﻿USE sofia;
DROP TABLE IF EXISTS sofia.hatbsa_vpl;
CREATE TABLE hatbsa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hatbsa_vpl WRITE;
INSERT INTO hatbsa_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nan kòmansman an Bondye te kreye syèl yo ak tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Latè te san fòm e vid, epi tenèb la te sou tout sifas fon an, e Lespri Bondye t ap ajite sou fas dlo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Alò Bondye te di: “Ke li gen limyè”. Epi te gen limyè. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Bondye te wè ke limyè a te bon. Bondye te separe limyè a avèk tenèb la. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Bondye te rele limyè a jou, e tenèb la, Li te rele li lannwit. Konsa, te gen aswè, ak maten, yon jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Alò Bondye te di: “Ke vin gen yon gran espas nan mitan dlo yo, e ke li separe dlo avèk dlo”. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bondye te fè gran espas la. Li te separe dlo ki te anba gran espas la, avèk dlo ki te anwo gran espas la. Se konsa sa te ye. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bondye te rele gran espas la syèl. Epi te gen aswè, e te gen maten, yon dezyèm jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Alò Bondye te di: “Ke dlo anba syèl yo vin rasanble nan yon plas, e ke tè sèch la vin parèt”. Konsa, sa te vin fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bondye te rele pati sèch la tè, ak dlo ki rasanble yo, lanmè. Epi Bondye te wè ke sa te bon. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Epi Bondye te di: “Ke latè a boujonnen avèk bagay vèt; plant ki donnen grenn selon espès pa yo, ak bwa k ap donnen fwi avèk grenn nan yo selon espès pa yo”. Konsa, sa te vin fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Latè te pwodwi bagay vèt, plant ki donnen grenn selon espès pa yo, ak pyebwa ki pwodwi fwi avèk grenn sou yo selon espès pa yo. Bondye te wè ke sa te bon. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Te gen aswè, ak maten, yon twazyèm jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Alò Bondye te di: “Ke vin gen limyè nan gran espas syèl yo pou separe jou avèk nwit lan, e ke yo vin kòm sign pou sezon yo, pou jou avèk lane yo; ");
INSERT INTO hatbsa_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ke yo vin sèvi pou limyè nan gran espas syèl yo pou bay limyè sou latè”. Konsa, sa te vin fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bondye te fè de gran limyè, pi gran an pou gouvène lajounen, e pi piti a pou gouvène lannwit. Anplis, Li te fè zetwal yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Bondye te plase yo nan gran espas syèl yo pou bay limyè sou latè, ");
INSERT INTO hatbsa_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","epi pou gouvène lajounen avèk lannwit, e pou separe limyè a avèk tenèb la. Bondye te wè ke sa te bon. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Te gen aswè, e te gen maten, yon katriyèm jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Alò Bondye te di: “Ke dlo yo vin ranpli avèk anpil kreyati vivan, e ke zwazo yo vole anwo tè a nan gran espas syèl yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bondye te kreye gwo bèt sovaj lanmè avèk tout kreyati vivan ki fè mouvman. Dlo yo te plen bèt selon espès pa yo, e chak zwazo selon espès pa l. Bondye te wè ke sa te bon. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bondye te beni yo. Li te di: “Fè pitit, e vin miltipliye. Ranpli dlo nan lanmè yo, e kite zwazo yo vin miltipliye sou tè a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Te gen aswè ak maten, yon senkyèm jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Alò, Bondye te di, “Ke tè a vin pwodwi kreyati vivan dapre espès pa yo; bèt domestik, reptil, avèk bèt latè selon espès yo”. Se konsa li te fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bondye te fè bèt latè yo selon espès yo, ak bèt gade yo dapre espès yo, tout bèt ki trennen atè dapre espès yo; epi Bondye te wè ke sa te bon. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Alò Bondye te di, “Annou fè lòm nan limaj Nou, menm jan ke Nou sanble a, e ke yo vin mèt sou tout pwason nan lanmè, sou zwazo yo nan syèl yo, sou bèt domestik nan chan yo, ak sou tout bèt reptil ki ranpe atè”. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bondye te kreye lòm, nan pwòp imaj pa Li, nan imaj Bondye Li te kreye li; mal avèk femèl Li te kreye yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Bondye te beni yo; Li te di yo, “Se pou nou vin fekon. Fè pitit pou ranpli latè, e domine sou li; se pou nou vin mèt sou pwason lanmè yo ak zwazo anlè yo, sou chak bèt vivan kab fè mouvman sou tè a”. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Alò Bondye te di, “Gade byen, Mwen bannou chak plant ki donnen grenn sou sifas tout tè a, ak chak bwa ki gen fwi avèk grenn li; li va sèvi kòm manje pou nou; ");
INSERT INTO hatbsa_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Epi a chak bèt latè ak chak zwazo syèl la, chak bagay k ap fè mouvman sou tè a, bagay ki gen lavi, Mwen te bay chak plant vèt pou manje”; epi se te konsa. ");
INSERT INTO hatbsa_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bondye te wè tout sa Li te kreye yo, e gade byen, sa te trè bon. Te gen aswè, ak maten, sizyèm jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Se te konsa syèl yo avèk tè a te fin fèt, avèk tout lame yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nan setyèm jou a, Bondye te fin fè travay ke Li te fè yo. Konsa, Li te repoze nan setyèm jou a sou tout travay ke Li te fè yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Epi Bondye te beni setyèm jou a. Li te fè li sen, akoz nan li, Li te repoze de tout travay kreyasyon an, ke Li te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Sa se listwa syèl yo avèk tè a lè yo te kreye, nan jou ke SENYÈ Bondye a te fè tè a avèk syèl la. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Alò potko gen ti bwa chan ki te parèt nan tè a, ni plant chan ki te boujonnen, paske Senyè Bondye a potko voye lapli sou tè a, e pa t gen moun pou kiltive tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Men yon vapè te konn leve sòti nan tè a pou wouze tout sifas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Alò Senyè Bondye a te fòme lòm sòti nan pousyè tè a. Li te respire souf lavi fè l vin antre nan nen l, e lòm te devni yon nanm vivan. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Senyè Bondye a te plante yon jaden nan pati lès Eden, e se la Li te mete lòm ke Li te fòme a. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Soti nan tè a, SENYÈ Bondye a te fè grandi chak ab ki bèl pou gade e ki bon pou manje. Avèk yo nan mitan jaden a te gen ab lavi a, ak ab konesans a sa ki bon ak sa ki mal la. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Alò, yon rivyè te sòti nan Eden pou wouze jaden an. Epi soti la, li te divize ou fè kat rivyè. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Premye rivyè a rele Pischon; li pase antoure tout peyi Havila, kote ki gen lò a. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Lò peyi sa a bon; wòch bdelyèm avèk onyx konn twouve la. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dezyèm rivyè a rele Guihon; li kouri antoure peyi Cush la. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Yo rele twazyèm rivyè Tigrès; li koule nan lès Assyrie. Epi katriyèm rivyè a se Euphrate. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Alò, Senyè Bondye a te pran lòm nan; Li te mete l nan jaden Eden pou kiltive li e pran swen li. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Senyè Bondye a te kòmande lòm nan. Li te di l: “Nan nenpòt sa nan jaden an, ou kapab manje, ");
INSERT INTO hatbsa_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","men sou ab konesans bon avèk mal la, ou pa pou manje li, paske nan jou ke ou manje li, ou va mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Alò, Senyè Bondye a te di: “Sa pa bon pou lòm nan rete sèl. Mwen va fè yon asistan jan li dwe genyen”. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Sòti nan tè a, Senyè Bondye a te fòme chak bèt chan ak chak zwazo syèl la, e Li te mennen yo kote lòm pou wè kòman li ta rele yo. Nenpòt jan li te rele yon kreyati vivan, sa te vin non li. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Lòm nan te bay non a tout bèt domestik yo, a tout zwazo syèl yo, e a chak bèt chan, men pou lòm nan, pa t gen yon asistan sanblab ak li. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Alò, Senyè Bondye a te fè yon Pwofon somèy pran lòm nan, e li te dòmi. Konsa, li te pran youn nan zo kòt li yo, e te fèmen chè a nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Senyè Bondye a te fòme yon fanm avèk kòt ke Li te pran nan lòm nan, e Li te pote li bay li. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Lòm nan te di: “Koulye a sa se zo a zo mwen, e chè a chè mwen. Li va rele fanm akoz li te retire nan lòm. ");
INSERT INTO hatbsa_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","“Pou rezon sila a, yon nonm va kite papa li avèk manman li, pou vin jwenn avèk madanm li, epi yo va vin tounen yon sèl chè.” ");
INSERT INTO hatbsa_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Epi lòm nan avèk fanm nan te toutouni, e yo pa t wont. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Alò, sèpan an te pi koken pase nenpòt bèt chan ke Bondye te fè. Li te di fanm nan: “Vrèman èske Bondye te di: ‘Pinga nou manje nan okenn ab nan jaden an?’” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Fanm nan te di a sèpan an: “Fwi ki sòti nan ab nan jaden yo, nou kapab manje yo; ");
INSERT INTO hatbsa_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","men nan fwi ki sòti nan ab ki nan mitan jaden an, Bondye te di: Nou pa pou manje nan li, ni touche li, sinon, nou va mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Sèpan an te di fanm nan: “Vrèman, nou p ap mouri!” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Paske Bondye konnen ke nan jou nou manje nan li, zye nou va vin louvri, e nou va vin tankou Bondye, avèk konesans de sa ki bon ak sa ki mal. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Lè fanm nan te wè ke pyebwa a te bon pou manje, ke li te yon plezi devan zye li, ke li te byen itil pou vin saj, alò li te pran nan fwi a pou li te manje; epi li te bay osi a mari li ansanm avèk li, pou li te manje. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Zye a toude te vin louvri, e yo te vin konnen ke yo te toutouni. Pou sa, yo te koud fèy pyebwa ansanm e yo te fè pou yo menm yon tabliye. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Yo te tande son a SENYÈ Bondye a ki t ap mache nan jaden an nan frechè jounen an, e lòm nan avèk fanm nan te kache tèt yo de prezans SENYÈ Bondye a pami bwa yo nan jaden an. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Alò, Senyè Bondye a te rele lòm nan, e te di l: “Kote ou ye?” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam te reponn: “Mwen te tande son Ou menm nan jaden an, e mwen te pè paske mwen te toutouni; alò mwen te kache tèt mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Epi Li te di li, kilès ki te di ou ke ou te toutouni? Èske ou te manje nan pyebwa e M te di ou pa manje a? ");
INSERT INTO hatbsa_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Lòm nan te di: “Fanm ke Ou te ban mwen an, li te ban m ladann, e mwen te manje.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Alò, Bondye te di a fanm nan: “Kisa ou te fè la a?” Epi fanm nan te di: “Sèpan an te twonpe mwen, e mwen te manje l.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","SENYÈ Bondye a te di a sèpan an: “Akoz ke ou te fè sa, ou modi pase tout bèt domestik yo, e plis ke tout bèt sovaj nan chan an. Sou vant ou ou va mache, e se pousyè ke ou va manje tout jou nan vi ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mwen va mete rayisman antre ou menm avèk fanm nan, e antre pitit ou ak pitit li. Li va kraze tèt ou, e ou va kraze talon li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A fanm nan Li te di: “Mwen va miltipliye anpil doulè ke ou va gen nan fè pitit; ak doulè ou va gen nan pouse pitit; malgre sa, dezi ou va pou mari ou, e li va domine sou ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Alò a Adam Li te di: “Akoz ou te koute vwa a fanm ou an, ou te manje nan ab ke Mwen te kòmande e te di Ou pa manje ladann nan, tè a ap modi akoz ou menm. Nan redi ou va manje ladann pou tout jou lavi ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Se pikan, se zepeng li va fè grandi pou ou; epi ou va manje plant chan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Avèk swè figi ou, ou va manje pen, jiskaske ou retounen nan tè a, paske ladann ou te sòti. Paske se pousyè ou ye, e se nan pousyè ou va retounen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Alò, lòm nan te rele fanm li an Eve, paske se li ki te manman a tout vivan yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","SENYÈ Bondye a te fè rad avèk po bèt pou Adam avèk madanm li, e Li te abiye yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Alò, SENYÈ Bondye a te di: “Gade byen, lòm nan gen tan vini tankou youn nan Nou, avèk konesans sa ki bon avèk sa ki mal. Koulye a, pou li pa lonje men l, pou pran osi nan ab lavi a, manje l e viv jis pou tout tan—” ");
INSERT INTO hatbsa_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Pou sa, SENYÈ Bondye a te voye l deyò jaden Eden nan, pou kiltive tè a, nan sila li te sòti a. ");
INSERT INTO hatbsa_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Alò, Li te pouse lòm nan deyò; epi nan lès jaden Eden nan, Li te estasyone cheriben an avèk nepe ak flanm ki te vire nan tout direksyon pou veye chemen vè ab lavi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Alò, lòm nan te vin nan relasyon avèk madanm li, Ève. Li te vin ansent e li te vin kouche fè Cain. Konsa, li te di: “Mwen gen tan fè yon ti nonm avèk èd SENYÈ a:” ");
INSERT INTO hatbsa_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ankò, li te bay nesans a frè li, Abel. Epi Abel se te yon bèje bann mouton, men Cain t ap laboure tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Li te vin rive pi devan ke Cain te pote yon ofrann bay SENYÈ a, ki sòti nan fwi rekòlt tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel, osi, sou pati pa l te pote nan premye pòtre twoupo, e nan pòsyon pi gra a nan yo. Konsa, SENYÈ a te kontan pou Abel avèk ofrann pa l la, ");
INSERT INTO hatbsa_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","men pou Cain, avèk ofrann pa li a, Li pa t kontan. Alò, Cain te vin byen fache, e figi li te vin ba. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Alò, SENYÈ a te di a Cain: “Poukisa ou fache konsa? Epi poukisa figi ou vin ba konsa? ");
INSERT INTO hatbsa_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si ou fè sa ki bon èske figi ou p ap leve ankò? Epi si ou pa fè sa ki bon, peche ap kouche devan papòt ou. Dezi li se pou ou, men ou oblije vin mèt li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cain te di frè l la, Abel, “An ale nan chan.” Epi li te vin rive ke pandan yo te nan chan an, Cain te leve kont Abel, frè l la, e li te touye li. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Alò, SENYÈ a te di a Cain: “Kote frè ou a, Abel?” Epi li te di: “Mwen pa konnen. Èske mwen se gadyen frè m nan?” ");
INSERT INTO hatbsa_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Li te di: “Kisa ou te fè la a? Vwa san a frè ou a ap rele ban Mwen sòti nan tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Koulye a ou modi, soti nan tè a, ki te ouvri bouch li pou resevwa san Abel nan men ou an. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Depi koulye a, lè ou kiltive tè a, li p ap bay ou fòs li ankò. Ou va vin yon vagabon k ap mache toupatou sou latè.” ");
INSERT INTO hatbsa_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Cain te di a SENYÈ a: “Pinisyon mwen an twò di pou m sipòte! ");
INSERT INTO hatbsa_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Byen gade! Jodi a ou gen tan pouse m kite sifas tè a. Konsa, fas ou p ap wè m; mwen va vin yon vagabon k ap plede mache toupatou sou latè, e nenpòt moun ki jwenn mwen va touye m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Alò, SENYÈ a te di li: “Pou sa, nenpòt moun ki touye Cain, vanjans va tonbe sou li sèt fwa plis.” Epi SENYÈ a te chwazi yon sign pou Cain, dekwa ke pèsòn ki jwenn li pa ta touye l. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Konsa, Cain te sòti de prezans SENYÈ a, e li te al rete sou tèren Nod nan pati lès Eden an. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain te antre an relasyon avèk madanm li. Li te vin ansent, e li te bay nesans a Hénoc; epi li te bati yon vil. Li te bay vil la non Hénoc, menm non ak fis li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Alò, Hénoc te fè Irad, e Irad te devni papa a Mehujaël, Mehujaël te vin papa a Metuschaël, e Metuschaël te vin papa a Lémec. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lémec te pran pou li de madanm: youn yo te rele Ada, e non a lòt la se te Tsilla. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada te bay nesans a Jabal. Li te papa a tout sila ki te rete nan tant yo, e ki te okipe bèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Frè li a te rele Jubal. Li te papa a tout sila ki te jwe ap avèk shaloumo yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Epi pou Tsilla, li te bay nesans a Tubal-Cain, yon bòs fòjewon ki fè zouti avèk bwonz ak fè. Sè a Tubal Cain an se te Naama. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lémec te di a madanm li yo: “Ada avèk Tsilla, koute vwa m. Nou menm ki madanm a Lémec yo; byen okipe pawòl mwen. Paske mwen te touye yon mesye akoz ke li blese m; e yon gason akoz li frape m. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si Cain vanje sèt fwa, alò Lémec swasann-dis-sèt fwa.” ");
INSERT INTO hatbsa_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam te antre an relasyon ankò avèk madanm li, epi li te bay nesans a yon fis. Li te rele li Seth, paske li te di “Bondye te chwazi ban mwen yon lòt fis nan plas Abel, paske Cain te touye li”. ");
INSERT INTO hatbsa_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Pou Seth, li menm, li te bay nesans a yon fis, epi li te rele non li Énosch. Nan lè sa a, lèzòm te kòmanse ap rele non SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Sa se liv jenerasyon Adan yo. Nan jou ke Bondye te kreye lòm, Li te fè l nan imaj Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Li te kreye yo mal avèk femèl. Li te beni yo, e Li te rele yo Lòm. Sa vle di “Adam” nan jou ke yo te kreye a. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Lè Adam te gen tan fin viv san-trant ane, li te vin papa a yon fis ki sanble nèt ak li, nan pwòp imaj pa l. Li te rele li Seth. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Laj a Adam, lè l te fin fè Seth, se te uit-san ane, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Paske tout jou ke Adam te viv yo te nèf-san-trant ane. Konsa, li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth te viv san-senkant ane, e li te vin papa Énosch. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Alò, Seth te viv uit-san-sèt ane apre li te vin papa Énosch, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Paske tout jou a Seth yo te nèf-san-douz ane, e li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Énosch te viv katre-ven-dis ane, e li te vin papa a Kénan. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Epi Énosch te viv uit-san-kenz ane apre li te vin papa a Kénan, e li te fè lòt fis ak lòt fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Alò, tout jou a Énosch yo te nèf-san-senk ane, e li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kénan te viv pandan swasann-dis ane, e li te vin papa a Mahalaléel. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Epi Kénan te viv uit-san-karant ane lè li te fin fè Mahalaléel, e li te gen lòt fis ak lòt fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Alò, tout jou a Kénan yo te nèf-san-dis ane, e li te mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaléel te viv swasant senk ane, e li te vin papa Jred. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Epi Mahalaléel te viv ui-san-trant ane apre li te vin papa Jred, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Alò, tout jou a Mahalaléel yo te ui-san-katre-ven-kenz ane, e li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jred te viv san-swasann-de ane, e li te vin papa Hénoc. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Alò, Jred te viv ui-san ane apre li te vin papa Hénoc, e li te gen lòt fis ak lòt fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Paske, tout jou a Jred yo te nèf-san-swasann-de ane, e li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hénoc te viv swasann-senk ane, e li te vin papa Methuschélah. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Alò, Hénoc te mache ansanm avèk Bondye pandan twa san ane apre li te vin papa a Methuschélah, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Paske tout jou Hénoc yo te twa-san-swasant-senk ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hénoc te mache avèk Bondye; e li pa t la ankò, paske Bondye te pran l. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuschélah te viv pandan san-katre-ven-sèt ane, e li te vin papa a Lémec. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Alò Methuschélah te viv sèt san katreven de ane apre li te vin papa a Lémec, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Jou Methuschélah yo te nèf-san-swasant nèf ane, e li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lémec te viv san-katre-ven-de ane, e li te vin papa a yon fis. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Alò, li te rele non li Noé, e li te di: “Sila a va bannou repo sou travay di nou fè ak men nou ki leve sòti nan tè ke SENYÈ a te modi a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Alò, Lémec te viv senk-san-katre-ven-kenz ane apre li te vin fè Noé, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Paske tout jou a Lémec yo te sèt-san-swasann-dis-sèt ane, e li te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé te gen laj senk-san ane, e li te vin papa a Sem, Cham, ak Japhet. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Alò, li te rive ke lè lèzòm te kòmanse miltipliye sou sifas tè a, e yo te fè pitit fi, ");
INSERT INTO hatbsa_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","ke fis Bondye yo te wè ke fi lèzòm yo te bèl. Konsa, yo te pran kòm madanm pou yo menm, nenpòt ke yo te chwazi. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Alò SENYÈ a te di: “Lespri Mwen p ap lite avèk lòm pou janmè, paske li menm osi se chè. Konsa, jou li yo va san-ven-ane.” ");
INSERT INTO hatbsa_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Jeyan yo te sou latè nan jou sa yo, e menm aprè, lè fis Bondye yo te antre nan pitit fi a lòm yo, e te fè pitit avèk yo. Sila yo se te lòm pwisan de tan ansyen yo, lòm gran repitasyon yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Alò SENYÈ a te wè ke mechanste lòm te gran sou latè, epi ke chak entansyon ak panse nan kè li te toujou vè lemal. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Epi SENYÈ a te regrèt ke Li te fè lòm sou latè a, e sa te blese Li nan kè L. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","SENYÈ a te di: “Mwen va efase lòm ke mwen te kreye sou fas tè a, soti nan lòm jis nan tout bèt yo, ak a zwazo anlè yo. Paske mwen regrèt ke m te fè yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Men Noé te twouve favè nan zye SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Sa yo se achiv jenerasyon Noé yo. Noé se te yon moun ak ladwati, san fot nan tan pa li a. Noé te mache avèk Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé te vin papa twa fis: Sem, Cham, ak Japhet. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Alò tè a te vin konwonpi nan zye Bondye, e latè te vin plen ak vyolans. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Bondye te gade sou latè, e gade byen, li te vin konwonpi; paske tout chè te vin konwonpi sou tè a nan jan yo te mache. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Alò, Bondye te di a Noé: “Lafen tout chè gen tan parèt devan M; paske latè vin ranpli avèk vyolans akoz yo menm. Gade byen, mwen prè pou detwi yo ansanm ak latè. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fè pou kont ou yon lach avèk bwa gofè. Ou va fè l avèk chanm, e kouvri li anndan kon deyò avèk kòl rezin. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Se konsa ke ou va fè l: longè lach la va twa san koude (18 pous se yon koude), lajè li va senkant koude, e wotè li va trant koude. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ou va fè yon fenèt pou lach la, fè l rive yon koude mwens ke wotè li. Konsa, plase pòt lach la rive sou de kote li yo. Fè li ak pi ba, dezyèm, avèk twazyèm etaj. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Gade byen, Mwen menm, Mwen ap mennen delij dlo sou latè pou detwi tout chè ki gen souf lavi ladann, depi anba syèl la. Tout bagay ki sou latè va peri. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“Men Mwen va etabli akò Mwen avèk ou. Konsa, ou va antre nan lach la—ou menm avèk fis ou yo, avèk madanm ou yo, madanm a fis ou yo ansanm avèk ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","“Epi soti nan tout chè de tout kalite bèt k ap viv, ou va pote de nan chak espès pou antre nan lach la, pou kenbe yo vivan ak nou. Konsa, yo va mal avèk femèl. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","“Nan zwazo yo selon espès pa yo, nan bèt yo selon espès pa yo, chak sa ki kouri atè reptil selon espès pa l. De nan chak espès va vin kote ou, pou ou ka kenbe yo toujou vivan. ");
INSERT INTO hatbsa_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Pou ou menm, pran pou pwòp tèt ou kèk nan tout bagay ki kab manje, e rasanble yo pou ou menm. Yo va sèvi pou ou kòm manje pou ou, ak pou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Konsa Noé te fè l. Selon tout sa ke Bondye te kòmande li, se konsa li te fè l. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Konsa, SENYÈ a te di a Noé: “Antre nan lach la, ou avèk tout lakay ou, paske se ou sèl mwen te wè ki dwat devan mwen nan jenerasyon sila a. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ou va pran avèk ou sèt nan chak bèt ki pwòp, yon mal avèk yon femèl parèy li. Nan bèt ki pa pwòp yo, yon mal avèk yon femèl parèy li. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Anplis, nan zwazo nan syèl la pa sèt, mal avèk femèl, pou kenbe pòtre yo vivan sou tout sifas tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Paske, apre sèt jou ankò, Mwen va voye lapli sou latè pandan karant jou ak karant nwit. Konsa, Mwen va efase sou fas tè a chak èt vivan ke Mwen te fè.” ");
INSERT INTO hatbsa_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé te fè tout bagay jan ke Bondye te mande l la. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Alò, Noé te gen laj sis-san ane lè delij la te vini sou latè. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé avèk fis li yo, avèk madanm li, avèk madanm a fis li yo, avèk li menm te antre nan lach la akoz dlo delij la. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Nan bèt ki te pwòp yo, avèk bèt ki pa pwòp yo, zwazo avèk tout sa ki kouri atè yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","tout te antre nan lach la ak Noé, de pa de, mal avèk femèl, jan Bondye te kòmande Noé a. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Li te rive apre sèt jou ke dlo delij la te vini sou latè. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nan sis-santyèm ane nan lavi Noé, nan dezyèm mwa, nan di-setyèm jou nan mwa a, nan menm jou a, tout sous nan gran fon an te vin pete, e pòt delij yo nan syèl la te vin louvri. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Lapli te tonbe sou latè pandan karant jou, ak karant nwit. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","O jis nan menm jou sa a, Noé avèk Sem, Cham, avèk Japhet, fis a Noé yo, madanm a Noé, ak twa madanm a fis li yo, te antre nan lach la, ");
INSERT INTO hatbsa_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","yo menm avèk chak bèt selon espès yo, tout bèt domestik selon espès pa yo, tout reptil ki kouri atè selon espès pa yo, ak tout kalite zwazo. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Epi yo te antre nan lach la vè Noé, pa de nan tout chè ki te gen souf lavi. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Sila ki te antre yo, mal avèk femèl nan tout chè, te antre jan Bondye te kòmande li a; epi SENYÈ a te fèmen lach la dèyè li. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Konsa delij la te vini sou latè a pandan karant jou. Dlo a te vin ogmante e te leve lach la jis li rive anwo tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dlo a te monte. Li te ogmante anpil sou tè a, e lach la te monte sou dlo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Dlo a te vin monte plis toujou sou tè a, jis tout mòn toupatou anba syèl la te vin kouvri. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dlo a te vin monte pou kenz koude anplis, e mòn yo te vin kouvri. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tout chè ki t ap fè mouvman sou tè a te vin peri, zwazo avèk bèt domestik avèk bèt sovaj, e chak ensèk ki vole ansanm sou latè, ak tout moun. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tout sa ki te sou tè sèk la, ki te gen souf lavi nan nen yo te vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Konsa Li te efase chak bagay ki t ap viv sou fas tè a, soti nan lòm jis rive nan tout bèt, sou sa ki te kouri atè, ak zwazo latè yo. Konsa yo te efase soti sou tè a nèt, e se sèl Noé ki te rete ansanm avèk sila ki te avèk li nan lach la. ");
INSERT INTO hatbsa_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Dlo a te monte kouvri tout tè a pandan san-senkant jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","E Bondye te sonje Noé avèk tout bèt ki te avèk li nan lach la. Konsa, Bondye te fè yon van pase sou tè a, e dlo yo te vin bese. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Sous nan fon yo te vin fèmen. Pòtay lapli nan syèl la te fèmen, e lapli ki te sòti nan syèl la te sispann. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Dlo a te bese ofiramezi sou tè a. E apre san-senkant jou, dlo a te vin mwens. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Nan setyèm mwa, nan dis-setyèm jou nan mwa a, lach la te vin poze sou mòn Ararat la. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dlo a te bese toujou jis nan dizyèm mwa a. Nan dizyèm mwa, nan premye jou mwa a, tèt mòn yo te vin vizib. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Alò, li te vin rive ke lè karant jou yo fin pase, Noé te ouvri fenèt lach la, ke li te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Konsa, li te voye deyò yon kònèy zwazo nwa ki te vole de yon kote a lòt jiskaske dlo a te vin seche sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Epi li te voye deyò yon toutrèl sòti kote li, pou wè si dlo a te bese sou fas tè a, ");
INSERT INTO hatbsa_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","men toutrèl la pa t jwenn plas repo pou plante pye li, e li te retounen kote li nan lach la, paske dlo a te sou fas tout tè a. Alò, li te lonje men l deyò, li te pran l, e li te fè l antre nan lach la vè li menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Li te tann pou yon lòt sèt jou ankò, e li te revoye toutrèl la soti nan lach la. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Toutrèl la te vin kote l vè aswè, e gade byen, nan bèk li te gen yon fèy bwa doliv byen fre. Konsa Noé te konnen ke dlo a te bese sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Alò, li te tann pou yon lòt sèt jou. Li te revoye toutrèl la, e li pa t retounen kote li ankò. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Alò, li te vin rive ke nan sis-san-en ane, nan premye mwa, dlo a te fin seche kite tè a. Konsa, Noé te retire kouvèti lach la. Li te gade, e gade byen, sifas tè a te vin sèch. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nan dezyèm mwa, nan venn-sèt jou nan mwa a, tè a te sèch. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Alò, Bondye te pale avèk Noé. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Sòti nan lach la, ou menm avèk madanm ou, fis ou yo, avèk madanm a fis ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mete deyò avèk ou tout chè vivan ki avèk ou, zwazo, animal, ak tout bèt sila yo ki kouri atè, pou yo kapab kouple anpil sou latè, pou vin fekon, e miltipliye anpil sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Alò, Noé te sòti, ak fis li yo avèk madanm li, e madanm a fis li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Chak bèt, chak reptil ki kouri atè, e chak zwazo, tout bagay ki fè mouvman sou latè yo, te sòti nan lach la selon espès pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Konsa, Noé te bati yon lotèl pou SENYÈ a. Li te pran chak bèt ki pwòp, ak chak zwazo ki pwòp, e li te ofri sakrifis ki te brile sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","SENYÈ a te pran sant dous la. Konsa, SENYÈ a te di a Li menm: “Mwen p ap janm modi tè a ankò akoz lòm, paske lentansyon kè li se lemal depi li te jèn. Ni mwen p ap janm detwi ankò chak bagay vivan jan Mwen te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Pandan tè a la a, lè semans avèk rekòlt, fredi avèk chalè, sezon chalè ak livè, lajounen avèk lannwit p ap janm sispann.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Konsa, Bondye te beni Noé avèk fis li yo. Li te di yo: “Se pou nou vin fekon, miltipliye, e ranpli latè. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Lakrent nou, ak laperèz nou va vini sou chak bèt latè, ak chak zwazo syèl la. Tout bagay ki kouri atè, ak tout pwason lanmè, tout livre nan men nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Chak bagay ki fè mouvman e ki vivan va sèvi kòm manje pou nou. Mwen bannou tout, jan Mwen te bay plant vèt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Sèlman, nou pa pou manje chè avèk lavi li, sa vle di san li. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Anverite, Mwen va egzije san lavi a paske se pa m. Menm soti nan chak bèt Mwen va egzije li. Epi sou chak òm, sou frè a chak òm, Mwen va egzije lavi a yon moun. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Nenpòt moun ki vèse san lòm, pa lòm san pa l va vèse, paske nan imaj a Bondye, Li te fè lòm. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Epi pou nou, se pou nou vin fekon, e miltipliye. Peple tè a anpil, e miltipliye ladann.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Alò, Bondye te pale avèk Noé ak fis li yo avè l. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Gade byen, Mwen menm, Mwen vin etabli akò Mwen avèk nou, e avèk desandan aprè nou yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","epi avèk chak kreyati vivan ki avè w: zwazo, bèt kay yo, ak chak bèt ki sou latè avèk nou, tout sa ki sòti nan lach la, menm chak bèt sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","“Mwen etabli akò Mwen avèk nou: Tout chè p ap janm koupe ankò pa dlo delij, ni p ap gen delij ankò pou detwi tè a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Bondye te di: “Sa se sign akò ke m ap fè antre Mwen avèk nou, e avèk chak kreyati vivan ki la avèk nou, jis rive pou tout jenerasyon k ap vini yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mwen mete lakansyèl Mwen nan nwaj la, epi l ap sèvi kòm yon sign pou akò antre Mwen menm avèk latè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Li va rive ke lè m mennen yon nwaj sou latè, ke lakansyèl la ap vizib nan nwaj la, ");
INSERT INTO hatbsa_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","epi Mwen va sonje akò ki antre Mwen menm avèk nou an, avèk chak kreyati vivan de tout chè. Epi janmen ankò dlo p ap vin yon delij pou detwi tout chè. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","“Lè lakansyèl la nan nwaj la, Mwen va gade sou li, pou m sonje akò ki jis pou tout tan antre Bondye ak tout kreyati vivan pou tout chè ki sou latè yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Epi Bondye te di a Noé: “Sa se sign akò ke Mwen te etabli antre Mwen ak tout chè ki rete sou tè a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Alò, fis Noé yo ki te soti nan lach la se te Sem, Cham, ak Japhet. Epi Cham te papa Canaan. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Twa sila yo se te fis Noé yo, e nan twa sila yo tout tè a te vin peple. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Alò, Noé te kòmanse kiltive tè a. Li te plante yon chan rezen. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Li te bwè diven, e li te vin sou. Konsa li te dekouvri kò li anndan tant li an. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham, papa Canaan nan, te wè papa li toutouni, e li te pale sa a frè l yo deyò a. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Men Sem avèk Japhet te pran yon abiman, yo te mete li sou chak zepòl li, e yo te mache an aryè pou kouvri nidite papa yo. Figi yo te vire akote pou yo pa wè nidite li. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Lè Noé te leve nan dòmi aprè diven an, li te konnen sa ke pi jenn fis li a te fè l la. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Konsa li te di: “ Canaan se modi. Se sèvitè l ap ye anvè frè li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Li te di osi: “Beni se SENYÈ a, Bondye a Cham nan. Canaan va sèvitè li. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ke Bondye agrandi Japhet. Kite li viv nan tant Sem yo. Kite Canaan vin sèvitè li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé te viv twa-san-senkant ane aprè delij la. ");
INSERT INTO hatbsa_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Alò, tout jou a Noé yo te nèf-san-senkant ane, e li te mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Alò, sa yo se achiv a jenerasyon yo pou Cham, Sem, ak Japhet, fis Noé yo. Fis te ne pou yo apre delij la. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Fis a Japhet yo te Gomer, Magog, Madaï, Javan, Tubal, Méschec, ak Tiras. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Fis Gomer yo te Aschkenaz, Riphat avèk Togarma. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Fis Javan yo te Elischa, Tarsis, Kittim, ak Dodanim. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Depi nasyon sila a peyi kot yo te divize nan tèritwa pa yo, yo chak selon langaj yo, selon fanmi pa yo, nan pwòp nasyon pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Fis a Cham yo te Cush, Mitsraïm, Puth, avèk Canaan. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Fis a Cush yo te Saba, Havila, Saba, Raema avèk Sabteca. Fis a Raema yo te Séba avèk Dedan. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush te fè osi Nimrod. Li te kòmanse vin pwisan sou latè. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Li te yon nonm fò nan fè lachas devan SENYÈ a. Akoz sa yo abitye di: “tankou Nimrod, yon nonm fò nan lachas devan SENYÈ a”. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Kòmansman wayòm li an te Babel, Érec, Accad, avèk Cainé nan peyi a Schinear yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De tèritwa sila a, li te antre nan Assur, e li te bati Ninive avèk Rehoboth-Hur, Calach, ");
INSERT INTO hatbsa_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Avèk Résen antre Ninive e Calach, ki se gran vil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitsraïm te devni papa Ludim, Anamim, Lehabim ak Naphtuhim. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Avèk Patrusim ak Casluhim (kote Filisten yo te sòti a) avèk Caphtorim. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan te vin papa Sidon ki te premye ne a, avèk Heth; ");
INSERT INTO hatbsa_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","epi Jebizyen yo avèk Amoreyen yo, ak Gigazyen yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Evyen yo, Akyen yo, avèk Sinyen yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","avèk Avadyen yo, Tsemaryen yo, Amatyen yo, e apre, fanmi Canaran an te gaye toupatou. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tèritwa Canaan an te sòti depi Sidon pou pwoche Guérar, jis rive Gaza, kote lè nou pwoche Sodome ak Gomorrhe, avèk Adma ak Tseboïm jis Léscha. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sa yo se fis Cham yo selon fanmi pa yo, selon langaj yo, selon tèritwa yo, selon nasyon pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Osi a Sem, papa a tout pitit Héber yo, e pi gran frè pou Japhet te fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Fis a Sem yo te Élam, Assur, Arpacschad, Lud, avèk Aram. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Fis Aram yo te Uts, Hul, Guéter avèk Masch. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpacschad te fè Schélach, epi Schélach te fè Héber. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Konsa, te ne a Héber de fis: non a youn te Péleg, paske nan jou pa l la latè te divize. Epi frè l la te rele Jokthan. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokthan te vin papa Almonad ak Schéleph, Hatsarmaveth, Jrach, ");
INSERT INTO hatbsa_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO hatbsa_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimaël, Séba, ");
INSERT INTO hatbsa_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havila ak Jbab. Tout sa yo te fis pou Jokthan. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Alò andwa kote yo te rete te rive jis nan Méscha lè nou ale vè Sephar, tèritwa mòn lès la. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Men sila ki se fis Sem yo, selon fanmi pa yo, selon langaj yo, selon tèritwa yo, selon nasyon yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Sila yo se fanmi a fis Noé yo selon jenerasyon yo, selon nasyon pa yo. Konsa, depi nan sa yo, nasyon yo te separe sou latè apre delij la. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Alò, tout latè te sèvi avèk menm lang avèk menm mo. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Konsa, li te rive ke pandan yo t ap vwayaje vè lès, ke yo te twouve yon gran plèn nan peyi ki rele Schinear, e yo te vin rete la. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Yo te di youn ak lòt: “Vini, annou fè brik e brile yo byen brile.” Epi yo te sèvi ak brik pou wòch, e yo te sèvi ak azfòt kòm mòtye. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Yo te di: “Vini, annou bati yon gran vil pou pwòp tèt nou, avèk yon kay wo tou won avèk yon twati ki va lonje rive jis nan syèl la. Konsa, annou fè pou pwòp tèt nou yon gran non, sof ke sa, nou va vin gaye toupatou sou tout sifas tè a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","SENYÈ a te vin desann pou wè gran vil avèk kay wo tou won ke fis a lòm yo te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Senyè a te di: “Gade byen, se yon sèl pèp yo ye, e yo tout gen menm lang, epi men sa ke yo kòmanse fè. Konsa, nenpòt sa yo eseye fè, yo p ap anpeche. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Vini, annou desann e konfonn langaj yo pou yo pa konprann lang youn lòt.” ");
INSERT INTO hatbsa_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Pou sa, SENYÈ a te gaye yo toupatou sou tout tè a, e yo te sispann bati gran vil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Pou koz sa a, yo te rele non vil la Babel, akoz ke se la, SENYÈ a te konfonn langaj yo nan tout latè. Depi la, SENYÈ a te gaye yo toupatou sou sifas a tout tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sa yo se te achiv pou tout jenerasyon a Sem yo. Sem te gen laj santan, lè l te vin papa a Arpacschad, dez ane apre delij la. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Epi Sem te viv senk-santan dèzane apre li te vin papa a Arpacschad. Li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpacschad te viv trann-senk ane, lè l te vin papa a Schélach. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Konsa, Arpacschad te viv kat-san-twa lane apre li te vin papa a Schélach, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Schélach te viv trantan, e li te vin papa a Héber; ");
INSERT INTO hatbsa_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","epi Schélach te viv kat-san-twa-lane apre li te vin papa a Héber. Li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Héber te viv pandan trann-kat ane, lè l te devni papa a Péleg; ");
INSERT INTO hatbsa_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","epi konsa, Héber te viv pandan kat-san-trant ane apre li te vin papa a Péleg, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg te viv pandan trant ane, lè l te vin papa a Reu. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Konsa, Péleg te viv pandan de-san-nèf ane apre li te vin papa a Rehu, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu te viv pandan trann-de ane, lè l te vin papa a Serug. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu te viv pandan de-san-sèt ane apre li te vin papa a Serug, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug te viv pandan trant ane lè l te vin papa a Nachor. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Epi Serug te viv de-san ane apre li te vin papa a Nachor, e li te fè lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nachor te viv pandan vent-nèf ane, e li te vin papa a Térach; ");
INSERT INTO hatbsa_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","epi Nachor te viv san-diz-nèf ane apre li te vin papa a Térach, e li te gen lòt fis ak fi. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térach te viv swasann-dis ane, e li te vin papa a Abram, Nachor, ak Haran. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Alò sa yo se achiv pou tout jenerasyon a Térach yo. Térach te vin papa Abram, Nachor, avèk Haran. Haran te fè Lot. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran te mouri nan prezans papa li, Térach nan peyi nesans li, nan Ur pou Kaldeyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram avèk Nachor te pran madanm yo pou yo menm. Non a madanm Abram nan se te Saraï, e non a madanm Nachor a se te Milca, fi a Haran an, papa a Milcah avèk Jisca. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraï te esteril. Li pa t fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térach te pran Abram, fis li a, e Lot, fis Haran an, pitit a pitit li, ak Saraï, bèlfi li, madanm a Abram, fis li. Konsa, yo te kite Ur a Kaldeyen yo ansanm, pou yo ta kapab antre nan peyi Canaan an. Yo te ale jis rive Haran, e yo te rete la. ");
INSERT INTO hatbsa_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Jou a Térach yo te de-san-senk ane. Térach te vin mouri Haran. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Alò, SENYÈ a te di a Abram: “Sòti nan peyi ou ak fanmi ou yo, ak lakay papa ou, pou ale vè yon peyi ke Mwen va montre nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mwen va fè ou vin yon gran nasyon. Mwen va beni ou, e fè non ou vin gran. Ou va yon benediksyon. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mwen va beni sila yo ki beni ou, e sila ki modi ou yo, Mwen va modi yo. Konsa, nan ou, tout fanmi sou latè yo va beni.” ");
INSERT INTO hatbsa_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Alò, Abram te sòti jan SENYÈ a te pale l la. Lot te ale avè l. Abram te gen laj swasann-kenz ane lè li te kite Haran. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram te pran Saraï madanm li avèk Lot, neve li, ak tout zafè yo ke yo te ranmase avèk moun ke yo te vin genyen nan Haran, e yo te pati pou peyi Canaan an. Konsa yo te rive Canaan. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram te pase nan peyi a jis rive Sichem, nan chenn Moré yo. Alò nan tan sa a, Kanaaneyen yo te nan peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","SENYÈ a te parèt a Abram. Li te di: “A desandan ou yo, Mwen va bay peyi sila a.” Alò, li te bati yon lotèl nan plas kote SENYÈ a te parèt a li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Alò, li te kontinye depi la nan mòn nan, nan lès Béthel. Li te monte tant li, avèk Béthel nan lwès, ak Aï nan lès. La li te bati yon lotèl a SENYÈ a, e li te rele non a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram te vwayaje toujou vè Negev. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Alò te gen yon gwo grangou nan peyi a, ki fè Abram desann an Égypte pou pase yon tan, akoz gwo grangou a te tèlman di nan peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Li te rive ke lè li te rive toupre Égypte, li te di a Saraï, madanm li: “Gade, mwen konnen ke ou se yon fanm ki tèlman bèl! ");
INSERT INTO hatbsa_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Lè Ejipsyen yo wè ou, yo va di: ‘Sa se madanm li.’ Konsa, yo va touye mwen, men yo va kite ou viv. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Souple, di ke se sè mwen ou ye, pou sa ale byen pou mwen, e pou mwen kapab viv akoz ou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Li te vin rive ke lè Abram te antre Égypte, ke Ejipsyen yo te wè ke fanm nan te byen bèl. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ofisyèl Farawon yo te wè li e te pote lwanj li bay Farawon. Konsa, yo te pran fanm nan fè l antre lakay Farawon an. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pou sa li te trete Abram byen pou koz li. Li te bay li mouton avèk bèf kabwa avèk bourik, ak sèvitè, ni mal ni femèl, ak femèl bourik avèk chamo. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Men SENYÈ a te frape Farawon avèk gwo malè yo akoz Saraï, madanm Abram nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Epi Farawon te rele Abram. Li te di li: “Kisa ou fè m la a? Poukisa ou pa t di mwen ke li te madanm ou? ");
INSERT INTO hatbsa_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Poukisa ou te di: Li se sè m, pou m te pran l kòm madanm mwen? Alò, men madanm ou, pran l ale.” ");
INSERT INTO hatbsa_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farawon te kòmande mesye pa l yo konsènan li, epi yo te akonpanye l ale, avèk madanm li, ak tout bagay ki te pou li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Alò, Abram te monte kite Égypte vè Negev, li menm avèk madanm li, ak tout bagay ki te pou li, e Lot te avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Epi Abram te trè rich nan bèt, lajan ak nan lò. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Li te fè vwayaj li yo ki sòti Negev pou rive jis Béthel, nan plas kote tant li a te ye nan kòmansman an, antre Béthel avèk Ai, ");
INSERT INTO hatbsa_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","jis rive nan plas lotèl ke li te fè la oparavan an. Epi la Abram te rele non SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Alò, Lot, ki te ale avèk Abram, osi te gen bann mouton, twoupo, avèk tant. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Epi tè a pa t kapab sipòte yo toude pou rete ansanm, paske byen yo te tèlman gran ke yo pa t kab rete ansanm. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Epi te gen konfli antre bèje bèt Abram, ak bèje bèt Lot yo. Epi te gen Kanaaneyen yo avèk Ferezyen yo ki te rete nan peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Alò, Abram te di a Lot: “Silvouplè, pa kite gen konfli antre ou avèk mwen, ni antre bèje pa m ak bèje pa w, paske se frè nou ye. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Èske se pa tout tè a ki pou ou? Silvouplè, annou separe. Si se vè agoch, mwen menm, mwen va ale adwat. Oswa si se adwat, mwen menm, mwen va ale agoch.” ");
INSERT INTO hatbsa_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot te leve zye li, e li te wè tout vale Jourdain an ke li te byen wouze. Sa se te avan SENYÈ a te detwi Sodome avèk Gomorrhe. Li te tankou jaden SENYÈ a, tankou peyi Égypte la lè ou ale vè Zoar. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Konsa, Lot te chwazi pou li menm tout vale Jourdain an, e Lot te vwayaje vè lès. Konsa yo te separe youn ak lòt. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram te vin rete nan tè Canaan an, pandan Lot te vin rete nan gran vil yo nan vale a, e li te deplase tant li yo jis rive Sodome. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Alò, mesye Sodome yo te mechan anpil, e yo te fè peche depase kont SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","SENYÈ a te di a Abram lè Lot fin kite l la: “Koulye a leve zye ou pou gade depi plas la kote ou ye a; vè nò, vè sid, vè lès ak lwès. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Paske tout peyi ke ou wè a, Mwen va ba ou li, ak desandan ou yo pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","“Mwen va fè desandan ou yo peple tankou pousyè tè, pou si okenn moun pa kapab kontwole pousyè tè a, konsa yo p ap kapab osi kontwole desandan ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Leve, mache toupatou nan peyi a nan longè li avèk lajè li; paske Mwen va ba ou li”. ");
INSERT INTO hatbsa_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Epi Abram te deplase tant li an, li te vin rete akote bwatchenn Mamré yo ki an Hébron, e la li te bati yon lotèl bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Li te rive nan jou Amraphel yo, wa Schinear a, ke Arjoc, wa Ellasar a, Kedorlaomer, wa Élam nan, avèk Tideal, wa Gojim nan, ");
INSERT INTO hatbsa_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ke yo te vin fè lagè avèk Béra, wa Sodome nan, e avèk Birscha, wa Gomorrhe a, Schineab, wa Adma a, ak Schémbeébern wa Tseboïm nan, avèk wa a Béla a, ki se Tsoar. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tout sila yo te vini nan yon alyans nan vale Siddim nan (sa vle di Lanmè Sèl la). ");
INSERT INTO hatbsa_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Pandan douz ane yo te sèvi Kedorlaomer, men nan trèzyèm ane a, yo te revòlte. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Nan katòzyèm ane a, Kedorlaomer ak wa ki te avè l yo, te vin bat Rephaïm nan Ashterothkarnaim, Zuzim lan nan Ham, avèk Émim nan Schavé-Kirjathaïm. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Avèk Oryen yo nan mòn pa yo nan Séir jiska distans rive nan Al-Paran, ki touprè dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Epi yo vin retounen rive nan En-Mischpath, (ki se Kadès), e yo te bat Amalesit yo nan tout peyi yo, e osi Amoreyen ki te rete Hatsatson-Thamar yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Epi wa Sodome nan avèk wa Gomorrhe a avèk wa Adma ak wa Tseboïm nan, e wa Béla a, (ki se Tsoar); te vin parèt. Yo ranje yo pou fè batay kont yo nan vale Siddim nan, ");
INSERT INTO hatbsa_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kont Kedorlaomer wa Élam nan, Tideal, wa Gojim nan, Amraphel, wa Schinear nan, ak Arjoc, wa Ellasar a; kat wa kont senk. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Alò, vale Siddim nan te ranpli avèk fon azfòt yo, epi wa Sodome avèk Gomorrhe yo te sove ale, e kèk tonbe la. Men sila ki te chape yo te sove ale, rive nan tèt mòn yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Yo te pran tout byen Sodome avèk Gomorrhe yo avèk tout manje yo te genyen, e yo te pati. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Anplis, yo te pran Lot, neve a Abram nan avèk tout byen li, e yo te pati, paske li t ap viv Sodome. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Alò, yon moun ki te sove ale te vin di Abram, Ebre a, tout sa. Alò, li t ap viv bò kote chenn Mamré yo, Amoreyen sila a, frè Eschcol e frè Aner, ki te fè yon alyans avèk Abram. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Lè Abram te tande ke moun fanmi li te pran an kaptivite, li te Mennen dèzòm ki te enstwi, twa-san-diz-uit òm ki te elve nan kay li pou te pouswiv yo jis rive nan Dan. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Li te divize ekip li yo kont yo nan lannwit. Epi li avèk sèvitè li yo te bat yo, e yo te kouri dèyè yo jis rive Choba, ki nan nò Damas la. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Li te mennen fè retounen tout byen yo. Anplis, li te mennen tounen moun fanmi li an, Lot, avèk byen pa l, fanm, avèk lòt moun yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Apre Abram te sòti nan masak Kédorlaomer ak wa ki te avè l yo, wa Sodome nan te sòti pou rankontre l nan vale Schavé a, (sa vle di Vale a Wa a). ");
INSERT INTO hatbsa_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Konsa, Melchisédek, wa Salèm nan te mennen pote pen avèk diven. Alò li menm se te yon prèt a Bondye Pi Wo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Li te beni li, e te di: “Beni, se Abram a Bondye Pi Wo a, Mèt Syèl la ak tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Beniswa Bondye Pi Wo a, ki te lage lènmi yo nan men ou.” Abram te bay li yon dim de tout bagay. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Wa Sodome nan te di Abram: “Ban mwen moun yo, e ou mèt pran byen yo pou ou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram te di a Wa Sodome nan: “Mwen te sèmante a Senyè Bondye Pi Wo a, Mèt sou syèl la avèk tè a, ");
INSERT INTO hatbsa_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ke mwen p ap pran menm yon fisèl oswa yon sandal, ni yon las, ni anyen ki pou ou, akoz laperèz ke ou ta di ‘se ou ki fè Abram vin rich’. ");
INSERT INTO hatbsa_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mwen p ap pran anyen sof ke sa ke jennonm yo te manje, ak pòsyon pou mesye ki te ale avè m yo, Aner, Eschcol, avèk Mamré; kite yo pran pòsyon pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Apre bagay sa yo, pawòl SENYÈ a te vin kote Abram nan yon vizyon. Li te di: “Pa pè, Abram, Mwen se yon pwotèj pou ou. Rekonpans ou va gran.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram te di: “O Senyè BONDYE, kisa ou va ban mwen, akoz ke m san pitit, e eritye lakay mwen se Eliézer a Danmas?” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Epi Abram te di: “Akoz ke ou pa t ban m pitit pou swiv mwen, pitit ki fèt nan kay mwen an se eritye mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Alò, gade byen, pawòl SENYÈ a te vin kote li. Li te di l: “Se pa nonm sa k ap eritye ou, men youn ki va sòti nan pwòp kò ou, se li ki va eritye ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Konsa, li te mennen li deyò, e te di: “Koulye a, gade vè syèl yo, e kontwole zetwal yo, si ou kapab kontwole yo.” Epi Li te di li: “Se konsa desandan w ap ye.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Li te kwè nan SENYÈ a, e SENYÈ a konsa, te konsidere sa kòm ladwati li. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Li te di Abram: “Mwen se SENYÈ a ki te mennen ou sòti nan Ur a Kaldeyen yo, pou bay ou peyi sa a pou posede li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram te di: “O Senyè BONDYE, kijan mwen kapab konnen ke m ap genyen l vre?” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Alò li te di li: “Pote ban mwen yon gazèl twazan, yon femèl kabrit twazan, yon mal mouton nan twazan, yon toutrèl, avèk yon jenn pijon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Li te pote bay li tout sa yo, e li te koupe yo an de mòso. Li te poze mwatye yo chak fasafas ak lòt, men li pa t koupe zwazo yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Zwazo ki manje vyann yo te desann sou kò bèt yo, e Abram te chase yo ale. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Alò, lè solèy la t ap desann, yon gran rèv te tonbe sou Abram. Epi gade byen, yon gwo tenèb ak gran perèz te vin tonbe sou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Bondye te di Abram: “Konnen byen si ke desandan ou yo va etranje nan yon peyi ki pa pou yo, kote yo va vin esklav, e va oprime pandan kat-san ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Men mwen va osi jije nasyon ke yo va sèvi a, e apre yo va sòti deyò avèk anpil byen. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Men pou ou menm, ou va ale vè zansèt ou yo anpè. Ou va antere nan yon laj byen avanse. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Alò, nan katriyèm jenerasyon yo va retounen isit la, paske inikite Amoreyen yo poko fini.” ");
INSERT INTO hatbsa_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Li vin rive ke lè solèy la te fin desann, ke li te fènwa anpil, e gade byen, te parèt yon tòch k ap fè lafimen avèk yon flanbo te pase antre mòso sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nan jou sa a, SENYÈ a te fè yon akò avèk Abram. Li te di: “A desandan ou yo, Mwen va bay peyi sa a, depi nan larivyè Égypte la, jis rive nan gran rivyè a, larivyè Euphrate, ");
INSERT INTO hatbsa_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","peyi a Kenyen yo, Kenizyen yo, Kadmonyen yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Itit yo, Ferezyen yo, Rephaïm yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoreyen yo, Kanaaneyen yo, Gigachyen yo, avèk Jebizyen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Alò, Saraï, madanm Abram nan pa t bay li pitit. Li te gen yon sèvant Ejipsyen ki te rele Agar. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Konsa, Saraï te di Abram: “Alò, gade byen, SENYÈ a te anpeche m fè pitit. Souple, al jwenn sèvant mwen an. Petèt mwen kapab vin gen pitit pa li menm.” Epi Abram te koute vwa a Saraï. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Apre Abram te viv dis lane nan peyi Canaan, madanm Abram nan, Saraï te pran Agar, sèvant Ejipsyen li an, e te bay li a mari li Abram kòm madanm li. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Li te al jwenn Agar, li te vin ansent, epi lè l te wè ke li te ansent, mètrès li a te vin meprize nan zye li. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Konsa, Saraï te di Abram: “Se ou ki gen tò nan bagay sa a. Mwen te bay sèvant mwen an pou li antre nan bra ou, e lè l te wè ke li te vin ansent, mwen te vin meprize nan zye li. Ke SENYÈ a jije antre ou menm avèk mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Men Abram te di a Saraï: “Gade byen, sèvant ou anba pouvwa ou. Fè sa ke ou wè ki bon nan zye ou avèk li.” Pou sa, Saraï te rèd avèk li, e li te pran sove ale kite prezans li. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Alò zanj lan te twouve li akote yon sous dlo nan savann nan, vè sous la nan wout chemen ki ale Schur la. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Li te di a Agar, sèvant Saraï a, “Kibò ou sòti, e kibò ou prale?” Epi li te di: “M ap sove ale kite prezans mètrès mwen an, Saraï.” ");
INSERT INTO hatbsa_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Epi zanj SENYÈ a te di li: “Retounen bò kote mètrès ou, e soumèt ou anba otorite l.” ");
INSERT INTO hatbsa_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Plis ke sa, zanj SENYÈ a te di li: “Mwen va miltipliye desandan ou yo anpil pou yo vin twòp pou konte.” ");
INSERT INTO hatbsa_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Zanj SENYÈ a te di li anplis: “Byen gade, ou ansent, e ou va fè yon fis. Epi ou va rele non li Ismaël ki vle di Bondye tande, akoz SENYÈ a te okipe afliksyon ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Li va yon nonm tankou bourik mawon. Men li va kont tout moun, e men a tout moun va kont li. Epi li va viv yon jan ki kont tout frè li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Epi li te rele non SENYÈ a ki te pale avèk li: “Ou se yon Bondye ki wè a”, paske li te di: “Èske m ap vrèman rete vivan isit lè m fin wè Li”? ");
INSERT INTO hatbsa_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Pou sa, pwi a te rele Lachaï-roi. Gade byen, li la antre Kadès ak Bared. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Alò, Agar te fè yon fis pou Abram. E Abram te rele fis li a, ke Agar te fè a, Ismaël. ");
INSERT INTO hatbsa_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram te gen katre-ven-sis ane lè Agar te fè Ismaël pou li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Alò, lè Abram te gen laj katre-ven-sèz ane, SENYÈ a te parèt a Abram. Li te di li: “Mwen menm se Bondye Toupwisan an. Mache devan mwen, e rete san fot. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mwen va etabli akò Mwen antre Mwen ak Ou, e Mwen va miltipliye ou anpil, anpil.” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram te tonbe atè sou figi li. Bondye te pale avèk li, e te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Pou Mwen, koute byen, akò Mwen avè ou a. Ou va papa a yon gran kantite nasyon. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Yo p ap rele ou Abram ankò, men non ou va Abraham, paske Mwen ap fè ou papa a yon gran kantite nasyon. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","“M ap fè ou bay anpil fwi, Mwen va fè nasyon yo avè w, e wa yo va soti nan ou menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Mwen va etabli akò Mwen antre Mwen ak ou, e desandan ou yo selon tout jenerasyon pa yo kòm yon akò k ap pou tout tan, pou M rete kòm Bondye pou ou ak desandan apre ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","“Mwen va ba ou avèk desandan ou yo peyi kote nou vwayaje yo, tout tè Canaan an, kòm yon posesyon k ap pou tout tan, epi Mwen va Bondye pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Bondye te di anplis a Abraham: “Koulye a pou ou, ou va kenbe akò Mwen an, ou menm avèk desandan apre ou yo pou tout jenerasyon. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Sa se akò Mwen, ke nou va kenbe antre Mwen ak nou menm, e desandan apre nou yo: chak mal pami nou va vin sikonsi. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","“ “Nou va sikonsi nan chè sou avan chè nou, e sa ap sèvi kòm sign akò antre Mwen ak nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Epi chak mal antre nou ki gen uit jou va sikonsi selon tout jenerasyon nou yo, e osi yon sèvitè ki fèt lakay ou, oswa ki achte avèk lajan a nenpòt etranje ki pa sòti nan desandan pa nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Yon sèvitè ki fèt lakay nou, oswa ki te achte avèk lajan nou va asireman vin sikonsi; konsa akò Mwen va nan chè nou, yon akò pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Men yon mal ki pa sikonsi nan avan chè li, moun sila a va vin retire de pèp li a. Li vyole akò Mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Epi Bondye te di a Abraham: “Konsènan madanm ou, Saraï, ou pa pou rele li Saraï, men Sarah va non li. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mwen va beni li, Mwen va bay ou yon fis pa li. Alò, Mwen va beni li, e li va yon manman pou anpil nasyon. Wa a pèp yo va sòti nan li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nan moman sa a, Abraham te tonbe sou figi li. Li te ri e li te di nan kè l: “Èske yon pitit va fèt a yon nonm santan? Epi èske Sarah, ki gen katre-ven-diz ane va fè yon pitit?” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Konsa, Abraham te di a Bondye: “O ke Ismaël kapab viv devan Ou!” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Men Bondye te di: “Non, men Sarah, madanm ou an va fè yon fis, e ou va rele non li Isaac. Mwen va etabli akò Mwen an avèk li pou yon akò pou tout tan pou desandan apre li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“Pou Ismaël, Mwen te tande ou. Gade byen, Mwen va fè li bay anpil fwi, e li va miltipliye li anpil, anpil. Li va vin papa a douz prens yo, e Mwen va fè li vin yon gran nasyon. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","“Men akò Mwen an, Mwen va etabli li avèk Isaac, ke Sarah va fè pou ou nan menm sezon sa a, lane pwochèn.” ");
INSERT INTO hatbsa_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lè Li te fin pale avèk li, Bondye te monte kite Abraham. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Alò, Abraham te pran Ismaël, fis li a, tout sèvitè ki te fèt nan kay li, tout ki te achte avèk lajan li, chak mal pami mesye lakay Abraham yo, e li te sikonsi prepis yo nan menm jou sa a jan Bondye te di li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Alò, Abraham te gen katre-ven-diz ane lè li te sikonsi nan chè pwen pye li. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Epi Ismaël, fis li a te gen trèz ane lè li te sikonsi nan chè pwen pye li. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Nan menm jou sa a, Abraham te sikonsi, ansanm ak fis li, Ismaël. ");
INSERT INTO hatbsa_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tout gason lakay li yo, ki te fèt lakay li, ki te achte avèk lajan nan men moun etranje, te sikonsi avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Alò, SENYÈ a te parèt a li nan bwadchenn Marmré yo pandan li te chita akote pòt tant lan nan chalè jounen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Lè li te leve zye li pou te gade, men twa mesye ki te kanpe anfas li. Lè li te wè yo li te kouri sòti nan pòt tant lan pou rankontre yo, e li te bese tèt li atè. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Li te di: “SENYÈ mwen, si koulye a mwen vin twouve favè nan zye nou, souple, pa pase lwen sèvitè nou an. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Souple, kite yon ti dlo ta pote pou lave pye nou, e repoze nou anba pyebwa a. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Konsa, mwen va pote yon mòso pen, pou nou kapab rafrechi nou menm; apre sa nou kapab kontinye, depi nou fin vizite sèvitè nou an.” Epi yo te di: “Fè sa ke ou di a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Epi Abraham te kouri antre nan tant lan vè Sarah, e te di: “Fè vit, prepare twa mezi farin fen, byen bat li, e fè gato pen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Abraham osi te kouri nan pak bèf, li te pran yon jenn bèf byen mou, byen chwazi, e li te bay li a sèvitè li, ki te fè vit pou prepare li. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Li te pran bòl lèt kaye yo avèk lèt fre ak jèn bèf ke li te prepare, e te plase li devan yo; epi li te kanpe bò kote yo anba pyebwa a pandan yo t ap manje. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Alò, yo te di li: “Kote Sarah, madanm ou?” Epi li te di: “Nan tant lan”. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Epi li te di: “Anverite, mwen va retounen bò kote ou nan lè sa ane pwochèn; epi gade byen, Sarah, madanm ou va gen tan gen yon fis.” Epi Sarah t ap koute bò kote pòt la, ki te dèyè li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Alò, Abraham ak Sarah te vye, byen avanse nan laj. Sarah te depase laj pou fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sarah te ri a tèt li, e te di: “Lè m gen tan fin vye a, èske m ap gen plezi, e mari mwen ki vye tou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Epi SENYÈ a te di Abraham: “Poukisa Sara te ri, e t ap di: ‘Èske vrèman mwen va fè yon pitit lè mwen fin vye a?’ ");
INSERT INTO hatbsa_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","“Èske gen anyen ki twò difisil pou SENYÈ a? Nan lè chwazi a, mwen va retounen a nou menm, nan lè sa a, lane pwochèn, e Sarah va gen yon fis.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sarah te demanti sa, e te di: “Mwen pa t ri non”; paske li te pè. Epi Li te di: “Non, men ou te ri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Alò, mesye yo te leve la e yo te gade pi ba vè Sodome; epi Abraham t ap mache avèk yo pou voye yo ale. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","SENYÈ a te di: “Èske Mwen kab kache Abraham sa ke M prè pou M fè a, ");
INSERT INTO hatbsa_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","paske Abraham va anverite vin yon gran nasyon byen fò, e nan li, tout nasyon yo va beni? ");
INSERT INTO hatbsa_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Paske Mwen te chwazi li pou l kapab kòmande pitit li yo avèk lakay li, pou kenbe chemen SENYÈ a, pou fè ladwati avèk jistis, pou SENYÈ a kapab fè rive sou Abraham, sa ke Li te pale de li a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Epi SENYÈ a te di: “Gwo kri kont Sodome avèk Gomorrhe a byen gran, e peche pa yo grav depase. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mwen va desann koulye a, pou wè si yo te fè tout bagay selon gwo kri sa a, ki te vin jwenn Mwen an; epi si se pa sa, m ap konnen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Alò, mesye yo te vire kite la, e te ale vè Sodome, pandan Abraham toujou kanpe devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham te vin pwoche, e te di L: “Èske Ou vrèman va fè disparèt moun dwat yo ansanm avèk mechan yo? ");
INSERT INTO hatbsa_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sipoze ke gen senkant moun ki dwat nan vil la; èske vrèman Ou va fè l disparèt, e pa prezève kote a pou koz a senkant moun dwat ki ladann yo? ");
INSERT INTO hatbsa_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","“Se lwen Ou pou Ou ta fè yon bagay konsa, pou touye moun dwat yo avèk mechan yo pou dwat yo avèk mechan yo vin trete menm jan. Se lwen Ou menm! Èske Jij sou tout latè a p ap aji avèk jistis?” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Epi SENYÈ a te di: “Si Mwen twouve nan Sodome, senkant moun dwat nan vil la, alò, Mwen va prezève tout pou koz a yo menm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Epi Abraham te reponn: “Alò gade byen, mwen te tante pale ak SENYÈ a, malgre mwen pa plis ke pousyè avèk sann. ");
INSERT INTO hatbsa_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Vin sipoze ke senkant dwat yo manke senk, èske Ou va detwi tout vil la akoz senk lan?” Epi li te di: “Mwen p ap detwi li si Mwen twouve karant-senk ki la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Epi li te pale ankò, e te di: “Sipoze ke gen karant ki twouve la?” Epi li te di: “Mwen p ap fè li pou koz a karant lan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Alò li te di: “O ke SENYÈ a pa vin fache avè m, e mwen va pale; sipoze se trant ki twouve la?” Epi Li te di: “Mwen p ap fè li si Mwen twouve trant lan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Epi li te di: “Koulye a byen gade, mwen te tante pale avèk SENYÈ a; sipoze se ven ki twouve la?” Epi li te di: “Mwen p ap detwi li pou koz a ven yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Alò li te di: “O ke Senyè a pa vin fache avè m! M ap pale sèl fwa sa; sipoze ke se dis ki twouve la?” Epi li te di: “Mwen p ap detwi li pou koz a dis yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Depi lè ke li fin pale ak Abraham nan, SENYÈ a te pati, e Abraham te retounen nan kote pa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Alò, de zanj te vini Sodome nan aswè lè Lot te chita nan pòtay Sodome nan. Lè Lot te wè yo, li te leve pou rankontre yo. Li te bese ba avèk figi li atè. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Epi li te di: “Koulye a, gade byen, frè m yo, souple vire akote nan kay sèvitè ou a, pou pase nwit lan. Lave pye nou, pou nou kapab leve bonè pou fè wout nou.” Malgre sa, yo te di: “Non, men nou va pase nwit lan nan lari a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Men li te plede avèk yo avèk fòs. Konsa yo te vire akote vè li e te antre lakay li a, e li te prepare yon gwo manje pou yo. Anplis li te kwit pen san ledven a, e yo te manje. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Avan yo gen tan kouche, mesye Sodome yo te antoure kay la, ni jèn, ni vye, tout moun ki te sòti nan tout katye yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Konsa, yo te rele Lot e te di li: “Kote mesye sa yo ki te vin kote ou aswè a? Mennen yo bannou pou nou kapab antre an relasyon avèk yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Men Lot te sòti kote yo nan pòtay la, e te fèmen pòt la dèyè l. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Li te di: “Souple, frè m yo, pa aji avèk mechanste. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Byen gade, mwen gen de fi ki pa janm antre an relasyon avèk yon gason. Souple, kite m mennen yo deyò pou nou, e fè avèk yo sa ke nou pito, men pa fè anyen avèk mesye sa yo, akoz se anba pwotèj twati mwen yo gen tan vini.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Men yo te di: “Mete ou akote.” Anplis ke sa yo te di: “Sila te antre tankou etranje, e deja l ap aji kòm jij. Pou sa a, nou va trete ou pi mal pase yo.” Epi yo te peze rèd kont Lot, e yo te prèt pou kraze pòt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Men mesye yo nan kay la te lonje men yo rale Lot anndan avèk yo, e yo te fèmen pòt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Yo te frape mesye ki te nan pòtay kay la pou yo vin avèg, ni piti ni gran, pou yo fatige kò yo e pou yo pa t ka twouve pòt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Konsa, de mesye yo te di Lot: “Kilès ankò ke ou gen isit la? Yon bofis, fis ou yo, e nenpòt moun ou gen nan vil la, mennen yo sòti kite plas sa a, ");
INSERT INTO hatbsa_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","paske nou prèt pou detwi plas sila a, akoz plent pa yo gen tan vin tèlman gran devan SENYÈ a, ke SENYÈ a te voye nou pou detwi li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot te ale deyò pou te pale avèk bofis li yo, ki te prèt pou marye avèk fi li yo, e li te di: “Leve sòti kite plas sila a, paske SENYÈ a va detwi vil la.” Men li te sanble a bofis li a ke se yon blag ke li t ap fè. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Lè maten an te rive, zanj yo te bourade Lot. Yo te di l: “Leve, pran madanm ou avèk de fis ou yo ki isit la, oswa ou va vin disparèt nan pinisyon vil la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Men li te fè reta. Pou sa, mesye sa yo te sezi men l avèk men madanm li avèk men a de fi li yo, paske konpasyon SENYÈ a te sou li. Yo te mennen li deyò, e yo te mete l deyò vil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Lè yo te mennen yo deyò, youn nan yo te di: “Sove ale pou lavi ou! Pa gade dèyè, e pa rete nan okenn kote nan vale a. Sove ale nan mòn yo, oswa ou va detwi nèt.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Men Lot de di yo: “Alò, li pa konsa, mèt mwen yo! ");
INSERT INTO hatbsa_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Koulye a gade byen, sèvitè nou an gen tan twouve favè nan zye nou, nou te montre jan mizerikòd nou gran nan sove vi m, men mwen p ap kapab chape nan mòn yo, paske malè a va gen tan rive sou mwen, e mwen va mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Gade byen, vil sila a ase pre pou m sove ale ladann, e li piti. Souple, kite mwen chape pa la. Èske li pa piti? Konsa vi m kapab sove.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Li te di li: “Gade byen, mwen ba ou demann sa a tou, pou pa detwi vil la sou sila ou te pale a. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Fè vit, chape rive la, paske mwen pa kapab fè anyen jiskaske ou rive la.” Pou sa yo te rele vil la Tsoar. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Solèy la te gen tan fin leve sou tè a lè Lot te rive Tsoar. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Epi SENYÈ a te fè souf avèk dife ki sòti nan syèl la, tonbe tankou lapli sou Sodome avèk Gomorrhe. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Li te detwi vil sila yo, ak tout vale a, ak tout moun ki te rete nan vil yo, ansanm ak sa ki te grandi nan tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Men madanm li ki te dèyè li te gade dèyè, e li te tounen yon pilye sèl. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Alò, Abraham te leve granmmaten. Li te ale nan plas kote li te kanpe devan SENYÈ a, ");
INSERT INTO hatbsa_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","epi li te gade anba vè Sodome avèk Gomorrhe, vè tout tèren nan vale a. Li te wè, e gade byen, lafimen te monte tankou lafimen ki sòti nan founo. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Se konsa li rive ke lè Bondye te detwi vil yo nan vale a, ke Li te sonje Abraham. Li te voye Lot deyò dega a, lè li te boulvèse vil yo nan sila Lot te rete yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot te kite Tsoar e monte. Li te rete nan mòn yo avèk de fi li yo avè l, paske li te pè rete Tsoar. Li te rete nan yon kav, li menm avèk de fis li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Alò premye ne a te vin di a pi Jèn nan: “Papa nou vin vye, e nou pa gen gason sou latè pou vin antre nan nou apre sistèm sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vini, annou fè papa nou bwè diven, e annou kouche avè l pou nou kapab prezève fanmi nou an pa papa nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Pou sa, yo te fè papa yo bwè diven menm nwit lan, e premye ne a te antre kouche avèk papa li. Li pa t konnen ni lè li te kouche a, ni lè li te leve a. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Jou swivan an, premye ne a te di a pi Jèn nan, “Gade byen, yè swa mwen te kouche avèk papa m. Annou fè li bwè diven aswè a tou, epi ou menm antre kouche avè l, pou nou prezève fanmi nou an ak papa nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Alò, yo te fè papa yo bwè diven nan nwit lan tou, epi pi Jèn nan te leve e kouche avè l. Epi li pa t konnen ni lè li te kouche a, ni lè li te leve a. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Konsa tou de fi a Lot yo te vin ansent pa papa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Premye ne a te fè yon fis, e li te rele non li Moab. Li se papa a Moabit yo jis rive jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Epi pou pi Jèn nan, li te fè yon fis tou, e li te rele li Ben-Ammi. Li se papa a tout fis Ammon yo jis rive jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Alò Abraham te vwayaje soti la vè peyi Negev la. Li te vin rete antre Kàdes ak Schur, e li te pase yon tan kon etranje nan Guérar. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham te di selon Sarah, madanm li: “Li se sè mwen”. Alò, Abimélec, wa nan Guérar a te vin pran Sarah. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Men Bondye te vini a Abimélec nan yon rèv nan nwit, e Li te di li: “Veye byen, ou se yon moun ki fin mouri akoz fanm ke ou te pran an, paske li marye.” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Alò, Abimélec pa t gen tan pwoche li, epi li te reponn: “Senyè, èske Ou va detwi yon nasyon, malgre li san fot? ");
INSERT INTO hatbsa_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Èske li menm, li pa t di mwen: ‘Li se sè mwen?’ Epi li menm, li te di: ‘Li se frè m.’ Nan entegrite kè m, ak inosans men m, mwen te fè sa.” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Konsa, Bondye te di li nan rèv la: “Wi, Mwen konnen ke nan entegrite kè ou, ou te fè sa, e Mwen osi te anpeche ou pou ou pa t peche kont Mwen. Se pou sa Mwen pa t kite ou touche li. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Alò, pou sa, remèt madanm a nonm sa a. Paske se yon pwofèt ke li ye. Li va priye pou ou e ou va viv. Men si ou pa remèt li, konnen ke ou va anverite mouri, ou menm avèk tout moun sa yo ki pou ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Konsa, Abimélec te leve granmmaten. Li te rele tout sèvitè li yo, e te di tout bagay sa yo pou yo tande. Mesye sa yo te gen gwo laperèz. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Alò, Abimélec te rele Abraham. Li te di li: “Kisa ou te fè nou? Epi kijan mwen te peche kont ou ke ou te pote sou mwen ak wayòm mwen yon gran peche? Ou te fè m bagay ou pa ta janm dwe fè.”: ");
INSERT INTO hatbsa_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Epi Abimélec te di a Abraham: “Sak rive ou ki fè ou fè bagay sa a?” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham te di: “Paske, mwen te reflechi ke asireman, pa gen lakrent Bondye nan plas sa a, e yo va touye mwen akoz madanm mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Anplis de sa, vrèman li se sè mwen, fi a papa m, men pa fi a manman m, e li te vin madanm mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lè li te rive ke Bondye te fè m vwayaje pou kite kay papa m, mwen te di li: ‘Men yon gras ke ou va fè m: tout kote nou ale, di pa mwen menm: ‘Li se frè m.’’” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Konsa, Abimélec te pran mouton avèk bèf avèk sèvitè li yo, mal ak femèl. Li te bay yo a Abraham, e li te remèt madanm li, Sarah bay li. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimélec te di: “Byen gade, peyi mwen an devan ou. Etabli ou kote ou pito.” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A Sarah, li te di: “Byen gade, mwen te bay frè ou mil pyès an ajan. Veye byen, li se revandikasyon ou devan zye tout moun ki avèk ou. E devan tout moun, ke ou egzonore.” ");
INSERT INTO hatbsa_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham te priye a Bondye, e Bondye te geri Abimélec avèk madanm li, avèk mennaj li yo, pou yo te vin fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Paske SENYÈ a te fèmen vant a tout kay Abimélec la akoz Sarah, madanm Abraham nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Epi SENYÈ a te bay atansyon a Sarah jan Li te pale a, e SENYÈ a te fè sa pou Sarah jan li te pwomèt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Alò, Sarah te vin ansent, e li te anfante yon fis pou Abraham nan vyeyès li, nan lè chwazi ke Bondye te pale li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham te rele non a fis ki te fèt a li menm nan, ke Sarah te fè pou li a, Isaac. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Epi Abraham te sikonsi fis li a, Isaac lè l te gen laj uit jou, jan Bondye te kòmande li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Alò, Abraham te gen laj san ane lè fis li a, Isaac te vin fèt a li menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah te di: “Bondye te fè m fè gwo ri. Tout moun ki tande va ri avèk mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Epi li te di: “kilès ki ta di a Abraham ke Sarah ta bay tete a timoun? Paske mwen ba li yon fis nan vyeyès li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Pitit la te grandi e li te vin sevre. Abraham te fè yon gwo fèt nan jou ke Isaac te sevre a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Alò, Sarah te wè fis Agar a, Ejipsyen an, ke li te fè pou Abraham nan, t ap moke l. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Akoz sa, li te di Abraham: “Mete bòn sa a deyò ansanm avèk fis li a! Paske fis a sèvant sa a p ap vin eritye avèk fis mwen an, Isaac.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Bagay sa a te twouble Abraham anpil akoz fis li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Men Bondye te di a Abraham: “Pa enkyete akoz pwoblèm jènjan sa a avèk sèvant ou an. Nenpòt sa ke Sarah di ou, koute li, paske se nan Isaac desandan ou yo va vin nome. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ak fis sèvant lan, Mwen va fè yon nasyon tou, akoz ke li menm se desandan ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Konsa, Abraham te leve bonè nan maten. Li te pran pen avèk yon kwi dlo, e li te bay yo a Agar. Li te vin mete yo sou zepòl li, li te ba li jènjan an, e li te voye li ale. Li te pati e li te vwayaje nan dezè Beer-Schéba a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Lè dlo ki te nan kwi a, te fin sèvi, li te kite jènjan an anba yon ti ab. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Alò, li te ale chita nan distans yon flèch kab tire, e li te di: “Pa kite m wè jènjan an k ap mouri.” Konsa, li te chita anfas li; li te leve vwa li, e li te kriye. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bondye te tande jènjan an t ap kriye, epi zanj Bondye a te rele Agar depi nan Syèl la. Li te di l: “Kisa ou gen, Agar? Pa pè, paske Bondye te tande vwa jènjan an kote li ye a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Leve, ale fè jènjan an leve, e kenbe li nan men, paske Mwen va fè yon gran nasyon ak li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Epi Bondye te ouvri zye l, e li te wè yon pwi dlo. Li te ale plen po a avèk dlo, e li te bay jènjan an bwè ladann. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bondye te avèk jènjan an, e li te grandi. Li te viv nan dezè a e li te vin yon achè. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Li te viv nan dezè Paran an, e manman l te pran yon madanm pou li nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Alò, li te vin rive nan tan sa a ke Abimélec avèk Picol, chèf lame li, te pale avèk Abraham. Li te di l: “Bondye avèk ou nan tout sa ou fè ");
INSERT INTO hatbsa_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Pou sa, fè sèman ban mwen menm isit la devan Bondye ke ou p ap twonpe ni mwen, ni pitit mwen yo, ni posterite mwen yo, men selon tout gras ke m te montre ou, ou va montre m tou, nan peyi kote ou te demere kon yon etranje a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham te di: “Mwen fè sèman sa a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Men Abraham te plenyen bay Abimélec akoz pwi dlo ke sèvitè Abimélec yo te sezi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimélec te reponn: “Mwen pa konnen kilès ki te fè ou bagay sa a. Ou pa t di m sa, ni mwen pa t tande sa, jis rive jodi a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham te pran mouton avèk bèf, e li te bay yo a Abimélec. Konsa, yo de a te fè yon akò. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham te mete sèt jèn mouton femèl ki sòti nan bann mouton apa pou kont yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimélec te di a Abraham: “Kisa sa vle di; sèt jèn mouton femèl ke ou te mete apa pou kont yo?” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Li te di: “Ou va pran sèt jèn mouton femèl sa yo nan men m pou yo kapab devni yon temwen pou mwen ke mwen te fouye pwi sa a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Pou sa, li te rele plas sila a Beer-Schéba, paske se la ke yo de a te fè sèman an. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Alò, yo te fè yon akò nan Beer-Schéba. Konsa, Abimélec avèk Picol, kòmandan lame a, te leve retounen nan peyi Filisten yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham te plante la yon pyebwa tamaris nan Beer-Schéba, e la li te rele sou non SENYÈ a, Bondye Letènèl la. ");
INSERT INTO hatbsa_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Epi Abraham te demere nan peyi Filistyen yo pandan anpil jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Alò, li te vin pase apre bagay sa yo, ke Bondye te fè Abraham pase yon eprèv. Li te di li: “Abraham!” Epi li te reponn: “Men mwen”. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Li te di: “Pran koulye a fis ou a, sèl fis ou a, ke ou renmen an, Isaac, epi ale nan peyi Morija. Ofri li la kòm yon ofrann ki brile, sou youn nan mòn yo ke Mwen va di ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Alò, Abraham te leve granmmaten. Li te sele bourik li, e li te pran de nan jennonm sèvitè li yo avè l, ansanm avèk Isaac, fis li a. Konsa, yo te fann bwa pou ofrann brile a, e yo te leve ale nan plas kote Bondye te di li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nan twazyèm jou a, Abraham te leve zye li, e li te wè plas la nan yon distans. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham te di a jèn sèvitè li yo: “Rete isit la avèk bourik la. Mwen menm avèk jènjan an va ale lòtbò a. Nou va adore, e retounen bò kote nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham te pran bwa dife pou ofrann brile a. Li te poze li sou Isaac, fis li a, e li te pran nan men l dife ak kouto a. Epi yo de a te mache avanse ansanm. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isaac te pale avèk papa li, Abraham, e te di li: “Papa m!” Epi li te reponn: “Men mwen, fis mwen.” Konsa, li te di l: “Gade, men dife a avèk bwa, men kote jèn mouton an ye pou fè sakrifis la?” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham te di: “Bondye va fè pwovizyon Li menm pou jèn mouton an, fis mwen.” Epi yo de a te mache avanse ansanm. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Alò yo rive nan plas ke Bondye te di li a, epi Abraham te bati yon lotèl la. Li te ranje bwa, li te mare fis li a, Isaac, e li te poze li sou lotèl la anwo tout bwa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham te lonje men l, e li te pran kouto a pou touye fis li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Men zanj SENYÈ a te rele li depi nan syèl la e te di: “Abraham, Abraham!” Li te reponn: “Men mwen isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Li te di: “Pa lonje men ou kont jènjan an, ni pa fè l anyen. Paske koulye a Mwen konnen ke ou krent Bondye, akoz ke ou pa t refize bay fis ou a, sèl fis ou ban Mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Alò, Abraham te leve zye li pou te gade, e byen wè, yon belye ki te kenbe pa kòn li, nan yon rakbwa. Abraham te ale pran belye a, e li te ofri li kòm ofrann brile a nan plas a fis li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham te rele non plas sa a Jehova-Jiré, Bondye Va Fè Pwovizyon. Jis jounen jodi a, yo kon di, “Nan mòn SENYÈ a, va gen pwovizyon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Alò, zanj SENYÈ a te rele Abraham yon dezyèm fwa soti nan syèl la, ");
INSERT INTO hatbsa_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","e te di: “Pou kont Mwen menm, Mwen te sèmante, deklare SENYÈ a, akoz ou te fè bagay sa a, e ou pa t refize fis ou a, sèl fis inik ou an, ");
INSERT INTO hatbsa_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","anverite Mwen va beni ou anpil. Mwen va miltipliye posterite ou tankou zetwal syèl yo, ak tankou grenn sab lanmè ki arebò lanmè yo, epi posterite ou va posede pòtay lènmi pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nan posterite ou, tout nasyon sou latè yo va beni, akoz ke ou te obeyi vwa Mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Epi Abraham te retounen vè jèn sèvitè yo. Yo te leve e te ale ansanm Beer-Schéba. Konsa, Abraham te rete Beer-Schéba. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Li te vin rive apre bagay sa yo ke yo te pale ak Abraham e te di: “Gade byen, Milca osi te fè pitit pou frè ou, Nahor: ");
INSERT INTO hatbsa_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uts se premye ne li, epi Buz frè li, avèk Kemuel, papa Aram nan ");
INSERT INTO hatbsa_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","epi Késed, Hazo, Pildasch, Jidlaph, ak Bethuel.” ");
INSERT INTO hatbsa_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel te vin papa Rebecca. Uit de Milcah sa yo te fè pitit pou Nahor, frè Abraham nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Konkibin li ki te rele Réuma, osi te fè Thébach, Gaham, Tahasch, ak Maaca. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Alò, Sarah te viv pandan san-ven-sèt ane. Men sa yo ki te lane a Sarah. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah te mouri nan Kirjath-Arba (sa vle di Hébron) nan peyi Canaan an. Abraham te vini pou fè dèy pou li, e kriye pou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Konsa, Abraham te leve kite mò li a. Li te pale a fis a Heth yo. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Mwen menm se yon etranje k ap demere pami nou. Ban mwen yon kote pou antèman pami nou pou m kapab antere mò a kote mwen p ap wè li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Fis a Heth yo te reponn Abraham. Yo te di l: ");
INSERT INTO hatbsa_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Koute nou, mèt mwen, ou menm, se yon prens Bondye pami nou. Antere mò ou a nan pi bon chwa ou nan tonm pa nou yo. Nanpwen pèsòn ki va refize ou yon plas antèman pou mò ou a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham te leve e te bese devan moun yo nan peyi a, fis a Heth yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Li te pale avèk yo, e te di: “Si se volonte ou pou m antere mò mwen an kote mwen p ap wè l, koute mwen, e pale ak Ephron fis Tsochar a pou mwen, ");
INSERT INTO hatbsa_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ke li kapab ban mwen kav Macpéla ki pou li a, ki nan pwent chan li an. Pou tout pri ke li fò, ke li ban mwen li devan nou kòm yon lye antèman an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Alò, Ephron te chita pami fis a Heth yo. Ephron, Ethyen an, te reponn Abraham nan prezans fis a Heth yo, menm tout moun yo ki t ap antre nan pòtay vil la. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Non, mèt mwen, koute mwen; mwen ba ou chan an, e mwen ba ou kav ki ladann nan. Nan prezans a tout fis a pèp mwen yo, mwen ba ou li pou ou fè antèman mò ou a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Konsa, Abraham te bese devan pèp peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Li te pale a Ephron nan prezans tout pèp peyi a, e te di: “Silvouplè, si ou va sèlman koute mwen, mwen va bay pri a chan an. Aksepte li nan men m pou m kapab antere mò mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Konsa, Ephron te reponn Abraham e te di li: ");
INSERT INTO hatbsa_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mèt mwen, koute mwen. Yon mòso tè ki vo kat-san pyès lajan, kisa sa ye antre mwen avèk ou? Alò, antere mò ou a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham te koute Ephron. Konsa, Abraham te peze pou Ephron lajan ke li te nonmen nan prezans tout fis a Heth yo, kat-san pyès lajan, nan sistèm komès nòmal. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Pou sa a, chan Ephron ki te nan Macpéla a, ki te pozisyone vè Mamre a, chan an avèk kav ki te ladann nan, tout bwa ki te nan chan an, ki te anndan limit li yo, te sede ");
INSERT INTO hatbsa_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","a Abraham kòm posesyon nan prezans fis a Heth yo, devan tout moun ki te antre nan pòtay vil li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Apre sa, Abraham te antere Sarah, madanm li nan kav la nan chan Macpéla ki anfas Mamre a, (sa vle di Hébron) ");
INSERT INTO hatbsa_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Konsa, fis a Etyen yo te bay papye tè a enkli ak kav la; yo te transfere li a Abraham pou yon landwa antèman. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Alò, Abraham te vin vye, byen avanse nan laj. Epi SENYÈ a te beni Abraham nan tout bagay. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham te di a sèvitè li a, sila ki te gen plis laj lakay li a, ki te an chaj tout sa ke li te posede: “Souple, mete men ou anba kwis mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mwen va fè ou sèmante devan SENYÈ a, Bondye syèl la avèk Bondye tè a, ke ou p ap pran yon madanm pou fis mwen ki sòti nan fi Kananeyen yo, pami moun m ap viv yo, ");
INSERT INTO hatbsa_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","men ke ou va ale nan peyi mwen, kote relasyon mwen yo, e pran yon madanm pou fis mwen an, Isaac.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Sèvitè a te di li: “Sipoze ke fanm nan pa vle swiv mwen pou vini nan peyi a? Èske mwen dwe mennen fis ou a retounen nan peyi kote ou te soti a?” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham te di li: “Veye ke ou pa pran fis mwen an pou fè l retounen la! ");
INSERT INTO hatbsa_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","SENYÈ a, Bondye syèl la ki te pran m, fè m sòti lakay papa m, peyi natal mwen, ki te pale avèk mwen; Li te sèmante ak mwen, e Li te di: ‘A desandan ou yo, Mwen va bay tè sa a’. Li va voye zanj Li devan ou, e ou va pran yon madanm pou fis mwen an soti la. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Men si fanm nan pa vle swiv ou, alò ou va lib de sèman pa m nan, Sèlman, pa fè fis mwen an retounen la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Alò, sèvitè a te plase men l anba kwis mèt li, Abraham, e li te sèmante devan li sou zafè sila a. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Epi sèvitè a te pran dis chamo pami chamo mèt li yo, e li te pati avèk yon seleksyon plizyè bon bagay a mèt li nan men l. Li te leve pou ale nan Mésopotamie pou rive nan vil Nahor. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Li te fè chamo yo bese a jenou deyò vil la toupre pwi a nan aswè, nan lè ke fanm yo te vin rale dlo. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Li te di: “O Senyè, Bondye a mèt mwen an, Abraham, souple, lese mwen twouve siksè jodi a, e montre lanmou ak dousè Ou anvè mèt mwen, Abraham. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Gade byen, m ap kanpe akote sous la, e fi a pèp vil yo ap parèt pou rale dlo. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Koulye a, kite sa fèt ke a fi ke mwen di: ‘Souple, desann veso ou pou m kab bwè’, e ki reponn: ‘Bwè, e mwen va bay bèt ou yo dlo tou’: lese ke se sila ke Ou te chwazi pou sèvitè ou a, Isaac. Konsa nou va konnen ke Ou te montre lanmou ak dousè Ou a mèt mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Avan li te fin pale, gade, Rebecca ki te ne a Bethuel, fi Milca a, fanm Nachor, frè Abraham nan te parèt ak veso sou zepòl li. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Fi a te trè bèl, yon vyèj, e gason pa t janm antre nan relasyon avè l. Li te desann nan sous la, li te ranpli veso li, e li t ap monte. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Alò, sèvitè a te kouri bò kote li, e te di: “Souple, kite mwen bwè yon ti dlo nan veso ou a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Li te di: “Bwè, mèt mwen.” Byen vit li te desann veso li rive nan men li, e li te bay li bwè. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Lè li te fin ba li bwè, li te di: “Mwen va rale dlo osi pou chamo ou yo, jiskaske yo fin bwè”. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Imedyatman li te vide veso li nan basen pou bèt yo, li te kouri retounen nan pwi a pou rale dlo, e li te rale pou tout chamo li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Antretan, nonm nan t ap veye li an silans, pou konnen si SENYÈ a te fè vwayaj li a vin yon siksè, ou non. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Epi pandan chamo yo te fin bwè, nonm nan te pran bag lò ki peze yon mwatye sik (sis gram nan) avèk de braslè pou ponyèt li, ki te peze dis sik an lò, ");
INSERT INTO hatbsa_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","epi li te mande: “Se fi a ki moun ou ye? Souple, fè m konnen, èske gen lojman lakay papa ou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Li te di li: “Mwen se fi Bethuel la, fis Milca, ke li te fè pou Nahor a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ankò fi a te di li: “Nou gen ase, nan pay avèk manje, ak espas pou lojman”. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Alò, mesye a te bese byen ba, e li te adore SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Li te di: “Beni se SENYÈ a, Bondye a mèt mwen an, Abraham, ki pa t abandone lanmou avèk konpasyon Li ak verite Li anvè mèt mwen. Pou mwen, SENYÈ a te dirije m nan chemen lakay de frè a mèt mwen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Alò, fi a te kouri pou pale tout kay manman l de bagay sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Fi a te gen yon frè ki te rele Laban. Laban te kouri deyò kote mesye a nan sous la. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lè li te wè bag la avèk braslè yo sou ponyèt sè li, e lè li te tande pawòl a Rebecca yo, sè li, ki te di: “Se sa ke mesye a te di mwen,” li te ale kote mesye a. Gade byen, li te kanpe akote chamo yo nan sous la. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Epi li te di: “Antre non, beni a SENYÈ a! Poukisa ou kanpe deyò, Paske m gen tan prepare kay la avèk yon plas pou chamo yo?” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Alò, mesye a te antre nan kay la. Laban te dechaje chamo yo, e li te bay pay avèk manje pou chamo yo, ak dlo pou lave pye li, avèk pye a mesye ki te avèk li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Men lè manje a te plase devan li, li te di: “Mwen p ap manje jiskaske mwen pale de misyon mwen an.” Laban te di: “Pale toujou”. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Li te di: “Mwen se sèvitè Abraham. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","SENYÈ a te beni mèt mwen an anpil, jiskaske li vin reyisi anpil. Li te bay li bann mouton ak twoupo, lò ak lajan, sèvitè ak sèvant yo, e chamo ak bourik. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Alò, Sarah, madanm a mèt mwen an te fè yon fis pou mèt mwen an nan vyeyès li. Li te bay li tout sa li posede. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mèt mwen an te fè m sèmante pou di: ‘Ou pa pou pran yon madanm pou fis mwen ki sòti nan fi Kananeyen yo, nan peyi kote m ap viv la, ");
INSERT INTO hatbsa_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","men ou va ale kote lakay papa m, nan moun fanmi pa m yo, e pran yon madanm pou fis mwen an.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mwen te di a mèt mwen an: ‘Sipoze ke fanm nan pa swiv mwen.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Li te di mwen: ‘SENYÈ a devan Sila mwen te mache a, va fè vwayaj ou a reyisi. Ou va pran yon madanm pou fis mwen an pami moun fanmi mwen yo, ak lakay papa m. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Epi konsa, ou va lib de sèman mwen an, si lè ou rive pami moun fanmi mwen yo, yo pa ba ou li. Si se sa a,ou va lib de sèman mwen an.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Konsa, mwen te vini jodi a nan sous la, e te di: ‘O SENYÈ, Bondye a mèt mwen an, Abraham, si koulye a ou va fè vwayaj ke m ap fè a reyisi. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Gade byen, mwen ap kanpe vè sous la, kite sa fèt ke jèn fi ki sòti pou rale dlo a, e ke mwen di: “Souple, kite m bwè yon ti dlo nan veso ou a”, ");
INSERT INTO hatbsa_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","epi li di mwen: ‘Ou mèt bwè, e mwen va tire dlo pou chamo ou yo tou,’ kite sa fèt ke se li ke SENYÈ a te chwazi pou fis a mèt mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Avan mwen te fin pale nan kè mwen, gade byen, Rebecca te parèt avèk veso li sou zepòl li, e li te desann nan sous la pou tire. Mwen te di li: ‘Souple, kite m bwè.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Li te byen vit desann veso a sou zepòl li, e li te di: ‘Bwè’, e mwen va bay bèt ou yo dlo tou’: Alò, mwen te bwè, e li te bay bèt yo dlo tou. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mwen te mande li konsa: ‘Fi a ki moun ou ye?’ Epi li te reponn: ‘Fi a Bethuel la, fis a Nachor, ke Milca te bay li a.’ Epi konsa, mwen te mete bag la nan nen li, e braslè yo nan ponyèt li. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“Epi mwen te bese byen ba, mwen te adore SENYÈ a, e te beni SENYÈ a, Bondye a mèt mwen an, Abraham, ki te gide mwen nan bon chemen pou pran fi nan fanmi mèt mwen an pou fis li. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Alò, koulye a, si w ap aji avèk dousè e verite avèk mèt mwen an, fè m konnen. Men si se pa sa, kite m konnen, pou m kapab vire swa adwat, swa agoch.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban avèk Bethuel te reponn: “Afè sa a sòti nan SENYÈ a. Alò nou pa kapab pale ou ni byen, ni mal. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Men Rebecca la devan ou, pran li pou ou ale, e ke li vin madanm a fis mèt ou a, jan SENYÈ a te pale a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Lè sèvitè Abraham nan te tande pawòl sa yo, li te bese tèt li atè devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Sèvitè a te mete deyò bagay ki fèt ak lajan avèk lò, ak vètman, e li te bay yo a Rebecca. Li te osi bay kèk bagay ki koute byen chè a frè li avèk manman li. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Li menm avèk mesye ki te avè l yo te manje, bwè e te pase nwit lan. Lè yo te leve nan maten li te di: “Voye mwen ale vè mèt mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Men frè li avèk manman li te di: “Kite fi a rete avèk nou pandan kèk jou, annou di di jou. Apre li kapab ale”. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Li te reponn yo: “Pa anpeche m, paske se SENYÈ a ki te fè chemen mwen an reyisi. Voye m ale pou m kapab retounen bò kote mèt mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Epi yo te di: “Nou va rele fi a pou mande li volonte pa li.”: ");
INSERT INTO hatbsa_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Alò, yo te rele Rebecca e te di li: “Èske ou va ale avèk mesye sila a?” Epi li te reponn: “M ap prale.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Konsa yo te voye Rebecca, sè yo a ale, avèk bòn li yo, sèvitè Abraham nan ak mesye pa li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Yo te beni Rebecca, e te di li: “Ke ou menm, sè nou, kapab devni manman a dè milye de dizèn de milye, e ke desandan ou yo kapab posede pòtay a sila ki rayi yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Epi Rebecca te leve avèk bòn li yo, yo te monte chamo yo, e yo te swiv mesye a. Konsa sèvitè a te pran Rebecca, e li te pati. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Alò, Isaac t ap sòti nan yon vwayaj vè Lachaï-roi, paske li t ap viv nan Negev. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Isaac te ale deyò pou fè meditasyon nan chan an nan aswè. Lè li te leve zye li pou gade, gade byen, chamo yo t ap vini. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecca te leve zye li, e lè li te wè Isaac, li te desann chamo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Li te di sèvitè a: “Kilès mesye sa a k ap mache nan chan an vin jwenn nou an?” Epi sèvitè a te reponn: “Li se mèt mwen.” Konsa, fi a te pran vwal la, e li te kouvri tèt li. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Sèvitè a te di Isaac tout sa ke li te fè. ");
INSERT INTO hatbsa_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Epi Isaac te mennen li nan tant li. Li te pran Rebecca, e li te vin madanm li, e li te renmen li. Konsa Isaac te konsole lè manman li te fin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Alò, Abraham te pran yon lòt madanm, ki te rele Ketura. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Li te fè pou li Zimran, Jokschan, Madian, Jischbak, avèk Schuach. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokschan te vin papa a Séba avèk Dedan. Epi fis Dedan yo te Aschurim, Letuschim, avèk Leummim. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Epi fis a Madian yo te Épha, Epher, Hénoc, Abida, avèk Eldaa. Tout sa yo se te fis a Ketura yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Alò Abraham te bay tout sa li te posede a Isaac; ");
INSERT INTO hatbsa_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","men a fis a fanm konkibin yo, li te bay yo kado pandan li te toujou ap viv la, e li te voye yo lwen fis li a vè lès, nan peyi lès la. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Sa yo se tout ane lavi ke Abraham te viv, san-swasann-kenz ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham te respire dènye souf li. Li te mouri yon granmoun byen mi, e li te byen satisfè avèk lavi. Konsa, li te vin ranmase vè pèp li. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Fis li yo, Isaac avèk Ismaël te antere li nan kav Macpéla a, nan chan Ephron an, fis Tsochar, Etyen an, anfas Mamré, ");
INSERT INTO hatbsa_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","chan ke Abraham te achte nan men fis a Heth yo. La, Abraham te antere avèk madanm li, Sarah. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Li te vin rive apre mò Abraham nan, ke Bondye te beni fis li a, Isaac, epi Isaac te viv toupre Lachaï-roi. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Alò, sa yo se achiv a desandan a jenerasyon Ismaël yo, fis Abraham nan, ke Agar, Ejipsyen an, sèvant a Sarah a, te fè ak Abraham; ");
INSERT INTO hatbsa_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","epi sa yo se non fis Ismaël yo, selon non yo, nan lòd nesans pa yo: Nebajoth, premye ne a Ismaël la, Kédar, Adbeel, Mibsam, ");
INSERT INTO hatbsa_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mischma, Duma, Massa, ");
INSERT INTO hatbsa_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Théma, Jethur, Naphisch avèk Kedma. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Sila yo se fis Ismaël yo e sa se non yo, pa vil, e pa anplasman yo; douz prens yo selon tribi pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Sa yo se lane lavi Ismaël yo, san-trant-sèt ane. Li te respire dènye souf li, e li te mouri, epi yo te ranmase li vè pèp li. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Yo te deplase soti nan Havila jis rive nan Schur ki nan kote lès Égypte lè yon moun ap pwoche Assyrie; li te rete la malgre sa te fè ènmi avèk tout paran li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Alò, sa yo se achiv jenerasyon ki swiv Isaac yo, fis Abraham nan: Abraham te vin papa Isaac. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Lè Isaac te gen laj karant ane, li te pran Rebecca, fi Bethuel la, Araméen an nan kote Paddan-Aram, sè Laban an, Araméen an, pou vin madanm li. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac te priye a SENYÈ a anfavè madanm li, akoz li te esteril. Konsa, SENYÈ a te reponn li, e Rebecca, madanm li an te vin ansent. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Men pitit yo te an konfli anndan vant li. Li te di: “Si se sa, poukisa mwen viv?” Li te ale mande a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","SENYÈ a te di li: “Gen de nasyon nan vant ou. De pèp va vin separe sòti nan vant ou. Yon pèp va pi pwisan ke lòt la. Pi gran an va sèvi pi jèn nan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lè jou li yo pou akouche te rive, gade, te gen jimo nan vant li. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Premye a te vin parèt byen wouj. Li te kouvri toupatou tankou yon rad ki plen plim sou li. Yo te nonmen li Ésaü. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Apre, frè li a te vin parèt avèk men li ki t ap kenbe talon pye a Ésaü. Akoz sa yo te rele li Jacob. Isaac te gen swasant ane lè madanm li te bay nesans a yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Lè gason sa yo te grandi, Ésaü te vin fò nan lachas, yon nonm ki fèt pou chan an. Men Jacob te yon nonm byen trankil, ki te viv nan tant. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Alò, Isaac te renmen Ésaü akoz ke li te gen yon gou pou vyann bèt sovaj, men Rebecca te renmen Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lè Jacob te fin kwit yon soup, Ésaü te vin antre pandan li t ap kite chan an, e li te grangou anpil. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Konsa, Ésaü te di Jacob: “Souple, ban m goute bagay wouj sa ki la a, paske mwen grangou anpil.” Se pou sa yo te rele non li Edom. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Men Jacob te di: “Premyeman vann mwen dwa nesans ou an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ésaü te di: “Gade byen, mwen prèt pou mouri, e konsa pou ki bagay yon eritaj ap sèvi mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob te di: “Premyeman, sèmante ban mwen.” Li te sèmante ba li. Li te vann dwa nesans li an bay Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jacob te bay Ésaü pen avèk yon soup pwa. Li te manje e bwè, e li te leve al fè wout li. Konsa Ésaü te vin rayi dwa nesans li an. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Alò, te gen yon gwo grangou nan peyi a, ki te fèt apre gwo grangou ki te fèt nan jou Abraham yo. Isaac te ale Guérar vè Abimélec, wa Filisten yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Senyè a te parèt a li menm e te di: “Pa desann an Égypte. Rete nan peyi ke Mwen va montre ou a. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Rete pou yon tan nan peyi sa a, Mwen va avèk ou, e Mwen va beni ou, paske a ou menm ak desandan ou yo, Mwen va bay tout peyi sa yo, e Mwen va etabli sèman ke Mwen te sèmante a papa ou a, Abraham. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","“Mwen va miltipliye desandan ou yo tankou zetwal nan syèl la, e va bay tout tè sa yo a desandan ou yo. E nan desandan ou yo, tout nasyon latè yo va beni, ");
INSERT INTO hatbsa_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","akoz Abraham te obeyi Mwen, e kenbe chaj Mwen, Kòmandman Mwen yo, règleman Mwen yo, avèk lwa Mwen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Konsa, Isaac te viv Guérar. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Lè mesye yo nan plas la te mande li de madanm li, li te di: “Li se sè mwen,” paske li te pè pou di “madanm mwen” akoz li te panse: “mesye yo nan zòn sa a ta kapab touye mwen pou Rebecca, paske li bèl.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Li te rive lè li te rete la pandan anpil tan, ke Abimélec, wa Filisten yo t ap gade nan yon fenèt, e gade, li te wè Isaac ki t ap karese madanm li, Rebecca. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Alò, Abimélec te rele Isaac e te di: “Gade sa, vrèman li se madanm ou! Kòman ou te fè di mwen: ‘Li se sè mwen’”? Isaac te di li: “Akoz ke mwen te di: ‘Mwen ta kapab mouri akoz li.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimélec te di: “Kisa ke ou te fè nou la a? Yon moun nan pèp la ta kapab fasilman vin kouche avèk madanm ou, e ou t ap fè nou vin koupab pou peche sa a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Konsa, Abimélec te bay tout pèp la lòd, e te di: “Moun ki touche mesye sa a, oswa madanm li, asireman va mete a lanmò.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Alò, Isaac te simen nan peyi sa a, e li te rekòlte nan menm ane a san fwa. Senyè a te beni li. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Mesye a te vin rich e li te kontinye vin pi rich jiskaske li te vin ranmase anpil gwo richès. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Li te posede anpil bann mouton, twoupo avèk anpil chan bèt, jiskaske Filisten yo te vin anvi li. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Alò, tout pwi ke sèvitè a papa li yo te fouye nan jou Abraham yo, papa li, Filisten yo te bouche lè yo te ranpli yo avèk tè. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Alò, Abimélec te di a Isaac: “Kite nou, paske ou twò fò pou nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Konsa, Isaac te pati la. Li te vin rete nan vale Guérar a, e li te fè anplasman la. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac te fouye pwi yo ankò, pwi ki te fouye nan jou papa li yo, Abraham, paske Filisten yo te bouche yo apre mò Abraham nan. Epi li te bay yo menm non ke papa li te bay yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Men lè sèvitè Isaac yo te fouye nan vale a, e te twouve la yon pwi dlo ki t ap boujonnen, ");
INSERT INTO hatbsa_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","bèje Guérar yo te goumen avèk bèje Isaac yo e te di: “Dlo a se pa nou!” Alò, li te nonmen pwi a Ések akoz ke yo te fè kont ak li. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Yo te fouye yon lòt pwi, yo te goumen sou sila a tou e li te nonmen li Sitna. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Li te deplase la, li te fouye yon lòt pwi, e yo pa t goumen sou li. Li te bay li non a Rehoboth, paske li te di: “Koulye a, Bondye vin bannou plas, e nou va rekòlte anpil fwi nan peyi a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Alò, li te kite la pou monte Beer-Schéba. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","SENYÈ a te parèt a li menm nan nwit lan, e te di: “Mwen se Bondye a papa ou, Abraham. Pa pè, paske Mwen avè w. Mwen va beni ou, e Mwen va fè desandan ou yo miltipliye pou koz a sèvitè Mwen an, Abraham.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Konsa, li te bati yon lotèl la, li te rele non SENYÈ a, e te monte tant li la. La sèvitè Isaac yo te fouye yon pwi. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Alò, Abimélec te vin kote li soti Guérar, avèk konseye li, Ahuzath, avèk Picol, kòmandan lame a. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac te di yo: “Poukisa nou vin kote m, kòmsi nou rayi mwen, e te pouse mwen lwen nou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yo te di: “Nou wè byen klè ke SENYÈ a te avèk ou. Alò, nou te di: ‘Annou fè yon sèman antre nou menm, e kite nou fè yon akò avèk ou, ");
INSERT INTO hatbsa_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ke ou p ap fè nou okenn mal, menm jan ke nou pa t touche ou, nou pa t fè ou anyen sof ke byen, e w ap voye nou ale anpè.’ Koulye a, ou se beni a SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Alò, li te fè yon gwo fèt manje pou yo, yo te manje e bwè. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nan maten, yo te leve bonè. Yo te sèmante a youn lòt, epi Isaac te voye yo ale kite li anpè. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Li te vin rive nan menm jou a, ke sèvitè Isaac yo te antre e te avèti li de yon pwi ke yo te fouye. Yo te di li: “Nou gen tan twouve dlo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Konsa, li te rele li Schiba, akoz sa yo rele vil la Beer-Schéba jis rive jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Lè Ésaü te gen karant ane, li te marye avèk Judith, fi Béeri a, Etyen an, e Basmath, fi a Elon an, Etyen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Yo te mennen traka pou twouble Isaac avèk Rebecca. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Alò, li te vin rive lè Isaac te vye, e zye li te twò fèb pou wè, ke li te rele Ésaü, pi gran nan pitit li yo. Li te di li: “Fis mwen.” Ésaü te reponn li: “Men mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac te di: “Gade byen, koulye a, mwen vin vye. Mwen pa konnen jou ke m ap mouri an. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ebyen, souple pran flèch ou yo avèk banza ou, e ale nan chan pou fè lachas jibye pou mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Prepare yon manje ki gen bon gou, jan ou konnen ke m renmen li an, e pote ban mwen pou m kab manje, pou nanm mwen kapab beni ou avan ke m mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebecca t ap koute pandan Isaac t ap pale avèk fis li a, Ésaü. Alò, lè Ésaü te ale nan chan pou fè lachas jibye pou kapab pote lakay, ");
INSERT INTO hatbsa_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebecca te di fis li a, Jacob: “Veye byen, mwen te tande papa ou pale ak frè ou a Ésaü. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pote pou mwen kèk jibye e prepare yon manje bon gou pou mwen, pou mwen kapab manje, e beni ou nan prezans SENYÈ a, avan ke m mouri.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Alò, pou sa, fis mwen, koute lòd ke mwen pral ba ou a. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ale koulye a, ale nan bann twoupo a. Chwazi de jèn kabrit ladann, pou m kapab prepare yo kòm yon bon manje pou papa ou, jan li renmen li an. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Konsa, ou va pote li bay papa ou, pou li kapab manje, pou li kapab beni ou avan ke li mouri”. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob te reponn a manman l, Rebecca: “Gade byen, Ésaü, frè m nan byen kouvri avèk plim, e po m byen swa. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Petèt papa m va manyen m. Konsa, mwen ta vin tankou yon twonpè nan zye li, e mwen ta rale sou mwen yon madichon olye yon benediksyon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Men manman li te di li: “Ke madichon ou tonbe sou mwen, fis mwen! Sèlman obeyi vwa m, e ale chache yo pou mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Li te ale chache yo e te pote yo bay manman l. Manman l te fè yon manje bon gou jan papa l te renmen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Alò, Rebecca te pran pi bon vètman Ésaü a, pi gran fis li a, ki te avèk li nan kay la, e te mete yo sou Jacob, pi jèn fis li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Li te mete po kabrit sou men li, ak nan pati kou li ki te swa. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Osi li te bay Jacob, fis li a, manje bon gou a avèk pen ke li te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Konsa, li te vini kote papa l, e te di: “Papa m.” Epi li te di: “Men mwen. Kilès ou ye, fis mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob te di a papa l: “Mwen menm se Ésaü, premye ne ou a. Mwen te fè sa ou te mande m nan. Leve, souple, e chita pou manje nan jibye mwen an, pou nanm ou kapab beni mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac te di fis li a: “Kòman ou reyisi fè sa vit konsa, fis mwen?” Epi li te di: “Paske SENYÈ a, Bondye ou a te fè sa rive m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Alò, Isaac te di Jacob: “Souple, vin pi pre pou m kapab manyen ou, fis mwen, pou si ou se vrèman fis mwen an Ésaü, o non.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob te pwoche papa li. Li te manyen li, e te di: “Vwa a se vwa a Jacob, men men yo se men Ésaü.”: ");
INSERT INTO hatbsa_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Li pa t rekonèt li, paske men li te kouvri avèk plim tankou men frè l la, Ésaü. Epi akoz sa, li te beni li. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Li te di: “Èske vrèman ou se fis mwen an, Ésaü?” Epi li te reponn: “Se Mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Konsa, li te di: “Pote ban mwen, e mwen va manje nan jibye fis mwen an, pou m kapab beni ou.” Li te pote ba li, e li te manje. Li te osi pote diven e li te bwè. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Epi Isaac, papa li, te di li: “Souple, pwoche pou bo m, fis mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Li te vin pre, e te bo li. Lè li te santi sant vètman li, li te beni li, e te di: “Ou wè, sant fis mwen an tankou sant a yon chan ke SENYÈ a te beni. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Koulye a, ke Bondye kapab ba ou lawouze syèl la, ak grès tè a, anpil sereyal chan avèk diven nèf. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ke anpil pèp vin sèvi ou, e ke nasyon yo bese devan ou. Vin mèt sou frè ou yo, e lese fis a manman ou yo vin bese a ou menm. Modi va sila ki modi ou yo. Beni va sila ki beni ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Depi li rive ke Isaac te fin beni Jacob, e Jacob te apèn sòti nan prezans Isaac, papa l, Ésaü, frè l la te vin sòti nan fè lachas. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Li menm tou te fè manje bon gou, e li te pote l bay papa l. Li te di a papa l: “Ke papa m leve manje nan jibye fis li a, pou ou kapab beni mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac, papa li te di: “Kilès ou ye?” Konsa, li te di: “Mwen se fis ou, premye ne a, Ésaü.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Alò, Isaac te vin tranble avèk vyolans, e te di: “Alò kilès sa ki te fè lachas jibye a, ki te pote ban mwen, ke m te manje tout li avan ou te vini, e ke mwen te beni li an? Wi, e li va beni.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lè Ésaü te tande pawòl a papa li yo, li te kriye avèk gwo kri ak yon vwa byen fò, e li te di papa l: “Beni m tou o papa mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Men li te reponn: “Frè ou a te vini twonpe m, e li te rache benediksyon ou an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Li te di: “Èske se pa t yon verite yo te nonmen li Jacob, paske li te pran plas mwen de fwa sa yo? Li te pran dwa nesans mwen an, e gade, koulye a li pran benediksyon mwen.” Epi li te di: “Èske ou pa t rezève yon benediksyon pou mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac te reponn Ésaü: “Gade byen, mwen te fè li mèt ou, e tout moun nan fanmi li, mwen te bay li yo kòm sèvitè. Avèk sereyal avèk diven nèf mwen te bay li soutyen. Alò, pou ou, kisa m kapab fè, fis mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ésaü te di a papa li: “Èske se yon sèl benediksyon ou genyen, papa mwen? Beni mwen menm tou, o papa m.” Konsa, Ésaü te leve vwa l e te kriye. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Alò, Isaac, papa l te reponn e te di li: “Gade byen, nan grès bon tè fètil ou va rete, e lwen lawouze k ap soti anwo syèl la. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Pa nepe ou, ou va viv, e frè ou a, ou va sèvi li. Men li va rive ke lè ou vin toumante, ou va kase jouk la sou kou ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Epi Ésaü te pote yon rayisman kont Jacob akoz benediksyon an ke papa l te beni li. Konsa, Ésaü te di nan kè l: “Jou doulè pou mò papa m prèt pou fini, alò, mwen va touye frè m, Jacob.” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Alò, lè pawòl pi gran fis la te rive a Rebecca, li te voye rele pi jèn fis li a, Jacob, e te di li: “Gade byen, frè ou a, Ésaü ap plenyen li menm de ou menm avèk entansyon pou touye ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Pou sa, fis mwen, obeyi vwa m, e leve sove ale Charan, vè frè mwen, Laban! ");
INSERT INTO hatbsa_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Rete avè l pandan kèk jou jiskaske kòlè frè ou a vin bese, ");
INSERT INTO hatbsa_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","jiskaske kòlè frè ou a vin bese, e bliye sa ou te fè li a. Alò, mwen va voye chache ou la. Poukisa mwen ta oblije pèdi nou toude nan yon sèl jou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebecca te di Isaac: “Mwen bouke viv akoz fi Heth yo. Si Jacob pran yon fanm nan fi a Heth yo, tankou sila, nan fi peyi yo, ki byen ki kab rive nan vi m?” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Alò, Isaac te rele Jacob, li te beni li, li te kòmande li, e li te di: “Ou p ap pran yon fanm nan fi Canaan yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","“Leve ale Paddan-Aram, lakay Bethuel, papa a manman ou. De la, pran yon madanm pami fi a Laban yo, frè manman ou an. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","“Ke Bondye Toupwisan an kapab beni ou, bay ou anpil fwi, e fè ou miltipliye pou yo kapab devni yon gran fòs kantite moun. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ke li kapab osi bay ou benediksyon Abraham nan, pou ou menm, ak pou desandan ou yo osi, ke ou kapab posede peyi kote w ap demere a, ke Bondye te bay a Abraham nan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Alò, Isaac te voye Jacob ale. Li te ale Paddan-Aram a Laban, fis a Bethuel la, Arameyen an, frè Rebecca, manman a Jacob ak Ésaü. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Epi Ésaü te wè ke Isaac te beni Jacob e te voye li ale Paddan-Aram pou pran pou li menm yon madanm, e ke lè li te beni li, li te bay li lòd, e te di: “Ou pa pou pran yon madanm nan fi a Canaan yo,” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","epi ke Jacob te obeyi papa li, ak manman li, li te ale Paddan-Aram. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Konsa Ésaü te wè ke fi Canaan yo pa t plè papa li Isaac. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Konsa, Ésaü te ale kote Ismaël, e li te marye, anplis ke madanm yo li te gen deja, Mahalath, fi Ismaël la, fis Abraham nan, sè Nebajoth la. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Konsa, Jacob te kite Beer-Schéba e te ale vè Charan. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Li te vini nan yon sèten kote pou te pase nwit lan la, akoz solèy la te gen tan fin kouche. Li te pran youn nan wòch yo, li te mete l anba tèt li, e li te kouche la nan plas sila a. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Li te fè yon rèv, e li te gade yon nechèl yo te mete sou latè, tèt li te rive nan syèl la. Epi gade, zanj Bondye yo t ap monte desann sou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Epi, gade byen, SENYÈ a te kanpe anwo li. Li te di: “Mwen se SENYÈ a, Bondye papa Abraham nan ak Bondye Isaac la. Tè sa kote ou kouche a, Mwen va bay ou li pou ou menm ak desandan ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Desandan ou yo va tankou pousyè latè, e ou va gaye nan lwès, nan lès, nan nò, ak nan sid. Konsa, nan ou avèk desandan ou yo, tout fanmi sou latè yo va beni. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“Gade byen, Mwen avèk ou. Mwen va kenbe ou nenpòt kote ou ale, e Mwen va fè ou retounen nan peyi sa a. Paske Mwen p ap kite ou jiskaske Mwen fin fè tout sa ke M te pwomèt nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Alò, Jacob te leve nan dòmi an, e li te di: “Anverite SENYÈ a nan plas sila a, e mwen pa t konnen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Li te pè, e li te di: “Alò, A la etonan plas sa a etonan! Sila a pa lòt ke lakay Bondye, e sa se pòtay Syèl la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Konsa, Jacob te leve bonè nan maten. Li te pran wòch ke li te plase anba tèt li a, e li te etabli li tankou yon pilye. Li te vide lwil sou tèt pilye a. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Li te rele plas sa a Béthel, men oparavan non a vil sa a se te Luz. ");
INSERT INTO hatbsa_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Epi Jacob te fè yon sèman. Li te di: “Si Bondye ale avèk mwen, si Li va kenbe mwen nan vwayaj sila ke m ap fè a, e Li va ban mwen manje pou m manje, ak rad pou m mete, ");
INSERT INTO hatbsa_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","pou m ka retounen lakay papa m anpè, pou SENYÈ a va Bondye pa m, ");
INSERT INTO hatbsa_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","alò, wòch sila a, ke m etabli tankou pilye a, va devni Lakay Bondye. Nan tout sa ke ou ban mwen, mwen va anverite bay yon dim a Ou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Alò, Jacob te ale nan vwayaj li a, e li te vini nan peyi ki te pou fis a lès yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Lè li te gade, li te wè yon pwi nan chan an, e gade byen, te gen twa bann mouton ki te kouche la akote li, paske se te avèk pwi sa a ke yo te bay tout bèt yo dlo. Alò, wòch la sou bouch pwi a te byen laj. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Lè tout bèje mouton yo te rasanble la, yo te konn woule wòch la sòti nan bouch pwi a, pou te bay mouton yo dlo, e te remete wòch la nan plas li sou bouch pwi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob te di yo: “Frè m yo, kibò nou sòti?”: Yo te reponn: “Nou sòti nan Charan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Li te di yo: “Èske nou konnen Laban, fis Nachor a?” Epi yo te di: “Nou konnen li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Li te mande yo: “Èske tout bagay ale byen pou li?” Epi yo te reponn: “Wi, tout bagay ale byen pou li. Men fi li a, Rachel k ap vini avèk mouton yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Li te di: “Gade byen, li toujou gwo lajounen; li poko lè pou rasanble bèt. Bay bèt yo dlo, e mete yo nan patiraj toujou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Men yo te di: “Nou pa kapab jiskaske tout bèje mouton yo fin rasanble, e yo woule wòch la sòti nan bouch pwi a. Se nan lè sa a nou va bay mouton yo dlo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Pandan li t ap pale avèk yo, Rachel te parèt avèk mouton papa l yo, paske li te yon bèje. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Lè Jacob te wè Rachel, fi Laban an, frè manman li, ak mouton Laban yo, frè manman l, Jacob te pwoche. Li te woule wòch la sòti nan pwi a, e li te bay dlo a bann mouton Laban an, frè manman l lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Epi Jacob te bo Rachel. Li te leve vwa li, e li te kriye. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob te di Rachel ke li te yon moun fanmi papa l, e ke li te fis a Rebecca. Li te kouri di papa l sa. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Alò, lè Laban te tande nouvèl Jacob la, fis a sè li, li te kouri pou ale rankontre avè l e te anbrase li. Li te bo li, e te mennen li lakay li. Konsa, Jacob te eksplike Laban tout bagay sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban te di li: “Anverite, ou se zo mwen avèk chè mwen.” Konsa, li te rete avèk li pandan yon mwa. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Alò Laban te di a Jacob: “Akoz ke ou se moun fanmi mwen, èske sa vle di ke ou ta dwe sèvi mwen gratis? Di m, kisa pou m bay ou kòm salè?” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Alò, Laban te gen de fi. Non pi gran an se te Léa, e lòt la se te Rachel. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Epi zye a Léa yo te fèb, men Rachel te byen bèl nan figi l, ni nan fòm li. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Alò Jacob te renmen Rachel, e konsa li te di: “Mwen va sèvi ou pandan sèt ane pou fi ou ki pi jèn nan, Rachel.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban te di: “Li pi bon pou m bay ou li pase pou m ta bay li a yon lòt gason. Rete avè m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob te sèvi sèt ane pou Rachel, men yo te parèt a li menm kòmsi se te kèk jou akoz lanmou li te gen pou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Konsa, Jacob te di a Laban: “Ban mwen madanm mwen, paske tan mwen an gen tan fin konplete, pou m kapab antre nan relasyon avè l.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban te rasanble tout mesye yo nan plas la, e li te fè yon gwo fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Men nan aswè, li te pran fi li, Léa, e li te mennen li kote Jacob. Li te antre an relasyon avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban osi te bay sèvant li, Zilpa, pou Léa kòm sèvant. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nan maten, gade byen, li vin parèt ke se te Léa! Konsa, li te di a Laban: “Kisa sa ou te fè m la a? “Èske se pa pou Rachel ke m te sèvi ou a? Poukisa ou fè m desepsyon sila a?” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Men Laban te di: “Se pa koutim peyi nou pou fè maryaj a pi jèn nan avan premye ne a. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Konplete semèn nan avèk sila a, e nou va bay ou lòt la tou; pou sèvis sa a, ou va sèvi m yon lòt sèt ane.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob te fè sa, li te konplete semèn nan avèk fi a, e li te ba li fi li, Rachel, kòm madanm li. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban osi te bay sèvant li, Bilha a fi li, Rachel kòm sèvant li. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Alò, Jacob te antre an relasyon ak Rachel osi, e vrèman, li te renmen Rachel plis ke Léa, e li te sèvi avèk Laban pandan yon lòt sèt ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Alò, SENYÈ a te wè ke Léa te manke renmen, e Li te ouvri vant li, men Rachel te rete san pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Léa te vin ansent. Li te fè yon fis, e li te nonmen li Reuben, paske li te di: “Akoz ke SENYÈ a te wè doulè mwen, asireman koulye a mari mwen va renmen m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Li te vin ansent ankò, li te fè yon fis, e li te di: “Akoz ke SENYÈ a te tande ke mwen te rayi, pou sa Li te ban mwen fis sila a osi.” Alò, li te bay li non Siméon. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Li te vin ansent ankò, li te fè yon fis. Konsa, li te di: “Alò fwa sa a mari mwen va vin atache a mwen, paske mwen te fè twa fis pou li.” Pou sa, li te nonmen li Lévi. ");
INSERT INTO hatbsa_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Epi li te vin ansent ankò. Li te fè yon fis, e li te di: “Fwa sa, mwen va louwe SENYÈ a.” Pou sa li te nonmen li Juda. Epi konsa, li te vin sispann fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Alò, lè Rachel te wè ke li pa t fè pitit pou Jacob, li te vin jalou. Li te di a Jacob: “Ban mwen pitit, oswa, m ap mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Epi chalè Jacob te brile kont Rachel. Li te di: “Èske mwen nan plas Bondye, ki te anpeche vant ou bay fwi a?” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Li te reponn: “Men sèvant mwen an, Bilha, antre an relasyon avèk li pou li kapab pouse fè sou jenou mwen yo. Konsa, pa li menm, mwen kapab fè timoun tou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Epi li te ba li sèvant li, Bilha kòm madanm, e li te antre nan relasyon avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha te vin ansent, e li te fè yon fis pou Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Alò, Rachel te di: “Bondye te ban mwen rezon. Li te vrèman tande vwa m, e Li te ban mwen yon fis.” Pou sa, li te nonmen li Dan. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Sèvant a Rachel la, Bilha te vin ansent ankò, e li te fè pou Jacob yon dezyèm fis. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Alò, Rachel te di: “Avèk gwo lit mwen te mennen avèk sè mwen an, mwen te vrèman vin genyen l.” Epi li te nonmen li Nephtali. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lè Léa te wè ke li pa t fè pitit ankò, li te pran sèvant li a, Zilpa, e li te bay li a Jacob kòm madanm. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Sèvant a Léa a, Zilpa te fè yon fis pou Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Konsa, Léa te di: “A la chans!” Epi li te nonmen li Gad. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Sèvant Léa a, Zilpa te fè pou Jacob yon dezyèm fis. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Epi Léa te di: “A la kontan mwen kontan! Pou sa, fanm yo va rele mwen kontan.” Epi li te nonmen li Aser. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Alò, nan jou rekòlt ble yo, Reuben te sòti pou twouve mandragò nan chan an, e li te pote yo bay manman li, Léa. Alò, Rachel te di a Léa: “Souple, ban m kèk nan mandragò fis ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Men Léa te di l: “Èske se yon ti bagay sa ye pou ou pou pran mari mwen? Konsa, èske ou ta renmen pran mandragò a fis mwen yo tou?” Rachel te reponn: “Pou sa, li kapab kouche avè ou aswè a, kòm twòk pou mandragò a fis ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Lè Jacob te sòti nan chan an nan aswè, alò, Léa te sòti pou rankontre li. Li te di l: “Ou oblije antre an relasyon ak mwen aswè a, paske vrèman mwen te achte ou avèk mandragò a fis mwen yo.” Epi li te kouche avèk li nan nwit lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bondye te okipe Léa, e li te fè yon senkyèm fis pou Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Epi Léa te di: “Bondye te ban mwen salè mwen, akoz ke m te bay sèvant mwen an a mari mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Léa te vin ansent ankò, e li te fè yon sizyèm fis pou Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Alò Léa te di: “Bondye te ban mwen yon bon kado! Koulye a mari mwen va rete avè m akoz ke mwen fè sis fis pou li.” Alò li te nonmen li Zabulon. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Apre sa li te fè yon fi, e li te nonmen li Dina. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Alò, Bondye te sonje Rachel. Li te okipe li, e Li te louvri vant li. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Konsa, li te vin ansent, e li te fè yon fis. Konsa, li te di: “Bondye retire repwòch mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Li te rele li Joseph, e li te di: “Ke SENYÈ a ban m yon lòt fis.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Alò, li te rive ke lè Rachel te fè Joseph, Jacob te di a Laban: “Voye mwen ale, pou mwen kapab ale nan pwòp plas mwen e nan pwòp peyi mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ban mwen madanm mwen yo, ak pitit mwen yo, pou sila mwen te sèvi ou yo. Kite mwen pati, paske ou menm ou konnen sèvis ke m te rann ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Men Laban te di li: “Si sa fè ou plezi, rete avè m; mwen devine ke Bondye te beni mwen akoz ou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Li te pale toujou: “Nonmen salè ou, e mwen va ba ou li”. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Men li te di li: “Ou menm ou konnen jan mwen te sèvi ou, ak jan bèt ou yo te byen okipe avè m. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Paske ou pa t gen anpil lè m te vini an, yo vin miltipliye anpil, e SENYÈ a te beni ou tout kote ke m vire. Men koulye a, se lè pou mwen okipe pwòp lakay mwen tou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Epi Laban te di: “Kisa mwen kapab ba ou?” Epi Jacob te reponn: “Ou pa bezwen ban m anyen. Si w ap fè yon sèl bagay pou mwen, mwen va okipe bann ou yo ankò, epi kenbe yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Kite mwen pase nan tout bann mouton ou yo, pou retire chak mouton ki takte, oswa trase, avèk tout sa ki nwa pami ti mouton yo, chak sa ki takte oswa trase pami kabrit yo. Se sa yo ki va sèvi kòm salè mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Konsa entegrite mwen va reponn pou mwen pita, lè ou vin parèt konsènan salè mwen. Chak sa ki pa takte, oswa trase pami kabrit yo, e ki nwa pami jenn mouton yo, si li twouve avè m, konsidere ke mwen te vòlè l.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban te di li: “Sa bon. Kite sa fèt selon pawòl ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Alò, nan menm jou sa a, li te retire tout mal kabrit ki te trase, oswa takte, ak tout femèl kabrit ki te takte, chak ki te gen blan ladann, ak tout nwa pami mouton yo, e li te bay fis li yo okipe yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Epi li te mete yon distans twa jou antre li menm avèk Jacob, e Jacob te bay manje a tout rès bann mouton yo pou Laban. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob te pran bwa vèt nan pye sikrèn, pye zanmann, ak pye bwadòm, e li te kale tras blan nan yo pou fè parèt blan ki te nan bwa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Li te plase bwa li te kale yo devan bann mouton yo, nan flèv dlo yo, e nan basen dlo kote bann mouton yo te vin bwè a. Se la yo te kwaze lè yo te vin pou bwè. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Alò, bann mouton yo te kwaze kote bwa kale yo, e yo te fè pote sa ki te trase, takte e pentle yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob te separe ti mouton yo, e te fè bann mouton yo rete anfas, pou yo t ap gade tout sa ki te trase yo, ak tout nwa yo, ki te nan bann mouton Laban yo. Li te mete pwòp bann mouton li yo apa, pou yo pa t avèk bann mouton Laban yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Anplis de sa, nenpòt kilè bèt ki pi fò nan bann mouton yo ta kwaze, Jacob ta mete bwa yo devan zye a bèt ki nan basen dlo yo, pou yo ta kwaze akote bwa yo; ");
INSERT INTO hatbsa_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","men lè bann mouton an te fèb, li pa t mete yo ladann. Konsa pi fèb yo te vin pou Laban, e pi fò yo pou Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Konsa, nonm nan te vin pwospere anpil. Li te vin gen gwo bann mouton, sèvant ak sèvitè, chamo avèk bourik. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Alò, Jacob te tande pawòl fis Laban yo ki te vin di: “Jacob te retire tout sa ki te pou papa nou, e avèk sa ki te pou papa nou, li te fè tout richès li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob te wè konpòtman Laban, e gade byen, li pa t emab anvè li jan li te ye avan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Epi SENYÈ a te di a Jacob: “Retounen nan peyi a zansèt ou yo, a moun ou yo, e mwen va avèk ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Alò Jacob te voye rele Rachel avèk Léa vè bann mouton li nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Konsa, li te di yo: “Mwen wè ke konpòtman papa nou anvè mwen menm pa emab jan li te ye lontan an, men Bondye a papa m nan te avèk mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nou konnen ke mwen te sèvi papa nou avèk tout fòs mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Malgre sa, papa nou te twonpe mwen, e li te chanje salè mwen dis fwa, men Bondye pa t kite li fè m donmaj. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Si li te pale konsa: ‘Takte yo se salè ou’, alò, tout bann mouton yo te bay pitit takte. Epi si li te pale konsa ke trase yo te salè ou, alò tout bann mouton yo te bay pitit trase. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Konsa Bondye te retire bèt yo nan men papa ou, e Li te ban mwen yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Epi li te rive ke lè bann mouton yo a t ap kwaze, ke mwen te leve zye mwen, mwen te wè nan yon rèv, e gade byen, mal kabrit ki t ap kwaze yo te trase, takte, e mele. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","“Alò, zanj Bondye a te di mwen nan rèv la: ‘Jacob,’ epi mwen te di: ‘Men mwen.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Li te di: ‘Koulye a leve zye ou, pou wè ke tout mal kabrit ki t ap kwaze yo te trase, takte, e mele, paske Mwen te wè tout sa ke Laban te fè ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mwen menm se Bondye a Béthel la, kote ou te vide lwil sou yon pilye, kote ou te fè sèman a Mwen menm nan. Konsa, leve, kite tè sa a, e retounen nan peyi nesans ou a.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel avèk Léa te di li: “Èske nou gen yon pati nan eritaj lakay papa nou an ki rete? ");
INSERT INTO hatbsa_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Èske li pa rekonèt nou kòm etranje? Paske li gen tan vann nou. Anplis, li te manje tout byen nou ranmase. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Vrèman, tout byen ke Bondye te rachte nan men papa nou yo, se pou nou avèk pitit nou ke yo ye. Alò, fè sa ke Bondye te di ou fè a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Alò, Jacob te leve. Li te mete pitit li yo avèk madanm li yo sou chamo yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Konsa, li te voye pouse tout bèt yo avèk tout byen ke li te rasanble yo, bèt ke li te vin gen nan Paddan-Aram yo, pou ale nan peyi Canaan vè papa li, Isaac. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lè Laban te ale pou taye plim mouton li yo, Rachel te vòlè zidòl lakay ki te pou papa li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Konsa, Jacob te twonpe Laban, Arameyen an. Li pa t di li ke li t ap sove ale. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Li te sove ale avèk tout sa ke li te genyen, epi li te leve pou travèse lariviyè Euphrate la, ak figi li byen fikse vè peyi mòn Galaad yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Lè yo te di Laban nan twazyèm jou ke Jacob te sove ale a, ");
INSERT INTO hatbsa_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","li te pran moun fanmi li yo, pou l te kouri dèyè li pandan sèt jou. Konsa, li te vin rive devan li nan ti kolin nan peyi Galaad yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bondye te parèt a Laban, Arameyen an, nan yon rèv nan nwit lan. Li te di li: “Fè atansyon pou ou pa pale a Jacob ni byen, ni mal.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban te vin rive devan Jacob. Alò Jacob te monte tant li nan peyi kolin yo, e Laban avèk moun pa li yo te rete nan peyi kolin Galaad yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Alò, Laban te di a Jacob: “Kisa ou te fè m la a lè ou te twonpe m e fè eskalad avèk fi mwen yo tankou prizonyè ki sou nepe? ");
INSERT INTO hatbsa_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Poukisa ou te sove ale an sekrè? Ou fè m desepsyon sa a, e ou pa di m sa pou m ta kapab voye ou ale avèk jwa, ak chante, tanbouren ak ap? ");
INSERT INTO hatbsa_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ou pa t menm kite m bo fis mwen yo, ak fi mwen yo. Alò, ou gen tan fè betiz. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Li nan pouvwa mwen pou m fè nou mal, men Bondye a papa ou a te pale avèk mwen yèswa. Li te di: ‘Pinga ou pale ni byen, ni mal a Jacob’. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Alò, vrèman ou te sòti paske ou te anvi wè lakay papa ou, men poukisa ou te vòlè dye mwen yo?” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob te reponn Laban: “Akoz ke m te pè, paske mwen te panse ke ou ta rachte fi ou yo nan men mwen pa lafòs. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Sila ki twouve avèk dye ou yo p ap viv. Nan prezans tout fanmi nou yo, montre m sa ki pou ou nan byen mwen yo, e pran li pou ou menm.” Paske Jacob pa t konnen ke Rachel te gen tan vòlè yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Alò, Laban te antre nan tant Jacob la, nan tant Léa a, ak nan tant sèvant yo, men li pa t twouve yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Alò, Rachel te pran zidòl lakay yo. Li te mete yo nan sèl chamo a, e li te chita sou yo. Konsa, Laban te manyen toupatou nan tant lan, men li pa t twouve yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Li te di a papa li: “Pa kite mèt mwen an fache avè m, pwiske mwen p ap ka leve devan ou, paske se règ mwen ki sou mwen.” Alò, li te chache, men li pa t jwenn zidòl kay yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Alò, Jacob te vin fache. Li te konfwonte Laban. Jacob te di l: “Ki tò mwen te fè ou? Ki peche mwen te fè konsa pou ou vin pouswiv mwen tou cho konsa? ");
INSERT INTO hatbsa_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Malgre ou gen tan manyen tout afè m, kisa ou te twouve ladan yo ki pou lakay ou? Mete li isit la devan moun pa m avèk moun pa ou yo, pou yo ka pran yon desizyon antre nou de a. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Pandan ventan mwen te la avè w. Mouton ou yo avèk kabrit ou yo pa janm pèdi pitit, ni mwen pa t manje belye nan bann mouton ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Sa ki te chire pa bèt sovaj, èske m pa te pote yo bay ou? Mwen te fè pèt la pou kont mwen. Se konsa ou te egzije sa ki nan men m, sof ke sa ki vòlè nan lajounen, sof ke sa ki vòlè nan lannwit. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Konsa mwen te ye: Nan lajounen, solèy la te manje m, fredi nan lannwit, e dòmi te vòlè sove ale nan zye mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pandan ven ane sa yo, mwen te lakay ou. Mwen te sèvi ou katòz ane pou de fi ou yo, sis ane pou bann mouton ou yo, e ou te fè chanjman salè mwen dis fwa. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si Bondye a papa m nan, Bondye a Abraham nan pa t pou mwen, vrèman koulye a ou t ap kab voye m ale men vid. Bondye te wè afliksyon mwen, ak travay di ke men m te gen tan fè, epi Li te rann jijman an yèswa.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban te reponn a Jacob: “Fi yo se fi m, pitit yo se pitit mwen, bann mouton yo se bann mouton mwen. Tout sa ou wè la yo se pa m. Men kisa m ka fè nan jou sa pou sila yo, a fi mwen yo, oswa a pitit pa yo ke yo te fè? ");
INSERT INTO hatbsa_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Alò, kounye a vin non, annou fè yon akò, ou menm avèk mwen menm. Annou fè li kòm yon temwen antre ou menm avèk mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Konsa, Jacob te pran yon gwo wòch. Li te fè l kanpe tankou yon pilye. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob te di a tout relasyon fanmi pa li a: “Sanble wòch”! Epi yo te pran wòch yo. Yo te fè yon gwo pil, e yo te manje la akote pil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Alò Laban te rele la Jegar-Sahadutha, men Jacob te rele l Galed. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban te di: “Gwo pil wòch sa se yon temwen antre ou menm avèk mwen menm jodi a.” Konsa, li te rele l Galed, ");
INSERT INTO hatbsa_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","epi osi Mitspa, paske li te di: “Ke Bondye kapab gade antre ou menm avèk mwen lè nou vin absan de youn lòt. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si ou maltrete fi mwen yo, oswa si ou pran madanm anplis ke fi mwen yo, malgre pèsòn pa avèk nou, ou wè, Bondye se temwen antre ou menm avèk mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban te di a Jacob: “Gade byen gwo pil sa a, e veye byen gwo pilye ke m etabli antre ou menm avèk mwen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Gwo pil sa a se yon temwen. Pilye a se yon temwen ke mwen p ap pase vè gwo pil sa a pou fè ou mal, e ou p ap pase gwo pil sa a vè mwen pou fè m mal. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bondye Abraham nan ak Bondye Nachor a, Bondye a papa pa yo a, vin jij antre nou menm.” Konsa Jacob te sèmante pa krent a papa l, Isaac. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Alò, Jacob te ofri yon sakrifis sou mòn nan. Li te rele tout gwo fanmi li yo pou vin manje pen. Yo te manje pen sa a, e yo te pase nwit lan sou mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Granmmaten, Laban te leve. Li te bo fis li yo ak fi li yo, e li te beni yo. Alò, Laban te retounen nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Alò, pandan Jacob te fin pran wout li, zanj Bondye yo te rankontre li. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacob te di lè li te wè yo: “Sa se lame Bondye a.” Konsa, li te nonmen plas sa a Mahanaïm. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Alò, Jacob te voye mesaje yo devan li kote frè li Ésaü nan peyi Séir a nan tèritwa Édom an. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Li te bay mesaje yo lòd, e li te di: “Konsa ou va pale a mèt mwen an, Ésaü: ‘Men sa ke sèvitè ou, Jacob di ou: Mwen te vin rete avèk Laban, e mwen te demere la jis rive koulye a. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Mwen gen bèf avèk bourik, avèk bann mouton, sèvitè avèk sèvant. M ap voye pou di mèt mwen sa, pou m kapab vin jwenn favè nan zye w.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Mesaje yo te retounen vè Jacob. Yo te di li: “Nou te rankontre frè ou Ésaü. Konsa, li ap vin kote ou avèk kat-san òm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Epi Jacob te vin pè anpil, e byen twouble. Li te divize moun ki te avè l yo, bann mouton, twoupo bèf ak chamo pou fè de konpanyen. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Konsa, li te di: “Si Ésaü ta vin atake youn nan konpanyen yo, alò, konpanyen ki rete a va chape.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob te di: “O Bondye a papa m nan Abraham e Bondye a papa m nan Isaac, O SENYÈ ki te di mwen an: ‘Retounen nan peyi ou, e a moun fanmi ou yo, e mwen va fè ou vin pwospere,’ ");
INSERT INTO hatbsa_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","mwen pa merite tout lanmou, mizerikòd ak fidelite ke ou te montre sèvitè ou a; paske se sèl avèk baton mwen ke m te travèse rivyè Jourdain an, men koulye a nou vin de konpanyen. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Delivre mwen, souple anba men frè m nan, anba men Ésaü; paske mwen pè li, pou li pa vin atake mwen avèk manman yo, ak timoun yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Paske ou te di: ‘Anverite, Mwen va fè nou vin pwospere, e fè desandan nou yo vin tankou sab lanmè a, k ap twò gran pou konte.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Epi li te pase nwit lan la. Alò, li te chwazi nan sa li te gen avè l yo kòm yon kado pou frè li, Ésaü: ");
INSERT INTO hatbsa_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","De-san kabrit femèl, ven kabrit mal, de-san femèl mouton, ak ven mal, ");
INSERT INTO hatbsa_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trant chamo ki t ap bay lèt a pitit pa yo, karant bèf avèk dis towo, ven bourik femèl, ak dis ti bourik. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Li te livre yo nan men a sèvitè li yo. Chak ekip te mache pou kont li, e li te di a sèvitè li yo: “Pase devan m, e mete yon espas antre de bann yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Li te kòmande sila ki te devan an e li te di li: “Lè frè m Ésaü vin rankontre ou, e mande ou: ‘Pou kilès ou ye, kibò w prale, e pou kilès bèt sa yo ki devan ou yo ye?’ ");
INSERT INTO hatbsa_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Alò, ou va di: ‘Se pou sèvitè ou, Jacob. Se yon kado ke li voye bay mèt mwen, Ésaü. Men gade byen, li la dèyè nou.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Li te kòmande osi a dezyèm nan, a twazyèm nan, ak tout sa ki te swiv ekip yo, e li te di: “Se konsa nou va pale avèk Ésaü lè nou rankontre li. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ou va di: ‘Gade, men sèvitè ou Jacob dèyè nou an tou.’ Paske li te di: ‘Mwen va satisfè li avèk kado ki ale devan m yo. E apre, mwen va wè figi li. Petèt li kapab aksepte mwen.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Epi kado a te pase devan li, e li menm te pase nwit lan menm kote li te fè kan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Alò, li te leve pandan menm nwit lan, e li te pran de madanm li yo avèk de sèvant li yo, onz pitit li yo, e li te travèse lariviyè a bò kote Jabbok la. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Li te pran yo, e li te voye yo travèse dlo a. Konsa, li te voye travèse ak tout sa li te genyen. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Konsa, Jacob te rete tout sèl, e yon nonm te vin lite avèk li jis rive granmmaten. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Lè li te wè ke li pa t genyen l, li te touche gwo jwenti janm li (anwo kote l tache nan kò a), epi li te vin dejwente pandan li t ap lite avè l. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Epi nonm nan te di: “Lage m, paske jou a pwòch.” Men Jacob te di: “Mwen p ap lage ou amwenske ke ou beni m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Alò, li te di li: “Kòman yo rele ou?” Li te reponn: “Jacob.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Li te di: “Yo p ap rele ou Jacob ankò, men Israël; paske ou te lite avèk Bondye, e avèk lòm, epi ou te reyisi.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Alò Jacob te mande li: “Souple, di m non ou.” Li te reponn: “Poukisa ou mande m non mwen?” Epi li te beni li la. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Konsa, Jacob te nonmen kote sa Peniel, paske li te di: “Mwen te wè Bondye fasafas, malgre sa, vi mwen te prezève.” ");
INSERT INTO hatbsa_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Alò, solèy la te leve sou li nan menm moman li t ap travèse Peniel la, e li te bwate akoz gwo janm nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Pou sa, jis jounen jodi a, fis Israël yo pa manje tandon ki tache nan gwo janm nan avèk anch ki sou jwenti a, akoz ke li te touche jwenti gwo janm nan tandon ki tache nan anch lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Alò, Jacob te leve zye li. Li te gade, e gade byen, Ésaü t ap vini, ak kat-san òm avèk li. Konsa, li te divize pitit yo pami Léa avèk Rachel avèk de sèvant yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Li te mete sèvant li yo devan, Léa avèk pitit li yo dèyè yo, e Rachel avèk Joseph an dènye. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Men li menm te pran devan yo. Li te bese jis atè sèt fwa, jiskaske li te rive toupre frè li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ésaü te kouri al jwenn li. Li te anbrase li, te tonbe nan kou li e li te bo li. Konsa, yo te kriye. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Li te leve zye li pou wè fanm yo, e li te di: “Se kilès? Sila yo ki avèk ou la a?” Epi Jacob te di: “Pitit ke Bondye nan gras li te bay sèvitè ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Alò, sèvant lakay yo te vin pwoche avèk pitit pa yo, e yo te bese ba. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Léa tou te apwoche avèk pitit li yo. Yo te bese ba. Apre, Joseph te vini avèk Rachel, e yo te bese ba. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ésaü te di: “Kisa ou vle di ak tout ekip sa yo ke m rankontre la a?” Jacob te reponn: “Pou jwenn favè nan zye a mèt mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Men Ésaü te di: “Mwen gen kont mwen, frè m; kite sa ou genyen yo rete pou ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob te di: “Non, souple, si koulye a mwen twouve favè nan zye ou, alò, pran kado a nan men m, paske mwen wè figi ou tankou yon moun ki vin wè figi a Bondye, e ou te byen resevwa m. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Souple, pran kado ki te pote pou ou a, paske Bondye te aji avèk gras anvè mwen, e akoz sa m gen anpil:” Konsa, li te vin ankouraje l, e li te aksepte li. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Konsa, Esaü te di: “Annou fè vwayaj nou. Ann ale, e mwen va ale devan nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Men Jacob te di li: “Mèt mwen, ou konnen ke timoun yo frajil, e ke bann mouton avèk twoupo k ap bay tete yo se yon tèt chaje pou mwen. Si yo pouse twòp, menm pou yon jou, yo va mouri. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Souple, kite mèt mwen an pase devan sèvitè li. Mwen menm mwen va avanse pi dousman, selon nesesite bèt ki devan m yo, ak selon vitès a timoun yo, jis lè m rive vè mèt mwen an nan Séir.” ");
INSERT INTO hatbsa_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ésaü te di: “Souple, kite mwen ba ou kèk nan moun ki avè m yo.” Men li te di: “Poukisa ou fè sa? Kite mwen jwenn favè nan zye a mèt mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Konsa, Ésaü te fè wout li pou Séir menm jou sa a. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob te vwayaje a Succoth. Li te bati pou li menm yon kay, e li te fè pak pou tout bèt li yo, epi pou sa, yo rele plas la Succoth. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Alò, Jacob te rive san pwoblèm nan vil Sichem nan peyi Canaan, lè li te sòti Paddan-Aram. Li te fè kan an devan vil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Li te achte yon mòso tè kote li te monte tant li nan men fis Hamor yo, papa Sichem nan, pou sòm a san pyès lajan. ");
INSERT INTO hatbsa_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Alò, la li te monte yon lotèl, e li te rele li El-Elohé-Israël. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Alò, Dina, fi Léa te fè pou Jacob la te sòti pou vizite fi peyi yo nan kote sa a. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Lè Sichem, fis Hamor a, Evyen an, prens nan peyi a te wè li, li te pran li, e pa lafòs, li te kouche avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Li te vrèman atire a Dina, fi Jacob la. Li te renmen fi a, e li te pale ak dousè avè l. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Alò, Sichem te pale avèk papa l Hamor. Li te di: “Fè m jwenn jèn fi sa a pou madanm.” ");
INSERT INTO hatbsa_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Alò, Jacob te tande ke li te vyole Dina, fi li a, men fis li yo te avèk bèt yo nan chan an. Alò, li te rete san pale jis lè yo te vin antre. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, papa a Sichem, te vin deyò a pou pale avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Alò, fis a Jacob yo te sòti nan chan an lè yo te tande koze sa a. Konsa, mesye yo te blese. Yo te vin byen fache, akoz ke li te fè yon choz meprizab an Israël lè li te kouche avèk fi Jacob la, paske yon bagay konsa pa t dwe fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Men Hamor te pale avèk yo. Li te di: “Nanm fis mwen an, Sichem anvi fi ou a anpil. Pou sa, silvouplè, ba li li pou yo marye. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Annou marye yo youn pou lòt. Bay fi ou yo a nou menm, e pran fi nou yo pou ou menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Konsa, ou va viv avèk nou, e peyi a va vin ouvri devan nou. Viv ladann, e fè afè nou yo ladann.” ");
INSERT INTO hatbsa_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sichem te di osi a papa ak frè a Dina, “Kite mwen twouve favè nan zye nou. Konsa, mwen va bannou nenpòt sa ke nou mande m. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mande m tan kòm pèyman avèk kado, e mwen va bannou nenpòt sa nou mande mwen, men ban mwen fi a pou marye.” ");
INSERT INTO hatbsa_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Konsa, fis Jacob yo te reponn Sichem avèk papa li Hamor avèk desepsyon, akoz ke li te vyole Dina, sè yo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yo te di yo: “Nou pa kapab fè bagay sa a, pou bay sè nou an a yon moun ki pa sikonsi. Sa ta yon wont pou nou tout. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sou yon sèl kondisyon nou ta kapab dakò: si nou va vini tankou nou. Sa vle di ke chak mal nan nou ta vin sikonsi. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Konsa, nou va bay sè nou yo a nou menm, nou va viv avèk nou e vin yon sèl pèp. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Men si nou pa koute nou pou vin sikonsi, alò, n ap pran sè nou an e ale.” ");
INSERT INTO hatbsa_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Alò, pawòl pa yo a te parèt rezonab a Hamor avèk Sichem, fis Hamor a. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Jennonm sa a pa t pèdi tan pou fè bagay la, paske li te tèlman kontan avèk fi Jacob la. Epi li te jwenn respè depase tout moun ki lakay papa li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Konsa, Hamor, avèk fis li a, Sichem te vini nan pòtay vil yo, li te pale avèk mesye nan vil yo, e li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Moun sa yo se zanmi nou yo ye; pou sa, annou kite yo viv nan peyi a pou fè komès ladann, paske, gade byen, peyi a ase gran pou yo. Annou pran fi yo an maryaj, e bay fi nou yo a yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","“Se sèl sou kondisyon sa a ke moun sa yo va vin dakò pou vin viv avèk nou, pou vin yon sèl pèp; ke chak mal pami nou vin sikonsi tankou yo menm tou deja sikonsi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Se pa ke bèt, byen ak tout zannimo yo va vin pou nou? Sèlman annou vin dakò avèk yo, e yo va viv avèk nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tout sa yo ki te sòti nan pòtay lavil la te koute Hamor, avèk fis li a, Sichem. Konsa, chak mal te sikonsi, tout moun ki te sòti nan pòtay vil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Alò, li te rive nan twazyèm jou a, lè yo te nan doulè, de nan fis a Jacob yo, Siméon avèk Lévi, frè a Dina yo, yo chak te pran nepe yo. Yo te vini sou vil la san yo pa konnen, e yo te touye tout mal yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Yo te touye Hamor avèk fis li a, Sichem, avèk lam file a nepe yo. Yo te pran Dina soti lakay Sichem nan, e yo te ale. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Fis Jacob yo te vini sou mò yo. Yo te piyaje vil la akoz ke yo te vyole sè yo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Yo te pran bann mouton, twoupo ak bourik, sa ki te nan vil la, ak sa ki te nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Epi yo te kaptire e piyaje tout byen yo, tout pitit yo, madanm yo, menm tout sa ki te lakay yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Alò Jacob te di a Siméon avèk Lévi: “Nou vin pote pwoblèm pou mwen akoz ke nou fè m vin rayi pa abitan peyi yo, pami Kananeyen avèk Ferezyen yo. Epi akoz ke gason nou yo pa anpil, yo va rasanble kont mwen, pou atake mwen, e mwen va vin detwi, mwen menm avèk tout lakay mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Men yo te di: “Èske yo ta dwe trete sè nou an tankou yon pwostitiye?” ");
INSERT INTO hatbsa_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Alò, Bondye te di a Jacob: “Leve ale Béthel e rete la. Fè yon lotèl la pou Bondye ki te parèt devan ou lè ou te sove ale sou frè ou a, Ésaü.” ");
INSERT INTO hatbsa_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Alò, Jacob te di moun lakay li yo, ak tout sa ki te avè l yo: “Mete deyò tout dye etranje yo ki pami nou, pirifye nou, e chanje rad nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Annou leve monte Béthel. Mwen va fè yon lotèl la pou Bondye, ki te reponn mwen nan jou detrès mwen an, e ki te avèk mwen nan tout kote ke m te konn ale yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Alò, yo te bay Jacob tout dye etranje ke yo te genyen yo, ak zanno ki te nan zòrèy yo, e Jacob te antere kache yo anba chenn ki te toupre Sichem nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Pandan yo t ap vwayaje, yon gwo laperèz te vin sou vil ki te ozanviwon yo, e yo pa t swiv fis a Jacob yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Alò, Jacob te vini Luz (sa vle di, Béthel), ki nan peyi Canaan an, li menm avèk tout moun ki te avèk li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Li te bati yon lotèl la, e li te rele plas la, El-Béthel, akoz ke se la Bondye te revele Li menm a li lè li te sove ale kite frè l la. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Alò, Débora, nouris Rebecca a, te mouri, e li te antere anba Béthel anba chenn nan. Bwa sa a te rele Allon-bacuth (ki vle di chenn k ap kriye a). ");
INSERT INTO hatbsa_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Alò, Bondye te vin parèt a Jacob ankò lè li te sòti Paddan-Aram, e Li te beni li. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Bondye te di li: “Non ou se Jacob. Yo p ap rele ou Jacob ankò, men Israël va non ou.” Konsa li te rele li Israël. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Bondye osi te di li: “Mwen se Bondye Toupwisan an. Fè fwi, e vin miltipliye. Yon nasyon ak yon gwo konpanyen nasyon va soti nan ou, e wa yo va sòti nan ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Peyi ke M te bay Abraham, ak Isaac la, Mwen va ba ou li, ak desandan apre ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Konsa, Bondye te monte kite li nan plas kote Li te pale avèk li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob te etabli yon pilye nan plas kote Li te pale avèk li a, yon pilye wòch. Li te vide yon bwason kòm ofrann sou li; epi osi li te vide yon lwil sou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Alò, Jacob te nonmen plas kote Bondye te pale avèk li a Béthel. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yo te vwayaje sòti Béthel. Lè te toujou gen yon distans pou rive Éphrata, Rachel te kòmanse fè pitit li, e li te soufri yon doulè ki te difisil. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Lè li te nan doulè rèd konsa, fanm saj la te di l: “Pa pè koulye a, paske ou va gen yon lòt gason.” ");
INSERT INTO hatbsa_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Li te rive, ke pandan nanm li t ap pati (paske li t ap mouri), ke li te nonmen li Ben-Oni; men papa li te rele li Benjamin. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel te mouri e li te antere nan wout pou ale Éphrata a (sa vle di, Bethléem). ");
INSERT INTO hatbsa_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob te monte yon pilye sou tonm li an, e sa se pilye a tonm Rachel jiska jounen jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israël te avanse e li te monte tant li an pi lwen tou Migdal-Éder a. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Konsa, li te rive ke pandan Israël t ap viv nan peyi a, Reuben te ale kouche avèk Bilha, youn nan fanm a papa li yo, e Israël te tande koze sa a. Alò, te gen douz fis fèt pa Jacob— ");
INSERT INTO hatbsa_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","fis a Léa yo: Reuben, premye ne a Jacob la, ak Siméon, Lévi, Juda, Issacar avèk Zabulon, ");
INSERT INTO hatbsa_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","fis a Rachel yo: Joseph avèk Benjamin; ");
INSERT INTO hatbsa_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","fis a Bilha yo, sèvant Rachel la: Dan avèk Nephthali; ");
INSERT INTO hatbsa_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","fis Zilpa yo, sèvant Léa a: Gad avèk Aser. Sa yo se fis Jacob yo ki te fèt a li menm nan Paddan-Aram. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob te vini vè papa li, Isaac nan Mamré pou Kirjath-Arba (ki se Hébron), kote Abraham avèk Isaac te demere a. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Alò, jou Isaac yo te san-katre-ven ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isaac te rann dènye souf li. Li te mouri, e li te rasanble vè moun li yo, yon granmoun anpil laj. Konsa, Ésaü avèk Jacob te antere li. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Alò, sa yo se achiv jenerasyon Ésaü yo, (sa vle di, Edom). ");
INSERT INTO hatbsa_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ésaü te pran madanm pami fi Canaan yo: Ada, fi Elon an, Etyen an, Oholibama, fi Ana a, ak gran fi a Tsibeon an, Evyen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Anplis, Basamath, fi Ismaël la, sè Nebajoth la. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada te fè Eliphaz bay Ésaü, e Basamath te fè Réuel; ");
INSERT INTO hatbsa_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Epi Oholibama te fè Jéusch, Jaelam, ak Koré. Sa yo se fis Ésaü ki te fèt a li menm nan peyi Canaan. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Epi Ésaü te pran madanm li yo, fis ak fi li yo avèk tout lakay li, bèt li yo avèk tout bèf li yo, ak tout byen ke li te ranmase nan peyi Canaan yo, e li te ale nan yon lòt peyi, lwen frè li a, Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Paske byen yo te vin twò gran pou yo ta viv ansanm, e peyi kote yo te demere a pa t kab pran yo akoz tout bèt yo te genyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Konsa, Ésaü te viv nan peyi kolin yo nan Séir. Ésaü se menm avèk Édom. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Alò, sa yo se achiv a jenerasyon Ésaü yo, papa a Edomit yo nan peyi kolin yo nan Séir. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Alò men non a fis Ésaü yo: Éliphaz, fis Ada a madanm Ésaü a, Réuel, fis Basamath la, madanm a Ésaü a. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Fis Éliphaz yo te: Théman, Omar, Tsepho, Gaetham, ak Kenaz. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Thimna te fanm lakay Éliphaz, fis Ésaü a; li te fè Amalek pou Éliphaz. Sila yo se fis Ada yo, madanm Ésaü a. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Sa yo se fis Réuel yo: Nahath, Zérach, Schamma, ak Mizza. Sa yo se te fis Basamath yo, madanm Ésaü a. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Sa yo se te fis madanm Ésaü a, Oholibama, fi Ana a, ki te pitit pitit Tsibeon an: li te fè pou Ésaü, Jéusch, Jaelam, ak Koré. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Men chèf a fis Ésaü yo. Fis Éliphaz yo, premye ne Ésaü a, se chèf Théman, chèf Omar, chèf Tsepho, chèf Kenatz, ");
INSERT INTO hatbsa_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","chèf Koré, chèf Gaetham, chèf Amalek. Sa yo se chèf ki te desandan Eliphaz nan peyi Edom an. Sa yo se fis a Ada yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Men fis Réuel, ki te fis Ésaü yo: chèf Nahath, chèf Zérach, chèf Schamma, chèf Mizza. Sa yo se chèf ki te desandan a Réuel yo, nan peyi Edom an. Sa yo se fis a Basamath, madanm a Ésaü a. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Sa yo se fis a Oholibama yo, madanm a Ésaü a; chèf Jéusch, chèf Jaelam, chèf Koré. Sa yo se chèf ki te desandan pa Oholibama a, madanm a Ésaü a, fi a Ana a. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sila yo se fis a Ésaü yo (sa vle di Édom), e sa yo se chèf yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sila yo se fis Séir yo, Oryen an, pèp peyi a: Lothan, Schobal avèk Tsibeon ak Ana, ");
INSERT INTO hatbsa_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","epi Dischon, Etser avèk Dischan. Sa yo se te chèf a Oryen yo, fis Séir yo, nan peyi Édom an. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Fis a Lothan yo se te Hori avèk Hémam. Sè a Lothan an se te Thimna. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Men fis a Schobal yo: Alvan, Manahath, Ébal, Schepho, avèk Onam. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Men fis a Tsibeon yo: Ajja ak Ana. Se te Ana ki te twouve sous cho nan dezè a lè l t ap fè gadyen bourik yo pou papa l, Tsibeon. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Men pitit a Ana yo: Dischon avèk Oholibama, fi a Ana a. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Men fis Dischon yo: Hemdan, Eschban, Jithran, avèk Keran. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Men fis a Etser yo: Bilhan, Zavvan avèk Akan. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Men fis a Dischan yo: Uts avèk Aran. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Men chèf Oryen yo: chèf Lothan, chèf Schobal, chèf Tsibeon, ak chèf Ana, ");
INSERT INTO hatbsa_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","chèf Dischon, chèf Etser, chèf Dischan. Sa se chèf a Oryen yo, chèf ki te nan peyi Séir yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Men wa ki te renye nan peyi a Édom yo, avan ke yon wa te vin renye pami zanfan Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla, fis Beor, te renye sou Édom; epi non vil pa l la te Dinhaba. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla te mouri e Jbab, fis Zérach, a Botsra te renye nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jbab te vin mouri; epi Huscham nan peyi Temanit yo te renye nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Huscham te mouri; epi Hadad, fis a Bedad la te vin renye nan plas li. Se te li menm ki te frape Madian nan chan Moab la. Non a vil sa a se te Avith. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad te mouri; epi Samia ak Masréka te vin renye nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samia te mouri; epi Saül ak Rehoboth sou larivyè Euphrate la te vin renye nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saül te mouri; epi Baal-Hanan, fis Acbor a te vin renye nan plas li. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanan, fis Acbor te mouri, epi Hadar te vin renye nan plas li. Non a vil sa a se te Pau; epi non madanm li te Mehéthabeel, fi a Mthred, fi a Mézahab la. ");
INSERT INTO hatbsa_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Men non a chèf ki te desandan Ésaü yo, selon tribi yo, selon teritwa yo, pa non yo; chèf Timna, chèf Alva, chèf Jetheth, ");
INSERT INTO hatbsa_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","chèf Oholibama, chèf Éla, chèf Pinon, ");
INSERT INTO hatbsa_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","chèf Kenaz, chèf Théman, chèf Mibtsar, ");
INSERT INTO hatbsa_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","chèf Magdiel, chèf Iram. Sa se chèf Édom yo (sa vle di pou Ésaü, papa a Edomit yo), selon abitasyon yo, ak peyi yo te posede yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Alò, Jacob te viv nan peyi kote papa li te konn demere a, nan peyi Canaan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Sa yo se achiv a jenerasyon Jacob yo. Joseph, lè l te gen laj dis-sèt ane, li t ap okipe bann mouton an avèk frè l yo, pandan li te toujou nan jennès li, ansanm avèk fis Bila yo, ak fis Zilpa yo, madanm a papa l yo. Epi Joseph te pote yon move rapò sou yo, bay papa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Alò, Israël te renmen Joseph plis ke tout lòt fis li yo, akoz ke li te fèt nan vyeyès li; epi li te fè pou li yon vètman plen tout koulè. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Frè li yo te wè ke papa yo te renmen li plis ke tout frè li yo. Konsa, yo te vin rayi li, e yo pa t kapab pale avèk li an amitye. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Alò, Joseph te fè yon rèv, e lè l te repete l bay frè l yo, konsa, yo te vin rayi li plis. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Li te di yo: “Souple, koute rèv sa a ke m te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Gade byen, nou t ap mare pakèt rekòlt yo nan chan an, e gade byen, pakèt pa nou yo te vin antoure pa m nan e yo te vin bese devan pakèt pa mwen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Alò, frè li yo te di li: “Èske vrèman ou ap vin renye sou nou? Oswa èske ou ap vin gouvène sou nou?” Epi yo te vin rayi li plis pou rèv li yo, ak pawòl li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Alò li te vin fè yon rèv toujou, li te eksplike li bay frè li yo. Li te di: “Gade, mwen te fè yon lòt rèv; e gade byen, solèy la, lalin lan avèk onz zetwal yo t ap bese ba devan mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Li te eksplike li bay papa li avèk frè li yo. Papa li te reprimande li e te di l: “Kisa sa ye, rèv sa ou te fè a? Èske mwen, manman ou avèk frè ou yo vrèman ap vin bese atè devan ou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Frè li yo te fè jalouzi akoz li, men papa li te kenbe pawòl sa yo nan tèt li. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Epi frè li yo te ale mennen bann mouton an Sichem. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israël te di Joseph: “Èske frè ou yo p ap okipe bann mouton an Sichem? Vini pou mwen ka voye ou bò kote yo.” Epi li te reponn: “Mwen va ale”. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Alò, li te di li: “Ale koulye a pou okipe afè frè ou yo ak afè bann mouton an, e vin pote nouvèl ban mwen.” Epi li te ale nan vale Hébron an e li te rive Sichem. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Yon mesye te twouve li, e gade byen, li t ap mache toupatou nan chan an. Konsa, mesye a te mande li: “Kisa w ap chache?” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Li te di: “Mwen ap chache frè m yo. Souple, fè m konnen kote yo ap fè patiraj pou bann mouton an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Alò, mesye a te di: “Yo te deplase isit la, paske mwen te tande yo di: ‘Annou ale Dothan.’” Epi Joseph te swiv frè li yo, e li te twouve yo Dothan. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Lè yo te wè li depi nan distans, e avan li te parèt kote yo, yo te fè konplo pou mete li a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Yo te di youn ak lòt: “Men sila ki fè rèv la ap vini! ");
INSERT INTO hatbsa_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Alò, koulye a, annou touye li e jete li nan youn nan fòs yo, e nou va di: ‘yon bèt sovaj te devore li.’ Koulye a annou wè kisa rèv li yo ap devni!” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Men Reuben te tande sa, li te retire li nan men yo, e li te di: “Annou pa pran lavi li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Reuben te di yo anplis de sa: “Pa vèse san. Jete li nan twou sila ki nan dezè a, men pa mete men sou li” —akoz lentansyon li te gen pou fè l chape nan men yo, pou l ta kapab remèt li bay papa l. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Alò li te rive ke lè Joseph te rive kote frè li yo, yo te retire vètman an sou li, (sa ki te gen anpil koulè ladann nan); ");
INSERT INTO hatbsa_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","epi yo te pran li e yo te jete li nan fòs la. Alò fòs la te vid e li pa t gen dlo ladann. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Alò, yo te chita pou manje yon manje. Epi pandan yo te leve zye yo, yo te gade, e vwala, yon ekip Izmayelit ki t ap sòti Galaad, avèk chamo ki t ap pote yon chaj gòm awomatik, bòm avèk mè pou rive an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Juda te di a frè li yo: “Ki avantaj sa ye si nou touye frè nou an, e kache san li? ");
INSERT INTO hatbsa_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Vini, annou vann li bay Izmayelit yo e annou pa mete men nou sou li, paske li se frè nou, pwòp chè nou.” Epi frè li yo te koute li. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Alò, kèk nan machann Madyanit yo te pase, epi frè l yo te rale li soti nan fòs la e te vann li bay Izmayelit yo pou ven sik lajan. Konsa yo te mennen Joseph antre an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Alò, Reuben te retounen nan fòs la, e gade byen, Joseph pa t la nan fòs la; epi li te chire rad li. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Li te retounen vè frè li yo e te di: “Ti gason an pa la non; e pou mwen menm, kibò pou m ale?” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Konsa, yo te pran vètman Joseph la, yo te kòche yon mal kabrit, e yo te tranpe vètman an nan san an. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Yo te voye vètman anpil koulè a pote li bay papa yo e yo te di: “Nou te twouve sa a. Souple, gade l byen e wè si se vètman a fis ou a oswa non.” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Li te egzamine li e te di: “Se vètman fis mwen an. Yon bèt sovaj gen tan devore li. Joseph vrèman gen tan chire an mòso!” ");
INSERT INTO hatbsa_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Alò, Jacob te chire rad li, li te mete twal sak nan ren li, e li te pase anpil jou ap lamante pou fis li a. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Alò, tout fis li yo, ak tout fi li yo te leve pou konsole li, men li te refize konsole. Epi li te di: “Vrèman mwen va desann kote fis mwen an, kote sejou mò yo ak lamante pou fis mwen an.” Epi papa li te kriye pou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Antretan, Madyanit yo te vann li an Égypte a Potiphar, ofisye Farawon an, chèf nan kò gad la. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Epi li te vin rive nan lè sa a ke Judas te kite frè l yo, pou te vizite yon sèten Adilamit ki te rele Hira. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","La, Juda te wè fi a yon sèten Kananeyen ki te rele Schua. Li te pran li e te antre an relasyon ak li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Konsa, li te vin ansent, li te fè yon fis, e li te nonmen li Er. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Epi li te vin ansent ankò, li te bay yon fis, ki te nonmen Onan. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Li te fè toujou yon lòt fis, e li te nonmen li Schéla. Li te nan Czib lè li te fè li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Alò, Juda te pran yon madanm pou Er, premye ne li a, e non li te Tamar. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Men Er, premye ne a Juda a te mechan nan zye a SENYÈ a e SENYÈ a te pran vi li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Konsa, Juda te di a Onan: “Antre an relasyon ak madanm a frè ou a; fè devwa ou kòm bòfrè li, e fè leve yon posterite pou frè ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan te konnen ke posterite sa yo pa t ap pou li. Konsa, li te jete jèm li an atè pou li pa fè pitit pou frè li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Men sa li te fè a pa t fè SENYÈ a plezi. Li te pran vi li tou. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Alò Juda te di a bofi li, Tamar: “Rete kòm vèv lakay papa ou jiskaske fis mwen an, Schéla fin grandi.” Paske li te reflechi: “Mwen pè pou li menm tou pa ta kapab mouri menm jan ak frè li yo.” Epi Tamar te ale viv lakay papa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Alò, apre yon tan konsiderab, fi Schua a, madanm a Juda, te mouri. Epi lè tan tristès a lanmò a te fini, Juda te monte vè ouvriye ki t ap taye lenn mouton bò kote Thimna yo, li menm avèk zanmi li, Hira, Adilamit lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Konsa, yo te di a Tamar: “Veye byen, bòpè ou ap monte vè Thimna pou taye lenn mouton li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Alò, li te retire vètman vèv li a, li te kouvri tèt li avèk yon vwal, li te vlope tèt li, e li te chita nan pòtay Énaïm nan, ki nan wout pou rive Thimna. Paske li te wè ke Shéla te fin grandi, e yo pa t vin prezante li devan li kòm madanm. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Lè Juda te wè l, li te panse ke li te yon pwostitiye, paske li te kouvri figi li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Konsa, li te vire bò kote li nan wout la, e li te di: “Alò, kite m antre an relasyon ak ou.” Paske li pa t konnen ke li te bèlfi li. Epi fi a te di: “Kisa w ap ban m pou ou ka antre an relasyon ak mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Li te di konsa: “Mwen va voye ba ou yon jèn kabrit ki sòti nan twoupo a.” Men li te di: “Èske ou va ban m yon bagay kòm yon sèman pou jis lè ou voye l?” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Li te di: “Kisa pou m ta bay ou?” Epi li te di: “Ban m so, kòd avèk baton ki nan men ou an.” Konsa, li te bay yo a li menm. Li te antre an relasyon ak li, e vèv la te vin ansent pa li menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar te leve ale. Li te retire vwal la, e li te remete vètman a vèv yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Lè Juda te voye jèn kabrit la ak zanmi li, Adilamit lan, pou resevwa sa ke li te bay kòm sèman an, li pa t twouve li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Li te mande mesye yo kote a: “Kote jennès tanp lan ki te akote wout la nan Énaïm nan?” Men yo te di li: “Pa t gen jennès tanp isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Li te retounen a Juda, e te di: “Mwen pa t twouve li. Anplis de sa, mesye nan zòn di ke: ‘Pa t gen yon jennès tanp nan zòn sa a.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda te di l: “Kite li pran yo pou kont li, sinon n ap vin yon betiz devan tout moun. Anfen, mwen te voye jèn kabrit sa a, men ou pa t twouve li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Alò, li te anviwon twa mwa pita ke Juda te enfòme: “Bèlfi ou Tamar te jwe wòl jennès la. Gade byen, li vin ansent nan koze sa a.” Konsa, Juda te di: “Mete li deyò e kite yo brile li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Epi pandan yo t ap mete li deyò, li te voye kote bòpè li pou di: “Mwen avèk pitit pa mesye ki se mèt a bagay sa yo.” Anplis, li te di: “Souple, fè yon ankèt pou vin aprann pou kilès so siyal sila a ye, e pou kilès kòd avèk baton sila yo ye?” ");
INSERT INTO hatbsa_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda te rekonèt yo, e te di: “Li pi jis pase mwen, paske mwen pa t bay li fis mwen an, Schéla.” Epi li pa t gen relasyon avèk li ankò. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Li te vin rive nan lè ke li t ap akouche a, gade byen, te gen jimo nan vant li. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Anplis de sa, li te rive pandan li t ap akouche a ke youn te lonje yon men deyò, e fanm saj la te mare yon fisèl wouj sou men l. Li te di: “Se sila a ki sòti avan”. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Men li te vin rive ke pandan li t ap rale men l tounen, frè l la te sòti avan. Epi li te di: “A la chemen ou gen tan fè pou kont ou!” Konsa, li te nonmen li Pérets. ");
INSERT INTO hatbsa_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Apre, frè l la te vin sòti avèk fisèl wouj mare nan men l, e li te nonmen li Zerah. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Alò, yo te pran Joseph desann an Égypte. Epi Potiphar, yon ofisye Farawon, kòmandan nan gad yo, te achte li nan men Izmayelit yo, ki te fè l desann la. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","SENYÈ a te avèk Joseph, e li te byen reyisi. Li te lakay mèt li, Ejipsyen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Alò mèt li a te wè ke SENYÈ a te avèk li, e ke li te fè tout sa li te antreprann byen reyisi nan men l. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Konsa, Joseph te twouve favè nan zye li, e li te devni sèvitè pèsonèl li. Li te fè li chèf an tèt tout lakay li, e tout sa ke li te posede, li te mete yo sou chaj li. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Epi li te rive ke depi lè sa a li te fè li chèf lakay li, ak sou tout sa li te posede, ke SENYÈ a te beni lakay Ejipsyen an akoz Joseph. Benediksyon SENYÈ a te sou tout sa li te genyen, ni nan kay la, ni nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Li te kite tout sa li te gen sou chaj Joseph. Konsa, li pa t okipe tèt li avèk anyen sof ke manje ke li te manje. Alò, Joseph te yon bo gason, ni nan fòm li, ni nan aparans li. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Li te vin rive apre evènman sa yo, ke madanm Potiphar a, te gade Joseph avèk anvi. Konsa, li te di: “Vin kouche avè m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Men Joseph te refize. Li te di a madanm mèt li a: “Mèt mwen pa menm okipe li pou anyen ki nan kay la, e li te mete tout sa li posede sou chaj mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nanpwen pèsòn nan kay sa a ki pi gran ke mwen, e li pa refize m anyen, sof ke ou menm, paske ou se madanm li. Kijan konsa, mwen ta kapab fè gwo mal sa a, e peche kont Bondye menm?” ");
INSERT INTO hatbsa_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Pandan li te pale avèk Joseph jou aprè jou, Joseph pa t koute l menm pou kesyon kouche avè l, oswa pou li ta rete avè l. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Alò li vin rive yon jou ke li te antre nan kay la pou fè travay li, e pa t gen lòt nan ouvriye lakay yo ki te andedan kay la. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Konsa, Madanm nan te kenbe li pa vètman li. Li te di: “Kouche avè m!” Men li te kite vètman li nan men l, e te sove ale deyò. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Lè Madanm nan te vin wè ke li te kite vètman li nan men l, e li te kouri deyò, ");
INSERT INTO hatbsa_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","li te rele tout gason ouvriye lakay li yo, e li te di yo: “Ou wè sa, li pote bannou yon Ebre ki pou vin fè jwèt avèk nou. Li te vin antre sou mwen pou kouche avè m, men mwen te rele fò. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Lè li tande ke m te leve vwa m pou rele fò, li te kite vètman li bò kote mwen, e li te sove ale kouri deyò.” ");
INSERT INTO hatbsa_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Konsa, li te kenbe vètman an kote li jiskaske mèt li te rive nan kay la. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Alò, li te pale avèk li ak pawòl sa yo: “Esklav Ebre ke ou te mennen bannou an, te antre kote mwen pou fè spò avè m, ");
INSERT INTO hatbsa_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","men lè m te leve vwa m pou te rele fò, li te kite vètman li bò kote mwen pou te sove ale deyò.” ");
INSERT INTO hatbsa_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Alò, lè mèt la te tande pawòl a madanm li yo, lè li te pale pou di: “Men sa esklav ou a te fè m nan,” li te vin brile avèk kòlè. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Konsa, mèt Joseph la te pran li e te mete li nan prizon, nan plas kote prizonye ki pou wa yo te ye. Epi li te la nan prizon an. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Men SENYÈ a te avèk Joseph. Li te fè li gras, e Li te fè li vin gen favè nan zye a chèf prizon an. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Chèf Kasèl la te fè Joseph responsab tout prizonye yo ki te nan prizon an, jiskaske nenpòt sa ki te fèt ladann, li te vin responsab. ");
INSERT INTO hatbsa_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Chèf Kasèl la pa t sipèvize anyen ki te anba direksyon Joseph, paske SENYÈ a te avèk li, paske nenpòt sa li te fè, SENYÈ a te fè l pwospere. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Alò, li te vin rive apre bagay sa yo ke chèf ki te responsab pran avan gou diven an pou wa a, ansanm ak bòs boulanje a wa a te fè yon ofans kont mèt yo, Wa a Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farawon te vin plen ak kòlè sou ofisye sa yo, chèf ki responsab pote tas la, avèk bòs boulanje a. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Alò li te sere yo nan prizon lakay Kaptenn a kò gad la, menm kote ke Joseph te anprizone a. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kaptenn kò gad la te mete Joseph an chaj yo, pou li te okipe yo. Konsa, yo te nan prizon an pou kèk tan. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Epi pandan tan sa a, toude moun sa yo, chèf ki te responsab pran avan gou diven an, ak bòs boulanje a wa a, te fè yon rèv nan menm nwit lan. Chak moun te fè pwòp rèv pa li, e chak rèv te gen pwòp entèpretasyon pa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Lè Joseph te vini kote yo nan maten, li te gade yo, e gade byen, yo te byen dekouraje. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Li te mande ofisye Farawon an sila yo, ki te anprizone avèk li nan kay mèt li a: “Poukisa figi nou tris konsa jodi a?” ");
INSERT INTO hatbsa_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Epi yo te di li: “Nou te fè yon rèv, e nanpwen pèsòn pou entèprete li.” Alò, Joseph te di yo: “Èske entèpretasyon yo pa apatyen a Bondye? Di m istwa sa a, souple.” ");
INSERT INTO hatbsa_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Epi chèf responsab goute diven an te pataje rèv li avèk Joseph, e li te di a li menm: “Nan rèv mwen an, gade byen, te gen yon pye rezen devan m, ");
INSERT INTO hatbsa_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","epi sou pye rezen an, te gen twa branch. Konsa, pandan li t ap boujonnen, flè li yo te parèt, e touf flè yo te pwodwi pakèt rezen mi. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Alò, tas Farawon an te nan men m; epi mwen te pran rezen yo, mwen te peze yo nan tas Farawon an, e mwen te mete tas la nan men Farawon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph te di l: “Men, sa se entèpretasyon sa a: twa branch sa yo se twa jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nan yon tan twa jou, Farawon va leve tèt ou e reprann ou nan pozisyon ou. Ou va mete tas Farawon an nan men li menm jan ou te konn fè lè ou te nan sèvis responsab pote diven an. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Sèlman, sonje mwen lè li ale byen avèk ou, e souple, fè m gras e nonmen non mwen a Farawon pou fè m soti nan kay sa a. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Paske mwen te kidnape nan peyi Ebre yo, e menm isit la mwen pa t fè anyen pou yo ta dwe mete m nan prizon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Lè bòs boulanje a te wè ke li te fè yon entèpretasyon favorab, li te di Joseph: “Mwen te wè nan rèv mwen an, e gade byen, te gen twa panyen pen blan sou tèt mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Epi nan panyen pi wo a, te gen kèk nan tout kalite manje kwit pou Farawon, e zwazo yo te manje yo nan panyen sou tèt mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Alò, Joseph te reponn e te di: “Sa se entèpretasyon an. Twa panyen yo se twa jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Pandan twa jou ankò, Farawon va leve tèt ou sou ou. Li va pann ou sou yon bwa, e zwazo va retire chè sou ou e manje ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Alò, li te vin rive nan twazyèm jou, ki te fèt nesans a Farawon an, ke li te fè yon fèt pou tout sèvitè yo. Epi li te leve tèt a chèf responsab pote manje a ak chèf bòs boulanje a pami sèvitè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Li te reprann chèf responsab pote tas la nan pozisyon li, e li te ankò vin responsab mete tas la nan men Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Men li te pann chèf bòs boulanje a jis jan ke Joseph te entèprete pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Men, chèf responsab pote manje a pa t sonje Joseph. Li te bliye li. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Alò, li te vin rive nan fin dèzane yo, Farawon te fè yon rèv, e gade byen, li te kanpe devan lariviyè Nil lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Konsa, gade byen, sèt bèf te sòti nan lariviyè Nil lan, byen swa, e byen gra. Yo t ap manje nan zèb flèv la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Epi gade byen, sèt lòt bèf te sòti nan lariviyè Nil lan, byen lèd e mèg, e yo te kanpe akote lòt bèf bò kote lariviyè Nil lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bèf ki te lèd e mèg yo te manje valè sèt bèf ki te swa e byen gra yo. Epi konsa, Farawon te vin leve nan dòmi. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Li te tonbe dòmi ankò, e fè rèv yon dezyèm fwa. Konsa, sèt tèt mayi te vini sou yon sèl pye mayi, ki te gwo e bon. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Epi gade byen, sèt tèt, mèg ki brile pa van lès yo, te vin boujonnen dèyè yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Tèt mèg yo te vale sèt tèt ki te gra e byen plen yo. Alò, Farawon te leve, e gade byen, sa se te yon rèv. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Alò, nan maten lespri li te vin twouble, e li te voye rele tout majisyen an Égypte yo, ak tout moun saj li yo. Konsa, Farawon te eksplike yo rèv li yo, men pa t gen pèsòn ki te kapab entèprete yo pou Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Alò, chèf responsab pote manje a te pale a Farawon. Li te di li: “Jodi a, mwen ta dwe admèt yon tò ke m genyen. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Farawon te byen fache avèk sèvitè li yo, e li te fè m anprizone lakay Kaptenn kò gad la, mwen menm avèk chèf boulanje a. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nou te fè yon rèv nan menm nwit lan, mwen menm ak li menm tou. Nou chak te fè yon rèv ak pwòp entèpretasyon pa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Alò, te gen yon jennonm ki te la avèk nou, yon sèvitè kaptenn kò gad la, yon Ebre. Nou te pale rèv yo a li menm, e li te entèprete rèv nou yo pou nou. A chak moun li te entèprete selon pwòp rèv pa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Epi jan ke li te entèprete pou nou an, konsa li te vin rive. Mwen menm te vin restore nan pozisyon mwen, e li menm, lòt la, wa a te pann.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Alò, Farawon te voye rele Joseph. Avèk vitès, yo te mennen li sòti nan prizon an. Depi li fin taye bab li e chanje rad li, li te vini devan Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farawon te di a Joseph: “Mwen te fè yon rèv, men pa gen pèsòn ki kapab entèprete li. Men mwen tande pale de ou menm ke lè ou tande yon rèv, ou kapab bay entèpretasyon li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph te reponn Farawon. Li te di: “Sa pa nan mwen, men Bondye va bay Farawon yon repons favorab.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Alò, Farawon te pale avèk Joseph: “Nan rèv mwen an, men gade, mwen te kanpe arebò Rivyè Nil lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Epi gade byen, sèt bèf, gra e swa te vin monte sòti nan Nil lan; yo t ap manje nan zèb arebò rivyè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Epi gade byen, sèt lòt bèf te vin monte apre yo, kata, lèd e mèg, konsa, mwen pa t janm wè youn ki lèd nan tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Epi bèf mèg ak lèd yo te manje premye sèt bèf gra yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","E lè yo te fin devore yo, ou pa t kab konnen si yo te manje yo, paske yo te rete mèg menm jan yo te ye avan an. Epi se konsa mwen te vin leve. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Mwen te wè nan rèv mwen an tou, byen parèt, se te sèt tèt mayi, plen e bon te vini sou yon sèl pye. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Epi gade, sèt tèt sèch yo, ki brile pa van lès yo te vin pouse apre yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Konsa, tèt sèch yo te vale sèt bon tèt yo. Epi alò, mwen te pale sa a majisyen yo, men pa t gen youn ki ta kapab eksplike m afè sila a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Alò, Joseph te di a Farawon: “Rèv a Farawon yo se yon sèl ke yo ye; Bondye te di a Farawon kisa ki prèt pou fèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sèt bon bèf yo se sèt ane; epi sèt bon tèt yo se sèt ane; rèv sa yo se yon sèl yo ye. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sèt bèf lèd ak mèg yo ki te sòti apre yo a se sèt ane, e sèt tèt mèg ki brile pa van lès la va sèt ane ak gwo grangou. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Se tankou mwen te pale a Farawon: “Bondye te montre Farawon kisa ki prèt pou rive. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Gade byen, sèt ane ak gran abondans yo ap vini nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Epi apre yo, sèt ane ak gwo grangou yo va vini, tout abondans sa a va gen tan bliye nan peyi Égypte la, e gwo grangou sa a va ravaje peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Alò, abondans lan p ap sonje nan peyi a akoz konsekans gwo grangou a, paske li va vrèman rèd. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Alò, pou afè repete rèv la de fwa a, li vle di Farawon ke koze sa a deja detèmine pa Bondye, e Bondye va fè l parèt byen vit. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Alò, Farawon gen pou chèche yon nonm avèk konprann ak sajès, pou mete li responsab sou peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kite Farawon aji pou chwazi administratè k ap pran chaj peyi a, e kite yo egzije yon senkyèm nan rekòlt peyi Égypte la, nan sèt ane abondans lan. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Konsa, kite yo ranmase tout manje nan bon ane sa yo k ap vini an, mete yo nan depo pou vil ki anba otorite Farawon yo, e kite yo mete yo anba gad. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kite manje yo vini yon rezèv pou peyi a pandan sèt ane gwo grangou yo ki va fèt nan peyi Égypte la, pou peyi a pa peri pandan gwo grangou a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Alò, plan sa a te parèt bon a Farawon, ak tout sèvitè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Alò, Farawon te di a sèvitè li yo: “Èske nou kapab twouve yon lòt moun konsa, nan sila a ki gen Lespri Bondye?” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Epi Farawon te di a Joseph: “Akoz Bondye te fè ou konprann tout sa, nanpwen okenn lòt moun ki gen konprann ak sajès tankou ou menm. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ou va sou tout lakay mwen, e selon lòd pa ou tout pèp mwen an ap fè obeyisans. Se sèl sou twòn nan ke mwen va pi wo pase ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Farawon te di a Joseph: “Ou wè, mwen plase ou sou tout peyi Égypte la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Alò, Farawon te retire bag so a nan men li. Li te mete li nan men Joseph, e li te abiye l ak rad len fen ak yon kolye lò nan kou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Li te fè l monte nan dezyèm cha li a, epi li te pwoklame devan li: “Mete ajenou!” Epi li te plase li sou tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Anplis de sa, Farawon te di a Joseph: “Malgre mwen se Farawon, san pèmisyon pa ou, pèsòn p ap leve ni men li ni pye li sou tout peyi Égypte la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Alò, Farawon te nonmen Joseph Tsaphnath-Paenéach. Li te bay li Asnath, fi a Poti-Phéra a, prèt On an, kòm madanm li. Epi Joseph te plase sou tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Alò, Joseph te gen laj trant ane lè li te kanpe devan Farawon, wa Égypte la. Epi Joseph te sòti nan prezans Farawon, e li te ale toupatou nan tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Pandan sèt ane abondans yo, peyi a te pwodwi anpil. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Konsa, Joseph te ranmase tout manje pandan sèt ane sa yo ki te ekoule nan peyi Égypte la, e li te mete manje yo nan vil yo. Li te mete nan chak vil, menm manje ki te sòti nan chan ki antoure li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Konsa, Joseph te ranmase sereyal an gran abondans tankou sab lanmè, jiskaske li te vin sispann mezire li, paske li te depase kontwòl. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Alò, avan ane gwo grangou a te rive, de fis te vin ne a Joseph ke Asnath, fi a Poti-Phéra a, prèt On an te fè pou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph te nonmen premye ne a Manassé, paske li te di: “Bondye te fè m bliye tout pwoblèm mwen yo ak tout lakay papa m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Li te nonmen dezyèm nan Éphraïm, paske li te di: “Bondye fè mwen bay anpil fwi nan peyi afliksyon mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sèt ane abondans ki te nan peyi Égypte la te fin pase. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Epi sèt ane gwo grangou a te kòmanse, jis jan ke Joseph te di a. Alò te vin gen gwo grangou nan tout peyi yo, men nan peyi Égypte la te gen pen. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Lè tout peyi Égypte la te grangou, yo te rele fò a Farawon pou bay pen. Konsa, Farawon te di tout Ejipsyen yo: “Ale wè Joseph. Nenpòt sa li mande nou, nou va fè l.” ");
INSERT INTO hatbsa_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Gwo grangou a te fin gaye sou tout sifas tè a. Konsa, Joseph te ouvri tout depo yo pou te vann manje bay Ejipsyen yo. Gwo grangou a te byen rèd nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pèp yo de tout peyi te vini an Égypte pou achte sereyal Joseph yo, akoz gwo grangou a te rèd sou tout tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Alò, Jacob te wè ke te gen sereyal an Égypte, e Jacob te di fis li yo: “Poukisa nou ap gade youn sou lòt konsa?” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Li te di: “Mwen tande gen sereyal an Égypte. Desann la pou achte kèk pou nou nan kote sa, pou nou kapab viv, e pa mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Alò, dis frè Joseph yo te desann pou achte sereyal an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Men Jacob pa t voye frè Joseph la, Benjamin avèk lòt frè li yo, paske li te di: “Mwen pè pou yon mal ta kab rive li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Alò, fis Israël yo te vini pou achte sereyal pami sila ki t ap vini yo, paske gwo grangou a te nan peyi Canaan an tou. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Alò, Joseph te an pouvwa nan peyi a. Se te li menm ki te vann a tout pèp nan peyi a. Epi frè a Joseph yo te vin bese ba devan li avèk figi yo atè. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Lè Joseph te wè frè li yo, li te rekonèt yo, men li te kache idantite li devan yo, e li te pale rèd avèk yo. Li te di yo: “Kote nou sòti?” Epi yo te di: “Nan peyi Canaan, pou achte manje.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Men Joseph te rekonèt frè l yo, malgre yo pa t rekonèt li. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph te sonje rèv ke li te gen sou yo a, e li te di yo: “Se espyon nou ye! Nou te vin chache konnen pwen fèb nan defans peyi nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Alò, yo te di li: “Non, mèt mwen, men sèvitè ou yo te vin achte manje.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","“Nou tout se fis a yon sèl mesye. Nou se moun onèt, sèvitè ou, e nou pa espyon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Malgre sa li te di yo: “Non, men nou te vin gade pwen fèb nan defans peyi nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Men yo te reponn li: “Sèvitè ou yo se douz frè antou, fis a yon sèl mesye nan peyi Canaan; e gade byen, pi jenn nan avèk papa nou jodi a, e youn pa la ankò.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph te di yo: “Se tankou mwen te di nou, se espyon nou ye. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Men se konsa nou va pase a leprèv. Pa lavi Farawon, nou p ap sòti nan plas sa a amwenske pi jenn nan vin parèt isit la! ");
INSERT INTO hatbsa_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Voye youn nan nou ale pou li kapab chache frè nou an, pandan n ap rete anprizone, pou pawòl nou yo kapab pase a leprèv, si gen verite nan nou. Men si non, pa lavi Farawon, vrèman nou se espyon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Konsa, li te mete yo nan prizon pou twa jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Alò, Joseph te di yo nan twazyèm jou a: “Fè sa pou viv, paske mwen krent Bondye: ");
INSERT INTO hatbsa_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si nou se moun onèt, kite youn nan frè nou yo rete anprizone nan prizon nou an; men pou nou lòt yo, ale pote sereyal pou grangou ki lakay nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Men mennen pi jenn frè nou an bò kote m, pou pawòl nou yo kapab verifye, e pou nou pa mouri.” Epi konsa, yo te fè. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Yo te di youn a lòt: “Vrèman, nou koupab nan zafè frè nou an, akoz nou te wè jan nanm li te twouble lè li te plede avèk nou, men nou te refize tande. Pou sa, kriz sila a vin rive sou nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben te reponn yo, e te di: “Èske mwen pa t di nou: ‘Pa peche kont tigason an;’ men nou te refize tande? Konsa, fwi san li an vin parèt.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Men yo pa t konnen ke Joseph te konprann, paske te gen yon entèprèt antre yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Konsa, li te vire lwen yo e li te kriye. Men lè li te retounen vè yo, li te pale avèk yo. Li te pran Siméon nan mitan yo, e li te mare li devan zye yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Konsa, Joseph te bay lòd pou plen sak yo avèk sereyal, remèt lajan a chak moun nan sak li, e bay yo pwovizyon pou vwayaj la. Epi se konsa sa te fèt pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Alò, yo te chaje bourik pa yo avèk sereyal yo, e yo te soti la. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pandan youn nan yo t ap ouvri sak li pou bay bèt la manje, li te wè lajan pa li a. Gade byen, se la li te ye, nan bouch sak la. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Epi li te di a frè l yo: “Lajan mwen an remèt wi! E gade byen, li la menm nan sak mwen an!” Konsa kè yo plonje desann. Yo te vire, tou ap tranble, youn ak lòt, e te di: “Kisa Bondye gen tan fè nou la a?” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Lè yo te rive kote papa yo Jacob, nan peyi Canaan an, yo te di li tout sa ki te rive yo. Konsa yo te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mesye a, mèt peyi a, te pale byen di avèk nou. Li te panse nou te espyon nan peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Men nou te di li: ‘Nou se moun onèt. Se pa espyon nou ye. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nou se douz frè, fis a papa nou. Youn nan nou pa viv ankò, e pi jenn nan avèk papa nou jodi a nan peyi Canaan.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Epi nonm nan, mèt peyi a, te di nou: ‘Pa sa mwen va konnen ke nou se moun onèt: kite youn nan frè nou yo avè m, pran sereyal la pou pwoblèm grangou lakay nou yo, e ale. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Men mennen pi jenn frè nou an kote mwen pou m ka konnen ke nou pa espyon, men ke nou se moun onèt. Mwen va bay ou frè nou a, e w ap kapab fè komès nan peyi a.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Alò, li te rive ke lè yo t ap vide sak yo, ke gade byen, bous lajan chak moun te nan sak li. Lè yo menm avèk papa yo te wè lajan an, yo te sezi. ");
INSERT INTO hatbsa_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Papa yo, Jacob te di yo: “Nou fin fè m pèdi pitit mwen yo! Joseph pa la ankò, Siméon pa la ankò, e nou ta vle pran Benjamin. Tout bagay sa yo kont mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Alò, Reuben te pale avèk papa l. Li te di: “Ou kapab mete de gason mwen yo a lanmò si mwen pa mennen li retounen kote ou. Mete li sou kont mwen, e mwen va fè l retounen kote ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Men Jacob te di: “Fis mwen an p ap desann avèk nou. Paske frè li a mouri, e se li sèl ki rete. Si malè ta rive li nan vwayaj ke nou ap fè a, alò, nou va mennen tèt cheve blanch sa a vè sejou mò yo avèk tristès.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Alò, gwo grangou a te rèd nan tout peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Epi li te vin rive ke lè yo te fin manje sereyal ke yo te achte an Égypte la, papa yo te di yo: “Ale retounen, achte yon ti manje.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Men Juda te pale avèk li. Li te di: “Nonm nan te menase nou ke: ‘Nou p ap wè figi m sof ke frè nou an avèk nou.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si ou voye frè nou an avèk nou, nou va desann achte manje. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Men si ou pa voye li, nou p ap desann. Paske nonm nan te di nou: ‘Nou p ap wè figi m sof ke frè nou an avèk nou.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Alò, Israël te di: “Poukisa ou maltrete m konsa, pou nou te di mesye a ke nou te gen yon lòt frè toujou?” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Men yo te di: “Mesye a te kesyone nou byen dirèk konsènan moun nan fanmi nou. Li te mande: ‘Èske papa nou toujou vivan? Èske nou gen yon lòt frè?’ Alò, nou te reponn kesyon li. Èske nou ta ka konnen ke li ta di: ‘Mennen frè nou an desann?’” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda te di a papa li, Israël: “Voye jènjan an avèk mwen. Nou va leve ale, pou nou kapab viv e pa mouri, nou menm, ansanm ak ou, ak pitit ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mwen menm, mwen va garanti pou li. Ou kapab mete m responsab li. Si mwen pa mennen l tounen bò kote ou, pou m fè l chita devan ou, alò, ke mwen rete koupab devan ou pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Paske si nou pa t mize, asireman kounye a nou ta gen tan retounen de fwa deja.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Alò, papa yo, Israël te di yo: “Si sa oblije fèt, alò, fè l konsa: Pran kèk nan pi bèl pwodwi peyi a nan sak nou, pou pote desann vè nonm nan kòm kado; yon ti lwil, yon ti siwo myèl, yon ti gòm santi bon, myrr, grenn pistach fen avèk grenn zanmann. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Pran doub lajan nan men nou, e anplis, pran pou remèt nan men nou kòb ki te retounen nan bouch sak la. Petèt se te yon erè. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pran frè nou an tou, e leve retounen vè mesye a. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Konsa, ke Bondye Toupwisan an kapab bannou gras nan zye mesye a, pou li kab lage bannou lòt frè nou an avèk Benjamin. Epi pou mwen, si mwen pèdi pitit mwen yo, mwen pèdi nèt.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Alò, mesye yo te pran kado sila yo, e yo te pran doub lajan nan men yo avèk Benjamin. Konsa, yo te leve desann an Égypte, e yo te kanpe devan Joseph. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Lè Joseph te wè Benjamin avèk yo, li te di a chèf domestik lakay li a, “Mennen mesye yo nan kay la, touye yon bèt, e fè prepare l; paske mesye sa yo ap vin manje avèk mwen a midi a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Alò, nonm nan te fè sa ke Joseph te mande a, e li te mennen mesye yo lakay Joseph. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Alò, mesye yo te byen pè, paske yo te mennen yo lakay Joseph. Konsa, yo te di: “Se akoz lajan ki te remèt nan sak yo premye fwa a, ke yo ap mennen nou la a, pou li kapab chache okazyon kont nou, pou tonbe sou nou, e pran nou kòm esklav avèk bourik nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Pou sa a, yo te vin pwoche chèf domestik la. Yo te pale ak li nan antre kay la, ");
INSERT INTO hatbsa_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","e yo te di: “O mèt mwen, vrèman nou te desann premye fwa a pou achte manje, ");
INSERT INTO hatbsa_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","men sa te fè ke lè nou rive nan lojman nou, pou louvri sak nou, konsa, nou jwenn kòb chak moun nan bouch sak li! Tout kòb nou nèt! Konsa, nou te retounen pote li nan men nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nou te pote osi, lajan anplis nan men nou pou achte manje. Nou pa konnen kilès ki te mete kòb nou yo nan sak nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Li te di: “Rete anpè, nou pa bezwen pè. Bondye pa nou an e Bondye papa nou an te bannou trezò nan sak nou yo. Mwen te resevwa kòb nou an.” Epi li te mennen Siméon deyò bay yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Epi nonm nan te mennen mesye yo antre lakay Joseph. Li te bay yo dlo, e yo te lave pye pa yo. Li te bay bourik yo manje. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Konsa, yo te prepare kado yo pou lè Joseph ta vin parèt a midi, paske yo te tande ke yo te gen pou manje la. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Lè Joseph te rive lakay li, yo te pote kado ki te nan men yo bò kote li nan kay la, e yo te bese atè devan li. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Li te mande yo si tout bagay ale byen. Li te di: “Èske granmoun sou sila nou te pale m nan toujou vivan?” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yo te di: “Sèvitè ou a, papa nou toujou byen; li toujou vivan.” Yo te bese ba pou bay respè. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Lè li te leve zye li, li te wè frè li, Benjamin, fis a manman l lan, e li te di: “Èske se sila a ki pi jenn frè nou ke nou te pale m nan?” Konsa, li te di: “Ke Bondye kapab fè ou gras, fis mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Konsa, Joseph te fè vit ale deyò, paske li te tèlman touche byen fon pa prezans frè li yo, e li te chache yon kote pou l ta kab kriye. Li te antre nan chanm li an, e li te kriye la. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Alò, li te lave figi li, e li te vin parèt deyò. Li te kontwole tèt li, e te di: “Sèvi manje a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Epi yo te sèvi Joseph nan yon kote pou kont li, e lòt Ejipsyen yo pou kont yo, paske yon Ejipsyen pa t kapab manje avèk yon Ebre. Paske sa se yon abominasyon pou Ejipsyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Alò, yo te chita devan li, premye ne a, selon dwa nesans li, pi jenn nan selon jennès li, e mesye yo t ap gade youn lòt byen etone. ");
INSERT INTO hatbsa_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Li te pran pòsyon manje pa yo sòti nan pwòp tab li, men pòsyon Benjamin an te senk fwa plis ke tout lòt yo. Epi yo te manje e bwè, e fè kè kontan avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Alò, li te pase lòd a chèf domestik la e te di: “Ranpli sak yo avèk manje, tout sa ke yo kapab pote, e mete kòb a chak moun nan bouch sak li. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Plase tas mwen an, tas fèt an ajan an nan bouch sak pi jenn nan, ansanm ak kòb li pou sereyal la.” Epi sa te fèt jan Joseph te mande a. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Depi li te fè klè, mesye yo te voye ale, yo menm avèk bourik yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Yo te fenk kite vil la, e yo pa t byen lwen lè Joseph te di a chèf domestik li a: “Leve, swiv mesye sa yo. Lè nou rive sou yo, di yo konsa: ‘Poukisa nou rekonpanse mal pou byen? ");
INSERT INTO hatbsa_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Èske tas sa a se pa sila ke mèt mwen an bwè ladann, e sèvi pou divinasyon an? Nou te fè mal lè nou te fè sa.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Alò, li te rive sou yo, e li te pale pawòl sa ak yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Yo te di li: “Poukisa mèt mwen an pale kalite pawòl sila yo? Sa lwen mwen pou m ta fè yon bagay konsa. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Gade byen, lajan ke nou te twouve nan bouch sak nou yo, nou te pote yo bannou soti nan peyi Canaan. Alò, kijan nou ta ka vòlè lò, oswa lajan lakay mèt la? ");
INSERT INTO hatbsa_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Avèk nenpòt kilès nan sèvitè nou yo ke nou ta twouve l, ke li mouri, e nou osi, nou va devni esklav a mèt nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Alò, li te di: “Konsa kite sa fèt tankou pawòl ou; sila avèk kilès li twouve l la, li va devni esklav mwen, e tout rès nan nou va rete inosan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Alò, byen prese, chak moun te desann sak li atè, pou te ouvri sak li. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Li te fè ankèt, kòmanse avèk pi gran, fini avèk pi jenn nan, e tas la te twouve nan sak Benjamin an. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Konsa, yo te chire rad yo, e lè chak moun te fin chaje bèt li, yo te retounen nan vil la. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Lè Juda avèk frè li yo te vini lakay Joseph, li te toujou la, e yo te tonbe atè devan li. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph te di yo: “Ki zak sa ke nou te fè la a? Èske nou pa konnen ke yon nonm tankou mwen kapab vrèman pratike divinasyon?” ");
INSERT INTO hatbsa_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Konsa, Juda te di: “Kisa nou kapab di a mèt nou? Kisa nou kapab pale? Kijan nou kapab jistifye pwòp tèt nou? Bondye te twouve inikite nan sèvitè ou yo. Gade byen, nou se esklav a mèt nou, ni nou, men osi sila ki te posede tas nou te twouve a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Men li te di yo: “Kite sa byen lwen pou m fè sa. Mesye sou sila nou te twouve tas la, li va esklav mwen. Men pou nou, ale anpè vè papa nou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Alò, Juda te pwoche li. Li te di: “O mèt mwen, silvouplè, èske sèvitè ou kapab pale yon mo nan zòrèy a mèt la, e li p ap vin fache avèk sèvitè ou a; paske ou menm jan avèk Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mèt mwen an te mande sèvitè li yo, e te di: ‘Èske nou genyen yon papa, oswa yon frè?’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nou te di a mèt mwen: ‘Nou gen yon papa ki granmoun, ak yon timoun li te fè nan vyeyès li. Alò, frè li a gen tan mouri, li sèl ki rete kòm pitit a manman l, e papa li renmen li.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Konsa, ou te di sèvitè ou yo: ‘Mennen fè l desann pou m kapab fikse zye m sou li.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","“Men nou te di a mèt nou: ‘Jènjan an pa kapab kite papa l; papa l ta mouri.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","“Malgre sa, ou te di a sèvitè ou yo: ‘Amwens ke pi jenn nan vin desann avèk nou, nou p ap wè figi m ankò.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Se te konsa li te rive ke lè nou te monte vè sèvitè ou, papa m, ke nou te pale li pawòl a mèt nou an. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Papa nou te di nou: ‘Retounen achte yon ti manje.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Men nou te di: ‘Nou pa kapab desann. Si pi jenn frè nou an avèk nou, nou va desann. Paske nou pa kapab wè figi a nonm nan ankò, sof ke pi jenn frè nou an avèk nou.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Sèvitè ou, papa m, te di nou: ‘Ou konnen ke madanm mwen te fè de fis pou mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Youn nan yo te sòti kite mwen, e mwen te di: “Asireman li te chire an mòso”, e mwen pa wè li depi lè sa. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si ou pran sila a osi de mwen, e si malè rive li, nou va mennen cheve tèt blanch sa a anba nan sejou mò yo avèk tristès.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Alò, pou sa, lè mwen rive vè sèvitè ou, papa m, e pou jènjan an pa la avèk nou, paske lavi li mare ansanm avèk lavi jènjan an, ");
INSERT INTO hatbsa_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","lè li wè ke jènjan an pa avèk nou, l ap mouri. Konsa sèvitè ou yo va mennen cheve blanch a sèvitè ou, papa nou anba nan sejou mò yo avèk tristès. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Paske sèvitè ou te devni yon sekirite pou jènjan a papa m nan, e mwen te di: ‘Si mwen pa fè l retounen a ou menm, alò, kite m pote koupabilite sa a devan papa m pou tout tan.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Alò, pou sa, kite sèvitè ou a rete, olye ke jènjan an, kòm yon esklav a mèt mwen. E kite jènjan an monte avèk frè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Paske kijan mwen kapab monte vè papa m si jènjan an pa avè m?—paske mwen pè pou m ta wè malè ki vin pran papa m.” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Alò, Joseph pa t kapab kontwole emosyon li devan tout moun sa yo ki te kanpe akote li yo. Li te kriye: “Fè tout moun kite mwen.” Konsa pa t gen pèsòn avèk li lè Joseph te revele li menm a frè l yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Li te kriye tèlman fò ke Ejipsyen yo te tande l. Menm lakay Farawon te tande l. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Alò, Joseph te di a frè li yo: “Mwen se Joseph! Èske papa m toujou vivan?” Men frè l yo pa t kapab reponn li, paske yo te plen de gwo perèz akoz prezans li. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Alò, Joseph te di a frè li yo: “Souple, vin pi pre m.” Epi yo te vin pi pre. Li te di: “Mwen se frè nou, Joseph, ke nou te vann pou ale an Egypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Alò, pinga nou tris ni fache avèk pwòp tèt nou, akoz ke nou te vann mwen isit la, paske Bondye te voye m avan nou pou prezève lavi nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Paske gwo grangou a te nan peyi sa pou dèzane sa yo, e gen senk ane toujou ki p ap gen ni raboure tè ni rekòlt. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bondye te voye m devan nou pou prezève yon retay sou latè, e pou kenbe nou vivan pa yon gwo delivrans. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Alò, pou sa, se pa te nou ki te voye m isit la, men Bondye. Li te fè m yon papa pou Farawon, mèt pou tout lakay li, e gouvènè sou tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Fè vit, monte vè papa m pou di l: ‘Se konsa ke fis ou a, Joseph pale: “Bondye gen tan fè m mèt pou tout Égypte la. Fè vit, vin desann kote mwen, e pa mize.” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Nou va viv nan peyi Gosen an, e nou va pre mwen, nou menm avèk pitit nou yo, pitit a pitit nou yo, bann mouton nou yo, avèk twoupo nou yo, ak tout sa ke nou genyen.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","La, mwen va osi fè pwovizyon pou nou, paske toujou ap gen senk ane ak gwo grangou e nou menm avèk lakay nou ak tout sa nou genyen ta kapab vin megri. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Gade byen, zye nou wè, e zye a frè m nan Benjamin wè, ke se pwòp bouch mwen k ap pale ak nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Koulye a nou gen pou di papa m tout richès mwen gen an Égypte, ak tout sa nou te wè. Nou gen pou prese mennen papa m desann isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Konsa, li te tonbe nan kou a frè l, Benjamin, e li te kriye nan kou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Li te bo tout frè li yo, li te kriye sou yo, e apre frè l yo te pale avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Alò, lè nouvèl la te tande kote lakay Farawon, ke frè Joseph yo te vini, sa te fè Farawon kontan, ni sèvitè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Epi Farawon te di a Joseph: “Pale a frè ou yo, ‘Men sa pou fè; chaje bèt nou pou ale nan peyi Canaan. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Pran papa ou avèk fanmi nou yo, e vini kote mwen, mwen va bannou pi bon tè an Égypte yo, e nou va manje tout grès tè a.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Koulye a mwen pase lòd: ‘Fè sa: pran cha ki sòti an Égypte yo pou pitit nou yo ak madanm nou yo, e mennen papa nou vini. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Pa okipe nou de byen nou yo, paske tout sa ki pi bon nan tout peyi Égypte la se pou nou.’” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Alò, fis Israël yo te fè sa. Epi Joseph te bay yo cha yo selon kòmann Farawon an, e li te bay yo pwovizyon pou vwayaj la. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A yo chak, li te bay echanj abiman, men a Benjamin li te bay twa san pyès an ajan, ak senk echanj abiman. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A papa li, li te voye kòm swivan: dis bourik chaje avèk pi bon bagay Égypte kab pwodwi, dis bourik femèl chaje avèk sereyal ak pen, ak nouriti pou papa l nan vwayaj la. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Konsa, li te voye frè li yo pati, e pandan yo t ap sòti, li te di yo: “Pa goumen nan vwayaj la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Alò yo te kite Égypte monte, e yo te vini nan peyi Canaan kote papa yo, Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Yo te pale li, e yo te di li konsa: “Joseph toujou vivan! Vrèman, li se Gouvènè tout peyi Égypte la!” Men kè Jacob te febli. Li pa t kwè yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Yo te di li tout pawòl ke Joseph te pale yo. Men lè li te wè cha yo ke Joseph te voye pou mennen li an, lespri papa yo, Jacob, te remonte. ");
INSERT INTO hatbsa_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Alò, Israël te di: “Sa sifi! Fis mwen an, Joseph toujou ap viv. M ap prale wè l avan ke m mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Epi Israël te pati avèk tout sa li te genyen. Li te vini Beer-Schéba e te ofri sakrifis a Bondye a papa li a, Isaac. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Bondye te pale avèk Israël nan vizyon nan nwit lan. Li te di: “Jacob, Jacob.” Jacob te reponn: “Men mwen isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Li te di: “Mwen se Bondye, Bondye a papa ou a. Pa pè desann an Égypte, paske mwen va fè nou vin yon gran nasyon la. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mwen va desann avèk nou an Égypte. Mwen va anplis, an verite, fè nou monte ankò. Epi se men Joseph ki va fèmen zye ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Alò, Jacob te leve kite Beer-Schéba. Fis Israël yo te pote papa yo, Jacob, ak pitit pa yo, ak madanm yo nan cha ke Farawon te voye pou pote yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yo te pran tout bèt yo avèk tout byen yo, ke yo te vin gen nan peyi Canaan an, e yo te vini an Égypte, Jacob avèk tout desandan li yo, ansanm ");
INSERT INTO hatbsa_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","avèk fis li yo, fis a fis li yo, fi li yo avèk fi a fis li yo, ak tout desandan li yo. Li te mennen tout desandan avèk li, ale an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Alò, sa yo se non a fis a Israël yo, Jacob avèk fis li yo ki te ale an Égypte: Reuben, premye ne a Jacob la. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Fis Reuben yo: Hénoc, Pallu, Hetsron, ak Carmi. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Fis Siméon yo: Jemuel, Jamin, Ohad, Jakin avèk Tsochar; e Saul, fis a yon fanm Kananeyèn. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Fis a Levi yo: Guerschon, Kehath, ak Merari. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Fis a Juda yo: Er, Onan, Schéla, Pérets, ak Zarach. Men Er avèk Onan te mouri nan peyi Canaan. Fis a Pérets yo te Hetsron, avèk Hamul. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Fis a Issacar yo: Tholy, Puva, Job, ak Schimron. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Fis a Zabulon yo: Séred, Élon avèk Jahleel. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sila yo se fis a Léa yo, ke li te fè pou Jacob nan Paddan-Aram, avèk fis li, Dina; tout fis li yo ak fi li yo te vin monte a trann-twa. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Fis a Gad yo: Tsiphjon, Haggi, Schuni, Etsbon, Éri, Arodi avèk Areéli. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Fis Aser yo: Jimna, Jischva, Jischvi, ak Beria; e sè yo, Sérach. Epi fis Beria yo: Héber avèk Malkiel. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sila yo se fis a Zilpha, sila ke Laban te bay a fi li Léa a; epi li te fè pou Jacob sèz moun sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Fis a Rachel yo, madanm a Jacob la: Joseph avèk Benjamin. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Alò, a Joseph nan peyi Égypte la, te ne Manassé ak Éphraïm, ke Asenath, fi a Poti-Phéra a, prèt On an te fè pou li. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Fis a Benjamin yo: Béla, Béker, Aschbel, Guéra, Naaman, Éhi, Rosch, Muppim, Huppim, ak Ard. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Sila yo se fis a Rachel yo, ki te fèt a Jacob; te gen katòz moun antou. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Fis a Dan yo: Huschim. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Fis a Nephtali yo: Jathtseel, Guni, Jetser, ak Schillem. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Sila yo se fis a Bilha yo, ke Laban te bay a fi li, Rachel, e li te fè sa yo pou Jacob; te gen sèt moun antou. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tout moun ki te pou Jacob yo te vini an Égypte, desandan ki te sòti dirèk sou li menm yo, san kontwole madanm a fis Jacob yo te swasann-sis moun antou. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Fis a Joseph ki te fèt pou li an Égypte yo te de. Tout moun lakay Jacob ki te vini an Égypte yo te swasann-dis. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Alò, li te voye Juda devan li vè Joseph, pou montre li chemen an devan l nan Gosen, epi yo te vini nan peyi Gosen. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph te prepare cha li, li te monte Gosen pou rankontre papa li, Israël. Depi li te parèt devan li, li te tonbe nan kou li e li te kriye nan kou li pandan anpil tan. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Konsa Israël te di a Joseph: “Koulye a kite mwen mouri, paske mwen gen tan wè figi ou, ke ou toujou vivan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph te di a frè l yo e a lakay papa li: “Mwen va monte pou pale ak Farawon, e mwen va di li: ‘Frè m yo avèk lakay papa m, ki te nan peyi Canaan an vin kote mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mesye sa yo se bèje, paske yo te konn okipe bèt. E yo te mennen bann mouton pa yo avèk twoupo pa yo, ak tout sa yo posede.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Lè Farawon rele nou e di: ‘Kisa nou fè kòm metye.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Nou va di: ‘Sèvitè ou yo ap okipe bèt depi lè nou te jenn jis rive koulye a, ni nou menm, ni papa nou yo,’ pou nou kapab viv nan peyi Gosen; paske tout bèje se yon abominasyon pou Ejipsyen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Konsa, Joseph te antre pou pale ak Farawon. Li te di: “Papa m avèk frè m yo, bann mouton yo, twoupo yo, avèk tout sa yo posede, te sòti nan peyi Canaan an. Epi gade byen, yo nan peyi Gosen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Li te pran senk mesye pami frè li yo, e li te prezante yo bay Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Alò, Farawon te di a frè li yo: “Ki metye nou?” Epi yo te di a Farawon: “Sèvitè nou se bèje, ni nou menm, ni zansèt nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Yo te di a Farawon: “Nou te vini pou rete tankou etranje nan peyi a, paske nanpwen patiraj pou bann mouton yo paske gwo grangou a rèd nan peyi Canaan. Alò pou sa, souple, kite sèvitè nou yo viv nan peyi Gosen an.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Konsa, Farawon te di a Joseph: “Papa ou avèk frè ou yo te vin kote ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Peyi Égypte la devan ou, plase papa ou avèk frè ou yo nan pi bon pòsyon tè a, kite yo viv nan peyi Gosen an. Epi si ou konnen moun ak kapasite pami yo, alò, fè yo responsab bèt mwen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Epi Joseph te mennen papa li, Jacob. Li te prezante li bay Farawon, epi Jacob te beni Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farawon te di a Jacob: “Konbyen ane ou gen tan viv?” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Konsa, Jacob te di a Farawon: “Lane lavi m yo sou latè se san-trant. Pa anpil, e degoutan se te ane lavi m yo. Ni yo pa menm fòs avèk lane ke zansèt mwen yo te viv pandan jou lavi pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Konsa, Jacob te beni Farawon, e li te sòti nan prezans li. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Epi Joseph te pozisyone papa li, ak frè li yo e li te bay yo yon tèren an Égypte, nan pi bon pati nan peyi a, kote Ramsès la, tankou Farawon te kòmande a. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph te founi papa li ak frè li yo, avèk tout lakay li avèk manje, selon fòs kantite pitit pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Koulye a, pa t gen manje nan tout peyi a, akoz gwo grangou a te tèlman rèd, ke peyi Égypte la ak peyi Canaan an te febli nèt akoz gwo grangou a. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph te ranmase tout lajan ki te twouve nan peyi Égypte la, ak nan peyi Canaan pou sereyal ke yo te achte a, e Joseph te pote lajan an lakay Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Lè tout lajan an te fin depanse nan tout peyi Égypte la, ak tout peyi Canaan an, tout Ejipsyen yo te vin vè Joseph, e te di li: “Bannou manje, paske pou ki rezon nou ta dwe mouri nan prezans ou? Paske lajan nou fini.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Alò, Joseph te di: “Bay bèt nou yo, e mwen va bannou manje pou bèt yo, paske kòb nou gen tan fini.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Epi yo te mennen bèt yo kote Joseph, Joseph te bay yo manje an echanj ak cheval ak bann mouton, twoupo ak bourik. Konsa, li te bay yo manje an echanj ak tout bèt pa yo nan ane sa a. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lè ane sa a te fini, yo te vin kote li nan lane pwochèn, e te di li: “Nou p ap kache a mèt nou ke lajan nou fin depanse, e tout twoupo bèt yo se pou mèt nou. Nanpwen anyen ki rete pou mèt la, sof ke kò nou, ak tè nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Poukisa nou ta mouri devan zye ou, ni nou menm, ni tè nou yo? Achte nou menm avèk tè nou yo, e nou va vin esklav a Farawon. Epi bannou semans pou nou ka viv, pou nou pa mouri, e pou tè a pa rete vid.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Alò, Joseph te achte tout tè an Égypte yo pou Farawon, e chak Ejipsyen te vann tè li, akoz ke gwo grangou a te rèd sou yo. Konsa, tè a te vin pou Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Epi pou pèp la, li te deplase yo pou antre nan vil yo, sòti nan yon pwen fwontyè Égypte la, jis rive nan lòt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Se sèl tè prèt yo ke li pa t achte, paske prèt yo te gen yon bous ki te sòti sou Farawon, e yo te viv sou bous ke Farawon te bay yo a. Akoz sa, yo pa t vann tè pa yo a. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Epi Joseph te di a pèp la: “Veye byen, jodi a mwen te achte nou menm avèk tè nou yo pou Farawon. Men semans lan se pou nou, e nou kapab simen nan tè a. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Nan rekòlt la, nou va bay yon senkyèm a Farawon, e kat senkyèm nan ap rete pou nou pou simen nan tè a pou manje pou nou menm avèk sa ki lakay nou yo, ak pou pitit nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Epi yo te di: “Ou gen tan sove lavi nou! Kite nou twouve favè nan zye a mèt nou, e nou va vin esklav Farawon.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph te fè yon règleman selon peyi Égypte la ki valab jis rive jou sa a ke Farawon te gen dwa a yon senkyèm nan. Sèl tè a prèt yo ki pa t vin pou Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Alò, Israël te viv nan peyi Égypte la, nan Gosen. Yo te gen tèren ladann, yo te vin trè pwodiktif, e yo te peple anpil. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob te viv nan peyi Égypte pandan disèt ane'. Pou sa, fòs lavi li te san-karann-sèt ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Lè pou Israël mouri an t ap pwoche. Li te rele fis li, Joseph, e te di li: “Souple, si mwen te twouve favè nan zye ou, koulye a plase men ou anba fant janm mwen, e aji avèk mwen nan bòn fwa ak tandrès. Souple, pa antere mwen an Égypte, ");
INSERT INTO hatbsa_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","men lè m kouche avèk zansèt mwen yo, nou va pote mwen deyò de Égypte, pou antere mwen nan plas antèman a yo menm nan.” Epi Joseph te di: “M ap fè jan ou di m nan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Konsa, li te di: “Sèmante ban mwen.” Epi li te sèmante ba li. Epi Israël te bese pou adore nan tèt kabann nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Alò, li te rive ke apre bagay sa yo, ke Joseph te vin enfòme: “Gade byen, papa ou malad.” Li te pran de fis li yo, Manassé ak Éphraïm avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Epi moun yo te pale a Jacob: “Gade byen, fis ou a, Joseph gen tan vin kote ou.” Konsa, Israël te ranmase fòs li. Li te chita sou kabann nan. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Epi Jacob te di a Joseph: “Bondye Toupwisan an te parèt a mwen nan Luz nan peyi Canaan an e Li te beni mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Li te di mwen: ‘Gade byen, Mwen va fè nou donnen anpil fwi, e miltipliye anpil. Mwen va fè ou vin yon konpanyen pèp la, e Mwen va bay peyi sa a a desandan aprè ou, kòm posesyon k ap dire pou tout tan.’ ");
INSERT INTO hatbsa_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Alò, de fis ou yo ki te fèt a ou menm nan peyi Égypte la avan mwen te vin kote ou an Égypte la, se pa m. Éphraïm avèk Manassé se pou mwen, menm jan ke Ruben avèk Siméon va pou mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Men pitit ou yo ki te fèt apre yo, va pou ou. Yo va rele selon non frè pa yo nan eritaj yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Alò, pou mwen, lè m te retounen nan Paddan, Rachel te mouri, nan tristès mwen, nan peyi Canaan an pandan vwayaj la, lè te toujou gen yon distans pou rive nan Ephrata (ki vle di Bethléem).” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Lè Israël te wè fis a Joseph yo, li te di: “Kilès moun sa yo ye?” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph te di a papa li: “Sa yo se fis mwen yo, ke Bondye te ban mwen isit la.” Epi li te di: “Mennen yo isit souple, pou m kapab beni yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Alò, zye Israël yo te tèlman vin fèb akoz laj ke li pa t kapab wè. Epi Joseph te mennen yo toupre li, li te bo yo e li te anbrase yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israël te di a Joseph: “Mwen pa t janm sipoze ke m ta wè figi ou, e gade byen, Bondye kite mwen wè pitit ou yo tou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Epi Joseph te mennen yo soti antre jenou li yo, e te bese ba avèk figi li jis atè. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Joseph te pran yo toude, Ephraïm nan men dwat li vè bò goch Israël, e nan men goch li, Manassé vè bò dwat Israël. Konsa, li te mennen yo toupre li. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Men Israël te lonje men dwat li, li te mete li sou Éphraïm, ki te pi jenn nan, e men goch li te sou tèt Manassé, avèk men l kwaze, poutan Manassé te premye ne. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Li te beni Joseph, e te di: “Bondye devan sila zansèt mwen yo, Abraham avèk Isaac te mache a, Bondye ki te bèje m nan pandan tout vi m jis rive jounen jodi a, ");
INSERT INTO hatbsa_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","zanj ki te rachte mwen de tout mal la, beni jènjan sa yo; epi ke non mwen kapab viv toujou nan yo, e non a zansèt mwen yo, Abraham avèk Isaac. Ke yo kapab grandi vin fè yon gwo pèp nan mitan mond lan.” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Lè Joseph te vin wè ke papa li te poze men dwat li sou tèt Éphraïm, sa te fè l pa kontan. Li te sezi men papa li pou deplase li sou Éphraïm, ale vè tèt Manassé. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph te di papa l: “Se pa sa, papa, paske se sila a ki premye ne a. Mete men dwat ou sou tèt li.” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Men papa li te refize. Li te di: “Mwen konnen, fis mwen, mwen konnen. Li osi va devni yon pèp, e li osi va vin gran. Poutan, pi jenn frè li a va pi gran pase li, e desandan li yo va devni yon gran pèp a nasyon yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Li te beni yo nan jou sa a, e te di: “Pa nou menm, Israël va eksprime benediksyon li yo e va di: ‘Ke Bondye kapab fè nou tankou Éphraïm ak Manassé!’” ");
INSERT INTO hatbsa_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Konsa, Israël te di a Joseph: “Gade byen, mwen prèt pou mouri, men Bondye va avèk ou, e Li va mennen ou retounen nan peyi a zansèt ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Mwen bay ou yon pòsyon anplis ke frè ou yo, ke m te pran nan men Amoreyen yo avèk nepe mwen ak banza mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Epi Jacob te rele fis li yo e te di: “Rasanble nou menm pou m kapab di nou sa k ap rive nou nan jou k ap vini yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Rasanble nou ansanm e tande, fis a Jacob yo. Koute Israël, papa nou. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, se ou ki premye ne mwen an; pouvwa mwen, kòmansman nan gwo fòs mwen, premye nan respè e premye nan fòs. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","San kontwòl tankou dlo k ap bouyi, ou p ap genyen premye; akoz ke ou te monte sou kabann papa ou, epi ou te souye li. Li te monte sou kabann mwen. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Siméon avèk Lévi se frè yo ye. Nepe pa yo se zouti vyolans. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Pa kite nanm mwen antre nan konsèy pa yo; pa kite glwa mwen vin reyini avèk asanble pa yo. Akoz nan kòlè yo, yo te touye moun, e nan volonte egoyis pa yo, yo te koupe blese jarèt bèf. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Modi se kòlè yo, paske li fewòs; epi vanjans yo, paske li te mechan. Mwen va separe yo nan Jacob, e gaye yo nan Israël. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, frè ou yo va ba ou lwanj; men ou ap sou kou lènmi ou yo. Fis a papa ou yo va vin bese ba devan ou. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda se jèn pòtre a yon lyon; depi nan manje ou, fis mwen, ou gen tan monte. Li bese kò l, li kouche tankou yon lyon, e tankou yon lyon, se kilès ki gen kouraj pou fè l leve? ");
INSERT INTO hatbsa_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Baton gouvènans p ap janm sòti sou Juda, ni bwa règleman p ap janm antre pye li jis lè Schilo vini, e a li menm va parèt obeyisans a tout nasyon yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Li mare jenn bourik li ak pi bèl pye rezen an. Li lave vètman li yo nan diven, ak manto li yo nan san rezen yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Zye li fonse wouj akoz diven an, e dan li blanchi nan lèt la. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon va demere bò lanmè; li va yon pwotèj pou gwo bato yo. Lizyè l va ak Sidon. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issacar se yon bourik gwo fòs k ap kouche ba nan mitan makout bèt. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Lè li te wè ke plas repo sa a te dous, e tè a te fè l plezi, li te double zepòl li pou pote chaj yo, e li te devni yon esklav pou kòve. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan va jije pèp li kon youn nan tribi Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan va yon sèpan ki nan wout, yon koulèv avèk kòn nan chemen k ap mòde talon cheval la, pou fè chevalye li tonbe an aryè. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Paske delivrans ou m ap tann, o SENYÈ. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Pou Gad, piyajè yo va piyaje li, men li va piyaje vè talon pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Pou Aser, manje li va rich, e li va pwodwi bagay ki delika e ki wayal. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nephthali se yon bich ki vin lage. Li donnen bèl pitit. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph se yon branch ki donnen fwi; yon branch avèk fwi toupre yon sous. Branch li yo kouri sou yon miray. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Achè yo te atake avèk rayisman, yo te tire sou li e yo te anmède li; ");
INSERT INTO hatbsa_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","men banza li te rete fèm, e bwa li yo te fò; depi nan men Toupwisan Jacob la (depi la se Bèje a, Wòch Israël la), ");
INSERT INTO hatbsa_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Depi nan Bondye a papa ou ki bay ou soutyen an; Toupwisan an ki beni ou avèk benediksyon anwo nan syèl la, benediksyon ki sòti nan fon ki anba a, e benediksyon tete matris ak vant ki te fè ou a. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Benediksyon a papa ou yo gen tan fin depase sila a zansèt pa m yo jis rive nan limit kolin ki dire pou tout tan yo. Yo va rete sou tèt a Joseph, sou kouwòn a tèt ki byen distenge pami frè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin se yon lou voras; nan maten li va devore sa ke li kenbe, e nan aswè, li va divize piyaj la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tout sa yo se douz tribi Israël yo, e se sa ke papa yo te di yo lè li te beni yo. Li te beni yo, yo chak avèk yon benediksyon ke yo te merite. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Konsa, li te bay yo chaj, e li te di yo: “Mwen prèt pou ranmase vè moun mwen yo. Antere mwen avèk zansèt mwen yo nan kav ki nan chan Éphron an, Etyen an, ");
INSERT INTO hatbsa_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nan kav ki nan chan Macpéla a, ki avan Mamré nan peyi Canaan an, ke Abraham te achte ansanm avèk chan nan men Éphron, Etyen an pou yon plas antèman. ");
INSERT INTO hatbsa_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","“La menm yo te antere Abraham avèk madanm li Sarah, la yo te antere Isaac avèk madanm li Rebecca, e se la mwen te antere Léa; ");
INSERT INTO hatbsa_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","chan an avèk kav ki ladann nan, te achte nan men fis a Heth yo.” ");
INSERT INTO hatbsa_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Lè li te fin chaje fis li yo, li te rale pye li anndan kabann nan, li te respire dènye souf li, e li te vin ranmase vè moun li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph te tonbe sou figi a papa li. Li te kriye sou li, e li te bo li. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph te kòmande sèvitè li yo avèk doktè yo pou anbome kò papa l. Donk, doktè yo te anbome Israël. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Alò, karant jou te nesesè pou sa, paske se tan sa a li te pran pou anbome. Epi Ejipsyen yo te kriye pou li pandan swasanndi jou. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Lè jou doulè pou li yo te fin pase, Joseph te pale a lakay Farawon, e te di: “Si koulye a mwen jwenn favè nan zye nou, souple, pale avèk Farawon, e di: ");
INSERT INTO hatbsa_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Papa m te fè m sèmante e te di: ‘Gade byen, mwen prèt pou mouri. Nan tonm mwen ke m te fouye pou mwen menm nan peyi Canaan an, se la nou va antere mwen.’ Alò, pou sa, kite mwen monte pou antere papa m; epi mwen va retounen.” ");
INSERT INTO hatbsa_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farawon te di: “Ale monte antere papa ou, jan li te fè ou sèmante a.” ");
INSERT INTO hatbsa_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Alò, Joseph te monte pou antere papa li, e avèk li te monte tout sèvitè a Farawon yo, ansyen lakay li yo, ak tout ansyen a peyi Égypte yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Tout lakay Joseph avèk frè li yo, ak lakay papa li te ale. Yo te kite sèlman timoun yo, bann mouton yo ak twoupo yo nan peyi Gosen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Osi te monte avèk li, cha yo avèk chevalye yo. Epi se te yon gran konpanyen. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Lè yo te vin nan glasi vannen kote Athad la, glasi ki lòtbò Jourdain an, yo te fè anpil kriye avèk gwo lamantasyon byen tris. Li te obsève sèt jou lamantasyon pou papa li. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Alò, lè abitan nan peyi a, Kananeyen yo te wè lamantasyon sa a nan glasi vannen Athad la, yo te di: “Sa se yon lamantasyon trè di pou Ejipsyen yo.” Pou rezon sa a, yo te rele li Abel-Mitsraïm, ki vle di lòtbò Jourdain an. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Se konsa fis li yo te fè pou li jan li te kòmande yo a; ");
INSERT INTO hatbsa_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","paske fis li yo te pote li nan peyi Canaan an. Yo te antere li nan kav kote chan a Macpéla a avan Mamré, ke Abraham te achte ansanm avèk chan an pou yon kote antèman nan men Éphron, Etyen an. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Apre li te antere papa li, Joseph te retounen an Égypte—li menm, frè li yo, ak tout moun ki te monte avèk li pou antere papa li yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Lè frè a Joseph yo te wè ke papa yo te mouri, yo te di: “Kisa ki va rive si Joseph toujou pote lahèn kont nou, e deside fè vanjans pou sa nou te fè l la?” ");
INSERT INTO hatbsa_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Epi yo te voye vè Joseph e te di: “Papa ou te pase lòd avan li te mouri. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Konsa ou va di a Joseph: Souple, mwen mande ou padon pou transgresyon a frè ou yo avèk peche pa yo, paske yo te fè ou tò.’ Koulye a, souple, padone transgresyon sèvitè Bondye a papa ou yo.” Epi Joseph te kriye lè yo te pale avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Frè li yo anplis, te vin tonbe ba devan li, e yo te di: “Gade byen, nou se sèvitè ou.” ");
INSERT INTO hatbsa_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Konsa, Joseph te di yo: “Pa pè; èske mwen nan plas Bondye? ");
INSERT INTO hatbsa_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Pou nou menm, nou te anvizaje mal kont mwen, men Bondye te anvizaje sa ki bon pou Li ta kapab fè rive rezilta ke nou wè koulye a devan nou an, pou L ta kapab prezève vi a anpil moun. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pou sa, pa pè. Mwen va fè pwovizyon pou nou avèk pitit nou yo.” Li te rekonfòte yo e li te pale avèk tandrès avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Alò, Joseph te rete an Égypte, li menm avèk lakay papa li, epi Joseph te viv pandan san-dis ane. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph te wè twazyèm jenerasyon nan fis Ephraim yo, e anplis, fis a Makir yo, fis a Manassé a te fèt sou jenou a Joseph. ");
INSERT INTO hatbsa_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph te di frè li yo: “Mwen prèt pou mouri men Bondye va asireman pran swen nou, e Li va fè nou sòti nan peyi sa a vè peyi ke li te pwomèt nan sèman li a Abraham, Isaac, ak Jacob la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Konsa, Joseph te fè fis Israël yo sèmante. Li te di: “Anverite, Bondye va pwoteje nou, e nou va pote zo mwen monte kite isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Alò, Joseph te mouri nan laj san-dis ane. Li te anbome e yo te plase li nan yon sèkèy an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Alò sa yo se non fis Israël yo ki te vini an Égypte avèk Jacob; yo chak te vini avèk fanmi pa yo: ");
INSERT INTO hatbsa_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Siméon, Lévi, Juda, ");
INSERT INTO hatbsa_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulon, Benjamin, ");
INSERT INTO hatbsa_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nephthali, Gad, ak Aser. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Tout moun ki te sòti nan zantray Jacob yo te swasann-dis moun, men Joseph te deja an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph te mouri, ni tout frè li yo avèk tout jenerasyon sila a. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Men fis Israël yo te pwodwi anpil, yo te vin miltipliye anpil, e yo te vin trè fò, jiskaske peyi a te vin ranpli avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Alò yon wa tounèf ki pa te konnen Joseph te vin leve sou Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Li te di a pèp pa li a: “Gade byen, moun a fis Israël yo vin plis, e pi fò ke nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Vini, annou aji avèk sajès avèk yo, sinon yo va miltipliye, e si gen lagè, yo va fè alyans avèk sa ki rayi nou yo, pou goumen kont nou e kite peyi a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Konsa, yo te chwazi sipèvizè sou yo pou aji di avèk yo pou fè yo travay pi rèd. Yo te bati pou Farawon vil Pithom avèk Ramsès yo pou konsève sereyal. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Men plis ke yo t ap aflije yo, plis ke yo t ap ogmante, e plis yo t ap grandi. Konsa Ejipsyen yo te vin gen gwo laperèz pou fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Yo te vin fòse fis Israël yo travay di. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Yo te fè vi yo vin amè avèk travay di nan mòtye avèk brik, e ak tout kalite travay nan chan an. Tout se te kòve ke yo te enpoze byen rèd sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Alò wa Égypte la te pale avèk fanm saj Ebre yo. Youn nan yo te rele Schiparaavèk, e lòt la yo te rele Pua. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Li te di yo: “Lè nou ap ede fanm Ebre yo akouche, e wè yo sou chèz doulè a, si se yon gason, nou va mete l a lanmò; men si se fi, li va viv.” ");
INSERT INTO hatbsa_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Men fanm saj yo te pè Bondye, yo pa t fè jan wa Égypte la te kòmande yo a, men yo te kite gason yo viv. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Epi wa Égypte la te rele fanm saj yo. Li te di yo: “Poukisa nou te fè bagay sa a, e kite gason yo viv la?” ");
INSERT INTO hatbsa_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Fanm saj yo te di a Farawon: “Akoz fanm Ebre yo pa tankou fanm Ejipsyen yo. Yo gen anpil fòs, e yo akouche pitit yo avan ke fanm saj la rive kote yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Alò Bondye te bay gras a fanm saj yo. Konsa, pèp Ebre a te vin miltipliye e te vin trè fò. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Akoz fanm saj yo te krent Bondye, Li te bay yo gran fanmi yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Alò Farawon te kòmande tout pèp li a e te di: “Chak fis ki ne, nou va jete l nan lariviyè Nil lan, e chak fi nou va kenbe l vivan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Alò, yon mesye lakay Lévi te marye avèk yon fi Lévi. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Fanm nan te vin ansent, li te fè yon fis. Lè l te wè ke li te byen bèl, li te kache li pandan twa mwa. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Men lè li pa t kab kache li ankò, li te pran yon panyen wozo, e li te kouvri li avèk goudwon ak gòm rezen. Konsa, li te mete pitit la ladann, e te plase li pami wozo yo akote lariviyè Nil lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Sè li a te kanpe nan yon distans, pou wè kisa ki kab rive li. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Fi a Farawon an te vin desann pou benyen nan Nil lan avèk sèvant li yo e yo t ap mache akote Nil lan. Konsa, li te wè panyen an pami wozo yo. Li te voye sèvant li an pou pote bay li. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Lè li te ouvri li; li te wè pitit la, e gade byen, li t ap kriye. Konsa, li te gen pitye pou li e te di: “Sa se youn nan pitit Ebre yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Epi sè li a te di a fi Farawon an: “Èske mwen ta dwe al chache yon fanm nouris pami fanm Ebre yo pou ou pou l ka ba li tete pou ou?” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Epi fi a Farawon an te di li: “Ale”. Konsa, fi a te al rele manman a pitit la. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Epi fi a Farawon an te di li: “Pran pitit sa a ale, bay li tete pou mwen e mwen va ba ou salè ou.” Epi fanm nan te pran pitit la e li te bay li tete. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Pitit la te grandi, li te pote li bay fi a Farawon an, li te devni fis li. Li te bay li non Moïse, e li te di: “Akoz ke m te rale li sòti nan dlo a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Li te vin rive nan jou sa yo ke lè Moïse te fin grandi, li te sòti vè frè li yo, e li te wè fado yo. Li te wè yon Ejipsyen ki t ap bat yon Ebre, youn nan frè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Alò li te gade toupatou e lè l pa t wè pèsòn, li te touye li, e li te kache li nan sab la. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Li te sòti nan pwochen jou a, e gade, de Ebre t ap goumen youn avèk lòt. Li te di a sa ki gen tò a: “Poukisa ou ap frape pwochen ou an?” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Men li te di: “Kilès ki te fè ou prens, oswa jij sou nou? Èske ou gen entansyon vin touye mwen jan ou te touye Ejipsyen an?” Alò konsa Moïse te vin pè. Konsa li te di: “Anverite, afè sa gen tan vin konnen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Lè Farawon te tande afè sila a, li te eseye touye Moïse. Men Moïse te sove ale de prezans li, li te vin demere nan peyi Madian, e li te vin chita la akote yon pwi. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Alò, prèt Madian an te gen sèt fi. Yo te vin rale dlo e te ranpli veso yo pou bay bann mouton papa yo dlo. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Bèje yo te vin pouse yo ale, men Moïse te kanpe pou ede fi yo, e te bay bann mouton pa yo bwè. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lè yo te vin kote Réuel, papa yo, li te di: “Poukisa nou gen tan tounen tèlman vit konsa jodi a?” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Yo te di: “Yon Ejipsyen te delivre nou anba men a bèje yo, e anplis, li te menm rale dlo pou nou e te bay bann mouton an dlo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Li te di fi li yo: “Alò, kibò li ye? Poukisa nou te kite mesye sa a dèyè? Envite li vin manje yon bagay.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moïse te dakò rete avèk mesye a, e li te bay fi li, Séphora a Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Konsa, li te bay nesans a yon fis e li te nonmen li Guerschom, paske li te di: “Mwen te yon vwayajè nan yon peyi etranje.” ");
INSERT INTO hatbsa_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Alò li te vin rive nan jou sa yo ke wa Égypte la te mouri. Epi fis Israël yo t ap fè gwo souf e t ap kriye akoz esklavaj la. Alò, kri pa yo akoz esklavaj sila a, te leve rive jwenn Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Konsa, Bondye te tande plent pa yo, epi Bondye te sonje akò Li avèk Abraham, Isaac, ak Jacob. ");
INSERT INTO hatbsa_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Bondye te wè fis Israël yo, e Bondye te konprann. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Alò, Moïse t ap swiv bann mouton Jétro a, bòpè li, prèt Madyan an. Li te mennen bann mouton an vè fas lwès nan dezè a, e li te vini Horeb, sou mòn Bondye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Zanj Bondye a te parèt kote li nan yon flanm dife ki t ap brile nan mitan yon ti bwa. Li te gade, e vwala, ti bwa a t ap fè flanm dife, men brile a pa t fè l disparèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Alò, Moïse te di: “Se fò pou m vire akote koulye a pou m al wè bagay etonan sila a, poukisa ti bwa a pa brile nèt.” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Lè SENYÈ a te wè ke li te vire akote pou gade, Bondye te rele li depi nan mitan ti bwa a, e te di: “Moïse, Moïse!” Li te di: “Men Mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Li te di: “Pa vin pre isit la. Retire sapat nan pye ou, paske plas kote ou kanpe a se tè sen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Li te di anplis: “Mwen se Bondye a zansèt ou yo, Bondye Abraham nan, Bondye a Isaac, e Bondye a Jacob la.” Moïse te kache figi li, paske li te pè gade Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","SENYÈ a te di: “Mwen vrèman te wè soufrans a pèp Mwen an ki an Égypte la, e Mwen te reponn a kri pa yo, akoz sila yo k ap peze yo, paske Mwen konnen soufrans yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Konsa, Mwen te desann pou delivre yo anba pouvwa Ejipsyen yo, pou mennen yo monte kite peyi sa a pou rive nan yon bon peyi byen vast, yon peyi k ap koule lèt ak myèl, nan plas kote Kananeyen yo avèk Etyen yo, Amoreyen yo avèk Ferezyen yo, Evyen yo, ak Jebizyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Alò, gade byen kri fis Israël yo gen tan rive devan M. Anplis, Mwen te wè avèk ki opresyon Ejipsyen yo ap oprime yo a. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Pou sa, vin koulye a, e Mwen va voye ou kote Farawon, pou ou kapab mennen fis Israël yo soti an Égypte.” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Men Moïse te di Bondye: “Kilès mwen ye, pou mwen ta ale kote Farawon, e pou m ta mennen fis Israël yo soti an Égypte?” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Li te di: “Anverite, Mwen va avèk ou. Men sign a ou menm ke se Mwen ki te voye ou; lè ou fin mete pèp la deyò Égypte, ou va adore Bondye sou mòn sila a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Epi Moïse te reponn Bondye: “Gade byen, lè m ale kote fis Israël yo, e Mwen va di yo: ‘Bondye a zansèt nou yo te voye mwen vè nou.’ Alò, yo kab petèt di mwen: ‘Kòman yo rele Li?’ Kisa m ap di yo?” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Bondye te di a Moïse: “Mwen Se ke Mwen Ye!” epi Li te di: “Konsa ou va pale a fis Israël yo: ‘Mwen Se te voye mwen kote nou.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Bondye, anplis ke sa te di a Moïse: “Konsa ou va di a fis Israël yo, ‘SENYÈ a, Bondye a zansèt nou yo a, Bondye Abraham nan, Bondye Isaac la, e Bondye a Jacob la, te voye mwen vin kote nou.’ Sa se non Mwen pou tout tan, e sa se non Mwen k ap nan memwa a tout jenerasyon yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","‘Ale rasanble tout ansyen an Israël yo ansanm e di yo: SENYÈ a, Bondye a zansèt nou yo a, Bondye Abraham nan, Isaac, ak Jacob la, te parèt kote mwen e te di: “Mwen anverite te vizite nou menm, e Mwen te wè sa k ap fèt a nou menm an Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","“‘Epi Mwen te di: ‘Mwen va mennen nou soti deyò pou kite afliksyon Égypte la, pou rive nan peyi ki pou Kananeyen yo, Etyen yo, Amoreyen yo ak Ferezyen yo, Evyen yo, ak Jebizyen yo nan yon peyi ki koule lèt ak myèl.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Yo va koute sa ke ou di yo a. Konsa, ou menm avèk ansyen an Israël yo va vin kote wa Égypte la, e nou va di li: ‘SENYÈ a, Bondye a Ebre yo, te rankontre ansanm avèk nou. Pou sa, souple, kite nou fè yon vwayaj distans a twa jou nan dezè a, pou nou kapab fè sakrifis a SENYÈ a, Bondye nou an.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Men Mwen konnen ke wa Égypte la p ap kite nou ale, sof ke pa lafòs. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","“Pou sa Mwen va lonje men M pou frape Égypte avèk tout zèv etonan ke Mwen va fè nan mitan tout sa. Epi apre sa, li va kite nou ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Mwen va bay favè a pèp sa a devan zye Ejipsyen yo, e sa va fè ke lè nou prale, nou p ap soti men vid. ");
INSERT INTO hatbsa_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Men chak fanm va mande a vwazen li ak fanm ki rete lakay li a pou bay li kèk bagay ki fèt an ajan, avèk kèk bagay ki fèt an lò avèk rad yo. Nou va mete yo sou fis nou ak fi nou yo. Se konsa nou va piyaje Ejipsyen yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moïse te di: “Men kisa si yo pa kwè m, ni koute sa ke mwen di a?” Paske yo ka petèt di: “SENYÈ a pa t parèt kote ou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","SENYÈ a te di li: “Kisa sa ye nan men ou la a?” Epi li te di: “Yon baton.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Li te di: “Jete l atè.” Moïse te jete l atè, e li te vin tounen yon sèpan; epi Moïse te kouri kite l. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Men SENYÈ a te di a Moïse: “Lonje men ou e kenbe l nan ke l.” Li te lonje men l, li te kenbe l nan ke l, e li te tounen yon baton nan men li. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“Pou yo ta kapab kwè ke SENYÈ a, Bondye Abraham nan, Bondye Isaac la, ak Bondye Jacob la te parèt a ou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","SENYÈ a anplis te di l: “Alò, fouye men ou antre kot kè ou.” Konsa, li te mete men l anndan sou kè li, e lè l te rale l deyò, li te devni lèp tankou lanèj. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Li te di l: “Mete men ou antre kot kè ou ankò.” Li te mete men l antre kot kè l ankò, e lè l te rale l, konsa, li te vin nèf tankou rès chè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Si yo pa kwè ou ni resevwa temwayaj premye sign lan, yo ka petèt kwè temwayaj dènye sign lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Men si yo pa kwè menm de sign sa yo ni koute sa ou di a, alò, ou va pran kèk dlo nan lariviyè Nil lan, e vide li sou tè sèch la; epi dlo ke ou pran nan Nil lan va vin tounen san sou tè sèch la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moïse te di a SENYÈ a: “Souple, SENYÈ, mwen pa t janm yon moun ki fò nan pale, ni nan tan sa a, ni nan tan pase, ni depi Ou te pale a Sèvitè ou a, paske mwen lan nan pale, e mwen lan nan langaj.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","SENYÈ a te di li: “Kilès ki te fè bouch a lòm? Oswa kilès ki te fè l bèbè, (oswa) soud, oswa pou l wè oswa pou li pa wè. Èske se pa Mwen, SENYÈ a? ");
INSERT INTO hatbsa_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Alò ale, e Mwen menm, Mwen va avèk bouch ou, pou enstwi ou nan kisa ou gen pou di.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Men li te di: “Souple, Senyè, koulye a voye mesaj la pa nenpòt lòt moun ke ou pito.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Konsa, lakòlè SENYÈ a te brile kont Moïse, e Li te di: “Èske pa gen frè ou a, Aaron, Levit la? Mwen konnen ke li konn pale avèk fasilite. E anplis de sa, gade, l ap vin rankontre ou. Lè li wè ou, kè li va kontan. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","“Ou gen pou pale avèk li, e mete pawòl yo nan bouch li. Mwen va avèk bouch pa w ak bouch pa l, e Mwen va enstwi ou kisa ou gen pou fè. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","“Anplis de sa, li va pale a pèp la pou ou. Li va tankou bouch ou, e ou va tankou Bondye pou li. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ou va pran nan men ou baton sila a; avèk li ou va fè sign yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Konsa, Moïse te pati e te retounen vè Jéthro, bòpè li a. Li te di li: “Souple, kite mwen ale pou mwen kapab retounen bò kote frè m yo an Égypte, pou wè si yo toujou vivan.” Jéthro te di a Moïse: “Ale anpè.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Alò SENYÈ a te di a Moïse nan Madian: “Ale retounen an Égypte, paske tout mesye ki t ap chache lavi ou yo gen tan mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moïse te pran madanm li avèk fis li yo; yo te monte sou yon bourik e yo te retounen nan peyi Égypte la. Anplis, Moïse te pran baton Bondye a nan men l. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","SENYÈ a te di a Moïse: “Lè ou retounen an Égypte, fè byen si ke ou fè tout mèvèy yo devan Farawon ke M te bay ou pouvwa fè yo. Men Mwen va fè kè l di pou li pa kite pèp la ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ou va di a Farawon: ‘Men kijan SENYÈ a pale: Israël se fis Mwen, premye ne Mwen an. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Epi Mwen te di ou: Kite fis Mwen an ale pou l kapab sèvi M, men ou te refize kite l ale. Gade byen, Mwen va touye fis ou a, premye ne pa w la.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Alò li te vin rive ke nan plas lojman an sou wout la SENYÈ a te rankontre Moïse e Li te chache touye li. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Konsa, Séphora te pran yon kouto wòch silèks, li te koupe prepis a fis li a; li te jete li devan pye a Moïse, e te di li: “Ou vrèman se yon mari pa san pou mwen menm.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Epi li te kite li anpè. Nan moman sa a, li te di: “Ou se yon mari pa san —akoz sikonsizyon an.” ");
INSERT INTO hatbsa_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Alò SENYÈ a te di a Aaron: “Ale rankontre Moïse nan dezè a.” Konsa li te ale rankontre li nan mòn Bondye a e te bo li. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moïse te di Aaron tout pawòl ke SENYÈ a te voye avèk li a, ak tout sign ke Li te bay li lòd fè yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Alò, Moïse avèk Aaron te ale e te reyini tout ansyen nan fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Konsa, Aaron te pale tout mo ke SENYÈ a te pale bay Moïse yo. Epi li te fè tout sign yo devan zye a pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Alò pèp la te vin kwè, lè yo te tande ke SENYÈ a te gen kè pou fis Israël yo, e ke Li te vin wè afliksyon yo. Yo te bese ba, pou te adore Li. ");
INSERT INTO hatbsa_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Apre, Moïse avèk Aaron te vin di a Farawon: “Konsa pale SENYÈ a, Bondye Israël la, ‘Kite pèp mwen an ale pou yo kapab selebre yon fèt pou Mwen nan dezè a.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Men Farawon te di: “Kilès SENYÈ a ye pou m ta obeyi vwa Li, pou kite Israël ale? Mwen pa konnen SENYÈ a, e anplis, mwen p ap kite Israël ale.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Yo te di: “Bondye a Ebre yo te reyini avèk nou. Souple, kite nou ale fè yon vwayaj twa jou nan dezè a pou nou kapab fè yon sakrifis a SENYÈ a, Bondye nou an; otreman, Li va vin tonbe sou nou ak gwo maladi, oubyen nepe.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Men wa a Égypte la te di yo: “Moïse avèk Aaron, poukisa nou ap rale pèp la kite travay li? Ale retounen nan travay nou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ankò Farawon te di: “Gade, pèp la nan peyi a koulye a vin anpil, e nou ta vle fè yo sispann fè travay yo!” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Alò menm jou a, Farawon te kòmande chèf kòve ki te sou pèp la avèk fòmann pa yo. Li te di yo: ");
INSERT INTO hatbsa_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Nou p ap bay pèp la pay ankò pou fè brik jan nou te konn fè a. Kite yo ale ranmase pay pou kont yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","“Menm fòs brik yo te konn fè avan an, fòk nou egzije yo fè l. Nou pa pou redwi li menm. Paske yo se parese! Se pou sa y ap kriye a: ‘Kite nou ale fè sakrifis a Bondye nou an.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kite travay la vin pi lou pou mesye yo. Kite yo travay pou yo pa swiv fo pawòl sa yo ankò.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Konsa, chèf kòve a pèp yo avèk fòmann pa yo te ale deyò pou te pale avèk pèp la. Li te di: “Konsa pale Farawon: ‘Mwen p ap bannou okenn pay. ");
INSERT INTO hatbsa_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Nou menm, ale chache pay nou pou kont nou nenpòt kote nou kab jwenn nan, men pou fòs travay nou oblije fè a, li p ap redwi.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Konsa, pèp la te gaye nan tout peyi Égypte la pou ranmase tij sereyal pou sèvi kòm pay. ");
INSERT INTO hatbsa_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Chèf Kòve yo te peze yo rèd. Yo te di: “Konplete menm fòs travay jounen ke nou te bannou an, menm jan ke lè nou te gen pay la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Anplis de sa, fòmann yo, fis Israël yo, ke chèf kòve Farawon yo te mete sou yo a, te pran kou. Konsa yo te mande yo: “Poukisa nou pa t konplete sa ke nou te gen pou fè a, ni ayè, ni jodi a nan fè brik yo menm jan tankou avan an?” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Epi fòmann sou fis Israël yo te vin kriye devan Farawon. Yo te di: “Poukisa ou aji konsa avèk sèvitè ou yo? ");
INSERT INTO hatbsa_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Yo pa bay pay a sèvitè yo, men yo kontinye di nou: ‘fè brik!’ E gade byen, sèvitè ou yo pran kou, men se fot pwòp pèp pa w la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Men li te di: “Nou se parese! Nou pa travay menm! Se pou sa nou di: ‘Kite nou ale fè sakrifis a SENYÈ a.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Alò koulye a, al travay! Paske nou p ap resevwa pay, men fòk nou konplete fòs kantite brik ke nou gen pou fè yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Fòmann nan fis Israël yo te wè ke yo te gen gwo pwoblèm, paske li te di yo: “Nou pa pou redwi fòs kantite brik pa jou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Lè yo te kite prezans Farawon, yo te rankontre Moïse avèk Aaron paske yo t ap tann yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Yo te di yo: “Ke Bondye kapab gade sa nou fè a, e jije nou, paske nou te fè nou vin rayisab devan zye Farawon, e devan zye tout sèvitè li yo. Konsa nou mete yon nepe nan men yo pou yo kab touye nou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Alò, Moïse te retounen vè SENYÈ a, e te di: “O SENYÈ, poukisa ou pote mal a pèp sa a? Poukisa menm ou te voye mwen an? ");
INSERT INTO hatbsa_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Depi mwen te vin kote Farawon pou pale nan non Ou a, li te fè mechanste a pèp sila a. Ni Ou pa t delivre pèp Ou a ditou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","SENYÈ a te di a Moïse: “Alò, koulye a ou va wè kisa mwen va fè a Farawon. Paske anba yon men pwisan, li va lage yo, e anba yon men pwisan, li va pouse yo sòti nan peyi li a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Bondye te pale plis avèk Moïse e te di li: “Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mwen te parèt a Abraham, Isaac, avèk Jacob, kòm Bondye Toupwisan an, men pa pwòp non Mwen, SENYÈ a, Mwen pa t janm fè yo rekonèt Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mwen te anplis etabli akò Mwen avèk yo, pou bay yo peyi Canaran an, peyi kote yo te rete kon etranje. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Anplis de sa, Mwen tande kri fis Israël yo, akoz Ejipsyen yo k ap kenbe yo nan esklavaj, e Mwen sonje akò Mwen an.” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Pou sa, di a fis Israël yo: ‘Mwen menm se SENYÈ a. Mwen va mennen nou sòti anba fado Ejipsyen yo, e Mwen va delivre nou anba esklavaj pa yo a. Mwen va anplis delivre nou avèk yon bra byen lonje, e avèk gwo jijman. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","“‘Alò, Mwen va pran nou kòm pèp pa m, e Mwen va Bondye pa nou; epi nou va konnen ke Mwen menm se SENYÈ a, Bondye pa nou an, ki te mennen nou sòti anba fado Ejipsyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mwen va mennen nou nan peyi ke M te sèmante pou bay a Abraham, Isaac, ak Jacob la, e Mwen va bannou li kòm posesyon. Mwen menm se SENYÈ a.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Alò Moïse te pale konsa avèk fis Israël yo, men yo pa t koute Moïse akoz dekourajman avèk esklavaj di a. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Ale pale Farawon, wa Égypte la, pou kite fis Israël yo sòti deyò peyi li a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Men Moïse te pale devan SENYÈ a e te di: “Gade byen, fis Israël yo pa t koute mwen. Alò, kijan Farawon ap koute mwen, paske mwen manke swa nan pale?” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Konsa, SENYÈ a te pale a Moïse avèk Aaron. Li te bay yo yon lòd pou fis Israël yo ak pou Farawon, wa Égypte la pou mennen fis Israël yo sòti nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Sa yo se te chèf an tèt yo pou lakay papa yo. Fis Ruben yo, premye ne a Israël la: Hénoc, Pallu, Hetsron avèk Carmi. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Fis Siméon yo: Jemuel, Jamin, Ohad, Jakin, ak Tsochar; epi Saül, fis a yon fanm Canaran. Sa yo se fanmi Siméon yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Men non a fis Lévi yo avèk posterite pa yo: Guerschon, Kehath, ak Merari. Ane ke Lévi te viv yo se te san-trann-sèt ane. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Fis Guerschon yo: Libni e Schimeï selon fanmi pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Fis Kehath yo: Amram, Jitsehar, Hébron, avèk Uziel. Ane Kehath te viv yo te de-san-trann-twa ane. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Fis Merari yo: Machli avèk Muschi. Sa yo se fanmi Lévi yo, avèk posterite pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram te pran pou fanm Jokébed, tant li an; epi li te fè Aaron avèk Moïse. Ane ke Amram te viv yo te de-san-trann-sèt ane. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Fis Jitsehar yo: Koré, Népheg avèk Zicri. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Fis Uziel yo: Mischaël, Eltsaphan ak Sithri. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron te pran pou fanm Élischéba, fi ki pou Amminidab la, sè Nachschon an; epi li te fè pou li Nadab, Abihu, Éléazar avèk Ithamar kòm pitit. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Fis Koré yo; Assir, Elkana, avèk Abiasaph. Sa yo se fanmi tribi Korit yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Éléazar, fis Aaron an, te marye ak youn nan fi Puthiel yo, e li te fè Phinées kòm pitit. Sa yo se chèf an tèt Levit yo selon fanmi pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Se tout sa yo ke Senyè te pale lè l te di Aaron avèk Moïse: “Mennen fis Israël yo deyò nan peyi Égypte la selon chèf lame pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Se te menm sa yo ki te pale avèk Farawon, wa Égypte la, pou fè yo mennen fis Israël yo sòti an Égypte. Se te menm Moïse avèk Aaron sa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Alò li te vin rive nan jou ke SENYÈ a te pale ak Moïse nan peyi Égypte la, ");
INSERT INTO hatbsa_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","ke SENYÈ a te pale ak Moïse e te di: “Mwen se SENYÈ a. Pale ak Farawon, wa Égypte la, tout sa ke M pale ak ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Men Moïse te di devan SENYÈ a: “Gade byen, lèv mwen pa sikonsi. Konsa, kijan Farawon va koute mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","SENYÈ a te di a Moïse: “Ou wè, Mwen fè ou vin tankou Bondye devan Farawon; epi frè ou a Aaron va pwofèt ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ou va pale tout sa ke mwen te kòmande ou yo. E frè ou a, Aaron va pale avèk Farawon pou li kite fis Israël yo ale sòti nan peyi li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","“Mwen va fè kè Farawon vin di, e mwen va miltipliye sign ak mèvèy mwen yo nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Men Farawon an p ap koute ou, epi konsa Mwen va mete men M sou Égypte. Mwen va mennen lame Mwen yo, pèp Mwen an, fis Israël yo, pou soti deyò peyi Égypte la avèk gwo jijman yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","“Ejipsyen yo va konnen ke Mwen se SENYÈ a lè mwen lonje men M sou Égypte, e fè fis Israël yo sòti nan mitan yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Alò, Moïse avèk Aaron te fè jan SENYÈ a te mande yo a; se te konsa yo te Fè l. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moïse te gen katre-ven lane, e Aaron katre-ven-twa, lè yo te pale ak Farawon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Alò SENYÈ a te pale avèk Moïse ak Aaron e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Lè Farawon pale nou pou di: ‘Fè yon mirak,’ alò nou va di a Aaron: Pran baton nou an e jete li atè devan Farawon, pou li kapab vin fè yon sèpan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Alò, Moïse avèk Aaron te vin vè Farawon, epi konsa yo te fè jis jan ke SENYÈ a te kòmande yo a. Aaron te jete baton li an atè devan Farawon avèk sèvitè li yo, epi li te devni yon sèpan. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Farawon osi te rele nonm saj avèk sa ki fè maji yo. Konsa, yo menm te fè menm bagay la tou. Majisyen nan Égypte yo te fè menm bagay avèk metye sekrè ak wanga pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Paske yo chak te jete baton yo atè, e chak te vin fè yon sèpan. Men baton Aaron an te vale lòt baton yo nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Men kè Farawon te vin di, e li pa t koute yo, jan SENYÈ a te di a. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","SENYÈ a te di a Moïse: “Kè a Farawon di; li refize kite pèp la ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ale kote Farawon nan maten. Gade byen, l ap antre nan dlo. Plase ou menm pou rankontre li arebò lariviyè Nil lan. Ou va pran nan men ou baton ki te vin tounen sèpan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ou va di li: ‘SENYÈ a, Bondye a Ebre yo, te voye m kote ou. Li te di: Kite pèp Mwen an ale, pou yo kapab sèvi Mwen nan dezè a. Men, gade byen, ou pa koute jiska prezan.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Konsa pale SENYÈ a: “Konsa ou va konnen ke Mwen se SENYÈ a: gade byen, Mwen va frape dlo ki nan Nil lan avèk baton ki nan men m nan, e li va tounen san. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Pwason ki nan Nil yo va mouri, Nil lan va vin santi move, e Ejipsyen yo va twouve ke li difisil pou bwè dlo Nil lan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Alò, SENYÈ a te di a Moïse: “Di Aaron: ‘Pran baton ou an, e lonje men ou sou dlo Égypte yo, sou rivyè yo, sou ti dlo ki koule yo, sou ti lak yo, sou rezèvwa pa yo, pou tout kapab vin tounen san. Va gen san toupatou nan tout peyi Égypte la, ni nan veso ki fèt an bwa, ak nan veso an wòch.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moïse avèk Aaron te fè sa ke SENYÈ a te kòmande yo a. Li te leve baton an wo e li te frape dlo ki te nan Nil lan, devan zye a Farawon, devan zye a sèvitè li yo, e tout dlo ki te nan Nil lan te vin tounen san. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Pwason ki te nan Nil yo te mouri, e Nil lan te vin pouri jiskaske Ejipsyen yo pa t kapab bwè dlo Nil lan. Konsa, san an te toupatou nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Men majisyen an Égypte yo te fè menm bagay la avèk metye maji pa yo. Pou sa a, kè a Farawon te vin di, e li pa t koute yo, jan Bondye te di a. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Alò, Farawon te vire antre lakay li. Li pa t pran sa akè. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tout Ejipsyen yo te fouye akote larivyè Nil lan pou jwenn dlo pou yo bwè, akoz ke yo pa t kab bwè dlo larivyè Nil lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Sèt Jou te pase apre SENYÈ a te frape Nil lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Alò SENYÈ a te di a Moïse: “Ale kote Farawon e di li: ‘Konsa pale SENYÈ a: Kite pèp Mwen an ale pou yo kab sèvi Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Men si ou refize kite yo ale, m ap frape tout tèritwa ou a avèk krapo. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nil lan va fòmante avèk krapo ki vin monte antre lakay ou, nan chanm dòmi ou, sou kabann ou, nan kay a sèvitè ou, sou pèp ou a, nan fou ou yo, ak nan veso pou fè pen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Epi krapo yo va monte sou ou menm, avèk pèp ou a, avèk sèvitè ou yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Alò SENYÈ a te di a Moïse: “Pale Aaron: ‘Lonje men ou avèk baton ou an sou rivyè yo, sou dlo k ap koule yo, sou ti lak yo, e fè krapo yo vin parèt sou peyi Égypte la.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Konsa, Aaron te lonje men l sou dlo Égypte yo, e krapo te vin kouvri peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Majisyen yo te fè menm bagay la avèk metye sekrè pa yo, e te fè krapo yo monte sou peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Alò, Farawon te rele Moïse avèk Aaron e te di: “Soupliye SENYÈ a pou Li retire krapo yo sou mwen, ak pèp mwen an, epi mwen va kite pèp la ale pou yo kapab fè sakrifis a SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moïse te di a Farawon: “Desizyon an se pa w: fè m konnen kilè ou ta vle m soupliye pou ou avèk sèvitè ou yo, avèk pèp ou a ke krapo sa yo vin detwi pami nou, ak lakay nou, pou yo kapab vin rete sèlman nan larivyè Nil lan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Alò li te reponn: “Demen”. Moïse te di: “Selon mo pa w, pou ou kapab konnen ke nanpwen anyen ki tankou SENYÈ a, Bondye nou an, ");
INSERT INTO hatbsa_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Krapo yo va pati kite nou, lakay nou yo ak sèvitè nou yo, ak pèp nou an'. Yo va vin rete sèlman nan larivyè Nil lan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Konsa, Moïse avèk Aaron te sòti devan Farawon, e Moïse te kriye a SENYÈ a, konsènan krapo yo avèk sila li te aflije Farawon yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","SENYÈ a te fè selon pawòl Moïse la. Krapo yo te mouri nan kay yo, nan lakou yo, ak nan chan yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Yo te fè gwo pil avèk yo, e peyi a te vin santi pouriti. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Men lè Farawon te vin wè sa te rezoud, li te fè kè di, e li pa t koute yo, jan SENYÈ a te di a. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Alò, SENYÈ a te di a Moïse: “Pale Aaron: ‘Lonje baton ou an e frape pousyè tè a, pou li kapab devni ti mouch fen nan tout vale an Égypte yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Yo te fè sa; Aaron te lonje men l avèk baton li an, li te frape pousyè tè a, e te vin gen ti mouch fen sou moun, ak sou bèt yo. Tout pousyè tè a te devni ti mouch nan tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Majisyen yo te eseye avèk metye maji pa yo pou pwodwi ti mouch fen yo, men yo pa t kapab. Te gen ti mouch yo ni sou moun, ni sou bèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Alò, majisyen yo te di a Farawon: “Sa se dwat Bondye.” Men kè Farawon te vin di, e li pa t koute yo, jan SENYÈ a te di a. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Alò, SENYÈ a te di a Moïse: “Leve granmmaten, e prezante ou devan Farawon, pandan l ap sòti nan dlo a, e di li: ‘Se konsa ke SENYÈ a pale: Kite pèp Mwen an ale, pou yo kapab sèvi Mwen.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","“Paske si ou pa kite pèp Mwen an ale, gade byen, Mwen va voye desann gwo mouch sou sèvitè ou yo, sou pèp ou a, ak anndan lakay ou yo. Kay Ejipsyen yo va vin ranpli avèk desant mouch, ak sou tè kote yo ap viv la. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“Nan jou sa a, Mwen va mete apa peyi Gosen, kote pèp Mwen an ap viv la, pou desant mouch yo pa rive la, pou ou ka konnen ke Mwen, SENYÈ a sou latè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Mwen va mete yon divizyon antre pèp Mwen an ak pèp pa w la. Demen sign sa a va parèt.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Alò SENYÈ a te fè sa. Te vini gran desant gwo mouch nan kay Farawon an ak kay sèvitè pa li yo, e peyi a te vin devaste akoz desant gwo mouch yo nan tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Farawon te rele Moïse avèk Aaron. Li te di: “Ale fè sakrifis a Bondye nou an pa anndan peyi a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Men Moïse te di: “Li pa bon pou nou fè sa, paske nou va fè sakrifis a SENYÈ a ki se yon abominasyon pou Ejipsyen yo. Si nou fè sakrifis ki se yon abominasyon pou Ejipsyen yo, èske yo p ap lapide nou avèk kout wòch? ");
INSERT INTO hatbsa_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nou dwe fè yon vwayaj twa jou nan dezè a, pou fè sakrifis a SENYÈ a, Bondye nou an, jan Li kòmande nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farawon te di: “M ap kite nou ale, pou nou kapab fè sakrifis a SENYÈ a, Bondye pa w la nan dezè a; men nou p ap prale lwen. Priye pou Mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Alò, Moïse te di: “Gade byen, Mwen ap sòti devan ou, mwen va priye a SENYÈ a pou desant mouch yo sòti sou Farawon, sou sèvitè li yo, ak sou pèp li a demen; men pinga kite Farawon aji an desepsyon ankò pou refize kite pèp la ale pou fè sakrifis a SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Alò, Moïse te sòti devan Farawon, e li te priye a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","SENYÈ a te fè jan Moïse te mande a, Li te fè desant gwo mouch yo vin disparèt sou Farawon, sou sèvitè li yo, ak sou pèp li a. Pa t gen youn ki te rete. ");
INSERT INTO hatbsa_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Men Farawon te andisi kè l fwa sa a ankò, e li pa t kite pèp la ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Alò, SENYÈ a te di a Moïse: “Ale bò kote Farawon e pale avèk li: ‘Konsa pale SENYÈ a, Bondye a Ebre yo: Kite pèp Mwen an ale, pou yo kapab sèvi Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Paske si ou refize kite yo ale, e kontinye kenbe yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","gade byen, men Bondye va vini avèk yon epidemi byen sevè sou bèt ki nan chan ou yo, sou cheval yo, sou bourik yo, sou chamo yo, sou twoupo yo, ak sou bann mouton yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Men SENYÈ a va distenge antre bèt Israël yo avèk bèt Ejipsyen yo, pou okenn pa mouri nan sa ki pou fis Israël yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","SENYÈ a te etabli yon tan detèmine, e Li te di: “Demen SENYÈ a va fè bagay sa a nan peyi a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Alò, SENYÈ a te fè bagay sa a nan jou ki te vini an, e tout bèt Égypte yo te mouri; men pou bèt fis Israël yo, pa gen youn ki te mouri. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farawon te voye, e gade byen, pa menm youn nan bèt Israël yo pa t mouri. Men kè Farawon te vin di, e li pa t kite pèp la ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Alò SENYÈ a te di a Moïse avèk Aaron: “Pran kèk men plen avèk poud chabon ki sòti nan fou kanari yo, e kite Moïse voye li vè syèl la devan zye a Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Li va vin fè yon poud fen ki kouvri tout peyi Égypte la, e li va devni gwo bouton k ap pete tankou maleng ni sou moun ni sou bèt.” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Alò yo te pran chabon ki sòti nan fou kanari yo, e yo te kanpe devan Farawon; epi Moïse te voye li vè syèl la, e li te devni gwo bouton k ap pete tankou maleng ni sou moun, ni sou bèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Majisyen yo pa t kab kanpe devan Moïse akoz bouton yo, paske bouton yo te sou majisyen yo menm jan ak tout Ejipsyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Men SENYÈ a te fè kè Farawon vin di, e li pa t koute yo, jan ke SENYÈ a te di a Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Alò, SENYÈ a te di a Moïse: “Leve granmmaten e kanpe devan Farawon pou di li: ‘Konsa pale SENYÈ a, Bondye a Ebre yo: Kite pèp Mwen an ale, pou yo kapab sèvi Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Paske fwa sa a, Mwen va voye tout fleyo Mwen yo sou kè ou, avèk sèvitè ou yo, avèk pèp ou a, pou ou kab konnen ke nanpwen lòt tankou Mwen sou tout latè. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","“‘Paske si Mwen te deja lonje men M pou frape ou ak pèp ou a avèk epidemi, nou t ap deja disparèt sou latè. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Men vrèman, pou rezon sa a, Mwen kite nou la jiska prezan: pou M kapab montre nou pouvwa Mwen e pwoklame pouvwa Mwen sou tout latè. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Malgre sa, ou toujou monte tèt ou kont pèp Mwen an, lè ou refize kite yo ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","“‘Gade byen, vè lè sa a demen, Mwen va voye lagrèl byen gwo, tankou yo pa janm wè an Égypte depi lè li te fonde, jiska prezan. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Alò, pou sa, mennen bèt nou yo avèk nenpòt sa nou gen nan chan an anba pwoteksyon. Chak moun oswa bèt ki twouve yo nan chan an, e ki pa mennen lakay yo, lè lagrèl la vin desann sou yo, yo va mouri.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Sèman sila pami sèvitè Farawon yo ki te krent pawòl SENYÈ a te fè pwòp sèvitè li yo avèk bèt li yo sove ale nan kay yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Men sila ki pa t okipe sa yo, te kite sèvitè li yo avèk bèt li yo nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Alò, SENYÈ a te di a Moïse: “Lonje men ou vè syèl la, pou lagrèl kapab tonbe sou tout tè Égypte la, sou moun, sou bèt, e sou chak plan nan chan tout kote nan peyi Égypte la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moïse te lonje baton li vè syèl la, e SENYÈ a te voye zeklè, loray avèklagrèl, avèk gwo kout dife ki te kouri rive jis atè. Konsa, SENYÈ a te fè lagrèl desann sou tout tè Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Alò te gen lagrèl, avèk dife ki te lanse, ki t ap vòltije tout tan nan mitan lagrèl la, byen sevè, jan peyi Égypte la pa t janm wè depi li te devni yon nasyon. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Lagrèl la te frape tout sa ki te nan chan nan tout pati an Égypte, ni moun, ni bèt. Lagrèl la te frape osi chak plan nan chan an epi te chire an mòso chak bwa nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Sèlman nan peyi Gosen an, kote fis Israël yo te ye a, pa t gen lagrèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Alò, Farawon te voye kote Moïse avèk Aaron, e te di yo: “Mwen te peche fwa sa a. SENYÈ a se sila ki dwat la, epi mwen avèk pèp mwen an se nou ki mechan. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Fè lapriyè bay SENYÈ a, paske te gen kont tonnè avèk lagrèl. Mwen va kite nou ale, e nou p ap rete ankò.” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moïse te di li: “Depi mwen kite vil la, m ap ouvri men m bay SENYÈ a. Tonnè a va sispann, e p ap gen lagrèl ankò, pou ou kapab konnen ke tè a se pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Men pou ou menm, avèk sèvitè ou yo, mwen konnen ke nou poko krent SENYÈ Bondye a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Alò pye koton swa yo avèk lòj la te gate, paske lòj la te fè gwo tèt, e koton swa a t ap boujonnen. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Men ble a avèk pitimi a pa t gate paske yo te vin mi pita. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Alò, Moïse te kite vil la sòti devan Farawon, e li te lonje men li vè SENYÈ a; epi tonnè avèk lagrèl la te sispann, e lapli pa t tonbe sou latè ankò. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Men lè Farawon te wè ke lapli avèk tonnè a te sispann, li te peche ankò, e li te andisi kè l, li menm avèk sèvitè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kè Farawon te vin di, e li pa t kite fis Israël yo ale, jan SENYÈ a te pale ak Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Alò, SENYÈ a te di a Moïse: “Ale vè Farawon, paske Mwen te fè kè l di, ak kè a sèvitè li yo, pou Mwen kapab fè sign sa yo selon Mwen menm pami yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","epi pou ou kapab rakonte nan zòrèy fis ou yo, ak fis a fis ou yo sa Mwen te fè Égypte, ak jan Mwen te fè sign Mwen yo pami yo, pou nou kapab konnen ke Mwen se SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moïse avèk Aaron te ale vè Farawon, e te di li: “Konsa pale SENYÈ a, Bondye a Ebre yo: ‘Jiska konbyen de tan ou va refize imilye ou devan Mwen? Kite pèp Mwen an ale, pou yo kapab sèvi Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","“‘Oswa, si ou refize kite pèp Mwen an ale, gade byen, demen Mwen va mennen krikèt nan tèritwa pa w la. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yo va kouvri tout sifas latè pou pèsòn pa kab wè tè a. Yo va anplis manje rès nan sa ki te chape yo—sa ki te rete pou ou aprè lagrèl la—e yo va manje chak bwa ki vin boujonnen pou ou nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Konsa, kay nou yo va vin ranpli, kay a tout sèvitè nou yo, e kay a tout Ejipsyen yo, yon bagay ke ni papa nou yo, ni papa a papa nou yo pa t janm wè, depi jou ke yo te vini sou tè a, jiska jodi a.’” Konsa, li te vire kite Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Sèvitè Farawon yo te di li: “Pou konbyen de tan mesye sila a ap rete tankou yon pèlen pou nou? Kite mesye yo ale pou yo kapab sèvi SENYÈ Bondye a yo. Èske ou pa wè ke Égypte gen tan fin detwi?” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Alò, yo te mennen Moïse avèk Aaron retounen vè Farawon. Li te di yo: “Ale sèvi SENYÈ a, Bondye ou a! Kilès nan nou k ap prale yo?” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moïse te di: “Nou va ale avèk jenn nou yo, ak granmoun nou yo. Avèk fis nou yo ak fi nou yo, avèk bann mouton nou yo, ak twoupo nou yo. Nou va ale, paske nou oblije fè yon fèt pou onore SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Alò li te di yo: “Vrèman SENYÈ a avèk nou, si janmen ou wè mwen ta kite nou avèk pitit nou yo ale! Veye nou, paske se mechanste nou anvizaje nan tèt nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Se pa konsa! Ale koulye a ak mesye ki pami nou yo, pou sèvi SENYÈ a, konsi se sa menm nou vle fè.” Konsa yo te chase yo ale kite prezans Farawon. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Alò SENYÈ a te di a Moïse: “Lonje men ou sou peyi Égypte la pou krikèt yo, pou yo kapab vin monte sou peyi Égypte la, pou yo ka manje chak plan ki nan tè a, menm tout sa ke lagrèl la te kite yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Alò, Moïse te lonje baton li sou peyi Égypte la, e SENYÈ a te dirije yon van lès sou latè pandan tout jounen an, ak tout nwit lan. Epi lè li te vin maten, van lès la te pote krikèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Krikèt yo te vini sou tout latè an Égypte. Yo te vin rete nan tout tèritwa Égypte la; yo te debòde l nèt. Pa t janm genyen fòs kantite krikèt egal a sa a, ni p ap janm genyen ankò. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Paske yo te kouvri sifas tout tè a, jiskaske latè te vin tounwa, epi yo te manje chak plant peyi a ak tout fwi nan bwa ke lagrèl te kite yo. Konsa, anyen vèt pa t rete nan bwa yo ni plant chan yo nan tout peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Alò, Farawon te fè vit pou rele Moïse avèk Aaron, e li te di: “Mwen te peche kont SENYÈ a Bondye nou an, e kont nou menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Alò, pou sa, souple padone peche mwen yo sèlman pou fwa sa a, e fè lapriyè pou mwen bay SENYÈ a, Bondye nou an, pou Li ta sèlman retire lanmò sa a sou mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Li te sòti devan Farawon e li te fè lapriyè bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Alò, SENYÈ a te fè van an chanje an yon van lwès byen fò ki te leve pran tout krikèt yo, e te voye yo nan Lamè Wouj. Menm yon sèl krikèt pa t rete nan tout tèritwa Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Men SENYÈ a te fè kè Farawon an vin di, e li pa t kite fis Israël yo ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Alò SENYÈ a te di Moïse: “Lonje men ou vè syèl la, pou kapab vin gen tenèb sou tout peyi Égypte la, menm yon tenèb tèlman lou ke yon moun ka santi l.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Alò Moïse te lonje men l vè syèl la, e te vin gen yon pwofon tenèb nan tout peyi Égypte la pandan twa jou. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Yo pa t kapab wè youn lòt ni pèsòn pa t leve kite kote yo ye a pandan twa jou. Men tout fis Israël yo te gen limyè nan andwa pa yo a. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Alò Farawon te rele Moïse. Li te di: “Ale, sèvi SENYÈ a, men kite bann mouton avèk twoupo yo dèyè. Menm pitit nou yo kapab ale avèk nou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Men Moïse te di: “Ou oblije osi kite nou fè sakrifis e brile ofrann, pou nou kapab fè sakrifis a SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Pou sa, bèt nou yo tou ap prale avèk nou. Pa menm youn zago p ap rete dèyè, paske nou va pran kèk nan yo pou sèvi SENYÈ a, Bondye nou an. Epi jiskaske nou rive la, nou menm pa konnen avèk kilès nan yo nou oblije sèvi SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Men SENYÈ a te fè kè a Farawon vin di, e li pa t dakò kite yo ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Alò, Farawon te di li: “Sòti sou mwen! Veye ou pou pa wè figi m ankò, paske nan jou ou wè figi m ou va mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moïse te di: “Ou gen rezon; Mwen p ap janmen wè figi ou ankò!” ");
INSERT INTO hatbsa_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Alò SENYÈ a te di a Moïse: “Yon malè anplis Mwen va fè rive sou Farawon, ak sou Égypte; apre sa li va kite nou sòti isit la. Lè li kite nou ale, anverite li va pouse nou ale sòti isit la nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Pale koulye a pou tout moun tande, ke chak gason mande vwazin li, e chak fanm vwazen pa li pou kèk bagay fèt an ajan ak bagay ki fèt an lò.” ");
INSERT INTO hatbsa_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","SENYÈ a te bay pèp la favè nan zye Ejipsyen yo. Anplis nonm nan, Moïse te byen estime nan peyi Égypte la, ni nan zye sèvitè a Farawon yo, ni nan zye a moun yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moïse te di: “Konsa pale SENYÈ a: ‘Vè minwit M ap prale nan mitan Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Epi tout nan premye ne nan peyi Égypte yo va mouri, soti nan premye ne Farawon ki chita sou twòn li an, jiska premye ne nan fi esklav ki dèyè wòch moulen yo; menm tout nan premye ne nan bèt yo tou. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Anplis de sa, va gen yon gran kri lamantasyon jan li pa t genyen avan, ak jan li p ap janm genyen ankò. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Men kont fis Israël yo, menm yon chen p ap jape, ni kont moun ni kont bèt, pou nou kapab konprann, jan SENYÈ a fè yon distenksyon antre Égypte avèk Israël. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","“‘Tout sa yo, sèvitè pa w yo va vin bese ba devan m, e yo va di: ‘Ale deyò, ou menm avèk tout moun ki swiv ou yo, e apre sa, mwen va ale deyò.’” Epi li te sòti devan Farawon, ranpli avèk kòlè e byen cho. ");
INSERT INTO hatbsa_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Alò SENYÈ a te di a Moïse: “Farawon p ap koute ou, pou mèvèy Mwen yo kapab vin miltipliye nan peyi Égypte la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moïse avèk Aaron te fè tout mèvèy sa yo devan Farawon; malgre sa, SENYÈ a te fè kè l di, e li pa t kite fis Israël yo sòti deyò peyi li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Alò, SENYÈ a te di a Moïse avèk Aaron nan peyi Égypte la: ");
INSERT INTO hatbsa_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Mwa sa a va vin premye nan mwa yo pou nou. Li va premye mwa nan ane a pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","“Pale a tout asanble Israël la, e di: ‘Nan dizyèm mwa sa a, yo chak va pran yon jenn mouton pou yo menm, selon kay pa yo, yon mouton pou chak kay. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Alò, si kay la twò piti pou yon jenn mouton, li menm avèk vwazen li ap pran youn pou kont yo, selon kantite moun ki nan yo selon sa ke chak moun ta kab manje, nou va divize jenn mouton an. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","“‘Jenn mouton nou an va yon jenn mal, ak laj yon lane, san defo. Nou ka pran li pami mouton yo, oswa kabrit yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nou va kenbe li jis rive nan katòzyèm jou nan menm mwa sa a, e tout asanble kongregasyon Israël la va touye li nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Anplis, yo va pran kèk nan san an, e mete li sou de chanbrann pòt kay la, ak sou de travès lento pòt kay la kote yo va manje li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“‘Yo va manje chè a menm nwit lan, boukannen li nan dife, e yo va manje li avèk pen san ledven, ak zèb anmè. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Pa manje anyen nan li ki pa kwit, ni ki bouyi avèk okenn dlo, men pito ki boukannen nan dife, ni tèt li, ni janm li yo ansanm avèk zantray li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Epi nou pa pou kite anyen nan li pou maten men nenpòt sa ki rete nan li, nan maten nou va brile li nan dife. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Alò, nou va manje li konsa: avèk senti nou mare, sapat nan pye nou ak baton nou nan men nou; epi nou va manje li byen vit—sa se Pak SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“‘Paske Mwen va pase nan peyi Égypte la nan nwit lan, e Mwen va frape tout premye ne nan peyi Égypte la, ni moun, ni bèt. Epi kont tout dye an Égypte yo, Mwen va egzekite jijman—Mwen menm se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","San an va yon sign pou nou sou kay kote nou rete yo. Lè Mwen wè san an, Mwen va pase sou nou, e nanpwen touman k ap rive nou, ni detwi nou lè Mwen frape peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“‘Alò, jou sa a va vin yon jou pa janm bliye pou nou, e nou va selebre li kòm yon fèt a SENYÈ a. Pami tout jenerasyon yo nou gen pou fete li kòm yon règleman k ap la pou tout tan.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Pandan Sèt jou nou va manje pen san ledven, men nan premye jou a, nou va retire tout ledven ki nan kay nou yo. Paske nenpòt moun ki manje nenpòt bagay avèk ledven depi nan premye jou a jis rive nan setyèm jou a, moun sa va koupe retire nèt de Israël. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","“Nan premye jou a nou va fè yon konvokasyon sen, e yon lòt konvokasyon sen nan setyèm jou a. P ap gen travay k ap fèt nan yo, sof sa ki oblije fèt pou manje a chak moun; se sa sèl nou kapab prepare. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Nou va osi obsève fèt Pen San Ledven an, paske nan jou sa a menm, Mwen te fè lame nou yo sòti nan peyi Égypte la. Pou sa, nou va obsève jou sa pandan jenerasyon nou yo kòm yon règleman k ap la pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","“Nan premye mwa a, nan katòzyèm jou nan mwa a, nan aswè, nou va manje pen san ledven an, jiska vente-yen jou nan mwa a, lè l rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Pandan sèt jou yo nou pa pou twouve ledven lakay nou paske nenpòt moun ki manje sa ki leve, moun sa a va vin koupe retire nèt de asanble Israël la, menm si se yon etranje, oswa yon natif peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nou pa pou manje anyen avèk ledven. Nan tout abitasyon nou yo nou va manje pen san ledven.” ");
INSERT INTO hatbsa_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Alò, Moïse te rele tout ansyen Israël yo e te di yo: “Ale pran pou nou menm jenn mouton yo selon fanmi nou, e touye jenn mouton Pak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nou va pran yon pake izòp e fonse li nan san basen an, epi mete kèk nan san basen an sou de chanbrann yo avèk travès lento pòt yo. Pèsòn pa pou ale deyò pòt kay li jis rive nan maten. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Paske SENYÈ a va travèse pou frape Ejipsyen yo; epi lè Li wè san sou travès lento pòt yo, ak sou de chanbrann pòt yo, SENYÈ a va pase sou pòt la, e Li p ap kite destriktè a antre nan kay nou pou frape nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Epi nou va obsève evènman sa a kòm yon règleman pou nou menm avèk pitit nou yo pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lè nou antre nan peyi ke SENYÈ a va bannou an, jan Li te pwomèt nou an, nou va obsève sèvis sakre sila a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","“Epi lè pitit nou di nou: ‘Kisa sa vle di selon sèvis sila a?’ ");
INSERT INTO hatbsa_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nou va di: ‘Sa se yon sakrifis Pak la pou SENYÈ a ki te pase sou kay a fis Israël yo nan Égypte lè Li t ap frape Ejipsyen yo, men te epanye lakay nou.’” Konsa, pèp la te bese ba, e te adore. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Alò, fis Israël yo te ale fè sa, jis jan SENYÈ a te kòmande Moïse avèk Aaron an, konsa yo te fè. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Alò li te vin rive nan minwi, SENYÈ a te frape tout premye ne nan peyi Égypte yo, depi premye ne a Farawon ki te chita sou twòn li an, jis rive nan premye ne nan kaptif ki te nan prizon yo, e menm tout premye ne nan bèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farawon te leve nan nwit lan, li ak sèvitè li yo avèk tout Ejipsyen yo. Yo te gen yon gwo lamantasyon nan tout Égypte la, paske pa t gen kay kote moun pa t mouri. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Epi li te rele Moïse avèk Aaron nan nwit lan. Li te di yo: “Leve e kite pèp mwen an, ni nou menm, ni fis Israël yo. Ale adore SENYÈ a, jan nou te di a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Pran ni bann mouton nou yo, ni twoupo nou yo, jan nou te di a, epi ale. Konsa, beni mwen tou!” ");
INSERT INTO hatbsa_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Ejipsyen yo ak ijans menm, te ankouraje pèp la pou kite peyi a byen vit, paske yo te di: “Nou tout pral mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Alò pèp la te pran pat farin ki potko leve yo, ak bòl pou petri yo byen mare nan rad yo, sou zepòl yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Alò, fis Israël yo te fè selon pawòl a Moïse la, paske yo te mande nan men Ejipsyen yo, bagay ki fèt an ajan, bagay ki fèt avèk lò, avèk vètman. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Konsa, SENYÈ a te bay pèp la favè nan zye Ejipsyen yo, jiskaske yo te sede a demann sa a. Konsa, yo te vin piyaje Ejipsyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Alò, fis Israël yo te vwayaje soti nan Ramsès rive Succoth, anviwon sis-san-mil òm apye, san kontwole timoun. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Yon gran foul byen mele osi te monte avèk yo, menm avèk bann mouton ak twoupo, yon trè gran kantite bèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Yo te kwit pat farin ke yo te fè sòti an Égypte yo, e yo te fè gato ak pen san ledven yo. Li pa t leve, akòz ke yo te chase sòti an Égypte, e yo pa t kab pran reta, ni yo pa t prepare okenn manje pou yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Alò tan ke fis Israël yo te pase an Égypte la te kat-san-trant ane. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Nan fen kat-san-trant ane yo, jis rive nan jou a menm, tout lame SENYÈ a te sòti an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Se yon nwit pou nou obsève pou SENYÈ a, paske li fè yo sòti nan peyi Égypte la. Nwit sa a se pou SENYÈ a, pou obsève pa tout fis Israël yo selon tout jenerasyon pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","SENYÈ a te di a Moise avèk Aaron: “Sa se òdonans Pak la. Okenn etranje pa pou manje li; ");
INSERT INTO hatbsa_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","men esklav a chak moun, achte avèk lajan, lè nou fin sikonsi li, alò, li kapab manje nan li. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Yon etranje ki rete pami nou, oswa yon sèvitè ki anplwaye, pa pou manje l. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Li oblije manje nan yon sèl kay. Nou pa pou mennen okenn nan chè a andeyò kay la, ni nou pa pou kase okenn nan zo li. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Tout asanble Israël la dwe obsève fèt sa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Men si yon etranje rete avèk nou, li selebre fèt Pak la bay SENYÈ a, ke tout mal gason li yo vin sikonsi, e kite li pwoche pou selebre li. Konsa, li va devni yon natif peyi a. Men okenn moun san sikonsisyon pa pou manje li. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Menm règ sa a va aplike a natif la tankou etranje ki demere pami nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Alò, tout fis Israël yo te fè sa. Yo te fè sa jis jan SENYÈ a te kòmande Moïse avèk Aaron an. ");
INSERT INTO hatbsa_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Epi nan menm jou sa a, SENYÈ a te mennen fis Israël yo sòti nan peyi Égypte la selon lòd lame pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Alò SENYÈ a te pale ak Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Konsakre pou Mwen chak premye ne; premye ne pami fis Israël yo, ni lòm, ni bèt, se pou Mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moïse te di a pèp la: “Sonje jou sa a lè nou te sòti an Égypte la, nou te pati kite kay esklavaj la. Paske ak yon men pwisan, SENYÈ a te fè nou sòti nan plas sa a. Epi anyen avèk ledven pa pou manje. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Nan jou sa a, nan mwa Abib la, nou prepare pou nou soti. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Li va fèt ke lè SENYÈ a fè nou antre nan peyi ki pou Kananeyen yo, Etyen yo, Amoreyen yo, Evityen yo, ak Jebizyen yo, peyi ke Li te sèmante a zansèt nou yo pou bannou, yon peyi k ap koule avèk lèt ak myèl, pou nou kab obsève sèvis sakre sa a nan mwa sa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“Pandan sèt jou nou va manje pen san ledven, e nan setyèm jou a va fè yon gwo fèt a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","“Pen san ledven an va manje pandan tout sèt jou yo; epi anyen avèk ledven p ap menm parèt pami nou. Ni nou p ap wè li pami nou nan tout fwontyè nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ou va pale fis ou a nan jou sa, e ou va di: ‘Se akoz sa ke SENYÈ a te fè pou mwen lè m te sòti an Égypte la.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Epi sa va sèvi kòm yon sign pou ou sou men ou, e kòm yon souvni nan fon ou, pou lalwa SENYÈ a kapab nan bouch ou; paske se te avèk yon men pwisan ke SENYÈ a te mennen nou sòti an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Pou sa nou va kenbe òdonans sa a nan tan ki chwazi chak ane a. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Alò li va rive lè SENYÈ a mennen ou nan peyi pèp Kanaran yo, jan Li te sèmante bannou avèk zansèt nou yo, e bay ou li, ");
INSERT INTO hatbsa_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ou va konsakre a SENYÈ a premye ne nan tout vant, ak premye ne nan chak bèt ke ou posede. Mal yo se pou SENYÈ a ke yo ye. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Men chak premye pòtre a yon bourik, ou va bay li kòm ranson avèk yon jenn mouton. Men si ou pa bay li kòm ranson, alò, ou va kase kou li, epi chak premye ne nan lòm pami fis ou yo ou va bay li kòm ranson. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Epi sa va fèt lè fis ou mande ou nan tan ki vini yo, pou di: ‘Kisa sa ye?’, alò ou va di li: ‘Avèk yon men pwisan SENYÈ a te mennen nou sòti an Égypte, nan kay esklavaj la. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Li te rive ke lè Farawon te fè tèt di sou afè kite nou ale a, ke SENYÈ a te touye chak premye ne ki te fèt nan peyi Égypte la, ni premye ne nan lòm, ni premye ne nan bèt. Pou sa, mwen fè sakrifis a SENYÈ a, mal yo; premye pòtre a chak vant, men premye ne nan fis mwen yo, mwen ransone yo.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Alò li va sèvi kòm yon sign sou men ou e kòm yon bando bwat kwi komemoratif ki mare sou fwon tèt ou; paske avèk yon men pwisan, SENYÈ a te mennen nou sòti an Égypte.” ");
INSERT INTO hatbsa_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Alò, lè Farawon te kite pèp la ale, Bondye pa t Mennen yo pa wout peyi Filisten yo, malgre li te toupre. Paske Bondye te di: “Pèp la kab petèt chanje lide yo lè yo wè lagè, pou yo retounen an Égypte.” ");
INSERT INTO hatbsa_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Pou sa, Bondye te mennen pèp la bò wout dezè a vè lanmè wouj la; epi fis Israël yo te monte byen prepare tankou yon lame pou kite peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moïse te pran zo Joseph yo avèk li, paske li te fè fis Israël yo sèmante solanèlman e te di: “Bondye va anverite pran swen nou, e nou va pote zo mwen yo soti isit la avèk nou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Alò yo te pati depi Succoth pou te vin kanpe Étham akote dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","SENYÈ a t ap prale devan yo nan yon pilye nwaj pandan lajounen pou mennen yo nan chemen an, e nan yon pilye dife pandan lannwit pou bay yo limyè pou yo ta kapab vwayaje lajounen, kon lannwit. ");
INSERT INTO hatbsa_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Li pa t retire pilye nwaj la nan lajounen, ni pilye dife a nan lannwit devan pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Alò, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Di fis Israël yo pou yo vire fè bak, e fè kan devan Pi-Hahiroth antre Migdol ak lanmè a. Nou va fè kan devan Baal-Tsephon, anfas li, bò kote lanmè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Paske Farawon va di de fis Israël yo: ‘Y ap mache byen egare nan peyi a; dezè a gen tan fèmen yo ladann.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Konsa Mwen va andisi kè Farawon e li va kouri dèyè yo. Epi Mwen va onore pa Farawon avèk tout lame li a, e Ejipsyen yo va vin konnen ke Mwen se SENYÈ a.” Se konsa yo te fè. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Lè wa Égypte la te avèti ke pèp la te sove ale, Farawon avèk sèvitè li yo te vin gen yon chanjman kè anvè pèp la. Yo te di: “Kisa sa ye nou fin fè la a, ke nou kite Israël ale pou kite sèvis nou yo?” ");
INSERT INTO hatbsa_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Alò, li te prepare cha li, e te pran pèp li a avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Epi li te pran sis-san cha byen chwazi, ansanm ak tout lòt cha an Égypte yo avèk gwo chèf sou yo tout. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","SENYÈ a te andisi kè Farawon, wa Égypte la, e li te kouri dèyè fis Israël yo. Paske se ak gwo kouraj ke Israël te soti. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Konsa, Ejipsyen yo te kouri dèyè yo avèk tout cheval yo ak cha Farawon yo, chevalye li yo, avèk lame li, e yo te vin parèt sou yo kanpe bò kote lanmè a, akote Pi-Hihroth, anfas Baal-Tsephon. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pandan Farawon t ap pwoche, fis Israël yo te gade, e vwala, Ejipsyen yo t ap mache dèyè yo. Yo te vin pè anpil, epi fis Israël yo te kriye fò bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Alò yo te di a Moïse: “Èske se paske pa gen tonm an Égypte ke ou mennen nou pati pou mouri nan dezè a? Poukisa ou te aji avèk nou konsa, pou fè nou sòti an Égypte? ");
INSERT INTO hatbsa_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Èske se pa pawòl ke nou te pale ou an Égypte la lè nou te di: ‘Pa deranje nou pou nou ka sèvi Ejipsyen yo?’ Paske li t ap pi bon pou nou pou sèvi Ejipsyen yo pase pou nou ta mouri nan dezè a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Men Moïse te di a pèp la: “Pa pè anyen! Kanpe la pou wè delivrans SENYÈ a va acheve pou nou jodi a. Paske Ejipsyen yo ke nou wè jodi a, nou p ap wè yo ankò jiska jamè. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","SENYÈ a va goumen pou nou pandan nou rete an silans.” ");
INSERT INTO hatbsa_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Alò SENYÈ a te di a Moïse: “Poukisa w ap kriye ban Mwen konsa? Di pèp la avanse. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Epi pou ou menm, leve baton ou an anlè. Lonje men ou sou lanmè a pou fann li. Konsa, fis Israël yo va pase nan mitan lanmè a sou tè sèch. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Pou Mwen, gade byen, Mwen va fè kè Ejipsyen yo di pou yo kouri antre dèyè yo. Konsa, Mwen va jwenn onè sou Farawon an avèk tout lame li ak cha li yo avèk kavalye li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Alò, Ejipsyen yo va vin konnen ke Mwen se SENYÈ a, lè Mwen vin onore pa Farawon, pa cha li yo, ak kavalye li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Zanj Bondye a ki t ap prale devan kan Israël la te vin deplase e te kanpe dèyè yo; epi pilye nwaj la te deplase kite devan yo, pou te kanpe dèyè yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Alò li te vin divize kan Égypte la ak kan Israël la. Te gen nwaj la ansanm avèk tenèb la, men li te bay limyè nan nwit lan. Konsa youn pa t pwoche lòt pandan tout nwit lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Alò Moïse te lonje men l sou lanmè a; epi SENYÈ a te bale lanmè a pa yon van lès byen fò tout lannwit. Li te fè lanmè a vin tounen tè sèch, e dlo a te vin fann. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Fis Israël yo te pase nan mitan lanmè a sou tè sèch, e dlo a te vin tankou yon miray pou yo sou men dwat yo ak sou men goch yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Alò, Ejipsyen yo te vin kouri dèyè yo, e tout cheval Farawon, avèk cha li yo, avèk kavalye li yo te antre kouri dèyè yo nan mitan lanmè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A la vèy nan maten, SENYÈ a te gade anba sou lame Ejipsyen yo, sou pilye a dife avèk nwaj yo, e Li te mennen lame Ejipsyen an nan yon gwo konfizyon. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Li te retire wou cha yo, e yo te mal a kondwi. Konsa, Ejipsyen yo te di: “Annou sove ale kite Israël, paske SENYÈ a ap goumen pou yo kont Ejipsyen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Alò SENYÈ a te di a Moïse: “Lonje men ou sou lanmè a pou dlo a kab retounen vin sou Ejipsyen yo, sou cha yo, ak sou kavalye yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Alò, Moise te lonje men li sou lanmè a, e lanmè a te retounen nan eta nòmal li nan granmmaten, pandan Ejipsyen yo t ap sove ale tou kont li. Konsa, SENYÈ a te boulvèse Ejipsyen yo nan mitan lanmè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Dlo a te retounen e te kouvri cha yo avèk kavalye yo, e menm tout lame Farawon ki te antre nan lanmè a dèyè yo. Pa t menm gen youn nan yo ki te rete. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Men fis Israël yo te mache sou tè sèch pase nan mitan lanmè a, e dlo a te vin tankou yon mi pou yo ni sou men dwat yo ni sou men goch yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Konsa, SENYÈ a te delivre Israël nan jou sa a nan men a Ejipsyen yo, e Israël te wè Ejipsyen yo ki te mouri sou bò lanmè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Lè Israël te wè gran pwisans ke SENYÈ a te sèvi kont Ejipsyen yo, tout Pèp la te krent SENYÈ a, e yo te kwè nan SENYÈ a ak sèvitè li a, Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Alò Moïse avèk fis Israël yo te chante chan sila a a SENYÈ a. Yo te di: “Mwen va chante a SENYÈ a paske viktwa Li etonan. Cheval la avèk moun ki monte l la, Li te voye yo nan lanmè. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“SENYÈ a se fòs mwen ak chanson mwen epi konsa, Li gen tan vin delivrans mwen. Sa se Bondye pa m, e mwen va louwe Li; Bondye a papa m nan, e mwen va leve Li wo. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","SENYÈ a se yon gèrye; Se SENYÈ yo rele L. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Cha Farawon yo avèk lame l lan, Li te voye yo nan lanmè. Pi bon pami chèf li yo te plonje mouri nan Lanmè Wouj. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Fon yo kouvri yo. Yo plonje ba nan fon yo tankou wòch. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Men dwat Ou, SENYÈ, ranpli ak majeste avèk pwisans. Men dwat Ou, O SENYÈ, vin dechire lènmi an nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ak tout grandè Ou, Ou te ranvoye tout sa yo ki leve kont Ou. Ou te voye lakolè ou deyò. Li te brile yo nèt kon pay. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Avèk gwo souf ki sòti nan nen ou kouran dlo yo vin kanpe fè gwo pil. Dlo k ap koule a te vin kanpe tankou yon miray. Fon yo te vin koule nan kè lanmè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Lènmi an te di: “Mwen va pouswiv yo; mwen va pran yo. Mwen va divize richès yo. Volonte m kont yo va satisfè. Mwen va rale nepe mwen. Se men m k ap detwi yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ou te soufle avèk van Ou. Lanmè a te vin kouvri yo. Yo te plonje tankou plon nan dlo pwisan yo ");
INSERT INTO hatbsa_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Kilès ki tankou Ou pami dye yo, O SENYÈ? Kilès ki tankou Ou? Kilès ki tankou ou nan majeste ak sentete, etonan nan lwanj, k ap fè mèvèy yo? ");
INSERT INTO hatbsa_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ou te lonje men dwat Ou; Lanmè a te vale yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nan lanmou ak mizerikòd Ou, Ou te mennen pèp ke Ou te ransone a. Nan pwisans Ou an, Ou te gide yo rive nan abitasyon sen pa Ou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Lòt nasyon pèp yo te tande. Y ap tranble. Gwo lakrent vin sezi abitan Philistine yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Epi chèf Édom yo vin sezi. Gèrye nan Moab yo pran tranble. Tout abitan Canaan yo te fonn e vin disparèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Sezisman avèk laperèz vin tonbe sou yo. Pa pwisans bra Ou, yo vin san fòs tankou wòch; jis lè pèp Ou a vin janbe, O SENYÈ, Jis lè pèp ke Ou te ransone a vin janbe. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ou va mennen yo antre, e plante yo nan gwo mòn eritaj pa Ou a, plas la, O SENYÈ, ke Ou te fè tankou abitasyon pa Ou a, lye sen an, O SENYÈ, ke men Ou te etabli a. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","SENYÈ a va renye pou tout tan, e pou tout tan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Paske cheval Farawon yo avèk cha li yo avèk mèt cheval li yo te antre nan lanmè a, e SENYÈ a te fè dlo lanmè a retounen sou yo. Men fis Israël yo te mache nan tè sèch nan mitan lanmè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Marie, pwofetès ak sè Aaron an te pran tanbouren an nan men l. Tout fanm yo te sòti dèyè li avèk tanbouren yo. Yo t ap danse. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Marie te reponn yo: “Chante a SENYÈ a, paske Li egzalte byen wo. Cheval la avèk Mèt Cheval la Li te voye yo nan lanmè.” ");
INSERT INTO hatbsa_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Alò, Moïse te mennen Israël soti kite Lanmè Wouj la. Yo te ale nan dezè Schur a, epi yo te vwayaje twa jou nan dezè a. Men yo pa t jwenn dlo. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Lè yo rive nan Mara, yo pa t kab bwè dlo Mara a, paske li te anmè. Se pou sa yo te rele l Mara. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Alò, pèp la te plenyen kont Moïse. Yo te di: “Kisa n ap bwè?” ");
INSERT INTO hatbsa_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Konsa, li te kriye a SENYÈ a, epi SENYÈ a te montre li yon pyebwa. Lè li te jete li nan dlo a, e dlo a te vin dous. La menm, Li te fè pou yo yon lòd avèk yon règleman, epi la, Li te fè yo pase a leprèv. ");
INSERT INTO hatbsa_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Li te di: “Si nou okipe byen vwa a SENYÈ a, Bondye nou an, si nou fè sa ki bon nan zye Li, si nou bay zòrèy nou a kòmandman Li yo, e kenbe lwa Li yo, Mwen p ap mete sou nou, okenn nan maladi ke M te mete sou Ejipsyen yo; paske se Mwen, SENYÈ ki geri nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Alò, yo te rive nan Élim kote ki te gen douz sous dlo ak swasann-dis palmye dat yo, e yo te fè kan akote dlo a. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Alò, yo te kite Élim, e tout asanble fis Israël yo te vini nan dezè Sin, ki te antre Élim ak Sinai an. Sa te fèt nan kenzyèm jou dezyèm mwa apre depa yo nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Konsa, tout asanble fis Israël yo te plenyen kont Moïse avèk Aaron nan dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Fis Israël yo te di yo: “Pito ke nou te mouri pa men SENYÈ a nan peyi Égypte la pandan nou t ap chita akote chodyè vyann yo, pandan nou t ap manje pen jis nou vin plen. Men ou mennen nou deyò nan dezè sila a pou touye tout asanble a avèk grangou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Alò, SENYÈ a te di Moïse: “Gade byen, Mwen va vide pen sòti nan syèl la tankou lapli pou nou. Epi pèp la va sòti chak jou pou ranmase sa ki kont pou jounen an, pou Mwen kapab fè yo pase a leprèv; pou M wè si yo va mache nan enstriksyon Mwen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Nan sizyèm jou a, lè yo prepare sa ke yo fè antre, li va doub sa ke yo konn pran pa jou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Alò, Moïse avèk Aaron te di a tout fis Israël yo: “Nan aswè nou va rekonèt ke SENYÈ a te mennen nou sòti nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Nan maten, nou va wè glwa SENYÈ a, paske Li tande plent nou yo kont SENYÈ a. Epi kisa nou ye pou nou ta plenyen kont nou?” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moïse te di: “Sa va vin rive lè SENYÈ a bannou vyann pou nou manje nan aswè, ak pen jiskaske nou vin satisfè nan maten. Paske SENYÈ a tande plent ke nou fè kont Li. Epi kisa nou ye? Plent nou yo pa kont nou, men kont SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Alò Moïse te di a Aaron: “Pale a tout asanble fis Israël yo, ‘Rapwoche nou devan SENYÈ a, paske Li tande plent nou yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Li te vin rive ke pandan Aaron t ap pale a tout asanble a fis Israël yo, ke yo te gade vè dezè a, e vwala, glwa SENYÈ a te parèt nan nwaj la. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Konsa, SENYÈ a te pale a Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mwen tande plent a fis Israël yo. Pale ak yo pou di: ‘Nan aswè avan li fènwa, nou va manje vyann, e nan maten, nou va vin plen avèk pen. Konsa, nou va konnen ke Mwen se SENYÈ a, Bondye nou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Alò, li vin rive nan aswè ke zwazo kay yo te monte. Yo te kouvri tout kan an. Nan maten an te gen yon kouch lawouze ki te antoure kan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lè kouch lawouze a te disparèt, gade, sou sifas dezè a, te gen yon bagay ki te sanble yon ti kal byen fen, ki sanble frechè lawouze sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Lè fis Israël yo te wè li, yo te di a youn lòt: “Kisa li te ye?” Paske yo pa t konnen kisa sa li te ye. Epi Moïse te di yo: “Sa se pen ke SENYÈ a bannou pou nou manje. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Men sa ke SENYÈ a kòmande: ‘Chak moun ranmase ladann selon sa ke li va manje. Nou va pran yon omè pou chak, selon kantite moun chak nan nou genyen nan tant li.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Fis Israël yo te fè sa, kèk te pran plis, e kèk te pran mwens. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Lè yo te mezire li avèk yon omè, sa ki te pran anpil yo pa t gen twòp, ni sa ki te pran piti yo pa t manke. Chak moun te ranmase sa ke li te dwe manje. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moïse te di yo: “Pa kite pèsòn konsève anyen ladann pou rive demen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Men yo pa t koute Moïse. Kèk nan yo te kite yon pati pou maten. Konsa, li te kale vè, e te vin rans. Moïse te fache avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Yo te ranmase li chak jou, chak moun selon sa li ta dwe manje. Men lè solèy la te vin cho, li te vin fann. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Alò nan sizyèm jou a, yo te pran doub fòs pen, de omè pou chak moun. Tout dirijan asanble yo te fè rapò sa, bay Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Alo, konsa li te reponn yo: “Men sa ke SENYÈ a vle: ‘Demen se yon jou Saba, yon Saba sen a SENYÈ a. Kwit sa ke nou va kwit, bouyi sa ke nou va bouyi, e tout sa ki rete, mete l akote pou konsève jis rive nan maten.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Alò, yo te mete li akote jis rive nan maten, jan Moïse te kòmande a, e li pa t vin kanni, ni li pa t gen okenn vè ladann. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moïse te di: “Manje li jodi a, paske jodi a se yon Saba a SENYÈ a. Jodi a nou p ap twouve li nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sis jou nou va pran li, men nan setyèm jou a, jou Saba a, p ap genyen okenn.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Li te rive nan setyèm jou a, ke kèk nan moun yo te ale pran, men yo pa t twouve menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Alò, SENYÈ a te di a Moïse: “Pou konbyen de tan nou va refize kenbe kòmandman Mwen yo, ak enstriksyon Mwen yo? ");
INSERT INTO hatbsa_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Gade, SENYÈ a te bannou Saba a. Pou sa, Li bannou pen pou de jou nan sizyèm jou a. Kite chak moun rete nan plas li. Pa kite pèsòn sòti nan plas li nan setyèm jou a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Pou sa, pèp Israël la te poze nan setyèm jou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Lakay Israël te nonmen li lamàn. Li te tankou grenn koryandè, blan avèk yon gou tankou gato avèk siwo myèl. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Alò, Moïse te di: “Men Sa ke SENYÈ a te kòmande, ‘Kite yon omè ladann pami tout jenerasyon yo pou yo kapab wè pen ke Mwen te bannou nan dezè a, lè Mwen te mennen nou sòti nan peyi Égypte la.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moïse te di a Aaron: “Pran yon bokal, mete yon omè plen lamàn ladann, epi plase li devan SENYÈ a pou kenbe li pandan tout jenerasyon nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Jan SENYÈ a te kòmande Moïse la, konsa Aaron te plase li devan temwen an, pou l konsève. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Fis Israël yo te manje lamàn pandan karant ane, jis lè yo te rive nan yon peyi ki te peple deja. Yo te manje lamàn jis yo rive nan fwontyè peyi Canaan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Alò, yon Omè se yon dizyèm pati a yon efa. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Alò, tout asanble a fis Israël yo te vwayaje pazapa vè dezè Sin nan. Selon kòmand a SENYÈ a, yo te fè kan nan Rephidim, men pa t gen dlo pou moun yo bwè. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Akoz sa, pèp la te chache kont avèk Moïse. Yo te di: “Bannou dlo pou nou kab bwè.” Konsa, Moïse te di: “Poukisa nou chache kont avè m? Poukisa nou pase SENYÈ a a leprèv?” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Men nan plas sa a pèp la te swaf dlo, epi yo te plenyen kont Moïse. Yo te di: “Poukisa ou te mennen nou monte isit la kite Égypte, pou touye nou avèk zanfan nou yo, ak bèt nou yo avèk swaf.” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Alò Moïse te kriye a SENYÈ a. Li te di: “Kisa pou m ta fè ak pèp sa a? Yon ti kras ankò e y ap lapide mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Alò, SENYÈ a te di a Moïse: “Pase devan pèp la, e pran avè w kèk nan ansyen Israël yo. Epi pran nan men ou baton ou avèk sila ou te frape Nil lan, e ale. Ou va frape wòch la, e dlo va sòti ladann, pou pèp la kapab bwè.” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Gade byen, Mwen va kanpe devan ou sou wòch Horeb la. Konsa, Moïse te fè sa devan zye a ansyen Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Li te nonmen kote a Massa ak Meriba, akoz kont ke fis Israël yo te genyen, e akoz ke yo te pase SENYÈ a a leprèv lè yo te di: “Èske SENYÈ a pami nou, wi oswa non?” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Alò, Amalèk te vin goumen kont Israël nan Rephidim. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Konsa, Moïse te di a Josué: “Chwazi mesye yo pou nou, e sòti pou batay kont Amalèk. Demen mwen va vin estasyone Mwen menm nan do kolin nan avèk baton a Bondye a nan men m.” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué te fè jan Moïse te mande li fè a, e li te goumen kont Amalèk. Epi Moïse, Aaron, avèk Hur te monte anwo tèt do kolin nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Konsa, li te vin rive ke lè Moïse te leve men l, pèp Israël la te vin genyen, men lè li te kite men l desann, Amalèk te vin genyen. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Men men Moïse te vin lou. Pou sa a, yo te pran yon wòch, yo te mete li anba li, e li te chita sou li. Aaron avèk Hur te bay men li soutyen, youn sou yon bò, e lòt la sou lòt bò a. Konsa men li te rete dyanm jis rive lè solèy la te vin kouche. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Epi Josué te bat Amalèk avèk pèp li a avèk lam nepe. ");
INSERT INTO hatbsa_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Alò SENYÈ a te di a Moïse: “Ekri sa a nan yon liv pou gen kòm souvni, e repete li a Josué, ke Mwen va konplètman efase memwa Amalèk soti anba syèl la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moïse te bati yon lotèl e te nonmen li: “SENYÈ a Se Drapo mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Li te di: “SENYÈ a te sèmante: SENYÈ a va fè lagè kont Amalèk de jenerasyon an jenerasyon.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Alò Jéthro, prèt Madian an, bòpè Moïse la, te tande tout sa ke Bondye te fè pou Moïse, ak pou Israël, pèp li a. Jan SENYÈ a te mennen Israël sòti an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jéthro, bòpè Moïse la, te pran Séphora, madanm a Moïse la apre li te fin voye li ale, ");
INSERT INTO hatbsa_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ansanm avèk de fis li yo. Youn nan yo te nonmen Guerschom, paske Moïse te di: “Mwen te yon vwayajè nan yon peyi etranje.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Lòt la te nonmen Eliézer, paske li te di: “Bondye a papa m nan te èd mwen, e Li te delivre m anba nepe Farawon.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Alò, Jéthro, bòpè Moïse la te vini avèk fis li yo ak madanm li vè Moïse nan dezè kote li te fè kan an, akote mòn Bondye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Li te voye di Moïse: “Mwen menm, bòpè ou Jéthro, ap vin kote ou avèk madanm ou, ak de fis li yo avè l.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Alò, Moïse te sòti pou rankontre bòpè li. Li te bese ba e li te bo li, epi yo chak te mande lòt kijan yo te ye, epi yo te antre nan tant lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moïse te pale bòpè li de tout sa ke SENYÈ a te fè Farawon an, ak Ejipsyen yo pou koz Israël, tout traka ki te vini sou yo nan vwayaj la, ak jan SENYÈ a te delivre yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jéthro te rejwi de tout bonte ke SENYÈ a te fè anvè Israël, lè l te delivre yo nan men Ejipsyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Konsa, Jéthro te di: “Beni se SENYÈ a ki te delivre ou nan men Ejipsyen yo, ak nan men Farawon, e ki te delivre pèp la anba men Ejipsyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Koulye a mwen konnen ke SENYÈ a pi gran ke tout dye yo, akoz jan yo te aji nan ògèy kont pèp la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Epi Jéthro, bòpè Moïse la te fè yon ofrann brile avèk sakrifis pou Bondye. Aaron te vini avèk tout ansyen Israël yo pou manje yon repa avèk bòpè Moïse la devan Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Li te vin rive nan pwochen jou a ke Moïse te chita pou jije pèp la, e pèp la te kanpe antoure Moïse soti nan maten pou rive jis aswè. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Alò, lè bòpè Moïse la te wè tout sa ke li te fè pou pèp la, li te di: “Kisa ke w ap fè pou pèp la konsa la a? Poukisa ou chita ou sèl ou tankou jij, e tout pèp la kanpe antoure ou soti nan maten, rive jis aswè?” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moïse te di bòpè li: “Akoz pèp la vin kote mwen pou fè demann pou jijman Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Depi yo gen kont yo vin kote mwen, mwen jije antre yon nonm avèk vwazen li e mwen fè konnen règleman Bondye avèk lalwa Li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Bòpè Moïse la te di li: “Sa ke w ap fè a pa bon. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Ou va anverite vin epwize ou nèt, ni ou menm, ni pèp ki avè w la, paske tach la twò lou pou ou. Ou p ap kapab fè l pou kont ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","“Koulye a, koute mwen. M ap ba ou konsèy, e ke Bondye kapab avè w. Ou va reprezante pèp la devan Bondye, e ou va mennen dispit yo devan Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Epi enstwi yo nan règleman avèk lalwa yo, e fè yo konnen nan chemen ke yo dwe mache a, ak travay ke yo dwe fè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“Anplis de sa, ou va chwazi pami tout pèp la, mesye ki kapab yo ki gen lakrent Bondye, moun ak verite, ki rayi richès malonèt. Konsa, ou va plase yo sou pèp la kòm chèf sou milye, sou santèn, sou senkantèn, ak sou dis. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Kite yo jije pèp la nan tout lè. Konsa, kite sa fèt ke chak gwo ka va vini devan ou, men chak ti ka, yo menm yo va jije yo. “Konsa li va pi fasil pou ou, e yo va pote chaj la avèk ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si ou fè bagay sa a jan Bondye kòmande ou a, alò, ou va gen kouraj pou andire, e anplis, tout moun sa yo va ale lakay yo anpè.” ");
INSERT INTO hatbsa_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Alò Moïse te koute bòpè li, e li te fè tout sa ke li te di yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moïse te chwazi mesye avèk kapasite pami tout Israël, e li te fè yo chèf sou pèp la, chèf sou dè milye, chèf sou dè santèn, chèf sou dè senkantèn, e sou dè dizèn. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Yo te jije pèp la nan tout tan. Ka ki difisil yo te mennen kote Moïse, e chak ti ka, yo te jije yo pou kont yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Konsa, Moïse te di bòpè li orevwa, e li te fè wout li pou ale nan peyi li. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Nan twazyèm mwa apre fis Israël yo te soti nan peyi Égypte la, nan jou sa a menm, yo te vin antre nan dezè Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Lè yo te pati soti Rephidim, yo te vini nan dezè Sinaï a. Yo te fè kan nan dezè a. Se la Israël te fè kan devan mòn lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moïse te monte vè Bondye. SENYÈ a te rele li soti nan mòn nan. Li te di: “Konsa ou va pale ak lakay Jacob la pou di fis Israël yo: ");
INSERT INTO hatbsa_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Nou menm, nou te wè sa ke Mwen te fè Ejipsyen yo, jan Mwen te pote nou sou zèl èg yo, e te mennen nou kote Mwen menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Alò, koulye a, si nou obeyi vwa Mwen, e kenbe akò Mwen, alò nou va pwòp posesyon pa M pami tout pèp yo. Paske tout latè se pou Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Konsa, nou va pou Mwen, yon wayòm prèt yo, e yon nasyon ki sen.’ Sa yo se pawòl ke ou va pale a fis Israël yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Se konsa Moïse te vini, e te rele ansyen pami pèp yo. Konsa, li te plase devan yo tout pawòl sa yo ke SENYÈ a te kòmande li. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Tout pèp la te reponn ansanm. Yo te di: “Tout sa ke SENYÈ a te pale yo, nou va fè yo!” Epi Moïse te mennen retounen tout pawòl a pèp yo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","SENYÈ a te di a Moïse: “Gade byen, Mwen va vini kote ou nan yon nwaj byen fonse, pou pèp la kapab tande lè M pale avèk ou, e pou yo kapab kwè nan ou pou tout tan.” Alò, Moïse te di SENYÈ a pawòl a pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","SENYÈ a anplis te di a Moïse: “Ale vè pèp la, konsakre yo jodi a avèk demen, e kite yo lave vètman yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","epi kite yo fin prepare pou twazyèm jou a, paske nan twazyèm jou a SENYÈ a va vin desann sou Mòn Sinaï a nan zye a tout pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","“Ou va fè bòn limit pou moun toutotou yo. Ou va di yo: ‘Gade byen pou nou pa monte sou mòn nan, ni touche rebò li. Nenpòt moun ki touche mòn nan va anverite mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Nanpwen men k ap mete sou moun sa a, men li va anverite lapide oswa frennen nèt; menm si se moun oswa bèt, li p ap viv.’ Lè twonpèt kòn lan fè yon gwo son, yo va monte vè mòn nan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Epi Moïse te desann mòn nan vè pèp la. Li te konsakre pèp la, e yo te lave vètman yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Li te di a pèp la: “Mete ou prè pou twazyèm jou a; pa pwoche pre fanm.” ");
INSERT INTO hatbsa_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Konsa, li te rive nan twazyèm jou a, lè li te vin maten, te genyen gwo tonnè avèk kout loray avèk yon nwaj byen fonse sou mòn nan, ak yon son twonpèt byen fò, jiskaske tout moun ki te nan kan an te tranble. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Epi Moïse te mennen pèp la sòti nan kan an pou rankontre Bondye. Yo te kanpe nan pye mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Alò, Mòn Sinai te nan lafimen nèt akoz SENYÈ a te desann sou li nan dife. Lafimen li te monte tankou lafimen yon founo, e tout mòn nan te tranble avèk vyolans. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Lè son twonpèt la te vin pi fò, e pi fò toujou, Moïse te pale, e Bondye te reponn avèk tonnè. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","SENYÈ a te vin desann sou Mòn Sinai, sou tèt mòn nan. Senyè a te rele Moïse anwo tèt mòn nan, epi Moïse te monte. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","SENYÈ a te pale ak Moïse: “Ale desann avèti pèp la pou yo pa pase antre vè SENYÈ a pou wè; konsa, pou anpil nan yo ta vin mouri. ");
INSERT INTO hatbsa_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Osi, ke prèt ki pwoche toupre SENYÈ yo konsakre yo menm, oswa SENYÈ a va eklate kont yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moïse te di a SENYÈ a: “Pèp la pa kapab monte sou Mòn Sinai a, paske Ou te avèti nou, e te di: ‘Mete limit bòn yo antoure mòn nan, e konsakre li.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Alò, SENYÈ a te di li: “Ale desann e monte ankò, ou menm e Aaron avèk ou. Men pa kite prèt yo, ni pèp la pase antre pou monte vè SENYÈ a, oswa L ap eklate sou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Konsa, Moïse te desann vè pèp la e te pale yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Bondye te pale tout pawòl sa yo e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Mwen menm se SENYÈ a Bondye ou a, ki te mennen ou sòti deyò nan peyi Égypte la, deyò kay esklavaj la. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ou pa pou gen lòt dye devan M. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Ou pa pou fè pou kont ou, yon zidòl, ni okenn imaj sou sa ki nan syèl la anwo, ni sou latè anba, ni nan dlo anba tè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","“Ou pa pou adore yo ni sèvi yo. Paske Mwen, SENYÈ a, Bondye pa w la. Mwen se yon Bondye jalou, k ap vizite inikite a papa yo sou pitit yo, jis rive nan twazyèm ak katriyèm jenerasyon a sila ki rayi Mwen yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","men k ap montre lanmou dous ak mizerikòd pami dè milye a sila ki renmen M, e ki kenbe kòmandman Mwen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Ou pa pou pran non SENYÈ a an ven, paske SENYÈ a p ap kite sila a ki mal sèvi ak non Li an san pinisyon.” ");
INSERT INTO hatbsa_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sonje jou Saba a pou kenbe l sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Si jou nou va travay e nou va fè tout travay nou yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","men setyèm jou a se yon jou Saba a SENYÈ a Bondye nou an. Ladan l ou pa pou fè okenn travay; ni ou menm, ni fis ou, ni fi ou, ni sèvitè ou, ni sèvant ou, ni bèf ou, ni etranje ki demere avèk ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Paske nan si jou, SENYÈ a te fè syèl la avèk tè a, lanmè a, ak tout sa ki gen ladann, e Li te repoze nan setyèm jou a. Konsa, SENYÈ a te beni jou Saba a, e te fè l sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Onore papa ou avèk manman ou, pou jou lavi ou yo kapab anpil nan peyi ke SENYÈ a, Bondye ou a te bay ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ou pa pou touye moun. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ou pa pou fè adiltè. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ou pa pou vòlè. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ou pa pou fè fo temwayaj kont vwazen ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ou pa pou fè anvi sou lakay vwazen ou; ou pa pou fè anvi sou madanm vwazen ou, ni sèvant li, ni sèvitè li, ni bèf li, ni bourik li, ni okenn bagay ki pou vwazen ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tout pèp la te tande gwonde tonnè avèk kout loray ak son a twonpèt la, ak mòn nan ki t ap fè lafimen. Lè pèp la te wè li, yo te tranble e te kanpe a yon distans. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Konsa, yo te di Moïse: “Pale avèk nou ou menm, e nou va koute; men pa kite Bondye pale avèk nou, oswa nou va mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moïse te di a pèp la: “Pa pè, paske Bondye vini pou pase nou a leprèv, e pou lakrent Li kapab rete avèk nou, pou nou pa peche.” ");
INSERT INTO hatbsa_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Alò, pèp la te kanpe a yon distans, pandan Moïse te pwoche gwo nwaj la kote Bondye. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Alò SENYÈ a te di a Moïse: “Konsa ou va pale avèk fis Israël yo: ‘Nou menm, nou gen tan wè ke Mwen te pale avèk nou depi nan syèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Nou pa pou fè lòt dye apati de Mwen menm; dye an ajan, ni dye an lò, nou pa pou fè yo pou nou menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“‘Nou va fè yon lotèl avèk tè pou Mwen, e nou va fè sakrifis sou li nan ofrann brile, ak ofrann lapè, mouton nou yo, avèk bèf nou yo. Nan chak plas kote Mwen fè non Mwen sonje, Mwen va vin kote nou, e Mwen va beni nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","“‘Si nou fè yon lotèl avèk wòch pou mwen, nou pa pou fè l avèk wòch taye, paske si ou itilize zouti ou sou li, li vin pa sen ankò. ");
INSERT INTO hatbsa_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Epi nou pa pou monte nan eskalye vè lotèl Mwen, pou nidite nou pa parèt a li.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Alò, sa yo se règleman ke ou va mete devan yo: ");
INSERT INTO hatbsa_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Si ou achte yon esklav Ebre, li va sèvi pou sizan, men nan setyèm ane a li va sòti tankou yon moun lib san peye frè. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Si li antre li sèl li, li va sòti sèl. Si se mari a yon madanm, alò, madanm nan va sòti avè l. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si mèt li bay li yon madanm, e li fè fis oswa fi pou li, madanm nan avèk pitit li yo va rete pou mèt li, e li va sòti sèl. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Men si esklav la di byen klè: “Mwen renmen mèt mwen, madanm mwen, ak pitit mwen yo; mwen p ap sòti tankou moun lib,” ");
INSERT INTO hatbsa_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","alò, mèt li va mennen li devan Bondye, e apre li va mennen li vè pòt la, oswa chanbrann pòt la. Epi konsa, mèt li va pèse zòrèy li avèk yon pwenson, e li va sèvi li nèt jis pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Si yon mesye vann fi li kòm yon esklav femèl, li pa pou lage tankou yo konn fè ak esklav mal. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si li vin degoutan nan zye mèt li ki te anvizaje li pou li menm, alò, li va kite li ransone. Li pa gen otorite pou vann li a yon pèp etranje, akoz sa li fè pa jis. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Si li ta dezinye l pou marye ak fis li, li va trete li selon koutim pwòp fi li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Si li ta vin pran pou li menm yon lòt fanm, li pa ka redwi manje li, vètman li, ni dwa konjigal li. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Si li p ap fè twa bagay sa yo pou li, alò li menm fi a va kite li gratis san peye lajan. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Sila ki frape yon mesye pou li mouri va vrèman mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Men si sa pa t rive pa eksprè nan anbiskad, men Bondye kite sa rive, alò, Mwen va chwazi yon kote pou li kapab sove ale. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Si, alò, yon mesye aji avèk mechanste kont vwazen li, pou l kab touye li nan koken, ou va pran li menm si se sou lotèl la, pou li kapab mouri. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Sila ki frape papa li oswa manman li, li va vrèman mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Sila ki kidnape yon nonm, oswa ke li vann li, oswa yo twouve li nan posesyon li, li va vrèman mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Sila ki modi papa li oswa manman li, li va vrèman mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Si de mesye gen yon kont e youn frape lòt la avèk yon wòch, oswa avèk pwen li, e li pa mouri, men l pa ka leve sou kabann li, ");
INSERT INTO hatbsa_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","si li ta leve mache deyò, malgre asistans baton li, alò, sila ki te frape li a va rete san pinisyon. Li va peye sèlman pou tan ke li pèdi a, e li va kontinye okipe li jis lè li fin geri nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Si yon mesye frape esklav li, kit mal kit femèl, avèk yon baton, epi li vin mouri nan men l, li va pini. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Malgre sa, si li leve apre youn oswa de jou, li p ap pini, pwiske sèvitè a se pwòp byen li ke li ye. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Si de mesye vin lite youn avèk lòt, yo frape yon fanm ansent e li vin akouche avan lè, men pa gen lòt pwoblèm, li va peye yon amann jan mari a fanm nan kapab mande li, e li va peye li selon desizyon jij yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Men si gen plis mal ki fèt, alò, ou va òdone kòm yon penalite vi pou vi, ");
INSERT INTO hatbsa_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","zye pou zye, dan pou dan, men pou men, pye pou pye, ");
INSERT INTO hatbsa_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brile pou brile, blese pou blese, brize pou brize. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Si yon mesye frape zye esklav li, kit mal, kit femèl, e li pèdi zye a, li va bay li libète akoz pèt zye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Si li kraze fè pèt a yon dan esklav li, kit mal, kit femèl, li va ba li libète akoz dan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Si yon bèf frennen yon mesye oswa yon fanm avèk kòn li, pou l mouri, bèf la va vrèman lapide jiskaske li mouri, e chè li p ap manje; men mèt bèf la p ap pini. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Men si yon bèf te deja gen abitid frennen moun e mèt li te avèti deja, men li pa t okipe sa, e li vin touye yon mesye oswa yon fanm, bèf la va lapide, e mèt li anplis va mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si yon amann ranson vin enpoze pou konsève lavi l, nenpòt sa yo mande, li va peye l, ");
INSERT INTO hatbsa_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Si se yon fis oswa si se yon fi ke li frennen, l ap fèt menm jan selon menm règ la. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si bèf la frennen yon mal oswa yon femèl esklav, mèt la va bay mèt li trant sik lajan, e bèf la va lapide. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Si yon mesye ouvri yon fòs, oswa fouye yon fòs e li pa kouvri li, yon bèf, oswa yon bourik tonbe ladann, ");
INSERT INTO hatbsa_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","mèt fòs la va bay rekonpans. Li va bay lajan a mèt li, e bèt mouri an va vin pou li. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Si bèf a yon mesye vin donmaje bèf a yon lòt, e li mouri, alò yo va vann bèf vivan an e divize pri li mwatye pou yo chak; epi osi yo va divize bèt mouri an. ");
INSERT INTO hatbsa_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Men, si li te deja rekonèt ke bèf la te gen abitid frennen, men mèt li pa t okipe sa, li va vrèman peye bèt pou bèt, e bèt mouri an va vin pou li. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Si yon nonm ta vòlè yon bèf oswa yon mouton epi kòche li oswa vann li, li va peye senk bèf pou bèf la, e kat mouton pou mouton an. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si vòlè a vin kenbe pandan l ap fonse antre, e bat jis li vin mouri, p ap gen koupabilite pou san li sou kont mèt kay la. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Men si solèy la gen tan leve sou li, va genyen koupabilite san sou li. Li va anverite peye dedonmajman an. Si li pa posede anyen, alò, y ap vann li pou vòl sa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si sa li te vòlè a twouve nan posesyon li, menm si se yon bourik, oswa yon mouton, li va peye li doub. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si yon mesye kite bèt li yo manje nan yon chan, oswa yon jaden jiskaske jaden an fini nèt, e kite bèt li lage pou li manje nan chan a yon lòt moun, li va peye dedonmajman an soti nan pi bon pati tè li, ak meyè pati chan rezen li an. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si yon dife vin parèt, e kouri jwenn bwa pikan yo, jis rive sereyal k ap rasanble nan chan an, oswa sereyal chan an li menm pran dife, sila ki te limen dife a va anverite peye. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Si yon mesye bay vwazen li lajan oswa byen li pou kenbe pou li, e li vòlè soti lakay mesye a, depi vòlè a kenbe, li va peye doub. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si yo pa jwenn vòlè a, alò, mèt kay la va parèt devan jij yo pou konstate si li te mete men li sou byen vwazen li an. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Pou chak vyòl konfyans, kèlkeswa ke se pou bèf, pou bourik, pou mouton, pou rad, oswa pou nenpòt bagay ki pèdi, si yon moun kapab di: “Sila se pa m nan!”, yo toude va vini devan jij yo. Konsa, sila ke jij yo kondane a va peye doub a vwazen li an. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Si yon mesye bay vwazen li yon bourik, yon bèf, yon mouton, oswa nenpòt bèt pou kenbe pou li, epi li vin mouri, oswa blese, oswa pouse ale lè moun pa wè, ");
INSERT INTO hatbsa_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","yon sèman devan SENYÈ a va fèt pa yo dèske li pa t mete men l sou byen a vwazen li. Konsa, mèt li va aksepte li, e li p ap oblije fè peye dedonmajman. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Men si li te vrèman vòlè li, li va peye dedonmajman a mèt li. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si li chire an mòso, kite sa mennen kòm evidans. Li p ap peye dedonmajman pou sa ki chire an mòso a. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Si yon mesye prete yon bagay nan men vwazen li, e sa vin donmaje oswa mouri pandan mèt li pa la, li va peye tout rekonpans. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si mèt li la avè l, li p ap peye rekonpans. Si se lwaye, sa te vini ak frè lwaye li. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si yon mesye sedwi yon vyèj ki poko fiyanse, e li vin kouche avèk li, li dwe peye li yon frè fiyanse pou l ka vin madanm li. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si papa li refize nèt pou ba li fi li, li va peye lajan ki menm fòs avèk frè fiyanse a pou vyèj yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ou pa pou kite yon majisyen viv. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Nenpòt moun ki kouche avèk yon bèt, va asireman mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Sila ki fè sakrifis a nenpòt dye, sof ke SENYÈ a sèl, va detwi nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ou pa pou fè mal a yon etranje, ni oprime li, paske se te etranje nou te ye nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Ou pa pou oprime okenn vèv, ni òfelen. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si ou oprime li, e li kriye ban Mwen, Mwen va anverite tande kri li; ");
INSERT INTO hatbsa_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","epi kòlè Mwen va vin ogmante. Mwen va touye ou avèk nepe, e madanm ou yo va vin vèv, e pitit ou yo va vin san papa. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si ou prete lajan a pèp Mwen an, a malere yo pami nou yo, ou pa pou aji kòm kreditè anvè li. Ou pa pou mande frè enterè. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si ou janmen pran manto vwazen ou kòm garanti, fòk ou remèt li li avan solèy la kouche, ");
INSERT INTO hatbsa_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","paske se sa sèl ki kouvri li. Se manto pou kò li. Kisa ankò li kab sèvi pou l dòmi? Epi li va rive ke lè li kriye fò, Mwen va tande li, paske Mwen ranpli avèk mizerikòd. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ou pa pou modi Bondye, ni modi yon chèf pèp ou. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ou pa pou fè reta avèk ofrann ki sòti nan rekòlt la avèk diven an. Premye ne nan fis ou yo, ou va ban Mwen l. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Ou va fè menm bagay la avèk bèf ou yo, ak mouton ou yo. Li va rete avèk manman l pandan sèt jou, e nan uityèm jou a ou va ban Mwen li. ");
INSERT INTO hatbsa_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Nou va dèzòm ki sen pou Mwen; konsa, nou p ap manje okenn chè ki chire an mòso nan chan. Nou va jete li bay chen. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ou pa pou pote yon fo rapò. Pa jwenn men ou avèk yon moun mechan pou devni yon move temwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ou pa pou swiv foul la nan fè mechanste, ni ou pa pou fè temwen nan yon pwosè k ap vire pou swiv foul la pou ou kapab fè lajistis vin konwonpi. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ni ou p ap apiye vè yon malere pou bay li avantaj nan pwosè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si ou rankontre bèf, oswa bourik a lènmi ou k ap pati, anverite, ou va remèt li bay mèt li. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si ou wè bourik a yon moun ki rayi ou, k ap kouche anba gwo chaj, ou p ap abandone li nan pwoblèm nan, men ou va ede l dechaje li. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ou pa pou konwonpi lajistis ki se dwa a yon malere nan pwosè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Rete lwen yon fo pwosè, e pa touye inosan an oswa moun ki dwat la, paske Mwen p ap jistifye koupab la. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ou pa pou pran lajan anba tab, paske kòb anba tab ap avegle sila ki wè klè yo, e konwonpi kòz sila ki jis yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ou pa pou oprime yon etranje, paske nou konnen pozisyon a yon etranje, konsi, nou osi te etrange nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ou va simen tè ou pou sis ane, e rekòlte donn li, ");
INSERT INTO hatbsa_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","men nan setyèm ane a ou va kite li san fè anyen pou l kab pran repo. Konsa, malere pami pèp nou an kapab manje, epi nenpòt sa yo menm ta kite, ap rete pou bèt chan yo. Ou ap fè menm bagay la avèk chan rezen e avèk chan doliv ou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Pandan sis jou ou va fè travay ou, men nan setyèm jou a, ou va sispann fè travay pou bèf ou avèk bourik ou kapab repoze, ansanm avèk fis esklav femèl ou a, ak etranje ou a tou, kapab repoze. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Alò, konsènan tout sa ke M te pale avèk nou yo, pran atansyon pou fè yo. Konsa, pa nonmen non a lòt dye yo, ni kite yo tande pawòl sa yo sòti nan bouch nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Twa fwa pa ane nou va selebre yon fèt pou Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Nou va obsève fèt Pen San Ledven an. Pandan sèt jou nou va manje pen san ledven an, jan Mwen te kòmande nou an, nan tan ki apwente nan mwa Abib la, paske nan li nou te sòti an Égypte. Epi okenn moun pèsòn p ap parèt devan M men vid. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Osi nou va obsève fèt Mwason Premye Fwi a travay nou yo, nan sa ke nou te simen nan chan, anplis, fèt rekòlt nan fen ane a lè nou fin ranmase tout fwi travay nan jaden nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Twa fwa pa lane tout mal nou yo va parèt devan SENYÈ Bondye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Nou pa pou ofri san a sakrifis Mwen ansanm avèk pen ledven. Ni grès fèt Mwen an pa pou pase lannwit pou rive nan maten. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Nou va pote pi bon nan premye fwi latè yo antre nan kay SENYÈ a, Bondye nou an. Nou pa pou bouyi yon jèn kabrit nan lèt manman li. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Gade byen, Mwen ap voye yon zanj devan nou pou pwoteje nou pandan nou nan chemen an, e pou mennen nou antre nan plas ke M te prepare pou nou an. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Rete vijilan devan li, e obeyi vwa li. Pa fè rebelyon anvè li, paske li p ap padone peche nou yo, paske non Mwen nan li. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“Men si nou vrèman obeyi vwa li, e fè tout sa ke M pale nou yo, alò, Mwen va vin lènmi ak lènmi pa nou yo, e advèsè pou advèsè nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Paske zanj Mwen va ale devan nou pou mennen nou nan peyi Amoreyen yo, Etyen yo, Ferezyen yo, Kananeyen yo, Evityen yo, ak Jebizyen yo. Epi Mwen va detwi yo nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“Nou pa pou adore dye pa yo, ni sèvi yo, ni fè selon zèv pa yo, men nou va boulvèse yo nèt e nou va kraze pilye sakre pa yo an mòso. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Men nou va sèvi SENYÈ a Bondye nou an, e Li va beni pen nou, ak dlo nou; epi Mwen va retire maladi pami nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","P ap gen foskouch oswa moun esteril nan peyi nou. Mwen va fin akonpli fòs kantite jou ke n ap viv yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Mwen va voye laperèz Mwen devan nou. Mwen va jete nan konfizyon tout pèp pami sila nou parèt yo, e Mwen va fè tout lènmi nou yo ban nou do. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Mwen va voye gèp devan nou pou yo pouse mete deyò tout Evityen yo, Kananeyen yo, ak Etyen yo devan nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mwen p ap pouse yo deyò nan yon sèl ane, pou peyi a pa vin dezole, e pou bèt chan yo pa vin twòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Mwen va pouse yo deyò devan nou mòso pa mòso jiskaske nou vin gran, e posede peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Mwen va etabli bòn nou yo soti nan Lamè Wouj, jis rive nan lanmè Filisten yo, soti savann nan pou rive nan larivyè Euphrate paske Mwen va livre abitan peyi yo nan men nou, e nou va pouse yo ale devan nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Nou pa pou fè okenn akò avèk yo, ni avèk dye pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Yo p ap viv nan peyi nou, paske yo va fè nou peche kont Mwen; paske si nou sèvi dye pa yo, sa va vrèman vin yon pèlen pou nou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Alò, Li te di a Moïse: “Vin monte vè SENYÈ a, ou menm avèk Aaron, Nadab, Abihu avèk swasann-dis nan ansyen Israël yo, e nou va adore a yon distans. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Men se sèl Moïse k ap vin toupre SENYÈ a, men yo menm p ap vin pre. Pèp la p ap monte avèk li.” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Alò Moïse te vin rakonte a pèp la tout pawòl a SENYÈ a yo, avèk tout òdonans yo; epi tout pèp la te reponn avèk yon sèl vwa. Yo te di: “Tout pawòl sa yo ke SENYÈ a pale, nou va fè yo!” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moïse te ekri tout pawòl SENYÈ a yo. Konsa, li te leve granmmaten e li te bati yon lotèl nan pye mòn nan avèk douz pilye pou douz tribi Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Li te voye jèn mesye nan fis Israël yo, yo te ofri ofrann brile e yo te fè sakrifis jèn towo kòm ofrann lapè bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moïse te pran mwatye nan san an. Li te mete li nan basen yo, e lòt mwatye san an li te aspèje li sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Epi li te pran liv akò a, e li te li li nan zòrèy a tout pèp la. Epi yo te di: “Tout sa ke SENYÈ a pale, nou va fè yo, e nou va obeyi yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Alò, Moïse te pran san an. Li te aspèje li sou pèp la. Li te di: “Gade byen san akò a, ke SENYÈ a te fè avèk nou selon tout pawòl sa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Alò, Moïse te pran Aaron, Nadab, Abihu, ak swasann-dis nan ansyen Israël yo pou monte. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Yo te wè Bondye Israël la. Anba pye li, te parèt yon choz tankou yon pave ki fèt an safì, klè tankou syèl la menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Malgre Li pa t lonje men Li kont prens Israël sa yo. Yo te wè Bondye, yo te manje e yo te bwè. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Alò, SENYÈ a te di a Moïse: “Vin monte vè Mwen nan mòn nan e rete la, epi Mwen va bay ou tab wòch yo avèk lalwa ak kòmandman ke M te ekri pou enstwi yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Alò, Moïse te leve avèk Josué, sèvitè li a, e Moïse te monte nan mòn Bondye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Men a ansyen yo li te di: “Tann isit la pou nou jis lè nou retounen kote nou. Epi gade byen, Aaron avèk Hur isit avèk nou. Nenpòt moun ki genyen yon pwosè lalwa kapab pwoche yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Alò Moïse te monte nan mòn nan, e nwaj la te kouvri mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Glwa SENYÈ a te rete sou Mòn Sinai a, e nwaj la te kouvri li pandan sis jou. Nan setyèm jou a, Li te rele Moïse soti nan mitan nwaj la. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Nan zye a fis Israël yo, aparans glwa SENYÈ a te tankou yon dife ki t ap ravaje sou tèt mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moïse te antre nan mitan nwaj la pandan li te monte sou mòn nan. Konsa, Moïse te rete sou mòn nan pandan karant jou ak karant nwit. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Alò, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Pale fis Israël yo pou yo rasanble yon ofrann pou Mwen. Soti nan chak òm ki gen bon kè ou va resevwa yon ofrann. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Sa se ofrann ke nou va rekeyi nan men yo: lò, lajan, ak bwonz, ");
INSERT INTO hatbsa_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Twal nan koulè ble, mov, ak wouj, avèk twal fen blan, pwal kabrit, ");
INSERT INTO hatbsa_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","po belye fonse wouj, po dofen bwa akasya, ");
INSERT INTO hatbsa_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lwil pou limyè, epis pou lwil onksyon, e pou lansan santi bon ");
INSERT INTO hatbsa_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pyè oniks ak pyè baz bijou pou efòd la, e pou pyès vètman lestomak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Kite yo konstwi yon sanktyè pou Mwen, pou Mwen kapab rete pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Selon tout sa ke M gen pou montre nou, kòm modèl tabènak la, ak patwon tout mèb li yo, se konsa ojis ke nou va konstwi li. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Yo va konstwi yon lach avèk bwa akasya, de koude edmi nan longè, yon koude edmi nan lajè, ak yon koude edmi nan wotè. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ou va kouvri li avèk lò pi ni anndan, ni deyò. Fè yon kouch lò pou kouvri li nèt, e fè yon woulèt lò pou antoure li. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ou va fonde kat gwo wondèl pou li, e tache yo nan kat pye li yo, epi de wondèl va yon kote, e de wondèl yon lòt kote. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","“Ou va fè poto ak bwa akasya e kouvri yo avèk yon kouch lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ou va mete poto yo pase anndan wondèl yo sou kote lach la, e pote lach la avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Poto yo va rete nan wondèl lach yo. Yo p ap retire sou li. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ou va mete nan lach la temwayaj ke Mwen va bay ou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Ou va fè yon chèz pwopyatwa avèk lò pi, de koude edmi nan longè, ak yon koude edmi nan lajè. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ou va fè de cheriben an lò, fè yo tankou yon zèv an lò ki bat avèk zouti nan de bout a chèz pwopyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Fè yon cheriben nan yon pwent, e yon lòt nan lòt pwent lan. Ou va fè cheriben yo tankou yon sèl pyès avèk chèz pwopyatwa a, nan de pwent li. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cheriben yo va gen zèl yo k ap ouvri pa anlè. Yo va kouvri chèz pwopyatwa a avèk zèl yo, epi figi a youn ap vire vè lòt. Konsa, fas toude cheriben yo ap gade vè chèz pwopyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“Ou va mete chèz pwopyatwa a sou lach la, e nan lach la ou va mete temwayaj ke Mwen va bay ou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","La Mwen va rankontre avèk ou, epi soti anwo chèz pwopyatwa a, nan antre de cheriben yo ki sou lach temwayaj la, Mwen va pale avèk ou selon tout sa ke Mwen va ba ou nan kòmandman pou fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Ou va fè yon tab avèk bwa akasya, de koude nan longè, yon koude nan lajè e yon koude edmi nan wotè. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ou va kouvri li avèk yon kouch lò pi, e antoure li avèk yon woulèt fèt an lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ou va fè yon rebò lajè kat dwat pou antoure li, e ou va fè yon bòdi pou rebò ki antoure li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","“Ou va fè kat wondèl an lò pou li, e mete wondèl yo sou kat kwen ki sou kat pye li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Wondèl yo va toupre rebò a kòm soutyen k ap resevwa poto k ap pote tab la. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ou va fè poto yo avèk bwa akasya e kouvri yo avèk yon kouch lò, dekwa ke pa yo menm, tab la kapab pote. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","“Ou va fè asyèt, kiyè yo, louch ak chodyè yo, avèk bòl li yo k ap sèvi pou vide ofrann yo. Ou va fè yo avèk lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","“Ou va mete pen Prezans lan sou tab la devan Mwen pou li la tout lè. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Alò, ou va fè yon chandelye avèk lò pi. Chandelye a avèk baz ak pyè li yo gen pou fòme avèk lò ki bat. Tas li yo, boujon li yo, avèk flè li yo va fèt nan yon sèl pyès avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“Sis branch yo va soti sou kote li yo; twa branch chandelye a nan yon bò, e twa branch chandelye a nan lòtbò a. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Twa tas yo va fòme tankou flè zanmann sou yon branch, yon boujon, yon flè, e twa tas yo fòme tankou flè zanmann sou lòt branch lan, yon boujon avèk yon flè—konsa pou sis branch yo sòti nan chandelye a; ");
INSERT INTO hatbsa_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Epi nan chandelye a, kat tas ki fòme tankou flè zanmann yo, avèk boujon ak flè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Yon boujon va vin mete anba premye pè branch ki sòti nan li yo, e yon boujon anba dezyèm pè branch ki sòti nan li yo, pou tout sis branch k ap sòti nan chandelye yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Boujon pa yo avèk branch pa yo va fèt nan yon sèl pyès avèk li. Yo tout va fòme yon èv nan yon sèl pyès, fòme avèk mato ak lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Alò, ou va fè sèt lanp e yo va monte yo nan yon sans k ap voye limyè sou espas ki devan li an. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Etoufè yo avèk asyèt pa yo va fèt avèk lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Li va fèt avèk yon talan swasann-kenz liv lò avèk tout bagay itil sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Veye pou nou fè yo selon patwon ki pou yo a, ki te montre a ou nan mòn nan.” ");
INSERT INTO hatbsa_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Anplis de sa, ou va fè tabènak la avèk dis rido an twal len fen ki tòde avèk twal ble, mov, ak wouj, ak cheriben yo. Yo gen pou fèt pa yon mèt ouvriye ak gwo kapasite. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Longè a chak rido va ventwit koude, e lajè chak rido va kat koude. Tout rido yo va gen menm mezi. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Senk rido va vin jwenn youn ak lòt, e lòt senk rido yo va jwenn youn ak lòt. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","“Ou va fè lasèt yo an ble sou kote rido ki plis deyò a nan premye asanblaj la, e osi ou va fè yo sou kote de tapi ki plis deyò nan dezyèm asanblaj la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ou va fè senkant lasèt nan yon rido, e ou va fè senkant lasèt sou kote rido ki nan dezyèm asanblaj la. Lasèt yo va opoze anfas youn ak lòt. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ou va fè senkant kwòk an lò, e ou va jwenn rido yo youn avèk lòt avèk kwòk. Konsa, tabènak la kapab fè yon sèl. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Alò ou va fè rido yo avèk pwal kabrit tankou yon tant sou tabènak la. Ou va fè onz rido antou. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Longè chak rido va trant koude, e lajè a va kat koude. Onz rido yo va gen menm mezi. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ou va jwenn senk rido yo poukont yo, lòt sis rido yo poukont yo, e ou va vin double sizyèm rido a pa devan tant lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","“Ou va fè senkant lasèt sou kote rido a ki plis pa deyò nan premye asanblaj la, e senkant lasèt sou kote rido a ki plis pa deyò nan dezyèm asanblaj la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ou va fè senkant kwòk an bwonz. Ou va mete kwòk yo nan lasèt yo e ou va jwenn tant lan ansanm pou li fè yon sèl. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","“Mòso anplis ki debòde nan rido a tant lan, mwatye rido ki rete a, va kouche anwo lòt la pa dèyè tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Yon koude sou yon kote e yon koude sou lòt kote a, sa ki rete nan longè rido a tant lan, li va debòde sou kote tabènak la sou yon bò, ni sou lòt la pou kouvri li. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Ou va fè yon kouvèti pou tant lan avèk po belye ki fonse wouj, e yon kouvèti an po dofen pa anwo. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Alò ou va fè planch pou tabènak la avèk bwa akasya ki kanpe tou dwat. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dis koude va longè a chak planch e yon koude edmi, lajè a chak planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Va genyen de bout pou chak planch, ki jwenn youn ak lòt. Konsa ou va fè pou tout planch tabènak yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","“Ou va fè planch yo pou tabènak la: ven planch pou kote sid la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ou va fè karant baz reseptikal an ajan anba ven planch yo, de baz reseptikal anba yon planch pou de bout li yo, e de baz reseptikal anba yon lòt planch pou de bout li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Pou dezyèm kote nan tabènak la, sou fas nò a, ven planch, ");
INSERT INTO hatbsa_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","epi karant baz reseptikal pa yo fèt an ajan; de baz reseptikal anba yon lòt planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Pou dèyè tabènak la, nan lwès la, ou va fè sis planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","“Ou va fè de planch pou kwen a tabènak la pa dèyè. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Yo va double pa anba, e ansanm yo va vin konplete jis nan pwent anlè pou rive nan premye wondèl la. Se konsa li va ye avèk toude: yo va fòme de kwen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Li va genyen uit planch avèk pwòp baz reseptikal pa yo fèt an ajan, sèz baz reseptikal yo; de baz reseptikal anba yon planch, e de baz reseptikal anba yon lòt planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Epi ou va fè senk travès yo avèk bwa akasya, senk pou planch yo nan yon kote tabènak la, ");
INSERT INTO hatbsa_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","epi senk travès pou planch yo nan lòt kote tabènak la, e senk travès pou planch yo pou kote a tabènak la pa fas dèyè vè lwès la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Travès mitan jis nan mitan planch yo va pase nèt sòti nan yon pwent a lòt pwent lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Ou va kouvri planch yo avèk lò e fè wondèl yo avèk lò tankou soutyen pou travès yo. Epi ou va kouvri poto yo avèk lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Ou va monte tabènak la selon plan ki te montre a ou sou mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Ou va fè yon vwal avèk materyo ble, ak mov avèk wouj; twal fen blan byen tòde. Li va fèt avèk yon cheriben, zèv a yon mèt ouvriye ki gen kapasite. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ou va pandye li sou kat pilye akasya yo ki kouvri avèk lò, kwòk pa yo osi fèt avèk lò, sou kat baz reseptikal ki fèt an ajan yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Ou va pandye vwal la anba kwòk yo e ou va fè li antre nan lach temwayaj la nan plas sa a, pa anndan vwal la. Konsa, vwal la va sèvi pou nou kòm yon separasyon antre lye ki sen an ak lye ki sen pase tout la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Ou va mete chèz pwopyatwa a sou lach temwayaj la nan lye ki sen pase tout la. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ou va mete tab la deyò vwal la, e chandelye a anfas tab la sou kote tabènak ki vè sid la. Epi ou va mete tab la nan fas nò a. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Ou va fè yon rido pou pòtay tant lan avèk twal ble, mov, e wouj, ak twal fen blan byen tòde, zèv a yon mèt tiseran. ");
INSERT INTO hatbsa_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ou va fè senk pilye yo avèk akasya pou rido a, e ou va kouvri yo avèk lò. Kwòk pa yo osi va fèt avèk lò. Konsa, ou va fonde senk baz reseptikal an bwonz pou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Ou va fè lotèl la avèk bwa akasya, senk koude nan longè, e senk koude nan lajè. Lotèl la va fèt kare, e wotè li va twa koude. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ou va fè kòn li yo sou kat kwen. Kòn li yo va fèt nan yon sèl pyès avèk li, epi ou va vin kouvri li avèk bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“Ou va fè bokit li yo pou retire sann, avèk pèl li yo, basen li yo, fouch li yo, ak po dife. Ou va fè tout bagay itil sa yo avèk bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ou va fè pou li yon griyaj, yon èv trese an bronz. Epi nan très yo ou va fè kat wondèl an bwonz nan kat kwen li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ou va mete li anba, arebò lotèl la, pou griyaj trese a vin monte a mwatye wotè nan lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“Ou va fè poto yo pou lotèl la, poto an bwa akasya yo, e kouvri yo avèk bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Poto yo va fonse antre nan wondèl yo, pou poto yo kab rive sou de kote lotèl la lè li pote. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ou va fè li vid, avèk planch. Fè l jan sa te montre a ou nan mòn nan, konsa yo va fè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Ou va fè galeri tabènak la. Nan kote sid la ap gen twal fen blan k ap pandye, byen tòde e san koude nan longè pou yon bò. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Pilye li yo va kontwole ven, avèk ven baz reseptikal yo an bwonz. Kwòk pilye yo avèk bann seraj pa yo va fèt an ajan. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Menm jan pou kote nò a, nan longè va genyen k ap pandye san koude nan longè, e ven pilye pa li yo avèk ven baz reseptikal yo an bwonz. Kwòk yo avèk bann seraj pa yo va fèt an ajan. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Pou lajè galeri a nan kote lwès la va gen bagay k ap pann pou senkant koude, avèk dis pilye pa yo, ak dis baz reseptikal pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Lajè galeri a nan kote lès la va senkant koude. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Sa ki pann nan yon kote pòtay la va kenz koude avèk twa pilye pa yo, ak twa baz reseptikal pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Epi pou lòt kote a va gen ki pandye kenz koude avèk twa pilye pa yo, ak twa baz reseptikal pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Pou pòtay galeri a va gen yon rido ven koude, avèk twal ble, mov, e wouj avèk twal fen blan, byen tòde, lèv a yon mèt tiseran, avèk kat pilye pa yo, ak kat baz reseptikal pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tout pilye ki antoure galeri yo va founi avèk bann seraj yo an ajan, avèk kwòk yo an ajan, e baz reseptikal yo an bronz. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Longè a galeri a va san koude, lajè a va senkant toupatou, e wotè a, senk koude an twal fen blan, byen tòde, avèk baz reseptikal yo an bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“Tout bagay itil a tabènak yo sèvi nan tout sèvis li, ak tout pikèt li yo va fèt an bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Ou va pase lòd a fis Israël yo pou yo pote bay ou lwil byen klè ki fèt avèk oliv byen bat pou limyè a, pou yon lanp kapab briye tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Nan tant rankont lan, deyò tapi a, ki avan temwayaj la, Aaron avèk fis li yo va kenbe li an lòd depi nan aswè rive jiska maten devan SENYÈ a: li va yon règleman jis pou tout tan, pou tout jenerasyon pa yo, pou fis Israël yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Epi fè Aaron, frè ou a vin pre ou menm, avèk fis pa li yo avè l, pami fis Israël yo pou sèvi kòm prèt pou Mwen—Aaron, Nadab, avèk Abihu, Éléazar, ak Ithamar, fis Aaron yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“Ou va fè vètman sen pou Aaron, frè ou a, pou onore li, e pou l byen parèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ou va pale avèk tout moun ki kapab yo, sa yo ke M te bay yon lespri sajès, pou fè vètman Aaron yo pou konsakre li, pou li kapab sèvi Mwen kòm prèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","“Sa yo se vètman ke yo va fè: yon pyès pou kouvri lestomak yo, yon efòd, avèk yon gwo manto, yon tinik avèk yon modèl kare, yon tiban pou tèt la, yon sentiwon ki fèt an twal. Yo va fè vètman sen yo pou Aaron, frè ou a ak fis li yo, pou li kapab sèvi kòm prèt pou Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Yo va pran lò a avèk twal ble, mov, wouj, ak twal fin blan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Yo va osi fè efòd la avèk lò, avèk twal ble, mov, wouj, ak twal fen blan ki byen tòde, travay a yon mèt ouvriye byen prepare. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Li va gen de pyès zepòl ki jwenn nan pwent li yo, pou li kapab jwenn ansanm. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Bann tise ki fèt avèk yon bòdi byen prepare sou li a, va menm jan ak kalite travay a li menm nan, avèk menm twal la: an lò, ble, mov, e wouj, avèk twal fen blan byen tòde a. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Ou va pran de pyè oniks, e grave sou yo non a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Sis nan non yo va sou yon pyè, e sis ki rete yo sou lòt pyè a, selon lòd nesans yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ak travay a yon mèt grave sou bijou, tankou fèt pou yon so, ou va grave sou pyè yo selon non a fis Israël yo. Ou va monte monti fèt an lò yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ou va mete de pyè sa yo sou pyès zepòl yo nan efòd la, kòm pyè pou toujou sonje fis Israël yo. Konsa, Aaron va pote non pa yo devan SENYÈ a sou de zepòl li yo tankou yon bagay komemoratif. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ou va pozisyone l sou yon monti fèt an lò, ");
INSERT INTO hatbsa_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ak de chèn an lò pi, Ou va fè yo tankou èv kòd ki tòde, e ou va mete chèn trese yo sou monti lò yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ou va fè yon pyès jijman pou lestomak, èv a yon mèt ouvriye; tankou èv efòd la, ou va fè li: avèk lò, twal ble, mov, e wouj, tòde byen fen ou va fè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Li va kare, plwaye doub, yon epann lajè yon men louvri nan lajè, e yon epann nan longè. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","“Ou va monte sou li kat ranje nan pyè yo; premye ranje a va yon ranje avèk woubi, topaz ak emwod; ");
INSERT INTO hatbsa_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","epi dezyèm ranje a yon tikwaz, yon safi, avèk yon dyaman; ");
INSERT INTO hatbsa_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","epi twazyèm ranje a, yon opal, yon agat, ak yon ametis; ");
INSERT INTO hatbsa_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","epi nan katriyèm ranje a, yon krizolit, yon oniks, avèk yon jasp; yo va plase nan monti an lò yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Pyè yo va selon non fis Israël yo: douz selon non pa yo. Yo va grave yo tankou sa ki fèt nan selil yo, yo chak selon non pa yo pou douz tribi yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ou va fè sou pyès lestomak la, chèn tankou kòd ki tòde, yon zèv ki fèt avèk lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ou va fè nan pyès lestomak la de wondèl an lò, e ou va mete de wondèl yo nan de pwent yo nan pyès lestomak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ou va mete de kòd lò yo nan de wondèl yo nan pwent a pyès lestomak yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Ou va mete lòt de pwent kòd yo nan de monti fèt byen fen yo, e mete yo sou pyès zepòl a efòd la, pa devan li. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","“Ou va fè de wondèl an lò e ou va plase yo sou de pwent pyès lestomak yo, akote li, ki se bò kote anndan efòd la. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ou va mete de wondèl an lò e ou va mete yo nan pati anba pyès efòd yo, pa devan li, toupre plas kote li jwenn nan, anwo bann tise byen fen nan efòd la. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Yo va atache pyès lestomak la pa wondèl li yo ak wondèl efòd yo avèk yon kòd an ble, pou li kapab sou bann nan ki trese byen fen nan efòd la, pou pyès lestomak la pa vin detache nan efòd la. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aaron va pote non a fis Israël yo nan pyès lestomak jijman an sou kè li lè l ap antre nan lye sen an, kòm yon souvni pou tout tan devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ou va mete nan pyès lestomak jijman an, Ourim nan avèk Toumim nan, e yo va sou kè Aaron lè l ap antre devan SENYÈ a. Konsa, Aaron va pote jijman a fis Israël yo sou kè li tout tan devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Ou va fè tout manto efòd la an ble. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Va genyen yon ouvèti nan tèt anwo li, nan mitan li. Ozanviwon ouvèti li va genyen yon bòdi ak zèv trese, tankou ouvèti nan yon pwotèj batay, pou li pa chire. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ou va fè nan woulèt li grenad ak materyèl ble, mov, e wouj, toutotou woulèt li, ak klòch an lò antre yo chak toutotou: ");
INSERT INTO hatbsa_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","yon klòch an lò ak yon grenad, yon klòch an lò ak yon grenad, toutotou woulèt manto a. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Li va sou Aaron lè l ap fè sèvis li; epi son li va tande lè l ap antre e soti nan lye sen an devan SENYÈ a, jis pou li pa mouri. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ou va osi fè yon plak avèk lò pi, e li va grave sou li, jan li grave a yon so: “Sen a SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ou va tache li avèk yon kòd ble, e li va rete sou tiban an; li va pa devan tiban an. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Li va sou fwon Aaron, e Aaron va retire inikite nan bagay sen ke fis Israël yo konsakre yo, selon tout ofrann sen pa yo; epi li va toujou sou fwon li, pou yo kapab aksepte devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ou va trese yon tinik avèk modèl kare avèk twal fen blan, ou va fè yon tiban avèk twal fen blan, e ou va fè yon sentiwon bwode, èv a yon bòs tiseran. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pou fis Aaron yo ou va fè tinik yo; ou va osi fè sentiwon pou yo. Ou va fè chapo pou yo, pou onore yo, e pou fè yo byen parèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Ou va mete yo sou Aaron, frè ou a, sou fis li yo avèk li, epi ou va vide lwil sou yo pou fè òdonasyon yo e konsakre yo, pou yo kab sèvi Mwen kòm prèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Ou va fè pou yo pantalon avèk len pou kouvri nidite yo. Yo va sòti nan ren yo jis rive nan kwis yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Yo va sou Aaron avèk fis li yo lè y ap antre nan tant reyinyon an, oswa lè y ap pwoche lotèl la pou fè sèvis nan lye sen an, pou yo pa atire koupabilite, e mouri. “Sa va yon règleman pou tout tan pou li, e pou desandan apre li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Alò, se sa nou va fè a yo menm pou konsakre yo pou fè sèvis kòm prèt Mwen: pran yon jèn towo avèk de belye san defo, ");
INSERT INTO hatbsa_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","epi pen san ledven avèk gato san ledven. Mele yo avèk lwil, ak galèt san ledven ki kouvri avèk lwil. Ou va fè yo avèk farin fen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ou va mete yo nan yon panyen, e prezante yo nan panyen an ansanm avèk towo a avèk de belye yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Konsa, ou va mennen Aaron avèk de fis li yo vè pòtay tant reyinyon an, e lave yo avèk dlo. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ou va pran vètman yo. Ou va mete sou Aaron tinik lan avèk manto efòd la, efòd avèk pyès lestomak la, e ou va mare senti li avèk bann trese byen fen ki sou efòd la. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ou va mete tiban an sou tèt li, e mete kouwòn sen an sou tiban an. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Epi ou va pran lwil onksyon an, ou va vide li sou tèt li pou onksyone li. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ou va mennen fis li yo, e mete tinik yo sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Ou va mete sentiwon pou yo, ni Aaron ni fis li yo, e ou va mare chapo yo sou tèt yo. Yo va genyen pozisyon prèt la, kòm yon lòd k ap pou tout tan san fen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Konsa, ou va mennen towo a devan tant reyinyon an, e Aaron avèk fis li yo va poze men yo sou tèt towo a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ou va touye towo a devan SENYÈ a nan pòtay tant reyinyon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ou va pran kèk nan san towo a, e ou va mete sou kòn lotèl la avèk dwèt ou; epi ou va vide tout san an nan baz lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ou va pran tout grès ki kouvri zantray yo, avèk gwo mas grès ki sòti nan fwa a, de ren yo ak grès ki sou yo a, e ou va ofri yo anlè nan lafimen sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Men chè towo a avèk po li ak watè li, ou va brile yo avèk dife andeyò kan an. Li menm se yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ou va anplis pran belye sa a, e Aaron avèk fis li yo va poze men yo sou tèt belye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ou va touye belye a e ou va pran san li pou flite li toutotou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Ou va koupe belye a an mòso, lave zantray li yo avèk janm li yo, e mete yo avèk mòso li yo avèk tèt li. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ou va ofri anlè nan lafimen tout belye a sou lotèl la; li se yon ofrann brile a SENYÈ a; li se yon sant ki dous; yon sakrifis pa dife pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Alò ou va pran lòt belye a, e Aaron avèk fis li yo va poze men yo sou tèt belye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ou va touye belye a, ou va pran kèk nan san li e mete li sou tèt zòrèy adwat Aaron, sou tèt zòrèy dwat a fis li yo, sou pous men dwat yo, nan gwo zòtèy pye dwat yo, e flite rès san an toutotou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ou va pran kèk nan san ki sou lotèl la ak kèk nan lwil onksyon an, e ou va flite li sou Aaron ak sou vètman li yo, sou fis li yo ak sou vètman ki pou fis li yo avèk li. Konsa li menm va vin konsakre; li menm, avèk vètman li yo avèk fis li yo, ak vètman a fis li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Ou va anplis pran grès belye a, grès ki nan ke a, ak grès ki kouvri zantray li yo, gwo mas grès ki sòti nan fwa a, de ren yo avèk grès ki sou yo a ak grès ki sou kwis dwat la (akoz ke se yon belye pou òdonasyon an), ");
INSERT INTO hatbsa_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Epi yon gato pen avèk yon gato nan pen ki mele avèk lwil la, ak yon galèt ki sòti nan panyen pen san ledven an ki devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Ou va mete tout sa yo nan men Aaron ak men a fis li yo, e ou va balanse yo anlè tankou yon ofrann balanse devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ou va pran yo sòti nan men pa yo, e ou va ofri yo anlè nan lafimen sou lotèl la, tankou yon bagay ki santi bon devan SENYÈ a: li se yon ofrann pa dife pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Epi ou va pran vyann pwatrin belye a ki pou òdonasyon Aaron an, e ou va balanse li anlè tankou yon ofrann balanse devan SENYÈ a. Li va pòsyon pa w. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Ou va konsakre pwatrin ofrann balanse a, kwis ofrann ki te voye anlè a, ki te balanse e ki te ofri kòm belye òdonasyon an, sila ki te pou Aaron an, ak sila ki te pou fis li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Li va pou Aaron avèk fis li yo kòm pòsyon pa yo jis pou tout tan; li va sòti nan fis Israël yo, paske se yon ofrann voye anlè ke li ye. Li va yon ofrann voye anlè sòti nan fis Israël yo, sòti nan sakrifis ofrann lapè pa yo, menm ofrann anlè bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Vètman sen ki pou Aaron yo va pou fis li yo apre li, ke nan yo, yo kapab onksyone e òdone. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Pandan sèt jou sila pami fis li yo ki vin prèt nan plas li, li va mete yo sou li lè l ap antre nan tant reyinyon an pou fè sèvis nan lye sen an. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Ou va pran belye òdonasyon an e ou va bouyi chè li nan yon lye sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","“Aaron avèk fis li yo va manje chè belye a ak pen ki nan panyen ki nan pòtay tant reyinyon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Konsa yo va manje bagay sa yo pa sa ke ekspyasyon te fèt nan òdonasyon ak konsekrasyon yo; men yon etranje pa pou manje yo, paske yo sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Si yon bagay nan chè òdonasyon an oswa, yon pen rete jis rive nan maten, ou va brile rès la avèk dife. Li p ap manje, akoz li sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Konsa ou va fè pou Aaron ak fis li yo, selon tout sa ke Mwen te kòmande ou yo. Ou va òdone yo pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","“Chak jou ou va ofri yon towo kòm ofrann ekspyasyon pou peche. Ou va pirifye lotèl la lè ou fè ekspyasyon pou li. E ou va onksyone li pou l kab vin konsakre. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pandan sèt jou ou va fè ekspyasyon sou lotèl la, e ou va konsakre li. Konsa lotèl la va pi sen, e nenpòt sa ki touche li va sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Alò, se sa ke ou va ofri sou lotèl la: de jèn mouton avèk laj de zan, chak jou san rete. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Premye jèn mouton an, ou va ofri li nan maten e lòt jèn mouton an, ou va ofri li nan aswè lè l fenk kòmanse fènwa; ");
INSERT INTO hatbsa_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","epi va genyen yon dizyèm efa (22 lit) farin fen, mele avè l yon ka in (22 lit) nan lwil ki bat, ak yon ka nan in (22 lit) diven kòm yon ofrann bwason avèk yon jèn mouton. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Lòt jèn mouton an, ou va ofri li nan aswè lè l fenk kòmanse fènwa. Ou va ofri avèk li menm ofrann sereyal, e menm ofrann bwason tankou nan maten an pou yon bagay ki santi bon, yon ofrann pa dife vè SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Li va yon ofrann brile nan tout tan pou tout jenerasyon nou yo, nan pòtay tant reyinyon an devan SENYÈ a, kote Mwen va reyini avèk nou, pou pale avèk nou la a. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","“Mwen va reyini la avèk fis Israël yo, e li va vin konsakre akoz glwa Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Mwen va konsakre tant reyinyon an ak lotèl la. Mwen va osi konsakre Aaron ak fis li yo pou sèvi kòm prèt pou Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","“Mwen va vin rete pami fis Israël yo e Mwen va Bondye pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Yo va konnen ke Mwen menm se SENYÈ a, Bondye pa yo ki te fè yo sòti nan peyi Égypte la, pou M ta kapab rete pami yo: Mwen se SENYÈ a, Bondye pa yo a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Anplis, ou va fè yon lotèl kòm yon plas pou brile lansan. Ou va fè li avèk bwa akasya. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Longè li va yon koude, e lajè li va yon koude. Li va kare, e wotè li va de koude. Kòn li yo va fèt tankou yon sèl pyès ansanm avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ou va kouvri li avèk yon kouch fen an lò; tèt li e akote li, toupatou ansanm avèk kòn li yo; epi ou va fè yon bòdi lò pou antoure li nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ou va fè de wondèl an lò pou li anba bòdi li. Ou va fè yo sou de fas kote, ki opoze yo, e yo va soutyen pou poto ki sèvi pou pote li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ou va fè poto yo avèk bwa akasya e kouvri yo avèk lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ou va mete lotèl sa a pa devan vwal ki pre lach temwayaj la, devan chèz pwopyatwa a ki kouvri lach temwayaj la, kote Mwen va rankontre avèk ou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aaron va brile lansan ki santi bon sou li. Li va brile li chak maten lè l ap pran swen lanp yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Lè Aaron ap pran swen lanp yo nan aswè, li va brile lansan. Va genyen lansan tout tan devan SENYÈ a pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","“Ou pa pou ofri okenn lòt lansan sou lotèl sila a, ni ofrann ki brile, ni ofrann sereyal; ni ou pa pou vide yon ofrann bwason sou li. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron va fè ekspyasyon sou kòn li yo yon fwa pa ane. Li va fè ekspyasyon sou li avèk san ofrann peche ki pou ekspyasyon an yon fwa pa ane pandan tout jenerasyon nou yo. Li pi sen pase tout bagay bay SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","SENYÈ a te osi pale ak Moïse. Li te di l: ");
INSERT INTO hatbsa_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Lè nou fè yon kontwòl ofisyèl de tout fis Israël yo pou konte yo, alò, chak nan yo va bay pwòp ranson li pou nanm li bay SENYÈ a, lè n ap kontwole yo, pou pa vin genyen okenn epidemi ki rive pami yo lè n ap nimewote yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Se chak moun ki kontwole yo ki va bay: mwatye sik selon sik sanktyè a, (yon sik se ven gera) mwatye sik kòm kontribisyon bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","“Tout moun ki kontwole, soti nan laj a ventan oswa plis, va bay yon kontribisyon bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Rich yo p ap peye plis, ni malere yo p ap peye mwens ke mwatye sik la, lè ou bay kontribisyon SENYÈ a pou fè ekspyasyon pou nou menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","“Ou va pran lajan ekspyasyon an pou fis Israël yo, e ou va bay li pou sèvis nan tant reyinyon an, pou li kapab yon souvni pou fis Israël yo devan SENYÈ a, pou fè ekspyasyon pou nou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","“SENYÈ a te pale a Moïse Li te di l: ");
INSERT INTO hatbsa_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Ou va osi fè yon basen lave an bwonz, avèk yon baz an bwonz, pou lave. Ou va mete li antre tant reyinyon an avèk lotèl la, e ou va mete dlo ladann. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaron avèk fis li yo va lave men yo ak pye yo ladann. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Lè yo antre nan tant reyinyon an, yo va lave avèk dlo, jis pou yo pa mouri; oswa lè yo pwoche lotèl la pou fè sèvis, pou ofri anlè nan lafimen, yon ofrann dife vè SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Epi yo va lave men yo ak pye yo pou yo pa mouri. Konsa, li va yon règleman k ap la pou toujou, pou Aaron avèk desandan li yo pami tout jenerasyon yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Anplis, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Pran anplis pou ou menm pi bon epis yo: nan mi k ap koule, senk san sik, nan kannèl santi bon an, mwatye sa, de-san-senkant, e nan wozo awomatik, de-san-senkant, ");
INSERT INTO hatbsa_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","epi nan kasya, senk-san, selon sik sanktyè a, e nan lwil doliv la, yon in nan lwil doliv la. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ou va fè sila yo tankou yon lwil sen pou onksyone, yon melanj pafen, zèv a yon mèt melanj pafen; se va yon lwil sen pou onksyone.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","“Avèk li ou va onksyone tant reyinyon an ak lach temwayaj la, ");
INSERT INTO hatbsa_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","tab la avèk tout bagay itil li yo, lanp bouji a avèk bagay itil li yo, ak lotèl lansan an, ");
INSERT INTO hatbsa_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","lotèl ofrann brile a avèk tout bagay itil li yo, basen lave a, avèk baz li. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","“Ou va osi konsakre yo, pou yo kapab vin sen pase tout bagay. Nenpòt moun ki touche yo dwe sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Ou va vide lwil sou Aaron avèk fis li yo, e ou va konsakre yo, pou yo kapab sèvi pou Mwen kòm prèt.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ou va pale avèk fis Israël yo. Ou va di: “Sa va yon lwil ki sen a Mwen pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Li pa pou vide sou kò a okenn moun, ni ou pa pou fè okenn bagay ki sanblab ak li nan menm mezi melanj lan. Li sen, e li va sen pou ou menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nenpòt moun ki mele nenpòt bagay parèy ak li, oswa nenpòt moun ki mete okenn nan li sou yon moun ki pa prèt, li va koupe retire pami moun li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Alò, SENYÈ a te di a Moïse: “Pran pou ou menm epis yo, safetida, zong santi bon, galbanòm, avèk lansan pi, yo chak nan menm kantite. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Avèk li ou va fè lansan, yon pafen, zèv a yon mèt melanj pafen, avèk disèl, ki pi, e ki sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ou va bat kèk nan li byen fen, e ou va mete yon pati ladann devan temwayaj la nan tant reyinyon an, kote Mwen va rankontre avèk ou a. Li va yon choz pou nou, ki sen pase tout choz.” ");
INSERT INTO hatbsa_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","“Lansan sa a, nou pa pou fè li nan menm mezi pou sèvis pèsonèl nou; li va sen a nou pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nenpòt moun ki ta fè parèy li pou sèvi kòm pafen va koupe retire pami pèp li a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Gade, Mwen te rele Betsaléel pa non li, fis Uri a, nan tribi Juda. ");
INSERT INTO hatbsa_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mwen te ranpli li avèk Lespri Bondye nan sajès, nan konprann, nan konesans, ak nan tout kapasite mendèv yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","pou fè desen pou travay avèk lò, avèk ajan, e avèk bwonz, ");
INSERT INTO hatbsa_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","epi nan koupe pyè bijou pou monti, ak nan fè desen sou bwa, pou li kapab fè tout kalite mendèv. ");
INSERT INTO hatbsa_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“Epi gade byen, Mwen menm te nonmen ansanm avèk li Oholiab, fis Ahisamach la, nan tribi Dan lan; epi osi nan kè tout moun ki ranpli avèk kapasite, Mwen te mete kapasite sa a, pou yo ta kapab fè tout sa ke M te kòmande ou yo: ");
INSERT INTO hatbsa_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Pou tant reyinyon an, lach temwayaj la, chèz pwopyatwa a sou li, ak tout mèb tant lan, ");
INSERT INTO hatbsa_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tab la osi avèk tout bagay itil li yo, chandelye an lò pi avèk tout bagay itil li yo, ak lotèl lansan an, ");
INSERT INTO hatbsa_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","lotèl ofrann ki brile yo, osi avèk tout bagay itil li yo, e basen lave a avèk baz li, ");
INSERT INTO hatbsa_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","epi vètman tise yo tou, vètman sen pou Aaron yo, prèt la, ak vètman pou fis li yo, pou ranpli kapasite prèt la; ");
INSERT INTO hatbsa_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","lwil onksyon an osi, ak lansan santi bon pou lye sen an. Yo va fèt selon tout sa ke M te kòmande ou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Men pou ou menm, pale a fis Israël yo. Di yo: ‘Nou va vrèman obsève Saba Mwen yo. Paske sa se yon sign antre Mwen ak nou pandan tout jenerasyon pa nou yo, pou nou kapab konnen ke Mwen se SENYÈ ki fè nou sen an. ");
INSERT INTO hatbsa_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘Pou sa, nou gen pou obsève Saba a, paske li sen pou nou. Tout sila ki vyole li yo va vrèman vin mete a lanmò. Paske nenpòt moun ki fè okenn travay nan li, moun sa a va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","“‘Pandan sis jou nou kapab travay, men nan setyèm jou a, gen yon Saba repo konplè, ki sen a SENYÈ a. Nenpòt moun ki fè okenn travay nan jou sa a va vrèman vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Konsa, fis Israël yo va obsève Saba a, pou selebre Saba a pandan tout jenerasyon pa yo kòm yon akò ki p ap janm sispann. ");
INSERT INTO hatbsa_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Li se yon sign antre Mwen avèk fis Israël yo pou tout tan. Paske nan sis jou SENYÈ a te fè syèl la avèk tè a, men nan setyèm jou a Li te pran repo, e Li te vin rafrechi Li.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","“Lè Li te fin pale avèk li sou Mòn Sinai a, Li te bay Moïse de tablèt temwayaj la. Tablèt yo te fèt an wòch, e yo te ekri pa dwèt SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Alò, lè pèp la te wè ke Moïse te fè reta sòti nan mòn nan, pèp la te rasanble vè Aaron e yo te di li: “Vini, fè pou nou yon dye ki va ale devan nou; pwiske, Moïse sila a, nonm ki te mennen nou sòti nan peyi Égypte la, nou pa konnen sa ki rive li.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron te di yo: “Chire retire zanno lò ki nan zòrèy a Madanm nou yo, fis nou yo, ak fi nou yo, e pote yo ban mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Epi tout pèp la te chire zanno lò ki te nan zòrèy pa yo. Yo te pote yo bay Aaron. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Li te pran yo nan men yo; li te fè desen li avèk yon zouti pou grave, e li te fonn li pou fè yon jèn towo. Konsa yo te di: “Sa se dye pa ou, O Israël, ki te mennen ou sòti nan peyi Égypte la.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Alò, lè Aaron te wè sa, li te bati yon lotèl devan li. Epi Aaron te fè yon pwoklamasyon e te di: “Demen va yon fèt pou SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Epi nan jou ki te vini an, yo te leve bonè. Yo te ofri ofrann brile a, e yo te pote ofrann lapè yo. Konsa, pèp la te chita pou manje, pou bwè, e yo te leve pou jwe. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Alò SENYÈ a te pale ak Moïse e te di: “Desann koulye a, paske pèp ou a, ke ou te mennen monte nan peyi Égypte la, gen tan vin konwonpi. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Yo vire byen vit kite chemen ke Mwen te pase lòd ba yo a. Yo fè pou yo menm yon jèn towo fonn, yo adore li, yo fè sakrifis bay li, e yo di: ‘Sa se dye pa ou, O Israël, ki te mennen ou monte kite peyi Égypte la!’” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","SENYÈ a te di a Moïse: “Mwen wè pèp sa, e gade byen, se yon pèp tèt di. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Koulye a alò, kite Mwen sèl, pou kòlè Mwen kapab briye kont yo, e pou M kapab detwi yo; epi Mwen va fè nan ou menm yon gran nasyon.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Men Moïse te priye SENYÈ a Bondye li a, e te di: “O SENYÈ poukisa kòlè ou briye kont pèp Ou a, ke Ou te fè sòti nan peyi Égypte la avèk gran pouvwa e avèk yon men pwisan an? ");
INSERT INTO hatbsa_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Poukisa Ejipsyen yo ta dwe pale pou di: ‘Avèk mechanste Li te fè yo sòti, pou touye yo nan mòn yo e pou detwi yo sou fas tè a?’” “Vire kite kòlè Ou k ap briye a, e vire kite ide Ou sou entansyon Ou, pou fè pèp Ou mal la. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Sonje Abraham, Isaac, ak Israël, sèvitè ou yo, ke Ou te sèmante pa Ou menm, pou di yo: ‘Mwen va miltipliye desandan nou yo tankou zetwal nan syèl yo, e tout peyi ke M te pale yo, Mwen va bay a desandan nou yo, e yo va eritye li jis pou tout tan.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Konsa, SENYÈ a te chanje ide li sou mal ke Li te di Li t ap fè a pèp Li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Alò, Moïse te vire desann mòn nan avèk de tablèt temwayaj yo nan Men l; tablèt ki te ekri nan toude fas yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Tablèt yo se te zèv Bondye yo te ye. Ekriti a se te ekriti Bondye menm ki grave sou tablèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Alò, lè Josué te tande bwi a pèp la pandan yo t ap rele fò, li te di Moïse: “Gen son lagè nan kan an”. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Men li te di yo: “Se pa son a yon kri viktwa, ni se pa son ke y ap pèdi batay; men se son chante ke m tande.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Li te vin rive ke depi Moïse te pwoche kan an, li te wè jèn towo a ak tout dans yo. Konsa, kòlè te briye nan Moïse. Li te jete tablèt ki te nan men li yo atè, e li te kraze yo nan baz mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Li te pran jèn towo ke yo te fè a; li te brile li avèk dife. Li te kraze l fè poud, e li te gaye li sou tout sifas dlo a. Konsa, li te fè fis Israël yo bwè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moïse te di a Aaron: “Kisa pèp sa te fè ou la a, pou ou ta mennen yon si tèlman gwo peche sou yo?” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron te di: “Pa kite kòlè a mèt mwen briye. Ou konnen pèp sa a ou menm, ke yo toujou panche vè lemal. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Paske yo te di mwen: ‘Fè yon dye pou nou ki va ale devan nou. Paske Moïse sila a, mesye ki te mennen nou monte sòti nan peyi Égypte la, nou pa konnen sa ki rive li.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","“Mwen te di yo: ‘Nenpòt moun ki gen nenpòt lò, ke yo chire retire li.’ Alò, yo te ban mwen li, mwen te jete li nan dife a, e ti towo sa a te parèt.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Alò, lè Moïse te wè ke pèp la te pèdi kontwòl nèt—paske Aaron te kite yo pèdi kontwòl pou yo te kapab devni yon rizib pami lènmi yo— ");
INSERT INTO hatbsa_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Alò, Moïse te vin kanpe nan pòtay kan an, e li te di: “Nenpòt moun ki pou SENYÈ a vin kote mwen!” Epi tout fis Levi yo te rasanble kote li. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Li te di yo: “Konsa pale SENYÈ a, Bondye Israël la, chak moun nan nou mete nepe nou sou kwis nou. Ale tout kote pòtay sou pòtay nan kan an, e chak touye frè nou, chak zanmi nou, chak vwazen nou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Konsa, fis a Levi yo te fè sa ke Moïse te enstwi yo a, e anviwon twa-mil moun nan pèp la te tonbe nan jou sa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Alò Moïse te di: “Konsakre nou nan menm jou sa a bay SENYÈ a—paske chak moun te kont fis li, e kont frè li—pou Li kapab beni nou jodi a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nan pwochen jou a, Moïse te di a pèp la: “Nou pou kont nou te komèt yon gwo peche. Koulye a mwen ap monte vè SENYÈ a. Petèt mwen kapab twouve padon pou peche nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Alò, Moïse te retounen vè Bondye, e te di: “Elas, pèp sa a komèt yon gwo peche. Yo te gen tan fè yon dye an lò pou yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Men koulye a, si Ou va padone, padone peche yo—e si non, souple efase mwen nan liv ke Ou te ekri a!” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","SENYÈ a te di a Moïse: “Nenpòt moun ki te peche kont Mwen, Mwen va efase li nan liv Mwen an. ");
INSERT INTO hatbsa_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Men ale koulye a, mennen pèp la kote Mwen te di ou a. Veye byen, zanj Mwen va ale devan ou. Malgre sa, nan jou ke Mwen va pini an, Mwen va pini yo pou peche yo a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Konsa, SENYÈ a te frape pèp la akoz sa yo te fè avèk jèn towo ke Aaron te fè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Alò SENYÈ a te pale ak Moïse: “Pati, ale monte soti isit la, ou menm avèk pèp ke ou te mennen monte sòti nan peyi Égypte la, vè yon peyi ke Mwen te sèmante a Abraham, Isaac, e a Jacob lè M te di yo: ‘A desandan nou yo Mwen va bay li.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Mwen va voye yon zanj devan ou, e Mwen va mete Kananeyen yo deyò, Amoreyen yo, Evetyen yo, Ferezyen yo, Etyen yo, ak Jebizyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Monte vè yon peyi ki koule lèt ak siwo myèl; men Mwen p ap monte nan mitan nou, pwiske nou se yon pèp tèt di, e Mwen ta kapab petèt detwi nou nan chemen an.” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Lè pèp la te tande pawòl tris sa yo, yo te antre nan gwo doulè, e pèsòn pa t abiye avèk òneman yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Paske SENYÈ a te di a Moïse: “Di a fis Israël yo: ‘Nou se yon pèp tèt di; si M ta monte nan mitan nou pandan yon moman, Mwen ta detwi nou. Koulye a, pou sa, retire òneman yo sou nou menm, pou M kapab konnen kisa ke M ta dwe fè avèk nou.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Konsa, soti Mòn Horeb pou rive pi lwen, fis Israël yo te retire tout òneman yo nèt sou yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Alò Moïse te abitye pran tant lan, li te monte li deyò kan an, yon bon distans a kan an, e li te rele li “Tant Reyinyon an”. Epi tout moun ki t ap chache SENYÈ a te konn ale nan tant reyinyon ki te deyò kan an. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Epi li te rive ke nenpòt lè ke Moïse te sòti deyò tant lan, ke tout pèp la ta leve kanpe, chak moun nan antre a tant pa yo a, e gade vè Moïse jiskaske li te vin retounen nan tant lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nenpòt lè Moïse te antre nan tant lan, pilye a nwaj la te konn desann e kanpe nan antre tant lan; epi SENYÈ a ta pale avèk Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Lè tout pèp la te wè pilye a nwaj la ki te kanpe nan antre tant lan, tout pèp la te leve adore, chak moun depi nan antre a tant pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Konsa SENYÈ a te konn pale avèk Moïse fasafas, menm jan ke yon moun pale avèk zanmi li. Lè Moïse te retounen nan kan an, sèvitè li a, Josué, fis a Nun nan, yon jennonm, ta refize sòti nan mitan tant lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Alò, Moïse te di a SENYÈ a: “Ou wè, Ou di mwen, ‘Monte avèk pèp sa a, men Ou menm ou pa kite m konnen kilès Ou va voye avèk mwen.’ Anplis, Ou te di m: ‘Mwen te konnen ou pa non Ou, e ou osi twouve favè nan zye M.’ ");
INSERT INTO hatbsa_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Alò, pou sa, mwen priye Ou, si mwen twouve favè nan zye Ou, kite mwen konnen chemen pa Ou yo, pou m kapab konnen Ou, pou m kab jwenn favè nan zye Ou. Konsidere tou, ke nasyon sila a se pèp pa Ou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Konsa, Li te di: “Prezans Mwen va ale avèk ou, e Mwen va bay ou repo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Epi Moïse te di Li: “Si prezans Ou p ap prale avèk nou, pa mennen nou monte isit la. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Paske kijan pèp sa ka konnen ke mwen te twouve favè nan zye Ou, mwen avèk pèp Ou a? Èske se pa lè ou ale avèk nou, ke nou, mwen menm avèk pèp Ou a, kapab distenge pami tout lòt pèp ki rete sou fas tè a?” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","SENYÈ a te di a Moïse: “Mwen va osi fè bagay sa ke ou te pale a; paske ou twouve favè nan zye M, e Mwen konnen ou pa non Ou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Konsa, Moïse te di: “Mwen priye Ou, montre m glwa Ou!” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Epi Li te reponn li: “Mwen menm va fè tout bonte Mwen pase devan ou, e Mwen va pwoklame non SENYÈ a devan ou. Konsa, Mwen va fè gras a sa ke M vle fè gras yo, e Mwen va montre mizerikòd a sa ke M vle montre mizerikòd yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Men Li te di: “Ou p ap kapab wè figi Mwen, paske okenn moun pa ka wè M pou l viv!” ");
INSERT INTO hatbsa_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","SENYÈ a te di: “Gade byen, gen yon plas bò kote Mwen. Ou va kanpe la sou wòch la. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Epi li va rive ke pandan glwa Mwen ap pase, Mwen va mete ou nan twou wòch la. E Mwen va kouvri ou avèk men M pou jiskaske M fin pase. ");
INSERT INTO hatbsa_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Alò, Mwen va retire men M, e ou va wè do Mwen, men figi M p ap vizib.” ");
INSERT INTO hatbsa_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Konsa, SENYÈ a te di a Moïse: “Taye pou kont ou de tablèt an wòch tankou sa nou te genyen yo. Mwen va ekri sou tablèt yo pawòl ki te sou lòt ke ou te kraze yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Alò, prepare ou pou maten an pou monte nan Mòn Sinaï, e prezante ou menm la devan Mwen, sou tèt mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nanpwen pèsòn ki pou monte avèk ou, ni pa kite pèsòn vizib nan okenn andwa sou mòn nan. Menm bann mouton yo ak twoupo yo p ap pou manje devan mòn sa a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Konsa, Moïse te koupe de tablèt an wòch tankou sa ki te fèt avan yo. Li te leve granmmaten pou monte sou Mòn Sinaï a, jan SENYÈ a te kòmande li a. Li te pran de tablo an wòch yo nan men l. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","SENYÈ a te desann nan nyaj la, e Li te kanpe la avèk li pandan li t ap rele non SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Konsa, SENYÈ a te pase devan li, e Moïse te pwoklame: “SENYÈ a! SENYÈ a, Bondye, ki plen mizerikòd ak konpasyon an, ki lan nan fè kolè, e ki ranpli avèk lanmou ki dous ak verite a; ");
INSERT INTO hatbsa_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ki kenbe lanmou dous pandan dè milye de jenerasyon, ki padone inikite, transgresyon ak peche; malgre sa li p ap kite koupab yo san pinisyon. L ap vizite inikite papa yo sou pitit yo, ak sou pitit a pitit yo jis rive nan twazyèm ak katriyèm jenerasyon.” ");
INSERT INTO hatbsa_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Moïse te fè vit bese ba jis atè pou adore. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Li te di: “Si koulye a mwen twouve favè nan zye Ou, O Senyè a, mwen priye, kite Senyè a ale ansanm nan mitan nou, malgre pèp la se tèt di. Padone inikite nou, peche nou, e pran nou kòm pwòp posesyon pa Ou.” ");
INSERT INTO hatbsa_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Alò, Bondye te di: “Gade byen, Mwen va fè yon akò. Devan tout pèp ou a Mwen va fè mirak ki pa t janm fèt nan tout tè a ni pami okenn nan nasyon yo. Epi tout pèp pami sila nou ap viv yo, va wè zèv a SENYÈ a, paske se yon bagay etonan ke Mwen va fè ak ou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Fè sèten ke ou obsève sa ke Mwen kòmande ou nan jou sa a. Gade byen, Mwen va chase devan ou Amoreyen yo, Kananeyen yo, Etyen yo, Ferezyen yo, Evetyen yo, ak Jebizyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Veye nou, pou nou pa fè okenn akò avèk sa yo k ap viv nan peyi kote nou prale a, oswa sa va devni yo pèlen nan mitan nou. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","“Men, olye de sa nou va dechire lotèl pa yo, kraze pilye sakre pa yo e koupe jete Asherim yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Paske nou pa pou adore okenn lòt dye, paske SENYÈ a, ak yon non ke yo rele Jalou, se yon Dye ki jalou. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Pa fè yon akò avèk abitan yo nan peyi a, sòf ke yo ta jwe yon wòl kòm pwostitiye avèk dye pa yo, fè sakrifis a dye pa yo, e yon moun ta kab envite nou pou nou manje nan sakrifis li. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Epi pou nou ta vin pran nan fi pa yo pou fis nou yo, e fi pa yo ta kab fè pwostitiye avèk dye pa yo, e vin lakoz ke fis nou yo osi fè pwostitiye avèk dye pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Nou p ap fè pou tèt nou okenn dye ki fonn. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Nou va obsève fèt Pen San Ledven an. Pandan sèt jou nou va manje pen san ledven, jan Mwen te kòmande nou an, nan lè dezinye a, nan mwa Abib la, paske nan mwa Abib la nou te sòti an Égypte. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Premye pòtre ki sòti nan tout vant se pou Mwen, e nan tout bèt mal ou yo, menm premye pòtre nan bèf yo ak mouton yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ou va ransone avèk yon jenn mouton premye pòtre a yon bourik; epi si ou pa ransone li, alò, ou va kase kou li. Ou va ransone tout premye ne nan fis nou yo. Pèsòn pa pou parèt devan M men vid. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ou va travay pandan sis jou, men nan setyèm jou a ou va repoze. Menm pandan sezon laboure tè ak rekòlt la ou va repoze. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ou va selebre fèt Semèn yo. Sa vle di premye fwi ki sòti nan rekòlt ble a, ak fèt Rekòlt la, nan fen ane a. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Twa fwa pa ane tout mal nou yo va parèt devan Senyè BONDYE a, Bondye Israël la. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Paske Mwen va chase nasyon yo devan ou, e fè agrandi limit fwontyè ou yo. Pèsòn p ap fè lanvi sou peyi ou lè w ap monte twa fwa pa ane pou parèt devan SENYÈ a, Bondye ou a. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ou p ap ofri san sakrifis Mwen yo avèk pen leve, ni kite sakrifis ki pou fèt Pak la rete jis rive nan maten. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ou va pote premye nan premye fwi tè ou yo pou l antre lakay SENYÈ a, Bondye ou a. Ou pa pou bouyi yon jèn kabrit nan lèt manman li.” ");
INSERT INTO hatbsa_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Alò, SENYÈ a te di a Moïse: “Ekri mo sa yo. Paske an akò avèk mo sa yo, Mwen te fè yon akò avèk ou, e avèk Israël.” ");
INSERT INTO hatbsa_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Li te la avèk SENYÈ a pandan karant jou ak karant nwit. Li pa t manje pen, ni bwè dlo. Konsa, li te ekri sou tablo yo avèk pawòl akò yo, dis kòmandman yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Lè Moïse t ap desann Mòn Sinaï a, avèk de tablo temwayaj yo nan men Moïse lè li t ap desann mòn nan, Moïse pa t konnen ke po figi li te briye akoz li t ap pale avèk Senyè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Pou sa, lè Aaron avèk tout fis Israël yo te wè Moïse, byen gade, po figi li t ap briye, e yo te pè pwoche li. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Epi Moïse te rele yo avèk Aaron. Tout dirijan kongregasyon yo te retounen kote li. Konsa, Moïse te pale avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Apre sa a, tout fis Israël yo te pwoche, e li te bay yo tout kòmandman yo ke SENYÈ a te pale ak li nan Mòn Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Lè Moïse te fin pale avèk yo, li te mete yon vwal sou figi li. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Men nenpòt lè Moïse te antre devan SENYÈ a pou pale avèk Li, li te retire vwal la pou jis lè li te sòti. Epi nenpòt lè li te vin sòti, li te pale avèk fis Israël yo sa ke Senyè a te kòmande yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Fis Israël yo te wè figi Moïse, ke po figi li t ap briye. Alò, Moïse te remete vwal la sou figi li jis lè li te vin antre pou pale avèk SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Alò, Moïse te reyini tout kongregasyon a fis Israël yo. Li te di yo: “Se bagay sa yo ke SENYÈ a te kòmande nou fè: ");
INSERT INTO hatbsa_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Pandan sis jou nou mèt travay, men nan setyèm jou a, nou va gen yon jou sen, yon repo Saba konplè a SENYÈ a. Nenpòt moun ki fè travay nan li va vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Nou pa pou limen dife nan okenn lojman nou nan jou Saba a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moïse te pale ak tout kongregasyon fis Israël yo. Li te di: “Sa se bagay ke SENYÈ a te kòmande a, e te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","‘Pran pami nou yon ofrann pou SENYÈ a. Nenpòt moun ki gen kè bòn volonte, kite li pote kòm ofrann bay SENYÈ a: lò, ajan, ak bwonz, ");
INSERT INTO hatbsa_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","twal ble, mov ak wouj, twal fen blan, pwal kabrit, ");
INSERT INTO hatbsa_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ak po belye fonse wouj, e po dofen avèk bwa akasya, ");
INSERT INTO hatbsa_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","avèk lwil pou limyè, epis pou lwil onksyon an e pou lansan santi bon an, ");
INSERT INTO hatbsa_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","epi pyè oniks avèk pyè monti pou efòd la, e pou pyès lestomak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“‘Kite chak nonm ki gen kapasite pami nou vin fè tout sa ke SENYÈ a te kòmande yo: ");
INSERT INTO hatbsa_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","tabènak la, tant li ak kouvèti li, kwòk li yo, planch li yo, poto li yo, pilye li yo, ak baz reseptikal li yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","lach la avèk poto pa li, chèz pwopyatwa a, ak rido vwal la; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tab la avèk poto pa li, tout bagay itil yo, ak pen Prezans lan; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","chandelye a osi avèk limyè li ak lwil pou limyè a; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","epi lotèl lansan an ak poto pa li, lwil onksyon an avèk lansan santi bon an, ak rido pòtay nan antre tabènak la; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","lotèl ofrann brile a avèk griyaj li, poto li, ak tout bagay itil li yo, basen, avèk baz li; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","episa k ap pann sou galeri yo, avèk pilye li yo, baz reseptikal yo, ak rido pòtay la; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","pikèt tabènak yo avèk pikèt galeri yo, ak kòd pa yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","vètman tise yo pou sèvi nan lye sen an, vètman sen yo pou Aaron, prèt la, ak vètman a fis li yo pou yo sèvi kòm prèt.’” ");
INSERT INTO hatbsa_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Konsa, tout kongregasyon a fis Israël yo te pati kite prezans Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Tout sa yo ki te mennen pa kè yo, tout sa yo ki te mennen pa pwòp lespri pa yo te vin pote ofrann pou zèv a tant reyinyon an, pou sèvis li, e pou vètman sen li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Epi tout sa yo ki te mennen pa bòn volonte kè yo, ni gason ni fanm, te vin pote bijou monte, bwòch, zanno, bag, braslè, avèk tout kalite bagay fèt an lò. Se konsa chak moun ki te prezante yon ofrann an lò bay SENYÈ a te fè. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Chak moun, ki te gen nan posesyon li twal ble, mov, e wouj, avèk twal fen blan ak pwal kabrit, po belye fonse wouj, ak po dofen, te pote yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tout moun ki te kab fè yon ofrann lò ak bwonz te pote pòsyon ofrann SENYÈ a; epi chak moun ki te posede bwa akasya pou nenpòt travay nan sèvis la te pote li. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tout fanm ki te abil, te file fil pou twal avèk men yo, e te pote sa ke yo te file yo, materyo ble avèk mov, wouj, ak len byen fen. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Tout fanm avèk kè bòn volonte, ansanm ak yon kapasite te file pwal kabrit yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mèt dirijan yo te pote pyè bijou oniks, pyè bijou pou monte gwo efòd la ak pou pyès lestomak la; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","epi epis avèk lwil pou limyè a, pou lwil onksyon an, e pou lansan santi bon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Izrayelit yo, tout mesye yo ni fanm ki te gen yon kè ki mennen yo pote nenpòt materyo pou èv, ke SENYÈ a pa Moïse te kòmande yo fè a, te pote yon ofrann bòn volonte bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Alò, Moïse te di a fis Israël yo: “Ou wè sa, SENYÈ a te rele Betsaléel, fis a Uri, fis a Hur, nan tribi Juda a. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Epi li te ranpli li avèk lespri Bondye a, nan sajès, nan konprann, nan konesans, ak nan tout kapasite mendèv yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","pou fè desen pou travay an lò ak ajan ak bwonz, ");
INSERT INTO hatbsa_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","anplis nan koupe pyè bijou yo pou monti yo, e pou desen ki fèt an bwa ak tout kalite èv lespri moun. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","“Li osi te dedye kè l pou enstwi ni li menm, ni Oholiab, fis a Ahisamac la nan tribi Dan nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Li te ranpli yo avèk kapasite pou fè tout èv a yon gravè, yon desinatè, e yon moun ki fè bwodri avèk twal an ble an mov, an wouj, an twal fen blan, e yon tiseran, kòm atizan nan tout zèv ak fèzè desen.” ");
INSERT INTO hatbsa_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Koulye a, Betsaléel, Oholiab, ak chak mèt atizan nan sila SENYÈ a te mete kapasite avèk konprann pou konnen jan pou fè tout travay yo pou konstwi sanktyè a, va aji an akò avèk tout sa ke SENYÈ a te kòmande yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Konsa, Moïse te rele Betsaléel avèk Oholiab e chak mèt kapasite nan sila SENYÈ a te mete konesans, chak moun ki te mennen pa kè li pou vin nan travay la pou fè li. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Yo te resevwa de Moïse tout don ke fis Israël yo te pote pou fè travay la nan konstwi sanktyè a. Konsa, yo te toujou kontinye pote ofrann bòn volonte yo chak maten. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Epi tout mesye avèk kapasite ki t ap fè tout travay nan sanktyè a te vini. Pou sa a, yo chak te sòti nan travay ke yo t ap fè, ");
INSERT INTO hatbsa_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","pou yo te di a Moïse: “Pèp la ap pote bokou plis ke ase pou èv konstriksyon ke SENYÈ a te kòmande nou fè a.” ");
INSERT INTO hatbsa_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Alò, Moïse te pase yon lòd. Pou sa yo te fè yon pwoklamasyon sikile toupatou nan kan an. Li te di: “Pa kite pèsòn, ni gason ni fanm travay ankò pou fè don pou sanktyè a.” Konsa pèp la te ralanti pou yo pa pote ankò. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Paske materyo ke yo te genyen an te sifi, e plis ke sifi pou tout èv la, pou te fin konplete li. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tout mesye avèk kapasite yo pami sa yo ki t ap fè travay la te fè tabènak la avèk dis rido twal fen blan, byen tòde, materyo ble, mov, e wouj. Yo te fè yo avèk cheriben yo, èv a yon mèt ouvriye. Se Betsaléel ki te fè yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Longè a chak rido se te ventwit koude, e lajè a chak rido, kat koude; tout rido yo te gen menm mezi. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Li te jwenn senk rido yo youn ak lòt, e lòt senk rido yo, li te jwenn yo youn ak lòt. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Li te fè lasèt yo nan koulè ble sou kote rido a pa deyò nan premye ansanm nan; epi li te fè menm jan an sou kote rido ki te pa deyò nan dezyèm ansanm nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Li te fè senkant lasèt nan premye rido a, e li te fè senkant lasèt sou kote rido ki te nan dezyèm ansanm nan; lasèt yo te opoze youn ak lòt. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Li te fè senkant kwòk an lò, e li te jwenn rido yo ansanm avèk kwòk yo pou tabènak la fè yon sèl pyès. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Li te fè rido yo avèk pwal kabrit pou sèvi kòm yon tant sou tabènak la. Li te fè onz rido antou. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Longè chak rido se te trant koude e lajè a chak rido te kat koude Tout nan onz rido yo te gen menm mezi. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Li te jwenn senk rido yo poukont yo, e lòt sis yo poukont yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Anplis, li te fè senkant lasèt sou kote rido ki te plis pa deyò nan premye ansanm nan, e li te fè senkant lasèt sou kote nan rido ki te plis deyò nan dezyèm ansanm nan. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Li te fè senkant kwòk an bwonz pou jwenn tant lan ansanm pou li ta kapab fè yon sèl. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Li te fè yon kouvèti pou tant lan avèk po belye fonse wouj, ak yon kouvèti avèk po vach lanmè pa anlè. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Epi li te fè planch pou tabènak la avèk bwa akasya ki kanpe dwat. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dis koude te longè a chak planch, e yon koude-edmi se te lajè a chak planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Te gen de tenon pou chak planch, yo te jwenn youn ak lòt. Se te konsa li te fè pou tout planch yo nan tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Li te fè planch yo pou tabènak la: ven planch pou kote sid la. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Epi li te fè karant baz reseptikal an ajan anba ven planch yo: de baz reseptikal anba yon planch pou de tenon pa li, e de baz reseptikal anba yon lòt planch pou de tenon pa li. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Konsa, pou dezyèm kote nan tabènak la, nan fas nò a, li te fè ven planch yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ak karant baz reseptikal pa yo an ajan; de baz reseptikal anba yon planch, e de baz reseptikal anba yon lòt planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Pou dèyè tabènak la, nan lwès, li te fè sis planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Li te fè de planch pou kwen yo nan tabènak la pa dèyè. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Yo te double anba, e ansanm yo te fin rive nèt nan tèt li, jis rive nan premye wondèl la. Se konsa li te fè avèk toude pou de kwen yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Te gen uit planch avèk baz reseptikal yo an ajan, sèz baz reseptikal, de anba chak planch. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Epi li te fè travès yo an bwa akasya, senk pou planch yo pou yon kote tabènak la, ");
INSERT INTO hatbsa_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","epi senk travès pou lòt kote nan tabènak la, e senk travès pou planch yo nan tabènak la sou kote pa dèyè vè lwès. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Li te fè travès mitan an pase nan mitan a planch yo soti nan yon pwent a lòt pwent lan. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Li te kouvri planch yo avèk yon kouch lò. Li te fè wondèl pa yo avèk lò kòm soutyen pou travès yo, e li te kouvri travès yo avèk yon kouch lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Anplis li te fè vwal la avèk materyo ble, mov, wouj, ak twal fen blan byen tòde, avèk cheriben yo; èv a yon mèt ouvriye. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Li te fè kat pilye yo an akasya pou li, e li te kouvri l avèk yon kouch lò. Kwòk yo te fèt an lò. Li te fonde kat baz reseptikal an ajan pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Li te fè yon rido pou pòtay tant lan avèk twal ble, mov, ak wouj, e twal fen blan byen tòde, travay a yon tiseran; ");
INSERT INTO hatbsa_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","epi li te fè senk pilye li yo avèk kwòk pa yo, e li te kouvri tèt yo avèk bann seraj avèk lò; epi senk baz reseptikal yo te an bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Alò Betsaléel te fè lach la an bwa akasya. Longè li se te de koude edmi, e lajè li se te yon koude edmi. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Li te kouvri li avèk lò pi ni anndan, ni deyò, e li te fè yon bòdi an lò pou antoure l. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Li te fonde kat wondèl yo an lò sou kat pye li yo; de wondèl menm sou yon bò, e de wondèl sou lòt bò li. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Li te fè poto yo an bwa akasya, e li te kouvri yo avèk yon kouch lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Li te pase poto yo nan wondèl yo ki te tache sou kote lach la pou pote li. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Li te fè yon chèz pwopyatwa avèk lò pi; de koude edmi nan longè, e yon koude edmi nan lajè. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Li te fè de cheriben yo avèk lò. Li te fè yo nan de pwent a chèz pwopyatwa yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","yon cheriben nan yon pwent, e yon cheriben nan lòt pwent lan. Li te fè cheriben yo kòm yon sèl pyès avèk chèz pwopyatwa a nan de pwent yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cheriben yo te gen zèl yo ouvri pa anlè, e yo te kouvri chèz pwopyatwa a avèk zèl yo, avèk figi pa yo youn anvè lòt. Figi Cheriben yo te anvè chèz pwopyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Alò, li te fè tab la avèk bwa akasya. Longè li te de koude, lajè li te yon koude, e yon koude edmi nan wotè. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Li te kouvri avèk yon kouch lò, e li te fè yon bòdi an lò toutotou li. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Li te fè yon rebò pou li, lajè a yon epann (yon men byen ouvri), ki antoure l nèt, e li te fè yon bòdi lò ki te antoure tab la. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Li te fonde kat wondèl an lò pou li tab la, e li te mete wondèl yo nan kat kwen ki te sou kat pye li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Byen pre rebò a se te wondèl yo, soutyen pou poto yo pou pote tab la. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Li te fè poto yo avèk bwa akasya. Li te kouvri yo avèk yon kouch lò, pou pote tab la. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Li te fè bagay itil yo ki te sou tab la, asyèt avèk kiyè, bòl, ak krich yo pou vide ofrann bwason yo avèk lò pi a. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Epi li te fè chandelye a avèk lò pi. Li te fè chandelye a, avèk lò ki bat. Baz ak tij li, tas li yo, boujon avèk flè yo te fèt nan yon sèl pyès, ansanm avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Te gen sis branch ki te sòti bò kote li yo; twa branch chandelye yo nan yon bò li, e twa branch chandelye nan lòt bò li; ");
INSERT INTO hatbsa_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","twa tas fòme tankou flè zanmann, yon boujon, yon flè nan yon branch, ak twa tas ki fòme tankou flè zanmann nan lòt tij, yon boujon avèk yon flè—menm jan an nan sis branch ki sòti nan chandelye yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Nan chandelye a te gen kat tas ki fòme tankou flè zanmann, boujon li yo, ak flè li yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","epi yon boujon te anba premye pè branch li yo ki sòti nan li, e yon boujon anba dezyèm pè branch li yo ki sòti nan li, jis pou sis branch yo ki sòti nan chandelye a. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Boujon yo, ak branch yo te yon sèl pyès avèk li; se te yon sèl pyès an lò ki bat. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Li te fè sèt lanp li yo avèk etoufè yo, ak vaz pou sann yo avèk lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Li te fè li e tout bagay itil li yo avèk yon talan (swasann kenz liv) lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Epi li te fè lotèl lansan an avèk bwa akasya: yon koude nan longè, yon koude nan lajè, kare, ak de koude nan wotè. Kòn li te yon sèl pyès avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Li te kouvri li nèt avèk lò pi, tèt li e tout kote li yo, tou antoure, ak kòn li yo. Konsa, li te fè yon bòdi lò antoure li nèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Li te fè de wondèl an lò pou li anba bòdi li, sou de kote ki opoze yo kòm soutyen pou poto ki t ap pote l yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Li te fè poto yo an bwa akasya e li te kouvri yo avèk yon kouch lò. ");
INSERT INTO hatbsa_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Epi li te fè lwil sen pou onksyone a, ak lansan santi bon an avèk epis yo, èv a yon mèt ouvriye ki konn fè melanj pafen. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Alò, li te fè lotèl ofrann brile a avèk bwa akasya, senk koude nan longè, senk koude nan lajè, kare, ak twa koude nan wotè. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Li te fè kòn li sou kat kwen yo. Kòn li yo te yon sèl pyès avèk li, e li te kouvri li avèk bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Li te fè tout bagay itil yo pou lotèl la, bokit yo avèk pèl yo, basen yo, kwòk vyann yo, ak plato pou resevwa sann yo. Li te fè tout bagay itil yo an bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Li te fè pou lotèl la yon sistèm griyaj an bwonz, anba rebò nan distans pou rive mwatye de wotè l. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Li te fonde kat wondèl yo sou kat kote nan griyaj an bwonz yo kòm soutyen pou poto yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Li te fè poto yo avèk bwa akasya, e li te kouvri yo avèk yon kouch an bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Li te antre poto yo nan wondèl sou kote lotèl la. Se avèk yo li te pote l. Fòm li te vid, fòme avèk planch yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Anplis, li te fè basen lave a avèk bwonz avèk yon baz an bwonz, ki te sòti nan miwa fanm sèvant yo ki t ap sèvi nan pòtay tant reyinyon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Alò li te fè galeri a: pou kote sid la, afè pandye yo te fèt avèk twal fen blan byen tòde, san koude nan longè, ");
INSERT INTO hatbsa_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","avèk ven pilye li yo, ak baz reseptikal fèt an bwonz yo, avèk ven kwòk pilye yo avèk bann seraj an ajan yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Pou kote nò a te gen san koude yo; ven pilye li yo avèk ven baz reseptikal an bwonz yo, epi kwòk pou pilye yo avèk bann seraj pa yo te an ajan. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Pou kote lwès la te gen afè pandye pou senkant koude yo avèk dis pilye pa yo e bann seraj yo te an ajan. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Pou kote lès la, senkant koude yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Afè pandye yo pou yon kote pòtay la te kenz koude, avèk twa pilye pa yo e twa baz reseptikal pa yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","epi menm jan an pou lòt kote a. Sou toude kote pòtay yo te gen afè pandye de kenz koude, avèk twa pilye pa yo ak twa baz reseptikal pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tout afè pandye nan galeri yo toutotou te avèk twal fen blan byen tòde. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Baz reseptikal pou pilye ki te an bwonz yo, kwòk pou pilye yo ak bann seraj an ajan yo; epi yon kouch lò ki te kouvri pwent tèt yo. Tout pilye galeri yo te founi avèk bann seraj an ajan yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Rido pòtay la te èv a tiseran an, avèk materyo ble, mov, wouj, ak twal fen blan byen tòde. Epi longè a se te ven koude e wotè a te senk koude, ki te koresponn ak afè pandye nan galeri yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kat pilye pa yo avèk baz reseptikal pa yo a te an bwonz; kwòk pa yo a te an ajan. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tout pikèt yo pou tabènak la avèk galeri a toutotou a te an bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Sa se kantite a bagay ki te pou tabènak yo, tabènak temwayaj la, jan yo te nimewote selon lòd a Moïse, pou sèvis Levit yo, ekri pa men a Ithamar, fis Aaron an, prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Alò, Betsaléel fis a Uri, fis a Hur, nan tribi Juda a, te fè tout sa ke SENYÈ a te kòmande Moïse yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Avèk li te gen Oholiab, fis a Ahisamac la, nan tribi Dan nan, yon gravè, yon mèt ouvriye, yon tiseran an materyo ble, mov, wouj, ak osi an twal fen blan. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Epi tout lò ki te sèvi nan èv la, nan tout travay sanktyè a, menm lò pou ofrann balanse anlè a te ventnèf talan e sèt-san-trant sik selon sik sanktyè a. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ajan a sa yo ki te nan kongregasyon an te gen kantite san talan e mil sèt san swasann kenz sik selon sik sanktyè a; ");
INSERT INTO hatbsa_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","yon beka pa chak tèt (sa vle di, mwatye sik, selon sik sanktyè a), pou chak moun nan sa ki te gen nimewo yo, soti nan laj ventan, e plis pou sis-san-mil-senk-san-senkant mesye. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","San talan ajan yo te pou fonde baz reseptikal sanktyè yo, ak baz reseptikal pou vwal yo; san baz reseptikal yo pou san talan, yon talan pa baz reseptikal. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Nan mil sèt san swasant kenz sik yo, li te fè kwòk pou pilye yo, li te kouvri tèt yo, e li te fè bann seraj pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Bwonz pou ofrann balanse anlè a te swasann-dis talan e de-mil-senk-san sik. ");
INSERT INTO hatbsa_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Avèk li, li te fè baz reseptikal yo pou pòtay tant reyinyon an, lotèl bwonz lan avèk griyaj an bwonz li, ak tout bagay itil pou lotèl yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","epi baz reseptikal yo pou galeri a, tout pikèt a tabènak yo ak tout pikèt pou galeri yo toutotou. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Anplis, avèk materyo ble, mov, e wouj, yo te fè vètman tise byen fen pou fè sèvis nan lye sen an, menm jan avèk vètman sen ki te pou Aaron yo, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Li te fè efòd la avèk lò, epi nan materyo ble, mov, e wouj avèk twal fen blan. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Alò, yo te bat mòso plat an lò yo, yo te koupe yo fè fil fen pou trese nan materyo ble a, mov la, wouj la e twal fen blan an, èv a yon mèt ouvriye. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Yo te fè pyès zepòl yo pou atache nan efòd la; li te tache nan de pwent anwo li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Bann ki te sou li a, ki te tise byen fen, te fèt menm jan tankou li avèk menm materyo yo: an lò avèk ble, mov, e wouj, avèk twal fen blan byen tòde, jis jan ke Bondye te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Yo te fè pyè oniks yo, plase nan monti desine byen fen yo; yo te grave tankou gravi a yon so, selon non a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Konsa, li te plase yo sou pyès zepòl nan efòd la, tankou pyè pou sonje fis a Israël yo, jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Li te fè pyès lestomak la, zèv a yon mèt ouvriye, tankou travay la fèt nan efòd la: avèk materyo an lò, an ble, an mov, e an wouj avèk twal fen blan byen tòde. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Li te kare. Yo te fè pyès lestomak la plwaye doub, longè a yon epann, e yon epann nan lajè lè li plwaye doub. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Yo te monte kat ranje pyè presye sou li. Premye ranje a te yon ranje avèk woubi, topaz, avèk emwod. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Nan dezyèm ranje a te gen yon tikwaz, yon safi, ak yon dyaman; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","epi nan twazyèm ranje a yon jasent, yon agat, ak yon ametis; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","epi nan katriyèm ranje a, yon krizolit, yon oniks, avèk yon jasp. Yo te plase yo nan monti lò byen fen lè yo te monte. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Pyè presye yo te koresponn ak non a fis Israël yo. Yo te douz, e yo te koresponn a non yo, grave avèk gravi a yon so, yo chak avèk non yo pou douz tribi yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Yo te fèt sou chenn pyès lestomak la tankou kòd ki te kòd tòde yo, lèv ki fèt an lò pi. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Yo te fè de monti yo byen fen an lò ak de wondèl lò yo, epi te plase wondèl yo nan de pwent pyès lestomak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Alò yo te mete de kòd lò yo nan de monti de wondèl lò yo nan pwent ki pou pyès lestomak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Yo te mete lòt de pwent yo nan de kòd yo avèk de monti yo fèt byen fen, e yo te mete yo sou pyès zepòl yo nan efòd la pa devan li. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Yo te fè de wondèl yo an lò e yo te plase yo nan de pwent nan pyès lestomak la sou kote pa anndan ki toupre efòd la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Anplis, yo te fè de wondèl lò yo e yo te plase yo nan pati anba pyès zepòl yo nan efòd la, pa devan li, toupre plas ke li te jwenn nan, anlè bann tise nan efòd la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Yo te mare pyès lestomak la avèk wondèl li yo ak wondèl ki te pou efòd la avèk kòd ble, pou li te sou bann tise a nan efòd la, e pou pyès lestomak la pa t vin lage nan efòd la, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Alò li te fè abiman efòd la tankou yon èv tise, tout an ble; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","epi ouvèti abiman an te anwo nan mitan, tankou ouvèti ki nan yon pwotèj lagè avèk yon woulèt ki antoure l pou l pa vin chire. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Yo te fè grenad avèk materyo ble, mov, wouj ak twal fen blan byen tòde nan woulèt abiman an. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Yo te osi fè klòch avèk lò pi, e yo te plase klòch yo antre grenad yo toutotou woulèt abiman an, ");
INSERT INTO hatbsa_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ki te toujou youn aprè lòt, yon klòch, ak yon grenad toutotou sou woulèt abiman sèvis la, jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Yo te fè tinik ki te tise an twal fen blan an pou Aaron, ak fis li yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","epi tiban avèk len fen an ak chapo an twal fen blan yo, e pantalon an twal fen blan byen tòde yo, ");
INSERT INTO hatbsa_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","epi sentiwon avèk twal fen blan an ak materyo ble, mov, e wouj, travay a yon tiseran, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Yo te fè plak pou kouwòn sen an avèk lò pi, e yo te enskri nan li tankou gravè a yon so: “Sen a SENYÈ a”. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Yo te tache kòd ble a ak li pou tache li nan tiban an pa anwo, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Konsa tout travay a tabènak tant reyinyon an te konplete; epi fis Israël yo te fè tout bagay selon sa ke SENYÈ a te kòmande Moïse la; konsa yo te fè l. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Yo te mennen tabènak la vè Moïse, tant lan avèk tout sa ki te founi li yo: kwòk li yo, planch li yo, travès li yo, ak pilye li yo avèk baz reseptikal li yo; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","epi kouvèti po belye fonse wouj yo, kouvèti po dofen yo, ak vwal rido pòtay la; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","lach a temwayaj la avèk poto li yo, ak chèz pwopyatwa a; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tab la, tout bagay itil li yo, ak pen a Prezans lan; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","chandelye fèt an lò pi a, avèk aranjman pou lanp yo ak tout bagay itil li yo, ak lwil pou limyè a; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","epi lotèl fèt an lò a, lwil onksyon an, lansan santi bon an, ak vwal pou pòtay tant lan; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","lotèl an bwonz lan ak griyaj bwonz pa li, avèk poto pa li yo ak tout bagay itil li yo, basen lave a avèk baz li; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","afè pandye yo pou galeri a, pilye li yo, baz reseptikal li yo, rido pou pòtay galeri a, kòd li yo, pikèt li yo, ak tout afè pou sèvis tabènak la, pou tant reyinyon an; ");
INSERT INTO hatbsa_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","vètman tise yo pou sèvis nan lye sen an, vètman sen pou Aaron yo, prèt la, ak vètman a fis pa li yo, pou fè sèvis kòm prèt. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Alò, fis Israël yo te fè tout travay la selon tout sa ke SENYÈ a te kòmande Moïse yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Epi Moïse te egzamine tout travay la, e gade byen, konsa yo te fè li; jis jan ke SENYÈ a te kòmande a, se sa yo te fè. Epi Moïse te beni yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Nan premye jou mwa a ou va monte tabènak tant reyinyon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ou va plase lach temwayaj la, e ou va kouvri lach la avèk vwal la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ou va mennen tab la antre, e ou va ranje li avèk sa ki dwe sou li. Konsa, ou va mennen fè antre chandelye a, e limen lanp li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Anplis, ou va plase lotèl lò a pou lansan devan lach temwayaj la, e ou va monte vwal la pou pòtay tabènak tant reyinyon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Ou va plase lotèl ofrann brile a devan pòtay a tabènak tant reyinyon an. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ou va plase basen lave a antre tant reyinyon an ak lotèl la e ou va mete dlo nan li. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ou va monte galeri a toutotou e ou va pann vwal la pou pòtay galeri a. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Epi ou va pran lwil onksyon an e ou va onksyone tabènak la ak tout sa ki ladann. Konsa, ou va konsakre li avèk tout afè li yo, epi li va sen. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ou va onksyone lotèl ofrann brile a ak tout bagay itil li yo, epi ou va konsakre lotèl la. Konsa, lotèl la va vin sen pase tout bagay. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ou va onksyone basen lave a ak baz li, e ou va konsakre li. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Konsa, ou va mennen Aaron ak fis li yo vè pòtay tant reyinyon an, e ou va lave yo avèk dlo. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ou va mete vètman sen yo sou Aaron. Ou va onksyone Aaron, e konsakre li, pou li kapab vin sèvi kòm prèt Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ou va mennen fis li yo pou mete tinik sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Konsa, ou va onksyone yo jis jan ke ou te onksyone papa yo, pou yo kapab vin sèvi kòm prèt pou Mwen. Onksyon pa yo va kalifye yo kòm prèt pou tout tan atravè tout jenerasyon pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Se konsa Moïse te fè. Selon tout sa ke SENYÈ a te kòmande li yo, konsa li te fè. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Alò, nan premye mwa nan dezyèm ane a, nan premye jou mwa a, tabènak la te monte. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moïse te monte tabènak la. Li te poze baz reseptikal li yo, li te monte planch li yo, li te pozisyone travès li yo, e li monte pilye li yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Li te louvri tant lan sou tabènak la e li te mete kouvèti tant lan anwo li, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Konsa, li te pran temwayaj la pou fè l antre nan lach la. Li te tache poto yo nan lach la, e li te mete chèz pwopyatwa a sou lach la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Li te mennen lach la nan tabènak la, e li te monte yon vwal pou separe l. Li te separe lach temwayaj la, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Anplis li te mete tab la nan tant reyinyon an sou kote nò tabènak la, deyò vwal la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Li te plase pen, byen ranje an lòd devan SENYÈ a jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Alò, li te mete chandelye a nan tant reyinyon an, sou kote sid tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Li te limen lanp yo devan SENYÈ a, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Epi li te plase lotèl lò a nan tant reyinyon an pa devan vwal la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Li te brile lansan santi bon an sou li, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Alò, li te monte vwal pòtay tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Li te plase lotèl ofrann brile a devan pòtay tabènak tant reyinyon an, e li te ofri sou li ofrann brile a ak ofrann sereyal la, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Li te plase basen lave a antre tant reyinyon an ak lotèl la, e li te mete dlo ladann pou lave. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Nan li, Moïse avèk Aaron avèk fis li yo te lave men yo avèk pye yo. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Lè yo te antre nan tant reyinyon an, e lè yo te apwoche lotèl la, yo te lave, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Li te monte galeri a toutotou tabènak la ak lotèl la, e li te pandye vwal la pou pòtay galeri a. Konsa, Moïse te fin fè travay la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Alò, nyaj la te kouvri tant reyinyon an, e laglwa SENYÈ a te ranpli tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moïse pa t kapab antre nan tant reyinyon an, paske nyaj la te poze sou li, e laglwa SENYÈ a te ranpli tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Pandan tout vwayaj pa yo, nenpòt lè ke nyaj la te leve anwo sou tabènak la, fis Israël yo te leve sòti pou fè vwayaj; ");
INSERT INTO hatbsa_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","men si nyaj la pa t leve, alò, yo pa t vwayaje jis rive jou ke li te leve a. ");
INSERT INTO hatbsa_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Paske pandan tout vwayaj yo, nyaj SENYÈ a te sou tabènak la nan lajounen, e li te gen dife ladann lannwit, devan zye a tout kay Israël la. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Alò, SENYÈ a te rele Moïse, e Li te pale avèk li depi nan tant asanble a. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Pale a fis Israël yo pou di yo: ‘Lè nenpòt moun nan nou pote yon ofrann bay SENYÈ a, nou va pote ofrann bèt ki sòti nan twoupo a, oswa nan bann mouton an. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“‘Si ofrann li an se yon ofrann brile ki sòti nan twoupo a, li va ofri li; yon mal san defo. Li va ofri li nan pòtay tant asanble a, pou li kapab aksepte devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Li va poze men li sou tèt ofrann brile a, e ofrann la va aksepte pou li, pou fè ekspiyasyon pou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Li va touye jenn towo a devan SENYÈ a. Konsa, fis Aaron yo, ki se prèt yo, va ofri san an e flite li toutotou lotèl ki nan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Li va, answit, kòche ofrann brile a e koupe li an mòso. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Fis Aaron yo, prèt la, va mete dife sou lotèl la e ranje bwa yo sou dife a. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Alò fis Aaron yo, prèt yo, va ranje mòso yo, tèt la avèk grès ren an sou bwa ki sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Men zantray li yo avèk janm li yo, moun nan va lave yo avèk dlo. Epi prèt la va brile li nèt sou lotèl la kòm yon ofrann brile, yon ofrann pa dife, yon bagay ki santi dous pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“‘Men si ofrann li an sòti nan bann bèt la, mouton oswa kabrit kòm yon ofrann brile, li va ofri li yon mal, san defo. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Li va touye li sou kote nò lotèl la, devan SENYÈ a, epi fis Aaron yo, prèt yo, va flite san li toutotou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Li va, answit, koupe li an mòso, avèk tèt li ak grès ren li. Prèt la va ranje yo sou bwa ki sou dife ki sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Men zantray li yo avèk janm yo, moun nan va lave yo avèk dlo. Epi prèt la va ofri tout nèt, e ofri li nan lafimen sou lotèl la. Li se yon ofrann brile, yon ofrann pa dife, yon bagay ki santi dous pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“‘Men si ofrann li an bay SENYÈ a se yon ofrann brile fèt ak zwazo, alò, li va pote ofrann li an ak toutrèl oswa jèn ti pijon. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Prèt la va ofri li sou lotèl la, e tòde kou li pou ofri li nan lafimen sou lotèl la; konsa, san li va koule sou kote lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Li va osi retire fal li avèk plim li yo e voye li sou kote lès lotèl la, nan plas sann yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Li va chire li pa zèl li, san fin separe l nèt. Konsa, prèt la va ofri li nan lafimen sou lotèl la, sou bwa ki sou dife a. Li se yon ofrann brile, yon ofrann pa dife yon bagay ki santi dous devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“‘Alò, lè yon moun prezante yon ofrann sereyal la kòm ofrann bay SENYÈ a, ofrann li an va avèk farin fen. Li va vide lwil sou li e mete lansan sou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Answit, li va pote li bay fis Aaron yo, prèt yo. Li va pran ladann de men plen nan farin fen ak lwil avèk tout lansan li an. Konsa, prèt la va ofri li nan lafimen kòm yon pati komemoratif la sou lotèl la, yon ofrann pa dife, yon bagay ki santi dous pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Rès ofrann sereyal la se pou Aaron avèk fis li yo; yon bagay ki sen pase tout, nan ofrann pa dife pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“‘Alò, lè nou pote yon ofrann sereyal kwit nan yon fou, li va fèt avèk gato san ledven avèk farin fen melanje avèk lwil oubyen galèt san ledven ki kouvri avèk lwil. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si ofrann ou an se yon ofrann sereyal ki fèt nan pwalon, li va fèt avèk farin fen, san ledven, melanje avèk lwil. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Ou va kase li an miyèt mòso e vide lwil sou li. Li se yon ofrann sereyal. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Alò si ofrann ou an se yon ofrann sereyal ki fèt nan yon chodyè, li va fèt avèk farin fen avèk lwil. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ou va pote yon ofrann ki fèt avèk bagay sa yo bay SENYÈ a. Li va prezante a prèt la, e li va pote li devan lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Alò, prèt la va pran nan ofrann sereyal la, pati komemoratif la, e li va ofri li nan lafimen sou lotèl la kòm yon ofrann pa dife yon bagay ki santi dous pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Rès ofrann sereyal la se pou Aaron avèk fis li yo; yon bagay ki sen pase tout, nan ofrann bay SENYÈ a pa dife yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“‘Okenn ofrann sereyal, ke nou pote devan SENYÈ a p ap fèt avèk ledven, paske nou pa pou lofri nan lafimen okenn ledven ni siwo myèl kòm ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kòm ofrann premye fwi, nou va pote yo bay SENYÈ a, men yo p ap monte kòm ofrann santi dous sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Chak ofrann sereyal de nou menm, anplis, nou va asezone li avèk sèl. Li fò ke sèl akò a Bondye nou an pa manke nan ofrann sereyal ou an. Avèk tout ofrann ou yo, ou va ofri sèl. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“‘Osi, si ou pote bay SENYÈ a, yon ofrann sereyal de bagay ofrann premye fwi yo, ou va pote tèt sereyal yo byen fre, boukannen nan dife, grenn moulen a rekòlt avan lè a, kòm ofrann sereyal de ofrann premye fwi yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Alò, ou va mete lwil sou li e poze lansan sou li; li se yon ofrann sereyal. ");
INSERT INTO hatbsa_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Prèt la va ofri nan lafimen pati pou tout moun sonje a, yon pati sereyal moulen ak lwil li, avèk tout lansan li kòm ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“‘Alò, si ofrann li an se yon ofrann lapè, si li pral ofri sòti nan twoupo a, kit se mal, kit se femèl, li va ofri li san defo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Li va mete men li sou tèt ofrann li an, e touye li nan pòtay tant asanble a. Epi fis Aaron yo, prèt yo, va flite san li toupatou sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Soti nan sakrifis ofrann lapè yo, li va prezante yon ofrann pa dife bay SENYÈ a, avèk grès ki kouvri zantray yo ak tout grès ki tache a zantray yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","epi de ren yo avèk grès ki sou yo a, ki sou senti a, ak gwo mòso fwa a, ke li va retire avèk ren yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Answit, fis Aaron yo va ofri li nan lafimen sou lotèl la sou ofrann brile ki sou bwa ki sou dife a. Li se yon ofrann pa dife, yon bagay ki santi dous pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“‘Men si ofrann li an pou yon sakrifis ofrann lapè pou SENYÈ a, sòti nan bann bèt la, li va ofri li, mal oswa femèl san defo. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Si li pral ofri yon jenn mouton pou ofrann li an, alò, li va ofri li devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Epi li va poze men li sou tèt ofrann li an e touye li devan tant asanble a, epi fis Aaron yo va flite san li toupatou sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Soti nan ofrann sakrifis lapè a, li va pote kòm ofrann pa dife bay SENYÈ a, grès li, tout grès ke li menm, moun nan va retire pre zo do a, ak grès ki kouvri zantray yo ak tout grès ki tache sou zantray yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Epi de ren yo avèk grès ki sou yo a, ki sou pati ba senti a, ak gran bout fwa a, ke li va retire avèk ren yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Answit, prèt la va ofri li nan lafimen sou lotèl la tankou manje, yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“‘Anplis, si ofrann li an se yon kabrit, alò, li va ofri li devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Li va poze men l sou tèt li e touye li devan tant asanble a, epi fis Aaron yo va flite san li toupatou sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Soti nan li, li va prezante ofrann li kòm ofrann pa dife bay SENYÈ a; grès ki kouvri zantray yo ak tout grès ki tache sou zantray yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ak de ren yo avèk grès ki sou yo a, ki sou pati ba senti a, ak gwo bout fwa a, ke li va retire avèk ren yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Prèt la va ofri yo nan lafimen sou lotèl la tankou manje, yon ofrann pa dife bagay ki santi dous; tout grès se pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“‘Li se yon règleman pou tout tan atravè tout jenerasyon nou yo, nan tout abitasyon nou yo: nou pa pou manje okenn grès, ni okenn san.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Pale avèk fis Israël yo. Di yo: ‘Si yon moun peche san movèz entansyon nan nenpòt bagay ke SENYÈ a te kòmande pou pa fè, e ki fèt pa nenpòt nan yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","si prèt onksyon an fè peche e mennen koupabilite sou pèp la, alò, kite li ofri bay SENYÈ a yon towo san defo, kòm ofrann peche pou peche ke li te komèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","“‘Li va pote towo a nan pòtay tant asanble a devan SENYÈ a. Li va poze men l sou tèt towo a e touye li devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Alò, prèt onksyone a dwe pran kèk nan san towo a pou pote li vè tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Konsa, prèt la va fonse dwèt li nan san an, e flite kèk nan san an sèt fwa devan SENYÈ a, devan vwal sanktyè a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Prèt la va osi mete kèk nan san an sou kòn lotèl lansan santi bon an ki devan SENYÈ a nan tant asanble a, epi tout san towo a, li va vide li nan baz lotèl ofrann brile ki nan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Li va retire sou li tout grès towo ofrann peche a: grès ki kouvri zantray yo ak tout grès ki tache sou zantray yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ak de ren avèk grès ki sou yo a, ki sou pati ba senti a, ak gwo mòso fwa a, ke li va retire avèk ren yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","(jis jan ke li retire nan bèf sakrifis ofrann lapè a), epi prèt la dwe ofri yo nan lafimen sou lotèl ofrann brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Men po towo a ak tout chè li avèk tèt li, janm li yo, zantray li yo ak watè li, ");
INSERT INTO hatbsa_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ki se, tout rès towo a, li dwe pote li yon kote ki pwòp deyò kan an, kote sann dife vide, epi brile li sou bwa avèk dife a. Kote sann yo vide, se la li va brile. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“‘Alò, si tout asanble Israël la vin fè yon erè, e bagay la chape atansyon asanble a, epi yo komèt nenpòt nan bagay ke SENYÈ a te kòmande pou yo pa fè, e yo vin koupab; ");
INSERT INTO hatbsa_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","lè peche ke yo te komèt la, vin konnen, alò, asanble a va ofri yon towo nan twoupo a kòm yon ofrann peche, e yo va pote li devan tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Answit, ansyen nan asanble yo va poze men yo sou tèt towo a devan SENYÈ a, epi towo a va touye devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Answit, prèt onksyone a dwe pote kèk nan san towo a nan tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Konsa, prèt la va fonse dwèt li nan san an e flite li sèt fwa devan SENYÈ a, devan vwal la. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Li va mete kèk nan san sou kòn lotèl ki devan SENYÈ a nan tant asanble a; epi rès san li va vide nan baz lotèl ofrann brile ki nan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Li va retire tout grès li ladann e li va ofri li nan lafimen sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Li va osi fè avèk towo a menm bagay li te fè avèk towo ofrann peche a; se konsa li va fè avè l. Konsa, prèt la va fè ekspiyasyon pou yo, e yo va vin padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Answit, li dwe pote towo a yon kote deyò kan an pou brile li jan li te brile premye towo a. Li se ofrann peche pou asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“‘Lè yon dirijan fè peche, e san movèz entansyon vin fè nenpòt nan bagay ke SENYÈ a, Bondye te kòmande pou li pa fè yo, e li vin koupab, ");
INSERT INTO hatbsa_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","si peche ke li te fè a vin konnen a li menm, li va pote pou ofrann li, yon kabrit, yon mal san defo. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Li va poze men li sou tèt mal kabrit la e touye li nan plas kote yo touye ofrann brile devan SENYÈ a. Li se yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Answit, prèt la dwe pran kèk nan san ofrann peche a avèk dwèt li e mete li sou kòn lotèl pou ofrann brile a. Konsa, rès san li an, prèt la va vide nan baz lotèl ofrann brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Tout grès li a, prèt la va ofri nan lafimen sou lotèl la menm jan an nan ka grès sakrifis ofrann lapè a. Konsa prèt la va fè ekspiyasyon pou li selon peche pa li, e li va vin padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“‘Alò, si nenpòt moun pami pèp òdinè a peche san movèz entansyon nan fè nenpòt nan bagay ke SENYÈ a te kòmande pou pa fè yo, e li vin koupab, ");
INSERT INTO hatbsa_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","si peche li a vin konnen a li menm, alò, li va pote pou ofrann pa li a, yon kabrit, yon femèl san defo, pou peche ke li te komèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Li va poze men l sou tèt ofrann peche a, e li va touye ofrann peche a nan menm plas ofrann brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Prèt la va pran kèk nan san li an avèk dwèt li, e li va mete li sou kòn lotèl ofrann brile a; epi tout rès san li an, prèt la va vide l nan baz lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Answit, li va retire tout grès li, jis jan grès la te retire nan sakrifis ofrann lapè yo; epi prèt la va ofri li nan lafimen sou lotèl la pou yon odè santi bon pou SENYÈ a. Konsa prèt la va fè ekspiyasyon pou li, e li va vin padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“‘Men si li pote yon jenn mouton kòm ofrann li pou ofrann peche a, li va pote li, yon femèl san defo. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Li va poze men l sou tèt ofrann peche a, e li va touye li kòm yon ofrann peche nan plas kote yo touye ofrann brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Prèt la dwe pran kèk nan san ofrann peche a avèk dwèt li e mete li sou kòn lotèl ofrann brile a, epi tout rès san li an, prèt la va vide li nan baz lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Answit, li va retire tout grès li, menm jan grès jenn mouton an te retire nan sakrifis ofrann lapè yo, epi prèt la va ofri yo nan lafimen bay SENYÈ a. Konsa prèt la va fè ekspiyasyon pou li selon peche li, sa ke li te komèt la, e li va vin padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“‘Alò, si yon moun peche lè l rele pou fè temwayaj tribinal kòn yon temwen, konsènan si li te wè oubyen otreman vin konnen yon bagay, si li pa pale sa, alò, li va pote koupabilite pa li. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“‘Oubyen, si yon moun touche nenpòt bagay ki pa pwòp, kit se yon kadav bèt pa pwòp, kit se yon kadav bèf ki pa pwòp, kit se kadav yon desen bèt vivan ki pa pwòp, malgre ke sa ta kache de li pou li pa konnen, e li pa pwòp, alò li va koupab. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Oubyen, si li ta touche afè moun ki pa pwòp, nenpòt sa li ye ki fè l vin pa pwòp la, epi sa kache de li, e answit, li vin konn sa, li va koupab. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Oubyen, si yon moun sèmante san reflechi avèk bouch li, kit se pou fè mal, kit se pou fè byen, nan nenpòt afè ke yon nonm ta pale san reflechi avèk yon sèman, epi sa kache de li, e answit li vin konn sa, li va koupab nan youn nan sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Se konsa li va ye lè li vin koupab nan youn nan sa yo, ke li va konfese nan sa ke li te fè peche a. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Li va osi pote ofrann koupabilite li a bay SENYÈ a pou peche ke li te komèt la: yon femèl ki sòti nan bann bèt la, yon jenn mouton, oswa yon kabrit kòm yon ofrann peche. Konsa prèt la va fè ekspyasyon nan non li pou peche li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“‘Men si li pa gen mwayen pou bay yon jenn mouton oswa kabrit, alò li va pote bay SENYÈ a kòm ofrann koupabilite pou peche ke li te komèt la, de toutrèl oswa de jenn pijon, youn pou yon ofrann peche a, e lòt la, pou yon ofrann brile. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Li va pote yo bay prèt la, ki va ofri, premyèman, sa ki pou ofrann peche a, e li va tranche tèt li pa devan kou a san ke li pa fin separe li nèt. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Li va osi flite kèk nan san ofrann peche a sou kote lotèl la, e rès san an va koule degoute nan baz lotèl la. Li se yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Dezyèm nan, li va, answit, prepare kòm yon ofrann brile selon òdonans lan. Epi prèt la va fè ekspiyasyon nan non li menm pou peche ke li te komèt la, e li va vin padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“‘Men si mwayen li pa sifi pou de toutrèl oswa de jenn pijon yo, alò pou ofrann li pou peche ke li te komèt la, li va pote yon dizyèm efa farin fen pou ofrann peche a. Li p ap mete lwil sou li ni mete lansan sou li, paske se yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Li va pote li bay prèt la, e prèt la va pran men plen de li kòm yon pati komemoratif, pou ofri li nan lafimen sou lotèl la, avèk ofrann bay SENYÈ a pa dife. Li se yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Alò, prèt la va fè ekspiyasyon pou li konsènan peche ke li te komèt soti nan youn nan sila yo, e sa va padone li. Konsa, rès la va vin pou prèt la menm jan ak ofrann sereyal la.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Answit SENYÈ a te pale avèk Moïse e t ap di: ");
INSERT INTO hatbsa_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Si yon moun pa fidèl, e peche san movèz entansyon kont bagay ki sen pou SENYÈ a, alò li va pote ofrann koupabilite li devan SENYÈ a; yon belye san defo ki sòti nan bann bèt la, selon valè an ajan de sik, an valè de sik sanktyè a kòm yon ofrann koupabilite. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Li va peye pou peche ke li te fè kont bagay sen an, e li va mete sou li yon senkyèm pati anplis pou pote bay prèt la. Prèt la, alò va fè ekspiyasyon pou li avèk belye a ofrann koupabilite a, e Li va padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Alò, si yon moun peche e fè nenpòt nan bagay ke SENYÈ a te kòmande pou pa fè yo, malgre li pa t konnen sa, li toujou koupab e li va pote koupabilite li. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Li dwe, alò, pote bay prèt la yon belye san defo ki sòti nan bann bèt la, selon sa ou estime, pou yon ofrann koupabilite. Alò, prèt la va fè ekspiyasyon pou li konsènan tò li ladann li te fè peche san movèz entansyon, e pa t konnen sa a, e li va padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Li se yon ofrann koupabilite. Sètènman, li koupab devan SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Lè yon moun peche e aji avèk movèz fwa kont SENYÈ a, epi twonpe pwochen li an sou yon depo lajan oswa yon sekirite ke li te konfye bay li, oswa pa vòl, oubyen li te fè li pa vyòl konfyans, ");
INSERT INTO hatbsa_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","oubyen, si l te twouve sa ki te pèdi a, te fè manti sou sa ak fo sèman, pouke li peche nan nenpòt nan bagay ke yon moun kapab fè yo; ");
INSERT INTO hatbsa_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","alò li va rive, ke lè li peche e vin koupab, li va remèt sa ke li te pran pa vòl la, oubyen sa ke li te vin gen pa vyòl konfyans lan, oubyen depo ki te plase nan men li an, oubyen sa ki te pèdi ke li te twouve a, ");
INSERT INTO hatbsa_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","oubyen, nenpòt de sa li te fè fo sèman an. Li va fè remèt li nèt e mete sou li yon senkyèm anplis. Li va bay li a sila li apatyen an, nan menm jou li prezante ofrann koupabilite li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Li va pote bay prèt la ofrann koupabilite li a, bay SENYÈ a, yon belye san defo ki soti nan bann bèt la, selon sa ou estime, pou yon ofrann koupabilite. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Konsa, prèt la va fè ekspiyasyon pou li devan SENYÈ a, e li va padone pou nenpòt nan bagay sa yo ke li te fè pou vin koupab.” ");
INSERT INTO hatbsa_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Alò, SENYÈ a te pale a Moïse, e t ap di: ");
INSERT INTO hatbsa_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Kòmande Aaron avèk fis li yo e di: ‘Sa se lalwa pou ofrann brile a: ofrann brile a li menm va retire nan fwaye lotèl la tout nwit lan jis rive nan maten, epi dife sou lotèl la va kontinye brile sou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Prèt la dwe abiye an vètman len fen pa li a, e li va mete sou vètman li touprè chè li. Konsa, li va pran sann dife yo nan ofrann brile a pou dife a ki vin redwi sou lotèl la e plase yo akote lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Answit, li va retire vètman sa yo pou mete lòt vètman. Epi li va pote sann yo deyò kan an nan yon plas ki pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Dife sou lotèl la dwe kontinye brile sou li. Li pa pou tenyen, men prèt la va brile bwa sou li chak maten. Li va pozisyone ofrann brile a sou li, e ofri sou li nan lafimen pati grès ofrann lapè yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Dife a dwe kontinye brile nèt sou lotèl la; li pa pou tenyen. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“‘Alò, sa se lalwa ofrann sereyal la: fis Aaron yo va prezante li devan SENYÈ a, devan lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Answit, li va leve soti de li yon men plen avèk farin fen ofrann sereyal la, avèk lwil li ak tout lansan ki sou ofrann sereyal la, epi li va ofri li anlè nan lafimen sou lotèl la, yon odè santi bon, kòm yon ofrann souvni bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Sa ki rete nan li a, Aaron avèk fis li yo dwe manje. Li va manje tankou gato san ledven nan yon plas ki sen. Yo dwe manje li nan galeri tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Li p ap boukannen avèk ledven. Mwen te bay li kòm pòsyon pa yo nan ofrann pa M pa dife a. Li pi sen pase tout, kòm ofrann peche ak ofrann koupabilite a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Chak mal pami fis Aaron yo kapab manje li. Li se yon òdonans pèmanan, atravè jenerasyon nou yo, soti nan ofrann dife bay SENYÈ a. Nenpòt moun ki touche yo va sen.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Alò, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Sa se ofrann ke Aaron avèk fis li yo dwe prezante bay SENYÈ a nan jou ke li onksyone a: dizyèm nan yon efa farin fen kòm yon ofrann sereyal nòmal, mwatye nan li nan maten e mwatye nan li nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Li va prepare avèk lwil nan yon pwalon. Lè li fin byen vire, ou va pote li. Ou va prezante ofrann sereyal la an mòso boukannen kòm bon sant bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Prèt onksyone a ki nan plas li pami fis li yo va ofri li. Pa yon òdonans pèmanan, li va ofri tout nèt nan lafimen bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Konsa, chak ofrann sereyal va konplètman brile nan lafimen bay SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Pale avèk Aaron ak fis li yo pou di: ‘Sa se lalwa ofrann peche a: nan plas kote ofrann brile a vin touye a, ofrann peche a va touye devan SENYÈ a. Li pi sen pase tout. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Prèt la ki ofri li pou peche a va manje li. Li va manje yon kote ki sen, nan galeri a tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Nenpòt moun ki touche chè li va vin sen. Lè kèk nan san li vin gaye sou yon vètman, nan yon lye sen, ou va lave sa ki te gaye sou li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Osi po ajil ladann li te bouyi a va kraze; epi si li te bouyi nan yon veso an bwonz, alò li va lave byen lave, e rense nan dlo. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Chak mal pami prèt yo kapab manje ladann. Li pi sen pase tout. ");
INSERT INTO hatbsa_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Men okenn ofrann peche ki te gen san ki te pote antre nan tant asanble a pou fè ekspiyasyon nan lye sen an p ap manje. Li va brile avèk dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“‘Alò sa se lalwa ofrann koupabilite a: li pi sen pase tout. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nan plas kote yo touye ofrann brile a, yo dwe touye ofrann koupabilite a, e li va flite san li toupatou sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Answit, li va ofri li avèk tout grès li: grès ke avèk grès ki kouvri zantray yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ak de ren yo avèk grès ki sou yo, ki nan pati senti a; epi gwo bout fwa a, li va retire avèk ren yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Prèt la va ofri yo nan lafimen sou lotèl la kòm yon ofrann pa dife bay SENYÈ a. Li se yon ofrann koupabilite. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Chak mal pami prèt yo kapab manje li. Li pi sen pase tout. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“‘Ofrann koupabilite a se tankou ofrann peche a, se yon sèl lwa pou yo. Prèt ki fè ekspiyasyon avèk li a va genyen li. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Osi, prèt ki prezante ofrann brile a nenpòt moun nan, prèt sa a va gen pou li menm, po a ofrann brile ke li te prezante a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Menm jan an, chak ofrann sereyal ki vin kwit nan fou a ak tout bagay ki prepare nan yon pwalon va rete pou prèt ki prezante li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Tout ofrann sereyal, mele avèk lwil oswa sèch, va vin apatyen a tout fis Aaron yo, tout menm jan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“‘Alò, sa se lalwa sakrifis ofrann lapè ki va prezante bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si li ofri li pou bay remèsiman, alò, ansanm avèk sakrifis remèsiman an, li va ofri gato san ledven mele avèk lwil, galèt kouvri avèk lwil, ak gato farin fen mele avèk lwil. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Avèk sakrifis ofrann lapè pou bay remèsiman an, li va prezante ofrann li an avèk gato pen san ledven. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","De sa, li va prezante youn nan chak ofrann kòm yon don bay SENYÈ a. Li va apatyen a prèt ki flite san ofrann lapè yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Alò, pou chè a sakrifis ofrann lapè li yo, li va manje nan jou li ofri a. Li p ap kite anyen nan li rete pou maten. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“‘Men si sakrifis lapè a se yon ofrann pou fè ve, oswa yon ofrann bòn volonte, li va manje nan jou ke li ofri sakrifis la. Epi nan pwochen jou a, sa ki rete a, ap kapab manje; ");
INSERT INTO hatbsa_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","men sa ki rete nan chè sakrifis la, nan twazyèm jou a, va brile avèk dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Alò, si nenpòt nan chè sakrifis ofrann lapè yo ta janm manje nan twazyèm jou a, sila ki ofri li a, p ap aksepte, e li p ap konte nan avantaj li. Li va yon bagay lèd, e moun ki manje ladann nan, va pote pwòp inikite pa li. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“‘Osi, chè ki touche yon bagay ki pa pwòp p ap manje. Li va brile avèk dife. Pou lòt chè, nenpòt moun ki pwòp kapab manje chè sa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Men moun ki manje chè sakrifis ofrann lapè ki apatyen a SENYÈ a lè l pa pwòp, moun sa a va vin koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Lè yon moun touche yon bagay ki pa pwòp, kit se bagay sal ki sòti nan moun, kit se yon bèt ki pa pwòp, kit se yon vye bagay sal, e manje chè sakrifis ofrann lapè ki apatyen a SENYÈ a, moun sa a va vin koupe retire de pèp li a.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Answit, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Pale avèk fis Israël yo e di: ‘Nou pa pou manje okenn grès a yon bèf, yon mouton, oswa yon kabrit. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Osi, grès a yon bèt ki mouri e grès a yon bèt ki dechire pa bèt parèy li kapab mete a nenpòt lòt sèvis, men anverite, nou pa pou manje li. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Paske nenpòt moun ki manje nan grès animal ki soti nan yon ofrann pa dife ki ofri bay SENYÈ a, menm moun ki manje l, va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Nou pa pou bwè okenn san, ni san zwazo, ni san bèt, ni okenn san nan abitasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Nenpòt moun ki bwè nenpòt san, menm moun sa a va koupe retire de pèp li a.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Answit, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Pale avèk fis Israël yo, e di: ‘Sila ki ofri sakrifis ofrann lapè bay SENYÈ a, va pote ofrann li an bay SENYÈ a soti nan sakrifis ofrann lapè li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Se pwòp men li ki va pote ofrann pa dife a bay SENYÈ a. Li va pote grès la avèk pwatrin nan, pou pwatrin nan kapab prezante kòm yon ofrann voye anlè devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Prèt la va ofri grès la nan lafimen sou lotèl la, men pwatrin nan va pou Aaron avèk fis li yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Nou va bay kwis dwat la a prèt la kòm yon don ki sòti nan sakrifis ofrann lapè nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Sila pami fis Aaron ki ofri san ofrann lapè a ak grès la, kwis dwat la va pou li kòm pati pa li. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Paske, Mwen te pran pwatrin nan ofrann vag la ak kwis la ki te bay pa fis Israël yo ki sòti nan ofrann lapè pa yo a pou bay yo a Aaron, prèt la, ak fis li yo, kòm dwa yo pou tout tan ki sòti nan fis Israël yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Se sa ki konsakre a Aaron e ki konsakre a fis li yo soti nan ofrann brile bay SENYÈ a, depi jou ke li te prezante yo pou sèvi kòm prèt bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Sa yo SENYÈ a te kòmande pou bay yo sòti nan fis Israël yo nan jou ke li te onksyone yo a. Se dwa yo pou tout tan atravè tout jenerasyon pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Sa se lalwa pou ofrann brile a, ofrann sereyal, ofrann peche, ofrann koupabilite, ofrann òdinasyon ak sakrifis ofrann lapè yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ke SENYÈ a te kòmande Moïse nan Mòn Sinaï nan jou ke li te kòmande fis Israël yo pou prezante ofrann pa yo bay SENYÈ a nan dezè Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Alò, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Pran Aaron ak fis li yo avè l, avèk vètman yo, lwil onksyon an, towo ofrann peche a, de belye, ak panyen pen san ledven an, ");
INSERT INTO hatbsa_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","epi reyini tout asanble a nan pòtay tant asanble a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Alò, Moïse te fè ojis sa ke SENYÈ a te kòmande li a. Lè asanble a te fin reyini nan pòtay tant asanble a, ");
INSERT INTO hatbsa_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moïse te di asanble a: “Sa se bagay ke SENYÈ a te kòmande pou fè yo.” ");
INSERT INTO hatbsa_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Konsa, Moïse te fè Aaron avèk fis li yo vin pwoche e te benyen yo avèk dlo. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Li te mete yon tinik sou li, mare senti li avèk yon sentiwon an twal, abiye li avèk yon manto, mete efòd la sou li; epi li te tache ban atistik efòd la e mare l sou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Li te mete pyès lestomak la sou li. Anplis, nan pyès lestomak la, li te mete Ourim nan avèk Toumim nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Li te plase plastwon an sou tèt li. Sou plastwon an, pa devan, li te mete plak an lò a, kouwòn sen an, jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Alò, Moïse te pran lwil onksyon an e te onksyone tabènak la ak tout sa ki te ladann, epi li te konsakre yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Li te flite kèk lwil ladann sou lotèl la sèt fwa, e li te onksyone lotèl la avèk tout zouti li yo, ak basen an avèk baz li pou konsakre yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Konsa, li te vide kèk nan lwil onksyon an sou tèt Aaron, e li te onksyone li, pou konsakre li. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Apre sa, Moïse te fè fis Aaron yo pwoche. Li te abiye yo avèk tinik yo, mare senti yo avèk sentiwon an twal yo e mare kas yo sou yo, jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Answit, li te pote towo ofrann peche a, e Aaron avèk fis li yo te poze men yo sou tèt towo ofrann peche a. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Apre sa, Moïse te touye li. Li te pran san an avèk dwèt li, li te mete kèk nan li toupatou sou kòn lotèl la, e te pirifye lotèl la. Rès san an, li te vide li nan baz lotèl la, e li te konsakre li pou fè ekspiyasyon pou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Li te osi pran tout grès ki te sou zantray yo avèk gwo mòso fwa a, de ren yo avèk grès pa yo. Moïse te ofri li nan lafimen sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Men towo a avèk po li ak chè li, ak watè li, li te brile yo nan dife a deyò kan an jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Alò, li te prezante belye ofrann brile a. Aaron avèk fis li yo te poze men yo sou tèt belye a. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moïse te touye li e li te flite san an toutotou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Lè li te fin koupe belye a an mòso, Moïse te ofri tèt la, mòso yo ak grès di ki kouvri ren yo nan lafimen. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Apre li te fin lave zantray yo ak janm yo avèk dlo, Moïse te ofri tout belye a nan lafimen sou lotèl la. Se te ofrann brile a pou yon bon odè. Li te yon ofrann pa dife bay SENYÈ a, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Answit, li te prezante dezyèm belye a, belye òdinasyon an. Aaron avèk fis li yo te poze men yo sou tèt belye a. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moïse te touye li, pran kèk nan san li e li te mete li sou tèt zòrèy dwat Aaron, sou pous men dwat li ak gwo zòtèy pye dwat li. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Osi, li te fè fis Aaron yo vin toupre; epi Moïse te mete kèk nan san an sou tèt zòrèy dwat la, sou pous men dwat yo, ak sou gwo zòtèy pye dwat yo. Alò, Moïse te flite rès san an toutotou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Li te pran grès la, grès ke a, tout grès ki te sou zantray yo, gwo mòso fwa a, de ren yo avèk grès pa yo ak kwis dwat la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Nan panyen pen san ledven ki te devan SENYÈ a, li te retire yon gato pen san ledven, yon gato pen mele avèk lwil ak yon galèt, e li te plase yo sou pati grès yo ak sou kwis dwat la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Answit, li te mete tout sa yo nan men Aaron ak nan men fis li yo, e li te prezante yo kòm yon ofrann balanse an lè devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Answit, Moïse te pran yo nan men yo, e li te ofri yo nan lafimen sou lotèl la avèk ofrann brile yo. Yo te yon ofrann òdinasyon pou yon bon odè. Se te yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moïse te pran pwatrin nan, e li te prezante li kòm yon ofrann balanse an lè devan SENYÈ a. Sa te pati pa Moïse nan belye òdinasyon an, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Alò, Moïse te pran kèk nan lwil onksyon an e kèk nan san ki te sou lotèl la, e li te flite li sou Aaron, sou vètman pa li, sou fis li yo, sou vètman pou fis li yo avèk pa li a. Konsa, li te konsakre Aaron, vètman li yo, fis li yo ak vètman a fis li yo ansanm avèk li menm. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Answit, Moïse te di a Aaron ak fis li yo: “Bouyi chè a nan pòtay tant asanble a, e manje li ansanm avèk pen ki nan panyen ofrann òdinasyon an, jis jan ke m te kòmande a lè m te di: ‘Aaron avèk fis li yo va manje li.’ ");
INSERT INTO hatbsa_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Sa ki rete nan chè a ak nan pen an, ou va brile li nan dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pandan sèt jou, nou pa pou sòti deyò pòtay tant asanble a, jis rive jou ke tan òdinasyon nou an fini: paske li va òdone nou pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","“Sa ki te fèt la jodi a, konsa, SENYÈ a te bay lòd pou fè, pou fè ekspiyasyon pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Nan pòtay tant asanble a, anplis, nou va rete lajounen kon lannwit pandan sèt jou pou kenbe lòd SENYÈ a pou nou pa mouri: paske se konsa mwen resevwa lòd la.” ");
INSERT INTO hatbsa_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Konsa, Aaron avèk fis li yo te fè tout bagay ke SENYÈ a te kòmande atravè Moïse yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Alò, li te vin rive nan uityèm jou a ke Moïse te rele Aaron, fis li yo ak ansyen an Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Konsa, li te di a Aaron: “Pran pou nou menm yon jenn kabrit, yon jenn towo pou yon ofrann peche ak yon belye pou yon ofrann brile, tou de san defo, e ofri yo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Epi a fis Israël yo nou va pale pou di: ‘Pran yon mal kabrit pou yon ofrann peche, ak yon jenn kabrit avèk yon jenn mouton, toude nan laj yon ane, san defo, pou yon ofrann brile, ");
INSERT INTO hatbsa_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","epi yon bèf avèk yon belye pou ofrann lapè a, pou fè sakrifis devan SENYÈ a; e yon ofrann sereyal melanje avèk lwil: paske jodi a, SENYÈ a va parèt a nou menm.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Donk, yo te pran sa ke Moïse te kòmande devan tant asanble a. Tout asanble a te rapwoche pou kanpe devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moïse te di: “Sa se bagay ke SENYÈ a te kòmande nou pou fè, pou glwa SENYÈ a kapab parèt a nou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Konsa, Moïse te di a Aaron: “Vin toupre lotèl la, e ofri ofrann peche ak ofrann brile nou yo, pou nou kapab fè ekspiyasyon pou nou menm, ak pou pèp la; pou nou kapab fè ekspiyasyon pou yo, jan SENYÈ a te kòmande a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Donk, Aaron te vin toupre lotèl la. Li te touye jenn kabrit la, ofrann peche ki te pou li menm nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Fis Aaron yo te prezante san an ba li. Li te fonse dwèt li nan san an, li te mete kèk sou kòn lotèl la, e li te vide rès san an nan baz lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Grès la, ren yo avèk gwo mòso fwa ofrann peche a, li te ofri yo nan lafimen sou lotèl la, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Men chè a avèk po a, li te brile yo avèk dife deyò kan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Answit, li te touye ofrann brile a; epi fis Aaron yo te lonje bay li san an, e li te flite li toupatou sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yo te lonje ofrann brile a ba li an mòso avèk tèt la, e li te ofri yo nan lafimen sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Li te lave zantray yo avèk janm yo, e li te ofri yo nan lafimen avèk ofrann brile yo sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Answit, li te prezante ofrann pèp la, e li te pran kabrit ofrann peche ki te pou pèp la. Li te touye li e li te ofri li pou peche, tankou premye a. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Li te prezante osi ofrann brile a. Li te ofri li selon òdonans lan. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Apre, li te prezante ofrann sereyal la, li te plen men li avèk kèk ladann. Konsa, li te ofri li nan lafimen sou lotèl la, anplis de ofrann brile nan maten an. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Answit, li te touye bèf la avèk belye a, sakrifis lapè ki te pou pèp la. Fis Aaron yo te lonje ba li san an pou li te flite li toupatou sou lotèl la; ");
INSERT INTO hatbsa_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ak pati grès ki sòti nan bèf la, nan belye a, grès ke a ak grès ki kouvri ren yo avèk gwo mòso fwa a, ");
INSERT INTO hatbsa_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","epi yo te plase pati grès sou pwatrin yo. Konsa, li te ofri yo nan lafimen sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Men pwatrin yo avèk kwis dwat la, Aaron te prezante yo kòm yon ofrann balanse an lè devan SENYÈ a, jis jan ke Moïse te kòmande a. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Alò, Aaron te leve men li anlè vè pèp la e li te beni yo. Konsa, li te desann lè l te fin fè ofrann peche a, ofrann brile a ak ofrann lapè yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moïse avèk Aaron te antre nan tant asanble a. Lè yo te sòti e te beni pèp la, laglwa SENYÈ a te parèt a tout pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Answit, dife te sòti devan SENYÈ a, e ofrann nan te brile nèt ak pati grès sou lotèl la. Lè tout pèp la te wè sa, yo te rele fò, e yo te tonbe sou figi yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Alò Nadab avèk Abihu, fis Aaron yo, te pran pwòp plato sann dife pa yo. Lè yo te fin mete dife ladan yo, yo te mete lansan sou li e yo te ofri dife etranj la devan SENYÈ a, ke Li pa t kòmande yo fè. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Konsa, dife te sòti nan prezans SENYÈ a, e te brile yo nèt. Yo te mouri devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Answit, Moïse te di a Aaron: “Se sa ke SENYÈ a te pale lè L te di: ‘Mwen va demontre M sen a sila ki vin pwòch Mwen yo, e devan tout pèp la Mwen va onore.’” Konsa, Aaron te gade silans. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moïse te rele osi Mischaël ak Eltsaphan, fis a tonton Aaron an, Uziel. Li te di yo: “Avanse; pote moun fanmi nou yo sòti devan sanktyè a pou rive deyò kan an.” ");
INSERT INTO hatbsa_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Konsa, yo te avanse e yo te pote yo toujou nan tinik yo pou rive deyò kan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Answit, Moïse te di a Aaron avèk fis li yo, Éléazar ak Ithamar: “Pa dekouvri tèt nou, ni chire rad nou, pou nou pa mouri; pou Li pa vin ranpli avèk kòlè kont tout asanble a. Men kite tout fanmi nou yo, tout lakay Israël la, lamante akoz brile ke SENYÈ a te limen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Nou pa pou menm sòti nan pòtay tant asanble a, sinon, nou va mouri; paske lwil onksyon SENYÈ a sou nou.” ");
INSERT INTO hatbsa_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","“Alò, SENYÈ a te pale avèk Aaron. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Pa bwè diven oubyen gwòg, ni ou menm, ni fis ki avèk ou yo, lè nou ap antre nan tant asanble a, pou nou pa mouri—-sa se yon lòd pou tout tan pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Fòk nou fè yon distenksyon antre sa ki sen ak sa ki pa sen; antre sa ki pa pwòp ak sa ki pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Enstwi fis Israël yo nan tout lòd ke SENYÈ a te pale atravè Moïse yo.” ");
INSERT INTO hatbsa_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Answit, Moïse te pale ak Aaron e ak fis ki te rete vivan yo, Éléazar avèk Ithamar: “Pran ofrann sereyal ki toujou rete nan ofrann pa dife SENYÈ a, e manje li san ledven akote lotèl la, paske li sen pase tout. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Anplis, nou va manje li nan yon lye ki sen akoz ke se dwa ou ak dwa fis ou yo ki sòti nan ofrann pa dife SENYÈ a. Paske, se konsa Mwen te resevwa kòmand lan. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Sepandan, pwatrin ofrann balanse an lè a ak kwis ofrann ke nou kapab manje nan yon plas ki pwòp la, ou menm avèk fis ou yo, e fi nou yo avèk nou menm. Paske yo te bay a ou menm e a fis ou yo kòm dwa ki sòti nan sakrifis ofrann lapè a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Kwis ke yo te ofri nan leve a, ak pwatrin ke yo te ofri nan ofrann balanse an lè a, yo va pote yo ansanm avèk ofrann pa dife pati grès la, pou prezante kòm yon ofrann leve balanse an lè devan SENYÈ a. Konsa, li va yon bagay ki dwa ou, e dwa fis ou yo avèk ou pou tout tan, jan SENYÈ a te kòmande a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Men Moïse te chache avèk atansyon kabrit ofrann peche a, e vwala, li te fin brile nèt! Donk, li te fache avèk fis Aaron ki te toujou vivan yo, Éléazar avèk Ithamar. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Poukisa nou pa t manje ofrann peche ki nan lye sen an? Paske li sen pase tout, e Li te bannou li pou efase koupabilite asanble a, pou fè ekspiyasyon pou yo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Gade byen, san li pa t pote antre nan sanktyè a. Anverite, nou te dwe manje li nan sanktyè a jan Mwen te kòmande a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Men Aaron te pale avèk Moïse, e te di: “Gade byen, se jou sa a menm ke yo te prezante ofrann peche ak ofrann brile pa yo a devan SENYÈ a. Epi gade bagay konsa yo ki vin rive mwen. Si m te manje yon ofrann peche jodi a, èske li t ap bon nan zye SENYÈ a?” ");
INSERT INTO hatbsa_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Lè Moïse te tande sa, sa te sanble gen bon rezon devan zye li. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Senyè a te pale ankò a Moïse avèk Aaron, e Li te di yo: ");
INSERT INTO hatbsa_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Pale avèk fis Israël yo. Di yo: ‘Sa yo se kreyati ke nou kapab manje pami tout bèt ki sou latè yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Nenpòt bèt ki gen zago ki fann e ki remoute manje yo, nan bèt sa yo, nou kapab manje. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“‘Sepandan, nou pa pou manje nan sa yo, pami sila ki remoute manje e ki gen zago ki fann yo: chamo, paske malgre li remoute manje, li pa divize zago; li pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Menm jan an, daman an, paske malgre li remoute manje, li pa divize zago, li pa pwòp pou nou; ");
INSERT INTO hatbsa_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Lapèn tou, paske malgre li remoute manje, li pa divize zago; li pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Epi kochon an, paske malgre li divize zago, ki fè l yon zago fann, li pa remoute manje li; li pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Nou pa pou manje chè yo, ni touche kadav yo; yo pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“‘Sa yo nou kapab manje, nenpòt sa ki nan dlo: tout sa ki gen zèl ak kal, sa yo ki nan dlo, nan lanmè oswa nan rivyè, nou kapab manje yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Men nenpòt sa ki nan lanmè oswa nan rivyè ki pa gen zèl avèk kal pami tout sa ki gen lavi nan dlo yo, yo se bagay abominab pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Konsa, yo va abominab pou nou. Nou pa pou manje chè yo, ak kadav yo. Nou va deteste yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nenpòt sa ki nan dlo ki pa gen zèl ak kal abominab pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“‘Sa yo, anplis, nou va deteste pami zwazo yo; yo abominab, yo pa pou manje: èg, òfrè, avèk èg lanmè, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","malfini, karanklou avèk tout espès li yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kòbo, avèk tout espès li yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","otrich avèk janmichèt, poul dlo, malfini avèk tout espès li yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","koukou, plonjon ak frize, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","gwo kana mawon blan, pelikan, chwèt, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","sigòy, krabye avèk tout espès li, chòchòt ak sèpantye. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“‘Tout ensèk avèk zèl ki mache sou kat pye abominab pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Sepandan, sa yo nou kapab manje yo pami ensèk ak zèl; sa ki mache sou kat pye yo, ki gen anlè pye kole ak janm ki sèvi pou sote sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Sa ladan yo, nou kapab manje: krikèt chan avèk tout espès li, krikèt voras avèk tout espès li yo, krikèt kay avèk tout espès li yo, e krikèt volan avèk tout espès li yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Men tout lòt ensèk a zèl ki gen kat pye abominab pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“‘Anplis, pa bagay sila yo, nou vin pa pwòp: nenpòt moun ki touche kadav yo vin pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Nenpòt moun ki ranmase kadav li yo va lave rad li e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“‘Tout zannimo avèk zago ki divize, men ki pa fann nèt, oswa ki pa remoute manje yo, yo pa pwòp pou nou. Nenpòt moun ki touche yo vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Nenpòt zannimo ki mache sou pat li; pami tout kreyati ki mache sou kat pat yo, yo pa pwòp pou nou. Nenpòt moun ki touche kadav li yo vin pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Sila ki ranmase kadav yo va lave rad yo, e yo va rete pa pwòp jis rive nan aswè. Yo pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“‘Men sa ki pa pwòp pou nou pami bagay ki trennen atè yo: zagoudi, sourit, gran leza ak tout espès li yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","zandolit, gwo kayiman, zandolit gongolo avèk kameleyon. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Sa yo pa pwòp pou nou pami sa ki trennen atè yo. Nenpòt moun ki touche yo lè yo mouri vin pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Nenpòt bagay sou li ke youn nan yo ta tonbe lè l mouri, bagay sa a va vin pa pwòp, enkli nenpòt bagay an bwa, vètman, po, yon sak—nenpòt bagay pou itilizasyon li fèt la—li va mete nan dlo, li va rete pa pwòp jis rive nan aswè, e apre sa li va vin pwòp ankò. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Osi, pou nenpòt veso ki fèt avèk ajil kote yon bèt ta tonbe; nenpòt bagay ki ladann va vin pa pwòp. Epi nou va kraze veso a. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nan nenpòt manje ki kapab manje, ki vin gen dlo sou li, sa vin pa pwòp, e nenpòt likid ke nou kapab bwè de li, nan tout veso, li va vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Anplis, tout bagay ladann yon pati nan kadav bèt la ta kapab tonbe, li vin pa pwòp; yon chodyè oswa yon fou va kraze an mòso. Yo pa pwòp e yo va kontinye rete pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Sepandan, yon sitèn oswa yon sous va rete pwòp, malgre ke sila ki touche kadav bèt yo va pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Si yon pati nan kadav yo vin tonbe sou nenpòt semans ki dwe plante, li toujou pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Men si dlo vin sou grenn semans lan, e yon pati nan kadav la tonbe sou li, li vin pa pwòp pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“‘Si youn nan bèt ki pwòp pou manje yo, vin mouri, moun ki touche kadav li a vin pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Sila a tou, ki manje kèk nan kadav li a va lave rad li, li va rete pa pwòp jis rive nan aswè. Anplis sila ki ranmase kadav li a va lave rad li, e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“‘Alò, tout bagay trennen ki trennen atè abominab, li pa pou manje. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Nenpòt bèt ki rale sou vant li, e nenpòt bèt ki mache sou kat pye, nenpòt bèt ki gen anpil pye, an rapò ak tout sa ki trennen atè, nou pa pou manje yo, paske yo abominab. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Pa rann tèt nou vin abominab pa okenn nan bagay ki trennen atè yo. Pa fè tèt nou pa pwòp avèk yo pou nou pa vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Paske Mwen se SENYÈ a, Bondye nou an. Konsa, se pou nou konsakre nou e rete sen, paske Mwen sen. Nou pa pou fè tèt nou pa pwòp avèk okenn bagay trennen, k ap trennen atè. ");
INSERT INTO hatbsa_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Paske Mwen se SENYÈ a ki te mennen nou sòti nan peyi Égypte pou M ta Bondye nou. Konsa nou va sen, paske Mwen sen.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“‘Sa se lalwa sou bèt ak zwazo, tout bagay vivan ki kouri nan dlo ak tout bagay ki trennen atè, ");
INSERT INTO hatbsa_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","pou fè yon distenksyon antre sa ki pa pwòp ak sa ki pwòp, e antre kreyati ki kab manje ak sa ki pa kab manje.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Pale avèk fis Israël yo. Di yo: ‘Lè yon fanm ansent e vin fè yon pitit gason, alò, li va pa pwòp pandan sèt jou. Tankou nan jou règ li yo, li va pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Nan uityèm jou a, chè ti pijon pitit gason an va vin sikonsi. ");
INSERT INTO hatbsa_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Alò, manman li va rete nan pirifikasyon san li pandan trann-twa jou. Li pa pou touche okenn bagay ki konsakre, ni antre nan sanktyè a jiskaske jou pirifikasyon li yo fin akonpli. ");
INSERT INTO hatbsa_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Men si li pote yon pitit fi, li va pa pwòp pandan de semèn, tankou nan lè règ li. Konsa, li va rete nan san pirifikasyon li an pandan swasann-si jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“‘Lè jou pirifikasyon li yo fin akonpli, pou yon fis, oswa yon fi, li va pote kote prèt la nan pòtay tant asanble a, yon jenn mouton sou laj en an kòm yon ofrann brile, ak yon jenn pijon oswa toutrèl kòm yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Prèt la, va ofri li devan SENYÈ a. Li va fè ekspiyasyon pou fi a, e konsa, li va netwaye de flo san li an. “‘Sa se lalwa pou sila ki pote pitit yo, kit li mal, kit li femèl. ");
INSERT INTO hatbsa_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Men si li pa gen mwayen achte yon jenn mouton, alò, li va pote de toutrèl, oswa de jenn pijon, youn pou ofrann brile a, e lòt la pou ofrann peche a. Konsa, prèt la va fè ekspiyasyon pou li e li va vin pwòp.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Alò, SENYÈ a te pale Moïse avèk Aaron. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Lè yon nonm vin gen sou po kò li yon enflamasyon, yon gal, oswa yon tach blanch, e li vin gen yon enfeksyon lalèp sou po kò li, alò, li va pote bay Aaron, prèt la, oswa yon prèt nan fis li yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Prèt la va gade bouton an sou po kò a. Si plim nan enfeksyon an vin blan, e enfeksyon an parèt pi fon ke po kò a, li se yon enfeksyon lalèp. Lè prèt la fin gade li, li va pwononse li pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Men si bouton blan an sou po kò a, men li pa parèt pi fon ke po a, epi plim sou li pa vin blan, alò, prèt la va izole li pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Prèt la va gade li nan setyèm jou a. Epi selon sa li wè, si enfeksyon an pa chanje, enfeksyon an pa gaye sou po a, alò, prèt la va fè l izole pandan sèt jou ankò. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Prèt la va gade li ankò nan setyèm jou a. Si enfeksyon an ap disparèt, e bouton an pa gaye sou po a, alò prèt la va pwoklame li pwòp. Se sèlman yon gal. Li va lave rad li; li va pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Men si gal la vin gaye plis sou po a apre li te fin vizite prèt la pou pirifikasyon li, li va parèt ankò devan prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Prèt la va gade, e si gal la vin gaye sou po a, alò prèt la va pwoklame li pa pwòp. Li se lalèp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Lè enfeksyon lalèp la sou yon moun, alò, li va vin mennen bay prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Prèt la va gade l. Si gen yon enflamasyon blan sou po a, li fè plim li vin blan, e gen maleng nan enflamasyon an, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","sa se yon lalèp kwonik sou po kò li. Prèt la va pwoklame li pa pwòp. Li p ap izole li ankò, paske li deja pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Si lalèp la vin gaye plis sou po a, e lalèp la kouvri tout po de sila ki gen enfeksyon an soti nan tèt li, jis rive nan pye li, toupatou kote prèt la kab wè, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","alò, prèt la va gade, e veye byen, si lalèp la vin kouvri tout kò li, li va pwoklame li pwòp. Li te vin blanch nèt, e koulye a, li vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Men nenpòt maleng ki vin parèt sou li, li va vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Prèt la va gade maleng lan, e li va pwoklame li pa pwòp. Maleng lan pa pwòp, se lalèp li ye. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Oswa, si maleng lan chanje ankò vin tou blanch, alò, li va vini kote prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Konsa, prèt la va gade li, e veye byen, si enfeksyon an te vin tou blanch, alò prèt la va pwoklame li pwòp de enfeksyon an. Li pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Si kò a gen yon abse sou po a, e li vin geri, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","epi nan plas abse a, li vin gen yon enflamasyon tou blanch oswa yon tach blanch e wouj fonse, byen vif, li va montre l a prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Prèt la va gade li, e veye byen, si li vin parèt pi fonse ke po a, e plim sou li a vin tou blanch, alò prèt la va pwoklame li pa pwòp. Sa se enfeksyon lalèp, li vin parèt nan abse a. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Men si prèt la gade li, e veye byen, li pa gen plim blanch ladann, li pa pi fon ke po a, e l ap vin disparèt, alò, prèt la va izole li pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si li gaye plis sou po a, alò, prèt la va pwoklame li pa pwòp. Se yon enfeksyon li ye. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Men si tach vif la rete nan plas li, e li pa gaye, se sèlman sikatris abse a. Konsa, prèt la va pwoklame li pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Oubyen, si kò a vin brile nan dife, e maleng brile a vin yon mak vif, blan wouj fonse, oswa blan, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","alò, prèt la va gade li. Epi si plim nan mak vif la vin tou blanch e parèt pi fonse ke chè a, sa se lalèp. Li vin parèt nan kote ki brile a. Konsa, prèt la va pwoklame li pa pwòp. Sa se yon enfeksyon lalèp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Men si prèt la gade li, e vrèman, pa gen plim blan nan mak vif la e li pa pi fon ke po a, men li vin pal; alò, prèt la va izole li pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Epi prèt la va gade li nan setyèm jou a. Si li gaye plis sou po a, alò, prèt la va pwoklame li pa pwòp.Sa se yon enfeksyon lalèp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Men si mak vif la toujou rete nan plas li, e li pa gaye nan po a, men li vin pal, sa se sèlman enflamasyon ki soti nan brile a, epi prèt la va pwoklame li pwòp, paske se sèlman sikatris brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Alò, si yon nonm oswa yon fanm gen yon enfeksyon nan tèt oswa nan bab, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","alò, prèt la va gade enfeksyon an. Si li parèt pi fonse pase po a e li vin gen yon ti plim avèk yon koulè jon, alò prèt la va pwoklame li pa pwòp. Li se yon kal. Sa se lalèp nan tèt oubyen nan bab. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Men si prèt la gade enfeksyon kal la, e vrèman, li parèt pi fonse ke po a, e nanpwen plim nwa ladann, alò, prèt la va izole moun avèk enfeksyon kal la pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Nan setyèm jou a, prèt la va gade enfeksyon an; epi si kal la pa gaye pi lwen, li pa gen ti plim jòn ki grandi ladann, e li pa sanble ke kal la pi fonse ke po a, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","answit, li va pase razwa sou li, men pa sou kal la; epi prèt la va izole moun avèk kal la pandan sèt jou anplis. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Answit, nan setyèm jou a, prèt la va gade kal la, si kal la pa gaye nan po a, e li pa parèt pi fonse ke po a, prèt la va pwoklame li pwòp. Li va lave rad li, e li va vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Men si kal la vin gaye plis sou po a apre pirifikasyon li, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","alò, prèt la va gade li, e si kal la ap gaye nan po a, prèt la pa bezwen chèche plim jòn nan. Li pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Si nan zye li, kal la rete, malgre sa, plim nwa yo vin grandi ladann, kal la vin geri, li pwòp. Konsa, prèt la va pwoklame li pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Lè yon nonm oswa yon fanm gen mak vif sou po kò a, menm mak tou blanch, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","alò prèt la va gade, e si mak vif sou po kò yo se blan pal, se sèlman ekzema ki parèt sou po a. Li pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Alò, si yon nonm pèdi cheve nan tèt li, li vin chòv. Li pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Si tèt li vin kale pa devan e sou kote, li chòv pa devan. Li pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Men si nan tèt chòv la oswa nan fwontèn chòv la, vin rete yon enfeksyon koulè blan— wouj fonse, sa se lalèp k ap parèt sou tèt chòv li oswa fwontèn chòv li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Answit, prèt la va gade li. Konsa, si enflamasyon enfeksyon an blan-wouj fonse sou tèt chòv oswa sou fwontèn chòv li, tankou aparans lalèp sou po kò a, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","li se yon moun lalèp. Li pa pwòp. Prèt la va vrèman pwoklame li pa pwòp. Enfeksyon li sou tèt li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Pou moun lalèp ki gen enfeksyon an, fòk li mete rad chire, e lese cheve nan tèt li san penyen. Li va kouvri moustach li e kriye: ‘Pa pwòp, pa pwòp.’ ");
INSERT INTO hatbsa_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Li va rete pa pwòp pandan tout jou ke enfeksyon an dire yo. Li pa pwòp. Li va abite izole pou kont li. Li gen pou rete deyò kan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Lè yon vètman vin gen lalèp kanni, kit se twal len nèt kit se twal len fen, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","kit li tise, kit li trikote avèk len nèt oswa avèk len fen, kit se an kwi oswa an okenn bagay ki fèt an kwi, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","si mak la tou vèt oswa wouj nan vètman an, kit se an kwi, oswa an tise ou trikote, oswa an okenn bagay an kwi, li se yon mak lalèp kanni, e fòk li vin montre bay prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Alò, prèt la va gade mak la e li va izole bagay avèk mak la pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Konsa, li va gade mak la nan setyèm jou a. Si mak la vin gaye sou rad la nan tise a, oswa trikote a, oswa an kwi oubyen nenpòt bagay ke kwi a sèvi, mak la se lalèp kanni, e li se yon maleng. Li pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Pou sa, li va brile rad la, kit an tise, oswa an trikote, oswa an len nèt, an len fen, oubyen nenpòt bagay an kwi kote mak la parèt, paske li se lalèp kanni maleng. Li va brile nan dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Men si prèt la ta gade, e vrèman, mak la pa gaye nan vètman an, ni nan tise a, ni nan trikote a, ni nan bagay an kwi a, ");
INSERT INTO hatbsa_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","alò, prèt la va pase lòd pou lave bagay ki te gen mak la e li va vin izole li pandan sèt jou anplis. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Lè bagay la avèk mak la fin lave, prèt la va gade ankò, e si mak la pa chanje aparans li, malgre mak la pa gaye, li pa pwòp. Nou va brile li nan dife, menm si li epwize pa anwo oswa pa devan li. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Alò, si prèt la gade e mak la vin mwens, li va chire e retire li nan vètman an, oswa an kwi a, kit se nan tise, kit se nan trikote a; ");
INSERT INTO hatbsa_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","epi si li parèt ankò nan vètman an, kit se nan tise a, oswa nan trikote a, oswa nan nenpòt bagay ki fèt an kwi, sa se yon epidemi lalèp kanni. Bagay la avèk mak la va brile nan dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Vètman an, kit se nan tise, oswa nan trikote, oswa nan nenpòt bagay ki fèt an kwi kote mak la te sòti lè nou te lave li a, li va konsa lave yon dezyèm fwa e li va vin pwòp.” ");
INSERT INTO hatbsa_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Sa se lalwa pou mak lalèp kanni nan yon vètman an len nèt, oswa len fen, oswa an tise, oswa an trikote, oswa an nenpòt bagay ki fèt an kwi, pou pwoklame li pwòp oswa pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Sa va lalwa pou moun lalèp la nan jou pirifikasyon li. Alò, li va vin mennen devan prèt la, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","epi prèt la va ale deyò kan an. Konsa prèt la va gade, e si enfeksyon lalèp la te geri nan moun lalèp la, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","alò, prèt la va bay lòd pou pran de zwazo pwòp avèk bwa sèd, fisèl wouj avèk izòp pou sila ki va vin pirifye a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Prèt la va osi bay lòd pou touye youn nan zwazo yo nan yon veso fèt an tè sou yon dlo k ap koule. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Epi pou zwazo vivan an, li va pran li ansanm avèk bwa sèd yo, fisèl wouj la, ak izòp, e li va fonse yo avèk zwazo vivan an nan san zwazo ki te touye sou dlo k ap koule a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Epi li va flite sèt fwa sou sila ki gen lalèp pou pirifye a, e li va pwoklame li pwòp. Konsa, li va kite zwazo vivan an vole lib sou yon chan byen louvri. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Alò, sila k ap pirifye a va lave rad li yo. Li va raze tout cheve li, e li va lave nan dlo pou vin pwòp. Apre tout sa a, li mèt antre nan kan an, men li va rete deyò tant li an pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Li va nan setyèm jou a pase razwa nan tout cheve li. Li va taye tèt li, bab li, sousi li, e menm tout cheve li. Alò, li va lave rad li yo e benyen kò l nan dlo. Konsa, li vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Alò, nan uityèm jou a, li gen pou pran de jenn mouton mal san defo, yon jenn mouton femèl laj en nan san defo, twa dizyèm nan yon efa farin fen mele avèk lwil pou yon ofrann sereyal, ak yon boutèy demi lit lwil. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Epi prèt la ki pwoklame li pwòp la va prezante nonm kap vin pirifye a, ak bagay sa yo, devan pòtay Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Alò, prèt la va pran youn nan jenn mouton mal yo. Li va mennen li pou yon ofrann koupab avèk boutèy demi lit lwil la, e li va prezante li kòm yon ofrann voye anlè devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Answit, li va touye jenn mouton an nan plas kote yo touye ofrann peche a ak ofrann brile a, nan plas kote sanktyè a—pou ofrann koupab la, tankou ofrann peche a, apatyen a prèt la. Li sen pase yo tout. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Alò, prèt la va pran kèk nan san ofrann koupab la, e prèt la va mete li sou tèt zòrèy dwat a sila k ap vin pirifye a, sou pous men dwat ak sou gwo zòtèy pye dwat li. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Prèt la va osi pran kèk nan boutèy demi lit lwil la, e li va vide li nan pla men goch li. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Alò, prèt la va fonse dwèt men dwat li nan lwil ki nan pla men goch la, e avèk dwèt li, li va flite kèk nan lwil la sèt fwa devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Nan lwil ki rete nan pla men l lan, prèt la va mete kèk sou tèt zòrèy dwat a sila k ap vin pirifye a, sou pous a men dwat li ak sou gwo zòtèy a pye dwat li, sou san a ofrann koupab la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Epi rès lwil ki nan pla men prèt la, li va mete li sou tèt a sila k ap vin pirifye a. Epi prèt la va fè ekspiyasyon pou li devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Apre sa, prèt la va ofri ofrann peche a, e li va fè ekspiyasyon pou sila k ap vin pirifye de kondisyon pa pwòp li a. Alò, apre, li va touye ofrann brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Prèt la va ofri ofrann brile a ak ofrann sereyal la sou lotèl la. Konsa prèt la va fè ekspiyasyon pou li, e li va vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Men si se yon malere li ye, e mwayen li pa sifi, alò li va pran yon jenn mouton mal tankou ofrann koupab la, tankou yon ofrann voye anlè pou fè ekspiyasyon pou li, e yon dizyèm efa farin fen mele avèk lwil kòm yon ofrann sereyal ak yon boutèy demi lit lwil; ");
INSERT INTO hatbsa_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","epi de toutrèl oswa de pijon, sa ki posib selon mwayen li; youn va ofrann peche a, e lòt la va ofrann brile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Konsa, nan uityèm jou a, li va mennen yo pou pirifikasyon li bay prèt la, nan pòtay tant asanble a, devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Prèt la va pran jenn mouton ofrann koupab la, ak boutèy demi lit lwil la, e prèt la va ofri yo kòm yon ofrann voye anlè devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Apre sa, li va touye jenn mouton ofrann peche a. Epi prèt la va pran kèk nan san ofrann koupab la pou mete sou tèt zòrèy dwat a sila k ap vin pirifye a, sou pous men dwat li ak sou gwo zòtèy pye dwat li. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Prèt la va osi vide kèk nan lwil la nan pla men goch li; ");
INSERT INTO hatbsa_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","epi avèk dwèt men dwat li, li va flite kèk nan lwil ki nan pla men goch la sèt fwa devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Apre sa, prèt la va mete kèk nan lwil ki nan pla men an sou tèt zòrèy dwat a sila k ap vin pirifye a, sou pous men dwat li, sou gwo zòtèy pye dwat li, sou plas san a ofrann koupab la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Anplis, rès lwil ki nan pla men prèt la, li va mete li sou tèt a sila k ap vin pirifye a, pou fè ekspiyasyon pou li devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Li va, alò, ofri youn nan toutrèl oswa nan pijon yo, selon kapasite li. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Sa li kapab selon mwayen li, youn pou yon ofrann peche, e lòt la pou yon ofrann brile, ansanm avèk ofrann sereyal la. Konsa prèt la va fè ekspiyasyon devan SENYÈ a pou sila k ap vin pirifye a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Sa se lalwa pou sila ki gen yon enfeksyon lalèp, ki gen mwayen limite pou pirifikasyon li. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","SENYÈ a te pale ankò ak Moïse avèk Aaron e te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Lè nou antre nan peyi Canaan an, ke Mwen bannou pou posesyon an, e Mwen mete yon mak lalèp kanni sou yon kay nan peyi posesyon pa nou an, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","alò, sila ki mèt kay la va vin di prèt la konsa, ‘Mwen wè yon bagay tankou yon mak lalèp kanni ki te vin parèt nan kay la.’ ");
INSERT INTO hatbsa_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Alò, prèt la va pase lòd pou yo mete kay la vid avan prèt la antre pou gade mak la, jis pou tout bagay nan kay la pa oblije vin pa pwòp. Apre, prèt la va antre pou gade kay la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Alò, li va gade mak la, e si mak sou mi kay la fonse avèk koulè tankou vèt oswa wouj ki fonse plis ke sifas la, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","alò, prèt la va sòti nan kay la pou rive nan pòtay la, e li va fèmen kay la pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Prèt la va retounen nan setyèm jou a, e li va pase fè enspeksyon. Si mak la te vrèman agrandi nan mi kay la, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","alò, prèt la va pase lòd pou yo chire retire wòch ki gen mak ladan yo a, pou jete yo deyò nan yon plas ki pa pwòp deyò lavil la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Li va fè yo grate kay la tout anndan, e yo va jete tout vye kras mòtye deyò nan yon plas deyò lavil la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Alò, yo va retire lòt wòch ki kontamine yo pou ranplase yo, e li va pran mòtye nèf pou fè randisaj kay la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Si, alò, mak la vin parèt ankò nan kay la apre li fin retire wòch yo, grate kay la, e apre li fin fè randisaj nèf la, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","alò, prèt la va vin antre pou fè yon enspeksyon. Si li wè ke mak la vrèman vin gaye nan kay la ankò, sa se yon mak maleng ki nan kay la. Li pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Pou sa, li va kraze kay la nèt, avèk wòch li yo, bwa li yo, ak tout ansyen randisaj li. Li va mete yo deyò lavil la nan yon kote ki pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Anplis, nenpòt moun ki antre nan kay la pandan li te izole a, li va vin pa pwòp pou jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Menm jan an, nenpòt moun ki kouche nan kay la, li va lave rad li, e nenpòt moun ki manje nan kay la, li va lave rad li. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Si, yon lòt kote, prèt la antre pou fè yon enspeksyon, e mak la pa vrèman gaye nan kay la apre kay la pase randisaj nèf la, alò, prèt la va pwoklame kay la pwòp akoz ke mak la pa parèt ankò. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Alò, pou netwaye kay la, li va pran de zwazo avèk bout bwa sèd, avèk yon fisèl wouj, ak izòp, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","epi li va touye youn nan zwazo yo nan yon veso fèt ak tè anwo dlo fwe. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Alò li va pran bout bwa sèd yo avèk izòp ak fisèl wouj la, avèk zwazo vivan an, e li va fonse yo nan san zwazo ki mouri an, e osi nan dlo fwe a, epi li va flite kay la sèt fwa. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Konsa li va netwaye kay la avèk san zwazo a e avèk dlo fwe a, ansanm avèk zwazo vivan an, avèk bout bwa sèd yo, avèk izòp e avèk fisèl wouj la. ");
INSERT INTO hatbsa_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Men li va kite zwazo vivan an vin lage pou l lib deyò lavil la nan yon chan byen laj. Konsa li va fè ekspiyasyon pou kay la, e kay la va vin pwòp.” ");
INSERT INTO hatbsa_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Sa se lalwa pou nenpòt mak lalèp kanni— menm pou yon kal ");
INSERT INTO hatbsa_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","epi pou yon rad oswa yon kay avèk lalèp kanni, ");
INSERT INTO hatbsa_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","epi pou yon enflamasyon, pou yon kal sou po li, ak yon kote ki klere blan— ");
INSERT INTO hatbsa_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","pou enstwi yo lè yo pa pwòp ak lè yo pwòp. Sa se lalwa lalèp la. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","SENYÈ a osi te pale avèk Moïse avèk Aaron. Li te di yo: ");
INSERT INTO hatbsa_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Pale avèk fis Israël yo. Di yo: ‘Lè yon moun vin gen yon ekoulman nan kò li, ekoulman li an pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Sila a, anplis, dwe pa pwòp nan ekoulman li an; li pa pwòp, menm si kò li kite ekoulman an koule, oswa li anpeche ekoulman an koule. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“‘Tout kabann kote moun avèk ekoulman an kouche a va vin pa pwòp; e lè l chita sou nenpòt bagay, bagay sa a va vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Nenpòt moun, anplis, ki touche kabann sa a va lave rad li, benyen nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Nenpòt moun ki chita sou bagay kote nonm avèk ekoulman an te chita a, li va lave rad li, benyen nan dlo, e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“‘Osi, nenpòt moun ki touche moun avèk ekoulman an, li va lave rad li, li va benyen nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“‘Oswa, si gason avèk ekoulman an krache sou yon moun ki pwòp, li osi va lave rad li, li va benyen nan dlo, e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“‘Si moun avèk ekoulman an chita sou nenpòt sèl cheval oswa bèt, li va vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Nenpòt moun ki touche nenpòt nan bagay ki te anba li va pa pwòp jis rive nan aswè, e sila ki pote yo a, va lave rad li, li va benyen avèk dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“‘Menm jan an, nenpòt moun ke moun ekoulman an touche san ke li pa lave men l nan dlo, li va lave rad li, li va benyen nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“‘Veso tè a ke moun nan te touche a, va kraze, e tout veso an bwa yo, va lave nan dlo. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Alò, depi yon moun avèk yon ekoulman vin pwòp e kite ekoulman li an, alò, li va kontwole pou li menm sèt jou pou pirifikasyon li. Li va lave rad li, li va benyen kò li nan dlo k ap koule, e li va vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Alò, nan uityèm jou a, li va pran pou li menm de toutrèl oswa de jenn pijon, e vini devan SENYÈ a nan pòtay tant asanble a, pou bay yo a prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Prèt la va ofri yo, youn pou yon ofrann peche, e lòt la pou yon ofrann brile. Konsa, prèt la va fè ekspiyasyon pou li devan SENYÈ a akoz ekoulman li an. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“‘Alò, si yon gason ejakile, li va benyen tout kò li nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Nenpòt vètman oswa kwi ki gen spèm, li va lave avèk dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Si yon nonm kouche avèk yon fanm e li ejakile, yo va tou de va benyen nan dlo, e yo va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“‘Lè yon fanm gen yon ekoulman, si ekoulman nan kò li a se san, li va kontinye rete enpi avèk règ li a jis rive sèt jou. Konsa, nenpòt moun ki touche li va pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“‘Anplis, nenpòt kote li kouche pandan règ li a va vin pa pwòp, e nenpòt bagay kote li vin chita va pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Nenpòt moun ki touche kabann li va lave rad li. Li va benyen nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nenpòt moun ki touche nenpòt bagay kote li chita va lave rad li. Li va benyen nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kit se sou kabann nan oswa sou bagay kote li chita, lè li touche li, li va pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“‘Si yon gason vin kouche avèk li pou san an vin sou li, gason an va pa pwòp pandan sèt jou, e tout kabann kote li kouche a va vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“‘Alò si yon fanm gen yon ekoulman san pandan anpil jou, pa sèlman nan tan règ la, oswa si li gen yon ekoulman anplis fwa sa a, li va kontinye aji kòmsi li gen règ. Li pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Nenpòt kabann kote li touche pandan tout jou ekoulman li yo, li va pou li tankou kabann li pandan règ la. Chak bagay kote li chita va vin pa pwòp, tankou pa pwòp a li menm nan tan sa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Menm jan an, nenpòt moun ki touche yo va vin pa pwòp. Li va lave rad yo, li va benyen nan dlo e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“‘Lè li vin pwòp de ekoulman li an, li va kontwole pou kont li sèt jou. Apre sa a, li va vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Alò, nan uityèm jou a, li va pran pou li menm de toutrèl oswa de jenn pijon e li va mennen yo devan prèt la nan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Prèt la va ofri youn kòm yon ofrann peche, e lòt la kòm yon ofrann brile. Konsa, prèt la va fè ekspiyasyon pou li menm devan SENYÈ a akoz ekoulman enpi a. ");
INSERT INTO hatbsa_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“‘Konsa, nou va kenbe fis Israël yo apa de pa pwòp yo, pou yo pa mouri akoz salte ki ta konwonpi tabènak Mwen ki pami yo a.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Sa se lalwa pou sila ki gen ekoulman an, ak pou gason ki gen yon ejakilasyon spèm ki fè l vin pa pwòp la, ");
INSERT INTO hatbsa_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","epi pou yon fanm ki malad akoz règ ki pa pwòp li a, ak pou sila ki gen ekoulman an, kit li mal kit li femèl, oswa yon nonm ki kouche avèk yon fanm ki pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Alò, SENYÈ a te pale avèk Moïse apre lanmò fis Aaron yo, lè yo te pwoche prezans SENYÈ a e yo te mouri an. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","SENYÈ a te di a Moïse: “Di frè ou a, Aaron, ke li pa pou antre nan nenpòt lè nan lye sen an anndan vwal la, devan twòn ekspiyatwa a ki sou lach la, oswa li va mouri; paske Mwen va parèt nan nwaj la sou twòn pwopiyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aaron va antre nan lye sen an avèk yon towo pou yon ofrann peche ak yon belye pou yon ofrann brile. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Li va mete sou li tinik sen an. Li va mete sou li pantalon fèt an len yo, ak sou-vètman an len ki va toupre kò li a, epi li va mare senti li an len, e li va abiye avèk tiban len an. Sa yo se vètman sen yo. Li va benyen kò li nan dlo, e li va vin abiye ak yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Li va pran soti nan asanble Israël la de mal kabrit kòm yon ofrann peche ak yon belye kòm yon ofrann brile. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Konsa, Aaron va ofri towo a kòm ofrann peche ki pou li menm nan, pou li kapab fè ekspiyasyon pou li menm ak pou tout lakay li. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Li va pran de kabrit yo, e li va prezante yo devan SENYÈ a nan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron va fè tiraj osò pou de kabrit sa yo, yon osò pou SENYÈ a, e lòt osò a pou kabrit ekspiyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Alò, Aaron va ofri kabrit la sou sila osò SENYÈ a tonbe a, e fè li vin yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Men kabrit la sou sila osò kabrit ekspiyatwa a vin tonbe a, li va vin prezante vivan devan SENYÈ a, pou fè ekspiyasyon sou li, e pou voye li nan dezè a kòm kabrit ekspiyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Alò Aaron va ofri towo ofrann peche ki pou li menm nan, li va fè ekspiyasyon pou li menm ak pou tout lakay li, e li va touye towo ofrann peche ki pou li menm nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Li va pran yon plato pou resevwa san ki ranpli avèk chabon cho ki sòti sou lotèl la devan SENYÈ a, de men plen avèk lansan dous moulen byen fen, e mennen li anndan vwal la. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Li va mete lansan an sou dife a devan SENYÈ a, pou nwaj lafimen lansan an kapab kouvri twòn ekspiyatwa ki sou lach temwayaj la; otreman, li va mouri. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Anplis, li va pran kèk nan san towo a e li va flite li avèk dwèt li sou twòn pwopiyatwa sou kote lès la; anplis, pa devan nan twòn pwopiyatwa a, li va flite kèk nan san an avèk dwèt li sèt fwa. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Epi li va touye kabrit ofrann peche ki pou pèp la. Li va mennen san li anndan vwal la, e li va fè avèk san li jan li te fè avèk san towo a. Li va flite li sou twòn pwopiyatwa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Li va fè ekspiyasyon pou lye sen an akoz salte fis Israël yo, akoz transgresyon pa yo avèk tout peche yo. Konsa, li va fè pou tant asanble ki rete avèk yo nan mitan tout salte pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Lè li antre pou fè ekspiyasyon nan lye sen an, pèsòn pa pou nan tant asanble a jiskaske li sòti, pou li kapab fè ekspyasyon an pou li menm, pou lakay li, ak pou tout asanble Israël la. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Konsa, li va ale deyò vè lotèl ki devan SENYÈ a pou fè ekspiyasyon pou li. Li va pran kèk nan san towo a, san kabrit la pou mete li sou kòn yo sou tout kote nan lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Avèk dwèt li, li va flite kèk nan san an sou li sèt fwa pou fè l vin pwòp, soti nan salte a fis Israël yo, e konsakre li. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Lè li fin fè ekspiyasyon pou lye sen an, tant asanble a, ak lotèl la, li va ofri kabrit vivan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Alò, Aaron va poze de men li sou tèt kabrit vivan an, e li va konfese sou li tout inikite a fis Israël yo, tout transgresyon pa yo selon tout peche yo. Li va poze yo sou tèt kabrit la e li va voye li nan dezè a pa men yon moun ki prepare pou sa. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kabrit la va pote sou li menm tout inikite pa yo pou rive nan yon peyi izole. Li va lage kabrit la nan dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Epi Aaron va vini nan tant asanble a pou retire vètman len ke li te mete lè li te antre nan lye sen an, e li va kite yo la. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Li va benyen kò li avèk dlo nan yon lye sen. Li va mete vètman li yo pou vin parèt e ofri ofrann brile pa li avèk ofrann brile ki pou pèp la, epi pou fè ekspiyasyon pou li menm ak pou pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Li va ofri nan lafimen grès ofrann peche a sou lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Sila ki te lage kabrit la kòm kabrit ekspiyasyon an, gen pou lave rad li, e benyen kò li avèk dlo. Alò apre, li va antre nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Men towo ofrann peche a ak kabrit ofrann peche a, san sila li te mennen antre pou fè ekspiyasyon nan lye sen an, va vin pote deyò lavil la. Li va brile po yo, chè yo, avèk poupou yo nan dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Epi sila ki brile yo a, va lave rad li, benyen kò l nan dlo, e apre, li va vin antre nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Sa va yon règleman pou tout tan pou nou: nan setyèm mwa a, nan dizyèm jou nan mwa a, nou va imilye nanm nou. Nou p ap fè okenn travay, ni pou moun peyi a, ni pou etranje ki demere pami nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Paske se nan jou sa a ke ekspiyasyon an va fèt pou nou pou fè nou vin pwòp. Nou va netwaye de tout peche nou yo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Se va yon Saba repo solanèl pou nou, pou nou kapab vin imilye nanm nou. Sa se yon règleman ki pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Alò prèt ki onksyone e òdone pou sèvi kòm prèt nan plas papa li a va fè ekspiyasyon an. Li va abiye ak vètman len yo, vètman sen yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Konsa, li va fè ekspiyasyon pou sanktyè sen an, e li va fè ekspiyasyon pou tant asanble a ak pou lotèl la. Li va osi fè ekspiyasyon pou prèt yo ak pou tout pèp asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Alò, nou va gen sa kòm yon règleman pou tout tan, pou fè ekspiyasyon pou fis Israël yo pou tout peche pa yo, yon fwa chak ane.” Epi jan ke SENYÈ a te kòmande Moïse la, konsa sa te fèt. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Pale avèk Aaron, avèk fis li yo e ak tout fis Israël yo. Di yo: ‘Se sa ke SENYÈ a te kòmande e te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","“Nenpòt moun ki sòti lakay Israël ki touye yon bèf oswa yon jenn mouton, oswa yon kabrit nan kan an, oswa touye li deyò kan an, ");
INSERT INTO hatbsa_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","epi ki pa t pote li nan pòtay tant asanble a pou prezante li kòm yon ofrann a SENYÈ a devan tabènak SENYÈ a, koupabilite vèse san an va kontwole sou moun sila a. Li te vèse san e moun sa a va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Rezon pou sa a se pou pèmèt fis Israël yo pote sakrifis ke y ap fè nan gran chan yo, pou yo kapab pote yo antre vè SENYÈ a, nan pòtay tant asanble a vè prèt la, e pou fè sakrifis yo kòm sakrifis ofrann lapè bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Prèt la va flite san an sou lotèl SENYÈ a nan pòtay tant asanble a, e li va ofri grès la nan lafimen kòm yon bagay santi bon bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Yo p ap fè sakrifis yo ankò bay kabrit a zidòl demon avèk sila yo fè jwèt pwostitisyon yo. Sa se yon règleman pou tout jenerasyon pa yo.”’” ");
INSERT INTO hatbsa_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Epi ou va di yo: ‘Nenpòt moun lakay Israël la, oswa etranje ki rete pami nou yo, ki ofri yon ofrann brile oswa yon sakrifis, ");
INSERT INTO hatbsa_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","epi ki pa mennen li nan pòtay tant asanble a pou ofri li bay SENYÈ a, moun sila a osi va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“‘Epi nenpòt moun lakay Israël la, oswa etranje ki rete pami yo, ki bwè nenpòt san, Mwen va mete figi Mwen kont moun sa a ki bwè san an, e li va koupe retire de pèp li a.’ ");
INSERT INTO hatbsa_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Paske vi a chè a se nan san an, e Mwen te bannou li sou lotèl la pou fè ekspiyasyon pou nanm nou; paske se san li ye, akoz lavi ki fè ekspiyasyon an. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Pou sa, Mwen te di a fis Israël yo: ‘Pèsòn pami nou pa pou bwè san, ni okenn etranje ki rete pami nou p ap kab bwè san.’ ");
INSERT INTO hatbsa_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“Pou sa, lè yon moun pami fis Israël yo oswa nan etranje ki rete pami yo, ki nan fè lachas kenbe yon bèt oswa yon zwazo ki kapab manje, li va vide san li e kouvri li avèk tè. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Paske lavi tout chè, se san li ki lavi li. Pou sa, Mwen te di a fis Israël yo: “Nou pa pou bwè san de okenn nan chè yo, paske lavi tout chè se san li. Nenpòt moun ki bwè li, va koupe retire. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Lè yon moun manje yon bèt ki mouri oswa ki chire pa lòt bèt kit li se yon moun peyi a, oswa yon etranje, li va lave rad li, li va benyen nan dlo, e li va rete pa pwòp jis rive nan aswè. Konsa, li va vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Men si li pa lave oswa benyen kò li, li va pote koupabilite li.” ");
INSERT INTO hatbsa_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Pale avèk fis Israël yo. Di yo: ‘Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Pinga nou fè sa ki te fèt nan peyi Égypte kote nou te rete a, ni pinga nou fè sa ki fèt nan peyi Canaan kote Mwen ap mennen nou an. Pinga nou mache nan règleman pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Se pou nou aji selon jijman pa M e kenbe règleman pa M, pou mache nan yo. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Konsa nou va kenbe règleman Mwen yo, ak jijman Mwen yo, pa sila yon nonm kapab viv si li fè yo. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“‘Pinga okenn nan nou pwoche okenn fanmi de san nou pou dekouvri nidite li: Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“‘Nou pa pou dekouvri nidite papa nou, ni nidite a manman nou. Li se manman nou; nou pa pou dekouvri nidite li. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“‘Nou pa pou dekouvri nidite madanm papa nou. Li se nidite a papa nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“‘Nidite a sè nou, oswa fi papa nou, oswa fi manman nou, kit li fèt nan kay la, kit li fèt deyò; nidite pa yo, nou pa pou dekouvri yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“‘Nidite fi a fis nou, oswa fi a fi nou; nidite yo, nou pa pou dekouvri yo; paske nidite pa yo se pa nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“‘Nidite a pitit fi madanm a papa nou, fèt pou papa nou, li se sè nou, nou pa pou dekouvri nidite li. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“‘Nou pa pou dekouvri nidite sè papa nou. Li se pwòp relasyon san papa nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“‘Nou pa pou dekouvri nidite sè manman nou, paske li se pwòp san manman nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“‘Nou pa pou dekouvri nidite frè papa nou. Nou pa pou pwoche madanm li. Li se matant nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“‘Nou pa pou dekouvri nidite bèlfi nou. Li se madanm a fis nou. Nou pa pou dekouvri nidite li. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“‘Nou pa pou dekouvri nidite madanm frè nou. Li se nidite a frè nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“‘Nou pa pou dekouvri nidite a yon fanm avèk fi li. Ni nou pa pou pran fi a fis li, ni fi a fi li, pou dekouvri nidite li. Yo se relasyon san. Sa vrèman lèd. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“‘Nou pa pou marye yon fanm ansanm avèk sè li pou fè jalouzi pandan sè li toujou vivan an, pou dekouvri nidite li. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“‘Osi nou pa pou pwoche yon fanm pou dekouvri nidite li pandan règ li fè l pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“‘Nou pa pou fè zak seksyèl avèk madanm vwazen nou pou nou ta vin konwonpi ansanm avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“‘Nou pa pou bay okenn nan pitit nou yo pou ofri bay Moloc. Nou pa pou degrade non Bondye. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“‘Nou pa pou kouche avèk yon gason jan yon moun ta kouche avèk yon fanm. Li se yon abominasyon. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“‘Osi, nou pa pou fè zak seksyèl avèk okenn bèt pou nou ta vin degrade avèk li. Ni okenn fanm pa pou kanpe devan yon bèt pou kwaze avèk li. Sa se yon pèvèsyon. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“‘Pa konwonpi tèt nou avèk okenn nan bagay sa yo; paske, se pou tout bagay sa yo, nasyon ke Mwen ap mete deyò devan nou yo, te vin konwonpi. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Paske peyi a gen tan vin konwonpi. Pou sa, Mwen te fè pinisyon li rive sou li, jiskaske peyi a vin krache moun ki rete la yo, mete yo deyò. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Men pou nou, se pou nou kenbe règleman Mwen yo, jijman Mwen yo, e pa fè okenn nan abominasyon sa yo, ni moun peyi a, ni etranje ki viv pami nou yo ");
INSERT INTO hatbsa_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(paske moun peyi a ki te devan nou yo, te fè tout abominasyon sa yo, e peyi a te vin konwonpi); ");
INSERT INTO hatbsa_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","pou peyi a pa krache mete nou deyò, si nou ta vin konwonpi li, tankou li te krache mete deyò nasyon ki te devan nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“‘Paske nenpòt moun ki fè okenn nan abominasyon sa yo, moun sa yo va vin koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Konsa, se pou nou kenbe lòd Mwen, pou nou pa pratike okenn nan abitid abominab ki te konn fèt avan nou yo, pou nou pa konwonpi tèt nou avèk yo. Mwen se SENYÈ a, Bondye Nou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Alò, SENYÈ a te pale ak Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Pale avèk tout asanble a fis Israël yo. Di yo: ‘Nou va sen, paske Mwen menm, SENYÈ a, Bondye nou an, Mwen sen. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“‘Nou chak va onore manman nou ak papa nou, e nou va kenbe Saba Mwen yo. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“‘Pa vire vè zidòl yo, ni fè pou nou menm dye metal fonn yo. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“‘Alò, lè nou ofri yon sakrifis lapè bay SENYÈ a, nou va ofri li pou nou kapab vin aksepte. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Li va manje nan menm jou ke nou ofri li a, ak jou apre a. Si gen ki rete jis nan twazyèm jou a, li va vin brile avèk dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Konsa, si li ta manje menm nan twazyèm jou a, sa se yon ofans. Li p ap aksepte. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Tout sila ki manje li yo, va pote inikite li, paske li te degrade bagay sen SENYÈ a. Konsa, moun sa a va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“‘Alò, lè nou fè rekòlt nan tè nou, nou p ap rekòlte rive jis nan kwen chan an, ni nou p ap ranmase ti rès ki tonbe a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ni nou p ap ranmase ti rès fwi nan chan rezen nou yo. Nou va kite yo pou malere yo ak etranje yo. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“‘Nou pa pou vòlè, ni twonpe, ni manti youn ak lòt. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“‘Nou pa pou fè fo sèman nan non Mwen pou degrade non a Bondye nou an. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“‘Nou pa pou oprime vwazen nou, ni vòlè li. Salè a yon ouvriye jounalye pa pou rete nan men nou tout lannwit pou rive nan maten. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“‘Nou pa pou anmède yon moun soud, ni mete yon obstak pou fè avèg la tonbe, men nou va gen krentif pou Bondye nou an. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“‘Nou pa pou fè lenjistis nan jijman nou yo. Nou pa pou apiye vè malere a, ni apiye vè moun pwisan an, men nou va jije vwazen nou avèk jistis. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“‘Nou pa pou mache bay kout lang pami pèp nou an. Nou pa pou fè zak kont lavi vwazen nou yo. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“‘Nou pa pou rayi pwochen peyi nou nan kè nou. Nou mèt toujou korije vwazen nou, pou nou pa pote peche akoz li. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“‘Nou pa pou pran vanjans ni pote lahèn nan kè nou kont fis pèp nou an; men nou va renmen pwochen nou tankou tèt nou. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“‘Se pou nou kenbe règleman Mwen yo. Nou pa pou fè kwazman de ras bèf. Nou pa pou plante chan nou avèk de kalite grenn; Ni pou abiye ak yon vètman ki gen de kalite twal ki mele ansanm. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“‘Alò, si yon nonm kouche nan zak seksyèl avèk yon fanm ki se yon esklav ki te pwomèt pou yon lòt gason, men ki pa t peye ranson li, ni pa t bay li libète l, li va pini. Malgre sa, yo p ap mete li a lanmò, paske li pa t lib. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Gason an va pote ofrann koupab li devan SENYÈ a nan pòtay tant asanble a; yon belye pou ofrann koupab la. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Prèt la va fè ekspiyasyon pou li avèk belye ofrann koupab la devan SENYÈ a pou peche ke li te fè a, e selon peche ke li te fè a, li va vin padone. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“‘Lè nou antre nan peyi sa a, e plante tout kalite bwa pou manje, alò, nou va kontwole premye fwi pa yo kòm entèdi. Pandan twazan, li va entèdi a nou menm. Li p ap pou manje. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Nan katriyèm ane a, tout fwi li yo va vin sen. Yo va vin yon ofrann lwanj bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Nan senkyèm ane a, nou gen pou manje nan fwi li, pou donn li kapab vin anpil pou nou menm. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“‘Nou pa pou manje anyen avèk san ki rete nan li. Nou pa pou pratike maji ni divinasyon zetwal ni predi evenman k ap vin rive. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“‘Nou pa pou koupe kwen cheve tèt nou, ni taye sou kote bab nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“‘Nou pa pou koupe kò nou pou moun mouri yo, ni fè tatou sou kò nou: Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“‘Pa degrade pwòp fi nou pou fè l vin yon pwostitiye, sòf ke peyi a menm ta tonbe nan pwostitisyon, e ranpli avèk tout kalite bagay lèd. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“‘Nou va kenbe Saba Mwen yo, e nou va onore sanktyè Mwen an. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“‘Pa vire bò kote moun ki fè kontak ak mò yo, ni ki chache move lespri yo. Pa chache yo pou nou pa vin degrade pa yo menm. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“‘Nou va leve devan moun cheve blanch yo. Nou va bay lonè a granmoun yo. Nou va gen lakrent pou Bondye nou an. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“‘Lè yon etranje rete avèk nou nan peyi nou, nou pa pou fè l tò. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Etranje ki rete avèk nou an va, pou nou, tankou pwòp moun peyi nou. Nou va renmen li tankou tèt nou, paske nou te etranje nan peyi Égypte la. Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Nou pa pou fè move jijman, ni nan mezire longè, pwa, oubyen kapasite. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Fòk balans nou yo jis, e pèz pwa nou yo jis; yon efa (22 lit) ki jis, e yon in (36 lit) ki jis. Mwen se SENYÈ nou an, ki te fè nou sòti nan peyi Égypte la. ");
INSERT INTO hatbsa_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“‘Se konsa nou va obsève tout règleman Mwen yo ak tout òdonans Mwen yo, e fè yo. Mwen se SENYÈ a.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Ou va osi di a fis Israël yo: ‘Nenpòt moun nan fis Israël yo, oswa nan etranje ki rete an Israël yo ki bay nenpòt nan pitit li yo a Moloc, li va vrèman vin mete a lanmò. Pèp peyi a va lapide moun sa a avèk kout wòch. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mwen va osi mete figi Mwen kont moun sa a. Mwen va koupe retire li de pèp li a, akoz li te bay nan pitit li bay Moloc pou konwonpi sanktyè Mwen an, e degrade non sen Mwen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Men si moun nan peyi a ta janm tolere moun sa a lè li bay nan pitit li yo bay Moloc, e pa mete l a lanmò, ");
INSERT INTO hatbsa_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","alò, Mwen menm va mete figi Mwen kont moun sila a ak kont fanmi li, e Mwen va koupe retire de pèp li a; non sèlman li menm, men tout sila ki jwe pwostitiye dèyè li yo, lè yo jwe pwostitiye dèyè Moloc. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“‘Epi pou moun ki vire vè moun k ap fè kontak ak mò yo, ki swiv lespri dyab yo, pou yo jwe pwostitiye avèk yo, Mwen va osi mete figi Mwen kont moun sa a e Mwen va koupe retire li de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“‘Konsa, nou va konsakre nou menm e nou va rete sen, paske Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","“‘Nou va kenbe règleman Mwen yo, e nou va swiv yo. Mwen se SENYÈ a ki fè nou sen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“‘Si yon moun anmède papa li oswa manman li, li va vrèman vin mete a lanmò. Li te anmède papa li oswa manman li. Koupabilite san li rete sou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“‘Si yon mesye fè adiltè avèk madanm a yon lòt, menm sila ki fè adiltè avèk madanm zanmi li an, adiltè a avèk fanm adiltè a va vrèman vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“‘Si yon nonm vin kouche avèk madanm a papa li, li te dekouvri nidite a papa li. Yo tou de va vin mete a lanmò. Koupabilite san yo rete sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“‘Si gen yon nonm ki kouche avèk bèlfi li, tou de va vin mete a lanmò. Yo te fè ensès; koupabilite san an sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“‘Si gen yon gason ki kouche avèk yon lòt gason, menm jan ke li ta kouche avèk yon fanm, tou de te fè yon zak abominab. Yo va vrèman vin mete a lanmò. Koupabilite san yo sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“‘Si gen yon mesye ki marye avèk yon fanm ansanm ak manman li, sa se konwonpi. Yo tout va brile avèk dife pou mechanste pa rete nan mitan nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“‘Si gen yon mesye ki kouche avèk yon bèt, li va vrèman vin mete a lanmò. Nou va anplis touye bèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“‘Si gen yon fanm ki vin pwoche yon bèt pou kouche avèk li, nou va touye fanm nan ansanm ak bèt la. Yo va vrèman vin mete a lanmò. Koupabilite san an sou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“‘Si yon mesye pran sè li, oswa fi a papa li, oswa fi a manman li, pou l wè nidite li, epi li wè nidite li, sa se yon gwo wont. Yo va koupe retire devan zye a fis pèp Israël la. Li te dekouvri nidite sè li. Li pote koupabilite pa l. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“‘Si gen yon mesye ki kouche avèk yon fanm sou règ li e dekouvri nidite li, li te vin dekouvri flèv li, e li te fè flèv san li vin parèt. Pou sa, tou de va koupe retire de pèp pa yo a. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“‘Nou pa pou dekouvri nidite sè manman nou, ni sè papa nou, paske yon nonm konsa te fè nidite a fanmi de san li vin parèt. Yo va pote koupabilite yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“‘Si gen yon mesye ki kouche avèk madanm tonton li, li te dekouvri nidite tonton li. Yo va pote peche yo. Yo va mouri san fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“‘Si gen yon mesye ki pran madanm a frè li, sa se abominab. Li te dekouvri nidite a frè li. Yo p ap janm fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“‘Konsa, nou gen pou kenbe tout règleman ak tout òdonans Mwen yo e fè yo, pou peyi kote M ap mennen nou pou viv la, pa krache mete nou deyò. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Anplis, nou pa pou swiv koutim nasyon sa yo ke Mwen va pouse fè sòti devan nou yo, paske yo te fè tout bagay sa yo, e konsa, Mwen te vin rayi yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Konsa Mwen te di nou: “Nou dwe posede peyi pa yo a, e Mwen menm va bannou li pou posesyon, yon peyi k ap koule lèt ak siwo myèl.” Mwen se SENYÈ a, Bondye nou an, ki te mete nou apa de lòt pèp yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“‘Se konsa ke nou gen pou distenge antre bèt ki pwòp ak bèt ki pa pwòp, e antre zwazo ki pa pwòp ak sa ki pwòp la. Nou pa pou fè tèt nou vin abominab ni pa bèt, ni pa zwazo, ni pa sa ki trennen atè reptil ke Mwen te separe pou nou kòm pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Se konsa, nou va sen pou Mwen, paske Mwen, SENYÈ a, Mwen sen. Mwen te mete nou apa de lòt pèp yo pou nou kapab pa Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“‘Alò, yon nonm oswa yon fanm ki kontakte mò yo, oswa lespri yo, yo va anverite vin mete a lanmò. Yo va vin lapide avèk kout wòch. Koupabilite san rete sou yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: “Pale avèk prèt yo, fis Aaron yo. Di yo konsa: ‘Pèsòn pa pou konwonpi kò l avèk yon moun mouri pami pèp li a, ");
INSERT INTO hatbsa_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","sof pou fanmi ki pi prè li yo, tankou manman l, papa l, fis li, fi li ak frè li, ");
INSERT INTO hatbsa_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ak pou sè vyèj li, ki prè li, ki pa t gen mari. Pou sila a, li kapab konwonpi kò l. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Li pa pou konwonpi kò l, akoz li se yon gwo chèf pami pèp li a, e konsa, pou vin degrade tèt li. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“‘Yo pa pou fè tèt yo kale, ni taye bab yo, ni fè okenn blese nan chè yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Yo va rete sen a Bondye pa yo a, e yo p ap konwonpi non Bondye pa yo a, paske se yo ki prezante ofrann dife bay SENYÈ a, manje pou Bondye pa yo a. Alò, fòk yo sen. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“‘Yo pa pou pran yon fanm ki degrade kòm pwostitiye, ni yo pa pou pran yon fanm ki divòse avèk mari li; paske li sen a Bondye pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Konsa, nou va konsakre li, paske li ofri ou manje Bondye nou an. Li va sen pou nou, paske Mwen, SENYÈ ki sanktifye nou an, Mwen sen. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“‘Fi a nenpòt prèt, si li degrade tèt li kòm pwostitiye, li degrade papa li. Li va brile nan dife. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“‘Prèt ki se wo prèt pami frè li yo, sou tèt sila lwil onksyon an te vide a, e sila ki te konsakre pou abiye avèk vètman yo, pa pou dekouvri tèt li, ni chire rad li. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Li pa pou pwoche okenn moun mouri, ni konwonpi tèt li menm si se pou papa li oswa manman li. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Li pa pou sòti nan sanktyè a, ni konwonpi sanktyè Bondye li a, paske konsekrasyon lwil sen an sou li. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“‘Li va pran yon madanm ki vyèj. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Yon vèv, oswa yon fanm divòse, oswa youn ki degrade kòm pwostitiye, sa yo, li pa kapab pran yo. Men okontrè, fòk li marye ak yon vyèj pami pwòp pèp pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Li pa pou degrade desandan li yo pami pwòp pèp li a, paske Mwen se SENYÈ ki fè li sen an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Pale avèk Aaron. Di l: ‘Okenn moun pami nou ki gen yon defo fizik p ap pwoche pou ofri manje bay Bondye li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Paske nenpòt moun ki gen yon defo p ap pwoche: yon nonm avèg, yon bwate, yon nonm ki gen figi defòme, oswa okenn manm kò defòme, ");
INSERT INTO hatbsa_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","yon nonm pye kase oswa men kase, ");
INSERT INTO hatbsa_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","yon moun ki gen boul nan do oswa kata, oubyen yon moun ki gen defo nan zye li, oswa ekzema nan po, kal oswa boul grenn ki donmaje. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Okenn moun nan ras Aaron, prèt ki gen defo pa pou pwoche pou fè ofrann SENYÈ a pa dife. Akoz li gen yon defo, li pa pou pwoche pou ofri pen ki pou Bondye li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Li kapab manje pen Bondye li a, ni sa ki sen pase tout bagay yo, avèk sa ki sen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Se sèlman, li pa pou antre anndan vwal la, ni toupre lotèl la akoz ke li gen yon defo, pou li pa konwonpi sanktyè Mwen yo. Paske Mwen se SENYÈ ki fè yo sen an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Alò, Moïse te pale avèk Aaron, a fis li yo, e a tout fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Di Aaron avèk fis li yo pou separe yo de bagay sen ki pou fis Israël yo, ke yo dedye kon sen de Mwen yo, epi pou yo pa derespekte non sen Mwen an. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Di yo ke: ‘Si nenpòt moun pami tout jenerasyon nou yo vin pwoche de bagay sen yo, ke fis Israël yo te dedye bay SENYÈ a pandan li pa pwòp, moun sa a va koupe retire devan M. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“‘P ap gen yon nonm pami desandan Aaron yo ki gen lalèp oswa yon ekoulman ki kapab manje nan bagay sen yo jiskaske li vin pwòp. Konsa, si youn vin touche nenpòt bagay ki fèt pa pwòp pa yon moun mouri, oswa si yon nonm vin fè yon ekoulman, ");
INSERT INTO hatbsa_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","oswa, si yon mesye vin touche nenpòt nan bèt ki trennen atè, oswa nenpòt moun ki fè l vin pa pwòp, nenpòt sa ki fè l pa pwòp; ");
INSERT INTO hatbsa_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ke yon moun ki touche nenpòt kalite bagay konsa va pa pwòp jis rive nan aswè, e li p ap kab patisipe nan manje nan bagay sen yo sof ke li benyen kò l nan dlo. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Men lè solèy la kouche, li va pwòp. Konsa, apre, li ka manje nan bagay sen yo, paske se manje li. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Li pa pou manje yon bèt ki mouri oswa ki chire pa lòt bèt, pou fè l vin pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“‘Konsa, yo va kenbe lòd Mwen, pou yo pa pote peche akoz li, e mouri konsa si yo souye li. Mwen se SENYÈ ki fè yo sen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“‘Okenn etranje pa pou manje kado sen an. Yon vwayajè k ap rete ak prèt la, oswa yon ouvriye pa pou manje nan kado sen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Men si yon prèt achte yon esklav kòm pwòp byen pa li, avèk pwòp lajan pa li, sila a kapab manje nan li, e sila ki te ne nan kay li yo kapab manje manje li. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si fi a yon prèt vin marye avèk yon moun ki pa prèt, li pa pou manje nan kado ofrann yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Men si fi a yon prèt vin vèv, oswa divòse, e pa gen pitit, si li vin retounen lakay papa li, tankou lè l te jèn, li va manje nan manje papa li; men moun deyò p ap kab manje li. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“‘Men si yon nonm manje yon kado sen san konnen, alò, li va mete sou fòs li yon senkyèm anplis valè li, e li va bay kado sen an bay prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Yo pa pou degrade kado sen ki pou fis Israël yo, ke yo ofri bay SENYÈ a, ");
INSERT INTO hatbsa_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","epi konsa, fè yo pote pinisyon pou koupabilite akoz manje nan kado sen pa yo; paske Mwen se SENYÈ ki fè yo sen an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Alò SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Pale avèk Aaron, ak fis li yo, epi tout fis Israël yo. Di yo: ‘Nenpòt moun nan kay Israël la oswa pami etranje yo nan Israël ki prezante ofrann li, sof ke se youn nan ofrann sèman yo oswa ofrann bòn volonte yo, ke yo prezante bay SENYÈ a kòm yon ofrann brile— ");
INSERT INTO hatbsa_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","pou nou ta aksepte li—li oblije ke se yon mal san defo ki sòti nan bèf, mouton, oswa kabrit. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Nenpòt bèt ki gen defo, nou pa pou ofri li, paske li p ap akseptab pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Lè yon moun ofri yon sakrifis lapè bay SENYÈ a pou ranpli yon ve espesifik, oswa yon ofrann bòn volonte ki sòti nan bann mouton oswa nan twoupo, fòk li bon nèt pou l kapab aksepte. Li pa pou gen defo menm nan li. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Sila ki avèg yo, ki gen zo kase, oswa donmaje yo, sila ki gen maleng ekoulman, ekzema, oswa kal yo, nou pa pou ofri yo bay SENYÈ a, ni fè yon ofrann pa dife sou lotèl bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pou yon bèf, oswa yon jenn ti mouton ki gen youn nan manm li ki pi gwo oswa pi piti ke lòt yo, nou kapab prezante li kòm yon ofrann bòn volonte, men kòm yon ofrann ve, li p ap aksepte. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Osi, nenpòt nan yo avèk boul grenn li brize oswa kraze, chire oswa koupe, nou pa pou ofri li bay SENYÈ a, ni fè sakrifis avèk li nan peyi nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Ni nou p ap aksepte anyen ki konsa nan men a yon etranje kòm yon ofrann manje pou Bondye nou an, paske yo konwonpi. Yo gen defo. Yo pa pou aksepte pou nou.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Konsa, SENYÈ a te pale a Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Lè yon bèf oswa yon mouton, oswa yon kabrit vin fèt, li va rete pandan sèt jou avèk manman li. Men depi nan uityèm jou a, li va vin aksepte kòm yon sakrifis pou yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Menm si se yon bèf, oswa yon mouton, nou pa pou touye li ansanm avèk pitit li nan yon sèl jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Lè nou ofri yon sakrifis pou remèsiman bay SENYÈ a, nou va fè sakrifis la yon jan pou l aksepte. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Li va manje nan menm jou a, nou pa pou kite anyen de li pou rive jis nan maten. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Konsa nou va kenbe kòmandman Mwen yo, e fè yo. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Nou pa pou degrade non sen Mwen an, men Mwen va sen pami fis Israël yo. Mwen se SENYÈ ki fè nou sen an, ");
INSERT INTO hatbsa_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ki te fè nou sòti nan peyi Égypte la, pou vin Bondye nou. Mwen se SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","SENYÈ a te pale ankò avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Pale avèk fis Israël yo pou di yo: ‘Fèt chwazi SENYÈ a, ke nou va pwoklame kòm konvokasyon sen yo—fèt chwazi Mwen yo se sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“‘Pandan sis jou, travay kapab fèt, men sou setyèm jou a, va gen yon repo Saba konplè, yon konvokasyon sen. Nou pa pou fè okenn travay. Se yon Saba a SENYÈ a nan tout domisil nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“‘Sa yo se lè fèt chwazi pou SENYÈ a, konvokasyon sen ke nou va pwoklame nan lè ki apwente pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Nan premye mwa nan katòzyèm jou mwa a, avan l fènwa, se Pak SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Alò, nan kenzyèm jou nan menm mwa sa a, fèt Pen San Ledven pou SENYÈ a ap fèt. Pandan sèt jou, nou va manje pen san ledven. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Nan premye jou a, nou va gen yon konvokasyon sen. Nou p ap fè okenn travay di. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Men pandan sèt jou, nou va prezante yon ofrann pa dife bay SENYÈ a. Nan setyèm jou a, se yon konvokasyon sen. Nou pa pou fè okenn travay ki di.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Konsa, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Pale avèk fis Israël yo pou di yo: ‘Lè nou antre nan peyi ke Mwen ap bannou pou fè rekòlt li a, alò, nou va pote premye pake a kòm premye fwi rekòlt la bay prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Li va fè sign voye pake a anlè devan SENYÈ a pou nou, pou l kapab aksepte. Nan jou apre Saba a, prèt la va voye li anlè. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Alò, nan jou lè nou voye pake a anlè a, nou va ofri yon jenn mouton ki gen laj ennan(1 an) ki san defo pou yon ofrann brile bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Ofrann sereyal li, alò, va 2 dizyèm yon efa farin melanje avèk lwil, yon ofrann pa dife bay SENYÈ a, yon bagay santi bon, avèk ofrann bwason li, yon ka in diven. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Jis rive nan jou sa a, jiskaske nou pote ofrann Bondye nou an, nou pa pou manje ni pen, ni sereyal boukannen, ni nouvo tij vèt. Sa dwe rete yon règleman ki la pou tout tan pami tout jenerasyon nou yo, nan tout domisil nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“‘Nou va osi kontwole pou kont nou sèt jou Saba yo, soti nan jou ke nou te pote premye pake ofrann voye anlè a: va gen sèt Saba konplè. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Nou va kontwole senkant jou jis rive nan jou apre setyèm Saba a, epi nou va prezante yon ofrann sereyal nèf bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nou va pote soti nan domisil nou yo de (2) pen kòm yon ofrann voye anlè, ki fèt avèk de dizyèm yon efa. Yo va fèt avèk farin fen, kwit avèk ledven kòm premye fwi bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ansanm avèk pen an, nou va prezante sèt jenn mouton nan laj 1 nan, mal san defo, ak yon towo twoupo avèk de belye. Yo dwe yon ofrann brile bay SENYÈ a, avèk ofrann sereyal pa yo ak ofrann bwason pa yo, yon ofrann pa dife ki dous e santi bon a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Nou va osi ofri yon mal kabrit kòm yon ofrann peche, ak de mal mouton ki gen laj 1 nan kòm yon sakrifis ofrann lapè. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Konsa, prèt la va voye yo anlè avèk pen premye fwi yo kòm yon ofrann voye anlè avèk de jenn mouton yo devan SENYÈ a. Yo dwe sen a SENYÈ a pou prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Nan menm jou sa a, nou va osi fè yon pwoklamasyon ke nou va gen yon konvokasyon sen. Nou pa pou fè okenn travay di. Se yon règleman pou tout tan nan tout domisil nou yo pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“‘Lè nou fè rekòlt la nan peyi nou, anplis, nou pa pou rekòlte jis nan kwen chan nou yo, ni ranmase ti retay nan rekòlt la. Se pou nou kite yo pou malere avèk etranje yo. Mwen se SENYÈ a, Bondye nou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ankò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Pale avèk fis Israël yo pou di: ‘Nan setyèm mwa nan premye jou nan mwa a, nou va fè yon repo, yon tan pou sonje avèk son twonpèt yo, yon konvokasyon sen. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Nou pa pou fè okenn travay di, men nou va prezante yon ofrann pa dife bay SENYÈ a.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Nan dizyèm jou nan setyèm mwa sa a, se jou ekspiyasyon an. Li va yon konvokasyon sen pou nou. Nou va imilye nanm nou pou prezante yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Nou pa pou fè okenn travay nan menm jou sa a, paske li se yon jou ekspiyasyon, pou fè ekspiyasyon pou nou menm devan SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Si gen yon moun ki refize nye li menm nan jou sa a, li va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Pou nenpòt moun ki fè yon travay nan menm jou sa a, moun sa a, Mwen va detwi li pami pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Nou pa pou travay menm. Se yon règleman k ap dire pandan tout jenerasyon nou yo nan tout kay nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Fòk se yon repo Saba konplè pou nou, e nou va imilye nanm nou. Nan nevyèm jou mwa a nan aswè, nou va obsève Saba nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ankò SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Pale avèk fis Israël yo pou di: ‘Nan kenzyèm jou nan mwa sa a ki se setyèm mwa a, se Fèt Ti Tonèl Yo pandan sèt jou anvè SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Nan premye jou a, se yon konvokasyon sen. Nou pa pou fè okenn kalite travay ki di. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Pandan sèt jou, nou va prezante yon ofrann pa dife bay SENYÈ a. Nan uityèm jou a, nou va fè yon konvokasyon sen e prezante yon ofrann pa dife bay SENYÈ a. Se yon asanble solanèl. Nou pa pou fè okenn travay di. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“‘Sa yo se lè chwazi SENYÈ a ke nou va pwoklame kòm konvokasyon sen, pou prezante ofrann dife bay SENYÈ a—ofrann brile ak ofrann sereyal yo, sakrifis yo avèk ofrann bwason yo, zafè chak jou nan pwòp jou pa li— ");
INSERT INTO hatbsa_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","apati Saba sila ki pou SENYÈ yo, apati kado nou yo, apati tout ofrann ve avèk ofrann bòn volonte ke nou bay SENYÈ yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“‘Byen jis nan kenzyèm jou nan setyèm mwa a, lè nou gen tan antre rekòlt nan peyi a, nou va fete fèt ki pou SENYÈ a pandan sèt jou. Nou va fè yon repo solanèl nan premye jou a, e yon repo solanèl nan uityèm jou a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Alò, nan premye jou a, nou va pran pou nou menm fèy ki sòti nan pyebwa ki bèl yo, branch pal yo avèk branch nan pyebwa ki gen fèy yo, pyebwa ki pann sou kote rivyè a ak ti dlo yo, e nou va rejwi devan SENYÈ a Bondye nou an pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Nou va selebre li konsa kòm yon fèt bay SENYÈ a pandan sèt jou nan ane a. Sa va yon règleman k ap dire nèt pandan tout jenerasyon nou yo. Nou va selebre li nan setyèm mwa a. ");
INSERT INTO hatbsa_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Nou va viv nan tonèl yo pandan sèt jou. Tout natif Israël yo va viv nan tonèl yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","pou jenerasyon nou yo kapab vin konnen ke fis Israël yo te viv nan tonèl lè Mwen te mennen yo, fè yo sòti nan peyi Égypte la. Mwen se SENYÈ a, Bondye nou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Se konsa Moïse te deklare a fis Israël yo tout lè ki te deziye pa Bondye yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Kòmande fis Israël yo pou yo pote bay ou lwil klè ki sòti nan oliv ki te bat yo, pou limyè, pou fè lanp lan briye san rete. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Deyò vwal temwayaj tant asanble a, Aaron va kenbe li an lòd soti nan aswè rive jis nan maten devan SENYÈ a pou tout tan. Sa va yon règleman pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Li va kenbe lanp an lòd sou chandelye an lò devan SENYÈ a pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Konsa, nou va pran farin fen an e fè douz gato avèk li: de dizyèm pati yon efa va sèvi nan chak gato. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Nou va mete yo nan de ranje, sis nan chak ranje, sou tab lò san tach ki devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Nou va mete lansan san tach nan chak ranje pou li kapab yon pati komemoratif pou pen an, menm yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chak jou Saba, li va mete li an lòd devan SENYÈ a pou tout tan. Se yon akò k ap dire pou tout tan pou fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Li va pou Aaron avèk fis li yo. Yo va manje li nan yon lye ki sen; paske li sen pase tout ofrann ki soti nan ofrann bay SENYÈ yo, ofrann pa dife, pati pa li pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Alò, fis a yon famn Izrayelit avèk yon papa Ejipsyen, te sòti pami fis Israël yo. Konsa, fis a fanm Izrayelit la ak yon mesye peyi Israël te lite youn avèk lòt nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Fis a fanm Izrayelit la te blasfeme Non Bondye a e li te bay madichon. Pou sa, yo te mennen li vè Moïse. Alò manman li te rele Schelomith, fi a Dibri nan tribi Dan nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Yo te arete li pou lòd SENYÈ a ta kapab vin klè a yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Alò SENYÈ a te pale ak Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Mennen sila ki te bay madichon an deyò kan an, kite tout moun ki te tande li yo vin poze men sou tèt li; epi kite tout asanble a lapide li avèk kout wòch. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Ou va pale avèk fis Israël yo e di: ‘Si yon moun modi Bondye li a, alò, li va pote peche li. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Anplis, sila ki blasfeme non a SENYÈ a va vrèman vin mete a lanmò. Tout asanble a va vrèman lapide li. Etranje oswa natif, lè li blasfeme Non Bondye, li va vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“‘Si yon nonm pran lavi a yon Kretyen vivan, li va vrèman vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Sila ki pran lavi a yon bèt va fè l bon, lavi pou lavi. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si yon nonm blese vwazen li, menm sa ke li te fè a, va fèt a li menm: ");
INSERT INTO hatbsa_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","zo kase pou zo kase, zye pou zye, dan pou dan. Menm jan ke li te blese yon moun, se konsa ke li va fèt sou li menm. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Konsa, sila ki touye yon bèt va fè li bon, men sila ki touye yon moun va vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Va gen yon sèl règleman pou nou. Li va pou etranje kòm pou moun peyi a, paske Mwen se SENYÈ a, Bondye nou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Konsa, Moïse te pale a fis Israël yo. Yo te mennen sila ki te modi a deyò kan an, e yo te lapide li avèk kout wòch. Konsa fis Israël yo te fè, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Alò, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Pale a fis Israël yo pou di yo: ‘Lè nou vini nan peyi ke Mwen va bannou an, alò, tè a va gen yon Saba pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pandan sis ane, nou va plante chan nou yo, e pandan sis ane, nou va netwaye chan rezen an e rasanble pou fè rekòlt li, ");
INSERT INTO hatbsa_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","men pandan setyèm ane a, tè a va gen yon repo Saba, yon Saba pou SENYÈ a. Nou p ap ni plante chan an ni netwaye chan rezen an. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Donn nan chan ki grandi pa aza konsa a, nou pa pou rekòlte li, e rezen nou yo ki parèt sou branch ki pa t taye yo, nou pa pou ranmase yo. Tè a va gen yon ane Saba. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Konsa, nou tout va gen pwodwi Saba nan peyi a kòm manje nou; nou menm, esklav yo, ni mal ni femèl, anplwaye nou yo, etranje ki rezidan pami nou yo, sila ki viv tankou moun lòt nasyon pami nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Menm bèf nou yo avèk bèt ki nan peyi a va gen tout pwodwi li kòm manje. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“‘Nou dwe osi kontwole sèt Saba pa lane yo pou nou menm; sèt fwa sèt ane, jiskaske nou kontwole tan ke sèt Saba nan Saba ekoule yo; otreman, karant-nèf ane. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Alò, lè lè sa a rive nou va sone kòn belye a toupatou nan dizyèm jou nan setyèm mwa a. Nan jou ekspiyasyon an, nou va sone yon kòn toupatou nan peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Se konsa, nou va konsakre senkantyèm ane a e pwoklame remisyon toupatou nan peyi a, a tout abitan li yo. Li va yon jibile pou nou, e nou chak va retounen nan pwòp tèren pa nou ak pwòp fanmi pa nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Nou va gen senkantyèm ane a kòm yon ane jibile. Nou pa pou plante, ni rekòlte sa ki grandi konsa nan tè, ni ranmase fwi ki sòti nan branch ki pa t netwaye yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Paske se yon jibile; li va sen pou nou. Nou va manje pwodwi li ki sòti nan chan an. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“‘Nan ane jibile sila a, nou chak va retounen nan pwòp tè pa nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“‘Anplis, si nou fè lavant bay zanmi nou, oswa achte nan men zanmi nou, nou pa pou fè tò a youn lòt. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Konsènan nonb ane apre jibile yo, konsa, nou va achte nan men zanmi nou. Li dwe vann nou selon nonb ane rekòlt yo ki rete. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nan menm fòs ane ki rete yo, nou va ogmante pri a, e nan menm fòs ane ki manke yo, nou va redwi pri a, paske li se fòs rekòlt ki rete ke l ap vann ou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Konsa, pinga nou fè tò a youn lòt, men nou va krent Bondye nou an; paske Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“‘Se konsa ke nou va obsève règleman Mwen yo e kenbe jijman Mwen yo, pou akonpli yo, pou nou kapab viv an sekirite sou tè a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","“‘Konsa, tè a va donnen pwodwi li pou nou kapab manje vant plen, e viv an sekirite sou tè a.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Men si nou ta di: ‘Kisa n ap manje nan setyèm ane a si nou pa ni plante ni rekòlte rekòlt nou yo? Gade byen, nou p ap semen, ni rasanble pwodwi nou;’ ");
INSERT INTO hatbsa_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","alò, Mwen va tèlman regle benediksyon Mwen yo pou nou nan sizyèm ane a, pou li kab pote yon rekòlt twazan. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Lè nou ap plante nan uityèm ane a, nou kapab toujou manje ansyen bagay a rekòlt yo, e nou va kontinye manje vye a jis rive nan nevyèm ane a lè rekòlt pa li kòmanse antre a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Tè a, anplis, pa pou vann nèt, paske tè a se pa M; paske nou se sèlman etranje k ap demere avè M. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Konsa, nan chak mòso tè ke nou posede, fòk nou fè pwovizyon pou peye ranson tè a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Si yon moun peyi parèy nou an vin tèlman pòv ke li oblije vann yon pati nan tè li a, alò, se fanmi pi pre li a ki dwe peye ranson ke manm fanmi li te vann nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Oswa nan ka a yon moun ki pa gen fanmi, men ki tèlman regle zafè li pou twouve ase mwayen pou peye ranson an, ");
INSERT INTO hatbsa_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","alò, li va kalkile ane yo soti lè li te vann nan, e remèt fòs balans sa a moun ke li te vann li an. Konsa li va retounen vin pwòp tèren pa l. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Men si li poko twouve ase mwayen pou reprann li pou kont li, alò, sa ke li te vann nan, va rete nan men a sila ki achte li a jis rive nan ane jibile a. Men nan jibile a, li va libere, pou li kapab retounen kon pwòp tè pa li. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Menm jan an, si yon mesye vann yon kay nan yon vil ki antoure avèk miray, alò, dwa pou peye ranson pa l la va dire pou tout 1 nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Men si li pa peye ranson li an nan 1 nan ki ekoule a, alò, kay ki nan vil antoure avèk miray la va pase nèt bay sila ki te achte li pou tout jenerasyon li yo. Li p ap remèt nan jibile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Men kay nan vil ki pa antoure avèk miray yo va konsidere kòm chan ouvri; yo gen dwa peye ranson an e yo va remèt nan jibile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Men nan vil ki pou Levit yo, Levit yo gen yon dwa pèmanan pou peye ranson nan vil ki se posesyon pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Konsa, sa ki pou Levit yo kapab peye ranson e yon vant kay nan vil posesyon sila a va remèt nan jibile a. Paske vil Levit yo se posesyon pa yo pami fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Men chan pou bèt nan vil pa yo pa pou vann, paske sa se posesyon pa yo pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Alò, nan ka ke yon moun peyi nou an vin pòv e zafè li vin gate, alò, nou gen pou bay li soutyen. Li va viv tankou etranje, oswa yon moun k ap demere, pou li kapab toujou rete pami nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Pa pran enterè ni avantaj sou li, men onore Bondye ou a pou li kapab viv avèk ou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ou pa pou bay li lajan ou avèk enterè, ni manje ou pou fè pwofi. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mwen se SENYÈ a, Bondye nou an ki te fè nou sòti nan peyi Égypte la pou bannou peyi Canaan an pou M kapab Bondye nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Si yon moun peyi parèy nou vin tèlman pòv pami nou menm, e li vin vann tèt li bannou, nou pa pou desann li nan sèvis esklavaj. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Li va rete avèk nou kòm yon jounalye, menm kòm yon demere. Li va sèvi avèk nou jis rive nan ane jibile a. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Konsa li va sòti de nou menm, li menm avèk fis li yo avè l, e li va retounen vè fanmi li, pou li kapab retounen nan tèren zansèt li yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Paske yo se sèvitè Mwen ke Mwen te mennen sòti nan peyi Égypte la. Yo pa pou vann kon vant esklav la. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nou pa pou domine li avèk severite, men onore Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Selon esklav, mal ak femèl ke petèt nou kapab gen,—-nou kapab jwenn esklav mal ak femèl nan nasyon payen ki antoure nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Alò, osi, se soti nan fis a demere k ap viv pami nou yo, ke nou kapab vin genyen yo, e ladann nan fanmi pa yo ki avèk nou, ke yo va gen tan pwodwi nan peyi nou; yo menm osi kapab devni posesyon pa nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Nou kapab menm sede a fis apre nou yo, pou resevwa yo kòm yon posesyon. Nou kapab sèvi yo kòm esklav pou tout tan. Men pou moun peyi nou an, nou pa pou domine avèk severite youn sou lòt. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Alò, si mwayen a yon etranje, oswa yon demere avèk nou vin rich, e yon moun peyi parèy a nou an vin tèlman pòv ke li vin vann tèt li bay yon etranje ki demere pami nou, oswa desandan a yon fanmi etranje, ");
INSERT INTO hatbsa_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","alò, li va gen dwa peye ranson nan moman li fenk vann nan. Youn nan frè li yo kapab peye ranson li an, ");
INSERT INTO hatbsa_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","oswa tonton li, oswa fis tonton li, kapab peye ranson li an, oswa si li vin pwospere, li kapab peye ranson an pou pwòp tèt li. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Konsa, li menm avèk sila ki te achte li a, va kalkile ansanm soti nan ane ke li te vann tèt li bay li menm nan jis pou rive nan jibile a. Pri lavant li an va koresponn a nonb ane ke li te avèk li yo. Se tankou jou a yon jounalye ke li va avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Si gen toujou anpil ane, li va remèt yon pati nan pri lavant lan pou kouvri yo pou peye pwòp ranson pa li. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Si se pa anpil ane ki rete pou rive nan ane jibile a, li va kalkile sa avèk li. Selon ane ki rete yo li va remèt menm fòs la pou pri ranson an. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Menm tankou yon ouvriye ki anplwaye ane pa ane li va konsa avèk li. Li p ap domine sou li avèk severite devan zye nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Menm si li pa peye ranson an pa mwayen sila yo, li va toujou sòti nan ane jibile a, li menm avèk fis li yo avè l. ");
INSERT INTO hatbsa_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Paske fis Israël yo se sèvitè Mwen; yo se sèvitè Mwen ke M te mennen fè sòti nan peyi Égypte yo. Mwen se Senyè a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Nou pa pou fè pou nou menm zidòl, ni nou pa pou mete an plas pou nou menm yon imaj, oswa yon pilye sakre. Ni nou pa pou plase yon wòch taye nan okenn fòm pou bese devan li; paske Mwen se SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“Nou va kenbe Saba Mwen yo, e nou va onore sanktyè Mwen an. Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Si nou mache nan règleman Mwen yo, e kenbe kòmandman Mwen yo pou fè yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","konsa Mwen va bannou lapli yo nan sezon pa yo, pou peyi a donnen pwodwi li yo, e bwa nan chan yo va bay fwi yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Anverite, bat grenn chan nou va dire jis tan pou ranmase rezen yo, e ranmase rezen yo va dire jis rive nan tan semans lan. Nou va konsa manje manje nou vant plen nèt, e viv ansekirite nan peyi nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Mwen va osi bay lapè nan peyi a, pou nou kapab kouche san okenn moun pa fè nou tranble. Osi mwen va retire bèt sovaj nan peyi a, e okenn nepe p ap pase nan peyi nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Men nou va kouri dèyè lènmi nou yo, e yo va tonbe devan nou pa nepe. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Senk nan nou va chase yon santèn, san nan nou va chase di-mil, e lènmi nou yo va tonbe devan nou pa nepe. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Konsa, Mwen va vire vè nou pou fè nou donnen anpil fwi. Mwen va miltipliye nou, e Mwen va asire akò Mwen avèk nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Nou va manje nan ansyen depo a, e nou va netwaye ansyen an akoz nèf la. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Anplis, Mwen va fè domisil Mwen pami nou, e nanm Mwen p ap rejte nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mwen va osi mache pami nou, Mwen va Bondye nou, e nou va pèp Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mwen se SENYÈ a, Bondye nou an, ki te mennen nou sòti nan peyi Égypte la pou nou pa t esklav pa yo. Mwen te kase fè esklavaj nou an, e Mwen te fè nou mache kanpe dwat. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Men si nou pa obeyi Mwen e pa akonpli tout kòmandman sa yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","si, okontrè, nou rejte règleman Mwen yo, si nanm nou rayi òdonans sa yo pou li pa vin akonpli tout kòmandman Mwen yo, e kraze akò Mwen yo, ");
INSERT INTO hatbsa_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","anretou, men kisa Mwen va fè nou: Mwen va apwente sou nou sibitman yon gwo twoub, yon maladi epwizan avèk lafyèv ki va gate zye nou, e fè nanm nan chagren. Konsa, nou va simen grenn nou yo san reyisi, paske se lènmi nou yo ki va manje li. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Mwen va mete figi Mwen kont nou jiskaske nou vin frape devan lènmi nou yo. Sila ki rayi nou yo va domine sou nou, e nou va kouri sove ale menm lè pa gen moun k ap kouri dèyè nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Si menm apre bagay sa yo, nou pa vin obeyi Mwen, alò Mwen va pini nou sèt fwa anplis pou peche nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Mwen va anplis, kase awogans pouvwa nou. Mwen va fè syèl la tankou fè, e tè a tankou bwonz. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Fòs ou va depanse san valè; latè ou p ap pwodwi, ni pyebwa yo p ap donnen fwi. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","‘Si konsa, ou aji ak ostilite kont Mwen, e refize obeyi M, Mwen va ogmante gwo maladi ak dezas yo sèt fwa, selon peche nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","“Mwen va lage pami nou bèt sovaj chan yo ki va rache pitit nou yo nan men nou, detwi bèt nou yo e redwi fòs kantite moun nou jis pou wout nou yo rete abandone. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Epi si, nan tout bagay sa yo nou pa vire bò kote M, men aji avèk ostilite kont Mwen, ");
INSERT INTO hatbsa_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","alò, Mwen va aji avèk ostilite kont nou. Mwen, Mwen menm, Mwen va frape nou sèt fwa pou peche nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Osi, Mwen va mennen sou nou yon nepe ki va egzekite vanjans pou akò a. Lè nou reyini ansanm nan vil nou yo, Mwen va voye epidemi sou nou, pou nou vin livre nan men lènmi nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Lè Mwen kase pen pami nou, dis fanm va kwit pen nou nan yon sèl fou, e yo va mennen retounen pen nou nan pati ki mezire nan balans lan, pou nou manje, men pa pou nou satisfè. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Men si, malgre tout sa, nou pa obeyi Mwen, men aji avèk ostilite kont Mwen, ");
INSERT INTO hatbsa_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","alò, Mwen va aji avèk ostilite ak vanjans kont nou. Mwen va pini nou sèt fwa pou peche nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Anplis nou va manje chè a fis nou yo e chè a fi nou yo, n ap manje. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Mwen va detwi wo plas yo, koupe lotèl lansan yo, e fè gwo pil ak retay kò nou sou retay zidòl nou, paske nanm Mwen va rayi nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Anplis, Mwen va kraze vil nou yo; Mwen va fè sanktyè nou yo vin dezè, e Mwen p ap dakò santi sant dous nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Mwen va fè peyi a dezole jiskaske lènmi nou ki vin viv ladan yo a va chagren sou sa. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Men nou, Mwen va gaye nou pami nasyon yo, e Mwen va rale yon nepe parèt dèyè nou, pandan peyi nou an vin dezè e vil nou yo vin kraze. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Epi tè a va rejwi nan Saba li yo pandan tout jou dezolasyon li yo, pandan nou nan peyi lènmi nou yo. Konsa, tè a va repoze e rejwi nan Saba li yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tout jou a dezolasyon yo, li va obsève repo ke li pa t obsève nan Saba nou yo pandan nou t ap viv ladann nan. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Pou sila nan nou ki kab toujou rete la yo, Mwen va osi pote feblès nan kè yo pandan yo nan peyi lènmi yo. Konsa, bwi a yon fèy k ap kouri nan van va fè kè yo sote, e menmlè pèsòn pa kouri dèyè yo, yo va sove ale tankou se devan nepe, e yo va tonbe. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Se konsa yo va manke tonbe youn sou lòt, kòmsi yo t ap kouri kite nepe, malgre pèsòn pa dèyè yo. Nou p ap gen fòs pou kanpe devan lènmi nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Men nou va peri pami nasyon yo, e peyi lènmi nou yo va manje nou. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Epi sila ki lese dèyè yo va pouri gate akoz inikite pa yo nan peyi a lènmi pa nou an; epi osi, akoz inikite zansèt pa yo, ak enfidelite ke yo te komèt nan peyi lènmi nou yo; anplis, akoz inikite a papa zansèt pa yo, yo va vin pouri ansanm avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Si yo konfese inikite pa yo, ak inikite zansèt yo, nan enfidelite ke yo te komèt kont Mwen yo, ak jan yo aji avèk ostilite kont Mwen an— ");
INSERT INTO hatbsa_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Mwen te aji osi avèk ostilite kont yo, pou mennen yo nan peyi lènmi yo—oubyen si kè ensikonsi yo a ta vin imilye pou yo kapab, answit, aksepte pinisyon pou inikite yo a. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Nan lè sa a, Mwen va sonje akò Mwen avèk Jacob, Mwen va sonje osi akò Mwen avèk Isaac, ni akò Mwen avèk Abraham, e Mwen va sonje peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Paske, peyi a va vin abandone pa yo. Konsa, li va rejwenn Saba li yo pandan li rete kon dezè san yo menm nan. Antretan, yo menm va vin aksepte pinisyon pa yo paske yo te rejte òdonans Mwen yo, e nanm yo te rayi règleman Mwen yo. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Men malgre tout sa, lè yo nan peyi lènmi yo, Mwen p ap rejte yo, ni Mwen p ap meprize yo tèlman pou detwi yo e kraze akò Mwen avèk yo; paske Mwen se SENYÈ a, Bondye pa yo a. ");
INSERT INTO hatbsa_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Men Mwen va sonje yo pou akò avèk zansèt yo a, ke M te mennen fè yo sòti nan peyi Égypte devan zye a tout nasyon yo, pou Mwen ta kapab vin Bondye pa yo. Mwen se SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Sa yo se règleman avèk òdonans avèk lwa ke SENYÈ a te etabli antre Li menm ak fis Israël yo pa Moïse nan Mòn Sinai a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Ankò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Pale avèk fis Israël yo pou di: ‘Lè yon nonm fin fè yon ve ki difisil, li va valorize selon valè moun nou ki apatyen a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Si valè ou a se yon gason antre ventan ak swasantan daj, valè ke nou va bay li a se senkant sik an ajan, dapre sik ki nan sanktyè a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Oubyen, si se yon fanm, alò valè nou va trant sik. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Si li antre senkan jiska ventan, alò valè nou pou gason an va ven sik, e pou fanm nan dis sik. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Men si yo antre laj yon mwa jis rive nan senkan, valè nou va senk sik an ajan pou gason an, e pou fanm nan, valè nou va twa sik an ajan. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Si yo gen swasantan oswa plis, si se yon gason, alò valè li va kenz sik, e pou fanm lan, dis sik. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Men si li manke rive nan valè ou, alò li va plase devan prèt ki va bay valè li a. Selon mwayen a sila ki te fè ve a, prèt la va ba li valè. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“‘Alò, si se yon kalite bèt ke yon mesye ta kapab prezante kòm yon ofrann bay SENYÈ a, nenpòt sa ki bay a SENYÈ a, va sen. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Li pa pou ranplase li ni chanje li, yon bon pou yon move, ni yon move pou yon bon. Oswa, si li ta chanje bèt pou bèt, se tou de ki vin sen. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Si li se yon bèt ki pa pwòp nan kalite ke moun pa kab prezante kòm yon ofrann bay SENYÈ a, alò, li va plase bèt la devan prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Prèt la va ba li valè kit li bon, kit li pa bon. Jan nou menm nan, prèt la ba li valè, se konsa li va ye. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Men si li ta janmen vle peye ranson li an, alò li va ogmante yon senkyèm nan valè li. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“‘Alò, si yon mesye konsakre kay li kòm sen pou SENYÈ a, alò prèt la va ba li valè kòm bon, oswa pa bon. Jan prèt la ba li valè, se konsa li va kanpe. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Men si sila ki konsakre li a ta vle vin peye ranson li an, alò, li va mete yon senkyèm sou valè pri a pou l kapab vin pou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“‘Ankò, si yon mesye konsakre bay SENYÈ a yon pati nan pwòp chan pa li yo, alò, valè ke nou ba li a va selon fòs kantite semans ki nesesè pou simen li an: yon barik semans lòj vo senkant sik ajan. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si li konsakre chan li an nan menm ane jibile a, selon valè nou ba li, li va kanpe konsa. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Si li konsakre chan li an apre jibile a, alò, prèt la va kalkile pri a pou li selon ane ki rete yo jis rive nan ane jibile a; epi li va vin redwi nan valè ke nou bay la. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Si sila ki konsakre li a ta janmen vle peye ranson chan an, alò li va adisyone yon senkyèm nan valè ke nou bay sou li a, pou li kapab vin pou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Malgre sa, si li pa peye ranson chan an, men te vann chan an a yon lòt moun, li p ap kapab peye ranson an ankò; ");
INSERT INTO hatbsa_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","men lè li vin retounen nan jibile a, chan an va vin sen pou SENYÈ a, kòm yon chan ki mete apa. Li va pou prèt la kòm tè pa li. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“‘Oswa, si li konsakre bay SENYÈ a, yon chan ke li te achte, ki se pa yon pati nan chan pwòp tè pa li a, ");
INSERT INTO hatbsa_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","alò, prèt la va kalkile pou li sòm valè chan an jis rive nan ane jibile a; epi li va nan jou sa a bannou valè nou kòm sen pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Nan ane jibile a, chan an va retounen a sila sou li menm li te achte li a, e ki se pwòp mèt tèren an. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Anplis, chak valè ke nou bay va baze sou sik sanktyè a. Sik la va ven gera (yon ventyèm sik la). ");
INSERT INTO hatbsa_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“‘Malgre sa, yon premye pòtre pami bèt yo, ki se kòm premye ne, se pou SENYÈ a, pèsòn pa pou konsakre li; kit se yon bèf, kit se yon mouton, se pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Men si li pami bèt ki pa pwòp yo, alò li va rachte li selon valè ke nou ba li e mete yon senkyèm anplis; epi si li pa rachte li, alò li va vann li selon valè ke nou ba li a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“‘Sepandan, nenpòt bagay ke yon nonm mete apa pou SENYÈ a nan tout sa ke li genyen, kit se moun, bèt, oswa chan nan pwòp tè li, li p ap janm vann ni peye ranson. Nenpòt bagay ki dedye pou destriksyon, pi sen pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Okenn moun ki vin mete apa pami lèzòm p ap janm peye ranson. Li va asireman vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“‘Konsa tout dim tè, semans tè, ni fwi nan bwa, se pou SENYÈ a. Li sen pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Alò, konsa, si yon moun vle peye ranson yon pati nan dim li, li va mete yon senkyèm sou li. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Paske chak dizyèm pati nan twoupo, oswa nan bann mouton, nenpòt sa ki pase anba baton, dizyèm pati a va sen pou SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Li pa konsènan si li bon oswa pa bon, ni li pa pou chanje li. Alò, li menm, ni sa ki ranplase li a, va vin sen. Li pa pou peye ranson.’” ");
INSERT INTO hatbsa_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Sa yo se kòmandman ke SENYÈ a te kòmande Moïse pou fis Israël yo nan mòn Sinai a. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","SENYÈ a te pale a Moïse nan dezè Sinaï a, nan tant asanble a, nan premye jou a dezyèm mwa a, nan dezyèm ane lè yo te fin sòti nan peyi Égypte la. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Fè yon chif kontwòl tout asanble fis Israël yo selon fanmi zansèt pa yo, selon papa lakay yo, selon kantite, non a chak gason, tèt pa tèt, ");
INSERT INTO hatbsa_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","soti nan ventan oplis, nenpòt moun ki kapab fè lagè an Israël. Ou menm avèk Aaron va konte yo pa lame yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Anplis de nou menm, va genyen yon moun ki sòti nan chak tribi, yo chak ki se tèt a fanmi zansèt pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Alò, sa yo se non mesye ki va kanpe avèk ou yo: pou Ruben: Élitsur, fis a Schedéur; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","pou Siméon: Schelumiel, fis a Tsurischaddaï; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","pou Juda: Nachschon, fis a Amminadab; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","pou Issacar: Nethaneel, fis a Tsuar; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","pou Zabulon: Éliab, fis a Hélon; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","pou fis a Joseph yo, pou Éphraïm: Élischama, fis a Ammihud; pou Manassé: Gamaliel, fis a Pedahtsur; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","pou Benjamin: Abidan, fis a Guideoni; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","pou Dan: Ahiézer, fis a Mamischaddaï; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","pou Aser: Paguiel, fis a Ocran; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","pou Gad: Éliasapah, fis a Déuel; ");
INSERT INTO hatbsa_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","pou Nephthali: Ahira, fis a Énan.” ");
INSERT INTO hatbsa_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Se sila yo ki te rele pa asanble a, dirijan a tribi fanmi zansèt pa yo; yo te chèf a dè milye an Israël. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Konsa, Moïse avèk Aaron te pran mesye sa yo ki te chwazi pa non yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Yo te reyini tout kongregasyon an ansanm nan premye jou nan dezyèm mwa a. Konsa, yo te fè anrejistreman selon fanmi zansèt pa yo, selon kay papa yo, selon kantite ki te nome yo, soti nan ventan oswa plis, tèt pa tèt. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Jan SENYÈ a te kòmande Moïse la, konsa li te konte yo nan dezè ki rele Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Alò fis a Ruben yo, premye ne pou Israël, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite ki te nome yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Kantite mesye ki te konte nan tribi Ruben an te karann-si-mil-senk san (46,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Pou fis Siméon yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite ki te nome yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Kantite mesye ki te konte nan tribi Siméon an te senkant-nèf-mil, twa-san (59,300). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Pou fis Gad yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite ki te nome yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Kantite mesye ki te konte nan tribi Gad la te karann-senk-mil-sis-san-senkant (45,650). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Pou fis Juda yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Kantite mesye ki te konte nan tribi Juda a te swasann-katòz-mil-sis-san (74,600). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Pou fis Issacar yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Kantite mesye ki te konte nan tribi Issacar a te senkant-kat-mil-kat-san (54,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Pou fis Zabulon yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Kantite mesye ki te konte nan tribi Zabulon an te senkant-sèt-mil-kat-san (57,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Pou fis Joseph sa vle di Éphraïm, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Kantite mesye ki te konte nan tribi Éphraïm nan te karann-sèt-mil-senk-san (47,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Pou fis Manassé yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Fòs kantite mesye ki te konte nan tribi Manassé a te trann-de-mil-de-san (32,200). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Pou fis Benjamin yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Kantite mesye ki te konte nan tribi Benjamin an te trann-senk-mil-kat-san (35,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Pou fis Dan yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Kantite mesye ki te konte nan tribi Dan nan te swasann-de-mil-sèt-san (62,700). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Pou fis Aser yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Kantite mesye ki te konte nan tribi Aser a te karanteyen-mil-senk-san (41,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Pou fis Nephthali yo, anrejistreman pa yo selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Kantite mesye ki te konte nan tribi Nephtali a te senkant-twa-mil-kat-san (53,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Sa yo se sila ki te konte yo, ke Moïse avèk Aaron te konte yo, selon chèf Israël yo, douz gason, chak ki te sòti lakay zansèt papa pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Konsa se tout gason nan fis Israël yo ki te konte selon fanmi zansèt yo, selon fanmi papa pa yo, selon kantite non yo, tèt pa tèt, tout gason soti nan ventan oswa plis ki ta kapab fè lagè an Israël. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Jiskaske tout mesye ki te konte yo te sis-san-twa-mil-senk-san-senkant. (603,550). ");
INSERT INTO hatbsa_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Men Levit yo pa t konte pami yo selon tribi zansèt papa pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Paske SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Sèlman tribi Levi a, nou p ap konte, ni nou p ap fè kontwòl anrejistreman pa yo pami fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Men nou va chwazi Levit yo sou tabènak temwayaj la, sou tout zafè li yo ak tout sa ki apatyen a li menm. Yo va pote tabènak la avèk tout zafè li, e yo va okipe li; yo va osi fè kan antoure tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Konsa lè tabènak la ap pati, Levit yo va desann li; epi lè tabènak la vin kanpe, Levit yo va monte li. Men sila ki pa Levit ki vin toupre va vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","“Fis Israël yo va fè kan, chak mesye bò kote kan pa li, e chak mesye bò drapo pa li, selon lame yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Men Levit yo va fè kan antoure tabènak temwayaj la, pou kòlè pa vin sou asanble fis Israël yo. Konsa Levit yo va kenbe chaj sou Tabènak Temwayaj la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Se konsa ke fis Israël yo te fè. Selon tout sa ke SENYÈ a te kòmande Moïse yo, konsa yo te fè. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Alò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Fis Israël yo va fè kan, chak bò kote pwòp drapo pa yo, avèk drapo lakay papa zansèt pa yo. Yo va fè kan antoure tant asanble a, a yon distans. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Alò, sila ki fè kan nan kote lès la vè solèy leve yo va sila nan drapo kan an Juda yo, selon lame pa yo. Chèf dirijan a fis Juda yo vaNachschon, fis a Amminadab la, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","avèk lame pa li. Men mesye ki te konte yo, swasann-katòz-mil-sis-san (74,600). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Sila ki fè kan bò kote li yo va nan tribi Issacar. Chèf dirijan an va Nethaneel, fis a Tsuar a, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","avèk lame pa li. Mesye ki te konte yo te senkant-kat-mil-kat-san (54,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Sila a va swiv pa Zabulon, avèk chèf dirijan fis Zabulon yo: Eliab, fis a Hélon an, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","avèk lame pa li, men mesye ki te konte yo, senkant-sèt-mil-kat-san (57,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Total a mesye ki te konte nan kan Juda a te: san-katreven-si-mil-kat-san (186,400) selon lame pa yo. Yo va sòti avan. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Nan kote sid la va gen drapo a kan Ruben an selon lame pa yo. Chèf a fis Ruben yo te: Élitsur fis a Schedéur a, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","avèk lame pa li. Men mesye ki konte yo, karant-si-mil-senk-san (46,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Sila ki fè kan bò kote li yo va nan tribi Siméon. Chèf a fis Siméon yo te: Schelumiel, fis a Tsurischaddaï la, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","avèk lame pa li. Mesye ki te konte yo te senkant-nèf-mil-twa-san (59,300). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Swiv pa tribi Gad la, avèk chèf a fis Gad yo: Éliasapah, fis a Déuel la, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","avèk lame pa li. Men mesye ki te konte yo; karann-senk-mil-sis-san-senkant (45,650). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Total a mesye konte nan kan Ruben an te: san-senkanteyen-mil-kat-san-senkant (151,450). Se yo k ap sòti nan dezyèm nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Konsa, tant asanble a va sòti avèk kan levit yo nan mitan kan yo. Menm jan ke yo fè kan an, konsa yo va sòti, chak moun nan plas li bò kote drapo pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Nan kote lwès la, va gen drapo kan Ephraïm lan selon lame pa yo e chèf a fis Ephraïm yo va Élischama fis a Ammihud la. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Nan lame pa li, men sa ki konte yo; karann-mil-senk-san (40,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Akote li va gen tribi Manassé a, e chèf a fis Manassé yo te: Gamaliel, fis a Pedahstsur a, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","avèk lame pa li. Men mesye sila ki te konte yo, trann-de-mil-de-san (32,200). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Apre se tribi a Benjamin an, e chèf a tribi Benjamin an te: Abidan, fis a Gideoni a, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","avèk lame pa li. Men mesye sila ki te konte yo; trann-senk-mil-kat-san (35,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Total a mesye konte nan kan Ephraïm yo te: san-ui-mil-san (108,100) pa lame pa yo. Yo va sòti nan twazyèm nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Nan kote nò va gen drapo pou kan Dan an, selon lame pa yo, e chèf a fis Dan yo te: Ahiézer, fis a Ammischaddaï a, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","avèk lame pa li. Men mesye ki te konte yo; swasann-de-mil-sèt-san (62,700). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Sila ki fè kan bò kote li yo va nan tribi Aser, e chèf a fis a Aser yo te: Paguiel, fis a Ocran an, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","avèk lame pa li. Men mesye sila ki te konte yo; karanteyen-mil-senk-san (41,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Apre se te tribi a Nephtali a, e chèf a fis a Nephtali yo te: Ahira, fis a Énan an, ");
INSERT INTO hatbsa_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","avèk lame pa li. Men mesye sila ki te konte yo; senkant-twa-mil-kat-san (53,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Total a mesye nan kan Dan yo te san-senkant-sèt-mil-sis-san. (157,600) Yo va sòti dènye avèk drapo pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Sa yo se mesye ki te konte a fis Israël yo selon lakay papa zansèt pa yo; total a mesye a tout kan yo ki te konte pa lame yo te sis-san-twa-mil-senk-san-senkant (603,550) ");
INSERT INTO hatbsa_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Malgre sa, Levit yo pa t konte pami fis Israël yo, jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Konsa fis a Israël te fè. Selon tout sa ke SENYÈ a te kòmande Moïse yo, yo te fè kan bò kote drapo pa yo, e konsa yo te sòti, yo chak avèk pwòp fanmi pa yo selon lakay zansèt papa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Alò sa yo se chif desandan a Aaron avèk Moïse nan tan lè SENYÈ a te pale avèk Moïse sou Mòn Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Sa yo se non a fis Aaron yo: Nadab, premye ne a, Abith, Éléazar ak Ithamar. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Sa yo se non a fis Aaron yo, prèt onksyone ke li te konsakre pou sèvi kòm prèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Men Nadab avèk Abihu te mouri devan SENYÈ a lè yo te ofri dife etranje devan SENYÈ a nan dezè Sinaï a. Yo pa t gen pitit. Konsa, Éléazar avèk Ithamar te sèvi kòm prèt pandan papa yo, Aaron, t ap viv. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Alò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Mennen tribi Levi a vin pre ou, e fè yo chita devan Aaron, prèt la, pou yo kapab sèvi li. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Yo va ranpli devwa pou li ak pou tout kongregasyon an devan tant asanble a, pou fè sèvis tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Yo va osi kenbe tout zafè ki founi tant asanble a, ansanm avèk devwa a fis Israël yo, pou fè sèvis tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Konsa ou va bay Levit yo a Aaron avèk fis li yo; yo va bay nèt a li pami fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Konsa, ou va chwazi Aaron avèk fis li yo pou yo kapab ranpli fonksyon prèt yo, men nenpòt lòt moun ki pwoche va vin mete a lanmò.” ");
INSERT INTO hatbsa_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Ankò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Alò, veye byen, Mwen te pran Levit yo pami fis Israël yo olye de chak premye ne, premye bebe a chak vant pami fis Israël yo. Konsa, Levit yo se pa M. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Paske, tout premye ne se pa M yo ye. Nan jou ke M te frape tout premye ne nan peyi Égypte yo, Mwen te sanktifye pou Mwen menm tout premye ne an Israël yo soti nan lòm pou rive nan bèt yo. Yo va pou Mwen; Mwen se SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Konsa, SENYÈ a te pale avèk Moïse nan dezè Sinaï a. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Konte fis a Levi yo selon lakay papa pa yo, pa fanmi yo; tout gason soti nan laj a yon mwa oswa plis, ou va konte yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Alò, Moïse te konte yo selon pawòl a SENYÈ a, jis jan ke li te kòmande a. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Konsa, se sa yo ki te fis a Levi yo pa non yo: Guerschon, Kehath, ak Merari. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Sa se non a fis a Guerschon yo selon fanmi pa yo: Libni ak Schimeï; ");
INSERT INTO hatbsa_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Fis a Kehath yo selon fanmi pa yo: Amram, Jitsehar, Hébron ak Uziel; ");
INSERT INTO hatbsa_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Fis a Merari yo selon fanmi pa yo: Machli ak Muschi. Sa yo se fanmi Levit yo selon lakay papa pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Nan Guerschon te sòti fanmi a Libni yo ak fanmi a Schimeï yo. Sa yo se te fanmi a Gèchonit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Nan mesye konte yo tout gason soti nan yon mwa oswa plis te vin konte nan sèt-mil-senk-san (7,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Fanmi a Gèchonit yo te toujou gen pou fè kan dèyè tabènak la nan kote lwès la. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Chèf a lakay papa yo pami Gèchonit yo te Élaisaph, fis a Laël la. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Alò, devwa a fis Guerschon yo nan tant asanble a se te tabènak la avèk tant lan, kouvèti li, rido pòtay tant asanble a, ");
INSERT INTO hatbsa_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","bagay pandye sou galeri a, ki antoure tabènak la ak lotèl la, e kòd li yo avèk tout sèvis konsènan li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Nan Kehath, te sòti fanmi a Amramit yo, fanmi Jitseharit yo, fanmi Ebwonit yo avèk fanmi Izyelit yo. Sila yo se te fanmi a Kehath yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Nan konte tout gason nan laj yon mwa oswa plis, te gen ui-mil-sis-san (8,600) ki t ap fè devwa sanktyè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Fanmi a Kehath yo te gen pou fè kan nan kote sid a tabènak la, ");
INSERT INTO hatbsa_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","epi chèf a tout kay papa yo pou Kehath yo se te Élitsaphan, fis a Uziel la. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Alò, devwa pa yo se te lach la, tab la, chandelye a, lotèl yo, tout zouti pou sèvis sanktyè a, rido a, ak tout sèvis ki fèt avèk yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Éléazar, fis a Aaron an se te chèf an tèt a chèf Levit yo, e li te responsab pou tout sila ki te fè devwa sanktyè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Nan Merari, te sòti fanmi a Machli yo ak fanmi Muschi yo. Se sa yo ki te fanmi a Merari yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Mesye pa yo ki te konte pa tout gason ak laj yon mwa oswa plis yo, te si-mil-de-san (6,200). ");
INSERT INTO hatbsa_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Chèf a lakay papa Merari yo se te Tsuriel, fis a Abihaïl la. Yo te gen pou fè kan sou kote nò a tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Alò, devwa a fis Merari yo se te pou okipe ankadreman tabènak la, poto li yo, baz reseptikal li yo, tout bagay sa yo avèk sèvis ki konsène yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","ak pilye ki antoure galeri a, avèk baz reseptikal pa yo avèk pikèt ak kòd yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Alò, sila ki te gen pou fè kan devan tabènak la vè lès la devan tant asanble a, vè solèy leve a, se te Moïse avèk Aaron avèk fis li yo, ki pou fè devwa sanktyè yo, pou ranpli obligasyon a fis Israël yo. Men nenpòt moun ki pa prèt va vin mete a lanmò si li vin toupre. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tout mesye ki te konte pami Levit yo, ke Moïse avèk Aaron te konte selon kòmand a SENYÈ a, pa fanmi pa yo, tout gason ki te gen yon mwa oswa plis, te venn-de-mil (22,000). ");
INSERT INTO hatbsa_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Konsa, SENYÈ a te di a Moïse: “Konte tout gason, premye ne pami fis Israël yo soti nan laj yon mwa oswa plis, e fè yon chif ak non yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ou va pran Levit yo pou Mwen—Mwen se SENYÈ a—olye de premye ne pami fis Israël yo; ak bèt a Levit yo olye de tout premye ne nan bèt a fis Israël yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Konsa, Moïse te konte tout premye ne pami fis Israël yo, jan SENYÈ a te kòmande li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Tout premye ne nan gason yo soti nan laj a yon mwa oswa plis, mesye ki te konte pou yo te venn-de-mil-de-san-swasann-trèz22,273 ");
INSERT INTO hatbsa_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Pran Levit yo olye de tout premye ne pami fis Israël yo ak bèt a Levit yo olye bèt pa yo. Konsa, Levit yo va pou Mwen: Mwen se SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pou ranson a de-san-swasann-trèz (273) nan premye ne an Israël ki plis ke Levit yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ou va pran senk sik pou chak, pa tèt. Ou va pran yo an valè sik sanktyè a (sik la se ven gera), ");
INSERT INTO hatbsa_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","epi bay Aaron avèk fis li lajan an ki te peye pou ranson pa Levit yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moïse te pran lajan ranson an ki sòti nan sila ki te anplis sila ki te ransonen pa Levit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","nan men a premye ne a fis Israël yo, li te pran lajan an an valè sik sanktyè a, mil-twa-san-swasann-senk (1,365) sik. ");
INSERT INTO hatbsa_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Epi Moïse te bay lajan ranson an bay Aaron avèk fis li yo, selon kòmand a SENYÈ a, jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Alò SENYÈ a te pale avèk Moïse ak Aaron. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Fè yon chif kontwòl a desandan Kehath yo pami fis Levit yo, selon fanmi pa yo, e selon lakay papa pa yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","soti nan trantan oswa plis, menm jiska senkantan; tout moun ki antre nan sèvis pou fè travay a Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Sa se travay a desandan a Kehath yo nan Tant Asanble a, selon bagay ki sen pase tout bagay yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Lè kan an pati, Aaron avèk fis li yo va antre ladann. Yo va fè desann vwal rido a, e yo va kouvri lach temwayaj la avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Yo va kouvri li avèk po dofen, ouvri sou li yon twal, koulè ble pi, e pase fè poto antre nan wondèl yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Sou tab a pen Prezans lan, yo va osi ouvri yon twal ble. Yo va mete sou li asyèt avèk bonm yo ak veso pou fè sakrifis yo, bokal pou ofrann bwason an, ak pen k ap la tout tan an, va sou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Yo va kouvri yo avèk yon twal wouj, yo va kouvri li avèk yon po dofen, e yo va fè poto yo antre pase nan wondèl yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Yo va pran yon twal ble, e yo va kouvri chandelye a pou limyè a, ansanm avèk lanp pa li yo, touf yo, asyèt li yo, ak veso lwil li yo, avèk sa yo konn okipe li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Yo va mete tout zouti li yo nan yon kouvèti po dofen, e yo va mete li nan poto ki fèt pou pote a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Sou lotèl an lò a, yo va mete yon twal ble. Yo va kouvri li avèk yon kouvèti po dofen, e yo va fè pase antre poto li yo nan wondèl yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Yo va pran tout zouti a sèvis yo avèk sila yo fè sèvis nan sanktyè a. Yo va mete yo nan yon twal ble, kouvri yo avèk yon kouvèti po dofen, e mete yo sou ankadreman an. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Yo va retire sann dife ki sou lotèl la, e yo va kouvri lotèl la avèk yon twal mov. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Yo va anplis mete sou li tout zouti li yo avèk sila yo sèvi e ki gen korespondans avèk li; veso dife yo, fouch avèk pèl yo, ak basen yo, tout zouti lotèl la. Epi yo va fè l kouvri avèk yon po dofen, e fè poto li yo pase antre. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Lè Aaron avèk fis li yo fin kouvri bagay sen yo avèk tout sa ki founi sanktyè yo, lè kan an prèt pou sòti, apre sa, fis Kehath yo va vini pou pote yo; men fòk yo pa touche bagay sen yo pou yo pa mouri. Sa yo se bagay nan Tant Asanble a ke fis Kehath yo va pote. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Devwa a Éléazar, fis a Aaron an, prèt la, se lwil pou limyè a, lansan santi bon an, ofrann sereyal ki pa janm sispann nan ak lwil onksyon an—lesansyèl tabènak la avèk tout sa ki ladann yo, sanktyè a avèk sa ki founi li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","SENYÈ a te pale avèk Moïse ak Aaron. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Pa kite tribi a Kehath yo vin koupe retire pami Levit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Men fè sa ak yo pou yo kapab viv, e pou yo pa mouri lè yo vin pwoche bagay ki sen pase tout bagay yo: Aaron avèk fis li yo va antre bay yo chak travay pa yo, avèk chaj yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","men yo pa pou antre pou wè sa ki sen an, menm pou yon moman, oswa yo va mouri. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Pran yon chif kontwòl nan fis Guerschon yo selon lakay papa pa yo, ak papa fanmi pa yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","soti nan trantan oswa plis jiska senkantan, ou va konte yo; tout moun ki antre pou fè sèvis, pou fè travay nan Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Sa se sèvis a fanmi Gèchonit yo, pou sèvi e pou pote: ");
INSERT INTO hatbsa_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Yo va pote rido a tabènak la, Tant Asanble a avèk kouvèti li, kouvèti po dofen ki sou li a, ak rido pòtay a Tant Asanble a, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","bagay pandye ki sou galeri a, rido a ki pou pòtay galeri a ki antoure tabènak la avèk lotèl la, kòd pa yo avèk tout bagay ki pou sèvis la; epi tout sa ki gen pou fèt, se yo ki pou fè l. Yo va sèvi andedan. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tout sèvis a fis Gèchonit yo, nan tout chaj ak tout travay yo, yo va fèt selon kòmand Aaron avèk fis li yo. Ou va dirije yo selon devwa yo nan tout chaj yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Sa se sèvis a fanmi Gèchonit yo nan Tant Asanble a, e devwa yo va anba direksyon a Ithamar, fis a Aaron, prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Selon fis Merari yo, ou va konte yo pa fanmi yo, pa lakay papa pa yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","soti nan trantan oswa plis jis rive nan laj senkantan, ou va konte yo, yo chak ki antre pou fè sèvis Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Alò, se sa ki devwa pou chaj pa yo, pou tout sèvis pa yo nan Tant Asanble a: planch a tabènak la avèk travès li yo, pilye li yo avèk baz reseptikal yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","pilye ki antoure galeri a ak baz reseptikal pa yo, pikèt ak kòd yo, avèk tout bagay pou sèvi ladann yo. Ou va chwazi chak moun pa non li, pou bagay ke li gen pou pote yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Sa se sèvis fanmi a fis Merari yo selon tout sèvis pa yo nan Tant Asanble a, anba direksyon a Ithamar, fis a Aaron, prèt la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Alò, Moïse ak Aaron avèk chèf asanble yo te konte fis Koatit yo selon fanmi yo e selon lakay a papa pa yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","soti nan trantan anplis menm pou rive nan senkantan, tout sila ki te antre sèvis pou travay nan Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Mesye pa yo ki te konte pa fanmi pa yo se te de-mil-sèt-san-senkant (2,750). ");
INSERT INTO hatbsa_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Sila yo se mesye yo ki te konte pami fis Koatit yo, tout sila ki t ap sèvi nan Tant Asanble a, ke Moïse avèk Aaron te konte selon kòmandman SENYÈ a, selon Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Mesye konte pa fis Gèchonit yo pa fanmi pa yo e pa lakay fanmi pa yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","soti nan trantan oswa plis menm jiska laj senkantan, tout sila ki te antre nan travay nan Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Mesye ki te konte pa fanmi pa yo, pa lakay papa pa yo se te de-mil-sis-san-trant (2,630). ");
INSERT INTO hatbsa_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Sila yo se mesye ki te konte nan fanmi a fis Guerschon yo, tout sila ki te sèvi nan Tant Asanble a, ke Moïse avèk Aaron te konte selon kòmandman a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Mesye konte nan fanmi a fis Merari yo pa fanmi pa yo, pa lakay papa pa yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","soti nan trantan oswa plis, jis rive nan laj senkantan, tout moun ki te antre nan sèvis pou fè travay nan Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Mesye ki te konte pa fanmi pa yo se te twa-mil-de-san (3,200). ");
INSERT INTO hatbsa_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Sila yo se mesye ki te konte nan fanmi a fis Merari yo, ke Moïse avèk Aaron te konte selon kòmandman SENYÈ a, selon Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tout mesye konte a Levit yo, ke Moïse avèk Aaron ak chèf Israël yo te konte selon fanmi yo e selon lakay a papa pa yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","soti nan trantan oswa plis jiska senkantan, tout moun ki te konn antre pou fè travay sèvis ak travay pote nan Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Mesye konte yo te ui-mil-senk-san-katreven (8,580). ");
INSERT INTO hatbsa_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Selon kòmandman SENYÈ a, selon Moïse, yo te konte, yo chak selon sèvis oswa pote yo te fè. Konsa sila yo se te mesye ki te konte yo, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Kòmande fis Israël yo pou yo voye fè kite kan an chak moun lalèp ak tout sila ki gen ekoulman yo, oswa chak moun ki pa pwòp akoz a yon moun mouri. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","“Nou va voye ale ni gason, ni fanm. Nou va voye yo deyò kan an pou yo pa konwonpi kan pa yo a, kote Mwen rete nan mitan yo a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Fis Israël yo te fè sa, e yo te voye yo deyò kan an; jis jan ke SENYÈ a te pale avèk Moïse la, se konsa ke fis Israël yo te fè. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Alò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Pale avèk fis Israël yo: ‘Lè yon nonm, oswa yon fanm fè yon lòt mal, aji avèk mank lafwa kont SENYÈ a, e moun sa a koupab, ");
INSERT INTO hatbsa_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","alò, li va konfese peche ke li te fè yo; li va peye pou tò ke li te fè a, li va peye yon senkyèm nan valè donmaj la anplis, e li va bay sa a sila ke li te fè tò a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Men si nonm nan pa gen relasyon pou resevwa pèyman, pèyman ki fèt pou tò a, li va oblije ale bay SENYÈ a pou prèt la, ansanm avèk belye ekspiyatwa ki pou fè ekspiyasyon pou li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Tout don ki apatyen a kado sen a fis Israël yo, ke yo ofri a prèt la, va pou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Konsa kado a chak moun va pou li; nenpòt bagay ke nenpòt moun bay a prèt la, li va vin pou li.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Alò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Pale avèk fis Israël yo e di yo: ‘Si madanm a yon nonm vin vire, e li vin enfidèl anvè li, ");
INSERT INTO hatbsa_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","epi yon lòt gason vin antre nan li, epi si sa kache a zye mari li, sa rete an kachèt, malgre ke li te konwonpi tèt li, men pa gen temwayaj kont li ni li pa t kenbe nan zak la, ");
INSERT INTO hatbsa_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","si yon espri jalouzi vin antre sou nonm nan, e si li jalou pou madanm li, e li te konwonpi tèt li a, oswa si yon espri jalouzi vin sou li e li jalou lè li pa t vrèman konwonpi tèt li, ");
INSERT INTO hatbsa_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","mesye a, alò, va mennen madanm li devan prèt la. Konsa, li va mennen kòm ofrann pou li yon dizyèm efa nan lòj moulen an. Li pa pou vide lwil sou li, ni mete lansan sou li, paske li se yon ofrann sereyal de jalouzi, yon ofrann sereyal pou sonje, pou pa bliye inikite. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“‘Alò, prèt la va mennen li vin toupre li, e fè l kanpe devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Prèt la va pran dlo sen an nan yon veso fèt an ajil. Li va pran kèk nan poud ki atè nan tabènak la, e li va mete nan dlo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Konsa, prèt la va fè fanm nan kanpe devan SENYÈ a, kite très cheve tèt a fanm nan vin desann, mete ofrann sonje a nan men li, ki se ofrann sereyal jalouzi a, pandan prèt la kenbe dlo anmè ki pote madichon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Prèt la va fè fanm nan sèmante. Li va di li: “Si nanpwen gason ki te kouche avèk ou, si ou pa t vin vire pou antre nan sa ki pa pwòp, alò akoz ou anba otorite mari ou, rete san afekte pa dlo anmè sa a ki mennen yon madichon. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Sepandan, si ou te vin vire, akoz ou anba otorite mari ou, si ou te konwonpi tèt ou, e yon lòt gason ki pa mari ou te kouche avèk ou,” ");
INSERT INTO hatbsa_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","(alò, prèt la va fè fanm nan fè sèman madichon an, e prèt la va di a fanm nan): “Ke SENYÈ a fè ou modi, yon madichon pami pèp ou a lè SENYÈ a fè kwis ou vin pouri pou disparèt, e vant ou vin anfle; ");
INSERT INTO hatbsa_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","epi dlo sa a ki pote yon madichon va antre nan vant ou, fè vant ou anfle e fè kwis ou vin pouri e disparèt.” Konsa, fanm nan va di: “Amen, Amen.” ");
INSERT INTO hatbsa_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Epi prèt la va ekri madichon sa yo sou yon woulo papye, e li va lave fè yo sòti nan dlo anmè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Epi li va fè fanm nan bwè dlo anmè ki pote madichon an, pou dlo ki pote madichon an kab antre nan li e li va fè l vin anmè. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Prèt la va pran ofrann sereyal pou jalouzi a nan men fanm nan, e li va balanse li devan SENYÈ a pou mennen li vè lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Konsa, prèt la va pran yon men plen nan ofrann sereyal la kòm ofrann tout moun sonje, li va ofri li anlè nan lafimen sou lotèl la, e apre, li va fè fanm nan bwè dlo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Lè li fin fè li bwè dlo a, alò li va vin rive, ke si li te konwonpi tèt li, li pa t kenbe bòn fwa avèk mari li, ke dlo ki mennen madichon an kab antre nan li pou fè l vin anmè a, vant li va vin anfle, kwis li va vin pouri, e fanm nan va devni yon madichon pami pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Men si fanm nan pa t konwonpi tèt li e li te pwòp, li va, alò, lib e li va fè pitit. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“‘Sa se lalwa jalouzi a: lè yon fanm, anba otorite mari li, vin vire e konwonpi tèt li, ");
INSERT INTO hatbsa_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","oswa lè yon espri jalouzi vin sou yon mesye, e li vin jalou pou madanm li. Li va, alò, fè fanm nan kanpe devan SENYÈ a, e prèt la va aplike tout lwa sa a anvè li. ");
INSERT INTO hatbsa_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Anplis, mesye a va lib, san koupabilite, men fanm nan va pote koupabilite pa li a.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Ankò, SENYÈ a te pale avè Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Pale avèk fis Israël yo e di yo: ‘Lè yon nonm oswa yon fanm fè yon ve, ve a yon Nazareyen, pou dedye tèt li bay SENYÈ a, ");
INSERT INTO hatbsa_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","li va refize diven avèk bwason fò. Li pa pou bwè vinèg, kit li fèt avèk diven kit bwason fò, ni li p ap bwè ji rezen, ni manje rezen, ni fre, ni sèch. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Tout jou apa sa yo, li pa pou manje anyen ki pwodwi pa pye rezen, soti nan grenn li yo, jis rive nan po li. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“‘Tout jou yo, pandan ve apa li a, okenn razwa p ap pase sou tèt li. Li va sen jiskaske jou li yo vin akonpli pou sa li te separe tèt li bay SENYÈ a. Li va kite cheve tèt li vin long. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“‘Tout jou a separasyon li yo, li pa pou pwoche yon mò. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Li pa pou fè tèt li pa pwòp ni pou papa li, ni manman li, pou frè li, oswa pou sè li, lè yo ta mouri, akoz separasyon li pou Bondye poze sou tèt li. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Tout jou a separasyon li yo, li va sen a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“‘Men si yon nonm mouri sibitman bò kote li, e li konwonpi tèt cheve ki se apa li a, alò, li va pase razwa sou tèt li nan jou ke li vin pwòp la.Li va pase razwa sou li nan setyèm jou a. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Konsa, nan dizyèm jou a, li va pote de toutrèl oswa de jenn pijon vè prèt la, nan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Prèt la va ofri youn kòm yon ofrann peche a, e lòt la kòm yon ofrann brile, epi fè ekspiyasyon pou li konsènan peche li, akoz mò a. Epi nan menm jou sa a, li va konsakre tèt li, ");
INSERT INTO hatbsa_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","epi li va dedye a SENYÈ a jou li yo kòm yon Nazareyen, e li va mennen yon mal mouton nan laj 1 nan oswa plis kòm yon ofrann koupab. Men jou tan pase yo va vin anile akoz tan separasyon li an te vin konwonpi. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“‘Alò, sa se lalwa a yon Nazareyen. Lè jou separasyon yo vin fini, li va mennen ofrann nan nan pòtay a tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Li va prezante ofrann li an bay SENYÈ a: yon mal mouton laj 1 nan san defo kòm yon ofrann brile, yon mouton femèl laj 1 nan san defo kòm yon ofrann peche, ak yon belye san defo kòm yon ofrann lapè, ");
INSERT INTO hatbsa_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","epi yon panye gato san ledven fèt avèk farin fen, mele avèk lwil, ofrann sereyal, ak galèt san ledven kouvri avèk lwil, ansanm avèk ofrann pa yo, ak ofrann bwason pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“‘Alò, prèt la va prezante yo devan SENYÈ a. Li va ofri ofrann peche pa li a avèk ofrann brile pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Li va osi ofri belye a kòm yon ofrann sakrifis lapè bay SENYÈ a, ansanm avèk yon panye gato san ledven. Prèt la va osi ofri ofrann sereyal li avèk ofrann bwason li. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“‘Alò, apre sa, Nazareyen an va pase razwa sou tèt cheve dedye pa li nan pòtay a tant asanble a. Li va pran cheve dedye a tèt li a, e mete li sou dife ki anba ofrann sakrifis lapè yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“‘Prèt la va pran zepòl belye a lè li fin bouyi, ak yon gato san ledven sòti nan panye a, yon galèt san ledven, e li va mete yo sou men a Nazareyen an lè l fin pase razwa a sou cheve dedye li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Konsa, prèt la va balanse yo kòm yon ofrann balanse vè lotèl la devan SENYÈ a. Li sen pou prèt la, ansanm avèk pwatrin ki ofri pa balanse a e kwis ki ofri pa leve anlè a. Apre Nazareyen an kapab bwè diven an. ");
INSERT INTO hatbsa_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“‘Sa se lalwa a Nazareyen ki fè ve ofrann li bay SENYÈ a, an akò avèk separasyon li, anplis tout lòt bagay ke li gen posibilite fè, selon ve ke li te fè a. Konsa, li va fè selon lalwa separasyon li an.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Pale avèk Aaron ak fis li yo pou di: ‘Konsa, nou va beni fis Israël yo. Nou va di yo: ");
INSERT INTO hatbsa_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","SENYÈ a beni nou e kenbe nou; ");
INSERT INTO hatbsa_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","SENYÈ a fè limyè figi li limen sou nou; epi fè gras anvè nou; ");
INSERT INTO hatbsa_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","SENYÈ a fè vizaj li vin gade nou, e bannou lapè.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Se konsa yo va rele non Mwen pou fis Israël yo, e se konsa Mwen va beni yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Alò nan jou ke Moïse te fin monte tabènak la, li te onksyone li, e li te konsakre li avèk tout zouti li yo, ak lotèl la, avèk tout zouti li yo. Li te onksyone yo e li te konsakre yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Chèf Israël yo, chèf lakay zansèt papa pa yo, te fè yon ofrann. Yo menm te chèf a tribi yo. Se te sila ki te sou mesye kontwolè yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Lè yo te mennen ofrann pa yo devan SENYÈ a, sis kabwèt kouvri, avèk douz bèf kabwèt, yon kabwèt pou chak de chèf, yon bèf pou chak nan yo, epi yo te prezante yo devan tabènak la. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Konsa, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Aksepte bagay sa yo pou yo menm, pou yo kapab sèvi nan sèvis Tant Asanble a, e ou va bay yo a Levit yo, a chak mesye selon sèvis pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Konsa, Moïse te pran kabwèt yo avèk bèf yo, e li te bay yo a Levit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","De kabwèt ak kat bèf, li te bay a fis Guerschon yo, selon sèvis pa yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","epi kat kabwèt avèk uit bèf, li te bay a fis Merari yo, selon sèvis pa yo, anba direksyon a Ithamar, fis a Aaron, prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Men li pa t bay a fis Kehath yo akoz sèvis pa yo se te sèvis bagay sen ke yo te pote sou zepòl yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Chèf yo te ofri ofrann dedikasyon an pou lotèl la lè li te fin onksyone. Konsa chèf yo te ofri ofrann yo devan lotèl la. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","SENYÈ a te di a Moïse: “Kite yo prezante ofrann pa yo, yon chèf chak jou, pou dedikasyon lotèl la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Alò, sila ki te prezante ofrann li nan premye jou a, se te Nachschon, fis a Amminadab nan tribi Juda a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ofrann pa li a se te yon plato fèt an ajan avèk yon pèz de san trant sik, yon bòl fèt an ajan a swasann-dis sik, selon sik a sanktyè a, tou de ki plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","yon kiyè fèt an lò a dis sik ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","yon towo, yon belye, yon mal mouton nan laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","yon mal kabrit kòm ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","epi pou sakrifis ofrann lapè a, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Nachschon, fis a Amminadab la. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Nan dezyèm jou a Nethaneel, fis a Tsuar a, chèf a Issacar a, te prezante yon ofrann. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Li te prezante kòm ofrann li yon kiyè fèt an ajan avèk yon pèz de san-trant sik, yon bòl an ajan a swasann-dis sik, selon sik a sanktyè a, tou de te plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","yon kiyè soup an lò a dis sik ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Yon towo, yon belye, yon mal mouton nan laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","yon mal kabrit pou yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","epi pou sakrifis ofrann lapè a, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Nan twazyèm jou a, se te Éliab fis a Hélon an, chèf a Zabulon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ofrann pa li a se te yon plato an ajan avèk yon pèz de trant sik, yon bòl an ajan a swasann-dis sik, selon sik a sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","yon kiyè soup an lò a dis sik plen avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","yon jenn towo, yon belye, yon mal mouton nan laj 1 nan, pou yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Yon mal belye pou yon ofrann peche, ");
INSERT INTO hatbsa_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","epi pou sakrifis ofrann lapè a, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Éliab la, fis a Hélon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Nan katriyèm jou a, se te Élitsur, fis a Schedéur a, chèf a fis Ruben yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ofrann pa li a se te yon plato an ajan avèk pèz de san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","yon kiyè nan dis sik plen avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","yon towo, yon belye, yon mal mouton nan laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","yon mal kabrit kòm yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","epi pou ofrann sakrifis lapè a, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Élitsur a, fis a Schedéur a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Nan senkyèm jou a, se te Schelumiel, fis a Schedéur a, chèf a fis Siméon yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ofrann pa li a, se te yon plato an ajan avèk yon pèz de san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de nan yo plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","yon towo, yon belye, yon mal mouton nan laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","yon mal kabrit pou yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Schelumiel la, fis a Schedéur a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Nan sizyèm jou a, se te Élisaph, fis a Déuel la, chèf a fis Gad yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ofrann pa li a se te yon plato an ajan nan pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de nan yo plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","yon kiyè soup an lò nan dis sik ranpli avèk lansan ");
INSERT INTO hatbsa_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","yon towo, yon belye, yon mal mouton nan laj 1 nan kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","yon mal kabrit kòm yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Élisaph la, fis a Déuel la. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Nan setyèm jou a, se te Élischama fis a Ammihud la, chèf a fis Ephraïm yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ofrann pa li a se te yon plato an ajan avèk yon pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","yon towo, yon belye, yon mal mouton nan laj 1 nan kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","yon mal kabrit pou yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Élischama a, fis a Ammihud la. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Nan uityèm jou a, se te Gamaliel, fis a Pedahtsur a, chèf a fis Mannasé yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ofrann pa li a se te yon plato an ajan avèk yon pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","yon towo, yon belye, yon mal mouton nan laj 1 nan kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","yon mal kabrit pou yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann Gamaliel, fis a Pedahtsur a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Nan nevyèm jou a, se te Abidan fis a Guideoni a, chèf a fis Benjamin yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ofrann pa li a se te yon plato an ajan avèk yon pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","yon towo, yon belye, yon mal mouton nan laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","yon mal kabrit pou yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Abidan, fis a Guideoni a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Nan dizyèm jou a, se te Ahiézer fis a Ammischaddaï a, chèf a fis Dan yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ofrann pa li a se te yon plato an ajan avèk yon pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","yon towo, yon belye, yon mal mouton nan laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","yon mal kabrit kòm yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Ahiézer, fis a Ammischaddaï a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Nan onzyèm jou a, se te Paguiel, fis a Ocran an, chèf a fis Acer yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ofrann pa li a se te yon plato an ajan avèk yon pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","yon towo, yon belye, yon mal mouton avèk laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","yon mal kabrit kòm yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Paguiel, fis a Ocran an. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Nan douzyèm jou a, se te Ahira, fis a Énan an, chèf a fis Nephtali yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ofrann pa li a se te yon plato an ajan avèk yon pèz san-trant sik, yon bòl an ajan nan swasann-dis sik, selon sik sanktyè a, tou de plen avèk farin fen mele avèk lwil pou yon ofrann sereyal; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","yon kiyè soup an lò nan dis sik, ranpli avèk lansan; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","yon towo, yon belye, yon mal mouton avèk laj 1 nan, kòm yon ofrann brile; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Yon mal kabrit kòm yon ofrann peche; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","epi pou ofrann sakrifis lapè yo, de bèf, senk belye, senk mal kabrit, senk mal mouton nan laj 1 nan. Sa se te ofrann a Ahira, fis a Enam an. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Sa se te ofrann dedikasyon pou lotèl la pa chèf Israël yo nan jou lotèl la te onksyone a: douz plato an ajan, douz bòl an ajan, douz kiyè soup ki fèt an lò, ");
INSERT INTO hatbsa_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","chak plato ajan te peze san-trant sik e chak bòl swasann-dis; tout ajan a zouti yo se te de-mil-kat-san (2,400) sik, selon sik sanktyè a; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","douz kiyè soup an lò, plen lansan, ki peze dis sik chak, selon sik a sanktyè a, tout lò a kiyè yo te fè san-ven (120) sik. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Tout bèf pou ofrann brile a, douz towo, belye yo douz, mal mouton nan laj 1 nan avèk ofrann sereyal pa yo, e douz mal kabrit kòm ofrann peche a; ");
INSERT INTO hatbsa_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","epi tout bèf pou sakrifis lapè yo, venn-kat towo, belye yo, swasant, mal kabrit yo, swasant, mal mouton nan laj 1 nan yo, swasant. Sa se te ofrann dedikasyon lotèl la apre li te fin onksyone a. ");
INSERT INTO hatbsa_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Alò, lè Moïse te antre nan Tant Asanble a pou pale avèk Li, li te tande vwa a pale avèk li soti anwo twòn pwopiyatwa a ki te sou lach temwayaj la, ki sòti depi nan antre cheriben yo; e Li te pale avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Alò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Pale avèk Aaron e di li: ‘Lè ou monte lanp yo, sèt lanp sa yo va bay limyè pa devan chandelye a.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Konsa, Aaron te fè sa. Li te monte lanp pa li a pa devan chandelye a, jis jan SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Men kòman mendèv chandelye a te ye; fèt avèk lò ki bat, soti nan baz li jis rive nan flè yo, li te yon travay ki bat. Selon modèl ke SENYÈ a te montre a Moïse la, konsa li te fè chandelye a. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Ankò SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Pran Levit yo soti nan fis Israël yo e fè yo vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Se konsa ou va fè pou fè yo vin pwòp: flite dlo ki pirifye sou yo. Kite yo pase razwa sou tout kò yo e lave rad yo; epi yo va vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Konsa, kite yo pran yon towo avèk ofrann sereyal li a, farin fen mele avèk lwil; epi yon dezyèm towo, ou va pran kòm yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Alò, ou va prezante Levit yo devan Tant Asanble a. Ou va osi rasanble tout kongregasyon a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ou va prezante Levit yo devan SENYÈ a. Fis Israël yo va poze men yo sou Levit yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","epi Aaron va prezante Levit yo devan SENYÈ a kòm yon ofrann balanse vè lotèl la, soti nan fis Israël yo, pou yo kapab kalifye pou fè sèvis SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Alò, Levit yo va poze men yo sou tèt a towo yo, epi ou va ofri youn kòm yon ofrann peche, e lòt la kòm yon ofrann brile bay SENYÈ a pou fè ekspiyasyon pou Levit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ou va fè Levit yo kanpe devan Aaron ak devan fis li yo pou prezante yo kòm yon ofrann balanse vè lotèl la bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Konsa, ou va separe Levit yo soti nan fis Israël yo, e Levit yo va vin pou Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Epi apre sa, Levit yo kapab antre pou fè sèvis nan Tant Asanble a. Konsa, ou va netwaye yo e prezante yo kòm yon ofrann balanse vè lotèl la; ");
INSERT INTO hatbsa_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","paske yo te vin pou Mwen nèt soti nan fis Israël yo. Mwen te pran yo pou Mwen menm nan plas a tout sila ki sòti nan vant yo, premye ne nan tout fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Paske tout gason premye ne pami fis Israël yo se pou Mwen, pami moun yo, ak pami bèt yo. Nan jou ke M te frape tout premye ne nan peyi Égypte yo, Mwen te sanktifye yo pou Mwen menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Men Mwen te pran Levit yo nan plas a chak premye ne pami fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mwen te bay Levit yo kòm yon kado bay Aaron ak fis li yo soti pami fis Israël yo, pou ranpli sèvis a fis Israël yo nan Tant Asanble a, e pou fè ekspiyasyon pou fis Israël yo, jis pou pa vin gen gwo epidemi pami fis Israël yo akoz ke yo vin pwoche toupre sanktyè a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Konsa Moïse avèk Aaron, ak tout kongregasyon a fis Israël yo te fè pou Levit yo. Selon tout sa ke SENYÈ a te kòmande Moïse konsènan Levit yo, konsa fis Israël yo te fè yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levit yo tou, te pirifye yo menm de peche e te lave rad yo. Aaron te prezante yo kòm yon ofrann balanse vè lotèl la devan SENYÈ a. Aaron, osi, te fè ekspiyasyon pou yo, pou fè yo vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Epi apre Levit yo te antre pou fè sèvis pa yo nan Tant Asanble a, devan Aaron ak devan fis li yo: jis jan ke SENYÈ a te kòmande Moïse konsènan Levit yo, se konsa yo te fè pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Sa se lòd ki aplike pou Levit yo: soti nan laj venn-senkan e plis, yo va antre pou fè sèvis nan travay a Tant Asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Men nan laj a senkantan, yo va pran retrèt nan sèvis travay la. Yo p ap travay ankò. ");
INSERT INTO hatbsa_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Sepandan, yo va asiste frè yo nan Tant Asanble a, pou kenbe devwa yo, men yo pa pou travay yo menm. Konsa ou va aji avèk Levit yo konsènan devwa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","SENYÈ a te pale avèk Moïse nan dezè Sinaï a, nan premye mwa nan dezyèm ane a lè yo te fin sòti nan Égypte la. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Alò, kite fis Israël yo obsève fèt Pak la nan lè ki apwente pou li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Nan katòzyèm jou nan mwa sa a, nan aswè avan li fènwa, nou va obsève li nan lè apwente a. Nou va obsève li avèk tout règleman e avèk tout òdonans li yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Konsa, Moïse te pale ak fis Israël yo pou obsève Pak la. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Yo te obsève Pak la nan premye mwa, nan katòzyèm jou a, nan aswè lè li fenk kòmanse fènwa, nan dezè Sinaï a. Selon tout sa ke SENYÈ a te kòmande Moïse yo, se konsa fis Israël yo te fè. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Men te gen kèk mesye ki pa t pwòp akoz yon mò. Akoz sa, yo pa t kab obsève Pak la nan jou sa a. Konsa yo te vin devan Moïse avèk Aaron nan jou sa a. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Mesye sa yo te di li: “Malgre nou pa pwòp akoz mò a, poukisa nou anpeche vin prezante ofrann SENYÈ a nan lè apwente pami fis Israël yo?” ");
INSERT INTO hatbsa_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Konsa, Moïse te reponn yo: “Tann, e mwen va koute sa ke SENYÈ a va kòmande pou nou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Epi SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Pale avèk fis Israël yo pou di: ‘Si nenpòt nan nou, oswa nan desandan nou yo vin pa pwòp akoz yon mò, oswa se nan yon vwayaj, malgre sa, li kapab obsève Pak SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Nan dezyèm mwa a, sou katòzyèm jou a, nan aswè lè l fenk kòmanse fènwa, yo va obsève li. Yo va manje li avèk pen san ledven ak zèb anmè. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Yo p ap kite anyen ladann pou rive nan maten, ni kase okenn zo ladann. Selon tout règleman a Pak la, yo va obsève li. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Men mesye ki pwòp e ki pa nan yon vwayaj, ki malgre sa, neglije obsève Pak la, moun sa a va vin koupe retire de pèp li a. Paske li pa t prezante ofrann bay SENYÈ a nan lè chwazi a. Nonm sila a va pote peche li. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“‘Si yon etranje demere pami nou e li obsève Pak SENYÈ a, li gen pou fè l selon règleman a Pak la, ak selon òdonans li. Nou va genyen yon sèl règleman, ni pou etranje, ni pou natif peyi a.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Alò, nan jou ke tabènak la te monte a, nwaj te vin kouvri tabènak la ak tant temwayaj la, e nan aswè, li te tankou aparans dife sou tabènak la, jis rive nan maten. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Se konsa li te ye tout tan. Nwaj te vin kouvri li nan lajounen, e aparans dife a nan lannwit. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Nenpòt lè nwaj te leve sou tant lan, fis Israël yo te leve vwayaje. Nan plas kote nwaj la te vin poze a, se la fis Israël yo te kanpe fè kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Sou kòmand a SENYÈ a, fis Israël yo te pati, e sou kòmand a SENYÈ a, yo te fè kan an. Tout tan ke nwaj la te poze sou tabènak la, yo te rete nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Menm lè nwaj la te fè reta sou tabènak la pandan anpil jou, fis Israël yo te kenbe lòd SENYÈ a. Yo pa t pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Si, pafwa nwaj la te rete kèk jou sou tabènak la, selon kòmand SENYÈ a, yo te rete nan kan an. Epi selon kòmand SENYÈ a, yo te vin pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Si, pafwa nwaj la te rete soti nan aswè pou jis rive nan maten, lè nwaj la te leve nan maten, yo te deplase; oswa, si li te rete nan lajounen ak lannwit, nenpòt lè ke nwaj la te leve a, yo te vin pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Sof ke se te pou de jou, oswa yon mwa, oswa 1 nan ke nwaj la te mize sou tabènak la, depi li rete anwo li, fis Israël yo te rete nan kan an. Yo pa t pati. Men lè li te vin leve, yo te pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ak kòmand a SENYÈ a, yo te fè kan an, e nan kòmand a SENYÈ a, yo te pati. Yo te kenbe lòd SENYÈ a selon kòmand SENYÈ a, selon Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Senyè a te pale avèk Moïse. Li te di li: ");
INSERT INTO hatbsa_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fè pou ou menm de twonpèt an ajan, yon zèv ajan ki bat, ou va fè yo. Konsa, ou va sèvi ak yo pou fè tout asanble a rasanble, e pou fè kan yo pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Lè toude vin sone, tout kongregasyon an va rasanble yo menm anvè ou nan pòtay a tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Men si se yon sèl ki sone, alò, se chèf yo, tèt a dè milye an Israël yo ki va rasanble devan ou. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Lè nou sone pou avèti, kan ki rete nan kote lès yo, va pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Lè nou sone pou avèti yon dezyèm fwa, kan ki nan kote sid yo, va pati. Yon son avèti va soufle pou yo pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Sepandan, lè nou ap reyini asanble a, ou va soufle twonpèt yo, men pa avèk son avèti yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Anplis, se prèt yo, fis a Aaron yo ki va soufle twonpèt yo. Konsa, sa va pou nou yon règleman pou tout tan pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Lè nou fè lagè nan peyi nou kont advèsè ki vin atake nou yo, alò, nou va sone yon son avèti avèk twonpèt yo, pou nou kapab sonje devan SENYÈ a, Bondye nou an, e vin sove de lènmi nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","“Osi, nan jou kè kontan yo, nan fèt apwente nou yo, ak nan premye jou nan mwa nou yo, nou va sone twonpèt yo sou ofrann brile nou yo, sou ofrann sakrifis lapè yo. Yo va tankou yon son pou nou menm devan Bondye nou an. Mwen se SENYÈ a, Bondye nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Alò, nan dezyèm ane a, nan dezyèm mwa a, nan ventyèm nan mwa a, nwaj la te leve pa anwo tabènak temwayaj la. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Konsa, fis Israël yo te pati nan vwayaj yo soti nan dezè a Sinaï a. Epi nwaj la te vin tann nan dezè Paran an. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Konsa, yo te derape pou premye fwa selon kòmandman SENYÈ a, selon Moïse. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Drapo kan Juda a selon lame pa yo, te sòti avan, avèk Nachschon, fis a Amminadab la sou lame pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nethaneel, fis a Tsuar a, te sou lame tribi a fis Issacar yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab, fis a Hélon an, te sou lame tribi a fis Zabulon an, ");
INSERT INTO hatbsa_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Tabènak la te vin demonte, epi fis a Guerschon yo avèk fis a Merari yo, ki t ap pote tabènak la, te pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Apre, drapo kan Ruben an, selon lame pa yo te pati avèk Élitsur, fis a Schedéur a sou lame pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Schelumiel, fis a Tsurischaddaï a te sou lame tribi a fis Siméon yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Élisaph, fis a Déuel la te sou lame tribi a fis Gad yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Epi Kehath yo te derape. Yo t ap pote bagay sen yo. Lòt yo te gen tan monte tabènak la avan ke yo te rive. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Apre, drapo a kan Ephraïm nan te pati, selon lame pa yo. Élischama, fis a Ammihud la te sou tèt lame pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaliel, fis a Pedahstsur te sou tèt lame tribi a fis Manassé yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abidan, fis a Guideoni te sou tèt lame a fis Benjamin yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Drapo kan fis a Dan nan, selon lame yo, te fòme gad an aryè pou tout kan yo. Yo derape avèk Ahiézer, fis a Ammischaddaï sou tèt lame pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Paguiel, fis a Ocran an te sou tèt lame tribi a fis Aser yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahira, fis a Énan an, te sou tèt lame tribi a fis Nephtali yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Konsa te lòd vwayaj la a pou fis Israël yo selon lame pa yo, lè yo te vin pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moïse te di a Hobab, fis a Réuel la, Madyanit lan, bòpè a Moïse la: “Nou ap pati pou kote ke SENYÈ a te di a, ‘Mwen va bannou li.’ Vini avèk nou, e nou va fè ou byen; paske SENYÈ a te pwomèt sa ki bon konsènan Israël.” ");
INSERT INTO hatbsa_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Men li te di li: “Mwen p ap vini, men olye de sa, m ap ale nan peyi pa m avèk fanmi pa mwen yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Alò li te di: “Souple, pa kite nou, kòmsi ou konnen kote nou dwe fè kan nan dezè a, e ou va pou nou tankou zye nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Se konsa sa va ye, ke si ou ale avèk nou, ke nenpòt sa ki bon ke SENYÈ a fè pou nou, nou va fè pou ou tou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Konsa yo te pati soti nan mòn SENYÈ a, yon vwayaj twa jou avèk lach temwayaj SENYÈ a ki te vwayaje pandan twa jou devan yo pou chache yon kote pou yo kab poze. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Nwaj SENYÈ a te sou yo nan lajounen lè yo te kite kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Epi li te vin rive ke lè lach la te derape ke Moïse te di: “Leve O SENYÈ! Kite sila ki rayi Ou yo Sove ale devan Ou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Lè l te vin poze li te di: “Retounen, O SENYÈ a vè bokou milye de Israël yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Alò, pèp la te devni kòm sila ki plenyen zafè pwoblèm nan zòrèy a SENYÈ a. Lè SENYÈ a te tande sa, kòlè li te vin limen, dife SENYÈ a te brile pami yo. Li te detwi kèk nan yo nan zòn deyò kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Pou sa, pèp la te kriye fò bay Moïse. Moïse te priye bay SENYÈ a, e dife a te ralanti. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Konsa, non a kote sa a te rele Tabeéra akoz dife SENYÈ a ki te brile pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Sanzave nan mele yo ki te pami yo te gen lide voras. Menm fis Israël yo tou te kriye dlo nan zye ankò. Yo te di: “Kilès k ap bannou vyann pou nou manje? ");
INSERT INTO hatbsa_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nou sonje pwason ke nou te konn manje gratis nan peyi Égypte, avèk konkonb ak melon, zonyon, ak lay; ");
INSERT INTO hatbsa_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","men koulye a, nanm nou vin sèch. Nanpwen anyen pou nou ta gade sof ke lamàn sa a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Alò, lamàn nan te tankou grenn pitimi avèk aparans gonm arabik. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Pèp la t ap fè ale retou pou ranmase li. Yo te moulen li antre de wòch moulen, oswa bat li nan yon pilon, bouyi li nan yon chodyè, epi fè gato avèk li. Li gen gou tankou gou a gato ki fèt ak lwil. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Lè lawouze te vin tonbe nan kan an pandan nwit lan, lamàn te tonbe avè l. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Alò, Moïse te tande pèp la ki t ap kriye pami tout fanmi yo, chak mesye nan pòtay a tant li. Konsa, chalè a SENYÈ a te vin limen anpil, e Moïse te malkontan. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Pou sa, Moïse te di SENYÈ a: “Poukisa Ou te tèlman di avèk sèvitè Ou a? Epi poukisa mwen pa t jwenn favè nan zye ou, ke Ou te vin mete chaj tout pèp sa a sou Mwen? ");
INSERT INTO hatbsa_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Èske se mwen menm ki te vin peple fè tout pèp sa a? Èske se mwen menm ki te fè yo vin parèt pou Ou ta di mwen: ‘Pote yo nan sen ou tankou yon fanm nouris pote yon ti bebe k ap tete, pou rive nan yon peyi ke Ou te sèmante a papa yo?’ ");
INSERT INTO hatbsa_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Kote mwen ap jwenn vyann pou bay tout pèp sa a? Paske yo kriye devan m! Yo te di: ‘Bannou vyann pou nou kapab manje!’ ");
INSERT INTO hatbsa_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mwen sèl mwen p ap kab pote tout pèp sa a; se twòp chaj pou mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Konsa, si W ap aji konsa avè m, souple touye mwen koulye a; konsa, si Mwen pa t twouve favè nan zye Ou, pa kite mwen vin wè mizè mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Konsa, SENYÈ a te di a Moïse: “Rasanble pou Mwen swasann-dis nonm ki soti nan ansyen Israël yo, pami sila a ou konnen kòm ansyen a pèp la, ak ofisyèl yo. Mennen yo nan tant asanble a e kite yo vin fè kanpe pa yo ansanm avè w la a. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Alò, Mwen va vin desann pou pale avèk ou la a. Konsa, Mwen va pran nan lespri ki sou ou a, pou mete li sou yo; epi yo va pote fado a avèk ou, pou ou pa oblije pote li ou sèl ou. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Di a pèp la: ‘Konsakre nou pou demen e nou va manje vyann; paske nou te kriye nan zòrèy SENYÈ a, e te di: “O ke yon moun bannou vyann pou nou manje! Paske nou te byen okipe an Égypte.” Konsa, SENYÈ a va bannou vyann, e nou va manje. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Nou va manje, pa pou yon jou, ni de jou, ni senk jou, ni di jou, ni ven jou, ");
INSERT INTO hatbsa_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","men yon mwa nèt, jis li vin sòti nan nen nou, e vin abominab pou nou; akoz nou te rejte SENYÈ a ki pami nou, e nou te kriye devan Li pou te di: “Poukisa nou te janmen kite Égypte?”’” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Men Moïse te di: “Pèp pami sila Mwen ye a se sis-san-mil sou pye; sepandan, Ou te di, ‘Mwen va bay yo vyann, pou yo kab manje jis yon mwa nèt.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","“Si bann mouton avèk twoupo yo ta touye pou yo èske sa ta sifi pou yo?” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","SENYÈ a te di a Moïse: “Èske pouvwa SENYÈ a limite? Koulye a, ou va wè si pawòl Mwen va vin vre pou ou oswa non.” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Konsa, Moïse te sòti deyò. Li te di pèp la pawòl SENYÈ a. Osi, li te rasanble swasann-dis gason nan ansyen pami pèp la, e li te estasyone yo antoure tant la. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Alò, SENYÈ a te vin desann nan nwaj la, e Li te pale avèk li. Li te pran nan Lespri ki te sou li a, e li te plase Li sou swasann-dis ansyen yo. Epi lè Lespri a te poze sou yo, yo te pwofetize. Men yo pa t fè sa ankò. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Men de mesye nan ansyen yo te rete nan kan an; Non a youn te Eldad, e non a lòt la te Médad. Epi Lespri a te vin rete sou yo. Yo menm te pami sila ki te anrejistre kòm ansyen yo, men ki pa t sòti pou ale nan tant lan; men yo te pwofetize nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Konsa, yon jennonm te kouri di Moïse: “Eldad avèk Médad ap pwofetize nan kan an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Epi Josué, fis a Nun nan, ki te sèvitè Moïse depi nan jenès li, te di: “Moïse, senyè mwen an, anpeche yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Men Moïse te di li: “Èske ou jalou pou tèt mwen? Pito ke tout pèp SENYÈ a te pwofèt, pou SENYÈ a ta mete Lespri Li sou yo!” ");
INSERT INTO hatbsa_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Epi Moïse te retounen nan kan an, ni li, ni ansyen Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Alò, te vin souleve yon van sòti nan SENYÈ a. Li te mennen zwazo kay sòti nan lanmè, e Li te kite yo tonbe akote kan an, anviwon distans de yon vwayaj yon jounen sou yon bò, e vwayaj a yon jounen de lòt bò a, toutotou kan an, epi plis oswa mwens de koude (twa pye) pwofondè sou sifas tè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Pèp la te pase tout jounen, tout nwit lan, ak tout jou aprè a nan ranmase zòtolan. Sila ki te ranmase mwens lan, te ranmase dis omè (ven lit), e yo te poze yo gaye pou yo toupatou nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Pandan vyann nan te toujou nan dan yo, avan yo te menm moulen li, kòlè SENYÈ a te vin limen kont pèp la, e SENYÈ a te frape pèp la avèk yon epidemi byen sevè. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Konsa, non a kote sa a te rele Kibroth Hattaava, akoz ke se ladann, yo te antere pèp ki te voras yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Soti nan Kibroth Hattaava, pèp la te ale Hazeroth, e yo te vin rete Hazeroth. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Marie avèk Aaron te vin pale kont Moïse akoz fanm Koushit ke li te marye a; paske li te marye avèk yon fanm Koushit; ");
INSERT INTO hatbsa_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Konsa, yo te di: “Èske SENYÈ a vrèman te pale sèlman ak Moïse? Èske Li pa t pale ak nou menm tou?” Epi SENYÈ a te tande sa. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Alò, nonm Moïse la te trè enb, plis pase tout moun ki te sou sifas latè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Sibitman, SENYÈ a te di a Moïse ak Aaron avèk Marie: “Nou twa a, vin sòti nan tant asanble a”. Alò, yo twa a te sòti. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Epi SENYÈ a te desann nan yon pilye nwaj. Li te kanpe nan pòtay tant asanble a, e Li te rele Aaron avèk Marie. Yo toude te vin avanse. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Li te di: “Koute pawòl Mwen koulye a: Si gen yon pwofèt pami nou, Mwen, SENYÈ a, Mwen va fè Mwen menm vin rekonèt a li menm nan yon vizyon. Mwen va pale avèk li nan yon rèv. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Se pa konsa avèk sèvitè Mwen, Moïse. Li fidèl nan tout kay Mwen; ");
INSERT INTO hatbsa_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Avèk li, Mwen pale bouch a bouch, byen klè, pa nan pawòl parabòl, epi li wè fòm SENYÈ a menm. Poukisa, konsa, nou pa t pè pou pale kont sèvitè Mwen an, kont Moïse?” ");
INSERT INTO hatbsa_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Epi kòlè SENYÈ a te brile kont yo, e Li te pati. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Lè nwaj la te kite tant lan, vwala, Marie te gen lalèp, blan tankou lanèj. Epi lè Aaron te gade, alò, Marie te gen lalèp. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aaron te di Moïse: “O senyè Mwen an! Mwen mande ou souple, pa konte peche sa a kont nou, nan sila nou te aji avèk foli a, ak nan sila nou te peche a. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","O Pa kite chè Marie rete kòm yon timoun ki fenk fèt mouri, ki sòti nan vant manman li avèk chè li mwatye manje!” ");
INSERT INTO hatbsa_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moïse te kriye fò bay SENYÈ a. Li te di: “O Bondye, geri li, mwen priye Ou!” ");
INSERT INTO hatbsa_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Men SENYÈ a te reponn Moïse: “Si papa li te sèlman krache nan figi li, èske li pa t ap pote wont li pandan sèt jou? Kite li rete fèmen pandan sèt jou deyò kan an. Apre, l ap kapab rantre ankò.” ");
INSERT INTO hatbsa_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Konsa Marie te fèmen deyò kan an pandan sèt jou, e pèp la pa t deplase jiskaske Marie te vin rantre ankò. ");
INSERT INTO hatbsa_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Apre sa a, pèp la te deplase kite Hatséroth pou te fè kan nan dezè Paran an. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Konsa, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Voye mesye ki kapab fè espyonaj nan peyi Canaran ke Mwen va bay fis Israël yo. Ou va voye yon nonm sòti nan chak tribi zansèt a papa pa yo, youn nan chèf pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Konsa, Moïse te voye yo soti nan dezè Paran an selon kòmand a SENYÈ a. Yo tout te chèf a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Sa yo, alò, se te non yo: soti nan tribi Ruben an, Schammua, fis a Zaccur a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","soti nan tribi a Siméon an: Schaphath, fis a Hori a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","pou tribi a Juda a: Caleb, fis a Jephaunné a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","pou tribi a Issacar a: Jigual, fis a Joseph la; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","pou tribi a Ephraïm nan: Hosée, fis a Nun nan ");
INSERT INTO hatbsa_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","pou tribi a Benjamin an: Palthi, fis a Raphu a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","pou tribi a Zabulon an: Gaddiel, fis a Sodi a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","pou tribi a Joseph la, tribi a Manassé a: Gaddi, fis a Sisi a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","pou tribi a Dan nan: Ammiel, fis a Guemalli a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","pou tribi a Hacer a: Sethur, fis a Micaël la; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","pou tribi a Nephtali a: Nachbi, fis a Vophsi a; ");
INSERT INTO hatbsa_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","pou tribi a Gad la: Guéuel, fis a Maki a. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Sa yo, se non a mesye ke Moïse te voye pou fè espyonaj peyi a. Men Moïse te rele Hosée, fis a Nun nan, Josué. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Lè Moïse te voye yo espyone peyi Canaan an, li te di yo: “Monte nan negev la; epi monte toujou nan peyi ti kolin yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Kontwole pou wè kijan peyi a ye, si pèp ki rete ladann nan, gen fòs, oswa si yo fèb, e si yo gen anpil, oswa pa anpil moun. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Kijan tè kote yo viv la ye, kit li bon, oswa pa bon? Epi kijan vil kote yo viv la ye, èske se kan san pwotèj, oswa avèk fò? ");
INSERT INTO hatbsa_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kijan tè a ye? Èske li rich, oswa pòv? Si gen pyebwa oswa si pa genyen? Epi fè yon efò pou pran kèk nan fwi peyi a.” Alò, se te tan ke premye rezen yo t ap vin mi. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Se konsa, yo te monte pou te fè espyonaj sou peyi a soti nan dezè a Tsin nan, jis pou rive Rehob, nan chemen Hamath (Lebo-Hamath) lan. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Lè yo te fin monte Negev, yo te rive Hébron kote Ahiman, Schéschaï ak Talmaï, desandan a Anak yo te ye a. (Alò, Hébron te bati sèt ane avan Tsoan an Égypte.) ");
INSERT INTO hatbsa_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Yo te rive nan vale Eschcol e soti la, yo te koupe yon sèl branch avèk yon sèl grap rezen; epi yo te pote li sou yon poto antre de gason avèk kèk grenad ak pye fig frans. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Kote sa a te vin rele vale a Eschcol, akoz gwo grap rezen ke fis Israël la te koupe fè desann soti la yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Yo te sòti retounen nan espyonaj peyi a, nan fen karant jou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Yo te vini vè Moïse avèk Aaron ak tout kongregasyon a fis Israël yo nan dezè Paran an, vè Kadès; epi yo te pote nouvèl la pou di a tout kongregasyon an, e pou te montre yo fwi peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Konsa, yo te pale li. Yo te di: “Nou te antre nan peyi kote nou te voye nou an. Vrèman, li koule avèk lèt ak siwo myèl, e sa a se fwi li. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","“Sepandan, pèp ki rete la yo, gen fòs, vil yo byen fòtifye, byen gwo. Anplis, nou te wè desandan Anak yo la. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Desandan a Amalèk yo ap viv nan peyi Negev la, Etyen yo, Jebizyen yo, Amoreyen yo ap viv nan mòn yo, e Kananeyen yo ap viv bò kote lanmè ak bò kote rivyè Jourdain an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Men Caleb te kalme pèp la devan Moïse e te di: “Sètènman, nou dwe monte pran posesyon a peyi a, paske nou va, anverite, konkeri li.” ");
INSERT INTO hatbsa_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Men mesye ki te monte avè l yo te di: “Nou pa kapab monte kont pèp la, paske yo twò fò pou nou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Konsa, yo te livre yon move rapò a fis Israël yo sou peyi kote yo te fè ankèt la. Yo te di: “Peyi kote nou te ale a, nan ankèt sa a, se yon peyi ki devore moun li ye, e tout pèp ke nou te wè ladann yo, se moun ki byen gran. ");
INSERT INTO hatbsa_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","La, osi, nou te wè jeyan, fis a Anak yo ki soti nan jeyan yo. Konsa, nou te vin tankou krikèt nan pwòp zye nou ak nan zye pa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Epi tout kongregasyon an te leve vwa yo pou te rele, e pèp la te kriye nan nwit lan. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Tout fis Israël yo te bougonnen kont Moïse ak Aaron. Tout kongregasyon an te di yo: “Pito ke nou te mouri nan peyi Égypte la! O pito nou te mouri nan dezè sa a! ");
INSERT INTO hatbsa_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Poukisa SENYÈ a ap mennen nou nan peyi sa a, pou tonbe anba nepe? Madanm nou yo avèk pitit nou yo va devni piyay. Èske li pa t ap pi bon pou nou pou retounen an Égypte?” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Epi yo te di youn lòt: “Annou chwazi yon chèf, pou retounen an Égypte.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Konsa, Moïse avèk Aaron te tonbe sou figi yo nan prezans a tout asanble kongregasyon a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Josué, fis a Nun lan avèk Caleb, fis a Jephaunné a, nan sila ki te fè espyonaj nan peyi a, te chire rad yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Yo te pale avèk tout kongregasyon a fis Israël yo, e te di: “Peyi ke nou te pase ladann pou fè ankèt la, se yon vrèman bon peyi. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si SENYÈ a kontan avèk nou, alò, Li va mennen nou nan peyi sa a pou bannou li—yon peyi ki koule avèk lèt ak siwo myèl. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Sèlman, pa fè rebèl kont SENYÈ a; ni pa pè pèp peyi sa a, paske, nou va devore yo. Pwoteksyon yo ale, e SENYÈ a avèk nou. Pa pè yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Men tout kongregasyon an te kòmanse lapide yo avèk kout wòch. Konsa laglwa SENYÈ a te parèt nan tant asanble a a tout fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","SENYÈ a te di a Moïse: “Pou konbyen de tan, moun sa yo va desann mwen konsa? Pou konbyen de tan yo va refize kwè nan Mwen, malgre tout sign ke M te fè nan mitan yo? ");
INSERT INTO hatbsa_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Mwen va frape yo avèk gwo mizè. Mwen va dizerite yo. Mwen va fè ou menm vin fòme yon nasyon pi gwo e pi fò ke yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Men Moïse te reponn SENYÈ a: “Alò Ejipsyen yo va tande bagay sa a, paske pa pwisans Ou, Ou te mennen fè monte pèp sa a soti nan mitan yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Konsa, yo va pale sa a sila ki rete nan peyi sila yo. Yo te tande ke Ou menm, O SENYÈ a, rete nan mitan pèp sa a. Paske Ou menm, O SENYÈ a, yo fè wè fasafas, e nwaj Ou kanpe sou yo; epi Ou ale devan yo nan yon pilye nwaj pandan lajounen ak yon pilye dife pandan lannwit. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Alò, si ou touye pèp sa a tankou se yon sèl moun, alò, nasyon ki te tande tout istwa Ou yo, va di: ");
INSERT INTO hatbsa_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Akoz SENYÈ a pa t kab mennen pèp sa nan peyi ke Li te pwomèt yo avèk sèman an, pou sa, li te detwi yo nan dezè a.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Men koulye a, mwen priye, pou pwisans a SENYÈ a vin gwo, jis jan ke Ou te deklare a, ");
INSERT INTO hatbsa_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘SENYÈ a lan nan fè kòlè; Li ranpli avèk lanmou dous, ki padone inikite avèk transgresyon yo. Li p ap janm bliye tò a koupab yo, men Li va vizite inikite a papa yo sou pitit yo jis rive nan twazyèm ak katriyèm jenerasyon.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","“Padone, mwen priye Ou, inikite a pèp sa a selon grandè lanmou dous Ou a, jis jan ke Ou menm, osi, te padone pèp sa a, depi an Égypte pou jis rive koulye a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Konsa, SENYÈ a te di: “Mwen te padone yo, jan ou te mande a; ");
INSERT INTO hatbsa_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","men vrèman, jan Mwen viv la, tout latè va ranpli avèk laglwa SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Vrèman, tout mesye ki te wè glwa Mwen ak sign Mwen te fè an Égypte ak nan dezè a, malgre sa, yo vin pase Mwen a leprèv pandan menm dis fwa sa yo, e yo pa t koute vwa M. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Pa gen youn nan yo k ap wè peyi ke M te sèmante a papa yo a, ni p ap gen nan sila ki te rejte M yo, k ap wè l. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Men sèvitè Mwen an, Caleb, akoz li te gen yon lòt lespri, e li te swiv Mwen nèt, Mwen va mennen l nan peyi kote li te antre a, e desandan li yo va vin pran posesyon li. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Alò, moun Amalec avèk Canaran yo ap viv nan vale yo. Vire demen pou pati pou dezè a pa chemen Lamè Wouj la. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","“SENYÈ a te pale avèk Moïse, e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Pou konbyen de tan, Mwen va sipòte kongregasyon mechan sila k ap bougonnen kont Mwen an? Mwen fenk tande plent ke fis Israël yo ap fè kont Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","“Di yo: ‘Jan Mwen vivan an, di SENYÈ a, mwen va fè pou ou tout bagay jan Mwen te tande ou di a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Kadav nou yo va tonbe nan dezè sila a, menm tout mesye konte yo, nou tout soti nan ventan oswa plis, ki te bougonnen kont Mwen yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","vrèman, nou p ap antre nan peyi kote Mwen te sèmante pou mete nou an, sof Caleb, fis a Jephunné a ak Jousé, fis a Nun nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Men pitit nou yo, ke nou te di ki ta devni yon objè lachas— Mwen va mennen yo antre ladann. Yo va konnen peyi ke nou menm te rejte a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","“‘Men pou nou menm, kadav nou va tonbe nan dezè sila a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Fis nou yo va vin bèje pandan karantan nan dezè a, e yo va soufri pou enfidelite nou yo jiskaske kadav nou kouche nan dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Selon nonb de jou ke nou te fè ankèt nan peyi a, karant jou, pou chak jou, nou va pote inikite nou yo pandan 1 nan, Ki fè karantan total, e nou va konprann opozisyon Mwen an.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mwen, SENYÈ a te pale. Se vrèman sa Mwen va fè a tout kongregasyon mechan sila ki rasanble kont Mwen an. Nan dezè sa a, yo va vin detwi, e la yo va mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Pou mesye ke Moïse te voye pou fè ankèt nan peyi a, e ki te retounen pou fè tout kongregasyon an bougonnen kont Li yo lè yo te vin sòti avèk yon move rapò sou peyi a, ");
INSERT INTO hatbsa_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","menm mesye sila yo ki te fè sòti rapò byen move a, yo te vin mouri akoz yon epidemi devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Men Josué, fis Nun nan ak Caleb, fis a Jephaunné a te rete vivan pami sila ki te ale fè espyonaj peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Lè Moïse te pale pawòl sa yo a tout fis Israël yo, pèp la te leve fè gwo lamantasyon. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Sepandan, nan maten, yo te leve bonè, yo te monte vè krèt kolin ki nan peyi kolin yo. Yo te di: “Men nou isit la! Nou te vrèman fè peche, men nou va monte vè kote ke SENYÈ a te pwomèt la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Men Moïse te di: “Poukisa nou ap transgrese kòmandman a SENYÈ a, lè sa p ap reyisi? ");
INSERT INTO hatbsa_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Pa monte, oswa nou va frape devan lènmi nou yo, paske SENYÈ a pa pami nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Paske, moun Amalec yo ak Kananeyen yo va la devan nou, e nou va vin tonbe anba nepe, akoz ke nou te vire an aryè kite SENYÈ a. Konsa, SENYÈ a p ap avèk nou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Men san prekosyon, yo te monte nan krèt peyi kolin nan. Men ni lach temwayaj la, ni Moïse te kite kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Alò, moun Amalec yo avèk Kananeyen ki te rete nan peyi kolin yo, te vin desann. Yo te frape yo, e te bat yo jis rive nan Horma. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Pale avèk fis Israël yo. Di yo: ‘Lè nou antre nan peyi kote nou dwe viv la, peyi ke Mwen ap bannou an, ");
INSERT INTO hatbsa_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","alò, fè yon ofrann pa dife a SENYÈ a—yon ofrann brile, oswa yon sakrifis pou akonpli yon ve espesyal, swa kòm yon ofrann bòn volonte, swa nan tan apwente yo, pou fè yon odè ki santi bon a SENYÈ a, soti nan twoupo oswa nan bann mouton— ");
INSERT INTO hatbsa_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","sila ki prezante ofrann li an, va prezante bay SENYÈ a yon ofrann sereyal de yon dizyèm efa farin fen mele avèk yon ka lwil. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ou va prepare diven pou ofrann bwason an, yon ka boutèy, avèk ofrann brile a oswa pou sakrifis la, pou chak jenn mouton. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“‘Oswa pou yon belye, ou va prepare kòm yon ofrann sereyal, de dizyèm efa farin fen mele avèk yon tyè boutèy lwil; ");
INSERT INTO hatbsa_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","epi pou ofrann bwason an, ou va ofri yon tyè boutèy diven kòm yon odè santi bon a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“‘Lè ou fin prepare yon towo kòm yon ofrann brile, oswa yon sakrifis pou akonpli yon ve espesyal, oswa ofrann lapè bay SENYÈ a, ");
INSERT INTO hatbsa_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","alò, ou va ofri avèk towo a yon ofrann sereyal fèt ak twa dizyèm efa farin fen mele avèk yon mwatye boutèy lwil; ");
INSERT INTO hatbsa_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","epi ou va ofri kòm ofrann bwason, yon mwatye boutèy diven kòm yon ofrann pa dife, kòm yon odè ki bon a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Konsa, li va fèt pou chak bèf, oswa chak belye, oswa chak nan jenn mouton mal yo, oswa kabrit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Selon kantite ke nou prepare yo, konsa nou va fè pou chak selon kantite ki genyen an. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“‘Tout sila ki natif peyi yo, yo va fè bagay sa yo nan menm mòd la, nan prezante yon ofrann pa dife, kòm yon odè ki bon a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Si yon etranje vin demere pami nou, oswa youn ki kapab pami nou pandan tout jenerasyon yo, e li vle fè yon ofrann pa dife, kòm yon ofrann ki santi bon an SENYÈ a, menm jan ak nou, se konsa li va fè l. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Epi pou asanble a, va genyen yon sèl règleman pou nou ak pou etranje ki demere pami nou an, yon règleman pou tout tan pandan tout jenerasyon nou yo. Jan nou menm ye a, se konsa etranje a va ye devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Va genyen yon sèl lwa, ak yon sèl òdonans pou nou ak pou etranje ki demere pami nou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Pale avèk fis Israël yo pou di yo: ‘Lè nou antre nan peyi kote Mwen mennen nou an, ");
INSERT INTO hatbsa_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","alò konsa sa va rive, ke lè nou manje nan manje peyi a, nou va leve yon ofrann bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","“‘Nan premye bòl farin moulen nou an, nou va fè leve yon gato kòm yon ofrann. Kòm ofrann moulen glasi, nou va leve li. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Soti nan premye bòl farin moulen an, nou va bay SENYÈ a yon ofrann pandan tout jenerasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Men lè nou tonbe fè yon fòt pa eksprè, e nou vin pa obsève tout kòmandman sila ke SENYÈ a te pale a Moïse yo— ");
INSERT INTO hatbsa_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tout sa ke SENYÈ a te kòmande pa Moïse yo soti nan jou ke SENYÈ a te bay kòmandman an, avanse rive nèt pou tout jenerasyon yo— ");
INSERT INTO hatbsa_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","alò, li va konte ke si sa fèt san entansyon, e san konesans kongregasyon an, ke tout kongregasyon an va ofri yon towo kòm yon ofrann brile, kòm yon odè ki bon a SENYÈ a, avèk ofrann sereyal pa li a, ak ofrann bwason li an, selon òdonans lan, ak yon mal kabrit pou yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Konsa, prèt la va fè ekspiyasyon pou tout kongregasyon fis Israël yo, e yo va vin padone; paske se te yon erè, e yo te pote ofrann pa yo, yon ofrann pa dife bay SENYÈ a, ofrann peche pa yo devan SENYÈ a, pou erè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","“‘Konsa, tout kongregasyon fis Israël yo va vin padone, avèk etranje ki demere pami yo, paske sa te rive a tout pèp la akoz fòt erè. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Osi, si yon moun fè peche ki pa eksprè, alò, li va ofri yon femèl kabrit nan laj 1 nan kòm yon ofrann peche. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Prèt la va fè ekspiyasyon devan SENYÈ a pou moun ki kite chemen an lè li fè peche ki pa eksprè a, pou li k ap fè ekspiyasyon pou li pou jiskaske li kapab padone. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Nou va genyen yon sèl lwa pou sila ki fè yon bagay ki pa eksprè, pou sila ki natif pami fis Israël yo, e pou sila ki se yon etranje k ap demere pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Men moun ki fè yon bagay avèk rebelyon an, menm si se yon natif, oswa yon etranje, sila ap blasfeme SENYÈ a. Nanm sa va koupe retire de pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Akoz ke li te meprize pawòl a SENYÈ a, e li te vyole kòmandman Li an, moun sa a va konplètman koupe retire. Koupabilite li va rete sou li.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Alò, pandan fis Israël yo te nan dezè a, yo te twouve yon nonm ki t ap ranmase bwa nan jou Saba a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Sila ki te twouve li yo nan ranmase bwa a te mennen li vè Moïse avèk Aaron, ak tout asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Konsa, yo te arete li, akoz ke li potko deside kisa pou fè avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Alò, SENYÈ a te di a Moïse: “Nonm nan va vrèman vin mete a lanmò. Tout kongregasyon an va lapide li avèk kout wòch deyò kan an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Konsa, tout kongregasyon an te mennen li deyò kan an, e yo te lapide li jiska lanmò avèk kout wòch, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","SENYÈ a te osi pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Pale avèk fis Israël yo e di yo ke yo va fè pou yo menm ponpon sou kwen vètman yo pandan tout jenerasyon yo, e ke yo va mete sou ponpon nan chak kwen an, yon kòd ble. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Se va yon ponpon pou nou gade, e pou sonje tout kòmandman SENYÈ yo, pou nou obeyi yo, e pa pwostitiye tèt nou jan noun te konn fè, nan swiv dezi pwòp kè nou ak zye nou, ");
INSERT INTO hatbsa_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","e pou nou sonje pou fè tout kòmandman Mwen yo, e pou rete sen a Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","“Mwen menm se SENYÈ a, Bondye nou an, ki te mennen nou sòti nan peyi Égypte la, pou M kab vin Bondye nou. Mwen se SENYÈ a, Bondye nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Alò, Koré, fis a Jitsehar, ansanm avèk Dathan ak Abiram, fis a Éliab avèk On, fis a Péleth, fis a Ruben yo, te pran desizyon. Yo te pran moun avèk yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","epi yo te vin soulve devan Moïse. Ansanm avèk kèk nan fis Israël yo, de-san-senkant nan chèf kongregasyon an, mesye ki te byen rekonèt, ki te chwazi pa asanble a, ");
INSERT INTO hatbsa_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","yo te reyini ansanm kont Moïse avèk Aaron. Yo te di yo: “Nou te ale ase lwen, paske tout kongregasyon an sen, yo tout, e SENYÈ a nan mitan yo! Konsa, poukisa nou egzalte tèt nou pi wo pase asanble SENYÈ a?” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Lè Moïse te tande sa, li te tonbe sou figi li. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Li te pale avèk Koré ak tout konpanyen li yo. Li te di: “Demen maten, SENYÈ a va montre kilès ki apatyen ak Li e kilès ki sen, epi Li va fè moun sa a vin touprè Li. Menm sila ke Li chwazi a, Li va mennen li toupre Li menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Fè sa: Fè Koré ak tout konpanyen li pran asanswa a pou kont nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Konsa, mete dife ladann, e poze lansan sou yo nan prezans a SENYÈ a, demen. Moun nan ke SENYÈ a chwazi a, va sila ki sen an. Nou gen tan ale ase lwen, fis a Levi yo!” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moïse te di a Koré: “Tande koulye a fis a Levi yo! ");
INSERT INTO hatbsa_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Èske li pa sifi pou nou ke Bondye Israël la te separe nou soti nan tout rès kongregasyon Israël la, pou mennen nou touprè a Li menm? Pou fè sèvis tabènak SENYÈ a, e pou vin kanpe devan kongregasyon an pou sèvi yo? ");
INSERT INTO hatbsa_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","E ke li te mennen nou touprè, tout frè ou yo Koré, fis a Levi yo avèk ou? Epi èske w ap chache pozisyon prèt la tou? ");
INSERT INTO hatbsa_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Pou sa, ou menm avèk tout konpanyen ou yo vin rasanble ansanm kont SENYÈ a! Men pou Aaron, kilès li ye pou nou vin plenyen kont li?” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Konsa, Moïse te voye yon lòd bay Dathan avèk Abiram, fis a Éliab yo, men yo te di: “Nou p ap monte.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Èske sa pa ase ke ou te mennen nou sòti nan yon peyi ki koule avèk lèt ak siwo myèl pou fè nou vin mouri nan dezè a, men ou ta, osi, vin chèf sou nou? ");
INSERT INTO hatbsa_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Vrèman, ou pa t mennen nou nan yon peyi ki koule avèk lèt ak siwo myèl, ni ou pa t bannou yon eritaj tèren, avèk chan rezen. Èske ou ta pete zye a mesye sa yo? Nou p ap monte? ");
INSERT INTO hatbsa_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Alò Moïse te vin byen fache. Li te di a SENYÈ a: “Pa aksepte ofrann pa yo! Mwen pa t pran menm yon bourik nan men yo, ni mwen pa t fè mal a okenn nan yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moïse te di a Koré: “Ou menm avèk tout konpanyen ou yo, parèt devan SENYÈ a demen; ni ou menm, yo menm ansanm avèk Aaron. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Chak nan nou pran veso dife li, mete lansan sou li, e chak nan nou pote veso lansan an devan SENYÈ a, de-san-senkant veso dife; osi ou menm avèk Aaron va chak pote veso dife pa li a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Konsa, yo chak te pran pwòp veso dife a e te mete dife ladann. Yo te mete lansan sou li, epi yo te kanpe nan pòtay tant asanble a, avèk Moïse ak Aaron. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Konsa, Koré te rasanble tout kongregasyon anfas yo a nan pòtay a tant asanble a. Epi glwa a SENYÈ a te vin parèt a tout kongregasyon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","SENYÈ a te pale avèk Moïse ak Aaron, e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Separe nou nan mitan kongregasyon sila a, pou Mwen kapab manje yo koulye a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Men yo te tonbe sou figi yo e te di: “O Bondye, Bondye a lespri de tout chè a, èske Ou va an kòlè avèk tout kongregasyon an lè yon sèl moun fè peche?” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Pale avèk kongregasyon an e di: ‘Sòti nan andwa tant Koré yo, Dathan avèk Abiram!’” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Alò, Moïse te leve ale vè Dathan ak Abiram, avèk ansyen a Israël ki t ap swiv li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Li te pale avèk kongregasyon an. Li te di: “Kite tant a moun mechan sa yo, e pa touche anyen ki pou yo, sinon, nou va vin pote ale ak tout peche yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Konsa, yo te soti nan tant a Koré yo, Dathan ak Abiram de tout kote. Dathan ak Abiram te vin kanpe nan pòtay tant pa yo a, ansanm avèk madanm yo, e fis yo, ansanm ak timoun yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moïse te di: “Selon sa, nou va konnen ke SENYÈ a te voye mwen pou fè tout zèv sa yo; paske sa se pa nan tèt mwen y ap soti. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si mesye sila yo mouri yon mò natirèl, oswa si yo soufri desten a tout moun nòmal, alò SENYÈ a pa t voye mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Men si SENYÈ a fè vin parèt yon bagay tounèf, tè a vin ouvri bouch li pou vale yo nèt avèk tout sa ki pou yo, e yo desann tou vivan kote mò yo ye a, alò, konsa, nou va konprann ke mesye sila yo te meprize SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Pandan li te fin pale tout pawòl sa yo, tè ki te anba yo a te fann e li te ouvri. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Konsa, latè te louvri bouch li e te vale yo nèt avèk moun lakay yo, ak tout mesye ki te apatyen a Koré avèk tout byen yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Konsa, yo menm avèk tout sa ki te pou yo, te desann vivan nan sejou mò yo. Tè a te vin fèmen sou yo, e yo te peri nan mitan asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tout Israël ki te antoure yo te sove ale pandan yo t ap rele, paske yo te di: “Tè a kapab vin vale nou nèt!” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Dife te sòti nan SENYÈ a pou brile de san senkant mesye ki te ofri lansan yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Di a Éléazar, fis a Aaron an, prèt la, ke li va ranmase veso lansan yo nan mitan dife a, paske yo sen. Epi nou va gaye sann dife k ap brile lwen kan an, paske yo sen. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Epi menm selon veso lansan a mesye sa yo ki te peche e te peye ak lavi yo, kite yo fin bat yo byen plat pou sèvi yo pou kouvri lotèl la, pwiske yo te prezante yo devan SENYÈ a. Yo sen. Konsa, yo va sèvi kòm yon sign a fis Israël yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Éléazar, prèt la, te pran veso lansan ki te fèt an bwonz ke mesye ki te brile yo te ofri, epi yo te bat yo pou fè yo plat pou kouvri lotèl la, ");
INSERT INTO hatbsa_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","kòm yon sonj komemoratif a fis Israël yo pou pèsòn ki pa nan ras Aaron pa ta dwe pwoche pou brile lansan devan SENYÈ a; jis pou li pa devni tankou Koré ak konpanyen li yo—jis jan ke SENYÈ a te pale a li pa Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Men nan pwochen jou a, tout kongregasyon fis Israël yo te bougonnen kont Moïse avèk Aaron. Yo te di: “Se nou ki touye pèp SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Lè kongregasyon an te reyini ansanm kont Moïse avèk Aaron, yo te gade vè tant asanble a, e vwala, nwaj la te kouvri li e glwa SENYÈ a te parèt. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Alò, Moïse avèk Aaron te vini devan tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Konsa, SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Mete ou lwen kongregasyon sila a, pou Mwen kapab detwi yo kounye a menm.” Yo te tonbe sou figi yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Moïse te di a Aaron: “Pran veso lansan an, mete dife lotèl la ladann. Mete lansan an sou li e pote li vit bay kongregasyon an pou fè ekspiyasyon pou yo. Paske lakòlè gen tan sòti nan SENYÈ a. Gwo epidemi an kòmanse!” ");
INSERT INTO hatbsa_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Alò Aaron te pran li jan Moïse te pale a. Li te kouri nan mitan asanble a, paske, gade byen, gwo epidemi an te kòmanse pami pèp la. Konsa li te mete lansan an pou fè ekspiyasyon pou pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Li te kanpe antre mò yo ak moun vivan, e gwo epidemi an te rete. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Men sila ki te mouri nan gwo epidemi yo te katòz-mil-sèt-san (14,700), anplis sila ki te mouri akoz Koré yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Alò, Aaron te retounen vè Moïse nan pòtay tant asanble a, paske gwo epidemi an te vin rete. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Pale avèk fis Israël yo, e pran yon branch bwa pou chak kay fanmi zansèt yo: douz branch bwa ki sòti nan tout chèf yo selon kay fanmi zansèt yo. Nou va ekri non a chak sou branch pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ekri non a Aaron sou branch Levi a. Konsa, va gen yon sèl branch pou tèt a chak kay fanmi zansèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Epi nou va depoze yo nan tant asanble a devan lach temwayaj la, kote Mwen rankontre nou an. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","“Li va vin rive ke branch moun ke Mwen chwazi a, va boujonnen. Konsa, Mwen va fè sispann tout bougonnen fis Israël k ap fèt kont nou menm.” ");
INSERT INTO hatbsa_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Konsa, Moïse te pale avèk fis Israël yo, e tout chèf yo te bay li yon branch pou chak nan yo; pou chak chèf, selon kay fanmi zansèt yo, douz branch avèk branch Aaron an pami branch yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Konsa, Moïse te depoze branch yo devan SENYÈ a nan tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Alò, nan jou apre a, Moïse te antre nan tant lan; epi vwala, branch Aaron an pou fanmi zansèt Levi a te boujonnen. E li pa t sèlman boujonnen, men li te pwodwi flè, e osi li te pote zanmann mi. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Konsa, Moïse te pote deyò tout branch ki te nan prezans a SENYÈ a vè tout fis Israël yo. Yo te gade, e chak mesye te pran pwòp branch pa l. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Men SENYÈ a te di a Moïse: “Remete branch Aaron a devan lach temwayaj la, pou kenbe kòm yon sign kont rebèl yo, pou ou kapab mete fen a plent kont Mwen yo, pou yo pa mouri.” ");
INSERT INTO hatbsa_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Konsa, Moïse te fè; jis jan ke SENYÈ a te kòmande li a, konsa li te fè. ");
INSERT INTO hatbsa_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Alò, fis Israël yo te pale avèk Moïse e te di l: “Gade byen, n ap mouri, nou tout ap mouri! ");
INSERT INTO hatbsa_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Tout moun ki pwoche, ki vin pwoche toupre tabènak SENYÈ a, fòk li mouri. Èske nou tout va peri nèt?” ");
INSERT INTO hatbsa_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Konsa, SENYÈ a te di a Aaron: “Ou menm avèk fis ou yo avèk lakay zansèt ou va pote inikite a pou zafè sanktyè a, e nou menm avèk fis nou yo va pote inikite a kon prèt. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Mennen avè w osi frè nou yo, tribi Levi a, tribi papa zansèt ou a, pou yo kapab vin jwenn avèk ou e sèvi ou, pandan ou menm avèk fis ou yo devan tant temwayaj la. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Yo va kenbe lòd ou avèk devwa tout asanble a, men yo p ap pwoche veso sanktyè yo avèk lotèl la, pou yo pa mouri; ni yo, ni ou menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Yo va vin jwenn avèk ou, e fè devwa a tant asanble a pou tout sèvis tant lan. Men yon etranje pa pou pwoche prè nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Konsa nou va fè tout devwa a sanktyè a ak devwa a lotèl la, pou pa toujou gen kòlè sou fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Veye byen, se Mwen Menm ki te pran Levit parèy nou yo pami fis Israël yo. Yo se yon don pou nou menm, ki dedye bay SENYÈ a, pou fè sèvis tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Men ou menm ak fis ou yo ap ranpli pozisyon prèt pou tout bagsay ki konsène lotèl la, ak andedann vwal la. Ou va fè sèvis yo. Mwen ap bay ou pozisyon prèt kon yon pozisyon donnen. Men okenn lòt moun ki pwoche va mete a lanmò.” ");
INSERT INTO hatbsa_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Alò, SENYÈ a te pale avèk Aaron: “Gade byen, se Mwen Menm ki te bay ou chaj sou tout ofrann Mwen yo, menm tout don sen a fis Israël yo. Mwen te bay ou yo akoz onksyon an nou resevwa, e a fis ou yo kòm yon dwa ki pou tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Sila a va pou nou, soti nan don pi sen pase tout lòt yo ki rezève soti nan dife a; tout ofrann pa yo, menm tout ofrann pa yo, tout ofrann sereyal, tout ofrann peche ak tout ofrann koupab ke yo rann ban Mwen yo, yo va sen pase tout lòt yo pou nou ak fis nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Kòm don ki sen pase tout lòt yo, nou va manje l. Tout gason va manje li. Li va sen pou nou menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Sa osi se pou nou, ofrann a don pa yo, menm tout ofrann balanse vè lotèl a fis Israël yo; Mwen te bannou yo ak fis nou yo ak fi nou yo ki avèk nou, kòm yon dwa ki pou tout tan. Tout sila lakay nou yo ki pwòp, kapab manje yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Tout sa ki pi bon nan lwil fre a, tout sa ki pi bon nan diven fre a ak nan sereyal la, premye fwi a sila ke yo bay a SENYÈ a, Mwen bannou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Premye nan fwi mi ki nan peyi yo, ke yo pote bay SENYÈ a, va pou ou. Tout moun lakay ou ki pwòp, kapab manje li. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Tout bagay ki konsakre an Israël va pou ou. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tout premye pòtre nan vant a tout chè, kit se lòm, kit se bèt, ke yo ofri bay SENYÈ a, va pou nou. Men premye ne a lòm nan, nou va anverite peye ranson, e premye ne bèt ki pa pwòp, nou va peye ranson. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Epi pou pri ranson an, soti nan laj yon mwa, nou va peye ranson yo, selon pri nou yo, senk sik an ajan, selon sik sanktyè a, ki se ven gera. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Men premye ne a yon bèf oswa yon mouton, oswa premye ne a yon kabrit, ou pa pou peye ranson. Yo sen. Ou va flite san pa yo sou lotèl la, e ou va ofri grès yo nan lafimen kòm yon ofrann pa dife, kòm yon odè ki bon a SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Vyann pa yo va pou ou. Li va pou ou tankou pwatrin ak kwis nan yon ofrann balanse anlè. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Tout ofrann a don sen yo, ke fis Israël yo ofri bay SENYÈ a, Mwen te bannou yo, avèk fis ou yo ak fi ou yo ki avèk ou, kòm yon dwa ki pou tout tan. Li se yon kontra disèl devan SENYÈ a avèk ou avèk desandan ou yo avèk ou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","SENYÈ a te di a Aaron: “Ou p ap gen okenn eritaj nan peyi a ni posesyon okenn pati pami yo. Mwen se pati pa ou ak eritaj ou pami fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“A fis Levi yo, gade byen, Mwen te bay tout dim an Israël yo kòm eritaj, anretou pou sèvis yo ke yo fè, sèvis a tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Fis a Israël pa pou pwoche tant asanble a ankò; sinon, yo va pote peche e yo va mouri. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Sèl Levit yo va fè sèvis tant asanble a. Yo va pote inikite pa yo. Sa va yon règleman pou tout tan atravè jenerasyon nou yo. Pami fis Israël yo, yo p ap gen okenn eritaj. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Paske dim a fis Israël yo, ke yo ofri kòm yon ofrann bay SENYÈ a, Mwen te bay a Levit yo kòm eritaj. Konsa, Mwen te di konsènan yo: ‘Yo p ap gen okenn eritaj pami fis Israël yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","SENYÈ a te pale a Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Anplis, ou va pale avèk Levit yo pou di yo: ‘Lè nou pran soti nan fis Israël yo, dim ke Mwen te bay a nou menm pou eritaj nou, alò nou va prezante yon ofrann ki sòti nan li bay SENYÈ a, yon dim nan dim nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Ofrann nou va konte pou nou kòm sila ki sòti nan voye anlè glasi a, oswa pwodwi ki nan basen diven an. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Konsa, nou va, osi, prezante yon ofrann bay SENYÈ a, ki soti nan dim nou yo, ke nou resevwa de fis Israël yo. Epi soti nan li, nou va bay ofrann SENYÈ a a Aaron, prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Nan tout don nou yo, nou va prezante tout ofrann ke nou dwe bay a SENYÈ a, soti nan tout sa ki pi bon nan yo, pati ki sakre nan yo.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Ou va di yo: ‘Lè nou ofri meyè pati a, li va kalkile a Levit yo kòm pwodwi a ofrann voye anlè glasi a, oswa pwodwi a basen diven an. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Nou gen dwa manje l nenpòt kote, nou menm avèk lakay nou, paske se pèyman nou an echanj pou sèvis nou nan tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Nou p ap pote peche akoz li, lè nou fin ofri meyè pati a. Men nou pa pou degrade bagay sakre a fis Israël yo; sinon, nou va mouri.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Senyè a te pale ak Moïse avèk Aaron e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Sa se règleman lalwa ke SENYÈ a te kòmande a. Li te di: ‘Pale a fis Israël yo pou yo pote ba ou yon gazèl wouj, san defo, sou sila yon jouk pa t janm vin poze. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Nou va bay li a Éléazar, prèt la, li va pote li deyò kan an, e touye li nan prezans li. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Apre, Éléazar, prèt la, va pran kèk nan san li avèk dwèt li, e flite kèk nan san li an pa devan tant asanble a sèt fwa. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Alò, gazèl la va brile devan zye li; po li, chè li avèk san li, avèk poupou li, va brile. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Prèt la va pran bwa sèd avèk izòp ak twal wouj, e li va jete li nan mitan gazèl k ap brile a. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Epi prèt la va lave vètman li yo, benyen kò li nan dlo, e apre, li va antre nan kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Sila ki brile li a, va osi lave kò li nan dlo, apre li va vini nan kan an, e li va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“‘Alò, yon nonm ki pwòp, va ranmase sann gazèl la pou depoze yo deyò kan an nan yon kote ki pwòp. Epi fis Israël yo va konsève li pou sèvi nan dlo pirifikasyon. Li se yon ofrann pou peche. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Sila ki ranmase sann gazèl la va lave rad li, e li va rete pa pwòp pou jis rive nan aswè. Li va yon règleman ki pou tout tan pou fis Israël yo ak pou etranje ki rete pami yo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“‘Sila ki touche kadav a nenpòt moun, va pa pwòp pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Li dwe pirifye tèt li avèk dlo nan twazyèm jou a ak nan setyèm jou a. Apre, li va pwòp. Men si li pa pirifye tèt li nan twazyèm jou a ak nan setyèm jou a, li p ap vin pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nenpòt moun ki touche yon mò, kò a yon moun mouri, e li pa pirifye tèt li, li degrade tabènak a SENYÈ a; epi moun sa va koupe retire de Israël a. Akoz dlo pirifikasyon an pa t flite sou li, li va vin pa pwòp. Pa pwòp li a rete sou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“‘Sa se lalwa lè yon nonm mouri nan yon tant: tout moun ki antre nan tant lan ak tout moun ki deja nan tant lan, vin pa pwòp pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tout veso ki louvri, ki pa gen kouvèti mare sou li, pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“‘Osi, nenpòt moun ki nan chan louvri, e ki touche yon moun ki te touye pa nepe, oswa ki te mouri nenpòt jan, swa yon zo Kretyen oswa yon tonm, li va vin pa pwòp pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“‘Alò, pou sila ki pa pwòp yo, yo va pran kèk nan sann pirifikasyon peche ki te brile a, e dlo k ap koule va mele avèk yo nan yon veso. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Yon moun pwòp va pran izòp e fonse li nan dlo a, flite li sou tant lan ak sou tout zafè li yo, ak sou tout moun ki te ladann yo, tout sila ki te touche zo a, oswa sa ki te touye a, oswa sa ki te mouri yon lòt jan an, oswa yon tonm. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Alò, moun pwòp la va flite sou sila ki pa pwòp la nan twazyèm jou a ak nan setyèm jou a. Nan setyèm jou a, li dwe pirifye tèt li. Li va lave rad li, benyen nan dlo e li va pwòp nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Men sila ki pa pwòp la, ki pa pirifye tèt li a, li va koupe retire nan mitan asanble a, akoz li te degrade sanktyè SENYÈ a. Dlo pirifikasyon an pa t flite sou li, e li pa pwòp. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","“‘Se konsa sa va yon règleman pou tout tan pou yo. Sila ki flite dlo pirifikasyon an, va osi lave rad li, e sila ki touche dlo pirifikasyon an va rete pa pwòp jis rive nan aswè. ");
INSERT INTO hatbsa_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Anplis, nenpòt bagay ke moun pa pwòp la touche, va vin pa pwòp. Moun ki touche li a, va vin pa pwòp jis rive nan aswè.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Konsa, fis Israël yo, tout kongregasyon an, te vini nan dezè a Tsin nan, nan premye mwa a. Pèp la te rete Kadès. Alò, Marie te mouri e li te antere la. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Pa t gen dlo pou kongregasyon an, e yo te vin reyini yo menm kont Moïse avèk Aaron. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Konsa, pèp la te fè kont avèk Moïse e te pale pou di: “Si sèlman nou te mouri lè frè nou yo te mouri devan SENYÈ a! ");
INSERT INTO hatbsa_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Epi poukisa ou te mennen asanble SENYÈ a antre nan dezè sila a, pou nou menm avèk bèt nou yo vin mouri isit la? ");
INSERT INTO hatbsa_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Poukisa ou te fè nou sòti an Égypte pou mennen nou kote mechan sila a? Se pa yon kote ki gen, ni fig, ni grenad, ni pa gen dlo pou bwè.” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moïse avèk Aaron te sòti nan prezans asanble a nan pòtay tant asanble a, e yo te tonbe sou figi yo. Alò, glwa a SENYÈ a te vin parèt a yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Konsa, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Pran baton an. Ou menm avèk frè ou a, Aaron, rasanble kongregasyon an e pale avèk wòch la devan zye yo, pou li kapab bay dlo pa li. Konsa, ou va fè dlo parèt pou yo sòti nan wòch la e kite kongregasyon an avèk bèt yo bwè.” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Konsa, Moïse te pran baton an soti devan SENYÈ a, jis jan ke Li te kòmande li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Epi Moïse avèk Aaron te reyini asanble a devan wòch la. Li te di yo: “Koute m koulye a, nou menm k ap fè rebèl; èske n ap fè dlo sòti nan wòch sila a?” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Epi Moïse te leve men li e li te frape wòch la de fwa avèk baton an. Dlo te sòti an kantite, e kongregasyon an avèk bèt pa yo te bwè. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Men SENYÈ a te di a Moïse avèk Aaron: “Akoz ke nou pa kwè M, pou trete m tankou sen devan fis Israël yo; pou sa, nou p ap mennen asanble sila a antre nan peyi ke M te bay yo a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Sa yo se te dlo a Meriba yo, akoz fis a Israël yo te fè kont avèk SENYÈ a, e Li te fè prèv sentete Li pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Soti nan Kadès, Moïse te voye mesaj vè wa Édom an: “Konsa frè ou a, Israël te pale: ‘Ou konnen tout traka ki gen tan pran nou; ");
INSERT INTO hatbsa_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ke zansèt nou yo te desann an Égypte, e ke nou te rete an Égypte pandan anpil tan, e ke Ejipsyen yo te maltrete nou anpil. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Men lè nou te kriye fò bay SENYÈ a, Li te tande vwa nou. Li te voye yon zanj pou te mennen nou sòti an Égypte. Alò, gade byen, nou rive Kadès, yon vil nan fwontyè tèritwa pa nou an. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","“Souple, kite nou pase nan peyi pa nou an. Nou p ap pase nan chan yo oswa nan rezen yo. Nou p ap menm bwè dlo nan yon pwi. Nou va ale bò kote chemen wa a, san vire ni adwat, ni agoch jiskaske nou fin pase nan tout tèritwa nou an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","“‘Men Édom te di li: “Ou p ap pase sou nou; sinon, mwen ap vini kont nou avèk nepe.”’” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","“Ankò, fis Israël yo te di li: ‘Nou va monte vè chemen an, e si Mwen avèk bèt mwen yo bwè nan dlo nou an; alò, m ap peye pri li. Kite mwen sèlman pase ladann a pye, anyen anplis.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Men li te di: “Ou p ap pase ladann.” Epi Édom te sòti kont li avèk yon gwo fòs ak yon men pwisan. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Konsa, Édom te refize kite Israël pase nan tèritwa pa li a. Pou sa Israël te vire kite li. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Alò, yo te sòti Kadès, epi fis Israël yo ak tout kongregasyon an te vini nan Mòn Hor. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","SENYÈ a te pale avèk Moïse ak Aaron nan Mòn Hor akote fwontyè Édom an. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aaron va rasanble vè pèp li a; paske li pa pou antre nan peyi ke Mwen te bay a fis Israël yo, akoz nou te vin rebèl kont kòmand Mwen nan dlo a Meriba yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Pran Aaron avèk fis li a, Éléazar e mennen yo nan Mòn Hor. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Retire tout vètman yo sou Aaron e mete yo sou fis li a, Éléazar. Konsa, Aaron va rasanble vè pèp li a, e li va mouri la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Konsa Moïse te fè selon SENYÈ a te kòmande a. Yo te monte vè Mòn Hor devan zye a tout kongregasyon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Lè Moïse te fin retire vètman yo sou Aaron, li te mete yo sou Éléazar. Aaron te mouri la sou tèt mòn nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Lè tout kongregasyon an te wè ke Aaron te mouri, tout lakay Israël te kriye pou Aaron pandan trantjou. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Lè Chèf Canaran an, wa Arad la, ki te viv nan Negev la te tande ke Israël t ap vini pa chemen a Atharim nan; alò, li te goumen kont Israël, e li te pran kèk nan yo an kaptif. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Konsa, Israël te fè yon ve a SENYÈ a, e te di: “Si Ou va vrèman livre pèp sa a nan men m; alò, mwen va detwi vil pa yo a nèt.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","SENYÈ a te tande vwa Israël. Li te livre yo bay Canaran, epi yo te detwi yo nèt ansanm avèk vil yo. Konsa, kote sa a te vin releHorma. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Yo te sòti nan Mòn Hor pa wout Lamè Wouj la, pou travèse peyi Édom an. Epi pèp la te vin pèdi pasyans akoz vwayaj la. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Pèp la te pale kont Bondye ak Moïse: “Poukisa ou te mennen nou sòti an Égypte pou mouri nan dezè a? Paske nanpwen manje, ni dlo, e nou rayi move manje sila a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","SENYÈ a te voye sèpan dife pami pèp la. Yo te mòde pèp la, e anpil nan pèp Israël la te mouri. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Konsa, pèp la te vini a Moïse e te di: “Nou te peche, pwiske nou te pale kont SENYÈ a ak ou menm. Entèsede pou nou avèk SENYÈ a, pou Li kapab retire sèpan sa yo sou nou.” Epi Moïse te entèsede pou pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Alò, SENYÈ a te di a Moïse: “Fè yon sèpan dife e mete li sou yon poto. Konsa, li va vin rive ke tout moun ki mòde, lè li gade li, l ap viv.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moïse te fè yon sèpan an bwonz e li te mete li sou poto a. Epi li te vin rive ke si yon sèpan te mòde nenpòt moun, lè li te gade vè sèpan an bwonz lan, li te viv. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Alò, fis Israël yo te deplase e te fè kan an nan Oboth. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Yo te vwayaje soti Oboth pou te fè kan an nan Ijje-Abarim, nan dezè ki anfas Moab a lès la. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Soti la, yo te pati pou te fè kan an nan vale Zéred la. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Soti la, yo te vwayaje pou te fè kan an sou lòt kote Arnon an, ki se nan dezè ki sòti nan lizyè Amoreyen yo, paske Arnon se te fwontyè Moab, antre Moab ak Amoreyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Konsa, sa di nan Liv Lagè SENYÈ a: “Vaheb nan Supha, avèk ravin sèch nan Arnon an, ");
INSERT INTO hatbsa_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ak pant ki rive nan ravin sèch yo ki rive jis nan kote Ar la e ki touche nan lizyè Moab la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Soti la, yo rive jis nan Beer, ki se pwi kote SENYÈ a te di Moïse, reyini pèp la pou Mwen kapab bay yo dlo a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Epi Israël te chante chan sila a: “Vin bwote o pwi! Chante a li! ");
INSERT INTO hatbsa_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Pwi a ke prens yo nan pèp la te fouye, Avèk baton wayal ak Baton soutyen pa yo.” Epi soti nan dezè a, yo te kontinye a Matthana, ");
INSERT INTO hatbsa_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","soti Matthana a Nahaliel, soti nan Nahaliel a Bamoth, ");
INSERT INTO hatbsa_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","soti Bamoth nan vale ki nan peyi Moab la, nan pwent lan vè Mòn Pisga ki kanpe anwo tout dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Alò Israël te voye mesaje yo bay Sihon, wa a Amoreyen yo. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Kite mwen pase nan peyi ou a. Nou p ap menm vire nan chan, oswa nan rezen yo. Nou p ap bwè dlo nan pwi yo. Nou va ale nan chemen Wa a jiskaske nou fin depase limit fwontyè pa w la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Men Sihon pa t kite Israël pase nan fwontyè pa li a. Konsa, Sihon te ranmase tout pèp li a pou te sòti kont Israël nan dezè a. Yo te rive a Jahats pou te goumen kont Israël. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Konsa,Israël te frape li avèk tranch nepe, e te pran posesyon peyi li a soti Arnon pou jis rive Jabbok, soti distans a fis Ammon yo; paske nan fwontyè a fis Ammon yo, se te Jazer. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israël te pran tout vil yo e Israël te viv nan tout vil Amoreyen yo, nan Hesbon ak nan tout vil li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Paske Hesbon, se te vil a Sihon, wa a Amoreyen yo, ki te goumen kont ansyen wa Moab la, e li te retire tout peyi li a nan men li, jis rive nan Arnon. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Se pou sa ke sila ki sèvi ak pwovèb yo di: “Vini Hesbon! Kite li bati! Konsa kite vil a Sihon an fin etabli. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Paske yon dife te sòti nan Hesbon, Yon flanm soti nan vil a Sihon; Li te devore Ar nan Moab, Pwent wo yo domine Arnon ");
INSERT INTO hatbsa_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Malè a nou menm, O Moab! Nou gen tan fin gate nèt, O pèp Kemosch la! Li te bay fis li yo kòm sila k ap sove ale, Epi fi li yo kòm kaptif, pou yon wa Amoreyen, Sihon. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nou te tire sou yo. Hesbon fin gate jis rive Dibon. Konsa, nou te fin piyaje jis rive Nophach, Ki rive nèt nan Médaba.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Pou sa a, Israël te viv nan peyi Amoreyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moïse te voye espyone Jaezer. Yo te kaptire vil li yo e te piyaje Amoreyen ki te la yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Epi yo te vire monte nan wout Basan, e Og, wa Basan an, te sòti avèk tout pèp li a pou fè bati Édréï. ");
INSERT INTO hatbsa_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Men SENYÈ a te di a Moïse: “Pa pè li, paske Mwen te bay li nan men nou, tout pèp li a ak tout peyi li a. Ou va fè avèk li jan ou te fè Sihon, wa Amoreyen, ki te viv Hesbon yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Konsa, yo te touye li avèk fis li yo ak tout pèp li a, jis pa t menm gen yon retay ki te rete de li. Konsa, yo te posede peyi li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Fis a Israël yo te vwayaje pou te fè kan an nan plèn Moab yo, fin kite Jourdain an, anfas Jéricho. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Alò Balak, fis Tsippor te wè tout sa ke Israël te fè a Amoreyen yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Konsa, Moab te nan gran perèz akoz pèp la, pwiske yo te anpil; Moab te sezi avèk gwo laperèz akoz fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab te di a ansyen yo a Madian: “Alò, bann moun sa yo va devore tout sa ki antoure nou, jan yon bèf devore zèb nan chan.” Balak, fis a Tsippor a te wa Moab nan tan sa a. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Konsa, li te voye yon mesaje vè Balaam, fis a Beor a nan Pethor, ki toupre Rivyè a, nan peyi a fis pèp li a. Li te di: “Gade byen, yon pèp te sòti an Égypte. Gade byen, yo kouvri sifas peyi a, e y ap viv anfas mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Alò, pou sa, silvouplè, vin mete yon madichon sou pèp sa a pou mwen; paske, yo twò pwisan pou mwen. Petèt mwen kapab fin bat yo, e pouse yo ale deyò peyi a. Paske mwen konnen ke sila ke ou beni an, beni, e sila ke ou modi a, modi.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Konsa, ansyen a Moab yo avèk ansyen a Madian yo te pati avèk frè pou peye divinasyon nan men yo. Yo te vin kote Balaam pou te repete pawòl a Balak yo pou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Li te di yo: “Pase nwit lan isit la, e mwen va pote yon pawòl bannou jan SENYÈ a kab petèt pale avè m.” Epi dirijan Moab yo te rete avèk Balaam. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Epi Bondye te vini a Balaam, e Li te di: “Ki moun sa yo ye ki avèk ou la a?” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam te di a Bondye: “Balak, fis a Tsippor a, wa Moab la te voye yon pawòl ban mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Gade byen, gen yon pèp ki sòti an Égypte, yo kouvri sifas peyi a. Alò, vin modi yo pou mwen. Petèt mwen kapab goumen kont yo, e pouse yo deyò.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Bondye te di a Balaam: “Pa ale avèk yo. Ou p ap modi pèp la, paske yo beni.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Konsa, Balaam te leve nan maten e li te di a chèf Balak yo: “Ale retounen nan peyi nou, paske SENYÈ a refize kite mwen ale avèk nou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Chèf a Moab yo te leve. Yo te ale kote Balak e te di: “Balaam refize vini avèk nou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Alò, Balak te voye chèf yo ankò, plis an kantite e pi gran pase lòt yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Yo te vini a Balaam e te di li: “Konsa pale Balak, fis a Tsippor a: ‘Pa kite anyen, mwen mande ou souple, anpeche ou vini kote mwen; ");
INSERT INTO hatbsa_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","paske vrèman, mwen va onore ou anpil. Mwen va fè nenpòt sa ou mande mwen. Alò, souple, vin modi pèp sa a pou mwen.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam te reponn a sèvitè a Balak yo, “Malgre Balak ta ban mwen kay li plen avèk ajan ak lò, mwen pa ta kapab fè anyen, ni piti ni gran, ki kontrè kòmand SENYÈ a, Bondye mwen an. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Alò, silvouplè, rete isit la aswè a pou m ka twouve ki lòt bagay SENYÈ a va pale mwen.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Bondye te vin kote Balaam nan aswè. Li te di li: “Si mesye sa yo ta vin rele ou, leve ale avèk yo; men se sèlman pawòl ke M pale avèk ou a ke ou va fè.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Konsa, Balaam te leve nan maten. Li te mete yon sèl sou bourik li pou te ale avèk chèf Moab yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Men Bondye te fache akoz li t ap ale a. Konsa, zanj SENYÈ a te vin kanpe nan chemen an kòm yon advèsè kont li. Alò, li te monte sou bourik li, e de sèvitè li yo te avèk li. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Lè bourik la te wè zanj SENYÈ a ki te kanpe nan chemen an avèk nepe li parèt nan men l, bourik la te kite chemen an pou te antre nan chan an. Men Balaam te frape bourik la pou fè l retounen nan chemen an. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Alò, zanj SENYÈ a te kanpe nan yon wout etwat nan chan rezen yo, avèk yon miray sou yon bò, e yon miray sou lòt bò a. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Lè bourik la te wè zanj SENYÈ a, li te peze kò l kont mi an, e li te peze pye Balaam kont lòt mi an. Konsa, Balaam te frape li ankò. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Zanj SENYÈ a te ale pi lwen. Li te kanpe nan yon kote etwat kote pa t gen mwayen pou vire ni adwat, ni agoch. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Lè bourik la te wè zanj SENYÈ a, li te kouche anba Balaam. Pou sa, Balaam te fache e li te frape bourik la avèk baton li. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Konsa, SENYÈ a te ouvri bouch a femèl bourik la, e li te di a Balaam: “Kisa m te fè ou, pou ou bat mwen twa fwa sa yo?” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Alò, Balaam te di a bourik la: “Akoz ou te pase m nan rizib! Si m te gen yon nepe nan men m, Mwen ta gen tan touye ou deja.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Bourik la te di Balaam: “Èske mwen pa bourik ou, sou sila ou te monte pandan tout vi ou jis rive Jodi a? Èske Mwen janm te konn abitye fè ou sa?” Epi li te reponn: “Non”. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Alò, SENYÈ a te ouvri zye a Balaam. Konsa, li te wè zanj a SENYÈ a ki te kanpe nan chemen an avèk nepe a rale nan men li. Balaam te bese jiska tè. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Zanj SENYÈ a te di li: “Poukisa ou te frape bourik ou a twa fwa sa yo? Gade byen, Mwen te parèt kòm yon advèsè, akoz direksyon pa w la te kont Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Men bourik la te wè M, e li te vire akote pou evite Mwen twa fwa sa yo. Si li pa t vire akote Mwen, Mwen ta, vrèman, gen tan touye ou nan moman sa a, e kite li menm viv.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam te di a zanj SENYÈ a: “Mwen te peche, paske mwen pa t konnen ke ou te kanpe nan chemen an kont mwen. Alò, koulye a, si sa pa fè ou plezi, mwen va vire retounen.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Men zanj SENYÈ a te di a Balaam: “Ale avèk mesye sa yo, men ou va pale, sèlman, pawòl ke Mwen di ou yo.” Konsa Balaam te ale avèk chèf Balak yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Lè Balak te tande ke Balaam t ap vini, li te sòti pou rankontre li nan vil Moab la, ki nan fwontyè Arnon an, nan dènye pwent lizyè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Epi Balak te di a Balaam: “Èske mwen pa t voye kote ou an ijans? Poukisa ou pa t vin kote mwen? Èske, vrèman, mwen pa kapab onore ou?” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Konsa, Balaam te di a Balak: “Gade byen, Mwen gen tan vini koulye a! Èske mwen kapab pale yon bagay menm? Pawòl ke Bondye mete nan bouch mwen an, se sa ke mwen va pale.” ");
INSERT INTO hatbsa_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Epi Balaam te sòti avèk Balak e yo te vini Kirjath-Hutsoth, ");
INSERT INTO hatbsa_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak te fè sakrifis bèf avèk mouton, e li te voye kèk bay Balaam avèk chèf ki te avèk li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Epi li te rive nan maten ke Balak te pran Balaam pou te mennen li monte nan wo plas a Baal yo. E li te wè depi la, yon pati nan pèp Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Alò, Balaam te di a Balak: “Bati sèt lotèl pou mwen isit la, e prepare sèt towo pou mwen isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak te fè ojis sa ke Balaam te pale a. Balak avèk Balaam te ofri yon towo avèk yon belye sou chak lotèl. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam te di a Balak: “Kanpe bò kote ofrann brile pa w la, e mwen va ale. Petèt SENYÈ a va vin rankontre m, e nenpòt sa ke Li montre mwen, mwen va di ou li.” Konsa, li te ale kote yon ti mòn ki pa t gen anyen sou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Bondye te rankontre Balaam, e li te di Li: “Mwen te ranje sèt lotèl yo, e mwen te ofri yon towo avèk yon belye sou chak lotèl.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Konsa, SENYÈ a te mete yon pawòl nan bouch Balaam. Li te di: “Retounen kote Balak. Ou va pale konsa.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Konsa, li te retounen kote li. E gade byen, Balak te kanpe bò kote ofrann brile li a; li menm avèk tout chèf Moab yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaam te pran diskou li, e te di: “Depi nan Aram, Balak te mennen m, wa Moab ki soti nan mòn Lès yo. ‘Vin modi Jacob pou mwen. Vin denonse Israël!’ ");
INSERT INTO hatbsa_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Kijan mwen kapab modi, lè Bondye pa t modi? Epi kijan mwen kapab denonse sila ke SENYÈ a pa t denonse? ");
INSERT INTO hatbsa_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","“Jan mwen konn wè li soti anwo nan pwent wòch yo, e mwen gade li depi sou kolin yo. Gade byen, yon pèp ki rete apa, ki p ap kab konte pami nasyon yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Kilès ki kab konte pousyè a Jacob, oswa konte menm yon ka an Israël? Kite mwen mouri lanmò a jis yo, pou lafen pa mwen an tankou pa li.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Konsa, Balak te di a Balaam: “Kisa ou te fè m konsa? Mwen te pran ou pou modi lènmi mwen yo, e gade byen, ou te vrèman beni yo!” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Li te reponn: “Èske mwen pa oblije fè atansyon pou pale sa ke SENYÈ a mete nan bouch mwen?” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Alò Balak te di li: “Souple, vin avèk mwen nan yon lòt kote pou ou ka wè yo. Malgre w ap wè sèlman ti bout a dènye pwent lan, e ou p ap wè tout a yo. Modi yo pou mwen depi la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Konsa, li te pran li rive nan chan Tsophim nan, nan pwent Mòn Pigsa a. Li te bati sèt lotèl e li te ofri yon towo avèk yon belye sou chak lotèl. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Konsa, li te di a Balak: “Kanpe bò kote ofrann brile ou a, pandan mwen menm, mwen ap rankontre SENYÈ a soti lòtbò.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Alò, SENYÈ a te rankontre Balaam e Li te mete yon pawòl nan bouch li. Li te di li: “Retounen jwenn Balak, e konsa ou va pale.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Li te vin kote li, e gade byen, li te kanpe bò kote ofrann brile pa li a, epi chèf Moab yo te avèk li. Konsa, Balak te di li: “Kisa SENYÈ a te pale a?” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Alò, li te pran diskou li. Li te di: “Leve ou menm, O Balak, pou tande! Ban m zòrèy ou, O fis a Tsippor! ");
INSERT INTO hatbsa_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bondye se pa yon nonm ke li ye pou L ta bay manti, ni fis a yon nonm pou L ta repanti. Èske Li pa t pale, e èske Li p ap fè l vre? ");
INSERT INTO hatbsa_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Gade byen, mwen te resevwa lòd pou beni. Lè se Li menm ki beni, alò, mwen p ap kab revoke sa. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Li pa t wè malè nan Jacob, ni Li pa t wè twoub nan Israël. SENYÈ a, Bondye li a avè l, epi gran vwa a yon wa pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Bondye mennen yo sòti an Égypte. Li pou yo tankou kòn sou bèf mawon. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Paske, nanpwen wanga kont Jacob, ni pa gen divinasyon kont Israël. Nan tan etabli a, li va pale a Jacob, e a Israël de sa Bondye te fè a! ");
INSERT INTO hatbsa_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Gade byen, yon pèp ki leve tankou yon manman lyon, tankou yon lyon li leve li menm. Ni li p ap kouche jiskaske li fin devore viktim nan, pou l bwè san a sila li touye a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Alò, Balak te pale a Balaam: “Pa modi yo ditou, ni pa beni yo ditou!” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Men Balaam te reponn a Balak: “Èske mwen pa t di ou, ‘Nenpòt sa ke SENYÈ a pale, se sa mwen oblije fè’?” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Alò Balak te di a Balaam: “Souple, vini; mwen va mennen ou yon lòt kote. Petèt li va agreyab a Bondye pou ou modi yo depi kote sa a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Konsa, Balak te pran Balaam vè tèt mòn Peor ki domine tout dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam te di a Balak, “Bati sèt lotèl pou mwen isit la, e prepare sèt towo ak sèt belye pou mwen isit la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak te fè jan ke Balaam te di a, e li te ofri yon towo avèk yon belye sou chak lotèl. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Lè Balaam te wè ke sa te fè SENYÈ a plezi pou beni Israël, li pa t ale tankou lòt fwa yo pou chache wanga, men li te fikse figi li vè dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Konsa, Balaam te leve zye li anwo, li te wè Israël ki t ap fè kan, tribi pa tribi; epi Lespri Bondye te vini sou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Li te reprann diskou li e te di: “Pòt pawòl a Balaam nan, fis a Beor a, Pòt pawòl a nonm ki gen zye louvri a; ");
INSERT INTO hatbsa_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Pòt pawòl a sila ki koute pawòl a Bondye yo, ki wè vizyon Toupwisan an, ki t ap tonbe, men zye li gen tan vin debouche. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ala tant nou yo bèl, O Jacob, ak abitasyon nou yo, O Israël! ");
INSERT INTO hatbsa_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Tankou vale ki vin ouvri byen laj, tankou jaden ki bò kote rivyè yo, tankou plan lalwa ki plante pa SENYÈ a, tankou bwa sèd ki bò kote dlo yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Dlo yo va koule nan bokit li yo, e jèm desandan li yo va bò kote anpil dlo. Wa li a va pi wo pase Agag, e wayòm li a va vin egzalte. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Bondye mennen l sòti an Égypte. Li pou li tankou kòn a yon bèf mawon. Li va devore nasyon ki advèsè li yo. Li va kraze zo yo an mòso, Li va kraze yo avèk flèch li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Li koube ba, li kouche tankou yon lyon; tankou yon manman lyon. Se kilès ki kab tante deranje l? Beni se tout moun ki beni ou, e modi se tout moun ki modi ou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Konsa, kòlè Balak te brile kont Balaam. Li frape men l ansanm; epi li te di a Balaam: “Mwen te rele ou pou modi lènmi mwen yo, men gade, ou te pèsiste nan beni yo menm twa fwa sa yo! ");
INSERT INTO hatbsa_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Pou sa, kouri ale nan plas ou koulye a. Mwen te di ke mwen ta onore ou anpil, men gade byen, SENYÈ a te anpeche ou resevwa onè a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam te di a Balak: “Èske mwen pa t di mesaje ke ou te voye kote mwen yo: ");
INSERT INTO hatbsa_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ke menm si Balak te ban mwen kay li plen avèk ajan ak lò, ke m pa t kab fè anyen kontrè ak lòd SENYÈ a, kit bon kit mal nan pwòp volonte pa m. Sa ke SENYÈ a pale a, se sa mwen va pale? ");
INSERT INTO hatbsa_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Epi koulye a, veye byen, mwen ap prale kote pèp mwen an. Vini, mwen va bay ou konsèy sou sa ke pèp sa a va fè a pèp pa ou a nan jou k ap vini yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Li te reprann diskou li e te di: “Pòt pawòl a Balaam nan, fis a Beor a, e pòt pawòl a nonm avèk zye louvri a di, ");
INSERT INTO hatbsa_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Li di ki tande pawòl Bondye yo, ki gen konesans a Trè Wo a, ki wè vizyon a Toupwisan an, k ap tonbe, men ak zye li ki gen tan fin ouvri. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mwen wè li, men pa koulye a. Mwen gade l, men pa toupre. Yon zetwal va sòti nan Jacob. Yon baton a wa va leve sòti an Israël. Li va kraze travèse fwon Moab la, e li va dechire tout fis a Seth yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Édom va yon posesyon pou li. Séir, lènmi li, osi, va yon posesyon pou li, pandan Israël ap aji avèk gwo kouraj. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Youn ki soti nan Jacob va gen tout pouvwa, li va detwi retay lavil la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Li te gade Amalec. Li te reprann diskou li e li te di: “Amalec se te premye nan nasyon yo, men lafen li pi lwen se destriksyon.” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Epi li te gade Kenizyen an, li te reprann diskou li e li te di: “Kote ou rete a, gen andirans. Nich kote ou chita nan falèz la. ");
INSERT INTO hatbsa_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Malgre, Cain va gate nèt, jis lè Asiryen yo pote nou ale an kaptif?” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Epi li te vin reprann diskou li. Li te di: “Ay, kilès ki ka viv lè Bondye fè sa a? ");
INSERT INTO hatbsa_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Men gwo bato yo va sòti nan kòt Kittim. Yo va pini Asiryen yo, yo va aflije Éber. Men li menm tou va vin detwi.” ");
INSERT INTO hatbsa_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Konsa, Balaam te leve e te pati pou retounen nan plas li, e Balak osi te al fè wout li. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Pandan Israël te rete nan Sittim, pèp la te kòmanse pwostitiye tèt yo avèk fi Moab yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Paske yo te envite pèp la pou vini nan sakrifis dye pa yo. Pèp la te manje, e te bese devan dye yo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Konsa, Israël te vin jwenn yo menm avèk Baal Peor, e SENYÈ a te vin fache kont Israël. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","SENYÈ a te di a Moïse: “Pran tout chèf a pèp la e touye yo gwo lajounen devan SENYÈ a, pou gran kòlè a SENYÈ a kapab vire kite Israël.” ");
INSERT INTO hatbsa_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Konsa, Moïse te di a jij Israël yo: “Chak nan nou va touye pwòp mesye pa li ki te jwenn yo menm avèk Baal Peor la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Alò, vwala, youn nan fis Israël yo te vini pou te mennen bay a fanmi li yo yon fanm Madyanit, devan zye Moïse e devan zye a tout kongregasyon fis Israël yo, pandan yo tout t ap kriye devan pòtay tant asanble a. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Lè Phinées, fis Éléazar, fis a Aaron, prèt la, te wè sa, li te leve nan mitan kongregasyon an. Li te pran yon frenn nan men l, ");
INSERT INTO hatbsa_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","epi li te ale dèyè Izrayelit la nan tant lan e li te frennen tranche kò yo toulède nèt, mesye Israël la ak fanm nan. Konsa gwo epidemi sou fis Israël yo te vin sispann. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Sila ki te mouri yo akoz gwo epidemi an se te venn-kat-mil (24,000). ");
INSERT INTO hatbsa_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Phinées, fis a Éléazar, fis a Aaron, prèt la, te fè detounen kòlè Mwen vè fis Israël yo, akoz li te jalou avèk jalouzi pa Mwen an pami yo; epi konsa, Mwen pa t detwi fis Israël yo nan jalouzi pa Mwen an. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","“Pou sa pale: ‘Gade byen, Mwen bay li akò lapè Mwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Li va pou li avèk desandan apre li yo, yon akò pozisyon prèt pou tout tan, akoz ke li te jalou pou Bondye li a, e li te fè ekspiyasyon pou fis Israël yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Alò, non a Izrayelit ki te touye avèk fanm Madyanit la se te Zimri, fis Salu, yon chèf kay pami Simeyonit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Non a fanm Madyanit ki te touye a se te Cozbi, fi a Zur, ki te chèf kay zansèt a yon pèp nan Madian. ");
INSERT INTO hatbsa_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Alò, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Se pou ou vin mechan avèk Madyanit yo, e frape yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","paske yo te mechan avèk nou avèk riz pa yo, avèk sila, yo twonpe nou nan zafè Peor la ak nan zafè Cozbi a, fi a chèf Madian an, sè ki te touye nan jou gwo epidemi an pou koz a Peor a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Konsa, li te vin rive apre gwo epidemi an ke SENYÈ a te pale avèk Moïse e avèk Éléazar, fis Aaron an, prèt la. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Fè yon kontwòl sou tout kongregasyon a fis Israël la soti nan laj ventan oswa plis, pou lakay zansèt a papa yo, nenpòt moun ki kapab sòti pou fè lagè an Israël. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Se konsa ke Moïse avèk Éléazar te pale avèk yo nan plèn Moab la, akote Jourdain an, anfas Jéricho. Di yo: ");
INSERT INTO hatbsa_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Fè yon kontwòl a pèp la soti nan laj a ventan oswa plis, jan SENYÈ a te kòmande Moïse la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, premye ne an Israël la, fis a Ruben yo: a Hénoc, fanmi a Enokit yo; a Pallu, fanmi a Paliyit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","a Hetsron, fanmi a Estwonit yo; a Carmi, fanmi a Kamit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Sila yo se fanmi a Ribenit yo: sila ki te konte nan yo a se te karann-twa-mil-sèt-san-trant (43,730). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Fis a Pallu yo: Éliab. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Fis a Éliab yo: Nemeul, Dathan ak Abiram. Sila yo se te Dathan avèk Abiram ki te rele pa kongregasyon an, ki te kont Moïse ak Aaron nan konpanyen Koré yo lè yo te kont SENYÈ a, ");
INSERT INTO hatbsa_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","epi tè a te vin ouvri bouch li e te vale yo ansanm avèk Koré, lè konpanyen sa yo te vin mouri, lè dife a te devore de-san-senkant (250) mesye. Konsa, yo te devni yon egzanp. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Sepandan, fis a Koré yo pa t mouri. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Fis a Siméon yo selon fanmi pa yo: a Nemeul, fanmi Nemilit yo, a Jamin, fanmi a Jaminit yo; a Jakin, fanmi a Jakinit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","a Zérach, fanmi a Zerakit yo; a Saül, fanmi a Saoulit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Sila yo se fanmi a Simeyonit yo, venn-de-mil-de-san (22,200). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Fis a Gad selon fanmi pa yo: a Tsephon, fanmi a Sefonit yo; a Haggi, fanmi a Agit yo; a Schuni, fanmi a Chounit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","a Ozni, fanmi a Oznit yo; a Éri, fanmi a Erit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","a Arod, fanmi a Awodit yo; a Areéli, fanmi a Areyelit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Sila yo se fanmi a fis a Gad yo selon sila ki te konte nan yo, te karant-mil-senk-san (40,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Fis a Juda yo te Er avèk Onan, men Er avèk Onan te mouri nan peyi Canaran. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Fis a Juda yo selon fanmi pa yo te: Schéla, fanmi a Chelanit yo; a Peret, fanmi a Peretit yo; a Zérach, fanmi a Zerakit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Fis a Peret yo te: a Hetsron, fanmi a Etswonit yo; a Hamul, fanmi a Amilit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Sila yo se fanmi a Juda selon sila ki te konte nan yo, se te swasann-sèz-mil-senk-san (76,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Fis a Issacar yo selon fanmi pa yo: a Thola, fanmi a Tolatit yo; a Puva, fanmi a Pivit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","a Jaschub, fanmi a Jachoubit yo; a Shimron, fanmi a Chimwonit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Sila yo se fanmi a Issacar, selon sila ki te konte nan yo, se te swasann-kat-mil-twa-san (64,300). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Fis a Zabulon yo selon fanmi pa yo: a Séred, fanmi a Seredit yo; a Élon, fanmi a Elonit yo; a Jaheel, fanmi a Jayelit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sila yo se fanmi a Zabilonit yo selon sila yo ki te konte nan yo, se te swasant-mil-senk-san (60,500). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Fis a Joseph yo selon fanmi pa yo: Manassé ak Ephraïm. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Fis a Manassé yo: a Makir, fanmi a Makirit yo; epi Makir te devni papa a Galaad; a fanmi Galaadit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Sila yo se fis a Galaad yo: a Jézer, fanmi a Jezerit yo; a Hélek, fanmi a Helekit yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","epi a Asriel, fanmi a Asriyelit yo; epi Sichem, fanmi a Sichemit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","epi a Schemida, fanmi a Schemidayit yo; epi a Hépher, fanmi a Eferit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Alò, Tselophchad, fis a Hépher a, pa t gen fis, men sèlman fi; epi non a fi a Tselophchad yo se te Machla, Noa, Hogla, Milca, ak Thirtsa. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Sila yo se fanmi a Manassé yo; epi sila ki te konte nan yo, se te senkann-de-mil-sèt-san (52,700). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Sila yo se fis a Ephraïm yo selon fanmi pa yo: a Schutélach, fanmi a Chutelachit yo; a Béker, fanmi a Bekerit yo; a Thachan, fanmi a Tachanit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sila yo se fis a Schutélach yo: a Éran fanmi a Eranit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Sila yo se fanmi a fis a Ephraïm yo selon sila ki konte nan yo, se te trann-de-mil-senk-san (32,500). Sila yo se fis a Joseph yo selon fanmi pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Fis a Benjamin yo selon fanmi pa yo: a Béla, fanmi a Belit yo; a Aschbel, fanmi a Achbelit yo; a Achiram, fanmi a Achiramit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","a Schupham, fanmi a Choufamit yo; a Hupham, fanmi a Oufamit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Fis a Béla yo se te: Ard ak Naaman: nan Ard, fanmi a Adit yo; nan Naaman, fanmi a Naamanit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Sila yo se fis a Benjamin selon fanmi pa yo; epi sila ki te konte nan yo, se te karann-senk-mil-sis-san (45,600). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Sila yo se fis a Dan yo selon fanmi pa yo: a Schucham, fanmi a Chouchamit yo. Sila yo se fanmi a Dan selon fanmi pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Tout fanmi a Chouchamit yo selon sila ki te konte nan yo, se te swasann-kat-mil-kat-san (64,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Fis a Aser yo, selon fanmi pa yo: a Jimna, fanmi a Jimnit yo; a Jischvi, fanmi a Jischvit yo; a Beria, fanmi a Berit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","A fis a Beria yo: Héber, fanmi a Eberit yo; a Malkiel, fanmi a Malkyelit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Fi a Aser a te rele Sérach. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Sila yo se fanmi a fis Aser yo selon sila ki te konte nan yo, se te senkant-twa-mil-kat-san (53,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Fis a Nephtali yo, selon fanmi pa yo: a Jahtséel, fanmi a Jatseyelit yo; a Guni, fanmi a Gounit yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","A Jetser, fanmi a Jetsrit yo; a Schillem, fanmi a Chilemit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Sila yo se fanmi a Nephtali yo selon fanmi pa yo, epi sila ki te konte avèk yo, se te karann-senk-mil-kat-san (45,400). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Sila yo se sa yo ki te konte nan fis Israël yo, sis-san-en-mil-sèt-san-trant (601,730). ");
INSERT INTO hatbsa_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Alò SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Pami sila yo, peyi a va divize kòm yon eritaj selon fòs kantite pèp la. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Nan sila ki pi gran yo, ou va ogmante eritaj pa yo, e nan pi piti yo, ou va diminye eritaj yo. Chak va bay eritaj yo selon sila ki te konte nan yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Men peyi a va divize pa tiraj osò. Yo va resevwa eritaj yo selon fòs kantite ki te konte pami yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Selon tiraj osò a, eritaj pa yo a va divize antre sila ki pi gran ak sila ki pi piti yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Sila yo se sa yo ki te konte pami Levit yo selon fanmi pa yo: a Guerschon, vin desann fanmi a Gèchonit yo; a Kehath, fanmi a Keyatit yo; a Merari, fanmi a Merarit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Sila yo se fanmi a Levi yo: fanmi a Libnit yo, fanmi a Ebwonit yo, fanmi a Machlit yo, fanmi a Mouchit yo, fanmi a Korit yo. Kehath te devni papa a Amram. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Non a madanm Amram nan se te Jokébed, fi pou Levi a, ki te ne a Levi an Égypte; epi li te fè pou Amram: Aaron avèk Moïse avèk sè yo, Marie. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Pou Aaron te ne Nadab avèk Abihu, Éléazar ak Ithamar. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Men Nadab avèk Abihu te mouri lè yo te ofri dife etranje devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Sila ki te konte nan yo te venn-twa-mil (23,000), tout gason soti nan yon mwa oswa plis, paske yo pa t konte pami fis a Israël yo akoz pa t gen eritaj ki te bay a yo menm pami fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Sila yo se sa ki te konte pa Moïse avèk Éléazar, prèt la, ki te konte fis a Israël yo, nan plèn a Moab bò kote Jourdain an, nan Jéricho. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Men pami sila yo, pa t gen yon mesye nan sa yo ki te konte pa Moïse avèk Aaron, prèt la, ki te konte fis a Israël yo nan dezè a Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Paske, SENYÈ a te di a yo menm: “Yo va, anverite, mouri nan dezè a.” Epi pa menm youn nan yo te rete, sof ke Caleb, fis a Jephaunné a avèk Josué, fis a Nun nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Alò fis Tselophchad yo, fis a Hépher a, fis a Galaad la, fis a Makir a, fis a Manassé a, nan fanmi a Manassé, fis a Joseph la, te vin rapwoche; epi sila yo se non a fi li yo: Machia, Noe, Hogla, Milca, ak Thirtsa, ");
INSERT INTO hatbsa_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Yo te kanpe devan Moïse ak Éléazar, prèt la, ak devan chèf a tout kongregasyon yo, nan pòtay a tant asanble a, e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Papa nou te mouri nan dezè a. Malgre sa, li pa t pami konpanyen a sila ki te rasanble yo menm kont SENYÈ a nan konpanyen a Koré yo, men li te mouri nan pwòp peche pa li. E li pa t gen fis. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Poukisa non a papa nou ta dwe retire soti nan fanmi li akoz ke li pa t gen fis? Bannou yon posesyon pami frè a papa nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Alò, Moïse te mennen ka yo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Fi a Tselophchad yo gen rezon nan sa yo di a. Ou va, vrèman, ba yo yon posesyon eritaj pami frè a papa yo, e ou va transfere eritaj a papa yo a ba yo menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Anplis, ou va pale avèk fis Israël yo e di: ‘Si yon nonm mouri e li pa t gen fis, ou va transfere eritaj li a bay fi li. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Si li pa gen fi, alò, ou va bay eritaj li a a frè li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Si li pa gen frè, alò, ou va bay eritaj li a a frè papa li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Si papa li pa gen frè, alò, ou va bay eritaj li a a fanmi ki pi prè nan pwòp fanmi li. Li va posede li. Konsa, sa va yon règleman nèt pou fis Israël yo jis jan ke SENYÈ a te kòmande Moïse la.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Alò, SENYÈ a te di a Moïse: “Monte nan mòn Abarim nan, pou wè peyi ke Mwen te bay a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Lè ou fin wè li, ou va vin rasanble vè zansèt ou yo, jan sa te rive avèk frè ou a, Aaron. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Paske, nan dezè Tsin nan, pandan asanble a t ap fè kont, ou te fè rebèl kont lòd Mwen pou trete Mwen tankou sen devan zye yo kote dlo a.” (Sila yo se dlo a Meriba yo nan Kadés nan dezè a Tsin nan.) ");
INSERT INTO hatbsa_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","“Alò, Moïse te pale avèk SENYÈ a. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Ke SENYÈ a, Bondye a lespri tout chè yo, ta chwazi yon mesye sou kongregasyon an, ");
INSERT INTO hatbsa_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ki va sòti e antre devan yo, ki va mennen yo deyò, e rale yo antre, pou kongregasyon SENYÈ a pa devni tankou yon mouton ki san bèje.” ");
INSERT INTO hatbsa_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Konsa SENYÈ a te di a Moïse: “Pran Josué, fis a Nun nan, yon nonm nan sila Lespri a rete a, e poze men ou sou li. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Konsa, fè li kanpe devan Éléazar, prèt la, ak devan tout kongregasyon an, e ba li lòd komisyon an devan zye yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ou va mete otorite pa w sou li, pou tout kongregasyon a fis Israël yo kapab obeyi a li menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Anplis, li va kanpe devan Éléazar, prèt la, ki va fè ankèt pou li selon jijman a Orim nan devan SENYÈ a. A kòmand pa li, yo va sòti e a kòmand pa li, yo va antre, ni li, ni fis Israël yo avèk li menm, tout kongregasyon an menm.” ");
INSERT INTO hatbsa_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moïse te fè jis sa ke SENYÈ a te kòmande li. Li te pran Josué e te mete li devan Éléazar, prèt la, avèk tout kongregasyon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Konsa, li te poze men li sou li e te bay li lòd komisyon an, jis jan ke SENYÈ a te pale pa Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Bay lòd a fis Israël yo, e di yo: “Ou va fè atansyon pou prezante ofrann Mwen yo, manje Mwen pou ofrann pa dife Mwen yo, a yon odè ki santi bon anvè Mwen, nan lè ki deziye pou yo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ou va di yo: ‘Sa se ofrann pa dife ke ou va ofri bay SENYÈ a: de mal mouton nan laj 1 nan, san defo, yon ofrann chak jou ki p ap janm sispann. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ou va ofri yon jenn mouton nan maten e lòt jenn mouton an nan aswè lè l fenk kòmanse fènwa; ");
INSERT INTO hatbsa_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","osi, yon dizyèm efa farin fen kòm yon ofrann sereyal mele avèk yon ka hin lwil ki bat. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Li se yon ofrann brile tout tan ki te òdone nan mòn Sinaï kòm yon odè ki bon, yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Epi ofrann bwason li va yon ka hin lwil pou chak mouton. Ou va vide yon ofrann bwason ak bwason fò a SENYÈ a, nan plas ki sen an. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Lòt jenn mouton an, ou va ofri li nan aswè lè l fenk kòmanse fènwa. Menm jan ak ofrann sereyal maten an, ak ofrann bwason pa l, ou va ofri li, yon ofrann pa dife, yon odè ki bon bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“‘Epi nan jou Saba a, de jenn mouton mal san defo, ak de dizyèm a yon efa farin fen, kon yon ofrann sereyal, mele avèk lwil, avèk ofrann bwason li an: ");
INSERT INTO hatbsa_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Sila a se ofrann brile a chak Saba, anplis ke ofrann brile tout tan ki fèt kontinyèlman, ak ofrann bwason an. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“‘Nan kòmansman a chak nan mwa nou yo, nou va prezante yon ofrann brile a SENYÈ a: de towo avèk yon belye, sèt jenn mal mouton, avèk laj 1 nan san defo, ");
INSERT INTO hatbsa_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","epi twa dizyèm efa farin fen mele avèk lwil pou yon ofrann sereyal pou chak towo; epi de dizyèm nan farin fen mele avèk lwil pou yon ofrann pou yon sèl belye; ");
INSERT INTO hatbsa_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","epi yon dizyèm efa farin fen mele avèk lwil kòm yon ofrann sereyal pou chak jenn mouton, kòm yon ofrann brile, yon odè ki santi bon, yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ofrann bwason pa yo a va avèk yon mwatye hin diven pou yon towo, yon tyè hin pou belye a, ak yon ka hin pou yon jenn mouton. Sa se ofrann brile a pou chak mwa pandan tout mwa nan ane yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Epi yon mal kabrit kòm yon ofrann peche bay SENYÈ a. Li va ofri anplis ke ofrann brile ki pou fèt tout tan yo avèk ofrann bwason li. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“‘Alò, nan katòzyèm jou a, nan premye mwa a, se va Pak SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Nan kenzyèm jou nan mwa a, va gen yon fèt pen san ledven ki va manje pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Nan premye jou fèt la, yon konvokasyon sen; nou pa pou fè okenn travay ki di. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Nou va prezante yon ofrann pa dife, yon ofrann brile bay SENYÈ a: de towo avèk yon belye ak sèt mal mouton nan laj 1 nan, ki san defo, ");
INSERT INTO hatbsa_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","avèk ofrann sereyal pa yo, nou va ofri farin fen mele avèk lwil. Nou va ofri twa dizyèm efa pou yon towo ak de dizyèm pou belye a. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Yon dizyèm efa, nou va ofri li pou chak nan sèt jenn mouton yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","epi yon mal kabrit pou yon ofrann peche pou fè ekspiyasyon pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Nou va prezante sa yo anplis ke ofrann brile maten an, ki se pou yon ofrann brile k ap fèt tout tan. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Nan menm jan sila a, nou va prezante li chak jou pandan sèt jou, manje a ofrann pa dife a, kòm yon odè ki santi bon a SENYÈ a. Li va prezante avèk ofrann bwason pa li an ki anplis ofrann brile k ap fèt tout tan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Nan setyèm jou a, nou va fè yon konvokasyon sen. Nou pa pou fè okenn travay ki di. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“‘Osi, nan jou premye fwi yo, lè nou prezante yon ofrann sereyal nèf bay SENYÈ a nan fèt semèn yo, nou va fè yon konvokasyon sen. Nou pa pou fè okenn travay ki di. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Nou va ofri yon ofrann brile pou yon odè ki bon a SENYÈ a: de jenn towo, yon belye, sèt mal mouton nan laj 1 nan; ");
INSERT INTO hatbsa_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","epi ofrann sereyal pa yo, farin fen mele avèk lwil: twa dizyèm efa pou chak towo, de dizyèm pou yon belye. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Yon dizyèm pou chak nan sèt jenn mouton yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","osi yon mal kabrit pou fè ekspiyasyon pou nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Anplis, ofrann brile kontinyèl la avèk ofrann sereyal li an, nou va prezante yo avèk ofrann bwason pa yo a. Yo va san defo. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“‘Alò, nan setyèm mwa nan premye jou nan mwa a, nou va osi fè yon konvokasyon sen. Nou pa pou fè okenn travay ki di. Li va pou nou yon jou pou soufle twonpèt. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Ou va ofri yon ofrann brile kòm yon odè ki bon a SENYÈ a: yon towo, yon belye, ak sèt mal mouton nan laj 1 nan, san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","osi, ofrann sereyal pa yo, farin fen mele avèk lwil: twa dizyèm efa pou towo a, de dizyèm pou belye a, ");
INSERT INTO hatbsa_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","epi yon dizyèm pou chak nan sèt jenn mouton yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Ofri yon mal kabrit pou yon ofrann peche, pou fè ekspiyasyon pou nou, ");
INSERT INTO hatbsa_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","anplis, ofrann brile a lalin nèf yo avèk ofrann sereyal li, ofrann brile ki fèt tout tan an avèk ofrann sereyal li, ofrann bwason pa li, selon òdonans pa yo, pou yon odè ki santi bon, yon ofrann pa dife bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“‘Epi nan dizyèm jou nan setyèm mwa a, nou va fè yon konvokasyon sen, e nou va imilye nou. Nou p ap fè okenn travay. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Nou va prezante yon ofrann brile bay SENYÈ a kòm yon odè ki santi bon: yon towo, yon belye, sèt mal mouton nan laj 1 nan, ki pa gen okenn defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","epi ofrann sereyal pa yo, farin fen mele avèk lwil: twa dizyèm efa pou towo a, de dizyèm pou yon belye, ");
INSERT INTO hatbsa_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","yon dizyèm pou chak nan sèt jenn mouton yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","yon mal kabrit pou yon ofrann peche, anplis ke ofrann peche pou ekspiyasyon an, epi ofrann brile ki fèt tout tan an, avèk ofrann sereyal la, ak ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“‘Nan kenzyèm jou a nan setyèm mwa a, nou va fè yon konvokasyon sen. Nou va obsève yon fèt a SENYÈ a pandan sèt jou. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Nou va prezante yon ofrann brile, yon ofrann pa dife kòm yon odè ki santi bon a SENYÈ a: trèz towo, de belye, katòz mal mouton nan laj 1 nan, ki san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","epi ofrann sereyal pa yo, farin fen mele avèk lwil: twa dizyèm efa pou chak nan trèz towo yo, de dizyèm pou chak nan de belye yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","epi yon dizyèm pou chak nan katòz belye yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","epi yon mal mouton pou yon ofrann peche, anplis ofrann brile kontinyèl la, ofrann sereyal la, ak ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“‘Epi nan dezyèm jou a: douz towo, de belye, katòz mal mouton nan laj 1 nan san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","epi ofrann sereyal avèk ofrann bwason pa yo pou towo yo, pou belye yo ak pou jenn mouton yo, pa nimewo a yo selon òdonans lan; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","epi yon mal kabrit kòm yon ofrann peche, anplis ofrann kontinyèl la avèk ofrann sereyal ak ofrann bwason pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“‘Epi nan twazyèm jou a: onz towo, de belye, katòz mal mouton nan laj 1 nan san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","epi ofrann sereyal pa yo, ofrann bwason pou towo yo, pou belye yo ak pou jenn mouton yo, selon nimewo òdonans lan; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","epi yon mal kabrit kòm yon ofrann peche, anplis de ofrann brile k ap fèt tout tan an, ofrann sereyal la, ak ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“‘Epi nan katriyèm jou a: de towo, de belye, katòz mal mouton nan laj 1 nan san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","ofrann sereyal pa yo a ak ofrann bwason pou towo yo, pou belye yo ak pou jenn ti mouton yo, selon nimewo òdonans lan; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","epi yon mal kabrit kòm yon ofrann peche, anplis ofrann brile ki fèt tout tan an, ofrann sereyal la ak ofrann bwason pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“‘Epi nan senkyèm jou a: nèf towo, de belye, katòz mal mouton nan laj 1 nan san defo’ ");
INSERT INTO hatbsa_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","epi ofrann sereyal pa yo ak ofrann bwason pou towo yo, pou belye yo ak pou mouton yo selon nimewo òdonans lan; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","epi yon mal kabrit kòm yon ofrann peche, anplis de ofrann brile ki fèt tout tan an ak ofrann sereyal avèk ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“‘Alò, nan sizyèm jou a: uit towo, de belye, katòz mal mouton 1 nan san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","epi ofrann sereyal yo ak ofrann bwason pou towo yo, pou belye yo ak pou jenn ti mouton yo, selon nimewo òdonans lan; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","epi yon mal kabrit kòm yon ofrann peche, anplis de ofrann brile ki fèt tout tan an avèk ofrann sereyal ak ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“‘Alò, nan setyèm jou a: sèt towo, de belye, katòz mal mouton nan laj 1 nan, san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","epi ofrann sereyal pa yo ak ofrann bwason yo pou towo yo, pou belye yo ak pou jenn mouton yo selon nimewo òdonans lan, ");
INSERT INTO hatbsa_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","epi yon mal kabrit kòm yon ofrann peche, anplis de ofrann brile ki fèt tout tan an, ofrann sereyal la ak ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“‘Nan uityèm jou a, nou va fè yon asanble solanèl; nou pa pou fè okenn travay di nan jou sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Men nou va prezante yon ofrann brile, yon ofrann pa dife kòm yon ofrann ki santi bon bay SENYÈ a: yon towo, yon belye, sèt mal mouton nan laj 1 nan san defo; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","ofrann sereyal la ak ofrann bwason pa yo pou towo a, pou belye a ak pou jenn mouton yo, selon nimewo òdonans lan; ");
INSERT INTO hatbsa_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","epi yon mal kabrit kòm yon ofrann peche, anplis de ofrann brile ki fèt tout tan an ak ofrann sereyal la avèk ofrann bwason pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“‘Nou va prezante sila yo bay SENYÈ a nan lè fèt apwente nou chwazi yo—anplis, ofrann ve nou yo ak ofrann bòn volonte nou yo—pou ofrann brile nou yo, pou ofrann sereyal pa nou yo, ofrann bwason pa nou yo ak ofrann lapè nou yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Moïse te pale avèk fis Israël yo an akò avèk tout sa ke SENYÈ a te kòmande li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Alò, Moïse te pale a chèf a tribi fis Israël yo. Li te di: “Sa se pawòl ke SENYÈ a te kòmande a. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Si yon nonm fè yon ve a SENYÈ a, oswa fè yon sèman ki mare li ak yon angajman, li pa pou vyole pawòl li. Li va fè li an akò avèk tout sa ki sòti nan bouch li. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Osi, si yon fanm fè yon ve a SENYÈ a, e li mare li ak yon angajman lakay papa li, pandan jenès li, ");
INSERT INTO hatbsa_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","epi papa li te tande ve li a, angajman pa sila li te mare tèt li a, e papa li pa di li anyen, alò, tout ve li yo va kanpe e tout angajman pa sila li te mare tèt li yo, yo va kanpe. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Men si papa li ta anpeche li nan jou ke li tande sa a, okenn nan ve sa yo ni angajman pa sila li te mare tèt li yo, p ap kanpe. SENYÈ a va padone li akoz ke papa li te anpeche li. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Si li ta marye pandan li anba ve oswa sèman a bouch li ki te manke sajès la, pa sila li te vin mare tèt li a, ");
INSERT INTO hatbsa_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","epi mari li tande sa e li pa di anyen a li menm nan jou ke li tande sa a; alò, ve li a va kanpe, e angajman pa sila li te mare tèt li a, va kanpe. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Men si nan jou ke mari li tande sa a, li anpeche li; alò, li va anile ve ke li anba li a, ak sèman ki te manke sajès pa sila li te mare tèt li a. SENYÈ a va padone li. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Men yon ve pa yon vèv, oswa yon fanm divòse, tout sa pa sila li te mare tèt li a, va vin kanpe kont li. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Si li te fè ve a lakay mari li, oswa li te mare tèt li pa yon angajman avèk yon sèman, ");
INSERT INTO hatbsa_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","epi mari li te tande sa; men pa t di anyen a li menm, e li pa t anpeche li; alò, tout ve li yo va kanpe e tout angajman pa sila li te mare tèt li yo, va vin kanpe. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Men si, vrèman, mari li anile yo nan jou ke li tande yo a; alò, okenn ve oswa angajman ki sòti nan lèv li, p ap kanpe. Mari li te anile yo. SENYÈ a va padone li. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Nenpòt ve oswa nenpòt sèman pa sila li te mare tèt li a, mari li kapab aksepte li, oswa mari li kapab anile li. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Men si mari li, vrèman, pa di anyen a li menm de jou an jou; alò, li te aksepte li. Paske li pa di anyen a li menm nan jou ke li te tande yo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Men si li, vrèman, anile yo apre li te tande yo a; alò, mari a va pote koupabilite chaj li.” ");
INSERT INTO hatbsa_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Sa yo se règleman ke SENYÈ a te kòmande Moïse yo, antre yon mesye ak madanm li, oswa antre yon papa ak fi ki nan laj jenès li, ki te viv lakay papa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Alò, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Pran vanjans konplè pou fis Israël yo kont Madyanit yo. Apre, ou va rasanble anvè pèp ou a. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moïse te pale avèk pèp la e te di: “Bay gason pami nou yo zam pou fè lagè; pou yo kapab sòti kont Madian pou egzekite vanjans SENYÈ a kont Madian. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Yon milye ki soti nan chak tribi a tout tribi Israël yo, nou va voye yo nan lagè.” ");
INSERT INTO hatbsa_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Konsa, te vin disponib soti nan milye an Israël, yon milye soti nan chak tribi, douz mil avèk zam prepare pou lagè. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moïse te voye yo, yon milye sòti nan chak tribi nan lagè, e Phinées, fis Éléazar a, prèt la, nan lagè avèk yo, avèk veso sen ak twonpèt yo pou sone alam ki nan men l lan. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Konsa, yo te fè lagè kont Madian, jis jan ke SENYÈ a te kòmande Moïse la, e yo te touye tout gason yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Yo te touye wa a Madian yo ansanm avèk lòt ki te mouri yo: Evi, Rékem, Tsur, Hur, ak Réba, senk wa a Madian yo. Yo osi te touye Balaam fis a Beor a avèk nepe. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Fis a Israël yo te pran an kaptif fanm a Madian avèk timoun piti yo, tout bèf yo avèk tout bann bèt yo ak tout byen yo te piyaje yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Yo te brile tout vil kote yo te rete yo ak tout kan yo avèk dife. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Yo te piyaje ak tout sila ki te pran an kaptif yo, ni moun, ni bèt. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Yo te mennen kaptif yo avèk bèt yo avèk sa yo piyaje yo bay Moïse ak Éléazar, prèt la ak bay kongregasyon fis Israël yo, nan kan nan plèn Moab la, ki akote Jourdain an anfas Jéricho. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moïse avèk Éléazar, prèt la ak tout chèf ki nan kongregasyon yo te ale deyò kan an pou rankontre yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moïse te fache avèk ofisye lame a, kapitèn a dè milye ak kapitèn dè santèn ki te sòti nan sèvis lagè yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Moïse te di yo: “Èske nou te bay tout fanm yo lavi? ");
INSERT INTO hatbsa_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Gade byen, sila yo te fè fis Israël yo avèk konsèy Balaam nan vin peche kont SENYÈ a nan zafè Peor a; konsa, gwo epidemi te vin pami kongregasyon SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Pou sa, touye tout gason pami pitit yo, e touye tout fanm ki gen tan fin kouche avèk gason. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Men tout fi ki poko konnen gason, konsève yo pou nou menm. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Epi nou menm, fè kan deyò kan an pandan sèt jou; nenpòt moun ki te touye yon moun, e nenpòt moun ki te touche yon mò, pirifye tèt nou, nou menm avèk kaptif nou yo, nan twazyèm jou ak nan setyèm jou a. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Nou va pirifye tèt nou, tout rad nou yo, tout bagay ki fèt an kwi, tout travay an po kabrit ak tout bagay an bwa.” ");
INSERT INTO hatbsa_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Alò, Éléazar, prèt la, te di a mesye lagè ki te ale nan batay yo: “Sa se règleman a lalwa ke SENYÈ a te kòmande Moïse la: ");
INSERT INTO hatbsa_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","sèlman lò avèk ajan, avèk bwonz, fè, fè blan ak plon, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tout sa ki kapab sipòte dife, nou va fè pase nan dife, e li va vin pwòp; men li va pirifye avèk dlo pirifikasyon an. Men nenpòt sa ki pa kab sipòte dife, nou va pase yo nan dlo. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Epi nou va lave rad nou nan setyèm jou a pou nou vin pwòp; epi apre, nou kapab antre nan kan an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Konsa, SENYÈ a te pale a Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ou menm avèk Éléazar, prèt la, chèf a lakay zansèt yo nan kongregasyon an, pran kontwòl de sa ki te pran an kaptif yo, ni lòm, ni bèt; ");
INSERT INTO hatbsa_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","epi divize piyaj la antre gèrye ki te sòti nan batay yo ak tout kongregasyon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Fè ranmase yon taks ki pou SENYÈ a sou gèrye ki te soti nan batay yo, youn nan chak senk san moun ke yo te pran an kaptif yo, nan bèf, nan bourik ak nan mouton; ");
INSERT INTO hatbsa_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","pran li nan mwatye pa yo, e bay li a Éléazar, prèt la, kòm yon ofrann bay SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Soti nan mwatye fis Israël yo, ou va pran youn ki sòti nan chak senkant moun, nan bèf, nan bourik ak nan mouton, nan tout bèt; epi bay yo a Levit ki responsab lòd nan tabènak SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moïse avèk Éléazar, prèt la, te fè jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Alò, piyaj ki te rete nan byen ke mesye lagè yo te piyaje a te si-mil-swasann-kenz (675,000) mouton, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","swasann-douz-mil (72,000) bèf, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","swasanteyen-mil (61,000) bourik, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","epi nan Kretyen kaptif yo, fanm ki pa t janm konnen gason yo, tout moun te trann-de-mil (32,000). ");
INSERT INTO hatbsa_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Mwatye a, pati a sila ki te ale nan lagè yo te konsa: kantite mouton yo te: twa-san-trann-sèt-mil-senk-san, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","taks SENYÈ a te sis-san-swasann-kenz (675); ");
INSERT INTO hatbsa_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","bèf yo te trann-si-mil (36,000), ladann taks la te swasann-douz (72); ");
INSERT INTO hatbsa_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","bourik yo te trann-mil-senk-san (30,500), ladan yo taks SENYÈ a te swasanteyen (61); ");
INSERT INTO hatbsa_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","moun vivan yo te sèz-mil (16,000), ladan yo taks SENYÈ a te trann-de (32) moun. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moïse te bay taks la, ofrann SENYÈ a Éléazar, prèt la, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Epi pou mwatye a fis Israël yo, ke Moïse te retire nan men mesye ki te ale nan lagè yo—— ");
INSERT INTO hatbsa_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Mwatye kongregasyon an te twa-san-trann-sèt-mil-senk-san (337,500) mouton, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trann-si-mil (36,000) bèf, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trann-mil-senk-san (30,500) bourik, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","moun vivan yo te sèz-mil (16,000) ");
INSERT INTO hatbsa_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","epi soti nan mwatye fis Israël yo, Moïse te retire nan chak senkant, ni nan lòm ak nan bèt yo, e li te bay yo a Levit yo, ki te kenbe lòd nan tabènak SENYÈ a, jis jan ke SENYÈ a te kòmande Moïse la. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Alò, ofisye ki te sou dè milye nan lame yo, kapitèn a dè milye e kapitèn a dè santèn yo te apwoche Moïse, ");
INSERT INTO hatbsa_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","epi yo te di a Moïse: “Sèvitè nou yo te pran kontwòl a mesye lagè ki sou chaj nou yo, e nanpwen pèsòn pami nou ki pa la. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Konsa, nou vin pote yon ofrann bay SENYÈ a sou sa ke chak moun te twouve, bagay an lò, chenèt, braslè, bag, zanno ak kolye, pou fè ekspiyasyon pou nou menm devan SENYÈ a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moïse avèk Éléazar, prèt la, te pran lò pa yo, tout kalite bagay ki fonn. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tout lò pou ofrann, yo te ofri devan SENYÈ a, soti nan kapitèn dè milye ak kapitèn dè santèn yo, se te sèz-mil-sèt-san-senkant (16,750) sik. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Mesye lagè yo te pran piyaj la, chak nonm pou kont li. ");
INSERT INTO hatbsa_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Konsa, Moïse avèk Éléazar, prèt la, te pran lò kapitèn dè milye ak dè santèn yo, e yo te pote li nan tant asanble a kòm yon souvni a fis Israël yo devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Alò, fis Ruben yo avèk fis Gad yo te gen vrèman yon gran kantite bèt. Konsa, lè yo te wè tèren nan Jaezer a ak peyi a Galaad la, ke li te vrèman yon kote ki bon pou bèt. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Fis a Gad avèk fis a Ruben yo te vin pale avèk Moïse ak Éléazar, prèt la, avèk chèf kongregasyon an. Yo te di yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atharoth, Dibon, Jaezer, Nimra, Hesbon Elealé, Sebam, Nebo ak Beon, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","peyi ke SENYÈ a te bat devan kongregasyon Israël yo, se yon peyi ki pou pran swen bèt, e sèvitè ou yo gen bèt.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Yo te di: “Si nou twouve favè nan zye ou, kite peyi sa a vin bay a sèvitè ou yo kòm yon posesyon. Pa mennen nou lòtbò Jourdain an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Men Moïse te di a fis Gad yo e a fis Ruben yo: “Èske frè nou yo va ale nan lagè, pou nou menm rete chita isit la? ");
INSERT INTO hatbsa_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Koulye a, poukisa nou ap dekouraje fis Israël yo travèse lòtbò a pou antre nan peyi ke SENYÈ a te ba yo a? ");
INSERT INTO hatbsa_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Se sa ke papa nou yo te fè lè mwen te voye yo sòti nan Kadès-Barnéa pou wè peyi a. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Paske, lè yo te monte nan vale Eschcol pou te wè peyi a, yo te dekouraje fis Israël yo jiskaske yo pa t antre nan peyi ke SENYÈ a te ba yo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","“Konsa, kòlè SENYÈ a te brile nan jou sa a, Li te sèmante, e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Okenn nan mesye sa yo ki monte kite Égypte, ki gen laj plis ke ventan p ap wè peyi ke Mwen te sèmante a Abraham, Isaac, e a Jacob la; paske yo pa t swiv Mwen nèt, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","sof Caleb, fis a Jephunné a, Kenizyen an, ak Josué, fis a Nun nan, paske yo te swiv SENYÈ a nèt.’ ");
INSERT INTO hatbsa_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Konsa, chalè a SENYÈ a te brile kont Israël, e Li te fè yo vin egare nan dezè a pandan karantan, jiskaske tout jenerasyon sa a pami sila ki te fè mal nan zye SENYÈ a yo, te vin detwi. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Koulye a, veye byen, nou te vin leve nan plas papa nou yo, yon nich moun plen peche, pou vin mete menm plis sou kòlè SENYÈ a kont Israël. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Paske si nou vire akote, e nou pa swiv Li, Li va, yon fwa, ankò abandone yo nan dezè a; epi nou va detwi tout pèp sa yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Alò, yo te vin pwoche li e te di: “Nou va bati isit la pak mouton pou bèt nou yo ak vil pou pitit nou yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","men nou, nou menm, nou va pran zam tou prepare pou ale devan fis Israël yo, jiskaske nou enstale yo nan plas yo. Pandan pitit nou yo ap viv nan vil fòtifye akoz sila k ap viv nan peyi yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nou p ap retounen lakay nou jiskaske chak moun nan fis Israël yo gen tan posede eritaj pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Paske nou p ap gen yon eritaj avèk yo lòtbò Jourdain an, oswa pi lwen, paske eritaj pa nou an te tonbe bannou nan kote Jourdain a sila a, vè lès la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Konsa Moïse te di yo: “Si nou va fè sa, si nou va pran zam nou yo devan SENYÈ a pou fè lagè a, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","epi nou tout mesye avèk zam yo travèse Jourdain an devan SENYÈ a jiskaske Li pouse lènmi Li yo soti devan Li, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","epi peyi a vin anba kontwòl devan SENYÈ a. Alò, apre nou va retounen, lib de angajman yo vè SENYÈ a, ak vè Israël. Konsa, peyi sila a va pou nou kòm yon posesyon devan SENYÈ a. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Men si nou pa fè sa, veye byen, nou te peche kont SENYÈ a, e fòk nou konnen ke peche nou va vin jwenn nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Bati pou nou menm gran vil pou pitit nou yo, pak pou mouton nou yo, e fè sa ke nou te pwomèt yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Fis a Gad avèk fis a Ruben yo te pale avèk Moïse. Yo te di: “Sèvitè ou yo va fè ojis sa ke mèt mwen kòmande yo a. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Pitit nou yo, madanm nou yo, ak bèt nou yo va rete nan vil Galaad yo; ");
INSERT INTO hatbsa_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","pandan sèvitè ou yo, chak ki gen zam pou fè lagè, va travèse lòtbò nan prezans SENYÈ a pou batay la, jis jan ke mèt mwen pale.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Konsa, Moïse te pase lòd konsènan yo a Éléazar, prèt la, a Josué, fis a Nun nan, e a chèf lakay papa zansèt yo, a tribi a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Moïse te di yo: “Si fis a Gad avèk fis a Ruben yo, tout sila ki te pran zam pou batay yo, va travèse avèk nou lòtbò Jourdain an nan prezans SENYÈ a, e peyi a vin soumèt devan nou, alò nou va ba yo peyi a Galaad la kòm yon posesyon. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Men si yo refize travèse avèk nou avèk zam yo, yo va genyen posesyon yo pami nou nan peyi Canaran.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Fis a Gad avèk fis a Ruben yo te reponn e te di: “Jan SENYÈ a te pale a sèvitè ou yo, konsa nou va fè. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nou menm, nou va travèse lòtbò avèk zam yo nan prezans SENYÈ a, nan peyi Canaran, e posesyon eritaj nou va rete avèk nou lòt kote Jourdain an.” ");
INSERT INTO hatbsa_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Konsa, Moïse te bay yo, fis a Gad avèk fis a Ruben yo, mwatye tribi fis a Joseph la, Manassé, wayòm a Sihon, wa a Amoreyen yo, wayòm a Og la, wa a Basan an, peyi a avèk vil pa yo, tèritwa pa yo, vil a tèritwa ki te antoure yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Fis a Gad yo te bati Dibon avèk Ataroth ak Aroër, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atroth-Schophan, Jaezer, Jogbetha, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth Nimra avèk Beth Haran, kòm vil byen fòtifye ak pak pou mouton. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Fis a Ruben yo te bati Hesbon, Elealé, avèk Kirjathaïm, ");
INSERT INTO hatbsa_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo avèk Baal-Meon——non ki te chanje yo—ak Sibma, e yo te bay lòt non a vil ke yo te bati yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Fis a Makir yo, fis a Manassé yo te ale Galaad pou te pran li, e yo te deplase Amoreyen ki te rete ladann yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Konsa, Moïse te bay Galaad a Makir, fis a Manassé a, e li te viv ladann. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jaïr, fis a Manassé a te ale pran vil li yo, e li te rele yo Havvoth-jaïr. ");
INSERT INTO hatbsa_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobach te ale pran Kenath avèk vil pa li yo, e li te rele li Nobach selon pwòp non pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Sa se vwayaj a fis Israël yo sou sila yo te sòti nan peyi Égypte la pa lame pa yo, anba direksyon Moïse avèk Aaron. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moïse te ekri yon rapò pou montre pwent kòmansman nan vwayaj yo selon kòmand SENYÈ a, e sa yo se vwayaj selon pwent kòmansman sila yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Yo te vwayaje soti nan Ramsès nan premye mwa a, sou kenzyèm jou a. Nan jou apre Pak la, fis Israël yo te soti avèk gwo kouraj devan zye a tout Ejipsyen yo, ");
INSERT INTO hatbsa_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","pandan tout Ejipsyen yo t ap antere tout premye ne ke SENYÈ a te frape detwi pami yo. SENYÈ a te osi egzekite jijman sou dye ki te pou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Alò, fis a Israël yo te vwayaje soti Ramsès pou te fè kan nan Succoth. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Yo te vwayaje soti Succoth pou te fè kan nan Etham, ki sou kote dezè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Yo te vwayaje soti Etham pou te vire fè bak jis nan Pi-Hahiroth, ki anfas Baal-Tsephon, e yo te vin fè kan devan Migdol. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Yo te vwayaje soti devan Pi-Hahiroth. Yo te pase nan mitan lanmè a pou rive nan dezè a, yo te vwayaje pandan twa jou nan dezè Étham nan, e yo te vin fè kan nan Mara. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Yo te vwayaje soti Mara pou te rive nan Élim. Nan Élim, te gen douz sous dlo, swasann-dis pye palmis, e yo te fè kan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Yo te vwayaje soti nan Élim, pou te fè kan bò kote Lamè Wouj. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Yo te vwayaje soti Lamè Wouj pou te fè kan nan dezè Tsin nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Yo te vwayaje soti nan dezè Tsin nan pou te fè kan nan Dophka. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Yo te vwayaje soti nan Dophka pou te fè kan nan Alusch. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Yo te vwayaje soti Alusch pou te fè kan nan Rephidim. Se te la ke pèp la pa t gen dlo pou bwè a. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Yo te vwayaje soti nan Rephidim pou te fè kan nan dezè Sinaï a. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Yo te vwayaje soti nan dezè Sinaï a pou te fè kan nan Kibroth-Hattaava. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Yo te vwayaje soti nan Kibroth-Hattaava pou te fè kan nan Hatséroth. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Yo te vwayaje soti nan Hatséroth pou te fè kan nan Rithma. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Yo te vwayaje soti nan Rithma pou te fè kan nan Rimmon-Pérets. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Yo te vwayaje soti nan Rimmon-Pérets pou te fè kan nan Libna. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Yo te vwayaje soti nan Libna pou te fè kan nan Rissa. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Yo te vwayaje soti nan Rissa pou te fè kan nan Kehélatha. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Yo te vwayaje soti nan Kehélatha pou te fè kan nan Schapher. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Yo te vwayaje soti nan Mòn Schapher pou te fè kan nan Harda. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Yo te vwayaje soti nan Harda pou te fè kan nan Makhéloth. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Yo te vwayaje soti nan Makhéloth pou te fè kan nan Tahath. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Yo te vwayaje soti nan Tahath pou te fè kan nan Tarach. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Yo te vwayaje soti nan Tarach pou te fè kan nan Mithka. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Yo te vwayaje soti nan Mithka pou te fè kan nan Haschmona. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Yo te vwayaje soti nan Haschmona pou te fè kan nan Moséroth. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Yo te vwayaje soti nan Moséroth pou te fè kan nan Bené-Jaakan. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Yo te vwayaje soti nan Bené-Jaakan pou te fè kan nan Hor-Guidgad. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Yo te vwayaje soti nan Hor-Guidgad pou te fè kan nan Jothbatha. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yo te vwayaje soti nan Jothbatha pou te fè kan nan Abrona. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Yo te vwayaje soti nan Abrona pou te fè kan nan Etsjon-Guéber. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Yo te vwayaje soti nan Etsjon-Guéber pou te fè kan nan dezè a Tsin nan: sa vle di, Kadès. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Yo te vwayaje soti nan Kadès pou te fè kan nan Mòn Hor, nan lizyè peyi Édom an. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Konsa, Aaron, prèt la, te monte nan Mòn Hor selon lòd SENYÈ a, e li te mouri la nan karantyèm ane apre fis Israël yo te sòti nan peyi Égypte la, nan premye jou sou senkyèm mwa a. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aaron te gen san-venn-twazan (123) lè li te mouri sou Mòn Hor a. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Alò, Kananeyen an, wa a Arad ki te rete Negev la nan peyi Canaran an, te tande ke fis Israël yo t ap pwoche. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Alò, yo te vwayaje soti nan Mòn Hor pou te fè kan nan Tsalmona. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Yo te vwayaje soti nan Tsalmona pou te fè kan nan Punon. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Yo te vwayaje soti nan Punon pou te fè kan nan Oboth. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Yo te vwayaje soti nan Oboth pou te fè kan nan Ijjé-Abarim nan lizyè Moab la. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Yo te vwayaje soti nan Ijjé-Abarim pou te fè kan nan Dibon-Gad. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Yo te vwayaje soti nan Dibon-Gad pou te fè kan nan Almon-Diblathaïm. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Yo te vwayaje soti nan Almon-Diblathaïm pou te fè kan nan mòn Abarim yo devan Nebo. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Yo te vwayaje soti nan mòn Abarim yo pou te fè kan nan plèn a Moab yo akote Jourdain an, anfas Jéricho. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Yo te fè kan akote Jourdain an, soti nan Beth-Jeschimoth pou jis rive nan Abel-Sittim nan plèn a Moab yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Alò, SENYÈ a te pale avèk Moïse nan plèn a Moab yo akote Jourdain an anfas Jéricho. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Pale avèk fis Israël yo e di yo, “Lè nou fin travèse Jourdain an pou antre nan peyi Canaran an, ");
INSERT INTO hatbsa_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","alò, nou va chase deyò tout abitan nan peyi a soti devan nou. Nou va detwi tout zidòl taye an wòch pa yo, detwi tout imaj fonn yo, e kraze nèt tout wo plas yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","“Konsa, nou va pran posesyon peyi a pou viv ladann. Paske Mwen te bay peyi a a nou pou posede li. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Nou va eritye tèren an pa tiraj osò selon fanmi nou yo. Pou pi gran fanmi yo, eritaj la va vin plis, pou pi piti yo, nou va bay mwens nan eritaj la. Nenpòt lè tiraj osò a tonbe sou nenpòt fanmi, sila a va pou li. Nou va eritye pa tribi a zansèt nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“Men si nou pa pouse mete deyò, tout abitan peyi a devan nou, alò, li va vin rive ke sila ke nou kite pami nou yo, va vin pike zye nou. Yo va devni tankou pikan bò kote nou, e yo va twouble nou nan peyi kote nou rete a. ");
INSERT INTO hatbsa_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Epi li va rive ke sa M te anvizaje fè yo, M ap vin fè l nou.” ");
INSERT INTO hatbsa_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Kòmande fis Israël yo e di yo: “Lè nou antre nan peyi Canaran an, sa se peyi ki va vin tonbe pou nou kòm eritaj la; peyi a Canaran an menm, selon lizyè pa li. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“Pati sid la va rive soti nan dezè Tsin nan akote Edom. Lizyè sid la va kouri soti nan pwent Lamè Sale a pou ale vè lès. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Epi lizyè nou an va vire soti nan sid pou monte vè Akrabbim, e kontinye rive nan Tsin, epi dènye pwent li an va nan sid Kadès-Barnéa. Konsa, li va rive nan Hatsar-Addar pou kontinye rive nan Atsmon. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Lizyè a va vire soti nan Atsmon nan ti flèv Égypte la, pou fini nan lanmè. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“‘Epi selon fwontyè lwès la, nou va genyen Gran Lamè a, sa vle di kot li. Sa va fwontyè lwès la. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“‘Epi sa va fwontyè nò nou: nou va trase lizyè a soti nan Gran Lamè a pou rive nan Mòn Hor. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Nou va trase yon lizyè soti nan Mòn Hor pou rive nan Lebo-hamath, e fwontyè a va vin fini nan Tsedad. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Konsa, fwontyè a va kontinye nan Ziphron, e dènye pwent li an va nan Hatsar-Énan. Sa va fwontyè nò nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“‘Pou fwontyè lès la, nou va osi trase yon lizyè soti nan Hatsar-Énan pou rive nan Schepham. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Konsa, fwontyè a va desann soti nan Schepham nan Ribla nan kote lès a Aïn nan. Epi lizyè a va desann rive nan pant sou kote lès a Lamè Kinnéreth la. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Konsa, fwontyè a va desann rive nan Jourdain an, e li va fini nan Lamè Sale a. Sa va peyi pa nou an selon lizyè yo ki antoure li a.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Konsa, Moïse te kòmande fis Israël yo. Li te di: “Sa se peyi ke nou gen pou separe selon tiraj osò pami nou menm kòm posesyon, ke SENYÈ a te kòmande pou bay a nèf tribi edmi yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Paske, tribi a fis Ruben yo te deja resevwa pa yo selon lakay zansèt pa yo, tribi a fis a Gad yo selon lakay zansèt pa yo, e mwatye tribi a Manassé a te resevwa posesyon pa l. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","De tribi edmi sa yo te resevwa posesyon pa yo lòtbò Jourdain an, anfas Jéricho, vè lès, vè solèy leve a.” ");
INSERT INTO hatbsa_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Alò, SENYÈ a te pale avèk Moïse e te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Sila yo se non a mesye ki va divize peyi a bannou kòm eritaj nou yo: Éléazar, prèt la, avèk Josué, fis a Nun nan. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Nou va pran yon chèf nan chak tribi pou divize peyi a kòm eritaj nou. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Sila yo se non a mesye sa yo: nan tribi Juda a, Caleb, fis a Jephaunné a. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","“Nan tribi fis a Siméon yo, Samuel fis a Ammihud la. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","“Nan tribi Benjamin an, Élidad fis a Kislon an. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Nan tribi fis a Dan yo, yon chèf, Buki, fis a Jogli a. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","“Nan tribi fis Joseph yo: nan tribi a fis a Manassé yo, chèf Hanniel, fis a Éphod la. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","“Nan tribi a fis a Éphraïm nan, yon chèf, Kemuel, fis a Schiphtan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","“Nan tribi a fis a Zabulon yo, yon chèf, Élitsaphan, fis a Parnac la. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","“Nan tribi a fis a Issacar yo, yon chèf, Paltiel, fis a Azzan an. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","“Nan tribi a fis a Aser yo; yon chèf, Ahihud, fis a Schelomi a. ");
INSERT INTO hatbsa_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","“Nan tribi a fis a Nephtali yo, yon chèf, Pedahel, fis a Ammihud la.” ");
INSERT INTO hatbsa_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Sa yo se sila ke SENYÈ a te kòmande pou divize eritaj a fis Israël yo nan peyi Canaran an. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Alò, SENYÈ a te pale avèk Moïse nan plèn Moab yo akote Jourdain an anfas Jéricho. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Kòmande fis a Israël yo pou yo bay a Levit yo soti nan eritaj a posesyon pa yo vil pou Levit yo rete ladan. Konsa, nou va bay a Levit yo tèren patiraj ki antoure vil yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Vil yo va pou yo, pou yo viv ladann. Tèren pa yo va pou bèf pa yo, pou twoupo pa yo ak pou tout bèt pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Tèren patiraj lavil ke nou te bay a Levit yo va rive soti nan miray lavil yo, pou lonje rive jis a mil (1,000) koude. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Nou va, osi, mezire deyò lavil la nan kote lès, de-mil (2,000) koude, nan kote sid, de-mil (2,000) koude, nan kote lwès, de-mil (2,000) koude, ak nan kote nò, de-mil koude, avèk vil nan mitan li an. Sa va devni pou yo kòm tèren pa yo pou vil yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Vil ke nou va bay a Levit yo va sis vil azil kote moun ki touye moun kapab sove ale. Anplis de sa yo, nou va bay karann-de vil. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Tout vil ke nou va bay a Levit yo va karanntuit vil ansanm avèk tèren patiraj pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Selon vil ke nou va bay soti nan posesyon a fis Israël yo, nou va pran plis nan men pi gran yo, e nou va pran mwens nan men pi piti yo. A tout selon eritaj li ke li resevwa va bay kèk nan vil pa li yo a Levit yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Alò, SENYÈ a te pale avèk Moïse. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Pale avèk fis Israël yo pou di yo: ‘Lè nou fin travèse Jourdain an pou lantre nan peyi Canaran an, ");
INSERT INTO hatbsa_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","alò, nou va apwente pou nou menm vil azil nou, pou sila ki touye moun yo, san entansyon eksprè, kapab sove ale. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Vil yo va pou nou yon refij kont vanjè yo, pou sila ki touye moun nan pa mouri jiskaske li ta vin kanpe devan kongregasyon an pou jije. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Vil ke nou bay yo va sis vil nou yo pou azil. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Nou va bay twa vil lòtbò Jourdain an ak twa vil nan peyi Canaran an. Yo va sèvi kòm vil azil. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Sis vil sila yo va tankou refij pou fis Israël yo, pou etranje a ak pou sila ki demere pami yo, pou nenpòt moun ki touye yon moun san entansyon eksprè kapab sove ale pou rive la. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“‘Men si li te frape detwi li avèk yon objè an fè, pou l ta vin mouri, li se yon asasen. Yon asasen va, anverite, vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Si li te frape li avèk yon wòch nan men l, pou l ta vin mouri, epi li mouri, li se yon asasen. Asasen an va vrèman, vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Oswa, si li te frape li avèk yon bout bwa nan men l pou li ta mouri, e li vin mouri, li se yon asasen. Asasen an va vrèman, vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Vanjè san an va, li menm, mete asasen an a lanmò. Li va mete li a lanmò depi li rankontre li. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Si li t ap pouse li akoz rayisman, oswa jete yon bagay sou li lè li kouche pou fè pèlen, e kòm rezilta, li te vin mouri, ");
INSERT INTO hatbsa_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","oswa, si li te frape li avèk men l an rayisman, e li vin mouri, sila ki te frape li a va, vrèman, vin mete a lanmò. Li se yon asasen. Vanjè san an va mete asasen an a lanmò lè li rankontre li. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“‘Men si li vin pouse li sibitman san rayisman, oswa li te jete yon bagay sou li san entansyon, ");
INSERT INTO hatbsa_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","oswa, avèk nenpòt objè mòtèl an wòch, men san wè, li vin tonbe sou li e li vin mouri, pandan li pa t lènmi li, ni li pa t ap chache pou fè li mal, ");
INSERT INTO hatbsa_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","alò, kongregasyon an va jije antre moun ki touye moun nan avèk vanjè san an, selon òdonans sa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Kongregasyon an dwe pwoteje moun ki touye moun nan de men a vanjè san an, e kongregasyon an va voye li retounen nan vil azil kote li te sove ale a. Epi konsa, li va viv ladann jiskaske lanmò wo prèt ki te onksyone avèk lwil sen an. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“‘Men si moun ki touye moun nan sòti pi lwen ke lizyè pwòp vil azil pa li a, kote li te gen dwa sove ale a, ");
INSERT INTO hatbsa_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","epi vanjè san an vin jwenn li deyò lizyè vil azil li a; epi vanjè san an touye moun ki te touye moun nan, li p ap koupab de san an, ");
INSERT INTO hatbsa_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","akoz li te dwe rete nan vil azil pa li a jiskaske wo prèt la vin mouri. Men apre lanmò wo prèt la, moun ki te touye moun nan va retounen vè peyi posesyon pa li a. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“‘Bagay sa yo va yon òdonans lalwa pou tout jenerasyon nou yo nan tout abitasyon nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“‘Si, yon moun touye yon moun, asasen an va vin mete a lanmò sou temwayaj temwen yo, men pèsòn pa pou mete a lanmò sou temwayaj a yon sèl temwen. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“‘Anplis, nou pa pou pran ranson pou lavi a yon asasen ki koupab jiska lanmò. Li va, vrèman, vin mete a lanmò. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Nou pa pou pran ranson pou sila ki te sove ale nan vil azil la, pou l kab retounen viv nan peyi a avan lanmò a wo prèt la. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“‘Alò, nou pa pou kontamine peyi kote nou rete a; paske san an va kontamine peyi a e nanpwen ekspiyasyon pou peyi pou san ki koule ladann, sof pa san a sila ki te fè vèse san an. ");
INSERT INTO hatbsa_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Nou pa pou konwonpi peyi kote nou rete a, kote Mwen menm rete a. Paske Mwen, SENYÈ a, Mwen ap viv pami fis Israël yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Epi chèf lakay zansèt a fis a Galaad yo, fis a Makir yo, fis a Manassé a, a zansèt a Joseph yo, te vin toupre pou te pale devan Moïse ak devan chèf yo, chèf lakay zansèt a fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Yo te di: “SENYÈ a te kòmande mèt pa mwen an pou bay peyi a pa tiraj osò a fis Israël yo. E mèt mwen an te kòmande pa SENYÈ a pou bay eritaj a Tselophchad la, frè nou an, bay pitit fi li yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Men si yo marye avèk youn nan fis nan lòt tribi fis Israël yo, eritaj yo va retire nan eritaj zansèt nou yo, e li va vin ajoute a eritaj a tribi sou sila yo vin manm nan. Konsa, l ap retire nan eritaj ki te tonbe nan dwa nou an. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Lè jibile a rive, alò, eritaj pa yo a va ajoute a eritaj tribi kote yo manm nan. Konsa, eritaj pa yo a va retire nan eritaj tribi a zansèt nou yo.” ");
INSERT INTO hatbsa_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Alò, Moïse te kòmande fis a Israël yo pa pawòl a SENYÈ a, e te di: “Sa ke tribi a fis Joseph yo di a se sa. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Se sa ke SENYÈ a te kòmande konsènan fi a Tselophchad yo e te di: ‘Kite yo marye ak nenpòt moun ke yo vle; men fòk yo marye nan pwòp fanmi a tribi zansèt papa pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Konsa, nanpwen eritaj nan fis Israël yo ki va transfere de tribi a tribi, paske fis Israël yo va chak kenbe eritaj a tribi zansèt yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Chak fi ki vin posede yon eritaj nan yon tribi a fis Israël yo va madanm a yon moun ki nan fanmi tribi zansèt papa li a, pou chak fis Israël yo kapab posede eritaj a zansèt pa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Konsa nanpwen eritaj k ap transfere de yon tribi rive nan yon lòt tribi. Paske, tribi a fis Israël yo va chak kenbe nan pwòp eritaj pa yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Jis jan ke SENYÈ a te kòmande Moïse la, se konsa fi a Tselophchad yo te fè: ");
INSERT INTO hatbsa_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Machla, Thirtsa, Hogla, Milca, ak Noa, fi a Tselophchad yo, yo te marye avèk fis a tonton yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Yo te marye sa yo soti nan fanmi a fis a Manassé yo, fis a Joseph la, e eritaj yo te rete avèk tribi a fanmi zansèt papa yo. ");
INSERT INTO hatbsa_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Sa yo se kòmandman ak règleman ke SENYÈ a te kòmande a fis Israël yo pa Moïse nan plèn Moab yo akote Jourdain an, anfas Jéricho. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Sa yo se pawòl a Moïse ke li te pale a tout pèp Israël la lòtbò Jourdain an, nan dezè a, nan Arabah, anfas Suph, antre Paran, Tophel, Laban, Hatséroth, ak Di-Zahab. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Se te yon vwayaj onz jou soti nan Horeb pa chemen a Mòn Séir pou rive nan Kadès-Barnéa. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Nan katriyèm ane a, nan premye jou nan onzyèm mwa a, Moïse te pale avèk fis Israël yo selon tout sa ke SENYÈ a te kòmande li anvè yo, ");
INSERT INTO hatbsa_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","lè li te fin bat Sihon, wa Amoreyen ki te rete Hesbon an, ak Og, wa Basan an, ki te rete Aschtaroth avèk Édréï. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Anfas Jourdain an, nan peyi Moab la, Moïse te kòmanse fè eksplikasyon sou lwa sa a. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","“SENYÈ a, Bondye nou an, te pale avèk nou isit la nan Horeb, e Li te di: ‘Nou gen tan rete la a nan mòn sa pou ase de tan. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Vire kòmanse vwayaj nou an pou ale nan peyi mòn ki pou Amoreyen yo e vè tout kote nan Arabah yo nan peyi mòn yo, nan tèren ba yo, nan Negev la, nan lanmè a, peyi a Canaran yo ak nan Liban jis rive nan gran rivyè Euphrate la. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Nou wè, Mwen te mete tout peyi a devan nou. Ale ladann pou posede peyi ke SENYÈ a te sèmante pou bay a zansèt nou yo—a Abraham, Isaac, e a Jacob—a yo menm ak desandan ki apre yo.’” ");
INSERT INTO hatbsa_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","“Mwen te pale avèk nounan tan sa a pou te di nou, ‘Mwen sèl p ap kapab pote fado nou pou kont mwen. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","SENYÈ a, Bondye nou an, te fè nou vin anpil, e gade byen, jodi a nou vin anpil tankou zetwal nan syèl la. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Ke SENYÈ a, Bondye a zansèt nou yo, kapab fè nou vin miltipliye yon mil fwa anplis ke nou ye a, e beni nou jis jan ke li te pwomèt nou an. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Kijan mwen sèl mwen, ta kapab sipòte fado a nou menm avèk tout zen nou konn fè yo? ");
INSERT INTO hatbsa_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Chwazi moun ki saj, ki gen disènman avèk eksperyans nan pwòp tribi nou yo e mwen vaapwente yo kòm chèf nou.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","“Nou te reponn mwen e te di: ‘Bagay ke ou di a, bon.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","“Konsa, mwen te pran chèf an tèt tribi nou yo, moun saj avèk eksperyans, e mwen te apwente yo kòm chèf sou nou, dirijan a dè milye, a dè santèn, a dè senkantèn, a dè dizèn ak ofisye pou tribi nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Mwen te pase lòd ak jij nou yo nan tan sa a. Mwen te di, ‘Tande ka ki parèt antre nou menm avèk moun peyi parèy nou yo, e jije avèk ladwati antre yon nonm avèk moun peyi parèy a li, oswa etranje ki pami nou an. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Nou pa pou gen moun pa nan jijman an; nou va tande moun gwo pwa avèk moun ki manke pwa egal menm jan. Nou pa pou pè moun, paske jijman an se pou Bondye. Ka ki twò difisil pou nou an, nou va pote li ban mwen, e mwen va tande l.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Mwen te kòmande nou nan tan sa a, tout bagay ke nou te gen pou fè. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","“Konsa, nou te pati Horeb pou te pase nan tout gran dezè tèrib sila a ke nou te wè nan wout la pou rive nan peyi mòn a Amoreyen yo, jis jan ke SENYÈ a, Bondye nou an, te kòmande nou an; epi nou te vini Kadès Barnéa. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Mwen te di nou: ‘Nou gen tan vini nan peyi mòn a Amoreyen yo ke SENYÈ a, Bondye nou an, prèt pou bannou an. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Nou wè, SENYÈ a, Bondye nou an, te mete peyi a devan nou. Monte ladann, posede li, jan SENYÈ a, Bondye a zansèt nou yo, te pale nou an. Pa pè, ni dekouraje.’” ");
INSERT INTO hatbsa_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","“Konsa, nou tout te vin kote m e te di: ‘Annou voye moun devan nou pou yo kapab fè ankèt peyi a pou nou, pou retounen bannou yon pawòl konsènan chemen nou ta dwe monte a ak vil ke nou va antre yo.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","“Sa te fè m plezi. Mwen te pran douz mesye pami nou, yon mesye pou chak tribi. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Yo te vire pou te monte nan peyi mòn nan, e yo te rive nan vale Eschcol la pou espyone ladann. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Epi yo te pran kèk nan fwi peyi a nan men yo pou te pote li bannou. Yo te mennen bannou yon rapò. Yo te di: ‘Se yon bon peyi ke SENYÈ a, Bondye nou an, prèt pou bannou an.’” ");
INSERT INTO hatbsa_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","“Men nou pa t vle monte. Nou te fè rebèl kont kòmand a SENYÈ a, Bondye nou an. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Nou te plenyen nan tant nou yo e te di: ‘Akoz SENYÈ a rayi nou, Li te mennen nou sòti nan peyi Égypte la pou livre nou nan men Amoreyen yo pou detwi nou. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Kibò nou kab monte?’ Frè nou yo te fè kè nou fann. Yo te di: ‘Pèp la pi gran e piwo pase nou! Vil yo gran e fòtifye jis rive nan syèl la!’ Anplis, nou te wè fis a Anak yo la!” ");
INSERT INTO hatbsa_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","“Konsa, mwen te di nou: ‘Pa etone, ni pa pè yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","SENYÈ a, li menm, ki ale devan nou an, va, Li menm, goumen pou nou, jis jan ke Li te fè pou nou an Égypte la devan zye nou, ");
INSERT INTO hatbsa_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","epi nan dezè a kote nou te wè kijan SENYÈ a, Bondye nou an, te pote nou, jis jan ke yon nonm ta pote fis li, nan tout chemen kote nou te mache jis nou vin rive kote sa a.’” ");
INSERT INTO hatbsa_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","“Men malgre tout sa, nou pa t mete konfyans nan SENYÈ a, Bondye nou an, ");
INSERT INTO hatbsa_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","ki te ale devan nou nan chemen an pou chèche yon kote pou nou fè kan, kòm dife nan aswè ak nwaj nan lajounen pou montre nou nan ki chemen nou dwe ale. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","“Epi SENYÈ a te tande son pawòl nou yo. Li te fache. Li te sèmante e te di: ");
INSERT INTO hatbsa_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","‘Nanpwen youn nan mesye sa yo, jenerasyon mechan sila a, ki va wè bon peyi ke mwen te sèmante pou bay a zansèt nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Sof ke Caleb, fis a Jephunné a. Li va wè li. A li menm avèk fis li yo Mwen va bay peyi kote li te mete pye li akoz li te swiv SENYÈ a nèt.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","“Anplis, SENYÈ a te fache avèk mwen osi akoz nou menm. Li te di: ‘Ni ou menm tou, ou p ap antre la. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Josué, fis a Nun nan, ki kanpe la devan nou an, li va antre la. Ankouraje li, paske li va fè Israël jwenn eritaj li a. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","“‘Anplis, pitit nou ke nou te di ta devni yon piyaj la, ak fis nou ki nan jou sa a pa t gen konesans a ni sa ki bon ak sa ki mal, va antre la. Mwen va bay yo li, e yo va posede li. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Men pou nou menm, vire pa dèyè, e fè wout nou pou dezè a pa Lamè Wouj.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","“Konsa, nou te di mwen: ‘Nou te peche kont SENYÈ a; anverite, nou va monte pou fè lagè, jis jan ke SENYÈ a, Bondye nou an, te kòmande nou an.’ Epi tout gason nan nou te mete zam sou yo. Yo te kalkile ke li te fasil pou monte nan peyi mòn nan.” ");
INSERT INTO hatbsa_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","“Men SENYÈ a te di mwen: ‘Di yo: “Pa monte, ni goumen, paske Mwen pa pami nou. Otreman, nou va vin bat devan lènmi nou yo.”’ ");
INSERT INTO hatbsa_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","“Konsa, mwen te pale avèk nou, men nou pa t koute mwen. Olye de sa, nou te fè rebèl kont kòmand SENYÈ a. Nou te aji avèk awogans e nou te monte nan peyi mòn lan. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Amoreyen ki te rete nan peyi mòn sa yo te parèt kont nou. Yo te chase nou tankou myèl ta fè e yo te kraze nou soti nan Séir jis rive nan Horma. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Konsa, nou te retounen pou te kriye fò devan SENYÈ a; men SENYÈ a pa t koute vwa nou, ni bannou zòrèy Li. ");
INSERT INTO hatbsa_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Pou sa, nou te rete Kadès pandan anpil jou, jou sa yo ke nou te pase la a.” ");
INSERT INTO hatbsa_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","“Epi nou te vire pati vè dezè a pa chemen Lamè Wouj la, jan SENYÈ a te pale mwen an, e nou te ansèkle Mòn Séir pandan anpil jou. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","“Epi SENYÈ a te pale avèk mwen. Li te di: ");
INSERT INTO hatbsa_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","‘Nou gen tan fin ansèkle mòn sa a pandan ase de tan. Vire bò kote nò a. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Kòmande pèp la e di yo: “Nou va pase nan tèritwa frè nou yo, fis a Ésaü yo ki rete Séir, eyo va pè nou. Pou sa, fè atansyon. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Pa bourade yo, paske Mwen p ap bannou okenn nan tè pa yo, menm yon ti mòso, paske Mwen te bay Ésaü Mòn Séir pou posede l. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Nou va achte manje nan men yo avèk lajan pou nou kapab manje. Epi nou va, osi, achte dlo pou bwè nan men yo avèk lajan nou.”’” ");
INSERT INTO hatbsa_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","“Paske SENYÈ a te beni nou nan tout sa nou te fè. Li te konnen tout vwayaj nou yo nan gran dezè sila a. Pandan karantan sa yo, SENYÈ a, Bondye nou an, te avèk nou. Nou pa t manke anyen.” ");
INSERT INTO hatbsa_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","“Pou sa, nou te pase devan kite frè nou yo, fis a Esaü ki rete Séir yo, lwen wout Araba a, lwen Élath ak Etsjon-Guéber. Konsa, nou te vire pase nan chemen dezè Moab la. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","“Alò, SENYÈ a te di mwen, ‘Pa menase Moab, ni pa fè pwovokasyon lagè, paske Mwen p ap bannou okenn nan peyi pa yo pou posede. Paske Mwen te bay Ar a fis a Lot yo kòm posesyon.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","“(Avan, se te pèp Émim ki te rete la; yon gwo pèp, gran an kantite, e wo menm jan ak Anakim (jeyan yo). ");
INSERT INTO hatbsa_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Tankou Anakim yo, yo konnen kòm Rephaïm; men Moabit yo, te rele yo Émim. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Otrefwa, se te Oriyen yo ki te rete Séir, men fis a Esaü yo te deplase yo, te detwi yo devan yo, e yo te vin rete nan plas yo, jis jan ke Israël te fè lè yo te vin posede peyi pa yo ke SENYÈ a te bay yo.) ");
INSERT INTO hatbsa_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“‘Koulye a, leve travèse ravin Zéred la, nou menm.’ Konsa, nou te travèse ravin Zéred la. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","“Alò, tan ke nou te pran pou sòti Kadès-Barnéa pou vin travèse ravin Zéred la se te trann-tuit ane, jiskaske tout jenerasyon moun lagè yo te mouri soti anndan kan an, jan SENYÈ a te sèmante a yo menm nan. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Anplis, men a SENYÈ a te kont yo, pou detwi yo soti anndan kan an jiskaske yo tout te mouri. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Epi li te vin rive ke lè tout moun lagè yo te fin mouri pami pèp la, ");
INSERT INTO hatbsa_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ke SENYÈ a te pale avè m e te di: ");
INSERT INTO hatbsa_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Jodi a, ou va travèse sou Ar, lizyè a Moab la. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Lè ou vin anfas fis Ammon yo, pa menase yo ni pwovoke yo, paske Mwen p ap bay ou okenn nan peyi ki pou fis Ammon yo kòm posesyon pa w, paske Mwen te bay li a fis a Lot yo kòm posesyon.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","“(Li rele osi peyi a, Rephaïm, akoz Rephaïm yo te viv la avan sa, men Amonit yo rele yo Zamzumminim, ");
INSERT INTO hatbsa_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","yon pèp tèlman gran e anpil, wo tankou Anakim, men SENYÈ a te detwi yo devan yo. Epi yo te chase yo sòti pou te vin rete nan plas yo, ");
INSERT INTO hatbsa_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","jis jan ke li te fè pou fis Esaü yo, ki te rete Séir, lè Li te detwi Oriyen yo soti devan yo; yo te chase yo e yo te vin rete nan plas yo menm jiska jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Epi Avyen ki te rete nan vil yo jis rive kote Gaza, Kaftorim yo ki te sòti nan Caphtor, te detwi yo, e te vin viv nan plas yo.) ");
INSERT INTO hatbsa_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Leve, pati, e pase nan vale Arnon an. Gade! Mwen te bay Sihon, Amoreyen an, wa a Hesbon avèk peyi pa l nan men nou. Kòmanse pran posesyon an e atake li pou fè lagè. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Nan jou sila a, Mwen va kòmanse mete lakrent ak laperèz ou sou pèp toupatou anba syèl yo, ki, lè yo tande rapò a ou menm, yo va tranble e soufri nan laperèz akoz de ou.” ");
INSERT INTO hatbsa_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“Konsa, Mwen te voye mesaje soti nan dezè a Kedémoth vè Sihon, wa Hesbon an avèk pawòl lapè. Mwen te di: ");
INSERT INTO hatbsa_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","‘Kite mwen pase nan peyi ou a, Mwen va vwayaje sèlman sou gran chemen an; mwen p ap vire akote ni adwat ni agoch. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ou va vann mwen manje pou lajan pou m kab manje; epi ban mwen dlo pou lajan pou m kab bwè. Sèlman, kite mwen pase ladann a pye, ");
INSERT INTO hatbsa_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","jis jan ke fis a Esaü ki rete Séir yo ak Moabit ki rete Ar yo te fè pou mwen, jiskaske mwen travèse Jourdain an pou antre nan peyi ke SENYÈ a, Bondye nou an, ap bannou an.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","“Men Sihon, wa Hesbon an, pa t dakò kite nou pase nan peyi pa li a; paske SENYÈ a te fè lespri li rèd e kè li di, pou l ta kapab livre li nan men nou, jan ke li ye la jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","“Senyè a te di mwen: ‘Ou wè, Mwen te deja kòmanse livre Sihon avèk peyi li a nan men ou. Kòmanse okipe ou, pou nou kapab genyen peyi li a.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","“Epi Sihon avèk tout pèp li a te parèt pou rankontre nou nan batay nan Jahats la. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","SENYÈ a, Bondye nou an, te livre li bannou, e nou te bat li avèk fis li yo ak tout pèp li a. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Konsa, nou te pran an kaptif tout vil li yo nan tan sa a, e nou te konplètman detwi mesye yo, fanm yo, avèk pitit nan chak vil yo. Nou pa t menm kite youn vivan. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Se sèl bèt nou te pran kòm piyaj nou, ak piyaj a vil ke nou te pran an kaptif. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","“Soti nan Aroër ki nan arebò vale Arnon an, epi soti nan vil ki nan vale a, menm pou rive Galaad, pa t gen vil ki te twò wo pou nou. SENYÈ a, Bondye nou an, te livre yo bannou tout. ");
INSERT INTO hatbsa_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Sèlman, nou pa t pwoche tèritwa fis a Ammon yo, toupatou akote rivyè Jabbok la ak vil peyi mòn yo, ak nenpòt kote ke SENYÈ a, Bondye nou an, te anpeche nou antre.” ");
INSERT INTO hatbsa_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","“Alò, nou te vire monte nan wout la vè Basan. Konsa, Og, wa a Basan an avèk tout pèp li a te sòti pou rankontre nou nan batay nan Édréï. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Men SENYÈ a te di mwen: ‘Pa pè li, paske Mwen te livre li avèk tout pèp li a, ak peyi li a nan men ou; epi ou va fè li menm jan ke ou te fè Sihon, wa Amoreyen yo, ki te rete Hesbon an.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","“Konsa SENYÈ a, Bondye nou an, te livre osi Og, wa Basan an, avèk tout pèp li a nan men nou e nou te frape yo jis nanpwen ki te rete vivan. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Nou te pran an kaptif tout vil li yo nan tan sa a; nanpwen vil ke nou pa t pran sou yo: swasant vil, tout rejyon Argob la, wayòm a Og la, nan Basan. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Tout vil sa yo te fòtifye avèk miray ki wo, avèk pòtay byen bare; epi osi, anpil vil ki te san miray. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Nou te konplètman detwi yo, jis jan ke nou te fè a Sihon, wa Hesbon an, e nou te konplètman detwi gason, fanm ak pitit a chak vil yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Men nou te piyaje tout bèt ak byen a vil yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","“Konsa, nou te pran peyi a nan tan sa a nan men wa Amoreyen yo ki te lòtbò Jourdain an, soti nan vale Arnon an jis rive nan Mòn Hermon an. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidonyen yo rele Hermon Sirion e Armoreyen yo rele li, Senir.) ");
INSERT INTO hatbsa_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Nou te pran tout vil nan platon yo, tout Galaad ak tout Basan jis rive nan Salca ak Édréï, vil a wayòm Og yo, nan Basan. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Paske se sèl Og, wa Basan an ki te rete kòm retay a Rephaïm yo. Gade byen, kabann li te fèt an fè. Èske li pa nan Rabbath, vil a fis Ammon yo? Longè li se te nèf koude e lajè li se te kat koude nan koude a yon moun.)” ");
INSERT INTO hatbsa_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","“Konsa, nou te vin pran posesyon a peyi sila nan tan sa a. Soti nan Aroër, ki bò kote vale Arnon an, ak mwatye peyi ti mòn a Galaad yo, avèk vil pa li yo, mwen te bay yo a Ribenit yo e a Gadit yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Rès pati a Galaad la ak tout Basan an, wayòm Og la, mwen te bay a mwatye tribi Manassé a, tout rejyon a Argob la (pa tout Basan, se li yo rele peyi a Rephaïm yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Jaïr, fis a Manassé a te pran tout rejyon Argob la jis rive nan lizyè Gechiyen yo ak Maakatyen yo, e yo te rele li Basan, selon pwòp non pa li, Havvoth-Jaïr, e se konsa li rele jis jodi a.) ");
INSERT INTO hatbsa_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","A Makir, mwen te bay Galaad. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","A Ribenit yo avèk Gadit yo, mwen te bay soti Galaad pou rive jis nan vale Arnon, mitan vale a sèvi kòm yon lizyè e jis nan rivyè Jabbok la, ki se fwontyè a fis Ammon yo; ");
INSERT INTO hatbsa_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Araba a osi, avèk rivyè Jourdain an kòm yon lizyè soti Kinnéreth jis rive nan lanmè Araba a, Lamè Sale a, nan pye a mòn Pisga nan lès. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","“Epi mwen te kòmande nou nan tan sa a e te di: ‘SENYÈ a, Bondye nou an, te bannou peyi sa a pou posede li. Nou tout, mesye vanyan yo, nou va travèse avèk zam devan frè nou yo, fis Israël yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Men madanm nou yo avèk pitit nou yo ak bèt nou yo (mwen konnen ke nou genyen anpil bèt) va rete nan vil ke mwen te bannou yo,’ ");
INSERT INTO hatbsa_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","jis SENYÈ a bay repo a sitwayen parèy a nou an, jis tankou nou; epi yo, osi, vin posede peyi ke SENYÈ a, Bondye nou an, va bay yo lòtbò Jourdain an. Nan moman sa a, nou tout kapab retounen nan pwòp posesyon pa l ke mwen te bannou an’. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","“Mwen te kòmande Josué e te di: ‘Zye ou gen tan fin wè tout sa ke SENYÈ a, Bondye nou an, te fè a dè wa sa yo. Konsa, SENYÈ a va fè nan tout wayòm kote ou prèt pou travèse yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Pa pè yo; paske SENYÈ a, Bondye nou an, se Li menm k ap goumen pou nou.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","“Nan tan sa a, osi, mwen te sipliye SENYÈ a, Bondye nou an. Mwen te di: ");
INSERT INTO hatbsa_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","‘O SENYÈ BONDYE, Ou te kòmanse montre sèvitè ou a jan Ou gran ak men pwisan Ou. Paske ki dye ki genyen nan syèl la oswa sou tè a, ki kapab fè kalite zèv sa yo, zèv pwisan tankou pa Ou yo? ");
INSERT INTO hatbsa_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Kite mwen pase, mwen priye Ou, travèse wè bèl peyi ki lòtbò Jourdain an, bèl peyi mòn sa a, avèk Liban.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","“Men SENYÈ a te fache avèk mwen akoz nou menm, e Li pa t koute mwen. SENYÈ a te di mwen: ‘Sa sifi! Pa pale M ankò de zafè sa a. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Monte sou tèt Pisga, leve zye ou vè lwès, nan nò, sid avèk lès, e gade li avèk zye ou, paske ou p ap travèse Jourdain an. ");
INSERT INTO hatbsa_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Men pale Josué, ankouraje li e ba li fòs, paske li va ale lòtbò a nan tèt a pèp sa a, e li va bay yo li kòm eritaj pa yo peyi ke ou va wè a.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","“Konsa, nou te rete nan vale a anfas Beth-Peor a.” ");
INSERT INTO hatbsa_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“Koulye a, O Israël, koute règleman avèk jijman ke mwen ap enstwi nou pou nou fè, pou nou kapab viv. Antre ladann e pran posesyon a peyi a ke SENYÈ a, Bondye a zansèt nou yo, ap bannou. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Nou p ap mete yon mo sou sa ke mwen ap kòmande nou an ni retire nan li; pou nou kapab kenbe kòmandman a SENYÈ a, Bondye nou an, ke mwen te kòmande nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","“Zye nou gen tan wè sa ke SENYÈ a te fè nan ka Baal-Peor a, paske tout moun ki te swiv Baal-Peor yo, SENYÈ a, Bondye nou an, te detwi yo nan mitan nou. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Men nou menm ki te kenbe fèm a SENYÈ a, Bondye nou an, nou vivan jodi a, nou chak. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Nou wè, mwen te enstwi nou règleman avèk jijman yo jis jan SENYÈ a, Bondye mwen an, te kòmande mwen an, pou nou ta fè konsa nan peyi kote nou ap antre pou posede a. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Pou sa, kenbe yo e fè yo paske sa se sajès avèk konprann nou devan zye a tout pèp ki va tande tout règleman sa yo e ki va di: ‘Anverite, nasyon sa a se yon pèp ki saj e ki gen konprann.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Paske ki gran nasyon ki genyen, avèk yon dye ki osi touprè li kòm SENYÈ a, Bondye nou an, nenpòt lè nou rele Li? ");
INSERT INTO hatbsa_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Oswa ki gran nasyon ki genyen avèk règleman ak jijman ki dwat tankou sa ke mwen ap mete devan nou jodi a? ");
INSERT INTO hatbsa_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","“Sèlman, veye tèt ou e kenbe nanm ou avèk dilijans, pou ou pa bliye bagay ke zye ou te wè yo; pou yo pa kite kè nou pandan tout jou lavi ou; men fè fis ou yo ak fis a fis ou yo konnen yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Sonje jou ke ou te kanpe devan SENYÈ a, Bondye ou an, nan mòn Horeb, lè SENYÈ a te di mwen: ‘Rasanble pèp Mwen an pou Mwen kapab kite yo tande pawòl Mwen, pou yo kapab aprann gen lakrent Mwen pou tout jou ke yo ap viv sou latè yo; epi pou yo kapab enstwi pitit pa yo.’ ");
INSERT INTO hatbsa_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","“Nou te pwoche e ou te kanpe nan pye mòn nan. Mòn nan te brile avèk dife jis rive nan kè syèl la: tenèb, nwaj avèk fènwa. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Epi SENYÈ a te pale avèk nou soti nan mitan dife a: nou te tande son pawòl yo, men nou pa t wè okenn fòm——sèlman yon vwa. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Konsa, Li te deklare bay nou akò ke Li te kòmande nou pou fè a, sa vle di, Dis Kòmandman yo. Li te ekri yo sou de tab an wòch. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","SENYÈ a te kòmande mwen nan tan sa a pou enstwi nou lwa avèk règleman li yo, pou nou ta kapab fè yo nan peyi kote nou pral travèse pou posede a. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Pou sa, veye tèt nou, akoz ke nou pa t wè okenn fòm nan jou ke SENYÈ a te pale avèk nou nan Horeb la, soti nan mitan dife a, ");
INSERT INTO hatbsa_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","pou nou pa aji yon jan konwonpi, e fè yon imaj taye pou nou menm nan fòm a okenn bagay, ki sanble a ni mal, ni femèl, ");
INSERT INTO hatbsa_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","sanblab a nenpòt bèt ki sou latè, oswa sanblab a nenpòt zwazo a zèl ki vole anlè, ");
INSERT INTO hatbsa_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ki sanblab a nenpòt sa ki ranpe atè, ki sanblab a nenpòt pwason ki nan dlo anba tè a. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Veye ke nou pa leve zye nou vè syèl la pou wè solèy la, lalin avèk zetwal yo, avèk tout lame syèl la, e mennen pou adore ak sèvi yo, sila ke SENYÈ a, Bondye nou an, te chwazi pou tout lòt pèp anba tout syèl la. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Men SENYÈ a te pran nou e mennen nou sòti nan founo fè a, an Égypte, pou nou kapab yon pèp pou pwòp posesyon pa Li, tankou jodi a. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","“Alò, SENYÈ a te fache avè m akoz de nou, e Li te sèmante pou mwen pa t travèse Jourdain an; epi pou Mwen pa ta antre nan bon peyi ke SENYÈ a, Bondye nou an, ap bannou kòm eritaj nou an. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Paske mwen va mouri nan peyi sila a. Mwen p ap travèse Jourdain an, men nou va travèse e pran posesyon a bon peyi sila a. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Pou sa, veye nou, pou nou pa bliye akò a SENYÈ a, ke Li te fè avèk nou, e fè pou nou menm yon imaj taye nan okenn fòm kont sila SENYÈ Bondye nou an, te kòmande nou an. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Paske SENYÈ a, Bondye nou an, se yon dife voras, yon Bondye ki jalou. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Lè nou devni papa a pitit, pitit a pitit, gen tan rete lontan nan peyi a, aji yon jan konwonpi, fè yon zidòl nan fòm a nenpòt bagay, e fè sa ki mal nan zye a SENYÈ a, Bondye nou an, pou pwovoke Li a lakòlè, ");
INSERT INTO hatbsa_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Mwen rele syèl la avèk tè a kòm temwen kont nou jodi a, ke nou va vrèman peri vit nan peyi kote nou ap pase Jourdain an pou posede a. Nou p ap viv pandan anpil tan ladann, men nou va detwi nèt. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","SENYÈ a va gaye nou pami pèp yo; epi nou va rete pa anpil an kantite pami nasyon kote SENYÈ a bourade nou yo. ");
INSERT INTO hatbsa_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","La, nou va sèvi dye yo, zèv men a lòm yo, bwa avèk wòch, ki pa wè ni tan