﻿USE sofia;
DROP TABLE IF EXISTS sofia.hat_vpl;
CREATE TABLE hat_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES hat_vpl WRITE;
INSERT INTO hat_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nan konmansman, Bondye kreye syèl la ak latè a. ");
INSERT INTO hat_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Men latè pa t' gen fòm, li pa t' gen anyen sou li. Fènwa te kouvri toupatou. Lespri Bondye t'ap plane sou dlo ki te kouvri tout latè. ");
INSERT INTO hat_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Bondye di. Se pou limyè fèt. Epi limyè te fèt. ");
INSERT INTO hat_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Bondye wè limyè a te bon. Bondye mete limyè a yon bò, li mete fènwa a yon lòt bò. ");
INSERT INTO hat_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Bondye rele limyè a lajounen, li rele fènwa a lannwit. Yon lannwit pase, yon maten rive. Se te premye jou a. ");
INSERT INTO hat_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Bondye di ankò. Se pou gen yon vout nan mitan dlo a pou separe dlo a an de. ");
INSERT INTO hat_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Bondye fè vout la separe dlo a an de, yon pati anwo vout la, yon lòt pati anba l'. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Bondye rele vout la syèl. Yon lannwit pase, yon maten rive. Se te dezyèm jou a. ");
INSERT INTO hat_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Bondye di ankò. Se pou dlo ki anba syèl la sanble yon sèl kote pou kote ki sèk la ka parèt. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Bondye rele kote ki sèk la tè. Li rele pil dlo a lanmè. Bondye gade sa l' te fè a, li wè l' bon. ");
INSERT INTO hat_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Bondye di. Se pou tè a pouse tout kalite plant: zèb, plant ki bay grenn, pyebwa ki bay fwi ak tout grenn yo. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tè a pouse tout kalite plant: zèb, plant ki bay grenn, pyebwa ki bay fwi ak tout grenn yo. Bondye gade sa l' te fè a, li wè l' bon. ");
INSERT INTO hat_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Yon lannwit pase, yon maten rive. Se te twazyèm jou a. ");
INSERT INTO hat_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Bondye di ankò. Se pou limyè parèt nan syèl la pou separe lajounen ak lannwit. Y'a sèvi pou make jou yo, lanne yo ak sezon yo. ");
INSERT INTO hat_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Y'a sèvi limyè nan syèl la pou klere tout latè a. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Bondye fè de gwo limyè, pi gwo a pou kòmande sou lajounen, pi piti a pou kòmande sou lannwit. Li fè zetwal yo tou. ");
INSERT INTO hat_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Li mete yo nan syèl la pou klere latè a, ");
INSERT INTO hat_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","pou kòmande sou lajounen ak sou lannwit, pou separe limyè ak fènwa. Bondye gade sa l' te fè a, li wè l' bon. ");
INSERT INTO hat_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Yon lannwit pase, yon maten rive. Se te katriyèm jou a. ");
INSERT INTO hat_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Bondye di ankò. Se pou dlo yo kale anpil anpil bèt vivan. Se pou zwazo vole nan syèl la anwo tè a. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Bondye kreye gwo bèt lanmè yo, tout kalite bèt vivan k'ap naje nan dlo ansanm ak tout kalite zwazo. Bondye gade sa l' te fè a, li wè l' bon. ");
INSERT INTO hat_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Bondye beni yo, li di. Fè pitit, fè anpil anpil pitit, plen dlo lanmè a. Se pou zwazo yo fè anpil anpil pitit tout sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Yon lannwit pase, yon maten rive. Se te senkyèm jou a. ");
INSERT INTO hat_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Bondye di ankò. Se pou tè a kale tout kalite bèt vivan, bèt yo gade, bèt ki trennen sou vant, bèt nan bwa. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Bondye fè tout kalite bèt, bèt nan bwa, bèt yo gade, bèt ki trennen sou vant. Li gade sa l' te fè a, li wè l' bon. ");
INSERT INTO hat_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Bondye di ankò. Ann fè moun. N'ap fè l' pòtre ak nou, pou li sanble ak nou. La gen pouvwa sou pwason ki nan lanmè yo, sou zwazo ki nan syèl la, sou tout bèt yo gade, sou tout latè, sou tout bèt nan bwa, sou tout bèt ki trennen sou vant sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Bondye kreye moun. Li fè l' pòtre ak li. Li kreye yo gason ak fi. ");
INSERT INTO hat_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Li ba yo benediksyon, li di. Fè pitit, fè anpil anpil pitit mete sou tè a. Donte tè a. Mwen ban nou pouvwa sou pwason ki nan lanmè, sou zwazo ki nan syèl la, ak sou tout bèt vivan k'ap mache sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Bondye di. Gade. Mwen ban nou tout kalite plant ki bay grenn ak tout kalite pyebwa ki bay fwi ak grenn pou nou manje. ");
INSERT INTO hat_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Men, tout bèt ki sou tè a, tout zwazo ki nan syèl la, tout bèt ki trennen sou vant, wi tout bèt vivan, m'ap ba yo zèb vèt pou yo manje. Se konsa sa te pase. ");
INSERT INTO hat_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Bondye gade sa l' te fè a, li wè l' bon nèt. Yon lannwit pase, yon maten rive. Se te sizyèm jou a. ");
INSERT INTO hat_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Konsa, Bondye te fin fè syèl la, latè a ansanm ak tout sa ki ladan yo. ");
INSERT INTO hat_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Sou sis jou, Bondye te fin fè tout sa l' t'ap fè a. Setyèm jou a, li sispann travay. ");
INSERT INTO hat_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Li beni setyèm jou a, li mete l' apa pou li, paske se jou sa a li te sispann travay apre li te fin kreye tout sa l' t'ap kreye a. ");
INSERT INTO hat_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Se konsa sa te pase lè Bondye t'ap kreye syèl la ak latè a. Lè Seyè a, Bondye a, t'ap fè latè ansanm ak tou sa ki nan syèl la, ");
INSERT INTO hat_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","pa t' gen yon ti pyebwa sou tè a. Ankenn zèb pa t' ankò pouse nan jaden, paske Bondye pa t' voye lapli tonbe sou tè a. Lèfini, pa t' gen moun pou travay latè. ");
INSERT INTO hat_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Men, yon vapè dlo leve soti nan tè a, li wouze tout tè a. ");
INSERT INTO hat_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Lè sa a, Seyè a, Bondye a, pran pousyè tè, li fè yon nonm. Li soufle nan twou nen nonm lan pou l' ba li lavi. Epi nonm lan vin vivan. ");
INSERT INTO hat_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Seyè a, Bondye a, plante yon jaden yon kote yo rele Edenn, bò kote solèy leve a. Se la li mete nonm li te fè a. ");
INSERT INTO hat_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Seyè a, Bondye a, te fè tout kalite pyebwa leve nan jaden an, bèl pyebwa ki donnen fwi ki bon pou manje. Nan mitan jaden an te gen de gwo pyebwa. Yonn se te pyebwa ki bay lavi a, lòt la se te pyebwa ki fè moun konnen sa ki byen ak sa ki mal la. ");
INSERT INTO hat_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Yon gwo larivyè soti nan peyi Edenn, li wouze jaden an. Larivyè a te fè kat branch. ");
INSERT INTO hat_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Premye branch lan te rele Pichon. Se larivyè sa a ki wouze tout peyi Avila a, peyi kote yo jwenn anpil lò a. ");
INSERT INTO hat_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Se nan peyi sa a yo jwenn pi bon lò ansanm ak pyebwa gonm arabik ak yon pyè wouj ki koute chè yo rele oniks. ");
INSERT INTO hat_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Dezyèm larivyè a rele Giyon. Se li ki wouze tout peyi Kouch la. ");
INSERT INTO hat_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Twazyèm larivyè a rele Tig. Se li ki pase nan peyi Lasiri, sou bò solèy leve a. Katriyèm larivyè a se Lefrat. ");
INSERT INTO hat_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Seyè a, Bondye a, pran nonm lan, li mete l' nan jaden Edenn lan pou l' travay li, pou l' pran swen l'. ");
INSERT INTO hat_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Seyè a, Bondye a, bay nonm lan lòd sa a. Ou mèt manje donn tout pyebwa ki nan jaden an. ");
INSERT INTO hat_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Men, piga ou manje donn pyebwa ki fè moun konnen sa ki byen ak sa ki mal la. Paske, jou ou manje l', w'ap mouri. ");
INSERT INTO hat_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Seyè a, Bondye a, di ankò. Sa pa bon pou nonm lan rete pou kont li. M'ap fè yon lòt moun sanble avè l' pou ede l'. ");
INSERT INTO hat_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Se konsa, Seyè a, Bondye a, pran pousyè tè, li fè tout kalite zannimo ki nan savann ak tout kalite zwazo k'ap vole nan syèl la. Lè l' fini, li mennen yo bay nonm lan pou wè ki non li tapral ba yo. Se non li te ba yo a ki rete pou yo nèt. ");
INSERT INTO hat_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Se konsa, nonm lan bay tout bèt yo gade, tout bèt nan bwa ak tout zwazo ki nan syèl la non yo. Men, pa t' gen yonn ki te sanble avè l', ki ta ka ede l'. ");
INSERT INTO hat_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Lè sa a, Seyè a, Bondye a, fè dòmi pran nonm lan. Msye dòmi nèt ale. Pandan l'ap dòmi an, Bondye louvri bò kòt li, li wete yon zo kòt. Apre sa, li fèmen twou a byen fèmen. ");
INSERT INTO hat_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Avèk zo kòt li te wete nan nonm lan, li fè yon fanm, li mennen l' ba li. ");
INSERT INTO hat_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Lè nonm lan wè l', li di. Aa! Fwa sa a, men yonn ki menm jan avè m'! Zo l' se zo mwen. Chè l' se chè mwen. Y'a rele l' fanm, paske se nan gason li soti. ");
INSERT INTO hat_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Se poutèt sa, gason an va kite papa l' ak manman l' pou l' mete tèt li ansanm ak madanm li, pou tout de fè yon sèl. ");
INSERT INTO hat_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Nonm lan ak madanm li te toutouni. Men, yo pa t' wont rete konsa. ");
INSERT INTO hat_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Sèpan se bèt ki te pi rize nan tout bèt raje Seyè a, Bondye a, te kreye. Li di fanm lan konsa. Eske Bondye te janm di piga nou manje donn tout pyebwa ki nan jaden an? ");
INSERT INTO hat_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Fanm lan reponn sèpan an. Nou gen dwa manje donn tout pyebwa ki nan jaden an. ");
INSERT INTO hat_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Men, kanta pou pyebwa ki nan mitan jaden an, Bondye di. Piga nou manje ladan l', piga nou manyen l' menm. Sinon, n'ap mouri. ");
INSERT INTO hat_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Lè sa a, sèpan an di fanm lan. Se pa vre. Nou p'ap mouri kras. ");
INSERT INTO hat_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bondye di nou sa paske li konnen jou nou manje ladan l', je nou va louvri. n'a vin tankou Bondye, n'a konn sa ki byen ak sa ki mal. ");
INSERT INTO hat_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Fanm lan gade, li wè jan pyebwa a te bèl, jan fwi yo sanble yo ta bon nan bouch. Li santi li ta manje ladan l' pou je l' ka louvri. Li keyi kèk fwi. Li manje, li pote bay mari l' ki manje tou. ");
INSERT INTO hat_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Manje yo fin manje, je yo louvri, lè sa a, yo vin konnen yo toutouni. Yo pran kèk fèy figfrans, yo koud yo ansanm, yo fè tanga mete sou yo. ");
INSERT INTO hat_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Jou sa a, solèy te fèk fin kouche lè nonm lan ak madanm li tande vwa Seyè a, Bondye a, ki t'ap pwonmennen nan jaden an. Y' al kache nan mitan pyebwa ki nan jaden an pou Seyè a, Bondye a, pa wè yo. ");
INSERT INTO hat_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Men, Seyè a, Bondye a, rele nonm lan, li di l'. Kote ou ye? ");
INSERT INTO hat_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nonm lan reponn li. Mwen tande vwa ou nan jaden an, mwen pè. M al kache pou ou, paske mwen toutouni. ");
INSERT INTO hat_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Seyè a, Bondye a, di l'. Ki moun ki di ou te toutouni? Eske ou te manje fwi pyebwa mwen te di ou pa manje a? ");
INSERT INTO hat_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Nonm lan reponn. Fanm ou te ban mwen an, se li menm ki ban mwen fwi pyebwa a pou m' manje, epi mwen manje l'. ");
INSERT INTO hat_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Seyè a, Bondye a, mande fanm lan. Poukisa ou fè sa? Fanm lan reponn li. Se pa mwen non! Se sèpan an wi ki pran tèt mwen ki fè m' manje l'. ");
INSERT INTO hat_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Seyè a, Bondye a, di sèpan an konsa. Poutèt sa ou fè a, ou madichonnen nan mitan tout bèt jaden ak tout bèt nan bwa. W'a rale sou vant ou. W'a manje pousyè tè jouk jou ou mouri. ");
INSERT INTO hat_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ou menm ak fanm lan, m'ap fè nou lènmi yonn ak lòt. Pitit pitit pa l' ak pitit pitit pa ou ap lènmi tou. Pitit pitit li ap kraze tèt ou, epi ou menm w'ap mòde l' nan talon pye l'. ");
INSERT INTO hat_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Li di fanm lan. Lè w'ap fè pitit, m'ap fè soufrans ou vin pi rèd. Wa gen pou soufri anpil lè w'ap akouche. W'ap toujou anvi mari ou. Men, se mari ou ki va chèf ou. ");
INSERT INTO hat_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Apre sa li di Adan. Ou koute pawòl madanm ou, pa vre! Ou manje fwi pyebwa mwen te ba ou lòd pa manje a. Poutèt sa ou fè a, m'ap madichonnen tè a. W'a gen pou travay di toutan pou fè tè a bay sa ou bezwen pou viv. ");
INSERT INTO hat_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Tè a va kale tout kalite pikan ak pengwen ba ou. W'a manje fèy ki pouse nan raje. ");
INSERT INTO hat_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Se swe kouraj ou ki pou fè ou mete yon moso pen nan bouch ou jouk lè wa tounen nan tè kote ou soti a. Paske, se pousyè ou ye, ou gen pou tounen pousyè ankò. ");
INSERT INTO hat_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adan bay madanm li non, li rele l' Ev, paske se li menm ki manman tout moun k'ap viv sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Lè sa a, Seyè a, Bondye a, pran po bèt, li fè rad pou Adan ansanm ak madanm li, li biye yo. ");
INSERT INTO hat_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Apre sa, Seyè a, Bondye a, di. Koulye a, Adan vin konnen sa ki byen ak sa ki mal tankou yonn nan nou. Nou p'ap kite l' lonje men l' keyi fwi pyebwa ki bay lavi a pou l' manje l', pou l' pa viv pou tout tan. ");
INSERT INTO hat_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Se konsa, Seyè a, Bondye a, mete Adan deyò nan jaden Edenn lan. Li voye l' al travay tè, menm tè Bondye te pran pou fè l' la. ");
INSERT INTO hat_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Se konsa, li te mete Adan deyò. Sou bò kote solèy leve nan jaden an, li mete kèk zanj cheriben ak yon manchèt klere kou dife nan men yo. Yo t'ap dragonnen nan tout direksyon pou anpeche moun pwoche bò pyebwa ki bay lavi a. ");
INSERT INTO hat_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Lè sa a, Adan kouche ak Ev, madanm li. Madanm li vin ansent. Li fè yon pitit gason, li rele l' Kayen, epi li di. Avèk konkou Bondye, mwen gen yon gason. ");
INSERT INTO hat_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Apre sa, li fè Abèl, frè Kayen. Abèl te gadò mouton, Kayen menm te travay latè. ");
INSERT INTO hat_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kèk tan apre sa, Kayen pran nan rekòt li, li ofri bay Seye a. ");
INSERT INTO hat_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abèl menm, bò pa l', pran sa ki pi gra nan premye pitit mouton l' yo, li ofri bay Seyè a. Seyè a te kontan ofrann Abèl la. ");
INSERT INTO hat_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Men, li pa t' asepte ofrann Kayen an. Lè Kayen wè sa, li te move anpil. Li move, li mare figi l' byen mare. ");
INSERT INTO hat_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Lè sa a, Seyè a di Kayen. Poukisa ou move konsa? Poukisa ou mare figi ou konsa? ");
INSERT INTO hat_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si sa ou te fè a te byen, ou pa ta rive nan sitiyasyon sa a. Men, paske ou fè sa ki mal, peche kouche nan papòt ou. L'ap tann konsa lè pou l' pran tèt ou. Men, ou menm, se pou ou kenbe tèt ak li. ");
INSERT INTO hat_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Yon jou, Kayen di Abèl, frè li. Ann al nan jaden. Vwala, antan yo nan jaden an, Kayen vire sou frè li, li touye li. ");
INSERT INTO hat_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Seyè a mande Kayen. Kote Abèl, frè ou la? Kayen reponn. Mwen pa konnen. Eske ou te mete m' veye l'? ");
INSERT INTO hat_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Bondye di l' konsa. Kisa ou fè konsa? San Abèl, frè ou, ki koule atè a, ap rele tankou yon vwa moun. Li rive jouk nan zòrèy mwen. L'ap mande revanj. ");
INSERT INTO hat_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Koulye a, tè ki te louvri bouch li pou l' te bwè san frè ou ou te fè koule a, menm tè sa a ap tounen yon madichon pou ou. ");
INSERT INTO hat_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Lè w'a travay latè, li p'ap ba ou sa l' te dwe ba ou. W'ap tounen yon vakabon k'ap plede mache toupatou sou latè san rete. ");
INSERT INTO hat_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kayen di Seyè a: Chatiman an twòp pou mwen. Mwen p'ap ka sipòte l'. ");
INSERT INTO hat_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Men ou mete m' deyò sou tè sa a koulye a, se kache pou m' al kache pou ou pa wè m'. M'ap tounen yon vakabon k'ap plede mache toupatou sou latè san rete. Nenpòt moun ki jwenn mwen va touye m'. ");
INSERT INTO hat_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Seyè a di: Non. Paske, si yon moun touye Kayen, y'ap fè l' peye sa sèt fwa. Se konsa, li mete yon siy sou Kayen pou moun pa touye l' si yo jwenn li. ");
INSERT INTO hat_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Apre sa, Kayen wete kò l' devan Seyè a, li al rete nan yon peyi yo rele Nòd, lòt bò jaden Edenn lan, sou kote solèy leve a. ");
INSERT INTO hat_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kayen kouche avèk madanm li. Madanm li vin ansent, li fè yon ti gason yo rele Enòk. Apre sa, Kayen bati yon vil, li rele l' Enòk. Li ba l' menm non ak pitit gason l' lan. ");
INSERT INTO hat_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enòk te fè yon pitit gason yo rele Irad. Se Irad sa a ki te papa Meoujaèl. Meoujaèl te papa Metouchaèl. Se Metouchaèl ki te papa Lemèk. ");
INSERT INTO hat_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemèk te gen de madanm. Yonn te rele Ada, lòt la te rele Zila. ");
INSERT INTO hat_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Se Ada ki manman Jabal. Jabal sa a, se li menm ki zansèt tout moun sa yo ki rete anba tant epi ki gade bèt. ");
INSERT INTO hat_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Frè menm manman ak li a te rele Joubal. Se li menm ki zansèt tout moun sa yo k'ap jwe gita ak fif. ");
INSERT INTO hat_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila menm bò pa l' te manman Toubal Kayen, yon bòs fòjon ki te konn travay kwiv ak fè. Toubal Kayen te gen yon sè menm manman ak li ki te rele Naama. ");
INSERT INTO hat_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Yon jou Lemèk di madanm li yo: Ada ak Zila, koute sa m'ap di nou! Madanm mwen yo, tande byen sa m'ap di nou! Mwen touye yon moun paske li leve men li sou mwen. Mwen touye yon jenn gason paske li mete san m' deyò. ");
INSERT INTO hat_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Si yon moun touye Kayen y'ap fè l' peye sa sèt fwa. Men, si yon moun touye m', mwen menm Lemèk, y'ap fè l' peye sa swasanndisèt fwa. ");
INSERT INTO hat_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adan te kouche ak madanm li ankò. Madanm li fè yon ti gason. Madanm lan di: Bondye ban m' yon lòt gason pou ranplase Abèl Kayen te touye a. Li rele l' Sèt. ");
INSERT INTO hat_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sèt, pou tèt pa l', vin gen yon pitit gason, li rele l' Enòk. Se lè sa a moun konmanse fè sèvis pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Men lis non pitit pitit Adan yo: Lè Bondye kreye moun, li te fè yo pòtre avè l'. ");
INSERT INTO hat_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Li kreye yo gason ak fi. Li beni yo. Jou li kreye yo a, li rele yo moun. ");
INSERT INTO hat_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adan te gen santrantan (0130 an) lè li vin gen yon pitit gason ki te sanble avè l' tèt koupe, li rele l' Sèt. ");
INSERT INTO hat_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Apre nesans Sèt, Adan viv witsanzan (0800 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Lè Adan mouri li te gen nèfsantrantan (0930 an). ");
INSERT INTO hat_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sèt te gen sansenkan (0105 an) lè li vin gen yon pitit gason yo te rele Enòk. ");
INSERT INTO hat_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Apre nesans Enòk, Sèt viv witsansetan (0807 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Lè Sèt mouri, li te gen nèfsandouzan (0912 an). ");
INSERT INTO hat_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enòk te gen katrevendizan lè li vin gen yon pitit gason yo rele Kenan. ");
INSERT INTO hat_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Apre nesans Kenan, Enòk viv witsankenzan (0815 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Lè Enòk mouri, li te gen nèfsansenkan (0905 an). ");
INSERT INTO hat_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan te gen swasanndizan lè li vin gen yon pitit gason yo rele Malaleyèl. ");
INSERT INTO hat_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Apre nesans Malaleyèl, Kenan viv witsankarantan (0840 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Lè Kenan mouri, li te gen nèfsandizan (0910 an). ");
INSERT INTO hat_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Malaleyèl te gen swasannsenkan lè li vin gen yon pitit gason yo rele Jerèd. ");
INSERT INTO hat_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Apre nesans Jerèd, Malaleyèl viv witsantrantan (0830 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Lè Malaleyèl mouri, li te gen witsankatrevenkenzan (0895 an). ");
INSERT INTO hat_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jerèd te gen sanswanndezan (0162 an) lè li vin gen yon pitit gason yo rele Enòk. ");
INSERT INTO hat_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Apre nesans Enòk, Jerèd viv witsanzan (0800 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Lè Jerèd mouri, li te gen nèfsanswasanndezan (0962 an). ");
INSERT INTO hat_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enòk te gen swasannsenkan lè li vin gen yon pitit gason yo rele Metouchela. ");
INSERT INTO hat_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Apre nesans Metouchela, Enòk te mache byen ak Bondye pandan twasanzan (0300 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","- ");
INSERT INTO hat_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enòk te pase tout vi l' ap mache byen ak Bondye. Li te gen twasanswasannsenkan (0365 an) lè l' disparèt, paske Bondye te pran l' avè l'. ");
INSERT INTO hat_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metouchela te gen sankatrevensètan (0187 an) lè li vin gen yon pitit gason yo rele Lemèk. ");
INSERT INTO hat_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Apre nesans Lemèk, Metouchela viv sètsankatrevendezan (0782 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Lè Metouchela mouri, li te gen nèfsanswantnevan (0969 an). ");
INSERT INTO hat_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lemèk te gen sankatrevendezan (0182 an) lè li vin gen yon pitit gason. ");
INSERT INTO hat_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Li rele l' Noe. Li di konsa: Pitit sa a va soulaje nou anba tout travay di n'ap fè, anba gwo travay nou blije fè avèk men nou paske Seyè a te madichonnen tè a. ");
INSERT INTO hat_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Apre nesans Noe, Lemèk viv senksankatrevenkenzan (0595 an). Li te vin gen anpil lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lè Lemèk mouri, li te gen sètsanswasanndisetan (0777 an). ");
INSERT INTO hat_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noe te gen senksanzan (0500 an) lè li vin gen twa pitit gason: Sèm, Kam ak Jafè. ");
INSERT INTO hat_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Lè sa a, moun te konmanse ap fè anpil anpil pitit sou latè. Yo te vin gen anpil pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Pitit gason Bondye yo te wè jan pitit fi lèzòm yo te bèl. Se konsa, nan fi yo te renmen yo, yo pran ladan yo pou madanm yo. ");
INSERT INTO hat_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Lè Seyè a wè sa, li di: Mwen p'ap kite lèzòm viv pou tout tan, paske se moun ase yo ye. Se sanventan (0120 an) sèlman pou yo viv. ");
INSERT INTO hat_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Lè sa a, epi pandan lontan apre sa, te vin gen sou latè yon ras moun wo anpil: se te pitit pitit fi lèzòm yo te fè pou pitit gason bondye yo. Se yo ki te vanyan gason nan tan lontan yo, kifè tout moun t'ap nonmen non yo. ");
INSERT INTO hat_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Seyè a wè jan lèzòm te mechan toupatou sou latè, ki jan tout lajounen se move lide ase ki te nan tèt yo. ");
INSERT INTO hat_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Li vin règrèt li te fè moun sou latè. Kè l' vin sere ak lapenn. ");
INSERT INTO hat_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Seyè a di: Mwen pral disparèt tout moun mwen te kreye yo, san kite yonn. Epi m'ap detwi ansanm ak yo tout tou bèt kat pat, tout bèt ki trennen sou vant ak tout zwazo k'ap vole nan syèl, paske mwen règrèt anpil dèske mwen te fè yo. ");
INSERT INTO hat_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Men, Noe te fè Bondye plezi. ");
INSERT INTO hat_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Men pitit pitit Noe yo. Nan tout moun ki t'ap viv lè sa a, Noe te sèl moun ki t'ap mache dwat devan Bondye, ki pa t' nan anyen ki mal. Li t'ap mache byen ak Bondye. ");
INSERT INTO hat_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Li te gen twa pitit gason: Sèm, Kam ak Jafè. ");
INSERT INTO hat_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Men, tout lòt moun yo te fin pouri devan Bondye. Toupatou sou latè se te mechanste sou mechanste. ");
INSERT INTO hat_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Bondye gade latè, li wè l' te fin pouri, paske tout moun sou latè te fin pèvèti. ");
INSERT INTO hat_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Lè sa a, Bondye di Noe konsa: Mwen deside pou m' fini ak tout moun, paske se yo ki lakòz toupatou sou latè se mechanste ase. Wi, mwen pral detwi yo nèt ansanm ak tout sa ki sou latè. ");
INSERT INTO hat_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fè yon gwo batiman pou ou ak bwa pichpen. W'a fè anpil ti chanm ladan l'. W'a badijonnen l' byen badijonnen anndan kou deyò avèk goudwon. ");
INSERT INTO hat_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Men ki jan pou ou fè l': Batiman an va gen katsansenkant (0450) pye longè, swasannkenz pye lajè, ak karannsenk pye wotè. ");
INSERT INTO hat_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","W'a mete yon twati sou batiman an. W'a kite yon espas dizwit pous ant twati a ak rebò a. W'a louvri yon sèl pòt sou kote batiman an. W'a mete yon etaj anba, yon etaj nan mitan, yon etaj anwo. ");
INSERT INTO hat_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Mwen pral voye yon gwo inondasyon dlo sou latè pou detwi tout sa k'ap viv anba syèl la. tout sa ki sou latè pral peri. ");
INSERT INTO hat_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Men, m'ap fè yon kontra avè ou. W'a antre nan batiman an, ou menm, pitit gason ou yo, madanm ou ansanm ak madanm pitit ou yo. ");
INSERT INTO hat_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","W'a pran avèk ou tout yon pè nan tout kalite bèt, yon mal ak yon fenmèl. Wa fè yo antre nan batiman an ansanm ak ou pou yo pa mouri. ");
INSERT INTO hat_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Konsa, nan tout kalite zwazo, nan tout kalite bèt domestik, nan tout kalite bèt ki trennen sou vant yo, gen yon pè nan chak kalite ki va vin jwenn ou pou yo pa mouri. ");
INSERT INTO hat_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ou menm bò pa ou, ranmase tout kalite manje, mezi ou kapab. Fè yon bèl pwovizyon mete la pou ou ka jwenn manje pou ou manje ansanm ak tout bèt yo tou. ");
INSERT INTO hat_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Se konsa Noe fè tout sa Bondye te ba li lòd fè a. Wi, se sa menm li te fè. ");
INSERT INTO hat_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Seyè a di Noe: Antre nan gwo batiman an, ou menm ansanm ak tout fanmi ou, paske, nan tout moun k'ap viv koulye la a, se ou menm sèl mwen wè k'ap mache dwat devan mwen. ");
INSERT INTO hat_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nan tout bèt ki bon pou moun manje, w'a pran sèt mal ak sèt fenmèl nan chak kalite. Nan tout bèt ki pa bon pou moun manje, w'a pran yon mal ak yon fenmèl nan chak kalite. ");
INSERT INTO hat_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Konsa tou, pou zwazo k'ap vole nan syèl la, w'a pran sèt mal ak sèt fenmèl nan chak kalite, pou ras la pa disparèt sou latè. ");
INSERT INTO hat_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Paske, nan sèt jou ankò, m'ap fè yon sèl lapli tonbe sou latè pandan karant jou karant nwit. M'ap disparèt tout moun ak tout bèt mwen te fè mete sou latè. ");
INSERT INTO hat_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noe fè tout sa Seyè a te ba li lòd fè a. ");
INSERT INTO hat_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noe te gen sisanzan (0600 an) lè inondasyon an te fèt sou latè. ");
INSERT INTO hat_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Li antre nan batiman an, li menm, pitit gason li yo, madanm li ansanm ak madanm pitit li yo pou yo te ka chape anba inondasyon an. ");
INSERT INTO hat_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","tout kalite bèt, kit sa ki bon pou moun manje, kit sa ki pa bon pou moun manje, tout zwazo, tout bèt ki trennen sou vant, ");
INSERT INTO hat_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","yo tout yo vin jwenn Noe nan batiman an, de pa de, mal ak fenmèl, jan Bondye te bay Noe lòd la. ");
INSERT INTO hat_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Sou sèt jou vre, dlo kouvri tout latè. ");
INSERT INTO hat_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Jou ki fè Noe sisanzan (0600 an), yon mwa, disèt jou, tout sous nan fon lanmè a pete. Syèl la menm louvri, li konmanse vide dlo sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Lapli tonbe san rete pandan karant jou karant nwit. ");
INSERT INTO hat_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Menm jou sa a, Noe, madanm li, pitit gason l' yo, Sèm, Kam ak Jafè, ansanm ak madanm yo antre nan batiman an, ");
INSERT INTO hat_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ansanm ak tout kalite bèt domestik, tout kalite bèt ki trennen sou vant ak tout kalite zwazo, tout kalite ti zwazo, tout kalite bèt ki gen zèl. ");
INSERT INTO hat_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Yo tout yo te vin jwenn Noe nan batiman an, de grenn nan chak kalite bèt vivan ki sou latè. ");
INSERT INTO hat_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Se konsa, yon mal ak yon fenmèl nan chak kalite bèt vivan antre nan batiman an, jan Bondye te bay lòd la. Epi Bondye fèmen pòt la dèyè Noe. ");
INSERT INTO hat_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Pandan karant jou, dlo kouvri tout tè a. Dlo yo gonfle, yo fè batiman an pèdi tè. ");
INSERT INTO hat_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Dlo yo ranfòse, yo gonfle pi rèd sou tè a jouk batiman an t'ap flote nèt sou dlo a. ");
INSERT INTO hat_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Dlo a moute pi rèd toujou anwo tè a, li kouvri tèt tout gwo mòn ki anba syèl la. ");
INSERT INTO hat_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Dlo a moute vennsenk pye depase tèt mòn yo. ");
INSERT INTO hat_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Lè sa a, tout bèt sou latè mouri: zwazo, bèt domestik, zannimo, tout bèt ki trennen sou vant yo, ansanm ak tout moun. ");
INSERT INTO hat_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","tout bèt vivan ak tout moun sou latè mouri. ");
INSERT INTO hat_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Se konsa, Seyè a detwi tout bèt, tout sa ki te sou latè, depi ou tande se moun jouk zannimo domestik, bèt ki trennen sou vant ak zwazo k'ap vole nan syèl la. Yo tout yo disparèt sou latè. Sèl moun ki te rete se te Noe avèk lòt moun ki te nan batiman an ansanm ak li yo. ");
INSERT INTO hat_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Apre sa, dlo a rete anwo tè a pandan sansenkant (0150) jou. ");
INSERT INTO hat_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Men, Bondye vin chonje Noe ansanm ak tout bèt bwa ak zannimo domestik ki te avè l' nan batiman an. Bondye fè yon van soufle sou latè, epi dlo yo konmanse bese. ");
INSERT INTO hat_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Sous dlo ki nan fon lanmè a te sispann bay dlo. Syèl la sispann bay dlo tou. Lapli sispann tonbe. ");
INSERT INTO hat_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Dlo yo menm t'ap bese, yo t'ap bese piti piti. Se sou sansenkant (0150) jou dlo yo te konmanse bese. ");
INSERT INTO hat_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Sou sis mwa disèt jou, batiman an fè tè sou tèt mòn Arara yo. ");
INSERT INTO hat_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Dlo yo t'ap bese toujou jouk sou dizyèm mwa a. Sou premye jou dizyèm mwa a, tèt mòn yo parèt. ");
INSERT INTO hat_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Karant jou apre sa, Noe louvri fennèt li te fè nan batiman an. ");
INSERT INTO hat_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Li lage yon kònèy. Kònèy la soti. li ale vini, li ale vini jouk dlo a te fin cheche nèt sou latè. ");
INSERT INTO hat_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Apre sa, li lage yon pijon, pou l' wè si dlo a te fin bese sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Men, pijon an pa t' jwenn kote pou l' poze. Li tounen vin jwenn Noe nan batiman an, paske te gen dlo sou tout latè toujou. Noe lonje men l', li pran pijon an, li fè l' antre nan batiman an ankò. ");
INSERT INTO hat_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Li tann sèt jou pase. Apre sa, li lage pijon an yon dezyèm fwa, li fè l' soti nan batiman an. ");
INSERT INTO hat_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Vè aswè konsa, pijon an tounen vin jwenn li. Men, fwa sa a, li te gen yon fèy oliv tout vèt nan bèk li. Konsa, Noe vin konnen dlo a te bese sou tout latè. ");
INSERT INTO hat_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Li tann sèt jou pase anvan li lage pijon an ankò. Fwa sa a menm pijon an pa t' tounen vin jwenn li ankò. ");
INSERT INTO hat_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Se konsa, lè Noe te gen sisan ennan (0601 an), nan premye jou premye mwa lanne jwif yo, dlo a te fin bese nèt sou latè. Noe dekouvri batiman an, li voye je l' gade, li wè tout tè a te chèch. ");
INSERT INTO hat_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Sou vennsetyèm jou dezyèm mwa a, tè a te fin chèch nèt. ");
INSERT INTO hat_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Lè sa a, Bondye di Noe: ");
INSERT INTO hat_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","-Soti nan batiman an, ou menm, madanm ou, pitit ou yo ansanm ak madanm pitit ou yo. ");
INSERT INTO hat_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fè tout bèt yo soti tout ansanm avèk ou, zwazo yo, zannimo domestik yo, tout bèt k'ap trennen sou vant yo. Se pou yo fè pitit, fè anpil pitit pou mete sou tè a ankò. ");
INSERT INTO hat_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Se konsa Noe soti nan batiman an ansanm ak madanm li, pitit li yo ak madanm pitit li yo. ");
INSERT INTO hat_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","tout bèt bwa yo, tout zannimo domestik yo, tout bèt k'ap trennen sou vant yo, tout zwazo yo, yo tout yo soti nan batiman an tou. ");
INSERT INTO hat_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noe bati yon lotèl. Li pran yonn nan chak kalite bèt ak zwazo ki bon pou moun manje, li touye yo, li boule yo nèt sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Lè Bondye pran bon sant lan, sa te fè l' plezi. Li di nan kè l' -Mwen p'ap janm bay tè a madichon ankò poutèt sa lèzòm fè, paske depi yo jenn, se move lide ase ki nan kè yo. Mwen p'ap janm detwi tout bèt vivan yo ankò, jan mwen sot fè l' la. ");
INSERT INTO hat_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Toutotan latè a la, va gen yon lè pou plante, yon lè pou rekòlte, va gen sezon fredi ak sezon chalè, va gen sezon sèk, ak sezon lapli, va gen lajounen, va gen lannwit. Wi, toutotan latè a la, bagay sa yo p'ap janm sispann. ");
INSERT INTO hat_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Bondye beni Noe ak pitit li yo, li di yo. Fè pitit, fè anpil anpil pitit mete sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Se pou tout zannimo sou latè, tout zwazo ki nan syèl la, tout bèt vivan ki sou latè, tout pwason ki nan lanmè bese tèt devan nou. Se pou yo pè nou. Mwen ban nou pouvwa sou yo tout. ");
INSERT INTO hat_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Koulye a, nou gen dwa manje tout kalite bèt vivan k'ap mache, tout kalite fèy vèt. Mwen ban nou tout pou manje. ");
INSERT INTO hat_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Tansèlman, se pa pou n' manje vyann ak tout san ladan l', paske san yon bèt se nanm li. ");
INSERT INTO hat_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Konprann sa byen: si yon moun touye nou, m'ap fè l' rann mwen kont. M'ap fè tout bèt ki touye nou rann mwen kont. tout moun ki touye moun parèy yo gen pou rann mwen kont. ");
INSERT INTO hat_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Si yon moun touye yon moun, yon lòt moun gen pou touye l' tou, paske Bondye kreye moun pòtre ak li. ");
INSERT INTO hat_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nou menm, se pou nou fè pitit, anpil pitit. Gaye kò nou toupatou sou latè, pou pitit nou yo toujou fè anpil pitit tou. ");
INSERT INTO hat_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Bondye pale ankò ak Noe ansanm ak pitit li yo, li di yo: ");
INSERT INTO hat_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","-Men m'ap pase yon kontra ak nou tout ansanm ak tout pitit pitit k'ap vin apre nou yo. ");
INSERT INTO hat_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","M'ap pase kontra a ak tout bèt vivan ki la avèk nou yo, zwazo, zannimo domestik, bèt nan bwa, avèk tout sa ki soti nan batiman an pou peple sou latè ankò. ");
INSERT INTO hat_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Wi, m'ap pase kontra mwen ak nou: mwen pwomèt pou m' pa janm voye gwo inondasyon ankò pou detwi tout moun ak tout bèt vivan yo. Konsa, p'ap janm gen gwo inondasyon ankò pou ravaje latè. ");
INSERT INTO hat_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Bondye di ankò-Kontra m'ap pase avèk nou ansanm ak tout bèt vivan ki la avèk nou yo, se yon kontra k'ap la pou tout tan. M'ap ban nou yon siy pou li. ");
INSERT INTO hat_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","M'ap mete lakansyèl mwen nan syèl la. Men siy m'ap ban nou pou kontra mwen pase ak latè a. ");
INSERT INTO hat_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Chak fwa m'a fè nwaj yo konmanse sanble, lakansyèl la va parèt nan syèl la. ");
INSERT INTO hat_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Lè sa a, m'a chonje kontra mwen te fè avèk nou ansanm avèk tout kalite bèt vivan yo. p'ap janm gen gwo inondasyon ankò ki pou detwi tout moun ak tout bèt k'ap viv sou latè. ");
INSERT INTO hat_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Lè lakansyèl la va parèt nan syèl la, m'a wè l', m'a chonje kontra mwen te pase pou tout tan ak tout moun ansanm ak tout kalite bèt k'ap viv sou latè. ");
INSERT INTO hat_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Sa se siy kontra mwen pase ak tout moun ansanm ak tout bèt k'ap viv sou latè. Se konsa Bondye te pale ak Noe. ");
INSERT INTO hat_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Men non pitit Noe yo ki te soti nan batiman an: Sèm, Kam ak Jafè. Kam se te papa Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Se twa pitit Noe sa yo ki peple mete moun sou tout latè. ");
INSERT INTO hat_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noe se premye moun ki travay latè. Li plante yon jaden rezen. ");
INSERT INTO hat_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Yon jou, apre li te fin bwè diven, li sou. Li wete tout rad sou li, li kouche toutouni anba tant li. ");
INSERT INTO hat_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Lè Kam, papa Kanaran, wè papa l' toutouni, li ale di de frè l' yo sa. ");
INSERT INTO hat_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Men, Sèm ak Jafè pran yon gwo rad, yo chak pran yon bout, yo pase l' dèyè do yo, yo kenbe l' anwo zepòl yo. Yo mache pa do, yo antre, yo kouvri papa yo san yo pa janm vire tèt yo gade dèyè. Konsa yo pa wè papa yo toutouni. ");
INSERT INTO hat_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Lè Noe soti anba toudisman diven l' lan, yo di l' sa dezyèm pitit gason l' lan te fè l'. ");
INSERT INTO hat_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Li di. Madichon pou Kanaran! Se pou l' tounen dènye klas esklav frè l' yo. ");
INSERT INTO hat_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Li di ankò. Lwanj pou Seyè a, Bondye Sèm lan. Se pou Kanaran tounen esklav Sèm. ");
INSERT INTO hat_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Se pou Bondye mete sou byen Jafè yo. Se pou pitit pitit Jafè yo viv byen ak pitit Sèm yo. Se pou Kanaran tounen esklav yo. ");
INSERT INTO hat_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Apre gwo inondasyon an, Noe viv twasansenkantan (0350 an). ");
INSERT INTO hat_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Lè l' mouri, li te gen nèfsansenkantan (0950 an). ");
INSERT INTO hat_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Apre gwo inondasyon an, pitit Noe yo, Sèm, Kam ak Jafè, te fè pitit. Men non pitit gason yo te fè. ");
INSERT INTO hat_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Men pitit gason Jafè yo: Se te Gomè, Magòg, Madayi, Javan, Toubal, Mechèk ak Tiras. ");
INSERT INTO hat_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomè te fè twa pitit gason. Achkenaz, Rifat ak Togama. ");
INSERT INTO hat_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Se Javan ki te papa Elicha, Tasis, Kitim ak Wodanim. ");
INSERT INTO hat_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Se tout pitit ak pitit pitit Jafè yo sa ki zansèt tout moun k'ap viv nan zile yo, yo chak sou tè pa yo, yo chak ak lang pa yo. Yo t'ap viv ansanm, fanmi ak fanmi, nasyon ak nasyon. ");
INSERT INTO hat_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Men pitit gason Kam yo. Se te Kouch, Mizrayim, Pout ak Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kouch te fè senk pitit gason: Seba, Avila, Sabta, Rama ak Sabteka. Rama menm te gen de pitit gason: Seba ak Dedan. ");
INSERT INTO hat_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kouch te gen yon lòt pitit gason yo te rele: Nimwòd. Nimwòd sa a, se premye moun ki te gwo chèf sou latè. ");
INSERT INTO hat_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Se te yon gwo chasè devan Seyè a. Se poutèt sa yo di. Gwo chasè devan Bondye tankou Nimwòd. ");
INSERT INTO hat_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nan peyi kote li t'ap gouvènen an te gen lavil sa yo: Babèl, Erèk, Akad, Kalne nan peyi Chenea. ");
INSERT INTO hat_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Apre sa, li kite peyi a, li ale lavil Asou. Men lavil li bati yo: Neniv, Reobòt-Ir, Kalak. ");
INSERT INTO hat_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Lèfini, li bati lavil Rezèm ant Neniv ak Kalak. Kalak sa a te yon gwo lavil. ");
INSERT INTO hat_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizrayim fè pitit. Se yo ki zansèt moun peyi Lidi, peyi Anan, peyi Leyab ak peyi Naftou, ");
INSERT INTO hat_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","peyi Patwous, peyi Kaslou ak peyi Kaftò. Se nan peyi Kaslou sa a moun Filisti yo soti. ");
INSERT INTO hat_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Premye pitit Kanaran se te Sidon. Apre sa vin Et. ");
INSERT INTO hat_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Se Kanaran tout ki papa Jebis, Amori, Gigach, ");
INSERT INTO hat_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Evi, Aka, Seni, ");
INSERT INTO hat_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avad, Zema, Amat. Apre sa tout fanmi Kanaran yo gaye. ");
INSERT INTO hat_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Lizyè tè moun Kanaran yo pati depi lavil Sidon, li mete tèt sou Gera jouk li rive Gaza. Apre sa, li vire sou Sodòm ak Gomò, Adma ak Seboyim jouk li rive Lecha. ");
INSERT INTO hat_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Se tout pitit ak pitit pitit Kam yo sa, yo chak sou tè pa yo, yo chak ak lang yo. Yo t'ap viv ansanm, fanmi ak fanmi, nasyon ak nasyon. ");
INSERT INTO hat_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sèm te gran frè Jafè. Li te gen anpil pitit tou. Se li ki te zansèt tout pitit Ebè yo. ");
INSERT INTO hat_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Men pitit gason Sèm yo. Se te Elam, Asou, Apachad, Lidi ak Aram. ");
INSERT INTO hat_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Men pitit Aram yo. Se te Ouz, Oul, Getè ak Mach. ");
INSERT INTO hat_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Se Apachad ki te papa Chelak. Chelak menm te papa Ebè. ");
INSERT INTO hat_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebè te gen de pitit gason. Yonn te rele Pelèg, paske se nan tan li moun sou latè te divize yonn ak lòt. Yo te rele frè l' la Joktan. ");
INSERT INTO hat_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan te papa Almodad, Chelèf, Azmavèt, Jerak, ");
INSERT INTO hat_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Ouzal, Dikla, ");
INSERT INTO hat_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimayèl, Seba, ");
INSERT INTO hat_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofi, Avila ak Jobab. Yo tout se pitit Joktan yo te ye. ");
INSERT INTO hat_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tè kote yo t'ap viv la te pran depi lavil Mecha, li moute kote lavil Sefa, jouk mòn ki bò kote solèy leve a. ");
INSERT INTO hat_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Se tout pitit ak pitit pitit Sèm yo sa, yo chak sou tè pa yo, yo chak ak lang pa yo. Yo t'ap viv ansanm, fanmi ak fanmi, nasyon ak nasyon. ");
INSERT INTO hat_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","tout moun sa yo se branch fanmi pitit Noe yo, dapre zansèt yo, nasyon pa nasyon. Apre gwo inondasyon an, tout nasyon ki sou latè soti nan pitit Noe yo. ");
INSERT INTO hat_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nan konmansman, tout moun sou latè te pale yon sèl lang, yonn te konprann lòt. ");
INSERT INTO hat_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Apre yo pati soti kote solèy leve a, yo rive nan yon plenn nan peyi Chenea. Yo moute kay yo la, yo rete. ");
INSERT INTO hat_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lè sa a, yonn di lòt. Mezanmi, vini non! Ann fè brik. Ann kwit yo nan dife. Se konsa, yo pran brik sèvi wòch pou bati kay, yo pran asfat sèvi mòtye. ");
INSERT INTO hat_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Apre sa, yo di. Annou wè! Ann bati yon gwo lavil pou nou rete ak yon gwo gwo kay tout won byen wo ki rive jouk nan syèl la. Konsa tout moun va respekte nou, yo p'ap ka gaye nou toupatou sou latè. ");
INSERT INTO hat_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Seyè a desann pou l' wè lavil la ansanm ak gwo kay won moun yo t'ap bati a. ");
INSERT INTO hat_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Epi li di. Koulye a, gade! Yo tout fè yon sèl pèp. Yo tout yo pale yon sèl lang. Gade sa yo konmanse ap fè. Talè konsa y'ap pare pou yo fè sa yo vle. ");
INSERT INTO hat_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Bon. N'ap desann, n'ap mele lang yo. Konsa, yonn p'ap ka konprann sa lòt ap di. ");
INSERT INTO hat_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Se konsa Seyè a gaye yo toupatou sou latè. Yo sispann bati lavil la. ");
INSERT INTO hat_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Se poutèt sa yo rele lavil la Babèl, paske se la Seyè a te mele lang tout moun ki rete sou latè, li fè yo pati, li gaye yo toupatou sou latè. ");
INSERT INTO hat_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Men pitit pitit Sèm yo. Dezan apre inondasyon an, Sèm te gen santan (0100 an) lè li fè yon pitit gason yo rele Apachad. ");
INSERT INTO hat_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Apre sa, li viv senksanzan (0500 an) ankò. Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Apachad te gen trannsenkan lè li te fè yon pitit gason yo rele Chela. ");
INSERT INTO hat_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Apre sa, li viv katsantwazan (0403 an) ankò. Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Chela te gen trantan lè li fè yon pitit gason yo rele Ebè. ");
INSERT INTO hat_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Apre sa, li viv katsantwazan (0403 an) ankò. Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebè te gen trannkatran lè li fè yon pitit gason yo rele Pelèg. ");
INSERT INTO hat_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Apre sa, li viv katsantrantan (0430 an). Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelèg te gen trantan lè li fè yon pitit gason yo rele Reou. ");
INSERT INTO hat_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Apre sa, li viv desannevan (0209 an) ankò. Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reou te gen tranndezan lè li fè yon pitit gason yo rele Sewoug. ");
INSERT INTO hat_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Apre sa, li viv desansetan (0207 an) ankò. Li fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Sewoug te gen trantan lè li fè yon pitit gason yo rele Nakò. ");
INSERT INTO hat_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Apre sa, li viv desanzan (0200 an) ankò. Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nakò te gen ventnevan lè li fè yon pitit gason yo rele Terak. ");
INSERT INTO hat_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Apre sa, li viv sandiznevan (0119 an) ankò. Li te fè lòt pitit gason ak pitit fi. ");
INSERT INTO hat_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terak te gen swasanndizan lè li fè twa pitit gason yo rele Abram, Nakò ak Aran. ");
INSERT INTO hat_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Men pitit ak pitit pitit Terak yo: Terak te papa Abram, Nakò ak Aran. Aran te papa Lòt. ");
INSERT INTO hat_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Aran mouri anvan papa l'. Li mouri lavil Our nan peyi Kalde kote l' te fèt la. ");
INSERT INTO hat_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ak Nakò te fè pozisyon. Abram marye ak Sarayi, Nakò marye ak Milka, pitit fi Aran. Aran te gen yon lòt pitit ankò yo te rele Jiska. ");
INSERT INTO hat_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarayi pa t' gen pitit, li pa t' ka fè pitit. ");
INSERT INTO hat_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terak pran pitit li, Abram, pitit pitit li, Lòt, ki te pitit Aran, ansanm ak bèlfi li Sarayi ki te madanm Abram, pitit li. Li pati ak yo, li kite lavil Our nan peyi Kalde pou li ale nan peyi Kanaran. Men lè yo rive lavil Karan, yo te rete la. ");
INSERT INTO hat_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Se la Terak mouri. Li te gen desansenkan (0205 an). ");
INSERT INTO hat_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Seyè a di Abram konsa. Pati, kite peyi ou la. Kite tout fanmi ou. Kite kay papa ou, ale nan peyi m'a moutre ou la. ");
INSERT INTO hat_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","M'ap ba ou anpil pitit pitit. Y'a tounen yon gwo nasyon. m'a beni ou. Y'a nonmen non ou toupatou; w'a sèvi yon benediksyon pou tout moun. ");
INSERT INTO hat_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","M'ap voye benediksyon mwen sou tout moun ki va mande benediksyon pou ou. Men, m'ap madichonnen tout moun ki va ba ou madichon. Gremesi ou, tout nasyon sou latè va jwenn benediksyon. ");
INSERT INTO hat_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram pati jan Seyè a te di l' la. Lòt pati ansanm avè l' tou. Abram te gen swasannkenzan lè li kite Karan. ");
INSERT INTO hat_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram pran Sarayi, madanm li, Lòt, pitit frè li a, ansanm ak tout byen li te genyen ak tout domestik li te gen avè l' nan lavil Karan, yo tout yo pati pou Kanaran. Yo rive nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram mache nan tout peyi a, jouk li rive kote yo rele Sichèm, bò pye bwadchenn More a. Lè sa a se moun Kanaran yo ki te rete nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Abram fè yon vizyon, li wè Seyè a ki di l'. Men peyi m'ap bay pitit pitit ou yo a. Se la Abram bati yon lotèl pou Seyè a ki te parèt devan li nan vizyon an. ");
INSERT INTO hat_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Apre sa, li pati ankò, li ale nan mòn ki toupre lavil Betèl, sou bò solèy leve. Li moute tant li la. Betèl te sou bò lanmè, Ayi te sou bò solèy leve. Abram bati yon lotèl pou Seyè a la tou, epi li fè sèvis pou li. ");
INSERT INTO hat_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Li vwayaje toujou, li desann nan direksyon sid, bout pou bout jouk li rive nan rejyon Negèv la. ");
INSERT INTO hat_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Men, grangou tonbe sou peyi a, pa t' gen manje menm. Se poutèt sa Abram te desann nan peyi Lejip. Li rete la yon bon bout tan. ");
INSERT INTO hat_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Li te prèt pou antre nan peyi Lejip lè li di Sarayi, madanm li. Koute non. Ou se yon bèl fanm. ");
INSERT INTO hat_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Lè gason nan peyi Lejip yo wè ou, yo pral di: Se madanm li wi! Epi y'a touye m' pou yo sa pran ou nan men m'. ");
INSERT INTO hat_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tanpri, di yo se sè mwen ou ye pou yo pa touye m', pou yo ka aji byen avè m' poutèt ou. ");
INSERT INTO hat_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Se konsa, rive Abram rive nan peyi Lejip, mesye yo gen tan wè jan Sarayi te yon bèl fanm. ");
INSERT INTO hat_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kèk grannèg nan gouvènman an wè sa tou, y al di farawon an jan li te bèl. Epi yo mennen Sarayi nan palè a. ");
INSERT INTO hat_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Poutèt Sarayi, farawon an te aji byen ak Abram. Li ba li kantite mouton, kabrit, bèf, bourik, chamo, san konte esklav, fanm kou gason, pou sèvi l'. ");
INSERT INTO hat_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Men, paske farawon an te pran Sarayi, madanm Abram, pou madanm li, Seyè a voye yon bann move maladi sou li ak sou moun ki te nan palè a. ");
INSERT INTO hat_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Lè sa a, farawon an fè rele Abram, li di li. Kisa ou fè m' konsa? Poukisa ou pa t' di m' se madanm ou Sarayi ye? ");
INSERT INTO hat_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Poukisa ou te di m' se sè ou li ye? Mwen pa ta janm pran l' pou madanm mwen. Monchè, men madanm ou. Pran l', al fè wout ou. ");
INSERT INTO hat_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Farawon an pase moun li yo lòd pou fè Abram pati kite peyi a, li menm ansanm ak madanm li avèk tout sa ki te pou li. ");
INSERT INTO hat_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram kite peyi Lejip, li moute nan nò, li tounen nan rejyon Negèv la, ansanm ak madanm li avèk tout sa li genyen. Lòt, neve l' la, te avèk li tou. ");
INSERT INTO hat_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram te rich anpil, li te gen anpil mouton, anpil kabrit ak anpil bèf, li te gen anpil lajan ak anpil lò. ");
INSERT INTO hat_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Li vwayaje toujou jouk li kite Negèv la dèyè. Bout pou bout li rive bò Betèl, kote li te moute tant li anvan an, ant lavil Betèl ak lavil Ayi. ");
INSERT INTO hat_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Li tounen kote li te moute yon lotèl premye fwa a. Li fè sèvis pou Bondye ankò. ");
INSERT INTO hat_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lòt menm, neve ki t'ap vwayaje ansanm avèk Abram lan, te gen mouton ak bèf pa l' tou. Li te gen moun tout avèk li. ");
INSERT INTO hat_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Peyi a te vin twò piti pou yo de a rete ansanm, paske yo te gen twòp zannimo pou bay manje. ");
INSERT INTO hat_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Se konsa, te vin gen yon kabouyay ant gadò mouton Abram yo ak gadò mouton Lòt yo. Lè sa a, se moun Kanaran yo ak moun Ferezi yo ki te rete nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram di Lòt konsa. Monchè, se fanmi nou ye. Pa gen rezon pou nou gen kont yonn ak lòt, ni pou gadò ou yo gen kont ak gadò pa m' yo. ");
INSERT INTO hat_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Men tout peyi a devan nou! Ann separe. Si ou fè bò dwat, m'ap fè bò gòch. Si ou fè bò gòch, m'ap fè bò dwat. ");
INSERT INTO hat_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lòt voye je l' toupatou, li gade plenn Jouden an byen gade. tout plenn lan, rive jouk Zoa, te wouze nèt ale. Jaden yo te tankou jaden Seyè a, tankou nan peyi Lejip. (Lè sa a, Seyè a pa t' ankò disparèt lavil Sodòm ak Gomò.) ");
INSERT INTO hat_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lòt chwazi plenn Jouden an pou li. Li pati nan direksyon solèy leve. Se konsa de mesye yo te separe. ");
INSERT INTO hat_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram rete nan peyi Kanaran. Lòt menm al moute kay li nan mitan lavil yo ki te nan plenn lan. Li moute kay li bò lavil Sodòm. ");
INSERT INTO hat_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Moun Sodòm yo te move moun anpil. Yo t'ap fè anpil peche kont Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lè Lòt fin ale, Seyè a di Abram konsa. Kanpe kote ou ye a, voye je ou toupatou, nan tout direksyon: nò, sid, lès, lwès, ");
INSERT INTO hat_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","paske mwen pral ba ou tout tè ou wè a pou ou ak pou pitit pitit ou yo pou tout tan. ");
INSERT INTO hat_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mapral ba ou anpil pitit pitit. Si yon moun ka konte tout grenn pousyè ki sou latè, la rive konte pitit pitit ou yo tou. ");
INSERT INTO hat_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Bon. Koulye a, ou mèt pwonmennen mache nan tout peyi a, paske se ou menm mwen pral bay li. ");
INSERT INTO hat_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Se konsa, Abram ranmase tout zafè l', li vin rete bò pye bwadchenn Manmre yo, toupre Ebwon. Se la li bati yon lotèl pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Lè sa a, Anmrafèl te wa Chenea, Ajòk te wa Elaza, Kedòlaòmè te wa Elam, Tideal te wa lòt nasyon yo. ");
INSERT INTO hat_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Yo kat yo leve, y al fè lagè ak senk lòt wa. Bera ki te wa Sodòm, Bicha ki te wa Gomò, Cheneab ki te wa Adma, Chemebè ki te wa zeboyim yo, ak wa peyi Bela a. Peyi sa a te rele Zoa tou. ");
INSERT INTO hat_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Senk wa sa yo mete tèt yo ansanm, yo reyini nan Fon Sidim lan kote lanmè Sèl la ye a. ");
INSERT INTO hat_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Pandan douzan, senk wa sa yo te soumèt devan Kedòlaòmè. Lanne ki fè yo trèzan an, yo revòlte. ");
INSERT INTO hat_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Lanne apre sa, ki pou ta fè yo katòzan nan pozisyon sa a, Kedòlaòmè ansanm ak twa wa ki te mete tèt ansanm ak li yo vin rive. Yo bat refayim yo nan lavil Astawòt-Kanayim, yo bat zouzim yo nan lavil Am, yo bat emim yo nan laplenn Chave-Kiryatayim. ");
INSERT INTO hat_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Yo bat orit yo sou mòn Seyi, jouk bò kote pye bwadchenn Paran an, ki toupre dezè a. ");
INSERT INTO hat_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Apre sa, yo kase tèt tounen, yo rive bò Sous jijman an, yo bat tout chèf moun Amelèk yo, yo pran tout bèt yo. Yo bat moun Amori yo tout ki rete Azazon-Tama, yo bat yo byen bat. ");
INSERT INTO hat_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Lè sa a, wa Sodòm, wa Gomò, wa Adma, wa zeboyim ansanm ak wa Bela a, yo soti, yo pran pozisyon nan Fon Sidim lan pou yo goumen ");
INSERT INTO hat_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kont Kedòlaòmè, wa Elam, Tideal, wa lòt nasyon yo, Anmrafèl, wa Chenea ak Ajòch, wa Elaza. Sa te fè kat wa kont senk wa. ");
INSERT INTO hat_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Nan Fon Sidim lan te gen anpil twou byen fon ki te plen asfat. Pandan batay la, wa Sodòm ak wa Gomò yo pran kouri pou lènmi yo, yo te vle wete kò yo nan batay la, yo tonbe nan twou asfat yo. Lòt wa yo menm kouri al kache nan mòn. ");
INSERT INTO hat_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kat wa yo pran tout sa yo jwenn nan Sodòm ak Gomò, ata pwovizyon manje, epi y al fè wout yo. ");
INSERT INTO hat_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Yo pase men yo yo pran Lòt, pitit frè Abram lan, ansanm ak tout byen l' yo, paske se Sodòm Lòt te rete. ");
INSERT INTO hat_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Men, yonn nan mesye ki te chape nan batay la vin di Abram sa. Lè sa a, Abram te rete toupre pye bwadchenn Manmre a. Manmre sa a, se te yon moun Amori. Se te frè Echkòl ak Ane. tout de mesye sa yo te pase kontra avèk Abram. ");
INSERT INTO hat_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Lè Abram vin konnen yo te fè neve l' la prizonye, li sanble tout domestik ki te fèt lakay li yo epi ki te konn goumen. Li pran twasandizwit (0318) antou. Epi li file dèyè wa yo jouk lavil Dann. ");
INSERT INTO hat_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","La, yon jou lannwit, li separe mesye li yo, li fè yo fè de gwoup, epi li atake lènmi yo. Li bat yo byen bat, li kouri dèyè yo jouk yo rive Oba, ki sou bò nò lavil Damas. ");
INSERT INTO hat_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Li reprann tout byen yo te pran yo, li mennen Lòt, neve li a, tounen lakay li ansanm ak tout byen l' yo, tout medam yo ak tout pèp la. ");
INSERT INTO hat_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Apre Abram te fin kraze Kedòlaòmè ansanm ak tout lòt wa ki te fè tèt ansanm ak Kedòlaòmè yo, li t'ap tounen lakay li. Wa Sodòm lan vin rankontre l' nan Fon Chave a ki rele Fon Wa a tou. ");
INSERT INTO hat_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mèlkisedèk menm ki te wa peyi Salèm fè pote pen ak diven vini. Se yon prèt ki t'ap sèvi Bondye ki anwo nan syèl la li te ye. ");
INSERT INTO hat_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Li beni Abram, li di. Se pou Bondye ki anwo nan syèl la, li menm ki fè syèl la ak latè a, beni Abram. ");
INSERT INTO hat_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Lwanj pou Bondye ki anwo nan syèl la. Se li menm ki te lage lènmi ou yo nan men ou. Apre sa, Abram ba li yon dizyèm nan tout sa li te pran. ");
INSERT INTO hat_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Lèfini, wa Sodòm lan di Abram. Ou mèt gade tout byen yo pou ou. Men ban mwen moun yo sèlman. ");
INSERT INTO hat_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram reponn wa Sodòm lan, li di l'. Mwen fè sèman devan Seyè a, Bondye ki anwo nan syèl la, li menm ki fè syèl la ak latè a, ");
INSERT INTO hat_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mwen p'ap pran anyen nan sa ki pou ou, li te mèt yon ti moso fil, yon kòd sapat. Konsa, ou p'ap janm ka di se ou menm ki fè Abram rich. ");
INSERT INTO hat_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mwen pa bezwen anyen pou tèt pa m'. Men, m'ap asepte sa moun mwen yo te manje, ansanm ak pòsyon ki pou moun ki te mache avè m' yo. Wi, se pou Ane, Echkòl ak Manmre pran sa ki vin pou yo a. ");
INSERT INTO hat_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Apre bagay sa yo, Abram fè yon vizyon. Li wè Seyè a ki t'ap pale avè l'. Seyè a di l' konsa. Abram, ou pa bezwen pè anyen. Se mwen menm k'ap pwoteje ou. M' sere yon gwo gwo rekonpans pou ou. ");
INSERT INTO hat_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram di. Seyè, Bondye, kisa ou vle ban mwen? Mwen tout fin mouri, mwen pa gen pitit. Sèl moun lakay mwen ki pral eritye m', se Elyezè, moun peyi Damas la. ");
INSERT INTO hat_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram di ankò. Gade! Ou pa ban m' pitit. Se yonn nan domestik mwen yo ki pral eritye m'. ");
INSERT INTO hat_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Lè sa a, li tande Seyè a ki di l' konsa. Non, se pa li menm ki pral eritye ou. Se pwòp pitit zantray ou ki pral eritye ou. ");
INSERT INTO hat_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Seyè a fè Abram soti deyò, li di l' konsa Leve je ou, gade syèl la byen. Konte zetwal yo si ou kapab. Apre sa, li di. Pitit pitit ou yo va anpil tankou zetwal nan syèl la. ");
INSERT INTO hat_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram mete konfyans li nan Seyè a, se konsa Seyè a fè l' gras. ");
INSERT INTO hat_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Seyè a di. Se mwen menm, Seyè a, ki te fè ou soti lavil Our nan peyi Kalde a, pou m' te ka ba ou peyi sa a pou ou. ");
INSERT INTO hat_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram di. Seyè, Bondye, kijan pou m' fè konnen peyi sa a pou mwen vre? ");
INSERT INTO hat_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Seyè a di l'. Pran yon ti gazèl bèf twazan, yon fenmèl kabrit twazan, yon belye twazan, yon toutrèl ak yon jenn pijon. ");
INSERT INTO hat_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram al pran tout bèt sa yo, li koupe yo mitan pou mitan, li mete moso yo yonn anfas lòt. Men, li pa koupe zwazo yo an de. ");
INSERT INTO hat_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Chak fwa malfini karanklou vin pou desann sou vyann bèt yo, Abram pouse yo ale. ");
INSERT INTO hat_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Solèy tapral kouche lè dòmi vòlè Abram. Li dòmi nèt ale. Epi yon sèl lapèz pran l' nan dòmi an. Kote l' te ye a vin fè tout nwa. ");
INSERT INTO hat_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Seyè a di l'. Konnen sa byen: Pitit pitit ou yo pral viv tankou etranje nan yon peyi ki pa pou yo. Y'ap fè yo tounen esklav, y'ap peze yo pandan katsanzan (0400 an). ");
INSERT INTO hat_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Men, apre sa, m'ap pini nasyon ki va pran yo fè esklav la. Konsa, lè lè a va rive pou yo kite peyi sa a, y'a soti avèk anpil anpil richès. ");
INSERT INTO hat_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kanta ou menm, ou pral mouri ak kè poze, ou pral jwenn zansèt ou yo ki mouri deja. Wi, anvan ou antre anba tè, wa viv lontan san ankenn pwoblèm. ");
INSERT INTO hat_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Apre kat jenerasyon, pitit pitit ou yo va tounen isit la, paske se pou nou tann moun Amori yo rive nan dènye bout mechanste yo. ");
INSERT INTO hat_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Apre solèy fin kouche, te fè nwa anpil. Epi men li, yon recho ki t'ap fè lafimen ansanm ak yon gwo bwa dife tout limen parèt. Yo pase nan mitan moso vyann bèt yo. ");
INSERT INTO hat_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Se jou sa a Seyè a te pase kontra avèk Abram. Li di l' konsa M'ap bay pitit pitit ou yo tout peyi sa a, depi larivyè Lejip, rive jouk larivyè Lefrat la. ");
INSERT INTO hat_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Sa vle di tout peyi kote moun Keni yo, moun Kenizi yo, moun Kadmon yo, ");
INSERT INTO hat_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","moun Et yo, moun Ferezi yo, moun refayim yo, ");
INSERT INTO hat_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","moun Amori yo, moun Kanaran yo, moun Gigach yo ak moun Jebis yo rete. ");
INSERT INTO hat_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarayi, madanm Abram, pa t' janm fè pitit. Sarayi te gen yon sèvant, moun peyi Lejip, yo te rele Aga. ");
INSERT INTO hat_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sarayi di Abram konsa. Gade! Seyè a pa kite mwen fè pitit. Al kouche ak sèvant mwen an non. Ou pa janm konnen, li ka fè pitit pou mwen. Abram tonbe dakò ak sa Sarayi te di l' la. ");
INSERT INTO hat_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Se konsa, Sarayi, madanm Abram, pran sèvant li a, Aga ki te moun peyi Lejip, li bay Abram li pou madanm. Lè sa a, Abram te gen tan gen dizan nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram kouche ak Aga. Aga vin ansent. Lè Aga wè li ansent, lògèy vire tèt li, li pa gade Sarayi, metrès li, pou anyen ankò. ");
INSERT INTO hat_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Lè sa a, Sarayi di Abram. Se fòt ou wi si m'ap sibi tout wont sa a. Se mwen menm ki te ba ou sèvant mwen an pou madanm. Men, depi li wè li ansent lan, li pa gade m' pou anyen ankò. Se Seyè a ki pou jije m' avè ou. ");
INSERT INTO hat_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram reponn Sarayi, li di l'. Sèvant ou pou ou. Li sou zòd ou. Ou gen dwa fè sa ou vle avè l'. Se konsa, Sarayi pran maltrete Aga sitèlman, Aga blije sove kite kay la pou li. ");
INSERT INTO hat_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Zanj Seyè a kontre Aga bò yon sous dlo nan dezè a sou wout ki mennen nan peyi Chour la. ");
INSERT INTO hat_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Li di l' konsa. Aga, sèvant Sarayi, kote ou soti la a? Kote ou prale? Aga reponn. M'ap kouri pou Sarayi, metrès mwen. ");
INSERT INTO hat_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Zanj Seyè a di l'. Tounen lakay metrès ou, soumèt ou devan li. ");
INSERT INTO hat_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Zanj lan di l' ankò. M'ap ba ou anpil anpil pitit pitit. Moun p'ap ka konte yo. ");
INSERT INTO hat_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Zanj lan di l' ankò. Gade! Ou ansent. Ou pral fè yon ti gason. Wa rele l' Izmayèl, paske Seyè a tande rèl ou nan tray w'ap pase a. ");
INSERT INTO hat_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Pitit gason ou lan va tankou yon bourik mawon. L'ap chache tout moun kont. tout moun va chache l' kont. Li p'ap mele ak tout frè l' yo. L'ap viv pou kont li. ");
INSERT INTO hat_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aga di nan kè l'. Ou kwè se vre se mwen ki wè moun ki wè m' lan? Se konsa li bay Seyè a yon non, li rele l': Ou se Bondye ki wè m' lan. ");
INSERT INTO hat_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Se poutèt sa, yo rele pi dlo ki ant Kadès ak Barèd la: Pi moun vivan ki wè m' lan. ");
INSERT INTO hat_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aga fè yon pitit gason pou Abram. Abram rele pitit la Izmayèl. ");
INSERT INTO hat_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram te gen katrevensizan lè Aga te fè Izmayèl. ");
INSERT INTO hat_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Le Abram rive sou katrevendisnevan laj, Seyè a parèt devan l', li di l' konsa. Mwen se Bondye ki gen tout pouvwa a. Se pou ou toujou fè sa m' di ou fè. Se pou ou mennen yon vi san repwòch. ");
INSERT INTO hat_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","M'ap pase yon kontra avè ou, m'ap ba ou anpil anpil pitit pitit. ");
INSERT INTO hat_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Lè sa a, Abram mete ajenou, li bese tèt li jouk atè. Bondye pale avè l' ankò, li di l'. ");
INSERT INTO hat_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","-Men kontra m'ap pase avè ou la. W'ap zansèt moun anpil nasyon. ");
INSERT INTO hat_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Yo p'ap rele ou Abram ankò. Men y'a rele ou Abraram, paske m'ap fè ou tounen zansèt moun anpil nasyon. ");
INSERT INTO hat_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","M'ap ba ou anpil anpil pitit pitit. Y'ap tounen kantite nasyon. Anpil wa ap soti nan ras ou. ");
INSERT INTO hat_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","M'ap kenbe kontra m' lan avè ou, avèk tout ras ou. De pitit an pitit, se va yon kontra k'ap la pou tout tan. Se mwen k'ap Bondye ou, se mwen k'ap Bondye pitit pitit ou yo tou. ");
INSERT INTO hat_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ou wè tè kote ou rete tankou moun vini koulye a? Mwen gen pou m' ba ou l' ansanm ak tout pitit pitit ou yo. tout peyi Kanaran an ap rele ou pa ou pou tout tan. Wi, se mwen menm k'ap Bondye yo tout. ");
INSERT INTO hat_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Bondye di Abraram. Men ou menm ansanm ak tout ras ou, de pitit an pitit, se pou nou dakò pou nou kenbe kontra a avèk mwen. ");
INSERT INTO hat_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Men sa pou ou menm ansanm ak tout pitit ou yo pou nou dakò fè: se pou tout gason nan mitan nou sikonsi. ");
INSERT INTO hat_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Depi koulye a, se pou nou sikonsi tout gason. Se pou sa sèvi yon siy pou moutre gen yon kontra ki pase ant nou menm avè m'. ");
INSERT INTO hat_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Se pou nou sikonsi tout gason wit jou apre yo fèt, li te mèt pitit moun lakay la, osinon pitit moun lòt nasyon ou pran pou travay lakay ou. ");
INSERT INTO hat_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Wi, se pou yo tout yo sikonsi, kit yo fèt lakay ou, kit yo fèt nan peyi etranje. Se va yon mak nan kò nou pou fè wè kontra mwen pase avèk nou an, se yon kontra ki la pou tout tan. ");
INSERT INTO hat_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Si yon gason pa sikonsi, se pou yo disparèt li nan ras la, paske li pa t' kenbe kontra mwen fè ak nou an. ");
INSERT INTO hat_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Apre sa, Bondye di Abraram. Sarayi, madanm ou, p'ap rele Sarayi ankò. Men depi jòdi a y'a rele l' Sara. ");
INSERT INTO hat_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","M'ap beni madanm ou, m'ap fè l' ba ou yon pitit gason. M'ap beni l', m'ap fè l' tounen manman moun anpil nasyon. Anpil nan pitit pitit li yo va wa. ");
INSERT INTO hat_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraram mete ajenou, li bese tèt li jouk atè. Men, li tonbe ri lè l' chonje jan l' fin granmoun. Li t'ap di nan kè l'. Eske yon nonm ki gen santan ka fè pitit ankò? Eske Sara, yon fanm ki gen katrevendizan, ka vin ansent? ");
INSERT INTO hat_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Li di Bondye. Tanpri, beni Izmayèl. Pa kite l' mouri! ");
INSERT INTO hat_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Men Bondye di l'. Non, se Sara madanm ou, ki gen pou fè yon pitit gason pou ou. W'a rele l' Izarak. M'ap kenbe kontra mwen avèk li, ansanm ak pitit pitit li yo. Pa bliye. Se va yon kontra k'ap la pou tout tan. ");
INSERT INTO hat_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ou mande m' pou m' pwoteje Izmayèl pou ou! M'ap fè l' pou ou! M'ap beni l', m'ap ba li anpil pitit ak anpil pitit pitit. Gen douz chèf k'ap soti nan fanmi li. M'ap fè pitit li yo tounen yon gwo nasyon. ");
INSERT INTO hat_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Men, m'ap kenbe kontra mwen an avèk Izarak, pitit gason Sara pral fè pou ou a. L'ap fèt lanne k'ap vini an, lè konsa. ");
INSERT INTO hat_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lè Bondye fin pale avèk Abraram, li kite l', li moute nan syèl. ");
INSERT INTO hat_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Jou sa a Abraram pran Izmayèl, pitit gason li an, ak tout gason ki t'ap travay lakay li, kit yo te fèt nan kay la, kit se moun lòt nasyon li te pran pou sèvi l', li sikonsi yo tout menm jou a, jan Bondye te pase l' lòd la. ");
INSERT INTO hat_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraram poutèt pa l' te gen katrevendiznèvan lè l' te sikonsi. ");
INSERT INTO hat_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Izmayèl, pitit gason l' lan, te gen trèzan lè l' te sikonsi. ");
INSERT INTO hat_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Yo tout de, yo sikonsi yo menm jou ");
INSERT INTO hat_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ansanm ak tout domestik ki te lakay li, kit yo te fèt la, kit se achte li te achte yo nan men moun lòt nasyon yo. ");
INSERT INTO hat_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Seyè a parèt devan Abraram bò pye bwadchenn Manmre yo. Abraram te chita nan papòt kay li, lè ki te fè pi cho nan lajounen an. ");
INSERT INTO hat_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraram leve je l', li rete konsa li wè twa mesye kanpe devan li toupre pyebwa yo. Wè li wè yo, li leve nan papòt la, li kouri al jwenn yo, li bese tèt li jouk atè pou l' di yo bonjou. ");
INSERT INTO hat_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Li di. Mèt, tanpri. Pa pase devan lakay mwen san ou pa fè yon ti rete. Se sèvitè ou mwen ye. ");
INSERT INTO hat_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kite m' mande yo pote ti gout dlo pou lave pye ou. Lèfini, w'a pran yon ti repo anba pyebwa sa a. ");
INSERT INTO hat_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","'a pote yon ti manje pou ou soutni kè ou pou ou reprann fòs pou ou ka kontinye vwayaj ou. Ou rive lakay mwen, mwen la pou m' sèvi ou. Yo reponn li: -Dakò. Ou mèt fè jan ou di a. ");
INSERT INTO hat_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraram kouri lakay li, li ale jwenn Sara. Li di l' konsa. Fè vit. Pran trant liv farin bon kalite, mouye l', fè pen. ");
INSERT INTO hat_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Apre sa, Abraram kouri al nan bann bèt li yo, li pran yon jenn ti bèf byen gra, li bay yonn nan domestik li yo li pou li prese al kòche l'. ");
INSERT INTO hat_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Apre sa, li pran fwomaj, li pran lèt fre, li mete yo ansanm ak vyann yo te pare a, li sèvi mesye yo. Pandan yo t'ap manje, Abraram te kanpe bò kote yo anba pyebwa a. ");
INSERT INTO hat_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Lèfini, yo mande l'. Kote Sara, madanm ou? Li reponn. Li la wi, anndan kay la. ");
INSERT INTO hat_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Yonn nan vizitè yo di l'. Mwen gen pou m' tounen isit la, lè konsa lanne k'ap vini an. Lè sa a, Sara, madanm ou, ap gen tan gen yon pitit gason. Sara menm te kanpe nan papòt la dèyè Abraram, li t'ap koute. ");
INSERT INTO hat_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraram ak Sara te fin vye granmoun. Yo te antre nan laj. Sara te sispann gen lalen li. ");
INSERT INTO hat_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sara tonbe ri nan kè l', li t'ap di. Koulye a, kalite jan m' fin vye a, ou kwè lide m' ta sou gason toujou! Epitou, mari mwen, mèt mwen, fin granmoun! ");
INSERT INTO hat_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Seyè a di Abraram. Sa ki gen la a pou Sara ri konsa, pou l'ap di nan kè l'. Eske mwen kapab fè pitit ankò, jan m' fin vye a? ");
INSERT INTO hat_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Bon. Eske gen kichòy ki twòp la a pou Mèt la fè? Sou dat mwen fikse a, m'a tounen pase wè ou ankò. Lè sa a, Sara va gen yon pitit gason. ");
INSERT INTO hat_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara te pè, li t'ap plede, li t'ap di. Mwen pa t' ri non! Men Seyè a di l'. Men wi, machè, ou te ri. ");
INSERT INTO hat_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mesye yo leve, yo pati, yo mete tèt sou Sodòm. Yo rive kote yo te ka voye je yo gade anba pou wè Sodòm. Abraram menm t'ap mache ak yo. Li t'ap kondi yo mete pi devan sou wout la. ");
INSERT INTO hat_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Seyè a di nan kè l'. Mwen pa kapab kache Abraram sa m' pral fè a. ");
INSERT INTO hat_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Pitit pitit li yo pral tounen yon gwo nasyon ki va gen pouvwa. Gremesi Abraram, tout nasyon sou latè pral jwenn benediksyon. ");
INSERT INTO hat_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Mwen te chwazi l' pou l' te pase pitit li yo ak tout rès fanmi l' k'ap vin apre li yo lòd pou yo mache nan chemen Seyè a met devan yo, pou yo fè sa ki kòrèk ak sa ki dwat devan Bondye. Se konsa m'a fè pou li tout sa mwen te pwomèt li a. ");
INSERT INTO hat_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Apre sa, Seyè a di. Se pa ti kras bagay y'ap di sou moun Sodòm ak moun Gomò, paske peche moun sa yo lou anpil. ");
INSERT INTO hat_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","M'ap desann pou m' wè ak je mwen si sa y'ap di sou yo a se vre. Si se pa vre, m'a konnen. ");
INSERT INTO hat_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Mesye yo pati, yo mete tèt sou Sodòm. Men, Seyè a te rete ak Abraram. ");
INSERT INTO hat_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraram pwoche bò kote Seyè a, li mande l'. Eske se vre ou pral touye inonsan yo ansanm ak koupab yo? ");
INSERT INTO hat_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Si gen senkant moun inonsan nan lavil la, èske w'ap detwi tout lavil la? Eske ou p'ap fè pa lavil la poutèt senkant inonsan sa yo? ");
INSERT INTO hat_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Aa! Pou di w'ap fè inonsan peri ak koupab? Se pa posib. Ou pa ka fè sa. Se lenjistis pou inonsan gen menm sò ak koupab. Non, sa pa ka fèt. Bondye k'ap jije tout moun sou tè a pa ka nan fè lenjistis. ");
INSERT INTO hat_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Seyè a reponn. Si mwen jwenn senkant inonsan nan lavil Sodòm, m'ap fè pa tout lavil la, poutèt senkant inonsan sa yo. ");
INSERT INTO hat_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraram pale ankò, li di. Eskize m' wi! Seyè, si m' penmèt mwen pale ankò. Se moun ase mwen ye, mwen pa gen dwa di ou anyen. ");
INSERT INTO hat_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Men, si se karannsenk moun inonsan sèlman ou jwenn, èske ou pral detwi tout lavil la paske manke senk pou fè senkant lan? Seyè a reponn. Si mwen jwenn karannsenk inonsan sèlman, mwen p'ap detwi lavil la. ");
INSERT INTO hat_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraram pale ankò, li di. Ou pa janm konnen, ka gen karant inonsan ase? Seyè a reponn. Si gen karant inonsan, mwen p'ap detwi lavil la. ");
INSERT INTO hat_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraram di. Tanpri, Seyè, pa fache sou mwen non. M'ap di ou yon ti mo ankò. Ou pa janm konnen, ou ka jwenn trant inonsan ase nan lavil la. Seyè a reponn. Si mwen jwenn trant, m'ap fè pa lavil la. ");
INSERT INTO hat_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraram di. Eskize m' wi, Seyè, si m' penmèt mwen pale toujou. Men, sipoze ou jwenn vin inonsan sèlman? Seyè a reponn li. Si mwen jwenn vin inonsan, m'ap fè pa lavil la. ");
INSERT INTO hat_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraram di ankò. Tanpri, Seyè, pa fache sou mwen non. M'ap di yon dènye mo. Si ou jwenn dis inonsan ase? Seyè a reponn li. Si mwen jwenn dis inonsan, m'ap fè pa lavil la. ");
INSERT INTO hat_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Apre li fin pale ak Abraram, Seyè a al fè wout li. Abraram menm tounen lakay li. ");
INSERT INTO hat_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","De zanj Bondye yo rive Sodòm nan aswè. Lòt te chita bò pòtay lavil la. Wè li wè yo, li leve, li al kontre yo. Li bese tèt li jouk atè pou l' di yo bonjou. ");
INSERT INTO hat_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Li di. Mesye, mwen la pou m' sèvi nou. Tanpri, vin lakay mwen. n'a ka lave pye nou, n'a pase nwit la la. Denmen maten, n'a leve, n'a reprann wout nou. Mesye yo reponn. Non. Nou pral pase nwit la sou laplas la. ");
INSERT INTO hat_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Men Lòt te fòse yo sitèlman, y' al lakay li avè l'. Lòt pare yon bon manje pou yo, li fè pen san ledven. Epi yo manje. ");
INSERT INTO hat_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Yo pa t' ankò kouche, lè mesye lavil Sodòm yo, jenn gason kou vye tonton, sènen kay la. tout gason nan lavil la te kouri vini. ");
INSERT INTO hat_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Yo rele Lòt, yo di l' konsa. Kote mesye ki vin pase nwit lakay ou aswè a? Fè yo soti vin jwenn nou pou nou kouche ak yo? ");
INSERT INTO hat_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lòt soti al jwenn yo nan papòt la. Li fèmen pòt la dèyè do l', ");
INSERT INTO hat_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","li di yo konsa Tanpri, mezanmi. Pa fè bagay sal sa a. ");
INSERT INTO hat_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Gade, mwen gen de pitit fi ki tifi toujou, m'ap mennen yo ban nou. Nou mèt fè sa nou vle avèk yo. Men, pa fè mesye sa yo anyen, paske mwen resevwa yo lakay mwen, mwen fèt pou m' pwoteje yo. ");
INSERT INTO hat_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Men, yo di. Wete kò ou la. Se moun vini ou ye! Kisa ou ye atò pou ou vin di nou sa pou nou fè. Sispann fè radòt la a, anvan nou pa fè ou pi mal pase yo. Sa ou tande a, yo bourade Lòt, epi yo pwoche pou yo defonse pòt la. ");
INSERT INTO hat_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Men, de mesye yo ki te anndan an lonje men yo, yo rale Lòt antre anndan, epi yo fèmen pòt la. ");
INSERT INTO hat_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Lèfini, yo vegle tout mesye ki te devan pòt kay la, depi pi piti a jouk pi gran an. Se konsa mesye yo t'ap vire tounen adwat agoch, yo pa t' kapab jwenn kote pòt kay la te ye. ");
INSERT INTO hat_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","De mesye yo pale ak Lòt, yo di l' konsa. Ki moun ankò ou gen nan lavil la? Pran bofi ou yo, pitit gason ou yo, ak pitit fi ou yo ansanm ak tout bagay ou gen nan lavil la, mete kò ou deyò. ");
INSERT INTO hat_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nou pral detwi tout bò isit la. Seyè a te tande tout sa yo t'ap di sou moun lavil sa a. Li voye nou detwi l'. ");
INSERT INTO hat_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lòt soti, li al jwenn mari pitit fi li yo, li di yo. Leve non, fè vit, ann met deyò. Seyè a pral detwi lavil la. Men bofi li yo te kwè se jwe li t'ap jwe. ");
INSERT INTO hat_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kou jou pral kase, zanj Bondye yo leve Lòt pou l' fè vit. Yo di l'. Fè vit non, monchè! Pran madanm ou ak de pitit fi ou yo, met deyò. Si se pa sa, n'ap mouri tout lè Bondye ap pini lavil la. ");
INSERT INTO hat_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lè yo wè Lòt t'ap kalbende, yo pran men li, yo pran men madanm li ansanm ak de pitit fi li yo, yo mennen yo andeyò lavil la, yo lage yo. Yo te fè sa, paske Seyè a te gen pitye pou Lòt. ");
INSERT INTO hat_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Apre zanj yo te fin fè yo soti nan lavil la, yo di l'. Sove poul ou, si ou pa vle mouri. Pa gad dèyè. Pa rete menm nan plenn lan. Kouri al nan mòn yo pou ou pa pase tou. ");
INSERT INTO hat_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Men, Lòt reponn li. O! Non, Mèt. Tanpri, pa mande m' tout sa. ");
INSERT INTO hat_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Gade, ou deja fè m' yon gwo favè. Ou moutre m' jan ou gen pitye anpil pou mwen. Ou sove lavi m'. Men, mòn lan twò lwen. m'a mouri anvan m' rive, malè a va gen tan rive sou mwen. ");
INSERT INTO hat_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Gade: ou wè ti bouk sa a? Li toupre. m'a gen tan rive la pou m' kache kò mwen. Tanpri, kite m' ale la. Ou wè se yon ti kote ki tout piti. Konsa m'a sove lavi m'. ");
INSERT INTO hat_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Zanj lan di l'. Dakò, Mwen fè ou favè sa a ankò: mwen p'ap detwi ti bouk w'ap pale m' lan. ");
INSERT INTO hat_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kouri vit ale. Mwen p'ap ka fè anyen toutotan ou poko rive la. Se poutèt sa yo rele ti bouk la Zoa. ");
INSERT INTO hat_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Solèy te fèk ap leve lè Lòt rive Zoa. ");
INSERT INTO hat_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Lè sa a, Seyè a fè yon sèl lapli souf ak dife soti nan syèl la tonbe sou Sodòm ak Gomò. Wi, se Seyè a menm ki te fè sa. ");
INSERT INTO hat_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Li detwi de lavil sa yo ak tout plenn lan ansanm ak tout moun ki te rete nan lavil yo ak tout plant ki t'ap pouse nan tè a. ");
INSERT INTO hat_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Men, madan Lòt vire gade dèyè. Lamenm li tounen yon gwo estati sèl. ");
INSERT INTO hat_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nan granmaten, Abraram leve, li ale kote li te kanpe ap pale ak Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Li voye je l' bò Sodòm ak Gomò, li wè tout plenn lan. Epi li rete konsa li wè gwo lafimen ap moute soti nan tè a tankou lafimen k'ap leve nan yon gwo founo dife. ");
INSERT INTO hat_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Se konsa, lè Bondye t'ap detwi lavil yo nan plenn lan, li chonje Abraram. Li fè Lòt chape anba malè li tapral lage sou lavil kote li te rete a. ");
INSERT INTO hat_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Men Lòt te pè rete nan bouk Zoa a. Se konsa, li menm ak de pitit li yo, yo soti Zoa, yo moute, y al rete nan mòn yo. Yo fè kay yo nan yon gwo twou wòch. ");
INSERT INTO hat_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Pi gran fi a di pi piti a. Papa nou ap fin granmoun. Pa gen gason nan peyi a pou marye ak nou pou nou ka fè pitit jan sa fèt toupatou. ");
INSERT INTO hat_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Vini non. Annou fè papa bwè diven jouk li sou. Apre sa, n'a kouche avè l'. Konsa, n'a fè pitit pou papa nou. ");
INSERT INTO hat_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Menm jou sa a, lè aswè rive, yo fè papa yo bwè diven jouk li sou. Pi gran fi a kouche ak papa l'. Men, papa a te sitèlman sou, li pa t' konn anyen. ");
INSERT INTO hat_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Nan denmen, pi gran an di pi piti a. Yèswa, mwen te kouche ak papa m'. Aswè a se tout pa ou: N'ap fè l' bwè diven ankò jouk li sou. Epi w'a al kouche avè l', pou nou de nou kapab fè pitit pou papa nou. ");
INSERT INTO hat_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Se konsa, lè aswè rive, yo fè papa a bwè diven ankò jouk li sou. Epi pi piti a kouche avè l'. Men, fwa sa a ankò, Lòt pa t' konnen anyen. ");
INSERT INTO hat_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Se konsa de pitit fi Lòt yo vin ansent pou papa yo. ");
INSERT INTO hat_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Pi gran an fè yon pitit gason, li rele l' Moab. Se li menm ki zansèt moun Moab yo ki la jouk koulye a. ");
INSERT INTO hat_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Pi piti a tout fè yon pitit gason. Li rele l' Bennami. Se li menm ki zansèt moun Amon yo ki la jouk jòdi a. ");
INSERT INTO hat_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraram kite Manmre, li pati, li ale Negèv, li rete ant Kadès ak Chour kote li moute kay li. Pandan tout tan li t'ap viv nan peyi Gera a, ");
INSERT INTO hat_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","li t'ap di se sè li Sara te ye. Se konsa, Abimelèk, wa peyi Gera a, fè yo mennen Sara ba li. ");
INSERT INTO hat_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Men pandan lannwit, Abimelèk fè yon rèv, li wè Bondye parèt devan li. Bondye di l'. Gade non, monchè. Ou pral mouri tande, paske Sara se yon madan marye. ");
INSERT INTO hat_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Men, Abimelèk pa t' gen tan kouche avè Sara. Li di. Mèt, èske w'ap kite yon pèp inonsan peri? ");
INSERT INTO hat_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Se Abraram ki di m' se sè li Sara ye. Sara pou tèt pa l' di m' se frè li Abraram ye. Mwen fè sa m' fè a san ankenn move lide. Mwen konnen mwen pa fè anyen ki mal. ");
INSERT INTO hat_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Bondye reponn li nan rèv la. Wi. Mwen konnen ou fè sa ou fè a san ankenn move lide dèyè tèt ou. Se poutèt sa mwen pa kite ou fè peche sa a kont mwen. Mwen pa kite ou fè madanm lan anyen. ");
INSERT INTO hat_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Men sa pou ou fè: renmèt nonm lan madanm li. Se yon pwofèt Bondye li ye. La lapriyè pou ou pou ou pa mouri. Men, si ou pa renmèt li, mwen tout di ou nou pral mouri, ou menm ansanm ak tout fanmi ou. ");
INSERT INTO hat_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Nan maten, bonè bonè, Abimelèk rele tout domestik li yo, li rakonte yo tout bagay. Yo tout yo te pè anpil. ");
INSERT INTO hat_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Lèfini, Abimelèk rele Abraram, li di l'. Kisa ou fè nou konsa? Kisa m' fè ou pou ou ta lakòz yon gwo malè konsa tonbe sou mwen ak sou peyi a? Sa ou fè nou la a, se bagay moun pa gen dwa fè. ");
INSERT INTO hat_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelèk di Abraram ankò. Poukisa ou fè sa ou fè a? ");
INSERT INTO hat_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraram reponn li. Mwen te di nan kè m' pa gen moun ki gen krentif pou Bondye bò isit la. Mwen tè kwè yo ta ka touye m' poutèt madanm mwen. ");
INSERT INTO hat_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Men, se vre wi, se sè m' li ye. Nou menm papa, men nou pa menm manman. Epi se madanm mwen li ye tou. ");
INSERT INTO hat_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Se konsa, lè Bondye fè m' kite lakay papa m' pou m' al nan peyi etranje yo, mwen di Sara: m'ap mande ou pou rann mwen yon sèvis? Si ou renmen m' vre, tanpri, kote ou pase, se pou di se frè ou mwen ye. ");
INSERT INTO hat_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Lè sa a, Abimelèk renmèt Sara bay Abraram. Anmenmtan li ba li mouton, bèf ak domestik, fanm kou gason, pou sèvi l'. ");
INSERT INTO hat_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Li di Abraram. Gade! tout peyi m' lan devan ou. Rete kote ki fè ou plezi. ");
INSERT INTO hat_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Epi li di Sara. Mwen bay frè ou la mil (01.000) pyès lajan. Se pou sa ka fè moun ki la avè ou yo bliye sak te rive ou. Konsa, tout moun va konnen ou pa t' fè anyen ki mal. ");
INSERT INTO hat_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","- ");
INSERT INTO hat_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Poutèt sa ki te rive Sara, madanm Abraram lan, Seyè a te fè tout fanm lakay Abimelèk pa t' kapab fè pitit. Abraram lapriyè pou Abimelèk, epi Bondye geri li. Bondye geri madanm li tout ansanm ak medam k'ap travay lakay li pou yo kapab fè pitit ankò. ");
INSERT INTO hat_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Seyè a fè Sara favè, jan l' te di l' la. Li fè sa l' te pwomèt li a rive vre. ");
INSERT INTO hat_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara vin ansent. Atout li te fin vye granmoun lan, li fè yon pitit gason pou Abraram, nan dat Bondye te di l' la. ");
INSERT INTO hat_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraram rele pitit gason Sara te fè pou li a Izarak. ");
INSERT INTO hat_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ti gason an te gen wit jou lè Abraram sikonsi l', jan Bondye te ba li lòd la. ");
INSERT INTO hat_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraram te gen santan sou tèt li lè Izarak, pitit li a, te fèt. ");
INSERT INTO hat_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara di konsa. Bondye fè m' bagay ki fè m' ri. tout moun ki tande sa pral ri avè m' tou. ");
INSERT INTO hat_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Apre sa, li di ankò: -Ki moun ki ta di Abraram yon jou Sara gen pou bay timoun tete? Men, atout li fin vye a, mwen fè yon pitit gason pou li. ");
INSERT INTO hat_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ti gason an grandi, li sevre. Jou yo sevre l' la, Abraram fè yon gwo fèt. ");
INSERT INTO hat_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Yon jou Izmayèl, pitit Aga, fanm peyi Lejip la te fè pou Abraram lan t'ap jwe ak Izarak, pitit Sara a. Sara wè sa. ");
INSERT INTO hat_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Li di Abraram konsa: -Mete sèvant la deyò ansanm ak tout pitit li a, paske pitit sèvant sa a pa gen dwa eritye ak Izarak, pitit mwen an. ");
INSERT INTO hat_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Pawòl sa a te fè Abraram lapenn anpil, paske Izmayèl te pitit li tou. ");
INSERT INTO hat_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Men, Bondye di Abraram konsa-Ou pa bezwen pran lapenn pou ti gason an ak pou Aga, sèvant ou a. Ou mèt fè tout sa Sara di ou fè a, paske se Izarak ki pral ba ou pitit pitit mwen pwomèt ou yo. ");
INSERT INTO hat_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","M'ap bay pitit sèvant lan anpil pitit pitit. M'ap fè l' tounen yon nasyon, paske se pitit ou li ye tou. ");
INSERT INTO hat_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Nan denmen Abraram leve bonè, li pran pen ak yon sak an po bèt plen dlo, li bay Aga. Li ede l' mete yo sou tèt li. Li ba li pitit la, li fè l' ale kite kay la. Aga pati, li mache, li mache, jouk li pèdi nan dezè Bècheba a. ");
INSERT INTO hat_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Lè dlo nan sak la fini, li kite pitit la anba yon touf raje. ");
INSERT INTO hat_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","li ale, li chita pi devan, yon bon ti distans, li di nan kè l' -Mwen pa ka rete ap gade pitit mwen an ap mouri konsa. Pandan li chita konsa, pitit la pran rele. ");
INSERT INTO hat_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Bondye tande rèl pitit la. Zanj Bondye a rete nan syèl la, li pale ak Aga, li di l' konsa-Sa ou genyen, Aga? Ou pa bezwen pè. Kote Bondye ye a, li tande rèl ti pitit la. ");
INSERT INTO hat_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Leve non, pran ti pitit la, kenbe l'. M'ap fè pitit pitit li yo tounen yon gwo nasyon. ");
INSERT INTO hat_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Bondye louvri je Aga. Aga wè yon pi. li ale, li plen sak an po a dlo. Li bay ti pitit la bwè dlo kont kò l'. ");
INSERT INTO hat_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Bondye te avèk ti pitit la. Li grandi, li rete nan dezè a. Li te rive konn tire flèch nan banza ak anpil ladrès. ");
INSERT INTO hat_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Se nan dezè Paran li te rete. Manman l' te chwazi yon madanm pou li nan jenn fi peyi Lejip yo. ");
INSERT INTO hat_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lè sa a, Abimelèk ale ansanm avek Pikòl, kòmandan lame li a, li pale ak Abraram. Li di l' konsa-Bondye avè ou nan tout sa w'ap fè. ");
INSERT INTO hat_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Koulye a, fè sèman, isit la menm, devan Bondye, ou p'ap janm twonpe ni mwen menm, ni pitit mwen yo, ni pitit pitit mwen yo. Mwen te aji byen avè ou. Pwomèt w'ap aji byen avè m' tou, epi w'ap sèvi byen ak tout moun nan peyi kote ou rete a. ");
INSERT INTO hat_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraram reponn. -M' fè sèman. ");
INSERT INTO hat_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Men Abraram te fè Abimelèk repwòch pou yon pi li domestik Abimelèk yo te pran pa fòs. ");
INSERT INTO hat_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelèk di l' -Mwen pa konnen ki moun ki fè sa. Ni tou, ou pa t' janm di m' anyen sou sa. Se koulye a m'ap tande koze a. ");
INSERT INTO hat_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraram pran kèk mouton ak kèk bèf li bay Abimelèk. Konsa, yo pase kontra yonn ak lòt. ");
INSERT INTO hat_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraram pran sèt mouton nan bann mouton l' yo, li mete yo sou kote. ");
INSERT INTO hat_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelèk mande l' -Poukisa ou mete sèt mouton sa yo sou kote. ");
INSERT INTO hat_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraram reponn li-Asepte sèt mouton sa yo. Si ou asepte yo, sa vle di ou rekonèt devan tout moun se mwen menm ki te fouye pi a. ");
INSERT INTO hat_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Se poutèt sa yo rele anplasman an Bècheba, paske se la menm yo te sèmante yonn bay lòt. ");
INSERT INTO hat_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Se Bècheba yo te pase kontra yonn ak lòt. Apre sa, Abimelèk leve, li tounen nan peyi moun Filisti yo, ansanm ak Pikòl, kòmandan lame li a. ");
INSERT INTO hat_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Se la Bècheba Abraram plante yon pye tonmaren. Lèfini li fè sèvis pou Seyè a, Bondye ki la pou tout tan an. ");
INSERT INTO hat_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Apre sa, Abraram rete kèk lanne ankò nan peyi Filisti a. ");
INSERT INTO hat_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Apre tout bagay sa yo, Bondye sonde Abraram pou wè sou ki pye li ye avè l'. Bondye rele l' -Abraram! Abraram! Abraram reponn-Men mwen wi! ");
INSERT INTO hat_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Bondye di l': -Pran Izarak, pitit ou a, sèl pitit gason ou genyen an, pitit ou renmen anpil la. Ale nan peyi Morija, w'a moute sou tèt mòn mwen pral moutre ou la. Lè w'a rive la, w'a touye l'. Apre sa, w'a boule l' nèt pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nan denmen maten, bonè bonè, Abraram leve, li sele bourik li, li pran Izarak ansanm ak de nan domestik li yo. Li fann kèk moso bwa pou l' fè dife pou boule vyann bèt l'ap ofri a. Epi li pati nan direksyon kote Bondye te di l' la. ");
INSERT INTO hat_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Sou twa jou, Abraram gade, li wè kote a yon bon ti bout devan l'. ");
INSERT INTO hat_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraram di domestik li yo. -Nou menm, mesye, rete isit la ak bourik la. Mwen menm ak ti gason an, nou pral jouk lòt bò a, pou nou fè sèvis pou Bondye. Apre sa, n'a tounen vin jwenn nou. ");
INSERT INTO hat_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraram pran bwa pou fè dife a, li bay Izarak pote li. Li menm, li pote bagay pou limen dife a ansanm ak yon kouto nan men l'. Yo tout de pati ansanm. ");
INSERT INTO hat_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Pandan y'ap mache konsa, Izarak di Abraram: -Papa! Abraram reponn: -Wi, pitit mwen! Izarak mande l': -Mwen wè ou gen dife ak bwa. Men, kote mouton pou boule a? ");
INSERT INTO hat_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraram reponn: -Pitit mwen, se sou kont Bondye sa ye. Yo toude t'ap kontinye mache ansanm. ");
INSERT INTO hat_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lè yo rive kote Bondye te di l' la, Abraram moute yon lotèl, li ranje bwa yo sou li. Li mare Izarak, pitit gason l' lan, li mete l' sou lotèl la, anwo bwa yo. ");
INSERT INTO hat_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Apre sa, li lonje men l', li pran kouto a pou l' koupe kou ti gason an. ");
INSERT INTO hat_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Men, zanj Bondye a rete nan syèl la, li rele l': -Abraram! Abraram! Abraram reponn. -Men mwen wi! ");
INSERT INTO hat_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Zanj lan di l' -Pa leve men ou sou ti gason an. Pa fè l' anyen. Koulye a mwen konnen ou gen krentif pou Bondye vre, paske ou pa t' derefize touye sèl pitit gason ou lan pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraram voye je l', li wè yon belye mouton ki te gen kòn li yo makònen nan yon lyann. li ale, li pran mouton an, li touye l', li boule li nèt sou lotèl la pou Bondye nan plas pitit li a. ");
INSERT INTO hat_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraram rele kote sa a: Se sou kont Seyè a sa ye. Se poutèt sa, jouk jòdi a, moun ap repete: Sou mòn Seyè a, tout bagay sou kont li. ");
INSERT INTO hat_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Zanj Bondye a rete nan syèl la, li pale ak Abraram yon dezyèm fwa, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","-Mwen sèmante sou tèt mwen. Se mwen menm Seyè a ki di sa. Mwen gen pou m' beni ou anpil poutèt sa ou fè a. Ou pa t' refize ban mwen pitit ou a, sèl pitit gason ou genyen an. ");
INSERT INTO hat_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Mwen pwomèt pou m' ba ou anpil pitit pitit. Y'ap tankou zetwal nan syèl la, tankou grenn sab bò lanmè. Y'a bat tout lènmi yo. ");
INSERT INTO hat_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Gremesi tout pitit pitit ou yo, tout nasyon sou latè pral jwenn benediksyon. Wi, yo tout, paske ou te fè sa m' te mande ou fè a. ");
INSERT INTO hat_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraram tounen bò kote domestik li yo, domestik yo pati ansanm avè l' pou peyi Bècheba, kote Abraram te rete a. ");
INSERT INTO hat_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Apre tout bagay sa yo, yo vin di Abraram konsa: -Tande non. Milka fè pitit tout wi pou Nak, frè ou la. ");
INSERT INTO hat_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Premye pitit la rele Ouz. Apre li, vini Bouz, Kemwèl, papa Aram, ");
INSERT INTO hat_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesèd, Azò, Pildach, Jidlaf ak Betwèl. ");
INSERT INTO hat_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Se Betwèl ki papa Rebeka. Se wit gason sa yo Milka te fè pou Nakò, frè Abraram lan. ");
INSERT INTO hat_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Reouma, fanm kay Nakò a te fè pitit tout pou li: se te Tebak, Gam, Tach ak Maka. ");
INSERT INTO hat_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara viv sanvennsetan (0127 an). ");
INSERT INTO hat_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Li mouri yon kote yo rele Kiriyat Aba osinon Ebwon nan peyi Kanaran. Abraram pran lapenn pou lanmò Sara, li plenn sò li. ");
INSERT INTO hat_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraram leve bò kote kadav la, li ale pale ak moun Et yo. Li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","-Se etranje mwen ye, se depasaj mwen ye nan mitan nou. Vann mwen yon anplasman pou m' ka antere madanm mwen, konsa m'a wete kadav la devan je m'. ");
INSERT INTO hat_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Moun Et yo reponn Abraram, yo di l' konsa: ");
INSERT INTO hat_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","-Mèt, koute sa n'ap di ou. Ou se yon gwonèg Bondye voye nan mitan nou. Chwazi yonn nan pi bon kavo nou yo pou antere madanm ou. Pa gen yonn nan nou ki pou ta refize ba ou kavo li pou antere madanm ou. ");
INSERT INTO hat_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraram kanpe. Pa respè pou moun Et yo, li bese tèt li byen ba devan yo. ");
INSERT INTO hat_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Li di yo: -Si nou dakò pou m' antere madanm mwen isit la, pou m' wete kadav li devan je m', koute sa m'ap di nou. Nou konnen Efwon, pitit gason Zoka a? Pale avè l' pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Mande l' pou l' vann mwen twou wòch Makpela a ki pou li nan bout jaden l' lan. Mande l' pou l' vann mwen li pou pri li vo, pou sa ka sèvi m' simityè isit la. ");
INSERT INTO hat_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efwon te chita la avèk lòt moun Et yo, bò pòtay lavil la, kote moun yo konn reyini an. Devan moun Et yo, devan tout moun ki t'ap pase bò pòtay la, Efwon reponn Abraram. Li di li: ");
INSERT INTO hat_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","-Non, mèt! Koute sa m'ap di ou: Mwen fè ou kado jaden an ak tout twou wòch ki ladan l' lan. Mwen fè ou kado l' devan tout moun peyi m' yo. M'ap ba ou l' pou ou ka antere madanm ou. ");
INSERT INTO hat_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Men, Abraram bese tèt li byen ba devan moun Et yo. ");
INSERT INTO hat_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Li pale ak Efwon pou tout moun ka tande. Li di l': -Koute sa m'ap di ou: M'ap achte tout jaden an nan men ou pou pri li vo. Tanpri, asepte lajan m'ap ba ou pou li a. Se lè sa a m'a antere madanm mwen ladan l'. ");
INSERT INTO hat_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efwon reponn Abraram: -Mèt, tanpri koute sa m'ap di ou: ");
INSERT INTO hat_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Yon moso tè ki vo katsan (0400) pyès lò, pa gen rezon pou n'ap diskite pou sa. Antere madanm ou sou li non! ");
INSERT INTO hat_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraram dakò ak sa Efwon di l' la. Li peze lajan an, li bay Efwon li devan tout moun Et yo. Wi, li ba li katsan (0400) pyès lò dapre jan kòmèsan yo te sèvi nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Se konsa, moso tè Efwon te gen Makpela a, anfas peyi Manmre a, ansanm ak tout twou wòch la ak tout pyebwa ki nan jaden an, jouk sou lizyè li, ");
INSERT INTO hat_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","yo vin pou Abraram, devan tout moun Et yo, devan tout moun ki te bò pòtay la. ");
INSERT INTO hat_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Apre sa, Abraram antere Sara, madanm li, nan twou wòch ki te nan jaden Makpela a, anfas Manmre yo rele Ebwon an, nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Se konsa, Abraram achte jaden an ak tout twou wòch ki te ladan l' lan, nan men moun Et yo, li fè l' sèvi simityè pou li. ");
INSERT INTO hat_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraram te fin vye. Li te antre nan granmoun. Seyè a te beni Abraram nan tout bagay. ");
INSERT INTO hat_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraram te gen yon domestik ki te pi ansyen pase tout lòt yo. Se li menm ki te jeran reskonsab tout byen li yo. Abraram di l' konsa: -Men, mete men ou nan fant janm mwen, fè sèman. ");
INSERT INTO hat_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Mwen vle pou ou fè sèman sou Seyè a, Bondye syèl la ak Bondye latè a, pou ou pa chwazi yon madanm pou pitit gason m' lan nan medam k'ap viv nan peyi Kanaran kote m' rete a. ");
INSERT INTO hat_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Men, se nan peyi pa m' pou ou ale, pou ou chwazi pami moun menm ras ak mwen yo yon madanm pou Izarak, pitit gason m' lan. ");
INSERT INTO hat_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Domestik la mande l': -Kisa pou m' fè si fi a pa vle kite peyi l' pou l' vin avè m' nan peyi sa a? Eske se pou m' mennen pitit gason ou lan ale nan peyi kote ou te soti a? ");
INSERT INTO hat_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraram reponn li: -Non, non, non! Pa janm mennen pitit mwen an laba a! ");
INSERT INTO hat_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Seyè a, Bondye syèl la, te pran m' fè m' soti lakay papa m' ak nan peyi fanmi mwen. Li pale avè m'. Li fè m' sèman l'ap bay pitit pitit mwen yo peyi sa a. Enben, se li menm ki va fè zanj li pran devan ou, pou ou chwazi yon madanm nan moun laba yo pou pitit gason m' lan. ");
INSERT INTO hat_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Si madanm lan pa vle vin avè ou, w'a konnen ou kit ak sèman ou te fè m' lan. Sèlman, nenpòt jan, pa mennen pitit gason m' lan laba a. ");
INSERT INTO hat_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Domestik la mete men l' nan fant janm Abraram, mèt li, epi li sèmante pou l' fè sa l' mande l' fè a. ");
INSERT INTO hat_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Domestik la pran dis chamo nan chamo mèt li yo. Li pran yon kantite bèl bagay ki koute chè, li chaje chamo yo. Li leve, li pati, li ale lavil kote Nakò rete a nan peyi Mezopotami. ");
INSERT INTO hat_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Lè aswè rive, li fè chamo yo kouche bò pi ki lòt bò pòtay lavil la. Se te lè ti medam yo tè konn vin tire dlo. ");
INSERT INTO hat_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Li lapriyè, li di: -Seyè, ou menm ki Bondye Abraram, mèt mwen, tanpri, fè m' jwenn jòdi a sa m'ap chache a. Moutre jan ou bon pou Abraram, mèt mwen. ");
INSERT INTO hat_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Men mwen kanpe bò pi a, kote medam yo ap vin chache dlo. ");
INSERT INTO hat_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mwen mande ou pou jenn fi ki va reponn mwen l'ap ban m' bwè lèfini l'ap bay chamo m' yo bwè tou, lè m'a di l': Tanpri, bese krich ou a ban m' ti gout dlo pou m' bwè, fè se li menm ou chwazi pou Izarak, sèvitè ou la. Lè sa a, m'a konnen jan ou bon pou mèt mwen vre. ");
INSERT INTO hat_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Li t'ap pale toujou lè Rebeka parèt avèk yon krich sou zepòl li. Rebeka te pitit Betwèl. Betwèl sa a te pitit gason Milka ki te marye ak Nakò, frè Abraram lan. ");
INSERT INTO hat_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Se te yon jenn fi. Li te bèl anpil, li te tifi. Li desann nan sous la, li plen krich li. Epi li moute soti deyò. ");
INSERT INTO hat_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Domestik la kouri al jwenn li, li di l' konsa: -Tanpri, ban m' ti gout dlo nan krich ou a non. ");
INSERT INTO hat_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebeka reponn li: -Wi. Bwè non, msye. Li desann krich la soti sou zepòl li, li kenbe l' nan men l' pou fè nonm lan bwè. ");
INSERT INTO hat_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Lè nonm lan fin bwè, jenn fi a di l': -Mwen pral pran dlo pou chamo ou yo, pou yo ka bwè kont yo tou. ");
INSERT INTO hat_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Li prese vide rès dlo krich la nan yon ti basen pou chamo yo bwè, epi li kouri desann nan sous la al chache dlo jouk tout chamo yo fin bwè kont yo. ");
INSERT INTO hat_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nonm lan menm te sezi. Li t'ap gade fi a san l' pa di anyen, li t'ap tann pou l' wè si Seyè a pa t' fè l' vwayaje pou gremesi. ");
INSERT INTO hat_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Lè chamo yo fin bwè, nonm lan pran yon bèl zanno lò ki peze sis gram, li pase l' nan nen Rebeka. Li pran de bèl braslè ki peze san gram, li mete yo nan bra li. ");
INSERT INTO hat_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Epi li mande l': -Pitit ki moun ou ye? Tanpri, di m' non. Eske gen kote lakay papa ou pou m' pase nwit la avèk chamo m' yo? ");
INSERT INTO hat_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Jenn fi a reponn: -Mwen se pitit fi Betwèl, yonn nan pitit gason Milka ak Nakò. ");
INSERT INTO hat_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Li di l' anko: -Lakay nou, nou gen kont pay zèb pou chamo ou yo. Wa jwenn kote pou ou pase nwit la tou. ");
INSERT INTO hat_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Lè sa a, nonm lan tonbe ajenou, li bese tèt li jouk atè devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Li di: -Lwanj pou Seyè a, Bondye Abraram, mèt mwen an. Li gen pitye pou li, li kenbe pwomès li te fè l' la. Li mennen m' tout dwat lakay fanmi mèt mwen an. ");
INSERT INTO hat_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Jenn fi a kouri lakay manman l'. Li rakonte tout sa ki te rive. ");
INSERT INTO hat_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka te gen yon frè yo rele Laban. Laban kouri deyò al jwenn nonm lan bò sous la. ");
INSERT INTO hat_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Li te wè zanno a nan nen sè li ak braslè yo nan bra l', li te tande l' ap rakonte sa nonm lan te di l'. Lamenm li al jwenn nonm lan ki te kanpe bò sous la ansanm ak chamo l' yo. ");
INSERT INTO hat_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban di l': -Antre non. Ou se yon nonm Seyè a beni. Poukisa ou rete deyò a konsa? Mwen pare yon kote pou ou nan kay la. Gen plas pou chamo ou yo tou. ");
INSERT INTO hat_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Nonm lan antre nan kay la. Laban desele chamo yo. Li fè ba yo pay ak zèb. Yo pare dlo pou nonm lan lave pye l', ansanm ak moun ki te avè l' yo. ");
INSERT INTO hat_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Lèfini, yo sèvi yo manje. Men nonm lan di: -Anvan m' manje, se pou m' di sa m' gen pou m' di a. Laban di l': -Bon. Pale non. ");
INSERT INTO hat_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Msye pran lapawòl, li di: -Mwen se domestik Abraram. ");
INSERT INTO hat_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Seyè a voye anpil benediksyon sou mèt mwen. Li fè l' vin grannèg. Li ba li mouton, bèf, lajan, lò, domestik, sèvant, chamo, bourik. ");
INSERT INTO hat_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, madanm mèt mwen, te fin vye granmoun lè li te resi fè yon pitit gason pou li. Mèt mwen bay pitit sa a tout sa li genyen. ");
INSERT INTO hat_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mèt mwen fè m' fè sèman, li di m' piga m' chwazi yon madanm pou pitit gason l' lan nan medam moun peyi Kanaran kote l' rete a. ");
INSERT INTO hat_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Men se pou m ale lakay papa l' pou mwen chwazi yon madanm nan ras li pou pitit gason l' lan. ");
INSERT INTO hat_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Lè sa a, mwen di mèt mwen: Bon, si fi a pa vle vini avè m', kisa pou m' fè? ");
INSERT INTO hat_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Li reponn mwen: Seyè a ki wè jan mwen toujou obeyi l' va voye zanj li avè ou. Li p'ap fè ou vwayaje pou gremesi. Ou va chwazi yon madanm nan fanmi papa m' pou gason m' lan. ");
INSERT INTO hat_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Si ou fè sa, w'a kit ak sèman ou te fè m' lan. Konsa tou, si ou rive kay fanmi m', si yo menm yo refize, w'a kit ak sèman ou te fè m' lan tou. ");
INSERT INTO hat_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Jòdi a, lè m' rive bò sous dlo a, mwen di: Seyè, Bondye Abraram, mèt mwen an, si sa fè ou plezi, fè m' pa vwayaje pou gremesi. ");
INSERT INTO hat_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Gade, m'ap rete kanpe bò sous dlo a. Lè m'a wè yon jenn fi k'ap vin chache dlo nan pi a, m'a va di l': Tanpri, ban m' ti gout dlo nan krich ou a pou m' bwè. Si li reponn mwen: ");
INSERT INTO hat_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ou mèt bwè! Apre sa, m'a bay chamo ou yo bwè tou, tanpri fè se li menm ou chwazi pou madanm pitit mèt mwen an. ");
INSERT INTO hat_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Mwen pa t' menm fin di pawòl sa yo nan kè m', lè m' wè Rebeka rive ak krich li sou zepòl li. Li desann nan sous la, li pran dlo epi mwen di l': Tanpri, ban m' ti gout dlo pou m' bwè. ");
INSERT INTO hat_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Lamenm, li desann krich la soti sou zepòl li, li di m': Bwè non. Apre sa, m'a bay chamo ou yo bwè tou. Mwen bwè, epi li bay chamo m' yo bwè tou. ");
INSERT INTO hat_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Mwen mande l': Pitit ki moun ou ye? Li reponn mwen: Mwen se pitit fi Betwèl, pitit gason Milka ak Nakò. Lè sa a, mwen mete zanno a nan nen l', mwen mete braslè sa yo nan bra l'. ");
INSERT INTO hat_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Mwen tonbe ajenou, mwen bese tèt mwen jouk atè devan Seyè a, mwen fè lwanj Seyè a, Bondye Abraram, mèt mwen an, paske li mennen m' tout dwat lakay frè mèt mwen an, kote mwen jwenn yon madanm pou pitit gason l' lan. ");
INSERT INTO hat_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Alèkile, si nou vle aji byen avè l', si nou vle fè l' konfyans, fè m' konnen. Si nou pa dakò, fè m' konnen tou, pou m' ka konnen sa pou m' fè. ");
INSERT INTO hat_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban ak Betwèl reponn: -Bagay sa a se travay Seyè a, Bondye a. Nou pa gen anyen pou n' di nan sa. ");
INSERT INTO hat_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Men Rebeka devan ou, pran li, mennen l' ale pou l' vin madanm pitit gason mèt ou a, jan Bondye te di l' la. ");
INSERT INTO hat_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Lè domestik Abraram lan tande sa, li tonbe ajenou, li bese tèt li jouk atè devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Apre sa, li pran rale bèl bijou fèt an ajan ak an lò ansanm ak rad, li bay Rebeka. Li te bay frè a ak manman an anpil bèl kado tou. ");
INSERT INTO hat_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Apre sa, domestik Abraram lan manje ansanm ak moun ki te avè l' yo, yo bwè, yo dòmi. Nan maten, lè yo leve, domestik la di: -Kite m' tounen al jwenn mèt mwen. ");
INSERT INTO hat_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Men, frè a avèk manman an di konsa: -Kite fi a pase dis jou ankò avèk nou non. Apre sa, n'a pati. ");
INSERT INTO hat_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Li reponn yo: -Pa ban m' reta. Seyè a pa fè m' vwayaje pou gremesi. Tanpri, kite m' al jwenn mèt mwen. ");
INSERT INTO hat_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yo di l': -Bon. Ann rele fi a. Ann mande l' sa l' di nan sa. ");
INSERT INTO hat_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Yo rele Rebeka, yo mande l': -Eske ou vle ale ak nonm sa a? Li reponn: -Wi, mwen vle ale. ");
INSERT INTO hat_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Se konsa yo kite Rebeka, sè yo a, ansanm ak bòn ki te nouris li a pati avèk domestik Abraram lan, ansanm ak moun ki te vin avè l' yo. ");
INSERT INTO hat_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Yo beni Rebeka, yo di l': -Rebeka, sè nou, nou mande Bondye pou ou fè anpil anpil pitit. Se pou pitit pitit ou yo bat tout lènmi yo. ");
INSERT INTO hat_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Apre sa, Rebeka avèk tout sèvant li yo leve, yo moute chamo yo, yo pati avèk nonm lan. Domestik la pran l', li pati ak li. ");
INSERT INTO hat_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Lè sa a, Izarak te vini nan dezè a, bò kote Pi moun vivan ki wè m' lan. Li te rete nan peyi Negèv. ");
INSERT INTO hat_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Yon jou swa, Izarak t'ap pwonmennen deyò nan jaden li, li t'ap kalkile. Li leve je l', li gade, li wè kèk chamo ki t'ap vini. ");
INSERT INTO hat_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Menm lè a tou, Rebeka leve je l', li wè Izarak. Li desann chamo a. ");
INSERT INTO hat_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Li mande domestik la: -Ki msye sa a k'ap mache vin jwenn nou nan jaden an? Domestik la reponn li: -Se mèt mwen an wi. Rebeka pran yon vwal, li bouche figi l'. ");
INSERT INTO hat_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Domestik la rakonte Izarak tout sa li te fè. ");
INSERT INTO hat_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Izarak mennen Rebeka lakay li, kay ki te pou Sara, manman l' lan. Li pran l' pou madanm li. Izarak te renmen Rebeka. Se konsa li te jwenn konsolasyon, apre li te fin pèdi manman l' lan. ");
INSERT INTO hat_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraram te pran yon lòt fanm yo te rele Ketoura. ");
INSERT INTO hat_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketoura fè sis pitit pou li: Zimran, Joksan, Medan, Madyan, Jisbak ak Swak. ");
INSERT INTO hat_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Joksan te papa Seba ak Dedan. Men pitit Dedan yo: Se te moun Achou yo, moun Letouch yo ak moun Lemou yo. ");
INSERT INTO hat_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Men pitit Madyan yo: Se te Efa, Efe, Enòk, Abida ak Elda. Se tout moun sa yo ki te pitit ak pitit pitit Ketoura. ");
INSERT INTO hat_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraram kite tout byen l' yo pou Izarak. ");
INSERT INTO hat_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Men anvan l' mouri, li te bay pitit li te fè ak lòt fanm kay yo kèk kado. Apre sa, li fè yo pati, li voye yo byen lwen Izarak, pitit gason l' lan, li voye yo nan peyi kote solèy leve a. ");
INSERT INTO hat_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraram te viv sanswasannkenzan (0175 an). ");
INSERT INTO hat_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraram te fin granmoun, li te wè kont jou l', li te pase vye jou l' yo san pwoblèm. Apre sa li mouri, li al jwenn moun li yo ki te mouri deja. ");
INSERT INTO hat_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Izarak ak Izmayèl, pitit li yo, antere l' nan twou wòch Makpela a, nan jaden Efwon, pitit Zoka, yon moun Et, anfas Manmre. ");
INSERT INTO hat_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Se jaden sa a Abraram te achte nan men mesye Et yo. Se la yo te antere Abraram ak Sara, madanm li. ");
INSERT INTO hat_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Apre Abraram mouri, Bondye te beni Izarak, pitit gason l' lan, ki te rete toupre Pi moun vivan ki wè m' lan. ");
INSERT INTO hat_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Men pitit pitit Izmayèl, pitit Abraram lan. Se Aga, moun peyi Lejip, sèvant Sara, ki te fè pitit sa a pou Abraram. ");
INSERT INTO hat_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Men non pitit Izmayèl yo. N'ap konmanse ak pi gran an pou rive sou pi piti a. Nebajòt te premye pitit Izmayèl. Apre li vini Keda, Adbeyèl, Mibsam, ");
INSERT INTO hat_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Michma, Douma, Masa, ");
INSERT INTO hat_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adad, Tema, Jetou, Nafich ak Kedma. ");
INSERT INTO hat_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Se yo ki te pitit Izmayèl. Se konsa yo te rele yo ansanm ak tout katye kote yo te rete ak kote yo te moute tant yo. Sa te fè douz chèf, chak ak nasyon pa yo. ");
INSERT INTO hat_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Izmayèl te gen santrannsetan (0137 an) lè l' mouri. Y al antere l' menm kote ak moun li yo ki te mouri deja. ");
INSERT INTO hat_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Pitit pitit Izmayèl yo te rete sou teritwa ki konmanse depi Avila rive jouk Chou, anfas peyi Lejip sou bò solèy leve a, anvan ou pran peyi Lasiri. Yo t'ap viv pou kont yo. Yo pa t' mele ak rès fanmi yo. ");
INSERT INTO hat_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Men istwa Izarak, pitit Abraram. ");
INSERT INTO hat_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Abraram te papa Izarak. Izarak te gen karantan lè li marye ak Rebeka ki te pitit fi Betwèl, moun lavil Aram, ki te rete nan peyi Mezopotami an. Rebeka te sè Laban, moun lavil Aram. ");
INSERT INTO hat_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Madanm Izarak pa t' ka fè pitit. Izarak lapriyè Seyè a pou li, Seyè a reponn li. Rebeka, madanm li, vin ansent. ");
INSERT INTO hat_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","De ti pitit yo t'ap plede goumen nan vant li. Rebeka di: -Si se konsa sa ye, mwen pa konprann anyen? li al lapriyè Seyè a. ");
INSERT INTO hat_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Seyè a reponn li: -Ou gen de nasyon nan vant ou. W'ap fè de pèp: chak ap pran bò pa yo. Yonn p'ap vle wè lòt. Yonn ap pi gwonèg pase lòt. Pi gran an pral sou zòd pi piti a. ");
INSERT INTO hat_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Lè jou pou Rebeka akouche a rive, li fè de marasa. ");
INSERT INTO hat_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Premye ki te fèt la te tout wouj. Li te kouvri ak pwal sou tout kò l'. Se poutèt sa yo te rele l' Ezaou. ");
INSERT INTO hat_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Lè dezyèm lan te fèt, men li te kenbe Ezaou nan talon pye l': se poutèt sa yo rele l' Jakòb. Izarak te gen swasantan sou tèt li lè yo te fèt. ");
INSERT INTO hat_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Timoun yo grandi. Ezaou te vin yon bon chasè, li te toujou nan bwa. Men Jakòb te yon nonm byen dousman, li te renmen rete lakay. ");
INSERT INTO hat_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Izarak te pito Ezaou, paske li te renmen manje vyann jibye, men Rebeka te pito Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yon jou, Jakòb te fin kwit yon bon bouyon, Ezaou antre sot nan jaden, li te bouke anpil. ");
INSERT INTO hat_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Li di Jakòb konsa: -M'ap mouri grangou. Tanpri, ban m' ti gout nan bouyon pwa wouj ou a. Se poutèt sa yo te bay Ezaou yon lòt ti non. Yo te rele l' Edon. ");
INSERT INTO hat_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Men Jakòb di l': -M'ap ba ou ti gout si ou vann mwen dwa ou kòm premye pitit. ");
INSERT INTO hat_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ezaou reponn: -Dakò. Mwen pral mouri. Kisa dwa kòm premye pitit la ap sèvi m'? ");
INSERT INTO hat_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakòb di li: -Fè m' sèman anvan. Ezaou fè sèman ba li, li vann li dwa l' kòm premye pitit. ");
INSERT INTO hat_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Lèfini, Jakòb ba li pen ak ti gout nan bouyon pwa a. Ezaou manje, li bwè. Li leve, li pati. Konsa, Ezaou te konsidere dwa li kòm premye pitit pou anyen. ");
INSERT INTO hat_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Te vin gen yon lòt grangou nan peyi a, pi rèd pase sa ki te tonbe sou peyi a nan tan Abraram lan. Lè sa a, Izarak ale yon kote yo rele Gera kay Abimelèk, wa moun Filisti yo. ");
INSERT INTO hat_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Izarak fè yon vizyon, li wè Seyè a parèt devan l'. Seyè a di l': -Pa desann nan peyi Lejip, rete kote m'ap di ou rete a. ");
INSERT INTO hat_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","W'a pase kèk tan nan peyi sa a. M'ap avè ou, m'ap beni ou, paske mwen pral ba ou tout tè sa a pou ou menm ak pou tout ras ou. m'a kenbe sèman mwen te fè bay Abraram, papa ou. ");
INSERT INTO hat_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","M'ap ba ou anpil anpil pitit tankou zetwal nan syèl la. M'ap ba yo tout tè sa yo. Gremesi pitit pitit ou yo, tout nasyon sou latè pral jwenn benediksyon. ");
INSERT INTO hat_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","tout sa, paske Abraram te tande m' lè m' te pale avè l', li te swiv tout lòd mwen yo ak tout kòmandman mwen yo. Li te fè tout sa mwen mande l', li te obeyi tout lwa mwen yo. ");
INSERT INTO hat_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Se konsa Izarak rete kote yo rele Gera a. ");
INSERT INTO hat_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Lè mesye ki te rete nan peyi a mande l' kisa madanm li ye pou li, li reponn yo se sè l' li ye, paske li te pè di se madanm li Rebeka te ye pou mesye yo pa t' touye l' pou yo te ka pran Rebeka ki te bèl anpil. ");
INSERT INTO hat_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Izarak te gen kèk tan depi l' te rete la. Yon jou, Abimelek, wa moun Filisti yo, t'ap gade nan fennèt li, li te wè Izarak ki t'ap pase men sou Rebeka, madanm li. ");
INSERT INTO hat_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Lè sa a, Abimelèk voye chache Izarak. Li di l' konsa: -Gade non, monchè, se madanm ou li ye! Poukisa ou di se sè ou li ye! Izarak reponn li: -Mwen te di sa paske mwen te kwè yo ta ka touye m', si m' te di se madanm mwen li ye. ");
INSERT INTO hat_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelèk di l': -Kisa ou fè nou konsa? Yonn nan mesye nou yo ta ka byen rive kouche avèk madanm ou! Se ou ki ta lakòz nou fè peche sa a. ");
INSERT INTO hat_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Se konsa Abimelèk pase lòd sa a bay tout pèp la: -Si yon moun manyen nonm sa a, osinon madanm li, y'ap touye l'. ");
INSERT INTO hat_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Izarak fè jaden nan peyi a. Lè lanne a bout, li rekòlte san fwa valè sa l' te plante a, paske Seyè a te beni l'. ");
INSERT INTO hat_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Msye te vin rich. Li t'ap fè lajan toujou, jouk li rive vin rich anpil anpil. ");
INSERT INTO hat_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Li te gen kantite kabrit, mouton ak bèf, ak anpil moun ki t'ap sèvi l'. Sa te fè moun Filisti yo rayi sò li. ");
INSERT INTO hat_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Se konsa yo konble tout pi domestik Abraram yo te fouye sou tan Abraram, papa Izarak. Yo plen yo tè. ");
INSERT INTO hat_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Lèfini, Abimelèk di Izarak: -Pati, al fè wout ou! Ou pi grannèg pase nou. ");
INSERT INTO hat_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Se konsa Izarak pati kite kote l' te ye a, li ale nan Fon Gera a. Se la li moute kay li pou l' rete. ");
INSERT INTO hat_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Li fè refouye tout pi dlo yo te fouye sou tan Abraram, papa l'. Se pi sa yo moun Filisti yo te bouche apre lanmò Abraram. Izarak ba yo menm non papa l' te ba yo a. ");
INSERT INTO hat_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Domestik Izarak yo te fouye ankò nan fon an. Yo te jwenn yon sous dlo k'ap ponpe. ");
INSERT INTO hat_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Men, gadò mouton peyi Gera yo leve yon sèl kont avèk gadò mouton Izarak yo. Yo t'ap di: -Dlo sa a, se pou nou li ye. Se konsa Izarak rele pi a Pi dezagreman paske yo te chache l' dezagreman pou dlo a. ");
INSERT INTO hat_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Domestik Izarak yo fouye yon lòt pi ki te lakòz yo chache yo kont ankò. Se konsa Izarak rele pi a Pi ki fè lènmi. ");
INSERT INTO hat_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Lè l' wè sa, li wete kò l' kote l' te ye a, li fouye yon lòt pi pou sa pa t' fè kont. Se poutèt sa li rele pi a Pi ki pa nan kont. Li di: -Koulye a Seyè a ban nou kont espas nan peyi a pou nou pa nan kont. Se atò zafè nou pral mache nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Izarak pati, li moute Bècheba. ");
INSERT INTO hat_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Menm jou sa a, nan mitan lannwit, Seyè a parèt nan yon vizyon, li di Izarak konsa: -Mwen se Bondye Abraram, papa ou. Ou pa bezwen pè anyen, paske mwen la avèk ou. M'ap beni ou, m'ap ba ou anpil pitit pitit, poutèt Abraram, sèvitè m' lan. ");
INSERT INTO hat_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Izarak bati yon lotèl la, li fè sèvis pou Seyè a. Li moute kay li la. Domestik li yo fouye yon lòt pi. ");
INSERT INTO hat_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimelèk soti Gera, li vin wè Izarak. Li te gen avè l' Akouzat, yon bon zanmi l', ak Pikòl, kòmandan lame li a. ");
INSERT INTO hat_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Izarak mande yo: -Poukisa nou vin wè m' koulye a? Jan nou te rayi m' sa a jouk nou te rive mete m' deyò nan peyi nou an! ");
INSERT INTO hat_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Yo reponn li: -Koulye a nou konnen Seyè a avèk ou. Se poutèt sa nou di n'ap fè yon kontra avè ou, n'ap sèmante yonn bay lòt. ");
INSERT INTO hat_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","W'ap sèmante ou p'ap janm fè nou anyen, menm jan nou pa t' janm fè ou anyen. W'ap sèmante nou te toujou aji byen avè ou. Nou kite ou ale san bri san kont. Koulye a, ou gen benediksyon Bondye sou ou. ");
INSERT INTO hat_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Izarak fè gwo fèt pou yo. Yo manje, yo bwè. ");
INSERT INTO hat_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nan granmaten, yo leve, yo sèmante yonn bay lòt. Apre sa, moun Filisti yo di Izarak orevwa. Yo separe tankou de bon zanmi, epi y al fè wout yo. ");
INSERT INTO hat_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Menm jou sa a, domestik Izarak yo vin ba l' nouvèl pi yo t'ap fouye a. Yo di l': -Nou jwenn dlo. ");
INSERT INTO hat_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Izarak rele pi a Chibeya. Se poutèt sa, jouk jòdi a, yo rele lavil la Bècheba. ");
INSERT INTO hat_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ezaou te gen karantan lè l' marye ak Jidit, pitit fi Beri, yon moun Et. Li te gen yon lòt madanm tout yo te rele Basmat, pitit fi Elon, yon moun Et tou. ");
INSERT INTO hat_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Medam sa yo te rann Izarak ak Rebeka lavi minab. ");
INSERT INTO hat_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Izarak te fin vye granmoun, je l' pa t' bon, li pa t' kapab wè ladan yo ankò. Li rele premye pitit li a, Ezaou, li di l' konsa: -Pitit mwen, Ezaou reponn li: -Men mwen wi, papa. ");
INSERT INTO hat_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Izarak di l': -Ou wè jan m' fin vye. Mwen pa konn ki jou m'ap mouri. ");
INSERT INTO hat_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tanpri, pran zam ou yo, flèch ou yo ak banza ou la. Ale nan bwa a, chase jibye pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Lèfini, pare vyann lan jan ou konnen mwen renmen l' lan, pote l' ban mwen. m'a manje. Epi m'a ba ou benediksyon mwen anvan m' mouri. ");
INSERT INTO hat_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebeka menm t'ap tande sa Izarak t'ap di Ezaou, gason l' lan. Ezaou soti, li pati li al lachas pou papa l'. ");
INSERT INTO hat_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Lè sa a, Rebeka di Jakòb, pitit li a: -Men mwen fèk tande papa ou di Ezaou, frè ou la: ");
INSERT INTO hat_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Al chase jibye pote pou mwen, kwit li, m'a manje. Apre sa, m'a beni ou devan Seyè a anvan m' mouri. ");
INSERT INTO hat_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Koulye a, pitit mwen, koute sa m'ap di ou: Fè sa m'ap mande ou la. ");
INSERT INTO hat_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ale pran de jenn kabrit byen gra nan bann lan, pote yo ban mwen. m'a pare yo pou papa ou jan m' konnen li renmen l' lan. ");
INSERT INTO hat_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","W'a pote l' bay papa ou, la manje, la beni ou anvan l' mouri. ");
INSERT INTO hat_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakòb reponn manman l': -Men manman, Ezaou, frè mwen an, gen pwal sou tout kò li. Mwen menm, po pa m' lis. ");
INSERT INTO hat_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Si papa m' manyen m', la wè se twonpe m'ap twonpe l'. Lè sa a pase li ban mwen benediksyon, la ban m' madichon pito. ");
INSERT INTO hat_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Men manman an reponn: -Madichon la ba ou a va tonbe sou mwen, pitit mwen. Ou menm, fè sa mwen di ou fè a, al chache kabrit yo mennen ban mwen. ");
INSERT INTO hat_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jakòb ale chache bèt yo, li mennen yo bay manman l'. Manman l' pare yon manje jan li konnen papa a te renmen l' lan. ");
INSERT INTO hat_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Apre sa, Rebeka pran rad Ezaou, premye pitit li a, pi bèl rad Ezaou te gen lakay la, li mete yo anwo Jakòb, dezyèm pitit li a. ");
INSERT INTO hat_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Avèk po ti kabrit yo, li kouvri bra ak kou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Apre sa, li bay Jakòb manje a avèk pen li te fè. ");
INSERT INTO hat_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jakòb al jwenn papa l', li di: -Papa. Izarak reponn li: -Men mwen, pitit mwen. Kilès nan nou ki la a? ");
INSERT INTO hat_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakòb reponn: -Se mwen menm Ezaou, premye gason ou lan. Mwen fè sa ou te di m' fè a. Leve non, chita. Manje vyann mwen pote pou ou a. Apre sa, wa ban mwen benediksyon. ");
INSERT INTO hat_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Izarak di Jakòb: -Ki jan ou fè jwenn bèt la vit konsa, pitit mwen? Jakòb reponn li: -Seyè a, Bondye ou la, ede m'. Li fè jibye a vin devan mwen. ");
INSERT INTO hat_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Izarak di: -Pwoche non. Vini mwen manyen ou, pitit mwen, pou m' wè si wi ou non ou se Ezaou, pitit mwen an. ");
INSERT INTO hat_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakòb pwoche bò kote Izarak, papa l', ki manyen l'. Epi Izarak di: -Vwa a se vwa Jakòb, men bra a se bra Ezaou. ");
INSERT INTO hat_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Li pa t' rekonèt Jakòb, paske bra li te plen pwal tankou bra Ezaou, frè li a. Izarak beni l'. ");
INSERT INTO hat_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Li di l': -Se vre, se Ezaou, pitit mwen, ou ye? Jakòb reponn li: -Se mwen wi. ");
INSERT INTO hat_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Izarak di l': -Sèvi m' non. m'a manje vyann ou pote a. Apre sa, m'a beni ou. Jakòb sèvi l' manje a, li manje. Lèfini, Jakòb ba li diven, li bwè. ");
INSERT INTO hat_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Izarak, papa l', di l': -Pwoche non, pitit mwen. vin bo m'. ");
INSERT INTO hat_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jakòb pwoche, li bo papa l'. Papa a pran sant rad ki te sou li a, epi li ba li benediksyon l'. Li di l': -Sant kò pitit mwen an tankou sant yon jaden Seyè a beni. ");
INSERT INTO hat_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Se pou Bondye ba ou lawouze ki soti nan syèl la. Se pou l' fè jaden ou donnen anpil. Se pou l' ba ou bèl rekòt ble ak rezen. ");
INSERT INTO hat_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Se pou kantite pèp soumèt devan ou. Se pou kantite nasyon bese tèt devan ou. Se ou menm ki pou mèt frè ou yo. Se pou pitit pitit manman ou yo bese tèt devan ou. Se pou tout moun ki ba ou madichon jwenn madichon. Se pou tout moun ki beni ou jwenn benediksyon. ");
INSERT INTO hat_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Izarak te fin beni Jakòb. Jakòb te fèk kite papa li, Izarak, lè Ezaou, frè li a, antre soti lachas. ");
INSERT INTO hat_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Li te pare yon bon plat manje, li pote l' bay papa l'. Li di l': -Leve chita non, papa. Manje vyann pitit ou pote pou ou a, pou ou ka beni l'. ");
INSERT INTO hat_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Izarak, papa l', mande: -Ki moun sa a? Li reponn: -Se mwen menm, Ezaou, premye pitit gason ou lan. ");
INSERT INTO hat_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tande Izarak tande sa, li sezi, li pran tranble kou fèy bwa. Li di: -Kilès sa ki te pote ban m' manje jibye li sot chase a? Mwen fèk fin manje anvan ou rive la a. Mwen ba li benediksyon m' lan ki pou li nèt. ");
INSERT INTO hat_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lè Ezaou tande sa, yon sèl kòlè moute l', li tonbe rele byen fò: -Beni m' tout non, papa! ");
INSERT INTO hat_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Izarak reponn li: -Frè ou la vini, li twonpe m'. Li pran benediksyon ki te pou ou a. ");
INSERT INTO hat_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ezaou di: -Sa fè dezyèm fwa li pran sak pou mwen. Eske se paske li rele Jakòb la kifè l'ap pase devan m' konsa? Premye fwa a, li te pran dwa m' kòm premye pitit. Men koulye a, li pran benediksyon ki te pou mwen an! Apre sa, li di: -Men papa, èske ou pa gen yon lòt benediksyon pou mwen? ");
INSERT INTO hat_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Izarak reponn Ezaou: -Mwen mete l' chèf sou ou. Mwen fè tout rès fanmi an tounen moun k'ap sèvi l'. Mwen ba li mezi pwovizyon l'. Kisa m' ka fè pou ou ankò, pitit mwen? ");
INSERT INTO hat_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ezaou di papa a: -Se sèl benediksyon sa a ou te genyen, papa? Tanpri, beni m' tout non, papa! Lè sa a, Ezaou pete yon sèl rèl, li kriye byen fò. ");
INSERT INTO hat_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Se konsa Izarak di l': -Latè p'ap ba ou sa l' te dwe ba ou. p'ap gen lawouze ki soti nan syèl la pou wouze jaden ou. ");
INSERT INTO hat_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Se zam ou k'ap fè ou viv. W'ap sèvi frè ou la, se vre. Men, se pye poudre ou ye, w'a soti anba men l'. ");
INSERT INTO hat_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ezaou te rayi Jakòb poutèt papa a te ba li benediksyon ki te pou li a. Li di nan kè l': Papa m' pa lwen mouri. Fini yo fini antere l', m'ap touye Jakòb, frè mwen an. ");
INSERT INTO hat_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Yo vin rapòte bay Rebeka sa ki te soti nan bouch Ezaou, premye pitit gason l' lan. Li fè rele Jakòb, dezyèm pitit li a, li di l': -Koute! Ezaou, frè ou la, vle tire revanj sou ou. Li vle touye ou. ");
INSERT INTO hat_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Koulye a, pitit mwen, koute sa m'ap di ou la. Leve, pati ale kay Laban, frè mwen an ki rete nan peyi Karan. ");
INSERT INTO hat_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","W'a rete kèk tan la avèk li, jouk tan kòlè frè ou la va bese, ");
INSERT INTO hat_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","jouk tan la sispann move sou ou, jouk li va bliye sa ou te fè l' la. Lè sa a, atò, m'a voye chache ou, m'a fè ou tounen. Poukisa pou m' ta pèdi tou de pitit gason m' yo yon sèl jou a? ");
INSERT INTO hat_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebeka di Izarak konsa: -Mwen degoute, mwen bouke ak bann fi Et sa yo. Pase pou m' ta wè Jakòb pran yonn nan moun sa yo, yonn nan bann fi Et sa yo k'ap viv nan peyi a pou madanm, pito m' mouri! ");
INSERT INTO hat_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Izarak rele Jakòb, li beni l'. Apre sa, li ba li lòd sa a: -Piga ou pran fi peyi Kanaran an pou madanm ou. ");
INSERT INTO hat_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Leve non, ale Mezopotami lakay Betwèl, papa manman ou. W'a pran yonn nan piti fi Laban yo pou madanm. Laban, se frè manman ou. ");
INSERT INTO hat_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mwen mande Bondye ki gen tout pouvwa a pou l' beni maryaj ou, pou l' ba ou anpil pitit, pou ou tounen zansèt anpil nasyon. ");
INSERT INTO hat_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Se pou l' beni ou, ou menm ansanm ak tout pitit pitit ou yo, menm jan li te beni Abraram, pou ou ka pran posesyon peyi kote w'ap viv koulye a, peyi li te deja bay Abraram lan. ");
INSERT INTO hat_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Se konsa Izarak fè Jakòb pati. Jakòb ale nan Mezopotami lakay Laban, pitit Betwèl, moun peyi Aram lan. Laban se te frè Rebeka, manman Jakòb ak Ezaou. ");
INSERT INTO hat_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ezaou vin konnen ki jan Izarak te beni Jakòb, ki jan li te voye l' Mezopotami al chache yon madanm. Li vin konnen tout lè Izarak t'ap beni Jakòb la, li te pase l' lòd sa a: Piga ou pran fi peyi Kanaran an pou madanm ou. ");
INSERT INTO hat_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ezaou te wè Jakob te obeyi papa l' ak manman l', li te pati pou Mezopotami. ");
INSERT INTO hat_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Konsa, Ezaou vin wè Izarak papa l' pa t' renmen fi peyi Kanaran yo. ");
INSERT INTO hat_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Li leve, li ale lakay Izmayèl, lòt pitit gason Abraram lan, li pran yon lòt madanm mete sou sa li te genyen deja yo. Li marye ak Maalat, yonn nan pitit fi Izmayèl yo. Maalat sa a, se te sè Nebajòt. ");
INSERT INTO hat_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakòb kite Bècheba, li pati pou Karan. ");
INSERT INTO hat_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Li rive yon kote, li rete pase nwit la la, paske sòlèy te fin kouche. Li pran yon wòch sèvi l' zòrye, epi li kouche atè a konsa pou l' dòmi. ");
INSERT INTO hat_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Li fè yon rèv. Li reve li wè yon nechèl ki te kanpe de pye l' atè ak tèt li pèdi nan syèl la. Zanj Bondye yo t'ap moute desann sou nechèl la. ");
INSERT INTO hat_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Epi li wè Seyè a kanpe anwo nechèl la. Seyè a t'ap di: -Se mwen menm, Seyè a, Bondye Abraram, zansèt ou, ak Bondye Izarak. Ou wè tè kote ou kouche a, m'ap ba ou l' pou ou menm ansanm ak tout pitit pitit ou yo. ");
INSERT INTO hat_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Pitit pitit ou yo pral menm kantite ak grenn pousyè ki sou latè. Yo pral gaye nan tout direksyon, lès, lwès, nò, sid. Ou menm ak tout pitit pitit ou yo, nou pral tounen yon benediksyon pou tout moun ki sou latè. ");
INSERT INTO hat_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Pa bliye, m'ap toujou la avèk ou, m'ap voye je sou ou kote ou pase. M'ap fè ou tounen nan peyi sa a, paske mwen p'ap lage ou san m' pa fè tout sa mwen sot di ou la a. ");
INSERT INTO hat_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakòb leve nan dòmi an, li di: -Wè pa wè, Seyè a isit la, mwen pa t' konn sa. ");
INSERT INTO hat_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Msye vin pè, li di: -Isit la se yon kote pou moun respekte! Se pa lòt bagay, isit la se kay Bondye ak pòt syèl la. ");
INSERT INTO hat_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakòb leve byen bònè, li pran wòch li te fè sèvi l' zòrye a, li plante l' tankou yon bòn tè, li vide lwil sou li pou mete l' apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Li rele kote sa a Betèl. (Anvan sa, lavil la te rele Louz.) ");
INSERT INTO hat_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakòb fè yon pwomès bay Seyè a, li di: -Si Bondye toujou kanpe avèk mwen, si li voye je sou mwen nan tout vwayaj sa m'ap fè a, si li ban m' manje pou m' manje ak rad pou m' met sou mwen, ");
INSERT INTO hat_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","si l' fè m' tounen ak kè poze lakay papa m', Seyè a va Bondye m' vre. ");
INSERT INTO hat_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Wòch sa a mwen plante nan tè tankou bòn lan va sèvi kay pou Bondye. m'a ba ou yon dizyèm nan tout sa ou va ban mwen. ");
INSERT INTO hat_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakòb pran mache ankò, li ale nan direksyon peyi moun ki rete bò kote solèy leve a. ");
INSERT INTO hat_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Li rete konsa, li wè yon pi nan mitan savann lan. Te gen twa bann mouton ki te kouche bò pi a. Se nan pi sa a yo te konn pran dlo pou bay bèt yo bwè. Men te gen yon gwo wòch ki te bouche bouch pi a. ");
INSERT INTO hat_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Lè tout bèt yo te sanble, gadò yo te met ansanm pou wete wòch la sou bouch pi a pou fè bèt yo bwè. Apre sa, yo tounen met kouvèti a sou bouch pi a ankò. ");
INSERT INTO hat_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakòb mande gadò mouton yo konsa: -Zanmi m' yo, moun ki bò nou ye? Yo reponn li: -Nou se moun Karan. ");
INSERT INTO hat_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Li di yo: -Eske nou konnen Laban, pitit Nakò a? Yo reponn li: -Men wi, nou konnen l'. ");
INSERT INTO hat_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Li mande yo: -Ban m' nouvèl li non. Li byen? Yo reponn li: -Li byen wi. Gade, men Rachèl, pitit fi li a, k'ap vini ak bann mouton li yo. ");
INSERT INTO hat_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jakòb di yo: -Men, solèy la byen wo toujou, se poko lè pou nou antre mouton yo. Sak fè nou pa bay yo bwè, epi nou ta tounen mete yo nan manje? ");
INSERT INTO hat_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Yo reponn li: -Nou pa ka fè sa. Fòk nou tann tout bann mouton yo sanble. Atòkile, nou tout n'a met men ansanm pou n' woule wòch ki sou bouch pi a. Se lè sa a n'a bay mouton yo bwè. ");
INSERT INTO hat_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jakòb t'ap pale ak yo toujou lè Rachèl vin rive ak bann mouton papa l' yo. Se li menm ki te gade mouton l' yo pou li. ");
INSERT INTO hat_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kou Jakòb wè Rachèl, pitit fi Laban, frè manman l' lan, avèk bann mouton Laban yo, li pwoche, li woule wòch ki te sou bouch pi a, li bay bann mouton Laban yo bwè. ");
INSERT INTO hat_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Lè l' fini, li bo Rachèl. Apre sa, li pran kriye. ");
INSERT INTO hat_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jakòb fè Rachèl konnen se ti fanmi Laban li ye, pitit Rebeka, sè Laban an. Rachèl kouri al di papa l' sa. ");
INSERT INTO hat_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lè Laban tande se pitit sè li a, li kouri al jwenn li. Li pran l', li pase men nan kou l', li bo l', epi li mennen l' lakay li. Rive yo rive Jakòb rakonte l' tout sak te pase. ");
INSERT INTO hat_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lè sa a, Laban di l': -Aa wi, se ras mwen ou ye vre. Jakòb rete pase yon mwa lakay Laban. ");
INSERT INTO hat_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban mande Jakòb: -Ou se fanmi m', se vre. Men, sa pa vle di fòk ou sevi m' gratis pou sa. Di m' konbe pou m' peye ou? ");
INSERT INTO hat_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban te gen de pitit fi. Pi gran an te rele Leya, pi piti a te rele Rachèl. ");
INSERT INTO hat_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leya te gen je pichpich, men Rachèl te gen bèl fòm kò, li te bèl anpil. ");
INSERT INTO hat_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakòb te renmen Rachèl. Li reponn Laban: M'ap sèvi avè ou sèt lanne pou Rachèl, dezyèm pitit fi ou la. ");
INSERT INTO hat_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban di l': Pito se ou menm mwen bay li pase m' bay yon lòt moun li. Ou mèt rete lakay mwen. ");
INSERT INTO hat_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Se konsa Jakòb pase sètan ap travay kay Laban pou l' te ka marye ak Rachèl. Sèt lanne yo te pase tankou dlo, paske li te renmen ti fi a. ");
INSERT INTO hat_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Lè lè a rive, Jakòb di Laban: -Bon. Li lè atò pou ou ban m' pitit fi ou la pou m' ka marye avè l'. ");
INSERT INTO hat_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Se konsa Laban fè yon gwo resepsyon nòs, li envite tout moun nan kanton an. ");
INSERT INTO hat_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Men aswè, li te pran Leya, pitit fi li a, li mennen l' bay Jakòb ki kouche avè l'. ");
INSERT INTO hat_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban te pran Zilpa, yonn nan sèvant li yo, li bay Leya pou sèvant pa li. ");
INSERT INTO hat_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Nan denmen maten, Jakòb vin wè se Leya yo te ba li. Li di Laban: -Kisa ou fè m' konsa? Eske se pa pou Rachèl mwen te sèvi avèk ou? Poukisa ou ban m' koutba sa a? ");
INSERT INTO hat_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban di l': -Se pa koutim nou isit pou n' marye ti sè anvan gran sè. ");
INSERT INTO hat_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tann senmenn lan fin pase. Lè sa a, n'a fin fete nòs la. Apre sa, m'a ba ou Rachèl, si ou dakò pou sèvi avè m' pandan sèt lòt lanne ankò. ");
INSERT INTO hat_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakòb tonbe dakò. Lè senmenn fèt la fin pase, Laban pran lòt pitit fi l' la, Rachèl, li bay Jakòb li pou madanm tou. ");
INSERT INTO hat_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban pran Bila, yonn nan sèvant li yo, li bay Rachèl li pou sèvant li. ");
INSERT INTO hat_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jakòb kouche ak Rachèl. Li te renmen l' pi plis pase Leya. Li sèvi ak Laban pandan sèt lanne ankò. ");
INSERT INTO hat_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Lè Seyè a wè jan Jakòb pa t' renmen Leya, li fè l' fè pitit. Men, Rachèl pa t' kapab fè pitit. ");
INSERT INTO hat_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leya vin ansent, li fè yon pitit gason, li di: -Seyè a wè jan m'ap soufri. Koulye a, mari m' va renmen m'. Se konsa li rele l' Woubenn. ");
INSERT INTO hat_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Leya vin ansent ankò, li fè yon lòt gason. Li di: -Seyè a ban m' yon lòt gason ankò, paske li wè jan mari m' pa renmen m' menm. Se konsa li rele l' Simeyon. ");
INSERT INTO hat_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Li vin ansent yon twazyèm fwa, li fè yon lòt pitit gason ankò. Li di: -Fwa sa a, mari m' pral rete avè m' nèt paske mwen fè twa pitit gason pou li. Se konsa li rele l' Levi. ");
INSERT INTO hat_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Apre sa, li vin ansent ankò, li fè yon lòt pitit gason. Li di: -Fwa sa a, m'ap fè lwanj Seyè a. Se konsa li rele l' Jida. Apre sa, Leya sispann fè pitit. ");
INSERT INTO hat_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lè Rachèl wè li pa t' kapab fè pitit pou Jakòb, li vin gen yon sèl jalouzi kont sè li a, li di Jakòb: -Fè m' fè pitit! Si se pa sa m'ap mouri sou kont ou! ");
INSERT INTO hat_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakòb fè kòlè sou Rachèl, li di li: -Eske se mwen ki Bondye? Se li menm ki anpeche ou fè pitit. ");
INSERT INTO hat_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachèl di li: -Bon. Men Bila, sèvant mwen an. Kouche avè l'. La fè yon pitit pou mwen. Konsa, gremesi Bila, m'a gen pitit tou. ");
INSERT INTO hat_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Se konsa, Rachèl te pran sèvant li a, li bay Jakòb pou madanm. Jakòb kouche ak Bila. ");
INSERT INTO hat_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bila vin ansent, li fè yon ti gason pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Lè sa a, Rachèl di: -Seyè a rann mwen jistis. Li tande vwa mwen. Li ban m' yon gason. Se poutèt sa Rachèl te rele pitit la Dann. ");
INSERT INTO hat_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Apre sa, Bila, sèvant Rachèl la, vin ansent ankò, li fè yon dezyèm gason pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachèl di: -Mwen t'ap mennen yon gwo batay kont sè m' lan devan Bondye. Men se mwen ki genyen. Se konsa li rele pitit la Nèftali. ");
INSERT INTO hat_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Lè Leya wè li te sispann fè pitit, li pran Zilpa, sèvant li a, bay Jakòb pou madanm tou. ");
INSERT INTO hat_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, sèvant Leya a, fè yon ti gason pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya di: -Ala fanm gen chans se mwen menm! Se konsa li rele pitit la Gad. ");
INSERT INTO hat_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, sèvant Lea a, fè yon dezyèm pitit gason pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya di konsa: -Ala benediksyon mwen jwenn! Koulye a medam yo pral di jan mwen se yon fanm ki beni. Se konsa li rele pitit la Asè. ");
INSERT INTO hat_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pandan rekòt ble a, Woubenn soti al nan jaden, li jwenn kèk mandragò. Li pote rasen yo bay Leya, manman li. Rachèl di Leya konsa: -Tanpri, ban m' kèk moso rasen mandragò pitit ou pote pou ou a. ");
INSERT INTO hat_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leya reponn li: -Atò ou pa fè m' ase? Ou fin pran mari m', koulye a ou vle pran mandragò pitit gason m' lan tou? Rachèl di l': -Enben, Jakòb va kouche avè ou aswè a pou mandragò pitit gason ou lan. ");
INSERT INTO hat_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Nan aswè, lè Jakòb parèt sot nan jaden, Leya soti al kontre l', li di l' konsa: -Se pou ou vin kouche avè m' aswè a, paske mwen bay mandragò pitit gason m' lan pou sa. Se konsa, jou swa sa a, Jakòb kouche avèk Leya. ");
INSERT INTO hat_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Bondye reponn lapriyè Leya a. Li vin ansent, epi li fè yon senkyèm pitit gason pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya di: -Bondye ban m' sa m' merite a, paske mwen te bay mari m' sèvant mwen an pou madanm. Se konsa, Leya rele pitit gason an Isaka. ");
INSERT INTO hat_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leya vin ansent ankò, li fè yon sizyèm pitit gason pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leya di: -Bondye fè m' yon bèl kado. Fwa sa a, mari m' pral pou mwen nèt, paske mwen fè sis pitit gason pou li. Se konsa li rele pitit la Zabilon. ");
INSERT INTO hat_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Apre sa, li fè yon pitit fi. Li rele l' Dena. ");
INSERT INTO hat_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Lè sa a, Bondye vin chonje Rachèl, li reponn lapriyè li, li fè l' ka fè pitit. ");
INSERT INTO hat_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Se konsa Rachèl vin ansent, li fè yon pitit gason. Li di: -Bondye fè yo sispann pase m' nan rizib. ");
INSERT INTO hat_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Epi Rachèl rele pitit gason an Jozèf, paske li te di: -Se pou Seyè a ba m' yon lòt gason ankò. ");
INSERT INTO hat_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Apre Rachèl te fè Jozèf, Jakòb di Laban konsa: -Kite m' pati pou m ale lakay mwen nan peyi mwen. ");
INSERT INTO hat_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ban mwen madanm mwen yo ansanm ak timoun yo pou m' ka ale, paske se pou yo mwen t'ap sèvi ak ou. Ou konnen tout kantite sèvis mwen rann ou. ");
INSERT INTO hat_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban reponn li: -Fè m' plezi sa a: mwen rekonèt se poutèt ou Seyè a beni m' tout beni sa a. ");
INSERT INTO hat_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Di m' sa pou m' peye ou, m'a ba ou li. ");
INSERT INTO hat_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakòb di l': -Ou konnen jan mwen sèvi avè ou. Ou wè ki jan bann bèt ou yo peple depi yo nan men m'. ");
INSERT INTO hat_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ti sa ou te genyen anvan m' te vini an tounen yon kantite depi mwen mete pye m' isit la. Akòz mwen Seyè a pa manke beni ou. Alekile, li lè pou m' al travay pou tèt pa mwen. ");
INSERT INTO hat_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban di l': -Kisa pou m' ba ou? Jakòb reponn li: -Ou pa bezwen peye m' pou sa. Men si ou dakò avèk sa mwen pral di ou la, m'a rete ankò pou okipe bèt ou yo. ");
INSERT INTO hat_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jòdi a, mwen pral pwonmennen mache nan mitan tout bèt ou yo. M'ap pran tout ti mouton nwa, ak tout ti kabrit ki takte osinon pentle yo, m'ap mete yo apa. Se sa ase w'a ban mwen pou sèvis mwen. ");
INSERT INTO hat_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Lè w'a vin wè sa ou dakò ban mwen an, w'a konnen si m' te fè vis, wi ou non. Lè w'a vin kontwole sa ki pou mwen yo, si mwen gen yon mouton ki pa nwa, osinon yon kabrit ki pa takte ou ki pa pentle, ou mèt konnen se vòlè mwen vòlè ou. ");
INSERT INTO hat_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban reponn li: -Dakò. n'a fè l' jan ou di l' la. ");
INSERT INTO hat_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Men menm jou a, Laban wete tout bouk kabrit ki te gen pwal takte osinon ki te gen re sou tout kò yo, ak tout fenmèl kabrit ki te gen pwal takte osinon pentle, ou ankò ki te gen tach blan sou yo. Li wete tout mouton nwa yo, li pran tout bèt sa yo, li renmèt yo bay pitit gason l' yo. ");
INSERT INTO hat_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Apre sa, li pati byen lwen Jakòb avèk bann bèt li yo, li mache pandan twa jou epi li rete. Jakòb menm te pran swen rès mouton ak kabrit Laban yo. ");
INSERT INTO hat_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakòb koupe kèk branch vèt nan pye sikren, pye zanmann ak pye bwadòm, li wete kèk lèz nan kòs yo. Konsa branch yo te vin gen bann vèt, bann blan sou tout kò yo. ");
INSERT INTO hat_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Li pran yo, li mete yo tout kote yo bay bèt yo bwè dlo. Li te ranje branch bwa yo la, paske se lè bèt yo vin bwè dlo yo kwaze. ");
INSERT INTO hat_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Konsa, lè bèt yo kwaze devan branch bwa de koulè yo, yo fè pitit takte, pitit pentle, osinon ak re sou tout kò yo. ");
INSERT INTO hat_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jakòb separe mouton yo, li pran tout mouton ki te takte osinon ki te nwa nan mouton Laban yo, li mete yo apa. Se konsa, li te vin gen yon bann bèt apa ki pa t' mele ak bèt Laban yo. ");
INSERT INTO hat_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Lè bèt ki gra yo ap kwaze, Jakòb mete branch yo devan je yo kote y'ap bwè a. Konsa, yo kwaze devan branch yo. ");
INSERT INTO hat_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Men, li pa mete branch yo lè se bèt mèg yo k'ap kwaze. Se konsa, bèt mèg yo vin pou Laban, epi bèt gra yo vin pou Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Jakòb vin rich anpil, Li te gen anpil bèt. Kanta pou sèvant, domestik, chamo ak bourik, li pa t' manke sa. ");
INSERT INTO hat_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jakòb vin konnen jan pitit gason Laban yo t'ap di: -Jakòb fin pran tou sa ki te pou papa nou. Se byen papa nou li fin ranmase kifè li rich konsa. ");
INSERT INTO hat_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakòb vin wè tout Laban pa t' ba li menm karaktè li te konn ba li anvan an. ");
INSERT INTO hat_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Lè sa a, Seyè a di l': -Tounen nan peyi kote ou te fèt la, al jwenn fanmi ou. M'ap toujou la avè ou. ");
INSERT INTO hat_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Se konsa Jakòb fè chache Rachèl ak Leya. Li voye di yo rive kote l' nan savann kote bèt li yo ye a. ");
INSERT INTO hat_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Li di yo: -Mwen wè karaktè papa nou pa menm jan avè m' ankò. Li chanje anpil, men Bondye papa m' lan toujou avè m'. ");
INSERT INTO hat_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nou tout de nou konnen jan mwen te sèvi ak papa nou ak tout kouraj mwen. ");
INSERT INTO hat_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Men li menm, li toujou ap twonpe mwen. Li chanje lide dis fwa lè lè a rive pou li peye m'. Men, Bondye pa janm kite l' fè m' anyen. ");
INSERT INTO hat_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Lè Laban di: ou mèt pran tout kabrit takte yo pou ou, tout bann bèt yo tonbe fè pitit takte. Lè li di: m'ap ba ou tout kabrit ki gen re sou tout kò yo, tout bann bèt yo tonbe fè pitit ak re sou tout kò yo. ");
INSERT INTO hat_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Se Bondye menm ki pran bann bèt papa nou yo, li ban mwen yo. ");
INSERT INTO hat_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Lè bèt yo mande kwaze, mwen fè yon rèv, mwen wè tout bouk ki t'ap kwaze yo se bouk ki takte, ki pentle ak sa ki gen re sou tout kò yo. ");
INSERT INTO hat_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Zanj Bondye a pale avè m' nan rèv la, li di m': Jakòb. Mwen reponn li: Men mwen wi. ");
INSERT INTO hat_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Li di m' ankò: Leve je ou gade: tout bouk k'ap vole fenmèl yo se bouk ki takte ak sa ki gen re sou tout kò yo. Se mwen menm k'ap fè sa konsa, paske mwen wè tout sa Laban ap fè ou. ");
INSERT INTO hat_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Mwen se Bondye ki te parèt devan ou lè ou te Betèl, kote ou te mete gwo wòch la apa pou mwen an. Ou chonje, lè sa a, ou te fè yon pwomès ban mwen. Koulye a, leve, kite peyi sa a. Tounen nan peyi kote ou te fèt la. ");
INSERT INTO hat_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachèl ak Leya reponn Jakòb: -Nou pa gen anyen ankò pou n' eritye nan men papa nou. ");
INSERT INTO hat_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Eske li pa konsidere nou tankou etranje? Li vann nou. Koulye a, li fin manje tout lajan yo te ba li pou nou an. ");
INSERT INTO hat_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tout richès Bondye wete nan men papa nou an, se pou nou ansanm ak pitit nou yo. Koulye a, se pou ou fè tout sa Bondye di ou fè. ");
INSERT INTO hat_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Lè sa a, Jakòb leve, li mete pitit li yo ansanm ak madanm li yo sou chamo. ");
INSERT INTO hat_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Li pran tout bèt li yo ansanm ak tout sa li te rive genyen pandan li te Mezopotami an, li mennen yo ale. Li pati, li al jwenn papa l', Izarak, nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lè sa a, Laban t al taye lenn mouton l' yo. Pandan li pa t' la, Rachèl vòlè ti zidòl kay papa l' yo. ");
INSERT INTO hat_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Se konsa Jakòb twonpe Laban, moun lavil Aram lan, li pati san l' pa di l' sa. ");
INSERT INTO hat_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Li pran tout sa li te genyen, li mete deyò, li ale, li travèse larivyè Lefrat, li pran chemen pou li al sou mòn Galarad. ");
INSERT INTO hat_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Twa jou apre, Laban pran nouvèl Jakòb te pati. ");
INSERT INTO hat_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Msye pran moun pa li yo avè l', li pati dèyè Jakòb. Apre sèt jou, li jwenn li sou mòn Galarad. ");
INSERT INTO hat_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Men, pandan lannwit, Bondye parèt devan Laban, moun lavil Aram lan, nan yon rèv, li di l': -Piga ou di Jakòb anyen ni an byen, ni an mal. ");
INSERT INTO hat_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Se konsa, Laban jwenn Jakòb ki te moute tant li sou mòn lan. Laban te moute tant li tout sou mòn Galarad pou li menm ansanm ak moun pa l' yo. ");
INSERT INTO hat_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban di Jakòb: -Kisa ou fè konsa? Ou twonpe m', ou pran pitit fi mwen yo, ou mennen yo ale tankou prizonye ou fè nan lagè. ");
INSERT INTO hat_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Poukisa ou twonpe m', ou leve ou pati an kachèt san ou pa avèti m'? Si ou te di m' sa, nou ta fè fèt, nou ta chante, nou ta bat tanbou, nou ta jwe gita anvan nou voye ou ale. ");
INSERT INTO hat_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ou pa menm kite m' bo pitit pitit mwen yo ak pitit fi m' yo. Ou aji tankou moun fou, monchè! ");
INSERT INTO hat_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mwen gen kont pouvwa anba men m' pou m' ta regle ou. Men yè swa, pandan lannwit lan Bondye papa ou la di m': Piga ou di Jakòb anyen ni an byen, ni an mal. ");
INSERT INTO hat_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Mwen konnen ou pati paske se pa ti anvi ou pa te anvi tounen lakay papa ou. Men, sa ou te bezwen vòlè ti zidòl kay mwen yo fè? ");
INSERT INTO hat_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakòb reponn Laban, li di l': -Mwen te pè, paske mwen te kwè ou ta ka reprann pitit fi ou yo nan menm. ");
INSERT INTO hat_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Men, kanta pou ti zidòl kay ou yo, si ou jwenn yo nan men yon moun isit la, se pou moun sa a mouri. Men, mwen pran tout moun sa yo pou temwen, si ou jwenn yon bagay lakay mwen ki pou ou, pran l' pote l' ale. Jakòb pa t' konnen Rachèl te vòlè ti zidòl kay yo. ");
INSERT INTO hat_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban antre anba tant Jakòb la, li chache, li ale anba tant Leya a, apre sa anba tant de sèvant yo, li pa jwenn anyen. Li soti anba tant Leya a, li antre anba tant Rachèl. la. ");
INSERT INTO hat_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachèl menm te pran ti zidòl kay yo, li te mete yo anba aparèy chamo a, epi li chita sou yo. Laban menm chache tout anba tant lan, li pa jwenn anyen. ");
INSERT INTO hat_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachèl di papa l' konsa: -Si ou wè mwen pa ka leve kanpe devan ou, ou pa bezwen fache non. Se lalen mwen mwen genyen. Se konsa Laban fouye toupatou, li pa jwenn ti zidòl kay li yo. ");
INSERT INTO hat_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Lè sa a, Jakòb move sou Laban. Li pete yon kabouyay ak li, li di l': -Ki krim mwen fè? Kisa m' fè ki mal pou w'ap pousib mwen konsa? ");
INSERT INTO hat_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ou fin fouye tout zafè m' yo. Kisa ou jwenn ki pou ou? Mete l' la devan moun pa ou yo ak moun pa m' yo, pou yo ka di ki moun ki gen rezon! ");
INSERT INTO hat_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Sa fè ventan depi m avè ou. Mouton ou yo ak kabrit ou yo pa janm manke fè pitit. Mwen pa janm manje yon ti bouk nan bèt ou yo. ");
INSERT INTO hat_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Lè bèt nan bwa touye yon mouton, mwen pa janm pote l' ba ou. Mwen te pran pèt la sou kont mwen. Ou te rann mwen reskonsab tout bèt yo vòlè, kit se lannwit, kit se lajounen. ");
INSERT INTO hat_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Lajounen, chalè te fini avè m'. Lannwit, se te fredi, mwen pa t' kapab dòmi. ");
INSERT INTO hat_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Se konsa sa te ye pandan tout ventan mwen pase lakay ou yo. Mwen travay pandan katòzan pou de pitit fi ou yo. Apre sa, mwen fè sizan ankò ap travay pou bann bèt ou yo. Atousa, ou jwenn mwayen chanje pawòl dis fwa lè lè a rive pou ou peye m'. ");
INSERT INTO hat_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si Bondye papa m' lan, Bondye Abraram lan, Bondye Izarak respekte a, pa t' la avèk mwen, koulye a ou ta voye m' ale yon men devan yon men dèyè. Men Bondye wè tout traka mwen bay tèt mwen, li wè travay mwen fè, se konsa yè swa li rann jijman li. ");
INSERT INTO hat_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban reponn Jakòb: -Fi sa yo se pitit mwen yo ye. Timoun sa yo, se pa m' yo ye. Bann bèt sa yo se pou mwen yo ye. tout sa ou wè la a, se pou mwen yo ye. Bon, kisa m' ka fè koulye a pou pitit fi mwen yo ak pou pitit pitit mwen yo? ");
INSERT INTO hat_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Vini non. Annou pase yon kontra, mwen menm avè ou. Ann kite yon mak ki va sèvi pou fè nou toujou chonje kontra a. ");
INSERT INTO hat_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jakòb pran yon gwo wòch, li plante l' nan tè a, li fè l' rete kanpe tankou yon bòn. ");
INSERT INTO hat_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Epi, li di moun li yo: -Ranmase wòch. Mesye yo ranmase wòch, yo anpile yo fè yon gwo pil. Apre sa, yo chita bò pil wòch la, yo manje. ");
INSERT INTO hat_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban rele pil wòch la Jega Saadouta nan lang pa l', men Jakòb te rele l' nan lang pa l' Galèd. ");
INSERT INTO hat_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban di: -Pil wòch sa a va sèvi pou fè nou tout de toujou chonje kontra a. Se poutèt sa yo rele kote sa a Galèd. ");
INSERT INTO hat_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laban di ankò: -Se pou Bondye voye je sou nou tout de lè nou fin separe. Se konsa yo rele kote sa a Mispa. ");
INSERT INTO hat_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban pale ankò, li di: -Si ou maltrete pitit fi mwen yo, si ou pran lòt fanm ankò sou yo, konnen ou p'ap annafè ak yon moun tankou nou tande. Atansyon, men se ak Bondye menm, ki temwen sa nou sot fè a, w'ap annafè. ");
INSERT INTO hat_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban di Jakòb ankò: -Men pil wòch mwen mete pou separe nou an. Men bòn ou plante a la. ");
INSERT INTO hat_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ni pil wòch yo ni bòn lan ap sèvi yon mak. Mwen pa gen dwa depase l' pou m' vin atake ou, ni ou pa gen dwa depase l' pou ou vin atake m'. ");
INSERT INTO hat_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Se pou Bondye Abraram lan, Bondye Nakò a, Bondye papa yo a, mete rezon nan mitan nou. Lè sa a, Jakòb sèmante nan non Bondye Izarak, papa l' respekte a. ");
INSERT INTO hat_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Apre sa, li touye yon bèt, li ofri l' bay Bondye sou mòn lan, epi li envite moun pa l' yo vin manje. Lè yo fin manje, yo pase nwit la sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Nan denmen maten byen bonè, Laban leve, li bo pitit pitit li yo ak pitit fi li yo. Li beni yo. Apre sa, li pati, li tounen lakay li. ");
INSERT INTO hat_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakòb menm ale chemen chemen l'. Li kontre kèk zanj Bondye sou wout li. ");
INSERT INTO hat_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Lè li wè yo, li di: -Sa se lame Bondye a. Se konsa li rele kote a Manayim. ");
INSERT INTO hat_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakòb voye kèk komisyonè devan al jwenn Ezaou, frè li a, nan peyi Seyi, kote Edon te rete a. ");
INSERT INTO hat_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Men sa li ba yo lòd pou yo di: -Men sa n'a di Ezaou, mèt mwen: Jakòb, nèg pa ou la, voye di ou konsa, li te pase tout tan sa a lakay Laban. Se poutèt sa li te pran tout reta sa a pou l' tounen. ");
INSERT INTO hat_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Li gen bèf, bourik, mouton, kabrit, domestik ak sèvant. Li voye di ou sa pou ou ka fè pa l'. ");
INSERT INTO hat_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Lè mesaje yo tounen vin jwenn Jakòb, yo di l': -Nou t ale kote Ezaou, frè ou la. Koulye a li gen tan sou wout pou l' vin kontre ou. Li gen katsan (0400) moun ak li. ");
INSERT INTO hat_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jakòb te pè anpil. Li te boulvèse. Li pran moun ki te avè l' yo, li fè yo fè de pòsyon. Li fè menm bagay la ak mouton, bèf, chamo li te genyen yo. ");
INSERT INTO hat_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Li t'ap di nan kè l': -Si Ezaou vin atake yon pòsyon, lòt pòsyon an va gen tan chape. ");
INSERT INTO hat_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jakòb lapriyè, li di: -O Bondye Abraram granpapa m' lan, Bondye Izarak papa m' lan! O Seyè, ou menm ki te di m' tounen nan peyi m' kote m' te fèt la! W'a fè tout bagay mache byen pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mwen menm k'ap sèvi ou la, mwen pa wè poukisa ou fè m' tout favè sa yo, poukisa ou toujou kenbe pawòl ou avè m'. Lè m' t'ap travèse larivyè Jouden, se annik yon baton mwen te gen nan men m'. Koulye a m'ap tounen, mwen tèlman genyen, mwen ka separe yo fè de pòsyon. ");
INSERT INTO hat_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tanpri, delivre m' non anba men Ezaou, frè mwen an! Mwen pè pou l' pa vin atake nou, pou l' pa touye ata fanm yo ak timoun yo. ");
INSERT INTO hat_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Chonje sa ou te di m' lan: M'ap fè tout bagay mache byen pou ou. M'ap si tèlman ba ou pitit pitit, moun p'ap ka konte yo. Y'ap tankou grenn sab bò lanmè. ");
INSERT INTO hat_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jakòb rete pase nwit la kote l' te ye a. Apre sa, nan sa l' te gen avè l' yo, li chwazi ladan yo pou fè Ezaou, frè l' la, kado. ");
INSERT INTO hat_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Li pran desan (0200) fenmèl kabrit ak vin bouk, desan fenmèl mouton ak vin belye, ");
INSERT INTO hat_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trant fenmèl chamo nouris ak tout ti chamo yo dèyè yo, karant manman bèf, dis towo, vin fenmèl bourik ak dis mal bourik. ");
INSERT INTO hat_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Li pran bèt yo, li mete chak kalite apa, li renmèt chak kalite bay yonn nan domestik li yo. Li di yo konsa: -Pran devan mwen. Chak moun ap kite yon distans nan mitan bèt pa l' yo ak bèt ki devan l' yo. ");
INSERT INTO hat_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Epi li pase premye a lòd sa a: -Lè Ezaou, frè m' lan, va kontre ou, l'ap mande ou: Kilès ki mèt ou? Kote ou prale? Pou ki moun bèt sa yo w'ap pouse devan ou konsa a? ");
INSERT INTO hat_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","W'a reponn li: Se pou Jakòb, nèg pa ou la. Se yon kado li voye bay Ezaou, mèt mwen an. Li menm, li dèyè, l'ap vini. ");
INSERT INTO hat_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Li pase dezyèm lan, twazyèm lan ak tout lòt moun ki t'ap mache dèyè bèt yo menm lòd la. -Men sa nou gen pou n' di Ezaou, lè nou kontre l'. ");
INSERT INTO hat_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Se pou nou di: Wi, Jakòb, nèg pa ou la, ap vin dèyè nou pye pou pye. Jakòb t'ap di nan kè l'. Avèk tout kado m'ap voye devan m' lan, m'ap fè kè l' kontan. Konsa, lè n'a kontre, ou pa janm konnen, li ka fè pa m'. ");
INSERT INTO hat_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Moun yo pran devan ak kado yo. Men Jakòb rete dèyè, li pase nwit la kote l' te ye a. ");
INSERT INTO hat_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Menm jou lannwit sa a, Jakòb leve, li pran de madanm li yo, de sèvant li yo ak onz pitit gason li yo, li janbe lòt bò larivyè Jabòk, nan pas la. ");
INSERT INTO hat_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Apre li fin fè yo janbe larivyè a, li fè janbe tout sa li te genyen tou. ");
INSERT INTO hat_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Men li menm, li te rete pou kont li dèyè. Lè sa a, gen yon moun ki mare batay ak li, yo goumen jouk devanjou. ");
INSERT INTO hat_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Lè nonm lan wè li pa t' ka bat li, li bay Jakòb yon kou nan ren l'. Se konsa zo ren l' dejwente pandan yo t'ap goumen an. ");
INSERT INTO hat_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Nonm lan di l': -Kite m' ale, paske bajou pral kase. Jakòb reponn li: -Si ou pa beni mwen, mwen p'ap kite ou ale. ");
INSERT INTO hat_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Nonm lan di: -Ki jan ou rele? Li reponn: -Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Nonm lan di l': -Yo p'ap rele ou Jakòb ankò. Y'ap rele ou Izrayèl, paske ou goumen ak Bondye, ou goumen ak moun, se ou menm ki genyen batay la. ");
INSERT INTO hat_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakòb mande l': -Tanpri, di m' ki jan ou rele? Li reponn: -Poukisa w'ap mande m' ki jan mwen rele? Apre sa li beni Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jakòb di konsa: -Mwen wè Bondye, mwen pa mouri. Se konsa, li rele kote l' te ye a Penyèl. ");
INSERT INTO hat_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Solèy te gen tan ap leve lè Jakòb kite Penyèl, li t'ap bwete poutèt ren li. ");
INSERT INTO hat_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Se poutèt sa, jouk jòdi a, pitit pitit Izrayèl yo pa manje venn ki kenbe zo ren an, paske se sou venn sa a Bondye te frape Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jakòb leve je l' gade, li wè Ezaou ki t'ap mache vin jwenn li avèk katsan moun dèyè li. Li pran timoun yo, li separe yo, li bay Leya pa l' yo, li bay Rachèl pa l' yo, li bay de sèvant yo pa yo. ");
INSERT INTO hat_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Li mete de sèvant yo devan nèt ak pitit yo, Leya ak pitit li yo nan mitan, Rachèl ak Jozèf dèyè nèt. ");
INSERT INTO hat_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Li menm, li pran mache devan yo tout. Li bese tèt li jouk atè pandan sèt fwa, jouk li rive toupre Ezaou, frè li a. ");
INSERT INTO hat_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ezaou menm kouri al kontre l', li pase bra l' nan kou l', li bat do l', li bo li. Epi yo tout de yo pran kriye. ");
INSERT INTO hat_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Lè Ezaou voye je l' gade, li wè medam yo ak timoun yo. Li di: -Ki moun sa yo ki avè ou la a? Jakòb reponn li: -tout se pitit Seyè a bay nèg pa ou la. ");
INSERT INTO hat_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Lè sa a, sèvant yo pwoche ak timoun yo, yo bese tèt yo jouk atè devan Ezaou. ");
INSERT INTO hat_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Apre sa, Leya pwoche ak timoun pa l' yo, yo bese tèt yo tout devan li. Andènye nèt, Jozèf ak Rachèl pwoche, yo bese tèt yo tout devan li. ");
INSERT INTO hat_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ezaou mande l': -Moun mwen kontre pi devan an, poukisa ou te voye yo? Jakòb reponn li: -Se pou m' te ka fè kè ou kontan. ");
INSERT INTO hat_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ezaou di l': -Frè mwen, mwen gen tout sa m' bezwen. Ou mèt kenbe tou sa ou genyen pou ou. ");
INSERT INTO hat_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakòb reponn li: -Non. Si ou kontan wè m' tout bon, tanpri, asepte kado m'ap ba ou yo. Paske, lè mwen kontre ou, se tankou si m' te wè figi Bondye. Gade jan ou resevwa m' byen. ");
INSERT INTO hat_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tanpri, asepte kado m'ap ba ou yo, paske Bondye te beni m' anpil. Mwen pa manke anyen. Jakòb fòse Ezaou sitèlman, bout pou bout, Ezaou asepte. ");
INSERT INTO hat_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Li di: -Bon. Ann pati. Ann ale. M'ap pran devan ou. ");
INSERT INTO hat_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Men Jakòb reponn li: -Mèt mwen, ou konnen jan timoun yo fèb. Epi, fòk mwen pa bliye fenmèl mouton ak manman bèf yo ki nouris. Si m' fè yo mache twòp yon sèl jou, se kont pou yo tout mouri. ");
INSERT INTO hat_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tanpri, mèt mwen, ou mèt pran devan nèg pa ou la, mwen menm m'ap vin dèyè ti pa ti pa, jan bèt yo ak timoun yo ka mache, jouk m'a rive lakay ou nan peyi Seyi. ");
INSERT INTO hat_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ezaou di l': -Bon. m'a kite kèk moun nan moun pa m' yo avè ou? Jakòb reponn: -Se pa nesesè. Yon sèl bagay mwen mande, se pou mèt mwen bliye tout bagay. ");
INSERT INTO hat_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Menm jou a, Ezaou pati tounen nan peyi Seyi. ");
INSERT INTO hat_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakòb menm pati pou Soukòt. Lè li rive la, li bati yon kay pou li ak yon pak pou bèt li yo. Se sak fè yo rele kote sa a Soukòt. ");
INSERT INTO hat_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Lè Jakòb tounen soti Mezopotami, li rive anbyen lavil Sichèm, nan peyi Kanaran. Li moute tant li sou moso tè ki anfas lavil la. ");
INSERT INTO hat_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Li achte moso tè kote li te moute tant li a pou san (0100) pyès lajan nan men pitit Amò yo. Se Amò sa a ki te papa Sichèm. ");
INSERT INTO hat_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Jakòb bati yon lotèl la tou. Li rele l': Bondye se Bondye Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dena, pitit fi Leya te fè pou Jakòb la, te soti al rann medam peyi a vizit. ");
INSERT INTO hat_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Lè sa a, Sichèm, pitit Amò, moun Evi a, te chèf nan kanton an. Lè li wè Dena, li mete men sou li, li fè kadejak sou li. ");
INSERT INTO hat_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Men Sichèm te tonbe damou pou Dena, pitit fi Jakòb la. Li te pale dous ak tifi a, paske li te renmen l'. ");
INSERT INTO hat_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sichèm di Amò, papa l': -Al mande pou fi sa a pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakòb vin konnen Sichèm te fè kadejak sou Dena, pitit fi li a. Men, paske pitit gason l' yo te nan savann ak bèt yo, li pa di anyen jouk lè yo tounen. ");
INSERT INTO hat_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Amò, papa Sichèm, ale bò kot Jakòb pou fè yon pale sou sa avè l'. ");
INSERT INTO hat_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Lè sa a, pitit gason Jakòb yo t'ap tounen soti nan savann. Lè yo pran nouvèl la, yo te move, yo te fache anpil, paske Sichèm te fè yon bagay grav: li te avili moun Izrayèl yo lè l' te fè kadejak sou pitit fi Jakòb la. Bagay konsa pa t' dwe fèt. ");
INSERT INTO hat_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Amò di yo konsa: -Pitit gason m' lan, Sichèm, fin fou pou fi nou an. Tanpri, kite li marye avè l'. ");
INSERT INTO hat_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ann pase kontra yonn ak lòt pou nou zanmi. n'a ban nou nan pitit fi nou yo pou madanm pitit gason nou yo. n'a pran nan pitit fi nou yo pou madanm pitit gason nou yo. ");
INSERT INTO hat_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Konsa n'a rete ansanm ak nou nan peyi a. n'a rete kote nou vle, n'a fè kòmès jan nou vle, n'a achte tè nou vle. ");
INSERT INTO hat_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Apre sa, Sichèm di papa ak frè Dena yo: -Fè m' favè sa a, tanpri. m'a ban nou tout sa nou vle. ");
INSERT INTO hat_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Di m' kisa pou m' fè nou kado. Nou mèt mande m' nenpòt ki gwo pri pou maryaj la. M'ap ban nou tout sa n'a mande m'. Men, se pou nou dakò. Kite m' marye ak fi a. ");
INSERT INTO hat_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Men pitit gason Jakòb yo bay Sichèm ak Amò, papa li, yon repons pou woule yo. Paske Sichèm te avili sè yo a, yo t'ap pare yon move kou pou yo. ");
INSERT INTO hat_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Yo di yo: -Nou pa ka kite sè nou an marye ak yon nonm ki pa sikonsi. Se va yon avilisman pou nou. ");
INSERT INTO hat_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","N'ap dakò nan yon sèl kondisyon. Se pou nou vin menm jan ak nou, se pou tout gason nan kanton an sikonsi tankou nou. ");
INSERT INTO hat_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Lè sa a atò, n'a kite sè nou an marye avè ou. Nou menm tout n'a ka marye ak pitit fi ou yo. n'a rete nan peyi a ansanm ansanm, n'a tounen yon sèl pèp. ");
INSERT INTO hat_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Men, si nou pa dakò ak kondisyon sa a, si nou pa vle pou yo sikonsi nou, n'ap pran sè nou an, epi nou pral fè wout nou. ");
INSERT INTO hat_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amò ak Sichèm, pitit gason l' lan, tonbe dakò ak yo pou kondisyon an. ");
INSERT INTO hat_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Se konsa jenn gason an te prese fè sa yo te mande l' fè a, paske li te renmen pitit fi Jakòb la anpil. tout moun kay papa l' te konsidere l' anpil. ");
INSERT INTO hat_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amò ak Sichèm, pitit gason l' lan, al nan pòtay lavil la, kote tout moun yo te konn reyini, yo pale ak moun peyi a. Yo di yo: ");
INSERT INTO hat_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","-Mesye sa yo, se pa moun ki vin pou kont. Ann kite yo rete nan peyi a. Ann kite yo fè trafik yo. Peyi a gen kont plas pou yo. Ann marye ak pitit fi yo, ann kite yo marye ak pitit fi nou yo. ");
INSERT INTO hat_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mesye sa yo dakò pou yo rete ansanm ak nou, pou nou fè yon sèl pèp. Men yo pase yon kondisyon: se pou tout gason nan mitan nou sikonsi, menm jan yo menm yo sikonsi a. ");
INSERT INTO hat_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Konsa, tout bèt yo, tout byen yo, tout zannimo yo ap vin pou nou yon lè. Se asepte pou n' asepte kondisyon an pou yo ka rete viv ansanm ak nou. ");
INSERT INTO hat_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","tout moun ki te reyini bò pòtay lavil la te tonbe dakò ak sa Amò ak Sichèm, pitit li a, te di yo. Se konsa yo sikonsi tout gason ki te la bò pòtay lavil la. ");
INSERT INTO hat_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Twa jou apre, mesye yo t'ap soufri ak sikonsizyon an toujou lè de nan pitit gason Jakòb yo, Simeyon ak Levi, frè menm manman ak Dena yo, pran nepe yo, yo antre nan lavil la san pesonn pa sispèk anyen, yo touye tout gason yo. ");
INSERT INTO hat_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Yo touye Amò ak Sichèm, pitit gason l' lan, yo pran Dena, yo fè l' kite kay Sichèm lan, y al fè wout yo avè l'. ");
INSERT INTO hat_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Lòt pitit Jakòb yo menm jete kò yo sou kadav yo, yo piye lavil la byen piye, paske moun lavil la te avili sè yo a. ");
INSERT INTO hat_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Apre sa, yo pran tout bèt, tout bèf, tout bourik ak tout sa ki te nan lavil la ak nan jaden yo. ");
INSERT INTO hat_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Yo pran tout richès ak tout sa ki te nan kay mesye yo pote ale, yo fè tout pitit yo ak tout medam yo prizonye. ");
INSERT INTO hat_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Apre sa, Jakòb rele Simeyon ak Levi, li di yo: -Gade nan ki traka nou mete m'. Koulye a, moun ki rete nan peyi a, moun Kanaran yo ak moun Perezi yo, pral rayi m'. Mwen pa gen anpil moun. Si yo mete ansanm sou do mwen pou atake m', y'ap touye m' ansanm ak tout moun lakay mwen. ");
INSERT INTO hat_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Men Simeyon ak Levi reponn: -Atò, se pou nou te kite yo trete sè nou an tankou nenpòt jennès! ");
INSERT INTO hat_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Bondye di Jakòb: -Leve non, moute al Betèl, epi rete la. Bati yon lotèl la pou Bondye ki te parèt devan ou lan, lè ou t'ap kouri pou Ezaou, frè ou la. ");
INSERT INTO hat_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Se konsa Jakòb rele fanmi l' yo ansanm ak tout lòt moun ki avè l' yo. li di yo: -Pran tout lòt bondye etranje n'ap sèvi yo, voye yo jete. Mete nou nan kondisyon pou sèvi Bondye. Mete rad nèt sou nou. ");
INSERT INTO hat_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nou pral kite kote nou ye a, nou pral Betèl, kote mwen pral bati yon lotèl pou Bondye ki te reponn lapriyè m' lè m' te anba tray la, pou Bondye ki te la avèk mwen kote m' pase nan vwayaj mwen te fè a. ");
INSERT INTO hat_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Se konsa yo renmèt Jakòb tout bondye etranje yo te gen nan men yo ansanm ak tout zanno yo te gen nan zòrèy yo. Jakòb antere tout sa anba pye bwadchenn ki te toupre lavil Sichèm lan. ");
INSERT INTO hat_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Apre sa, yo pati. tout moun ki te rete nan zòn lan te vin pè Bondye anpil. Yo yonn pa leve al rapouswiv pitit Jakòb yo. ");
INSERT INTO hat_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakòb rive ansanm ak tout moun ki te avè l' yo lavil Louz, nan peyi Kanaran. Se lavil sa a yo rele Betèl tou. ");
INSERT INTO hat_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Li bati yon lotèl la, li rele kote a Betèl, paske se la Bondye te parèt devan li lè li t'ap kouri pou frè l' la. ");
INSERT INTO hat_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Lè sa a, Debora, bòn Rebeka a, mouri. Yo antere l' pi ba Betèl, anba pye bwadchenn lan. Se konsa yo rele pye bwadchenn lan: chenn dlo nan je a. ");
INSERT INTO hat_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Lè Jakòb te tounen soti Mezopotami, Bondye parèt ankò devan li, li beni li. ");
INSERT INTO hat_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Bondye di l' konsa: -Yo rele ou Jakòb pa sa? Men, yo p'ap rele ou Jakòb ankò, y'a rele ou Izrayèl. Depi lè sa a, se Izrayèl yo rele l' vre. ");
INSERT INTO hat_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Bondye di l' ankò: -Se mwen menm Bondye ki gen tout pouvwa a. W'ap gen anpil pitit ak pitit pitit. Gen ladan yo k'ap wa. W'ap si tèlman gen anpil pitit pitit, y'a tounen yon kantite nasyon. ");
INSERT INTO hat_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Peyi mwen te bay Abraram ak Izarak la, m'ap ba ou li tou. Apre sa, m'ap bay pitit pitit ou yo li. ");
INSERT INTO hat_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Apre sa, Bondye kite l' kote li t'ap pale ak li a, li moute nan syèl. ");
INSERT INTO hat_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jakòb pran yon gwo wòch, li plante l' pou l' make kote Bondye te pale avèk li a. Li pran diven, li wouze wòch la, apre sa li vide lwil sou li. ");
INSERT INTO hat_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Li rele kote Bondye te pale avè l' la Betèl. ");
INSERT INTO hat_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Apre sa, yo pati yo kite Betèl. Yo pa t' twò lwen rive lavil Efrata lè lè a te rive pou Rachèl akouche. Li t'ap soufri anpil. ");
INSERT INTO hat_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Lè doulè a te pi rèd, fanmchay la di l': -Ou pa bezwen pè. Ou fè yon pitit gason ankò. ");
INSERT INTO hat_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rachèl tapral mouri, li t'ap rann dènye souf li lè li rele pitit la Bennoni. Men papa a rele l' Benjamen. ");
INSERT INTO hat_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachèl mouri, yo antere l' sou wout lavil Efrata. Se lavil sa a yo rele Betleyèm lan tou. ");
INSERT INTO hat_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jakòb make tonm lan ak yon gwo wòch: yo rele l' Moniman tonm Rachèl la. Wòch la la jouk jòdi a. ");
INSERT INTO hat_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Apre sa, Izrayèl pati, li al moute tant li lòt bò Migdaledè. ");
INSERT INTO hat_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Antan Jakòb t'ap viv nan peyi sa a, Woubenn al kouche ak Bila, yonn nan fanm papa l' yo. Izrayèl vin konn sa, li te fache anpil. Jakòb te gen douz pitit gason. ");
INSERT INTO hat_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Men non pitit Leya te fè pou li yo: Woubenn, premye pitit gason l' lan, Simeyon, Levi, Jida, Isaka ak Zabilon. ");
INSERT INTO hat_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Men non pitit Rachèl te fè pou li yo: Jozèf ak Benjamen. ");
INSERT INTO hat_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Men non pitit Bila, sèvant Rachèl la, te fè pou li yo: Dann ak Nèftali. ");
INSERT INTO hat_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Men non pitit Zilpa, sèvant Leya a, te fè pou li yo: Gad ak Asè. Se tout pitit gason sa yo Jakòb te genyen antan li te nan peyi Mezopotami. ");
INSERT INTO hat_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakòb al wè papa l' Izarak, nan Manmre (yo rele kote sa a Kija aba tou, ou ankò Ebwon). Se la Abraram ak Izarak te pase tout lavi yo. ");
INSERT INTO hat_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Izarak te gen sankatreven lanne sou tèt li ");
INSERT INTO hat_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","lè li mouri. Li te fin granmoun, li te wè kont jou li lè l' al jwenn moun li yo ki te mouri deja. Ezaou ak Jakòb, pitit gason l' yo, antere li. ");
INSERT INTO hat_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Men pitit pitit Ezaou yo. Se Ezaou sa a yo te rele Edon. ");
INSERT INTO hat_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ezaou te chwazi fi nan moun peyi Kanaran yo pou madanm. Yonn te rele Ada. Se te pitit fi Elon, yon moun Et. Yon lòt te rele Olibama, pitit fi Ana, ki li menm te pitit fi Zibeyon, yon moun Evi. ");
INSERT INTO hat_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Li te marye tout ak Basmat, pitit fi Izmayèl la, sè Nebajòt. ");
INSERT INTO hat_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Se Ada ki te fè Elifaz pou Ezaou. Basmat te fè Reouyèl, ");
INSERT INTO hat_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Olibama menm te fè Jeouch, Jalam epi Kore. Se tout pitit sa yo Ezaou te fè antan li te nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Yon jou, Ezaou pran madanm li yo, pitit gason l' yo, pitit fi li yo, tout moun ki te lakay li, tout mouton l' yo, tout kabrit li yo ansanm ak tou sa li te genyen nan peyi Kanaran, li pati pou yon lòt peyi byen lwen Jakòb, frè li. ");
INSERT INTO hat_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Li te fè sa paske tè kote li t'ap viv ansanm ak Jakòb, frè l' la, te vin twò piti pou yo. Yo te vin gen twòp bèt, yo pa t' kapab rete ansanm ankò menm kote a. ");
INSERT INTO hat_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Se konsa Ezaou, yo rele Edon tou, al rete nan mòn Seyi. ");
INSERT INTO hat_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Men pitit pitit Ezaou, papa moun Edon yo ki rete nan mòn Seyi a. ");
INSERT INTO hat_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Men non pitit gason Ezaou yo: Se te Elifaz, pitit Ada, madanm Ezaou, ak Reouyèl, pitit Basmat, madanm Ezaou tou. ");
INSERT INTO hat_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Men non pitit gason Elifaz yo: Se te Teman, Oma, Zefo, Gayetan ak Kenaz. ");
INSERT INTO hat_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz, pitit Ezaou a, te gen yon fanm kay yo te rele Timna. Se li ki manman Amalèk. Sa yo se tout pitit pitit gason Ada, madanm Ezaou. ");
INSERT INTO hat_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Men non pitit gason Reouyèl yo: Se te Naat, Zerak, Chanma ak Miza. Sa yo se pitit pitit gason Basmat, madanm Ezaou. ");
INSERT INTO hat_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Men non pitit gason Olibama, madanm Ezaou, te fè pou li: Jeouch, Jalam ak Kore. Olibama te pitit fi Ana, pitit fi Zibeyon. ");
INSERT INTO hat_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Men chèf branch fanmi pitit pitit Ezaou yo. Men non tout pitit gason Elifaz, premye pitit gason Ezaou a: Se te Teman, Oma, Zefo, Kenaz, ");
INSERT INTO hat_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kore, Gayetan ak Amalèk. Yo tout te chèf. Se pitit Elifaz sa yo ki te chèf nan peyi Edon an: Yo tout se pitit pitit Ada yo ye. ");
INSERT INTO hat_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Men non pitit gason Reouyèl, pitit gason Ezaou a: Se te Naat, Zerak, Chanma ak Miza. Yo tout te chèf tou. Se pitit Reouyèl sa yo ki te chèf nan peyi Edon an. Yo tout se pitit pitit Basmat, madanm Ezaou, yo ye. ");
INSERT INTO hat_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Men non tout pitit gason Olibama, madan Ezaou: Se te Jeouch, Jalam ak Kore. Yo tout te chèf. Se chèf sa yo ki te pitit Olibama, madan Ezaou. Olibama te pitit fi Ana. ");
INSERT INTO hat_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Se te non tout pitit pitit Ezaou yo sa. Yo te rele Ezaou Edon tou. Se yo ki te chèf branch fanmi yo. ");
INSERT INTO hat_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Men non tout pitit gason Seyi, moun peyi Ori. Se yo menm ki rete nan peyi a depi lontan. Se Lotan, Chobal, Zibeyon, Ana, ");
INSERT INTO hat_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dichon, Ezè ak Dichan. Se chèf moun peyi Ori yo sa. Yo se pitit gason Seyi nan peyi Edon. ");
INSERT INTO hat_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Men non pitit Lotan yo: Se te Ori ak Eman. Timna te sè Lotan. ");
INSERT INTO hat_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Men non pitit Chobal yo: Se te Alvan, Manaat, Ebal, Chefo ak Anam. ");
INSERT INTO hat_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Men non pitit Zibeyon yo: Se te Aja ak Ana. Se Ana sa a ki te jwenn sous dlo cho yo nan dezè a, lè l' t'ap gade bourik Zibeyon, papa l' yo. ");
INSERT INTO hat_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Men non pitit Ana yo: Se te Dichon, yon gason ak Olibama, yon fi. ");
INSERT INTO hat_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Men non pitit gason Dichon yo: Se te Emdan, Echban, Jitran ak Keran. ");
INSERT INTO hat_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Men non pitit gason Ezè yo: Se te Bilan, Zavan ak Akan. ");
INSERT INTO hat_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Men non pitit gason Dichan yo: Ouz ak Aran. ");
INSERT INTO hat_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Men non chèf moun peyi Ori yo: Se te Lotan, Chobal, Zibeyon, Ana, ");
INSERT INTO hat_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dichon, Ezè, Dichan. Se te tout chèf moun Ori yo sa. Se yo ki te chèf branch fanmi moun Ori yo nan peyi Seyi. ");
INSERT INTO hat_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Men wa ki te gouvènen peyi Edon an, anvan te gen ankenn wa pou gouvènen pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, gason Beyò a, t'ap gouvènen peyi Edon. Yo te rele lavil kote li te rete a Denaba. ");
INSERT INTO hat_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Lè Bela mouri, se Jobab, gason Zerak la, moun lavil Bozra, ki te gouvènen nan plas li. ");
INSERT INTO hat_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Lè Jobab mouri, se Oucham, moun peyi Teman, ki te gouvènen nan plas li. ");
INSERT INTO hat_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Lè Oucham mouri, se Adad, pitit gason Bedad la, ki te gouvènen nan plas li. Se Adad sa a ki te bat moun peyi Madyan yo nan plenn Moab la. Yo te rele lavil kote li te rete a Avit. ");
INSERT INTO hat_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Lè Adad mouri, se Samla, moun Masreka, ki te gouvènen nan plas li. ");
INSERT INTO hat_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Lè Samla mouri, se Sayil, moun lavil Reyobòt bò gwo larivyè Lefrat la, ki te gouvènen nan plas li. ");
INSERT INTO hat_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Lè Sayil mouri, se Baalanan, pitit gason Akbò a, ki te gouvènen nan plas li. ");
INSERT INTO hat_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Lè Baalanan, pitit gason Akbò a, mouri, se Ada ki te gouvènen nan plas li. Yo te rele lavil kote li te rete a Paou. Madanm li te rele Metabèl. Se te pitit fi Matrèd ki poutèt pa l' tè pitit fi Mezarab. ");
INSERT INTO hat_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Men lis non tout pitit Ezaou yo ki te chèf ansanm ak non branch fanmi yo ak non kote yo te rete: Timna, Alva, Jetèt, ");
INSERT INTO hat_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ela, Penon, ");
INSERT INTO hat_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibza, ");
INSERT INTO hat_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiyèl, Iram. Se non chèf Edon yo sa ansanm ak non kote yo te rete nan peyi a. Se Ezaou ki papa yo tout nan peyi Edon. ");
INSERT INTO hat_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Men Jakòb rete rete l' nan peyi Kanaran kote papa l' te pase tout lavi l'. ");
INSERT INTO hat_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Men istwa fanmi Jakòb la. Jozèf te yon jenn gason disètan. Li t'ap gade mouton ak kabrit ansanm ak frè l' yo, pitit gason Bila ak Zilpa, fanm kay papa l' yo. Li te konn rapòte bay papa l' tout vye bagay yo t'ap fè. ");
INSERT INTO hat_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Izrayèl menm te renmen Jozèf plis pase tout lòt pitit li yo, paske li te fin granmoun lè Jozèf te fèt. Li fè yon bèl varèz long ak manch pou li. ");
INSERT INTO hat_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Lè frè l' yo wè jan papa yo te renmen Jozèf plis pase yo, yo pran rayi l'. Yo pa t' louvri bouch avè l' san yo pa joure l'. ");
INSERT INTO hat_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yon jou, Jozèf fè yon rèv. Li rakonte l' bay frè li yo. Sa te fè yo rayi l' pi plis toujou. ");
INSERT INTO hat_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Li di yo: -Mesye, tande yon rèv mwen fè. ");
INSERT INTO hat_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Mwen wè nou tout nou te nan jaden, chak moun t'ap mare yon pakèt zèb. Pakèt mwen an rete konsa li kanpe tout dwat pou kont li, epi tout pakèt pa nou yo fè wonn li, yo vin bese tèt devan pa m' lan tankou moun y'ap salwe. ");
INSERT INTO hat_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Frè l' yo di l': -Anhan! Ou vle di ou pral chèf nou, ou pral kòmande nou! Yo te vin rayi l' pi plis toujou poutèt rèv li te di yo li fè a. ");
INSERT INTO hat_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Apre sa, Jozèf fè yon lòt rèv ankò. Li rakonte l' bay frè li yo. Li di yo: -Mwen fè yon lòt rèv. Mwen wè solèy la, lalen lan ansanm ak onz zetwal ki t'ap bese tèt devan mwen. ");
INSERT INTO hat_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Li rakonte rèv la bay papa l' ansanm ak frè l' yo. Men papa a t'ap rale zòrèy li, li t'ap di l': -Ki kalite rèv w'ap fè konsa a? Koulye a, se pou mwen menm, manman ou ansanm ak onz frè ou yo, pou nou vin bese tèt devan ou? ");
INSERT INTO hat_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Frè Jozèf yo t'ap fè jalouzi, men papa l' t'ap kalkile tout bagay sa yo nan tèt li. ");
INSERT INTO hat_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Frè Jozèf yo leve, y ale jouk Sichèm ak bann bèt papa yo pou fè yo manje. ");
INSERT INTO hat_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Izrayèl rele Jozèf, li di l' konsa: -Frè ou yo mennen bèt yo jouk Sichèm al manje. Vini non, m'ap voye ou bò kote yo pou mwen. Jozèf reponn: -Men mwen wi, papa. ");
INSERT INTO hat_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Izrayèl di l' konsa: -Tanpri, ale we kouman frè ou yo ak bèt yo ye laba a. Apre sa, tounen vin pote nouvèl yo ban mwen. Konsa, se papa l' menm ki te fè l' pati kite Fon Ebwon an. Lè Jozèf rive Sichèm, ");
INSERT INTO hat_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","li pèdi wout li nan savann lan, li kontre ak yon nonm ki mande l': -Kisa w'ap chache konsa? ");
INSERT INTO hat_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Jozèf reponn li: -M'ap chache frè m' yo. Tanpri, di m' ki kote yo mennen bèt yo al manje. ");
INSERT INTO hat_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Nonm lan di l': -Yo te isit la wi, men yo pati deja. Mwen tande yo t'ap di yo pral Dotan. Jozèf pati dèyè frè l' yo, li jwenn yo Dotan. ");
INSERT INTO hat_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Men, anvan Jozèf te rive, yo te gen tan wè l' byen lwen ap vini. Yo fè konplo pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Yonn di lòt: -Men nonm ki renmen fè rèv la ap vini. ");
INSERT INTO hat_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Annou wè. N'ap touye l', n'ap jete kadav la nan yonn nan pi yo. Epi n'a di se bèt nan bwa ki touye l'. Konsa n'a wè si sa l' te wè nan rèv li yo va rive vre. ");
INSERT INTO hat_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Woubenn t'ap koute yo, li t'ap chache yon jan pou sove Jozèf anba men yo. Li di yo: -Piga nou touye l'. ");
INSERT INTO hat_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Pa fè san koule. Ann voye l' jete nan pi sa a ki nan dezè a. Men, pa leve men sou li. Li t'ap di yo sa paske li te fè lide sove l' anba men yo pou l' te voye l' tounen bay papa l'. ");
INSERT INTO hat_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lè Jozèf rive bò kote frè l' yo, yo wete bèl varèz long ak manch ki te sou li a. ");
INSERT INTO hat_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Yo pran l', yo jete l' nan pi a. Pi a te vid, li pa t' gen dlo. ");
INSERT INTO hat_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Apre sa, yo chita pou yo manje. Pandan yo leve je yo, konsa yo wè yon kolonn moun Izmayèl ki t'ap vwayaje. Yo te soti Galarad. Chamo yo te chaje ak gonm bwa, lansan ak lami yo t'ap pote al vann nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Jida di frè l' yo konsa: -Sa sa ap rapòte nou pou nou touye frè nou an epi apre sa pou nou kache sa? ");
INSERT INTO hat_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Annou vann li ak moun Izmayèl yo. Konsa nou p'ap bezwen leve men nou sou li. Apre tou, se frè nou li ye, se menm san ak nou. Frè l' yo tonbe dakò. ");
INSERT INTO hat_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Lè machann Madyan yo vin ap pase, yo rale Jozèf moute sot nan pi a. Yo vann li ak moun Izmayèl yo pou vin pyès lajan. Moun Izmayèl yo menm mennen l' nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Lè Woubenn tounen nan pi a, li pa jwenn Jozèf ladan l'. Sa te fè l' lapenn anpil. Li chire rad ki te sou li a. ");
INSERT INTO hat_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Li tounen al jwenn frè li yo, li di yo: -Ti gason an pa nan pi a non! Kisa m' pral fè koulye a? ");
INSERT INTO hat_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Yo touye yon bouk kabrit, yo pran bèl varèz Jozèf la, yo tranpe l' nan san an. ");
INSERT INTO hat_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Yo voye varèz la bay papa yo ak komisyon sa a: -Men sa nou jwenn. Gade wè si se pa varèz pitit gason ou lan. ");
INSERT INTO hat_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jakòb rekonèt rad la, li di: -Men wi, se varèz pitit gason m' lan. Se yon bèt nan bwa ki devore l'. Bèt la dechèpiye l' nèt. ");
INSERT INTO hat_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Sa ou tande a, yon sèl lapenn pran Jakòb, li chire rad ki te sou li, li mare yon tanga sak nan ren li. Li pase kèk tan ap kriye pou pitit gason l' lan. ");
INSERT INTO hat_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","tout lòt gason l' yo ansanm ak pitit fi l' yo te vin ba l' kouraj, men li te refize tande sa yo t'ap di l'. Li t'ap plede repete: -M'ap kriye pou pitit gason m' lan jouk m al jwenn li lè m'a mouri. Se konsa li t'ap kriye pou pitit gason l' lan. ");
INSERT INTO hat_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Pandan tout tan sa a, moun Madyan yo te gen tan vann Jozèf nan peyi Lejip ak Potifa, yonn nan chèf lame farawon an. Se li menm ki te kòmandan gad palè yo. ");
INSERT INTO hat_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Lè sa a, Jida kite frè l' yo, li al jwenn Ira, yon nonm lavil Adoulam. ");
INSERT INTO hat_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Antan li la, li wè yon fi. Papa fi a te yon moun peyi Kanaran yo te rele Chwa. Jida marye ak fi a, li kouche avè l'. ");
INSERT INTO hat_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Madanm lan vin ansent, li fè yon pitit gason. Jida rele pitit la Er. ");
INSERT INTO hat_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Madanm lan vin ansent ankò, li fè yon lòt pitit gason, yo rele l' Onan. ");
INSERT INTO hat_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Li fè yon lòt pitit gason ankò, yo rele l' Chela. Jida te lavil Kezib lè madanm li fè Chela. ");
INSERT INTO hat_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Jida chwazi yon fi yo rele Tama pou Er, premye pitit gason l' lan. ");
INSERT INTO hat_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Men Er, premye pitit Jida a, pa t' fè Seyè a plezi paske li te twò mechan. Se konsa Seyè a te fè l' mouri. ");
INSERT INTO hat_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Lè sa a, Jida di Onan: -Ale jwenn madanm frè ou la, kouche avè l'. Se devwa ou, paske ou se frè mari l' ki mouri. Konsa, w'a fè yon pitit pou frè ou pou non li pa pèdi. ");
INSERT INTO hat_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Men Onan te konnen pitit la pa t'ap pou li. Se konsa, chak fwa li kouche ak madanm frè li a, li voye atè pou li pa t' fè pitit pou frè li a. ");
INSERT INTO hat_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Sa l' t'ap fè a pa t' fè Seyè a plezi. Se konsa Seyè a fè l' mouri tou. ");
INSERT INTO hat_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Lè sa a, Jida di Tama, bèlfi li a: -Ou mèt tounen kay papa ou, rete vèv san marye jouk tan Chela, lòt gason m' lan, vin gran. Li te di l' sa paske li te pè pou Chela pa t' mouri tankou frè l' yo. Tama menm tounen rete kay papa l'. ");
INSERT INTO hat_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kèk tan apre sa, madanm Jida, pitit fi Chwa a, mouri. Apre Jida te fin fè sa pou l' te fè pou lanmò a, li moute al Timna ansanm ak zanmi l' lan, Ira, moun Adoulam lan. Li tapral wè moun ki t'ap taye lenn mouton l' yo pou li. ");
INSERT INTO hat_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Yo fè Tama konn sa, yo di l': -Gade. Men bòpè ou ap moute al Timna, pou l' fè taye lenn mouton li yo. ");
INSERT INTO hat_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Se konsa, Tama wete rad vèv ki te sou li a, li kouvri tèt li ak yon vwal, li al chita bò pòtay lavil Enayim, sou chemen ki mennen Timna a. Li te wè Chela te fin gran, men Jida pa t' pran l' bay Chela pou madanm. ");
INSERT INTO hat_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Lè Jida wè l', li konprann se te yon jennès, paske figi l' te kouvri. ");
INSERT INTO hat_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","li al jwenn li bò chemen an, li di l': -vin non. Kite m' kouche avè ou. Li pa t' konnen se bèlfi li li te ye. Tama di li: -Kisa w'ap ban mwen pou m' kite ou kouche avè m'. ");
INSERT INTO hat_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Jida reponn li: -m'a voye yon jenn kabrit ba ou nan bèt mwen yo. Tama di li: -Kisa w'a ban m' kenbe jouk ou voye l' ban mwen. ");
INSERT INTO hat_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Jida reponn li: -Kisa ou vle m' ba ou kenbe? Tama di li: -Letanp ou a ak tout kòd li, ansanm ak baton ki nan men ou lan. Jida ba li yo. Li kouche ak li. Tama vin ansent pou li. ");
INSERT INTO hat_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Apre sa Tama leve, li al fè wout li. Li wete vwal la, epi li mete rad vèv li sou li ankò. ");
INSERT INTO hat_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Jida voye zanmi l', moun lavil Adoulam lan, ak jenn kabrit la pou l' te ka reprann sa l' te bay fanm lan kenbe a. Men zanmi l' lan pa t' kapab jwenn fanm lan. ");
INSERT INTO hat_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Li mande mesye ki te la yo. Kote jennès ki te chita bò chemen an, sou pòtay lavil Enayim lan? Yo reponn li: -Pa janm gen ankenn jennès bò isit la. ");
INSERT INTO hat_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Li tounen al jwenn Jida, li di l': -Mwen pa jwenn li non. Mesye nan zòn lan di m' pa janm gen ankenn jennès bò la. ");
INSERT INTO hat_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Jida di l': -Pa fatige kò ou chache reprann sak nan men l' lan. Moun va pase m' nan betiz twòp. Mwen voye kabrit la ba li, ou pa jwenn li. Kite sa! ");
INSERT INTO hat_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Sou twa mwa konsa, yo vin di Jida: -Tama, bèlfi ou la, lage kò l' nan jennès. Li gen tan ansent. Jida di yo: -Pran l', mennen l' deyò lavil la. Mete dife anwo l' jouk li mouri. ");
INSERT INTO hat_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Yo t'ap mennen Tama deyò lavil la lè li voye komisyon sa a bay bòpè li: -Se pou mèt bagay sa yo mwen ansent. Gade wè si ou rekonèt ki moun ki mèt letanp sa a ak tout kòd li ansanm ak baton sa a? ");
INSERT INTO hat_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Jida rekonèt yo, li di: -Li gen rezon. Se mwen menm ki antò. Mwen te dwe fè l' marye ak Chela, pitit gason m' lan. Jida pa t' kouche avè l' ankò. ");
INSERT INTO hat_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Lè lè a rive pou Tama akouche, yo wè li te gen marasa nan vant li. ");
INSERT INTO hat_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Pandan li te gen tranche, yonn nan timoun yo lonje men l' deyò. Fanmchay la kenbe men an, li mare yon moso fil wouj ladan l'. Li di: -Sa a fèt anvan. ");
INSERT INTO hat_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Men pitit la rale men an antre, epi se lòt frè a ki soti anvan. Fanmchay la di: -Se konsa ou fè chemen pou ou pase! Se poutèt sa yo rele l' Perèz. ");
INSERT INTO hat_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Apre sa, frè li a soti ak fil wouj la mare nan men l'. Yo rele l' Zerak. ");
INSERT INTO hat_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Moun Izmayèl yo te mennen Jozèf nan peyi Lejip. Rive la, Potifa, yon moun peyi Lejip ki te chèf nan gouvènman farawon an ak kòmandan gad palè yo, achte l' nan men yo. ");
INSERT INTO hat_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Seyè a te kanpe la avèk Jozèf. Li te fè tout bagay mache byen pou li. Jozèf te rete kay mèt li, moun peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Mèt li tout te wè Seyè a te avèk Jozèf. Seyè a te fè tout zafè l' mache byen. ");
INSERT INTO hat_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potifa te kontan ak Jozèf ak jan li t'ap sèvi li. Li mete l' reskonsab kay li, li renmèt li tout sa li te genyen. ");
INSERT INTO hat_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Depi lè Potifa te renmèt kay li ansanm ak tout sa li te genyen bay Jozèf, Seyè a beni kay moun peyi Lejip la poutèt Jozèf. Seyè a beni tout sa li te gen lakay li ak nan jaden l'. ");
INSERT INTO hat_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifa te lage tout zafè l' nan men Jozèf. Li pa t' okipe anyen ankò, se annik vin chita manje. Jozèf te vin yon bèl gason byen kanpe. ");
INSERT INTO hat_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Se konsa madanm mèt li a vin tonbe pou li. Li di l': -vin kouche avè m' non! ");
INSERT INTO hat_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Men Jozèf derefize, li di l': -Mèt mwen an pa okipe anyen k'ap pase nan kay li a, paske mwen la. Li lage tout bagay nan men m'. ");
INSERT INTO hat_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mwen gen menm otorite avè l' nan kay la, li pa defann mwen manyen anyen, esepte ou menm, paske se madanm li ou ye. Ki jan ou ta vle pou m' fè yon bagay konsa, pou m' fè peche sa a kont Bondye? ");
INSERT INTO hat_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Se chak jou li te nan kò Jozèf. Men, Jozèf te toujou derefize kouche avè l'. ");
INSERT INTO hat_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Yon jou, Jozèf vin pou fè travay li nan kay la. Lè sa a pesonn pa t' la: ");
INSERT INTO hat_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Madanm lan kenbe rad Jozèf, li di l': -Jòdi a, se pou ou kouche avè m'. Lè Jozèf wè sa, li chape kò l' met deyò, li kite rad la nan men madanm lan. ");
INSERT INTO hat_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Madanm lan menm, lè li wè Jozèf te kite rad la nan men l' pou l' kouri ale deyò, ");
INSERT INTO hat_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","li rele domestik li yo, li di yo: -Nou wè sa! Mari mwen mennen yon ebre nan kay la, men koulye a li soti pou avili m'. Li vini jwenn mwen jouk isit la, li vle pou m' kouche avè l'. Mwen pete rele. ");
INSERT INTO hat_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Lè li tande m' rele a, msye kouri, li met deyò, li kite rad li la bò kote m'. ");
INSERT INTO hat_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Madanm lan kite rad la bò kote l', li tann mèt Jozèf la tounen lakay la. ");
INSERT INTO hat_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Li rakonte l' menm bagay la, li di l': -Esklav ebre ou mennen lakay la vin jwenn mwen jouk isit la pou avili m'. ");
INSERT INTO hat_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Men, mwen pete yon rèl, li kouri met deyò, li kite rad li bò kote m'. ");
INSERT INTO hat_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Lè Potifa tande madanm li di l' sa domestik li a te fè l', li move sou Jozèf. ");
INSERT INTO hat_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Li fè arete l', mete l' nan prizon kote yo fèmen tout prizonye wa a. Se konsa Jozèf twouve l' nan prizon. ");
INSERT INTO hat_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Men Seyè a te kanpe la avèk Jozèf. Li moutre l' jan l' te renmen l', li fè chèf prizon an gen Jozèf konfyans. ");
INSERT INTO hat_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Li mete l' veye tout lòt prizonye yo. Se li menm ki te reskonsab tout bagay nan prizon an. ");
INSERT INTO hat_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Depi li te renmèt yon bagay nan men Jozèf, li pa t' bezwen okipe anyen ankò paske Seyè a te la avèk Jozèf. Seyè a te fè tout zafè l' mache byen. ");
INSERT INTO hat_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kèk tan apre sa, chèf kanbiz ak chèf boulanje wa Lejip la te fè mèt yo yon bagay. ");
INSERT INTO hat_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farawon an te move ni sou chèf kanbiz la ni sou chèf boulanje a. ");
INSERT INTO hat_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Se konsa li te mete yo lakay kòmandan gad palè a, kote yo te fèmen Jozèf nan prizon an. ");
INSERT INTO hat_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kòmandan gad palè a mete yo sou kont Jozèf pou l' sèvi yo. Yo pase kèk tan nan prizon an. ");
INSERT INTO hat_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Yon jou lannwit, antan yo nan prizon an, chèf kanbiz ak chèf boulanje wa a te fè yo chak yon rèv. Chak rèv te gen sans pa yo. ");
INSERT INTO hat_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Lè Jozèf vin jwenn yo nan denmen maten, li jwenn yo boulvèse. ");
INSERT INTO hat_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Li mande yo: -Poukisa nou kagou konsa jòdi a? ");
INSERT INTO hat_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Yo reponn li: -Nou chak fè yon rèv, men pa gen pesonn isit la ki ka esplike nou rèv yo. Jozèf reponn yo: -Eske se pa Bondye sèl ki ka esplike bagay konsa? Rakonte m' rèv nou yo. ");
INSERT INTO hat_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Chèf kanbiz la rakonte Jozèf rèv li te fè a, li di l': -Nan rèv mwen an, mwen wè yon pye rezen devan m'. ");
INSERT INTO hat_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Li te gen twa branch. Branch yo pran boujonnen, yo fè flè, yo fè rezen, rezen yo mi. ");
INSERT INTO hat_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Gwo gode farawon an te nan men mwen. Mwen pran rezen yo, mwen pije yo nan gode farawon an, lèfini mwen bay wa a li. ");
INSERT INTO hat_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Jozèf di li: -Men sa rèv la vle di: Twa branch yo se twa jou. ");
INSERT INTO hat_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nan twa jou, farawon an pral chonje ou, li pral mete ou nan pozisyon ou ankò. Ou pral bay farawon an diven jan ou te konn fè l' anvan lè ou te chèf kanbiz li a. ");
INSERT INTO hat_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Men, lè tout bagay va mache byen pou ou, pa bliye m'. Tanpri, rann mwen sèvis sa a, pale ak farawon an pou mwen. Fè m' soti nan prizon sa a. ");
INSERT INTO hat_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ou wè: se vòlè yo te vòlè m' nan peyi Ebre yo. Isit la menm, mwen pa t' fè anyen pou yo te mete m' nan prizon. ");
INSERT INTO hat_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Lè chèf boulanje a wè bèl esplikasyon Jozèf te bay lòt la, li di l': -Mwen menm tout mwen fè yon rèv. Mwen wè te gen twa panyen pen sou tèt mwen. ");
INSERT INTO hat_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Nan panyen ki te anwo nèt la, te gen tout kalite bagay yo konn kwit nan fou pou wa a. Men, zwazo t'ap manje yo nan panyen an sou tèt mwen. ");
INSERT INTO hat_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Jozèf reponn li: -Men sa rèv la vle di: Twa panyen yo se twa jou. ");
INSERT INTO hat_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nan twa jou farawon an pral fè rele ou, l'ap fè yo pann ou nan yon pyebwa, kote zwazo ap vin dechèpiye ou. ");
INSERT INTO hat_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sou twa jou vre, farawon an t'ap fè yon gwo resepsyon pou tout chèf ki t'ap sèvi avè l' yo, paske se te jou fèt li. Li fè rele chèf kanbiz la ak chèf boulanje a devan tout lòt chèf yo. ");
INSERT INTO hat_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Li mete chèf kanbiz la nan plas li ankò pou sèvi l'. ");
INSERT INTO hat_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Men, li fè pann chèf boulanje a, jan Jozèf te di yo a. ");
INSERT INTO hat_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Men, chèf kanbiz la pa dòmi reve Jozèf, li bliye l' nèt. ");
INSERT INTO hat_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dezan te fin pase. Farawon an fè yon rèv. Li wè li te kanpe bò larivyè Nil la. ");
INSERT INTO hat_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Li wè sèt bèl vach byen gra moute soti nan larivyè a, yo t'ap manje zèb bò dlo a. ");
INSERT INTO hat_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Apre sa, sèt lòt vach tout lèd, tout mèg, moute soti nan dlo a tou. Yo vin kanpe toupre lòt vach yo, bò dlo a. ");
INSERT INTO hat_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Sèt vye vach mèg yo manje sèt bèl vach gra yo. Epi je farawon an vin klè. ");
INSERT INTO hat_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Dòmi pran l' ankò, li fè yon lòt rèv. Li wè sèt gwo grap ble ki t'ap pouse sou yon sèl pye ble. Yo te plen grenn, yo te mi. ");
INSERT INTO hat_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Apre sa, sèt lòt grap vin parèt sou menm pye ble a. Yo te chèch, van nòde te fin boule yo. ");
INSERT INTO hat_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Sèt grap chèch yo souse sèt bèl grap yo. Epi je farawon an vin klè ankò. Se rèv sa yo li te fè. ");
INSERT INTO hat_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Nan maten, li te boulvèse anpil, li voye chache dènye divinò ak nèg save ki nan peyi Lejip la. Li rakonte yo rèv la, men yo yonn pa t' kapab esplike rèv la ba li. ");
INSERT INTO hat_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Se lè sa a, chèf kanbiz la di farawon an: -Koulye a mwen chonje mwen te fè yon fòt. ");
INSERT INTO hat_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yon jou, monwa, ou te ankòlè sou sèvitè ou yo. Ou te fè mete yo nan prizon lakay kòmandan gad palè ou la. Se te mwen menm, chèf kanbiz ou a, ansanm ak chèf boulanje ou la. ");
INSERT INTO hat_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yon jou lannwit, nou tout de nou reve. Chak moun te fè yon rèv diferan. Chak rèv te gen sans pa l'. ");
INSERT INTO hat_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Te gen yon jenn ebre avèk nou nan prizon an. Se te yon esklav kòmandan gad palè a. Nou rakonte l' rèv nou yo. Epi li esplike yo ban nou, li bay chak moun sans rèv li te fè a. ");
INSERT INTO hat_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","tout bagay pase jan li te di a: Sou twa jou vre, farawon an te mete m' nan plas mwen ankò. Pou chèf boulanje a menm, li te fè pann li. ");
INSERT INTO hat_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Farawon an voye chache Jozèf. Yo fè l' soti byen vit nan prizon an. Jozèf fè labab, li koupe cheve l', li chanje rad, epi li parèt devan farawon an. ");
INSERT INTO hat_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farawon an di Jozèf konsa: -Mwen fè yon rèv, pesonn pa ka di m' sa l' vle di. Men yo di m' depi yo rakonte ou yon rèv, ou ka esplike l'. ");
INSERT INTO hat_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Jozèf reponn farawon an: -Se pa mwen menm non! Se Bondye ki pral bay farawon an esplikasyon rèv la. ");
INSERT INTO hat_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Farawon an di: -Mwen reve mwen te kanpe bò larivyè Nil la. ");
INSERT INTO hat_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Konsa, sèt bèl vach byen gra te moute soti nan larivyè a, yo t'ap manje zèb bò dlo a. ");
INSERT INTO hat_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Apre sa, sèt lòt vach tout mèg, tout lèd, tout chèch te moute soti nan dlo a dèyè lòt yo. Mwen poko janm wè vye vach lèd konsa nan tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Vye vach mèg yo manje bèl vach gra yo. ");
INSERT INTO hat_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Lè yo te fin vale yo, se tankou si yo pa t' janm manje. Yo te rete menm jan yo te ye anvan an. Epi je m' vin klè. ");
INSERT INTO hat_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Apre sa, mwen fè yon lòt rèv. Mwen wè sèt grap ble byen plen, byen mi ki t'ap pouse ansanm sou yon sèl pye ble a. ");
INSERT INTO hat_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Apre sa, sèt lòt grap parèt dèyè yo. Yo te chèch, van nòde te fin boule yo. ");
INSERT INTO hat_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Grap mèg yo souse sèt bèl grap yo. Mwen rakonte rèv yo bay divinò yo, men yo yonn pa t' kapab esplike yo ban mwen. ");
INSERT INTO hat_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Jozèf di farawon an: -tout de rèv yo vle di menm bagay la: Bondye fè ou konnen sa li pral fè. ");
INSERT INTO hat_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Sèt vach gra yo, se sèt lanne. Sèt bèl grap yo se sèt lanne tou. Yo vle di menm bagay. ");
INSERT INTO hat_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Sèt vach tout mèg, tout lèd ki vin apre lòt yo, se sèt lanne. Sèt grap ble boule yo, se sèt lanne tou. Sa vle di pral gen sèt lanne grangou. ");
INSERT INTO hat_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Se jan m' sot di farawon an: Bondye vle fè ou konnen sa li pral fè. ");
INSERT INTO hat_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Pandan sèt lanne pral gen bèl rekòt nan tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Apre sa, pral gen sèt lanne grangou. Lè sa a, moun pral bliye tout bèl rekòt yo te fè nan peyi a. Grangou pral fini nèt ak peyi a. ");
INSERT INTO hat_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Grangou ki pral tonbe sou peyi a pral rèd anpil. Moun p'ap wè tras rekòt ki te fèt nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Si farawon an fè menm rèv la de fwa, sa vle di Bondye gen tan fin fè plan l' nèt. Se yon bagay Bondye pral fè talè konsa. ");
INSERT INTO hat_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Koulye a, se pou farawon an chwazi yon moun ki gen lespri ak bon konprann pou l' mete l' chèf sou tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Se pou ou mete chèf toupatou nan peyi Lejip la, pou yo ranmase yon senkyèm nan tout rekòt ki pral fèt pandan sèt bon lanne yo. ");
INSERT INTO hat_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Se pou yo ranmase pwovizyon pandan tout lanne ki pral vini yo. Se pou farawon an ba yo otorite pou yo anpile pwovizyon yo nan depo nan chak vil, lèfini pou yo veye yo. ");
INSERT INTO hat_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Konsa, pwovizyon sa yo va sèvi yon rezèv pou peyi a pandan sèt lanne grangou k'ap vin tonbe apre sa sou peyi Lejip, pou grangou pa fini ak peyi a. ");
INSERT INTO hat_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farawon an ak tout moun pa l' yo te tonbe dakò ak sa Jozèf te di a. ");
INSERT INTO hat_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Farawon an di moun pa l' yo: -Ki bò nou ka jwenn yon moun ki gen lespri Bondye sou li tankou nonm sa a? ");
INSERT INTO hat_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farawon an di Jozèf: -Gade tout bagay Bondye fè ou konnen! Pa gen pesonn ki gen plis lespri, osinon plis bon konprann pase ou. ");
INSERT INTO hat_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","M'ap mete ou chèf sou tout peyi mwen an. Se pou tout moun nan peyi a obeyi ou. Se sèlman paske mwen wa kifè mwen menm m'a pi gwo chèf pase ou. ");
INSERT INTO hat_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Apre sa, farawon an di Jozèf: -Gade, m'ap mete ou chèf pou gouvènen tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Li wete gwo bag ki te nan dwèt li a, li mete l' nan dwèt Jozèf. Li abiye l' ak yon rechanj fèt ak bèl twal fen. Li pase yon chenn an lò nan kou l'. ");
INSERT INTO hat_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Li fè l' moute sou yon cha. Se te pi bèl cha nan tout peyi a apre cha wa a. Li bay gad onè ki t'ap mache devan Jozèf yo lòd pou yo di byen fè: Abrèk. Se konsa farawon an te mete Jozèf chèf sou tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farawon an di Jozèf: -Se mwen menm farawon an k'ap pale avèk ou. Pesonn pa gen dwa fè anyen ni al ankenn kote nan peyi Lejip san pèmisyon ou. ");
INSERT INTO hat_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farawon an rele Jozèf Safna-Paneak. Li pran Asnat, pitit fi Potifera, yon prèt lavil On, li bay Jozèf li pou madanm. Jozèf al vizite tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Jozèf te gen trantan lè li te konmanse sèvi farawon an, wa peyi Lejip la. Li pati, li vwayaje toupatou nan peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Pandan sèt bon lanne yo, tè a te bay anpil anpil rekòt. ");
INSERT INTO hat_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Jozèf ranmase pwovizyon pandan sèt lanne bon rekòt yo nan tout peyi a, li mete yo nan depo nan lavil yo. Chak lavil te gen kont depo pou sere tout sa jaden alantou yo te bay. ");
INSERT INTO hat_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Li ranmase ble, li ranmase ble tankou ou ta di sab bò lanmè. Sitèlman te gen anpil ble, yo pa t' ka konnen kantite ki te genyen. ");
INSERT INTO hat_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Anvan lanne grangou yo mete pye, Jozèf te gen tan gen de pitit ak Asnat, pitit fi Potifera, prèt lavil On an. ");
INSERT INTO hat_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Jozèf rele premye a Manase paske li t'ap di nan kè l': Bondye fè m' bliye tout soufrans mwen ansanm ak moun lakay papa m' yo. ");
INSERT INTO hat_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Li rele dezyèm lan Efrayim paske li t'ap di nan kè l': Bondye fè m' fè pitit nan peyi kote m'ap soufri a. ");
INSERT INTO hat_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sèt bon lanne rekòt yo te fin pase nan peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Sèt lanne grangou yo te konmanse jan Jozèf te di a. Grangou t'ap bat nan tout lòt peyi yo tou, men te gen manje toujou nan tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Men, yon lè grangou konmanse mete pye nan peyi Lejip la tou. Pèp la menm pran rele nan zòrèy farawon an, y'ap mande manje. Farawon an di moun peyi Lejip yo: -Al jwenn Jozèf. Se li menm ki va di nou sa pou nou fè. ");
INSERT INTO hat_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Lè grangou a te toupatou nan peyi Lejip la, Jozèf louvri tout depo yo. Li vann moun peyi Lejip yo ble, paske grangou a te rèd anpil nan peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Moun soti toupatou nan tout lòt peyi yo vin achte ble nan men Jozèf nan peyi Lejip, paske grangou a te rèd anpil toupatou sou latè. ");
INSERT INTO hat_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Lè Jakòb vin konnen te gen ble pou vann nan peyi Lejip, li di pitit li yo: -Poukisa nou chita konsa yonn ap gade lòt, de bra kwaze? ");
INSERT INTO hat_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mwen tande y'ap vann ble nan peyi Lejip. Desann non, al achte ble pou nou ka viv pou nou pa mouri grangou. ");
INSERT INTO hat_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Se konsa, dis nan frè Jozèf yo desann nan peyi Lejip, y al achte ble. ");
INSERT INTO hat_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Men Jakòb pa t' voye Benjamen, lòt frè Jozèf menm manman avè l' la, avèk yo paske li te pè pou malè pa t' rive l'. ");
INSERT INTO hat_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Grangou a te rèd nan peyi Kanaran an tou. Se konsa, pitit Izrayèl yo te vwayaje ansanm ak lòt moun ki tapral achte ble tou. ");
INSERT INTO hat_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Se Jozèf ki t'ap gouvènen sou tout peyi Lejip la. Se nan men l' moun te konn soti toupatou vin achte manje. Frè Jozèf yo rive, yo bese tèt yo byen ba jouk atè pou di l' bonjou. ");
INSERT INTO hat_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Lè Jozèf wè frè l' yo, li rekonèt yo. Men li pran pòz pa konnen yo. Li pale rèd ak yo. Li di: -Ki bò nou soti? Yo reponn: -Nou soti peyi Kanaran, nou vin achte manje. ");
INSERT INTO hat_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Jozèf te rekonèt frè l' yo, men yo menm yo pa t' rekonèt li. ");
INSERT INTO hat_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Le sa a Jozèf vin chonje rèv li te fè sou frè l' yo. Li di yo: -Nou se yon bann espyon. Nou vin isit la pou n' chache konnen pwen fèb peyi a. ");
INSERT INTO hat_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yo reponn li: -Non, mèt. Nou se moun pa ou, se manje nou vin achte isit la. ");
INSERT INTO hat_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nou tout nou se pitit yon sèl papa. Nou p'ap ba ou manti, se pa espyon nou ye. ");
INSERT INTO hat_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Jozèf di yo: -Se pa vre. Nou vin isit la pou n' chache konnen pwen fèb peyi a. ");
INSERT INTO hat_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Yo di l': -Nou se douz frè, pitit yon sèl papa nan peyi Kanaran. Dènye a rete ak papa nou. Gen yonn nan nou ki disparèt. ");
INSERT INTO hat_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Jozèf reponn yo: -Nou wè mwen gen rezon lè m' di se yon bann espyon nou ye. ");
INSERT INTO hat_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Men ki bò mwen pral kenbe nou: M'ap fè sèman sou tèt farawon an, nou p'ap soti isit la tout tan nou pa fè ti frè nou an vini isit la. ");
INSERT INTO hat_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Voye yonn nan nou al chache l'. Lòt yo ap rete nan prizon. Se konsa, m'a wè nou pa t'ap bay manti. Si se pa sa, mwen fè sèman sou tèt farawon an, se espyon nou ye. ");
INSERT INTO hat_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Li fè fèmen yo tout nan prizon pandan twa jou. ");
INSERT INTO hat_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sou twazyèm jou a, Jozèf di yo: -Men sa pou n' fè, si nou vle sove lavi nou: Mwen menm mwen se moun ki respekte Bondye. ");
INSERT INTO hat_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si nou konnen nou p'ap bay manti se pou yonn nan nou rete fèmen nan prizon kote yo te fèmen nou an. Lòt yo mèt pote ble a ale pou fanmi nou yo ka manje. ");
INSERT INTO hat_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Men, ti frè nou an, sa ki pi piti a, se pou nou mennen l' ban mwen, pou nou ka moutre m' nou pa t' ban m' manti. Konsa, yo p'ap touye nou. Yo tonbe dakò sou sa. ");
INSERT INTO hat_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Yonn t'ap di lòt: -Nou wè. Nou peye sa nou te fè frè nou an pase. Se vre wi. Nou te fè mal lè nou te fè frè nou an pase tout sa nou te fè l' la. Nou te wè ki jan sa te fè l' lapenn anpil, lè li t'ap mande nou fè l' gras. Men, nou pa t' vle koute l'. Se poutèt sa nou nan tout traka sa a. ");
INSERT INTO hat_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Woubenn di yo: -Mwen te di nou pa fè tibway la anyen, men nou pa t' vle koute m'. Koulye a se lanmò tibway la n'ap peye. ");
INSERT INTO hat_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Jozèf te konprann tout sa yo t'ap di a. Men yo pa t' konn sa paske te gen yon moun ki t'ap tradwi pou yo lè yo t'ap pale avè l'. ");
INSERT INTO hat_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Jozèf soti kote yo te ye a, li al kriye. Lèfini li tounen, li pale ak yo, li pran Simeyon, li fè yo mete l' nan chenn, la devan yo tout. ");
INSERT INTO hat_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Jozèf te bay lòd pou yo te plen sak yo avèk ble, pou yo te mete lajan yo chak nan sak yo ankò, lèfini pou yo ba yo manje pou yo manje sou wout la. Se sa yo te fè vre. ");
INSERT INTO hat_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Frè yo menm chaje bourik yo ak ble yo te achte a, yo pati. ");
INSERT INTO hat_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Lè yo rive kote yo t'ap pase nwit la a, yonn ladan yo louvri sak li pou l' te ka bay bourik li manje. Li jwenn lajan li te bay la nan sak la. ");
INSERT INTO hat_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Li di frè l' yo. -Yo renmèt mwen lajan m' lan wi. Men li nan sak mwen an. Kè yo kase. Yo t'ap tranble kou fèy bwa tèlman yo te pè. Yonn t'ap di lòt: -Kisa Bondye fè nou konsa? ");
INSERT INTO hat_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Lè yo rive kay Jakòb, papa yo, nan peyi Kanaran, yo rakonte l' tout sa ki te pase. Yo di l': ");
INSERT INTO hat_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","-Nèg k'ap gouvènen peyi a pale rèd ak nou. Li pran nou pou espyon. ");
INSERT INTO hat_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nou di l' nou p'ap ba l' manti, se pa espyon nou ye. ");
INSERT INTO hat_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Se douz frè nou ye, pitit yon sèl papa. Yonn nan nou disparèt, dènye a rete ak papa nou nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Men chèf peyi a di nou: Men ki jan m'ap konnen si nou p'ap ban m' manti: Kite yonn nan frè nou yo isit la avèk mwen. Pran sa nou bezwen pou fanmi nou. Nou mèt ale. Mennen lòt ti frè nou an ban mwen. ");
INSERT INTO hat_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Lè sa a, m'a konnen se pa espyon nou ye, nou pa t'ap ban m' manti. m'a renmèt nou frè nou an. m'a kite nou trafike nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Lè yo vide sak yo, chak moun jwenn ti sakit lajan li te bay la nan bouch sak li ankò. Lè yo wè sa, yon sèl lapè pran yo ansanm ak papa yo. ");
INSERT INTO hat_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Lè sa a Jakòb, papa yo, di: -N'ap wete tout pitit mwen yo nan men m'. Jozèf disparèt, Simeyon pa la ankò. Koulye a, nou vle pran m' Benjamen. Se mwen menm k'ap pote tout chaj la. ");
INSERT INTO hat_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Woubenn di papa l' konsa: -Papa, ou mèt touye de pitit gason m' yo, si m' pa mennen Benjamen tounen ba ou. Ou mèt renmèt mwen li nan men, m'ap mennen l' tounen ba ou. ");
INSERT INTO hat_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Men Jakòb te di: -Pitit gason m' lan p'ap fè yon pa. Frè li a fin mouri. Se li menm sèl ki rete nan pitit manman l' yo. Si pou yon malè ta rive l' nan vwayaj nou pral fè a, m'a mouri. Mwen fin granmoun, lapenn sa a va twòp pou mwen, la fin pote m' ale. ");
INSERT INTO hat_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Grangou t'ap bat pi rèd nan peyi Kanaran an. ");
INSERT INTO hat_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Lè fanmi Jakòb yo te fin manje ble yo te pote soti nan peyi Lejip la, Jakòb di pitit li yo: -Tounen al chache manje pou nou ankò non. ");
INSERT INTO hat_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Jida reponn li: -Nonm lan te byen avèti nou pou nou pa parèt devan l' si nou pa vin ak ti frè nou an. ");
INSERT INTO hat_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si ou vle kite ti frè nou an vin ak nou, nou v al achte manje pou ou. ");
INSERT INTO hat_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Si ou pa vle kite l' ale, n'ap rete, paske msye a te tout di nou: piga nou parèt devan l' ankò si nou pa vin ak ti frè nou an. ");
INSERT INTO hat_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Izrayèl di: -Sa nou te bezwen di l' nou te gen yon ti frè fè? Poukisa nou fè m' sa? ");
INSERT INTO hat_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Yo reponn li: -Msye a t'ap poze nou keksyon sou nou ak sou fanmi nou. Li mande nou si papa nou la toujou, si nou gen lòt frè, se pou n' te reponn li. Kouman pou n' ta fè konnen li tapral mande nou pou nou mennen ti frè nou an ba li? ");
INSERT INTO hat_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Jida di Izrayèl, papa l', konsa: -Kite tibway la ale ak nou. Konsa n'a leve, n'a pati. Konsa ni ou menm, ni nou menm, ni timoun nou yo p'ap mouri grangou. ");
INSERT INTO hat_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Se nan men m' li ye, se mwen menm ki pou rann ou kont pou li. Si m' pa mennen l' tounen ba ou, si m' pa tounen avè l' la devan ou, se mwen menm k'ap pote fòt la devan ou jouk mwen mouri. ");
INSERT INTO hat_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Si nou pa t' pran tout reta sa a, koulye a nou ta gen tan ale nou tounen de fwa deja. ");
INSERT INTO hat_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Lè sa a, Izrayèl, papa yo, di: -Bon. Si se konsa sa ye, men sa pou n' fè: n'ap pran pi bon danre ki gen nan peyi a, n'ap mete nan sak nou, n'ap pote fè nonm lan kado: gonm santi bon, siwo myèl, lansan, lami, pistach ak nwa. ");
INSERT INTO hat_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Lèfini, n'a pran de fwa valè lajan nou bezwen, paske fòk nou renmèt lajan yo te mete nan bouch sak ble yo tou. Ou pa janm konnen, yo ka pa t' wè sa. ");
INSERT INTO hat_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Pran frè nou an, tounen kote msye a. ");
INSERT INTO hat_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","M'ap mande Bondye ki gen tout pouvwa a pou l' fè nonm lan aji byen ak nou, pou l' ka renmèt nou ni lòt frè nou an, ni Benjamen. Pou mwen menm, si se pou m' pèdi pitit mwen yo, mwen mèt pèdi yo. ");
INSERT INTO hat_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Se konsa mesye yo pran kado yo, de fwa valè lajan yo te bezwen ansanm ak Benjamen, yo leve, yo desann peyi Lejip kote yo parèt devan Jozèf. ");
INSERT INTO hat_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Lè Jozèf wè Benjamen ak yo, li rele chèf domestik li a, li di l': -Mennen mesye sa yo lakay mwen. Touye yon bèt, kwit li, paske mesye sa yo ap manje avè m' midi a. ");
INSERT INTO hat_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Chèf domestik la fè sa Jozèf te di l' fè a, li mennen mesye yo lakay li. ");
INSERT INTO hat_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Men, lè mesye yo wè yo t'ap mennen yo lakay Jozèf, yo te pè anpil. Yo t'ap di: -Se poutèt lajan nou te jwenn nan sak nou yo dènye fwa a kifè y'ap mennen nou bò isit la. Yo pral kenbe nou, yo pral bat nou, y'ap fè nou tounen esklav. Lèfini y'ap pran bourik nou yo. ");
INSERT INTO hat_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Se konsa, antan yo rive nan papòt kay la, yo pwoche bò chèf domestik la, ");
INSERT INTO hat_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","yo di l': -Eskize nou wi, mèt. Nou te vin isit la yon fwa deja pou n' te achte manje. ");
INSERT INTO hat_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Lè n'ap tounen lakay nou, nou rive yon kote nou t'ap poze pou pase nwit, nou louvri sak nou yo, nou jwenn tout lajan an nan bouch sak yo, byen konte. Nou pote l' tounen wi. ");
INSERT INTO hat_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nou pote lòt lajan tout pou n' ka achte manje. Nou pa konnen ki moun ki te mete lajan an nan sak nou yo ankò. ");
INSERT INTO hat_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Domestik anchèf la di yo: -Pa okipe bagay konsa. Nou pa bezwen pè. Se Bondye nou an, Bondye papa nou an, ki mete richès sa a pou nou nan sak yo. Mwen te resevwa premye lajan an. Lèfini, li mennen Simeyon vin jwenn yo. ");
INSERT INTO hat_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Chèf domestik la mennen mesye yo lakay Jozèf. Li ba yo dlo pou yo lave pye yo, li bay bourik yo manje. ");
INSERT INTO hat_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mesye yo menm pare kado yo pou lè Jozèf va vin jwenn yo midi, paske yo te vin konnen yo tapral manje avè l'. ");
INSERT INTO hat_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Lè Jozèf antre lakay li, yo pote kado yo ba li, yo bese tèt yo jouk atè devan li. ");
INSERT INTO hat_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Jozèf mande yo kouman yo ye. Apre sa, li di yo: -Granmoun nou te pale m' lan, papa nou an, ban m' nouvèl li non? Li la toujou? Li byen? ");
INSERT INTO hat_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Yo reponn li: -Granmoun lan la wi, l'ap debat. Li byen mèsi. Yo tonbe ajenou, yo bese tèt yo jouk atè devan li. ");
INSERT INTO hat_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Lè Jozèf fè sa li wè Benjamen, frè menm manman menm papa avè l' la, li di: -Eske se ti frè nou an sa, ti frè nou t'ap pale m' lan? Bondye beni ou, pitit mwen. ");
INSERT INTO hat_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Lè sa a, Jozèf kouri soti byen vit, paske kè l' t'ap fè l' mal pou frè l' yo. Dlo vin nan je l', li antre nan chanm li, li kriye kont li. ");
INSERT INTO hat_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Apre sa, li lave figi l', li soti, li kenbe pou li pa kriye ankò, epi li bay lòd sèvi manje a. ");
INSERT INTO hat_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yo te sèvi yon tab apa pou Jozèf, yon tab apa pou frè l' yo ak yon lòt tab apa pou moun peyi Lejip ki t'ap manje ansanm ak yo tou, paske pou moun peyi Lejip yo, se ta yon wont pou yo chita manje sou menm tab ak ebre yo. ");
INSERT INTO hat_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Frè Jozèf yo te chita anfas li. Yo te mete yo chita dapre laj yo, depi pi gran an jouk pi piti. Lè yo wè sa, yo te sezi, yonn gade lòt. ");
INSERT INTO hat_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Jozèf te fè yo pran manje sou tab li pote ba yo. Benjamen te resevwa senk fwa plis pase lòt yo. Yo manje, yo bwè, yo fete ansanm avè l'. ");
INSERT INTO hat_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Apre sa, Jozèf bay chèf domestik la lòd sa a: -Plen sak mesye yo manje mezi yo ka pote. Mete lajan chak moun nan bouch sak yo. ");
INSERT INTO hat_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","W'a pran gwo gode m' lan, gode an ajan an, w'a mete l' nan bouch sak pi piti a ansanm ak tout lajan l' lan. Chèf domestik la fè sa Jozèf te di l' fè a. ");
INSERT INTO hat_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nan denmen maten, byen bonè, yo voye mesye yo al fè wout yo ak tout bourik yo. ");
INSERT INTO hat_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Yo te fin kite lavil la dèyè, men yo pa t' pi lwen pase sa, lè Jozèf di domestik li a: -Leve, kouri dèyè mesye yo. Lè w'a trape yo, w'a di yo: Poukisa nou aji mal konsa ak moun ki fè nou byen? ");
INSERT INTO hat_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Poukisa nou pran gwo gode mèt mwen an? Se ladan l' li bwè, se ak li li sèvi pou l' konnen sa ki pral pase. Sa nou fè a pa bon menm. ");
INSERT INTO hat_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Lè domestik la trape yo, li repete tout sa mèt li a te di l'. ");
INSERT INTO hat_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Men yo reponn: -Men msye, nou pa konprann sa w'ap di la a. pou n' ta fè bagay konsa? Mande Bondye padon! ");
INSERT INTO hat_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Gade, lajan nou te jwenn premye fwa a nan bouch sak nou yo, nou pote l' tounen ba ou soti peyi Kanaran. Ki jan ou vle wè pou nou ta vòlò ajan osinon lò kay mèt la? ");
INSERT INTO hat_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Si ou jwenn gwo gode a nan men yonn nan nou, se pou moun sa a mouri. Nou menm lòt yo, se pou yo fè nou tounen esklav. ");
INSERT INTO hat_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Domestik la di: -Dakò. Men, si yo jwenn gode a nan men yonn nan nou, se moun sa a m'ap pran pou sèvi m' esklav. Lòt yo lib, yo mèt ale. ");
INSERT INTO hat_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","La menm, yo prese mete sak yo atè, chak moun louvri sak yo. ");
INSERT INTO hat_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Chèf domestik Jozèf la pran fouye sak yo yonn apre lòt. Li konmanse ak sak pi gran an pou l' fini ak sak pi piti a. Yo jwenn gode a nan sak Benjamen an. ");
INSERT INTO hat_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Sa ou tande a, yon sèl lapenn pran mesye yo, yo chire rad sou yo. Chak moun chaje bourik yo ankò, yo tounen lavil. ");
INSERT INTO hat_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Lè Jida ak frè l' yo rive lakay Jozèf, Jozèf te la toujou. Yo bese tèt yo jouk atè devan li. ");
INSERT INTO hat_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Jozèf di yo: -Kisa nou fè konsa? Eske nou pa konnen yon nonm tankou mwen gen pouvwa pou m' wè tout sa ki pral rive? ");
INSERT INTO hat_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Jida reponn li: -Mèt, nou pa konn sa pou nou di. Nou pa ka pale. Pa gen savon pou lave nou devan ou. Se Bondye menm ki fè ou dekouvri nou. Mèt, se poutèt sa se pa sèlman moun ki te gen gode a nan men l' lan ki esklav ou, se nou tout ki esklav ou. ");
INSERT INTO hat_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Men Jozèf di: -Mande Bondye padon! Mwen pa ka fè sa. Moun ki te gen gode a, se li menm sèlman k'ap rete pou sèvi m' esklav. Lòt yo mèt tounen lakay papa yo ak kè poze jan yo te vini an. ");
INSERT INTO hat_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Lè sa a, Jida pwoche bò kote Jozèf, li di l' konsa: -Tanpri, mèt. Kite m' di ou yon ti pawòl. Ou pa bezwen fache sou mwen. Mwen konnen ki di ou menm di farawon an. ");
INSERT INTO hat_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mèt, ou te mande nou èske papa nou la, èske nou gen lòt frè. ");
INSERT INTO hat_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nou te reponn ou: Wi, nou gen yon papa ki fin vye granmoun ak yon ti frè, pitit papa nou te fè nan vyeyès li. Ti bway la te gen yon lòt frè menm manman avè l'. Men, li mouri. Nan de pitit manman l' yo, se li menm ase ki rete. Lèfini papa nou renmen l' anpil. ");
INSERT INTO hat_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ou te mande nou pou nou mennen l' isit la pou ou te ka wè l'. ");
INSERT INTO hat_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nou te reponn ou, mèt, ti bway la pa t' ka kite papa l'. Si li kite l', chagren va touye papa a. ");
INSERT INTO hat_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Men, ou te kenbe pawòl ou pi rèd, ou te di nou si ti frè nou an pa vini ak nou, nou pa bezwen parèt devan ou. ");
INSERT INTO hat_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Lè nou tounen kay papa nou, nou rakonte l' tout sa ou te di nou. ");
INSERT INTO hat_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Apre sa, papa di nou: Tounen al achte manje pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nou di l': Non, papa. Nou pa ka desann paske si ti frè nou an pa ale ak nou, nou p'ap ka parèt devan chèf la. Men, si ou dakò pou ti frè nou an ale ak nou, n'a desann. ");
INSERT INTO hat_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Lè sa a, papa nou di: Nou konnen madanm mwen te fè de sèl pitit gason pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Gen yonn ki pati kite m'. Mwen kwè se bèt nan bwa ki dwe devore l', paske mwen pa janm wè l' jouk koulye a. ");
INSERT INTO hat_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Jòdi a, si nou pran sa a nan men m', si yon malè rive l', avèk tout laj sa ki sou tèt mwen an, mwen p'ap ka sipòte lapenn sa a, chagren va touye m'. ");
INSERT INTO hat_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Koulye a atò, mèt, si mwen tounen al jwenn papa m' san pitit gason l' sa a, ki de je nan tèt li, ");
INSERT INTO hat_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","kou la gade li wè pitit li a pa la, l'ap mouri. Se nou menm ki va lakòz lapenn sa a k'ap twòp pou granmoun lan. Papa nou va mouri sou kont nou. ");
INSERT INTO hat_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Wi, se mwen menm ki te bay papa m' garanti m'ap tounen ak pitit la. Mwen te di l': Si m' pa mennen l' tounen ba li, se mwen menm k'ap pote fòt la devan l' jouk jou mwen mouri. ");
INSERT INTO hat_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Se poutèt sa, mèt, tanpri, kite ti bway la ale avèk frè l' yo, kite m' pran plas li. Gade m' pou esklav ou. ");
INSERT INTO hat_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mwen pa konnen ki pye pou m' ta mete devan pou m' tounen kay papa m' san ti gason an pa avèk nou. Mwen pa ta vle wè lapenn sa a tonbe sou papa m'. ");
INSERT INTO hat_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Jozèf pa t' kapab kenbe ankò devan tout moun ki t'ap sèvi l' yo. Li di byen fò: -Fè tout moun soti. Se konsa, pesonn pa t' la avèk Jozèf lè li fè frè l' yo rekonèt li. ");
INSERT INTO hat_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Li te pran kriye byen fò, tèlman fò moun peyi Lejip yo te tande l'. Bri a te rive jouk lakay farawon an. ");
INSERT INTO hat_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Jozèf di frè l' yo: -Se mwen menm Jozèf. Eske papa m' vivan toujou? Men frè l' yo pa t' kapab reponn li paske yo te boulvèse lè yo wè l' devan yo. ");
INSERT INTO hat_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Jozèf di frè l' yo: -Pwoche vin pi pre m'. Yo pwoche, li di yo: -Se mwen menm Jozèf wi, frè nou an. Se mwen menm wi nou te vann bay moun ki tapral peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Men koulye a, nou pa bezwen boulvèse. Nou pa bezwen règrèt nou te vann mwen pou yo mennen m' isit la. Se Bondye ki te voye m' devan pou m' te ka sove lavi nou. ");
INSERT INTO hat_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Sa fè dezan depi grangou tonbe sou peyi a. Men, p'ap gen mwayen travay latè ni fè rekòt pou senk lanne ankò. ");
INSERT INTO hat_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Bondye te voye m' vini devan pou ras nou an pa t' fini nan peyi a, pou m' te ka sove lavi nou, pou nou pa mouri. ");
INSERT INTO hat_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Nou wè. Se pa nou menm ki te voye m' isit la, men se Bondye. Se Bondye menm ki mete m' sèvi yon papa pou farawon an. Mwen se chèf nan tout kay li, se mwen k'ap gouvènen tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Koulye a, prese tounen kay papa m'. Al di l': Men sa Jozèf, pitit gason l' lan, voye di l': Bondye mete m' chèf sou tout peyi Lejip la. Desann vin jwenn mwen. Pa mize. ");
INSERT INTO hat_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ou pral rete nan peyi Gochenn. Konsa, w'a toupre m', ou menm ansanm ak pitit ou yo, pitit pitit ou yo, mouton ou yo, bèf ou yo ak tout sa ou genyen. ");
INSERT INTO hat_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Lè wa Gochenn, m'a pran swen ou, paske grangou a la pou senk lanne ankò. ");
INSERT INTO hat_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Koulye a, nou wè, pa vre. Benjamen, frè m' lan, wè tout se mwen menm menm Jozèf k'ap pale ak nou an. ");
INSERT INTO hat_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Fè papa m' konnen jan moun respekte m' isit nan peyi Lejip. Rakonte l' tou sa nou wè. Prese mennen papa m' desann isit la. ");
INSERT INTO hat_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Epi li lage kò l' nan bra Benjamen, frè li a, li konmanse kriye ankò. Benjamen tout t'ap kriye sou zepòl li. ");
INSERT INTO hat_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Apre sa, li bo tout frè li yo, li t'ap kriye toujou. Lèfini, frè l' yo pran pale ak li. ");
INSERT INTO hat_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Lè moun lakay farawon yo vin konnen frè Jozèf yo te vini, sa te fè farawon an ak chèf li yo kontan. ");
INSERT INTO hat_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farawon an di Jozèf konsa: -Pale ak frè ou yo. Di yo men sa pou yo fè: Chaje bèt yo, ale nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Lè y'a rive, y'a pran papa yo ak tout fanmi yo, y'a tounen vin jwenn mwen. m'a ba yo pi bon tè ki nan peyi Lejip la pou fè jaden. Y'a manje pi bon manje ki gen nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ou menm poutèt pa ou, w'a di yo sa pou yo fè. Y'a pran kèk cha nan peyi Lejip la pou timoun yo ak madanm yo. Y'a mennen papa yo vini. ");
INSERT INTO hat_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Yo pa bezwen règrèt kite anyen, paske se pi bon bagay nan tout peyi Lejip la m'ap ba yo. ");
INSERT INTO hat_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Se sa menm pitit Izrayèl yo te fè. Jozèf ba yo kèk cha jan farawon an te ba li lòd la. Li ba yo pwovizyon pou fè vwayaj la. ");
INSERT INTO hat_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Li ba yo chak yon rad tout nèf. Men, li bay Benjamen twasan (0300) pyès lajan ak senk rad nèf. ");
INSERT INTO hat_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Apre sa, li pran dis mal bourik chaje ak pi bon bagay ki te nan peyi Lejip la, dis fenmèl bourik chaje ak ble ak pen ak tout kalite lòt pwovizyon ankò, li voye bay papa l' pou l' ka fè vwayaj la. ");
INSERT INTO hat_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Lè l'ap voye frè l' yo pati, li di yo: -Piga nou chache kont yonn ak lòt nan chemen an, tande. ");
INSERT INTO hat_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yo kite peyi Lejip, yo rive Kanaran lakay Jakòb, papa yo. ");
INSERT INTO hat_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Yo di l': -Papa, Jozèf la toujou wi. Se li menm k'ap gouvènen peyi Lejip la wi. Men, Jakòb rete tout frèt, paske li pa t' kwè yo. ");
INSERT INTO hat_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Men, lè yo rakonte l' tout sa Jozèf te di yo, lè li wè cha Jozèf te voye pou l' te ka vwayaje a, Jakòb gen yon sèl kontantman ki pran l'. ");
INSERT INTO hat_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Li di yo: -Se kont. Jozèf, pitit mwen an, vivan toujou. Fòk m ale pou m' ka wè l' anvan m' mouri. ");
INSERT INTO hat_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Izrayèl pati avèk tout sa li te genyen. li al Bècheba, li touye bèt, li ofri yo bay Bondye Izarak, papa li. ");
INSERT INTO hat_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Jou lannwit sa a, Bondye pale ak Izrayèl nan rèv, li di l': -Jakòb! Jakòb! Jakòb reponn: -Men mwen wi. ");
INSERT INTO hat_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Bondye di li: -Mwen se Bondye, Bondye papa ou la. Ou pa bezwen pè desann ale nan peyi Lejip paske m'ap fè pitit pitit ou yo tounen yon gwo pèp laba a. ");
INSERT INTO hat_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","M'ap desann avè ou nan peyi Lejip, m'ap fè pitit pitit ou yo tounen isit la ankò. Se Jozèf ki va fèmen je ou lè wa mouri. ");
INSERT INTO hat_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jakòb pati, li kite Bècheba. Pitit Izrayèl yo pran Jakòb, papa yo, ansanm ak timoun yo ak madanm yo, yo fè yo moute sou cha farawon an te voye pou yo vwayaje a. ");
INSERT INTO hat_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yo pran tout bèt ak tout byen yo te fè nan peyi Kanaran an. Yo desann nan peyi Lejip. Yo mennen Jakòb desann nan peyi Lejip ak tout pitit pitit li yo. ");
INSERT INTO hat_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Jakòb pran pitit gason l' yo ak pitit fi l' yo, pitit pitit li yo, fi kou gason, li desann nan peyi Lejip ak yo tout. ");
INSERT INTO hat_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Men non pitit Izrayèl yo ansanm ak pitit pitit yo ki te desann nan peyi Lejip: Jakòb ak pitit gason l' yo. Premye gason an te rele Woubenn. ");
INSERT INTO hat_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Men non pitit Woubenn yo: Enòk, Palou, Ezwon ak Kami. ");
INSERT INTO hat_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Men non pitit Simeyon yo: Jemouyèl, Jamen, Orad, Jaken, Zoka ak Sayil. Li te fè dènye sa a ak yon fanm peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Men non pitit gason Levi yo: Gèchon, Keyat ak Merari. ");
INSERT INTO hat_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Men non pitit gason Jida yo: Er, Onan, Chela, Perèz ak Zerak. Men Er ak Onan te mouri nan peyi Kanaran. Perèz te gen de pitit gason: Ezwon ak Amoul. ");
INSERT INTO hat_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Men non pitit Isaka yo: Tola, Pouva, Jòb ak Chimwon. ");
INSERT INTO hat_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Men non pitit Zabilon yo: Serèd, Elon ak Jaleyèl. ");
INSERT INTO hat_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Se pitit sa yo Leya te fè pou Jakòb lè yo te Mezopotami. Leya te fè yon fi tout yo te rele Dena. Avèk pitit pitit yo, sa te fè antou tranntwa gason ak yon fi. ");
INSERT INTO hat_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Men non pitit gason Gad yo: Zifjon, Agi, Chouni, Ezbon, Eri, Awodi ak Areyèli. ");
INSERT INTO hat_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Men non pitit gason Asè yo: Jimna, Jichva, Jichvi epi Beria. Yo te gen yon sè ki te rele Serak. Beria te gen de pitit gason: Ebè ak Malkyèl. ");
INSERT INTO hat_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Se pitit gason sa yo Zilpa te fè pou Jakòb. Zilpa sa a, se te sèvant Laban te bay Leya, pitit fi li a. Avèk pitit pitit yo, sa te fè antou sèz moun. ");
INSERT INTO hat_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Men non pitit gason Rachèl, madan Jakòb: Jozèf ak Benjamen. ");
INSERT INTO hat_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Pandan Jozèf te nan peyi Lejip, Asnat, pitit fi Potifera, prèt lavil On an, te fè Manase ak Efrayim pou li. ");
INSERT INTO hat_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Men non pitit Benjamen yo: Bela, Bekè, Achbèl, Gera, Naaman, Ei, Wòch, Moupen, Oupim epi Ad. ");
INSERT INTO hat_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Se pitit gason sa yo Rachèl te fè pou Jakòb. Avèk pitit pitit yo, sa te fè antou katòz moun. ");
INSERT INTO hat_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Men non pitit gason Dann lan: Ouchim. ");
INSERT INTO hat_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Men non pitit gason Neftali yo: Jazeyèl, Gouni, Jezè epi Chilèm. ");
INSERT INTO hat_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Se pitit gason sa yo Bila te fè pou Jakòb. Bila sa a, se te sèvant Laban te bay Rachèl, pitit fi li a. Avèk pitit pitit yo, sa te fè antou sèt moun. ");
INSERT INTO hat_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Antou sa te fè swasannsis moun, pitit ak pitit pitit ki te desann nan peyi Lejip ansanm ak Jakòb, san konte madanm pitit li yo. ");
INSERT INTO hat_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Avèk Jozèf ki te gen tan fè de pitit nan peyi Lejip, sa te fè antou swasanndis moun laras Jakòb ki te vin nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Izrayèl te voye Jida devan al mande Jozèf pou l' vin jwenn li Gochenn. ");
INSERT INTO hat_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Jozèf fè pare cha li a, li moute, li al Gochenn, li al kontre papa l'. Rive Jozèf rive devan papa l', li lage kò l' nan bra l', li pase yon bon tan ap kriye sou zepòl li. ");
INSERT INTO hat_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Izrayèl di Jozèf konsa: -Koulye a, mwen wè figi ou, mwen konnen ou vivan toujou, mwen mèt mouri. ");
INSERT INTO hat_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Epi Jozèf di frè l' yo ak tout fanmi papa l' yo: -Mwen pral avèti wa a. Mwen pral di l': men frè m' yo ak tout fanmi papa m' yo ki t'ap viv nan peyi Kanaran vin jwenn mwen isit la. ");
INSERT INTO hat_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Se gadò mouton yo ye. Se bèt yo konn gade. Yo mennen tout mouton yo ak tout bèf yo ansanm ak tout sa yo genyen. ");
INSERT INTO hat_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Lè farawon an va rele nou pou mande nou ki metye nou, ");
INSERT INTO hat_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","n'a reponn li: Monwa, depi nou tout piti jouk koulye a, se bèt n'ap gade, tankou tout zansèt nou yo. Konsa, nou ka rete nan peyi Gochenn lan. Li te di yo sa paske moun peyi Lejip yo pa ka sipòte wè moun k'ap gade bèt viv nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Apre sa, Jozèf al avèti farawon an li di l': -Men papa m' ak frè m' yo rive soti nan peyi Kanaran, yo vini ak mouton yo, bèf yo ak tout sa yo genyen. Koulye a menm yo Gochenn. ");
INSERT INTO hat_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Jozèf te pran senk nan frè l' yo avèk li, li prezante yo bay farawon an. ");
INSERT INTO hat_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farawon an di yo konsa: -Ki metye nou? Yo reponn li: -Metye nou se gade bèt tankou zansèt nou yo. ");
INSERT INTO hat_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Apre sa, yo di farawon an: -Nou vin pou nou ka rete nan peyi a, paske pa gen manje ankò nan peyi nou pou bèt yo manje. Lèfini, grangou a rèd anpil nan peyi Kanaran. Tanpri, ban nou pèmisyon pou nou rete nan peyi Gochenn lan. ");
INSERT INTO hat_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farawon an di Jozèf: -Men papa ou ak frè ou yo vin jwenn ou isit la. ");
INSERT INTO hat_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","tout peyi Lejip la la devan ou. Chwazi pi bon tè nan peyi a, ba yo l' pou rete. Yo mèt rete sou tè Gochenn lan. Epi, si ou konnen gen nan mitan yo moun ki kapab pran swen bèt pa m' yo, ou mèt ba yo bèt mwen yo gade. ");
INSERT INTO hat_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Apre sa, Jozèf fè papa l' vini, li prezante l' bay farawon an. Lè Jakòb fin di farawon an bonjou, ");
INSERT INTO hat_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","farawon an mande l': -Ki laj ou? ");
INSERT INTO hat_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakòb reponn li: -Mwen gen santrantan (0130 an) depi m'ap moute desann sou latè. Men, mwen poko prèt pou m' rive laj zansèt mwen yo te rive lè yo t'ap fè moute desann pa yo. Mwen pa gen anpil laj, se vre. Men, mwen pa manke bat mizè. ");
INSERT INTO hat_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jakòb di farawon an orevwa, epi li ale. ");
INSERT INTO hat_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Jozèf fè papa l' ak frè l' yo rete nan peyi Lejip. Li ba yo tè bò lavil Ranmsès, jan farawon an te mande l' la. Li ba yo yon bon tè nan peyi a. ");
INSERT INTO hat_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Jozèf te bay papa l', frè l' yo ak tout fanmi yo kantite manje yo te bezwen pou mezi timoun yo te genyen. ");
INSERT INTO hat_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Grangou a te rèd anpil toupatou. pa t' gen manje ankò. Moun peyi Lejip ak moun peyi Kanaran yo t'ap fin deperi anba grangou a. ");
INSERT INTO hat_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Jozèf te fin ranmase dènye lajan moun peyi Lejip ak moun peyi Kanaran te genyen nan vann yo ble. Li pote tout lajan an lakay farawon an. ");
INSERT INTO hat_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Lè tout lajan moun yo fini nan peyi Lejip ak nan peyi Kanaran, tout moun peyi Lejip yo vin jwenn Jozèf, yo di l': -Ban nou manje non, souple. Pa kite nou mouri. Fè kichòy pou nou, nou pa gen lajan ankò. ");
INSERT INTO hat_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Jozèf di yo: -Si nou pa gen lajan, mennen bèt nou yo vini, n'a boukante yo pou manje. ");
INSERT INTO hat_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Se konsa, yo mennen bèt yo bay Jozèf pou fè boukantay. Li ba yo manje, yo ba li chwal, bèf, mouton, bourik. Pandan tout lanne a, li boukante manje ak yo pou valè bèt yo te genyen. ");
INSERT INTO hat_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Apre lanne a fin pase, yo tounen bò kote Jozèf ankò. Yo di li: -Nou p'ap kapab kache ou sa, mèt. Lajan nou fini nèt. Nou deja ba ou tout bèt nou te genyen. Koulye a, mèt, se tè nou yo ak pwòp tèt nou ase ki rete pou n' ba ou. ");
INSERT INTO hat_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pa kite nou mouri. Fè kichòy pou nou! Pa kite nou pèdi tè nou yo. Fè pri pou nou menm ansanm ak tout tè nou yo. N'ap tounen esklav farawon an. Tè nou yo va pou li tou. Men, ban nou plan pou nou simen nan jaden nou yo pou nou pa mouri, pou tè a pa fin tounen savann. ");
INSERT INTO hat_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Se konsa Jozèf achte tout tè Lejip la pou farawon an. tout moun peyi Lejip yo te vann li tè yo paske grangou a t'ap fini ak yo. tout peyi a vini pou farawon an. ");
INSERT INTO hat_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Jozèf fè tout moun toupatou nan peyi a tounen esklav farawon an. ");
INSERT INTO hat_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Se te prèt yo ase li pa t' manyen. Prèt yo pa t' bezwen tè pou yo manje, paske, dapre yon lwa ki gen nan peyi a, se farawon an menm ki te toujou peye yo. Se ak lajan sa a yo te viv. ");
INSERT INTO hat_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Jozèf di pèp la: -Jòdi a, mwen achte nou ansanm ak tout tè nou yo pou farawon an. Men grenn m'ap ban nou pou nou plante nan jaden nou yo. ");
INSERT INTO hat_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Lè sezon rekòt la va rive, n'a bay farawon an yon senkyèm (01/5) nan tou sa nou rekòlte. Rès la va pou nou, pou nou plante nan jaden nou yo, pou nou manje nou menm ansanm ak pitit nou yo ak tout moun ki lakay nou. ");
INSERT INTO hat_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Yo reponn li: -Ou sove lavi nou! Sèl sa nou mande ou, se pou ou aji byen ak nou. N'ap rete esklav farawon an. ");
INSERT INTO hat_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Se konsa, Jozèf te pase yon regleman pou tout peyi Lejip la: dapre regleman sa a ki la jouk koulye a toujou, se pou yo bay farawon an yon senkyèm sou chak rekòt. Se sèlman tè prèt yo ki pa t' pou farawon an. ");
INSERT INTO hat_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Moun Izrayèl yo te rete nan peyi Lejip sou tè Gochenn lan. Yo vin gen anpil byen. Yo te fè anpil anpil pitit. Yo t'ap fè toujou. ");
INSERT INTO hat_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakòb pase disèt lanne nan peyi Lejip. Li te rive gen sankarannsèt (0147) lanne sou tèt li. ");
INSERT INTO hat_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Lè sa a, Izrayèl vin wè li pa t' gen lontan pou l' viv ankò. Li fè rele Jozèf, pitit li a, li di l' konsa: -Si ou renmen m' vre, tanpri, fè m' sèman. Mete men ou nan fant janm mwen, pwomèt mwen w'ap kenbe pawòl ou, ou p'ap janm trayi m'. Tanpri, pa antere m' nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mwen vle pou yo antere m' menm kote ak zansèt mwen yo, lè m aval jwenn fanmi mwen yo ki mouri deja a. Se pou ou pran kadav mwen, pote l' soti peyi Lejip, al antere l' nan kavo fanmi m' yo. Jozèf reponn li: -m'a fè jan ou mande m' lan. ");
INSERT INTO hat_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Men, Jakòb di Jozèf konsa: -Fè m' sèman w'ap fè sa pou mwen! Jozèf sèmante ba li. Apre sa, Izrayèl bese kouche nan kabann li. ");
INSERT INTO hat_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kèk tan apre sa, yo vin fè Jozèf konnen papa l' malad. Jozèf pran Manase ak Efrayim, de pitit gason l' yo, ak li, li ale wè Jakòb. ");
INSERT INTO hat_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yo vin di Jakòb: -Men Jozèf, pitit ou, vin wè ou. Izrayèl ranmase dènye ti rès fòs li te genyen an, li leve chita sou kabann lan. ");
INSERT INTO hat_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakòb di Jozèf: -Bondye ki gen tout pouvwa a te parèt devan mwen yon kote yo rele Louz, nan peyi Kanaran. Li beni m'. ");
INSERT INTO hat_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Li di m' konsa: M'ap ba ou anpil pitit ak pitit pitit. M'ap fè yo tounen anpil nasyon. Ou wè tè sa a? M'ap bay pitit pitit ou yo li pou li rele yo pa yo pou tout tan. ");
INSERT INTO hat_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Bon. De pitit gason ou te fè nan peyi Lejip anvan m' te vin jwenn ou isit la a, se pitit mwen yo pral ye. Wi, Efrayim ak Manase ap pou mwen tankou Woubenn ak Simeyon. ");
INSERT INTO hat_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Men, tout pitit ou va fè apre yo, se pitit ou y'ap ye. Y'a pote non gran frè yo pou yo ka jwenn pa yo nan byen m' yo. ");
INSERT INTO hat_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Lè m' t'ap tounen soti nan peyi Mezopotami an, Rachèl, manman ou, te mouri nan men mwen. Li mouri sou wout pou ale peyi Kanaran, pa twò lwen lavil Efrata. Mwen antere l' la sou wout Efrata a. Se Efrata sa a yo rele Betleyèm lan tou. ");
INSERT INTO hat_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Lè Izrayèl wè pitit Jozèf yo, li mande: -Ki timoun sa yo? ");
INSERT INTO hat_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Jozèf reponn li: -Se pitit gason Bondye te ban mwen antan mwen isit la wi. Izrayèl di li: -Tanpri, fè yo pwoche pi pre m' pou m' ka beni yo. ");
INSERT INTO hat_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Izrayèl te fin granmoun, je l' pa t' bon menm. Li pa t' kapab wè ankò. Jozèf fè pitit li yo pwoche bò kote papa l'. Jakòb pran yo, li bo yo, li pase bra l' nan kou yo. ");
INSERT INTO hat_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Izrayèl di Jozèf konsa: -Mwen pa t' gen espwa wè figi ou ankò, men Bondye fè m' wè ata pitit ou yo. ");
INSERT INTO hat_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Jozèf wete timoun yo sou jenou Izrayèl, epi li bese tèt li jouk atè devan papa l'. ");
INSERT INTO hat_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Li pran timoun yo, Efrayim nan men dwat li ak Manase nan men gòch li. Konsa, Efrayim vin sou bò gòch Izrayèl, Manase menm sou bò dwat li. Li fè yo pwoche vin jwenn papa l'. ");
INSERT INTO hat_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Men, Izrayèl kwaze men l' lè l'ap lonje yo, li mete men dwat li sou tèt Efrayim ki te pi piti a, li mete men gòch li sou tèt Manase ki te pi gran an. Izrayèl te konnen sa l' t'ap fè lè l' te fè sa. ");
INSERT INTO hat_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Li beni Jozèf, li di l': -Se pou Bondye zansèt mwen yo, Bondye Abraram ak Izarak te sèvi tout lavi yo a, beni timoun sa yo. Se pou Bondye ki te pran swen mwen depi lè m' te fèt jouk jòdi a beni timoun yo. ");
INSERT INTO hat_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Se pou zanj Bondye ki te delivre m' anba tout move pa beni timoun yo. Se pou yo pote non mwen ak non zansèt mwen yo, Abraram ak Izarak. Se pou yo fè anpil pitit pitit, se pou yo peple sou tè a. ");
INSERT INTO hat_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Men Jozèf pa t' kontan lè li wè papa l' te mete men dwat li sou tèt Efrayim. Li kenbe men papa l' pou l' wete l' sou tèt Efrayim pou l' mete l' pito sou tèt Manase. ");
INSERT INTO hat_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Epi li di papa l': -Se pa konsa, papa. Men pi gran an bò isit. Mete men dwat ou sou tèt li. ");
INSERT INTO hat_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Men, papa a derefize. Li di l': -Mwen konnen, pitit mwen, mwen konnen. Manase tout ap vin yon pèp. Li menm tout l'ap grannèg. Men, ti frè l' la pral pi grannèg pase l'. Pitit li yo pral vin anpil nasyon. ");
INSERT INTO hat_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Jou sa a, li beni yo, li di: -Nan peyi pitit pitit Izrayèl yo, lè y'ap bay benediksyon, y'a nonmen non nou. y'a mande pou Bondye beni yon moun menm jan li te beni Efrayim ak Manase. Se konsa li te mete Efrayim anvan Manase. ");
INSERT INTO hat_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Apre sa, Izrayèl di Jozèf: -Gade. Mwen pral mouri. Men Bondye ap la avèk ou. La fè ou tounen nan peyi zansèt ou yo. ");
INSERT INTO hat_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Se pa pou lòt moun nan frè ou yo, se pou ou m'ap kite moso tè Sichèm lan. Se pòsyon tè sa a mwen te pran nan men moun Amori yo anba gwo goumen. ");
INSERT INTO hat_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakòb fè rele pitit gason l' yo, li di yo: -Sanble non. M'ap fè nou konnen sa ki pral rive nou nan jou k'ap vini yo. ");
INSERT INTO hat_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Sanble, vin koute non, pitit Jakòb yo! vin koute sa Izrayèl, papa nou, pral di nou. ");
INSERT INTO hat_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ou menm, Woubenn, premye pitit gason mwen, ou se fòs mwen, premye pitit mwen fè. Nan tout pitit mwen yo, se ou ki gen plis fòs, se ou ki pi gwonèg. ");
INSERT INTO hat_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ou tankou yon larivyè k'ap desann. Men, se pa ou k'ap alatèt, paske ou kouche ak yon madanm papa ou. Ou moute sou kabann mwen, ou fè sa ou pa t' dwe fè. ");
INSERT INTO hat_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeyon ak Levi se menm moun, se pwason kraze nan bouyon! Yo sèvi ak zam yo pou fè mechanste. ");
INSERT INTO hat_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mwen p'ap patisipe nan konplo yo. Mwen p'ap la avèk yo nan reyinyon yo. Paske lè yo ankòlè, yo touye moun. Yo koupe jarèt towo bèf pou dan ri. ");
INSERT INTO hat_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Madichon pou yo lè yo move paske yo san manman! M'ap fè yo rete toupatou nan peyi Jakòb la. M'ap gaye yo nan tout peyi Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ou menm, Jida, frè ou yo ap fè lwanj ou. W'ap kenbe lènmi ou yo dèyè kou. Pitit papa ou yo ap bese tèt devan ou. ");
INSERT INTO hat_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Jida, se yon jenn ti lyon. Lè ou fin fè ravaj, pitit mwen, ou tounen tounen ou. Ou kwoupi, ou kache kò ou tankou yon jenn ti lyon, tankou yon fenmèl lyon. Ki moun ki ka deranje ou? ");
INSERT INTO hat_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yo p'ap ka wete kòmandman an nan men Jida. Non. Baton kòmandman an p'ap soti nan mitan janm li, jouk tan moun tout pèp sou latè pral obeyi a va vini. ");
INSERT INTO hat_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","L'ap mare ti bourik li a nan yon pye rezen, l'ap mare pitit manman bourik li a nan pi bon pye rezen an. L'ap lave rad li nan diven, l'ap lave varèz li nan diven wouj kou san. ");
INSERT INTO hat_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Je l' wouj ak diven. Dan l' blan ak lèt. ");
INSERT INTO hat_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabilon pral rete bò lanmè. Batiman yo va jwenn bon pò sou rivaj li yo. Limit peyi l' la ap rive jouk Sidon. ");
INSERT INTO hat_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka, se yon bon bourik chay. Li kouche nan mitan de bò sakpay. ");
INSERT INTO hat_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Li wè jan kote li poze kò l' la nan gou li, li wè jan peyi a bèl. Li pare do l' pou l' pote chay li. Li tounen esklav pou l' travay di. ");
INSERT INTO hat_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dann ap yon chèf pou pèp li, tankou yon branch nan fanmi Izrayèl. ");
INSERT INTO hat_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dann ap tankou yon sèpan bò gran chemen an, yon sèpan mechan sou bò wout la. L'ap mòde chwal yo nan talon pou l' fè kavalye yo tonbe sou tèt. ");
INSERT INTO hat_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Seyè, m'ap tann ou vin sove mwen! ");
INSERT INTO hat_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ou menm, Gad, yon bann vòlò ap vin tonbe sou ou. Men, w'ap kouri dèyè yo, se ou k'ap mete men sou yo. ");
INSERT INTO hat_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Peyi Asè a ap bay bon manje k'ap bay fòs. L'ap donnen manje ki gou nan bouch wa yo. ");
INSERT INTO hat_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Neftali, se yon fenmèl kabrit ki lage. L'ap fè bèl ti pitit. ");
INSERT INTO hat_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Jozèf se boujon yon pye rezen ki konn donnen, li soti nan yon pye rezen bò sous dlo ki donnen byen. Branch li yo moute sou tout miray la. ");
INSERT INTO hat_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Y'ap chache l' kont, y'ap voye wòch sou li. Moun k'ap voye flèch yo tounen yon pèsekisyon pou li. ");
INSERT INTO hat_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Men, banza pa li a rete fèm, ponyèt li pa febli, gremesi pouvwa Bondye Jakòb la, Bondye ki gadò pèp Izrayèl la. Se li ki tout pwoteksyon yo. ");
INSERT INTO hat_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Sa soti nan Bondye papa ou la k'ap ede ou, nan Bondye ki gen tout pouvwa a k'ap beni ou avèk benediksyon lapli ki soti anwo nan syèl la, avèk benediksyon sous dlo k'ap soti anba tè a, avèk benediksyon ki soti nan tete ak nan vant manman. ");
INSERT INTO hat_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Benediksyon papa ou yo pi plis pase benediksyon mòn ki la pou tout tan yo. Se pou benediksyon sa yo tonbe sou tèt Jozèf, sou tèt moun Bondye te chwazi nan mitan tout frè l' yo. ");
INSERT INTO hat_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamen, se yon bèt nan bwa devoran. Nan maten, li manje bèt li kenbe a. Nan aswè, l'ap separe toujou sa l' te pran yo. ");
INSERT INTO hat_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Men douz branch fanmi Izrayèl yo. Men sa papa yo te di yo. Li beni yo, li bay chak moun benediksyon pa yo. ");
INSERT INTO hat_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Apre sa, Jakòb ba yo lòd sa a: -Mwen menm, mwen pral jwenn fanmi m' yo ki mouri deja. Antere m' menm kote ak zansèt mwen yo nan twou wòch ki nan jaden Efwon, moun Et la, ");
INSERT INTO hat_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nan twou wòch ki nan jaden Makpela a, anfas Manmre, nan peyi Kanaran. Se Abraram ki te achte twou wòch sa a ak tout jaden an nan men Efwon, moun Et la, pou sèvi l' simityè. ");
INSERT INTO hat_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Se la yo te antere Abraram ak Sara, madanm li. Se la yo te antere Izarak ak Rebeka, madanm li. Se la tout mwen te antere Leya. ");
INSERT INTO hat_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Se nan men mesye Et yo nou te achte jaden an ak tout twou wòch ki sou li a. ");
INSERT INTO hat_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Lè Jakòb fin pale konsa ak pitit gason l' yo, li lonje kò l' sou kabann lan, li mouri, li al jwenn fanmi li yo ki te mouri deja. ");
INSERT INTO hat_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Jozèf lage kò l' sou papa l', li kriye kont li, li bo l' nan figi. ");
INSERT INTO hat_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Apre sa, Jozèf rele dòktè ki t'ap sèvi l' yo, li fè yo pare kadav la. Se sa menm dòktè yo fè. ");
INSERT INTO hat_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Yo pran karant jou pou pare kadav la jan yo konn fè l' la. Apre sa, moun peyi Lejip yo pase swasanndi jou ap kriye pou li. ");
INSERT INTO hat_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Lè tout swasanndi jou yo fin pase, jou pou antèman an rive. Jozèf pale ak moun lakay farawon yo, li di yo konsa: -Tanpri souple, rann mwen sèvis sa a. Pote komisyon sa a bay farawon an pou mwen. ");
INSERT INTO hat_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Di l' pou mwen: Anvan papa m' te mouri li te fè m' sèmante pou m' te antere l' nan kavo li te fè pare pou li nan peyi Kanaran. Tanpri, kite m' moute al antere papa m'. Apre sa, m'a tounen. ");
INSERT INTO hat_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farawon an voye reponn li: -Ou mèt al antere papa ou, jan ou te sèmante ba li a. ");
INSERT INTO hat_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Se konsa Jozèf moute al antere papa l'. tout moun lakay farawon yo, tout chèf ak tout notab peyi Lejip yo ale ak li, ");
INSERT INTO hat_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","ansanm ak tout fanmi Jozèf yo, frè l' yo, ak tout fanmi papa l' yo. Men yo te kite tout timoun piti yo Gochenn ansanm ak bèt yo, mouton, kabrit ak bèf. ");
INSERT INTO hat_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Te gen anpil cha ak anpil kavalye sou chwal ki t ale avek li. Kifè pa t' manke moun nan lantèman an. ");
INSERT INTO hat_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Lè yo rive nan glasi Atad ki lòt bò larivyè Jouden, kote sòlèy leve a, yo pran rele byen fò. Jozèf te fè yo fè sèvis la pandan sèt jou pou papa l'. ");
INSERT INTO hat_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Lè moun peyi Kanaran yo wè sèvis lantèman yo t'ap fè Atad la, yo di: -Ala yon grannèg ki mouri lakay moun peyi Lejip yo papa! Se poutèt sa yo rele glasi ki lòt bò larivyè Jouden an: Glasi lapenn moun peyi Lejip yo. ");
INSERT INTO hat_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Konsa, pitit gason Jakòb yo te fè jan papa yo te ba yo lòd fè a. ");
INSERT INTO hat_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Yo pote kadav li nan peyi Kanaran, yo antere l' nan twou wòch ki te nan jaden Makpela a, anfas Manmre. Se jaden sa a Abraram te achte nan men Efwon, moun Et la, pou sèvi l' simityè. ");
INSERT INTO hat_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Apre Jozèf fin antere papa l', li tounen Lejip ansanm ak frè l' yo ak tout moun ki te moute avè l' pou lantèman papa l' la. ");
INSERT INTO hat_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Apre lanmò papa yo, frè Jozèf yo di: -Ou pa janm konnen. Jozèf ka kenbe nou nan kè, li ka fè nou peye tout sa nou te fè l' yo. ");
INSERT INTO hat_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Se konsa yo voye di Jozèf: -Men komisyon papa te ban nou pou ou anvan l' te mouri: ");
INSERT INTO hat_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Men sa n'a di Jozèf pou mwen: Tanpri, padonnen krim frè ou yo te fè ou la. Padonnen peche yo paske yo te fè ou mal anpil. Koulye a atò, tanpri, padonnen mal nou te fè ou la, nou menm k'ap sèvi Bondye papa ou la. Lè Jozèf tande pawòl sa a, li pran kriye. ");
INSERT INTO hat_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Apre sa, frè l' yo vini yo menm menm, yo bese tèt yo jouk atè devan li, yo di l' konsa: -Men nou pote tèt nou pou nou sèvi ou domestik. ");
INSERT INTO hat_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Jozèf di yo: -Nou pa bezwen pè. Mwen pa kapab pran plas Bondye. ");
INSERT INTO hat_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nou te moute konplo pou fè m' mal. Men Bondye fè sa tounen yon byen, pou l' te fè sak rive jòdi a rive, pou l' te ka sove lavi tout kantite moun sa yo. ");
INSERT INTO hat_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Non. Nou pa bezwen pè. M'ap okipe nou, nou menm ansanm ak tout pitit nou yo. Se konsa, Jozèf te pale byen ak frè l' yo, li te di yo pawòl ki te touche kè yo, li remoute kouraj yo. ");
INSERT INTO hat_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Jozèf te rete nan peyi Lejip ak tout fanmi papa l' yo. Li te gen sandizan (0110 an) lè l' mouri. ");
INSERT INTO hat_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Li te gen tan wè pitit ak pitit pitit Efrayim. Se nan men l' pitit Maki yo te fèt. Maki sa a te pitit Manase. ");
INSERT INTO hat_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Li di frè l' yo konsa: -Mwen pral mouri. Men mwen sèten Bondye gen pou vin ede nou. L'ap fè nou kite peyi sa a, l'ap fè nou tounen nan peyi li te sèmante l'ap bay Abraram, Izarak ak Jakòb la. ");
INSERT INTO hat_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Apre sa, Jozèf fè pitit Izrayèl yo sèmante ba li, li di yo: -Wi, Bondye gen pou vin ede nou. Lè sa a, tanpri, pote zosman m' yo moute ak nou. ");
INSERT INTO hat_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Lè Jozèf mouri li te gen sandizan (0110 an). Yo benyen kadav la, yo pare l' pou l' pa pouri. Yo mete l' nan yon sèkèy byen fèmen nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Men non pitit Jakòb yo ki te desann avè l' nan peyi Lejip ansanm ak tout fanmi yo: ");
INSERT INTO hat_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Se te Woubenn, Simeyon, Levi epi Jida, ");
INSERT INTO hat_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Zabilon epi Benjamen, ");
INSERT INTO hat_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dann ak Nèftali, Gad ak Asè. ");
INSERT INTO hat_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Sa te fè antou swasanndis moun nan ras Jakòb la. Jozèf menm te deja nan peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Apre sa, Jozèf mouri, tout frè l' yo mouri tou ansanm ak tout moun menm laj ak yo. ");
INSERT INTO hat_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Men pèp Izrayèl la te fè anpil pitit, yo te peple. Yo te vin anpil. Yo te vin fò, yo te toupatou nan peyi a. ");
INSERT INTO hat_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Te vin gen yon lòt wa nan peyi Lejip la. Wa sa a pa t' konn anyen sou Jozèf. ");
INSERT INTO hat_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Li di pèp la konsa: -Gade. Pèp Izrayèl la vin pi plis pase nou. Yo pi fò pase nou. ");
INSERT INTO hat_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tande non! Fòk nou jwenn yon jan wi, pou n' bat ak moun sa yo, pou yo pa vin plis toujou. Paske, si yon lagè pete la a, yo ka mete tèt ansanm ak lènmi nou yo pou yo bat nou. Apre sa, y'a pati kite peyi a. ");
INSERT INTO hat_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Se konsa yo mete kèk chèf sou pèp Izrayèl la pou kraze kouraj yo, pou fè yo fè kòve travo fòse san pran souf. Moun pèp Izrayèl yo bati lavil Piton ak Ranmsès pou farawon an. Se nan lavil sa yo yo te fè depo manje. ");
INSERT INTO hat_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Men, tank moun Lejip yo t'ap peze moun pèp Izrayèl yo, se tank yo t'ap fè pitit, se plis yo t'ap peple. Moun Lejip yo vin rayi moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Se konsa, yo fè pèp Izrayèl la tounen esklav. ");
INSERT INTO hat_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Yo rann yo lavi minab, yo fè yo travay rèd ap bat mòtye, ap fè brik, ap fè tout lòt kalite kòve nan jaden. Yo bat yo, yo fòse yo fè tout kalite travay sa yo. ");
INSERT INTO hat_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Lè sa a, te gen de fanmchay ki te konn akouche medam ebre yo. Yonn te rele Chifra, lòt la te rele Pwa. Wa Lejip la rele yo, ");
INSERT INTO hat_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","li di yo: -Lè n'ap akouche medam ebre yo, lè yo sou choukèt, louvri je nou. Si pitit la se yon gason, touye l'. Men si se yon fi, kite l' viv. ");
INSERT INTO hat_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Men, fanmchay yo te gen krentif pou Bondye. Yo pa t' fe sa wa Lejip la te ba yo lòd fè a. Yo te kite ti gason yo viv tou. ");
INSERT INTO hat_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Lè sa a, wa a fè rele fanmchay yo, li mande yo: -Poukisa nou fè sa? Apa nou kite ti gason yo viv tou? ");
INSERT INTO hat_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Medam yo reponn: -Fanm ebre sa yo pa tankou fanm Lejip yo non. Yo gen kouraj sou yo wi. Anvan fanmchay la rive, yo gen tan akouche. ");
INSERT INTO hat_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Bondye te beni fanmchay yo. Moun pèp Izrayèl yo menm t'ap vin pi plis toujou. Yo t'ap vin pi fò. ");
INSERT INTO hat_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Paske fanmchay yo te gen krentif pou Bondye, Bondye te ba yo anpil pitit. ");
INSERT INTO hat_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Lè sa a, farawon an bay pèp la lòd sa a: -Se pou nou jete tout ti gason ki fèt lakay moun ebre yo nan gwo larivyè a. Men, kite tout ti fi yo viv. ");
INSERT INTO hat_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Yon nonm nan branch fanmi Levi a te marye ak yon fi nan menm branch fanmi an. ");
INSERT INTO hat_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Madanm li vin ansent, li fè yon pitit gason. Lè li wè jan ti pitit la te bèl, li kache l' pandan twa mwa. ");
INSERT INTO hat_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Men, li pa t' kapab kache l' pi lontan pase sa. Se konsa, li pran yon panyen jon, li badijonnen l' byen badijonnen ak goudwon ansanm ak gonm bwapen. Li mete ti pitit la ladan l'. Lèfini, li mete panyen an ak tout pitit la ladan l' nan mitan yon touf wozo, sou bò gwo larivyè a. ");
INSERT INTO hat_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Sè ti pitit la menm te rete kanpe yon ti distans pou l' wè sak tapral rive pitit la. ");
INSERT INTO hat_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Pitit fi farawon an desann bò gwo larivyè a pou l' al benyen. Medam ki te avè l' yo t'ap mache bò larivyè a. Fi farawon an wè panyen an nan mitan touf wozo yo. Li voye sèvant li a al pran l'. ");
INSERT INTO hat_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Li louvri panyen an, li wè ti pitit la: se te yon ti gason ki t'ap kriye. Kè l' fè l' mal pou li. Li di: -Se yonn nan timoun ebre yo. ");
INSERT INTO hat_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Lè sa a, sè ti gason an pwoche, li di pitit fi farawon an: -Eske ou vle m al chache yon nouris pou ou nan mitan medam ebre yo pou bay ti pitit la tete pou ou? ");
INSERT INTO hat_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Fi Farawon an di li: -Ale non. Ti fi a al chache manman ti pitit la. ");
INSERT INTO hat_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fi farawon an di manman an konsa: -Pran ti pitit sa a, mete l' nan tete pou mwen. m'a peye ou pou sa. Madanm lan pran ti pitit la, li ba l' tete. ");
INSERT INTO hat_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Lè ti gason an vin gran ti bway, li mennen l' bay fi farawon an ki adopte l' pou pitit li. Lè sa a, fi farawon an di: -Se nan dlo mwen wete l'. Se konsa, li rele l' Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Lè sa a, Moyiz te fin grandi. Yon jou, li soti pou l' al vizite moun pèp Izrayèl parèy li yo. Li wè jan yo t'ap fè yo travay di. Li wè yon moun peyi Lejip ki t'ap bimen yon ebre anba kou, yonn nan moun parèy li yo. ");
INSERT INTO hat_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Li voye je l' adwat, li voye je l' agoch, li pa wè pesonn. Li touye moun pèyi Lejip la, li fouye yon twou nan sab la, li kache kadav la. ");
INSERT INTO hat_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Nan denmen, li soti ankò, li wè de ebre ki t'ap goumen. Li di sa ki te antò a: -Poukisa w'ap maltrete moun menm ras ak ou konsa? ");
INSERT INTO hat_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Men, nonm lan reponn li: -Kilès ki mete ou chèf pou kòmande nou? Gen lè ou vle touye m' menm jan ou te touye moun peyi Lejip la? Moyiz vin pè, li di nan kè l': -Aa! Gen moun ki konnen sa m' te fè a! ");
INSERT INTO hat_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farawon an pran nouvèl sak te pase. Li t'ap chache Moyiz pou touye l'. Men Moyiz chape kò l' anba men l', l' al rete nan peyi Madyan. Rive la, li chita bò yon pi. ");
INSERT INTO hat_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Prèt peyi Madyan an te gen sèt pitit fi. Yo te vin tire dlo pou plen ganmèl yo pou bay mouton papa yo bwè. ");
INSERT INTO hat_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Men, kèk lòt gadò mouton vin rive, yo kouri dèyè medam yo. Moyiz leve, li pran defans yo, epi li bay mouton medam yo bwè. ");
INSERT INTO hat_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Lè medam yo tounen lakay Reouyèl, papa yo, li mande yo: -Ki jan nou fè tounen vit konsa jòdi a? ");
INSERT INTO hat_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Yo reponn li: -Se yon moun peyi Lejip ki te delivre nou anba men gadò mouton yo. Apre sa, se li menm ankò ki tire dlo pou nou bay bèt yo bwè. ");
INSERT INTO hat_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Reouyèl mande pitit fi li yo: -Kote msye? Poukisa nou kite l' laba a? Al rele l' pou l' vin pran kichòy ak nou. ");
INSERT INTO hat_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moyiz te dakò pou l' te rete lakay nonm sa a. Reouyèl bay Moyiz Sefora, yonn nan pitit fi li yo, pou madanm. ");
INSERT INTO hat_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sefora fè yon ti gason. Lè sa a, Moyiz di: -Se moun vini mwen ye nan yon peyi etranje. Se konsa, li te rele pitit la Gèchon. ");
INSERT INTO hat_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Lontan apre sa, wa Lejip la mouri. Pèp Izrayèl la t'ap plenn pi rèd anba esklavaj. Yo t'ap rele gras mizèrikòd. Bondye te tande jan yo t'ap rele, jan yo t'ap plenn anba esklavaj la. ");
INSERT INTO hat_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Bondye tande rèl yo, li vin chonje kontra li te pase ak Abraram ak Izarak epi ak Jakòb. ");
INSERT INTO hat_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Bondye te wè nan ki sitiyasyon moun pèp Izrayèl yo ye, li pran kòz yo nan men l'. ");
INSERT INTO hat_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moyiz t'ap gade mouton ak kabrit Jetwo, bòpè li, ki te yon prèt nan peyi Madyan. Moyiz mennen bèt yo lòt bò dezè a. Li rive sou mòn Orèb, mòn Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Zanj Seyè a parèt devan l' sou fòm yon flanm dife nan mitan yon ti touf bwa. Moyiz gade, li wè touf bwa a te tou wouj ak dife, men li pa t'ap boule. ");
INSERT INTO hat_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Lè sa a, Moyiz di nan kè l': -Kite m' pwoche pi pre pou m' wè bagay dwòl sa a. Kouman touf bwa a fè pa boule? ");
INSERT INTO hat_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Lè Seyè a wè Moyiz t'ap pwoche pou l' gade, li rete nan mitan touf bwa a, li rele l', li di: -Moyiz! Moyiz! Moyiz reponn: -Men mwen wi. ");
INSERT INTO hat_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Bondye di: -Rete kote ou ye a. Pa pwoche. Wete sapat nan pye ou, paske kote ou kanpe a se yon tè ki apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Bondye di ankò: -Se mwen menm, Bondye zansèt ou yo, Bondye Abraram lan, Bondye Izarak la ak Bondye Jakòb la. Moyiz bouche figi l', paske li te pè gade Bondye. ");
INSERT INTO hat_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Seyè a di: -Mwen wè tray pèp mwen an ap pase nan peyi Lejip. Mwen tande jan y'ap rele anba men moun k'ap peze yo. Wi, mwen konnen jan y'ap soufri. ");
INSERT INTO hat_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Mwen desann pou m' vin delivre yo anba men moun peyi Lejip yo, pou m' fè yo soti nan peyi Lejip la, pou m' mennen yo nan yon gwo peyi ki gen bon tè, yon peyi kote lèt ak siwo myèl koule tankou dlo. Se la moun Kanaran yo rete ansanm ak moun Et yo, moun Amori yo, moun Ferezi yo, moun Evi yo ak moun Jebis yo. ");
INSERT INTO hat_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Bondye di ankò: -Koulye a menm, rèl pitit Izrayèl yo rive jouk nan zòrèy mwen. Mwen wè jan y'ap soufri anba moun peyi Lejip yo k'ap peze yo. ");
INSERT INTO hat_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Koulye a, ale! Se mwen menm k'ap voye ou bò kote farawon an. Fè pèp mwen an soti nan peyi Lejip. Wi, fè pèp Izrayèl la soti kite peyi sa a. ");
INSERT INTO hat_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moyiz di Bondye: -Ki moun mwen ye menm pou m' ta penmèt mwen ale bò kot farawon an pou m' fè pèp Izrayèl la soti kite peyi Lejip? ");
INSERT INTO hat_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Bondye di l': -M'ap kanpe la avè ou. Lèfini, pou fè konnen se mwen menm ki voye ou, men sa w'a fè: lè w'a fin fè pèp la soti kite peyi Lejip, n'a sèvi m' sou mòn sa a. ");
INSERT INTO hat_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moyiz di Bondye konsa: -Bon. Koulye a, mwen pral bò kote pèp Izrayèl la, mwen pral di yo: Bondye zansèt nou yo voye m' kote nou. Ou mèt sèten yo pral mande m': Ki jan li rele? Lè sa a, kisa pou m' reponn yo? ");
INSERT INTO hat_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Bondye di Moyiz: -Sa m' ye a se sa m' ye. Apre sa li di ankò: -W'a pale ak moun pèp Izrayèl yo, w'a di yo konsa: Mwen menm ki rele sa m' ye a, se mwen menm ki voye ou bò kote yo. ");
INSERT INTO hat_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Bondye di Moyiz ankò: -Men sa pou di moun pèp Izrayèl yo. Seyè a, Bondye zansèt nou yo, Bondye Abraram lan, Bondye Izarak la, Bondye Jakòb la, voye m' bò kote nou. Wi, se konsa mwen rele. Se konsa y'ap toujou rele m' sou latè de tit an tit. ");
INSERT INTO hat_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ale non. Reyini tout chèf fanmi pèp Izrayèl la, di yo: Seyè a, Bondye zansèt nou yo, Bondye Abraram lan, Bondye Izarak la, Bondye Jakòb la, te parèt devan mwen. Li mande m' pou m' di nou pou li: Mwen vin vizite nou, mwen wè sa moun peyi Lejip yo ap fè nou pase. ");
INSERT INTO hat_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Se poutèt sa mwen di: M'ap fè nou soti kite peyi Lejip kote y'ap maltrete nou an. M'ap mennen nou nan peyi moun Kanaran yo, moun Et yo, moun Amori yo, moun Ferezi yo, moun Evi ak moun Jebis yo. Se yon peyi kote lèt ak siwo myèl koule tankou dlo. ");
INSERT INTO hat_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Chèf fanmi yo va koute sa ou gen pou di yo. Apre sa, wava ale bò kote wa Lejip la ansanm ak chèf fanmi pèp Izrayèl yo, n'a di wa a: Seyè a, Bondye ebre yo, te parèt devan nou. Kite n al fe yon ti vwayaj nan dezè a. Lè n'a fin mache pandan twa jou, n'a rete pou n' touye bèt n'ap ofri bay Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mwen konnen wa peyi Lejip la p'ap kite nou ale, si yo pa fòse l'. ");
INSERT INTO hat_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Se poutèt sa, m'ap lonje men m', m'ap frape peyi Lejip. M'ap fè tout kalite mirak nan peyi a. Apre sa, l'a kite nou ale. ");
INSERT INTO hat_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","m'a fè mèvèy jouk tan moun peyi Lejip yo va aji byen ak pèp mwen an. Konsa, lè n'a pare pou nou pati kite yo, nou p'ap soti san anyen nan men nou. ");
INSERT INTO hat_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Chak fanm va mande vwazin li pou yo ba li rad ak bijou an ajan ak bijou an lò. L'a fè menm bagay la ak fanm pèyi Lejip ki rete lakay li yo. Lèfini, n'a mete yo sou pitit gason ak pitit fi nou yo. Konsa, n'a pran tou sa moun peyi Lejip yo genyen. ");
INSERT INTO hat_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moyiz reponn li: -Men, moun yo ka refize kwè m', yo ka pa koute sa m' gen pou m' di yo a. Yo ka di m' se pa vre, Seyè a pa t' kras parèt devan mwen. ");
INSERT INTO hat_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Seyè a mande l': -Kisa ou gen nan men ou la a? Moyiz reponn li: -Yon baton. ");
INSERT INTO hat_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Seyè a di l': -Jete l' atè. Moyiz jete baton an atè. Baton an tounen yon koulèv. Lè Moyiz wè sa, li pran kouri. ");
INSERT INTO hat_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Seyè a di Moyiz: -Lonje men ou, bese pran koulèv la nan ke. Moyiz lonje men l', li pran koulèv la nan ke. Lamenm, koulèv la tounen baton ankò nan men Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Seyè a di: -Men sa w'a fè pou yo ka kwè Seyè a, Bondye zansèt yo, Bondye Abraram lan, Bondye Izarak la, Bondye Jakòb la, te parèt devan ou. ");
INSERT INTO hat_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Seyè a di l' ankò: -Foure men ou anndan chemiz ou, sou lestonmak ou. Moyiz foure men li anndan chemiz li, sou lestonmak li. Lè li wete men l', men l' te vin tou blan ak bouton. Li te kouvri ak lalèp. ");
INSERT INTO hat_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Seyè a di l': -Foure men ou anndan chemiz ou ankò, sou lestonmak ou. Moyiz foure men li anndan chemiz li ankò. Lè li wete l', men li te menm koulè ak rès kò li. ");
INSERT INTO hat_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Seyè a di Moyiz: -Si apre ou fin fè premye mirak la, ou wè yo pa vle kwè ou, yo pa vle koute ou, y'a kwè ou lè w'a fè dezyèm mirak sa a. ");
INSERT INTO hat_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Si apre ou fè de mirak sa yo, y'ap fè tèt di toujou, yo pa vle kwè ou toujou, yo pa vle koute sa w'ap di yo, w'a pran ti gout dlo nan gwo larivyè a, w'a vide l' atè. Lamenm, dlo a va tounen san. ");
INSERT INTO hat_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moyiz di Seyè a: -Eskize m' wi, Seyè. Men, mwen pa ka pale fasil. Se pa bagay jòdi a non. Menm koulye a, depi w'ap pale ak sèvitè ou la, anyen pa chanje. Bouch mwen lou, lang mwen mare. ");
INSERT INTO hat_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Seyè a di l': -Kilès ki bay moun bouch pou yo pale? Kilès ki fè moun sa a bèbè, moun sa a soudè? Kilès ki fè moun sa a wè, moun sa a avèg? Eske se pa mwen menm, Seyè a? ");
INSERT INTO hat_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Bon, ou mèt ale. m'a ede ou lè ou gen pou ou pale, m'a moutre ou sa ou gen pou di. ");
INSERT INTO hat_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moyiz di: -Eskize m' wi, Seyè! Men, poukisa ou pa voye yon lòt moun pito? ");
INSERT INTO hat_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Lè sa a, Seyè a move sou Moyiz, li di l' konsa: -Gen Arawon, frè ou la, ki soti nan branch fanmi Levi a. Mwen konnen lang msye pa mare nan bouch li. Men koulye a, li gen tan nan wout ap vin jwenn ou. L'a kontan anpil lè l'a wè ou. ");
INSERT INTO hat_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","W'a pale avè l', w'a di l' sa pou l' di. m'a ede nou tou de lè n'a gen pou nou pale. m'a di nou sa pou nou fè. ");
INSERT INTO hat_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","L'a pale ak pèp la pou ou. Se tankou si se te ou menm ki t'ap pale. Ou menm, w'a tankou Bondye k'ap di li sa pou li di. ");
INSERT INTO hat_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Kanta baton sa a, toujou kenbe l' nan men ou. Se avèk li w'a fè tout mirak ou gen pou fè yo. ");
INSERT INTO hat_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moyiz kite kote l' te ye a, li tounen lakay Jetwo, bòpè li. Li di li: -Tanpri, kite m' ale. Mwen pral jwenn frè mwen yo nan pèyi Lejip. Mwen pral wè si yo la toujou. Jetwo di Moyiz: -Ale ak kè poze. ");
INSERT INTO hat_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Antan Moyiz nan peyi Madyan, Seyè a di l': -Koulye a, tounen nan peyi Lejip, paske tout moun ki t'ap chache touye ou yo fin mouri. ");
INSERT INTO hat_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moyiz pran madanm li ak pitit gason l' yo, li mete yo sou bourik, epi li tounen nan peyi Lejip. Moyiz te gen baton Bondye a nan men l'. ");
INSERT INTO hat_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Seyè a di Moyiz konsa: -Koulye a, ou wè w'ap tounen nan peyi Lejip. Gade byen. Se pou ou fè devan farawon an tout mirak mwen ba ou pouvwa fè yo. Mwen menm, m'ap fè l' kenbe tèt avèk ou, li p'ap vle kite pèp la ale. ");
INSERT INTO hat_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","W'a di farawon an: Men sa Seyè a di: Izrayèl se pitit mwen, se premye pitit mwen. ");
INSERT INTO hat_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Mwen di ou kite pitit mwen an ale fè wout li pou l' ka fè yon sèvis pou mwen. Si ou refize kite l' ale, mwen menm m'ap touye premye pitit gason ou lan. ");
INSERT INTO hat_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Pandan vwayaj la, Moyiz rete pase lannwit yon kote. Seyè a vin atake Moyiz. Li t'ap chache touye l'. ");
INSERT INTO hat_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Sefora pran yon moso ròch byen file, li koupe pwent po ti kòk pitit gason l' lan, li voye l' jete nan pye Moyiz. Epi li di: -Se yon mari san ou ye pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Apre sa, Seyè a kite Moyiz. Lè sa a, se poutèt sikonsizyon an Sefora te di ou se yon mari san pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Seyè a di Arawon: -Ale kontre Moyiz nan dezè a. Arawon pati, li kontre Moyiz sou mòn Bondye a. Li pase bra l' nan kou l'. ");
INSERT INTO hat_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moyiz di Arawon tou sa Seyè a te di l' anvan li te voye l' la. Li fè l' konnen tout mirak Seyè a te ba li lòd fè. ");
INSERT INTO hat_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moyiz ak Arawon pati ansanm, yo sanble tout chèf fanmi pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Arawon di yo tou sa Seyè a te di Moyiz. Moyiz menm fè tout mirak yo devan tout pèp la. ");
INSERT INTO hat_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Pèp la vin kwè yo. Lè yo tande Seyè a te vin vizite yo, li te wè mizè y'ap pase a, yo tonbe ajenou, yo bese tèt yo jouk atè pou adore Bondye. ");
INSERT INTO hat_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Apre sa, Moyiz ak Arawon ale bò kote farawon an. Yo di l' konsa: -Men sa Seyè a, Bondye pèp Izrayèl la, voye di ou: Kite pèp mwen an ale pou yo ka fè yon fèt pou mwen nan dezè a. ");
INSERT INTO hat_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farawon an reponn: -Kilès ki Seyè a pou m' ta swiv lòd li, pou m' kite pèp Izrayèl la ale? Mwen pa konnen Seyè sa a. Mwen p'ap kite pèp Izrayèl la al ankenn kote. ");
INSERT INTO hat_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Moyiz ak Arawon di l': -Bondye ebre yo te parèt devan nou. Tanpri, kite n al fè yon ti vwayaj nan dezè a. Lè n'a fin mache pandan twa jou, n'a rete pou n' touye bèt n'ap ofri bay Seyè a, Bondye nou an. Si nou pa fè sa, l'a voye move maladi sou nou, osinon l'a fè nou mouri nan lagè. ");
INSERT INTO hat_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Wa Lejip la di Moyiz ak Arawon: -Poukisa nou vle fè pèp la kite travay li? Tounen nan travay nou! ");
INSERT INTO hat_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farawon an di ankò: -Gade. Nou wè jan pèp sa a vin pi plis pase moun peyi a. Koulye a atò, nou ta vle pou yo kite travay yo? ");
INSERT INTO hat_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Menm jou sa a, farawon an rele moun peyi Lejip ki te chèf kòve yo ansanm ak moun pèp Izrayèl ki te fòmann yo, li ba yo lòd sa a: ");
INSERT INTO hat_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","-Pa janm bay moun sa yo pay ankò pou yo fè brik, jan nou te konn fè l' la. Se yo menm ki pou al ranmase pay yo bezwen. ");
INSERT INTO hat_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Men, se pou yo founi menm valè brik yo te konn bay anvan an, san manke yonn. Se yon bann parese yo ye. Se poutèt sa y'ap kriye, y'ap di: O wi, ann al ofri bèt pou nou touye bay Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Fè yo travay pi rèd. Pa kite yo poze menm. Konsa yo p'ap gen tan pou yo koute tout radòt moun ap vin di yo. ");
INSERT INTO hat_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Chèf kòve yo ak fòmann yo vin di pèp la: -Men sa farawon an voye di nou: Li p'ap ban nou pay ankò. ");
INSERT INTO hat_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Se nou menm ki pou al ranmase pay kote nou ka jwenn. Men, se toujou menm valè brik la pou nou bay. ");
INSERT INTO hat_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Se konsa, pèp la gaye toupatou nan peyi Lejip ap chache zèb pou fè pay. ");
INSERT INTO hat_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Chèf kòve yo te dèyè yo tout tan, yo t'ap di yo: -Se pou nou fè menm valè brik chak jou menm jan ak lè yo te konn ban nou pay la. ");
INSERT INTO hat_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Chèf kòve farawon yo te mete kèk moun pèp Izrayèl pou sèvi fòmann. Ata fòmann sa yo te anba makak tou. Chèf kòve yo t'ap mande yo: -Poukisa ni ayè ni jòdi a, nou pa t' bay menm valè brik nou te konn fè anvan an? ");
INSERT INTO hat_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Lè sa a, fòmann yo ki te menm ras ak moun pèp Izrayèl yo t al plenyen bay farawon an. Yo di l': -Monwa, poukisa ou fè moun k'ap sèvi ou yo sa? ");
INSERT INTO hat_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Yo pa ban nou pay ankò. Atousa, se tout tan y'ap mande nou pou nou fè brik. Lèfini, yo mete nou anba makak. Men, se moun pa ou yo ki antò wi, monwa. ");
INSERT INTO hat_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farawon an reponn yo: -Se yon bann parese nou ye. Se poutèt sa n'ap di: O wi, kite n al ofri bèt pou nou touye bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Al nan pye travay nou, tande! Yo p'ap ban nou pay ankò. Degaje nou bay menm kantite brik la. ");
INSERT INTO hat_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Fòmann yo ki te menm ras ak moun pèp Izrayèl yo vin wè yo te nan yon move sitiyasyon lè yo mande yo pou yo fè menm valè brik yo te konn fè a chak jou, san manke yonn. ");
INSERT INTO hat_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Antan y'ap soti kay farawon an, yo kontre Moyiz ak Arawon ki t'ap tann yo. ");
INSERT INTO hat_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Yo di yo: -Se pou Seyè a wè sa nou fè la a. Se pou l' pini nou. Paske se nou menm ki lakòz ni farawon an ni moun k'ap sèvi l' yo pa vle wè pèp Izrayèl la. Nou mete yon nepe nan men yo pou yo fini ak pèp la. ");
INSERT INTO hat_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Lè sa a, Moyiz tounen al jwenn Seyè a ankò, li di l': -Seyè, poukisa w'ap maltrete pèp la konsa? Poukisa ou te voye m'? ");
INSERT INTO hat_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Depi menm lè mwen t al bò kote farawon an pou m' pale avè l' pou ou a, se maltrete l'ap maltrete pèp ou a. Epi ou pa fè anyen pou delivre pèp la. ");
INSERT INTO hat_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Seyè a di Moyiz konsa: -Se koulye a ou pral wè sa m' pral fè farawon an. Mwen pral fè l' santi fòs ponyèt mwen. Vle pa vle, l'ap kite yo ale. Wi, m'ap fòse l' sitèlman, se mete l'ap mete yo deyò nan peyi l' a. ");
INSERT INTO hat_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Bondye pale ak Moyiz, li di l': -Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mwen te fè Abraram, Izarak ak Jakòb konnen m' sou non Bondye ki gen tout pouvwa a. Mwen pa t' fè yo konnen m' sou lòt non mwen an, ki vle di: Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mwen te pase yon kontra ak yo, mwen te pwomèt pou m' te ba yo peyi Kanaran an, peyi kote yo te viv tankou etranje a. ");
INSERT INTO hat_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Koulye a, mwen tande jan pèp Izrayèl la ap plenn. Moun peyi Lejip yo fè yo tounen esklav. Mwen vin chonje kontra mwen te pase ak yo a. ");
INSERT INTO hat_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Men sa ou pral di moun pèp Izrayèl yo: Se mwen menm menm ki Seyè a. M'ap ban nou libète nou, m'ap wete nou nan travay di moun peyi Lejip yo ap fòse nou fè a. M'ap delivre nou anba esklavaj kote yo mete nou an. M'ap lonje bra m' pou m' delivre nou, pou pini moun peyi Lejip yo byen pini. ");
INSERT INTO hat_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","M'ap adopte nou pou pèp mwen, mwen menm m'a Bondye nou. N'a konnen se mwen menm Seyè a, Bondye nou an, ki ban nou libète nou, ki wete nou nan travay di moun peyi Lejip yo ap fòse nou fè a. ");
INSERT INTO hat_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Apre sa, m'ap mennen nou tounen nan peyi mwen te sèmante m'ap bay Abraram, Izarak ak Jakòb la. Se mwen menm Seyè a k'ap ban nou peyi sa a pou l' rele nou chèmèt. ");
INSERT INTO hat_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moyiz di pèp Izrayèl la sa, men yo pa t' vle kwè l', paske yo te about. Esklavaj la te peze lou sou yo. ");
INSERT INTO hat_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Lè sa a, Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","-Ale bò kote farawon an, wa Lejip la. Di l' konsa pou l' kite pèp Izrayèl la soti kite peyi l' la. ");
INSERT INTO hat_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Men, Moyiz di Seyè a: -Ata pèp Izrayèl la pa t' koute m', atò se farawon an ki ta koute m'? Mwen tou pa konn pale. ");
INSERT INTO hat_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Seyè a pale ak Moyiz ansanm ak Arawon. Li ba yo lòd pale ak pèp Izrayèl la ansanm ak farawon an, wa Lejip la, pou fè yo konnen yo tou de te resevwa lòd fè pèp Izrayèl la soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Men non chèf fanmi pèp Izrayèl yo: Woubenn, premye pitit Izrayèl la. Se li ki papa Enòk, Palou, Ezwon ak Kami. Se tout fanmi Woubenn lan sa. ");
INSERT INTO hat_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Apre li vin Simeyon. Men non pitit Simeyon yo: Jemwèl, Jamen, Arad, Jaken, Taoska ak Sayil, yon pitit li te fè ak yon fanm moun peyi Kanaran. Se tout fanmi Simeyon yo sa. ");
INSERT INTO hat_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Apre li vin Levi. Men non pitit Levi yo ak tout pitit yo: Gèchon, Keyat ak Merari. Levi te viv santrannsetan (0137 an). ");
INSERT INTO hat_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Men pitit Gèchon yo ak tout fanmi yo: Libni ak Chimeyi. ");
INSERT INTO hat_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Men pitit Keyat yo: Amram, Jizeya, Ebwon ak Ouzyèl. Keyat te viv antou santranntwazan (0133 an). ");
INSERT INTO hat_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Men pitit Merari yo: Makli ak Mouchi. Se tout branch fanmi Levi yo sa ansanm ak pitit yo. ");
INSERT INTO hat_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram te marye ak Jokebèd, ki matant li bò papa. Jokebèd te fè Arawon ak Moyiz pou li. Amram te viv antou santrannsetan (0137 an). ");
INSERT INTO hat_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Men pitit Jizeya yo: Kore, Nefèg ak Zikri. ");
INSERT INTO hat_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Men pitit Ouzyèl yo: Mikayèl, Elsafan ak Sitri. ");
INSERT INTO hat_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Arawon te marye ak Elicheba, pitit fi Aminadab, sè Nakchon. Elicheba te fè Nadab, Abiyou, Eleaza ak ltama pou Arawon. ");
INSERT INTO hat_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Men non pitit Kore yo: Asi, Elkana ak Abyazaf. Se tout fanmi Kore yo sa. ");
INSERT INTO hat_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleaza, pitit Arawon an, te marye ak yonn nan pitit fi Poutyèl yo, ki te fè Fineas pou li. Men non tout chèf fanmi Levi yo ak tout moun pa yo. ");
INSERT INTO hat_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Se menm Arawon sa a ansanm ak Moyiz Seyè a te di: Fè pitit Izrayèl yo soti kite peyi Lejip la, gwoup pa gwoup. ");
INSERT INTO hat_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Se yo menm tou ki t al di farawon an, wa Lejip la, pou l' fè pèp Izrayèl la soti kite Lejip. Wi, se Arawon sa a avèk Moyiz sa a ki te fè tou sa. ");
INSERT INTO hat_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Lè Seyè a te pale ak Moyiz nan peyi Lejip la, men sa li te di l': ");
INSERT INTO hat_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","-Se mwen menm ki Seyè a! Tou sa mwen di ou la a, se pou ou rapòte l' bay farawon an, wa Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Men Moyiz koupe pawòl nan bouch Seyè a, li di l': -Pawòl pa vin nan bouch mwen fasil. Ou kwè farawon an pral chita tande m'? ");
INSERT INTO hat_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Seyè a di Moyiz konsa: -Gade! Mwen pral fè ou tounen Bondye pou farawon an. Arawon, frè ou la, pral pale avè l' pou ou tankou yon pwofèt. ");
INSERT INTO hat_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","W'a di Arawon tou sa mwen te ba ou lòd di. Li menm, l'a repete l' bay farawon an pou farawon an voye pitit Izrayèl yo pati kite peyi a. ");
INSERT INTO hat_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mwen menm menm, m'ap fè farawon an fè tèt di. Konsa, m'a fè plis mirak ak plis mèvèy toujou nan peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Farawon an p'ap koute nou. Lè sa a, m'a frape peyi Lejip la. m'a pini l' byen pini. m'a pran pitit Izrayèl yo, sòlda mwen yo, pèp mwen an, m'ap fè yo soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Lè m'a frape peyi Lejip, lè m'a fè pitit Izrayèl yo soti nan mitan yo, moun peyi Lejip yo va konnen se mwen menm menm ki Seyè a vre. ");
INSERT INTO hat_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moyiz ak Arawon te fè tou sa Seyè a te ba yo lòd fè. Wi, yo fè tou sa li te di yo fè a. ");
INSERT INTO hat_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moyiz te gen katrevenzan, Arawon te gen katreventwazan lè yo t al pale ak farawon an. ");
INSERT INTO hat_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Seyè a di Moyiz ak Arawon konsa: ");
INSERT INTO hat_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","-Si farawon an mande nou fè yon mirak pou moutre ki moun nou ye, ou menm Moyiz w'a di Arawon pran baton l' lan, voye l' atè devan farawon an. Baton an va tounen yon koulèv. ");
INSERT INTO hat_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moyiz ak Arawon al bò kote farawon an. Yo fè sa Seyè a te ba yo lòd fè a. Arawon voye baton l' lan devan farawon an ak devan tout moun farawon yo. Baton an tounen yon koulèv. ");
INSERT INTO hat_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Men farawon an rele nèg save l' yo ak divinò l' yo. Yo menm tou, avèk maji yo, yo te rive fè menm bagay la tou. ");
INSERT INTO hat_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Yo voye baton pa yo atè, baton yo tounen koulèv tou. Men, baton Arawon an vale tout lòt baton yo. ");
INSERT INTO hat_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Farawon an t'ap fè tèt di toujou. Li pa t' vle koute Moyiz ak Arawon, tankou Seyè a te di a. ");
INSERT INTO hat_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Seyè a di Moyiz konsa: -Farawon an ap fè tèt di toujou. Li pa vle kite pèp la ale. ");
INSERT INTO hat_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ale bò kote farawon an denmen maten, lè li pral soti pou l' al bò gwo larivyè Nil la. Al tann li bò larivyè a. Baton ki te tounen koulèv la, w'a kenbe l' nan men ou. ");
INSERT INTO hat_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","W'a di farawon an: Seyè a, Bondye ebre yo, te voye m' di ou konsa kite pèp li a ale pou yo ka fè yon sèvis pou li nan dezè a. Men, jouk koulye a ou pa vle koute l'. ");
INSERT INTO hat_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Jòdi a, men sa Seyè a di: mwen pral fè ou konnen se mwen menm ki Seyè a. Mwen pral frape dlo gwo larivyè a avèk baton ki nan men m' lan, dlo a pral tounen san. ");
INSERT INTO hat_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Tout pwason yo pral mouri, dlo a pral santi move, moun peyi Lejip yo p'ap ka bwè dlo ladan li ankò. ");
INSERT INTO hat_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Seyè a di Moyiz ankò: -Di Arawon pran baton l' lan, lonje l' sou tout dlo ki nan peyi Lejip la: larivyè, kannal, letan, m'a dlo, wi, sou tout dlo ki genyen. Dlo yo va tounen san. Konsa va gen san sou tout peyi a, menm nan ganmèl yo ak nan kannari yo. ");
INSERT INTO hat_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moyiz ak Arawon fè sa Seyè a te ba yo lòd fè a. Arawon leve baton l' lan, li frape dlo gwo larivyè a devan farawon an ak devan tout moun farawon yo. Tout dlo gwo larivyè a tounen san. ");
INSERT INTO hat_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tout pwason nan larivyè a mouri. Dlo a vin santi move. Moun peyi Lejip yo pa t' kapab pran dlo ladan l' pou yo bwè ankò. Te gen san toupatou nan peyi a. ");
INSERT INTO hat_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Men, majisyen peyi Lejip yo te rive fè menm bagay la tou avèk maji yo. Farawon an menm t'ap fè tèt di pi rèd. Li pa koute Moyiz ak Arawon, tankou Seyè a te di a. ");
INSERT INTO hat_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Farawon an vire do ba yo, l' al lakay li tankou si anyen pa t' rive. ");
INSERT INTO hat_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Moun peyi Lejip yo pran fouye twou sou bò gwo larivyè a pou yo te ka jwenn dlo pròp pou yo bwè, paske yo pa t' kapab bwè dlo gwo larivyè a. ");
INSERT INTO hat_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Apre Seyè a te fin frape gwo larivyè a, li kite sèt jou pase. ");
INSERT INTO hat_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Apre sa, Seyè a di Moyiz konsa: -Ale kote farawon an. W'a di l': Men sa Seyè a di: Kite pèp mwen an ale pou l' kapab fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Koute byen. Si ou derefize kite yo ale, mwen pral lage krapo sou tout peyi a pou pini ou. ");
INSERT INTO hat_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Gwo larivyè a pral plen krapo. Yo pral soti nan larivyè a, y'ap anvayi toupatou, y'ap antre lakay ou, anndan chanm ou, y'ap moute jouk nan kabann ou. Y'ap antre lakay moun pa ou yo, lakay tout pèp ou a, nan fou kote yo fè pen, nan ganmèl kote yo pare pat. ");
INSERT INTO hat_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Y'ap vole sou ou, sou pèp ou a, sou tout moun pa ou yo. ");
INSERT INTO hat_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Seyè a di Moyiz: -Di Arawon lonje men li avèk baton l' lan sou larivyè yo, sou kannal yo ak sou m'a dlo yo. Fè krapo moute kouvri peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Arawon lonje men l' sou tout dlo nan peyi Lejip la. Epi krapo moute kouvri tout peyi a. ");
INSERT INTO hat_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Men majisyen peyi Lejip yo, avèk maji yo, te rive fè menm bagay la tou. Yo fè krapo moute vin sou peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Farawon an rele Moyiz ak Arawon, li di yo: -Lapriyè Seyè a, mande l' pou l' chase krapo sa yo soti sou mwen ak sou pèp mwen an. Apre sa, m'a kite pèp ou a ale pou yo ka touye bèt y'ap ofri bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Lè sa a Moyiz di farawon an: -Se ou menm, farawon, ki konnen kilè ou vle pou m' lapriyè Seyè a pou ou, pou moun pa ou yo ansanm ak pèp ou a. Wi, se ou ki pou di m' kilè ou vle pou Seyè a wete krapo sa yo lakay ou ak nan kay pèp ou a, pou yo rete nan larivyè a ase. ");
INSERT INTO hat_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farawon an reponn: -W'a fè sa denmen. Moyiz di li: -Sa va pase jan ou di l' la, pou ou sa konnen pa gen Bondye tankou Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Krapo yo pral soti lakay ou, y'a wete kò yo sou ou, sou moun pa ou yo ak sou pèp ou a. Se nan gwo larivyè a ase va gen krapo. ");
INSERT INTO hat_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Moyiz ak Arawon soti lakay farawon an. Moyiz lapriyè Seyè a ak tout kè l' pou krapo li te voye sou farawon yo. ");
INSERT INTO hat_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Seyè a fè sa Moyiz te mande l' la: krapo yo mouri toupatou, nan kay, nan lakou, nan jaden. ");
INSERT INTO hat_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Moun peyi Lejip yo ranmase yo fè gwo pil. Toupatou nan peyi a te santi move ak krapo mouri yo. ");
INSERT INTO hat_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Lè farawon an wè yo te ba l' yon souf, li konmanse fè tèt di ankò. Li pa koute Moyiz ak Arawon, tankou Seyè a te di a. ");
INSERT INTO hat_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Seyè a di Moyiz konsa: -Di Arawon lonje baton l' lan, frape pousyè tè a. Pousyè a va tounen vèmin nan tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Moyiz ak Arawon fè sa vre. Arawon lonje men li avèk baton an, li frape pousyè tè a. Pousyè a tounen vèmin sou tout moun ak sou tout bèt. Tout pousyè tè a tounen vèmin nan tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Majisyen yo vin ankò ak maji yo pou yo te fè menm bagay la tou. Men, fwa sa a, yo pa t' kapab. vèmin yo te sou tout moun ak sou tout bèt. ");
INSERT INTO hat_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Majisyen yo di farawon an: -Sa se travay Bondye. Men farawon an t'ap fè tèt di toujou. Li pa t' vle koute Moyiz ak Arawon, tankou Seyè a te di a. ");
INSERT INTO hat_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Seyè a di Moyiz ankò: -Leve granmaten, ale jwenn farawon an lè li pral larivyè a. W'a di l': men sa Seyè a di: Kite pèp mwen an ale, pou yo ka fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Si ou pa kite pèp mwen an ale, mwen pral voye mouchavè sou ou, sou moun pa ou yo, sou tout pèp ou a ak nan tout kay yo. Mouchavè pral plen kay moun peyi Lejip yo, yo pral kouvri tout peyi a. ");
INSERT INTO hat_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Men jou sa a, m'a fè yon bagay pou peyi Gochenn kote pèp mwen an rete a. p'ap gen yon mouchavè la. Konsa, w'a konnen se mwen menm, Seyè a, k'ap travay nan peyi a. ");
INSERT INTO hat_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","m'a veye pou sa k'ap rive pèp ou a pa rive pèp mwen an. Se denmen mwen pral fè mèvèy sa a. ");
INSERT INTO hat_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Seyè a fè sa vre jan l' te di l' la: yon kantite mouchavè desann sou kay farawon an, sou kay moun pa l' yo ak sou tout peyi a. Mouchavè t'ap devaste tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Lè sa a, farawon an fè rele Moyiz ak Arawon, li di yo: -Nou mèt al ofri bèt pou touye pou Bondye nou an, men n'ap fè l' isit la nan peyi a. ");
INSERT INTO hat_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moyiz reponn li: -Li p'ap bon pou nou fè l' konsa, paske moun peyi Lejip yo ka ofiske lè y'a wè ki kalite bèt nou touye pou ofri bay Seyè a, Bondye nou an. Si nou ofri bagay sa yo devan moun peyi Lejip yo, y'a ka touye nou ak kout ròch. ");
INSERT INTO hat_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Se pou nou mache twa jou nan dezè a. Se la n'a touye bèt n'ap ofri bay Seyè a, Bondye nou an, jan li te di nou an. ");
INSERT INTO hat_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farawon an di li: -Bon! M'ap kite nou al touye bèt n'ap ofri bay Seyè a, Bondye nou an, nan dezè a, men se pa pou nou al twò lwen. Lèfini, lapriyè pou mwen tou. ");
INSERT INTO hat_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moyiz di l' konsa: -Kou m' soti isit la, mwen pral lapriyè Seyè a. Denmen mouchavè yo ap soti sou ou ansanm ak sou moun pa ou yo ak sou tout pèp la. Yo pral byen lwen. Men, piga ou twonpe nou ankò. Pa refize kite pèp la al ofri bèt pou yo touye bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Moyiz soti lakay farawon an, l' al lapriyè Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Seyè a fè sa Moyiz te mande l' la. Li fè mouchavè yo soti sou farawon an, sou tout moun pa l' yo ansanm ak sou tout pèp la. Li fè yo ale byen lwen. Pa yon mouchavè pa t' rete. ");
INSERT INTO hat_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Men, menm jou sa a, farawon an fè tèt di ankò, li pa t' vle kite pèp la ale. ");
INSERT INTO hat_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Seyè a di Moyiz konsa: -Ale bò kot farawon an, w'a di l': Men sa Seyè a, Bondye pèp ebre a, voye di ou: Kite pèp mwen an ale pou yo ka fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Si ou derefize kite yo ale, si ou kenbe yo toujou, men sak pral rive: ");
INSERT INTO hat_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","M'ap leve men m' sou bèt ou gen nan jaden ou yo: chwal, bourik, chamo, bèf, mouton, kabrit. Yon gwo maladi pral tonbe sou yo. ");
INSERT INTO hat_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Men m'a veye pou sa ki rive bèt moun peyi Lejip yo pa rive bèt moun pèp Izrayèl yo, pou ankenn bèt moun pèp Izrayèl yo pa mouri. ");
INSERT INTO hat_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Seyè a fikse jou pou l' fè bagay sa a. Li di se denmen l'ap fè sa nan tout peyi a. ");
INSERT INTO hat_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Nan denmen vre, Seyè a fè sa l' te di li t'ap fè a: tout bèt moun peyi Lejip yo mouri. Men, pa yonn nan bèt moun Izrayèl yo pa t' mouri. ");
INSERT INTO hat_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farawon an voye pran nouvèl sak pase: li vin konnen pa t' gen yonn nan bèt moun Izrayèl yo ki te mouri. Men, farawon an t'ap fè tèt di toujou. Li pa t' vle kite pèp la ale. ");
INSERT INTO hat_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Apre sa, Seyè a di Moyiz ak Arawon: -Plen de men nou ak sann dife. Se pou Moyiz voye sann lan jete anlè devan farawon an. ");
INSERT INTO hat_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Sann lan pral gaye tankou pousyè pou l' kouvri tout peyi Lejip la. Toupatou li pral fè yon kantite bouton leve sou tout moun ak sou tout bèt nan peyi a. Lèfini, bouton yo ap pete, y'ap fè malenng. ");
INSERT INTO hat_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yo pran sann dife a, yo parèt devan farawon an. Moyiz voye sann lan jete anlè. Sann lan fè bouton leve sou tout moun ak sou tout bèt. Epi bouton yo pete fè malenng. ");
INSERT INTO hat_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Ata majisyen yo pa t' kapab parèt devan Moyiz, paske yo te kouvri ak malenng tou tankou tout moun peyi Lejip yo. ");
INSERT INTO hat_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Men Seyè a te fè farawon an fè tèt di pi rèd. Farawon an pa t' koute Moyiz ak Arawon, tankou Seyè a te di Moyiz la. ");
INSERT INTO hat_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Seyè a di Moyiz konsa: -Leve granmaten, al parèt devan farawon an. W'a di l': Men sa Seyè a, Bondye pèp ebre a, voye di ou: Kite pèp mwen an ale pou yo ka al fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Paske, fwa sa a, mwen pral voye tout kalite malè mwen konn fè yo sou ou menm menm, sou moun pa ou yo ak sou tout pèp ou a. Konsa, w'a konnen pa gen tankou m' sou tout latè. ");
INSERT INTO hat_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Si mwen te lonje men m' pou m' te lage lanmò sou ou ansanm ak tout pèp ou a, nou tout nou te disparèt nèt sou latè. ");
INSERT INTO hat_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Men, mwen kite nou viv pou nou kapab wè pouvwa mwen, pou moun ka nonmen non m' sou tout latè. ");
INSERT INTO hat_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Men w'ap pran pòz awogan ou avèk pèp mwen an, ou pa vle kite yo ale. ");
INSERT INTO hat_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Koute! Fwa sa a, denmen mwen pral fè lagrèl tonbe tankou lapli, bagay moun poko janm wè nan peyi Lejip, depi peyi a peyi jouk jounen jòdi a. ");
INSERT INTO hat_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Koulye a, bay lòd pou yo pran tout bèt nou gen nan jaden ak tout lòt bagay nou gen deyò mete yo anndan kay pou pwoteje yo. Paske, yon gwo lagrèl pral tonbe sou tout moun ak sou tout bèt ki deyò. Yo pral mouri. ");
INSERT INTO hat_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Te gen kèk moun nan moun pa farawon yo ki te pè lè yo tande sa Seyè a te di. Yo fè tout domestik yo ansanm ak tout bèt yo antre anba kay. ");
INSERT INTO hat_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Men, gen lòt ki pa t' okipe sa Seyè a te di. Yo kite tout domestik yo ak tout bèt yo deyò. ");
INSERT INTO hat_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Seyè a di Moyiz konsa: -Leve men ou anlè. Lagrèl pral tonbe sou tout peyi Lejip la, sou tout moun ki deyò, sou tout bèt ak sou tout plant ki nan jaden. ");
INSERT INTO hat_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moyiz lonje baton l' lan anlè nan syèl la. Seyè a voye loraj, lagrèl ak zèklè. Loraj la tonbe anpil kote. Wi, Seyè a voye lagrèl sou tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Lagrèl t'ap tonbe, zèklè t'ap fè yanyan nan syèl la. Se te pi gwo kout tan ki te tonbe sou peyi a depi peyi a peyi. ");
INSERT INTO hat_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Lagrèl tonbe toupatou nan peyi Lejip la. Li tonbe sou tou sa ki te deyò, sou tout moun ak sou tout bèt. Li tonbe sou tout plant ki nan jaden, li kraze tout pyebwa. ");
INSERT INTO hat_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Se sèl nan peyi Gochenn lan lagrèl la pa t' tonbe. Se la moun pèp Izrayèl yo te rete. ");
INSERT INTO hat_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Farawon an fè rele Moyiz ak Arawon, li di yo konsa: -Fwa sa a, mwen rekonèt tò mwen. Se Seyè a ki gen rezon. Se mwen menm ak pèp mwen an ki antò. ");
INSERT INTO hat_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Lapriyè Seyè a pou l' fè loraj la sispann, pou l' fè lagrèl la rete. Mwen pwomèt pou m' kite nou ale. Nou pa bezwen rete ankò. ");
INSERT INTO hat_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moyiz di l' konsa: -Soti m' soti lavil la, mwen pral lapriyè nan pye Seyè a. Loraj la va sispann, p'ap gen lagrèl ankò. Konsa w'a konnen tè a se pou Seyè a li ye. ");
INSERT INTO hat_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Men mwen konnen ni ou menm, ni moun pa ou yo, nou poko ap respekte Seyè a, Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tout pye koton swa yo ak tout jaden lòj yo te boule. Lòj la te deja fè grap, koton yo t'ap fleri. ");
INSERT INTO hat_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Men ble ak pitimi pa t' gate, paske yo toujou an reta sou lòt plant yo. ");
INSERT INTO hat_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moyiz soti lakay farawon an, l' al andeyò lavil la. Li lapriyè nan pye Seyè a. Loraj la sispann, lagrèl la rete. pa t' gen lapli ankò. ");
INSERT INTO hat_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Lè farawon an wè lapli a, lagrèl la ak loraj la sispann, li kontinye fè peche toujou. Li fè tèt di, li menm ansanm ak tout moun pa l' yo. ");
INSERT INTO hat_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Nan fè tèt di sa a, li pa t' kite moun pèp Izrayèl yo ale, jan Seyè a te fè Moyiz al di l' la. ");
INSERT INTO hat_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Seyè a di Moyiz ankò: -Ale bò kot farawon an. Se mwen menm ki fè l' gen tèt di, li menm ansanm ak moun pa l' yo, pou m' fè yo wè mèvèy mwen ka fè nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Konsa tou, n'a rakonte pitit nou yo ak pitit pitit nou yo sa mwen te fè moun peyi Lejip yo pase ak kalite mèvèy mwen te fè nan mitan yo. Lè sa a nou tout n'a konnen se mwen menm menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Se konsa Moyiz ak Arawon ale bò kote farawon an. Yo di l': -Men sa Seyè a, Bondye pèp ebre a, voye di ou: Kilè w'a aprann soumèt tèt ou devan mwen? Kite pèp mwen an ale pou l' ka fè yon sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Si ou refize kite pèp mwen an ale, men sa m' pral fè: Denmen, mwen pral voye krikèt vèt sou tout peyi a. ");
INSERT INTO hat_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yo pral kouvri tout tè a, jouk moun p'ap ka wè tè a ankò. Yo pral devore ti rès lagrèl te kite pou nou an. y'a devore tout pyebwa ki nan jaden nou yo. ");
INSERT INTO hat_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Y'ap anvayi tout kay ou yo, kay tout moun pa ou yo ak kay tout moun nan peyi a. Se bagay granpapa nou yo ak zansèt nou yo pa t' janm wè depi yo fèt jouk jounen jòdi a. Apre sa, Moyiz vire do l', li soti kay farawon an. ");
INSERT INTO hat_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Moun pa farawon yo vin di l': -Kilè nonm sa a va sispann ban nou pwoblèm? Kite moun yo ale non. Kite yo al fè sèvis pou Bondye yo a. Ou pa wè jan peyi Lejip la ap fini! ");
INSERT INTO hat_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Se konsa yo fè Moyiz ak Arawon tounen vin kote farawon an. Farawon an di yo: -Nou mèt al fè sèvis pou Seyè a, Bondye nou an. Kilès ki prale? ");
INSERT INTO hat_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moyiz reponn li: -Nou prale ak tout timoun yo, ak tout granmoun yo, ak tout pitit gason nou yo, ak tout pitit fi nou yo ansanm ak bèf, mouton ak kabrit nou yo, paske se yon gwo sèvis pou n' fè pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farawon an di yo: -Gade jan nou gen move lide dèyè tèt nou! Mwen ta swete pou Seyè a ede nou vre! Men, mwen p'ap kite nou ale ansanm ak timoun yo. ");
INSERT INTO hat_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Non. Sa p'ap pase konsa. Se nou menm gason yo ase ki mèt ale pou fè sèvis pou Seyè a. Se pa sa nou te mande? Lè l' fin di yo sa, li fè mete yo deyò lakay li. ");
INSERT INTO hat_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Seyè a di Moyiz: -Lonje men ou sou peyi Lejip la pou fè krikèt yo vini sou li. Y'ap vini, y'ap devore tout fèy bwa nan peyi a. Wi, y'a devore tou sa lagrèl te kite. ");
INSERT INTO hat_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moyiz lonje baton l' lan sou peyi Lejip la. Seyè a fè yon van nòde soufle sou peyi a. Van an soufle tout yon jounen ak tout yon nwit. Nan maten, van an pote krikèt vèt yo vini. ");
INSERT INTO hat_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Krikèt yo tonbe sou peyi Lejip la, yo poze toupatou nan peyi a. Moun pa t' janm wè kantite krikèt konsa, epi se bagay yo p'ap janm wè ankò. ");
INSERT INTO hat_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Krikèt yo kouvri tè a nèt. Tè a vin tou nwa ak krikèt. Krikèt yo manje tou sak t'ap pouse nan peyi a, tout fwi ki te nan pyebwa yo, tou sa lagrèl te kite. pa t' rete yon ti fèy vèt nan pyebwa yo ankò nan tout peyi Lejip la. Tout jaden te pèdi nèt. ");
INSERT INTO hat_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Lè sa a, farawon an prese fè rele Moyiz ak Arawon, li di yo: -Mwen peche kont Seyè a, Bondye nou an, mwen peche kont nou menm tou. ");
INSERT INTO hat_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tanpri, padonnen peche m' fwa sa a. Lapriyè Seyè a, Bondye nou an, ankò pou l' wete chatiman sa a sou mwen. Se touye chatiman sa a ap touye m'! ");
INSERT INTO hat_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moyiz soti kay farawon an. Li lapriyè Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Seyè a fè yon gwo van lwès soufle fwa sa a. Van an pote tout krikèt yo al jete nan lanmè Wouj la. Pat rete yon sèl grenn krikèt nan tout peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Men Seyè a fè farawon an fè tèt di ankò. Farawon an pa kite moun pèp Izrayèl yo ale. ");
INSERT INTO hat_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Seyè a di Moyiz ankò: -Lonje men ou anlè pou fènwa kouvri peyi Lejip la, yon fènwa sitèlman pwès moun ta ka santi li anba men yo. ");
INSERT INTO hat_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moyiz leve men li anlè, epi yon fènwa byen pwès desann kouvri tout peyi Lejip la pandan twa jou. ");
INSERT INTO hat_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Moun peyi Lejip yo fè twa jou yonn pa t' ka wè lòt, pesonn pa mete tèt deyò. Men, te gen klète kote moun pèp Izrayèl yo te rete a. ");
INSERT INTO hat_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farawon an fè rele Moyiz, li di l' konsa: -Nou mèt ale fè sèvis pou Seyè a. Nou mèt ale ak timoun nou yo. Men mouton nou yo, kabrit nou yo ak bèf nou yo ap rete isit la. ");
INSERT INTO hat_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moyiz reponn li: -Bon, lè sa a, se ou menm ki pral ban nou bèt pou nou touye pou nou boule pou Seyè a, Bondye nou an? ");
INSERT INTO hat_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tout bèt nou fèt pou ale ak nou. Nou p'ap kite yonn dèyè. Paske, se ladan yo pou nou pran sa nou bezwen pou fè sèvis pou Seyè a, Bondye nou an. Tout tan nou pa rive, nou poko konnen kisa nou pral chwazi pou ofri bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Men Seyè a fè farawon an fè tèt di pi rèd toujou. Farawon an pa t' vle kite yo ale. ");
INSERT INTO hat_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farawon an di Moyiz konsa: -Wete kò ou devan m'. Gade! Pa janm parèt devan m' ankò, paske jou ou ta parèt devan m' ankò, m'ap disparèt ou. ");
INSERT INTO hat_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moyiz reponn li: -Jan ou vle! Mwen p'ap janm parèt devan ou ankò. ");
INSERT INTO hat_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Seyè a di Moyiz: -Mwen pral voye yon lòt malè sou farawon an ak sou peyi Lejip la. Apre sa, l'ap kite nou ale. Wi, lè l'a pare pou l' kite nou ale a, se mete l'ap mete nou deyò. ");
INSERT INTO hat_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Pale ak pèp Izrayèl la. Se pou yo chak mande vwazen ak vwazen yo fè yo kado bagay yo genyen ki fèt an ajan osinon an lò. ");
INSERT INTO hat_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Seyè a te fè moun peyi Lejip yo vin gen kè sansib pou moun pèp Izrayèl yo. Pou Moyiz menm, tout moun nan peyi a te gen gwo respè pou li. Moun farawon yo ansanm ak tout pèp la te respekte Moyiz anpil. ");
INSERT INTO hat_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moyiz di farawon an: -Men sa Seyè a di: Aswè a, nan mitan lannwit, m'ap pase kay moun peyi Lejip yo. ");
INSERT INTO hat_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Tout premye pitit gason moun peyi Lejip yo pral mouri, depi premye pitit farawon an, ki chita sou fotèy la, jouk premye pitit gason dènye klas sèvant k'ap travay nan moulen. Premye pitit tout bèt pral mouri tou. ");
INSERT INTO hat_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Pral gen yon sèl gwo rèl nan tout peyi a, rèl moun poko janm tande, rèl moun p'ap janm tande ankò. ");
INSERT INTO hat_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Men, nan mitan pèp Izrayèl la, ou p'ap menm tande yon chen wouke, paske ni moun ni bèt p'ap mouri la. Konsa, w'a konnen Seyè a fè yon diferans ant pèp peyi Lejip la ak pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Lè sa a, tout moun pa ou yo pral desann vin kote mwen. Y'ap bese tèt yo jouk atè devan mwen. y'a di m': Ale non, ou menm ansanm ak tou pèp ou a. Se lè sa a, m'a pati. Lèfini, Moyiz soti byen fache lakay farawon an. ");
INSERT INTO hat_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Seyè a di Moyiz: -Farawon an p'ap koute ou. Konsa, m'a fè plis mèvèy toujou nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moyiz ak Arawon te fè tout mirak sa yo devan farawon an. Men farawon an pa t' vle kite moun pèp Izrayèl yo soti kite peyi a. Seyè a fè farawon an fè tèt di pi rèd toujou. ");
INSERT INTO hat_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Antan Moyiz ak Arawon te nan peyi Lejip la, Seyè a di yo: ");
INSERT INTO hat_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","-Se mwa sa a k'ap premye mwa pou nou nan lanne a. Se limenm k'ap anvan tout lòt mwa yo. ");
INSERT INTO hat_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pale tout moun pèp Izrayèl la. Di yo: sou dizyèm jou mwa sa a, n'a pran yon ti mouton pou chak fanmi, tande byen wi, yon ti mouton pou chak kay. ");
INSERT INTO hat_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Si pa gen kont moun nan kay la pou manje tout ti mouton an, se pou yo mete tèt yo ansanm ak vwazinaj ki pi pre kay la. N'a kalkile kantite moun ki nesesè pou manje mouton an, sa chak moun ka manje. ");
INSERT INTO hat_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Se pou ti bèt nou chwazi a yon timal ki gen ennan, epi ki pa gen ankenn enfimite, li te mèt mouton, li te mèt kabrit. ");
INSERT INTO hat_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","N'a gade l' apa jouk sou katòzyèm jou mwa a. Jou sa a, nan aswè, tout moun Izrayèl yo va touye ti bèt la anvan li fin fè nwa. ");
INSERT INTO hat_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","N'a pran ti gout nan san bèt la, n'a pase l' sou de chanbrann pòt kay la ansanm ak sou travès lento pòt la, nan kay kote n'ap manje ti bèt la. ");
INSERT INTO hat_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Menm nwit sa a, n'a boukannen vyann lan. Apre sa, n'a manje l' avèk pen ki fèt san ledven epi ak fèy lanman. ");
INSERT INTO hat_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Piga nou manje vyann lan ni manke kwit ni bouyi. Se boukannen pou nou boukannen l' tout ankè ak tout tonbe a. ");
INSERT INTO hat_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Pa kite anyen pou denmen maten. Si rete rès, se pou nou boule l' nan dife. ");
INSERT INTO hat_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Men ki jan pou nou ranje kò nou pou nou manje l': n'a mare ren nou, sapat nou nan pye nou, baton nou nan men nou. Se pou nou manje l' prese prese, paske se lè sa a Seyè a ap pase. ");
INSERT INTO hat_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Jou lannwit sa a, m'ap pase nan tout peyi Lejip la, m'ap touye tout premye pitit gason ak tout premye pitit bèt yo ki nan peyi a. M'ap regle tout bondye peyi Lejip yo. Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","San nou pase sou pòt yo va make kay kote nou ye a. Lè m'a wè san an, m'a sote kay nou. Konsa, lè m'ap frape peyi Lejip la, chatiman an p'ap tonbe sou nou tou. ");
INSERT INTO hat_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Jou sa a, se yon jou pou nou pa janm bliye. Se pou nou fete l' tankou yon fèt pou Seyè a, chak lè lè a va rive. Se pou nou pase yon lwa pou nou toujou fete fèt sa a, nou menm ak tout pitit pitit nou yo. ");
INSERT INTO hat_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pandan sèt jou, se pou nou manje pen ki fèt san ledven. Depi premye jou nan mwa a, n'a wete tout ledven anndan lakay nou, paske depi premye jou a, rive sou setyèm jou a, si yon moun gen malè manje pen ki gen ledven ladan l', se pou yo disparèt li nan mitan pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Sou premye jou a ak sou setyèm jou a, n'a reyini pou nou lapriyè. Jou sa yo, nou p'ap fè ankenn travay. Manje ase n'a fè pou tout moun manje. ");
INSERT INTO hat_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","N'a toujou fete fèt pen san ledven an, paske se jou sa a mwen te fè tout lame moun nou yo soti kite peyi Lejip. N'a toujou fete fèt sa a, de pitit an pitit tankou yon lwa ki la pou tout tan. ");
INSERT INTO hat_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Nan premye mwa a, depi katòzyèm jou a nan aswè rive jouk sou venteyenyèm jou a nan aswè tou, se pen san ledven pou nou manje. ");
INSERT INTO hat_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Pandan sèt jou sa yo, p'ap gen ledven lakay nou paske nenpòt moun ki va gen malè manje pen ki gen ledven, yo gen pou yo disparèt li nan mitan pèp Izrayèl la, kit se yon etranje, kit se yonn nan nou. ");
INSERT INTO hat_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Se pa pou nou manje pen ki gen ledven. Lakay nou, se pou tout moun manje pen san ledven. ");
INSERT INTO hat_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moyiz rele tout chèf fanmi pèp Izrayèl la, li di yo: -Se pou chak moun al chache yon ti mouton osinon yon ti kabrit pou yo touye pou fèt delivrans lan pou fanmi nou. ");
INSERT INTO hat_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Apre sa, n'a pran yon branch izòp, n'a tranpe l' nan kivèt ki gen san bèt la. N'a pase l' sou de chanbrann pòt la ak sou travès lento a. Apre sa, piga pesonn soti deyò lakay yo jouk li jou. ");
INSERT INTO hat_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Konsa, lè Seyè a va pase nan peyi Lejip la pou touye moun peyi Lejip yo, l'a wè san an sou chanbrann yo ak sou lento a, l'ap pase devan pòt la, li p'ap kite moun ki reskonsab pou touye a antre lakay nou pou touye nou. ");
INSERT INTO hat_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","N'a fè tout bagay sa yo sèvi tankou yon lwa ki la pou tout tan, ni pou nou ni pou pitit nou yo. ");
INSERT INTO hat_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lè n'a antre nan peyi Seyè a pral ban nou an, jan l' te pwomèt la, se pou nou toujou fè seremoni sa a. ");
INSERT INTO hat_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Lè timoun nou yo va mande nou sa seremoni sa a vle di, ");
INSERT INTO hat_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","n'a reponn yo: Se fèt Delivrans lan n'ap fete pou Seyè a, paske li te sote kay moun pèp Izrayèl yo nan peyi Lejip, lè li t'ap touye moun peyi Lejip yo. Konsa li pa t' fè nou anyen. Apre tout pawòl sa yo, tout moun pèp Izrayèl yo met ajenou, yo bese tèt yo atè pou adore Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Lèfini, yo leve, y' ale, yo fè tou sa Seyè a te bay Moyiz ak Arawon lòd fè a. Wi, yo fè tout bagay jan li te bay lòd la. ");
INSERT INTO hat_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Nan mitan lannwit, Seyè a touye tout premye pitit gason moun peyi Lejip yo, depi premye pitit gason farawon an ki chita sou fotèy la, jouk premye pitit gason prizonye ki te nan kacho. Tout premye pitit bèt yo tou te mouri. ");
INSERT INTO hat_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Jou lannwit sa a, farawon an leve, li menm, tout chèf li yo ansanm ak tout pèp peyi Lejip la. Yon gwo rèl pete toupatou nan peyi Lejip, paske pa t' gen yon kay ki pa t' gen lanmò. ");
INSERT INTO hat_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nan mitan lannwit lan, farawon an fè rele Moyiz ak Arawon, li di yo: -Leve, ale fè wout nou! Wete kò nou nan mitan pèp mwen an, nou menm ansanm ak moun pèp Izrayèl la. Ale, mwen di nou. Al fè sèvis pou Seyè a jan nou te di a. ");
INSERT INTO hat_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nou mèt pran mouton nou ak bèf nou yo, jan nou te di l' la. Epi mande Bondye pou l' beni mwen. ");
INSERT INTO hat_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Moun peyi Lejip yo te cho cho dèyè moun pèp Izrayèl yo pou fè yo prese kite peyi a. Yo t'ap di: -Si nou pa ale, nou tout ap mouri! ");
INSERT INTO hat_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Se konsa pèp Izrayèl la pran pa t' farin lan san yo pa t' ankò mete ledven ladan l'. Yo mete yo sou platin fou yo, yo vlope yo nan rad yo, yo mete yo sou zepòl yo. ");
INSERT INTO hat_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Moun pèp Izrayèl yo te fè sa Moyiz te di yo a. Yo mande moun peyi Lejip yo bijou an ajan, bijou an lò ansanm ak rad. ");
INSERT INTO hat_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Seyè a te fè moun peyi Lejip yo gen kè sansib pou pèp Izrayèl la. Yo ba yo tou sa yo te mande. Se konsa pèp Izrayèl la pran tout bagay moun peyi Lejip yo. ");
INSERT INTO hat_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Moun pèp Izrayèl yo pati kite Ranmsès pou Soukòt. Te gen sisanmil (0600,000) moun konsa, san konte fanm ak timoun. Yo tout te apye. ");
INSERT INTO hat_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Te gen anpil moun lòt peyi tou ki te pati ansanm ak yo. Te gen anpil mouton, kabrit ak bèf tou. ");
INSERT INTO hat_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Avèk pa t' farin yo te pote soti peyi Lejip la, yo fè pen. Pen yo te san ledven, paske yo te prese mete yo deyò nan peyi Lejip la. Yo pa t' menm gen tan fè pwovizyon. ");
INSERT INTO hat_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Moun pèp Izrayèl yo te pase katsantrantan nan peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Menm jou ki te fè yo katsantrantan nan peyi a, jou pou jou, tout lame moun Seyè a soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Se te yon jou lannwit. Seyè a te pase tout nwit la ap veye pou fè yo soti kite peyi Lejip la. Se poutèt sa, se pou yo mete nwit sa a apa pou yo fè veye pou Seyè a. Se bagay pou yo toujou fè de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Seyè a di Moyiz ak Arawon konsa: -Men ki jan pou yo fete fèt Delivrans lan. Pou konmanse, ankenn moun lòt nasyon pa gen dwa patisipe ladan l'. ");
INSERT INTO hat_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Domestik nou achte pou sèvis lakay nou, lè nou fin sikonsi yo, yo mèt patisipe. ");
INSERT INTO hat_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Men, ni moun lòt nasyon ki depasaj lakay nou, ni domestik k'ap travay pou lajan pa ka patisipe nan fèt la. ");
INSERT INTO hat_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Se pou nou manje manje Delivrans lan anndan kay. Vyann lan pa fèt pou soti deyò menm. Ni nou pa fèt pou kraze ankenn zo bèt nou touye yo. ");
INSERT INTO hat_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Se pou tout pèp Izrayèl la nèt fete fèt sa a. ");
INSERT INTO hat_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Si gen yon moun lòt nasyon ki rete nan peyi a epi ki ta vle fete fèt Delivrans lan pou Seyè a, men sa pou nou fè: Sè pou nou sikonsi tout gason lakay li anvan. Apre sa, l'a gen dwa fete fèt Delivrans lan. y'a konsidere l' tankou moun natif natal pèp Izrayèl la. Si yon gason pa sikonsi, li pa ka patisipe nan fèt la. ");
INSERT INTO hat_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Lòd sa a bon ni pou natif natal yo ni pou moun lòt nasyon ki rete nan peyi a nan mitan nou. ");
INSERT INTO hat_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tout moun pèp Izrayèl yo te swiv lòd la, yo te fè sa Seyè a te bay Moyiz ak Arawon lòd fè a. ");
INSERT INTO hat_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Se jou sa a Seyè a te fè tout lame moun Izrayèl yo soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","-Se pou nou mete tout premye pitit gason ak tout premye mal bèt yo apa pou mwen. Tout premye pitit gason moun pèp Izrayèl yo, tout premye mal bèt yo fè, se pou mwen yo ye. ");
INSERT INTO hat_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moyiz di pèp la: -Pa janm bliye jou sa a, jou nou te soti kite peyi Lejip kote yo te fè nou tounen esklav la, paske se Seyè a menm ki te fè nou soti ak fòs ponyèt li. Jou sa a, se pa pou nou manje pen ki gen ledven ladan l'. ");
INSERT INTO hat_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Se jòdi a, se jou sa a, nan mwa Abib la, n'ap soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Seyè a va fè nou antre nan peyi ki pou moun Kanaran yo, pou moun Et yo, pou moun Amori yo, pou moun Evi yo ak moun Jebis yo. Se yon peyi ki rich anpil, kote lèt ak siwo myèl koule tankou dlo. Se peyi sa a Seyè a te pwomèt l'ap bay zansèt nou yo. Lè l'a fè nou antre nan peyi sa a, n'a toujou fè sèvis sa a nan menm mwa a. ");
INSERT INTO hat_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pandan sèt jou, n'a manje pen ki fèt san ledven. Sou setyèm jou a, n'a fè yon fèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Pandan sèt jou, n'a manje pen ki fèt san ledven. Yo pa dwe jwenn ni pen ki fèt ak ledven, ni ledven menm lakay nou, nan tout peyi a. ");
INSERT INTO hat_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Jou sa a, men sa n'a di pitit gason nou yo: Nou fè tou sa pou Seyè a, lè nou chonje tou sa li te fè pou nou lè nou soti kite Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sèvis sa a ap tankou yon mak nan men nou osinon yon bagay nou mete nan tèt nou pou nou pa bliye, pou nou ka toujou fè konnen lòd Seyè a. Paske, se avèk fòs ponyèt li li fè nou soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Toujou fè sèvis sa a chak lanne, nan dat mwen te fikse a. ");
INSERT INTO hat_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Lè Seyè a va fè nou antre nan peyi moun Kanaran yo, dapre pwomès li te fè nou an, nou menm ansanm ak zansèt nou yo, lè Seyè a va ban nou peyi sa a, ");
INSERT INTO hat_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","n'a pran tout premye pitit gason nou yo, n'a mete yo apa pou Seyè a. Konsa tou, tout premye pitit bèt nou yo, depi se mal yo ye, se pou mwen yo ye. ");
INSERT INTO hat_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Nan plas tout premye pitit bourik nou yo, se pou nou ban mwen yon ti mouton. Si nou pa fè sa, se pou nou kase kou l'. Men, n'a ofri m' bagay pou achte lavi tout premye pitit gason nou yo nan men mwen. ");
INSERT INTO hat_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Denmen, lè pitit gason nou yo va mande nou poukisa nou fè sa, n'a di yo: Se paske se ak fòs ponyèt li Seyè a te fè nou soti kite peyi Lejip kote yo te fè nou tounen esklav la. ");
INSERT INTO hat_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Seyè a te touye depi premye pitit gason moun peyi Lejip yo rive jouk premye mal bèt yo fè, paske farawon an t'ap fè tèt di, li pa t' vle kite nou ale. Se poutèt sa nou ofri bay Seyè a tout premye mal bèt nou yo fe, epi nou ofri lòt bagay pou achte lavi tout premye pitit gason nou yo nan men l'. ");
INSERT INTO hat_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Sèvis sa a va tounen tankou yon mak sou men nou, tankou bando nou mare sou fwon nou, pou fè nou chonje se ak fòs ponyèt li Seyè a te fè nou soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Lè farawon an kite pèp Izrayèl la pati, Bondye pa mennen yo nan wout ki pase bò lanmè a pou ale nan peyi moun Filisti yo, atout se wout sa a ki te pi kout, paske Bondye te di: Mwen pa vle pou pèp la gen remò pou yo kase tèt tounen nan peyi Lejip la ankò, lè y'a wè batay yo gen pou yo fè. ");
INSERT INTO hat_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Se konsa, Bondye fè pèp la pran chemen dezè a nan direksyon lanmè Wouj la. Pèp Izrayèl la te soti kite peyi Lejip la tankou yon lame. ");
INSERT INTO hat_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moyiz pran zosman Jozèf yo avèk li, paske Jozèf te fè moun pèp Izrayèl yo fè sèman. Li te di yo: Bondye gen pou vin ede nou. Lè sa a, se pou nou pati ak zosman mwen soti isit la. ");
INSERT INTO hat_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Yo kite Soukòt, yo rive yon kote ki rele Etam, sou lizyè dezè a, yo pase kèk tan la. ");
INSERT INTO hat_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Lajounen, Seyè a t'ap mache devan yo nan yon gwo nwaj ki te gen fòm yon poto pou moutre yo chemen pou yo pran. Lannwit, li t'ap mache devan yo nan yon dife ki te tankou yon flanm ki t'ap klere yo. Konsa, yo te ka vwayaje lajounen kou lannwit. ");
INSERT INTO hat_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Lajounen, nwaj la te toujou ap mache devan pèp la. Lannwit, se te dife a. ");
INSERT INTO hat_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Bondye pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","-Pale ak pèp Izrayèl la, di yo: Tounen dèyè, moute tant nou devan Pyakiròt, ant Migdòl ak lanmè a, anfas Baalsefon. N'a moute tant nou devan kote sa a, bò lanmè a. ");
INSERT INTO hat_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Farawon an pral mete nan tèt li pèp Izrayèl la pèdi nan peyi a, yo pa konn kote pou yo fè nan dezè a. ");
INSERT INTO hat_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","M'ap fè farawon an fè tèt di ankò, l'a rapouswiv nou. Men, m'ap bat ni farawon an ni tout lame li yo. Sa va sèvi yon lwanj pou mwen. Konsa, moun peyi Lejip yo va konnen se mwen menm ki Seyè a. Moun pèp Izrayèl yo fè jan Bondye te di yo a. ");
INSERT INTO hat_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Farawon an, wa Lejip la, resevwa rapò. Yo vin di l' pèp la sove ale. Lè sa a, farawon an ak moun pa l' yo chanje lide. Yo di: -Sa nou fè la a? Nou kite yo ale? Yo sove kite travay yo t'ap fè pou nou an? ");
INSERT INTO hat_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Farawon an fè pare cha lagè li. Li pran sòlda li yo ak li. ");
INSERT INTO hat_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Li pran sisan (0600) cha nan sa ki te pi bon yo. Tout lòt cha yo te ale tou. Yo tout te gen sòlda ame sou yo. ");
INSERT INTO hat_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Seyè a te fèmen kè farawon an, wa Lejip la. Farawon an pran rapouswiv moun pèp Izrayèl yo ki te soti kite peyi a devan je tout moun san pesonn pa t' di yo anyen. ");
INSERT INTO hat_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Men apre sa, moun peyi Lejip yo pran kouri dèyè yo ak tout chwal yo, tout cha lagè farawon yo, tout kavalye yo. Tout lame yo te dèyè pèp Izrayèl la. Yo jwenn yo kote yo te moute tant yo a, bò lanmè a, toupre Pyakiròt anfas Baalsefon. ");
INSERT INTO hat_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Antan farawon an t'ap pwoche, moun Izrayèl yo leve je yo, yo wè moun peyi Lejip yo ki t'ap rapouswiv yo. Yo te pè anpil. Yo pran rele nan pye Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Yo di Moyiz konsa: -Eske se paske pa gen kote pou antere moun nan peyi Lejip la kifè ou mennen nou vin mouri isit la nan dezè a? Kisa ou fè nou konsa lè ou te fè nou soti kite Lejip la? ");
INSERT INTO hat_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Eske nou pa t' di ou sa lè nou te Lejip toujou? Nou te di ou: Kite nou travay pou moun peyi Lejip yo, pa vre! Pito nou travay pou moun peyi Lejip yo pase pou nou mouri nan dezè a. ");
INSERT INTO hat_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moyiz reponn pèp la: -Nou pa bezwen pè. Pran kouraj. Louvri je nou pou nou wè jan Seyè a pral delivre nou jòdi a. Moun peyi Lejip sa yo nou wè jòdi a, nou p'ap janm wè yo ankò. ");
INSERT INTO hat_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Seyè a ap goumen pou nou. Nou menm, poze san nou. ");
INSERT INTO hat_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Seyè a di Moyiz: -Poukisa w'ap rele konsa nan zòrèy mwen? Di moun pèp Izrayèl yo pou yo leve mache. ");
INSERT INTO hat_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ou menm, leve baton ou lan. Lonje men ou sou lanmè a, fann li de bò. Konsa, moun pèp Izrayèl yo va mache nan mitan lanmè a tankou sou tè sèk. ");
INSERT INTO hat_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","M'ap fè moun peyi Lejip yo fè tèt di pi rèd. Y'ap antre dèyè moun pèp Izrayèl yo nan mitan lanmè a. Mwen pral bat farawon an ansanm ak tout lame l' a, tout cha li yo ak tout kavalye l' yo. Sa va sèvi yon lwanj pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Lè m'a bat farawon an ansanm ak tout cha li yo ak kavalye li yo, moun peyi Lejip yo va konnen se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Zanj Bondye ki t'ap mache devan moun pèp Izrayèl yo chanje plas, li pase dèyè. Nwaj ki te devan yo a chanje plas tou, li pase dèyè yo. ");
INSERT INTO hat_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Li rete nan mitan ant moun peyi Lejip yo ak moun pèp Izrayèl yo. Nwaj la te tou nwa yon bò. Sou lòt bò a, li t'ap klere tout lannwit. Konsa, de lame yo pa t' ka pwoche yonn sou lòt pandan tout lannwit lan. ");
INSERT INTO hat_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moyiz lonje men l' sou lanmè a. Seyè a fè yon gwo van nòde soufle byen fò pandan tout lannwit lan sou lanmè a. Li fè fon lanmè a tounen tè sèk, dlo a fann de bò. ");
INSERT INTO hat_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Moun pèp Izrayèl yo antre sou tè sèk la, nan mitan lanmè a. Dlo a te kanpe de bò tankou yon miray sou bò dwat yo ak sou bò gòch yo. ");
INSERT INTO hat_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Moun peyi Lejip yo pran rapouswiv yo. Yo antre dèyè yo nan mitan lanmè a ak tout chwal farawon yo, tout cha li yo ak tout kavalye l' yo. ");
INSERT INTO hat_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Lè devanjou rive, Seyè a rete nan dife a ak nan nwaj la, li voye je l' sou lame peyi Lejip la, li lage yon sèl dezòd nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Li bloke wou cha yo. Sa te difisil anpil pou cha yo te vanse. Lè sa a, moun peyi Lejip yo di konsa: -Ann kouri kite moun Izrayèl yo an repo. Paske, Seyè a ap goumen pou yo kont nou. ");
INSERT INTO hat_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Lè sa a, Seyè a di Moyiz: -Lonje men ou sou lanmè a ankò. Dlo a ap tounen nan plas li, l'ap kouvri moun peyi Lejip yo ansanm ak tout cha yo ak kavalye yo. ");
INSERT INTO hat_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Se konsa, lè jou pral kase, Moyiz lonje men l' sou lanmè a, dlo a tounen nan plas li. Lè moun peyi Lejip yo wè dlo a ap vini sou yo, yo t'ap chache sove poul yo. Yo pran kouri. Men, Seyè a voye yo jete nan lanmè a. ");
INSERT INTO hat_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Dlo a tounen nan plas li, li kouvri cha yo, kavalye yo ak tout lame farawon an. Wi, li kouvri tout moun ki t'ap kouri dèyè moun pèp Izrayèl yo nan lanmè a. Pa gen yonn ki chape. ");
INSERT INTO hat_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Men, moun Izrayèl yo menm te mache nan mitan lanmè a tankou sou tè sèk. Dlo a te kanpe tankou yon miray sou bò dwat ak sou bò gòch yo. ");
INSERT INTO hat_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Sè jou sa a Seyè a te delivre pèp Izrayèl la anba men moun peyi Lejip yo. Moun pèp Izrayèl yo te wè kadav moun peyi Lejip yo sou tout bò lanmè a. ");
INSERT INTO hat_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Yo wè sa Seyè a te fè moun peyi Lejip yo pase ak fòs ponyèt pa li. Pèp Izrayèl la vin gen krentif pou Seyè a. Yo mete konfyans yo nan Seyè a ak nan Moyiz, sèvitè l' la. ");
INSERT INTO hat_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Lè sa a, Moyiz ak moun pèp Izrayèl yo chante yon chante pou Seyè a. Men sa chante a di: -M'ap chante pou Seyè a, paske li genyen batay la. Li voye chwal yo ak tout kavalye yo jete nan lanmè. ");
INSERT INTO hat_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Seyè a, se tout fòs mwen. Se pou li m'ap chante. Se li menm ki delivre m'. Se Bondye mwen li ye, m'ap fè lwanj li. Se Bondye zansèt mwen yo, m'ap di jan li gen pouvwa. ");
INSERT INTO hat_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Seyè a, se yon vanyan sòlda. Se Seyè yo rele l'. ");
INSERT INTO hat_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Li voye cha farawon yo ansanm ak tout lame l' a jete nan lanmè. Li fè pi bon sòlda li yo mouri neye nan lanmè Wouj la. ");
INSERT INTO hat_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Lanm lanmè a kouvri yo. Yo fè fon tankou ròch. ");
INSERT INTO hat_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Seyè, fòs bra dwat ou se kokenn zafè! Seyè, fòs bra dwat ou kraze lènmi an! ");
INSERT INTO hat_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Jan ou gen anpil pouvwa sa a, Seyè! Ou kraze moun k'ap goumen avè ou yo. Ou fè yon sèl kòlè, ou boule yo tankou dife nan pay. ");
INSERT INTO hat_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nan kolè ou, ou soufle. Souf ou fè dlo a ranmase kò l'. Lanm yo kanpe dwat tankou yon miray. Dlo a vin di nan mitan lanmè a. ");
INSERT INTO hat_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Lènmi an te di: M'ap kouri dèyè yo, m'ap pran yo. M'ap separe tout richès yo, m'ap pran tou sa m' vle. M'ap rale nepe mwen, avèk fòs ponyèt mwen, m'ap disparèt yo. ");
INSERT INTO hat_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ou annik fè yon ti van leve, lanmè a kouvri yo. Lanmè a te move, yo desann nan fon tankou plon. ");
INSERT INTO hat_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Seyè, nan tout bondye yo, kilès ki tankou ou! Pouvwa ou fè yo respekte ou! Ou se Bondye ki apa nèt! Kilès ki tankou ou? Ou menm ki fè mirak, ou menm ki fè mèvèy pou fè moun pè! Kilès ki tankou ou? ");
INSERT INTO hat_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ou annik lonje men dwat ou, tè a vale yo tou vivan. ");
INSERT INTO hat_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Paske ou gen bon kè, ou mennen pèp ou delivre a, avèk fòs ponyèt ou, ou mennen yo nan peyi ki apa pou ou a. ");
INSERT INTO hat_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Lòt pèp yo pran nouvèl sa ki pase, yo pran tranble tèlman yo pè. Yon sèl vant fè mal pran moun Filisti yo. ");
INSERT INTO hat_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ata chèf peyi Edon yo te pè anpil. Vanyan gason peyi Moab yo pran tranble. Tout moun nan peyi Kanaran pèdi kouraj. ");
INSERT INTO hat_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Yon sèl kè kase, yon sèl sezisman pran yo. Avèk fòs ponyèt ou, ou fè yo rete rèd san yo pa kapab fè anyen. Ou fè yo rete konsa jouk pèp ou a fin pase, Seyè, wi, jouk pèp ou delivre a fin pase! ");
INSERT INTO hat_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wa mennen yo, w'a plante yo sou mòn ki pou ou a, Seyè, sou mòn kote ou pare pou kay ou a, kay ou bati pou ou a, Seyè. ");
INSERT INTO hat_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Seyè a ap gouvènen pou tout tan. ");
INSERT INTO hat_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Chwal farawon yo ansanm ak tout cha ak kavalye yo te tonbe nan lanmè. Seyè a fè dlo a tounen nan plas li. Dlo a kouvri yo tout. Men, moun pèp Izrayèl yo menm te mache nan fon lanmè a tankou sou tè sèk. ");
INSERT INTO hat_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miryam, sè Arawon an, te yon pwofèt. Li pran yon tanbouren nan men l', tout medam yo t'ap mache dèyè l', yo t'ap bat tanbouren, yo t'ap danse. ");
INSERT INTO hat_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miryam t'ap chante pou yo, li t'ap di moun pèp Izrayèl yo: Annou chante pou Seyè a! Paske li genyen yon bèl batay! Li voye chwal yo jete nan fon lanmè ak tout kavalye yo sou yo. ");
INSERT INTO hat_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moyiz fè moun Izrayèl yo pati kite bò lanmè Wouj la. Yo mete tèt yo sou bò dezè Chou a. Yo t'ap mache depi twa jou nan dezè a san yo pa jwenn gout dlo pou yo bwè. ");
INSERT INTO hat_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Yo rive yon kote ki rele Mara. Men, yo pa t' kapab bwè dlo ki te la a, paske li te twò anmè. Se poutèt sa yo rele kote a Mara. ");
INSERT INTO hat_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Pèp la pran bougonnen sou do Moyiz nan dezè a. Yo mande l': -Atò, kisa pou nou bwè koulye a? ");
INSERT INTO hat_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moyiz rele Seyè a, li lapriyè nan pye l'. Seyè a moutre l' yon kalite pyebwa. Moyiz lage branch bwa a nan dlo a, dlo a vin dous. Se la Seyè a te ba yo lòd ak regleman pou yo swiv. Se la li t'ap chache sonde yo. ");
INSERT INTO hat_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Li di yo: -Se mwen menm ki Seyè a, Bondye nou an. Si nou koute m' lè m' pale nou, si nou fè tout sa ki dwat devan mwen, si nou louvri zòrèy nou pou swiv kòmandman mwen yo, pou nou kenbe lòd mwen ban nou, mwen p'ap voye malè sou nou, jan mwen te fè moun peyi Lejip yo. Se mwen menm, Seyè a, k'ap geri nou. ");
INSERT INTO hat_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Apre sa, yo rive Elim, yon kote ki te gen douz sous dlo ak swasanndis pye dat. Yo rete la, yo moute tant yo bò dlo a. ");
INSERT INTO hat_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Apre sa, tout moun pèp Izrayèl yo pati kite Elim, yo rive nan dezè yo rele Sin lan, ant Elim ak mòn Sinayi. Lè yo rive la, yo te gen yon mwa kenz jou depi yo te pati kite Lejip. ");
INSERT INTO hat_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Yo tout pran bougonnen sou do Moyiz ak Arawon nan dezè a. ");
INSERT INTO hat_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Yo t'ap di yo: -Poukisa Seyè a pa t' tou touye nou nan peyi Lejip la? Lè sa a, nou te konn chita devan bòl vyann nou, nou te konn manje pen plen vant nou. Men, ou menm ak Arawon, nou mennen nou nan dezè sa a pou fè tout kantite moun sa yo mouri grangou. ");
INSERT INTO hat_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Seyè a di Moyiz konsa: -Mwen pral fè pen tonbe soti nan syèl la pou nou tankou grenn lapli. Pèp la va soti chak jou pou l' ranmase mezi li bezwen pou jounen an. Konsa, m'a gade pou m' wè si wi ou non yo vle mache sou lòd mwen vre. ");
INSERT INTO hat_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Chak sizyèm jou nan senmenn lan, y'a ranmase de fwa lavalè sa yo konn ranmase lòt jou yo, y'a pare mete la. ");
INSERT INTO hat_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moyiz ak Arawon di tout moun pèp Izrayèl yo: -Aswè a n'a konnen se Seyè a ki te fè nou pati kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Denmen maten, n'a wè ki kalite pouvwa Seyè a genyen. Li tande jan n'ap bougonnen sou do li. Paske mwen menm ak Arawon, kisa nou ye pou se sou nou n'ap bougonnen konsa? Se sou Bondye n'ap bougonnen. ");
INSERT INTO hat_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Apre sa, Moyiz di yo: -Se Seyè a k'ap ban nou vyann pou nou manje chak swa. Se li k'ap ban nou kantite pen nou bezwen chak maten, paske Seyè a tande tout bougonnen n'ap bougonnen sou li a. Nou menm, kisa nou ye? Se pa sou nou n'ap bougonnen, men se sou Seyè a n'ap bougonnen. ");
INSERT INTO hat_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Lè sa a Moyiz di Arawon: -Men sa pou ou di tout moun pèp Izrayèl yo: Pwoche vin devan Seyè a paske li tande jan n'ap plenyen an. ");
INSERT INTO hat_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Pandan Arawon t'ap pale ak tout moun pèp Izrayèl yo, yo vire tèt yo bò dezè a, yo wè pouvwa Bondye a parèt nan nwaj la. ");
INSERT INTO hat_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Seyè a di Moyiz: ");
INSERT INTO hat_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","-Mwen tande jan moun pèp Izrayèl yo ap plenyen. Men sa pou ou di yo: Aswè a, anvan li fin fè nwa, n'a gen vyann pou nou manje. Denmen maten, n'a gen pen kantite nou bezwen. Lè sa a, n'a konnen se mwen menm, Seyè a, ki Bondye nou. ");
INSERT INTO hat_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Nan aswè, zòtolan vini, yo kouvri tout kote yo te moute tant yo a. Nan maten, te gen yon kouch lawouze toutalantou kote pèp la te moute tant yo a. ");
INSERT INTO hat_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Lè lawouze a disparèt, li kite yon kwout tou blan atè nan dezè a. Kwout la te fen, li te plen ti grenn tankou sèl, li te kouvri tout atè a. ");
INSERT INTO hat_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Lè moun pèp Izrayèl yo wè sa, yo pa t' konn sa l' te ye. Yonn t'ap di lòt: -Sa sa ye sa? Moyiz di yo: -Sa a, se pen Seyè a ban nou pou nou manje. ");
INSERT INTO hat_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Men lòd Seyè a ban nou: Se pou chak moun ranmase mezi yo bezwen pou kantite moun ki lakay yo. N'a ranmase twa ti mamit edmi pou chak moun. ");
INSERT INTO hat_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Moun pèp Izrayèl yo fè sa Moyiz te di yo fè a. Gen moun ki te ranmase plis, gen lòt ki te ranmase pi piti. ");
INSERT INTO hat_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Men, lè yo mezire, sa ki te ranmase plis yo pa t' gen twòp, sa ki te ranmase pi piti yo pa t' manke anyen. Konsa, chak moun te ranmase mezi yo te bezwen pou yo manje. ");
INSERT INTO hat_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moyiz di yo: -Piga pesonn sere anyen pou denmen. ");
INSERT INTO hat_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Men gen moun ki pa t' koute Moyiz. Yo sere ti gout pou denmen maten. Nan denmen yo jwenn li plen vè, li te gate. Moyiz te fache sou moun sa yo. ");
INSERT INTO hat_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Chak maten yo ranmase mezi yo te bezwen pou yo manje. Men, kou solèy la konmanse cho, bagay la te fonn. ");
INSERT INTO hat_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Sizyèm jou nan senmenn lan, yo te ranmase de fwa lavalè sa yo te konn ranmase chak jou a. Yo te ranmase sèt ti mamit pou chak moun. Tout chèf fanmi ki te alatèt pèp la vin di Moyiz sa. ");
INSERT INTO hat_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Moyiz reponn yo: -Men lòd Seyè a te bay: Denmen se jou repo, se jou repo ki apa pou Seyè a. Kwit sa nou gen pou nou kwit. Bouyi sa nou gen pou nou bouyi. N'a sere rès la pou denmen. ");
INSERT INTO hat_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Jan Moyiz te ba yo lòd la, yo sere rès la pou denmen. Li pa t' gate, vè pa t' tonbe ladan l'. ");
INSERT INTO hat_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moyiz di yo: -Nou mèt manje rès la jòdi a, paske jòdi a se jou repo yo mete apa pou Seyè a. Jòdi a nou p'ap jwenn anyen deyò a. ");
INSERT INTO hat_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Pandan sis premye jou senmenn lan n'a jwenn pou n' ranmase. Men setyèm jou a, jou repo a, nou p'ap jwenn anyen pou nou ranmase. ");
INSERT INTO hat_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Setyèm jou a, gen kek moun nan pèp la ki te soti al ranmase manje, men yo pa jwenn anyen. ");
INSERT INTO hat_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Lè sa a, Seyè a di Moyiz: -Kilè n'a sispann dezobeyi lòd ak kòmandman mwen yo? ");
INSERT INTO hat_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Konprann sa byen, se mwen menm, Seyè a, ki te ban nou jou repo sa a. Se poutèt sa, sou sizyèm jou nan senmenn lan, mwen ban nou manje valè pou de jou. Nan setyèm jou senmenn lan, se pou tout moun rete kote yo ye a. Piga pesonn mete tèt deyò. ");
INSERT INTO hat_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Se konsa, lè setyèm jou a rive, pèp la pa fè ankenn travay. ");
INSERT INTO hat_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Pèp Izrayèl la rele manje a laman. Li te gen fòm grenn pitimi. Li te tou blan, li te gen menm gou ak gato ki fèt ak siwo myèl. ");
INSERT INTO hat_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moyiz di yo: -Men lòd Seyè a ban nou. Se pou nou sere twa ti mamit edmi plen laman pou pitit pitit nou yo. Konsa y'a wè ki kalite manje mwen te konn ban nou nan dezè a, lè mwen te fè nou soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Apre sa Moyiz di Arawon: -Pran yon ti ja, mete twa ti mamit edmi laman ladan l'. Mete l' devan Seyè a pou l' ka rete pou pitit pitit nou yo. ");
INSERT INTO hat_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Arawon fè sa Seyè a te bay Moyiz lòd fè a. Li mete ti ja a devan Bwat Kontra a, li sere l' la. ");
INSERT INTO hat_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Moun pèp Izrayèl yo pase karantan ap manje laman, jouk jou yo rive nan yon peyi kote yo jwenn moun rete. Kifè yo manje laman jouk yo rive sou fwontyè peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Twa ti mamit edmi, se valè twaka yon gwo mamit. Trannsenk ti mamit fè yon gwo bidon. ");
INSERT INTO hat_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Tout moun pèp Izrayèl yo pati, yo kite dezè Sin lan, dapre lòd Seyè a te ba yo. Yo fè wout la moso pa moso, jouk yo rive Refidim kote yo moute tant yo. Men, pa t' gen dlo la pou pèp la te bwè. ");
INSERT INTO hat_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Yo leve fè kont ak Moyiz. Yo di l': -Ban nou dlo pou nou bwè! Moyiz reponn yo: -Poukisa n'ap chache m' kont konsa? Pouki n'ap sonde Seyè a konsa? ");
INSERT INTO hat_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Men, pèp la te swaf dlo anpil, yo t'ap bougonnen sou do Moyiz. Yo di l': -Poukisa ou fè nou soti kite peyi Lejip la? Gen lè se pou te fè nou vin mouri swaf dlo isit la, avèk pitit nou yo ansanm ak tout bèt nou yo? ");
INSERT INTO hat_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moyiz menm lapriyè nan pye Bondye. Li di l' konsa: -Kisa pou m' fè ak moun sa yo? Yo san lè touye m' ak kout ròch! ");
INSERT INTO hat_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Seyè a di Moyiz: -Pran kèk chèf fanmi pèp Izrayèl la avèk ou, pase devan pèp la. Kenbe baton ou te sèvi pou frape gwo la rivyè Nil lan nan men ou. Epi mache. ");
INSERT INTO hat_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mwen menm, m'ap kanpe laba a, dwat devan ou, sou tèt gwo ròch Orèb la. W'a frape ròch la, dlo va soti ladan l'. Pèp la va bwè. Se sa menm Moyiz te fè devan chèf fanmi pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yo rele kote sa a Masa ak Meriba, paske pèp Izrayèl la t'ap chache kont, yo t'ap sonde Seyè a lè yo te mande: Eske Seyè a nan mitan nou, wi ou non? ");
INSERT INTO hat_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Antan pèp Izrayèl la Refidim, moun Amalèk yo vin pou goumen ak yo. ");
INSERT INTO hat_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moyiz di Jozye konsa: -Chwazi kèk gason pou nou. Denmen w'a soti al goumen ak moun Amalèk yo. Mwen menm, m'a moute sou tèt ti mòn lan avèk baton Bondye te ban mwen an nan men mwen. ");
INSERT INTO hat_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Jozye fè tou sa Moyiz te di l' fè. Li soti al goumen ak moun Amalèk yo. Moyiz menm moute sou tèt ti mòn lan ansanm ak Arawon ak Our. ");
INSERT INTO hat_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tout tan Moyiz te kenbe men l' yo leve anlè, se moun Izrayèl yo ki te pi fò. Men, kou Moyiz bese men l', se moun Amalèk yo ki te pi fò. ");
INSERT INTO hat_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Rive yon lè Moyiz te bouke, de bra l' t'ap fè l' mal. Arawon ak Our pran yon ròch, yo mete l' deyè Moyiz, yo fè Moyiz chita sou li. Yo chak pran yon bra Moyiz, yo kenbe yo anlè. Yo kenbe yo konsa jouk solèy kouche. ");
INSERT INTO hat_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Jozye menm te bat Amalèk ak moun li yo byen bat, li touye yo anba kout nepe. ");
INSERT INTO hat_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Apre sa, Seyè a di Moyiz: -Ekri sa nan liv rejis la pou moun yo pa janm bliye batay sa a. W'a di Jozye konsa m'ap efase non Amalèk sou latè pou yo pa janm chonje l' ankò. ");
INSERT INTO hat_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moyiz bati yon lòtèl, li rele l': Seyè a se drapo m'. ");
INSERT INTO hat_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Apre sa li di: -Men mwen leve men m' devan fotèy Seyè a, Seyè a p'ap janm sispann goumen ak moun Amalèk yo. ");
INSERT INTO hat_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jetwo te pran nouvèl tou sa Bondye te fè pou Moyiz ak pèp Izrayèl la, jan li te fè yo soti kite peyi Lejip. Jetwo sa a te prèt nan peyi Madyan. Se bòpè Moyiz li te ye. ");
INSERT INTO hat_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Anvan tout bagay sa yo te rive, Moyiz te voye Sefora, madanm li, al jwenn Jetwo, papa li. Koulye a, Jetwo mennen Sefora tounen bay Moyiz ");
INSERT INTO hat_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ansanm ak Gèchon ak Elyezè, de pitit gason Moyiz yo. Lè timoun sa yo t'ap fèt Moyiz te di: Se moun vini mwen ye nan yon peyi etranje. Se konsa li te rele yonn Gèchon. ");
INSERT INTO hat_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Moyiz te di tou: Se Bondye papa m' ki te pote m' sekou, ki te sove m' anba pèsekisyon farawon an. Se konsa li te rele lòt la Elyezè. ");
INSERT INTO hat_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jetwo, bòpè Moyiz la, pran madanm Moyiz ak de pitit gason l' yo, li vin wè Moyiz nan dezè kote l' te moute tant li a, sou mòn Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jetwo voye di Moyiz: -Se mwen menm, Jetwo, bòpè ou, k'ap vin wè ou ansanm ak madanm ou ak de pitit gason ou yo. ");
INSERT INTO hat_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moyiz soti al kontre bòpè li, li bese tèt li jouk atè devan l' pou di li bonjou, epi li bo l'. Yonn mande lòt ki jan yo ye, epi yo antre anba tant Moyiz la. ");
INSERT INTO hat_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moyiz rakonte bòpè l' tou sa Seyè a te fè farawon an ak moun peyi Lejip yo pase poutèt pitit Izrayèl yo. Li di l' tout tray yo te pase nan vwayaj la ak ki jan Seyè a te delivre yo. ");
INSERT INTO hat_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jetwo te kontan anpil lè l' tande tout bèl bagay Seyè a te fè pou pèp Izrayèl la, jan l' te delivre yo anba men moun peyi Lejip yo. ");
INSERT INTO hat_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jetwo di: -Lwanj pou Seyè a ki delivre ou anba men moun peyi Lejip yo ak anba men farawon an! Lwanj pou Seyè a ki wete pèp li a anba esklavaj moun peyi Lejip yo! ");
INSERT INTO hat_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Koulye a mwen konnen Seyè a gen plis pouvwa pase tout lòt bondye yo, paske gade jan Bondye delivre pèp Izrayèl la anba moun peyi Lejip yo ki pa t' vle wè yo! ");
INSERT INTO hat_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Apre sa, Jetwo, bòpè Moyiz la, ofri bèt pou yo touye pou di Bondye mèsi. Li ofri bèt pou yo boule nèt pou Seyè a. Arawon ansanm ak tout chèf fanmi pèp Izrayèl la te vin manje ak bòpè Moyiz la nan manje yo t'ap manje devan Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Nan denmen, Moyiz te chita pou rann jijman sou tout bagay ki pase nan mitan pèp la. Depi maten jouk aswè, moun t'ap pase devan Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Lè Jetwo, bòpè Moyiz la, wè kalite travay di sa a Moyiz t'ap fè pou kò l' pou pèp la, li di l' konsa: -Kisa w'ap fè konsa ak pèp la? Poukisa pou pèp la kanpe devan ou depi maten jouk aswè, epi se ou menm ki chita la pou kont ou ap rann jijman? ");
INSERT INTO hat_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moyiz reponn bòpè l' konsa: -Se sa pou m' fè paske pèp la vin kote m' pou yo ka konnen sa Bondye vle yo fè nan tout sikonstans. ");
INSERT INTO hat_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Lè yo gen kont, yo vin jwenn mwen, mwen regle sa pou yo, mwen fè yo konnen volonte Bondye ak sa Bondye mande yo pou yo fè. ");
INSERT INTO hat_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Bòpè Moyiz la di l' konsa: -Jan w'ap fè l' la pa bon. ");
INSERT INTO hat_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","W'ap fin kraze kouraj ou ansanm ak kouraj pèp la ki la avè ou. Paske chay la twòp pou ou. Ou pa ka pote l' pou kont ou. ");
INSERT INTO hat_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Bon. Koute sa m'ap di ou: se yon konsèy m'ap ba ou pou Bondye ka ede ou. Se ou menm ki va prezante pou pèp la devan Bondye. W'a mete tout pwoblèm yo devan Bondye. ");
INSERT INTO hat_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","W'a moutre yo lòd Bondye, Seyè a, bay ansanm ak sa li mande yo pou yo fè. W'a fè yo konnen jan pou yo viv ak sa yo dwe fè. ");
INSERT INTO hat_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Men, w'a chwazi nan mitan pèp la kèk moun ki kapab, moun ki gen krentif pou Bondye. Fòk se moun ou ka konte sou yo, moun ki p'ap kite lajan pran nanm yo. W'a mete yo chèf pou dirije pèp la, chèf sou mil moun, chèf sou san moun, chèf sou senkant moun ak chèf sou dis moun. ");
INSERT INTO hat_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Moun sa yo va toujou la pou sèvi jij pou pèp la. Lè y'a gen gwo zafè, y'a pote yo devan ou. Men lòt ti zafè, y'a regle sa yo menm. Konsa, chay la va pi lejè pou ou, paske y'a ede ou pote l'. ");
INSERT INTO hat_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si ou fè sa, Bondye va dirije ou. W'a kapab fè travay ou, epitou, tout pèp la va tounen lakay li ak kè poze. ");
INSERT INTO hat_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moyiz koute konsèy bòpè l' la vre. Li fè tou sa Jetwo te di l' fè yo. ");
INSERT INTO hat_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moyiz chwazi nan mitan pèp Izrayèl la kèk nèg ki kapab dirije pèp la, li mete yo chèf sou mil moun, chèf sou san moun, chèf sou senkant moun ak chèf sou dis moun. ");
INSERT INTO hat_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Yo te toujou la pou rann jistis pou pèp la. Yo te pote gwo zafè yo devan Moyiz. Men ti ka piti yo, yo te regle sa yo menm. ");
INSERT INTO hat_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Apre sa, Moyiz kite bòpè l' la pati. Epi Jetwo tounen tounen l' nan peyi l'. ");
INSERT INTO hat_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Moun Izrayèl yo te gen de mwa depi yo te soti kite peyi Lejip la. Premye jou twazyèm mwa a, yo rive nan dezè Sinayi a. ");
INSERT INTO hat_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Lè yo kite Refidim, yo rive nan dezè Sinayi a. Se la yo moute tant yo, anfas mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moyiz moute sou mòn lan, l' al bò kote Bondye. Seyè a rete sou tèt mòn lan, li rele Moyiz, li di l': -Men sa pou ou di moun fanmi Jakòb yo, men sa pou ou fè pèp Izrayèl la konnen: ");
INSERT INTO hat_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Seyè a pale, li voye di nou konsa: Nou wè sa mwen te fè moun peyi Lejip yo. Nou wè ki jan mwen te pote nou tankou malfini pote pitit li yo sou do li, mwen fè nou vin jwenn mwen. ");
INSERT INTO hat_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Koulye a menm, si nou koute sa mwen di nou, si nou kenbe kontra mwen an, se nou menm m'ap chwazi pou moun pa m' nan mitan tout pèp ki sou latè. Tout latè se pou mwen, se vre. ");
INSERT INTO hat_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Men nou menm, n'ap vini yon nasyon moun k'ap sèvi m' tankou prèt, yon pèp k'ap viv apa pou mwen. Wi, se sa pou ou di moun Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moyiz ale, li fè sanble tout chèf fanmi pèp la, li rapòte yo tou sa Seyè a te ba li lòd di yo. ");
INSERT INTO hat_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Tout pèp la reponn ansanm, yo di: -N'a fè tou sa Seyè a di nou fè. Apre sa, Moyiz al rapòte bay Seyè a repons pèp la. ");
INSERT INTO hat_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Seyè a di Moyiz: -M'ap vin jwenn ou nan yon gwo nwaj byen pwès. Konsa pèp la va tande lè m'ap pale avè ou, y'a toujou kwè nan ou. Moyiz rakonte Seyè a sa pèp la te reponn. ");
INSERT INTO hat_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Seyè a di Moyiz: -Ale bò kote pèp la. Fè yo pran jounen jòdi a ak jounen denmen an pou yo mete yo nan kondisyon pou fè sèvis pou mwen. Se pou yo lave rad yo. ");
INSERT INTO hat_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Se pou yo pare pou twazyèm jou a. Paske, sou twa jou mwen menm, Seyè a, m'ap desann sou mòn Sinayi a pou tout moun ka wè m'. ");
INSERT INTO hat_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","W'a mete yon limit toutalantou mòn lan pou pèp la pa depase. W'a avèti yo pou yo pa moute sou mòn lan, ni pou pesonn pa menm pwoche bò pye mòn lan. Nenpòt moun ki va mete pye sou mòn lan, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","y'a kalonnen l' kout ròch osinon y'a pèse l' ak kout flèch jouk li mouri, san pesonn p'ap bezwen manyen li ak men yo. Kit se yon moun, kit se yon bèt, se pou yo touye l'. Lè y'a tande kòn lan kònen, se lè sa a y'a moute sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moyiz desann soti sou mòn lan, l' al bò kote pèp la. Li fè yo mete tèt yo nan kondisyon pou fè sèvis pou Seyè a. Yo lave rad yo. ");
INSERT INTO hat_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Apre sa, Moyiz di yo: -Pare nou pou apre denmen. Pa kouche ak ankenn fanm. ");
INSERT INTO hat_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Sou twazyèm jou a vre, nan granmaten, loraj t'ap gwonde sou mòn lan. Te gen zèklè ak yon gwo nwaj byen pwès sou mòn lan tou. Yon twonpèt t'ap kònen byen fò. Tout moun t'ap tranble kou fèy bwa kote yo te ye a, sitèlman yo te pè. ");
INSERT INTO hat_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moyiz fè pèp la soti kote yo te moute tant yo a pou y al kontre Bondye. Yo rete nan pye mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tout mòn Sinayi a te kouvri nèt ak lafimen, paske Seyè a te desann sou li nan mitan yon gwo dife. Lafimen t'ap moute tankou nan yon fou lacho. Tout mòn lan t'ap tranble avèk fòs. ");
INSERT INTO hat_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Twonpèt la t'ap kònen pi fò toujou. Moyiz t'ap pale, Bondye t'ap reponn li byen fò avèk yon bri ou ta di yon bri loraj. ");
INSERT INTO hat_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Seyè a desann sou mòn Sinayi a, sou tèt mòn lan menm. Li rele Moyiz sou tèt mòn lan. Moyiz moute al jwenn li. ");
INSERT INTO hat_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Seyè a di Moyiz konsa: -Desann, avèti pèp la pou yo pa depase limit la, paske yo ka pran kouri vin gade mwen. Lè sa a, anpil ladan yo ta kapab mouri. ");
INSERT INTO hat_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ata prèt yo ki ka pwoche bò kote m', se pou yo mete tèt yo nan kondisyon pou sa tou. Si se pa sa, mwen ka touye yo. ");
INSERT INTO hat_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moyiz di Seyè a: -Pèp la p'ap kapab moute sou mòn Sinayi a, paske se ou menm ki defann yo moute, lè ou te di: Trase yon limit toutalantou mòn lan, mete l' apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Lè sa a Seyè a di Moyiz: -Desann non. Epi tounen ansanm ak Arawon. Men pa kite prèt yo ak pèp la depase limit ou te ba yo a pou yo kouri vin kote m'. Si yo fè sa, m'ap touye yo. ");
INSERT INTO hat_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moyiz desann bò kote pèp la, li di yo tout bagay. ");
INSERT INTO hat_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Bondye pran pale, li di: ");
INSERT INTO hat_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","-Se mwen menm, Seyè a, Bondye nou an, ki te fè nou soti nan peyi Lejip kote nou te esklav la. ");
INSERT INTO hat_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Piga nou gen lòt bondye pase mwen menm sèlman. ");
INSERT INTO hat_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Piga nou janm fè ankenn estati ni ankenn pòtre ki sanble bagay ki anwo nan syèl la, osinon bagay ki sou latè ou ankò nan dlo anba tè a. ");
INSERT INTO hat_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Piga nou adore yo, ni piga nou sèvi yo. Paske mwen menm, Seyè a, Bondye nou an, mwen se yon Bondye ki fè jalouzi. Lè yon moun rayi m', mwen fè pitit li, pitit pitit li ak pitit pitit pitit li yo peye sa. ");
INSERT INTO hat_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Men, lè yon moun renmen m', lè li fè sa m' mande l' fè, m'ap moutre l' jan mwen renmen l' tou ansanm ak tout pitit pitit li yo pandan mil jenerasyon. ");
INSERT INTO hat_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Piga nou sèvi mal ak non Seyè a, Bondye nou an, paske Seyè a p'ap manke pa pini moun ki sèvi mal avèk non li. ");
INSERT INTO hat_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Toujou chonje jou repo a pou nou mete l' apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","N'a travay sis jou. Lè sa yo n'a fè tou sa nou gen pou fè. ");
INSERT INTO hat_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Men, setyèm jou a, se jou repo pou nou mete apa pou Seyè a, Bondye nou an. Jou sa a, nou p'ap fè ankenn travay, ni nou menm, ni pitit gason nou, ni pitit fi nou, ni moun k'ap travay lakay nou, ni bèt nou yo, ni etranje ki lakay nou. ");
INSERT INTO hat_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Paske, Seyè a te pran sis jou pou l' fè syèl la, latè a ak lanmè a ansanm ak tou sa ki ladan yo. Apre sa, sou setyèm jou a, li pran repo. Se poutèt sa, Seyè a beni jou repo a, li mete l' apa pou li. ");
INSERT INTO hat_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Respekte manman nou ak papa nou pou nou ka viv lontan nan peyi Seyè a, Bondye nou an, ban nou an. ");
INSERT INTO hat_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Piga nou touye moun. ");
INSERT INTO hat_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Piga nou fè adiltè. ");
INSERT INTO hat_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Piga nou pran sa ki pa pou nou. ");
INSERT INTO hat_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Piga nou bay manti sou frè parèy nou. ");
INSERT INTO hat_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Piga nou pote lanvi sou sa ki pa pou nou: ni sou kay frè parèy nou, ni sou madanm li, ni sou moun k'ap sèvi lakay li, ni sou bèf li, ni sou bourik li, ni sou ankenn lòt bagay ki pou frè parèy nou. ");
INSERT INTO hat_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Lè pèp la tande bri loraj la ak son twonpèt la, lè yo wè kout zèklè sou kout zèklè, ak mòn lan ki t'ap pouse lafimen, yo tranble sitèlman yo te pè. Yo ret kanpe byen lwen. ");
INSERT INTO hat_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Yo di Moyiz konsa: -Pito se ou menm ki pale ak nou, n'a koute sa w'ap di. Men, si se Bondye ki pou pale avèk nou, n'a mouri. ");
INSERT INTO hat_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moyiz di pèp la: -Nou pa bezwen pè. Bondye vini pou wè kote nou ye avèk li. Li vle pou nou toujou gen krentif pou li, pou nou pa lage kò nou nan fè peche. ");
INSERT INTO hat_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Men pèp la rete kanpe byen lwen. Sèl Moyiz te pwoche kote nwaj nwa a kote Bondye te ye a. ");
INSERT INTO hat_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Seyè a di Moyiz: -Men sa pou ou di moun pèp Izrayèl yo: Nou wè ki jan mwen ret nan syèl la pou m' pale ak nou. ");
INSERT INTO hat_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Piga n al fè lòt bondye an ajan osinon an lò pou nou sèvi yo ansanm avè m'. ");
INSERT INTO hat_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","N'a bati yon lòtèl an tè pou mwen. Se sou li n'a ofri bèt n'a touye pou boule nèt yo ak bèt n'a touye pou di mèsi. Se sou li n'a ofri mouton ak bèf nou yo. Chak kote m'a di nou pou nou fè sèvis pou mwen, m'a vin jwenn nou la, m'a beni nou. ");
INSERT INTO hat_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Si nou fe yon lòtèl ak ròch pou mwen, pa travay ròch n'a pran pou fè l' la. Paske lè ou travay yon ròch ak sizo, li pa ka sèvi pou mwen ankò. ");
INSERT INTO hat_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Piga nou sèvi ak macheskalye pou nou moute sou lòtèl mwen pou moun pa wè anba rad nou. ");
INSERT INTO hat_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","-Men regleman w'a mete devan moun pèp Izrayèl yo: ");
INSERT INTO hat_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Lè ou achte yon moun menm ras avè ou pou sèvi ou esklav, li gen pou l' sèvi ou sizan. Lè setyèm lanne a rive, l'a lib. L'a gen dwa al fè wout li san l' pa gen anyen pou l' peye ou. ");
INSERT INTO hat_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Si li te pou kont li lè l' te vini an, li va ale pou kont li. Si li te gen madanm lè l' te vini an, madanm lan va ale avè l'. ");
INSERT INTO hat_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si se mèt li ki te ba li madanm, epi madanm lan te fè pitit pou li, ni pitit yo, ni manman lan va rete pou mèt la. Msye va al fè wout li pou kont li. ");
INSERT INTO hat_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Men, si esklav la di: Mwen renmen mèt mwen, mwen renmen madanm mwen ak pitit mwen yo, mwen pa vle vin lib ankò, ");
INSERT INTO hat_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","enben, lè sa a, mèt la va mennen l' devan Bondye. L'a fè l' pwoche bò pòt la, osinon bò chanbrann pòt la, l'a pèse zòrèy li ak yon bagay pwenti. Konsa esklav la va rete ap sèvi li jouk li mouri. ");
INSERT INTO hat_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Lè yon nonm vann pitit fi li pou sèvi esklav, pitit fi sa a pa ka lib ankò, jan yo ka fè l' pou gason yo. ");
INSERT INTO hat_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si mèt la te fin dakò pou l' te pran fi a pou madanm, epi si apre sa fi a pa fè l' plezi ankò, msye va fè yon jan pou papa ak manman fi a achte l' nan men li ankò. Men, li pa gen dwa vann li bay yon moun lòt nasyon, paske se trayi l'a trayi fi a lè sa a. ");
INSERT INTO hat_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Men, si li te fè lide bay pitit gason l' fi a, se pou l' aji avè l' tankou si se te pròp pitit fi li. ");
INSERT INTO hat_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Si li pran yon lòt madanm sou li, li pa gen dwa wete anyen sou sa li dwe l': ni sou manje l', ni sou rad li, epi se pou l' toujou sevi ak li tankou madanm li. ");
INSERT INTO hat_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Si li pa fè twa bagay sa yo pou li, madanm lan gen dwa ale fè wout li, san li pa gen anyen pou l' peye mèt la, san bay senk kòb. ");
INSERT INTO hat_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Si yon moun leve men l' sou yon lòt, epi li touye l', moun sa a, se pou yo touye l' tou. ");
INSERT INTO hat_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Men, si se pa espre li fè, si se Bondye ki fè lòt moun lan tonbe anba men l', m'ap chwazi yon kote pou l' ale kache kò l'. ");
INSERT INTO hat_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Men, si yon moun chache yon lòt kont, epi li fè plan pou li touye l', li te mèt al kache bò kote lòtèl mwen an, se pou n al pran l' pou nou touye l'. ");
INSERT INTO hat_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Si yon moun leve men l' sou papa l' osinon sou manman l', se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Si yon moun pran yon lòt pa fòs pou l' al vann li osinon pou kenbe l' lakay li, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Si yon moun bay papa l' osinon manman l' madichon, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Lè de moun gen kont, si yonn bay lòt yon koutwòch osinon yon koutpwen, epi si sak resevwa kou a pa mouri, men li blije pran kabann, men jan pou sa regle: ");
INSERT INTO hat_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Si li ka leve, si li ka mache pwonmennen ak baton, y'a fè pa moun ki te ba l' kou a. Tansèlman, l'a gen pou l' peye lòt la dedomajman pou tout jou li fè rete san travay, epi l'a reskonsab pran swen l' jouk li geri. ");
INSERT INTO hat_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Lè yon moun leve men l' sou yon esklav li, kit se gason, kit se fi, pou ba li koutbaton, si esklav la mouri frèt, se pou yo pini mèt la. ");
INSERT INTO hat_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Men, si esklav la fè yon jou osinon de jou anvan l' mouri, se pa nesesè pou yo pini mèt la, paske se lajan pa l' li te mete deyò pou l' achte l'. ");
INSERT INTO hat_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Lè gason ap goumen, si nan voye kou yo frape yon fanm ansent, epi si fanm lan fè foskouch san anyen ankò pa rive l', moun ki ba l' kou a va peye dedomajman dapre sa mari a va mande. L'a peye sa jij yo va deside. ");
INSERT INTO hat_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Men, si malè rive fanm lan, y'a fè l' peye lavi pou lavi, ");
INSERT INTO hat_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","yon je pou yon je, yon dan pou yon dan, yon men pou yon men, yon pye pou yon pye, ");
INSERT INTO hat_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","boule pou boule, blese pou blese, foule pou foule. ");
INSERT INTO hat_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Lè yon moun frape yon esklav li nan je, kit se yon gason, kit se yon fanm, si esklav la pèdi je a, mèt la va ba li libète l' pou dedomajman pou je a. ");
INSERT INTO hat_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Si se dan yon esklav li rache, l'a ba li libète li pou dedomajman pou dan an. ");
INSERT INTO hat_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Lè yon bèf touye yon gason osinon yon fanm ak koutkòn, se pou yo touye l' ak koutwòch. Se pa pou yo manje vyann lan, ni yo pa bezwen fè mèt bèf la peye anyen. ");
INSERT INTO hat_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Men, si se pa premye fwa bèf la atake moun, si yo te pale mèt li men mèt li pa t' fè anyen pou sa, si bèf la touye yon gason osinon yon fanm, nan ka sa a y'ap toujou touye bèf la ak koutwòch, epi y'a touye mèt la tou pou pini l'. ");
INSERT INTO hat_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Men, si yo mande mèt bèf la pou l' peye pou l' ka sove lavi pa l', se pou l' peye tou sa y'a mande l' la. ");
INSERT INTO hat_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Si bèf la atake yon ti gason osinon yon ti fi, se menm règleman an ki pou fèt. ");
INSERT INTO hat_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si bèf la atake yon esklav, kit se gason, kit se fi, mèt bèf la va bay mèt esklav la trant pyès an ajan. Bèf la menm, y'a touye l' ak koutwòch. ");
INSERT INTO hat_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Si yon moun kite yon pi dekouvri, ou ankò si l'ap fouye yon pi epi li kite l' san kouvèti, si yon bèf osinon yon bourik vin tonbe ladan l', ");
INSERT INTO hat_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","se pou mèt pi a peye mèt bèt la sa bèt la vo. Bèt mouri a menm va rete pou mèt pi a. ");
INSERT INTO hat_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Si yon moun gen yon bèf ki touye bèf yon lòt moun ak yon koutkòn, de mesye yo va vann bèf vivan an, y'a separe lajan an mwatye pou mwatye. y'a separe vyann bèf ki mouri a tou. ");
INSERT INTO hat_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Men, si se pa premye fwa bèf la ap bay koutkòn, si yo te pale mèt li men mèt li pa t' fè anyen pou sa, nan ka sa a, mèt bèf la gen pou peye. L'a bay yon bèf vivan pou bèf ki mouri a. Bèf mouri a menm va rete pou li. ");
INSERT INTO hat_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Si yon moun vòlò yon bèf osinon yon mouton, si li touye l' epi li vann li, li gen pou l' bay senk bèf pou bèf li pran an osinon kat mouton pou mouton li pran an. ");
INSERT INTO hat_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si yo bare yon vòlè ap kase yon kay epi yo touye l', moun ki touye l' la pa koupab. ");
INSERT INTO hat_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Men, si sa rive apre solèy fin leve, moun ki touye l' la koupab. Li gen pou l' peye pou li, wè pa wè. Si li pa gen anyen, y'a vann li pou yo ka peye pou sa l' te vòlò a. ");
INSERT INTO hat_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Men, si yo jwenn bèt li te vòlò a vivan nan men l' toujou, kit se bèf, kit se kabrit, kit se bourik, l'a renmèt de pou yonn. ");
INSERT INTO hat_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si yon moun kite bèt li manje nan jaden yon lòt, osinon nan jaden rezen li, si yon moun kite bèt li lage pou yo fè kont dega nan jaden yon lòt moun, li gen pou l' dedonmaje lòt moun lan. L'a ba li pi bon bagay li gen nan jaden pa l' la osinon nan jaden rezen l' yo. ");
INSERT INTO hat_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si yon dife pran yon kote, li tonbe nan zèb chèch epi li rive boule danre ki nan depo, osinon grenn ki fin keyi, ou ankò yon jaden tou plante, moun ki lakòz dife a va peye yon dedomajman. ");
INSERT INTO hat_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Si yon moun pran lajan l' osinon yon bagay ki gen anpil valè, li bay yon lòt moun sere l' pou li, si yo rive vòlò bagay sa yo nan kay moun ki te sere yo a, si yo jwenn vòlè a, vòlè a va gen pou renmèt de fwa lavalè. ");
INSERT INTO hat_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Men, si yo pa jwenn vòlè a, y'a mennen mèt kay kote bagay yo te sere a devan lòtèl Bondye a, pou yo wè si se pa li menm ki te pran bagay lòt moun lan. ");
INSERT INTO hat_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Si yon moun pèdi yon bagay, kit se yon bèf, osinon yon bourik, ou ankò yon mouton, kit se yon rad ou nenpòt lòt bagay, si lè yo jwenn sak te pèdi a yon lòt moun pretann di se pou li li ye, y'a mennen yo tou de devan lòtèl Bondye a pou regle sa. Moun Bondye va kondannen an va gen pou l' bay lòt la de fwa lavalè pou dedomajman. ");
INSERT INTO hat_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Si yon moun bay yon frè parèy li gade yon bourik, yon bèf, yon mouton, ou ankò nenpòt ki lòt bèt pou li, si bèt la mouri osinon si malè rive l' ou ankò si piyajè pran l' san pesonn pa wè sa, ");
INSERT INTO hat_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","lè sa a, y'a mande ni mèt bèt la ni gadò a pou yo fè sèman devan lòtèl Bondye a. Moun ki t'ap gade bèt la va deklare se pa li menm ki te pran bèt lòt moun lan. Lè sa a, mèt bèt la va asepte pèt la. Gadò a p'ap gen ankenn dedomajman pou l' bay. ");
INSERT INTO hat_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Men si se vòlò yo te vòlò bèt la nan men l', l'a gen pou l' peye mèt la kichòy. ");
INSERT INTO hat_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si se bèt nan bwa ki devore bèt la, l'a pote rès la pou mèt bèt la ka wè ak de je l' se pa manti l'ap ba li. Li p'ap gen anyen pou l' peye pou sa. ");
INSERT INTO hat_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Si yon moun prete yon bèt nan men yon frè parèy li, epi malè rive bèt la, osinon li mouri an absans mèt li, se pou l' peye mèt bèt la kichòy. ");
INSERT INTO hat_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Men, si mèt la te la lè malè a rive, moun lan pa gen anyen pou l' peye. Si se yon bèt li te lwe, se pri li te lwe l' la ase pou li bay. ");
INSERT INTO hat_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si yon nonm pran tèt yon jenn fi ki poko fiyanse, epi li kouche avè l', li gen pou l' peye lajan yo konn bay pou yon maryaj, epi se pou l' marye ak jenn fi a. ");
INSERT INTO hat_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Men, si papa jenn fi a refize kite l' marye avè l', tout jan se pou msye peye lajan yo bay lè yo pral marye ak yon fi ki tifi. ");
INSERT INTO hat_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Se pou nou touye tout fanm k'ap fè maji. ");
INSERT INTO hat_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Se pou yo touye tout moun ki kwaze ak zannimo. ");
INSERT INTO hat_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Si yon moun ofri bèt pou yo touye pou lòt bondye pase Seyè a, se pou yo disparèt li tankou bèt y'ap ofri bay Bondye. ");
INSERT INTO hat_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Piga nou maltrete moun lòt nasyon ki vin rete nan peyi nou. Piga nou peze yo non plis, paske nou menm, chonje nou te etranje tou nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Piga nou maltrete ni vèv yo, ni timoun san papa yo. ");
INSERT INTO hat_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si nou malmennen yo, m'ap reponn yo lè y'a rele mande m' sekou. ");
INSERT INTO hat_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","m'a fache, m'a fè nou mouri nan lagè. Konsa, madanm nou yo ap vin vèv tou, pitit nou yo ap rete san papa tou. ");
INSERT INTO hat_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si nou prete yonn nan frè parèy nou yo lajan, yonn nan pòv ki nan mitan nou yo, piga nou fè tankou moun k'ap bay ponya pou nou egzije l' peye enterè. ");
INSERT INTO hat_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si yon nonm plane levit li lakay ou pou ou prete l' yon ti kòb, se pou ou renmèt li rad li anvan solèy kouche. ");
INSERT INTO hat_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Paske, se sèl rad li gen pou l' mete sou li pou fredi pa bat li. Kisa pou l' mete sou li pou l' kouvri aswè? Si li rele mande m' sekou, m'a reponn li paske mwen gen bon kè. ");
INSERT INTO hat_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Piga nou pale Bondye mal. Piga nou bay chèf pèp la madichon. ");
INSERT INTO hat_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Pa pran reta pou n' ofri m' sa pou n' ofri m' nan rekòt danre nou yo ak nan diven nou. n'a ban mwen premye pitit gason nou yo. ");
INSERT INTO hat_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","N'a ban mwen tou premye pitit bèf nou yo ak premye pitit mouton nou yo. Ti bèt la va pase sèt jou avèk manman l'. Sou wityèm jou a n'a ofri l' ban mwen. ");
INSERT INTO hat_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Se pou nou mache tankou moun k'ap viv apa pou mwen. Pa manje vyann bèt nou jwenn lòt bèt nan bwa devore. Vyann konsa se chen pou nou jete l' bay. ");
INSERT INTO hat_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Piga nou fè manti sou frè parèy nou. Lè n'ap sèvi temwen, piga nou bay manti pou ede yon mechan. ");
INSERT INTO hat_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Pa konprann pou nou fè sa ki mal paske nou wè se sa tout moun ap fè. Lè n'ap sèvi temwen nan yon pwose, piga nou pran pati pou bò ki gen plis moun lan lè nou konnen se yo ki antò. ");
INSERT INTO hat_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Konsa tou, lè gen pwose, se pa paske yon moun pòv pou nou pran pati pou li. ");
INSERT INTO hat_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si nou pa byen ak yon moun, epi nou jwenn bèf li osinon bourik li ki kase kòd, se pou nou mennen l' ba li. ");
INSERT INTO hat_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si nou pa byen ak yon moun, epi nou wè bourik li kouche anba yon chay, pa vire do nou kite l' pou kont li. Se pou nou ede l' fè bourik la kanpe. ");
INSERT INTO hat_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Lè yon malere nan pwose, pa anpeche yo fè l' jistis. ");
INSERT INTO hat_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Evite fè manti sou moun pou akize yo. Moun inonsan ak moun ki nan dwa yo, piga nou fè touye yo, paske mwen p'ap padonnen moun ki fè bagay konsa. ");
INSERT INTO hat_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Lè n'ap sèvi temwen nan yon kòz, pa pran lajan anba nan men moun, paske lajan konsa bouche je nou, li fè nou pa wè kote jistis la ye. Li fè moun ki pa antò a pèdi kòz li. ");
INSERT INTO hat_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Piga nou aji mal ak moun lòt nasyon k'ap viv nan peyi a. Paske, nou menm tou, yon lè, nou te etranje nan peyi Lejip, kifè nou konnen sa ki rele viv nan lòt peyi. ");
INSERT INTO hat_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Pandan sizan n'a travay tè a, epi n'a ranmase sa li bay. ");
INSERT INTO hat_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Men, sou setyèm lanne a, n'a kite tè a poze. Menm si li bay kichòy, nou p'ap ranmase anyen sou li. N'a kite rekòt la pou pòv malere yo. Rès la va rete pou bèt nan bwa manje. N'a fè menm bagay la tou pou jaden rezen ak jaden oliv nou yo. ");
INSERT INTO hat_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","N'a travay sis jou. Men setyèm jou a, n'a sispann travay, n'a pran repo. Konsa, bèf nou yo ak bourik nou yo, moun k'ap sèvi avèk nou yo ansanm ak etranje ki lakay nou yo va ka pran repo tou. ");
INSERT INTO hat_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Se pou nou swiv tou sa mwen sot di nou la a. Pa lapriyè lòt bondye, piga mwen tande non yo soti nan bouch nou. ");
INSERT INTO hat_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Twa fwa chak lanne, n'a fè fèt pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","N'a fè fèt Pen san ledven yo. Jan mwen te ban nou lòd la, n'a manje pen san ledven pandan sèt jou nan epòk yo fikse nan mwa Abib la. Paske se nan mwa sa a nou te soti kite peyi Lejip. Lè sa a, nou p'ap gen dwa parèt devan m' de men vid. ");
INSERT INTO hat_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Apre sa, n'a fete fèt Premye Rekòt la lè nou fèk konmanse rekòlte grenn nou simen nan jaden nou yo. N'a fete fèt Dènye Rekòt la menm vè fen lanne a, lè n'ap fin rekòlte tou sa ki nan jaden nou yo. ");
INSERT INTO hat_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Twa fwa chak lanne, tout gason nan pèp la va parèt devan mwen menm Seyè a, Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Lè n'ap touye yon bèt pou mwen, piga nou ofri san an ansanm ak pen ki fèt ak ledven. Piga nou sere grès bèt la tout lannwit jouk denmen maten. ");
INSERT INTO hat_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","N'a pran pi bèl fwi nan premye rekòt jaden nou, n'a pote yo bay Seyè a, Bondye nou an, lakay li, Piga ou kwit yon ti kabrit nan lèt manman li. ");
INSERT INTO hat_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Men m'ap voye yonn nan zanj mwen yo devan nou pou pwoteje nou sou wout la, pou l' fè nou rive san danje kote mwen pare pou nou an. ");
INSERT INTO hat_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Veye kò nou devan li. Koute sa l'ap di nou. Pa kenbe tèt avè l'. Si nou fè sa, li p'ap padonnen nou sa paske se nan non mwen l'ap fè tou sa l'ap fè a. ");
INSERT INTO hat_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Men, si nou koute sa li di nou, si nou fè tou sa mwen di nou fè, m'ap rayi moun ki rayi nou, mwen p'ap vle wè moun ki pa vle wè nou. ");
INSERT INTO hat_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Zanj mwen an va mache devan nou, l'ap mennen nou nan peyi moun Amori yo, peyi moun Et yo, peyi moun Ferezi yo, peyi moun Kanaran yo, peyi moun Evi yo ak peyi moun Jebis yo. M'ap detwi yo tout. ");
INSERT INTO hat_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Piga nou mete ajenou devan bondye lòt nasyon yo. Piga nou janm sèvi yo. Pa fè menm jan ak moun lòt nasyon yo. Se pou nou detwi bondye yo nèt, se pou nou kraze tout moniman yo fè pou yo. ");
INSERT INTO hat_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Se mwen menm Seyè a, Bondye nou an, pou nou sèvi. M'ap beni nou, m'ap ban nou manje pou n' manje, dlo pou nou bwè. Mwen p'ap kite maladi tonbe sou nou. ");
INSERT INTO hat_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nan peyi nou an p'ap gen fanm k'ap fè foskouch, ni fanm ki p'ap ka fè pitit. M'ap kite nou viv jouk nou fin granmoun. ");
INSERT INTO hat_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","M'ap fè tout moun pè nou. Kote nou pase, m'ap fè moun pèdi tèt yo. M'ap fè tout lènmi nou yo pran rak devan nou. ");
INSERT INTO hat_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","m'a voye gwo gèp devan nou, y'a fè moun Evi yo, moun Kanaran yo ak moun Et yo kouri byen lwen nou. ");
INSERT INTO hat_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Mwen p'ap fè yo ale tout ansanm yon sèl kou, yon sèl lanne, pou peyi a pa tounen savann, pou bèt nan bwa yo pa vin twòp pou nou. ");
INSERT INTO hat_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Men, piti piti m'ap mete yo deyò, jouk n'a gen plis moun pou nou ka pran tout peyi a pou nou. ");
INSERT INTO hat_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","M'ap fè fwontyè peyi nou an konmanse depi sou lanmè Wouj la rive jouk sou lanmè Mediterane, depi sou dezè a al bat sou larivyè Lefrat la. M'ap lage tout moun nan peyi a anba men nou, n'ap chase yo met deyò devan nou. ");
INSERT INTO hat_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Piga nou pase ankenn kontra ak moun sa yo, ni ak bondye yo. ");
INSERT INTO hat_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Se pa pou yo rete nan peyi nou an, pou yo pa ankouraje nou fè peche kont mwen. Si nou sèvi bondye moun sa yo, sa ka yon malè pou nou. ");
INSERT INTO hat_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Apre sa, Bondye di Moyiz: -Moute sou mòn lan bò kote m' ansanm ak Arawon, Nadab, Abiyou ak swasanndis nan chèf fanmi pèp Izrayèl la. N'a rete yon distans, n'a bese tèt nou jouk atè pou adore m'. ");
INSERT INTO hat_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Apre sa, Moyiz va pwoche pou kont li, l'a vin bò kote m'. Piga lòt yo pwoche. Pèp la menm pa pou moute avè yo. ");
INSERT INTO hat_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moyiz ale, li rapòte bay pèp la tou sa Seyè a te di l' yo ansanm ak tout lòd li te bay yo. Tout pèp la reponn ansanm: -N'a fè tou sa Seyè a di nou fè. ");
INSERT INTO hat_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moyiz ekri tou sa Seyè a te di l' yo. Nan denmen maten, byen bonè, lè Moyiz leve, li bati yon lòtèl nan pye mòn lan. Li pran douz gwo ròch, yonn pou chak branch fanmi pèp Izrayèl la, li mete yo kanpe. ");
INSERT INTO hat_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Apre sa, li pran kèk jenn gason nan moun Izrayèl yo, li voye yo al ofri bèt pou touye bay Seyè a: yo ofri bèt yo te boule nèt pou Seyè a. Yo touye kèk towo bèf pou di Seyè a mèsi. ");
INSERT INTO hat_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moyiz pran mwatye nan san an, li mete l' nan ganmèl. Lòt mwatye a, li vide l' sou lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Lèfini, li pran liv kontra a, li li l' pou tout pèp la ka tande. Apre sa, pèp la di: -N'a fè tou sa Seyè a mande nou fè, n'a obeyi l'. ");
INSERT INTO hat_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Lè sa a, Moyiz pran san ki te nan ganmèl yo, li voye l' sou pèp la, li di: -San sa a sèvi pou siyen kontra Seyè a pase ak nou an, dapre pawòl li di yo. ");
INSERT INTO hat_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moyiz moute sou mòn lan ansanm ak Arawon, Nadab, Abiyou ak swasanndis nan chèf fanmi pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Yo te wè Bondye pèp Izrayèl la. Anba pye l', te gen yon bagay plat fèt ak bèl pyè kristal ble yo rele safi. Li te klè tankou syèl la lè pa gen yon ti nwaj menm ladan li. ");
INSERT INTO hat_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Seyè a pa t' fè chèf pèp Izrayèl yo anyen. Se konsa yo te wè Bondye. Aprè sa, yo manje epi yo bwè. ");
INSERT INTO hat_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Seyè a di Moyiz konsa: -Moute sou mòn lan bò kote m'. Rete la. m'a ba ou de ròch plat avèk lalwa ak regleman mwen te ekri sou yo pou fè levasyon pèp la. ");
INSERT INTO hat_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moyiz leve ansanm ak Jozye, adjwen li a, yo moute sou mòn Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Anvan Moyiz te ale, li di chèf fanmi yo: -Rete tann nou isit la jouk nou tounen. Men Arawon ak Our ap rete ak nou. Si yon moun bezwen regle yon pwoblèm, li mèt al jwenn yo. ");
INSERT INTO hat_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moyiz moute sou mòn lan, epi nwaj kouvri mòn lan nèt. ");
INSERT INTO hat_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Pouvwa Seyè a desann sou mòn Sinayi a. Nwaj kouvri mòn lan pandan sis jou. Sou setyèm jou a, Seyè a rete nan nwaj la, li rele Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Pou moun pèp Izrayèl yo menm, pouvwa Seyè a te parèt tankou yon gwo dife ki t'ap boule sou tèt mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moyiz antre nan mitan nwaj la, li moute sou mòn lan. Moyiz pase karant jou ak karant nwit sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Seyè a pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","-Pale ak moun Izrayèl yo. Di yo pote yon ofrann ban mwen. W'a resevwa l' pou mwen nan men tout moun ki vle bay ak kè kontan. ");
INSERT INTO hat_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Men ofrann pou ou resevwa nan men yo: lò, ajan ak kwiv, ");
INSERT INTO hat_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","bon twal koulè violèt, ble ak wouj, twal fen blan, twal fèt ak pwal kabrit, ");
INSERT INTO hat_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","po belye tenn koulè wouj ak po bazann, bwa zakasya, ");
INSERT INTO hat_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","lwil pou gwo lanp sèt branch lan, epis santi bon pou mete nan lansan an ak nan lwil yo sèvi pou mete moun apa pou sèvis Bondye a, ");
INSERT INTO hat_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pyè oniks ak lòt pyè pou gani jile ak plastwon granprèt la. ");
INSERT INTO hat_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","y'a mete yon kote apa pou mwen pou m' ka vin rete nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","W'a fè tant lan ak tout bagay ki pou ale ladan l', dapre modèl mwen pral ba ou a. ");
INSERT INTO hat_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","y'a pran bwa zakasya, y'a fè yon gwo bwat. Bwat la va mezire twa pye nèf pous longè, de pye twa pous lajè, de pye twa pous wotè. ");
INSERT INTO hat_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","W'a kouvri l' nèt, anndan kou deyò, ak pi bon klas lò ki genyen. Epi w'a mete yon bòdi an lò fè wonn li. ");
INSERT INTO hat_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","W'a fonn lò a fè kat gwo bag tou won. W'a moute yonn sou chak kwen bwat la, de chak bò. ");
INSERT INTO hat_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","W'a pran de jenn poto zakasya, w'a kouvri yo nèt ak lò. ");
INSERT INTO hat_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","W'a pase poto yo nan twou bag yo, sou de bò bwat la. Poto sa yo va sèvi manch pou pote bwat la. ");
INSERT INTO hat_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Se pou poto yo toujou rete nan bag yo, san yo pa janm wete yo. ");
INSERT INTO hat_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Mwen pral ba ou de ròch plat ki va sèvi pou nou toujou chonje m'. W'a mete yo nan bwat la. ");
INSERT INTO hat_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","W'a pran pi bon lò ki genyen, w'a fè yon kouvèti pou bwat la. L'a mezire twa pye nèf pous longè sou de pye twa pous lajè. ");
INSERT INTO hat_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","W'a fè pòtre de zanj cheriben an lò. y'a pran lò a, y'a bat li ak mato pou yo fè pòtre yo. W'a mete yo anwo kouvèti a, ");
INSERT INTO hat_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","yonn sou bò dwat, yonn sou bò gòch. W'a kole yo byen kole sou kouvèti a pou yo fè kò avè l'. ");
INSERT INTO hat_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Zanj cheriben yo va louvri zèl yo anwo tèt yo, konsa y'a kouvri kouvèti a. Se pou yo yonn anfas lòt, avèk tèt yo bese ap gade kouvèti a. ");
INSERT INTO hat_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","W'a mete kouvèti a sou bwat la. Nan bwat la menm, w'a mete de ròch plat mwen pral ba ou pou nou ka toujou chonje mwen. ");
INSERT INTO hat_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Se la m'a toujou kontre avè ou. m'a rete anwo kouvèti a, nan mitan de zanj cheriben yo, m'a ba ou tout lòd mwen gen pou m' ba ou yo pou moun Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","W'a fè yon tab an bwa zakasya. Desi tab la va mezire twa pye longè, yon pye sis pous lajè ak de pye twa pous wotè. ");
INSERT INTO hat_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","W'a kouvri l' nèt ak pi bon lò ki genyen. W'a mete yon bòdi an lò fè wonn li. ");
INSERT INTO hat_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","W'a mete yon ankadreman kat pous lajè anba desi a fè wonn tab la. Epi w'a kouvri tout ankadreman an ak yon plak lò. ");
INSERT INTO hat_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","W'a fonn lò a fè kat gwo bag tou won pou tab la. W'a moute yo nan kat kwen tab la kote pye yo moute a. ");
INSERT INTO hat_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","W'a moute bag yo toupre ankadreman an. Se nan twou bag yo pou ou pase poto bwa zakasya ki pou sèvi pou pote tab la. ");
INSERT INTO hat_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","W'a fè poto yo ak bwa zakasya, epi w'a kouvri yo nèt ak lò. Se ak poto sa yo pou yo sèvi pou pote tab la. ");
INSERT INTO hat_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","W'a fè asyèt, bòl, tas, kafetyè. W'a mete yo apa pou mwen. W'a fè yo ak pi bon lò ki genyen. Se ak yo pou nou sèvi lè n'ap fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Epi w'a toujou mete sou tab la pen yo ofri ban mwen yo. Wi, se pou pen yo tout tan la devan mwen. ");
INSERT INTO hat_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","W'a fè yon gwo lanp sèt branch ak pi bon lò ki genyen. y'a pran yon sèl gwo mòso lò, y'a bat li ak mato pou fè pye gwo lanp sèt branch lan ansanm ak tout kò li. y'a fè pòtre bèl flè, flè an bouton, flè louvri, sou tout kò li. Yo tout va fè yon sèl pyès ak pye lanp lan. ");
INSERT INTO hat_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Gwo lanp lan va gen sèt branch, yonn kanpe dwat nan mitan ak twa branch chak bò. ");
INSERT INTO hat_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Sou chak branch sou kote yo, y'a fè pòtre twa flè nwa kajou ak tout boujon yo. ");
INSERT INTO hat_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Sou branch ki nan mitan an va gen kat flè nwa kajou ak tout boujon yo. ");
INSERT INTO hat_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","W'a mete yon ti boujon anba chak pè branch sou kote yo. ");
INSERT INTO hat_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Boujon yo ak branch yo va fè yon sèl pyès ak pye gwo lanp lan. Se va yon sèl pyès lò y'a bat ak mato pou ba li fòm yo vle a. ");
INSERT INTO hat_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","y'a fè sèt lanp pou gwo lanp lan, y'a moute yo sou li yon jan pou yo ka klere sou devan. ");
INSERT INTO hat_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","N'a fè pensèt pou netwaye gwo lanp lan ak plato pou resevwa sann lan. W'a fè yo ak pi bon lò ki genyen. ");
INSERT INTO hat_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","N'a pran swasannkenz liv bon lò pou fè gwo lanp lan ansanm ak tout bagay pou sèvi ak gwo lanp lan. ");
INSERT INTO hat_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Gade byen pou ou ka fè tout bagay dapre modèl mwen te moutre ou sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","N'a fè tant kote pou Bondye rete a ak dis lèz twal fen blan tise byen sere, ansanm ak lenn koulè ble, violèt ak wouj. W'a fè yo bwode bèl pòtre zanj cheriben byen fèt sou tout twal la. ");
INSERT INTO hat_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Chak lèz twal va gen katòz mèt longè, de mèt lajè. Yo tout va menm gwosè. ");
INSERT INTO hat_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","N'a koud lèz yo ansanm, senk yon bò, senk yon lòt bò. ");
INSERT INTO hat_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Lè w'a fin koud senk premye lèz yo ansanm, w'a fè pasan ak kòdon ble sou tout bòdi senk premye lèz yo. W'a fè menm jan an tou ak senk lòt lèz yo. ");
INSERT INTO hat_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","W'a fè senkant pasan nan premye lèz premye gwoup la, ak senkant pasan nan dènye lèz dezyèm gwoup la. W'a fè yo koresponn de pa de. ");
INSERT INTO hat_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","W'a fè senkant ti kwòk an lò ki va sèvi pou kole de gwoup lèz yo yonn ak lòt pou yo fè yon sèl tant. ");
INSERT INTO hat_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","W'a fè onz lèz twal ak pwal kabrit pou fè yon gwo tant pou kouvri kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Chak lèz va gen kenz mèt longè ak de mèt lajè. Yo tout va menm gwosè. ");
INSERT INTO hat_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","W'a pran senk ladan yo, w'a koud yo ansanm. Apre sa, w'a pran lòt sis yo, w'a koud yo ansanm tou. W'a pliye sizyèm lèz la an de sou devan tant lan. ");
INSERT INTO hat_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","W'a mete senkant pasan sou bòdi premye lèz premye gwoup la, ak senkant pasan sou bòdi dènye lèz dezyèm gwoup la. ");
INSERT INTO hat_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","W'a fè senkant ti kwòk an kwiv, w'a pase yo nan pasan yo pou kole de gwoup lèz yo ansanm pou fè yon sèl tant. ");
INSERT INTO hat_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mwatye lèz ki an plis la va bat sou dèyè kay Bondye a pou kouvri l'. ");
INSERT INTO hat_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Menm jan an tou, lèz ki sou kote yo pral gen yon pye edmi k'ap depase. Sa ki an plis la pral desann sou bò kay Bondye a pou kouvri l'. ");
INSERT INTO hat_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","W'a fè yon kouvèti ak po belye pou tant lan. W'a tenn li wouj. Apre sa, w'a fè yon lòt kouvèti ak po bazann pou kouvri tant Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","W'a pran bwa zakasya pou fè planch ankadreman pou soutni tant Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Chak ankadreman va gen kenz pye longè sou vensèt pous lajè. ");
INSERT INTO hat_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Yo chak va gen de bout depase ki va penmèt yo kole yonn ak lòt. ");
INSERT INTO hat_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Lè w'ap fè ankadreman yo, w'a fè ven pou bò sid la. ");
INSERT INTO hat_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","W'a fè karant sipò an ajan pou ale anba ankadreman yo, de sipò anba chak ankadreman. Se ladan yo bout ki depase yo va chita. ");
INSERT INTO hat_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Konsa tou, w'a fè ven ankadreman pou bò nò a ");
INSERT INTO hat_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ak karant sipò an ajan, de pou chak ankadreman. ");
INSERT INTO hat_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","W'a fè sis ankadreman pou dèyè tant Bondye a, sou bò lwès la, ");
INSERT INTO hat_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ak de ankadreman pou chak kwen ki sou dèyè tant Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ankadreman kwen yo va mare yonn ak lòt pa anba. y'a bout-a-bout depi anba jouk anwo kote gwo bag la. Se konsa w'a moute de ankadreman k'ap fè kwen yo. ");
INSERT INTO hat_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Konsa, va gen wit ankadreman avèk sèz sipò an ajan, de sipò anba chak ankadreman. ");
INSERT INTO hat_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","W'a fè travès ak bwa zakasya, senk pou ankadreman sou bò sid tant Bondye a, ");
INSERT INTO hat_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","senk pou ankadreman sou bò nò a, senk pou ankadreman ki sou bò lwès la, pa dèyè. ");
INSERT INTO hat_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Travès mitan an, k'ap pase nan ren ankadreman yo, va soti nan yon bout pou ale nan yon lòt bout. ");
INSERT INTO hat_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","W'a kouvri tout kò ankadreman yo ak lò. W'a moute gwo bag an lò sou yo pou kenbe travès yo. W'a kouvri travès yo ak lò tou. ");
INSERT INTO hat_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","W'a fè tant lan dapre modèl mwen te moutre ou sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","W'a fè yon rido ak bon twal koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere. y'a bwode bèl pòtre zanj cheriben byen fèt sou tout rido a. ");
INSERT INTO hat_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","W'a pann rido a sou kat poto an bwa zakasya. Poto yo va kouvri ak lò. y'a gen kwòk an lò moute sou yo. y'a chita sou kat sipò an ajan. ");
INSERT INTO hat_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Mete rido a anba kwòk ki nan twati tant lan. W'a mete Bwat Kontra a dèyè rido a. Rido a va separe kote ki apa apa nèt pou Bondye sèlman an ak rès tant Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","W'a mete kouvèti a sou Bwat Kontra ki nan kote ki apa apa nèt pou Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","W'a mete tab la pa deyò rido a. Mete gwo lanp sèt branch lan sou bò sid tant lan, an fas tab la. Tab la menm va sou bò nò a. ");
INSERT INTO hat_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Konsa tou, w'a fè yon rido an bon twal ble, violèt ak wouj ansanm ak twal fen blan tise byen sere. Rido a va sèvi pou fèmen kote yo pase pou antre nan tant lan. y'a fè bèl bodri sou tout rido a. ");
INSERT INTO hat_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Pou kenbe rido a, w'a fè senk poto an bwa zakasya, w'a kouvri yo ak lò, w'a moute ti kwòk an lò sou yo. y'a chita sou senk sipò an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","W'a fè yon lòtèl an bwa zakasya. L'a kare kare. L'a mezire sèt pye sis pous longè sou sèt pye sis pous lajè ak kat pye sis pous wotè. ");
INSERT INTO hat_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","W'a travay kat kòn sou kat kwen lòtèl la. Se pou kòn yo fè yon sèl pyès ak lòtèl la. Apre sa, w'a kouvri tout ak kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Pou lòtèl la, w'a fè pèl, kivèt, fouchèt, recho ak plato pou resevwa sann. Tout bagay sa yo va fèt an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Pou lòtèl la toujou, w'a fè yon griyaj an kwiv, tankou griy yo sèvi pou griye vyann. W'a mete kat gwo bag an kwiv nan kat pwent griyaj la. ");
INSERT INTO hat_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","W'a mete griyaj la anba rebò lòtèl la, pou l' soti anba rive mwatye wotè lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","W'a fè baton an bwa zakasya ki va sèvi manch pou lòtèl la. W'a kouvri yo an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","W'a pase manch yo nan gwo bag yo. Manch yo va sou chak bò lòtèl la lè y'ap pote l'. ");
INSERT INTO hat_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Lòtèl la va fèt an planch. Anndan li va rete tou vid. W'a fè l' dapre modèl mwen te moutre ou sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","W'a fè yon galeri wonn kay la. Sou bò sid la, w'a moute yon seri rido fèt ak lèz twal fen blan tise byen sere, sou senkant mèt longè pou bò sa a. ");
INSERT INTO hat_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Pou kenbe rido yo, va gen ven poto an kwiv chita sou ven sipò an kwiv tou. Men, kwòk ki sou poto yo ak trenng ki pou soutni rido yo va fèt an ajan. ");
INSERT INTO hat_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Menm jan an tou, sou bò nò a va gen yon seri rido fèt ak lèz twal sou senkant mèt longè pou bò sa a, avèk ven poto an kwiv chita sou ven sipò an kwiv tou. Kwòk yo ak trenng yo va fèt an ajan. ");
INSERT INTO hat_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Sou bò lwès la, va gen yon galeri tou. W'a moute yon seri rido sou vennsenk mèt longè ak dis poto chita sou dis sipò. ");
INSERT INTO hat_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Sou bò lès la, galeri a va gen swasannkenz pye lajè. ");
INSERT INTO hat_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Sou bò gòch pòt antre a, y'a moute rido sou yon longè vennde pye sis pous avèk twa poto chita sou twa sipò. ");
INSERT INTO hat_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Sou bò dwat la tou, y'a moute rido sou yon longè vennde pye sis pous avèk twa poto chita sou twa sipò. ");
INSERT INTO hat_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pou pòt antre a menm, va gen yon rido trant pye longè, fèt ak twal siperyè koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere, dekore avèk bodri. Se kat poto chita sou kat sipò ki pou soutni rido a. ");
INSERT INTO hat_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Tout poto ki fè wonn galeri a va gen trenng fèt an ajan, kwòk fèt an ajan ak sipò fèt an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Galeri a va gen sansenkant pye longè, swasannkenz pye lajè ak sèt pye sis pous wotè. Rido yo va fèt ak twal fen blan tise byen sere. Sipò yo va fèt an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tout bagay ki la pou sèvi nan tant lan, tout pikèt pou tant lan ak pou galeri a, tou sa gen pou fèt an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","W'a pase pèp Izrayèl la lòd pou yo pote ba ou pi bon kalite lwil oliv ki genyen pou lanp yo. Konsa, lanp lan va toujou ka rete limen. ");
INSERT INTO hat_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Se Arawon ak pitit li yo ki va mete lwil nan lanp sa a, ki nan Tant Randevou a pa deyè rido a, devan Bwat Kontra a. Se la gwo lanp lan va limen devan Seyè a depi aswè jouk maten. Se pou moun Izrayèl yo swiv lòd sa a pou tout tan, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","W'a pran Arawon ak pitit li yo: Nadab, Abiyou, Eleaza, Itama, w'a wete yo nan mitan moun Izrayèl yo, w'a fè yo vin jwenn ou. W'a mete yo apa pou yo sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","W'a fè rad pou Arawon, frè ou la, rad pou li mete lè l'ap fè sèvis, pou l' ka byen abiye, pou moun ka rekonèt grad li. ");
INSERT INTO hat_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","W'a pale ak atizan ki konnen metye yo byen. Se mwen menm ki ba yo tout ladrès yo genyen an. W'a mande yo pou yo fè rad Arawon yo, pou ou ka mete l' apa pou mwen pou l' ka sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Men ki rad pou yo fè: yon plastwon, yon jile, yon gwo rad long, yon chemiz byen bwode, yon gwo mouchwa pou vlope tèt ak yon sentiwon. y'a fè rad sa yo pou Arawon, frè ou la, ak pou pitit li yo pou yo ka sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Pou fè travay la, atizan yo va sèvi ak lò ak twal siperyè koulè ble, violèt ak wouj ansanm ak twal fen. ");
INSERT INTO hat_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","y'a fè jile a ak lò ak twal siperyè koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere. y'a fè bèl bodri byen fèt sou li. ");
INSERT INTO hat_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Va gen de zèpòlèt, yonn chak bò jile a. Se yo ki pou tache moso devan an ak moso dèyè a ansanm. ");
INSERT INTO hat_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Bèl sentiwon byen bwode ki pou kenbe jile a va fè yon sèl pyès ak li, ak menm kalite bodri a sou li tou. y'a fè l' an lò ak twal siperyè koulè ble, violèt ak wouj, ansanm ak twal fen blan tise byen sere. ");
INSERT INTO hat_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","W'a pran de pyè oniks, w'a grave non branch fanmi douz pitit Izrayèl yo sou yo. ");
INSERT INTO hat_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","W'a grave non sis sou yon pyè, ak non sis sou lòt la, dapre laj yo, depi pi gran an jouk pi piti a. ");
INSERT INTO hat_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Avèk ladrès òfèv ki konn grave non sou bag, ou ankò ladrès atizan ki konn fè so, w'a grave non branch fanmi pèp Izrayèl yo sou de pyè yo, epi w'a moute pyè yo chak sou yon moso lò. ");
INSERT INTO hat_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","W'a moute yo sou de zèpòlèt jile a pou yo pa bliye branch fanmi pèp Izrayèl yo. Konsa, Arawon va pote non yo sou zepòl li pou Seyè a pa janm bliye yo. ");
INSERT INTO hat_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","W'a pran de moso lò pou moute pyè yo sou yo. ");
INSERT INTO hat_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","W'a fè de ti chenn ak pi bon kalite lò ki genyen. Chenn yo va trese tankou ti kòdon. W'a tache yo sou moso lò yo. ");
INSERT INTO hat_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","W'a fè yon plastwon pou yo mete bagay y'a sèvi pou chache konnen sa Bondye vle. Se yon bon atis ki pou fè travay bodri a tankou pou jile a. W'a fè l' an lò ak twal siperyè koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere. ");
INSERT INTO hat_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Plastwon an va mezire nèf pous kare kare, l'a double. ");
INSERT INTO hat_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","W'a moute kat ranje pyè sou li. Nan premye ranje a, va gen yon pyè woubi, yon pyè topaz ak yon pyè emwòd. ");
INSERT INTO hat_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Nan dezyèm ranje a, va gen yon pyè malachi, yon pyè safi ak yon pyè dyaman. ");
INSERT INTO hat_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Nan twazyèm ranje a, va gen yon pyè opal, yon pyè agat ak yon pyè ametis. ");
INSERT INTO hat_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Nan katriyèm ranje a, va gen yon pyè krizolit, yon pyè oniks ak yon pyè jasp. y'a moute tout pyè sa yo chak sou yon moso lò. ");
INSERT INTO hat_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Va gen douz pyè ak non branch fanmi pèp Izrayèl yo grave sou yo, yon non sou chak pyè. y'a grave non yo tankou lè òfèv ap grave bag. ");
INSERT INTO hat_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","W'a pran pi bon kalite lò ki genyen, w'a fè de ti chenn pou plastwon an. W'a trese yo tankou ti kòdon. ");
INSERT INTO hat_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","W'a fè de ti bag an lò, w'a tache yo nan de bout anwo plastwon an. ");
INSERT INTO hat_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","W'a mare de ti chenn yo nan de bag yo. ");
INSERT INTO hat_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","W'a pran de lòt bout chenn yo, w'a fè yo pase pa devan jile a, w'a tache yo sou de moso lò ki sou zèpòlèt jile a. ");
INSERT INTO hat_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","W'a fè ankò de lòt bag an lò, w'a tache yo nan de bout anba plastwon an sou lanvè, nan bòdi a toupre jile a. ");
INSERT INTO hat_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","W'a fè de lòt bag an lò ankò, w'a tache yo anba zèpòlèt jile a pa devan, toupre kouti a anwo tèt sentiwon bwode a. ");
INSERT INTO hat_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","y'a mare de bag plastwon an ak de bag jile a ansanm ak yon kòdon ble pou plastwon an bat sou sentiwon jile a. Konsa, plastwon an p'ap ka soti detache sou jile a. ");
INSERT INTO hat_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Lè Arawon va antre nan kote ki apa pou Bondye a, l'a pote non branch fanmi pèp Izrayèl yo sou kè l', sou plastwon an, konsa Seyè a p'ap janm bliye yo. ");
INSERT INTO hat_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","W'a mete nan plastwon an ourim yo ak toumim yo. Konsa, Arawon va pote yo sou kè l' lè l'ap parèt devan lòtèl Seyè a. Lè l'a kanpe devan lòtèl Seyè a, l'a toujou pote sou kè l' sa li sèvi pou fè pèp Izrayèl la konnen volonte m'. ");
INSERT INTO hat_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","W'a pran twal ble pou fè rad ki ale anba jile a. ");
INSERT INTO hat_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Nan mitan rad la, w'a fè yon twou pou l' pase tèt li. W'a mete yon doubli nan ankoli a, tankou yo fè l' pou varèz an po bèt yo, pou li pa chire. ");
INSERT INTO hat_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sou tout woulèt anba rad la, w'a pran twal ble, violèt ak wouj, w'a fè bodri an fòm grenad ak ti klòch an lò nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Sou tout woulèt rad la va gen yon grenad, yon ti klòch, yon grenad, yon ti klòch, jouk yo fè tout tou rad la. ");
INSERT INTO hat_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Se rad sa a Arawon va mete sou li lè li pral fè sèvis. Lè l'ap antre kote yo mete apa pou Bondye a pou l' parèt devan lòtèl Seyè a, ansanm ak lè l'ap soti, y'a tande ti klòch yo ap sonnen. Konsa li p'ap mouri. ");
INSERT INTO hat_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","W'a fè fè yon ti plak ak pi bon kalite lò ki genyen. Tankou lè y'ap fè so, w'a grave pawòl sa a sou li: Apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","W'a mare l' sou devan mouchwa tèt la avèk yon ti kòdon ble. ");
INSERT INTO hat_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Arawon va mete l' sou fwon li, konsa Arawon va pran sou tèt li tou sa pèp Izrayèl la va fè ki mal lè y'ap pote ofrann apa yo bay Seyè a. Arawon va toujou pote l' sou fwon li pou ofrann yo ka toujou fè Seyè a plezi. ");
INSERT INTO hat_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","W'a fè chemiz la ak mouchwa tèt la ak twal fen blan, ansanm ak yon sentiwon bwode byen bèl. ");
INSERT INTO hat_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","W'a fè rad, sentiwon ak bonnèt pou pitit gason Arawon yo tou, pou yo ka byen abiye pou moun ka rekonèt grad yo. ");
INSERT INTO hat_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Apre sa, w'a mete rad yo sou Arawon, frè ou la, ansanm ak pitit gason l' yo. Lèfini, w'a vide lwil sou tèt yo, w'a ba yo pouvwa pou yo fè sèvis Bondye. W'a mete yo apa pou mwen pou yo ka sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","W'a fè kalson ak twal fen pou yo pou kò yo pa parèt anba rad la. Kalson yo va pran depi nan ren desann wotè jenou yo. ");
INSERT INTO hat_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Se pou Arawon ak pitit gason l' yo toujou pote kalson yo lè y'ap antre nan Tant Randevou a, osinon lè y'ap pwoche bò lòtèl la pou fè sèvis nan kote ki apa pou Bondye a. Konsa, yo p'ap fè sa ki mal, yo p'ap mouri. Sa se yon lwa k'ap la pou tout tan pou Arawon ak tout pitit pitit gason li yo apre li. ");
INSERT INTO hat_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Men sa ou gen pou fè pou mete Arawon ak pitit gason l' yo apa pou mwen pou yo ka sèvi m' prèt. Pran yon jenn ti towo bèf ak de belye mouton ki san defo. ");
INSERT INTO hat_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","W'a pran bon farin frans, w'a fè kèk pen san ledven, kèk gato san ledven, men ak lwil melanje nan pa t' la. W'a fè tou kèk gato plat san ledven wouze ak lwil. ");
INSERT INTO hat_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Mete yo nan yon panyen. Ofri yo ban mwen nan panyen an ansanm ak ti towo a ak de belye mouton yo. ");
INSERT INTO hat_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","W'a fè Arawon ansanm ak pitit gason l' yo vanse jouk devan pòt Tant Randevou a. W'a benyen yo nan dlo. ");
INSERT INTO hat_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Apre sa, w'a pran rad yo, w'a biye Arawon. W'a mete chemiz la, rad la, jile a ak plastwon an sou li. W'a mare sentiwon an nan ren li. ");
INSERT INTO hat_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","W'a mete mouchwa a nan tèt li. W'a mare plak ki make Apa pou Seyè a, sou mouchwa a. ");
INSERT INTO hat_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Lèfini, w'a pran lwil pou mete moun apa a, w'a vide l' sou tèt Arawon. Konsa, w'a mete l' apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","W'a fè pitit li yo pwoche, w'a mete chemiz yo sou yo. ");
INSERT INTO hat_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","W'a pase sentiwon nan ren yo, w'a mete bonnèt yo nan tèt yo. Se yo menm k'ap sèvi m' prèt dapre yon lwa ki la pou tout tan. Se konsa w'a bay Arawon ak pitit gason l' yo pouvwa pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Mennen towo bèf la devan Tant Randevou a. Arawon ak pitit gason l' yo va mete men yo sou tèt li. ");
INSERT INTO hat_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","W'a touye towo a la devan Seyè a, devan pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","W'a tranpe dwèt ou nan san towo a. W'a mete ti degout san sou kat kòn lòtèl la. Apre sa, w'a vide tout rès san an atè nan pye lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Lèfini, w'a pran grès ki vlope tripay yo, mas grès ki sou fwa a ansanm ak de wonyon yo ak tout grès yo, w'a ofri yo ban mwen. W'a boule yo nèt sou lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Men w'a pran tout vyann lan, po a ak tout tripay la, w'a boule yo andeyò limit kote nou rete a. Se va yon ofrann bèt y'ap touye pou Bondye ki va sèvi pou wete peche moun fè san yo pa konnen. ");
INSERT INTO hat_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","W'a pran yonn nan belye mouton yo. Arawon ak pitit gason l' yo va mete men yo sou tèt li. ");
INSERT INTO hat_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","W'a touye l', w'a pran san an, w'a vide l' tout arebò lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","W'a dekoupe belye a an divès moso. W'a lave tonbe a ansanm ak pye yo. W'a mete yo anwo moso vyann yo ansanm ak tèt la. ");
INSERT INTO hat_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","W'a ofri tout belye a ban mwen. W'a boule l' nèt sou lòtèl la. Sa se yon ofrann bèt w'a boule nèt pou Seyè a, yon ofrann bèt ki fèt pou boule nèt nan dife, yon ofrann bèt k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Apre sa, pran lòt belye mouton an. Arawon ak pitit gason l' yo va mete men yo sou tèt li. ");
INSERT INTO hat_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","W'a touye l', w'a pran ti gout nan san li, w'a mete l' sou tete zòrèy dwat Arawon ak sou tete zòrèy dwat pitit gason l' yo, sou gwo pous men dwat yo ak sou gwo zòtèy pye dwat yo. W'a pran rès san an, w'a vide l' tout arebò lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Pran ti gout nan san ki sou lòtèl la ansanm ak ti gout nan lwil pou mete moun apa a, voye yo sou Arawon ak sou rad li yo, sou pitit gason l' yo ak sou rad yo tou. Konsa, w'a mete Arawon ak pitit gason l' yo ansanm ak tout rad yo apa pou mwen nèt. ");
INSERT INTO hat_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Wete tout grès dezyèm belye mouton an: ke a ak tout grès li, grès ki vlope tripay yo, moso grès ki sou fwa a, de wonyon yo ak tout grès yo, ansanm ak jigo dwat la, paske se yon belye k'ap sèvi nan sèvis pou mete prèt yo apa a. ");
INSERT INTO hat_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nan panyen pen san ledven ki devan Seyè a, w'a pran yon pen antye, yon gato fèt ak lwil ak yon pen plat. ");
INSERT INTO hat_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","W'a mete tout bagay sa yo nan men Arawon ak nan men pitit gason l' yo. W'a mete yo apa pou sèvis mwen, w'a fè yo balanse l' devan Seyè a tankou yon ofrann. ");
INSERT INTO hat_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Lèfini, pran manje a nan men yo, boule l' sou lòtèl la, anwo ofrann ki boule deja a, pou l' fè Seyè a plezi ak bon sant li. Se va yon ofrann pou Seyè a ki fèt pou boule nèt nan dife. ");
INSERT INTO hat_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Pran vyann pwatrin belye ki te sèvi nan sèvis pou mete Arawon apa a, w'a balanse l' devan Seyè a tankou yon ofrann. Se va pòsyon pa ou la sa. ");
INSERT INTO hat_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","W'a pran vyann pwatrin belye ki te sèvi nan sèvis pou mete Arawon ak pitit gason l' yo apa a, w'a mete yo apa pou Seyè a. W'a balanse yo devan Seyè a tankou yon ofrann. W'a fè menm bagay la tou pou jigo w'ap wete pou prèt yo. ");
INSERT INTO hat_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Dapre lòd mwen bay pèp Izrayèl pou tout tan an, moso vyann sa yo va pou Arawon ak pou pitit gason l' yo. Se va yon kado pèp Izrayèl la pral blije fè. Se pòsyon yo va toujou wete pou prèt yo, pòsyon pèp Izrayèl la va toujou bay nan ofrann y'ap fè pou di mèsi. Se kado y'a bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Lè Arawon va mouri, rad sèvis li yo va rete pou pitit li yo. Se rad sa yo y'a mete sou yo lè y'ap vide lwil sou tèt yo pou mete yo apa, lè y'ap ba yo pouvwa pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Pitit Arawon ki va pran plas Arawon nan sèvis Seyè a va mete rad yo sou li pandan sèt jou, epi l'a antre nan tant lan pou fè sèvis li nan kote ki apa pou Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","W'a pran belye mouton ki te sèvi nan sèvis pou mete apa a, w'a fè kwit vyann li yon kote ki apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Arawon ak pitit gason l' yo va manje vyann belye a ansanm ak pen ki nan panyen an. y'a rete bò pòt devan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","y'a manje manje ki te sèvi nan sèvis yo fè pou mande Bondye padon pou peche yo fè san yo pa konnen, sèvis yo te fè lè yo t'ap mete yo apa, lè yo t'ap resevwa pouvwa pou fè sèvis Bondye a. Se prèt yo ase ki ka manje manje sa yo, paske se manje yo mete apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Si gen rès nan vyann lan ak nan pen an ki rete apre yo fin manje, nan denmen maten w'a boule l' nan dife. Piga pesonn manje li, paske se manje yo mete apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","W'a fè tou sa m' te ba ou lòd fè pou Arawon ansanm ak pitit gason l' yo. W'a pase sèt jou ap fè sèvis pou mete yo apa pou sèvis mwen. ");
INSERT INTO hat_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Chak jou, w'a ofri yon towo bèf, w'a touye l' pou mande Bondye padon pou peche yo fè san yo pa konnen. Avèk ofrann bèt sa a w'ap fè pou peche a, w'a mete lòtèl la nan kondisyon pou l' sèvi nan sèvis Bondye. Lèfini, w'a vide lwil sou li, w'a mete l' apa pou sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pandan sèt jou, w'a fè ofrann bèt pou peche yo fè san yo pa konnen an sou lòtèl la. Konsa w'a mete lòtèl la apa pou sèvis Bondye a. Konsa, lòtèl la va apa nèt pou Bondye. Tout moun ki va manyen lòtèl la, ak tout bagay ki va an kontak ak lòtèl la va tounen bagay yo mete apa pou Bondye tou. ");
INSERT INTO hat_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Men sa ou gen pou ofri sou lòtèl la: Chak jou, san sote yon jou, w'a ofri de ti mouton ki poko gen ennan bay Bondye. ");
INSERT INTO hat_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","W'a ofri yonn nan mouton yo nan maten, lòt la nan aswè anvan li fin fè nwa nèt. ");
INSERT INTO hat_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Avèk premye ti mouton an, w'a ofri sèt ti mamit farin frans melanje ak yon lit edmi bon lwil oliv fèt nan moulen. W'a pran yon lit edmi diven pou ofri pou bwason ak manje a. ");
INSERT INTO hat_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","W'a touye dezyèm ti mouton an aswè. W'a ofri ansanm avè l' menm manje ak menm bwason ou te ofri nan maten an. W'a boule tout bagay sa yo nèt nan dife. Se va yon ofrann bèt k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ofrann nan dife sa a, yo gen pou yo fè l' tout tan devan mwen, de pitit an pitit nan papòt Tant Randevou a. Se la mwen menm Seyè a, m'ap kontre ak pèp mwen an pou m' pale ak yo. ");
INSERT INTO hat_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Se la m'ap kontre pèp Izrayèl la. Avèk pouvwa mwen, m'ap mete kote sa a apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","M'ap mete Tant Randevou a apa pou sèvis mwen. M'ap fè menm bagay la tou pou lòtèl la. M'ap mete Arawon ak pitit gason l' yo apa pou mwen pou yo ka sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","M'ap rete nan mitan pèp Izrayèl la, se mwen menm ki va Bondye yo. ");
INSERT INTO hat_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","y'a konnen se mwen menm ki Seyè a, Bondye yo a, se mwen menm ki te fè yo soti kite peyi Lejip pou m' te kapab rete nan mitan yo. Se mwen ki Seyè a, Bondye yo a. ");
INSERT INTO hat_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","W'a fè yon lòtèl an bwa zakasya pou boule lansan. ");
INSERT INTO hat_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","W'a fè l' kare kare. L'a mezire dizwit pous longè, dizwit pous lajè ak trannsis pous wotè. Kat pwent ki depase yo va fè yon sèl pyès avèk lòtèl la. Se va kòn lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","W'a kouvri tout anwo lòtèl la, kat kote l' yo ansanm ak kat kòn li yo ak pi bon kalite lò ki genyen. W'a fè yon bòdi an lò tout arebò l'. ");
INSERT INTO hat_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","W'a fè de bag an lò, w'a tache yo anba bòdi a sou de bò lòtèl la. Se nan bag sa yo w'a pase manch ki pou sèvi pou pote lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","W'a fè manch yo an bwa zakasya, epi w'a kouvri yo ak lò. ");
INSERT INTO hat_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","W'a mete lòtèl la devan rido ki pann devan Bwat Kontra a avèk kouvèti li sou li. Se la m'a vin jwenn ou. ");
INSERT INTO hat_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Arawon va boule lansan bon sant sou li chak maten lè l'ap netwaye lanp yo. ");
INSERT INTO hat_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","L'a boule lansan tou chak swa lè l'ap ranje lanp yo. Se pou yo toujou fè ofrann lansan sa a devan lòtèl Seyè a, chak jou san sote yonn, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Se pa pou nou ofri sou lòtèl la lansan ki pa fèt tout espre pou sèvis la, ni vyann bèt ki fèt pou boule, ni lòt manje. Ni se pa pou nou ofri ankenn bwason sou li non plis. ");
INSERT INTO hat_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Yon fwa chak lanne, Arawon va fè yon seremoni sou kòn lòtèl la pou Bondye ka fè gras. Yon fwa chak lanne, avèk san bèt yo touye pou mande padon pou peche a, l'a mande gras pou lòtèl la. Se pou yo toujou fè sa de pitit an pitit. Lòtèl sa a, se yon lòtèl ki fèt pou yo mete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Seyè a di Moyiz: ");
INSERT INTO hat_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","-Lè n'ap konte konbe moun ki genyen nan peyi Izrayèl la pou nou fè resansman, chak gason va bay Seyè a kichòy pou lavi yo, pou malè pa rive lè y'ap fè resansman an. ");
INSERT INTO hat_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Chak moun y'a konte nan resansman an va peye de goud edmi, dapre jan yo konte lajan nan kote ki apa pou Bondye a. Chak moun va peye sa tankou yon ofrann yo mete apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tout moun ki dwe bay non yo nan resansman an, sa vle di tout moun ki gen ventan osinon ki depase ventan, va peye menm lajan an bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Moun ki rich p'ap peye plis, ni moun ki pòv p'ap peye mwens, lè y'ap peye lajan an bay Seyè a pou lavi yo. ");
INSERT INTO hat_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","W'a resevwa lajan sa a nan men pèp la, w'a depanse l' pou sèvis Tant Randevou a. Sa va sèvi pou Seyè a pa janm bliye pèp Izrayèl la. Se va bagay y'a peye pou sove lavi yo. ");
INSERT INTO hat_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","-W'a fè yon gwo basen an kwiv avèk yon pye an kwiv tou. W'a mete l' ant Tant Randevou a ak lòtèl la. W'a mete dlo ladan l'. ");
INSERT INTO hat_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Arawon ak pitit gason l' yo va sèvi ak dlo sa a pou yo lave men yo ak pye yo. ");
INSERT INTO hat_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Lè y'ap antre nan Tant Randevou a, y'a lave men yo ak pye yo nan dlo sa a. y'a fè menm jan an tou lè y'ap pwoche bò lòtèl la pou fè sèvis pou ofri Seyè a bèt ki fèt pou boule nèt nan dife a pou li. Konsa, yo p'ap mouri. ");
INSERT INTO hat_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Wi, se pou yo lave men yo ak pye yo pou yo pa mouri. Se yon lòd pou Arawon, pou pitit gason l' yo ak pitit pitit k'ap vin apre yo, lòd pou yo toujou swiv, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Seyè a di Moyiz ankò: ");
INSERT INTO hat_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","-Pran pi bon plant santi bon ki genyen: ven liv lami, dis liv kannèl bon kalite, dis liv fèy sitwonèl, ");
INSERT INTO hat_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ven liv kas. W'a mezire yo dapre mezi yo sèvi nan kote ki apa pou Bondye a. W'a pran tou senk ka lwil oliv. ");
INSERT INTO hat_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Avèk tou sa, w'a fè yon lwil jan moun ki konn fè odè a fè. Lwil sa a va sèvi pou mete moun apa pou sèvis Bondye. Se avèk lwil sa a w'a sèvi pou mete moun osinon nenpòt bagay apa pou sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","W'a voye lwil la sou Tant Randevou a, sou Bwat Kontra a, ");
INSERT INTO hat_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","sou tab la ak tout bagay ki sèvi sou tab la, sou lanp sèt branch lan ak tout bagay ki sèvi ak li, sou lòtèl lansan an, ");
INSERT INTO hat_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","sou lòtèl kote yo boule ofrann yo ak sou tout bagay ki sèvi sou li, sou basen lan ak tout pye l'. ");
INSERT INTO hat_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Se konsa w'a mete tout bagay sa yo apa pou mwen pou yo ka pou mwen ase. Tout bagay ki va touche ak yo va apa pou mwen tou. ");
INSERT INTO hat_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Lèfini, w'a vide lwil la sou Arawon ak sou pitit gason l' yo. Konsa w'a mete yo apa pou yo ka sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","W'a pale ak pitit Izrayèl yo, w'a di yo: Nou wè lwil sa a, se ak li pou nou sèvi, de pitit an pitit, pou mete moun osinon nenpòt bagay apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Nou pa dwe sèvi ak lwil sa a sou nenpòt ki moun, ni nou pa fèt pou fè yon lòt lwil ak menm konpozisyon an. Se yon bagay ki apa pou mwen nèt. Nou fèt pou nou konsidere l' pou sa li ye a. ");
INSERT INTO hat_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Si yon moun sèvi ak menm konpozisyon an pou fè lwil, osinon si yon moun sèvi avè l' sou yon moun ki pa prèt, se pou yo disparèt li nan mitan pèp la. ");
INSERT INTO hat_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Apre sa, Seyè a di Moyiz konsa: -Pran epis sa yo: safetida, lorye, gonm bwa ak pi bon kalite lansan. W'a pran menm valè nan chak. ");
INSERT INTO hat_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","W'a fè yon lansan ak yo san ankenn kras ladan l', menm jan moun ki konn fè odè yo fè sa. W'a mete yon ti sèl ladan l', w'a mete l' apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","W'a pran ti gout ladan l', w'a pile l' fè l' fè poud. W'a sèvi avèk ti gout dèvan bwat ki gen ròch plat kontra a, nan Tant Randevou a kote pou m' kontre avè ou la. Se pou ou konsidere lansan sa a tankou yon bagay yo mete apa pou mwen ase. ");
INSERT INTO hat_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Piga ou sèvi ak menm konpozisyon sa a pou fè lansan pou sèvi pou tèt pa ou. Sa se yon bagay ki rezève pou sèvis Bondye ase. ");
INSERT INTO hat_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Si yon moun fè yon konpozisyon menm jan an pou sèvi l' odè, se pou yo disparèt li nan mitan pèp la. ");
INSERT INTO hat_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Seyè a pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","-Mwen chwazi Bezaleyèl, pitit Ouri, pitit pitit Our, nan branch fanmi Jida a. ");
INSERT INTO hat_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mwen mete lespri m' sou li an kantite pou l' ka gen ladrès, bon konprann ak konesans pou l' fè tout kalite travay atizan yo konn fè, ");
INSERT INTO hat_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","pou l' ka fè bèl desen, pou l' travay yo an lò, an ajan ak an kwiv, ");
INSERT INTO hat_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","pou l' travay pyè tankou òfèv yo konn fè a, pou l' moute yo sou nenpòt bagay, pou l' ka fè desen sou bwa, wi pou l' fè tout kalite bon bagay atizan konn fè. ");
INSERT INTO hat_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nan travay sa a, mwen bay Bezaleyèl yon lòt bòs pou ede l' nan travay la: se Owoliyab, pitit Ayisamak, moun branch fanmi Dann. Konsa tou, tout lòt moun nan pèp Izrayèl la n'a wè ki gen ladrès, konnen se mwen menm ki ba yo l' pou yo ka fè sa mwen mande ou fè a. ");
INSERT INTO hat_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Men sa mwen te mande ou fè: Tant Randevou a, Bwat Kontra a avèk ròch plat yo, kouvèti ki pou ale sou bwat la ansanm ak tout mèb ki pou ale nan tant lan, ");
INSERT INTO hat_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","tab la ak lanp sèt branch an lò a ansanm avèk tout bagay ki pou sèvi avèk yo, lòtèl pou boule lansan an, ");
INSERT INTO hat_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","lòtèl pou boule ofrann yo ak tout bagay ki pou sèvi sou lòtèl la, basen lan ak tout pye l' a, ");
INSERT INTO hat_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","bèl rad seremoni, rad pou Arawon, prèt la, ak pou pitit gason l' yo mete sou yo lè y'ap fè sèvis nan tant lan, ");
INSERT INTO hat_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","lwil pou mete moun apa pou Bondye a ak lansan santi bon pou kote ki apa pou Bondye a. Lè y'ap fè bagay sa yo, se pou yo fè l' jan mwen te di ou la. ");
INSERT INTO hat_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","-W'a di pèp Izrayèl la: Se pou nou respekte jou repo mwen yo, paske se va yon siy ant mwen menm ak nou menm, ak tout pitit pitit nou yo, pou fè konnen se mwen menm, Seyè a, ki mete nou apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Se poutèt sa, se pou nou respekte jou repo a paske se yon jou pou nou mete apa pou mwen. Si yon moun pa respekte jou sa a, se pou yo touye l'. Si yon moun fè nenpòt ki travay jou sa a, se pou yo disparèt li nan mitan pèp li a. ");
INSERT INTO hat_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","N'a fè tout travay nou pandan sis jou. Men setyèm jou a, se va yon gwo jou repo, jou n'a mete apa pou Seyè a. Nenpòt moun ki fè nenpòt ki travay jou sa a, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Se tout pèp la nèt ki pou respekte jou repo a de pitit an pitit. Se yon kontra ki la pou tout tan. ");
INSERT INTO hat_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Sa va yon siy ant mwen menm ak pèp Izrayèl la, paske mwen menm, Seyè a, mwen te pran sis jou pou m' fè syèl la ak latè a. Sou setyèm jou a mwen te sispann travay, mwen te pran repo. ");
INSERT INTO hat_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Lè Seyè a te fin pale konsa ak Moyiz sou mòn Sinayi a, li ba li de ròch plat kote li te ekri kontra a ak pròp men li. ");
INSERT INTO hat_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Lè pèp la wè Moyiz te rete lontan sou mòn lan san li pa desann, yo sanble bò kote Arawon, yo di l' konsa: -Ann debouye nou fè lòt bondye ki pou mache devan nou, paske nonm yo rele Moyiz la ki te fè nou moute soti nan peyi Lejip la, nou pa konn sa ki rive l'. ");
INSERT INTO hat_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Arawon di yo: -Wete tout zanno lò ki nan zòrèy madanm nou yo ak nan zòrèy pitit fi ak pitit gason nou yo, pote yo ban mwen. ");
INSERT INTO hat_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Konsa, tout pèp la wete zanno lò yo te gen nan zòrèy yo, yo pote yo bay Arawon. ");
INSERT INTO hat_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Arawon pran zanno yo, li fonn yo, li koule lò a nan yon moul, li fè estati yon ti towo bèf. Pèp la di: -Pèp Izrayèl, men bondye nou an. Se li ki te fè nou soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Lè Arawon wè sa, li bati yon lòtèl devan estati ti towo bèf la, epi li di yo: -Denmen m'ap fè yon gwo fèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Nan denmen maten yo leve byen bonè, yo touye bèt, yo boule yo nèt ofri bay Seyè a. Yo touye lòt bèt tou pou di l' mèsi. Apre sa, pèp la chita, yo manje, yo bwè. Lèfini, yo leve pou yo pran plezi yo. ");
INSERT INTO hat_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Lè sa a, Seyè a di Moyiz: -Ale non, ou mèt desann. Paske pèp ou a, pèp ou te fè moute soti nan peyi Lejip la, gen tan deraye, yo lage tèt yo nan bwa. ");
INSERT INTO hat_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Yo gen tan kite chemen mwen te mande yo swiv la. Yo pran lò, yo fonn li, yo fè estati yon ti towo bèf, yo tonbe fè sèvis pou li, yo touye bèt ofri ba li, epi yo di: Pèp Izrayèl, men bondye nou an. Se li ki te fè nou soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Seyè a di Moyiz ankò: -Mwen wè pèp sa a se yon pèp ki gen tèt di. ");
INSERT INTO hat_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Bon, koulye a kite m' al regle ak yo. Mwen pral fè yo konnen lè m' an kòlè, m'ap detwi yo, m'ap boule yo. Men, ou menm, m'ap fè ou vin yon gwo nasyon. ");
INSERT INTO hat_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moyiz kriye nan pye Seyè a, Bondye l' a, li di l': -Seyè, poukisa pou ou ta koute kòlè ou pou ou fache sou pèp ki pou ou a, pèp ou menm menm te fè moute soti kite Lejip avèk gwo pouvwa ou, avèk fòs ponyèt ou? ");
INSERT INTO hat_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Atò, sa pou moun peyi Lejip yo di? y'a di: Ala Bondye malveyan! Li fè yo soti kite Lejip pou l' te ka touye yo nan mòn yo, pou l' te ka disparèt yo sou latè. Seyè, pa koute kòlè ou! Chanje lide. Pa fè malè sèk sa a tonbe sou pèp ou a. ");
INSERT INTO hat_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Chonje sèvitè ou yo, Abraram, Izarak ak Izrayèl. Chonje pwomès ou te fè yo. Ou te fè sèman sou tèt ou, ou te di yo: M'ap ban nou pitit pitit an kantite, y'ap tankou zetwal nan syèl la. M'ap bay pitit pitit nou yo tout peyi mwen te di m'ap ban nou an, pou peyi a rele yo chèmèt pou tout tan. ");
INSERT INTO hat_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Lè sa a, Seyè a chanje lide, li pa voye malè sèk li te fè lide voye sou pèp la ankò. ");
INSERT INTO hat_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moyiz pran chemen pou l' tounen. Li desann soti nan mòn lan avèk de ròch plat kontra a nan men l'. Ròch yo te ekri sou tout kò yo, devan kou dèyè. ");
INSERT INTO hat_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Se Bondye menm ki te travay ròch plat sa yo. Se li menm tou ki te ekri sou yo ak pròp men li. Se li ki te grave tout lèt ki ekri sou ròch yo. ");
INSERT INTO hat_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Jozye te tande pèp la ki t'ap rele byen fò anba a. Li di Moyiz: -Pou tout bri mwen tande a, gen gwo goumen nan kan an! ");
INSERT INTO hat_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Men Moyiz reponn li: -Non! Non! Kalite chante sa a, se pa chante moun ki genyen yon batay ni chante moun ki pèdi batay. Se de gwoup moun k'ap chante: yonn ap reponn lòt. ");
INSERT INTO hat_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Lè Moyiz rive toupre kan an, li wè estati ti towo bèf la ak moun yo ki t'ap danse. Moyiz fè yon sèl kòlè, li voye ròch plat ki te nan men l' yo jete. Yo tonbe, y al kraze an miyèt moso anba pye mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Li pran estati ti towo bèf yo te fè a, li boule l', li kraze l', li fè l' tounen pousyè. Li simen pousyè a nan dlo. Lèfini, li fè moun Izrayèl yo bwè dlo a. ");
INSERT INTO hat_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Apre sa li di Arawon: -Kisa moun sa yo fè ou menm pou ou kite yo fè kalite gwo peche sa a? ");
INSERT INTO hat_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Arawon reponn li: -Mèt, tanpri, pa fache sou mwen! Ou menm, ou konnen jan pèp sa a toujou pare pou fè sa ki mal. ");
INSERT INTO hat_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Se yo menm ki di m' fè bondye pou yo, bondye ki pou mache devan yo, paske yo pa konnen sa ki rive Moyiz, nonm sa a ki te fè yo soti kite Lejip la. ");
INSERT INTO hat_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Lè sa a, mwen mande kilès nan mitan yo ki gen lò. Tout moun ki te gen lò sou yo ban mwen l'. Mwen lage lò a nan dife, epi estati ti towo bèf sa a parèt. ");
INSERT INTO hat_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moyiz wè pèp la te fin dechennen, paske Arawon te lage brid ba yo, yo te lage kò yo nan sèvi zidòl. Sa fè yo pa t' anyen ankò devan lènmi yo. ");
INSERT INTO hat_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moyiz kanpe nan pòtay lakou kan an, li pale byen fò, li di: -Tout moun ki pou Seyè a, vin jwenn mwen. Se konsa tout pitit Levi yo vin jwenn li. ");
INSERT INTO hat_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Li di yo: -Men sa Seyè a, li menm ki Bondye pèp Izrayèl la di: Se pou nou chak pran nepe nou, mache nan tout kan an, depi nan pòtay sa a rive jouk lòt bò a. Touye mezi moun ki tonbe anba men nou, kit se frè nou, kit se zanmi nou, osinon vwazinaj nou. ");
INSERT INTO hat_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Pitit Levi yo fè sa Moyiz te ba yo lòd fè a. Jou sa a, te gen twamil moun konsa nan pèp la ki te pèdi lavi yo. ");
INSERT INTO hat_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moyiz di pitit Levi yo: -Jòdi a, avèk san pitit gason nou yo ak san frè nou yo nou fè koule a, nou mete tèt nou apa nèt pou sèvis Seyè a. Se poutèt sa tou, Seyè a pa manke ban nou benediksyon l' jòdi a. ");
INSERT INTO hat_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Nan denmen, Moyiz rele pèp la, li di yo: -Nou te fè yon gwo peche. Men koulye a, mwen pral moute sou mòn lan bò kote Seyè a. m'a wè si m' ka jwenn padon pou peche nou an. ");
INSERT INTO hat_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moyiz tounen bò kote Seyè a. Li di l': -Ou wè gwosè peche pèp la fè. Yo fè yon estati an lò pou sèvi yo bondye. ");
INSERT INTO hat_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Men, tanpri, padonnen peche yo. Si se pa sa, tanpri efase non m' nan liv ou a. ");
INSERT INTO hat_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Seyè a reponn Moyiz, li di l': -Moun ki peche kont mwen an, se non l' pou m' efase nan liv mwen an. ");
INSERT INTO hat_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Koulye a, ou mèt ale. W'a mennen pèp la kote mwen te di ou mennen yo a. Chonje byen. Zanj mwen an ap mache devan ou. Men, lè jou a va rive pou m' vin fè regleman ak yo a, m'ap pini yo pou peche yo. ");
INSERT INTO hat_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Seyè a te voye yon maladi sou pèp la pou pini l', paske yo te fòse Arawon fè estati yon ti bèf pou yo. ");
INSERT INTO hat_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Seyè a di Moyiz: -Leve non, ou menm ak tout pèp ou te fè soti kite Lejip la. Kite kote nou ye a. Pran chemen pou n' ale nan peyi mwen te sèmante bay Abraram, Izarak ak Jakòb la, lè m' te di yo m'ap ba yo tè sa a pou pitit pitit yo. ");
INSERT INTO hat_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","M'ap voye yonn nan zanj mwen yo devan nou. M'ap mete moun Kanaran yo, moun Amori yo, moun Et yo, moun Ferezi yo, ak moun Jebis yo deyò sou tè yo a. ");
INSERT INTO hat_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ale. W'ap rive nan yon peyi kote lèt ak siwo myèl koule tankou dlo. Men, se pa mwen menm menm ki prale ansanm ak nou, paske nou se yon bann moun ki gen tèt di, mwen ta ka touye nou sou wout la. ");
INSERT INTO hat_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Lè pèp la tande move nouvèl sa a, yon sèl lapenn pran yo. Tout moun refize pote bijou sou yo. ");
INSERT INTO hat_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Seyè a di Moyiz konsa: -Di pitit Izrayèl yo se yon bann moun ki gen tèt di yo ye. Si se pou m' ta ale ak yo, menm yon sèl ti kadè, mwen ta fin estèminen yo nèt. Koulye a, se pou yo wete tout bijou yo gen sou yo. Lè sa a m'a wè, sa m' ka fè pou yo. ");
INSERT INTO hat_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Se konsa, depi sou mòn Orèb, moun Izrayèl yo pa janm pote bijou ankò sou yo. ");
INSERT INTO hat_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moyiz pran tant lan, li mete l' yon ti distans an deyò limit kan kote yo te enstale a. Li rele l' Tant Randevou a. Tout moun ki te bezwen pale ak Seyè a te blije soti nan kan an pou ale nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Chak fwa Moyiz te soti pou l al nan tant lan, tout pèp la te fèt pou kanpe, chak moun devan papòt kay yo, ap gade Moyiz jouk li antre nan tant lan. ");
INSERT INTO hat_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Depi Moyiz antre nan tant lan, poto nwaj la desann, li kanpe sou papòt tant lan. Epi Seyè a pran pale ak Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Lè tout moun wè poto nwaj la kanpe nan papòt tant lan, yo leve, yo bese tèt yo jouk atè devan papòt kay pa yo. ");
INSERT INTO hat_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Seyè a te konn pale fasafas ak Moyiz tankou yon moun k'ap pale ak zanmi l'. Apre sa, Moyiz te tounen nan kan kote pèp la te enstale a. Men, te gen yon jenn gason yo te rele Jozye, pitit gason Noum lan, ki t'ap sèvi ak Moyiz. Li menm, li pa t' janm kite tant lan. ");
INSERT INTO hat_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moyiz di Seyè a: -Ala ou di m' fè pèp la moute ale nan peyi a, men ou pa di m' kilès w'ap voye avè m' pou ede m'. Men, koulye a ou di m' ou konnen m' byen, ou konnen ki moun mwen ye. Ou kontan mwen anpil. ");
INSERT INTO hat_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Bon, si ou kontan m' vre, tanpri, fè m' konnen lide ou gen nan tèt ou pou m' ka konnen ki moun ou ye, pou m' ka toujou fè ou plezi. Chonje tou, pèp sa a se pa ou li ye wi! ");
INSERT INTO hat_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Seyè a reponn: -Se mwen menm k'ap mache avè ou. M'ap fè ou jwenn repo. ");
INSERT INTO hat_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moyiz di l': -Si se pa ou menm menm k'ap mache avè nou, ou pa bezwen kite nou soti isit la. ");
INSERT INTO hat_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Lè ou gade byen, ki jan pou mwen fè konnen ou konsidere m' anpil, mwen menm ansanm ak pèp ou a? Eske se pa lè ou mache ak nou? Si ou mache ak nou, tout moun va rekonèt mwen menm ansanm ak pèp la, nou pa menm ak lòt pèp ki sou latè yo. ");
INSERT INTO hat_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Seyè a di Moyiz: -m'a fè sa ou mande m' lan, paske ou fè kè m' kontan anpil. Mwen konnen ki moun ou ye. ");
INSERT INTO hat_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moyiz di l': -Tanpri, fè m' wè pouvwa ou! ");
INSERT INTO hat_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Lè sa a Seyè a reponn li: -M'ap fè ou wè jan m' gen bon kè, m'ap nonmen non m' devan ou. M'ap fè moun mwen vle gras, m'ap gen pitye pou moun mwen vle gen pitye. ");
INSERT INTO hat_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Seyè a pale ankò, li di-Ou p'ap kapab wè figi m', paske ankenn moun sou latè pa kapab wè figi m' pou l' kontinye ap viv apre sa. ");
INSERT INTO hat_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Li di ankò: -Men yon ti plas bò kote m'. W'a kanpe sou ròch sa a. ");
INSERT INTO hat_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Lè pouvwa mwen vin ap pase, m'ap mete ou nan twou ròch la, m'a kouvri ou avèk men mwen jouk mwen fin pase. ");
INSERT INTO hat_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Apre sa, m'a wete men m' sou ou. Se do m' ase w'a wè ki prale, men ou p'ap wè figi m'. ");
INSERT INTO hat_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Seyè a di Moyiz konsa: -Taye de ròch plat tankou de premye yo. m'a ekri sou yo tout pawòl ki te sou premye ròch ou te kraze yo. ");
INSERT INTO hat_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pare ou byen bonè denmen maten. W'a moute sou mòn Sinayi a. Vin jwenn mwen la sou tèt mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Pa kite pesonn moute avè ou. Pa kite pesonn parèt sou mòn lan. Ata mouton ak bèf pa pou vin manje twò pre mòn lan. ");
INSERT INTO hat_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moyiz taye de ròch plat tankou de premye yo. Nan denmen maten byen bonè, li moute sou mòn Sinayi a ak de ròch plat yo nan men l' jan Seyè a te ba li lòd la. ");
INSERT INTO hat_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Seyè a desann nan yon nwaj, li kanpe la toupre Moyiz. Li fè l' konnen se li menm yo rele Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Seyè a pase devan Moyiz, li pale byen fò, li di: -Seyè a, Seyè a se yon Bondye ki gen pitye pou moun, yon Bondye ki gen bon kè. Li pa fè kòlè fasil, li p'ap janm sispann renmen, l'ap toujou kenbe pawòl li. ");
INSERT INTO hat_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","L'ap kenbe pwomès li pou tout tan jouk sou mil jenerasyon, de pitit an pitit. L'ap toujou padonnen sa nou fè ki mal, sa nou te dwe fè nou pa fè, ak peche nou yo. Men, li pa nan kase fèy kouvri sa. Lè yon moun fè yon peche, l'ap pini pitit li yo, pitit pitit li yo ak pitit pitit pitit li yo pou sa li fè a, jouk sou twazyèm ak katriyèm jenerasyon. ");
INSERT INTO hat_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Lamenm, Moyiz prese bese tèt li byen ba jouk atè, li adore Bondye. ");
INSERT INTO hat_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Li di: -Seyè! Si ou kontan m' vre, tanpri, mache avè nou non! Pèp sa a, se yon bann moun ki gen tèt di, se vre. Men, padonnen fòt nou yo ak peche nou yo. Asepte nou pou moun ki rele ou pa ou. ");
INSERT INTO hat_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Seyè a reponn: -Mwen pral fè yon kontra avèk nou. Devan tout pèp la, mwen pral fè gwo bèl bagay, bèl bagay ankenn peyi sou latè ni ankenn nasyon poko janm wè. Konsa, tout pèp ki avè ou yo pral wè travay Seyè a ka fè, paske mwen pral sèvi avè ou pou m' fè yon bagay estraòdinè. ");
INSERT INTO hat_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Se pou ou swiv tout kòmandman mwen ba ou jòdi a. M'ap mete moun Amori yo deyò, ansanm ak tout moun Kanaran yo, tout moun Et yo, moun Ferezi yo, moun Evi yo ak moun Jebis yo, pou yo fè plas pou nou. ");
INSERT INTO hat_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Pran prekosyon nou pou nou pa antre nan ankenn konfyolo ak moun ki rete nan peyi kote nou prale a, paske sa ka tounen yon pèlen pou nou. ");
INSERT INTO hat_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Okontrè, se pou nou kraze lòtèl yo, dechouke tout vye ròch moniman yo te kanpe. Koupe tout poto bwa yo te plante pou zidòl yo. ");
INSERT INTO hat_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Nou pa fèt pou nou sèvi lòt bondye paske mwen menm, Seyè a, yo rele m' Bondye ki fè jalouzi. Mwen se yon Bondye ki fè jalouzi anpil. ");
INSERT INTO hat_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Pa antre nan ankenn konfyolo ak moun ki rete nan peyi a, paske lè y'ap sèvi bondye yo, lè y'ap touye bèt pou yo, sa y'ap fè a se menm bagay ak fanm k'ap fè jennès. Lè sa a y'a konprann pou yo vin envite nou. Konsa nou ka tonbe nan manje vyann bèt yo te ofri bay zidòl yo. ");
INSERT INTO hat_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Konsa konsa, yon lè n'a pran pitit fi moun sa yo pou madanm pitit gason nou yo. Lè pitit fi yo menm va lage kò yo nan sèvis lòt bondye yo, yo ka pran tèt pitit gason nou yo, fè yo vire do ban mwen pou y al sèvi bondye pa yo a, tankou lè yon nonm kite madanm li pou l' al dèyè lòt fanm. ");
INSERT INTO hat_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Piga ou janm fonn metal pou fè estati ki pou sèvi ou bondye. ");
INSERT INTO hat_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Se pou ou toujou fete fèt pen san ledven an. Pandan sèt jou nan mwa Abib la, nou va manje pen san ledven, jan mwen te ban nou lòd la, paske se nan mwa sa a nou te soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tout premye pitit gason se pou mwen yo ye. Konsa tou, tout bèt, kit se bèf, kit se mouton, kit se kabrit, premye pitit mal yo fè, se pou mwen yo ye tou. ");
INSERT INTO hat_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Men, lè yon manman bourik fè premye pitit mal li, nou ka achte l' nan men m'. N'a ban mwen yon mouton pou li. Si nou pa vle peye pou li, se pou nou kase kou l'. Konsa tou, nou va achte nan men m' tout premye pitit gason gason nou yo va fè. N'a ban mwen kichòy pou yo. Piga pesonn janm parèt devan mwen de men l' vid. ");
INSERT INTO hat_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","W'a travay sis jou. Men setyèm jou a, se pou ou sispann travay, te mèt nan sezon plante osinon nan sezon rekòt. ");
INSERT INTO hat_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","W'a fete fèt Senmenn yo, fèt premye grap ble ou koupe lè rekòt la. Lèfini, nan fen lanne a w'a fete fèt Rekòt la. ");
INSERT INTO hat_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Twa fwa chak lanne, tout gason ki nan mitan nou gen pou parèt devan mwen, Seyè sel Mèt la, Bondye pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Lè m'a fin mete lòt nasyon yo deyò pou fè plas pou nou, lè m'a fin laji teritwa nou an, pesonn p'ap gen lanbisyon pou yo seye vin pran peyi a nan men nou lè n'a moute chak lanne pou parèt devan mwen menm, Seyè a, Bondye nou an, pou fete twa fèt sa yo. ");
INSERT INTO hat_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Lè n'ap touye yon bèt pou ofri l' ban mwen, piga nou janm sèvi ak pen ki fèt ak ledven. Lè fèt Delivrans lan menm, piga nou kite ankenn vyann bèt yo touye pou fèt la rete pou denmen maten. ");
INSERT INTO hat_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","N'a pran pi bèl fwi nan premye rekòt jaden nou yo, n'a pote yo bay Seyè a, Seyè nou an, lakay li. Piga ou janm kwit yon ti mouton nan lèt manman l'. ");
INSERT INTO hat_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Seyè a di Moyiz ankò: -Ekri tout pawòl sa yo, paske se dapre pawòl sa yo m'ap siyen kontra m' lan avè ou ansanm avèk pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moyiz te rete la avèk Seyè a pandan karant jou karant nwit. Li pase tout jou sa yo san manje san bwè. Li te ekri tout pawòl kontra a sou ròch plat yo. Se te dis kòmandman yo. ");
INSERT INTO hat_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Lè Moyiz desann soti sou mòn Sinayi a, li t'ap pote de ròch plat yo nan men l'. Men, gen yon bagay li pa t' konnen. Lè li t'ap pale ak Seyè a, figi l' te vin klere byen bèl. ");
INSERT INTO hat_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Arawon ak tout pèp la t'ap gade Moyiz, yo we jan figi l' te klere, yo te pè pwoche bò kote l'. ");
INSERT INTO hat_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Men Moyiz rele yo. Arawon vin jwenn li ansanm ak tout chèf pèp la. Moyiz pale ak yo. ");
INSERT INTO hat_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Apre sa, tout rès pèp Izrayèl la pwoche, epi Moyiz ba yo tout lòd li te resevwa nan men Seyè a sou mòn Sinayi a. ");
INSERT INTO hat_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Lè Moyiz fin pale ak yo, li kouvri figi li ak yon twal. ");
INSERT INTO hat_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Chak fwa Moyiz antre nan tant lan devan Seyè a pou pale avè l', li toujou wete twal la jouk li soti deyò ankò. Lè l' soti, li rakonte pèp Izrayèl la tou sa Seyè a te ba li lòd di yo. ");
INSERT INTO hat_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Lè konsa, moun pèp Izrayèl yo gade, yo wè figi Moyiz te klere byen bèl. Apre sa, Moyiz remete twal la sou figi l' ankò, pou jouk lè li antre ankò pou l' pale ak Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moyiz sanble tout pèp Izrayèl la, li di yo: -Men sa Seyè a bay lòd pou nou fè. ");
INSERT INTO hat_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","N'a travay sis jou, men se pou nou mete setyèm jou a apa pou Bondye, se jou repo ki apa nèt pou Seyè a. Si yon moun fè nenpòt ki travay jou sa a, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ata dife piga nou limen nan ankenn kay jou repo a. ");
INSERT INTO hat_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moyiz pale ak tout pèp Izrayèl la ki te sanble, li di yo: -Men sa Seyè a ban nou lòd fè: ");
INSERT INTO hat_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Se pou nou pran nan sa nou genyen pou fè ofrann pou Seyè a. Tout moun ki vle bay ak tout kè yo pou fè yon ofrann pou Seyè a va fè l'. y'a pote lò, ajan ak kwiv, ");
INSERT INTO hat_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","bon twal siperyè koulè violèt, ble ak wouj, twal fen blan ak twal pwès fèt ak pwal kabrit, ");
INSERT INTO hat_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","po belye tenn koulè wouj, po bazann, ak bwa zakasya, ");
INSERT INTO hat_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","lwil pou lanp sèt branch lan, epis santi bon pou mete nan lwil yo sèvi pou mete moun apa pou Bondye a ak nan lansan an, ");
INSERT INTO hat_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","pyè oniks ak lòt pyè pou gani jile ak plastwon prèt la. ");
INSERT INTO hat_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Se pou tout moun pami nou ki gen ladrès vin jwenn mwen pou yo fè travay Seyè a bay lòd fè a: ");
INSERT INTO hat_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","kay Bondye a avèk tant lan, twati li, kwòk li yo, ankadreman li yo, travès li yo, poto li yo ak tout sipò yo, ");
INSERT INTO hat_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Bwat kontra a ak manch li yo, kouvèti bwat la, ak rido pou kache bwat la, ");
INSERT INTO hat_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","tab la avèk manch li yo ansanm ak tout bagay pou sèvi ak li, ak pen yo ofri bay Bondye a tou, ");
INSERT INTO hat_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","gwo lanp sèt branch lan ak tout bagay ki sèvi avè l' yo, tèt lanp yo ak lwil pou lanp yo, ");
INSERT INTO hat_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","lòtèl pou boule lansan an ak tout manch li yo, lwil yo sèvi pou mete moun apa pou sèvis Bondye a, lansan santi bon, rido pou fèmen kote yo antre nan tant lan, ");
INSERT INTO hat_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","lòtèl pou boule nan dife bèt yo ofri bay Bondye, avèk griyaj an kwiv li a, ak tout manch li yo ak tout bagay ki pou sèvi avè l' yo, basen lan ak tout pye li, ");
INSERT INTO hat_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","rido pou galeri a ak poto l' yo ak tout sipò yo, rido pou fèmen kote pou yo antre nan galeri a, ");
INSERT INTO hat_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","dis pikèt ak tout kòd pou tant lan ak galeri a, ");
INSERT INTO hat_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","bèl rad seremoni pou prèt yo mete sou yo lè y'ap fè sèvis nan kote ki apa pou Bondye a, rad pou Arawon, prèt la, ak rad pou pitit gason l' yo lè y'ap fè travay prèt yo. ");
INSERT INTO hat_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Lè Moyiz fin di yo sa, tout pèp Izrayèl la al lakay yo. ");
INSERT INTO hat_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Apre sa, tout moun ki te soti pou bay ak tout kè yo, ki te vle fè ofrann, tounen vin jwenn li. Yo te pran nan sa yo genyen, yo pote ofri bay Seyè a pou fè Tant Randevou a, pou fè tout bagay yo bezwen pou sèvis li ansanm ak rad seremoni yo. ");
INSERT INTO hat_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Tout moun ki te soti pou bay ak tout kè yo pou fè ofrann, fanm kou gason, yo vini, yo pote zanno, bag, kolye, braslè ak tout kalite bijou an lò. Chak moun te pote bijou an lò yo te mete apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tout moun ki te gen bon twal siperyè koulè ble, koule violèt osinon koulè wouj, twal fen blan, twal pwès fèt ak pwal kabrit, po belye tenn koulè wouj, ou ankò po bazann, tout moun ki te gen bagay sa yo lakay yo pote yo vini. ");
INSERT INTO hat_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tout moun ki te vle ofri ajan ak kwiv devan Seyè a, yo te pote l', yo te leve l' devan Seyè a. Tout moun ki te gen bwa zakasya lakay yo ki te ka sèvi nan travay la te pote l'. ");
INSERT INTO hat_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tout fanm ki te gen ladrès te file fil koulè ble, violèt ak wouj, ak twal fen koulè blan, epi yo pote yo vini. ");
INSERT INTO hat_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Tout fanm ki te soti pou fè kichòy ak tout kè yo te fè twal pwès ak pwal kabrit, yo pote yo vini tou. ");
INSERT INTO hat_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Chèf yo menm te pote pyè oniks ak lòt pyè pou yo gani jile ak plastwon prèt la, ");
INSERT INTO hat_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ansanm ak epis santi bon ak lwil pou lanp sèt branch lan, lwil yo sèvi pou mete moun apa pou Bondye, ak lansan santi bon. ");
INSERT INTO hat_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Se konsa tout moun pèp Izrayèl ki te soti pou bay kichòy ak tout kè yo pou travay Seyè a te di Moyiz ba yo lòd fè a, fanm kou gason, yo te pote ofrann yo te vle fè bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moyiz di pèp Izrayèl la: -Gade. Seyè a chwazi Bezaleyèl, pitit Ouri a, pitit pitit Our, nan branch fanmi Jida a. ");
INSERT INTO hat_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Li mete lespri l' sou li an kantite pou l' ba li ladrès, konesans ak bon konprann pou l' fè tout kalite travay atizan yo konn fè a, ");
INSERT INTO hat_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","pou l' konn fè bèl desen, pou l' fè travay an lò, an ajan ak an kwiv, ");
INSERT INTO hat_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","pou l' travay pyè tankou òfèv yo konn fè a, epi pou l' konn moute yo, pou l' travay bwa, pou l' ka fè tout kalite travay atizan konn fè. ");
INSERT INTO hat_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Bondye ba li don pou l' moutre lòt moun metye sa yo. Se menm jan an tou pou Owoliyab, pitit Ayisamak, nan branch fanmi Dann lan. ");
INSERT INTO hat_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Seyè a ba yo konesans ak ladrès pou yo ka fè tout kalite travay atizan ka fè, desen sou bwa, bon twal koulè ble, violèt ak wouj, twal fen blan. Wi, li ba yo ladrès pou yo ka fè tout metye, pou yo ka fè tout kalite bèl bagay. ");
INSERT INTO hat_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Bezaleyèl, Owoliyab ansanm ak tout moun ki gen konprann, tout moun Seyè a te bay ladrès ak konesans pou yo ka fè tou sa ki nesesè pou kay Bondye a, se pou yo fè tout bagay jan Seyè a te bay lòd la. ");
INSERT INTO hat_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moyiz fè rele Bezaleyèl, Owoliyab ansanm ak tout lòt bòs atizan Bondye te bay ladrès ak konesans. Li fè rele tout moun ki te vle pou yo mete men nan travay la ak tout kè yo. ");
INSERT INTO hat_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Yo resevwa nan men Moyiz tout ofrann moun pèp Izrayèl yo te pote pou fè tou sa ki nesesè pou kay Bondye a. Y al travay. Moun Izrayèl yo menm te toujou ap pote ofrann yo bay Moyiz chak maten, san pesonn pa t' fòse yo. ");
INSERT INTO hat_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Lè sa a, tout bòs atizan ki t'ap travay pou kay Bondye a kite travay yo t'ap fè a, yo vin jwenn Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Yo di l' konsa: -Pèp la pote depase sa nou bezwen pou nou fini ak travay Seyè a te bay lòd fè a. ");
INSERT INTO hat_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Lè sa a, Moyiz fè pibliye lòd sa a nan tout kan an: -Pesonn, ni gason ni fanm, pa bezwen pote ankenn ofrann pou kay Bondye a ankò. Se konsa, yo te fè moun yo sispann pote lòt ofrann. ");
INSERT INTO hat_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Sa yo te pote deja a te menm twòp pou travay ki te gen pou fèt la. ");
INSERT INTO hat_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Yo pran ouvriye ki te pi abil nan travay la pou fè tant lan. Yo fè l' ak dis lèz twal fen blan tise byen sere, twal lenn koulè ble, violèt, wouj, avèk pòtre zanj cheriben bwode byen bèl sou tout kò l'. ");
INSERT INTO hat_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Chak lèz te mezire katòz mèt longè, de mèt lajè. Tout lèz yo te menm gwosè. ");
INSERT INTO hat_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Yo pran senk lèz, yo koud yo ansanm. Apre sa, yo fè menm bagay la tou ak senk lòt lèz yo. ");
INSERT INTO hat_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Yo pran kòdon fèt ak twal ble, yo fè pasan, yo moute yo sou rebò dènye lèz nan chak gwoup. ");
INSERT INTO hat_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Yo mete senkant pasan nan premye lèz premye gwoup la ak senkant pasan nan dènye lèz dezyèm gwoup la yon jan pou yo koresponn de pa de. ");
INSERT INTO hat_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Yo te fè senkant ti kwòk an lò. Yo pase kwòk yo nan pasan yo pou kenbe de gwoup rido yo ansanm. Se konsa, yo te fè yon sèl tant pou sèvi kay kote pou Bondye rete a. ");
INSERT INTO hat_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Apre sa, yo fè onz lèz twal ak pwal kabrit pou kouvri tant kote Bondye rete a. ");
INSERT INTO hat_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Tout onz lèz yo te menm gwosè, chak te mezire kenz mèt longè ak de mèt lajè. ");
INSERT INTO hat_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Yo pran senk lèz, yo koud yo ansanm sou yon bò. Apre sa, yo fè menm bagay la ak sis lòt lèz yo apa. ");
INSERT INTO hat_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Yo mete senkant pasan sou rebò dènye lèz nan premye gwoup la ak senkant pasan sou rebò dènye lèz nan dezyèm gwoup la. ");
INSERT INTO hat_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Yo fè senkant ti kwòk an kwiv pou kenbe de gwoup lèz yo ansanm, pou yo ka fè yon sèl tant. ");
INSERT INTO hat_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Yo fè yon kouvèti pou tant lan ak po belye tenn koulè wouj. Apre sa, yo fè yon lòt kouvèti ak po bazann pou ale anwo kouvèti ki fèt ak po belye a. ");
INSERT INTO hat_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Yo te fè ankadreman an bwa zakasya pou soutni tant Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Chak ankadreman te mezire kenz pye longè sou vennsèt pous lajè. ");
INSERT INTO hat_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Yo chak te gen de bout ki depase ki te penmèt mare yo yonn ak lòt. Yo fè tout ankadreman kay la menm jan an tou. ");
INSERT INTO hat_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Yo te fè ven ankadreman pou fasad sid la. ");
INSERT INTO hat_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Yo fè karant sipò an ajan pou ale anba pye ankadreman yo, de sipò pou chak ankadreman. ");
INSERT INTO hat_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Yo fè ven ankadreman pou fasad nò a, ");
INSERT INTO hat_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ak karant sipò an ajan, de pou chak ankadreman. ");
INSERT INTO hat_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Pou fasad lwès kay Bondye a, ki bay sou dèyè, yo fè sis ankadreman ");
INSERT INTO hat_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ak de lòt ankadreman ki pou fè kwen ki sou deyè kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kwen yo te mare yonn ak lòt pa anba, yo te bout-a-bout jouk anwo nan gwo bag la. Se konsa yo te moute de ankadreman ki te fè de kwen yo. ");
INSERT INTO hat_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Konsa sa te fè wit ankadreman ak sèz sipò an ajan, de sipò pou chak ankadreman. ");
INSERT INTO hat_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Apre sa, yo fè travès yo an bwa zakasya. Yo mete senk pou ankadreman sou yon bò kay Bondye a, ");
INSERT INTO hat_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","senk pou ankadreman sou lòt bò a ak senk pou ankadreman sou bò lwès la pa dèyè. ");
INSERT INTO hat_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Yo fè travès mitan an yon jan pou l' pase nan ren ankadreman yo, depi yon bout rive nan lòt bout la. ");
INSERT INTO hat_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Yo te kouvri ankadreman yo ak lò. Yo te fè bag an lò pou kenbe travès yo. Apre sa, yo kouvri tout travès yo ak lò tou. ");
INSERT INTO hat_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Yo fè rido a ak bon twal koulè ble, violèt epi wouj ansanm ak twal fen blan tise byen sere, avèk pòtre zanj cheriben bwode byen bèl sou tout kò l'. ");
INSERT INTO hat_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Yo fè kat poto an bwa zakasya pou rido a. Yo te kouvri yo ak lò, yo moute kwòk an lò sou yo. Yo travay kat sipò an ajan pou poto yo. ");
INSERT INTO hat_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Pou fèmen kote yo antre nan tant lan, yo fè yon rido ak bon twal ble, violèt ak wouj, ansanm ak twal fen blan tise byen sere, bwode sou tout kò l'. ");
INSERT INTO hat_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Yo fè senk poto avèk kwòk. Yo kouvri tèt poto yo ak trenng pou soutni rido yo ak lò. Epi yo fè senk sipò an kwiv pou poto yo. ");
INSERT INTO hat_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleyèl te fè Bwat Kontra a an bwa zakasya. Bwat la te mezire twa pye nèf pous longè, de pye twa pous lajè ak de pye twa pous wotè. ");
INSERT INTO hat_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Li kouvri l' nèt, andedan kou deyò, ak pi bon kalite lò ki genyen. Li mete yon bòdi an lò fè wonn li. ");
INSERT INTO hat_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Li fonn lò pou fè kat gwo bag tou won pou bwat la. Li moute yonn sou chak kwen bwat la, de chak bò. ");
INSERT INTO hat_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Li fè de jenn ti poto an bwa zakasya, li kouvri yo nèt ak lò. ");
INSERT INTO hat_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Li pase poto yo nan twou bag yo, yonn sou chak bò bwat la pou yo te kapab pote l' kote yo vle. ");
INSERT INTO hat_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Li fè yon kouvèti an bon lò pou bwat la. Kouvèti a te mezire twa pye nèf pous longè ak de pye twa pous lajè. ");
INSERT INTO hat_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Li pran de gwo moso lò, li bat yo ak mato, li fè pòtre de zanj cheriben li moute sou de pwent kouvèti a, ");
INSERT INTO hat_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","yonn sou bò gòch, lòt la sou bò dwat. Li fè yo tankou si yo te fè yon sèl pyès ak kouvèti a. ");
INSERT INTO hat_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Zanj cheriben yo te gen zèl yo louvri anwo tèt yo pou kouvri kouvèti a. Yo te yonn anfas lòt, avèk tèt yo bese ap gade kouvèti a. ");
INSERT INTO hat_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Li fè tab la an bwa zakasya. Tab la te mezire twa pye longè, yon pye sis pous lajè ak de pye twa pous wotè. ");
INSERT INTO hat_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Li kouvri l' nèt ak pi bon lò ki genyen, li mete yon bòdi an lò fè wonn li. ");
INSERT INTO hat_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Li mete yon ankadreman kat pous lajè anba desi a fè wonn tab la. Epi li kouvri tout ankadreman an ak yon plak lò. ");
INSERT INTO hat_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Li fè kat gwo bag tou won an lò. Li moute yo nan kat kwen tab la kote pye yo moute a. ");
INSERT INTO hat_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Li te moute bag won yo toupre ankadreman an. Se nan twou bag yo yo pase poto bwa ki pou sèvi pou pote tab la. ");
INSERT INTO hat_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Li fè poto yo ak bwa zakasya, epi li kouvri yo nèt ak lò. Se poto sa yo ki sèvi pou pote tab la. ");
INSERT INTO hat_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Li fè tout bagay ki pou ale sou tab la: asyèt, bòl, tas, gode, bagay ki pou sèvi lè y'ap fè sèvis pou Bondye. Li fè yo ak pi bon lò ki genyen. ");
INSERT INTO hat_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Li fè gwo lanp sèt branch lan ak pi bon lò ki genyen. Li pran yon sèl moso lò pou li fè lanp sèt branch lan: kò li, branch li yo, flè yo, boujon yo, ak fèy yo ki te fè yon sèl pyès ak li. ");
INSERT INTO hat_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Li te gen yon branch nan mitan ak twa branch chak bò. ");
INSERT INTO hat_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Sou chak branch sou kote yo, te gen pòtre twa flè nwa kajou ak tout boujon yo sou yo. Konsa, konsa, sou tout sis branch sou kote yo. ");
INSERT INTO hat_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Sou branch mitan an te gen kat flè nwa kajou avèk tout boujon yo sou yo. ");
INSERT INTO hat_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Te gen yon ti boujon anba chak pè branch sou kote yo. ");
INSERT INTO hat_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Boujon yo ak branch yo te fè yon sèl pyès ak pye lanp sèt branch lan. Se yon sèl moso lò yo bat pou fè tout. ");
INSERT INTO hat_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Li fè sèt ti lanp pou lanp sèt branch lan avèk pensèt pou netwaye lanp lan ak plato pou resevwa sann lan. Li fè yo ak pi bon lò ki genyen. ");
INSERT INTO hat_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Li te pran swasannkenz liv bon lò pou fè lanp sèt branch lan ansanm ak tout bagay pou sèvi ak lanp sèt branch lan. ");
INSERT INTO hat_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezaleyèl fè lòtèl pou boule lansan an ak bwa zakasya. Li fè l' kare kare: dizwit pous lajè, dizwit pous longè, trannsis pous wotè. Kat kòn yo te fè yon sèl pyès ak lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Bezaleyèl kouvri tout anwo lòtèl la, kat kote l' yo ansanm ak kat kòn li yo ak pi bon kalite lò ki genyen. Apre sa, li mete yon bòdi an lò fè wonn li. ");
INSERT INTO hat_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Li fè de bag an lò, li moute yo anba bòdi a sou de kote lòtèl la. Se nan bag sa yo pou yo pase manch ki pou sèvi pou pote lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Li fè manch yo an bwa zakasya epi li kouvri yo nèt ak lò. ");
INSERT INTO hat_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bezaleyèl fè lwil ki pou sèvi pou mete moun osinon nenpòt bagay apa pou Bondye a ansanm ak lansan santi bon an, jan moun ki konn fè odè avèk ladrès yo fè yo. ");
INSERT INTO hat_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezaleyèl fè lòtèl pou boule ofrann yo an bwa zakasya. Li fè l' kare kare: Li te mezire sèt pye sis pous longè, sèt pye sis pous lajè, kat pye sis pous wotè. ");
INSERT INTO hat_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Li travay kat kòn sou kat kwen lòtèl la. Kòn yo te fè yon sèl pyès ak lòtèl la. Apre sa, li kouvri tout ak kwiv. ");
INSERT INTO hat_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Li fè tout bagay ki pou mache ak lòtèl la: recho, pèl, fouchèt, plato pou resevwa sann, kivèt. Li fè tout bagay sa yo an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Li fè yon griyaj an kwiv pou lòtèl la, tankou griy pou griye vyann. Li mete griyaj la anba rebò lòtèl la, li fè l' soti anba rive mwatye wotè lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Li fè kat gwo bag tou won an kwiv, li mete yo nan kat pwent griyaj la. Se nan bag sa yo pou yo pase poto ki sèvi manch pou pote lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Apre sa, li fè manch an bwa zakasya, li kouvri yo an kwiv nèt. ");
INSERT INTO hat_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Li pase manch yo nan bag won yo sou chak bò lòtèl la, pou yo ka pote lòtèl la. Li fè lòtèl la an planch. Tout anndan lòtèl la te rete vid. ");
INSERT INTO hat_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezaleyel pran moso kwiv poli ki te sèvi glas pou medam k'ap sèvi nan pòt antre Tant Randevou a, li fè yon gwo basen an kwiv avèk yon pye an kwiv tou pou mete l' chita. ");
INSERT INTO hat_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Li fè galeri a. Sou bò sid la, li moute yon seri rido fèt ak lèz twal fen blan tise byen sere, sou senkant mèt longè. ");
INSERT INTO hat_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Ven ankadreman yo ak ven sipò yo te fèt an kwiv. Kwòk poto yo ak trenng yo te an ajan. ");
INSERT INTO hat_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Menm jan an tou, sou bò nò a, li moute yon seri rido ki gen senkant mèt longè avèk ven poto sou ven sipò an kwiv. Kwòk poto yo ak trenng yo te an ajan. ");
INSERT INTO hat_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Sou bò lwès la, li moute yon seri rido fèt ak lèz twal ki mezire ven mèt longè, avèk dis poto chita sou dis sipò avèk kwòk poto yo ak trenng yo an ajan. ");
INSERT INTO hat_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Sou bò lès la, galeri a te gen swasannkenz pye lajè. ");
INSERT INTO hat_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Sou bò gòch espas kote yo antre a, li moute rido sou yon longè vennde pye sis pous avèk twa poto chita sou twa sipò. ");
INSERT INTO hat_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Sou bò dwat la, li moute rido sou yon longè vennde pye sis pous avèk twa poto chita sou twa sipò. Se konsa sa te fèt chak bò pòt kote yo antre a. ");
INSERT INTO hat_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Tout rido yo te fèt ak twal fen blan tise byen sere. ");
INSERT INTO hat_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Sipò poto yo te fèt an kwiv. Kwòk poto yo ak trenng yo, te fèt an ajan. Tèt poto yo te kouvri an ajan. Tout poto galeri a te mare yonn ak lòt ak trenng an ajan. ");
INSERT INTO hat_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Rido ki te fèmen kote yo antre nan tant lan te bwode byen bèl sou tout kò l'. Li te fèt ak bon twal siperyè koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere. Li te gen dis mèt longè, de mèt edmi wotè, tankou rido galeri a. ");
INSERT INTO hat_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kat poto kwen, chita sou kat sipò an kwiv tou, t'ap soutni rido pòt la. Kwòk yo ak trenng yo te fèt an ajan. Tèt poto yo te kouvri an ajan. ");
INSERT INTO hat_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Li fè tout pikèt pou tant lan ak pou galeri a an kwiv. ");
INSERT INTO hat_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Men kantite metal yo te sèvi pou fè tant kote yo mete Bwat Kontra a. Dapre lòd Moyiz te bay, se pitit Levi yo ki te fè lis metal yo, epi se Itama, pitit Arawon, prèt la, ki t'ap dirije yo nan travay sa a. ");
INSERT INTO hat_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleyèl, pitit Ouri, pitit pitit Our, nan branch fanmi Jida a, te fè tou sa Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Se Owoliyab, pitit Ayisamak, nan branch fanmi Dann lan, ki te ede l'. Owoliyab sa a te yon bon bòs atizan ki te konn fè desen. Li te konn bwode lenn ble, violèt ak wouj ansanm ak twal fen blan. ");
INSERT INTO hat_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tout lò yo te sèvi pou fè travay nan kote ki apa pou Bondye a, se te lò moun yo te ofri bay Bondye. Lò a te peze demil nèfsantrant (02930) liv, dapre mezi yo sèvi nan kote ki apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Ajan yo te ranmase pou resansman an te peze dimil swasanndis (010.070) liv, dapre mezi yo sèvi kote ki apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Sa se kantite ajan yo ranmase antou nan men moun ki te vin bay non yo lè resansman an. Chak moun te bay kantite yo te mande yo, ki vle di yon pyès ajan ki peze yon ons, dapre mezi yo sèvi kote yo mete apa pou Seyè a. Te gen sisantwamil senksansenkant (0603.550) gason ki te gen ventan pou pi piti, ki te enskri nan resansman an. ");
INSERT INTO hat_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Nan dimil swasanndis (010.070) liv ajan yo, dimil (010.000) liv te sèvi pou fè sipò pou tant lan ansanm ak sipò pou rido yo. Chak sipò te pran san liv. ");
INSERT INTO hat_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Avèk swasanndis liv ajan ki te rete a, yo fè kwòk ak trenng pou poto yo, epi yo kouvri tèt poto yo. ");
INSERT INTO hat_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Yo te ofri bay Seyè a sètmil katrevendis (07.090) liv kwiv antou. ");
INSERT INTO hat_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Yo sèvi ak kwiv la pou fè sipò ki nan pòt antre tanp lan, lòtèl la ak griyaj kwiv la ansanm ak tout bagay y'ap bezwen pou sèvi ak lòtèl la. ");
INSERT INTO hat_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Yo fè sipò pou galeri toutotou a, sipò pou pòt kote ki apa pou Seyè a, ansanm ak tout pikèt pou tant lan ak pou galeri a. ");
INSERT INTO hat_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Yo pran twal siperyè koulè ble, violèt ak wouj, yo fè bèl rad seremoni pou prèt yo mete sou yo lè y'ap fè sèvis nan kote ki apa pou Bondye a. Yo fè rad tou pou Arawon mete sou li sèlman lè l'ap fè sèvis Bondye, dapre lòd Seyè a te bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Yo fè jile a ak lò, ak twal siperyè koulè ble, violèt ak wouj, ak twal fen blan tise byen sere. ");
INSERT INTO hat_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Yo pran fèy lò, yo bat yo, yo koupe yo an filang, yo travay yo nan twal ble, violèt ak wouj la, ansanm ak nan twal fen blan an. Yo bwode yo byen bèl ak anpil ladrès. ");
INSERT INTO hat_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Yo fè zèpòlèt pou jile a. Yo tache yo yonn chak bò jile a pou kenbe moso devan an ak moso dèyè a nan plas yo. ");
INSERT INTO hat_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Bèl sentiwon byen bwode ki mache ak jile a te fè yon sèl pyès ak li, ak menm kalite bodri a. Yo te fè l' an lò avèk twal siperyè koulè ble, violèt ak wouj, ansanm ak twal fen blan tise byen sere, dapre lòd Seyè a te bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Apre sa, yo pran pyè oniks yo, yo moute yo chak sou yon gwo moso lò, yo grave non douz branch fanmi Izrayèl yo tankou lè y'ap grave non moun sou so. ");
INSERT INTO hat_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Yo moute pyè yo sou de zèpòlèt jile a, pou yo toujou chonje branch fanmi pep Izrayèl yo, jan Seyè a te bay Moyiz lòd la. ");
INSERT INTO hat_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Yo fè plastwon an, yo bwode l' byen bèl ak anpil ladrès tankou jile a. Yo fè l' an lò ak twal siperyè koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere. ");
INSERT INTO hat_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Yo fè l' kare kare, epi yo double l'. Li te mezire nèf pous kare kare, li te double. ");
INSERT INTO hat_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Yo moute kat ranje pyè sou li. Nan premye ranje a, yo mete yon pyè woubi, yon pyè topaz ak yon pyè emwòd. ");
INSERT INTO hat_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Nan dezyèm ranje a, yo mete yon pyè malachi, yon pyè safi ak yon pyè dyaman. ");
INSERT INTO hat_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Nan twazyèm ranje a, yo mete yon pyè opal, yon pyè agat ak yon pyè ametis. ");
INSERT INTO hat_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Nan katriyèm ranje a, yo mete yon pyè krizolit, yon pyè oniks ak yon pyè jasp. Yo te moute chak pyè sou yon moso lò. ");
INSERT INTO hat_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Te gen antou douz pyè ak non douz branch fanmi pèp Izrayèl yo grave yonn sou chak pyè. Yo te grave yon non sou chak pyè tankou lè òfèv ap grave so sou bag. ");
INSERT INTO hat_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Yo fè ti chenn pou plastwon an. Ti chenn yo te trese tankou ti kòdon. Yo te fèt ak pi bon kalite lò ki genyen. ");
INSERT INTO hat_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Apre sa, yo fè de moso lò pou moute pyè yo ak de bag an lò. Yo moute de bag yo nan de bout anwo plastwon an. ");
INSERT INTO hat_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Yo mare de ti kòdon an lò yo nan de bag yo, nan bout anwo plastwon an. ");
INSERT INTO hat_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Yo pran de lòt bout chenn yo, yo fè yo pase sou devan jile a. Yo tache yo sou de moso lò yo ki sou zèpòlèt jile a. ");
INSERT INTO hat_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Yo fè de lòt bag an lò, yo tache yo nan bout anba plastwon an sou lanvè, nan bòdi a toupre jile a. ");
INSERT INTO hat_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Yo fè de lòt bag an lò ankò, yo tache yo anba de zèpòlèt jile a, sou devan, toupre kouti a anwo sentiwon jile a. ");
INSERT INTO hat_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Yo mare de bag plastwon an ak de bag jile a ansanm ak yon kòdon ble pou plastwon an bat sou sentiwon jile a. Konsa, plastwon an p'ap ka soti detache sou jile a. Yo fè tou sa dapre lòd Seyè a te bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Apre sa, yo pran twal ble, yo fè rad ki pou ale anba jile a. ");
INSERT INTO hat_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Nan mitan rad la, yo fè yon twou pou pase nan tèt prèt la, epi yo mete yon doubli nan ankoli a tankou yo fè l' pou varèz an po bèt yo, pou li pa chire. ");
INSERT INTO hat_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Yo pran twal koulè ble, violèt ak wouj ansanm ak twal fen blan tise byen sere, yo fè bodri an fòm grenad sou tout woulèt anba rad la. ");
INSERT INTO hat_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Yo fè ti klòch an lò, yo mete yo nan espas ki separe grenad yo sou tout woulèt rad la. Ti klòch yo ak grenad yo te fè wonn rad la. ");
INSERT INTO hat_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Yon ti klòch, yon grenad, yon ti klòch, yon grenad sou tout woulèt rad la pa anba, jouk yo fè tout tou rad pou Arawon mete sou li lè l'ap fè sèvis la, jan Seyè a te bay Moyiz lòd fè l' la. ");
INSERT INTO hat_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Yo pran twal fen blan, yo fè chemiz pou Arawon ak pou pitit gason l' yo. ");
INSERT INTO hat_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Yo pran twal fen blan, yo fè mouchwa tèt la ak ganiti pou bonnèt yo pou moun rekonèt grad yo. Epi yo pran twal fen blan tise byen sere, yo fè kalson yo. ");
INSERT INTO hat_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Yo pran twal fen blan tise byen sere ak bon twal siperyè koulè ble, violèt ak wouj, yo fè sentiwon bwode byen bèl la, jan Seyè a te bay Moyiz lòd fè l' la. ");
INSERT INTO hat_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Yo fè ti plak lò ki pou ale sou mouchwa tèt la ak pi bon kalite lò ki genyen. Yo grave pawòl sa a sou li: Apa pou Seyè a, tankou lè y'ap grave so sou bag. ");
INSERT INTO hat_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Yo mare l' ak yon ti kòdon ble anwo nèt sou devan mouchwa tèt la, dapre lòd Seyè a te bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Se konsa yo te fin fè tout travay pou Tant Randevou a, kote pou Bondye rete a. Moun pèp Izrayèl yo te fè tout bagay dapre lòd Seyè a te di Moyiz la. Wi, se konsa yo te fè l'. ");
INSERT INTO hat_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Yo pran tout bagay, yo pote yo bay Moyiz, depi tant lan, kay kote pou Bondye rete a, ak tout bagay ki mache avè li yo, kwòk li yo, ankadreman li yo, trenng li yo, poto li yo ak sipò yo, ");
INSERT INTO hat_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","twati ki fèt ak po belye tenn tou wouj yo, twati yo fè ak po bazann ak rido pou kache Bwat Kontra a, ");
INSERT INTO hat_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","bwat ki gen de moso ròch kontra yo, manch li yo ak kouvèti a, ");
INSERT INTO hat_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","tab la ak tou sa ki pou sèvi ak tab la, pen yo ofri bay Bondye a, ");
INSERT INTO hat_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","gwo lanp sèt branch fèt an lò a, ti lanp ki pou moute an liy dwat sou li yo, avèk tou sa ki pou sèvi ak lanp sèt branch lan ansanm ak lwil pou lanp yo, ");
INSERT INTO hat_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","lòtèl fèt an lò a, lwil pou mete moun osinon bagay apa pou Bondye a, lansan ki santi bon an ak rido pou fèmen kote pou antre nan tant lan, ");
INSERT INTO hat_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","lòtèl fèt an kwiv la avèk griyaj an kwiv la, manch yo ak tou sa ki pou sèvi ak lòtèl la, basen lan ak pye l' a, ");
INSERT INTO hat_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","rido pou galeri a, poto yo, sipò yo, rido pou fèmen kote pou yo antre sou galeri a, kòd yo, pikèt yo ak tou sa yo bezwen pou fè sèvis nan Tant Randevou a kote pou Bondye rete a, ");
INSERT INTO hat_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","bèl rad seremoni pou yo mete lè y'ap fè sèvis nan kote ki apa pou Bondye a, rad pou Arawon, prèt la, mete sou li ansanm ak rad pou pitit gason l' yo mete sou yo lè y'ap fè travay prèt yo. ");
INSERT INTO hat_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Se konsa moun pèp Izrayèl yo te fè tout travay la jan Seyè a te bay Moyiz lòd fè l' la. ");
INSERT INTO hat_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moyiz egzaminen travay yo te fè a, li wè yo te fè l' jan Seyè a te bay lòd fè l' la. Wi, se konsa yo te fè l'. Lèfini, Moyiz beni yo. ");
INSERT INTO hat_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","-Sou premye jou premye mwa a, w'a moute Tant Randevou a kote pou Bondye rete a. ");
INSERT INTO hat_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","W'a mete bwat ki gen ròch kontra a ladan l'. y'a kache bwat la ak rido a. ");
INSERT INTO hat_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Apre sa, w'a pote tab la vini, w'a pran tout bagay ki pou sèvi ak tab la, w'a ranje yo sou li byen ranje. W'a fè pote lanp sèt branch lan tou, w'a moute ti lanp yo sou li. ");
INSERT INTO hat_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","W'a pran lòtèl an lò pou boule lansan an, w'a mete l' devan bwat ki gen ròch kontra yo, w'a moute rido ki pou fèmen kote pou moun antre nan tant lan. ");
INSERT INTO hat_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","W'a pran lòtèl pou boule bèt yo ofri yo, w'a mete l' devan kote pou moun antre nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","W'a mete basen lan nan espas ki ant Tant Randevou a ak lòtèl la. W'a mete dlo ladan l'. ");
INSERT INTO hat_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","W'a moute galeri a fè wonn tant lan, w'a moute rido ki pou fèmen kote pou moun antre sou galeri a. ");
INSERT INTO hat_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","W'a pran lwil yo sèvi pou mete moun osinon bagay apa pou Bondye a, w'a voye l' sou tant Bondye a, sou tout bagay ki ladan l'. Se konsa w'a mete tant lan ak tou sa ki ladan li apa pou mwen. y'a tounen bagay ki apa pou mwen nèt. ");
INSERT INTO hat_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","W'a voye lwil la tou sou lòtèl pou boule ofrann bèt yo, ak sou tout bagay ki sèvi avè l'. Se konsa w'a mete lòtèl la apa pou mwen, l'a pou mwen nèt ale. ");
INSERT INTO hat_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","W'a voye lwil la tou sou basen lan ak sou pye l' a. Se konsa w'a mete yo apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Apre sa, w'a fè Arawon ak pitit gason l' yo pwoche bò kote yo antre nan Tant Randevou a. W'a pran dlo, w'a benyen yo byen benyen. ");
INSERT INTO hat_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","W'a mete rad seremoni yo sou Arawon. Lèfini, w'a vide lwil sou tèt li. W'a mete l' apa pou mwen pou l' ka sèvi m' prèt. ");
INSERT INTO hat_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","W'a fè pitit gason l' yo pwoche tou. W'a mete chemiz sou yo. ");
INSERT INTO hat_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","W'a vide lwil sou yo menm jan ou te vide lwil sou papa yo pou yo ka sèvi m' prèt. Seremoni sa a va mete yo apa pou yo ka toujou sèvi m' prèt, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moyiz te fè tou sa Seyè a te ba li lòd fè. Wi, li fè tout bagay jan Seyè a te mande l' la. ");
INSERT INTO hat_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Sou premye jou premye mwa nan dezyèm lanne a, yo kanpe tant lan. ");
INSERT INTO hat_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moyiz fè kanpe tant lan. Li mete sipò yo nan pozisyon yo, li poze ankadreman yo, li moute trenng yo nan plas yo, li drese poto yo. ");
INSERT INTO hat_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Li louvri twal tant lan sou kay la, epi li mete twati tant lan anwo l', jan Seyè a te ba li lòd fè a. ");
INSERT INTO hat_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Li pran ròch kontra yo, li mete yo nan bwat la. Li pase manch yo nan bag yo, epi li mete kouvèti a anwo bwat la. ");
INSERT INTO hat_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Apre sa, li pote Bwat Kontra a andedan kay la, epi li moute rido yo. Se konsa, li kache Bwat Kontra a, jan Seyè a te ba li lòd la. ");
INSERT INTO hat_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Li mete tab la nan plas li nan Tant Randevou a, sou bò nò tant lan, pa deyò rido a. ");
INSERT INTO hat_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Li ranje pen yo byen ranje sou tab la devan Seyè a, jan Seyè a te bay Moyiz lòd fè l' la. ");
INSERT INTO hat_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Apre sa, Moyiz mete lanp sèt branch lan nan Tant Randevou a, sou bò sid tant lan anfas tab la. ");
INSERT INTO hat_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Li ranje ti lanp yo devan Seyè a, dapre lòd Seyè a te bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Li mete lòtèl an lò a nan Tant Randevou a, devan rido a. ");
INSERT INTO hat_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Li fè boule lansan santi bon sou li, jan Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Li moute rido yo kote pou yo pase antre nan tant lan. ");
INSERT INTO hat_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Li mete lòtèl pou boule bèt yo ofri yo devan kote pou yo antre nan Tant Randevou a. Apre sa, li pran bèt yo ofri yo, li touye yo, li boule yo sou lòtèl la ansanm ak lòt ofrann yo, jan Seyè a te ba li lòd fè a. ");
INSERT INTO hat_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Li mete basen lan nan espas ki nan mitan Tant Randevou a ak lòtèl la, epi li mete dlo ladan l'. ");
INSERT INTO hat_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moyiz, Arawon ansanm ak pitit Arawon yo lave men yo ak pye yo nan basen lan. ");
INSERT INTO hat_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Depi y'ap antre nan Tant Randevou a, depi y'ap pwoche bò lòtèl la, yo te lave men yo ak pye yo, jan Seyè a te bay Moyiz lòd pou yo fè a. ");
INSERT INTO hat_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Apre sa, li moute galeri a fè wonn tant lan ak lòtèl la, li mete rido kote pou yo pase antre nan tant lan. Se konsa Moyiz te fin fè travay la. ");
INSERT INTO hat_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Nwaj la kouvri Tant Randevou a, epi limyè prezans Seyè a plen tant lan. ");
INSERT INTO hat_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moyiz pa t' kapab antre nan Tant Randevou a, paske nwaj la te rete anplas anwo tant lan, epi limyè prezans Seyè a te plen tant lan. ");
INSERT INTO hat_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Pandan tout tan moun pèp Izrayèl yo t'ap vwayaje a, se sèlman lè nwaj la te leve soti anwo tant lan yo te ka derape. ");
INSERT INTO hat_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Men, si nwaj la pa t' leve anwo tant lan, yo pa t' pati. Yo te tann jouk nwaj la te leve. ");
INSERT INTO hat_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Lajounen, nwaj Seyè a te rete anwo tant lan, men lannwit, se te yon dife tout pèp Izrayèl la te wè klere nan nwaj la. Se konsa sa te fèt pandan tout vwayaj la. ");
INSERT INTO hat_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Seyè a rete nan Tant Randevou a, li rele Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","-W'a pale ak moun pèp Izrayèl yo, w'a di yo: Lè yon moun vle fè Seyè a yon ofrann, si se yon bèt li vle ofri, l'a ofri yon bèf osinon yon kabrit ou ankò yon mouton l'a pran nan bèt li yo. ");
INSERT INTO hat_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Si se yon gwo bèt li vle ofri pou yo boule pou Seyè a, l'a mennen yon towo bèf ki pa gen ankenn enfimite. L'a vin avè l' jouk devan pòt Tant Randevou a pou Seyè a ka asepte l'. ");
INSERT INTO hat_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","L'a mete men l' sou tèt bèt l'ap ofri a pou Bondye ka asepte l' tankou yon ofrann l'ap fè pou mande Bondye fè li gras. ");
INSERT INTO hat_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","L'a touye towo a la devan Seyè a. Apre sa, prèt yo, pitit Arawon yo, va pran san an pou yo ofri l' bay Seyè a. Lèfini, y'a voye san an sou kat bò lotèl ki toupre pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Apre sa, y'a kòche towo a, y'a koupe l' an moso. ");
INSERT INTO hat_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Prèt yo, pitit Arawon, prèt la, va limen dife sou lotèl la, y'a mete bwa nan dife a. ");
INSERT INTO hat_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Apre sa, prèt yo, pitit Arawon yo, va mete moso vyann yo ansanm ak tèt la ak moso grès yo sou dife ki sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Moun k'ap fè ofrann lan va lave tripay yo ak pye dèyè yo nan dlo. Lèfini, prèt yo va ofri yo bay Seyè a. Konsa y'a boule tout ofrann lan nèt sou lotèl la. Se sa yo rele yon ofrann bèt ou boule pou Seyè a, yon ofrann ou boule nèt nan dife epi k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Si se yon ti bèt moun lan vle ofri pou boule nèt pou Seyè a, l'a ofri yon ti bouk kabrit osinon yon belye mouton ki pa gen ankenn enfimite. ");
INSERT INTO hat_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","L'a touye l' sou bò nò lotèl la, devan Seyè a. Apre sa, prèt yo, pitit Arawon yo, va voye san an sou kat bò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Lèfini, nonm lan va koupe l' an moso. Prèt yo va mete tout moso yo ansanm ak tèt la ak moso grès yo sou dife ki sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Moun k'ap fè ofrann lan va lave tripay yo ak pye dèyè yo nan dlo. Apre sa, prèt yo va ofri yo bay Seyè a. Konsa l'a boule tout ofrann lan nèt sou lotèl la. Se sa yo rele yon ofrann bèt ou boule pou Seyè a, yon ofrann ou boule nèt nan dife epi k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Si se zwazo nonm lan ap ofri pou yo boule pou Seyè a, se va toutrèl osinon pijon. ");
INSERT INTO hat_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Prèt la va pran zwazo a, l'a pote l' bò lotèl la, l'a peze bèk li, l'a tòde kou l' pou l' touye l'. Y'a boule tèt la sou lotèl la, y'a fè san li koule sou kat bò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","L'a rache fal zwazo a ak tout plim li sou li. L'a jete l' bò lotèl la, sou bò solèy leve, kote yo mete sann dife a. ");
INSERT INTO hat_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Apre sa, l'a bay yon kout kouto nan mitan de zèl yo, l'a kenbe zèl yo, l'a louvri kò zwazo a ande san li pa detache zèl yo. Lèfini, prèt la va boule l' nèt sou dife ki sou lotèl la. Se sa yo rele yon ofrann bèt yo boule pou Seyè a, yon ofrann ou boule nèt nan dife epi k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Lè yon moun vle fè yon ofrann fèt ak grenn ki soti nan jaden yo bay Seyè a, se pou l' fè farin ak grenn yo anvan. Apre sa, l'a vide ti gout lwil oliv sou li, epi l'a mete lansan sou li tou. ");
INSERT INTO hat_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Lèfini, l'a pote l' bay prèt yo, pitit Arawon yo. Yonn nan prèt yo va pran yon ponyen nan farin melanje ak lwil la ansanm ak tout lansan an, l'a boule l' nèt sou lotèl la, pou Seyè a pa janm bliye nonm ki fè ofrann lan. Se sa yo rele yon ofrann yo boule nèt nan dife epi k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Rès ofrann lan va rete pou Arawon ansanm ak pitit gason l' yo. Rès ofrann sa a apa nèt pou Seyè a, paske se nan manje yo ofri pou boule pou Seyè a li soti. ");
INSERT INTO hat_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Lè w'ap ofri yon pen kwit nan fou, se pou ou fè l' ak farin lan san ou pa mete ledven ladan l'. Se ka gwo pen pwès fèt ak farin bat ak lwil oliv, ou ankò ti biswit plat wouze ak lwil oliv. ");
INSERT INTO hat_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Lè w'ap ofri yon pen kwit sou platin, w'a fè l' ak farin ble bat ak lwil oliv, men san ledven ladan l'. ");
INSERT INTO hat_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","W'a koupe l' an ti moso, epi w'a vide lwil sou li. Se konsa w'a ofri l' bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Lè w'ap ofri yon pen kwit nan chodyè, w'a fè l' ak farin melanje ak lwil oliv. ");
INSERT INTO hat_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","W'a fè yon ofrann avè l' bay Seyè a. W'a pote l' bay prèt la ki va mete l' sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Prèt la va pran yon moso nan ofrann lan ki va sèvi pou Seyè a pa janm bliye moun ki fè ofrann lan, l'a boule l' sou lotèl la. Se sa yo rele yon ofrann manje yo boule nan dife epi k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Rès ofrann lan va rete pou Arawon ansanm ak pitit gason l' yo. Rès ofrann sa a apa nèt pou Seyè a, paske yo pran l' nan manje yo ofri pou boule pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Piga ou janm ofri bay Seyè a ofrann manje ki gen ledven ladan l'. Piga ou janm sèvi ni ak ledven, ni ak siwo myèl nan ofrann w'ap boule nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","W'a ofri ledven ak siwo myèl fè Seyè a kado tankou ofrann premye donn nan jaden nou. Men, piga ou boule yo sou lotèl la, tankou ofrann ki pou fè Seyè a plezi ak bon sant yo. ");
INSERT INTO hat_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","W'a simen sèl sou tout ofrann w'ap fè, paske sèl la se pou fè ou chonje kontra Bondye te pase avè ou la. Wi, se pou nou mete sèl sou tou sa n'ap ofri. ");
INSERT INTO hat_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Lè w'ap ofri bay Seyè a premye grenn ki bon yo, w'a ofri grenn griye nan dife ak farin ble. ");
INSERT INTO hat_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","W'a mete lwil oliv sou li ansanm ak lansan. Se konsa w'a ofri l' bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Prèt la va pran ti gout nan ofrann manje a ak nan lwil la, l'a boule l' ansanm ak tout lansan an. Se sa yo rele yon ofrann manje yo boule nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Lè yon moun vle ofri bèt pou di Bondye mèsi, si se yon gwo bèt l'ap ofri, l'a bay yon towo bèf osinon yon vach ki pa gen ankenn enfimite. ");
INSERT INTO hat_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","L'a mete men l' sou tèt bèt l'ap ofri a, l'a touye l' devan pòt Tant Randevou a. Prèt yo, pitit Arawon yo, va voye san an sou kat bò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Nan bèt yo ofri a, l'a pran pati sa yo: grès ki vlope tripay la, ");
INSERT INTO hat_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","de wonyon yo ak tout grès ki sou yo a, ansanm ak mas grès ki sou fwa a, l'a boule yo tout nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Pitit Arawon yo va boule tou sa sou lotèl la ansanm ak ofrann boule ki te deja sou bwa dife a. Se sa yo rele yon ofrann yo boule nèt nan dife k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Si se yon ti bèt moun lan vle ofri, l'a bay yon mouton osinon yon kabrit, bouk ou fenmèl, men ki pa gen ankenn enfimite. ");
INSERT INTO hat_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Si se yon ti mouton l'ap ofri bay Seyè a, l'a mennen l' devan lotèl Seyè a, ");
INSERT INTO hat_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","l'a mete men l' sou tèt bèt l'ap ofri a, l'a touye l' la devan pòt Tant Randevou a. Apre sa, pitit Arawon yo va voye san an sou kat bò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Nan bèt yo ofri a, l'a pran pati sa yo: grès la, ke y'a koupe ra koupyon an, grès ki vlope tripay la, ");
INSERT INTO hat_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","de wonyon yo ak tout grès ki sou yo a, ansanm ak mas grès ki sou fwa a, l'a boule yo nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Prèt la va boule tou sa sou lotèl la. Se konsa y'a sèvi pou fè yon ofrann boule nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Si se yon kabrit li vle ofri, l'a mennen l' devan lotèl Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","L'a mete men l' sou tèt li, l'a touye l' la devan Tant Randevou a. Lèfini, pitit Arawon yo va voye san an sou kat bò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","L'a pran pati sa yo: grès ki vlope tripay la, ");
INSERT INTO hat_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","de wonyon yo ak tout grès ki sou yo a, ansanm ak mas grès ki sou fwa a, l'a boule yo nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Prèt la va boule tou sa sou lotèl la. Tout grès la se pou Seyè a li ye. Se yon ofrann ou boule nèt nan dife epi k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Piga nou janm manje ni grès ni san. Sa se yon regleman pou nou swiv, de pitit an pitit, kote nou pase. ");
INSERT INTO hat_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","-Men sa pou ou di moun pèp Izrayèl yo: Si yon moun fè yon peche san li pa konnen, si li pa swiv lòd Seyè a bay epi li fè sa l' pa t' dwe fè, men sa pou yo fè l': ");
INSERT INTO hat_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Si se granprèt la ki fè yon peche konsa epi ki lakòz tout pèp la ap sibi chatiman, granprèt la va mennen yon ti towo bèf san ankenn enfimite, l'a ofri l' bay Seyè a pou peche l' la. ");
INSERT INTO hat_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","L'a mennen towo a devan pòt Tant Randevou a, l'a mete men l' sou tèt towo a, epi l'a touye l' la devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Apre sa, granprèt la va pran ti gout nan san towo a, l'a pote l' anba Tant Randevou a, ");
INSERT INTO hat_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","l'a tranpe dwèt li nan san an, epi l'a voye san an sèt fwa devan rido kote ki apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Apre sa, l'a pran ti gout nan san an, l'a mete l' sou kat kòn lotèl lansan an ki anndan Tant Randevou a. L'a vide rès san an nan pye lotèl kote yo boule bèt yo ofri yo, ki bò pòt kote yo antre nan tant lan. ");
INSERT INTO hat_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Apre sa, l'a wete tout grès ki nan towo yo te ofri pou peche a. Y'a wete tout grès ki vlope tripay la, ");
INSERT INTO hat_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","de wonyon yo ak tout grès ki sou yo a, ansanm ak mas grès ki sou fwa a. ");
INSERT INTO hat_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","L'a wete yo menm jan yo fè sa lè y'ap fè ofrann bèt pou di Bondye mèsi. Prèt la va boule tout grès la sou lotèl ki la pou boule kalite ofrann bèt sa yo. ");
INSERT INTO hat_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Men, l'a pran po towo a ansanm ak tout vyann lan, tèt la, pye yo, tout tripay la avèk tout poupou a ladan l'. ");
INSERT INTO hat_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Wi, l'a pran tout rès towo a, l'a fè yo pote l' andeyò limit kote yo rete a. Lè y'a rive kote ki rezève pou jete sann lotèl yo, y'a fè yon dife bwa, y'a boule rès towo a sou li. Wi, kote yo jete sann dife a, se la pou yo boule vyann towo a. ");
INSERT INTO hat_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Si se tout pèp Izrayèl la ki fè peche san yo pa fè espre, si yo antò devan Bondye paske, san yo pa konnen, yo fè yon bagay Seyè a te ba yo lòd pou yo pa fè, ");
INSERT INTO hat_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","lè y'a vin wè yo te fè yon peche, y'a mennen yon jenn towo, y'a ofri l' bay Bondye pou l' ka wete peche yo a. Y'a mennen l' devan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Lè y'a rive la, chèf fanmi pèp Izrayèl yo va mete men yo sou tèt towo a, epi y'a touye l' la devan lotèl Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Granprèt la va pran ti gout nan san towo a, l'a pote l' anndan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","L'a tranpe dwèt li nan san an sèt fwa, l'a voye l' sèt fwa sou devan rido kote ki apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Apre sa, l'a pran ti gout nan san an, l'a mete l' sou kat kòn lotèl ki devan Seyè a, anndan Tant Randevou a. L'a vide rès san an nan pye lotèl kote yo boule bèt yo ofri yo, lotèl ki bò pòt kote yo antre nan tant lan. ");
INSERT INTO hat_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Apre sa, l'a pran tout grès towo a, l'a boule l' sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Menm sa li gen pou l' fè pou towo li ta ofri pou pwòp peche li fè, l'a fè l' pou towo sa a tou. Konsa, prèt la va fè ofrann bèt pou peche pèp la te fè san yo pa konnen an, epi Bondye va padonnen peche yo a. ");
INSERT INTO hat_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Lèfini, l'a pran rès towo a, l'a pote l' andeyò limit kote yo rete a, l'a boule l' menm jan li gen pou l' boule towo li ta ofri pou pwòp peche li fè. Se sa yo rele ofrann bèt yo fè pou wete peche tout pèp la te fè san li pa konnen. ");
INSERT INTO hat_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Si se yon chèf ki fè peche, ki rive antò devan Bondye li a paske, san li pa fè espre, li pa swiv yonn nan lòd Seyè a te bay la, ");
INSERT INTO hat_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","rive li rive konnen sa l' fè a pa bon, se pou l' mennen yon ti bouk kabrit ki pa gen ankenn enfimite, l'a ofri l' pou yo touye l' bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","L'a mete men l' sou tèt kabrit la, l'a touye l' sou bò nò lotèl la, kote yo konn touye bèt yo ofri pou boule nèt pou Seyè a. Se sa yo rele yon ofrann bèt pou wete peche moun fè san yo pa konnen. ");
INSERT INTO hat_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Prèt la va tranpe dwèt li nan san bèt yo ofri pou peche a, l'a mete san sou kat kòn lotèl kote yo boule bèt yo ofri bay Bondye yo, l'a vide rès san an nan pye lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Apre sa, l'a boule tout grès la sou lotèl la, menm jan yo fè l' pou grès bèt yo ofri pou di Bondye mèsi a. Se konsa prèt la va fè ofrann bèt pou wete peche chèf la te fè san li pa konnen an, epi Bondye va padonnen l' sa. ");
INSERT INTO hat_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Si se nenpòt lòt moun nan pèp la ki fè peche san li pa fè espre, ki vle di li antò paske li fè yon bagay Seyè a te bay lòd pa fè men li fè l' san l' pa konnen, ");
INSERT INTO hat_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","rive moun sa a rive konnen sa l' fè a pa bon, se pou l' mennen yon fenmèl kabrit ki pa gen ankenn enfimite, l'a ofri l' pou yo touye l' bay Seyè a pou peche li a. ");
INSERT INTO hat_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","L'a mete men l' sou tèt kabrit la, l'a touye l' sou bò nò lotèl la, kote yo konn touye bèt yo ofri pou boule nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Prèt la va tranpe dwèt li nan san bèt yo ofri a, l'a mete san sou kat kòn lotèl kote yo boule bèt yo ofri bay Bondye yo, l'a vide rès san an nan pye lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Lèfini, l'a wete tout grès la, menm jan yo fè l' pou bèt yo ofri pou di Bondye mèsi a, y'a boule l' sou lotèl la pou fè Bondye plezi ak bon sant li. Se konsa prèt la va fè ofrann bèt pou wete peche moun lan te fè san li pa t' konnen an, epi Bondye va padonnen l' sa. ");
INSERT INTO hat_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Si se yon ti mouton moun lan ap ofri pou wete peche li fè a, se yon ti fenmèl ki pa gen ankenn enfimite pou l' mennen. ");
INSERT INTO hat_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","L'a mete men l' sou tèt bèt li ofri pou wete peche li a, l'a touye l' sou bò nò lotèl la, kote yo konn touye bèt yo ofri pou boule nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Prèt la va tranpe dwèt li nan san bèt yo ofri a, l'a mete san sou kat kòn lotèl kote yo boule bèt yo ofri bay Bondye yo, epi l'a vide rès san an nan pye lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Apre sa, l'a wete tout grès la, menm jan yo fè l' pou mouton yo ofri pou di Bondye mèsi a, l'a boule l' sou lotèl la ansanm ak lòt ofrann y'ap boule pou Seyè a. Se konsa prèt la va fè ofrann bèt pou wete peche moun lan te fè san l' pa t' konnen an, epi Bondye va padonnen l' sa. ");
INSERT INTO hat_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Men nan ki sikonstans pou yo fè ofrann bèt pou peche moun fè san yo pa konnen: Si yon moun fin fè sèman nan tribinal pou l' di sa ki pase epi li refize pale sa l' te wè ou ankò sa li vin konnen, li gen pou l' peye pou sa li fè a. ");
INSERT INTO hat_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Si yon moun rive manyen, san li pa konnen, yon bagay moun k'ap sèvi Bondye pa gen dwa manyen, tankou kadav yon bèt ki pa bon pou moun k'ap sèvi Bondye, li te mèt yon bèt nan bwa, li te mèt yon bèt kay, li te mèt yon bèt k'ap trennen sou vant, lè l' rive konnen sa l' fè a, li menm tou li pa nan kondisyon pou fè sèvis pou Bondye, epi li antò pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Si, san li pa konnen, li rive manyen yon nonm ki pa nan kondisyon pou fè sèvis pou Bondye, nenpòt ki jan moun lan te ka rive nan eta sa a, lè pita li vin konnen sa l' fè a, li antò pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Si yon moun kite bouch li mennen l', epi li sèmante, li di l'ap fè yon bagay, se ka yon move bagay osinon yon bon bagay, lè l' vin rekonèt sa, se pou l' peye sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Lè yon moun rive antò paske li fè yonn nan bagay sa yo, se pou l' rekonèt devan tout moun sa l' fè a mal. ");
INSERT INTO hat_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Apre sa, l'a peye pou peche li fè a, l'a pran yon fenmèl nan mouton pa l' yo, osinon nan kabrit li yo, l'a ofri l' bay Seyè a pou peche li te fè a. Prèt la va fè ofrann bèt pou wete peche nonm lan. ");
INSERT INTO hat_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Men, si nonm lan pa ka bay yon mouton osinon yon kabrit, l'a pote yon pè toutrèl osinon yon pè pijon pou peye pou peche a. L'a ofri yo bay Seyè a, yonn pou yo touye pou peche a, lòt la pou yo boule nèt sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","L'a pote yo bay prèt la. Prèt la menm va ofri zwazo pou peche a anvan. L'a kase kou zwazo a, san li pa separe tèt la ak rès kò a. ");
INSERT INTO hat_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","L'a voye ti gout nan san an bò lotèl la. Epi l'a vide rès san an nan pye lotèl la. Se va yon ofrann bèt yo touye pou wete peche a. ");
INSERT INTO hat_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Apre sa, l'a ofri dezyèm zwazo a, l'a boule l' dapre regleman yo. Se konsa prèt la va fè ofrann bèt pou wete peche moun lan te fè a, epi Bondye va padonnen l' sa l' te fè a. ");
INSERT INTO hat_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Si moun lan pa ka bay de toutrèl osinon de pijon pou peye pou peche li fè a, l'a pote de liv bon farin. Li p'ap bezwen mete ni lwil oliv ni lansan sou li, paske se yon ofrann pou wete peche l'ap fè. ");
INSERT INTO hat_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","L'a pote l' bay prèt la, prèt la va pran yon ponyen nan farin lan ki va sèvi pou Seyè a pa janm bliye moun ki fè ofrann lan. L'a ofri l' bay Seyè a, l'a boule l' sou lotèl la tankou yon ofrann yo boule bèt pou Seyè a. Se va yon ofrann yo fè pou wete peche a. ");
INSERT INTO hat_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Se konsa, prèt la va fè ofrann pou wete peche moun lan te fè a, Bondye va padonnen l' sa l' te fè a. Rès farin lan va rete pou prèt la, tankou lè y'ap fè ofrann manje. ");
INSERT INTO hat_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","-Si yon moun fè yon peche san li pa fè espre, si li fè sa li pa t' dwe fè, tankou lè li bliye bay sa li te dwe bay pou Seyè a, l'a fè yon ofrann pou repare bagay li te fè ki mal la. L'a pran yon belye mouton nan bèt li yo, yonn ki san ankenn enfimite. Y'a di konbe bèt la vo, dapre lajan yo sèvi nan kay Bondye a, epi l'a ofri l' bay Seyè a. Se sa yo rele yon ofrann pou peye pou sa yon moun fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Se pou l' peye tou sa li te bliye bay Seyè a, plis vin pou san anwo li. L'a pote l' bay prèt la. Prèt la menm va ofri bouk la, l'a touye l' pou peye pou sa moun lan te fè ki mal, epi Bondye va padonnen l' sa. ");
INSERT INTO hat_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Si yon moun fè peche san l' pa konnen, si li fè yon bagay Seyè a te bay lòd pa fè, atout li pa t' fè espre, li antò. Se pou l' peye pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","L'a pran yon belye nan bèt li yo, yonn ki pa gen ankenn enfimite, l'a pote l' bay prèt la. Prèt la menm va ofri l' pou peye pou sa moun lan te fè ki mal. Y'a kalkile pri bèt la dapre sistèm lajan yo sèvi nan kay Bondye a. Prèt la va fè ofrann lan pou peye pou sa moun lan te fè san l' pa t' konnen an, epi Bondye va padonnen l' sa. ");
INSERT INTO hat_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Se sa yo rele yon ofrann moun fè pou peye pou sa yo fè ki mal kont Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","-Si yon moun fè peche, si li fè bagay Seyè a pa vle moun fè, si li bay yon moun pèp Izrayèl parèy li manti sou bagay li te mete an depo lakay li, sou bagay li te ba li kenbe pou li an zanmi, ou ankò si li vòlò l', ou ankò si li twonpe l', ");
INSERT INTO hat_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ou ankò si li jwenn bagay lòt la te pèdi epi li manti, li sèmante li pa t' jwenn li, pou tout bagay mal sa yo yon moun ka fè, se pou yo fè yon ofrann. ");
INSERT INTO hat_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Lè yon moun fè yon peche konsa, li koupab, epi se pou l' renmèt sa l' te vòlò a, osinon lajan li te fè sou tèt lòt la, osinon depo yo te ba l' kenbe a, ou ankò bagay pèdi li te jwenn lan, ");
INSERT INTO hat_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ou ankò sa l' te sèmante li pa t' jwenn lan. Wi, se pou l' renmèt tout plis ven pou san bay mèt bagay la, jou l'ap fè ofrann pou peye pou sa l' te fè ki mal la. ");
INSERT INTO hat_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Apre sa, l'a pran yon belye nan bèt li yo, yonn ki san ankenn enfimite, l'a mennen l' bay prèt la ki va ofri l' bay Seyè a pou li peye pou sa l' te fè ki mal la. Y'a kalkile pri belye a dapre sa yo gen pou yo peye pou ofrann konsa. ");
INSERT INTO hat_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Prèt la va fè ofrann lan pou li bay Seyè a. Bondye va padonnen l' nenpòt kisa li te fè li pa t' dwe fè. ");
INSERT INTO hat_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Seyè a pale ak Moyiz, li di l' ankò: ");
INSERT INTO hat_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","-Men lòd pou ou pase Arawon ansanm ak pitit gason l' yo. Men ki jan pou yo fè ofrann pou yo boule nèt pou Seyè a. Se pou ofrann lan pase tout nwit la ap boule jouk denmen maten sou lotèl la. Se pou dife sou lotèl la pa janm mouri. ");
INSERT INTO hat_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Nan maten, prèt la va chanje rad sou li, l'a mete yon chemiz fèt ak twal fen blan, ansanm ak yon kalson ki fèt ak menm twal la, l'a wete sann ki rete apre ofrann lan fin boule nèt sou lotèl la, l'a mete l' sou kote lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Apre sa, l'a chanje rad ankò, l'a mete rad òdinè l' sou li, l'a pote sann lan kote ki rezève pou sa, andeyò lòt bò limit kote moun yo rete a. ");
INSERT INTO hat_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Fòk dife ki sou lotèl la toujou ap boule. Pa janm kite l' mouri. Chak maten prèt la va mete bwa ladan l', epi l'a ranje ofrann pou boule a sou li, epi l'a boule grès ofrann yo fè pou di Bondye mèsi a. ");
INSERT INTO hat_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Se pou dife a toujou ap boule sou lotèl la. Pa janm kite l' mouri. ");
INSERT INTO hat_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Men regleman pou lè n'ap ofri grenn ki soti nan jaden nou. Yonn nan pitit Arawon yo va prezante grenn y'ap ofri a bay Seyè a devan lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Apre sa, l'a pran yon ponyen farin nan ofrann grenn lan tou melanje ak lwil ansanm ak tout lansan an, l'a boule l' sou lotèl la pou Seyè a pa janm bliye moun ki fè ofrann lan, ki vle di se tout yo ofri bay Seyè a. Sant ofrann yo boule a va fè Seyè a plezi. ");
INSERT INTO hat_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Arawon ak pitit li yo va manje rès la. Y'a fè pen san ledven avè l', y'a manje pen an yon kote apa pou Seyè a nan lakou Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Se pou yo kwit pen an san ledven. Se mwenmenm menm ki ba yo pòsyon pa yo nan ofrann y'ap boule nèt pou mwen an. Se yon bagay ki apa nèt pou mwen, tankou yon ofrann yo fè pou peche yo ak ofrann yo fè pou peye pou sa yo te fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nenpòt gason nan branch fanmi Arawon an ka manje l'. Sa se yon prensip k'ap la pou tout tan. Se va pòsyon pa yo nan ofrann grenn y'ap boule pou Seyè a. Si lòt moun manyen yon ofrann grenn yo mete apa pou Seyè a, malè va rive l' poutèt sa. ");
INSERT INTO hat_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Apre sa, Seyè a pale ak Moyiz, li di l' ankò: ");
INSERT INTO hat_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","-Men ofrann Arawon ak pitit gason l' yo va fè pou Seyè a jou y'ap mete yo apa pou sèvis Bondye a. Jou sa a, y'a pote yon liv farin menm kantite ak sa yo ofri chak jou a, y'a ofri mwatye ladan l' nan maten, lòt mwatye a nan aswè. ");
INSERT INTO hat_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Y'a melanje lwil ladan l', y'a kwit li sou griy. Apre sa, y'a kraze l' an ti moso tankou lè y'ap fè ofrann grenn ki soti nan jaden yo, y'a ofri l' bay Seyè a. Sant ofrann yo boule a va moute, l'a fè Seyè a plezi. ");
INSERT INTO hat_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Se yon lòd ki la pou tout tan. Se pou pitit Arawon y'a mete apa pou ranplase Arawon an toujou fè ofrann sa a bay Seyè a. Y'a boule ofrann lan nèt, y'a ofri l' bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Lè yon prèt ap fè yon ofrann grenn pou tèt pa l', se pou yo boule tout nèt nan dife. Yo pa fèt pou yo manje anyen ladan l'. ");
INSERT INTO hat_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Seyè a pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","-Men sa w'a di Arawon ak pitit gason l' yo. Men regleman pou yo swiv lè y'ap fè ofrann pou peche moun fè san yo pa konnen. Y'a touye bèt y'a ofri pou kalite peche sa yo sou bò nò lotèl la, kote yo touye bèt yo ofri pou boule a. Sa se yon ofrann yo mete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Prèt ki va touye bèt la va manje l' kote yo mete apa pou Bondye nan lakou Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Nenpòt moun osinon nenpòt bagay ki va manyen osinon ki va touche vyann bèt yo mete apa pou Seyè a va tounen yon moun osinon yon bagay yo mete apa pou Bondye tou. Si san bèt la tonbe sou yon rad, w'a lave rad la yon kote ki apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Se pou yo kraze tout veso an tè ki te sèvi pou bouyi vyann lan. Men, si se nan yon veso an kwiv yo te bouyi l', se pou yo grate l' byen grate epi lave l' nan gwo dlo. ");
INSERT INTO hat_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Tout gason nan fanmi prèt yo gen dwa manje nan vyann lan, paske se yon vyann yo mete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Men, si yo pran ti gout nan san bèt la pou yo pote l' anndan Tant Randevou a pou yo sèvi avè l' tankou san bèt yo ofri pou repare sa yon moun fè ki mal, yo pa fèt pou yo manje anyen nan bèt la. Se pou yo boule l' nèt nan dife. ");
INSERT INTO hat_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Men regleman pou yo swiv lè moun ap fè ofrann pou peye pou sa yo te fè ki mal. Ofrann sa yo se ofrann y'a mete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Y'a touye bèt pou ofrann sa a sou bò nò lotèl la, kote yo touye bèt yo ofri pou boule yo. Y'a voye san an sou kat bò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Y'a wete tout pati sa yo: ke a, grès ki vlope tripay yo, ");
INSERT INTO hat_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","de wonyon yo ak tout grès ki sou yo a, ansanm avèk mas grès ki sou fwa a, l'a ofri yo sou lotèl la pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Prèt la va boule tout pati sa yo sou lotèl la, tankou ofrann yo boule pou Seyè a. Se sa yo rele yon ofrann pou repare sa yo te fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Tout gason nan fanmi prèt yo kapab manje ladan l'. Se pou yo manje l' kote yo mete apa pou Bondye a, paske se yon ofrann ki apa nèt pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Ofrann pou peye pou sa yo te fè ki mal la, se menm bagay ak ofrann pou peche yon moun fè san l' pa konnen. Se menm regleman an pou tou de: vyann lan va rete pou prèt ki fè ofrann lan. ");
INSERT INTO hat_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Po bèt y'a ofri pou boule pou Bondye a va rete pou prèt ki fè ofrann lan. ");
INSERT INTO hat_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Tout ofrann fèt ak grenn ki soti nan jaden, kit yo te kwit nan fou, kit yo te kwit sou platin osinon sou griy, y'a rete pou prèt ki te ofri yo bay Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Men, lè se yon ofrann grenn ki soti nan jaden ki fèt tou kri, kit li melanje avèk lwil, kit li chèch, se pou tout pitit Arawon yo li ye, se pou yo separe l' bay yo tout. ");
INSERT INTO hat_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Men regleman pou yo swiv lè yon moun ap fè ofrann bay Bondye pou di l' mèsi: ");
INSERT INTO hat_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si yon moun ap fè ofrann pou di Bondye mèsi, l'a ofri yon bèt pou yo touye epi ansanm avè l' l'a pote gwo pen fèt ak farin san ledven melanje ak lwil oliv, pen plat san ledven avèk lwil oliv pase sou li, epitou gato fèt ak flè farin melanje ak lwil oliv. ");
INSERT INTO hat_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Konsa tou, l'a ofri avèk bèt pou yo touye a pen kwit ak ledven. ");
INSERT INTO hat_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","L'a pran yonn nan chak kalite pen yo, l'a ofri yo espesyalman bay Seyè a. Pen sa yo va rete pou prèt ki va pran san bèt la pou voye sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Kanta vyann bèt la, se pou yo manje tout menm jou yo te touye l' la. Yo pa fèt pou yo kite anyen pou denmen maten. ");
INSERT INTO hat_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Si yon moun pote yon ofrann pou di Bondye mèsi, paske li te vle kenbe yon ve li te fè, ou ankò paske li vle fè yon ofrann konsa, yo pa bezwen manje tout vyann ofrann lan menm jou a. Men yo gen dwa kite rès pou denmen. ");
INSERT INTO hat_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Men vyann ki rete pou twazyèm jou a, se pou yo boule yo. ");
INSERT INTO hat_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si yo manje anyen nan ofrann lan sou twazyèm jou a, Bondye p'ap asepte ofrann moun lan. Ofrann lan p'ap sèvi l' anyen. Se yon vyann fezande, moun ki manje l' va peye pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Si yon bagay ki pa bon pou fè sèvis Bondye tonbe sou vyann lan, yo pa ka manje l' non plis. Se pou yo boule l' nan dife. Tout moun ki nan kondisyon pou fè sèvis Bondye a ka manje nan vyann lan. ");
INSERT INTO hat_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Si yon moun ki pa nan kondisyon pou fè sèvis Bondye a manje nan vyann yo ofri bay Seyè a, se pou yo mete l' deyò nèt nan mitan pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Si yon moun manje nan vyann yo ofri bay Seyè a apre li fin manyen yon bagay ki pa nan kondisyon pou fè sèvis Bondye, kit se yon moun, kit se yon bèt, kit se nenpòt lòt bagay, se pou yo mete l' deyò nèt nan mitan pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Seyè a pale ak Moyiz, li di l' ankò: ");
INSERT INTO hat_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","-Men sa pou di moun pèp Izrayèl yo: Piga nou janm manje grès bèf, grès kabrit osinon grès mouton. ");
INSERT INTO hat_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Nou pa fèt pou nou manje grès bèt ki rete konsa li mouri mò natirèl li, ni grès bèt yon bèt nan bwa touye, men nou gen dwa sèvi ak grès la pou nou fè nenpòt lòt bagay nou vle. ");
INSERT INTO hat_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Lè yon moun manje grès yon zannimo yo te ofri pou boule pou Seyè a, se pou yo mete l' deyò nèt nan mitan pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Nenpòt ki kote nou ye, piga nou janm manje san zwazo, ni san ankenn lòt bèt. ");
INSERT INTO hat_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Si yon moun rive manje san nenpòt ki bèt, se pou yo mete l' deyò nèt nan mitan pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","-Men sa w'a di moun pèp Izrayèl yo. Lè yon moun ap fè yon ofrann pou di Bondye mèsi, se pou l' pran yon pòsyon ladan l' ki va sèvi tankou yon ofrann espesyal pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","L'a pote l' ak men l' pou yo boule l' pou Seyè a. L'a pote grès bèt la ansanm ak tout pwatrin lan pou yo ka balanse yo tankou yon ofrann devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Prèt la va boule grès la sou lotèl la. Men pwatrin lan va rete pou Arawon ak pitit li yo. ");
INSERT INTO hat_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","N'a pran jigo dwat bèt li te ofri pou di Bondye mèsi a, n'a bay prèt la li pou li prezante l' tankou yon ofrann devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Konsa, prèt ki ofri san an ak grès bèt yo te touye pou di Bondye mèsi a va resevwa jigo dwat la pou tèt pa l'. ");
INSERT INTO hat_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pwatrin bèt la, se yon ofrann espesyal y'a annik balanse devan Seyè a. Jigo dwat la, se yon ofrann y'a annik prezante devan Seyè a. Se Seyè a menm ki wete moso sa yo nan ofrann pèp la va fè a pou li bay prèt yo. Sa se bagay moun Izrayèl yo dwe toujou bay prèt yo. Se va yon regleman pou tout tan tout tan. ");
INSERT INTO hat_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Se pòsyon sa yo pou yo pran nan ofrann yo fè pou boule pou Seyè a pou yo te bay Arawon ak pitit li yo, depi jou yo te mete yo apa pou sèvi prèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Jou sa a, se Seyè a menm ki te bay pèp Izrayèl la lòd pou yo bay prèt yo pòsyon sa yo nan ofrann lan. Sa se yon regleman pou pèp Izrayèl la toujou swiv de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Men regleman pou yo swiv lè y'ap fè ofrann pou yo boule pou Seyè a, lè y'ap fè ofrann grenn ki soti nan jaden yo, lè y'ap fè ofrann pou peche moun fè san yo pa konnen, ofrann pou peye pou sa yo fè ki mal, ofrann pou lè y'ap mete prèt yo apa pou Bondye, ofrann pou di Bondye mèsi. ");
INSERT INTO hat_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Se Seyè a menm ki te bay Moyiz regleman sa yo, sou mòn Sinayi nan mitan dezè a, jou li te mande moun pèp Izrayèl yo pou yo fè ofrann ba li. ");
INSERT INTO hat_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","-Pran Arawon ak pitit gason l' yo ansanm avè ou. W'a pote rad seremoni yo, lwil pou mete moun osinon bèt apa pou Bondye a, towo yo ofri pou peye pou sa moun fè ki mal la, de belye mouton yo ak panyen pen san ledven yo tou. ");
INSERT INTO hat_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Apre sa, w'a rele tout pèp la pou yo sanble devan pòt kay Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moyiz fè sa Seyè a te ba li lòd fè a, epi tout pèp la sanble devan pòt kay Randevou a ");
INSERT INTO hat_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moyiz di moun yo: -Men sa Seyè a te ban mwen lòd fè a. ");
INSERT INTO hat_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Lè sa a Moyiz fè Arawon ak pitit gason l' yo pwoche, li benyen yo nan dlo. ");
INSERT INTO hat_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Lèfini, li mete chemiz la ak gwo rad la sou Arawon, li mare sentiwon an nan ren li. Apre sa, li mete jile a sou li, li mare bèl sentiwon jile a nan ren l'. ");
INSERT INTO hat_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Epi li mete plastwon an sou li, li mete ourim ak tourim yo nan pòch plastwon an. ");
INSERT INTO hat_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Li mare tèt Arawon ak gwo mouchwa tèt la, epi li pran plak lò ki te gen pawòl sa yo grave sou li: Apa pou Bondye, li mare l' sou devan mouchwa a dapre lòd Seyè a te ba li. ");
INSERT INTO hat_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Apre sa, Moyiz pran lwil pou mete moun apa pou Bondye a, li voye l' sou kay Bondye a ak sou tout bagay ki ladan l'. Se konsa, li te mete yo apa pou sèvis Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Li voye lwil la sèt fwa sou lotèl la ak sou tout bagay ki sèvi sou lotèl la, sou kivèt la ak tout pye li. Se konsa li mete yo apa pou sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Lèfini ankò, li pran lwil pou mete moun apa pou Bondye a, li vide l' sou tèt Arawon. Se konsa li mete l' apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moyiz fè pitit gason Arawon yo pwoche, li mete rad yo sou yo, li pase sentiwon nan ren yo, li mare mouchwa tèt sou tèt yo, dapre lòd Seyè a te ba li. ");
INSERT INTO hat_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Apre sa, Moyiz fè mennen ti towo yo ofri pou peye pou sa moun fè ki mal la. Arawon ak pitit gason l' yo mete men yo sou tèt li. ");
INSERT INTO hat_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Lèfini, Moyiz touye towo a, li tranpe dwèt li nan san towo a, li mete ti degout san sou kat kòn lotèl la. Apre sa, li fè ofrann pou peye pou tou sa moun te fè ki mal sou lotèl la, li vide tout rès san an atè nan pye lotèl la. Se konsa li mete l' apa pou Bondye, li mande Bondye gras pou li. ");
INSERT INTO hat_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Apre sa, Moyiz pran grès ki vlope tripay yo, mas grès ki sou fwa a, ansanm ak de wonyon yo ak tout grès yo, li boule yo nèt sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Men, li pran tout vyann ti towo a, po a ak tout tripay la, li boule yo an deyò limit kote yo rete a, dapre lòd Seyè a te ba li. ");
INSERT INTO hat_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Apre sa, Moyiz fè mennen belye mouton ki pou boule nèt pou Seyè a. Arawon ak pitit gason l' yo mete men yo sou tèt li. ");
INSERT INTO hat_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moyiz touye l', li pran san an, li vide l' tout arebò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Li dekoupe belye a an divès moso. Apre sa, li boule tèt la, moso vyann yo ak tout moso grès yo nèt sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Moyiz lave tripay yo ak pye yo nan dlo. Apre sa li boule tout towo a nèt sou lotèl la. Se te yon bèt li ofri pou boule nèt nan dife pou Seyè a, yon ofrann bèt k'ap fè Seyè a plezi ak bon sant li, dapre lòd Seyè a te ba li. ");
INSERT INTO hat_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Apre sa, Moyiz fè mennen lòt belye mouton an, belye ki pou sèvi nan seremoni pou mete prèt yo apa pou Seyè a. Arawon ak pitit gason l' yo mete men yo sou tèt li. ");
INSERT INTO hat_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moyiz touye l', li pran ti gout nan san belye a, li mete l' sou tete zòrèy dwat Arawon, sou pous men dwat li ak sou gwo zòtèy pye dwat li. ");
INSERT INTO hat_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Apre sa, Moyiz fè pitit gason Arawon yo pwoche, li mete ti gout san sou tete zòrèy dwat yo, sou gwo pous men dwat yo ak sou gwo zòtèy pye dwat yo. Lèfini, Moyiz pran rès san an, li vide l' tout arebò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Apre sa, li pran tout moso grès yo, ke a, tout grès ki vlope tripay yo, moso grès ki sou fwa a, de wonyon yo ak tout grès yo, ansanm ak jigo dwat la. ");
INSERT INTO hat_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Nan panyen pen san ledven ki devan Seyè a, li pran yon pen antye, yon gato fèt ak lwil, ak yon pen rale. Li mete yo sou moso grès yo ak sou jigo dwat la. ");
INSERT INTO hat_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Apre sa, li mete tout bagay sa yo nan men Arawon ak nan men pitit gason l' yo, li balanse yo devan Seyè a tankou yon ofrann. ");
INSERT INTO hat_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Apre sa, Moyiz pran ofrann yo nan men yo, li boule yo sou lotèl la anwo ofrann ki t'ap boule deja a. Se te yon ofrann pou bay prèt yo pouvwa pou yo sèvi Bondye, yon ofrann bèt k'ap boule nèt nan dife pou Seyè a, yon ofrann bèt k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moyiz pran moso pwatrin lan, li balanse l' devan Seyè a tankou yon ofrann. Nan belye ki te sèvi nan seremoni pou mete prèt yo apa a, se pòsyon sa a ki te pou Moyiz, dapre lòd Seyè a te bay Moyiz la. ");
INSERT INTO hat_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Lè sa a, Moyiz pran ti gout nan lwil pou mete moun apa pou sèvis Bondye a, li melanje l' ak san ki te sou lotèl la, li voye l' sou Arawon ak sou tout rad li yo, sou pitit gason Arawon yo ak sou tout rad yo. ");
INSERT INTO hat_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moyiz pale ak Arawon ansanm ak pitit gason l' yo, li di yo: -N'a fè kwit vyann belye a devan pòt Tant Randevou a. Se la n'a manje l' tou ansanm ak pen ki nan panyen ofrann yo fè lè nou t'ap resevwa pouvwa pou fè sèvis pou Bondye a, dapre lòd mwen te resevwa lè li te di m': Arawon ak pitit gason l' yo va manje vyann belye a. ");
INSERT INTO hat_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Si gen rès nan vyann lan ak nan pen an ki rete apre yo fin manje, n'a boule l' nan dife. ");
INSERT INTO hat_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pandan sèt jou, nou p'ap soti devan pòt Tant Randevou a, jouk lè y'a fini ak seremoni pou mete nou apa pou sèvis Bondye a, paske y'ap pran sèt jou pou fè seremoni pou ban nou pouvwa pou fè sèvis pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Sa nou wè nou fè jòdi a, se Seyè a menm ki te bay lòd pou nou te fè l' pou peye pou tou sa nou te fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Pandan sèt jou, lajounen kou lannwit, n'a rete la devan pòt Tant Randevou a, epi n'a fè tou sa Seyè a te ban nou lòd fè a. Si se pa sa, n'a mouri. Wi, men lòd Seyè a te ban mwen an. ");
INSERT INTO hat_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Se konsa, Arawon ak pitit gason l' yo te fè tou sa Moyiz te di yo Seyè a te ba yo lòd fè a. ");
INSERT INTO hat_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sou wityèm jou a apre yo fini avèk sèvis pou mete yo apa pou Bondye a, Moyiz rele Arawon ak pitit gason l' yo ansanm ak tout chèf fanmi pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Epi li di Arawon konsa: -Pran yon jenn ti towo san ankenn enfimite ki pou sèvi ofrann pou peye pou sa nou fè ki mal, ak yon belye mouton san ankenn enfimite ki pou sèvi ofrann pou nou boule nèt pou Seyè a. Ofri yo bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Apre sa, w'a mande moun pèp Izrayèl yo pou yo pran yon bouk san ankenn enfimite ki pou sèvi ofrann pou yo boule nèt pou Seyè a, yon ti towo san ankenn enfimite ki gen ennan ak yon ti mouton san ankenn enfimite ki gen ennan ki pou sèvi ofrann pou peye pou sa pèp la fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Lèfini, y'a pran yon towo ak yon belye pou sèvi ofrann pou di Bondye mèsi. Y'a ofri yo tout bay Seyè a ansanm ak ofrann grenn ki sot nan jaden yo melanje ak lwil. Y'a fè sa paske Seyè a pral parèt devan yo jòdi a. ");
INSERT INTO hat_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Se konsa yo pran tou sa Moyiz te ba yo lòd pran an. Yo mennen yo devan pòt Tant Randevou a. Apre sa, tout pèp la nèt sanble menm kote a, yo rete kanpe devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Lè sa a Moyiz di yo: -Seyè a te bay lòd pou nou te fè tou sa pou li ka fè nou wè pouvwa li. ");
INSERT INTO hat_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Apre sa, Moyiz di Arawon konsa: -Pwoche bò lotèl la, fè yon ofrann pou peye pou tou sa ou fè ki mal, ak yon ofrann pou ou boule nèt pou Seyè a. Apre sa w'a fè menm bagay pou pèp la. Wi, mete ofrann pèp la devan Bondye, mande Bondye pou l' fè yo gras, jan Seyè a te bay lòd la. ");
INSERT INTO hat_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Se konsa Arawon pwoche bò lotèl la, li touye ti towo bèf li te bay pou ofrann pou peye pou sa li te fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Pitit li yo pote san an ba li, li tranpe dwèt li nan san an, epi li mete ti gout san sou kat kòn lotèl la. Apre sa, li vide rès la nan pye lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Lè l' fini, li pran grès la, wonyon yo, mas grès ki te sou fwa a, li mete yo boule sou lotèl la jan Seyè a te bay Moyiz lòd la. ");
INSERT INTO hat_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pou vyann lan ak po a, li boule yo nan dife andeyò lòt bò limit kote yo rete a. ");
INSERT INTO hat_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Apre sa, Arawon touye bèt li te ofri pou boule nèt pou Seyè a. Pitit li yo pote san an ba li, li vide l' sou lotèl la ak tout arebò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yo pote ba li tou tèt la ansanm ak rès vyann lan dekoupe, epi li mete yo boule sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Li lave tripay yo ansanm ak pye yo. Lèfini li mete yo boule sou lotèl la anwo vyann yo t'ap boule pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Apre sa, Arawon mete ofrann pèp la devan Seyè a: li pran bouk pèp la te ofri pou peye pou sa yo fè ki mal la, li touye l' epi li ofri l' bay Seyè a pou peche pèp la, jan l' te fè l' pou pa l' la. ");
INSERT INTO hat_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Apre sa, li fè ofrann pou yo boule nèt pou Seyè a, dapre regleman yo. ");
INSERT INTO hat_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Li mete ofrann grenn jaden yo devan Seyè a. Li pran yon ponyen farin, li boule l' sou lotèl la, anplis ofrann ki t'ap boule depi maten an. ");
INSERT INTO hat_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Li touye towo a ak belye a, li ofri yo tankou ofrann pèp la fè pou di Bondye mèsi. Pitit li yo pote san an ba li, li vide san an sou lotèl la ak tout arebò lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Apre sa, Arawon pran tout moso grès towo a ak moso grès belye a, ke yo, grès ki vlope zantray yo, mas fwa yo, grès ki kouvri wonyon yo. ");
INSERT INTO hat_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Li mete yo yonn sou lòt sou de moso pwatrin yo, epi li pote tout grès yo, li mete yo boule nèt sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Men, li pran moso pwatrin yo ak jigo dwat yo, li balanse yo devan Seyè a tankou yon ofrann, jan Moyiz te ba li lòd fè a. ");
INSERT INTO hat_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Lè Arawon fin fè tout ofrann pou peye pou sa yo te fè ki mal, ofrann pou yo boule nèt pou Bondye ak ofrann pou di Bondye mèsi, li leve men l' anwo pèp la, li beni yo epi li desann. ");
INSERT INTO hat_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moyiz ak Arawon antre anndan Tant Randevou a. Lè yo soti, yo beni pèp la ankò. Se lè sa a pouvwa Seyè a parèt devan je pèp la. ");
INSERT INTO hat_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Yon dife rete konsa, li soti nan syèl la, li boule tout vyann ak tout grès ki te sou lotèl la. Lè pèp la wè sa, yo tout pran rele sitèlman yo te kontan epi yo tonbe fas atè devan Bondye. ");
INSERT INTO hat_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Yon jou, de nan pitit Arawon yo, Nadab ak Abiyou, leve, yo pran ti recho yo, yo mete chabon dife tou limen ladan yo, yo mete lansan nan dife a, epi y' al ofri l' bay Seyè a. Men, dife a pa t' bon paske se pa t' yon dife Seyè a te bay lòd fè. ");
INSERT INTO hat_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Seyè a voye yon dife sou yo, dife a boule yo, epi yo mouri la devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Lè sa a, Moyiz di Arawon: -Men sa Seyè a t'ap di nou an wi lè l' te di: Moun k'ap sèvi m' fèt pou respekte m'. M'a fè pèp la konnen pouvwa mwen! Arawon pa di anyen. ");
INSERT INTO hat_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Moyiz rele Mikayèl ak Elzafan, de pitit gason Ouzyèl, tonton Arawon, li di yo: -Vini non! Wete kadav kouzen nou yo devan tant Seyè a, pote yo deyò lòt bò limit kan an. ");
INSERT INTO hat_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Se konsa yo vini, yo pran kò yo ak tout rad ki te sou yo, yo pote yo lòt bò limit kan an, jan Moyiz te di a. ");
INSERT INTO hat_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Apre sa, Moyiz pale ak Arawon ansanm ak de lòt pitit gason l' yo, Eleaza ak Itama, li di yo: -Pa rete san penyen tèt nou, pa chire rad sou nou jan moun yo fè l' la lè yo nan lapenn pou ka lanmò. Si nou fè sa n'a mouri, Seyè a va fache sou tout pèp la. Men, frè nou yo ansanm ak tout lòt moun peyi Izrayèl yo gen dwa pran lapenn pou moun sa yo ki boule nan dife Seyè a te voye sou yo a. ");
INSERT INTO hat_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Nou menm, rete nan tant Randevou a. Pa mete pwent pye nou deyò. Si nou fè sa n'a mouri, paske avèk lwil yo te vide sou tèt nou an, yo mete nou apa pou Seyè a. Yo fè jan Moyiz te di a. ");
INSERT INTO hat_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Seyè a pale ak Arawon, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","-Ni ou menm, ni pitit gason ou yo, nou pa fèt pou nou bwè diven ni ankenn gwòg lè se jou nou gen pou nou antre nan Tant Randevou a. Si nou fè sa n'a mouri. Sa se yon regleman pou nou swiv tout tan, nou menm, pitit nou yo ak pitit pitit nou yo. ");
INSERT INTO hat_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Se pou nou konnen sa ki apa pou sèvis Bondye ak sa ki pou sèvis òdinè, sa ki pa ka sèvi pou sèvis Bondye ak sa ki ka sèvi pou sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Lèfini, se devwa nou pou nou moutre pèp Izrayèl la tout regleman mwen menm Seyè a, mwen te bay Moyiz pou nou. ");
INSERT INTO hat_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moyiz pale ak Arawon ansanm ak de lòt pitit gason ki te rete l' yo, Eleaza ak Itama, li di yo: -N'a pran farin ki rete nan ofrann grenn yo boule pou Seyè a, n'a fè pen san ledven avè l', n'a manje yo bò lotèl la, paske ofrann lan, se yon ofrann ki apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","N'a manje l' yon kote ki apa pou Seyè a. Wi, se pòsyon sa a ki pou ou ansanm ak pitit ou yo nan ofrann yo fè pou boule pou Seyè a. Se sa Seyè a te ban m' lòd fè. ");
INSERT INTO hat_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Konsa tou, nou menm ak tout fanmi nou, fi kou gason, nou gen dwa manje pwatrin yo balanse devan Seyè a ak jigo yo te ofri bay Seyè a pou prèt yo. N'a manje yo yon kote yo mete apa pou sèvis Seyè a. Paske, pòsyon sa yo se pou nou yo ye, pou nou ansanm ak pitit nou yo. Se nan ofrann moun Izrayèl yo fè pou di Bondye mèsi yo soti. ");
INSERT INTO hat_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Wi, y'a pote jigo ak pwatrin y'ap ofri pou boule ansanm ak pòsyon grès y'ap ofri pou boule nan dife pou Seyè a. Y'a balanse yo devan Bondye. Pòsyon sa yo va toujou rete pou ou ansanm ak pou pitit ou yo, jan Seyè a te bay lòd la. ");
INSERT INTO hat_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Lè sa a, Moyiz mande sa yo te fè ak kabrit ki sèvi ofrann pou peye pou sa moun te fè ki mal la. Yo di l' yo te gen tan boule l'. Moyiz fè yon sèl move sou Eleaza ak Itama, de gason Arawon ki te rete yo, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","-Poukisa nou pa t' manje ofrann yo te fè pou peche a nan kote yo mete apa pou sèvis Bondye a? Nou konnen ofrann lan se yon bagay ki apa nèt pou Seyè a. Seyè a ban nou l' pou nou manje, pou li ka wete peche pèp la, pou peye pou peche yo fè. ");
INSERT INTO hat_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tande byen. Nou wè yo pa t' pote san an anndan kay Bondye a. Se pou nou te manje vyann lan nan kay ki apa pou Bondye a, jan Bondye te ban mwen lòd fè l' la. ");
INSERT INTO hat_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Arawon reponn Moyiz: -Ou wè sa ki rive m' jòdi a? Atout pèp la te fè ofrann pou wete peche li yo ak ofrann pou boule pou Seyè a, mwen t'ap mande m' si m' te manje ofrann peche yo a jòdi a, ou kwè sa ta fè Seyè a plezi? ");
INSERT INTO hat_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Lè Moyiz tande sa, sa te fè kè l' kontan. ");
INSERT INTO hat_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","-Men sa pou nou di moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Nan tout bèt ki sou latè, men bèt nou ka touye pou nou manje. Nou ka manje tout bèt ki gen zago yo fann an de depi yo remoute manje tou. ");
INSERT INTO hat_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Men, gen bèt ki remoute manje epi ki pa gen zago yo fann. Bèt konsa nou pa gen dwa manje yo. Sa pa bon pou nou! Nou gen chamo ki remoute manje men ki pa gen zago yo fann. Vyann li pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Nou gen daman ki remoute manje men ki pa gen zago yo fann. ");
INSERT INTO hat_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Nou gen ankò lapen ki remoute manje men ki pa gen zago fann an de. Vyann li pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Nou gen ankò kochon. Li menm li gen zago fann an de, men li pa remoute manje. Vyann li tou pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Piga nou janm manje vyann bèt sa yo. Piga nou manyen kadav yo. Yo pa bon pou nou menm k'ap sèvi Bondye. ");
INSERT INTO hat_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Nan bèt k'ap viv nan dlo men sa nou ka manje. Nou ka manje tout bèt nan lanmè ak nan dlo dous ki gen zèl ak kal sou kò yo. ");
INSERT INTO hat_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Men, tout bèt k'ap viv nan lanmè osinon nan dlo dous men ki pa gen ni zèl ni kal sou kò yo, sa pa bon pou manje yo. ");
INSERT INTO hat_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Gade yo pou move vyann. Pa manje vyann yo, pa manyen kadav yo. ");
INSERT INTO hat_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tout bèt k'ap viv nan dlo men ki pa gen zèl ak kal sou kò yo, nou pa fèt pou nou manje yo. ");
INSERT INTO hat_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Nan tout zwazo men sa nou pa gen dwa manje paske yo pa bon pou nou menm k'ap sèvi Bondye. ");
INSERT INTO hat_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Malfini karanklou ak lòt bèt menm fanmi ak yo ki manje kadav, ");
INSERT INTO hat_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","tout kalite kònèy, ");
INSERT INTO hat_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","otrich, janmichèt, poul dlo, grigri, ak lòt bèt menm fanmi ak yo ki manje vyann vivan, ");
INSERT INTO hat_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","koukou, plonjon, frize, ");
INSERT INTO hat_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","gwo kanna mawon blan, grangozye, chwèt, ");
INSERT INTO hat_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","sigòy, krabye ak tout lòt bèt menm fanmi ak yo, chòchòt, sèpantye. ");
INSERT INTO hat_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tout ti bètazèl ki mache sou kat pye pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Men, nou ka manje tout ti bètazèl ki mache sou kat pye, depi yo gen de gwo pye ki penmèt yo sote, ");
INSERT INTO hat_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","tankou krikèt kay, krikèt bwa, chwal bondye ak lòt kalite krikèt. ");
INSERT INTO hat_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Men, tout lòt ti bètazèl ki gen kat pye pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Depi yon moun manyen kadav yonn nan bèt sa yo, li pa nan kondisyon pou l' fè sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Tout moun ki pote menm yon moso nan kadav yo gen pou lave tout rad sou li, epi li p'ap nan kondisyon pou l' fè sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Tout bèt ki pa gen zago yo fann an de osinon ki pa remoute manje pa bon pou nou manje. Tout moun ki manyen ata kadav bèt sa yo pa nan kondisyon pou l' fè sèvis pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Konsa tou, tout bèt ki mache sou kat pa t' men ki pa gen zago, yo pa bon pou nou manje. Depi yon moun manyen kadav yonn nan bèt sa yo, li pa nan kondisyon pou fè sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Tout moun ki pote kadav bèt yo al jete gen pou lave tout rad sou li, epi li p'ap nan kondisyon pou l' fè sèvis pou Bondye jouk aswè. Wi, tout bèt sa yo pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Pami tout bèt toupatou sou latè ki mache sou vant, men sa ki pa bon pou nou manje: tout kalite zagoudi, sourit ak leza, ");
INSERT INTO hat_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","zandolit, soud, mabouya, gongolo, aganman. ");
INSERT INTO hat_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Wi, tout bèt sa yo pa bon pou nou manje. Si yon moun annik manyen kadav yonn nan bèt sa yo, l'a nan kondisyon pou l' pa fè sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Si kadav bèt sa yo tonbe sou nenpòt ki bagay, kit an bwa, kit an twal, kit an po, kit an twal sak, osinon sou nenpòt ki zouti nou sèvi pou nou travay, bagay sa a osinon zouti sa a pa bon pou nou sèvi. Se pou nou mete l' tranpe nan dlo, li p'ap bon pou nou sèvi avè l' jouk aswè rive. Apre sa, nou ka sèvi avè l' san danje. ");
INSERT INTO hat_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Si kadav yonn nan bèt sa yo tonbe nan yon veso fèt an tè, tou sa ki nan veso a pa bon pou nou sèvi ankò, epitou se pou nou kraze veso sa a. ");
INSERT INTO hat_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Si ti gout nan dlo ki soti nan veso sa a ta rive tonbe sou nenpòt manje nou gen dwa manje, manje a pa bon ankò pou nou manje. Konsa tou, tout bwason nou gen dwa bwè, si yo ta rive vide l' nan yon veso konsa, li pa bon ankò pou nou bwè. ");
INSERT INTO hat_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Si kadav yonn nan bèt sa yo tonbe sou nenpòt bagay, bagay sa a pa bon pou sèvi ankò. Si se yon fou osinon yon recho, se pou yo kraze yo an miyèt moso. Yo pa bon, nou pa fèt pou sèvi ak yo ankò menm. ");
INSERT INTO hat_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Men, si yo tonbe nan yon sous osinon nan yon sitèn pou ranmase dlo, sous la osinon sitèn lan ap toujou bon pou sèvis nou. Men, moun ki manyen kadav la pou wete l' nan dlo a p'ap nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Si kadav yonn nan bèt sa yo tonbe sou grenn nou pral plante, grenn yo bon toujou pou plante. ");
INSERT INTO hat_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Men, si grenn lan te tranpe nan dlo epi kadav yonn nan bèt sa yo tonbe sou li, grenn lan pa bon ankò pou plante. ");
INSERT INTO hat_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Lè yon bèt nou ka manje rete konsa li mouri, tout moun ki manyen kadav li p'ap kapab fè sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Moun ki manje nenpòt moso nan vyann bèt mouri a gen pou l' lave rad sou li epi li p'ap nan kondisyon pou l' fè sèvis Bondye jouk aswè. Moun ki pote kadav la al jete gen pou l' lave rad sou li, epi li p'ap nan kondisyon pou l' fè sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Tout ti bèt k'ap trennen sou vant pa bon pou moun k'ap sèvi Bondye. Nou pa fèt pou manje yo. ");
INSERT INTO hat_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Depi se ti bèt k'ap trennen sou vant ou ankò ti bèt kat pye, ou ankò ti bèt ki gen anpil pye, yo yonn pa bon menm pou moun k'ap sèvi Bondye: nou pa fèt pou nou manje yo. ");
INSERT INTO hat_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Pa manje ankenn nan ti bèt k'ap trennen sou vant yo pou yo pa mete nou nan kondisyon pou nou pa kapab fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Se mwen menm Seyè a ki Bondye nou. Se pou nou kenbe kò nou yon jan pou nou viv apa pou mwen, paske mwen menm se yon Bondye apa mwen ye. Pa kite ankenn ti bèt k'ap trennen sou vant mete nou nan kondisyon pou nou pa ka sèvi m'. ");
INSERT INTO hat_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Se mwen menm, Seyè a, se mwen menm ki te mennen nou soti kite peyi Lejip pou m' te ka Bondye nou. Wi, se pou nou viv apa pou mwen, paske mwen se yon Bondye apa. ");
INSERT INTO hat_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Men regleman ki gen rapò ak bèt, zwazo ak tout lòt bèt k'ap viv nan dlo, osinon k'ap trennen sou vant. ");
INSERT INTO hat_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Se pou nou toujou rekonèt bèt ki ka mete nou nan kondisyon pou nou pa ka sèvi Bondye ak bèt ki p'ap fè l', bèt ki bon pou nou manje ak bèt ki pa bon pou nou manje. ");
INSERT INTO hat_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","-Men sa pou ou di pep Izrayèl la pou mwen. Lè yon fanm vin ansent, epi li fè yon pitit gason, li p'ap nan kondisyon pou l' fè sèvis pou mwen pandan sèt jou apre jou akouchman an, menm jan li pa ka fè sèvis pou mwen lè li gen règ li. ");
INSERT INTO hat_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sou wityèm jou a, y'a sikonsi pitit la. ");
INSERT INTO hat_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Men, madanm lan va rete ankò tranntwa jou. Se apre sa l'a fè sèvis pou san li pèdi a. Li p'ap gen dwa manyen ankenn bagay yo mete apa pou Bondye, ni li p'ap gen dwa antre nan tant ki apa pou Bondye a, toutotan li poko fè sèvis pou mete l' ankò nan kondisyon pou fè sèvis pou Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Si se yon tifi li fè, li p'ap nan kondisyon pou l' fè sèvis pou mwen pandan de senmenn apre akouchman an, menm jan li pa ka fè sèvis pou mwen lè li gen règ li. Apre sa se pou l' pase swasannsis jou anvan li fè sèvis pou san li pèdi a. ");
INSERT INTO hat_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Lè li fin pase kantite jou pou l' pase a, kit se pou yon pitit gason, kit se pou yon pitit fi, fanm lan va pran yon ti mouton ki poko gen ennan ak yon jenn ti pijon osinon yon toutrèl, l'a pote yo bay prèt la devan pòt Tant Randevou a. Ti mouton an va sèvi ofrann yo boule nèt pou Bondye a. Ti pijon an osinon ti toutrèl la va sèvi ofrann pou mande Bondye padon pou sa l' te fè ki mal. ");
INSERT INTO hat_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Prèt la va ofri yo bay Seyè a pou mande padon pou fanm lan. Se konsa fanm lan va fè sèvis pou san li pèdi a. Wi, se sa pou yon fanm fè apre li fin akouche, kit se yon gason, kit se yon fi li fè. ");
INSERT INTO hat_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Si fanm lan pa gen mwayen pou l' pote yon ti mouton, lè sa a l'a pote de pijon osinon de toutrèl, yonn pou yo boule nèt pou Bondye, lòt la pou yo ofri pou mande padon. Prèt la va ofri yo bay Seyè a pou l' mande padon pou li. Se konsa fanm lan va fè sèvis pou l' ka nan kondisyon sèvi Bondye ankò. ");
INSERT INTO hat_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","-Si yon moun wè yon kote sou po kò l' anfle, ou ankò si li wè yon bouton osinon yon tach parèt sou po l' ki ta vle sanble konmansman yon move maladi po ki ka kontaminen lòt moun, y'a mennen l' bay Arawon, prèt la, ou ankò bay yonn nan pitit li yo ki prèt tou. ");
INSERT INTO hat_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Prèt la va egzaminen kote ki malad la. Si pwal yo vin tou blan, epi si maladi a fouye po a ti kras, l'a konnen se yon move maladi po ki ka kontaminen lòt moun. Lè prèt la va wè sa, l'a fè konnen moun lan pa nan kondisyon pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Men, si kote po a anfle a vin tou blan san li pa fouye, si pwal yo pa vin blan, prèt la va fèmen moun lan yon kote pou kont li pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sou setyèm jou a, prèt la va egzaminen l' ankò. Si li wè bouton an rete menm jan an, li pa laji sou po a, prèt la va fèmen moun lan pou kont li pou sèt jou ankò. ");
INSERT INTO hat_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Apre sa, prèt la va egzaminen l' ankò. Si bouton an cheche, si li pa laji kò l' sou po a, prèt la va fè konnen moun lan nan kondisyon pou l' fè sèvis Bondye. Se yon bouton ase li te genyen. Lè sa a, moun lan va lave rad li, epi l'ap nan kondisyon pou l' fè sèvis pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Men si bouton an vin pi laj sou po a, apre prèt la te fin di moun lan bon lè li te wè l' la, se pou moun lan parèt devan prèt la ankò. ");
INSERT INTO hat_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Prèt la va egzaminen l' ankò. Si li wè bouton an vin pi laj sou po a, prèt la va fè konnen moun lan pa nan kondisyon pou fè sèvis Bondye. Se yon move maladi po li genyen! ");
INSERT INTO hat_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Lè yon moun va gen yon move maladi po sou li, y'a mennen l' bay prèt la. ");
INSERT INTO hat_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Prèt la va egzaminen l'. Si li wè yon bouton blan sou po a ki fè pwal yo vin blan tou, si bouton an plen postim, ");
INSERT INTO hat_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","se va yon move maladi po ki chita sou li. Prèt la va fè konnen nonm lan pa nan kondisyon pou fè sèvis pou Bondye. Li p'ap bezwen fèmen l' yon kote pou kont li, paske se bagay ki klè, nonm lan pa nan kondisyon pou fè sèvis pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Men, si maladi a gaye sou tout kò l', si li kouvri ak bouton depi nan tèt jouk nan pye, kifè kote prèt la voye je l' li wè se bouton, ");
INSERT INTO hat_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","prèt la va egzaminen l' ankò. Si maladi a kouvri tout kò l', prèt la va di moun lan toujou nan kondisyon pou fè sèvis Bondye. Depi tout kò l' vin tou blan, li nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Men, jou yon bouton pete, li p'ap nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Prèt la va egzaminen l' ankò. Si li wè yon bouton pete, l'a fè konnen nonm lan pa nan kondisyon pou fè sèvis Bondye. Depi bouton an pete se yon move maladi po li genyen, nonm lan pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Men, lè bouton an va konmanse geri, po a konmanse vin blan ankò, moun lan va tounen al jwenn prèt la. ");
INSERT INTO hat_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Prèt la va egzaminen l' ankò. Si li wè bouton an vin tou blan, prèt la va fè konnen nonm lan nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Si yon moun gen yon apse ki geri, ");
INSERT INTO hat_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","men kote apse a te ye a vin anfle, ou ankò yon ti bouton wouj anba po a vin parèt, se pou l' al wè prèt la. ");
INSERT INTO hat_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Prèt la va egzaminen l'. Si bouton an gen lè yon ti jan pi fon pase rès po a, epi si pwal ki ladan l' yo vin tou blan, prèt la va fè konnen moun lan pa nan kondisyon pou fè sèvis Bondye. Se yon move maladi po k'ap parèt sou mak apse a. ");
INSERT INTO hat_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Men, lè prèt la egzaminen l', si li wè pwal ki ladan l' yo pa blan, si bouton an pa pi fon pase rès po a, si li konmanse chanje koulè, prèt la va fèmen moun lan yon kote pou kont li pou sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si bouton an gaye sou tout kò l', prèt la va fè konnen moun lan pa nan kondisyon pou fè sèvis Bondye. Se yon move maladi po li genyen. ");
INSERT INTO hat_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Men, si bouton an rete jan l' te ye a, y'a konnen se mak apse a ase li ye. Prèt la va fè konnen moun lan pa gen anyen, li toujou nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Ou ankò, lè yon moun boule nan dife, si lè li konmanse geri, po a vin yon ti jan wouj e blan, ");
INSERT INTO hat_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","prèt la va egzaminen l'. Si li wè pwal yo vin blan, epi si tach la gen lè pi fon pase rès po a, y'a konnen se yon move maladi po k'ap devlope sou boule a. Prèt la va fè konnen moun lan pa nan kondisyon pou fè sèvis Bondye. Se yon move maladi po li genyen. ");
INSERT INTO hat_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Men, si lè prèt la egzaminen l' li pa jwenn pwal blan ladan l', epi tach la pa pi fon pase rès po a, men li ta vle chanje koulè, prèt la va fèmen l' yon kote pou kont li pou sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sou setyèm jou a, prèt la va egzaminen l' ankò. Si li wè tach la ap gaye, l'a konnen se yon move maladi po li genyen. Lè sa a, prèt la va fè konnen moun lan pa nan kondisyon pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Men, si tach la rete jan l' te ye a, si li pa gaye sou po a, si se koulè a ase ki chanje, l'a konnen se mak boule a ase li ye. Prèt la va fè konnen moun lan toujou nan kondisyon pou fè sèvis Bondye, paske se boule a k'ap geri. ");
INSERT INTO hat_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Lè yon gason osinon yon fanm gen yon kote nan cheve l' osinon nan bab li ki fè yon plak, ");
INSERT INTO hat_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","prèt la va egzaminen plak la. Si li gen lè pi fon pase rès po a, si li gen cheve yon ti jan jòn, fin fen ladan l', l'a konnen se pyas moun lan genyen. Se yon move maladi po ki parèt nan cheve l' osinon nan bab li. Prèt la va fè konnen moun lan pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Men, lè prèt la egzaminen plak pyas la, si li wè gen lè li pa pi fon pase rès po a, epi cheve ki ladan l' yo yon ti jan jòn, prèt la va fèmen moun lan yon kote pou kont li pou sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sou setyèm jou a, prèt la va egzaminen malenng lan ankò. Si pyas la gaye, si cheve ki ladan l' yo pa vin jòn, si li gen lè pa pi fon pase rès po a, ");
INSERT INTO hat_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","moun lan va koupe tout cheve nan tèt li san l' pa manyen pyas la. Apre sa, prèt la va fèmen l' yon kote pou kont li pou sèt jou ankò. ");
INSERT INTO hat_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sou setyèm jou a, prèt la va egzaminen l' ankò. Si pyas la pa laji sou po a, si li pa fouye po a, prèt la va fè konnen moun lan nan kondisyon pou fè sèvis Bondye. Moun lan menm va lave rad sou li, epi l'a nan kondisyon pou fè sèvis Bondye ankò. ");
INSERT INTO hat_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Men, si apre prèt la te fin di moun lan nan bon kondisyon an, pyas la gaye tout bon vre sou po a, ");
INSERT INTO hat_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","prèt la va egzaminen l' ankò. Si pyas la gaye vre sou po a, li pa bezwen chache wè si li gen cheve jòn ankò. L'a tou konnen moun lan pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Men si li wè pyas la rete jan l' te ye a, epi cheve nwa ap pouse sou li, l'a tou konnen pyas la geri, epi prèt la va fè konnen moun lan nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Lè yon gason osinon yon fanm gen ti tach blan ki parèt sou po l', ");
INSERT INTO hat_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","prèt la va egzaminen l'. Si tach yo yon ti koulè blan sal, l'a konnen se yon ti gratèl ki parèt sou po a, moun lan toujou nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Lè yon nonm pèdi tout cheve nan tèt li, li chòv. Sa pa vle di li pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Konsa tou, lè yon moun pèdi cheve sou tout devan tèt li, li demi chòv. Sa pa vle di li pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Men, si kote l' chòv la yon ti tach koulè wouj-blan parèt, se ka yon move maladi po k'ap leve sou kò l'. ");
INSERT INTO hat_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Lè sa a, prèt la va egzaminen l'. Si plak la gen yon ti koulè wouj-blan tankou lè moun gen move maladi po sou kò yo, ");
INSERT INTO hat_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","l'a konnen se yon moun ki gen move maladi po. Prèt la va fè konnen moun lan pa nan kondisyon pou fè sèvis Bondye, akòz move maladi po ki parèt sou tèt li a. ");
INSERT INTO hat_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Lè yon moun gen yon move maladi po, l'a mete vye rad chire sou li. L'a kite tèt li san penyen, l'a kouvri figi l' depi anba nen l' desann, epi kote l' pase la pran rele: Men moun malad! Men moun malad! ");
INSERT INTO hat_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Pandan tout tan maladi a va sou li, li p'ap nan kondisyon pou fè sèvis Bondye. Se yon moun ki gen move maladi po li ye. L'a rete yon kote pou kont li, nan yon kay andeyò limit kote moun rete. ");
INSERT INTO hat_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Lè yon rad fèt an lenn nèt osinon an twal fen blan nèt bay mak tankou li ta vle kanni, ");
INSERT INTO hat_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ou ankò lè nan yon moso twal, fil dwat yo osinon fil travè yo, kit yo fèt an lenn ou ankò an kenaf, bay mak tankou yo ta vle kanni, ou ankò lè yon moso po osinon yon bagay fèt an po bay mak tankou li ta vle kanni, ");
INSERT INTO hat_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","si kote ki vle kanni an gen yon ti koulè vèt osinon wouj, sa vle di se kanni l'ap kanni. Se pou nou pote l' moutre prèt la. ");
INSERT INTO hat_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Prèt la va pran l', l'a egzaminen l' epi l'a fèmen bagay ki vle kanni an yon kote pou sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Sou setyèm jou a, prèt la va egzaminen l' ankò. Si li wè kanni an gaye sou twal la, osinon li mache nan fil dwat yo osinon nan fil travè yo, oswa sou po a, osinon sou bagay fèt ak po, sa vle di se kanni l'ap kanni vre. Moun k'ap sèvi Bondye pa ka sèvi avè l' ankò. ");
INSERT INTO hat_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Prèt la va boule bagay ki kanni an, paske se yon move maladi k'ap manje tout rad la. Se pou yo boule l' nan dife. ");
INSERT INTO hat_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Men, si lè prèt la egzaminen l', li jwenn kanni an pa gaye nan twal la osinon nan po a, ");
INSERT INTO hat_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","prèt la va bay lòd pou yo lave l'. Apre sa, l'a fèmen l' ankò yon kote pou sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sou setyèm jou a, l'a egzaminen l' ankò. Si li wè kote ki te vle kanni an rete menm jan an, menm si li pa gaye sou rès twal la, bagay la pa nan bon kondisyon, moun k'ap sèvi Bondye pa ka sèvi avè l'. Se pou yo boule l' nan dife, kanni an te mèt sou lanvè ou sou landrèt li. ");
INSERT INTO hat_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Men, si lè prèt la ap egzaminen l' dezyèm fwa a, li wè kanni an te pèdi koulè, fwa sa a, l'a chire kote ki te kanni nan twal la osinon nan po a. Ou ankò, l'a wete fil dwat ou fil travè ki te kanni nan twal la. ");
INSERT INTO hat_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Si apre sa, kanni an parèt ankò epi li konmanse gaye nan rès rad la, mèt rad la va boule l'. ");
INSERT INTO hat_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Si apre yo lave yon rad, kanni an disparèt, y'a lave l' yon dezyèm fwa. Se lè sa a rad la va nan bon kondisyon, moun k'ap sèvi Bondye ka sèvi avè l'. ");
INSERT INTO hat_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Men regleman pou nou swiv lè yon rad fèt an lenn osinon an twal fen blan bay mak tankou li ta vle kanni, ou ankò lè nan yon moso twal, fil dwat osinon fil travè yo, kit yo fèt an lenn ou ankò an kenaf, bay mak tankou li ta vle kanni, ou ankò lè yon moso po osinon nenpòt bagay ki fèt an po bay mak tankou li ta vle kanni. Se konsa n'a konnen si moun k'ap sèvi Bondye ka sèvi osinon pa ka sèvi ak yo. ");
INSERT INTO hat_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","-Men regleman w'a bay pou yo swiv lè y'ap fè sèvis pou moun ki geri apre yo te gen move maladi po. Jou pou yo rekonèt moun lan geri a, y'a mennen l' bay prèt la. ");
INSERT INTO hat_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Prèt la va pran l', l'a soti ansanm avè l' lòt bò limit kan kote moun rete a. L'a egzaminen l' byen egzaminen, pou l' wè si malad la geri vre. ");
INSERT INTO hat_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Prèt la va bay lòd pou yo pote pou moun ki te malad la de zwazo tou vivan epi ki bon pou moun k'ap fè sèvis pou Bondye, ansanm ak yon moso bwa sèd, yon moso twal kamwazi ak yon ti branch izòp. ");
INSERT INTO hat_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Apre sa, prèt la va bay lòd pou yo touye premye zwazo a anwo yon bòl an tè plen dlo fre. ");
INSERT INTO hat_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","L'a pran lòt zwazo a tou vivan ansanm ak bwa sèd la, moso twal kamwazi a ak ti branch izòp la, l'a plonje yo nan san zwazo yo te touye anwo dlo fre a. ");
INSERT INTO hat_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Apre sa, l'a voye san an sèt fwa sou moun ki te gen move maladi po a epi l'a di moun lan nan kondisyon ankò pou fè sèvis Bondye. L'a lage zwazo vivan an pou l' vole al fè wout li nan bwa. ");
INSERT INTO hat_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Moun ki te malad la va lave rad ki te sou li yo, l'a kale tèt li nèt, l'a benyen nan gwo dlo, epi l'a nan kondisyon pou fè sèvis Bondye ankò. Apre sa, l'a antre nan kan kote moun rete a, men li p'ap antre lakay li pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sou setyèm jou a, l'a kale tèt li ankò, l'a koupe tout bab li, tout plim je l' ak tout plim ki sou tout rès kò li. L'a lave rad ki te sou li a, l'a lave kò l' nan gwo dlo. Apre sa, l'a nan kondisyon pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sou wityèm jou a, l'a pran de ti belye ki pa gen ankenn enfimite ak yon ti fenmèl mouton ki gen ennan epi ki pa gen ankenn enfimite. L'a pran tou de mamit farin melanje ak lwil oliv epi yon boutèy demi lit plen lwil oliv. ");
INSERT INTO hat_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Prèt k'ap fè sèvis la va mennen moun lan ansanm ak ofrann li yo devan Seyè a, jouk nan papòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Rive la, prèt la va pran yonn nan ti belye yo, l'a ofri l' ansanm ak demi lit lwil la bay Seyè a pou peye pou sa moun lan te fè ki mal. L'a balanse yo devan Seyè a tankou yon ofrann espesyal pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","L'a touye ti mouton an kote yo konn touye bèt yo ofri pou mande padon an osinon pou boule nèt la, nan kote yo mete apa pou sèvis Bondye a. L'a fè sa konsa paske bèt moun yo ofri pou peye pou sa yo fè ki mal la osinon pou mande Bondye padon an, se pou prèt la li ye. Se yon ofrann yo mete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Apre sa, prèt la va pran ti gout nan san ti mouton an, l'a pase l' sou pwent tete zòrèy dwat moun ki te malad la, sou gwo pous men dwat li ak sou gwo zòtèy pye dwat li. ");
INSERT INTO hat_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Prèt la va pran ti gout lwil nan boutèy la, l'a vide l' nan pla men gòch li. ");
INSERT INTO hat_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","L'a tranpe yon dwèt men dwat li nan lwil ki nan pla men gòch li a. Avèk dwèt la, l'a voye ti gout lwil sèt fwa devan lotèl Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","L'a pran ti gout nan lwil ki nan pla men gòch li a, l'a mete l' menm kote li te mete san ti mouton an, ki vle di sou pwent tete zòrèy dwat moun lan, sou gwo pous men dwat li ak sou gwo zòtèy pye dwat li. ");
INSERT INTO hat_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Lèfini, l'a vide rès lwil ki nan pla men l' lan sou tèt moun lan. Se konsa prèt la va fè sèvis pou mande Bondye padon devan lotèl Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Apre sa, prèt la va fè ofrann pou peye sa moun lan fè ki mal. L'a fè sèvis pou mande Bondye padon pou moun ki te malad la. L'a touye bèt pou yo boule nèt la. ");
INSERT INTO hat_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","L'a mete l' sou lotèl la ansanm ak farin ble melanje ak lwil la. Se konsa prèt la va fè sèvis pou mande padon pou moun lan, epi moun lan va nan kondisyon ankò pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Si moun lan pòv epi li pa gen anpil mwayen, l'a pote yon sèl ti mouton pou yo ofri pou peye pou sa moun lan te fè ki mal la. L'a pote twaka mamit farin sèlman melanje ak lwil oliv ak yon boutèy demi lit plen lwil. ");
INSERT INTO hat_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","L'a pote de ti toutrèl tou osinon de ti pijon, jan mwayen li va penmèt li, yonn pou sèvi ofrann pou mande padon, lòt la pou boule nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Sou wityèm jou a, l'a pote yo bay prèt la devan pòt Tant Randevou a, pou prèt la fè sèvis pou mete l' nan kondisyon pou li ka sèvi Seyè a ankò. ");
INSERT INTO hat_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Prèt la va pran ti mouton li ofri pou peye pou sa moun lan fè ki mal la ansanm ak boutèy lwil la, l'a balanse yo devan Seyè a tankou yon ofrann. ");
INSERT INTO hat_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Apre sa, l'a touye ti mouton an, l'a pran ti gout nan san li l'a mete sou pwent tete zòrèy dwat moun ki te malad la, sou gwo pous men dwat li ak sou gwo zòtèy pye dwat li. ");
INSERT INTO hat_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Prèt la va vide ti gout lwil nan pla men gòch li, ");
INSERT INTO hat_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","l'a tranpe yon dwèt men dwat li nan lwil ki nan pla men gòch li a. Avèk dwèt la, l'a voye lwil la sèt fwa devan lotèl Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Apre sa, l'a pran nan lwil ki nan men gòch li a, l'a mete l' menm kote li te mete san ti mouton an, ki vle di sou pwent tete zòrèy dwat moun lan, sou gwo pous men dwat li a ak sou gwo zòtèy pye dwat li a. ");
INSERT INTO hat_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Lèfini, l'a vide rès lwil ki nan pla men gòch li a sou tèt moun lan. Se konsa l'a fè sèvis pou mande Bondye padon devan lotèl Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Apre sa, l'a ofri toutrèl yo, osinon pijon yo, dapre sa mwayen moun lan te penmèt li, ");
INSERT INTO hat_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","yonn pou mande padon pou peche, lòt la pou yo boule nèt ansanm ak ofrann farin ble a. Se konsa prèt la va fè sèvis pou mande Bondye padon pou moun lan. ");
INSERT INTO hat_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Men regleman pou yo swiv lè yon moun ki gen move maladi po pa gen dekwa pou l' ofri tou sa li te dwe ofri pou sèvis ki pou mete l' nan kondisyon pou fè sèvis Bondye ankò. ");
INSERT INTO hat_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo: ");
INSERT INTO hat_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","-Lè n'a fin antre nan peyi Kanaran an, peyi m'ap ban nou pou rele nou pa nou an, si mwen voye salpèt sou yonn nan kay kote nou rete yo, men sa pou nou fè. ");
INSERT INTO hat_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Mèt kay la va al jwenn prèt la, l'a di l': Gen yon bagay tankou salpèt ki parèt sou miray kay mwen an. ");
INSERT INTO hat_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Prèt la va bay lòd pou yo mete tou sa ki nan kay la deyò anvan li vin egzaminen kay la. Konsa, tou sa ki te nan kay la ka toujou sèvi pou moun k'ap sèvi Bondye. Apre sa, prèt la va vini, l'a antre nan kay la pou egzaminen l'. ");
INSERT INTO hat_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","L'a egzaminen tout miray yo. Si li wè gen kèk kote ki manje nan miray la, epi ki gen ti koulè vèt osinon wouj, ");
INSERT INTO hat_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","prèt la va soti nan kay la, l'a fèmen l' akle pou sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sou setyèm jou a, prèt la va tounen, l'a egzaminen miray kay la ankò. Si li wè tach la gaye sou miray kay la, ");
INSERT INTO hat_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","prèt la va bay lòd pou yo wete wòch kote yo te jwenn salpèt la, y'a voye wòch yo jete yon kote andeyò lavil la, kote yo mete bagay ki pa ka sèvi pou sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Apre sa, l'a fè yo grate tout anndan kay la, epi y'a jete tout vye kras mòtye yo te grate a andeyò lavil la, menm kote yo mete bagay ki pa ka sèvi nan sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Y'a pran lòt wòch ranplase wòch yo te wete yo epi y'a rekrepi kay la. ");
INSERT INTO hat_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Si salpèt la parèt ankò apre yo fin wete wòch malad yo, apre yo fin grate kay la epi yo rekrepi l', ");
INSERT INTO hat_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","prèt la va tounen vin gade. Si li wè salpèt la gaye nan kay la, la konnen kay la gen yon move maladi sou miray li. Moun k'ap sèvi Bondye pa ka rete ladan l'. ");
INSERT INTO hat_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Lè sa a, y'a demoli kay la nèt epi y'a pran wòch, bwa, mòtye ki te nan kay la, y'a voye yo jete andeyò lavil la, kote yo mete bagay ki pa ka sèvi pou sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Tout moun ki te antre anndan kay la lè kay la te fèmen an p'ap nan kondisyon pou sèvi Bondye jouk aswè rive. ");
INSERT INTO hat_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Tout moun ki te kouche osinon ki te manje anndan kay la va gen pou lave rad ki te sou yo. ");
INSERT INTO hat_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Lè prèt la vin gade a, si li te jwenn salpèt la disparèt nèt apre yo te fin rekrepi kay la, prèt la va fè konnen kay la nan bon kondisyon ankò pou moun k'ap sèvi Bondye ka rete ladan l', paske salpèt la disparèt nèt. ");
INSERT INTO hat_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Apre sa, prèt la va fè sèvis pou wete peche nan kay la. L'a pran de zwazo, kèk moso bwa sèd, yon moso twal kamwazi ak yon ti branch izòp. ");
INSERT INTO hat_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","L'a touye yonn nan ti zwazo yo anwo yon bòl an tè plen dlo fre. ");
INSERT INTO hat_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Apre sa, l'a pran bwa sèd la, ti branch izòp la, moso twal kamwazi a ansanm ak lòt zwazo ki vivan an, l'a plonje yo nan san premye zwazo a ki melanje ak dlo fre a. Apre sa, l'a voye san an sèt fwa sou kay la. ");
INSERT INTO hat_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Se konsa prèt la va fè sèvis pou wete peche nan kay la, avèk san zwazo a, dlo fre a, zwazo vivan an, bwa sèd la, ti branch izòp la, epi moso twal kamwazi a. ");
INSERT INTO hat_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Apre sa, l'a lage ti zwazo vivan an pou l' vole al fè wout li nan bwa andeyò lavil la. Se konsa l'a fè sèvis pou mande Bondye padon pou kay la epi kay la va nan bon kondisyon pou moun k'ap sèvi Bondye ka rete ladan l' ankò. ");
INSERT INTO hat_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Men regleman pou nou swiv lè yon moun gen move maladi po osinon pyas, ");
INSERT INTO hat_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","lè kanni tonbe sou rad osinon lè salpèt parèt nan yon kay, ");
INSERT INTO hat_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","lè yon moun gen yon kote sou po l' ki anfle osinon lè li gen yon bouton ou ankò yon tach ki parèt sou po l'. ");
INSERT INTO hat_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Se konsa n'a konnen lè yon bagay nan bon kondisyon osinon lè li pa nan bon kondisyon pou moun k'ap sèvi Bondye. Se tout regleman yo sa pou move maladi po. ");
INSERT INTO hat_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","-Pale ak pèp Izrayèl la, di yo pou mwen: Lè yon nonm gen ekoulman, li pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Kit ekoulman an ap koule, kit li bloke ti pati li, nonm lan pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Moun k'ap sèvi Bondye pa ka sèvi ak kabann kote moun malad la kouche ni ak bagay kote l' te chita. ");
INSERT INTO hat_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Tout moun ki manyen kabann lan gen pou lave rad ki sou yo, yo gen pou yo benyen nan gwo dlo, epi yo p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Konsa tou, tout moun ki chita sou bagay kote li te chita gen pou lave rad ki sou yo, pou yo benyen nan gwo dlo epi yo p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Tout moun ki manyen yon moun ki gen ekoulman gen pou yo lave rad ki sou yo, pou yo benyen nan gwo dlo epi yo p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Si nonm malad la krache sou yon moun ki te nan kondisyon pou fè sèvis Bondye, moun sa a gen pou l' lave rad ki te sou li a, li gen pou l' benyen nan gwo dlo epi li p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Si nonm malad la moute sou yon sèl chwal, moun ki nan kondisyon pou fè sèvis Bondye pa ka sèvi avèk sèl la. ");
INSERT INTO hat_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Tout moun ki manyen nenpòt bagay kote nonm lan te chita a p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. Tout moun ki va pran nenpòt bagay kote nonm lan te chita a pou yo pote l' ak men yo, yo gen pou lave rad sou yo, pou yo benyen nan gwo dlo epi yo p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Si yon nonm ki gen ekoulman manyen yon moun san li pa lave men l' anvan, moun sa a gen pou lave rad ki sou li, li gen pou l' benyen nan gwo dlo epi li p'ap nan kondisyon pou l' fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Depi nonm malad la manyen yon veso fèt an tè, se pou yo kraze veso a. Men, si veso a fèt an bwa, y'a lave l' nan gwo dlo. ");
INSERT INTO hat_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Apre nonm ki te gen ekoulman an fin geri, li gen pou l' tann sèt jou anvan li fè sèvis ki pou mete l' nan kondisyon pou fè sèvis Bondye. Lè sa a, l'a lave rad ki sou li, l'a benyen nan dlo dous. Se konsa l'a vin nan kondisyon pou fè sèvis Bondye ankò. ");
INSERT INTO hat_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sou wityèm jou a, l'a pran de toutrèl osinon de pijon, l'a pote yo bay prèt la devan pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Prèt la va ofri yonn ladan yo pou wete peche li yo, lòt la pou yo boule nèt pou Seyè a. Se konsa l'a fè sèvis pou mande Bondye padon pou ekoulman nonm lan te genyen an. ");
INSERT INTO hat_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Lè yon nonm voye sou li, se pou li lave tout kò l' nan dlo epi li p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Depi dechay la tonbe sou yon bagay fèt an twal osinon an po, se pou yo lave bagay sa yo, epi moun ki nan kondisyon pou fè sèvis Bondye p'ap ka sèvi ak bagay sa yo jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Lè yon nonm kouche ak yon fanm epi li voye anndan l', tou de gen pou benyen nan gwo dlo, epi yo p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Lè yon fanm gen règ li, li p'ap nan kondisyon pou fè sèvis Bondye pandan sèt jou. Tout moun ki manyen l' pandan sèt jou sa yo p'ap nan kondisyon tou pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Lè konsa, moun k'ap sèvi Bondye pa ka sèvi ak kabann kote l' kouche ni ak bagay li te sèvi pou l' chita. ");
INSERT INTO hat_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Lè yon moun manyen kabann yon fanm konsa, li gen pou l' lave rad ki sou li, l'a benyen nan gwo dlo, epi li p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Si yon moun manyen yon bagay fanm lan te sèvi pou l' chita, li gen pou l' lave rad ki sou li, l'a benyen nan gwo dlo epi li p'ap nan kondisyon pou l' fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Wi, depi se kabann fanm lan osinon yon bagay fanm lan sèvi pou l' chita yon moun manyen, moun sa a p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Si yon nonm kouche ak yon fanm ki gen règ li epi li sal ak san, li p'ap nan kondisyon pou l' fè sèvis Bondye pandan sèt jou. Depi li kouche sou yon kabann, moun k'ap sèvi Bondye p'ap ka sèvi ak kabann sa a. ");
INSERT INTO hat_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Si yon fanm gen règ li pandan plizyè jou lè li pa nan peryòd li, osinon si règ li kontinye koule kèk jou apre peryòd li pase, se va menm jan an tou. Li p'ap nan kondisyon pou l' fè sèvis Bondye pandan tout jou san an ap koule a, tankou lè l' gen règ li nòmal. ");
INSERT INTO hat_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Lè sa a, moun k'ap sèvi Bondye pa ka sèvi ni ak kabann kote l' kouche ni ak bagay li sèvi pou l' chita. ");
INSERT INTO hat_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Si yon moun manyen yonn nan bagay sa yo, li p'ap nan kondisyon pou l' fè sèvis Bondye, l'a gen pou l' lave rad ki sou li, pou l' benyen nan gwo dlo epi li p'ap nan kondisyon pou l' fè sèvis Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Lè san an va sispann koule, fanm lan va tann sèt jou. Se apre sa l'a nan kondisyon pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Sou wityèm jou a, l'a pran de toutrèl osinon de pijon, l'a pote yo bay prèt la devan pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Prèt la va ofri yonn ladan yo pou wete peche li yo, l'a ofri lòt la pou boule nèt pou Bondye. Se konsa l'a fè sèvis pou mande Bondye padon pou fanm lan, paske règ la te mete l' nan kondisyon li pa t' ka fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Seyè a di Moyiz ankò: -Pale moun Izrayèl yo byen. Lè yo pa nan kondisyon pou fè sèvis Bondye, piga yo pwoche bò Tant Randevou a ki nan mitan kan kote yo rete a. Si yo fè sa y'a mouri. ");
INSERT INTO hat_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Men regleman pou yo swiv lè yon nonm pa ka fè sèvis Bondye paske li gen ekoulman osinon paske li voye sou li, ");
INSERT INTO hat_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","lè yon fanm gen règ li, osinon lè yon nonm kouche ak yon fanm ki pa nan kondisyon pou fè sèvis Bondye, wi pou tout moun, fanm kou gason, ki gen ekoulman. ");
INSERT INTO hat_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Seyè a pale ak Moyiz apre lanmò de pitit gason Arawon yo ki te mouri lè yo te ofri yon dife ki pa t' bon bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Seyè a di Moyiz konsa: -Pale ak Arawon, frè ou la, pou l' pa antre nenpòt kilè, nenpòt ki jan dèyè rido a nan kote ki apa pou mwen an, devan kouvèti espesyal ki sou Bwat Kontra a. Paske se la, sou kouvèti ki sou bwat kontra a, mwen parèt nan yon nwaj. Si li pa swiv lòd sa a, li ka mouri. ");
INSERT INTO hat_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Lè l'ap antre nan kote ki apa nèt pou Bondye a, li gen pou l' pote yon jenn ti towo ak yon belye. Ti towo a va sèvi pou mande Bondye padon, epi y'a boule belye a nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Men ki jan pou Arawon abiye lè l'ap antre nan kay Bondye a. L'a mete rad seremoni pou prèt yo mete lè y'ap fè sèvis pou Bondye. L'a mete chemiz twal fen blan an ak kalson twal fen blan an, l'a mare sentiwon twal fen blan an nan ren l' ak mouchwa tèt twal fen blan an nan tèt li. L'a lave kò l' nan gwo dlo anvan la mete yo sou li. ");
INSERT INTO hat_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Moun pèp Izrayèl yo va bay Arawon de bouk kabrit ak yon belye. Bouk kabrit yo va sèvi ofrann pou mande Bondye fè gras. Belye a menm, y'a boule l' nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Arawon va ofri ti towo bèf la pou yo touye l' pou wete peche l' yo ak peche fanmi l' yo. Se konsa l'a fè sèvis pou mande Bondye padon an pou li ak pou fanmi l'. ");
INSERT INTO hat_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Apre sa, l'a pran de bouk kabrit yo, l'a mennen yo devan pòt Tant Randevou a. L'a prezante yo devan lotèl Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Apre sa, l'a tire osò ak de ti wòch, yonn make: Pou Seyè a, lòt la: Pou Azazèl. ");
INSERT INTO hat_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Arawon va touye bouk kabrit ki soti pou Seyè a, l'a ofri l' pou wete peche. ");
INSERT INTO hat_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Men, l'a pran bouk kabrit ki soti pou Azazèl la, y'a prezante l' tou vivan devan Seyè a. Apre sa, lè y'a fin fè sèvis sou li pou wete peche pou pèp la, y'a lage l' nan dezè a pou l al jwenn Azazèl. ");
INSERT INTO hat_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Lèfini, Arawon va touye ti towo bèf li te ofri pou wete peche pa l' yo. L'a fè sèvis pou mande Bondye padon pou peche pa l' yo ansanm ak peche fanmi l' yo. ");
INSERT INTO hat_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Apre sa, l'a pran yon recho, l'a plen l' chabon dife tou limen la jwenn sou lotèl la, l'a pran de ponyen lansan santi bon an poud. L'a pote recho a ak lansan an antre nan kote ki apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Rive la, devan lotèl Seyè a, l'a mete lansan an sou dife a, lafimen lansan an va kouvri kouvèti Bwat Kontra a nèt. Konsa, li p'ap ka wè l', li p'ap mouri. ");
INSERT INTO hat_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","L'a tranpe dwèt li nan san ti towo bèf la, l'a voye san an sou bò devan kouvèti Bwat Kontra a, sou bò solèy leve. Apre sa, l'a voye san an sèt fwa devan kouvèti a avèk dwèt li. ");
INSERT INTO hat_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Se lè sa a l'a touye kabrit pou wete peche pèp la. L'a pran san an, l'a pote l' anndan kote ki apa nèt pou Seyè a, l'a voye l' sou kouvèti a ak devan kouvèti a, menm jan li te fè pou san ti towo bèf la. ");
INSERT INTO hat_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Se konsa, poutèt tout peche ak tout mechanste pèp la fè yo, epi poutèt moun nan pèp la ki pa nan kondisyon pou fè sèvis Bondye, Arawon va fè sèvis pou mande Bondye fè gras pou kote ki apa nèt pou li a. L'a fè sa tou pou Tant Randevou a, paske tant lan kanpe nan mitan pèp la ak tout moun nan pèp la ki pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Depi Arawon antre nan kote ki apa nèt pou Seyè a pou l' fè sèvis pou mande padon an jouk lè li soti, lòt moun pa gen dwa anndan tant Randevou a. L'a fè sèvis la pou li menm, pou fanmi l' ak pou tout moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Lèfini, l'a soti, l'a ale bò kote lotèl pou boule ofrann lan, l'a fè sèvis pou wete peche pou li tou. Epi, l'a pran nan san ti towo bèf la ak nan san bouk kabrit la, l'a mete sou kat kòn ki sou kat kwen lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Lèfini, avèk dwèt li, l'a voye san an sèt fwa sou lotèl la. Se konsa, poutèt moun nan pèp Izrayèl la ki pa nan kondisyon pou fè sèvis pou Bondye, l'a fè sèvis pou mete lotèl la nan kondisyon pou fè sèvis Bondye, l'a mete l' apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Lè Arawon va fin fè sèvis pou wete peche pou kote ki apa nèt pou Bondye a, pou Tant Randevou a ak pou lotèl la, l'a fè yo pwoche bouk kabrit vivan yo te chwazi pou Azazèl la devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","L'a mete tou de men l' yo sou tèt kabrit la, l'a rekonèt sou li tout peche, tout mechanste ak tout movezak pèp Izrayèl la te fè. Se konsa l'a mete tout peche sa yo sou tèt kabrit la. Lèfini, l'a fè moun ki chwazi pou sa a mennen kabrit la al lage l' nan dezè a. ");
INSERT INTO hat_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Bouk la va pote tout peche yo ale sou li yon zòn kote pa gen moun rete la. ");
INSERT INTO hat_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Apre sa, Arawon va antre ankò nan Tant Randevou a. L'a wete rad fen blan li te mete sou li pou li te ka antre nan kote ki apa nèt pou Seyè a, l'a kite yo la. ");
INSERT INTO hat_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","L'a pran yon bon beny nan kote yo mete apa pou sa a, l'a mete lòt rad sou li. Apre sa, l'a soti, l'a ofri bèt pou yo boule nèt yo pou peche pa l' yo ak pou tout peche pèp la. L'a fè sèvis pou mande Bondye padon. ");
INSERT INTO hat_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","L'a pran grès bèt yo te ofri pou peche a, l'a boule yo sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Nonm ki te al lage bouk kabrit la pou Azazèl nan dezè a gen pou l' lave tout rad ki sou li, epi pou l' pran yon bon beny nan gwo dlo, anvan li tounen nan kan kote moun yo rete a. ");
INSERT INTO hat_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Y'a pran towo bèf ak kabrit yo te touye pou wete peche a, y'a pote yo ale andeyò limit kan kote moun yo rete a, epi y'a boule po vyann yo ansanm ak tout tripay yo nèt. Se san bèt sa yo yo te pote nan kote ki apa nèt pou Seyè a pou fè sèvis pou mande padon pou peche. ");
INSERT INTO hat_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Moun ki te al boule yo a va gen pou l' lave rad li tou, pou l' benyen nèt nan gwo dlo anvan li tounen nan kan kote moun yo rete a. ");
INSERT INTO hat_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Men regleman pou nou fè tout tan tout tan jouk sa kaba. Sou dizyèm jou nan setyèm mwa a, tout moun pèp Izrayèl yo ansanm ak tout moun lòt nasyon k'ap viv nan mitan nou yo va fè jèn, yo p'ap fè ankenn travay jou sa a. ");
INSERT INTO hat_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Paske, jou sa a y'a fè sèvis pou wete yo anba tout peche yo, pou yo ka parèt nan bon kondisyon devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Jou sa a va yon jou espesyal pou nou fè jèn, yon jou pou nou pa travay menm. Se lòd mwen ban nou, se pou nou toujou fè sèvis sa a. ");
INSERT INTO hat_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Se va reskonsablite granprèt yo va mete apa pou fè sèvis Seyè a nan plas papa l' la pou li fè sèvis pou mande Bondye padon, l'a mete rad fen blan yo, rad pou prèt yo mete lè y'ap fè sèvis. ");
INSERT INTO hat_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","L'a fè sèvis pou wete peche pou kote ki apa nèt pou Bondye a, pou Tant Randevou a ak pou lotèl la, l'a fè ofrann pou prèt yo ak pou tout pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Men regleman pou nou swiv tout tan tout tan. Se yon sèvis pou yo fè yon fwa chak lanne pou mande padon pou peche pèp Izrayèl la. Yo te fè tout bagay jan Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","-Pale ak Arawon ak pitit gason l' yo epi ak tout moun pèp Izrayèl yo. W'a di yo: Men bagay Seyè a bay lòd pou nou fè: ");
INSERT INTO hat_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Si yonn nan moun Izrayèl yo touye yon towo bèf, yon mouton osinon yon kabrit nan kan kote yo rete a, ou ankò lòt bò limit kan an, ");
INSERT INTO hat_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","depi se pa devan pòt Tant Randevou a li touye l' pou l' ofri l' bay Seyè a la devan kay Seyè a, moun sa a koupab, li fè yon krim, li fè san koule. Se pou yo wete l' nèt nan mitan moun pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Sa vle di: Depi koulye a moun pèp Izrayèl yo gen pou mennen devan Seyè a tout bèt yo te konn touye nan jaden. Se pou yo mennen yo bay prèt la devan pòt Tant Randevou a. Se la y'a touye yo, menm jan yo touye bèt y'ap ofri pou di Bondye mèsi. ");
INSERT INTO hat_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Prèt la va pran san an, l'a vide l' sou lotèl la, devan pòt Tant Randevou a. L'a boule grès la pou l' fè yon bon sant ki va fè Seyè a plezi. ");
INSERT INTO hat_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Se pou moun pèp Izrayèl yo sispann ofri bèt pou yo touye bay zidòl nan jaden tankou yo te konn fè lè yo te vire do bay Bondye a. Se pou pèp la toujou kenbe lòd sa a de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Epi w'a di yo ankò: Ankenn moun nan pèp Izrayèl la, ni moun lòt nasyon k'ap viv nan mitan yo pa gen dwa touye bèt yo ofri ni pou yo boule nèt ni pou lòt kalite sèvis ");
INSERT INTO hat_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ankenn lòt kote, si se pa devan pòt Tant Randevou a pou li ofri l' bay Seyè a. Si se pa sa, y'a wete l' nèt nan mitan moun pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Pesonn ni nan pèp Izrayèl la, ni pami moun lòt nasyon k'ap viv nan mitan yo pa gen dwa manje vyann ak tout san li ladan l'. Si li fè l', mwen menm Seyè a, mwen p'ap okipe l' ankò, m'ap wete l' nan mitan pèp mwen an. ");
INSERT INTO hat_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Nanm tout bèt vivan se nan san an li ye. Se poutèt sa, mwen menm Seyè a, mwen mande pou yo vide tout san an sou lotèl la pou li ka wete peche pèp la. Nou bay san an pou nanm nou. ");
INSERT INTO hat_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Se poutèt sa Seyè a te di moun pèp Izrayèl yo: Pesonn nan pèp Izrayèl la, ni ankenn moun lòt nasyon k'ap viv nan mitan nou pa gen dwa manje vyann ki gen san ladan l'. ");
INSERT INTO hat_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Lè yon moun nan pèp Izrayèl la osinon yon moun lòt nasyon k'ap viv nan mitan yo al lachas, si li pran yon bèt osinon yon zwazo yo gen dwa manje, l'a vide tout san bèt la atè epi la kouvri l' ak tè. ");
INSERT INTO hat_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Paske nanm tout bèt vivan se nan san an li ye. Se poutèt sa mwen menm, Seyè a, mwen di moun pèp Izrayèl yo: Yo pa gen dwa manje vyann ankenn bèt ak tout san an ladan l'. Paske se nan san an nanm lan ye. Tout moun ki manje vyann ak san li ladan l', m'ap wete yo nan mitan pèp mwen an. ");
INSERT INTO hat_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Mwen pa bezwen konnen si se moun pèp Izrayèl la osinon moun lòt nasyon k'ap viv nan mitan nou, depi yon moun manje vyann yon bèt mouri osinon vyann bèt yon lòt bèt nan bwa ta touye, l'a gen pou l' lave rad ki sou li, l'a benyen nan gwo dlo, epi li p'ap nan kondisyon pou fè sèvis Bondye jouk aswè. Se aprè sa l'a nan kondisyon pou fè sèvis Bondye ankò. ");
INSERT INTO hat_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Men, si li pa lave rad ki sou li yo, si li pa benyen nèt, l'a peye sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","-Pale ak moun pèp Izrayèl yo, w'a di yo: Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Piga nou janm fè menm jan ak moun peyi Lejip kote nou te ye a, ni tankou moun peyi Kanaran kote mwen pral mennen nou an. Piga nou swiv mès yo. ");
INSERT INTO hat_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Se pou nou swiv lòd mwen ban nou. Se pou nou fè sa mwen di nou fè. Se pou nou mache dapre prensip mwen ban nou. Se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Se pou nou swiv regleman ak lòd mwen ban nou yo. Gremesi sa m' di nou fè a, tout moun ki koute m' va jwenn lavi. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Apre sa, Seyè a bay regleman sa yo: -Piga pesonn kouche yon fanm ki fanmi pre l'. Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Piga ou jete dezonè sou papa ou pou ou kouche madanm li, se manman ou li ye. Pa jete dezonè sou manman ou. ");
INSERT INTO hat_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Piga ou jete dezonè sou papa ou pou ou kouche yonn nan fanm kay papa ou yo. ");
INSERT INTO hat_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Piga ou kouche sè ou, li te mèt menm papa osinon menm manman avè ou, kit li te elve nan menm kay avè ou, kit li te elve lòt kote. Piga ou kouche l'. ");
INSERT INTO hat_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Piga ou kouche pitit fi pitit gason ou osinon pitit fi pitit fi ou. Se va sou pwòp tèt ou w'a jete dezonè. ");
INSERT INTO hat_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Piga ou kouche pitit fi madanm papa ou. Se pou ou konsidere l' tankou pwòp sè ou. ");
INSERT INTO hat_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Piga ou kouche matant ou, kit se matant bò papa, ");
INSERT INTO hat_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","kit se bò manman. ");
INSERT INTO hat_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Piga ou kouche madanm tonton ou bò papa. Se pou ou konsidere l' tankou matant ou. ");
INSERT INTO hat_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Piga ou kouche bèlfi ou: se madanm pitit gason ou li ye. Pa jete dezonè sou li. ");
INSERT INTO hat_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Piga ou kouche madanm frè ou. Pa jete dezonè sou frè ou. ");
INSERT INTO hat_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Piga ou kouche pitit fi osinon pitit pitit fi yon madanm ki te nan afè avè ou deja. Pa kouche yo. Se tankou si se te fanmi pre ou yo te ye. Si ou fè sa, se va yon wont! ");
INSERT INTO hat_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Piga ou pran yonn nan sè madanm ou pou yonn nan pwòp madanm ou yo toutotan madanm ou vivan. Sa ka mete yon jalouzi nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Piga ou kouche yon fanm ki gen règ li, paske lè sa a li pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Piga ou kouche madanm yon frè parèy ou, paske lè nou fè sa, ni ou ni fanm lan, nou pa nan kondisyon pou fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Piga ou janm bay yonn nan pitit fi ou yo tankou ofrann pou yo boule bay zidòl yo rele Molòk la, paske lè sa a w'a fè yo derespekte non Bondye. Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Piga yon gason kouche yon lòt gason tankou yo kouche yon fanm: Se bagay Bondye pi pa vle wè. ");
INSERT INTO hat_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Ni fanm ni gason pa gen dwa kwaze ak zannimo. Se bagay k'ap mete yo nan kondisyon pou yo pa ka fè sèvis Bondye. Se bagay sal nèt. ");
INSERT INTO hat_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Piga nou janm fè bagay sa yo k'ap mete nou nan kondisyon pou nou pa ka fè sèvis Bondye. Se bagay konsa pèp lòt nasyon ki t'ap viv nan peyi a anvan nou yo te konn fè. Se poutèt sa Seyè a ap mete yo deyò pou nou ka pran plas yo. ");
INSERT INTO hat_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Yo te mete tout peyi a nan move kondisyon ak sa yo t'ap fè a. Se konsa mwen menm Seyè a, m'ap peni peyi a, m'ap fè l' voye moun ki rete sou li yo jete deyò. ");
INSERT INTO hat_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Men nou menm, se pou nou kenbe tout lòd ak tout kòmandman mwen ban nou yo. Piga pesonn ni nan nou, ni nan moun lòt nasyon k'ap viv nan mitan nou yo fè ankenn nan bagay mwen pa vle wè yo. ");
INSERT INTO hat_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Se paske moun ki te rete nan peyi a anvan nou yo te fè tout kalite bagay sa yo, kifè yo te mete peyi a nan move kondisyon sa a. ");
INSERT INTO hat_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Konsa tou, si nou mete peyi a nan move kondisyon, peyi a pral voye nou jete deyò menm jan li te fè l' pou pèp ki te la anvan nou yo. ");
INSERT INTO hat_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Depi yon moun fè yonn nan bagay sal sa yo, y'ap wete l' nan mitan pèp Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Epi Seyè a di: -Se pou nou kenbe lòd mwen yo. Pa swiv move mès moun ki te rete nan peyi a anvan nou yo. Pa fè vye bagay sa yo k'ap mete nou nan kondisyon pou nou pa ka fè sèvis Bondye. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","-Pale ak tout moun ki fè pati pèp Izrayèl la. W'a di yo: Se pou nou viv apa pou mwen paske mwen menm, Seyè a, Bondye nou an, mwen se yon Bondye apa. ");
INSERT INTO hat_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Se pou nou tout respekte manman ak papa nou. Se pou nou respekte regleman jou repo mwen yo. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Pa janm vire do ban mwen pou n' al sèvi zidòl. Piga nou janm fonn metal pou fè estati ki pou sèvi nou bondye. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Lè n'ap touye bèt pou fè ofrann pou di Seyè a mèsi, se pou nou fè l' jan mwen mande l' la pou m' ka asepte l' nan men nou. ");
INSERT INTO hat_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Se pou nou manje vyann bèt yo ofri ban mwen an menm jou a, osinon nan denmen. Men, sou twazyèm jou a, tout sa ki rete nan vyann lan, se pou nou boule l'. ");
INSERT INTO hat_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Paske si nou manje l' sou twazyèm jou a, se yon manje gate li ye! Seyè a p'ap asepte l' nan men nou. ");
INSERT INTO hat_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Se poutèt sa, tout moun ki va manje yon vyann konsa va gen pou peye pou sa l' fè a, paske li pa respekte bagay yo te mete apa pou mwen. Moun konsa se pou nou wete yo nan mitan pèp mwen an. ");
INSERT INTO hat_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Lè n'ap ranmase rekòt nan jaden nou, se pa pou nou ranmase sa ki toupre lizyè jaden an, ni nou pa bezwen tounen dèyè pou nou ranmase ti grenn ki te tonbe atè. ");
INSERT INTO hat_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Nou pa bezwen tounen nan jaden rezen an pou nou ranmase dènye ti grap rezen yo te bliye, osinon pou nou ranmase ti grenn rezen ki te tonbe atè. N'a kite sa pou moun peyi a ki pa gen anyen, ak pou moun lòt nasyon k'ap viv nan mitan nou yo. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Piga nou pran sa ki pa pou nou. Piga nou yonn twonpe lòt. Piga nou bay frè parèy nou manti. ");
INSERT INTO hat_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Piga nou pran non m' pou fè sèman pou twonpe moun. Si nou fè sa, se derespekte n'ap derespekte non Bondye nou an. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Piga nou pwofite sou moun menm ras ak nou. Lè lè pou nou peye moun ki travay pou nou an rive, peye l' lajan l'. Piga nou voye l' pou denmen maten. ");
INSERT INTO hat_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Piga ou madichonnen moun soud. Piga ou mete ankenn bagay sou chemen moun avèg pou fè yo tonbe. Se pou nou gen krentif pou mwen. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Piga nou fè lenjistis lè nou nan tribinal. Piga nou fè patipri pou pòv. Piga nou achte figi grannèg. N'a rann jistis pou tout frè parèy nou san fè paspouki. ");
INSERT INTO hat_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Pa mache bay manti sou moun menm ras avèk nou. Piga nou kanpe pou fè yo touye san rezon yon moun menm ras avèk nou. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Piga nou kenbe frè nou nan kè. Si yo gen kichòy avèk nou, regle sa la pou la. Konsa, yo p'ap lakòz nou tonbe nan peche. ");
INSERT INTO hat_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Piga nou tire revanj sou pesonn. Piga nou kenbe moun menm ras ak nou nan kè, men se pou nou renmen yo tankou nou renmen pwòp tèt pa nou. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Se pou nou kenbe lòd mwen ban nou yo. Piga nou kwaze de zannimo ki pa menm kalite. Piga nou plante de kalite plant anmenmtan nan jaden nou. Piga nou mete sou nou rad depaman. ");
INSERT INTO hat_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Lè yon moun te gen tan pwomèt vann yon esklav fi bay yon nonm pou madanm, men lòt nonm lan poko peye pou esklav la, ni li menm li poko ba li libète l', si li kouche fi a, se pou yo peni yo san yo pa bezwen touye yo, paske fanm lan te esklav li toujou. ");
INSERT INTO hat_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Nonm lan va mennen yon belye mouton devan pòt Tant Randevou a, l'a ofri l' bay Seyè a pou peye pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Prèt la va pran belye mouton an, l'a fè sèvis pou l' mande Bondye gras pou peche li te fè a epi Bondye va padonnen l' sa. ");
INSERT INTO hat_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Le n'a antre nan peyi Kanaran an, apre n'a fin plante tout kalite pyebwa ki ka donnen, n'a konsidere rekòt twa premye lanne yo tankou bagay ki pa bon pou nou manje. Pandan twazan, piga nou manje anyen nan rekòt la. ");
INSERT INTO hat_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Lè katriyèm lanne a vin rive, n'a pran tout rekòt katriyèm lanne a, n'a ofri l' ban mwen, mwen menm Seyè a, pou nou moutre jan nou genyen m' rekonesans. ");
INSERT INTO hat_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Men sou senkyèm lanne a, nou ka manje donn yo. Si nou fè sa konsa, pyebwa nou yo va donnen pi plis toujou. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Piga nou manje ankenn vyann ak tout san li ladan l'. Piga nou chache konnen davans bagay ki gen pou rive nou nan lavi. Pa etidye pozisyon zetwal pou chache konnen sa ki pral rive sou latè. ");
INSERT INTO hat_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Lè nou gen moun mouri, piga nou koupe pafouten nou raz, piga nou taye pwent bab nou, ");
INSERT INTO hat_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","piga nou make kò nou avèk kout kouto, ni piga nou fè desen ak lank sou kò nou. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Piga nou avili pitit fi nou yo pou nou voye yo fè jennès nan tanp zidòl yo. Si nou fè sa, tout peyi a va vire al jwenn zidòl yo. Lè sa a, tout moun va lage kò yo nan fè sa ki mal. ");
INSERT INTO hat_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Se pou nou respekte regleman jou repo mwen yo. Se pou nou respekte kay ki apa pou mwen an. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Piga n' al konsilte moun k'ap rele mò nan tab tounant osinon moun k'ap fè divinò. Si nou fè sa, n'ap tounen tankou moun sa yo, nou p'ap nan kondisyon pou fè sèvis pou mwen. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Toujou leve kanpe devan granmoun cheve blan. Respekte figi vye granmoun, paske nou gen krentif pou mwen menm, Bondye nou an. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Piga nou maltrete moun lòt nasyon ki vin rete nan peyi a ansanm ak nou. ");
INSERT INTO hat_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Se pou nou aji ak yo menm jan nou gen pou nou aji ak moun natif natal peyi a. Se pou nou renmen yo tankou nou renmen pwòp tèt pa nou. Pa bliye nou menm tou yon lè nou te rete nan peyi Lejip ki pa t' peyi pa nou! Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Piga nou fè lenjistis nan tribinal. Piga nou twonpe moun lè n'ap mezire longè yon bagay, lè n'ap peze nan balans, lè n'ap mezire pa mamit. ");
INSERT INTO hat_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","N'a toujou gen bon balans, bon pwa, bon lòn, bon mezi. Se mwen menm ki Seyè a, Bondye nou an. Se mwen menm ki te fè nou soti kite peyi Lejip! ");
INSERT INTO hat_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Se pou nou kenbe tout lòd ak tout kòmandman mwen ban nou yo. Se pou nou swiv yo. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","-Men sa pou ou di moun pèp Izrayèl yo: Depi yon moun bay yonn nan pitit li yo pou sèvi nan sèvis zidòl Molòk, li te mèt moun peyi a osinon moun lòt nasyon k'ap viv nan peyi a, se pou yo touye l'. Wi, tout moun nan peyi a va kalonnen l' wòch jouk li mouri. ");
INSERT INTO hat_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Mwen menm bò pa m', mwen p'ap okipe l' ankò, m'ap wete l' nan mitan pèp mwen an. Paske li te bay yonn nan pitit li yo pou sèvi nan sèvis Molòk, li mete kay ki apa pou mwen an nan kondisyon yo pa ka fè sèvis ladan l' pou mwen, li derespekte non mwen. ");
INSERT INTO hat_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Men, si moun ki nan peyi a fèmen je yo sou sa nonm lan fè a, lè li te bay pitit li pou fè sèvis pou Molòk la, si yo pa touye l', ");
INSERT INTO hat_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","se mwen menm ki p'ap okipe l' ankò, li menm ak tout fanmi l'. M'ap wete yo nan mitan pèp mwen an, ni li, ni nenpòt lòt moun k'ap vire do ban mwen tankou l' pou y al sèvi Molòk. ");
INSERT INTO hat_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Si yon moun vire do ban mwen poul al konsilte moun k'ap rele mò nan tab tounant, osinon moun k'ap fè divinò, mwen p'ap okipe l' ankò, m'ap wete l' nan mitan pèp mwen an. ");
INSERT INTO hat_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Se pou nou viv apa pou mwen. Piga nou fè bagay mwen di nou pa fè, paske se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Se pou nou kenbe lòd mwen ban nou yo, se pou nou swiv yo. Se mwen menm Seyè a, se mwen menm k'ap fè nou sèvi m' nan tou sa n'ap fè! ");
INSERT INTO hat_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Depi yon moun bay manman l' osinon papa l' madichon, se pou yo touye l'. Paske li madichonnen manman l' ak papa l', se li menm sèl kab reskonsab lanmò li. ");
INSERT INTO hat_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Depi yon nonm fè adiltè ak madanm yon frè parèy li, se pou yo touye yo, ni li ni madanm lan. ");
INSERT INTO hat_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Depi yon nonm kouche madanm papa l', li jete dezonè sou papa l'. Se pou yo touye yo, ni li ni madanm lan. Lè konsa, se yo menm sèl k'ap reskonsab lanmò yo. ");
INSERT INTO hat_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Depi yon moun kouche bèlfi li, se pou yo touye tou de. Sa yo fè a se yon wont. Lè konsa, se yo menm sèl k'ap reskonsab lanmò yo. ");
INSERT INTO hat_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Depi yon nonm kouche yon nonm tankou li ta fè l' ak yon fanm, sa yo fè la a se bagay Bondye pi pa vle we. Se pou yo touye tou de. Lè konsa, se yo menm sèl k'ap reskonsab lanmò yo. ");
INSERT INTO hat_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Si yon nonm marye ak yon fi ansanm ak manman fi a tou, se bagay ki sal nèt yo fè la a. Se pou yo boule tou twa nan dife. Bagay konsa pa fèt pou fèt nan mitan nou. ");
INSERT INTO hat_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Si yon nonm kwaze ak yon zannimo, se pou yo touye l', li menm ansanm ak zannimo a. Wi, se pou yo touye yo. ");
INSERT INTO hat_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Si yon fanm chache yon jan pou li kwaze ak yon zannimo, se pou yo touye l', li menm ansanm ak zannimo a. Wi, se pou yo touye yo. Lè konsa, se yo menm sèl k'ap reskonsab lanmò yo. ");
INSERT INTO hat_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Si yon nonm marye ak sè li, li te mèt pitit fi manman l' osinon pitit fi papa l', si yo kouche yonn ak lòt, yo avili tèt yo devan tout pèp Izrayèl la. Sa yo fè a se yon gwo wont. Se pou yo chase yo nan mitan pèp la. Li te kouche sè li, se pou li peye pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Si yon nonm kouche yon fanm ki gen règ li, se pou yo wete yo nan mitan pèp la. ");
INSERT INTO hat_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Si yon nonm kouche matant li, matant bò papa l' osinon matant bò manman l', li kouche pwòp fanmi l'. Se pou yo fè tou de peye pou sa yo fè a. ");
INSERT INTO hat_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si yon nonm kouche madanm tonton li, li jete dezonè sou tonton li. Lè konsa, ni li, ni madanm lan, yo gen pou peye pou sa yo fè a. Y'a mouri san fè pitit. ");
INSERT INTO hat_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Si yon nonm marye ak madanm frè li, sa l' fè a se yon bagay k'ap mete l' nan kondisyon li pa ka sèvi Bondye, li jete dezonè sou frè li. Se poutèt sa, ni li ni madanm lan va rete san fè pitit. ");
INSERT INTO hat_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Seyè a di ankò: -Se pou nou kenbe tout lòd mwen yo ak tout kòmandman mwen ban nou yo, se pou nou swiv yo. Konsa, peyi kote mwen pral mennen nou pou nou rete a p'ap voye nou jete deyò. ");
INSERT INTO hat_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Piga nou swiv move mès moun lòt nasyon mwen te mete deyò pou nou te ka antre nan peyi a. Yo te ban m' degoutans ak tout move bagay yo t'ap fè a. ");
INSERT INTO hat_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Men, mwen te pwomèt mwen t'ap ban nou peyi sa a pou peyi pa nou. Se yon peyi kote lèt ak siwo myèl koule tankou dlo. Wi, se mwen menm Seyè a, Bondye nou an, ki te chwazi nou nan mitan tout pèp yo pou mete nou apa. ");
INSERT INTO hat_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Se konsa, koulye a, piga nou mele zannimo nou gen dwa manje ak zannimo nou pa gen dwa manje, zwazo nou gen dwa manje ak zwazo nou pa gen dwa manje. Pa kite ankenn zannimo ni ankenn zwazo nou pa gen dwa manje, ni bèt k'ap trennen sou vant mwen menm mwen di ki pa bon pou nou, mete nou nan kondisyon pou nou pa ka fè sèvis mwen. ");
INSERT INTO hat_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Se pou nou viv apa pou mwen, paske mwen menm se yon Bondye apa mwen ye. Mwen menm Seyè a, mwen mete nou apa nan mitan tout lòt pèp yo pou nou ka pou mwen nèt. ");
INSERT INTO hat_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Depi yon nonm osinon yon fanm gen lespri yon mò sou li, osinon yon lòt lespri k'ap fè l' fè divinò, se pou yo touye yo. Y'a touye yo ak kout wòch. Lè konsa, se yo menm sèl k'ap reskonsab lanmò yo. ");
INSERT INTO hat_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Seyè a di Moyiz konsa: -Pale ak pitit Arawon yo, prèt yo. W'a di yo konsa: Lè yon prèt gen yon moun mouri nan fanmi l', piga li patisipe nan ankenn seremoni yo fè pou mò, pou sa pa mete l' nan kondisyon pou l' pa ka fè sèvis Bondye, ");
INSERT INTO hat_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","esepte pou fanmi pre anpil tankou manman, papa, pitit fi, pitit gason, frè. ");
INSERT INTO hat_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Pou yon sè, si sè a poko fè zafè, li gen dwa mete tèt li nan kondisyon pou l' pa ka fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Yon prèt pa gen dwa mete tèt li nan kondisyon pou l' pa ka fè sèvis Bondye lè se yon sè li ki deja marye ki mouri. ");
INSERT INTO hat_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Prèt yo pa gen dwa kale ankenn pati nan tèt yo, ni yo pa gen dwa taye pwent bab yo, ni yo pa gen dwa make kò yo avèk kouto, pou fè wè yo gen moun mouri. ");
INSERT INTO hat_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Se pou yo viv apa nèt pou Bondye yo. Yo pa dwe derespekte non mwen. Paske se yo menm k'ap mete nan dife ofrann yo fè pou Seyè a, se manje Bondye y'ap ofri. Se pou yo toujou rete apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Yon prèt pa gen dwa marye ni ak yon fanm ki t'ap fè jennès, ni ak yon fanm ki konn gason deja, ni ak yon fanm mari l' kite l', paske yo mete yo apa pou fè sèvis mwen. ");
INSERT INTO hat_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tout moun dwe konsidere prèt yo tankou moun yo mete apa pou Bondye, paske se yo menm k'ap fè ofrann pou Bondye nou an. Mwen menm Seyè a, mwen yon Bondye apa. Se mwen k'ap fè nou viv apa pou mwen. Wi, se pou nou konsidere prèt yo tankou moun yo mete apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Si pitit fi yon prèt tonbe nan fè jennès, l'ap avili papa l', y'a boule l' nan dife pou touye l'. ");
INSERT INTO hat_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Granprèt la, se chèf li ye nan mitan tout prèt yo. Se moun yo te vide lwil sou tèt li a, moun yo te mete apa pou mete rad prèt la sou li a. Li pa fèt ni pou kite tèt li san penyen, ni pou l' chire rad sou li lè li gen moun mouri. ");
INSERT INTO hat_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Yo mete kouwòn mwen sou tèt li, yo vide lwil sou tèt li pou mete l' apa pou mwen. Li pa fèt pou l' fè bagay ki pou mete l' nan kondisyon pou li pa ka fè sèvis Bondye, pou l' derespekte kay yo mete apa pou Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Li pa fèt pou l' kite kay Bondye a pou l' al antre nan yon kay kote gen kadav moun mouri, menm si se papa l' osinon manman l' ki mouri a. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Granprèt la va marye ak yon jenn fi ki tifi. ");
INSERT INTO hat_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Li p'ap pran pou madanm yon fanm vèv, ni yon fanm divòse, ni yon fanm ki konn gason deja, osinon yon fanm ki t'ap fè jennès. Se sèlman yon jenn fi ki soti nan menm branch fanmi avè l' pou li pran pou madanm. ");
INSERT INTO hat_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Sinon, pitit li yo va yon wont pou fanmi an. Se mwen menm, Seyè a, ki mete li apa pou sèvis mwen. ");
INSERT INTO hat_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","-Pale ak Arawon, w'a di li: Si gen yon moun nan fanmi ou ki gen yon enfimite, li p'ap janm ka pwoche pou l' fè ofrann manje pou Bondye li. Regleman sa a ou fèt pou swiv li tout tan de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Ankenn gason enfim pa gen dwa prezante ofrann bay Bondye, kit li avèg, kit li bwete, kit li domaje nan figi, kit li difòm, ");
INSERT INTO hat_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","kit li enfim nan men osinon nan pye, ");
INSERT INTO hat_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kit li gen boul nan do, kit li rachitik, kit li malad nan je, kit li gen maladi po, kit grenn li kraze. ");
INSERT INTO hat_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Depi yon gason nan ras prèt Arawon an enfim yon kote nan kò li, li p'ap ka pwoche pou fè ofrann pou boule nan dife pou Seyè a. Wi, si li gen yon enfimite, li p'ap ka pwoche devan Bondye pou fè ofrann pou li. ");
INSERT INTO hat_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Yon nonm konsa ka toujou manje nan manje yo ofri ban mwen, kit se nan manje yo ofri m' lan osinon nan manje yo mete apa pou mwen an. ");
INSERT INTO hat_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Men, li pa gen dwa pwoche bò rido a ni vin bò lotèl la paske li enfim nan kò l'. Li pa fèt pou derespekte bagay ki apa pou mwen yo paske se mwen menm Seyè a ki mete yo apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Se konsa, Moyiz pale ak Arawon, ak pitit gason l' yo ansanm ak tout moun pèp Izrayèl yo, li di yo tou sa. ");
INSERT INTO hat_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Seyè a pale ak Moyiz, li di li: ");
INSERT INTO hat_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","-Men sa w'a di Arawon ak pitit gason l' yo. Se pou yo konnen ki jan pou yo sèvi ak sa moun pèp Izrayèl yo ofri m', ofrann yo mete apa pou mwen, pou yo pa derespekte non m'. Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","W'a di yo pou mwen: Lè yon gason nan fanmi nou pa nan kondisyon pou fè sèvis mwen, si li pwoche bò kote ofrann moun pèp Izrayèl yo mete apa pou mwen, piga yo janm kite l' parèt devan m' ankò! Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Si yon gason nan branch fanmi Arawon an gen yon move maladi po osinon ekoulman, li p'ap ka manje nan ofrann yo mete apa pou Bondye toutotan li pa nan kondisyon pou fè sèvis Bondye ankò. Konsa tou, si yon prèt manyen yon kadav, osinon yon nonm ki gen ekoulman, li pa nan kondisyon pou l' fè sèvis Bondye a. ");
INSERT INTO hat_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ou ankò si yon prèt manyen yonn nan bèt k'ap trennen sou vant yo, bèt ki ka mete l' nan kondisyon pou l' pa kapab fè sèvis Bondye, ou ankò si li manyen yon moun ki deja nan kondisyon sa a pou tèt pa l', prèt la tou pa ka fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","L'a rete nan kondisyon sa a jouk aswè, lèfini tou li p'ap ka manje nan ofrann yo mete apa pou Bondye yo. Se pou li pran yon bon beny nan dlo anvan. ");
INSERT INTO hat_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Apre solèy kouche, l'a nan kondisyon pou l' fè sèvis Bondye. Se lè sa a l'a ka manje nan ofrann yo mete apa pou Bondye a, paske se sa ki manje l'. ");
INSERT INTO hat_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Li pa gen dwa manje ni vyann bèt ki mouri mò natirèl, ni vyann bèt bèt nan bwa touye. Bagay konsa ap mete l' nan kondisyon pou li pa kapab fè sèvis Bondye. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Se pou tout prèt yo swiv regleman mwen bay yo. Si yo pa swiv yo, y'a koupab, epi y'ap mouri paske yo pa respekte lòd Bondye menm te bay yo. Se mwen menm ki Seyè a, se mwen menm ki mete yo apa pou yo viv apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Depi yon moun pa fè pati fanmi prèt yo, li te mèt yon moun ki rete lakay yon prèt osinon yon moun k'ap travay pou lajan l' lakay prèt la, li pa gen dwa manje nan ofrann yo mete apa pou Bondye yo. ");
INSERT INTO hat_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Men, esklav yon prèt, kit se achte li te achte l', kit li te fèt lakay li, gen dwa manje nan manje prèt la resevwa a. ");
INSERT INTO hat_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si pitit fi yon prèt marye ak yon nonm ki pa prèt, li p'ap ka manje anyen nan ofrann yo fè pou Bondye yo. ");
INSERT INTO hat_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Men, si pitit fi a vèv osinon si li divòse, si li pa gen pitit epi li tounen kay papa l' sou kont papa l', l'a ka manje nan manje papa l'. Men, moun ki pa fè pati fanmi prèt yo pa gen dwa manje anyen ladan l'. ");
INSERT INTO hat_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Si yon moun ki pa fè pati fanmi prèt yo manje nan manje yo mete apa pou Bondye a san li pa konnen, li gen pou l' renmèt sa l' manje a plis ven pou san valè bagay la. ");
INSERT INTO hat_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Prèt yo pa gen dwa kite moun ki pa fè pati fanmi yo derespekte manje yo mete apa pou Bondye. ");
INSERT INTO hat_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Si yo kite sa rive, moun lan va antò, l'ap peye pou sa. Se mwen menm ki Seyè a. Se mwen menm ki mete ofrann yo apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","-Pale ak Arawon ak pitit gason l' yo ak tout moun pèp Izrayèl la. Men sa w'a di yo: Lè yon moun nan pèp Izrayèl la, osinon yon moun lòt nasyon k'ap viv nan peyi a fè ofrann pou boule pou Seyè a, kit se paske li te fè yon ve, kit se paske li menm li fè lide fè ofrann lan, ");
INSERT INTO hat_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","se pou l' chwazi yon towo bèf, yon belye osinon yon bouk kabrit san ankenn enfimite si li vle pou m' asepte ofrann lan. ");
INSERT INTO hat_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Si nou ofri yon bèt ki gen nenpòt enfimite, Seyè a p'ap asepte l' nan men nou. ");
INSERT INTO hat_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Lè yon moun ap fè ofrann pou di Bondye mèsi, kit se paske li te fè yon ve, kit se paske li menm li vle fè ofrann lan, se pou bèt l'ap ofri a, li te mèt gwo bèt, li te mèt ti bèt, pa gen ankenn enfimite, si li vle pou m' asepte l'. ");
INSERT INTO hat_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Piga nou janm ofri bay Seyè a bèt je pete, bèt k'ap bwete, bèt ki pèdi janm, bèt ki gen malenng, bèt ki gen maladi po. Piga nou janm pran yon bèt konsa pou nou mete sou lotèl la pou nou boule nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Lè nou menm nou fè lide fè yon ofrann pou Seyè a, nou ka ofri yon towo bèf osinon yon belye ki difòm osinon ki kata. Men, nou pa ka sèvi ak yo pou yon ofrann n'ap fè paske nou te fè yon ve. Mwen p'ap asepte l'. ");
INSERT INTO hat_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Pa ofri bay Seyè a yon mal bèt ki gen grenn li yo foule, kraze, rache, osinon koupe. Nou pa gen dwa ofri bèt konsa nan peyi nou an. ");
INSERT INTO hat_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Piga nou pran bèt moun lòt nasyon fè nou kado pou n' ofri bay Seyè a. Paske bèt konsa pa antye, yo manke kichòy nan kò yo. Seyè a p'ap asepte yo nan men nou. ");
INSERT INTO hat_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","-Lè yon ti bèf, yon ti mouton osinon yon ti kabrit fenk fèt, se pou nou kite l' dèyè manman l' pandan sèt jou. Depi sou wityèm jou a, nou gen dwa ofri l' pou boule nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kit se bèf, kit se mouton, pa janm ofri yon bèt ansanm ak pitit li menm jou a. ");
INSERT INTO hat_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Lè n'ap fè ofrann pou di Bondye mèsi, se pou nou swiv tout regleman yo si nou vle Seyè a asepte ofrann lan nan men nou. ");
INSERT INTO hat_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Se pou nou manje l' menm jou a. Pa kite anyen pou denmen maten. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Se pou nou fè tou sa mwen ban nou lòd fè. Wi, se pou nou swiv lòd mwen yo. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Piga nou derespekte non mwen. Se pou tout moun pèp Izrayèl la respekte m'. Se mwen menm ki Seyè a, se mwen menm ki mete nou apa pou nou viv apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Se mwen menm ki te fè nou soti kite peyi Lejip pou m' te ka Bondye nou. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","-Pale ak moun pèp Izrayèl yo. W'a di yo pou mwen: Men jou pou nou mande pèp la pou li reyini pou fè fèt pou Seyè a. Men lè pou nou fè fèt pou mwen. ");
INSERT INTO hat_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Chak senmenn nou gen sis jou pou n' fè travay nou. Men, setyèm jou a se jou repo. Jou sa a, piga nou fè ankenn travay. Se jou n'a reyini pou n' fè sèvis pou Bondye. Jou repo a se pou Seyè a li ye. Nenpòt kote nou rete jou sa a, piga nou fè ankenn travay lakay nou. ");
INSERT INTO hat_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Men jou pou nou fè fèt pou Seyè a, jou pou nou mande pèp la pou li reyini pou fè fèt pou Seyè a. Men dat pou nou reyini pèp la pou fèt yo: ");
INSERT INTO hat_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","N'a fete fèt Delivrans lan pou Seyè a chak lanne, nan katòzyèm jou premye mwa a. N'a konmanse fèt la lè solèy fin kouche. ");
INSERT INTO hat_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Sou kenzyèm jou premye mwa a, n'a konmanse fèt pen san ledven yo. Pandan sèt jou, n'a manje pen ki fèt san ledven. ");
INSERT INTO hat_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Premye jou a, n'a reyini tout pèp la pou n' fè sèvis pou Bondye. Nou p'ap fè ankenn gwo travay jou sa a. ");
INSERT INTO hat_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Pandan sèt jou n'a boule ofrann nan dife pou Seyè a. Sou setyèm jou a, n'a reyini tout pèp la ankò pou n' adore Seyè a. Jou sa a, nou p'ap fè ankenn gwo travay non plis. ");
INSERT INTO hat_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","-Pale ak moun pèp Izrayèl yo. Men sa pou ou di yo. Lè n'a antre nan peyi m'ap ban nou an, lè n'a fin ranmase premye rekòt grenn nan jaden nou, n'a pran premye makout la, n'a pote l' bay prèt la. ");
INSERT INTO hat_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Prèt la va balanse l' devan Seyè a tankou yon ofrann espesyal, pou Seyè a ka asepte resevwa nou. Prèt la va fè ofrann lan jou ki vini apre jou repo a. ");
INSERT INTO hat_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Jou n'ap fè ofrann premye makout rekòt la, n'a pran yon ti belye ki pa gen ankenn enfimite epi ki poko gen ennan, n'a boule l' nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","N'a ofri ansanm avè l' tou katòz ti mamit farin frans melanje ak lwil oliv pou nou boule nan dife pou Seyè a. Bon sant ofrann lan va fè Seyè a plezi. N'a ofri tou yon boutèy ka diven pou yo vide pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Piga nou pran nan grenn nou fèk rekòlte yo ni pou nou manje kri, ni pou nou griye, ni pou nou fè pen, toutotan nou pa pote ofrann premye grenn yo bay Seyè a. Se va yon regleman pou nou swiv tout tan, de pitit an pitit, kote nou pase. ");
INSERT INTO hat_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","N'a konte sèt semèn antye, depi jou nou te pote premye makout rekòt la ofri bay Seyè a, apre jou repo a. ");
INSERT INTO hat_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Wi, n'a konte senkant jou. Sa va mennen nou sou jou ki vini apre setyèm jou repo a. N'a fè yon lòt ofrann grenn jaden bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Chak fanmi va soti lakay yo ak de gwo pen pou yo ofri bay Seyè a. Chak pen va fèt ak de liv farin kwit ak ledven. Y'a ofri yo bay Seyè a tankou ofrann premye grenn yo rekòlte. ");
INSERT INTO hat_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Ansanm ak pen yo, pèp la va ofri sèt ti mouton ki poko gen ennan, yon jenn ti towo bèf ak de belye. Fòk tout bèt sa yo pa gen ankenn enfimite. Y'a boule yo nèt nan dife pou Seyè a, ansanm ak ofrann grenn jaden yo ak ofrann diven an. Bon sant ofrann sa a va fè Seyè a plezi. ");
INSERT INTO hat_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","N'a touye tou yon bouk ki va sèvi ofrann pou peye pou tou sa nou fè ki mal, ak de ti mouton ki poko gen ennan ki va sèvi ofrann pou di Bondye mèsi. ");
INSERT INTO hat_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Prèt la va balanse pen yo ansanm ak de ti mouton yo tankou yon ofrann espesyal devan Seyè a. Ofrann sa yo se bagay ki apa nèt pou Seyè a. Se pou prèt yo yo ye. ");
INSERT INTO hat_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Jou sa a, n'a reyini pèp la pou l' adore Bondye. Pesonn p'ap fè gwo travay. Sa se regleman pou nou swiv tout tan, de pitit an pitit, kote nou pase. ");
INSERT INTO hat_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Lè n'ap fè rekòt nan jaden nou, se pa pou nou ranmase grenn ki toupre lizyè jaden an, ni nou pa bezwen tounen dèyè pou ranmase grenn ki te tonbe atè. W'a kite yo pou moun peyi a ki pa genyen ak pou moun lòt nasyon k'ap viv nan mitan nou. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","-Pale ak moun pèp Izrayèl yo. Men sa pou ou di yo: Premye jou setyèm mwa a va yon gwo jou repo pou nou. Jou sa a n'a kònen twonpèt pou fè moun yo chonje se jou pou yo reyini pou adore Bondye. ");
INSERT INTO hat_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Piga nou fè gwo travay. N'a fè ofrann pou yo boule nan dife pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Seyè a pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","-Dizyèm jou sètyèm mwa sa a, se gran jou padon an li ye. N'a reyini tout moun pou n' adore Bondye. N'a fè jèn epi n'a fè ofrann pou yo boule nan dife devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Jou sa a, nou p'ap travay menm, paske se gran jou padon an, jou pou nou fè sèvis pou Seyè a, Bondye nou an, pou nou mande l' fè nou gras. ");
INSERT INTO hat_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Si yon moun mete anyen nan bouch li jou sa a, y'ap wete l' nan mitan pèp li a. ");
INSERT INTO hat_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Si yon moun travay jou sa a, se mwen menm, Seyè a, k'ap touye l'. ");
INSERT INTO hat_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Nou pa pou fè anyen jou sa a. Sa se regleman pou nou swiv tout tan, de pitit an pitit, kote nou pase. ");
INSERT INTO hat_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Se va yon gwo jou repo, jou nou p'ap fè ankenn travay. Depi lè solèy kouche nan nevyèm jou mwa a jouk lè li kouche ankò dizyèm jou a, n'a rete san manje. ");
INSERT INTO hat_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Seyè a pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","-Pale ak moun pèp Izrayèl yo, w'a di yo konsa: N'a fete fèt joupa yo pandan sèt jou. N'a konmanse sou kenzyèm jou setyèm mwa a. ");
INSERT INTO hat_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Premye jou a, n'a reyini tout moun pou adore Bondye. Pesonn p'ap fè gwo travay jou sa a. ");
INSERT INTO hat_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Chak jou, pandan sèt jou, n'a boule ofrann nan dife pou Seyè a. Sou wityèm jou a, n'a reyini moun yo ankò pou adore Bondye, epi n'a boule ofrann nan dife pou Seyè a. Se va yon jou pou adore Bondye. Jou sa a, piga nou fè gwo travay. ");
INSERT INTO hat_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Men fèt pou nou fete pou Seyè a. Men jou n'a reyini tout moun pou yo fè sèvis pou Bondye. Men ofrann pou nou boule nan dife pou Seyè a, se ka bèt pou nou boule nèt, se ka ofrann grenn jaden, se ka bèt pou nou touye, se ka ofrann diven. Chak jou fèt gen ofrann pa li. ");
INSERT INTO hat_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Apa tout jou repo Seyè yo, n'a fete fèt sa yo tou. Apa kado pou nou fè nòmalman, apa ofrann n'ap fè paske nou te fè ve, apa ofrann n'ap fè pou Seyè a paske nou te vle fè l', n'a fè ofrann sa yo. ");
INSERT INTO hat_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Sou kenzyèm jou setyèm mwa a, n'a fè fèt pou Seyè a pandan sèt jou, apre n'a fin rekòlte jaden nou yo. Premye jou a ak wityèm jou a va de gwo jou repo. ");
INSERT INTO hat_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Premye jou a, n'a keyi pi bon fwi nan pye sitwon nou yo, n'a koupe fèy nan pye dat nou yo ak branch nan pye jasmen ak pye sikren, n'a fè kè nou kontan devan Seyè a, Bondye nou an, pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Chak lanne, pandan sèt jou nan setyèm mwa a, n'a fete fèt sa a pou mwen menm, Seyè a, Bondye nou an. Sa se yon regleman pou nou swiv tout tan, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Pandan sèt jou tout moun pèp Izrayèl yo va rete anba joupa. Wi, n'a rete anba joupa pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Konsa, pitit pitit nou yo va konnen mwen menm, Seyè a, mwen te fè pèp Izrayèl rete anba joupa lè mwen te fè yo soti kite peyi Lejip la. Se mwen menm ki Seyè a, Bondye nou an! ");
INSERT INTO hat_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Se konsa Moyiz te bay moun pèp Izrayèl yo tout kalite fèt pou yo fete pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","-Bay moun pèp Izrayèl yo lòd pou yo fè ou jwenn bon lwil fèt ak grenn oliv kraze pou gwo lanp sèt branch ki nan Tant Randevou a, pou lanp yo toujou ka rete limen. ");
INSERT INTO hat_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Chak aswè, Arawon va limen yo, l'a veye pou yo toujou rete limen jouk denmen maten devan Seyè a, sou deyò rido ki devan Bwat Kontra a nan Tant Randevou a. Sa se yon regleman pou yo kenbe pou tout tan, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Arawon va pran swen tout ti lanp ki sou gwo lanp sèt branch an lò a. L'a veye pou yo toujou rete limen devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","W'a pran vennkat liv farin frans, w'a fè douz pen. Chak pen va fèt ak de liv farin. ");
INSERT INTO hat_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","W'a mete pen yo sou de ran sou tab lò ki devan Seyè a, sis pen nan chak ran. ");
INSERT INTO hat_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Apre sa, w'a pran lansan bon kalite, w'a mete sou chak ran pen yo. Se lansan sa a w'a ofri nan dife bay Seyè a tankou si se te pen yo menm ou te ofri. ");
INSERT INTO hat_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Se pou moun pèp Izrayèl yo pote pen chak jou repo, pou yo ofri bay Seyè a. Se bagay pou yo toujou fè dapre kontra Bondye a ki p'ap janm kase. ");
INSERT INTO hat_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Se pou Arawon ak pitit gason l' yo pen yo va ye. Y'a manje yo yon kote ki apa pou Seyè a, paske se yon pòsyon ki apa nèt pou Bondye nan manje yo ofri pou boule nan dife pou Seyè a. Se yon regleman ki la pou tout tan tout tan. ");
INSERT INTO hat_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Vwala te gen yon nonm, manman l' te moun pèp Izrayèl, men papa l' te moun peyi Lejip. Msye vin rive nan mitan pèp la, epi li pete yon kont nan kan an avèk yon moun pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Manman nonm lan te rele Chelomit. Se te pitit fi Dibri, yon moun nan branch fanmi Dann lan. Pandan yo t'ap joure a, nonm lan nonmen non Bondye mal. Nan koze a, li derespekte Bondye. Se konsa yo pran l' mennen bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Yo mete msye yon kote ak moun pou veye l', pandan Moyiz menm t'ap tann Seyè a vin di l' sa pou l' fè. ");
INSERT INTO hat_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","-Mennen nonm lan lòt bò limit kan an. Fè tout moun ki te tande l' lè li t'ap derespekte Bondye a mete men yo sou tèt li. Konsa, y'a ba l' pote reskonsablite sa l' fè a, epi tout pèp la va kalonnen msye wòch jouk li mouri. ");
INSERT INTO hat_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Apre sa, w'a pale ak moun pèp Izrayèl yo, w'a di yo: Lè yon moun derespekte Bondye, se pou l' peye pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Se pou yo touye l'. Wi, si yon moun peyi a osinon yon moun lòt nasyon k'ap viv nan mitan nou derespekte Bondye, se pou yo touye l'. Tout moun nan peyi a va kalonnen l' wòch jouk li mouri. ");
INSERT INTO hat_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Depi yon moun touye yon lòt, se pou yo touye l' tou. ");
INSERT INTO hat_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Si yon moun touye yon bèt ki pa pou li, se pou l' renmèt li. Prensip la vle kou pou kou, lavi pou lavi. ");
INSERT INTO hat_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si ou fè yon moun menm peyi avè ou mal, se pou yo fè ou menm bagay la tou. ");
INSERT INTO hat_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Si ou kase yon zo nan kò l', y'a kase yon zo nan kò pa ou tou. Si ou pete yon grenn je l', y'a pete yon grenn je pa ou tou. Si ou kase yon dan nan bouch li, y'a kase yon dan nan bouch pa ou tou. Sa ou fè lòt la, se sa y'a fè ou tou. ");
INSERT INTO hat_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Si ou touye yon bèt ki pa pou ou, se pou ou renmèt li. Men, si se yon moun ou touye, y'ap touye ou tou. ");
INSERT INTO hat_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Menm jijman sa a va pou tout moun k'ap viv nan peyi a, kit se yon moun peyi a ki menm ras avè ou, kit se yon moun lòt nasyon, paske se mwen menm Seyè a ki Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moyiz pale ak moun pèp Izrayèl yo, epi yo pran nonm ki te nonmen non Bondye a mal la, yo mennen l' andeyò lòt bò limit kote tout moun rete a, epi yo kalonnen l' wòch jouk yo touye l'. Se konsa moun pèp Izrayèl yo te fè tou sa Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Seyè a pale ak Moyiz sou mòn Sinayi a, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","-Pale ak moun pèp Izrayèl yo, w'a di yo pou mwen: Lè n'a antre nan peyi m'ap ban nou an, n'a bay tè a yon repo pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pandan sizan n'a plante jaden nou, n'a taye pye rezen nou yo, epi n'a ranmase rekòt pandan sizan. ");
INSERT INTO hat_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Men, setyèm lanne a n'a kite tè a poze nèt. Se va yon gwo lanne repo pou tè a. Se va yon lanne n'a kite tè a pran repo pou Seyè a. Nou p'ap simen anyen nan jaden nou, ni nou p'ap taye pye rezen nou yo. ");
INSERT INTO hat_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Piga nou ranmase grenn ki pouse konsa nan jaden nou pou nou vann. Ni piga nou keyi rezen ki donnen nan pye rezen nou pa t' taye pou nou vann. Se va yon lanne repo nèt pou te a. ");
INSERT INTO hat_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pandan tout lanne a tè a va rete san nou pa travay li. Men, sa l'a bay la va sèvi manje pou nou ak pou tout moun k'ap viv lakay nou, pou moun lòt nasyon ki fè ladesant lakay nou. ");
INSERT INTO hat_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Bèt domestik nou yo ak bèt bwa ki nan peyi a va manje nan sa tè a bay la tou. ");
INSERT INTO hat_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","N'a konte sèt lanne Repo, ki vle di sèt fwa sèt lanne, sa va ban nou karantnèf lanne. ");
INSERT INTO hat_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Sou dizyèm jou setyèm mwa a ki jou pou n' mande Bondye gras la, n'a fè kònen twonpèt nan tout peyi a. ");
INSERT INTO hat_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","N'a mete senkantyèm lanne sa a apa pou Bondye, epi n'a bay lòd pou yo bay tout moun ki esklav nan peyi a libète yo pou tout lanne a. Se va yon lanne rejwisans pou tout moun. Lanne sa a, tou sa yo te vann anvan ap tounen pou ansyen mèt yo ankò osinon pou eritye yo. Tout moun ki te esklav ap tounen lib lakay yo. ");
INSERT INTO hat_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Senkantyèm lanne sa a va yon lanne rejwisans pou tout moun: Nou p'ap simen anyen nan jaden nou yo, ni nou p'ap ranmase grenn ki pouse konsa nan jaden nou yo pou nou vann, ni nou p'ap keyi rezen ki donnen nan pye rezen nou pa t' taye pou nou vann. ");
INSERT INTO hat_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Paske se va yon lanne rejwisans, se va yon lanne n'a mete apa nèt pou Seyè a. Men n'a manje tou sa jaden nou pa t' plante yo bay. ");
INSERT INTO hat_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Nan lanne rejwisans sa a, tout tè ki te vann ap tounen pou ansyen mèt yo ankò. ");
INSERT INTO hat_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Konsa, si n'ap vann yon moun pèp Izrayèl parèy nou yon tè osinon si n'ap achte tè nan men l', piga nou fè koutay yonn sou do lòt. ");
INSERT INTO hat_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Lè n'ap achte yon tè osinon lè w'ap vann yon tè, se pou nou kalkile pri a sou kantite lanne tè a ka travay anvan lanne rejwisans k'ap vini an rive. ");
INSERT INTO hat_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Plis gen lanne anvan lanne rejwisans lan rive, se plis pri a va pi wo. Mwens gen lanne, se plis pri a va pi ba, paske se kantite lanne rekòt tè a ka bay la n'ap vann osinon n'ap achte. ");
INSERT INTO hat_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Pa fè lajan sou do moun pèp Izrayèl parèy nou. Men, se pou nou gen krentif pou Bondye nou, paske se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Se pou nou swiv lòd mwen ban nou yo, se pou nou kenbe tout kòmandman m' yo. Se pou nou swiv yo, se konsa n'a kapab viv nan peyi a san nou pa bezwen pè anyen. ");
INSERT INTO hat_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tè a va bay rekòt li, n'a manje kont nou, epi n'a viv nan peyi a ak kè poze. ");
INSERT INTO hat_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Men, gen moun ki va mande kisa y'a manje setyèm lanne a si yo pa plante, si yo pa ranmase rekòt. ");
INSERT INTO hat_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mwen menm, Seyè a, m'a voye benediksyon m' sou tè a pandan sizyèm lanne a pou l' ka donnen rekòt kantite pou twazan. ");
INSERT INTO hat_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Konsa, lè wityèm lanne a va rive pou nou plante jaden nou yo, n'a jwenn manje toujou nan ansyen rekòt sizyèm lanne a. N'a gen kont pou nou manje jouk nevyèm lanne a rivè, lè n'a gen pou n' ranmase rekòt wityèm lanne sa a. ");
INSERT INTO hat_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Yon tè pa fèt pou vann pou tout tan, paske tè a pa pou nou, se pou mwen li ye. Nou menm, nou tankou moun lòt peyi ki rete lakay mwen: mwen ban nou dwa sèvi sou tè a. ");
INSERT INTO hat_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Lè n'ap achte yon tè nan peyi nou an, se pou nou rekonèt dwa ansyen mèt tè a genyen pou l' reachte tè a ankò. ");
INSERT INTO hat_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Lè yon moun pèp Izrayèl parèy nou vin nan nesesite, epi li blije vann pòsyon tè ki pou li a, fanmi ki pi pre l' la va reachte tè li te vann lan, paske se li ki gen dwa fè sa. ");
INSERT INTO hat_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Men, si yon nonm pa gen fanmi pre pou reachte tè a, epi apre kèk tan zafè l' vin bon ankò, l'a reachte tè a lè l'a gen kont lajan pou sa. ");
INSERT INTO hat_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","L'a kalkile depi ki tan li te vann tè a, epi l'a renmèt moun ki te achte tè a nan men l' lan lajan ki koresponn ak kantite lanne ki rete anvan lanne rejwisans k'ap vini an, epi l'a reprann tè li. ");
INSERT INTO hat_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Men, si li pa gen kont kòb pou reachte tè a, tè a va rete nan men moun ki te achte l' la jouk lanne rejwisans k'ap vini an. Lè sa a, tè a va tounen nan men ansyen mèt li ankò. ");
INSERT INTO hat_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Si yon nonm vann yon kay ki nan yon bouk ki gen ranpa, li gen yon lanne delè, depi dat li te vann kay la, pou l' reachte l' ankò. Pase yon lanne, li pèdi dwa a. ");
INSERT INTO hat_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Si li kite tout lanne a pase san li pa reachte kay la, kay la ap rete pou moun ki te achte l' la ak pou pitit pitit li yo. Yo p'ap renmèt li kay la lè lanne rejwisans la rive. ");
INSERT INTO hat_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Men, kay ki nan bouk kote ki pa gen ranpa, y'ap konsidere yo menm jan ak yon jaden. Ansyen mèt la gen dwa reachte l' ankò. Men, tout jan se pou yo renmèt li kay la, lè lanne rejwisans lan rive. ");
INSERT INTO hat_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Moun Levi yo menm ap gen lavil pa yo apa. Yon moun Levi ap toujou gen dwa reachte kay ki te pou li nenpòt kilè. ");
INSERT INTO hat_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Si yon moun Levi rive vann yon kay ki nan lavil moun Levi yo, epi li pa reachte l', se pou yo renmèt li kay la lè lanne rejwisans lan rive, paske lè yon moun Levi gen yon kay nan mitan pèp la, kay la pou li nèt. ");
INSERT INTO hat_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Konsa tou, pou jaden ki tout arebò lavil moun Levi yo, yo pa gen dwa vann li, paske se pou yo li ye pou tout tan. ");
INSERT INTO hat_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Si yon moun pèp Izrayèl parèy nou k'ap viv toupre lakay nou vin nan nesesite, epi li tonbe nan malsite, se pou nou lonje men ba li tankou nou ta dwe fè l' pou yon moun lòt nasyon k'ap travay lakay nou osinon ki vin fè ladesant lakay nou. Konsa, l'a toujou ka viv bò kote nou. ");
INSERT INTO hat_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Pa fè l' peye ankenn enterè, pa ba l' ponya. Gen krentif pou Bondye. Bay moun pèp Izrayèl parèy nou an yon chans pou l' viv tou. ");
INSERT INTO hat_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Piga nou mande l' enterè sou lajan nou prete l'. Piga nou ba l' ponya pou manje nou vann li. ");
INSERT INTO hat_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Se mwen menm Seyè a, Bondye nou an. Se mwen menm ki te fè nou soti kite peyi Lejip pou m' te ka ban nou peyi Kanaran an epitou pou m' te ka Bondye nou. ");
INSERT INTO hat_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Si yon moun pèp Izrayèl parèy nou k'ap viv toupre lakay nou vin nan nesesite, epi li vann tèt li ban nou pou li sèvi nou esklav, piga nou fè l' fè travay yon domestik. ");
INSERT INTO hat_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","L'ap rete lakay nou tankou moun lòt nasyon yo k'ap travay pou lajan lakay nou. L'a sèvi nou jouk lanne rejwisans k'ap vini an. ");
INSERT INTO hat_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Lè sa a, li menm ak tout pitit li yo, y'a kite lakay nou, y'a tounen al jwenn fanmi yo, epi y'a renmèt yo tè zansèt yo te kite pou yo a. ");
INSERT INTO hat_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Paske se esklav mwen nou ye, se mwen menm ki te fè nou soti kite peyi Lejip. Yo pa gen dwa vann nou pou fè nou sèvi esklav lòt moun. ");
INSERT INTO hat_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Piga nou aji mal ak moun pèp Izrayèl parèy nou yo. Se pou nou gen krentif pou Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Lè n'a bezwen gason osinon fi pou sèvi esklav lakay nou, nou ka achte yo nan moun lòt nasyon k'ap viv lòt bò fwontyè peyi nou an. ");
INSERT INTO hat_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nou ka achte pitit moun lòt nasyon k'ap viv nan mitan nou tou. Konsa tou, lè yo rete lakay nou, si yo fè pitit sou tè ki pou nou, pitit yo va pou nou tou. ");
INSERT INTO hat_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","N'a kite yo tankou byen pou pitit nou yo. Y'a sèvi yo jouk yo mouri. Nou pa dwe maltrete moun pèp Izrayèl parèy nou. Men, se pou nou aji avèk yo tankou frè ak frè. ");
INSERT INTO hat_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Sipoze yon moun lòt nasyon k'ap viv nan mitan nou nan peyi a vin gen anpil mwayen epi yon moun pèp Izrayèl parèy nou k'ap viv lakay nou, osinon pre kay moun lòt nasyon an, vin nan nesesite epi l al vann tèt li bay moun lòt nasyon an, osinon bay yonn nan fanmi moun lòt nasyon an pou li sèvi l' esklav. ");
INSERT INTO hat_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Apre li vann tèt li a, l'a toujou gen avantaj moun ka reachte l' pou ba li libète l'. Se bagay yonn nan frè li yo, ");
INSERT INTO hat_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","osinon tonton l', osinon pitit gason tonton l' yo, osinon yonn nan fanmi pre li yo ka fè pou li. Si li menm li vin gen mwayen, li ka reachte tèt li tou. ");
INSERT INTO hat_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Dakò ak moun ki te achte l' la, se pou l' konte konbe lanne ki gen depi lanne li te vann tèt li bay moun lan jouk lanne rejwisans k'ap vini an. Lè sa a, l'a kalkile lajan pou l' bay la sou kantite lanne l'a jwenn lan, epi sou pri yo peye lè konsa pou yon moun k'ap travay pou lajan lakay moun. ");
INSERT INTO hat_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Lè gen anpil lanne ki rete, l'a kalkile sou yo pou l' konnen valè lajan pou l' renmèt pou l' ka reachte tèt li. ");
INSERT INTO hat_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Men, si pa gen lanne ki rete anvan lanne rejwisans lan, y'a kalkile ansanm, epi l'a renmèt li lajan dapre kantite lanne ki rete a pou l' ka reachte tèt li. ");
INSERT INTO hat_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Paske l'ap travay ak moun lan tankou domestik k'ap travay pou lajan pa an, ou pa fèt pou kite moun lan maltrete li. ");
INSERT INTO hat_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Si li pa reachte tèt li konsa, lè lanne rejwisans lan rive, ni li menm, ni pitit gason l' yo va lib ankò. Epi y'a kite kay moun lan. ");
INSERT INTO hat_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Se pou nou swiv regleman sa yo, paske se esklav pa m' moun pèp Izrayèl yo ye. Yo se esklav mwen te fè soti kite peyi Lejip. Se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Seyè a di: -Nou pa gen dwa fè zidòl, nou pa gen dwa fè estati, ni mete wòch kanpe. Nou pa gen dwa pran wòch pou fè desen sou li, lèfini pou n' mete l' kanpe yon kote nan peyi a pou nou adore yo. Se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Se pou nou fete tout fèt mwen yo. Se pou nou respekte kay ki apa pou mwen an. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Si nou mache dapre lòd mwen yo, si nou kenbe tout kòmandman m' yo, si nou swiv yo, ");
INSERT INTO hat_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","lè sezon an rive, m'a ban nou lapli. Konsa, tè nou va bay rekòt, pyebwa nan jaden nou va donnen. ");
INSERT INTO hat_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Lè sa a, nou p'ap anko fin bat ble, n'ap gen tan nan keyi rezen. Nou p'ap ankò fin keyi rezen, n'ap gen tan nan plante grenn. N'a gen kont manje pou nou manje, epi n'a rete nan peyi nou an san nou pa bezwen pè anyen. ");
INSERT INTO hat_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","M'a mete kè poze nan peyi a, n'a kouche dòmi san kè sote. M'ap fè tout bèt mawon disparèt nan peyi a, moun p'ap vin fè nou lagè ankò. ");
INSERT INTO hat_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","N'a kouri dèyè lènmi nou yo, n'a bat yo, n'a kraze yo ak nepe nou. ");
INSERT INTO hat_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Senk moun nan mitan nou va kont pou bat san lènmi, san moun nan mitan nou va kont pou bat mil lènmi. N'a kraze lènmi nou yo anba kout nepe nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","M'a beni nou, m'a ban nou pitit, m'a ban nou anpil pitit. Mwen menm, m'a kenbe kontra mwen te siyen ak nou an. ");
INSERT INTO hat_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","N'a sitèlman fè bèl rekòt, apre nou fin manje pandan ennan, n'a setoblije mete rès grenn dènye rekòt la deyò pou nou fè plas pou rekòt k'ap vin apre a. ");
INSERT INTO hat_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","M'ap rete nan mitan nou nan kay mwen an, m'ap toujou kontan ak nou. ");
INSERT INTO hat_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","M'a toujou la nan mitan nou, se mwen menm k'ap Bondye nou, se pèp mwen n'a ye. ");
INSERT INTO hat_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Se mwen menm, Seyè a, Bondye nou an, ki te fè nou soti kite peyi Lejip pou nou pa t' rete esklav moun sa yo ankò. Mwen kase gwo kòd lwijanboje ki t'ap jouke nou an, mwen fè nou mache tèt anlè. ");
INSERT INTO hat_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Men tou, si nou pa koute m', si nou pa vle fè tou sa m' mande nou fè la a, m'ap peni nou. ");
INSERT INTO hat_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Si nou meprize lòd mwen yo, si nou voye kòmandman mwen yo jete, si nou pa fè tou sa mwen mande nou fè, si nou pa kenbe kontra m' pase ak nou an, ");
INSERT INTO hat_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","men ki jan m'ap peni nou: M'ap voye gwo malè sou nou. Maladi ap mennen nou. Lafyèb ap fè nou deperi. Nou p'ap ka wè nan je nou, n'ap pèdi souf nou. Nou va simen grenn nan jaden nou. Men, sa p'ap sèvi nou anyen, paske se lènmi nou yo ki va jwi rekòt nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","M'a vire do ban nou, epi lènmi nou va bat nou. Moun ki pa vle wè nou yo va donminen sou nou. N'a rete konsa, n'a pran kouri san pa gen pesonn k'ap kouri dèyè nou. ");
INSERT INTO hat_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Si, atousa toujou, nou pa koute m', m'ap peni nou sèt fwa pi rèd pase anvan poutèt peche nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Pouvwa nou genyen an epi k'ap fè nou gonfle konsa a, m'ap kraze l' nèt. Pa yon ti degout lapli p'ap tonbe sot nan syel la, tè a ap vin di kou wòch. ");
INSERT INTO hat_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","N'a kraze kouraj nou travay di, men sa p'ap sèvi nou anyen: tè jaden nou yo p'ap bay anyen ankò, pyebwa yo p'ap donnen menm. ");
INSERT INTO hat_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Si, apre sa, nou vle kenbe tèt ak mwen toujou, si nou derefize koute m', mwen menm tou m'ap peni nou sèt fwa pi rèd toujou pase anvan poutèt peche nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","M'a lage bèt nan bwa dèyè nou, y'a touye pitit nou yo, y'a fini ak tout zannimo nou yo. Anpil nan nou va mouri tou. p'ap gen pesonn ap mache sou chemen nan peyi a. ");
INSERT INTO hat_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Si apre tout malè sa yo nou pa korije toujou, n'ap kenbe tèt avè m' toujou, ");
INSERT INTO hat_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","mwen menm tou m'a kenbe tèt avèk nou. M'ap frape nou sèt fwa pi rèd ankò pase anvan poutèt peche nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","M'ap fè lènmi nou yo vin fè nou lagè poutèt kontra m' nou pa kenbe a. Lè sa a, n'a anpile kò nou nan lavil yo pou chache pwoteksyon, m'a voye tout kalite move maladi sou nou, jouk n'a blije rann tèt nou bay lènmi nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","M'ap koupe viv nou. Yon sèl fou ap kont pou dis fanm pare pen pou tout fanmi yo. Y'a kontwole sa y'ap bay chak moun. Lè n'a fin manje, se atò n'a grangou. ");
INSERT INTO hat_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Epi, si apre tou sa toujou, nou pa koute m', n'ap kenbe tèt avè m' toujou, ");
INSERT INTO hat_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","lè sa a m'a kenbe tèt ak nou tou, m'a pran chenn sou nou. Se mwen menm toujou k'ap peni nou sèt fwa pi rèd pase anvan poutèt peche nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","N'a sitèlman grangou n'a touye pwòp pitit gason ak pwòp pitit fi nou yo, n'a manje vyann yo. ");
INSERT INTO hat_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","M'a detwi tout kay nou bati sou tèt mòn pou fè sèvis, m'a kraze lotèl lansan nou yo mete atè, m'a anpile kadav nou yo atè sou moso estati vye zidòl nou yo. N'a ban m' degoutans. ");
INSERT INTO hat_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","M'a fè lavil nou yo tounen mazi. M'ap detwi tout kote nou fè sèvis yo. M'ap derefize pran bon sant ofrann nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Se mwen menm ankò ki pral devaste peyi nou an. Ata lènmi nou yo ki pral pran peyi a pou yo rete pral sezi wè sa m'ap fè. ");
INSERT INTO hat_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","M'ap mennen lènmi nou yo vin fè nou lagè. M'ap leve moun dèyè nou pou vin fè nou lagè. M'ap gaye nou nan mitan lòt peyi etranje yo. Peyi a va tounen yon dezè. Lavil nou p'ap gen pesonn rete ladan yo. ");
INSERT INTO hat_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Lè sa a, tè a va pran repo. Wi, lè lènmi nou yo va depòte nou byen lwen nan peyi pa yo, tè a va rete san travay, l'a pran repo. ");
INSERT INTO hat_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Pandan tout tan tè a va rete san travay la, l'a jwi tout lanne repo nou pa t' ba li yo lè nou te rete sou li a. ");
INSERT INTO hat_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Kanta pou rès moun ki pa mouri yo, lè y'a rive nan peyi kote yo depòte yo a, m'ap fè yo viv tout tan ak yon kè sote san rete. Konsa, bri yon fèy bwa chèch van ap pote ap kont pou fè yo kouri. Y'ap kouri tankou moun ki gen lagè dèyè yo, y'ap tonbe san pa gen moun k'ap kouri dèyè yo. ");
INSERT INTO hat_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Y'ap tonbe yonn sou lòt tankou nan lagè san pa gen pesonn k'ap kouri dèyè yo. Yo p'ap fouti kanpe pou yo goumen ak lènmi yo. ");
INSERT INTO hat_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","N'a mouri nan peyi kote yo te depòte nou yo. Y'a antere nou nan peyi moun ki pa vle wè nou yo. ");
INSERT INTO hat_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Moun ki rete nan sa yo te depòte yo va depafini nan peyi lènmi nou yo, paske y'a peye pou peche zansèt yo ak pou pwòp peche pa yo. ");
INSERT INTO hat_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Men, lè sa a pitit pitit nou yo va rekonèt peche yo ak peche zansèt yo, peche yo te fè paske yo te refize fè sa m' te di yo fè, peche yo te fè paske yo te kenbe tèt avè m'. ");
INSERT INTO hat_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Se poutèt sa mwen menm tou, mwen te kenbe tèt ak yo, mwen te mennen yo prizonye nan peyi lènmi yo. Lè sa a, moun ki te gen lògèy plen kè yo va soumèt devan m', y'a peye pou sa yo te fè a. ");
INSERT INTO hat_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Mwen menm m'a chonje kontra mwen te pase avèk Jakòb, avèk Izarak epi avèk Abraram. Wi, m'a chonje pwomès mwen te fè yo ak peyi mwen te di m'ap ba yo a. ");
INSERT INTO hat_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Men, yo gen pou yo pati byen lwen, pou yo kite peyi a san moun pou tè a ka pran repo li. Wi, y'a peye pou sa yo te fè a, paske yo pa t' swiv prensip mwen te ba yo, paske yo te voye kòmandman m' yo jete. ");
INSERT INTO hat_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Men, menm lè sa a, antan yo la toujou nan peyi lènmi yo, mwen p'ap meprize yo, mwen p'ap lage yo jouk pou m' ta fini ak yo nèt. Mwen p'ap kase kontra m' pase ak yo a. Paske se mwen menm ki Seyè a, Bondye yo a. ");
INSERT INTO hat_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Men, m'a fè pa yo, m'a chonje kontra mwen te pase avèk zansèt yo lè mwen te fè yo soti kite peyi Lejip devan je moun lòt nasyon yo pou m' te ka Bondye yo. Se mwen menm ki Seyè a! ");
INSERT INTO hat_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Men tout prensip, tout lòd ak tout kòmandman Seyè a te bay Moyiz lòd mete nan kontra li te siyen ak moun pèp Izrayèl yo sou mòn Sinayi a. ");
INSERT INTO hat_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","-Pale ak moun pèp Izrayèl yo, w'a di yo pou mwen: Lè yon moun pran angajman pou l' ofri yon moun bay Seyè a, se nou menm ki pou fikse kantite lajan pou yo bay nan plas moun lan, dapre sistèm yo sèvi nan tanp lan. ");
INSERT INTO hat_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Men ki jan n'a fè sa: Pou yon gason ki gen ant ventan al swasantan, se va senkant pyès ajan. ");
INSERT INTO hat_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Pou yon fanm menm laj la, se va trant pyès ajan ");
INSERT INTO hat_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Pou yon jenn gason ki gen ant senkan al ventan, se va vin pyès ajan. Pou yon jenn fi ki gen menm laj la, se va dis pyès ajan. ");
INSERT INTO hat_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Pou yon timoun ki gen ant yon mwa al senkan, si se yon gason se va senk pyès ajan. Pou yon ti fi menm laj la, se va twa pyès ajan ");
INSERT INTO hat_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Pou yon gason ki depase swasantan, se va kenz pyès ajan. Pou yon fanm menm laj la, se va dis pyès ajan. ");
INSERT INTO hat_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Men, si moun ki te pran angajman an pa gen kont lajan pou peye valè nou mande a, l'a mennen moun li te pwomèt bay la bay prèt la. Prèt la va fè yon lòt pri, dapre sa moun lan ka peye. ");
INSERT INTO hat_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Si se yon bèt yon moun pran angajman pou l' ofri bay Seyè a, nenpòt kisa l'a bay Seyè a va rete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Li p'ap ka chanje yon move pou yon bon. Li p'ap ka bay yon lòt bèt nan plas sa li te pwomèt la. Si li fè sa, tou de bèt yo, ni sa li te di l'ap bay anvan an, ni sa li ta vle bay nan plas li a, va rete apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Men, si bèt li te pran angajman ofri a se yon bèt ki pa ka sèvi ofrann pou Seyè a, l'a mennen bèt la bay prèt la. ");
INSERT INTO hat_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Prèt la va fè pri bèt la dapre jan l' wè bèt la. Lè l'a fin fè pri bèt la, pri l' mande a, se sa y'a peye pou li. ");
INSERT INTO hat_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Men, si moun ki te fè ofrann lan ta vle achte bèt la ankò, l'a peye pri prèt la te fikse a plis ven pou san (020%) lavalè. ");
INSERT INTO hat_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Lè yon moun ap mete kay li apa pou Seyè a, prèt la va fè pri kay la dapre jan l' wè kay la. Lè l'a fin fè pri a, pri l' mande a, se sa pou yo bay. ");
INSERT INTO hat_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Men, si moun k'ap mete kay la apa pou Seyè a ta vle achte kay la ankò, l'a peye pri prèt la te fikse a, plis ven pou san (020%) lavalè. Epi y'a renmèt li kay li. ");
INSERT INTO hat_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Si yon moun pran yon pòsyon nan jaden l' epi li mete l' apa pou Seyè a, w'a fè pri pòsyon tè a dapre kantite grenn yo ka simen ladan l'. Pou chak barik grenn lòj yo ka simen, l'a bay dis pyès ajan. ");
INSERT INTO hat_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si li fè ofrann lan apre yo fèk fin fete lanne rejwisans lan, se pou l' peye tout pri a nèt. ");
INSERT INTO hat_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Men, si li fè l' kèk tan apre yo fin fete lanne rejwisans lan, prèt la va kalkile pri a sou kantite lanne ki rete anvan yo fete lanne rejwisans k'ap vini an, konsa l'a desann premye pri li te bay la. ");
INSERT INTO hat_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Si moun ki mete pòsyon tè a apa pou Seyè a ta vle achte tè a ankò, l'a peye pri yo te bay pou tè a plis ven pou san (020%). Epi tè a va rete pou li. ");
INSERT INTO hat_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Men, si yo te gen tan vann tè a bay yon lòt moun anvan li menm li te mande achte l' ankò, li p'ap ka achte l' ankò. ");
INSERT INTO hat_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Yon tè konsa, lè lanne rejwisans lan va rive, pase yo renmèt li nan men premye mèt li, l'ap rete yon bagay apa pou Seyè a, yon jaden pesonn p'ap ka manyen. L'a rete pou prèt yo. ");
INSERT INTO hat_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Si yon moun pran yon jaden li menm li te achte, yon jaden ki pa jaden eritye, epi li mete l' apa pou Seyè a, ");
INSERT INTO hat_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","prèt la va kalkile pri jaden an sou kantite lanne ki rete anvan yo fete lanne rejwisans k'ap vini an, epi moun lan va peye lajan an menm jou a. Lajan sa a va rete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Lè lanne rejwisans lan va rive, jaden an va tounen pou premye mèt la osinon pou pitit premye mèt la. ");
INSERT INTO hat_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Y'a fè tout pri yo dapre sistèm lajan yo sèvi nan kote yo mete apa pou Bondye a: yon gwo pyès pou ven ti pyès. ");
INSERT INTO hat_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Pesonn p'ap ka pran angajman pou yo ofri Seyè a premye pitit mal yon bèt fè paske li deja pou Seyè a. Kit se premye pitit bèf, kit se premye pitit mouton osinon kabrit, se pou Seyè a yo ye. ");
INSERT INTO hat_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Men, si se premye pitit yon bèt ki pa ka sèvi ofrann pou Seyè a, y'a ka achte l' ankò nan men Seyè a pou pri n'a fikse a, plis ven pou san (020%) lavalè. Men, si moun lan pa vle achte l' ankò pou tèt li, y'a vann yon lòt moun li pou pri n'a fikse a. ");
INSERT INTO hat_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Tou sa yon moun mete apa nèt pou Seyè a, kit se yon moun, kit se yon bèt, kit se yon jaden, li pa ka vann li ni li pa ka reachte l'. Bagay la fèt pou l' rete la, apa nèt pou Seyè a. Pesonn p'ap ka manyen l'. ");
INSERT INTO hat_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Si se yon moun yo vle ki pou rete apa nèt pou Seyè a, yo p'ap ka reachte l'. Se touye pou yo touye moun sa a. ");
INSERT INTO hat_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","N'a mete dis pou san (010%) nan tout rekòt jaden nou apa pou Seyè a, li te mèt rekòt jaden nou fè nou menm, osinon rekòt pyebwa ki donnen nan jaden nou. Se pou Seyè a dis pou san sa yo ye. ");
INSERT INTO hat_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si yon moun vle achte pou li menm kichòy nan dis pou san (010%) ki pou Seyè a, la peye pri bagay la plis ven pou san (020%) lavalè. ");
INSERT INTO hat_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Sou chak dis bèt, li te mèt bèf, kabrit osinon mouton n'ap gade, gen yonn ki pou Seyè a. Sa vle di lè n'ap konte bèf nou yo, n'a konte yo pa dis. Konsa, chak fwa nou rive sou dizyèm lan, n'a mete l' apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Nou pa bezwen konnen si li bon si li pa bon, ni nou pa bezwen pran yon lòt mete nan plas li. Si nou vle chanje yon bèt, ni sa nou ta vle chanje a, ni sa nou ta renmen bay nan plas li a, tou de va pou Seyè a. Epitou nou p'ap ka reachte yo ankò. ");
INSERT INTO hat_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Men tout regleman Seyè a te bay Moyiz pou moun pèp Izrayèl yo sou mòn Sinayi a. ");
INSERT INTO hat_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Premye jou dezyèm mwa nan dezyèm lanne depi moun pèp Izrayèl yo te soti kite peyi Lejip la, antan yo te nan dezè Sinayi a, Seyè a pale ak Moyiz nan Tant Randevou a. Li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","-Se pou ou menm ak Arawon, nou fè yon resansman pou konte tout moun nan pèp Izrayèl la, dapre fanmi yo, dapre branch fanmi yo. W'a pran non tout gason, yonn apre lòt. ");
INSERT INTO hat_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","N'a konte tou sa ki gen ventan osinon ki pi gran, depi yo bon pou fè lagè. N'a fè resansman an dapre jan lame a òganize. ");
INSERT INTO hat_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","N'a pran yon chèf nan chak branch fanmi, dapre zansèt yo, pou ede nou. ");
INSERT INTO hat_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Men non moun ki va ede nou nan resansman an: Nan branch fanmi Woubenn lan, se va Elizou, pitit gason Chedeyou. ");
INSERT INTO hat_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Nan branch fanmi Simeyon an, se va Cheloumyèl, pitit gason Sourichadayi. ");
INSERT INTO hat_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nan branch fanmi Jida a, se va Nakchon, pitit gason Aminadab. ");
INSERT INTO hat_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Nan branch fanmi Isaka a, se va Netanèl, pitit gason Swa. ");
INSERT INTO hat_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Nan branch fanmi Zabilon an, se va Eliyab, pitit gason Elon. ");
INSERT INTO hat_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Nan branch fanmi Efrayim, premye pitit gason Jozèf la, se va Elichama, pitit gason Amiyoud. Nan branch fanmi Manase, dezyèm pitit gason Jozèf la, se va Gamliyèl, pitit gason Pedachou. ");
INSERT INTO hat_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Nan branch fanmi Benjamen an, se va Abidan, pitit gason Gideyoni. ");
INSERT INTO hat_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Nan branch fanmi Dann lan, se va Ayezè, pitit gason Amichadayi. ");
INSERT INTO hat_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Nan branch fanmi Asè a, se va Pagiyèl, pitit gason Okran. ");
INSERT INTO hat_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Nan branch fanmi Gad la, se va Elyasaf, pitit gason Dewèl. ");
INSERT INTO hat_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nan branch fanmi Neftali a, se va Ayira, pitit gason Enan. ");
INSERT INTO hat_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Se moun sa yo yo te chwazi nan pèp la pou fè travay la. Se yo ki te chèf lakay yo, chèf branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moyiz ak Arawon pran douz mesye Bondye te nonmen yo, ");
INSERT INTO hat_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","yo reyini tout pèp la, premye jou dezyèm mwa a. Yo pran non tout moun dapre fanmi yo, dapre branch fanmi zansèt yo. Yo konte tout gason, yonn apre lòt, tou sa ki gen ventan osinon ki pi gran, ");
INSERT INTO hat_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","dapre lòd Seyè a te bay Moyiz la. Se nan dezè Sinayi a yo te fè resansman tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Se konsa yo konte tout gason nan branch fanmi Woubenn, premye pitit Jakòb la, tou sa ki gen ventan ak tou sa ki pi gran epi ki bon pou fè lagè. Yo pran non yo yonn apre lòt, yo di pitit ki moun yo ye, dapre fanmi yo, dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Yo jwenn karannsimil senksan (046.500) gason pou branch fanmi Woubenn lan. ");
INSERT INTO hat_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Yo fè menm bagay la tou pou tout lòt branch fanmi yo. Pou branch fanmi Simeyon an, ");
INSERT INTO hat_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","yo jwenn senkantnèfmil twasan (059.300) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Pou branch fanmi Gad la, ");
INSERT INTO hat_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","yo jwenn karannsenkmil sisansenkant (045.650) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Pou branch fanmi Jida a, ");
INSERT INTO hat_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","yo jwenn swasannkatòzmil sisan (074.600) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Pou branch fanmi Isaka a, ");
INSERT INTO hat_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","yo jwenn senkannkatmil katsan (054.400) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Pou branch fanmi Zabilon an, ");
INSERT INTO hat_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","yo jwenn senkannsètmil katsan (057.400) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Pou branch fanmi Efrayim, premye pitit gason Jozèf la, ");
INSERT INTO hat_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","yo jwenn karantmil senksan (040.500) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Pou branch fanmi Manase, dezyèm pitit gason Jozèf la, ");
INSERT INTO hat_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","yo jwenn tranndemil desan (032.200) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Pou branch fanmi Benjamen an, ");
INSERT INTO hat_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","yo jwenn trannsenkmil katsan (035.400) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Pou branch fanmi Dann lan, ");
INSERT INTO hat_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","yo jwenn swasanndemil sètsan (062.700) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Pou branch fanmi Asè a, ");
INSERT INTO hat_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","yo jwenn karanteyenmil senksan (041.500) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Pou branch fanmi Neftali a, ");
INSERT INTO hat_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","yo jwenn senkanntwamil katsan (053.400) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Se non tout moun sa yo Moyiz ak Arawon te pran lè sa a. Te gen douz chèf, yonn pou chak branch fanmi pèp Izrayèl la, ki t'ap ede yo nan travay la. ");
INSERT INTO hat_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Pou tout branch fanmi yo ansanm, ");
INSERT INTO hat_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","yo jwenn sisantwamil senksansenkant (0603.550) gason. ");
INSERT INTO hat_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Men yo pa t' fè resansman branch fanmi Levi a ansanm ak lòt branch fanmi yo, ");
INSERT INTO hat_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","paske Seyè a te di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","-Ou pa bezwen fè resansman branch fanmi Levi a. Ou pa bezwen konte moun fanmi Levi yo ansanm ak rès moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Men, w'a mete moun fanmi Levi yo reskonsab Tant Randevou a ak tou sa ki ladan l' ansanm ak tou sa ki pou li. Se yo ki pou pote l' ansanm ak tou sa ki ladan l'. Se yo ki pou sèvi ladan l' epi yo gen pou yo moute kay yo fè wonn Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Lè pou Tant Bondye a deplase, se moun fanmi Levi yo ki va demoute l'. Lè yo rive kote pou yo rete a, se moun fanmi Levi yo ki va moute l' tou. Nenpòt lòt moun ki pa nan branch fanmi Levi a epi ki ta pwoche bò tant lan, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Lòt moun pèp Izrayèl yo menm va moute tant yo apa, chak fanmi ansanm bò làbanyè yo, dapre pozisyon yo nan lame a. ");
INSERT INTO hat_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Men, moun fanmi Levi yo va moute kay yo fè wonn Tant Randevou a pou kòlè Bondye pa tonbe sou pèp Izrayèl la. Se yo menm tou ki la pou veye sou Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Moun pèp Izrayèl yo te fè tou sa Seyè a te bay Moyiz lòd fè a. Se konsa yo te fè l' vre. ");
INSERT INTO hat_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","-Lè moun pèp Izrayèl yo va rive yon kote pou yo rete, chak moun va moute tant yo toupre làbanyè yo, anba ti drapo branch fanmi zansèt yo. Y'a moute tant yo devan ak sou kote Tant Randevou a, men pa twò pre l'. ");
INSERT INTO hat_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Tout moun k'ap mache anba làbanyè Jida a va moute kan yo sou bò solèy leve, chak divizyon apa. Se Nakchon, pitit gason Aninabad la, ki te chèf fanmi Jida a. ");
INSERT INTO hat_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Dapre resansman an, te gen swasannkatòzmil sisan (074.600) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Moun Isaka yo va moute kan yo sou menm bò a, adwat moun Jida a yo. Se Netanèl, pitit gason Swa a, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Dapre resansman an, te gen senkannkatmil katsan (054.400) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Moun Zabilon yo va moute kan yo sou menm bò a tou, agoch moun Jida yo. Se Eliyab, pitit gason Elon an, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Dapre resansman an, te gen senkannsètmil katsan (057.400) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Konsa, anba làbanyè Jida a, te gen twa divizyon. Sa te fè antou sankatrevensimil katsan (0186,400) gason. Se toujou yo menm ki pou mache devan lè y'ap deplase. ");
INSERT INTO hat_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Tout moun k'ap mache anba làbanyè Woubenn yo va moute kan yo sou bò sid, chak divizyon apa. Se Elisou, pitit gason Chedeyou a, ki te chèf fanmi Woubenn lan. ");
INSERT INTO hat_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Dapre resansman an, te gen karannsimil senksan (046.500) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Moun Simeyon yo va moute kan yo sou menm bò a, adwat moun Woubenn yo. Se Cheloumyèl, pitit gason Sourichadayi a, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Dapre resansman an, te gen senkannèfmil twasan (059.300) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Moun Gad yo va rete sou menm bò a, agoch moun Woubenn yo. Se Elyasaf, pitit gason Reouyèl la, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Dapre resansman an, te gen karannsenkmil sisan (045.600) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Konsa, anba làbanyè Woubenn lan te gen twa divizyon. Sa te fè antou sansenkanteyenmil katsansenkant (0151.450) gason. Se toujou yo menm ki pou mache an dezyèm pozisyon lè y'ap deplase. ");
INSERT INTO hat_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Lè tout moun ap deplase, y'a mache nan menm pozisyon yo mete yo lè y'ap moute kan yo, anba làbanyè yo: de divizyon devan, de divizyon dèyè ak fanmi Levi yo nan mitan ap pote Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Tout moun k'ap mache anba làbanyè Efrayim lan va moute kan yo sou solèy kouche, chak divizyon apa. Se Elichama, pitit gason Amiyoud la, ki te chèf fanmi Efrayin lan. ");
INSERT INTO hat_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Dapre resansman an, te gen karantmil senksan (040.500) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Moun Manase yo va moute kan yo sou menm bò a, adwat moun Efrayim yo. Se Gamliyèl, pitit gason Pedachou a, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Dapre resansman an, te gen tranndemil desan (032.200) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Moun Benjamen yo va moute kan yo sou menm bò a tou, agoch moun Efrayim yo. Se Abidan, pitit gason Gideyoni a, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Dapre resansman an, te gen trannsenkmil katsan (035.400) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Konsa, anba làbanyè Efrayim lan, te gen twa divizyon. Sa te fè antou san witmil san (0108.100) gason. Se toujou yo menm ki pou mache an twazyèm pozisyon lè y'ap deplase. ");
INSERT INTO hat_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Tout moun k'ap mache anla làbanyè Dann lan va moute kan yo sou bò nò, chak divizyon apa. Se Ayezè, pitit gason Amichadayi a, ki te chèf fanmi Dann lan. ");
INSERT INTO hat_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Dapre resansman an, te gen swasanndemil sètsan (062.700) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Moun Asè yo va moute kan yo sou menm bò a, adwat moun Dann yo. Se Pagiyèl, pitit gason Okran an, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Dapre resansman an, te gen karanteyenmil senksan (041.500) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Moun Neftali yo va moute kan yo sou menm bò a tou, agoch moun Efrayim yo. Se Ayira, pitit gason Enan an, ki te chèf fanmi yo a. ");
INSERT INTO hat_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Dapre resansman an, te gen senkanntwamil katsan (053.400) gason nan divizyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Konsa, anba làbanyè Dann lan, te gen twa divizyon. Sa te fè antou sansenkannsètmil sisan (0157.600) gason. Se toujou yo menm ki pou mache dèyè nèt, chak divizyon anba drapo pa yo. ");
INSERT INTO hat_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Men kantite gason yo te jwenn nan pèp Izrayèl la dapre branch fanmi zansèt yo. Dapre resansman yo te fè a, divizyon pa divizyon, te gen sisantwamil senksansenkant (0603.550) gason antou. ");
INSERT INTO hat_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Men yo pa t' konte moun branch fanmi Levi yo ansanm ak rès moun pèp Izrayèl yo, dapre lòd Seyè a te bay Moyiz la. ");
INSERT INTO hat_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Moun pèp Izrayèl yo te fè tou sa Seyè a te bay Moyiz lòd fè a. Se konsa yo moute kan yo, chak divizyon apa, anba làbanyè pa yo. Lè y'ap deplase, yo mache pa divizyon, chak moun ansanm ak branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Lè nou remoute nan tan Seyè a te pale ak Moyiz sou mòn Sinayi a, men moun ki te nan fanmi Arawon ak Moyiz. ");
INSERT INTO hat_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Men non pitit Arawon yo: se te Nadab, pi gran an. Apre li vin Abiyou, Eleaza ak Itama. ");
INSERT INTO hat_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Se yo menm Bondye te chwazi, li te ba yo pouvwa pou yo te sèvi l' prèt. ");
INSERT INTO hat_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Men, Nabad ak Abiyou te mouri nan dezè Sinayi a, lè yo te ofri bay Seyè a yon dife yo pa t' gen dwa ofri ba li. Yo pa te gen pitit. Konsa, se Eleaza ak Itama ki te sèvi prèt ansanm ak Arawon, papa yo. ");
INSERT INTO hat_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","-Fè moun fanmi Levi yo pwoche. Mete yo ansanm ak Arawon, prèt la, pou yo ka ede l' nan travay l'ap fè a. ");
INSERT INTO hat_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Y'a travay nan kay Bondye a, y'a fè tout kalite sèvis ki gen pou fèt pou Arawon ak pou pèp la devan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Yo va reskonsab tout bagay ki anndan Tant Randevou a. Y'a fè tout travay moun Izrayèl yo ta gen pou yo fè nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","W'a mete yo sou kont Arawon ak pitit gason l' yo. Wi, nan tout moun pèp Izrayèl yo, w'a pran moun fanmi Levi yo, w'a mete yo sou kont prèt yo pou toutan. ");
INSERT INTO hat_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Men, w'a bay Arawon ak pitit gason l' yo reskonsablite tout travay prèt yo. Si yon lòt moun ki pa prèt ta konprann pou li fè travay prèt yo, se pou yo touye l'. ");
INSERT INTO hat_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Seyè a pale ak Moyiz, li di l' ankò: ");
INSERT INTO hat_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","-Gade non! Nan tout moun pèp Izrayèl yo, mwen chwazi moun fanmi Levi yo. Mwen pran yo nan plas premye pitit gason moun pèp Izrayèl yo. Se pou mwen yo ye. ");
INSERT INTO hat_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Paske, tout premye pitit gason yo se pou mwen yo ye. Depi jou mwen te touye tout premye pitit gason moun peyi Lejip yo, mwen te mete tout premye pitit gason moun pèp Izrayèl yo apa pou mwen, ansanm ak tout premye ti mal bèt yo fè. Se pou mwen menm yo tout ye. Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Seyè a pale ak Moyiz nan dezè Sinayi a, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","-Ou pral fè resansman tout moun Levi yo, dapre fanmi yo, dapre branch fanmi zansèt yo. W'a konte tout gason depi sa ki gen yon mwa depi yo fèt jouk sa ki pi gran yo. ");
INSERT INTO hat_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moyiz fè resansman an dapre lòd Seyè a te ba l' a. Li konte yo jan Seyè a te di l' fè l' la. ");
INSERT INTO hat_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Men non twa pitit gason Levi yo: Se te Gèchon, Keyat ak Merari. ");
INSERT INTO hat_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Men non pitit Gèchon yo ak tout fanmi yo: Se te Libni ak Chimèyi. ");
INSERT INTO hat_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Men non pitit Keyat yo ak tout fanmi yo: Se te Amram, Jizeya, Ebwon ak Ouzyèl. ");
INSERT INTO hat_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Men non pitit gason Merari yo ak tout fanmi yo: Se te Makli ak Mouchi. Men non fanmi moun Levi yo, dapre non zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Te gen de fanmi nan branch Gèchon an: Se te pitit Libni yo ak pitit Chimeyi yo. Se tout fanmi Gèchon yo sa. ");
INSERT INTO hat_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Lè yo konte gason yo, depi sa ki te gen yon mwa depi yo fèt jouk sa ki pi gran yo, yo jwenn sètmil senksan (07.500) gason. ");
INSERT INTO hat_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Fanmi sa yo te rete dèyè kay Bondye a, sou bò solèy kouche. ");
INSERT INTO hat_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Se Elyasaf, pitit gason Layèl la, ki te chèf fanmi Gèchon yo. ");
INSERT INTO hat_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Se yo ki te reskonsab kay Bondye a, ak de tant ki kouvri l' yo, rido ki nan pòt devan Tant Randevou a, ");
INSERT INTO hat_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","rido pou galeri ki fè wonn Tant Randevou a ak lotèl la, rido ki nan pòt devan galeri a ak tout kòd yo bezwen pou sèvi nan kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Te gen kat fanmi nan branch Keyat la: Se te pitit Amram yo, pitit Jizeya yo, pitit Ebwon yo ak pitit Ouzyèl yo. Se tout fanmi Keyat yo sa. ");
INSERT INTO hat_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Lè yo konte tout gason yo, depi sa ki gen yon mwa depi yo fèt jouk sa ki pi gran yo, yo jwenn witmil sisan (08.600) gason. Se yo ki te reskonsab kote ki apa nèt pou Seyè a nan kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Fanmi sa yo te moute kan yo sou bò sid kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Se Elizafan, pitit gason Ouzyèl la, ki te chèf fanmi Keyat yo. ");
INSERT INTO hat_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Se yo ki te reskonsab Bwat Kontra a, tab la, gwo lanp sèt branch lan, lotèl yo ak tout bagay ki sèvi nan kote ki apa nèt pou Bondye a, rido yo ansanm ak tout bagay ki mache avèk rido yo. ");
INSERT INTO hat_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Se Eleaza, pitit gason Arawon, prèt la, ki te chèf tout chèf fanmi Levi yo. Se li ki te kontwole travay moun ki te reskonsab kote ki apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Te gen de fanmi nan branch fanmi Merari a: se te pitit Makli yo ak pitit Mouchi yo. Se tout fanmi Merari yo sa. ");
INSERT INTO hat_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Lè yo konte tout gason yo, depi sa ki gen yon mwa depi yo fèt jouk sa ki pi gran yo, yo jwenn simil desan (06.200) gason. ");
INSERT INTO hat_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Se Zouryèl, pitit gason Abikayil la, ki te chèf fanmi Merari yo. Yo te moute kan yo sou bò nò kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Se yo ki te reskonsab ankadreman pou soutni kay Bondye a, travès yo, poto yo, sipò yo ak tout rido yo ansanm ak tout bagay ki sèvi ak yo. ");
INSERT INTO hat_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Yo te reskonsab poto, sipò, pikèt ak kòd pou soutni galeri yo tou. ");
INSERT INTO hat_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moyiz, Arawon ak pitit gason l' yo te moute kay pa yo devan Tant Randevou a, sou bò lès. Se yo ki te reskonsab pou fè sèvis nan kote ki apa nèt pou Bondye a pou pèp Izrayèl la. Tout lòt moun ki ta konprann pou yo fè travay prèt yo, se pou yo touye yo. ");
INSERT INTO hat_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lè Moyiz ak Arawon te fè resansman moun fanmi Levi yo, chak fanmi apa, dapre lòd Seyè a te bay yo a, yo jwenn antou venndemil (022.000) gason, depi sa ki te gen yon mwa depi yo te fèt jouk sa ki pi gran yo. ");
INSERT INTO hat_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Seyè a di Moyiz konsa: -Pran non tout premye pitit gason moun pèp Izrayèl yo, depi sa ki gen yon mwa depi yo fèt jouk sa ki pi gran yo. W'a konte konbe ki genyen. ");
INSERT INTO hat_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Se mwen menm ki Seyè a. W'a pran moun fanmi Levi yo, w'a mete yo apa pou mwen nan plas tout premye pitit gason moun pèp Izrayèl yo. Konsa tou, w'a pran tout bèt ki pou moun fanmi Levi yo, w'a mete yo apa pou mwen nan plas premye ti mal bèt moun Izrayèl yo va fè. ");
INSERT INTO hat_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moyiz pran non tout premye pitit gason moun pèp Izrayèl yo, dapre lòd Seyè a te ba l' a. ");
INSERT INTO hat_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Li konte tout premye pitit gason yo, depi sa ki te gen yon mwa jouk sa ki pi gran yo. Li jwenn venndemil desanswasanntrèz (022.273). ");
INSERT INTO hat_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Apre sa, Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","-Pran moun fanmi Levi yo, mete yo apa pou mwen nan plas premye pitit gason moun pèp Izrayèl yo. Epi w'a mete bèt moun Levi yo apa pou mwen tou nan plas premye ti mal bèt moun pèp Izrayèl yo va fè. Konsa, tout moun Levi yo va pou mwen. Se mwen menm ki Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Ou te jwenn te gen plis premye pitit gason nan pèp Izrayèl la pase te gen moun Levi. Te gen desanswasanntrèz (0273) an plis. Men sa pou yo peye pou sove lavi desansousanntrèz premye pitit gason sa yo. ");
INSERT INTO hat_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Pou yo chak, y'a bay senk pyès ajan, dapre sistèm lajan yo sèvi nan kay Bondye a: vin gara pou yon pyès ajan. ");
INSERT INTO hat_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","W'a pran lajan yo peye pou sove lavi sa ki an plis yo, w'a bay Arawon ak pitit gason l' yo. ");
INSERT INTO hat_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Se konsa, Moyiz pran lajan yo te peye pou sove lavi premye pitit gason ki te an plis sou kantite moun Levi yo. ");
INSERT INTO hat_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Li pran mil twasanswasannsenk (01.365) pyès lajan nan men premye pitit moun Izrayèl yo, dapre sistèm lajan yo sèvi nan kote ki apa pou Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Apre sa, Moyiz pran tout lajan yo te peye pou sove lavi rès premye pitit gason yo, dapre lòd Seyè a te bay la, li bay Arawon ak pitit gason l' yo, jan Seyè a te ba li lòd la. ");
INSERT INTO hat_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","-Fè resansman tout pitit gason moun Keyat yo, nan branch fanmi Levi a, dapre fanmi yo, dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè travay ki gen pou fèt nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Men travay pitit gason Keyat yo va fè nan Tant Randevou a, kote yo mete apa nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Lè lè a rive pou pèp la ranmase zafè yo pou yo deplase, Arawon ak pitit gason l' yo va antre nan kay Bondye a, y'a desann rido ki devan Bwat Kontra a, y'a kouvri bwat la ak li. ");
INSERT INTO hat_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Y'a mete yon premye gwo nap an po bazann sou li, epi y'a kouvri l' ak yon dezyèm nap an twal ble. Apre sa, y'a pase manch pou pote bwat la nan gwo bag yo. ");
INSERT INTO hat_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Y'a kouvri tab pou pen yo ofri bay Bondye a ak yon dra ble. Y'a mete asyèt, tas, kafetyè ak bòl yo sèvi nan sèvis pou mwen yo sou li. Pen yo ofri bay Seyè a va toujou rete sou li tou. ");
INSERT INTO hat_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Y'a voye yon dra wouj sou li, y'a kouvri tout ak yon nap fèt ak po bazann, epi y'a pase manch pou pote tab la nan gwo bag yo. ");
INSERT INTO hat_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Y'a pran yon dra tou ble, y'a kouvri gwo lanp sèt branch lan ak tout ti lanp li yo, pensèt li yo, plat li yo ak veso pou lwil yo. ");
INSERT INTO hat_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Y'a vlope yo ansanm nan yon nap an po bazann, epi y'a mete l' sou yon branka pou pote l'. ");
INSERT INTO hat_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Apre sa, y'a mete yon dra ble sou lotèl an lò a, y'a kouvri l' nèt ak yon nap an po bazann, epi y'a pase manch pou pote lotèl la nan bag yo. ");
INSERT INTO hat_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Y'a pran tout bagay yo sèvi nan kote ki apa nèt pou Seyè a, y'a mete yo nan yon dra ble, y'a vlope yo nan yon nap an po bazann, epi y'a mete yo sou yon branka pou pote yo. ");
INSERT INTO hat_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Y'a wete sann ki sou lotèl la, epi y'a kouvri lotèl la ak yon dra wouj. ");
INSERT INTO hat_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Y'a pran tout bagay ki mache ak lotèl la: recho, pèl, fouchèt, plat pou resevwa sann, y'a mete yo sou lotèl la. Apre sa, y'a kouvri l' ak yon nap an po bazann, epi y'a pase manch pou pote lotèl la. ");
INSERT INTO hat_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Lè lè a va rive pou pèp la leve lamach, lè Arawon ak pitit gason l' yo va fin kouvri tout mèb ki nan kote ki apa nèt pou Seyè a, ansanm ak tout bagay ki mache ak yo a, se lè sa a gason moun Keyat yo va vin pran mèb yo pou pote yo. Moun Keyat yo pa gen dwa manyen bagay yo mete apa nèt pou Seyè a. Si yo fè sa, y'ap mouri. Se tout reskonsablite moun Keyat yo sa, lè y'ap deplase Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleaza, pitit gason Arawon, prèt la, va reskonsab kontwole lwil lanp yo, lansan santi bon an, pen yo toujou ofri bay Seyè a ak lwil pou mete moun apa a. Wi, l'a kontwole tout kay Bondye a nèt ak tou sa ki ladan l', menm kote ki apa nèt pou Seyè a ak bagay ki ladan l' yo. ");
INSERT INTO hat_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","-Pa kite anyen rive moun fanmi Keyat yo ki pou ta fè yo disparèt nan mitan moun Levi yo. ");
INSERT INTO hat_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Men sa pou nou fè pou yo pa mouri, pou yo ka viv, lè y'ap pwoche bò bagay ki apa nèt pou Seyè a. Arawon ak pitit gason l' yo va antre anvan epi y'a bay chak moun travay pa yo, y'a di yo sa pou yo pote. ");
INSERT INTO hat_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Men, moun Keyat yo pa janm gen dwa antre al gade lè y'ap vlope bagay ki apa nèt pou Seyè a. Si yo fè sa, y'ap mouri. ");
INSERT INTO hat_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","-Fè resansman tout pitit gason moun Gèchon yo tou, dapre fanmi yo, dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè travay ki gen pou fèt nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Men travay moun Gèchon yo, men sa pou yo pote: ");
INSERT INTO hat_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","lèz twal ki sèvi pou moute kay Bondye a ansanm ak gwo tant ki kouvri kay Bondye a, kouvèti fèt ak po bazann ki anwo tant lan, seri rido ki fèmen pòt Tant Randevou a, ");
INSERT INTO hat_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","rido galeri ki kouvri tant lan ak lotèl la nèt, rido ki fèmen galeri a, kòd yo ak tout lòt bagay ki mache ak bagay sa yo. Se yo ki pou fè tout travay ki gen rapò ak bagay sa yo. ");
INSERT INTO hat_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Moun Gèchon yo va travay sou lòd Arawon ak pitit gason l' yo. Y'a fè tout travay yo, y'a pote tou sa yo gen pou yo pote. Y'a reskonsab tou sa y'ap pote a. ");
INSERT INTO hat_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Sa se tout reskonsablite moun Gèchon yo nan travay ki gen pou fèt nan Tant Randevou a. Se Itama, pitit gason Arawon, prèt la, ki va kontwole tou sa y'ap fè. ");
INSERT INTO hat_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Seyè a di Moyiz ankò: -W'a fè resansman tout pitit gason moun Merari yo, dapre fanmi yo, dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","W'a pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè travay ki gen pou fèt nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Se yo menm k'ap reskonsab pote ankadreman, travès, poto ak sipò kay Bondye yo, ");
INSERT INTO hat_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","poto, sipò, pikèt ak kòd pou galeri ki fè wonn tant lan, avèk tout bagay ki sèvi ak yo, ansanm ak tout zouti y'ap bezwen pou fè travay yo. Y'a bay chak moun non bagay la reskonsab pou l' pote a. ");
INSERT INTO hat_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Se tout reskonsablite moun Merari yo sa nan travay yo gen pou fè nan Tant Randevou a. Se Itama, pitit Arawon, prèt la, ki va ba yo sa pou yo fè. ");
INSERT INTO hat_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Dapre lòd Seyè a te bay la, Moyiz, Arawon ak chèf pèp Izrayèl yo te fè resansman gason nan fanmi Keyat yo, dapre fanmi yo ak dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Yo pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè pati gwoup moun k'ap travay nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Yo jwenn demil sètsansenkant (02.750) gason antou nan ");
INSERT INTO hat_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","tout fanmi Keyat yo. Se moun sa yo ki te la pou fè travay ki gen pou fèt nan Tant Randevou a. Se yo menm Moyiz ak Arawon te konte dapre lòd Seyè a te bay Moyiz la. ");
INSERT INTO hat_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Apre sa, yo fè resansman gason nan fanmi Gèchon yo, dapre fanmi yo ak dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Yo pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè pati gwoup moun k'ap travay nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Yo jwenn demil sisantran (02.630) gason ");
INSERT INTO hat_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","nan tout fanmi Gèchon yo. Se moun sa yo ki te la pou fè travay ki gen pou fèt nan Tant Randevou a. Se yo menm Moyiz ak Arawon te konte dapre lòd Seyè a te bay Moyiz la. ");
INSERT INTO hat_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Apre sa, yo fè resansman gason nan fanmi Merari yo, dapre fanmi yo ak dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Yo pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè pati gwoup moun k'ap travay nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Yo jwenn twamil desan (03.200) gason ");
INSERT INTO hat_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","nan tout fanmi Merari yo. Se moun sa yo ki te la pou fè travay ki gen pou fèt nan Tant Randevou a. Se yo menm Moyiz ak Arawon te konte dapre lòd Seyè a te bay Moyiz la. ");
INSERT INTO hat_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Se konsa Moyiz ak Arawon ak chèf pèp Izrayèl yo te fè resansman branch fanmi Levi yo, dapre fanmi yo ak dapre branch fanmi zansèt yo. ");
INSERT INTO hat_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Yo te pran non tout gason, depi sa ki gen trantan jouk sa ki gen senkantan, tou sa ki gen laj pou fè pati gwoup moun k'ap travay nan Tant Randevou a, osinon k'ap pote l' lè y'ap deplase. ");
INSERT INTO hat_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Yo jwenn antou witmil senksankatreven (08.580) gason. ");
INSERT INTO hat_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Se konsa, dapre lòd Seyè a te bay Moyiz pou pèp la, yo pran non chak gason moun Levi yo ak travay pou yo fè ak sa pou yo pote. Se Seyè a menm ki te bay Moyiz lòd fè resansman sa a. ");
INSERT INTO hat_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","-Bay moun pèp Izrayèl yo lòd pou yo mete deyò nan kan kote yo rete a tout moun ki gen move maladi po, moun ki gen ekoulman, osinon moun ki pa nan kondisyon pou sèvi Bondye paske yo manyen kadav moun mouri. ");
INSERT INTO hat_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Wi, se pou nou mete tout moun ki pa nan kondisyon pou sèvi m' yo deyò nan kan an, fanm kou gason, pou yo pa mete kan kote m'ap viv nan mitan pèp mwen an nan kondisyon li pa ka sèvi m'. ");
INSERT INTO hat_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Se konsa, moun pèp Izrayèl yo fè sa Seyè a te di Moyiz la. Yo mete tout moun sa yo deyò nan kan kote yo rete a. ");
INSERT INTO hat_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","-Pale ak moun pèp Izrayèl yo. Lè yon gason osinon yon fanm pa kenbe pawòl l' ak Seyè a, l' al fè yon bagay mal kont yon moun, l' antò. ");
INSERT INTO hat_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Moun ki antò a va rekonèt devan tout moun li te fè yon bagay mal, epi li va renmèt tout sa l' te pran an bay moun li te fè tò a plis vin pou san (020%) lavalè. ");
INSERT INTO hat_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Men, si moun li te fè tò a mouri san li pa kite yon fanmi pre ki pou resevwa sa y'ap renmèt l' a, y'a pran sa l'ap renmèt la, y'a ofri l' bay Seyè a pou prèt yo. Apre sa, moun lan ap toujou gen pou l' ofri bay Bondye yon belye mouton pou repare sa l' te fè ki mal la. ");
INSERT INTO hat_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Tout ofrann moun Izrayèl yo mete apa pou Seyè a va rete pou prèt y' al jwenn pou fè ofrann lan. ");
INSERT INTO hat_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Tout ofrann yon moun pote bay prèt la va rete pou prèt la. Tou sa yon moun pote renmèt va rete pou prèt la tou. ");
INSERT INTO hat_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","-Pale ak moun pèp Izrayèl yo. W'a di yo pou mwen: Sipoze madanm yon nonm lage kò l' nan dezòd, epi l'ap twonpe mari l', ");
INSERT INTO hat_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","si li kouche ak yon lòt gason san mari l' pa konn sa, si li te kache kò l' pandan li t'ap fè bagay ki mete l' nan kondisyon pou li pa ka fè sèvis pou Bondye a, kifè pa gen temwen ki pou pale kont li, ni yo pa t' kenbe l' nan men, ");
INSERT INTO hat_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","osinon si yon mari vin sispèk madanm li nan dezòd, kifè madanm lan pa nan kondisyon pou l' fè sèvis pou Bondye, kit madanm lan fè l' vre, kit li pa fè l', ");
INSERT INTO hat_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","nonm lan va mennen madanm lan bay prèt la, epi l'a pote ofrann madanm lan gen pou fè nan ka sa a: se va de liv farin lòj. Li p'ap bezwen vide lwil sou li, ni li p'ap bezwen mete lansan sou li, paske se yon ofrann l'ap fè paske li sispèk kichòy, se yon ofrann l'ap fè pou l' ka konn verite a. ");
INSERT INTO hat_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Apre sa, prèt la va fè madanm lan pwoche vin kanpe devan lotèl Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Prèt la va pran ti gout dlo nan kivèt la, l'a mete l' nan yon veso fèt an fè, l'a pran yon priz pousyè tè nan Tant Randevou a, l'a mete l' nan dlo a. ");
INSERT INTO hat_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Lèfini, l'a fè madanm lan kanpe devan lotèl Seyè a, l'a wete twal ki sou tèt madanm lan, epi l'a mete ofrann farin lan nan de pla men l' yo. Prèt la menm va kenbe nan men l' veso ki gen dlo anmè a, dlo ki bay madichon an. ");
INSERT INTO hat_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Prèt la va mande madanm lan pou li sèmante. L'a di l' konsa: Si ou pa kouche avèk okenn lòt gason pase avèk mari ou, si ou pa lage kò ou nan dezòd ki pou ta mete ou nan kondisyon pou ou pa ka fè sèvis pou Bondye, ou mèt bwè dlo anmè sa a, dlo ki bay madichon an, anyen p'ap rive ou. ");
INSERT INTO hat_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Men, si ou te lage kò ou nan dezòd vre, si ou pa nan kondisyon pou ou fè sèvis pou Bondye, paske ou te kouche ak yon gason ki pa mari ou, ");
INSERT INTO hat_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","se pou Seyè a fè tout moun pran non ou pou bay madichon. Se pou l' fè ou pa ka janm fè pitit. Se pou vant ou anfle. ");
INSERT INTO hat_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Se pou dlo anmè ki bay madichon an antre nan vant ou pou fè l' anfle, pou l' fè ou pa ka janm fè pitit. Madanm lan va reponn: -Mwen dakò. Se pou Seyè a fè m' sa vre, si m' antò! ");
INSERT INTO hat_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Lè sa a, prèt la va ekri sèman an yon kote, epi l'a lave kote li te ekri a ak dlo anmè a pou efase sa l' te ekri a. ");
INSERT INTO hat_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Apre sa, l'a fè madanm lan bwè dlo anmè ki bay madichon an, pou dlo a pase nan kò l' ba li gwo doulè nan vant. ");
INSERT INTO hat_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Prèt la va pran ofrann farin lan nan men madanm lan, l'a balanse l' devan Seyè a tankou yon ofrann, epi l'a mete l' sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Apre sa, l'a pran yon ponyen nan farin lan, l'a ofri l' bay Bondye, l'a boule l' sou lotèl la. Se konsa l'a mete tout farin lan nèt apa pou Seyè a. Apre sa, l'a fè fanm lan bwè dlo a. ");
INSERT INTO hat_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Si fanm lan te antò vre, si li te twonpe mari l', dlo a va desann nan kò l', l'a ba li gwo doulè. Vant li va anfle, li p'ap janm ka fè pitit ankò, epi non l' va sèvi pou bay madichon. ");
INSERT INTO hat_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Men, si fanm lan inonsan, si li te nan kondisyon pou fè sèvis Bondye, anyen p'ap rive l', l'ap toujou ka fè pitit. ");
INSERT INTO hat_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Se regleman sa a pou yo swiv lè yon fanm pran gason sou mari l', lè li lage kò l' nan dezòd pou l' fè sa li pa t' dwe fè, ");
INSERT INTO hat_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","osinon lè yon nonm sispèk madanm l' ap twonpe l'. L'a mennen madanm lan devan lotèl Seyè a, epi prèt la va fè sèvis sa a pou madanm lan. ");
INSERT INTO hat_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Mari a p'ap reskonsab anyen ki ka rive madanm lan. Men madanm lan, si l' antò, va pote chay peche l' la. ");
INSERT INTO hat_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","-Pale ak moun pèp Izrayèl yo, w'a di yo: Lè yon gason osinon yon fanm fè yon ve espesyal, ve nazareyen yo, pou li viv apa nèt pou Seyè a, ");
INSERT INTO hat_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","se pou l' rete san li pa bwè diven ni okenn bweson ki gen alkòl ladan l'. Ni li p'ap bwè vinèg ki fèt ak diven ni okenn lòt bweson fèmante, ni li p'ap bwè ji rezen. Ata rezen fre osinon rezen chèch li p'ap ka manje. ");
INSERT INTO hat_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pandan tout tan l'ap viv apa pou Bondye tankou yon nazareyen an, li pa gen dwa manje anyen ki soti nan pye rezen, pa menm grenn rezen an ak po a. ");
INSERT INTO hat_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Pandan tout tan li fè ve pou l' viv apa pou Bondye tankou yon nazareyen an, li pa gen dwa koupe cheve nan tèt li, ni fè labab. Se pou l' kenbe ve a pandan tout tan l'ap viv apa nèt pou Bondye a, jouk lè tan ve a bout. Se pou l' kite cheve nan tèt li pouse byen long san li pa janm koupe yo. ");
INSERT INTO hat_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Pandan tout tan l'ap viv apa pou Bondye a, piga li janm pwoche bò yon kadav moun mouri, ");
INSERT INTO hat_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","pa menm kadav papa l', osinon kadav manman l', kadav frè l', osinon kadav sè li. Li pa fèt pou li pwoche bò kadav moun mouri pou li pa mete tèt li nan kondisyon pou l' pa ka sèvi Bondye, paske avèk cheve ki nan tèt l' a, sa vle di l'ap viv apa nèt pou Bondye. ");
INSERT INTO hat_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Pandan tout tan l'ap viv apa pou Bondye a, se pou l' rete apa nèt pou Bondye. ");
INSERT INTO hat_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Si yon moun rete konsa, li tonbe li mouri devan yon nazareyen, devan yon moun ki t'ap viv apa nèt pou Seyè a san koupe cheve nan tèt li, nazareyen an ap twouve l' nan kondisyon pou l' pa ka sèvi Bondye ankò. Se pou l' tann sèt jou anvan l'a nan kondisyon pou l' ka fè sèvis Bondye ankò. Jou sa a, l'a koupe tout cheve nan tèt li. ");
INSERT INTO hat_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sou wityèm jou a, l'a pran de toutrèl osinon de pijon, l'a pote yo bay prèt la devan pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Prèt la va ofri yo bay Seyè a, yonn pou repare sa li te fè ki mal la, lòt la pou yo boule sou lotèl la. Se konsa l'a ofri bèt pou yo touye pou peche moun lan fè a akòz kontak li te gen avèk kadav moun mouri a. ");
INSERT INTO hat_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nonm lan va refè ve li te fè pou l' viv apa nèt pou Bondye a. Tou sa li te fè anvan an pa vo anyen ankò, paske ve li te fè a gate. Epi l'a pote yon ti mouton ki poko gen ennan pou yo ofri pou repare sa li te fè ki mal la. ");
INSERT INTO hat_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Men sèvis yon nazareyen va fè lè tan pou l' kenbe ve l' te fè a bout. Y'a mennen l' devan pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","L'a ofri twa bèt ki san okenn enfimite bay Seyè a: yon ti belye mouton ki poko gen ennan, yon ti fenmèl mouton ki poko gen ennan ak yon gwo belye mouton. Ti belye mouton an va sèvi ofrann pou boule nèt pou Seyè a, ti fenmèl mouton va sèvi ofrann pou wete peche, ak gwo belye mouton an va sèvi ofrann pou di Bondye mèsi. ");
INSERT INTO hat_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","L'a ofri tou yon panyen pen san ledven: pen gwo mit fèt avèk farin frans melanje ak lwil oliv ak ti pen plat ak lwil pase sou yo, ansanm ak ofrann grenn jaden ak ofrann diven ki mache ak yo. ");
INSERT INTO hat_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Prèt la va ofri yo pou li devan lotèl Seyè a. L'a fè sèvis pou repare sa moun lan te fè ki mal la, epi l'a boule ofrann l' a nan dife. ");
INSERT INTO hat_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","L'a touye belye mouton an, l'a ofri l' pou di Bondye mèsi ansanm ak panyen pen san ledven an. Lèfini, l'a fè ofrann grenn jaden ak ofrann diven ki mache ak yo a. ");
INSERT INTO hat_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Lè sa a, nazareyen an va koupe tout cheve nan tèt li devan pòt Tant Randevou a, l'a pran cheve yo, l'a mete yo nan dife kote ofrann pou di Bondye mèsi a ap boule. ");
INSERT INTO hat_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Apre nazareyen an fin fè sa, prèt la va pran jigo mouton yo te kwit la, yon pen gwo mit ak yon ti pen plat nan panyen an, l'a mete tou sa nan pla men nazareyen an. ");
INSERT INTO hat_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Lèfini, prèt la va balanse yo tankou yon ofrann devan Seyè a: pòsyon sa yo va yon bagay yo mete apa pou Bondye, y'a rete pou prèt la anplis vyann pwatrin lan ak jigo ki te pou li deja a. Apre sa, nazareyen an gen dwa bwè diven. ");
INSERT INTO hat_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Se tout regleman yo sa pou moun ki fè ve nazareyen yo swiv. Y'a fè ofrann yo bay Seyè a dapre ve yo te fè pou yo viv apa nèt pou Seyè a. Men, si yon moun pwomèt pou li ofri lòt bagay anplis sa yo mande l' la a, se pou l' fè tou sa li te pwomèt pou l' fè a. ");
INSERT INTO hat_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","-Pale ak Arawon ansanm ak pitit gason l' yo. W'a di yo men sa pou nou di lè n'ap beni pèp Izrayèl la: ");
INSERT INTO hat_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Se pou Seyè a beni nou, se pou l' pran swen nou. ");
INSERT INTO hat_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Se pou Seyè a fè nou santi li la avèk nou, se pou l' gen pitye pou nou. ");
INSERT INTO hat_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Se pou Seyè a fè nou wè jan li renmen nou, se pou l' ban nou kè poze. ");
INSERT INTO hat_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Se konsa y'a nonmen non m', y'a lapriyè nan pye m' pou pèp Izrayèl la, epi m'a beni yo. ");
INSERT INTO hat_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Jou Moyiz te fin moute kay Bondye a, li vide lwil sou li pou mete l' apa pou Bondye, li fè sèvis pou mete l' apa pou Bondye ansanm ak tout bagay ki mache avè l' nan tant lan, lotèl la ak tout bagay ki sèvi sou lotèl la. ");
INSERT INTO hat_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Apre sa, chèf fanmi moun Izrayèl yo, chèf douz branch fanmi pèp Izrayèl la, vin pote ofrann yo. Se chèf sa yo ki te reskonsab fè resansman an. ");
INSERT INTO hat_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Men sa yo te ofri bay Seyè a: sis kabwa ak douz towo bèf, ki vle di yon kabwa pou chak de chèf ak yon bèf pou chak chèf. Yo mennen yo devan kay Bondye a epi yo ofri yo bay Bondye. ");
INSERT INTO hat_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Lè sa a, Seyè a di Moyiz konsa: ");
INSERT INTO hat_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","-Ou mèt asepte kado sa yo nan men yo. W'a sèvi ak yo nan travay ki gen pou fèt nan Tant Randevou a. W'a bay moun fanmi Levi yo kabwa yo, dapre travay ki sou kont yo. ");
INSERT INTO hat_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Se konsa, Moyiz pran kabwa yo ak bèf yo, li bay moun Levi yo. ");
INSERT INTO hat_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Li bay moun fanmi Gèchon yo de kabwa ak kat bèf, dapre travay li konnen ki sou kont yo. ");
INSERT INTO hat_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Li bay moun fanmi Merari yo kat kabwa ak wit bèf, dapre travay li konnen ki sou kont yo, travay pou yo fè sou lòd Itama, pitit Arawon, prèt la. ");
INSERT INTO hat_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Men li pa bay noun Keyat yo anyen, paske se sou zepòl yo pou yo pote tout bagay ki nan kote ki apa nèt pou Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Chèf yo te fè lòt ofrann pou lotèl la, jou yo t'ap vide lwil sou li pou mete l' apa pou sèvis Bondye a. Yo mete ofrann yo devan lotèl la. ");
INSERT INTO hat_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Seyè a di Moyiz konsa: -Chèf yo va pote ofrann yo pou sèvis y'ap fè pou mete lotèl la apa pou mwen. Y'a vini yonn apre lòt, yonn chak jou. ");
INSERT INTO hat_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Chèf yo vini vre, yo fè ofrann yo yonn apre lòt. Premye jou a, se te tou pa Nakchon, pitit gason Aminadab la, chèf branch fanmi Jida a. ");
INSERT INTO hat_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Men sa li te ofri: yon bòl an ajan ki peze twa liv enka, yon plat an ajan ki peze yon liv twaka, dapre sistèm yo sèvi nan tanp lan. Ni bòl la ni plat la te plen farin frans melanje ak lwil ki te sèvi pou ofrann grenn jaden yo. ");
INSERT INTO hat_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Li te ofri tou yon kiyè an lò, ki peze yon ka liv, plen lansan, ");
INSERT INTO hat_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","yon jenn ti towo bèf, yon belye mouton ak yon ti mouton ki poko gen ennan, tou sa pou yo boule nèt pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Li te ofri ankò yon bouk pou yo touye pou repare sa yo fè ki mal, ");
INSERT INTO hat_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","de towo, senk belye, senk bouk, senk ti mouton ki poko gen ennan pou ofrann pou di Bondye mèsi. Se ofrann sa a Nakchon, pitit gason Anminadab la, te ofri bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Dezyèm jou a, se te tou pa Netanèl, pitit gason Zwa a, chèf branch fanmi Isaka a. ");
INSERT INTO hat_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Twazyèm jou a, se te tou pa Eliyab, pitit gason Elon an, chèf branch fanmi Zabilon an. ");
INSERT INTO hat_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Katriyèm jou a, se te pou pa Elizou, pitit gason Chedeyou a, chèf branch fanmi Woubenn lan. ");
INSERT INTO hat_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Senkyèm jou a, se te tou pa Cheloumyèl, pitit gason Sourichadayi a, chèf branch fanmi Simeyon an. ");
INSERT INTO hat_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Sizyèm jou a, se te tou pa Elyasaf, pitit gason Dewèl la, chèf branch fanmi Gad la. ");
INSERT INTO hat_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Setyèm jou a, se te tou pa Elichama, pitit gason Amiyoud la, chèf branch fanmi Efrayim lan. ");
INSERT INTO hat_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Uityèm jou a, se te tou pa Gamliyèl, pitit gason Pedachou a, chèf branch fanmi Manase a. ");
INSERT INTO hat_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Nevyèm jou a, se te tou pa Abidan, pitit gason Gideyoni an, chèf branch fanmi Benjamen an. ");
INSERT INTO hat_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Dizyèm jou a, se te tou pa Ayezè, pitit gason Amichadayi a, chèf branch fanmi Dann lan. ");
INSERT INTO hat_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Onzyèm jou a, se te tou pa Pagiyèl, pitit gason Okran an, chèf branch fanmi Asè a. ");
INSERT INTO hat_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Douzyèm jou a, se te tou pa Ayira, pitit gason Enan an, chèf branch fanmi Neftali a. ");
INSERT INTO hat_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Li ofri menm bagay ak Nakchon. ");
INSERT INTO hat_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Men ofrann tout chèf yo te pote pou lotèl la, jou yo t'ap vide lwil sou li pou mete l' apa pou sèvis Bondye a: douz bòl an ajan, douz plat an ajan, douz kiyè an lò. ");
INSERT INTO hat_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Chak bòl an ajan te peze twa liv enka, chak plat an ajan te peze yon liv twaka. Sa te fè antou swasant liv ajan, dapre sistèm yo sèvi nan tanp lan. ");
INSERT INTO hat_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Chak kiyè an lò pou lansan an te peze yon ka liv, dapre sistèm pèz yo sèvi nan kay Bondye a. Sa te fè antou pou douz kiyè yo twa liv lò. ");
INSERT INTO hat_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Men kantite bèt yo te ofri antou pou boule nèt pou Seyè a ansanm ak ofrann grenn jaden ki mache ak yo: douz towo, douz belye, douz ti mouton ki poko gen ennan. Yo te bay douz bouk tou pou yo touye pou repare sa yo fè ki mal. ");
INSERT INTO hat_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Men kantite bèt yo te ofri an total pou di Bondye mèsi: vennkat jenn ti towo, swasant belye, swasant bouk ak swasant ti mouton ki poko gen ennan. Se ofrann sa a yo te fè pou mete lotèl la apa nèt pou sèvis Seyè a, apre yo te fin vide lwil sou li. ");
INSERT INTO hat_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Chak fwa Moyiz te antre nan Tant Randevou a pou l' pale ak Seyè a, li te tande vwa Seyè a ki t'ap pale avè l' anwo kouvèti espesyal ki sou Bwat Kontra a, nan mitan de zanj cheriben yo. ");
INSERT INTO hat_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","-Pale ak Arawon. W'a di l' konsa: Lè l'ap fè moute sèt ti lanp yo sou pye gwo lanp sèt branch lan, ranje yo yon jan pou yo klere sou devan gwo lanp sèt branch lan. ");
INSERT INTO hat_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Arawon swiv lòd Seyè a te bay Moyiz la: li fè moute ti lanp yo pou yo ka klere sou devan gwo lanp sèt branch lan. ");
INSERT INTO hat_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Men ki jan gwo lanp lan te fèt: tout kò a nèt te fèt ak pi bon lò ki genyen. Yo te fè depi pye gwo lanp lan jouk flè yo nan yon sèl gwo moso lò, dapre modèl Seyè a te fè Moyiz wè nan vizyon an. ");
INSERT INTO hat_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Seyè a pale ak Mwiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","-Wete moun Levi yo nan mitan rès pèp Izrayèl la. Mete yo nan kondisyon pou yo ka fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Men ki jan w'a fè l': W'a pran nan dlo pou wete peche a, w'a voye l' sou yo. Apre sa, y'a koupe cheve ak pwal sou tout kò yo nèt, epi y'a lave rad ki sou yo. Se konsa y'a nan kondisyon pou fè sèvis pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Apre sa, moun Levi yo va pran yon jenn ti towo ansanm ak ofrann grenn jaden ki pou mache avè l' la, ki vle di ti gout farin frans melanje ak lwil. Ou menm, w'a pran yon dezyèm ti towo tou jenn pou ou touye pou repare sa yo fè ki mal. ");
INSERT INTO hat_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Apre sa, w'a fè moun Levi yo pwoche dèvan pòt Tant Randevou a, epi w'a fè tout moun pèp Izrayèl yo sanble. ");
INSERT INTO hat_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Y'a poze men yo sou tèt moun Levi yo. ");
INSERT INTO hat_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Lèfini, Arawon va pran moun Levi yo, l'a vire yo adwat, l'a vire yo agoch devan mwen menm, Seyè a, tankou yon ofrann espesyal moun pèp Izrayèl yo ap fè m' pou moun Levi yo ka fè sèvis mwen. ");
INSERT INTO hat_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Apre sa, moun Levi yo va poze men yo sou tèt ti towo bèf yo, w'a ofri yonn pou mande padon pou peche yo, w'a ofri lòt la pou yo boule nèt pou mwen. Se konsa y'a fè sèvis pou mande m' gras pou moun Levi yo. ");
INSERT INTO hat_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Mete moun Levi yo apa tankou yon kado espesyal moun yo fè m'. Mete yo sou zòd Arawon ak pitit gason l' yo. ");
INSERT INTO hat_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","W'a wete moun Levi yo nan mitan rès pèp Izrayèl la, konsa moun Levi yo va pou mwen nèt ale. ");
INSERT INTO hat_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Lè w'a fin mete moun Levi yo nan kondisyon pou fè sèvis pou mwen, lè w'a fin vire yo adwat agoch devan m', tankou yon kado espesyal moun yo fè m', y'a gen dwa pwoche vin fè travay yo nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","N'a wete yo nan mitan rès pèp Izrayèl la, n'a fè m' kado yo nèt. Mwen va pran yo pou mwen nan plas tout premye pitit gason moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Paske, tout premye pitit gason moun pèp Izrayèl yo ak tout premye ti mal bèt yo fè se pou mwen yo ye. Depi jou mwen te touye tout premye pitit moun peyi Lejip yo, wi depi jou sa a mwen mete premye pitit nou yo apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Koulye a, mwen pran moun Levi yo nan plas premye pitit moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mwen pran moun Levi yo tankou yon kado moun yo fè m', mwen renmèt yo nan men Arawon ak pitit gason l' yo pou yo fè travay moun Izrayèl yo gen pou yo fè nan Tant Randevou a, pou mande Bondye gras pou pèp la. Konsa, okenn malè p'ap rive tonbe sou pèp la paske yo p'ap janm bezwen pwoche twò pre kote ki apa nèt pou mwen nan tanp lan. ");
INSERT INTO hat_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Se konsa, Moyiz, Arawon ak tout pèp Izrayèl la mete moun Levi yo apa nèt pou Seyè a, jan li te bay Moyiz lòd la. Wi, yo te fè tou sa pou yo te fè pou moun Levi yo. ");
INSERT INTO hat_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Moun Levi yo fè sèvis pou peye pou tou sa yo te fè ki mal, yo lave rad ki sou yo. Arawon mete yo apa devan Seyè a, li vire yo adwat agoch devan Seyè a tankou yon kado espesyal pou Bondye, epi li fè sèvis pou mande gras pou yo te ka nan kondisyon sèvi Bondye. ");
INSERT INTO hat_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Apre sa, moun Levi yo antre al fè travay yo nan Tant Randevou a sou lòd Arawon ak pitit gason l' yo. Se konsa pèp la te fè pou moun Levi yo tou sa Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Seyè a pale ak Moyiz ankò, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","-Sa mwen pral di ou la a, se pou moun Levi yo: Depi yo rive laj vennsenkan y'a fè pati gwoup moun k'ap travay nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Lè y'a gen senkantan, y'a pran retrèt yo, yo p'ap reskonsab okenn travay ankò nan tant lan. ");
INSERT INTO hat_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Men, y'a gen dwa ede moun Levi parèy yo nan nenpòt travay y'ap fè nan Tant Randevou a. Men yo menm poutèt pa yo, yo p'ap reskonsab okenn travay ankò. Se konsa w'a bay moun Levi yo travay pou yo fè. ");
INSERT INTO hat_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nan premye mwa dezyèm lanne apre yo te soti kite peyi Lejip la, Seyè a pale ak Moyiz nan dezè Sinayi a, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","-Se pou tout moun pèp Izrayèl yo fete fèt delivrans lan dat mwen te di yo fete l' la. ");
INSERT INTO hat_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Katòzyèm jou premye mwa a, lè solèy fin kouche, n'a fete fèt la dapre tout lòd ak regleman mwen te ban nou pou sa. ");
INSERT INTO hat_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moyiz di pèp Izrayèl la pou yo fete fèt delivrans lan. ");
INSERT INTO hat_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Epi yo fete fèt la nan aswè katòzyèm jou premye mwa a, nan dezè Sinayi a. Pèp la fè tout bagay jan Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Men, vwala te gen kèk moun ki pa t' nan kondisyon pou fè sèvis pou Bondye, paske yo te manyen kadav yon moun mouri. Yo pa t' kapab fete fèt delivrans lan jou sa a. Yo leve, y' al jwenn Moyiz ak Arawon. ");
INSERT INTO hat_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Yo di yo: -Nou pa nan kondisyon pou nou fè sèvis pou Bondye, paske nou te manyen yon kadav moun mouri. Men, poukisa nou pa ta ka pote ofrann nou yo bay Seyè a jou sa a, ansanm ak tout moun pèp Izrayèl yo? ");
INSERT INTO hat_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moyiz reponn yo: -Rete tann jouk Seyè a va ban m' lòd sa pou m' di nou. ");
INSERT INTO hat_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","-Pale ak moun pèp Izrayèl yo, w'a di yo pou mwen: Lè yonn nan nou, osinon yonn nan pitit pitit nou yo, twouve li pa ta nan kondisyon pou fè sèvis pou Bondye, paske li te manyen kadav yon moun mouri, ou ankò si li ta nan vwayaj byen lwen, l'a toujou ka fete fèt Delivrans lan pou Bondye. ");
INSERT INTO hat_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Y'a tann katòzyèm jou dizyèm mwa a, lè sòlèy fin kouche, pou yo fè l'. Y'a manje manje Delivrans lan avèk pen san ledven yo epi ak fèy lanman. ");
INSERT INTO hat_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Yo p'ap gen dwa kite anyen pou denmen maten, ni yo pa fèt pou yo kraze okenn zo bèt yo touye a. Y'a fè tout bagay dapre regleman mwen bay pou fete fèt Delivrans lan. ");
INSERT INTO hat_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Men, si yon moun ki nan kondisyon pou fè sèvis pou mwen epi ki pa nan vwayaj ta rive pa fete fèt Delivrans lan, se pou yo mete l' deyò nèt nan mitan fanmi l' yo, paske li pa t' ofri ofrann li bay Seyè a dat pou l' te fè l' la. Se pou l' peye pou sa l' fè a. ");
INSERT INTO hat_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Si gen moun lòt nasyon k'ap viv nan mitan nou, li menm tou se pou l' fete fèt Delivrans Seyè a, dapre lòd ak regleman fèt la. Va gen yon sèl regleman pou tout moun, ni pou moun natif natal peyi a, ni pou moun lòt nasyon yo. ");
INSERT INTO hat_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Jou yo t'ap moute Tant Randevou a, yon nwaj vini epi li kouvri tant kote Bwat Kontra a ye a. Lè aswè rive, ou ta di yon gwo dife ki te parèt anwo tant lan jouk nan maten. ");
INSERT INTO hat_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Se konsa sa te toujou ye: lajounen nwaj la te kouvri l', lannwit li te klere tankou yon dife. ");
INSERT INTO hat_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Chak fwa nwaj la fè yon leve anwo tant lan, la menm moun pèp Izrayèl yo leve, epi yo pati. Lè li desann poze sou tant lan, yo rete, yo moute tant yo la. ");
INSERT INTO hat_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Konsa, se sou kòmandman Seyè a yo te leve pati, e se sou kòmandman li tou yo te rete moute tant yo. Toutotan nwaj la te rete anwo tant lan, yo menm tou, yo te rete kote yo te ye a. ");
INSERT INTO hat_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Si nwaj la te rete anpil jou anwo tant lan san deplase, moun pèp Izrayèl yo te swiv lòd Seyè a, yo menm tou yo pa t' deplase. ");
INSERT INTO hat_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Gen de fwa nwaj la pa t' rete lontan anwo tant lan san deplase. Men, se te toujou konsa: se sou kòmandman Seyè a yo te leve pati, se sou kòmandman li tou yo te rete moute tant yo. ");
INSERT INTO hat_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Gen de lè nwaj la rete sèlman pou yon nwit anwo tant lan, depi aswè jouk nan denmen maten. Leve nwaj la leve nan maten, yo menm tou yo leve, yo pati. Gen de fwa tou, li te rete yon jou yon nwit. Leve nwaj la leve, yo menm tou yo leve, yo pati. ");
INSERT INTO hat_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Toutotan nwaj la te rete la anwo tant lan san deplase, li te mèt de jou, yon mwa, yon lanne, yo menm tou, yo pa t' deplase. Men, leve nwaj la leve, yo leve, yo pati. ");
INSERT INTO hat_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Konsa, yo moute tant yo sou lòd Seyè a, yo leve yo pati sou lòd Seyè a: Yo te fè tou sa Seyè a te di Moyiz di yo fè. ");
INSERT INTO hat_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","-Fè yo fè de twonpèt an ajan pou ou. Y'a pran yon gwo moso ajan, y'a bat l' ak mato pou fè chak twonpèt yo. W'a sèvi ak yo pou avèti moun yo lè pou yo reyini ak lè lè a rive pou yo leve pati. ");
INSERT INTO hat_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Depi yo kònen twonpèt yo ansanm, se pou tout moun kouri reyini bò kote ou devan pòt Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si se yon sèl twonpèt yo kònen, se tout chèf branch fanmi yo ase ki va reyini bò kote ou. ");
INSERT INTO hat_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Lè y'a tande twonpèt yo kònen yon premye fwa ansanm ak bri moun k'ap rele, se va siyal pou branch fanmi ki rete bò solèy leve a leve pati. ");
INSERT INTO hat_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Lè y'a tande twonpèt yo kònen yon dezyèm fwa ansanm ak bri moun k'ap rele yo, se va siyal pou branch fanmi ki rete bò sid la leve pati. ");
INSERT INTO hat_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Men lè y'ap reyini tout moun yo, y'a kònen twonpèt yo sèlman, san pesonn pa bezwen rele. ");
INSERT INTO hat_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Se prèt yo, pitit gason Arawon yo, ki pou kònen twonpèt yo. Men regleman pou nou swiv tout tan tout tan, de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Lè nan peyi a, nou pral fè lagè kont lènmi ki vin atake nou, n'a kònen twonpèt yo epi n'a pouse rèl pou bay siyal batay la. Mwen menm Seyè a, Bondye nou an, m'a vin ede nou, m'a sove nou anba men lènmi nou yo. ");
INSERT INTO hat_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Konsa tou, lè kè nou kontan, lè n'ap fete fèt yo, lè premye jou chak mwa rive avèk lalin nouvèl lan, n'a kònen twonpèt yo tou pandan n'ap fè ofrann pou boule nèt pou Seyè a ak ofrann pou di Bondye mèsi. Lè sa a m'a vin ede nou. Se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ventyèm jou, dezyèm mwa nan dezyèm lanne depi pèp la te soti kite peyi Lejip, nwaj la rete, li leve anwo Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Epi moun pèp Izrayèl yo leve, yo pati, chak fanmi nan pozisyon yo te ba yo a. Yo kite dezè Sinayi a. Apre yon tan, nwaj la rete nan dezè Paran an. ");
INSERT INTO hat_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Se konsa yo konmanse vwayaje ankò sou kòmandman Seyè a, jan li te di Moyiz di yo sa pou l' a. ");
INSERT INTO hat_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Premye moun ki pati se moun k'ap mache dèyè làbanyè fanmi Jida a, chak divizyon apa. Alatèt divizyon branch fanmi Jida yo, se te Nakchon, pitit gason Aminadab la. ");
INSERT INTO hat_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Se Netanèl, pitit gason Swa a, ki te alatèt divizyon branch fanmi Isaka a. ");
INSERT INTO hat_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Epi se Eliyab, pitit gason Elon an, ki te alatèt divizyon branch fanmi Zabilon an. ");
INSERT INTO hat_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Apre sa, yo demoute tant lan, epi moun Gèchon yo ak moun Merari yo ki la pou pote tant lan pati. ");
INSERT INTO hat_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Apre yo, moun k'ap mache dèyè làbanyè fanmi Woubenn lan vini, chak divizyon apa. Alatèt divizyon branch fanmi Woubenn lan, se te Elizou, pitit gason Chedeyou a. ");
INSERT INTO hat_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Se Cheloumyèl, pitit gason Sourichadayi a, ki te alatèt divizyon branch fanmi Simeyon an. ");
INSERT INTO hat_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Epi se Elyasaf, pitit gason Dewèl la, ki te alatèt branch fanmi Gad la. ");
INSERT INTO hat_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Apre yo, se te moun Keyat yo ki reskonsab pou pote tout bagay ki apa nèt pou Bondye yo. Tan pou yo rive kote yo pral rete a, tant lan va gen tan moute ankò ap tann yo. ");
INSERT INTO hat_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Apre yo, moun k'ap mache dèyè làbanyè fanmi Efrayim lan vini, chak divizyon apa. Alatèt divizyon branch fanmi Efrayim lan, se Elichama, pitit gason Amiyou a, ki t'ap mache. ");
INSERT INTO hat_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Se Gamaliyèl, pitit gason Pedachou a, ki te alatèt divizyon branch fanmi Manase a. ");
INSERT INTO hat_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Epi se Abidan, pitit gason Gideyoni an, ki te alatèt divizyon branch fanmi Benjamen an. ");
INSERT INTO hat_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Apre yo, moun k'ap mache dèyè làbanyè fanmi Dann lan vini, chak divizyon apa. Se yo k'ap pwoteje tout pèp la pa dèyè nèt. Alatèt divizyon branch fanmi Dann lan se Ayezè, pitit gason Amichadayi a, ki t'ap mache. ");
INSERT INTO hat_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Se Pagiyèl, pitit gason Okran an, ki te alatèt divizyon branch fanmi Asè a. ");
INSERT INTO hat_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Epi se Ayira, pitit gason Enan an, ki te alatèt divizyon branch fanmi Neftali a. ");
INSERT INTO hat_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Men nan ki lòd moun pèp Izrayèl yo t'ap mache, chak divizyon nan pozisyon yo, lè yo leve pou yo pati. ");
INSERT INTO hat_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moyiz rele bòfrè l' a, Obab, pitit gason Ragèl, moun peyi Madyan an, li di l' konsa: -Nou pral pati la a pou n' ale nan peyi Seyè a te di l'ap ban nou an. Seyè a te pwomèt li t'ap fè anpil byen pou nou. Vini avèk nou non! N'a pataje tout byen nou yo avè ou. ");
INSERT INTO hat_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Obab reponn li: -Non. M'ap tounen nan peyi m' al jwenn fanmi m'. ");
INSERT INTO hat_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Moyiz di l' konsa: -Tanpri, pa kite nou pou kont nou. Se ou ki konnen dènye kote nou ka moute tant nou yo nan dezè a. W'a sèvi nou gid. ");
INSERT INTO hat_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Si ou vini ak nou, w'a gen pa ou nan tout byen Seyè a ap ban nou. ");
INSERT INTO hat_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Se konsa, pèp la leve li pati, li kite mòn Sinayi a, mòn Seyè a, yo mache twa jou. Epi Bwat Kontra Seyè a pran devan yo tout pou chache yon kote pou yo moute tant yo. ");
INSERT INTO hat_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Chak fwa y'ap kite yon kote pou yo ale yon lòt kote, nwaj Seyè a te rete anlè tèt yo nan syèl la tout lajounen. ");
INSERT INTO hat_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Chak fwa Bwat Kontra a pati, Moyiz di: -Leve non, Seyè! Gaye lènmi ou yo! Fè tout moun ki rayi ou yo kouri lè ou parèt! ");
INSERT INTO hat_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Lè Bwat Kontra a kanpe, Moyiz di: -Tounen non, Seyè! Vin rete nan mitan tout lame moun pèp Izrayèl yo! ");
INSERT INTO hat_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Pèp la te konmanse ap plenyen nan zòrèy Seyè a jan zafè yo pa t' bon. Lè Seyè a tande sa, li fè yon sèl kòlè, li voye dife sou pèp la. Dife a pran nan mitan yo, li boule yon bò nan kan an nèt. ");
INSERT INTO hat_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Pèp la rele Moyiz vin delivre yo. Moyiz lapriyè Seyè a pou yo epi dife a sispann. ");
INSERT INTO hat_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Se konsa yo rele kote yo te ye a Tabera, paske se la dife Seyè a te pran nan mitan yo a. ");
INSERT INTO hat_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Bann moun lòt nasyon ki te la nan mitan pèp Izrayèl la te anvi manje vyann. Pèp la menm te pran plenyen ankò, yo t'ap di: -Ki moun k'ap fè nou jwenn vyann pou nou manje koulye a? ");
INSERT INTO hat_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Jan nou te konn manje pwason pou gremesi nan peyi Lejip! Nou chonje kalite bon ti konkonm, melon dlo, powo, zonyon, ak lay nou te konn manje! ");
INSERT INTO hat_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Men koulye a, se deperi n'ap deperi. Nou pa gen anyen pou nou manje, anyen menm pase laman lan ki devan je nou tout tan! ");
INSERT INTO hat_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Laman lan te gen fòm grenn pitimi, li te blan epi ou ta di se gonm arabik. ");
INSERT INTO hat_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Pèp la ale toupatou, li ranmase yo. Apre sa, oubyen li te pase yo nan moulen wòch, oubyen li te pile yo nan pilon pou fè farin. Lèfini, yo kwit li nan chodyè, yo fè gato plat avè l'. Li te gen menm gou avèk pen ki fèt ak lwil oliv. ");
INSERT INTO hat_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Se lannwit laman lan te konn tonbe nan kan an, menm lè ak lawouze. ");
INSERT INTO hat_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moyiz te tande jan pèp la t'ap plenyen, chak moun ak fanmi yo devan papòt tant yo. Seyè a te fache anpil sou moun yo. Sa te fè Moyiz lapenn. ");
INSERT INTO hat_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Lè sa a, Moyiz di Seyè a konsa: -Poukisa ou aji mal avè m' konsa? Kisa m' fè ki pa fè ou plezi? Poukisa ou mete tout pèp sa a sou kont mwen? ");
INSERT INTO hat_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Eske se mwen ki papa yo? Eske se mwen ki manman yo? Poukisa w'ap mande m' pou mwen pote yo sou lestonmak mwen tankou nouris k'ap bay timoun tete, jouk yo rive nan peyi ou te pwomèt zansèt yo ou t'ap ba yo a? ");
INSERT INTO hat_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Kote pou m' jwenn vyann pou m' bay tout moun sa yo? Y'ap plede plenyen nan zòrèy mwen, y'ap mande m' pou m' ba yo vyann pou yo manje. ");
INSERT INTO hat_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Mwen pa kapab reskonsab tout pèp sa a pou kont mwen. Chay la twò lou pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Si se konsa w'ap aji avè m', tanpri, fè m' favè sa a: pito ou tou touye m' fin ak sa, pou m' pa wè m'ap pase tout malè sa a. ");
INSERT INTO hat_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Seyè a di Moyiz konsa: -Sanble swasanndis nan chèf fanmi pèp Izrayèl la, moun ou konnen ki gen otorite sou pèp la, ki konn bout yo. Mennen yo nan Tant Randevou a. Fè yo rete kanpe la avèk ou. ");
INSERT INTO hat_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","M'ap desann epi m'a pale avè ou. M'a pran ti gout nan lespri mwen te ba ou a, m'a ba yo. Konsa, y'a ede ou pote reskonsablite pèp la, ou p'ap pote chay la pou kont ou ankò. ");
INSERT INTO hat_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","W'a di pèp la menm: Pran nwit la pou nou pare kò nou pou nou ka fè sèvis pou mwen denmen maten. Epi n'a jwenn vyann pou nou manje. Seyè a te tande jan nou t'ap plenyen nan zòrèy li, jan nou t'ap di nou ta renmen jwenn vyann pou nou manje. Nou te pi bon lè nou te nan peyi Lejip. Koulye a, Seyè a pral ban nou vyann. Se pou nou manje l' ban mwen. ");
INSERT INTO hat_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Se pa sèlman yon jou, ni de jou, ni senk jou, ni dis jou, ni vin jou n'a jwenn vyann sa a pou nou manje. ");
INSERT INTO hat_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Se va pandan tout yon mwa. N'a gen pou nou manje l' jouk l'a soti nan twou nen nou, jouk n'a rebite l', paske nou te vire do bay Bondye ki te la nan mitan nou an, nou t'ap plenyen nan zòrèy li, nou t'ap di nou pa t' dwe janm soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moyiz di Seyè a: -Se sisanmil (0600.000) moun wi ki sou kont mwen. Epi ou di w'ap ba yo vyann kont pou yo manje yon mwa. ");
INSERT INTO hat_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kote pou yo jwenn kantite mouton ak bèf pou touye ki pou ta kont pou yo? Si yo ta ka ranmase tout pwason ki nan lanmè, ou kwè li ta ase pou yo? ");
INSERT INTO hat_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Seyè a di Moyiz: -Pa gen bagay mwen vle fè mwen pa ka fè! Talè konsa w'a wè si sa m' di a p'ap rive vre. ");
INSERT INTO hat_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Se konsa Moyiz soti, li di pèp la tou sa Seyè a te di l'. Li pran swasanndis nan chèf fanmi pèp Izrayèl la, li mete yo kanpe fè wonn kay Bondye a. ");
INSERT INTO hat_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Seyè a desann nan yon nwaj, li pale ak Moyiz ankò. Apre sa, li pran ti gout nan lespri li te bay Moyiz la, li bay swasanndis chèf yo. Lè lespri a vin sou yo, yo tonbe pale tankou pwofèt yo sou tout kalite bagay. Apre sa, yo sispann. ");
INSERT INTO hat_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Te gen de nan chèf fanmi yo te chwazi yo ki te rete nan kan an. Yo pa t' ale nan kay Bondye a. Yonn te rele Eldad, lòt la Medad. Lespri a te desann sou yo tou, yo t'ap pale pawòl Bondye a byen fò nan kan an. ");
INSERT INTO hat_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Yon jenn gason kouri al di Moyiz men Eldad ak Medad ap pale pawòl Bondye a byen fò nan kan an. ");
INSERT INTO hat_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Lè sa a Jozye, pitit gason Noun lan, ki te adjwen Moyiz nan tou sa l' t'ap fè depi li te jenn tibway, pran lapawòl, li pale ak Moyiz, li di l' konsa: -Msye Moyiz, fè yo sispann non! ");
INSERT INTO hat_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moyiz reponn li: -Kouman? Ou gen lè w'ap fè jalouzi pou mwen? Pa pito Seyè a te mete lespri l' sou tout pèp la pou yo te ka pale tankou pwofèt! ");
INSERT INTO hat_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Apre sa, Moyiz tounen nan kan an ansanm ak swasanndis chèf fanmi yo. ");
INSERT INTO hat_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Apre sa, Seyè a fè yon sèl van soufle sot nan lanmè, li bwote yon bann zòtolan ki vin tonbe toupatou nan kan kote moun yo te rete a ak toutotou kan an. Yon moun ta gen dwa mache tout yon jounen nan nenpòt direksyon anvan pou l' ta kite kote zòtolan yo te tonbe a. Zòtolan yo te fè pil rive twa pye wotè sou tè a. ");
INSERT INTO hat_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Pèp la pase tout jounen an, tout nwit la, ak tout jounen denmen an ap ranmase zòtolan. Sa ki te ranmase pi piti a te ranmase dis barik pou tèt pa l'. Yo blayi yo atè toupatou nan kan an pou mete yo cheche. ");
INSERT INTO hat_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Yo te fèk konmanse manje vyann, lè Seyè a fè kòlè sou pèp la, li lage yon sèl epidemi sou yo pou pini yo. ");
INSERT INTO hat_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Yo rele kote sa a: Simityè Grangou, paske se la yo te antere tout moun nan pèp la ki t'ap plenyen pou vyann. ");
INSERT INTO hat_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Apre sa, pèp la kite Simityè Grangou kote yo te ye a, yo pati pou Azewòt kote yo moute kay yo. ");
INSERT INTO hat_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Moyiz te marye ak yon fanm peyi Etiopi. Miryam ak Arawon t'ap pale Moyiz mal sou sa. ");
INSERT INTO hat_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Yo t'ap di konsa: -Eske se sèlman Moyiz Seyè a te pran pou pale ak pèp la? Eske li pa konn pale ak nou pou pèp la tou? Seyè a tande sa yo t'ap di a. ");
INSERT INTO hat_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Men Moyiz se yon nonm ki pa t' grandizè. pa t' gen pase l' sou latè. ");
INSERT INTO hat_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Seyè a rete konsa li pale ak Moyiz, Arawon ak Miryam, li di yo: -Nou twa sa yo, soti non. Ale nan Tant Randevou a. Yo twa a ale vre. ");
INSERT INTO hat_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Seyè a desann nan yon gwo nwaj ki te gen fòm yon poto. Li kanpe nan papòt tant lan, li rele Arawon ak Miryam ki pwoche vin jwenn li. ");
INSERT INTO hat_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Li di yo konsa: -Tande byen sa m'ap di nou la a. Lè gen yon pwofèt nan mitan nou, se nan vizyon mwen fè l' wè mwen, se nan rèv mwen pale avè l'. ");
INSERT INTO hat_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Men, se pa menm bagay la ak Moyiz, sèvitè m' lan. Li se sèl moun mwen fè konfyans nan mitan tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Mwen pale avè l' aklè, mwen pa ba li parabòl. Mwen fè l' wè mwen. Ki jan nou fè penmèt nou pale Moyiz, sèvitè m' lan, mal? ");
INSERT INTO hat_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Seyè a te fè yon sèl fache sou yo, epi l' ale. ");
INSERT INTO hat_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Nwaj la leve anwo tant lan, l' ale. Menm lè a, yon sèl maladi tonbe sou Miryam: tout po kò l' vin blanch kou koton. Arawon gade Miryam, li wè Miryam te kouvri ak bouton sou tout po li. ");
INSERT INTO hat_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Arawon di Moyiz konsa: -Tanpri, mèt mwen. Pa kite nou peye pou sa nou fè a. Tèt nou pa t' la! ");
INSERT INTO hat_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Tanpri, pa kite Miryam tounen tankou yon tibebe ki fèt tou mouri ak tout mwatye nan kò l' manje. ");
INSERT INTO hat_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Se konsa, Moyiz rele nan pye Bondye, li di l' konsa: -Bondye, tanpri, geri l' non! ");
INSERT INTO hat_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Men, Seyè a di Moyiz: -Si se te papa l' ki te krache nan figi l', li t'ap blije pote wont la pandan sèt jou, pa vre? Enben, se pou yo fèmen l' pou kont li pandan sèt jou yon kote andeyò limit kan an. Apre sa, y'a kite l' tounen. ");
INSERT INTO hat_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Yo fèmen Miryam pou kont li pandan sèt jou yon kote andeyò limit kan an. Pèp la pa t' leve pati toutotan yo pa t' kite Miryam tounen nan kan an ankò. ");
INSERT INTO hat_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Apre sa, pèp la kite Azewòt kote yo te ye a, yo pati al moute tant yo nan dezè Paran an. ");
INSERT INTO hat_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","-Ou pral chwazi douz nan chèf fanmi pèp Izrayèl yo, yonn pou chak branch fanmi. Ou pral voye yo pou y' al wè ki jan peyi Kanaran an ye, peyi m'ap bay moun Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Dapre lòd Moyiz te resevwa nan men Seyè a, li pran douz gason ki te chèf fanmi nan pèp Izrayèl la. Antan li te nan dezè Paran an, li voye yo al rekonèt peyi a. ");
INSERT INTO hat_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Men non yo: Pou branch Woubenn lan, se te Chamwa, pitit gason Zakou a. ");
INSERT INTO hat_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Pou branch fanmi Simeyon an, se te Chafa, pitit gason Ori a. ");
INSERT INTO hat_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Pou branch fanmi Jida a, se te Kalèb, pitit gason Jefoune a. ");
INSERT INTO hat_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Pou branch fanmi Isaka a, se te Jigal, pitit gason Jozèf la. ");
INSERT INTO hat_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Pou branch fanmi Efrayim lan, se te Oze, pitit gason Noun lan. ");
INSERT INTO hat_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pou branch fanmi Benjamen an, se te Palti, pitit gason Rafou a. ");
INSERT INTO hat_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Pou branch fanmi Zabilon an, se te Gadiyèl, pitit gason Sodi a. ");
INSERT INTO hat_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Pou branch fanmi Jozèf la, nan branch Manase a, se te Gadi, pitit gason Souzi a. ");
INSERT INTO hat_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Pou branch fanmi Dann lan, se te Amiyèl, pitit gason Jemali a. ");
INSERT INTO hat_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Pou branch fanmi Asè a, se te Setou, pitit gason Mikayèl la. ");
INSERT INTO hat_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Pou branch fanmi Neftali a, se te Nakbi, pitit gason Wopsi a. ");
INSERT INTO hat_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Pou branch fanmi Gad la, se te Geouyèl, pitit gason Maki a. ");
INSERT INTO hat_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Se te non douz mesye Moyiz te voye al rekonèt peyi Kanaran an. Moyiz te chanje non Oze, pitit gason Noun lan, li rele l' Jozye. ");
INSERT INTO hat_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Lè Moyiz voye yo ale nan peyi Kanaran an, li di yo: -Moute nan peyi a. N'a pase pa Negèv la, n'a pran chemen mòn pou nou. ");
INSERT INTO hat_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ale gade peyi a. Chache konnen ki jan li ye, ki kalite moun ki rete ladan l', konbe yo ye, ak ki fòs yo. ");
INSERT INTO hat_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Chache konnen si tè a se yon bon tè osinon yon move tè, si moun yo rete nan lavil ki gen ranpa pou pwoteje yo osinon nan kan anba tant twal. ");
INSERT INTO hat_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Chache konnen si peyi a rich osinon pòv, si gen anpil pyebwa sou tè a ou si pa genyen. Nou pa bezwen pè anyen. Lè n'ap tounen, pote kèk nan fwi ki donnen laba a. Se te sezon rezen te konmanse ap mi. ");
INSERT INTO hat_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Se konsa mesye yo moute, y' al chache konnen tout bagay ki gen nan peyi a, depi dezè Zin ki nan sid peyi a rive jouk Reyòb toupre pas Amat la, nan nò. ");
INSERT INTO hat_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Yo travèse zòn Negèv la, yo rive lavil Ebwon kote moun Ayiman yo, moun Chechayi yo ak moun Talmayi yo rete. Yo tout te fè pati ras moun Anak yo. Ebwon sa a, se yon lavil ki te bati sètan anvan yo te bati lavil Zoan nan peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Yo rive nan ravin Echkòl, yo koupe yon branch rezen ki te gen yon sèl gwo grap rezen nan li. Yo mete l' sou yon gòl pou de moun te ka pote l' sou zepòl yo, si tèlman li te lou. Yo pote grenad ak fig frans tou. ");
INSERT INTO hat_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Yo rele kote sa a Ravin Echkòl, poutèt gwo grap rezen moun pèp Izrayèl yo te koupe la a. ");
INSERT INTO hat_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Apre karant jou, lè yo fin vizite toupatou nan peyi a, yo tounen, ");
INSERT INTO hat_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","yo vin jwenn Moyiz, Arawon ak tout moun pèp Izrayèl yo Kadès, nan dezè Paran an. Yo detaye ba yo tou sa yo te wè, yo moutre yo fwi yo te pote yo. ");
INSERT INTO hat_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Yo di Moyiz konsa: -Nou vizite toupatou nan peyi ou te voye nou al chache konnen an. Se yon peyi ki rich anpil, kote lèt ak siwo myèl koule tankou dlo. Se vre wi. Gade fwi nou jwenn ladan l'. ");
INSERT INTO hat_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Men, moun ki rete nan peyi a gwonèg anpil. Lavil yo gran, yo byen pwoteje. Sa ki pi rèd nou wè yon kalite ras moun gwonèg bèl wotè. ");
INSERT INTO hat_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Moun Amalèk yo rete nan sid peyi a, nan zòn Negèv la. Moun It yo, moun Jebis yo ak moun Amon yo rete nan mòn yo. Moun Kanaran yo rete bò lanmè Mediterane a ak bò larivyè Jouden an. ");
INSERT INTO hat_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kalèb fè moun yo sispann bougonnen sou do Moyiz, li di yo konsa: -Ann moute koulye a. Ann al pran peyi a pou nou. Pa gen anyen la a nou pa ka fè! ");
INSERT INTO hat_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Men mesye ki te moute ansanm ak Kalèb yo di konsa: -Non. Nou pa ka al atake moun sa yo. Yo pi fò pase nou. ");
INSERT INTO hat_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Se konsa yo pran pale mal sou peyi yo te al vizite a devan pèp Izrayèl la. Yo t'ap di: -Peyi nou ta l' vizite a, peyi nou ta l' chache konnen an, se yon peyi ki pa menm bay kont manje pou moun k'ap viv sou li yo. Epi, tout moun nou wè la se moun ki wo anpil. ");
INSERT INTO hat_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Sa ki pi rèd, nou wè yon kalite gwonèg bèl wotè, moun ras Anak yo. Devan moun sa yo se krebete nou ye, tèlman nou piti. Se konsa nou te santi nou devan yo. ");
INSERT INTO hat_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Lè sa a, pèp la pran rele byen fò, yo pase tout nwit la ap kriye san rete. ");
INSERT INTO hat_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Yo tout t'ap bougonnen sou Moyiz ak Arawon. Yo vin di yo konsa: -Pito nou te mouri nan peyi Lejip osinon nan dezè a! ");
INSERT INTO hat_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Poukisa Seyè a mennen nou nan peyi sa a? Koulye a, yo pral touye nou nan lagè, yo pral pran madanm ak pitit nou yo fè yo tounen esklav. Pa pito nou tounen nan peyi Lejip? ");
INSERT INTO hat_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Yonn t'ap di lòt: -Ann chwazi yon lòt chèf! Ann tounen nan peyi Lejip! ");
INSERT INTO hat_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Lè Moyiz ak Arawon wè sa, yo tonbe fas atè devan tout pèp la ki te sanble la a. ");
INSERT INTO hat_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Lè sa a, de nan mesye espyon yo, Jozye, pitit gason Noun lan, ak Kalèb, pitit gason Jefoune a, chire rad ki te sou yo sitèlman yo te fache. ");
INSERT INTO hat_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Epi yo di pèp la: -Peyi nou te al vizite a se yon bon bon peyi. ");
INSERT INTO hat_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si Seyè a vle fè sa pou nou, l'ap fè nou antre nan peyi a, l'ap ban nou li. Se yon peyi ki rich anpil, yon peyi kote lèt ak siwo myèl koule tankou dlo. ");
INSERT INTO hat_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Sèlman, pa kenbe tèt ak Seyè a! Nou pa bezwen pè moun k'ap viv nan peyi sa a. N'ap manje yo tankou kann. Bondye ki t'ap pwoteje yo a kouri mete deyò. Men Seyè a kanpe la avèk nou. Nou pa bezwen pè yo. ");
INSERT INTO hat_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Lè sa a, tout pèp la ranmase wòch pou yo kalonnen Jozye ak Kalèb. Men, lamenm pouvwa Bondye a parèt anwo Tant Randevou a, li fè tout pèp la wè l'. ");
INSERT INTO hat_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Seyè a di Moyiz konsa: -Kilè pèp sa a va sispann meprize mwen? Kilè y'a soti pou yo fè m' konfyans? Gade tout bèl bagay mwen te fè pou yo. Malgre sa, yo pa vle kwè m' toujou! ");
INSERT INTO hat_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","M'ap voye yon sèl epidemi sou yo, m'ap touye yo tout. M'ap anpeche yo pran posesyon tè ki pou yo a. Men ou menm, m'ap fè ou tounen yon nasyon k'ap pi gwo, k'ap pi fò pase yo. ");
INSERT INTO hat_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Men, Moyiz di Seyè a konsa: -Se ou menm ak fòs ponyèt ou ki te fè pèp Izrayèl la soti kite peyi Lejip la. ");
INSERT INTO hat_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Lè moun pèyi Lejip yo va vin konnen sa ou pral fè pèp la, y'a rakonte l' bay moun ki rete nan peyi Kanaran yo. Yo menm tou, yo deja konnen se ou menm, Seyè, ki kanpe la nan mitan pèp la, se ou menm ki parèt aklè devan je yo, se nwaj ou, Granmèt, ki rete anwo yo. Se ou menm ki t'ap mache devan yo lajounen nan yon gwo nwaj ki te gen fòm yon poto, lannwit nan yon gwo flanm dife ki te gen fòm yon poto tou. ");
INSERT INTO hat_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Koulye a, si ou rete konsa ou touye tout pèp ou a, moun lòt nasyon yo ki te tande pale ki kalite moun ou ye, yo pral di ");
INSERT INTO hat_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","se kapab ou pa t' kapab mennen pèp la nan peyi ou te fè sèman w'ap ba yo a kifè ou touye yo nan dezè a. ");
INSERT INTO hat_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Non. Seyè! Se koulye a pou ou fè wè gwo pouvwa ou la, jan ou te pwomèt l' a, lè ou te di: ");
INSERT INTO hat_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Se mwen menm ki Seyè a, mwen pa an kòlè fasil, mwen p'ap janm sispann renmen nou. M'ap toujou padonnen sa nou fè ki mal ak sa nou te dwe fè nou pa fè. Men, mwen pa nan kase fèy kouvri sa ak pesonn. Si yon moun fè yon bagay mal, m'ap pini pitit li, pitit pitit li, ak pitit pitit pitit li yo pou sa li fè a, jouk sou twazyèm ak katriyèm jenerasyon. ");
INSERT INTO hat_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tanpri, jan ou gen bon kè sa a, padonnen sa pèp la fè ki mal la, menm jan ou te pran pasyans ak yo depi yo kite peyi Lejip jouk yo rive isit la. ");
INSERT INTO hat_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Seyè a di: -M'ap padonnen yo, jan ou mande m' lan. ");
INSERT INTO hat_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Men, menm jan ou wè mwen vivan an, menm jan ou wè pouvwa mwen toupatou sou latè, ");
INSERT INTO hat_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","okenn nan moun sa yo p'ap rive viv lontan ase pou yo antre nan peyi a. Yo te wè pouvwa mwen, yo te wè tout bèl bagay mwen te fè nan peyi Lejip ak nan dezè a. Men anpil fwa deja, yo chache wè jouk ki bò mwen ye ak yo, yo pa janm vle koute m' lè m' pale ak yo. ");
INSERT INTO hat_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Yo p'ap menm wè peyi mwen te sèmante mwen t'ap bay zansèt yo a. Yo tout ki vire do ban mwen yo, yo yonn p'ap wè peyi a. ");
INSERT INTO hat_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Men, paske Kalèb, sèvitè m' lan, pa aji tankou yo, li swiv mwen san gad dèyè, m'ap fè l' antre nan peyi li te al rekonèt la. Pitit pitit li yo va pran peyi a pou yo. ");
INSERT INTO hat_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Y'a rete nan plenn kote moun Amalèk yo ak moun Kanaran yo rete koulye a. Denmen n'ap fè bak, n'a tounen nan dezè a ankò nan direksyon Lanmè Wouj la. ");
INSERT INTO hat_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Apre sa, Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","-Kilè bann moun mechan sa yo va sispann bougonnen sou do mwen konsa? Mwen bouke tande jan moun pèp Izrayèl yo ap pale m' mal. ");
INSERT INTO hat_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Men sa pou ou di yo pou mwen: Se mwen menm menm, Seyè a, ki di sa. Menm jan nou wè m' vivan an, mwen fè sèman sa nou te di k'ap rive nou an, se li k'ap rive nou vre. ");
INSERT INTO hat_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Y'ap antere kadav nou tout nan dezè a. Nou tout ki t'ap bougonnen sou mwen yo, nou tout yo te konte lè resansman an, nou tout ki gen ventan ak sa ki pi gran yo, nou yonn p'ap antre nan peyi a. ");
INSERT INTO hat_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Dakò! Mwen te fè sèman mwen t'ap fè nou al rete nan peyi a. Men, nou yonn p'ap gen chans lan, esepte Kalèb, pitit gason Jefoune a, ak Jozye, pitit gason Noun lan. ");
INSERT INTO hat_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Nou te di pitit pitit nou yo pral tonbe anba men lènmi nou yo. Men, se yo menm m'ap fè antre nan peyi nou menm nou refize al pran an. ");
INSERT INTO hat_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Men, nou menm y'ap antere kadav nou yo isit nan dezè a. ");
INSERT INTO hat_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Pitit nou yo pral moute desann nan tout dezè a. Pandan karant lanne, y'a peye pou vire nou te vire do ban mwen an, jouk nou tout nèt n'a fin mouri nan dezè a. ");
INSERT INTO hat_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Nou menm, n'a peye konsekans peche nou an pandan karant lanne, yon lanne pou chak jou nan karant jou nou te pase ap vizite peyi a. Lè sa a, n'a konnen sa sa vle di lè m' vire do bay moun. ");
INSERT INTO hat_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Se mwen menm Seyè a ki di sa: Mwen fè sèman se konsa mwen pral aji ak bann moun sa yo ki mete tèt yo ansanm sou do m'. Yo tout gen pou yo disparèt nan dezè sa a. Wi, se la menm yo tout ap mouri. ");
INSERT INTO hat_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Mesye Moyiz te voye al rekonèt peyi a te fè tout pèp la ap bougonnen sou Moyiz avèk move rapò yo te fè sou peyi a, lè yo te tounen an. ");
INSERT INTO hat_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Se konsa yon sèl maladi tonbe sou mesye sa yo ki te pale peyi a mal konsa. Yo tonbe, yo mouri frèt devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nan douz mesye ki te al vizite peyi a, se de sèlman ki pa t' mouri: se te Jozye, pitit gason Noun lan, ak Kalèb, pitit gason Jefoune a. ");
INSERT INTO hat_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Lè Moyiz di moun pèp Izrayèl yo tout pawòl sa yo, sa te fè yo lapenn anpil. ");
INSERT INTO hat_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Nan denmen maten, byen bònè, yo leve pou y' al janbe lòt bò mòn yo pou yo antre nan peyi a. Yo t'ap di: -Men nou! Nou pare pou n' ale kote Seyè a di pou n' ale a. Nou rekonèt sa nou te fè a mal. ");
INSERT INTO hat_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Men Moyiz di yo: -Pouki pou n'ap dezobeyi lòd Seyè a ankò? Sa p'ap mache pou nou non, fwa sa a! ");
INSERT INTO hat_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Piga nou moute. Seyè a vire do ban nou, nou pa bezwen ale fè lènmi nou yo bat nou pou gremesi. ");
INSERT INTO hat_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Lè n'a rive devan moun Amalèk yo ak moun Kanaran yo, nou pral mouri nan batay la. Seyè a p'ap kanpe la avèk nou, paske nou te vire do ba li. ");
INSERT INTO hat_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Pèp la fè tèt di, yo moute moute yo sou mòn yo pou yo seye antre nan peyi a. Men, ni Bwat Kontra Seyè a, ni Moyiz pa deplase kote yo te ye nan kan an. ");
INSERT INTO hat_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Se konsa moun Amalèk yo ak moun Kanaran yo ki te rete nan mòn yo desann, yo bat yo, yo kouri dèyè yo jouk yon kote yo rele Oma. ");
INSERT INTO hat_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Seyè a pale ak Moyiz ankò, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","-Pale ak moun pèp Izrayèl yo, w'a di yo pou mwen: Lè n'a antre nan peyi mwen pral ban nou pou nou rete a, ");
INSERT INTO hat_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","lè n'ap ofri yon towo bèf, osinon yon mouton, oswa yon kabrit pou yo boule nèt nan dife pou Seyè a, tankou yon ofrann ki pou fè Seyè a plezi ak bon sant li, kit se paske nou te fè yon ve, kit se paske nou menm nou te fè lide fè yon ofrann, osinon paske lè fèt n'ap fete pou mwen yo rive, ");
INSERT INTO hat_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","wi, lè n'ap fè ofrann konsa pou Seyè a, n'a fè ofrann grenn ki donnen nan jaden pou mache ak yo tou: sèt ti mamit farin frans melanje avèk de boutèy ka plen lwil oliv. ");
INSERT INTO hat_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Lè n'ap fè ofrann pou yo boule nèt pou Seyè a, n'a ofri de boutèy ka plen diven pou chak ti mouton n'ap ofri. ");
INSERT INTO hat_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Lè se yon belye mouton n'ap ofri, se va katòz ti mamit farin frans melanje avèk twa boutèy ka plen lwil oliv n'a ofri pou ofrann grenn ki donnen nan jaden, ");
INSERT INTO hat_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ansanm ak twa boutèy ka diven. Ofrann sa yo, lè yo boule nan dife, y'a fè Seyè a plezi ak bon sant yo. ");
INSERT INTO hat_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Lè se yon jenn towo n'ap ofri pou yo boule nèt nan dife osinon pou yo touye pou Seyè a, kit se paske nou te fè yon ve, kit se pou di Bondye mèsi, ");
INSERT INTO hat_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","se pou nou pote yon ofrann grenn ki donnen nan jaden tou: venteyen ti mamit farin frans melanje ak senk ti boutèy ka lwil oliv. ");
INSERT INTO hat_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Lèfini, n'a ofri kat boutèy ka diven avèk li. Ofrann sa a, lè li boule nan dife, l'a fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Se sa pou nou bay ansanm ak chak jenn towo, chak belye mouton osinon chak bouk kabrit n'ap ofri. ");
INSERT INTO hat_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Pou chak bèt n'ap ofri an plis, n'a ofri kantite grenn jaden ki pou mache ak l' a. ");
INSERT INTO hat_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Se konsa chak moun natif natal peyi Izrayèl la gen pou fè l' lè y'ap ofri yon bèt pou boule nèt pou Seyè a, yon ofrann ki pou fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Lè yon moun lòt nasyon k'ap viv nan mitan nou pou yon ti tan, osinon pou tout tan, ap fè yon ofrann bay Bondye, yon ofrann pou yo boule nan dife epi ki pou fè Seyè a plezi ak bon sant li, se pou l' swiv menm regleman ak nou. ");
INSERT INTO hat_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Nan peyi a, se va yon sèl regleman pou tout moun, ni pou nou menm ni pou moun lòt nasyon k'ap viv nan mitan nou yo, yon sèl regleman pou tout tan, de pitit an pitit: Se va menm bagay la ni pou nou ni pou moun lòt nasyon yo devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Se va yon sèl lwa, yon sèl regleman ni pou nou ni pou moun lòt nasyon k'ap viv nan mitan nou yo. ");
INSERT INTO hat_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Apre sa Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","-Pale ak moun pèp Izrayèl yo. W'a di yo pou mwen: Lè n'a antre nan peyi kote mwen pral mennen nou an, ");
INSERT INTO hat_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","lè n'ap manje manje peyi a va bay, n'a wete yon pòsyon, n'a mete l' apa pou nou fè Seyè a kado. ");
INSERT INTO hat_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Chak lanne, apre rekòt la, n'a pran yon pen nan premye pen fèt ak ble nou fèk rekòlte a, n'a mete l' apa pou nou fè Seyè a kado, jan nou fè l' pou grenn ki pase sou glasi. ");
INSERT INTO hat_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Se pou nou toujou wete yon pen nan premye pen nou fè apre rekòt nou yo pou nou fè Seyè a kado. Se va yon lwa pou pitit ak pitit pitit nou yo, depi koulye a ak pou tout tan. ");
INSERT INTO hat_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Men, si san nou pa fè espre, nou pa swiv yonn nan lòd Seyè a te bay Moyiz yo, ");
INSERT INTO hat_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","lòd pou nou te toujou swiv de pitit an pitit depi jou li te voye Moyiz pale ak nou an, men sa pou yo fè: ");
INSERT INTO hat_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Si se tout pèp la ki fè sa l' pa t' dwe fè san li pa t' konnen sa l'ap fè a, yo tout ansanm y'a ofri yon jenn ti towo bèf pou yo boule nèt nan dife pou Seyè a. Se va yon ofrann pou yo boule nan dife pou fè Seyè a plezi ak bon sant li. Y'a ofri l' ansanm ak ofrann grenn jaden ak bwason ki pou mache avè l' la. Apre sa, y'a ofri yon bouk kabrit pou repare sa yo te fè ki mal la. ");
INSERT INTO hat_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Prèt la va pote ofrann lan devan Bondye, l'a touye bèt yo ofri pou peche tout moun pèp Izrayèl yo te fè a, epi Bondye va padonnen sa yo te fè a, paske yo pa t' fè espre, epi yo te pote ofrann pou yo te boule nan dife pou Seyè a ansanm ak ofrann pou repare sa yo te fè ki mal devan Seyè a san yo pa t' fè espre a. ");
INSERT INTO hat_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Se konsa Bondye va padonnen tout moun pèp Izrayèl yo ansanm ak tout moun lòt nasyon k'ap viv nan mitan yo, paske se yo tout ki te koupab nan sa yo te fè san yo pa konnen an. ");
INSERT INTO hat_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Si se yon moun ki fè sa l' pa t' dwe fè san li pa fè espre, l'a gen pou l' ofri yon ti fenmèl kabrit ki poko gen ennan pou repare pou sa l' te fè a. ");
INSERT INTO hat_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Prèt la va pote ofrann lan devan Seyè a, l'a touye bèt yo ofri pou peche moun lan te fè san li pa t' fè espre a, epi Bondye va padonnen l' sa l' te fè a. ");
INSERT INTO hat_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Se va menm regleman an pou tout moun ki fè bagay yo pa t' dwe fè san yo pa fè espre, kit se yon moun pèp Izrayèl la menm li ye, kit se yon moun lòt nasyon k'ap viv nan mitan yo a. ");
INSERT INTO hat_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Men, lè yon moun fè yon bagay li konnen byen pwòp li pa t' dwe fè, kit se yon moun pèp Izrayèl la menm li ye, kit se yon moun lòt nasyon k'ap viv nan mitan yo a, se pase l'ap pase Seyè a nan betiz. Se pou yo wete moun sa a nan mitan pèp la. ");
INSERT INTO hat_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Paske li refize tande sa Seyè a te di a, li fè sa li konnen li pa t' dwe fè. Dapre lòd Seyè a, se pou yo touye l'. Epi se li menm sèl ki va reskonsab lanmò li. ");
INSERT INTO hat_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Yon jou, antan moun pèp Izrayèl yo te nan dezè a, yo bare yon nonm ki t'ap ranmase bwa jou repo a. ");
INSERT INTO hat_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Moun ki te bare l' yo mennen l' bay Moyiz, Arawon ak tout moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Yo pran msye, yo mete moun veye l', paske yo pa t' fin konnen sa pou yo te fè avè l'. ");
INSERT INTO hat_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Lè sa a, Seyè a di Moyiz konsa: -Se pou nou touye nonm lan pou sa li fè a. Y'a mennen msye andeyò limit kan kote yo rete a, pou tout moun kalonnen l' kout wòch jouk li mouri. ");
INSERT INTO hat_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Se konsa tout moun yo fè msye soti andeyò limit kan an, epi yo kalonnen msye kout wòch jouk li mouri, jan Seyè a te ba yo lòd la. ");
INSERT INTO hat_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","-Pale ak moun pèp Izrayèl yo. W'a di yo pou mwen: Se pou yo toujou mete ponpon sou woulèt rad yo, se pou yo pase kòdon ble nan chak ponpon. Se pou nou toujou fè sa de pitit an pitit. ");
INSERT INTO hat_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Chak fwa n'a wè ponpon sa yo, sa va fè nou chonje tou sa Seyè a te ban nou lòd fè pou nou ka fè yo. Konsa, nou p'ap pèdi tèt nou, nou p'ap vire do ban mwen pou nou swiv pwòp lide pa nou ak pwòp dezi pa nou. ");
INSERT INTO hat_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ponpon yo va fè nou chonje tout lòd mwen te ban nou pou nou ka swiv yo, pou nou ka viv apa nèt pou mwen menm ki Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Se mwen menm ki Seyè a, Bondye nou an. Se mwen menm ki te fè nou soti kite peyi Lejip la pou m' te ka Bondye nou. Se mwen menm ki Seyè a, Bondye nou an. ");
INSERT INTO hat_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kore, pitit gason Iza, moun laras Levi nan fanmi Keyat la, pran tèt Datan ak Abiram, pitit gason Eliyab yo ansanm ak One, pitit gason Pelèt, twa moun laras Woubenn. ");
INSERT INTO hat_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Yo revòlte kont Moyiz. Te gen desansenkant (0250) lòt moun nan pèp Izrayèl la avèk yo. Mesye sa yo, se te chèf pèp la menm te chwazi, moun ki te fè pati konsèy pèp la, chèf moun yo te konsidere anpil. ");
INSERT INTO hat_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Yo tout reyini devan Moyiz ak Arawon, yo di yo konsa: -Koulye a, mesye, n' al twò lwen tande! Dènye moun nan pèp la se pou Seyè a y'ap viv. Seyè a la nan mitan nou tout, pa vre? Poukisa, nou menm Moyiz ak Arawon, nou pran pòz chèf nou anwo pèp Seyè a konsa? ");
INSERT INTO hat_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Lè Moyiz tande sa, li lage kò l' atè plat, li lapriyè. Lèfini, li di Kore ak bann moun ki te avè l' yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","-Denmen maten, Seyè a va fè nou konnen ki moun ki pou li, ki moun li mete apa pou l' ak ki moun ki gen dwa pwoche bò kote l'. Moun la kite pwoche bò kote l' la, n'a konnen se moun sa a Bondye chwazi. ");
INSERT INTO hat_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Men sa pou n' fè. Ou menm, Kore, ak chak moun ki nan bann ou an, nou chak n'a pran yon ti recho dife. ");
INSERT INTO hat_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Denmen maten chak moun va ranje chabon dife nan recho pa l' la, epi l'a mete lansan sou dife a devan lotèl Seyè a. Konsa, moun Seyè a va chwazi a, n'a konnen se li menm Bondye mete apa pou l' a. Se nou menm, pitit Levi yo, ki pral twò lwen koulye a! ");
INSERT INTO hat_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moyiz di Kore konsa: -Koute non, nou menm pitit Levi yo! ");
INSERT INTO hat_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Apre tou sa Bondye fè pou nou, nou jwenn li pa fè ase toujou: Nan tout pèp Izrayèl la, se nou li chwazi pou pwoche bò kote l', pou fè sèvis li nan kay li, pou kanpe devan pèp la pou fè sèvis pou yo. ");
INSERT INTO hat_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ou menm Kore ak tout frè ou yo, pitit Levi yo, li ban nou dwa pou nou pwoche bò kote l'. Epi koulye a, n'ap mande pou yo ban nou plas prèt yo! ");
INSERT INTO hat_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Lè ou menm ak tout bann mesye ou yo n'ap plenyen konsa sou do Arawon, kisa Arawon ye nan sa? Konnen se kont Seyè a menm wi nou pran pozisyon. ");
INSERT INTO hat_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Apre sa, Moyiz voye rele Datan ak Abiram, de nan pitit gason Eliyab yo. Men yo voye di Moyiz: -Nou p'ap vini. ");
INSERT INTO hat_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ou fin fè nou kite yon bon ti peyi kote lèt ak siwo myèl t'ap koule tankou dlo, ou mennen nou vin mouri isit nan dezè a, epi koulye a ou vle pran pòz chèf ou sou nou ankò! ");
INSERT INTO hat_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ou mèt di sa ou vle, men se pa nan yon peyi kote lèt ak siwo myèl koule tankou dlo ou mennen nou la a! Ou pa ban nou okenn jaden pou n' plante grenn ni okenn jaden rezen ou te di ou t'ap ban nou an. Atò, ou kwè ou kapab pete je moun sa yo? Non! Nou p'ap vini. ");
INSERT INTO hat_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Lè sa a, Moyiz fè yon sèl fache, li di Seyè a konsa: -Pa asepte okenn ofrann moun sa yo ta pote vin ofri ou. Mwen pa janm pran anyen nan zafè yo, pa menm yon bourik. Mwen pa janm fè yonn ladan yo anyen. ");
INSERT INTO hat_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Apre sa, Moyiz di Kore konsa: -Ou menm ak tout bann moun ou yo, denmen n'a vini devan lotèl Seyè a. Arawon va la tou. ");
INSERT INTO hat_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Chak moun va pran yon ti recho dife, y'a mete lansan ladan l', epi y'a pote recho yo devan Seyè a. Sa va fè desansenkant (0250) recho. Ou menm ak Arawon, n'a vini ak recho pa nou tou. ");
INSERT INTO hat_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Se konsa, yo chak pran yon ti recho, yo ranje chabon dife ladan l', yo mete lansan sou dife a, epi yo vin kanpe devan pòt Tant Randevou a ansanm ak Moyiz ak Arawon. ");
INSERT INTO hat_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kore te fè tout pèp la reyini nan pòt Tant Randevou a anfas Moyiz ak Arawon. Yo rete konsa, epi pouvwa Bondye parèt tankou yon gwo limyè devan tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo: ");
INSERT INTO hat_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","-Wete kò nou nan mitan moun sa yo. Mwen pral disparèt yo koulye a. ");
INSERT INTO hat_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Men Moyiz ak Arawon tonbe fas atè, yo di: -O Bondye, ou menm ki bay tout moun lavi, se pa paske yon sèl moun fè sa l' pa t' dwe fè kifè pou ou fache sou tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","-Pale ak tout pèp la. Di yo pou mwen pou yo wete kò yo bò kote Kore, Datan ak Abiram rete a. ");
INSERT INTO hat_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moyiz leve, l' al jwenn Datan ak Abiram. Tout chèf fanmi pèp Izrayèl yo te ale avè l' tou. ");
INSERT INTO hat_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Li pale ak pèp la, li di yo: -Wete kò nou bò kote bann mechan sa yo rete a. Pa manyen anyen ki pou yo, si nou pa vle pase tou nan chatiman yo pral ba yo pou peche yo fè a. ");
INSERT INTO hat_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Se konsa, tout pèp la wete kò yo, yo rete byen lwen kote Kore, Datan ak Abiram te rete a. Datan ak Abiram menm soti, yo vin kanpe devan pòt kay yo ansanm ak madanm yo, pitit yo ak pitit pitit yo. ");
INSERT INTO hat_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moyiz di pèp la konsa: -Avèk sa ki pral rive a, nou pral konnen se Seyè a menm ki te voye m' fè tout travay sa yo. Se pa mwen menm ki rete konsa mwen di mwen pral fè yo. ");
INSERT INTO hat_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si moun sa yo mouri jan tout moun fèt pou mouri a, san se pa Bondye ki pini yo, enben, se pa Seyè a ki te voye m'. ");
INSERT INTO hat_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Men, si Seyè a fè bagay nou poko janm wè, si li fè tè a louvri pou l' vale moun sa yo ansanm ak tou sa ki pou yo, kifè y'ap desann tou vivan nan peyi kote mò yo ye a, n'a konnen se Seyè a menm yo t'ap derespekte konsa. ");
INSERT INTO hat_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Fini li fini di pawòl sa yo, tè a fann, li louvri anba pye Datan ak Abiram. ");
INSERT INTO hat_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Li vale yo, yo menm, tout fanmi yo ansanm ak tout moun ki te pran pozisyon pou Kore, ak tou sa ki te pou yo. ");
INSERT INTO hat_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Yo desann tou vivan avèk tou sa ki te pou yo nan peyi kote mò yo ye a. Apre sa, tè a fèmen sou yo, yo disparèt nèt nan mitan pèp la. ");
INSERT INTO hat_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tout moun nan pèp la ki te la pran kouri lè yo tande jan moun yo t'ap rele. Yo t'ap di: -Ann kouri pou tè a pa vale nou tou. ");
INSERT INTO hat_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Menm lè a tou, Seyè a voye yon sèl dife ki devore tout desansenkant (0250) mesye ki t'ap ofri lansan yo. ");
INSERT INTO hat_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","-Mande Eleaza, pitit gason Arawon, prèt la, pou l' ale wete recho dife an kwiv yo nan mitan rès moun boule yo. L'a jete chabon dife ki ladan yo yon kote byen lwen, paske recho dife sa yo se bagay ki apa pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Wi, yo apa pou mwen paske mesye sa yo ki mouri pou peche yo te ofri yo devan lotèl Seyè a. W'a pran recho sa yo, w'a bat yo ak mato fè yo tounen plak fin pou kouvri lotèl la. Sa va sèvi yon avètisman pou moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Se konsa, Eleaza, prèt la, te pran recho an kwiv moun boule yo te ofri yo, li bat yo ak mato, li fè yon kouvèti pou lotèl la ");
INSERT INTO hat_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","pou sa sèvi yon avètisman pou moun pèp Izrayèl yo, pou yo konnen moun ki pa fè pati fanmi Arawon an pa gen dwa pwoche devan lotèl Seyè a pou boule lansan. Si yo fè sa, sa ki rive Kore ak moun li yo, se sa k'ap rive moun sa yo tou. Tou sa pase konsa vre dapre lòd Seyè a te bay Moyiz pou Eleaza. ");
INSERT INTO hat_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Nan denmen, tout moun pèp Izrayèl yo pran bougonnen sou do Moyiz ak Arawon, yo t'ap di: -Se nou menm ki lakòz moun pèp Seyè a ap mouri konsa. ");
INSERT INTO hat_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Lè pèp la fin sanble pou yo pran pozisyon kont Moyiz ak Arawon, yo vire je yo gade Tant Randevou a, yo wè nwaj la te kouvri tant lan. Menm lè a, pouvwa Bondye-a parèt tankou yon gwo limyè. ");
INSERT INTO hat_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moyiz ak Arawon ale, yo kanpe devan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","-Wete kò nou nan mitan pèp sa a. Mwen pral disparèt yo koulye a menm! De mesye yo tonbe fas atè. ");
INSERT INTO hat_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Epi Moyiz di Arawon konsa: -Pran ti recho dife ou la, pran chabon dife sou lotèl la, mete ladan l'. Vide ti lansan sou dife a. Epi kouri vit avè l' al jwenn pèp la. W'a fè sèvis pou mande Bondye padon pou yo. Fè vit non! Seyè a fache anpil, li gen tan pran desizyon l'. Malè a konmanse deja. ");
INSERT INTO hat_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Arawon pran ti recho a, li fè sa Moyiz te di l' fè a. Epi li pran kouri nan mitan pèp la. Men, malè a te deja konmanse ap fè dega nan pèp la. Lè Arawon wè sa, li mete lansan sou dife a, li fè sèvis pou mande Bondye padon pou yo. ");
INSERT INTO hat_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Se konsa malè a te sispann. Arawon te kanpe nan mitan ak mò yo yon bò, moun vivan yo yon lòt bò. ");
INSERT INTO hat_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Te gen katòzmil sètsan moun (014.700) antou ki te mouri nan malè sa a, san konte sa ki te mouri akòz Kore yo. ");
INSERT INTO hat_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Lè malè a sispann nèt, Arawon tounen al jwenn Moyiz, devan papòt Kay Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","-Pale ak moun pèp Izrayèl yo. Di yo pou yo pote douz branch bwa, yon branch bwa pou chak branch fanmi pèp Izrayèl la. Wi, y'a pran yon branch bwa nan men chèf chak branch fanmi. Epi w'a ekri non chak chèf sou branch bwa pa yo. ");
INSERT INTO hat_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","W'a ekri non Arawon sou branch bwa Levi a. Va gen yon sèl branch bwa pou chak moun ki chèf nan branch fanmi pa l'. ");
INSERT INTO hat_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","W'a mete yo nan Tant Randevou a, devan Bwat Kontra a, kote mwen ban nou randevou a. ");
INSERT INTO hat_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Branch bwa ki pote non moun mwen chwazi a, se li menm ki va fè flè. Se konsa m'a fè moun Izrayèl yo sispann bougonnen sou do ou. ");
INSERT INTO hat_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moyiz pale ak moun pèp Izrayèl yo. Epi chak chèf pote ba li yon branch bwa, yonn pou chak branch fanmi. Sa te fè douz branch bwa antou. Branch bwa Arawon an te nan mitan tout lòt yo. ");
INSERT INTO hat_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moyiz pran tout branch bwa yo, li mete yo devan Bwat Kontra Seyè a, nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Nan denmen, lè Moyiz antre nan Tant Randevou a, li wè branch bwa Arawon an, ki pou branch fanmi Levi a, te fè flè. Li te gen tan fè bouton, flè yo te louvri, zanmann yo te mi. ");
INSERT INTO hat_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moyiz pran tout branch bwa yo ki te devan lotèl Seyè a, li pote yo bay moun pèp Izrayèl yo. Yo wè sa ki rive, epi chak chèf pran branch bwa ki te pou yo a. ");
INSERT INTO hat_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Seyè a di Moyiz: -Remete branch bwa Arawon an devan Bwat Kontra a. Se pou yo konsève l' pou sa sèvi yon siy pou moun tèt di sa yo, pou yo ka sispann bougonnen. Si yo pa sispann bougonnen, y'ap mouri! ");
INSERT INTO hat_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moyiz fè jan Seyè a te ba li lòd fè a. ");
INSERT INTO hat_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Apre sa, moun pèp Izrayèl yo pale ak Moyiz, yo di l' konsa: -Gade jan n'ap mouri, n'ap deperi, nou tout ap fini. ");
INSERT INTO hat_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Depi yon moun pwoche bò Tant Randevou a, li mouri. Si se konsa, nou tout ap mouri! ");
INSERT INTO hat_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Seyè a di Arawon konsa: -Se ou menm, pitit gason ou yo ansanm ak tout lòt moun nan branch fanmi Levi a, ki va reskonsab tout bagay mal ki pase nan tant yo mete apa pou Bondye a. Men, se ou menm ak pitit gason ou yo ase ki va reskonsab tout bagay mal ki pase nan travay prèt yo gen pou fè a. ");
INSERT INTO hat_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","W'a pran fanmi ou yo, moun branch fanmi Levi, granpapa ou la, w'a mete yo ansanm avè ou pou yo ka ede ou, pandan ou menm ak pitit gason ou yo, n'ap fè travay nou devan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Y'a fè tou sa yo gen pou yo fè pou ou, ak tou sa pou yo fè nan kay Bondye a. Men, se pa pou yo janm pwoche bò bagay yo mete apa pou Bondye yo, ni bò lotèl yo. Si yo fè sa, ni ou menm ni yo menm, n'ap mouri. ");
INSERT INTO hat_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Y'a travay ansanm avè ou, y'a fè tou sa y'a gen pou yo fè nan kay Bondye a, nan tout travay ki gen pou fèt nan kay Bondye a. Pesonn lòt pa gen dwa travay avè ou. ");
INSERT INTO hat_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Men, ou menm ak pitit gason ou yo, n'a fè tou sa nou gen pou nou fè nan kote ki apa pou Seyè a, tou sa nou gen pou nou fè pou lotèl la. Konsa, mwen p'ap janm fache ankò sou moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Se mwen menm ki te pran fanmi ou yo, moun Levi yo, ki te chwazi yo nan mitan tout moun pèp Izrayèl yo, mwen mete yo apa pou mwen. Se mwen ki ba ou yo pou yo ka travay nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Men, se ou menm sèl ak pitit gason ou yo ki pou fè travay prèt yo bò lotèl la ak dèyè rido a. Sa se travay pa nou sa. Mwen ban nou pouvwa pou nou sèvi m' prèt. Se yon kado mwen fè nou. Se pou yo touye nenpòt lòt moun ki va pwoche bò bagay yo mete apa pou mwen yo. ");
INSERT INTO hat_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Apre sa, Seyè a di Arawon konsa: -Chonje mwen pran yon pòsyon nan tout ofrann moun pèp Izrayèl yo fè pou mwen, mwen ba ou yo. Se va pòsyon ki va toujou rete pou ou ak pou pitit gason ou yo depi lè mwen te mete nou apa pou mwen an, dapre regleman ki la pou tout tan tout tan an. ");
INSERT INTO hat_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Nan ofrann yo mete apa nèt pou mwen yo, lè ou fin wete pòsyon pou boule nan dife a, tout rès la va pou nou: tout ofrann grenn ki donnen nan jaden, tout ofrann pou mande Bondye padon, tout ofrann pou repare sa yo fè ki mal. Tou sa yo ofri ban mwen tankou yon ofrann yo mete apa pou mwen, se pou ou ak pou pitit gason ou yo y'a ye. ");
INSERT INTO hat_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","N'a manje yo yon kote yo mete apa pou Seyè a. Se gason ase ki pou manje ladan yo. Konsidere ofrann sa yo tankou bagay ki apa pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Lèfini, tout ofrann espesyal moun pèp Izrayèl yo va fè pou yo balanse devan Seyè a, se pou ou yo va ye tou. M'ap ba ou yo pou ou, pou pitit gason ou yo ak pitit fi ou yo, dapre yon regleman k'ap la pou tout tan tout tan. Tout moun nan fanmi ou ki nan kondisyon pou fè sèvis pou mwen va gen dwa manje ladan l'. ");
INSERT INTO hat_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","M'ap ba ou tou tousa ki pi bon nan premye fwi rekòt y'ap ofri bay Seyè a chak lanne: lwil oliv, diven ak grenn ki donnen nan jaden. ");
INSERT INTO hat_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Tout premye fwi ki mi nan peyi a, fwi yo ofri bay Seyè a, se va pou ou tou. Tout moun lakay ou ki nan kondisyon pou sèvi Seyè a va gen dwa manje ladan yo. ");
INSERT INTO hat_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Tout bagay moun pèp Izrayèl yo pran angajman mete apa pou Seyè a va pou ou tou. ");
INSERT INTO hat_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tout premye pitit, kit se pitit moun, kit se pitit bèt, y'a mete yo apa pou mwen, e se pou ou yo va ye tou. Men, se pou ou asepte yo peye ou pou chak premye pitit moun ak tout premye pitit bèt ki pa ka sèvi ofrann pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Lè premye pitit gason an va gen yon mwa, w'a fè yo peye ou senk pyès ajan dapre sistèm yo sèvi nan kay Bondye a, -vin gera pou yon pyès ajan-,pou yo ka achte lavi l' nan men m'. ");
INSERT INTO hat_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Men, pou premye ti mal yon manman bèf osinon yon manman kabrit ou ankò yon manman mouton fè, ou p'ap asepte anyen pou yo. Se bagay ki apa pou mwen nèt. Se pou yo touye yo. Y'a vide san yo sou lotèl la, w'a boule grès yo. Se va yon ofrann y'a boule nèt pou mwen, yon ofrann ki va fè m' plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Men, vyann yo va rete pou ou ansanm ak vyann pwatrin lan ak jigo dwat ki te deja pou ou a. ");
INSERT INTO hat_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","M'ap ba ou pou ou menm, pou pitit gason ak pitit fi ou yo tout pòsyon ki va rete nan ofrann moun pèp Izrayèl yo va mete apa pou mwen. Se va yon regleman k'ap la pou tout tan tout tan. Se yon kontra ki p'ap janm kase ni ki p'ap janm gate mwen fè la avèk ou, pou ou ak pou tout ras fanmi ou. ");
INSERT INTO hat_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Apre sa, Seyè a di Arawon konsa: -Ou p'ap jwenn okenn pòsyon nan tè eritaj ki pou pèp la. Ou p'ap janm gen yon moso tè ki va rele ou pa ou nan peyi a. Se mwen menm ki tout ou, se mwen menm ki tout byen ou nan mitan pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Seyè a di konsa: -Mwen mete tout ladim moun Izrayèl yo va bay la apa pou moun branch fanmi Levi yo, pou sèvis y'ap rann nan tanp lan, pou travay y'ap fè nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Moun pèp Izrayèl yo pa janm bezwen preche bò Tant Randevou a. Konsa, yo p'ap rive fè yon peche ki pou ta fè yo mouri. ");
INSERT INTO hat_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Depi koulye a, se moun Levi yo ki va pran swen tout bagay nan Tant Randevou a. Y'a reskonsab pou tout bagay mal y'a fè. Sa se yon lòd sevè pou tout moun swiv de pitit an pitit. Se konsa yo menm tou, yo p'ap gen tè k'ap rele yo pa yo pou tout tan nan mitan pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","M'ap bay moun Levi yo tout ladim moun pèp Izrayèl yo pran sou sa yo genyen pou ofri bay Seyè a. Se poutèt sa, mwen di moun fanmi Levi yo p'ap gen okenn pòsyon tè ki pou rele yo pa yo nan peyi Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Seyè a pale ak Moyiz ankò, li di l': ");
INSERT INTO hat_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","-Pale ak moun Levi yo, di yo konsa: Lè n'a resevwa nan men moun pèp Izrayèl yo ladim Seyè a ban nou pou byen pa nou, n'a wete yon dizyèm ladan l' pou mwen. Se va ofrann ladim pa nou bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Y'a konsidere ofrann sa a tankou ofrann lòt moun yo fè sou farin ble ak diven apre chak rekòt. ");
INSERT INTO hat_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Konsa, nou menm tou, n'a pran yon pòsyon nan tout ofrann ladim moun pèp Izrayèl yo va fè, n'a mete l' apa pou mwen. Epi n'a pran pòsyon nou wete pou Seyè a nan sa ki pou nou an, n'a bay Arawon, prèt la, li pou tèt pa li. ");
INSERT INTO hat_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","N'a pran sa ki pi bon nan tout sa ki pou nou an, n'a ofri l' bay Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","W'a di yo tou: Lè moun Levi yo fin pran sa ki pi bon nan tou sa ki pou vin pou yo a, y'a konsidere rès ki rete a tankou rekòt farin ble ak diven yo menm yo fè. ");
INSERT INTO hat_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Y'a manje l' kote yo vle, ansanm ak tout moun lakay yo. Se tankou lajan yo ba yo pou travay y'ap fè nan Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Depi nou ofri sa ki pi bon an bay Seyè a, nou mèt manje rès la san kè sote, anyen p'ap rive nou. Piga nou derespekte bagay moun pèp Izrayèl yo mete apa pou mwen. Si nou fè sa, n'ap mouri. ");
INSERT INTO hat_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Seyè a pale ak Moyiz ansanm ak Arawon, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","-Men yon regleman Seyè a bay lòd pou yo swiv tankou yon lwa: Men sa li di: Mande moun pèp Izrayèl yo pou yo fè ou jwenn yon gazèl pwal koulè wouj, ki pa gen okenn enfimite e ki poko janm travay. ");
INSERT INTO hat_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","W'a renmèt Eleaza, prèt la, li. L'a fè l' soti andeyò limit kan kote moun yo rete a, epi l'a fè yo touye l' devan je li. ");
INSERT INTO hat_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Apre sa, Eleaza va pran ti gout nan san an. Epi, kote l' kanpe a, avèk dwèt li, l'a voye san an sèt fwa nan direksyon Tant Randevou a. ");
INSERT INTO hat_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Lèfini, y'a boule tout bèt la nèt devan je prèt la: po a, vyann lan, san an ansanm ak tout tripay la. ");
INSERT INTO hat_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Prèt la va pran kèk moso bwa sèd, kèk branch izòp, yon moso twal wouj, l'a jete yo nan boukan dife kote gazèl la ap boule a. ");
INSERT INTO hat_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Apre sa, prèt la va lave rad ki te sou li, l'a benyen nan gwo dlo. Lèfini, l'a tounen antre nan kan an. Prèt la p'ap nan kondisyon pou l' fè okenn sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Moun ki te boule gazèl la va lave rad ki te sou l' a, epi l'a benyen nan gwo dlo tou. Li menm tou, li p'ap nan kondisyon pou l' fè okenn sèvis pou Bondye jouk aswè. ");
INSERT INTO hat_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Yon lòt moun ki nan kondisyon pou fè sèvis pou Bondye va ranmase tout sann gazèl wouj la, l'a mete l' yon kote ki apa pou Bondye andeyò limit kan kote moun yo rete a. Y'a konsève sann lan pou lè moun pèp Izrayèl yo va bezwen pran ladan l' pou pare dlo y'a sèvi pou mete nenpòt bagay nan kondisyon pou fè sèvis Bondye ankò, lè y'ap fè sèvis pou mande Bondye padon pou sa yo fè ki mal. ");
INSERT INTO hat_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Nonm ki te ranmase sann gazèl la va lave rad ki te sou l' a, epi li p'ap nan kondisyon pou l' fè okenn sèvis pou Bondye jouk aswè. Sa se va yon regleman pou tout moun nan peyi a toujou swiv, kit se moun pèp Izrayèl yo, kit se moun lòt nasyon k'ap viv nan mitan yo. ");
INSERT INTO hat_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Depi yon moun manyen kadav yon moun mouri, pandan sèt jou apre sa, li p'ap nan kondisyon pou l' fè sèvis pou Bondye. ");
INSERT INTO hat_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","L'a fè sèvis pou mande Bondye gras avèk dlo yo pare pou sa a sou twazyèm jou a ak sou setyèm jou a. Apre sa, l'a nan kondisyon pou l' fè sèvis Bondye. Men, si li pa fè sèvis pou mande Bondye gras sou twazyèm jou a ak sou setyèm jou a, li p'ap nan kondisyon pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Depi yon moun manyen kadav yon moun mouri, si li pa fè sèvis pou mande Bondye gras, piga li pwoche bò Tant Randevou a pou li pa derespekte tant lan. Si li fè sa, se pou yo touye l'. Se pou yo konsidere moun sa a tankou yon moun ki pa fè pati pèp Bondye a, paske yo pa t' voye dlo pou mete nan bon kondisyon an sou li, li pa nan kondisyon pou l' sèvi Bondye. Toutotan yo pa fè sèvis la pou li, l'ap rete nan kondisyon sa a. ");
INSERT INTO hat_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Men regleman pou yo swiv: lè yon moun mouri nan yon kay, tout moun ki te nan kay la lè lanmò a, ou ankò tout moun ki vin antre nan kay la apre sa, p'ap nan kondisyon pou fè sèvis Bondye pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tout veso ki pa kouvri ak yon kouvèti byen mare sou li p'ap ka sèvi pou moun ki nan kondisyon pou sèvi Bondye. ");
INSERT INTO hat_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Konsa tou, depi yon moun k'ap mache nan jaden manyen kadav yon moun mouri, kit moun lan mouri mò natirèl, kit se ansasinen yo te ansasinen l', osinon depi yon moun manyen zosman yon moun mouri oswa tonm kote yo antere yon moun mouri, moun sa a p'ap nan kondisyon pou l' sèvi Bondye pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Si yon moun ta rive nan kondisyon sa a konsa, y'a pran ti gout nan sann gazèl yo te boule pou wete peche a, y'a mete l' nan yon veso, epi y'a vide ti gout dlo dous sou li. ");
INSERT INTO hat_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Nan premye ka a, yon moun ki nan kondisyon pou fè sèvis Bondye va pran yon branch izòp, l'a plonje l' nan dlo a, epi l'a voye dlo sou kay la, sou tout bagay ki ladan l' ak sou tout moun ki te la nan kay la. Nan dezyèm ka a, l'a voye dlo a sou moun lan, kit li te manyen zosman moun mouri osinon kadav moun yo te ansasinen, osinon kadav moun ki te mouri mò natirèl, kit li te manyen yon tonm moun mouri. ");
INSERT INTO hat_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Sou twazyèm jou a ak sou setyèm jou a, nonm ki nan kondisyon pou fè sèvis pou Bondye a va voye dlo a sou moun ki pa nan kondisyon pou sèvi Bondye a. Sou setyèm jou a, l'a fè sèvis pou mande Bondye gras pou nonm lan. Apre sa, nonm lan va lave rad ki sou l' a, l'a benyen nan gwo dlo. Men, se lè solèy va fin kouche la nan kondisyon ankò pou l' fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Men lè yon nonm pa nan kondisyon pou fè sèvis Bondye, si li pa fè sèvis pou mande Bondye gras, se pou yo konsidere l' tankou yon moun ki pa fè pati pèp Bondye a. Li pa ka pwoche bò Tant Randevou a pou l' pa derespekte l'. Toutotan yo pa fè pou li sèvis voye dlo ki pou mete l' nan bon kondisyon an, l'ap rete nan kondisyon pou l' pa ka fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Se va la yon regleman pou yo toujou swiv tout tan. Moun ki te voye dlo sou lòt la pou mete l' nan bon kondisyon an, va gen pou l' lave rad ki te sou l' a tou. Depi yon moun manyen dlo pou mete nan bon kondisyon an, li p'ap nan kondisyon pou l' fè sèvis pou Bondye jouk nan aswè menm jou a. ");
INSERT INTO hat_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Depi yon nonm ki pa nan kondisyon pou sèvi Bondye manyen yon bagay, moun ki nan kondisyon pou sèvi Bondye pa ka sèvi ak bagay sa a. Depi yon moun manyen yon bagay konsa, li menm tou, li p'ap nan kondisyon pou l' sèvi Bondye jouk aswè rive. ");
INSERT INTO hat_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Sou premye mwa a, tout moun pèp Izrayèl yo te rive nan dezè Zin lan, epi yo moute tant yo yon kote yo rele Kadès. Se la Miryam mouri, se la menm yo antere l'. ");
INSERT INTO hat_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Men, pa t' gen dlo la pou pèp la te bwè. Pèp la sanble bò kote Moyiz ak Arawon, yo leve kont ak yo. ");
INSERT INTO hat_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Pèp la fè kont ak Moyiz, yo di l' konsa: -Pa pito nou te mouri devan lotèl Seyè a ansanm ak lòt frè nou yo! ");
INSERT INTO hat_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Poukisa ou mennen nou nan dezè a? Gen lè se pou fè nou mouri, nou menm pèp Seyè a, ansanm ak tou bèt nou yo? ");
INSERT INTO hat_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Poukisa ou fè nou soti kite peyi Lejip la pou mennen nou nan move kote sa a? Se yon kote ou pa jwenn grenn pou simen, ou pa jwenn okenn pye fig frans, ni pye rezen, ni pye grenad. Pa menm gen dlo pou moun bwè! ");
INSERT INTO hat_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moyiz ak Arawon pati kite pèp la, y' ale devan pòt Tant Randevou a. Yo lage kò yo fas atè, epi bèl limyè prezans Bondye a parèt sou yo. ");
INSERT INTO hat_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","-Pran baton ki sou devan Bwat Kontra a. Lèfini, ou menm ak Arawon, frè ou la, sanble tout pèp la. Epi devan yo tout, w'a pale ak wòch ki bò laba a, wòch la va bay dlo. Se konsa w'a fè dlo soti nan wòch la pou pèp la, pou yo tout ka bwè ansanm ak bèt yo. ");
INSERT INTO hat_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moyiz pran baton ki sou devan lotèl la, jan Seyè a te ba li lòd la. ");
INSERT INTO hat_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moyiz ak Arawon sanble tout pèp la devan gwo wòch la. Epi Moyiz di yo: -Louvri zòrèy nou, bann moun tèt di! Se vle nou vle mwen fè dlo soti nan wòch sa a pou nou? ");
INSERT INTO hat_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Moyiz leve men l', li frape wòch la de fwa avèk baton an. Epi yon gwo sous dlo pete nan wòch la. Tout moun yo bwè ansanm ak bèt yo tou. ");
INSERT INTO hat_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Men, Seyè a di Moyiz ak Arawon konsa: -Paske nou pa t' fin gen konfyans nèt nan mwen pou n' te fè moun pèp Izrayèl yo wè jan mwen se yon Bondye apa, se pa nou menm m'ap kite mennen pèp la antre nan peyi mwen pwomèt m'ap ba yo a. ");
INSERT INTO hat_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Se kote sa a yo rele sous Meriba a, paske se la moun pèp Izrayèl yo te leve kont ak Seyè a. Se la Seyè a te moutre yo li se yon Bondye ki pa tankou lòt bondye yo. ");
INSERT INTO hat_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Moyiz rete Kadès, li voye kèk mesaje bò wa peyi Edon an pou di l' konsa: -Men sa moun pèp Izrayèl yo, moun menm fanmi ak ou yo, voye di ou: Ou konnen tout tray nou pase. ");
INSERT INTO hat_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ou konnen ki jan zansèt nou yo te desann al rete nan peyi Lejip pandan lontan, ki jan moun peyi sa a tonbe maltrete nou menm jan yo te maltrete zansèt nou yo. ");
INSERT INTO hat_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Lè nou wè sa, nou rele nan pye Seyè a. Li tande vwa nou, epi li voye zanj li, li fè nou soti kite peyi Lejip sa a. Koulye a, men nou Kadès, yon lavil ki toupre fwontyè peyi ou la. ");
INSERT INTO hat_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tanpri, n'ap mande ou yon ti pèmisyon pou nou pase ase nan mitan peyi ou la. Nou p'ap kite wout nou pou n' pase nan mitan jaden ou, ni nan mitan pye rezen ou yo. Ata dlo nan pi ou yo nou p'ap bwè. Nou p'ap kite gran chemen w'a moutre nou an, nou p'ap vire ni adwat ni agoch, jouk n'a fin travèse lòt bò peyi a. ");
INSERT INTO hat_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Wa Edon an voye di yo: -Non. Nou p'ap kite nou travèse peyi a. Si nou chache fè sa, n'ap mache pran nou, n'ap atake nou. ");
INSERT INTO hat_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Men, moun pèp Izrayèl yo voye di l' ankò: -Nou p'ap kite gran chemen w'a louvri devan nou an. Epi si yonn nan nou, osinon yonn nan bèt nou yo ta bwè nan dlo peyi ou la, n'ap peye ou pou sa. Se annik pase nou bezwen pase nan mitan peyi a, pa lòt bagay! ");
INSERT INTO hat_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Men, wa Edon an voye di yo ankò: -Non! Nou p'ap pase menm! Epi li soti avèk yon gwo lame ak yon bann lòt moun, yo mache kontre moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Se konsa moun peyi Edon yo te refize kite moun pèp Izrayèl yo pase nan peyi yo a. Kifè moun Izrayèl yo te blije vire do yo, fè yon lòt wout. ");
INSERT INTO hat_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Tout moun pèp Izrayèl yo kite Kadès, yo rive sou Mòn Or la, ");
INSERT INTO hat_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ki te toupre fwontyè peyi Edon an. Antan yo la, Seyè a pale ak Moyiz ansanm ak Arawon, li di yo: ");
INSERT INTO hat_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","-Arawon pa pral antre nan peyi mwen pwomèt pou m' bay moun pèp Izrayèl yo. Msye pral mouri, li pral jwenn moun li yo ki te mouri anvan l' yo, paske nou tou de, nou pa t' fè sa mwen te ban nou lòd fè bò sous dlo Meriba a. ");
INSERT INTO hat_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Pran Arawon ak Eleaza, pitit gason l' lan, moute sou mòn Or la ak yo. ");
INSERT INTO hat_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","W'a wete rad espesyal ki sou Arawon yo, w'a mete yo sou Eleaza, pitit gason l' lan. Se la sou mòn lan Arawon pral mouri. ");
INSERT INTO hat_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moyiz fè tou sa Seyè a te mande l' fè a: Devan je tout moun, yo tou twa yo moute sou mòn Or la. ");
INSERT INTO hat_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Lèfini, Moyiz wete rad espesyal ki te sou Arawon yo, li mete yo sou Eleaza, pitit gason Arawon an. Se la sou tèt mòn lan Arawon mouri. Apre sa, Moyiz ak Eleaza desann desann yo sou mòn lan. ");
INSERT INTO hat_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Tout pèp la vin konnen Arawon te mouri. Se konsa tout moun nan pèp Izrayèl la pase trant jou ap kriye pou Arawon. ");
INSERT INTO hat_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Wa lavil Arad la, nan rejyon Negèv la, te yon moun peyi Kanaran. Lè li vin tande moun pèp Izrayèl yo t'ap vini sou chemen ki mennen Atarim lan, l' al atake yo. Li fè kèk ladan yo prizonye. ");
INSERT INTO hat_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Lè sa a, moun pèp Izrayèl yo fè yon ve bay Seyè a, yo di konsa: -Si ou lage moun sa yo nan men nou, n'ap mete yo tout apa pou ou ansanm ak tout lavil yo. N'ap detwi yo nèt. ");
INSERT INTO hat_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Seyè a tande sa yo te mande l' la, epi li ede yo, li fè yo mete men sou moun Kanaran yo. Moun pèp Izrayèl yo disparèt tout moun yo ansanm ak tout lavil yo. Se poutèt sa yo rele kote sa a Oma. ");
INSERT INTO hat_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Moun Izrayèl yo pati, yo kite mòn Or la, yo pran wout ki mennen bò Lanmè Wouj la, pou yo pa pase nan peyi Edon an. Men, antan y'ap vwayaje a, pèp la vin dekouraje. ");
INSERT INTO hat_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Pèp la pale Bondye ansanm ak Moyiz mal, yo leve dèyè yo, yo di konsa: -Poukisa nou fè nou soti kite peyi Lejip la? Gen lè se pou fè nou vin mouri nan dezè sa a kote ki pa gen ni manje ni dlo. Nou bouke manje vye manje sa a ki pa ka fè anyen pou nou ankò. ");
INSERT INTO hat_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Lè sa a, Seyè a voye yon bann ti sèpan sou pèp la. Kote sèpan sa yo mòde ou la boule kou dife. Yo mòde pèp la. Anpil moun te mouri. ");
INSERT INTO hat_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Pèp la vin jwenn Moyiz, yo di l' konsa: -Nou rekonèt nou fè sa ki mal lè nou pale kont Seyè a ak kont ou menm tou. Tanpri, lapriyè Seyè a pou nou pou l' fè sèpan sa yo ale. Moyiz lapriyè pou pèp la vre. ");
INSERT INTO hat_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Seyè a di Moyiz konsa: -Fè pòtre yon sèpan parèy ak sèpan sa yo. Mete l' sou yon poto byen wo. Konsa, depi yon sèpan mòde yon moun, moun lan va annik gade pòtre sèpan an, epi li p'ap mouri. ");
INSERT INTO hat_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moyiz pran kwiv, li fonn li, li fè yon sèpan parèy ak sèpan yo. Lèfini, li mete l' sou yon poto byen wo. Tout moun sèpan mòde, depi yo voye je yo gade sèpan an kwiv la, yo pa mouri. ");
INSERT INTO hat_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Moun pèp Izrayèl yo pati, y' al moute kan yo nan fon Obòt la. ");
INSERT INTO hat_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Apre sa, yo kite fon Obòt, y' al moute kan yo bò mazi Abarim yo nan dezè ki sou bò lès peyi Moab la. ");
INSERT INTO hat_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Apre sa ankò, yo kite kote yo te ye a, y' al moute kan yo nan ravin Zerèd. ");
INSERT INTO hat_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Lè yo kite ravin Zerèd, y' al moute kan yo lòt bò larivyè Anon nan dezè ki rive jouk nan teritwa moun Amori yo. Rivyè Anon sa a te sèvi fwontyè ant peyi Moab ak peyi Amori a. ");
INSERT INTO hat_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Se poutèt sa, nan liv istwa ki rakonte batay Seyè a, nou jwenn yo pale sou lavil Vayèb, nan peyi Soufa a, ak ravin li yo, sou rivyè Anon ");
INSERT INTO hat_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","avèk fon lavalas li yo, ki desann bò lavil Amoab la nan direksyon fwontyè peyi Moab la. ");
INSERT INTO hat_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Apre sa, yo kite kote yo te ye a, y' al yon kote yo rele Beyè. Se la Seyè a te pale ak Moyiz, lè li te di l': Reyini tout pèp la. Mwen pral ba yo dlo. ");
INSERT INTO hat_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Lè sa a, moun Izrayèl yo pran chante chante sa a: Pi a bay dlo! Annou chante pou sa! ");
INSERT INTO hat_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Pi chèf yo te fouye Avèk baton kòmandan yo! Pi grannèg yo te fouye Avèk baton yo sèvi lè y'ap mache a! Apre sa, yo kite dezè a, y' al moute kan yo Matana. ");
INSERT INTO hat_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Lè yo kite Matana, y' ale Nakalyèl. Lè yo kite Nakalyèl, yo moute Bannòt. ");
INSERT INTO hat_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Lè yo kite Bannòt, y' ale nan fon ki nan peyi Moab la, jouk sou tèt mòn Pisga, kote y'ap gade tout dezè a nan pye yo. ");
INSERT INTO hat_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Lè sa a, moun pèp Izrayèl yo voye mesaje bò kote Siyon, wa peyi Amori a, pou di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","-Kite nou pase ase nan mitan peyi ou la! Nou p'ap kite wout nou pou pase nan mitan jaden ou, ni nan mitan pye rezen ou yo. Ata bwè nou p'ap bwè dlo nan pi ou yo. N'ap rete sou gran chemen ou va moutre nou an, jouk n'a fin travèse lòt bò peyi ou la. ");
INSERT INTO hat_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Men, Siyon pa t' vle kite pèp Izrayèl la pase sou tè li yo. Li leve tout pèp l' a, li mache sou moun pèp Izrayèl yo, l' al kontre ak yo yon kote nan dezè a yo rele Jaza, l' atake yo. ");
INSERT INTO hat_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Men, moun Izrayèl yo touye anpil ladan yo nan batay la, yo pran tout peyi a nan men yo, depi larivyè Anon nan sid rive larivyè Jabòk nan nò, toupre fwontyè peyi Amon an, ki te yon fwontyè byen gade. ");
INSERT INTO hat_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Se konsa, moun Izrayèl yo pran tout lavil moun Amori yo, depi Esbon, kapital la ak lòt ti bouk nan vwazinaj li ki te sou kont li, epi yo rete ladan yo tout. ");
INSERT INTO hat_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Lavil Esbon te kapital peyi a. Se la Siyon, wa peyi Amori a, te rete. Se menm Siyon sa a ki te goumen kont ansyen wa peyi Moab la epi ki te pran tout peyi a pou li jouk larivyè Anon. ");
INSERT INTO hat_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Se poutèt sa sanba yo di: -Ann ale Esbon! Ann al bati l' ankò! Ann al mete lavil wa Siyon an kanpe sou de pye l' ankò! ");
INSERT INTO hat_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Paske yon sèl dife te soti lavil Esbon, Wi, lame wa Siyon an derape tankou yon flanm dife, li boule lavil A Moab. Li devore tout chèf ki rete sou mòn Anon an. ");
INSERT INTO hat_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Sa pral rèd nèt pou nou, moun peyi Moab! Nou pèdi nèt, nou menm sèvitè Kemòch! Bondye nou an fè pitit gason nou yo kouri al kache. Li kite pitit fi nou yo tounen prizonye nan men Siyon, wa peyi Amori a. ");
INSERT INTO hat_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Men koulye a, se moun lavil Esbon yo ki pèdi nèt fwa sa a! Nou mete kou sou yo depi lavil Esbon rive Dibon! Nou devaste peyi a kite l' blanch jouk Nofak, toupre Medeba. ");
INSERT INTO hat_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Se konsa, moun pèp Izrayèl yo vin rete nan peyi Amori a. ");
INSERT INTO hat_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moyiz menm voye kèk moun wè ki jan sa ye nan lavil Jazè. Apre sa, moun Izrayèl yo mache pran lavil la ak lòt ti bouk ki nan vwazinaj li. Kote yo pase, yo mete moun Amori yo deyò lakay yo. ");
INSERT INTO hat_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Apre sa, moun pèp Izrayèl yo tounen sou wout yo, yo pran chemen ki mennen lavil Bazan. Epi Og, wa lavil Bazan an, leve tout pèp l' a, li vin kontre ak yo pou l' atake yo bò Edreyi. ");
INSERT INTO hat_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Seyè a di Moyiz konsa: -Ou pa bezwen pè msye! M'ap fè nou kraze l' anba pye nou, li menm ansanm ak tout pèp l' a. M'ap fè nou pran peyi l' la pou nou. Nou pral fè l' pase sa nou te fè Siyon, wa peyi Amori ki te rete Esbon an, pase. ");
INSERT INTO hat_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Se konsa, moun pèp Izrayèl yo touye Og, ansanm ak pitit gason l' yo ak tout pèp l' a. Yo pa kite yonn chape, yo pran tout peyi a pou yo. ");
INSERT INTO hat_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Moun pèp Izrayèl yo kite kote yo te ye a, y' al moute kan yo nan plenn Moab, ki lòt bò larivyè Jouden, anfas lavil Jeriko. ");
INSERT INTO hat_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Lè wa Balak, pitit Zipò, wè tou sa moun pèp Izrayèl yo te fè moun Amori yo, ");
INSERT INTO hat_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","li menm ak tout moun pèp Moab yo te vin pè pèp Izrayèl la kou chat, paske moun pèp Izrayèl yo te anpil anpil. ");
INSERT INTO hat_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moun Moab yo pale ak chèf fanmi moun Madyan yo, yo di yo: -Bann moun sa yo pral manje tou sa ki alantou nou, tankou bèf k'ap manje zèb nan savann. Lè sa a, se Balak, pitit Zipò, ki te wa peyi Moab. ");
INSERT INTO hat_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Li voye kèk mesaje bò kote Balaram, pitit Beyò a, ki te rete lavil Petò, bò gwo larivyè Lefrat la nan peyi moun Amaf yo. Men komisyon li te voye ba li: -Men, gen yon pèp la a ki soti nan peyi Lejip. Y'ap mache pran tout peyi pou yo. Koulye a, men yo kanpe toupre lòt bò fwontyè peyi mwen an. ");
INSERT INTO hat_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Tanpri, vini non. Vin madichonnen yo pou mwen, paske yo pi fò pase m'. Lè sa a, ou pa janm konnen, m'a ka bat yo, m'a mete yo deyò nan peyi a. Paske mwen konnen lè ou beni yon moun, li beni nèt, Konsa tou, lè ou bay yon moun madichon, li madichonnen nèt. ");
INSERT INTO hat_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Se konsa, chèf fanmi moun Moab yo ak chèf fanmi moun Madyan yo pati. Yo te pote ak yo sa ki te nesesè pou peye konsiltasyon an. Yo rive kay Balaram, epi yo ba li komisyon Balak la. ");
INSERT INTO hat_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaram di yo: -Bon. Nou mèt pase nwit la isit la. Denmen m'a ban nou repons mwen dapre sa Seyè a va fè m' konnen. Se konsa, chèf fanmi moun Moab yo rete lakay Balaram. ");
INSERT INTO hat_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Bondye vin bò kote Balaram, li di l' konsa: -Ki moun sa yo ki lakay ou a? ");
INSERT INTO hat_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaram reponn: -Se Balak, pitit Zipò a, wa peyi Moab, ki voye yo vin di m': ");
INSERT INTO hat_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Men gen yon pèp ki soti nan peyi Lejip k'ap mache pran tout peyi pou yo. Tanpri, vini ba yo madichon pou li. Konsa, l'a ka rive bat yo, l'a ka mete yo deyò nan peyi a. ");
INSERT INTO hat_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Men Bondye di Balaram konsa: -Piga ou ale ak mesye sa yo, tande. Piga ou bay pèp Izrayèl la madichon, paske se mwen ki beni yo. ");
INSERT INTO hat_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Nan denmen maten, byen bonè, Balaram leve, l' al jwenn moun Balak te voye yo, li di yo: -Tounen lakay nou, paske Seyè a pa vle kite m' ale ak nou. ");
INSERT INTO hat_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Se konsa chèf moun Moab yo leve, yo tounen bò kote Balak, yo di l' konsa: -Balaram refize vini avèk nou! ");
INSERT INTO hat_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Lè sa a, Balak voye yon bann lòt chèf kote Balaram ankò. Men, fwa sa a chèf sa yo te pi plis, epi yo te pi grannèg pase premye yo. ");
INSERT INTO hat_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Mesye yo leve vre, y' ale bò kote Balaram, epi yo di l' konsa: -Men sa Balak, pitit Zipò a, voye di ou: Tanpri, pa kite anyen anpeche ou vin bò kote m'. ");
INSERT INTO hat_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Gade: m'ap kite anpil bèl bagay pou ou. M'ap fè tou sa ou di m' fè. Tanpri, vini non! Vin bay pèp sa a madichon pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Men, Balaram reponn moun Balak yo, li di yo: -Balak te mèt ban mwen kay li plen ajan ak lò, mwen p'ap fè anyen, ni lou ni lejè, ki pou fè m' dezobeyi lòd Seyè a, Bondye mwen an. ");
INSERT INTO hat_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Yon sèl bagay, nou mèt dòmi isit la aswè a, pou m' ka konnen si Seyè a gen lòt bagay li vle di m' ankò. ");
INSERT INTO hat_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Jou lannwit sa a, Bondye vin jwenn Balaram, epi li di l' konsa: -Si se chache mesye sa yo vin chache ou, ou mèt leve ale ak yo. Men, se sa mwen di ou fè ase pou ou fè. ");
INSERT INTO hat_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Nan denmen maten, byen bonè, Balaram leve, li sele manman bourik l' a, epi li pati avèk chèf moun Moab yo. ");
INSERT INTO hat_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Pati Balaram pati, Bondye fache sou li. Se konsa, antan Balaram taprale sou manman bourik l' a, avèk de domestik ki t'ap mache avè l' yo, zanj Seyè a vin kanpe nan mitan wout la pou bare chemen l'. ");
INSERT INTO hat_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Lè manman bourik la wè zanj Seyè a ki te kanpe nan mitan wout la avèk nepe li nan men l', bourik la chankre, li lage kò l' nan jaden. Balaram bat bourik la jouk li fè l' tounen sou wout la. ");
INSERT INTO hat_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Men zanj Seyè a vin kanpe yon kote wout la te jennen, kote wout la pase nan mitan de jaden rezen avèk yon miray kloti sou chak bò. ");
INSERT INTO hat_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Lè manman bourik la wè zanj Seyè a, l' al fwote kò l' sou miray la. Se konsa li kwense pye Balaram sou miray la. Balaram tanmen bat l' ankò. ");
INSERT INTO hat_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Zanj Seyè a fè yon ti mache ankò, epi l' al kanpe yon kote wout la te pi jennen toujou, kifè pa t' gen yon ti espas menm pou pase ni adwat, ni agoch. ");
INSERT INTO hat_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Lè bourik la wè zanj Seyè a, fwa sa a, li kouche ak tout Balaram sou li. Balaram fache, li tonbe bat bourik la ak gwo baton ki te nan men l' lan. ");
INSERT INTO hat_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Lè sa a, Seyè a bay bourik la lapawòl. Bourik la di Balaram konsa: -Kisa m' fè ou? Poukisa an twa fwa ou bat mwen konsa: ");
INSERT INTO hat_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaram di bourik la konsa: -Se paske w'ap pase m' nan jwèt! Pa pito se te yon manchèt osinon yon nepe ki te nan men m', ou ta gen tan konnen. Ou mouri lontan! ");
INSERT INTO hat_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Bourik la reponn, li di l': -Eske se pa bourik ou mwen ye! Se pa sou mwen ou toujou moute depi tout tan jouk jòdi a? Ou janm wè mwen konn aji konsa avè ou? Balaram reponn: -Non! ");
INSERT INTO hat_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Lè sa a, Seyè a louvri je Balaram, li fè l' wè zanj lan ki te kanpe nan mitan wout la avèk nepe l' nan men l'. Balaram lage kò l' fas atè. ");
INSERT INTO hat_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Zanj lan di l' konsa: -Poukisa an twa fwa ou bat bourik la konsa? Se mwen menm ki vin bare chemen ou, paske ou pa t' dwe al fè vwayaj sa a. ");
INSERT INTO hat_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Men bourik ou a te wè m'. Se poutèt sa, an twa fwa, li te vle chankre. Men, ou mèt di l' mèsi, paske si li pa t' fè sa, mwen ta gen tan touye ou. Li menm, mwen pa t'ap fè l' anyen. ");
INSERT INTO hat_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaram reponn: -Sa m' fè a pa bon, vre! Sèlman, mwen pa t' konnen se ou menm ki te bare wout la devan m'. Men si koulye a ou pa vle m' al pi lwen, m'ap tou tounen lakay mwen. ");
INSERT INTO hat_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Men, zanj Bondye a di li: -Ou mèt ale ak mesye yo. Sèlman, pa di anyen pase sa m'a di ou di. Se konsa Balaram ale ak chèf Balak te voye bò kote l' yo. ");
INSERT INTO hat_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Lè Balak vin konnen Balaram t'ap vini, li pati, l' al kontre l' jouk Amoab, yon lavil sou fwontyè bò larivyè Anon an. ");
INSERT INTO hat_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak di Balaram konsa: -Ki jan fè mwen voye moun al chache ou, ou pa vin jwenn mwen? Se konprann ou konprann mwen pa ta ka resevwa ou jan ou merite l' la? ");
INSERT INTO hat_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaram reponn: -Apa mwen vini fwa sa a! Men mwen tou pale ou, se pawòl Bondye va mete nan bouch mwen ase m'ap di. ");
INSERT INTO hat_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Se konsa, Balaram ale avèk Balak jouk yo rive lavil Kiriyat-Ousòt. ");
INSERT INTO hat_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Rive la, Balak fè touye bèf ak mouton, epi li voye kèk moso vyann bay Balaram ansanm ak chèf ki te avè l' yo. ");
INSERT INTO hat_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Nan denmen maten, Balak pran Balaram, yo moute sou mòn Bamòtbaal. Antan yo la, yo te kapab wè yon pòsyon nan moun Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaram di Balak konsa: -Bati sèt lotèl isit la pou mwen. Apre sa, ban mwen sèt towo bèf ak sèt belye mouton. ");
INSERT INTO hat_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak fè sa Balaram te di l' fè a. Lèfini, Balaram ak Balak touye yon towo bèf ak yon belye mouton sou chak lotèl. ");
INSERT INTO hat_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Apre sa, Balaram di Balak konsa: -Rete kanpe bò kote ofrann ou mete ap boule la a. Mwen menm, mwen pral wè si Seyè a p'ap vin jwenn mwen. Apre sa, m'a fè ou konnen sa l'a fè m' wè a. Epi l' ale sou tèt yon ti mòn ki pa t' gen yon ti pyebwa sou li. ");
INSERT INTO hat_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Epi Bondye vin jwenn li la. Balaram di l' konsa: -Mwen te fè bati sèt lotèl pou ou, epi mwen te touye yon towo bèf ak yon belye mouton sou chak lotèl pou ou. ");
INSERT INTO hat_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Seyè a pale ak Balaram byen pale. Apre sa, li di l': -Tounen bò kote Balak. W'a pale avè l' jan mwen di ou la. ");
INSERT INTO hat_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Se konsa, Balaram tounen bò kote Balak. Li jwenn li kanpe bò ofrann boule yo ansanm ak lòt chèf moun Moab yo. ");
INSERT INTO hat_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Lèfini, li pran chante chante sa a: -Balak fè m' kite peyi m', peyi Aram. Wa Moab la fè m' desann soti nan mòn bò solèy leve yo. Li di m': Vini non! Vin bay moun Jakòb yo madichon. Vini non! Vin kraponnen moun Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Men ki jan ou ta vle pou m' madichonnen moun Bondye pa madichonnen? Ki jan ou ta vle pou m' kraponnen moun Bondye pa kraponnen? ");
INSERT INTO hat_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mwen kanpe sou tèt gwo wòch yo, mwen wè yo. Antan mwen sou ti mòn yo, m'ap gade anba: Wi, se yon pèp k'ap viv yon jan apa pou kont li. Se yon pèp ki pa menm ak lòt pèp yo! ");
INSERT INTO hat_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ki moun ki ka konte valè pitit Jakòb genyen? Yo anpil tankou grenn pousyè ki sou latè. Ki moun ki ka konte valè pitit Izrayèl yo ye? Mwen ta renmen mouri tankou moun ki mache dwat devan Bondye. Mwen ta renmen fini tankou yo ak kè poze. ");
INSERT INTO hat_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak di Balaram: -Kisa w'ap fè m' konsa? Mwen mennen ou isit la pou bay lènmi m' yo madichon, epi se beni mwen wè w'ap beni yo! ");
INSERT INTO hat_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaram reponn: -Mwen te tou di ou se sèlman pawòl Seyè a va mete nan bouch mwen m'ap di. ");
INSERT INTO hat_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak di Balaram konsa: -Ann al avè m' yon lòt kote. Antan ou va la, ou p'ap wè tout pèp Izrayèl la, men sèlman yon pòsyon ladan l'. W'a rete kanpe la, epi w'a bay ti sa w'a wè a madichon pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Balak pran Balaram, li mennen l' nan jaden Santinèl yo, sou tèt mòn Pisga. Lè l' rive la, li bati sèt lotèl. Epi li touye yon jenn ti towo bèf ak yon belye mouton sou chak lotèl pou Bondye. ");
INSERT INTO hat_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaram di Balak konsa: -Rete kanpe bò kote ofrann ou mete boule sou lotèl yo. Mwen menm, mwen pral kontre ak Bondye pi devan. ");
INSERT INTO hat_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Seyè a vin jwenn Balaram, li pale ak Balaram byen pale ankò, epi li di l': -Tounen al jwenn Balak. W'a pale avè l' jan mwen di ou la. ");
INSERT INTO hat_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Se konsa Balaram tounen bò kote Balak, li jwenn li kanpe bò ofrann boule yo ansanm ak tout chèf moun Moab yo. Epi Balak mande l': -Kisa Seyè a di konsa? ");
INSERT INTO hat_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Epi Balaram pran chante chante sa a: -Souke kò ou, Balak! Vin tande! Pare zòrèy ou, pitit Zipò! ");
INSERT INTO hat_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Bondye pa tankou moun k'ap bay manti. Non! Li pa tankou moun k'ap chanje lide yo pou ti krik ti krak! Depi li pwomèt yon bagay, l'ap fè l'. Depi li pale, fòk sa li di a rive vre! ");
INSERT INTO hat_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Yo ban m' lòd pou m' beni pèp Izrayèl la! Lè Bondye fin bay benediksyon l', nanpwen anyen mwen ka fè ankò. ");
INSERT INTO hat_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Mwen pa wè okenn malè pou moun Jakòb yo. Ni mwen pa wè okenn traka pou moun Izrayèl yo. Seyè a, Bondye yo a, l'a avèk yo. Yo tout kontan, y'ap fè konnen se li ki wa yo. ");
INSERT INTO hat_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Paske, lè Bondye t'ap fè yo soti kite peyi Lejip la, li te ba yo fòs pou yo te goumen tankou towo mawon. ");
INSERT INTO hat_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Pa gen wanga ki ka pran sou moun Jakòb yo. Pa gen maji ki ka fè moun Izrayèl yo anyen. Lè lè a va rive, y'a di moun Jakòb yo ak moun Izrayèl yo: Gade sa Seyè a fè pou nou! ");
INSERT INTO hat_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Gade! Pèp Izrayèl la kanpe tankou yon manman lyon. Yo leve kanpe tankou yon mal lyon. Yo p'ap chita toutotan yo pa fin devore moun ki tonbe anba men yo, toutotan yo pa fin bwè san moun yo touye yo. ");
INSERT INTO hat_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Lè sa a, Balak di Balaram konsa: -Menm jan ou pa vle ba yo madichon an, ou pa t' dwe asepte ba yo benediksyon non plis. ");
INSERT INTO hat_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Men, Balaram reponn Balak, li di l': -Mwen te tou pale ou wi. Mwen te di ou: Tou sa Seyè a va di m' fè, se sa m'ap fè. ");
INSERT INTO hat_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak di Balaram konsa: -Ann al non! Mwen pral mennen ou yon lòt kote. Ou pa janm konnen, antan ou la a, Bondye ka kite ou bay pèp la madichon pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak mennen Balaram sou tèt mòn Peyò a. Antan yo la, yo dekouvri tout dezè a nan pye yo. ");
INSERT INTO hat_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaram di Balak konsa: -Bati sèt lotèl pou mwen isit la. Lèfini, fè m' jwenn sèt jenn ti towo bèf ak sèt belye mouton. ");
INSERT INTO hat_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak fè tou sa Balaram te di l' fè a, epi li touye yon ti towo bèf ak yon belye mouton sou chak lotèl pou Bondye. ");
INSERT INTO hat_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Lè sa a, Balaram te fin konprann se yon sèl bagay Seyè a te vle, se beni pou li beni pèp Izrayèl la. Se poutèt sa, li pa fè tankou lòt fwa yo. Li pa al chache konnen sa Seyè a te vle fè l' konnen an. Men, li bay fas li sou dezè a. ");
INSERT INTO hat_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Li leve je l', epi li wè moun pèp Izrayèl yo ak tant yo byen ranje, chak branch fanmi apa. Lespri Bondye desann sou li. ");
INSERT INTO hat_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Epi li pran chante chante sa a: -Men sa mwen menm, Balaram, pitit Bèyò, m'ap di: Men pawòl k'ap soti nan bouch moun Bondye te louvri je a, ");
INSERT INTO hat_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","pawòl moun ki te tande sa Bondye ap di a, pawòl moun ki te wè sa Bondye ki gen tout pouvwa a fè l' wè a. Lè sa a, li te tonbe fas atè, men Bondye te louvri je l'. ");
INSERT INTO hat_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ala bèl tant nou yo bèl, moun Jakòb yo! Ala bèl kote nou rete a bèl, moun Izrayèl yo! ");
INSERT INTO hat_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Yo laji kò yo tankou dlo larivyè k'ap desann. Yo tankou jaden k'ap pouse sou bò larivyè, tankou yon pye lalwa Bondye li menm ta plante, tankou yon pye sèd k'ap grandi bò kannal dlo. ");
INSERT INTO hat_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Lame pèp Izrayèl la ap fè nasyon yo tranble. Pèp Izrayèl la ap donminen sou anpil lòt pèp. Wa li yo ap pi fò pase wa Agag, Y'ap gouvènen sou anpil nasyon. ");
INSERT INTO hat_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Bondye te mennen yo soti kite peyi Lejip. Li te goumen pou yo tankou yon towo mawon. L'ap manje tout nasyon ki pa vle wè yo. L'ap kraze tout zo yo an miyèt moso. L'ap pèse yo pak an pak ak flèch li yo. ");
INSERT INTO hat_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Pèp Izrayèl la chita atè a, l' ap pran repo, tankou yon lyon, tankou yon fenmèl lyon. Lè l'ap dòmi, ki moun ki ka penmèt yo leve l'? benediksyon pou tout moun ki mande benediksyon pou pèp Izrayèl la! Madichon pou tout moun k'ap mande madichon pou pèp Izrayèl la! ");
INSERT INTO hat_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Lè sa a, Balak fè yon sèl move sou Balaram, li frape pye l' atè, li di konsa: -Mwen te rele ou isit la pou bay lènmi m' yo madichon pou mwen. Men, gade sa ou fè. Se beni ou beni yo pito. Sa fè twa fwa ou fè sa. ");
INSERT INTO hat_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Koulye a, pito ou kouri al lakay ou, tande. Mwen te pwomèt pou m' te fè anpil bèl bagay pou ou. Men, gade sa Seyè a fè ou: ou pèdi tout. ");
INSERT INTO hat_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaram reponn, li di l' konsa: -Mwen te tou pale moun ou te voye chache m' yo. Mwen te di yo: ");
INSERT INTO hat_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Balak te mèt ban mwen kay li plen ajan ak lò, mwen p'ap fè anyen poutèt pa m' ki pou fè m' dezobeyi lòd Seyè a, ni an byen ni an mal. Sa Seyè a di m' di, se sa ase m'ap di. ");
INSERT INTO hat_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Balaram di Balak ankò: -Wi, koulye a mwen pral lakay mwen. Men, anvan m' ale, vini m' di ou kisa pèp Izrayèl la pral fè pèp ou a nan jou k'ap vini yo. ");
INSERT INTO hat_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Epi Balaram pran chante chante sa a: -Men sa mwen menm, Balaram, pitit Bèyò, m'ap di. Men pawòl k'ap soti nan bouch moun Bondye te louvri je a, ");
INSERT INTO hat_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","moun ki ka tande sa Bondye ap di a, moun ki gen konesans ki soti nan men Bondye ki anwo nan syèl la, moun ki te wè sa Bondye ki gen tout pouvwa a fè l' wè a. Li te tonbe fas atè, men Bondye te louvri je l'. ");
INSERT INTO hat_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Mwen wè sa ki gen pou rive pèp Izrayèl la. M'ap gade sa ki pral rive l' pita. Tankou yon gwo zetwal, mwen wè yon chèf k'ap soti nan fanmi Jakòb la. Yon gwo wa pral leve nan mitan pèp Izrayèl la. L'ap kraze chèf Moab yo, l'ap detwi tout pitit Sèt yo. ");
INSERT INTO hat_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Y'a deposede moun Edon yo. Y'a pran peyi Seyi a nan men lènmi l' yo. Men, yo menm, moun Izrayèl yo, y'ap fè mèvèy nan lagè. ");
INSERT INTO hat_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yon gwo chèf pral soti nan pèp Izrayèl la. L'a gouvènen sou yo tout. L'a touye rès moun ki te rete nan lavil yo apre batay la. ");
INSERT INTO hat_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Apre sa, Balaam wè moun Amalèk yo nan vizyon l' lan. Li bay mesaj sa a, li di konsa: -Moun Amalèk yo, se yon nasyon ki fò anpil. Men, bout pou bout, yo gen pou yo disparèt nèt. ");
INSERT INTO hat_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Apre sa, Balaram wè moun Kayen yo nan vizyon l' lan. Li bay mesaj sa a, li di konsa: -Kote ou rete a ou byen pwoteje. Ou ta di yon nich poze sou tèt yon gwo falèz. ");
INSERT INTO hat_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Men, wè pa wè, moun Kayen yo la pou yo fini mal. Peyi Lasiri va depòte yo. ");
INSERT INTO hat_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaram pran pale ankò. Li bay mesaj sa a, li di ankò: -Kilès ki va la lè Bondye va fè tou sa? ");
INSERT INTO hat_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Lè sa a, moun ap soti lavil Kitim nan bato vin anvayi peyi a. Yo pral kraze peyi Lasiri ak lavil Babilòn. Men, ata moun Kitim yo gen pou disparèt nèt tou. ");
INSERT INTO hat_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Apre sa, Balaram leve, li tounen tounen l' lakay li. Epi Balak al fè wout li. ");
INSERT INTO hat_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Pèp Izrayèl la vin moute tant yo nan Fon Zakasya yo. Lè sa a, mesye yo konmanse lage kò yo nan vagabondaj ak fanm peyi Moab yo. ");
INSERT INTO hat_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Medam peyi Moab yo menm envite yo nan seremoni ofrann bèt yo t'ap touye pou bondye pa yo. Moun pèp Izrayèl yo ale vre, yo manje epi yo sèvi bondye moun Moab yo. ");
INSERT INTO hat_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Se konsa pèp Izrayèl la pran sèvi Baal-Peyò. Sa te fè Seyè a ankòlè anpil sou moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Seyè a di Moyiz konsa: -Pran tout chèf pèp la, pann yo gwo midi devan mwen. Konsa, mwen p'ap ankòlè sou yo ankò. ");
INSERT INTO hat_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moyiz di chèf ki te reskonsab pèp la: -Se pou nou chak nou touye tout gason nan moun nou yo ki te al sèvi Baal-Peyò. ");
INSERT INTO hat_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Lè sa a, antan tout moun yo t'ap kriye sou devan pòt Tant Randevou a, yonn nan gason pèp Izrayèl la ale, li mennen yon fanm peyi Madyan lakay li, devan Moyiz ak tout moun pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Lè Fineas, pitit gason Eleaza a, pitit pitit Arawon, prèt la, wè sa, li leve, li kite moun yo kote yo te reyini an, li pase men l', li pran yon frenn. ");
INSERT INTO hat_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Li swiv nonm lan ak fanm lan anba tant lan, epi li pèse tou de, ni nonm lan ni fanm lan, ak frenn lan anba ti vant yo. Lamenm, epidemi ki t'ap ravaje pèp la sispann. ");
INSERT INTO hat_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Te gen vennkatmil (024.000) moun ki te gen tan mouri nan epidemi an. ");
INSERT INTO hat_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","-Se Fineas, pitit gason Eleaza a, pitit pitit gason Arawon prèt la, ki te fè m' sispann ankòlè sou pèp la. Paske nan tout moun sa yo, se li menm ki pa t' ka sipòte wè yon moun nan pèp Izrayèl la kite m' pou l' al sèvi yon lòt bondye. Se poutèt sa, atout mwen t'ap fè jalouzi a, mwen pa fin touye tout pèp la nèt. ");
INSERT INTO hat_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Men sa pou ou di Fineas pou mwen: m'ap siyen yon kontra avè l' ki pou ba li kè poze. ");
INSERT INTO hat_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","M'ap mete li, li menm ak tout ras fanmi l' apre li, pou yo sèvi m' prèt pou tout tan. Paske li te fè m' wè jan li pa t' tolere moun sèvi lòt bondye pase mwen. Se konsa li fè m' padonnen sa pèp la te fè ki mal la. ");
INSERT INTO hat_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Nonm pèp Izrayèl ki te mouri ansanm ak fanm peyi Madyan an te rele Zimri. Se te pitit gason Salou, chèf nan branch fanmi Simeyon an. ");
INSERT INTO hat_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Fanm peyi Madyan yo te touye a te rele Kozbi. Se te pitit fi Sou, ki li menm te chèf yon branch nan fanmi moun Madyan yo. ");
INSERT INTO hat_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Lè sa a, Seyè a pale ak Moyiz, li di l': ");
INSERT INTO hat_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","-Al atake moun Madyan yo. Bat yo byen bay. ");
INSERT INTO hat_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Paske se yo menm ki te atake nou anvan ak malefis yo te voye sou nou nan zafè Peyò a, ak nan zafè Kozbi a, pitit fi chèf peyi Madyan an, moun menm ras ak yo a, fanm yo te touye lè epidemi te tonbe sou nou nan peyi Peyò a. ");
INSERT INTO hat_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Apre epidemi an, Seyè a pale ak Moyiz ansanm ak Eleaza, pitit gason Arawon, prèt la, li di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","-Nou pral fè resansman tout moun pèp Izrayèl la, tou sa ki gen ventan osinon ki pi gran, chak fanmi apa, dapre zansèt yo. W'a pran non tout gason nan pèp Izrayèl la ki bon pou fè lagè. ");
INSERT INTO hat_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Se konsa, antan pèp la nan plenn peyi Moab yo, toupre larivyè Jouden, anfas lavil Jeriko, Moyiz ak Eleaza, prèt la, ba yo lòd ");
INSERT INTO hat_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","pou tout gason ki gen ventan osinon ki pi gran vin bay non yo, dapre lòd Seyè a te bay Moyiz. Men moun pèp Izrayèl la ki te soti kite peyi Lejip: ");
INSERT INTO hat_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Nan branch fanmi Woubenn, premye pitit gason Izrayèl la, te gen fanmi moun Enòk yo, fanmi moun Palou yo, ");
INSERT INTO hat_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","fanmi moun Ezwon yo ak fanmi moun Kami yo. ");
INSERT INTO hat_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Se tout moun sa yo ki nan branch fanmi Woubenn lan. Lè resansman an, yo te jwenn karanntwamil sètsantrant (043.730) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palou te papa Eliyab. ");
INSERT INTO hat_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliyab te papa Nemwèl, Datan ak Abiram. Se Datan ak Abiram sa yo, de nèg moun yo te konsidere anpil, ki te revòlte kont Moyiz ak Arawon. Yo te fè pati bann moun Kore yo ki te revòlte kont Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Lè sa a, tè a te louvri, li vale yo, epi yo mouri ansanm ak Kore ak tout bann moun li yo. Jou sa a, dife te boule desansenkant (0250) moun. Se te yon avètisman pou pèp la. ");
INSERT INTO hat_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Men, pitit gason Kore yo pa t' mouri lè sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Men pitit gason Simeyon yo ak tout kòt fanmi yo. Te gen fanmi moun Nemwèl yo, fanmi moun Yamen yo, fanmi moun Yakim yo, ");
INSERT INTO hat_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","fanmi moun Zera yo ak fanmi moun Sayil yo. ");
INSERT INTO hat_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Se tout moun sa yo ki nan branch fanmi Simeyon an. Lè resansman an, te gen venndemil desan (022.200) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Men pitit gason Gad yo ak tout kòt fanmi yo. Te gen fanmi moun Sefon yo, fanmi moun Agi yo, fanmi moun Chouni yo, ");
INSERT INTO hat_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","fanmi moun Ozni yo, fanmi moun Eri yo, ");
INSERT INTO hat_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","fanmi moun Awòd yo, fanmi moun Areli yo. ");
INSERT INTO hat_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Se tout moun sa yo ki nan branch fanmi Gad la. Lè resansman an, te gen karantmil senksan (040.500) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Men pitit gason Jida yo. Te gen Er ak Onan, men yo tou de mouri nan peyi Kanaran san kite pitit. ");
INSERT INTO hat_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Apre yo, te gen Chela, Perèz ak Zirak, ki bay yo chak yon kòt fanmi. ");
INSERT INTO hat_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perèz te gen de pitit gason. Yo chak bay yon fanmi apa. Se te fanmi Eswon an ak fanmi Amoul lan. ");
INSERT INTO hat_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Se tout moun sa yo ki nan branch fanmi Jida a. Lè resansman an, te gen swasannsèzmil senksan (076.500) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Men pitit gason Isaka yo ak tout kòt fanmi yo. Te gen fanmi moun Tola yo, fanmi moun Pouva yo, ");
INSERT INTO hat_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","fanmi moun Yachoub yo, fanmi moun Chimwon yo. ");
INSERT INTO hat_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Se tout moun sa yo ki te fè pati branch fanmi Isaka a. Lè resansman an, yo te jwenn swasannkatmil twasan (064.300) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Men pitit gason Zabilon yo ak tout kòt fanmi yo. Te gen fanmi moun Serèd yo, fanmi moun Elon yo, fanmi moun Yaleyèl yo. ");
INSERT INTO hat_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Se tout moun sa yo ki te fè pati branch fanmi Zabilon an. Lè resansman an, yo te jwenn swasantmil senksan (060.500) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Jozèf te gen de pitit gason: Manase ak Efrayim. ");
INSERT INTO hat_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Men pitit gason Manase yo ak tout kòt fanmi yo: Te gen fanmi moun Maki yo. Maki te papa Galarad ki te bay fanmi moun Galarad yo. ");
INSERT INTO hat_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Galarad te fè sis pitit gason, yo chak bay yon branch fanmi. Te gen fanmi moun Yezè yo, fanmi moun Elèk yo, ");
INSERT INTO hat_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","fanmi moun Asriyèl yo, fanmi moun Sichèm yo, ");
INSERT INTO hat_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","fanmi moun Chemida yo, fanmi moun Efè yo. ");
INSERT INTO hat_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Men Zelofeyad, pitit gason Efè a, pa t' gen pitit gason. Se annik pitit fi li te genyen. Men non yo: Se te Mala, Noa, Ogla, Milka ak Tisa. ");
INSERT INTO hat_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Se tout moun sa yo ki te fè pati branch fanmi Manase a. Lè resansman an, yo te jwenn senkanndemil sètsan (052.700) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Men pitit gason Efrayim yo ak tout kòt fanmi yo: Te gen fanmi moun Choutela yo, fanmi moun Bekè yo, fanmi moun Tayan yo. ");
INSERT INTO hat_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Choutela poutèt pa l' te gen yon pitit gason. Se te Eran ki bay yon fanmi apa. ");
INSERT INTO hat_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Se tout moun sa yo ki te nan branch Efrayim lan. Lè resansman an, yo te jwenn tranndemil senksan (032.500) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Men pitit gason Benjamen yo ak tout kòt fanmi yo: Te gen fanmi moun Bela yo, fanmi moun Achbèl yo, fanmi moun Ayiram yo, ");
INSERT INTO hat_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","fanmi moun Choufan yo ak fanmi moun Oufam yo. ");
INSERT INTO hat_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela pou tèt pa l' te gen de pitit gason ki bay de lòt branch nan branch fanmi an ankò. Se te Ad ak Naaman. ");
INSERT INTO hat_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Se tout moun sa yo ki te fè pati branch fanmi Benjamen an. Lè resansman an, yo te jwenn karannsenkmil sisan (045.600) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Men pitit gason Dann lan ak tout kòt fanmi l'. Se te fanmi moun Chwanm yo. Se tout moun sa yo ki te fè pati branch fanmi Dann lan. ");
INSERT INTO hat_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Lè resansman an, yo te jwenn swasannkatmil katsan (064.400) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Men pitit gason Asè yo ak tout kòt fanmi yo. Te gen fanmi moun Imna yo, fanmi moun Ichvi yo ak fanmi moun Berya yo. ");
INSERT INTO hat_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Berya pou tèt pa l' te gen de pitit gason ki bay de lòt branch nan fanmi an ankò: Se te Ebè ak Malkiyèl. ");
INSERT INTO hat_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asè te gen yon pitit fi yo te rele Sera. ");
INSERT INTO hat_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Se tout moun sa yo ki te fè pati branch fanmi Asè a. Lè resansman an, yo te jwenn senkanntwamil katsan (053.400) gason nan branch fanmi sa a. ");
INSERT INTO hat_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Men pitit gason Neftali yo ak tout kòt fanmi yo. Te gen fanmi moun Yazeyèl yo, fanmi moun Gouni yo, ");
INSERT INTO hat_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","fanmi moun Yesè yo ak fanmi moun Chilèm yo. ");
INSERT INTO hat_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Se tout moun sa yo ki te fè pati branch fanmi Neftali a, fanmi pa fanmi. Lè resansman an, yo te konte karannsenkmil katsan (045.400) gason nan fanmi sa yo. ");
INSERT INTO hat_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Konsa, te gen antou sisan enmil sètsantrant (0601.730) gason nan tout pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","-Nou pral separe peyi a bay chak fanmi pòsyon pa yo dapre kantite gason yo jwenn nan chak. ");
INSERT INTO hat_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Fanmi ki gen anpil gason va resevwa yon pi gwo pòsyon. Fanmi ki pa gen anpil gason va resevwa yon pi piti pòsyon. Chak fanmi va resevwa yon pòsyon dapre kantite gason ki gen ladan l'. ");
INSERT INTO hat_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Men, pou fè separasyon peyi a, n'a tire osò: chak fanmi va resevwa pòsyon pa l' dapre kantite moun yo te konte nan chak. ");
INSERT INTO hat_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Y'a tire osò pou yo separe bay chak branch fanmi pòsyon pa yo: yon gwo pòsyon pou chak branch fanmi ki anpil, yon ti pòsyon pou chak branch fanmi ki pa anpil. ");
INSERT INTO hat_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Men, nan branch fanmi Levi a, men moun yo te konte dapre fanmi yo. Te gen fanmi Gèchon an, fanmi Keyat la ak fanmi Merari a. ");
INSERT INTO hat_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Men lòt fanmi Levi yo: moun Libni yo, moun Ebwon yo, moun Makli yo, moun Mouchi yo ak moun Kore yo. Keyat te papa Amram. ");
INSERT INTO hat_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Madan Amram te rele Yokebèd. Se te yon pitit fi Levi. Li te fèt nan peyi Lejip. Li te fè twa pitit pou Amram: Arawon, Moyiz ak Miryam, sè yo. ");
INSERT INTO hat_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Arawon te papa kat pitit gason: Nadab, Abiyou, Eleaza ak Itama. ");
INSERT INTO hat_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab ak Abiyou te mouri lè yo te ofri bay Seyè a yon dife yo pa t' dwe ofri. ");
INSERT INTO hat_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Lè resansman an, yo te jwenn nan branch fanmi sa a venntwamil (023.000) gason ki te gen yon mwa depi yo te fèt osinon ki te pi gran. Yo pa t' konte yo ansanm ak rès pèp Izrayèl la, paske yo pa t'ap resevwa okenn pòsyon nan tè ki pou pèp la. ");
INSERT INTO hat_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Men tout moun Moyiz ak Eleaza te konte lè yo t'ap fè resansman moun pèp Izrayèl la nan plenn Moab yo, lòt bò larivyè Jouden, anfas lavil Jeriko. ");
INSERT INTO hat_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Pami yo pa t' gen yonn menm nan sa Moyiz ak Arawon te konte lè yo t'ap fè premye resansman pèp Izrayèl la nan dezè Sinayi a. ");
INSERT INTO hat_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Paske Seyè a te di yo tout gen pou mouri nan dezè a. Yo tout te mouri vre, esepte Kaleb, pitit gason Jefoune a ak Jozye, pitit gason Noun lan. ");
INSERT INTO hat_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Lè sa a, te gen nan branch fanmi Manase a senk fi, Mala, Noa, Ogla, Milka ak Tiza. Yo tout te pitit fi Zelochad. Zelochad sa a te pitit gason Efè. Efè te pitit gason Galarad, ki te pitit gason Maki, ki li menm te pitit gason Manase, ki te pitit gason Jozèf. ");
INSERT INTO hat_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Medam yo vini, yo kanpe devan Moyiz ak Eleaza, prèt la, devan chèf fanmi yo ak devan tout pèp la, devan pòt Tant Randevou a, epi yo di: ");
INSERT INTO hat_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","-Papa nou mouri nan dezè a san li pa kite okenn pitit gason. Li pa t' fè pati bann moun Kore yo ki te revòlte kont Seyè a. Se poutèt pwòp peche pa l' yo kifè li mouri san li pa t' gen tan gen pitit gason. ");
INSERT INTO hat_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Se pa paske papa nou pa t' gen pitit gason kifè pou non li disparèt nan fanmi an. Ban nou yon pòsyon tè tou nan mitan fanmi papa nou. ");
INSERT INTO hat_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moyiz al pale koze a avèk Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Seyè a di l' konsa; ");
INSERT INTO hat_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","-Pitit fi Zelochad yo gen rezon. W'a ba yo yon pòsyon tè ki va rete pou yo nan mitan fanmi papa yo. W'a ba yo pòsyon tè ki te pou papa yo a. ");
INSERT INTO hat_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Apre sa, w'a pale ak moun pèp Izrayèl yo, w'a di yo konsa: Si yon moun mouri san li pa kite pitit gason, n'a renmèt pòsyon tè pa l' la bay pitit fi li yo. ");
INSERT INTO hat_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Si li pa gen pitit fi, n'a renmèt pòsyon tè pa l' la bay frè l' yo. ");
INSERT INTO hat_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Si li pa gen frè, n'a renmèt tè a bay frè papa l' yo. ");
INSERT INTO hat_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Si papa l' pa t' gen frè, n'a renmèt li bay fanmi pi pre l' la. Epi tè a va rete pou li. Se pou moun pèp Izrayèl yo swiv regleman sa a tankou yon lwa, jan mwen menm Seyè a, mwen te bay Moyiz lòd la. ");
INSERT INTO hat_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Seyè a di Moyiz konsa: -Moute sou mòn Abarim. Voye je ou gade peyi mwen pral bay moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Lè w'a fin wè li, ou pral mouri, tankou Arawon, frè ou la. ");
INSERT INTO hat_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","paske nou tou de nou pa t' fè sa m' te di nou fè a nan dezè Zin lan. Lè pèp la t'ap chache m' kont bò sous dlo Meriba yo, nou te refize kite m' fè yo wè pouvwa mwen nan zafè dlo a. (Meriba se sous dlo bò Kadès nan dezè Zin lan.) ");
INSERT INTO hat_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Lè sa a, Moyiz pale ak Seyè a, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","-O Seyè, Bondye ki bay tout moun lavi, tanpri, chwazi yon nonm ki ka mennen pèp la, ");
INSERT INTO hat_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","yon nonm ki ka mache alatèt yo nan tout antre soti yo, pou pèp ou a, pèp Seyè a, pa rete tankou yon bann mouton san gadò pou okipe yo. ");
INSERT INTO hat_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Seyè a reponn Moyiz: -Pran Jozye, pitit gason Noun lan. Se yon nonm ki gen lespri Bondye k'ap travay nan kè l'. W'a mete men ou sou tèt li, ");
INSERT INTO hat_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","epi w'a fè l' kanpe devan Eleaza, prèt la, ak devan tout pèp la. Epi la, devan yo tout, w'a ba li tout lòd ou gen pou ba li. ");
INSERT INTO hat_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","W'a separe avè l' pouvwa otorite ou genyen an, pou tout moun nan pèp Izrayèl la ka obeyi l'. ");
INSERT INTO hat_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","L'a toujou kanpe devan Eleaza, prèt la, ki va sèvi ak Ourim yo pou chache konnen sa mwen vle yo fè. Se konsa, Eleaza va dirije Jozye ak tout pèp la nan tout antre soti yo. ");
INSERT INTO hat_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moyiz fè jan Seyè a te ba li lòd fè a. Li pran Jozye, li fè l' kanpe devan Eleaza, prèt la, ak tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Li mete men l' sou tèt li, epi li ba li lòd li yo, jan Seyè a te di l' la. ");
INSERT INTO hat_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","-Men lòd w'a bay moun pèp Izrayèl yo. W'a di yo pou mwen: Se pou yo toujou chonje dat pou yo fè ofrann yo, dat pou yo vin pote ofrann y'ap boule nèt pou mwen nan dife, ofrann k'ap fè m' plezi ak bon sant yo. ");
INSERT INTO hat_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","W'a di yo pou mwen: Men ofrann pou nou boule nan dife pou Seyè a. Chak jou, san sote yonn, n'a ofri de ti mouton ki gen ennan, ki pa gen okenn enfimite. N'a boule yo nèt nan dife pou mwen. ");
INSERT INTO hat_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","N'a ofri premye ti mouton an nan maten, n'a ofri lòt la nan aswè. ");
INSERT INTO hat_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Ansanm avèk chak ti mouton, n'a ofri sèt ti mamit farin frans melanje ak de boutèy ka plen pi bon kalite lwil oliv ou ka jwenn. ");
INSERT INTO hat_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","(Sa se ofrann pou yo boule nèt chak jou nan dife, ofrann yo te konn fè nan tan lontan sou mòn Sinayi a, tankou yon manje yo boule pou Seyè a, yon ofrann k'ap fè Seyè a plezi ak bon sant li.) ");
INSERT INTO hat_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Avèk chak ti mouton, n'a ofri de boutèy ka bwason, n'a vide l' sou lotèl la pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Nan aswè, n'a boule dezyèm ti mouton an menm jan nou te fè l' nan maten an. N'a fè ofrann farin frans lan tou ansanm ak bwason an. Se va yon manje n'a boule nèt pou Seyè a, yon ofrann k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Pou jou repo a, n'a ofri de ti belye mouton ki gen ennan, ki san okenn enfimite, kat ti mamit farin frans melanje ak lwil oliv tankou ofrann grenn jaden ak yon ofrann bwason. ");
INSERT INTO hat_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Chak jou repo, se pou nou fè ofrann sa yo an menm tan ak ofrann pou chak jou yo ansanm ak ofrann bwason yo. ");
INSERT INTO hat_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Nan konmansman chak mwa, n'a fè yon ofrann boule pou Seyè a. Lè sa a, n'a ofri de towo bèf, yon belye mouton ak sèt ti mouton ki gen ennan. Epi fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","N'a fè yon ofrann grenn manje tou ansanm ak chak bèt. Pou chak towo bèf, n'a ofri vennkat ti mamit farin frans melanje ak lwil oliv. Pou chak belye mouton, n'a ofri katòz ti mamit farin frans tankou yon ofrann grenn manje. ");
INSERT INTO hat_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Pou chak ti mouton, n'a ofri sèt ti mamit farin frans. Se va yon ofrann n'a boule nèt pou Seyè a, yon ofrann k'ap fè Seyè a plezi ak bon sant li. ");
INSERT INTO hat_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","N'a fè ofrann bwason tou: kat boutèy ka pou chak towo bèf, twa boutèy ka pou belye mouton an ak de boutèy ka pou chak ti mouton. Se ofrann sa yo n'a boule nèt pou Seyè a, nan konmansman chak mwa, pandan tout lanne a. ");
INSERT INTO hat_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Anplis ofrann pou chak jou yo, w'a touye yon bouk pou mande padon pou peche, epi w'a ofri tou ofrann bwason ki toujou mache ansanm avè l' la. ");
INSERT INTO hat_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Katòzyèm jou nan premye mwa a, n'a fete fèt Delivrans lan pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Kenzyèm jou menm mwa a va yon gwo jou fèt. Pandan sèt jou, n'a manje pen ki fèt san ledven. ");
INSERT INTO hat_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Sou premye jou a, n'a reyini tout moun pou vin adore Seyè a. Lè sa a, pesonn p'ap gen dwa fè okenn gwo travay. ");
INSERT INTO hat_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","N'a fè ofrann bèt pou yo boule nèt pou Seyè a: de jenn towo bèf, yon belye mouton ak sèt ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","N'a fè ofrann grenn jaden sou fòm farin frans melanje ak lwil oliv: venteyen ti mamit pou chak towo, katòz ti mamit pou belye mouton an, ");
INSERT INTO hat_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ak sèt ti mamit pou chak ti mouton. ");
INSERT INTO hat_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","N'a ofri tou yon bouk pou yo touye pou mande padon pou peche. Se konsa, n'a fè ofrann bèt pou nou touye pou mande Bondye gras pou pèp la. ");
INSERT INTO hat_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","N'a fè tout ofrann sa yo anplis ofrann bèt nou gen pou nou boule chak maten san sote jou a. ");
INSERT INTO hat_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Se va menm jan an tou pou tout sèt jou yo. Chak jou n'a ofri manje pou yo boule nèt pou Seyè a: se va tankou yon ofrann k'ap fè Seyè a plezi ak bon sant li. N'a fè ofrann sa a anplis ofrann bèt pou yo boule chak jou pou Seyè a ak ofrann bwason ki mache avè l' la. ");
INSERT INTO hat_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Sou setyèm jou a, n'a reyini tout pèp la ankò pou n' fè sèvis pou Seyè a. Jou sa a, nou p'ap fè okenn gwo travay non plis. ");
INSERT INTO hat_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Konsa tou, premye jou fèt premye rekòt la, lè n'ap pote ofrann grenn nou fèk rekòlte yo bay Seyè a, n'a reyini tout moun pou yo vin fè sèvis pou Bondye. Jou sa a, pesonn p'ap gen dwa fè okenn gwo travay. ");
INSERT INTO hat_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Men bèt n'a ofri pou yo boule nèt nan dife pou Seyè a, ofrann ki va fè Seyè a plezi ak bon sant li: de jenn towo, yon belye mouton ak sèt ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","N'a fè ofrann grenn jaden yo tou sou fòm farin frans melanje ak lwil oliv: ki vle di venteyen ti mamit pou chak towo, katòz ti mamit pou belye mouton an ");
INSERT INTO hat_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ak sèt ti mamit pou chak ti mouton yo. ");
INSERT INTO hat_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","N'a ofri tou yon bouk pou mande Bondye padon pou peche. Se konsa n'a fè ofrann bèt pou yo touye pou mande Bondye gras pou tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","N'a ofri bèt sa yo ansanm ak ofrann bwason ki mache avèk yo chak, anplis ofrann bèt pou yo boule chak jou a ansanm ak ofrann grenn jaden yo. Se pou tout bèt yo san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Premye jou setyèm mwa a, n'a sanble tout moun pou yo vin fè sèvis pou adore Bondye. Jou sa a, pesonn p'ap gen dwa fè okenn gwo travay. Se jou sa a tou, y'a kònen twonpèt yo pou fè konnen jou a rive. ");
INSERT INTO hat_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Men bèt n'a ofri pou yo boule nèt nan dife pou Seyè a, men ofrann ki va fè Seyè a plezi ak bon sant li: yon jenn towo bèf, yon belye mouton ak sèt ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","N'a fè ofrann grenn jaden yo tou sou fòm farin frans melanje ak lwil oliv: ki vle di venteyen ti mamit farin frans pou towo a, katòz ti mamit pou belye mouton an, ");
INSERT INTO hat_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ak sèt ti mamit pou chak ti mouton yo. ");
INSERT INTO hat_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","N'a ofri tou yon bouk kabrit pou mande padon pou peche. Se konsa n'a fè ofrann bèt pou touye pou mande Bondye gras pou tout pèp la. ");
INSERT INTO hat_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","N'a fè ofrann sa yo anplis ofrann bèt pou yo boule nan dife chak premye jou nan mwa yo ansanm ak ofrann grenn jaden ki toujou mache avèk yo a, mete sou ofrann bèt pou yo boule chak jou a ansanm ak ofrann grenn jaden ak bwason ki toujou mache avè l' la. Se ofrann manje sa yo n'a boule nèt pou Seyè a. Se va ofrann k'ap fè Seyè a plezi ak bon sant yo. ");
INSERT INTO hat_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Dizyèm jou setyèm mwa a, n'a reyini tout moun pou yo vin fè sèvis pou Bondye. Jou sa a, tout moun va rete san manje. Pesonn p'ap gen dwa fè okenn travay. ");
INSERT INTO hat_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","N'a ofri bèt pou yo boule nèt nan dife pou Bondye. Se va yon ofrann ki va fè Seyè a plezi ak bon sant li. Men bèt n'a ofri: yon towo bèf, yon belye mouton, sèt ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","N'a fè ofrann grenn jaden ki pou mache ak chak bèt sou fòm farin frans melanje ak lwil oliv: ki vle di venteyen ti mamit farin pou towo bèf la, katòz ti mamit pou belye mouton an ");
INSERT INTO hat_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ak sèt ti mamit pou chak ti mouton yo. ");
INSERT INTO hat_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","N'a ofri tou yon bouk pou mande Bondye padon pou peche anplis ofrann bèt pou touye pou gran jou padon an, mete sou ofrann bèt pou yo boule chak jou a ansanm ak ofrann grenn jaden yo ak ofrann bwason ki mache ak yo a. ");
INSERT INTO hat_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Kenzyèm jou setyèm mwa a, n'a reyini tout moun pou yo vin adore Bondye. Jou sa a, pesonn p'ap gen dwa fè okenn gwo travay. N'a fè yon fèt pou Seyè a pandan sèt jou. ");
INSERT INTO hat_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Premye jou a, n'a ofri bèt pou yo boule nèt nan dife pou Seyè a, ofrann ki va fè Seyè a plezi ak bon sant li: Men bèt pou nou ofri: trèz towo bèf, de belye mouton, katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Men ofrann grenn jaden sou fòm farin frans melanje ak lwil oliv ki pou mache ak bèt yo: venteyen ti mamit farin frans pou chak towo, katòz ti mamit pou chak belye, ");
INSERT INTO hat_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ak sèt ti mamit pou chak ti mouton, ansanm ak ofrann bwason ki pou mache ak yo chak. ");
INSERT INTO hat_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","N'a ofri tou yon bouk kabrit pou mande Bondye padon pou peche. N'a fè ofrann sa yo anplis ofrann pou nou boule nèt chak jou a ansanm ak ofrann grenn jaden ak ofrann diven ki pou mache avè l' yo. ");
INSERT INTO hat_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Dezyèm jou fèt la, n'a ofri douz towo bèf, de belye mouton ak katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Ansanm ak chak bèt n'a fè ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an. ");
INSERT INTO hat_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Epi, anplis ofrann bèt nou fè pou yo boule nèt pou Seyè a chak jou ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo a, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche. ");
INSERT INTO hat_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Twazyèm jou fèt la, n'a ofri onz towo bèf, de belye mouton ak katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Ansanm ak chak bèt n'a fè ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an. ");
INSERT INTO hat_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Epi, anplis ofrann bèt nou fè chak jou pou yo boule nèt pou Seyè a ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo a, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche. ");
INSERT INTO hat_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Katriyèm jou fèt la, n'a ofri dis towo bèf, de belye mouton ak katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Ansanm ak chak bèt n'a fè ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an. ");
INSERT INTO hat_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Epi, anplis ofrann bèt nou fè chak jou pou yo boule nèt pou Seyè a ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo a, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche. ");
INSERT INTO hat_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Senkyèm jou fèt la, n'a ofri nèf towo, de belye mouton ak katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Ansanm ak chak bèt n'a fè ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an. ");
INSERT INTO hat_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Epi, anplis ofrann bèt nou fè chak jou pou boule nèt pou Seyè a ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo a, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche. ");
INSERT INTO hat_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Sizyèm jou fèt la, n'a ofri wit towo, de belye mouton ak katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Ansanm ak chak bèt n'a fè ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an. ");
INSERT INTO hat_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Epi, anplis ofrann bèt nou fè chak jou pou boule nèt pou Seyè a ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo a, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche. ");
INSERT INTO hat_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Setyèm jou fèt la, n'a ofri sèt towo, de belye mouton ak katòz ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Ansanm ak chak bèt n'a fè ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an. ");
INSERT INTO hat_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Epi, anplis ofrann bèt nou fè chak jou pou boule nèt pou Seyè a ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo a, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche. ");
INSERT INTO hat_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Wityèm jou fèt la, n'a sanble tout moun pou adore Bondye. Jou sa a, pesonn p'ap fè okenn gwo travay. ");
INSERT INTO hat_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","N'a fè ofrann bèt pou yo boule nèt nan dife, ofrann ki va fè Seyè a plezi ak bon sant li. Men bèt pou nou ofri: yon towo bèf, yon belye mouton ak sèt ti mouton ki gen ennan. Fòk yo tout san okenn enfimite. ");
INSERT INTO hat_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Ansanm ak chak bèt n'a ofri ofrann grenn jaden ak ofrann bwason ki pou mache ak yo, dapre regleman an, ");
INSERT INTO hat_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Epi, anplis ofrann bèt nou fè chak jou pou boule nèt pou Seyè a ansanm ak ofrann grenn jaden ak ofrann bwason ki mache ak yo, n'a ofri yon bouk kabrit pou yo touye pou mande Bondye padon pou peche yo. ");
INSERT INTO hat_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Men tou sa nou va ofri bay Seyè a lè n'ap fè gwo fèt nou dwe fè pou li yo, apa ofrann n'ap fè paske nou te pran angajman pou nou te fè yo, ou ankò ofrann n'ap fè paske nou rete konsa nou vle fè l', mete sou bèt n'ap ofri pou boule nèt nan dife pou Bondye, sou ofrann grenn jaden ak ofrann bwason yo, ak sou ofrann nou fè pou di Bondye mèsi. ");
INSERT INTO hat_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Se konsa Moyiz te di pèp Izrayèl la tou sa Seyè a te ba li lòd di yo. ");
INSERT INTO hat_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moyiz pale ak chèf branch fanmi pèp Izrayèl yo. Li di yo konsa: -Men lòd Seyè a bay. ");
INSERT INTO hat_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Lè yon moun fè yon ve l'ap bay Seyè a kichòy ou ankò lè yon moun pwomèt li p'ap fè yon bagay, li pa fèt pou l' pa kenbe pawòl. Se pou l' fè tou sa li te pwomèt l'ap fè a. ");
INSERT INTO hat_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Si yon jenn fi ki lakay papa l' toujou fè yon ve l'ap bay Seyè a kichòy ou ankò li pwomèt pou l' pa fè yon bagay, ");
INSERT INTO hat_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","lè papa a vin konn sa, si li pa di l' anyen, jenn fi a gen obligasyon pou l' kenbe ve li te pran an, osinon pwomès li te fè a. ");
INSERT INTO hat_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Men, si lè papa a vin konn sa, li fè opozisyon, ni ve jenn fi a te pran yo ni pwomès li te fè yo pa kenbe ankò: yo pa vo anyen. Seyè a p'ap gade sou sa, li p'ap fè l' anyen, paske se pa fòt li. Se papa l' ki derefize kite l' kenbe pawòl li. ");
INSERT INTO hat_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Si yon jenn fi te anba obligasyon pou l' te kenbe yon ve li te pran osinon yon pwomès li te fè, menm si li te pran yo an jwèt, si li rive marye, ");
INSERT INTO hat_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","epi mari a pa di l' anyen lè li vin konn sa, fi a gen obligasyon pou l' kenbe ve li te pran an osinon pwomès li te fè a. ");
INSERT INTO hat_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Men, si jou mari a vin konn sa li fè opozisyon, lamenm li wete fanm lan anba obligasyon li te genyen pou l' te kenbe ve li te pran an osinon pwomès li te fè a. Seyè a p'ap gade sou sa, li p'ap fè l' anyen. ");
INSERT INTO hat_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Men lè yon fanm ki vèv osinon ki divòse fè yon ve pou l' bay Seyè a kichòy, osinon li pwomèt pou l' pa fè yon bagay, se pou l' kenbe pawòl li. ");
INSERT INTO hat_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Si yon madanm marye, antan li lakay mari l', pran yon ve pou fè kichòy osinon pwomèt pou l' pa fè yon bagay, ");
INSERT INTO hat_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","epi si lè mari l' vin konn sa, li pa di l' anyen, li pa fè okenn opozisyon, fanm lan gen obligasyon pou l' kenbe ve li te pran an osinon pwomès li te fè a, nenpòt kisa yo te ye. ");
INSERT INTO hat_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Men, si mari a vin konn sa, epi menm jou li vin konn sa a, li di li pa dakò, fanm lan p'ap nan obligasyon pou l' kenbe pawòl ni pou ve li te pran an, ni pou pwomès li te fè a. Se mari a ki te derefize kite l' kenbe pawòl li. Konsa, Seyè a p'ap gade sou sa, li p'ap fè l' anyen. ");
INSERT INTO hat_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Yon mari gen dwa dakò, konsa tou li gen dwa refize dakò kite madanm li kenbe pawòl li, ni pou ve madanm li te pran an, ni pou pwomès li te fè a. ");
INSERT INTO hat_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Men, si apre mari a vin konn sa li kite yon jou pase, li pa di l' anyen ankò, sa vle di li dakò ak ve madanm li te pran an osinon ak pwomès madanm lan te fè a. Depi mari a pa di l' anyen lè li vin konn sa, sa vle di se dakò li dakò. ");
INSERT INTO hat_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Men si, apre mari a vin konn angajman madanm lan te pran an, mari a kite kèk jou pase anvan li di li pa dakò, se li menm k'ap sibi chatiman ki pou ta tonbe sou madanm lan pou pawòl li pa kenbe a. ");
INSERT INTO hat_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Men tout regleman Seyè a te bay Moyiz pou yon fanm ki fè ve osinon ki pran yon angajman. Si li marye, men tout jan mari a ka boule avè l' nan ka sa a. Si li poko marye, li lakay papa l' toujou, men tout jan papa a ka pran sa. ");
INSERT INTO hat_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Seyè a pale ak Mwiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","-Ou pral pini moun Madyan yo pou sa yo fè moun pèp Izrayèl yo pase. Apre sa, ou pral mouri pou ou al jwenn moun pa ou yo ki mouri deja. ");
INSERT INTO hat_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Se konsa, Moyiz pale ak pèp la, li di yo konsa: -Pare kèk gason nan mitan nou pou y' al goumen, pou yo mache pran moun Madyan yo, fè yo peye sa yo fè Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","N'a pran mil gason nan chak branch fanmi pèp Izrayèl la pou n' voye al goumen. ");
INSERT INTO hat_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Se konsa nan tout kantite gason ki nan pèp Izrayèl la, yo pran mil gason nan chak branch fanmi. Sa te bay douzmil (012.000) gason antou ki te pare pou al goumen. ");
INSERT INTO hat_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moyiz voye douzmil gason sa yo al fè lagè. Li voye ak yo Fineas, pitit gason Eleaza, prèt la, ki t'ap pote veso Bondye yo ak twonpèt pou bay siyal yo. ");
INSERT INTO hat_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Yo atake moun Madyan yo jan Seyè a te bay Moyiz lòd la, yo touye tout gason yo. ");
INSERT INTO hat_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Yo touye senk wa moun Madyan yo: Evi, Rekèm, Zou, Our ak Reba. Yo touye Balaram, pitit Beyò a, tou. ");
INSERT INTO hat_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Moun Izrayèl yo fè tout fanm ak tout timoun Madyan yo prizonye. Yo pase men yo pran tout bèf yo, tout mouton yo, tout kabrit yo ak tout lòt byen yo. ");
INSERT INTO hat_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Yo boule tout kay nan lavil yo ak tout kan kote moun yo te rete. ");
INSERT INTO hat_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Apre sa, yo pran tou sa yo te ranmase, tout bèt ak tout moun yo te fè prizonye yo, ");
INSERT INTO hat_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","yo mennen yo bay Moyiz ansanm ak Eleaza, prèt la, ak tout moun pèp Izrayèl yo ki te nan kan an, nan plenn Moab yo, lòt bò larivyè Jouden, anfas lavil Jeriko. ");
INSERT INTO hat_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moyiz, Eleaza, prèt la ak tout chèf pèp Izrayèl yo soti nan kan an al kontre lame a. ");
INSERT INTO hat_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Moyiz move sou chèf reskonsab lame yo, sou chèf divizyon mil yo ak chèf konpayi san yo ki t'ap tounen soti nan lagè a. ");
INSERT INTO hat_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Li di yo konsa: -Poukisa nou pa touye tout medam sa yo? ");
INSERT INTO hat_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Se yo menm ki te swiv konsèy Balaram yo, se yo ki te lakòz moun pèp Izrayèl yo te vire do bay Bondye nan zafè Baal-Peyò a, kifè gwo malè nou konnen an te tonbe sou pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Se pou nou touye tout pitit gason yo. Se pou nou touye tout fanm ki kouche ak gason deja. ");
INSERT INTO hat_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Men, n'a sove lavi tout jenn fi ki poko janm kouche ak gason. N'a pran yo pou nou. ");
INSERT INTO hat_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Men, nou menm ki touye moun osinon ki manyen kadav moun mouri, nou pral rete sèt jou andeyò limit kan an. Sou twazyèm jou a ak sou setyèm jou a n'a fè sèvis pou mete nou nan kondisyon, nou menm ak tout prizonye nou yo, pou nou ka fè sèvis Bondye. ");
INSERT INTO hat_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","N'a fè sèvis pou mete tout rad ak tout bagay ki fèt ak po bèt, bagay ki fèt ak pwal kabrit, bagay ki fèt an bwa, nan kondisyon pou moun k'ap sèvi Bondye ka sèvi ak yo. ");
INSERT INTO hat_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Eleaza, prèt la, pale ak mesye ki te tounen soti nan lagè yo. Li di yo konsa: -Men yon regleman nou jwenn nan lòd Seyè a te bay Moyiz. ");
INSERT INTO hat_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Tout moso lò, tout moso ajan, tout bout fè, tout moso kwiv, tout moso plon, ");
INSERT INTO hat_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tou sa ki pa ka boule nan dife, n'a pase yo nan dife pou yo ka nan kondisyon sèvi pou moun k'ap sèvi Bondye. Men tou sa ki ka boule nan dife, se nan dlo yo mete apa pou sa a n'a pase yo pou yo ka nan kondisyon sèvi pou moun k'ap sèvi Bondye. ");
INSERT INTO hat_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Sou setyèm jou a, n'a lave rad ki sou nou yo. Konsa n'a nan kondisyon pou nou fè sèvis Bondye. Se lè sa a n'a ka antre nan kan an. ");
INSERT INTO hat_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","-Ou menm, Moyiz ak Eleaza, prèt la, ansanm ak tout lòt chèf pèp Izrayèl yo, n'a konte tou sa lame a te ranmase nan lagè a, san bliye bèt yo ak prizonye yo. ");
INSERT INTO hat_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Apre sa, n'a separe tout bagay mwatye pou mwatye, mwatye pou moun ki te al goumen yo, mwatye pou rès moun pèp Izrayèl yo. ");
INSERT INTO hat_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Nan mwatye ki pou moun ki te al goumen yo, n'a wete yon pòsyon ki va tankou yon taks y'a peye pou Seyè a: sou chak senksan (0500) moun, sou chak senksan bèt menm kalite, bèf, bourik, mouton, kabrit, w'a wete yonn pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Sa w'a wete nan mwatye ki pou moun ki te al goumen yo, w'a bay Eleaza, prèt la, tankou yon bagay yo pran pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Sou lòt mwatye ki rete pou rès moun pèp Izrayèl la, w'a pran yonn sou chak senkant moun, sou chak senkant bèt menm kalite, bèf, bourik, mouton, kabrit. Epi w'a bay moun Levi yo ki reskonsab Tant Randevou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moyiz ak Eleaza, prèt la, te fè tout bagay jan Seyè a te bay Moyiz lòd fè a. ");
INSERT INTO hat_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","San konte sa sòlda yo te pran pou yo menm, men sa yo te pran nan men lènmi yo epi yo te pote bay Moyiz: sisanswasannkenzmil (0675.000) mouton ak kabrit, ");
INSERT INTO hat_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","swasanndouzmil (072.000) bèf, ");
INSERT INTO hat_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","swasanteyenmil (061.000) bourik, ");
INSERT INTO hat_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","tranndemil (032.000) jenn fi ki poko janm kouche ak gason. ");
INSERT INTO hat_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Yo pran mwatye ladan yo bay sòlda ki te al goumen yo. Epi yo wete sa ki pou Seyè a ladan l'. Sa te fè twasantrannsètmil senksan (0337.500) mouton ak kabrit, ");
INSERT INTO hat_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ak sisanswasannkenz (0675) ladan yo pou Seyè a, ");
INSERT INTO hat_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","trannsimil (036.000) bèf ak swasanndouz ladan yo pou Seyè a, ");
INSERT INTO hat_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","trantmil senksan (030.500) bourik ak swasanteyen ladan yo pou Seyè a, ");
INSERT INTO hat_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","sèzmil (016.000) jenn fi ak trannde ladan yo pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Se konsa, Moyiz renmèt bay Eleaza, prèt la, tou sa yo te wete pou Seyè a, jan Seyè a te bay Moyiz lòd la. ");
INSERT INTO hat_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Lòt mwatye a te pou rès pèp Izrayèl la. Lè Moyiz fin wete sa ki te pou sòlda yo, ");
INSERT INTO hat_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","men sa ki te rete: twasantrannsètmil senksan (0337.500) mouton ak kabrit, ");
INSERT INTO hat_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trannsimil (036.000) bèf, ");
INSERT INTO hat_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trantmil senksan (030.500) bourik ak ");
INSERT INTO hat_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","sèzmil (016.000) jenn fi. ");
INSERT INTO hat_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Sou mwatye ki te pou rès moun pèp Izrayèl la, Moyiz pran yon moun sou chak senkant moun ak yon bèt sou chak senkant bèt menm kalite, li bay moun Levi yo ki te reskonsab tant Seyè a, jan Seyè a te bay Moyiz lòd la. ");
INSERT INTO hat_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Lè sa a, tout moun ki te chèf lame a, chèf divizyon mil yo ak chèf konpayi san yo, yo tout vin jwenn Moyiz. ");
INSERT INTO hat_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Epi yo di l': -Nou konte kantite sòlda ki te sou kont nou yo, nou jwenn yo tout la. ");
INSERT INTO hat_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Se poutèt sa, n'ap pote tout bijou lò nou te jwenn epi nou te pran: braslè, chennèt, bag, zanno, chenn ak meday, n'ap ofri yo bay Seyè a pou li ka fè nou gras. ");
INSERT INTO hat_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moyiz ak Eleaza, prèt la, resevwa tout bijou lò yo te pote yo. ");
INSERT INTO hat_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Sa te fè katsan (0400) liv konsa chèf divizyon mil yo ak chèf konpayi san yo te pote bay Moyiz ak Eleaza ki te resevwa yo pou Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Men, sòlda yo menm te kenbe sa yo te pran pou tèt pa yo. ");
INSERT INTO hat_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Se konsa Moyiz ak Eleaza, prèt la, pran lò chèf divizyon mil ak chèf konpayi san yo te pote ba yo a, yo pote l' nan Tant Randevou a, pou Seyè a te ka toujou chonje pwoteje pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Moun branch fanmi Woubenn ak moun branch fanmi Gad yo te gen anpil anpil bèt. Lè yo wè jan peyi Jazè a ak peyi Galarad la te bon pou fè gadinaj, ");
INSERT INTO hat_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","yo vin jwenn Moyiz, Eleaza, prèt la, ak chèf fanmi pèp Izrayèl yo, yo di yo konsa: ");
INSERT INTO hat_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","-Tout rejyon kote nou jwenn lavil sa yo: Atawo, Dibon, Jazè, Nimra, Esbon, Eleyale, Sèbam, Nebo ak Biyon, ");
INSERT INTO hat_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","tout peyi Seyè a te ede moun pèp Izrayèl yo pran pou yo bò isit la, se tè ki bon pou fè gadinaj, lèfini nou menm nou gen anpil bèt. ");
INSERT INTO hat_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Tanpri, si ou vle fè nou favè sa a, ban nou peyi sa a pou pòsyon pa nou. Pa fòse nou janbe lòt bò larivyè Jouden an. ");
INSERT INTO hat_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moyiz reponn yo: -Nou ta renmen rete isit la pandan lòt frè nou yo pral nan goumen? ");
INSERT INTO hat_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Poukisa nou vle dekouraje moun pèp Izrayèl yo pou yo pa ale nan peyi Seyè a ba yo a? ");
INSERT INTO hat_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Se menm bagay la zansèt nou yo te fè wi lè mwen te voye yo ale vizite peyi a antan nou te Kadès Banea. ");
INSERT INTO hat_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Yo moute jouk nan ravin Echkòl la, yo vizite tout peyi a. Apre sa, yo dekouraje moun pèp Izrayèl yo pou yo pa antre nan peyi Seyè a te ba yo a. ");
INSERT INTO hat_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Jou sa a, Seyè a te move anpil sou yo. Li sèmante, li di konsa: ");
INSERT INTO hat_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Okenn nan gason ki te gen ventan osinon ki te pi gran lè yo te soti kite peyi Lejip p'ap mete pwent pye yo nan peyi mwen te pwomèt sou sèman m'ap bay Abraram, Izarak ak Jakòb la, paske yo pa t' kenbe pawòl yo ak mwen, ");
INSERT INTO hat_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","an wetan Kalèb, pitit gason Jefoune, moun fanmi Kenaz yo, ak Jozye, pitit gason Noun lan. Se yo menm sèlman ki te toujou swiv Seyè a san mank. ");
INSERT INTO hat_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Se konsa, Seyè a fè yon sèl move sou pèp Izrayèl la, li fè yo moute desann nan dezè a pandan karantan, jouk dènye moun ki te fè sa ki mal devan Seyè a mouri. ");
INSERT INTO hat_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Epi koulye a, nou vle fè tankou papa nou yo? Ou byen wè se pitit yo nou ye vre! Nou pral fè Seyè a pi move ankò sou pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Si nou vire do nou ba li, l'a fè pèp la rete pi lontan ankò nan dezè a. Se nou menm ki va lakòz pèp la fini nèt. ");
INSERT INTO hat_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Yo pwoche bò Moyiz, yo di l' konsa: -Pou konmanse, nou ta renmen moute kloti ak wòch pou fèmen pak bèt nou yo, epi nou ta renmen bati lavil ak ranpa pou pitit nou yo. ");
INSERT INTO hat_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Men, nou menm gason yo, nou tou pare pou n' ale goumen ansanm ak rès moun pèp Izrayèl yo, pou nou pran devan lè n'ap atake lènmi jouk yo rive nan peyi ki pou yo a. Pandan tan sa a, moun pa nou yo menm va rete isit la nan lavil ak ranpa yo kote moun peyi a p'ap ka fè yo anyen. ");
INSERT INTO hat_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nou p'ap tounen lakay nou toutotan tout lòt moun nan pèp Izrayèl la poko jwenn pòsyon tè ki pou yo a. ");
INSERT INTO hat_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Nou p'ap pran anyen nan tè ki pou yo lòt bò larivyè Jouden an, paske yo ban nou tè ki bò isit larivyè Jouden an, sou kote solèy leve a, pou pòsyon pa nou. ");
INSERT INTO hat_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moyiz di yo konsa: -Si nou fè tou sa nou sot di la a, si vreman vre nou pare pou n' al goumen devan Seyè a, ");
INSERT INTO hat_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","si tout gason ki ka goumen pami nou yo janbe lòt bò larivyè Jouden an devan Seyè a, jouk Seyè a va fin kraze tout lènmi l' yo devan li, ");
INSERT INTO hat_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","enben, apre tout peyi a va tonbe anba men Seyè a, n'a tounen vin lakay nou, paske n'a fin fè tou sa nou te dwe fè pou Seyè a ak pou pèp Izrayèl la. Lè sa a, tout peyi ki bò isit la va rele nou pa nou devan Seyè a. ");
INSERT INTO hat_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Men, si nou pa fè tou sa, konnen se kont Seyè a menm n'a peche. N'a peye konsekans peche nou an. ");
INSERT INTO hat_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Nou mèt bati lavil ak ranpa pou moun pa nou yo. Nou mèt moute lantouraj pou mete bèt nou yo nan pak. Men, se pou nou fè sa nou pwomèt n'ap fè a. ");
INSERT INTO hat_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Moun fanmi Woubenn yo ak moun fanmi Gad yo di konsa: -Mèt, n'ap fè tou sa ou mande nou fè. ");
INSERT INTO hat_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Pitit nou yo va rete nan lavil ki nan peyi Galarad yo ansanm ak madanm nou yo ak tout bèf, tout mouton ak tout kabrit nou yo, ");
INSERT INTO hat_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Men, nou menm gason ki pare pou n' al goumen yo, n'ap pase devan Seyè a pou n' al fè lagè jan ou di l' la. ");
INSERT INTO hat_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Lè sa a, Moyiz bay Eleaza, prèt la, Jozye, pitit gason Noun lan, ak tout chèf fanmi pèp Izrayèl la lòd sa a sou moun sa yo. ");
INSERT INTO hat_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Li di yo: -Si gason nan branch fanmi Woubenn ak nan branch fanmi Gad yo janbe lòt bò larivyè Jouden an avèk nou tou pare pou y' al goumen devan Seyè a, lè tout peyi a va anba men nou, n'a ba yo tè peyi Galarad la pou yo. ");
INSERT INTO hat_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Men, si yo pa janbe lòt bò larivyè Jouden an pou y' al goumen avèk nou, y'a resevwa pòsyon tè pa yo nan peyi Kanaran an ansanm ak nou. ");
INSERT INTO hat_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Mesye branch fanmi Woubenn ak branch fanmi Gad yo reponn Moyiz, yo di l' konsa: -N'a fè tou sa Seyè a mande nou fè. Se sèvitè li nou ye. ");
INSERT INTO hat_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","N'a janbe lòt bò larivyè a tou pare pou n' al goumen devan Seyè a, n'a antre nan peyi Kanaran an. Men toutjan, nou mande pou yo ban nou pòsyon tè ki bò isit larivyè Jouden an pou nou. ");
INSERT INTO hat_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Se konsa Moyiz pran tout peyi Amori ki te pou wa Siyon, ak peyi Bazan ki te pou wa Og, avèk tout lavil ki nan limit fwontyè peyi yo, li bay moun fanmi Gad yo, moun fanmi Woubenn yo ak mwatye moun ki nan fanmi Manase, pitit gason Jozèf la. ");
INSERT INTO hat_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Moun fanmi Gad yo rebati tout lavil sa yo: Dibon, Atawòt, Awoyè, ");
INSERT INTO hat_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atawo, Sofam, Jaze ak Jobeya, ");
INSERT INTO hat_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bèt-Nimra, Bèt aran. Yo rebati yo avèk ranpa pou pwoteje yo, yo fè pak tou pou mouton ak kabrit. ");
INSERT INTO hat_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Moun fanmi Woubenn yo menm rebati lavil sa yo: Esbon, Elealè, Kiryatayim, ");
INSERT INTO hat_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meyon ak Sibma. Yo te chanje non lavil Nebo ak Baal Meyon. Yo bay tout lavil yo rebati yo lòt non. ");
INSERT INTO hat_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Moun fanmi Maki, pitit gason Manase a, pati pou peyi Galarad kote moun Amori yo te rete a. Yo anvayi tout peyi a, yo mete moun Amori yo deyò. ");
INSERT INTO hat_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Se konsa tou, Moyiz bay moun fanmi Maki, pitit gason Manase a, peyi Galarad la pou yo rete. ");
INSERT INTO hat_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Moun fanmi Jayi, pitit gason Manase a, al atake yon seri ti bouk. Yo anvayi yo epi yo rele yo Bouk Jayi. ");
INSERT INTO hat_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Noba menm al atake lavil Kenat ak lòt ti bouk ki sou lòd li yo. l' anvayi l', epi li ba li non l'. Li rele l' Noba. ");
INSERT INTO hat_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Men non tout kote moun Izrayèl yo te pase depi apre yo tout te soti kite peyi Lejip tankou yon lame, avèk Moyiz ak Arawon alatèt yo. ");
INSERT INTO hat_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Dapre lòd Seyè a te bay Moyiz, chak kote yo te rive, li te make non kote a anvan yo reprann vwayaj yo. ");
INSERT INTO hat_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Moun pèp Izrayèl yo te kite lavil Ranmsès jou ki te kenzyèm jou nan premye mwa a, yon jou apre premye Fèt Delivrans lan. Yo soti kite peyi a devan je tout moun peyi Lejip yo san pesonn pa di yo anyen. ");
INSERT INTO hat_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Lè sa a, moun peyi Lejip yo t'ap antere premye pitit gason yo. Se Seyè a menm ki te touye yo. Se konsa li te fè wè li gen plis pouvwa pase bondye moun peyi Lejip yo ");
INSERT INTO hat_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Moun pep Izrayèl yo kite lavil Ranmsès, yo rive yon kote ki rele Soukòt. Se la yo moute kan yo. ");
INSERT INTO hat_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Apre sa, yo kite Soukòt, y' al moute kan yo Etam ki sou limit dezè a. ");
INSERT INTO hat_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Yo kite Elam, yo tounen sou Pi ayiwòt, ki anfas Baal-Sefon, bò solèy leve, epi yo moute kan yo devan Migdòl. ");
INSERT INTO hat_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Yo kite Pi ayiwòt, yo travèse Lanmè Wouj la, yo rive nan dezè a. Yo pase twa jou ap mache nan dezè Etam lan, yo rive Mara kote yo moute kan yo. ");
INSERT INTO hat_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Yo kite Mara, yo rive Elim kote ki te gen douz sous dlo ak swasanndis pye palmis. Yo moute kan yo la. ");
INSERT INTO hat_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Yo kite Elim, y' al moute kan yo toupre Lanmè Wouj la. ");
INSERT INTO hat_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Yo kite Lanmè Wouj, y' al moute kan yo nan dezè Zin lan. ");
INSERT INTO hat_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Yo kite dezè Zin lan, y' al moute kan yo Dofka. ");
INSERT INTO hat_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Yo kite Dofka, y' al moute kan yo Alouch. ");
INSERT INTO hat_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Yo kite Alouch, y' al moute kan yo Refidim kote pèp la pa t' jwenn dlo pou yo bwè a. ");
INSERT INTO hat_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Yo kite Refidim, y' al moute kan yo nan dezè Sinayi a. ");
INSERT INTO hat_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Yo kite dezè Sinayi a, y' al moute kan yo Simityè Grangou. ");
INSERT INTO hat_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Yo kite Simityè Grangou, y' al moute kan yo Azewòt. ");
INSERT INTO hat_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Yo kite Azewòt, y' al moute kan yo Ritma. ");
INSERT INTO hat_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Yo kite Ritma, y' al moute kan yo Rimonn Perèz. ");
INSERT INTO hat_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Yo kite Rimonn Perèz, y' al moute kan yo Libna. ");
INSERT INTO hat_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Yo kite Libna, y' al moute kan yo Risa. ");
INSERT INTO hat_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Yo kite Risa, y' al moute kan yo Keyelata. ");
INSERT INTO hat_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Yo kite Keyelata, y' al moute kan yo sou mòn Chefè a. ");
INSERT INTO hat_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Yo kite mòn Chefè a, y' al moute kan yo Arada. ");
INSERT INTO hat_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Yo kite Arada, y' al moute kan yo Makelòt. ");
INSERT INTO hat_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Yo kite Makelòt, y' al moute kan yo Tayat. ");
INSERT INTO hat_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Yo kite Tayat, y' al moute kan yo Tara. ");
INSERT INTO hat_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Yo kite Tara, y' al moute kan yo Mitka. ");
INSERT INTO hat_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Yo kite Mitka, y' al moute kan yo Asmona. ");
INSERT INTO hat_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Yo kite Asmona, y' al moute kan yo Mosewòt. ");
INSERT INTO hat_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Yo kite Mosewòt, y' al moute kan yo Benè-Jakan. ");
INSERT INTO hat_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Yo kite Benè-Jakan, y' al moute kan yo Ogidgad. ");
INSERT INTO hat_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Yo kite Ogidgad, y' al moute kan yo Jotbata. ");
INSERT INTO hat_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Yo kite Jotbata, y' al moute kan yo Abwona. ");
INSERT INTO hat_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Yo kite Abwona, y' al moute kan yo Ezyongebè. ");
INSERT INTO hat_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Yo kite Ezyongebè, y' al moute kan yo nan dezè Zin lan, ki vle di Kadès. ");
INSERT INTO hat_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Yo kite Kadès, y' al moute kan yo sou mòn Or, toupre fwontyè peyi Edon an. ");
INSERT INTO hat_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Dapre lòd Seyè a te bay la, Arawon, prèt la, moute sou tèt mòn lan. Se la li mouri. Lè sa a, moun pèp Izrayèl yo te gen trantnevan kat mwa yon jou depi yo te soti kite peyi Lejip. ");
INSERT INTO hat_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Lè Arawon mouri sou mòn Or la, li te gen sanvenntwazan sou tèt li. ");
INSERT INTO hat_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Wa Arad, yon moun Kanaran ki te rete nan pati sid peyi Kanaran yo rele Negèv la, vin konnen moun Izrayèl yo t'ap rive. ");
INSERT INTO hat_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Se konsa, moun Izrayèl yo kite Mòn Or la, y' al moute kan yo Zalmona. ");
INSERT INTO hat_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Yo kite Zalmona, y' al moute kan yo Pounon. ");
INSERT INTO hat_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Yo kite Pounon, y' al moute kan yo Obòt. ");
INSERT INTO hat_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Yo kite Obòt, y' al moute kan yo Ije abrarim nan peyi Moab la. ");
INSERT INTO hat_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Yo kite Ije abrarim nan peyi Moab la, y' al moute kan yo Dibon Gad. ");
INSERT INTO hat_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Yo kite Dibon Gad, y' al moute kan yo Almon-Diblatayim. ");
INSERT INTO hat_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Yo kite Almon-Diblatayim, y' al moute kan yo sou mòn Abarim yo, anfas Mòn Nebò, bò solèy leve. ");
INSERT INTO hat_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Yo kite mòn Abarim yo, y' al moute kan yo nan plenn Moab yo, lòt bò larivyè Jouden, anfas lavil Jeriko. ");
INSERT INTO hat_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Yo te moute kan yo nan tout plenn Moab yo, toupre larivyè Jouden an, depi Bèt ayechimòt jouk Abèl-Chitim. ");
INSERT INTO hat_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Antan yo la nan plenn Moab yo, toupre larivyè Jouden, anfas lavil Jeriko, Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","-Men sa pou ou di moun pèp Izrayèl yo pou mwen. Lè n'a janbe lòt bò larivyè Jouden pou nou antre nan peyi Kanaran an, ");
INSERT INTO hat_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","se pou nou mete tout moun ki rete nan peyi a deyò. N'a kraze tout estati zidòl yo fè nan moul, osinon ki fèt ak wòch, n'a demoli mete atè dènye kay kote moun yo fè sèvis pou bondye yo. ");
INSERT INTO hat_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","N'a pran peyi a pou nou, n'a rete ladan l' paske se mwen menm ki ban nou li pou bitasyon nou. ");
INSERT INTO hat_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","N'a tire osò pou nou ka separe l' bay chak branch fanmi pa yo. N'a bay branch fanmi ki anpil la yon gwo pòsyon. N'a bay branch fanmi ki pa anpil la yon ti pòsyon. Chak branch fanmi va resevwa pòsyon ki va vin pou l' a. Se konsa n'a separe tè a bay chak branch fanmi zansèt nou yo pa yo. ");
INSERT INTO hat_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Men, si nou pa mete moun ki rete nan peyi a deyò, sa ki va rete yo pral ban nou gwo pwoblèm. Y'ap tankou yon pay ki tonbe nan je nou, osinon tankou pikan k'ap pike nou nan tout kò nou. Yo pral tounen yon tizon pou nou lè n'a fin tabli nan peyi a. ");
INSERT INTO hat_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Lè sa a, sa m' te fè lide fè yo a, se nou m'ap fè l'. ");
INSERT INTO hat_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","-Men lòd w'a bay moun Izrayèl yo pou mwen. Lè n'a antre nan peyi Kanaran mwen pral ban nou an, men fwontyè ki pral limite peyi a. ");
INSERT INTO hat_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Sou bò sid la, n'a gen dezè Zin ki toupre Edon an pou limit. Fwontyè a va konmanse bò solèy leve nan pwent sid Lanmè Sale a. ");
INSERT INTO hat_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","L'a chankre desann nan direksyon sid bò pas Eskòpyon yo, l'a travèse dezè Zin lan, jouk li rive anba nèt bò Kadès-Banea. L'a pran direksyon nò, l'a moute bò Aza ada, l'a rive Achmon, ");
INSERT INTO hat_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","l'a chankre bò ravin ki sèvi fwontyè ak peyi Lejip la, epi l'a bout nan Lanmè Mediterane. ");
INSERT INTO hat_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Sou bò solèy kouche, teritwa a nou an va rive jouk sou rivaj gwo lanmè a. Se Lanmè Mediterane a ki va sèvi nou fwontyè. ");
INSERT INTO hat_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Sou bò nò a, fwontyè a va swiv yon liy dwat ki soti depi gwo lanmè a rive sou mòn Or la. ");
INSERT INTO hat_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Antan nou la, n'a trase yon liy dwat ankò jouk nou rive nan Pas Amat la, ale pi lwen toujou jouk nou rive Zedad. ");
INSERT INTO hat_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","N'a pouse pi lwen toujou nan direksyon Zifwon jouk nou rive Aza-Enan. Men fwontyè nou sou bò nò a. ");
INSERT INTO hat_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Fwontyè sou bò solèy leve a va soti Aza-Enan pou rive Chefam. ");
INSERT INTO hat_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","L'a desann soti Chefam nan direksyon Ribla, sou kote Ayen bò solèy leve. L'a desann pi ba toujou jouk l'a rive sou rivaj lanmè Galile a, sou bò solèy leve. ");
INSERT INTO hat_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Fwontyè a va swiv larivyè Jouden an pou l' al bout sou lanmè Sale a. Men fwontyè k'ap limite peyi nou an sou kat bò. ");
INSERT INTO hat_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Moyiz bay moun Izrayèl yo lòd sa yo: -Men peyi nou pral separe yonn ak lòt la. Nou pral tire osò pou fè sa. Men peyi Seyè a bay pou nèf branch fanmi ak mwatye yon branch fanmi nan pèp Izrayèl la. ");
INSERT INTO hat_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Branch fanmi Woubenn lan ak branch fanmi Gad la ansanm ak mwatye nan branch fanmi Manase a deja resevwa tè pa yo, chak fanmi apa. ");
INSERT INTO hat_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Yo resevwa pòsyon tè pa yo ki anfas lavil Jeriko, lòt bò larivyè Jouden, sou bò solèy leve. ");
INSERT INTO hat_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","-Men non moun ki pral fè pataj tè a pou nou: se va Eleaza, prèt la, Jozye, pitit gason Noun lan, ");
INSERT INTO hat_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","avèk douz chèf n'a chwazi pou fè pataj la, yonn nan chak branch fanmi. ");
INSERT INTO hat_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Men non chèf yo. Pou branch fanmi Jida a, se va Kalèb, pitit gason Jefoune a. ");
INSERT INTO hat_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Pou branch fanmi Simeyon an, se va Chemwèl, pitit gason Amiyoud la. ");
INSERT INTO hat_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Pou branch fanmi Benjamen an, se va Elidad, pitit gason Kislòn lan. ");
INSERT INTO hat_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Pou branch fanmi Dann lan, se va chèf Bouki, pitit gason Jogli a. ");
INSERT INTO hat_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Pou branch fanmi Jozèf la, va gen chèf Aniyèl, pitit gason Efòd la, pou fanmi Manase a, ");
INSERT INTO hat_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ak chèf Kemwèl, pitit gason Chiftan an, pou fanmi Efrayim lan. ");
INSERT INTO hat_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Pou branch fanmi Zabilon an, se va chèf Elichafan, pitit gason Panak la. ");
INSERT INTO hat_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Pou branch fanmi Isaka a, se va chèf Paltiyèl, pitit gason Azan an. ");
INSERT INTO hat_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Pou branch fanmi Asè a, se va chèf Akiyoul, pitit gason Chelomi a. ");
INSERT INTO hat_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pou branch fanmi Neftali a, se va chèf Pedayèl, pitit gason Amiyoud la. ");
INSERT INTO hat_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Men moun Seyè a te mete reskonsab pou fè pataj tè a pou bay chak moun nan pèp Izrayèl la pòsyon pa yo nan peyi Kanaran. ");
INSERT INTO hat_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Antan yo nan plenn Moab yo, lòt bò larivyè Jouden, sou bò solèy leve anfas lavil Jeriko, Seyè a pale ak Moyiz, li di l' konsa: ");
INSERT INTO hat_