﻿USE sofia;
DROP TABLE IF EXISTS sofia.gyz_vpl;
CREATE TABLE gyz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gyz_vpl WRITE;
INSERT INTO gyz_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ga̱n ka̱ɗe taka̱rda gwe na̱ma mbokti ang ten mbala̱n jwe Yesu Almasihu yen ga̱ Dauda, yen ga̱ Iba̱rahim yil tet tumalsi wu. ");
INSERT INTO gyz_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Iba̱rahim ka̱ɗe aba ga̱ Ishaku, Ishaku ka̱ zi Yakubu, Yek Yakubu zi Yehuda suk yilkeni jwasi, ");
INSERT INTO gyz_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda ka̱ɗe aba ga̱ Peres suk Zera, ana gwasa̱n ka̱ɗe Tamar. Peres ka̱ zi Heza̱ron, Yek Heza̱ron zi Aram, ");
INSERT INTO gyz_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram ka̱ zi Aminadab, Aminadab ka̱ zi Nashon, Yek Nashon zi Salmon, ");
INSERT INTO gyz_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ka̱ zi Bo'az ma̱lgwe ana gwas ka̱ɗe Rahab wu. Bo'az ka̱ zi Obida ma̱lgwe ana gwas ka̱ɗe Rut wu. Yek Obida zi Yese, ");
INSERT INTO gyz_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese ka̱ zi Dauda guu, Dauda ka̱ zi Sulemanu ma̱lgwe ana gwas wo, tek go kili ga̱ Wuriya ka̱ɗe ti wu. ");
INSERT INTO gyz_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Yek Sulemanu guu zi Rehobowam. Yek Rehobowam zi Abija, Abija ka̱ zi Asa, ");
INSERT INTO gyz_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ka̱ zi Yehoshapat. Yek Yehoshapat zi Joram, Joram ka̱ zi Yuziya. ");
INSERT INTO gyz_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yek Yuziya zi Jotam, Jotam ka̱ zi Ahaz, Ahaz ka̱ zi Hezekiya. ");
INSERT INTO gyz_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Yek Hezekiya zi Manasa, Manasa ka̱ zi Amon, Amon ka̱ zi Josiya. ");
INSERT INTO gyz_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yek Josiya zi Yekoniya suk yilkeni jwasi ka̱ sa'i gwe sa̱ yem ma̱n Yehuda ɗe zhel a Babila wu. ");
INSERT INTO gyz_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kaal ɗa̱ da̱mti zhel gwasa̱n a Babila, yek Yekoniya zi Shayeltiyel, Shayeltiyel ka̱ zi Zerubabel. ");
INSERT INTO gyz_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Yek Zerubabel zi Abihud, Abihud ka̱ zi Eliyakim, Eliyakim zi Azor. ");
INSERT INTO gyz_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Yek Azor zi Zadok, Zadok ka̱ zi Akim. Akim zi Eliyud. ");
INSERT INTO gyz_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Yek Eliyud zi Eliyaza, Eliyaza ka̱ zi Matan, Matan ka̱ zi Yakubu. ");
INSERT INTO gyz_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yek Yakubu zi Yusupu kos ga̱ Maryam ma̱lgwe zi Yesu gwe asa̱ mbet ɗe Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tet ten Iba̱rahim hal yek la Dauda mbala̱n ɗe kutl cet wupsi ka̱n. A Tet ten Daude yek la da̱mti zhel gwasa̱n a Babila go mbala̱n ɗe kutl cet wupsi ka̱ pak. Tet ten da̱mti zhel gwasa̱n a Babila yek la Almasihu mago mbala̱n ɗe kutl cet wupsi ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kangwe za̱t ga̱ Yesu Almasihu ni wu wuggu. A Yusupu yi ɗe yen kos ga̱ Maryam ana ga̱ Yesu, tun ba̱sa̱ ɓo pa̱l hapti so yek ta̱ mbi yen tuki tumal Shishi ga̱ Nya a ba̱ta̱ ɓo yis maani so. ");
INSERT INTO gyz_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ama na̱k ɗe hwa mbala̱n ka̱ɗe Yusupu yen kos gwas wu, yek ba̱ta̱ lami ɗe ta̱s lak Maryam ka̱ nsha ka̱ dlo mbala̱n so. Yek ta̱ gwe ta̱s zakti mukli. ");
INSERT INTO gyz_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ama tun a ta̱ yima daamti gwas ten pa̱lti nu, yek Yen shinti ga̱ Nya tul malti ka̱ tlunka̱ti. Yek ta̱ wulti ɗe, Yusupu yen ga̱ Dauda, kan Maryam ɗe kili gwa, ba̱ ɓanti cik so, yen tuk gwe ta̱ mbi go sut mal Shishi ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ta zi yen, aka̱ zit shin ɗe Yesu, na̱k ɗe tik ka kis mbala̱n jwas ɗa̱ka̱ pa̱lti byas wul ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ili pi na̱k gwisi ta̱ ga̱ɓa gwe Nya dla̱m tumal ma̱n dla̱mti ga̱ɓa gwas wu njika̱n. ");
INSERT INTO gyz_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ga̱ɓa gwe wule, <<Yek ge yen kili gwe ɓo yis maani sowu a mbi yen tuki, ata̱ zi yen maani, asa zit shin ɗe Imanuwel.>> Gwe yek ɗe, <<Nya ni sukmi wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ɗe Yusupu pa̱da̱l tet yemba̱l wu, yek ta̱ kop ilgwe yen shinti ga̱ Nyami hwit ɗe ta̱s pa̱li wu, yek ta̱ hap Maryam ɗe kili gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ama yek ba̱ta̱ yisti so se na̱k ta̱ zi yen cina gwasi, yek ta̱ zit shin ɗe Yesu. ");
INSERT INTO gyz_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Sa̱ zi Yesu ka̱ ba̱n Baitalami ka̱ atl ga̱ Yehudiya, ka̱ sa'i gwe Hiridus ni ɗe bal guu wu, yek ma̱n yisti kyatla̱l jon tet gaba̱s tul Wurshelima, Yek sa̱ kum ga̱zi ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","<<Guu ga̱ ma̱n Yehuda gwe sa̱ ya za̱t wuk gwi? Ma̱ yen kyatla̱l gwas a tu gaba̱s, yek ka̱n ma̱ tuli ta̱n ngusit atli.>> ");
INSERT INTO gyz_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hiridus guu kumi nu wugo, yek ili hwotti suk mas ma̱n Wurshelima i'e. ");
INSERT INTO gyz_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yek Hiridus guu mo mas kiɗi ma̱n Pa̱ris suk ma̱n yisti mba̱t ga̱ɓa ga̱ Musa yek ta̱ ngemsi ɗe, <<Ɓohwe a'ako ka̱n ma̱n dla̱mti ga̱ɓa Nya wule sa zi Almasihu ko?>> ");
INSERT INTO gyz_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yek sa̱ ballit ɗe, <<Ka̱ ba̱n Baitalami ka̱ atl ga̱ Yehudiya,>> na̱k ɗe ma̱n dla̱mti ga̱ɓa ga̱ Nya lishi ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<< <Ki ba̱n Baitalami ga̱ atl ga̱ Yehudiya, ko njaa, kik ɗe nak'eni ka̱ ba̱n jwe ni ka̱ atl ga̱ Yehudiya wu so, ten ɗe ka̱ ki ka̱n sa zi bal guu gon, ma̱lgwe a da̱m ɗe bacina ga̱ mbala̱n ji ma̱n Yisiraila ata̱ pi kyo gwasa̱n wu.> >> ");
INSERT INTO gyz_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yek Hiridus guu mbe mbala̱mi mukli, yek ta̱ kum ga̱z ga̱ sa'i gwe kyadla̱li yil wu. ");
INSERT INTO gyz_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Yek ta̱ wulsi ɗe, <<Lak ngo yenni i'e, kume ka̱ mbit wu, a ka̱a̱ lak hwini nini ammago ba lak ngusit atl pak.>> ");
INSERT INTO gyz_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ɗe sa̱ kum ga̱ɓa ga̱ guumi wu, yek sa̱ zigaa. Yek kyatla̱l gwe sa̱ yeni wu ngusi kopti na̱ si yek lak dla̱l sut gaa ga̱ lubii gwe yeni ni wu. ");
INSERT INTO gyz_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sa̱ yen kyadla̱li wugo yek sa̱ pa̱l hwol tuk i'e. ");
INSERT INTO gyz_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɗe sa̱ te ka̱ lubiimi wugo, yek sa̱ yen yeni suk Maryam ana gwasi yek sa̱ ngus a cina ɗatka̱. Yek sa̱ ɓul ngura jwasa̱n yek sa̱ ba̱lti zinariya, suk luban, suk mur. ");
INSERT INTO gyz_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ama yek yen shinti ga̱ Nya da̱lisi ka̱ng ka̱ tlunka̱t ɗe ba̱s koɓi tumal Hiridus so, yek sa̱ pal ga̱za̱n tu ten zobsi tantu. ");
INSERT INTO gyz_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma̱n yisti kyadla̱li zigaa wugo yek yen shinti ga̱ Nya ga̱ɓa suk Yusupu ka̱ tlunka̱ti yek ta̱ wulti ɗe, <<Tlinya ta̱k kan yeni suk ana gwasi ta̱k aɓa̱n te Masar ka, ta̱k da̱ma̱n teka se a hwikii ilgwe kaa pa̱li ka̱ kaali wu ten ɗe Hiridus a ngwe ta̱s tlo yeni.>> ");
INSERT INTO gyz_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yek Yusupu tlinya yek ta̱ kan yeni suk ane ka̱ gasi yek sa̱ ap te Masar ka, ");
INSERT INTO gyz_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","yek sa̱ da̱n a Masar hal se sa'i gwe Hiridus guu ma̱sh wu. Na̱k gwisi pi ta̱ njika̱n ga̱ɓa gwe Nya dla̱m tumal ma̱n dla̱mti ga̱ɓa gwas wu ɗe, <<Tet Masar ka̱n a mbe yen gini.>> ");
INSERT INTO gyz_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ɗe Hiridus guu lak yisi ɗe ma̱n yisti kyadla̱li palla̱t ɗe ka̱dla̱n wugo, yek mbadl gwas lil i'e, yek ta̱ laki ta̱s tlo mas mil maani ji ba̱n Baitalami suk jwe ni njaa ka̱li wu ka. Yek sa̱ tlo mas mil mani ma̱n gin ɗe lop suk ji atl ɗaasi ka ndakce na̱ sa'i gwe ma̱n yisti kyadla̱li hwit wu. ");
INSERT INTO gyz_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gwisi ka̱ɗe sa'i gwe sa̱ njika̱n ga̱ɓa gwe Irimiya ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Sa̱ kum yal gon ka̱ ba̱n Rama, Yal kulu na̱ du tuk i'e. Rahila ka̱ na̱ma kulu ten bi mil jwasi ta̱ nge sheltidli, na̱k ɗe sa̱ tlwet mil ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ama kaal ɗa̱ ma̱shka̱n ga̱ Hiridus guu, yek yen shinti ga̱ Nya tul mal Yusupu ka̱ tlunka̱ti a Masar. ");
INSERT INTO gyz_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Yek ta̱ wulti ɗe <<Tlinya ta̱k kan yeni suk ana gwasi ta̱k pala̱n teka̱ atl ga̱ Yisiraila ka, na̱k ɗe mbala̱n jwe sa̱ na̱ma la̱mti tlot ga̱ yeni go sa̱ ma̱sh wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yek Yusupu kan yeni suk ane yek sa̱ pal teka̱ atl ga̱ Yisiraila ka. ");
INSERT INTO gyz_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ama yek ta̱ kumi ɗe Alkilawus ka̱ da̱n ɗe guu ka̱ lal ga̱ aba gwas Hiridus a tik ɓal ɗe guu ga̱ atl Yehudiya wu, yek ɓanti la̱t ka̱li citi. Ama ɗe Nya da̱lit ka̱ng ka̱ tlunka̱t ɗe ba̱s li ka̱li tu ka̱li sowu, yek ta̱ li tu Galili. ");
INSERT INTO gyz_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yek ta̱ lak da̱n ka̱ ba̱n gwe asa̱ mbe ɗe Nazarat wu. Na̱ nu ka̱n ilgwe ma̱n dla̱mti ga̱ɓa ji Nya dla̱m wu da̱n ɗe gem, gwe wule, <<Sa mbet ɗe ma̱n Nazarat wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ka̱ multi jwisi wo yek Yohana ma̱n baptisma yil deɓa̱l yek ta̱ ngusi lakti icin ka̱ me ka̱ atl ga̱ Yehudiya, ");
INSERT INTO gyz_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","yek ta̱ wul mbala̱n ɗe, <<Cin atl gaa na̱k ɗe kanti ga̱ Nya ɗe guu ga̱na̱n ɓal njaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ma̱lga̱n go tik ɗe ma̱lgwe Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya ga̱ɓa tenti wu, ɗe ta̱ wule, <<Yal ga̱ ma̱lgwe na̱ma takti bi ka̱ me wu, gwe na̱ma wulti ɗe, <La̱ka̱mi Bagaa tantu gwe ta koɓi wu, La̱ka̱miti tantu ta̱ni ɗe taki.> >> ");
INSERT INTO gyz_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A Yohana lak luka̱l ma̱dla̱n rakumi ata̱ hap dlo gwas na̱ kul, ka̱ɓa suk duu ka̱ɗe ilga̱ nguki gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yek mas ma̱n Wurshelima suk Yehudiya suk mas atl jwe ni njaa mal dla̱lka Yodan wu ngusi la̱t malti. ");
INSERT INTO gyz_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yek sa̱ ngusi dla̱mti byas wul jwasa̱n ata̱ nisi ma pa̱lti baptisma ka̱ dla̱lka Yodan. ");
INSERT INTO gyz_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yek Yohana yen ma̱n Paresi suk ma̱n Saduki wonti sa̱ na̱ma tulti malti ta̱s pa̱lisi baptisma wu, yek ta̱ wulsi ɗe. <<mil woka̱nzi na̱kkii, wok da̱likii ka̱ng ɗe ta̱k aɓi lilti mbadl ga̱ Nya ma̱n tulti wu wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pa̱la̱n wul jwe a mbok ang ten cit atl gaa gwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ba̱k ɓo ngetl ɗe kii wo Iba̱rahim ka̱ɗe aba gwaka̱n so, Nya a mani palti mil Iba̱rahim na̱ ye jin. ");
INSERT INTO gyz_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na̱k ninge mago ndal ni ten zhila tlindi, mas tlindi gwe wut hwa mil sogo sa wotl ka asa̱ lak ka̱ wutu. ");
INSERT INTO gyz_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ami wo na̱ ze ka̱n a nikii ma pa̱lti baptisma ta̱ mbok ang ɗe ka̱a̱ ci atl gaa mal Nya wi, ama kaal ɗa̱ ami wo ma̱lgon a tuli ma̱lgwe nal mana̱n wu, ma̱lgwe kapta̱lan gwas mago a mbuki ta tusit ka̱ sowu. Tik ka pa̱likii baptisma na̱ Shishi ga̱ Nya suk wutu. ");
INSERT INTO gyz_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Gal pelti wul gwas nit ang, ta taas lu pelti wul gwas ka, ata̱ pel ka̱pti ɗa̱ka̱ gwe wo ka, ata̱ wut gwesi ka̱ nhu gwasi, apaa ta̱ kwel ka̱pti ka na̱ wutu gwe ba̱ a mba̱shdli sowu. ");
INSERT INTO gyz_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ka̱ sa'i gwisi wo yek Yesu yil tet Galili yek ta̱ li dla̱lka Yodan ta̱ Yohana pa̱lit baptisma. ");
INSERT INTO gyz_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ama yek Yohana nda ngeti ɗe ta pa̱lit baptisma so, yek ta̱ wul Yesu ɗe, <<Amik ka li malki ta̱k pa̱li baptisma ama yek kik li tet ɗa?>> ");
INSERT INTO gyz_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yek Yesu wulti ɗe, <<Ningo zaki ta̱ na̱k gwisi pi ta̱n pa̱l mas ilgwe ni ndakce mal Nya wu.>> Yek paa Yohana ba̱l gaa gwasi yek ta̱ pa̱li Yesu baptisma. ");
INSERT INTO gyz_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ɗe sa̱ pa̱li baptisma Yesu wu, ɗe ta̱ yil tot ɗa̱ka̱ ze ka̱ wugo yek dlo nya ɓuli, yek ta̱ yen Shishi ga̱ Nya na̱k kulu sut nya yek ta̱ sak dla̱l tenti. ");
INSERT INTO gyz_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Yek yal ga̱ɓa gon sut nya wuli ɗe, <<Ga̱n go yen gi ka̱n a lamti, a na̱ma kumti ta̱mti gwas i'e.>> ");
INSERT INTO gyz_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yek Shishi ga̱ Nya ta̱la Yesu ka̱ me ta̱ Sheɗan cinga̱lti. ");
INSERT INTO gyz_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ta̱ pa̱l ka̱lka̱ze multi ɗe kutl ɗe wupsi na̱ ka̱ cin na̱ ka̱ gas wu, yek kuza̱n njel tlot gwasi i'e. ");
INSERT INTO gyz_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Yek Sheɗan ma̱n cinga̱ltisi li tet malti yek ta̱ wulti ɗe, <<Kume ki wo yen ga̱ Nya ka̱ɗe ki wu, hwi ye jin ɗe ta̱s pal ɗe ilga̱ nguki.>> ");
INSERT INTO gyz_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yek Yesu wulti ɗe, <<Ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <Ilga̱ nguki tokte ka̱ɗe ma̱n keta̱lti ga̱ mbala̱n so, ama mas ga̱ɓa gwe a yil sut mal Nya wu.> >> ");
INSERT INTO gyz_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yek Sheɗan ta̱lat Wurshelima ba̱n gwe Nya botli wu, Yek ta̱ tolti to ten gaa lubii ga̱ Nya ka, ");
INSERT INTO gyz_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Yek ta̱ wulti ɗe, <<Kume yen ga̱ Nya ka̱ɗe ki go ɗakci su ka, na̱k ɗe ni ga̱ lishi ɗe, << <Nya a hwi mil shinti jwas ga̱ɓa tenki asa̱ ngibki ka na̱ ang gwasa̱n, kangwe ka ɓo asa̱n ten ye sowu.> >> ");
INSERT INTO gyz_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yek Yesu wulti ɗe, <<Ni ga̱ lishi pak ɗe, <Ba̱k cinga̱l Nya Bagaa gwa so.> >> ");
INSERT INTO gyz_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yek Sheɗan po ta̱lat ten tlal tla̱nda̱l gon, yek ta̱ mbokit ang ten guu ji dii atli suk mbunti jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Yek ta̱ wulti ɗe, <<Ba ba̱lki mas wul jimi, ɗe kume ka̱ ngus atli yek ka̱ ba̱la̱n nalti wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yek Yesu wulti ɗe, <<Tli ɗa̱ mala̱n ka Sheɗan, ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <Ngusi atl Nya Bagaa gwa, a ti na̱ ngus ka̱n ka kumit bi.> >> ");
INSERT INTO gyz_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yek Sheɗan zakti, yek mil Shinti ji Nya tuli yek sa̱ nda̱llit gahwula̱n. ");
INSERT INTO gyz_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu kumi ɗe sa̱ le Yohana ka̱wu yek ta̱ zak luisi yek ta̱ li ka̱ ka̱t atl ga̱ Galili. ");
INSERT INTO gyz_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yek ta̱ zak Nazarat yek ta̱ li Kaparnahum ba̱n gwe ni njaa ten bi bal dla̱lka Galili ka̱ ka̱t atl ga̱ Zabalun suk Naptali wu. ");
INSERT INTO gyz_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na̱k gwisi pi ten ɗe ta̱ ilgwe Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu njika̱n ga̱ɓa gwe wuli ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Ka̱t atl ga̱ Zabalun suk ga̱ Naptali gwe ni ka̱ Galili, Lu ga̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, lu gwe lak gaa tu bal ze hal yek ɗakci dla̱lka Yodan wu ");
INSERT INTO gyz_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ma̱jwe sa̱ na̱ma da̱mti ka̱ da̱mshal wu sa̱ yen bal cilti wi. Mbala̱n jwe sa̱ na̱ma da̱mti ka̱ da̱n-da̱n ma̱shka̱n go Cilti a yilisi tot wi.>> ");
INSERT INTO gyz_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ka̱ sa'i gwisi ka̱n Yesu nde dla̱mti ga̱ɓa mbala̱n ɗe, <<Cin atl gaa, na̱k ɗe kanti Nya ɗe guu ga̱na̱n njaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ta̱ na̱ma la̱t ten bi bal dla̱lka Galili nu go, yek ta̱ yen Siman gwe asa̱ mbet ɗe Biturus wu suk yilka gwasi Andarawus asa̱ na̱ma dipti ze na̱ wul dopti kwes gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yek Yesu wulsi ɗe, <<Koɓa̱nni nini ba palla̱ki ɗe ma̱n ngot mbala̱n na̱k gwe aka̱ dop kwes wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nige-nige yek sa̱ lak wul dopti kwes gwasa̱n ka yek sa̱ kopti. ");
INSERT INTO gyz_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sa̱ na̱ma la̱t nugo yek Yesu yen Yakubu suk Yohana yilka gwasi. Si wo mil ji Zabadi ka̱n, Yesu mbisi asa̱ na̱ma la̱ka̱nti wul dopti kwesi suk aba gwasa̱n ka̱ jirgi ze. Yek ta̱ mbesi, ");
INSERT INTO gyz_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","yek nige-nige yek sa̱ zak jirgi suk aba gwasa̱n yek sa̱ kopti. ");
INSERT INTO gyz_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yek Yesu matl ka̱ mas ka̱t atl Galili ata̱ nima mbokti ang mbala̱n ten ga̱ɓa ga̱ Nya ka̱ lu motgaa gwasa̱n ata̱ nisi ma̱ dla̱mti ga̱ɓa ma̱n ta̱mti ten bi kanti Nya ɗe guu gwasa̱n. Yek ta̱ pita ndokti mas cwo suk la̱shi kumti ta̱mti ga̱ dli ji mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yek bi gwas ma̱tl ka̱ mas atl ga̱ Siriya, yek ma̱n ba̱mi ngusi tulla̱t ji mbala̱n jwasa̱n jwe dli ta̱misi bi sowu. Na̱ ma̱jwe sa̱ citi ka̱ na̱ cwo wonti wu, suk ma̱jwe na̱ma kumti dli suk ma̱jwe yeta̱l ni ka̱si ju, suk ma̱n maparpaɗa suk ma̱jwe dli jwasa̱n tla ka̱wu, yek ta̱ ndoksi mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yek mbala̱n wonti, ma̱n Galili, suk ma̱n Dikapolis, suk ma̱n Wurshelima, suk ma̱n Yehudiya hal suk ma̱jwe ni tu ten ka̱ti gon ga̱ dla̱lka Yodani wu kop kaal ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu yeni ɗe mbala̱n wonti mogaa wu, yek ta̱ to ten tla̱nda̱l ilgon gwasi. Ta̱ da̱n na̱ zhila wu, yek mil lishti jwas li tet malti. ");
INSERT INTO gyz_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yek ta̱ njelisi mbokti ang ten wul ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Ma̱n albarka ka̱ɗe ma̱jwe yis la̱shi nda̱lti gwasa̱n ten bi wul ji Nya wu, ten ɗe guu ga̱ Nya wo gwasa̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ma̱n albarka ka̱ɗe ma̱jwe asa̱ pa̱l duu tuk wu, ten ɗe sa wutisi bi tang ten mbadl wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ma̱n albarka ka̱ɗe ma̱jwe ba̱sa palli gaa gwasa̱n ɗe ilgon sowu ten ɗe sa mbi wul ji dii atli. ");
INSERT INTO gyz_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ma̱n albarka ka̱ɗe ma̱jwe sa̱ na̱ma kuza̱n suk ka̱lka̱ze ɗe ta̱s pa̱l ilgwe ni ndakce wu, ten ɗe tuk gwasa̱n a njika̱n. ");
INSERT INTO gyz_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ma̱n albarka ka̱ɗe ma̱jwe asa̱ yen gonti wu ten ɗe si mago sa yen gonti gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ma̱n albarka ka̱ɗe ma̱jwe mbadl jwasa̱n ni mbuni wu ten ɗe sa yen Nya. ");
INSERT INTO gyz_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ma̱n albarka ka̱ɗe ma̱jwe asa̱ la̱ka̱n dlo ga̱ mbala̱n wu ten ɗe sa mbesi ɗe mil ji Nya. ");
INSERT INTO gyz_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ma̱n albarka ka̱ɗe ma̱jwe sa̱ na̱ma tlat bomti ten pa̱lti wul ndakce wu ten ɗe boo ga̱ Nya wo gwasa̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Kii wo ma̱n albarka ka̱n ka̱ sa'i gwe mbala̱n byalkii yek sa̱ lakkii ka̱ bomti yek sa̱ shelikii lal gaa ga̱ pa̱lti mas byas wul ten bi gi wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ta̱ mbadl gwaka̱n ta̱mi aka̱a̱ pa̱l hwol tuki i'e na̱k ɗe Nya a ɓatlkii nal ka̱ boo gwas wu, nu ka̱n sa̱ lak ma̱n dla̱mti ga̱ɓa ga̱ Nya jwe tulikii cina ju ka̱ bomti. ");
INSERT INTO gyz_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Kii wo kik ɗe kwi ga̱ dii atli, kume kwi po ta̱m sogo, ɗa̱ nii ka̱n sa palli ta̱mti gwi? Ma̱lgon a po pa̱l ilgon na̱ nali so, ama sa wut ka a mbala̱n li na̱ asa̱n a dani. ");
INSERT INTO gyz_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<Kik ɗe cilti ga̱ dii atli. Ai ba̱n gwe ni ten za̱nda̱l go sa mana̱n hwunda̱lti ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mbala̱n laka̱n wutu ka̱ pitila asa̱ yitle ka na̱ gal so, ama asa̱ sa̱ zi ten lu za̱ti. Kangwe a cili, a mbala̱n yen lu ka̱ lubiimi wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na̱k gwisi ka̱n ha̱n ta̱ cilti gwaka̱n ngusi cilti, ta̱ mbala̱n yen hwa pa̱t gwaka̱n asa̱ ta̱s shin ga̱ Aba gwaka̱n gwe ta̱ ni to nya ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Ba̱k da̱ma̱n gwa we a tuli, ta tlok Mba̱t Ga̱ɓa ga̱ Musa suk Lishti ji ma̱n Dla̱mti Ga̱ɓa ga̱ Nya ka̱ so, a tul ɗe ta tlok ka̱ so a ma a tul ɗe ta njika̱mi ka. ");
INSERT INTO gyz_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gem ka̱n dlo nya suk dii atl a taas ka, ama ko ta̱ ilgwe ni ɗe nak'eni ka̱ Mba̱t Ga̱ɓa ga̱ Musa, mago a tlokdli ka̱ so se njika̱n mas. ");
INSERT INTO gyz_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ten na̱k gwisi ka̱n mas ma̱lgwe nge kopti mba̱ti gon a giɓi, ko ta̱ mba̱ti gwisi ka̱ni ɗe gwe nda nak'eni mani wu, yek ta̱ mboki ang mbala̱n ɗe ta̱s pa̱li nugo, sa mbet ɗe ma̱lgwe ni nak'eni ka̱ guu ga̱ Nya. A mas ma̱lgwe kop mba̱t ga̱ɓe yek ta̱ mboki ang mbala̱n dani go sa mbet ɗe kakshe a guu ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","A nikii ma hwiti, kume pa̱lti wul ndakce gwaka̱n man ga̱ ma̱n Paresi suk ma̱n mbokti ang mbala̱n ten Mba̱t Ga̱ɓa ga̱ Musa wu sowu, kaa te ka̱ guu ga̱ Nya so. ");
INSERT INTO gyz_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Ka̱a̱ kumi ɗe tet go sa̱ dla̱mi mbala̱n jina̱n ɗe <ba̱k tlo mbala̱n so, ma̱jwe tlo mbala̱n go sa nolti.> ");
INSERT INTO gyz_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ama ami wo a nikii ma hwiti ɗe mas ma̱lgwe mbadl lilit na̱ yilka gwas go sa nolti. A ma̱lgwe hwi yilka ɗe, <Ki wo mbala̱n ga̱ koo lu,> sa nolti, a ma̱lgwe wul yilka gwas ɗe, <Ki wo ka̱dla̱n ka̱ɗe ki wu!> Mbun ɗe ta̱ lakti buu wutu. ");
INSERT INTO gyz_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","<<Na̱ nu ka̱n kume ka̱ ɓa ba̱l wul ka̱ lu takti wul, yek ka̱ daami go ma̱lgon na̱ma lilti mbadl na̱ ki wu, ");
INSERT INTO gyz_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","lak la̱ka̱n dlo gwa suk ma̱li pa apaa ka̱ nda takti wuli. ");
INSERT INTO gyz_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<La̱ka̱n dlo gwa suk ma̱lgwe ta̱lak dlaboo wu ba̱le-ba̱le a ka̱yi ten tantu la̱t ka̱ lu kisti ga̱ɓe. La̱ka̱n dlo gwa sukti, ka̱ pa̱li nu sowu ta lakki ka̱ ang ga̱ ma̱n kisti ga̱ɓa, a ma̱n kisti ga̱ɓe lakki ka̱ ang ga̱ ma̱n hapti dlo asa̱ lek ka ka̱ lu gwe asa̱ le ma̱n pa̱lti byas wullu. ");
INSERT INTO gyz_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A nikma hwiti ɗe gem kaman yilti ka̱ so, se ka̱ ɓatl mas ilgwe ma̱n kisti ga̱ɓa tlwek ɗe ta̱k ɓatl wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Ka̱a̱ kume ɗe tek go sa̱ dla̱m ɗe <ba̱k pa̱n pa̱la̱n so.> ");
INSERT INTO gyz_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama ami wo a nikii ma hwiti ɗe mas ma̱lgwe yen kili mbala̱n yek ta̱ lam multi sukti go ma̱li pi pa̱la̱n sukti ka̱ mbadl gwas wi. ");
INSERT INTO gyz_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kume gwel gwa ka̱ti ga̱ ang shinti ka̱ɗe ma̱n lakti gwa ten pa̱lti byas wullu, yilli ka aka̱ lakka. A mani ki ta̱ ka̱t dli gon gwa ka̱ ni ɗa̱ so ɗa̱ gwe ta̱s lak mas dli gwa ka̱ buu wutu wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A kume a ang shinti gwa ka̱ɗe ma̱n lakti aka̱ pa̱l byas wullu, kotl ka ta̱k lakka. A maniki ta̱ ka̱t dli gon gwa ka̱ ni ɗa̱ so ɗa̱ gwe ta̱s lak mas dli gwa ka̱ buu wutu wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Tek go sa̱ wulsi ɗe, <Mas ma̱lgwe lam zakti ga̱ kili gwas go ta̱s ba̱lti lishti zakti.> ");
INSERT INTO gyz_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ama a nikii ma hwiti ɗe mas ma̱lgwe zak kili gwasi aba ten pa̱t pa̱la̱n ka̱n ta̱ mbit sogo ta̱ lakti ten pa̱t pala̱n wi. A ma̱lgwe hap kili gwe sa̱ zakti go, ta̱ na̱ma pa̱t pa̱la̱n sukti. ");
INSERT INTO gyz_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Ka̱a̱ po kume ɗa̱ɗe tek go sa̱ hwi mbala̱n ɗe, <Ba̱s mo ga̱ɓa suk Nya ten lal so, ama ta̱s pa̱l ilgwe sa̱ mo ga̱ɓa na̱ Nya dani.> ");
INSERT INTO gyz_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ama ami wo a nikii ma hwiti ɗe, ba̱k mo ga̱ɓa suk Nya so. Ba̱k mo ga̱ɓa na̱ dlo nya so na̱k ɗe yek ɗe lu da̱nti ga̱ Guu Nya wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A ba̱k mwe na̱ dii atl so, na̱k ɗe yek ɗe lu za̱t asa̱n gwas wu, ba̱k mwe na̱ Wurshelima so pak, ai yek ɗe ba̱n ga̱ Bal Guu. ");
INSERT INTO gyz_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ba̱k mo ga̱ɓa na̱ gaa gwa so, na̱k ɗe ka man palla̱t ga̱ ma̱dla̱n ɗe na̱m ga̱ gaa gwa hwoli sogo duuni dani sowu. ");
INSERT INTO gyz_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ka̱ mas ilgwe kaa dla̱m wu ta̱ ga̱ɓa gwaka̱n dla̱l ten <Yii> sogo <Wowo.> Kume ɗakci nu wu, tet mal Ma̱n Ngalci wu ka̱n yil teɗi. ");
INSERT INTO gyz_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Ka̱a̱ kumi ɗe tek go sa̱ dla̱m ɗe <Gwel ka̱ lal ga̱ gwel, shin ka̱ lal ga̱ shin.> ");
INSERT INTO gyz_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama ami wo a nikii ma hwiti ɗe, ba̱k nge ɗe ta̱ mbala̱n tekii ga̱zi so. Kume ma̱lgon ɓek kalka̱ng ten ka̱t ang shinti go, ballit ka̱ti ga̱ ang yali wu pak. ");
INSERT INTO gyz_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kume ma̱lgon ta̱lak dlaboo ten bi kuka̱l gwa ga̱ tugiɓi go, ba̱lti luka̱l ga̱ tukaali pak. ");
INSERT INTO gyz_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kume ma̱lgon zik ngetli ta̱k li sukti dlenta̱t ga̱ mil ɗe na̱m wu, li sukti hal mil ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mas ma̱lgwe ngemik wul go patti ɗa̱ so, a ma̱lgwe ngemik dul go ba̱lti. ");
INSERT INTO gyz_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Ka̱a̱ kumi tek go sa̱ dla̱m ɗe, <Lam yilka gwa, aka̱ nge ma̱n nget gwa.> ");
INSERT INTO gyz_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ama ami wo a nikii ma hwiti ɗe ta̱k lama̱n ma̱jwe ngekii wu, ngemi Nya ma̱jwe nikii ma cit dlelngapcan wu. ");
INSERT INTO gyz_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kume ka̱ pa̱li na̱k gwisi go kaa da̱m ɗe mil ji Aba gwaka̱n gwe ni to nya ka̱wu, ti ɗe ata̱ laki a cin yili hwa mbala̱n suk byasi, ata̱ laki a ze nde ma̱n pa̱lti wul ndakce suk ma̱n pa̱lti byasi. ");
INSERT INTO gyz_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kume ma̱jwe sa̱ lamkii wu ka̱n aka̱a̱ lamsi na̱ ngusa̱n go, ɗa̱ni ka̱n sa ɓatlkii gwi? Ai ko ta̱ ma̱n kanti wulpi boo mago na̱k gwe aka̱a̱ pa̱li wu ka̱n asa̱ pa̱li. ");
INSERT INTO gyz_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A kume yilkeni jwaka̱n ka̱n aka̱a̱ ga̱ɓesi na̱ ngusa̱n go, na̱ yek ka̱a̱ man naa mbala̱n ye? Ai mbala̱n jwe ɗe ma̱n Yehuda ka̱ sowu mago nu ka̱n asa̱ pa̱li. ");
INSERT INTO gyz_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nuk go da̱ma̱n ga̱ njikmi na̱k kangwe ga̱ Aba gwaka̱n gwe ni nya wu njika̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Pa̱n ɗem-ɗem ba̱k pa̱la̱n hwa wul ten ɗe ta̱ mbala̱n yeni asa̱ ta̱skii so. Kume ka̱a̱ pa̱li nu go, kaa mbi ɓatlti mal Aba gwaka̱n gwe ni nya wu so. ");
INSERT INTO gyz_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<Kume ka̱a̱ ɓa ba̱l wul ma̱n la̱shi wul wu, ba̱k pa̱nta ga̱ɓa dani na̱k gwe a ma̱n riya pa̱li ka̱ lu motgaa gwasa̱n suk ɗa̱n ten tantu ka̱ ten ɗe ta̱ mbala̱n ta̱ssi wu so. Gem, amik ka hwikii ge sa̱ mbi ɓatlti gwasa̱n wi. ");
INSERT INTO gyz_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama kume ka̱a̱ ɓa ba̱l wul ma̱n la̱shi wul wu, ba̱k zaki ni a ang yali gwaka̱n yis ilgwe ang shinti na̱ma pa̱lti wu so. ");
INSERT INTO gyz_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kangwe ba̱lti wul gwaka̱n a ni ga̱ hwunda̱li wu, a Aba gwaka̱n ɗe ata̱ yen wul gwe a mbala̱n pa̱li ga̱ hwunda̱li wu ɓatlkii. ");
INSERT INTO gyz_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Kume ka̱a̱ ɓa ngem Nya go, ba̱k pa̱li na̱k ma̱n pa̱lti riya so, na̱k ɗe si wo asa̱ laam ngemti Nya a nya ɗa̱nka̱ lu motgaa gwasa̱n ka suk ɗa̱n ten tantu ka kangwe mbala̱n a yensi dani wu. Gem, amik ka hwikii ge sa̱ mbi ɓatlti gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ama kume ka̱a̱ ɓa ngem Nya go te punka, aka̱a̱ le dlabii ka aka̱a̱ ngem Aba gwaka̱n gwe ba̱ mbala̱n a yenti dani sowu. Ti ɗe ata̱ yen mas ilgwe ni ga̱ hwunda̱li ka̱wu ta ɓatlkii. ");
INSERT INTO gyz_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kume ka̱a̱ ɓa ngem Nya go, ba̱k pa̱nta ka̱pti ga̱ɓa ten wul ɗe na̱m na̱k ma̱jwe asa̱ pa̱l wul na̱k wule si wo hwa mbala̱n ka̱ɗe si wu so. Sa̱ da̱ma̱n gwa we ten ka̱pti ga̱ɓa gwasa̱n ka̱n ta katisi ka̱ng. ");
INSERT INTO gyz_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ba̱k pa̱li na̱k gwasa̱n wu so na̱k ɗe Aba gwaka̱n yis ilgwe ka̱a̱ lami tun a ba̱ka̱a̱ ɓo ngemti sowu. ");
INSERT INTO gyz_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","<<Nuk'wu, kume ka̱ ɓa ngem Nya go aka̱a̱ wuli ɗe, << <Aba ga̱na̱n gwe ni to nya ka̱wu, ha̱n ta̱ mbala̱n ɓanti shin gwa ");
INSERT INTO gyz_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ha̱n ta̱ da̱mti gwa ɗe guu tuli. Ha̱n ta̱ ilgwe ka̱ lami wu pi ten dii atli na̱k gwe a pi to nya ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ba̱lni ilgwe ma guk ase wu. ");
INSERT INTO gyz_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Taasini mas byas wul jina̱n ka na̱k gwe ama̱ taasi ma̱jwe asa̱ pa̱lini byas wul wu. ");
INSERT INTO gyz_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ba̱k zakni ta̱n nda so ɗe kume sa̱ ɓa cinga̱lni wu. Ama aka̱a̱ te ka̱ dlo ga̱na̱n suk Ma̱n Ngalci wu.> ");
INSERT INTO gyz_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Kume ka̱a̱ taasi byas wul ma̱jwe pa̱likii byas wul wu, Aba gwaka̱n gwe ni to nya ka̱wu mago ta taasikii gwaka̱n ka. ");
INSERT INTO gyz_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama kume ka̱a̱ taasi byas wul ma̱jwe sa̱ pa̱likii byas wul wu ka̱ sogo, Aba gwaka̱n mago ta taasikii gwaka̱n wu ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<A kume ka̱ ɓa pa̱l ka̱lka̱ze wu, ba̱k docina̱n cina gwel na̱k ma̱n pa̱lti riya so, na̱k ɗe si wo asa̱ docin cina gwel ta̱ mbala̱n yeni asa̱ yisi ɗe sa̱ na̱ma ka̱lka̱ze wu. Gem, amik ka hwikii ge sa̱ mbi ɓatlti gwasa̱n wi. ");
INSERT INTO gyz_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama kume ka̱a̱ pa̱l ka̱lka̱ze go aka̱ pola̱n gwel gwaka̱n ka aka̱a̱ tuksi mili ten gaa, ");
INSERT INTO gyz_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ba̱ mbala̱n yenkii asa̱ yisi ɗe ka̱a̱ na̱ma pa̱lti ka̱lka̱ze so, ama Aba gwaka̱n ɗe ata̱ yen mas ilgwe ni ga̱ hwunda̱li ka̱wu a ɓatlkii. ");
INSERT INTO gyz_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Ba̱k mwe wul gaa gwaka̱n ten dii atl so, lu gwe a da̱kmbi lili ka, a kaci ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mwe wul gwaka̱n to nya ka, ka̱ lu gwe da̱kmbi a lili ka̱ so, a ba̱ a kaci ka̱ so wu. Muka̱l mago sa man teti asa̱ muka̱li ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ten ɗe ka̱ lu gwe wul gwaka̱n ni wu, ka̱li ka̱n mbadl gwaka̱n ni pak. ");
INSERT INTO gyz_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Gwel ka̱ɗe cilti ga̱ dli. Kume gwel gwa ni hwaɓi wu, dli gwa a ni cili. ");
INSERT INTO gyz_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama ɗe kume cilti ga̱ dli gwa wo da̱mshal ka̱ go, gem da̱mshal gwe ka̱ ni giɓi go bali ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Mbala̱n a man da̱n ɗe zhel ga̱ bagaa ɗe lop ka̱ sa'i ɗe na̱m so. Ngetli ka̱n ta̱s lam gon ata̱ nge gon, sogo ta̱s kumi bi gon ata̱ nge kumti bi gon. Mbala̱n a man da̱mti ɗe zhel ga̱ Nya suk lamti wulpi so. ");
INSERT INTO gyz_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","<<Ten na̱k gwisi ka̱n, a nikii ma hwiti ɗe ba̱k hwota̱n gaa gwaka̱n ka̱ da̱mti gwaka̱n so, ten bi ilgwe kaa nguk wu, suk ilgwe kaa tla wu sogo luka̱l gwe kaa lak wu. Ase mbadl ga̱ mbala̱n mana̱n ilga̱ nguki sa? Aba̱ dli ga̱ mbala̱n mana̱n luka̱l ga̱ laki sa? ");
INSERT INTO gyz_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ɓo yena̱n yadl la, ba̱sa ɓak zhin so, ba̱sa wotl wul zhin so, a ba̱sa moo wul ka̱ nhu so. Ama Aba gwe ni nya wu na̱ma citi na̱ si. Ka̱a̱ yisi ɗe ka̱a̱ nal man yadl mal Nya sa? ");
INSERT INTO gyz_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wok ni ka̱ kii gwe ɗe wul hwotti wugo ta mani mba̱lti gaa gwas ko ta̱ sa'i ɗe na̱m dani wo? ");
INSERT INTO gyz_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","<<Yek laki yek luka̱l gwe kaa lak wu a hwotkii ye? Ɓo yena̱n buzha ɗe asa̱ kiɗi ka̱ me wu la, kangwe ba̱sa pa̱l ilgon so, a ba̱sa pi luka̱l so wu. ");
INSERT INTO gyz_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mas na̱ na̱k gwisi, ko ta̱ Sulemanu guu na̱ mas nalti gwas mago, ta̱ kin mbuni luka̱l yek ta̱ kinti ka na̱k ɗe na̱m ka̱ buzha jin so. ");
INSERT INTO gyz_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ɗe hal Nya kin buzha ka̱ me ka na̱ mbunti wu, si ɗe sa̱ ni ɗa ase, ama ayo asa̱ kweli ka ka̱ wutu wugo, se kii ka̱n ba̱ Nya a pa̱likii sa? Kii mbala̱n jwe ba̱sa̱ nga̱sti ten Nya sowu! ");
INSERT INTO gyz_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Na̱ nu ka̱n ba̱k hwota̱n gaa gwaka̱n aka̱a̱ na̱ma wulti ɗe, <Yek ma nguka̱n ye?> Sogo <Yek ma tla ye?> Sogo <Yek ma laka̱n ye?> ");
INSERT INTO gyz_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ma̱jwe sa̱ yis Nya sogo sik ɗe ma̱n ngot wunda̱l ji wul jimi, ama kii wo Aba gwaka̱n gwe ni to nya ka̱wu yisi ɗe ka̱a̱ lam wul jwisi mas. ");
INSERT INTO gyz_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ama ngo guu ga̱ Nya suk pa̱lti wul ndakce gwasi, apaa ta̱ mba̱likii mas naa wul jwisi. ");
INSERT INTO gyz_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ten na̱k gwisi ka̱n, ba̱k hwota̱n gaa gwaka̱n na̱ wul jwe a pi ayo wu so, ayo a tul na̱ wul jwasi. Hwotti ga̱ ase kumkii wi. ");
INSERT INTO gyz_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Ba̱k zi du gaa ma̱lgon so, kii mago ma̱lgon a zikii so. ");
INSERT INTO gyz_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ten ɗe na̱ wunda̱l kisti ga̱ɓa gwe ka̱ pa̱li mbala̱n go, wunda̱lisi ka̱n sa pa̱liki. Gal cinga̱lti wul gwe ka̱ cinga̱li mbala̱n ɗa̱ go na̱ nali ka̱n sa cinga̱liki. ");
INSERT INTO gyz_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","<<Yek laki ɗe ka̱ na̱ma za̱t gwel ten nak'en ilgon ɗe ni yilka gwa gwel wu, ama yek ba̱ bali gwe ni ka̱ gwa wu hwotki so ye? ");
INSERT INTO gyz_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ɗa̱ nii ka̱n ka wul yilka gwa ɗe, <Ha̱n ta yillik nak'en ilga̱n ɗe nik ka̱ gwel wu ka,> Ama a ki wo bali ka̱ ni ka̱ gweli gwa wu gwi? ");
INSERT INTO gyz_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ki ma̱n riya, yilli bal ilgwe nikka̱ gwel wu ka, ta̱k man yenti lu i'e ɗa apaa ka̱ man yilla̱t nak'en ilgon gwe ni ka̱ gwel ga̱ yilka gwa wu ka. ");
INSERT INTO gyz_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<Ba̱k ba̱la̱n kaɗi wul gwe sa̱ botli ka̱wu so. A ba̱k ba̱la̱n zok mbuni ye Alade so. Ten ɗe sa li na̱ asa̱n dani, asa̱ palikii gaa asa̱ kumikii cwo. ");
INSERT INTO gyz_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<Pa̱nta ngemti sa ba̱lkii, ngweni kaa mbi, kotla̱n bi dlabii sa ɓulikii. ");
INSERT INTO gyz_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mas ma̱lgwe ngemi go sa ba̱lti, a ma̱lgwe ngwe go ta mbi. Ma̱lgwe ngusi kotlti bi dlabii go sa ɓuliti. ");
INSERT INTO gyz_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","<<Ka̱ kii wo wok ɗe gwe ɗe yen gwas a ngemit ba̱redi ata̱ ba̱lti ye wo? ");
INSERT INTO gyz_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sogo ta̱s ngemit kwesi ata̱ ba̱lti wuci wo? ");
INSERT INTO gyz_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kii ɗe ma̱n ngalci wu mago yek ka̱a̱ yis kangwe kaa ba̱l hwa wul mil jwaka̱n wu, Aba gwaka̱n gwe ɗe ta̱ ni to nya ka̱wu pa? Ai ta ba̱la̱n hwa wul ma̱jwe sa̱ ngemit wu. ");
INSERT INTO gyz_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ilgwe ka̱a̱ lami ɗe ta̱ mbala̱n pa̱likii wu, kii mago pa̱lisi nu pak. Nu ka̱n Mba̱t Ga̱ɓa ga̱ Musa suk taka̱rda ji ma̱n dla̱mti ga̱ɓa ga̱ Nya mbok ang. ");
INSERT INTO gyz_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Koɓi tu ka̱ ngaɓi tantu na̱k ɗe tantu gwe a ta̱la mbala̱n ka̱ buu wutu go alti ka̱n ni wu. Kopti tantu gwisi wo bom so, a ma̱jwe asa̱ koɓi go wonti ka̱n sa̱ni. ");
INSERT INTO gyz_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tantu gwe a mbala̱n koɓi asa̱ mbi mbadl go ngaptlan ka̱n ni, a kopti gwas bomi. Mbala̱n jwe asa̱ koɓi tu ka̱li go sa̱ wonti so. ");
INSERT INTO gyz_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Pa̱n ɗem-ɗem na̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya ga̱ la̱li, ma̱jwe asa̱ tul malkii na̱k wule mba̱la ka̱n ama kaɗila̱p jwe kuza̱n na̱ma tlot gwasa̱n i'e ka̱ɗe si wu. ");
INSERT INTO gyz_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tumal pa̱t jwasa̱n ka̱n kaa yissi. Kaa man kotlti yandi inabi ten tlindi zhina a? Ko a ma̱n kotlti yandi tula̱n ten tlindi wuɓa̱l la? ");
INSERT INTO gyz_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","A na̱k gwisi ka̱n mas hwa tlindi wo ata̱ wut hwa yandi, a byasi wo ata̱ wut byas yandi. ");
INSERT INTO gyz_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hwa tlindi wo ba̱ a wut byas yandi so, a ba̱ a byas tlindi a wut hwa yandi so. ");
INSERT INTO gyz_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kume nuk go, mas tlindi gwe wut hwa yandi sogo asa̱ wotl ka asa̱ wut ka̱ wutu. ");
INSERT INTO gyz_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ten na̱k gwisi ka̱n kaa yis ma̱n dla̱mti ga̱ ɓa ga̱ Nya ji lali tu ten pa̱t jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Mas ma̱jwe asa̱ mbe ɗe Bagaa wu kaa te ka̱ guu ga̱ Nya so, ama se ma̱jwe asa̱ pa̱l ilgwe Aba gi gwe ni wu nya lami wu. ");
INSERT INTO gyz_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ten cin gwisi wo, mbala̱n wonti a wula̱n ɗe, <Bagaa, Bagaa! Ale ma̱ laki mbala̱n icin ten ga̱ɓa ga̱ Nya na̱ shin gwa na̱? Ale ma̱ yilla̱n ma̱zhe ɗa̱ka̱ mbala̱n ka na̱ shin gwa na̱? A ma̱ pa̱l wul cit ɓanti wonti na̱ shin gwa.> ");
INSERT INTO gyz_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Apaa a wulsi ɗe, <A yiskii so, tli ɗa̱ mala̱n ka, kii ma̱n palti byas wul!> ");
INSERT INTO gyz_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Ten na̱k gwisi ka̱n, mas ma̱lgwe kum ga̱ɓa gini yek ta̱ koɓi go, ta da̱m na̱k ma̱n ɓotlka̱n yisti wul gwe kin lubii ten pa wu. ");
INSERT INTO gyz_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ɗe ze nda wi ɗe dla̱lka njika̱n wu, yek yeta̱l tli toɗi yek ɓo lubiimi, ama yek ba̱ nda so na̱k ɗe ten pa ka̱n ta̱ lak zhila lubii wu. ");
INSERT INTO gyz_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ama mas ma̱lgwe kum ga̱ɓa gi ga̱n yek ta̱ nge kopti go, ta da̱m na̱k ka̱dla̱n gwe kin lubii ten yelsi wu. ");
INSERT INTO gyz_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ɗe ze nda wi ɗe dla̱lka njika̱n, yek yeta̱l tak ɓo lubiimi wu, yek lubiimi nda ka, byas ndati.>> ");
INSERT INTO gyz_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu pak wul jwisi wu, yek ɓanti ci mbala̱n ten kangwe ta̱ hwisi ga̱ɓe wu, ");
INSERT INTO gyz_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","na̱k ɗe ta̱ hwisi ga̱ɓa na̱k ma̱n iko gon, ba̱ ɗe na̱k kangwe a ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa pa̱li wu so. ");
INSERT INTO gyz_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu yil sut ɗa̱ka̱ tla̱nda̱li ka̱wu, yek mbala̱n wonti kopti. ");
INSERT INTO gyz_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yek ma̱n gita gon li tet malti, yek ta̱ ngusit atli yek ta̱ ba̱lti nalti. Yek ta̱ wulti ɗe, <<Bagaa, kume ta̱mik ɗa̱ go ka palla̱n ɗe ma̱n la̱shi da̱ska̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yek Yesu tak ang yek ta̱ ta̱nti, yek ta̱ wuli ɗe, <<Ta̱ ta̱mi ɗa, da̱m ɗe ma̱n la̱shi da̱ska̱n.>> Yek ma̱li ndoki ka̱li-ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yek Yesu wulti ɗe, <<Ba̱k hwi ma̱lgon ilga̱n so, ama li ta̱ ma̱n Pa̱ris ɓo yenki aka̱ ba̱l wul sadaka na̱k gwe Mba̱t Ga̱ɓa ga̱ Musa dla̱m wu. Pa̱li na̱k gwisi ta̱ mbala̱n yisi ɗe ka̱ ndoki wi.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu te ka̱ ba̱n Kaparnahum wu, yek bali ga̱ ma̱n hapti dlo ga̱ Roma gon li tet malti yek ta̱ ngemti ɗe ta̱s zit ang ne. ");
INSERT INTO gyz_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Yek ta̱ wulti ɗe, <<Bagaa, zhel gi ni lubii a atli za̱tak dli tlet ka, ta̱ na̱ma tlat bomti i'e.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yek Yesu wulti ɗe, <<Ba li a lak ndokti.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yek ma̱li wulti ɗe, <<Bagaa, a mbuki ta̱k li tet ɗa ka̱ so, ga̱ɓa kawei zhel gi a ndoki. ");
INSERT INTO gyz_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na̱k ɗe ami mago a atl ɗa̱ ma̱lgon ka ka̱n ani, a ma̱n hapti dlo jon ni atl ɗa ka̱ pak wu. A wul gon ɗe, <Li te du,> ata̱ li. A po wul gon ɗe, <Li teɗi,> ata̱ li te. A wul zhel gi ɗe <Pa̱li na̱k ga̱n,> ata̱ pa̱li nu wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu kum ga̱ɓa ga̱mi wugo, yek ta̱ ngip bi ka̱ ang yek ta̱ wul ma̱jwe sa̱ na̱ma kopti kaal gwas wu ɗe, <<Gem a mik kaa hwikii ge, ka̱ ma̱n Yisiraila mago a ɓo yen ma̱lgwe nga̱sti ten Nya gwas nda̱l na̱k ga̱ ma̱lga̱n wu so.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A niki ma hwiti ɗe ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu na̱k ma̱lga̱n wonti a yil tet tu gaba̱s suk tet tu yemma asa̱ da̱m na̱ zhila asa̱ nguk wul suk Iba̱rahim suk Ishaku suk Yakubu ka̱ guu ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ama ma̱jwe mbun ɗe ta̱ sik ni ɗe mil guumi go sa laksi to deɓa̱l ka ka̱ duu da̱mshal, a duk ka̱n sa kuli asa̱ as ang bi. ");
INSERT INTO gyz_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yek Yesu wul ma̱n hapti dlomi ɗe, <<Zigaa, a piki na̱k kangwe ka̱ nga̱ski ten Nya ɗe ta̱ pik wu.>> Yek zhel ga̱ ma̱n hapti dlomi ndoki ka̱li-ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ɗe Yesu te lubii ɗa̱ Biturus ka̱ wu, yek ta̱ mbi nkwe ga̱ Biturus ten zazzaɓi. ");
INSERT INTO gyz_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yek Yesu ta̱n ang gwasi, yek zazzaɓi zakti, yek ta̱ tlinya yek ta̱ pa̱lit wul. ");
INSERT INTO gyz_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɗe sukti pi wugo, yek sa̱ tullit mbala̱n jwe ma̱zhe ni ka̱si ju wonti. Yek ta̱ yilli ma̱zhesi ka na̱ ga̱ɓa ga̱ bi gwasi, yek ta̱ ndok mas ma̱jwe dli ta̱mi bi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Na̱k gwisi pi ten ɗe ta̱ ilgwe Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu njika̱n. Ga̱ɓa gwe wule, <<Ta̱ yem cwo jina̱n ka yek ta̱ hwula̱nni na̱ la̱shi kumti ta̱mti ga̱ dli jina̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu yeni wi ɗe mbala̱n wonti ganda̱lti wu, yek ta̱ laki ɗe ta̱s ɗakci bal dla̱lke ta̱s pal tu ten ka̱ti gwe ni tu te duk wu. ");
INSERT INTO gyz_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yek ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa gon li tet malti, yek ta̱ wulti ɗe, <<Ma̱n lishti, ba̱ kopki mas lu gwe ka li wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yek Yesu wulti ɗe, <<Gwen-gwen wo shu nisi ɗa, a yadl mago bii nisi ɗa, ama ami yen ga̱ mbala̱n wo lu multi ni ɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yek ɗe na̱m ka̱ mil lishti ji Yesu wulti ɗe, <<Bagaa, zaka̱nni ta lak lep aba gi paa, apaa a lak kopki.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yek Yesu wulti, <<Zak hwu mbala̱n ta̱s lep yilkeni jwasa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yek Yesu te ka̱ jirgi ze, yek mil lishti jwas kopti. ");
INSERT INTO gyz_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sa̱ ni nugo yek ba̱l yeta̱l nyaze gon tli tot ten bal dla̱lke hal yek zesi tlinya na̱k wule a cin jirgi na̱ gaa. Ama a Yesu na̱ma ndet yemba̱l. ");
INSERT INTO gyz_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yek mil lishti jwas sak pa̱da̱lti, yek sa̱ wulti ɗe, <<Bagaa kisni ne, ma̱ ɓa su ga̱z gaa ze!>> ");
INSERT INTO gyz_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yek Yesu wulsi ɗe, <<Yek laki yek ɓanti a cikii ye? Kii ma̱jwe ba̱ nga̱sti ten Nya gwaka̱n nda̱l sowu.>> Yek ta̱ tlinya yek ta̱ matl yeta̱li suk zesi. Yek mas tlo ang, yek lu da̱m mbetlak. ");
INSERT INTO gyz_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yek mbala̱n ngip bi ka̱ ang, yek sa̱ ngusi wulti ka̱ dlo gwasa̱n ɗe, <<Wok ɗe ga̱n ɗe hal yeta̱l suk kapsi ze mago asa̱ kumit bi go?>> ");
INSERT INTO gyz_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu mbuk lu ka̱ ka̱t atl ga̱ Garasina wu, yek ma̱n ma̱zhe jon ɗe lop jwe asa̱ da̱m ka̱ gazukɗi mo sukti. Ma̱n ma̱zhe jwisi wo sa̱ da̱m ɗe wul cit ɓanti i'e wi, hal sa̱ laki yek ba̱ mbala̱n po man kopti tu ten tantu gwisi so. ");
INSERT INTO gyz_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Yek sa̱ des le yek sa̱ wuli ɗe, <<Yek ɗe ze gwa suk mi ye, ki Yen ga̱ Nya? Ka̱ tul ɗe ta̱k nolni a ba̱ multi ɓo njika̱n sa?>> ");
INSERT INTO gyz_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ka̱ sa'isi wo a alade jon ni njaa ka̱li sa̱ na̱ma kyo. ");
INSERT INTO gyz_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Yek ma̱zhesi ngem Yesu ɗe, <<Kume ɗe ka̱ yilla̱ni ka̱wu, aka̱ zakni ta̱n te ka̱ alade ju.>> ");
INSERT INTO gyz_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yek Yesu wulsi ɗe, <<Yilla̱n te ka.>> Yek sa̱ yil ɗa̱ka̱ mbala̱mi ka, yek sa̱ lak te ka̱ aladesi. Yek mas aladesi lok su ka̱ zesi ka yek sa̱ ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yek ma̱n kyo aladesi lak dla̱mi mbala̱n wul mas jwisi na̱ ilgwe pi na̱ ma̱n ma̱zhe ju pak. ");
INSERT INTO gyz_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yek mas ma̱n ba̱mi yil suɗi ta̱s yen Yesu, sa̱ yenti wugo yek sa̱ ngemti ta̱s zakisi ka̱t atl gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yek Yesu te ka̱ jirgi ze, yek ta̱ pal te ka̱ ba̱n gwas ka. ");
INSERT INTO gyz_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yek ma̱jon tulli ma̱lgwe dli tlet ka̱wu malti a atl ten lumulti. Ta̱ yen nga̱sti ten Nya gwasa̱n wu, yek ta̱ wul ma̱n cwoɓi ɗe, <<Yen gini ba̱ ilgon hwotki so, sa̱ taasik byas wul gwa ka̱wi.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Na̱ kumti na̱k gwisi, yek ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa jon wul yilkeni jwasa̱n ɗe, <<Ma̱lga̱n na̱ma cutgaa suk Nya!>> ");
INSERT INTO gyz_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Na̱k ɗe Yesu yis ilgwe sa̱ na̱ma daamti gwasa̱n dani wu, yek ta̱ wulsi ɗe, <<Yek laki ɗe ka̱a̱ na̱ma daamti byas wul ka̱ mbadl gwaka̱n ye? ");
INSERT INTO gyz_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gwik bom so gwi? na̱ ta̱ wule, <Sa̱ taasik byas wul gwa ka̱wi.> Sogo ta̱ wule, <Tlinya ta̱k zigaa?> ");
INSERT INTO gyz_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ama a na̱ma lamti ta̱k yisi ɗe iko ni yen ga̱ mbala̱n ɗa ta̱s taasi byas wul mbala̱n ka ten dii atli.>> Yek ta̱ wul ma̱lgwe dli tlet ka̱wu ɗe, <<Tlinya ta̱k kan lumulti gwa ta̱k li lubii.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Yek ma̱li tlinya yek ta̱ li ga̱s lubii. ");
INSERT INTO gyz_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wonti mbala̱mi yeni nu wu, yek ɓanti cisi, yek sa̱ ba̱l nalti Nya ɗe ta̱ ba̱l iko pa̱lti na̱k gwisi mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ɗe Yesu ci cina na̱ za̱tgaa wu, yek ta̱ yen ma̱lgon gwe asa̱ mbet ɗe Matiyu ata̱ ni na̱ zhila ka̱ lu kanti wulpi boo. Yek ta̱ wulti ɗe, <<Koɓa̱nni,>> Yek ta̱ tlinya yek ta̱ kopti. ");
INSERT INTO gyz_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kaal na̱k gwisi ɗe ka̱a̱ Yesu suk mil lishti jwas ɓa nguk wul ka̱ lubii ga̱ Matiyu wu, yek ma̱n kanti wulpi boo suk ma̱n pa̱lti byas wul wonti tuli, yek sa̱ lak da̱n na̱ zhila mal Yesu suk mil lishti jwasi yek sa̱ nguk wul. ");
INSERT INTO gyz_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ɗe ma̱n Paresi yeni nu wugo, yek sa̱ wul mil lishtisi ɗe, <<Yek laki ɗe ma̱n lishti gwaka̱n na̱ma ngukti wul suk ma̱n kanti wulpi boo suk <ma̱n pa̱lti byas wul ye>?>> ");
INSERT INTO gyz_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu kumi nu wugo yek ta̱ wulsi ɗe, <<Ma̱jwe ba̱ cwo na̱ma cit gwasa̱n sowu ngo ma̱n ika̱n so, se ma̱n cwo. ");
INSERT INTO gyz_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ama a lamti ta̱k sak yena̱n ilgwe ga̱ɓa ga̱na̱n mbokti ang dani wu, ga̱ɓa ɗe ta̱ wuli ɗe, <Yenti gonti ka̱n a lami, ba̱ ɗe we sadaka so.> Ten na̱k gwisi ka̱n, a tul ɗe ta̱ mbe ma̱n wul ndakce so, ma̱n pa̱lti byas wul ka̱n a tuli mbet gwasa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ka̱ sa'i gwisi, yek mil lishti ji Yohana tul mal Yesu yek sa̱ ngemti ɗe, <<Yek laki ɗe na̱ mi, na̱ ma̱n Paresi a ma̱ pa̱l ka̱lka̱ze ama mil lishti jwa wo ba̱sa pa̱li so ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yek Yesu wulsi ɗe, <<Yela̱n ji pyal kos a pa̱l duu tuki a pyal kosi yi suksi ya? Ai multi jwe sa kamisi pyal kosi ka̱wu yi teɗi, ka̱ sa'isi ka̱n sa pa̱l ka̱lka̱ze. ");
INSERT INTO gyz_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","<<Ai ma̱lgon kama̱n pyal yadi ata̱ tla̱m keshti ga̱ gus ka na̱ nali so, kume ta̱ pa̱li nugo gus luka̱li a kesh ka man kangwe kesh cina wu. ");
INSERT INTO gyz_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","A ba̱ mbala̱n a shot pyal ze inabi ka̱ gus ngura kul so. Kume ta̱ pa̱li nu go, ngure a kesh ka a ze inabisi shot te atl ka a yekge ngure lil ka̱ wi. Pyal ze inabi wo ka̱ pyal ngura kul ka̱n a shoti. Pa̱lti na̱k gwisi ka laki asa̱ mbi ze inabisi suk ngura kuli.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu nisi ma ga̱ɓa nu go yek bacina ga̱ lu motgaa ga̱ ma̱n Yehuda gon tuli, yek ta̱ ngus atl a cina ɗatka, yek ta̱ wulti ɗe, <<Ninge ninge ka̱n yen gi ya ma̱shi, ama lite ta̱k ta̱nti ta pal kaami.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yek Yesu tlinya yek ta̱ kopti suk mil shinti jwas ji botli. ");
INSERT INTO gyz_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Yek kili gon gwe ta̱ pa̱l gin ɗe kutl cet lop a hwulan nitma shotti wu, li tet tu tukaal ga̱ Yesu, yek ta̱ ta̱n bi luka̱l gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Na̱k ɗe ta̱ wuli ka̱ mbadl gwas ɗe, <<Ko ta̱ luka̱l gwas ka̱n a ta̱ ni go, ba ndoki.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yek Yesu balla̱ti yek ta̱ yenti wu yek ta̱ wulti ɗe, <<Yen gini ba̱ ilgon hwotki so, nga̱sti ten Nya gwa ndoki wi.>> yek ta̱ ndoki ka̱li-ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ɗe Yesu mbuk lu ɗa̱ bacinesi ka̱wu, yek ta̱ mbi mbala̱n asa̱ na̱ma hotti sheta̱l asa̱ na̱ma shila̱n ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yek Yesu wule, <<Ba̱la̱nni nini lu, yen kilisi ɓo ma̱sh so, yemba̱l ka̱n ta̱ na̱ma ndeti.>> Yek sa̱ gitliti. ");
INSERT INTO gyz_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Sa̱ yilli mbala̱mi deɓa̱l wu, yek Yesu te ka̱ giɓi yek ta̱ ngiɓi ang yen kilisi, yek ta̱ tlinya. ");
INSERT INTO gyz_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Yek ga̱ɓa gwisi ma̱tl ka̱ ka̱t atl gwisi mas. ");
INSERT INTO gyz_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yek Yesu li cina wu, yek dwa ɗe lop jon kopti, asa̱ na̱ma wulti to nya ka̱ɗe, <<Yesu yen ga̱ Dauda yen gonti ga̱na̱n ne!>> ");
INSERT INTO gyz_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ɗe Yesu te ka̱ lubii gon wu, yek dwami li tet malti. Yek Yesu wulsi ɗe, <<Ka̱a̱ kan ka̱ mbadl ɗe ba man ndokti gwaka̱n ma?>> Yek sa̱ wule, <<Yii, Bagaa, ka mani.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Yek Yesu ta̱n gwel gwasa̱n, yek ta̱ wule, <<Ha̱n ta̱ pikii na̱k gwe ka̱a̱ kan ka̱ mbadl wu,>> ");
INSERT INTO gyz_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɗe Yesu dlam nu wu, yek gwel gwasa̱n ɓuli. Yek ta̱ da̱lisi ka̱ng i'e, yek ta̱ wulsi ɗe, <<ba̱k dla̱mi ma̱lgon ilga̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ama yek sa̱ ngusi dla̱mti ilgwe ta̱ pa̱lisi wu ka̱ ka̱t atli mas. ");
INSERT INTO gyz_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ɗe sa̱ ɓa zak ba̱mi go, yek ma̱jon tulli ma̱lgon gwe ma̱zhe ngiɓit bi ka̱wu yek ba̱ta ga̱ɓa dani sowu. ");
INSERT INTO gyz_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu yilli ma̱zhesi ɗa̱ka̱ ma̱li ka̱wu, yek ma̱li njel ga̱ɓa. Yek ma̱jwe ni ka̱li wu ngip bi ka̱ ang, yek sa̱ wule, <<Ma̱ ɓo taɓa yenti ilgon nu ka̱ ma̱n Yisiraila so.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yek ma̱n Paresi wule, <<Na̱ iko ga̱ guu ma̱zhe ka̱n ta̱ na̱ma yilla̱t ma̱zhe ka.>> ");
INSERT INTO gyz_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yek Yesu ngusi ma̱tlti yek ta̱ ngash kiɗi ba̱n suk nak mili mas ata̱ na̱ma dla̱mti ta̱mi ga̱ɓa ka̱ lu motgaa jwasa̱n ten bi guu ga̱ Nya, ata̱ na̱ma ndokti ga̱ wunda̱l ji co mas suk ma̱jwe dli ta̱misi bi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ama ɗe ta̱ yen mbala̱n wonti mogaa wu, yek gonti gwasa̱n citi na̱k ɗe sa̱ na̱ma tlat bomti asa̱ cac-cal ɗa̱nka̱ wu, na̱k wule mba̱la jwe ma̱n kyo nisi ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yek ta̱ wul mil lishti jwas ɗe, <<Wotlti zhimi nali, ama ma̱n wotlti wo sa̱ wonti so. ");
INSERT INTO gyz_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ngema̱n Bagaa ga̱ wotlti zhimi ta̱s mba̱l ma̱n wotlti zhimi jon.>> ");
INSERT INTO gyz_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yek ta̱ mbe mil lishti jwas ɗe kutl cet lop ju yek ta̱ ba̱lsi iko ta̱s man yilla̱t ɗa̱ yeta̱l ka a ta̱s man ndokti ga̱ mas co suk ma̱jwe dli ta̱misi bi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Shin ji mil shinti ji botlisi ka̱ɗe ɗe, Siman gwe asa̱ mbet ɗe Biturus wu, suk yilka gwasi Andarawus, suk Yakubu yen ga̱ Zabadi suk yilka gwasi Yohana, ");
INSERT INTO gyz_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","suk Pilibus, suk Bartalomi, suk Tomas, suk Matiyu ma̱n kanti wulpi boo, suk Yakubu yen ga̱ Halpa, suk Tadiwus, ");
INSERT INTO gyz_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","suk Siman ma̱n Kan'ana suk Yehuda Iskariyoti ma̱lgwe ba̱l bi Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mil shinti ɗe Kutl cet ɗe lop jimi ka̱n Yesu shinsi, yek ta̱ lakisi icin kaal ɗe, <<Ba̱k la̱n mal ma̱jwe ba̱ Ma̱n Yehuda ka̱ sowu so, a ba̱k te ka̱ ba̱n Samariya so. ");
INSERT INTO gyz_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ama la̱n mal ma̱n Yisiraila jwe gil ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","La̱nni a ka̱a̱ hwi mbala̱n ɗe, <Kanti ga̱ Nya ɗe guu ga̱na̱n ɓal njaa.> ");
INSERT INTO gyz_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ndoka̱n ma̱jwe dli ta̱misi bi sowu, palla̱n ma̱jwe ma̱sh wu kaami, ndoka̱n ma̱n gita ka ta̱s pal ɗe ma̱n la̱shi da̱ska̱n, a ka̱a̱ yilli mbala̱n yeta̱l ka. Ten koo lu ka̱n sa̱ ba̱lkii, kii mago ba̱li ten koo lu pak. ");
INSERT INTO gyz_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ka̱a̱ ɓa li wu ba̱k kama̱n wulpi ga̱ zinariya sogo ga̱ zil ga̱lla sogo ga̱ hwol ga̱lla ka̱ aljihu gwaka̱n so. ");
INSERT INTO gyz_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A ba̱k kama̱n ngura sogo mayafi sogo luka̱l ɗe lop suk kapta̱lan suk sanda so. Ten ɗe ma̱n pa̱lti wul wo mbun ɗe ta̱s mbi ilga̱ nguki ka̱ pa̱lti wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","<<Mas ba̱n gwe ka̱li wu, ngo hwa mbala̱n ka̱ ba̱mi a ka̱a̱ te lubii ɗatka aka̱a̱ da̱m ka̱li hal se gas gwe ka̱ zak ba̱mi wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kume ka̱ te ka̱ lubiimi wugo a ka̱a̱ wulisi sallama. ");
INSERT INTO gyz_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kume hwa mbala̱n ni ka̱ lubiimi ta mbi sallama gwaka̱n. Kume hwa mbala̱n ni ka̱ lubiimi sowu, sallama gwaka̱n a pallikii. ");
INSERT INTO gyz_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mas ma̱lgwe nge kanti gwaka̱n sogo ma̱lgwe nge kumti ga̱ɓa gwaka̱n wu, a ka̱a̱ bat kushka gwe nikii ten asa̱n ka ɗe ka̱a̱ ɓa zak lubiimi wu, sogo ɗe ka̱a̱ ɓa zak ba̱mi wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gem amik ka hwik ge, ten gas kisti ga̱ɓa wo, Nya a dlwe mbadl ma̱n Sodom suk ma̱n Gomora man ma̱n ba̱n jwisi. ");
INSERT INTO gyz_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","<<Yekgu a na̱ma shinti gwaka̱n na̱k mba̱la jwe sa̱ te ka̱ dlo ga̱ kaɗila̱p wu. Yek laki yek a nikii ma hwiti ɗe ta̱k da̱ma̱n na̱ ɓotlka̱n na̱k wuci, ama da̱ma̱n ɗe ma̱jwe ba̱sa pi ɓarna sowu na̱k kulu. ");
INSERT INTO gyz_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","<<Pa̱n ɗem ɗem na̱ mbala̱n na̱k ɗe sa man ta̱lat gwaka̱n dlaboo, asa̱ ɓoki ka̱ lu motgaa gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","A sa ta̱lakii a cina ji bacina suk ma̱n kisti ga̱ɓa suk guu jwasa̱n ta̱ da̱misi ɗe sheda suk ma̱jwe ba̱ Ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kume sa̱ ta̱lakii malsi wu, ba̱ kangwe kaa ga̱ɓa wu sogo ilgwe kaa dla̱m wu hwotkii so, ten ɗe sa ba̱lkii ilgwe kaa dla̱m wu ka̱ sa'i gwisi, ");
INSERT INTO gyz_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","na̱k ɗe ba̱ kik ka ga̱ɓa so, ama Shishi ga̱ Aba gwaka̱n ka ga̱ɓa tumalkii wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Yilka a ba̱l bi ga̱ yilka gwasi asa̱ tloti, a aba a ba̱l bi ga̱ yen gwasi. Mil a tli ma̱n za̱t jwasa̱n gaa hal asa̱ laki ta̱s tlosi. ");
INSERT INTO gyz_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Mas mbala̱n a ngekii ten bi shin gini. Ama mas ma̱lgwe dlo mbadl hal pakti go tik ka mbi kisti. ");
INSERT INTO gyz_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kume sa̱ lakkii ka̱ bomti ka̱ ba̱n ga̱n wu, aɓa̱n te ka̱ ba̱mi ga̱n ka. Gem amik ka hwikii ge, kaa ɓo pak ma̱tlti ɗa̱nka̱ ba̱n ji Yisiraila ka̱ so Yen ga̱ Mbala̱n a pali. ");
INSERT INTO gyz_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Yen lishti nal man ma̱n lishti gwas so, a ba̱ zhel nal man baboo gwas so. ");
INSERT INTO gyz_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ai pa̱li wi, ɗe yen lishti da̱n na̱k ma̱n lishti gwasi, a zhel da̱n na̱k baboo gwas wu. Kume sa̱ mbe baboomi ɗe Ba'alzabul Guu Ma̱zhe go, ɗe yek sa mbe mil boo gwas ye? ");
INSERT INTO gyz_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<A nikii ma hwiti ba̱ ɓanti gwasa̱n cikii so, na̱k ɗe ba̱ ilgon ni ga̱ yitle gwe ba̱sa ɓul ka̱ sowu. A ba̱ ilgon ni ga̱ hwunda̱li ka, gwe ba̱ mbala̱n a yilli ten dii sowu. ");
INSERT INTO gyz_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ilgwe a hwikii ka̱ da̱mshal wu, dla̱ma̱n ka̱ dlo cin, ilgwe sa̱ hwikii ka̱ shu ka̱ng go, laka̱n icin gwas ten gaa bii. ");
INSERT INTO gyz_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ba̱k ɓanti ma̱jwe asa̱ tlo dli ga̱ mbala̱n ama ba̱sa man tlot ga̱ mbadl gwas sowu so. Ama ɓanti ma̱lgwe ta man tlot ga̱ dlisi ata̱ man lakti ga̱ mbadli ka̱ buu wutu wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ale asa̱ wul yadl ba̱lba̱l ɗe lop ka wulpi ga̱lla ɗe na̱m na̱? Ama ko gon gwasa̱n a nda ten atl ɗe ba̱na̱ yisti ga̱ Aba gwaka̱n gwe ni nya wu ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ai ko ta̱ ma̱dla̱n gaa gwaka̱n mago ga̱ dla̱mi ka̱n ni malti. ");
INSERT INTO gyz_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ten na̱k gwisi ai kaa mana̱n ba̱lba̱l wonti na̱ nalti.>> ");
INSERT INTO gyz_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Mas ma̱lgwe mbok ang ɗe ti wo gi ka̱n a cina ga̱ mbala̱n wu, ammago ba mbok ang tenti ɗe gini, a cina ɗa̱ Aba gi gwe ni to nya ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ama mas ma̱lgwe nge mbokti ang ɗe ti wo gi ka̱n mal mbala̱n go, ammago ba nge mbokti ang tenti ɗe gini a cina ɗa̱ Aba gi gwe ni to nya ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<Ba̱k da̱ma̱n gwa we ta̱mti da̱nti ka̱n a tulli ten dii atl so. Ta̱mti da̱mti ka̱n a tulli so dlanti ka̱n a tulli. ");
INSERT INTO gyz_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na̱k ɗe a tul ɗe << <ta mo yen mani suk aba gwasi, a mo yen kili suk ana gwasi, ta mo nkwe suk aka gwasi, ");
INSERT INTO gyz_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ma̱n boo ga̱ mbala̱n a da̱m ɗe yela̱n dlanti jwasi.> ");
INSERT INTO gyz_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","<<Mas ma̱lgwe lam aba gwasi sogo ana gwas mana̱n go ma̱li mbuk da̱nti ɗe ma̱n kopti gi so. A ma̱lgwe lam yen gwas ga̱ maani sogo ga̱ ma̱dli mana̱n go, ma̱li mbuk da̱nti ɗe ma̱n kopti gi so. ");
INSERT INTO gyz_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mas ma̱lgwe kan bomti na̱k guda̱l yencin gaa ta̱s koɓa̱n sowu, ma̱li mbuk da̱nti ɗe ma̱n kopti gi so. ");
INSERT INTO gyz_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mas ma̱lgwe lam mbadl gwas go, ta hwul na̱ mbadl gwasi, ama ma̱lgwe hwul na̱ mbadl gwas ten bi gi go ta mbi mbadl gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Mas ma̱lgwe kankii go ami ka̱n ta̱ kama̱nni. Ma̱lgwe kama̱n go, ma̱lgwe shina̱n wu ka̱n ta̱ kanti. ");
INSERT INTO gyz_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mas ma̱lgwe kan ma̱n dla̱mti ga̱ɓa ga̱ Nya ten ɗe ti wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱wu, ma̱li a mbi albarka gwe tumal ma̱n dla̱mti ga̱ɓe. A mas ma̱lgwe kan ma̱n pa̱lti wul ndakce ten ɗe ti wo ma̱n pa̱lti wul ndakce ka̱wu, ma̱li a mbi albarka tumal ma̱n pa̱lti wul ndakce. ");
INSERT INTO gyz_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A mas ma̱lgwe ba̱l ko ta̱ mbuka ze ɗe na̱m nak mil jin ten ɗe si wo mil lishti ji wu, Gem amik ka hwikii ge, ta sa ba ɓatlti so.>> ");
INSERT INTO gyz_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu paki hwit ga̱ɓa mil shinti jwas ji botli ɗe kutl cet lop ju wu, yek ta̱ zak luisi yek ci ta̱ cina na̱ za̱tgaa yek ta̱ te ka̱ ba̱n jwe ni ka̱ ka̱t atl ga̱ Galili wu ata̱ nisi ma mbokti ang suk lakti icin ten ga̱ɓa ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ka̱ sa'isi wo a Yohana ma̱n baptisma ni ga̱ le ka, ɗe ta̱ kum ilgwe Yesu na̱ma pa̱lti wu wu, yek ta̱ shin mil lishti jwas malti, ");
INSERT INTO gyz_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta̱s kum ga̱zi ɗe, <<Kik ɗe ma̱n tulti gwa, ko ta̱n zi gwel tulli ga̱ ma̱lgon?>> ");
INSERT INTO gyz_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yek Yesu wulsi, <<Lak hwi Yohana ilgwe ka̱a̱ kumi yek ka̱a̱ yeni wu. ");
INSERT INTO gyz_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dwa ɓa yenti lu, kulki ɓa li na̱ asa̱n, ma̱n gita na̱ma palti ɗe ma̱n la̱shi da̱ska̱n, ma̱jwe kum ka̱ng sowu ɓa kum ka̱ng, asa̱ na̱ma palla̱t ɗa̱ ma̱jwe ma̱sh wu kaami, a ma̱jwe ba̱ ilgon nisi ɗa̱ sowu na̱ma kumti ga̱ɓa ma̱n ta̱mti. ");
INSERT INTO gyz_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma̱n albarka ka̱ɗe ma̱lgwe ba̱ta kot asa̱n ten bi gi sowu.>> ");
INSERT INTO gyz_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ɗe mil shinti ji Yohana zigaa wu, yek Yesu njeli hwit ga̱ɓa wonti mbala̱n ten bi Yohana, yek ta̱ wulsi ɗe, <<Ɓohwe yek ka̱a̱ la yenti ka̱ me ye na̱? Tlal me jwe a yeta̱l wuni ka̱n ka̱a̱ sa yenti ya? ");
INSERT INTO gyz_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kume nuk sogo, to yek a ka̱a̱ sa yenti ye? Ka̱a̱ da̱ma̱n we ma̱lgon ka̱n kaa yenti na̱ mbuni luka̱l ten dli ya? Wowo, ma̱jwe asa̱ lak mbuni luka̱l jwo ka̱ dlaboo ga̱ guu ka̱n asa̱ da̱mi. ");
INSERT INTO gyz_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To, yek aka̱a̱ sa yenti ye? Ma̱n dla̱mti ga̱ɓa ga̱ ka̱n ka̱a̱ sa yenti gwas a? Yii, amik ka hwikii ge, ta̱ man ma̱n dla̱mti ga̱ɓa ga̱ Nya na̱ nalti pamma. ");
INSERT INTO gyz_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tik ɗe ma̱lgwe taka̱rda ga̱ɓa tenti ɗe, << <Yekgu ba lak yen shinti gini ta̱s tulik cina tik ɗe ma̱lgwe ta la̱ka̱mik lu wu.> ");
INSERT INTO gyz_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","<<Gem amik ka hwiti ge, ka̱ mas mbala̱n jwe modli wutsi go gon na̱k man Yohana ma̱n baptisma so. Ama ma̱lgwe tik ɗe nak'eni ka̱ guu ga̱ Nya wu nal man Yohana ma̱n baptisma. ");
INSERT INTO gyz_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tun tet ka̱ multi ji Yohana ma̱n baptisma hal yek la ase, guu ga̱ Nya na̱ma tlat bomti, a ma̱jwe nit ma ba̱lti bomti na̱ma lamti ta̱s kan guumi ka na̱ nda̱lti. ");
INSERT INTO gyz_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na̱k ɗe mas Mba̱t Ga̱ɓa ga̱ Musa suk lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya, dla̱m ga̱ɓa ten bi guumi a ba̱ Yohana ɓo tul sowu. ");
INSERT INTO gyz_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kume kaa kan ilgwe sa̱ dla̱m wu, Yohana ka̱ɗe Iliya gwe sa̱ dla̱m ga̱ɓa ɗe ta tullu. ");
INSERT INTO gyz_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mas ma̱lgwe ka̱ng kumti ga̱ɓa niɗɗa̱ wu ta̱s kumi.>> ");
INSERT INTO gyz_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","<<Na̱ yek ba cinga̱l mbala̱n ji se ye? Na̱k mil mbala̱n jwe ni ka̱ lu jetit gwasa̱n wu ka̱n sa̱ ni, jwe sa̱ na̱ma mbet ga̱ yela̱n jetit jwasa̱n asa̱ na̱ma wulti ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<< <ma̱ hotikii mba̱zhel yek ba̱ka̱a̱ dlal so, yek ma̱ wulikii koo multi ma̱shka̱n yek ba̱ka̱a̱ kul so.> ");
INSERT INTO gyz_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Na̱k ɗe Yohana tuli ba̱ta̱ nguki ata̱ tla i'e so yek sa̱ wule, <ma̱n yeta̱l ka̱ɗe ti.> ");
INSERT INTO gyz_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yek Yen ga̱ Mbala̱n tul wu ata̱ nguki ata̱ tlat, yek sa̱ wule, <Ma̱lga̱n nguk wul hwo ata̱ tla wul hwo, yela̱n ga̱ ma̱n kanti wulpi boo suk <<ma̱n pa̱lti byas wul.>> > Ama mas na̱ nu mbala̱n yen ɓotlka̱n yisti wul ga̱ Nya tumal pa̱lti wul gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yek ta̱ njeli da̱lti ka̱ng ba̱n jwe ta̱ pa̱l wul jwe a lak mbala̱n ten ngipti bi ang yek sa̱ nge cit atl gaa wu. ");
INSERT INTO gyz_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yek ta̱ wule, <<Kii wo wul cit gonti ka̱n ma̱n Korazin! Kii wo wul cit gonti ka̱n ma̱n Betsaida! Wul ngipti bi ang gwe sa̱ pa̱li malkii go, ɗe da a Taya suk Sidon ka̱n sa pa̱li go da sa ci atl gaa, asa̱ lak gus luka̱l asa̱ cat mba̱tla̱l ten gaa jwasa̱n asa̱ na̱ma ba̱lti bi. ");
INSERT INTO gyz_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","A nikii ma hwiti ɗe, ten gas kisti ga̱ɓa wo Nya a dlo mbadl na̱ ma̱n Taya suk Sidon mankii. ");
INSERT INTO gyz_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kii ma̱n Kaparnahum, ka̱a̱ da̱ma̱n gwa we sa tlilkii to nya ka? Wowo, ai ka̱ atl ka̱n sa sulkii, ka̱ lu da̱mti ga̱ ma̱jwe ma̱sh wu. Wul ngipti bi ang gwe sa̱ pa̱li ka̱ ba̱n gwaka̱n wu ka̱n sa pa̱li a Sodom go da a yi hal ase. ");
INSERT INTO gyz_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","A nikii ma hwiti ɗe ten cin kisti ga̱ɓa wo sa yen gonti ga̱ Sodom mankii.>> ");
INSERT INTO gyz_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ka̱ sa'i gwisi wo, yek Yesu wule, <<A pa̱l hwol tuk na̱ki Buka, Bagaa ga̱ dii atli suk dlo nya na̱k ɗe ka̱ hwunda̱li wul jwisi ma̱n ɓotlka̱n yisti wul suk ma̱jwe yisti nisi ɗa̱ wu, ama yek ka̱a̱ mboki ang mil mbala̱n dani. ");
INSERT INTO gyz_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yii Aba, ten na̱k gwisi ka̱ ta̱n yeniki. ");
INSERT INTO gyz_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","<<Mas wul wo Aba gi ka̱ ba̱la̱nni. Ma̱lgon yis Buke so se Yeni, a ba̱ ma̱lgon yis Yeni so se Buke suk ma̱lgwe yeni hwit bi ga̱ Buke wu. ");
INSERT INTO gyz_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","<<La̱n tet mala̱nni mas jwaka̱n, kii ɗe ka̱a̱ nak wi aka̱a̱ na̱ma tlat bomti na̱ wul ma̱n diɓa̱lti gaa wu, ami wo ba ba̱lkii shukti. ");
INSERT INTO gyz_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Kama̱n ilgwe a dla̱m wu na̱k gwe a tla kan guda̱l yencin ka̱ yal gwas wu, pa̱la̱n ilgwe a mbokikii ang dani wu, na̱k ɗe ami wo ma̱n kumti bi ka̱n a ma̱n ngusa̱lti gaa atl ka̱n, apaa ka̱a̱ mbi shukti ga̱ mbadl gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ten ɗe guda̱l yencin gini gwe yek ɗe ilgwe a dla̱m wu bom so, a ba̱ wul ji diɓa̱l so.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ka̱ multi jwisi ten gas Asabar cin shukti ga̱ ma̱n Yehuda, a Yesu suk mil lishti jwas na̱ma yilti ka̱ zhin alkama gon a kuza̱n ɓa tlo mil lishtisi, yek mil lishtisi njel celti gaa alkama asa̱ na̱ma ngukti. ");
INSERT INTO gyz_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ɗe ma̱n Paresi yensi wu, yek sa̱ wulti ɗe, <<Ɓo yen ilgwe mil lishti jwa na̱ma pa̱lti gas Asabar wu, ko ɗe Mba̱t Ga̱ɓa ga̱ Musa wule ba̱ mbala̱n pa̱li so wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yek Yesu ballisi ɗe, <<Ase, ka̱a̱ yena̱n ilgwe sa̱ lishi ten Dauda guu suk yela̱n la̱t jwasi ɗe kuza̱n ɓa tlosi wu sa? ");
INSERT INTO gyz_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ai, ta̱ te ka̱ lubii ga̱ Nya, yek sa̱ kan burodi gwe sa̱ zi ka̱wu yek sa̱ nguki, ko ɗe mbun ɗe ta̱ ma̱lgon nguk so se ma̱n Pa̱rismi na̱ ngusa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ko ka̱a̱ ɓo yeni ga̱ lishi ka̱ Mba̱t Ga̱ɓa ga̱ Musa ɗe, a ma̱n Pa̱ris pa̱l ilgwe ba̱ yek sowu ka̱ lubii ga̱ Nyami gas shukti, ama yek ba̱ ni ɗe we sa̱ cel mba̱t ga̱ɓe ka̱ so sa? ");
INSERT INTO gyz_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A nikii ma hwiti ɗe ma̱lgwe ta̱ nal man lubii ga̱ Nya wuggu. ");
INSERT INTO gyz_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Da kaa yis ilgwe laki yek ga̱ɓa ga̱ Nya wuli ɗe, <Yenti gonti ka̱n a lami ba̱ ɗe we takti wul so.> Da kaa yen ma̱n la̱shi pa̱lti ilgwe ba̱ yek sowu na̱ byas wul so. ");
INSERT INTO gyz_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ten ɗe Yen ga̱ Mbala̱n wo Bagaa ga̱ gas shukti ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu zak lwisi wugo, yek ta̱ te ka̱ lu motgaa gwasa̱n, ");
INSERT INTO gyz_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","a ma̱lgon ni ɗa ka̱li gwe ang gwas tla ka̱wu. Yek ma̱n Paresi ngem Yesu ɗe, <<Mbun ɗe ta̱ ndok mbala̱n gas shukti ya?>> Sa̱ ngem ti nu ta̱s man dopti gwas na̱ pa̱lti wul gas shukti. ");
INSERT INTO gyz_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu wulsi ɗe, <<Wok ka̱ kii gwe ɗe mba̱la a niɗɗa, a mba̱le nda ka̱ shu gas shukti a ba̱ta yilla̱t ɗa̱ka̱ shusi ka ten gas shukti so wo? ");
INSERT INTO gyz_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ai mbala̱n mana̱n mba̱la i'e? Ten na̱k gwisi ka̱n, sa̱ dla̱m ɗe ba̱ mbala̱n pa̱l hwa wul gas shukti so so.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yek ta̱ wul ma̱li ɗe, <<Tak ang gwa,>> yek ta̱ taki. Yek ami ndoki, yek pal na̱k gon wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yek ma̱n Paresi yili, yek sa̱ tak dla̱m ga̱ɓa ten kangwe sa pi asa̱ tlo Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ɗe Yesu yisi nu wugo, yek ta̱ zak lwisi, yek mbala̱n wonti kop kaal gwasi, yek ta̱ ndok mas ma̱n cwo jwe sa̱ ni ka̱si wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yek ta̱ hwisi ɗe ba̱s dla̱mi mbala̱n ilgon tenti so. ");
INSERT INTO gyz_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ili pi nu ten ɗe ta̱ ga̱ɓa gwe Nya dla̱mi tumal Ishaya wu njika̱n ɗa, ga̱ɓa gwe wule, ");
INSERT INTO gyz_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Zhel gi gwe a botli wu ka̱wu, a lamti a nima hwol tuk na̱ ti i'e. Ba njika̱nti na̱ Shishi gini ata̱ pa̱li mas ka̱t atl ji ba̱n kisti ga̱ɓa ga̱ gem. ");
INSERT INTO gyz_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ta dla̱k ga̱ɓa suk ma̱lgon so, a ba̱ta tlil yal gwas nya so, a ba̱sa kum yal gwas ɗa̱n ten tantu ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ta pak celti mamo gwe ɓal njaa ta̱ cel ka̱wu so, a ba̱ta mba̱sh pitila gwe ɓa lam ma̱shka̱n wu so. se ta̱ laki yek pa̱lti gem ci ba̱n. ");
INSERT INTO gyz_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ma̱jwe ba̱ Ma̱n Yehuda ka̱ sowu a zi mbadl tenti.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yek sa̱ tullit ma̱n ma̱zhe gon, ma̱li wo ta̱ ga̱ɓa dani so, a dwa ka̱n yek Yesu ndokti yek ta̱ man ga̱ɓa suk yenti lu. ");
INSERT INTO gyz_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yek ɓanti ci mas mbala̱n jwe ni ka̱li wu. Yek sa̱ wule, <<Ɓohwe, ale ma̱lga̱n go yen ga̱ Dauda ka̱n na̱?>> ");
INSERT INTO gyz_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ama ma̱n Paresi kumi nu wu, yek sa̱ wule, <<Ai na̱ iko ga̱ Ba'alzabul Guu Ma̱zhe ka̱n ma̱lga̱n na̱ma yilla̱t ga̱ yeta̱l ka.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na̱k ɗe Yesu yis daamti gwasa̱n wu, yek ta̱ wulsi ɗe, <<Mas guu gwe mbala̱n jwas tatl gaa gwasa̱n ɗe lop ten nget ga̱ yilkeni jwasa̱n go ba̱mi a dla̱l so. A mas ba̱n sogo boo gwe a mbala̱n jwasa̱n tatl gaa gwasa̱n ɗe lop ten nget ga̱ yilkeni jwasa̱n go, ba̱mi sogo boomi a dla̱l so pak. ");
INSERT INTO gyz_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kume Sheɗan ka̱ yilli Sheɗan go, ɗa̱ ni ka̱n ba̱n gwas a dlal gwi? Na̱k ɗe ta̱ na̱ma dlanti suk gaa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A kume na̱ iko ga̱ Ba'alzabul ka̱n a na̱ma yilla̱t ga̱ ma̱zhe ka̱wu, mil lishti jwaka̱n wo na̱ iko ga̱ wok asa̱ yilli ka̱ wo? Sik ka da̱mikii ɗe ma̱n kisti ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ama kume na̱ iko ga̱ Shishi ga̱ Nya ka̱n a na̱ma yilla̱t ma̱zhe ka̱ wu, Nya ɗe guu tulikii wi. ");
INSERT INTO gyz_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","<<Sogo ɗa̱ nii ka̱n ma̱lgon a man tet ka̱ lubii ga̱ nda̱li mbala̱n ata̱ yemit wul ka̱ gwi? Se ta̱ ɓal ma̱n lubiimi ka̱ paa ata̱ manit yemti wul ka. ");
INSERT INTO gyz_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","<<Ma̱lgwe ni suk ami sowu, ma̱li na̱ma nget gini. A ma̱lgwe zi ang ten moti sowu catti ka̱n ma̱li na̱ma catti ka. ");
INSERT INTO gyz_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yek laki yek a nikii ma hwiti ɗe, sa man taasti ga̱ mas byas wul suk ga̱ɓa mbulti Nya ga̱ mbala̱n ka, ama ma̱lgwe dla̱m byas ga̱ɓa ten Shishi ga̱ Nya go sa taasit ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mas ma̱lgwe dla̱m ga̱ɓa mbulti ten Yen ga̱ Mbala̱n go sa taasit ka. Ama mas ma̱lgwe dla̱m ga̱ɓa mbulti ten Shishi ga̱ Nya go sa taasit ka̱ so, ko na̱k ninge sogo cin ga̱ ayo. ");
INSERT INTO gyz_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<A hwa tlindi wut hwa yandli. Ama kume tlindi wo lili ka̱wu, a wut lili yandi. Tu ten wunda̱l ga̱ yandi ka̱n a mbala̱n yis wunda̱l ga̱ tlindi. ");
INSERT INTO gyz_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wonti woka̱nzi na̱kkii nini, ɗa̱ ni ka̱n kaa dla̱m hwa wul gwi? Ai ilgwe ni ka̱ mbadl wu ka̱n a bi dla̱mi. ");
INSERT INTO gyz_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hwa mbala̱n wo ata̱ yilli hwa wul tet ka̱ hwa wul gwe ta̱ zi ka̱ mbadl gwas wu, a byas mbala̱n wo ata̱ yilli byas wul tet ka̱ byas wul gwe ta̱ zi ka̱ mbadl gwas wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ama amik ka hwikii ge, mbala̱n a dla̱m mas byas ilgwe sa̱ dla̱m wu ten cin ga̱ ayo cin kisti ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sa kisik ga̱ɓa ten ilgwe ka̱ dla̱m wu, gon a ilgwe ka̱ dla̱m laki aka̱ ni ɗe ma̱n pa̱lti wul ndakce sogo ma̱n pa̱lti byas wul.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yek ma̱n Paresi suk ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa jon wulti ɗe, <<Ma̱n lishti, ma̱ na̱ma lamti ta̱k pa̱lini wul ngipti bi ang gwe a mbok ang ɗe ki wo sut mal Nya ka̱n ka̱ ni wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yek ta̱ ballisi ɗe, <<Byas mbala̱n ji ase ma̱n la̱shi pa̱lti gem na̱ma lamti yenti wul ngipti bi ang gwe a da̱misi ɗe lal wu, ama sa zisi lal gon so, seko wunda̱l lal ga̱ Yona ma̱n dla̱mti ga̱ɓa ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na̱k kangwe Yona pa̱l multi ɗe mekan cin suk gasi ka̱ tuk ga̱ bal kwes wu, na̱k gwisi ka̱n Yen ga̱ Mbala̱n a mul ɗe mekan cin suk gasi ga̱ leɓi ka̱ atli. ");
INSERT INTO gyz_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ten cin ga̱ ayo ma̱n Neniba a tlinya suk mbala̱n ji se ta̱s mbokisi ang ɗe sa̱ pa̱l ilgwe ba̱ yek sowu. Na̱k ɗe ma̱n Neniba ci atl gaa ten byas wul gwasa̱n na̱ kumti dla̱mti ga̱ɓa ga̱ Yona, ama ma̱lgwe nal man Yona wuggu! ");
INSERT INTO gyz_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ten cin ga̱ ayo Guu ga̱ Ma̱dli Sheba a tlinya suk mbala̱n ji se ta̱s mbokisi ang ɗe sa̱ pa̱l ilgwe ba̱ yek sowu. Ten ɗe ta̱ tli tet ka̱ dlenti lu ta̱s kati ka̱ng wunda̱l ga̱ ɓotlka̱n yisti ga̱ɓa ga̱ Sulemanu guu, ama ma̱lgwe nal man Sulemanu wuggu! ");
INSERT INTO gyz_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<Kume byas ma̱zhe yil ɗa̱ka̱ mbala̱n ka̱wu, ata̱ ngusi matlti ɗa̱nka̱ lu jwe ze ni ɗa̱ sowu ten ngot lu gwe ta shuk wu ama a ba̱ta mbi so. ");
INSERT INTO gyz_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Apaa ata̱ wul gaa gwas ɗe, <Ba pal teka̱ lubii gwe a zaki wu ka.> Kume ta̱ pali yek ta̱ mbi lubiimi go sa̱ taasi ka yek sa̱ la̱ka̱mi ka a ba̱ ma̱lgon ni giɓi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ta sak mbe byas ma̱zhe jwe ngalci manti wu ɗe nitgi teɗi, asa̱ sak da̱m giɓi. Ka̱ kaali wo a da̱mti ga̱ ma̱li lil man kangwe ta̱ni tek wu. Na̱k gwisi ka̱n a pi na̱ byas mbala̱n ji ase.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ata̱ yima hwit ga̱ɓa mbala̱n jwe mo gaa wu nu wugo, yek ana gwas suk yilkeni jwas tuli yek sa̱ dla̱l a deɓa̱l, sa̱ na̱ma lamti ta̱s ga̱ɓa sukti. ");
INSERT INTO gyz_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Yek ma̱lgon wulti ɗe, <<Ana gwa ka̱wu suk yilkeni jwa a deɓa̱l, sa̱ na̱ma lamti ta̱s ga̱ɓa sukki.>> ");
INSERT INTO gyz_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yek ta̱ ballit ɗe, <<Wok ɗe ana gi suk yilkeni ji wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yek ta̱ mbok ang ten mil lishti jwasi, yek ta̱ dla̱m ɗe, <<Ana gi suk yilkeni ji ka̱wu aɗe. ");
INSERT INTO gyz_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mas ma̱lgwe pa̱l ilgwe Aba gi gwe ni to nya ka̱wu lami wu, ma̱li ka̱ɗe ana gini a tik ɗe yilka gini ga̱ maani suk ga̱ modli.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yek Yesu yil ɗa̱ka̱ lubiimi ka ten cin jwisi, yek ta̱ sak da̱m ten bi bal ze. ");
INSERT INTO gyz_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Yek mbala̱n ngusi motgaa malti hal yek sa̱ luk lakti dlo se na̱k ta̱ sak te ka̱ jirgi ze yek ta̱ da̱m giɓi, a mbala̱mi ni ten bicikɗi. ");
INSERT INTO gyz_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yek ta̱ hwisi ga̱ɓa wonti na̱ cinga̱lti ga̱ɓa, yek ta̱ dla̱m ɗe, <<Ma̱n kolti zhin gon yil ɗe ta la ɓakti zhin gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ta̱ na̱ma catti wunda̱l gwas nugo, yek jon lok ten tantu yek yadl sak ɗaka̱mi ka. ");
INSERT INTO gyz_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yek wunda̱li jon lok ka̱ gacal, lu gwe ba̱ atl ni ka̱li i'e sowu. Yek te ba̱le-ba̱le na̱k ɗe atl nal ka̱li sowu. ");
INSERT INTO gyz_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ama ɗe cin mat wugo yek ilgwe sa̱ ɓak wu lada̱l ka yek nko ka, na̱k ɗe tla̱lki nisi ɗa i'e sowu. ");
INSERT INTO gyz_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wunda̱li jon lok ka̱ lu gwe il ni ka̱li wu, yek ili kiɗi yek ngip ilgwe sa̱ ɓak wu ka. ");
INSERT INTO gyz_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yek jon lok ka̱ hwa lu, yek ilgwe sa̱ ɓak wu pa̱l gwe i'e. Jon wo ɗe zaba̱l, jon wo ɗe kutl ɗe mukka a jon wo ɗe kutl ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma̱lgwe ka̱ng kumti niɗɗa̱ go, ta̱s kum ga̱ɓa ga̱mi.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yek mil lishti jwas tul malti yek sa̱ ngemti ɗe, <<Yek laki aka̱ hwi mbala̱n ga̱ɓa na̱ cinga̱lti ga̱ɓa ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yek ta̱ ballisi ɗe, <<Nya ba̱lkii yisti wul ga̱ hwunda̱li gwe ni guu ga̱ Nya wu, ama si wo sa̱ ba̱lsi so. ");
INSERT INTO gyz_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mas ma̱lgwe wul niɗɗa̱ go, sa mba̱lit ɗa, kangwe wul a nit ɗa nal wu. A mas ma̱lgwe wul niɗɗa̱ sowu, naki gwe niɗɗa̱ wu mago sa kamit ka. ");
INSERT INTO gyz_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ilgwe laki a dla̱mti wul na̱ cinga̱lti ga̱ɓa go yek ɗe, <<Ko ta̱s kusi, sa yenni so, Ko ta̱s ka̱t ka̱ng sa kumi, a ba̱sa yis gaami so. ");
INSERT INTO gyz_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Gem ilgwe Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m tensi wu njika̱n wi, ɗe ta̱ wule << <Kaa ngusi kumti ga̱ɓa, ama kaa yis gaa ga̱ ilgwe ka̱a̱ kumi wu so Kaa ngusi yenti wul, ama kaa yis ilgwe ka̱a̱ yenni wu so. ");
INSERT INTO gyz_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Na̱k ɗe mas jwasa̱n mbadl ka̱nga̱lisi ka̱wu, Ba̱ ka̱ng gwasa̱n a kum ga̱ɓa so, a yekgu sa̱ yitla gwel gwasa̱n ka̱wi. Sa lak yen wul na̱ gwel gwasa̱n, sa lak kum ga̱ɓa na̱ ka̱ng gwasa̱n. Ten ɗe ba̱ mbadl gwasa̱n yis gaami so hal asa̱ pal tet mala̱nni ten ɗe ta ndoksi.> ");
INSERT INTO gyz_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ama kii wo ma̱n albarka ka̱n, na̱k ɗe a gwel gwaka̱n yen wul a ka̱ng gwaka̱n kum ga̱ɓa wu. ");
INSERT INTO gyz_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gem amik ka hwikii ge, ma̱n dla̱mti ga̱ɓa ga̱ Nya suk mbala̱n ma̱n pa̱lti wul ndakce wonti lami ta̱s yen ilgwe ka̱a̱ na̱ma yenti wu, ama yek ba̱sa̱ yeni so. Asa̱ lami ɗe ta̱s kum ga̱ɓa gwe ka̱a̱ na̱ma kumti wu ama yek ba̱sa̱ kumi so. ");
INSERT INTO gyz_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Kati ka̱ng ilgwe cinga̱lti ga̱ɓa na̱ ma̱n ɓakti zhin na̱ma mbokti ang dani wu. ");
INSERT INTO gyz_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kume mbala̱n kum ga̱ɓa ten guumi yek ba̱ta̱ yis gaa ga̱ ilgwe ga̱ɓe dla̱m wu sowu, a sheɗan tulli ata̱ yem ga̱ɓe ɗa̱ka̱ mbadl ga̱ ma̱li ka. Gwisi ka̱ɗe wunda̱l gwe lok ten tantu wu. ");
INSERT INTO gyz_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wuda̱li gwe lok ka̱ gacal go, yek ɗe ma̱lgwe kum ga̱ɓe wugo ata̱ nda̱ki ba̱le-ba̱le na̱ hwol tuk wu. ");
INSERT INTO gyz_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ama na̱k ɗe ga̱ɓe lak kiɗi tla̱lki ka̱ mbadl gwas sowu, ba̱ ga̱ɓe a dla̱l ka̱ti so, ka̱ sa'i hwottidli suk bomti tul ten bi ga̱ɓe wugo ata̱ pal na̱ kaali ba̱le-ba̱le. ");
INSERT INTO gyz_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wuda̱li jwe lok ka̱ ili go, yek ɗe mbala̱n jwe asa̱ kum ga̱ɓe, ama a hwottidli ga̱ dii atl ge suk laamti wulpi laki a ba̱ ga̱ɓe a nali ta̱ wut mil so. ");
INSERT INTO gyz_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","A wunda̱li jwe lok ka̱ hwa lu go na̱k mbala̱n jwe sa̱ kum ga̱ɓe yek sa̱ yis gaami wu ka̱n. A ga̱ɓe laksi ten wutti mil jwe wonta̱t ji jon la zamba̱l, jon wo kutl ɗe nitgi, a jon wo kutl ɗe mekan.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yek Yesu cinga̱ltisi ga̱ɓa gon ɗa, yek ta̱ dla̱m ɗe, <<Guu ga̱ Nya wo na̱k ma̱lgon gwe ɓak hwa wunda̱l alkama ka̱ zhin gwas wu ka̱n, ");
INSERT INTO gyz_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","yek gas gon ka̱ gasi a mbala̱n ni atli yek yela̱n dlanti gwas sak ɓak byas wunda̱l alkama ka̱ zhimi yek paa ta̱ zigaa ilgon gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɗe hwa alkame tlal ɗe mbutl gaa wu, yek byas alkame tlal pak. ");
INSERT INTO gyz_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","<<Yek zhel ji ma̱li li tet malti yek sa̱ wulti ɗe, <Bagaa, a wule hwa wunda̱l alkama ka̱n ka̱ ɓak ka̱ zhin gwa wu na̱? Yek ɗa̱ nii ka̱n byas alkama yil tot giɓi gwi?> ");
INSERT INTO gyz_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","<<Yek ta̱ wulsi ɗe, <Yela̱n dlanti gi ka̱ sak ɓaki.> <<Yek zheli wulti ɗe, <Ka̱ lami ɗe ta̱n sak ndus byas alkame ɗa̱ka̱ zhimi ka?> ");
INSERT INTO gyz_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","<<Yek ta̱ wulsi ɗe, <Wowo, gon a ten ndusti byas alkame ka, aka̱a̱ lak ndus hwaɓi jon ka. ");
INSERT INTO gyz_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Zaka̱nsi ta̱s kiɗi ka̱ lu ɗe na̱m hal se ka̱ gisi. Kume sa'i tloti ɓal go ba hwi ma̱n tloti ɗe, tlo byas alkame ka aka̱a̱ ɓal na̱ zaa, gaami-gaami aka̱a̱ kweli ka, apaa ka̱a̱ mo hwa alkame a ka̱a̱ wut ka̱ nhu gini.> >> ");
INSERT INTO gyz_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yek Yesu po cinga̱lisi ga̱ɓa gon ɗa, yek ta̱ wulsi ɗe, <<Guu ga̱ Nya wo na̱k gwe mastat gwe ma̱lgon kaami yek ta̱ ɓak ka̱ zhin gwas wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ko ɗe gwe mastat wo nda nak'eni man mas gwe wullu, ama kume tlindi gwas nallu go a da̱m ɗe bal tlindi man mas naa tlindi a yatl lak bii gwasa̱n ka̱ mil ami.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yek ta̱ hwisi cinga̱lti ga̱ɓe gon ɗa yek ta̱ dla̱m ɗe, <<Guu ga̱ Nya wo na̱k yiis gwe kili gon lak ka̱ apti gal cinga̱lti ɗe mekan, yek ta̱ ngusi wuti hal yek yiisi ngashi wu ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu hwi mbala̱n wul jin mas na̱ cinga̱lti ga̱ɓa, ba̱ta dla̱misi ilgon ba cinga̱lti ga̱ɓa so. ");
INSERT INTO gyz_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na̱ nu ka̱n ta̱ njika̱n ilgwe Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu gwe wule, <<Ba ɓul bi gini a hwisi wul na̱ cinga̱lti ga̱ɓa, Ba hwisi wul jwe ni ga̱ hwunda̱li ka tun tet ten lakti zhila dii atl wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yek Yesu zak lu gwe wonti mbala̱mi ni wu, yek ta̱ te giɓ boo. Yek mil lishti jwas te malti yek sa̱ wulti ɗe, <<Ɓo hwini ilgwe cinga̱lti ga̱ɓa ten byas alkama ka̱ zhin na̱ma mbokti ang dani wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yek ta̱ wulsi ɗe, <<Yen ga̱ mbala̱n ka̱ɗe ma̱n ɓakti hwa wunda̱l alkama ka̱ zhimi, ");
INSERT INTO gyz_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","a dii atl ka̱ɗe zhimi, hwa wunda̱l alkame ka̱ɗe mil guumi, byas alkame ka̱ɗe mil ji Ma̱n Ngalci, ");
INSERT INTO gyz_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","a yela̱n dlantisi ɗe ta̱ ɓak byas alkame wu ka̱ɗe Ibilis. Wotlti zhimi ka̱ɗe pakti ga̱ dii atli, a man wotlti zhimi ka̱ɗe mil shinti ji Nya. ");
INSERT INTO gyz_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","<<Na̱k kangwe asa̱ mo byas alkama asa̱ kweli ka na̱ wutu wu, na̱k gwisi ka̱n sa pa̱li ka̱ pakti ga̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yen ga̱ Mbala̱n a shin mil shinti jwasi asa̱ mo wul jwe a lak mbala̱n ten pa̱lti byas wul wu suk mas ma̱n pa̱lti ngalci, asa̱ mbolsi ɗa̱ka̱ guu gwas ka. ");
INSERT INTO gyz_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A paa asa̱ wutsi su ka̱ buu wutu ma̱n cicit ka, ka̱li ka̱n sa kuli asa̱ na̱ma asti ang bi. ");
INSERT INTO gyz_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ka̱ sa'i gwisi ka̱n ma̱n pa̱lti wul ndakce a cil na̱k cin, ka̱ guu ga̱ Aba gwasa̱n. Ta̱ mas ma̱n ka̱ng kumti kum ga̱ɓa ga̱n. ");
INSERT INTO gyz_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Guu ga̱ Nya wo na̱k zok wul gwe sa̱ hwunda̱li ka ka̱ zhin wu ka̱n, gwe ɗe ma̱lgon te dani wu yek ta̱ po hwunda̱li ka̱ ɗa. Ten bi hwol tuk gwasi yek ta̱ wul mas wul jwas ka yek ta̱ sak wul zhimi na̱ wulpi.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Guu ga̱ Nya wo na̱k wule ma̱n wulti wul ka, gwe na̱ma ngot zok mbuni ye, ");
INSERT INTO gyz_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","yek ma̱li mbi zok ye gon ma̱n mbunti i'e, yek ta̱ sak wul mas wul jwas ka yek paa ta̱ wul yesi na̱ wulpisi. ");
INSERT INTO gyz_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Guu ga̱ Nya wo na̱k wul dipti ze gwe sa̱ lak ka̱ bingi ze yek dop wunda̱l kwes wonti, ");
INSERT INTO gyz_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ɗe njika̱n wugo, yek ma̱n dopti kwesi dla̱k wul dipti zesi to ten bicikɗi ka. Yek sa̱ da̱m na̱ zhila yek sa̱ ɗaka̱m hwa kwesi yek sa̱ mosi ka̱ ga̱ɗa, ama byas kwesi wo yek sa̱ wut ka. ");
INSERT INTO gyz_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Na̱k gwisi ka̱n sa pa̱li ten pakti ga̱ dii atli, mil shinti ji Nya a tuli asa̱ hwul dlo ga̱ ma̱n pa̱lti wul ndakce suk ma̱n ngalci ");
INSERT INTO gyz_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","asa̱ wut ma̱n ngalci ka̱ buu wutu ma̱n ciciti, ka̱li ka̱n sa kuli asa̱ na̱ma asti ang bi.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yek Yesu ngemsi ɗe, <<Ka̱a̱ yis gaa ga̱ wul jin mas a?>> Yek sa̱ ballit ɗe, <<Yii Bagaa.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yek ta̱ wulsi ɗe, <<Ten na̱k gwisi ka̱n, ma̱n lishti Mba̱t Ga̱ɓa ga̱ Musa gwe da̱m ɗe yen lishti ka̱ guu ga̱ Nya go, na̱k ba boo gwe ata̱ yilli pyal wul suk gus wul tot ka̱ bii wul ang gwas wu ka̱n ta̱ni.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ɗe ta̱ pak dla̱mti cinga̱lti ga̱ɓa jin wugo, yek ta̱ zak luisi. ");
INSERT INTO gyz_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yek ta̱ pal ba̱n gwasi yek ta̱ njeli mbokti ang mbala̱n ten ga̱ɓa ga̱ Nya ka̱ lu motgaa gwasa̱n yek mbala̱mi ngip bi ka̱ ang. Yek sa̱ ngusi dla̱mti ɗe, <<A ako ka̱n ma̱lga̱n mbi wunda̱l ɓotlka̱n yis wul jin, suk iko pa̱lti wul ngipti bi ang ga̱n ko? ");
INSERT INTO gyz_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ale tik ɗe yen ga̱ kapinta wu na̱? ale gasa̱l gwas ka̱ɗe Maryam na̱? A yilkeni jwas ka̱ɗe ka̱a̱ Yakubu, suk Yusupu, suk Siman suk Yehuda na̱? ");
INSERT INTO gyz_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A yilkeni jwas ji ma̱dli mago sa̱ na̱n ɗe sa? Tet ako ka̱n ma̱lga̱n mbi mas wul jimi ko?>> ");
INSERT INTO gyz_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yek mbadl lilisi na̱ ti. Yek Yesu wulsi ɗe, <<Asa̱ ba̱l nalti ma̱n dla̱mti ga̱ɓa ga̱ Nya ko ako, ama ka̱ ba̱n gwasi suk lubii gwas wo ba̱sa ba̱lti nalti so.>> ");
INSERT INTO gyz_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na̱k ɗe sa̱ nga̱ssi tenti sowu, yek ba̱ta̱ pa̱l wul ngipti bi ang ka̱li i'e so. ");
INSERT INTO gyz_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ka̱ multi jwisi yek Hiridus Antipas guu kum ga̱ɓa ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Yek ta̱ wul ma̱jwe asa̱ pa̱lit wullu ɗe, <<Ma̱lga̱n co Yohana ma̱n baptisma ka̱n Nya palla̱t kaami! Yek laki yek iko pa̱lti wul ngipti bi ang nit ɗa na̱k gwisi.>> ");
INSERT INTO gyz_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tek go a Hiridus laki yek sa̱ dop Yohana yek sa̱ ɓalti, yek sa̱ let ka ten bi ga̱ Hirodiya, kili ga̱ Pilip yilka gwas wi. ");
INSERT INTO gyz_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Na̱k ɗe a Yohana kul hwi Hiridus ɗe, <<Mbun ɗe ta̱k kan Hirodiya ɗe kili gwa so!>> ");
INSERT INTO gyz_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridus lami ɗe ta̱s tlo Yohana ka, ama yek ɓanti ga̱ mbala̱n citi, na̱k ɗe sa̱ kan ɗe Yohana wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ɗe ti wu. ");
INSERT INTO gyz_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ama yek cin za̱t ga̱ Hiridus balla̱t tet wu go, yek yen kili ga̱ Hirodiya dlal a cina ga̱ ma̱nda̱ki jwe tul ka̱ biki hwol tukisi, yek dlaltisi ta̱mit ɗa i'e ");
INSERT INTO gyz_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","yek Hiridus mo ga̱ɓa na̱ Nya yek ta̱ pa̱lit alkawol ɗe ta balti mas ilgwe ta̱ ngemi wu. ");
INSERT INTO gyz_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yek ana gwas hwit ilgwe ta ngemi wu, yek yen kilisi wul Hiridus ɗe, <<Ba̱la̱n gaa ga̱ Yohana ma̱n Baptisma aɗe ka̱ gali nige-nige!>> ");
INSERT INTO gyz_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yek ga̱ɓe hwot guumi i'e, ama na̱k ɗe ta̱ mo ga̱ɓa na̱ Nya, a ma̱nda̱ki jwas ka̱ ju ka̱li wu, yek ta̱ dla̱m ɗe ta̱ ba̱lti ilgwe ta̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Yek ta̱ shinlu yek sa̱ kotli gaa Yohana ka ata̱ ni ga̱ le ka, ");
INSERT INTO gyz_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","yek sa̱ tulli gaami ka̱ gali yek sa̱ ba̱l yen kilisi, yek ta̱ ta̱le gasa̱l gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yek mil lishti ji Yohana sak kan dli gwasi yek sa̱ lepti ka, Yek pa sa̱ sak hwi Yesu ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ɗe Yesu kum ilgwe pi wugo, yek ta̱ te ka̱ jirgi ze, yek ta̱ li ka̱ lu gwe mbala̱n ni ɗa̱ sowu ta̱s da̱m na̱ ngus ɗa. Ama yek mbala̱mi kum lu gwe ta̱ ni wu, Yek sa̱ zak ba̱n jwasa̱n yek sa̱ kopti ten asa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ɗe Yesu yil ɗa̱ka̱ jirgi ze ka̱ wu, yek ta̱ yen motgaa ga̱ wonti mbala̱n, yek ta̱ yen gonti jwasa̱n yek ta̱ ndok ma̱jwe dli ta̱misi bi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Sukti pi wugo, yek mil lishti jwas tul malti yek sa̱ wulti ɗe, <<Sukti ka̱ ɓali, a lu ge go lubii ni ɗa̱ ka̱li so. Palli bi mbala̱mi ta̱s li ɗa̱nka̱ mil ba̱n jwe ni njaa wu ka, ta̱s wuli gaa gwasa̱n ilga̱ nguki ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yek Yesu wulsi ɗe, <<Ni ngetli ɗe ta̱s zigaa so. Ba̱la̱nsi ilgon ta̱s nguki.>> ");
INSERT INTO gyz_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yek sa̱ ballit ɗe, <<Ilgon nini ang aɗe so, se nak ba̱redi ɗe namtan suk kwes ɗe lop.>> ");
INSERT INTO gyz_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yek ta̱ wulsi ɗe, <<Ta̱leni nini teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yek ta̱ wul mbala̱mi ɗe ta̱s da̱m na̱ zhila ten me. Yek ta̱ kan ba̱redi ɗe namtami suk kwes ɗe loɓi yek ta̱ lak gaa nya, yek ta̱ pa̱l hwol tuk na̱ Nya yek ta̱ cac-cal ba̱redisi. Yek pa ta̱ ba̱l mil lishti jwasi yek sa̱ ngusi ba̱lti mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Yek mas mbala̱mi nguki yek kumsi. Yek mil lishtisi mo losa̱li jwe sa wu, hal yek njika̱n ga̱ɗa ɗe kutl cet lop. ");
INSERT INTO gyz_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wonta̱t ga̱ ma̱jwe nguk wu, pa̱l mani ɗe zangu namtan ba̱n na̱ modli suk mil mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Sa̱ na̱ma pakti, yek Yesu laki yek mil lishti jwas te ka̱ jirgi ze yek sa̱ ndet cina ten la̱t tu ten ka̱ti gon ga̱ zesi, a ti gaa gwas wo ta̱ yima palla̱t bi motgaa wonti mbala̱mi. ");
INSERT INTO gyz_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ta̱ pallisi bi paki wu yek ta̱ to ten za̱nda̱l tla̱nda̱l ta̱s ngem Nya. Hal yek sukti luk pi ata̱ yi ka̱li ti na̱ ngusi. ");
INSERT INTO gyz_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ama a jirgi ɓal teka̱ dlo bal ze ka, a kapsi ze na̱ma jekti ga̱ jirgi ɗa̱n ka na̱k ɗe yeta̱l na̱ma wulti tet tu cina ga̱ jirgi wu. ");
INSERT INTO gyz_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yek Yesu li malsi na̱ asa̱n ten gaa zesi ka̱ bultlwe ga̱ cina. ");
INSERT INTO gyz_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mil lishtisi yenti ten la̱t na̱ asa̱n ten gaa ze wugo yek ɓanti cisi. Yek sa̱ wuli ɗe, <<Gu co lul ka̱n!>> Yek sa̱ lak yal na̱ ɓanti. ");
INSERT INTO gyz_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yek Yesu ga̱ɓesi yek ta̱ wulsi ɗe, <<Ba̱ ilgon hwotkii so! Ami ka̱n, ba̱ ɓanti cikii so!>> ");
INSERT INTO gyz_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yek Biturus wulti ɗe, <<Bagaa, kume kik go, wula̱n ɗe ta li tet malki ten gaa zesi.>> ");
INSERT INTO gyz_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yek ta̱ wulti ɗe, <<Li teɗi.>> Yek Biturus yil ɗa̱ka̱ jirgi ka, yek ta̱ njel la̱t mal Yesu ten gaa zesi. ");
INSERT INTO gyz_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ama ɗe Biturus kum nda̱lti ga̱ yeta̱li wu, yek ɓanti njel cit gwasi yek ta̱ njel sut ga̱z gaa ze. Ɗe ta̱ ɓa su ga̱z gaa ze wu, yek ta̱ lak yal, yek ta̱ wuli ɗe, <<Kisa̱n ne, Bagaa!>> ");
INSERT INTO gyz_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yek Yesu tak ang gwasi ba̱le-ba̱le yek ta̱ ngiɓit ang yek ta̱ da̱lti toɗi, yek ta̱ wulti ɗe, <<Ki ɗe ba̱ nga̱sti ten Nya gwa nda̱l sowu, yek lakki ten celti ka̱ mbadl ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yek sa̱ te ka̱ jirgi mas jwasa̱n, yek paa yeta̱li mul atli. ");
INSERT INTO gyz_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yek ma̱jwe sa̱ ni ka̱ jirgi wu ngusit atli, asa̱ na̱ma wulti ɗe, <<Gem ka̱n, yen ga̱ Nya ka̱ɗe ki!>> ");
INSERT INTO gyz_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɗe sa̱ ɗakci bal zesi wugo yek sa̱ yil to ten bi cikɗi gwe ni njaa mal atl ga̱ Genisarat wu ka. ");
INSERT INTO gyz_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma̱n ba̱mi yisi ɗe Yesu ka̱ɗe gwisi wu, yek sa̱ shini lu mas mbala̱n jwasa̱n, yek mbala̱mi tulli mas mbala̱n jwasa̱n jwe dli ta̱misi bi sowu malti, ");
INSERT INTO gyz_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","yek sa̱ ngemti ɗe ta̱s nak ta̱n ko ta̱ bi luka̱l gwas ne, yek mas ma̱jwe ta̱ni wu mbi ndokti. ");
INSERT INTO gyz_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yek ma̱n Paresi suk ma̱n yisti mba̱t ga̱ɓa ga̱ Musa jon tet Wurshelima tul mal Yesu yek sa̱ ngemti ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Yek laki a mil lishti jwa nge kopti wul jwe a kiɗi jina̱n pa̱li wu ye? Ɗe si wo ba̱sa pol ang ka̱ pa so, ɗe sa̱ ɓa nguk wullu!>> ");
INSERT INTO gyz_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yek Yesu wulsi ɗe, <<A kii, yek laki ɗe aka̱a̱ cel mba̱t ga̱ɓa ga̱ Nya ka, ten bi pa̱lti wul jwaka̱n ye? ");
INSERT INTO gyz_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ai Nya dla̱ma̱n ɗe, <Ta̱ mbala̱n ba̱l nalti aba suk ana gwasi,> a <ma̱lgwe byal aba, sogo ana gwas go, ngetli ka̱n ta̱ tlot ka.> ");
INSERT INTO gyz_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ama kii wo aka̱a̱ mboki ang mbala̱n ɗe, kume ilgon ni mbala̱n ɗa gwe ta ba̱l aba sogo ana gwasi ten ɗe ta̱s zisi ang wu ni ma̱li ngetli ɗe ta̱s zisi ang so, ten ɗe ta manisi wulti ɗe <Mas ilgwe gwe a lamikii ba̱lti go, a pa̱l alkawol wi ɗe ba ba̱l Nya.> ");
INSERT INTO gyz_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Na̱k gwisi mbok ang ɗe, po yi ma̱li ngetli ɗe ta̱s ba̱l nalti aba suk ana gwas so. Na̱ pa̱lti wul gwaka̱n na̱k gwisi ka̱n ka̱a̱ palli ga̱ɓa ga̱ Nya ten koo lu. ");
INSERT INTO gyz_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kii ma̱n pa̱lti riya! Ilgwe Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m tenkii ni ndakce gwe wule! ");
INSERT INTO gyz_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<< <Na̱ kul bi ka̱n a mbala̱n jin ba̱la̱n nalti, ama mbadl jwasa̱n dlenti suk ami. ");
INSERT INTO gyz_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ten koo lu ka̱n asa̱ ngusi atli, asa mbok ang ten mba̱t ga̱ɓa ga̱ mbala̱n ɗe ga̱ɓa ga̱ Nya.>>> ");
INSERT INTO gyz_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yek Yesu mbe mbala̱mi yek ta̱ wulsi ɗe, <<Kuma̱n ga̱ɓa ga̱n aka̱a̱ yis gaami! ");
INSERT INTO gyz_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ilgwe a su tu ka̱ bi wu ka̱ɗe ma̱n lilti ga̱ mbala̱n ka̱ so, ama ilgwe a yil tot tu ka̱ bi ga̱ mbala̱n wu ka̱ɗe ma̱n lilti gwas ka.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yek mil lishtisi tul malti yek sa̱ wulti ɗe, <<Ama ka̱ yisi ɗe ilgwe ka̱ dla̱m wu nda ma̱n Paresi mbadl a?>> ");
INSERT INTO gyz_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yek ta̱ ballisi ɗe, <<Mas ilgwe ba̱ Aba gini, gwe ni Nya wu ka̱ ɓak sogo sa tus ɗa̱ ten zhila gwas ka. ");
INSERT INTO gyz_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Hwula̱nkii suksi, si wo dwa ka̱n, ama asa̱ nde dwa cina. A kume dwa ka̱ nde dwa cina go, mas jwasa̱n sa lok ka̱ shu.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yek Biturus wulti ɗe, <<Yillini gaa ga̱ cinga̱lti ga̱ɓa gwisi.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yek Yesu wulsi ɗe, <<Ase hal ninge ka̱a̱ po yisa̱n gaami sa? ");
INSERT INTO gyz_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ka̱a̱ ɓo yisi ɗe mas ilgwe a su tu ka̱ bi mbala̱n go ka̱ tuk ka̱n a su, apaa ka̱ kaali wo a yil ɗa̱ka̱ ma̱li ka̱sa? ");
INSERT INTO gyz_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ama wul jwe a yil tot ka̱ bi go, wul jwe nit ka̱ mbadl wu ka̱n, a yek ɗe ma̱n lilti ga̱ mbala̱n ka. ");
INSERT INTO gyz_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ten ɗe tot ka̱ mbadl ka̱n a byas daamti ngusi yilti. Wuda̱l ji tlot mbala̱n, suk lamti pa̱t pa̱la̱n, suk mas byas pa̱t suk modli, suk pa̱t muka̱l, suk shelti lal mbala̱n gaa, suk lil shin mbala̱n ka. ");
INSERT INTO gyz_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wul jimi ka̱ɗe ma̱n lilti ga̱ mbala̱n ka, ama ngukti wul na̱ duu ang wo lil mbala̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɗe Yesu zak luisi wu yek ta̱ li ka̱ ka̱t atl ga̱ Taya suk Sidon. ");
INSERT INTO gyz_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Yek kili Kan'ana gon gwe ni ka̱li wu tul malti yek ta̱ tlil yal nya yek ta̱ wulti ɗe, <<Yen gonti gi ne, Bagaa yen ga̱ Dauda! Ma̱zhe jon na̱ma nolti ga̱ yen gini i'e.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ama yek ba̱ Yesu wulti ɗe ilgon so. Yek mil lishti jwas tul malti yek sa̱ ngemti yek sa̱ wulti ɗe, <<Mbol kili ga̱n ne, ten ɗe ta̱ na̱ma kopti ata̱ na̱ma hwotti ga̱na̱n na̱ tlilti yal nya.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yek ta̱ wulsi ɗe, <<Mal mba̱la ji Yisiraila jwe gil ju na̱ ngusa̱n ka̱n sa̱ shina̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yek kilisi sak ngus na̱ gahwula̱n a cina gwasi, yek ta̱ wulti ɗe, <<Zi ang ne, Bagaa!>> ");
INSERT INTO gyz_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yek ta̱ wulti ɗe, <<Mbun ɗe ta kan ilga̱ nguki ga̱ mil lubii a ba̱l kaɗi so.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yek kilisi wulti ɗe, <<Go nu ka̱n, ama ai kaɗi nguk ilga̱ nguki gwe a yili baboo gwas ɗa̱ ang ka a nda sut ga̱s tebul wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yek Yesu wulti ɗe, <<Kili mbala̱n, nga̱ski ten Nya nda̱li! Ka̱ mbi ilgwe ka̱ ngemi wu wi.>> Yek yen ga̱ kilisi mbi ndokti na̱ dla̱mti gwas na̱k gwisi. ");
INSERT INTO gyz_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tet ka̱li go, yek Yesu koɓi tu bal ze ga̱ Galili. Yek ta̱ to ten tla̱nda̱l yek ta̱ da̱m na̱ zhila. ");
INSERT INTO gyz_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mbala̱n wonti tul malti, sa̱ tulit kulki, suk dwa suk ma̱n gita suk bebe, suk naami jon wonti yek sa̱ wutsi atl a cina gwasi yek ta̱ ndoksi. ");
INSERT INTO gyz_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yek mbala̱mi ngip bi ang ɗe sa̱ yen bebe ten ga̱ɓa, a ma̱n gita ndok wi, a kulki ɓa li na̱ asa̱n, suk dwa ten yenti lu wu. Yek sa̱ ta̱s Nya ga̱ ma̱n Yisiraila. ");
INSERT INTO gyz_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yek Yesu mbe mil lishti jwasi yek ta̱ wulsi ɗe, <<A na̱ma yenti gonti ga̱ mbala̱n jin, sa̱ mul ɗe mekan aɗe mala̱n wi a ba̱sa̱ nguk ilgon so. A lamisi palla̱t bi asa̱ yi kuza̱mi so, ten ɗe gon asa̱ ngusi pa̱lti gwel ma̱shka̱n ten tantu na̱ kuza̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yek mil lishtisi wulti ɗe, <<Ako ka̱n ma mbi ilga̱ nguki gwe a kum wonti mbala̱n jin ka̱ me ga̱n ko?>> ");
INSERT INTO gyz_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yek ta̱ ngemsi ɗe, <<Ba̱redi ɗe na̱mi ka̱ nikii ang?>> Yek sa̱ wulti ɗe, <<Ɗe mukka suk nak kwes jon.>> ");
INSERT INTO gyz_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yek ta̱ wul wonti mbala̱mi ɗe ta̱s da̱m atli. ");
INSERT INTO gyz_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yek ta̱ kan ba̱redi ɗe mukke suk kwesisi yek ta̱ pa̱l hwol tuk na̱ Nya, yek ta̱ cac-cali yek ta̱ ba̱l mil lishtisi yek sa̱ ba̱l mbala̱mi. ");
INSERT INTO gyz_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Yek ko wokko nguki yek kumti. Ka̱ kaali yek mil lishtisi yem ga̱ɗa ɗe mukka ga̱ losa̱li gwe mbala̱mi zaki wu. ");
INSERT INTO gyz_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wonta̱t ga̱ mani jwe nguk go sa̱ la zangu ɗe namtan ban na̱ modli suk mil mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu palli bi wonti mbala̱mi wugo yek ta̱ te ka̱ jirgi ze yek ta̱ li ten ka̱t atl ga̱ Magadan. ");
INSERT INTO gyz_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yek ma̱n Paresi suk ma̱n Saduki jon tul mal Yesu, yek sa̱ ngemti ɗe ta̱s mbokisi ang ten lal gwe a mbok ang ɗe ti wo sut mal nya ka̱n ta̱ ni wu. ");
INSERT INTO gyz_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yek ta̱ nda̱kisi ɗe, <<Kume cin ɓa ndabi go, aka̱a̱ wule <Ayo go lu a ta̱mi, dlo nya ka̱ zwila̱n wu.> ");
INSERT INTO gyz_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A kume ka̱a̱ yen lu zwila̱n ka, ɗe nyaze na̱ma tlil tot na̱ gasi wo wugo aka̱a̱ wule, <Ase go ze a nda.> Ka̱a̱ yis wul jwe a pi ka̱ dlo nya wu, ama yek ba̱ka̱a̱ yis gaa ga̱ lal ji multi ga̱ se so. ");
INSERT INTO gyz_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mbala̱n ji se wo byasi suk ma̱n la̱shi ngipti alkawol ka̱n, sa̱ na̱ma lamti ɗe ta̱s yen lali, ama ba̱sa mbokisi ang ten lal gon so se wunda̱l ga̱ Yona wu.>> Yek Yesu zaksi yek ta̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sa̱ ɗakci bal zesi tu te duk wu, ase mil lishti jwas lak ma̱sa̱n yek ba̱sa̱ kan ba̱redi so. ");
INSERT INTO gyz_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu wulsi ɗe, <<Pa̱n ɗem-ɗem na̱ yiis ga̱ ma̱n Paresi suk ma̱n Saduki.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yek sa̱ ngusi ga̱ɓa ka̱ dlo gwasa̱n yek sa̱ dla̱m ɗe, <<Ilgwe laki yek ta̱ dla̱m nugo, na̱kka̱n ma̱ kama̱n ba̱redi ang so.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu yis ilgwe sa̱ na̱ma dla̱mti wu, yek ta̱ wulsi ɗe, <<Kii ɗe ba̱ nga̱sti ten Nya gwaka̱n nda̱l sowu! Yek laki yek ka̱a̱ na̱ma ga̱ɓa ten bi la̱shi ba̱redi ye? ");
INSERT INTO gyz_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Hal ase ka̱a̱ ɓo yis gaami sa? Kangwe a cal ba̱redi ɗe namtan yek mbala̱n ɗe zangu namtan nguk wu ma̱snikii ka̱wu nwa? Ga̱ɗa ɗe na̱mi ka̱n ka̱a̱ me ga̱ ilgwe ɗe sa wu? ");
INSERT INTO gyz_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sogo ba̱redi ɗe nitgi gwe a ba̱l mbala̱n zangu ɗe wupsi yek sa̱ nguk wu. Ga̱ɗa ɗe na̱mi ka̱n ka̱a̱ me ga̱ ilgwe ɗe sa wu? ");
INSERT INTO gyz_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yek laki ɗe yek ba̱ka̱a̱ yisi ɗe ten bi ba̱redi ka̱n a nikii ma ga̱ɓa so ye? Ai ilgwe a nikii ma hwiti go yek ɗe ta̱k hwula̱nkii na̱ yiis ga̱ ma̱n Paresi suk ma̱n Saduki.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yek pa sa̱ yis gaami ɗe ten bi yiis gwe asa̱ laki ba̱redi wu ka̱n ta̱ nisi ma ga̱ɓa so, ten ɗe ta̱s hwul gaa gwasa̱n na̱ mbok ang ga̱ ma̱n Paresi suk ma̱n Saduki ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ɗe Yesu mbuki ten ka̱t atl ga̱ Kaisariya Pilibi wu, yek ta̱ ngem mil lishti jwas ɗe, <<Ɗe wok a mbala̱n mbe yen ga̱ mbala̱n wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yek sa̱ wulti ɗe, <<A jon dla̱m ɗe Yohana ma̱n baptisma, jon wo asa̱ dla̱m ɗe Iliya, a jon wo asa̱ dla̱m ɗe Irimiya sogo gon ka̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yek ta̱ ngemsi ɗe, <<A kii pa, ka̱ yenti gwaka̱n wo, wok ɗe ami wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Yek Biturus wulti ɗe, <<Kik ɗe Almasihu yen Nya gwe ni kaami wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yek Yesu wulti ɗe, <<Ki wo ma̱n albarka ka̱n, Siman yen ga̱ Yona. Ten ɗe mbala̱n ka̱ mbokik ang ten na̱k gwisi so, Aba gi gwe ta̱ ni to nya ka̱wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ama amik ka hwik ge, kik ɗe Biturus a ten ye ga̱n ka̱n ba kin motgaa ga̱ ma̱n kopti gini, iko ga̱ ma̱shka̱n a ci ba̱n ten mot gaami so. ");
INSERT INTO gyz_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ba ba̱lki wul ɓulti dlabii ga̱ guu ga̱ Nya, mas ilgwe ka̱ ɓal ka ten dii atl go ta̱ ni ɗe ilgwe sa̱ ɓal ka a nya wu. A mas ilgwe ka̱ pa̱tl ka ten dii atl go ta̱ ni ɗe ilgwe sa̱ pa̱tl ka a nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yek Yesu da̱li ka̱ng mil lishti jwas i'e ɗe ba̱s hwi mbala̱n ɗe tik ɗe Almasihu so. ");
INSERT INTO gyz_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kan tet ka̱ sa'i gwisi, yek Yesu nde hwit ga̱ɓa mil lishti jwas ten ɗe ngetli ka̱n ta̱s su Wurshelima ta̱s tla wonti bomti ka̱ ang ga̱ bacina ji ma̱n Yehuda suk kiɗi ma̱n Pa̱ris suk ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa, hal asa̱ tlot ka, ama ten cin na mekan wo ta pal kaami. ");
INSERT INTO gyz_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Yek Biturus mbet te malka̱mi ka yek ta̱ matlti yek ta̱ wulti ɗe, <<Nya a kan so, go ma̱n pa̱t tenki ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yek Yesu bala̱t tet tu malti yek ta̱ wulti ɗe, <<Hwulki suk ami Sheɗan. Ka laka̱n ten pa̱lti byas wul, na̱k ɗe pa̱lti wul ga̱ Nya nik mbadl so, se ga̱ mbala̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yek Yesu wul mil lishti jwas ɗe, <<Mas ma̱lgwe a koɓa̱n go, ta̱s nge gaa gwasi ata̱ kan guda̱l yencin ɓakti gaa gwasi ata̱ koɓa̱nni. ");
INSERT INTO gyz_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mas ma̱lgwe na̱ma lamti kisti mbadl gwas go ta mbi mbadli so, ama ma̱lgwe hwul na̱ mbadl gwas ten bi go ta mbi mbadli. ");
INSERT INTO gyz_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Yek ɗe ta̱mti ga̱ mbala̱n ye, ɗe ta̱ mbi mas wul ga̱ dii atli ge, ama yek ta̱ hwul suk mbadl gwas wu? Sogo yek mbala̱n a man ba̱lti ka̱ lal ga̱ mbadl gwas ye? ");
INSERT INTO gyz_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yen ga̱ Mbala̱n a ya tul suk mil shinti jwasi ka̱ nalti ga̱ Aba gwasi ata̱ ɓatl mas mbala̱n, ta ba̱l ko wokko ten pa̱lti wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gem, amik ka hwikii ge, ma̱jon ni ɗa a nya aɗe ka̱ kii, ma̱jwe sa ma̱sh so se sa̱ yen palti ga̱ Yen ga̱ Mbala̱n ka̱ iko guu gwas wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kaal ɗa̱ multi ɗe mukka, yek Yesu kan Biturus suk Yakubu suk yilka ga̱ Yukubu gwe asa̱ mbet ɗe Yohana wu, yek sa̱ to ka̱ tlal tla̱nda̱l gon si na̱ ngusa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sa̱ ni nu go, yek dli gwas balla̱ti asa̱ na̱ma yenti. Yek cina gwel gwas cil ka na̱k wule cin, yek luka̱l gwas hwoli ka pat. ");
INSERT INTO gyz_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ba̱le-ba̱le yek ka̱a̱ Musa suk Iliya yilisi asa̱ na̱ma ga̱ɓa suk Yesu. ");
INSERT INTO gyz_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yek Biturus wulti ɗe, <<Bagaa, mbun wi na̱k ɗe ma̱ ni ɗa aɗe wu, kume ta̱mik ɗa̱ go, ma lak bii bukka ɗe mekan, ɗe na̱m wo gwa, gon wo ga̱ Musa a gon wo ga̱ Iliya.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","A ta̱ yima ga̱ɓa nugo, yek kaluntun ma̱n cilti gon yitlasi ka, yek sa̱ kum yal ga̱ɓa gon a giɓi ten wulti ɗe, <<Ga̱n go yen gi ka̱n a lamti, a na̱ma kumti ta̱mti gwas i'e. Katiti ka̱ng!>> ");
INSERT INTO gyz_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mil lishtisi kum ga̱ɓa gwisi wugo, yek sa̱ lok te atl ka na̱ ɓanti. ");
INSERT INTO gyz_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Yek Yesu ta̱nsi yek ta̱ wulsi ɗe, <<Tla̱nnya ka, ba̱ ɓanti cikii so.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Sa̱ tlil gaa nya wugo, yek ba̱sa̱ po yen ma̱lgon so, se Yesu na̱ ngusi. ");
INSERT INTO gyz_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Sa̱ ɓa yil sut ɗa̱ka̱ tla̱nda̱li ka̱wu, yek Yesu hwisi ɗe, <<Ba̱k hwi ma̱lgon ilgwe ka̱a̱ yeni wu so, se Yen ga̱ Mbala̱n pal kaami tot ɗa̱ka̱ gazukɗi pa.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yek mil lishtisi wulti ɗe, <<Yek laki a ma̱n yisti mba̱t ga̱ɓa ga̱ Musa dla̱m ɗe se Iliya tul pa ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yek Yesu wulsi ɗe, <<Gem, Iliya a tuli ta̱s la̱ka̱n wul mas ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ama amik ka hwikii ge Iliya tul wi yek ba̱ mbala̱n yisti so, yek sa̱ pa̱lit ilgwe sa̱ lami wu. A na̱k gwisi ka̱n Yen ga̱ Mbala̱n a tla bomti ka̱ ang gwasa̱n pak.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yek mil lishtisi yisi ɗe ta̱ nisi ma ga̱ɓa ten Yohana ma̱n Baptisma. ");
INSERT INTO gyz_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sa̱ pal tet ka̱ mbala̱n wugo, yek ma̱lgon li tet ma̱l Yesu yek ta̱ ngus a cina ɗatka. ");
INSERT INTO gyz_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Yek ta̱ wulti ɗe, <<Bagaa yen gonti ga̱ yen gi ne. Cwo maparpaɗa nima cit gwasi ata̱ na̱ma tlat bomti i'e. A cwoɓi ngusi lakti gwas ka̱ wutu sogo ka̱ ze. ");
INSERT INTO gyz_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A ta̱la̱t mal mil lishti jwa, ama yek ba̱sa̱ man ndokti gwas so.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yek Yesu wulsi ɗe, <<Kii mbala̱n ji se, ma̱jwe ba̱sa̱ ba̱l gem na̱ Nya sowu, asa̱ ka̱nga̱l mbadl jwasa̱n ka̱ wu! Hal a gasi ka̱n ba pita da̱mti sukkii gwi? Hal a gasi ka̱n ba ngusi dlot mbadl na̱kii gwi? Ta̱leni nini yeni teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yek Yesu matl ma̱zhesi yek ta̱ yil ɗa̱ka̱ yeni ka yek ta̱ ndoki ka̱li-ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yek mil lishtisi li mal Yesu ka̱ sa'i gwe mbala̱n po yi malti sowu yek sa̱ ngemti ɗe, <<Yek laki yek ba̱ma̱ man yilla̱t ga̱ ma̱zhesi ka̱ so ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yek Yesu wulsi ɗe, <<Ilgwe laki go, yek ɗe ka̱a̱ nga̱skii ten Nya i'e so. Gem amik ka hwikii ge, ɗe kume nga̱sti ten Nya gwaka̱n nal na̱k gwe mastat go, kaa mani aka̱a̱ wul tla̱nda̱l ge ɗe, <Tli ɗa̱ ɗe ka ta̱k li te du,> a tla̱nda̱li li ka̱li. A ba̱ ilgon a kankii gaa so.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wuda̱li go ba̱sa yil so se na̱ ngemti Nya suk pa̱lti ka̱lka̱ze ze. ");
INSERT INTO gyz_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mil lishtisi mogaa ka̱ lu ɗe na̱m a Galili wu, yek ta̱ wulsi ɗe, <<Sa ba̱l bi ga̱ Yen ga̱ Mbala̱n ka̱ ang ga̱ mbala̱n ");
INSERT INTO gyz_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","sa tloti. Ama ten cin na mekan wo ta palla̱t kaami.>> Yek ili hwot mil lishtisi i'e. ");
INSERT INTO gyz_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu suk mil shinti jwas mbuki ba̱n Kaparnahum wugo yek ma̱n kanti wulpi boo lubii ga̱ Nya tul mal Biturus Yek sa̱ wulti ɗe, <<Ma̱n lishti gwaka̱n ɓatla̱n wulpi boo lubii ga̱ Nya sa?>> ");
INSERT INTO gyz_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Yek Biturus wulsi ɗe, <<Ata̱ ɓatli.>> Biturus te gibboo wugo yek Yesu wulti ɗe, <<Siman, yek ɗe daamti gwa ye? Ka̱ ɓa yeni go tet mal ka̱ wokko ka̱n a guu ji ma̱n dii atl ga̱n kan wulpi boo wo na̱? Tet mal mbala̱n ji ba̱mi nwa ko mal ma̱nda̱ki?>> ");
INSERT INTO gyz_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Yek Biturus wulti ɗe, <<Tet mal ma̱nda̱ki.>> Yek Yesu wulti ɗe, <<Gwisi na̱ma mbokti ang ɗe ba̱ mil ji ba̱mi a ɓatl so.>> ");
INSERT INTO gyz_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","<<Ama ten ɗe ma lak ndesi mbadli, su bal ze ta̱k suk lak wul dopti kwesi. Ɓul bi ga̱ kwes gwe ka doɓi na na̱m wu, ka mbi wulpi zil ga̱lla gwe a mbuk ɓatlti wulpi boo gi suk gwa wu. A pa ka̱ kan wulpi aka̱ ɓatlsi na̱ nali.>> ");
INSERT INTO gyz_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ka̱ sa'i gwisi wo yek mil lishtisi li mal Yesu yek sa̱ ngemti ɗe, <<Wok ɗe kakshe ka̱ guu ga̱ Nya wo na̱?>> ");
INSERT INTO gyz_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yek ta̱ mbe na̱k'en yen gon tet ɗe ta̱s dla̱l ka̱ dlo gwasa̱n, ");
INSERT INTO gyz_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","yek ta̱ wulsi ɗe, <<Amik ka hwikii ge, ɗe kume ka̱a̱ palli gwaka̱n pal na̱k mil mbala̱n sowu, kaa mbi guu ga̱ Nya so. ");
INSERT INTO gyz_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ten na̱k gwisi ka̱n mas, ma̱lgwe palli gaa gwas na̱k nak'en yen ga̱n go ma̱li ka̱ɗe kakshe ka̱ guu ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","<<Mas ma̱lgwe kan yen mbala̱n na̱k ga̱n ka̱ shin gi go ami ka̱n ta̱ kama̱nni. ");
INSERT INTO gyz_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","<<Ama mas ma̱lgwe lak ɗe na̱m ka̱ mil jin ɗe sa̱ nga̱ssi tena̱n wu ten pa̱lti byas wul go, a maniti ɗe ta̱s ɓalit ye na̱kti hwo yal asa̱ lakti ka̱ bal ze. ");
INSERT INTO gyz_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","<<Mbala̱n ji dii atl ge wo wul cit gonti ka̱n, na̱ wul wonti jwe a lak mbala̱n ten pa̱lti byas wul wu! Ni ngetli ɗe ta̱ wul jwe a lak mbala̱n ten pa̱lti byas wul wu tuli, ama ma̱lgwe tulli wuli go wul cit gonti ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kume a ang gwa sogo asa̱n gwa laki a ka̱ pa̱l byas wullu, kotl ka aka̱ lak ka. A manik ɗe ta̱k mbi mbadl ma̱n la̱shi pakti na̱ ang ɗe na̱m sogo asa̱n ɗe na̱m, ɗa̱ gwe ta̱s lakki ka̱ buu wutu gwe ba̱ a mba̱shdli so na̱ ang jwa suk asa̱n jwa wu. ");
INSERT INTO gyz_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A kume a gwel gwa lakki ten pa̱lti byas wullu, yilli ka aka̱ lak ka! A manik ɗe ta̱k mbi mbadl ma̱n la̱shi pakti na̱ gwel ɗe na̱m, ɗa̱ gwe ta̱s lakki ka̱ buu wutu na̱ gwel jwa wu. ");
INSERT INTO gyz_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Kii dai pa̱n ɗem-ɗem ba̱k mbula̱n gon ka̱ nak mil jin so. A nikii ma hwiti, mil shinti ji Nya jwe sa̱ na̱ma ɓa̱tti gwasa̱n wu ni to nya ka a cina ga̱ Aba gini cin suk gasi. ");
INSERT INTO gyz_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yen ga̱ Mbala̱n tul ɗe ta̱s kis ma̱jwe gillu. ");
INSERT INTO gyz_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","<<Nik ka̱a̱ yeni gwi na̱? Kume mba̱la zamba̱l ɗe na̱m ni ma̱n kyo ɗa yek gon gwasa̱n gil ka̱ go, ta zaka̱n naami ɗe kutl topsi na̱ topsi ju ten pa̱t kyo ata̱ sa ngot ga̱ mba̱le gwe gillu sa? ");
INSERT INTO gyz_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gem, amik ka hwikii ge, kume ta̱ mbit ɗu go, a pa̱l hwol tuk na̱ ti man ɗe kutl topsi na̱ topsi jwe ba̱sa̱ gillit ka̱ so ju. ");
INSERT INTO gyz_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na̱k gwisi ka̱n Aba gwaka̱n gwe ni to nya ka̱wu lami ɗe ta̱ ɗe na̱m ka̱ nak mil jin gil ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<Kume yilka gwa pa̱lik byas wul wu, li malti aka̱ hwit byas ilgwe ta̱ pa̱lik wu, kii sukti kii na̱ ngweka̱n. Kume ta̱ katik ka̱n wu ka̱ palli yilka gwa ten tantu wi. ");
INSERT INTO gyz_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ama kume ta̱ nge kumti gwa wu, ngo mbala̱n ɗe na̱m sogo mbala̱n ɗe lop aka̱ li malti, kangwe asa̱ wule ɗe, <Ten ga̱ɓa ga̱ mbala̱n ɗe lop sogo ɗe mekan ka̱n asa̱ dla̱lli mas ga̱ɓa.> ");
INSERT INTO gyz_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kume ta̱ nge kumti gwasa̱n wu, hwi motgaa ga̱ ma̱n kopti. A kume ta̱ nge kumti ga̱ motgaa ga̱ ma̱n kopti go, aka̱ palla̱t na̱k ma̱lgwe ɓo yis Nya sowu sogo na̱k ma̱n pa̱lti byas wul gwe nge cit atl gaa wu. ");
INSERT INTO gyz_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","<<Amik ka hwikii ge, mas ilgwe ka̱ ɓal ka ten dii atl go ta̱ ni ɗe ilgwe sa̱ ɓal ka a nya wu. A mas ilgwe ka̱ pa̱tl ka ten dii atl go ta̱ ni ɗe ilgwe sa̱ pa̱tl ka a nya wu. ");
INSERT INTO gyz_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","<<Amik ka hwikii wu ɗa̱ɗe, kume mbala̱n ɗe lop ka̱ kii ten dii atl dla̱lli ga̱ɓa ɗe sa ngem ilgon go, Aba gi ɗe ta̱ ni nya wu a pa̱lisi. ");
INSERT INTO gyz_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ten ɗe, kume mbala̱n ɗe lop sogo ɗe mekan mogaa na̱ shin gi go, ani suksi.>> ");
INSERT INTO gyz_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yek Biturus li mal Yesu yek ta̱ ngemti ɗe, <<Bagaa asa̱mi ɗe na̱mi ka̱n yilka gi a pa̱li byas wul a taasit ka̱ gwi? Asa̱mi ɗe nitgi ya?>> ");
INSERT INTO gyz_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yek Yesu ballit ɗe, <<Amik ka hwikii ge asa̱mi ɗe nitgi tokte ka̱ so, ama se la asa̱mi ɗe kutl nitgi ɗe nitgi. ");
INSERT INTO gyz_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","<<Guu ga̱ Nya wo na̱k wule guu gwe lami ɗe, ta̱s dla̱m wul ang gwas gwe ni a ang ga̱ zhel jwas wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ɗe guumi ɓa dla̱m go, yek sa̱ tullit ma̱lgon gwe ta̱ na̱ma kopti gwas wulpi zil ga̱lla wonti gwe ɗe hal ma̱li a ma̱shi a ba̱ta man ɓatlti sowu. ");
INSERT INTO gyz_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Na̱k ɗe ma̱li a man ɓatlti gwas sowu, yek guumi dla̱m ɗe ta̱ wulti ka suk kili gwasi suk mil jwasi suk mas ilgwe niɗɗa̱ wu ta̱ ɓatlti wulpi gwas ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","<<Yek zheli ngus na̱ gahwula̱n a cina gwasi yek ta̱ ngemti yek wulti ɗe, <Dlo mbadl na̱ ami, ba ɓatlki mas wulpi gwa.> ");
INSERT INTO gyz_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Yek guumi yen gonti gwasi yek ta̱ taasi ma̱li mas duli ka yek ta̱ zakti. ");
INSERT INTO gyz_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","<<Ama yek na̱ yilti ga̱ zhel gwisi yek ta̱ mo suk yela̱n pa̱lti wul gwas gon, gwe ta̱ na̱ma kopti gwas wulpi zil ga̱lla gwe ba̱ nal sowu, yek ta̱ ngiɓit yal luka̱l ata̱ nitma wulti ɗe, <Ɓatla̱n wulpi gwe a na̱ma kopti gwa wu.> ");
INSERT INTO gyz_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","<<Yek zheli gwisi ngus na̱ gahwula̱n yek ta̱ ngemti ɗe, <Dlo mbadl na̱ ami, ba ɓatlki wulpi gwa!> ");
INSERT INTO gyz_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","<<Ama yek zheli nge kumti gwasi yek ta̱ sak let ka ka̱ lu leti, ten ɗe se ta̱ ɓatlti wulpi gwasi mas. ");
INSERT INTO gyz_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Naa zhel ji ma̱li yen ilgwe pi wu wugo yek mbadl jwasa̱n lili, yek sa̱ sak hwi guu gwasa̱mi mas ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","<<Yek guumi mbe zheli malti, yek ta̱ wulti ɗe, <Ki wo byas zhel ka̱n.> A taasik mas dul gwe a na̱ma kopti gwa wu ka na̱k ɗe ka̱ ngema̱n ɗe ta taasik ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ki wo mbuna̱n ɗe ta̱k yen gonti ga̱ yilka gwa zhel na̱k gwe a yen gonti gwa wu sa? ");
INSERT INTO gyz_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mbadl lili guumi i'e yek ta̱ laki yek sa̱ nol zheli ka, se na̱k ta̱ ɓatlti mas dul gwe nit gaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","<<Nu ka̱n Aba gi gwe ni nya wu a pa̱li ko wokko ka̱ kii ɗe ba̱ta taasi yilkeni jwas byas wul ka̱ sowu.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ɗe Yesu pak dla̱mti wul jimi wugo, yek ta̱ zak ka̱t atl ga̱ Galili yek ta̱ li ka̱t atl ga̱ Yehudiya, lu gwe ni tu te duk ɗa̱ dla̱lka Yodan wu. ");
INSERT INTO gyz_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yek mbala̱n wonti kopti yek ta̱ ndok ma̱n cwo ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yek ma̱n Paresi jon tul malti ɗe sa cinga̱lti na̱ kumti ga̱s wul, yek sa̱ wulti ɗe, <<Ko Mba̱t Ga̱ɓe kama̱n ɗe ta̱ mbala̱n zak kili gwas ten bi ilgon na̱?>> ");
INSERT INTO gyz_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yek ta̱ ballisi ɗe, <<Ase ka̱a̱ ɓo yenni ga̱ lishi ɗe, <Ten ndat zhile wo, ti ɗe ta̱ pa̱l mas wul go, ta̱ pa̱lsi ba mani suk kili mbala̱n.> ");
INSERT INTO gyz_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yek ta̱ wule, <Ten na̱k gwisi ka̱n, a ba mani zak aba suk ana gwasi ata̱ ngatli kili gwas dli, a si ɗe loɓi da̱m ɗe dli ɗe na̱m> ");
INSERT INTO gyz_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yek laki yek ba̱sa po yi ɗe mbala̱n ɗe lop so, ama ɗe na̱m ka̱ ɓali. Ten na̱k gwisi ka̱n, mas ilgwe Nya palli ɗe na̱m wu, ba̱ ma̱lgon hwuli so.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Yek sa̱ ngemti ɗe, <<Ɗe nuk go yek laki yek Musa dla̱m ɗe kume mbala̱n a zak kili gwas go ta̱s ba̱lti lishti zakti ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yek Yesu wulsi ɗe, <<Nda̱lli gaa gwaka̱n ka̱ laki yek Musa kamikii ɗe ta̱k zaka̱n modli jwaka̱n. Ama tet ten ndat zhile wo nuk ni so. ");
INSERT INTO gyz_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Amik ka hwikii wu ɗa̱ɗa, mas ma̱lgwe zak kili gwasi yek ta̱ hap zopsi a ba̱ ten bi pa̱t-pa̱la̱n ka̱ sowu, ma̱li na̱ma pa̱t pa̱la̱n sukti.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yek mil shinti jwas wulti ɗe, <<Ɗe kume nu ka̱n ni ka̱ dlo ga̱ kos suk kili gwas go, la̱shi hapti man hapti.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yek Yesu ballisi ɗe, <<Mas mbala̱n ka kan ga̱ɓa ga̱n so, se ko ma̱jwe Nya kamisi wu. ");
INSERT INTO gyz_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mbala̱mi jon wo sa̱ laksi go maani ka̱ so, a jon wo pa̱lti ka̱n mbala̱n pa̱lisi na̱k gwisi, a jon wo sik nge hapti ten bi guu ga̱ Nya. Mas ma̱lgwe a man kanti ga̱ɓa ga̱n go ta̱s kaami.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yek sa̱ tulli mil mbala̱n mal Yesu ta̱s wutisi ang gaa ata̱ ngemisi Nya. Ama yek mil lishti jwas matl ma̱jwe tulla̱si wu. ");
INSERT INTO gyz_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yek Yesu wulsi ɗe, <<Zaka̱n nak mil mbala̱n ta̱s tul mala̱nni ba̱k mbola̱nsi ka̱ so, ten ɗe guu ga̱ Nya wo ga̱ wunda̱l gwasa̱n ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ta̱ wutisi ang albarka gaa wugo yek ta̱ zak luisi. ");
INSERT INTO gyz_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Sa̱ ni nugo yek ma̱lgon tul mal Yesu yek ta̱ wulti ɗe, <<Ma̱n lishti, wunda̱l hwa wul gwik ni ngetli ɗe ta pa̱li a mbi mbadl gwe ba̱ a paki sowu gwi?>> ");
INSERT INTO gyz_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yek Yesu ballit ɗe, <<Yek laki ɗe ka̱ ngema̱n ten bi hwa wul ye? Ai Nya na̱ ngus ka̱ɗe hwa wul! Kume ka̱ na̱ma lamti ta̱k mbi mbadl gwe ba̱ a paki sowu go kop mba̱t ga̱ɓa ju.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yek ma̱li ngem Yesu ɗe, <<Mba̱t ga̱ɓe jwi?>> Yek ta̱ ballit ɗe, << <Tlo mbala̱n so, pi suk kili ga̱ ma̱lgon so, pi muka̱l so, sheli lal ma̱lgon gaa so, ");
INSERT INTO gyz_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ba̱l nalti aba suk ana gwa,> aka̱ <lam yela̱n da̱mti gwa na̱k gwe ka̱ lam gaa gwa wu.> >> ");
INSERT INTO gyz_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Yek samali wul Yesu ɗe, <<A kop mba̱t ga̱ɓa jwisi wi, yek yi kaal ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yek Yesu wulti ɗe, <<Kume ka̱ na̱ma lamti ta̱k da̱m njikmi go, sak wul mas wul jwa ka, aka̱ ba̱l wulpi ma̱n la̱shi wul ka da̱m ɗe ma̱n wul ang a nya. Apaa aka̱ lak koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Yen samali kumi nu wugo yek ta̱ zigaa na̱ lilti mbadli, na̱k ɗe ti wo ma̱n wul ang i'e ka̱ɗe ti wu. ");
INSERT INTO gyz_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yek Yesu wul mil lishti jwas ɗe, <<Gem amik ka hwikii ge, a bom i'e ta̱ ma̱n wul ang te ka̱ guu ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ta ɓo hwikii ɗa̱ɗa, gara ta̱ rakumi koɓi tu ka̱ shu alipla ɗa̱ gwe ta̱ ma̱n wul ang te ka̱ Nya ɗe guu wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Mil lishtisi kumi nu wugo yek ngip ang bi i'e yek sa̱ ngemti ɗe, <<Ɗe nu ka̱ go, yek wok ka mbi kisti wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yek Yesu wutisi gwel yek ta̱ dla̱m ɗe, <<Mal mbala̱n wo, go ma̱n pa̱t ka̱ so! Ama mal Nya wo ko yek ke a man pa̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Yek Biturus ballit ɗe, <<Mi wo ma̱ zak wul wi mas ten bi kopti gwa! Yek ɗe ilgwe ma mbi wu ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yek Yesu wulsi ɗe, <<Gem amik ka hwikii ge, ka̱ multi ma̱n tulti ka̱ sa'i gwe Yen ga̱ Mbala̱n a da̱m ten gobdlan guu gwas ma̱n nalti wu, kii ɗe ka̱a̱ koɓa̱n wu mago kaa da̱m ten gobdlan kutl cet lop, aka̱a̱ kissi ga̱ɓa ma̱n boo ɗe kutl ɗe lop ji Yisiraila ju. ");
INSERT INTO gyz_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Apaa mas ma̱lgwe zak lubii jwasi sogo yilkeni jwasi sogo aba sogo ana sogo mil mbala̱n sogo zhin gwasa̱n ten bi gi wu mbi asa̱mi ɗe zaba̱l ga̱ ilgwe sa̱ zaki wu. Asa mbi mbadl gwe ba̱ a paki sowu pak. ");
INSERT INTO gyz_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ama mbala̱n wonti jwe sik ɗe ji cina ju a pal ɗe ma̱ji tukaali, a ma̱jwe sik ɗe ji tukaal ju a pal ɗe ma̱ji cina. ");
INSERT INTO gyz_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Guu ga̱ Nya wo na̱k ma̱n zhin gon gwe yil na̱ gasi ta̱s ngo ma̱jwe a kolit zhin ka̱ zhin inabi gwas wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta̱ pa̱l ga̱m suksi ten ɗe ta ɓatlsi na̱ wulpi dinari ɗe na̱m ɗe na̱m ten ndat cin gwasa̱n, yek ta̱ laksi ka̱ zhin inabi gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","<<Yek ta̱ yili ka̱ sa'i ga̱lla ɗe topsi, yek ta̱ yen mbala̱mi jon ten da̱mti ten koo lu ka̱ lu wulti wul ka. ");
INSERT INTO gyz_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Yek ta̱ wulsi ɗe, <Kii mago sak kola̱n zhin ka̱ zhin inabi gini, ba ɓatlkii kangwe mbun ɗe ta ɓatl wu.> ");
INSERT INTO gyz_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yek sa̱ li ka̱ zhimi. <<Yek ta̱ yil ɗa ka̱ dlo cin suk ka̱ sa'i ga̱lla ɗe mekan ka̱ sukti yek ta̱ po pa̱li na̱k gwisi ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ta̱ po yil ɗa sa'i ga̱lla ɗe namtan ka̱ sukti yek ta̱ po yen ma̱jon ɗa a nya ba̱sa̱ na̱ma pa̱lti ilgon so, yek ta̱ wulsi ɗe, <Yek laki yek ka̱a̱ nda cin ten koo lu nu ye?> >> ");
INSERT INTO gyz_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","<<Yek sa̱ ballit ɗe, <Ilgwe laki go, na̱kka̱n ma̱lgwe ilgwe ma pa̱li wu so.> <<Yek ta̱ wulsi ɗe, <Kii mago sak kola̱n zhin ka̱ zhin ɗaaka.> ");
INSERT INTO gyz_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","<<Cin nda bii wugo yek ma̱n zhimi wul ma̱lgwe ata̱ zit ang ten yenti zhimi wu ɗe, <Mbe ma̱n kolti zhin ju ta̱k ɓatlsi. Nda zhila ɓatlisi na̱ ma̱jwe pak kaal ten la̱t ka̱ zhimi wu, aka̱ paki na̱ ma̱jwe nda cina ten la̱t wu.> ");
INSERT INTO gyz_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","<<Yek ma̱jwe sa̱ mbesi ka̱ sa'i ga̱lla ɗe namtan wu tulli, yek sa̱ ba̱lsi ko wokko wulpi ndat cin. ");
INSERT INTO gyz_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yek ma̱jwe li tet ka̱ zhimi cina wu da̱m gwa we sa ba̱lsi wulpi ta̱ man ko wokko. Ama yek sa̱ ba̱l ko wokko wulpi ndat cin pak. ");
INSERT INTO gyz_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ɗe sa̱ kan wulpi wugo, yek sa̱ njet nala̱nti ten ma̱n zhimi. ");
INSERT INTO gyz_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Asa̱ na̱ma wulti ɗe, <Ma̱jin ɗe sa̱ ya tul ka̱ kaali go sa'i ɗena̱m ka̱n sa̱ pa̱li ka̱ zhimi, ama yek ka̱ ɓatlsi ndakce sukmi ɗe ma nda cin ten kolti zhin wu.> ");
INSERT INTO gyz_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","<<Ama yek ta̱ balli gon gwasa̱n ɗe, <Yela̱n gini, a tek ga̱zi so. Ale ga̱m ka̱n ma̱ pa̱li sukkii ten ɗe ta ɓatlkii wulpi dinari ɗe na̱m ɗe na̱m na̱? ");
INSERT INTO gyz_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kan wulpi gwa ta̱k zigaa. A mik lami ɗe ta ba̱l ma̱jwe sa̱ ya tul ka̱ kaali wu ndakce sukkii. ");
INSERT INTO gyz_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ko ba mana̱n pa̱lti ilgwe a lami wu na̱ wul gi so? Ko daka̱lti ga̱ alheri gwe a pa̱li wu ka̱n ka̱ na̱ma pa̱lti.> ");
INSERT INTO gyz_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","<<Na̱k gwisi ka̱n, ma̱ji tukaali pal ɗe ji cina, a ji cina pal ɗe ma̱ji tukaali.>> ");
INSERT INTO gyz_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","A Yesu suk mil lishti jwas na̱ma la̱t Wurshelima yek ta mbesi te kaali ka yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Yek gu ma̱ ɓa la̱n Wurshelima. Apaa sa̱ tak yen ga̱ mbala̱n ka̱ ang ga̱ kiɗi ma̱n Pa̱ris suk ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa, sa pa̱lit kisti ga̱ɓa ɗe ta̱ tlot ka. ");
INSERT INTO gyz_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Asa̱ takti ka̱ ang ga̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ so wu, sa hwit ga̱ɓa mbulti asa̱ ɓoti asa̱ ɓakti ka ten guda̱l yencin. Ama ten cin na mekan wo sa palla̱t kaami!>> ");
INSERT INTO gyz_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ka̱ sa'i gwisi wo yek ana ga̱ mil ji Zabadi tul mal Yesu suk mil jwasi, yek ta̱ ngus atl a cina gwasi tas ngemit ilgon. ");
INSERT INTO gyz_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yek Yesu wulti ɗe, <<Yek ka lami kam ye?>> Yek ta̱ wulti ɗe, <<A na̱ma lamti ta̱k laki ta̱ mil ji jee da̱m malki, ta̱ gon da̱m ten ang shinti, a gon wo ten ang yali gwa ka̱ guu gwa.>> ");
INSERT INTO gyz_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yek Yesu wul mili ɗe, <<Ka̱a̱ yis ilgwe ka̱a̱ na̱ma ngemti wu so, kaa man tlat bomti gwe ba tla gwa?>> Yek sa̱ ballit ɗe, <<Ma mani,>> ");
INSERT INTO gyz_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yek Yesu wulsi ɗe, <<Yii kaa man tlat bomti gwe ba tla wu, ama ma̱lgwe a da̱m ten ang shinti suk ang yali gi go, amik ka lak ma̱li so. Lu da̱mti jwisi wo ji ma̱jwe Aba gi gwe ni nya wu a botli wu ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ɗe naa mil lishti jwas ɗe kutl ju kumi nu wugo, yek mbadl jwasa̱n lil na̱ yilkeni ɗe loɓi. ");
INSERT INTO gyz_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yek Yesu mbesi ka̱ lu ɗena̱m mas jwasa̱n yek ta̱ wulsi ɗe, <<Ka̱a̱ yis kangwe a guu ji ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu pa̱l iko ten ma̱ jwasa̱n wu. Ko ta̱ bacina jwasa̱n mago asa̱ pa̱li na̱k gwisi. ");
INSERT INTO gyz_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ama kii wo ba̱ ni na̱k gwisi ka̱ dlo gwaka̱n so. Mas ma̱lgwe na̱ma lamti ta̱s da̱m ɗe kakshe ka̱ kii go, ngetli ka̱n ta̱s da̱mikii ɗe ma̱n pa̱lti wul. ");
INSERT INTO gyz_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A mas ma̱lgwe na̱ma lamti ta̱s da̱m ɗe bacina gwaka̱n go, ngetli ka̱n ta̱s da̱mikii ɗe zhel, ");
INSERT INTO gyz_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","na̱k gwisi ka̱n yen ga̱ mbala̱n tul ɗe ta̱ ma̱lgon pa̱lit wul so, ama ta̱ tul ɗe pa̱l wul, ata̱ ba̱l mbadl gwasi, ten ɗe ta̱ mbala̱n wonti mbi kis ɗa̱.>> ");
INSERT INTO gyz_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ɗe Yesu suk mil lishti jwas ɓa zak ba̱n Yeriko go, yek wonti mbala̱n kopti. ");
INSERT INTO gyz_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","A dwa ɗe lop jon ni na̱ zhila ten bi tantu, sa̱ kumi ɗe Yesu na̱ma la̱t wugo, yek sa̱ njel wulti to nya ka̱ɗe, <<Bagaa Yen ga̱ Dauda, yen gonti ga̱na̱n ne!>> ");
INSERT INTO gyz_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yek mbala̱mi matlsi yek sa̱ wulsi ɗe ta̱s da̱m mbetlak, ama yek sa̱ wuli to nya ka̱ɗe, <<Bagaa, Yen ga̱ Dauda yen gonti ga̱na̱n ne!>> ");
INSERT INTO gyz_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yek Yesu dla̱l ka yek ta̱ wulsi ɗe, <<Yek ka̱a̱ na̱ma lamti ta pa̱likii ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yek sa̱ nda̱kit ɗe, <<Bagaa ma̱ na̱ma lamti ta̱n man yenti lu.>> ");
INSERT INTO gyz_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yek Yesu yen gonti gwasa̱n yek ta̱ ta̱n gwel jwasa̱n. Yek sa̱ njel yenti lu ka̱li-ka̱li yek sa̱ kop kaal gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ɗe Yesu suk mil lishti jwas mbuki nak'en ba̱n Betapaj njaa a Wurshelima ten Za̱nda̱l Tla̱nda̱l Zetun wu, yek ta̱ shin mil lishti jwas ɗe lop te cina gwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Yek ta̱ wulsi ɗe, <<La̱n te ka̱ ba̱n gwe nikii cina wu ka, kaa yen zhaki suk yen gwas ga̱ ɓali ka ka̱ ba̱mi. Pa̱tlini nini si teɗi. ");
INSERT INTO gyz_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A kume ma̱lgon wulkii ɗe ilgon go, aka̱a̱ hwit ɗe Bagaa na̱ma lamti gwasa̱n ata ya palla̱si teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pi na̱k gwisi ta̱ njika̱n ilgwe ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Hwi ma̱n Sihiyona ɗe, <Ɓo yeni ni guu gwaka̱n ka tulikii wu, ma̱n kumti bi ka̱ɗe ti, ta̱ to ten zhaki, ten yen zhaki ka̱n ta̱ na̱ma la̱ti.> >> ");
INSERT INTO gyz_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yek mil lishtisi sak pa̱l ilgwe Yesu hwisi ɗe ta̱s pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yek sa̱ tulli zhaki suk yen gwasi, yek sa̱ wut luka̱l jwasa̱n tensi ten ɗe ta̱ Yesu to ta̱s da̱mi. ");
INSERT INTO gyz_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yek wonti mbala̱n wut luka̱l jwasa̱n ten tantu, yek jon jwasa̱n kotl daa tet ten tlindi yek sa̱ ta̱tali ten tantu. ");
INSERT INTO gyz_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yek mbala̱n jwe sa̱ nit tu cina ju, suk jwe sa̱ nit tu tukaal wu ngusi wulti to nya ka̱ɗe, <<Hosana ga̱ yen Dauda!>> <<Ma̱lgwe tul na̱ shin ga̱ Bagaa go, ma̱n albarka ka̱n!>> <<Hosana ga̱ Ma̱n Nalti!>> ");
INSERT INTO gyz_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɗe Yesu te Wurshelima wugo yek mas ba̱mi hwot ka na̱ bi gwasi. Yek ma̱n ba̱mi ngusi kumti ga̱zi ɗe, <<Wok ɗe gwisi wo na̱?>> ");
INSERT INTO gyz_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Yek mbala̱n jwe na̱ma kopti kaal gwas wu nda̱kisi ɗe, <<Yesu ka̱n, ma̱n dla̱mti ga̱ɓa tet Nazarat ka̱ atl ga̱ Galili.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yek Yesu te ka̱ lubii ga̱ Nya yek ta̱ mbol ma̱jwe asa̱ wul wul ka ka̱li wu. Yek ta̱ jek tebul ji ma̱jwe asa̱ balli wulpi mbala̱n wu ka, suk gobdlan ji ma̱jwe asa̱ wul kulu ka̱ ju ka. ");
INSERT INTO gyz_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yek ta̱ wulsi ɗe, <<Ni ga̱ lishi ɗe, <Sa mbe lubii gi ɗe lubii ngemti Nya,> ama yek ka̱a̱ palli ɗe lu hwunti ji muka̱l wi.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yek dwa suk ma̱jwe ka̱t dli jon jwasa̱n tla ka̱ ju tul malti ka̱ lubii ga̱ Nyami, yek ta̱ ndoksi. ");
INSERT INTO gyz_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ama yek kiɗi ma̱n Pa̱ris suk ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa yen wul ngipti bi ang gwe ta̱ pa̱li wu, suk kangwe mil mbala̱n na̱ma wulti to nya ka̱ɗe, <<Hosana ga̱ Yen ga̱ Dauda wu,>> Yek mbadl gwasa̱n lili. ");
INSERT INTO gyz_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yek sa̱ ngemti ɗe, <<Ama ka̱ na̱ma kumti ilgwe mil jee na̱ma dla̱mti gwa?>> Yek Yesu ballisi ɗe, <<Yii, ka̱a̱ ɓo taɓa dla̱mti luisi ka̱ ga̱ɓa Nya so nwa?>> <<Ɗe, <Ka lak mil mbala̱n suk mil la̱li ten ta̱sti gwa!> >> ");
INSERT INTO gyz_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yek ta̱ zaksi ka̱li, yek ta̱ li ba̱n Betani yek ta̱ mul ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lu tlo wi ɗe ta̱ dop tantu palti tot ka̱ ba̱n wugo yek kuza̱n njel tlot gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yek ta̱ yen tlindi tula̱n ten bi tantu yek ta̱ li mali ama yek ba̱ta̱ mbi ilgon dani so se daa. Yek ta̱ wul tula̱mi ɗe, <<Ba̱k po wut mil so hal pakti gwa!>> Yek tlindi koo ka ka̱li-ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mil lishtisi yeni nu wugo, yek sa̱ ngip ang bi Yek sa̱ ngemti ɗe, <<Ɗa̱ nii ka̱n tlindi koo ka ba̱le-ba̱le nu gwi?>> ");
INSERT INTO gyz_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yek Yesu ballisi ɗe, <<Gem amik kaa hwikii ge, ɗe kume ka̱a̱ nga̱skii ten Nya yek ba̱ka̱a̱ cel ka̱ mbadl sowu, ilgwe mbi tula̱n ga̱n ka̱n kaa man lakti a pi tokte so. Ama kaa mani wulti tla̱nda̱l ga̱n ɗe, <Tlinya ta̱k suk nda ka̱ bal ze,> a pi na̱k gwe ka̱a̱ dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ɗe kume ka̱a̱ ba̱l gem go, kaa mbi mas ilgwe ka̱a̱ ngemi ten ga̱ɓa suk Nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ɗe Yesu te ka̱ lubii ga̱ Nya ɗe ta̱ ɓa hwi ga̱ɓa mbala̱n wu, yek kiɗi ma̱n pa̱lti wul ka̱ lubiimi suk bacina ji Ma̱n Yehuda tul malti yek sa̱ ngemti ɗe, <<Na̱ wunda̱l ga̱ iko gwi ka̱n ka̱ na̱ma pa̱lti wul jin jwi? Wok ba̱lki iko pa̱lti wul jimi wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yek Yesu ballisi ɗe, <<Kii mago ba ngemkii wul ɗe na̱m. Kume ka̱a̱ dla̱mi go ba hwikii wunda̱l ga̱ iko gwe a na̱ma pa̱lti wul jin ɗa̱ wu. ");
INSERT INTO gyz_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Baptisma ga̱ Yohana go tet ko ka̱n yil ko? Sut mal Nya ma, ko tet mal mbala̱n ka̱n.>> Yek sa̱ dla̱m ga̱ɓa a dani ka̱ dlo gwasa̱n, yek sa̱ dla̱m ɗe, <<Kume ma̱ wuli ɗe, <Sut mal Nya wu,> ta ngema̱nni ɗe, <Yek laki yek ba̱ka̱a̱ ba̱l gem ɗa̱ so ye?> ");
INSERT INTO gyz_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","A kume ma̱ dla̱ma̱n ɗe, <Tet mal mbala̱n ka̱wu,> ma na̱mma ɓanti ga̱ ilgwe mbala̱n a manini pa̱lti wu, na̱k ɗe mas mbala̱n kan ɗe Yohana wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nuk laki yek sa̱ balli Yesu ɗe, <<Ma̱ yisi so.>> Yek ta̱ wulsi ɗe, <<Ami mago ba hwikii wunda̱l iko pa̱lti wul gwe a nima pa̱lti wul jin na̱ nali wu so. ");
INSERT INTO gyz_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Yek ɗe daamti gwaka̱n ye? Ma̱n mil mani ɗe lop gon ni ɗa. Ta̱ wul kaksha yen gwas ɗe, <Yen gini, lak kol zhin ka̱ zhin inabi ase.> ");
INSERT INTO gyz_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<<Yek yeni ballit ɗe, <Ba li so,> ama yek ta̱ lak daamti ka̱ kaali yek ta̱ li ka̱ zhimi. ");
INSERT INTO gyz_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","<<Yek abe li mal ma̱ngaɓisi yek ta̱ hwit ilgwe ta̱ hwi kakshesi wu. Yek ta̱ ballit ɗe, <To, bali aba gini,> ama yek ba̱ta̱ li ka̱ zhimi so. ");
INSERT INTO gyz_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","<<Wok ɗe ma̱lgwe pa̱l ilgwe aba gwas lami wu ka̱ mil ɗe loɓi go?>> Yek sa̱ ballit ɗe, <<Ga̱ cinesi.>> Yek Yesu wulsi ɗe, <<Gem amik ka hwikii ge, ma̱n kanti wulpi boo suk ma̱n pa̱t-pa̱la̱n a te ka̱ Nya ɗe guu cina ɗa kii. ");
INSERT INTO gyz_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ai Yohana ma̱n baptisma tula̱n ɗe ta̱s mbokikii ang ten kangwe kaa pa̱l zok wul wu, yek ka̱a̱ nge ba̱lti gem na̱ ti. Ama ma̱n kanti wulpi boo suk ma̱n pa̱t-pa̱la̱n ba̱l gem na̱ ti. Ko ɗe ka̱a̱ yeni nu ma wu ama yek ba̱ka̱a̱ ci atl gaa yek ka̱a̱ ba̱l gem na̱ ti so. ");
INSERT INTO gyz_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Ɓo kuma̱n cinga̱lti ga̱ɓe gon ɗa, ma̱n zhin gon ɓak inabi. Yek ta̱ ganda̱li ka na̱ bal sa̱mba̱l, yek ta̱ ɗuk shu cetti ze inabi a giɓi, yek ta̱ kin lu da̱mti ga̱ ma̱n ɓa̱tti. Yek pa ta̱ ba̱l mil haya zhimi yek ta̱ li ka̱ atl gon. ");
INSERT INTO gyz_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ɗe gis ga̱ inabi tul wugo yek ta̱ shin zhel jwas mal mil haye, ten ɗe ta̱s kamit yandi inabisi gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","<<Ama yek mil haye dop zhel jwasi, yek sa̱ ɓo gon, yek sa̱ tlo gon, yek sa̱ lak gon na̱ ye. ");
INSERT INTO gyz_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yek ta̱ shin zheli jon jwe wonti man ji cina ju malsi, yek sa̱ po pa̱lisi na̱k kangwe sa̱ pa̱li ji cina ju. ");
INSERT INTO gyz_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ka̱ kaali wo, yek ma̱n zhimi shin yen gwas malsi. Ta̱ wuli ɗe, <Sa yena̱n nalti ga̱ yen gini.> ");
INSERT INTO gyz_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","<<Ama yek mil haye yen yeni wugo, yek sa̱ wul yilkeni jwasa̱n ɗe, <Ma̱lga̱n ka̱ɗe ma̱n cit gadosi. Ma̱ tloti ka ta̱ gado gwas da̱m ɗe ga̱na̱n.> ");
INSERT INTO gyz_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Yek sa̱ dopti yek sa̱ lakti te kaal bal sa̱mba̱l ga̱ zhimi ka yek sa̱ tloti. ");
INSERT INTO gyz_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","<<To, ɗe ma̱n zhimi pal wugo yek ta pa̱li mil haya jwisi ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yek sa̱ ballit ɗe, <<Gem ka̱ go ta tlo ma̱n ngalci jwisi ka, ata̱ ba̱l zhimi ma̱jwe a ba̱lti wul zhimi gwas ka̱ gis wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yek Yesu wulsi ɗe, <<A ka̱a̱ kumi ka̱ ga̱ɓa ga̱ Nya sa? Ai na̱n ga̱ lishi ɗe, << <Ye gwe ma̱n kinti bii nge wu, yek ɓal ɗe ye gwe ni hwaɓi ka̱ kinti biimi man naami wu Gwisi wo pa̱lti ga̱ Bagaa ka̱n, a wul ngipti bi ang ka̱n a mala̱nni.> ");
INSERT INTO gyz_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Ten gwisi ka̱n a nikii ma hwiti ɗe, Sa kan Nya ɗe guu ɗa̱ ang gwaka̱n ka asa̱ ba̱l ma̱jwe sa pa̱l hwa wul wu. ");
INSERT INTO gyz_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma̱lgwe nda ten yesi go ta caccal ka, a ma̱lgwe yesi ndet gaa go a nolti na̱k apti.>> ");
INSERT INTO gyz_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ɗe kiɗi ma̱n Pa̱ris suk ma̱n Paresi kum cinga̱lti ga̱ɓa jimi wu, yek sa̱ yisi ɗe tensi ka̱n ta̱ na̱ma mbokti ang. ");
INSERT INTO gyz_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yek sa̱ lam dopti gwasi ama yek ɓanti ga̱ wonti mbala̱n jwe ni ka̱li wu cisi na̱k ɗe mbala̱mi kan ɗe ti wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ɗe ti wu. ");
INSERT INTO gyz_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yek Yesu po hwisi cinga̱lti ga̱ɓa gon ɗa yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Guu ga̱ Nya wo na̱k ta̱ guu gwe pa̱li yen gwas shiri biki hapti ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yek ta̱ shin zhel jwas mal ma̱jwe ta̱ shinisi lu ɗe ta̱s tul wu, ama yek ba̱ ma̱jwe ta̱ shinisi lu wu tul so. ");
INSERT INTO gyz_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","<<Yek ta̱ shin zheli jon malsi ɗa, yek ta̱ wulsi ɗe, <Hwi ma̱jwe a shinisi lu ju ɗe, a pak za̱t ilga̱ nguki wi. Sa mbosh basi tla suk tla jwe sa̱ keta̱lsi ɗe ji biki wu wi, ma̱ pak la̱ka̱nti ko yek ke wi. La̱n tet ka̱ lu biki haptisi.> ");
INSERT INTO gyz_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","<<Ama yek ba̱sa̱ kat ka̱ng so yek sa̱ zigaa ilgon gwasa̱n. Yek gon li ka̱ zhin gwasi, yek gon la wulti wul ka. ");
INSERT INTO gyz_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yek naami jwasa̱n dop zheli yek sa̱ ɓosi hal yek sa̱ tlosi ka. ");
INSERT INTO gyz_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yek mbadl ga̱ guumi lil i'e. Yek ta̱ shin ma̱n hapti dlo jwasi yek sa̱ tlo ma̱n tlot mbala̱n jwisi ka, yek sa̱ kwel ba̱mi ka. ");
INSERT INTO gyz_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","<<Yek ta̱ wul zhel jwas ɗe, <Pak pa̱lti shiri biki wi, ama ma̱jwe a shinisi lu ɗe ta̱s tul go mbun ɗe ta̱s sa biki so. ");
INSERT INTO gyz_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ningo la̱n ɗa̱n ten tantu ka ta̱k mbe mas ma̱jwe ka̱a̱ mbisi wu tet ka̱ lu biki.> ");
INSERT INTO gyz_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Yek zheli li ɗa̱n ten bal tantu ka yek sa̱ mbe mas ma̱jwe sa̱ mbisi ju teɗi. Na̱ hwa mbala̱n suk mbala̱n ji koo lu se na̱k lu biki hapti njika̱n ka na̱ ma̱nda̱ki. ");
INSERT INTO gyz_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Ama yek guu te ka̱ lu biki ɗe ta̱s yen kangwe ni wu, wugo yek ta̱ yen ma̱lgon gwe ba̱ta̱ lak luka̱l biki sowu. ");
INSERT INTO gyz_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Yek guumi ngemti ɗe, <Yela̱n gini, ɗa̱ nii ka̱n ka̱ te tet aɗe ba̱na̱ luka̱l biki so gwi?> Yek ba̱ ma̱li mbi ilga̱ dla̱mi so. ");
INSERT INTO gyz_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","<<Yek guumi wul ma̱jwe asa̱ pa̱lit wul wu ɗe, <Ɓala̱n asa̱n gwas ka suk ang gwasi ta̱k la̱ka̱nti te ka̱ duu da̱mshal ka. Ka̱ lu gwisi ka̱n ta̱ kuli ata̱ as ang bi.> ");
INSERT INTO gyz_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","<<Ai wonti mbala̱n ka̱n sa̱ shinisi lu, ama mbala̱n ji botli wo sa̱ wonti so.>> ");
INSERT INTO gyz_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yek ma̱n Paresi lak dla̱m ga̱ɓa ka̱ dlo gwasa̱n ten kangwe sa pi asa̱ dopti ka̱ ga̱ɓa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yek sa̱ shin mil lishti jwasa̱n suk mbala̱n ji Hiridus jon yek sa̱ wulti ɗe, <<Ma̱n lishti, ma̱ yisi ɗe ki wo ma̱n gem ka̱n, aka̱ nima mbokti ang mbala̱n ten ga̱ɓa ga̱ Nya na̱ gem. Ka̱ kan mas mbala̱n gaa ɗe na̱m, ba̱ka ba̱l jon nalti man jon so. ");
INSERT INTO gyz_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ningo ɓo hwini, yek ɗe daamti gwa ye? Mbun ɗe ta̱n ɓatl wulpi boo ga̱ guu Kaisar a ko mbuna̱n so?>> ");
INSERT INTO gyz_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ama na̱k ɗe Yesu yis byas daamti ga̱ mbadl gwasa̱n wu, yek ta̱ wulsi ɗe, <<Yek laki yek ka̱a̱ na̱ma lamti cinga̱lti gi ye, kii ma̱n pa̱lti riya!>> ");
INSERT INTO gyz_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","<<Ɓo mbokini nini ang ten wulpi gwe asa̱ ɓatl wulpi boomi ɗa̱ wu.>> Yek sa̱ ba̱lti wulpi dinari. ");
INSERT INTO gyz_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yek ta̱ ngemsi ɗe, <<Hoto suk shin ga̱ wok ɗe ga̱n wo?>> ");
INSERT INTO gyz_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yek sa̱ ballit ɗe, <<Kaisar.>> Yek ta̱ wulsi ɗe, <<Ba̱la̱n Kaisar wul ga̱ Kaisar, aka̱a̱ ba̱l Nya wul ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sa̱ kumi nu wugo yek ngip bi ang, yek sa̱ zakti yek sa̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ten cin gwisi ka̱n ma̱n Saduki ma̱jwe asa̱ wuli ɗe, mbala̱n a pal kaami sowu tul mal Yesu, yek sa̱ ngemti. ");
INSERT INTO gyz_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yek sa̱ wuli ɗe, <<Ma̱n lishti, Musa wuli ɗe, kume mbala̱n ma̱shi a ba̱ ta̱ ɓo zi yen sowu. Ta̱ ma̱ngaɓi gwas kan kili gwe ta̱ zakti wu ta̱s zi yen yilka gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To, ma̱jon ni ɗa yilkeni ɗe nitgi ka̱ mi. Kakshe gwasa̱n pa̱l hapti hal yek ta̱ ma̱shi a ba̱ta̱ ɓo zi yen so, yek ma̱ngaɓi gwas hap kilisi ɗe ta̱ zakti wu. ");
INSERT INTO gyz_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na̱k gwisi pi na̱ na loɓi suk na mekami hal yek la na nitgisi. ");
INSERT INTO gyz_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ka̱ kaali wo yek kilisi lak ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Yek ningo, ten cin gwe mbala̱n a pal kaami go, ɗe kili ga̱ wok tani wo, na̱k ɗe mas jwasa̱n sa̱ hapti wu?>> ");
INSERT INTO gyz_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yek Yesu ballisi ɗe, <<Daamti gwaka̱n ka̱ni hwaɓi so, na̱kka̱n ka̱a̱ yis ilgwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya wu so a ba̱ka̱a̱ yis iko ga̱ Nya so. ");
INSERT INTO gyz_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ten ɗe ten cin gwe mbala̱n a pal kaami go mbala̱n a pa̱l hapti so a ba̱sa hap ka̱ so, ama sa da̱m na̱k mil shinti ji Nya. ");
INSERT INTO gyz_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ningo ten bi palti kaami ga̱ mbala̱n wo, ka̱a̱ dla̱ma̱n ilgwe Nya hwikii wu sa? ");
INSERT INTO gyz_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ɗe ta̱ wule, <Amik ɗe Nya ga̱ Iba̱rahim, Nya ga̱ Ishaku suk Nya ga̱ Yakubu.> Nya ga̱ ma̱jwe ni kaami ka̱ɗe ti, ba̱ ɗe we Nya ga̱ hwu so.>> ");
INSERT INTO gyz_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mbala̱mi kum ilgwe ta̱ dla̱m wugo yek sa̱ ngip bi ang ten wunda̱l ga̱ mbokti ang gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ma̱n Paresi kum kangwe Yesu man ngetl ga̱ ma̱n Saduki wugo yek sa̱ mogaa. ");
INSERT INTO gyz_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Yek gon gwasa̱n ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa i'e ngem Yesu ten ɗe ta cinga̱lti. ");
INSERT INTO gyz_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Yek ta̱ wulti ɗe, <<Ma̱n lishti, Gwik nal mani ka̱ Mba̱t Ga̱ɓa ga̱ Musa gwi?>> ");
INSERT INTO gyz_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yek Yesu ballit ɗe, << <Lam Nya Bagaa gwa na̱ mas mbadl gwa, na̱ mas da̱mti gwa, suk mas daamti gwa.> ");
INSERT INTO gyz_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yek ɗe lakti zhila ga̱ mba̱t ga̱ɓa a yek ɗe gwe nal mani wu. ");
INSERT INTO gyz_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A gwe kop kaali go na̱k gwisi ka̱n ni. Yek ɗe, <Lam yela̱n da̱mti gwa na̱k kangwe ka̱ lam gaa gwa wu.> ");
INSERT INTO gyz_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mas lishti ga̱ Mba̱t Ga̱ɓa ga̱ Musa suk ji Ma̱n Dla̱mti Ga̱ɓa ga̱ Nya dla̱l ten mba̱t ga̱ɓa ɗe lop jimi.>> ");
INSERT INTO gyz_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ma̱n Paresi mogaa ka̱ lu ɗe na̱m wugo, yek Yesu ngemsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Yek ɗe daamti gwaka̱n ten Almasihu ye? Yen ga̱ wok ɗe ti wo?>> Yek sa̱ ballit ɗe, <<Yen ga̱ Dauda,>> ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yek ta̱ wulsi ɗe, <<Yek laki yek Shishi ga̱ Nya lak Dauda ten mbet gwas ɗe <Bagaa> ye? Na̱k ɗe Dauda dla̱m ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<< <Bagaa hwi Bagaa gi ɗe, Da̱m ten ka̱t ang shinti gini se a palli ma̱n nget jwa a atl ɗaaki.> >> ");
INSERT INTO gyz_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","<<Ɗe kume Dauda mbet ɗe, <Bagaa> go, ɗa̱ nii ka̱n ta̱ nit ɗe yen gwi?>> ");
INSERT INTO gyz_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Yek ba̱ ma̱lgon manit balla̱t ilgon so. Kan ten cin gwisi yek ba̱ gon gwasa̱n po mbi nda̱li gahwula̱n ngemti gwas ten bi ilgon so. ");
INSERT INTO gyz_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ɗe mbala̱n mogaa wonti suk mil lishti jwas wugo, yek Yesu wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa suk Ma̱n Paresi ka̱ɗe ma̱jwe Nya ba̱lsi iko mbokti ang ten Mba̱t Ga̱ɓa wu. ");
INSERT INTO gyz_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ten na̱k gwisi ka̱n, pa̱la̱n mas ilgwe asa̱ mbokikii ang dani. Koɓa̱n ga̱ɓa gwasa̱n ama ba̱k pa̱la̱n ilgwe asa̱ pa̱li wu so, na̱k ɗe ba̱sa kop ilgwe asa̱ mbok ang dani wu sowu. ");
INSERT INTO gyz_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Asa̱ ɓal wul ma̱n diɓa̱lti gwe a bomi kanti gaa mbala̱n wu, asa̱ zi ma̱n kanti ka̱ yal. Ama ba̱sa̱ zi ma̱n kanti wuli ang so ko ta̱ na̱ yen ang. ");
INSERT INTO gyz_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","<<Mas wul jwe asa̱ pa̱li go ten ɗe ta̱ mbala̱n yensi ɗa ka̱n. Asa̱ ɓal bal kumshi taka̱rda gwe sa̱ lish ga̱ ga̱ɓa ga̱ Nya a giɓi wu, asa̱ ɓal ten bicina jwasa̱n. Asa̱ pa̱l tlal rasa gwe a ta̱n atl wu, ɗa̱n ten bi luka̱l jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Sa̱ lam gobdlan ji kiɗi mbala̱n ka̱ lu biki, asa̱ lam mbuni gobdlan ka̱ lu motgaa jwasa̱n hwo. ");
INSERT INTO gyz_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Asa̱ lami ɗe ta̱ ngusi ga̱ɓet gwasa̱n ka̱ motgaa ga̱ wonti mbala̱n ta̱s mbesi ɗe, <Ma̱n lishti.> ");
INSERT INTO gyz_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<Ama kii wo ba̱ ma̱lgon mbekii ɗe, <Ma̱n lishti so,> ten ɗe kii wo Bagaa gwaka̱n ɗe na̱m ka̱n, mas jwaka̱n wo yilkeni ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A ba̱k mbe ma̱lgon ten dii atl ge ɗe, <Aba> so, Aba gwaka̱n wo ɗe na̱m ka̱n gwe ni ta̱ to nya ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A ba̱s mbekii ɗe <bacina> so, Ten ɗe na̱ ngus ka̱ɗe bacina gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma̱lgwe tik ɗe kakshe gwaka̱n go ta̱s da̱mikii ɗe zhel. ");
INSERT INTO gyz_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mas ma̱lgwe ba̱l nalti gaa gwas go, sa shitit gaa sut atli. Ama mas ma̱lgwe shit gaa gwas sut atl go, sa palla̱t ɗe kakshe. ");
INSERT INTO gyz_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","<<Kii wo wul cit gonti ka̱n, kii ma̱n yisti mba̱t ga̱ɓa ga̱ Musa suk ma̱n Paresi, kii ma̱n pa̱lti riya! Ka̱a̱ yitle mbala̱n dla̱bii tet ka̱ guu ga̱ nya ka. Kii gaa gwaka̱n wo ka̱a̱ te so, a ba̱ka̱a̱ zak ma̱jwe sa̱ na̱ma lamti tet wu ta̱s te so. ");
INSERT INTO gyz_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kii wo wul cit gonti ka̱n, kii ma̱n lishti Mba̱t Ga̱ɓa ga̱ Musa suk ma̱n Paresi, kii ma̱n pa̱lti riya! A ka̱a̱ nguki wul ang modli jwe kos ma̱shisi ka̱wu ka, aka̱a̱ ngusi pa̱lti tlal ngemti Nya ten ɗe ta̱ mbala̱n yenkii ɗa. Ten na̱k gwisi ka̱n, sa nolkii na̱ bomti i'e. ");
INSERT INTO gyz_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","<<Kii wo wul cit gonti ka̱n, kii ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa suk ma̱n Paresi, kii ma̱n pa̱lti riya! Aka̱a̱ ɗakci bal ze, aka̱a̱ li dlenti ba̱n ten ɗe ta̱k mbi ma̱n kopti ɗe na̱m. Ama kume ma̱li te ka̱ koptisi wugo, aka̱a̱ palla̱t ɗe yen buu wutu mankii gaa gwaka̱n asa̱mi ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<Kii wo wul cit gonti ka̱n, kii dwa bacina! Ka̱a̱ wuli ɗe, <Mas ma̱lgwe mo ga̱ɓa suk lubii ga̱ Nya go ilgon ni ɗa̱ so, ama ma̱lgwe mo ga̱ɓa na̱ zinariya gwe ni ka̱ lubii ga̱ Nyami go, ngetli ka̱n ta̱s pa̱l ilgwe ta̱ wuli ɗe ta pa̱li wu.> ");
INSERT INTO gyz_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kii dwa ka̱dla̱n gwik ɗe kakshe gwi, zinariye ya ko lubii ga̱ Nyami ɗe a palli zinariye zoki wu? ");
INSERT INTO gyz_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ka̱a̱ po wuli ɗe, <Kume mbala̱n mo ga̱ɓa na̱ bagadi go ilgon ka̱ so, ama kume mbala̱n mo ga̱ɓa na̱ wul gwe sa̱ taki Nya ten bagadi go ngetli ka̱n ta̱s pa̱l ilgwe ta̱ wuli ɗe ta pa̱li wu.> ");
INSERT INTO gyz_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kii dwa! Gwik ɗe kakshe gwi, ilgwe sa̱ taki Nya gwa ko bagadi ɗe a palli ili zoki wu? ");
INSERT INTO gyz_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ten na̱k gwisi ka̱n ma̱lgwe mo ga̱ɓa na̱ bagadi go ma̱li mo ga̱ɓa na̱ nali suk mas ilgwe ni dani wu. ");
INSERT INTO gyz_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A ma̱lgwe mo ga̱ɓa na̱ lubii ga̱ Nya go, ma̱li mo ga̱ɓa na̱ nali suk ma̱lgwe a ta̱ da̱m giɓi wu. ");
INSERT INTO gyz_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A mas ma̱lgwe mo ga̱ɓa suk nya go, ma̱li mo ga̱ɓa na̱ gobdlan guu ga̱ Nya suk Nya gaa gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<Kii wo wul cit gonti ka̱n, kii ma̱n mbokti ang ten Mba̱t Ga̱ɓa ga̱ Musa suk ma̱n Paresi, kii ma̱n pa̱lti riya! Aka̱a̱ ba̱l zakka ga̱ wul yaji suk daa wolo, ama yek ka̱a̱ zak wul jwe mbun mani ka̱ Mba̱t Ga̱ɓe wu. Ka̱a̱ zak pa̱lti gem, suk yenti gonti suk nga̱sti ten Nya. Jimi ka̱ɗe wul jwe mbun ɗe ta̱k pa̱li wu, ama ba̱k zaka̱n pa̱lti jon ju so. ");
INSERT INTO gyz_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kii dwa bacina! Aka̱a̱ cinda̱l ze ga̱ tle gwaka̱n ka ten ɗe ka lak sa̱nga nak'en kwaro, ama aka̱a̱ sa̱nga rakumi! ");
INSERT INTO gyz_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<Kii wo wul cit gonti ka̱n, kii ma̱n mbokti ang ten Mba̱t Ga̱ɓa ga̱ Musa suk ma̱n Paresi! Kii ma̱n pa̱lti riya! Aka̱a̱ pol tukaal ga̱ kopi suk gal ka, ama tugiɓi wo ga̱ njika̱mi ka na̱ byas wul gwaka̱n suk tet ga̱zi mbala̱n suk lamti gaa gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ki dwa ma̱n Paresi! Nde na̱ polti tugiɓi ga̱ kopisi suk gali ka apaa tukaalisi poldli pak. ");
INSERT INTO gyz_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<Kii wo wul cit gonti ka̱n, kii ma̱n mbokti ang ten Mba̱t Ga̱ɓa ga̱ Musa suk ma̱n Paresi, kii ma̱n pa̱lti riya! Kii wo na̱k gazukɗi jwe sa̱ ɓesi hwol atl wu ka̱n, ham ka̱a̱ ta̱n yeni tu tukaal hwo, ama tugiɓi wo is ji ma̱jwe ma̱sh wu suk mas wunda̱l ga̱ da̱ska̱n wonti ka̱ni giɓi. ");
INSERT INTO gyz_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na̱k gwisi ka̱n tu tukaal gwaka̱n wo aka̱a̱ mboki ang mbala̱n ɗe kii wo ma̱n pa̱lti wul ndakce ka̱n, ama tu tugiɓi wo ka̱a̱ njika̱n na̱ shelti mbala̱n suk ngalci. ");
INSERT INTO gyz_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","<<Kii wo wul cit gonti ka̱n, kii ma̱n mbokti ang ten mba̱t ga̱ɓa ga̱ Musa suk ma̱n Paresi, kii ma̱n pa̱lti riya! Aka̱a̱ kin gazukɗi ji ma̱n dla̱mti ga̱ɓa ga̱ Nya, aka̱a̱ ɓe gazukɗi ji ma̱n pa̱lti wul ndakce ado. ");
INSERT INTO gyz_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Aka̱a̱ wuli ɗe, <Ma na̱n ɗa ka̱a̱ multi ji ma̱n za̱t jina̱n go, mi wo ma mo ang suksi ten tlot ji ma̱n dla̱mti ga̱ɓa ga̱ Nya so.> ");
INSERT INTO gyz_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na̱ nu ka̱n ka̱a̱ mbok ang ɗe kii wo mil ji ma̱jwe sa tlo ma̱n dla̱mti ga̱ɓa ga̱ Nya ju ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ten na̱k gwisi ka̱n paka̱n pa̱lti ilgwe ma̱n ngalci suk ma̱n za̱t jwaka̱n lak zhile wu! ");
INSERT INTO gyz_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","<<Kii wuci, mil woka̱nzi na̱k kii nini! Ɗa̱ nii ka̱n kaa yilli gaa gwaka̱n ɗa̱ka̱ nolti ga̱ buu wutu ka̱ gwi? ");
INSERT INTO gyz_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ten na̱k gwisi ka̱n ba shinikii lu na̱ ma̱n dla̱mti ga̱ ga̱ɓa Nya, suk ma̱n ɓotlka̱n yisti wul, suk ma̱n mbokti ang ten mba̱t ga̱ɓa ga̱ Musa. Kaa tlo jon jwasa̱n, akaa ɓak jon jwasa̱n ka ten guda̱l yencin, a jon jwasa̱n wo kaa ɓosi ɗa̱nka̱ lu motgaa jwaka̱n ka, kaa ngusisi kopti gwasa̱n ba̱n-ba̱n aka̱a̱ laksi ka̱ bomti. ");
INSERT INTO gyz_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ba shin ma̱ jwisi suɗi ten ɗe ta̱ mas hwulan ji ma̱n pa̱lti wul ndakce jwe sa tlosi ten dii atl wu da̱mikii gaa. Kan tet ten hwulan ga̱ Habila ma̱n pa̱lti wul ndakce, hal yek la ga̱ Zakariya yen ga̱ Berekiya, ma̱lgwe ka̱a̱ tlot ka ka̱ dlo ga̱ lu ma̱n cilti suk bagadi takti wul Nya wu. ");
INSERT INTO gyz_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gem amik ka hwikii ge, mas wul jimi a mbi mbala̱n ji se. ");
INSERT INTO gyz_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Anya ma̱n Wurshelima, ma̱n Wurshelima! Ba̱n ma̱n tlot ɗa̱ ma̱n dla̱mti ga̱ɓa ji Nya, suk lakti ga̱ ma̱jwe sa̱ shinsi malki wu na̱ ye! Kangwe a lami ɗe ta moo mil jwa ɗe na̱m, na̱k gwe a kol moo mil jwas ka̱ bibaku gwas wu, ama yek ka̱ nge wu. ");
INSERT INTO gyz_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɓo yeni, ningo sa̱ zakik lubii gwa ɗe kupayi wi. ");
INSERT INTO gyz_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ten na̱k gwisi ka̱n, amik ka hwikii ge, kaa po yena̱n so se gas gwe ka̱a̱ wuli ɗe, <Ma̱n albarka ka̱ɗe ma̱lgwe na̱ma tulti na̱ shin ga̱ Bagaa wu.> >> ");
INSERT INTO gyz_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ɗe Yesu zak lubii ga̱ Nya wu, ta̱ na̱ma za̱tgaa nugo yek mil lishti jwas mbokit ang ten kinti bii jwe ni ka̱ lubii ga̱ Nyami wu. ");
INSERT INTO gyz_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yek Yesu wulsi ɗe, <<Ka̱a̱ yen kinti bii jee ya! Gem amik ka hwiki ge, ko sa zak ye gon ten gon so, sa cac-cati ka mas.>> ");
INSERT INTO gyz_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ɗe Yesu da̱m na̱ zhila ten Za̱nda̱l Tla̱nda̱l Zetun wu, yek mil lishti jwas li malti si na̱ ngusa̱n. Yek sa̱ wulti ɗe, <<Hwini, a gasi ka̱n ilga̱mi a pi gwi? Yek ɗe lal ga̱ palti gwa suk ga̱ pakti dii atl gwi?>> ");
INSERT INTO gyz_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yek Yesu ballisi ɗe, <<Da̱ma̱n na̱ ka̱ng gaa ba̱k zaki ni a ma̱lgon shelkii so. ");
INSERT INTO gyz_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ten ɗe mbala̱n wonti a tul na̱ shin gini, a ngusi wulti ɗe, <Amik ɗe Almasihu,> asa̱ shel mbala̱n wonti wu. ");
INSERT INTO gyz_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kaa kum wonti dlanti suk wonti ga̱ɓa ten bi dlanti, ama ba̱ hwotkii so. Ngetli ka̱n ta̱ wul jwisi pi, ama paktisi ɓo tul so. ");
INSERT INTO gyz_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mbala̱n a tli mbala̱n jon gaa, a guu tli guumi jon gaa. A pa̱l kuza̱n suk nwuti ga̱ atl ɗa̱nka. ");
INSERT INTO gyz_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mas wul jimi wo ndat zhila tlat bomti ka̱ yi. ");
INSERT INTO gyz_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Apaa sa̱ lakkii ka̱ ang ga̱ ma̱jwe a nolkii wu hal asa̱ tlokii. Mas mbala̱n a ngekii ten bi gini. ");
INSERT INTO gyz_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ka̱ sa'i gwisi wo mbala̱n wonti a pal na̱ kaali, sa ba̱l bi ga̱ yilkeni jwasa̱n, asa nge yilkeni jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma̱n dla̱mti ga̱ɓa ga̱ Nya ji lali wonti a yili asa shel mbala̱n wonti. ");
INSERT INTO gyz_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na̱k ɗe pa̱t ngalci a mba̱ldli i'e wu, lamti ga̱ mbala̱n wonti a nda̱ɗi ka. ");
INSERT INTO gyz_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ama mas ma̱lgwe dlo mbadli yek ta̱ ta̱le paktisi go ta mbi kisti. ");
INSERT INTO gyz_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Asa lak cin ten ta̱mi ga̱ɓa ga̱ guu ga̱ Nya mal mas mbala̱n, ta̱ da̱misi ɗe sheda apaa paktisi tuli. ");
INSERT INTO gyz_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Ten na̱k gwisi ka̱n, kume ka̱a̱ yen <lili wul cit daɗi,> gwe Daniyel ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m ɗe sa dla̱lli ka̱ Lu ma̱n Cilti wu, ta̱ ma̱lgwe na̱ma dla̱mti lishti wu yis gaami, ");
INSERT INTO gyz_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ta̱ ma̱jwe ni Yehudiya wu ap to ka̱ tla̱da̱l ka. ");
INSERT INTO gyz_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ba̱ ma̱lgwe ni ten gaa bii wu, wuli ɗe ta suk kan ilgon a giɓ boo so. ");
INSERT INTO gyz_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ba̱ ma̱lgwe ni ka̱ zhin wu wule ta pal tet lubii ta̱s kan godo gwas so. ");
INSERT INTO gyz_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Modli ma̱n mil tuk suk ma̱n mil kaal a da̱m ɗe wul cit gonti ka̱ multi jwisi. ");
INSERT INTO gyz_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ngema̱n Nya ɗe ba̱ apti gwisi tulikii ka̱ sa'i nda̱ɗiti sogo ten cin shukti so. ");
INSERT INTO gyz_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Na̱k ɗe ka̱ sa'isi wo mbala̱n a te ka̱ bomti ma̱n ciciti, wunda̱li gwe ba̱ ɓo taɓa pa̱t so tun na̱k sa̱ lak zhila ga̱ dii atli hal ase wu, a ba̱ gon a po tul na̱k gwisisi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sa hul wonta̱t ga̱ multi jwisi ka̱ sogo, ko ma̱lgon a sa kaami so, ama ten bi ga̱ mbala̱n ji botlisi yek laki yek sa hul wonta̱t ga̱ multi jwisi ka. ");
INSERT INTO gyz_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ka̱ multi jwisi wo kume ma̱lgon wulkii ɗe, <Ɓo yeni ni, Almasihu ka̱ ka̱wu aɗe sogo te duk go!> Ba̱k kama̱n so. ");
INSERT INTO gyz_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Na̱k ɗe Almasihu ji lali suk ma̱n dla̱mti ga̱ɓa ga̱ Nya ji lali wonti a yili. Asa̱ pa̱l kiɗi lali suk wul ngipti ang bi ta̱s gilli mbala̱n ɗa, hal kume ma̱n pa̱t ka̱ go sa gilli mbala̱n ji botli pak. ");
INSERT INTO gyz_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","To ɓo yeni ni, yekgu a hwikii wi ba̱le. ");
INSERT INTO gyz_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","<<Ten na̱k gwisi ka̱n, kume sa̱ wulkii ɗe, <Tik tek gu te ka̱ la̱p ka̱wu,> ba̱k la̱n so. A kume sa̱ wulkii ɗe, <Ta̱ni to ka̱ punka ga̱ hwunda̱li ka̱wu,> ba̱k kama̱n so. ");
INSERT INTO gyz_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Na̱k ɗe na̱k kangwe a nyaze cibi, a cilli lu gaba̱s suk yemma wu, na̱k gwisi ka̱n palti ga̱ Yen ga̱ Mbala̱n ani. ");
INSERT INTO gyz_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ai mas lu gwe hwu tlu ni go, ka̱li ka̱n a zhipki mogaa. ");
INSERT INTO gyz_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Na̱ pakti tlat bomti giɓi jimi, << <Cin a pal duuni a ba̱ lip a po cil so. kyadla̱l a lok sut nya, Sa nwu kiɗi wul ji nya.> ");
INSERT INTO gyz_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","<<Apaa ka̱ yen lal ga̱ Yen ga̱ Mbala̱n ka̱ dlo nya, mas mbala̱n ji dii atl kul ten ɓanti. Sa yen tulti ga̱ Yen ga̱ Mbala̱n ten nyaze, na̱ iko suk nalti i'e. ");
INSERT INTO gyz_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ta̱ shin mil shinti jwasi asa̱ hot noo teti, asa̱ moo mbala̱n ji botli jwas tet tu gaba̱s suk yemma suk kudu suk arewa, suk tet ten mas dii atli. ");
INSERT INTO gyz_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Ta̱ tlindi tula̱n da̱mikii ɗe wul mbokti ang, kume mil ang gwas ɓa pal zela̱ɗi yek nda telti daa wugo, a ka̱a̱ yisi ɗe watla̱n ɓal njaa. ");
INSERT INTO gyz_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na̱k gwisi ka̱n, hal kume ka̱a̱ yen mas wul jimi ɗe a hwikii wu ten pa̱t wugo, yisi ɗe sa'isi ɓal njaa, ɓal ten bi dlabii. ");
INSERT INTO gyz_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gem amik ka hwikii ge, mbala̱n ji se a ma̱sh so, se mas wul jin pi pa. ");
INSERT INTO gyz_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Dlo nya suk dii atl a taas ka, ama ga̱ɓa gi wo a taasdli so ko njet. ");
INSERT INTO gyz_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Ma̱lgon yis cimi sogo sa'isi gwe wul jimi a pi wu so, na̱ mil shinti ji Nya, hal Yeni se Abe na̱ ngusi. ");
INSERT INTO gyz_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na̱k kangwe pi ka̱ multi ji Nuhu go, na̱k gwisi ka̱n a pi ten palti ga̱ Yen ga̱ Mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tun ka̱ sa'i gwe ba̱ ze ga̱ Nuhu ɓo yitla dii atl ka̱ sowu, mbala̱n na̱ma ngukti wul asa̱ na̱ma tlati, asa̱ na̱ma pa̱lti hapti, asa̱ na̱ma hapti ka hal yek la sa'i gwe Nuhu te ka̱ jirgi ze wu, ");
INSERT INTO gyz_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","a ba̱sa̱ yisi ɗe ilgon a pi so, se na̱k zesi tuli yek yemsi ka̱wu. Na̱k gwisi ka̱n a pi ten palti ga̱ Yen ga̱ Mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ka̱ sa'i gwisi wo mbala̱n ɗe lop ani ka̱ zhin, sa kan gon asa̱ zak gon. ");
INSERT INTO gyz_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Modli ɗe lop a nima na̱kti hwo ten hwo, sa kan gon asa̱ zak gon. ");
INSERT INTO gyz_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","<<Ten na̱k gwisi ka̱n, da̱ma̱n na̱ ka̱ng gaa na̱k ɗe ba̱ka̱a̱ yis cin gwe Bagaa gwaka̱n a pal dani wu sowu. ");
INSERT INTO gyz_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ama yisi ɗe, ai ba boo a yisa̱n ka̱ sa'i gwe muka̱l a tul wugo, ta zakini a yemba̱l kanti so, a ba̱ta zaki a muka̱li tet ka̱ lubii so. ");
INSERT INTO gyz_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Na̱k gwisi ka̱n, kii mago da̱ma̱n na̱ ka̱ng gaa ko a gasi, na̱k ɗe Yen ga̱ Mbala̱n a tul ka̱ sa'i gwe ba̱ka̱a̱ zi ɗe ta tul wu sowu. ");
INSERT INTO gyz_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Wok ɗe zhel ma̱n pa̱lti gem, ma̱n ɓolka̱n yisti wul, gwe bagaa gwas a zak zhel jwas ka̱ ang gwasi ɗe ta̱s ba̱lsi wul ga̱ nguki ka̱ sa'i ngukti wul gwi? ");
INSERT INTO gyz_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma̱n albarka ka̱ɗe zhel gwe bagaa gwas a pali ata̱ mbit ten pa̱lti ilgwe ta̱ zit wu. ");
INSERT INTO gyz_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gem amik ka hwikii ge, ta palla̱t ɗe bacina ten mas wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ama kume ɗe zheli wo ma̱n ngalci ka̱wu ta̱ dla̱m ka̱ mbadl gwas ɗe, <Bagaa gi a pal ba̱le so,> ");
INSERT INTO gyz_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","yek ta̱ nda ɓot ɗa̱ zhel yilkeni jwasi yek ta̱ njel ngukti wul ata̱ na̱ma tlatdli suk ma̱n tlati-tlati. ");
INSERT INTO gyz_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Bagaa ga̱ zheli a pal ten cin gwe ba̱ta̱ zi ɗe ta pal dani sowu, ka̱ sa'i gwe ba̱ta̱ yisi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bagaami a pa̱lit byas ɓoti ata̱ nolti suk ma̱n pa̱lti riya, ka̱li ka̱n ta kuli ta̱ as ang bi. ");
INSERT INTO gyz_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Ka̱ sa'isi wo guu ga̱ Nya a ni na̱k mil modli ɗe kult jwe sa̱ yem pitila jwasa̱n ta̱s sa ɓa̱tti ga̱ yen kos wu. ");
INSERT INTO gyz_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ɗe namtan ka̱si wo ka̱dla̱n ka̱n, a ɗe namtam wo ɓotli. ");
INSERT INTO gyz_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ka̱ sa'i gwe ka̱dla̱mi ju ɓa kan pitilla jwasa̱n go yek ba̱sa̱ kan mil gwe sa mba̱li ka̱ pitile wu ang so. ");
INSERT INTO gyz_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ama ma̱n ɓotlka̱n jo yek sa̱ kan mili ɗa̱nka̱ bunta̱n mil jwasa̱n ka, ɗe sa̱ ɓa kan pitila jwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Yek ba̱ yen kosi tul ba̱le so, yek mas mil modlisi njel pa̱t genga̱ɗi hal yek sa̱ yemba̱l ka mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","<<Ɗe te ka̱ dlo gas ka ka̱ ɓal go, yek sa̱ kum shele ɗe, <Yen kosi ka̱ ɓal wu, la̱n teɗi ta̱k mbiti.> ");
INSERT INTO gyz_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","<<Yek mil modlisi tlinya mas jwasa̱n yek sa̱ njel la̱ka̱nti pitila jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yek ka̱dla̱mi ju wul ma̱n ɓotlka̱n ju ɗe, <Nak ɓesini mil jwaka̱n ne, pitila jina̱n na̱ma ma̱shka̱n.> ");
INSERT INTO gyz_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","<<Yek sa̱ wulsi ɗe, <Wowo, mili a kumini sukkii so. Kaa sak wul gwaka̱n tet mal ma̱n wulti ka̱wu a mani.> ");
INSERT INTO gyz_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","<<Ɗe sa̱ sa wulti mili wugo yek yen kosi mbuk lu. Yek ma̱jwe ta̱ mbisi na̱ shiri wu te ka̱ lu biki sukti, yek paa sa̱ le dlabii ka. ");
INSERT INTO gyz_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","<<Ka̱ kaali wo yek ka̱dla̱n mil modli ju pali, yek sa̱ wuli ɗe, <Bagaa, Bagaa, nak ɓulini dlabii ka!> ");
INSERT INTO gyz_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","<<Ama yek ta̱ wulsi ɗe, <Gem, amik ka hwikii ge, a yiskii so.> ");
INSERT INTO gyz_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","<<Ten na̱k gwisi, se ta̱k da̱ma̱n na̱ ka̱ng gaa, na̱k ɗe ba̱ka̱a̱ yis cimi sogo sa'isi sowu. ");
INSERT INTO gyz_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Na̱k gwisi ka̱n, guu ga̱ Nya wo na̱k ma̱lgwe a pi tafiya yek ta̱ mbe zhel jwasi, yek ta̱ zak wul ang gwas ka̱ ang jwasa̱n wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yek ta̱ hwulisi wulpi zinariya. Ta̱ ba̱l gon gwasa̱n ngura zinariya ɗe namtam, ta̱ ba̱l gon ngura zinariya ɗe lop, yek pa ta̱ ba̱l gon ngura zinariya ɗe na̱m. Ta̱ ba̱lsi na̱k gwisi, ko wokko ten nda̱lti gwasi yek pa zigaa. ");
INSERT INTO gyz_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yek ma̱lgwe ta̱ ba̱lti wulpi ngura zinariya ɗe namtam wu kan gwas wu, yek ta̱ ngusi wulti wul ka na̱ nali hal yek ta̱ mbi wulpi ngura zinariya ɗe namtam dani. ");
INSERT INTO gyz_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nu ka̱n ma̱lgwe ta̱ ba̱lti ngura ɗe lop wu pa̱li, ti mago yek ta̱ mbi mba̱lti wulpi zinariya ngura ɗe lop dani. ");
INSERT INTO gyz_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ama yek ma̱lgwe kan wulpi ngura zinariya ɗe na̱m wu lak ɗuk shu ka̱ atli, yek ta̱ hwunda̱l wulpi ga̱ ba boo gwas ka a giɓi. ");
INSERT INTO gyz_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","<<Pa̱l tlal multi wugo yek ba boo ga̱ zhel jwisi pali ta̱s dla̱m wulpi suksi. ");
INSERT INTO gyz_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yek zhel gwe kan wulpi ngura zinariya ɗe namtan wu te malti yek ta̱ ba̱lti zinariya jon ɗe ngura namtan ɗa, yek ta̱ hwit ɗe, <Ba boo gini, ka̱ ba̱la̱n wulpi ngura zinariya ɗe namtan. Ama yekgu a mbi ɗe ngura namtan dani wi.> ");
INSERT INTO gyz_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","<<Yek ba boo gwas wulti ɗe, <Madalla, hwa zhel ma̱n pa̱lti gem, ka̱ pa̱l gem ten wul njet, ningo ba palla̱k ɗe bagaa ga̱ wul wonti. Te sut mala̱nni ta̱k tla ta̱mi mbadl ga̱ ba boo gwa!> ");
INSERT INTO gyz_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","<<Yek zhel gwe kan wulpi ngura zinariya ɗe lop wu te malti, yek ta̱ ba̱lti zinariya jon ngura ɗe lop ɗa, yek ta̱ hwit ɗe, <Ba boo gini, ka̱ ba̱la̱n wulpi ngura zinariya ɗe lop. Ama yekgu a mbi ngura ɗe lop dani wi.> ");
INSERT INTO gyz_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","<<Yek ba boo gwas wulti ɗe, <Madalla, hwa zhel, ma̱n pa̱lti gem, ka̱ pa̱l gem ten wul njet, ningo ba palla̱k ɗe bagaa ga̱ wul wonti. Te sut mala̱nni ta̱k tla ta̱mi mbadl ga̱ ba boo gwa!> ");
INSERT INTO gyz_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","<<Yek ma̱lgwe kan wulpi ngura zinariya ɗe na̱m wu tuli. Yek ta̱ dla̱m ɗe, <Ba boo, a yisi ɗe ki wo wunda̱l ma̱lgwe ba̱ mbala̱n a yis gaa gwas sowu ka̱n, a ka̱ wotl zhin ka̱ lu gwe ba̱ka̱ ɓak sowu, a ki wo ma̱n lamti wul ga̱ ten koo lu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Na̱k gwisi ka̱ laki yek ɓanti cinni yek a sak ɗuk shu ka̱ atli, yek a hwunda̱l ngura zinariya gwa ka a giɓi. Ningo kan il gwa.> ");
INSERT INTO gyz_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","<<Yek ba boo gwas wulti ɗe, <Ki wo byas zhel ma̱n laka̱l! Ashe ka̱ yisi ɗe ami wo a wotl zhin ka̱ lu gwe ba ɓak sowu, a mo wul ka̱ lu gwe ba̱ cat wunda̱l so gwa? ");
INSERT INTO gyz_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ai da ka lakini nini wulpi gi ka̱ banki, kangwe ɗe ba pal wugo a mbi mba̱lti ten gaami wu.> ");
INSERT INTO gyz_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","<<Yek ba boomi wuli ɗe, <Kama̱n wulpi ɗa̱ka̱ ang gwas ka, ta̱k ba̱la̱n ma̱n ngura ɗe kutl wu. ");
INSERT INTO gyz_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ten ɗe mas ma̱lgwe ilgon niɗɗa̱ go sa mba̱liti ta̱s mbi nal. Ama ma̱lgwe ilgon niɗɗa̱ sowu go, na̱k ilgwe niɗɗa̱ wu mago sa kamit ɗa̱ ang ka. ");
INSERT INTO gyz_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ningo laka̱n zhel ga̱ ten koo lu wu, te ka̱ duu da̱mshal ka. Aduk ka̱n ta kuli ata̱ as ang bi.> ");
INSERT INTO gyz_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<Sa'i gwe yen ga̱ mbala̱n a tul ka̱ nalti gwasi suk mas mil shinti ji Nya wu, ta da̱m ka̱ gobdlan guu gwas ma̱n nalti. ");
INSERT INTO gyz_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Sa moo mas mbala̱n ji dii atl a cina gwasi, ta hwulsi kak-kak na̱k kangwe a ma̱n kyo hwul mba̱la suk mal wu. ");
INSERT INTO gyz_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta wut mba̱le tu ten ang shinti, ata̱ wut mali tu ten ang yali gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","<<Apaa guumi wul ma̱jwe sa̱ ni tu ten ang shinti gwas wu ɗe, <La̱n teɗi, kii ɗe Aba pa̱likii albarka wu! Kama̱n guu gwe sa̱ shiryekii tun ba̱sa̱ ɓo pa̱l dii atl sowu. ");
INSERT INTO gyz_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ten ɗe kuza̱n tloni yek ka̱a̱ ba̱la̱n ilga̱ nguki, a ka̱lka̱ze tloni yek ka̱a̱ ba̱la̱n ze yek a tla, a ni ɗe ma̱nda̱ki yek ka̱a̱ kama̱n ka̱ lubii gwaka̱n, ");
INSERT INTO gyz_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ɗe luka̱l ni ɗa̱ sowu yek ka̱a̱ ba̱la̱n luka̱l, a pa̱l cwo yek ka̱a̱ ga̱ɓeni, ani ga̱ le ka yek ka̱a̱ sa yenti gini.> ");
INSERT INTO gyz_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","<<Apaa ma̱n pa̱lti wul ndakce ballit ɗe, <Bagaa, a gasi ka̱n ma̱ yenki a kuza̱n na̱ma tlot gwa yek ma̱ ba̱lki ilga̱ nguki, sogo a ka̱lka̱ze na̱ma tlot gwa yek ma̱ ba̱lki ze yek ka̱ tla gwi? ");
INSERT INTO gyz_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A agasi ka̱n ma̱ yenki aka̱ ni ɗe ma̱nda̱ki yek ma̱ kanki ka̱ lubii ga̱na̱n, sogo a ba̱ luka̱l nik ɗa̱ so yek ma̱ ba̱lki luka̱l gwi? ");
INSERT INTO gyz_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A gasi ka̱n ma̱ yenki aka̱ na̱ma cwo sogo ga̱ le ka yek ma̱ sak yenki gwi?> ");
INSERT INTO gyz_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","<<Guumi a ballisi ɗe, <Gem amik ka hwiki ge, na̱k ɗe ka̱a̱ pa̱li na̱k mil yilkeni ji jee go, ami ka̱n ka̱a̱ pa̱lini.> ");
INSERT INTO gyz_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","<<Apaa guumi wul ma̱jwe sa̱ ni tu ten ang yali gwas wu ɗe, <Tli ɗa̱ mala̱n ka, kii ɗe bi nikii gaa wu, te teka̱ buu wutu gwe ba̱ a mba̱shdli sowu gwe sa̱ pa̱li sheɗan suk mil shinti jwas ju. ");
INSERT INTO gyz_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ten ɗe kuza̱n tloni yek ba̱ka̱a̱ ba̱la̱n ilga̱ nguki so, a ka̱lka̱ze tloni yek ba̱ka̱a̱ ba̱la̱n ze yek a tla so, ");
INSERT INTO gyz_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","a ni ɗe ma̱nda̱ki yek ba̱ka̱a̱ kama̱n ka̱ lubii gwaka̱n so, ɗe luka̱l ni ɗa̱ sowu yek ba̱ka̱a̱ ba̱la̱n luka̱l so, a pa̱l cwo yek ba̱ka̱a̱ kula so, ani ka̱ lu leti ka yek ba̱ka̱a̱ sak yena̱n so.> ");
INSERT INTO gyz_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","<<Si mago, sa ballit ɗe, <Bagaa, a gasi ka̱n ma̱ yenki a kuza̱n na̱ma tlot gwa yek ba̱ma̱ ba̱lki ilga̱ nguki so, sogo a ka̱lka̱ze na̱ma tlot gwa yek ba̱ma̱ ba̱lki ze yek ka̱ tla so, sogo aka̱ ni ɗe ma̱nda̱ki yek ba̱ma̱ kanki ka̱ lubii ga̱na̱n so, sogo a ba̱ luka̱l nik ɗa̱ so yek ba̱ma̱ ba̱lki luka̱l so, sogo aka̱ na̱ma cwo sogo aka̱ ni ga̱ le ka yek ba̱ma̱ sak yenki so gwi?> ");
INSERT INTO gyz_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","<<Apaa ta̱ ballisi ɗe, <Gem amik ka hwiki ge, na̱k ɗe ka̱a̱ nge pa̱lti na̱k mil yilkeni ji jee wu, ami ka̱n ka̱a̱ nge pa̱lti.> ");
INSERT INTO gyz_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","<<Ma̱ jimi a te ka̱ bal bomti gwe ba̱ pakti niɗɗa̱ sowu, a ma̱n pa̱lti wul ndakce te ka̱ da̱mti gwe a paki sowu.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ɗe Yesu pak dla̱mti mas ga̱ɓa jimi wu, yek ta̱ wul mil lishti jwas ɗe, ");
INSERT INTO gyz_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Ka̱a̱ yisi ɗe biki ɗakciti wo multi ɗe lop ka̱ ɓali, asa ba̱l Yen ga̱ Mbala̱n ta̱s pakti ten guda̱l yencin.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yek kiɗi ma̱n Pa̱ris suk bacina ji mbala̱n mogaa ka̱ lubii ga̱ bali ga̱ ma̱n pa̱lti wul ka̱ biimi gwe asa̱ mbet ɗe Kayapas wu, ");
INSERT INTO gyz_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","yek sa̱ dla̱lli ga̱ɓa ten kangwe sa pi asa̱ dop Yesu asa̱ tlot ka mbukli wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ama yek sa̱ wuli ɗe, <<Ba̱ ɗe ka̱ sa'i biki so, sogo mbala̱n a tlil dlanti.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","To a Yesu ni ka̱ ba̱n Betani ka̱ lubii ga̱ ma̱lgwe asa̱ mbet ɗe Siman ma̱n gita wu, ");
INSERT INTO gyz_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","yek kili gon tul malti na̱ bunta̱n mili gwe sa̱ pa̱li na̱ ye onis wu, bunta̱mi ni ga̱ njikmi na̱ mil ma̱n ta̱mi wusa̱n ma̱n wulpi i'e. Ɗe Yesu ɓa nguk wul wu, yek ta̱ shotit mili sut ten gaa. ");
INSERT INTO gyz_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ama ɗe mil lishti jwas yeni nu wugo yek mbadl lilisi yek sa̱ wul yilkeni jwasa̱n ɗe, <<Ai, go lilti wul ka ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ten ɗe sa wulla̱n mil ga̱n ka̱ go, ai sa mbi bal wulpi asa̱ hwuli ma̱n la̱shi wul.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na̱k ɗe Yesu yis ilgwe sa̱ na̱ma dla̱mti wu, yek ta̱ wulsi ɗe, <<Yek laki ɗe ka̱a̱ na̱ma hwotti ga̱ kili ga̱n ye? Ai hwa wul ka̱n ta̱ pa̱lini. ");
INSERT INTO gyz_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ma̱n la̱shi wul ni ɗa malkii ko a gasi, ama ami wo ko a gasi ka̱n bani sukkii so. ");
INSERT INTO gyz_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Mil ga̱n ɗe ta̱ shoti gaa wu, shiryat ka̱n ta̱ shirya dli gini ten ɗe ta̱s leɓa̱nni. ");
INSERT INTO gyz_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gem amik ka hwikii ge, mas lu gwe sa lak icin ga̱ ta̱mi ga̱ɓa ga̱n ten dii atl go se sa̱ dla̱m ilgwe kili ga̱n pa̱li wu ten bi daamti gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yek gon ka̱ mil shinti ɗe kutl cet lop ju, gwe asa̱ mbet ɗe Yehuda Iskariyoti wu li mal kiɗi ma̱n Pa̱ris, ");
INSERT INTO gyz_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","yek ta̱ ngemsi ɗe, <<Kume a ba̱lkii ti go yek kaa ba̱la̱n ye?>> Yek sa̱ ba̱lti wulpi hwol ga̱lla ɗe kutl ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tun tet ka̱ sa'i gwisi yek ta̱ njel ngot tantu gwe ta koɓi ta̱s ba̱lsi Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ten cin na ɗe na̱m ga̱ Motgaa Burodi Ma̱n La̱shi Yis, yek mil lishtisi tul mal Yesu yek sa̱ wulti ɗe, <<A ako ka̱n ka̱ lami ɗe ta̱n shiryek ngukti wul Biki Ɗakcitisi ko?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yek ta̱ ballisi ɗe, <<Te ka̱ ba̱n mal ma̱lgon aka̱a̱ wulti ɗe, <Ma̱n lishti dla̱m ɗe, sa'i gwas ɓal njaa. Ta nguk wul Biki Ɗakciti suk mil lishti jwas a lubii ɗakka.> >> ");
INSERT INTO gyz_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yek mil lishtisi pa̱li na̱k gwe Yesu zisi wu, yek sa̱ sak shiryesi ilga̱ nguki ga̱ Biki Ɗakcitisi. ");
INSERT INTO gyz_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɗe sukti ka̱ ɓal ɗe nguktisi ka̱ ɓal wu, yek Yesu da̱m na̱ zhila suk mil lishti ɗe kutl cet lop ju ta̱s nguki. ");
INSERT INTO gyz_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Sa̱ na̱ma ngukti wuli nugo yek ta̱ wulsi ɗe, <<Gem amik ka hwikii ge, ɗe na̱m tet ka̱ kii a ba̱l bi gini.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yek ili hwotsi i'e, yek sa̱ ngusit wulti ɗe, <<Ko ami ka̱n, Bagaa?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yek ta̱ ballisi ɗe, <<Ma̱lgwe na̱ma sulti ang suk ami ka̱ gal wu ka̱ɗe ma̱n ba̱lti bi gini. ");
INSERT INTO gyz_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yen ga̱ Mbala̱n a ma̱shi na̱k kangwe sa̱ lish ga̱ɓa tenti wu, ama ma̱lgwe a ba̱l bi gwas wu da̱m ɗe wul cit gonti wi! Sa za̱t so mago, da a maniti.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yek Yehuda, ma̱lgwe ba̱l bi gwas wu dla̱m ɗe, <<Ma̱n Lishti, ko ami ka̱n?>> Yek Yesu nda̱kit ɗe, <<Ka̱ dla̱m na̱ bi gwa wi ɗe ki ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Asa̱ na̱ma ngukti nu wu yek ta̱ kan burodi yek ta̱ pi godiya Nya yek ta̱ cac-cali, yek ta̱ ba̱l mil lishti jwasi yek ta̱ wulsi ɗe, <<Kama̱nni ta̱k nguka̱nni. Ga̱n go tlu dli gi ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yek ta̱ kan yen mbuke yek ta̱ pi godiya Nya yek ta̱ takisi yek ta̱ wule, <<Tlani mas jwaska̱n. ");
INSERT INTO gyz_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ga̱n go hwulan gi ka̱n, gwe yek ɗe pyal dla̱lla̱t ga̱ɓa wu. Hwulan gwe sa̱ shoti ten ɗe ta̱ mbala̱n wonti mbi taasti byas wul jwasa̱n ka̱ ɗa̱ wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A ni kii ma hwiti ɗe, ndok ten ge ba po tla ze inabi so se gas gwe ba tla pyal zesi gon sukkii ka̱ guu ga̱ Aba gi wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ɗe Yesu suk mil lishti jwas wul koo wu, yek sa̱ yili, yek sa̱ to ten Za̱nda̱l Tla̱nda̱l Zetun. ");
INSERT INTO gyz_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yek Yesu hwisi ɗe, <<Kaa aɓi mas jwaka̱n aka̱a̱ zaka̱n ka̱ gas ge, ten bi ilgwe a pi na̱ ami wu. Na̱k gwe ni ga̱ lishi ɗe, << <Ba ɓo ma̱n kyoɓi, a tunga mba̱la jwas cat ka̱.> ");
INSERT INTO gyz_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ama kume a pal kaami wugo, ba li Galili cina ɗaakii.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yek Biturus wulti ɗe, <<Ko ta̱s ap ka mas jwasa̱n ten bi ga̱ ilgwe a mbik wu mago, ami wo ba ap so.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yek Yesu ballit ɗe, <<Gem amik hwik ge, ka nge yisti gini asa̱mi ɗe mekan ka̱ gas ga̱n a paa gunda kol nda lakti yal.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Yek Biturus dla̱m ɗe, <<Ko ta̱ ma̱shka̱n ka̱n ba ma̱sh sukki, ba nge yisti gwa so.>> Yek mas mil lishtisi dla̱m na̱k gwas wu pak. ");
INSERT INTO gyz_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yek paa Yesu suk mil shinti jwas li ka̱ lu gwe asa̱ mbe ɗe Getsa̱mani wu, gwe yek ɗe lu cetti mil Zetun wu. Yek ta̱ wulsi ɗe, <<Da̱ma̱n aɗe ami wo ba tok ngem Nya to du.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yek ta̱ kan Biturus suk mil ɗe lop ji Zabadi ju, ka̱a̱ Yakubu suk Yohana, yek ta̱ njel pa̱lti duu tuki yek ta̱ hwotdli i'e. ");
INSERT INTO gyz_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yek ta̱ wulsi ɗe, <<Duu tuk gwe ni ka̱ mbadl gi wu a man tlot gini. Da̱ma̱n aɗe suk ami, ba̱k ndema̱n yemba̱l so.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yek ta̱ nak ɗam ɗa̱ malsi ka njet, yek ta̱ ngus atli yek ta̱ ngem Nya. Yek ta̱ wule, <<Aba gini, kume ɗe ma̱n pa̱t ka̱ wu, kami mbuka bomti ga̱n ka. Ko ɗe ba̱ ɗe ilgwe a lami wu ka̱n a pa̱li sowu, ama ta̱ pa̱l ilgwe ka̱ lami wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yek ta̱ pal tet mal mil lishtisi yek ta̱ mbisi ten ndet yemba̱l. Yek ta̱ ngem Biturus ɗe <<Ashe kaa mana̱n da̱mti kaami suk ami ko ta̱ ga̱ sa'i ɗe na̱m sa?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yek ta̱ wulsi ɗe, <<Da̱mti kaami ta̱k ga̱ɓa suk Nya, kangwe kaa te ka̱ cinga̱lti so wu. Shishi lami ama dli gwaka̱n ka̱ nda̱l so.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yek ta̱ pal to ka asa̱mi na lop yek ta̱ ga̱ɓa suk Nya yek ta̱ wule, <<Aba gini, kume ni ngetli ɗe ta tla mbuka bomti ga̱n wu. To, ta̱ ilgwe ka̱ lami wu pi.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɗe ta̱ po pal tet wu, yek ta̱ mbisi ten ndet yemba̱li ɗa, na̱k ɗe gwel jwasa̱n njika̱n ka na̱ yemba̱l wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yek ta̱ zaksi ka̱li, yek ta̱ po pal te ka asa̱mi na mekan yek ta̱ ga̱ɓa suk Nya yek ta̱ kaɓa̱l ga̱ɓa gwe ta̱ dla̱m tet wu ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yek paa ta̱ pal te mal mil lishtisi ka yek ta̱ hwisi ɗe, <<Hal ninge ka̱a̱ yima ndet yemba̱l aka̱a̱ na̱ma shukti ya? To, ningo sa'isi pi wi, sa tak Yen ga̱ Mbala̱n ka̱ ang ga̱ ma̱n pa̱lti byas wul. ");
INSERT INTO gyz_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tla̱nnya, ta̱n za̱ngaa! Ma̱n ba̱lti bi gi ka̱ ɓal tet wu!>> ");
INSERT INTO gyz_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ta̱ nisi ma ga̱ɓa nugo yek Yehuda, gon ka̱ ma̱n kopti jwas ɗe kutl cet lop ju mbuk lu tet malsi. Yehude tul suk wonti mbala̱n ma̱n kiɗi puka, suk sanda ɗa̱n ang jwasa̱n ka. Ma̱jwe kiɗi ma̱n Pa̱ris suk bacina ji mbala̱n ka̱ shinsi tet wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","To, ma̱n ba̱lti bisi dla̱lli lal suksi ten ɗe, <<Ma̱lgwe a njop bi gi ten kalka̱ng gwas wu ka̱ɗe ma̱li! Doɓa̱nti.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yehuda na̱ma mbukti lu, yek ta̱ lak ngip Yesu te dlo ka yek ta̱ wulti ɗe, <<Sallama gwa, Ma̱n Lishti!>> Yek pa ta̱ njop bi gwas ten kalka̱ng gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yek Yesu ballit ɗe, <<Yela̱n gini, pa̱l ilgwe tulla̱k wu.>> Yek wonti mbala̱n ɗam teɗi, yek sa̱ dop Yesu yek sa̱ ngipti. ");
INSERT INTO gyz_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Sa̱ yeni nu wugo, yek gon ka̱ mbala̱n jwe sa̱ ni suk Yesu wu, yilli bal puka. Yek ta̱ wotl zhel ga̱ bal ma̱n Pa̱ris te ka̱ng ka, yek ta̱ kotlit ka̱ng ka. ");
INSERT INTO gyz_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yek Yesu wulti ɗe, <<Palli bal puka gwa ka̱ ka̱pta̱mi, na̱k ɗe mas ma̱lgwe kan bal puka go, bal puka ka tlot wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ka̱a̱ da̱ma̱n gwa we ba lami go ba ga̱ɓa suk Aba gini ata̱ zi-ang, ata̱ shini lu na̱ mil shinti jwas wonti man motgaa ga̱ ma̱n hapti dlo ɗe kutl cet lop sa? ");
INSERT INTO gyz_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ama ɗa̱ ni ka̱n a njika̱n ilgwe ga̱ɓa ga̱ Nya dla̱m ɗe ngetli ka̱n ta̱ pi wu gwi?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka̱ sa'i gwisi wo yek Yesu wul wonti mbala̱mi ɗe, <<Ka̱a̱ li tet na̱ kiɗi puka suk sanda ta̱k doɓa̱nni nini, ma̱n ɓa̱tti tantu ka̱ɗe ami a? A da̱m na̱ zhila ko gasi gwik-gwi ka̱ lubii ga̱ Nya, yek a mboki ang mbala̱n ten ga̱ɓa ga̱ Nya ama yek ba̱ka̱a̱ doɓa̱n so. ");
INSERT INTO gyz_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ama mas wul jin pi, ten ɗe ta̱ lishti ji ma̱n dla̱mti ga̱ɓa ji Nya njika̱n ɗa.>> Na̱ kumti na̱k gwisi yek mil lishti jwas zakti yek sa̱ ap ka. ");
INSERT INTO gyz_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yek ma̱jwe dop Yesu ju ta̱lat mal Kayapas, bacina ga̱ ma̱n Pa̱ris, ka̱ li ka̱n ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa suk kiɗi ji mbala̱n mogaa. ");
INSERT INTO gyz_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ama yek Biturus ngusi kopti gwasa̱n tet dlenti, hal yek ta̱ lak mbuki ka̱ dii boo lubii ga̱ bacina ga̱ ma̱n pa̱lti wul ga̱ lubii ga̱ Nyami. Yek ta̱ da̱m atl mal ma̱n ɓa̱tti lubii ga̱ Nya ta̱s yen ilgwe a pi wu. ");
INSERT INTO gyz_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Yek ma̱n Pa̱ris suk ma̱n da̱mti dlaboo Sanhidirin ngusi ngot lal gwe sa sheli Yesu gaa ta̱s man tlot gwas ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ama yek ba̱sa̱ mbi ilgwe sa man dla̱mti wu so, ko ɗe mbala̱n wonti shelit lal gaa wu. Ka̱ kaali yek mbala̱n ɗe lop lak yil toɗi ");
INSERT INTO gyz_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yek sa̱ wule, <<Ma̱lga̱n dla̱m ɗe, <Ba man jekti lubii ga̱ Nya ka, a kin lisi ten multi ɗe mekan.> >> ");
INSERT INTO gyz_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yek bacina ga̱ ma̱n Pa̱ris tlinya yek ta̱ wul Yesu ɗe, <<Ka mana̱n balla̱t ilgon sa? A sheda jin ɗe sa̱ na̱ma dla̱mti tenki wu pa?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ama yek Yesu da̱m mbetlak. Yek bacina ga̱ ma̱n Pa̱ris wulti ɗe, <<A mok na̱ shin ga̱ Nya ma̱n mbadli. Dla̱mini, kik ɗe Almasihu yen ga̱ Nya ma?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yek Yesu ballit ɗe, <<Yii, nu ka̱n. Ama amik ka hwikii ge, ndok ase kaa yen Yen ga̱ Mbala̱n ta̱ da̱m ten ka̱t ang shinti ga̱ Nya Ma̱n Ikosi ten tulti ka̱ kaluntun ka̱ dlo nya.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yek bacina ga̱ ma̱n Pa̱rismi kesh luka̱l jwas ka na̱ lilti mbadli, yek ta̱ wule, <<Ka̱a̱ kum ga̱ɓa cutgaa suk Nya gwe ta̱ dla̱m wu wi! Sheda yek ma̱ yima ɓa̱tti ye? Ningo ka̱a̱ kum ga̱ɓa cutgaa suk Nya tet bi gwas wi. ");
INSERT INTO gyz_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Yek ɗe daamti gwaka̱n a dani ye?>> Yek sa̱ ballit ɗe, <<Mbun ɗe ta̱ tlot ka.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yek sa̱ ba̱zet ɓaka̱n ten cina gwel, yek sa̱ ɓok-ɓoti, yek jon jwasa̱n ɓet kalka̱ng, ");
INSERT INTO gyz_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","asa̱ na̱ma wulti ɗe, <<Ɓo hwini ga̱ɓa ga̱ Nya ɗe kume kik ɗe Almasihu wu, dla̱mini ma̱lgwe ɓok wu?>> ");
INSERT INTO gyz_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ka̱ sa'i gwisi wo a Biturus ni na̱ zhila ka̱ gip boomi nugo, yek ɗe na̱m ka̱ mil modli jwe asa̱ pa̱l wul ka̱ lubiimi wu li malti, yek ta̱ wulti ɗe, <<Ki mago suk Yesu ma̱n Galili wu ka̱n ka̱ ni.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yek Biturus nge yisti ga̱ Yesu a cina ɗa̱ mas jwasa̱n ka, yek ta̱ wule, <<Ami wo a yis ga̱ɓa gwe ka̱ na̱ma dla̱mti wu so.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yek ta̱ yil to dlaboo ka, yek yen kili gon po yenti ɗa, yek ta̱ wul ma̱jwe ni ka̱li wu ɗe, <<Ma̱lga̱n ni suk Yesu ba Nazarat.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yek Biturus po nge yisti ɗa, hal yek ta̱ mo ga̱ɓa na̱ Nya, yek ta̱ wule, <<Ami wo a yis ma̱li so!>> ");
INSERT INTO gyz_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Po la̱m da̱nti wugo, yek ma̱jwe na̱ma dla̱lti ka̱li wu li mal Biturus, yek sa̱ wulti ɗe, <<Ki mago gon gwasa̱n ka̱n. Kangwe aka̱ ga̱ɓa wu ɓulik gal ɗa̱ gaa ka̱ wi.>> ");
INSERT INTO gyz_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yek Biturus njeli pa̱lti bi gaa gaa gwasi, ata̱ na̱ma mot ga̱ɓa na̱ Nya ten wulti ɗe, <<A yis ma̱li so!>> Ta̱ na̱ma dla̱mti nugo yek gunda kol lak yal. ");
INSERT INTO gyz_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yek Biturus daam ga̱ɓa gwe Yesu hwit wu, <<Ka nge yisti gini asa̱mi ɗe mekan a paa gunda kol nda lakti yal.>> Yek Biturus yil deɓa̱l yek ta̱ kul i'e. ");
INSERT INTO gyz_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Lu tlo wugo, yek kiɗi ma̱n Pa̱ris suk bacina ga̱ mbala̱n dla̱lli ga̱ɓa ɗe ta̱s tlo Yesu ka. ");
INSERT INTO gyz_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yek sa̱ ɓalti ka, yek sa̱ yilla̱t deɓa̱l yek sa̱ ta̱lat mal Bilatus gobna. ");
INSERT INTO gyz_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ɗe Yehuda ɗe tik ba̱l bi gwas wu yeni ɗe sa̱ dla̱lli ga̱ɓa ɗe sa tlo Yesu ka̱wu, yek ta̱ pa̱l duu tuk na̱ gaa gwasi. Yek ta̱ pal tet mal kiɗi ma̱n Pa̱ris suk bacina ga̱ mbala̱mi, yek ta̱ pallisi wulpi hwol ga̱lla ɗe kutl ɗe mekami. ");
INSERT INTO gyz_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Yek ta̱ wulsi ɗe, <<A pa̱l byas wul wi, a ba̱l bi ga̱ ma̱lgwe ba̱ta̱ pa̱l byas ilgon sowu ten ɗe ta̱ tlot ka.>> Yek sa̱ ballit ɗe, <<Yek ɗe biki ga̱na̱n ye? Go ai ki ka̱n hwotki.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yek Yehuda shot wulpi ka ka̱ lubii ga̱ Nyami yek ta̱ zak luisi. Yek ta̱ zigaa yek ta̱ sak lak zaa yal yek ta̱ tlo gaa gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Yek kiɗi ma̱n Pa̱ris yem wulpi, yek sa̱ wule, <<Mbun ɗe ta̱n wutta̱n wulpi ga̱n ka̱ lu mot wulpi ga̱ lubii ga̱ Nya so, na̱k ɗe wulpi hwulan ka̱ wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yek sa̱ moo bi gwasa̱n yek sa̱ dla̱lli ga̱ɓa a dani, yek sa̱ wul lu ga̱ ma̱n kinti cikɗa na̱ wulpi, ten ɗe ta̱s ngusi lepti ji ma̱nda̱ki ka̱li. ");
INSERT INTO gyz_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ten na̱k gwisi ka̱ laki asa̱ mbe lu gwisi ɗe Lu Hwulan hal cin ga̱ ase. ");
INSERT INTO gyz_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Na̱ nu ka̱n ga̱ɓa gwe Irimiya ma̱n dla̱mti ga̱ɓa Nya dla̱m wu njika̱n. Ga̱ɓa gwe wule, <<Yek sa̱ kan wulpi hwol ga̱lla ɗe kutl ɗe mekan, wulpi gwe ma̱n Yisiraila pa̱l ga̱m gwas ɗa̱ wu, ");
INSERT INTO gyz_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","yek sa̱ wul lu ga̱ ma̱n kinti cikɗa na̱ nali na̱k gwe Nya dla̱lli ɗe ta̱ pi tena̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","To, ka̱ sa'i gwe Yesu ni cina ga̱ gobna wu, yek gobne ngemti ɗe, <<Kik ɗe guu ga̱ ma̱n Yehuda nwa?>> Yek Yesu ballit ɗe, <<Yii, nu ka̱n ni.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ama sa'i gwe kiɗi ma̱n Pa̱ris suk bacina ji mbala̱n dla̱mit byas wul gaa go, yek ba̱ Yesu wule ilgon so. ");
INSERT INTO gyz_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yek Bilatus ngemti ɗe, <<Ka̱ kuma̱n byas wul jwe sa̱ zik gaa wu sa?>> ");
INSERT INTO gyz_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ama yek ba̱ Yesu ballit ɗe ilgon so, yek ili ci ɓanti gobne i'e. ");
INSERT INTO gyz_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","To, ka̱ sa'i Biki Ɗakcitisi wo, gobna ku na̱ ɓulti ma̱l ga̱ le ka ɗe na̱m gwe mbala̱n botli wu wi. ");
INSERT INTO gyz_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ka̱ sa'i gwisi wo a ma̱l ga̱ le ka gon gwe mbala̱n yisti i'e wu ni ang, ma̱lgwe asa mbet ɗe Barabas wu. ");
INSERT INTO gyz_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ɗe mbala̱mi mogaa wu, yek Bilatus ngemsi ɗe, <<Gwik ka̱a̱ lami ɗe ta zakti gwi, Barabas a, sogo Yesu ɗe asa̱ mbet Almasihu wu?>> ");
INSERT INTO gyz_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Na̱k ɗe Bilastus yisi ɗe daka̱lti ka̱ laki yek sa̱ tulli Yesu a malti wu. ");
INSERT INTO gyz_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A Bilastus ni ga̱ da̱mi na̱ zhila ten gobdlan kisti ga̱ɓa nugo yek kili gwas shinlu ɗe ta̱s wulti ɗe, <<Yil ɗa̱ka̱ tantu ga̱ ma̱l wu ɗe ba̱ta̱ pa̱l byas ilgon sowu ka, na̱k ɗe a ci ka̱ dli i'e na̱ tlunka̱t tenti wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ama yek kiɗi ma̱n Pa̱ris suk bacina ji mbala̱n cok mbala̱mi ɗe ta̱s wule ɗe ta̱s zak Barabas ta̱s tlo Yesu ka. ");
INSERT INTO gyz_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yek gobne ngemsi ɗe, <<Gwik ka̱a̱ lami ɗe ta zakikii ti ka̱ mbala̱n ɗe loɓi jwi?>> Yek sa̱ ballit ɗe, <<Barabas,>> ");
INSERT INTO gyz_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yek Bilatus ngemsi ɗe, <<A yek ba pa̱li na̱ Yesu ɗe asa̱ mbet ɗe Almasihu wu ye?>> Yek sa̱ ballit ɗe, <<Ɓakti ka ten guda̱l yencin!>> ");
INSERT INTO gyz_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yek ta̱ ngemsi ɗe, <<Ten ɗe yek ke? Byas wul yek ta̱ pa̱li ye?>> Ama yek sa̱ mba̱l yal gwasa̱n ten wulti to nya ka̱ɗe, <<Ɓakti ka ten guda̱l yencin!>> ");
INSERT INTO gyz_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bilatus yeni ɗe ta man pa̱lti ilgon dani so, a yekgu mbala̱mi ɓa lam tlilti dlanti wu, yek ta̱ kan ze yek ta̱ pol ang gwas ka ten yenti ga̱ gwel ga̱ mbala̱mi ata̱ na̱ma dla̱mti ɗe, <<Ami wo ze gi ni ka̱ alhaki ga̱ hwulan ga̱ ma̱n la̱shi pa̱lti byas wul ga̱n so, go ze gwaka̱n ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Yek mas mbala̱mi ballit ɗe, <<Ha̱n ta̱ alhaki ga̱ hwulan gwas ni ten gaa ga̱na̱n mi suk mil jina̱n.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yek ta̱ zakisi Barabas. Yek ta̱ laki yek sa̱ ɓo Yesu, yek paa ta̱ ba̱lsiti ɗe ta̱s ɓakti ka ten guda̱l yencin. ");
INSERT INTO gyz_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kaal na̱k gwisi, yek ma̱n hapti dlomi ji gobna ta̱la Yesu ka̱ pada ga̱ gobne, yek sa̱ mwet motgaa ji ma̱n hapti dlo ga̱ atli gaa. ");
INSERT INTO gyz_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yek sa̱ ndusit wul ɗa̱ ten dli ka yek sa̱ lakit zil luka̱l gon wunda̱li ji guu, ");
INSERT INTO gyz_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","yek sa̱ pa̱l tagiya guu gon na̱ ili yek sa̱ kinit gaa, yek sa̱ lakit sanda ka̱ ang shinti gwasi, yek sa̱ ngusi ngusti a cina gwasi asa̱ nitma wulti ga̱ɓa mbulti ɗe, <<Na̱ nalti gwa, guu ga̱ ma̱n Yehuda!>> ");
INSERT INTO gyz_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yek sa̱ ba̱zet ɓaka̱n, yek sa̱ kan sande yek sa̱ ngusit ɓot gaa ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ɗe sa̱ wulit ga̱ɓa mbultisi paki wu, yek sa̱ ndusit zil luka̱li ka, yek sa̱ lakit luka̱l gwas lisi. Yek sa̱ zigaa sukti ten ɗe sa sak ɓakti ka ten guda̱l yencin. ");
INSERT INTO gyz_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sa̱ na̱ma za̱tgaa nugo yek sa̱ mo suk ma̱n Sayirin gon, ma̱lgwe asa̱ mbet ɗe Siman wu, yek sa̱ zit ngetli ɗe ta̱s kan guda̱l yencin gwe sa ɓak Yesu ka a dani wu. ");
INSERT INTO gyz_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Yek sa̱ mbuki ka̱lu gwe asa̱ mbe ɗe Golgota, gwe yek ɗe Is Gaa wu. ");
INSERT INTO gyz_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yek sa̱ ba̱l Yesu ze inabi ga̱ kutltli suk yoki ilgon ɗe ta̱s tla, ama ta̱ lami ɗe ta̱ kum yokit ɗu go yek ta̱ nge tlati. ");
INSERT INTO gyz_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ɗe sa̱ ɓakti ka ten guda̱l yencin wu, yek sa̱ lak guria ten ɗe ta̱s hwul luka̱l gwas ɗa. ");
INSERT INTO gyz_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ka̱ kaali wo, yek sa̱ da̱m na̱ zhila ka̱li yek sa̱ ngusi ɓa̱tti gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yek sa̱ zi lishti gwe dla̱m byas ilgwe ta̱ pa̱li wu dap ten gaa gwasi, gwe sa̱ lishi ɗe: GA̱N GO TIK ƊE YESU, GUU GA̱ MA̱N YEHUDA. ");
INSERT INTO gyz_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yek sa̱ ɓak muka̱l ma̱n ɓa̱tti tantu ɗe lop jon ka ten guda̱l yencin sukti, gon wo ten ka̱t ang shinti a gon wo ten ka̱t ang yali gwasi. ");
INSERT INTO gyz_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yek ma̱n kopti tu ka̱li ngusit wulti ga̱ɓa mbulti asa̱ na̱ma wotlti gaa jwasa̱n, ");
INSERT INTO gyz_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","yek sa̱ ngusi wulti ɗe, <<Ki ɗe ka̱ dla̱m ɗe ka jek lubii ga̱ Nya ka aka̱ kin lisi ka̱ multi ɗe mekan wu! Kis gaa gwa la! Kume ki wo yen ga̱ Nya ke ki wu, yil sut ɗa̱ ten guda̱l yencimi ka̱ la!>> ");
INSERT INTO gyz_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Na̱k gwisi ka̱n kiɗi ma̱n Pa̱ris suk ma̱n yisti mba̱t ga̱ɓa ga̱ Musa suk bacina ji mbala̱n wulit ga̱ɓa mbulti. ");
INSERT INTO gyz_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Yek sa̱ wuli ɗe, <<Ta̱ kis naa mbala̱n, ama yek ba̱ta̱ kis gaa gwas dani so. Kume ti wo guu ga̱ ma̱n Yisiraila ka̱ go ta̱s yil sut ɗa̱ ten guda̱l yencimi ka̱ la, apaa ma̱ ba̱l gem na̱ ti. ");
INSERT INTO gyz_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ta̱ nga̱sti ten Nya, ha̱n ta̱ Nyami kisti ninge ɗe ta̱mit ɗa̱ wu, na̱k ɗe ta̱ dla̱m ɗe, <Ami wo Yen ga̱ Nya ka̱ɗe ami wu.> >> ");
INSERT INTO gyz_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na̱k gwisi ka̱n muka̱l jwe sa̱ ɓaksi ka ten guda̱l yencin sukti ju wulit zobi pak. ");
INSERT INTO gyz_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tun tet ka̱ tlo cin, yek da̱mshal yitla atli ka mas, se na̱k cin celti ta̱ la sa'i ga̱lla ɗe mekan ga̱ ka̱ sukti. ");
INSERT INTO gyz_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ta̱ la sa'i ga̱lla ɗe mekan ga̱ ka̱ sukti go yek Yesu tlil yal gwas nya yek ta̱ wuli ɗe, <<Eloyi, Eloyi, lama sabaktani?>> Ilgwe yek ɗe. <<Nya gini, Nya gini, yek laki yek ka̱ laka̱n ka̱ ye?>> ");
INSERT INTO gyz_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma̱jwe ni ka̱li wu kum ilgwe ta̱ dla̱m wu, wugo yek sa̱ wuli ɗe, <<Ta̱ ɓa mbe Iliya suɗi.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yek gon gwasa̱n yem na̱ apti yek ta̱ kan wushgali, yek ta̱ lak ka̱ ze inabi gwe mbayi wu, yek ta̱ ɓak ten sanda yek ta̱ takit ɗe ta̱s tla. ");
INSERT INTO gyz_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yek naami jwasa̱n wuli ɗe, <<Ɓo zaka̱nti ta̱n ɓo yeni ni, ko Iliya a suk kisa̱nti.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yek Yesu po tlil yal gwas nya ɗa na̱ nda̱lti, yek paa ta̱ kotl mbadl ka. ");
INSERT INTO gyz_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yek labule ga̱ lubii ga̱ Nya kesh su tlo ka, kan sut tu nya hal sut tu atli. Yek atl nwuti yek kiɗi ye tat-tatli. ");
INSERT INTO gyz_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yek gazukɗi ɓu-ɓuli yek mbala̱n ji botli jwe ma̱sh wu wonti pal kaami. ");
INSERT INTO gyz_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yek sa̱ yil tot ɗa̱ka̱ gazukɗi jwasa̱n ka, ɗe Yesu pal kaami tot ka̱ gazukɗi wu, yek sa̱ li ka̱ ba̱n ma̱n cilti ga̱ Nya yek sa̱ ngusi mbok ang ten gaa jwasa̱n mal mbala̱n wonti. ");
INSERT INTO gyz_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ka̱ sa'i gwe bal ma̱n hapti dlo ga̱ Roma suk ma̱jwe sa̱ na̱ma ɓa̱tti gwas wu yen kangwe lu nwuti suk mas wul jwe pi wu wu, yek ɓanti cisi i'e yek sa̱ dla̱m ɗe, <<Gem, ma̱lga̱n go yen ga̱ Nya ka̱n!>> ");
INSERT INTO gyz_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ama a wonti modli jon jwe sa̱ kop Yesu tun tet Galili ɗe asa̱ ngusit pa̱lti wul wu. Modli jwisi dla̱l te dlenti ka yek sa̱ ngusi yenti wul jwe na̱ma pa̱t wu. ");
INSERT INTO gyz_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Modli jimi ka̱ɗe ka̱a̱ Maryam ma̱n Maga̱dala, suk Maryam ana ga̱ Yakubu suk Yusupu, suk ana ji mil ji Zabadi ju. ");
INSERT INTO gyz_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɗe sukti pi wugo, yek ma̱n wul ang gon ma̱n Arimatiya, ma̱lgwe shin gwas ka̱ɗe Yusupu wu tuli. Yusupu wo yen lishti ga̱ Yesu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ta̱ li mal Bilatus yek ta̱ ngemti ɗe ta̱s ba̱lti hwu dli ga̱ Yesu yek Bilatus laki yek sa̱ ba̱lti. ");
INSERT INTO gyz_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yek Yusupu kan hwuunisi yek ta̱ lak ka̱ zani leni ma̱n mbunti, ");
INSERT INTO gyz_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","yek ta̱ za̱t ka̱ pyal gazukɗi gwasi, gwe ta̱ ɗuk ka̱ ye wu. Yek ta̱ jek bal ye gon ten bisi yek paa ta̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ama ka̱ sa'i gwisi wo aka̱a̱ Maryam ma̱n Maga̱dala, suk Maryami gon wu ni na̱ zhila tu te duk ɗa̱ gazukɗisi ka. ");
INSERT INTO gyz_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ten cin gwe kop kaali wu, gwe yek ɗe cin gwe kop kaal ga̱ cin pa̱lti shiri wu. Yek kiɗi ma̱n Pa̱ris suk ma̱n yisti Mba̱t Ga̱ɓa ga̱ Musa mogaa mal Bilatus. ");
INSERT INTO gyz_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Yek sa̱ dla̱m ɗe, <<Na̱ nalti gwa, ma̱ daam ilgwe ma̱n gilla̱t mbala̱n ga̱n dla̱m ɗe ta̱ yi kaami wu. Ta̱ wuli ɗe, <Ka̱ kaal ga̱ multi ɗe mekan wo ba pal kaami.> ");
INSERT INTO gyz_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ten na̱k gwisi ka̱n ningo laki ta̱ ɓa̱t gazukɗisi i'e hal se pa̱l multi ɗe mekami. Sogo mil lishti jwas a lak muka̱l hwu gwas ka asa̱ hwi mbala̱n ɗe ta̱ pal kaami wi. Kume pi nu go, gilla̱t gwe sa gilli mbala̱n ka̱ kaali wu a man ga̱ cine na̱ lilti.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Yek Bilatus ballisi ɗe, <<Yema̱n ma̱n hapti dlo, ta̱k suk ɓa̱ta̱n luisi, kan gwe ka man ɓa̱tti wu.>> ");
INSERT INTO gyz_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yek sa̱ sak ɓa̱tti gazukɗisi ka, yek sa̱ ɓo hatimi ga̱ guu ten ye gazukɗisi, yek sa wut ma̱n hapti dlo ten ɓa̱tti luisi. ");
INSERT INTO gyz_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ɗe gas shukti shige wu, ka̱ bultlwe ga̱ gas lahadi, yek Maryam ma̱n Maga̱dala suk Maryam gon wu sa yenti gazukɗisi. ");
INSERT INTO gyz_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yek atl nwuti i'e, ten ɗe yen shinti ga̱ Nya gon yil sut nya. Yek ta̱ sak guda̱l ye ga̱ ten bi gazukɗisi ka, yek ta̱ da̱m ten yesi. ");
INSERT INTO gyz_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yen shinti ga̱ Nyami ngusi cilti na̱k cit bi ga̱ nyaze, a luka̱l gwas wo hwoli pat na̱k apda̱ga. ");
INSERT INTO gyz_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma̱n ɓa̱tti gazukɗisi yenti wugo yek ɓanti gwas cisi i'e, hal yek sa̱ lok te atl ka na̱k ma̱jwe ma̱sh wu. ");
INSERT INTO gyz_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yek yen shinti ga̱ Nyami wul modlisi ɗe, <<Ba̱k ɓanti so, a yisi ɗe Yesu ka̱n ka̱a̱ na̱ma ngot gwasi gwe sa̱ ɓakti ka ten guda̱l yencin wu. ");
INSERT INTO gyz_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ta̱ni aɗe so, ta̱ pal kaami wi na̱k gwe ta̱ dla̱m wu. La̱n teɗi ta̱k yena̱n lu gwe sa̱ mulla̱t atl wu. ");
INSERT INTO gyz_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ningo, la̱n na̱ aniya ta̱k sak hwi mil lishti jwas ɗe, <Ta̱ pal kaami wi, a ningo ta suikii Galili cina. a Galilisi ka̱n kaa yenti.> A mi wo ilgwe tulla̱n wuggu.>> ");
INSERT INTO gyz_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yek modlisi zak gazukɗisi ɓa-ɓa a ɓanti na̱ma cit gwasa̱n, ama a mbadl jwasa̱n njika̱n na̱ hwol tuki, yek sa̱ yem na̱ apti ta̱s sak hwi mil lishti jwasi. ");
INSERT INTO gyz_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yek Yesu na̱ gaa gwas mo suksi yek ta̱ wulisi ɗe, <<Sallama gwaka̱n.>> Yek sa̱ ɗam tet malti yek sa̱ ngip asa̱n gwasi yek sa̱ ngusit atli. ");
INSERT INTO gyz_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yek Yesu wulsi ɗe, <<Ba̱ ɓanti cikii so. La̱n ni ta̱k sak hwi yilkeni ji ɗe ta̱s li Galili, ka̱li ka̱n sa yena̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","A modlisi na̱ma za̱tgaa nugo yek jon ka̱ ma̱n hapti dlo ju te ka̱ ba̱n, yek sa̱ dla̱mi kiɗi ma̱n Pa̱ris mas ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ɗe kiɗi ma̱n Pa̱rismi suk bacina ji mbala̱n pa̱l da̱mti wu, yek sa̱ dla̱lli ga̱ɓa yek sa̱ ba̱l ma̱n hapti dlomi bal wulpi, ");
INSERT INTO gyz_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","yek sa̱ wulsi ɗe, <<Hwi mbala̱n ɗe, <Mil lishiti jwas ka̱a̱ sak muka̱l hwu gwas ka, ka̱ sa'isi wo ama̱ na̱ma ndet yemba̱l.> ");
INSERT INTO gyz_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kume ga̱ɓe mbuki mal gobna go, ma ga̱ɓa sukti kangwe kaa te ka̱ bomti sowu.>> ");
INSERT INTO gyz_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yek ma̱n hapti dlomi kan wulpi, yek sa̱ pa̱li kangwe sa̱ wulsi ɗe ta̱s pa̱li wu. Ga̱ɓa gwisi ka̱n a ma̱n Yehuda dla̱mi, hal cin ga̱ se. ");
INSERT INTO gyz_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","To, yek mil lishti ɗe kutl cet na̱m ju li Galili, yek sa̱ to ten Za̱nda̱l Tla̱nda̱l gwe ta̱ hwisi ɗe ta̱s mogaa ka̱li wu. ");
INSERT INTO gyz_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ɗe sa̱ yenti wu, yek sa̱ ngusit atli. Ama yek jon jwasa̱n tatl mbadl jwasa̱n tenti. ");
INSERT INTO gyz_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yek Yesu ɗam njaa tet malsi yek ta̱ wulsi ɗe, <<Sa̱ ba̱la̱n mas iko to nya ka suk ten dii atl wi. ");
INSERT INTO gyz_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ten na̱k gwisi, ningo sak hwi mas mbala̱n ji dii atl ɗe ta̱s koɓa̱nni, laka̱nsi ta̱s da̱m ɗe mil lishti jini, aka̱a̱ nisi ma pa̱lti baptisma na̱ shin ga̱ Aba suk ga̱ Yen suk ga̱ Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aka̱a̱ nisi ma mbokti ang ɗe ta̱s kop wul jwe a zi kii pa̱lti wu. Yekgu ani sukkii ko agasi hal se cin gwe dii atl a paki wu.>>");
INSERT INTO gyz_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Mbala̱n wonti lish ga̱ɓa ten ilgwe pi ka̱ tlo ga̱na̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Sa̱ lish ilgwe ma̱ kumi mal ma̱jwe yeni na̱ gwel gwasa̱n tet ten ndat zhile wu, a zhel ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ɗe si. ");
INSERT INTO gyz_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yek laki, ami mago a bodla̱l ga̱ɓe i'e wugo, yek a yeni go mbun ɗe ta lishik kangwe ni wu, ma̱n nalti Tiyopolos, ");
INSERT INTO gyz_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ta̱k yisi ɗe ilgwe ka̱ kumi go gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ka̱ gin gwe ɗe Hiridus ni ɗe guu ka̱ atl ga̱ Yehudiya wu, ma̱n Pa̱ris gon, asa̱ mbet ɗe Zakariya, gwe ni ka̱ mbala̱n ga̱ Abija bal ma̱n da̱nti ka̱ bii ngemti Nya ga̱ cina. Shin ga̱ kili ga̱ Zakariya ka̱ɗe Alisabatu, ti mago ma̱n ga̱s ga̱ Haruna bal ma̱n da̱nti ka̱ bii ngemti Nya ga̱ cina wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mas jwasa̱n sa̱ pa̱l hwa da̱nti gwe Nya lami wu, sa̱ kop mba̱t ga̱ Nya na̱k kangwe ta̱ lami ta̱ mbala̱n koɓi wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","A ba̱ mil nisi ɗa̱ so. Na̱k ɗe Alisabatu wo ba̱ ma̱n za̱t yen ka̱ɗe ti sowu, a mas jwasa̱n go sa̱ koli wi. ");
INSERT INTO gyz_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Gas gon Zakariya na̱ma pa̱lti wul ka̱ lubii ga̱ Nya ɗe cin pa̱lti wul gwasa̱n ka̱ bii ngemti Nyami balla̱t tet wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na̱k kangwe a ma̱n Pa̱rismi kul pa̱li wu. Yek sa̱ botl Zakariya ta̱s te ka̱ lubii ga̱ Nyami ta̱s kwel turare ma̱n ta̱mti wusa̱n. Yek ta̱ te giɓi. ");
INSERT INTO gyz_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","A mbala̱n wonti ni deɓa̱l asa̱ na̱ma ngemti Nya ɗe Zakariya na̱ma kwelti turare wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ta̱ ni nugo, yek yen shinti ga̱ Nya ka̱wu ten ka̱t ang shinti a malka̱n lu kwelti turare. ");
INSERT INTO gyz_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yek ɓanti ci Zakariya, ɗe ta̱ yen yen shinti ga̱ Nyami wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yek yen shinti ga̱ Nyami wulti ɗe, <<Ba̱ ɓanti cik so Zakariya, Nya kum ngemti gwe ka̱ ngemti wu yi. Kili gwa Alisabatu a zik yen aka̱ zit shin ɗe Yohana.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","<<Sa za̱t wugo, ka pa̱l hwol tuki, a mbala̱n wonti a pa̱l hwol tuk na̱ za̱t gwas pak. ");
INSERT INTO gyz_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yeni a da̱n ɗe bal mbala̱n mal Nya. Ta tla ɗuk so a ba̱ta tla mas ilgwe a gillit gaa ka̱wu so. Sa njika̱n mbadl gwas na̱ Shishi ga̱ Nya ata̱ yi ka̱ tuk ga̱ ana gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Tik ka palli ma̱n Yisiraila wonti mal Bagaa Nya gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ta tuli Bagaa Yesu cina, ata̱ pa̱l wul na̱ nda̱lti na̱k gwe Iliya ma̱n dla̱mti ga̱ɓa ga̱ Nya pa̱li wu. Ta tulli ta̱mti da̱nti ka̱ tlo ga̱ mil suk ma̱n za̱t jwasa̱n. Ta palli mbala̱n ma̱n la̱shi kumti bi asa̱ da̱n ɗe ma̱n kumti bi suk ma̱n pa̱lti zok wul. Na̱ nu ka̱n ta la̱ka̱mi Yesu mbala̱n jwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yek Zakariya wul yen shinti ga̱ Nyami ɗe, <<Ɗa̱ nii ka̱n ba yisi ɗe ilgwe ka̱ dla̱m go a pi nu gwi? Na̱k ɗe ami wo kol mbala̱n ka̱ ɓali a kili gi mago ta koli wu?>> ");
INSERT INTO gyz_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yek yen shinti ga̱ Nyami wulti ɗe, <<Amik ɗe Jibirailu gwe na̱ma da̱nti mal Nya wu. Nya shina̱n ɗe ta hwik ga̱ɓa ma̱n ta̱mti gee. ");
INSERT INTO gyz_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yek yekgu ka̱ nge ga̱ɓa gini, ama a da̱n ɗe gem kume multi njika̱n wu. Yek laki ɗe ningo ka po man ga̱ɓa so, se gas gwe sa̱ zi yeni wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mbala̱n na̱ma ɓa̱tti yilti ga̱ Zakariya, yek sa̱ njel daamti gwasa̱n ɗe yek laki ɗe ba̱ta̱ yil tet ba̱le so ye. ");
INSERT INTO gyz_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ta̱ yil tet wugo yek ba̱ta̱ man ga̱ɓa so, yek sa̱ yisi ɗe Nya ɓulit gwel yek ta̱ yen ilgon ka̱ lubii ga̱ Nyami. Yek ta̱ ngusi ga̱ɓa na̱ ang ama ba̱ta̱ man ga̱ɓa na̱ bi gwas so. ");
INSERT INTO gyz_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Multi ga̱ pa̱lti wul gwasa̱n ka̱ bii ngemti Nyami paki wugo, yek ta̱ li ga̱zi. ");
INSERT INTO gyz_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","La̱m multi wugo, yek kili gwas Alisabatu mbi yen, yek ta̱ hwuda̱l gaa gwas ka a gibboo ga̱ lip ɗe namtan. ");
INSERT INTO gyz_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yek ta̱ wule, <<Nya yen gonti ga̱na̱n yek ta̱ ba̱lni yen wi. Ta̱ kami nsha gwe a cin ka̱ mbala̱n wu ka̱wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Alisabatu njika̱n lip ɗe mukka na̱ yen tuk wugo, yek Nya shin yen shinti gwasi asa̱ mbet ɗe Jibirailu ka̱ ba̱n gon asa̱ mbe ɗe Nazarat ka̱ atl ga̱ Galili. ");
INSERT INTO gyz_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ta̱ shinti mal yen kili gon gwe ba̱ta̱ ɓo yis maani sowu asa̱ mbet ɗe Maryam, ti ka̱n ma̱lgon asa̱ mbet ɗe Yusupu na̱ma kopti gwas ɗe yen kili gwas wu. Yusupu wo ma̱n ga̱s ga̱ gus guu ga̱ ma̱n Yisiraila gwe asa̱ mbet ɗe Dauda wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yek yen shinti ga̱ Nyami tul mal Maryam, yek ta̱ wulti ɗe, <<A na̱ma ga̱ɓet gwa na̱ hwol tuki ki ɗe ka̱ mbi hwa wul sut mal Nya wu. Guu ga̱ Nya ni sukki.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maryam kum ga̱ɓetisi wugo, yek ɓanti citi, yek ta̱ daamti ɗe, <<Yek yen shinti ga̱ Nyami a hwit ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yek yen shinti ga̱ Nyami wulti ɗe, <<Ba̱ ɓanti cik so Maryam, ka̱ mbi hwa wul sut mal Nya. ");
INSERT INTO gyz_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ka mbi yen tuki, aka̱ zi yen maani, aka̱ zit shin ɗe Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ta da̱n ɗe kaksha mbala̱n, asa̱ mbet ɗe yen ga̱ Guu ga̱ Nya ma̱n nalti. Nya Bal Kakshe a ba̱lti nalti ga̱ ma̱n za̱t ga̱ koli gwasi Dauda. ");
INSERT INTO gyz_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tik ka da̱n ɗe guu gwe ba̱ pakti niɗɗa̱ sowu ga̱ ma̱n Yisiraila, ta da̱n ɗe guu ga̱ Israila gwe ba̱ a paki sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Yek Maryam ngem yen shinti ga̱ Nyami ɗe, <<Ɗa̱ nii ka̱n a pi nu gwi, ɗe ba ɓo yis maani sowu?>> ");
INSERT INTO gyz_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yek yen shinti ga̱ Nyami wulti ɗe, <<Shishi ga̱ Nya a su sut tenki. Nda̱lti ga̱ Guu ga̱ Nya a yitlak ka, na̱k ɗe nu ka̱n ni wu, yen gwe ka za̱t go sa mbet ɗe Yen ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yilka gwa Alisabatu mago yen nit tuki ka̱ kolit gwasi, a mbala̱n kul wule, ti wo ma̱n za̱t yen ka̱ so, yekgu ta̱ ɓal ka̱ lip ɗe mukka gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ilgon kan Nya gaa so.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yek Maryam wul yen shinti ga̱ Nyami ɗe, <<Ami wo zhel ga̱ Nya ka̱n, ha̱n ta̱ da̱n na̱k gwe ka̱ dla̱m wu.>> Yek yen shinti ga̱ Nyami zigaa. ");
INSERT INTO gyz_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kaal ɗa̱ la̱mti multi, yek Maryam li ka̱ ba̱n gon ɗe ni ten za̱nda̱l wu ka̱ atl ga̱ Yehudiya ba̱le-ba̱le, ");
INSERT INTO gyz_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yek ta̱ te ka̱ lubii ga̱ Zakariya, yek ta̱ ga̱ɓe Alisabatu. ");
INSERT INTO gyz_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Na̱ kumti yal ga̱ɓet ga̱ Maryam, yek yen gwe ni Alisabatu tuk wu nwuti, yek mbadl ga̱ Alisabatu njika̱n na̱ Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Yek ta̱ wul Maryam na̱ nda̱lti ɗe, <<Ki wo ma̱n mbit hwa wul ga̱ Nya ka̱n man mas modli, a yen gwe ka za̱t wu mago ma̱n mbit hwa wul ka̱ pak! ");
INSERT INTO gyz_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Hwa wul yek a mbi na̱n ye, ɗe ana ga̱ Bagaa gi li tet mala̱n wu? ");
INSERT INTO gyz_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na̱ kumti yal ga̱ɓet gwa Maryam, yek yen ga̱ nii tuk wu nwuti na̱ hwol tuki. ");
INSERT INTO gyz_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ki wo ma̱n mbit hwa wul ga̱ Nya ka̱n na̱k ɗe ka̱ zi mbadl ɗe ga̱ɓa gwe Nya shinik lu sut na̱ nali wu pi wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yek Maryam ballit ɗe, <<Bagaa Nya ka̱n mbadl gi na̱ma ta̱sti gwasi, ");
INSERT INTO gyz_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Na̱k ɗe tik ɗe ma̱n kisti gi wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na̱k ɗe ta̱ yisi lu wu, ko ɗe ami wo zhel gwas ka̱n gwe ba̱ ani ten bi ilgon sowu. Ningo gin ten gin sa mbe ɗe ma̱n mbit hwa wul ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Na̱k ɗe Nya Bal Kakshe wo ma̱n nalti ka̱wu ta̱ pa̱li kiɗi wul, shin gwas ka̱ɗe ma̱n cilti. ");
INSERT INTO gyz_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A ta̱ yen gonti ga̱ ma̱jwe ɓantit wu gin ten gin. ");
INSERT INTO gyz_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na̱ ang gwas ma̱n nda̱lti ka̱n ta̱ pa̱l kiɗi wul, yek ta̱ cat ma̱n nali gaa ka suk mas wul jwe nisi ka̱ mbadl wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yek ta̱ yilli kiɗi guu ɗa̱ka̱ gobdlan gwasa̱n ka, yek ta̱ ba̱l nalti ma̱jwe sa̱ mbulsi wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yek ta̱ ba̱l hwa wul ma̱jwe ni ka̱ kuza̱n wu, yek ta̱ mbol ma̱n wul koo ami. ");
INSERT INTO gyz_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","A ta̱ zi ang ten zhel jwasi ma̱n Yisiraila na̱k ɗe a ba̱ta ma̱sa̱n ga̱ɓa gwe ta̱ dla̱lli ka̱ dlo gwas suksi gwe ɗe ba̱ a paki sowu so. A ta̱ kul yen gonti ga̱ koli ga̱na̱n Ibirahim suk ma̱jwasi gin ten gin, na̱k gwe ta̱ dla̱mi ma̱ jina̱n ji cina wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Yek Maryam da̱m suk Alisabatu lip ɗe mekan yek paa ta̱ pal ga̱zi. ");
INSERT INTO gyz_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Yek za̱t yen ga̱ Alisabatu tul wi yek ta̱ zi yen maani. ");
INSERT INTO gyz_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yek ga̱ɓe ma̱tl ɗa̱nka̱ yela̱n da̱nti gwas ka suk yilkeni, kangwe Nya yen gonti gwas i'e wu, yek mas mbala̱n pa̱l hwol tuk sukti. ");
INSERT INTO gyz_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yeni mul ɗe wusupsi na̱ za̱t wugo, yek sa̱ sa̱lti, yek yilkeni ji Alisabatu mogaa mas suk yela̱n jwasi gas sa̱lti ga̱ yeni, yek sa̱ lami ɗe ta̱s zit shin ga̱ koli gwasi Zakariya. ");
INSERT INTO gyz_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yek gasa̱l gwas wulsi ɗe, <<Nuk so, ɗe Yohana ka̱n ka mbeti.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yek sa̱ wulti ɗe, <<Yek nu ye? Ka̱ ga̱s gwaka̱n wo ma̱n shin wu ni ɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yek sa̱ pa̱li kolisi na̱ ang ɗe, nii ka̱n sa mbe shin ga̱ yeni gwi? ");
INSERT INTO gyz_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yek ta̱ ngwe ɗe ta̱s ba̱lti wul lishti, yek ta̱ lishi ɗe, <<Shin gwas ka̱ɗe Yohana.>> Na̱ kumti nu yek mbadl tatlisi. ");
INSERT INTO gyz_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Zakariya na̱ma lishti shin ga̱ yeni, yek bi ɓuliti yek ta̱ nda ga̱ɓa. Yek ta̱ njel ta̱sti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yek ɓanti ci yela̱n da̱nti jwasi yek sa̱ ngusi dla̱mti ilgwe pi wu mas ten za̱nda̱l atl ga̱ Yehudiya. ");
INSERT INTO gyz_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mas ma̱jwe kum ga̱ɓe jo yek ili cisi ɓanti, yek sa̱ ngem yilkeni ɗe, <<Ɗe yek yeni a da̱n ye?>> Na̱k ɗe ang ga̱ Nya ma̱n nda̱lti ni tenti nu wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yek Shishi ga̱ Nya njika̱n mbadl ga̱ Zakariya aba ga̱ Yohana yek ta̱ dla̱m ga̱ɓa ga̱ Nya ten ilgwe a ya pi wu, yek ta̱ wule, ");
INSERT INTO gyz_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Ma̱ ta̱sa̱n Nya ga̱ ma̱n Yisiraila na̱k ɗe ta̱ na̱ma tulla̱t ga̱ ma̱n kisti ga̱ mbala̱n jwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ta̱ ɓalma shinti ga̱ bal ma̱n kisti ga̱na̱n suɗi tet ka̱ ga̱s ga̱ zhel gwasi Dauda guu. ");
INSERT INTO gyz_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Na̱k kangwe Nya dla̱mi ma̱n dla̱mti ga̱ɓa gwas ji cina wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ningo ta̱ ɓalma shinti ga̱ ma̱n kisti ga̱na̱n, ta̱s kisnii ɗa̱ka̱ ang ji mas ma̱n nget ga̱na̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na̱k kangwe ta̱ wula̱nni ɗe ta yen gonti ji kolsi jina̱n wu, a ba̱ta ma̱sa̱n zok ga̱ɓa gwe ta̱ dla̱lli ka̱ dlo gwas suksi wu so, ");
INSERT INTO gyz_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yek ɗe ga̱ɓa gwe ta̱ dla̱lli ka̱ dlo gwas suk koli ga̱na̱n Ibirahim wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ta̱ hwini ɗe ta kisnii ɗa̱ mal ma̱n nget ga̱na̱n ka, kangwe ba̱ ɓanti kopti gwas a cinni sowu, ");
INSERT INTO gyz_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Na̱ zok mbadli suk pa̱lti hwa wul ka̱ da̱nti ga̱na̱n mas a cina ɗatka. ");
INSERT INTO gyz_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ki nak en yen gi go, sa mbek ɗe ma̱n dla̱mti ga̱ɓa ga̱ Nya Bal Kakshe, kik ɗe ma̱n la̱ka̱nti mbadl ga̱ mbala̱n ji Nya, na̱k ɗe ka tuli Almasihu cina aka̱ la̱ka̱mit tantu tulti wu, ");
INSERT INTO gyz_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kik ka hwi mbala̱n jwasi kangwe sa mbi kisti wu, ten taasti byas wul jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Na̱k ɗe Nya wo ma̱n yenti gonti ka̱n i'e wu, ta shin Almasihu suɗi na̱k gwe a cin yil tot na̱ cilti wu. ");
INSERT INTO gyz_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","A cilti gwisi ka cilli ma̱n da̱nti ka̱ da̱mshal suk ma̱jwe ni ka̱ da̱n-da̱n ma̱shka̱n wu, ata̱ koɓi na̱mi ten tantu ta̱mti mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yek Yohana nali yek ta̱ nda̱li ata̱ na̱ma ɓotlka̱n, yek ta̱ da̱m ka̱ la̱ɓi se na̱k ta̱ nda dla̱mti ga̱ɓa ka̱ dlo ga̱ ma̱n Yisiraila. ");
INSERT INTO gyz_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ni nu ka̱ multi jon, yek ga̱ɓa yil sut mal guu ga̱ ma̱n atl ga̱ Rom asa̱ mbet ɗe Kaisar Ogostus, ɗe ngetli ka̱n ta̱s dla̱m wonta̱t ga̱ ma̱jwe ni ka̱ atl gwas wu mas na̱ shin gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yek ɗe ndat zhila dla̱mti wonta̱t ga̱ mbala̱n ka̱ multi jwe Kiriniyas ni ɗe gobna ga̱ Siriya wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yek mbala̱n li mas jwasa̱n ta̱s dla̱msi ɗa̱nka̱ ba̱n jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na̱k ɗe Yusupu wo ma̱n ga̱s ga̱ Dauda ka̱wu, yek ta̱ zak Nazarat ka̱ atl ga̱ Galili yek ta̱ li ka̱ ba̱n Baitalami ka̱ atl ga̱ Yehudiya. Ba̱n gwe sa̱ zi Dauda ma̱lgwe tik ɗe gus guu gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yusupu mago ta̱ su ta̱s dla̱msi suk Maryam yen kili gwe ta̱ na̱ma kopti gwas wu. A yen nit tuki. ");
INSERT INTO gyz_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Sa̱ ni Baitalami nugo yek za̱t yen tuliti. ");
INSERT INTO gyz_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yek ta̱ zi yen cina gwasi yen maani yek ta̱ kusti ka na̱ wul lut yen kaali. Yek ta̱ lakti ka̱ wul tlat ze ji tla na̱k ɗe ba̱sa̱ mbi punka ka̱ lubii gwe a ma̱nda̱ki shuk wu sowu. ");
INSERT INTO gyz_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","A ma̱n kyo na̱ma multi ten dii atli njaa ka̱ lwisi, asa̱ na̱ma ɓa̱tti mba̱la jwasa̱n ka̱ gasi. ");
INSERT INTO gyz_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ba̱ na̱ yisti gwasa̱n so, yek yen shinti ga̱ Nya tuli yek ta̱ dla̱l malsi, yek nalti ga̱ guu ga̱ Nya cilli lwisi ka. Yek ɓanti cisi i'e. ");
INSERT INTO gyz_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yek yen shinti wulsi ɗe, <<Ba̱ ɓanti ciki so, ga̱ɓa ga̱ Nya ma̱n ta̱mti, ma̱n hwolla̱t mbadl ka̱n a tullikii gwe ni ɗe ga̱ mbala̱n mas wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ase go ka̱ bal ba̱n ga̱ Dauda sa̱ zikii ma̱lgwe ɗe ta kis mbala̱n ɗa̱ka̱ byas wul ka̱wu, asa̱ mbet ɗe Almasihu Bagaa. ");
INSERT INTO gyz_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ilgwe ka yeni wuggu, ka mbi yen ga̱ kusi ka̱ wul lut yen kaali a atli ka̱ wul tlat ze ji tla.>> ");
INSERT INTO gyz_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A ba̱ ma̱lgon ɓo kum ga̱ɓe so, yek wonti mil shinti ji Nya suk yen shinti gon wu, njel ta̱sti ga̱ Nya ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Nalti ga̱ Nya Bal Kakshe to nya ka, ten dii atl wo ta̱mi mbadl ga̱ mbala̱n jwe ta̱ na̱ma hwol tuk na̱ si wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sa̱ ni nugo, yek mil shinti ji Nyami zaksi yek sa̱ pal to nya ka, yek ma̱n kyoɓi wul yilkeni ɗe, <<Mi mago ma̱ ɓo su Baitalamisi pak, ta̱n sak yena̱n ilgwe na̱ma pa̱t wu, gwe ɗe Bagaa Nya hwini wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Yek sa̱ li ka̱ ba̱mi ɓaa-ɓaa, yek sa̱ mbi ka̱ Maryam suk Yusupu suk yen la̱li gwasa̱n ata̱ ni atli ka̱ wul tlat ze ji tla. ");
INSERT INTO gyz_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yek ma̱n kyoɓi yenti wugo, yek sa̱ dla̱misi ilgwe yen shinti ga̱ Nya hwisi ten yen ni wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mas ma̱jwe kum ga̱ɓa gwe ma̱n kyo ju dla̱m wu, yek sa̱ ngip bi ka̱ ang asa̱ na̱ma yenti wul cit ɓanti ten ilgwe ma̱n kyoɓi dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Yek Maryam ngip ga̱ɓe mas ka̱ mbadl gwasi, yek ta̱ ngusi daamti gwas a dani. ");
INSERT INTO gyz_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yek ma̱n kyoɓi pal ga̱za̱n na̱ hwol tuki, na̱ ta̱sti nalti ga̱ Nya na̱ ilgwe sa̱ kumi yek sa̱ yeni wu ndakce na̱k kangwe yen shinti ga̱ Nya hwisi wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yeni njika̱n multi na̱ wusupsi wugo, yek sa̱ sa̱lti, yek sa̱ zit shin ɗe Yesu, shin gwe yen shinti ga̱ Nya ba̱li a ba̱sa̱ ɓo mbi tuk gwas sowu. ");
INSERT INTO gyz_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Yek multi jwe a kili ma̱n za̱t yen kul pa̱li na̱ da̱ska̱n njika̱n wugo, yek Maryam suk Yusupu li ka̱ lubii ga̱ Nya a Wurshelima na̱k gwe dla̱m ka̱ mba̱t ga̱ Musa wu. Yek sa̱ taki wul Nya kangwe mba̱t gwe Nya ba̱l Musa dla̱m wu, <<Kulu me ɗe lop sogo mil kulu boo ɗe lop,>> ka̱n sa mboshi asa̱ taki Nya. Yek sa̱ ta̱la Yesu Wurshelima ta̱s takiti Nya, na̱k gwe mba̱t gwe Nya ba̱l Musa dla̱m wu, <<Mas yen maani gwe ɗe yen cingo, ta da̱n ɗe ma̱n la̱shi da̱ska̱n ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ka̱ multi jwisi wo, a ma̱lgon ni ɗa̱ a Wurshelima asa̱ mbet ɗe Saminu, ma̱n zok mbadl gon a hwa zhel ga̱ Nya ka̱ɗe ti. Ta̱ na̱ma ɓa̱tti ma̱lgwe a kis ma̱n Yisiraila wu. A Shishi ga̱ Nya ni sukti. ");
INSERT INTO gyz_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Shishi ga̱ Nya hwit ɗe ta ɓo ma̱sh so se ta̱ yen Almasihu gwe Nya a shinti sut wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yek Shishi ga̱ Nya ta̱la Saminu ka̱lu lubii ga̱ Nyami lu gwe ka̱ Maryam suk Yusupu ta̱la Yesu ta̱s pa̱lit na̱k gwe mba̱t ga̱ Musa dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yek Saminu kan yeni ka̱ ang gwasi yek ta̱ ta̱s Nya, yek ta̱ wule, ");
INSERT INTO gyz_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<Bagaa Nya , ningo zhel gwa a ma̱sh na̱ ta̱mi mbadli, na̱k kangwe ka̱ dla̱mi wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na̱k ɗe gwel gi yen kisti gwa wu, ");
INSERT INTO gyz_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","kisti gwe ka̱ pa̱li mas mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tik ɗe cilti gwe a cilli ma̱jwe ba̱ Ma̱n Yehuda ka̱ sowu, a tik ɗe ma̱lgwe ma̱n Yisiraila a nda̱l ka̱ti wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yek aba gwasi suk ana gwas ngip bi ka̱ ang na̱ cit ɓanti na̱ ilgwe Saminu dla̱m ten yen gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Yek Saminu ngem Nya ta̱s ba̱lsi zok wul gwasi, yek ta̱ hwi ana gwas Maryam ɗe, <<Yen ga̱n go mbala̱n wonti ka̱ Israila a ngeti asa̱ nda, a wonti a lamti asa̱ dla̱li, a ta da̱n ɗe lal gwe ba̱ mbala̱n lami sowu. ");
INSERT INTO gyz_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Na̱ nu ka̱n wul jwe sa̱ zi ka̱ mbadl gwasa̱n wu a yil deɓa̱l. Ilga̱n a ciki na̱k wule puka ka̱ tul mbadl gwa.>> ");
INSERT INTO gyz_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kol gasa̱l ma̱n dla̱mti ga̱ɓa ga̱ Nya gon ni ɗa asa̱ mbet ɗe Hannatu, yen ga̱ Panuwel ma̱n ga̱s ga̱ Ashiru. Ta̱ da̱n bii kos gin ɗe nitgi, ");
INSERT INTO gyz_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yek kos gwas ma̱shi, yek ta̱ ɓal ka̱ gin ɗe kutl na̱ wusupsi na̱ wupsi. Ba̱ta huul na̱ lubii ga̱ Nya so, ata̱ ngem Nya na̱ ka̱ cin na̱ ka̱ gasi ata̱ pa̱l ka̱lka̱ze pak. ");
INSERT INTO gyz_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yek ta̱ li mal ka̱ Saminu suk ka̱ Maryam ka̱lu bii ngemti Nyami, yek ta̱ ngusi hwol tuk na̱ Nya yek ta̱ hwi ga̱ɓa mbala̱n jwe na̱ma ɓa̱tti kisti ga̱ Wurshelima wu ten yeni. ");
INSERT INTO gyz_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ka̱ Yusupu suk Maryam pak pa̱lti ilgwe mba̱t ga̱ Musa dla̱m ɗe ta̱s pa̱li wugo, yek sa̱ pal ga̱za̱n a Nazarat ka̱ atl ga̱ Galili. ");
INSERT INTO gyz_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yek yeni nali yek ta̱ nda̱li, yek ta̱ njika̱n na̱ ɓotlka̱n yisti wul, a hwa wul ga̱ Nya ni sukti. ");
INSERT INTO gyz_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Mas gin, a aba suk ana ga̱ Yesu li Wurshelima ta̱s pa̱l Motgaa daamti ɗakcit boo ji Israila. ");
INSERT INTO gyz_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesu njika̱n gin kutl cet lop wugo, yek sa̱ to na̱k gwe asa̱ kul pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sa̱ pak motgaami wi ɗe sa̱ ɓa pal ga̱za̱n go yek Yesu sa tukaali a Wurshelima, aba̱ abe suk ane yisi so. ");
INSERT INTO gyz_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Sa̱ da̱m gwa we ta̱ ni suksi ka̱ mbala̱n, yek ba̱ ni nu so. Yek paa sa̱ nda ngot gwas ka̱ yilkeni suk ma̱jwe sa̱ yissi ju asa̱ nda cin ten a la̱t wi. ");
INSERT INTO gyz_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yek ba̱sa̱ yenti so. Yek sa̱ pal te Wurshelima ka ten ngot gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Sa̱ mul ɗe mekan ten ngot gwas wugo, yek sa̱ lak mbit ka̱ dlo ji ma̱n lishti ka̱ lubii ga̱ Nya, ata̱ na̱ma kumti gwasa̱n ata̱ na̱ma bodla̱lti gwasa̱n na̱ kumti ga̱s wul. ");
INSERT INTO gyz_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mas ma̱jwe kumti jo yek sa̱ ngip bi ka̱ ang a ɓanti na̱ma cit gwasa̱n na̱ yisti wul gwasi na̱ kangwe ata̱ ballisi ga̱ɓa wu. ");
INSERT INTO gyz_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aba gwas suk ana gwas mbit wugo, yek ɓanti cisi, ɗe sa̱ yenti ka̱ dlo ga̱ ma̱n lishti wu, yek ana gwas wulti ɗe, <<Ma̱ na̱ma ta ngot gwa suk aba gwa yek laki yek ka̱ pa̱lini nu ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yek ta̱ wulsi ɗe, <<Yek laki ɗe ka̱ na̱ma ngot gi ye? Ka̱ yisi ɗe ngetli ka̱n nii ɗe ta̱ pa̱l wul ga̱ aba gi sa?>> ");
INSERT INTO gyz_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yek ba̱sa̱ yis ilgwe ta̱ nisi ma dla̱mti wu so. ");
INSERT INTO gyz_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yek ta̱ kopsi yek sa̱ li Nazarat ata̱ na̱ma kopti ga̱ɓa gwasa̱n. Yek ana gwas ngip ili mas ka̱ mbadl gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yek Yesu ngusi nalti ata̱ na̱ma ɓotlka̱n yisti wul suk hwol hwula̱n mal Nya suk mal mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ka̱ gin ɗe kutl cet namtan ɗe Kaisar Tiberiyas ni ɗe bal guu ka̱ atl ga̱ Rom. A Bilatus ni ɗe gobna ga̱ ma̱n Yehudiya. A Hiridus ka̱ɗe guu ga̱ ma̱n Galili. Yilka gwas Pilip wo ata̱ ni ɗe guu ga̱ ma̱n Ituriya suk Tarakanitus. A Lisaniyas ni ɗe guu ga̱ ma̱n Abilen. ");
INSERT INTO gyz_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ka̱ Anana suk Kayapas ka̱ɗe kiɗi ma̱n Pa̱ris. Yek Nya ga̱ɓa suk Yohana yen ga̱ Zakariya ata̱ na̱ma da̱nti ka̱ la̱ɓi. ");
INSERT INTO gyz_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yek ta̱ ngusi ma̱tlti ɗa̱nka̱ ba̱n jwe ni njaa mal dla̱lka gon asa̱ mbe ɗe Yodan wu ata̱ nima hwit ga̱ɓa mbala̱n ɗe, ta̱s cit atl gaa mal Nya ta̱s taasisi byas wul jwasa̱n ka asa̱ pa̱lisi baptisma. ");
INSERT INTO gyz_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Na̱k gwe ni ga̱ lishi ka̱ lishti ga̱ Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya ɗe: <<Tik ɗe yal gwe na̱ma takti bi na̱ nda̱lti ka̱ la̱ɓi gwe na̱ma wulti ga̱ mbala̱n ɗe, <La̱ka̱mi Bagaa tantu gwaka̱n, la̱ka̱ma̱n da̱nti gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Njika̱ma̱n gora̱ndla̱n ka. Taka̱n tantu jwe kontan ka̱ju ka. ");
INSERT INTO gyz_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na̱ nu ka̱n mas mbala̱n a yen kisti ga̱ Nya.> >> ");
INSERT INTO gyz_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yek Yohana hwi mbala̱n jwe ɗe mogaa ta̱s pa̱lisi baptisma wu ɗe, <<Ɓuɓul na̱k kii, wok hwikii ɗe ta̱k aɓii lilti mbadl ga̱ Nya ma̱n tulti wo? ");
INSERT INTO gyz_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pa̱la̱n ilgwe a mbok ang ten cit atl gaa gwaka̱n wu. Ba̱k wula̱n ɗe kii wo ma̱n ga̱s ga̱ Ibirahim wo ka̱ ni ka̱ ma̱n pa̱lti byas wul so so, nu ka̱n ni so. Nya a man palla̱t mil ye asa̱ da̱n ɗe mil ji Ibirahim. ");
INSERT INTO gyz_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Na̱k ninge mago bi ndal ni ten zhila tlindi, mas tlindi jwe wut mil sogo a wotl ka a wut ka̱ wutu.>> ");
INSERT INTO gyz_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yek mbala̱mi kum ga̱zi ɗe, <<Yek ma pa̱li ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yek Yohana wulsi ɗe, <<Ma̱lgwe luka̱l ɗe lop niɗɗa̱ wu, ata̱ ba̱l ɗe na̱m ma̱lgwe niɗɗa̱ sowu; a ma̱lgwe ilga̱ nguki niɗɗa̱ wu ta̱s pa̱li nu pak.>> ");
INSERT INTO gyz_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma̱n kanti wulpi boo tul mal Yohana ta̱s pa̱lisi baptisma, yek sa̱ ngemti ɗe, <<Ma̱n lishti, yek ma pa̱li ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yek Yohana wulsi ɗe, <<Mboka̱n ang ten gem gwaka̱n, ba̱k kama̱n wulpi boo mal mbala̱n nal man kangwe sa̱ zikii kanti wu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yek ma̱n hapti tlo jon kum ga̱zi ɗe, <<Yek ma pa̱li ye?>> Yek Yohana ballisi ɗe, <<Ba̱k kama̱n wulpi mal mbala̱n ngetli so, a ba̱k sheli lal ma̱lgon gaa so. Dlo mbadl na̱ ɓatlti gwaka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mbala̱n mas na̱ma ɓa̱tti tulti ga̱ Almasihu ba̱le, sa̱ lami ta̱s yisi ko gwa Yohana ka̱ɗe Almasihu. ");
INSERT INTO gyz_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yek Yohana nda̱kisi ɗe, <<Ami wo na̱ ze ka̱n a pa̱likii baptisma, ama bal ma̱lgon a ya tuli ma̱lgwe nal mana̱n wu, ta̱ man ngetl ga̱ ta pa̱tl kapta̱lan gwasi. Tik ka pa̱likii baptisma na̱ Shishi ga̱ Nya suk wutu. ");
INSERT INTO gyz_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ta huul tlo ga̱ gwesi suk ka̱pti na̱ gal pelti wul gwasi. Ta taas lu cokti tul gwas ka mas ata̱ wut gwesi ka̱ nhu gwasi. Ka̱pti wo ata̱ kweli ka na̱ wutu gwe ba̱ a mba̱sh sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohana hwisi wunda̱l ga̱ɓa jwisi wonti ma̱n nda̱lti ɗe ta̱ nisi ma hwit ga̱ɓa ma̱n ta̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohana ga̱ɓa ten Hiridus guu ten hapti gwe ta̱ hap kili ga̱ Pilip yilka gwas wu, suk byas wul jwe ta̱ pa̱li wonti wu. ");
INSERT INTO gyz_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yek Hiridus guu yitla Yohana ka̱ bii gwe asa̱ tel ma̱n pa̱lti byas wul wu, ɗa̱ ten byas wul jwe ta̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Gas gon sa̱ nima pa̱lti baptisma mbala̱n wonti. Yek Yesu na̱ gaa gwas mago yek sa̱ pa̱liti. Ta na̱ma ngemti Nya nugo, yek tlo nya ɓuli. ");
INSERT INTO gyz_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yek Shishi ga̱ Nya yil sut nya na̱k kulu yek ta̱ dla̱l ten Yesu. Yek ga̱ɓa wul sut nya ɗe, <<Kik ɗe yen gi gwe a lamki wu. A na̱ma hwol tuk na̱ ki i'e.>> ");
INSERT INTO gyz_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu ni ka̱ gin ɗe kutl ɗe mekan ɗe ta̱ nda dla̱mti ga̱ɓa ga̱ Nya mbala̱n wu, ka̱ yisti ga̱ mbala̱n wo Yesu wo yen ga̱ Yusupu ka̱n, Yusupu wo yen ga̱ Heli. ");
INSERT INTO gyz_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli yen ga̱ Matat, Matat yen ga̱ Lawi, Lawi yen ga̱ Malki, Malki yen ga̱ Jannai, Jannai yen ga̱ Yusupu. ");
INSERT INTO gyz_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusupu yen ga̱ Matatiya, Matatiya yen ga̱ Emos, Emos yen ga̱ Nahu, Nahu yen ga̱ Azariya, Azariya yen ga̱ Esli, Esli yen ga̱ Najaya. ");
INSERT INTO gyz_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najaya yen ga̱ Ma'ata, Ma'ata yen ga̱ Matatiya, Matatiya yen ga̱ Shimeya, Shimeya yen ga̱ Yusupu, Yusupu yen ga̱ Yoda. ");
INSERT INTO gyz_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda yen ga̱ Yowana, Yowana yen ga̱ Repaya, Repaya yen ga̱ Zerubabel, Zerubabel yen ga̱ Shayeltiyel, Shayeltiyel yen ga̱ Niri. ");
INSERT INTO gyz_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Niri yen ga̱ Malki, Malki yen ga̱ Addi, Addi yen ga̱ Kosama, Kosama yen ga̱ Almadama, Almadama yen ga̱ Er. ");
INSERT INTO gyz_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yen ga̱ Yosi, Yosi yen ga̱ Eliyeza, Eliyeza yen ga̱ Yorima, Yorima yen ga̱ Matat, Matat yen ga̱ Lawi. ");
INSERT INTO gyz_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lawi yen ga̱ Saminu, Saminu yen ga̱ Yehuda, Yehuda yen ga̱ Yusupu, Yusupu yen ga̱ Yonam, Yonam yen ga̱ Eliyakim. ");
INSERT INTO gyz_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim yen ga̱ Malaya, Malaya yen ga̱ Mainana, Mainana yen ga̱ Matata, Matata yen ga̱ Natan, Natan yen ga̱ Dauda. ");
INSERT INTO gyz_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dauda yen ga̱ Yesse, Yesse yen ga̱ Obida, Obida yen ga̱ Bo'aza, Bo'aza yen ga̱ Salmon, Salmon yen ga̱ Nashon. ");
INSERT INTO gyz_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nashon yen ga̱ Aminadab, Aminadab yen ga̱ Aram, Aram yen ga̱ Hesruna, Hesruna yen ga̱ Peresa, Peresa yen ga̱ Yehuda. ");
INSERT INTO gyz_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda yen ga̱ Yakubu, Yakubu yen ga̱ Ishaku, Ishaku yen ga̱ Ibirahim, Ibirahim yen ga̱ Tera, Tera yen ga̱ Nahor. ");
INSERT INTO gyz_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor yen ga̱ Seruk, Seruk yen ga̱ Reza, Reza yen ga̱ Pelek, Pelek yen ga̱ Eba, Eba yen ga̱ Shela. ");
INSERT INTO gyz_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shela yen ga̱ Kenan, Kenan yen ga̱ Arpakshad, Arpakshad yen ga̱ Shem, Shem yen ga̱ Nuhu, Nuhu yen ga̱ Lamek. ");
INSERT INTO gyz_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek yen ga̱ Metusela, Metusela yen ga̱ Enok, Enok yen ga̱ Yared, Yared yen ga̱ Mahalalel, Mahalalel yen ga̱ Kenan. ");
INSERT INTO gyz_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan yen ga̱ Enosh, Enosh yen ga̱ Shitu, Shitu yen ga̱ Adamu, Adamu wo ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yek Shishi ga̱ Nya njika̱n Yesu, yek ta̱ zak lu dla̱lka Yodan, yek Shishi ga̱ Nyami ta̱lat ka̱ la̱ɓi, ");
INSERT INTO gyz_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ka̱lu gwe Sheɗan cinga̱lti wu. Multi ɗe kutl ɗe wupsi a ba̱ta̱ nguk ilgon so, a kuza̱n ɓalma tlot gwas i'e. ");
INSERT INTO gyz_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Yek Sheɗan wulti ɗe, <<Kume ki wo Yen ga̱ Nya ka̱go, palli ye ga̱n ɗe burodi.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yek Yesu wulti ɗe, <<Ni ga̱ lishi ɗe, <Ilga̱ nguki na̱ ngus ka̱ɗe ma̱n lakti mbala̱n asa̱ da̱n na̱ mbadl so.> >> ");
INSERT INTO gyz_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yek Sheɗan tolti ten tlal lu gon, yek ta̱ mbokit ang ten dii atli na̱ mas wul jwe ni giɓi wu ka̱ nak da̱nti. ");
INSERT INTO gyz_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Yek Sheɗan wulti ɗe, <<Ba palla̱k ɗe bagaa ga̱ mas mbuni wul jimi, mas ji ka̱n, a ba mani ba̱lti ma̱lgwe a lamit wu. ");
INSERT INTO gyz_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ba ba̱lki mas, kume ka̱ ngus atli yek ka̱ ba̱la̱n nalti wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yek Yesu ballit ɗe, <<Ni ga̱ lishi ɗe, <Bagaa Nya gwa na̱ ngus ka̱n ka ba̱lti nalti, ti na̱ ngus ka̱n ka da̱n ɗe zhel gwasi.> >> ");
INSERT INTO gyz_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yek Sheɗan ta̱lat Wurshelima, yek ta̱ tolti ten gaa lubii ga̱ Nya, yek ta̱ wulti ɗe, <<Kumɗe Yen ga̱ Nya ka̱ɗe ki wu, ɗakci lu suɗi, ");
INSERT INTO gyz_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","na̱k gwe ni ga̱ lishi ɗe, <Nya a shin mil shinti jwas suɗi ");
INSERT INTO gyz_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","asa̱ ngipki na̱ ang gwasa̱n. A ba̱ka ɓo asa̱n ten ye so.> >> ");
INSERT INTO gyz_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yek Yesu wulti ɗe, <<Ni ga̱ lishi ɗe, <Ba̱k cinga̱l Bagaa Nya gwa so.> >> ");
INSERT INTO gyz_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sheɗan pak cinga̱lti ga̱ Yesu wugo, yek ta̱ zakti, yek ta̱ ɓa̱t zobsi cin gon ɗa. ");
INSERT INTO gyz_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yek Yesu pal te atl ga̱ Galili ka a mbadl gwas ni ga̱ njikmi na̱ nda̱lti Shishi ga̱ Nya, yek mbala̱n wonti kum ga̱ɓa tenti mas ka̱ atli. ");
INSERT INTO gyz_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A ta̱ kul hwi ga̱ɓa mbala̱n ka̱lu motgaa ga̱ gwasa̱n, a mas mbala̱n ta̱sti. ");
INSERT INTO gyz_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yek Yesu li ka̱ nak'en ba̱n gon asa̱ mbe ɗe Nazarat, ka̱lu gwe ta̱ nal wu, yek ta̱ te ka̱lu motgaa gwasa̱n na̱k kangwe ata̱ kul pa̱li gas shukti wu. ");
INSERT INTO gyz_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yek sa̱ ba̱lti lishti gwe Ishaya yen shinti dla̱mti ga̱ɓa ga̱ Nya lish wu. Yek ta̱ ɓul lu gwe lishtisi wuli ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Shishi ga̱ Nya ni ka̱ ami, Nya botla̱n ɗe ta dla̱mi ga̱ɓa ma̱n ta̱mti ma̱jwe ba̱ ilgon nisi ɗa̱ sowu. Ta̱ shina̱n ɗe ta hwi ma̱jwe ni ga̱ ɓali wu ɗe sa pa̱tlsi, Dwa mago sa yen lu, A ta yilli ma̱jwe ni ka̱ bomti da̱nti suk baboo jwasa̱n wu ka̱ pak, ");
INSERT INTO gyz_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ta hwisi ɗe, gin gwe Nya a kis mbala̱n jwas wu tul wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yek ta̱ le lishtisi ka yek ta̱ ba̱l ma̱n da̱nti ka̱lu motgaami. Yek ta̱ da̱m na̱ zhila. Ma̱jwe ni ka̱lu motgaami jo yek sa̱ wutit gwel. ");
INSERT INTO gyz_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yek ta̱ wulsi ɗe, <<Ga̱ɓa gee da̱n ɗe gem malkii ase wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mas mbala̱n jwe ni ka̱li wu dla̱m hwa ga̱ɓa tenti. Yek ɓanti cisi ten ga̱ɓa gwe ta̱ dla̱m wu. Yek sa̱ wuli ɗe, <<Ɗa̱ nii ka̱n a pi nu gwi? Ko yen ga̱n go tik ɗe yen ga̱ Yusupu wu so?>> ");
INSERT INTO gyz_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yek Yesu wulsi ɗe, <<A yisi ɗe ka dla̱m ga̱ɓa tena̱n nu ɗe, <Ma̱n ba̱lti ika̱n, ndok gaa gwa la.> Ilgwe ka̱ lam dla̱mti go yek ɗe, <Yek laki ɗe ba̱ka̱ pa̱l wul cit ɓanti ka ba̱n gwa na̱k gwe ka̱ pa̱li a Kaparnahum so ye?> >> ");
INSERT INTO gyz_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yek Yesu po hwisi ɗe, <<Gem ka̱n, ma̱n dla̱mti ga̱ɓa ga̱ Nya a mbi nalti ka̱ ba̱n gwas so. ");
INSERT INTO gyz_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Gem, guli modli ni ɗa̱ wonti ka̱ atl ga̱ Israila ka̱ gin gwe Iliya ma̱n dla̱mti ga̱ɓa ga̱ Nya ni ka̱ atli wu. Gin ɗe mekan na̱ tatlti tlo, ɗe ba̱ ze nda sowu, yek kuza̱n tlo mbala̱n mas ka̱ atl ga̱ Israila. ");
INSERT INTO gyz_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ama ba̱ Nya shin Iliya mal modli ju so. Yek ta̱ shinti mal guli kili gon a Zarepat ma̱n da̱nti ka̱ atl ga̱ Sidon. ");
INSERT INTO gyz_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sogo ɓo daama̱nki ten Ilisha ma̱n dla̱mti ga̱ɓa ga̱ Nya ma̱lgwe laki yek Naaman ndoki ɗa̱ka̱ cwo gita ka̱wu, a Naaman wo ma̱n Siriya ka̱n, a ma̱n cwo gita ni ɗa wonti ka̱ Israila jwe na̱ma lamti ndokti wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Yek sa̱ kumi nu wugo, yek mbadl lili ma̱jwe ni ka̱lu motgaami wu. ");
INSERT INTO gyz_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yek sa̱ tlinya na̱ apti, yek sa̱ tol Yesu ten za̱nda̱l ba̱mi. Sa̱ na̱ma lamti ta̱s jekti sut ten za̱nda̱li. ");
INSERT INTO gyz_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yek Yesu yil ɗa̱ka̱ tlo gwasa̱n ka yek ta̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yek Yesu li Kaparnahum ba̱n gon ka̱ atl ga̱ Galili, yek ta̱ nisi ma ga̱ɓa ka̱lu motgaa gwasa̱n gas shukti. ");
INSERT INTO gyz_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ka̱ lwisi mago ɓanti ci mbala̱n ten ilgwe ta̱ dla̱m wu na̱k ɗe mas ga̱ɓa gwas wo kiɗi ga̱ɓa ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","A Yesu ni ka̱lu motgaa, yek ma̱n byas ma̱zhe gon njel tlilti yal nya ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Tli ɗa̱ mal ni ka̱! Yek mo ni sukki ye, Yesu ga̱ ma̱n Nazarat? Ka̱ sa tlot ga̱na̱n kaa? A yisi, ki wo ma̱n cilti ka̱n gwe Nya shinti sut ɗu.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yek Yesu dla̱lla̱t ka, yek ta̱ wulti ɗe, <<Da̱m mbetlak!>> Yek ta̱ po wul ma̱zhesi ɗe, <<Yil ɗa̱ka̱ ti ka.>> Yek ma̱zhesi jek ma̱li a atli ka̱ tlo mbala̱n yek ta̱ yil ɗa̱ka̱ ma̱li ka kangwe ba̱ta̱ kumit cwo sowu. ");
INSERT INTO gyz_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yek ɓanti ci mbala̱n yek sa̱ wuli ɗe, <<Nda̱lti yek ni ga̱ɓa ga̱ ma̱lga̱n ɗa̱ nu ye, ɗe mas na̱ ma̱zhe mago asa̱ kum ga̱ɓa gwas wu?>> ");
INSERT INTO gyz_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yek ga̱ɓa ten ilgwe ta̱ pa̱li wu ma̱tl ɗa̱nka̱ ba̱mi ka. ");
INSERT INTO gyz_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yek Yesu yil ɗa̱ka̱ lu motgaa ga̱ gwasa̱n ka, yek ta̱ li lubii ɗa̱ Siman. ");
INSERT INTO gyz_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yek Yesu ngus malti yek ta̱ matl cwoɓi, yek cwoɓi zakti yek ta̱ tlinya ninge-ninge yek ta̱ njelisi pa̱lti wul. ");
INSERT INTO gyz_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cin ɓal njaa ta̱ nda bii go yek wonti mbala̱n ma̱n cwo tul malti yek ta̱ ngusi za̱t ang gwas tensi asa̱ na̱ma ndokti, ");
INSERT INTO gyz_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ma̱zhe mago sa̱ yil ɗa̱ka̱ mbala̱n ka wonti asa̱ na̱ma lakti yal asa̱ na̱ma wulti ɗe, <<Kik ɗe Yen ga̱ Nya.>> Yek ta̱ matlsi yek ba̱ta̱ zaksi ta̱s ga̱ɓa so na̱k ɗe sa̱ yisi ɗe tik ɗe Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Lu tlo wugo, yek Yesu li ka̱lu gon na̱ ngusi, a mbala̱mi na̱ma ta ngot gwasi yek sa̱ mbit wugo yek sa̱ wulti ɗe ba̱s zigaa ata̱ zaksi so. ");
INSERT INTO gyz_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ama yek ta̱ wule, <<Ngetli ka̱n nii ɗe ta dla̱m ga̱ɓa ma̱n ta̱mti ten kangwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu, na̱k ɗe yek laki yek sa̱ shina̱n sut ɗu.>> ");
INSERT INTO gyz_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Yek ta̱ ngusi dla̱mti ga̱ɓa ka̱lu motgaa ji Ma̱n Yehuda a Yehudiya. ");
INSERT INTO gyz_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gas gon, Yesu na̱ma dla̱mti ga̱ɓa ga̱ Nya ten bi bal ze gon asa̱ mbe ɗe Jeneselet. Yek mbala̱n wonti da̱n njaa malti ta̱s kumti. ");
INSERT INTO gyz_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yek ta̱ yen jirgi ze jon ɗe lop jwe ba̱ ma̱lgon ni giɓi sowu ten bi bal zesi, ji ma̱n dopti kwesi, sa̱ wut ka̱li, asa̱ na̱ma polti wul dopti kwes gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yek ta̱ te ka̱ jirgi zesi ga̱ Siman Biturus wu. Yek ta̱ ngem Siman Biturus ta̱s nak jek jirgi te ka̱ zesi ka̱. Yek ta̱ da̱m ka̱ jirgi zesi yek ta̱ nde hwit ga̱ɓa mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ta̱ pak ga̱ɓe wugo, yek ta̱ wul Siman Biturus ɗe, <<Nii go li ka̱lu gwe dlunti mani wu, aka̱ lak wul dopti kwes gwa ka̱ zesi, ka doɓi wonti.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yek Siman Biturus wule, <<Ma̱n lishti, ma̱ mul ten dipti ze a ba̱ma̱ dop ilgon so, ama na̱k ɗe ka̱ dla̱m nugo ma po lak wul dopti kwesi ka̱ zesi ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Sa̱ lak wul dopti kwesi wugo, yek njika̱n ka na̱ kwesi hal ɓa nda keshti. ");
INSERT INTO gyz_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Yek sa̱ mbe yilkeni jwasa̱n jwe ni te ka̱ zopsi jirgi gon ka̱wu ta̱s lak zisi ang. Yek sa̱ li teɗi yek sa̱ zisi ang, yek jirgi pak lop njika̱n ka na̱ kwesi na̱k wule a su ga̱s gaa ze. ");
INSERT INTO gyz_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Siman Biturus yen ilgwe na̱ma pa̱t wu wugo, yek ta̱ ngus na̱ gaa hwula̱n a cina ɗa̱ Yesu ka, yek ta̱ wule, <<Bagaa, a na̱ma ngemti gwa ta̱k zaka̱nni, ma̱n pa̱lti byas wul ka̱ɗe ami.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Na̱ Siman Biturus na̱ ma̱jwe ni sukti wu yen kangwe sa̱ dop kwesi wugo yek ili ngusisi cit ɓanti. ");
INSERT INTO gyz_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yela̱n dopti kwes jwasi, ka̱ Yakubu suk Yohana mil ji Zabadi mago ili cisi ɓanti pak. Yek Yesu wul Siman Biturus ɗe, <<Ba̱ ɓanti cik so, ndok ase, mbala̱n ka̱n ka ngusi dopti gwasa̱n kwes ka po ni so.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Sa̱ na̱ma yilti tot ten bi cikɗi, yek sa̱ zak mas wul jwasa̱n yek sa̱ kop Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu ni ka̱ ba̱n gon nu go, yek ta̱ mo suk ma̱n bal cwo gita gon, yek ma̱li yen Yesu wugo, yek ta̱ ngus a cina ɗatka yek ta̱ ngusa̱l gaa gwas atli. Yek ta̱ ngem Yesu ɗe, <<Bagaa, kume ka̱ lami go aka̱ ndoka̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yek Yesu tak ang, yek ta̱ ta̱n ma̱li, yek ta̱ wulti ɗe, <<A lami wi, ndoki,>> na̱ dla̱mti nu, yek ma̱li ndoki. ");
INSERT INTO gyz_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yek Yesu wulti ɗe, <<Ba̱k hwi ma̱lgon so, ama li mal ma̱n Pa̱ris ta̱s yenki aka̱ ba̱lti ilgwe ta taki Nya wu, na̱k gwe ni ka̱ mba̱t ga̱ Musa wu. Na̱ nu ka̱n mas mbala̱n a yisi ɗe ka̱ ndoki wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mas na̱ ndwal ga̱ɓa gwe Yesu ba̱l ma̱li wu, yek ga̱ɓa tenti ngusi ma̱tlti ka̱ mbala̱n. Yek mbala̱n wonti ngusi la̱t tet malti ta̱s kumti, si mago ta̱s ndokti ɗa̱ka̱ cwo gwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","A Yesu kul yil ɗa̱ka̱ mbala̱n ka, ata̱ la ngem Nya ka̱ me. ");
INSERT INTO gyz_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gas gon Yesu nima hwit ga̱ɓa mbala̱n ka̱ ba̱n gon, a ma̱n Paresi suk ma̱n yisti mba̱t ga̱ Musa jwe yil tet ka̱ atl ga̱ Galili suk Yehudiya suk tet ka̱ bal ba̱n Wurshelima wu ni na̱ zhila njaa ka̱li. A nda̱lti gwe Nya ba̱l Yesu ta̱s ndok mbala̱n wu ni tenti. ");
INSERT INTO gyz_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yek ma̱jon kan ma̱lgon ɗe asa̱n tlet ka̱wu ten lumulti, sa̱ na̱ma tlot gwasa̱n ta̱s telti gibboo ta̱s lakti atli a cina ɗa̱ Yesu ka. ");
INSERT INTO gyz_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Yek ba̱sa̱ mbi tantu so na̱k ɗe mbala̱n wonti hwo wu. Sa̱ yeni nu wugo, yek sa̱ tolti ten gaa bii yek sa̱ ɓul gaa biimi yek sa̱ yilla̱t suɗi ten lumulti gwasi, yek sa̱ mulla̱t atli ka̱ tlo ga̱ mbala̱n a cina ɗa̱ Yesu ka. ");
INSERT INTO gyz_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yek Yesu yen za̱t mbadl ten Nya gwasa̱n wugo, yek ta̱ wul ma̱n cwoɓi ɗe, <<Sa̱ taas byas wul jwa ka̱wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yek ma̱n Paresi suk ma̱n yisti mba̱t ga̱ Musa ngusi nala̱nti ɗe, <<Wok ɗe ga̱n ɗe paa ta̱ dla̱m ga̱ɓa mbulti ga̱ Nya nu wo? Nya na̱ ngus ka̱ɗe ma̱n manti taasti byas wul ga̱ mbala̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na̱k ɗe Yesu yis ilgwe sa̱ na̱ma daamti gwasa̱n dani wu, yek ta̱ wulsi ɗe, <<Yek laki ɗe ka̱ na̱ma daamti gwaka̱n nu ye? ");
INSERT INTO gyz_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gwik bom so mani gwi, na̱ ta̱ mbala̱n wule, <Sa̱ taas byas wul jwa ka̱wi,> sogo ta̱s wule <Tlinya ta̱k zigaa?> ");
INSERT INTO gyz_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ama ta̱k yisi ɗe ami Yen ga̱ Mbala̱n man taasti byas wul ji mbala̱n ka ten dii atli.>> Yek ta̱ wul ma̱lgwe asa̱mi tlet ka̱wi ɗe, <<Tlinya ta̱k kan lumulti gwa ta̱k li gee.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ninge yek ma̱li tlinya ten gwel ga̱ mbala̱n wonti yek ta̱ tlil lumulti gwasi yek ta̱ pal ga̱zi ata̱ na̱ma ta̱sti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Mas jwasa̱n yek sa̱ ngip bi ka̱ ang ɗe ɓanti ɓa cisi wu. Yek sa̱ ngusi ta̱sti ga̱ Nya asa̱ na̱ma wulti ɗe, <<Ase ka̱n ma̱ yen wul cit ɓanti.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kaal ɗa̱ nu, yek Yesu yil ɗa̱ka̱ ba̱n gwe ta̱ nima hwit ga̱ɓa mbala̱n wu ka, yek ta̱ yen ma̱n kanti wulpi boo gon asa̱ mbet ɗe Lawi. Ata̱ ni na̱ zhila ka̱lu kanti wulpi boomi. Yek Yesu wulti ɗe, <<Li te ta̱k koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yek ta̱ zak kanti wulpi boomi yek ta̱ kop Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Yek Lawi mbe motgaa hwol tuki a lubii ɗatka ta̱ mbala̱n yen nalti ga̱ Yesu. Ma̱n kanti wulpi boo wonti suk ma̱jon asa̱ na̱ma ngukti wul suksi. ");
INSERT INTO gyz_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yek ma̱n Paresi suk ma̱n yisti mba̱t ga̱ Musa jon nda nala̱nti asa̱ na̱ma wulti ga̱ ma̱n kopti ji Yesu ɗe, <<Yek laki ɗe ka̱a̱ na̱ma ngukti aka̱a̱ na̱ma tlati suk ma̱n kanti wulpi boo suk ma̱n pa̱lti byas wul ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yek Yesu wulsi ɗe, <<Ma̱jwe ba̱ cwo na̱ma cit gwasa̱n sogo, sa ngo ma̱n ika̱n so, se ma̱n cwo. ");
INSERT INTO gyz_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A tul ɗe ta mbe ma̱n pa̱lti zok wul so, ama ma̱n pa̱lti byas wul ta̱s ci atl gaa mal Nya.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yek ma̱jon wul Yesu ɗe, <<Ma̱n kopti ji Yohana wo asa̱ pa̱l ka̱lka̱ze ngemti Nya nja-nja, mil lishti ji ma̱n Paresi mago nu. Ama ma̱n kopti jwa wo ba̱sa pa̱li nu so na̱k ɗe asa̱ nguk wul asa̱ tla ze mas cin wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yek Yesu ballisi ɗe, <<Ka̱ yeni go yela̱n ji pyal kos a pa̱l ka̱lka̱ze ngemti Nya a pyal kos yi suksi a? ");
INSERT INTO gyz_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ama gas gwe sa̱ kan pyal kos ka̱wu ka̱n sa̱ pa̱l ka̱lka̱ze ngemti Nya.>> ");
INSERT INTO gyz_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yek Yesu mwesi ga̱ɓa gon ɗe, <<Mbala̱n a kesh pyal luka̱l ata̱ dla̱m ten gusi so. Kume ta̱ pa̱li nugo, ta kesh pyal luka̱l gwas ka. A ba̱ pyalisi a mbun ten gusi so. ");
INSERT INTO gyz_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A ba̱ mbala̱n a shot pyal ze inabi ka̱ gus zwi kuul so ɗe kume ta̱ pa̱li nugo, gus zwi kuli a mbutl ka, a ze inabisi a shot ka, a zwi kuli mago a lilka. ");
INSERT INTO gyz_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pyal ze inabi wo ka̱ pyal zwi kuul ka̱n asa̱ shoti. ");
INSERT INTO gyz_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A ba̱ mbala̱n a lam tlat pyal ze inabi kaal ɗa̱ ta̱ tla gusi wi so, ta wule, gusi wu ta̱m man pyali wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gas shukti ga̱ Ma̱n Yehuda gon yek Yesu suk ma̱n kopti jwas koɓi tuka̱ zhin alkama gon yek sa̱ ngusi celti gaa alkame asa̱ na̱ma wumti asa̱ na̱ma ngukti. ");
INSERT INTO gyz_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yek ma̱n Paresi jon wulsi ɗe, <<Yek laki ɗe ka̱ na̱ma pa̱lti ilgwe ba̱ mbun ɗe ta̱ mbala̱n pa̱li gas shukti wu na̱k gwe ni ga̱ lishi ka̱ mba̱t ga̱ Musa so gwe?>> ");
INSERT INTO gyz_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yek Yesu ballisi ɗe, <<Ka̱ yisa̱n ilgwe Dauda pa̱li ɗe kuza̱n na̱ma tlot gwasi suk yela̱n jwas wu sa? ");
INSERT INTO gyz_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kangwe ɗe ta̱ te ka̱ bii ga̱ Nya yek ta̱ kan burodi gwe sa̱ zi ka̱ biimi wu, yek ta̱ nguki hal yek ta̱ ba̱l naami ma̱n kopti jwasi, gwe mbun ɗe ta̱ mbala̱n mas nguk sowu, se ma̱n da̱nti ka̱ biimi. Nu ka̱n mba̱t ga̱ Musa dla̱m pak.>> ");
INSERT INTO gyz_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yek Yesu po dla̱misi ɗa̱ɗe, <<Ami Yen ga̱ Mbala̱n wo, amik ɗe bagaa ga̱ gas shukti.>> ");
INSERT INTO gyz_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gas shukti ga̱ Ma̱n Yehuda gon ɗa, yek Yesu te ka̱lu motgaa ga̱ gwasa̱n ata̱ nisi ma ga̱ɓa, a ma̱lgon ni ka̱li ɗe ang shinti gwas tla ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yek ma̱n yisti mba̱t ga̱ Musa suk ma̱n Paresi wuti gwel Yesu ta̱s ɓo yeni, ko ta ɗakca̱n mba̱t ga̱ Musa ata̱ ndokti mbala̱n gas shukti, ta̱s mbi byas ilgon tenti. ");
INSERT INTO gyz_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","A Yesu yis ilgwe sa̱ na̱ma daamti gwasa̱n dani wu. Yek ta̱ wul ma̱li ɗe, <<Tlinya ta̱k dla̱l a nde,>> yek ma̱li tlinya yek ta̱ dla̱l a cina ɗaasika. ");
INSERT INTO gyz_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yek Yesu wulsi ɗe, <<A na̱ma ngemti gwaka̱n, cin pa̱lti byas wul ka̱ɗe ga̱n ma, ko ga̱ pa̱lti hwa wul, ta̱ yilli mbadl kaa ko ta̱ tlo mbadli?>> ");
INSERT INTO gyz_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yek ta̱ ngusi yenti gwasa̱n na̱m-na̱m, yek ta̱ wul ma̱li ɗe, <<Tak ang gwa,>> yek ta̱ tak ami go ndoki wi. ");
INSERT INTO gyz_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ten nu ka̱n yek mbadl lili ma̱n yisti mba̱t ga̱ Musa suk ma̱n Paresi i'e. Yek sa̱ nda ga̱ɓa ten ilgwe sa pa̱lit wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ka̱ multi jwisi, yek Yesu to ten tla̱da̱l, ta̱s ngem Nya, yek ta̱ mul ten ngemti Nya. ");
INSERT INTO gyz_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Yek lu tlo wugo, yek ta̱ mbe ma̱n kopti jwasi mas jwasa̱n. Yek ta̱ botl ɗe kutl cet lop ka̱si, yek ta̱ mbesi ɗe mil shinti ji botli. ");
INSERT INTO gyz_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ka̱ Siman gwe Yesu zit shin ɗe Biturus wu, suk yilka gwasi Andarawus, suk Yakubu suk Yohana suk Pilip suk Bartilomi ");
INSERT INTO gyz_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","suk Matta suk Tomas suk Yakubu yen ga̱ Halpa suk Siman gwe asa̱ mbet ɗe ma̱n lamti ji mbala̱n ga̱ atl gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Suk Yehuda yen ga̱ Yakubu suk Yehuda Iskariyoti ma̱lgwe ba̱l bi ga̱ Yesu ta̱s tlot wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yek Yesu yil sut ka̱ tla̱da̱l suk ma̱n kopti jwasi. Yek ta dla̱l ten bal dii atl gon suk mbala̱n wonti suk ma̱n kopti jwasi. Ka̱ lwisi mago a wonti mbala̱n tet ɗa̱nka̱ atl ga̱ Yehudiya suk Wurshelima suk tet ka̱ atl ga̱ Taya suk Sidon jwe ni ten bi bal ze wu ni ɗa. ");
INSERT INTO gyz_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Sa̱ li tet ɗe ta̱s kumti asa̱ mbi ndokti ɗa̱ka̱ cwo gwasa̱n ka, ma̱jwe duu ma̱zhe dopsi mago yek sa̱ ndoki pak. ");
INSERT INTO gyz_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yek mas mbala̱n dlosi ɗe ta̱s ta̱nti na̱ ang na̱k ɗe nda̱lti na̱ma yilti tet tenti wu. Yek mas jwasa̱n sa̱ ndoki. ");
INSERT INTO gyz_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yek Yesu yen ma̱n kopti jwasi, yek ta̱ wulsi ɗe, <<Kii wo ma̱n mbit hwa wul ga̱ Nya ka̱n kii ɗe ba̱ ilgon ni kii ɗa̱ sowu. Na̱ nu ka̱n Nya a da̱n ɗe guu ka̱ mbadl gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kii wo ma̱n mbit hwa wul ga̱ Nya ka̱n kii ɗe kuza̱n na̱ma tlot gwaka̱n ninge wu, na̱ nu ka̱n gas gon wo a kumkii. Kii wo ma̱n mbit hwa wul ga̱ Nya ka̱n kii ɗe ka̱ na̱ma kulu ninge wu, na̱ nu ka̱n gasi gon wo ka gitli. ");
INSERT INTO gyz_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kii wo ma̱n mbit hwa wul ga̱ Nya ka̱n kii ɗe mbala̱n na̱ma nget gwaka̱n, yek sa̱ yilla̱kii ɗa̱ka̱ dlo gwasa̱n ka, asa̱ na̱ma byalti gwaka̱n, asa̱ na̱ma wulti gwaka̱n ɗe, <Kii wo ma̱n byas mbadl ka̱n,> na̱k ɗe ma̱n kopti ga̱ Yen ga̱ Mbala̱n ka̱ɗe kii wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pa̱la̱n hwol tuki aka̱ lak icin! Bal ɓatlti na̱ma ɓa̱tti gwaka̱n to nya ka. Daama̱n kangwe kolsi jwasa̱n pa̱li ma̱n dla̱mti ga̱ɓa ga̱ Nya tek wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ka da̱n ɗe wul cit gonti kii ɗe wul ni kii ɗa̱ wu, ninge ka̱ɗe hwol tuk gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ka da̱n ɗe wul cit gonti kii ɗe kuza̱n na̱ma tlot gwaka̱n so ni wu, na̱ nu ka̱n kuza̱n a ya tlokii gas gon. Ka da̱n ɗe wul cit gonti kii ɗe ka̱ na̱ma gitlti ni wu, na̱ nu ka̱n ka ya lak pa̱l duu tuki aka̱ na̱ma kulu. ");
INSERT INTO gyz_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ka da̱n ɗe wul cit gonti kii ɗe mbala̱n na̱ma ta̱sti gwaka̱n wu. Nu ka̱n kolsi jwasa̱n ta̱s ma̱n shelti lal yisti ga̱ɓa ga̱ Nya pak. ");
INSERT INTO gyz_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<A ni kii ma hwiti, kii ɗe ka̱ na̱ma kumti gi wu, lama̱n ma̱n nget gwaka̱n. A ka̱ pa̱lisi hwa wul. ");
INSERT INTO gyz_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pa̱li hwa wul ma̱n byalti jwaka̱n, aka̱a̱ ngemi Nya ma̱jwe pa̱likii ngalci wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kume ma̱lgon ɓek kalka̱ng ten ka̱t ang shinti wu, ballit ka̱t ang yali pak. A kume ma̱lgon lam wul yitlat gwa wu, ba̱lti luka̱l gwa pak. ");
INSERT INTO gyz_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mas ma̱lgwe ngemik wul go aka̱ ba̱lti. A ma̱lgwe kamit wul ka ngetli go ba̱k wule ta̱s pallik so. ");
INSERT INTO gyz_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pa̱li hwa wul mbala̱n na̱k gwe ka̱ lami ɗe ta̱s pa̱likii wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ɗe kume ma̱jwe lamkii wu ka̱n ka̱a̱ lamsi na̱ ngusa̱n go, ɗa̱ nii ka̱n ka mbi hwa wul gwi? Ma̱n pa̱lti byas wul mago sa̱ lam ma̱n lamti jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A kume ma̱jwe pa̱likii hwa wul ka̱n, aka̱a̱ pa̱lisi na̱ ngusa̱n go, yek hul dlo gwaka̱n suk ma̱n pa̱lti byas wul ye? Ma̱n pa̱lti byas wul mago asa̱ pa̱li nu. ");
INSERT INTO gyz_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ɗe kume ma̱jwe asa̱ ɓatlkii wu ka̱n ka ba̱lsi duul go, ɗa̱ nii ka̱n ka̱ mbi hwa wul gwi? Ma̱n pa̱lti byas wul mago asa̱ pa̱li yilkeni nu ta̱s ɓatlsi ɗa. ");
INSERT INTO gyz_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ama, kii wo lama̱n ma̱n nget gwaka̱n, aka̱a̱ pa̱lisi hwa wul. Ba̱lini a ba̱k za̱n mbadl palla̱ti so. Apaa ka̱a̱ mbi bal ɓatlti aka̱a̱ da̱n ɗe mil ji Nya Bal Kakshe. A ta̱ pa̱li hwa wul ma̱jwe ba̱sa pa̱l hwol tuk sowu suk ma̱n ngalci. ");
INSERT INTO gyz_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Da̱ma̱n ɗe ma̱n yenti gonti ji mbala̱n na̱k kangwe Aba gwaka̱n ni ɗe ma̱n yenti gonti wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","<<Ba̱k zi byas wul ma̱lgon so, kii mago sa zikii so pak. Ba̱k pa̱li byas da̱mti ma̱lgon so, kii mago ma̱lgon a pa̱likii so. Taasa̱n byas wul ji mbala̱n ɗa̱ ten mbadl ka, kii mago sa taas gwaka̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ba̱lini, kii mago sa ba̱lkii. Gal ga̱ njikmi i'e, hal a ngusi shoti, hal a shoti ki naami ka̱ ang luka̱l, gal gwe ka̱a̱ cinga̱li na̱ nali go, kii mago na̱ nali ka̱n a cinga̱likii.>> ");
INSERT INTO gyz_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yek Yesu hwisi ga̱ɓa gon ɗe, <<Ɗa̱ nii ka̱n dwa a nde dwa cina gwi? Kume pi nugo, mas jwasa̱n sa nda ka̱ shu. ");
INSERT INTO gyz_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yen lishti a nal man ma̱n lishti gwas so. Ama yen ma̱n lishti gwe pak lishti gwas wugo ta̱ da̱m na̱k ma̱n lishti gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ka̱ man yenti yen coklan ka̱ gwel ga̱ yilka gwa ama ba̱ka̱ man yenti guda̱l yencin gwe ni ka̱ gwel gwa wu so ");
INSERT INTO gyz_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɗa̱ nii ka̱n kama̱n wulti ga̱ yilka gwa ɗe, <Yilka gini, ha̱nta yillik yen coklan ga̱ ka̱ gwel wu ka,> a yekgu go ba̱ka̱ man yenti ga̱ bal guda̱l yencin gwe ni ka̱ gweli gwa wu sowu? ki ma̱n pa̱lti riya, nda ndusti guda̱l yencin gwe nikka̱ gwel wu ka, kangwe ka man yenti lu i'e aka̱ ndusi nak coklan gwe ni ka̱ gwel ga̱ yilka gwa wu ka. ");
INSERT INTO gyz_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","<<Hwa tlindi wuta̱n byas yandi so aba̱ byas tlindi wut hwa yandi so. ");
INSERT INTO gyz_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tlindi wo ten yandi gwas ka̱n a mbala̱n yisi. Ka kotl tula̱n tet ten tlindi iil so, sogo yandi inabi tet ten tlindi tula̱n so. ");
INSERT INTO gyz_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","A hwa mbala̱n pa̱l hwa wul na̱k ɗe hwa wul ka nik ka mbadli wu, a byas mbala̱n wo byas wul ka̱n ata̱ pa̱li, na̱k ɗe byas wul ka̱ nit ka̱ mbadli wu. Ilgwe ni ka̱ mbadl go, yek ka̱n a bi dla̱mi. ");
INSERT INTO gyz_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","<<Yek laki aka̱ mbe ɗe Bagaa ye? Ɗe ka̱ nge pa̱lti ilgwe a hwiki ɗe ta̱k pa̱li wu? ");
INSERT INTO gyz_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ma̱lgwe li tet mala̱nni yek ta̱ kati ka̱n yek ta̱ pa̱l ilgwe a hwit ɗe ta̱s pa̱li go, ba hwiki wunda̱l ga̱ ma̱li. ");
INSERT INTO gyz_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ta̱ ni na̱k ma̱lgwe ɗe ta̱ ɓa kin bii gwas go, yek ta̱ ɗuk atl dlunti, yek ta̱ lak zhila kinti biimi ten pa, yek dla̱lka njika̱n wugo, yek ze tak ɓo biimi, ama ba̱ nda so. Na̱k ɗe zhila biimi wo ten pa ka̱n ni wu. ");
INSERT INTO gyz_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mas ma̱lgwe kum ga̱ɓa gini a ba̱ta̱ pa̱l ilgwe a hwit ɗe ta̱s pa̱li wu sogo, na̱k ma̱lgwe ta̱ kin bii gwas ɗe ba̱ta̱ nda zhila biimi hwaɓi sowu ka̱n ta̱ ni, yek dla̱lka njika̱n wugo, yek ze ɓo biimi wugo yek pa̱l byas ndati.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu paki dla̱mti mas ga̱ɓe jwisi mbala̱n wugo, yek ta̱ li ka̱ ba̱n Kaparnahum. ");
INSERT INTO gyz_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yek zhel ga̱ bal ma̱n hapti tlo ga̱ ma̱n Roma gon ka̱wu na̱ cwo na̱k wule ta ma̱shinni, a ma̱n hapti dlomi lam zheli i'e. ");
INSERT INTO gyz_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma̱n hapti dlomi kum bi ga̱ Yesu wugo, yek ta̱ shin kiɗi Ma̱n Yehuda jon ta̱s ngem Yesu ta̱s lak ndok zhel gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Sa̱ li mal Yesu wugo, yek sa̱ ngemti i'e, yek sa̱ wulti ɗe, <<Mbun ɗe ta̱k ndok zhel ga̱ ma̱lga̱n, ");
INSERT INTO gyz_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","na̱k ɗe ta̱ lam mbala̱n jina̱n hal ta̱ kinini lu motgaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yek Yesu li suksi. Ta̱ ɓal njaa ta̱s mbuki lubiimi go, yek bal ma̱n hapti dlomi shin yela̱n jwasi ta̱s hwi Yesu ɗe, <<Ki wo ma̱n nalti ka̱n, ba̱k nol gaa gwa so, a mbuki ta̱k li tet lubii ɗaaka so. ");
INSERT INTO gyz_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yek laki yek baa mbuki ɗe ta li tet malki so. Ga̱ɓa ka̱li, zhel gi a ndoki. ");
INSERT INTO gyz_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ami mago a ang ɗa̱ ma̱lgwe nii cina wu ka̱n a ni, a ma̱n hapti tlo jon nii atl ɗaaka pak, aa kul wul ga̱n ɗe, <Li ka̱lu gee,> ata̱ li; aa po wul ga̱n ɗe, <Li te,> ata̱ li te. A kume a wul zhel gi ɗe, <Pa̱li na̱k ga̱n wu,> ata̱ pa̱li.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu kumi nu wugo yek ta̱ ngip bi ka̱ ang, ɗe ta̱ yen za̱t mbadl ten Nya ga̱ ma̱li wu, yek ta̱ balla̱t mal mbala̱n jwe na̱ma kopti gwas wu, yek ta̱ wulsi ɗe, <<A ni kii ma hwiti, ka̱ ma̱n Yisiraila mago, a yen ma̱n za̱t mbadl ten Nya na̱ nda̱lti na̱k ga̱ ma̱lga̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma̱jwe ma̱n hapti dlomi shinsi wu pal tek wugo yek sa̱ mbi go zhel ga̱ ma̱li ndoki wi. ");
INSERT INTO gyz_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ɓo la̱m da̱nti so, yek Yesu lika̱ nak'en ba̱n gon asa̱ mbe ɗe Nayin a ma̱n kopti jwas suk mbala̱n wonti na̱ma kopti gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Sa̱ ɓal njaa ta̱s te ka̱ bi dlaboo ba̱mi go, yek ma̱jon ka̱wu na̱ hwuu ga̱ yen gon, a tik ɗe yen ga̱ kili gwe kos ma̱shit ka̱wu na̱ ngusi, a mbala̱n wonti na̱ma kopti gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Yek Yesu yen kilisi wugo, yek gonti gwas citi, yek ta̱ wulti ɗe, <<Po kul so.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yek Yesu lak ta̱n wul kanti hwuunisi na̱ ang yek ma̱jwe kan hwuunisi wu dla̱li, yek ta̱ wule, <<Yen mbala̱n, tlinya!>> ");
INSERT INTO gyz_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yek yeni tlinya yek ta̱ njel ga̱ɓa. Yek Yesu ba̱ltiti ana gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yek ɓanti ci mbala̱n mas jwasa̱n, yek sa̱ ba̱l nalti Nya asa̱ na̱ma wulti ɗe, <<Bal ma̱n dla̱mti ga̱ɓa ga̱ Nya tulini wi. Nya su suɗi ta̱s kis mbala̱n jwas wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yek ga̱ɓa ten ilgwe Yesu pa̱li wu ma̱tl ɗa̱nka̱ Yehudiya ka suk ba̱n jwe ni njaa wu. ");
INSERT INTO gyz_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ma̱n kopti ji Yohana ma̱n baptisma hwi Yohana mas wul jwe Yesu na̱ma pa̱lti wu wugo, yek ta̱ mbe ɗe lop ka̱si. ");
INSERT INTO gyz_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yek ta̱ shinsi mal Yesu ta̱s kum ga̱zi ɗe, <<Kik ɗe ma̱lgwe a tul gwa? Ko ta̱n ɓa̱tti ta̱ yi suɗi?>> ");
INSERT INTO gyz_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sa̱ li mal Yesu wugo yek sa̱ wulti ɗe, <<Yohana ma̱n baptisma shinnii malki ta̱n kum ga̱zi ɗe, ko kik ɗe ma̱lgwe a tul wu? Ko ta̱n ɓa̱tti ta̱ yi suɗi?>> ");
INSERT INTO gyz_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sa̱ ni ka̱li nugo, yek Yesu ndok mbala̱n wonti ɗa̱ka̱ cwo jwasa̱n ka, yek ta̱ yilli ma̱zhe ɗa̱ka̱ mbala̱n ka, yek ta̱ ɓuli gwel dwa wonti. ");
INSERT INTO gyz_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yek Yesu hwi mil shinti ɗe, <<Lak hwi Yohana wul jwe ka̱a̱ kumi yek ka̱a̱ yeni wu, gwel ji dwa ɓuli, ma̱jwe man la̱t na̱ asa̱n sowu li na̱ asa̱n, ma̱n cwo gita ndoki, a ma̱jwe kum ka̱n sowu kum ka̱n, a ma̱jwe ma̱sh ju tli ɗa̱ka̱ ma̱shka̱n ka, ma̱jwe ba̱ ilgon nisi ɗa̱ sowu kum ga̱ɓa ga̱ Nya ma̱n ta̱mti. ");
INSERT INTO gyz_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nya a ba̱l hwa wul ma̱jwe zak za̱t mbadl tena̱n sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kaal ɗa̱ za̱t gaa ga̱ ma̱n kopti ji Yohana, yek Yesu nde ga̱ɓa mbala̱mi tenti ɗe, <<Wok nii ka̱ la̱ɓ ɗe ka̱ la yenti gwas wo? Ko ma̱lgwe ni na̱k tlal me jwe yeta̱l na̱ma nwuti wu ka̱n ka̱ la yenti? ");
INSERT INTO gyz_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Yek wok ka̱ la yenti gwas wo? Ma̱lgwe kinti na̱ hwa luka̱l gwa? Ma̱n lakti hwa luka̱l suk ma̱n da̱nti ta̱mti wo ɗa̱ guu ka̱n asa̱ ni. ");
INSERT INTO gyz_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Yek wok ka̱ la yenti wo? Ma̱n dla̱mti ga̱ɓa ga̱ Nya ma? Nu ka̱n ni, ta̱ nal ma̱n dla̱mti ga̱ɓa ga̱ Nya pamma. ");
INSERT INTO gyz_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ti ka̱n ga̱ɓa ga̱ Nya dla̱m ɗe, <<<Yen shinti gi a tulik cina, ma̱lgwe a la̱ka̱mik lu apaa ka̱ nda tulti wu.> ");
INSERT INTO gyz_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A ni kii ma hwiti, mas mbala̱n za̱ti ga̱ modli, gon nal na̱k Yohana so, ama ma̱lgwe tik ɗe nak'eni ka̱ ma̱jwe kan Nya ɗe guu ka̱ mbadl gwasa̱n wu nal manti.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Mas ma̱jwe kum ga̱ɓe wu, mas na̱ ma̱n kanti wulpi boo sa̱ kan ka̱ mbadl gwasa̱n ɗe, tantu ga̱ Nya wo gem ka̱n, na̱k ɗe Yohana pa̱lisi baptisma wu. ");
INSERT INTO gyz_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ama yek ma̱n Paresi suk ma̱n yisti mba̱t ga̱ Musa nge kopti ilgwe Nya lamisi kopti wu, na̱k ɗe sa̱ nge ta̱ Yohana pa̱lisi baptisma wu. ");
INSERT INTO gyz_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yek Yesu wule, <<Yek mbala̱n ten dii atl ninge ndaali ye? Ndakce suk yek sa̱ ni ye? ");
INSERT INTO gyz_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sa̱ ni ndakce suk mil mbala̱n jwe ni ka̱lu motgaa wu ɗe sa̱ wul yilkeni ɗe, <<<Ma̱ hotiki mba̱zhel, yek ka̱ nge dlalti, ma̱ wul koo ma̱shka̱n yek ka̱ nge kulu.> ");
INSERT INTO gyz_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","<<Ɗe Yohana ma̱n baptisma tul go, a ba̱ta̱ nguk wul so, ba̱ta̱ tla ze inabi so, ama yek ka̱ wule, <Ma̱n ma̱zhe ka̱ɗe ti.> ");
INSERT INTO gyz_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yek ami Yen ga̱ Mbala̱n tuli, a na̱ma ngukti wul a na̱ma tlati yek ka̱ wule, <Ɓo yena̱nti ta̱ nguk wul hwo ata̱ tla ze inabi i'e pak, yela̱n ji ma̱n kanti wulpi boo suk ma̱n pa̱lti byas wul.> ");
INSERT INTO gyz_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mas na̱ nu go, ma̱jwe kan ɓotlka̱n gwe a Nya ba̱li wugo, sa̱ yisi ɗe ɓotlka̱mi wo gem ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yek ba Paresi gon asa̱ mbet ɗe Siman mbe Yesu ta̱s nguk wul a lubii ɗatka, yek Yesu li lubiimi yek ta̱ da̱n na̱ zhila ta̱s nguki. Nu ka̱n a Ma̱n Yehuda pa̱li, kumɗe sa̱ ɓa nguk wul go asa̱ tlalti asa̱n a atli. ");
INSERT INTO gyz_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","A kili gon ni ka̱ ba̱mi gwe pa̱l byas wul ka̱ da̱nti gwas wu. Yek ta̱ kumi ɗe Yesu na̱ma ngukti wul a lubii ɗa̱ ba Paresi wu ka, yek ta̱ kan bunta̱n mil gon teɗi na̱ mil ma̱n ta̱mi wusa̱n gwe asa̱ wul na̱ bal wulpi wu. ");
INSERT INTO gyz_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yek ta̱ lak dla̱l a malka̱n ɗa̱ Yesu ka, ata̱ na̱ma kulu, a luu gwas na̱ma lokti ten asa̱n ga̱ Yesu. Yek ta̱ taasi ka na̱ ma̱dla̱n gaa gwasi. Yek ta̱ ngusi swatti asa̱n ga̱ Yesu ata̱ na̱ma pa̱t mil dani. ");
INSERT INTO gyz_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yek ba Paresi wu yen ilgwe kili wu na̱ma pa̱lti wu wugo yek ta̱ wul ka̱ mbadl gwas ɗe, <<Ma̱lga̱n go, Nya ka shinti ɗe ma̱n dla̱mti ga̱ɓa gwas go ɗa ta yis wunda̱l kili gwe na̱ma ta̱nti gwas wu ɗe ma̱n pa̱lti byas wul ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yek Yesu wul ba Paresisi ɗe, <<A lamik hwit ilgon.>> Yek ta̱ wulti ɗe, <<Hwini, ma̱n lishti.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yek Yesu wule, <<Ma̱lgon na̱ma kopti ji mbala̱n ɗe lop jon wulpi, gon wo ta̱ na̱ma kopti gwas wulpi gwe asa̱ ɓatl zhel ka̱ gin ɗe na̱m na̱ tatlti tlo wu, a gon wo ta̱ na̱ma kopti gwas wulpi gwe asa̱ ɓatl zhel ka̱ multi ɗe kutl ɗe namtan wu. ");
INSERT INTO gyz_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yek ba̱sa̱ ɓatl dani sogo, yek ta̱ zakisi mas jwasa̱n. Ka̱ yenti gwa wo gwik ka lamti mani gwi?>> ");
INSERT INTO gyz_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Yek Siman wulti ɗe, <<Ka̱ yenti gi wo ma̱lgwe wulpi gwas wu nal mani wu.>> Yek Yesu wule, <<Gem ka̱n ka̱ dla̱mi.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yek ta̱ balla̱t mal kilisi yek ta̱ wul Siman ɗe, <<Ɓo yen kili gee, a te boo ɗakka ba̱ka̱ ba̱la̱n ze ta pol asa̱n gi so, ama yek ta̱ pol asa̱n gi ka na̱ luu gwasi yek ta̱ taasi ka na̱ ma̱dla̱n gaa gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na̱k a te boo ɗakka, ka̱ ga̱ɓe i'e so a ba̱ka ngiɓa̱n ni yek ka̱ wup kaal ka̱n gi so, ama na̱k a te teɗi yek kili ga̱n na̱ma ta wupti asa̱n gini. Pa̱lti ji Ma̱n Yehuda ka̱n kume sa̱ ɓa ga̱ɓe yilkeni go, asa̱ ngipsi te tlo ka asa̱ wup ga̱ska̱n gwasa̱n sogo ang gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ka̱ pi mil ten gaa so, ama ti wo ta̱ na̱ma tuksa̱t mil ten asa̱n gini. ");
INSERT INTO gyz_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yek laki a nikma hwiti ɗe, wonti byas wul jwas jo mas a taasit ka̱wi na̱k ɗe ta̱ lama̱n i'e wu. Ma̱lgwe sa̱ taasit njet byas wul ka̱go, njet ka̱n ata̱ pa̱l lamti gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yek ta̱ wul kilisi ɗe, <<Sa̱ taas byas wul jwa ka̱wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yek ma̱nda̱ki jwe na̱ma ngukti wul suksi wu wul yilkeni ɗe, <<Wok ɗe ga̱n ɗe hal ata̱ taas byas wul ga̱ mbala̱n ka̱go?>> ");
INSERT INTO gyz_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yek Yesu wul kilisi ɗe, <<Za̱t mbadl ten Nya gwa kiski wi; zigaa na̱ ta̱mi mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nak la̱m da̱nti wugo, yek Yesu ma̱tl ɗa̱nka̱ kiɗi ba̱n ka suk nak mili ata̱ na̱ma dla̱mti ga̱ɓa ma̱n ta̱mti ten kangwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu, a ma̱n kopti jwas ɗe kutl cet lop ju ni sukti. ");
INSERT INTO gyz_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Suk modli jon jwe sa̱ yilli ma̱zhe ɗa̱ka̱si ka yek sa̱ ba̱lsi ndokti wu, ka̱ Maryam ma̱n Maga̱dala ma̱lgwe sa̱ yillit ma̱zhe ɗe nitgi ka̱wu, ");
INSERT INTO gyz_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Suk Yuwana kili ga̱ Kuza gwe ata̱ pa̱li wul Hiridus guu wu, suk Suzana, suk modli wonti jwe na̱ma pa̱lti wul suk Yesu suk ma̱n kopti jwas ɗe kutl cet lop ju na̱ wul ang jwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","A mbala̱n na̱ma ta motgaa mal Yesu tet ka̱ ba̱n ɗa̱nka, yek Yesu wule, <<Ha̱nta ɓo hwikii ga̱ɓa gon. ");
INSERT INTO gyz_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ma̱lgon la catti wunda̱l ka̱ zhin gwasi, ta̱ na̱ma catti wuda̱li nugo, yek naami lok ten tantu yek mbala̱n koɓi dani yek yatl ɗakmi ka. ");
INSERT INTO gyz_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yek naami lok ka̱ gokca, yek te wugo yek lada̱l ka, na̱k ɗe ba̱ lwisi ni diki i'e sowu. ");
INSERT INTO gyz_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yek naami lok ka̱ iili, yek nal suk iili, yek iili ngap ka yek ba̱ kiɗi so. ");
INSERT INTO gyz_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yek naa wuda̱li jon lok ka̱ hwa lu yek sa̱ kiɗi, yek pa̱l gwe nal.>> Yesu pak ga̱ɓe wugo, yek ta̱ ga̱ɓa na̱ nda̱lti ɗe, <<Ma̱lgwe ka̱n kumti niɗɗa̱ go, ha̱n ta̱s kumi.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yek ma̱n kopti jwas ngemti ilgwe ta̱ lamisi dla̱mti ka̱ ga̱ɓe wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yek ta̱ wulsi ɗe, <<Kii wo sa̱ ba̱lkii yisti wul gwe ni ga̱ hwuda̱li ga̱ kangwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu, ama naa mbala̱n wo, a hwisi ga̱ɓa ga̱ hwuda̱li kangwe, <ko ta̱s yeni, sa man yenti so, ko ta̱s kumi, sa yis gaami so.> ");
INSERT INTO gyz_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Ilgwe a lamikii dla̱mti go yek ɗe, wunda̱l go yek ɗe ga̱ɓa ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jwe lok ten tantu go sa̱ ni na̱k ma̱jwe kum ga̱ɓe yek Sheɗan kan ɗa̱ ten mbadl gwasa̱n ka, ba̱s zi mbadl gwasa̱n ten Nya asa̱ mbi kisti so. ");
INSERT INTO gyz_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Wuda̱l jwe lok ka̱ gokca go sa̱ ni na̱k ma̱jwe kum ga̱ɓe yek sa̱ kan na̱ hwol tuki, ama yek ba̱ dlunti ka̱si so. Sa̱ ba̱l gem njet yek bomti tulisi wugo yek sa̱ pal na̱ kaali. ");
INSERT INTO gyz_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wuda̱l jwe lok ka̱ iil go sa̱ ni na̱k ma̱jwe kum ga̱ɓe ama yek da̱nti ga̱ se na̱ ayo suk lamti wul ji dii atli suk kumti ta̱mti da̱nti ngapsi yek ba̱ za̱t mbadl ten Nya gwasa̱n nda̱l so. ");
INSERT INTO gyz_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","A wunda̱l jwe lok ka̱ hwa lu go, sa̱ ni na̱k ma̱jwe kum ga̱ɓe wu, yek sa̱ ngiɓi ka̱ mbadl gwasa̱n yek sa̱ tlo mbadli yek za̱t mbadl ten Nya gwasa̱n nda̱li, yek sa̱ pa̱l hwa da̱nti. ");
INSERT INTO gyz_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","<<Mbala̱n a lak wutu ten pitila ata̱ yitle ka na̱ ka̱sa̱l so, sogo ata̱ zi te ga̱s gobdlan ka̱ so, ama ta zi ten wul za̱ti kangwe mas ma̱n tet ka̱ biimi a yen cilti wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mas ilgwe ni ga̱ hwuda̱li go a yil deɓa̱l, a mas ilgwe ni ga̱ yitle go a ɓuli. ");
INSERT INTO gyz_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pa̱n ɗem'ɗem na̱ kangwe aka̱ kat ka̱n wu, na̱k ɗe ma̱lgwe ilgon niɗɗa̱ wu, sa mba̱lit dani, a ma̱lgwe ba̱ ilgon niɗɗa̱ sogo nak njeti gwe niɗɗa̱ wu mago sa kamit ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yek ana suk yilkeni ji Yesu tul malti, ama yek ba̱sa̱ mbi mbukti lu malti so na̱k ɗe mbala̱n wonti hwo wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yek ma̱lgon wul Yesu ɗe, <<Ana gwa suk yilkeni jwa ni deɓa̱l sa̱ na̱ma lamti yenti gwa.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yek Yesu wulti ɗe, <<Ana gini suk yilkeni ji ka̱ɗe ma̱jwe kum ga̱ɓa ga̱ Nya yek sa̱ koɓi wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gas gon yek Yesu wul ma̱n kopti jwas ɗe, <<Ma̱ la̱n te ten ka̱t bi cikɗi ga̱ tekgu ka.>> Yek sa̱ te ka̱ jirgi ze yek sa̱ njel la̱ti. ");
INSERT INTO gyz_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Sa̱ na̱ma la̱t nugo, yek yeba̱l kan Yesu, yek bal yeta̱l gon tli tot ka̱ zesi, yek ɓanti dopsi na̱k ɗe zesi ɓalma tet ka̱ jirgi wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yek ma̱n kopti jwas pa̱da̱lti yek sa̱ wulti na̱ nda̱lti ɗe, <<Ma̱n lishti, tlinya ka, ma̱ ɓa lam ma̱shka̱n!>> Yek Yesu tlinya yek ta̱ matl yeta̱li suk ze gwe na̱ma tlit wu, yek zesi mul atli. ");
INSERT INTO gyz_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yek Yesu ngemsi ɗe, <<Za̱t mbadl gwaka̱n ɓal ko?>> Yek ɓanti cisi, yek sa̱ wul yilkeni ɗe, <<Wok ɗe ga̱n ɗe paa ata̱ matl yeta̱l suk ze gwe na̱ma tlit wu asa̱ kum ga̱ɓa gwas nu wo?>> ");
INSERT INTO gyz_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yek Yesu suk ma̱n kopti jwas ngusi la̱t ten ze yek sa̱ mbuki ten ka̱t atl ga̱ Garasina gwe ni ten ka̱t ang gon ga̱ zesi wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yek Yesu yil tot ten bi cikɗi wugo, yek ma̱n ma̱zhe gon ka̱wu koo tlisi gwe ata̱ da̱m ka̱lu gwe asa̱ lep mbala̱n wu, ata̱ mul wonti ka̱li wi. ");
INSERT INTO gyz_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na̱ yenti ga̱ Yesu, yek ta̱ nda a cina ɗatka yek ta̱ des lee, yek ta̱ wule, <<Yek moo sukki ye, Yesu, yen ga̱ Nya Bal Kakshe? A na̱ma ngemti gwa ba̱k nola̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ta̱ dla̱m nu ɗe ta̱ Yesu huulti suk ma̱zhesi. A ma̱zhesi kul ɓoti ko ɗe asa̱n suk ang gwas wo ga̱ ɓali ka̱n ni na̱ zaa ga̱lla wu, a ma̱n ɓa̱tti gwas ni malti ama ata̱ ɓatl ka a ma̱zhesi mbolti te ka̱ me ka. ");
INSERT INTO gyz_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yek Yesu ngemti ɗe shin gwa ka̱ɗe wokko? Yek ta̱ wule, <<Wonti.>> Na̱k ɗe ma̱zhe jwe ni ka̱ti go wonti ka̱n sa̱ ni wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Yek ma̱zhesi ngusi ngemti ga̱ Yesu ba̱s mbolsi te ka̱lu gwe sa da̱n ka̱ bomti wu so. ");
INSERT INTO gyz_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A wonti alade jon na̱ma kyo ten za̱nda̱l njaa mal bal zesi, yek ma̱zhesi ngem Yesu ɗe ta̱s zaksi ta̱s te gipsi, yek ta̱ zaksi. ");
INSERT INTO gyz_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Yek sa̱ yil ɗa̱ka̱ ma̱li ka yek sa̱ te ka̱ aladesi, yek aladesi tli na̱ apti yek sa̱ lok ka̱ bal zesi yek sa̱ ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yek ma̱n kyo aladesi yeni nu wugo, yek sa̱ aɓi yek sa̱ lak hwi mbala̱n ɗa̱nka̱ ba̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Yek mbala̱mi yili ta̱s lak yen ilgwe pi wu, yek sa̱ li tet mal Yesu wugo, yek sa̱ yen ma̱lgwe ma̱zhe yil ɗa̱ka̱ ti ka̱wu njaa mal Yesu na̱ luka̱l ten tli ata̱ ɓal hwaɓi, yek ɓanti njel cit gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yek ma̱jwe ni ka̱li ɗe ili pi wu, ngusi hwiti mbala̱n kangwe Yesu ndok ma̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yek mas mbala̱n ka̱ atl ga̱ Garasina ngem Yesu ta̱s zak ba̱mi na̱k ɗe ɓanti cisi i'e wu. Yek Yesu ɓa te ka̱ jirgi ta̱s zigaa go, ");
INSERT INTO gyz_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","yek ma̱lgwe ta̱ yillit ma̱zhesi ka̱wu ngemti ɗe, <<Ba kopki,>> ama yek ba̱ Yesu zigaa sukti so. ");
INSERT INTO gyz_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Yek Yesu wulti ɗe, <<Pal gee ta̱k dla̱m ilgwe Nya pa̱lik wu.>> Yek ma̱li li ka̱ bal ba̱mi yek ta̱ ngusi dla̱mti ilgwe Yesu pa̱lit wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yek Yesu pal te ten ka̱t bi bal ze gon wu ka̱wu yek mbala̱n wonti pa̱lit ɗem, na̱k ɗe ti ka̱n sa̱ na̱ma ɓa̱tti gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yek ma̱lgon ka̱wu asa̱ mbet ɗe Yayirus, bali ka̱n ka̱lu motgaa ga̱ gwasa̱n, yek ta̱ lak ngus a cina ɗa̱ Yesu ka ata̱ na̱ma ngemti gwas ɗe ta̱s li tet lubii ɗatka. ");
INSERT INTO gyz_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yen gwas ɗe na̱m ga̱ ma̱dli ma̱n gin ɗe kutl cet lop ɓal njaa ta̱s ma̱shi. Yek Yesu ɓal ten tantu la̱t lubiimi go yek mbala̱n wonti ngusi kopti gwasi asa̱ na̱ma ɗamti njaa malti. ");
INSERT INTO gyz_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","A kili gon ni ka̱ mbala̱mi gwe pa̱l gin ɗe kutl cet lop a hwulan nitma shoti wu, a ba̱ta̱ mbi ma̱lgwe a ndokti wu so. ");
INSERT INTO gyz_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yek ta̱ te teka̱ mbala̱mi ka yek ta̱ li tukaal ɗa̱ Yesu ka yek ta̱ ta̱n bi luka̱l gwasi, ninge-ninge yek shoti hwulami tlo ang. ");
INSERT INTO gyz_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yek Yesu wule, <<Wok ta̱na̱n wo?>> Yek kokko wule tik so, yek Siman Biturus wule, <<Ma̱n lishti, mbala̱n wonti lakki tlo, asa̱ na̱ma ngapti gwa.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yek Yesu wule, <<Ma̱lgon ta̱na̱nni, a kum nda̱lti yil tet ka̱ ami.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yek kilisi yeni go sa̱ yisit lu ka̱wi, yek ta̱ yil teɗi a tli gwas na̱ma da̱dalti yek ta̱ lak ngus a cina ɗa̱ Yesu ka, yek ta̱ dla̱mit ilgwe laki ɗe ta̱ ta̱nti wu suk kangwe ta̱ mbi ndokti ka̱li wu a cina ɗa̱ mbala̱n mas. ");
INSERT INTO gyz_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yek Yesu wulti ɗe, <<Kili mbala̱n, za̱t mbadl ten Nya gwa ndokki wi, zigaa na̱ ta̱mi mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","A ba̱ Yesu ɓo pak ga̱ɓe so, yek yen shinti ka̱ ɓal wu tet lubii ɗa̱ Yayirus ka, yek ta̱ hwi Yayirus ɗe, <<Ba̱ ma̱n lishtisi po tlamba la̱t tet so, yeni ma̱sh wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yek Yesu kumi nu wugo, yek ta̱ wul Yayirus ɗe, <<Ba̱ ɓanti cik so, zi mbadl ɗe ta tli ɗa̱ka̱ ma̱shka̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Sa̱ mbuk lu lubiimi wugo, yek ba̱ta̱ zak ma̱lgon ta̱s te ka̱ biimi sukti so se Biturus suk Yohana suk Yakubu suk aba na̱ ana ga̱ yeni. ");
INSERT INTO gyz_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mas mbala̱n jwe ni ka̱ lubiimi go yek sa̱ pita kulu asa̱ na̱ma desti lee na̱ ma̱shka̱n ga̱ yen kilisi. Yek Yesu wulsi ɗe, <<Po kula̱n so, yen kilisi ɓo ma̱sh so, yeba̱l ka̱n ta̱ na̱ma ndeti.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yek sa̱ mboshu ka̱ ga̱ɓe yek sa̱ gitlti, na̱k ɗe sa̱ yisi ɗe ta̱ ma̱sh wu. ");
INSERT INTO gyz_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yek Yesu ngip ang ga̱ yeni, yek ta̱ ga̱ɓa na̱ nda̱lti ɗe, <<Yen mbala̱n, tlinya.>> ");
INSERT INTO gyz_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yek mbadl gwas palli, yek ta̱ tlinya ninge, yek Yesu wulsi ɗe ta̱s ba̱lti ilga̱ nguki. ");
INSERT INTO gyz_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yek ma̱n za̱t ga̱ yeni ngip bi ka̱ ang. Ama yek Yesu wulsi ɗe ba̱s hwi ma̱lgon so. ");
INSERT INTO gyz_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu mo mil shinti ji botli jwas ɗe kutl cet lop wu, yek ta̱ ba̱lsi nda̱lti ta̱s yilli mas ma̱zhe ka suk ta̱s ndok mbala̱n ma̱n cwo wonti, ");
INSERT INTO gyz_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","yek ta̱ shinsi ta̱s dla̱misi ga̱ɓa ten kangwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu a ta̱s ndok mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ta̱ wulsi ɗe, <<Ba̱k kama̱n ilgon ang so ɗe ka̱ɓa li wu, ba̱k kama̱n sada so, a ba̱k kama̱n ngura so, a ba̱k kama̱n ilga̱ nguki so, a ba̱k kama̱n wulpi so, a ba̱k kama̱n luka̱l ɗe lop so. ");
INSERT INTO gyz_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Mas lubii gwe sa̱ kan ki wu, da̱ma̱n ka̱li, se gas gwe ka zigaa wu. ");
INSERT INTO gyz_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Mas ba̱n gwe nge kanti gwaka̱n wu, ka̱ɓa zak ba̱mi go aka̱ bat kushka ga̱ ba̱mi ɗa̱ ten asa̱n gwaka̱n ka, yek ka da̱n ɗe ilgwe a daamisi ga̱ɓa gwe ka̱ hwisi wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yek sa̱ yili yek sa̱ ngusi tet ɗa̱nka̱ ba̱mi ka asa̱ na̱ma dla̱mti ga̱ɓa ga̱ Nya ma̱n ta̱mti asa̱ na̱ma ndokti ga̱ ma̱n cwo mas lu gwe sa̱ li wu. ");
INSERT INTO gyz_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Yek Hiridus guu kum ilgwe na̱ma pa̱t wu wugo yek ili hwotti i'e. Naa mbala̱n wule, Yohana ma̱n baptisma ka̱n Nya palla̱t na̱ mbadli. ");
INSERT INTO gyz_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Naa mbala̱mi jon wule Iliya ka̱ palli. Naami wo sa̱ wule ɗe na̱m ka̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya ji cina ka̱n Nya palla̱t kaami. ");
INSERT INTO gyz_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Yek Hiridus wule, <<Yohana wo a laki yek sa̱ kotlit gaa ka̱wi, wok ɗe gwe a yima kumti wul wonti tenti go?>> Yek ta̱ ngwe ta̱s yenti. ");
INSERT INTO gyz_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mil shinti ji botlisi pal wugo, yek sa̱ hwi Yesu ilgwe sa̱ pa̱li wu, yek ta̱ li ka̱ ba̱n gon asa̱ mbe ɗe Betsaida suk mil shinti jwasi na̱ ngusa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mbala̱n yeni nu wugo, yek sa̱ kopti wonti, yek ta̱ kan ma̱nda̱ki gwasa̱n yek ta̱ hwisi ga̱ɓa ten kangwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu, yek ta̱ ndok ma̱n cwo. ");
INSERT INTO gyz_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Cin ɓal njaa ta̱ nda bii go, yek ma̱n kopti ɗe kutl cet lop ju, li tet malti yek sa̱ wulti ɗe, <<Hwi mbala̱n jee ta̱s zigaa ta̱s lak ngo ilga̱ nguki suk lu gwe sa mul wu ɗa̱nka̱ ba̱n jwe ni njaa wu ka, a ɗee ɗe ma̱ na̱n go, a kansi so, aba̱ ilga̱ nguki ni ɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yek Yesu wulsi ɗe, <<Ba̱la̱nsi ilga̱ nguki ci la,>> yek sa̱ wule, <<Burodi ɗe namtan suk kwes ɗe lop ka̱ nini ɗa, kume nuk go ta̱n lak wuli ilga̱ nguki mbala̱mi teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Maani zamba̱l kutl ɗe namtan ka̱ ni ka̱li. Yek ta̱ wul ma̱n kopti jwas ɗe, <<Moosi kutl ɗe namtan-namtan asa̱ da̱m na̱ zhila.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yek sa̱ pa̱li nu, yek mas jwasa̱n sa̱ da̱m atli. ");
INSERT INTO gyz_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yek Yesu kan burodi ɗe namtan wu, yek ta̱ tlil gaa nya yek ta̱ pa̱l hwol tuk na̱ Nya, yek ta̱ cal burodisi yek ta̱ ba̱l ma̱n kopti jwasi yek sa̱ hwuli mbala̱mi. ");
INSERT INTO gyz_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Yek sa̱ nguki yek kumsi yek sa̱ mo naami gwe sa wu hal njika̱n ga̱ɗa kutl cet lop. ");
INSERT INTO gyz_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Gas gon, Yesu na̱ma ngemti Nya na̱ ngusi yek ma̱n kopti jwas li tet malti yek ta̱ ngemsi ɗe, <<Mbala̱n wule wok ɗe ami wo?>> ");
INSERT INTO gyz_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yek sa̱ wulti ɗe, <<Mbala̱n wule Yohana ma̱n baptisma ka̱ɗe ki, naami wo sa̱ wule Iliya, a naami wo sa̱ wule ɗe na̱m ka̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya ji cina ka̱n Nya palla̱t kaami wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yek ta̱ wulsi ɗe, <<A kii hwa? Ɗe wok ka̱a̱ yisa̱n wo?>> Yek Siman Biturus wulti ɗe, <<Kik ɗe Almasihu gwe Nya shinti sut wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yek Yesu hwisi ɗe ba̱s hwi ma̱lgon so. ");
INSERT INTO gyz_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yek ta̱ wulsi ɗe, <<Ngetli ka̱n ta̱ Yen ga̱ Mbala̱n tla bomti ten wul wonti, a kiɗi mbala̱n suk kiɗi ma̱n Pa̱ris suk ma̱n yisti mba̱t ga̱ Musa a ngeti, a mbala̱n a tloti. Ama ten ndat cin na̱ mekan wo Nya a palla̱t kaami.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yek ta̱ wul mbala̱mi mas jwasa̱n ɗe, <<Mas ma̱lgwe lam da̱nti ɗe ma̱n kopti gi go, se ta̱ nge gaa gwasi, ata̱ lam tet ka̱ bomti ten da̱nti ɗe ma̱n kopti gini ko gasi. ");
INSERT INTO gyz_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Na̱ nu ka̱n mas ma̱lgwe lam gaa gwas man kopti gi go, ta mbi Nya boo so. Ama ma̱lgwe ba̱l gaa gwas ten kopti gi go, ta mbi Nya boo. ");
INSERT INTO gyz_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Yek ɗe ta̱mti ga̱ mbala̱n ye, ɗe ta̱ mbi mas hwa wul ten dii atli a ba̱ta̱ mbi Nya boo sowu? ");
INSERT INTO gyz_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na̱ nu ka̱n mas ma̱lgwe nsha kopti gi citi suk ga̱ ga̱ɓa gi go, nsha yisti gwas a cinni ami Yen ga̱ Mbala̱n ɗe a pal sut na̱ nalti gini suk nalti ga̱ bal Aba gini suk ga̱ mil shinti ga̱ Nya ma̱n cilti wu. ");
INSERT INTO gyz_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gem ka̱n a ni kii ma hwiti ɗe ma̱jon ni ka̱ kii jwe sa ma̱sh so se sa̱ yen gas gwe Nya a da̱n ɗe guu ka̱ mbadl gwasa̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kaal ɗa̱ multi ɗe wusupsi ɗe Yesu pak dla̱mti ga̱ɓa wu, yek ta̱ kan ka̱ Biturus suk Yohana suk Yakubu, yek ta̱ to ka̱ tla̱da̱l suksi ta̱s ngem Nya. ");
INSERT INTO gyz_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ta̱ ɓalma ngemti Nya go, yek cinagwel gwas balla̱ti, yek luka̱l gwas pal hwoli na̱ cilti hal na̱ma zhila̱kti gwel. ");
INSERT INTO gyz_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Sa̱ ni nugo yek mbala̱n ɗe lop ka̱wu, ka̱ Musa suk Iliya ");
INSERT INTO gyz_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ka̱ nalti ga̱ Nya asa̱ na̱ma ga̱ɓa sukti ten bi gas gwe ta pal to Nya ka̱wu suk ma̱shka̱n gwe ta ma̱sh a Wurshelima ta̱s njika̱n ilgwe Nya dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Biturus suk ma̱jwe ni sukti wu dlenti ka̱ yeba̱l wi, ama yek sa̱ pa̱da̱l wugo yek sa̱ yen nalti gwasi suk mbala̱n ɗe lop jwe ni sukti wu. ");
INSERT INTO gyz_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Mbala̱n ɗe loɓi ɓa lam za̱tgaa go, yek Biturus wul Yesu ɗe, <<Ma̱n lishti, mbuni ɗe ma̱ na̱n a ɗee wu, ha̱n ta̱n pa̱likii mil bii ɗe mekan, gon wo gwa a gon wo ga̱ Musa a gon wo ga̱ Iliya.>> A ba̱ Biturus yis ilgwe ta̱ na̱ma dla̱mti wu so. ");
INSERT INTO gyz_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ta̱ na̱ma dla̱mti nugo, yek kaluntun yitlasi ka, yek ɓanti njel cit gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yek ga̱ɓa wul sut ka̱ kaluntumi ɗe, <<Ga̱n go tik ɗe yen gi gwe a botlti wu, kuma̱n ga̱ɓa gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Yek ga̱ɓe paki wugo, yek sa̱ yen Yesu na̱ ngusi. Yek ba̱sa̱ hwi ma̱lgon ilgwe pi wu ka̱ multi jwisi so se ka̱ kaali. ");
INSERT INTO gyz_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kaal ɗa̱ multi ɗe na̱m, yek sa̱ yil sut ɗa̱ka̱ tla̱nda̱li ka̱ wugo yek mbala̱n wonti mbi Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yek ma̱lgon ka̱ mbala̱mi wule, <<Ma̱n lishti, a na̱ma ngemti gwa ta̱k yen gonti ga̱ yen gini, tik ni ɗa na̱ ngusi. ");
INSERT INTO gyz_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A ma̱zhe kul twet ka̱ gaa, ata̱ lak yal, a ma̱zhesi ɓot ten atli, a bi gwas yilli hwol ɓaka̱n. A ba̱ta zakti so se ta̱ kumit cwo na̱k wule ta tloti. ");
INSERT INTO gyz_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yek a ngem ma̱n kopti jwa ta̱s yilla̱si ka yek ba̱sa mani so.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yek Yesu wulsi ɗe, <<Kii mbala̱n ji se wo ka̱a̱ zi mbadl ten Nya so a ma̱n yokit ka̱ɗe kii, hal a gasi ka̱n ba da̱n sukkii a na̱ma tlot mbadl na̱ la̱shi za̱t mbadl gwaka̱n ten Nya gwi? Ta̱la yeni teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yeni ɓa li tet mal Yesu go yek ma̱zhesi ɓot ten atli. Yek Yesu matl ma̱zhesi, yek ta̱ ndok yeni, yek ta̱ ba̱ltiti aba gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yek ɓanti cisi, ɗe sa̱ yen nalti ga̱ Nya wu yek sa̱ ngip bi ka̱ ang. A sa̱ yima yenti wul cit ɓanti gwe Yesu pa̱li wu, yek ta̱ wul ma̱n kopti jwas ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Ba̱k ma̱sa̱na̱n ilgwe ba hwikii wu so. Sa ba̱l bi gini ami Yen ga̱ Mbala̱n a ang ɗa̱ byas mbala̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ama yek ba̱sa̱ yis ilgwe ta̱ nisi ma hwiti wu so, ga̱ hwuda̱li ka̱n ni malsi, a ɓanti kumti ga̱zi na̱ma cit gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yek ga̱ɓa nda ka̱ dlo ji ma̱n kopti ji Yesu ten ɗe wok ka da̱n ɗe bali ka̱si wo. ");
INSERT INTO gyz_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yek Yesu yis daamti gwasa̱n yek ta̱ kan nak'en yen gon yek ta̱ za̱t njaa malti. ");
INSERT INTO gyz_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yek ta̱ wulsi ɗe, <<Mas ma̱lgwe kan nak'en yen mbala̱n na̱k ga̱n ka̱ lal gi go, ami ka̱n ta̱ kama̱nni. A ma̱lgwe kama̱n go, ta̱ kan ma̱lgwe shina̱n sut wu. Ma̱lgwe tik ɗe nak'eni ka̱ kii mas go, tik ɗe bali.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yek Yohana wul Yesu ɗe, <<Ma̱n lishti, ma̱ yen ma̱lgon ta̱ na̱ma yilla̱t ga̱ ma̱zhe ka ka̱ shin gwa, yek ma̱ hwit ɗe ta̱s zaki na̱k ɗe ba̱ta̱ ni ka̱ mi sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yek Yesu wulsi ɗe, <<Zaka̱nti, ma̱jwe ngekii sogo gwaka̱n ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ta̱ ɓal njaa ta̱s pal to Nya ka̱go yek ta̱ zi ka̱ mbadl gwas ɗe ta li Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yek ta̱ shin mil shinti cina ɗati ta̱s la̱ka̱misi lu ka̱ ba̱n Samariya gon. ");
INSERT INTO gyz_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Yek ma̱n ba̱mi nge kanti ga̱ Yesu na̱k ɗe sa̱ yisi ɗe a Wurshelima ka̱n ta̱ lam sut wu. ");
INSERT INTO gyz_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma̱n kopti jwasi ka̱ Yakubu suk Yohana yeni nu wugo, yek sa̱ wul Yesu ɗe, <<Bagaa, ka̱ lami ta̱n mbe wutu sut nya ta̱ kwelsi ka?>> ");
INSERT INTO gyz_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yek Yesu balla̱t malsi yek ta̱ matlsi. ");
INSERT INTO gyz_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yek sa̱ li ka̱ ba̱mi gon. ");
INSERT INTO gyz_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Sa̱ na̱ma la̱t ten tantu, yek ma̱lgon wul Yesu ɗe, <<Ba kopki mas lu gwe ka li wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yek Yesu wulti ɗe, <<Gwengwen wo shu da̱nti nisi ɗa, yatl mago lumulti nisi ɗa, ama ami Yen ga̱ Mbala̱n wo lumulti niɗɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yek ta̱ po wul ma̱lgon ɗa̱ɗe, <<Koɓa̱nni.>> Yek ma̱li wulti ɗe, <<Bagaa, ha̱nta ɓa̱t ma̱shka̱n ga̱ aba gini aa lepti paa.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yek Yesu wulti ɗe, <<Zak ma̱jwe ma̱sh wu ta̱s lep yilkeni jwasa̱n, ama ki wo lak dla̱mi mbala̱n ga̱ɓa ten kangwe sa kan Nya ɗe guu ka̱ mbadl gwasa̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yek ma̱lgon po wulti ɗa̱ɗe, <<Bagaa, ami wo ba kopki, ama ha̱nta lak palli bi a lubii paa.>> ");
INSERT INTO gyz_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yek Yesu wulti ɗe, <<Mas ma̱lgwe nda gut zhin na̱ gil tla ata̱ na̱ma celti gwel kaal go, ta man kanti ga̱ Nya ɗe guu ka̱ mbadl gwas so.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kaal ɗa̱ nugo yek Bagaa Yesu botl mbala̱n ɗe kutl ɗe nitgi na̱ lop jon yek ta shinsi lop-lop ka̱ ba̱n jwe ta̱ lam la̱t na̱ gaa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yek ta̱ wulsi ɗe, <<Zhimi nali, aba̱ ma̱n wotlti wonti so. Ngema̱n ma̱n zhimi, ta̱s shin ma̱n wotlti teɗi ta̱s wotli. ");
INSERT INTO gyz_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","La̱nni, a shinti, na̱k mil mba̱la ka̱ tlo ji hwuli. ");
INSERT INTO gyz_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ba̱k kama̱n wulpi ko ngura ko kapta̱lan ang so, a ba̱k da̱ma̱n ɗe ka ga̱ɓe ma̱lgon ten tantu so. ");
INSERT INTO gyz_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","<<Mas lubii gwe ka̱ te giɓi wu aka̱ wule, <Ta̱mi mbadl ka̱ lubii gee.> ");
INSERT INTO gyz_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kume ma̱n hwol tuk ni ka̱ lubiimi go hwol tuk gwaka̱n a da̱miti. A kume ma̱n hwol tuk ni ka̱ lubiimi sowu, ta̱mi mbadl gwaka̱n a pallikii. ");
INSERT INTO gyz_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Da̱ma̱n ka̱ lubiimi aka̱ nguki aka̱ tla mas ilgwe sa̱ ba̱lkii wu na̱k ɗe ma̱lgwe pa̱l ilga̱ pa̱li go ta mbi ɓatlti gwasi wu. Ba̱k koɓa̱n lubii ɗa̱nka̱ so. ");
INSERT INTO gyz_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","<<Kume ka̱a̱ te ka̱ ba̱n yek sa̱ pikii ɗem wu, nguka̱n mas ilgwe sa̱ ba̱lkii wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ndoka̱n ma̱n cwo ka̱ ba̱mi aka̱ hwisi ɗe, <Cin gwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu ɓal njaa malkii.> ");
INSERT INTO gyz_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ama kume ka̱a̱ te ka̱ ba̱n yek ba̱sa̱ pikii ɗem sogo, aka̱ yil ɗa̱n ten tantu ba̱mi ka aka̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Kushka ga̱ ba̱n gwaka̱n mago ma bat ɗa̱ ten asa̱n ga̱na̱n ka̱wi. Ama ta̱k yisi ɗe cin gwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n ɓal njaa malki.> ");
INSERT INTO gyz_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A ni kii ma hwiti ɗe, gas pakti ga̱ dii atl wo, Nya a yen gonti ga̱ ma̱n Sodom man ma̱n ba̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Ka̱a̱ da̱n ɗe wul cit gonti wi ma̱n Korazin suk Betsaida, wul cit ɓanti gwe sa̱ pa̱likii wu ka̱n sa pa̱li ma̱n Taya suk ma̱n Sidon go, sa ci atl gaa wi ba̱ sen so. Sa lak gus luka̱l asa̱ da̱n ka̱ mba̱tla̱l asa̱ daamsi ten byas wul jwe sa̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gas pakti ga̱ dii atl wo, Nya a yen gonti ga̱ ma̱n Taya suk Sidon mankii. ");
INSERT INTO gyz_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kii ma̱n Kaparnahum, ka̱ da̱ma̱n gwa we Nya a kankii to nya ka? Ko njaa! Nya a sulkii aka̱ da̱nti ga̱ ma̱n ma̱shka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","<<Mas ma̱lgwe kum ga̱ɓa gwaka̱n go ta̱ kumti ga̱ɓa gini wi, mas ma̱lgwe nge kumti ga̱ɓa gwaka̱n go ta̱ nge kumti ga̱ɓa gini, mas ma̱lgwe nge kumti ga̱ɓa gi go ta̱ nge Nya ma̱lgwe shina̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yek mbala̱n ɗe kutl ɗe nitgi na̱ lop ju palli na̱ hwol tuki yek sa̱ wul Yesu ɗe, <<Bagaa, ma̱zhe mago asa̱ kum ga̱ɓa ga̱na̱n ɗe ma̱ hwisi ga̱ɓa ka̱ shin gwa wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yek Yesu wulsi ɗe, <<A yen Sheɗan nda sut nya na̱k nyaze gwe ci bi sut nya wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","A ba̱lki nda̱lti gwe ka li ka̱ dlo ji wuci suk yenda̱l a ba̱sa pa̱likii ilgon sowu, aka̱ mani na̱ ma̱n nget gwaka̱n Sheɗan. ");
INSERT INTO gyz_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mas na̱ nu, ba̱k pa̱la̱n hwol tuk ɗe ma̱zhe kum ga̱ɓa gwaka̱n so, ama pa̱la̱n hwol tuk ɗe shin gwaka̱n ni ga̱ lishi a nya.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ka̱ multi jwisi, yek Yesu njika̱n na̱ hwol tuk ga̱ Shishi ga̱ Nya yek ta̱ wule, <<A pa̱l hwol tuk na̱ ki, Aba gini, Bagaa ga̱ nya suk dii atli, ɗe ka̱ hwuda̱li mas wul ju ma̱n ɓotlka̱n suk ma̱n yisti wul, yek ka̱ ba̱l yisti nak mil mbala̱n wu. Nu ka̱n ni, Aba, ɗe mbuniki ta̱k pa̱li nu wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","<<Aba gi ba̱la̱n wul mas. Ma̱lgon yis yeni wu so, se Abe na̱ ngusi. A ba̱ ma̱lgon yis Abe so se yeni suk ma̱jwe yeni lami ɗe ta̱ ba̱lsi yisti wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yek Yesu balla̱t mal ma̱n kopti jwasi, yek ta̱ hwisi na̱ ngusa̱n ɗe, <<Kii wo ma̱n mbit hwa wul ka̱n ɗe gwel gwaka̱n yenikii ilgwe ka̱ yeni wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","A ni kii ma hwiti, ma̱n dla̱mti ga̱ɓa ga̱ Nya wonti suk guu lami ta̱s yen ilgwe ka̱ yeni, yek ba̱sa̱ yeni so, ta̱s kum ilgwe ka̱ kumi wu yek ba̱sa̱ kumi so.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Gas gon ma̱n yisti mba̱t ga̱ Musa gon tlinya ka̱ mbala̱n ta̱s cinga̱l yisti Yesu, yek ta̱ wulti ɗe, <<Ma̱n lishti, yek nii ngetli ɗe ta pa̱li a mbi Nya boo ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yek Yesu ballit ɗe, <<Yek mba̱t ga̱ Musa dla̱m ye? Nii ka̱n ka̱ yisi gwi?>> ");
INSERT INTO gyz_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yek ma̱li wule, << <Lam Bagaa Nya gwa na̱ mas mbadl gwa na̱ mas yisti gwa na̱ mas nda̱lti gwa, aka̱ lam yela̱n da̱nti gwa na̱k gaa gwa.> >> ");
INSERT INTO gyz_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yek Yesu wule, <<Gem ka̱n ka̱ dla̱mi, ka̱ pa̱li nugo, ka mbi Nya boo.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yek ba̱ ma̱li lami ɗe ta̱ Yesu ngipti na̱ byas wul so, yek ta̱ wule, <<Wok ɗe yela̱n da̱nti gi wo?>> ");
INSERT INTO gyz_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yek Yesu hwisi ga̱ɓa gon yek ta̱ wule, <<Gas gon ma̱lgon yil sut Wurshelima ta su Jeriko, yek ta̱ mo suk kiɗi muka̱l ma̱n ɓa̱tti tantu. Yek sa̱ dopti, yek sa̱ ɓoti, yek sa̱ yemit wul ka, yek sa̱ zakti a atli na̱k hwuuni. ");
INSERT INTO gyz_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Yek bal ma̱n Pa̱ris gon yil sut Wurshelima pak, yek ta̱ yen ma̱lgwe muka̱l dopti yek sa̱ ɓot wu, yek ta̱ tlat a malka̱n ɗatka yek ta̱ zigaa ilgon gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yek yen shinti ga̱ bal ma̱n da̱nti ka̱ bii ngemti Nyami koɓi tuka̱li pak yek ta̱ yenti a atli, yek ta̱ zigaa ilgon gwas pak. ");
INSERT INTO gyz_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ni nugo, yek ma̱lgon yil tot Samariya yek ta̱ yen ma̱li a atli yek gonti gwas citi. ");
INSERT INTO gyz_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yek ta̱ li tet malti yek ta̱ polit lu gwe sa̱ wotlti wu ka, yek ta̱ wutit ika̱n dani. Yek ta̱ kanti ten zhaki gwasi yek ta̱ ta̱lat ka̱lu multi ga̱ ma̱nda̱ki. ");
INSERT INTO gyz_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sa̱ mul ɗe na̱m wugo, yek ta̱ ba̱l wulpi ma̱n lubiimi. Yek ta̱ wulti ɗe, <Yeni ma̱li gee, kume ka̱ tlo wulpi nal man gwe a ba̱lki wugo ba palliki ɗe a pal wu.> >> ");
INSERT INTO gyz_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yek Yesu ngem ma̱n yisti mba̱ti ɗe, <<Ka̱ mbala̱n ɗe mekan jo, wok ɗe yela̱n da̱nti ga̱ ma̱lgwe te ang ɗa̱ muka̱l go?>> ");
INSERT INTO gyz_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yek ma̱li balli Yesu ɗe, <<Ma̱lgwe yen gonti ga̱ ma̱li wu.>> Yek Yesu wulti ɗe, <<Ki mago lak pa̱li nu.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesu suk ma̱n kopti jwas ni ten tantu Wurshelima yek sa̱ te ka̱ yen ba̱n gon gwe kili gon asa̱ mbet ɗe Marta kan ma̱nda̱ki gwasi a lubii ɗaat ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A yilka gon ni Marta ɗa asa̱ mbet ɗe Maryam ma̱lgwe da̱m njaa mal Bagaa Yesu ata̱ na̱ma kumti ga̱ɓa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta wo ta̱ na̱ma ta pa̱lti ilga̱ nguki, yek ta̱ li mal Yesu yek ta̱ wulti ɗe, <<Bagaa, ka̱ yen kangwe yilka gi zaka̱n na̱ ngwe ɗe a na̱ma pa̱lti mas wul wu sa, hwiti ta̱s lak zi ang.>> ");
INSERT INTO gyz_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yek Bagaa Yesu wulti ɗe, <<Marta, mbadl gwa tli ten ga̱ɓa ga̱n, wul wonti na̱ma hwotti gwa. ");
INSERT INTO gyz_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wul ɗe na̱m ka̱n ka daamki dani. Maryam botl ilgwe mbun wu aba̱ ma̱lgon a kamit ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Gas gon, Yesu na̱ma ngemti Nya ka̱lu gon. Ta̱ paki wugo, yek ɗe na̱m ka̱ ma̱n kopti jwas wulti ɗe, <<Bagaa, mbokinii ang ten kangwe ma ngem Nya wu, na̱k kangwe Yohana mboki ang ma̱n kopti jwas wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yek Yesu wulsi ɗe, <<Ka̱a̱ ɓa ngem Nya go aka̱ wule, <Nya bal Aba, ta̱ nalli shin gwa ma̱n cilti, da̱m ɗe guu ka̱ mbala̱n mas ten dii atli. ");
INSERT INTO gyz_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ba̱lnii ilga̱ nguki ga̱ mas cin. ");
INSERT INTO gyz_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","A ka̱ taasini byas wul jina̱n ka na̱k gwe ama̱ taas ga̱ yilkeni ɗa̱ ten mbadl ga̱na̱n ka̱wu. Ba̱k zakni ta̱n pa̱l byas wul so.> >> ");
INSERT INTO gyz_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yek Yesu po wul ma̱n kopti jwas ɗa̱ɗe, <<Wok nii ka̱ kii gwe ɗe ta li mal yela̱n da̱nti gwasi ka̱ tlo gasi ata̱ ngemit duul burodi ɗe mekan, yek ta̱ wulti ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","<Yekgu yela̱n gon gi tul mala̱nni tet ka̱lu gon, aba̱ ilga̱ nguki gwe ba ba̱lti wu ni ɗa̱ so.> ");
INSERT INTO gyz_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","<<A paa yela̱n da̱nti gwe ta̱ la ngot burodi malti wu wul tet punka ɗe, <Ba̱k hwota̱n so, ma̱ le dlabii ga̱na̱n ka̱wi, ma̱ mul atl wi suk mil jini bama̱n tlat nya a ba̱lki ilgon so.> ");
INSERT INTO gyz_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A ni kii ma hwiti ɗe ta tlinya ata̱ ba̱lti ilgon ten ɗe ti wo yela̱n da̱nti gwas so, ama na̱k ɗe ta̱ ngaɓit na̱k ngemti wu ta tlinya ata̱ ba̱lti mas ilgwe ta̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","<<A ni kii ma hwiti ɗa̱ɗe, pa̱nta ngemti, Nya a ba̱lkii. Pa̱nta ngoti, ka mbi. Pa̱nta kotlti dlabiimi, Nya a ɓulikii. ");
INSERT INTO gyz_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mas ma̱lgwe ngemi go, Nya a ba̱lti. Ma̱lgwe ngwe go, ta mbi. Ma̱lgwe ɓo dlabiimi go, Nya a ɓuliti. ");
INSERT INTO gyz_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","<<Wok yen gwas a ngemit kwes ka̱ kii, ata̱ ba̱lti wuci wo? ");
INSERT INTO gyz_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Sogo, ta̱ yen gwas ngemit mbutli, ata̱ ba̱lti yenda̱l wo? ");
INSERT INTO gyz_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kume kii ma̱n pa̱lti byas wul yek ka̱ yis kangwe ka ba̱l hwa wul mil jwaka̱n go, ɗa̱ nii ka̱n a kan bal Aba ga̱na̱n ga̱ to nya ka̱wu gaa gwi, ti ɗe ta ba̱l Shishi ga̱ Nya ma̱jwe ngemti wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Gas gon Yesu na̱ma yilla̱t ga̱ ma̱zhe gwe ba̱ta ga̱ɓa sowu ɗa̱ka̱ ma̱lgon ka. Yek ma̱zhesi yil ka̱ wugo, yek ma̱li ga̱ɓa yek ɓanti ci mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yek naa mbala̱mi wule, <<Guu ga̱ ma̱zhe ka̱ ba̱lti nda̱lti yilla̱t ma̱zhe ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Naa mbala̱mi jon lami ta̱s yen ilgwe ta pa̱li wu, yek sa̱ wulti ɗe, <<Pa̱lini wul cit ɓanti, ta̱n yisi ɗe sut mal nya ka̱n ka̱ ni.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yek Yesu yis daamti gwasa̱n wugo yek ta̱ wulsi ɗe, <<Kume mbala̱n ka̱ ba̱n ɗe na̱m dlansi ten tli gwasa̱n go, ba̱mi a dla̱l so, nu ka̱n mas lubii gwe calti ɗe lop asa̱ na̱ma nget ji yilkeni go lubiimi a nda. ");
INSERT INTO gyz_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kume Sheɗan calti ɗe lop ata̱ na̱ma nget ga̱ gaa gwas go, nii ka̱n nalti gwas a dla̱l gwi? Ka̱a̱ wule, na̱ nda̱lti ga̱ guu ma̱zhe ka̱n a na̱ma yilla̱t ga̱ ma̱zhe ka. ");
INSERT INTO gyz_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Kume ka̱ wule, na̱ nda̱lti ga̱ guu ma̱zhe ka̱n a na̱ma yilla̱t ma̱zhe ka̱go, a kii hwa, na̱ nda̱lti ga̱ wok aka̱ yilli ma̱zhesi ka̱ wo? ");
INSERT INTO gyz_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama kume na̱ nda̱lti ga̱ Nya ka̱n a na̱ma yilla̱t ga̱ ma̱zhe ka̱go, cin gwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu ɓa tuli. ");
INSERT INTO gyz_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","<<Kume nda̱li mbala̱n na̱ buula gwas da̱n na̱ ka̱n gaa ten ɓa̱t boo gwas go, ilgon a ta̱n wul lubii gwas so. ");
INSERT INTO gyz_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ama kume ma̱lgwe nda̱l manti wu tuli, yek ta̱ ndat na̱ dlanti, yek ta̱ man ngetl gwas go ta yem mas buula jwas jwe ta̱ nda̱l giɓi wu ka, ata̱ hwuli mbala̱n mas wul jwasi. ");
INSERT INTO gyz_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","<<Ma̱lgwe ni suk ami sogo, nget ka̱n ta̱ na̱ma nget gini; ma̱lgwe na̱ma mooti suk ami sogo, ta̱ na̱ma catti ka. ");
INSERT INTO gyz_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","A kume duu ma̱zhe yil ɗa̱ka̱ tli ga̱ mbala̱n ka̱ wu, ata̱ ngusi ma̱tlti ɗa̱nka̱ me ka ka̱lu gwe ba̱ ze ni ɗa̱ sowu ta̱s mbi lu shukti. Kume ta̱ mbi sowu, apaa ta̱ wule, <Ha̱n ta̱ pal te ka̱ ma̱lgwe a yil tet wu ka.> ");
INSERT INTO gyz_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kume ta̱ lak mbi mbadl ma̱li sa̱ taasi ka yek sa̱ la̱ka̱mi ka̱ wu, ");
INSERT INTO gyz_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ata̱ lak yem ma̱zhesi jon teɗi ɗe nitgi jwe yoki manti wu ta̱s lak da̱n ka̱li. Pakti da̱nti ga̱ ma̱llu a lil man kangwe ta̱ nda zhile wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesu dla̱m nu wugo, yek kili gon wulti na̱ nda̱lti ɗe, <<Ta Nya ba̱l hwa wul kili gwe zaki yek ta̱ ngipki yek ka̱ nal wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yek Yesu wulti ɗe, <<Nu ka̱n ni, ama ma̱jwe kum ga̱ɓa ga̱ Nya yek sa̱ koɓi wu mbi hwa wul mani.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mbala̱n ngusi mba̱lti wonta̱t mal Yesu wu, yek ta̱ nda wulti gwasa̱n ɗe, <<Mbala̱n ji se wo byas mbala̱n ka̱n, lamti gwasa̱n wo ta̱ pa̱lisi wul cit ɓanti ama ba̱sa yeni so se ga̱ Yona wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na̱k gwe Yona da̱n ɗe wul cit ɓanti mal ma̱n Neniba wu, nu ka̱n ami Yen ga̱ Mbala̱n a da̱mi mbala̱n ji se. ");
INSERT INTO gyz_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Gas pakti ga̱ dii atl wo, guu ga̱ ma̱dli tet Sheba a kudu a tlinya suk mbala̱n ji se, ata̱ hwisi ɗe sa̱ pa̱l hwa wul so. Ta̱ tul tet dlenti ta̱s kum ga̱ɓa ɓotlka̱n ga̱ guu Sulemanu, yek ma̱lgwe man Sulemanu wuk ɓal wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Gas pakti ga̱ dii atl wo, ma̱n Neniba a tlinya suk mbala̱n ji se asa̱ hwisi ɗe sa pa̱l hwa wul so na̱k ɗe si wo sa̱ ci atl gaa ɗe Yona hwisi ga̱ɓa ga̱ Nya wu, a yekgu ma̱lgwe man Yona wuk ɓal wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","<<Mbala̱n a lak wutu ten pitila ata̱ hwuda̱li ka̱ so, sogo ata̱ yitle ka na̱ gal so, ama ta zi ka̱lu gwe mas ma̱lgwe te ka̱ biimi wu a yen cilti wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gwel ka̱ɗe cilti ga̱ tli, kume gwel gwa ni hwaɓi wu, tli gwa ani na̱ cilti, ama kume gwel gwa ni hwaɓi sogo, mas tli gwa ani ka̱ da̱mshal. ");
INSERT INTO gyz_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pa̱n ɗem'ɗem ba̱ cilti gwaka̱n da̱n ɗe da̱mshal so. ");
INSERT INTO gyz_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kume mas tli gwa ni na̱ cilti wu, da̱mshal ani kii ɗa̱ so, mas a da̱m na̱ cilti na̱k gwe a pitila cilli lu wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesu pak ga̱ɓe wugo, yek ba Paresi gon mbet a lubii ɗatka ta̱s nguk wul, yek Yesu li ka̱ lubiimi ta̱s nguki. ");
INSERT INTO gyz_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yek ba Paresisi yeni ɗe Yesu pol ang paa ta̱ nda ngukti na̱k kangwe a Ma̱n Yehuda pa̱li wu sogo, yek ili hwotti. ");
INSERT INTO gyz_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Yek Yesu wulti ɗe, <<Kii ma̱n Paresi wo aka̱ pol mbuka ze suk gali, ama mbadl gwaka̱n ni ga̱ njikmi na̱ lamti mot wul suk yokiti. ");
INSERT INTO gyz_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ka̱dla̱n ka̱ɗe kii, ka̱ yisi ɗe Nya gwe pa̱l tukaali wu ka̱ pa̱l tugiɓi pak sa? ");
INSERT INTO gyz_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ka ba̱l ilga̱ nguki ma̱jwe ba̱ ilgon nisi ɗa̱ sowu tot ka̱ gal gwe aka̱ poli wu, a mbuni kii mal Nya mani. ");
INSERT INTO gyz_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","<<Ka̱a̱ da̱n ɗe wul cit gonti wi ma̱n Paresi, na̱k ɗe aka̱ ba̱l Nya ɗe na̱m ka̱ kutl ka̱ wul jwe aka̱ mbi wu na̱k wul wolo suk dik daa suk mitlgulu suk ngum, ama zok da̱nti suk lamti Nya wo yek ba̱ hwotkii so. Ngetli ka̱n ta̱k koɓa̱n jwisi, ama ba̱k zaka̱n jon ju so. ");
INSERT INTO gyz_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","<<Ka̱a̱ da̱n ɗe wul cit gonti wi ma̱n Paresi, na̱k ɗe lamti gwaka̱n wo ta̱s ba̱lkii hwa lu da̱nti ka̱lu motgaa ga̱ gwasa̱n ata̱ mbala̱n pita ga̱ɓet gwaka̱n ka̱lu motgaa wulti wul. ");
INSERT INTO gyz_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","<<Ka̱a̱ da̱n ɗe wul cit gonti wi, kii ma̱n Paresi na̱k gaa zukɗi gwe ba̱ mbala̱n a yeni sowu ka̱n ka̱ ni, jwe mbala̱n jwaka̱n na̱ma la̱t dani a ba̱sa̱ yisi ɗe yek ka laki asa̱ da̱n ɗe ma̱n da̱ska̱n sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yek gon ka̱ ma̱n yisti mba̱t ga̱ Musa wul Yesu ɗe, <<Ma̱n lishti, kume ka̱ dla̱m nugo, mi mago ka̱ byal nii.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yek Yesu wule, <<Ka̱a̱ da̱n ɗe wul cit gonti wi, kii ma̱n yisti mba̱t ga̱ Musa, na̱k ɗe ka̱a̱ zi diɓa̱l mba̱t mbala̱n ama kii wo ba̱ka zisi ang ta̱s man kopti ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","<<Ka̱a̱ da̱n ɗe wul cit gonti wi na̱k ɗe ka̱a̱ kin gaa zukɗi ga̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya mbuni jwe ma̱jwaka̱n ji cina tlosi wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kii na̱ gaa gwaka̱n, ka̱ yisi yek ka̱ kan ka̱ mbadl gwaka̱n ilgwe mbala̱n jwaka̱n ji cina pa̱li wu. Sa̱ tlo ma̱n dla̱mti ga̱ɓa ga̱ Nya yek kii ne go yek ka̱ kop kaal gwasa̱n ɗe ka̱ kin gaa zukɗi jwasa̱n mbuni wu. ");
INSERT INTO gyz_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yek laki yek Nya wul ka̱ yisti gwas ɗe, <Ba shinisi lu na̱ mil shinti ga̱ɓa ga̱ Nya suk mil shinti ji botli, mbala̱n a tlo naami, asa̱ nol naami.> ");
INSERT INTO gyz_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na̱ nu ka̱n Nya a dop mbala̱n ji se na̱ byas wul jwasa̱n ɗe sa tlo mas ma̱n dla̱mti ga̱ɓa ga̱ Nya tet ten ndat zhila da̱nti ka̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nde tet ten hwulan ga̱ Habila yek su sut ten ga̱ Zakariya, ma̱lgwe sa̱ tlot ka̱ tlo ga̱ lu takti wul Nya ka̱lu ma̱n cilti ka̱ lubii ga̱ Nya wu. Gem ka̱n a ni kii ma hwiti, sa dop mbala̱n ji se na̱ mas byas wul jwisi. ");
INSERT INTO gyz_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","<<Ka̱a̱ da̱n ɗe wul cit gonti wi, kii ma̱n yisti mba̱t ga̱ Musa, na̱k ɗe ka̱a̱ yis mba̱ti yek ka̱a̱ nge kopti kii gaa gwaka̱n, a ba̱ka̱a̱ zak ma̱lgon ta̱s yisi so.>> ");
INSERT INTO gyz_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesu zak lwisi wugo, yek ma̱n yisti mba̱t ga̱ Muse suk ma̱n Paresi nda ngabti gwasi, yek sa̱ ngusit ngot bi na̱ kumti ga̱s wul wonti. ");
INSERT INTO gyz_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Sa̱ na̱ma ngoti ta̱s telti ka̱ ga̱ɓa gwe ba̱ta man yilti ɗa̱ giɓi ka̱ sowu a ta̱s dla̱m ilgwe ba̱ yek sowu. ");
INSERT INTO gyz_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yek mbala̱n wonti mogaa mal Yesu hal wonta̱t gwasa̱n laki yek sa̱ na̱ma za̱t asa̱n ten ji yilkeni, yek Yesu nde hwit ga̱ɓa ma̱n kopti jwasi yek ta̱ wulsi ɗe, <<Pa̱n ɗem'ɗem ba̱k shela̱n lal yisti Nya na̱k ga̱ ma̱n Paresi wu ka̱ da̱nti gwaka̱n so. ");
INSERT INTO gyz_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ilgon ni ga̱ hwuda̱li gwe ba̱ a yil deɓa̱l sowu so. Sogo ga̱ hwuda̱li ɗe ba̱ mbala̱n a yisi sowu so. ");
INSERT INTO gyz_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ilgwe ka̱a̱ dla̱m ka̱ da̱mshal go a yil ten cilti. Ilgwe ka̱ dla̱m ga̱ hwuda̱li te punka ka̱go a kumi ten za̱nda̱l. ");
INSERT INTO gyz_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<A ni kii ma hwiti kii yela̱n jini, ba̱k ɓanti ma̱jwe a tloki wu, kaal ɗa̱ nugo a ba̱sa po man pa̱lti ilgon sowu so. ");
INSERT INTO gyz_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ama ba hwiki ma̱lgwe ka ɓantit wu, tik ɗe Nya ma̱lgwe kaal ɗa̱ tlot ga̱ tlisi ta man lakti gwaka̱n ka̱ boo wutu. Gem, ɓantiti. ");
INSERT INTO gyz_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ale yatl ɗe namtan wo kobo ɗe lop ka̱n asa̱ wul ka̱ nwa? Mas na̱ nu, Nya ma̱sa̱n gon gwasa̱n so. ");
INSERT INTO gyz_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ma̱dla̱n gaa gwaka̱n mago ga̱ dla̱mi ka̱n ni mas. Ba̱ ɓanti cikii so, ka̱ ni hwaɓi man wonti yadli. ");
INSERT INTO gyz_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<A ni kii ma hwiti ɗe mas ma̱lgwe dla̱m ka̱ mbala̱n ɗe ta̱ yisa̱n go, ami Yen ga̱ Mbala̱n a yisti a cina ɗa̱ mil shinti ji Nya ka. ");
INSERT INTO gyz_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma̱lgwe nge yisti gi a cina ɗa mbala̱n ka̱go, ami mago ba nge yisti gwas a cina ɗa̱ mil shinti ji Nya ka. ");
INSERT INTO gyz_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mas ma̱lgwe dla̱m ga̱ɓa mbulti ten ami Yen ga̱ Mbala̱n go sa taasit ka, ama ma̱lgwe dla̱m ga̱ɓa nget ga̱ Shishi ga̱ Nya go sa taasit ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","<<Kume sa̱ ta̱lakii ka̱lu motgaa ga̱ gwasa̱n sogo mal guu ji ba̱n sogo mal kiɗi ma̱n ba̱n, ba̱ hwotkii ɗe nii ka̱n ka yilli gaa gwaka̱n suk ilgwe ka dla̱m wu so ");
INSERT INTO gyz_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","na̱k ɗe Shishi ga̱ Nya a ba̱lkii ilgwe ka dla̱m ka̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yek ma̱lgon tet ka̱ mbala̱n wulti ɗe, <<Ma̱n lishti, hwi yilka gini ta̱s huulini ilgwe aba ga̱na̱n ma̱shi yek ta̱ zakini wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yek Yesu wulti ɗe, <<Ba mbala̱n, wok za̱n ɗe ma̱n huulti ga̱ɓa ka̱ tlo gwaka̱n wo?>> ");
INSERT INTO gyz_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yek ta̱ wulti ɗe, <<Pa̱n ɗem'ɗem ba̱k za̱n mbadl gwaka̱n ten mot wul wonti so, na̱k ɗe yek ka laki a mbala̱n mbi mbadl sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yek ta̱ cinga̱lisi ga̱ɓa gon ɗe, <<Ma̱n wul ang gon ka̱n, zhin mbunit i'e. ");
INSERT INTO gyz_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yek ta̱ daamti ka̱ mbadl gwas ɗe, <Nhu gwe ba wut wul zhin wu njika̱n ka̱wi.> ");
INSERT INTO gyz_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","<<Yek ta̱ po wul ka̱ mbadl gwas ɗa̱ɗe, <Ilgwe ba pa̱li go, ba tatl nhu jin ka a kin kiɗi a wut mas wul zhin gini suk wul ji giɓi. ");
INSERT INTO gyz_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","A paa a wul gaa gi ɗe, <<Wul wonti nik ɗa gwe a ta̱lak gin wonti wu, shuk ilgon gwa, aka̱ ngusi kumti ta̱mti.>> > ");
INSERT INTO gyz_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","<<Yek Nya wulti ɗe, <Ki wo ka̱dla̱n ka̱n, ka̱ gas nge ka̱n ka ma̱shi, ta ɓo yen ma̱lgwe a nguk ilga̱n ɗe ka̱ mwe gaa gwa wu.> >> ");
INSERT INTO gyz_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yek Yesu wuli ɗe, <<Nu ka̱n ani mal ma̱jwe mwe wul gaa gwasa̱n ten dii atli ama mal Nya wo ba̱ ilgon nisi ɗa̱ sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yek Yesu hwi ma̱n kopti jwas ɗe, <<A ni kii ma hwiti, ba̱ ilga̱ nguki suk luka̱l gwe ka lak wu hwotkii so. ");
INSERT INTO gyz_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kangwe ka da̱n wu manikii ilga̱ nguki sa? A ba̱ tli gwaka̱n manikii luka̱l sa? ");
INSERT INTO gyz_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɓo yena̱n yadli, ba̱sa ɓak zhin so a ba̱sa wotl so. A ba̱ nhu wutti ilga̱ nguki nisi ɗa̱ so, na̱k ɗe Nya ka̱ nisi ma ba̱lti ilga̱ nguki wu. Nya lamkii man kangwe ta lam yatl wu sa? ");
INSERT INTO gyz_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wok nii ka̱ kii ɗe ilgwe hwotti wu a mba̱lit multi ɗe na̱m dani wo? ");
INSERT INTO gyz_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kume ka̱a̱ mani pa̱lti nak mil wul gaa gwaka̱n nu sogo, yek laki yek ka̱a̱ na̱ma hwotti mbadl gwaka̱n ye? ");
INSERT INTO gyz_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","<<Ɓo yena̱n mbuni buzha ka̱ me kangwe asa̱ nal wu, ba̱sa pa̱l ilgon so, a ba̱sa pa̱li luka̱l gaa gwasa̱n so. Ama ko ta̱ Sulemanu guu na̱ nalti gwas mago ta̱ ɓo taɓa kinti gwas mbuni nu so. ");
INSERT INTO gyz_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kii ɗe ba̱ za̱t mbadl gwaka̱n ten Nya nda̱l sowu, kume nu ka̱n Nya pa̱l buzha ka̱ me mbuni jwe ase go sa̱ ni ɗa ama ayo go asa̱ lak ka̱ wutu wu, a kii ka̱n ba̱ta ba̱lkii luka̱l gwe ka lak wu sa? ");
INSERT INTO gyz_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ba̱k za̱n mbadl gwaka̱n ten ilga̱ nguki suk ilga̱ tle so, mas ba̱ hwotkii so. ");
INSERT INTO gyz_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mbala̱n ga̱ dii atl mas ɗe ba̱sa̱ yis Nya sowu na̱ma ngot wul jwisi, ama kii wo Aba gwaka̱n yisi ɗe ka̱ lami ta̱ wul jwisi ni kii ɗa̱. ");
INSERT INTO gyz_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dloka̱ma̱nkii ta̱k kama̱n Nya ɗe guu ka̱ mbadl gwaka̱n, Nya a ba̱lkii mas wul jwisi. ");
INSERT INTO gyz_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Ko ɗe ba̱ka̱a̱ wonti sogo, ba̱ ɓanti cikii so, na̱k ɗe bal Aba gwaka̱n pa̱l hwol tuk ɗe ta̱ telkii ka̱ boo gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wula̱n wul jwaka̱n ka aka̱a̱ ba̱l wulpi ma̱jwe ba̱ ilgon nisi ɗa̱ sowu. Za̱n wul jwaka̱n to nya ka, ka̱lu gwe ba̱ a lil ka̱ sowu, lu gwe muka̱l a mukli so, aba̱ da̱kmbi a lili ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Lu gwe wul jwaka̱n ni go ka̱li ka̱n mbadl gwaka̱n ani pak. ");
INSERT INTO gyz_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Da̱ma̱n na̱ ka̱n gaa, ta̱ wutu yenti lu gwaka̱n cili, ");
INSERT INTO gyz_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","na̱k zhel jwe na̱ma ɓa̱tti ga̱ baboo gwasa̱n ta̱s pal tet ka̱lu motgaa hapti wu. Ta̱ pal wugo ata̱ ɓwesi dlabi asa̱ ɓuliti ninge. ");
INSERT INTO gyz_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Zhel ju a mbi hwa wul kume baboomi palli a ba̱sa ɓo nde yeba̱l sowu. A ni kii ma hwit gem ɗe, ta ndus bal luka̱l gwe ta̱ lak wu ka, ata̱ wulsi ɗe ta̱s da̱m atli ta̱s nguk wul, ata̱ kopsi gaa-gaa ata̱ ba̱lsi ilga̱ nguki. ");
INSERT INTO gyz_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Zhel jo ma̱n mbit hwa wul ka̱n kume baboomi pal ka̱ tlo gas wu, sogo ka̱ bultlwe ata̱ mbisi ten ɓa̱tti gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ama ta̱k yisi ɗe, kume baboo a yis tulti ga̱ muka̱l go, ta zakti asa̱ tet lubii asa̱ lilit wul ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kii mago, da̱ma̱n na̱ ka̱n gaa, na̱k ɗe ami Yen ga̱ Mbala̱n ba palli gas gwe ba̱ka̱ ɓo zi tulti gi sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yek Biturus wul Yesu ɗe, <<Bagaa, cinga̱lti ga̱ɓa ga̱n go ten mi na̱ ngwe na̱n ma, ko ten mas mbala̱n?>> ");
INSERT INTO gyz_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yek Yesu wule, <<Wok ɗe ma̱n pa̱lti wul gibboo ga̱ baboo gwas ɗe ma̱n gem, ma̱n zok mbadli suk ma̱n ɓotlka̱n go? Ti ka̱n baboomi a zakit yenti lubii gwasi, ata̱ ba̱l zheli jon ju ilga̱ nguki na̱k gwe sa̱ zit pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Zhel go ma̱n mbit zok wul ka̱n ɗe baboo gwas a pal tet ka̱lu gwe ta̱ li wu ata̱ mbit ten pa̱lti hwa wul nu wu. ");
INSERT INTO gyz_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A ni kii hwiti gem ɗe, ta palli zhel wu ɗe bagaa ga̱ wul jwasi mas. ");
INSERT INTO gyz_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ama kume zhel wu wul ka̱ mbadl gwas ɗe, <Baboo gi pal ba̱le so,> yek ta̱ njel ɓot ji zheli jon ju na̱ modli na̱ maani, yek ta̱ njel tlati suk ngukti yek gaa ɓa gillit ka, ");
INSERT INTO gyz_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","baboo ga̱ zhel wu a palli gas gwe ba̱ta̱ yisi sowu. Baboomi a pa̱lit byas ɓoti ata̱ keshti ka ata̱ za̱t ndakce suk ma̱jwe ba̱ gem nisi ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","<<Zhel gwe yis ilgwe baboo gwas lami yek ba̱ta̱ zi ka̱ mbadl gwas ɗe ta̱s pa̱li sogo, sa pa̱lit byas ɓoti. ");
INSERT INTO gyz_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ama ma̱lgwe ba̱ta̱ yis ilgwe baboo gwas lami sowu, yek ta̱ pa̱l wul ɓot go, njet ka̱n sa ɓoti. Mas ma̱lgwe sa̱ ba̱lti wul nal go, sa ngo wul nal malti. Ma̱lgwe sa̱ ba̱lti nal mani go, nu ka̱n sa ngwe malti. ");
INSERT INTO gyz_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Wutu ka̱n a tuli ta laki mbala̱n ten dii atli, lamti gi wo ta̱ wuti tlo. ");
INSERT INTO gyz_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Baptisma gwe sa pa̱li wu ni ɗa̱, a mbadl gi tli wi i'e ta̱s pa̱li ni. ");
INSERT INTO gyz_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ka̱ da̱ma̱n gwa we ta̱mti ga̱ mbadl ka̱n a tullikii ten dii atli a? Ko njaa, a ni kii ma hwiti ɗe, huulti tlo ji yilkeni suk yilkeni ka̱n a tulli. ");
INSERT INTO gyz_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ndok ase, mbala̱n ɗe namtan ka̱ lubii a huul ɗe lop. Ɗe lop na̱ma nget ga̱ ɗe mekan, a ɗe mekan na̱ma nget ga̱ ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tlo gwasa̱n a hwuli, aba na̱ma nget ga̱ yen, a yen na̱ma nget ga̱ aba. Ana na̱ma nget ga̱ yen gwas ga̱ ma̱dli, yeni mago ata̱ na̱ma nget ga̱ ana gwasi. Nkwe ga̱ ma̱dli na̱ma nget ga̱ kili ga̱ yen gwasi. A kili ga̱ yeni na̱ma nget ga̱ ana ga̱ kos gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yek Yesu po wul mbala̱n ɗa̱ɗe, <<Kume ka̱a̱ yen nyaze tli tot wugo, aka̱a̱ wule ze a nda a zesi nda kuwa. ");
INSERT INTO gyz_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kume ka̱ kum yeta̱l ɓalma hotti tet go, aka̱ wule wutu cin a tuli, a wutu cinmi tul kuwa. ");
INSERT INTO gyz_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ki ma̱n pa̱lti riya, ka̱ man yisti kangwe a wul pi ten dii atli suk to nya ka̱wu, ama yisti wul gwe na̱ma pa̱t ningo yek kanki gaa. ");
INSERT INTO gyz_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Yek laki a ba̱ka daamki ta̱k yisa̱n ilgwe mbun ɗe ta̱k pa̱li wu so ye? ");
INSERT INTO gyz_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kume ma̱lgon mbet a dlaboo kisti ga̱ɓa wu, tloki ta̱k la̱ka̱n tlo gwa sukti ten tantu, kume ka̱ nge go, ta ta̱lak dlaboo mal ma̱n ndoka̱lti ga̱ɓa asa̱ telki ka̱lu gwe asa̱ le ma̱n pa̱lti byas wul wu. ");
INSERT INTO gyz_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A nikma hwiti ɗe, ka yil ɗa̱ka̱ lwisi ka̱ so se ka̱ ɓatl ilgwe sa̱ mboshik wu mas.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ka̱ multi jwisi ɗe Yesu nisi ma hwit ga̱ɓa wu, yek ma̱jon ɗe sa̱ ni ka̱li wu dla̱mi Yesu ma̱n Galili jwe Bilatus laki yek sa̱ tlosi asa̱ na̱ma mboshti mba̱la sogo mal ta̱s tak Nya wu. ");
INSERT INTO gyz_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yek Yesu nda̱kisi ɗe, <<Na̱k ɗe ma̱n Galili ju ma̱sh nugo, ka̱ da̱ma̱n gwa we sa̱ pa̱l byas wul man naa mbala̱n mas a Galili a? ");
INSERT INTO gyz_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ko njaa, a ni kii ma hwiti ɗe kume ka̱ ci atl gaa sogo nu ka̱n ka ma̱shi mas jwaka̱n na̱k gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ko mbala̱n ɗe kutl cet wusupsi jwe tlal bii ndesi gaa a Siluwam yek sa̱ ma̱sh go sa̱ pa̱l byas wul man mas ma̱n Wurshelima? ");
INSERT INTO gyz_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ko njaa, a ni kii ma hwiti, kume ka̱ ci atl gaa sogo nu ka̱n mas jwaka̱n ka ma̱shi na̱k gwasa̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yek Yesu cinga̱lisi ga̱ɓa gon ɗe, <<Ma̱lgon pa̱l zhin yandi inabi gwasi yek ta̱ ɓak tlindi tula̱n a giɓi, yek ta̱ li ka̱ zhimi ta̱s kotl yandi tula̱mi ama yek ba̱ta̱ mbi ilgon dani so. ");
INSERT INTO gyz_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Yek ta̱ wul ma̱lgwe zhimi nit ang wu ɗe, <Gin naa ɗe mekan ka̱ ɓal gee ɗe a na̱ma tulti ngot yandi a dani a ba̱ba mbi ilgon sowu. Yek laki ɗe ma̱ zak tlindi tula̱n ga̱n ka̱lu gwe ma ɓaka̱n yandi inabi ka̱li gwe? Wotl ka!> ");
INSERT INTO gyz_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yek ma̱lgwe zhimi nit ang wu wule, <Bagaa, ɓo zaki ta̱ po pa̱l gin ɗe na̱m ɗa̱ paa. Ba hwokit atl ɗa̱ zhila ka a wutit taki. ");
INSERT INTO gyz_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kume guli wu aka̱ zaki, kume guli sowu aka̱ laki a wotl ka.> >> ");
INSERT INTO gyz_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gas gon Yesu na̱ma hwit ga̱ɓa mbala̱n ka̱lu motgaa ga̱ gwasa̱n gas shukti gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","A kili gon ɗe ma̱zhe laki yek cwo tlet tli ka̱wu ni ka̱li, ta̱ ɓal ka̱ gin ɗe kutl cet wusupsi ata̱ ni kontami. A ba̱ta man takti gwas so ko njet. ");
INSERT INTO gyz_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu yenti wugo yek ta̱ mbet tet malti yek ta̱ wulti ɗe, <<Kili mbala̱n, ka̱ mbi ndokti ɗa̱ka̱ cwo gwa ka̱wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yek Yesu zi kilisi ang ten gaa, yek ninge tli gwas taki yek ta̱ ngusi ta̱sti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yek mbadl lili bali ga̱ lu motgaami ɗe Yesu ndok ma̱lgon gas shukti gwasa̱n wu. Yek ta̱ wul mbala̱n ɗe, <<Cin ɗe mukka ka̱n sa̱ ba̱la̱nnii ka̱n mba̱t ga̱ Musa ɗe ta̱n pa̱la̱n wul jina̱n, tula̱n ka̱ multi jwisi ta̱s ndokkii ama ba̱ ɗe gas shukti ga̱na̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yek Yesu ballit ɗe, <<Kii ma̱n pa̱lti riya, ka̱a̱ kul pa̱tl tla suk zhaki jwaka̱n aka̱ ta̱lasi ka̱lu gwe sa tla ze wu gas shukti sa? ");
INSERT INTO gyz_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kili ga̱n ɗe ga̱s ga̱ Ibirahim gwe Sheɗan lakit cwo hal ta̱ ɓal ka̱ gin ɗe kutl cet wusupsi go mbun ɗe ta ndokti gas shukti sa?>> ");
INSERT INTO gyz_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ta̱ dla̱m nu wugo yek nsha ci mas ma̱n nget gwasi, yek naa mbala̱mi ngusi hwol tuki ɗe sa̱ yen wul cit ɓanti gwe Yesu na̱ma pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yek Yesu wule, <<Nii ka̱n kanti ga̱ Nya ɗe guu ka̱ mbadl ga̱ mbala̱n ni gwi, na̱ yek ba cinga̱li ye? ");
INSERT INTO gyz_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kanti ga̱ Nya ɗe guu ka̱ mbadl wo, na̱k gwe mbukla ka̱n ni, gwe ma̱lgon ɓak ka̱ zhin gwasi yek nali yek da̱n ɗe bal tlindi, yek yatl pa̱l bii jwasa̱n ten mil ami.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yek Yesu po kum ga̱zi ɗa̱ɗe, <<Na̱ yek ba cinga̱l Nya ɗe guu ka̱ mbadl ga̱ mbala̱n ye? ");
INSERT INTO gyz_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kanti ga̱ Nya ɗe guu ka̱ mbadl wo, na̱k yiis ka̱n ni gwe a modli la̱ski njet ka̱ apti a to wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yek Yesu ɓa li a Wurshelima go yek ta̱ koɓi ɗa̱nka̱ kiɗi suk nak mil ba̱n ka ata̱ nisi ma hwit ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yek ma̱lgon ngemti ɗe, <<Bagaa, ma̱jwe Nya a kissi go njet ka?>> Yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Dloka̱ma̱nkii ta̱k koɓi tuka̱ ngaɓi dlabii na̱k ɗe mbala̱n wonti a ngwe ta̱s koɓi tuka̱li ama ba̱sa mani sowu. ");
INSERT INTO gyz_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kume baboomi tlinya yek ta̱ le dlabiimi ka̱wu, kaa dla̱l a deɓa̱l aka̱ ngusi ɓot dlabiimi aka̱ na̱ma ngemti gwas ɗe, <Bagaa, ɓulinii dlabiimi.> <<A paa ta̱ balli kii ɗe, <A yis kii so, aba̱ a yis lu gwe ka̱a̱ yil tet wu so.> ");
INSERT INTO gyz_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","<<A paa ka̱a̱ wulti ɗe, <Mi ɗe ma̱ nguk wul yek ma̱ tla sukki wu aka̱ dla̱m ga̱ɓa ɗa̱n ten tantu ba̱n ga̱na̱n ka.> ");
INSERT INTO gyz_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","<<A ta̱ po balli kii ɗe, <A yiskii so, a baa yis lu gwe ka̱ yil tet wu so. Tli ɗa̱ mala̱n ka kii ma̱n pa̱lti byas wul.> ");
INSERT INTO gyz_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","<<Kume ka̱a̱ yen ka̱ Ibirahim suk Ishaku suk Yakubu suk mas ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ dlo ga̱ ma̱jwe kan Nya ɗe guu ka̱ mbadl gwasa̱n wu, a kii wo yek sa̱ mbolkii go, ka̱li ka̱n ka kuli aka̱ as ang bi. ");
INSERT INTO gyz_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mbala̱n a yil tet tucina suk tet tukaali suk tet ten ang shinti suk ang yali ga̱ mas dii atli, asa̱ da̱n ka̱lu motgaa hwol tuki suk ma̱jwe kan Nya ɗe guu ka̱ mbadl gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Na̱ nu ka̱n ma̱jwe nde ba̱le wu a pal tukaali, ma̱jwe nde ka̱ kaali wu a pal cina.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yesu ni nugo yek ma̱n Paresi jon li tet malti, yek sa̱ wulti ɗe, <<Zigaa ɗa̱ ka̱lu ga̱n ka, na̱k ɗe Hiridus guu na̱ma ngot gwa ta̱s tloki wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yek Yesu wulsi ɗe, <<Lak wula̱n ma̱n byas mbadl wu ɗe, <Ase suk ayo wo ba yilli ma̱zhe ɗa̱ka̱ mbala̱n ka, a ba ndok mbala̱n pak. Tli wu ka̱n ba paki.> ");
INSERT INTO gyz_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mas na̱ nu ngetli ka̱n ni ɗe ta ci cina na̱ la̱t ka̱lu gwe ba li wu, ase suk ayo suk tli wu, na̱k ɗe sa man tlot ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱lu gon so se a Wurshelima wu. ");
INSERT INTO gyz_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","<<Kii ma̱n Wurshelima ɗe ka̱a̱ tlo ma̱n dla̱mti ga̱ɓa ga̱ Nya yek ka̱ lak ma̱jwe sa̱ shinsi malkii na̱ ye wu, asa̱mi ɗe na̱mi ka̱n a lam mot gwaka̱n na̱k gwe a ana kol moo mil jwas ka̱ bibaku gwas wu, ama yek ka̱a̱ nge. ");
INSERT INTO gyz_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yekgu sa̱ zakikii lubii gwaka̱n wi koni. A ni kii ma hwiti ɗe, kaa po yena̱n so se gas gwe ka̱a̱ wule, <Ma̱n mbit hwa wul ga̱ Nya ka̱ɗe ma̱lgwe na̱ma tulti ka̱ shin ga̱ Bagaa Nya wu.> >> ");
INSERT INTO gyz_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gas shukti ga̱ Ma̱n Yehuda, yek Yesu te ka̱ lubii ga̱ bali ga̱ ma̱n Paresi gon ta̱s nguk wul yek mbala̱n wutit gwel ta̱s yen ilgwe ta pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Yek ma̱lgon ka̱wu na̱ ang na̱ asa̱n gwasi mas kiɗi ka, ta̱ li tet mal Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yek Yesu ngem ma̱n yisti mba̱t ga̱ Musa suk ma̱n Paresi ɗe, <<Mba̱t ga̱na̱n ba̱li ɗe ta̱ ndok mbala̱n gas shukti a?>> ");
INSERT INTO gyz_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yek ba̱sa̱ wule ilgon so. Yek Yesu ta̱n ma̱n cwoɓi yek ta̱ ndokti yek ta̱ wulti ɗe, <<Zigaa ilgon gwa.>> ");
INSERT INTO gyz_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yek Yesu ngem mbala̱mi ɗe, <<Kume yen sogo tla gwaka̱n nda ka̱ shu gas shukti go, ka yilla̱t ka ba̱le-ba̱le so ɗe gas shukti a?>> ");
INSERT INTO gyz_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yek ba̱sa̱ mbi ilga̱ dla̱mi so. ");
INSERT INTO gyz_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na̱k Yesu yen ma̱jon ka̱ mbala̱n jwe sa̱ mbesi ta̱s nguk wul wu na̱ma botlti hwa lu da̱nti ga̱ kiɗi mbala̱n wu, yek ta̱ cinga̱lisi ga̱ɓa gon ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Kume ma̱lgon mbek ka̱lu motgaa hapti wu, ba̱k lak da̱n ka̱lu da̱nti ga̱ kiɗi mbala̱n so, gon asa̱ mbe ma̱lgwe nal man ki wu. ");
INSERT INTO gyz_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma̱lgwe mbekii mas jwaka̱n wu tul wugo, ta wule, <Tlinya ka ta̱k ba̱l lu,> nsha a ciki na̱k ɗe ka pal ka̱lu da̱nti gwe ba̱ nal na̱k gon wu sowu. ");
INSERT INTO gyz_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ama kume sa̱ mbek ka̱lu motgaa wugo aka̱ ngo lu da̱nti ga̱ ma̱jwe ba̱sa̱ ni ten bi ilgon sowu. Kume ma̱lgwe mbek wu tul wugo ta̱ wulki ɗe, <Yela̱n gini, li te ta̱k da̱n a nde.> A laki, a ma̱jwe ni ka̱li wu yen nalti gwa. ");
INSERT INTO gyz_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Mas ma̱lgwe nalli gaa gwas go mbala̱n a palla̱t ɗe ilgon so, ama ma̱lgwe palli gaa gwas ɗe ilgon sogo, mbala̱n a nalla̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yek Yesu wul ma̱lgwe mbet ka̱lu motgaami wu ɗe, <<Kume ka̱ ɓa mbe mbala̱n ta̱s nguk wul a lubii ɗakka sogo ka̱lu motgaa hwol tuk wu, ba̱k mbe yela̱n jwa suk yilkeni jwa suk ma̱jwa suk yela̱n da̱nti jwa ma̱n wul ang so, na̱k ɗe gas gon wo sa mbek ka̱lu motgaa gwasa̱n pak asa̱ pa̱lik ilgwe ka̱ pa̱lisi wu. ");
INSERT INTO gyz_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ama kume ka̱ ɓa mbe ma̱jon ka̱lu motgaa hwol tuki go, aka̱ mbe ma̱jwe ba̱ ilgon nisi ɗa sowu suk ma̱jwe man la̱t na̱ asa̱n sowu, suk ma̱jwe tli gwasa̱n tla ka̱wu suk dwa. ");
INSERT INTO gyz_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Na̱ nu ka̱n ka mbi hwa wul ga̱ Nya, na̱k ɗe si wo sa man ɓatlti gwa sowu. Nya ka ɓatlki gas gwe ma̱n pa̱lti zok wul a tlinya tot ka̱ gaa zukɗi gwasa̱n kaami wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yek ma̱lgon ɗe ta̱ ni suksi wu kumi nu wugo yek ta̱ wule, <<Ma̱n mbit hwa wul ga̱ Nya ka̱ɗe ma̱lgwe a nguk wul ka̱ motgaa hwol tuki suk ma̱jwe kan Almasihu ɗe guu ka̱ mbadl gwasa̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yek Yesu wulti ɗe, <<Ma̱lgon ni ɗa, ta̱ mbe mbala̱n wonti ka̱lu bal motgaa ngukti wul gwe ta pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Yek motgaami ɓalɗa̱ go yek ta̱ shin zhel gwasi ta̱s hwi ma̱jwe ta̱ mbesi ka̱lu motgaami wu ta̱s li te. ");
INSERT INTO gyz_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Yek mas jwasa̱n sa̱ ngusi dla̱mti iljwe a laki a ba̱sa mbi la̱t ka̱lu motgaami sowu. Yek gwe nda ga̱ɓa wu wule, <Aya wul lu zhin, a lam la̱t yenti.> Yek ta̱ wule ta̱ ma̱li tlo mbadli. ");
INSERT INTO gyz_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yek gon po wule, <Aya wul tla gut zhin ɗe kutl, ba ta̱lasi ta̱s nda gut zhin, lak wul ma̱li ɗe ta̱s tlo mbadli.> ");
INSERT INTO gyz_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yek gon po wule, <Ka̱ multi jee ka̱n aya pa̱l pyal kili. Ba mbi la̱t so.> ");
INSERT INTO gyz_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Yek zheli lak hwi baboomi mas ilgwe sa̱ hwit wu. Yek mbadl ga̱ baboomi lil i'e yek ta̱ wul zheli ɗe, <Li ka̱ ba̱mi aka̱ ma̱tl ɗa̱nka aka̱ mbe ma̱jwe ba̱ ilgon nisi ɗa̱ sowu suk ma̱jwe man la̱t na̱ asa̱n sowu suk ma̱jwe tli gwasa̱n tla ka̱wu suk dwa.> ");
INSERT INTO gyz_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Yek ta̱ pal wugo, yek ta̱ wul baboomi ɗe, <Baboo, a pa̱l ilgwe ka̱ dla̱m wu yi, ama hal ninge naa lu yi.> ");
INSERT INTO gyz_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yek baboomi wulti ɗe, <Kop tantu ta̱k li ka̱ nak mil ba̱n ta̱k mbe mbala̱n teɗi ta̱ lwisi njika̱n.> ");
INSERT INTO gyz_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A ni kii ma hwiti ɗe ma̱jwe sa̱ mbesi cina ka̱lu motgaami jo, gon a tul ɗe ta̱s la̱m ilga̱ nguki ga̱ motgaa hwol tuk gwe a pa̱li wu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mbala̱n wonti na̱ma kopti ga̱ Yesu yek ta̱ balla̱t malsi yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Mas ma̱lgwe lam kopti gini a ba̱ta̱ nge aba gwasi suk ana gwasi suk kili gwasi suk mil jwasi suk yilkeni modli suk maani, yek ta̱ nge gaa gwas pak sogo, ta man da̱nti ɗe ma̱n kopti gi so. ");
INSERT INTO gyz_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mas ma̱lgwe kan bomti gwe ni ka̱ kopti gi sogo, ta̱ ɓo mbuk da̱nti ɗe ma̱n kopti gi so. ");
INSERT INTO gyz_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","<<Kume ka̱ lam kinti lubii ma̱n wulpi go, se ka̱ da̱mi yek ka̱ yen kangwe ka pa̱li wu suk wulpi gwe a kinik lubiimi wu, ko ilgwe nik ɗa̱ wu a kumik kinti lubiimi. ");
INSERT INTO gyz_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Kume ka̱ lak zhila biimi yek ba̱ka̱ man pakti kinti sogo, mbala̱n a gitliki. ");
INSERT INTO gyz_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Sa wule, <Ma̱lga̱n go ka̱dla̱n ka̱n, ta̱ nda kinti bii yek ba̱ta̱ man pakti so.> ");
INSERT INTO gyz_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","<<Sogo kume guu ga̱ ba̱n gon gwe ma̱n hapti dlo jwas wo zangu ɗe kutl wu a la dlanti suk guu ga̱ ba̱mi gon gwe ma̱n hapti dlo jwas wo zangu ɗe kutl ɗe lop wu. A ba̱ta da̱n ɗe ta̱s yeni ko ta mana̱n dlanti suk guu gwisi so so? ");
INSERT INTO gyz_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kume ta mani sogo, ata̱ shin mil shinti mal guumi, ata̱ yi dlenti, ta̱s ngo ta̱mti da̱nti ka̱ dlo gwas sukti. ");
INSERT INTO gyz_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nu ka̱n kume ka̱ zak mas wul jwaka̱n sogo, ka man da̱nti ɗe ma̱n kopti gi so. ");
INSERT INTO gyz_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","<<Kwi wo hwa wul ka̱n, ama lilka̱ wugo, na̱ yek a la̱kmi ye? ");
INSERT INTO gyz_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mbala̱n a po pa̱l ilgon na̱ nali so na̱k ɗe ba̱sa wuti wo ka̱ zhin sowu. Wutti ka̱n sa wut ka. Ma̱lgwe ka̱n kumti niɗɗa̱ wu, ha̱n ta̱s kumi.>> ");
INSERT INTO gyz_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Gas gon, ma̱n kanti wulpi boo suk ma̱jwe ba̱sa pa̱l hwa wul sowu tul mal Yesu wonti ta̱s kum ga̱ɓa gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yek ma̱n Paresi suk ma̱n yisti mba̱t ga̱ Musa nda nala̱nti ɗe Yesu kan ma̱nda̱ki ga̱ ma̱jwe ba̱sa pa̱l hwa wul sowu ata̱ na̱ma ngukti wul suksi. ");
INSERT INTO gyz_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yek Yesu hwisi ga̱ɓa gon ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Wok ka̱ kii gwe ɗe mba̱la ɗe kutl ɗe kutl a nit ɗa a ɗe na̱m gil ka, a ba̱ta zak kutl ɗe topsi na̱ topsi ka̱lu ɗe na̱m ka̱ me ata̱ la ngot ga̱ ɗe na̱m wu se ta̱ mbit so wo? ");
INSERT INTO gyz_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ta̱ mbit wugo ata̱ pa̱l hwol tuki ata̱ kanti a yal. ");
INSERT INTO gyz_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A ta̱ ta̱lat lubii apaa ta̱ mbe yela̱n jwasi suk yela̱n da̱nti ta̱s pa̱l hwol tuk sukti na̱k ɗe ta̱ mbi mba̱la gwas gwe gil ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A ni kii ma hwiti ɗe, nu ka̱n Nya suk mil shinti jwas a pa̱l hwol tuki nal na̱ ma̱n byas wul ɗe na̱m gwe ci atl gaa mal Nya wu man ma̱n pa̱lti zok wul ɗe kutl ɗe topsi na̱ topsi jwe a po ci atl gaa sowu. ");
INSERT INTO gyz_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Sogo ta̱ wulpi ni kili mbala̱n gon ɗa azurfa ɗe kutl, yek ɗe na̱m gil ka. Ta ɓa̱s wutu ata̱ taas gibboomi ka ata̱ ngwe mas lu gwe ni wu se ta mbi. ");
INSERT INTO gyz_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kume ta̱ mbi wugo, ta̱ mbe yela̱n jwasi suk yela̱n da̱nti ta̱s pa̱l hwol tuk sukti na̱k ɗe ta mbi wulpi gwas gwe gil ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","A ni kii ma hwiti ɗe, nu ka̱n ani ɗe wul hwol tuk mal Nya suk mil shinti jwasi ɗe ma̱n byas wul ɗe na̱m ci atl gaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yek Yesu wule, <<Ma̱lgon ni ɗa̱ ma̱n mil maani ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Yek ma̱ngaɓi wu wul aba gwasa̱n ɗe, <A lami ɗe ta̱k ba̱la̱n gi ka̱ ilgwe ka zaki ni kaal ɗa̱ ma̱shka̱n gwa wu ninge, ba ɓa̱ti ta̱k ma̱sh paa so.> Yek abe huulisi wul jwasi. ");
INSERT INTO gyz_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","<<La̱m multi wugo yek yeni yem wul jwasi mas yek ta̱ zigaa ka̱ atl gon dlenti, yek ta̱ lil mas wul jwas ka ten byas da̱nti. ");
INSERT INTO gyz_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yek wul jwas paki ka̱wu, yek bal kuza̱n gon te ka̱ ba̱mi, yek yeni te ka̱ bomti na̱k ɗe ilgon poyit sowu. ");
INSERT INTO gyz_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Yek ta̱ ngo ilga̱ pa̱li mal ma̱lgon ka̱ ba̱mi yek ma̱li ba̱lti kyo alade gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yek ba̱sa̱ ba̱lti ilga̱ nguki so, yek ta̱ lami ɗe ta̱s nguk ilga̱ nguki ga̱ aladesi. Yek ba̱ta̱ mbi so. ");
INSERT INTO gyz_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","<<Yek ta̱ lak pal ka̱ hwa daamti gwas wugo yek ta̱ wul ka̱ mbadl gwas ɗe, <Zhel ji aba gi na̱ma ngukti asa̱ na̱ma tlati, a ilga̱ nguki nisi ɗa nal, ama ami wo amikgu ten tlat kuza̱n wule ba ma̱shinni. ");
INSERT INTO gyz_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ba pal to mal aba gi ka aa wulti ɗe: Aba, a pa̱li Nya byas wul yek a pa̱lik pak. ");
INSERT INTO gyz_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A po mbuk da̱nti ɗe yen gwa so, kama̱n na̱k zhel gwa.> ");
INSERT INTO gyz_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","<<Yek ta̱ nda tantu ka̱li taɓa to mal aba gwasi. <<Ama yek abe yisti tet dlenti yek gonti gwas citi yek ta̱ tlinya na̱ apti yek ta̱ ngipti te dlo ka yek ta̱ ngusi swatti gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","<<Yek yeni wulti ɗe, <Aba, a pa̱li byas wul Nya yek a pa̱lik pak, a po mbuki ta̱k mbe ɗe yen gwa so.> ");
INSERT INTO gyz_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","<<Yek abe wul zhel gwas ɗe, <La̱n na̱ apti ta̱k kama̱n luka̱l gwe mbun mani wu teɗi suk zobbe suk kapta̱lan. ");
INSERT INTO gyz_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Aka̱ dop tla gwe bas mani wu teɗi aka̱ mboshi ama̱ palla̱n hwol tuki. ");
INSERT INTO gyz_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Na̱k ɗe yen gi go ta̱ ma̱shi yek ningo ta pal wi, ta̱ gilka yek ningo a mbit wi.> Yek sa̱ pa̱l hwol tuk i'e. ");
INSERT INTO gyz_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","<<A ba̱ ma̱nkolisi ni lubii so ata̱ ni ka̱ zhin, yek ta̱ pal wugo yek ta̱ ngusi kumti ɓot gan-gan suk wulti koo suk dlalti a lubii ɗaasika. ");
INSERT INTO gyz_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yek ta̱ mbe zhel gon gwasa̱n ta̱s kum ga̱s ilgwe na̱ma pa̱t wu? ");
INSERT INTO gyz_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Yek zheli wulti ɗe, <Ma̱ngaɓi gwa ka̱ pal wi, yek aba gwaka̱n laki yek sa̱ mbosh tla gwe bas mani wu ta̱ mbala̱n pa̱l hwol tuk sukti na̱k ɗe yilka gwa pal boo ka̱ ta̱mti wu.> ");
INSERT INTO gyz_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","<<Yek mbadl lili ma̱nkolisi i'e yek ta̱ nge tet gibboo, yek abe yil tot gibboomi yek ta̱ ba̱lti bi ta̱s te gibboo. ");
INSERT INTO gyz_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yek ta̱ wule abe ɗe, <Yek na̱k gwe? Mas da̱nti gwe a da̱n sukki wu, a nikma pa̱lti wul na̱k zhel, a mas ilgwe ka̱ lami go a pa̱liki, ama ko ga̱ cin ɗe na̱m ka̱ pa̱li ilgon nu so, a ba̱ka̱ ba̱la̱n ko ta̱ yen mal ɗe ta mboshi a mo mbala̱n ji so. ");
INSERT INTO gyz_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ama yek yen gwa pal wi kaal ɗa̱ tlot wulpi gwa ka ten muka̱l modli, yek ka̱ mbe mbala̱n yek ka̱ mboshit tla gwe bas mani wu.> ");
INSERT INTO gyz_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","<<Yek abe wulti ɗe, <Yen gini, ka̱ ni suk ami ko gasi, mas wul ji wo jwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mbun ɗe ta̱n pa̱l hwol tuki na̱k ɗe yilka gwa ma̱shi yek ta̱ tli ɗa̱ka̱ ma̱shka̱n ka wu, ta̱ gili yek ningo ta̱ pal boo wu.> >> ");
INSERT INTO gyz_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yek Yesu wul ma̱n kopti jwas ɗe, <<Ma̱n wul gon ni ɗa gwe kan ma̱lgwe a pa̱lit wulbo gwas wu, ama yek ta̱ lak kumi ɗe ma̱li nitma lilti wul ka. ");
INSERT INTO gyz_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Yek baboomi mbet su gibboo ka, yek ta̱ wulti ɗe, <A kumi ɗe ka̱ nima lilti wul ka. Lak hwi kangwe ka̱ na̱ma pa̱lti wulbo gi wu ga̱ la̱shi, ka po da̱n ɗe ma̱n pa̱lti wul ga̱ boo gi so.> ");
INSERT INTO gyz_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","<<Yek ma̱li wul ka̱ mbadl gwas ɗe, <Baboo gi mbola̱n wugo, ba pa̱n nii? Na̱k ɗe ba̱ nda̱lti kolti zhin ka̱ niɗɗa̱ sowu, a nsha ngemti wul ka cin wu.> ");
INSERT INTO gyz_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yek ta̱ po wule, <A yis ilgwe ba pa̱li ɗe ta̱ naa mbala̱n pa̱l ɗem na̱ ami a lubii ɗaasika wu wi.> ");
INSERT INTO gyz_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","<<Yek ta̱ mbe mas ma̱jwe baboo gwas na̱ma kopti gwasa̱n duul wu, yek ta̱ ngem ma̱lgwe la̱t tet cina wu ɗe, <Na̱mi kan baboo gi na̱ma kopti gwa?> ");
INSERT INTO gyz_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","<<Yek ta̱ wulti ɗe, <Ta̱ na̱ma kopti gi bunta̱n mili zamba̱l ɗe wusupsi.> Yek ma̱li wulti ɗe, <Da̱m atli ta̱k lish zamba̱l ɗe wupsi.> ");
INSERT INTO gyz_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","<<Yek ta̱ po ngem gon ɗa̱ɗe, <A kii hwa, na̱mi kan ta̱ na̱ma kopti gwa?> <<Yek ta̱ wulti ɗe, <Bal ngura zamba̱l ɗe na̱m ga̱ alkama.> <<Yek ta̱ wulti ɗe, <Kan wul lishti ta̱k lish kutl ɗe wusupsi.> ");
INSERT INTO gyz_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","<<Yek baboomi kum ilgwe ma̱n pa̱lti wulbo gwas na̱ma pa̱lti wu wugo, yek ta̱ ta̱s byas ɓotlka̱n gwasi, na̱k ɗe mbala̱n ji ninge man pa̱t na̱ mbala̱n jwasa̱n ji se man ma̱jwe ni ka̱ cilti ga̱ Nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yek Yesu po wule, <<A ni kii ma hwiti, pa̱la̱n wul na̱ wul ang gwaka̱n ta̱k mbi yela̱n ɗa. Na̱ nu ka̱n kume wul gwaka̱n paki wugo sa pikii ɗem ka̱ boo ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","<<Ma̱lgwe pa̱l gem ten ngipti nak'en wul go, ta man pa̱lti gem ten ngipti kakshe. Ma̱lgwe pa̱l gem ten nak'en wul sogo, ta mani ten kakshe so pak. ");
INSERT INTO gyz_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","A kume ka̱ pa̱l gem ten ngipti wul ji dii atl sogo, wok ka ba̱lkii hwa wul ga̱ Nya wo? ");
INSERT INTO gyz_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","A kume ka̱ pa̱l gem ten ngipti wul ji ma̱lgon sogo, wok ka ba̱lkii gwaka̱n wo? ");
INSERT INTO gyz_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","<<Mbala̱n a man da̱nti ɗe zhel ga̱ baboo ɗe lop so, a kume ta̱ pa̱li nu go, ta nge gon ata̱ lam gon, sogo a ta pa̱li hwa wul gon ata̱ mbul gon. Ka man da̱nti ɗe zhel ga̱ Nya suk zhel ga̱ wulpi so.>> ");
INSERT INTO gyz_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Na̱k ɗe ma̱n Paresi wo ma̱n lamti wulpi ka̱n i'e wu, yek sa̱ kumi nu wugo yek sa̱ desit njwaa. ");
INSERT INTO gyz_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yek ta̱ wulsi ɗe, <<Kik ɗe ma̱n lamti ɗe ta̱ mbala̱n yenki ɗe ma̱n zok mbadli, ama Nya yis mbadl gwaka̱n. Ilgwe mbala̱n yeni ɗe hwaɓi go, yek ka̱n Nya a ngeti.>> ");
INSERT INTO gyz_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yek Yesu po wul ma̱n Paresisi ɗa̱ɗe, <<Mba̱t ga̱ Musa suk lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ ni ɗa, yek Yohana ma̱n baptisma tuli, ama na̱k sa̱ dla̱m ga̱ɓa ma̱n ta̱mti ten kangwe mbala̱n a kan Nya ɗe guu ka̱ mbadl gwasa̱n wu, yek mbala̱n na̱ma tlot gwasa̱n i'e ta̱s te giɓi. ");
INSERT INTO gyz_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tlo nya suk dii atl a man pakti ama ko njet ka̱ mba̱t ga̱ Musa wo gon a paki so. ");
INSERT INTO gyz_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","<<A ma̱lgwe huul suk kili gwasi yek ta̱ kan zopsi kili go ta̱ na̱ma pa̱t pa̱la̱n, a ma̱lgwe kan kili gwe huul suk kos gwas go, sa̱ na̱ma pa̱t pa̱la̱n pak.>> ");
INSERT INTO gyz_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yek Yesu wule, <<Ma̱lgon ni ɗa̱ ma̱n wul, ata̱ lak luka̱l ma̱n wulpi ata̱ nguk hwa ilga̱ nguki ko gasi. ");
INSERT INTO gyz_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","A ma̱lgon ni ten bi dlaboo gwasi asa̱ mbet ɗe Liazaru ma̱lgwe tli gwas wo mas usu wu a ma̱n ngemti wul ka̱ɗe ti. ");
INSERT INTO gyz_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A Liazaru ɓa̱t ilga̱ nguki gwe a lok sut ten lu ngukti ga̱ ma̱n wul wu, a kaɗi la̱pti usu gwe nit ten tli wu. ");
INSERT INTO gyz_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","<<Ni nugo yek Liazaru lak ma̱shi yek mil shinti ji Nya sak kanti yek sa̱ ba̱lti hwa lu da̱nti ka̱ boo ga̱ Nya ka̱lu gwe Ibirahim ni wu. Yek ma̱n wul wu mago yek ta̱ lak ma̱shi yek sa̱ lepti. ");
INSERT INTO gyz_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Yek mbadl gwas li ka̱lu da̱nti ga̱ ma̱n ma̱shka̱n yek ta̱ da̱n ka̱ bomti, yek ta̱ yen Liazaru suk Ibirahim tet dlenti. ");
INSERT INTO gyz_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yek ta̱ taki bi Ibirahim yek ta̱ wulti ɗe, <Aba Ibirahim, yen gonti gini, aka̱ shin Liazaru ta̱s lak yen ang gwas ka̱ ze ta̱s nak laki sut ten la̱ka ne ta kum nda̱ɗiti ka̱ bomti ka̱n ani i'e ka̱ wutu.> ");
INSERT INTO gyz_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","<<Yek Ibirahim wulti ɗe, <Yen mbala̱n, daamki ɗe ka̱ yi ten dii atl go, hwa wul nik ɗa̱ a Liazaru ni ka̱ bomti, ama ningo ta̱ ɓal ka̱ ta̱mti a mala̱nni a ki wo ka̱ ni ka̱lu bomti. ");
INSERT INTO gyz_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","A ban na̱ nu mago, bal buu ni ka̱ tlo ga̱na̱n sukki kangwe mas ma̱lgwe ni tumalki wu a man la̱t tet ka̱lu gwe ma̱ ni wu so, aba̱ ma̱lgwe ni tumalni wu a man ɗakciti tumalki so.> ");
INSERT INTO gyz_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","<<Yek ma̱n wuli wulti ɗe, <Aba Ibirahim, a na̱ma ngemti gwa, ta̱k shin Liazaru ta̱s su lubii ɗa̱ aba gi ka. ");
INSERT INTO gyz_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yilkeni ni ɗa ɗe namtan ta̱s suk hwisi ba̱s kop tantu gwe a koɓi wu asa̱ li tet ka̱lu bomti ga̱n so.> ");
INSERT INTO gyz_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","<<Yek Ibirahim wule, <Mba̱t ga̱ Musa suk lishti ga̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya nisi ɗa̱ ta̱s katisi ka̱n.> ");
INSERT INTO gyz_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","<<Yek ma̱n wuli wulti ɗe, <Nuk so Aba Ibirahim, kume ma̱lgon yil tot ka̱ hwu mbala̱n yek ta̱ li malsi go sa kumi asa̱ cit atl gaa.> ");
INSERT INTO gyz_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","<<Ama yek Ibirahim wulti ɗe, <Kume sa̱ kum ilgwe mba̱t ga̱ Musa suk lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya nisi ma dla̱mti wu sogo, ko ta̱ ma̱lgon tlinya tot ka̱ gaa zukɗi kaami sa kumti so.> >> ");
INSERT INTO gyz_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yek Yesu wul ma̱n kopti jwas ɗe, <<Wul jwe a lak mbala̱n ten pa̱lti byas wul go a tuli, ama ma̱lgwe wul jwisi a tul tumalti go ta da̱m ɗe wul cit gonti. ");
INSERT INTO gyz_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɗa̱ gwe ta̱ ma̱lgon lak ɗe na̱m ka̱ nak mil jee ta̱s pa̱l byas wul go, a maniti ta̱s ɓalit ye na̱kti hwoo a yal asa̱ lakti ka̱ bal ze. ");
INSERT INTO gyz_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Pa̱n ɗem'ɗem na̱ gaa gwaka̱n. <<Kume yilka gwa pa̱lik byas wul wu, aka̱ matlti, a kume ta̱ ci atl gaa wu, aka̱ taasi ɗa̱ ten mbadl ka. ");
INSERT INTO gyz_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Kume ta̱ pa̱lik byas wul asa̱mi ɗe nitgi ten cin ɗe na̱m ata̱ na̱ma palti tet malki asa̱mi ɗe nitgi ata̱ na̱ma cit atl gaa wu, aka̱ taasi ɗa̱ ten mbadl ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yek mil shinti ji botlisi wul Bagaa ɗe, <<Mba̱lini za̱t mbadl ten Nya dani.>> ");
INSERT INTO gyz_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yek ta̱ wulsi ɗe, <<Kume za̱t mbadl ten Nya ni kii ɗa njet na̱k gwe daazi wu, ka man wulti ga̱ tlindi ga̱n ɗe, <Ndus ɗa̱ka̱ lu gee ka ta̱k sak dla̱l ka̱ bal ze,> a ilgwe ka̱a̱ dla̱m wu pi. ");
INSERT INTO gyz_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","<<Kume zhel ni gon gwaka̱n ɗa a zheli nitma kolti zhin sogo kyo mba̱la, a na̱ palti ga̱ zheli tet ka̱ zhin, a ma̱li wulti ɗe, <Li te ta̱k da̱m na̱ zhila ta̱k nguk wul la?> ");
INSERT INTO gyz_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ba̱ta wulti ɗe, <Lak pa̱li ilga̱ nguki aka̱ ɓa̱tti ta nguki aa tla ze apaa ka̱ po nguki aka̱ tla pak> sa? ");
INSERT INTO gyz_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ta pa̱l hwol tuk na̱ zheli na̱k ɗe ta̱ kop ga̱ɓa gwas wu?>> ");
INSERT INTO gyz_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yek Yesu po wulsi ɗa̱ɗe, <<Kii mago nu ka̱n, kume ka̱ pa̱l mas ilgwe sa̱ hwikii ɗe ta̱k pa̱li wu, ka wule, <Mi wo zhel ka̱n jwe ba̱ma̱ ni ten bi ilgon sowu, mi wo ilgwe mbun ɗe ta̱n pa̱li wu ka̱n ma̱ na̱ma pa̱lti.> >> ");
INSERT INTO gyz_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","A Yesu ni ten tantu la̱t Wurshelima, yek ta̱ yil ka̱ tlo ga̱ Samariya suk Galili. ");
INSERT INTO gyz_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yek ta̱ ɓa te ka̱ nak'en ba̱n gon nu go yek ma̱n cwo gita jon ka̱ju si ɗe kutl, yek sa̱ dla̱l te dlenti ka. ");
INSERT INTO gyz_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Yek sa̱ tak bi na̱ nda̱lti ɗe, <<Yesu, ma̱n lishti, yen gonti ga̱na̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yek ta̱ yensi wugo, yek ta̱ wulsi ɗe, <<La̱n mal ma̱n Pa̱ris ta̱s yisi ɗe ka̱a̱ ndoki wi.>> Sa̱ ɓal ten tantu la̱t go, yek sa̱ ndoki. ");
INSERT INTO gyz_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yek ɗe na̱m ka̱si yeni ɗe ta̱ ndoki wugo, yek ta̱ pal tet mal Yesu, ata̱ na̱ma ta̱sti ga̱ Nya na̱ nda̱li yal. ");
INSERT INTO gyz_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yek ta̱ lak ngus a cina ɗa̱ Yesu ka, yek ta̱ ngusa̱l gaa gwas atli, yek ta̱ pa̱l hwol tuk na̱ Yesu. A ti wo ma̱n Samariya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yek Yesu wule, <<A wule mbala̱n ɗe kutl ka̱ mbi ndokti nwa? Na̱ topsi jon ju ɓal ko? ");
INSERT INTO gyz_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Yek ba̱ ma̱lgon pal tet ɗe ta̱s ba̱l nalti Nya so se ma̱nda̱ki ga̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yek Yesu wul ma̱li ɗe, <<Tlinya ta̱k zigaa, za̱t mbadl ten Nya gwa ndokki wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Gas gon, yek ma̱n Paresi ngem Yesu ɗe, <<A gasi ka̱n ma yen tulti ga̱ Almasihu ɗe guu gwi?>> Yek Yesu wulsi ɗe, <<Gas gwe Almasihu a da̱n ɗe guu ka̱ mbadl ga̱ mbala̱n go mbala̱n a man yenti na̱ gwel so, ");
INSERT INTO gyz_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aba̱ mbala̱n a wule <Yek ɓal ga̱n> sogo <Yek tekgu> so, na̱k ɗe ka̱ tlo gwaka̱n ka̱n ni wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yek Yesu po wul ma̱n kopti jwas ɗa̱ɗe, <<Gas gwe ka lam yenti palti sut gini Yen ga̱ Mbala̱n wu ni teɗi ama ba̱ka yeni so. ");
INSERT INTO gyz_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mbala̱n a shelkii ɗe, <Tik tekgu,> sogo <Tik gee,> ama ba̱k koɓa̱n ga̱ɓa gwasa̱n so. ");
INSERT INTO gyz_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Gas palti sut gini Yen ga̱ Mbala̱n wo mbala̱n mas a yena̱nni na̱k gwe a nyaze ci bi a cilti yil tet ten ka̱t dii atl gon a li ten ka̱ti gon wu. ");
INSERT INTO gyz_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ama na̱k jwisi a ɓo pi so se ami Yen ga̱ Mbala̱n tla bomti nal paa a mbala̱n ji se a nge pak. ");
INSERT INTO gyz_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","<<Na̱k gwe pi ka̱ gin ga̱ Nuhu wu nu ka̱n a pi ten gin gwe ba pal sut ten dii atl wu. ");
INSERT INTO gyz_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Mbala̱n a na̱ma ngukti, asa̱ na̱ma tlati, sa̱ na̱ma hapti modli asa̱ na̱ma hapti mil jwasa̱n ka. Na̱ nu ka̱n yek cin gwe Nuhu te ka̱ jirgi wu tuli, yek bal ze yil sut tu nya suk tot tu atli yek tlo mbala̱n ka mas. ");
INSERT INTO gyz_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","<<Nu ka̱n pi ka̱ gin ga̱ Lutu pak mbala̱n na̱ma ngukti suk tlati, asa̱ na̱ma wulti wul suk wulti ka, sa̱ na̱ma ɓakti zhin asa̱ na̱ma kinti bii. ");
INSERT INTO gyz_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ama gas gwe Lutu zak ba̱n Sodom wu, yek wutu suk wutu na̱k ze ngusi shoti sut nya yek tlosi ka mas. ");
INSERT INTO gyz_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","<<Nu ka̱n ani ten gas gwe ami Yen ga̱ Mbala̱n a pal sut wu. ");
INSERT INTO gyz_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ten cin gwisi wo, ma̱lgwe ni to ten tlal bii gwas ka̱go ba̱s yil sut ɗe ta yem wul jwas ɗa̱ gibboo ka̱ so. Nu ka̱n mas ma̱lgwe li ka̱ zhin wu ba̱s pal lubii so. ");
INSERT INTO gyz_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɓo daama̱nkii ten kili ga̱ Lutu. ");
INSERT INTO gyz_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mas ma̱lgwe nge ten mbadl gwas go ta mbi so ama ma̱lgwe ba̱l mbadl gwas go za̱ti ka̱n ta̱ zit ka. ");
INSERT INTO gyz_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A ni kii ma hwiti ɗe, ten gas gwe na̱k gwisi a pi wu, mbala̱n ɗe lop ani ten lumulti ɗe na̱m, Nya a kan gon ata̱ zak gon. ");
INSERT INTO gyz_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Modli ɗe lop a na̱ma na̱kti hwoo, Nya a kan gon ata̱ zak gon. ");
INSERT INTO gyz_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mbala̱n ɗe lop ani ka̱ zhin, Nya a kan gon ata̱ zak gon ka̱li.>> ");
INSERT INTO gyz_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yek ma̱n koptisi ngem Yesu ɗe, <<A'ako ka̱n na̱k gwisi a pi ko?>> Yek ta̱ wulsi ɗe, <<Ka̱ lu gwe hwu wul ni go, ka̱li ka̱n a zhipki mogaa.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yek Yesu hwi cinga̱lti ga̱ɓa ma̱n kopti jwasi, kangwe sa ngusi tlot gwasa̱n ten ngemti Nya a ba̱s nak sowu. ");
INSERT INTO gyz_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yek ta̱ wulsi ɗe, <<Ma̱n kisti ga̱ɓa gon ni ɗa̱ ka̱ ba̱n gon, ma̱lgwe ba̱ta̱ ɓanti Nya so a ba̱ta̱ yen gonti ga̱ ma̱lgon sowu. ");
INSERT INTO gyz_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","A guli kili gon ni ka̱ ba̱mi pak, yek ta̱ ngusi la̱t mal ma̱n kisti ga̱ɓe ta̱s pa̱lit hwa kisti ga̱ɓa ka̱ dlo gwas suk ma̱n nget gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","<<Yek ma̱n kisti ga̱ɓe nda ngeti, ama yek ta̱ lak wul ka̱ mbadl gwas ɗe, <Ko ɗe a ɓanti Nya so aba̱ ma̱lgon hwota̱n sowu, ");
INSERT INTO gyz_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ama na̱k ɗe guli kili ga̱n twe gaa na̱ ngemti wu, ba pa̱lit ilgwe ta̱ lami wu ta̱s zaka̱nni ta shuki.> >> ");
INSERT INTO gyz_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Yek Yesu Bagaa wulsi ɗe, <<Ɓo kuma̱n ilgwe ma̱n kisti ga̱ɓa gwe ba̱ta pa̱l gem ka kisti ga̱ɓa gwas sowu dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A ba̱ Nya a pa̱li ma̱jwe ta̱ botlsi wu hwa wul jwe sa̱ na̱ma ngemti gwas wu na̱k ɗe sa̱ na̱ma ngemti gwasi na̱ ka̱ cin na̱ ka̱ gas wu sa? Ka̱ yeni go ta ba̱lsi ilgwe sa̱ lami wu ba̱le sa? ");
INSERT INTO gyz_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A ni kii ma hwiti ɗe ta ba̱lsi ilgwe sa̱ na̱ma ngemti gwas wu ba̱le-ba̱le. Ama kume ami Yen ga̱ Mbala̱n pal sut ten dii atl wugo, ba ya mbi ma̱n za̱t mbadl tena̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yek Yesu po hwi cinga̱lti ga̱ɓa ma̱jwe palli gaa gwasa̱n ɗe ma̱n pa̱lti zok wul yek sa̱ mbul mas naa mbala̱n wu, ");
INSERT INTO gyz_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","yek ta̱ wulsi ɗe, <<Ma̱jon ɗe lop te ka̱lu lubii ga̱ Nya ta̱s ngemti Nya. Gon wo ba Paresi a gon wo ma̱n kanti wulpi boo. ");
INSERT INTO gyz_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yek ba Paresi wu tlinya ta̱s ngemi Nya gaa gwasi yek ta̱ wule, <Nya a pa̱l hwol tuki na̱k ɗe ami wo ba̱ na̱k ma̱jwe asa̱ te mbala̱n ga̱zi, asa̱ pa̱l byas wul, asa̱ kop modli wu ka̱n ani so. A ba̱ na̱k ma̱n kanti wulpi boo ga̱ tekgu ka̱n ani so. ");
INSERT INTO gyz_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Aa kul pa̱l ka̱lka̱ze asa̱mi ɗe lop ka̱ multi ɗe nitgi, aa ba̱l ɗe na̱m ka̱ kutl ga̱ mas ilgwe ni ɗa̱ wu.> ");
INSERT INTO gyz_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","<<Yek ma̱n kanti wulpi boo wu dla̱l te dlenti ka, yek ta̱ kin gaa gwas giɓi, yek ta̱ zi ang gwas ten ngetli, yek ta̱ wule, <Nya, yen gonti gini, ami wo ma̱n pa̱lti byas wul ka̱n.> >> ");
INSERT INTO gyz_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yek Yesu wule, <<A ni kii ma hwiti, ma̱n kanti wulpi boo wu li ga̱s na̱ zok mbadli na̱k ɗe Nya taas byas wul jwas ka̱wu, ba̱ na̱k ga̱ ba Paresi wu so, na̱k ɗe mas ma̱lgwe nalli gaa gwas go sa nalla̱t so, ama ma̱lgwe nalli gaa gwas sogo, sa nalla̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yek ma̱jon tulli mil jwasa̱n mal Yesu ta̱s wutisi ang gaa ata̱ ngemisi Nya. Yek ma̱n kopti jwas yeni nu wugo yek sa̱ matlsi. ");
INSERT INTO gyz_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ama yek Yesu mbe mil mbala̱mi tet malti yek ta̱ wule, <<Zaka̱n mil mbala̱n ta̱s li tet mala̱nni, ba̱k mbola̱nsi so, na̱k ɗe Nya ka̱ɗe guu ga̱ mbala̱n ma̱n wunda̱l mbadl gwasa̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yek Yesu wulsi ɗe, <<A ni kii ma hwit gem ɗe mas ma̱lgwe kan Nya ɗe guu ka̱ mbadl gwas na̱k ga̱ yen mbala̱n sogo Nya a da̱n ɗe guu gwas so.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yek bali ga̱ ma̱n Yehuda gon wul Yesu ɗe, <<Hwa ma̱n lishti, yek nii ngetli ɗe ta pa̱li a mbi Nya boo ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yek Yesu wulti ɗe, <<Yek laki yek ka̱ mbe ɗe <hwaɓi> ye? Ma̱lgon ni hwaɓi so se Nya. ");
INSERT INTO gyz_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ka̱ yis ilgwe mba̱t ga̱ Musa dla̱m wu ɗe, <Ba̱k kop modli so, a ba̱k tlo ma̱lgon so, a ba̱k pi muka̱l so, a ba̱k sheli lal ma̱lgon gaa so. A ka̱ ba̱l nalti aba gwa suk ana gwa.> >> ");
INSERT INTO gyz_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Yek ma̱li wule, <<Mas jo a koɓi wi aa yi nak'eni.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yek Yesu kumi nu wugo yek ta̱ wul ma̱li ɗe, <<Wul ɗe na̱m yii gwe ba̱ka̱ ɓo pa̱li sowu, yek ɗe, lak wul wul jwa ka mas aka̱ ba̱l wulpi ma̱jwe ba̱ ilgon nisi ɗa̱ sowu ta̱k mbi wul to nya ka̱ɗa, a paa ka̱ li te aka̱ koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Yek ta̱ kumi nu wugo yek mbadl liliti na̱k ɗe ti wo ma̱n wul ka̱n i'e wu. ");
INSERT INTO gyz_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu yeni ɗe mbadl lili ma̱li wugo yek ta̱ wule, <<A bomi ta̱ ma̱n wul kan Nya ɗe guu ka̱ mbadl gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ma̱n wul a man kanti ga̱ Nya ɗe guu ka̱ mbadl gwasa̱n so na̱k kangwe a bomi rakumi gaa ta̱s te ka̱ shu alipla wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Mbala̱n kumi nu wugo yek sa̱ ngem Yesu ɗe, <<Kume nu ka̱n ni go wok Nya kisti wo?>> ");
INSERT INTO gyz_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yek Yesu wulsi ɗe, <<Ilgwe man ngetl ga̱ mbala̱n go mal Nya wo man pa̱t ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yek Biturus wulti ɗe, <<Yekgu ma̱ zak wul jina̱n wi mas yek ma̱ kopki.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yek Yesu wule, <<A yisi nu yek laki yek a ni kii ma hwit gem ɗe, mas ma̱lgwe zak lubii suk kili suk yilkeni suk ma̱n za̱t jwasi suk mil jwasi ten kanti ga̱ Nya ɗe guu ka̱ mbadl gwas go, ");
INSERT INTO gyz_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ta mbi wul nal ninge. Kaal ɗa̱ ma̱shka̱n gwas wo ata̱ mbi Nya boo.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yek Yesu mo ma̱n kopti jwas ɗe kutl cet lop ju ka̱lu ɗe na̱m yek ta̱ wulsi ɗe, <<Ma to Wurshelima, a mas iljwe ma̱n dla̱mti ga̱ɓa ga̱ Nya lishi ten ami Yen ga̱ Mbala̱n wu a da̱n ɗe gem. ");
INSERT INTO gyz_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sa ba̱l bi gi ma̱jwe ba̱ Ma̱n Yehuda ka̱ sowu, asa̱ wuli wul jon, asa̱ byala̱nni, asa̱ ba̱ze ɓaka̱n ten tli. ");
INSERT INTO gyz_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Sa ɓo na̱ tlemndi, asa̱ tloni. Ama ba nda cin ɗe mekan wugo ba tli ɗa̱ka̱ ma̱shka̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ama yek ba̱sa̱ yis ilgwe ta̱ nisi ma hwiti wu so. Sa̱ hwuda̱lisi ga̱ɓe ka yek laki ɗe ba̱sa̱ yis gaami sowu. ");
INSERT INTO gyz_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yek Yesu ɓal njaa a Jeriko go yek dwa gon ka̱wu na̱ zhila ata̱ na̱ma ngemti wul ten bi tantu. ");
INSERT INTO gyz_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ta̱ kum la̱t ga̱ wonti mbala̱n wugo yek ta̱ kum ga̱zi ɗe, <<Yek na̱ma pa̱t ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yek sa̱ wulti ɗe, <<Yesu ga̱ Nazarat ka̱ na̱ma la̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yek ta̱ tlil yal nya na̱ nda̱lti yek ta̱ wule, <<Yesu ga̱s ga̱ Dauda guu Israila, yen gonti gini.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yek ma̱jwe ni cina wu matlti ɗe ta̱s zak ga̱ɓa, ama yek ta̱ mba̱l tlilti yal nya dani yek ta̱ wule, <<Ga̱s ga̱ Dauda guu Israila, yen gonti gini.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yek Yesu dla̱li yek ta̱ hwisi ɗe ta̱s ta̱la dwami tet malti. Ta̱ ɓal njaa mal Yesu go yek Yesu ngemti ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Yek ka̱ lami ɗe ta pa̱lik ye?>> Yek ta̱ wule, <<Bagaa, lamti gi wo ta̱ gwel gi ɓuli ta yen lu.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yek Yesu wulti ɗe, <<Ta̱ gwel gwa ɓuli ta̱k yen lu. Za̱t mbadl ten Nya gwa ndokki wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yesu na̱ma dla̱mti nu yek gwel gwas ɓuli yek ta̱ yen lu yek ta̱ kop Yesu ata̱ nima ba̱lti nalti Nya. Mbala̱n yeni nu wugo yek mas jwasa̱n sa̱ ta̱s Nya. ");
INSERT INTO gyz_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yek Yesu koɓi tuka̱ ba̱n Jeriko. ");
INSERT INTO gyz_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A ma̱lgon ni ɗa asa̱ mbet Zakka, bali ga̱ ma̱n kanti wulpi boo ka̱ɗe ti. A ma̱n wul ka̱ pak. ");
INSERT INTO gyz_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ta̱ na̱ma lamti ta̱s yen Yesu, ama ba̱ta̱ mani so na̱k ɗe ti wo ndoklan mbala̱n ka̱wu, a mbala̱n wonti ka̱li. ");
INSERT INTO gyz_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Yek ta̱ ap te cina ka, yek ta̱ to ka̱ tlindi la̱ngali tu ka̱lu gwe Yesu a koɓi wu ta̱s yenti ɗa. ");
INSERT INTO gyz_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yek Yesu ɓal ga̱s la̱ngali go yek ta̱ lak gaa nya yek ta̱ wulti ɗe, <<Zakka, yil suɗi, ma̱nda̱ki gwa ka̱ɗe ami ase.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yek ta̱ yil sut na̱ apti, yek ta̱ pa̱lit ɗem na̱ hwol tuki. ");
INSERT INTO gyz_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Mas mbala̱mi yeni nu wugo, yek sa̱ njel nala̱nti ɗe, <<Ɗa̱ ma̱n pa̱lti byas wul ka̱n ta li.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sa̱ ɓal lubiimi go, yek Zakka tlinya yek ta̱ wule, <<Bagaa, ba ba̱l tatlti dlo ga̱ wul jini ma̱jwe a yemisi wulpi ka̱wu, a ma̱jwe ba̱ ilgon nisi ɗa̱ sogo ba ba̱lsi, a ma̱jwe a tesi ga̱zi go ba pallisi asa̱mi ɗe wupsi.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yek Yesu wulti ɗe, <<Ase go kisti tuli ma̱n lubii ga̱n wi, na̱k ɗe Zakka mago ga̱s ga̱ Ibirahim ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A ami Yen ga̱ Mbala̱n a tul ɗe ta ngo ma̱jwe gil ka̱wu ta kissi.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Sa̱ nima kati ka̱n Yesu nugo, yek ta̱ cinga̱lisi ga̱ɓa gon, na̱k ɗe ta̱ ɓal njaa ka̱ bal ba̱n Wurshelima wu, a mbala̱mi da̱n gwa we Almasihu a tul ɗe guu ten dii atli ninge-ninge. ");
INSERT INTO gyz_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Yek ta̱ wule, <<Bal ma̱lgon ni ɗa gwe sa̱ mbet ka̱ dlenti atl gon ta̱s ba̱lti guu a paa ta̱ pal tet ka̱ atl gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yek ta̱ mbe ɗe kutl ka̱ zhel jwasi yek ta̱ ba̱lsi wulpi na̱k kangwe zhel a mbi ka̱ lip ɗe mekan wu mas jwasa̱n, yek ta̱ wulsi ɗe, <Ngusi balla̱t wulpi se gas gwe a pal wu.> Yek ta̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","<<A ba̱ ma̱n atli lami ɗe ta̱s da̱n ɗe guu gwasa̱n so, yek sa̱ shin mil shinti kaal ɗa̱ ti ta̱s lak dla̱m ɗe sa̱ lamti ɗe guu so. ");
INSERT INTO gyz_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","<<Sa̱ ba̱lti guumi wugo yek ta̱ pal tet ka̱ atli, yek ta̱ mbe zhel jwe ta̱ ba̱lsi wulpi ɗe ta̱s ngusi balla̱ti wu, ta̱s ɓo yeni na̱mi kan ta̱ mbi mba̱lti dani. ");
INSERT INTO gyz_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","<<Yek gon li tet malti yek ta̱ wulti ɗe, <Baboo, wulpi gwe ka̱ ba̱la̱n go a mbi ɗe kutl dani wi.> ");
INSERT INTO gyz_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","<<Yek baboomi wulti ɗe, <Mbun wi, ka̱ pa̱l gem ten nak'en wul, ba za̱k ɗe guu ga̱ kiɗi ba̱n ɗe kutl.> ");
INSERT INTO gyz_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","<<Yek zheli na̱ lop wu wul baboomi ɗe, <A mbi mba̱lti ɗe namtan ten gwe ka̱ ba̱la̱n wu.> ");
INSERT INTO gyz_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","<<Yek baboomi wulti ɗe, <Ka da̱n ɗe guu ga̱ kiɗi ba̱n ɗe namtan.> ");
INSERT INTO gyz_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","<<Yek zhel na̱ mekan wul baboomi ɗe, <Baboo, kan wulpi gwa, ɓanti gwa cinni yek a kus ka̱ nak'en tutul yek a hwuda̱li ka. ");
INSERT INTO gyz_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na̱k ɗe kyo ba̱ mbala̱n a yis gaa gwa sowu, a da̱nti sukki bomi, a lamti wul ten koo lu ka̱wu, na̱k ɗe aka̱ wotl ilgwe ba̱ kik ɓak sowu.> ");
INSERT INTO gyz_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","<<Yek ta̱ wulti ɗe, <Kiyo byas zhel ka̱n, ba nolki na̱k gwe ka̱ yisa̱n wu. Kume ka̱ yisi ɗe ami wo ma̱n bomti ka̱n a ma̱n lamti wul ten koo lu suk ma̱n wotlti ilgwe ba̱ amik ɓak sowu, ");
INSERT INTO gyz_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","yek laki yek ba̱ka̱ ngusi balla̱t wulpi gini kangwe a pal wugo aa mbi ilgwe mba̱l tli dani wu so ye? Na̱k ɗe ka̱ yisi ɗe nu ka̱n ani wu?> ");
INSERT INTO gyz_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","<<Yek ta̱ wul ma̱jwe ni ka̱li wu ɗe, <Kama̱n ɗe na̱mi gwe nit ang wu ka aka̱ ba̱l ma̱n ɗe kutl wu.> ");
INSERT INTO gyz_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","<<Yek sa̱ wulti ɗe, <Baboo, ɗe kutl ka̱ nit ang ca.> ");
INSERT INTO gyz_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","<<Yek baboomi wulsi ɗe, <Ɓo kumini, mas ma̱lgwe ilgon niɗɗa̱ wu sa mba̱lit dani, a ma̱lgwe ba̱ ilgon niɗɗa̱ sowu, nak njeti gwe niɗɗa̱ wu mago sa kamit ka. ");
INSERT INTO gyz_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mbe ma̱jwe nge ɗe guu gwasa̱n wu teɗi, aka̱ tlosi ka ten gwel gini.> >> ");
INSERT INTO gyz_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yek Yesu dla̱m nu wugo, yek ta̱ ngusi tot Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ta̱ ɓal njaa ka̱ ba̱n jwe asa̱ mbe ɗe Betapaji suk Betani jwe ni ten malka̱n yen tla̱da̱l gwe asa̱ mbe ɗe Za̱nda̱l Tlindi Zetun wu, yek ta̱ mbe ma̱n kopti jwas ɗe lop. Yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","<<La̱n ka̱ ba̱n gwe ni cina ɗa ni wu. Ka̱ te ka̱ ba̱mi wu ka mbi yen zhaki gon ga̱ ɓali gwe ba̱ ma̱lgon ɓo to tenti sowu, aka̱ pa̱tlti, aka̱ li tet na̱ ti. ");
INSERT INTO gyz_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Kume ma̱lgon ngemkii ɗe, <Yek laki ɗe ka̱ na̱ma pa̱tlti gwas ye wu?> Aka̱ wulti ɗe, <Bagaa ka̱ na̱ma lamti gwasi.> >> ");
INSERT INTO gyz_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yek ma̱jwe ta̱ shinsi wu lak mbi zhaki na̱k gwe ta̱ hwisi wu. ");
INSERT INTO gyz_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yek sa̱ ɓa pa̱tlti wu yek manti ka̱ ɓal wu yek ta̱ ngemsi ɗe, <<Yek laki ɗe ka̱ na̱ma pa̱tlti gwas ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yek sa̱ wulti ɗe, <<Bagaa ka̱ na̱ma lamti gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yek sa̱ ta̱lat mal Yesu, yek sa̱ wut luka̱l ten zhaki, yek sa̱ zi Yesu tenti. ");
INSERT INTO gyz_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sa̱ na̱ma la̱t wugo, yek mbala̱n ngusi talti luka̱l jwasa̱n ten tantu. ");
INSERT INTO gyz_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ta̱ ɓal njaa ka̱lu gwe tantu yil sut ka̱ Za̱nda̱l Tlindi Zetun wu, yek ma̱n kopti jwas mas njel pa̱lti hwol tuki asa̱ na̱ma ta̱sti ga̱ Nya na̱ nda̱li yal na̱k ɗe sa̱ yen kiɗi wul cit ɓanti jwe ta̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yek sa̱ ngusi wulti ɗe, <<Ma̱n mbit hwa wul ga̱ Nya ka̱ɗe guu gwe na̱ma tulti ka̱ shin ga̱ Bagaa wu!>> <<Ta̱mti mbadl ga̱ mbala̱n mal Nya. Ma̱ ba̱l nalti Nya Bal Kakshe.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","A ma̱n Paresi jon ni suksi, yek sa̱ wul Yesu ɗe, <<Ma̱n lishti, matl ma̱n kopti jwa ta̱s zak ga̱ɓa.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yek ta̱ ballisi ɗe, <<A ni kii ma hwiti, kume ma̱jin zak ga̱ɓa wu, ye a ga̱ɓa ka̱ lal gwasa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yek sa̱ ɓal njaa a Wurshelima go yek Yesu yen bal ba̱mi yek cit gonti yek ta̱ kuli. ");
INSERT INTO gyz_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yek ta̱ hwi ba̱n Wurshelima ɗe, <<Na̱k wule ka̱a̱ yisa̱n tantu mbit hwol tuki ka̱ multi jwaka̱n, ama ga̱ hwuda̱li ka̱n ni kii. ");
INSERT INTO gyz_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cin gwe ma̱n nget gwaka̱n a ganda̱l ba̱n gwaka̱n na̱ sa̱ba̱l ɗe ta̱s dlansi sukkii wu ni teɗi, a ma̱n hapti dlo a ngaɓikii ka̱ mas da̱nti gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sa catkii ɗa̱nka na̱m-na̱m, asa̱ tlo ma̱n ba̱n jwaka̱n ka mas, asa̱ jek bii jwaka̱n ka na̱k ɗe ba̱ka̱a̱ kan ɗe Nya tuli ta̱s kiskii sowu.>> ");
INSERT INTO gyz_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yek Yesu li ka̱lu lubii ga̱ Nya yek ta̱ nda mbolti ji ma̱n wulti wul ka jwe ni ka̱ lubii ga̱ Nyami wu. ");
INSERT INTO gyz_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yek ta̱ wulsi ɗe, <<Nya dla̱m ka̱ lishti ɗe, <Lubii gi a da̱m ɗe lu ngemti gini,> ama yek ka̱ palli ɗe, <lu hwunti ji kiɗi muka̱l wi.> >> ");
INSERT INTO gyz_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yek ta̱ ngusisi hwit ga̱ɓa ka̱lu lubii ga̱ Nyami mas cin, ama yek kiɗi ma̱n da̱nti ka̱ bii ngemti Nyami suk ma̱n yisti mba̱t ga̱ Musa suk kiɗi ji ma̱n ba̱mi njel ngot tantu gwe sa tlot wu. ");
INSERT INTO gyz_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Yek ba̱sa̱ mbi so, na̱k ɗe ma̱jwe ni ka̱li wu na̱ma kumti ta̱mti ga̱ɓa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gas gon Yesu nima hwit ga̱ɓa mbala̱n ata̱ nisi ma dla̱mti ga̱ɓa ma̱n ta̱mti ka̱ lubii ga̱ Nya. Yek kiɗi ma̱n da̱nti ka̱ bii ngemti Nyami suk ma̱n yisti mba̱t ga̱ Musa suk kiɗi ji ma̱n ba̱mi li teɗi. ");
INSERT INTO gyz_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Yek sa̱ wulti ɗe, <<Hwinii, na̱ wunda̱l nda̱lti gwik ka̱ na̱ma pa̱lti wul jin jwi? Wok ba̱lki nda̱lti gwisi wo?>> ");
INSERT INTO gyz_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yek Yesu wulsi ɗe, <<Am mago ba ngemkii ta̱k hwini nini: ");
INSERT INTO gyz_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Baptisma gwe Yohana pa̱li mbala̱n go sut mal Nya ka̱n ni ya? Ko ga̱ mbala̱n ka̱n?>> ");
INSERT INTO gyz_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yek sa̱ ngusi ga̱ɓa dani ka̱ dlo gwasa̱n, yek sa̱ wule, <<Kume ma̱ wuli ɗe, sut mal Nya ka̱go, ta wule, yek laki ɗe ba̱ma̱ kama̱n ga̱ɓa gwas so ye? ");
INSERT INTO gyz_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A kume ma̱ wuli ɗe ga̱ mbala̱n ka̱go, mas mbala̱n jin a laka̱nni na̱ ye na̱k ɗe mas jwasa̱n sa̱ kan ɗe Yohana ma̱n baptisma wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yek sa̱ wul Yesu ɗe, <<Ma̱ yis lu gwe baptisma ga̱ Yohana yil tet wu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yek Yesu wulsi ɗe, <<Am mago ba hwikii na̱ nda̱lti gwe a na̱ma pa̱lti wul wu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yek Yesu cinga̱li ga̱ɓa mbala̱n yek ta̱ wulsi ɗe, <<Ma̱lgon ni ɗa̱ gwe ɓak zhin inabi gwas wu, yek ta̱ ba̱l ma̱jon ta̱s kolit zhimi, yek ta̱ li ka̱ ba̱n gon dlenti yek ta̱ mul tu gon wonti. ");
INSERT INTO gyz_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kotlti yandi inabisi ɓal go yek ta̱ shin zhel gwas mal ma̱jwe ta̱ ba̱lsi kolti zhimi wu ta̱s kotlit yandi inabisi teɗi, yek sa̱ ɓo zheli, yek sa̱ mbolti koo ami. ");
INSERT INTO gyz_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yek ta̱ po shin zobsi zheli gon, yek sa̱ po ɓot ɗa yek sa̱ byalti yek sa̱ mbolti koo ami pak. ");
INSERT INTO gyz_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yek ta̱ po shin zheli ga̱ na mekan ɗa, yek sa̱ pa̱lit byas ɓoti yek sa̱ mbolti koo ami ɗa̱ pak. ");
INSERT INTO gyz_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","<<Yek ma̱n zhimi wule, <Ningo yek ba pa̱li ye?> Yek ta̱ po wule, <Ba shin yen gini gwe a lamti wu, a yisi ɗe sa ba̱lti nalti.> ");
INSERT INTO gyz_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","<<Yek ma̱n kolti zhimi yenti wugo, yek sa̱ wule, <Yen ga̱ ma̱n zhimi ka̱ ɓallu, ti ka̱n zhimi a pal ɗe gwasi kaal ɗa̱ ma̱shka̱n ga̱ abe. Ma̱ tloti, ta̱ zhimi da̱n ɗe ga̱na̱n.> ");
INSERT INTO gyz_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Yek sa̱ yilla̱t ɗa̱ka̱ zhimi ka yek sa̱ tloti. <<Yek ma̱n zhin wu a pa̱li ma̱ju ye? ");
INSERT INTO gyz_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ta tlosi ka ata̱ ba̱l zhimi ma̱jon.>> Yek mbala̱n kumi nu wugo yek sa̱ wule, <<Ba Nya zaki ta̱ pi nu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yek Yesu wutisi gwel, yek ta̱ wulsi ɗe, <<Yek ɗe gaa ga̱ ga̱ɓa ga̱n ɗe sa̱ lishi gwe, << <Ye gwe ma̱n kinti bii nge wu, yek pal ɗe hwa ye kinti bii?> ");
INSERT INTO gyz_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mas ma̱lgwe nda ten ye wugo, ta caccal ka, a ma̱lgwe ye wu ndet gaa go, a na̱kti ka na̱k apti.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yek ma̱n yisti mba̱t ga̱ Musa suk kiɗi ma̱n Pa̱ris ngwe ta̱s dop Yesu ka̱li na̱k ɗe sa̱ yisi ɗe tensi ka̱n ta̱ cinga̱l ga̱ɓa gwisi wu. Ama yek ɓanti ga̱ mbala̱n cisi. ");
INSERT INTO gyz_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yek kiɗi ji Ma̱n Yehuda shin ma̱jon jwe palli gaa gwasa̱n ɗe hwa mbala̱n wu ta̱s dop Yesu na̱ byas ɓotlka̱n ka̱ ga̱ɓa suk kumti ga̱s wul gwe sa pa̱lit wu ta̱s ba̱ltiti gobna ga̱ atli asa̱ dopti ɗa. ");
INSERT INTO gyz_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Yek sa̱ wulti ɗe, <<Ma̱n lishti, ma̱ yisi ɗe ga̱ɓa gwa wo gem ka̱n aka̱ palli mbala̱n mas ndakce, aka̱ dla̱mi mbala̱n gem kangwe sa yis Nya wu. ");
INSERT INTO gyz_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Mbun ɗe ta̱n ɓatl Kaisar guu wulpi boo ga̱na̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yek Yesu yis byas ɓotlka̱n gwasa̱n yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Ɓo za̱n wulpi ta ɓo yeni. Shishi suk shin ga̱ wok ni dani wo?>> Yek sa̱ wulti ɗe, <<Ga̱ Kaisar.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yek Yesu wulsi ɗe, <<Ba̱la̱n Kaisar wul jwasi, aka̱ ba̱l Nya wul jwas pak.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yek ba̱sa̱ mbi byas wul ka̱ iljwe ta̱ dla̱m ka̱ mbala̱n wu so, yek ba̱sa̱ po man ga̱ɓa so na̱k ɗe kangwe ta̱ ballisi ga̱ɓe cisi ɓanti wu. ");
INSERT INTO gyz_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yek kiɗi ji Ma̱n Yehuda jon jwe asa̱ mbesi ɗe ma̱n Saduki ju, jwe asa̱ kul wule ma̱jwe ma̱sh wu jo sa po tli ɗa̱ka̱ ma̱shka̱n ka sowu tul mal Yesu ta̱s ngemti. Yek sa̱ wulti ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","<<Ma̱n lishti, Musa lishi nii ka̱ mba̱t ɗe, kume ma̱lgon ma̱shi yek ta̱ zak kili gwasi a ba̱ta̱ zi yen sukti sogo, a yilka gwas hap kilisi ta̱s zi yen yilka gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Yek sa̱ wule, <<Ma̱jon si ɗe nitgi, mas jwasa̱n yilkeni ka̱n. Kakshe gwasa̱n ma̱shi yek ta̱ zak kili gwasi a ba̱ta̱ zi yen sukti so. ");
INSERT INTO gyz_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Yek gwe kopti wu hap kilisi yek ta̱ lak ma̱shi a ba̱ta̱ zi yen sukti so pak. ");
INSERT INTO gyz_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yek na̱ mekan gwasa̱n hap kilisi pak. Na̱nu-na̱nu yek mas jwasa̱n hap kilisi asa̱ na̱ma ma̱shka̱n a ba̱sa̱ zi yen sukti so. ");
INSERT INTO gyz_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Yek kilisi lak ma̱sh pak. ");
INSERT INTO gyz_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Gas tlit ga̱ dii atl wo wok ka̱ ni ɗe kos gwas wo na̱k ɗe mas jwasa̱n sa̱ hapti wu?>> ");
INSERT INTO gyz_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yek Yesu wulsi ɗe, <<Mbala̱n ji se na̱ma hapti modli asa̱ na̱ma hapti jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ama ma̱jwe mbun ɗe Nya a palla̱si kaami gas tlit ga̱ dii atl go, hapti po yi ka̱ dlo gwasa̱n so. ");
INSERT INTO gyz_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","A ba̱sa po ma̱sh so, sa pal ndakce suk mil shinti ji Nya. Sa pal ɗe mil ji Nya na̱k ɗe Nya a palla̱si kaami wu. ");
INSERT INTO gyz_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na̱k gwe Musa lishi ɗe ma̱jwe ma̱sh jo sa palla̱si kaami ɗe ta̱ ga̱ɓa ten lu me gwe wutu ci wu ka̱lu gwe Nya wulti ɗe, <Amik ɗe Nya ga̱ Ibirahim suk ga̱ Ishaku suk ga̱ Yakubu.> ");
INSERT INTO gyz_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ti wo Nya ga̱ ma̱n ma̱shka̱n ka̱ so, ama Nya ga̱ ma̱jwe ni na̱ mbadl wu ka̱n, na̱k ɗe malti wo mas mbala̱n wo mbadl nisi ɗa̱ wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yek jon ka̱ ma̱n yisti mba̱t ga̱ Musa wulti ɗe, <<Ma̱n lishti, ka̱ hwini gem.>> ");
INSERT INTO gyz_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Yek ba̱sa̱ po man kumti ga̱s ilgon malti so. ");
INSERT INTO gyz_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yek Yesu ngemsi ɗe, <<Ɗa̱ nii ka̱n mbala̱n a wule Almasihu wo yen ga̱ Dauda guu gwi? ");
INSERT INTO gyz_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Na̱k ɗe Dauda dla̱m ka̱ lishti ga̱ Zabura ɗe, << <Nya wul Bagaa gi ɗe: <<Da̱n ten ang shinti gini ");
INSERT INTO gyz_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","se a laki yek ka̱ man ngetl ga̱ ma̱n nget gwa yek a palli guu suk mbala̱n gwasa̱n a atl ɗakka.>> > ");
INSERT INTO gyz_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na̱k ɗe Dauda guu mbet ɗe Bagaa go, ɗa̱ nii ka̱n ta ni ɗe yen gwas gwi?>> ");
INSERT INTO gyz_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yek Yesu dla̱mi mas ma̱n kopti jwas a cina ɗa̱ mbala̱n wonti ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Pa̱n ɗem'ɗem suk ma̱n yisti mba̱t ga̱ Musa na̱k ɗe asa̱ lak bal luka̱l asa̱ ngusi ma̱tlti ɗa̱nka ta̱ mbala̱n ga̱ɓesi ka̱lu motgaa ji mbala̱n ɗa, asa̱ lami ɗe ta̱ mbala̱n ba̱lsi lu da̱nti ji kiɗi mbala̱n ka̱lu motgaa ga̱ gwasa̱n suk ka̱lu motgaa hwol tuki. ");
INSERT INTO gyz_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sik ɗe ma̱jwe asa̱ yemi wul guli modli ka asa̱ pa̱l tlal ngemti Nya ka̱ mbala̱n ta̱s yensi ɗa. Yek laki ɗe Nya a nolsi nal man mas mbala̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yek Yesu tlil gaa nya yek ta̱ yen ma̱n wul sa̱ na̱ma wutti wulpi ka̱ wul wutti ka̱ lubii ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yek ta̱ yen guli kili gon gwe ba̱ ilgon niɗɗa̱ sowu ta̱lak ba̱l nak njet wulpi gwe niɗɗa̱ wu mas. ");
INSERT INTO gyz_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yek Yesu wule, <<A ni kii ma hwit gem ɗe, wulpi gwe guli kili wu ba̱li wu man ga̱ naa mbala̱n mas. ");
INSERT INTO gyz_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Na̱k ɗe si wo njet ka̱n sa̱ ba̱li tet ka̱ nali gwe nisi ɗa̱ wu, ama kili go njeti gwe niɗɗa̱ wu ka̱n ta̱ wuti mas.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yek jon ka̱ ma̱n kopti ji Yesu nda ga̱ɓa ten kangwe sa̱ kin lubii ga̱ Nya na̱ hwa ye suk kangwe sa̱ la̱ka̱mi na̱ wul jwe mbala̱n ba̱li ɗe ga̱ pa̱lti wul ka̱ bii ngemti Nya wu. Yek Yesu wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Na̱k gwe ka̱ na̱ma yenti wul jin ju, cin ni teɗi gwe mas ye jwe ka̱ na̱ma yenti wu sa zak gon ten yilka gwas so, mas sa jek ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yek sa̱ wulti ɗe, <<Ma̱n lishti, a gasi ka̱n na̱k gwisi a pi gwi? A yek ma yeni ama̱ yisi ɗe na̱k gwisi ɓal njaa ta pi ye?>> ");
INSERT INTO gyz_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yek Yesu ballisi ɗe, <<Pa̱n ɗem'ɗem ba̱ ma̱lgon shelkii so na̱k ɗe mbala̱n wonti a tuli asa̱ wulkii ɗe sik ɗe ami, asa̱ po wule, <Tlit ga̱ dii atl ɓal njaa.> Ba̱k koɓa̱nsi so. ");
INSERT INTO gyz_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kume ka̱ kum dlanti ɗa̱nka suk la̱shi da̱nti ta̱mti wu, ba̱ ɓanti cikii so, na̱k ɗe ngetli ka̱n ta̱ na̱k gwisi pi wu. Ama ba̱ yek ɓo ni ɗe tlit ga̱ dii atl so.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yek ta̱ ngusi wulti gwasa̱n ɗe, <<Mbala̱n ji atl gon a dlansi suk mbala̱n ji atli gon. A mbala̱n ka̱ atl ga̱ guu gon a dlansi suk mbala̱n ga̱ guumi gon pak. ");
INSERT INTO gyz_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Dii atl a wu na̱ nda̱lti a kuza̱n a tlo mbala̱n, a mbala̱n wonti ɗa̱nka a ma̱sh na̱ byas cwo. A kiɗi wul cit ɓanti a pi sut nya. ");
INSERT INTO gyz_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ama na̱k jwisi a ɓo pi so se sa̱ dopkii yek sa̱ lakkii ka̱ bomti. A sa̱ ta̱lakii mal ma̱n kisti ga̱ɓa ka̱lu motgaa ji Ma̱n Yehuda asa̱ ɓalkii asa̱ za̱kii ka̱lu gwe asa̱ zi ma̱n pa̱lti byas wul ju. A sa̱ ta̱lakii a cina ɗa̱ guu ji ba̱n suk kiɗi jwasa̱n ten ɗe ka̱a̱ zi mbadl tena̱n ni. ");
INSERT INTO gyz_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na̱ nu ka̱n ka mbi tantu gwe ka hwisi ga̱ɓa tena̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ba̱ ilgwe ka dla̱m a cina ɗaasika wu hwotkii so. ");
INSERT INTO gyz_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ba hwikii ilgwe ka dla̱m wu suk ɓotlka̱n ga̱ɓa kangwe ma̱n nget gwaka̱n a man nget ga̱ɓa gwaka̱n sowu. ");
INSERT INTO gyz_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma̱n za̱t jwaka̱n suk yilkeni jwaka̱n suk yela̱n jwaka̱n a ba̱l bi ga̱ jon jwaka̱n ɗe ta̱s tlokii. ");
INSERT INTO gyz_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Mas mbala̱n a ngekii na̱k ɗe ka̱a̱ zi mbadl tena̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ama ko ɗe na̱m ka̱ ma̱dla̱n gaa gwaka̱n mago gon a gil ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kume ka̱ dlo mbadl go Nya a kiskii.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yek Yesu wulsi ɗa̱ɗe, <<Kume ka̱a̱ yen ma̱n hapti dlo ganda̱l Wurshelima wugo, ta̱k yisi ɗe ndat ga̱ ba̱mi ɓal njaa. ");
INSERT INTO gyz_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma̱jwe ni ka̱ atl ga̱ Yehudiya go sa ap to ka̱ tla̱da̱l ka. A ma̱jwe ni ka̱ ba̱n Wurshelima wu yil ɗa̱ka̱ ba̱mi ka. Ma̱jwe ni ka̱ nak mil ba̱n jo ba̱s te ka̱ bal ba̱mi so. ");
INSERT INTO gyz_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ka̱ multi jwisi ka̱n Nya a nol mbala̱n, ta̱ ga̱ɓa gwe mil shinti dla̱mti ga̱ɓa ga̱ Nya lishi wu da̱n ɗe gem. ");
INSERT INTO gyz_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Modli ma̱n mil tuki suk ma̱n mil kaal a da̱n ɗe wul cit gonti ka̱ multi jwisi na̱k ɗe bal bomti a te ka̱ atli a lilti mbadl ga̱ Nya a su sut ten mbala̱mi wu. ");
INSERT INTO gyz_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sa tlo jon jwaka̱n ka̱ dlanti a jon wo sa palla̱si ɗe zhel ɗa̱nka̱ atl jon ka. Ma̱jwe ba̱ Ma̱n Yehuda ka̱ sowu a ngaɓi Wurshelima se multi jwasa̱n njika̱n. ");
INSERT INTO gyz_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","<<Mbala̱n a yen wul cit ɓanti ten cin suk ten liɓi suk ten kyadla̱l. A ten dii atl wo mbadl ga̱ mbala̱n a lus ka na̱k ɗe ɓanti a cisi i'e ɗe bal ze nwuti wu. ");
INSERT INTO gyz_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Na̱k wule mbala̱n a na kotla̱n mbadl ka na̱ ɓanti, a bi mbadl gwasa̱n a ngusi ɓoti na̱k ɗe dlo nya a wu wu. ");
INSERT INTO gyz_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A paa mas mbala̱n yena̱nni Yen ga̱ Mbala̱n ka̱ nyaze, ka̱ nda̱lti suk bal nalti gini. ");
INSERT INTO gyz_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kume ka̱ yeni ɗe nu ɓa pi wu, dla̱la̱n nda̱li, kisti gwaka̱n ka̱ ɓal njaa.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yek Yesu cinga̱lisi ga̱ɓa gon ɗe, <<Ɓo yena̱n tlindi tula̱n suk naa tlindi, ");
INSERT INTO gyz_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","kume sa̱ nda telti pyal daa wugo, aka̱ yisi ɗe watla̱n ɓal njaa. ");
INSERT INTO gyz_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nu ka̱n kume ka yen iljwe a hwikii wu ɓa pi wu ta̱k yisi ɗe kanti ga̱ Nya ɗe guu ka̱ mbadl ga̱ mbala̱n ɓal njaa. ");
INSERT INTO gyz_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A ni kii ma hwit gem ɗe jon ka̱ mbala̱n ji se a ɓo ma̱sh so ɗe mas wul jwisi a pi wu. ");
INSERT INTO gyz_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Dlo nya suk dii atl a paki ama ko njet ka̱ ga̱ɓa gi wo a paki so. ");
INSERT INTO gyz_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","<<Pa̱n ɗem'ɗem na̱ gaa gwaka̱n, ba̱ za̱t mbadl ten ngukti wul suk tlat wul jwe a gillikii gaa ka̱wu suk daamti ten wul ji dii atl lil da̱nti gwaka̱n ka̱ so. Ɗe ba̱ nuk sogo, cin gwisi a tuli gasi gwe ba̱ka̱ yisi sowu, ");
INSERT INTO gyz_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","na̱k gwe a tarko dop wul wu. Nu ka̱n cimi a tuli mas mbala̱n ga̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Da̱ma̱n na̱ ka̱n gaa aka̱ na̱ma ngemti Nya ta̱k mana̱n yilti ɗa̱ka̱ wul jwisi ka aka̱ man dla̱lti a cina ɗaaka Yen ga̱ Mbala̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yek Yesu ngusi hwit ga̱ɓa mbala̱n ka̱ lubii ga̱ Nya mas cin, sukti ɓal go ata̱ to ten Za̱nda̱l Tlindi Zetun ata̱ mul to ka. ");
INSERT INTO gyz_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na̱ gasi ɓal go a mas mbala̱n mogaa ka̱ lubii ga̱ Nya ta̱s katit ka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Cin Motgaa bukti burodi gwe ba̱ yiis ni giɓi sowu gwe a Ma̱n Yehuda mbe ɗe Motgaa daamti ɗakcit boo ji Israila wu ɓal njaa go, ");
INSERT INTO gyz_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","yek kiɗi ma̱n Pa̱ris suk ma̱n yisti mba̱t ga̱ Musa ngusi ngot ga̱ Yesu ta̱s laki ta̱s tloti mukli na̱k ɗe ɓanti ga̱ mbala̱n cisi wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yek Sheɗan te ka̱ mbadl ga̱ Yehuda gwe asa̱ mbet ɗe Iskariyoti wu, ɗe na̱m ka̱ ma̱n kopti botli jwas ɗe kutl cet lop ju. ");
INSERT INTO gyz_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yek Yehuda li mal kiɗi ma̱n da̱nti ka̱ bii ngemti Nya suk ma̱n hapti dlo jwasa̱n ta̱s dla̱m suksi kangwe ta ba̱lsi Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yek sa̱ pa̱l hwol tuk i'e yek sa̱ dla̱m sukti ɗe sa ba̱lti wulpi. ");
INSERT INTO gyz_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yek Yehuda nda̱kisi ɗe ta̱ ba̱lsi Yesu. Yek ta̱ ngo tantu gwe ta ba̱lsiti aba̱ ma̱lgon ni ka̱li sowu. ");
INSERT INTO gyz_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Cin Motgaa bukti burodi gwe ba̱ yiis ni giɓi sowu balla̱t tet wi gas gwe a mas lubii ka̱ ba̱n Israila mbosh yen bagalla asa̱ taki Nya wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yek Yesu shin Biturus suk Yohana ta̱s lak la̱ka̱misi lu gwe sa nguk wul ka̱ Motgaami wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yek sa̱ ngemti ɗe, <<A'ako ka̱n ka̱ lami ɗe ta̱n pa̱li ko?>> ");
INSERT INTO gyz_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yek ta̱ wulsi ɗe, <<Ka̱a̱ te ka̱ ba̱mi wugo ka mbi ma̱lgon na̱ tat ze a gaa aka̱ kopti ka̱ lubii gwe ta te wu, ");
INSERT INTO gyz_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","aka̱a̱ wul baboomi ɗe, <Ma̱n lishti ka̱ shinnii ɗe ta̱n ngemki ɗe a'ako ka̱n ta nguk wul ga̱ Motgaa daamti ɗakcit boo ji Israila suk ma̱n kopti jwas ko?> ");
INSERT INTO gyz_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ta mbokikii ang ten bal punka gon to ka̱ tlal bii ka na̱ gobdlan a giɓi. Ka̱li ka̱n ka la̱ka̱mini lu.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yek sa̱ li wugo, yek sa̱ lak mbi mas na̱k gwe ta̱ hwisi wu. Yek sa̱ la̱ka̱n lwisi. ");
INSERT INTO gyz_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Yek sukti ɓal ɗe nguktisi ka̱ ɓal go, yek Yesu da̱m na̱ zhila suk mil shinti ji botli jwasi ta̱s nguki. ");
INSERT INTO gyz_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Yek ta̱ wulsi ɗe, <<A lami i'e ɗe ta nguk wul sukkii ten Motgaa daamti ɗakcit boo ji Israila a paa a nda tlat bomti. ");
INSERT INTO gyz_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","A ni kii ma hwiti ɗe, ndok ten gee ba po nguk wul sukkii ka̱ Motgaami na̱k ga̱n so se gas gwe ma pa̱la̱n bal Motgaa to nya ka ka̱lu gwe ma̱jwe Nya kissi wu a mogaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yek ta̱ kan mbuka ze inabi yek ta̱ pa̱l hwol tuk na̱ Nya yek ta̱ wulsi ɗe, <<Kama̱nnii ta̱k huuliini. ");
INSERT INTO gyz_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","A ni kii ma hwiti ɗe, ndok ten gee ba po tla ze inabi sukkii so se gas gwe ma̱ moo mal guu ga̱ Nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yek ta̱ kan burodi yek ta̱ pa̱l hwol tuk na̱ Nya yek ta̱ caccali yek ta̱ ba̱lsi yek ta̱ wulsi ɗe, <<Ga̱n go tlu tli gi ka̱n gwe a ba̱li ka̱ lal gwaka̱n wu, ngusi pa̱lti nu aka̱ na̱ma daamti gini.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Sa̱ nguk wugo, yek ta̱ po kan mbuke yek ta̱ wule, <<Mbuka ga̱n go ga̱ pyal dla̱lla̱t ga̱ɓa ka̱n gwe ni ka̱ hwulan gi ɗe ba shoti ka̱ lal gwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ama ma̱lgwe a ba̱l bi gi wuggu ta̱ na̱ma ngukti wul suk ami. ");
INSERT INTO gyz_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ami Yen ga̱ Mbala̱n ba ma̱shi na̱k kangwe Nya pa̱li wu, ama ma̱lgwe a ba̱l bi gi ɗe ta̱s tlo go, ta da̱n ɗe wul cit gonti.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yek ma̱n kopti jwas njel ngemti ji yilkeni ɗe wok ka pa̱l ilgon nu ka̱ mi wo? ");
INSERT INTO gyz_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yek ga̱ɓa te ka̱ dlo ga̱ ma̱n kopti ji Yesu ten ɗe wok ka da̱n ɗe kakshe ka̱si wo. ");
INSERT INTO gyz_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yek Yesu wulsi ɗe, <<Guu ji ma̱jwe ba̱sa̱ yis Nya sogo, asa̱ pa̱li wul mbala̱n jwasa̱n ta̱s yisi ɗe nda̱lti guu nisi ɗa, asa̱ lami ɗe ta̱ mbala̱n kansi ɗe ma̱n pa̱lti hwa wul. ");
INSERT INTO gyz_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ama kii wo ba̱ ni nu malkii so. Ha̱n ta̱ ma̱lgwe ni ɗe kakshe ka̱ kii wu da̱n na̱k nak'eni, a ma̱lgwe ni ɗe bali ka̱ kii wu da̱n na̱k zhel. ");
INSERT INTO gyz_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wok nal mani wo, ma̱lgwe na̱ma ngukti wul gwa ko ma̱lgwe na̱ma huulti ilga̱ ga̱ nguki wu? Ma̱lgwe na̱ma ngukti wu ka̱ɗe kakshe. Ama yek amikgu ka̱ dlo gwaka̱n na̱k ma̱n huulti ilga̱ ga̱ nguki. ");
INSERT INTO gyz_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kiik dla̱l na̱ gem suk ami ka̱ bomti jwe a tla wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na̱k gwe Aba gi palla̱n ɗe guu wu, nu ka̱n kii mago a palla̱kii ɗe guu wi pak. ");
INSERT INTO gyz_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka nguki aka̱ tla aka̱ ngukti wul gini ka̱lu gwe a ni ɗe guu wu, aka̱ da̱n ka̱ gobdlan guu aka̱ da̱n ɗe ma̱n kisti ga̱ɓa ga̱ ma̱n ga̱s ga̱ Israila ɗe kutl cet lop ju.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yek Yesu wule, <<Siman Biturus, ɓo kumi, Sheɗan ngwe i'e ta̱s pelkii na̱k gwe asa̱ pel gwe alkama ɗa̱ka̱ ka̱pti ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ama a nikma ngemti Nya ɗe ta̱ za̱t mbadl gwa dla̱l ten Nya, a kume ka̱ balla̱k tet mala̱n wugo, aka̱ nda̱li mbadl yilkeni jwa.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Yek Biturus wulti ɗe, <<Bagaa, ko ta̱ ka̱ bii gwe asa̱ ɓal mbala̱n wu ka̱ mago, ba te sukki, a kume ma̱shka̱n ka̱ ma wu, ba ma̱sh sukki.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yek Yesu wulti ɗe, <<A nikma hwiti ɗe, ka nge yisti gini asa̱mi ɗe mekan ka̱ gas ga̱n a paa gunda kol nda lakti yal ka̱ bultlwe.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yek Yesu ngem ma̱n kopti jwas ɗe, <<A shinkii ba̱ na̱ wulpi so aba̱ na̱ ngura so aba̱ na̱ kapta̱lan sogo, yek ka̱ mbi so ye?>> Yek sa̱ wule, <<Ma̱ mbi mas wul.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yek ta̱ wulsi ɗe, <<Ninga̱n go mas ma̱lgwe wulpi suk ngura niɗɗa̱ wu ta̱s kami ata̱ ngiɓi. Mas ma̱lgwe bal puka niɗɗa̱ sogo, ta̱s wul luka̱l gwas ka ata̱ wuli. ");
INSERT INTO gyz_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A ni kii ma hwiti ɗe, ngetli ka̱n ta̱ ilgwe sa̱ lishi tena̱n ka̱ lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya wu da̱n ɗe gem, gwe wuli ɗe, <Yek sa̱ palla̱t ndakce suk ma̱n pa̱lti byas wul.> Ilgwe sa̱ lishi tena̱n wu ɓalma da̱nti ɗe gem.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yek ma̱n kopti jwas wulti ɗe, <<Bagaa, kiɗi puka ɗe lop ka̱ju.>> Yek Yesu wulsi ɗe, <<Kumi wi.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yek Yesu zak ba̱mi yek ta̱ to ka̱ Za̱nda̱l Tlindi Zetun na̱k gwe ata̱ kul pa̱li wu, yek ma̱n kopti jwas kopti. ");
INSERT INTO gyz_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ta̱ to ka̱ tla̱nda̱li wugo, yek ta̱ wulsi ɗe, <<Ngema̱n Nya, ba̱ Sheɗan lakkii ten pa̱lti byas wul so.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yek ta̱ nak ɗam ɗa̱ malsi ka njet, yek ta̱ ngus atli yek ta̱ ngem Nya. ");
INSERT INTO gyz_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Yek ta̱ wule, <<Aba, ka̱ lami go aka̱ kami bomti ga̱n ka, ko ɗe ba̱ lamti gi ka̱ sowu, ama kangwe ka̱ lami wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ta̱ na̱ma ngemti Nya nugo yek yen shinti sut nya ka̱ ɓallu yek ta̱ ngusit nda̱lla̱t mbadli. ");
INSERT INTO gyz_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na̱k ɗe ta̱ ni ka̱ bomti wu, yek ta̱ dlot ten ngemti Nya hal lwani nitma lokti na̱k guda̱l hwulan. ");
INSERT INTO gyz_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ta̱ pak ngemti Nyami wugo, yek ta̱ pal te mal ma̱n kopti jwas ka yek ta̱ mbisi go sa̱ na̱ma ndet yeba̱l, na̱k ɗe sa̱ ni ka̱ duu tuk wu. ");
INSERT INTO gyz_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yek ta̱ wulsi ɗe, <<Yek laki ɗe ka̱a̱ na̱ma ndet yeba̱l ye? Tla̱nnya ta̱k ngema̱n Nya ba̱ Sheɗan lakkii ten ndat so.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ta̱ nisi ma ga̱ɓa nugo yek ma̱jon ka̱ju wonti sa̱ sa dopti gwasi. Yehuda, gon ka̱ ma̱n kopti jwas ɗe kutl cet lop ju ka̱ tulla̱si. Yek Yehuda ɗam njaa mal Yesu yek ta̱ swatti. ");
INSERT INTO gyz_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yek Yesu wulti ɗe, <<Yehuda, na̱ swatti ka̱n ka ba̱l bi gi Yen ga̱ Mbala̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yek ma̱n kopti jwe ni suk Yesu wu yeni nu wugo yek sa̱ ngem Yesu ɗe, <<Bagaa, ta̱n kan kiɗi puka ta̱n dlanni suksi a?>> ");
INSERT INTO gyz_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yek gon ka̱ ma̱n kopti ji Yesu wotl zhel ga̱ bal ma̱n Pa̱ris gon hal yek ta̱ kotlit ka̱n ga̱ ka̱t ang shinti ka. ");
INSERT INTO gyz_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yek Yesu wulsi ɗe, <<Zaka̱nsi!>> Yek ta̱ ta̱n ka̱n ga̱ ma̱lgwe sa̱ wotlit ka̱wu yek ka̱mi ndoki. ");
INSERT INTO gyz_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yek Yesu wul kiɗi ma̱n da̱nti ka̱ bii ngemti Nyami suk ma̱n hapti dlo jwasa̱n suk kiɗi jwasa̱n jwe tul ɗe ta̱s dopti wu ɗe, <<Ka̱a̱ li tet na̱ kiɗi puka suk sada ta̱k doɓa̱n ninini, muka̱l ka̱ɗe ami a? ");
INSERT INTO gyz_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A ni sukkii mas cin ka̱lu lubii ga̱ Nya yek ba̱ka̱ doɓa̱n so, yek ninge ka̱n ka̱a̱ ya mbi tantu dopti gini ka̱ nda̱lti byas wul ga̱ da̱mshal.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yek sa̱ dop Yesu, yek sa̱ zigaa na̱ ti, yek sa̱ ta̱lat ka̱ boo ga̱ bal ma̱n Pa̱ris. Yek Biturus ngusi kopti gwasa̱n tet dlenti. ");
INSERT INTO gyz_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yek sa̱ hot wutu a dii boo lubiimi wugo, yek sa̱ da̱m atli, Biturus mago yek ta̱ da̱m suksi njaa mal wuti. ");
INSERT INTO gyz_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yek ɗe na̱m ka̱ mil modli jwe na̱ma pa̱lti wul ka̱ lubiimi wu yenti wugo, yek ta̱ wutit gwel, yek ta̱ wule, <<Ma̱lga̱n go suk Yesu ka̱n ta̱ ni.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yek Biturus wule, <<Suk Yesu ka̱n a ni so, a yisti so pamma.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","La̱m da̱nti wugo, yek ma̱lgon po yis Biturus ɗa, yek ta̱ wule, <<Ki mago gon gwasa̱n ka̱n.>> Yek Biturus wule, <<Amik so.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nak po la̱m da̱nti tek wugo, yek ma̱lgon po wulti ɗe, <<Gem, ma̱lga̱n go suk Yesu ka̱n ta̱ ni. Na̱k ɗe ti mago ma̱n Galili ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yek Biturus wule, <<A yis ilgwe ka̱ na̱ma dla̱mti wu so pamma.>> Ta̱ na̱ma dla̱mti nugo yek gunda kol lak yal ka̱ bultlwe. ");
INSERT INTO gyz_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yek Bagaa Yesu balla̱ti, yek ta̱ wuti gwel Biturus, yek Biturus daam ilgwe Yesu hwit wu ɗe, <<Ka nge yisti gini asa̱mi ɗe mekan a paa gunda kol nda lakti yal ase ka̱ bultlwe.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Yek Biturus yil deɓa̱l yek ta̱ kul i'e. ");
INSERT INTO gyz_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yek ma̱jwe na̱ma da̱nti mal Yesu wu ndet wulti wul jon asa̱ na̱ma ɓot gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yek sa̱ ɓalit gwel ka, yek sa̱ njel wulti gwas ɗe, <<Hwini ma̱lgwe ɓok wu ta̱n yisi ɗe ki wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yek sa̱ ngusi byalti gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lu tlo wugo, yek kiɗi ma̱n ba̱n suk kiɗi ma̱n da̱nti ka̱ lubii ga̱ Nya suk ma̱n lishti mba̱t ga̱ Musa mogaa, yek ma̱n hapti dlo tulli Yesu malsi. ");
INSERT INTO gyz_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yek sa̱ wulti ɗe, <<Kume kik ɗe Almasihu go, hwinii.>> Yek Yesu wulsi ɗe, <<Kume a hwikii mago ka kan ga̱ɓa gi so. ");
INSERT INTO gyz_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A kume a kum ga̱s ilgon malkii go ka balli so. ");
INSERT INTO gyz_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama ndok ase, ami Yen ga̱ Mbala̱n a da̱n ten ka̱t ang shinti ga̱ Nya Bal Kakshe.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yek mas jwasa̱n ngemti ɗe, <<Kik ɗe Yen ga̱ Nyami a?>> Yek ta̱ wulsi ɗe, <<Gem ka̱n ka̱a̱ dla̱mi, nu ka̱n ni.>> ");
INSERT INTO gyz_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yek sa̱ wule, <<Yek ma̱ yii ma ɓa̱tti ye, na̱k ɗe ma̱ kumi tet bi ɗatka wu?>> ");
INSERT INTO gyz_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yek mas kiɗi ji ma̱n Yehudasi tlinya yek sa̱ ta̱la Yesu mal Bilatus gobna, ");
INSERT INTO gyz_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","yek sa̱ ndet za̱t duu gaa ɗe, <<Ma̱ mbi ma̱lga̱n ten gilla̱t ga̱ mbala̱n jina̱n ɗe ba̱s ba̱l wulpi boo gwasa̱n Kaisar guu so. A ta̱ na̱ma wulti ɗe tik ɗe Almasihu guu.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Yek Bilatus ngem Yesu ɗe, <<Kik ɗe guu ga̱ ma̱n Yehuda?>> Yek Yesu wule, <<Nu ka̱n ni.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Yek Bilatus hwi kiɗi ma̱n da̱nti ka̱ lubii ga̱ Nyami suk naa mbala̱n ɗe, <<Yek laki yek ka̱a̱ tulla̱t ye? Ami wo a mbi byas ilgwe ta̱ pa̱li wu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yek mbala̱mi ngusi wulti ɗe, <<Ga̱ɓa gwe ata̱ hwi mbala̱n wu ka̱ɗe ma̱n tlilti mbadl gwasa̱n ka̱ mas ba̱n ji Yehudiya, tet Galili ka̱n ta̱ nde, yek tik ɓallu a ɗee.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bilatus kumi nu wugo yek ta̱ kum ga̱zi ɗe ko Yesu wo ma̱n Galili ka̱ɗe ti. Yek sa̱ wulti ɗe ma̱n Galili ka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Bilatus kumi ɗe Yesu wo ka̱ atl ga̱ Hiridus guu ka̱n ta̱ ni wu, yek ta̱ wulsi ɗe, ta̱s ta̱lat malti na̱k ɗe Hiridus guu ni Wurshelima ka̱ multi jwisi wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hiridus guu yen Yesu wugo, yek ta̱ pa̱l hwol tuki i'e na̱k ɗe ta̱ la̱m multi ata̱ na̱ma kumti ga̱ɓa tenti wu. Ta̱ lami ta̱s yen wul cit ɓanti gwe a Yesu pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yek ta̱ kum ga̱s wul wonti mal Yesu ama yek ba̱ Yesu wulti ɗe ilgon so. ");
INSERT INTO gyz_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kiɗi ma̱n da̱nti ka̱ lubii ga̱ Nya suk ma̱n yisti mba̱t ga̱ Musa ni ka̱li asa̱ na̱ma ta dla̱mti byas wul tenti. ");
INSERT INTO gyz_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Yek Hiridus suk ma̱n hapti dlo jwas wulit wul jon, yek sa̱ wulit wul jon yek sa̱ lakit bal luka̱l, yek sa̱ palla̱t su mal Bilatus ka. ");
INSERT INTO gyz_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndok ten gasi, yek Hiridus suk Bilatus da̱n ɗe yela̱n, na̱k ɗe yela̱n dlanti ka̱ɗe si wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yek Bilatus mo kiɗi ma̱n da̱nti ka̱ bii ngemti Nya suk kiɗi ji ma̱n ba̱mi suk mbala̱mi mas. ");
INSERT INTO gyz_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Yek ta̱ wulsi ɗe, <<Ka̱a̱ tulli ma̱lga̱n mala̱n ɗe ta̱ na̱ma gilla̱t ga̱ mbala̱n, ama yek a bodla̱lti yek baa mbit na̱ byas ilgon so. ");
INSERT INTO gyz_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","A ba̱ Hiridus mbit na̱ byas ilgon so pak, yek laki yek ta̱ palla̱t tet mala̱nni. Kiik ka yeni wu, ta̱ pa̱l ilgwe a laki ɗe ta̱n tlot wu so. ");
INSERT INTO gyz_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Yek laki ɗe ɓot ka̱n ba ɓoti a paa a zakti.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Yek mbala̱mi ɓel bi yek sa̱ ngusi wulti na̱ nda̱lti ɗe, <<Za̱n gaa na̱ ma̱lga̱n! A ka̱ zakini Barabas.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas tulli dlanti ka̱ dlo ga̱ mbala̱n a Wurshelima, yek ta̱ po tlo ma̱lgon. Yek laki yek sa̱ ɓalti. ");
INSERT INTO gyz_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yek Bilatus wulsi ɗa̱ɗe, ta̱ lami ɗe ta̱s zak Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yek sa̱ ngusi dla̱mti na̱ nda̱lti ɗe, <<Ɓaka̱nti ten guda̱l yencin ta̱s ma̱shi!>> ");
INSERT INTO gyz_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Yek Bilatus po wulsi asa̱mi na mekan ɗe, <<Yek laki ɗe ka̱ lami ta̱ ma̱lga̱n ma̱shi ye? Byas wul yek ta̱ pa̱li ye? A mbit na̱ byas ilgwe a laki ta tlot wu so. Ba laki asa̱ ɓot na̱ tlemndi a paa a zakti.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ama yek sa̱ nge, yek sa̱ ngusi wulti na̱ nda̱lti ɗe, <<Ɓaka̱nti ten guda̱l yencin!>> Yek ga̱ɓe gwasa̱n wu ka̱ dla̱li. ");
INSERT INTO gyz_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Yek Bilatus pa̱lisi ilgwe sa̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yek ta̱ zakisi Barabas, ma̱lgwe sa̱ ɓalti ten ɗe ta̱ tlo ma̱lgon wu, yek ta̱ ba̱lsi Yesu ta̱s pa̱lit ilgwe sa̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma̱n hapti dlo na̱ma za̱t gaa na̱ Yesu nugo, yek sa̱ mo suk ma̱lgon asa̱ mbet ɗe Siman ma̱n ba̱n Sayirin ta̱ na̱ma la̱t Wurshelima. Yek sa̱ dopti yek sa̱ zit guda̱l yencin gwe sa̱ ɓak Yesu dani wu gaa, yek sa̱ lakti ta̱s kop Yesu na̱ nali. ");
INSERT INTO gyz_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A mbala̱n wonti na̱ma kopti gwasa̱n suk modli jon asa̱ na̱ma desti lee. ");
INSERT INTO gyz_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yek Yesu balla̱ti, yek ta̱ wulsi ɗe, <<Modli Wurshelima, po kuli ninini gaa so, kuli gaa gwaka̱n suk mil jwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Gas gon wo ka wule, <Modli jwe zi yen so, a ba̱sa̱ lu mil kaal sogo ma̱n hwol tuk ka̱ɗe si.> ");
INSERT INTO gyz_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ten gasisi ka̱n << <mbala̱n a wul tla̱da̱l ɗe, <<Ndenii sut gaa,>> asa̱ wul za̱nda̱l ɗe, <<Yitlani ka.>> > ");
INSERT INTO gyz_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Kume sa̱ pa̱li nu a tlindi yi diki go, nii ka̱n a pi gwi ɗe tlindi koo wu?>> ");
INSERT INTO gyz_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yek sa̱ ta̱la mbala̱n ɗe lop jon jwe pa̱l byas wul wu ta̱s tlosi pak suk Yesu. ");
INSERT INTO gyz_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yek sa̱ ta̱lasi ka̱lu gwe asa̱ mbe ɗe <<Is Gaa>> wu. Ka̱li ka̱n sa̱ ɓakti ten guda̱l yencin suk mbala̱n ɗe lop jwe pa̱l byas wul ju. Gon ni ten guda̱l yencin ten ka̱t ang shinti gwasi a gon wo ten ka̱t ang yali gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yek Yesu wule, <<Aba, taasi ma̱jin byas wul jwasa̱n ka, na̱k ɗe ba̱sa̱ yis ilgwe sa̱ na̱ma pa̱lti wu sowu.>> Yek sa̱ huul luka̱l ga̱ Yesu ka̱ dlo gwasa̱n ten botlti ga̱ ma̱lgwe a kan wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yek mbala̱n ngusi yenti ga̱ Yesu, yek kiɗi jwasa̱n wulit wul jon ɗe, <<Ta̱ kis naa mbala̱n, ta̱s kis gaa gwas la kume tik ɗe Almasihu gwe Nya botlti wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Yek ma̱n hapti dlo jwe ɓakti ten guda̱l yencimi wu wulit wul jon, yek sa̱ takit mbayi ze. ");
INSERT INTO gyz_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Yek sa̱ wulti ɗe, <<Kume kik ɗe guu ga̱ ma̱n Yehuda go, kis gaa gwa la.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yek sa̱ lishi ten guda̱l yencimi to gaa ɗatka̱ɗe, <<Ma̱lga̱n ka̱ɗe guu ga̱ ma̱n Yehuda.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yek ɗe na̱m ka̱ ma̱jwe pa̱l byas wul ɗe sa̱ ɓaksi ten guda̱l yencin mal Yesu wu, hwit byas ga̱ɓa ɗe, <<Ale kik ɗe Almasihu nwa? Kis gaa gwa aka̱ kisnii pak la.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yek ma̱li gon wu matlti yek ta̱ wulti ɗe, <<Ɓanti ga̱ Nya mago cik sa? Ɗe ilgwe sa̱ pa̱lini wu ka̱n sa̱ pa̱lit wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mi wo byas ilgwe ma̱ pa̱li wu mbuki ta̱s pa̱lini nu, ama ma̱lga̱n go ta̱ pa̱l byas ilgon so.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Yek ta̱ wul Yesu ɗe, <<A ka̱ yisi lu ne, kume ka̱ ɓal ɗe guu wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yek Yesu wulti ɗe, <<A nikma hwit gem ɗe, ase go ka da̱n suk ami ka̱ Boo ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sa̱ ni nugo, ka̱ dlo cin, yek da̱mshal yitla lu ka mas, se na̱k cin celti. ");
INSERT INTO gyz_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Yek cin zak cilti, yek labule ga̱ lubii ga̱ Nya kesh su dlo ka. ");
INSERT INTO gyz_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yek Yesu wul na̱ nda̱lti ɗe, <<Aba gini, ka̱ ang gwaka̱n a zi mbadl gini.>> Ta̱ dla̱m nu wugo, yek ta̱ ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yek bal ma̱n hapti tlo ga̱ ma̱n Roma gwe ni ka̱li wu yeni nu wugo, yek ta̱ ta̱s Nya, yek ta̱ wule, <<Gem, ma̱lga̱n go zok mbala̱n ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Yek mas ma̱jwe mogaa ta̱s yen ilgwe a pi wu yeni nu wugo, yek sa̱ ɓo ang ten ngetli, yek sa̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yek mas ma̱jwe yis Yesu, suk modli jwe kopti tet Galili wu dla̱l tet dlenti, yek sa̱ ngusi yenti ilgwe na̱ma pa̱t wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma̱lgon ni ɗa asa̱ mbet ɗe Yusupu ma̱n pa̱lti zok wul gon. Ta̱ na̱ma hwol tuk ten ɓa̱tti ga̱ Nya ta̱s tul ɗe guu ka̱ mbadl ga̱ mbala̱n. Ti wo ma̱n ba̱n ga̱ Yehuda gon ka̱n gwe asa̱ mbe ɗe Arimatiya wu, a bal mbala̱n ga̱ ma̱n Yehuda ka̱ pak. Ama ba̱ta̱ mo bi suksi ten ilgwe sa̱ pa̱li Yesu wu so. ");
INSERT INTO gyz_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yek ta̱ li mal Bilatus yek ta̱ ngemti ta̱s ba̱lti hwuu ga̱ Yesu. Yek ta̱ zakti ta̱s lak kami. ");
INSERT INTO gyz_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yek Yusupu shit hwuunisi sut ɗa̱ ten guda̱l yencimi ka, yek ta̱ kus ka ka̱ mbuni hwol luka̱l yek ta̱ zi ka̱ gaa zukɗi gwe sa̱ tlat ka̱ paa a ba̱sa̱ ɓo lep ma̱lgon giɓi sowu. ");
INSERT INTO gyz_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A cin la̱ka̱nti wul ka̱n na̱k ɗe gas shukti ɓal njaa wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yek modli jwe kop Yesu tet Galili wu li suk Yusupu yek sa̱ yen gaa zukɗisi suk kangwe sa̱ zi hwuu ga̱ Yesu a giɓi wu. ");
INSERT INTO gyz_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Yek sa̱ li ga̱za̱n yek sa̱ la̱ka̱n turare suk mil tuksa̱ti, yek sa̱ shuki ten gas shukti na̱k gwe mba̱t ga̱ Musa dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Gas ndat multi ɗe na̱m ga̱ nitgi kaal ɗa̱ gas shukti ka̱ bultlwe yek modli ju li ka̱ gaa zukɗi ga̱ Yesu na̱ turare gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yek sa̱ mbi go sa̱ guda̱l bal ye gwe sa̱ zi ten bi gaa zukɗisi wu ka̱wi. ");
INSERT INTO gyz_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yek modlisi te ka̱ gaa zukɗisi wugo yek ba̱sa̱ mbi hwuu ga̱ Yesu Bagaa a giɓi so. ");
INSERT INTO gyz_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Sa̱ na̱ma daamti gwasa̱n nugo yek ma̱jon ka̱ju si ɗe lop a malsi na̱ hwol luka̱l ma̱n cilti i'e. ");
INSERT INTO gyz_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ɓanti ɓa cisi go yek sa̱ ngusa̱l gaa gwasa̱n atli. Yek mbala̱mi wulsi ɗe, <<Yek laki ɗe ka̱ na̱ma ngot ga̱ ma̱lgwe ni kaami wu ka̱ hwuu mbala̱n ye? ");
INSERT INTO gyz_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ta̱ po yi ɗee so, ta̱ tli ɗa̱ka̱ ma̱shka̱n ka wu na̱k gwe ta̱ dla̱mi ata̱ yi sukkii a Galili wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ɗe ta̱ wulkii ɗe sa ba̱l bi ga̱ Yen ga̱ Mbala̱n a ang ɗa̱ ma̱n pa̱lti byas wul ka asa̱ ɓakti ten guda̱l yencin, a ten gas na̱ mekan wo ata̱ tli ɗa̱ka̱ ma̱shka̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yek ga̱ɓe te modlisi ka̱n, ");
INSERT INTO gyz_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Yek sa̱ pal tet ka̱lu gaa zukɗisi wugo, yek sa̱ hwi mil shinti ji botli ga̱ Yesu ɗe kutl cet na̱m ju suk mas ma̱jwe ni ka̱li wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Modli jwe li ka̱lu gaa zukɗisi jo sik ɗe, Maryam Maga̱dala suk Yuwana suk Maryam ana ga̱ Yakubu suk naa modli jwe ni suksi wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ama yek mil shinti ji botlisi palli ga̱ɓe ɗe jetiti yek ba̱sa̱ kan so. ");
INSERT INTO gyz_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Yek Biturus tlinya na̱ apti ta̱s lak yen ilgwe modli ju dla̱m wu, yek ta̱ kus gaa zukɗisi, yek ta̱ yen luka̱l gwe sa̱ lep hwuuni ga̱ Yesu a giɓi wu ten ka̱ti gon, yek ta̱ pal lubii a ili nitma cit ɓanti ata̱ na̱ma daamti gwas a dani. ");
INSERT INTO gyz_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ten gasisi, yek ma̱n kopti ji Yesu jon ɗe lop na̱ma la̱t ten tantu ba̱n gon asa̱ mbe ɗe Imawus, dlenta̱t ga̱ Imawus tet Wurshelima wo mil ɗe nitgi ka̱n. ");
INSERT INTO gyz_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Asa̱ na̱ma ga̱ɓa ka̱ dlo gwasa̱n ten mas wul jwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Sa̱ na̱ma ga̱ɓa asa̱ na̱ma daamti gwasa̱n nugo yek Yesu ka̱wu yek ta̱ njel la̱t suksi. ");
INSERT INTO gyz_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ama yek ba̱sa̱ yisi ɗe Yesu ka̱ ni malsi so. ");
INSERT INTO gyz_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yek ta̱ ngemsi ɗe, <<Yek ka̱a̱ na̱ma dla̱mti ten tantu na̱n ye?>> Yek sa̱ dla̱l ka̱li asa̱ na̱ma duu tuki. ");
INSERT INTO gyz_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yek gon gwasa̱n asa̱ mbet ɗe Kiliyopas ngemti ɗe, <<Kik ɗe ma̱nda̱ki na̱ ngwe a Wurshelima ɗe ba̱ka̱ yis iljwe na̱ma pa̱t ka̱ multi jin so gwa?>> ");
INSERT INTO gyz_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yek Yesu ngemsi ɗe, <<Yek pi ye?>> Yek sa̱ wulti ɗe, <<Iljwe pi ten bi ga̱ Yesu ma̱n Nazarat wu ma̱n dla̱mti ga̱ɓa ga̱ Nya, ma̱n nda̱li ga̱ɓa a ma̱n pa̱lti kiɗi wul a cina ɗa̱ Nya suk mas mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yek kiɗi ma̱n da̱nti ka̱ bii ngemti Nya suk kiɗi jina̱n ba̱ltiti ma̱n tlot gwasi yek sa̱ ɓakti ten guda̱l yencin. ");
INSERT INTO gyz_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma̱ lak mbadl ɗe tik ka yilli ma̱n Yisiraila tet ɗa̱ka̱ ang ga̱ ma̱n nget ga̱na̱n ka, ama yek multi ɗe mekan ka̱ ɓali na̱ pa̱t ga̱ ili. ");
INSERT INTO gyz_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Yek modli jon ka̱ mbala̱n jina̱n cini ɓanti ɗe sa̱ yil ka̱ bultlwe yek sa̱ li ka̱lu gaa zukɗisi, ");
INSERT INTO gyz_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","yek ba̱sa̱ mbi hwuu gwas so. Yek sa̱ pal teɗi yek sa̱ hwini ɗe, gwel gwasa̱n ɓuli yek sa̱ yen mil shinti ji Nya jwe wulsi ɗe Yesu tli ɗa̱ka̱ ma̱shka̱n ka wi. ");
INSERT INTO gyz_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Yek jon ka̱ mi li ka̱lu gaa zukɗisi pak yek sa̱ mbi go ta̱ po yi so na̱k gwe modli ju dla̱m wu.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yek Yesu wulsi ɗe, <<Kii wo ka̱ ka̱dla̱n hwo, a yisti mas wul jwe ma̱n dla̱mti ga̱ɓa ga̱ Nya lishi wu bomikii gaa! ");
INSERT INTO gyz_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ngetli ka̱n ta̱ Almasihu tla bomti nu apaa ta̱ da̱n ka̱ nalti gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yek ta̱ ndesi ga̱ɓa ten lishti ga̱ Musa suk mas ga̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya jwe lish ga̱ɓa tenti wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yek sa̱ ɓal njaa a Imawus go, yek Yesu pi wule ta zaka̱nsi ta̱s li cina. ");
INSERT INTO gyz_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Yek sa̱ ngemti ta̱s da̱n suksi ka̱ ba̱mi na̱k ɗe sukti ka̱ ɓallu, a cin nda bii wi. Yek ta̱ kopsi ka̱lu gwe sa mullu. ");
INSERT INTO gyz_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yek sa̱ da̱m na̱ zhila ta̱s nguk wul wugo, yek ta̱ kan burodi yek ta̱ pa̱l hwol tuk na̱ Nya yek ta̱ caali yek ta̱ huulisi. ");
INSERT INTO gyz_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yek ninge yek sa̱ yisti, njet go yek ta̱ gilisi ka. ");
INSERT INTO gyz_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Yek sa̱ wul ka̱ dlo gwasa̱n ɗe, <<Ta̱ hwini ga̱ɓa ga̱ Nya ten Almasihu ten tantu go, yek ba̱ mbadl kweka̱mini ka̱sa?>> ");
INSERT INTO gyz_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yek sa̱ tlinya yek sa̱ pal su Wurshelima ka, yek sa̱ mbi ma̱n kopti jwas ɗe kutl cet na̱m suk ma̱jwe ni suksi ju. ");
INSERT INTO gyz_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yek mas ma̱n koptisi ngusi wulti ɗe, <<Gem ka̱n, Yesu Bagaa tli ɗa̱ka̱ ma̱shka̱n ka wi yek ta̱ mo suk Biturus.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yek sa̱ dla̱m ilgwe pi ten tantu Imawus wu suk kangwe sa̱ yisti ɗe ta̱ huulisi burodi wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sa̱ na̱ma ga̱ɓe nugo yek Yesu ka̱ ɓallu na̱ gaa gwasi, yek ta̱ dla̱l ka̱ dlo gwasa̱n, yek ta̱ wulsi ɗe, <<Ta̱ mbadl gwaka̱n ta̱mi.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yek ɓanti cisi mas jwasa̱n, sa̱ da̱m gwa we lul ka̱n sa̱ yenti. ");
INSERT INTO gyz_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yek ta̱ ngemsi ɗe, <<Yek ka cikii ɓanti nu ɗe ba̱ mbadl dla̱likii so ye? ");
INSERT INTO gyz_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɓo yena̱n ang suk asa̱n gini, ami ka̱n na̱ gaa gini, ta̱na̱nni nini ta̱k ɓo kumini. Lul ka̱ɗe ami so, lul wo tli niɗɗa̱ na̱k gi wu so.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ta̱ dla̱m nu wugo, yek ta̱ mbokisi ang ten ang suk asa̱n gwasi. ");
INSERT INTO gyz_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A ba̱ mbadl gwasa̱n ɓo dla̱l so, na̱k ɗe ili cisi ɓanti ama asa̱ na̱ma hwol tuk pak. Yek ta̱ ngemsi ɗe, <<Ilga̱ nguki ni kii ɗa a ɗee ma?>> ");
INSERT INTO gyz_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yek sa̱ ba̱lti kwes ga̱ buki. ");
INSERT INTO gyz_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yek ta̱ kami yek ta̱ nguki asa̱ na̱ma yenti. ");
INSERT INTO gyz_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yek ta̱ wulsi ɗe, <<Ilgwe a hwikii ɗe a yi sukkii wuggu, mas iljwe sa̱ dla̱m tena̱n ka̱ mba̱t ga̱ Musa, suk iljwe ma̱n dla̱mti ga̱ɓa ga̱ Nya lishi, suk ka̱ Zabura wu a da̱m ɗe gem.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yek ta̱ ɓul mbadl gwasa̱n kangwe sa yis lishti ga̱ ga̱ɓa ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yek ta̱ wulsi ɗe, <<Ilgwe ni ga̱ lishi wuggu, Almasihu a tla bomti ata̱ ma̱shi, a ten ndat cin na mekan wo ta tli ɗa̱ka̱ ma̱shka̱n ka. ");
INSERT INTO gyz_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A paa sa̱ hwi ga̱ɓa mbala̱n ten dii atl ɗa̱nka, ten bi cit atl gaa mal Nya suk taasti byas wul jwasa̱n ka ka̱ shin gwasi. Tet Wurshelima ka̱n sa nde. ");
INSERT INTO gyz_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Kik ka yen wul jwisi na̱ gwel gwaka̱n, aka̱a̱ dla̱mi mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yekgu ba shinikii lu na̱ ma̱lgwe aba gi dla̱lli ga̱ɓa ɗe ta ba̱li wu, ama ɓa̱ti ka̱ bal ba̱mi se Nya ba̱lkii nda̱lti sut paa.>> ");
INSERT INTO gyz_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","La̱m multi wugo, yek Yesu yilli ma̱n kopti jwas te kaal bal ba̱n Wurshelima ka, yek sa̱ li Betani. Yek ta̱ tlil ang gwas nya, yek ta̱ ngemisi hwa wul ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ta̱ nisi ma ngemti hwa wul ga̱ Nya nugo, yek ta̱ huul suksi, yek sa̱ kanti to nya ka. ");
INSERT INTO gyz_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yek sa̱ ngus atli, yek sa̱ ba̱lti nalti. Yek sa̱ pal te Wurshelima ka na̱ hwol tuki i'e, ");
INSERT INTO gyz_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","yek sa̱ ngusi la̱t ka̱ lubii ga̱ Nya mas cin, asa̱ na̱ma ta̱sti ga̱ Nya Bal Kakshe.");
INSERT INTO gyz_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ten ndat zhile wo Ga̱ɓe ni ɗa, a Ga̱ɓe wo suk Nya ka̱n ni, a Ga̱ɓe wo Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tik ni suk Nya tet ten ndat zhile. ");
INSERT INTO gyz_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tumalti ka̱n sa pa̱l mas wul, a ɗe ba̱ tumalti ka̱ sogo sa̱ pa̱l ilgon ka̱ wul jwe sa̱ pa̱li wu so. ");
INSERT INTO gyz_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tik ɗe ma̱n ba̱lti mbadli, a mbadl gwisi ka̱ɗe cilti ga̱ mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cilti na̱ma cilti ka̱ da̱mshal, aba̱ da̱mshali man tlat gaa gwas so. ");
INSERT INTO gyz_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ma̱lgon ni ɗa ma̱lgwe Nya ka̱ shinti sut wu, shin gwas ka̱ɗe Yohana. ");
INSERT INTO gyz_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ta̱ tuli ta̱s ba̱l sheda ga̱ gem ten bi ga̱ cilti, kangwe mas mbala̱n a kum sheda gwisi asa̱ ba̱l gem tumalti wu. ");
INSERT INTO gyz_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","A ba̱ Yohana gaa gwas ka̱ɗe cilti so, ama ta̱ tuli ta̱s ba̱l sheda ten cilti. ");
INSERT INTO gyz_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cilti ga̱ gem gwe a ba̱l mas mbala̱n cilti wu, na̱ma tul ten dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tek go ga̱ɓa gwisi da̱m ten dii atli, a ko ɗe tumalti ka̱n sa̱ pa̱l dii atli wu, ama ba̱ mbala̱n ji dii atli yisti so. ");
INSERT INTO gyz_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ta̱ tul mal mbala̱n jwasi, ama yek sa̱ ge kanti gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ama mas ma̱jwe kanti yek sa̱ ba̱l gem na̱ shin gwas go, ta̱ ba̱lsi iko ga̱ na̱t ɗe mil ji Nya, ");
INSERT INTO gyz_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ma̱jwisi da̱m ɗe mil ji Nya tu ten tantu za̱t yen ga̱ mbala̱n so, ba̱ ɗe tumal mot ga̱ ba maani suk kili mbala̱n ka̱ so, a ba̱ ɗe tumal lamti ga̱ mbala̱n ka̱ so, ama tumal lamti ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ga̱ɓe da̱m ɗe mbala̱n yek ta̱ da̱m sukmi. Mik yen nalti gwasi, nalti ga̱ Yen ɗe na̱m gwe ba̱ wunda̱l gwas ni ɗa̱ so ɗe ta̱ yil sut mal Abe wu, ata̱ njika̱n na̱ alheri suk gem. ");
INSERT INTO gyz_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana tlil yal nya yek ta̱ ba̱l sheda tenti. Yek ta̱ wuli ɗe, <<Ga̱mi ka̱ɗe ma̱lgwe a wule, <Ma̱lgon a tul ka̱ kaal gini, ma̱lgwe nal mana̱n wu, ten ɗe tik ni ɗa a ba̱sa̱ ɓo za̱n sowu.> >> ");
INSERT INTO gyz_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tumal nalti ga̱ alheri gwas ka̱n mas jina̱n ma̱ mbi albarka ten albarka. ");
INSERT INTO gyz_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ai mba̱t ga̱ɓa wo tumal Musa ka̱n Nya ba̱li, ama alheri suk gem wo tumal Yesu Almasihu ka̱n tuli. ");
INSERT INTO gyz_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma̱lgon ɓo taɓa yenti ga̱ Nya so, seko Yen ɗe na̱m gwas gwe ba̱ wunda̱l gwas ni ɗa̱ sowu gwe tik ɗe Nya, ata̱ suk Abe wu ka̱ mbokini ang ten Nya. ");
INSERT INTO gyz_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ilgwe Yohana ma̱n Baptisma hwi mbala̱n ka̱ sa'i gwe ma̱n Yehuda jwe sa̱ni Wurshelima shin ma̱n Pa̱ris suk ma̱n Lawi ɗe ta̱s ngemti ɗe wok ɗe ti wo wukgu! ");
INSERT INTO gyz_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yek ba̱ ta̱ hwunda̱li so, ama yek ta̱ dla̱misi ten dii ɗe, <<Amik ɗe Almasihu so.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yek sa̱ ngemti ɗe, <<Kik ɗe wokko? Kik ɗe Iliya a?>> Yek ta̱ wule, <<Amik so.>> <<Kik ɗe Ma̱n Dla̱mti Ga̱ɓa ga̱ Nyami ya?>> Yek ta̱ ballisi ɗe, <<Wowo.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yek sa̱ po ngemti ɗa, yek sa̱ wuli ɗe, <<Kik ɗe wokko? Hwini ilgwe ma lak dla̱mi ma̱jwe shinni wu. Ɗe yek ka̱ mbe gaa gwa ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yek Yohana ballisi tet ka̱ lishti ga̱ Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya ɗe, <<Amik ɗe yal ga̱ ma̱lgwe na̱ma ten lakti icin ka̱ me ɗe, <La̱ka̱mi Bagaa tantu> wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yek ma̱n parisi jon jwe sa̱ shinsi wu ");
INSERT INTO gyz_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ngemti ɗe, <<Yek laki aka̱ pa̱li mbala̱n Baptisma ye, ɗe kik ɗe Almasihu so, sogo Iliya, sogo Ma̱n Dla̱mti Ga̱ɓa ga̱ Nyami sowu?>> ");
INSERT INTO gyz_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yek Yohana ballisi ɗe, <<Na̱ ze ka̱n a pa̱l Baptisma, ama ma̱lgon ni ɗa a nya ka̱ dlo gwaka̱n ma̱lgwe ba̱ ka̱a̱ yisti sowu. ");
INSERT INTO gyz_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tik ɗe ma̱lgwe ta tul ka̱ kaal gi wu, ma̱lgwe zaa kapta̱lan gwas mago a mbuki ta̱ pa̱tl dani sowu.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Mas wul jimi wo ka̱ ba̱n Betani ka̱n pi tu ten ka̱ti gon ga̱ dla̱lka Yodan, ka̱lu gwe Yohana na̱ma pa̱lti Baptisma wu. ");
INSERT INTO gyz_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Lu tlo wugo yek Yohana yen Yesu ata̱ nima la̱t tet tumalti yek ta̱ wuli ɗe, <<Ɓo yena̱n, Yen Bagalla ga̱ Nya, ma̱lgwe ta̱ kan byas wul ga̱ dii atl wu! ");
INSERT INTO gyz_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ga̱mi ka̱ɗe ma̱lgwe a dla̱m ɗe, <Ma̱lgon a tul ka̱ kaal gini, ma̱lgwe ta̱ nal mana̱n wu, ma̱lgwe ta̱ ni ɗa aba̱ sa̱ ɓo za̱n sowu.> ");
INSERT INTO gyz_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ami gaa gi mago a yisti so, ama ilgwe laki yek a tuli a nima Baptisma na̱ ze go yek ɗe ta̱ ma̱n Yisraila yisti.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yek Yohana ba̱l shaida ɗe, <<A yen Shishi sut nya na̱k yadli yek ta̱ sak nda tenti. ");
INSERT INTO gyz_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ami mago a yisti so, se na̱k ma̱lgwe shina̱n ɗe ta pa̱l Baptisma na̱ ze wu hwi ɗe, <Ma̱lgwe ka̱ yen Shishi yil sut nya yek sak nda tenti wu ka̱ɗe ma̱lgwe a pa̱li mbala̱n Baptisma na̱ Shishi ga̱ Nya wu.> ");
INSERT INTO gyz_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A yeni na̱ gwel gini yek a hwi mbala̱n ɗe ga̱n go Yen ga̱ Nya ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ten cin gwe kop kaali wu a Yohana suk ɗe lop ka̱ mil lishti jwas ni ka̱li, ");
INSERT INTO gyz_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ɗe Yohana yen Yesu ten la̱t tu ka̱li wugo, yek ta̱ wule <<Ɓo yeni ni, Yen Bagalla Nya ka̱ wu!>> ");
INSERT INTO gyz_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ɗe mil lishti ɗe loɓi kum ga̱ɓa ga̱ Yohana wugo, yek sa̱ kop kaal ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ɗe Yesu cel gwel kaali yek ta̱ yensi ten kopti gwas wugo, <<Yek ta̱ ngemsi ɗe yek ka̱a̱ lami ye?>> Yek sa̱ wulti ɗe, <<Rabbi>> (gwe yek ɗe ma̱n lishti wu), <<Ako ka̱n lu da̱nti gwa ni ko?>> ");
INSERT INTO gyz_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yek ta̱ ballisi ɗe, <<La̱n te, ta̱k yeni ni.>> Yek sa̱ lak yen lu gwe ta̱ nima da̱mti wu, yek sa̱ ndacin sukti ka̱li. A sa'i ɗe wupsi ga̱ ka̱ sukti ka̱ ɓali. ");
INSERT INTO gyz_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andarawus yilka ga̱ Siman Biturus ni ka̱ ma̱jwe sa̱ kop kaal ga̱ Yesu ɗe sa̱ kum ilgwe Yohana dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ilgwe Andarawus nda pa̱lti go yek ɗe, ta̱ ngo yilka gwas Siman yek ta̱ hwit ɗe, <<Ma̱ mbi Almasihusi wi>> (gwe yek ɗe Ma̱lgwe Nya Botli wu). ");
INSERT INTO gyz_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yek ta̱ tulla̱t mal Yesu. Yek Yesu yenti yek ta̱ wuli ɗe, <<Kik ɗe Siman yen ga̱ Yohana. Sa mbek ɗe Kepas>> (gwe yek ɗe Biturus wu). ");
INSERT INTO gyz_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ten cin gwe kop kaali wu, Yesu lam la̱t Galili. Yek ta̱ mbi Pilip, yek ta̱ wulti ɗe, <<Koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip wo ma̱n Betseda ka̱n, ba̱n gwasa̱n ɗe na̱m suk Andarawus suk Biturus. ");
INSERT INTO gyz_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip mbi Nataniyel yek ta̱ hwit ɗe, <<Ma̱ mbi ma̱lgwe sa̱ lish ga̱ɓa tenti ka̱ mba̱t ga̱ɓa ga̱ Musa, suk lishti ji ma̱n Dla̱mti Ga̱ɓa ga̱ Nya wu wi, tik ɗe Yesu ma̱n Nazarat, Yen ga̱ Yusupu.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Yek Nataniyel ballit ɗe, <<Nazarat we! Hal hwa ilgon a yil tet ka̱li nwa?>> Yek Pilip hwit ɗe <<Lite ta̱k ɓo yeni,>> ");
INSERT INTO gyz_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ɗe Yesu yen Nataniyel ten la̱t tet malti wugo, yek ta̱ wulti ɗe, <<Ma̱n Israila ga̱ gem ka̱ wu, ma̱lgwe lal ni ka̱ti sowu.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yek Nataniyel ngemti ɗe, <<Ɗa̱ni ka̱n ka̱ yisa̱n gwi?>> Yek Yesu ballit ɗe, <<A yenki aka̱ yi ga̱z tlindi tula̱n a ba̱ Pilip ɓo mbek so.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yek Nataniyel wul Yesu ɗe, <<Ma̱n lishti, kik ɗe Yen ga̱ Nya, kik ɗe Guu ga̱ ma̱n Yisraila.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yek Yesu hwit ɗe, <<Ka̱ ba̱l gem ten ɗe a hwik ɗe, a yenki a ga̱z tlindi tula̱n, ka yen kiɗi wul jwe ma̱n gwisi wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yek Yesu po wulsi ɗe, <<Gem amik ka hwikii ge kaa yen dlo nya ga̱ ɓuli, suk mil shinti ji Nya ten toti suk yilti ten Yen ga̱ Mbala̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ten multi ɗe mekan ka̱n sa̱ pa̱l biki hapti ka̱ ba̱n Kana ka̱ ka̱t atl ga̱ Galili. A ana ga̱ Yesu ni ka̱ lu biki haptisi, ");
INSERT INTO gyz_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","a Yesu suk mil lishti jwas mago sa̱ shinisi lu ɗe ta̱s li ka̱ lu biki haptisi pak. ");
INSERT INTO gyz_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ɗe ze inabi paki wugo, yek ana ga̱ Yesu sak hwi Yesu ɗe, <<Ze inabi pakisi ka̱ wi.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yek Yesu ballit ɗe, <<Gasa̱l, yek laki ɗe ka̱ li tet mala̱n ye? Ai sa'i gi ɓo pa̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yek ana ga̱ Yesu hwi ma̱n pa̱lti wul ka̱li ɗe, <<Pa̱la̱n mas ilgwe ta̱ hwikii ɗe ta̱k pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","A ka̱li wo kiɗi pyal ze ɗe mukka jwe sa̱ kin na̱ ye wu ni ɗa, jwe a kan tatze ɗe kutl ɗe lop sogo kutl ɗe mekan ga̱ ze wu. Na̱ ze ga̱ pyal ze jwisi ka̱n a ma̱n Yehuda pol da̱ska̱n gwasa̱n ka, na̱k kangwe sa̱ ku na̱ pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yek Yesu hwi ma̱n pa̱lti wul ka̱li ɗe, <<Njika̱ma̱n pyal ze jwisi na̱ ze>> yek sa̱ njika̱mi ka mas ceka̱l-ceka̱l. ");
INSERT INTO gyz_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Yek paa ta̱ hwisi ɗe, <<Laka̱n zesi ta̱k ta̱le bagaa ga̱ biki.>> Yek sa̱ pa̱l ilgwe ta̱ hwisi wu, ");
INSERT INTO gyz_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","bagaa ga̱ biki la̱mi go pal ɗe ze inabi wi. A ba̱ ta̱ yis tet ka̱ lu gwe ze inabisi yil tet wu so, ko ɗe ma̱n pa̱lti wuli wo sa̱ yisi wu. Yek pa ta̱ mbe yen kosi te malka̱mi ka ");
INSERT INTO gyz_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","yek ta̱ wulti ɗe, <<Ko wokko hwa ze inabi ka̱n asa̱ nda yilla̱ti ta̱ ma̱nda̱ki tla paa aka̱ kaali wo asa̱ tulli gwe ta̱m sowu, ama ki wo yek ka̱ zi hwa ze inabi ka se nin ma.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","A ga̱mi ka̱ɗe, wul cit ɓanti gwe Yesu nda pa̱lti ka̱ ba̱n Kana ka̱ ka̱t atl Galili wu. Yek ta̱ mbokisi ang ten nalti gwasi, yek mil lishti jwas ba̱l gem na̱ti. ");
INSERT INTO gyz_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ka̱ kaali wo yek Yesu li Kaparnahum suk ana gwasi suk yilkeni jwasi suk mil lishti jwasi. Yek sa̱ la̱m multi ka̱li. ");
INSERT INTO gyz_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ɗe sa'i motgaa ɗakciti ga̱ Ma̱n Yehuda ɓal njaa wu, yek Yesu to Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ka̱ dii boo lubii ga̱ Nya yek ta̱ mbi mbala̱n ka̱ ma̱n wulti tla ka, suk mba̱la suk kulu, suk ma̱n balla̱t wulpi na̱ zhila ten pa̱lti wul jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yek Yesu taka̱l tlemndi na̱ zaa, yek ta̱ mbolsi mas jwasa̱n ɗa̱ka̱ dii boo lubii ga̱ Nyami ka, na̱ mba̱le suk tlaɓi, yek ta̱ babbali tebul ji ma̱n balla̱t wulpi ka, yek ta̱ cat-cat wulpi jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yek ta̱ hwi ma̱n wulti kulu ɗe, <<Yilla̱nsi ɗa̱ ɗe ka! Ba̱k palla̱n lubii ga̱ Aba gi ɗe lu wulti wul ka̱ so!>> ");
INSERT INTO gyz_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yek mil lishti jwas daam lishti gwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <<Daka̱lti ten lubii gwa ka̱ mbadl gi nima kwel gi na̱k wutu.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yek ma̱n Yehuda ngemti ɗe, <<Yek ɗe wul cit ɓanti gwe ka pa̱li ten ɗe ta̱n yeni ama̱ yisi ɗe iko pa̱lti mas wul jimi nik ɗa̱ gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yek Yesu ballisi ɗe, <<Jeka̱n lubii ga̱ Nya ga̱n ka, ba kin lisi ka̱ multi ɗe mekan.>> ");
INSERT INTO gyz_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yek ma̱n Yehuda ballit ɗe, <<Ka̱ gini ɗe kutl ɗe wupsi na̱ mukka ka̱n sa̱ kin lubii ga̱ Nya ga̱n, ama ki wo ka̱ multi ɗe mekan ka̱n ka kin ma?>> ");
INSERT INTO gyz_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ama lubii ga̱ Nya gwe ta̱ na̱ma ga̱ɓa a dani go dli gwas ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kaal ɗa̱ palti gwas kaami ka̱n, yek mil lishti gwas daam ilgwe ta̱ dla̱m wu. Yek sa̱ ba̱l gem na̱ lishti ga̱ ga̱ɓa ga̱ Nya suk mas ilgwe Yesu dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","A Yesu ni Wurshelima ka̱ sa'i motgaa Daamti Ɗakcitisi, ɗe wonti mbala̱mi yen wul cit ɓanti gwe ta̱ na̱ma palti wugo yek sa̱ ba̱l gem na̱ shin gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ama yek ba̱ Yesu ba̱l gem na̱si so na̱k ɗe ta̱ yis mas mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Yesu lami ɗe ta̱ mbala̱n hwit wul ten ma̱lgon so, ten ɗe ta̱ yis mas ilgwe ni ka̱ mbadl ga̱ mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ma̱lgon ni ɗa shin gwas ka̱ɗe Nikodimus, ti wo ɗe na̱m ka̱n tet ka̱ motgaa ji bacina ga̱ ma̱n Yehuda jwe asa̱ mbesi ɗe Parisi wu. ");
INSERT INTO gyz_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ta̱ tul mal Yesu ka̱ gasi yek ta̱ wulti ɗe, <<Ma̱n lishti, ma̱ yisi ɗe ki wo ma̱n lishti ka̱n sut mal Nya. Ten ɗe ma̱lgon a man pa̱lti wul cit ɓanti jwe ka̱ na̱ma pa̱lti wu so, ɗe kume Nya ni sukti sowu.>> ");
INSERT INTO gyz_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yek Yesu ballit ɗe, <<Gem amik ka hwik ge, ba ma̱lgwe a yen Nya ɗe Guu wu seko sa̱ saka za̱t ga̱ ma̱li.>> ");
INSERT INTO gyz_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Yek Nikodimus ngemti ɗe, <<Ɗa̱ni ka̱n sa zi mbala̱n ata̱ koli wi gwi? Ma̱li a man palti te ka̱ tuk ga̱ ana gwas ka asa̱ saka za̱t gwas a?>> ");
INSERT INTO gyz_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yek yesu ballit ɗe, <<Gem amik ka hwik ge, ba ma̱lgwe a man tet ka̱ Nya ɗe Guu wu seko sa̱ pa̱lit za̱ti ga̱ ze suk ga̱ Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ilgwe a mbala̱n zi go mbala̱n ka̱n, ama ilgwe a Shishi ga̱ Nya zi go Shishi ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ba̱ ilgwe a dla̱m wu ɗe, <Ngetli ka̱n ta̱s saka za̱t gwa wu,> cik ɓanti so. ");
INSERT INTO gyz_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A yeta̱l ngusi nwuti lu a li ka̱ lu gwe lami wu. Aka̱ kum nwuti lu gwasi, ama ba̱ka yis tet ka̱ lu gwe yil tet wu sogo lu gwe na̱ma la̱t wu so. Nu ka̱n ni suk ma̱lgwe ɗe Shishi ga̱ Nya ka̱ za̱t wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yek Nikodimus ngemti ɗe, <<Ɗa̱ni ka̱n a pi nu gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yek Yesu wulti ɗe <<Ki ɗe ma̱n lishti ga̱ ma̱n Yisraila wu mago yek ba̱ka̱ yis gaa ji wul jimi sa? ");
INSERT INTO gyz_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gem amik ka hwik ge, ilgwe ma̱ yisi wu ka̱n ma̱ na̱ma ga̱ɓa dani, ma nikii ma hwit ga̱ɓa ten ilgwe ma̱ yeni wu, ama mas na̱ nu yek ka̱a̱ nge kanti ga̱ɓa ga̱na̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A nikii ma dla̱mti ga̱ɓa ten wul jwe ni dii atl wu yek ka̱a̱ nge ba̱lti gem. Ɗa̱ni ka̱n kaa ba̱l gem, ɗe a dla̱mikii ga̱ɓa ten wul jwe ni nya wu gwi? ");
INSERT INTO gyz_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma̱lgon ɓo taɓa tot nya so, seko ma̱lgwe yil sut nya wu a tik ɗe Yen ga̱ Mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na̱k gwe Musa tlil wuci zil ga̱lla nya ka̱ me wu, na̱k gwisi ka̱n ngetli ka̱n sa tlil Yen ga̱ Mbala̱n nya pak, ");
INSERT INTO gyz_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ten ɗe ta̱ mas ma̱lgwe nga̱sti tenti wu mbi mbadl ma̱n la̱shi pakti. ");
INSERT INTO gyz_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","<<Ten ɗe Nya lam dii atl i'e yek ta̱ ba̱l Yen ɗe na̱m gwe ba̱ wunda̱l gwas ni ɗa̱ sowu, ten ɗe ta̱ mas ma̱lgwe nga̱sti tenti go ba̱s lil ka̱ so ama ta̱s mbi mbadl ma̱n la̱shi pakti. ");
INSERT INTO gyz_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ten ɗe Nya shin Yen gwas sut ten dii atl ɗe ta̱s kissi ga̱ɓa mbala̱n ji dii atli so, ama ta̱ shinti sut ɗe ta̱ dii atli mbi kisti tumalti. ");
INSERT INTO gyz_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mas ma̱lgwe nga̱sti tenti ten Yen ga̱ Nya go sa nolti so. Ama mas ma̱lgwe nge nga̱sti tenti go sa̱ kisti ga̱ɓa wi, ten ɗe ta̱ nge nga̱sti ten shin ga̱ Yen ga̱ Nya ɗe na̱m gwe ba̱ wunda̱l gwas ni ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kangwe kisti ga̱ɓe ni wukgu, cilti tul ten dii atli, ama yek mbala̱n lam da̱mshal man cilti, ten ɗe pa̱lti wul jwasa̱n wo byasi ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mas ma̱lgwe ata̱ pa̱l byas wul go, ata̱ nge cilti a ba̱ta li tet mal cilti so ten ɗe cilti a lak ɓuli byas pa̱lti wul gwas gal ɗa̱ gaa ka. ");
INSERT INTO gyz_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ama mas ma̱lgwe ata̱ pa̱l gem go ata̱ li tet mal cilti, ten ɗe ta̱ mbala̱n yeni ten dii ɗe ilgwe ata̱ pa̱li go tumal za̱t ang ga̱ Nya ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kaal ɗa̱ na̱k gwisi yek Yesu suk mil lishti jwas li tu ka̱t atl ga̱ Yehudiya, ka̱li ka̱n ta̱ la̱m multi suksi, ata̱ nima pa̱lti Baptisma mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yohana mago ata̱ nima pa̱lti Baptisma a Ainon lu gwe ni njaa a Salim ten ɗe ze ni ɗa nal ka̱li. Yek mbala̱n ngusi tulti asa̱ nisi ma pa̱lti Baptisma. ");
INSERT INTO gyz_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Na̱k gwisi pi aba̱ sa̱ ɓo le Yohana ka ka̱ lu leti so.) ");
INSERT INTO gyz_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Yek mil lishti ji Yohana ngusi calti ga̱ɓa suk ma̱n Yehuda gon ten bi polti-polti jwe a ma̱n Yehuda pa̱li na̱k kangwe mba̱t ga̱ɓa ga̱ Musa ba̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yek sa̱ li mal Yohana yek sa̱ wulti ɗe, <<Ma̱n lishti, ma̱lgwe ka̱ni sukti tu ten ka̱ti gon ga̱ dla̱lka Yodan wu, ma̱lgwe ka̱ hwi mbala̱n ga̱ɓa tenti ki na̱ gaa wu, tik tek gu ta̱ na̱ma pa̱lti baptisma a mbala̱n wonti nima la̱t malti.>> ");
INSERT INTO gyz_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yek Yohana ballisi ɗe, <<Ma̱lgon a man mbit ilgon so seko ɗe kume sa̱ ba̱lti sut nya wu. ");
INSERT INTO gyz_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kii gaa gwaka̱n mago sheda ka̱n, ten ɗe ami na̱ gaa gi ka̱ dla̱mkii ɗe, <Amik ɗe Almasihu so ama sa̱ shina̱n ɗe ta tul a cina gwasi.> ");
INSERT INTO gyz_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ka̱ biki hapti wo amarya wo kili ga̱ yen kos ka̱n. Yela̱n ga̱ yen kosi wo ata̱ ɓa̱ti ɗe ta̱s kum yal ga̱ yen kosi. Ata̱ pa̱l hwol tuki ɗe kume ta̱ kum yen kosi ten ga̱ɓa wu. Na̱ nu ka̱n a hwol tuk gi njika̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngetli ka̱n ta̱s ngusi mba̱lti dli, a ami wo a ngusi hwulti ka. ");
INSERT INTO gyz_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","<<Ma̱lgwe yil sut nya go ta̱ man ko wokko, a ma̱lgwe ɗe tet dii atl ka̱n ta̱ni go ti wo ga̱ dii atl ka̱n, a ga̱ɓa gwas wo ten wul ji dii atli ka̱n. Ma̱lgwe yil sut nya go ta̱ man mas wul. ");
INSERT INTO gyz_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ta̱ na̱ma dla̱mti wul jwe ta̱ kumi yek ta̱ yeni wu, ama mas na̱ nu yek ba̱ ma̱lgon kan ilgwe ta̱ dla̱m wu so. ");
INSERT INTO gyz_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ama mas ma̱lgwe kan ilgwe ta̱ dla̱m wu go, ma̱li kan ɗe Nya wo ma̱n pa̱lti gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ten ɗe ma̱l gwisi ɗe Nya ka̱ shinti sut go ga̱ɓa ga̱ Nya ata̱ dla̱mi, na̱k ɗe Nya ba̱lti Shishi gwasi ba mba̱t wu. ");
INSERT INTO gyz_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Abe lam Yeni yek ta̱ zi mas wul a ang ɗatka. ");
INSERT INTO gyz_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mas ma̱lgwe ci cina na̱ ba̱lti gem na̱ Yeni go mbadl ma̱n la̱shi pakti nit ɗa. Ama mas ma̱lgwe nge Yeni go ta mbi mbadl so, ama lilti mbadl ga̱ Nya ni tenti.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yek ma̱n Parisi kum ga̱ɓa ɗe Yesu na̱ma mbit mil lishti wonti man Yohana, ata̱ nisi ma pa̱lti Baptisma. ");
INSERT INTO gyz_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ko ɗe Yesu na̱ gaa gwas ka̱ɗe ma̱n pa̱lti Baptisme so ama mil lishti jwas ka̱ɗe ma̱n pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ɗe Yesu kum ilgwe na̱ma pa̱t ɗu wugo, yek ta̱ zak ka̱t atl ga̱ Yehudiya yek ta̱ pal te ka̱ ka̱ti ga̱ Galili ka. ");
INSERT INTO gyz_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","A nit ngetli ɗe ta̱s koɓi tu ka̱ ka̱t atl Samariya. ");
INSERT INTO gyz_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yek ta̱ li ka̱ ba̱n gon ga̱ Samariya gwe asa̱ mbe ɗe Sekar, njaa mal lu gwe Yakubu ba̱l yen gwas Yusupu wu. ");
INSERT INTO gyz_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ka̱li ka̱n rijiya ga̱ Yakubu ni. Ɗe Yesu nak na̱ la̱t wugo yek ta̱ da̱n na̱ zhila ten bi rijiye. Na̱k gwisi pi go a dlocin ka̱ ɓali. ");
INSERT INTO gyz_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yek kili gon nga Samariya tuli mbot ze. Yek Yesu wulti ɗe, <<Nak ba̱la̱n ze ta tla ne!>> ");
INSERT INTO gyz_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Mil lishti jwas li ka̱ ba̱mi, ten ta̱s wul ilga̱ nguki teɗi.) ");
INSERT INTO gyz_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yek nga Samariye wulti ɗe, <<Ɗa̱ni ka̱n ki ma̱n Yehuda ama yek ka̱ nima ngemti ze ga̱ tle ami ɗe kili Samariya wu gwi?>> (Ten ɗe ma̱n Yehuda wo ba̱sa̱ mo suk ma̱n Samariya so.) ");
INSERT INTO gyz_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yek Yesu ballit ɗe, <<Da ka̱ yis ba̱lti wul ga̱ Nya suk ma̱lgwe ngemik ze go, ka ngemit ze ata̱ ba̱lki ze ma̱n ba̱lti mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yek kilisi hwi Yesu ɗe, <<Ma̱n nalti ai ba̱ guga niki ɗa̱so a yekgu rijiye wo dlunti ka̱n ni. A ako ka̱n ka mbi ze ma̱n ba̱lti mbadl gwisi ko? ");
INSERT INTO gyz_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ka̱ mana̱n ma̱n za̱t ga̱na̱n Yakubu ɗe ta̱ ba̱lni rijiye, a ti gaa gwas mago ta̱ tla zesi, suk mil jwasi suk tunga dabbobi jwasa̱n ɗe sa̱ tla tet ka̱ rijiye nwa?>> ");
INSERT INTO gyz_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yek Yesu ballit ɗe, <<Mas ma̱lgwe tla ze ge go ka̱lka̱ze a ya tloti, ");
INSERT INTO gyz_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ama mas ma̱lgwe tla ze gwe ba ba̱lti go ka̱lka̱ze a po saka tlot gwas so. Zesi a da̱m ɗe gwel ze gwe a ngusi telti ze ka̱ ma̱li wu, hal a ta̱lat ka̱ mbadl ma̱n la̱shi pakti.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yek kilisi wulti ɗe, <<Ma̱n nalti, ba̱la̱n ze gwisi kangwe ɗe ka̱lka̱ze a po tlo so, aba̱ ba po ngusi tulti aɗe ɗe ta mbo ze sowu.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yek Yesu hwit ɗe, <<Lak mbe kos gwa teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yek kilisi wulti ɗe, <<Kos ni ɗa̱ so.>> Yek Yesu hwit ɗe, <<Gem ka̱n ka̱ dla̱mi ɗe ka̱ wule kos nik ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ten ɗe ka̱ hap maani ɗe namtan wi, a ma̱lgwe ka̱ nima da̱mti sukti na̱k ninge go kos gwa ka̱ so. Ilgwe ka̱ dla̱m go gem ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yek kilisi ballit ɗe, <<Ma̱n nalti, aɓa yeni go ki wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ma̱n za̱t jina̱n ngusi Nya atl ten bal tla̱nda̱l ga̱n. Ama kii ma̱n Yehuda wo, ka̱a̱ dla̱m ɗe Wurshelima ka̱ɗe lu gwe mbun ɗe ta̱n ngusi atl Nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yek Yesu ballit ɗe, <<Kili mbala̱n ba̱l gem na̱ ilgwe a na̱ma dla̱mti wu, ten ɗe sa'i a tuli gwe ɗe ba̱ mbala̱n a ngusi Aba atl ten bal tla̱nda̱l ga̱n sogo a Wurshelima so. ");
INSERT INTO gyz_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kii ma̱n Samariya wo aka̱a̱ ngusi atl ilgwe ɗe ba̱ka̱a̱ yisi sowu. Ama mi ma̱n Yehuda wo ama̱ ngusi atl ilgwe ma̱ yisi wu, ten ɗe kisti wo tet ka̱ ma̱n Yehuda ka̱n tuli. ");
INSERT INTO gyz_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ama sa'i a tuli na̱k ninge mago pi wi sa'i gwe ɗe ma̱n ngusti atl ga̱ gem a ngusi Aba atl ka̱ Shishi suk gem wu, ten ɗe wunda̱l ji mbala̱n jwisi ka̱n Aba na̱ma ngot gwasa̱n ɗe ta̱s ngusit atli. ");
INSERT INTO gyz_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nya wo Shishi ka̱n, a ma̱jwe sa ngusit atl go ngetli ka̱n ta̱s ngusit atl ka̱ Shishi suk gem.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yek kilisi wulti ɗe, <<A yisi ɗe Almasihu>> (ma̱lgwe asa̱ mbet ɗe Kiristi wu), <<a tuli. Kume ɗe ta̱ tul wugo, ta̱ yillini gaa ga̱ mas wul ten dii.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yek Yesu ballit ɗe, <<Ami ɗe a nima ga̱ɓa sukki wu, Amik ɗe ti.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Sa̱ na̱ma pakti ga̱ɓa nugo yek mil lishti jwas pal teɗi, yek sa̱ ngip bi ang ten ɗe sa̱ mbit ten ga̱ɓa suk kili mbala̱n. Ama yek ba̱ ma̱lgon ngem kilisi ɗe, <<Yek ka̱ lami ye?>> Aba̱ ma̱lgon ngem Yesu ɗe <<Yek laki ɗe ka̱ na̱ma ga̱ɓa sukti ye?>> so. ");
INSERT INTO gyz_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yek kilisi zak tatze gwas ka̱li, yek ta̱ pal te ka̱ ba̱n ka yek ta̱ wul mbala̱n ɗe, ");
INSERT INTO gyz_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<La̱n teɗi, ta̱k yena̱n ma̱lgwe dla̱mi mas ilgwe a pa̱li wu. Ko gon a tik ɗe Almasihu?>> ");
INSERT INTO gyz_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yek mbala̱mi ngusi yilti tet ka̱ ba̱mi yek sa̱ li tet ka̱ lu gwe Yesu ni wu. ");
INSERT INTO gyz_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A il gwisi na̱m pa̱t nugo yek mil lishti jwas ngemti ɗe, <<Ma̱n lishti nguk ilga̱ nguki ne.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ama yek Yesu wulsi ɗe, <<Ilga̱ nguki ni ɗa gwe ɗe ba̱ka̱a̱ yis ilgon a dani sowu.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yek mil lishti jwas ngusi ngemti ji yilkeni jwasa̱n ɗe, <<Ko na̱kka̱n ma̱lgon tullit ilga̱ nguki na̱?>> ");
INSERT INTO gyz_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ama yek Yesu wulsi ɗe, <<Ilga̱ nguki gi ka̱ɗe, ta pa̱l ilgwe ma̱lgwe shina̱n wu lami a pak pa̱lti ilgwe ta̱ zi wu. ");
INSERT INTO gyz_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ale ka̱a̱ na̱mma dla̱mti ɗe <lip ɗe wupsi ka̱ ɓali a paa ka̱a̱ nda wotlti zhin na̱?> Ama amik ka hwikii ge, ɓo ɓula̱n gwel ta̱k yena̱n zhin i'e, zhin jwaka̱n no paki wi, ningo wotlti ka̱ ɓali. ");
INSERT INTO gyz_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na̱k gwisi ka̱n a ma̱n wotlti zhimi mbi ɓatlti gwasi, ata̱ moo wul zhimi ata̱ ta̱le ka̱ mbadl ma̱n la̱shi pakti, ten ɗe ta̱ ma̱n ɓakti zhin suk ma̱n wotlti zhin pa̱l hwol tuk mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Aduk go cinga̱lti ga̱ɓa gwe asa̱ wule <Ma̱lgon ka̱ ɓak zhin, yek ma̱lgon wotl zhimi,> wu da̱m ɗe gem wi. ");
INSERT INTO gyz_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A shinki ta̱k wotla̱n zhin gwe ɗe ba̱ kik tla bomti kolti sowu. Ma̱jon ka̱ tla bomti ten kolti, yek kii wo yek ka̱a̱ mbi ɓatlti tlat bomti gwasa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma̱n Samariya wonti ji tet ka̱ ba̱n gwisi ba̱l gem na̱ Yesu ten bi ga̱ ilgwe kilisi dla̱m wu ɗe, <<Ta dla̱mi mas ilgwe a pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ɗe ma̱n Samariya tul mal Yesu wugo, yek sa̱ ngemti ɗe ta̱s da̱m suksi, yek ta̱ da̱m suksi ga̱ multi ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ten bi ga̱ ilgwe Yesu dla̱m wu, yek mbala̱n wonti ba̱l gem na̱ti. ");
INSERT INTO gyz_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Yek ma̱n Samariya wul kilisi ɗe, <<Ningo ma̱ ba̱l gem ba̱ ɗe we ten bi ga̱ ilgwe ka̱ dla̱mini wu tokte ka̱ so, ama ten ɗe mi mago ma̱ kumi na̱ ka̱ng ga̱na̱n, a ma̱ yisi wi ɗe gem ka̱n, ma̱lga̱n ka̱ɗe Ma̱n Kisti ga̱ dii atli.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kaal ɗa̱ multi ɗe loɓi wo, yek Yesu zak ka̱t ga̱ Samariya yek ta̱ li ka̱t atl ga̱ Galili. ");
INSERT INTO gyz_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(A Yesu na̱ gaa gwas taɓa dla̱mti ga̱ɓa gon ɗe, a ba̱sa ba̱l nalti ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ ba̱n gwas so.) ");
INSERT INTO gyz_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ɗe ta̱ mbuki ka̱ ka̱t atl ga̱ Galili wu, yek ma̱n Galili kanti na̱ ang ɗe lop. Ten ɗe sa̱ yen ilgwe Yesu pa̱li ka̱ Biki Daamti Ɗakciti a Wurshelima na̱k si mago sa̱ la biki wu. ");
INSERT INTO gyz_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yek ta̱ po pal te ka̱ ba̱n Kana ga̱ ka̱t atl ga̱ Galili ka̱ ɗa, ka̱ lu gwe ta̱ palli ze ɗe ze inabi wu. A ka̱li ka̱n bacina ga̱ ma̱n pa̱lti wul ga̱ gobnati ga̱ Roma, ma̱lgwe cwo na̱ma cit ga̱ yen gwas a Kaparnahum wu ni. ");
INSERT INTO gyz_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɗe ma̱lgwisi kumi ɗe Yesu na̱ma palti Galili tet Yehudiya wugo yek ta̱ li malti, yek ta̱ ngemti ɗe ta̱s lak ndok yen gwas ɗe ta̱ ɓal ten bi ma̱shka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yek Yesu ballit ɗe, <<Kume hal ka̱a̱ yen wul jwe sa̱ ba̱l sheda suk wul ngipti bi ang sogo kaa ba̱l gem so ko njet.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Yek bacina ga̱ ma̱n pa̱lti wuli ngemti ɗe, <<Ma̱n nalti, teɗi ta̱n li ne yen gi a lak ma̱shi.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yek Yesu ballit ɗe, <<Zigaa ilgon gwa, ten ɗe yen gwa asa kaami.>> Yek ma̱li ba̱l gem na̱ ga̱ɓa ga̱ Yesu yek ta̱ zigaa ilgon gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A ma̱li yi ten tantu la̱t lubii nugo, yek zhel jwas mo sukti yek sa̱ hwit ɗe yen gwas ndoki wi. ");
INSERT INTO gyz_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yek ta̱ kum ga̱z ga̱ dap sa'i gwe cwoɓi ndoki wu, yek sa̱ hwit ɗe, <<Cwoɓi zakti a hwuli ka̱ sa'i ɗe na̱m ga̱ cin.>> ");
INSERT INTO gyz_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yek Aba ga̱ yeni yis gaami ɗe ka̱ sa'i gwisisi ka̱n Yesu wulti ɗe, <<Zigaa ten ɗe yen gwa a da̱m asa kaami wu.>> Ten na̱k gwisi ka̱n yek ma̱li suk mas ma̱n lubii jwas ba̱l gem. ");
INSERT INTO gyz_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ga̱mi ka̱ɗe wul sheda gwe da̱m ɗe wul ngipti ang bi na ɗe lop gwe Yesu pa̱li kaal ɗa̱ zakti Yehudiya gwas ɗe ta̱ pal tet Galili wu. ");
INSERT INTO gyz_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kaal ɗa̱ na̱k gwisi, yek Yesu li Wurshelima ten bi biki ga̱ ma̱n Yehuda. ");
INSERT INTO gyz_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","A a Wurshelime njaa mal Bi Dlabii Mba̱la, bingi ze gon ni ɗa gwe sa̱ ganda̱li ka na̱ rumpa ɗe namtan wu. Na̱ bi Arameya wo yek ɗe Betasda. ");
INSERT INTO gyz_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ka̱ rumpa jwisi ka̱n a wonti ma̱n cwo suk dwa, suk kulki, suk ma̱jwe dli tlesi ka̱wu da̱mi. ");
INSERT INTO gyz_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ka̱ sa'i gon wo a yen shinti ga̱ Nya yil sut nya ata̱ sak nwu zesi. Mas ma̱lgwe te ka̱ zesi cina go ata̱ mbi ndokti. ");
INSERT INTO gyz_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","A ma̱lgon ni ɗa ka̱li ma̱lgwe ta̱ pa̱l gin ɗe kutl ɗe mekan na̱ wusupsi na̱ cwo wu. ");
INSERT INTO gyz_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ɗe Yesu yen ma̱li a atl wu, yek ta̱ yisi ɗe ta̱ daɗe na̱ cwo gwisi wi, yek ta̱ ngemti ɗe, <<Ka̱ lami ɗe ta̱ ndokki nwa?>> ");
INSERT INTO gyz_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yek ma̱li ballit ɗe <<Ma̱n nalti, na̱k ka̱n ma̱lgwe a zi ang ta mbi tet ka̱ zesi ka̱ sa'i gwe sa̱ nwuni wu ka̱ni ɗa̱so. Ɗe aɓa dloka̱ma̱n ɗe ta te giɓi go a ma̱lgon teni,>> ");
INSERT INTO gyz_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yek Yesu wulti ɗe, <<Tlinya ta̱k kan lumulti gwa, aka̱ zigaa ilgon gwa.>> ");
INSERT INTO gyz_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ka̱li ka̱li yek ma̱li ndoki, yek ta̱ ka̱n lumulti gwasi yek ta̱ zigaa ilgon gwasi. Ilga̱mi pi go, ten Cin Shukti ga̱ ma̱n Yehuda ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ten na̱k gwisi ka̱n, yek ma̱n Yehuda wul ma̱lgwe Yesu ndokti wu ɗe, <<Ase go Cin Shukti ka̱n, a ka̱ mba̱t ga̱ɓa ga̱ Musa wo mbun ɗe ta̱k kan lumulti gwa so.>> ");
INSERT INTO gyz_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ama yek ma̱li ballisi ɗe, <<Ma̱lgwe ndoka̱n wu wula̱n ɗe, <Kan lumulti gwa ta̱k zigaa ilgon gwa.> >> ");
INSERT INTO gyz_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ten na̱k gwisi ka̱n yek sa̱ ngemti ɗe, <<Wok ɗe ma̱lgwe wulki ɗe ta̱k kan lumulti gwa ta̱k zigaa ilgon gwa wo?>> ");
INSERT INTO gyz_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma̱lgwe sa̱ ndoktisi go ta̱ yis ma̱lgwe ndokti wu so pamma, ten ɗe Yesu gilit ka̱ wi te ka̱ wonti mbala̱n jwe sa̱ni ka̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ka̱ kaali wo yek Yesu mbit ka̱ lubii ga̱ Nya yek ta̱ wulti ɗe, <<Ɓo yeni ningo ka̱ ndoki wi! Se ta̱k zak pa̱lti byas wul, sogo ilgwe lil man ge wu a mbiki.>> ");
INSERT INTO gyz_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yek ma̱li zigaa yek ta̱ hwi bacina ji ma̱n Yehuda ɗe Yesu ka̱ɗe ma̱lgwe ndokti wu. ");
INSERT INTO gyz_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ten na̱k gwisi ka̱n yek ma̱n Yehuda nde cit dlelngapcan Yesu ten ɗe ata̱ pal wunda̱l ji wul jimi ten Cin Shukti. ");
INSERT INTO gyz_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yek Yesu hwisi ɗe, <<Aba gi na̱ma pa̱lti wul hal ase, a ami mago a na̱ma pa̱lti wul pak.>> ");
INSERT INTO gyz_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ga̱ɓa ga̱mi ɗe ta̱ dla̱m wu ka̱ laki yek ma̱n Yehuda mba̱l ngwot tantu tlot gwas ɗa. Ba̱ ɗe we ten bi pa̱l wul ten Cin Shukti tokte ka̱ so, ai yekgu ta̱ mbe Nya ɗe Aba gwas wi, ta̱ na̱ma palla̱t gaa gwas ndakce suk Nya. ");
INSERT INTO gyz_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yek Yesu ballisi ɗe, <<Gem amik ka hwikii ge, Yeni man pa̱lti ilgon na̱ ngus so, ilgwe ta̱ yen Aba gwas ten pa̱lti wu ka̱n ata̱ pa̱li, ten ɗe mas ilgwe a Abe pa̱li go yek ka̱n a Yeni pa̱li pak. ");
INSERT INTO gyz_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ten ɗe Abe lam Yeni yek ta̱ mbokit ang ten mas ilgwe ata̱ pa̱li wu. Yi, ta mbokit ang ten wul jwe sa̱ kiɗi man jin wu, kangwe kaa ngip bi ang ɗa̱ wu. ");
INSERT INTO gyz_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ten ɗe na̱k kangwe a Abe tlil ma̱jwe ma̱shi ata̱ ba̱lsi mbadl wu, nu ka̱n a Yeni ba̱l mbadl ma̱jwe ta̱mit ɗa̱ wu ");
INSERT INTO gyz_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Abe wo ba̱ta kisi ga̱ɓa ma̱lgon so, ama ta̱ zak mas kisti ga̱ɓa ka̱ ang ga̱ Yeni, ");
INSERT INTO gyz_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ten ɗe ta̱ mas mbala̱n ba̱l Yeni nalti na̱k kangwe asa̱ ba̱l Abe nalti wu. Ma̱lgwe ba̱l Yeni nalti sogo ma̱li ba̱l Abe ɗe ta̱ shinti sut wu nalti so pak. ");
INSERT INTO gyz_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<Gem amik ka hwikii wu, mas ma̱lgwe kum ga̱ɓa gini yek ta̱ ba̱l gem na̱ ma̱lgwe shina̱n sut go, ta̱ mbi mbadl ma̱n la̱shi pakti wi, a ba̱ Nya a nolti so ta̱ mbi kisti tet ka̱ ma̱shka̱n wi, yek ta̱ mbi mbadli. ");
INSERT INTO gyz_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Gem amik ka hwikii wu, sa'i a tuli na̱k ninge mago pi wi, gwe ɗe ma̱jwe ma̱sh wu a kum yal ga̱ Yen ga̱ Nya a ma̱jwe kumi go sa pal kaami. ");
INSERT INTO gyz_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na̱k kangwe Abe na̱ gaa gwas ka̱ɗe ma̱n ba̱lti mbadl wu, nu ka̱n ta̱ laki yek Yeni da̱m ɗe ma̱n ba̱lti mbadl pak. ");
INSERT INTO gyz_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yek ta̱ ba̱lti iko kisti ga̱ɓa ten ɗe tik ɗe Yen ga̱ Mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","<<Ba̱ ga̱ɓa ga̱n ɗe a dla̱m wu da̱mikii ɗe wul ngipti bi ang so, ten ɗe sa'i a tuli gwe ɗe mas ma̱jwe ni ka̱ gazukɗi wu a kum yal gwasi ");
INSERT INTO gyz_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","asa̱ yil toɗi. Ma̱jwe sa̱ pa̱l hwa wul go sa pal kaami, asa̱ mbi mbadl ma̱n la̱shi pakti, a ma̱jwe pa̱l byas wul go sa tlilsi asa̱ te ka̱ nolti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","A ba̱ a man pa̱l ilgon na̱ ngwe so, a pa̱l kisti ga̱ɓa gi kangwe Nya hwi ɗe ta pa̱li wu, ten na̱k gwisi ka̱n kisti ga̱ɓa gi wo gem ka̱n. Ten ɗe ilgwe a lami wu ka̱n a pa̱li so, ama ilgwe ma̱lgwe shina̱n wu lami ka̱n a pa̱li. ");
INSERT INTO gyz_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<Kume ɗe a ba̱l sheda ten gaa gi go sheda gwe a ba̱li go ga̱ gem ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ama ma̱lgon na̱ma ba̱lti sheda tena̱nni, a a yisi ɗe sheda gwe ata̱ ba̱li tena̱n go gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","<<Ka̱a̱ shin mbala̱n mal Yohana yek ta̱ hwikii gemi. ");
INSERT INTO gyz_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mas na̱ na̱k gwisi a nga̱sa̱n ten ilgwe a mbala̱n dla̱m wu so. Ama a hwikii na̱k gwisi ka̱n ten ɗe ta̱k mbi kisti. ");
INSERT INTO gyz_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana wo pitilla gwe wutu na̱ma tlot giɓi wu ka̱n, yek ka̱a̱ pa̱l hwol tuk na̱ cilti gwas ga̱ nak njet sa'i gon. ");
INSERT INTO gyz_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","<<Ama sheda gwe ni ɗa ten gaa gi go, man ga̱ɓa gwe Yohana ba̱li tena̱n wu. Ten ɗe wul jin ɗe a na̱ma pa̱lti go Abe ka̱ ba̱la̱n ɗe ta pa̱li, a wul jimi ɗe a na̱ma pa̱lti wu ka̱ na̱ma mbok ang ɗe Abe ka̱ shina̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Abe ɗe ta̱ shina̱n wu, ti na̱ gaa gwas ka̱ɗe sheda gini. Ka̱a̱ ɓo taɓa kumti yal gwas so, a ba̱ka̱a̱ ɓo taɓa yenti kangwe ta̱ ni wu so, ");
INSERT INTO gyz_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","a ba̱ ga̱ɓa gwas ni ka̱ mbadl gwaka̱n so, na̱k ɗe ba̱ka̱a̱ ba̱l gem na̱ ma̱lgwe Abe shinti sut wu sowu. ");
INSERT INTO gyz_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","A ka̱a̱ ngusi bodla̱lti ga̱ɓa ga̱ Nya i'e, ten ɗe ka̱a̱ ɓa yeni kaa mbi mbadl ma̱n la̱shi pakti a giɓi. A ga̱ɓa ga̱ Nya gwisi ka̱ na̱ma ba̱lti sheda tena̱nni, ");
INSERT INTO gyz_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ama mas na̱ na̱k gwisi ka̱n yek ka̱a̱ nge la̱t tet mala̱nni ta̱k mbi mbadli. ");
INSERT INTO gyz_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<Ami wo ta̱sti ga̱ mbala̱n dika̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ten ɗe a yiskii, a yisi ɗe lamti ga̱ Nya ni ka̱ mbadl jwaka̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A tul na̱ shin ga̱ Aba gini, yek ka̱a̱ nge kanti gini, ama kume ma̱lgon tul na̱ shin ga̱ gaa gwas go, kaa kanti. ");
INSERT INTO gyz_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ɗa̱ni ka̱n kaa ba̱l gem gwi, ɗe aka̱a̱ ngusi ngot ta̱sti ka̱ dlo jwaka̱n ama ba̱kaa ngo ta̱sti gwe a yil sut mal Nya ti ɗe ti na̱ ngus ka̱n ta̱ ni wu so gwi? ");
INSERT INTO gyz_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","<<Ba̱k da̱ma̱n gwa we amik ka ta̱la ga̱ɓa gwaka̱n mal Aba so. Ma̱lgwe a ta̱la ga̱ɓa gwaka̱n wu ka̱ɗe Musa, ti ɗe ka̱a̱ na̱ma za̱t mbadl ɗe ta zikii ang wu. ");
INSERT INTO gyz_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ɗe da kume ka̱a̱ ba̱l gem na̱ Musa go, da kaa ba̱l gem na̱ ami, ten ɗe Musa pa̱l lishti ten bi gini ka̱ lishti gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ama na̱k ɗe ka̱a̱ ba̱l gem na̱ ilgwe ta̱ lishi wu sowu, ɗa̱ni ka̱n kaa ba̱l gem na̱ ilgwe a dla̱m wu gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ka̱ kaal ɗa̱ na̱k gwisi wo yek Yesu ɗakci bal ze ga̱ Galili (gwe yek ɗe bal ze ga̱ Tibariya wu) ");
INSERT INTO gyz_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","yek wonti mbala̱n kopti, ten ɗe sa̱ yen lal wul ngipti ang bi gwe ta̱ pa̱li ma̱jwe cwo na̱ma cit jwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yek Yesu to ten za̱nda̱l yek ta̱ da̱n ka̱li suk mil lishti jwasi. ");
INSERT INTO gyz_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A sa'i Biki Ɗakciti ga̱ ma̱n Yehuda ɓal njaa. ");
INSERT INTO gyz_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ɗe Yesu tlil gaa nya yek ta̱ yen wonti mbala̱n ten tot malti wugo, yek ta̱ wul Pilip ɗe, <<A ko ka̱n ma wul ilga̱ nguki gwe ɗe mbala̱n jin a nguki a kumsi wu tet ko?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu gem Pilip ka̱n ten ta̱s ɓo cinga̱lti, na̱k ɗe ta̱ yis ilgwe ta pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Yek Pilip ballit ɗe, <<Ai ko ta̱ wulpi ga̱ lip ɗe wusupsi gwe asa̱ ɓatl mbala̱n ɗa̱ wu mago, a mbuk wulti ilga̱ nguki gwe mas mbala̱n jimi a mbi ta̱s la̱mi njet wu so!>> ");
INSERT INTO gyz_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yek gon ka̱ mil lishti jwasi, ma̱lgwe shin gwas ka̱ɗe Andarawus yilka ga̱ Siman Biturus wu, wul Yesu ɗe, ");
INSERT INTO gyz_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Yen gon ka̱wu aɗe na̱ na̱k mil ba̱redi ɗe na̱mtan suk mil kwes ɗe lop, ama yek a pa̱li wonti mbala̱n jimi ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yek Yesu wul mil lishti jwas ɗe, <<Hwi mbala̱mi ta̱s da̱m atli.>> A me ni ɗa wonti ka̱li, yek mbala̱mi da̱m atli, wonta̱t gwasa̱n la maani zangu ɗe na̱mtan. ");
INSERT INTO gyz_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yek Yesu kan ba̱redisi, yek ta̱ pi godiya Nya, yek ta̱ hwuk-hwuli mbala̱mi ɗe sa̱ni atl na̱ zhila ka̱li wu, yek mas jwasa̱n mbi kangwe a kumsi wu. Na̱k gwisi ka̱n ta̱ pa̱li na̱ kwesi pak. ");
INSERT INTO gyz_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ɗe sa̱ nguki yek kumsi wugo, yek ta̱ wul mil lishti jwas ɗe, <<Mo losa̱li jwe sa wu. Ten ɗe ba̱ ilgon lil ka̱ so ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ten na̱k gwisi ka̱n, yek sa̱ mo losa̱l ba̱redi jwe sa wu, yek sa̱ njika̱n ga̱ɗa ɗe kutl cet ɗe lop na̱ losa̱l ba̱redi ji guda̱l ba̱redi ɗe namtan gwe sa̱ pa̱li na̱ bale gwe ɗe sa ɗe mbala̱mi nguk wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ɗe mbala̱mi yen wul ngipti ang bi gwe Yesu pa̱li wugo, yek sa̱ wuli ɗe, <<Gem ma̱lga̱n ka̱ɗe ma̱n dla̱mti ga̱ɓa ga̱ Nya gwe ta tul ten dii atl wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ɗe Yesu yis gaami ɗe mbala̱mi na̱ma lamti ta̱s palla̱t ɗe guu na̱ nda̱lti wugo, yek ta̱ pal to ten tla̱nda̱li ka ti na̱ ngusi. ");
INSERT INTO gyz_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ɗe sukti pi wugo, yek mil lishti yil sut ɗa̱ka̱ tla̱nda̱li ka yek sa̱ su ten bi bal ze, ");
INSERT INTO gyz_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ka̱ sa'i gwisi wo a da̱mshal ɓa pi, a ba̱ Yesu ɓo tul malsi so. Yek mil lishti jwas te ka̱ jirgi ze, yek sa̱ njel za̱tgaa yek sa̱ lak gaa tu ka̱ ba̱n Kaparnahum. ");
INSERT INTO gyz_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Yek bal zesi njel kuzhilti ka i'e, ten bi ga̱ bal yeta̱l gwe na̱ma wulti wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɗe sa̱ pa̱l mil ɗe mekan sogo mil ɗe mekan na̱ tatlti dlo asa̱ na̱ma za̱t gaa wugo, yek sa̱ yen Yesu ten la̱t na̱ asa̱n ten gaa zesi, a ta̱ na̱ma la̱t tet njaa mal jirgi. Yek ɓanti njel cit ji mil lishtisi. ");
INSERT INTO gyz_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ama yek ta̱ wulsi ɗe, <<Ami ka̱n, ba̱ ɓanti cikii so.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yek paa sa̱ nda lamti ɗe ta̱s kan Yesu ka̱ jirgi zesi, yek jirgi mbuki ten bicikɗi gwe sa̱ li wu ba̱le-ba̱le. ");
INSERT INTO gyz_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ɗe lu tlo wugo yek wonti mbala̱n jwe sa̱ni ten bi cikɗi gwe ni tu te duk ɗa̱ bal zesi wu, lak yis gaami ɗe jirgi ze ɗe na̱m ka̱ tul ka̱li, yek sa̱ daami ɗe Yesu te ka̱ jirgisi suk mil lishti jwas so, ama mil lishtisi na̱ ngusa̱n ka̱ sa̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yek jirgi ze jon tet Tibariya tul njaa ka̱ lu gwe mbala̱mi nguk ba̱redi gwe Bagaa pi godiya a dani wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ɗe wonti mbala̱mi yisi ɗe Yesu suk mil lishti jwas ni ka̱li sowu, yek sa̱ te ka̱ jirgi ze jwisi yek sa̱ li Kaparnahum ten ngot ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɗe sa̱ mbit ten ka̱ti gon ga̱ bal zesi wugo, yek sa̱ ngemti ɗe, <<Ma̱n lishti, a gasi ka̱n ka̱ li tet ɗe gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yek Yesu ballisi ɗe, <<Gem amik ka hwikii wu, ilgwe laki yek ka̱a̱ na̱ma ngot gi go ten ɗe ka̱a̱ nguk ba̱redi yek kumkii ka̱n, ama ba̱ ɗe we na̱kka̱n ka̱a̱ yis gaa ga̱ wul ngipti ang bi gwe a pa̱li wu ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ba̱k tla bomti ten bi ilga̱ nguki gwe a lil ka̱wu so, ama ngo ilga̱ nguki gwe ba̱ a lil ka̱ sowu, ilga̱ nguki gwe a ta̱lakii ten mbit mbadl ma̱n la̱shi pakti wu. Gwisi ka̱ɗe wunda̱l ga̱ ilga̱ nguki gwe Yen ga̱ Mbala̱n a ba̱lkii wu. Ten ɗe Nya Aba ɓo sheda gwas ten Almasihu yek ta̱ zi lali ɗe ta̱ yedde na̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yek sa̱ ngemti ɗe, <<Ɗa̱ni ka̱n ma pi ama̱ pa̱l wul jwe Nya lami ɗe ta̱n pa̱li wu ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yek Yesu ballisi ɗe, <<Ilgwe Nya lami go, yek ɗe ta̱k ba̱la̱n gem na̱ ma̱lgwe ta̱ shinti sut wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yek sa̱ po ngemti ɗe, <<Wul ngipti ang bi gwi ka̱n ka pa̱li a ma̱ yeni ta̱n ba̱l gem na̱ ki gwi? Yek ka pa̱li ye? ");
INSERT INTO gyz_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ma̱n za̱t jina̱n nguk manna ka̱ me, na̱k gwe ni ga̱ lishi wu ɗe, <Ta̱ ba̱lsi ilga̱ nguki sut nya ɗe ta̱s nguki.> >> ");
INSERT INTO gyz_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yek Yesu wulsi ɗe, <<Gem amik ka hwikii wu, Musa ka̱ ba̱lkii ilga̱ nguki sut nya so, ama Aba gi ka̱ ba̱lkii ilga̱ nguki ga̱ gem sut nya. ");
INSERT INTO gyz_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ten ɗe ilga̱ nguki ga̱ Nya ka̱ɗe ma̱lgwe yil sut nya, ata̱ nima ba̱lti mbala̱n ji dii atl mbadli wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yek sa̱ ballit ɗe, <<Ma̱n nalti ningo ngusini balti ilga̱ nguki gwisi ko a gasi.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yek Yesu dla̱m ɗe, <<Amik ɗe ilga̱ nguki gwe a ba̱l mbadl wu. Ma̱lgwe li tet mala̱n go kuza̱n a po tlot so, a ma̱lgwe ba̱l gem na̱ ami go ka̱lka̱ze a tlot so ko njet. ");
INSERT INTO gyz_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ama na̱k kangwe a hwikii wu, ka̱a̱ yena̱n wi mas na̱ na̱k gwisi yek ba̱ka̱a̱ ba̱l gem so. ");
INSERT INTO gyz_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mas ma̱jwe Aba gi ba̱la̱nsi go sa li tet mala̱nni, a ma̱lgwe li tet mala̱n go ba mbolti so. ");
INSERT INTO gyz_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","A yil sut nya ɗe ta pa̱l ilgwe a lami wu so, ama ten ɗe ta pa̱l ilgwe ma̱lgwe shina̱n wu lami wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","A ilgwe ma̱lgwe shina̱n wu lami go, yek ɗe ba̱ ko ta̱ ɗe na̱m ka̱ ma̱jwe ta̱ ba̱la̱nsi wu gil ka̱ so, ama ba tlilsi ten cin pakti ga̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ten ɗe lamti ga̱ Aba gi ka̱ɗe, mas ma̱lgwe na̱ma yenti ga̱ Yeni ata̱ na̱ma ba̱lti gem na̱ti wu, ta̱ mbi mbadl ma̱n la̱shi pakti wi, a ba tlilti ten cin pakti ga̱ dii atli.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ten na̱k gwisi ka̱n yek ma̱n Yehuda njel nala̱nti ten Yesu ten ɗe ta̱ wuli ɗe, <<Amik ɗe ilga̱ nguki gwe yil sut nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yek sa̱ dlam ɗe, <<Ale ga̱mi wo Yesu ka̱n na̱ yen ga̱ Yusupu, ma̱lgwe ma̱ yis aba suk ana gwas wu? Ɗa̱ni ka̱n ta dlam ɗe, <Sut nya ka̱n a yil gwi>?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yek Yesu balla̱si ɗe, <<Zaka̱n nala̱nti ka̱ dlo gwaka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","<<Ba ma̱lgwe a man la̱t tet mala̱n wu, seko kume Aba ɗe ta̱ shina̱n wu ka̱ dla̱k ma̱li teɗi, a ami wo ba tlilti ten cin pakti ga̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ni ga̱ lishi ka̱ lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya ɗe, <Mas jwasa̱n Nya ka mbokisi ang ten wul.> A mas ma̱lgwe kat ka̱ng, yek ta̱ kan ilgwe Abe mbok ang dani wugo ma̱li a li tet mala̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma̱lgon ɓo taɓa yenti ga̱ Abe so, se ma̱lgwe yil sut mal Nya wu, ti na̱ ngus ka̱ taɓa yen ga̱ Abe wi. ");
INSERT INTO gyz_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gem amik ka hwikii wu, mas ma̱lgwe ba̱l gem go mbadl ma̱n la̱shi pakti nit ɗa. ");
INSERT INTO gyz_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Amik ɗe ilga̱ nguki ma̱n ba̱lti mbadli. ");
INSERT INTO gyz_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ma̱n za̱t jwaka̱n nguk manna ka̱ me, ama mas na̱ na̱k gwisi yek sa̱ ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ama ilga̱ nguki gwe yil sut nya ka̱wu, ten ɗe mas ma̱lgwe nguk ilga̱ nguki gwisi go ta ma̱sh so. ");
INSERT INTO gyz_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Amik ɗe ilga̱ nguki ma̱n ba̱lti mbadl gwe yil sut nya wu. Mas ma̱lgwe nguk ilga̱ nguki ga̱mi go ta mbi mbadl ma̱n la̱shi pakti. Ilga̱ ngukisi ka̱ɗe dli gini, gwe ɗe ba ba̱li ta̱ mbala̱n ji dii atl mbi mbadl wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yek ma̱n Yehuda njel dla̱kti ga̱ɓa i'e ka̱ dlo gwasa̱n asa̱ na̱ma wulti ɗe, <<Ɗa̱ni ka̱n ma̱lga̱n a ba̱la̱nni tludli gwasi ama̱ nguka̱n gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yek Yesu wulsi ɗe, <<Gem amik ka hwikii wu, ɗe hal kume ka̱a̱ nguk tludli ga̱ Yen ga̱ Mbala̱n so, a ba̱ka̱a̱ tla hwulan gwas sogo, mbadl ma̱n la̱shi pakti ni ka̱ kii so. ");
INSERT INTO gyz_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mas ma̱lgwe ata̱ nguk tludli gini ata̱ tla hwulan gi go mbadl ma̱n la̱shi pakti nit ɗa, a ba tlilti ten cin pakti ga̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ten ɗe tludli gi ka̱ɗe ilga̱ nguki ga̱ gem, a hwulan gi wo ilga̱ tle ga̱ gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mas ma̱lgwe ata̱ nguk tludli gini ata̱ tla hwulan gi go, ta̱ na̱ma da̱mti gwas ka̱ ami, a ami mago a nima da̱mti ka̱ ma̱li. ");
INSERT INTO gyz_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na̱k kangwe Aba ɗe mbadl nit ɗa̱ wu shina̱nni yek a na̱ma da̱mti ten bi gwas wu, ten na̱k gwisi ka̱n mas ma̱lgwe palla̱n ɗe ilga̱ nguki gwas wu a mbi mbadl ten bi gini. ");
INSERT INTO gyz_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Amik ɗe ilga̱ nguki gwe yil sut nya wu. Ma̱n za̱t jwaka̱n nguk manna ama yek sa̱ ma̱shi, ama ma̱lgwe nguk ilga̱ nguki ga̱mi go, ta mbi mbadl ma̱n la̱shi pakti.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu dla̱m mas wul jimi ka̱ sa'i gwe ta̱ nisi ma mbokti ang ten wul ka̱ lu motgaa a Kaparnahum wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Na̱ kumti na̱k gwisi, yek wonti ka̱ mil lishti jwas dla̱m ɗe, <<Ga̱ɓa ga̱n go ma̱n bomti ka̱n, wok ka man kanti wo?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na̱k ɗe Yesu yisi ɗe mil lishti jwas na̱ma nala̱nti ten wul jimi wu, yek ta̱ hwisi ɗe, <<Mbokti ang ten wul ga̱mi ndakii mbadl a? ");
INSERT INTO gyz_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ni ka̱n kaa kumi gwi, ɗe ka̱a̱ yen Yen ga̱ Mbala̱n ten palti to ka̱ lu gwe ɗe ta̱ yil sut ɗu wu! ");
INSERT INTO gyz_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Shishi ka̱ɗe ma̱n ba̱lti mbadli, dli ga̱ mbala̱n wo ten bi ilgon ka̱n ni so. Ga̱ɓa gwe a dla̱mikii go ga̱ɓa ga̱ Shishi ka̱n a mbadl ka̱ pak. ");
INSERT INTO gyz_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ama ma̱jon ni ɗa ka̱ kii ma̱jwe ba̱sa̱ ba̱l gem sowu.>> Ten ɗe Yesu yis ma̱jwe ba̱sa̱ ba̱l gem na̱ti sowu tet ten ndat zhile suk ma̱lgwe a ba̱l bi gwas wu. ");
INSERT INTO gyz_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yek Yesu po wuli ɗe, <<Ilgwe laki yek a hwikii ɗe ma̱lgon a man la̱t tet mala̱n so seko ɗe Aba ba̱lti iko la̱t tet wukgu.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kaal ɗa̱ ga̱ɓa ga̱mi ɗe Yesu dla̱m wu, yek wonti ka̱ mbala̱n jwe sa̱ na̱ma kopti gwas wu zakti, yek sa̱ zak kopti gwas kaali. ");
INSERT INTO gyz_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yek Yesu gem mil lishti ɗe kutl cet loɓi ɗe, <<Kii mago ka̱a̱ na̱ma lamti za̱tgaa ma?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Yek Siman Biturus ballit ɗe, <<Bagaa mal wok ma li wo? Ga̱ɓa ma̱n ba̱lti mbadl ma̱n la̱shi pakti nik ɗa. ");
INSERT INTO gyz_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma̱ ba̱l gem a ma̱ yisi ɗe kik ɗe Ma̱n Cilti ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yek Yesu balli ɗe, <<Ale kii ɗe kutl cet lop ka̱n a botlkii na̱? Ama ɗe na̱m ka̱ kii wo sheɗan ka̱n?>> ");
INSERT INTO gyz_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ta̱ na̱ma ga̱ɓa ten Yehuda yen ga̱ Siman Iskariyoti, ten ɗe tik ka ba̱l bi gwasi, ko ɗe ti wo ɗe na̱m ka̱n ka̱si ɗe cutl cet loɓi wu.) ");
INSERT INTO gyz_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kaal ɗa̱ na̱k gwisi yek Yesu ma̱tl ɗa̱nka̱ ba̱n ji Galili ka, ama yek ba̱ta̱ lami ɗe ta̱s li Yehudiya so ten ɗe ma̱n Yehuda jwe ni ka̱li wu na̱ma lamti tlot gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","A biki ga̱ ma̱n Yehuda gwe asa̱ mbe ɗe Biki Bukka wu ɓal njaa, ");
INSERT INTO gyz_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yek yilkeni ji Yesu wulti ɗe, <<A mbuna̱n ɗe ta̱k zak ɗee ta̱k li Yehudiya, ten ɗe ta̱ mil lishti jwa yen wul ngipti bi ang gwe ka̱ na̱ma pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ai mas ma̱lgwe na̱ma lamti ɗe ta̱ mbala̱n yisti i'e go ta̱ hwunda̱la̱n pa̱lti wul gwas so. Na̱k ɗe ka̱ na̱ma pa̱lti wul jin wu, se ta̱k mboki ang dii atl ten gaa gwa ta̱s yiski ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ten ɗe ko ta̱ yilkeni ji Yesu mago sa̱ ba̱l gem na̱ti so. ");
INSERT INTO gyz_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ten na̱k gwisi ka̱n yek Yesu hwisi ɗe, <<Sa'i gi ɓo pi so, a malkii wo ko ta̱ sa'i gwik-gwi ten ndwal gwas ka̱n ni. ");
INSERT INTO gyz_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Kii wo dii atli a ngekii so, ama ami wo ta ngeni ten ɗe a nitma dla̱mti byas pa̱lti wul gwe ata̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kii wo la̱n ka̱lu Biki. Ami wo ba li ka̱lu biki so ten ɗe sa'i la̱t gi ɓo pi so.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ɗe Yesu dla̱misi ga̱ɓa gwisi wu, yek ta̱ nak la̱m da̱mti a Galili. ");
INSERT INTO gyz_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ama ɗe yilkeni jwas li ka̱ lu biki wu, yek Yesu li ka̱ lu biki ama mukli ba̱ ɗe ten gwel ga̱ mbala̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yek ma̱n Yehuda ngusi ngot gwas ka̱ lu biki, asa̱ na̱ma kum ga̱zi ɗe <<Ma̱llu ka̱ yi?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Yek wonti mbala̱mi ngusi ga̱ɓa ten Yesu mukli ɗa̱nka̱ dlo jwasa̱n ka. A jon jwasa̱n na̱ma wulti ɗe, <<Ti wo hwa mbala̱n ka̱n.>> A jon wo sa̱ na̱ma wulti ɗe, <<Wowo, ai shelti ka̱n ta̱ na̱ma shelti ga̱ mbala̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ama yek ba̱ ma̱lgon man ga̱ɓa tenti ka̱ mbala̱n ten dii so, ten ɗe sa̱ nima ɓanti bacina ji ma̱n Yehuda. ");
INSERT INTO gyz_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Se sa̱ ɓal ka̱ dlo ga̱ Biki yek Yesu te ka̱ dii boo lubii ga̱ Nya, yek ta̱ njeli mbokti ang mbala̱n ten wul. ");
INSERT INTO gyz_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yek ma̱n Yehuda ngip ang bi asa̱ na̱ma kumti ga̱zi ɗe, <<Ɗa̱ni ka̱n ma̱lga̱n pi yek ta̱ yis wul jin jwi ɗe ba̱ta̱ ɓo taɓa la̱t ka̱lu koyat lishti sowu?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yek Yesu ballisi ɗe, <<Wul jimi ɗe a na̱ma ma mbokti ang a a dani go ga̱ gaa gi ka̱ so, ama ga̱ ma̱lgwe shina̱n sut wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mas ma̱lgwe botli ɗe ta̱s pa̱l ilgwe Nya lami go, ta yisi ɗe mbokti ang ten wul gi wo sut mal Nya ka̱n ni, a ba̱ ga̱ gaa gi ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma̱lgwe ata̱ mbok ang ten ga̱ɓa ga̱ gaa gwas go, nalti ka̱n ti nima ngweti gaa gwasi, ama ma̱lgwe a ta̱ pa̱l wul ten ɗe ta̱s ngwe nalti ma̱lgwe shinti go, ma̱n pa̱lti gem ka̱ɗe ti, a ba̱ta pa̱l la̱shi gem so. ");
INSERT INTO gyz_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ale Musa ka̱ ba̱lki mba̱t ga̱ɓa na̱? Mas na̱ gwisi yek ba̱ ma̱lgon ka̱ kii kop mba̱t ga̱ɓe so. Yek laki ɗe ka̱a̱ na̱ma ngot tlot gi ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yek mbala̱mi ballit ɗe, <<Ki wo ma̱n ma̱zhe ka̱n wok na̱ma ngot tlot gwa wo?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yek Yesu wulsi ɗe, <<A pa̱l wul ngipti ang bi ɗe na̱m ama yek mas jwaka̱n ngip ang bi. ");
INSERT INTO gyz_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa wulkii ɗe ta̱k pa̱la̱n sa̱lti, ko ɗe tet malti ka̱n yil tet so, ama tet mal ma̱n ga̱z jwaka̱n ji da ka̱wu, mas na̱ nu a ka̱a̱ sa̱l yen Gas Shukti. ");
INSERT INTO gyz_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ama na̱k ɗe aka̱a̱ sa̱l mil Gas Shukti ten ɗe ta̱k koɓa̱n mba̱t ga̱ɓa ga̱ Musa wu, yek laki ɗe kaa lil mbadl na̱ ami ten ɗe a ndok dli ga̱ mbala̱n Gas Shukti i'e ye? ");
INSERT INTO gyz_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Zaka̱n kisti ga̱ɓa ten wul jwe a gwel gwaka̱n yeni dani wu, ama Kisa̱n ga̱ɓa ten ndwali.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ka̱ sa'i gwisi ka̱n yek ma̱n Wurshelima jon njel kumti ga̱zi ɗe, <<Ale ma̱lga̱n ka̱ɗe ma̱lgwe sa̱ na̱ma lamti tlot gwas wu na̱? ");
INSERT INTO gyz_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tik gu aɗe ta̱ na̱ma ga̱ɓa ka̱ mbala̱n ten dii, a ba̱ ma̱lgon wulti ɗe ilgon so. Ko na̱k ka̱n bacina ji na̱mi kama̱n wi ɗe tik ɗe Almasihu na̱? ");
INSERT INTO gyz_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yekgu ma̱ yis tet ka̱ lu gwe ma̱lga̱n yil tet wu, ama ɗe Almasihu ga̱ gem tul wugo ma̱lgon a yis tet ka̱lu gwe ta̱ yil tet wu so.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","A Yesu nisi ma mbokti ang ten wul ka̱ dii boo lubii ga̱ Nyami, yek ta̱ tlil yal nya yek ta̱ wuli ɗe, <<Yi, ka̱a̱ yisa̱nni a ka̱a̱ yis tet ka̱ lu gwe a yil tet wu. A tul ten ɗe ta pa̱l wul na̱ iko ga̱ gaa gi so, ama ma̱lgwe shina̱n go ma̱n pa̱lti gem ka̱n. A ba̱ka̱a̱ yisti so, ");
INSERT INTO gyz_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ama ami wo a yisti ten ɗe sut malti ka̱n ani a tik shina̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ɗe Yesu dla̱m nu wo yek mbala̱mi ngo dopti gwasi ama yek ba̱sa̱ man ta̱nti gwas so na̱k ɗe sa'i gwas ɓo pi sowu. ");
INSERT INTO gyz_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mas na̱ nu yek wonti ka̱ mbala̱mi ba̱l gem na̱ti. Yek sa̱ dla̱m ɗe, Kume ɗe Almasihu tul wugo, ta̱ pa̱l wul ngipti ang bi gwe a man ga̱ ma̱lga̱mi gwa? ");
INSERT INTO gyz_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yek Ma̱n Parisi kum mbala̱mi ten ga̱ɓa mukli ka̱ dlo jwasa̱n ten Yesu. Yek kiɗi ji ma̱n Pa̱ris suk ma̱n Parisi shin ma̱n ɓa̱tti lubii ga̱ Nyami ɗe ta̱s dopti. ");
INSERT INTO gyz_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yek Yesu wulsi ɗe, <<Ani sukki ga̱ nak njet sa'i, a pa a pal to mal ma̱lgwe shina̱n wu ka. ");
INSERT INTO gyz_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kaa ngoni a ba̱kaa mbi so, a lu gwe ani go, kaa man la̱t so.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yek ma̱n Yehuda ga̱ɓa suk yilkeni jwasa̱n yek sa̱ dla̱m ɗe, <<A ako ka̱n ta li ko gwe ɗe hal ba̱ ma po mbiti sowu? Ko na̱k ka̱n ta li mal mbala̱n jina̱n ɗe sa̱ni ga̱ cati ɗa̱nka ka̱ ma̱n Girik ka, a ta̱ mboki ang mbala̱n ji ma̱n Girik ang ten wul ka̱li na̱? ");
INSERT INTO gyz_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yek ɗe gaa ilgwe ta̱ na̱ma dla̱mti wu ye, ɗe ta̱ wule <Kaa ngoni ama ba̱kaa mbi so,> a yek ɗe daamti gwas ye, ɗe ta̱ wule <Lu gwe ani go kaa man la̱t sowu ye>?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ten cin pakti ga̱ biki cin gwe yek ɗe bali ga̱ biki wu, yek Yesu tlinya yek ta̱ tlil yal nya yek ta̱ dla̱m ɗe, <<Mas ma̱lgwe ka̱lka̱ze na̱ma tlot gwas go ta̱s li tet mala̱nni ta̱s tla ze.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mas ma̱lgwe ba̱l gem na̱ ami go, gwel ze gwe na̱ma telti ze ma̱n ba̱lti mbadl wu a kata̱l tot ka̱ mbadl gwasi na̱k kangwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu na̱ma ga̱ɓa ka̱n, ten bi ga̱ Shishi ga̱ Nya gwe sa ba̱l ma̱jwe sa ba̱l gem na̱ti wu. Ten ɗe ka̱ sa'i gwisi wo sa̱ ɓo ba̱l Shishi ga̱ Nya mbala̱n so, na̱k ɗe Yesu ɓo te ka̱ nalti gwas sowu. ");
INSERT INTO gyz_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ɗe mbala̱mi kum ga̱ɓa gwisi ɗe Yesu dla̱m wugo yek sa̱ wuli ɗe, <<Gem ka̱n, ma̱lga̱n ka̱ɗe ma̱n dla̱mti ga̱ɓa ga̱ Nyami.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Naami jwasa̱n wo yek sa̱ wule, <<Tik ɗe Almasihusi.>> Ama naami wo yek sa̱ kum ga̱zi ɗe, <<Na̱ngo Almasihusi wo tet Galili ka̱n ta yil tet ɗa?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ale ga̱ɓa ga̱ Nya dla̱ma̱n ɗe Almasihu wo ka̱ ga̱z ga̱ Dauda ka̱n sa za̱ti, a ta yil tet ka̱ Baitalami ba̱n gwe Dauda da̱m wu na̱? ");
INSERT INTO gyz_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yek bi tatli mbala̱mi ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jon jwasa̱n lami ɗe ta̱s dopti, ama yek ba̱ ma̱lgon ta̱nti so. ");
INSERT INTO gyz_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ɗe ma̱n ɓa̱tti lubii ga̱ Nyami pal tet ɗu go yek kiɗi ji ma̱n Pa̱ris suk ma̱n Parisi ngemsi ɗe, <<Yek laki yek ba̱ka̱a̱ kanti tet so ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yek ma̱n ɓa̱tti lubii ga̱ Nyami nda̱kisi ɗe, <<Ai ma̱lgon ɓo taɓa ga̱ɓa na̱k kangwe a ma̱lga̱n ga̱ɓa wu so.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yek ma̱n Parisisi wulsi ɗe, <<Ahwap! Kii mago ta̱ gilla̱kii wu nwa? ");
INSERT INTO gyz_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ko ka̱a̱ yena̱n ma̱lgon tet ka̱ bacina jwaka̱n sogo ma̱n Parisi gwe ta̱ ba̱l gem na̱ti wu? ");
INSERT INTO gyz_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ama wonti mbala̱n jimi ɗe ba̱sa̱ yis ilgon tet ka̱ mba̱t ga̱ɓa ga̱ Musa sogo, ai ma̱jwe sa̱ pa̱lisi bi gaa wu ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","A Nikodimus ɗe ta̱ li mal Yesu tet da wu, ni ka̱ ma̱n Parisisi yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Na̱ngo mba̱t ga̱ɓa ga̱na̱n wuli ɗe ta̱ lil mbala̱n ka, tun a ba̱ma̱ ɓo kuma̱n ga̱ɓa tet ka̱ bi ga̱ ma̱li ten ɗe ta̱ yis ilgwe ma̱li na̱ma pa̱lti wu sa?>> ");
INSERT INTO gyz_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Yek sa̱ ballit ɗe, <<Ki mago ma̱n Galili ka̱ɗe ki a? Ɓo bodla̱li ka̱ ga̱ɓa Nya ta̱k ɓo yeni la, ai ma̱n dla̱mti ga̱ɓa ga̱ Nya gon a taɓa yilti tet Galili so.>> ");
INSERT INTO gyz_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yek paa ko wokko li lubii gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ama yek Yesu to ten Tla̱nda̱l Tlindi Zaitun. ");
INSERT INTO gyz_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yek Yesu li lubii ga̱ Nya buzge na̱ gasi. Yek mbala̱mi mas li tet malti yek ta̱ da̱n na̱ zhila ten ɗe ta̱s mbokisi ang ten wul. ");
INSERT INTO gyz_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yek ma̱n yisti mba̱t ga̱ɓa ga̱ Musa suk ma̱n Parisi tulli kili gon gwe sa̱ dopti ten pa̱t pa̱la̱n wu. Yek sa̱ laki yek kilisi dla̱l nya ka̱ dlo gwasa̱n, ");
INSERT INTO gyz_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","yek sa̱ hwi Yesu ɗe, <<Ma̱n lishti, kili ga̱n go ten pa̱t pa̱la̱n ka̱n sa̱ dopti. ");
INSERT INTO gyz_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ka̱ mba̱t ga̱ɓa ga̱ Musa wo sa̱ zini ɗe, ta̱n lak wunda̱l jwasa̱n na̱ ye hal se sa̱ ma̱shi. Ki wo yek ka̱ dla̱m ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sa̱ ngemti nu ka̱n ten ɗe ta̱s kum ilgwe ta dla̱m wu sa̱ na̱ma lamti ta̱s mbit na̱ pa̱lti byas wul kangwe sa man ta̱lat gwas dlaboo wu ɗa. Ama yek Yesu ngus atli yek ta̱ pita pa̱lti lishti na̱ yen ang gwas ka̱ atli. ");
INSERT INTO gyz_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ɗe sa̱ pita ngemti ga̱ Yesu wugo, yek ta̱ tlil gaa nya yek ta̱ wulsi ɗe, <<Kume ma̱lgwe ɓo taɓa pa̱lti byas wul sowu ni ɗa ka̱ kii go, ta̱ ma̱li da̱m ɗe ma̱lgwe a nda lakti gwas na̱ yesi wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yek Yesu po ngusa̱l gaa gwas atli yek ta̱ pita lishti ten atli. ");
INSERT INTO gyz_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ɗe sa̱ kumi nu wugo, yek sa̱ njel za̱tgaa ɗa̱ ka̱li ka na̱m na̱m, kan tet ten kakshe gwasa̱n hal yek la nak'eni gwasa̱n, yek sa̱ zak Yesu na̱ ngusi suk kilisi a nya a cina gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yek Yesu tlinya yek ta̱ ngemti ɗe, <<Kili mbala̱n, sa̱ ɓal ko? Ma̱lgon man lilti gwa ka̱ so nwa?>> ");
INSERT INTO gyz_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yek ta̱ ballit ɗe, <<Wowo ma̱lgon gon mani so, ma̱n nalti.>> Yek Yesu ballit ɗe, <<Ko ta̱ ami mago ba lilki ka̱ so. Ningo zigaa ama ba̱k po pa̱l byas wul so.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yek Yesu ci cina na̱ dla̱mti ga̱ɓa mbala̱n yek ta̱ wuli ɗe, <<Amik ɗe cilti ga̱ dii atli. Mas ma̱lgwe na̱ma kopti gi go ta li ka̱ da̱mshal so, ama ta mbi cilti ga̱ mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yek ma̱n Parisi wulti ɗe, <<Ka̱ na̱ma ba̱lti sheda ten gaa gwa ten na̱k gwisi ka̱n sheda gwe ka̱ ba̱li go gem ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yek Yesu ballisi ɗe, <<Kume a ba̱l sheda ten gaa gi mago, sheda gwe a ba̱li go gem ka̱n, ten ɗe a yis lu gwe a yil sut wu suk lu gwe ba li wu. Ama kii wo ka̱a̱ yis lu gwe a yil sut wu sogo lu gwe ba li wu so. ");
INSERT INTO gyz_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Kii wo kangwe a mbala̱n kus wullu ka̱n a ka̱a̱ kis ga̱ɓa, ama ami wo ba̱ ba kisi ga̱ɓa ma̱lgon so. ");
INSERT INTO gyz_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ama kume ɗe ba kis ga̱ɓa mago, kisti ga̱ɓa gi wo ga̱ gem ka̱n, ten ɗe ami na̱ ngwe ka̱n ani so. Aba ɗe ta̱ shina̱n sut wu ni suk ami. ");
INSERT INTO gyz_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ka̱ mba̱t ga̱ɓa gwaka̱n wo, sa̱ lishi ɗe kume mbala̱n ɗe lop ba̱l sheda ze ɗe na̱m ten wul go, shede wo gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","To, a mi wo a na̱ma ba̱lti sheda ga̱ gaa gini a Abe ɗe ta̱ shina̱n sut wu ka̱ɗe na ɗe loɓi.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yek sa̱ ngemti ɗe, <<Ako ka̱n Aba gwa wi si ni ko na̱?>> Yek Yesu ballisi ɗe, <<Ka̱a̱ yisa̱n so aba̱ ka̱a̱ yis Aba gi so pak. Ɗe da kaa yisa̱n go da kaa yis Aba gi pak.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ta̱ dla̱m ga̱ɓa jimi ka̱ sa'i gwe ta̱ nisi ma mbokti ang ten wul njaa mal lu gwe asa̱ zi wulpi ka̱ lubii ga̱ Nya wu. Ama mas na̱ nu yek ba̱ ma̱lgon dopti so, ten ɗe sa'i gwas ɓo pi so. ");
INSERT INTO gyz_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yek Yesu po wulsi ɗa̱ ɗe, <<Ba zigaa ka a kaa ngoni, a kaa ma̱sh ka̱ pa̱lti byas wul gwaka̱n. Lu gwe ba li go, kaa man la̱t ka̱li so.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ga̱ɓa ga̱mi laki yek bacina ji ma̱n Yehuda kum ga̱zi ɗe, <<Ko na̱kka̱n ta tlo gaa gwas ka na̱, ɗe ta̱ wule, <Lu gwe ba li go, kaa man la̱t sowu>?>> ");
INSERT INTO gyz_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yek Yesu ci cina na̱ dla̱mti ɗe, <<Kii wo tet ka̱ dii atl ga̱n ka̱n, a ami wo sut nya ka̱n a yili. Kii wo ga̱ dii atl ga̱n ka̱n, ami ga̱ dii atl ga̱n ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gwisi ka̱ laki yek a wulkii ɗe kaa ma̱sh ka̱ pa̱lti byas wul gwaka̱n, ɗe hal kume ka̱a̱ ba̱l gem ten ɗe amik ɗe ma̱lgwe a hwikii ɗe Amik ɗe ti wu sowu kaa ma̱sh ka̱ pa̱lti byas wul gwaka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yek sa̱ gem Yesu ɗe, <<Ɓohwe wok ɗe ki wo na̱?>> Yek ta̱ ballisi ɗe, <<Amik ɗe ma̱lgwe a hwikii tun tet ten ndat zhile wu. ");
INSERT INTO gyz_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Wul wonti ni ɗa gwe ba man dla̱mti tenkii a kisikii ga̱ɓa ɗa̱ wu. Ama ma̱lgwe shina̱n sut go gem ka̱n ata̱ dla̱mi, a ilgwe a kumi malti wu ka̱n a dla̱mi mbala̱n ji dii atli.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yek ba̱ mbala̱mi yis gaami ten ɗe ten Aba gwas ka̱n ta̱ nisi ma ga̱ɓa so. ");
INSERT INTO gyz_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ten na̱k gwisi ka̱n yek Yesu wulsi ɗe, <<Ka̱ sa'i gwe kaa tak yen ga̱ mbala̱n nya wu ka̱n, kaa lak yis gaami ten ɗe Amik Ɗe ti. Ka yis gaami ten ɗe ba̱ ba pa̱l ilgon na̱ iko ga̱ gaa gi so, ama ilgwe Aba mboki ang dani wu ka̱n a dla̱mi tokte. ");
INSERT INTO gyz_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma̱lgwe shina̱n wu ni suk ami ta̱ zaka̱nni ami na̱ ngwe so, ten ɗe ilgwe ta̱ lami wu ka̱n pa̱li dlip.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ka̱ sa'i gwe Yesu dla̱m wul jimi go, yek wonti mbala̱n nga̱ssi tenti. ");
INSERT INTO gyz_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yek Yesu wul ma̱n Yehuda jwe sa̱ ba̱l gem na̱ti wu ɗe, <<Ɗe kume ka̱a̱ ci cina na̱ kopti wul jwe a mbokikii ang dani wugo, kiik ɗe mil lishti jini ji gem. ");
INSERT INTO gyz_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kaa yis gem a gemi a laki aka̱a̱ mbi gaa.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yek sa̱ ballit ɗe, <<Mi wo ga̱z ji Iba̱rahim ka̱n a ba̱ma̱ ɓo taɓa da̱mti ɗe zhel ji ma̱lgon so. To yek laki yek ka̱ dla̱m ɗe ma mbi gaa ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yek Yesu nda̱kisi ɗe, <<Gem amik ka hwikii wu, mas ma̱lgwe ata̱ pa̱l byas wul go zhel ga̱ pa̱lti byas wul ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ai, zhel wo ba̱ta da̱m ka̱ lubii ko a gasi so, ama yen wo ga̱ lubiimi ka̱n ko a gasi. ");
INSERT INTO gyz_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ten na̱k gwisi ka̱n, hal kume ɗe Yeni ba̱lkii mbit gaa go, kaa mbi mbit gaa ga̱ gem. ");
INSERT INTO gyz_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A yisi ɗe kii wo ma̱n ga̱z ji Iba̱rahim ka̱n, ama yekgu ka̱a̱ na̱ma ngot tlot gini, ten ɗe ka̱a̱ kan mbokti ang ten wul gi so. ");
INSERT INTO gyz_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A nikii ma dla̱mti ilgwe a yeni mal Aba gi wu, ama kii wo ilgwe ka̱a̱ kumi mal Aba gwaka̱n wu ka̱n ka̱a̱ na̱ma pa̱lti.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yek sa̱ ballit ɗe, <<Ai, mi wo Iba̱rahim ka̱ɗe Aba ga̱na̱n.>> Yek Yesu wulsi ɗe, <<Ɗe da kume Iba̱rahim wo Aba gwaka̱n ka̱ go, da kaa pa̱la̱n ilgwe Iba̱rahim pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ama yekgu ka̱a̱ na̱ma lamti tlot gini, ami ma̱lgwe dla̱mikii gem ga̱ ga̱ɓa gwe a kumi mal Nya wu. Ai, Iba̱rahim wo ta̱ pa̱la̱n ilgon nu so. ");
INSERT INTO gyz_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ten na̱k gwisi ka̱n, ilgwe a Aba gwaka̱n pali wu ka̱n ka̱a̱ na̱ma pa̱lti.>> Yek sa̱ wulti ɗe, <<Ka̱ na̱ma lamti ta̱k wule mi wo aba nini gaa sa! Nya na̱ gaa gwas ka̱ɗe Aba ga̱na̱n, a tik ɗe Aba ga̱na̱n ti na̱ ngusi.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yek Yesu wulsi ɗe, <<Da Nya kani ɗe Aba gwaka̱n go kaa lama̱nni, ten ɗe sut mal Nya ka̱n a yili a ningo amik gu aɗe. Ten bi tulli ga̱ gaa gi ka̱n ani so ama tik shina̱n suɗi. ");
INSERT INTO gyz_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Yek laki a ba̱kaa yis gaa ga̱ ga̱ɓa gi so ye? Ten ɗe ba̱kaa man katti ka̱ng so ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kii wo ji Aba gwaka̱n Sheɗan ka̱n, lamti gwaka̱n wo ta̱k pa̱la̱n ilgwe aba gwaka̱n lami wu ka̱n. Ti wo ma̱n tlot mbala̱n ka̱n tun tet ten ndat zhile, gem hwotti so ten ɗe gem ni ka̱ti so. Kume ta̱ shel lal wugo ta̱ dla̱m bi gwas wi, ten ɗe ti wo ma̱n shelti lal ka̱n aba ga̱ lali. ");
INSERT INTO gyz_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ama ten ɗe gem ka̱n a na̱ma dla̱mti yek laki yek ba̱ka̱a̱ ba̱l gem na̱ ami so. ");
INSERT INTO gyz_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ka̱ kii wo wok taɓa mbit gi na̱ pa̱lti byas wul wo? Ɗe kume gem ka̱n a na̱ma dla̱m go yek laki yek ba̱kaa ba̱l gem na̱ ami so ye? ");
INSERT INTO gyz_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ma̱lgwe ɗe ti wo ga̱ Nya ka̱ go a ta̱ kum ilgwe a Nya dla̱m wu. Ilgwe laki ɗe ba̱kaa kumi sogo, yek ɗe kii wo mbala̱n ji Nya ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yek ma̱n Yehuda ballit ɗe, <<Ashe gem ga̱na̱n ka̱n ɗe ma̱ dla̱m ɗe, ki wo ma̱n Samariya ka̱n a ma̱zhe ni ka̱ ki wu!>> ");
INSERT INTO gyz_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yek Yesu ballisi ɗe, <<Ami wo ma̱zhe ni ka̱ ami so, Aba gi ka̱n a ba̱lti nalti ama kii wo aka̱a̱ mbula̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A ngwe nalti gaa gi so, ama ma̱n ngoti ni ɗa a ma̱lgwisi ka̱ɗe ma̱n kisti ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gem amik ka hwikii wu mas ma̱lgwe kop mbokti ang ten wul gi go ta ma̱sh so ko njaa.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ten ga̱ɓa gwisi ka̱n yek ma̱n Yehuda wuli ɗe, <<Yeke! Gem, ningo ma̱ yisi wi ɗe ma̱n ma̱zhe ka̱ɗe ki. Ai, Iba̱rahim ma̱sha̱nni a nu ka̱n mas ma̱n dla̱mti ga̱ɓa ji Nya ma̱shi, ama ki wo yek ka̱ na̱ma wulti ɗe, <Mas ma̱lgwe kop mbokti ang ten wul gwa go ta ma̱sh so!> ");
INSERT INTO gyz_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ka̱ da̱ma̱n gwa we ka̱ mana̱n Aba ga̱na̱n Iba̱rahim ma? Ko ta̱ ti gaa gwas mago ta̱ ma̱shi a nu ka̱n ma̱n dla̱mti ga̱ɓa ji Nya ma̱sh pak! Ɗe yek ka̱ palli gaa gwa ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yek Yesu ballisi ɗe, <<Kume ɗe a ba̱l nalti gaa gi mago, nalti gi ni ten bi ilgon so. Aba gi ka̱ ni ɗe ma̱n ba̱lti nalti, ma̱lgwe aka̱a̱ wule tik ɗe Nya gwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kii wo ka̱a̱ yisti so ama ami wo a yisti. Kume a dla̱m ɗe a yisti sowu ba da̱m ɗe ma̱n shelti lali na̱kkii, ama a yisti a na̱ma kopti ga̱ɓa gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aba gwaka̱n Iba̱rahim pa̱l hwol tuk ten ɗe ta̱ yen sa'i gini, ta̱ yeni yek ta̱ pa̱l hwol tuk i'e.>> ");
INSERT INTO gyz_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yek ma̱n Yehuda wulti ɗe, <<Ɓo kuma̱nti na̱! Ki ɗe ka̱ ɓo pa̱l gin ɗe kutl ɗe na̱mtan sowu, ama yek ka̱ dla̱m ɗe ka̱ yen Iba̱rahim ma?>> ");
INSERT INTO gyz_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yek Yesu ballisi ɗe, <<Gem, amik ka hwikii wu, tun a ba̱sa̱ ɓo zi Iba̱rahim so ka̱n Ani ɗa!>> ");
INSERT INTO gyz_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ten ga̱ɓa gwisi ka̱n yek sa̱ yem ye ɗe sa lakti ɗa. Ama yek Yesu hwun ka, yek ta̱ yil ɗa̱ka̱ lubii ga̱ Nyami ka. ");
INSERT INTO gyz_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","A Yesu na̱ma la̱t nugo, yek ta̱ yen ma̱lgon gwe sa̱ za̱t dwa wu. ");
INSERT INTO gyz_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yek mil lishti jwas ngemti ɗe, <<Ma̱n lishti, wok pa̱l byas wul wo ɗe sa̱ zi ma̱lga̱n ɗe dwa wu, ti nwa, ko ma̱n za̱t jwasi?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yek Yesu balli ɗe, <<Pa̱lti pa̱l byas wul ga̱ ma̱li sogo ga̱ ma̱n za̱t jwas ka̱ laki so, ama ten ɗe ta̱ mbala̱n yen iko ga̱ Nya tenti ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ngetli ka̱n ta̱n cin cina na̱ pa̱lti wul ga̱ ma̱lgwe shina̱n sut wu tun ka̱ cin. Ai gas na̱n teɗi sa'i gwe ba ma̱lgon a man pa̱lti ilgon sowu. ");
INSERT INTO gyz_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kume ɗe hal a yi ten dii atl go, amik ɗe cilti ga̱ dii atli.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ɗe ta̱ dla̱m ga̱ɓa gwisi wugo yek ta̱ ba̱za ɓaka̱n ka̱ atli, yek ta̱ nyaka̱m atli yek ta̱ tuksi ma̱li ten gwel. ");
INSERT INTO gyz_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Yek ta̱ hwit ɗe, <<Zigaa, sak pol gwel gwa ka ka̱ bingi ze ga̱ Silom.>> (ilgwe lishti gwisi na̱ma mbokti ang dani go, yek ɗe Ma̱lgwe sa̱ Shinti wu.) Ten na̱k gwisi ka̱n yek ma̱li sak pol gwel ka, yek ta̱ pali a ta̱ na̱ma yenti lu. ");
INSERT INTO gyz_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yek yela̱n da̱mti jwasi suk ma̱jwe ku na̱ yenti gwas ten ngemti wul wu kum ga̱zi ɗe, <<Ale ma̱lga̱n ka̱ɗe ma̱lgwe ata̱ da̱m na̱ zhila ata̱ gem wul wu na̱?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yek jon ji mbala̱mi wule ti ka̱n. Yek jon jwasa̱n wule, <<Wowo, tet ka̱n sa̱ tesi sukti.>> Ma̱li ne go yek ta̱ wulsi ɗe, <<Yii, ami ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yek sa̱ ngemti ɗe, <<Ɗa̱ni ka̱n pi yek gwel gwa ɓul gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yek ta̱ ballisi ɗe, <<Ma̱lgon wu ɗe asa̱ mbet ɗe Yesu wu, ka̱ nyaka̱m atli yek ta̱ tuksi ten gwel. Yek ta̱ hwi ɗe ta li bingi ga̱ ze Silom ta poli ka. Ten na̱k gwisi yek a li yek a poli ka, yek a njel yenti lu.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yek sa̱ ngemti ɗe, <<Ma̱li na̱n ako?>> Yek ta̱ wuli ɗe, <<A yisi so.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yek sa̱ ta̱la ma̱lgwe tek go dwa ka̱wu mal ma̱n Parisi. ");
INSERT INTO gyz_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","To, ten gas shukti ka̱n Yesu nyaka̱m atli yek ta̱ ɓul gwel ga̱ ma̱li. ");
INSERT INTO gyz_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ten na̱k gwisi ka̱n yek ma̱n Parisi ngemti ten kangwe pi yek gwel gwas ɓul wu. Yek ma̱li ballisi ɗe, <<Ta̱ nyaka̱m atli yek ta̱ tuksi ten gwel, yek a poli ka, a ningo a ɓalma yenti lu.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yek ma̱n Parisi jon wuli ɗe, <<Ma̱lga̱n go sut mal Nya ka̱n ta̱ yil so, ten ɗe ba̱ta zak pa̱lti wul gas Shukti so.>> Ama yek jon jwasa̱n kum ga̱zi ɗe, <<Ɗa̱ni ka̱n ma̱n pa̱lti byas wul a man pa̱lti wul ngipti ang bi na̱k gwisi gwi?>> Ten na̱k gwisi yek bi tatlisi tenti. ");
INSERT INTO gyz_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yek sa̱ po gem ma̱li ɗa, yek sa̱ wulti ɗe, <<Yek ɗe daamti gwa tenti ye? Na̱k ɗe ki ka̱n ta̱ ɓul gwel gwa wu.>> Yek ta̱ balli ɗe, <<Ai, ma̱li wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Bacina ji ma̱n Yehuda wo sa̱ ba̱l gem ɗe da go ma̱li wo dwa ka̱ɗe ti ama yek ningo ta̱ ɓa yen lu so. Ten na̱k gwisi ka̱n yek sa̱ shin lu yek sa̱ mbe ma̱n za̱t jwas teɗi. ");
INSERT INTO gyz_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yek sa̱ ngemsi ɗe, <<Yen gwaka̱n ka̱ɗe ga̱n ma? Ti ka̱n ka̱a̱ wuli ɗe ka̱a̱ za̱t dwa gwa? Ɗa̱ni ka̱n pi yek ningo ta̱ ɓalma yenti lu gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yek ma̱n za̱t ji ma̱li balli ɗe, <<Ma̱ yisi ɗe ti wo yen ga̱na̱n ka̱n, a ɗe dwa kan ma̱ za̱ti. ");
INSERT INTO gyz_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ama mi wo ma̱ yis kangwe pi yek ningo ta̱ ɓalma yenti lu, sogo ma̱lgwe ɓulit gwel wu so. Ngema̱nti ai ba̱ yen mbala̱n ka̱ po yi ɗe ti so, ta dla̱mikii na̱ bi gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ma̱n za̱t jwas dla̱m na̱k gwisi ka̱n ten ɗe sa̱ na̱ma ɓanti bacina ji ma̱n Yehuda ten ɗe tet da go ma̱n Yehuda dla̱lli ga̱ɓa ɗe mas ma̱lgwe dla̱m ɗe, Yesu ka̱ɗe Almasihu go sa mbolti ɗa̱ka̱ lu motgaa gwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yek laki yek ma̱n za̱t ji ma̱li dla̱m ɗe, <<Ai, ti wo yen mbala̱n ka̱ po yi so ngema̱nti.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yek sa̱ po mbe ma̱lgwe ɗe tet da go dwa ka̱ɗe ti wu ɗa. Yek sa̱ wulti ɗe, <<Dla̱m gem kangwe Nya a mbi nalti ɗa̱ wu. Ma̱ yisi ɗe ma̱lgwisi wo ma̱n pa̱lti byas wul ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yek ta̱ ballisi ɗe, <<Ko ma̱n pa̱lti byas wul ka̱ɗe ti a, ami wo a yisi so. Wul ɗena̱m ka̱n a yisi. Tet da go dwa ka̱ɗe ami ama ningo a ɓa yen lu.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yek sa̱ ngemti ɗe, <<Yek ta̱ pa̱lik ye? Ɗa̱ni ka̱n ta̱ pi yek ta̱ ɓulik gwel gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yek ta̱ balli ɗe, <<A dla̱mikii wi yek ba̱ka̱a̱ kati ka̱ng so. Yek laki ɗe ka̱a̱ na̱ma lamti ta̱k ya kumi ɗa̱ ye? Ko kii mago ka̱a̱ na̱ma lamti ta̱k da̱ma̱n ɗe mil lishti jwas ka̱n?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yek paa sa̱ dla̱mi ma̱li byas ga̱ɓa yek sa̱ wulti ɗe, <<Kik ɗe yen lishti gwasi, ama mi wo mil lishti ji Musa ka̱n! ");
INSERT INTO gyz_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ma̱ yisi ɗe Nya ga̱ɓa suk Musa, ama ma̱lgwisi wo ma̱ yis lu gwe ta̱ yil tet wu so.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yek ma̱li ballisi ɗe, <<Ase ka̱n a na̱ma yenti wul gipti wul ang bi! Ka̱a̱ yis lu gwe ta̱ yil tet wu so, ama yek ta̱ ɓuli gwel. ");
INSERT INTO gyz_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ma̱ yisi ɗe aba̱ Nya a kati ka̱ng ma̱n pa̱lti byas wul so. Ama ata̱ kati ka̱ng ma̱lgwe ata̱ ngusit atli ata̱ kumit bi wu. ");
INSERT INTO gyz_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tun ten ndat zhila ga̱ dii atli sa̱ ɓo taɓa kumti ɗe ma̱lgon ɓul gwel ga̱ ma̱lgwe sa̱ za̱t dwa wu so. ");
INSERT INTO gyz_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ai, ɗe da kume sut mal Nya ka̱n ta̱ yil sut sogo da ta mana̱n pa̱lti ilgon so.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yek sa̱ balli ma̱li ɗe, <<Ki ɗe sa̱ za̱k ka̱ pa̱lti byas wullu, ama yek ka̱ na̱ma lamti ta̱k mbokini ang ten wul la?>> Yek sa̱ mbolti. ");
INSERT INTO gyz_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ɗe Yesu kumi ɗe sa̱ mbol ma̱li ɗe ta̱ mbit wugo yek ta̱ ngemti ɗe, <<Ka̱ ba̱l gem na̱ Yen ga̱ Mbala̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yek ma̱li ngemti ɗe, <<Ma̱n nalti, wok ɗe ti wo? Hwini ten ɗe ta ba̱l gem na̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yek Yesu wulti ɗe, <<Ai, ka̱ yena̱nti wi, tik ɗe ma̱lgwe ta̱ na̱ma ga̱ɓa sukki ninge wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Yek ma̱li dla̱m ɗe, <<Bagaa, A ba̱l gem wi,>> yek ta̱ ngusit atli. ");
INSERT INTO gyz_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yek Yesu wuli ɗe, <<A tul ten dii atl ga̱n ten ɗe ta pa̱l kisti ga̱ɓa ka̱n, ten ɗe ta̱ dwa man yenti lu, a ma̱jwe ma̱n yenti lu da̱m ɗe dwa.>> ");
INSERT INTO gyz_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ɗe ma̱n Parisi jwe sa̱ni sukti wu kumi nu wugo yek sa̱ ngemti ɗe, <<Yek ke? ka̱ na̱ma wulti ɗe mi mago dwa ka̱ɗe mi pak a?>> ");
INSERT INTO gyz_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yek Yesu wulsi ɗe, <<Ai, da dwa kani ɗe kii go da pa̱lti byas wul a nikii gaa so. Ama na̱k ɗe ka̱a̱ dla̱m ɗe ka̱a̱ na̱ma yenti lu wu, to, byas wul gwaka̱n yikii gaa. ");
INSERT INTO gyz_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","<<Gem amik ka hwikii ge, ma̱lgwe ba̱ta̱ te mal tunga mba̱la tu ka̱ bi dlabii so ama yek ta̱ to giɓi tu ka̱ zobsi tantu go, to ma̱li wo muka̱l ka̱n a ma̱n ɓa̱tti tantu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma̱lgwe te malsi tu ka̱ bi dlabii go tik ɗe ma̱n kyo ga̱ mba̱le. ");
INSERT INTO gyz_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A ma̱n ɓa̱tti dlabii ɓulit bi dlabimi, a mba̱le kati ka̱ng yal gwasi. Ata̱ mbe mba̱la jwas na̱ shin jwasa̱n ata̱ ta̱lasi deɓa̱l. ");
INSERT INTO gyz_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɗe ta̱ yilli mba̱la jwas deɓa̱l wugo, ata̱ ndesi cina, a mba̱le kop kaal gwasi ten ɗe sa̱ yis yal gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ama sa kop ma̱nda̱ki so, seko ta̱s aɓiti ten ɗe sa̱ yis yal ga̱ ma̱nda̱ki so.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu dla̱mi mbala̱mi cinga̱lti ga̱ɓa, ama yek ba̱sa̱ yis gaa ga̱ ilgwe ta̱ nisi ma dla̱mti wu so. ");
INSERT INTO gyz_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ten na̱k gwisi ka̱n yek Yesu po dla̱m ɗe, <<Gem, amik ka hwikii wu amik ɗe dlabii ga̱ mba̱le. ");
INSERT INTO gyz_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mas ma̱jwe tuli cina go muka̱l ka̱n suk ma̱n ɓa̱tti tantu, aba̱ mba̱le a katisi ka̱ng so. ");
INSERT INTO gyz_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Amik ɗe bi dlabiimi mas ma̱lgwe te tumala̱n go ta mbi kisti. Ta te giɓi ata̱ yili ata̱ na̱ma pa̱t kyo. ");
INSERT INTO gyz_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Muka̱l wo ata̱ tul ka̱n ten ɗe ta̱s muka̱l wul, suk tloti ka, suk lilti ka, Ama a tuli ten ɗe ta̱s mbi mbadli asa̱ mbi ga̱ njika̱mi. ");
INSERT INTO gyz_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<Amik ɗe hwa ma̱n kyo. A hwa ma̱n kyo wo tik ɗe ma̱n ba̱l mbadl gwasi ten bi ga̱ mba̱le. ");
INSERT INTO gyz_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yen haya ɗe sa̱ kanti ten ɗe ta̱s pi kyoɓi go ti wo mba̱la jwas ka̱ so. Kume ta̱ yen kaɗi la̱ɓi ten la̱t tet wugo, a ta̱ aɓi a ta̱ zak mba̱le. A kaɗi la̱ɓisi dop mba̱le jon a ta̱ cat jon ka. ");
INSERT INTO gyz_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A ma̱li aɓi ten ɗe ti wo yen haya ka̱n a ba̱ ilgon hwotti na̱ mba̱le so. ");
INSERT INTO gyz_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","<<Amik ɗe hwa ma̱n kyo, A yis mba̱la jini a mba̱la ji yisa̱nni, ");
INSERT INTO gyz_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","na̱k kangwe Abe yisa̱n wu nu ka̱n a Abe. A nima ba̱lti mbadl gi ten bi ga̱ mba̱le. ");
INSERT INTO gyz_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mba̱la jon ni ɗa jwe ba̱ sa̱ni ka̱ tunga mba̱le jin sowu. Si mago ngetli ka̱n ta ta̱lasi teɗi. Si mago sa kati ka̱ng yal gini, asa̱ da̱m ɗe tunga ɗe na̱m na̱ ma̱n kyo ɗe na̱m. ");
INSERT INTO gyz_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ilgwe laki yek Abe na̱ma lamti gi go yek ɗe a ba̱l mbadl gini a kan il gini. ");
INSERT INTO gyz_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ma̱lgon a mani kanti mbadl gi ka̱ so, ten ɗe amik ɗe ma̱n ba̱lti na̱ gaa gini. Iko ba̱lti ni ɗa, a iko kanti lisi ni ɗa̱ pak. Ilgwe Aba gi zi pa̱lti wukgu.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ten ga̱ɓa ga̱mi ɗe Yesu dla̱m wu ka̱n yek ma̱n Yehuda njel calti ga̱ɓa ka̱ dlo jwasa̱n tenti. ");
INSERT INTO gyz_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Yek wonti ka̱si wuli ɗe, <<Ma̱n ma̱zhe ka̱ɗe ti na̱k gwisi ka̱ laki yek ta̱ na̱ma boli. Yek laki ɗe kaa katit ka̱ng ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ama yek jon jwasa̱n wule, <<Wowo, ai ga̱ɓa ga̱n go ga̱ɓa ga̱ ma̱n ma̱zhe ka̱ so. A ma̱zhe mani ɓulti gwel dwa ma?>> ");
INSERT INTO gyz_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ka̱ sa'i nda̱ɗiti asa̱ na̱ma biki ga̱ daamti ɓulti lubii ga̱ Nya a Wurshelima, ");
INSERT INTO gyz_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","a Yesu na̱ma ma̱tlti ka̱ Baranda ga̱ Sulemanu ka̱ lubii ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yek ma̱n Yehuda mogaa malti yek sa̱ wulti ɗe, <<Hal a gasi ka̱n ka zak ni ka̱ da̱mshal gwi? Kume kik ɗe Almasihusi go hwini ten dii la na̱.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yek Yesu ballisi ɗe, <<A hwikii yek ba̱ka̱a̱ ba̱l gem so. Wul ngipti ang bi gwe a pa̱li ka̱ shin ga̱ Aba gi wu ka̱ ɗe wul jwe mbok ang tena̱n wu, ");
INSERT INTO gyz_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ama yek ba̱ka̱a̱ ba̱l gem so ten ɗe kii wo mba̱la ji ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ten ɗe mba̱la ji wo asa̱ kumi bi, a yissi asa̱ koɓa̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A nisi ma ba̱lti mbadl ma̱n la̱shi pakti, a ba̱sa ma̱sh so ko njaa, a ba ma̱lgwe a man kanti gwasa̱n ɗa̱ ang gi ka na̱ nda̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aba gi ɗe ta̱ ba̱la̱nsi wu nda̱l man ko wokko, a ba̱ ma̱lgon a man kanti gwasa̱n ɗa̱ ang gwas ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ami suk Abe wo ɗe na̱m ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yek ma̱n Yehuda po yem ye ɗa ten ɗe sa lakti na̱ nali. ");
INSERT INTO gyz_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ama yek Yesu wulsi ɗe, <<A pa̱likii kiɗi wul ngipti ang bi sut mal Aba gi wonti, gwik a giɓi kaa lakkii ten lakti gi gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yek ma̱n Yehuda ballit ɗe, <<Ai ba̱ ten bi hwa wul gwe ka̱ pa̱li wu ka̱n ma lakki so, ama ten bi ga̱ɓa mbulti ga̱ Nya gwe ka̱ dla̱m wu ka̱n. Ki ɗe mbala̱n kawai wu ama yek ka̱ na̱ma palla̱t gaa gwa ɗe Nya.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yek Yesu ballisi ɗe, <<Ai sa̱ lishi ka̱ mba̱t ga̱ɓa gwaka̱n ɗe, Nya dla̱m ɗe, <Kii wo wul jwe asa̱ ngusisi atl wu ka̱n>! ");
INSERT INTO gyz_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","A ma̱ yisi ɗe ga̱ɓa ga̱ Nya gwe sa̱ lishti wu ɓo taɓa shelti lal so, ɗe kume Bagaa mbe ma̱jwe kum ga̱ɓa gwas wu ɗe, <wul jwe asa̱ ngusisi atl wu> ");
INSERT INTO gyz_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","to, a ami ɗe Aba botltla̱nni yek ta̱ shina̱n sut ten dii atl wu hwa, ɗa̱ni ka̱n a da̱m ɗe ga̱ɓa ga̱ mbulti ga̱ Nya ten ɗe a wule, <Yen ga̱ Nya ka̱ɗe ami gwi?> ");
INSERT INTO gyz_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kume ɗe hal wul jwe Abe na̱ma pa̱lti wu ka̱n a na̱ma pa̱lti sowu, to ba̱k ba̱la̱n gem na̱ ami so. ");
INSERT INTO gyz_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ama kume a na̱ma pa̱lti wul jwe ta̱ na̱ma pa̱lti wu go, ko ba̱k ba̱la̱n gem na̱ ami so ma wu, ba̱la̱n gem na̱ pa̱lti wuli, ten ɗe ta̱k yisini aka̱a̱ yis gaami ɗe, Abe ni ka̱ mi, a ami mago ani ka̱ Abe.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yek sa̱ po ngwe ta̱s dopti ɗa, ama yek ta̱ yil ɗa̱ka̱ ang gwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yek ta̱ pal te ka̱t atl ga̱ Yodan ka, ka̱ lu gwe Yohana nda pa̱lti Baptisma wu, yek ta̱ da̱n ka̱li. ");
INSERT INTO gyz_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yek mbala̱n wonti tul malti. Yek sa̱ ngusi wulti ɗe, <<Ko ɗe Yohana pa̱l wul ngipti ang bi sowu, ama mas ga̱ɓa gwe ta̱ dla̱m ten ma̱lga̱n go gem ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ka̱ lu gwisi wo yek mbala̱n wonti nga̱ssi ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A ma̱lgon ni ɗa shin gwas ka̱ɗe Li'azaru cwo na̱ma cit gwasi, ti wo ma̱n Betani ka̱n a Betani wo ba̱n ga̱ ka̱ Maryam ka̱n suk yilka gwas Marta. ");
INSERT INTO gyz_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Li'azaru ɗe cwo na̱ma cit gwas go yilka ga̱ Maryam ka̱n, a Maryami ka̱ ɗe ma̱lgwe shoti mil ma̱n ta̱mi wusa̱n Bagaa ten asa̱n yek ta̱ taasi ka na̱ ma̱dla̱n gaa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Yek yilkeni jwas ji modlisi shini lu Yesu ɗe, <<Bagaa, ma̱lgwe ka̱ lamti wu cwo na̱ma cit gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ɗe Yesu kumi nu wugo yek ta̱ dla̱m ɗe, <<Cwo gwisi a ɓo la ga̱ ma̱shka̱n so, ama nalti ka̱n a tulli Nya, a mbala̱n ba̱l Yeni nalti tumali pak.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu lam Marta suk yilka gwas Maryam suk Li'azaru. ");
INSERT INTO gyz_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ama ko ɗe Yesu kumi ɗe cwo na̱ma cit ga̱ Li'azaru wu, yek ta̱ po mba̱l multi ɗe lop ka̱ lu gwe ta̱ni wu. ");
INSERT INTO gyz_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ka̱ kaali wo, yek ta̱ hwi mil lishti jwas ɗe, <<Ta̱n pala̱n te ka̱ ka̱t atl ga̱ Yehudiya ka.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Yek mil lishti jwas hwit ɗe, <<Ma̱n lishti, ka̱ multi jon duk go ma̱n Yehuda ngwe ta̱s lakki na̱ ye, ama yek ka̱ ɓa po pal tok a?>> ");
INSERT INTO gyz_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yek Yesu ballisi ɗe, <<Awa ɗe kutl cet lop ka̱ni ten ndat cin ɗe na̱m so nwa? To, mas ma̱lgwe na̱ma za̱tgaa ka̱ cin go ba̱ta kot asa̱n so, ten ɗe ta̱ na̱ma yenti cilti ga̱ dii atl ga̱n. ");
INSERT INTO gyz_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","A mas ma̱n za̱tgaa ka̱ gas wo ata̱ kot asa̱n ten ɗe cilti ni malti so.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ɗe ta̱ pak dla̱mti ga̱ɓa jimi wugo, yek ta̱ wulsi ɗe, <<Yela̱n ga̱na̱n Li'azaru ndemba̱l wi, ama bali a pa̱da̱lti ɗa̱ka̱ yemba̱li ka.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yek mil lishti jwas ballit ɗe, <<Bagaa, kume a yemba̱l ka̱n ta̱ni go, ai, ta ndoki ni.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu wo ten bi ma̱shka̱n ga̱ Li'azaru ka̱n ta̱ na̱ma ga̱ɓa, ama mil lishtisi wo sa̱ da̱m gwa ten ndet yemba̱l ga̱ shukti ka̱n ta̱ na̱ma ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yek pa Yesu dla̱misi ten dii ɗe, <<Li'azaru ma̱sh wi, ");
INSERT INTO gyz_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","a na̱ma pa̱lti hwol tuki ten bi gwaka̱n na̱k ɗe ani ka̱li sowu, kangwe kaa man ba̱lti gem wu. Ama ningo ma̱ la̱n malti.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yek Tomas (ma̱lgwe asa̱ mbet ɗe Ngusa̱n wu) wul yilkeni jwas mil lishtisi ɗe, <<Mi mago ta̱n la̱nni ta̱n ma̱sha̱n sukti.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ɗe Yesu mbuk lu ka̱li wugo yek ta̱ kumi ɗe sa̱ lep Li'azaru wi hal ta̱ pa̱l multi ɗe wupsi ga̱ leɓi wi. ");
INSERT INTO gyz_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani wo njaa suk Wurshelima ka̱n ni, dlenta̱t gwasa̱n pa̱l mil ɗe lop so. ");
INSERT INTO gyz_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A ma̱n Yehuda wonti tul mal ka̱a̱ Marta suk Maryam ta̱s ga̱ɓesi na̱ ma̱sha̱n ga̱ yilka gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ɗe Marta kumi ɗe Yesu ni tet wugo, yek ta̱ li ɗe ta̱s wulit ɗem. Maryam wo yek ta̱ da̱n a lubii. ");
INSERT INTO gyz_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Yek Marta wul Yesu ɗe, <<Bagaa, ai, da ka na̱n ɗa̱ go yilka gi a ma̱sh so. ");
INSERT INTO gyz_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ama a yisi ɗe ko ta̱ na̱k ninge mago Nya a ba̱lki mas ilgwe ka̱ ngemi wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yek Yesu hwit ɗe, <<Yilka gwa aya pal kaami.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Yek Marta ballit ɗe, <<A yisi ɗe taya pal kaami, ten cin pakti ga̱ dii atli.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yek Yesu hwit ɗe, <<Ai, amik ɗe palti kaami a amik ɗe mbadli pak. Ma̱lgwe nga̱sti tena̱n go, ko ta̱s ma̱sh mago ta da̱m na̱ mbadli. ");
INSERT INTO gyz_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A ma̱lgwe yi kaami yek ta̱ ci cina na̱ nga̱sti tena̱n go ta ma̱sh so. Ka̱ ba̱l gem na̱ ga̱ɓa ga̱mi a?>> ");
INSERT INTO gyz_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Yek ta̱ ballit ɗe, <<Yi, Bagaa, A ba̱l gem ten ɗe kik ɗe Almasihusi, Yen ga̱ Nya gwe ta tul ten dii atl wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ɗe Marta dla̱m nu wugo, yek ta̱ sak mbe yilka gwas Maryam yek ta̱ hwit ɗe. <<Ma̱n lishti ɓal ɗa, ata̱ na̱ma mbet gwa.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na̱ kumti na̱k gwisi yek Maryam tlinya ba̱le-ba̱le, yek ta̱ li mal Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","To, aba̱ Yesu ɓo mbuk lu ka̱ ba̱mi so, ata̱ yi ka̱ lu gwe Marta lak wulit ɗem wu. ");
INSERT INTO gyz_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ɗe ma̱n Yehuda jwe ni suk Maryam ka̱ lubiimi ɗe sa̱ na̱ma ga̱ɓet gwas wu yen kangwe ta̱ tlinya ba̱le-ba̱le yek ta̱ yil deɓa̱l wugo yek sa̱ kopti kaali, sa̱ da̱ma̱n gwa we na̱k ka̱n ta sa kulu ten gazukɗisi. ");
INSERT INTO gyz_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ɗe Maryam mbuki ka̱ lu gwe Yesu ni wu wugo yek ta̱ yenti yek ta̱ nda te atl ka a cina gwasi yek ta̱ wulti ɗe, <<Bagaa, ai, da ka na̱n ɗa̱ go yilka gi a ma̱sh so.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ɗe Yesu yenti ten kulu yek ta̱ po yen ma̱n Yehuda jwe sa̱ tul sukti wu si mago sa̱ na̱m kulu wu, yek ili ta̱n mbadl gwas i'e. ");
INSERT INTO gyz_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yek ta̱ kum ga̱zi ɗe, <<Ako ka̱n ka̱a̱ lepti ko?>> Yek sa̱ ballit ɗe, <<Bagaa, lite ta̱k yeni.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yek lnwu shoti Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ten na̱k gwisi ka̱n yek ma̱n Yehuda wule, <<Ɓo yena̱n kangwe ta̱ lamti wu na̱!>> ");
INSERT INTO gyz_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ama yek jon jwasa̱n wuli ɗe, <<Ale tik ɓuli gwel ga̱ dwa wu na̱? To, yek laki yek ba̱ta̱ pa̱l ilgon gwe a laki aba̱ ma̱lga̱n a ma̱sh sowu so ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yek ili po hwot Yesu ka̱ mbadl gwas i'e ɗa, yek ta̱ li mal gazukɗisi. Gazukɗisi wo shu ka̱n sa̱ ɗuk ka̱ ye, yek sa̱ yitla bisi ka na̱ yesi gon. ");
INSERT INTO gyz_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yek Yesu wulsi ɗe, <<Jeka̱n yesi ka,>> Ama yek Marta yilka ga̱ ma̱li ɗe ta̱ ma̱sh wu wul Yesu ɗe, <<Bagaa ningo hwunisi wusa̱n wi ten ɗe ta̱ pa̱l multi ɗe wupsi na̱ ma̱shka̱n wi.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yek Yesu hwit ɗe, <<Ale a hwiki ɗe kume ka̱ ba̱l gem go ka yen nalti ga̱ Nya na̱?>> ");
INSERT INTO gyz_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ten na̱k gwisi ka̱n yek sa̱ jek yesi ka. Yek Yesu lak gaa nya yek ta̱ dla̱m ɗe, <<Aba, a pa̱l hwol tuki na̱k ɗe ka̱ ka̱ti ka̱ng wu. ");
INSERT INTO gyz_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A yisi ɗe dlip aka̱ kati ka̱ng, ama a dla̱m na̱k gwisi ten bi ga̱ ma̱jwe sa̱ni aɗe wu, ten ta̱s ba̱l gem ɗe kik shina̱n suɗi.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ɗe Yesu dla̱m nu wugo, yek ta̱ tlil yal nya yek ta wuli ɗe, <<Li'azaru, yil toɗi!>> ");
INSERT INTO gyz_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Yek ma̱lgwe ma̱shisi yil toɗi, ang suk asa̱n gwas wo ga̱ ɓali ka na̱ hwol yadi, a cina gwel gwas wo ga̱ yitle ka na̱ hwol luka̱l. Yek Yesu wulsi ɗe, <<Pa̱tla̱nti ka, ta̱s zigaa.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ten na̱k gwisi ka̱n yek ma̱n Yehuda wonti jwe sa̱ la ga̱ɓet ga̱ Maryam wu yen ilgwe Yesu pa̱li wu, yek sa̱ nga̱ssi tenti. ");
INSERT INTO gyz_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ama yek jon jwasa̱n li mal ma̱n Parisi yek sa̱ dla̱misi ilgwe Yesu pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yek kiɗi ji ma̱n Pa̱ris, suk ma̱n Parisi mbe motgaa ga̱ bacina jwasa̱n yek sa̱ dla̱m ɗe, <<Yek ma na̱nma pa̱lti ye? Ma̱l ga̱mi ka̱wu ta̱ nima pa̱lti wonti wul ngipti ang bi, gwe na̱ma mbokti ang ɗe ti wo sut mal Nya ta̱ni wu! ");
INSERT INTO gyz_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kume ma̱ zaka̱nti yek ta̱ ci cina na̱ pa̱lti wul jimi go, mas mbala̱n a ba̱l gem na̱ti. A ma̱n Roma a tuli asa̱ kamini lu ga̱na̱n suk lubii ga̱ Nya ga̱na̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ama yek gon gwasa̱n gwe asa̱ mbet ɗe, Kayapa wu, ma̱lgwe tik ɗe bacina ga̱ ma̱n Pa̱ris ten gin gwisi wu wulsi ɗe, <<Kii wo ka̱a̱ yis ilgon so ko njet. ");
INSERT INTO gyz_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ase ka̱a̱ yisa̱n gaami so nwa! Ai, a mani ni ta̱ mbala̱n ɗe na̱m ka̱ ma̱sh ten bi mbala̱n, ɗa̱ gwe ta̱ mas mbala̱mi ka̱ lil ka̱ wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ga̱ɓa ga̱n ɗe Kayapa dla̱m go daamti ga̱ gaa gwas ka̱ so, ama na̱k ɗe tik ɗe bacina ga̱ ma̱n Pa̱ris ten ginisi wu, ta̱ dla̱m ga̱ɓa ga̱ Nya ɗe Yesu a ma̱sh ten bi ga̱ ma̱n Yehuda, ");
INSERT INTO gyz_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ba̱ ɗe ten bi ji ma̱n Yehuda na̱ ngusa̱n so, ama ten ɗe ta̱s mo mil ji Nya jwe sa̱ni ga̱ cati ɗa̱nka̱ wu ta̱s da̱m ɗe na̱m. ");
INSERT INTO gyz_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kan tet ten cin gwisi yek sa̱ pa̱l tantu ga̱ kangwe sa pi asa̱ tlo Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ten na̱k gwisi ka̱n yek ba̱ Yesu ma̱tl ka̱ ma̱n Yehuda ten dii so. Ka̱ lal ga̱ na̱k gwisi wo yek ta̱ zak ka̱t atl ga̱ luisi yek ta̱ li ka̱ atl gwe ni njaa ka̱ me wu, ka̱ ba̱n gwe asa̱ mbe ɗe Iprem wu, ka̱li ka̱n ta̱ da̱m suk mil lishti jwasi. ");
INSERT INTO gyz_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ɗe sa'i Biki Ɗakciti ga̱ ma̱n Yehuda ɓal njaa wu, yek mbala̱n wonti jwe sa̱ ni ka̱ kauye wu to Wurshelima ten ɗe ta̱s pol gaa gwasa̱n ka, na̱k kangwe a ma̱n Yehuda pa̱li wu aba̱ biki ɓo tul so. ");
INSERT INTO gyz_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yek mbala̱n pita ngot ga̱ Yesu ka̱li, sa̱ ngusi dla̱lti ɗa̱n nya ka ka̱ lubii ga̱ Nya asa̱ na̱ma ngemti ji yilkeni jwasa̱n ɗe, <<Yek ɗe daamti gwaka̱n ye? Ko na̱k ka̱n ta tul ka̱ lu biki so na̱?>> ");
INSERT INTO gyz_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ten ɗe kiɗi ji ma̱n Pa̱ris suk ma̱n Parisi dla̱m wi ɗe, ta̱ mas ma̱lgwe yis lu gwe Yesu ni wu sak dla̱misi kangwe sa dopti ɗa̱ wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A multi ɗe mukka ka̱ ɓali asa̱ pa̱l Biki Ɗakciti nugo, yek Yesu li ba̱n Betani ba̱n gwe ka̱li ka̱n Li'azaru ma̱lgwe ɗe Yesu palla̱t kaami wu na̱ma da̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ka̱li ka̱n sa̱ pa̱li ilga̱ nguki ga̱ ka̱ gasi Yesu. Marta ka̱ hulisi ilga̱ ngukisi, a Li'azaru ni ka̱ ma̱jwe sa̱ nguk ilga̱ nguki suk Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yek Maryam kan bunta̱n mil nardi ma̱n ta̱mi wusa̱n ma̱n wulpi i'e, yek ta̱ shoti ten asa̱n ga̱ Yesu, yek pa ta̱ taasi ka na̱ ma̱dla̱n gaa gwasi. Yek ta̱mi wusa̱n ga̱ mili njika̱n mas lubiimi ka. ");
INSERT INTO gyz_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ama yek Yehuda Iskariyoti ti ɗe gon ka̱n ka̱ mil lishti jwas wu, ma̱lgwe tik ka lak ba̱l bi gwas wu wuli ɗe, ");
INSERT INTO gyz_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Yek ɗe ilgwe laki ba̱ a wul mil ma̱n wulpi ga̱mi ka a ba̱l wulpi ma̱jwe ba̱ ilgon nisi ɗa̱ sowu so ye? Mil gwe wulpi gwas a mbuk ɓatlti ga̱ lebura ga̱ gin ɗe na̱m wu!>> ");
INSERT INTO gyz_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yehuda dla̱m ga̱ɓa ga̱mi ka̱n ba̱ ɗe ten ɗe a bi ga̱ ma̱jwe ba̱ ilgon nisi ɗa̱ so wu hwotti ka̱n so, ama ten ɗe ti wo muka̱l ka̱ɗe ti. Na̱k ɗe tik nisi ɗe ma̱n ngipti wulpi wu, ata̱ muka̱li tet giɓi. ");
INSERT INTO gyz_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yek Yesu balli ɗe, <<Zaka̱nti, na̱k ɗe ta̱ zi mili ka ka̱n ten ɗe ga̱ shiri ga̱ cin gwe sa leɓa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ai ma̱jwe wul nisi ɗa̱ sowu na̱n sukkii ko agasi, ama aba̱ ko agasi ka̱n kaa ni suk ami so.>> ");
INSERT INTO gyz_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ɗe ma̱n Yehuda wonti kumi ɗe Yesu ni ɗa̱ ka̱li wugo, yek sa̱ tuli ba̱ ɗe ten bi ga̱ Yesu tokte ka̱ so, ama ta̱s yen Li'azaru ɗe Yesu palla̱t kaami wu pak. ");
INSERT INTO gyz_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ten na̱k gwisi ka̱n yek kiɗi ji ma̱n Pa̱ris pa̱l tantu tlot ga̱ Li'azaru pak, ");
INSERT INTO gyz_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ten ɗe ma̱n Yehuda wonti nga̱ssi ten Yesu, yek sa̱ kopti ten bi ga̱ Li'azaru. ");
INSERT INTO gyz_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ɗe lu tlo wugo yek wonti mbala̱n jwe sa̱ sa Biki Ɗakcitisi wu kumi ɗe Yesu ni ten tantu la̱t Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yek sa̱ kotl daa daɓino yek sa̱ yil to malti ka yek sa̱ wulit ɗem asa̱ na̱ma tliti yal nya ten wulti ɗe, <<Hosana!>> <<Ma̱n albarka ka̱ɗe ma̱lgwe tul ka̱ shin ga̱ Bagaa wu!>> <<Ma̱n albarka ka̱ɗe Guu ga̱ ma̱n Yisraila!>> ");
INSERT INTO gyz_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ɗe Yesu mbi yen zhaki gon wu yek ta̱ to tenti, na̱k gwe sa̱ lishi ɗe, ");
INSERT INTO gyz_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Ba̱ ɓanti cik so, ki Sihiyona, ɓo yen Guu gwa ten tulti, ten yen zhaki.>> ");
INSERT INTO gyz_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ten ndat zhile wo yek ba̱ mil lishti jwas yis gaa ga̱ mas wul jimi so. Se kaal ɗa̱ mbit nalti ga̱ Yesu ka̱n, yek sa̱ lak yisi ɗe mas wul jimi ni ga̱ lishi tenti, a yekgu wuli pi na̱k kangwe ɗe sa̱ lishi wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yek wonti mbala̱n jwe sa̱ni sukti ka̱ sa'i gwe ta̱ taki bi Li'azaru ta̱s palla̱t kaami, a ta̱s yil tot ɗa̱ka̱ gazukɗi ka̱wu, ngusi dla̱mti mbala̱n ilgwe Yesu pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wonti mbala̱n li mal Yesu ta̱s wulit ɗem ten ɗe sa̱ kum wul ngipti ang bi gwisi ɗe ta̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yek ma̱n Parisi wul yilkeni jwasa̱n ɗe, <<Ɓo yeni ni ma̱ cin ba̱n so ko njet. A yekgu mas mbala̱n ji dii atl ɓal ma kopti gwasi!>> ");
INSERT INTO gyz_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","To, ma̱n Girik jon ni ka̱ ma̱jwe sa̱ sa ngusti atl Nya ka̱ mbala̱n jwe sa̱ la biki wu, ");
INSERT INTO gyz_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","sa̱ li tet mal Pilip, ma̱lgwe yil tet Betseda ka̱ atl ga̱ Galili wu, yek sa̱ ngemti ɗe, <<Ma̱n nalti, ma̱ na̱ma lamti ga̱ɓa suk Yesu.>> ");
INSERT INTO gyz_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yek Pilip lak hwi Andarawus, yek si ɗe loɓi li yek sa̱ lak hwi Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yek Yesu ballisi ɗe, <<Sa'i gwe sa nalli Yen ga̱ Mbala̱n wu pi wi. ");
INSERT INTO gyz_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gem amik ka hwikii ge, ɗe kume gwe alkama nda ka̱ shu yek ma̱sh ka̱ sogo, asa ɗe gwesi ɗe na̱m. Ama ɗe kume gwesi ma̱sh ka̱ wugo, a wut mil wonti. ");
INSERT INTO gyz_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mas ma̱lgwe lam mbadl gwas go sa hwulti ɗa. Ama mas ma̱lgwe nge mbadl gwas ten dii atl ga̱n go, za̱ti ka̱n ta̱ na̱ma za̱ti ka kangwe ba̱ a paki ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mas ma̱lgwe a pa̱li wuli go ngetli ka̱n ta̱s koɓa̱nni. A mas lu gwe ani go ma̱n pa̱lti wul gi ani ka̱li suk ami pak. Aba gi a nalli mas ma̱lgwe ta̱ nima pa̱lti wul wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","<<Ningo mbadl gi na̱ma hwotti gini. Yek ba dla̱m ye? Ta wule <Aba kami sa'i ga̱mi ka̱ nwa?> Wowo, ai, sa'i ga̱misi ka̱ɗe ilgwe laki yek a tul ten dii atl wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A, Aba nalli shin gwa!>> Yek yal gon wul sut nya ɗe, <<Ai, a nalli wi, a ba ya nalli ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ɗe mbala̱n jwe sa̱ni ka̱li kum yali wugo, yek sa̱ wuli ɗe, <<Nyaze ɓo gaa wi.>> Jon jwasa̱n wo yek sa̱ wule, <<Yen shinti ga̱ Nya ka̱ hwit ga̱ɓa!>> ");
INSERT INTO gyz_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yek Yesu wulsi ɗe, <<Yal ga̱mi wo ten bi gwaka̱n ka̱n tuli, ama ba̱ ɗe ten bi gi ka̱n tul so. ");
INSERT INTO gyz_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ninge ka̱n sa kisi ga̱ɓa dii atl ga̱n, a ninge ka̱n sa mbol ma̱n guu ga̱ dii atl ga̱n ɗa̱ka̱ gobdlan guu ka. ");
INSERT INTO gyz_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ama sa'i gwe sa tlila̱n tot ɗa̱ka̱ atl ka̱ go, ba dla̱k mas mbala̱n tet mala̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu dla̱m na̱k gwisi ka̱n ta̱s mbok ang ten wunda̱l ga̱ ma̱shka̱n gwe ta pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yek mbala̱mi wulti ɗe, <<Ma̱ kumi ka̱ mba̱t ga̱ɓa ga̱na̱n ɗe Almasihu a ma̱sh so. To ɗa̱ni ka̱n ka wuli ɗe, <Ngetli ka̱n ta̱s tlil Yen ga̱ Mbala̱n gwi? Wok ɗe Yen ga̱ Mbala̱mi wo>?>> ");
INSERT INTO gyz_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yek Yesu wulsi ɗe, <<Cilti ni sukkii ga̱ nak njet sa'i. La̱nni tun a cilti yi sukkii ten ɗe da̱mshal a lak man ngetl gwaka̱n. Ma̱n la̱t ka̱ da̱mshal wo ta̱ yis lu gwe ta̱ na̱ma la̱t wu so. ");
INSERT INTO gyz_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ba̱la̱n gem na̱ cilti tun a cilti yi sukkii, ten ɗe ta̱k da̱ma̱n ɗe mil ji cilti.>> Yesu pakisi dla̱mti ga̱ɓa wugo yek ta̱ zigaa yek ta̱ hwunisi ka. ");
INSERT INTO gyz_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ko ɗe Yesu ngusi pa̱lti wul ngipti ang bi wonti ten gwel gwasa̱n wu, ama mas na̱ na̱k gwisi yek ba̱sa̱ ba̱l gem na̱ti so. ");
INSERT INTO gyz_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Gwisi pi ka̱n ta̱ njika̱n ga̱ɓa ga̱ Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya ɗe, <<Bagaa wok ba̱l gem na̱ ga̱ɓa ga̱na̱n wo a wok ɗe ma̱lgwe sa̱ mbokit ang ten iko ga̱ Bagaa go?>> ");
INSERT INTO gyz_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Yek laki yek ba̱sa̱ man ba̱lti gem so, na̱k kangwe Ishaya po dla̱m ka̱ luisi gon ɗe, ");
INSERT INTO gyz_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<Ta̱ palla̱si ɗe dwa yek ta̱ ka̱nga̱l mbadl jwasa̱n ka, ten ɗe ba̱s yen lu na̱ gwel gwasa̱n so, a ba̱s yis gaami ka̱ mbadl gwasa̱n so, hal asa̱ pal tet mala̱nni ta ndoksi ɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya dla̱m na̱k gwisi ka̱n ten ɗe ta̱ yen nalti ga̱ Yesu yek ta̱ ga̱ɓa tenti. ");
INSERT INTO gyz_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ama mas na̱ na̱k gwisi wo wonti mbala̱n nga̱ssi tenti, hal suk wonti mbala̱n tet ka̱ bacina jwasa̱n sa̱ nga̱ssi tenti. Ama ten ɗe sa̱ ɓanti ma̱n Parisi yek ba̱sa̱ dla̱m ɗe sa̱ nga̱s tenti so, ten ɗe ba̱s mbolsi ɗa̱ka̱ lu motgaa gwaka̱n ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Na̱k ɗe sa̱ lami ɗe ta̱s mbi ta̱sti mal mbala̱n man kangwe sa̱ lami ɗe ta̱s mbi ta̱sti mal Nya wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yek Yesu tlil yal nya yek wuli ɗe, <<Mas ma̱lgwe ba̱l gem na̱ ami go ami na̱ ngwe ka̱n ma̱li ba̱l gem ɗa tokte so, ama ta̱ ba̱l gem na̱ ma̱lgwe shina̱n sut wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mas ma̱lgwe na̱ma yenti gi go, ma̱li nima yenti ga̱ ma̱lgwe shina̱n sut wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na̱k cilti ka̱n a tuli ten dii atli ten ɗe ba̱ mas ma̱lgwe nga̱sti tena̱n wu da̱m ka̱ da̱mshal so. ");
INSERT INTO gyz_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","<<A mas ma̱lgwe kum ga̱ɓa gini, ama yek ba̱ta̱ koɓi sogo amik ɗe ma̱lgwe a kisit ga̱ɓa wu so. A tul ten ɗe ta pa̱li nol dii atl so, ama a tul ten ɗe ta̱ kis dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mas ma̱lgwe ngeni yek ta̱ nge kanti ga̱ɓa gi go, ma̱lgwe a nolti wu ni ɗa, ga̱ɓa gwe a dla̱m wu ka nolti ten cin pakti ga̱ dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ten ɗe ilgwe a na̱ma mbokti ang dani go gi ka̱ so, ama Aba gi ɗe ta̱ shina̱n wu ka̱ dla̱mi ilgwe ba dla̱m wu, suk kangwe ba dla̱m ga̱ɓe wu. ");
INSERT INTO gyz_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A a yisi ɗe mbala̱n a mbi mbadl ma̱n la̱shi pakti tumal ga̱ɓa ga̱ Aba gini. Ten na̱k gwisi ka̱n mas ilgwe a dla̱m go ndakce ka̱n ni suk kangwe Aba hwi ɗe ta hwikii wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Asa̱ ni na̱k gwisi tun aba̱ sa'i Biki Ɗakcitisi ɓo pi so. Yesu wo ta̱ yisi ɗe sa'i zakti dii atl gwas ta̱s pal to mal Aba ka pa̱li wi. Na̱k ɗe ta̱ lam mbala̱n jwas ɗe sa̱ ni ten dii atl wu, yek ta̱ mbokisi ang ten kangwe ta̱ lamsi wu. ");
INSERT INTO gyz_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ka̱ sa'i gwe Yesu suk mil lishti jwas nima ngukti ilga̱ nguki ga̱ ka̱ gas wu, a sheɗan te ka̱ mbadl ga̱ Yehuda Iskariyoti yen ga̱ Siman wi ɗe ta̱s ba̱l bi ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","A Yesu yisi ɗe Aba lak mas wul ka̱ ang gwasi, ta̱ yisi ɗe sut mal Nya ka̱n ta̱ yil suɗi a malti ka̱n ta pal to ka. ");
INSERT INTO gyz_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Yek Yesu tlinya yek ta̱ ndus luka̱l gwas ga̱ tu kaali ka, yek ta̱ kan tawul yek ta̱ hap te dlo ka. ");
INSERT INTO gyz_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kaal ɗa̱ na̱k gwisi yek ta̱ shot ze ka̱ gali, yek ta̱ njeli polti asa̱n mil lishti jwasi, ata̱ na̱ma taasti ka na̱ tawul gwe ta̱ hap te dlo ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yek Yesu li mal Siman Biturus. Yek Biturus wulti ɗe, <<Bagaa, kik ka poli asa̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yek Yesu ballit ɗe, <<Na̱k ningo ka̱ yis ilgwe a na̱ma pa̱lti wu so, ama ka̱ kaali wo kaa yis gaami.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yek Biturus wulti ɗe, <<Wowo, ami wo ka poli asa̱n so.>> Yek Yesu ballit ɗe, <<To, ɗe kume a polik ka̱ sogo ki wo ilgon a mo sukki so.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Yek Biturus wulti ɗe, <<Bagaa ɗe nuk wu, asa̱n gi ka̱n ka poli ka tokte so ama poli suk ang suk gaa gi pak!>> ");
INSERT INTO gyz_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yek Yesu ballit ɗe, <<Ma̱lgwe wutit ze wugo asa̱n gwas ka̱n ata̱ poli ka, dli gwas mbun wi. A yek ge kii wo sabta nikii ɗa, ama ba̱ ɗe mas jwaka̱n ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ten ɗe Yesu yis ma̱lgwe a ba̱l bi gwas wu, yek laki yek ta̱ dla̱m ɗe ba̱ ɗe mas jwaka̱n ka̱n sabta nikii ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ɗe ta̱ polisi asa̱n wugo, yek ta̱ kin luka̱l gwas lwisi, yek ta̱ pal ka̱ lu da̱mti gwasi yek da̱m atli. Yek ta̱ ngemsi ɗe, <<Ka̱a̱ yis gaa ga̱ ilgwe a pa̱likii gwa?>> ");
INSERT INTO gyz_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","<<A ka̱a̱ mbe ɗe Ma̱n <Lishti> suk <Bagaa.> A gem ka̱n, ten ɗe na̱k gwisi ka̱n ni. ");
INSERT INTO gyz_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Tun na̱k ɗe ami ɗe Bagaa suk Ma̱n lishti gwaka̱n ama yek a polikii asa̱n wu, kii mago mbun ɗe ta̱k poli asa̱n yilkeni jwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A zikii lal wi, ten ɗe kii mago ta̱k pa̱li na̱k kangwe a pa̱likii wu. ");
INSERT INTO gyz_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gem amik ka hwikii ge, zhel nal man baboo gwas so, a ba̱ yen shinti nal man ma̱n shinti gwas so. ");
INSERT INTO gyz_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ninge ɗe ka̱a̱ yis wul jimi wu, kaa da̱m ɗe ma̱n albarka ɗe kume ka̱a̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","<<Ba̱ ɗe ten mas jwaka̱n ka̱n a na̱ma ga̱ɓa so. Ten ɗe a yis ma̱jwe a botli wu. Gwisi wo ten ɗe ta̱ njika̱n ilgwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya ka̱n, ɗe, <Ma̱lgwe na̱ma ngukti wul gi wu tli gaa.> ");
INSERT INTO gyz_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","<<A nikii ma hwiti ga̱mi ka̱n tun ninge aba̱ ɓo pi so, ten ɗe kume ɗe sa'i pi wugo aka̱a̱ ba̱l gem ɗe Amik ɗe ti. ");
INSERT INTO gyz_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gem amik ka hwikii ge, mas ma̱lgwe kan ma̱lgwe a shinti wu go ami ka̱n ta̱ kama̱nni, a ma̱lgwe kama̱n go, ma̱lgwe shina̱n wu ka̱n ma̱li kanti.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ɗe Yesu dla̱m ga̱ɓa ga̱mi wugo yek ili hwotti ka̱ mbadl i'e. Yek ta̱ dla̱m ten dii ɗe, <<Gem amik ka hwikii ge, gon gwaka̱n a ba̱l bi gini.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yek mil lishtisi ngusi yenti ga̱ yilkeni jwasa̱n ka shu gwel, ten ɗe sa̱ yis yen lishti gwe ta̱ na̱ma ga̱ɓa tenti so. ");
INSERT INTO gyz_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","A gon ka̱ mil lishtisi, yen lishti gwe Yesu lamti i'e ni na̱ zhila njaa malti. ");
INSERT INTO gyz_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Yek Siman Biturus hwit ga̱ɓa ga̱ pa̱li na̱ ang ɗe, <<Ngemti, wok ta̱ na̱ma ga̱ɓa tenti wo.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yek yen lishti gwisi ɗam te ka yek ta̱ nga̱sti ten ngetl ga̱ Yesu, yek ta̱ ngemti ɗe, <<Bagaa, wok ɗe ti wo?>> ");
INSERT INTO gyz_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yek Yesu ballit ɗe, <<Ba njop nak burodi ka̱ gali, a ma̱lgwe a ba̱lti go tik ɗe ma̱li.>> Ɗe Yesu kan nak burodisi yek njop ka̱ gali wugo yek ta̱ ba̱l Yehuda Iskariyoti yen ga̱ Siman. ");
INSERT INTO gyz_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yehuda na̱ma kanti burodisi, yek Sheɗan te ka̱ti. Yek Yesu wulti ɗe, <<Ilgwisi ɗe ka pa̱li wu, se ta̱k pa̱li ba̱le-ba̱le.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ama yek ba̱ ma̱lgon yis ilgwe laki yek Yesu dla̱mit ga̱ɓa gwisi ka̱ ma̱jwe sa̱ na̱ma ngukti wuli wu so. ");
INSERT INTO gyz_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Na̱k ɗe Yehudasi ka̱ ɗe ma̱n ngipti wulpi gwasa̱n wu, yek jon ka̱ mil lishtisi da̱m gwa gwe Yesu nit ma hwiti ɗe ta̱s wul ilgwe sa̱ lami ɗe ga̱ biki wu ka̱n, sogo ɗe ta̱s ba̱l ilgon ma̱n la̱shi wul. ");
INSERT INTO gyz_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ta̱ na̱ma kanti nak burodisi yek ta yili. Ka̱ sa'i gwisi wo a gas ka̱ ɓali. ");
INSERT INTO gyz_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ɗe Yehuda zigaa wugo yek Yesu dla̱m ɗe, <<Ninge ka̱n sa̱ nalli Yen ga̱ Mbala̱n, yek sa̱ nalli Nya tumalti pak. ");
INSERT INTO gyz_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɗe kume Nya mbi nalti tumalti wugo, to, apaa Nya gaa gwas ba̱l Yeni nalti a Yeni mbi nalti ba̱le-ba̱le. ");
INSERT INTO gyz_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","<<Mil jini, da̱mti gi sukkii wo ga̱ nak njet sa'i ka̱ ɓali. Na̱k gwe a hwi ma̱n Yehuda ɗe, lu gwe ba li go kaa man la̱t sowu, na̱k gwisi ka̱n a nikii ma dla̱mti ninge ɗe, kaa ngo lu gwe ani wu. ");
INSERT INTO gyz_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","<<Pyal mba̱t ga̱ɓa ka̱n a nikii ma ba̱lti ɗe lama̱n yilkeni jwaka̱n. Na̱k kangwe a lamkii wu, na̱k gwisi ka̱n kii mago lama̱n yilkeni jwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tu ten na̱k gwisi ka̱n mas mbala̱n a yisi ɗe, kii wo mil lishti ji ka̱n, ɗe kume ka̱a̱ lam yilkeni jwaka̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yek Siman Biturus ngemti ɗe, <<Bagaa a ako ka̱n ka li ko?>> Yek Yesu ballit ɗe, <<Lu gwe ba li go ka man kop gi na̱k ninge so, ama ka̱ kaali wo ka koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Yek Biturus ngemti ɗe, <<Bagaa, Yek laki ɗe ba man kopti gwa ninge so ye? Ai, ba ba̱la̱n mbadl gini ten bi gwa.>> ");
INSERT INTO gyz_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yek Yesu ballit ɗe, <<Ase ka ba̱la̱n mbadl gwa ten bi gi nwa? Gem amik ka hwik ge, ka nge yisti gini asa̱mi ɗe mekan aba̱ gunda kol ɓo lak yal so! ");
INSERT INTO gyz_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","<<Ba̱ ilgon hwotkii so. Ba̱la̱n gem na̱ Nya a ka̱a̱ ba̱l gem na̱ ami pak. ");
INSERT INTO gyz_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ka̱ lubii ga̱ Aba gi wo lu da̱mti ni ɗa wonti ɗe na̱k gwisi kani sogo, da ba hwikii nu so. Ba to ka̱li a tok la̱ka̱mikii lu. ");
INSERT INTO gyz_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kume ɗe a to yek a la̱ka̱mikii lu wugo, ba pali a yemkii to mala̱n ka, ten ɗe ta̱k da̱ma̱n ka̱ lu gwe ani wu. ");
INSERT INTO gyz_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ai, lu gwe ba li go ka̱ yisa̱n tantu la̱ti.>> ");
INSERT INTO gyz_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yek Tomas wul Yesu ɗe, <<Bagaa, ai ma̱ yisa̱n lu gwe ka li wu so, ɗa̱ni ka̱n ma yis tantu la̱t ka̱li gwi?>> ");
INSERT INTO gyz_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yek Yesu ballit ɗe, <<Amik ɗe tantui, amik ɗe gemi a mik ɗe mbadli pak. Ba ma̱lgwe a man la̱t mal Aba wu se ta̱ koɓi tu mala̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ɗe da gem ka̱a̱ yisa̱n go, da kaa yis Abe pak. A na̱k ningo ka̱a̱ yisti wi, a ka̱a̱ yenti wi pak.>> ");
INSERT INTO gyz_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yek Pilip wulti ɗe, <<Bagaa, mbokini ang ten Abe, kume ka̱ pa̱li nugo ma̱ mbi ilgwe ma̱ lami wu yi.>> ");
INSERT INTO gyz_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yek Yesu ballit ɗe, <<Na̱k kangwe a da̱m sukkii ga̱ tlal sa'i nugo ama hal ninge yek ba̱ka̱ ɓo yisa̱n sa Pilip? Mas ma̱lgwe yena̱n wugo ma̱li yen Abe wi. Ɗa̱ni ka̱n ka wule, <Mbokini ang ten Abe gwi?> ");
INSERT INTO gyz_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ka̱ ba̱la̱n gem ɗe ani ka̱ Abe, a Abe ni ka̱ ami so nwa? Ai, ga̱ɓa gwe a nikii ma dla̱mti go na̱ iko ga̱ gaa gi ka̱ so. Ama Abe ɗe ta̱ni ka̱ ami wu ka̱ na̱ma pa̱lti wul jwasi. ");
INSERT INTO gyz_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ba̱la̱n gem na̱ ami ɗe a dla̱m ɗe ani ka̱ Abe a Abe ni ka̱ ami wu, sogo ba̱la̱n gem ten bi ga̱ wul ngipti bi ang jwe a pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Gem amik ka hwikii ge, mas ma̱lgwe na̱ma nga̱sti gwas tena̱n go ta pa̱l wul jwe a na̱ma pa̱lti wu. Hal ta pa̱l kiɗi wul jwe kiɗi man jimi wu, ten ɗe ba to mal Aba. ");
INSERT INTO gyz_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mas ilgwe ka̱a̱ ngemi ka̱ shin gi go ba pa̱li, ten ɗe ta̱ Abe mbi nalti tumal Yeni. ");
INSERT INTO gyz_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ko yek ka̱a̱ ngemi ka̱ shin gi go ba pa̱likii. ");
INSERT INTO gyz_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","<<Kume ka̱a̱ lama̱n go kaa kop mba̱t ga̱ɓa gini. ");
INSERT INTO gyz_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","A ba ngem Aba, ata̱ ba̱lkii Ma̱n Za̱t Ang ti ne go ta da̱m sukkii ba pakti. ");
INSERT INTO gyz_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tik ɗe Shishi ga̱ gem, gwe ba̱ dii atl a man kanti gwas so ten ɗe dii atli ɓo taɓa yenti gwas so a ba̱ta̱ yisti so. Ama kii wo ka̱a̱ yisti wi, ten ɗe ta̱ na̱ma da̱mti sukkii, a ta da̱m ka̱ mbadl gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ba zakkii na̱k ma̱jwe ma̱n za̱t jwasa̱n ma̱sh ka̱wu so, ba tul malkii. ");
INSERT INTO gyz_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nak njet sa'i ka̱ ɓali a ba̱ dii atl a po yena̱n so, ama kii wo kaa yena̱nni. Ten ɗe mbadl ni ɗa, kii mago kaa da̱m na̱ mbadl pak. ");
INSERT INTO gyz_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ten cin gwisi ka̱n kaa yisi ɗe ani ka̱ Aba gini, a kii wo ka̱a̱ ni ka̱ ami, a ami mago ani ka̱ kii. ");
INSERT INTO gyz_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mas ma̱lgwe yis mba̱t ga̱ɓa jini ata̱ na̱ma kopti go tik ɗe ma̱lgwe lama̱n wu. A ma̱lgwe lama̱n go Aba gi a lamti, a ami mago ba lamti a mbokit ang ten gaa gini.>> ");
INSERT INTO gyz_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yek Yehuda (ba̱ ɗe Yehuda Iskariyoti so) wulti ɗe, <<Bagaa, yek laki ɗe mi ka̱n ka mbokini ang ten gaa gwa, ama ba̱ ɗe dii atl ka̱n ka mbokisi ang ten gaa gwa so ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yek Yesu ballit ɗe, <<Mas ma̱lgwe lama̱n go, ta kop wul jwe a mbok ang dani wu. A Aba gi a lamti, ma tul malti a ma̱ da̱m sukti. ");
INSERT INTO gyz_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma̱lgwe lama̱n so go ba̱ta kop wul jwe a mbok ang dani wu so. Ga̱ɓa jin ɗe ka̱a̱ na̱ma kumti go, ga̱ɓa ga̱ gaa gi ka̱ so, ama ga̱ɓa ga̱ Abe ɗe ta̱ shina̱n sut wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","<<A dla̱mikii mas ga̱ɓa jimi a yi sukkii. ");
INSERT INTO gyz_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ama Ma̱n Za̱t Ang gwe tik ɗe Shishi ga̱ Nya, ɗe Aba a shinti sut ka̱ shin gi wu, tik ka mbokikii ang ten mas wul ata̱ daamikii mas wul jwe a dla̱mikii wu. ");
INSERT INTO gyz_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","A nima zakti gwaka̱n ka̱ ta̱mi da̱mti, ta̱mi da̱mti gi ka̱n a nikii ma ba̱lti. Ba̱ na̱k kangwe a dii atl ba̱li wu ka̱n a nikii ma ba̱lti so. Ba̱k hwota̱n gaa gwaka̱n so ba̱ ɓanti cikii so. ");
INSERT INTO gyz_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","<<Ka̱a̱ kuma̱n ten dla̱mti ɗe, <Ba zigaa ka a ba ya pal sut malkii ɗa.> Ɗe kume ka̱a̱ lama̱n go, kaa pa̱l hwol tuki ten ɗe ba to mal Aba, ten ɗe Abe mana̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A, ningo a dla̱mikii wi tun a ba̱ ɓo pi so, ten ɗe sa'i gwe pi wugo aka̱a̱ ba̱l gem. ");
INSERT INTO gyz_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ba po dla̱mikii wonti ga̱ɓa so, ten ɗe ma̱n guu ga̱ dii atl ga̱n nima tulti, ama iko nit ɗa tena̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ami wo a na̱ma pa̱lti ilgwe Aba hwi ɗe ta̱ pa̱li wu ndakce, ten ɗe ta̱ dii atl yisi ɗe a lam Abe. <<To, tla̱nnya ma̱ zaka̱n lu ga̱n. ");
INSERT INTO gyz_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","<<Amik ɗe tlindi inabi ga̱ gem, a Aba gi wo tik ɗe ma̱n kolti zhimi. ");
INSERT INTO gyz_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mas yen angtlindi gwe ni ten ami ɗe ba̱ta wut mil sowu ata̱ wotl ka, ama mas yen ami gwe a wut mil go ata̱ mba̱l la̱ka̱nti ka ten ɗe ta̱ mba̱l wut mil i'e ɗa. ");
INSERT INTO gyz_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ko ta̱ na̱k ninge mago sabta nikii ɗa ten bi ga̱ ga̱ɓa gwe a dla̱mikii wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sa ten dli gini, ami mago ten dli gwaka̱n. Na̱k kangwe a ba̱ yen angtlindi inabi a man wutti mil so seko kume ɗe ta̱ni ten dli ga̱ tlindi inabisi wu, nu ka̱n kii mago kaa mani so seko kume ɗe ka̱ni ten dli gi wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","<<Amik ɗe tlindi inabi, a kik ɗe mil ami. Ma̱lgwe sa ten dli gini, yek a sa ten dli gwas go, ma̱li ka wut wonti mil, ten ɗe kume ɗe ba̱ suk ami ka̱ so go kaa man pa̱lti ilgon so. ");
INSERT INTO gyz_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mas ma̱lgwe sa ten ami sogo, ma̱li ni na̱k yen angtlindi gwe sa̱ wotl ka yek nko ka̱wu. A mbala̱n moo wunda̱l ji mil angtlindi jwisi asa̱ wut ka̱ wutu asa̱ kweli ka. ");
INSERT INTO gyz_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Kume ɗe ka̱a̱ sa ten dli gini yek ga̱ɓa gi sa ka̱ kii go, kaa ngem mas ilgwe ka̱a̱ lami wu asa̱ pa̱likii. ");
INSERT INTO gyz_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pa̱la̱n hwa da̱mti wunda̱li gwe a mbok ang ɗe kii wo mil lishti ji ka̱ɗe kii wu, ten ɗe yek ɗe ilgwe a tulli nalti Aba gi wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","<<Na̱k kangwe Aba lama̱n wu, na̱k gwisi ka̱n a nima lamti gwaka̱n. To, se ta̱k da̱ma̱n ka̱ lamti gwe a nikii ma pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ami wo a kop mba̱t ga̱ɓa ga̱ Aba gini a da̱m ka̱ lamti gwasi. Na̱k gwisi ka̱n kaa da̱m ka̱ lamti gini ɗe ka̱a̱ kop mba̱t ga̱ɓa gi wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A dla̱mikii gwisi ka̱n ten ɗe ta̱ pa̱lti hwol tuk gi da̱m ka̱ kii, a pa̱lti hwol tuk gwaka̱n njika̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mba̱t ga̱ɓa gi ka̱ɗe, ta̱k lama̱n yilkeni jwaka̱n na̱k kangwe a lamkii wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lamti gon man lamti ga̱n so, ɗe ta̱ mbala̱n ba̱l mbadl gwas ten bi ga̱ yela̱n gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Kii wo yela̱n ji ka̱n ɗe kume ka̱a̱ pa̱l ilgwe a wulkii ɗe ta̱k pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ba po mbekii ɗe zhel so, ten ɗe zhel yis ilgwe a ba boo gwas pa̱li wu so. Ama a na̱ma mbet gwaka̱n ɗe yela̱n jini ten ɗe a dla̱mikii mas ilgwe a kumi mal Aba gi wu wi. ");
INSERT INTO gyz_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Kiik botla̱n so ama amik botlkii, yek a lakkii ta̱k pa̱la̱n hwa da̱mti na̱k tlindi ma̱n wutti mil jwe ba̱ a paki sowu. Apaa Abe ba̱lkii mas ilgwe ka̱a̱ ngemi ka̱ shin gi wu. ");
INSERT INTO gyz_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mba̱t ga̱ɓa gwe a zikii wu ka̱ɗe, ta̱k lama̱n yilkeni jwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","<<Kume ɗe dii atl nge kii go, yisi ɗe da go ta̱ nge pa yek ta̱ nda nget gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Da kume kii wo ga̱ dii atl kani go, da dii atli a lam ilgon gwasi, ama ten ɗe kii wo ga̱ dii atl ka̱ so, a botlkii tet ka̱ dii atli, yek laki yek dii atli nima nget gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Daama̱n ilgwe a dla̱mikii wu ɗe, <Ba̱ zhel a man bagaa gwas so.> Kume sa̱ ci dlelngapcan go, kii mago sa cikii dlelngapcan pak. Da kume sa̱ kop ga̱ɓa gi go, da sa kop ga̱ɓa gwaka̱n pak. ");
INSERT INTO gyz_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Sa pa̱likii mas wul jimi ka̱n ten bi ga̱ shin gini, ten ɗe sa̱ yis ma̱lgwe shina̱n sut wu so. ");
INSERT INTO gyz_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Da ba tuli yek a dla̱misi ga̱ɓa sogo, da byas wul a nisi gaa so. Ama ningo hujja nisi ɗa ten bi byas wul gwasa̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mas ma̱lgwe nge go, ma̱li nge Aba gi pak. ");
INSERT INTO gyz_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","A pa̱l wul wonti ka̱ dlo gwasa̱n, wul jwe ba̱ ma̱lgon ɓo ta̱ ɓa pa̱lti so wu. Ɗe da a wule a pa̱la̱n wul jwisi so go, da byas wul a nisi gaa so. Ama ningo sa̱ yen wul ngipti ang bi jwe a pa̱li wu, ama mas na̱k gwisi yek sa̱ ngeni yek sa̱ nge Aba gi pak. ");
INSERT INTO gyz_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gwisi pi ka̱n ten ɗe ta̱ njika̱n ga̱ɓa gwe ni lishi ka̱ mba̱t ga̱ɓa gwasa̱n wu ɗe, <Sa̱ ngeni ten koo lu.> ");
INSERT INTO gyz_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Ba shinikii lu sut na̱ Ma̱n Za̱t Ami, ta yil sut mal Abe ata̱ susut malkii. Tik ɗe Shishi ga̱ gem gwe a yil sut mal Abe wu, tik ka dla̱m ga̱ɓa tena̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A kii mago sheda ka̱n ten ɗe tun tet ten ndat zhile ka̱n ka̱a̱ ni suk ami. ");
INSERT INTO gyz_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","<<A dla̱mikii mas wul jimi ka̱n ten ɗe ba̱k pala̱n na̱ kaal ten bi ba̱lti gem gwaka̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Sa mbolkii ɗa̱ka̱ lu motgaa jwasa̱n ka. Gem sa'i yi teɗi gwe ɗe mas ma̱lgwe tlokii wu a da̱m gwa we Nya ka̱n ta̱ nit ma pa̱lti wul wu. ");
INSERT INTO gyz_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Sa pa̱li na̱k gwisi ka̱n ten ɗe sa̱ yis Aba so a ba̱sa̱ yisa̱n so pak. ");
INSERT INTO gyz_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A dla̱mikii wul jimi ka̱n ten ɗe kume sa'i pa̱t jwasa̱n pi wugo a ka̱a̱ daami ɗe a dla̱mikii wi. ");
INSERT INTO gyz_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","<<Ningo a ɓa to mal ma̱lgwe shina̱n sut wu. Ama mas na̱ na̱k gwisi yek ba̱ gon gwaka̱n ngema̱n ɗe, <A ako ka̱n ka li ko so?> ");
INSERT INTO gyz_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Mbadl jwaka̱n njika̱n na̱ duu tuki ten ɗe a dla̱mikii wul jimi. ");
INSERT INTO gyz_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ama gem amik ka hwikii ge, za̱tgaa gi a manikii mani, ten ɗe Ma̱n Za̱t Ang gwisi a tul so ɗe kume a zigaa sowu. Ama kume a zigaa wugo ba shinikii lu sut na̱ ti. ");
INSERT INTO gyz_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Sa'i gwe Ma̱n Za̱t Ami tul wugo ta mboki ang dii atl ɗe daamti gwasa̱n ten bi byas wul, suk palti wul ndakce, suk kisti ga̱ɓa wo ndakce ka̱n ni so. ");
INSERT INTO gyz_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Daamti gwasa̱n ten byas wul ni ndakce so ten ɗe sa̱ nge ba̱lti gem tena̱nni, ");
INSERT INTO gyz_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Daamti gwasa̱n ten pa̱lti wul ndakce ni ndakce so ten ɗe ba to mal Aba gini aba̱ kaa ci cina na̱ yenti gi so. ");
INSERT INTO gyz_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Daamti gwasa̱n ten kisti ga̱ɓa ni ndakce so ten ɗe sa̱ kisi ga̱ɓa ma̱n guu ga̱ dii atl ga̱n wi. ");
INSERT INTO gyz_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Naa wul wonti jwe ba dla̱mikii wu ni ɗa ama na̱k ninge go kaa ɓo yis gaa gwasa̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ama sa'i gwe ɗe Shishi ga̱ gem tul wugo, ta mbokikii ang ten mas gem. Ten ɗe ga̱ɓa ga̱ gaa gwas ka̱n ta dla̱m so, ama ilgwe ta̱ kumi wu ka̱n ta̱ dla̱mi ata̱ hwikii wul jwe a pi wu. ");
INSERT INTO gyz_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ta ba̱la̱n nalti ten ɗe ilgwe a hwit wu ka̱n ta dla̱mikii. ");
INSERT INTO gyz_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mas wul jwe ni Aba ɗa̱ go gi ka̱n. Yek laki yek a dla̱m ɗe Shishi a kan wul jwe a hwit wu a ta̱ dla̱mikii. ");
INSERT INTO gyz_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","<<Kaal ɗa̱ nak sa'i gon wo kaa po yena̱n so, ama kaal ɗa̱ nak sa'isi gon wo kaa po yena̱n ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yek jon ka̱ mil lishtisi hwi yilkeni jwasa̱n ɗe, <<Yek ɗe ilgwe ta̱ na̱ma mbokti ang dani wu, ɗe ta̱ wule, <Kaal ɗa̱ nak sa'i gon wo kaa po yena̱n so, ama kaal ɗa̱ nak sa'isi gon wo kaa po yena̱n ɗa̱ wu ye?> A yek ɗe ilgwe ta̱ na̱ma mbokti ang dani wu, ɗe ta̱ wule, <Ten ɗe ba to mal Aba wu ye>?>> ");
INSERT INTO gyz_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yek sa̱ ngusi kumti ga̱zi ɗe, <<Yek ɗe ilgwe ta̱ na̱ma mbokti ang dani wu, ɗe ta̱ dla̱m ɗe <Kaal ɗa̱ nak sa'i gon wu ye>? To, mi wo ma̱ yis gaa ga̱ ilgwe ta̱ na̱ma dla̱mti wu so.>> ");
INSERT INTO gyz_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu lak yisi ɗe mil lishti jwas na̱ma lamti ta̱s ngemti ten ga̱ɓa gwisi wugo, yek ta̱ wulsi ɗe, <<Ka̱a̱ na̱ma ngemti ji yilkeni jwaka̱n ten ilgwe a mbok ang dani wu ɗe a dla̱m ɗe, <Kaal ɗa̱ nak sa'i gon wo kaa po yena̱n so, ama kaal ɗa̱ nak sa'isi gon wo kaa po yena̱n ɗa̱ wu nwa>? ");
INSERT INTO gyz_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gem amik ka hwikii ge, kaa kuli a ka̱a̱ pa̱l duu tuki, ama dii atl a pa̱l hwol tuki. Kaa pa̱l duu tuki, ama duu tuk gwaka̱n a pal ɗe hwol tuki. ");
INSERT INTO gyz_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kume ɗe kili mbala̱n ɓa zi yen go a cit i'e ten ɗe sa'i za̱t yen gwas pi wi. Ama ɗe ta̱ pak za̱t yen wugo a cicit gwe ta̱ tla wu ma̱sa̱nit ka, ten ɗe ta njika̱n na̱ hwol tuk ten ɗe zi yen ten dii atli. ");
INSERT INTO gyz_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Na̱k gwisi ka̱n nikii pak, ningo ka̱ni ka̱ duu tuki ama ba ya yenkii ɗa, apaa ka̱a̱ pa̱l hwol tuki. A ba̱ ma̱lgon a kamikii hwol tuk gwaka̱n ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ten cin gwisi wo kaa ngemi ilgon so. Gem amik ka hwikii ge, Aba a ba̱lkii mas ilgwe ka̱a̱ ngemi ka̱ shin gi wu. ");
INSERT INTO gyz_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hal ninge ka̱a̱ ɓo ngem ilgon ka̱ shin gi so. Ngemini kaa mbi, ten ɗe ta̱ pa̱lti hwol tuk gwaka̱n njika̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","<<Koɗe a dla̱mikii ga̱ɓa na̱ cinga̱lti ga̱ɓa ten ɗe ta yillikii gaami ɗa̱ wu. Ama sa'i gwe ɗe ba dla̱mikii ga̱ɓa ten bi ga̱ Aba ten dii wu ni teɗi, aba̱ ba po dla̱mikii ga̱ɓa na̱ cinga̱lti ga̱ɓa so. ");
INSERT INTO gyz_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ten cin gwisi wo kaa ngem wul ka̱ shin gini. Kaa ngem Aba na̱ gaa gwaka̱n, amik ka ngemti ka̱ lal gwaka̱n so. ");
INSERT INTO gyz_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ten ɗe Abe na̱ gaa gwas na̱ma lamti gwaka̱n, na̱k ɗe ka̱a̱ lama̱nni yek ka̱a̱ ba̱l gem ɗe a yil sut mal Nya wu. ");
INSERT INTO gyz_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A yil sut mal Aba yek a tul ten dii atli, a ningo ba zak dii atli ta pal to mal Abe ka.>> ");
INSERT INTO gyz_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yek mil lishtisi wuli ɗe, <<Yauwa! Ningo ka̱ ɓa ga̱ɓa ten dii ca ka̱ po yi ma ga̱ɓa na̱ cinga̱lti ga̱ɓa so. ");
INSERT INTO gyz_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ningo ma̱ yisi wi ɗe ka̱ yis mas wul. Ka̱ man balla̱t ga̱ɓa ten kumti ga̱z wul tun aba̱ mbala̱n ɓo ngemki so. Ga̱mi laki yek ma̱ ba̱l gem ɗe sut mal Nya ka̱n ka̱ yili.>> ");
INSERT INTO gyz_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yek Yesu ballisi ɗe, <<Ashe ningo ka̱a̱ ba̱l gem wu nwa?>> ");
INSERT INTO gyz_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","<<To, ama sa'i aya pi, hal nin mago yek gu pi wi gwe ɗe mas jwaka̱n a ap ɗa̱nka̱ lubii jwaka̱n ka aka̱a̱ zaka̱n na̱ ngwe wu. Ama mas na̱ na̱k gwisi wo ami na̱ ngwe ka̱n ani so ten ɗe Aba ni suk ami. ");
INSERT INTO gyz_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","<<A dla̱mikii wul jimi ka̱n ten ɗe ta̱k mbi ta̱mti da̱mti ka̱ ami. Ten dii atl ga̱n go ka̱a̱ na̱ma tlat bomti, ama da̱ma̱n na̱ dlot mbadli ten ɗe a ci ba̱n ten dii atli wi.>> ");
INSERT INTO gyz_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ɗe Yesu dla̱m ga̱ɓa jimi wugo, yek ta̱ tlil gaa gwas nya, yek ta̱ ga̱ɓa suk Nya yek ta̱ dla̱m ɗe. <<Aba sa'i pi wi. Ba̱l Yen gwa nalti, kangwe Yeni a ba̱lki nalti wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ten ɗe ka̱ ba̱l Yeni iko ten mas mbala̱n ten ta̱s ba̱l mbadl ma̱n la̱shi pakti ma̱jwe ka̱ ba̱lti si wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Mbadl ma̱n la̱shi pakti ka̱ɗe ta̱ mbala̱n yiski, ki ɗe Nya ɗe Na̱m gwe ki na̱ ngwe ka̱n asa̱ ngusik atl wu asa̱ yis Yesu Almasihu gwe ka̱ shinti sut wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A ba̱lki nalti ten dii atli ten ɗe a pak pa̱lti mas wul jwe ka̱ zi wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ningo Aba, nalla̱n na̱ nalti gwe ni ɗa a malki tun ba̱sa̱ po pa̱l dii atli sowu. ");
INSERT INTO gyz_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<A mboki mbala̱n jwe ka̱ ba̱la̱nsi ten dii atl wu ang tenki wi. Tun tek go si wo jwaka̱n, yek ka̱ ba̱la̱nsi a yekgu sa̱ kop ga̱ɓa gwa wi. ");
INSERT INTO gyz_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Yek ningo sa̱ yisi ɗe mas ilgwe ɗe ka̱ ba̱la̱n go tet malki ka̱n ni. ");
INSERT INTO gyz_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ten ɗe ga̱ɓa gwe ka̱ hwi go a dla̱misi yek sa̱ kan wi, yek sa̱ yisi ɗe gem tet malki ka̱n a yil suɗi, yek sa̱ ba̱l gem ɗe kik shina̱n suɗi. ");
INSERT INTO gyz_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","A na̱ma ngemti gwa ten bi gwasa̱n. Ba̱ ɗe ten bi ga̱ ma̱n dii atl ka̱n a na̱ma ngemti gwa so, ama ten bi ga̱ mbala̱n jwe ka̱ ba̱la̱nsi wu, ten ɗe si wo mbala̱n jwa ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ai mas ilgwe ni ɗa̱ go gwaka̱n, a mas ilgwe nik ɗa̱ go gi ka̱n. Asa̱ na̱ma yenti nalti gini tumal wul jwisi. ");
INSERT INTO gyz_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","A na̱ma la̱t malki ba po ci cina na̱ da̱mti ten dii atl ga̱n so. Ama si wo sa̱ yi ten dii atli ɗa̱ paa. A Aba Ma̱n Cilti, katisi ang gaa na̱ nda̱lti ga̱ shin gwa gwe yek ɗe shin gwe ka̱ ba̱la̱nni ten ɗe si mago ta̱s da̱m ɗe na̱m na̱k kangwe ani sukki wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sa'i gwe a yi suksi go, a katisi ang gaa na̱ nda̱lti ga̱ shin gwa, gwe yek ɗe shin gwe ka̱ ba̱la̱n wu. A a katisi ang gaa ko gon gwasa̱n gil ka̱ so, seko ma̱lgwe sa̱ botlti ɗe ta̱s lilti ka̱wu na̱k gwisi pi na̱k kangwe ga̱ɓa ga̱ Nya dla̱m wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","<<Ningo a ɓa to malki, ama a na̱ma ngemti wul jimi ka̱n a yi ten dii atli, ten bi ga̱ ma̱n kopti ji je ta̱s mbi wuda̱l ga̱ hwol tuk gi i'e ka̱ mbadl gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A dla̱misi ga̱ɓa gwa yek dii atl ngesi ten ɗe si wo mbala̱n ji dii atl ka̱ so na̱k kangwe ami mago ba̱ ga̱ dii atli ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ba̱ ɗe we a na̱ma ngemti gwa ten ɗe ta̱k yemsi ɗa̱ ten dii atl ka ka̱ so, ama a na̱ma ngemti gwa ka̱n ten ɗe ta̱k te ka̱ dlo gwasa̱n suk Ma̱n Ngalci wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Si wo ga̱ dii atl ka̱ so na̱k kangwe ami mago ga̱ dii atli ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Palla̱si ɗe ma̱jwe sa̱ ɓantik wu tumal gem ga̱ɓa gwa ka̱ ɗe gemi. ");
INSERT INTO gyz_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","A shinsi ten dii atli na̱k kangwe ka̱ shina̱n sut wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","A ɓantik ka̱ damti gini ten bi gwasa̱n, ten ɗe ta̱s da̱m ɗe ma̱jwe ba̱ntik wu ga̱ gem. ");
INSERT INTO gyz_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","<<A ba̱ si na̱ ngusa̱n ka̱n a nisi ma ngemti so. Ama a nima ngemti gwa ten bi ga̱ mas ma̱jwe sa ya ba̱l gem tumal ga̱ɓa gwasa̱n wu, ");
INSERT INTO gyz_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aba a na̱ma ngemti gwa ten ɗe ta̱s da̱m ɗe na̱m mas jwasa̱n. Na̱k kangwe ka̱ ni ka̱ ami, a ammago ani ka̱ ki wu. A na̱ma ngemti gwa ɗe ta̱k laki ta̱s da̱m ka̱ mi ten ɗe ta̱ mbala̱n ji dii atl ba̱l gem ɗe kik shina̱nni. ");
INSERT INTO gyz_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ami wo a ba̱l mbala̱n jimi nalti gwe ka̱ ba̱la̱n wu, ten ɗe ta̱s da̱m ɗe na̱m na̱k kangwe ma̱ ni ɗe na̱m wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ba da̱m ka̱si a ki wo ka̱ ni ka̱ ami ten ɗe ta̱s da̱m ɗe na̱m i'e ɗa, kangwe mbala̱n a yisi ɗe kik shina̱n sut wu asa̱ yisi ɗe ka̱ lamsi na̱k kangwe ka̱ lama̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","<<Aba a na̱ma lamti ɗe ta̱ mbala̱n jin ɗe ka̱ ba̱la̱n wu da̱m suk ami ka̱ lu gwe ani wu. A na̱ma la̱mti ta̱s yen nalti gwa, nalti gwe ka̱ ba̱la̱nni ten ɗe ka̱ lama̱nni tun a ba̱sa̱ ɓo pa̱l dii atl sowu. ");
INSERT INTO gyz_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","<<Aba Ma̱n Pa̱lti Wul Ndakce, mbala̱n ji dii atl yiski so, ama ami wo a yiski a mbala̱n je ne go sa̱ yisi ɗe kik ɗe ma̱lgwe shina̱n sut wu. ");
INSERT INTO gyz_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A mbokisi ang ten kangwe ka̱ ni wu, a ba ngusisi mbokti ang tenki, ten ɗe ta̱ lamti gwe ka̱ lama̱n wu da̱m ka̱ ka̱si, a ami wo ka̱si.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ɗe Yesu pak ngemti Nyami wugo, yek ta̱ koɓi ga̱z za̱nda̱l Kidiron yek ta̱ li ten ka̱ ga̱ tekgu suk mil lishti jwasi. A ten ka̱ti gwisi wo a zhin inabi gon ni ɗa, yek Yesu suk mil lishti jwas te giɓi. ");
INSERT INTO gyz_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","A Yehuda, ma̱lgwe ba̱l bi ga̱ Yesu wu yis luisi, ten ɗe Yesu ku na̱ la̱t ka̱li suk mil lishti jwas wi. ");
INSERT INTO gyz_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yek Yehuda tulli motgaa ga̱ man hapti dlo suk ma̱n ɓa̱tti lubii ga̱ Nya jwe kiɗi ji ma̱n Pa̱ris suk ma̱n Parisi shinsi ka̱ zhimi. A motgaa ji mbala̱mi ni na̱ pitilla suk wutu ga̱ ɓa̱si ten mamo suk wul dlanti ɗa̱nka̱ ang jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na̱k ɗe Yesu yis mas ilgwe a pi na̱ti wugo, yek ta̱ yil toɗi yek ta̱ ngemsi ɗe, <<Wok ka̱ na̱ma ngot gwas wo?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yek sa̱ ballit ɗe, <<Yesu ga̱ Nazarat.>> Yek ta̱ wulsi ɗe, <<Amik ɗe Ti.>> (A Yehuda ma̱n ba̱lti bi gwas wu ni a nya suksi ka̱li.) ");
INSERT INTO gyz_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ɗe Yesu dla̱m ɗe, <<Amik ɗe ti,>> wugo, yek mbala̱mi pal na̱ kaali hal yek sa̱ lok te atl ka. ");
INSERT INTO gyz_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yek Yesu po ngemsi ɗa, <<Wok ka̱ na̱ma ngot gwas wo?>> Yek sa̱ wulti ɗe, <<Yesu ga̱ Nazarat.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yek Yesu ballisi ɗe, <<A hwikii ɗe amik ɗe ti. Kume ɗe ami ka̱n ka̱ na̱ma ngot gi go, to zaka̱n mbala̱n jimi ta̱s zigaa.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ilga̱mi ɗe pi go ndakce ka̱n ni na̱ ilgwe Yesu dla̱m wu, ten ɗe tek ɗe ta̱ na̱ma gemti Nya go ta̱ wuli ɗe, <<Ka̱ mbala̱n jwe ka̱ ba̱la̱n go ko ɗena̱m gil ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na̱k ɗe bal puka ni Siman Biturus ɗa̱ wu yek ta̱ yilli toɗi, yek ta̱ wotl zhel ga̱ bacina ga̱ ma̱n Pa̱ris, hal yek ta̱ kotlit ka̱ng ga̱ tu ang shinti ka. (Shin ga̱ zhel gwisi ka̱ɗe Malkus.) ");
INSERT INTO gyz_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yek Yesu wul Biturus ɗe, <<Palli puka gwa ka̱ ka̱pta̱mi. Ba tla wul ga̱ buka gwe Aba ba̱la̱n ɗe ta tla wu sa?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yek motgaa ga̱ ma̱n hapti dlomi suk bacina gwasa̱n suk ma̱n ɓa̱tti lubii ga̱ Nya dop Yesu yek sa̱ ɓalit ang ka. ");
INSERT INTO gyz_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yek sa̱ nde na̱ ta̱lat gwas mal Anana, ma̱lgwe tik ɗe nkwe ga̱ Kayapa wu. A Kayapa ka̱ɗe bacina ga̱ ma̱n Pa̱ris ten gini gwisi. ");
INSERT INTO gyz_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayapa ka̱ɗe ma̱lgwe ba̱l shawori ma̱n Yehuda ɗe, a mbun mani ɗe kume mbala̱n ɗena̱m a ma̱sh ten bi ga̱ naa mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yek Siman Biturus suk gon ka̱ mil lishtisi kop kaal ga̱ Yesu. Na̱k ba̱cina ga̱ ma̱n pa̱risi yis yen lishti gwisi wu, yek ta̱ te gibboo ga̱ diiboo ga̱ bacinesi suk Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ama yek Biturus dla̱l a deɓa̱l ten bi dlabii. Yek yen lishti gwisi ɗe bacina ga̱ ma̱n Pa̱risi yisti wu, pal teɗi yek ta̱ ga̱ɓa suk yen kili ma̱n ɓa̱tti bi dlabimi yek paa ta̱ tel Biturus gibboomi. ");
INSERT INTO gyz_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yek yen kili ma̱n ɓa̱tti dlaboomi ɗe ta̱ni ten bi dlaboomi wu ngem Biturus ɗe, <<Anya! Ki mago gon ka̱n ka̱ mil lishti ga̱ ma̱llu so nwa?>> Yek Biturus ballit ɗe, <<Wowo ani ka̱si so.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A lu nda̱ɗi ka̱ wi, ten na̱k gwisi ka̱n yek ma̱n pa̱lti wul suk ma̱n ɓa̱tti lubiimi hot wutu, yek sa̱ dla̱l nya ten kumti. Biturus mago ta̱ dla̱l nya suksi ata̱ nima kumti wuti. ");
INSERT INTO gyz_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yek bacina ga̱ ma̱n Pa̱ris ngusi ngemti ga̱ Yesu ten bi ga̱ mil lishti jwasi suk mbokti ang ten wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yek Yesu ballit ɗe, <<Ai ten dii ka̱n a dla̱m ga̱ɓa, a cina ga̱ ko wokko ka̱n a mboki ang mbala̱n ten wul ɗa̱nka̱ lu motgaa ga̱ ma̱n Yehuda suk lubii ga̱ Nya ka. A dla̱m ilgon ga̱ hwunda̱li so. ");
INSERT INTO gyz_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Yek laki ɗe ka̱ na̱ma ngemti gi ye? Ai, se ta̱k ngem ma̱jwe sa̱ kuma̱n wu, ten bi wul jwe a dla̱misi wu ten ɗe sa̱ yis ilgwe a dla̱m wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ɗe Yesu dla̱m nu wugo, yek gon ka̱ ma̱n ɓa̱tti lubii ga̱ Nya gwe ta̱ni nya njaa wu ɓe kalka̱ng Yesu. Yek ta̱ wulti ɗe, <<Nu ka̱n ka balli bacina ga̱ ma̱n Pa̱ris a?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yek Yesu ballit ɗe, <<Ɗe kume a dla̱m ilgwe ni ndakce sogo, to se ta̱k mboki ang dani. Ama kume ilgwe a dla̱m go gem ka̱ wu, to, yek laki yek ka̱ ɓe kalka̱ng ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yek Anana laki yek sa̱ ta̱la Yesu na̱ ang gwas ga̱ ɓali ka mal Kayapa bacina ga̱ ma̱n Pa̱ris. ");
INSERT INTO gyz_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Na̱k ɗe Siman Biturus yi nya ten kumti wutu ka̱li wu, yek ma̱jon po ngemti ɗa, yek sa̱ wule <<Anya! Ki mago ka̱ mil lishti jwas ka̱n ka̱ni sa?>> Yek ta̱ nge yisti, yek ta̱ wuli ɗe, <<Ani ka̱si so.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","A gon ka̱ zhel ji bacina ga̱ ma̱n Pa̱risi ni ɗa. Zhel gwisi wo yas ga̱ ma̱lgwe Biturus kotlit ka̱ng ka̱wu ka̱n, yek ta̱ wul Biturus ɗe, <<Ale, ki ka̱n a yenki sukti ka̱ zhin wu na̱?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yek Biturus po nge yis ɗa. Njet nugo yek gunda kol lak yal. ");
INSERT INTO gyz_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ka̱ bultlwe, yek sa̱ yilli Yesu ɗa̱ ka̱ lubii ga̱ Kayapa ka, yek sa̱ ta̱lat dlaboo ga̱ gobna ga̱ ma̱n Roma. Ama yek ma̱n Yehuda nge tet ka̱ dlaboo ga̱ guumi, ten ɗe sa lak duka̱n dli jwasa̱n a cina ga̱ Nya ka̱ ɗa, hal a laki a ba̱sa po nguk ilga̱ nguki ga̱ Biki Ɗakcitisi so. ");
INSERT INTO gyz_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ten na̱k gwisi ka̱n yek Bilatus yil tot deɓa̱l ta̱s mbisi, yek ta̱ ngemsi ɗe, <<Ɓohwe ten bi ga̱ yek ka̱a̱ ta̱la ma̱lga̱mi tet dlaboo gi ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yek sa̱ ballit ɗe, <<Ɗe da ta pa̱l byas ilgon sogo, ai, da ma ta̱lati tet malki so.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yek Bilatus wulsi ɗe, <<Kama̱nti kii na̱ gaa gwaka̱n ta̱k pa̱liti kisti ga̱ɓa na̱ mba̱t ga̱ɓa gwaka̱n la.>> Yek ma̱n Yehuda ballit ɗe, <<Ai, sa̱ ba̱la̱nni iko ta̱n ndoka̱li ma̱lgon kisti ga̱ɓa ga̱ tlot mbala̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ɗe ilga̱mi pi wugo yek ni ndakce suk ilgwe Yesu dla̱m wu, ga̱ɓa gwe mbok ang ten wunda̱l ga̱ ma̱shka̱n gwe ta pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Yek Bilatus pal te lubii ga̱ guu ka, yek pa ta̱ mbe Yesu yek ta̱ ngemti ɗe, <<Kik ɗe guu ga̱ ma̱n Yehuda a?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yek Yesu ngemti ɗe, <<Kumti ga̱zi ga̱mi ɗe ka pa̱li go, ga̱ daamti ga̱ mbadl gwa ka̱ nwa ko ma̱jon ka̱ dla̱mik ga̱ɓa tena̱nni?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Yek Bilatus ballit ɗe, <<Ai, ami wo ma̱n Yehuda ka̱ɗe ami so, mbala̱n jwa suk kiɗi ji ma̱n Pa̱ris ka̱ ta̱lak tet mala̱nni. Yek ka̱ pa̱li ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yek Yesu wuli ɗe, <<Guu gi wo ga̱ dii atl ga̱n ka̱ so. Ɗe da guu gi wo ga̱ dii atl ga̱n kani go, da ma̱jwe asa̱ pa̱li wul wu a dlansi ten ɗe ba̱ ma̱n Yehuda doɓa̱n so. Ama guu gi wo tet ka̱ lu gon ka̱n ni.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yek Bilatus wule, <<Ase ki wo guu ka̱ a?>> Yek Yesu ballit ɗe, <<Ki na̱ gaa gwa ka̱n ka̱ dla̱m ɗe ami wo guu ka̱n. Gwisi ka̱ɗe ilgwe laki yek sa̱ za̱n wu, a yek ɗe ilgwe laki yek a tul ten dii atli wu, ten ɗe ta ba̱l sheda ten gem. A mas ma̱lgwe ɗe ti wo ga̱ gem ka̱ go ata̱ kati ka̱ng yal gini.>> ");
INSERT INTO gyz_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Yek Bilatus ngemti ɗe, <<Yek ɗe gem ye?>> Ɗe ta̱ dla̱m nu wugo yek ta̱ yil to mal ma̱n Yehuda ka, yek ta̱ wulsi ɗe, <<Ami wo a mbit na̱ byas ilgon gaa so. ");
INSERT INTO gyz_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ama kwikii dani wi ɗe sa'i Biki Ɗakcitisi ka̱ ɓal go a ɓulikii ma̱l ga̱ le ka ɗe na̱m. To ka̱ na̱ma lamti ta zakikii <guu ga̱ ma̱n Yehuda nwa?> >> ");
INSERT INTO gyz_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yek sa̱ tlil yal nya yek sa̱ ballit ɗe, <<Wowo, ma̱l gwisi ka̱n ka zakini ti so, seko ta̱k zakini Barabas!>> A Barabas wo muka̱l ma̱n ɓa̱tti tantu ka̱ɗe ti. ");
INSERT INTO gyz_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yek Bilatus laki yek sa̱ ɓo Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yek ma̱n hapti dlo pi tagiya guu gon na̱ ili yek sa̱ kini Yesu ten gaa. Yek paa sa̱ lakit zil luka̱l gon, wunda̱li ji guu. ");
INSERT INTO gyz_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Yek sa̱ ngusi la̱t malti asa̱ nit ma ɓot kalka̱ng asa̱ na̱ma wulti ɗe, <<Na̱ nalti gwa, guu ga̱ ma̱n Yehuda!>> ");
INSERT INTO gyz_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yek Bilatus po yil tot ɗa, yek ta̱ wul ma̱n Yehuda ɗe, <<Yekgu ca aɓa yilli kii Yesu toɗi ten ɗe a na̱ma lamti ta̱k yisi ɗe a mbit na̱ byas ilgon gaa so.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yek paa Yesu yil toɗi na̱ tagiya guu ga̱ ili ten gaa suk zil luka̱l. Yek Bilatus wulsi ɗe, <<To, ma̱li ka̱ wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ɗe kiɗi ji ma̱n Pa̱ris suk bacina ji mbala̱mi yenti wugo, yek sa̱ tlil yal nya asa̱ na̱ma wulti ɗe, <<Ɓaka̱nti ka! Ɓaka̱nti ka.>> Yek Bilatus ballisi ɗe, <<Kama̱nti ta̱k ɓaka̱nti ka ten guda̱l yencin. Ama ami wo a mbit na̱ pa̱lti byas ilgon so.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yek ma̱n Yehuda ngusi dla̱mti ɗe, <<Ai, mba̱t ga̱ɓa nini ɗa, a tu ten mba̱t ga̱ɓe wo ngetli ka̱n ta̱s tlot ka, ten ɗe ta̱ palli gaa gwas ɗe yen ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ɗe Bilatus kum ga̱ɓa gwisi wugo, yek ɓanti mba̱l cit gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yek ta̱ po pal te ka̱ dlaboo guu gwas ka̱ ɗa. Yek ta̱ gem Yesu ɗe, <<Ka̱ yila̱n ɗa̱ ko?>> Ama yek ba Yesu ballit ɗe ilgon so. ");
INSERT INTO gyz_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ten na̱k gwisi ka̱n yek Bilatus wulti ɗe, <<ka̱ nima nget ga̱ɓa a? Ka̱ yisi ɗe iko zakti gwa sogo ga̱ ɓakti gwa ka ten guda̱l yencin ni ɗa̱ sa?>> ");
INSERT INTO gyz_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yek Yesu ballit ɗe, <<Iko gwe nik ɗa tena̱n go iko gwe Nya ba̱lki wu ka̱n. Ma̱lgwe laka̱n ka̱ ang gwa wu manki na̱ pa̱lti byas wul.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ten ga̱ɓa gwisi ka̱n yek Bilatus lam zakti ga̱ Yesu, ama yek ma̱n Yehuda tlil yal jwasa̱n to nya ka asa̱ na̱ma wulti ɗe, <<Kume ka̱ zak ma̱lga̱n go, to ki wo yela̱n ga̱ Kaisar ka̱ so. Ai, mas ma̱lgwe palli gaa gwas ɗe guu go yela̱n dlanti ga̱ Kaisar ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ɗe Bilatus dla̱m ga̱ɓa gwisi wugo, yek ta̱ yilli Yesu toɗi. Yek Bilatusi da̱m ten gopdlan kisti ga̱ɓa gwe ni lu gwe asa̱ mbe ɗe Ye ga̱ Mbashi wu (Na̱ bi Arameya wo yek ɗe Gabata). ");
INSERT INTO gyz_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ten cin gwisi yek ɗe cin pa̱lti shiri Biki Ɗakciti ka̱ dlo cin. Yek Bilatus wul ma̱n Yehuda ɗe, <<Guu gwaka̱n ka̱ wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ama yek sa̱ tlil yal nya asa̱ na̱ma wulti ɗe, <<Tloti ka! Tloti ka! Ɓaka̱nti ka! Ɓaka̱nti ka!>> Yek Bilatus ngemsi ɗe, <<Ka̱a̱ na̱ma lamti ta ɓak guu gwaka̱n ka̱ nwa?>> Yek kiɗi ji ma̱n Pa̱ris ballit ɗe, <<Mi wo guu gon nini ɗa̱ so seko Kaisar.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Yek pa Bilatus kan Yesu yek ta̱ ba̱l ma̱n Yehuda ten ɗe ta̱s ɓakti ka ten guda̱l yencin. Ten na̱k gwisi ka̱n yek ma̱n hapti dlomi zigaa na̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yek Yesu za̱k ba̱mi ata̱ ni na̱ guda̱l yencin gwe sa̱ ɓakti ka a dani yal yek sa̱ ta̱lat ka lu gwe asa̱ mbe ɗe Mbuka Is Gaa wu (na̱ bi Arameya wo asa̱ mbe ɗe Golgota). ");
INSERT INTO gyz_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ka̱li ka̱n sa̱ ɓak Yesu ka suk mbala̱n ɗe lop jon. Sa̱ ɓak ma̱li gon ka ten ang yali gwasi, a ma̱li gon wo ten ang shinti gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Yek Bilatus pa̱l lishti gon gwe sa̱ nal ten guda̱l yencimi wu, ilgwe sa̱ lishi go yek ɗe, YESU GA̱ NAZARAT, GUU GA̱ MA̱N YEHUDA. ");
INSERT INTO gyz_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yek ma̱n Yehuda wonti dla̱m lishti gwisi, ten ɗe lu gwe sa̱ ɓak Yesu ten guda̱l yencin go, njaa ka̱ bal ba̱n ka̱n ni. Lishtisi wo sa̱ pa̱li na̱ bi Arameya, suk bi Roma suk bi Girik. ");
INSERT INTO gyz_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yek kiɗi ji ma̱n Pa̱ris ga̱ ma̱n Yehuda wul Bilatus ɗe, <<Ba̱s lishi ɗe <Guu ga̱ ma̱n Yehuda> so, ama ta̱s lishi ɗe ma̱lga̱n wuli ɗe tik ɗe guu ga̱ ma̱n Yehuda.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Yek Bilatus balli ɗe, <<Ilgwe a lishi wugo, a lishi wi.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ɗe ma̱n hapti dlo ɓak Ymesu ka ten guda̱l yencin wugo, yek sa̱ yem luka̱l jwasi yek sa̱ hwuli boo ɗe wupsi, yek ko wokko ka̱si yem boo gwasi. Yek sa̱ kan tlal luka̱l gwasi, wunda̱li gwe ɗe ba̱sa tla̱m so ama pa̱ti ka̱n asa̱ pi na̱ ang tun sut nya hal a zhile wu. ");
INSERT INTO gyz_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Yek sa̱ wul yilkeni jwasa̱n ɗe, <<Ba̱n kesha̱n luka̱l ga̱n ka̱ so, ta̱n pa̱la̱n guriya ta̱n yena̱n ma̱lgwe a kan wu.>> Gwisi pi nu ka̱n yek da̱m na̱kgwe ga̱ɓa ga̱ Nya wu dla̱m wu, gwe wule, <<Yek sa̱ hul wul ji kini gi ka̱ dlo gwasa̱n Yek sa̱ pa̱l guriya ten luka̱l gi gini,>> Ga̱mi ka̱ɗe ilgwe ɗe ma̱n hapti dlomi pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","To, ma̱jwe dla̱l njaa mal guda̱l yencin ga̱ Yesu wu ka̱ɗe ka̱a̱ ana gwasi suk yilka ga̱ ane suk Maryam kili ga̱ Kilobas suk Maryam ma̱n Maga̱dala. ");
INSERT INTO gyz_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ɗe Yesu yen ana gwas suk yen lishti ga̱ lami gwas a nya njaa ka̱li wugo, yek ta̱ wul ana gwas ɗe, <<Ana, yen gwa ka̱wu!>> ");
INSERT INTO gyz_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Yek paa ta̱ wul yen lishtisi ɗe, <<Ana gwa ka̱wu.>> Kan ten sa'i gwisi ka̱n yek yen lishtisi ta̱la ana ga̱ Yesu lubii gwasi, yek ane da̱m ka̱ lubii gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu yisi ɗe ka̱ sa'i gwisi wo ta̱ pak pa̱lti mas wuli wi, ten ɗe ta̱ njika̱n ilgwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya wu, yek ta̱ wuli ɗe, <<A na̱ma kumti ka̱lka̱ze.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","To, a tatze gon ni ka̱li, gwe ɗe sa̱ njika̱mi na̱ ze inabi ma̱n mbayit wu. Yek sa̱ njop wushgal ka̱ ze inabisi, yek sa̱ lak wushgali ten sanda ga̱ tlindi izob, yek sa̱ taki Yesu to bi ka. ");
INSERT INTO gyz_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ɗe Yesu la̱m mbayi ze inabisi wugo, yek ta̱ wuli ɗe, <<Paki wi.>> Yek paa ta̱ ngusa̱l gaa gwas atli yek ta̱ zak mbadl gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yek ma̱n Yehuda ngem Bilatus ten ɗe ta̱s nda̱kisi ɗe ta̱s cak-cali asa̱n mbala̱n jwe sa̱ ɓaksi ten guda̱l yencimi wu ka, asa̱ shit dli jwasa̱n sut atli. Sa̱ ngemti ten nu ten ɗe cin gwisi wo cin palti shiri ka̱n, aba̱ sa lami ɗe ta̱ dli ji mbala̱mi yi ka̱li ten cin gwe a kop kaali wu so, cin gwe cin shukti ka̱ wu. A cin shukti gwe a tulisi wo zok cin shukti ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Yek ma̱n hapti dlomi li mal mbala̱n jwe sa̱ ɓaksi ka ten guda̱l yencin suk Yesu wu yek sa̱ celi asa̱n ma̱li ga̱ cina ka pak lop, yek pa sa̱ lak cal ga̱ ma̱li gon wu ka nu pak. ");
INSERT INTO gyz_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ama ɗe sa̱ li mal Yesu wugo yek ba̱sa̱ celit asa̱n jwas ka̱ so ten ɗe ta̱ ma̱sh wi. ");
INSERT INTO gyz_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ka̱ lal ga̱ na̱k gwisi wo yek gon ka̱ ma̱n hapti dlomi ɓak Yesu na̱ gashi te malka̱n ka, tumal is bingetli yek hwulan suk ze shot suɗi. ");
INSERT INTO gyz_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ti ɗe ta̱ yen ilgwe pi wu ka̱ dla̱m ga̱ɓa ga̱mi, a mas ilgwe ta̱ dla̱m go gem ka̱n. Ti na̱ gaa gwas mago ta̱ yisi ɗe gem ka̱n ta̱ na̱ma dla̱mti, ata̱ na̱ma dla̱mti ga̱ɓa ten ɗe kii mago ta̱k ba̱la̱n gem. ");
INSERT INTO gyz_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Wul jimi pi yek da̱m ndakce na̱ ilgwe ga̱ɓa ga̱ Nya dla̱m wu, ga̱ɓa gwe wule, <<Ko sa cal ɗe na̱m ka̱ is dli jwas so,>> ");
INSERT INTO gyz_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A ga̱ɓa ga̱ Nya ga̱ lishi ka̱ lu gon po wuli ɗe, <<Sa yen ma̱lgwe sa̱ ɓakti wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ka̱ kaali wo yek Yusupu ma̱n Arimatiya, ma̱lgwe ti wo yen lishti ga̱ Yesu ka̱n, ama ga̱ hwunda̱li ten ɓanti ji ma̱n Yehuda wu sak ngem hwu ga̱ Yesu mal Bilatus. Yek Bilatus nda̱kiti yek ta̱ sak kan hwu gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Yek Nikodimus ma̱lgwe ta̱ tul mal Yesu ka̱ gas wu li suk Yusupu. Nikodimusi ngip wul ma̱n ta̱mi wusa̱n te ang ka, jwe yek ɗe ka̱a̱ mur suk alos ga̱ kutltli ka, diɓa̱lti gwasa̱n a pa̱l kilo ɗe kutl ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yek mbala̱n ɗe lop jimi kan hwu ga̱ Yesu yek sa̱ kuk-kus ka ka̱ hwol luka̱l suk wul ma̱n ta̱mi wusa̱mi na̱k kangwe a ma̱n Yehuda lep mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ka̱ lu gwe sa̱ ɓak Yesu ka ten guda̱l yencin go a zhin gon ni ka̱li, a ka̱ zhimi wo pyal gazukɗi gon ni giɓi, gwe ɗe sa̱ ɓo taɓa za̱t ga̱ ma̱lgon a giɓi sowu. ");
INSERT INTO gyz_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Na̱k ɗe cin gwisi wo cin pa̱lti shiri ga̱ ma̱n Yehuda ka̱wu, a na̱k ɗe gazukɗisi ni njaa ka̱li, yek ma̱jwisi zi hwu ga̱ Yesu ka̱ lu gwisi. ");
INSERT INTO gyz_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ka̱ bultlwe ten cin ga̱ na ɗe na̱m ga̱ multi ɗe nitgi, ka̱ sa'isi wo aba̱ lu ɓo pak tlot so, yek Maryam ma̱n Maga̱dala li gazukɗi ga̱ Yesu yek ta̱ mbi go sa̱ jek ye gwe ɗe ni ten bi gazukɗisi wu ka̱ wi. ");
INSERT INTO gyz_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yek ta̱ yem na̱ apti te mal ka̱a̱ Siman Biturus suk yen lishti gwe Yesu lamti wu ka, yek ta̱ wulsi ɗe, <<Ai, sa̱ kama̱n hwu ga̱ Bagaa ɗa̱ka̱ gazukɗi ka̱ wi, a ba̱ma̱ yis lu gwe sa̱ lak zi wu so!>> ");
INSERT INTO gyz_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Yek Biturus suk yen lishti gwisi yili yek sa̱ dop tantu la̱t ka̱ lu gazukɗisi. ");
INSERT INTO gyz_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yek mas jwasa̱n pak ɗe loɓi yem na̱ apti, yek yen lishtisi gwisi te Biturus yek ta̱ tet ten mbukti lu ten gazukɗisi. ");
INSERT INTO gyz_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ɗe ta̱ ngusi yek ta̱ kus lu te ka̱ gazukɗisi ka̱ wugo, yek ta̱ yen hwol luka̱l ga̱ zi ka, ama yek ba̱ta̱ te ka̱ gazukɗisi so. ");
INSERT INTO gyz_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yek paa Siman Biturus tul ka̱ kaal gwasi, yek ta̱ te ka̱ gazukɗisi, yek ta̱ yen hwol luka̱li ga̱ zi ka. ");
INSERT INTO gyz_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yek ta̱ yen luka̱li gwe sa̱ kushimi gaa Yesu ka na̱ nali ga̱ zi ka ka̱ luisi gon kak-kak suk hwol luka̱lisi. ");
INSERT INTO gyz_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yek pa yen lishti gwe ta̱ te Biturusi ten mbukti lu ten gazukɗisi wu te giɓi pak. Ta̱ yeni wugo yek ta̱ ba̱l gem pak. ");
INSERT INTO gyz_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ama hal ka sa'i gwisi mago a ba̱sa̱ ɓo yis gaa ga̱ ilgwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya wu, ten ɗe ngetli ka̱n ta̱ Yesu pal kaami tot ka̱ ma̱shka̱n wu so.) ");
INSERT INTO gyz_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yek mil lishtisi pal lubii jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ama Maryam wo yek ta̱ dla̱l ten bi dlabii gazukɗisi tet tu deɓa̱l ten kulu. Ta̱ na̱ma kulu nu go yek ta̱ ngusi yek ta̱ kus lu te ka̱ gazukɗisi ka, ");
INSERT INTO gyz_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Yek ta̱ yen mil shinti ji Nya jon ɗe lop na̱ hwol luka̱l, na̱ zhila ka̱ lu gwe sa̱ zi hwu ga̱ Yesu wu. Yen shinti gon da̱m tu lu gwe sa̱ zi gaa gwas wu a gon wo tu lu gwe sa̱ zi asa̱n gwa wu. ");
INSERT INTO gyz_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yek mil shinti ji Nyami ngemti ɗe, <<Kili mbala̱n, yek ka kulit ye?>> Yek ta̱ wulsi ɗe, <<Ai na̱kka̱n sa̱ kan hwu ga̱ Bagaa gi ka, a ba̱ a yis lu gwe sa̱ za̱t wu so.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɗe ta̱ dla̱m nu wugo yek ta̱ balla̱ti yek ta̱ yen Yesu a nya ka̱ li. ama yek ba̱ta̱ yisi ɗe tik ɗe gwisi so. ");
INSERT INTO gyz_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yek Yesu wulti ɗe, <<Kili mbala̱n, Yek ka kulit ye? Wok ka̱ na̱ma ngot gwas wo?>> Maryam da̱ma̱n gwa we tik ɗe ma̱n zhimi, yek laki yek ta̱ wulti ɗe, <<Ma̱n nalti, kume kik kanti ka̱ go, hwi lu gwe ka̱ za̱t wu ta sak kanti.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yek Yesu wulti ɗe, <<Maryam.>> Yek ta̱ balla̱t tet tu mal Yesu yek ta̱ hwit na̱ bi Arameya ɗe, <<Rabboni,>> (gwe yek ɗe Ma̱n Lishti wu). ");
INSERT INTO gyz_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yek Yesu wulti ɗe, <<Ba̱k giɓa̱n so, ten ɗe a ɓo to mal Aba so. Ama li mal yilkeni jini ta̱k hwisi ɗe, <A ɓa pal to mal Aba gini ka suk Aba gwaka̱n, mal Nya gini suk Nya gwaka̱n pak.> >> ");
INSERT INTO gyz_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yek Maryam ma̱n Maga̱dala li yek ta̱ hwi mil lishtisi ɗe, <<Hal a yen Bagaa!>> Yek ta̱ dla̱misi ilgwe Yesu hwit ɗu pak. ");
INSERT INTO gyz_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ka̱ sukti ten cin na ɗe na̱m ga̱ multi ɗe nitgi, a mil lishti ji Yesu ni ka̱ lu ɗe na̱m. Sa̱ kupla bi dlabii ka ten ɓanti ga̱ bacina ji ma̱n Yehuda. Yek Yesu tuli yek ta̱ dlal ka̱ dlo gwasa̱n, yek ta̱ wulsi ɗe, <<Ta̱ ta̱mi da̱mti da̱m sukkii!>> ");
INSERT INTO gyz_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ɗe ta̱ dla̱m nu wugo yek ta̱ mbokisi ang ten ang jwasi suk lu is bingetl gwasi. Yek mil lishtisi pa̱l hwol tuk i'e na̱ yenti ga̱ Bagaa. ");
INSERT INTO gyz_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yek Yesu po wulsi ɗe, <<Ta̱ ta̱mi da̱mti da̱m sukkii, na̱k kangwe Aba shina̱n sut wu, ami mago a na̱ma shinti gwaka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ɗe ta̱ dla̱m nu wugo, yek ta̱ hotisi pa̱ska̱n gwasi yek ta̱ wulsi ɗe, <<Kama̱n Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mas ma̱lgwe ka̱a̱ taasit byas wul ka̱ go, sa̱ taasit byas wuli ka̱ wi, a mas ma̱lgwe ka̱a̱ taasit ka̱ sogo, to, sa̱ ɓo taasit ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aba̱ Tomas ɗe na̱m ka̱ mil lishti ɗe kutl cet loɓi jwisi, gwe ɗe asa̱ mbet ɗe ngusa̱n wu ni suksi so ka̱ sa'i gwe Yesu tulisi wu. ");
INSERT INTO gyz_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Yek naa mil lishtisi hwit ɗe, <<Hal ma̱ yen Bagaa!>> Ama yek Tomas wulsi ɗe, <<Kume a yen lal shu kusa ka̱ ang gwasi yek a lak yen-ang gi a giɓi, yek a lak ang gi ka̱ lu gwe sa̱ ɓakti ka̱ is bingetl wu sogo, ba ba̱l gem so.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kaal ɗa̱ multi ɗe nitgi a mil lishtisi ni ka̱ lu ɗe na̱m a lubiimi, a Tomas ni suksi. A bi dlabii ga̱ lubiimi ni ga̱ kuple ka, yek Yesu yilisi yek ta̱ dla̱l ka̱ dlo gwasa̱n yek ta̱ wulsi ɗe, <<Ta̱ ta̱mi da̱mti da̱m sukkii.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Yek ta̱ wul Tomas ɗe, <<Lak yen-ang gwa aɗe, ɓo yen ang jini, tak ang gwa teɗi ta̱k lak ka̱ is bingetl gini. Zak tatlti mbadl ɗe lop tena̱nni ta̱k ba̱l gem.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Yek Tomas wulti ɗe, <<Bagaa gini suk Nya gini!>> ");
INSERT INTO gyz_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yek Yesu wulti ɗe, <<Ai ten ɗe ka̱ yena̱n ka̱n yek laki yek ka̱ ba̱l gem. Ma̱n albarka ka̱ɗe ma̱jwe sa̱ ba̱l gem ama ba̱sa̱ yena̱n so wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu pa̱l lal wul ngipti ang bi wonti ten gwel ga̱ mil lishtisi, jwe ɗe ba̱sa̱ lishi ka̱ lishti ga̱n sowu. ");
INSERT INTO gyz_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ama sa̱ lish jimi ten ɗe ta̱k ba̱la̱n gem ɗe Yesu ka̱ɗe Almasihu, Yen ga̱ Nya. A tumal ba̱lti gemi wo a ka̱a̱ mbi mbadl ka̱ shin gwasi. ");
INSERT INTO gyz_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kaal ɗa̱ na̱k gwisi yek Yesu po yilli gaa gwas mal mil lishti jwasi ten bi bal ze ga̱ Tibariya. Kangwe pi wukgu, ");
INSERT INTO gyz_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siman Biturus suk Tomas ma̱lgwe asa̱ mbet ɗe ngusa̱n wu, suk Nataniyel ma̱n Kana ga̱ Galili, suk mil ji Zabadi, suk mil lishti jon ɗe lop asa̱ ni ka̱ lu ɗe na̱m mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Yek Siman Biturus wulsi ɗe, <<Ba sa dopti kwesi,>> yek sa̱ wule, <<Mi mago ma li sukki.>> Yek sa̱ sak te ka̱ jirgi ze, yek sa̱ zigaa. Ama ka̱ gas gwisi wo yek ba̱sa̱ dop ilgon so. ");
INSERT INTO gyz_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","A lu yima tlot nugo yek Yesu ka̱wu ta̱ dla̱l nya ten bi bal zesi, ama yek ba̱ mil lishtisi yisi ɗe tik so. ");
INSERT INTO gyz_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yek Yesu wulsi ɗe, <<Mil samali ama kwes nikii ɗa?>> Yek sa̱ ballit ɗe, <<Wowo.>> ");
INSERT INTO gyz_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yek ta̱ wulsi ɗe, <<Laka̱n wul dopti kwes gwaka̱n tu ten ang shinti ga̱ jirgi zesi kaa mbi jon.>> Yek sa̱ laki na̱k kangwe Yesu hwisi. Yek sa̱ dop kwesi hal yek ba̱sa̱ man dla̱kti wul dopti kwesi dani tot ka̱ jirgi so. ");
INSERT INTO gyz_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yek yen lishti ga̱ lami ga̱ Yesu wu wul Biturus ɗe, <<Bagaa ka̱ ca!>>Ɗe Biturus kumi ɗe, Bagaa ka̱ wu, yek ta̱ kan tlal luka̱l gwasi yek ta̱ ɓal te dlo ka, ten ɗe tet go koo dlisi ka̱n ta̱ ni. Yek paa ta̱ yil nya yek ta̱ nda ten gaa zesi. ");
INSERT INTO gyz_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yek naa mil lishtisi li tet ten bicikɗi ka̱ jirgi zesi, asa̱ na̱ma dla̱kti wul dopti kwesi ga̱ njika̱mi na̱ kwesi. Ten ɗe njaa ten bicikɗi ga̱ bal zisi ka̱n sa̱ ni. Dlenta̱t gwasa̱n suk bicikɗi si wo ani ɗe lakti asa̱n ɗe zamba̱l ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ɗe sa̱ mbuki ten bicikɗi wugo, yek sa̱ yen ga̱za̱n wutu na̱ kwes a dani, suk burodi ka̱li. ");
INSERT INTO gyz_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yek Yesu hwisi ɗe, <<Ta̱la kwesi jon teɗi, tet ka̱ jwe ka̱a̱ doɓi wu.>> ");
INSERT INTO gyz_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Yek Siman Biturus te ka̱ jirgi zesi yek ta̱ dla̱k wul dopti kwesi te ten bicikɗi. A wul dopti kwesi ni ga̱ njika̱mi na̱ kiɗi kwesi, wonta̱t gwasa̱n wo ɗe 153, ama mas na̱ wonta̱t gwasa̱n nu yek ba̱ wul dopti kwesi kesh ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yek Yesu wulsi ɗe, <<La̱n teɗi ta̱k nguka̱n ilga̱ nguki ga̱ na̱ gasi.>> Yek ba̱ ma̱lgon ka̱ mil lishtisi mbi nda̱li gahwula̱n ngemti ɗe, <<Wok ɗe ki wo so?>> Ten ɗe sa̱ yisi ɗe Bagaa ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yek Yesu tuli yek ta̱ kan ba̱redisi yek ta̱ ba̱lsi, yek ta̱ kan kwesi yek ta̱ ba̱lsi pak. ");
INSERT INTO gyz_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ga̱mi ka̱ɗe asa̱mi na ɗe mekan ɗe Yesu yilli gaa gwas mal mil lishti jwasi ka̱ kaal ga̱ palti kaami gwas tet ka̱ ma̱shka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ɗe sa̱ pak ngukti ilga̱ nguki ga̱ na̱ gasisi wugo, yek Yesu ngem Siman Biturus ɗe, <<Siman yen ga̱ Yohana, Ka̱ lama̱n man ma̱jin ma?>> Yek ta̱ ballit ɗe, <<Yi Bagaa, ai ka̱ yisa̱n kangwe a lamki wu.>> Yek Yesu hwit ɗe, <<Ba̱l ilga̱ nguki mba̱la jini.>> ");
INSERT INTO gyz_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yek Yesu po ngemti ɗa asa̱mi na ɗe lop ɗe, <<Siman yen ga̱ Yohana, ka̱ lama̱n ma?>> Yek ta̱ ballit ɗe, <<Yi, Bagaa, ai ka̱ yisi ɗe a lamki.>> Yek Yesu hwit ɗe, <<Pi kyo ga̱ mba̱la jini.>> ");
INSERT INTO gyz_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu ngemti asa̱mi na ɗe mekan ɗe, <<Siman yen ga̱ Yohana, ka̱ lama̱n ma?>> Yek mbadl lili Biturus ten ɗe Yesu ngemti asa̱mi ɗe mekan ɗe, <<Ka̱ lama̱n ma?>> Yek ta̱ dla̱m ɗe, <<Bagaa, ka̱ yis mas wul. Ka̱ yisi ɗe a lamki.>> Yek Yesu wulti ɗe, <<Ba̱l ilga̱ nguki mba̱la jini. ");
INSERT INTO gyz_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Gem amik ka hwik ge, sa'i gwe ka̱ yi ɗe yen samali go a ka̱ kini wul gaa gwa, a ka̱ li ka̱ lu gwe ka̱ lami wu, ama kume ka̱ koli wugo ka tak ang gwa a ma̱lgon kinik wul, a ta̱ ta̱lak ka̱ lu gwe ka̱ lam la̱t sowu.>> ");
INSERT INTO gyz_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu dla̱m nu ka̱n ta̱s mbok ang ten wunda̱l ga̱ ma̱shka̱n gwe Biturus a pa̱li wu, ten ɗe ta̱s ba̱l nalti Nya. Ka̱ kaal ga̱ ga̱ɓa gwisi wo yek Yesu hwi Biturus ɗe, <<Koɓa̱nni!>> ");
INSERT INTO gyz_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Biturus balla̱ti yek ta̱ yeni go yen lishti gwe Yesu lamti wu na̱ma kopti gwasa̱n. Gwisi wo tik ɗe yen lishti gwe ta̱ nga̱sti ten ngetl ga̱ Yesu ka̱ sa'i ngukti ilga̱ nguki ga̱ Biki Daamti Ɗakciti wu. A tik ngem Yesu ɗe, <<Bagaa, Wok ka ba̱l bi gwa wo?>> ");
INSERT INTO gyz_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ɗe Biturus yenti wugo, yek ta̱ gem Yesu ɗe, <<Bagaa ma̱lga̱n pa?>> ");
INSERT INTO gyz_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yek Yesu ballit ɗe, <<Kume lamti gi ka̱ɗe ta̱s da̱mi hal a pal sut go yek ɗe ze gwa ye? Ki dai koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ten na̱k gwisi ka̱n yek ga̱ɓa ngusi ma̱tlti ka̱ dlo ji ma̱n kopti ga̱ Yesu ɗe yen lishti gwisi wo ta ma̱sh so. Ama Yesu wo ta̱ dla̱m ɗe ta ma̱sh so so. Ta̱ dla̱m ɗe, <<Kume a lami ɗe ta̱s da̱mi hal a pal sut go yek ɗe ze gwa ye?>> ");
INSERT INTO gyz_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yen lishti gwisi ka̱ɗe ma̱lgwe ba̱l sheda ten wul jimi wu yek ta̱ lishi. A ma̱ yisi ɗe sheda gwas wo gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Wuli jon jwe Yesu pa̱li wu wonti ni ɗa̱ pak, ɗe da mas wuli ka̱n sa lishi wu, a ɓa yeni go ko ta̱ dii atl na̱ gaa gwas mago ta man kanti littapi gwe sa lishi wu dani so.");
INSERT INTO gyz_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ma̱n nalti Tiyopolos, ka̱ lishti gwe a lishiki ga̱ cina go a hwik mas wul jwe Yesu pa̱li wu, suk ga̱ɓa jwe ta̱ mboki mbala̱n ang dani wu, ");
INSERT INTO gyz_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hal se gas gwe Nya kanti to nya ka̱wu. Ɗe ba̱ Nya ɓo kanti to nya ka̱ sogo, yek Yesu lak Shishi ga̱ Nya ta̱s hwi ga̱ɓa mil shinti jwasi jwe ta̱ botlsi wu. ");
INSERT INTO gyz_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ta̱ ngusi tulti malsi kaal ɗa̱ ma̱shka̱n gwasi, ata̱ nisi ma mbokti ang ten gaa gwasi ta̱s yisi ɗe ta̱ tli ɗa̱ka̱ ma̱shka̱n ka wi. Multi gwas ɗe kutl ɗe wupsi ata̱ ni suksi, ata̱ nisi ma ga̱ɓa ten Nya ɗe guu wu. ");
INSERT INTO gyz_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Gas gon, a Yesu na̱ma ngukti wul suksi yek ta̱ wulsi ɗe, <<Da̱ma̱n a Wurshelima ta̱k ɓa̱ta̱n ilgwe Nya dla̱lli ga̱ɓa ɗe ta ba̱lkii wu gwe ta̱ dla̱mikii na̱ bi gwas wu. ");
INSERT INTO gyz_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana wo na̱ ze ka̱n ta̱ pa̱li mbala̱n baptisma, ama njet ɗe Nya pa̱likii baptisma na̱ Shishi gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Sa̱ mogaa wugo yek mil shinti ji botli ngemti ɗe, <<Bagaa, ninge ka̱n ka laki a ma̱n Yisiraila mbi guu ga̱ gaa gwasa̱n ɗa?>> ");
INSERT INTO gyz_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yek Yesu wulsi ɗe, <<Yisti gas gwe wul a pi go gwaka̱n ka̱ so, Nya bal kakshe na̱ ngus ka̱ yis cin jwe a wul pi wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ama Nya a ba̱lkii nda̱lti na̱k ɗe ta shin Shishi gwas sut tenkii wu, apaa ka̱a̱ da̱m ɗe ma̱n dla̱mti ga̱ɓa gi mbala̱n ten wul jwe ka̱ yeni tena̱n wu a Wurshelima suk ka̱ atl ga̱ Yehudiya suk ga̱ Samariya mas, hal a ka̱ ngash dii atli mas. ");
INSERT INTO gyz_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ta̱ dla̱m nu wugo yek Nya kanti to nya ka, yek kaluntu yitlat ka yek ba̱sa̱ po yenti dani so. ");
INSERT INTO gyz_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","A sa̱ yima wutti gwel to Nya ka̱ nugo, yek gal mbala̱n ɗe lop jon ma̱n hwol luka̱l sak dla̱l malsi. ");
INSERT INTO gyz_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Yek mbala̱mi wul si ɗe, <<Ma̱n Galili, yek laki ɗe ka̱ na̱ma yenti lu to nya ka na̱n ye? Yesu ga̱n ɗe ta̱ zakki yek ta̱ to nya go, ta ya pal suɗi na̱k gwe ta̱ zigaa wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yek sa̱ pal tet Wurshelima, tet ɗa̱ ten tla̱da̱l gwe asa̱ mbe ɗe Tla̱da̱l Tlindi Zetun wu, gwe dlenta̱t gwas tet Wurshelima wo pa̱l tatlti dlo mil ɗe na̱m wu. ");
INSERT INTO gyz_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Sa̱ mbuki ka̱ ba̱n Wurshelima wu, yek sa̱ te ka̱ tlalbii gon ka̱ lu gwe asa̱ kul da̱m wu. Ma̱jwe ni ɗa ka̱li go sik ɗe, Biturus suk Yohana suk Yakubu suk Andarawus, Pilip suk Toma suk Bartilomi, suk Matiyu suk Yakubu yen ga̱ Halpa suk Siman ma̱lgwe asa̱ mbet ɗe ma̱n lamti mbala̱n ga̱ atl gwas wu, suk Yehuda yen ga̱ Yakubu. ");
INSERT INTO gyz_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sa̱ mogaa mas jwasa̱n yek sa̱ ngusi ngemti Nya na̱ mbadl ɗe na̱m, suk modli jon suk Maryam ana ga̱ Yesu suk yilkeni ji Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Yilkeni ma̱n kopti jwe ni ka̱li ka̱ multi jwisi go, wonta̱t jwasa̱n la zamba̱l ɗe na̱m na̱ kutl ɗe lop. Yek Biturus tlinya ka̱ dlo gwasa̱n ");
INSERT INTO gyz_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","yek ta̱ wuli ɗe, <<Yilkeni jini, ga̱ɓa ga̱ Nya gwe Shishi ga̱ Nya dla̱m tumal Dauda guu gwe ta̱ dla̱m ten Yehuda ma̱lgwe tulli ma̱n dopti ga̱ Yesu wu ka̱ da̱m wi ɗe gem. ");
INSERT INTO gyz_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ti Yehude wo gon ga̱na̱n ka̱n ata̱ nima pa̱lti wul Nya sukmi.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yehudasi wul lu na̱ wulpi gwe ta̱ mbi ten pa̱lti byas wul gwas wu. Ka lusi ka̱n ta̱ lak nda na̱ gaa, yek tuk gwas mbutl ka, yek ɓot gwas yil deɓa̱l. ");
INSERT INTO gyz_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Mas ma̱n Wurshelima kumi na̱k gwisi, yek sa̱ mbe lusi na̱ bi gwasa̱n ɗe, <<Akeldama,>> yek ɗe <<Lu hwulan.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Yek Biturus wuli ɗe, <<Ni ga̱ lishi ka̱ Zabura ɗe, << <Ha̱n ta̱ lu da̱mti gwas da̱m ɗe koo boo Ba̱ ma̱lgon te giɓi so,> a, <Hwe ta̱ ma̱lgon da̱m ka̱ gobdlan bacina gwasi.> ");
INSERT INTO gyz_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","<<Yek laki ɗe ngetli ka̱n ta̱n botla̱n mbala̱n ɗe na̱m ka̱ ma̱jwe ni sukmi, ka̱ mas pa̱lti wul gwe Bagaa Yesu pa̱li ka̱ dlo ga̱na̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ma̱lgwe ma botla̱nti go ngetli ka̱n ta̱s ni ɗe ma̱lgwe ni sukmi ndati tet ten ga̱ɓa ga̱ Yohana ten bi baptisma, hal se gasi gwe Nya kan Yesu to nya ka̱wu. Ma̱lgwisi ka hwi ga̱ɓa mbala̱n ten kangwe ma̱ yen Yesu tli ɗa̱ka̱ ma̱shka̱n ka wu sukmi.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Yek sa̱ ba̱l shin ga̱ mbala̱n ɗe lop, ka̱ Yusupu gwe asa̱ mbet ɗe Barsabas wu, ti ka̱n asa̱ po mbet ɗe Justus pak, suk Matiyes. ");
INSERT INTO gyz_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Yek sa̱ ngem Nya ɗe, <<Bagaa, ki ɗe ka̱ yis mbadl ga̱ mbala̱n mas wu, mboki ni ang ten ma̱lgwe ka̱ botli wu ka̱ ma̱jin, ");
INSERT INTO gyz_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ma̱lgwe a da̱m ɗe yen shinti ga̱ botli gwa ka̱lal ga̱ Yehuda ma̱lgwe zak ni yek ta̱ li ka̱ lu gwe ndalti mani wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Yek sa̱ pa̱l botlti yek nda ten Matiyes, yek ta̱ mba̱ldli ten mil shinti ji botli ɗe kutl cet na̱m ju. ");
INSERT INTO gyz_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gas motgaa hwol tuki gwe asa̱ mbe ɗe Pentekos wu tuli, a mas yilkeni ma̱n kopti ni ka̱ lu ɗe na̱m. ");
INSERT INTO gyz_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sa̱ ni nugo yek sa̱ kum ilgon na̱ma wulti sut Nya na̱k bal yeta̱l. Yek ili sak njika̱n bii gwe sa̱ ni giɓi wu ka. ");
INSERT INTO gyz_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Sa̱ yen wuljon jwe te ba̱lba̱l wutu wu, yek wuli ngusi lokti ɗa̱n ten gaa jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yek Shishi ga̱ Nya njika̱n mas mbadl jwasa̱n, yek sa̱ njel ga̱ɓa na̱ bi jwe ɗe ba̱ jwasa̱n ka̱ sowu na̱k kangwe Shishi ga̱ Nyami ba̱lsi manti pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ten gasisi wo a ma̱n Yehuda wonti jwe asa̱ kop mba̱t ga̱ɓa ga̱ Musa i'e ten dii atl wu ni a ba̱n Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Sa̱ kum kangwe yeta̱li wul wugo yek ili hwotsi i'e, yek sa̱ mogaa na̱k ɗe mas jwasa̱n kumsi ten ga̱ɓa na̱ bi jwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ili cisi ɓanti wugo yek sa̱ ɓo ang ten ngetli yek sa̱ wuli ɗe, <<Ale ma̱jin jo ma̱n Galili ka̱n na̱? ");
INSERT INTO gyz_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Yek laki yek kokko na̱ma kumti gwasa̱n ten ga̱ɓa na̱ bi gwas ye? ");
INSERT INTO gyz_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A yek gu mi wo ma̱n Partiya, suk ma̱n Midi, suk ma̱n Elama, suk ma̱n da̱mti a Mesopotamiya, suk a Yehudiya, suk a Kapadokiya, suk ma̱n Pontus, suk a Asiya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ajon ka̱ mi wo ma̱n Pirijiya, suk ma̱n Pampiliya, suk ma̱n Masar suk mbala̱n tet ka̱ ka̱t atl ga̱ Libiya gwe ni njaa mal Sayirin wu, mas suk ma̱ndaki jwe sa̱ yil tet ka̱ atl ga̱ Roma wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ka̱ mi wo ma̱n Yehuda suk ma̱jwe te ka̱ kopti Nya ga̱ ma̱n Yehuda wu. Ma̱n Keriti suk ma̱n Arab ama yek gu mas jina̱n ma̱ na̱ma kumti gwasa̱n ten ga̱ɓa na̱ bi jina̱n, sa̱ na̱ma dla̱mti kiɗi wul jwe Nya pa̱li wu!>> ");
INSERT INTO gyz_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yek ɓanti cisi i'e mas jwasa̱n, yek sa̱ ngusi ngemti yilkeni jwasa̱n ɗe, <<Yek nu kam ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yek naami wulisi wuljon ɗe, <<Ze inabi ka̱n sa̱ tla yek ɓa tlosi.>> ");
INSERT INTO gyz_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yek Biturus tlinya suk yilkeni jwas mil shinti ji botli ɗe kutl cet na̱mi, yek ta̱ tlil yal Nya yek ta̱ wule, <<Yilkeni jini Ma̱n Yehudiya suk mas ma̱n da̱nti ka̱ ba̱n Wurshelima, ɓo katini nini ka̱ng. ");
INSERT INTO gyz_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ma̱jin jo ze inabi ka̱n sa̱ tla na̱k gwe ka̱ na̱ma daamti wu so, Ba̱le na̱ gasi ka̱ yi! ");
INSERT INTO gyz_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ilgwe Joyel ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu ka̱ɗe ge. ");
INSERT INTO gyz_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<<Gwe Nya wuli ɗe, <Ka̱ pakti multi wo, ba ba̱l Shishi gi mas mbala̱n i'e. Mas mil jwaka̱n a dla̱m ga̱ɓa gini, Nya a ɓuli gwel mil maani jwaka̱n asa̱ yen iljwe a pi wu, kolsi jwaka̱n a tlunki. ");
INSERT INTO gyz_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","A ba ba̱l Shishi gi zhel jini modli suk maani, a sa dla̱m ga̱ɓa gini. ");
INSERT INTO gyz_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ba̱ pa̱l wul cit ɓanti to Nya ka suk wul jwe ba̱ mbala̱n zi ɗe a pi sowu sut ten dii atli, hwulan suk wutu suk bal kuno. ");
INSERT INTO gyz_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A palli cin ɗe da̱mshal, a palli lip na̱k hwulan, apaa bal cin ma̱n nalti gwe Bagaa Nya a kisi mbala̱n ga̱ɓa dani wu tuli. ");
INSERT INTO gyz_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","A mas ma̱jwe asa̱ mbe shin ga̱ Bagaa wu mbi kisti.> ");
INSERT INTO gyz_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<Ma̱n Israila, ɓo kuma̱n ga̱ɓa ge. Yesu ga̱ Nazarat ma̱lgwe Nya mbokikii ang tenti ɗe tik shinti sut ɗu, yek ta̱ pa̱likii wul cit ɓanti tumalti, na̱k gwe ka̱ yeni na̱ gwel gwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ti ka̱n ka̱ lamti ga̱ Nya suk yisti ga̱ ilgwe a pi a cina wu, ka̱n ta̱ ba̱lti a ang gwaka̱n, yek ka̱a̱ tloti kii suk byas mbala̱n tumal ɓakti ten guda̱l yencin. ");
INSERT INTO gyz_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Yek Nya yilla̱t ɗa̱ka̱ cicit ga̱ ma̱shka̱n ka yek ta̱ palla̱t kaami na̱k ɗe ma̱shka̱n gipti dani sowu. ");
INSERT INTO gyz_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tenti ka̱n Dauda guu ga̱ɓa ɗe ta̱ wuli ɗe, << <A yen Bagaa Nya a cina ɗa ka mas cin, Na̱k ɗe ta̱ ni suk ami go, ilgon a ci ɓanti so. ");
INSERT INTO gyz_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na̱n ɗe a na̱ma ga̱ɓa go mbadl gini ni ka̱ ta̱mti, Na̱ hwol tuk ka̱n a na̱ma ga̱ɓa, A zi mbadl gini ten ilgwe Nya dla̱lli ga̱ɓa ɗe ta pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Na̱k ɗe ka zaka̱nni a da̱m ka̱ gazukɗi sowu. A ba̱ka zak ma̱n cilti gwa ata̱ moki so. ");
INSERT INTO gyz_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ka̱ mboki ang ten kangwe a mbi mbadl wu, yek ka̱ laka̱n ten pa̱lti hwol tuki na̱k ɗe ka̱ ni suk ami wu.> ");
INSERT INTO gyz_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<Yilkeni jini, ha̱n ta ɓo hwiki. Dauda aba ga̱na̱n ma̱shi yek sa̱ lepti, gazukɗi gwas ka̱ yi wu hal ase. ");
INSERT INTO gyz_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tisi wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱n, yek Nya dla̱llit ga̱ɓa ma̱n nda̱lti ɗe ta lak gon ka̱ mil jwasi, ɗe guu ten gobdlan guu gwasi na̱k gwe ta̱ lakti wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Na̱k ɗe Dauda yen ilgwe a pi wu, yek ta̱ dla̱m ga̱ɓa ten tlit ɗa̱ka̱ ma̱shka̱n ka ga̱ Almasihu ɗe Nya a zakti ka̱ lu ma̱shka̱n so, a ba̱ta zak dli gwasi ta̱ moki so. ");
INSERT INTO gyz_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mas jina̱n ma̱ yen Nya palli Yesu kaami, a ma̱ nima dla̱mti ɗe Nya palla̱t kaami wi. ");
INSERT INTO gyz_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ningo ta̱ ɓal ka̱ nalti gwas mal Nya, yek Nyami ba̱lti Shishi gwasi gwe ta̱ dla̱lli ga̱ɓa ɗe ta ba̱li wu. Ilgwe ka̱ na̱ma yenti ningo a ka̱ na̱ma kumti go, tet mal Shishi ga̱ Nyami ka̱n yili gwe Yesu wut ten ni wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Nya kan Dauda to to nya ka̱ so ama yek ta̱ wule, << <Yek Bagaa Nya wul Bagaa gi ɗe, Da̱m ka̱ nda̱lti gini ten ang shinti gini, ");
INSERT INTO gyz_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","se a palli ma̱n nget gwa a atl ɗaaki.> ");
INSERT INTO gyz_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<Ha̱n ta̱ mas ma̱n Yisiraila yisi ɗe Yesu gwe ka̱a̱ ɓakti ka ten guda̱l yencin go, ti ka̱n Nya palla̱t ɗe Bagaa ga̱ mbala̱n mas a tik ɗe Almasihu.>> ");
INSERT INTO gyz_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Sa̱ kumi nu wugo yek ili ta̱n mbadl gwasa̱n i'e, yek ba̱sa̱ yis ilgwe sa pa̱li wu so. Yek sa̱ wul Biturus suk naa mil shinti ji botlisi ɗe, <<Yilkeni jina̱n, yek ma pa̱li ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Yek Biturus wulsi ɗe, <<Cin atl gaa a pa̱likii baptisma na̱ shin ga̱ Almasihu Yesu, apaa Nya taasikii byas wul jwaka̱n ka a ta̱ ba̱lki Shishi gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ga̱ɓa ga̱n ɗe Nya dla̱lli go gwaka̱n ka̱n suk mil jwaka̱n suk ma̱jwe ni dlenti wu, suk mas ma̱jwe Bagaa Nya ga̱na̱n a mbesi tet malti wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na̱ ga̱ɓa jwisi suk ga̱ɓe jon ka̱n ta̱ da̱lisi ka̱ng. Yek ta̱ ngemsi ɗe, ta̱s yil ɗa̱ka̱ lilti ga̱ mbala̱n ji se ka. ");
INSERT INTO gyz_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma̱jwe kan ga̱ɓe ka̱ mbadl jwasa̱n go yek sa̱ pa̱lisi baptisma. Ten gasisi wo mbala̱n jwe mba̱ldli ten wonta̱t ga̱ ma̱n koptisi wu la zangu ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yek sa̱ ngusi katti ka̱n ka̱ ga̱ɓa jwe a mil shinti ji botli hwisi wu, asa̱ nima cutgaa, asa̱ na̱ma ngukti wul suk yilkeni jwasa̱n, asa̱ ngusi ngemti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yek mbala̱n mas ba̱l Nya nalti, na̱k ɗe Nyami pa̱l wul cit ɓanti tumal mil shinti ji botlisi wu. ");
INSERT INTO gyz_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Yek mas ma̱jwe pal ɗe ma̱n kopti go da̱m ka̱ lu ɗe na̱m, asa̱ na̱ma mot wul jwasa̱n ka̱ lu ɗe na̱m asa̱ ngusi pa̱lti wul na̱ nali mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yek sa̱ ngusi wulti wul jwasa̱n ka, asa̱ na̱ma ba̱lti wulpi kokko kangwe ta̱ Lami wu ");
INSERT INTO gyz_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yek sa̱ ngusi motgaa ka̱ gib boo lubii ga̱ Nya ten mas cin, asa̱ na̱ma ngukti wul na̱ ta̱mi mbadli ɗa̱nka̱ boo ji yilkeni jwasa̱n ka, ");
INSERT INTO gyz_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","asa̱ na̱ma ta̱sti ga̱ Nya, a hwol hwulan nisi ɗa mal mbala̱n mas. Yek Bagaa ngusisi mba̱lti ma̱jwe ba̱l gem yek sa̱ mbi kisti wu ten mas cin. ");
INSERT INTO gyz_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gas gon a Biturus suk Yohana na̱ma la̱t lubii ga̱ Nya ka̱ cin sukti. ");
INSERT INTO gyz_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yek ma̱jon ka̱ju ten bi dlabii gwe asa̱ mbe ɗe Mbuni Dlabii wu sa̱ kan kulki gon, gwe ta̱ ɓo taɓa la̱t na̱ asa̱n gwas sowu. Asa̱ kul ta̱la kulkisi ten mas cin ka̱li ta̱s ngem wul mal ma̱jwe asa̱ te gib boo lubii ga̱ Nyami wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Yek ta̱ yen Biturus suk Yohana ten tet gib boo lubii ga̱ Nyami wugo, yek ta̱ ngemisi wul. ");
INSERT INTO gyz_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yek Biturus suk Yohana wutit gwel. Yek Biturus wulti ɗe, <<Ɓo yenni!>> ");
INSERT INTO gyz_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yek ta̱ katisi ka̱ng i'e ta̱ ɓa̱tti ta̱s mbi ilgon malsi ne. ");
INSERT INTO gyz_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Yek Biturus wulti ɗe, <<Wulpi ni ɗa̱ so ama ilgwe ba pa̱lik go, yek ɗe na̱ nda̱lti shin ga̱ Almasihu Yesu ga̱ Nazarat wu, tlinya ta̱k li na̱ asa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yek Biturus ngip ang shinti gwasi, yek ta̱ tlilti nya, yek giɓ asa̱n gwasi suk gwel asa̱n gwas nda̱li. ");
INSERT INTO gyz_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yek ta̱ yil nya, yek ta̱ njel la̱ti, yek ta̱ te gib boo lubii ga̱ Nyami suksi ata̱ na̱ma yilti nya ata̱ na̱ma ta̱sti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Mas mbala̱mi yenti ten ta̱sti ga̱ Nya wu, ");
INSERT INTO gyz_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","yek sa̱ yisti ɗe ma̱n da̱mti ka̱ Mbuni Dlabii ata̱ ngem wul wu ka̱n. Yek sa̱ ɓo ang ten ngetli yek ɓanti ngusi cit gwasa̱n i'e na̱ kangwe ta̱ ndokti wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Yek kulki gwe sa̱ ndokti wu ngip Biturus suk Yohana, yek mas mbala̱n li tet malsi ɓaa-ɓaa ka̱ lu gwe asa̱ mbe ɗe Baranda ga̱ Sulemanu wu asa̱ na̱ma yenti wul cit ɓanti ten ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Biturus yeni nu wugo yek ta̱ wul mbala̱mi ɗe, <<Ma̱n Israila yek laki yek ilga̱n ni kii ma cit ɓanti nu ye? A yek laki yek ka̱ ni nima wulti gwel nu ye? Ka̱ ɓa yeni go na̱ nda̱lti ga̱na̱n ka̱n ma̱ ndok ma̱lga̱n ma? ");
INSERT INTO gyz_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nya gwe Ibirahim suk Ishiyaku suk Yakubu ngusit atl wu, tik ɗe Nya ga̱ aba jina̱n tik nalli Yesu zhel gwasi. Yesusi ka̱n ka̱ nge yisti gwasi yek ka̱ ba̱ltiti Bilatus gobna ko ɗe Bilatus lami ɗe ta̱s zakti wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ko ɗe ti wo ma̱n cilti ka̱n a ma̱n zok mbadl ka̱n wu, yek ka̱ nge yisti gwasi, yek ka̱ wule ta̱s zakikii ma̱n tlot mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Yek ka̱ dlo ma̱lgwe ata̱ ba̱l mbala̱n mbadl gwe ba a paki sowu. Yek Nya palla̱t kaami, mik yen kangwe pi wu na̱ gwel ga̱na̱n. ");
INSERT INTO gyz_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Na̱ nalti ga̱ shin ga̱ Yesu gwe ma̱ nga̱s tenti wu ka̱n ma̱lga̱n ɗe ka̱ yisti wu mbi nda̱lti suk ndokti, yek gwel gwaka̱n yenikii ndokti gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<Yilkeni jini, a yisi ɗe na̱kka̱n ka̱ yisi ɗe tik ɗe Almasihu so, yek laki yek ka̱ pa̱li nu kangwe bacina jwaka̱n pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ama na̱k gwisi ka̱n Nya njika̱n ilgwe ta̱ dla̱m tumal ma̱n dla̱mti ga̱ɓa gwasi, ɗe Almasihu gwas atla bomti. ");
INSERT INTO gyz_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Cin atl gaa ta̱ Nya taasikii byas wul jwaka̱n ka ata̱ nda̱lli mbadl jwaka̱n, ");
INSERT INTO gyz_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","kangwe ɗe ta ya shin Almasihu gwe ta̱ botlikii ti wu sut ɗu, a Almasihusi ka̱ɗe Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ngetli ka̱n ta̱ Yesu to to nya ka, se Nya palli mas wul pyali na̱k gwe ta̱ dla̱lli ga̱ɓa gwasi tumal ma̱n dla̱mti ga̱ɓa jwe ta̱ ɓotlsi ju. ");
INSERT INTO gyz_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Na̱k gwe Musa ma̱n dla̱mti ga̱ɓa ga̱ Nya dla̱m wu ɗe, <Nya tlilikii ma̱n dla̱mti ga̱ɓa gwas gon ka̱ dlo gwaka̱n na̱k ami, ngetli ka̱n ta̱k kata̱n ka̱ng ten mas ilgwe ta hwikii wu. ");
INSERT INTO gyz_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mas ma̱lgwe kum ga̱ɓa gwas sogo, Nya a mbolti ɗa̱ka̱ mbala̱n jwas ka.> ");
INSERT INTO gyz_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","<<Mas ma̱n dla̱mti ga̱ɓa ga̱ Nya jwe dla̱m ilgwe a pi wu tun tet ten Samaila, sa̱ dla̱m ga̱ɓa ten multi jimisi. ");
INSERT INTO gyz_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ilgwe ma̱n dla̱mti ga̱ɓa ga̱ Nya ju dla̱m wu suk ga̱ɓa gwe Nya dla̱lli aba jwaka̱n jo jwaka̱n ka̱n. Na̱k gwe Nya wul Ibirahim ɗe, <Tumal mil jwaka̱n ba ba̱l nalti mbala̱n ji dii atli mas.> ");
INSERT INTO gyz_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kii ka̱n Nya tlil zhel gwasi yek ta̱ shinti malkii ta̱s ba̱lkii nalti kangwe ta yilla̱kii ɗa̱ka̱ yokit gwaka̱n ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Biturus suk Yohana nima hwit ga̱ɓa mbala̱n nugo yek ma̱n Pa̱ris suk bacina ga̱ ma̱n ɓa̱tti lubiimi suk ma̱n Saduki li tet malsi. ");
INSERT INTO gyz_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Mbadl lilisi na̱k ɗe mil shinti ji ɓotlisi nima dla̱mti ɗe a mbala̱n tli ɗa̱ka̱ ma̱shka̱n ka tumal Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Yek sa̱ dop Biturus suk Yohana yek sa̱ lesi ka na̱k ɗe sukti ka̱ ɓal wu se lu tlo. ");
INSERT INTO gyz_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ten cin gwisi wo mbala̱n wonti kum ga̱ɓa gwasa̱n yek wonti ka̱si ba̱l gem. Yek wonta̱t ji maani ma̱n kopti mba̱ldli yek sa̱ la za̱mba̱l kutl ɗe namtan (5,000). ");
INSERT INTO gyz_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Lu tlo wugo yek guu suk bacina jwasa̱n suk ma̱n yisti mba̱t ga̱ɓa ga̱ Musa mogaa a Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ka̱ ma̱jwe mogaa go Hanana bal ma̱n Pa̱ris suk Kayapas suk Yohana, suk Alekzanda suk mas ma̱n boo ga̱ bal ma̱n Pa̱rismi ni ka̱si. ");
INSERT INTO gyz_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yek sa̱ ta̱la ka̱a̱ Biturus suk Yohana tet malsi, yek sa̱ ngemsi ɗe, <<Wok ba̱lkii manti pa̱lti ilga̱n wo? Na̱ shin ga̱ wok a ka̱ pa̱li wo?>> ");
INSERT INTO gyz_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yek Biturus na̱ Shishi ga̱ Nya ka̱ mbadl gwasi, wulsi ɗe, <<Guu suk bacina jina̱n, ");
INSERT INTO gyz_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ngemti ka̱n ka̱ na̱ma ngemti ga̱na̱n ten kangwe kulki wu ndoki gwa? Ɗe ɗa̱ nii ka̱n pi yek ta̱ ndok gwi gwa? ");
INSERT INTO gyz_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ha̱n ta̱k yisini kii ɗe ka̱ ni a ɗe wu, suk mas jwaka̱n ma̱n Yisiraila ɗe na̱ nda̱lti shin ga̱ Almasihu Yesu ga̱ Nazarat ka̱n ma̱lga̱n ɗe ka yenti wu ndoki. Yesu gwe ka̱ ɓakti ka ten guda̱l yencin yek Nya palla̱t kaami wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ni ga̱ lishi ka̱ ga̱ɓa ɗe Yesu go na̱k, << <Ye gwe kii ma̱n kinti bii ka̱a̱ nge, yek lak da̱n ɗe zok ye kinti bii wu ka̱n ta̱ ni.> ");
INSERT INTO gyz_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesusi na̱ ngus ka man kisti ga̱ mbala̱n, na̱ shin gwas na̱ ngusi ka̱n mbala̱n a man mbit kisti. Na̱k ɗe ba̱ Nya ba̱l shin ga̱ zobsi ma̱lgon ten dii atli, gwe mbala̱n a mbi kisti tumali wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sa̱ yen kangwe Biturus suk Yohana ga̱ɓa na̱ nda̱lti gahwula̱n wu asa̱ yisi ɗe sa̱ pa̱l lishti so, a ba̱ ma̱n wul ang ka̱ɗe si so, yek ili cisi ɓanti. Yek sa̱ yisi ɗe sa̱ da̱n suk Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Na̱k ɗe sa̱ yen ma̱lgwe ndokisi dla̱l nya a malsi wu, yek ba̱ta̱ po man wulti ɗe ilgon so. ");
INSERT INTO gyz_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Yek sa̱ wul Biturus suk Yohana ɗe ta̱s yil ɗa̱ dlaboo Sanhidirimi ka, yek sa̱ ga̱ɓa ka̱ dlo gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Yek sa̱ wule, <<Yek ma pa̱li ma̱jin ye na̱k ɗe sa̱ pa̱l wul cit ɓanti na̱k ga̱n, a ba̱ma mana̱n hwunda̱lti so, na̱k ɗe mas ma̱n Wurshelima yisi wu?>> ");
INSERT INTO gyz_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yek sa̱ po wuli ɗa̱ɗe, <<Ha̱n ta̱n wula̱nsi ɗe ta̱s zaki hwit ga̱ɓa mbala̱n ten bi shin ga̱ ma̱lgwisi ba̱ bi gwas ngusi ma̱tlti ɗa̱nka̱ mbala̱n ka̱ so ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Yek sa̱ mbesi yek sa̱ wulsi ɗe ba̱s po hwi ga̱ɓa ma̱lgon ten bi ga̱ Yesu so, a ba̱s po dla̱m ilgon na̱ shin gwas so ko njet. ");
INSERT INTO gyz_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yek Biturus suk Yohana wulsi ɗe, <<Ga̱ɓa ga̱ Nya ka̱n ma koɓi ya ko gwaka̱n? Ɓo daama̱nkii. ");
INSERT INTO gyz_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mi wo ma man da̱nti mbetlak ten ilgwe ma yeni yek ma kumi wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma̱n da̱mti dlaboo Sanhidirimi kumi nu wugo yek sa̱ laki Biturus suk Yohana ɓanti ka̱ dli. Yek sa̱ zaksi ta̱s zigaa na̱k ɗe sa̱ mbi ilgwe sa̱ nolsi dani sowu, a mbala̱n na̱ma ta ta̱sti ga̱ Nya ten ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ma̱lgwe mbi ndoktisi wo ta̱ man gin ɗe kutl ɗe wupsi na̱ za̱t wi. ");
INSERT INTO gyz_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ma̱n da̱mti dlaboo Sanhidirin zak Biturus suk Yohana wu yek sa̱ pal mal yilkeni jwasa̱n ma̱n kopti, yek sa̱ hwisi mas ilgwe kiɗi ma̱n Pa̱ris suk bacina jwasa̱n dla̱misi wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Sa̱ kumi nu wugo yek sa̱ tlil yal nya mas jwasa̱n, yek sa̱ ngem Nya ɗe, <<Bagaa Nya, kik pa̱l dii atli suk dlo nya suk bal ze na̱ mas ilgwe ni gipsi wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tumal Shishi gwaka̱n ka̱ ga̱ɓa suk zhel gwa Dauda aba ga̱na̱n yek ka̱ wule, << <Yek laki ɗe mbadl lili ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ye? Yek laki yek mbala̱n na̱ma ɓelti bi ten wul jwe ni ten koo lu ye? ");
INSERT INTO gyz_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Yek guu ga̱ mbala̱n ji dii atli suk bacina jwasa̱n ɓel bi ta̱s nge Bagaa Nya suk Almasihu gwe ta̱ botlti wu.> ");
INSERT INTO gyz_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nu ka̱n ka̱a̱ Hiridus guu suk Buntus Bilatus gobna suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, suk ma̱n Yehuda mas mogaa ka̱ ba̱n ge ta̱s ngem Yesu zhel gwa ma̱n cilti gwe ka̱ botlti ɗe Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yek sa̱ pa̱l ilgwe ka̱ dla̱lli ɗe a pi tek wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bagaa, kum kangwe sa̱ nini ma lakti ɓanti ka̱ dli wu, ma̱ na̱ma ngemti gwa ta̱k ba̱lni nda̱li mbadli kangwe ɗe ɓanti dla̱mti ga̱ɓa gwa a cini sowu. ");
INSERT INTO gyz_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tak ang gwa ta̱k ndok ma̱n cwo a ka̱ pa̱l wul cit ɓanti na̱ nda̱lti ga̱ shin Yesu zhel gwa ma̱n cilti.>> ");
INSERT INTO gyz_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Sa̱ pak ngemi Nya wugo yek bii gwe sa̱ na̱ma ngemti Nyami giɓi wu nwu i'e, yek ta̱ njika̱n mbadl gwasa̱n na̱ Shishi gwasi yek sa̱ ngusi dla̱mti ga̱ɓa gwas na̱ nda̱li mbadli. ");
INSERT INTO gyz_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Yek ma̱n kopti da̱m na̱ mbadl ɗe na̱m suk daamti ɗe na̱m mas jwasa̱n. Ko gon wule ilga̱n go gi so, na̱k ɗe mas wul jwasa̱n wo ka̱ lu ɗe na̱m ka̱n ni wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Yek mil shinti ngusi dla̱mti ga̱ɓa mbala̱n ten tlit ɗa̱ka̱ ma̱shka̱n ka ga̱ Yesu, kangwe Shishi ga̱ Nya ba̱lsi nda̱lti pa̱lti wu. Yek Nya ba̱lsi hwa wul gwasi mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ko gon gwasa̱n da̱mi a ba̱ ilgon niɗɗa̱ so so, na̱k ɗe mas ma̱jwe lubii sogo lu nisi ɗa̱ go asa̱ wul ka asa̱ ta̱la wulpi te ɗi, ");
INSERT INTO gyz_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mal mil shinti ji botli, asa̱ hwuli ma̱n koptisi kangwe kokko lami wu. ");
INSERT INTO gyz_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Nu ka̱n Yusupu gwe a mil shinti ji botli mbet ɗe Barnabas pa̱li. Shin Barnabas wo yek ɗe ma̱n nda̱lla̱t mbadli. Ti wo ma̱n boo ga̱ Lawi ka̱n tet ten za̱nda̱l Kuburus. ");
INSERT INTO gyz_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yek ta̱ wul lu gon gwas ka, yek ta̱ ta̱la wulpi tet mal mil shinti ji botli. ");
INSERT INTO gyz_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Yek ma̱lgon gwe asa̱ mbet ɗe Hananiya suk kili gwasi Sapiratu wu wul lu gon gwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yek ta̱ ɓel bi suk kilisi yek sa̱ hwuda̱l naa wulpi ka. Yek ta̱ ta̱la naami tet mal mil shinti ji botli. ");
INSERT INTO gyz_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Yek Biturus wulti ɗe, <<Hananiya, yek laki yek guu ma̱zhe njika̱n mbadl gwa nu hal yek ka̱ sheli lal Shishi ga̱ Nya ye, ɗe ka̱ hwuda̱l naa wulpi lwisi ka̱wu? ");
INSERT INTO gyz_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ale lwisi wo gwaka̱n na̱ ɗe ba̱ ka̱ ɓo wul ka̱ sowu? A wulpi lwisi mago gwa. Yek mbik ɗe ka̱ pa̱li nu ye? Nya ka̱n ka̱ shelti, mbala̱n ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Yek Hananiya kumi nu wugo yek ta̱ nda atli, ka̱li-ka̱li yek ta̱ ma̱shi. Mas mbala̱n kumi nu wugo yek ɓanti cisi ka. ");
INSERT INTO gyz_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Yek mil samali tlinya yek sa̱ kan hwu gwasi yek sa̱ lak lepti. ");
INSERT INTO gyz_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","La̱m da̱nti wugo yek kilisi tul ka̱li a bata̱ yis ilgwe pi wu so. ");
INSERT INTO gyz_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yek Biturus ngemti ɗe, <<Dla̱mini, kangwe ki suk kos gwa wul lu gwaka̱n ka̱ wuk gwa?>> Yek ta̱ wuli ɗe, <<Yii, nu ka̱n ma̱ wul ka.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Yek Biturus wulti ɗe, <<Yek laki yek ka̱ ɓel bi suk kos gwa ta̱k cinga̱la̱n Shishi ga̱ Nya ye? Yekgu, asa̱n ji ma̱jwe lep kos gwa wu ka wullu ten bi dlabii wu, a ki mago nu ka̱n sa kanki asa sak lepki pak.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Yek ta̱ nda atl ka̱li-ka̱li a cina ɗa̱ Biturus ka, yek ta̱ ma̱shi. Yek mil samali te suɗi yek sa̱ mbi hwuuni gwasi, yek sa̱ kanti yek sa̱ lak lepti a malka̱n ɗa̱ kos gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Yek mas motgaa ga̱ ma̱n kopti ji Wurshelima ɓanti ka, suk mas ma̱jwe kum ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yek mil shinti ji botli pa̱l wul cit ɓanti wonti ka̱ dlo ga̱ mbala̱n. Yek mas ma̱n kopti ngusi motgaa ka̱ lu gwe asa̱ mbe ɗe Baranda ga̱ Sulemanu wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ko ɗe mbala̱n ba̱lsi nalti i'e wu, ama ba̱ ma̱lgon ka̱ naa mbala̱n mbi nda̱li gahwula̱n cutgaa suksi so. ");
INSERT INTO gyz_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mas na̱ nu go, yek wonta̱t ga̱ ma̱jwe nga̱ssi ten Yesu wu ngusi mba̱lti dli na̱ modli na̱ maani wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Nuk laki yek mbala̱n ngusi yilla̱t ɗa̱ ma̱n cwo to deɓa̱l ɗa̱n ten lumulti ka ka̱ ba̱mi, kangwe ɗe ko ta̱ shishi ga̱ Biturus mago ta̱ ta̱n jon jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hal tet ka̱ ba̱n jwe ni njaa mal Wurshelima wu mago, mbala̱n tulli ma̱n cwo jwasa̱n suk ma̱jwe ma̱zhe ni ka̱si wu. Yek sa̱ ndoki mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Yek bali ga̱ ma̱n Pa̱ris suk yilkeni jwas daka̱l i'e, ma̱jwe sa̱ ni ka̱ mbala̱n jwe asa̱ mbesi ɗe ma̱n Saduki wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yek sa̱ dop mil shinti ji botlisi yek sa̱ yitlasi ka, ka̱ bii gwe asa̱ yitla ma̱jwe pa̱l byas wul wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ama yek yen shinti ga̱ Nya ɓul dlabii bii yitlatisi ka yek ta̱ yilla̱si, yek ta̱ wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<La̱n lubii ga̱ Nya ta̱k te gib boo, aka̱a̱ dla̱l nya a dii boomi ta̱k hwi ga̱ɓa mbala̱n mas ten pyal tantu da̱mti gee.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Lu tlo wugo yek sa̱ te gib boo lubii ga̱ Nyami na̱k gwe yen shinti hwisi wu, yek sa̱ njeli hwit ga̱ɓa mbala̱n. Bal ma̱n Pa̱rismi tuli suk ma̱ jwas wu yek ta̱ mbe mas kolsi ji dlaboo Sanhidirin, yek ta̱ shinlu ɗe ta̱s yilli mil shinti ji botlisi teɗi. ");
INSERT INTO gyz_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yek ma̱n hapti dlo li ka̱li wu yek ba̱sa̱ mbisi a giɓi so. Yek sa̱ lak hwi kiɗi jwasa̱n ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","<<Ma̱ mbi lu yitlatisi ga̱ yitle ka nda̱li, a ma̱n ɓa̱tti dlabiimi ni ka̱li, ama yek ma̱ ɓul wugo yek ba̱ma̱ mbi ma̱lgon a giɓi so.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kiɗi ma̱n Pa̱rismi suk bacina ga̱ ma̱n hapti dlomi kumi nu wugo, yek ili gulsa̱si na̱k ɗe ba̱sa̱ yis ilgwe a pi wu sowu. ");
INSERT INTO gyz_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Yek ma̱lgon gwe kum mil shintisi ten ga̱ɓa wu, tul ka̱ motgaa Sanhidirimi yek ta̱ hwisi ɗe, <<Ma̱jwe ka̱a̱ yitlasi go, sa̱ ni te ka̱ lubii ga̱ Nya sa̱ nima ta hwit ga̱ɓa mbala̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Yek bacina ga̱ ma̱n hapti dlomi li ka̱li suk ma̱jwasi yek sa̱ yemsi teɗi. Sa̱ lak mil shintisi ten la̱t ngetli so, na̱k ɗe ɓanti na̱ma cit gwasa̱n ɗe gon a mbala̱n laksi na̱ ye wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sa̱ tulla̱si dlaboo motgaa Sanhidirin wu, yek bal ma̱n Pa̱rismi ngemsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","<<Ma̱ wula̱nkii ɗe ba̱k po hwi ga̱ɓa mbala̱n ten shin ga̱ ma̱llu so sa? Ama yek ga̱ɓa gwaka̱n ngash ba̱n Wurshelima wi mas. A lamti gwaka̱n wo ta̱k wuli ɗe mik tloti.>> ");
INSERT INTO gyz_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Yek Biturus ka̱ lal ga̱ naa mil shinti ji botlisi wulsi ɗe, <<Ngetli ka̱n nini ta̱n kop ga̱ɓa ga̱ Nya man ga̱ɓa ga̱ mbala̱n!>> ");
INSERT INTO gyz_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nya gwe aba jina̱n ngusit atl wu, tik palli Yesu kaami ma̱lgwe ka̱a̱ tloti ɗe ka̱ ɓakti ten guda̱l yencin wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Yek Nya ba̱lti nalti yek ta̱ palla̱t ɗe guu suk ma̱n kisti. Yek ta̱ za̱t ten ang shinti gwasi, ta̱s ɓul tantu gwe ma̱n Yisiraila a ci atl gaa wu, ata̱ taasisi byas wul jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Mik yen ilgwe pi wu na̱ gwel ga̱na̱n. Shishi ga̱ Nya gwe a Nya ba̱l ma̱jwe kumit bi wu mago ta̱ dla̱m ga̱ɓa dani. ");
INSERT INTO gyz_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Sa̱ kumi nu wugo yek mbadl lilisi i'e wule sa tlosi ka. ");
INSERT INTO gyz_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Yek ba Paresi gon asa̱ mbet ɗe Gamaliyel ma̱n yisti mba̱t ga̱ɓa ga̱ Musa, tik ɗe ma̱lgwe a mas mbala̱n ba̱lti nalti i'e wu. Yek ta̱ tlinya a nya ka̱ dlaboo Sanhidirimi. Yek ta̱ wule ta̱ mil shinti ji botlisi ɓo nak yil deɓa̱l. ");
INSERT INTO gyz_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Yek ta̱ hwi kosisi ɗe, <<Kii ma̱n Yisiraila, pa̱n ɗem'ɗem ten ilgwe ka̱a̱ na̱ma lamti ta̱k pa̱li ma̱jin wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ka̱ multi jon tek go ma̱lgon asa̱ mbet ɗe Tudas ya yili yek ta̱ ngusi mbokti ang ten gaa gwasi, ɗe ti wo ilgon ka̱n. Yek mbala̱n zamba̱l ɗe wupsi (400) kop ga̱ɓa gwasi. Yek ma̱jon tlot ka, yek ma̱jwe kop ga̱ɓa gwas wu cat ɗa̱nka. ");
INSERT INTO gyz_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kaal ɗati, yek ma̱n Galili gon asa̱ mbet ɗe Yehuda ten gini gwe sa̱ dla̱m wonta̱t ga̱ mbala̱n wu. Ta̱ po shel mbala̱mi jon pak, ama ti mago yek sa̱ tloti. Yek ma̱jwe kopti wu cat ɗa̱nka̱ pak. ");
INSERT INTO gyz_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","A na̱ma ngemti gwaka̱n ten ga̱ɓa gee ta̱k zaka̱n ma̱jin ta̱s zigaa, kume ilgwe sa̱ na̱ma dla̱mti go pa̱lti ga̱ mbala̱n ka̱wu, a li tu gon so. ");
INSERT INTO gyz_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ama kume ga̱ Nya ka̱wu, ka man dla̱lla̱t gwasa̱n ka̱ so, se ko ta̱k da̱ma̱n ɗe ma̱n nget ilgwe Nya pa̱li wu.>> Yek ga̱ɓa ga̱ Gamaliyel ta̱n mbadl gwasa̱n, ");
INSERT INTO gyz_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","yek sa̱ mbe mil shinti ji botlisi suɗi yek sa̱ ɓosi. Yek paa sa̱ wulsi ɗe ba̱s po ga̱ɓa ten bi ga̱ Yesu so. Yek sa̱ zaksi. ");
INSERT INTO gyz_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Yek mil shinti ji botlisi yil ɗa̱ka̱ lu motgaa Sanhidirimi ka na̱ hwol tuki, na̱k ɗe sa̱ mbuki ta̱s tla bomti ten bi ga̱ Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Mas cin yek sa̱ ngusi dla̱mti ta̱mi ga̱ɓa mbala̱n asa̱ nisi ma mbokti ang ɗe Yesu ka̱ɗe Almasihu ka̱ lubii ga̱ Nyami suk lubii lubii. ");
INSERT INTO gyz_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ka̱ multi jwe wonta̱t ga̱ ma̱n kopti na̱ma mba̱lti dli wu, yek ma̱n Yehuda ma̱n ga̱ɓa na̱ bi Giris njel nala̱nti ten ma̱n Yehuda ma̱n ga̱ɓa na̱ bi Arameya, ɗe modli jwe maani jwasa̱n ma̱sh wugo ba̱sa̱ mbi ilga̱ nguki gwe asa̱ ba̱li mas cin wu ndakce suk naa modlisi so. ");
INSERT INTO gyz_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yek mil shinti ji botli ɗe kutl cet lop ju mbe motgaa ga̱ mas ma̱n kopti, yek sa̱ wulsi ɗe, <<Mbun ɗe ta̱n zaka̱n bi dla̱mti ga̱ɓa ga̱ Nya ama̱ pala̱n ten bi huulti ilga̱ nguki ya? ");
INSERT INTO gyz_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yilkeni jina̱n, botla̱n mbala̱n ɗe nitgi ka̱ kii ma̱jwe ka̱a̱ yissi ɗe ma̱n ɓotlka̱n, a Shishi ga̱ Nya ni ka̱ mbadl gwasa̱n wu, ta̱s zini gwel ten bi huulti ilga̱ ngukisi. ");
INSERT INTO gyz_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mi wo ma za̱n mbadl ga̱na̱n ten ngemti Nya suk dla̱mti ga̱ɓa ten Yesu.>> ");
INSERT INTO gyz_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Yek ga̱ɓe ta̱mi ma̱n koptisi ɗa mas jwasa̱n. Yek sa̱ botl Istipanus ma̱lgwe nga̱sti ten Yesu i'e, a Shishi ga̱ Nya ni gipti pak wu. Yek sa̱ botl Pilibus suk Burokoras suk Nikano suk Timan suk Parminas suk Nikolas ma̱n Antakiya ma̱lgwe te ka̱ kopti Nya ga̱ ma̱n Yehuda wu pak. ");
INSERT INTO gyz_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Yek sa̱ ta̱la ma̱jwisi mal mil shinti ji botli, yek mil shintisi wutisi ang gaa, yek sa̱ ngemisi Nya. ");
INSERT INTO gyz_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yek wonti mbala̱n kum ga̱ɓa ga̱ Nya ɗa̱nka. Yek ma̱n kopti wonti a Wurshelima i'e, yek ma̱n Pa̱ris wonti njel nga̱ssi ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nya ba̱l Istipanus hwa wul gwasi, suk nda̱lti pa̱lti wul, yek ta̱ man pa̱lti kiɗi wul cit ɓanti ka̱ mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Yek ma̱jon jwe sa̱ yil tet ka̱ bii motgaa gon gwe asa̱ mbe ɗe Ma̱jwe Mbi Gaa Gwasa̱n Wu. Sa̱ yil tet ka̱ ba̱n Sayirin suk Alekzandiriya suk atl ga̱ Silisiya suk Asiya. Yek sa̱ ngusi dla̱kti ga̱ɓa suk Istipanus. ");
INSERT INTO gyz_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ama yek ba̱sa̱ mani na̱ Shishi ga̱ Nya gwe ni ka̱ mbadl gwas wu so suk ɓotlka̱n ga̱ɓa gwas so. ");
INSERT INTO gyz_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Yek sa̱ cok ma̱jon mukli ta̱s wuli ɗe, <<Ma̱ kum Istipanus ten dla̱mti ga̱ɓa mbulti ga̱ Nya, suk ten Musa ma̱n dla̱mti ga̱ɓa gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Yek sa̱ tlil mbadl ga̱ mbala̱n suk bacina jwasa̱n suk ma̱n yisti mba̱t ga̱ɓa ga̱ Musa. Yek sa̱ lak dop Istipanus, yek sa̱ ta̱lat dlaboo Sanhidirin. ");
INSERT INTO gyz_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Yek sa̱ tulli ma̱n shelti lali, yek sa̱ shelit lal gaa ɗe, <<A ma̱lga̱n sa ten dla̱mti byas ga̱ɓa ten lubii ga̱ Nya ma̱n cilti gee suk ten mba̱t ga̱ɓa ga̱ Musa. ");
INSERT INTO gyz_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ma̱ kumti ten dla̱mti ɗe we Yesu ma̱n Nazarat wu a jek bii gee ka, ata̱ laki a ba̱ma po da̱ma̱n na̱k gwe Musa mboki ang aba jina̱n wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yek mas ma̱jwe ni ka̱ dlaboomi wu wuti gwel Istipanus, yek sa̱ yeni go cinagwel gwas wo na̱k ga̱ yen shinti ga̱ Nya ka̱n ni. ");
INSERT INTO gyz_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Yek bali ga̱ ma̱n da̱nti ka̱ lubii ga̱ Nya ngem Istipanus ɗe, <<Iljin ɗe sa̱ dla̱m tenki go gem ma?>> ");
INSERT INTO gyz_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yek Istipanus wulsi ɗe, <<Yilkeni jini suk aba jini, ɓo katini nini ka̱ng. Nya ma̱n nalti mboki ang koli ga̱na̱n Ibirahim ten kangwe ta̱ ni wu a ta̱ yi Mesopotamiya a ba̱ta̱ ɓo da̱m a Haran so. ");
INSERT INTO gyz_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nyami wulti ɗe, <Zak atl gwa suk ma̱jwa ta̱k li ka̱t atl gwe ba mbokik ang dani wu.> ");
INSERT INTO gyz_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","<<Yek ta̱ zak ka̱t atl ga̱ ma̱n Kaldiya yek ta̱ lak da̱m a ba̱n Haran. Koli gwas ma̱sh wugo yek Nya ta̱la̱t tet ka̱ lu ga̱n ɗe ka̱a̱ na̱ma da̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nyami ba̱l lu Ibirahim a ɗe so ko njet. Ama ta̱ dla̱lli ga̱ɓa sukti ɗe ta ba̱lti lu ge suk ma̱n ga̱s jwasi, ko ɗe a ba̱ yen ɓo niɗɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Yek Nya wulti ɗe, <Mil jwa a pa̱l da̱mti ma̱nda̱ki ka̱ atl gwe ba̱ gwasa̱n ka̱ sowu, asa palla̱si ɗe zhel asa̱ tla bomti se sa̱ pa̱l gin zamba̱l ɗe wupsi. ");
INSERT INTO gyz_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ama ba nol ma̱n atl gwe palla̱si ɗe zhel wu. Kaal ɗa̱ nugo, mil jwa a yil tet ɗa̱ka̱ atl gwisi ka asa̱ ba̱la̱n nalti ka̱ lu gee.> ");
INSERT INTO gyz_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Yek Nya dla̱lli ga̱ɓa suk Ibirahim ten bi pa̱lti sa̱lti ta̱ mbok ang ɗe ti wo mbala̱n gwas ka̱n. Yek Ibirahim zi Ishiyaku wu, yek ta̱ sa̱lti ten cin na wusupsi kaal ɗa̱ za̱t gwasi. Kaal ɗa̱ nu, yek Ishiyaku zi Yakubu, yek Yakubu wut aba jina̱n ɗe kutl cet lop jwe ma̱ yisa̱nsi ju. ");
INSERT INTO gyz_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<Yek daka̱lti lak aba jina̱n jwisi ten wulti Yusupu yilka gwasa̱n ka, sa̱ wulti ka̱ɗe zhel ka̱ atl ga̱ Masar. Ama a Nya ni sukti ");
INSERT INTO gyz_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","yek ta̱ yilla̱t ɗa̱ka̱ mas bomti gwe ta̱ tla wu ka. Yek Nya ba̱lti ɓotlka̱n yisti wul suk hwol hwulan mal Pir'auna guu ga̱ ma̱n Masar. Yek ta̱ palla̱t ɗe guu a Masar suk bacina kaal ɗati. ");
INSERT INTO gyz_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","<<Yek bal kuza̱n gon nda ten mas atl ga̱ Masar suk atl ga̱ Kan'ana. Yek mbala̱n wonti te ka̱ bomti i'e na̱k ɗe ilga̱ nguki niɗɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Yek Yakubu kumi ɗe ilga̱ nguki ni Masar wugo, yek ta̱ shin aba jina̱n, yek ɗe ndat la̱t gwasa̱n Masar. ");
INSERT INTO gyz_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","La̱t gwasa̱n na lop wo, yek Yusupu hwi yilkeni jwas ɗe ti ka̱n. Yek Pir'auna yis ma̱n boo gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kaal ɗa̱ nu, yek Yusupu laki ta̱s mbe aba gwas Yakubu teɗi suk ma̱n lubii gwasi mas, si ɗe kutl nitgi na̱ namtan. ");
INSERT INTO gyz_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yek Yakubu li Masar, ka̱li ka̱n ta̱ ma̱shi suk aba jina̱n. ");
INSERT INTO gyz_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yek sa̱ palli hwuu gwasa̱n tot Shekem, yek sa̱ lepsi ka̱ gazukɗi gwe Ibirahim wul mal mil ji Hamor wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","<<Ɓal njaa ɗe ta̱ Nya njika̱n ga̱ɓa gwe ta̱ dla̱lli suk Ibirahim wugo, yek mbala̱n jina̱n wonti a Masar i'e. ");
INSERT INTO gyz_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Yek ma̱lgon gwe ba̱ta̱ yis Yusupu sowu da̱n ɗe Pir'auna guu ga̱ Masar. ");
INSERT INTO gyz_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Guu gwisi ka̱ lak aba jina̱n ten tlat bomti, tik cisi dlelngapcan yek zisi ngetli ta̱s wut mil la̱li jwasa̱n ka ta̱s ma̱sh ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","<<Ka̱ multi jwisi ka̱n sa̱ zi Musa, yen ma̱n mbunti i'e. Yek sa̱ keta̱lti ɗa̱ aba gwas ka lip ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma̱n za̱t jwas yilla̱t deɓa̱l wu, yek yen ga̱ ma̱dli ga̱ Pir'auna kanti yek ta̱ keta̱lti ɗe yen gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Musa pa̱l lishti ga̱ ma̱n Masar suk ɓotlka̱n yisti wul gwasa̱n. Yek laki yek ta̱ mbi nda̱lti pa̱lti wul suk yek ta̱ man ga̱ɓa i'e. ");
INSERT INTO gyz_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Ta̱ ɓal ka̱ gin ɗe kutl ɗe wupsi go yek ta̱ kumi ka̱ mbadl gwas ɗe, ta̱s lak yen yilkeni jwasi ma̱n Yisiraila. ");
INSERT INTO gyz_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ta̱ li malsi yek ta̱ yen kangwe ba Masar gon na̱ma ɓot ga̱ ba Israila gon wu, yek ta̱ lak ɓetti ti hal yek ta̱ tloti. ");
INSERT INTO gyz_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muse da̱m gwa we yilkeni jwas ma̱n Yisiraila a yisi ɗe Nya shinti ta̱s yilla̱si ɗa̱ka̱ da̱mti ɗe zhel ka, ama yek ba̱sa̱ yisi so. ");
INSERT INTO gyz_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kaal ɗa̱ multi ɗe na̱m, yek ta̱ mbi ma̱n Yisiraila jon ɗe lop ten dlanti gwasa̱n. Yek ta̱ tesi dlo ɗe ta̱s la̱ka̱n dlo gwasa̱n, yek ta̱ wulsi ɗe, <Kii wo yilkeni ka̱n, yek laki ɗe ka̱a̱ na̱ma dlanti gwaka̱n ye?> ");
INSERT INTO gyz_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","<<Yek ma̱lgwe kumi cwo yilka gwas wu wul Musa ɗe, <Wok lakki ɗe bagaa suk ma̱n kisti ga̱ɓa ga̱na̱n wo? ");
INSERT INTO gyz_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ka̱ na̱ma lamti ta̱k tloni na̱k gwe ka̱ tlo ba Masar ahwul gwa?> ");
INSERT INTO gyz_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musa kumi nu wugo yek ta̱ ap te atl ga̱ Midiya ka, yek ta̱ pa̱l da̱nti ma̱nda̱ki. Ka̱li ka̱n ta̱ wut mil maani ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<Kaal ɗa̱ gin ɗe kutl ɗe wupsi, yek Nya tul mal Musa na̱k wule yen shinti gon gwasi ka̱ ba̱lba̱l wutu ten luda̱n ka̱ me, njaa mal tla̱nda̱l Sinai. ");
INSERT INTO gyz_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musa yeni nu wugo yek ɓanti citi yek ta̱ am te mali ka ta̱s yeni i'e ɗa. Ta̱ am tek wugo yek Nya ga̱ɓa sukti ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<Amik ɗe Nya ga̱ aba jwaka̱n, Nya ga̱ Ibirahim suk ga̱ Ishiyaku suk ga̱ Yakubu.> Ta̱ kumi nu wugo yek ɓanti citi i'e yek ta̱ njel da̱dalti, yek ba̱ta̱ po man yenti luda̱mi so. ");
INSERT INTO gyz_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","<<Yek Nya wulti ɗe, <Tus kapta̱lan gwa ka, lu gwe ka̱ dla̱l dani go lu gi ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A yen kangwe mbala̱n ji na̱ma tlat bomti a Masar wu, a kum kulu gwasa̱n ga̱ kumti dli wi, yek a susut wi ta kissi. Ningo teɗi ta shinki te Masari ka.> ");
INSERT INTO gyz_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<Musa ga̱mi ɗe sa̱ ngeti ɗe sa̱ dla̱m ɗe, <i lakki ɗe bagaa suk ma̱n kisti ga̱ɓa ga̱na̱n wo wu?> Ti ka̱n Nya shinti ta̱s da̱n ɗe bagaa suk ma̱n kisti gwasa̱n ɗa̱ka̱ da̱mti ɗe zhel ka, tumal yen shinti gwas gwe tul malti ka̱ ba̱lba̱l wutu ten luda̱n ka̱ me wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Muse ka̱ yilla̱si ɗa̱ka̱ atl ga̱ Masar ka. Yek ta̱ pa̱l kiɗi wul cit ɓanti ka̱ dlo gwasa̱n a ka̱li, suk dla̱lka bal ze gwe asa̱ mbe ɗe Zil bal ze wu, suk wul cit ɓantisi jwe ta̱ pa̱li ka̱ gin ɗe kutl ɗe wupsi jwe ma̱n Yisiraila pa̱li ka̱ me wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","<<Tik wul ma̱n Yisiraila ɗe, <Nya a shin ma̱n dla̱mti ga̱ɓa gwas gon na̱k gwe ta̱ shina̱n wu, ka̱ dlo gwaka̱n tet ka̱ mbala̱n jwaka̱n.> ");
INSERT INTO gyz_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Tik mwe gaa aba jina̱n ma̱n Yisiraila ka̱ lu ɗe na̱m ka̱ me, suk yen shinti ga̱ Nya gwe ga̱ɓa sukti ten tla̱nda̱l Sinai wu. Yek Nya hwit ga̱ɓa ten kangwe mbala̱n a mbi mbadl wu, ɗe ta̱s hwinii. ");
INSERT INTO gyz_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","<<Ama yek aba jina̱n nge kopti ga̱ɓa gwasi. Yek sa̱ ngeti. Yek sa̱ lam palti te atl ga̱ Masar ka̱ mani. ");
INSERT INTO gyz_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yek sa̱ hwi Haruna yilka gwas ɗe, <Pa̱lini gunki gwe ma ngusit atli ata̱ ndenii cina wu. Musa ɗe ta̱ yilla̱ni tet ka̱ atl ga̱ Masar go ma̱ po yis ilgwe mbit wu so!> ");
INSERT INTO gyz_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ka̱li ka̱n sa̱ pa̱l gunki gon na̱k yen tla. Yek sa̱ takit wul, yek sa̱ pa̱l hwol tuk na̱ ilgwe sa̱ pa̱li na̱ ang gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yek Nya yil ɗa̱ka̱ tantu jwasa̱n ka, yek ta̱ zaksi ta̱s ngusi atl cin suk kyatla̱l ɗa. Na̱k gwe ni ga̱ lishi ka̱ lishti ga̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya wu. << <Kii ma̱n boo ga̱ Israila, ami ka̱n ka̱ ba̱la̱n nalti ka̱ gin ɗe kutl ɗe wupsi ka̱ me gwa? ");
INSERT INTO gyz_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ka̱a̱ ba̱l nalti lu waal ga̱ gunki gwaka̱n gwe aka̱a̱ mbet ɗe Molek, suk kyatla̱l ga̱ gunki gwaka̱n gwe aka̱a̱ mbet ɗe Rampan wu. Gunki jimi ka̱ɗe wul jwe ka̱a̱ pa̱lsi ɗe ta̱k ngusisi atl wu. Yek laki ningo ba laki asa̱ ta̱lakii cina ɗa̱ atl ga̱ Babila ka.> ");
INSERT INTO gyz_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Tenti ni aba jina̱n ɗa gwe sa̱ ngusi la̱t na̱ nali ka̱ me wu. Tenti gwisi ka̱n Nya hwi Musa ɗe ta̱s pa̱li, yek ta̱ pa̱li kangwe Nyami hwit ɗu. ");
INSERT INTO gyz_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tenti gwisi ka̱n sa̱ lak mbi ka̱ gini jwe Joshuwa ndesi cina, ɗe ta̱ mbolisi ma̱n atl ga̱ Kan'ana ka̱wu. Tenti gwisi ni ɗa hal yek la gini gwe Dauda da̱n ɗe guu ga̱ Israila wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dauda ka̱ mbi hwol hwulan mal Nya, yek ta̱ ngemti ɗe ta̱s kini lubii Nya ga̱ Yakubu, lubii gwe ma̱n Yisiraila a ngusit atl giɓi wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","48","<<Ko ɗe ba̱ Nya Bal Kakshe a da̱n ka̱ lubii gwe a mbala̱n kin sowu, yek Sulemanu yen ga̱ Daude kin bal lubiimi. Na̱k gwe ma̱n dla̱mti ga̱ɓa ga̱ Nya gon dla̱m wu ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<< <Bagaa Nya dla̱m ɗe, Dlo nya ka̱ɗe gobdlan guu gini, a dii atl ka̱ɗe lu za̱t asa̱n gini. Wuda̱l ga̱ bii gwi ka̱n kaa kini gwi? A ko ka̱n lu shukti gini ko? ");
INSERT INTO gyz_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Amik pa̱l mas wul jwisi na̱ ang gi sa?> ");
INSERT INTO gyz_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<Kii mbala̱n ma̱n la̱shi kumti bi, kii ɗe ka̱ nge ba̱lti Nya mbadl jwaka̱n wu. Dlip ba̱kaa kan ga̱ɓa ga̱ Shishi ga̱ Nya so na̱k aba jwaka̱n pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ma̱n dla̱mti ga̱ɓa ga̱ Nya gon gwe ba̱ aba jwaka̱n cit dlelngapcan sowu niɗɗa̱ so. Ma̱jwe dla̱m bi tulti ga̱ ma̱n zok mbadl wu mago sa̱ tlosi ka. A ningo ka̱a̱ ba̱l bi gwasi yek ka̱a̱ tlot wi. ");
INSERT INTO gyz_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kii ɗe mil shinti ji Nya ba̱lkii mba̱t ga̱ɓa ga̱ gwasi yek ba̱ka̱a̱ man kopti sowu.>> ");
INSERT INTO gyz_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ma̱n dlaboomi kumi nu wugo, yek mbadl lilisi i'e hal yek sa̱ as shin. ");
INSERT INTO gyz_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Shishi ga̱ Nya njika̱n mbadl ga̱ Istipanus wugo yek ta̱ lak gaa to dlo nya ka, yek ta̱ yen nalti ga̱ Nya, a Yesu ni ga̱ dla̱lli njaa malti ten ang shinti gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Yek Istipanus wule, <<A yen dlo nya ga̱ ɓuli, yek a yen Yen ga̱ Mbala̱n, ta̱ dla̱l njaa mal Nya ten ang shinti gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yek sa̱ cek ka̱ng jwasa̱n ka na̱ ang, yek sa̱ lak yal, yek sa̱ tli tet tenti ka mas jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Yek sa̱ dla̱kti te kaal ba̱n ka, yek sa̱ njel lakti gwas na̱ ye. Yek ma̱jwe tulli ga̱ɓa tenti wu wut luka̱l jwasa̱n mal yen samali gon gwe asa̱ mbet ɗe Shawulu wu. ");
INSERT INTO gyz_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Sa̱ na̱ma lakti ga̱ Istipanus nugo yek ta̱ ngem Yesu ɗe, <<Bagaa Yesu, kan mbadl gini.>> ");
INSERT INTO gyz_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Yek ta̱ nda na̱ gahwula̱n, yek ta̱ wuli na̱ nda̱lti ɗe, <<Bagaa, taasi ma̱jin byas ilga̱n ɗe sa̱ pa̱li wu ka.>> Yek multi gwas paki. ");
INSERT INTO gyz_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","A Shawulu ni ka̱li ata̱ nima pit kaal ma̱n tlot ga̱ Istipanus. Ten cin gwisi ka̱n sa̱ ci dlelngapcan motgaa ga̱ ma̱n kopti i'e a Wurshelima. Yek ma̱n koptisi cat ɗa̱nka̱ atl ji Yehudiya suk Samariya ka. Mil shinti ji botli ka̱ sa ka̱li na̱ ngusa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Yek ma̱jwe asa̱ ngusi atl Nya i'e wu lep Istipanus. Yek sa̱ mul ma̱shka̱n gwasi na̱ duu tuk i'e. ");
INSERT INTO gyz_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yek Shawulu ngusi dlot gwas ten cit dlelngapcan motgaa ga̱ ma̱n kopti. Ta̱ ngusi kopti lubii lubii ata̱ dopsi na̱ maani na̱ modli ata̱ na̱ma yitlat gwasa̱n ka ka̱ bii gwe asa̱ yitla ma̱jwe pa̱l byas wullu. ");
INSERT INTO gyz_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yek ma̱jwe sa̱ catsi ɗa̱nka̱ wu ngusi ma̱tlti asa̱ na̱ma dla̱mti ta̱mi ga̱ɓa ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilibus su ka̱ bal ba̱n gon ga̱ Samariya, yek ta̱ dla̱mi ga̱ɓa mbala̱n ten Almasihu ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Yek mas ma̱n ba̱mi kat ka̱ng ka̱ ga̱ɓa gwe Pilibus dla̱msi wu na̱k ɗe sa̱ yen wul cit ɓanti gwe ta̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Na̱k ɗe na̱ da̱dalti suk desti lee ka̱n a duu ma̱zhe ngusi yilti ɗa̱ka̱ wonti ma̱jwe sa̱ te gipsi wu ka. Yek ma̱jwe dli jwasa̱n tla ka̱wu suk kulki ndoki wonti. ");
INSERT INTO gyz_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yek mbala̱n ji ba̱mi pa̱l hwol tuk i'e. ");
INSERT INTO gyz_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma̱lgon ni ɗa̱ asa̱ mbet ɗe Siman, ta̱ la̱m multi ten pa̱lti waali ka̱ ba̱n a ɓanti ci ma̱n atl ga̱ Samariya ten ilgwe ta̱ pa̱li wu. Ta̱ ɓa yen gaa gwas go ɗe ti wo bal mbala̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ti ka̱n a ma̱n Samariye mas na̱ kakshe na̱ nak'eni katit ka̱ng, asa̱ kul wule, <<Ma̱lga̱n go tik ɗe ma̱n nda̱lti pa̱lti wul ga̱ nya gwe asa̱ mbet ɗe ma̱n pa̱lti wul cit ɓanti wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ti ka̱n asa̱ kop ga̱ɓa gwasi na̱k ɗe sa̱ kuu na̱ yenti wul cit ɓanti ka̱ waal gwe ata̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ama mbala̱mi kum ta̱mi ga̱ɓa gwe Pilibus dla̱misi ten Nya ɗe guu suk ten bi shin ga̱ Almasihu Yesu wu, yek sa̱ ba̱l gem na̱ ga̱ɓa ga̱ Pilibus. Yek ta̱ pa̱lisi baptisma na̱ modli na̱ maani. ");
INSERT INTO gyz_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Yek Siman nga̱sti ten Yesusi pak, yek sa̱ pa̱lit baptisma, yek ta̱ ngusi kopti ga̱ Pilibus mas lu gwe ta̱ li wu, yek Siman ngip bi ka̱ ang na̱ yenti kiɗi wul cit ɓanti malti. ");
INSERT INTO gyz_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Mil shinti ji botli kumi wi ɗe ma̱n Samariya ɓal ɗe ma̱n kopti wu, yek sa̱ shin Biturus suk Yohana malsi. ");
INSERT INTO gyz_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Biturus suk Yohana mbuki malsi wugo, yek sa̱ ngemisi Nya ɗe ta̱ Shishi ga̱ Nya susut tensi. ");
INSERT INTO gyz_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Sa̱ pa̱li na̱k gwisi na̱k ɗe Shishi ga̱ Nyami ɓo susut tensi so, ɗe ya pa̱lisi baptisma na̱ shin ga̱ Yesu Bagaa wu. ");
INSERT INTO gyz_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yek Biturus suk Yohana wutisi ang gaa wu, yek Shishi ga̱ Nya susut tensi. ");
INSERT INTO gyz_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Siman yeni ɗe ang ka̱n a mil shinti zi mbala̱n ten gaa a Shishi ga̱ Nya susut tensi wu, yek ta̱ takisi wulpi, ");
INSERT INTO gyz_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","yek ta̱ wulsi ɗe, <<Mbokini nini ang kangwe ba zi-ang mbala̱n ten gaa asa̱ mbi Shishi ga̱ Nya wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Yek Biturus wulti ɗe, <<Ha̱n ta̱k paki ka̱ wutu ki suk wulpi gwa, na̱k ɗe ka̱ da̱ma̱n gwa we ka man wulti zok wul ga̱ Nya na̱ wulpi wu. ");
INSERT INTO gyz_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ze gwa ni ka̱ ilga̱n ɗe ma̱ na̱ma pa̱lti wu so, na̱k ɗe mbadl gwa ni hwaɓi mal Nya sowu. ");
INSERT INTO gyz_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ci atl gaa mal Nya ten byas mbadl gwe nik ɗa̱ wu, ta̱k ngem Nya ta̱s taasik byas wul gwe nikka̱ mbadl wu ka. ");
INSERT INTO gyz_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","A nikma dla̱mti na̱k gwisi na̱k ɗe aɓa yeni go yokit ni gipki i'e, a pa̱lti byas wul dop mbadl gwa wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Yek Siman wulti ɗe, <<Ngemini nini Nya ne, ba̱ ilgon ka̱ wul jin ɗe ka̱a̱ dla̱m wu mbi so.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Biturus suk Yohana hwi ga̱ɓa ten da̱mti gwasa̱n suk Yesu wu, yek sa̱ dla̱misi ta̱mi ga̱ɓa ga̱ Nya ka̱li, yek sa̱ pal tet Wurshelima. Ɗe sa̱ ɓal go yek sa̱ ngusi dla̱mti ta̱mi ga̱ɓe ɗa̱nka̱ nak mil ba̱n ji Samariya wonti jwe ni ten tantu wu. ");
INSERT INTO gyz_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Yek yen shinti ga̱ Nya gon wul Pilibus ɗe, <<Li tu kudu, aka̱ kop tantu la̱ɓi, gwe yil sut Wurshelima yek su Gaza wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Yek ta̱ nda tantu kaali. Ta̱ na̱ma la̱t nugo yek ta̱ mo suk ba Itiyopiya gon gwe ba̱ta man pa̱t suk modli sowu, kaksha mbala̱n ka̱ɗe ti. Tik ɗe ma̱n za̱t wul ga̱ guu ga̱ ma̱dli ga̱ Itiyopiya gwe asa̱ mbet ɗe Kandisi wu. Ta̱ li ta̱s ngusi Nya atl a Wurshelima, ");
INSERT INTO gyz_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ata̱ ɓal ten tantu palti. Ata̱ ni ka̱ kapsi ga̱lla gwasi ta̱ na̱ma dla̱mti ka̱ lishti ga̱ Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya to nya ka. ");
INSERT INTO gyz_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Yek Shishi ga̱ Nya wul Pilibus ɗe, <<Li te mal kapsi ga̱lle ka, ta̱k ngusi kopti gwas njaa-njaa.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Yek Pilibus li te mali ka na̱ apti, yek ta̱ kum ma̱li ten dla̱mti ka̱ lishti ga̱ Ishaya. Yek ta̱ ngemti ɗe, <<Lishti ga̱n ɗe ka̱ na̱ma dla̱mti go ka̱ yis gaami ya?>> ");
INSERT INTO gyz_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Yek ma̱li wulti ɗe, <<Ɗa̱ nii ka̱n ba yis gaami gwi, ɗe ba̱ ma̱lgon ka̱ mboki ang dani sowu?>> Yek ta̱ ngem Pilibus ɗe ta̱s te ka̱ kapsi ga̱lle malti. ");
INSERT INTO gyz_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ilgwe ma̱li na̱ma dla̱mti ka̱ ga̱ɓa ga̱ Nyami go, yek ɗe lu gwe wule, <<Sa̱ dla̱kti na̱k mba̱la gwe sa ta̱lat ka̱ lu mboshti wu. Na̱k gwe a ba̱ yen mba̱la a kul so ɗe sa̱ ɓa wutlit ma̱dla̱n ka̱wu, nu ka̱n ti mago yek ba̱ta̱ wule ilgon so. ");
INSERT INTO gyz_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Na̱k ɗe ba̱sa̱ palla̱t ɗe ilgon sowu, yek sa̱ nget pa̱lti hwa kisti ga̱ɓa wu. Wok ka man yisti ji mil jwas wo? Na̱k ɗe sa̱ kan mbadl gwas ɗa̱ ten dii atl ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Yek ma̱li ngem Pilibus ɗe, <<Ɓo hwini, ma̱n dla̱mti ga̱ɓa ga̱ Nya gwe lish lu ga̱n go ten gaa gwas ka̱n ta̱ na̱ma ga̱ɓa a, ko ten zobsi ma̱lgon?>> ");
INSERT INTO gyz_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Yek Pilibus ndet ga̱ɓa ten lishti gwisi, yek ta̱ hwit ta̱mi ga̱ɓa ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Sa̱ na̱ma la̱t nugo, yek sa̱ lak mbi ze gon. Yek ma̱li wul Pilibus ɗe, <<Ze ka̱wu, yek ka laki a ba̱ka pa̱li baptisma so ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Yek ta̱ laki yek kapsi ga̱lle dla̱li. Na̱ ti na̱ Pilibus yek sa̱ su ka̱ zesi yek Pilibus pa̱lit baptisma. ");
INSERT INTO gyz_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Sa̱ yil tot ɗa̱ka̱ zesi ka̱wu go, yek Shishi ga̱ Nya kan Pilibus ka. Yek ba̱ ta̱ po yenti so, ama yek ta̱ ngusi hwol tuki ata̱ na̱ma za̱tgaa. ");
INSERT INTO gyz_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Yek Pilibus lak mbi gaa gwas ka̱ ba̱n Azotus, yek ta̱ ngusi ma̱tlti ka̱ mas ba̱n jwe ni ka̱li wu ata̱ na̱ma dla̱mti ga̱ɓa ma̱n ta̱mti ten Yesu se na̱k ta̱ mbuki ka̱ ba̱n Kaisariya. ");
INSERT INTO gyz_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","A Shawulu yima cit dlelngapcan ma̱n kopti ji Bagaa Yesu, ata̱ na̱ma wulti ɗe ta tlosi ka. Yek ta̱ li mal bal ma̱n Pa̱ris, ");
INSERT INTO gyz_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yek ta̱ ngemti ɗe ta̱s lishit ga̱ɓa gwe ta lak ba̱li ka̱ bii motgaa jwe ni ka̱ ba̱n Demaskus wu. Ta̱ pa̱li na̱k gwisi kangwe ɗe ta̱ mbi ma̱jwe sa̱ na̱ma kopti Tantu ga̱ Yesu wugo ata̱ dopsi, ata̱ ɓalsi ka, ata̱ ta̱lasi tet Wurshelima na̱ modli na̱ maani wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ta̱ na̱ma la̱ti yek ta̱ ɓal njaa a Demaskus nugo, yek ba̱u! Cilti gon sut nya cilli lu gwe ta̱ ni wu ka. ");
INSERT INTO gyz_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Yek ta̱ nda atli, yek ta̱ kum yal ga̱ɓa gon gwe wulti ɗe, <<Shawulu! Yek laki yek ka̱ nima cit dlelngapcan ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Yek Shawulu wule, <<Bagaa, wok ɗe ki wo?>> Yek yal ga̱ɓe wule, <<Amik ɗe Yesu, ma̱lgwe ka̱ nitma cit dlelngapcan wu, na̱k ɗe ka̱ nima cit dlelngapcan ma̱n kopti ji wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Tlinya ta̱k li ka̱ ba̱mi, sa hwik ilgwe nik ngetli ɗe ta̱k pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Yek ma̱jwe na̱ma la̱t sukti wu dla̱l ka yek ba̱sa̱ man wulti ɗe ilgon na̱ ɓanti, na̱k ɗe sa̱ kum yal ga̱ɓe ama yek ba̱sa̱ yen ma̱lgon sowu. ");
INSERT INTO gyz_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Yek Shawulu tlinya. Ta̱ ɓul gwel go, ta̱ po man yenti lu so. Yek sa̱ ngiɓit ang, yek sa̱ ta̱lat ka̱ ba̱mi. ");
INSERT INTO gyz_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Yek ta̱ mul ɗe mekan ata̱ ni dwami, a ba̱ta̱ nguk ilgon so a ba̱ta̱ tla ilgon so. ");
INSERT INTO gyz_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","A ma̱n kopti gon ni ɗa a Demaskus shin gwas ka̱ɗe Hananiya. Bagaa Yesu ɓulit gwel yek ta̱ takit bi ɗe, <<Hananiya!>> Yek ta̱ nda̱ki ɗe, <<Bagaa, amik gu.>> ");
INSERT INTO gyz_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Yek Bagaami wulti ɗe, <<Li ten tantu gwe asa̱ mbe ɗe Taki wu aka̱ li lubii ɗa̱ Yehuda ka, aka̱ kum ga̱s ga̱ ma̱lgon tet Tarsus asa̱ mbet ɗe Shawulu, ka yenti ten ngemti Nya. ");
INSERT INTO gyz_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","A Shawulu mago Nya ɓuli gwel wi, yek ta̱ yen ma̱lgon gwe asa̱ mbet ɗe Hananiya wu, ta̱ zit ang ten gaa ta̱ gwel gwas ɓuli.>> ");
INSERT INTO gyz_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Yek Hananiya wule, <<Bagaa, a kum wul wonti ten ma̱llu, kangwe ata̱ pa̱li ngalci mbala̱n jwa a Wurshelima wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","A yekgu ta̱ tul ɗee na̱ nda̱lti tet mal kiɗi ma̱n Pa̱ris wi ɗe ta̱s dop mas ma̱jwe asa̱ ngusik atl wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yek Bagaami wul Hananiya ɗe, <<Lak mbiti, a botlti wi ta̱s hwi ga̱ɓa ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu tena̱nni na̱ guu jwasa̱n suk ma̱n Yisiraila pak. ");
INSERT INTO gyz_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ba mbokit ang ten kangwe ɗe ngetli ka̱n ta̱s tla bomti i'e tena̱n wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Yek Hananiya li, yek ta̱ te ka̱ lubiimi. Yek ta̱ wut ang ten gaa ga̱ Shawulu, yek ta̱ wulti ɗe, <<Yilka gini, Bagaa Yesu gwe tul malki, aka̱ na̱ma la̱t teɗɗu ka̱ shina̱nni ta̱ gwel gwa ɓul ɗa ta̱k man yenti lu, a Shishi ga̱ Nya njika̱n mbadl gwa.>> ");
INSERT INTO gyz_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ka̱li-ka̱li yek ilgon na̱k kola yil tet ka̱ gwel ga̱ Shawulu, yek gwel gwas ɓuli. Yek ta̱ tlinya, yek sa̱ pa̱lit baptisma. ");
INSERT INTO gyz_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ta̱ nguk wul wugo, yek nda̱lti gwas pali. Yek ta̱ la̱m multi mal ma̱n kopti jwe ni Demaskus wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Njet nugo yek ta̱ nde dla̱mti ga̱ɓa mbala̱n ɗa̱nka̱ lu motgaa ji ma̱n Yehuda ɗe, Yesu wo Yen ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Yek ɓanti ci mas ma̱jwe kumti wu, yek sa̱ ngusi wulti ɗe, <<Ale ma̱lga̱n ka̱ɗe ma̱n lakti ga̱ ma̱jwe nga̱ssi ten ma̱lgwisi ka̱ bomti a Wurshelima wu na̱? Ta̱ tul ɗee ta̱s dopsi ata̱ ta̱lasi ga̱ ɓali mal kiɗi ma̱n Pa̱ris!>> ");
INSERT INTO gyz_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Yek Shawulu nda̱l ten dla̱mti ga̱ɓa ga̱ Nya. Yek ta̱ gulsi ma̱n Yehuda jwe ni Demaskus wu yek ba̱sa̱ po wulti ɗe ilgon so. Na̱k ɗe ta̱ nisi ma dla̱mti ɗe, gem Yesu ka̱ɗe Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kaal ɗa̱ multi wonti, yek ma̱n Yehuda ɓel bi ta̱s tlo Shawulu, ");
INSERT INTO gyz_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ama yek ta̱ kum ilgwe sa̱ ɓel bi ɗe sa̱ pa̱lit ɗu ka. Ɗe sa̱ na̱ma ɓa̱tti dlabii ba̱mi, na̱ ka̱ cin na̱ ka̱ gasi ta̱s mbiti ta̱s tlot wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yek mil lishti jwas kanti ka ka̱ ga̱ɗa ka̱ gasi, yek sa̱ shitti a kaal ba̱mi tuka̱ shu bii. ");
INSERT INTO gyz_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tet ka̱li go yek ta̱ ap te Wurshelima ka. Yek ta̱ ngwe ɗe ta mogaa suk ma̱n kopti, ama yek ɓanti gwas cisi na̱k ɗe ba̱sa̱ kan ɗe gem ka̱n ta̱ pal ɗe ma̱n kopti wu so. ");
INSERT INTO gyz_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Yek Barnabas kanti yek ta̱ ta̱lat mal mil shinti ji botli. Yek ta̱ hwisi kangwe Shawulu yen Bagaa Yesu ten tantu wu, suk kangwe ta̱ ga̱ɓa sukti wu, suk kangwe ta̱ hwi ga̱ɓa mbala̱n ten bi ga̱ Yesu ka̱ ba̱n Demaskus na̱ nda̱li gahwula̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yek Shawulu da̱n suksi a Wurshelima. Yek ta̱ ngusi ma̱tlti ɗa̱nka, ata̱ na̱ma ga̱ɓa ten bi ga̱ Bagaa Yesu na̱ nda̱li gahwula̱n. ");
INSERT INTO gyz_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Yek ta̱ ngusi dla̱kti ga̱ɓa suk ma̱n Yehuda ma̱n ga̱ɓa na̱ bi Giris wu, yek sa̱ ngwe ɗe ta̱s tloti. ");
INSERT INTO gyz_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Yilkeni ma̱n kopti kumi nu wu, yek sa̱ ta̱lat ka̱ ba̱n Kaisariya. Yek sa̱ lakti tantu yek ta̱ li Tarsus. ");
INSERT INTO gyz_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Yek motgaa ga̱ ma̱n kopti ji Yehudiya suk ji Galili suk ji Samariya wu mas mbi ta̱mi da̱mti. Yek sa̱ nda̱l ten kopti ga̱ Yesu na̱k ɗe Shishi ga̱ Nya nda̱lli mbadl gwasa̱n wu. Yek sa̱ ngusi wonta̱ti asa̱ na̱ma da̱nti asa̱ nima ba̱lti nalti Bagaa Yesu. Biturus li ba̱n Lida suk Jopa. ");
INSERT INTO gyz_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Biturus na̱ma ma̱tlti ka̱ atl ji ma̱n Yehuda nugo yek ta̱ la yenti ga̱ mbala̱n ji Nya jwe sa̱ na̱ma da̱mti ka̱ ba̱n Lida wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ka̱li ka̱n ta̱ mbi ma̱lgwe asa̱ mbet ɗe Iniyas, ma̱lgwe ka̱t tli gon gwas tla ka̱wu. Ta̱ pa̱l gin ɗe wusupsi ata̱ ni atli, ba̱ta man la̱t so. ");
INSERT INTO gyz_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Yek Biturus wulti ɗe, <<Iniyas, Yesu Almasihu ndokki wi, tlinya ta̱k tlil lumulti gwa.>> Ninge-ninge yek ta̱ tlinya. ");
INSERT INTO gyz_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Yek mas ma̱jwe ni ka̱ ba̱n Lida suk naa ba̱n jwe ni atl ga̱ Sharon wu yenti, yek sa̱ pal ɗe ma̱n kopti ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ka̱ ba̱n Jopa njaa mal ba̱n Lida wo, ma̱n kopti gon ni ɗa shin gwas ka̱ɗe Tabita (gwe na̱ Giris wo yek ɗe Dokas wu). Ata̱ kul pa̱l wul na̱ ang gwasi ata̱ ba̱l ma̱jwe ba̱ ilgon nisi ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ka̱ multi jwisi wo, yek ta̱ pa̱l cwo, yek ta̱ ma̱shi. Yek sa̱ pol hwuuni gwas ka, yek sa̱ zi to ka̱ tlal bii ka. ");
INSERT INTO gyz_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yek ma̱n kopti kumi ɗe Biturus ni Lida. Na̱k ɗe dlo ga̱ Jopa suk Lida dlenti sowu, yek sa̱ shin mbala̱n ɗe lop ta̱s wulti ɗe ta̱s li tet malsi ba̱le-ba̱le. ");
INSERT INTO gyz_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Yek Biturus li suksi. Ta̱ mbuk lu malsi wu, yek sa̱ tolti ka̱ tlal biimi. Yek modli jwe maani jwasa̱n ma̱sh wu mas dla̱l mal Biturus, asa̱ na̱ma kulu asa̱ nitma mbokti ang ten luka̱l suk naa wul jwe Dokas pa̱lisi ɗe ta̱ yi suksi wu. ");
INSERT INTO gyz_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Yek Biturus yilla̱si deɓa̱l mas jwasa̱n, yek ta̱ ngus na̱ gahwula̱n, yek ta̱ ngem Nya. Yek ta̱ balla̱t tumal hwuunisi, yek ta̱ wule, <<Tabita, tlinya.>> Yek Tabita ɓul gwel. Ta̱ yen Biturus wu, yek ta̱ tlinya, yek ta̱ da̱m na̱ zhila. ");
INSERT INTO gyz_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Yek Biturus ngiɓit ang, yek ta̱ tlilti nya. Yek Biturus mbe mbala̱n ji Nya teɗi suk modli jwe maani jwasa̱n ma̱shi wu, yek ta̱ mbokisi ang tenti, ta̱ tli ɗa̱ka̱ ma̱shka̱n ka wi. ");
INSERT INTO gyz_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yek ili ma̱tl ka̱ ba̱n Jopa mas, yek mbala̱n wonti nga̱ssi ten Bagaa Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Yek Biturus la̱m multi a Jopa ɗa̱ ma̱lgon gwe asa̱ mbet ɗe Siman, ma̱n mokti kuul gon. ");
INSERT INTO gyz_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma̱lgon ni ɗa ka̱ ba̱n Kaisariya shin gwas wo Korneliwus. Ti wo gon ka̱ kiɗi ma̱n hapti dlo jwe asa̱ mbesi ɗe Ma̱n Italiya wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ti suk ma̱n boo gwasi mas sa̱ ɓanti Nya i'e. Ata̱ ba̱l wul ma̱jwe ba̱ ilgon nisi ɗa̱ sowu na̱ mbadl ɗe na̱m, ata̱ ngem Nya mas cin. ");
INSERT INTO gyz_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Gas gon ka̱ cin sukti yek Nya ɓulit gwel, yek ta̱ yen yen shinti ga̱ Nya gwe tul malti wu, yek ta̱ wulti ɗe, <<Korneliwus!>> ");
INSERT INTO gyz_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Yek ta̱ yenti na̱ gwel ɓanti, yek ta̱ wulti ɗe, <<Bagaa, yek ke?>> Yek yen shinti ga̱ Nyami ballit ɗe, <<Nya kum ngemti gwe ka̱ na̱ma ngemti gwas wu wi, ata̱ yen ba̱lti wul gwe ka̱ nima ba̱lti ma̱jwe ba̱ wul nisi ɗa̱ sowu wi. ");
INSERT INTO gyz_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ningo shinlu te Jopa ka ta̱s mbek Siman ma̱lgwe asa̱ mbet ɗe Biturus wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ta̱ ni ɗa̱ Siman ma̱n mokti kul lu ka, ma̱lgwe lubii gwas ni ten bi bal ze wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Yen shinti ga̱ Nyami zigaa wu, yek Korneliwus mbe ɗe lop ka̱ zhel jwasi suk ɗe na̱m ka̱ ma̱n hapti dlo jwe asa̱ pa̱lit wul wu, jwe asa̱ ngusi Nya atl wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Yek ta̱ hwisi mas ilgwe pi wu, yek ta̱ shinsi te Jopa ka. ");
INSERT INTO gyz_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lu dlo wi ɗe cin sukti ɓal go, a ma̱jwe Korneliwus shinsi ɓal njaa ta̱s mbuki ka̱ ba̱mi wu, yek Biturus to ten gaa bii ta̱s ngem Nya. ");
INSERT INTO gyz_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kuza̱n lak njel tlo Biturus, a ba̱ ilga̱ nguki gwe sa̱ na̱ma za̱ti wu ɓo no so. Yek Nya ɓulit gwel, ");
INSERT INTO gyz_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","yek ta̱ yen dlo nya ɓuli. Yek ilgon na̱k bal luka̱l yil suɗi. ");
INSERT INTO gyz_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Yek ta̱ yen wul me suk ji lubii wonti a giɓi, wul ma̱n asa̱n ɗe wupsi, suk wuci suk ɓalka̱n, suk yadli. ");
INSERT INTO gyz_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yek yal ga̱ɓa gon wulti ɗe, <<Biturus, tlinya ta̱k mboshi a ka̱ nguki.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Yek Biturus nda̱kit ɗe, <<Bagaa a pi nu so, a ɓo taɓa ngukti tlu gwe ba̱ ni hwaɓi ɗe ta̱ ma̱n Yehuda nguk wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Yek yal ga̱ɓe po wulti ɗa̱ɗe, <<Ba̱k mbe ilgwe Nya palli hwaɓi wu, ɗe byasi so.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na̱k gwisi pi asa̱mi ɗe mekan yek paa bal luka̱li pal to nya ka. ");
INSERT INTO gyz_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","A Biturus na̱ma daamti gwas ten ilgwe pi wu nugo, yek ma̱jwe Korneliwus shinsi wuk ju, sa̱ mbi boo ga̱ Siman wi. A sa̱ ɓal ten bi dlaboo. ");
INSERT INTO gyz_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yek sa̱ kum ga̱zi ɗe, ko Siman gwe asa̱ mbet ɗe Biturus wu na̱n ɗe? ");
INSERT INTO gyz_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Biturus yima daamti gwas ten ili nugo, yek Shishi ga̱ Nya wulti ɗe, <<Siman, mbala̱n ɗe mekan jon na̱ma ngot gwa. ");
INSERT INTO gyz_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tlinya ta̱k su malsi, ɓaa-ɓaa, a ka̱li suksi amik shinsi teɗi.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Biturus susut mal mbala̱mi yek ta̱ wulsi ɗe, <<Ami ka̱n ka̱ na̱ma ngot gini. Yek tulla̱kii ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yek mbala̱mi wulti ɗe, <<Bal ma̱n hapti dlo ga̱ Roma gon gwe asa̱ mbet ɗe Korneliwus wu ka̱ shinni. Zok mbala̱n ma̱n ɓanti Nya ka̱ɗe ti, ma̱lgwe a ma̱n Yehuda mas ba̱lti nalti wu. Yen shinti ga̱ Nya dla̱mit ɗe ta̱s shinik lu ta̱k li ɗatka ta̱s kum ilgwe ka dla̱m wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Yek Biturus telsi gibboo yek ta̱ ngwesi lumulti. Lu tlo wu, yek Biturus suk yilkeni ma̱n kopti jon a Jopa li suksi. ");
INSERT INTO gyz_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Lu tlo wugo yek sa̱ mbuk lu Kaisariya. A Korneliwus ɓalma ɓa̱tti gwasa̱n hal ta̱ mbe yilkeni suk yela̱n jwas tet wi. ");
INSERT INTO gyz_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Biturus te ka̱ lubiimi wu, yek Korneliwus ngusit atli yek ta̱ ba̱lti nalti. ");
INSERT INTO gyz_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Yek Biturus ngipti yek ta̱ wulti ɗe, <<Tlinya ka, am mago mbala̱n ka̱n na̱k ki.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Biturus yima ga̱ɓa sukti nugo, yek ta̱ te giɓ boomi, yek ta̱ mbi mbala̱n wonti. ");
INSERT INTO gyz_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Yek ta̱ wulsi ɗe, <<Kii na̱ gaa gwaka̱n ka̱a̱ yisi ɗe mba̱t ga̱ɓa ga̱na̱n kan ɗe ta̱ ma̱n Yehuda, pi suk ma̱lgwe ba̱ ma̱n Yehuda ka̱ sowu sogo ta̱s li ɗaasi ka̱ so. Ama Nya mboki ang ɗe ba wule a Nya nge ma̱jon a ta̱ lam ma̱jon so. ");
INSERT INTO gyz_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Yek laki ɗe sa̱ shinlu ɗe ta li tet wugo yek a tuli baa nge so. Ha̱n ta ɓo ngemki, yek laki yek ka̱ mbe ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliwus nda̱kit ɗe, <<Ndat cin ɗe wupsi ka̱ ɓal ge, ka̱ cin sukti a na̱ma ngemti Nya a ɗaaka. A ni nugo yek ma̱lgon dla̱l a cina ɗaaka luka̱l gwas wo ma̱n cilti i'e. ");
INSERT INTO gyz_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Yek ta̱ wula̱n ɗe, <Korneliwus Nya kum ngemti gwe ka̱ na̱ma ngemti gwas wu wi, ata̱ yen wul jwe aka̱ ba̱l ma̱jwe ba̱ ilgon nisi ɗa̱ sowu wi. ");
INSERT INTO gyz_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Shin lu te Jopa ka ta̱ mbek Siman gwe asa̱ mbet ɗe Biturus wu, ta̱ ni ɗe ma̱nda̱ki ɗa̱ Siman ma̱n mokti kul lu ka gwe lubii gwas ni njaa ten bi bal ze wu.> ");
INSERT INTO gyz_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yek laki yek a shinik lu ba̱le-ba̱le, yekgu mbun wi na̱k ɗe ka̱ tul wu. Ningo mik ɓallu mas jina̱n a cina ɗa̱ Nya ka, ta̱n kum ilgwe ta̱ hwik ɗe ta̱k dla̱mi nii wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Yek Biturus ndesi ga̱ɓa ɗe, <<Ningo a yisi wi ɗe gem ka̱n Nya wo ta̱ lam ma̱lgon man gon so. ");
INSERT INTO gyz_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ata̱ kan mbala̱n mas lu gwe sa̱ yil tet ka̱li wu kume sa̱ ɓantiti asa̱ pa̱l gem ka̱ da̱nti gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Yek ɗe ta̱mi ga̱ɓa ma̱n tulla̱t ta̱mi da̱mti, gwe Nya hwi ma̱n Yisiraila tumal Bagaa Yesu ga̱ mas mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ka̱ yisa̱n ilgwe pi ka̱ mas atl ga̱ ma̱n Yehuda wu gwe nde tet Galili kaal ɗa̱ ga̱ɓa ga̱ Yohana ten baptisma wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nya botl Yesu ga̱ Nazarat wu, yek ta̱ njika̱nti na̱ Shishi gwasi, yek ta̱ ba̱lti nda̱lti. Yek ta̱ ngusi ma̱tlti ɗa̱nka ata̱ nima pa̱lti hwa wul mbala̱n. Ta̱ yilli ma̱jwe sa̱ ni a ang ɗa̱ guu ma̱zhe ka̱ju na̱k ɗe Nyami ni sukti wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","<<Mi wo mik yen ilgwe Yesu pa̱li wu mas, ka̱ atl ga̱ Yehudiya suk ka̱ ba̱n ga̱ Wurshelima na̱ gwel ga̱na̱n. Bacina ji ma̱n Yehuda ɓakti ten guda̱l yencin yek sa̱ tloti. ");
INSERT INTO gyz_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Yek Nya palla̱t kaami ten multi gwas na mekan, yek ta̱ laki yek mbala̱n yenti. ");
INSERT INTO gyz_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mas mbala̱n ka̱ yen Yesu kaal ɗa̱ tlit ɗa̱ka̱ ma̱shka̱n ka gwas so, ama mi ɗe Nya botlni ta̱n yeni ama̱ dla̱m wu, mi ɗe ma̱ nguk wul yek ma̱ tla sukti wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Yek Yesu hwini ɗe ta̱n dla̱mi mbala̱n ama̱ da̱lisi ka̱ng ɗe, ti ka̱n Nya lakti ɗe ma̱lgwe a kisi ga̱ɓa ma̱jwe ma̱sh wu suk ma̱jwe yi kaami wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ma̱n dla̱mti ga̱ɓa ji Nya mas ga̱ɓa tenti ɗe mas ma̱lgwe nga̱sti ten Yesu go Nya a taasit byas wul gwas ka.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Tun a Biturus yima ga̱ɓa, yek Shishi ga̱ Nya susut ten ma̱jwe na̱ma kumti gwas wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ili ci ɓanti ma̱n Yehuda ma̱n kopti jwe tul suk Biturus wu. Ɗe sa̱ yeni wi ɗe ma̱jwe ba̱ ma̱n Yehuda ka̱ so mago sa̱ mbi Shishi ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Na̱k ɗe sa̱ kumsi ten ta̱sti ga̱ Nya, asa̱ na̱ma ga̱ɓa na̱ bi jwe ba̱ gwasa̱n ka̱ sowu. Yek Biturus wuli ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<Ma̱lgon a man ngeti ɗe ta̱ pa̱li baptisma ma̱jin na̱ ze nwa? Si mago sa̱ mbi Shishi ga̱ Nya wi na̱k gwe ma̱ mbi wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Yek Biturus laki ɗe ta̱s pa̱lisi baptisma ka̱ shin ga̱ Yesu Almasihu. Yek sa̱ ngemti ɗe ta̱s nak la̱misi multi. ");
INSERT INTO gyz_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mil shinti ji botlisi suk naa yilkeni ma̱n kopti ka̱ atl ga̱ Yehudiya kumi ɗe ma̱jwe ba̱ ma̱n Yehuda ka̱ so mago sa̱ kan ga̱ɓa ga̱ Nya ka̱ mbadl jwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Biturus li Wurshelima wu yek ma̱n Yehuda ma̱n kopti matlti. ");
INSERT INTO gyz_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Yek sa̱ wulti ɗe, <<Ka̱ li lubii ɗa̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu yek ka̱ nguk wul suksi.>> ");
INSERT INTO gyz_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Yek Biturus hwisi mas ilgwe pi wu, yek ta̱ yillisi gaa mi ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","<<A yi ka̱ ba̱n Jopa, a nima ngemti Nya yek Nyami ɓuli gwel, yek a yen ilgon na̱k bal luka̱l ga̱ ɓuli, gwe yil sut nya yek mbuki sut ka̱ lu gwe a ni wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A sul gwel ka̱ bal luka̱li go, wul me suk ga̱ lubii ma̱n asa̱n ɗe wupsi ka̱wu, suk ka̱a̱ wuci suk ka̱a̱ ɓalka̱n suk ka̱a̱ yadli a giɓi. ");
INSERT INTO gyz_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Yek a kum yal ga̱ɓa gon gwe wula̱n ɗe, <Tlinya ta̱k mboshi a ka̱ nguki.> ");
INSERT INTO gyz_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","<<Yek a ballit ɗe, <A pi nu so Bagaa a ɓo taɓa ngukti tlu jwe ba̱ mbun ɗe ta̱ ma̱n Yehuda nguk na̱k jin wu so.> ");
INSERT INTO gyz_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","<<Yek yali po ga̱ɓa ɗa̱ɗe, <Ba̱k mbe ilgwe Nya palli hwaɓi wu ɗe byasi so.> ");
INSERT INTO gyz_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na̱k gwisi pi asa̱mi ɗe mekan yek paa sa̱ kan bal luka̱li to nya ka. ");
INSERT INTO gyz_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","<<A yi ka̱li nugo yek ma̱jwe sa̱ shinsi tet Kaisariya wuk ɓal ju ten bi dlaboo ga̱ lubii gwe ani giɓi wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Yek Shishi ga̱ Nya wula̱n ɗe ta kopsi ɓaa-ɓaa, yek yilkeni ɗe mukka jin koɓa̱nni yek ma̱ te ka̱ lubii ga̱ ma̱li. ");
INSERT INTO gyz_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yek ta̱ hwini kangwe ɗe yen shinti ga̱ Nya tul malti, yek ta̱ wulti ɗe <Shin lu su Jopa ka ta̱ mbek ma̱lgwe asa̱ mbet ɗe Biturus wu toɗi. ");
INSERT INTO gyz_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ta hwik kangwe ka mbi kisti wu suk mas ma̱n lubii jwa.> ");
INSERT INTO gyz_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","<<A ndesi ga̱ɓa wi nugo yek Shishi ga̱ Nya susut tensi na̱k gwe ta̱ susut tena̱nni wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yek a daam ilgwe Yesu Bagaa dla̱m wu ɗe, <Yohana pa̱li mbala̱n baptisma na̱ ze, ama kii wo Nya a pa̱likii baptisma na̱ Shishi gwasi.> ");
INSERT INTO gyz_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Na̱k ɗe sa̱ nga̱ssi ten Almasihu Yesu Bagaa wugo, yek Nya ba̱lsi ilgwe ta̱ ba̱la̱nnii ɗe ma nga̱sa̱nni ten wu. Wok ɗe ami ta nge ilgwe Nya lami wu wo?>> ");
INSERT INTO gyz_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Sa̱ kumi nu wugo, yek ba̱sa̱ po wule ilgon so, ama yek sa̱ ta̱s Nya ɗe, <<Ma̱jwe ba̱ ma̱n Yehuda ka̱ so mago Nya pa̱lisi tantu cit atl gaa ta̱s mbi kisti pak.>> ");
INSERT INTO gyz_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yek ma̱n kopti cat ɗa̱nka na̱k ɗe mbala̱n ngesi i'e wu hal yek sa̱ dlo Istipanus. Yek ma̱n koptisi jon li dlenti hal a Pinikiya suk Kuburus suk ba̱n Antakiya. Yek ma̱n Yehuda ka̱n sa̱ ngusisi dla̱mti ga̱ɓa ga̱ Nya na̱ ngusa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ko ɗe jon jwasa̱n tet Kuburus suk tet Sayirin li Antakiya yek sa̱ dla̱mi ta̱mi ga̱ɓa ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. Sa̱ hwisi ga̱ɓa ma̱n ta̱mti ten bi ga̱ Yesu Bagaa. ");
INSERT INTO gyz_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Nda̱lti ga̱ Nya ni ka̱ ma̱n koptisi, yek laki yek mbala̱n wonti nga̱ssi ten Yesu yek mbala̱mi pal ɗe ma̱n kopti. ");
INSERT INTO gyz_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ma̱n kopti jwe asa̱ mogaa a Wurshelima kumi nu wugo, yek sa̱ shin Barnabas te Antakiya ka. ");
INSERT INTO gyz_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ta̱ mbuki Antakiya wugo, yek ta̱ yen hwa ilgwe Nya pa̱lisi wu, yek ta̱ nda̱llisi daala ta̱s kop Yesu Bagaa na̱ gem suk na̱ mbadl ɗe na̱m. ");
INSERT INTO gyz_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas wo hwa mbala̱n ka̱n gwe nga̱sti ten Yesu wu. A nda̱lti ga̱ Shishi ga̱ Nya ni gipti i'e pak. Mbala̱n wonti nga̱ssi ten Yesu, yek sa̱ pal ɗe ma̱n kopti sabona̱ wul jwe Barnabas pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Yek Barnabas sa ngot ga̱ Shawulu a Tarsus. ");
INSERT INTO gyz_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Barnabas mbit wu yek sa̱ li Antakiya sukti. Ka̱a̱ Barnabas suk Shawulu da̱m a Antakiya gin ɗe na̱m asa̱ nima hwit mbala̱n wonti ga̱ɓa ga̱ Nya. A Antakiya ka̱n sa̱ nda mbet ga̱ ma̱n kopti ɗe Kirista. ");
INSERT INTO gyz_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ka̱ multi jwisi ka̱n ma̱n dla̱mti ga̱ɓa ga̱ Nya jon sut Wurshelima su Antakiya. ");
INSERT INTO gyz_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yek gon ka̱si ma̱lgwe asa̱ mbet ɗe Agabus wu ga̱ɓa, yek ta̱ wule, <<Bal kuza̱n a tul ten mas dii atli.>> Na̱k gwisi pi ka̱ gin gwe Kaludiwus ni ɗe guu wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yek ma̱n kopti jwe ni Antakiya wu, zi ka̱ mbadl gwasa̱n ɗe sa zi-ang ma̱n kopti jwe ni Yehudiya wu, kokko na̱ kangwe ta man ba̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Yek sa̱ pa̱li nu wugo, yek sa̱ shinlu na̱ za̱t ang gwasa̱n tumal Barnabas suk Shawulu yek sa̱ ba̱l bacina ji ma̱n kopti a Yehudiya. ");
INSERT INTO gyz_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ka̱ multi jwisi ka̱n yek Hiridus guu njel nget ga̱ ma̱n kopti yek ta̱ ngusi dopti jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","yek ta̱ laki yek sa̱ dlo Yakubu yilka ga̱ Yohana na̱ bal puka. ");
INSERT INTO gyz_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ta̱ yeni ɗe na̱k gwisi ta̱mi ma̱n Yehuda ɗa̱ wu, yek ta̱ dop Biturus pak. Na̱k gwisi pi go asa̱ na̱ma motgaa ga̱ burodi gwe ba̱ yis ni giɓi sowu. ");
INSERT INTO gyz_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Hiridus dop Biturusi wugo yek ta̱ lakti ka̱ lu leti. Yek Hiridus zi ma̱n hapti dlo ɗe kutl cet mukka ta̱s ɓa̱tti, ten ɗe ta pa̱lit kisti ga̱ɓa ka̱ dlo mbala̱n kaal ɗa̱ motgaami. ");
INSERT INTO gyz_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","A Biturus ni ga̱ le ka̱ nugo, yek ma̱n kopti ngusit ngemti Nya i'e. ");
INSERT INTO gyz_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ka̱ gas gwe lu a dlo a Hiridus ta̱la Biturus ta̱s kisit ga̱ɓa wu, a Biturusi ni yemba̱l ga̱ ɓali na̱ zaa ga̱lla ɗe lop ka̱ dlo ga̱ ma̱n hapti dlo ɗe lop. A ma̱n hapti dlomi jon na̱ma ɓa̱tti bi dlabiimi mi. ");
INSERT INTO gyz_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ni nugo yek yen shinti ga̱ Nya tul mal Biturus, yek punke cil ka. Yek ta̱ ta̱n Biturus yek ta̱ pa̱da̱l. Yek ta̱ wulti ɗe, <<Tlinya, ba̱le-ba̱le!>> Yek zaa ga̱lle ɓatl-ɓatl ka yek lokit ɗa̱ ten yal ang ka. ");
INSERT INTO gyz_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Yek yen shinti wulti ɗe, <<Kin luka̱l suk kapta̱lan gwa.>> Yek Biturus kini. Yek yen shinti po wulti ɗa̱ɗe, <<Lak bal luka̱l gwa ta̱k koɓa̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Yek Biturus kopti yek sa̱ yil ɗa̱ka̱ lu letisi ka, a ba̱ Biturusi yisi ɗe ilgwe na̱ma pa̱t go gem ka̱ so. Ta̱ da̱ma̱n gwa we Nya ka̱ ɓulit gwel yek ta̱ yen ilgwe pi wu. ");
INSERT INTO gyz_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Sa̱ ɗakci ma̱n ɓa̱tti lwisi ga̱ na na̱m suk ga̱ na lop wugo, yek sa̱ li tet mal dlabii gwe sa̱ le na̱ ga̱lla wu. Yek dlabiimi ɓul na̱ ga̱ gwasi, yek sa̱ yili. Sa̱ ɓal ka̱ dlo ba̱mi go yek yen shinti ga̱ Nyami zigaa. ");
INSERT INTO gyz_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Gaa ceti Biturus wi ɗe ta̱ yisi ɗe ilgwe pi go gem ka̱wu, yek ta̱ wule, <<Ni go a yisi wi ɗe Bagaa Nya, kik shin yen shinti gwa suɗi ta̱s yilla̱n ɗa̱ka̱ byas ilgwe Hiridus pa̱li wu ka. Suk mas yokit gwe ma̱n Yehuda lami ɗe ta̱s pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Biturus yisi nu wugo yek ta̱ li lubii ɗa̱ Maryam ka̱ ana ga̱ Yohana gwe gon shin gwas ka̱ɗe Markus wu, ka̱li ka̱n mbala̱n mogaa wonti yek sa̱ ngusi ngemti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Yek Biturus ɓo bi dlabiimi. Yek zhel yen kili gon asa̱ mbet ɗe Roda yil teɗi ta̱s yen ma̱lgwe na̱ma ɓot bi dlabimi wu. ");
INSERT INTO gyz_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Yek ta̱ kumi ɗe yal ga̱ Biturus ka̱wu, yek ba̱ta̱ ɓul dlabimi so na̱ hwol tuki. Yek ta̱ pal te gibboomi ka̱ na̱ apti, yek ta̱ hwisi ɗe, <<Biturus ni ten bi dlaboo!>> ");
INSERT INTO gyz_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yek sa̱ wulti ɗe, <<Ama ka̱ ni i'e ma?>> Yek ta̱ wulsi ɗe gem ka̱n ta̱ nisi ma dla̱mti. Yek sa̱ wulti ɗe, <<Yen shinti ga̱ Nya gwe ni sukti wu ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Yek Biturus ngusi ɓot bi dlaboomi, sa̱ lak ɓul go, yek sa̱ yenti yek ɓanti cisi. ");
INSERT INTO gyz_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Yek Biturusi pa̱lisi na̱ ang ɗe ta̱s ɓo da̱m mbetlak, yek ta̱ hwisi kangwe Nya yilla̱t ɗa̱ka̱ lu letisi ka̱wu. Yek ta̱ wulsi ɗe, <<Hwi Yakubu suk naa yilkeni jina̱n ilgwe pi wu.>> Yek ta̱ tlinya yek ta̱ li zobsi lwisi gon. ");
INSERT INTO gyz_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Yek lu dlo wu yek ili gulsi ma̱n hapti dlo jwe na̱ma ɓa̱tti lwisi wu i'e, ten ɗe yek mbi Biturus ye? ");
INSERT INTO gyz_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hiridus ngo Biturus wi ɗe ba̱ta̱ mbit sowu, yek ta̱ ngem ma̱n ɓa̱tti lwisi ten ilgwe pi wu, yek ta̱ laki ɗe ta̱s tlosi ka. Kaal ɗa̱ nugo, yek Hiridus zak Yehudiya yek ta̱ li Kaisariya yek ta̱ nak la̱m multi ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ka̱ multi jwisi ka̱n ma̱n Taya suk ma̱n Sidon lili mbadl Hiridus. Yek sa̱ mo bi mas jwasa̱n yek sa̱ li tet malti, a Bilastus zok zhel ga̱ Hiridus nisi kaali. Yek Bilastus nɗa̱kisi yek sa̱li mal Hiridus. Yek sa̱ ngemi ɗe ta̱s pa̱l da̱mti ta̱mti sukti na̱k ɗe ilga̱ nguki gwasa̱n wo tet ka̱ atl ga̱ guumi ka̱n a yil tet wu. ");
INSERT INTO gyz_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Cin gwe sa̱ botli wu tul wu, yek Hiridus da̱n ten gobdlan guu ata̱ ni ka̱ luka̱l guu gwasi, yek ta̱ hwi ga̱ɓa mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sa̱ kum ga̱ɓa gwas wu, yek sa̱ tlil yal gwasa̱n nya yek sa̱ wule, <<Yal ga̱ɓa ga̱n go ga̱ mbala̱n ka̱ so, ga̱ Nya ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ka̱li-ka̱li yek yen shinti ga̱ Nya ɓoti, yek ta̱ nda atli na̱k ɗe ta̱ ba̱l nalti Nya sowu. Yek zhiba̱l nguk tli gwas ka hal yek ta̱ lak ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Yek ma̱n kopti ngusi dla̱mti ga̱ɓa ga̱ Nya mba̱tl ɗa̱nka a mbala̱n nima nga̱sti ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ɗe ka̱a̱ Barnabas suk Shawulu pak ilgwe sa̱ zisi pa̱lti a Wurshelima wu, yek sa̱ pal te Antakiya ka. Yek sa̱ kan Yohana gwe gon shin gwas wo Markus wu ang. ");
INSERT INTO gyz_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ka̱ ma̱n kopti jwe ni Antakiya jo, ma̱n dla̱mti ga̱ɓa ga̱ Nya suk ma̱n lishti ni gipsi. Ka̱a̱ Barnabas suk Siman gwe gon shin gwas ke Duni wu, suk Lukiya mbala̱n ga̱ Sayirin, suk Manayen daka ga̱ Hiridus guu, suk Shawulu wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sa̱ nima ngusti atl Nya na̱ pa̱lti ka̱lka̱ze nugo, yek Shishi ga̱ Nya wulsi ɗe, <<Yilli ninini Barnabas suk Shawulu, na̱k ɗe a botlsi ɗe ta̱s pa̱li wul wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Sa̱ pak ngemti Nya suk pa̱lti ka̱lka̱zesi wu, yek sa̱ katisi ang gaa, yek sa̱ laksi tantu. ");
INSERT INTO gyz_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas suk Shawulu ma̱jwe Shishi ga̱ Nya shinsi wu su Salukiya, tet ka̱li go yek sa̱ te ka̱ jirgi ze yek sa̱ li ten Kuburus. ");
INSERT INTO gyz_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Sa̱ te ka̱ ba̱n Salamis wu yek sa̱ dla̱m ga̱ɓa ga̱ Nya ka̱ bii motgaa. A Yohana ni suksi ata̱ nisi ma za̱t ang. ");
INSERT INTO gyz_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yek Barnabas suk Shawulu ma̱tl ɗa̱nka̱ za̱nda̱li ka hal yek sa̱ mbuki ba̱n Paposa, yek sa̱ mo suk ma̱n Yehudiya ma̱n waal gon, ma̱lgwe shel lal ɗe ti wo ma̱n dla̱mti ga̱ɓa ga̱ Nya keti wu. Shin gwas ke Bar-Yeshuwa, ");
INSERT INTO gyz_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","tik ni suk Sarjiyus Bulusu gobna wu. Gobna wo mbala̱n ma̱n yisti wul ka̱n i'e, yek ta̱ laki yek mbet Barnabas suk Shawulu na̱k ɗe ta̱ lam kumti ga̱ɓa ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yek ma̱n waal gon gwe shin gwas ni na bi ga̱ Giris ka̱ɗe Alimas wu ngwe ɗe ba̱ gobne nga̱sti ten Yesu, na̱k gwe ka̱a̱ Barnabas suk Shawulu mbok ang dani wu so. ");
INSERT INTO gyz_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Yek Shawulu ma̱lgwe asa̱ po mbet ɗe Bulus wu, ata̱ ni ga̱ njikmi na̱ Shishi ga̱ Nya wuti gwel Alimas ");
INSERT INTO gyz_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","yek ta̱ wulti ɗe, <<Ki wo yen ga̱ guu ma̱zhe ka̱n ma̱n nget mas ilgwe ni hwaɓi wu! Mbadl gwa ni ga̱ njikmi na̱ shelti lali suk mas yokiti. A gasi ka̱n ka zak balla̱t ga̱ɓa gem ten Bagaa Nya ka̱ gwi? ");
INSERT INTO gyz_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ni go Nya a nolki na̱ nda̱lti gwasi. Ka pal ɗe dwa, a ka la̱m multi ba̱ ka man yenti cilti cin so.>> Ka̱li-ka̱li yek ɓondi suk da̱mshal yitlat ka, yek ta̱ ngusi didipti lu ata̱ na̱ma ngot ma̱lgwe a ngiɓit ang wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gobne yen ilgwe pi wu, yek ta̱ nga̱sti ten Yesu na̱k ɗe ɓanti citi na̱ kangwe ta̱ kum ga̱ɓa ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Yek Bulus suk yela̱n la̱t jwas te ka̱ jirgi ze yek sa̱ li Paposa tet Perga ka̱ atl ga̱ Pampiliya. Kaali ka̱n Yohana zaksi yek ta̱ pal te Wurshelima ka. ");
INSERT INTO gyz_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Tet ba̱n Perga ka̱n sa̱ li ba̱n Antakiya ka̱ atl ga̱ Bisidiya. Gas shukti ga̱ ma̱n Yehuda ɓal go, yek sa̱ li ka̱ lu motgaa ga̱ ma̱n Yehuda, yek sa̱ da̱m na̱ zhila. ");
INSERT INTO gyz_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kaal ɗa̱ dla̱mti ga̱ɓa ka̱ mba̱t ga̱ɓa ga̱ Musa suk ma̱n dla̱mti ga̱ɓa ji Nya, yek bacina ga̱ lu motgaami shin gon gwasa̱n mal ka̱a̱ Barnabas suk Bulus ɗe, <<Yilkeni jina̱n kume ga̱ɓa gwe a nda̱lli madl mbala̱n wu nikii bi go, dla̱minii ne.>> ");
INSERT INTO gyz_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Yek Bulus tlinya yek ta̱ pa̱lisi ang ɗe ta̱s katit ka̱ng, yek ta̱ wule, <<Ma̱n Israila suk ma̱jwe ba̱ ma̱n Yisiraila ka̱ sowu, ɓo katini nini ka̱ng! ");
INSERT INTO gyz_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nya ga̱ ma̱n Yisiraila botl aba jina̱n yek ta̱ laki yek mbala̱n jina̱n wonti asa̱ yi ka̱ atl ga̱ Masar. Yek ta̱ yilla̱si tot ɗa̱ Masar ka na̱ nda̱lti gwasi ");
INSERT INTO gyz_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ko ɗe sa̱ nget kumti bi. Ama yek Nya dlo mbadl na̱ si yek sa̱ pa̱l wul jwe sa̱ lami, ka̱ gin ɗe kutl ɗe wupsi jwe sa̱ da̱m ka̱ la̱p wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Yek ta̱ tlo ma̱n Kan'ana ka. Bi gwasa̱n ɗe nitgi. Yek ta̱ ba̱l atl gwasa̱n ma̱n Yisiraila ɗe gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Na̱k gwisi pi ka̱ gin zaba̱l ɗe wupsi na̱ ɗe kutl namtan. <<Kaal ɗa̱ nu, yek Nya ngusisi ba̱lti ma̱n kisti ga̱ɓa ɗe bacina. Hal yek ta̱le multi ji Samaila ma̱n dla̱mti ga̱ɓa ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Yek mbala̱mi ngemi ɗe ta̱ Nya ba̱lsi guu, yek ta̱ ba̱lsi Shawulu yen ga̱ Kish ma̱n boo ga̱ Bilyaminu tik pa̱l guu ga̱ gin ɗe kutl ɗe wupsi. ");
INSERT INTO gyz_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nya shit Shawuli wu, yek ta̱ palli Dauda ɗe guu gwasa̱n. Yek Nya ga̱ɓa ten Dauda ɗe, <A mbi Dauda yen ga̱ Yesse wi ma̱lgwe za̱n ten mbadl gwasi a ta̱ ni ten mbadl wu, ta pa̱li ilgwe a lami wu.> ");
INSERT INTO gyz_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","<<Tumal mil boo ga̱ ma̱lga̱mi ka̱n Nya tulli ma̱n Yisiraila Yesu ma̱n kisti na̱k gwe ta̱ dla̱lli ga̱ɓa wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","A ba̱ Yesu ɓo tul sowu, Yohana dla̱mi ma̱n Yisiraila ga̱ɓa ten bi cit atl gaa suk pa̱lti baptisma. ");
INSERT INTO gyz_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ɗe Yohana pak pa̱lti ilgwe Nya zitɗu wugo, yek ta̱ wuli ɗe, <Ka̱a̱ da̱ma̱n gwa we wok ɗe ami wo? Amik ɗe Almasihu so ca. Wowo, ta̱ yi suɗi kaal ɗa̱ ami, ti ka̱n zaa kapta̱lan gwas mago a mbuki ta pa̱tl ka̱ so.> ");
INSERT INTO gyz_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<Yilkeni jini, mil ji Ibirahim suk kii ma̱n ɓanti Nya ɗe ba̱ ma̱n Yehuda ka̱ sowu, mi ka̱n tulli ni ga̱ɓa ten bi kisti. ");
INSERT INTO gyz_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yek ba̱ ma̱n Wurshelima suk guu jwasa̱n yis Yesu so yek sa̱ lilti ka. Yek sa̱ njika̱n ga̱ɓa ga̱ ma̱n dla̱mti ga̱ɓa ga̱ Nya gwe asa̱ dla̱misi mas gas shukti gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ko ɗe ba̱sa̱ mbi ilgwe a laki asa̱ ba̱l bi tlot ga̱ Yesu sowu, yek sa̱ ngem Bilatus ɗe ta̱s tloti. ");
INSERT INTO gyz_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sa̱ njika̱n mas ilgwe ma̱n dla̱mti ga̱ɓe lishi tenti wu, yek sa̱ yilla̱t sut ɗa̱ ten guda̱l yencimi ka, yek sa̱ lepti ka̱ gazukɗi. ");
INSERT INTO gyz_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ama yek Nya palla̱t kaami. ");
INSERT INTO gyz_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Yek ma̱jwe li Wurshelima sukti tet Galili wu, ngusi yenti gwasi ga̱ multi wonti. Sik nima hwiti mbala̱n ilgwe sa̱ yeni na̱ gwel gwasa̱n ɗe pi na̱ ti wu. ");
INSERT INTO gyz_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","<<Mik nikii ma dla̱mti ta̱mi ga̱ɓa gwe Nya dla̱lli suk aba jina̱n go ");
INSERT INTO gyz_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ta̱ njikmi nii wi, mi mil jwasa̱n ɗe ta̱ palli Yesu kaami wu. Na̱k gwe ni ga̱ lishi ka̱ Zabura na lop wu ɗe, << <Ki wo yen gi ka̱n, Ase go a da̱n ɗe aba gwa wi.> ");
INSERT INTO gyz_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nya palli Yesu kaami tot ka̱ gazukɗi ba̱s po ma̱sh so ɗa. Gem ka̱n Nya njika̱n ga̱ɓa gwe ta̱ dla̱m wu, ɗe ta̱ palla̱t kaami wu, gwe wule. << <Ba zikii ang na̱ gem na̱k gwe a dla̱llit ga̱ɓa Dauda ɗe ba pa̱li wu.> >> ");
INSERT INTO gyz_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ni ga̱ lishi ka̱ Zabura gon ɗa̱ɗe, << <Ka zak ma̱n cilti gwa ta̱s moki ka̱ so.> ");
INSERT INTO gyz_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","<<Dauda pak pa̱lti wul ka̱ multi jwas wugo, yek ta̱ ma̱shi. Yek sa̱ lepti mal aba jwasi, yek dli gwas moki ka. ");
INSERT INTO gyz_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ama Yesu ɗe Nya palla̱t kaami go ta̱ moki so. ");
INSERT INTO gyz_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","<<Yilkeni jini, a lami ta̱k yisi ɗe tumal Yesu wu ka̱n Nya a taas byas wul ji mbala̱n ka. ");
INSERT INTO gyz_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mas ma̱jwe nga̱ssi ten ti go sa mbi kisti, ama ba̱ mba̱t ga̱ɓa ga̱ Musa a man kisti mbala̱n so. ");
INSERT INTO gyz_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pa̱n ɗem'ɗem ba̱ ilgwe ma̱n dla̱mti ga̱ɓa Nya dla̱m wu pi tenkii so, ");
INSERT INTO gyz_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","<< <kumini kii, ɗe a ka̱a̱ jeti na̱ shin ga̱ Nya wu. Ta̱ ɓanti cikii aka̱a̱ ma̱shi na̱k ɗe ba pa̱l ilgon ka̱ multi jwaka̱n, ilgwe ba̱kaa ba̱l gem ɗe amik pa̱li sowu Ko ta̱ ma̱lgon hwikii ɗe a pa̱li wu.> >> ");
INSERT INTO gyz_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Bulus suk Barnabas ɓa yil ɗa̱ka̱ bii ngemti Nyami ka̱ go, yek mbala̱mi ngemsi ɗe ta̱s ya mba̱lisi dla̱mti ga̱ɓa ten wul jwisi ɗa, gas shukti gwasa̱n ma̱n tulti. ");
INSERT INTO gyz_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mbala̱n zigaa wu, yek ma̱n Yehuda suk ma̱jwe te ka̱ kopti Nya ga̱ ma̱n Yehuda na̱ nda̱li mbadl wu kop Bulus suk Barnabas. Yek ka̱a̱ Bulus suk Barnabasi nda̱llisi gahwula̱n ɗe ta̱s ci cina na̱ za̱t mbadl gwasa̱n ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ga̱s shukti po balla̱t tet wugo, yek mas ma̱n ba̱mi mogaa ta̱s kum ga̱ɓa ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Yek ma̱n Yehuda yeni ɗe mbala̱n wonti mogaa wu, yek sa̱ daka̱l i'e, yek sa̱ ngusi nget ilgwe Bulus na̱ma dla̱mti wu. Yek sa̱ ngusi byalti gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Yek Bulus suk Barnabas ga̱ɓa ba̱na̱ ɓanti so yek sa̱ wule, <<Mbun ɗe ta̱kii ma̱n Yehuda ka̱a̱ kum ga̱ɓa ga̱ Nya cina. Ama na̱k ɗe ka̱a̱ nge wu, ka̱a̱ mbok ang wi ɗe ka̱a̱ mbuki ta̱k mbi mbadl gwe ba̱ a paki sowu so. Mi wo mali mal ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Go yek ɗe ilgwe Nya zini wu, << <A lakkii wi ɗe cilti ga̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. Ta̱k tulla̱n kisti ka̱ dii atli mas.> >> ");
INSERT INTO gyz_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu kumi nu wugo, yek sa̱ pa̱l hwol tuki i'e, yek sa̱ dla̱m ɗe ga̱ɓa ga̱ Nya zok ga̱ɓa ka̱n. Yek ma̱jwe Nya botlsi ɗe sa mbi mbadl gwe ba̱ a paki sowu ka̱si nga̱ssi ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Yek ga̱ɓa ga̱ Nya ngusi lakti ang ɗa̱nka̱ ba̱mi ka mas. ");
INSERT INTO gyz_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ama yek ma̱n Yehuda cok modli jon jwe ɓanti Nya ma̱jwe ɗe a mbala̱n nalla̱si wu, suk kiɗi maani ji ba̱mi. Yek sa̱ tlil nget ga̱ Bulus suk Barnabas, yek sa̱ mbolsi ɗa̱ka̱ ba̱n gwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Yek sa̱ bat kushka ga̱ ba̱mi ɗa̱ ten asa̱n gwasa̱n ka, ta̱ da̱n ɗe ilgwe a daami ma̱n ba̱mi wu, yek sa̱ li Ikoniya. ");
INSERT INTO gyz_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Yek ma̱n kopti jwe ni ka̱li wu njika̱n na̱ hwol tuki suk Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Yek Bulus suk Barnabas li ka̱ lu motgaa ka̱ ba̱n Ikoniya na̱k gwe asa̱ kul pa̱li wu. Yek sa̱ dla̱mi ga̱ɓa ga̱ Nya mbala̱n, yek ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu nga̱ssi ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ama yek ma̱n Yehude jwe nge nga̱ssi ten Yesu wu cok ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, yek sa̱ lil dlo gwasa̱n suk ma̱n koptisi ka. ");
INSERT INTO gyz_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Mas na̱ nu yek Bulus suk Barnabas la̱m multi ka̱li asa̱ na̱ma dla̱mti ga̱ɓa ga̱ Nya, a Nya mbok ang ɗe ilgwe sa̱ dla̱m go gem ka̱n, na̱k ɗe ta̱ laki yek sa̱ pa̱l wul cit ɓanti wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yek ma̱n ba̱mi tatl ɗe lop, jon pi kaal ma̱n Yehude, a jon wo yek sa̱ pi kaal mil shinti. ");
INSERT INTO gyz_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yek ma̱jwe ba̱ ma̱n Yehuda ka̱ soju, suk ma̱n Yehude mas na̱ bacina jwasa̱n ngwe ta̱s ɓosi asa̱ laksi na̱ ye. ");
INSERT INTO gyz_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Yek mil shinti kumi ka, yek sa̱ aɓ te ka̱ ba̱n ji Likoniya ka. Jwe a mbe ɗe Listera suk Dabe wu, suk lujwe ni njaa ka̱li ju. ");
INSERT INTO gyz_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yek sa̱ ngusi dla̱mti ta̱mi ga̱ɓa ten Yesu ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kulki gon ni ɗa na̱ zhila gwe ɗe ta̱ man la̱t na̱ asa̱n sowu ka̱ ba̱n Listera. ");
INSERT INTO gyz_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ta̱ katti ka̱n ga̱ɓa gwe Bulus na̱ma dla̱mti wu. Yek Bulus wutit gwel, ta̱ yeni ɗe ma̱li ba̱l gem ɗe ta ndokti wu, ");
INSERT INTO gyz_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","yek Bulus tlil yal nya yek ta̱ wulti ɗe, <<Tlinya ta̱k dla̱l na̱ asa̱n gwa!>> Yek ta̱ yil nya yek ta̱ njel la̱t na̱ asa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mbala̱n jwe mogaa wu yen ilgwe Bulus pa̱li wu, yek sa̱ tlil yal gwasa̱n mas jwasa̱n yek sa̱ wuli na̱ bi gwasa̱n ɗe, <<Nya pal na̱k mbala̱n yek ta̱ susut mala̱nni wi.>> ");
INSERT INTO gyz_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Yek sa̱ zi shin Barnabas ɗe Zewus, Bulus wo yek sa̱ mbet ɗe Hames na̱k ɗe tik ɗe ma̱n ga̱ɓa wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Yek guu waal ga̱ Zewus gwe bii waal gwas ni te kaal ba̱n ka̱wu ta̱la tla suk buzha te ten bal dlabii ba̱mi ka. Na̱ ti na̱ ma̱n ba̱mi lami ɗe ta̱s ba̱l gal ka̱ shin ga̱ Bulus suk Barnabas. ");
INSERT INTO gyz_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bulus suk Barnabas mil shintisi kumi nu wugo, yek sa̱ pa̱l duu tuki, yek sa̱ kesh luka̱l jwasa̱n ka, yek sa̱ li te ka̱ lu gwe mbala̱mi mogaa wu ka ba̱le ba̱le asa̱ na̱ma wulti ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<Yek laki ɗe ka̱a̱ na̱ma pa̱lti nu ye? Mi mago mbala̱n ka̱n na̱k kii sole. Ga̱ɓa ma̱n ta̱mti ka̱n ma̱ tulli kii ta̱k zaka̱n iljwe ka̱a̱ nisi ma ngusti atl ɗe ba̱ mbadl nisi ɗa̱ sowu. Ta̱k pala̱n tet mal Nya gwe ma̱sh sowu, a tik pa̱l dlo nya, suk dii atli, suk bal ze suk mas wul jwe ni giɓi wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ka̱ gin jwe nda na̱ kaal lu go Nya zak mbala̱n ta̱s pa̱l ilgwe sa̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Mas na̱ nu, ta̱ ɓo taɓa zakti ga̱ mbala̱n ba̱na̱ ilgwe a laki asa̱ daamti sowu so. Tik nikii ɗe ma̱n ba̱lti ze sut nya suk mbuni watla̱n, ata̱ kul ba̱lkii ilga̱ nguki kangwe a kum kii wu, ata̱ laki aka̱a̱ da̱n na̱ hwol tuki.>> ");
INSERT INTO gyz_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mas na̱ ga̱ɓa jimi ɗe sa̱ hwisi wu, yek sa̱ ngo kanti gwasa̱n gaa. Ten ɗe si wo sa ba̱l gal ka̱ shin gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ama yek ma̱n Yehuda jwe yil tet Antakiya suk Ikoniya ju mani na̱ mbala̱mi. Yek sa̱ lak mbala̱mi ten lakti ga̱ Bulus na̱ ye, yek sa̱ dla̱kti te kaal ba̱n ka sa̱ da̱m gwa gwe ta̱ ma̱sh wi. ");
INSERT INTO gyz_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Yek ma̱n kopti lak ganda̱lti wu yek ta̱ tlinya, yek ta̱ pal te ka̱ ba̱n ka. Lu dlo wugo yek ta̱ zigaa te Dabe ka suk Barnabas. ");
INSERT INTO gyz_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Bulus suk Barnabas dla̱m ta̱mi ga̱ɓa ka̱ ba̱mi gwisi yek mbala̱n wonti nga̱ssi ten Yesu, yek sa̱ pal te ka̱ ba̱n Listera ka suk Ikoniya, suk Antakiya, ");
INSERT INTO gyz_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","yek sa̱ ngusi nda̱lla̱t mbadl ma̱n kopti, yek sa̱ nda̱llisi daala ɗe ta̱s dla̱l ten nga̱sti ten Yesu. Yek sa̱ wulsi ɗe, <<Ngetli ka̱n ta̱n tla bomti i'e, apaa ma̱ te ka̱ Nya ɗe guu.>> ");
INSERT INTO gyz_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yek Bulus suk Barnabas botlisi ma̱jwe a da̱misi ɗe bacina ka̱ lu motgaa ngemti Nya jwasa̱n wu. Yek sa̱ pa̱l ka̱lka̱ze, yek sa̱ ngemisi Nya gwe sa̱ zi mbadl tenti ɗe, ta zisi ang wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Sa̱ koɓi ka̱ atl ga̱ Bisidiya wu, yek sa̱ mbuki Pampiliya. ");
INSERT INTO gyz_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Sa̱ dla̱m ga̱ɓa ga̱ Nya a Perga wu, yek sa̱ su Ataliya. ");
INSERT INTO gyz_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tet Ataliya go yek sa̱ te ka̱ jirgi ze, yek sa̱ pal Antakiya. Ka̱lu gwe ngemisi Nya ten wul ga̱ Nya gwe sa̱ pak pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Sa̱ mbuk lu wu, yek sa̱ mo ma̱n kopti, yek sa̱ hwisi mas ilgwe Nya pa̱li tumalsi wu. Suk kangwe Nya ɓuli gwel ma̱jwe ba̱ ma̱n Yehuda ka̱ soju yek sa̱ nga̱ssi ten Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Yek sa̱ mul wonti suk ma̱n kopti ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yek ma̱n Yehuda ma̱n kopti jon tet Yehudiya tul Antakiya, yek sa̱ ngusi hwiti ma̱n kopti ɗe, <<Kume sa̱ sa̱lkii na̱k gwe mba̱t ga̱ɓa ga̱ Musa dla̱m wu sogo ka mbi kisti so.>> ");
INSERT INTO gyz_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Bulus suk Barnabas dla̱k ga̱ɓa suk ma̱jwisi i'e. Yek ma̱n kopti botlsi suk ma̱n kopti jon ta̱s to Wurshelima ta̱s mbi bacina suk mil shinti ji botli jwe ni ka̱li wu ta̱s ga̱ɓa suksi ten ga̱ɓa gwisi. ");
INSERT INTO gyz_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Yek ma̱n koptisi laksi tantu sut Wurshelima yek sa̱ koɓi tu Pinikiya suk Samariya. Yek sa̱ hwi ma̱n kopti jwe ni ka̱ lu jwisi kangwe ma̱jwe ba̱ ma̱n Yehuda ka̱ soju nga̱ssi ten Yesu wu. Kumti na̱k gwisi lak ma̱n koptisi ten pa̱lti hwol tuk i'e. ");
INSERT INTO gyz_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Sa̱ ɓal Wurshelima go, yek mil shinti ji botli suk ma̱n kopti suk bacina jwasa̱n pa̱lisi ɗem na̱ palti. Yek Bulus suk Barnabas hwisi ilgwe Nya zisi ang yek sa̱ pa̱li ka̱ ma̱jwe ba̱ ma̱n Yehuda ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Yek ma̱n kopti jon jwe ma̱n Paresi ka̱ɗe si wu tlinya yek sa̱ wule, <<Ngetli ka̱n ta̱ sa̱l ma̱n kopti jwe ba̱ ma̱n Yehuda ka̱ soju, asa̱ kop mba̱t ga̱ɓa ga̱ Musa.>> ");
INSERT INTO gyz_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Yek mil shinti ji botli suk bacina ji ma̱n jwasa̱n mogaa ta̱s kus ga̱ɓa gwisi. ");
INSERT INTO gyz_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sa̱ kusi i'e wu, yek Biturus tlinya yek ta̱ wulsi ɗe, <<Yilkeni jini, ka̱a̱ yisi ɗe ka̱ multi jon duk go Nya botla̱nni ta̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ soju kum ga̱ɓa ma̱n ta̱mti ta̱s nga̱sti ten Yesu tumala̱nni. ");
INSERT INTO gyz_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Na̱k ɗe Nya wo ma̱n yisti mbadl ga̱ mbala̱n ka̱wu, yek ta̱ mbok ang ɗe ta̱ kansi wi ɗe ta̱ ba̱lsi Shishi gwasi na̱k gwe ta̱ ba̱la̱nni wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Yek ta̱ pol mbadl jwasa̱n ka tumal nga̱sti gwe sa̱ pa̱li wu, na̱k gwisi mbok ang ɗe Nya hul dlo ga̱na̱n suksi so. ");
INSERT INTO gyz_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ke nuk go yek laki ɗe ka̱a̱ na̱ma lamti ta̱k zi pa̱lti ilgwe mana̱n ngetl ga̱na̱n, mi suk aba jina̱n wu ma̱n kopti jin ye? ");
INSERT INTO gyz_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Na̱k gwe ma̱ ba̱la̱n gem ɗe tumal alheri ga̱ Bagaa Yesu ka̱n ma̱ mbi kisti wu, nu ka̱n si mago sa̱ nga̱ssi ten Yesu.>> ");
INSERT INTO gyz_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Yek mas mbala̱mi da̱m mbetlak asa̱ na̱ma daamti gwasa̱n ɗe Biturus ga̱ɓa wu. Yek sa̱ ngusi katti ka̱ng Barnabas suk Bulus ɗe sa dla̱mti wul cit ɓanti jwe Nya pa̱li ka̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ so tumalsi wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Barnabas suk Bulus pakisi dla̱mti ga̱ɓa wugo yek Yakubu wule, <<Yilkeni jini, katini nini ka̱ng. ");
INSERT INTO gyz_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Siman hwini kangwe Nya tul mal ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu yek ta̱ palli jon ɗe mbala̱n jwasi. ");
INSERT INTO gyz_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Nu ka̱n ga̱ɓa ga̱ ma̱n dla̱mti ga̱ɓa Nya dla̱mi, gwe ni ga̱ lishi ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<< <Kaal ɗa̱ gwisi wo ba pal suɗi, a palli boo guu ga̱ Dauda gwe nda ka̱wu ɗe guu ɗa, ba kin lu guumi ɗa, a palli gus boo guumi liisi. ");
INSERT INTO gyz_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ta̱ naa mbala̱n ngo Nya ɗa, mas suk ma̱jwe ba̱ ma̱n Yehuda ka̱ so ɗe asa̱ mbe shin gi wu, ami Nya, amik dla̱m nu> ");
INSERT INTO gyz_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nu ka̱n a dla̱lli ga̱ɓa ka̱ tlal multi jon teka. ");
INSERT INTO gyz_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","<<Ga̱ɓa gi wo yek ɗe, ba̱n laka̱n ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu jwe pal tet mal Nya wu ka̱ bomti so. ");
INSERT INTO gyz_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ɗa̱ nugo, ta̱n lishisi ɗe ba̱s nguk ilgwe sa̱ taki gunki wu so. A ba̱s pi pa̱la̱n so, a ba̱s nguk hwu wul suk hwulan so. ");
INSERT INTO gyz_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","A dla̱m nu na̱k ɗe ten mba̱t ga̱ɓa ga̱ Musa ka̱n a ma̱n Yehuda ngusi dla̱mti ga̱ɓa ɗa̱nka̱ lu motgaa jwasa̱n ka, mas gas shukti gwasa̱n ka̱ gin jon ka.>> ");
INSERT INTO gyz_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Yek mil shinti ji botli, suk bacina ji ma̱n kopti suk naa ma̱n koptisi mas botl ma̱jon tet gipsi. Yek sa̱ shinsi te Antakiya ka suk Bulus suk Barnabas. Ma̱jwe sa̱ botlsi go sik ɗe, ka̱ Silas suk Yehuda gwe asa̱ mbet ɗe Barsabas wu. Silas suk Barsabas wo bacina ji ma̱n koptisi ka̱ɗe si. ");
INSERT INTO gyz_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yek sa̱ ba̱lsi lishti gwe wule: Mi, mil shinti ji botli, suk bacina ji ma̱n kopti, yilkeni jwaka̱n. Kii ma̱n kopti ɗe ba̱ ma̱n Yehuda ka̱ so jwe ni a Antakiya suk Siriya suk Silisiya wu. Ma̱ na̱ma ga̱ɓet gwaka̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ma̱ kumi ɗe jon jina̱n li malkii ba̱na̱ yisti ga̱na̱n so, yek sa̱ gulsi mbadl gwaka̱n na̱ ilgwe sa̱ hwikii wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Yek ma̱ mo bi ga̱na̱n ɗe ta̱n botl yela̱n jina̱n jon, ama̱ moosi suk Bulus suk Barnabas ta̱n shinsi mal malkii ");
INSERT INTO gyz_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ma̱jwe ba̱l gaa gwasa̱n ten pa̱lti wul ga̱ Almasihu Yesu Bagaa wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nuk laki yek ma̱ na̱ma shinti ga̱ Silas suk Yehuda, ta̱s hwikii ilgwe ma̱ ballikii wu na̱ bi gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ta̱mi Shishi ga̱ Nya ɗa ɗe ba̱n zikii bal ilgon gaa so, ɗe ba̱ jin ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ba̱k nguka̱n ilgwe asa̱ ba̱li ka̱ lu waal wu so, ba̱k nguka̱n hwulan so, ba̱k nguka̱n tlu ga̱ hwuu wul so. Ba̱k pa̱n pa̱la̱n so. Mbun ɗe ta̱k zaka̱n mas wul jwisi. Se gasi gon jwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Yek sa̱ shin ma̱jwisi yek sa̱ li Antakiya, yek sa̱ mo mas ma̱n kopti yek sa̱ ba̱lsi lishti gwisi. ");
INSERT INTO gyz_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Sa̱ yen lishtisi wugo yek sa̱ pa̱l hwol tuki, na̱k ɗe ga̱ɓa gwe ni giɓi wu nda̱llisi gahwula̱n ten nga̱sti ten Yesu gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yehuda suk Silas hwi ma̱n koptisi ga̱ɓa nda̱lla̱t gahwula̱n suk ba̱lti nda̱lti i'e, na̱k ɗe si wo ma̱n dla̱mti ga̱ɓa ga̱ Nya ka̱ɗe si wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Sa̱ nak la̱m multi ka̱li wu, yek ma̱n koptisi pallisi bi na̱ ga̱ɓa ta̱mi mbadli, yek sa̱ pal ga̱za̱n mal ma̱jwe shinsi wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Yek Bulus suk Barnabas sa a Antakiya, yek sa̱ mboki ang mbala̱n wonti ten ga̱ɓa ga̱ Nya ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","La̱m multi wu, yek Bulus hwi Barnabas ɗe, <<Ma̱ pal teka ta̱n kus ba̱n jwe ma̱ dla̱m ga̱ɓa ga̱ Nya ka̱li ju, ta̱n ɓo yen kangwe sa̱ ɓal na̱ nga̱sti ten Yesu wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Yek Barnabas lami ɗe ta̱s kan Yohana gwe asa̱ mbet ɗe Markus wu ta̱s li suksi. ");
INSERT INTO gyz_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Yek ba̱ ta̱mi Bulus ɗa̱ so na̱k ɗe Markusi zaksi ɗe sa̱ li Pampiliya ba̱ta̱ ci cina na̱ dla̱mti ga̱ɓa ga̱ Nya suksi sowu. ");
INSERT INTO gyz_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Yek sa̱ njel dla̱kti ga̱ɓa ka̱ dlo gwasa̱n yek sa̱ hwuli. Yek Barnabas kan Markus yek te ka̱ jirgi ze yek sa̱ li te Kuburus ka. ");
INSERT INTO gyz_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bulus wo yek ta̱ botl Silas yek sa̱ zigaa, ɗe ma̱n kopti ngemisi Nya ɗe ta̱s zisi ang wu. ");
INSERT INTO gyz_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Yek ta̱ li ba̱n Siriya suk Silisiya yek ta̱ nda̱llisi gahwula̱n. ");
INSERT INTO gyz_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Yek Bulus tul a Dabe, tet ka̱li go yek ta̱ li Listera, ka̱ lu gwe ma̱n kopti gon gwe asa̱ mbet ɗe Timoti ni na̱ da̱nti wu. Ana gwas ga̱ Timoti wo nga Yehuda ma̱n kopti wu, a aba gwas wo ma̱n Giris. ");
INSERT INTO gyz_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A ma̱n kopti jwe ni Ikoniya suk Listera dla̱m hwa ga̱ɓa tenti. ");
INSERT INTO gyz_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulus lami ɗe ta̱s mo asa̱n suksi ten la̱t gwasa̱n, yek ta̱ sa̱lti na̱k ɗe ma̱n Yehuda jwe ni ka̱li wu mas yisi ɗe aba gwas wo ma̱n Giris ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Yek sa̱ ngusi ma̱tlti ɗa̱nka̱ ba̱n jwe ni ka̱li ju ka, asa̱ nisi ma hwit ilgwe bacina ji ma̱n kopti suk mil shinti ji botli a Wurshelima dla̱lli ɗe ta̱ ma̱n kopti koɓi wu. ");
INSERT INTO gyz_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Yek ma̱n koptisi mbi nda̱lti ten nga̱sti ten Nya gwasa̱n, asa̱ na̱ma wonta̱t tli mas cin. ");
INSERT INTO gyz_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Yek Bulus suk yela̱n la̱t jwas li ɗa̱nka̱ ba̱n jwe ni ka̱ atl ga̱ Pirijiya suk Galatiya ju. Ama yek ba̱ta̱ dla̱m ga̱ɓa ga̱ Nya a Asiya so na̱k ɗe Shishi ga̱ Nya zaksi ɗe ta̱s dla̱m ka̱li sowu. ");
INSERT INTO gyz_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Yek sa̱ li tet ten mba̱t ga̱ atl ga̱ Misiya wu, yek sa̱ ngwe ɗe ta̱s te Betiniya ama yek ba̱ Shishi ga̱ Nya zaksi so. ");
INSERT INTO gyz_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Yek sa̱ koɓi a njaa mal atl ga̱ Misiya, ɗe sa su Turawas wu. ");
INSERT INTO gyz_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Gas ɓal go, yek Nya ɓuli gwel Bulus, yek ta̱ yen ma̱n Makedoniya gon, ma̱li dla̱l nya ata̱ na̱ma ngemti gwasi ɗe, <<To tot Makedoniya ta̱k zisi ang ne.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nya ɓuli gwel Bulus wu yek ma̱ yisi ɗe ta̱ mbe ni ta̱n dla̱m ta̱mi ga̱ɓa ten Yesu ka̱li, yek ma̱ to Makedoniye ba̱le-ba̱le. ");
INSERT INTO gyz_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tet Turawas go yek ma̱ te ka̱ jirgi ze, yek ma̱ li Samotiras. Lu dlo wugo yek ma̱ li Niyopolis. ");
INSERT INTO gyz_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tet ka̱li go, yek ma̱ li Pilibi bal ba̱n ga̱ Makedoniya ka̱ atl ga̱ Roma. Yek ma̱ la̱m multi ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Gas shukti ga̱ ma̱n Yehuda ɓal wu, yek ma̱ yil te kaal dlabii ba̱mi ka yek ma̱ su tu dla̱lka, lu gwe ma̱ zi ɗe ma mbi lu ngemti Nya wu. Ka̱li ka̱n ma̱ da̱mi yek ma̱ hwi ga̱ɓa modli jwe mogaa ka̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gon ka̱ modlisi ɗe kaatini ka̱ng go shin gwas ka̱ɗe Lidiya, ma̱n wulti tutul ka ka̱ɗe ti tet ka̱ ba̱n Tayatira, ata̱ ngusi Nya atli. ta̱ kum ga̱ɓa gwe Bulus na̱ma dla̱mti wu yek Nya ta̱n mbadl gwasi yek ta̱ nga̱sti ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yek sa̱ pa̱li baptisma Lidiya suk ma̱n lubii jwas jwe nga̱ssi ten Yesu wu. Yek Lidiya wul ni ɗe ta̱n li lubii ɗatka. Ta dla̱m ɗe, <<Ka̱a̱ yisi ɗe a nga̱ssa̱n ten Bagaa Yesu wu, ningo lak da̱ma̱n a daaka.>> Yek ta̱ mani na̱ mi. ");
INSERT INTO gyz_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Gas gon ama̱ na̱ma la̱t ka̱ lu ngemti Nya, yek ma̱ moo suk zhel yen kili gon ma̱n ma̱zhe gwe a ma̱zhe lakti ata̱ man dla̱mti ilgwe a pi wu. Ata̱ mwe bal wulpi bagaa gwasi ten pa̱lti na̱k gwisi. ");
INSERT INTO gyz_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yek yen kilisi ngusi kopti ga̱ Bulus suk naa yilkeni jina̱n ata̱ na̱ma dla̱mti to nya ka̱ɗe, <<Ma̱jin jo zhel ji Nya Bal Kakshe ka̱n, sa̱ tuli dla̱mti ga̱ɓa ten kangwe kaa mbi kisti wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ta̱ ngusi pa̱lti nu multi wonti. Yek mbadl ga̱ Bulus lak lil wu, yek ta̱ balla̱ti, yek wul ma̱zhe ɗe, <<Ka̱ shin ga̱ Almasihu Yesu, a na̱ma wulti gwa ɗe ta̱k yil ɗa̱ka̱ ti ka!>> Yek ma̱zhesi zakti ka̱li-ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Bagaa ji yen kilisi yeni ɗe sa po mbi wulpi sowu, yek sa̱ dop Bulus suk Silas yek sa̱ ta̱lasi ka̱ lu motgaa mal ma̱n kisti ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Yek sa̱ tulla̱si dlaboo kisti ga̱ɓa yek sa̱ wuli ɗe, <<Ma̱jin jo sa̱ nima gulsa̱t ga̱ ma̱n ba̱n gee i'e. A ma̱n Yehuda ka̱n, ");
INSERT INTO gyz_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","sa̱ na̱ma wulti ɗe ta̱n pa̱la̱n wul jwe mbun ɗe ta̱n mi ma̱n Roma pa̱li sowu.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Yek mas mbala̱n tlinya ka ten Bulus suk Silas, yek sa̱ nget ɓot gwasa̱n. Yek ma̱n dlaboo kisti ga̱ɓe dla̱lli ga̱ɓa ɗe, ta̱ tusisi luka̱l ka a ɓosi na̱ tlemndi. ");
INSERT INTO gyz_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Sa̱ ɓosi i'e wu, yek sa̱ lesi ka ka̱ lu leti. Yek sa̱ wul ma̱n ɓa̱tti lwisi ɗe ta̱s zi gwel tensi i'e. ");
INSERT INTO gyz_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Yek sa̱ hwit nu wu, yek ta̱ telsi su ka̱ punka leti gwe ni te ka̱ bii letisi ka̱wu, yek ta̱ ɓalisi asa̱n ka ka̱ dlo ji guda̱l yencin ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ka̱ dlo gas ɓallu ɗe Bulus suk Silas na̱ma ngemti Nya asa̱ na̱ma wulti koo ta̱sti ga̱ Nya, a ma̱jwe ɗe lesi pak ju na̱ma kumti gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sa̱ yi nugo, yek atl wuni na̱ nda̱lti, hal yek zhila bii gwe sa̱ lesi giɓi wu wuni. Na̱ma pa̱t nu yek mas bi dlabii lu letisi ɓul ka, yek zaa ga̱lla jwe sa̱ ɓalisi ang ɗa̱ju ɓatl ka. ");
INSERT INTO gyz_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ma̱n ɓa̱tti lwisi pa̱da̱l wi ɗe ta̱ yen dlabiimi ga̱ ɓuli ka̱wu, yek ta̱ yilli bal puka gwasi ta̱s tlo gaa gwas ka. Ta̱ da̱m gwa we ma̱jwe lesi ka̱ju aɓ wi. ");
INSERT INTO gyz_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Yek Bulus wulti to nya ka̱ɗe, <<Ba̱k kumi cwo gaa gwa so, ma̱ ni ɗa mas jina̱n!>> ");
INSERT INTO gyz_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Yek ma̱n ɓa̱tti lwisi kum ga̱s ga̱ cilti wutu, yek ta̱ te ka̱ biimi ka na̱ apti, yek ta̱ lak nda a cina ɗa̱ Bulus suk Silas ka a tli gwas na̱ma da̱dalti. ");
INSERT INTO gyz_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Yek ta̱ yilla̱si tet deɓa̱l, yek ta̱ ngemsi ɗe, <<Bacina jini, yek ba̱ pa̱li ta mbi kisti ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yek sa̱ ballit ɗe, <<Nga̱ski ten Bagaa Yesu apaa ka mbi kisti, ki suk mas ma̱n lubii jwa.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Yek sa̱ hwit ta̱mi ga̱ɓa ten Yesu, suk mas ma̱n lubii gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ka̱ gas gwisi ka̱n ta̱ kan Bulus suk Silas yek ta̱ polisi usu jwasa̱n ka. Yek Bulus suk Silas pa̱lisi baptisma ka̱li-ka̱li, na̱ ti na̱ ma̱n lubii gwasi mas. ");
INSERT INTO gyz_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ta̱ ngusi pa̱lti hwol tuki na̱k ɗe ta̱ nga̱sti ten Nya wi suk mas ma̱n lubii gwas wu. Yek ta̱ ta̱la ka̱a̱ Bulus suk Silas lubii ɗatka, yek ta̱ ba̱lsi ilga̱ nguki. ");
INSERT INTO gyz_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Lu tlo wugo yek ma̱n kisti ga̱ɓe shin ma̱n hapti dlo mal ma̱n ɓa̱tti lu letisi ɗe, <<Zak ma̱ ju ta̱s zigaa.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Yek ma̱n ɓa̱tti lwisi wul Bulus ɗe, <<Ma̱n kisti ga̱ɓa ba̱l bi ɗe ta̱ zak ki suk Silas wi. Ningo za̱ngaa na̱ ta̱mi mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Yek Bulus wul ma̱n hapti dlomi ɗe, <<Mi wo ma̱n atl ga̱ ma̱n Roma ka̱n, ama yek sa̱ ɓoni ka̱ dlo mbala̱n a ba̱sa̱ kisini ga̱ɓa paa so. Yek ningo sa̱ ɓa lam zakti ga̱na̱n mukli a? a pi nu so, ta̱s sak pa̱tlni na̱ gaa gwasa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Yek ma̱n hapti dlomi tok hwi ma̱n kisti ga̱ɓe, sa̱ kumi wi ɗe Bulus suk Silas wo ma̱n Roma ka̱wu yek ɓanti cisi. ");
INSERT INTO gyz_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Yek sa̱ li tet ka̱ lu letisi, yek sa̱ ba̱lsi bii, yek sa̱ yilla̱si ɗa̱ka̱ bii letisi ka. Yek sa̱ ngemsi ɗe ta̱s zak ba̱mi. ");
INSERT INTO gyz_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bulus suk Silas yil ɗa̱ka̱ lu letisi ka̱wu, yek sa̱ li lubii ɗa̱ Lidiya ka. Ka̱li ka̱n sa̱ mbi ma̱n kopti, yek sa̱ nda̱llisi daala, yek paa sa̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Sa̱ koɓi tu Ampibolis suk Apoloniya wu, yek sa̱ li Tasalonika ka̱ lu gwe lu motgaa ni ka̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Yek Bulus ngusi tet ka̱ bii ngemti Nyami ata̱ nisi ma ga̱ɓa tet ka̱ ga̱ɓa ga̱ Nya, mas gas shukti gwasa̱n ɗe mekan na̱k gwe ata̱ kul pa̱li ka̱ mas lu jwe ta̱ li ju. ");
INSERT INTO gyz_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ta̱ mbokisi ang ɗe Almasihu wo ngetli ka̱n ta̱s tla bomti ata̱ ma̱shi, apaa ta̱ tli ɗa̱ka̱ ma̱shka̱n ka tot ɗa̱ka̱ ma̱jwe ma̱sh wu ka. Yek ta̱ wulsi ɗe, <<Yesu ga̱n ɗe a nikii ma ga̱ɓa tenti go tik ɗe Almasihu.>> ");
INSERT INTO gyz_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yek ma̱n Yehuda jon nga̱ssi ten Yesu yek sa̱ mogaa suk Bulus suk Silas. Ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu jwe ɓanti Nya wu nga̱ssi ten Yesu yek sa̱ mogaa suksi pak, suk kiɗi modli ji ba̱mi wonti. ");
INSERT INTO gyz_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yek ma̱n Yehuda jon daka̱l, yek sa̱ mbe mil yeta̱l tet ka̱ lu motgaa wulti wuli yek sa̱ tlil dlanti ka̱ ba̱mi. Yek sa̱ li lubii ɗa̱ Jason ten ngot ga̱ Bulus suk Silas ta̱s tolsi ka̱ dlo mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Yek ba̱sa̱ mbi Bulus suk Silas sowu, yek sa̱ dop Jason suk ma̱n kopti jon, yek sa̱ ta̱lasi cina ɗa̱ kiɗi ji ba̱mi ka, yek sa̱ wul kiɗi ji ba̱mi ɗe, <<Ma̱jin ɗe sa̱ na̱ma gulsa̱t ga̱ mbala̱n ten dii atl mas go sik ɓallu a ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","a Jason ka̱ kansi ɗe ma̱nda̱ki a lubii ɗatka. Mas jwasa̱n sa̱ na̱ma ɗakcit mba̱t ga̱ ga̱ɓa Kaisar asa̱ na̱ma wulti ɗe guu gon ni ɗa asa̱ mbet ɗe Yesu.>> ");
INSERT INTO gyz_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kiɗi ji ba̱mi suk mbala̱n jwasa̱n kumi nu wugo, yek ili gulsa̱si mas. ");
INSERT INTO gyz_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yek sak lak Jason suk naa ma̱n koptisi ta̱s ɓatl wulpi zakti gwasa̱n, yek paa sa̱ zaksi. ");
INSERT INTO gyz_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Gas gil wu, yek ma̱n kopti lak Bulus suk Silas tantu la̱t Beriya. Sa̱ mbuki li wu yek sa̱ li ka̱ lu motgaa. ");
INSERT INTO gyz_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ma̱n Beriya wo sa̱ lami ɗe ta̱s kati kan ga̱ɓa ga̱ Nya man ma̱n Tasalonika. Na̱k ɗe sa̱ kan ga̱ɓe gwe Bulus hwisi wu na̱ hwol tuki, yek sa̱ ngusi bodla̱lti ta̱s yisi ɗe ko ilgwe ta̱ hwisi go gem ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Yek ma̱n Yehuda wonti suk kiɗi maani suk modli jwe ba̱ ma̱n Yehuda ka̱ sowu wonti nga̱ssi ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Yek ma̱n Yehuda jwe ni Tasalonika wu kumi ɗe Bulus na̱ma hwit mbala̱n ga̱ɓa ten Yesu a Beriya wu, yek sa̱ ka̱li yek sa̱ sak gulsi ma̱n ba̱mi yek sa̱ coksi. ");
INSERT INTO gyz_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Yek ma̱n kopti lak Bulus te ten bicikɗi ka ba̱le-ba̱le. Ama Silas suk Timoti wo yek sa̱ sa a Beriya. ");
INSERT INTO gyz_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ma̱jwe lak Bulus tantu wu tulla̱t a Atina wu ɓa pal ga̱za̱n go yek Bulus shinsi ɗe ta̱s wul Silas suk Timoti ɗe ta̱s kopti teɗi ba̱le-ba̱le. ");
INSERT INTO gyz_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Bulus na̱ma ɓa̱tti gwasa̱n a Atina nu wu yek ta̱ yen gunki wonti, jwe a ma̱n ba̱mi ngusisi atl wu, yek mbadl lilit i'e. ");
INSERT INTO gyz_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yek Bulus suk ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, jwe ɓanti Nya wu ngusi bodla̱lti ga̱ɓa ga̱ Nya ka̱ lu motgaa ga̱ ma̱n Yehude. Yek Bulusi hwi ga̱ɓa mas ma̱jwe motgaa ka̱ lu wulti wul ka̱wu ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yek motgaa ga̱ ma̱n lishti jon, jwe asa̱ mbesi ɗe ma̱n Abikuriya suk Sitokiya ju ngusi dla̱kti ga̱ɓa suk Bulus. Yek jon jwasa̱n kum ga̱zi ɗe, <<Yek ma̱n shila̱n ga̱n a dla̱m kam ye?>> Yek jon po wule, <<Gon ata̱ na̱ma ga̱ɓa ten gunki jwe ba̱ma̱ yisa̱nsi sowu.>> Ilgwe laki yek sa̱ dla̱m nugo yek ɗe, sa̱ kum Bulus ten ga̱ɓa ten Yesu suk tlit ɗa̱ka̱ ma̱shka̱n ka kaal ɗa̱ ma̱shka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Yek sa̱ ta̱la Bulus dlaboo da̱mti gwe asa̱ mbe ɗe, <<Arepagus wu.>> Yek sa̱ wulti ɗe, <<Ɓo hwini pyal ilga̱n ɗe ka̱ nima mbokti ang mbala̱n dani wu. ");
INSERT INTO gyz_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ka̱ ni nima mokti ang ten pyal wul, ma̱ na̱ma lamti ta̱n yis gaami.>> ");
INSERT INTO gyz_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Mas ma̱n Atina suk ma̱nda̱ki jwe ni a ɗee go, ten katti ka̱ng suk ga̱ɓa ten pyal wul ka̱n asa̱ sa.) ");
INSERT INTO gyz_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Yek Bulus tlinya ka̱ dlo ga̱ ma̱n da̱mti Arepagusi yek ta̱ wul kiɗi ji ba̱mi ɗe, <<Ma̱n Atina, a yeni go ka̱ mas pa̱t jwaka̱n kii wo ma̱n ngot Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ɗe a ma̱tl ka̱ ba̱n go yek a ngusi yenti wul jwe aka̱a̱ ngusisi atl wu, yek a yen bagadi gwe ka̱a̱ lishi dani ɗe, <Ga̱n go bagadi ga̱ ilgwe a mbala̱n ngusit atl ɗe ba̱ma yisa̱nti sowu.> Nya gwe aka̱a̱ ngusit atli ama ba̱ka̱a̱ yisti sowu, ha̱nta mbokikii ang tenti. ");
INSERT INTO gyz_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","<<Nya gwe pa̱l dii atl suk mas wul jwe ni dani wu, tik ɗe Bagaa ga̱ dii atli suk boo nya, ti wo ba̱ta da̱n ka̱ bii gwe a mbala̱n kin wu so. ");
INSERT INTO gyz_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","A ba̱ mbala̱n a mani pa̱lti Nya ilgwe ta̱ lami wu so, na̱k ɗe ti gaa gwas wo tik pa̱l mbala̱n suk wul ma̱n mbadl mas wu. ");
INSERT INTO gyz_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Tumal mbala̱n ɗe na̱m ka̱n ta̱ pa̱l mas mbala̱n jwe ni ten dii atl wu, ten ɗe ta̱ dii atli da̱n ɗe gwasa̱n. A tik lak kangwe da̱nti gwasa̱n suk lu gwe sa da̱m wu a ni wu. ");
INSERT INTO gyz_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ta̱ pa̱li nu ta̱ mas mbala̱n ngo lu gwas i'e asa̱ lamti ka̱ mbadl jwasa̱n ta̱s mbit ɗa, ko ɗe Nya dlenti suk mas jina̱n sowu. ");
INSERT INTO gyz_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","<na̱k ɗe tumalti ka̱n mas da̱mti suk pa̱lti wul jina̱n ni.> Na̱k gwe ma̱n manti bi jwaka̱n dla̱m wu ɗe, <Mi wo mil jwas ka̱n.> ");
INSERT INTO gyz_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","<<Na̱k ɗe mi wo mil ji Nya ka̱wu, ba̱n za̱n ɗe Nya wo na̱k zinariya sogo azurpa sogo na̱k ye gwe mbala̱n pa̱li ka̱ so, ba̱n da̱ma̱n ɗe ti wo ilgwe mbala̱n pa̱li na̱ ang gwasa̱n wu ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ka̱ multi tek jo, wunda̱l ji ka̱dla̱n jwisi hwot Nya so. Ama ningo yek ta̱ na̱ma wulti mbala̱n mas ɗe ta̱s ci atl gaa, mas lu jwe sa̱ ni wu. ");
INSERT INTO gyz_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","A hwikii nu, na̱k ɗe Nya zi cin gwe ta kisi ga̱ɓa mas mbala̱n na̱ gem tumal ma̱lgwe ta̱ botlti wu. Nya mboki ang mbala̱n ten na̱k gwisi ɗe ta̱ palli ma̱lgwe ta botltisi kaami wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Sa̱ kum bi tlit ɗa̱ka̱ ma̱shka̱n ka ga̱ mbala̱n wugo yek jon des njwaa, ama jon wo yek sa̱ wule, <<Ma̱ ya lam kumti gwa ten bi ilga̱mi ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ten nu ka̱n yek Bulus yil ɗa̱ka̱ motgaami ka. ");
INSERT INTO gyz_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yek maani jon ka̱li cugaa suk Bulus yek sa̱ nga̱ssi ten Yesu. Ma̱jwe cugaa sukti jo sik ɗe, ka̱a̱ Deyonisus ma̱n da̱mti motgaa Arepaguus, suk kili gon gwe asa̱ mbet ɗe Damaris, suk naa mbala̱mi jon ɗa jwe nga̱ssi ten Yesu pak ju. ");
INSERT INTO gyz_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kaal ɗa̱ nugo yek Bulus zak Atina yek li Korinti. ");
INSERT INTO gyz_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ka̱li ka̱n ta̱ mo suk ma̱n Yehuda gon ɗe asa̱ mbet Akila ma̱n Pontus. Ma̱lgwe ya yil tet Italiya suk kili gwasi gwe asa̱ mbet ɗe Pirisila wu, na̱k ɗe Kaludiwus guu ga̱ Roma laki ta̱ mas ma̱n Yehuda zak atl ga̱ Roma wu. Yek Bulus la yenti gwasa̱n, ");
INSERT INTO gyz_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na̱k ɗe Bulus mago ma̱n mokti kul ka̱n na̱ksi wu, yek ta̱ da̱m suksi yek ta̱ ngusi mokti kul suksi. ");
INSERT INTO gyz_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Yek Bulus ngusi ga̱ɓa suk ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu kangwe sa yis gaami wu, ta̱s dla̱ksi tet mal Yesu Almasihu ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas suk Timoti tul tet Makedoniya wu, yek Bulus dla̱l gal ten dla̱mti ga̱ɓa ma̱n ta̱mti. Ta̱ hwi ma̱n Yehudasi ɗe Yesu ka̱ɗe Almasihu. ");
INSERT INTO gyz_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Yek ma̱n Yehuda nge kumti gwasi yek sa̱ dla̱m byas ga̱ɓa tenti, yek Bulus batisi kushka ga̱ luka̱l gwasi yek ta̱ wule, <<Ta̱ hwulan gwaka̱n dla̱l ten gaa jwaka̱n, ze gi po yi giɓi so. Ningo ba li mal ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu.>> ");
INSERT INTO gyz_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Yek Bulus zak lu motgaami yek ta̱ li lubii ɗa̱ Titus Justus ka. Ma̱lgwe ba̱ ma̱n Yehuda ka̱ sowu, gwe ɗe ata̱ ngusi atl Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Yek Kiribus bacina ga̱ lu motgaami suk mas ma̱n lubii jwas nga̱ssi ten Yesu Bagaa. Ma̱n Korinti wonti jwe kum Bulus wu mago sa̱ ba̱l gem yek sa̱ pa̱lisi baptisma. ");
INSERT INTO gyz_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ga̱s gon ka̱ gasi, yek Yesu Bagaa ɓuli gwel Bulus, yek ta̱ wulti ɗe, <<Ba̱ ɓanti cik so, ngusi dla̱mti ga̱ɓa ma̱n ta̱mti, ba̱k da̱m mbetlak so. ");
INSERT INTO gyz_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","A ni sukki, ma̱lgon a man tulti ata̱ kumit cwo so, mbala̱n wonti ka̱ ba̱n ga̱n a da̱m ɗe mbala̱n jini.>> ");
INSERT INTO gyz_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Yek Bulus da̱m ka̱li ga̱ gin ɗe na̱m na̱ tatlti dlo, ata̱ nisi ma mbokti ang ten ga̱ɓa ma̱n ta̱mti ten Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","A Galiyo ni ɗe gobna ga̱ Akaya, yek ma̱n Yehuda ɓel bi yek sa̱ tulli Bulus ka̱ lu kisti ga̱ɓa. ");
INSERT INTO gyz_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Yek sa̱ ga̱ɓa tenti ɗe, <<Ma̱lga̱n nima shelti mbala̱n ɗe ta̱s ngusi atl Nya kangwe ba̱ mba̱t ga̱ɓa wule ta̱ pa̱li sowu.>> ");
INSERT INTO gyz_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bulus ɓa nda ga̱ɓa wu, yek Galiyo wul ma̱n Yehuda ɗe, <<Kaa na̱ma nala̱nti ten ilgwe ba̱ yek sowu, sogo byas wul wu, ani zoki ta kati kii ka̱ng. ");
INSERT INTO gyz_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ama na̱k ɗe kumti ga̱z wul ka̱n ten bi wul gwaka̱n suk mba̱t ga̱ɓa gwaka̱n go, la̱ka̱ma̱n ili na̱ gaa gwaka̱n. Ba pa̱l kisti ga̱ɓa ten wunda̱l ga̱ ga̱ɓa wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yek ta̱ yilla̱si ɗa̱ka̱ lu kisti ga̱ɓe ka. ");
INSERT INTO gyz_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yek sa̱ pal ten Sostenus bacina ga̱ lu motgaami, yek sa̱ ɓoti ten bii dlaboo lu kisti ga̱ɓe ka. Ama yek ba̱ hwot Galiyo so. ");
INSERT INTO gyz_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus la̱m da̱nti a Korinti wu, yek ta̱ zak ma̱n kopti jwe ni ka̱li wu, yek ta̱ li Siriya suk Pirisila suk Akila ka̱ jirgi ze. Ta̱ wutl gaa ka a Senkiriya, na̱k gwe ta̱ dla̱lli ga̱ɓa ɗe ta pa̱li wu yek paa ta̱ nda za̱tgaa. ");
INSERT INTO gyz_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Sa̱ mbuki a Apisa wu, yek Bulus zak Pirisila suk Akila ka̱li. Ti gaa gwas wo yek ta̱ li ka̱ lu motgaa ga̱ ma̱n Yehuda yek sa̱ bodla̱l ga̱ɓa suk ma̱n Yehude. ");
INSERT INTO gyz_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Sa̱ ngemti ɗe ta̱s ya da̱m suksi ɗa̱, yek Bulus nge. ");
INSERT INTO gyz_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bulusi ɓa zigaa go yek ta̱ dla̱llisi ga̱ɓa yek ta̱ wule, <<Ba ya pali, kume Nya lami wu.>> Yek ta̱ te ka̱ jirgi ze yek ta̱ zak ba̱n Apisa. ");
INSERT INTO gyz_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ta̱ mbuk lu Kaisariya wu, yek ta̱ sak ga̱ɓe ma̱n kopti ji ka̱li, yek paa ta̱ li Antakiya. ");
INSERT INTO gyz_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bulus la̱m multi ka̱ ba̱n ga̱ Antakiya wu, yek ta̱ ngusi ma̱tlti ɗa̱nka̱ lu ji Galatiya suk Pirijiya ka. A ta̱ nima nda̱lla̱t gahwula̱n ma̱n kopti mas. ");
INSERT INTO gyz_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yek ma̱n Yehuda gon asa̱ mbet ɗe Apolos, ma̱n Alekzandiriya tul a Apisa. Ma̱n yisti wul ka̱ɗe ti, ata̱ yis ga̱ɓa ga̱ Nya i'e. ");
INSERT INTO gyz_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ma̱n kopti jon hwi Apolos ten kangwe mbala̱n a kop Bagaa wu, yek ta̱ dloti ten mbokti ang mbala̱n ten kangwe sa kop Yesu wu ko ɗe baptisma ga̱ Yohana ka̱n ta̱ yisi tokte wu. ");
INSERT INTO gyz_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Yek Apolos njel ga̱ɓa ka̱ lu motgaa, ka̱a̱ Akila suk Pirisila kumti wu. Yek sa̱ mbet tet lubii ɗaasi ka, yek sa̱ yilit gaami i'e kangwe kopti Nya ni wu. ");
INSERT INTO gyz_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos ɓa li Akaya go yek ma̱n kopti nda̱llit daala, yek sa̱ pa̱lit lishti gwe ta ba̱l ma̱n kopti jwe ni Akaya wu ta̱s kan ma̱nda̱ki gwas ɗa. Ta̱ mbuk lu wu, yek ta̱ zi-ang ma̱jwe nga̱ssi ten Yesu i'e tumal alheri ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Na̱k ɗe ta̱ man ngetl ga̱ ma̱n Yehuda jwe dla̱k ga̱ɓa sukti ka̱ dlo mbala̱n wu, yek ta̱ mbokisi ang ka̱ ga̱ɓa ga̱ Nya ɗe Yesu ka̱ɗe Almasihu. ");
INSERT INTO gyz_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ɗe Apolos yi Korinti go, yek Bulus kop tantu gwe koɓi Korintisi yek ta̱ mbuki Apisa. Yek ta̱ lak mbi ma̱n kopti jon ka̱li ");
INSERT INTO gyz_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","yek ta̱ ngemsi ɗe, <<Ka̱a̱ mbi Shishi ga̱ Nya ma, ɗe ka̱ nga̱skii ten Yesu wu?>> Yek sa̱ wulti ɗe, <<Hwowo, ma̱ yisi ɗe Shishi ga̱ Nya ni ɗa̱ so so pamma.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Yek Bulus po ngemsi ɗa̱ɗe, <<Yek wunda̱l ga̱ baptisma gwik sa̱ pa̱likii gwi?>> Yek sa̱ ballit ɗe, <<Wunda̱l baptisma ga̱ Yohana wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Yek Bulus wule, <<Baptisma ga̱ Yohana go, ga̱ cit atl gaa ka̱n. Ta̱ hwi mbala̱n ɗe ta̱s nga̱ssi ten Yesu ma̱lgwe a tul kaal ɗaat ɗu.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Sa̱ kumi nu wugo yek sa̱ pa̱lisi baptisma, na̱ shin ga̱ Yesu Bagaa. ");
INSERT INTO gyz_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bulus wutisi ang gaa wu, yek Shishi ga̱ Nya susut tensi, yek sa̱ ga̱ɓa na̱ zobsi bi, yek sa̱ dla̱m ga̱ɓa jwe Nya hwisi ɗe ta̱s dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wonta̱t jwasa̱n mbala̱n ɗe cutl cet lop. ");
INSERT INTO gyz_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulus pa̱l lip ɗe mekan ata̱ na̱ma la̱t ka̱ lu motgaa ga̱ ma̱n Yehuda ata̱ ngusisi dla̱mti ga̱ɓa ga̱ Nya na̱ mbadl ɗe na̱m. Ta̱ ngusi dla̱kti gwasa̱n ten bi ga̱ Nya ɗe guu. ");
INSERT INTO gyz_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Yek jon jwasa̱n ka̱nga̱l ka, yek sa̱ nge nga̱sti ten Yesu, yek sa̱ ngusi dla̱mti byas ga̱ɓa ten bi kopti Tantu ga̱ Yesu te ka̱ mbala̱n ka. Yek Bulus zaksi, yek ta̱ yem ma̱n kopti yek sa̱ ngusi ga̱ɓa mas cin ka̱ bal bii motgaa ga̱ Tiranus. ");
INSERT INTO gyz_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Na̱k gwisi ngusi pa̱ti hal gin ɗe lop yek mas ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, jwe na̱ma da̱mti ka̱ atl ga̱ Asiya wu kum ga̱ɓa ga̱ Bagaa Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Nya pa̱l kiɗi wul cit ɓanti tumal Bulus, ");
INSERT INTO gyz_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","kangwe wul taasti lwani gwasi suk luka̱l gwas ma wu, asa̱ ta̱le ma̱n cwo suk ma̱n ma̱zhe. Asa̱ ndoki a ma̱zhesi yil ɗa̱ka̱si ka. ");
INSERT INTO gyz_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yek ma̱n Yehuda jon jwe asa̱ ma̱tl ɗa̱nka asa̱ yilli ma̱zhe ɗa̱ka̱ mbala̱n ka̱wu, lami ɗe ta̱s ndok ma̱jwe ma̱zhesi ni ka̱si wu na̱ shin ga̱ Bagaa Yesu. Asa̱ wul ma̱zhesi ɗe, <<Na̱ shin ga̱ Yesu gwe a Bulus ga̱ɓa tenti wu, a nikma wulti ɗe ta̱k yilka.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Mil ɗe nitgi ji bal ma̱n Pa̱ris gon asa̱ mbet ɗe Siba wu ngusi pa̱lti na̱k gwisi. ");
INSERT INTO gyz_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Gasi gon wo yek ma̱zhesi ballisi ɗe, <<Yesu co a yisa̱nti, a Bulus mago a yisti, yek ki wo wok ɗe ki wo?>> ");
INSERT INTO gyz_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Yek ma̱lgwe ma̱zhesi ni ka̱ti wu ndesi yek ta̱ man ngetl gwasa̱n. Ta̱ pa̱lisi byas ɓoti yek luka̱l gwasa̱n kesh ka, se na̱k sa̱ yil tot ɗa̱ka̱ lubiimi ka na̱ apti koo dlisi na̱ hwulan ɗa̱n ten dli gwasa̱n ka̱. ");
INSERT INTO gyz_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu jwe nima da̱mti Apisa wu kumi nu wu, yek ɓanti cisi i'e, yek shin ga̱ Yesu Bagaa mbi nalti i'e. ");
INSERT INTO gyz_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Yek ma̱jwe nga̱ssi ten Yesu wu wonti ngusi dla̱mti byas wul jwe sa̱ pa̱li wu ka̱ dlo mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Yek ma̱n pa̱lti waal wonti, tulli kul lishti jwe asa̱ pa̱l waal ɗa̱ ju yek sa̱ kweli ka ka̱ dlo mbala̱n. Wulpi gwe asa̱ wul kul lishtisi ɗa̱ go, a pa̱l 50,000 ga̱ zinariya. ");
INSERT INTO gyz_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Na̱ nu ka̱n ga̱ɓa ga̱ Bagaa Yesu mba̱tl ɗa̱nka̱ mbala̱n ka yek nda̱l i'e. ");
INSERT INTO gyz_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kaal ɗa̱ na̱k gwisi, yek Bulus zi ka̱ mbadl gwas ɗe ta li Wurshelima, ata koɓi tu Makedoniya suk Akaya. Yek ta̱ wule, <<Ngelti ka̱n ta li Roma pak.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Yek ta̱ lak Timoti suk Irastus ma̱jwe asa̱ zit ang wu ta̱s li Makedoniya, ti gaa gwas wo yek ta̱ya la̱m da̱mti a Asiya ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ka̱ multi jwisi ka̱n bi kopti Tantu ga̱ Yesu gulsa̱l mbala̱n i'e. ");
INSERT INTO gyz_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ma̱n desti azurpa gon gwe asa̱ mbet ɗe Demitiriyas, ma̱lgwe ata̱ des azurpa ata̱ palli ɗe lu za̱t na̱k'en gunki gwe asa̱ mbe ɗe Aritimis wu. A ma̱n desti wul mbi wulpi i'e ten pa̱lti wunda̱l ji wul jwisi. ");
INSERT INTO gyz_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Yek Demitiriyas mbe ma̱n desti azurpe ka̱ lu ɗe na̱m suk ma̱jwe asa̱ pa̱l wunda̱l ga̱ wul jwisi ju. Yek ta̱ wulsi ɗe, <<Yela̱n jini, ka̱a̱ yisi ɗe ma̱ na̱nma mbit wulpi nal ten desti azurpa gee. ");
INSERT INTO gyz_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kik ka kumi wu aka̱a̱ na̱ma yenti kangwe ma̱lga̱n ɗe asa̱ mbet Bulus wu na̱ma shelti ga̱ mbala̱n wonti ta̱s gilla̱si a ɗe a Apisa suk mas atl ga̱ Asiya wu. Ta̱ na̱ma dla̱mi ɗe gunki jwe mbala̱n pa̱li go Nya ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ilgwe ma̱ na̱ma pa̱lti wu ka̱n mbala̱n a nge tokte so. Ama lu gwe a zi gunki ma̱n nalti Aritimis wu suk gunkisi gaa gwasi, ti ɗe a mbala̱n ngusit atli ka̱ atl ga̱ Asiya suk mas dii atl wu mago ta po yi ten bi ilgon so.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Sa̱ kumi nu wugo yek mbadl lilisi, yek sa̱ njel ga̱ɓa to nya ka̱ɗe, <<Gunki Aritimis ga̱ ma̱n Apisa go ma̱n nalti ka̱n!>> ");
INSERT INTO gyz_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Njet nugo yek mas ba̱mi hwot ka, yek mbala̱mi dop Gayus suk Aristakus yela̱n la̱t ji Bulus tet Makedoniya, yek sa̱ ta̱lasi ka̱ lu motgaa gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulus lami ɗe ta̱s li mal mbala̱mi, ama yek ba̱ ma̱n kopti zakti so. ");
INSERT INTO gyz_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yek bacina jon ka̱ ba̱mi jwe ɗe yela̱n ji Bulusi ju mago sa̱ shinit lu ɗe, ba̱s te ka̱ lu motgaami so. ");
INSERT INTO gyz_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Yek motgaami gulsi ka, jon na̱ma ga̱ɓa ten ilga̱n a jon na̱ma ga̱ɓa ten zobsi ilgon. A ba̱ mbala̱mi wonti gipsi yis ilgwe tulla̱si ka̱li wu so pamma. ");
INSERT INTO gyz_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yek ma̱n Yehuda jwe ni ka̱ mbala̱mi wu jek Alekzanda tet cina, yek sa̱ wulti ɗe ta̱s dla̱m ilgwe na̱ma pa̱t ɗu. Yek ta̱ pa̱lisi na̱ ang ɗe ta̱s ɓo da̱m mbetlak yek ta̱s yilli gaa gwas ka̱ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Yek mbala̱mi yeni ɗe ma̱n Yehuda ka̱ɗe ti wugo, yek sa̱ tlil yal nya ndakce yek sa̱ ngusi wulti ɗe, <<Gunki Aritimis ga̱ ma̱n Apisa go ma̱n nalti ka̱n!>> Yek sa̱ pita dla̱mti na̱k gwisisi. ");
INSERT INTO gyz_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Yek bali gon ga̱ ba̱mi laki yek sa̱ da̱m mbetlak, yek ta̱ wulsi ɗe, <<Ma̱n Apisa, mas mbala̱n ten dii atl yisi ɗe ba̱n Apisa ka̱ɗe ma̱n ngipti ga̱ lu gwe asa̱ ngusi atl gunki Aritimis ma̱n nalti gwe ɗe nda sut nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Na̱k ɗe ga̱ hwuda̱li ka̱n ni sowu, da̱ma̱n mbetlak, ba̱k pa̱la̱n ilgon ka̱ lilti mbadl so. ");
INSERT INTO gyz_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ka̱ tulli ma̱jin a ɗe, muka̱l ka̱n sa̱ pi tet ka̱ lu da̱nti ga̱ gunkisi so a ba̱sa̱ dla̱m byas ilgon ten gunki ga̱na̱n so. ");
INSERT INTO gyz_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Kume ga̱ɓa ni Demitiriyas suk ma̱jwas ɗa̱ ten ma̱lgon go ma̱n kisti ga̱ɓa ni ɗa, sik ka lak ma̱jwe pa̱l ilgwe ba̱ yek sowu ta̱s ɓatlti. ");
INSERT INTO gyz_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","A kume ilgon yi kaal go, suli ka̱ lu motgaa ga̱ ba̱n. ");
INSERT INTO gyz_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ningo ma̱ pa̱la̱n ilgwe ba̱ mbun sowu wi na̱k ɗe ma̱ tlila̱n dlanti ase wu. Aba̱ ilgwe laki yek ma̱ tlila̱n dlantisi wu ni ɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ta̱ dla̱m nu wugo, yek ta̱ wul mas mbala̱mi ɗe ta̱s zigaa. ");
INSERT INTO gyz_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Dlantisi paki wugo yek Bulus mbe ma̱n koptisi yek ta̱ nda̱llisi gahwula̱n, yek ta̱ pallisi bi, yek ta̱ li Makedoniya. ");
INSERT INTO gyz_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ta̱ ngusi ma̱tlti ka̱ lu jwisi ata̱ nisi ma nda̱lla̱t gahwula̱n ma̱n kopti, yek ta̱ lak mbuk atl ga̱ ma̱n Giris, ");
INSERT INTO gyz_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ka̱li ka̱n ta̱ pa̱l lip ɗe mekan, yek ta̱ lami ɗe ta̱s te ka̱ jirgi ta̱s li Siriya ama yek ta̱ kume ɗe ma̱n Yehuda jon na̱ma ngoti ta̱s tloti, yek ta̱ koɓi tu Makedoniya. ");
INSERT INTO gyz_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yek Sobata yen ga̱ Parus ma̱n Beriya, suk Aristakus suk Sakundus ma̱n Tasalonika, suk Gayus tet Darbe, suk Timoti, suk Tikikus suk Turopimus ma̱n ba̱n Asiya kopti. ");
INSERT INTO gyz_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ma̱jwisi ndenii cina yek sa̱ sak ɓa̱tni a Turawas. ");
INSERT INTO gyz_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Yek ma̱ te ka̱ jirgi ze tet Pilibi kaal ɗa̱ motgaa ngukti burodi gwe ba̱ yis ni dani sowu. Yek ma̱ lak mbisi a Turawas kaal ɗa̱ multi ɗe namtan ten tantu. Yek ma̱ pa̱l multi ɗe mukka ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Gas shukti ga̱ ka̱ sukti, ma̱ mogaa ɗe ta̱n nguk wul ndakce wu, yek Bulus ngusi hwit ga̱ɓa mbala̱n, se na̱k lu dlo. Na̱k ɗe ta̱ na̱ma lamti za̱tgaa ɗe lu dlo wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pitilla ni ka̱ soɓa̱l tlal bii gwe ma̱ mogaa giɓi wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Yek yen maani gon gwe asa̱ mbet ɗe Iyutikus wu da̱n ka̱ shu windo. Yek yeba̱l njel dopti ga̱ gwasi hal yek kanti. Bulus na̱ma ga̱ɓa nugo yek ta̱ dlunti ka̱ yeba̱li. Yek ta̱ nda sut atli sut ka̱ soɓa̱l tlal biimi ga̱ na mekan yek sa̱ kanti go ta̱ ma̱sh wi. ");
INSERT INTO gyz_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Yek Bulus yil suɗi, yek ta̱ ngus mal yeni, Yek ta̱ wut ang sut tenti. Yek ta̱ wul mbala̱mi ɗe, <<Ba̱ ili gulsa̱lkii so, ta̱ yi kaami!>> ");
INSERT INTO gyz_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Yek ta̱ pal to ka̱ soɓa̱l dla̱l biimi ka yek sa̱ nguk wul yek sa̱ tla jibi. Ta̱ ngusisi dla̱mti ga̱ɓa se na̱k lu dlo wu, yek paa ta̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Yek mbala̱mi kan Iyutikusi na̱ gasi, yek sa̱ ta̱lat lubii ata̱ ɓal kaami, yek mbadl ta̱misi i'e. ");
INSERT INTO gyz_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Yek ma̱ te ka̱ jirgi ze, yek ma̱ li Asos ta̱n mbi Bulus ka̱li na̱k gwe ma̱ dla̱m sukti na̱k ɗe ten asa̱n ka̱n ta̱ li wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ma̱ mo sukti a Asos wu, yek ma̱ kanti ka̱ jirgi ze yek ma̱ li Metilin. ");
INSERT INTO gyz_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Lu dlo wu yek ma̱ ɗakci za̱nda̱l ga̱ ba̱n Kiyos. lu po dlo ɗa̱ wugo, yek ma̱ mbuk lu ten za̱nda̱l Samos, yek lwisi gon po dlo ɗa̱ wu yek ma̱ te ba̱n Melitus. ");
INSERT INTO gyz_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulus lami ɗe ta̱s koɓi tu Apisa so, ba̱s da̱m ka̱ ka̱t atl ga̱ Asiya so ɗa na̱k ɗe ta̱ lami ɗe ta̱s te Wurshelima ten cin motgaa ɗakciti kume na̱k gwisi pi wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Tet Melitusi go, yek Bulus shini lu bacina ji ma̱n kopti jwe ni Apisa wu ɗe ta̱s tuli. ");
INSERT INTO gyz_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Sa̱ tul wu, yek ta̱ wulsi ɗe, <<Ka̱a̱ yis kangwe a da̱m wu, ɗe a yi sukkii wu, tet ten cin gwe a tul ka̱ ka̱t atl ga̱ Asiya wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","A pa̱l wul ɗe zhel ga̱ Nya na̱ lwu ka̱ gwel gini, a ba̱ a palli gaa gi ɗe ilgon so, ko ɗe ma̱n Yehuda lami ɗe ta̱s tela̱n ka̱ bomti wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ka̱a̱ yisi ɗe a hwuda̱likii ilgon so, mas wul jwe mbun ɗe ta̱k yisi go a hwikii. A hwikii ga̱ɓa ka̱ lu motgaa jwaka̱n yek a po koɓi ɗa̱n boo jwaka̱n yek a hwikii. ");
INSERT INTO gyz_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","A hwi ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ɗe ngetli ka̱n ta̱s bala̱si tet mal Nya ta̱s cit atl gaa malti, a ta̱s nga̱ssi ten Yesu na̱ Bagaa ga̱na̱n Yesu. ");
INSERT INTO gyz_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","<<Ningo Shishi ga̱ Nya zi ɗe ta li Wurshelima, aba yis ilgwe a pi na̱ ami tek wu so. ");
INSERT INTO gyz_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ilgwe a yisi go yek ɗe, mas ba̱n gwe a li wu, a Shishi ga̱ Nya hwi ɗe, mbala̱n a laki a te ka̱ bomti, asa̱ laka̱n ka̱ lu gwe a sa le ma̱jwe pa̱l ilgwe ba̱ yek sowu. ");
INSERT INTO gyz_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Mas na̱ nu, mbadl gi ni ten bi ilgon a mala̱n so, kume a man pakti pa̱lti ilgwe Bagaa Yesu zi wu, gwe yek ɗe dla̱mti ta̱mi ga̱ɓa alheri ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<A yisi ɗe kii ɗe a dla̱mikii ga̱ɓa ten kanti Nya ɗe guu ka̱ mbadl go, kaa po yena̱n so. ");
INSERT INTO gyz_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Yek laki yek a nikii ma dla̱mti ɗe, kume gon gwaka̱n ma̱shi yek ba̱ta̱ mbi Nya boo sowu, ba̱k wuli ɗe a hwikii so so. ");
INSERT INTO gyz_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Na̱k ɗe a dla̱l gal, yek a hwikii mas ilgwe Nya lami wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pa̱n ɗem'ɗem na̱ da̱nti gwaka̱n, aka̱a̱ zi gwel ten ma̱jwe Nya kissi tumal hwulan ga̱ yen gwas wu. Yek Shishi ga̱ Nya za̱kii ɗe bacina wu, ta̱k pa̱n kyo gwasa̱n na̱k gwe a ma̱n kyo pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","A yisi ɗe kume a zigaa wugo byas wul mee a tulli ka̱ dlo gwaka̱n, a ba̱sa zak ma̱jwe Nya kissi wu so. ");
INSERT INTO gyz_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tet ka̱ kii mago jon a yili asa̱ shel mbala̱n ta̱s ma̱n kopti gwasa̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Dla̱la̱n na̱ nda̱lti, aka̱a̱ damkii ten kangwe a tla bomti ɗe a hwi ga̱ɓa, na̱ ka̱ cin na̱ ka̱ gasi ka̱ ga̱ gin ɗe mekan wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","<<Ningo a na̱ma za̱t gwaka̱n a ang ɗa̱ Nya ka, suk ta̱mi ga̱ɓa alheri gwasi. Kangwe ta̱mi ga̱ɓa gwas a laki ta̱k yisa̱n Nya i'e, kangwe Nyami a ba̱lkii hwa wul gwe ta ba̱l mas ma̱n kopti gwas wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A ɓo taɓa lamti ɗe ta kaami zinariya sogo azurpa sogo luka̱l ma̱lgon ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Kii gaa gwaka̱n ka̱a̱ yisi ɗe a ngwe wul gaa gini suk ma̱jwe a na̱ suksi wu. ");
INSERT INTO gyz_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mas ilgwe a pa̱li wu, a mbokikii ang ten kangwe kaa zi-ang ma̱jwe ba̱ ilgon nisi ɗa̱ sowu. Daama̱nkii ten ilgwe Yesu dla̱m wu ɗe, <Mbala̱n ba̱l nalti ma̱jwe asa̱ ba̱l wul wu, man ma̱jwe a mbala̱n ba̱lsi wul wu.> >> ");
INSERT INTO gyz_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bulus pakisi hwit ga̱ɓa wu, yek ta̱ ngus atli yek ta̱ ngem Nya suksi. ");
INSERT INTO gyz_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ta̱ ɓa zigaa go yek sa̱ ngusi gwas ngipti te dlo ka asa̱ na̱ma kulu, ");
INSERT INTO gyz_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","na̱k ɗe ta̱ wulsi ɗe sa po yenti sowu, yek ili hwotsi i'e. Yek sa̱ lakti tantu ka̱ lu gwe ta te ka̱ jirgi ze wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ma̱ palli bi bacina ji ma̱n kopti a Apisa wu, yek ma̱ te ka̱ jirgi ze yek ma̱ li ba̱n gon gwe asa̱ mbe ɗe Kos wu. Lu dlo wugo yek ma̱ li Rodusa. Tet duk go yek ma̱ li Patara. ");
INSERT INTO gyz_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ka̱li ka̱n ma̱ te ka̱ jirgi ze gwe a li Pinikiya wu, yek ma̱ te giɓi yek ma̱ zigaa. ");
INSERT INTO gyz_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Yek ma̱ ɓalma yenti ba̱n Kuburus tek go, yek ma̱ yil te malka̱n ba̱mi ka ten tu ka̱t ang shinti yek ma̱ li Siriya. Yek ma̱ mbuk lu a Taya ka̱ lu gwe jirgi zesi shit wul wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yek ma̱ mbi ma̱n kopti ka̱li, yek ma̱ mul ɗe nitgi a Taye. Yek Shishi ga̱ Nya mboki ang ma̱n koptisi yek sa̱ hwi Bulus ɗe ba̱s li Wurshelima so. ");
INSERT INTO gyz_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ama yek za̱tgaa ga̱na̱n tul wu, yek ma̱ ngusi la̱ti. Yek mas ma̱n kopti na̱ modli jwasa̱n na̱ mil jwasa̱n lakni tantu. Ma̱ ɓal ten bi bal zesi go yek ma̱ ngus atli mas jina̱n yek ma̱ ngem Nya. ");
INSERT INTO gyz_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Yek ma̱ palli bi yilkeni wu, yek ma̱ te ka̱ jirgi zesi. Ma̱jwe lakni tantu go yek sa̱ pal ga̱za̱n. ");
INSERT INTO gyz_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tet Taya go yek ma̱ mbuk lu Tolemayis, yek ma̱ ga̱ɓe yilkeni ma̱n kopti jwe ni ka̱li wu. Yek ma̱ mul ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lu dlo wu yek ma̱ zak lwisi, yek ma̱ mbuk lu a Kaisariya. Yek ma̱ da̱m a lubii ɗa̱ Pilibus ka, ma̱lgwe ɗe ata̱ dla̱mi ga̱ɓa ga̱ Nya mbala̱n wu. A Pilibusi ni ɗe gon ka̱ mbala̱n ɗe nitgi jwe sa̱ botlsi wu pak. ");
INSERT INTO gyz_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Mil modli ɗe wupsi jon ni Pilibus ɗa jwe ba̱sa̱ ɓo yis mani sowu, jwe ɗe asa̱ dla̱m ilgwe Shishi ga̱ Nya hwisi wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ma̱ la̱m multi ka̱li wugo, yek ma̱n dla̱mti ga̱ɓa ga̱ Nya gon ka̱wu gwe asa̱ mbet Agabus tet Yehudiya. ");
INSERT INTO gyz_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Yek ta̱ kan wul hapti mis ga̱ Bulus, yek ta̱ ɓal asa̱n suk ang gwas na̱ nali. Yek ta̱ wule, <<Shishi ga̱ Nya wule, <Na̱n ka̱n ma̱n Yehuda a Wurshelima a ɓal ma̱n wul hapti mis gee asa̱ baltiti ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu.> >> ");
INSERT INTO gyz_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ma̱ kumi nu wugo yek mas jina̱n yek ma̱ hwi Bulus ɗe ba̱s li Wurshelima so. ");
INSERT INTO gyz_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Yek Bulus wuli ɗe, <<Yek laki yek ka̱a̱ na̱ma kulu aka̱a̱ na̱ma lamti ta cel ka̱ mbadl ye? Ɓalti hwota̱n so, ko ta̱ tlot mago ta̱s tloni a Wurshelima ten bi ga̱ Yesu Almasihu ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Yek ma̱ yeni ɗe ma man dla̱lla̱t gwas ka̱ sowu, yek ma̱ zakti yek ma̱ wuli ɗe, <<Ta̱ Nya pa̱l ilgwe ta̱ lami na̱ ti wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Na̱k gwisi pi wu, yek ma̱ yem wul jina̱n yek ma̱ li Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Yek ma̱n kopti jon tet Kaisariya lakni tantu se na̱k sa̱ ta̱lani tet lubii ɗa̱ Manason ka, ka̱ lu gwe ma da̱n wu. Manason wo ma̱n ba̱n Kuburus ka̱n a ta̱ ni ka̱ ma̱jwe nga̱ssi ten Yesu cina wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ma̱ mbuk lu Wurshelima wu, yek yilkeni ma̱n kopti wuli ni ɗem na̱ ta̱mi mbadli. ");
INSERT INTO gyz_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Lu dlo wugo, yek Bulus suk mi mas sa yenti ga̱ Yakubu a bacina ji ma̱n kopti mas ni ka̱li pak. ");
INSERT INTO gyz_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Yek Bulus ga̱ɓe si, yek ta̱ hwisi ilgwe Nya zit ang yek ta̱ pa̱li ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Sa̱ kumi nu wugo yek sa̱ ta̱s Nya. Yek sa̱ wul Bulus ɗe, <<Ama ka̱ yis kangwe ili ni a ɗee a Wurshelima gwa? ma̱n Yehuda wonti nga̱ssi ten Yesu, a mas jwasa̱n lam kopti mba̱t ga̱ɓa ga̱ Musa wu i'e. ");
INSERT INTO gyz_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Sa̱ kumi ɗe ka̱ hwi ma̱n Yehuda jwe ni ka̱ atl ga̱ ma̱jwe ba̱ ma̱n Yehuda ka sowu ɗe ba̱s kop mba̱t gwe Nya ba̱l Musa wu so. Ka̱ hwisi ɗe ba̱s sa̱l mil so, a ba̱s po pa̱l wul na̱k gwe a ma̱n Yehuda pa̱li wu so. ");
INSERT INTO gyz_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Yek ma pa̱li ye nii wu, na̱k ɗe sa kumi ɗe ka̱ ɓalɗa̱ wu? ");
INSERT INTO gyz_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ilgwe ma̱ lami ɗe ta̱k pa̱li go yek ɗe, mbala̱n ɗe wupsi jon ni ɗa jwe sa̱ mo ga̱ɓa suk Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Kopsi ta̱k taka̱n wul gwe asa̱ taki Nya ɗe ta̱ ta̱s pol mbala̱n ɗa̱ka̱ byas wul ka̱wu. A ka̱ ɓatl mas wulpi ga̱ wul jwe sa̱ taki Nyami ɗe ta̱s wudlisi gaa ka̱wu. Na̱ nu ka̱n mas mbala̱n a yisi ɗe ilgwe sa̱ dla̱m ten ki go gem ka̱ so, a ma̱n kopti mba̱t ga̱ɓa ga̱ Musa ka̱ yi ɗe ki. ");
INSERT INTO gyz_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu go, ma̱ hwisi wi ɗe ba̱s nguk ilgwe sa̱ taki gunki wu so, a ba̱s nguk hwuu wul so, a ba̱s nguk tlu ga̱ dabba gwe sa̱ celit yal ka yek ta̱ ma̱sh wu so, a ba̱s pi pa̱la̱n so.>> ");
INSERT INTO gyz_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Yek Bulus li suksi, yek sa̱ taki wul Nya ta̱s polti ɗa̱ka̱ byas wul ka. Yek paa ta̱ li ka̱ lubii ga̱ Nyami yek ta̱ hwisi gas gwe takti wuli a paki wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Multi ɗe nitgisi ɓal njaa ta̱ njika̱n go yek ma̱n Yehuda jon tet ka̱t atl ga̱ Asiya yen Bulus ka̱ lubii ga̱ Nya. Yek sa̱ cok mas mbala̱n yek sa̱ dop Bulus. ");
INSERT INTO gyz_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Yek sa̱ dla̱m ɗe, <<Ma̱n Israila, ma̱lgwe hwi ma̱n Yehuda ɗa̱nka ɗe ba̱s kop mba̱t ga̱ɓa ga̱ Musa so, a ba̱s po kan lu gee ɗe ma̱n cilti so wuggu. A yek gee ta tulli ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu a ɗe, ta̱s lil lubii ga̱ Nyami ka.>> ");
INSERT INTO gyz_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Na̱k ɗe sa̱ ya yen Turopimus ma̱n Apisa suk Bulus ka̱ ba̱n wu, yek sa̱ da̱m gwa we Bulus tulla̱t ka̱ lubii ga̱ Nyami. ");
INSERT INTO gyz_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Yek mbadl ga̱ ma̱n ba̱mi tlili mas jwasa̱n, yek sa̱ dop Bulus yek sa̱ yilla̱t ɗa̱ka̱ lubii ga̱ Nyami ka. Ka̱ yilla̱t gwas ka yek sa̱ le dlabiimi ka. ");
INSERT INTO gyz_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Sa̱ ɓa lam tlot gwas wugo, yek bacina ga̱ ma̱n hapti dlo ga̱ ma̱n Roma kumi ɗe Wurshelima hwot ka̱wi. ");
INSERT INTO gyz_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Yek ninge ninge yek ta̱ su suk ma̱n hapti dlo jon. Yek mbala̱mi yen bali ga̱ ma̱n hapti dlomi suk mbala̱n jwas wu, yek sa̱ zak ɓot ga̱ Bulus. ");
INSERT INTO gyz_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Yek bali ga̱ ma̱n hapti dlomi laki yek sa̱ dopti yek sa̱ ɓalti na̱ zaa ga̱lla ɗe lop. Yek ta̱ kum ga̱zi ɗe wok ɗe Bulus wo? A yek ta̱ pa̱li ye? ");
INSERT INTO gyz_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Yek mas mbala̱mi dla̱m wul jwe Bulus pa̱li wu, jon na̱ma dla̱mti ga̱n a jon na̱ma dla̱mti ga̱n. Yek ba̱ bacina ga̱ ma̱n hapti dlomi yis gaa ga̱ wul jwe sa̱ na̱ma dla̱mti wu so, na̱k ɗe mbala̱mi gulsidli ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Sa̱ na̱ma la̱t suk Bulus nugo yek gulsa̱tdli mba̱ldli i'e, se na̱k ma̱n hapti dlomi kanti to nya ka. ");
INSERT INTO gyz_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yek mbala̱mi jwe kopsi wu ngusi wulti ɗe, <<Tloti ka.>> ");
INSERT INTO gyz_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Sa̱ ɓal njaa ta̱s tel Bulus ka̱ lu da̱mti ga̱ ma̱n hapti dlo wu, yek Bulus wulsi ɗe, <<Ha̱n ta ɓo hwikii ilgon ne?>> Yek sa̱ wulti ɗe, <<Ka̱ man bi Giris a? ");
INSERT INTO gyz_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kik ɗe bacina ga̱ ma̱n la̱shi kumti bi tet Masar, gwe laki hal yek mbala̱n 4,000 ngusi tlot mbala̱n ka̱ me wu sa?>> ");
INSERT INTO gyz_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Yek Bulus ballisi ɗe, <<A mi wo ma̱n Yehuda ka̱n tet Tarsus ka̱ atl ga̱ Silisiya. A mi wo ma̱n ba̱n gwe mbala̱n yisi wu ka̱n. Ɓo zaka̱n ninini ta hwi ga̱ɓa ma̱jin.>> ");
INSERT INTO gyz_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Bacina ga̱ ma̱n hapti dlomi zak Bulus ta̱s ga̱ɓa wu, yek ta̱ tlinya yek ta̱ pa̱lisi na̱ ang, yek sa̱ da̱m mbetlak. Sa̱ da̱m mbetlak wu, yek Bulus hwisi ga̱ɓa na̱ bi ga̱ ma̱n Yehuda. ");
INSERT INTO gyz_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Yek Bulus wulsi ɗe, <<Yilkeni jini suk aba jini, ɓo kati ninini ka̱ng ta ɓo pol gaa gi ka.>> ");
INSERT INTO gyz_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Sa̱ kumi ɗe na̱ bi ga̱ ma̱n Yehuda ka̱n ta̱ nisi ma ga̱ɓa wu, yek sa̱ da̱m mbetlak. Yek Bulus wulsi ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","<<A mi wo ma̱n Yehuda ka̱n tet Tarsus ka̱ atl ga̱ Silisiya, ama ka̱ ba̱n ga̱n ka̱n a nali. Gamaliyel ma̱n lishti ka̱ mboki ang ten mba̱t ga̱ɓa ga̱ Musa gwe a ma̱n za̱t jina̱n koɓi wu. A lam kopti mba̱t ga̱ɓa ga̱ Musa i'e na̱k gwe ka̱ na̱ma lamti ase wu. ");
INSERT INTO gyz_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","A nge ma̱n kopti Tantu ga̱ Yesu i'e, yek a ngusi dopti gwasa̱n na̱ modli na̱ maani, yek a ngusi telti gwasa̱n ka̱ lu leti, hal yek naami ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Na̱k gwe bal ma̱n Pa̱ris suk ma̱jwas mas yisi wu. Na̱k ɗe a lak kan lishti tet malsi yek a ta̱le ma̱n kopti jwe ni Demaskus wu, Ɗe ba yemsi tet Wurshelima ta̱ nolsi. ");
INSERT INTO gyz_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<Ten gasisi ka̱ dlo cin a na̱ma la̱t Demaskus nugo yek ba̱u! Nda̱li cilti gon sut nya cilli lu gwe a ni wu ka. ");
INSERT INTO gyz_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Yek a nda te atl ka, yek a kum yal ga̱ɓa gon ten wulti gi ɗe, <Shawulu! Yek laki yek ka̱ nima cit dlelngapcan ye?> >> ");
INSERT INTO gyz_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Yek a wule, <<Bagaa, wok ɗe ki wo?>> Yek yali balli ɗe, <<Amik ɗe Yesu ma̱n Nazarat ma̱lgwe ka̱ nima cit dlelngapcan wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Yek ma̱jwe na̱ma la̱t suk ami wu yen cilti, ama ba̱sa̱ kum ilgwe yali dla̱m wu so. ");
INSERT INTO gyz_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Yek a wule, <<Bagaa, yek ba pa̱li ye?>> Yek ta̱ wule, <<Tlinya ta̱k li Demaskus, ka̱li ka̱n sa hwik mas ilgwe a botlki ɗe ta̱k pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Yek ma̱jwe ni suk ami wu ngiɓi ang, yek sa̱ ta̱la Demaskus na̱k ɗe cilti laki yek ba po man yenti lu sowu. ");
INSERT INTO gyz_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Yek ma̱lgon asa̱ mbet Hananiya tuli ta̱s yena̱nni. Ma̱n kopti mba̱t ga̱ɓa ga̱ Musa i'e ka̱ɗe ti, a ma̱n Yehuda ga̱ ba̱mi mas yisi ɗe ti wo hwa mbala̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Yek ta̱ lak dla̱l a mala̱nni, yek ta̱ wula̱n ɗe, <Yilka gini, ɓul gwel ta̱k yen lu.> Yek ninge-ninge yek gwel gi ɓuli yek a man yenti gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","<<Yek ta̱ wula̱n ɗe, <Nya ga̱ aba jina̱n botlki, ta̱k yis ilgwe ta̱ lami wu a ta̱k yen ma̱n zok mbadl gwasi, ta̱k ga̱ɓa sukti bi suk bi. ");
INSERT INTO gyz_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ka dla̱mi mbala̱n mas ilgwe ka̱ yeni yek ka̱ kumi tenti wu. ");
INSERT INTO gyz_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ningo yek ka̱ yima ɓa̱tti ye? Tlinya ta̱s pa̱lik baptisma ta̱s polik byas wul jwa ka, aka̱ mbe shin gwasi.> ");
INSERT INTO gyz_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<A pal tet Wurshelima ɗe a ɓalma ngemti Nya ka̱ lubii ga̱ Nya wu, yek Nya ɓuli gwel, ");
INSERT INTO gyz_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","yek a yen Bagaa. Yek ta̱ wula̱n ɗe, <Zak ba̱n Wurshelima ninge ninge, ma̱n ba̱mi a katik ka̱ng so, ɗe ka̱ ɓa dla̱m ga̱ɓa tena̱n wu.> ");
INSERT INTO gyz_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","<<Yek a wulti ɗe, <Bagaa, ma̱jimi yisi ɗe a na̱ma ma̱tlti ɗa̱nka̱ lu motgaa ji ma̱n Yehuda ka a dop yilkeni jwasa̱n a telsi ka̱ lu gwe asa̱ le ma̱jwe pa̱l ilgwe ba̱ yek sowu. ");
INSERT INTO gyz_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɗe sa̱ dlo Istipanus ma̱lgwe hwi ga̱ɓa gwa mbala̱n go, aa ni ka̱li ani ma̱jwe tlot wu kaali. Hal amik ɗe ma̱n ɓa̱tti luka̱l ga̱ ma̱jwe tlot wu.> ");
INSERT INTO gyz_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","<<Yek ta̱ wula̱n ɗe, <Zigaa, ba shinki dlenti te mal ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu.> >> ");
INSERT INTO gyz_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Mbala̱mi kumi ɗe Bulus dla̱m nu wu, yek sa̱ tlil yal nya yek sa̱ wule, <<Kama̱nti te ka ta̱k tloti, mbun ɗe ta̱k zaka̱n ti so.>> ");
INSERT INTO gyz_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Sa̱ na̱ma ga̱ɓa asa̱ na̱ma catti atl to nya ka asa̱ na̱ma wutti luka̱l ka nugo, ");
INSERT INTO gyz_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","yek bacina ga̱ ma̱n hapti dlomi laki yek sa̱ ta̱la Bulus ka̱ lu da̱mti ga̱ ma̱n hapti dlo. Yek ta̱ dla̱m ɗe ta̱s ɓo ti yek sa̱ ngemti ta̱s yis ilgwe laki ɗe mbala̱n na̱ma ga̱ɓa tenti nu? ");
INSERT INTO gyz_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Sa̱ ɓal Bulus wi ɗe ta̱s ɓot wugo yek ta̱ wul ma̱n hapti dlomi ɗe, <<Mba̱t ga̱ɓa wuli ɗe ta̱ ɓo ma̱n Roma gwe ba̱sa̱ ɓo pa̱lit kisti ga̱ɓa so gwa?>> ");
INSERT INTO gyz_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Yek bacina ga̱ ma̱n hapti dlomi kumi nu wu, yek ta̱ li mal bali gwasa̱n, yek ta̱ wulti ɗe, <<Yek ka̱ na̱ma lamti pa̱lti ye?>> ma̱lga̱n co yen atl ga̱ Roma ka̱ca. ");
INSERT INTO gyz_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Yek bali ga̱ ma̱n hapti dlomi li mal Bulus yek ta̱ wulti ɗe, <<Hwini, ki wo yen atl ga̱ Roma ka?>> Yek Bulus wulti ɗe, <<Yii ami wo yen Roma ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Yek bacina ga̱ ma̱n hapti dlomi wule, <<Ama go yen Roma ka̱ɗe ami, ama se na̱k a dlo bal wulpi yek a nda da̱mti ɗe yen Rome.>> Yek Bulus wulti ɗe, <<Ami wo ka̱ atl ga̱ Roma ka̱ sa̱ za̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Yek ba̱ ma̱jwe lami ɗe ta̱s ngem Bulus ten ilgwe ta̱ pa̱li wu po man wulti ɗe ilgon so. Yek ɓanti njel cit ga̱ bacina ga̱ ma̱n hapti dlomi na̱k ɗe Bulus wo yen atl ga̱ Roma ka̱n a yekgu ta̱ ɓalti wu. ");
INSERT INTO gyz_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Bacina ga̱ ma̱n hapti dlomi lami ɗe ta̱s yis ilgwe laki yek ma̱n Yehuda na̱ma dla̱mti byas ga̱ɓa ten Bulus wu. Yek ta̱ laki ɗe lu tlo wugo ta̱ mbe motgaa ga̱ kiɗi ma̱n Pa̱ris ka̱ lubii ga̱ Nya suk kiɗi ji ba̱mi tet madl. Yek ta̱ tulli Bulus malsi. ");
INSERT INTO gyz_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Yek Bulus yen ma̱n da̱mti Sanhidirin te gwel ka yek ta̱ wulsi ɗe, <<Yilkeni jini, a yisi ɗe a pa̱l da̱mti hwaɓi a cina ɗa̱ Nya ka a mbadl gi dla̱mi a pa̱l byas ilgon a cina ɗa̱ Nya ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Bulus dla̱m nu wugo yek Hananiya bal ma̱n Pa̱ris wul ma̱jwe ni njaa mal Bulus wu ɗe ta̱s ɓo bi gwasi. ");
INSERT INTO gyz_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Yek Bulus wulti ɗe, <<Nya a ɓoki ki ma̱n shelti lali. Ka̱ da̱m ɗe ta̱k kis ga̱ɓa tena̱nni ka̱ mba̱t ga̱ɓa ga̱ Musa ama ba̱ka̱ man kopti mba̱ti so na̱k ɗe ka̱ wule ta̱s ɓo wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yek ma̱jwe dla̱l njaa mal Bulus wu wulti ɗe, <<Bal ma̱n Pa̱ris ka̱n ka̱ na̱ma byalti gwas a?>> ");
INSERT INTO gyz_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Yek Bulus wulsi ɗe, <<Yilkeni jini, a yisi ɗe tik ɗe bal ma̱n Pa̱ris so. Ga̱ɓa ga̱ Nya wule, <Ba̱k dla̱m byas ga̱ɓa ten bacina gwa so.> >> ");
INSERT INTO gyz_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Bulus yisi ɗe jon jwasa̱n wo ma̱n Saduki ka̱n a jon wo ma̱n Paresi wu. Yek ta̱ wuli to nya ɗe, <<Yilkeni jini, ami wo ba Paresi ka̱n, aba gi mago ba Paresi. Ka̱a̱ na̱ma pa̱lti kisti ga̱ɓa tena̱nni na̱k ɗe a zi mbadl ɗe ma̱jwe ma̱sh wu a tli ɗa̱ka̱ ma̱shka̱n ka wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Bulus dla̱m nu wugo yek dlanti tli ka̱ dlo ga̱ ma̱n Paresi suk ma̱n Saduki, yek motgaami tatl ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Ma̱n Saduki wo sa̱ wule ma̱jwe ma̱sh wu a tli ɗa̱ka̱ ma̱shka̱n ka so, a ba̱ ilgon ni ɗa̱ɗe mil shinti ji Nya suk ma̱zhe so ama ma̱n Paresi zi mbadl ɗe mas jwisi ni ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Yek dlantisi mba̱l tli. Yek ma̱n yisti mba̱t ga̱ɓa ga̱ Musa jwe ɗe ma̱n Paresi ju dla̱l gaa suk kul yek sa̱ wu wule, <<Ma̱ yen byas ilgwe ma̱lga̱n pa̱li wu so, gon a yen shinti ga̱ Nya sogo ma̱zhe ka̱ ga̱ɓa sukti?>> ");
INSERT INTO gyz_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Yek dlantisi po mba̱ldli ɗa, yek bacina ga̱ ma̱n hapti dlomi yeni go gon asa̱ caccal Bulus ka. Yek ta̱ laki yek sa̱ kanti ka na̱ nda̱lti yek sa̱ ta̱lat ka̱ lu da̱mti gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Gas ɓal go yek Bagaa lak tlal njaa mal Bulus yek ta̱ wulti ɗe, <<Dla̱l na̱ nda̱lti, na̱k gwe ka̱ dla̱m ga̱ɓa tena̱nni a Wurshelima go nuk ka dla̱m a Roma pak.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lu dlo wugo yek ma̱n Yehuda mogaa yek sa̱ ɓel bi yek sa̱ dla̱lli ga̱ɓa ɗe sa̱ nguk wul so a ba̱sa tla ilgon so se sa̱ dlo Bulus. ");
INSERT INTO gyz_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ma̱jwe ɓel bisi yek sa̱ dla̱lli ga̱ɓe go sa̱ man kutl ɗe wupsi. ");
INSERT INTO gyz_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yek sa̱ li mal bal ma̱n Pa̱ris yek sa̱ wulti ɗe, <<Ma̱ dla̱lli ga̱ɓa ɗe ma nguk wul so se ma̱ dlo Bulus. ");
INSERT INTO gyz_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ta̱ ki suk kiɗi ji ba̱n laki ɗe ta̱ bacina ga̱ ma̱n hapti dlo ta̱lat tet malkii, ten ɗe ka̱a̱ lam kumti mas ilgwe tulli ga̱ɓa tenti wu, moo ma tlot ka a ba̱ta̱ ɓo mbuk lu a ɗe so.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Yek yen kawu ga̱ Bulus kum ilgwe sa̱ na̱ma lamti ta̱s pa̱li Bulus wu, yek ta̱ li ka̱ lu da̱mti ji ma̱n hapti dlomi yek ta̱ hwi Bulus. ");
INSERT INTO gyz_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Yek Bulus mbe gon ka̱ ma̱n hapti dlomi yek ta̱ wulti ɗe, <<Ta̱la yen ga̱n mal bacina gwaka̱n ta̱ lamit hwit ilgon.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Yek ta̱ ta̱la yeni mal bacina ga̱ ma̱n hapti dlomi. ");
INSERT INTO gyz_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Yek bacina ga̱ ma̱n hapti dlomi ngiɓi ang yeni yek ta̱ wulti ɗe, <<Yek ka̱ lami hwiti ye?>> ");
INSERT INTO gyz_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Yek yeni wulti ɗe, <<Ma̱n Yehuda ɓel bi ɗe sa ngemki ta̱k ta̱lesi Bulus mal kiɗi ji ba̱n ten ɗe sa kum ga̱s ilgwe tulli ga̱ɓa tenti wu i'e. ");
INSERT INTO gyz_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ba̱k ba̱lsi Bulus so, mbala̱n jwe sa̱ man kutl ɗe wupsi wu na̱ma ɓa̱tti gwasi. Sa̱ dla̱lli ga̱ɓa ɗe sa nguk wul so a ba̱sa tla so se tloti. Ningo sa̱ na̱ma ɓa̱tti ilgwe ka pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Yek bacina ga̱ ma̱n hapti dlomi lak yeni tantu yek ta̱ wulti ɗe, <<Ba̱k hwi ma̱lgon ilgwe ka̱ hwi wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Yek bacina ga̱ ma̱n hapti dlomi mbe ɗe lop ka̱ ma̱n hapti dlomi yek ta̱ wulsi ɗe, <<Bodl ma̱n hapti dlo 2,000 suk ma̱n hapti dlo jwe a to ten kapsi 70 suk ma̱n gashi 200 ta̱s li Kaisariya ka̱ gasi. ");
INSERT INTO gyz_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","A ka̱ ngo kapsi gwe Bulus a to dani wu aka̱ ta̱lat mal gobna Pelis ba̱ ilgon mbit so.>> ");
INSERT INTO gyz_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Yek ta̱ lish ga̱ɓa ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ami Kaludiwus Lisiyas ka̱ lishit ga̱ɓa ge ma̱n nalti Pelis gobna. A na̱ma ga̱ɓet gwa. ");
INSERT INTO gyz_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Yek ma̱n Yehuda dop ma̱lga̱n sa̱ na̱ma lamti tlot gwasi, yek a li suk ma̱n hapti dlo yek ma̱ kisti tet ka̱ ang gwasa̱n na̱k ɗe a kumi ɗe ti wo ma̱n atl ga̱ Roma ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Yek a ngwe ta yis ilgwe laki yek sa̱ naa nget gwas wu, yek a ta̱lat te mal kiɗi ga̱ ma̱n Yehuda. ");
INSERT INTO gyz_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Yek a kumi go ilgwe sa̱ na̱ma dla̱mti tenti go ten mba̱t gwasa̱n ka̱n, ama ta̱ pa̱l ilgwe a laki a tlot wu sogo telti ka̱ lu gwe asa̱ le ma̱jwe pa̱l ilgwe ba̱ yek sowu so. ");
INSERT INTO gyz_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","A kumi ɗe sa̱ ɓel tenti wu, yek laki yek a wule ta̱s ta̱lat malki ninge. Yek a hwi ma̱jwe dopti wu ta̱s lak dla̱mik ilgwe ta̱ pa̱lisi wu. ");
INSERT INTO gyz_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Yek ma̱n hapti dlomi kan Bulus tet Wurshelima ka̱ gasi na̱k gwe sa̱ zisi pa̱lti wu, yek sa̱ ta̱lat Antipatiris. ");
INSERT INTO gyz_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yek lu dlo wugo, yek sa̱ zak ma̱n kapsi ju sukti yek sa̱ pa̱l tet ka̱ lu da̱nti ga̱ ma̱n hapti dlomi. ");
INSERT INTO gyz_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ma̱n hapti dlo jwe ni ten kapsi wu mbuki Kaisariya wu, yek sa̱ ba̱l lishiti gwe bacina gwasa̱n lishi gobne wu, yek sa̱ ba̱ltiti Bulus. ");
INSERT INTO gyz_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Yek gobne yen lishtisi wu yek ta̱ kum ga̱zi ɗe ten ka̱t atl gwik Bulus yil tet gwi? Ta̱ kumi wi ɗe tet Silisiya ka̱n ta̱ yil tet wu, ");
INSERT INTO gyz_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","yek ta̱ wule, <<Ba ga̱ɓa ten ilgwe sa̱ ta̱lak tet mala̱n wu ɗe ma̱jwe tulli ga̱ɓa ten ki wu ɓalɗa̱ wu.>> Yek ta̱ laki ɗe ta̱s zi Bulus ɗa̱ Hiridus ka asa̱ ɓa̱tti. ");
INSERT INTO gyz_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kaal ɗa̱ multi ɗe namtan yek Hananiya bal ma̱n Pa̱ris su Kaisariya suk kiɗi mbala̱n jon suk ma̱n yisti mba̱t ga̱ɓa ga̱ ma̱n Roma gon gwe asa̱ mbet ɗe Tartulus, yek sa̱ dla̱mi gobne ilgwe Bulus pa̱lisi wu. ");
INSERT INTO gyz_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Sa̱ mbe Bulus tet wu yek Tartulus wule, <<Ma̱ pa̱l tlal multi wi a ma̱ na̱ma kumti ta̱mti gwa guu, ɓotlka̱n yisti wul gwa tulli la̱ka̱nti wul wonti ka̱ mbala̱n jina̱n. ");
INSERT INTO gyz_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ma̱ yen cit cina ko a tu ko, yek laki yek ma̱ na̱ma hwol tuk na̱ ilgwe ka̱ pa̱li wu ma̱n nalti Pelis. ");
INSERT INTO gyz_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","A lami ɗe ta dla̱kki na̱ tlal ga̱ɓa so, ama a na̱ma ngemti gwa ta̱k ɓo katini ka̱ng njet ne. ");
INSERT INTO gyz_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","<<Ma̱lga̱n go ma̱n tulla̱t dlanti ka̱ mbala̱n ka̱n, ma̱ dopti ten tlilti dlanti ka̱ ma̱n Yehuda ten dii atl mas. A tik ɗe bacina ga̱ ma̱jwe asa̱ mbesi ɗe ma̱n Nazara wu, ");
INSERT INTO gyz_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","hal ta̱ ngwe ta̱s lil lubii ga̱ Nya ka, na̱ ilgwe ba̱ mbun ɗe ta̱ pa̱li giɓi sowu, yek laki yek ma̱ dopti. ");
INSERT INTO gyz_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Kume ka̱ bodla̱lti go ki na̱ gaa gwa ka yisi ɗe ilgwe ma̱ na̱ma dla̱mti tenti go gem ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yek ma̱n Yehudasi moo bi yek sa̱ dla̱m ɗe mas ilgwe ta̱ dla̱m ten Bulus go gem ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Yek gobne ba̱l lu Bulus ɗe ta̱s ga̱ɓa wu yek Bulus wuli ɗe, <<A yisi ɗe ka̱ da̱m ɗe ma̱n kisti ga̱ɓa wonti wi, yek laki yek ba dla̱m ilgwe a yisi ten gaa gi wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Kume ka̱ kusi go ka yisi ɗe, multi ɗe cutl cet lop ka̱ yi, ɗe ala ngusti atl Nya a Wurshelima wu. ");
INSERT INTO gyz_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ma̱jwe ta̱la tet malki wu yena̱n ten dla̱kti ga̱ɓa suk ma̱lgon so, a ba̱sa̱ yena̱n ten tulla̱t dlanti ka̱ lubii ga̱ Nya sogo ka̱ bii motgaa ga̱ ma̱n Yehuda, sogo ka̱ lu gon ka̱ ba̱n ga̱n so. ");
INSERT INTO gyz_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","A ba̱sa man mbokti ang ɗe byas wul jwe sa̱ wule a pa̱li go gem ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ko ɗe gem ka̱n a nima ngusti atl Nya ga̱ aba jina̱n, tumal kopti Tantu ga̱ Yesu gwe si wo asa̱ mbe ɗe kopti lal wu. A kan mas wul jwe mba̱t ga̱ɓa ga̱ Musa suk ma̱n dla̱mti ga̱ɓa ji Nya lishi ɗe gem. ");
INSERT INTO gyz_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","A zi mbadl ten Nya gwe ma̱jin zi mbadl tenti wu. Na̱k gwe sa̱ yisi wu, ama go a yisi ɗe ma̱jwe ma̱sh wu Nya a pallisi kaami, na̱ ma̱lgwe pa̱l hwa wul wu na̱ ma̱lgwe pa̱l byasi wu. ");
INSERT INTO gyz_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Yek laki a ngusi tlot gini, ta̱ daamti gi ni hwaɓi mal Nya suk mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<A da̱m tu gon ka̱ gin wonti a ɓa pal Wurshelima wu, yek a pal tet na̱ wulpi gwe ba ba̱l ma̱jwe ba̱ wul nisi ɗa̱ sowu, suk wul jwe ba taki Nya wu. ");
INSERT INTO gyz_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Sa̱ mbi ka̱ lubii ga̱ Nyami go, a pak pa̱lti kangwe a ma̱n Yehuda pa̱li asa̱ la̱ka̱n dlo gwasa̱n suk Nya wu wi. Aba̱ ma̱jon ni suk ami so, a ba̱ tlil dlanti so. ");
INSERT INTO gyz_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ma̱n Yehuda jon ni ka̱li, ma̱jwe sa̱ yil tet ka̱ atl ga̱ Asiya wu. Kume ga̱ɓa nisi ɗa tena̱n wu ta̱s lak dla̱mi ");
INSERT INTO gyz_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Sogo ta̱ ma̱jin dla̱m byas ilgwe sa̱ mbi tena̱n wu ɗe sa̱ ta̱la te ma̱n Sanhidirin ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Seko ɗe a dla̱m ga̱ɓa na̱ nda̱li yal, <ten bi tlit ɗa̱ka̱ ma̱shka̱n ka ga̱ ma̱jwe ma̱sh wugo, yek laki yek sa̱ ta̱la tet malki ase ta̱k kisi ninini ga̱ɓa.> >> ");
INSERT INTO gyz_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Yek Pelis wo ta̱ yis wul wonti ten bi kopti Tantu ga̱ Yesu. Yek ta̱ dla̱k ga̱ɓe ka se gasi gon, yek ta̱ dla̱m ɗe, <<Kume Lisiyas bacina ga̱ ma̱n hapti dlo tul wu, ba ga̱ɓa ten ga̱ɓa gee.>> ");
INSERT INTO gyz_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Yek ta̱ wul ma̱n hapti dlo gwe na̱ma ɓa̱tti gwas wu ɗe, ta̱s giɓ Bulus a ba̱s cit dlelngapcan so a ba̱s mbol yela̱n jwas ɗa̱ malti ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kaal ɗa̱ multi jon yek Pelis suk kili gwasi Dursila gwe ɗe ti wo ma̱n Yehuda ka̱wu tuli. Yek Pelis shinlu ta̱s mbet Bulus teɗi. Yek sa̱ kati ka̱n Bulus i'e ɗe ta̱ hwisi ga̱ɓa ten bi nga̱sti Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Bulus hwisi ga̱ɓa ten da̱nti na̱ zok mbadli suk nget ten gaa, suk kisti ga̱ɓa gwe Nya a pa̱li mbala̱n ten mas ilgwe sa̱ pa̱li wu, yek ɓanti njel cit ga̱ Pelis, yek ta̱ wule, <<Zigaa nu, kume a mbi tantu, wu ba shinit lu.>> ");
INSERT INTO gyz_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pelis zi mbadl ɗe, gwa a Bulus ba̱lti wulpi cit icin, yek ta̱ ngusi mbet gwas ata̱ ngusi ga̱ɓa sukti. ");
INSERT INTO gyz_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kaal ɗa̱ gin ɗe lop yek Poshos Pestus da̱m ɗe guu ka̱ lal Pelis. na̱k ɗe Pelis lam mbit hwol hwulan mal ma̱n Yehuda wu yek ta̱ zak Bulus ga̱ leka. ");
INSERT INTO gyz_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Pestus li ka̱ ka̱t atl ga̱ Kaisariya ta̱s nda pa̱lti wul ɗe gobna. Kaal ɗa multi ɗe mekan na̱ da̱mti ɗe gobna wu yek ta̱ to Wurshelima. ");
INSERT INTO gyz_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ka̱li ka̱n kiɗi ma̱n Pa̱ris suk kiɗi ji ma̱n Yehuda mogaa ta̱s hwit ilgwe Bulus pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Yek sa̱ ngemti ɗe ta̱s laki ta̱ palli Bulus tet Wurshelima ne, na̱k ɗe sa̱ ɓel bi wi ɗe sa tlot ka ten tantu wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Yek Pestus wulsi ɗe, <<Bulus ni ga̱ le ka a Kaisariya a ama go bali te Kaisariye ka ninge. ");
INSERT INTO gyz_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ta̱ bacina jwaka̱n koɓa̱nni ta̱s lak dla̱m byas wul jwe ta̱ pa̱li wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Pestus mul ɗe kutl sogo ɗe wusupsi suksi wu yek ta̱ pal te Kaisariya ka. Yek lu tlo wugo yek ta̱ da̱n ka̱ gobdlan guu, yek ta̱ laki yek sa̱ yilli Bulus teɗi. ");
INSERT INTO gyz_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Sa̱ tulli Bulus wu, yek ma̱n Yehuda jon tet Wurshelima gada̱lti yek sa̱ ngusi dla̱mti kiɗi ga̱ɓa tenti wu, jwe ba̱sa man mbokti ang dani ɗe nuk ni sowu. ");
INSERT INTO gyz_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Yek Bulus wule, <<A pa̱l ilgwe ni byasi ka̱ mba̱t ga̱ɓa ga̱ ma̱n Yehuda wu so, a baa tulli dlanti ka̱ lubii ga̱ Nya so, a baa dla̱m byas ilgon ten Kaisar bal guu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Na̱k ɗe Pestus lami ɗe ta̱s mbi hwol hwulan mal ma̱n Yehuda wu, yek ta̱ wulti ɗe, <<Ka̱ lami ɗe ta̱k li Wurshelima ta̱k tok pa̱l kisti ga̱ɓa ten ga̱ɓa jimi ɗe sa̱ dla̱m ten ki gwa?>> ");
INSERT INTO gyz_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Yek Bulus wule, <<Na̱k ningo ka̱ lu kisti ga̱ɓa ga̱ Kaisar ka̱n sa̱ nima kisti ga̱ɓa, ka̱li ka̱n sa̱ na̱ma cinga̱lti gini. Ki gaa gwa mago ka̱ yisi ɗe a pa̱li ilgon ma̱n Yehuda so. ");
INSERT INTO gyz_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Kume a pa̱l byas wul gwe a mbuk dlot gi go, ba nge ma̱shka̱n so. A kume ga̱ɓa jin ɗe ma̱n Yehuda dla̱m tena̱n go gem ka̱ sowu, ma̱lgon a man ba̱lsi bi tena̱n ɗe ta̱s dlo so. A na̱ma ngemti gwa ɗe ta̱k ta̱la ga̱ɓa ga̱n mal Kaisar ne.>> ");
INSERT INTO gyz_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Pestus ga̱ɓa suk yela̱n dla̱mti jwas wu, yek ta̱ wulti ɗe, <<Na̱k ɗe ka̱ ngemi ɗe ta̱ ta̱la ga̱ɓe mal Kaisar wu, malti ka̱n sa sa̱ ta̱laki.>> ");
INSERT INTO gyz_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","La̱m multi wu, yek Agiripa guu suk yilka gwasi Bani li Kaisariya ta̱s ga̱ɓe Pestus na̱ da̱mti ɗe gobna. ");
INSERT INTO gyz_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Na̱k ɗe sa̱ mul Kaisariya wonti wu, yek Pestus dla̱m bi ga̱ ga̱ɓa Bulus suk guumi. Yek ta̱ wulti ɗe, <<Ma̱lgon ni a ɗe ma̱lgwe Pelis zakti ga̱ le ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ɗe a to Wurshelima wu, yek kiɗi ma̱n Pa̱ris suk kiɗi ji ma̱n Yehuda dla̱m ɗe ta̱ pa̱l byas wul wonti, yek sa̱ ngema̱n ɗe ta lilti ka. ");
INSERT INTO gyz_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","<<Yek a wulsi ɗe, mi ma̱n atl ga̱ Roma wo ba̱ma ba̱l bi ga̱ mbala̱n ba pa̱lti cinga̱lti ga̱ɓa so, se ma̱ zak ma̱li yek ta̱ dla̱m ga̱ɓa gwe a man yilla̱t gwas wu a cina ɗa̱ ma̱jwe tulli ga̱ɓa tenti wu ka. ");
INSERT INTO gyz_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Yek ma̱jwe tulli ga̱ɓa tenti wu mbuk lu wu, yek a laki yek sa̱ yilli ma̱li tot ka̱ lu kisti ga̱ɓa ba̱le-ba̱le, yek ma̱ njel kisti ga̱ɓa tenti na̱ tlot ɗa̱ lu wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ama yek ba̱ ma̱jwe tulli ga̱ɓe wu dla̱m ilgwe a zi ɗe sa̱ dla̱m wu so. ");
INSERT INTO gyz_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ilgwe te ka̱ dlo gwasa̱n sukti go yek ɗe, ga̱ɓa ten kopti Nya gwasa̱n suk ten bi ga̱ ma̱lgon ɗe asa̱ mbet ɗe Yesu wu, gwe ta̱ ma̱shi ama yek Bulus wule ningo ta̱ tli ɗa̱ka̱ ma̱shka̱n ka wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Yek gaa gili ka, yek ba̱ a yis ilgwe ba pa̱li ten ga̱ɓe wu so, yek laki yek a ngem ma̱li ɗe ko ta̱ lama̱n tot Wurshelima ta̱ pa̱lit kisti ga̱ɓa ten wul jimi ɗe sa̱ dla̱m tenti wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Yek ta̱ ngema̱n ɗe ta ta̱la ga̱ɓe mal bal guu ne, yek a laki ɗe ta̱s let ka, se gas gwe ba ta̱lat mal Kaisari wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Yek Agiripa guu wul Pestus ɗe, <<Ami mago a lam kumti ga̱ ma̱li pak.>> Yek Pestus wulti ɗe, <<Ayo go ka kuma̱nti.>> ");
INSERT INTO gyz_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lu dlo wu, yek Agiripa guu suk Bani tul ka̱ bal lu kisti ga̱ɓa. Yek mbala̱n ngusi ta̱sti gwasa̱n asa̱ nisi ma pa̱lti wul jwe a ba̱lsi nalti wonti wu. Yek sa̱ te ka̱ lu kisti ga̱ɓe suk kiɗi ma̱n hapti dlo suk kiɗi ji ba̱mi. Yek Pestus laki yek sa̱ kan Bulus teɗi. ");
INSERT INTO gyz_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Yek Pestus wul guumi suk mas ma̱jwe ni ka̱li wu ɗe, <<Ka̱ yena̱n ma̱lga̱n ma? Ma̱n Yehuda a Wurshelima suk ji ɗe tulli ga̱ɓa tenti, asa̱ na̱ma dla̱mti ɗe ta̱ tlot ka. ");
INSERT INTO gyz_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ama ami wo a yen byas ilgwe ta̱ pa̱li gwe mbuki ɗe ta̱ tlot wu so. Yek laki, yek sa ta̱lat mal bal guu, na̱k ɗe ta̱ ngema̱n ɗe ta̱ tol ga̱ɓe malti wu. ");
INSERT INTO gyz_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ama ami wo a yis ilgwe ba lishi bal guu ga̱na̱n tenti wu so. Yek laki yek a ta̱lat tet malkii, tun na̱k ba̱ ki guu so, ta̱n ɓo yeni ni, ta yis ilgwe ba lishi bal guu wu ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Yenti gi wo mbun ɗe ta̱ ta̱la mbala̱n mal bal guu ba yisti byas ilgwe ma̱li pa̱li wu so so.>> ");
INSERT INTO gyz_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Yek Agiripa guu wul Bulus ɗe, <<Ma̱ ba̱lki lu wi, hwini ilgwe ka̱ yisi wu.>> Yek Bulus tlinya yek ta̱ ba̱lsi nalti na̱ ang yek paa ta̱ nda ga̱ɓa yilla̱t gaa gwasi yek wule, ");
INSERT INTO gyz_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","<<Mal nalti guu, a pa̱l hwol tuki na̱k ɗe ki ka̱n ba hwik ga̱ɓa ga̱n ase wu, ta ga̱ɓa ten mas ilgwe mbala̱n ji dla̱m tena̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","A dla̱m na̱k gwisi na̱k ɗe ki wo ma̱lgwe yis pa̱lti wul ga̱ ma̱n Yehuda i'e ka̱wu. A na̱ma ngemti gwa ta̱k dlo mbadli ta̱k kati ka̱ng ne. ");
INSERT INTO gyz_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","<<Mas ma̱n Yehuda yis kangwe pa̱l da̱mti ka̱ atl gini suk a Wurshelima wu, tun tet ten nak eni gini. ");
INSERT INTO gyz_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Kume sa dla̱m gem go, sa̱ yisi ɗe ten bi kopti Nya ga̱na̱n wo, ami wo tek go ba Paresi ka̱n, ma̱jwe asa̱ zi gwel ten kopti mba̱t ga̱ɓa ga̱na̱n i'e wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Za̱t mbadl ten ga̱ɓa Nya dla̱lli aba jina̱n wu ka̱ laki yek sa̱ nima pa̱lti kisti ga̱ɓa ase. ");
INSERT INTO gyz_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ga̱ɓa gwisi ka̱ɗe ilgwe ta̱ dla̱lli ma̱n boo ga̱ Israila ɗe kutl cet lop wu. Yek ka̱n sa̱ na̱ma ɓa̱tti ta̱ njika̱n ɗe sa̱ nitma ngusti atli na̱ ka̱ cin na̱ ka̱ gas wu. Na̱ nalti gwa guu, za̱t mbadl gwisi ka̱ laki yek ma̱n Yehuda nima ta̱la tet dlaboo. ");
INSERT INTO gyz_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Yek laki ɗe ba̱ka̱a̱ kan ɗe, Nya a man palla̱t kaami ma̱jwe ma̱sh wu so ye? ");
INSERT INTO gyz_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","<<Ami mago da̱mti gi tek go a lam dlot gini ta pa̱l ilgwe a laki a mbala̱n nge Yesu ga̱ Nazarat wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nu ka̱n aa kul pa̱li a Wurshelima, a kum ga̱zi mal kiɗi ma̱n Pa̱ris ɗe ta man dop ma̱n kopti gwas ɗa. Yek a dop wonti ka̱si yek a lesi ka. A kume sa̱ ɓa tlosi wu, a kop kaal ji ma̱n tlot gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","A kul kopsi ka̱ lu motgaa ga̱ ma̱n Yehuda a dopsi, a nolsi. A kul dloni ta laksi ta̱s nget Yesu. Na̱k ɗe a mbadl gi lil i'e na̱si wu a ngusi kopsi gwasa̱n ɗa̱nka̱ da̱ki ba̱n ka ta cisi dlelngapcan ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","<<Ma̱n nalti guu, gas gon a na̱ma la̱t Demaskus na̱ lishti gwe kiɗi ma̱n Pa̱ris ba̱la̱n wu gwe ba̱la̱n nda̱lti dopti ga̱ ma̱n kopti wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Na̱ nalti gwa guu, ka̱ dlo cin a ni ten tantu nugo yek a yen bal cilti gon sut nya gwe cil man cin wu. Yek ba̱u! Cilti cilla̱n ka suk ma̱jwe a na̱ma la̱t suksi wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Yek ma̱ lok te atl ka ka̱li mas jina̱n, yek a kum yal ga̱ɓa gon na̱ bi ga̱ ma̱n Yehuda ten wulti ɗe, <Shawulu! Yek laki yek ka̱ nima cit dlelngapcan ye? Ka kumi cwo gaa gwa, ɗe ka̱ na̱ma lamti ta̱k dlanki suk ami?> ");
INSERT INTO gyz_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","<<Yek a kum ga̱zi ɗe, <Bagaa, wok ɗe ki wo?> <<Yek ta̱ balli ɗe, <Amik ɗe Yesu, ma̱lgwe ka̱ nitma cit dlelngapcan wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Tlinya, a tul malki ta botlki ɗe zhel gini suk ma̱lgwe a mboki ang mbala̱n ten ilgwe ka̱ yeni suk ilgwe ba ya mbokik ang dani tena̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ba kiski ɗa̱ka̱ ang ga̱ mbala̱n jwa ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ka. Ba shinki malsi, ");
INSERT INTO gyz_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ta̱k ɓulisi gwel aka̱ yilla̱si ɗa̱ka̱ da̱mshal ka, aka̱ balla̱si tumal cilti. Ba shinki ta̱k yilla̱si ɗa̱ka̱ ndalti ga̱ guu ma̱zhe ka, asa̱ kan Nya ɗe guu ka̱ mbadl gwasa̱n wu. A paa Nya taas byas wul jwasa̱n ka, asa̱ mbi lu da̱mti ka̱ mbala̱n jini jwe a polsi ka tumal nga̱sti gwasa̱n tena̱n wu.> ");
INSERT INTO gyz_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Ma̱n nalti guu, na̱k gwisi laki yek ba̱ a nge kopti ga̱ɓa gwe a kumi sut nya wu so. ");
INSERT INTO gyz_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ma̱jwe a nda̱si dla̱mti ga̱ɓa go sik ɗe ma̱n Demaskus, yek paa ma̱n Wurshelima suk ma̱n Yehudiya, suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu pak. A hwisi ga̱ɓa ga̱ Nya ɗe ta̱s ci atl gaa, asa̱ balla̱si tet mal Nya asa̱ pa̱l wul jwe a mbok ang ten cit atl gaa gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Yek laki yek ma̱n Yehuda doɓa̱n ka̱ lubii ga̱ Nya, yek sa̱ ngwe ɗe ta̱s tloni. ");
INSERT INTO gyz_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ama yek Nya zi-ang, tet ten cin gwisi hal ase. Yek laki yek a nima dla̱mti ga̱ɓa mbala̱n mas, na̱ kiɗi na̱ na̱k mili. Ga̱ɓa gwe a na̱ma dla̱mti go yek ɗe ga̱ɓa gwe ma̱n dla̱mti ga̱ɓa ji Nya suk Musa dla̱m ɗe a pi wu, ");
INSERT INTO gyz_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ɗe Almasihu a tla bomti, a tik ɗe ma̱lgwe a lak zhila tlit ɗa̱ka̱ ma̱shka̱n ka ga̱ mbala̱n wu. A tik ka dla̱mi ma̱n Yehuda suk ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ga̱ɓa ma̱n cilti ga̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","A Bulus yima ga̱ɓa ta̱s pol gaa gwas nugo, yek Pestus tlil yal yek ta̱ wulti ɗe, <<Bulus ki wo ma̱n booli ka̱n, yisti wul gwa ɓa lakik gaa me.>> ");
INSERT INTO gyz_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Yek Bulus ballit ɗe, <<Ma̱n nalti Pestus ami wo ma̱n booli ka̱ so, gem ka̱n a nima dla̱mti ka̱ ceti gaa. ");
INSERT INTO gyz_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Guumi yis mas wul jwisi, yek laki yek ba ga̱ɓa sukti ba̱ ɓanti a cin so, na̱k ɗe a yisi ɗe ilgon nit ga̱ hwuda̱li sowu. A ba̱ mas wul jimi pi ga̱ hwuda̱li so. ");
INSERT INTO gyz_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ma̱n nalti guu, ka̱ kan ɗe ga̱ɓa gwe ma̱n dla̱mti ga̱ɓa ji Nya dla̱m go gem ka? A yisi ɗe ka̱ kan na̱k gwisi.>> ");
INSERT INTO gyz_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","A Bulus yima ga̱ɓa nugo yek Agiripa wulti ɗe, <<Ka̱ da̱m gwa we ka man palla̱t gi ɗe Kirista ba̱le-ba̱le na̱k ga̱n ma?>> ");
INSERT INTO gyz_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Yek Bulus ballit ɗe, <<Gon a ɗem'ɗem sogo ba̱le-ba̱le kani, a na̱ma ngemti ga̱ Nya ba̱ ɗe ki, ki na̱ ngwe so ama suk mas jwaka̱n ɗe ka̱ na̱ma kumti gini ase wu. Ta̱k pala̱n na̱k gwe a ni wu, ama ba̱ ɗe na̱k gwe ani ga̱ ɓalti wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Yek guumi tlinya suk gobne suk Bani suk mas ma̱jwe da̱m suksi wu. ");
INSERT INTO gyz_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Yek sa̱ yil ɗa̱ka̱ bal bii kisti ga̱ɓe ka, yek sa̱ ngusi ga̱ɓa suk yilkeni jwasa̱n yek sa̱ wule, <<Ma̱lga̱n go ta̱ pa̱l ilgwe mbuki asa̱ tloti, sogo ilgwe ta̱ lakti ka̱ lu let wu so.>> ");
INSERT INTO gyz_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Yek Agiripa wul Pestus ɗe, <<Ma̱lga̱n a ngemi ɗe ta̱ ta̱la kisti ga̱ɓa gwas a cina ɗa̱ Kaisar ka̱ sogo ma zakti ta̱s zigaa.>> ");
INSERT INTO gyz_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ga̱ɓa dla̱l wi ɗe ta̱n li Italiya wu, yek sa̱ lak Bulus suk ma̱ji le ka̱ jon a ang ɗa̱ bal ma̱n hapti dlo gon gwe a sa mbet ɗe Yuliyos wu. Yuliyosi wo gon ka̱ ma̱n hapti dlo jwe asa̱ pa̱li wul Kaisar bal guu wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Yek ma̱ te ka̱ jirgi ze gwe ya yil tet Adaramitiwus ka̱ ka̱t atl ga̱ Asiya gwe a ngusi dla̱lti ɗa̱n ten ba̱n jwe ni ten tantu wu ka. Yek Aristakus ma̱n Makedoniya gon tet ka̱ ba̱n Tasalonika li sukmi. Yek ma̱ nda za̱tgaa. ");
INSERT INTO gyz_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Lu dlo wugo yek ma te ba̱n Sidon yek ma̱ dla̱l ka̱li. Yek Yuliyos pa̱li zok wul Bulus, ta̱ zakti yek ta̱ li mal yela̱n jwasi, ta̱s ba̱lti wul jwe ta lami wu. ");
INSERT INTO gyz_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tet Sidon go yek ma̱ pal ka̱ jirgi zesi, yek ma̱ zigaa yek ma̱ lak za̱nda̱l ga̱ Kuburus na̱ kaali na̱k ɗe yeta̱l ngusi zhiba̱lti ga̱na̱n tet tucina wu. ");
INSERT INTO gyz_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ma̱ lak dlunti ze ji Silisiya suk Pampiliya na̱ kaal wu, yek ma̱ te ba̱n Mira ka̱ atl ga̱ Likiya yek ma̱ dla̱l ka̱li. ");
INSERT INTO gyz_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","A Mira ka̱n bal ma̱n hapti dlomi mbi jirgi ze gwe yil tet Alekzandiriya yek na̱ma la̱t Italiya wu, yek ta̱ wutni giɓi. ");
INSERT INTO gyz_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Ma̱ ngusi la̱ti ɗem'ɗem yek ma̱ la̱m multi ten tantu a ma̱ na̱ma tlat bomti, yek ma̱ lak mbuki njaa a ba̱n Kinidus. Yek ba̱ yeta̱l zaki ɗe ta̱ jirgi man la̱t tu ka̱ lu gwe ma̱ lami sowu, yek ma̱ li tu ten za̱nda̱l gwe asa̱ mbe ɗe Keriti wu yek ma̱ koɓi njaa a ba̱n Salamoni ta̱ man lakti ga̱ za̱nda̱li na̱ kaali. ");
INSERT INTO gyz_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ma̱ ngusi la̱t na̱ tlat bomti ten tantu gwe koɓi njaa ten bicikɗi ga̱ za̱nda̱li wu. Yek ma̱ lak te lu gwe asa̱ mbe ɗe Zok Lu Hwunti gwe ni njaa mal ba̱n Lasiya wu. ");
INSERT INTO gyz_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ma̱ pa̱l tlal da̱mti ten gaa zesi yek za̱tgami cini ɓanti, na̱k ɗe lulpi ka̱ ɓali a multi jwe a pa̱l ka̱lka̱ze taasti byas wul ka ka̱ ɓallu. Yek Bulus matlsi yek ta̱ wule, ");
INSERT INTO gyz_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","<<Yilkeni jini, kumini, za̱tgaa ga̱na̱n a tulli tlat bomti, a lil wul ka wonti ka̱ jirgi suk jirgi gaa gwasi, hal gon a man tlot mbala̱n.>> ");
INSERT INTO gyz_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ama yek bal ma̱n hapti dlomi nge kumti ga̱ɓa ga̱ Bulus, yek ta̱ kum ga̱ɓa ga̱ ma̱n jirgi suk ma̱n dla̱kti jirgisi. ");
INSERT INTO gyz_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Na̱k ɗe lu dla̱lti jirgi ze ga̱ ba̱mi mbun ɗe ta̱ mbala̱n ci watla̱n kaali sowu, yek ma̱jwe asa̱ pa̱l wul ka̱ jirgi wu wonti lami ɗe ta̱n zigaa, kume ɗe ma̱ mbuki a ba̱n Poniki wu apaa ma̱ ci watla̱n ka̱li. Lu dla̱lti jirgi ga̱ Poniki ka̱ atl ga̱ Keriti wo hwaɓi ka̱n na̱k ɗe lwisi ni ka̱ dlo ga̱ yeta̱l gwe a tli tet tu kudu suk yemma na̱ gwe a tli tet tu arewa suk yemma wu pak. ");
INSERT INTO gyz_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Yeta̱l gwe ba̱ nda̱l sowu nda wulti tet tu kudu wu, yek mbala̱mi da̱m gon asa̱ mbi ilgwe sa̱ lami wu wi. Yek sa̱ pa̱tl yilli wul ga̱lla jwe a laki a jirgi man dla̱lti wu ɗa̱ka̱ atl ka, yek sa̱ ngusi la̱t njaa tu ten bicikɗi ga̱ za̱nda̱l Keriti. ");
INSERT INTO gyz_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Njet nugo, yek duu yeta̱l ma̱n nda̱lti gon gwe asa̱ mbet ɗe, <<Yeta̱l tet dlo ga̱ arewa suk yemma wu.>> yil sut tet ten za̱nda̱l ga̱ Keritisi yek susut ten jirgi yek jek jirgi te ka̱ dlunti zesi ka. ");
INSERT INTO gyz_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Duu yeta̱li laki yek ba̱sa̱ po man ta̱lat ɗa̱ jirgi tu lu gwe sa̱ lami wu so, nuk laki yek sa̱ zak yeta̱li yek ta̱ ngusi jekti gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ma̱ ɓa lak yen za̱nda̱l gwe asa̱ mbe ɗe Kawuda wu na̱ kaal go, yek tolti ga̱ yen jirgi ze tot jirgi zesi bomini gaa i'e. ");
INSERT INTO gyz_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Sa̱ tol yen jirgisi tot ka̱ jirgi wu, yek ka̱a̱ ma̱n dla̱ktisi ɓal jirgi ka na̱ zaa ta̱ ngiɓi ɗa. Ɓanti dla̱lti jirgi ten bal guda̱l yelsi ga̱ Siritis ɓa cisi wu, yek sa̱ wut wul ma̱n diɓa̱lti jwe a lak jirgi ten la̱t ɗem'ɗem su ka̱ zesi ka, yek ma̱ ngusi za̱tgaa nu. ");
INSERT INTO gyz_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Yek yeta̱li ngusi mba̱lti dli kangwe ɗe lu dlo wugo yek sa̱ njel wuti wul jwe ni ka̱ jirgi wu ka ka̱ zesi. ");
INSERT INTO gyz_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ten cin na mekan wo, yek ma̱n dla̱kti jirgi wut wul jekti jirgi jon ka ka̱ zesi na̱ gaa gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Ma̱ mul wi wonti ɗe ma̱ po yima yenti cin sogo kyala̱l sowu, a duu yeta̱li na̱ma wulti wu. Yek ma̱ yilli mbadl ka, ten ɗe mapo mbi kisti so. ");
INSERT INTO gyz_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kaal ɗa̱ la̱t ga̱ tlal multi kuza̱mi, yek Bulus tlinya a cina gwasa̱n yek ta̱ wuli ɗe, <<Yilkeni jini, kaa kuma̱n ga̱ɓa gi go ma zaka̱n za̱nda̱l Keriti so, a ba̱ wunda̱l ga̱ lilti wul suk la̱shi ga̱n a mbinii so. ");
INSERT INTO gyz_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ama ningo a nima ngemti gwaka̱n ɗe, ta̱k dla̱la̱n na̱ nda̱lti, na̱k ɗe ma̱lgon a ma̱sh so, jirgi zesi ka caccalka na̱ ngusi. ");
INSERT INTO gyz_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ahwul ka̱ gas go yen shinti ga̱ Nya gini, Nya gwe a ngusit atl wu su suɗi yek ta̱ dla̱l a mala̱nni. ");
INSERT INTO gyz_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Yek ta̱ wule, <Bulus ba̱ ɓanti cik so. Ka dla̱l a cina ɗa̱ Kaisar bal guu ka asa̱ kisik ga̱ɓa, a Nya pa̱lik hwa wul wi yek ta̱ ba̱lki mas ma̱jwe ka̱ ni suksi wu a ba̱ta zaki ta̱ ma̱lgon ma̱sh ka̱si so.> ");
INSERT INTO gyz_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Yilkeni jini ningo dla̱la̱n na̱ nda̱lti, a nga̱ssa̱n ten Nya ɗe a pi na̱k gwe ta̱ hwi wu. ");
INSERT INTO gyz_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ko ɗe ma la̱n na̱ asa̱n ten za̱nda̱li jon wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ka̱ gas na kutl cet wupsi a duu yeta̱li yima ta̱la̱t ga̱na̱n te ten bal ze gwe asa̱ mbe ɗe Ze Aderiya wu ka̱ dlo gasi. Yek ma̱n dla̱kti jirgi kumi go sa̱ ɓa lam ta̱nti atli. ");
INSERT INTO gyz_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Yek sa̱ cinga̱l zesi na̱ zaa cinga̱lti, yek sa̱ mbi go dlunta̱t gwas wo asa̱mi ɗe 120 ka̱ ɓali. Po la̱m da̱mti njet wu yek sa̱ po cinga̱li ɗa, yek sa̱ mbi go kutl ɗe topsi ka̱ ɓali. ");
INSERT INTO gyz_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ɓanti dutlti ye jwe ni njaa ten bicikɗi ɓa cisi wu, yek sa̱ wut wul ma̱n diɓa̱lti jon ɗe wupsi su ka̱ zesi ka, yek sa̱ ngem nya jwasa̱n ɗe ta̱ lu cil ne. ");
INSERT INTO gyz_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ma̱n dla̱kti jirgisi jon ɓa lam apti ɗa̱ka̱ jirgi ka̱ go yek sa̱ shit yen jirgi ze sut ten bal zesi. Yek sa̱ ngusi pa̱lti wule na̱kka̱n sa wut wul ga̱lla wu ɗe asa̱ dla̱lli jirgi na̱ nali wu tucina. ");
INSERT INTO gyz_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Yek Bulus hwi ma̱n hapti dlomi suk bali gwasa̱n ɗe, <<Ta̱ ma̱jin dla̱l ka̱ jirgi zesi sogo mas jwaka̱n kaa ma̱shi.>> ");
INSERT INTO gyz_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Yek ma̱n hapti dlomi ndoka̱l zaa gwe ngiɓ yen jirgi zesi wu ka yek zaaɓi ndaka. ");
INSERT INTO gyz_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Lu ɓal njaa ta̱ dlo wu yek Bulus ngemsi ta̱s nguk wul ne, yek ta̱ wule, <<Ka̱ multi ɗe kutl cet wupsi jwe nda na̱ kaal go mbadl gwaka̱n hwot ka̱ yek ba̱ka̱a̱ nguk ilgon so. ");
INSERT INTO gyz_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ningo a na̱ma ngemti jwaka̱n ta̱k nguka̱n wul ta̱k da̱ma̱n na̱ mbadl ɗa. Ko ta̱ ma̱dla̱n gaa ɗe na̱m mago a nde gon gwaka̱n ka̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bulus dla̱m nu wu yek ta̱ yem burodi jon yek ta̱ pa̱l hwol tuk na̱ Nya a cina ɗa̱ mas jwasa̱n ka. Yek ta̱ celi yek ta̱ njel ngukti. ");
INSERT INTO gyz_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Yek sa̱ mbi ndalti gaa hwulan mas jwasa̱n, yek sa̱ nguk wul. ");
INSERT INTO gyz_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wonta̱t ga̱na̱n ka̱ jirgi go, mbala̱n ɗe 276 ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Mas jina̱n nguk wul ɗe kumni wu yek sa̱ wut gwe wul gwe ni ka̱ jirgi wu ka ka̱ zesi ba̱ jirgi po diɓa̱l so ɗa. ");
INSERT INTO gyz_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Cin yil wugo yek ba̱sa̱ yis atl gwe ma̱ ɓallu so, ama yek sa̱ yen bicikɗi ma̱n yelsi gon teka, yek sa̱ wule ta̱s jek jirgi te ten dii atl ka ɗe sa mani wu. ");
INSERT INTO gyz_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Yek sa̱ kotl zaa ji wul ma̱n diɓa̱lti gwe a lak jirgi ten la̱t ɗem'ɗem wu ka yek wuli lok su ka̱ zesi ka, yek sa̱ pa̱tl zaa gwe asa̱ ɓal wul balla̱t gaa jirgisi na̱li wu ka, yek sa̱ tlil bal zani gwe ni tu cina ga̱ jirgi wu ka̱ pak. Yek sa̱ zak yeta̱li yek ta̱ jek jirgi te cina tu te ten bicikɗi ka. ");
INSERT INTO gyz_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ama yek jirgi ɓo bal yelsi gon ka̱ lu gwe la̱t ga̱ zesi balla̱t ɗu, yek tu cina ka̱ jirgi ngatl giɓi. Yek tucina ga̱ jirgi lil ka yek ba̱ jirgi po man za̱tgaa so, yek bal kapsi ze laki yek tukaal ga̱ jirgi caccal ka. ");
INSERT INTO gyz_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Yek ma̱n hapti dlomi ɓel bi ɗe ta̱s dlo ma̱ji lesi ka, kangwe ɗe sa man apti ka̱ so kume sa̱ man ze yek sa̱ mbuki ten bicikɗi wu. ");
INSERT INTO gyz_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ama yek bacina ga̱ ma̱n hapti dlomi lam kisti ga̱ Bulus yek ba̱ta̱ zak ma̱n hapti dlomisi ta̱s pa̱l ilgwe sa̱ ɓel bi dani wu so. Yek ta̱ dla̱m ɗe ma̱jwe man ze go ta̱s nda ten zesi cina ta̱s mbuki ten atli. ");
INSERT INTO gyz_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","A naami wo ta̱s kopsi ten wul jirgi zesi suk pukta̱la̱n yencin jwe a man su ga̱s gaa ze sowu. Na̱ nu ka̱n mas jina̱n li ten bicikɗi yek ma̱ mbuki ten dii atli a ba̱ ilgon mbi gon ma̱lgon so. ");
INSERT INTO gyz_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Ma̱ ɓal ten bicikɗi go, yek ma̱ lak yisi ɗe shin ga̱ za̱nda̱l gwe ma̱ni dani wu ka̱ɗe Malita. ");
INSERT INTO gyz_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ma̱n lwisi pa̱lini hwa wul, yek sa̱ hotini wutu na̱k ɗe lu nda̱ɗi ka̱wu a na̱ma ndat ɗu, yek sa wulini ɗem na̱ tulti. ");
INSERT INTO gyz_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Yek Bulus mo yencin yek ta wut ka̱ wutu, yek ɓuɓul gon yil tet ka̱ yencimi ɗe ta̱ kum wuti wu yek ta̱ watl Bulus ten ang. ");
INSERT INTO gyz_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ma̱n lwisi yen wucisi ten ang ga̱ Bulus wu, yek sa̱ ngusi hwiti yilkeni jwasa̱n ɗe, <<Ma̱lga̱n go ma̱n tlot mbala̱n ka̱n, ta̱ ap tet ɗa̱ka̱ bal zesi ka ama yek ba̱ nya asa̱ mbet ɗe Alhaki wu zakti ɗe ta̱s ya da̱m so.>> ");
INSERT INTO gyz_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama yek Bulus tlak wucisi te ka̱ wuti ka, yek ba̱ ilgon mbit so. ");
INSERT INTO gyz_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mbala̱mi da̱m gwa we ta kiɗi ka, sogo ta ma̱shka ninge-ninge, ama yek sa̱ ɓa̱ti i'e yek ba̱sa̱ yen byas ilgon mbit sowu yek sa̱ wule ti wo nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","A lubii jon ga̱ Pubiliyus bacina ga̱ za̱nda̱li njaa ka̱li gwe ma̱ ni wu, Pubiliyusi wuli ni ɗem a boo ɗatka, yek ma̱ mul ɗe mekan ka̱li ata̱ ni nima pa̱lti wul na̱ ta̱mi mbadli. ");
INSERT INTO gyz_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aba ga̱ Pubiliyus ni atl na̱ cwo zazaɓi ata̱ na̱ma tet ze ishi. Yek Bulus sa yenti gwasi, ta̱ ngemit Nya wugo yek ta̱ wut ang tenti yek ta̱ ndoki. ");
INSERT INTO gyz_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Na̱k gwisi pi wu, yek naa mbala̱n ji lwisi jwe cwo na̱ma cit gwasa̱n wu tuli yek sa̱ mbi ndokti. ");
INSERT INTO gyz_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Sa̱ ba̱lni nalti ten wul wonti. Ma̱ ɓa zigaa go yek sa mweni mas wul jwe ma̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Kaal ɗa̱ lip ɗe mekan yek ma̱ pal ten bal ze, yek ma̱ te ka̱ jirgi gwe ci watla̱n ten bicikɗi ga̱ za̱nda̱li wu. Jirgisi ga̱ ba̱n Alekzandiriya, gwe sa̱ tlat gaami na̱k ngusa̱n gunki gwe asa̱ mbe ɗe Kasto suk Poluk wu. ");
INSERT INTO gyz_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Yek ma̱ njel za̱tgaa yek lak te ka̱ ba̱n Sirakus yek ma̱ da̱m ka̱li multi ɗe mekan. ");
INSERT INTO gyz_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tet Sirakus go yek ma̱ zigaa yek ma lak te ba̱n Rigiyum. Lu dlo wugo yek yeta̱l tet tu kudu wuli, yek lu po dlo wugo yek ma̱ mbuk lu a Puteyoli. ");
INSERT INTO gyz_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","A Puteyoli ka̱n ma̱ mbi ma̱n kopti jon jwe mbeni tet malsi ta̱n mulisi ɗe nitgi wu. Yek ma̱ lak li ba̱n Roma. ");
INSERT INTO gyz_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Ma̱n kopti jwe ni ka̱li wu kumi wi ɗe ma̱ni tet wu, yek sa̱ sak mbini ka̱ lu wulti wul gwe ni a Apiyus suk lubii da̱mti ga̱ ma̱nda̱ki gwe mbet ɗe Lu Da̱mti ɗe Mekan wu. Yek Bulus ngem Nya a cina ɗa̱ ma̱jwisi ka yek ta̱ mbi nda̱li gahwula̱n. ");
INSERT INTO gyz_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ma̱ mbuk lu ba̱n Roma wu, yek sa̱ zak Bulus ta̱s pa̱l da̱mti ga̱ gaa gwasi, a ma̱n hapti dlo gon nima za̱t gwel tenti. ");
INSERT INTO gyz_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kaal ɗa̱ multi ɗe mekan yek Bulus mbe bacina ji ma̱n Yehuda ji ba̱n Roma. Sa̱ mogaa wu, yek ta̱ wulsi ɗe, <<Yilkeni jini, a pa̱li byas ilgon mbala̱n jina̱n sogo pa̱lti wul ji aba jina̱n jwe ma̱sh wu so, ama yek mbala̱n jina̱n doɓa̱nni a Wurshelima. Yek sa̱ laka̱n a ang ɗa̱ ma̱n Roma ka. ");
INSERT INTO gyz_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Ma̱n Rome bodla̱la̱nni yek sa̱ lam ɗe ta̱s zakni na̱k ɗe ba̱sa̱ mbi byas ilgon tena̱nni gwe a laki asa̱ dlo wu sowu. ");
INSERT INTO gyz_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama yek bacina jimi nge, yek sa̱ wule ba̱ ma̱n Roma zaka̱n so, yek a ngemi ta̱s ta̱la ga̱ɓe a cina ga̱ Kaisar bal guu. Ba̱ ɗe we byas ilgon ka̱ ni mbadl ten mbala̱n ji so. ");
INSERT INTO gyz_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Yek laki yek a lam yenti gwaka̱n ta ga̱ɓa sukkii. Bi za̱t mbadl ga̱ ma̱n Yisiraila ka̱ laki yek sa̱ ɓala̱n ka na̱ zaa ga̱lla ge.>> ");
INSERT INTO gyz_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Yek sa̱ ballit ɗe, <<Ma mbi lishti gon tet Yehudiya tenki so, a ba̱ ma̱lgon po yil tet ka̱li yek ta̱ hwini byas ilgon tenki so. ");
INSERT INTO gyz_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama ma̱ na̱ma lamti ta̱n kum ilgwe ka̱ yeni wu, na̱k ɗe ma̱ yisi ɗe mbala̱n ko ako na̱ma dla̱mti byas ga̱ɓa ten wunda̱l ji ma̱ju wu.>> ");
INSERT INTO gyz_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Yek sa̱ dla̱lli ga̱ɓa ɗe sa mo suk Bulus gas gon, yek mbala̱n wonti tul malti ka̱ lu gwe ta̱ ni wu ten cin gwe sa̱ zi wu. Tun tet na̱ gasi hal sukti a Bulus nisi ma mbokti ang ten bi ga̱ Nya ɗe guu yek ta̱ dlot ten dla̱mti ga̱ɓa ten Yesu ka̱ mba̱t ga̱ɓa ga̱ Musa suk lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Jon jwasa̱n kan ga̱ɓa gwe Bulus dla̱m wu, yek jon jwasa̱n nge. ");
INSERT INTO gyz_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Sa̱ ngusi dla̱kti ga̱ɓa ka̱ dlo gwasa̱n yek sa̱ lak zigaa, kaal ɗa̱ pakti ga̱ɓa ga̱ Bulus ɗe, <<Shishi ga̱ Nya dla̱mi gem aba jina̱n ɗe ta̱ hwisi tumal Ishaya ma̱n dla̱mti ga̱ Nya wu ɗe, ");
INSERT INTO gyz_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","<Li mal ma̱jin aka̱ wulsi ɗe, <<Ka sa ten kumti ga̱ɓa a ba̱ka yis gaami so, ka sa ten yenti wul a ba̱ka yis wuli so.>> ");
INSERT INTO gyz_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Na̱k ɗe mba̱tl ji ma̱jin ka̱nga̱l ka̱wu, a ba̱ ka̱ng gwasa̱n kum ga̱ɓa sowu, asa̱ le gwel gwasa̱n ka̱wi. Sa lak man yenti wul na̱ gwel gwasa̱n sogo sa lak kum ga̱ɓa na̱ ka̱ng gwasa̱n asa̱ yis gaami ka̱ mbadl gwasa̱n asa̱ balla̱si teɗi apaa a ndoksi ɗa wu.> ");
INSERT INTO gyz_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","<<A na̱ma lamti ta̱k yisi ɗe Nya ba̱l kisti ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu wi, a sa kat ka̱ng!>> ");
INSERT INTO gyz_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Bulus da̱m ka̱li gin ɗe lop ka̱ lubii gwe ta̱ ɓatl wulpi da̱mti giɓi wu, ata̱ nima wulti ɗem ma̱jwe asa̱ tuli yenti gwas wu. ");
INSERT INTO gyz_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Yek Bulus ngusi dla̱mti ga̱ɓa ten bi ga̱ Nya ɗe guu ata̱ nima mbokti ang mbala̱n ten Almasihu Yesu Bagaa na̱ nda̱li gahwula̱n, a ba̱ ma̱lgon ngwe ta̱s dla̱lla̱t ka̱ so.");
INSERT INTO gyz_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Lishti ga̱n go tet mal ami Bulus zhel ga̱ Yesu Almasihu ɗe sa̱ mbe ɗe ta da̱m ɗe yen shinti ga̱ Yesu, yek sa̱ za̱n ka ten ɗe ta lak icin ten ga̱ɓa ma̱n ta̱mti ga̱ Nya wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Ga̱mi ka̱ɗe ga̱ɓa ma̱n ta̱mti gwe Nya pi alkawol gwas tun tek ka tumal ma̱n dla̱mti ga̱ɓa jwas wu, na̱k kangwe sa̱ lishi ka̱ ga̱ɓa gwas ma̱n cilti wu. ");
INSERT INTO gyz_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Ga̱ɓa ma̱n ta̱mti gwisi wo ten bi ga̱ Yen gwas ka̱n, ma̱lgwe ka̱ da̱mti gwas ɗe mbala̱n wo ma̱n ga̱s ga̱ Dauda ka̱ ɗe ti wu, ");
INSERT INTO gyz_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ama ten bi za̱t gwas ka ɗe sa̱ za̱t ka ka̱ Shishi suk iko go gem ti wo Yen ga̱ Nya ka̱n, tumal tlit gwas tot ɗa̱ka̱ ma̱shka̱n ka. Gem Yesu Almasihu wo Bagaa ga̱na̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Tumal Yesu Amasihu suk ten ɗe ta̱ shin gwas mbi nalti ɗa ka̱n a mbi alheri suk mbeti ten ta da̱mti ɗe yen shinti ga̱ Yesu, ten ɗe ta mbe ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu tet ka̱ mas ba̱n ta̱s ba̱l gem asa̱ kumit bi. ");
INSERT INTO gyz_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","A kii mago ka̱a̱ ni giɓi, kii ɗe Nya mbekii yek ka̱a̱ da̱m ɗe mbala̱n ji Yesu Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Mas jwaka̱n ɗe ka̱a̱ ni ka̱ ba̱n Roma wu, kii mbala̱n jwe Nya lamsi yek ta̱ mbekii ten ɗe ta̱k da̱ma̱n ɗe mbala̱n jwas wu, Ha̱n ta̱ alheri suk multi mbadl sut mal Nya Buka ga̱na̱n, suk Bagaa Yesu Almasihu da̱m ɗe gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ten ndat zhile wo api godiya Nya gini tumal Yesu Almasihu ten bi ga̱ mas jwaka̱n, ten ɗe sa̱ na̱ma dla̱mti ga̱ɓa ten bi nga̱sti ten Nya gwaka̱n ko ako ten dii atli. ");
INSERT INTO gyz_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Nya gwe a nitma pa̱lti wul na̱ mas mbadl gini tumal lakti icin ten ga̱ɓa ma̱n ta̱mti ga̱ Yen gwas wu ka̱ ɗe sheda gini ten ɗe a na̱ma daamti gwaka̱n, ");
INSERT INTO gyz_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","dlip ka̱ sa'i gwe a ɓa gem Nya wu. A na̱ma gemti ga̱ Nya ɗe, ɗe kume ta̱mit ɗa̱ go, kota̱ na̱k gwik-gwi ta mbi la̱t malkii ne. ");
INSERT INTO gyz_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","A na̱ma lamti yenti gwaka̱n ten ɗe ta ba̱lkii ilgon ga̱ Shishi ga̱ Nya ilgwe a nda̱llikii gahwula̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","lamti gi wo yek ɗe, ta̱n nda̱lli gahwula̱n yilkeni na̱ ami sukkii, ten ɗe ta nda̱llikii gahwula̱n na̱ nga̱sti ten Nya gini kii mago aka̱a̱ nda̱lli gahwula̱n na̱ nga̱sti ten Nya gwaka̱n pak. ");
INSERT INTO gyz_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Yilkeni jini a na̱ma lamti ta̱k yisi ɗe a pi shiri la̱t malkii asa̱mi wonti, ama hal ninge yek ba̱sa̱ ɓo zaka̱n ɗe ta tul so. Ilgwe a laka̱n ten tulti go yek ɗe ta lak icin ten ga̱ɓa ma̱n ta̱mti ka̱ dlo gwaka̱n a mbala̱n ba̱l gem na̱k kangwe a pa̱li ka̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Diɓa̱lti ga̱ wonti mbala̱n ni gaa, diɓa̱lti ga̱ ma̱n ba̱n suk ma̱n ga̱ me, ga̱ ma̱jwe man lishti wu suk ma̱jwe sa̱ mani sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Yek laki yek a lak ka̱ mbadl gi ɗe kii mago ta dla̱mikii ga̱ɓa ma̱n ta̱mti kii ɗe ka̱ ni ka̱ ba̱n Roma wu. ");
INSERT INTO gyz_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Ga̱ɓa ma̱n ta̱mti ga̱n go ɗe wul nsha ka̱n ni a malla̱n so, ten ɗe yek ɗe iko ga̱ Nya gwe a ta̱la mas ma̱lgwe ba̱l gem wu ten mbit kisti, nde na̱ ma̱n Yehuda yek paa ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Ten ɗe tumal ga̱ɓa ma̱n ta̱mti ga̱mi ka̱ mbok ang ten pa̱lti wul ndakce gwe yil sut mal Nya wu, a mbala̱n mbi pa̱lti wul ndakce gwisi tumal ba̱lti gem tet ten ndat zhile hal a la pakti. Na̱k kangwe ni ga̱ lishi ka̱ gaɓa ga̱ Nya wu ɗe, <<Ma̱n pa̱lti wul ndakce wo tumal nga̱sti ten Nya ka̱n ta da̱mi.>> ");
INSERT INTO gyz_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Ten ɗe sa̱ na̱ma mbokti ang ten kangwe Nya sut nya a nol mbala̱n ka̱ lilti mbadl gwas ten bi la̱shi ɓanti ga̱ Nya suk byas pa̱lti wul ga̱ ma̱jwe ɗe asa̱ kup gem ka tumal yokit gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ten ɗe ilgwe a mbala̱n man yisti ten Nya go ten dii ka̱n ni a malsi, na̱k ɗe Nya mbokisi ang dani wu. ");
INSERT INTO gyz_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Pa̱lti wul ga̱ Nya suk iko gwas ma̱n la̱shi pakti wo wul jwe asa̱ man yenti na̱ gwel wu ka̱ so. Ama tun tet ten pa̱lti ga̱ dii atl ka̱n Nya mboki ang mbala̱n dani ten dii yek sa̱ yis gaa gwasa̱n tumal wul jwe Nyami pa̱lsi wu, kangwe ɗe mbala̱n a mbi ilga̱ dla̱mi sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ten ɗe ko ɗe sa̱ yis Nya wu, ama mas na̱ nu a ba̱sa ba̱lti nalti ten nalti gwas ɗe Nya so, a ba̱sa pit godiya so. Ka̱ lal ga̱ pa̱lti na̱k gwisi wo yek daamti wul gwasa̱n da̱m ɗe daamti wul ga̱ ten koo lu, yek mbadl gwasa̱n gwe ɗe ba̱ a daamti sowu njika̱n ka na̱ da̱mshal. ");
INSERT INTO gyz_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Ko ɗe sa̱ dla̱m ɗe ma̱n ɓotlka̱n yisti wul ka̱ ɗe si wu, ama si wo ka̱dla̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Yek sa̱ balli nalti ga̱ Nya gwe ba̱ta ma̱sh sowu suk ga̱ gunki ma̱n tet ɗa̱ mbala̱n suk ga̱ gunki ma̱n tet ji yadli, suk dabbobi suk dingi ji wul ma̱n la̱t na̱ ze tuki. ");
INSERT INTO gyz_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ten na̱k gwisi ka̱n yek Nya laksi ka yek sa̱ pita lamti pa̱lti byas wul jwe ni ka̱ mbadl jwasa̱n wu yek sa̱ ngusi pa̱lti wul nsha suk yilkeni jwasa̱n na̱ dli jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Sa̱ palli gem ga̱ Nya ɗe lal wi. Sa̱ nima ngusti alt wul jwe Nya pa̱lsi wu hal asa̱ pa̱lisi wul ka̱ lal ga̱ Ma̱n Pa̱lti Wuli gaa gwasi, ti ɗe ta̱ mbuki ta̱ mbala̱n ta̱sti dlip wu. Amin. ");
INSERT INTO gyz_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Ten na̱k gwisi ka̱n yek Nya laksi ka yek sa̱ pita lamti palti byas wul nsha. Yek modli jwasa̱n zak multi suk maani yek sa̱ njel multi suk yilkeni jwasa̱n modli kangwe ba̱ mbun ɗe ta̱ pa̱li wu sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nu ka̱ pak ɗe byas lamti ga̱ yilkeni jwasa̱n man ngetl gwasa̱n wugo, yek maani zak multi suk modli na̱k kangwe Nya pa̱li ɗe ta̱ ni wu. A ba maani suk ba maani ngusi pa̱lti wul nsha ka̱ dlo jwasa̱n, na̱ nuka̱n sa̱ dla̱ki gaa gwasa̱n nolti gwe ni ndakce suk byas pa̱lti wul gwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Na̱k ɗe sa̱ nge da̱mti na̱ yisti ga̱ Nya wu, yek ta̱ laksi ka ten daamti wul ga̱ ten koo lu ten ɗe ta̱s ngusi pa̱ti ilgwe ba̱ mbun ɗe ta̱s pa̱li sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Sa̱ njika̱n na̱ mas wunda̱l ga̱ wul gwe ba̱ yek sowu, suk ngalci, suk kotgwel, suk nget hwullan ga̱ yilkeni. Sa̱ ni ga̱ njika̱mi na̱ daka̱lti suk tlot mbala̱n suk dlanti suk shelti mbala̱n suk duu tuki. Si wo ma̱n wulti yilkeni ka̱n, ");
INSERT INTO gyz_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","man lilti shin mbala̱n ka, ma̱n dlanti suk Nya, ma̱n byalti mbala̱n, ma̱n tlilti gaa nya, ma̱jwe asa̱ ta̱s gaa gwasa̱n wu, ma̱n ɓelti bi ten ngalci, ma̱jwe ba̱sa kumi bi ma̱n za̱t gwasa̱n sowu. ");
INSERT INTO gyz_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Si wo mbala̱n ji ten koo lu ka̱n, ma̱jwe ba̱sa njika̱n alkawol sowu, ma̱n la̱shi lamti suk man la̱shi yenti gonti. ");
INSERT INTO gyz_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Sa̱ yis mba̱t ga̱ Nya ɗe mas ma̱jwe asa̱ pa̱l wunda̱l ga̱ pa̱t jin jo sa̱ ndal ma̱shka̱n, ama ba̱ɗe we pa̱lti ka̱n asa̱ pa̱l wul jimi tokte so, hal asa̱ pi kaal ma̱jwe sa̱ na̱ma pa̱lti nu wu pak. ");
INSERT INTO gyz_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ten na̱k gwisi ka̱n ki ɗe ka kisi ga̱ɓa yilka gwa go, ga̱ɓa nik bi so kota̱ wok ɗe ki wo. Na̱k ɗe sa'i gwe ka̱ nima kisti ga̱ɓa ma̱lgon wu, ka̱ nima kisti ga̱ɓa gaa gwa, ten ɗe byas wul gwe ka̱ na̱ma yenti ga̱ ma̱lgon ten pa̱lti wu yekka̱n ki ma̱go ka̱ na̱ma pa̱lti. ");
INSERT INTO gyz_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ma̱ yisi ɗe kisti ga̱ɓa ga̱ Nya ten ma̱jwe asa̱ pa̱l wunda̱l ji wul jin jo ndakce ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ki mbala̱n! Yekgu ki na̱ gaa gwa ka̱ na̱ma pa̱lti byas wul jimi ɗe ka̱ na̱ma yenti ga̱ ma̱lgon na̱ nali wu! Ka̱ da̱ma̱n gwe we ka ɗakci nolti ga̱ Nya wu nwa? ");
INSERT INTO gyz_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ko na̱kka̱n ka̱ na̱ma mbulti nalti ga̱ alheri ga̱ Nya suk dlot mbadli suk lashi lilti mbadl ba̱le-ba̱le gwe ata̱ pa̱lik wu ka̱n? Ko na̱kka̱n ka̱ yisi ɗe alheri gwe Nya nik ma pa̱lti go ten ɗe ta̱k ci atlgaa ka̱ sa? ");
INSERT INTO gyz_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ama la̱shi kumti bi suk ka̱nga̱lti ga̱ mbadl gwe ka̱ na̱ma pa̱lti wu, yek ka̱ nima mwet gaa gwa nolti gwe na̱ma ɓa̱tti gwa ten cin lilti mbadl ga̱ Nya, ka̱ sa'i gwisi ka̱n sa mbok ang ten nolti ga̱ Nya ɗe ni ndakce wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Nya a palli ko wokko ami ndakce na̱ pa̱lti wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ama mas na̱ nu, ma̱jwe sa̱ na̱ma ngot nalti suk da̱mti ɗe kiɗi suk mbadl gwe ba̱ a paki sowu wu niɗa. Sik ɗe ma̱jwe sa̱ dlosi ten pa̱lti wul ga̱ alheri ka̱ dlot mbadli a si ka̱n Nya a ɓatlsi na̱ mbadl ma̱n la̱shi pakti wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ama ka̱ ma̱n lamti gaa, suk ma̱jwe asa̱ nge gem asa̱ pa̱l ngalci wu sa pallisi ami na̱ lilti mbadli suk duu tuki. ");
INSERT INTO gyz_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Bomti suk citi ka̱ dli ka̱ na̱ma ɓa̱tti ga̱ mas ma̱n ngalci, ndati ten ma̱n Yehuda yek paa ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ama mas ma̱n pa̱lti hwa wul wo ta mbi nalti suk da̱mti ɗe bali suk ta̱mi mbadli, ndati ten ma̱n Yehuda yek pa ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Ten ɗe Nya wo ma̱n lamti ga̱ mbala̱n jon ata̱ nge mbala̱mi jon ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Mas ma̱jwe sa̱ pa̱l byas wul a ba̱sa̱ yis mba̱t ga̱ɓa ga̱ Musa sowu, sa lilsi ka ko ɗe sa̱ yis mba̱t ga̱ɓe sowu, ama ma̱jwe sa̱ yis mba̱t ga̱ɓa yek sa̱ pa̱l byas wul go sa lilsi ka na̱k kangwe mba̱t ga̱ɓe dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ten ɗe ba̱ɗe we katti ka̱ng wul jwe mba̱t ga̱ɓe dla̱m wu tokte ka̱ɗe ma̱n lakti a mbala̱n da̱m ɗe ma̱n pa̱lti wul ndakce mal Nya so, ama kumti bi wul jwe mba̱t ga̱ɓe dla̱m wu ka̱ɗe ilgwe laki asa̱ mbe mbala̱n ɗe ma̱n pa̱lti wul ndakce wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu go mba̱t ga̱ɓa ga̱ Musa nisi ɗa̱ so. Ama ka̱ sa'i gon wo asa̱ pa̱l ilgwe mba̱t ga̱ɓe dla̱m wu tu ten pa̱lti ilgwe mbadl gwasa̱n ba̱lsi wu. Ashe, ma̱n la̱shi mba̱t ga̱ɓe mago mba̱ti nisi ɗa̱ pak. ");
INSERT INTO gyz_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Pa̱lti wul jwasa̱n mbok ang ɗe wul jwe mba̱t ga̱ɓe dla̱m ɗe ta̱ pa̱li wu ni ga̱ lishi ka̱ mbadl jwasa̱n. Ten ɗe daamti ga̱ mbadl gwasa̱n mbokisi ang ten na̱k gwisi, na̱k ɗe a daamti gwasa̱n mbokisi ang ɗe sa̱ byas wul ka̱ sa'i gon, a ka̱ sa'isi gon wo ba̱ a mbokisi ang ɗe sa̱ byas wul sowu. ");
INSERT INTO gyz_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ten na̱k gwisi ka̱n, na̱k kangwe ta̱mi ga̱ɓa ga̱n ɗe a na̱ma lakti icin dani dla̱m wu, nu ka̱n a pi ten cin gwe Nya a pa̱l kisti ga̱ɓa ten mas wul jwe ni ga̱ hwuda̱li ka̱ daamti ga̱ mbadl ga̱ mbala̱n tumal Yesu Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","To, ki ɗe aka̱ mbe gaa gwa ɗe ma̱n Yehuda wu pa? Ka̱ na̱ma nga̱sti gwa ten Mba̱t Ga̱ɓa ga̱ Musa aka̱ na̱ma ɓot ngetl gwa ten ɗe ki wo ka̱ni nja mal Nya, ");
INSERT INTO gyz_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ka̱ na̱ma wulti ɗe ka̱ yis ilgwe Nya lami wu, aka̱ yisti gaa ga̱ ilgwe Mba̱t Ga̱ɓa ga̱ Musa dla̱mi ten bi kangwe ka ɓotl ilgwe ni ndakce wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ki gaa gwa wo ka̱ ba̱l gem ɗe ki wo ma̱lgwe ata̱ nde dwa cina wu ka̱n, a ki wo cilti ka̱n mal ma̱jwe sa̱ni ka̱ da̱mshal wu, ");
INSERT INTO gyz_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ma̱lgwe nima mbokti ka̱dla̱n ang ten wul wu, suk ma̱n lishti ga̱ ma̱jwe daamti gwasa̱n wo na̱k ga̱ mil mbala̱n ka̱n ni wu. Ten ɗe gem ka̱ yisi ɗe ka̱ mba̱t ga̱ɓa ga̱ Musa ka̱n ka̱ mbi mas yisti suk gem. ");
INSERT INTO gyz_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","To, ki ɗe ka̱ nima mbokti ang ten wul naa mbala̱n wu, mboki ang gaa gwa dani la! Ki ɗe aka̱ mboki ang mbala̱n ɗe ba̱s pi muka̱l sowu, ki gaa gwa wo ka̱ pi muka̱l sa a? ");
INSERT INTO gyz_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ki ma̱n wulti ɗe ba̱ mbala̱n pi pa̱la̱n sowu, ki gaa gwa wo ka̱ pa̱n pa̱la̱n sa a? Ki ɗe ka̱ palli gunki ɗe wul cit daɗe go, ka̱ muka̱l wul tet ka̱ bii gunki sa a? ");
INSERT INTO gyz_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ki ma̱n ɓot ngetl na̱ mba̱t ga̱ɓa ga̱ Musa, ka̱ na̱mma lilti shin ga̱ Nya ka tumal celti mba̱ti sa a? ");
INSERT INTO gyz_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ai, sa̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <<Ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu sa̱ na̱ma dla̱mti ga̱ɓa mbul shin ga̱ Nya ka̱ dlo gwasa̱n ten bi gwaka̱n kii ma̱n Yehuda.>> ");
INSERT INTO gyz_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Ɗe kume ka̱ na̱ma kopti mba̱t ga̱ɓa ga̱ Musa go, sa̱lti gwe sa̱ pa̱lik wu pa̱lik ampani wi. Ama kume ka̱ na̱ma kopti mba̱t ga̱ɓa ga̱ Musa sogo sa̱lti gwa wo ten ko lu, ka̱n na̱k wule sa̱ sa̱la̱nki so. ");
INSERT INTO gyz_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Ɗe kume ma̱jwe ba̱sa̱ ɓo sa̱lsi sowu na̱ma pa̱lti ilgwe mba̱t ga̱ɓa ga̱ Musa dla̱m wugo, aba̱ Nya a kansi na̱k ma̱jwe sa̱ sa̱lsi wu so nwa? ");
INSERT INTO gyz_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ma̱jwe sa̱ pa̱lisi sa̱lti ga̱ dli so ama asa̱ kop ilgwe mba̱t ga̱ɓa ga̱ Musa dla̱m ɗe ta̱ pa̱li wu a kisik ga̱ɓa, ki ɗe mba̱t ga̱ɓa ga̱ Musa nik ɗa ga̱ lishi asa̱ sa̱lki wi, ama aka̱ cel mba̱t ga̱ɓe ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ten ɗe mbala̱n a man yisti ga̱ ma̱n Yehuda ga̱ gem tumal ilgwe ata̱ yeni a deɓal wu so, a nu ka̱n sa̱lti ga̱ gem wo ba̱ mbala̱n a yeni na̱ gwel so. ");
INSERT INTO gyz_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ka̱ lal ka̱ na̱k gwisi ma̱n Yehuda ga̱ gem wo tik ɗe ma̱n Yehuda ka̱ mbadli, a sa̱lti ga̱ gem wo yek ɗe sa̱lti ga̱ mbadli, ilgwe Shishi ga̱ Nya ka̱ɗe ma̱n pa̱lti wu ba̱ ɗe we tumal mba̱t ga̱ɓa gwe sa̱ lishi wu so. Wunda̱l ga̱ ma̱lgwisi wo Nya ka̱ɗe ma̱n ta̱sti gwasi ba̱ɗe yen ga̱ mbala̱n so. ");
INSERT INTO gyz_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","To, yek ndat gwa ɗe ma̱n Yahuda a mba̱lik ye? Yek ɗe riba ga̱ sa̱lti gwa ye? ");
INSERT INTO gyz_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Yii, a mba̱lik wul tu ten mas tantu ci! Ta̱ nda dla̱mti wo, Nya ba̱l ma̱n Yehuda ngipti ga̱ɓa gwasi. ");
INSERT INTO gyz_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Ama ɗe kume ma̱n Yahude jon nga̱ssi ten ga̱ɓe sowu pa, la̱shi nga̱sti ten ga̱ɓa gwasa̱mi a laki a Nya da̱m ɗe ma̱n la̱shi pa̱lti gem ma? ");
INSERT INTO gyz_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ko njaa! Nuk'ni so! Nya wo ma̱n gem ka̱n, kota̱ ni ɗe mas mbala̱n wo ma̱n shelti lal ka̱n. Na̱k kangwe ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya wu ɗe, <<Ga̱ɓa gwa wo gem ka̱n ko a gasi a kota̱ a cina ga̱ guu mago ma̱n gem ka̱ɗe ki.>> ");
INSERT INTO gyz_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","To, ɗe kume la̱shi pa̱lti wul ndakce ga̱na̱n da̱m ɗe tantu mbokti ang ten pa̱lti wul ndakce ga̱ Nya go, yek ma̱ dla̱ma̱n ye? Ma dla̱ma̱n ɗe Nya wo ma̱n la̱shi pa̱lti wul ndakce ka̱n ten ɗe ta̱ nola̱nni nwa? A na̱ma ga̱ɓa ga̱n ka̱ da̱mti gi ɗe mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Wowo! Ko njaa! Kume ɗe nu ka̱n ni go, ɗa̱ni ka̱n Nya a pa̱li kisti ga̱ɓa dii atl gwi? ");
INSERT INTO gyz_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Kume ɗe la̱shi gem gi laki yek gem ga̱ Nya yil ten dii i'e, yek po laki yek sa̱ mba̱l nalla̱t ga̱ Nya go, to, yek laki ɗe sa nola̱n ten ɗe ma̱n pa̱lti byas wul ka̱ɗe ami ye? ");
INSERT INTO gyz_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ɗe kume nu ka̱wu yek laki ɗe ba̱ma pa̱nta ngalci ten ɗe ta̱ da̱m ɗe hwa wul so ye? Ma̱jon ma̱n dla̱mti ga̱ɓa lilti shin ga̱na̱n ka na̱ma wulti ɗe we nuka̱n ma̱ na̱mma dla̱mti. Sa nol ma̱jwisi na̱k kangwe mbun ɗe ta̱ nolsi wu. ");
INSERT INTO gyz_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","To, ningo yek ɗe pakti ga̱ ga̱ɓa ga̱n ye? Ten ɗe mi ma̱n Yehuda wo ma̱ mana̱n naa mbala̱n ma? Wowo! Ko njet! Ma̱ mboka̱n ang dani tet wi ɗe na̱ ma̱n Yehuda na̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu mas sa̱ pa̱l byas wul a mas jwasa̱n sa̱ ni a atl ɗa̱ iko ga̱ byas wul. ");
INSERT INTO gyz_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Na̱k kangwe ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya wu ɗe, <<Ma̱n pa̱lti wul ndakce ni ɗa̱ so ko ta̱ ɗe na̱m mago ni ɗa̱ so. ");
INSERT INTO gyz_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ma̱n yis gaa ga̱ wul ni ɗa̱ so, aba̱ ma̱lgon nima ngot ga̱ Nya so. ");
INSERT INTO gyz_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Mas jwasa̱n sa̱ balli tukaal Nya wi, sa̱ lil ka̱ wi mas jwasa̱n, ko ma̱n pa̱lti wul ndakce ni ka̱si so, ɗe na̱m mago ni ɗa̱ so.>> ");
INSERT INTO gyz_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","<<Shukalyal gwasa̱n wo na̱k gazukɗi gwe ni ga̱ ɓuli wu ka̱n ni, La̱ka jwasa̱n pal ɗe wul shelti mbala̱n wi.>> <<Ga̱ɓa jwasa̱n wo na̱k dapi cila̱kmba̱l ka̱n ni.>> ");
INSERT INTO gyz_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","<<Bi jwasa̱n wo ga̱ njikmi ka̱n ni na̱ ga̱ɓa pa̱lti bi gaa mbala̱n suk byas ga̱ɓa.>> ");
INSERT INTO gyz_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","<<A asa̱n gwasa̱n la shotti hwulan ga̱ mbala̱n ɓaa-ɓaa, ");
INSERT INTO gyz_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","a tlot mbala̱n suk duu tuk kop kaal gwasa̱n mas lu gwe sa̱ li wu. ");
INSERT INTO gyz_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","A ba̱sa̱ yis tantu ga̱ lu gwe ta̱mi mbadl ni wu so.>> ");
INSERT INTO gyz_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","<<A ba̱ ɓanti ga̱ Nya nisi gwel so.>> ");
INSERT INTO gyz_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Mi dai ma̱ yisi wi ɗe mas ilgwe mba̱t ga̱ɓa ga̱ Musa dla̱m go, ma̱jwe sa̱ni ga̱z ga̱ mba̱ti wu ka̱n mba̱ti dla̱misi. Gwisi pi nu ka̱n ten ɗe ba̱ ma̱lgon mbi ilga̱ ga̱ dla̱mi so, a ta̱s mbok ang ɗe mas dii atl ni ga̱z ga̱ nolti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Na̱k ɗe ba ma̱lgwe a da̱m ɗe ma̱n la̱shi pa̱lti byas wul mal Nya tumal kopti ilgwe mba̱t ga̱ɓe dla̱m wu. Ilgwe a mba̱t ga̱ɓe pa̱li go yek ɗe a mboki ang mbala̱n ten byas wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ama ningo sa̱ mbok ang ten zobsi tantu da̱mti ɗe ma̱n pa̱lti wul ndakce mal Nya wi. A ba̱ tumal kopti mba̱t ga̱ɓa ga̱ Musa ka̱n a mbala̱n da̱m ɗe ma̱n pa̱lti wul ndakce ga̱mi so, ko ɗe mba̱t ga̱ɓa ga̱ Musa suk lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya ba̱l sheda tenti wu. ");
INSERT INTO gyz_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Da̱mti ɗe ma̱n pa̱lti wul ndakce ga̱mi ɗe sut mal Nya ka̱n ni go, tumal nga̱sti ten Yesu Almasihu ka̱n a mbala̱n mbi, Nya ba̱l pa̱lti wul ndakce ga̱mi mas ma̱jwe sa̱ nga̱ssi tenti wu. Nya lam ma̱jon yek ta̱ nge ma̱jon so, ");
INSERT INTO gyz_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ten ɗe ko wokko pa̱l byas wul yek ba̱ ma̱lgon mbuk mbit nalti ga̱ Nya so. ");
INSERT INTO gyz_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Ama tumal alheri gwe Nya pa̱li mas mbala̱n ten koo lu wu, yek ko wokko mbi da̱mti ɗe ma̱n la̱shi byas wul a cina ɗa̱ Nya ka tumal ɓatlti gwe Almasihu Yesu ɓatl wul tena̱nni wu. ");
INSERT INTO gyz_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Ten ɗe Nya tak Yesu ta̱s da̱m ɗe sadaka gwe kan diɓa̱lti ga̱ byas wul jina̱n ka̱ wu, ten ɗe sa taasi mbala̱n batlti nolti ga̱ byas wul gwasa̱n ka, tumal hwulan sadaka gwe shot wu ɗe kume sa̱ nga̱sti ten Nya wu. Nya pa̱li na̱k gwisi ka̱n ten ɗe ta̱s mbok ang ten pa̱lti wul ndakce gwasi, na̱k ɗe ta̱ dlo bi na̱ mbala̱n yek ta̱ kan gwel ɗa̱ ten byas wul jwe sa̱ pa̱li tet wu ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Tu ten nu ka̱n Nya mbok ang ten pa̱lti wul ndakce gwasi ka sa'i ga̱n, ten ɗe ti gaa gwas wo byas wul nit ɗa̱ so, ata lak mas ma̱n nga̱sti ten Yesu ten da̱mti ɗe ma̱n la̱shi byas wul a cina ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","To, na̱ yek ma ɓo ngetl ye? Ai wul ɓot ngetl wo nini ɗa̱ so! Tu ten yek sa̱ kamini ilgwe ma ɓo ngetl ɗa̱ wu ka̱ ye? Tumal kopti mba̱t ga̱ɓa ga̱ Musa ka̱n sa̱ kamini ka̱ nwa? Wowo, seko tumal nga̱sti ten Nya. ");
INSERT INTO gyz_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ten ɗe ma̱ yeni ɗe tumal nga̱sti ten Nya ka̱n a mbala̱n da̱m ɗe ma̱n la̱shi byas wul a cina ga̱ Nya, ba̱ ɗe tumal kopti mba̱t ga̱ɓa ga̱ Musa so. ");
INSERT INTO gyz_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ko Nya wo Nya ga̱ ma̱n Yehuda ka̱n si na̱ ngusa̱n? Ashe, ti wo Nya ga̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ka̱ pak sa? Yii, ti wo Nya ga̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ka̱ pak, ");
INSERT INTO gyz_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","na̱k ɗe Nya wo ɗe na̱m ka̱wu. A ta laki a ma̱n sa̱lti da̱m ɗe ma̱n la̱shi byas wul malti tumal nga̱sti ten Nya, a na̱k gwisi ka̱n ma̱n la̱shi sa̱lti a mbi da̱mti ɗe ma̱n la̱shi byas wul tumal nga̱sti ten Nya pak. ");
INSERT INTO gyz_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ɓohwe, ma palla̱n mba̱t ga̱ɓa ga̱ Musa ɗe wul ga̱ ten koo lu wi ten bi ga̱ nga̱sti ten Nya nwa? Ko njet! Ka̱ lal ga̱ nu wo kopti kaal ga̱ mba̱ti ka̱n ma̱ na̱ma kopti. ");
INSERT INTO gyz_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","To, yek ma dla̱ma̱n ten Iba̱rahim, aba ga̱ aba ga̱ ma̱n za̱t jina̱n ye? Yek ɗe ilgwe ta̱ yis gaami ten bi nga̱sti ten Nya wu ye? ");
INSERT INTO gyz_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Ɗe kume Iba̱rahim mbi da̱mti ɗe ma̱n la̱shi byas wul a cina ɗa̱ Nya ka tumal pa̱lti wul gwas ka̱go, ashe ilgwe ta ɓo ngetl na̱ nali wu niti ɗa, ama ba̱ ɗe we a cina ga̱ Nya so. ");
INSERT INTO gyz_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <<Ten ɗe Iba̱ra̱him nga̱sti ten Nya yek Nyami dla̱mit pa̱lti na̱k gwisi ɗe pa̱lti wul ndakce.>> ");
INSERT INTO gyz_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Ma̱lgwe nima pa̱lti wul ten ɗe ta̱s mbi ɓalti go, ilgwe sa̱ ba̱lti go ten koo lu ka̱n ni so, ɓatlti ga̱ ilgwe ta̱ pa̱li wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","To, ma̱lgwe ba̱ta̱ nga̱sti ten pa̱lti wul gwas so, ama yek ta̱ nga̱sti ten Nya ti ɗe ata̱ palli ma̱n la̱shi pa̱t ji Nya ɗe ma̱n la̱shi byas wul a cina gwas wu, asa̱ kan nga̱sti ten Nya ga̱ ma̱li ɗe pa̱lti wul ndakce gwasi. ");
INSERT INTO gyz_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Gwisi ka̱ɗe ilgwe Dauda na̱ma mbokti ang dani wu ɗe ta̱ ga̱ɓa ten bi albarka gwe sa̱ laki ma̱lgwe Nya mbet ɗe ma̱n pa̱lti wul ndakce wu, ba̱ɗe tu ten pa̱lti wul gwe ma̱li pa̱li wu so, ɗe ta̱ wule, ");
INSERT INTO gyz_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","<<Ma̱n albarka ka̱ɗe ma̱jwe sa̱ polisi da̱ska̱n jwasa̱n ka̱wu, ma̱jwe sa̱ taasisi byas wul jwasa̱n ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ma̱n albarka ka̱ɗe ma̱lgwe Bagaa dla̱mit byas wul jwas gaa sowu.>> ");
INSERT INTO gyz_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Ɓohwe, albarka ga̱mi wo ma̱jwe sa̱ sa̱lsi wu ka̱n sa lakisi si na̱ ngusa̱n ma ko suk ma̱jwe ba̱sa̱ sa̱lsi sowu pak? Ai ilgwe ama̱ dla̱ma̱n tet ka̱ lishti ga̱ɓa ga̱ Nya wu ɗe wule, Iba̱ra̱him ka̱n sa̱ dla̱mit nga̱sti ten Nya gwas ɗe pa̱lti wul ndakce. ");
INSERT INTO gyz_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","To, ka̱ sa'i gwi ka̱n asa̱ mbet ɗe ma̱n pa̱lti wul ndakce gwi? Ka̱ sa'i gwe sa̱ sa̱lti wu gwa, ko tun a ba̱sa̱ ɓo sa̱lti so? Ai, tun a ba̱sa̱ ɓo sa̱lti so ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ama ɗe ta̱ kan lal ga̱ sa̱lti wugo, yek da̱mit ɗe lal sheda ga̱ pa̱lti wul ndakce gwe ta̱ mbi tumal nga̱sti ten Nya gwasi tun a ba̱sa̱ ɓo sa̱lti sowu. Ten gwisi ka̱n yek Iba̱ra̱him pal ɗe aba ga̱ ma̱jwe sa̱ nga̱ssi ten Nya ten ɗe ta̱s dla̱msi ɗe ma̱n pa̱lti wul ndakce ko ɗe ba̱sa̱ sa̱lsi sowu. ");
INSERT INTO gyz_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Nu ka̱n Iba̱ra̱him da̱m ɗe aba ga̱ ma̱jwe sa̱ sa̱lsi wu, ko ɗe ba̱ ɗe sa̱lti ka̱n sa̱ sa̱lsi tokte sowu, ama hal sa̱ na̱ma kopti wunda̱l ga̱ lal nga̱sti ten Nya gwe ni Iba̱ra̱him ɗa tun a ba̱sa̱ ɓo sa̱lti sowu. ");
INSERT INTO gyz_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Alkawol wu ɗe sa̱ pi Iba̱ra̱him suk ga̱z jwas wu ɗe ta ci gado ga̱ dii atl wugo, ai tumal mba̱t ga̱ɓa ga̱ Musa ka̱n sa̱ pit alkawoli so, ama ta̱ kan alkawoli tumal pa̱lti wul ndakce gwe a mbala̱n mbi tumal nga̱sti ten Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ten ɗe kume ɗe ma̱n kopti mba̱t ga̱ Musa ka̱ɗe ma̱jwe sa ci gado ga̱ dii atl go, ai nga̱sti ten Nya ga̱ mbala̱n a da̱ma̱n ten koo lu, a alkawol ga̱ Nya da̱m ɗe wul ga̱ ten koo lu. ");
INSERT INTO gyz_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Ten ɗe mba̱t ga̱ɓe wo lilti mbadl ga̱ Nya ka̱n a tulli, ama ka̱ mas lu gwe mba̱t ga̱ɓa ni ɗa̱ sowu, byas wul ni ɗa̱ so pak. ");
INSERT INTO gyz_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ten na̱k gwisi ka̱n alkawoli tul ten bi nga̱sti ten Nya, tumal alheri ga̱ Nya, ten ɗe ta̱ mas mil ji Iba̱ra̱him mbi alkawoli. Ama sa̱ dla̱lla̱li alkawoli ga̱n ma̱jwe sa̱ ga̱z ga̱ mba̱t ga̱ɓa ga̱ Musa wu si na̱ ngusa̱n so, ama suk mas ma̱n nga̱ssi ten Nya na̱k kangwe Iba̱ra̱him pa̱li wu. Ten na̱k gwisi ka̱n Iba̱ra̱himi ka̱ɗe aba ga̱na̱n mas jina̱n. ");
INSERT INTO gyz_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Na̱k kangwe ni ga̱ lishi wu ɗe, <<A palla̱k wi ɗe aba ga̱ bi wonti.>> Gwisi wo yek ɗe sa̱ dla̱lli alkawol ga̱mi ɗe gem wi. Iba̱rahim wo Aba ga̱na̱n ka̱n a cina ga̱ Nya gwe ta̱ nga̱sti ten ti wu, Nya gwe ata̱ ba̱l mbadl ma̱jwe sa̱ ma̱sh wu. Tik ɗe ma̱n iko mbet ji wul jwe sa̱ ni ɗa̱ sowu ɗe ta̱s tuli a wuli tuli. ");
INSERT INTO gyz_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ko ɗe za̱t mbadl ga̱ Iba̱ra̱him da̱m na̱k wule ten koo lu ka̱ wu, mas na̱ nu yek ba̱ta̱ cel ka̱ mbadl so yek ta̱ cina na̱ za̱t mbadli ata̱ na̱ma nga̱sti ten Nya ta̱s pal ɗe, <<Aba ga̱ bi wonti.>> Ga̱mi pi nu ka̱n na̱k kangwe sa̱ pit alkawol wu ɗe, <<na̱k gwisi ka̱n ma̱n ga̱z jwa a wonti.>> ");
INSERT INTO gyz_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ka̱ sa'i gwisi wo a Iba̱ra̱him pa̱l gin ɗe zamba̱l ɗe na̱m na̱ za̱ti, ama yek ba̱ nga̱sti ten Nya gwas nda̱ɗi ka̱ so, ko ɗe ta̱ na̱ma yenti kangwe nda̱lti ga̱ dli gwas paki ka̱ wi na̱ koliti suk kangwe Saratu ɗakci sa'i za̱t yen wu. ");
INSERT INTO gyz_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ta̱ cel ka̱ mbadl na̱ alkawol ga̱ Nya yek ta̱ mbok ang ten la̱shi nga̱sti ten Nya so, ama yek ta̱ mba̱l nda̱lti nga̱sti ten Nya gwas dani ata̱ nima ba̱lti nalti Nya. ");
INSERT INTO gyz_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","A ta̱ da̱m na̱ yisti i'e ɗe iko njika̱nti alkawoli ni Nya ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Yek laki yek sa̱ dla̱mi Iba̱ra̱him nga̱sti ten Nya gwas ɗe pa̱lti wul ndakce. ");
INSERT INTO gyz_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ga̱ɓa ga̱n ɗe wule <<Yek sa̱ dla̱m nga̱sti ten Nya gwas ɗe pa̱lti wul ndakce wu,>> ai, ba̱ ɗe ten bi gwas ti na̱ ngus ka̱n sa̱ lishi so. ");
INSERT INTO gyz_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ama sa̱ pa̱l lishti ga̱mi ten bi ga̱na̱n, mi ɗe mi mago Nya a dla̱ma̱nni ɗe ma̱n pa̱lti wul ndakce wu, mi ɗe ma̱ ba̱la̱n gem na̱ ma̱lgwe tlil Yesu Bagaa ga̱na̱n ɗa̱ka̱ ma̱shka̱n ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ten bi byas wul ga̱na̱n ka̱n sa̱ ba̱l bi ga̱ Yesu ɗe ta̱s ma̱shi, yek sa̱ palla̱t kaami ten ɗe ta̱n da̱ma̱n ɗe ma̱n la̱shi byas wul a cina ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Ten Na̱k gwisi ka̱n na̱k ɗe ma̱ mbi da̱mti ɗe ma̱n la̱shi byas wul gaa mal Nya tumal nga̱sti ten Nya wu, ta̱mi da̱mti ni ka̱ dlo ga̱na̱n suk Nya tumal Bagaa ga̱na̱n Yesu Almasihu. ");
INSERT INTO gyz_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Tumalti ka̱n ma̱ mbi tet ka̱ alheri ga̱n ɗe ma̱ na̱nma da̱mti giɓi tumal nga̱sti ten Nya wu. A ma̱ na̱mma pa̱lti hwol tuki ten ɗe ma̱ za̱n mbadl ɗe ma da̱ma̱n ɗe ma̱jwe sa cugaa gaa ka̱ nalti ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","A ba̱ gwisi ka̱ tokte so ama hal ma̱ na̱nma pa̱lti hwol tuk ka̱ tlat bomti ga̱na̱n, ten ɗe ma̱ yisi ɗe a tlat bomti lakka̱n ni ten dlot bi, ");
INSERT INTO gyz_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","a dlot bi laki a ma̱n da̱ma̱n ɗe ma̱n pa̱lti hwa wul, a pa̱lti hwa wul laki a ma̱ da̱ma̱n na̱ za̱t mbadli. ");
INSERT INTO gyz_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","A ba̱ za̱t mbadl gwisi ani ten koo lu so ko njet, ten ɗe Nya ta̱tok lamti gwas ɗa̱nka̱ mbadl jina̱n ka tumal Shishi ga̱ Nya gwe ta̱ ba̱la̱nni wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Ten ɗe ndakce ka̱ sa'i gwe ba̱ma̱ mbuki za̱t ang gaa ga̱na̱n sowu, yek Almasihu ma̱sh ten bi ga̱na̱n, mi ma̱jwe ba̱ Nya lam pa̱lti wul ga̱na̱n sowu. ");
INSERT INTO gyz_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Wul ma̱n bomti i'e ka̱n ta̱ ma̱lgon ma̱sh ten bi ga̱ ma̱n pa̱lti wul ndakce, ko ɗe gon a ma̱lgon pa̱l nda̱li gahwula̱n ata̱ ma̱shi ten bi ga̱ hwa mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ama Nya mbokini ang ten nalti ga̱ lamti gwasi, na̱k ɗe tun a ma̱ yi ɗe ma̱n byas wul ka̱n yek Almasihu ma̱shi ten bi ga̱na̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","To, tun na̱k ɗe ma̱ mbi da̱mti ɗe ma̱n la̱shi byas wul a cina ga̱ Nya tumal hwulan ga̱ Almasihu wu, ba̱she na̱k ninge ma, ai sa kisa̱nni ɗa̱ka̱ liliti mbadl ga̱ Nya ka tumal Almasihusi. ");
INSERT INTO gyz_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","To, na̱k ɗe tun ka̱ sa'i gwe ma̱ yi ɗe yela̱n tlanti ji Nya wu ka̱n sa̱ la̱ka̱n dlo ga̱na̱n sukti tumal ma̱shka̱n ga̱ Yen gwas wugo, ba̱she ta̱ ninge ɗe sa̱ palla̱nni ɗe yelan jwas wu gwa, sa kisa̱nni ca tumal da̱mti ga̱ Yeni. ");
INSERT INTO gyz_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ta̱ man na̱k gwisi, hal ma̱ na̱nma pa̱lti hwol tuk ten bi ga̱ ilgwe Nya pa̱li tumal Bagaa ga̱na̱n Yesu Almasihu, ma̱lgwe tumalti ka̱n sa̱ la̱ka̱n dlo ga̱na̱n suk Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","To, na̱k kangwe byas wul tul ten dii atl tumal mbala̱n ɗe na̱m, yek byas wuli tulli ma̱shka̱n, na̱ na̱k gwisi ka̱n ma̱shka̱n nda ten mas mbala̱n ten ɗe ko wokko pa̱l byas wul wi. ");
INSERT INTO gyz_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ka̱ sa'i gwe ba̱ sa̱ ɓo ba̱l mba̱t ga̱ɓa ga̱ Musa sowu, a byas wul ni ɗa ten dii atli. Ama a ba̱sa dla̱m byas wul ka̱ lugwe ɗe mba̱t ga̱ɓa niɗa̱ sowu so. ");
INSERT INTO gyz_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ama mas na̱ nu yek ma̱shka̱n pa̱l iko ten mas mbala̱n, kan tet ten Adamu hal yek la Musa, hal yek ma̱shka̱n pa̱l iko ten ma̱jwe pa̱lti byas wul jwasa̱n wo ba̱ ga̱ celti mba̱t ka ka̱ sowu na̱k kangwe ga̱ Adamu pi wu. Adamu ka̱ɗe cinga̱lti ga̱ ma̱lgwe a tul gwe tik ɗe ba̱lti wul ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ama ba̱lti wul ga̱ Nya ɗe ta̱ ba̱li tumal ma̱lgwe ta ya tul go ni kak-kak i'e suk byas wul gwe Adamu pa̱li wu. A yekgu byas wul gwe mbala̱n ɗe na̱m pa̱li wu tulli wonti mbala̱n ma̱shka̱n. Ama alheri ga̱ Nya nal mani, hal yek ba̱lti wul gwas ɗe ta̱ ba̱li tumal alheri ga̱ mbala̱n ɗe na̱m gwisi wu laki yek mbala̱n wonti mbi bal albarka. ");
INSERT INTO gyz_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Gem ba̱lti wul ga̱ Nya ni kak-kak suk byas wul ga̱ mbala̱n ɗe na̱m wu. Na̱k ɗe nolti gwe kop kaal ga̱ byas wul gwisi go yek tulli ma̱shka̱n, ama ba̱lti wul ga̱ Nya go yek laki yek ba̱ byas wul nini gaa a cina gwas so, ko ɗe ma̱ pa̱la̱n byas wul wonti wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Tumal byas wul ga̱ mbala̱n ɗe na̱m ma̱lgwe tik ɗe Adamu wu ka̱n ma̱shka̱n mbi iko ten ko wokko, ama iko ga̱ byas wuli wo ni ten bi ilgon so ɗe kume sa̱ cinga̱li na̱ iko gwe mbala̱n ɗe na̱m gwisi, ma̱lgwe tik ɗe Yesu Almasihu wu tulli mas ma̱jwe sa̱ kan alheri ga̱ Nya suk ba̱lti wul gwas ga̱ da̱mti ɗe ma̱n pa̱lti wul ndakce a cina gwas wu. Tumalti ka̱n ma pa̱la̱n iko ka̱ da̱mti ga̱na̱n. ");
INSERT INTO gyz_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ten na̱k gwisi ka̱n na̱k kangwe ɗakcit mba̱t ga̱ mbala̱n ɗe na̱m tulli nolti ga̱ ma̱shka̱n ten ko wokko wu, nu ka̱n pa̱lti wul ndakce ga̱ mbala̱n ɗe na̱m tulli albarka ko wokko, gwe yek ɗe da̱mti ɗe ma̱n la̱shi byas wul a cina ga̱ Nya suk ma̱n pyal mbadl wu. ");
INSERT INTO gyz_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Na̱k kangwe ɗe mbala̱n wonti da̱m ɗe ma̱n byas wul tumal la̱shi kumti bi ga̱ mbala̱n ɗe na̱m wu, nu ka̱n mbala̱n wonti a da̱m ɗe ma̱n pa̱lti wul ndakce tumal kumti bi ga̱ mbala̱n ɗe na̱m pak. ");
INSERT INTO gyz_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Ilgwe laki yek sa̱ ba̱l mba̱t ga̱ɓa ga̱ Musa go yek ɗe ta̱ yilli byas wul ten dii. Ama sa'i gwe ɗe byas wul mba̱ldli wugo yek alheri ga̱ Nya mba̱ldli mani, ");
INSERT INTO gyz_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ten ɗe na̱k kangwe ɗe byas wul pa̱l iko tenti tumal ma̱shka̱n wu, nu ka̱n alheri ga̱ Nya nima iko tenti ninge tumal pa̱lti wul ndakce, ten ɗe ta̱s ta̱lani ka̱ mbadl ma̱n la̱shi pakti tumal Yesu Almasihu Bagaa ga̱na̱n. ");
INSERT INTO gyz_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","To, yek ma dla̱ma̱n ye? Ma cin cina na̱ pa̱lti byas wul ten ɗe ta̱ alheri ga̱ mba̱ldli nwa? ");
INSERT INTO gyz_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Wowo! Ko nja! Mi ɗe ma̱ ma̱sha̱n wi, ma̱shka̱n ga̱ zakti pa̱lti byas wul wugo ɗa̱ni ka̱n ma cin cina na̱ da̱mti a giɓi gwi? ");
INSERT INTO gyz_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ko na̱k ka̱n ka̱a̱ yisi so ɗe mas jina̱n ɗe sa̱ pa̱lini Baptisma tet ka̱ Almasihu Yesu go, tet ka̱ ma̱shka̱n gwas ka̱n sa̱ pa̱lini so nwa? ");
INSERT INTO gyz_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Gwisi ka̱ mbok ang ɗe sa̱ leɓa̱nni ka sukti tumal Baptisma ga̱na̱n ka̱ sa'i gwe sa̱ lepti wu. Ten na̱k gwisi ka̱n ma̱ ɓala̱n ɗe na̱m sukti ka̱ ma̱shka̱n gwasi, ten ɗe na̱k kangwe sa̱ tlil Almasihu ɗa̱ka̱ ma̱shka̱n ka tumal iko ma̱n nalti ga̱ Aba wu, nu ka̱n mi mago ma pa̱la̱n pyal da̱mti pak. ");
INSERT INTO gyz_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Na̱k ɗe ma̱ na̱n ɗe na̱m sukti ka̱ wunda̱l ga̱ ma̱shka̱n gwe ta̱ ma̱sh wu, gem nu ka̱n ma da̱ma̱n ɗe na̱m sukti ka̱ tlit gwas ɗa̱ka̱ ma̱shka̱n ka. ");
INSERT INTO gyz_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Ma̱ yisi ɗe sa̱ ɓak byas pa̱lti wul jina̱n ka ten guda̱l yencin sukti wi, ten ɗe ta̱s kamini iko ga̱ byas wul gwe ni ka̱ dli ga̱na̱n wu ka. Sa̱ pa̱li nu ka̱n ten ɗe ba̱n po saka da̱mti ɗe zhel ji byas wul so. ");
INSERT INTO gyz_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Na̱k ɗe kume mbala̱n ma̱sh wugo, ta̱ mbi gaa gwas tet ɗa̱ka̱ iko ga̱ byas wul ka̱wi. ");
INSERT INTO gyz_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Kume ɗe ma̱ ma̱sha̱n suk Almasihu wu, ma̱ nga̱ssa̱n ten Nya ɗe ma pa̱la̱n da̱mti sukti pak. ");
INSERT INTO gyz_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ten ɗe ma̱ yisi ɗe sa̱ tlil Almasihu ɗa̱ka̱ ma̱shka̱n ka̱wi, a ba̱ta po saka ma̱shka̱n so, gwisi wo na̱ma mbokti ang ɗe iko gon poyi ma̱shka̱n ɗa tenti so. ");
INSERT INTO gyz_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Ma̱shka̱n gwe ta̱ pa̱li go, asa̱mi ɗe na̱m tak ka̱n ta̱ ma̱shi ba mba̱lti ten ɗe ta̱s cel iko ga̱ byas wul ka, ata̱ pa̱l da̱mti suk Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Nu ka̱n kii mago palla̱n gaa jwaka̱n na̱k hwuni ma̱jwe ɗe ba̱ iko ni byas wul ɗa tensi so wu, ama ka̱a̱ ni kaami mal Nya tumal Almasihu Yesu. ");
INSERT INTO gyz_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ten na̱k gwisi ka̱n ba̱k zakini a pa̱lti byas wul pa̱l iko ka̱ dli jwaka̱n ma̱n ma̱shka̱n wu hal a lakkii ten kopti byas lamti wul gwas so. ");
INSERT INTO gyz_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ba̱k taki ka̱t dli jwaka̱n byas wul ta̱s da̱m ɗe wul pa̱lti ngalci so. Seko ta̱k taki gaa gwaka̱n Nya na̱k gwe ndal ma̱jwe sa̱ yilla̱si ɗa̱ka̱ ang ga̱ ma̱shka̱n ka yek sa̱ ba̱lsi mbadl wu, taki Nya ka̱t dli jwaka̱n ten ɗe ta̱s da̱m ɗe wul pa̱lti wul ndakce. ");
INSERT INTO gyz_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ten ɗe byas wul a pa̱l iko tenkii so, na̱k ɗe ka̱a̱ ni ga̱z ga̱ mba̱t ga̱ɓa ga̱ Musa sowu, ama a ga̱z ga̱ alheri ga̱ Nya ka̱n ka̱a̱ ni wu. ");
INSERT INTO gyz_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","To, nikgwi? Ta̱n pa̱la̱n byas wul na̱k ɗe ma̱ na̱n ga̱z ga̱ mba̱t ga̱ɓa so ten ɗe ma̱ na̱n ga̱z ga̱ alheri ga̱ Nya ma? Wowo! Ko njaa ma̱ pa̱li nu so! ");
INSERT INTO gyz_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ko ka̱a̱ yisi ɗe kume ka̱a̱ tak gaa gwaka̱n ten ɗe ta̱k kumi bi ma̱lgon wugo, ka̱a̱ ɓal ɗe zhel ka̱ ang ma̱lgwe ka̱a̱ nit ma kumti bi wu sa? Kaa man da̱mti ɗe zhel ga̱ byas wul gwe a tulli ma̱shka̱n wu sogo zhel ga̱ kumti bi Nya gwe a ta̱la mbala̱n ka̱ pa̱lti wul ndakce wu. ");
INSERT INTO gyz_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ama godiya wo ga̱ Nya ka̱n, ten ɗe ko ɗe tekgo zhel ga̱ byas wul ka̱ɗe kii wu, ama ningo ka̱a̱ nima kumti bi wunda̱l ga̱ mbokti ang gwe sa̱ lakkii ga̱z gwas wu na̱ mas mbadl gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Sa̱ ɓatl wul tenkii yek sa̱ kiskii yek sa̱ yilla̱kii ɗa̱ka̱ ang ga̱ byas wul ka̱ wi, yek ka̱a̱ ɓal ɗe zhel ga̱ pa̱lti wul ndakce. ");
INSERT INTO gyz_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","A nikii ma ga̱ɓa ten wul ji ase na̱ ayo, ten bi ga̱ la̱shi njika̱nti gwaka̱n ga̱ mbala̱n. Na̱k kangwe ɗe tekgo ka̱a̱ ku na̱ takti ka̱t dli jwaka̱n ten pa̱lti wul cit daɗe, suk ngalci ilgwe nima mba̱ltidli i'e wu, nu ka̱n ningo se ta̱k taki Nya ka̱t dli jwaka̱n ten pa̱lti wul ndakce, ten ɗe ta̱k da̱ma̱n ɗe ma̱jwe sa̱ za̱si ka a ba̱ da̱ska̱n nisi ɗa mal Nya sowu. ");
INSERT INTO gyz_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ka̱ sa'i gwe ka̱a̱ yi ɗe zhel ga̱ byas wul wugo, ba ze gwaka̱n na̱ pa̱lti wul ndakce. ");
INSERT INTO gyz_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Yek ɗe hwa ilgwe ka̱a̱ mbi tet ka̱ wul jin ɗe ningo da̱mikii ɗe wul nsha wu ye? Ai, ɓatlti ga̱ wul jimi wo ma̱shka̱n ka̱n! ");
INSERT INTO gyz_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ama ningo ka̱ mbi gaa gwaka̱n tet ɗa̱ka̱ da̱mti ɗe zhel ga̱ byas wul ka̱ wi, yek ka̱a̱ ɓal ɗe zhel ji Nya. Hwa ilgwe ka̱a̱ na̱ma mbiti ten ga̱mi go yek ɗe da̱mti ka̱ cilti gwe yek ɗe ilgwe na̱ma lakti gwaka̱n ten mbit mbadl ma̱n la̱shi pakti wu. ");
INSERT INTO gyz_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Na̱k ɗe ɓatlti ga̱ byas wul wo yek ɗe ma̱shka̱n, ama ilgwe a Nya ba̱li go yek ɗe mbadl ma̱n la̱shi pakti tumal Almasihu Yesu Bagaa ga̱na̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","To, yilkeni jini, na̱k ɗe mas jwaka̱n ka̱a̱ yis mba̱t ga̱ɓa ga̱ Musa wu, kaa yis gaa ga̱ ilgwe ba dla̱m wu. Mba̱t ga̱ɓa ga̱n go ka̱ sa'i gwe ɗe mbala̱n yi kaami wu tokte ka̱n a pa̱l iko tenti. ");
INSERT INTO gyz_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Cinga̱li ga̱ɓa a dani wo yek ɗe kili gwe sa̱ pa̱lit hapti wu, kilisi ni ka̱ ang ga̱ kos gwasi ɗe hal kume ɗe kosi yi kaami wu. Ama kume ɗe kos gwas ma̱sh wugo mba̱t ga̱ɓa ga̱ haptisi poyit gaa so. ");
INSERT INTO gyz_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Ten na̱k gwisi ka̱n kume ɗe ta̱ hap zobsi ma̱lgon ka̱ sa'i gwe kosi yi kaami go sa mbet ɗe ma̱n pa̱t pa̱la̱n. Ama kume ɗe kosi ma̱sh wugo mba̱t ga̱ɓa hapti poyit gaa so. Kume ɗe ta̱ saka hapti zobsi ma̱lgon go, ti wo ma̱n pa̱t pa̱la̱n ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ili wo nuka̱n ni yilkeni jini, ilgwe a nikii ma dla̱mti wu na̱ma mbokti ang ten ilgwe na̱ma pa̱t na̱kii wu. Ma̱shka̱n ga̱ Yesu Almasihu ten guda̱l yencin laki yek ka̱a̱ ɓal ɗe hwuni mal mba̱t ga̱ɓa ga̱ Musa. Ningo kii wo mbala̱n jwas ka̱n, ti Yesu ɗe Nya tlilti ɗa̱ka ma̱shka̱n ka̱wu, ten ɗe ta̱k pa̱la̱n da̱mti gwe mbun a cina ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ten ɗe ka̱ sa'i gwe ma̱ da̱ma̱n ka̱ ang ga̱ iko ga̱ pa̱lti wul ga̱ dli go, Mba̱t ga̱ɓe ngusi cokti ga̱ byas lamti wul ga̱na̱n. Byas lamti wul ga̱na̱mi nego yek ngusi pa̱lti wul ka̱ dli jina̱n, a mas pa̱lti wul jina̱mi tullini ma̱shka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ama ningo ma̱ mbi gaa tet ɗa̱ka̱ iko ga̱ mba̱t ga̱ɓa ga̱ Musa ka̱ wi na̱k ɗe ma̱ ma̱shi ilgwe ɓala̱nni wu ka̱wu. Ten na̱k gwisi ka̱n ningo ma̱ nima pa̱lti wul Nya ka̱ pyal da̱mti tumal Shishi gwasi. Gus pa̱lti wul ji tek ɗe a ma̱ pa̱li mba̱t ga̱ɓa wu nda na̱ kaal wi. ");
INSERT INTO gyz_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","To, yek ma dla̱ma̱n ye? Mba̱t ga̱ɓe gaa gwas wo byas wul ka̱ nwa? Wowo, ko njet! Ten ɗe kume tumal mba̱t ga̱ɓe kani sogo ɗa̱ ni ka̱n ba yis ilgwe ni ɗe byas wul wu gwi? Ɗe da mba̱t ga̱ɓe a wuli ɗe, <<Ba̱k koo gwel ten wul ga̱ ma̱lgon sowu,>> go ai da ba yisa̱n ilgwe asa̱ mbe ɗe kot gwel wu so. ");
INSERT INTO gyz_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ama ten bi ga̱ mba̱t ga̱ɓa gwisi yek byas wul mbi bidlabii cokti ga̱ mas wunda̱l ga̱ kot gwel ka̱ ami. Ten ɗe kume ɗe ba̱ tu ten mba̱t ga̱ɓa ka̱ sogo byas wul wo hwuni ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Tek ɗe a ɓo yis mba̱t ga̱ɓa ga̱ Musa sogo ani na̱ mbadli, ama ɗe a yis mba̱t ga̱ɓe wugo yek byas wul tlinya na̱ mbadl ka̱ ami yek paa a ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Yek paa a yis gaami ɗe, mba̱t ga̱ɓa gwisi ɗe sa̱ lami ɗe ta̱ tulli mbadl go yek tulli ma̱shka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Yek byas wuli mbi tantu yek paa shela̱nni yek tlo ka tumal mba̱t ga̱ɓe. ");
INSERT INTO gyz_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ten na̱k gwisi ka̱n mba̱t ga̱ɓe gaa gwas wo ma̱n cilti ka̱n, a wul jwe sa̱ mbok ang dani a giɓi wu mago ma̱n cilti ka̱n, a wul jwe ni giɓi go wul jwe sa̱ ni ndakce wu ka̱n a hwaɓi ka̱ pak. ");
INSERT INTO gyz_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ɓohwe mbala̱n a mana̱n wulti ɗe hwa mba̱t ga̱ɓa gwisi ka̱ tulli ma̱shka̱n nwa? Wowo! Ko njaa! Ama ten ɗe byas wul ka̱ tulli ma̱shka̱n tumal hwa mba̱t ga̱ɓa gwisi ten ɗe ta̱ mbok ang ten kangwe byas wul ten dii. Gwisi wo yek sa̱ mbok ang ten lilti ga̱ byas wul ten dii tumal mba̱t ga̱ɓe. ");
INSERT INTO gyz_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ma̱ yisi ɗe mba̱t ga̱ɓa ga̱ Musa wo wul ga̱ Shishi ga̱ Nya ka̱n, ami nego ma̱n pa̱t ga̱ dli ka̱n, a zhel ka̱n ka̱ ang ga̱ byas wul. ");
INSERT INTO gyz_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","A yis gaa ga̱ ilgwe a na̱ma pa̱lti wu so. Ten ɗe ilgwe ɗe a na̱ma lamti pa̱lti wu ka̱n a na̱ma pa̱li so, a ilgwe ɗe a na̱ma nget pa̱lti wu ka̱n a na̱ma pa̱lti. ");
INSERT INTO gyz_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Na̱k ɗe ilgwe a na̱ma ngeti wu ka̱n a na̱ma pa̱lti go, gwisi na̱ma̱ mbokti ang ɗe a kan wi ɗe mba̱t ga̱ɓe wo hwa wul ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","A gwisi na̱ma mbokti ang ɗe ami gaa gi ka̱ɗe ma̱n byas wuli so, ama byas wul gwe ni ka̱ ami wu ka̱ɗe ma̱n pa̱lti ka̱ ami wu. ");
INSERT INTO gyz_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","A yisi ɗe da̱mti gi ga̱ mbala̱n wo hwal ilgon ni ka̱ ami so, ten ɗe a na̱ma lamti pa̱lti hwa wul ama yek pa̱lti na̱k gwisi kama̱n gaa. ");
INSERT INTO gyz_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","A pa̱l hwa wul jwe ɗe a na̱ma lamti pa̱lti wu so, ama yek a na̱ma ta pa̱lti byas wul jwe ɗe ba̱ a lam pa̱lti sowu. ");
INSERT INTO gyz_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","To, kume a na̱ma pa̱lti ilgwe ba̱ a lam pa̱lti sowu, gwisi na̱ma mbokti ang ɗe amik na̱ma pa̱lti ili so, ama byas wul gwe na̱ma da̱mti ka̱ ami wu ka̱ na̱ma pa̱lti. ");
INSERT INTO gyz_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ten na̱k gwisi ka̱n, yek a yis gaami ɗe, ashe ilgwisi wo pa̱t gi ka̱n ten ɗe kume aɓa lam pa̱lti hwa wul wugo, a mbi gaa gi ten pa̱lti byas wul. ");
INSERT INTO gyz_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ten ɗe su ka̱ mbadl gi ka̱ wo a lam kopti mba̱t ga̱ɓa ga̱ Nya, ");
INSERT INTO gyz_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ama ka̱ ka̱t dli ji wo yek a na̱ma yenti zopsi mba̱t gon gwe nima tlanti suk mba̱t ga̱ɓa gwe mbadl gi kan wu. Gwisi wo yek ɓalla̱n ka ka̱ ang ga̱ mba̱t ga̱ byas wul gwe nima da̱mti ka̱ ka̱t dli ji wu. ");
INSERT INTO gyz_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ma̱n duu tuk na̱k ami! Ami wo wul cit gonti ka̱n! Wok ka kisa̱n ɗa̱ka̱ ang ga̱ dli ma̱n ta̱lat mbala̱n ka̱ ma̱shka̱n ga̱n ka̱ wo? ");
INSERT INTO gyz_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Ama godiya wo ga̱ Nya ten ɗe ta̱ kissa̱nni tumal Yesu Almasihu Bagaa ga̱na̱n! Ten na̱k gwisi ka̱n, ami gaa gi wo mba̱t ga̱ɓa ga̱ Nya ka̱n a nit ɗe zhel ka̱ ceti gaa gini, ama ka̱ pa̱t gi ga̱ dli ga̱ mbala̱n wo mba̱t ga̱ pa̱lti byas wul ka̱n a nit ɗe zhel. ");
INSERT INTO gyz_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Ten na̱k gwisi ka̱n ningo nolti ga̱ ma̱shka̱n po yi ma̱jwe sa̱ni ɗe ga̱ Yesu Almasihu wu gaa so. ");
INSERT INTO gyz_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ten ɗe mba̱t ga̱ Shishi ma̱n ba̱lti mbadl wu kissa̱n ɗa̱ka̱ mba̱t ga̱ byas wul suk ma̱shka̱n ka tumal Almasihu Yesu. ");
INSERT INTO gyz_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ten ɗe ilgwe ba̱ mba̱t ga̱ɓe man pa̱lti so ten bi la̱shi njika̱nti gwe a pa̱t ga̱ dli ga̱ mbala̱n tulli go, yek ɗe ilgwe Nya pa̱li wu. Nya shin Yen ɗe na̱m gwe nit ɗa̱ wu suɗi ka̱ wunda̱l ga̱ dli ga̱na̱n ma̱n byas wul ge, ten ɗe ta̱s ɗa̱m ɗe sadaka ten bi ga̱ byas wul asa̱ tlo iko ga̱ byas wul ɗa̱ka̱ dli ga̱ mbala̱n ka̱ ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Nya pali nu ka̱n ten ɗe ta̱ mas pa̱lti wul ndakce jwe mba̱t ga̱ɓe dla̱m ɗe ta̱ mbala̱n pa̱li wu pa̱ldli mala̱nni. Nya pa̱li ni na̱k gwisi ka̱n, mi ɗe ma̱ na̱nma da̱mti ka̱ Shishi gwas ɗe a ba̱ wunda̱l ga̱ da̱mti ga̱ pa̱t ɗa̱ dli ka̱n ma̱ na̱mma pa̱lti sowu. ");
INSERT INTO gyz_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ma̱jwe asa̱ pa̱l da̱mti ga̱ dli go asa̱ sul gwel ten wul ji dli, ama ma̱jwe asa̱ pa̱l da̱mti ga̱ Shishi ga̱ Nya go asa̱ sul gwel ten wul jwe Shishi ga̱ Nya lami wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Sulti gwel ten wul ji dli wo a tulli ma̱shka̱n, ama sulti gwel ten wul ji Shishi ga̱ Nya wo a tulli mbadl suk ta̱mi mbadli. ");
INSERT INTO gyz_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Mas ma̱lgwe sul gwel ten pa̱lti wul ga̱ dli go, ma̱li ɓal ɗe yela̱n dlanti ga̱ Nya. Ten ɗe aba̱ ma̱li a taki mba̱t ga̱ Nya gaa gwas so, a ba̱ta man pa̱lti wul jwe mba̱ti dla̱m wu so pak. ");
INSERT INTO gyz_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ma̱n da̱mti ga̱ pa̱t ga̱ dli wo ba kangwe sa man pa̱lti ilgwe a Nya lami wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kii wo da̱mti pa̱t ga̱ dli ka̱n ka̱a̱ na̱ma da̱mti so, seko da̱mti ga̱ Shishi ga̱ Nya ɗe kume Shishi na̱ma da̱mti ka̱ mbadl jwaka̱n wu. Mas ma̱lgwe ɗe Shishi ga̱ Almasihu nit ɗa̱ sogo, ma̱li wo ga̱ Almasihu ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kume ɗe Almasihu nima da̱mti ka̱ mbadl gwaka̱n wu, ko ɗe dli gwaka̱n ni ten bi ma̱shka̱n ka ten bi ga̱ byas wul go, Shishi ga̱ Nya na̱ma keta̱lti gwaka̱n ten bi ga̱ Nya na̱k ɗe Nya pa̱lla̱kii ɗe ma̱n pa̱lti wul ndakce wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","A kume Shishi ga̱ Nya ɗe ta̱ tlil Yesu ɗa̱ka̱ ma̱shka̱n ka̱wu nima da̱mti ka̱ mbadl gwaka̱n go, to, ti ɗe ta̱ tlil Almasihu ɗa̱ka̱ ma̱shka̱n ka̱wu a ba̱l mbadl dli gwaka̱n ma̱n ma̱shka̱n wu, tumal Shishi gwas ɗe nima da̱mti ka̱ mbadl jwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ten na̱k gwisi ka̱n, yilkeni jini, ngetli ka̱n ba̱ da̱mti ga̱na̱n ni ba̱ɗe ga̱ pa̱t ga̱ dli ga̱ mbala̱n ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Ten ɗe kume da̱mti ga̱ dli ka̱n ka̱a̱ na̱ma da̱mti go kaa ma̱shi. Ama kume ɗe tumal iko ga̱ Shishi ga̱ Nya ka̱n ka̱a̱ tlo pa̱t ga̱ byas wul ka̱ go, kaa da̱mi. ");
INSERT INTO gyz_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ten ɗe ma̱jwe a Shishi ga̱ Nya koɓi na̱si go, mil ji Nya ka̱ɗe si. ");
INSERT INTO gyz_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ten ɗe Shishi gwe sa̱ ba̱lkii go ga̱ da̱mti ɗe zhel ka̱so, kangwe ɗe ɓanti a cikii sowu. Wowo, Shishi gwisi wo ga̱ da̱mti ɗe mil ji Nya ka̱n, a tumal Shishi gwisi ka̱n ama̱ mbe Nya ama̱ mbeti ɗe, <<Abba, Aba!>> ");
INSERT INTO gyz_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Shishi ga̱ Nya gaa gwasi suk shishi ga̱na̱n na̱ma dla̱lla̱ti ɗe gem mi wo mil ji Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ashe, tun na̱k ɗe mi wo mil ji Nya ka̱ wu, ma̱ ɓala̱n ɗe ma̱n cit gado gwasi. Gwisi wo yek ɗe ma̱n cit gado ga̱ albarka ga̱ Nya, suk yela̱n cit gado suk Almasihu, ɗe kume ma̱ tla bomti suk Almasihu wu ngetli ka̱n ta̱s nalla̱nni sukti. ");
INSERT INTO gyz_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ai, a yisi ɗe gem ka̱n, ba kangwe a cinga̱l bomti gwe ma̱ na̱nma tlati ka̱ multi ji se wu, suk wunda̱l ga̱ nalti gwe sa mbokini ang dani a cina wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Mas wul jwe Nya pa̱li wu na̱ma ɓa̱tti asa̱ na̱ma za̱t mbadl i'e ten ɓa̱tti ga̱ sa'i gwe Nya a mbok ang ten mil jwas ten dii wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Ten ɗe wul jwe Nya pa̱li wu mas mbuk da̱mti ɗe ilgwe Nya lami wu so, a ba̱ɗe lamti ji wuli gaa gwasa̱n ka̱so, ama ten ɗe nuka̱n Nya lami ɗe ta̱ pi. Nya pa̱li na̱k gwisi ka̱n na̱ za̱t mbadli, ");
INSERT INTO gyz_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ten ɗe ta yilli wul jwe ta̱ pa̱lsi wu ɗa̱ka̱ da̱mti ɗe zhel ga̱ mokit wu ka, ten ɗe sa mbi mbit gaa ga̱ nalti gwe sa ba̱l mil ji Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Ma̱ yisi ɗe hal ninge mas wul jwe sa̱ pa̱lsi wu yima pa̱lti nishi na̱k kangwe a kili ma̱n cit tuk ga̱ za̱t yen pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","A ba̱ɗe wul jwe sa̱ pa̱lsi wu na̱ ngusa̱n ka̱ na̱ma nishisi tokte so ama hal sukmi. Mi ɗe ma̱ mbi Shishi ga̱ Nya wu, gwe yek ɗe ilgwe ɗe sa̱ ndeni ba̱lti wu, ma̱ na̱nma nishi ka̱ mbadl jina̱n, ma̱ na̱nma ɓa̱tti na̱ za̱t mbadl i'e, ten ɗe ta̱ Nya palla̱nni ɗe mil jwas i'e wu, ata̱ ɓatl dli jina̱n jin pak. ");
INSERT INTO gyz_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ten ɗe tumal za̱t mbadl ga̱n ka̱n sa̱ kisa̱nni. Ama kume ɗe ma̱ yena̱n ilgwe ma̱ na̱nma za̱t mbadl a dani wugo, ai gwisi wo poyi ɗe za̱t mbadl so. Wok ka zi mbadl gwas ten ilgwe ɗe ta̱ mbi wu wo? ");
INSERT INTO gyz_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ama kume ɗe ma̱ na̱nma za̱t mbadl ga̱na̱n ten ilgwe ba̱ ma̱ ɓo mbi sowu, ai, ama̱ kul ɓa̱ti na̱ dlot mbadli. ");
INSERT INTO gyz_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nu ka̱n a Shishi ga̱ Nya zini ang ka̱ la̱shi manti wul ga̱na̱n. Ma̱ yisa̱n kangwe mbun ɗe ta̱n ngema̱n Nya wu so, ama Shishi ga̱ Nya na̱ gaa gwas ka̱ na̱ma ngemti ga̱ Nya ka̱ lal ga̱na̱n na̱ bal nishi jwe ba̱ bi ga̱ mbala̱n a man dla̱mti sowu. ");
INSERT INTO gyz_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nya ɗe ata̱ bodla̱l mbadl ga̱ mbala̱n go, ta̱ yis mas ilgwe Shishi gwas lami wu, ten ɗe a Shishi ga̱ Nya ngemi wul mbala̱m ji Nya, kangwe ɗe Nyami lami wu ka̱ lal ga̱ mbala̱n ji Nya. ");
INSERT INTO gyz_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ma̱ yisi ɗe ka̱ mas wul wo Nya nima pa̱lti hwa wul ma̱jwe sa̱ lamti wu, gwisi wo sik ɗe ma̱jwe sa̱ mbesi na̱k kangwe ta̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Ten ɗe ma̱jwe Nya yissi tun tek wu ka̱n, si ka̱n Nya laki wi ɗe ta̱s te Yen gwasi, ten ɗe ta̱ Yeni da̱m ɗe yen cina ka̱ dlo ji yilkeni jwasi. ");
INSERT INTO gyz_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ma̱jwe Nya laksi jo si ka̱n ta̱ mbesi. Ma̱jwe ta̱ mbesi go si ka̱n ta̱ palla̱si ɗe ma̱n la̱shi byas wul a cina gwasi. Ma̱jwe sa̱ palla̱si ɗe ma̱n la̱shi byas wul a cina gwas wu nego si ka̱n ta̱ ba̱lsi nalti. ");
INSERT INTO gyz_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","To, yek ma dla̱ma̱n ten ilga̱n ye? Na̱k ɗe Nya nini kaal go wok mbuk da̱mti ɗe yela̱n tlanti ga̱na̱n wo? ");
INSERT INTO gyz_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Na̱k ɗe Nya wo yek ba̱ta̱ nge ten Yen gwas so, ama yek ta̱ takti ten bi ga̱na̱n mas wu. Ti Nya gaa gwasi na̱k ɗe ta̱ ba̱la̱nni Yen gwas go a ba̱ta ba̱la̱nni naa wul na̱ mbadl ɗe na̱m so nwa? ");
INSERT INTO gyz_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Wok ka tulli ga̱ɓa ten ma̱jwe ɗe Nya botlisi wu wo? Ai Nya na̱ gaa gwas ka̱ɗe ma̱lgwe palla̱si yek sa̱ da̱m ɗe ma̱n la̱shi byas wul a cina gwas wu. ");
INSERT INTO gyz_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Wok mbuki ta̱s ndoka̱lisi kisti ma̱shka̱n wo? Almasihu Yesu ma̱lgwe ɗe ta̱ ma̱sh wu, ta̱ man na̱k gwisi, yek ta̱ tli tot ɗa̱ka̱ ma̱shka̱n ka, ata̱ ni ten ang shinti ga̱ Nya, a ta̱ na̱ma ngemti ga̱ Nya ka̱ lal ga̱na̱n. ");
INSERT INTO gyz_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Wok ka man hwulti dlo ga̱na̱n suk lamti gwe Almasihu nima lamti ga̱na̱n wu wo? Citi ka̱ dli ka̱ nwa, sogo tlat bomti, sogo cit dlelngapcan, sogo kuza̱n, sogo la̱shi wul ang, sogo da̱mti na̱ ɓanti, sogo ma̱sha̱n ka̱n? ");
INSERT INTO gyz_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Na̱k kangwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya wu ɗe, <<Ten bi gwa ka̱n ma̱ ni ten bi ma̱shka̱n dlip sa̱ palla̱ni na̱k mba̱la gwe sa boshti wu.>> ");
INSERT INTO gyz_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ai! Ka̱ mas wul jin jo ma̱ mana̱n ngetl ga̱ ta̱s mbeni ɗe ma̱n cit ba̱n tokte wi, gwisi wo tumal ti ɗe ta̱ lama̱nni wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ten ɗe gem a yisi ɗe, ko ta̱ ma̱shka̱n sogo mbadli, sogo mil shinti ji nya sogo ma̱zhe, sogo wul jwe ma̱na̱n giɓi ninge wu sogo wul jwe yi tet wu, sogo iko kak-kak, ");
INSERT INTO gyz_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","sogo tlalti, sogo dlunta̱ti, sogo zobsi ilgon ka̱ mas wul jwe sa̱ pa̱lsi wu. Mas jwasa̱n sa̱ mbuki ta̱s te ka̱ dlo ga̱na̱n suk lamti gwe Nya pa̱lini tumal Almasihu Yesu Bagaa ga̱na̱n wu so. ");
INSERT INTO gyz_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","A na̱ma dla̱mti gem ka̱ Almasihu, lal ka̱n a na̱ma shelti so. Ka̱ daamti ga̱ mbadl gi wo a yisi ɗe gem ka̱n tumal ba̱lti sheda ga̱ Shishi ga̱ Nya ɗe, ");
INSERT INTO gyz_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","a na̱ma pa̱lti duu tuk i'e, a ili na̱ma hwotti ga̱ mbadl gi ko a gasi. ");
INSERT INTO gyz_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Na̱ na̱k gwisi wo sa pa̱lini bi gaa go a mani, asa̱ hwula̱n suk Almasihu, ten ɗe ta̱ yilkeni jini suk ma̱n bi ji mbi kisti ɗa! ");
INSERT INTO gyz_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Ma̱jwisi wo sik ɗe ma̱n Yisra'ila. Si ka̱n Nya palla̱si ɗe mil jwasi, yek ta̱ mbokisi ang ten nalti gwasi, yek ta̱ dla̱lli ga̱ɓa gwas suksi, yek ta̱ ba̱lsi Mba̱t Ga̱ɓa ga̱ Musa, yek ta̱ mbokisi ang ten kangwe sa ngusit atli, ngusti atl ga̱ gem ka̱ lubii ga̱ Nya wu, yek ta̱ ba̱lsi naa alkawoli. ");
INSERT INTO gyz_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Sik ɗe mil ji ma̱n za̱t ji ma̱n za̱t ju ɗe mbala̱n yissi i'e wu. A Almasihu ka̱ da̱mti gwas ɗe mbala̱n wo, ti wo tet ka̱ ma̱n bi gwasa̱n ka̱n. Ha̱nta̱ Nya ma̱n iko ten mas wul ba pakti mbi ta̱sti. Amin. ");
INSERT INTO gyz_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ba̱ɗe we na̱kka̱n ga̱ɓa ga̱ Nya njika̱n so ka̱ so. Ten ɗe ba̱ mas ma̱jwe ɗe asali gwasa̱n ka̱ɗe ma̱n Yisra'la wu ka̱ɗe mbala̱n ji Yisra'la so. ");
INSERT INTO gyz_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","A ba̱ mas ma̱jwe sa̱ni ɗe ga̱z ga̱ Iba̱rahim wu ka̱ɗe mil ji Iba̱rahim ji gem so. Ka̱ lal ga̱ nu wo yek Nya hwi Iba̱rahim ɗe, <<Ishaku ka̱ɗe ma̱lgwe ɗe tumal ti ka̱n sa ci cina na̱ mbet ga̱ ma̱n ga̱z jwa wu.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Gwisi wo na̱ma mbokti ang ɗe mil jwe sa̱ wutsi na̱k kangwe a mbala̱n wut mil ju ka̱ɗe mil ji Nya so, mil jwe sa̱ mbisi tumal njika̱nti alkawol wu ka̱ɗe mil ji Iba̱rahim ji gem. ");
INSERT INTO gyz_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ten ɗe ilgwe Nya dla̱m wukgu ɗe ta̱ pi alkawol Iba̱rahim wu, <<Kume ɗe sa'isi pi wugo ba pali, a paa Saratu zi yen.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","A ba gwisi tokte ka̱ so, kaa yeni ɗa ten mil ji Rabeka jwe ɗe aba gwasa̱n wo ɗe na̱m ka̱n, a tik ɗe aba ga̱na̱n Ishaku wu. ");
INSERT INTO gyz_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","Ama tun a ba̱sa̱ ɓo wut gusa̱mi so, tun a ba̱sa̱ ɓo pa̱l hwa ilgon sogo byasi so, ten ɗe ta̱ ilgwe Nya lami ten bi ga̱ botlti wul pi ɗa, ");
INSERT INTO gyz_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ba̱ ɗe tumal ilgwe mbala̱n pa̱li wu ka̱ so ama tumal ma̱lgwe mbe Rebeka wu ɗe ta̱ wulti ɗe, <<Kakshesi a da̱m ɗe zhel ga̱ nak'enisi.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Na̱k kangwe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya wu ɗe <<A lam Yakubu yek a nge Isuwa.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","To, yek ma dla̱ma̱n ye? Ɗe Nya pa̱li ndakce so nwa? Wowo! Ko nja! ");
INSERT INTO gyz_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Ten ɗe Nya wul Musa ɗe, <<Ma̱lgwe ba kwet ang gaa go ba kwet ang gaa, A ma̱lgwe ba yen gonti gwas go, ba yen gonti gwasi.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Gwisi na̱ma mbokti ang ɗe lamti ga̱ mbala̱n ka̱ so aba̱ dlot gwas ka̱ so, ama ten bi kwot ang gaa ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Ten ɗe ga̱ɓa ga̱ Nya gwe sa̱ lishi wu wul Pir'auna ɗe, <<A tlilki ta̱k da̱m ɗe guu ten ɗe ta mbok ang ten iko gi tumalki, a sa̱ lak icin ten shin gini ko ako ten dii atli.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Na̱ na̱k gwisi ka̱n a Nya kwe ang gaa ma̱lgwe ta lamit kwot ang gaa wu, a ta̱ ka̱nga̱li mbadl ma̱lgwe ta̱ lamit ka̱nga̱lti mbadl ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Gon gwaka̱n a man wulti gi ɗe, <<Kume nuka̱n ni go, yek laki yek Nya yima lilti mbadl na̱ mi ye? Wok ka man nget ga̱ ilgwe Nya lami wu wo?>> ");
INSERT INTO gyz_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ama wok ɗe ki wo, ki mbala̱n? Ɗe hal ka̱ dla̱k ga̱ɓa suk Nya wu, <<Ilgwe sa̱ kin wu a mani wulti malgwe kinti wu ɗe, <Yek laki yek ka̱ pa̱la̱n na̱k ga̱n ye> nwa?>> ");
INSERT INTO gyz_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ai, ma̱n kinti cikɗa gulki wo iko ga̱ ta̱s pa̱l ilgwe ta̱ lami na̱ gulki wu niti ɗa. A ta̱ man kanti guda̱l gulki ɗe na̱m ata̱ kin cikɗa jon ten bi pa̱lti wul ma̱n nalti a jon wo ga̱ pa̱lti wul jwe ba̱ nalti nisi ɗa̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Pa̱lti wul ga̱ Nya wo nu ka̱nni, Nya lam mbokti ang ten lilti mbadl gwasi, ten ɗe ta̱ mbala̱n yen iko gwas ten dii. Ama yek ta̱ dlo mbadl i'e, yek ta̱ dlo bi na̱ ma̱jwe ta̱ za̱si ka̱ɗe ta̱s nolsi wu. ");
INSERT INTO gyz_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Nuk pak Nya lami ɗe ta̱s mbok ang ten nalti ga̱ nalti gwas ma̱jwe ta̱ kwesi ang gaa wu, ma̱jwe ta̱ za̱si ka tun tet ten ndat zhile ten ɗe ta̱s mbi nalti gwas wu. ");
INSERT INTO gyz_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ai, mik ɗe mbala̱n jwisi ma̱jwe ɗe Nya mbeni ba̱ɗe tet ka̱ ma̱n Yehuda ka̱ tokte so, ama hal suk ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu pak. ");
INSERT INTO gyz_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Na̱k kangwe sa̱ dla̱m ka̱ lishti ga̱ Hosiya wu ɗe, <<Si ma̱jwe ɗe ba̱ mbala̱n ji ka̱ sowu, ba mbesi ɗe <mbala̱n jini.> A mbala̱n jwe ɗe a lamsi sowu ba mbesi ɗe <ma̱ji lami jini,> >> ");
INSERT INTO gyz_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Yek sa̱ po lishi ɗe, <<Dap ka̱ lu gwe sa̱ mbesi ɗe, <Kii wo mbala̱n ji ka̱ sowu,> sa mbesi ɗe <mil ji Nya ma̱n mbadli.> >> ");
INSERT INTO gyz_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Nuka̱n ka̱n ten bi ga̱ ma̱n Yisra'ila Ishaya ma̱n dla̱mti ga̱ɓa ga̱ Nya tlil yal Nya yek ta̱ dla̱m ɗe, <<Ko ɗe wonti ga̱ mil Yisra'la, ni na̱k wonta̱t ga̱ yelsi ten bi bal ze wu, ama ma̱jwe sa njet tet ka̱si wu ka̱ɗe ma̱jwe sa mbi kisti wu. ");
INSERT INTO gyz_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Ten ɗe Bagaa a pa̱l nolti gwas ten mas dii atli ba̱le-ba̱le.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Na̱k kangwe Ishaya dla̱m ka̱ ga̱ɓa ga̱ Nya tek wu ɗe, <<Ɗe da kume Bagaa ma̱n nalti a zakini ma̱n ga̱z sowu, da ma da̱m na̱k Sodom, da sa palla̱ni na̱k Gomora.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","To, ningo yek ma ya dla̱ma̱n ye? Yekgu ma̱jwe ɗe ba̱ ma̱n yehuda ka̱ so, ma̱jwe ɗe ba̱ sa̱ ngo mbit da̱mti ɗe ma̱n pa̱lti wul ndakce mal Nya sowu, ama yek sa̱ mbi da̱mti ɗe ma̱n pa̱lti wul ndakce a cina ga̱ Nya. Pa̱lti wul ndakce gwe sa̱ mbi go wuda̱li gwe a mbala̱n mbi tumal nga̱sti ten Nya wu ka̱n, ");
INSERT INTO gyz_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ama ma̱n Yisra'la ɗe sa̱ ngo mbit da̱m ɗe ma̱n pa̱lti wul ndakce a cina ɗa̱ Nya ka, tumal Mba̱t ga̱ɓa Musa go yek ba̱sa̱ mi so. ");
INSERT INTO gyz_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","To, yek laki yek ba̱ sa̱ mbi so ye? Ten ɗe tumal nga̱sti ten Nya ka̱n sa̱ ngwe so, ama tumal pa̱lti wul gwasa̱n ka̱n sa̱ ngwe. Yek sa̱ kot asa̱n ten <<ye ma̱n lakti kotti asa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Na̱k kangwe ni lishi ka̱ ga̱ɓa ga̱ Nya wu ɗe, <<Yekgu, azi ye a Sihiyona, ye ma̱n lakti ga̱ mbala̱n ten kotti asa̱n Ye gwe a lak mbala̱n ten ndat wu, Ama mas ma̱lgwe nga̱sti tenti go nsha a cit so.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","To, yilkeni, ilgwe a lami mani go yek ɗe ta̱ ma̱n Yisraila mbi kisti. Ilgwe a ngemi mal Nya ten bi gwasa̱n wukgu. ");
INSERT INTO gyz_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Ba man ba̱lti sheda ɗe daka̱lti ga̱ ngusti atl Nya nisi ɗa, ama daka̱lti gwasa̱mi wo ba̱ɗe ka̱ yisti ka̱n asa̱ pa̱li so. ");
INSERT INTO gyz_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Tun na̱k ɗe ba̱sa̱ yis tantu ga̱ da̱mti ɗe ma̱n pa̱lti ndakce gwe yil sut mal Nya sowu, yek sa̱ lak tantu da̱mti ɗe ma̱n pa̱lti wul ndakce ga̱ gaa gwasa̱n gwe ni kak-kak suk ga̱ Nya wu, yek gwisi laki yek sa̱ nge kopti tantu pa̱lti wul ndakce ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ama Almasihu ka̱ɗe njika̱nti ga̱ mba̱t ga̱ɓa ga̱ Musa, ten ɗe ta̱ mas ma̱lgwe ba̱l gem na̱ti wu mbi da̱mti ɗe ma̱n pa̱lti wul ndakce a cina ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Musa pa̱l lishti ten wunda̱l ga̱ da̱mti ɗe ma̱n pa̱lti wul ndakce gwe a mbi dli tumal kopti Mba̱t Ga̱ɓa wu, ɗe ta̱ wule, <<Mas ma̱lgwe kop ilgwe Mba̱t Ga̱ɓe dla̱m go ta pa̱l da̱mti gwas tumal Mba̱t Ga̱ɓe.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Ama ilgwe ga̱ɓa ga̱ Nya dla̱m ten ma̱n pa̱lti wul ndakce tumal nga̱sti ten Nya wukgu, gwe wuli ɗe, <<Ba̱k dla̱m ka̱ mbadl gwa ɗe, <Wok ka to nya?> >> (Ten ɗe ta̱s shit Almasihu sut wo) ");
INSERT INTO gyz_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","<<sogo, aka̱ dla̱m ɗe, <Wok ka su ka̱ lu da̱mti ga̱ ma̱jwe ma̱sh wu?> >> (Ten ɗe ta̱s tlil Almasihu tot ɗa̱ka̱ ma̱jwe sa̱ ma̱sh wu so). ");
INSERT INTO gyz_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ilgwe ga̱ɓa̱ ga̱ Nya dla̱m go yek ɗe, <<Ga̱ɓa ga̱ Nya ni nja malki, ga̱ɓe ni ka̱ bi gwa suk ka̱ mbadl gwa.>> Ga̱ɓa gwisi ka̱ɗe ga̱ɓa ba̱lti gem gwe ma̱ na̱ma lakti icin dani wu. ");
INSERT INTO gyz_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Kume ɗe ka̱ dla̱m na̱ bi gwa ɗe, Yesu ka̱ɗe Bagaa, yek ka̱ ba̱l gem ka̱ mbadl gwa ɗe Nya tlilti tot ɗa̱ka̱ mashka̱n ka̱wu ka mbi kisti. ");
INSERT INTO gyz_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ten ɗe na̱ mbadl ka̱n a mbala̱n ba̱l gem asa̱ da̱mti ɗe ma̱n la̱shi byas wul a cina ga̱ Nya, a na̱ bi ka̱n a mbala̱n ba̱l sheda asa̱ mbi kisti. ");
INSERT INTO gyz_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Na̱k kangwe ga̱ɓa ga̱ Nya ga̱ lishi dla̱m wu ɗe, <<Mas ma̱lgwe ba̱l gem na̱ti go, nsha a cit so.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ten ɗe ilgon ni ɗa kak-kak ka̱ dlo ga̱ ma̱n Yehuda suk ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu so. Bagaa ɗe na̱m gwisi ka̱ɗe Bagaa ga̱ ko wokko, tik ɗe ma̱n lakti wonti albarka mas ma̱jwe asa̱ mbe shin gwas wu, ");
INSERT INTO gyz_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","na̱k kangwe ga̱ɓa ga̱ Nya ga̱ lishi dla̱m wu ɗe, <<Mas ma̱lgwe mbe shin ga̱ Bagaa wu ta mbi kisti.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Ama ɗa̱ni ka̱n sa mbe ma̱lgwe ɗe ba̱sa̱ nga̱ssi tenti sowu gwi? A ɗa̱ni ka̱n sa nga̱ssi ten ma̱lgwe ɗe ba̱sa̱ ɓo ta̱ɓa kumti ga̱ɓa tenti sowu gwi? A ɗa̱ni ka̱n sa kum ga̱ɓa tenti gwi ɗe ba̱ ma̱lgwe a lakisi icin tenti wu niɗa̱ sowu? ");
INSERT INTO gyz_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","A ɗa̱ni ka̱n ma̱n lakti icin ten a lak icin tenti gwi ɗe ba̱sa̱ shinsi sowu? Na̱k kangwe ni ga̱ lishi wu ɗe, <<Na̱ngo ten yek mbala̱n a cinga̱l mbunti ga̱ ma̱jwe asa̱ tulli ga̱ɓa ma̱n ta̱mti wu ye!>> ");
INSERT INTO gyz_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Ama mas ma̱n Yisra'la ka̱ kan ga̱ɓa ma̱n ta̱mti so. Na̱k kangwe Ishaya dla̱m wu ɗe, <<Bagaa, wok nga̱sti ten ga̱ɓa gwe ta̱ kumi tet bi ga̱na̱n go?>> ");
INSERT INTO gyz_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Ten na̱k gwisi ka̱n a nga̱sti ten Nya tul tumal kumti ga̱ɓa ma̱n ta̱mtisi, a mbala̱n kum ga̱ɓa ma̱n ta̱mti ga̱n tumal lakti icin ten ga̱ɓa ga̱ Almasihu. ");
INSERT INTO gyz_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ama yek a na̱ma kumti ga̱zi ɗe, Ɓohwe, gem na̱kka̱n sa̱ kum ga̱ɓe sa? Ai, sa̱ kumi wi. Ten ɗe ga̱ɓa ga̱ Nya ga̱ lishi wule, <<Yal dla̱mti ga̱ɓa gwasa̱n ngash mas dii atl wi, ga̱ɓa jwasa̱n mbuklu ten mba̱t ga̱ dii atli wi.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","A na̱ma kumti ga̱zi ɗa̱ ɗe. Ɓohwe na̱kka̱n ma̱n Yisra'raila yis gaami so nwa? Ai, ten ndat zhile wo Musa wuli ɗe Nya dla̱m ɗe, <<Ba lakkii ten daka̱lti na̱ mbala̱n ji alt gwe ba̱sa̱ ni ten bi ilgon sowu, tumal mbala̱n jwe ba̱sa̱ ɓotl sowu ka̱n ba laki, a cina gwel jwaka̱n docin ka.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Yek Ishaya pa̱l nda̱lli gahwula̱n hal yek ta̱ dla̱mi Nya ɗe, <<Ma̱jwe ɗe ba̱sa̱ ngo sowu, sik mbini. A yilli gaa gini, mal ma̱jwe ba̱sa̱ kum ga̱z ga̱ lu gwe ani wu sowu.>> ");
INSERT INTO gyz_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Ama ten ma̱n Yisra'ila wo, yek Nya dla̱m ɗe, <<A nda cin ten takti ang gi mbala̱n jwe ba̱sa kum bi sowu, suk ma̱jwe ba̱sa kum ga̱ɓa sowu.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Hwa̱nta ɓo ngemkii, ko na̱kka̱n Nya nge mbala̱n jwas ma̱n Yisrai'la na̱? Ko nja! Ami gaa gi wo ma̱n Yisra'ila ka̱ɗe ami, tet ka̱ ma̱n ga̱z ga̱ Iba̱rahim, tet ka̱ boo ga̱ Bilyaminu. ");
INSERT INTO gyz_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nya nge mbala̱n jwas jwe ta̱ botlsi tet ten ndat zhile wu so. Ka̱a̱ yis ilgwe ga̱ɓa ga̱ Nya ga̱ lishi dla̱m ten Iliya wu, gwe yek ɗe kangwe Iliya ta̱la kulu mal Nya ten bi ga̱ ma̱n Yisra'ila wu ɗe, ");
INSERT INTO gyz_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","<<Bagaa, sa̱ tlotl-tlo ma̱n dla̱mti ga̱ɓa jwa ka̱wi, yek sa̱ jek-jek bagadi jwa ka. Ami na̱ ngwe ka̱ ɓali, asa̱ na̱ma lamti tlot gi ka̱ pak.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ama yek ɗe ilgwe Nya ballit wu ye? Ta̱ ballit ɗe, <<A zi gaa gi mbala̱n ɗe zangu ɗe nitgi ka, ma̱jwe ɗe ba̱sa̱ ngus atli yek sa̱ pa̱li gunki ga̱ ba'al wul sowu.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nuka̱n ga̱mi ni hal na̱k ninge ma wu. Nak naa mbala̱n jwe Nya botlsi tumal alheri gwas wu yi ɗa̱ pak. ");
INSERT INTO gyz_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Botlti ga̱mi ɗe Nya pa̱li go tumal alheri gwas ka̱n, ba̱ɗe tumal palti wul jwe ɗe mbala̱mi pa̱li wu ka̱ so. Ten ɗe kume nu ka̱ sowu alherisi ɓo da̱m ɗe alheri so. ");
INSERT INTO gyz_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","To, ningo nik gwi? Ai, ma̱n Yisra'ila mbi ilgwe ɗe sa̱ na̱ma ngoti wu so. Seko nak njeti jon ɗe sa̱ botlsi ka̱si wu ka̱ mbi, ama naami wo yek sa̱ ka̱nga̱l mbadl jwasa̱n ka. ");
INSERT INTO gyz_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Na̱k kangwe ni ga̱ lishi wu ɗe, <<Nya laki yek sa̱ pal ɗe ma̱n la̱shi yisti gaa ga̱ wul ba̱le, yek ta̱ ba̱lsi gwel jwe ba̱ a yen lu sowu, suk ka̱ng jwe ba̱ sa kum ka̱ng ɗa̱ sowu. Gwisi wo nuka̱n ni hal yek la cin ga̱ se.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","A Dauda dla̱m ɗe, <<Hwa̱nta̱ biki gwasa̱n da̱misi ɗe tarko, ilgwe a laksi ten kumti cwo wu, Hwa̱nta̱ biki laksi ten kotti asa̱n a dla̱kisi nolti. ");
INSERT INTO gyz_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Hwa̱nta̱ gwel jwasa̱n duka̱n ka kangwe ɗe ba̱sa po man yenti lu sowu, a diɓa̱lti ga̱ bomti mansi ba pakti.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Hal ninge a yima kumti ga̱zi ɗa. Ɗe ma̱n Yisra'ila kot asa̱n yek sa̱ nda go sa po man tla̱nnya so nwa? Nuk'so! Ko nja! Ten bi ga̱ byas wul gwasa̱n ka̱n yek kisti mbuki mal ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu, ten ɗe ta̱ lak ma̱n Yehuda ten daka̱lti na̱si. ");
INSERT INTO gyz_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Ɗe hal kume byas wul gwe sa̱ pa̱li wu ka̱ tulli albarka dii atl wu, a ɗe kume la̱shi nda̱lti gwasa̱n ka̱ tulli albarka ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu go, to, ni ka̱n nalti ga̱ albarke ani gwi ɗe kume wonta̱t ga̱ ma̱n Yisra'la njika̱n wu? ");
INSERT INTO gyz_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Ningo sukkii ɗe ba̱ ma̱n Yehuda ka̱ sowu ka̱n a na̱ma ga̱ɓa. Tun na̱k ɗe ami wo yen shinti ga̱ Yesu ka̱n, mal ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu, ba nak ɓo ngetl na̱ pa̱lti wul gi ge. ");
INSERT INTO gyz_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Tumal pa̱lti na̱k gwisi ka̱n a na̱ma za̱t mbadl ɗe ta man lakti ji mbala̱n jini ma̱n Yisra'la ten daka̱lti, hal a laki asa̱ kis jon jwasa̱n. ");
INSERT INTO gyz_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kume ɗe hal nget gwe sa̱ ngesi wu ka̱ da̱m ɗe wul ɓulti tantu la̱ka̱nti dlo ga̱ dii atl suk Nya wu go, yek ɗe ilgwe a pi gwe ɗe kume sa̱ ɓa kansi wu? A she gwisi wo a da̱m ɗe tantu mbit mbadl tot ɗa̱ka̱ ma̱shka̱n ka̱n ka̱ sa? ");
INSERT INTO gyz_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Kume ɗe sa̱ botl ka̱ti ɗe na̱m ga̱ ba̱redi ga̱ gwe wul gwe no cina wu tumal takti Nya go, sa̱ botl mas ba̱redisi ɗe ma̱n cilti wi. A kume ɗe sa̱ botli Nya tla̱lki tlindi go, sa̱ botl mas mil ang ji tlindi yek da̱m ɗe ma̱n cilti wi. ");
INSERT INTO gyz_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Na̱k gwisi ka̱n kume ɗe sa̱ taki Nya tla̱lki ga̱ tlindi wugo ai mas suk mil ang tlindi mago ɗe gwas ka̱ ɓali. Ten na̱k gwisi ka̱n sa̱ wotl naa mil ang ji hwa tlindi zaitun ka̱ wi, yek sa̱ wotl mil ang ji tlindi ga̱ zaitun ga̱ me teɗi, yek sa̱ ɓal mil ang ji tlindi ga̱ memi ten hwa tlindisi. Kii ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu, na̱k mil ang ji tlindi zaitun ga̱ me ka̱n ka̱ni, kii ka̱n sa̱ ɓalkii ten tlindi gwe sik ɗe ma̱n Yehuda ma̱jwe tumalsi ka̱n aka̱a̱ ngusi mbit albarka ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ten na̱k gwisi ka̱n ba̱k ɓo ngetl ten ɗe ka̱a̱ man mil ang ji hwa tlindi ɗe sa̱ wotl ka̱wu so. A kume ɗe ka̱a̱ na̱ma ɓot ngetl go, se ta̱k daami ɗe tlindi ka̱n sa̱ ɓal ten mil ami so, ama mil ami ka̱n sa̱ bal ten tlindi. ");
INSERT INTO gyz_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ama ka man dla̱mti ɗe <<Ai, sa̱ wotla̱n mil ami ka ka̱n, ten ɗe ta̱s man ɓalti gi ten tlindi ɗa.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Yii, nuka̱n ni! Ama ai la̱shi nga̱sti ten Nya ka̱ɗe ilgwe laki yek sa̱ wotlsi ɗa̱ ten tlindi ka̱wu, ki ne go nga̱sti ten Nya gwa ka laki aka̱ ci cina na̱ da̱mti ga̱ ɓali ka ten tlindisi. Ten na̱k gwisi ka̱n ba̱k ɓo ngetl so, ka̱ lal ga̱ nu wo ta̱ ɓanti ciki. ");
INSERT INTO gyz_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ten ɗe kume hal Nya zak mil ami jwisi ɗe sik ɗe mil ang ji hwa tlindi wu sowu, ki mago ta zakki so pak. ");
INSERT INTO gyz_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","A duk go ma mana̱n yenti hwa wul suk ngapti ga̱ Nya. Ta̱ mbok ang ten ngapti gwas ten ma̱jwe sa̱ nda wu, ama yek ta̱ mbok ang ten pa̱lti hwa wul gwas tenki, ɗe ka̱ ci cina na̱ da̱mti ka̱ pa̱lti hwa wul gwas wu. A kume ka̱ cina na̱ da̱mti nu sowu, ki mago ta̱ wotlki ɗa̱ ten tlindi ka̱ pak. ");
INSERT INTO gyz_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Ɗe kume ɗe hal ma̱n Yisra̱'ila ci cina na̱ da̱mti ka̱ la̱shi nga̱sti gwasa̱n ten Nya sowu, ta saka palla̱t gwasa̱n ten tlindi ten ɗe Nya aya man palla̱t jwasa̱n ten tlindi ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Kii ɗe ba̱ ma̱n Yehuda ka̱ sowu, na̱k tlindi zaitun ga̱ me ka̱n kani gwe ɗe sa̱ wotl tet wugo, yek sa̱ ɓal ten hwa tlindi zaitun wu. Ko ɗe ba̱ mbala̱n a pa̱li nu so, na̱k ɗe tlindi jwisi tla kak-kak wu. To, tun na̱k ɗe ma̱n Yehuda wo sik ni na̱k mil ang ga̱ hwa zaitun wu, a da̱mi Nya ɗe ilgwe ba̱ bom sowu mani ta̱s palla̱si ten hwa tlindi lisi. ");
INSERT INTO gyz_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Yilkeni jini, a lami ɗe ta̱k da̱ma̱n ka̱ la̱shi yisti gaa ga̱ wul jin ɗe ni ga̱ hwunda̱li ka̱wu so, ten ɗe ba̱k kama̱n gaa gwaka̱n ɗe ma̱n botlka̱n yisti wul ka̱ɗe kii so. Mbadl ka̱nga̱li ma̱n Yisra'ila jon ka, hal se wonta̱t ga̱ ma̱jwe ɗe ba̱ ma̱n Yehuda ka̱ so jwe ɗe sa mbi tulti mal Nya wu njika̱n. ");
INSERT INTO gyz_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Na̱ nuka̱n sa kis mas ma̱n Yisra'ila. Na̱k kangwe ni ga̱ lishi wu ɗe, <<Ma̱n kisti a yil tet Sihiyona. Ta kan mas la̱shi kopti ga̱ Nya ɗa̱ka̱ ma̱n ga̱z ga̱ Yakubu ka. ");
INSERT INTO gyz_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ga̱mi ka̱ɗe dla̱lla̱t ga̱ɓa gi suksi, ka̱ sa'i gwe ɗe ba kamisi byas wul jwasa̱n ka̱wu.>> ");
INSERT INTO gyz_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ten ɗe nget ga̱ɓa ma̱n ta̱mti ɗe ma̱n Yehuda nge wu ka̱ laki yek sa̱ da̱m ɗe yela̱n dlanti ji Nya. A kii nego, kiik mbi riba ga̱ pa̱lti na̱k gwisi. Ama ten bi botlti gwe sa̱ pa̱lisi go, si wo mbala̱n jwe Nya na̱ma lamti gwasa̱n wu ka̱n. A gwisi wo ten bi albarka ga̱ ma̱n za̱t ga̱ ma̱n za̱t jwasa̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ten ɗe ba̱lti wul ga̱ Nya suk mbet gwas wo wul jwe Nya a dla̱k ka̱wu ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Tek go kii ɗe ba̱ ma̱n Yehuda ka̱ so go ma̱n la̱shi kumti bi Nya ka̱n, ama ningo Nya kwekii ang gaa wi tumal la̱shi kumti bi ga̱ ma̱n Yehuda. ");
INSERT INTO gyz_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nuka̱n ningo ma̱n Yehuda mago sa̱ da̱m ɗe ma̱n la̱shi kumti bi Nya wi. Gwisi wo ten ɗe ta̱s mbi kwot ang gaa tumal kwot ang gaa gwe ɗe Nya kwekii wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ten ɗe Nya palli mas mbala̱n na̱k ma̱jwe sa̱ni ga̱ le ka̱wu ka̱ lashi kumti bi jwasa̱n. Ta̱ pa̱li nuka̱n ten ɗe ta̱s kwe ang gaa mas jwasa̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ɓo daama̱nkii ten wonta̱ti suk dlunta̱t ga̱ botlka̱n yisti wul ga̱ Nya, tlunta̱t ga̱ yisti wul gwas wo mba̱t nitɗa̱ so! Kisti ga̱ɓa jwas wo man ngetl ga̱ ɓodla̱lti wul ga̱ mbala̱n! Tantu pa̱lti wul jwas wo mbala̱n a yis gaami dani so. ");
INSERT INTO gyz_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","<<Wok ta̱ɓa yisti daamti ga̱ mbadl ga̱ Bagaa wo? Sogo wok taɓa da̱mti ɗe yela̱n dla̱mti ga̱ɓa gwas wo?>> ");
INSERT INTO gyz_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","<<Wok ta̱ɓe ba̱lti ilgon Nya wo? gwe da̱mit ɗe ngetli ka̱n ta̱s pallit wu?>> ");
INSERT INTO gyz_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ten ɗe tik pa̱l mas wul, a mas wul jin jo tumalti ka̱n sa̱ pi suk ten bi gwasi. Hwa̱nta̱ nalti da̱m ɗe ga̱ Nya ba pakti! Amin. ");
INSERT INTO gyz_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ten na̱k gwisi ka̱n a na̱ma ngemti gwaka̱n yilkeni jini ten bi ga̱ wonta̱t ɗa̱ kwot ang ga̱ Nya, ta̱ka̱n gaa jwaka̱n ɗe sadaka gwe asa̱ taki Nya wu, wul ma̱n mbadli, gwe sa̱ zi ka̱ wu. Gwisi wo yek ɗe wunda̱l ga̱ sadaka gwe a Nya kan wu, a yek ɗe tantu gwe kaa pa̱li Nya wul ga̱ gem wu. ");
INSERT INTO gyz_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Ba̱k pa̱nta kopti kangwe a dii atl ge pa̱l wul wu so, ama zakini ta̱ Nya balli ata̱ palli daamti ga̱ mbadl jwaka̱n pyali. Pa̱lti nu a laki a ka̱a̱ yis gem ga̱ ilgwe ɗe Nya lami wu, gwe yek ɗe ilgwe ni hwaɓi, suk ilgwe Nya a kami suk ilgwe ni njikmi wu pak. ");
INSERT INTO gyz_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Tumal alheri ga̱n ɗe sa̱ pa̱li wu ka̱n a nima da̱lti ka̱ng mas jwaka̱n ten ɗe ba̱ ma̱lgon kan gaa gwas na̱ nalti ta̱ ma̱n kangwe mbun ɗe ta̱s pa̱li wu so. Ka̱ lal ga̱ pa̱lti nu wo ta̱ ko wokko pi ɗem-ɗem na̱ kangwe ata̱ palli gaa gwas wu, gwisi wo yek ɗe ta̱s ngusi yenti gaa gwas ndakce suk wunda̱l ga̱ nga̱sti ten Nya gwe Nya ba̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Ka̱t dli nini ɗa wonti ten dli ɗe na̱m a mas ka̱t dli jwisi wo ko gwik-gwi na̱ ilgwe ɗe ata̱ pa̱li wu kak-kak suk ga̱ yilka. ");
INSERT INTO gyz_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nuka̱n ni, ko ɗe wonti mbala̱n ka̱ɗe mi wu, ma̱ da̱ma̱n ɗe dli ɗe na̱m wi ka̱ Almasihu, a ko wokko ga̱na̱n wo, ka̱t dli ga̱ yilka gwas ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Na̱k ɗe wunda̱l ji ba̱lti wul jwe sa̱ bla̱la̱nni wu ni kak-kak ndakce ten na̱lti ga̱ alheri gwe Nya pa̱lini wu se ta̱n pa̱la̱n wul na̱ nali. Kume ɗe sa̱ ba̱la̱nni manti dla̱mti ga̱ɓa ga̱ Nya go ama̱ dla̱ma̱n ndakce suk nga̱sti ten Nya ga̱na̱n. ");
INSERT INTO gyz_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","A ma̱lgwe ba̱lti wul gwas wo ga̱ pa̱lti wul mbala̱n ka̱wu se ta̱s pa̱lisi wul. A kume ga̱ mbokti ang ten wul ka̱wu, ta̱s mboka̱n ang ten wul. ");
INSERT INTO gyz_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","A kume ɗe ga̱ nda̱lla̱t gahwula̱n mbala̱n ka̱wu, ta̱s ngusi nda̱lla̱t gahwula̱n mbala̱n. A kume ɗe ga̱ za̱t ang mbala̱n ka̱wu, ta̱s pa̱li nu na̱ mbadl ɗe na̱m. A kume ɗe ga̱ da̱mti ɗe bacina ka̱wu ta̱s dlot ten da̱mti na̱k gwisi. A kume ɗe ga̱ yenti gonti ka̱wu, se ta̱s pa̱li nu na̱ hwol tuki. ");
INSERT INTO gyz_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Mbun ɗe ta̱ lamti gwaka̱n ni ɗe ga̱ gem. Nge mas ilgwe ni ɗe nga̱lci wu, ama giɓa̱n ilgwe ni ɗe hwaɓi wu na̱ nda̱lti i'e. ");
INSERT INTO gyz_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Hwota̱ndli na̱ yilkeni jwaka̱n ka̱ lamti, wunda̱l ga̱ lamti gwe a ma̱n kopti pa̱li wu. To, ta̱ ko wokko ba̱l yilka gwas nalti ba̱le-ba̱le man kangwe ata̱ ba̱l gaa gwas wu. ");
INSERT INTO gyz_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Ba̱k da̱ma̱n ɗe ma̱jwe ba̱sa dlosi ten wul sowu so, ama kama̱n ka̱ mbadl jwaka̱n i'e ɗe kaa dlokii ten pa̱lti wul ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Pa̱la̱n hwol tuk ka̱ za̱t mbadl gwaka̱n, aka̱a̱ dlo mbadl ka̱ tlat bomti, aka̱a̱ pa̱l gem ka̱ ngemti Nya gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","A ka̱a̱ ngusi hwulti ilgwe nikii ɗa̱ wu suk mbala̱n ji Nya ma̱n la̱shi wul. A ka̱a̱ ngusi kanti ga̱ ma̱nda̱ki ka̱ lubii jwaka̱n na̱ ang ɗe lop. ");
INSERT INTO gyz_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Laki ma̱jwe ɗe asa̱ cikii dlelngapcan wu albarka. Lakisi albarka ba̱k pa̱lisi bi gaa so. ");
INSERT INTO gyz_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Pa̱la̱n hwol tuk suk ma̱jwe sa̱ na̱ma pa̱lti hwol tuk wu, pa̱la̱n duu tuk suk ma̱jwe na̱ma pa̱lti duu tuk wu. ");
INSERT INTO gyz_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Pa̱la̱n ta̱mi da̱mti suk yilkeni jwaka̱n. Ba̱k ɓo ngetl na̱ gaa jwaka̱n so, ama palla̱n gaa jwaka̱n ɗe yela̱n ji ma̱jwe ɗe ba̱sa̱ kansi ten bi ilgon sowu. Ba̱k kama̱n gaa jwaka̱n na̱k wule ka̱a̱ ɓotla̱n man naa mbala̱n so. ");
INSERT INTO gyz_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Kume ma̱lgon pa̱likii ngalci wu ba̱k palliti ami so. Da̱ma̱n na̱ ka̱ng gaa ta̱k pa̱la̱n wul jwe ɗe mas mbala̱n a yeni asa̱ dla̱m ɗe ndakce ka̱n ka̱a̱ pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Dloka̱ma̱nkii i'e, ɗe ma̱n pa̱t ka̱ go pa̱la̱n ta̱mi da̱mti suk mas mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Ba̱k da̱ma̱n ɗe ma̱jwe asa̱ palli ang byas wul wu so, yilkeni jini zakini ta̱ Nya pallisi ami ka̱ lilti mbadl gwasi. Ten ɗe ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <<Palla̱t ang wul wo gi ka̱n, amik ka pallli ami,>> in ji Bagaa. ");
INSERT INTO gyz_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Ga̱ɓa ga̱ Nya ga̱ lishi dla̱m ɗa̱ ɗe, <<Kume kuza̱n na̱ma tlot ga̱ yela̱n dlanti gwa go, ba̱lti ilga̱ nguki, a kume ɗe ka̱lka̱ze na̱ma tlot gwas go ba̱lti ze ga̱ tle. Pa̱lti na̱k gwisi a laki a nsha citi.>> ");
INSERT INTO gyz_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Ba̱k zakini ta̱ nga̱lci ci ba̱n tenkii so, ama ka̱ lal ga̱ nu wo cin ba̱n ten nga̱lci tumal pa̱lti hwa wul. ");
INSERT INTO gyz_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ngetli ka̱n ta̱ ko wokko kumi bi bacina ji gobnati, ten ɗe iko da̱mti ɗe bacina gon niɗa̱ so, seko gwe yil sut mal Nya wu. A mas lugwe ɗe bacina niɗa̱ go Nya ka̱ laksi. ");
INSERT INTO gyz_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ten na̱k gwisi ka̱n mas ma̱lgwe nge kumti bacina ga̱ gobnati go, ilgwe Nya lak wu ka̱n ta̱ nitma nget kumti bi. A ma̱n pa̱lti na̱k gwisi wo gaa jwasa̱n ka̱n sa̱ nisi ma dla̱kti nolti. ");
INSERT INTO gyz_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Ten ɗe bacina ji mbala̱n ni ɗe wul cit ɓanti mal ma̱n pa̱lti wul ndakce so, ama si wo wul cit ɓanti ka̱n mal ma̱jwe asa̱ pa̱l ilgwe ba̱ yek sowu. Ka̱ na̱ma lamti ɗe ta̱k hwulki na̱ ɓanti ga̱ ma̱lgwe ni ɗe bacina wu nwa? To, se ta̱k pa̱l ilgwe ɗe ni ndakce wu, ti nego ta ta̱ski, ");
INSERT INTO gyz_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ten ɗe bacina wo ma̱n pa̱lti wul ga̱ Nya ka̱n ten ɗe ta̱s pa̱lik hwa wul. Ama ɗe kume ki wo ma̱n ngalci ka̱ wu, se ta̱k ɓantiti, ten ɗe ten koo lu ka̱n bacine ngip bal puka ndoka̱lti ga̱ɓa ka̱ ang gwas so. Ti wo ma̱n pa̱lti wul ga̱ Nya ka̱n, a tumalti ka̱n a Nya mbok ang ten lilti mbadl gwasi a ta̱ nol ma̱n ngalci. ");
INSERT INTO gyz_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ten na̱k gwisi ka̱n ngetli ka̱n ta̱k kumi bi bacina ji gobnati. Ba̱ɗe ten ɗe ta̱k aɓi lilti mbadl ga̱ Nya tokte ka̱ so, ama ten ɗe ta̱ daamti wul ga̱ mbadl gwaka̱n mbok ang ɗe ka̱a̱ pa̱l byas wu so. ");
INSERT INTO gyz_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","A ga̱misi ka̱ɗe ilgwe laki a ka̱a̱ ɓatl wulpi boo wu, ten ɗe bacina ji gobnati wo ma̱n pa̱lti wul ji Nya ka̱n, ma̱jwe ɗe asa̱ ba̱l mas sa'i gwasa̱n ten bi pa̱lti wul ga̱ bacine wu. ");
INSERT INTO gyz_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ɓatla̱n ko wokko dul gwe ɗe sa̱ na̱ma kopti gwaka̱n wu. Ɗe kume wulpi boo gwe nikii gaa wu ka̱ mbun ɗe ta̱k ɓatla̱n go se ta̱k ɓatla̱nni, a kume ɗe wulpi boo ga̱ wul ji wuli ka ka̱wu se ta̱k ɓatla̱nni. Ɓanti ma̱lgwe mbuki ɗe ta̱ ɓantit wu, aka̱a̱ ba̱l nalti ma̱lgwe mbuki ɗe ta̱k ba̱la̱nti nalti wu. ");
INSERT INTO gyz_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ba̱k ngiɓi dul ma̱lgon ka̱ so, seko dul gwe ɗe da̱mikii ngetli ɗe ta̱k ngiɓi wu, gwe yek ɗe dul ga̱ lamti ji yilkeni jwaka̱n wu, ten ɗe ma̱lgwe na̱ma lamti ga̱ ma̱lgon go ta̱ njika̱n ilgwe Mba̱t Ga̱ɓa ga̱ Musa dla̱m wu wi. ");
INSERT INTO gyz_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Mba̱t ga̱ɓa jwe yek ɗe, <<Ba̱k pi suk zobsi kili gon ka̱ da̱mti gwa ga̱ ma̱n hapti so, ba̱k tlo mbala̱n so, ba̱k pi muka̱l so, ba̱k ko gwel so,>> suk mas naa mba̱t ga̱ɓa jwe sa̱ni ɗa̱ wu, ma̱s jwasa̱n mbi njika̱ntidli ka̱ ga̱ɓa gwe ɗe dla̱m ɗe, <<Lam yela̱n da̱mti gwa na̱k kangwe ka̱ lam gaa gwa wu.>> ");
INSERT INTO gyz_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Ɗe kume ka̱ lam mbala̱n go ka taɓet pa̱lti ngalci so. Ten na̱k gwisi ka̱n lamti ka̱ɗe njika̱nti ga̱ Mbat Ga̱ɓa ga̱ Musa. ");
INSERT INTO gyz_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","To, pa̱li nu ten ɗe ka̱a̱ yis gaa ga̱ wunda̱l ga̱ sa'i ga̱n ɗe ma̱na̱n giɓi wu wi. Sa'i gwe ɗe kaa pa̱da̱l tet yemba̱l wu pa̱li wi, ten ɗe sa'i gwe sa kissa̱nni wu ɓal nja na̱k ninge man sa'i gwe ma̱ cin atl gaa wu. ");
INSERT INTO gyz_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Gas ɓal nja ta̱ paki ka, a sa'i njet ka̱ ɓali ta̱ lu tlo. Ten na̱k gwisi ka̱n se ta̱n wuta̱n pa̱lti wul ji da̱mshal ka, ta̱n kina̱n wul dlanti jina̱n ji cilti. ");
INSERT INTO gyz_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Hwa̱nta̱n pa̱la̱n da̱mti ga̱ hwa wul kangwe ni ndakce suk mbala̱n jwe ɗe sa̱ na̱ma da̱mti ga̱ cilti wu, ba̱ɗe na̱ pa̱lti biki tlati-tlati, suk tlatdli, suk pa̱t pa̱la̱n suk lamti kumti ta̱mti ga̱ la̱shi nsha, suk dlanti, suk daka̱lti so. ");
INSERT INTO gyz_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ama ka̱ lal ga̱ pa̱lti nu wo se ta̱k kama̱n pa̱lti wul ga̱ Bagaa Yesu Almasihu ta̱ da̱mikii na̱k luka̱l, ba̱k kama̱n pa̱lti wul ga̱ dli ga̱ mbala̱n gwe ɗe a lakkii ten pa̱lti ilgwe ta̱ lami wu so. ");
INSERT INTO gyz_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Kama̱n ma̱lgwe ɗe nga̱sti ten Nya gwas nda̱l sowu, ba̱k cala̱n ga̱ɓa sukti ten wul jwe ɗe daamti ji mbala̱n ni kak-kak a dani wu so. ");
INSERT INTO gyz_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Nga̱sti ten Nya ga̱ ma̱lgon kamit ɗe ta̱s nguk mas ilgwe ta̱mit ɗa̱ wu, ama ma̱lgwe ɗe nga̱sti ten Nya gwas nda̱l so go wul lambu suk yandi ji tlindi tokte ka̱n ata̱ nguki. ");
INSERT INTO gyz_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ma̱lgwe ɗe ata̱ nguk mas wunda̱l ilga̱ nguki go, ba̱s mbul ma̱lgwe ɗe ti wo ba̱ta nguk wuli jon sowu so. A nuka̱n ma̱lgwe ɗe ba̱ta nguk wunda̱l ga̱ wul ji nguki jon sowu ba̱s zi byas wul gaa ma̱n ngukti mas wunda̱l ji wul ga̱ nguki so ten ɗe Nya kanti wi. ");
INSERT INTO gyz_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Wok ɗe ki wo ɗe hal ka̱ zi byas wul gaa zhel ga̱ ma̱lgon wu? Ɗe kume zheli pa̱l hwa wul sogo byasi go, ai, ze ga̱ baboo gwas ka̱n. Gem sa nda̱llit gahwulan ɗe ta̱s dla̱lnya, ten ɗe Bagaa a man lakti gwasi ata̱ ci ba̱n. ");
INSERT INTO gyz_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ma̱lgon wo ata̱ yen cin gon ɗe zoki man naa cin. A mal ma̱li gon wo mas cin wo ɗe na̱m ka̱n ni. Ta̱ ko wokko mbi gem ga̱ mbunti ga̱ ilgwe ta̱ kan wu ka̱ mbadl gwasi. ");
INSERT INTO gyz_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Mas ma̱lgwe ata̱ yen cin gon ɗe zoki go, ta̱ na̱ma pa̱lti nuka̱n ten ɗe ta̱ Bagaa mbi nalti ɗa. Mas ma̱lgwe ɗe ata̱ nguk mas wunda̱l ga̱ ilga̱ nguki go ta̱ na̱ma pa̱li nuka̱n ten ɗe ta̱ Bagaa mbi nalti, ten ɗe ata̱ pi godiya Nya ten ilga̱ ngukisi. A mas ma̱lgwe ɗe ba̱ta nguk wunda̱l ji wul ji nguki jon sowu mago ata̱ pa̱li nuka̱n ten ɗe ta̱ Bagaa mbi nalti ten ɗe ti mago ata̱ pi godiya Nya. ");
INSERT INTO gyz_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","A ka̱ mi wo ba̱ɗe ten bi ga̱ mbit wul ga̱ gaa gwas ka̱n ma̱lgon na̱ma da̱mti so. A ba̱ ten bi mbit wul ga̱ gaa gwas ka̱n ata̱ ma̱sh so. ");
INSERT INTO gyz_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Ɗe kume ma̱ nima da̱mti wu, ten bi ga̱ Bagaa ka̱n ma̱ na̱ma da̱mti, a ɗe kume ma̱shka̱n ka̱n ma ma̱sha̱n ma wu, ten bi ga̱ Bagaa ka̱n ma ma̱sha̱nni. Ten na̱k gwisi ka̱n ko da̱mti ka̱n ma̱ na̱ma da̱mti sogo ma̱shka̱n ka̱n ma̱ ma̱shi, mi wo ga̱ Bagaa ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Ten ɗe Almasihu ma̱shi yek ta̱ tlinya na̱ mbadli ten ɗe ta̱s da̱m ɗe Bagaa ga̱ ma̱jwe sa̱ ma̱sh wu suk ma̱jwe sa̱ yi kami wu. ");
INSERT INTO gyz_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Ki pa, yek laki yek ka̱ na̱ma yenti ga̱ yilka na̱ byas wul gaa ye? A ki nego yek laki yek ka̱ na̱ma mbulti ga̱ yilka gwa ye? Mas jina̱n ma dla̱lla̱n a cina ga̱ gobdlan kisti ga̱ɓa ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Ten ɗe sa̱ lishi ka̱ ga̱ɓa ga̱ Nya ga̱ lishi ɗe, <<Gem na̱k ɗe amik ɗe Nya Bagaa ma̱n ba̱lti mbadl wu, a dla̱m ɗe, <gahwula̱n mas a ngus atl a cina gini, a la̱ka mas a ba̱l sheda ɗe amik ɗe Nya.> >> ");
INSERT INTO gyz_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","To, ko wokko ga̱na̱n a dla̱m wul ten bi ga̱ da̱mti gwasi a cina ɗa̱ Nya ka. ");
INSERT INTO gyz_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ten na̱k gwisi ka̱n se ta̱n zaki kisti ga̱ɓa yilkeni jina̱n. Ka̱ lal ga̱ nu wo, ta̱k ko wokko zi ka̱ mbadl gwas ten ɗe ta da̱mi yilka gwas ɗe wul kotti asa̱n so. ");
INSERT INTO gyz_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","A yisi, a kan ɗe gem ka̱n ka̱ Bagaa Yesu wo ilgon gwe ɗe asali gwas wo ɗe wul cit daɗe ka̱wu niɗa̱ so. Ama ɗe kume ma̱lgon kan ilgon ɗe wul cit daɗe wu, to, a malti ka̱n ili ni ɗe wul cit daɗe. ");
INSERT INTO gyz_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Ɗe kume a ilga̱ nguki gwa lak yilka gwa ten hwottidli go, da̱mti ga̱ lamti ka̱n ka̱ na̱ma pa̱lti so. Ba̱k zaki ta̱ ilgwe aka̱ nguk wu da̱m ɗe tantu lilti ga̱ yilka gwa gwe Almasihu ma̱sh ten bi gwas wu so. ");
INSERT INTO gyz_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ba̱k zak ilgwe ni hwaɓi a malki wu ta̱ da̱m ɗe ilgwe mbala̱n a dla̱m byas ga̱ɓa dani wu so. ");
INSERT INTO gyz_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Ten ɗe Nya ɗe guu ga̱ wo ga̱ɓa ten bi ga̱ nguki suk tlati ka̱ so, ama ga̱ɓa ten bi ga̱ pa̱lti wul ndakce, suk ta̱mi da̱mti, suk hwol tuk tumal Shishi ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","A mas ma̱lgwe ɗe ata̱ ngusi atl Almasihu tu ten tantu ga̱mi go, ti wo ma̱n pa̱lti ilgwe Nya lami wu ka̱n, a ma̱n mbit kantidli ka̱n mal mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ten na̱k gwisi ka̱n se ta̱n dloka̱ma̱nni ten ɗe ta̱n pa̱la̱n ilgwe a tulli ta̱mi da̱mti suk nda̱lla̱t gahwula̱n ga̱ yilkeni jina̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Ba̱k lila̱n pa̱lti wul ga̱ Nya ka ten bi ilga̱ nguki so. Gem mas ilga̱ nguki wo hwaɓi ka̱n, ama byas wul ka̱n ɗe kume a ilgwe asa̱ nguk wu da̱mi ma̱lgon ɗe wul kotti asa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","A mbun mani ɗe ba̱k nguk tlu so, sogo ba̱k tla ze inabi so, sogo ba̱k pa̱l mas wunda̱l ga̱ wul so, ɗe kume a laki a yilka nda wu. ");
INSERT INTO gyz_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Ha̱nta̱ daamti ga̱ mbadl gwa ten bi ga̱ wul jin sa ka̱ dlo gwa suk Nya. Ma̱n albarka ka̱ɗe ma̱lgwe mbadl gwas lakti ɗe byas wul ka̱ sowu, ten bi ga̱ ilgwe ɗe ti na̱ gaa gwas ka̱ kan ɗe ndakce ka̱n ni wu. ");
INSERT INTO gyz_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ama ma̱lgwe mbadl nitma tatlti ten ilgwe ta̱ na̱ma ngukti go, ta̱ nima dla̱kti gaa gwas nolti ga̱ Nya ɗe kume ta̱ nguk wu, ten ɗe ka̱ il gwisi ɗe ta̱ na̱ma pa̱lti go ta̱ nga̱sti ten Nya so. A mas ilgwe mbala̱n pa̱li ɗe ba̱ tumal nga̱sti ten Nya ka̱ sogo byas wul ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Mi ɗe ma̱ nda̱la̱n ka̱ nga̱sti ten Nya ga̱na̱n wu, a mbun ɗe ta̱n dlo mbadl na̱ la̱shi nda̱lti ga̱ ma̱jwe ɗe ba̱ nga̱sti ten Nya gwasa̱n nda̱l sowu, ten ɗe ta̱n zisi ang ka̱ la̱shi nda̱lti gwasa̱n, ba̱n pa̱la̱n wul ten ɗe ta̱n kumi ta̱mti gaa ga̱na̱n so. ");
INSERT INTO gyz_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Hwa̱nta̱ ko wokko ga̱na̱n pa̱l ilgwe a ta̱mi yilka gwas mbadl wu ten ɗe ta̱ yilke mbi wul, ata̱ mbi za̱t ang ka̱ nga̱sti ten Nya gwasi. ");
INSERT INTO gyz_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Ten ɗe kota̱ Almasihu gaa gwas ka̱ da̱mti gwas wo ta̱ pa̱l wul ten ɗe ta̱s kumi ta̱mti gaa gwas ka̱ da̱mti gwas so. Na̱k kangwe ni ga̱ lishi wu ɗe, <<Byalti jwe ɗe sa̱ na̱ma byalti gwa wu nda tena̱nni.>> ");
INSERT INTO gyz_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ten ɗe mas wul jwe sa̱ lishi tun teka ka̱ Ga̱ɓa ga̱ Nya ga̱ Lishi go, sa̱ lishi ka̱n ten ɗe ta̱s mbokini ang ten wul, kangwe ɗe ma da̱ma̱n na̱ za̱t mbadl tumal dlot bi suk nda̱li gahwula̱n gwe a Ga̱ɓa ga̱ Nya ga̱ Lishi ba̱lla̱nni wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Hwa̱nta̱ Nya ma̱n ba̱lti dlot bi suk nda̱li gahwula̱n lakkii ten dlot mbadl na̱ yilkeni jwaka̱n ka̱ sa'i gwe ka̱a̱ na̱ma kopti lal ga̱ Almasihu Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Na̱ nuka̱n mas jwaka̱n kaa da̱m na̱ bi ɗe na̱m suk daamti wul ɗe na̱m, aka̱a̱ na̱ma nalla̱t ɗa̱ shin ga̱ Nya ti ɗe tik ɗe Aba ga̱ Bagaa ga̱na̱n Yesu Almasihu wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Ngiɓa̱n yilkeni jwaka̱n na̱ ang ɗe lop na̱k kangwe ɗe Yesu Almasihu kankii na̱ ang ɗe lop wu, ten ɗe ta̱k lakini a mbala̱n ba̱l nalti Nya ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","A mik ka hwikii ge, ɗe ilgwe laki yek Almasihu da̱m ɗe ma̱n pa̱lti wul ga̱ ma̱n Yehuda go yek ɗe ten ɗe ta̱ mbok ang ten gem ga̱ ga̱ɓa ga̱ Nya, asa̱ mbok ang ten gem ga̱ alkawol gwe sa̱ pi ma̱n za̱t ji ma̱n za̱t jwasa̱n wu, ");
INSERT INTO gyz_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","suk ten ɗe ta̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ba̱l nalti Nya ten bi ga̱ kwot ang gaa gwasi. Na̱k kangwe ni ga̱ lishi wu ɗe, <<Ten ga̱misi ka̱n, Bagaa ba ta̱ski ka̱ mbala̱n jwe ba̱ ma̱n Yehuda ka̱ sowu, ba wul koo ta̱sti ga̱ shin gwa.>> ");
INSERT INTO gyz_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Ga̱ɓa ga̱ Nya po dla̱m ɗa̱ ɗe, <<Kii ɗe ba̱ ma̱n Yehuda ka̱ sowu, pa̱la̱n hwol tuk suk mbala̱n ji Nya.>> ");
INSERT INTO gyz_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Yek ta̱ po dla̱m ɗa̱ ɗe, <<Mas jwaka̱n ta̱sa̱n Bagaa, kii ɗe ba̱ ma̱n Yehuda ka̱ sowu, mas mbala̱n ji dii atli ta̱sa̱nti.>> ");
INSERT INTO gyz_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Yek Ishaya po dla̱m ɗe, <<Ma̱lgon a yiltet ka̱ ma̱n boo ga̱ Yese, ta tlinya ata̱ da̱m ɗe guu ten ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, Tenti ka̱n ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu a zi mbadli.>> ");
INSERT INTO gyz_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Ha̱nta̱ Nya ma̱n lakti za̱t mbadl ba̱lkii hwol tuk ga̱ njikmi suk ta̱mi da̱mti ka̱ sa'i gwe ka̱a̱ nga̱sti tenti wu, ten ɗe ta̱ za̱t mbadl gwaka̱n nal i'e ɗa tumal iko ga̱ Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Yilkeni jini, ami gaa gini a yisi ɗe gem kii gaa gwaka̱n wo ma̱n pa̱lti hwa wul i'e ka̱ ɗe kii, a ka̱a̱ yis wul i'e hal ka̱a̱ mbuki ɗe ta̱k mboki ang yilkeni jwaka̱n ten wul. ");
INSERT INTO gyz_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","A ka̱ lishti ga̱n ɗe a lishikii go a yil ten dii i'e yek a ga̱ɓa ten wul jon ten ɗe ta daamikii wuli ɗa. A pa̱li na̱k gwisi ka̱n tumal alheri gwe Nya pa̱li wu, ");
INSERT INTO gyz_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","gwe ɗe ta̱ laki yek a da̱m ɗe ma̱n pa̱lti wul ga̱ Almasihu mal ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu. A na̱ma pa̱lti wul ɗe ma̱n pa̱lti wul ka̱ lubii ga̱ Nya tumal lakti icin ten ga̱ɓa ma̱n ta̱mti ga̱ Nya ten ɗe ta̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu da̱m ɗe sadaka ga̱ taki Nya ma̱n mbit kantidli, ma̱jwe ɗe sa̱ za̱si ka tumal Shishi ga̱ Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ten na̱k gwisi ka̱n ba man ɓot ngetl ka̱ Almasihu Yesu ten bi ga̱ pa̱lti wul ga̱n ɗe a nima pa̱lti Nya wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Ba pa̱l nda̱li gahwula̱n a dla̱m ga̱ɓa ten ilgon so, seko ten ilgwe Almasihu pa̱li tumala̱n wu. Ilgwisi wo yek ɗe kangwe sa̱ dla̱k ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu ten ɗe ta̱s kumi bi Nya tumal ga̱ɓa suk pa̱lti wul gini. ");
INSERT INTO gyz_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Yek a pa̱l wul ga̱ za̱t laali suk pa̱lti wul ngipti bi ang tumal iko ga̱ Shishi ga̱ Nya. A tli tet Wurshelima yek a ganda̱l lu hal yek a la Ilirikum, a ngusi lakti icin ten ga̱ɓa ma̱n ta̱mti ga̱ Almasihu hal yek a pak mas pa̱lti wul gini. ");
INSERT INTO gyz_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Ko a gasi lamti gi wo yek ɗe ta̱ dla̱m ga̱ɓa ten ga̱ɓa ma̱n ta̱mti ka̱ mas lu gwe ba̱sa̱ ɓo yis Almasihu sowu, ten ɗe ba̱ da̱m ɗe a na̱ma kinti bii ten zhila bii gwe zobsi ma̱lgon ka̱ lak wu so. ");
INSERT INTO gyz_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Ama ka̱ lal ga̱ na̱k gwisi wo yek da̱m na̱k kangwe ni ga̱ lishi wu ɗe, <<Ma̱jwe ɗe ba̱sa̱ ɓo taɓesi dla̱mti ga̱ɓa ten bi gwas sowu sa yeni, ma̱jwe ba̱sa̱ ɓo ta̱ɓa kumti ga̱ɓa tenti sowu sa yis gaami.>> ");
INSERT INTO gyz_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Ga̱mi ka̱ɗe ilgwe laki yek ba̱sa̱ zaka̱nni ten ɗe ta tul amalkii so asa̱mi wonti wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Na̱k ningo a pak pa̱lti wul gi ka̱ ka̱t atl jin wi. Tun na̱k ɗe tun ka̱ wonti gin jon a na̱ma lamti tulti malkii ɗe ta yenkii wu, ");
INSERT INTO gyz_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","a shirye wi ɗe ta̱ sa yenti gwaka̱n ninge. A na̱ma za̱t mbadl ɗe ka̱ sa'i gwe ba shige ta li ka̱ atl ga̱ Sipen go a koɓi tumalkii a sak yenkii. A na̱ma za̱t mbadl ɗe kume ɗe a kum ta̱mti ga̱ da̱mti sukkii ga̱ nak sa'i gon wu, ba ci cina na̱ za̱tgaa ta li teka na̱ za̱t ang gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ningo ba li Wushelima ten ɗe ta ta̱le za̱t ang mbala̱n ji Nya jwe sa̱ni ka̱ li wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Ma̱n kopti jwe sa̱ ni Makidoya suk jwe sa̱ ni Akaya wu kum ta̱mti ba̱lti wul ten bi za̱t ang ma̱jwe sa̱ ni ka̱ la̱shi wul ka̱ mbala̱n ji Nya jwe sa̱ ni Wurshelima wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Sa̱ kum ta̱mti ga̱ pa̱lti na̱k gwisi, ko ɗe gwisi wo ngetli ka̱n nisi gaa wu. Na̱k ɗe ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu mbi rabo gwasa̱n ka̱ albarka ga̱ Shishi tet mal ma̱n Yehuda wu, yek da̱misi wi na̱k wule dul ka̱n ta̱s pa̱l wul na̱ albarka gwasa̱n ga̱ dii atli ten ɗe ta̱s ɓatli wul ma̱n Yehuda na̱ nali. ");
INSERT INTO gyz_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Ɗe kume a pak pa̱lti wul ga̱n yek a ba̱lsi wul za̱t ang gwe sa̱ ba̱li ten bi gwasa̱n wu, ba dop tantu la̱t Sipen a dlat te malkii ka a sak yenkii ɗe aɓa zigaa wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","A yisi ɗe gem ka̱n ɗe a ɓa tul malkii wu, ba tul na̱ albarka ga̱ Almasihu ga̱ njikmi. ");
INSERT INTO gyz_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Yilkeni jini ten bi ga̱ Bagaa ga̱na̱n Yesu Almasihu suk ten bi ga̱ lamti gwe a Shishi ga̱ Nya ba̱li wu, a na̱ma ngemti gwaka̱n ɗe ta̱k zini nini ang ka̱ dopti ngetl gwe a ni dlo wu, ga̱ɓa suk Nya ten bi gini. ");
INSERT INTO gyz_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Ngema̱n Nya ten ɗe ta mbi yilti ɗa̱ka̱ ang ga̱ ma̱jwe ɗe ba̱ ma̱n kopti ka̱ so ɗe sa̱ ni ka̱ ka̱t atl Yehudiya wu, suk ten bi wul za̱t ang jwe ba ba̱li a Wurshelima wu, ta̱ wuli da̱m ɗe ilgwe a kandli mal mbala̱n ji Nya jwe sa̱ ni ka̱li wu. ");
INSERT INTO gyz_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Ga̱ɓa suk Nya pak ten ɗe kume ilgwe ta̱ lami wu ka̱wu, ba mbuklu malkii ka̱ hwol tuki, ta mbi ta shuk sukkii ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Ta̱ Nya ma̱n ba̱lti ta̱mi da̱mti da̱m sukkii mas jwaka̱n. Amin. ");
INSERT INTO gyz_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","A nikii ma dla̱mti ga̱ɓa ga̱n ten ɗe ta mbokikii ang ten yilka ga̱na̱n Pibi ma̱lgwe a ba̱l sheda ɗe ti wo ma̱n pa̱lti hwa wul ka̱ wu. Tisi wo bacina ma̱n pa̱lti wul ga̱ motgaa ga̱ ma̱n kopti ka̱n a Kankiriya. ");
INSERT INTO gyz_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Kama̱n ti ka̱ shin ga̱ Bagaa kangwe mbun ɗe ta̱k kama̱n mbala̱n ji Nya wu. A ka̱a̱ zit ang na̱ mas ilgwe ta̱ lami tet ang gwaka̱n wu, ten ɗe ti gaa gwas wo ta̱ zi ang wonti mbala̱n wi, hal suk ami pak. ");
INSERT INTO gyz_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Ga̱ɓe Ba̱riskila suk Akila ɗa, yela̱n pa̱lti wul gini ka̱ Almashu Yesu. ");
INSERT INTO gyz_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Si wo sa̱ ba̱l mbadl gwasa̱n hal njet ka̱ ɓali asa̱ ma̱shi ten bi gini. A ba̱ ami na̱ ngwe ka̱ɗe ma̱lgwe nisi ma pa̱t godiya wu so, ama hal suk mas motgaa ga̱ ma̱n kopti jwe ɗe ba̱ ma̱n Yehuda ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Ga̱ɓe motgaa ga̱ ma̱n kopti jwe asa̱ mogaa ka̱ lubii gwasa̱n wu. Ga̱ɓe Apanitus yela̱n gi ga̱ gem ɗa, ma̱lgwe tik ɗe ma̱lga̱ cina̱ gwe nda da̱mti ɗe ma̱n kopti ga̱ Almasihu ka̱ mas atl ga̱ Asiya wu. ");
INSERT INTO gyz_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Ga̱ɓe Maryam ɗa, ma̱lgwe ta̱ pa̱l wul i'e ten bi gwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Ga̱ɓe Adaronikus suk Yuniya ɗa, ma̱jwe ɗe si wo ma̱n Yehuda ka̱n na̱k ami wu, ma̱jwe ɗe sa̱ lesi ka ka̱ lu leti suk ami pak wu. Sisi wo ma̱jwe ɗe mbala̱n yissi i'e ka̱ shinti ji Yesu wu ka̱n, asa̱ ni cina ten nga̱sti ten Almasihu. ");
INSERT INTO gyz_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Ga̱ɓe Ampiliyatus ɗa, yela̱n gi ga̱ gem ka̱ cutgaa ka̱ Bagaa. ");
INSERT INTO gyz_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Ga̱ɓe Urbanus ɗa, yela̱n pa̱lti wul ga̱na̱n ka̱ Almasihu, suk yela̱n gini ga̱ nja Sitakis. ");
INSERT INTO gyz_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Ga̱ɓe Apalis ɗa, ma̱lgwe ɗe ma̱n pa̱lti gem i'e ka̱n ka̱ Almasihu wu. Ga̱ɓe ma̱n lubii ji Aristopulus ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Ga̱ɓe Hirudiyan ɗa, ma̱lgwe ti mago yilka gi ma̱n Yehuda ka̱ɗe ti wu. Ga̱ɓe mbala̱n ji Bagaa ɗa, ma̱jwe sa̱ ni ka̱ lubii ga̱ Narkisus wu. ");
INSERT INTO gyz_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Ga̱ɓe Tirayipina suk Tirayipusa ɗa, modli ma̱n pa̱lti wul i'e ka̱ Bagaa. Ga̱ɓe Parsis ɗa, yela̱n ga̱ lami gini ga̱ ma̱dli ma̱n pa̱lti wul i'e ka̱ Bagaa. ");
INSERT INTO gyz_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Ga̱ɓe Rupus ɗa, ma̱lgwe ɗe ti wo sa̱ yisti i'e ka̱ pa̱lti wul ga̱ Bagaa wu. A ka̱a̱ ga̱ɓe ana gwas ɗa, ma̱lgwe ta̱ kama̱nni na̱k wule yen gwas ka̱ pak wu. ");
INSERT INTO gyz_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Ga̱ɓe Asinkiritus, suk Piligona, suk Hermes, suk Paturobas suk Harmas, suk mas yilkeni jwe sa̱ ni suksi wu ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Ga̱ɓe Pilologus, suk Yuliya, suk Niriyus, suk yilka gwasi ga̱ ma̱dli, suk Olimpas, suk mas mbala̱n ji Nya jwe sa̱ ni ka̱li suksi wu ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Ga̱ɓe yilkeni jwaka̱n na̱ njupti bi ten ga̱ska̱n wunda̱li ga̱ cilti. Mas motgaa ji ma̱n kopti ga̱ Almasihu na̱ma ga̱ɓet gwaka̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Yilkeni jini a na̱ma ngemti gwaka̱n ɗe ta̱k da̱ma̱n na̱ ka̱ng gaa ten bi ga̱ ma̱jwe ɗe asa̱ cat gaa jwaka̱n ka̱ wu, ma̱jwe asa̱ lakkii ten kotti asa̱n, asa̱ na̱ma dlanti suk ga̱ɓa gwe sa̱ mbokikii ang dani wu. Ta̱ dlo gwaka̱n dlenti suk wunda̱l ji ma̱ju. ");
INSERT INTO gyz_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Ten ɗe wunda̱l ji ma̱jwisi wo Almasihu Bagaa ga̱na̱n ka̱n sa̱ nitma pa̱lti wul so, tuk gwasa̱n tokte ka̱n. Tumal ta̱mi bi suk ta̱sti ga̱ lal jwasa̱n ka̱n asa̱ shel ma̱jwe asa̱ katisi ka̱ng wu. A ma̱jwe asa̱ katisi ka̱ng go, ma̱n daamti wul na̱k mil mbala̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Ko wokko kum kangwe ka̱ nima kumti bi wu wi, gwisi ka̱ laki yek a na̱ma hwol tuki ten bi gwaka̱n. Ama a na̱ma lamti ɗe ta̱k da̱ma̱n ɗe ma̱n ɓotlka̱n yisti wul ten ilgwe ni ɗe hwa wul wu, a ka̱a̱ da̱m ɗe ma̱jwe ba̱ byas wul nisi gaa sowu ten bi ga̱ wul ngalci. ");
INSERT INTO gyz_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Nya ma̱n ba̱lti ta̱mi da̱mti a taka Sheɗan ka ka̱ asa̱n gwasi, ata̱ ba̱lkii iko tenti njet ɗe. Hwa̱nta̱ alheri ga̱ Bagaa ga̱na̱n Yesu da̱m sukkii. ");
INSERT INTO gyz_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timoti, yela̱n pa̱lti wul gi nima ga̱ɓet gwaka̱n ɗa, nu ka̱n Lushiyus suk Yason suk Sosipata na̱ma ga̱ɓet gwaka̱n ɗa, ma̱jwe si wo ma̱n Yehuda ka̱ wu. ");
INSERT INTO gyz_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Ami Tartiyus, ma̱lgwe lish lishti ga̱n wu a na̱ma ga̱ɓet gwaka̱n ɗa ka̱ Bagaa. ");
INSERT INTO gyz_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus na̱ma ga̱ɓet gwaka̱n ɗa, ma̱lgwe kan ma̱nda̱ki gi ka̱ lubii gwasi, a ka̱ lubiimi ka̱n a mas motgaa ga̱ ma̱n kopti mogaa wu. Eratus ma̱n gipti wul ga̱ ba̱n suk yilka ga̱na̱n Kwartus na̱ma ga̱ɓet gwaka̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Ha̱nta̱ alheri ga̱ Bagaa ga̱na̱n Yesus Almasihu da̱m sukkii mas jwaka̱n. Amin. ");
INSERT INTO gyz_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Hwa̱nta̱ nalti da̱m ɗe ga̱ Nya ti ɗe iko ga̱ ta̱s dla̱lla̱kii ten nga̱sti ten Nya na̱k kangwe ga̱ɓa ma̱n ta̱mti ge ɗe a na̱ma lakti icin dani ten Yesu Almasihu dla̱m wu. Ga̱ɓa ma̱n ta̱mtisi wo ilgwe sa̱ hwunda̱li ka tun ka̱ multi ji tek wu ka̱n, ");
INSERT INTO gyz_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ama ningo sa̱ yilli ten dii wi tumal lishti ji ma̱n dla̱mti ga̱ɓa ga̱ Nya. A tumal ilgwe Nya dla̱m ɗe ma̱n la̱shi pakti wu ka̱n sa̱ mboki ang mas mbala̱n ji dii atli dani, ten ɗe ta̱s nga̱ssi ten Nya asa̱ kumit bi ɗa. ");
INSERT INTO gyz_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Hwa̱nta̱ nalti da̱m ɗe ga̱ Nya ti ɗe tik ɗe ma̱n ɓotlka̱n yisti wul na̱ ngusi tumal Yesu Almasihu ba pakti wu. Amin.");
INSERT INTO gyz_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Ami Bulus ɗe Nya mbeni ta da̱n ɗe yen shinti ga̱ botli ga̱ Yesu Almasihu na̱k kangwe ta̱ pa̱li wu. Amik lish ga̱ɓa ge suk yilka ma̱n kopti gwe asa̱ mbet ɗe Sastanis wu. ");
INSERT INTO gyz_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Kii motgaa ma̱n kopti jwe ni ka̱ ba̱n Korinti wu, suk jwe Nya botlsi yek ta̱ polsi ka yek sa̱ da̱n ɗe ma̱n hwa mbadl wu, suk mas ma̱jwe asa̱ ngem Nya ka̱ shin ga̱ Yesu mas lu gwe sa̱ ni wu, na̱k ɗe tik ɗe Bagaa ga̱na̱n suksi wu. ");
INSERT INTO gyz_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Ha̱n ta̱ yenti gonti na̱ ta̱mi mbadl sut mal Nya Buka ga̱na̱n suk mal Yesu Bagaa da̱n ka̱ mbadl gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","A pa̱l hwol tuk na̱ Nya dlip na̱k ɗe ka̱a̱ mbi alheri tumal Almasihu Yesu wu. ");
INSERT INTO gyz_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Tumalti ka̱n ka̱a̱ mbi mas hwa wul, ten mas tantu ka̱ mas ga̱ɓa gwaka̱n, suk mas yisti wul gwaka̱n, ");
INSERT INTO gyz_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","na̱k ɗe ga̱ɓa gwe ma̱ hwikii ten Yesu go mbala̱n yeni ten pa̱t gwaka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Yek laki ɗe ka̱a̱ mbi mas ba̱lti wul ji Shishi ga̱ Nya ɗe ka̱a̱ na̱ma za̱t gwel ten palti sut ga̱ Yesu Almasihu Bagaa wu. ");
INSERT INTO gyz_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ta nda̱llikii gahwula̱n se gas gwe ta pal sut ɗu. Ta̱k da̱ma̱n ɗe ma̱n la̱shi pa̱lti byas wul ten gas palti ga̱ Almasihu Yesu. ");
INSERT INTO gyz_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Nya ɗe ta̱ mbekii ten ɗe ta̱k cugaa suk Yen gwasi Yesu Almasihu go, ma̱n njika̱nti ga̱ɓa gwas ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","A na̱ma ngemti gwaka̱n yilkeni jini ka̱ shin ga̱ Yesu Almasihu ta̱ bi gwaka̱n ni ɗe na̱m. Ba̱k da̱ma̱n kak-kak so, mo gaa gwaka̱n ta̱k da̱ma̱n na̱ mbadl ɗena̱m suk daamti ɗena̱m. ");
INSERT INTO gyz_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Yilkeni jini, ma̱jon ka̱ boo ga̱ Kuluwi hwi ɗe ka̱a̱ na̱ma dla̱kti ga̱ɓa ka̱ dlo gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ilgwe a nikii ma hwiti go yek ɗe, gon gwaka̱n wule, <<Bulus ka̱n ta̱ na̱ma kopti gwasi,>> a gon wule, <<Ami wo Apolos,>> a gon wule, <<Ami wo Kepas,>> a gon wo, <<Ami wo Almasihu.>> ");
INSERT INTO gyz_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Yesu wo ɗe na̱mi ka̱n ta̱ ni? Bulus ka̱n sa̱ ɓakti ka ten guda̱l yencin ka̱ lal gwaka̱n ma? Ka̱ shin ga̱ Bulus ka̱n sa̱ pa̱likii baptisma nwa? ");
INSERT INTO gyz_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","A pa̱l hwol tuk na̱ Nya na̱k ɗe a pa̱li baptisma ma̱lgon so, ban na̱ Kiribus suk Gayus sowu. ");
INSERT INTO gyz_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Yek laki ma̱lgon a man wulti ɗe sa̱ pa̱lit baptisma ka̱ shin gi so. ");
INSERT INTO gyz_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","A po pa̱li baptisma ma̱n boo ga̱ Sitipanus pak. Ban na̱ ma̱ ju sogo, ka̱ daamti gi wo a po pa̱li baptisma ma̱lgon so. ");
INSERT INTO gyz_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Yesu shina̱n ɗe ta pa̱l baptisma so. Ta̱ shina̱n ɗe ta dla̱mi ga̱ɓa ma̱n ta̱mti mbala̱n, ba̱ ɗe ta ga̱ɓa na̱ manti ga̱ mbala̱n so, ta̱ mbala̱n yis nda̱lti ɓakti ga̱ Yesu ka ten guda̱l yencin. ");
INSERT INTO gyz_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Ɓakti gwe sa̱ ɓak Yesu ka ten guda̱l yencin wu mal ma̱jwe gil go, ɗe ka̱dla̱n ka̱n ni. Ama mal ni ɗe ma̱ mbi kisti go, bi ɓakti ga̱ Yesu ten guda̱l yencin wo nda̱lti ga̱ Nya ka̱n ");
INSERT INTO gyz_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Na̱k gwe ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya wu ɗe, <<Ba lil ɓotlka̱n ga̱ ma̱jwe da̱m gwa we sa̱ ɓotl wu ka. Ba cat byas ɓotlka̱n ga̱ ma̱n ɓotlka̱n ka.>> ");
INSERT INTO gyz_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ma̱n ɓotlka̱n na̱n ko? Ma̱n yisti mba̱t ga̱ɓa ga̱ Musa ka̱ jwi? Ma̱jwe da̱ma̱n gwa we sa̱ yis mas wul wuk gwi? Nya ɓo mbok ang ten byas ɓotlka̱n ga̱ mbala̱n ten dii atl ɗe ka̱dla̱n sa? ");
INSERT INTO gyz_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Ten ɗe Nya tumal ɓotlka̱n yisti wul gwasi, yek ta̱ laki yek ba̱ mbala̱n ji dii atl man yisti gwas tumal ɓotlka̱n yisti wul gwasa̱n so. Ka̱ lal ga̱ na̱k gwisi wo yek Nya lami ɗe ta̱s kis ma̱jwe nga̱ssi tenti wu tumal lakti icin ten ga̱ɓa ma̱n ta̱mti gwe mbala̱n kan ɗe ka̱dla̱n wu. ");
INSERT INTO gyz_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Ma̱n Yehuda wo sa̱ na̱ma lamti yenti wul cit ɓanti, a ma̱n Giris wo sa̱ na̱ma ngot ɓotlka̱n yisti wul. ");
INSERT INTO gyz_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Ama mi wo bi ga̱ Yesu gwe sa̱ ɓakti ka ten guda̱l yencin wu ka̱n ma̱ na̱ma dla̱mti. Ga̱ɓa gwe a lak ma̱n Yehuda ten kotti asa̱n, a mal ma̱jwe ba̱ ma̱n Yehuda ka̱ sogo ɗe ka̱dla̱n ka̱n ni wu. ");
INSERT INTO gyz_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Ama mal ma̱jwe Nya mbesi go, ko ta̱ ma̱n Yehuda ko ta̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu Yesu ka̱ɗe nda̱lti ga̱ Nya suk yisti wul gwasi. ");
INSERT INTO gyz_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Mas ilgwe Nya pa̱li yek mbala̱n yeni wule ka̱dla̱n ka̱wu man ɓotlka̱n yisti wul ga̱ mbala̱n, a ilgwe Nya pa̱li yek mbala̱n yeni wule la̱shi manti ka̱wu, man manti wul ga̱ mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Ɓo daama̱nkii ten kangwe ka̱a̱ ni ɗe Nya mbekii wu yilkeni jini, na̱m na̱m ka̱ kii ka̱ɗe ma̱n ɓotlka̱n na̱k gwe a mbala̱n yen ɓotlka̱n wu. Na̱m na̱m ka̱ kii ka̱ da̱n ɗe kiɗi mbala̱n wi, a na̱m na̱m ka̱ kii ka̱ɗe mil ji kiɗi mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Nya botl ilgwe mbala̱n kan ɗe ka̱dla̱n wu ta̱s laki ta̱ nsha ci ma̱n ɓotlka̱n ten dii atli. Nya botl wul jwe mbala̱n mbuli wu ta̱ nsha ci ma̱jwe nda̱l wu. ");
INSERT INTO gyz_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Wul ji dii atl jwe mbala̱n yeni ɗe hwaɓi ka̱ so jwe sa̱ mbuli wu ɗe a ba̱ ni ten bi ilgon malsi sowu, yek ka̱n Nya botli ta̱s cat wul jwe mbala̱n yeni ɗe hwaɓi wu ka. ");
INSERT INTO gyz_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Nya pa̱li nu ba̱ ma̱lgon ɓo ngetl ɗe ti wo ta̱ mbuk ilgon a cina ɗatka̱ so. ");
INSERT INTO gyz_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Nya ka̱ laki yek ma̱ pala̱n ɗe ma̱n kopti ga̱ Yesu, a tik laki yek Almasihu da̱mini ɗe ɓotlka̱n yisti wul. Tumalti ka̱n Nya palla̱nni ɗe mbala̱n jwasi yek ta̱ yilla̱ni ka yek ta̱ kisni ɗa̱ka̱ da̱nti ɗe zhel ga̱ pa̱lti byas wul ka tumal Yesu. ");
INSERT INTO gyz_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Nu ka̱n ni ka̱ lishti ga̱ɓa ga̱ Nya ɗe, <<Mas ma̱lgwe ɓo ngetl ɗe ta̱ mbuk pa̱lti ilgon go, ta̱s ɓo ngetl na̱ Nya.>> ");
INSERT INTO gyz_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Yilkeni jini, ɗe a tul malki ɗe ta hwikii ilgwe ni ga̱ hwuda̱li ɗe Nya dla̱m go, a tul na̱ manti bi suk ɓotlka̱n ga̱ mbala̱n suk yisti wul ga̱ gaa gi so. ");
INSERT INTO gyz_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","A zi ka̱ mbadl gi ɗe da̱nti gi sukkii wo, ba ga̱ɓe kii ten ilgon so se ten bi ga̱ Yesu Almasihu gwe sa̱ ɓakti ka ten guda̱l yencin wu. ");
INSERT INTO gyz_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Ɗe a nda tulti malkii go, dli nda̱li so, ɓanti cinni yek dli gi ngusi da̱dalti. ");
INSERT INTO gyz_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Ga̱ɓa gi wo na̱ manti bi suk ɓotlka̱n ga̱ mbala̱n ka̱ so ama na̱ nda̱lti ga̱ Shishi ga̱ Nya ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Ba̱k nga̱sa̱nkii ten ɓotlka̱n ga̱ mbala̱n so, ama nga̱sa̱nkii ten nda̱lti ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Mas na̱ na̱k gwisi ma̱ na̱ma lakti icin ten ga̱ɓa ɓotlka̱n yisti wul mal ma̱jwe nda̱l ten nga̱sti ten ya gwasa̱n wu. Ga̱n go wunda̱l ga̱ ɓotlka̱n yisti wul ga̱ mbala̱n ji se ɗe sa̱ ni ten dii atl wu ka̱ so. A ba̱ wunda̱l ɓotlka̱n yisti wul ga̱ guu ji niige gwe a paki wuk so, ");
INSERT INTO gyz_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ama ma̱ na̱ma ga̱ɓa ten ɓotlka̱n ga̱ Nya gwe ni ga̱ hwuda̱li wu. Nya pa̱l wunda̱l ɓotlka̱n gwisi ta̱n mbi nalti ɗa. Nyami pa̱li nu a ba̱ta̱ ɓo pa̱l dii atl so. ");
INSERT INTO gyz_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Guu ji dii atl mas yis gaa ga̱ ɓotlka̱n ga̱ Nya gwisi so, sa yisi go sa ɓak Bagaa ga̱na̱n ma̱n nalti ka ten guda̱l yencin so. ");
INSERT INTO gyz_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Ama ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <<Ilgwe Nya zi ma̱jwe lamti wugo ma̱lgon ɓo yeni so zam, a ba̱ ma̱lgon ɓo kumi so, a ba̱ ma̱lgon ɓo daamti ɗe a pi nu so.>> ");
INSERT INTO gyz_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ama yek Nya mbokinii ang ten wul jwisi wi tumal Shishi gwas ma̱n cilti. Shishi ga̱ Nyami wo ata̱ bodla̱l mas wul, mas na̱ wul ji Nya jwe ni dlunti gwe a bomi mbala̱n ta̱s yisi wu. ");
INSERT INTO gyz_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Wok ka yis daamti ga̱ ma̱lgon wo ɗe ba̱ mbadl ga̱ ma̱li ka̱ sowu? Nu ka̱n yisti mbadl ga̱ Nya mago se Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Mi wo shishi ga̱ dii atl ka̱n ma̱ kan so, ama Shishi gwe yil sut mal Nya wu ka̱n ma kaami, ta̱n yisa̱n ilgwe Nya ba̱la̱nni ten koo lu wu. ");
INSERT INTO gyz_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ilgwe ma̱ nikii ma hwiti go, ma̱ na̱ma dla̱mti na̱ ɓotlka̱n ga̱ mbala̱n so, ma̱ na̱ma dla̱mti na̱k gwe Shishi ga̱ Nya mbokinii ang dani wu. Ma̱ nima dla̱mti ma̱jwe Shishi ga̱ Nya na̱ma kopti na̱ si wu gem gwe ni ka̱ Shishi ga̱ Nyami wu. ");
INSERT INTO gyz_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ma̱lgwe ba̱ Shishi ga̱ Nya na̱ma kopti na̱ti sogo ta kan ilgwe yil tet mal Shishi ga̱ Nya wu so, na̱k ɗe malti wo ka̱dla̱n ka̱wu, a ba̱ta yis gaami so na̱k ɗe tumal Shishi ga̱ Nyami ka̱n a mbala̱n yis gaami wu. ");
INSERT INTO gyz_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ma̱lgwe Shishi ga̱ Nya na̱ma kopti na̱ ti go, ata cinga̱l mas wul, ama ti wo ba̱ ma̱lgon a cinga̱l ti so. ");
INSERT INTO gyz_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","<<Wok yis daamti ga̱ Bagaa wo, ɗe hal ta mbokit ang ten ilgon wu?>> Ama daamti ga̱na̱n wo ga̱ Almasihu wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Yilkeni jini, ba ga̱ɓekii na̱k ma̱jwe Shishi ga̱ Nya na̱ma kopti na̱ si wu so, ama na̱k naa mbala̱n ji dii atli, na̱k mil la̱li ka̱ kopti ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","A ba̱lkii ze nii ba̱ ɗe nda̱li shin so, na̱k ɗe ka̱a̱ ɓo mbuk ngukti sowu. Na̱k niige mago ka̱ ɓo mbuki so. ");
INSERT INTO gyz_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Na̱k naa mbala̱n ji dii atl ka̱n ka̱a̱ yima da̱mti, na̱k ɗe ka̱a̱ yima daka̱lti, aka̱a̱ yima dla̱kti ga̱ɓa ka̱ dlo gwaka̱n wu. Na̱k niige mago pa̱lti wul gwaka̱n wo ga̱ dli ka̱ yi. Ka̱a̱ yima pa̱lti wul na̱k ma̱n dii atli. ");
INSERT INTO gyz_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kume gon wule, <<Ami wo ga̱ Bulus ka̱n,>> A gon wule, <<Ami wo ga̱ Apolos,>> go ndakce ka̱n ka̱a̱ yi suk na ma̱n dii atl sa? ");
INSERT INTO gyz_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ta ngemkii, wok ɗe Apolos wo? A wok ɗe Bulus wo? Zhel ji Nya ka̱n jwe ka̱a̱ nga̱skii ten Yesu tumalsi, ko gwik-gwi ta̱ pa̱l wul kangwe Nya ba̱lti ta̱s pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Amik ɓak wuda̱li, yek Apolos ba̱l ze, ama Nya ka̱ laki yek nali. ");
INSERT INTO gyz_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Na̱ nu ka̱n, na̱ ma̱lgwe ɓak wuda̱li wu, na̱ ma̱lgwe ba̱l ze wu, ko gon ni ten bi ilgon so se Nya na̱ ngusi ti ɗe ta̱ laki yek nal wu. ");
INSERT INTO gyz_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Na̱ ma̱lgwe ɓak wuda̱li wu, na̱ ma̱lgwe ba̱l ze wu, mas jwasa̱n wo wul ɗena̱m ka̱ ni ka̱ mbadl gwasa̱n. A ko gwik-gwi Nya a ɓatlti ndakce na̱ kangwe ta̱ pa̱l wul wu. ");
INSERT INTO gyz_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Mi wo yela̱n ten pa̱lti wul ga̱ Nya ka̱n. A kii wo zhin ga̱ Nya ka̱n, a bii gwe Nya kin wu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Na̱k gwe Nya ba̱la̱n manti wu, a lak zhila kinti biimi na̱k ma̱n manti kinti bii i'e, a ma̱lgon na̱ma mba̱lti kinti dani. Ama mas ma̱lgwe a kin biimi go ta̱s pi ɗem-ɗem na̱ kangwe ta kin biimi wu. ");
INSERT INTO gyz_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Ma̱lgon a po man lakti zobsi zhila biimi gon ban na̱ gwe a lak wu so, gwe Yesu Almasihu ka̱ɗe zhile wu. ");
INSERT INTO gyz_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Kume ma̱lgon kin ten zhila bii gwisi na̱ zinariya sogo na̱ hwol muni, sogo mbuni sunka̱n sogo na̱ yencin sogo na̱ koo me, sogo na̱ mamo. ");
INSERT INTO gyz_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Ilgwe ta̱ pa̱li wu a yil deɓa̱l, na̱k ɗe gas gwe a yil ten cilti wu ni tet wu. Nya a cinga̱l pa̱lti wul ga̱ mas mbala̱n na̱ wutu a wuti ka cinga̱l pa̱lti wul ga̱ ma̱li. ");
INSERT INTO gyz_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Kume kinti gwe ta̱ kin ten zhila biimi wu kwel ka̱ sowu, ma̱lgwe kin wu a mbi ɓatlti gwasi. ");
INSERT INTO gyz_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Ama kume kinti biimi kwel ka̱wu, ma̱li a sa ang kooni, ti gaa gwas wo ta mbi kisti ama na̱k ma̱lgwe koɓi tu ka̱ wutu wu. ");
INSERT INTO gyz_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Ka̱a̱ yisi ɗe kii wo bii ga̱ Nya ka̱sa? A Shishi ga̱ Nya na̱ma da̱nti ka̱ kii sa? ");
INSERT INTO gyz_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Mas ma̱lgwe lil bii ga̱ Nya ka̱go, Nya a lilti ka, na̱k ɗe bii ga̱ Nya wo da̱ska̱n ni giɓi sowu, a kik ɗe bii gwisi. ");
INSERT INTO gyz_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ba̱k shela̱n gaa gwaka̱n so, mas ma̱lgwe da̱m gwa we ta̱ ɓotl na̱k ninge wu, ta̱s palli gaa gwas ɗe ka̱dla̱n ta̱s da̱n ɗe ma̱n ɓotlka̱n ɗa. ");
INSERT INTO gyz_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Ilgwe mbala̱n ji dii atli yeni ɗe ɓotlka̱n go, mal Nya wo ɗe ka̱dla̱n ka̱n ni. Na̱k gwe ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya wu, <<Nya dop ma̱n ɓotlka̱n ka̱ ɓotlka̱n gwasa̱n.>> ");
INSERT INTO gyz_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ni ga̱ lishi ka̱ ga̱ɓa ga̱ Nya ɗe, <<Bagaa yisi ɗe daamti ga̱ ma̱n ɓotlka̱n wo ni ten bi ilgon so.>> ");
INSERT INTO gyz_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Yek laki ba̱ ma̱lgon ɓo ngetl ten ilgwe ma̱lgon a pa̱li wu so, mas wul wo gwaka̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Ko ta̱ Bulus, ko ta̱ Apolos, ko ta̱ Kepas, ko ta̱ dii atli, ko ta̱ mbadli, ko ta̱ ma̱shka̱n, ko ta̱ ilgwe na̱ma pa̱t nin wu, ko ta̱ ilgwe a pi a cina wu, mas gwaka̱n ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","A kii wo ga̱ Almasihu ka̱n, a Almasihu wo ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Kama̱nni ɗe zhel ji Almasihu ma̱jwe Nya ba̱lsi gem gwas gwe ni ga̱ hwuda̱li wu. ");
INSERT INTO gyz_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Ngetli ka̱n ta̱ ma̱jwe sa̱ ba̱lsi za̱t ilgon wu pa̱l gem. ");
INSERT INTO gyz_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Ami wo hwota̱n so kume kii, sogo ma̱jon kis ga̱ɓa tena̱n wu. Ami mago a cinga̱l gaa gi so. ");
INSERT INTO gyz_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Ami wo a yis byas wul gwe a pa̱li wu so, ama ba̱ ɗe we na̱kka̱n a pa̱l byas wul so so, Nya ka cinga̱la̱nni. ");
INSERT INTO gyz_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Ten na̱k gwisi ka̱n ba̱k cinga̱la̱n ma̱lgon a ba̱ cin cinga̱lti ɓo tul so so. Ɓa̱ta̱n cin gwe Bagaa a tul wu, ta yilli ilgwe ni ga̱ hwuda̱li ka ka̱ da̱mshal wu, suk ilgwe ni ka̱ mbadl ga̱ mbala̱n wu mas. Ten cin gwisi ka̱n mbala̱n a mbi ta̱sti mal Nya. ");
INSERT INTO gyz_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Yilkeni jini, a cinga̱likii ga̱ɓa ten Apolos suk ami ta hwikii ga̱ɓa jwisi, ta̱k yisa̱n gaa ga̱ ga̱ɓa gwe wule, <<Ba̱k ɗakca̱n ilgwe ni ga̱ lishi wu so.>> Yek laki ba̱ ma̱lgon kan ɗe ma̱n lishti gwas man ga̱ ma̱lgon so. ");
INSERT INTO gyz_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Wok hwik ɗe ka̱ man ma̱lgon wo? Yek nik ɗa̱ɗe ba̱ Nya ka̱ ba̱lki so ye. A Kume Nya ka̱ ba̱lki wu, yek laki yek ka̱ na̱ma ɓot ngetli wule ba̱lti ka̱n sa̱ ba̱lki so ye? ");
INSERT INTO gyz_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","To ka̱a̱ mbi mas ilgwe ka̱a̱ lami wu wi. Ka̱a̱ ɓal ɗe ma̱n wul ang, aka̱a̱ ɓal na̱k guu, a mi wo ba̱ma̱ ni ten bi ilgon so. Guu ga̱ gem kani ɗe kii wu, ma da̱ma̱n wi ɗe guumi sukkii. ");
INSERT INTO gyz_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Yenti gi wo mi mil shinti ji botli ji Almasihu mik ni kaali ten mas wul, na̱k ma̱jwe sa̱ kis ga̱ɓa ɗe ta̱s tlosi ka ka̱ dlo ga̱ mbala̱n wu. Ma̱ pal ɗe ma̱jwe mbala̱n ji dii atli, suk mil shinti ji Nya suk mas ma̱jwe mbala̱n zinii gwel wu. ");
INSERT INTO gyz_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Mi wo ma̱ pal ɗe ka̱dla̱n ka̱ Almasihu ki wo yek ka̱ pal ɗe ma̱n ɓotlka̱n ka̱ Almasihu. Mi wo ma̱ nda̱l so ama ki wo ka̱ nda̱li. Ka̱ mbi nalti wi, ama mi wo ma̱lgon nalla̱ni so. ");
INSERT INTO gyz_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Na̱k nin mago kuza̱n suk ka̱lka̱ze na̱ma tlot ga̱na̱n, a ba̱ hwa tutul gwe ma lak wu nini ɗa̱ so, mbala̱n na̱ma ɓot ga̱na̱n, lubiii mago nini ɗa̱ so. ");
INSERT INTO gyz_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Ama̱ ngo wul na̱ gaa ga̱na̱n. Mbala̱n pa̱lini bi wu, ama̱ ngemisi hwa wul ga̱ Nya. A kume sa̱ cini dlelngapcan wu, ama̱ dlo mbadli. ");
INSERT INTO gyz_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Sa̱ byalni wu, ama̱ hwisi hwa ga̱ɓa, mas na̱ nu mas mbala̱n ten dii atl na̱ma mbulti ga̱na̱n, sa̱ palla̱ni na̱k bi zukɗi ten dii atli. Ilgwe sa̱ na̱ma pa̱lti wuggu. ");
INSERT INTO gyz_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","A lishikii ga̱ɓa ge ba̱ ɗe ta̱ nsha cikii so, ama ta matlkii na̱k gwe a aba matl mil jwas jwe ta̱ lamsi wu. ");
INSERT INTO gyz_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Ko ta̱ ma̱n lishti jwaka̱n ka̱ Almasihu wonti yek sa̱ la zaba̱l ɗe kutl, aba nikii ɗa wonti so. Amik da̱n ɗe aba gwaka̱n ka̱ Yesu Almasihu wi, na̱k ɗe a tullikii ga̱ɓa ma̱n ta̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","na̱k ɗe nuk ni wu, a na̱ma ngemti gwaka̱n ta̱k pa̱la̱n ilgwe ka̱ yena̱n ten pa̱lti wu. ");
INSERT INTO gyz_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Yek laki ɗe yek a shin Timoti malkii, yen gi ka̱n gwe a lamti wu. Ti wo ma̱n pa̱l gem ka̱n ten kopti ga̱ Bagaa. Ta daamikii ilgwe a na̱ma pa̱lti ka̱ kopti ga̱ Yesu Almasihu wu, na̱k kangwe ɗe a mboki ang mas motgaa ga̱ ma̱n kopti ko ako. ");
INSERT INTO gyz_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Jon jwaka̱n ɓa yeni go ba po tul malkii so, yek laki yek sa̱ na̱ma nalti gaa. ");
INSERT INTO gyz_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Ba tul malkii njet ɗe kume Nya lami wu. Apaa a bodla̱l ilgwe ma̱n nalti gaa ju na̱ma dla̱mti wu suk nda̱lti gwe sa̱ dla̱m ga̱ɓa jwisi na̱ nali wu. ");
INSERT INTO gyz_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","na̱k ɗe Nya ɗe guu wo ten manti ga̱ɓa ka̱n ni sowu, ama ka̱ nda̱lti ga̱ Nya ka̱n ni. ");
INSERT INTO gyz_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Botla̱n gon ta tul malkii na̱ tlemndi ya? ko ta tul na̱ ga̱ɓa ma̱n mulla̱t mbadli ka̱ lamti? ");
INSERT INTO gyz_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Sa̱ hwi ɗe jon jwaka̱n na̱ma pa̱t suk ma̱dli jwe ba̱ gwasa̱n ka̱ sowu, gwe hal ma̱lgon pi suk kili ga̱ aba gwasi, ma̱jwe ba̱sa̱ yis Nya so mago sa̱ pa̱li so. ");
INSERT INTO gyz_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Ama yek ka̱a̱ na̱ma ɓot ngetl ɗe ka̱a̱ mbuki wi! Yek ba̱ mbadl lili kii yek ka̱a̱ yilli ma̱n pa̱lti wuda̱li gwisi ɗa̱ka̱ dlo gwaka̱n ka̱ sa? ");
INSERT INTO gyz_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ko ɗe a ni sukkii ka̱ dli sowu, ama mbadl gi ni sukkii. Ka̱ shin ga̱ Bagaa Yesu hal a nol ma̱lgwe pa̱li na̱k gwisi wu wi, na̱k wule a na̱n ka̱li. ");
INSERT INTO gyz_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Kume ka̱ mogaa ka̱ shin ga̱ Yesu Bagaa wu, a mbadl gi ni sukkii, a nda̱lti ga̱ Yesu Bagaa ni ɗa ");
INSERT INTO gyz_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Taki ma̱llu Sheɗa̱n, ta̱ pa̱lti byas wul ka̱ dli ga̱ ma̱li ma̱shi, apaa shishi ga̱ ma̱li mbi kisti ten cin ga̱ Bagaa. ");
INSERT INTO gyz_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Ɓot ngetl gwaka̱n wo ten koo lu ka̱n. Ka̱ yisi ɗe yist wo njet ka̱n asa̱ la̱ski ka̱ guda̱l ba̱redi a ngashi mas sa? ");
INSERT INTO gyz_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Yilla̱n gus yis ka ta̱k pala̱n ɗe pyal guda̱l ba̱redi gwe ba̱ yis ni giɓi sowu, na̱k gwe ka̱a̱ kul ni wu. Na̱k ɗe sa̱ mbosh yen bagalla motgaa ɗakciti wi, tik ɗe Almasihu. ");
INSERT INTO gyz_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Na̱k ɗe nu ka̱wu, ma̱ pa̱la̱n motgaa ɗakcitisi ba̱na̱ gus yis so, yis ga̱ ngalci suk yokiti. Ama pa̱la̱n motgaami na̱ ba̱redi gwe ba̱ yis ni giɓi sowu, gwe sa̱ pa̱li na̱ hwa mbadli suk na̱ gem wu. ");
INSERT INTO gyz_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","A lishikii ten ga̱ cina ɗe, ba̱k cugaa suk ma̱n pa̱t pa̱la̱n so, ");
INSERT INTO gyz_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","a nima dla̱mti ga̱ɓa ga̱n, ba̱ ɗe suk ma̱n pa̱t pa̱la̱n, suk ma̱n lamti mot wul nal, suk muka̱l suk ma̱n waal ji dii atl ga̱n ka̱ so. Kume na̱ si ka̱wu, se ko ta̱k zaka̱n dii atli. ");
INSERT INTO gyz_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ama a nikii ma lishti ɗe ba̱k cugaa suk ma̱lgwe ata̱ mbe gaa gwas ɗe ma̱n kopti, ama ata̱ pi pa̱la̱n, ata̱ lam mot wul wonti, ata̱ pa̱l waali, ata̱ sheli lal mbala̱n gaa, ata̱ tla ɗuki, sogo ata̱ te mbala̱n ga̱zi, ata̱ dla̱m byas ga̱ɓa ten mbala̱n, ngukti wul mago ba̱k nguka̱n suk wunda̱l ga̱ ma̱llu so. ");
INSERT INTO gyz_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","Yek ɗe ze gi na̱ kisti ga̱ɓa ma̱jwe ba̱sa̱ ɓo ni ɗe ma̱n kopti so wu ye? Ase ma̱jwe sa̱ni ka̱ motgaa kopti ju ka̱n kaa kisi ga̱ɓa so nwa? ");
INSERT INTO gyz_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","Nya ka kisi ga̱ɓa ma̱jwe ba̱sa̱ ɓo ni ɗe ma̱n kopti sowu. <<Mbola̱n byas ma̱lgwe ni ka̱ kii wu ka.>> ");
INSERT INTO gyz_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","Kume ilgon te ka̱ dlo ga̱ ma̱lgon suk yilka gwas ma̱n kopti go ba̱ta ta̱le mal mbala̱n ji Nya sa? A mal ma̱jwe ba̱ ma̱n kopti ka̱ sowu ka̱n ta̱le a? ");
INSERT INTO gyz_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Ka̱a̱ yisi ɗe mbala̱n ji Nya ka kisi ga̱ɓa ma̱n dii atl sa? Na̱k ɗe kik ka kisi ga̱ɓa ma̱n dii atl go, ba̱ ka man kisti ga̱ɓa ten nak mil wul jwisi sa? ");
INSERT INTO gyz_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Ka̱a̱ yisi ɗe mik ka kisi ga̱ɓa mil shinti ji Nya sa? Na̱k ɗe mik ka kisi ga̱ɓa mil shinti ji Nya wu, yek ka laki a wul ji dii atli kama̱nni gaa ye? ");
INSERT INTO gyz_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Na̱k ɗe nu ka̱wu kume wunda̱l ga̱ɓa jwisi te dlo gwaka̱n wu, botla̱n ma̱jwe a da̱n ɗe ma̱n kisti ga̱ɓa wu ko ba̱sa̱ ni ten bi ilgon so. ");
INSERT INTO gyz_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","A hwikii nu ka̱n ta̱ nsha cikii ɗa, ɓohwe ma̱lgon ma̱n ɓotlka̱n ka̱ kii gwe a ma̱n kisti ga̱ɓa ka̱ dlo ga̱ yilkeni ma̱n kopti kume ɗe ilgon te ka̱ dlo gwasa̱n wu nikii ɗa̱ sa? ");
INSERT INTO gyz_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ama yek a ma̱n kopti ta̱la yilka gwas ma̱n kopti ka̱ lu kisti ga̱ɓa mal ma̱jwe ba̱ ma̱n kopti ka̱ sowu. ");
INSERT INTO gyz_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Na̱k ɗe aka̱a̱ ta̱la yilkeni mal ma̱jwe ba̱ ma̱n kopti ka̱ so ta̱s kisisi ga̱ɓa go, yek ɗe ndat gwaka̱n. Yek laki ba̱ka dlo mbadl na̱ ilgwe sa̱ pa̱lik wu so ye? Dlanti suk yilkeni mago wul nsha ka̱n. Ka dlo mbadl na̱ byas ilgwe yilka gwa pa̱lik wu, a manikii. Yek laki ɗe ba̱ka zaki ta̱ yilkeni pa̱likii byas wul so ye? Yek laki ɗe ba̱ka zaki ta̱s tekii ga̱zi so ye? ");
INSERT INTO gyz_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Ama yek kii na̱ gaa gwaka̱n mago ka̱a̱ pa̱li byas wul yilkeni a ka̱a̱ te ma̱n kopti ga̱zi. ");
INSERT INTO gyz_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Ka̱ yisi ɗe Nya ɗe guu wo ga̱ ma̱n ngalci ka̱ so sa? Ba̱ ma̱lgon shelki so, na̱ ma̱n pa̱t pa̱la̱n, na̱ ma̱n waali, na̱ ma̱jwe asa̱ mul suk yilkeni ten tantu gwe ba̱ mbun sowu. Na̱ maani ma̱n ngot modli, na̱ maani ma̱n pa̱t suk maani sogo modli ma̱n pa̱t suk modli, ");
INSERT INTO gyz_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","na̱ muka̱l, na̱ ma̱n lamti wul ga̱ mbala̱n, na̱ ma̱n tlak ɗuki, na̱ ma̱n hwit byas ga̱ɓa mbala̱n, na̱ ma̱jwe asa̱ te ga̱zi mbala̱n wu, mas jwasa̱n sa̱ mbi Nya ɗe guu so ");
INSERT INTO gyz_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Nu ka̱n jon jwaka̱n ni tek wu, ama yek sa̱ polkii ka, yek sa̱ palla̱kii ɗe ma̱n cilti, yek sa̱ po palla̱kii ɗe ma̱n la̱shi byas wul ka̱ shin ga̱ Yesu Almasihu tumal Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","<<Sa̱ zaka̱nni ta̱n pa̱la̱n mas wul, ama ba̱ mas wul ka̱ ni hwaɓi mala̱n so. Ba man pa̱lti mas wul, ama ba̱ da̱n ɗe zhel ga̱ ilgon so.>> ");
INSERT INTO gyz_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Ama ma̱jon a wule, <<Sa̱ pa̱l shin ɗe ga̱ tuki, a tuk wo sa̱ pa̱li ɗe ga̱ shin,>> Ama Nya a lilsi ka mas. Sa̱ pa̱l dli go ba̱ ɗe ta̱ mbala̱n pi pa̱la̱n na̱ nali ka̱ so, sa̱ pa̱l dlisi ka̱n ten ɗe ga̱ Bagaa, ten na̱k gwisi ka̱n dli gwa wo ga̱ Bagaa ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Na̱k gwe nda̱lti ga̱ Nya tlil Bagaa kaal ɗa̱ ma̱shka̱n gwasi yek ta̱ pal kaami wu, nu ka̱n Bagaami a tlila̱nni ka̱ nda̱lti gwas pak. ");
INSERT INTO gyz_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Ka̱a̱ yisi ɗe dli ga̱ mas ma̱n kopti wo ka̱t dli ga̱ Almasihu ka̱ sa? Mbun ɗe ta̱n kama̱n dli ga̱ Almasihu a mwe suk kili ma̱n kopti maani ya? Ko njaa! ");
INSERT INTO gyz_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Ka̱a̱ yisi ɗe mas ma̱lgwe moo dli gwas suk kili ma̱n kopti maani go, dli gwas ɓal ɗena̱m sukti sa? Na̱k gwe ga̱ɓa ga̱ Nya dla̱m wu ɗe, <<Mbala̱n ɗe loɓi, sa pal ɗe dli ɗena̱m.>> ");
INSERT INTO gyz_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Ama mas ma̱lgwe mo gaa suk Bagaa go, ta̱ pal ɗena̱m sukti wi ka̱ shishi gwasi. ");
INSERT INTO gyz_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Aɓi pa̱t pa̱la̱n, mas byas wul jwe mbala̱n pa̱li go, ta̱n dli gwas so, ama ma̱lgwe pi pa̱la̱n go, ta̱ te dli gwas ga̱zi. ");
INSERT INTO gyz_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Ka̱a̱ yisi ɗe dli gwaka̱n wo boo ga̱ Shishi ga̱ Nya gwe ni ka̱ kii wu ka̱ sa? Gwe Nya ba̱lkii wu. Ka̱a̱ po yi ɗe ga̱ gaa gwaka̱n so. ");
INSERT INTO gyz_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","Nya wulkii wi. Na̱k ɗe nuk ni wu, nalla̱n Nya na̱ dli gwaka̱n. ");
INSERT INTO gyz_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Ten bi wul jwe ka̱ lishi wu, mbun ɗe ta̱ mbala̱n pa̱l hapti so. ");
INSERT INTO gyz_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Ama na̱k ɗe pa̱t pa̱la̱n nal ka̱ dlo gwaka̱n wu, ta̱ mas maani suk modli pa̱l hapti. ");
INSERT INTO gyz_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Ta̱ kos pa̱li ilgwe ni ngetli ɗe ta̱s pa̱li kili gwas wu, a kili mago ta̱s pa̱l ilgwe ni ngetli ɗe ta̱s pa̱li kos gwas wu. ");
INSERT INTO gyz_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Dli ga̱ kilisi wo gwas ka̱ so, ga̱ kosi ka̱n, a dli kosi wo gwas ka̱ so, ga̱ kilisi ka̱ pak. ");
INSERT INTO gyz_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Ba̱k nge ten dli jwaka̱n yilkeni so, se ko na̱ lamti gwaka̱n ga̱ nak njet da̱nti ta̱k ngema̱n Nya ɗa, apaa ka̱ palli mot gwaka̱n, ba̱ guu ma̱zhe cinga̱lkii so ɗa, na̱k ɗe ba̱ka̱a̱ man dlot mbadl na̱ la̱shi mot gwaka̱n sowu. ");
INSERT INTO gyz_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Amik ni kii ma hwit ga̱ɓa ge, Nya ka̱ wule ta hwikii so. ");
INSERT INTO gyz_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Lamti gi kani wu, a mbala̱n mas ni na̱k ami. Ama ko wokko na̱ manti gwe Nya ba̱lti wu. Ta̱ ba̱l manti pa̱lti ilga̱n ma̱lgon, zobsi ma̱lgon wo yek ta̱ ba̱lti manti pa̱lti ili gon. ");
INSERT INTO gyz_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Yenti gi wo mbun ɗe ta̱ ma̱jwe ɓo pa̱l hapti sowu suk modli jwe maani jwasa̱n ma̱sh wu da̱m ba̱ hapti so, ta̱s da̱n na̱k ami. ");
INSERT INTO gyz_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Sa pa̱l hapti go a mani si, ɗa̱ gwe ta̱ lamti modli sogo lamti maani man ngetl gwasa̱n wu. ");
INSERT INTO gyz_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Ma̱jwe pa̱l hapti wu, ha̱n ta hwikii mba̱t ge, amik dla̱m so, Bagaa ka̱ dla̱mi ɗe, <<Ba̱ kili huul suk kos gwas so.>> ");
INSERT INTO gyz_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","Ama kume kili a hul suk kos gwas wu, ba̱s po hap ma̱lgon so, seko ta̱s pal mal kos gwasi. Koosi mago ba̱s hul suk kili gwas so. ");
INSERT INTO gyz_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Ga̱ɓa gwe ba hwi naa mbala̱n go yek ɗe, ko ɗe amik dla̱mi, Bagaa ka̱ dla̱m sowu, yek ɗe kume kili ni ma̱n kopti ɗa, a kili si wo ba̱ ma̱n kopti ka̱ so, ata̱ lam da̱nti suk kos gwas wu, ba̱s hul sukti so. ");
INSERT INTO gyz_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","A kume kilisi ka̱ɗe ma̱n koptisi a koosi wo ba̱ ma̱n kopti ka̱ sowu, ata lam da̱nti suk kilisi wu, ba̱ kilisi hul sukti so. ");
INSERT INTO gyz_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","A dla̱m nu na̱k ɗe kosi ɗe ba̱ ma̱n kopti ka̱ sogo sa̱ polti ka̱wi tumal da̱nti suk kili gwasi. Nu ka̱n, kili gwe ba̱ ma̱n kopti ka̱ sowu, sa̱ polti ka̱wi tumal da̱nti gwas suk kos gwas ɗe ma̱n kopti wu. Nuk kani sogo mil jwasa̱n ani ga̱ poli so, ama yek gu ningo sa̱ polsi ka̱wi. ");
INSERT INTO gyz_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Ama kume ma̱lgwe ba̱ ma̱n kopti ka̱ so ka̱ lam zakti ga̱ ma̱n koptisi wu, ta̱s hwuli. Kume pi nu wu, ma̱n koptisi pa̱l byas wul so, na̱k ɗe Nya mbeni ta̱n da̱ma̱n na̱ ta̱mi mbadl suk mas mbala̱n wu. ");
INSERT INTO gyz_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Ki kili ma̱n kopti wu ka̱ yisi ya, a ɗe kik ka pa̱l tantu kisti ga̱ kos gwa wu? Ki kos wu ka̱ yisi ya, a ɗe kik ka pa̱l tantu kisti ga̱ kili gwa wu? ");
INSERT INTO gyz_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ha̱n ta̱ ko wokko pa̱l wunda̱l da̱nti gwe Nya ba̱lti ɗe ta̱s da̱ma̱n wu suk kangwe Nya mbet ɗe ta̱s pa̱li wu. Mba̱t gwe a ba̱l mas ma̱n kopti wuggu. ");
INSERT INTO gyz_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Ma̱lgwe sa̱ sa̱lti paa yek Nya mbet go, ba̱s ngwe ɗe ta̱s da̱m ba sa̱lti so. A ma̱lgwe Nya mbeti a ba̱sa̱ ɓo sa̱lti sogo, ba̱s ngwe ɗe ta̱s sa̱lti so. ");
INSERT INTO gyz_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Na̱ sa̱lti na̱ la̱shi sa̱lti, ko gon ni ten bi ilgon so. Ilgwe mani go yek ɗe kopti mba̱t ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Ha̱n ta̱ mas jwaka̱n da̱m na̱k gwe ka̱a̱ ni ɗe Nya mbekii wu. ");
INSERT INTO gyz_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Zhel ka̱ɗe kii ɗe Nya mbekii gwa? ba̱ hwotkii so, a kume ka ɓatl gaa gwaka̱n wu, ba̱k nge so. ");
INSERT INTO gyz_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Nu ka̱n kume Nya mbe mbala̱n ata̱ ni ɗe zhel go, mal Bagaa wo sa̱ ɓatlti wi. A ma̱lgwe Nya mbeti a ba̱ta̱ ni ɗe zhel sogo ta̱ da̱n ɗe zhel ga̱ Almasihu wi. ");
INSERT INTO gyz_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","Almasihu wulkii na̱ bal ɓatlti wi, Na̱ nu ka̱n ba̱k da̱ma̱n ɗe zhel ga̱ mbala̱n so. ");
INSERT INTO gyz_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Yilkeni jini, kangwe ɗe paa Nya mbekii wu, da̱ma̱n suk Nya nu. ");
INSERT INTO gyz_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Ten mil modli jwe ba̱sa̱ ɓo pa̱l hapti sowu, Bagaa hwi ilgon tensi so ama ba dla̱m ilgwe a yeni ɗe mbun wu na̱k ɗe ka̱a̱ yisi ɗe ami wo ma̱n pa̱lti gem ka̱n tumal yenti gonti ga̱ Bagaa wu. ");
INSERT INTO gyz_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","A yeni go mbun ɗe ta̱k da̱ma̱n na̱k gwe ka̱ ni wu na̱k ɗe mbala̱n ɓal ka̱ bomti wu. wul jwisi na̱ma pa̱t nu wu. ");
INSERT INTO gyz_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","A kume ka̱ pa̱l hapti wu, ba̱k ɓatla̱n ka̱ so. Kume ka̱ ɓo pa̱l hapti sowu, ngo hapti so. ");
INSERT INTO gyz_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Kume ka̱ pa̱l hapti wu, ka̱ pa̱l byas wul so. Kume yen kili pa̱l hapti wu, ta̱ pa̱l byas wul so. Ama ma̱jwe pa̱l hapti go sa tla bomti nal na̱ ngipti lubiii, yek laki yek a lami ɗe ta yilla̱kii ɗa̱ka̱ bomti gwisi ka. ");
INSERT INTO gyz_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Yilkeni, ilgwe a na̱ma dla̱mti go yek ɗe, multi gwe sa̱ zi go ɓal njaa. Kan ase ma̱jwe pa̱l hapti wu, ta̱s da̱n na̱k wule sa̱ ɓo pa̱la̱n hapti so. ");
INSERT INTO gyz_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","Ma̱jwe na̱ma duu tuk wu ta̱s da̱n na̱k wule sa̱ na̱nma duu tuk so, ma̱jwe na̱ma hwol tuk wu ta̱s da̱n wule sa̱ na̱nma hwol tuk so, ma̱jwe wul wul wu ta̱s da̱n wule wuli wo gwasa̱n ka̱ so ");
INSERT INTO gyz_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","Ma̱jwe na̱ma pa̱lti wul na̱ wul ga̱ dii atl go ba̱s zi mbadl dani so, na̱k ɗe a paki wu. ");
INSERT INTO gyz_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","A lami ɗe ta̱k gulsa̱la̱n gaa gwaka̱n so. Ma̱lgwe ɓo pa̱l hapti sogo, wul ga̱ Bagaa ka̱ hwotti i'e. ");
INSERT INTO gyz_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Ama ma̱lgwe pa̱l hapti wugo, daamti gwas wo ten wul ga̱ dii atl ka̱n ni, kangwe ta mulli mbadl kili gwas wu. ");
INSERT INTO gyz_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","Mbadl gwas wo ga̱ caali ka̱n ni. Nu ka̱n, kili gwe ba̱ kos niɗɗa̱ sowu, suk yen kili gwe ba̱ta̱ ɓo pa̱l hapti sowu, a wul ga̱ Bagaa hwotti i'e ta̱s da̱n zoki ka̱ Shishi. Kili gwe pa̱l hapti go a wul ga̱ dii atl hwotti ta̱s pa̱li kos gwas ilgwe ta̱ lami wu. ");
INSERT INTO gyz_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","A nikii ma dla̱mti nu ta̱ mbunikii. Ba̱ ɗe we ta palla̱kii ɗokco ka̱ so, ama ta̱k ngusi atl Nya ba̱ ilgon gulsa̱lkii so. ");
INSERT INTO gyz_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","Kume ma̱lgon ndal yen kili ɗe ta hapti, ama yek ta̱ yeni go ta̱ pa̱lit ilgwe ɗe ba̱ yek sowu a ta̱ ɓa koli ka, ama mas nu ta̱ lami ɗe ta̱s hapti wu. Ta̱s hapti, ta̱ pa̱l byas wul so. ");
INSERT INTO gyz_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Ama ma̱lgwe zi ka̱ mbadl ɗe ta hap yen kilisi so, a ba̱ ma̱lgon mbuki ta̱s zit ngetl sowu, ti mago ta̱ pa̱l hwa wul ɗe ta̱ hap yen kilisi sowu. ");
INSERT INTO gyz_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","Ma̱lgwe hap yen kilisi gwe ta̱ ndalti wu pa̱l hwa wul, ama ma̱lgwe hapti sowu pa̱l hwa wul mani. ");
INSERT INTO gyz_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Kili a hul suk kos gwas so kume ba̱ kosi ɓo ma̱sh sowu. Ama kosi ma̱sh wu, ta man hapti ga̱ mas ma̱lgwe ta̱ lami wu, ama ngetl ka̱n ta̱ ma̱lgwe ta hapti wu ni ɗe ma̱n kopti ga̱ Bagaa Yesu. ");
INSERT INTO gyz_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Ka̱ yenti gi wo, ta pa̱l hapti sogo ta kum ta̱mti mani, ka̱ yenti gi wo Shishi ga̱ Nya. ");
INSERT INTO gyz_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Ningo ten bi ilga̱ nguki gwe sa̱ taki gunki wu, mas jina̱n ma̱ yisa̱n wul wi, ko ɗe yistisi wo a lak mbala̱n ten nalti gaa, ama lamti yilkeni wo a laki a mbala̱n zi-ang mas mbala̱n. ");
INSERT INTO gyz_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Ma̱lgwe kan ɗe ta̱ yis ilgon go, ta̱ ɓo yisi na̱k gwe mbun ɗe ta̱s yisi wu so. ");
INSERT INTO gyz_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Ama ma̱lgwe lam Nya go, Nya yisti. ");
INSERT INTO gyz_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ten bi ilga̱ nguki gwe sa̱ taki gunki go, ma̱ yisi ɗe gunki wo ta̱ ni ten bi ilgon ten dii atl ge so. Ma̱lgwe mbuki ta̱ mbala̱n ngusit atl go ɗe na̱m ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Ko ɗe wul jwe a mbala̱n ngusisi atl wu ni ɗa̱ ten dii atli, sogo to dlo nya ka, na̱k ɗe wul jwe a mbala̱n ngusisi atli suk baboo ni ɗa wonti wu, ");
INSERT INTO gyz_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","mas na̱ nu, mi wo ma̱ yisi ɗe ma̱lgwe mbuki ɗe ta̱ mbala̱n ngusit atl go ɗena̱m ka̱n, tik ɗe Buka. Tik pa̱l mas wul, ti ka̱n ma̱ na̱ma da̱nti gwasi. Bagaa mago ɗena̱m ka̱n, tik ɗe Yesu Almasihu ma̱lgwe tumalti ka̱n mas wul pi wu. Mi mago ti ka̱n ma̱ nitma da̱nti. ");
INSERT INTO gyz_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Ama mas mbala̱n ka̱ yis gem gwisi so. Naa mbala̱n wo sa̱ ku na̱ gunki ka̱ lu waal wi. Hal ninge mago kume sa̱ nguk wul jwisi wu, asa̱ da̱ma̱n gwa we gwe sa̱ taki gunki wu ka̱n. Na̱k ɗe mbadl gwasa̱n kamisi nu sowu, sa̱ ɓa yeni go sa̱ pa̱l ilgwe ba̱ yek sowu. ");
INSERT INTO gyz_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Ilga̱ nguki a ta̱lani njaa mal Nya so; kume ma̱ nguka̱n sowu, mba̱li ni ilgon so, a kume ma̱ nguk wu, mba̱li ni ilgon dani so. ");
INSERT INTO gyz_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Pa̱n ɗem-ɗem na̱ pa̱lti ilgwe sa̱ zakkii ɗe ta̱k pa̱li wu, ba̱k laka̱n ma̱jwe nga̱sti gwasa̱n ten Yesu ɓo nda̱l sowu ten ndat so. ");
INSERT INTO gyz_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Kume ma̱jwe nga̱sti gwasa̱n ten Yesu ɓo nda̱l sowu yen ki ten ngukti ilga̱ nguki gwe sa̱ taki gunki ka̱ lu waal wu, ki ɗe ka̱ yisi man si wu, a laki asa̱ ngusi ngukti ilga̱ nguki gwe sa̱ taki gunkisi ka̱ lu waal wu sa? ");
INSERT INTO gyz_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Na̱ nu ka̱n yilka gwe nga̱sti gwas ten Yesu ɓo nda̱l sowu, gwe Yesu ma̱sh a gaa gwas go, yisti gwa a laki ata̱ zak nga̱sti gwas ten Yesu sa? ");
INSERT INTO gyz_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","Kume ka̱ pa̱li byas wul yilka gwa nu hal yek ba̱ta̱ man yisti dlo ga̱ byas wul suk hwaɓi sowu, Yesu ka̱n ka̱ pa̱lit byas wul. ");
INSERT INTO gyz_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Yek laki kume ilgwe a na̱ma ngukti wu a laki a yilka gi pa̱l byas wul wu, ba po nguk tlu so ba lak laki a yilka gi nda. ");
INSERT INTO gyz_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","A ɓo mbi gaa gi sa? A mi wo yen shinti ga̱ botli ga̱ Yesu ka̱sa? A yena̱n Yesu sa? Tumala̱n ka̱n ka̱a̱ da̱n ɗe ma̱n kopti sa? ");
INSERT INTO gyz_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Kume mal naa mbala̱n wo yen shinti ga̱ botli ga̱ Yesu ka̱ɗe ami sogo, ama kii wo ka̱a̱ yisi ɗe ami wo yen shinti botli ga̱ Yesu ka̱n, na̱k ɗe da̱nti gwaka̱n ɗe ma̱n kopti, mbok ang ɗe ami wo yen shinti ga̱ Yesu ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Ilgwe ba hwi ma̱jwe na̱ma kumti ga̱zi ɗe ko ami wo yenti shinti ga̱ botli ga̱ Yesu ka̱ɗe ami wuggu. ");
INSERT INTO gyz_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","Ngetli ka̱n ta̱s ba̱lni ilga̱ nguki suk ga̱ tle sa̱? ");
INSERT INTO gyz_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Ma mana̱n hapti kili ma̱n kopti na̱k gwe naa mil shinti ji botli ga̱ Yesu suk yilkeni ji Yesu suk Kepas pa̱li wu sa? ");
INSERT INTO gyz_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Ko ami suk Barnabas na̱ ngwena̱n ka̱n nini ngetli ta̱n ngo ilga̱ nguki na̱ gaa ga̱na̱n? ");
INSERT INTO gyz_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Ma̱n hapti dlo gwik ka kan diɓa̱lti ilga̱ nguki ga̱ gaa gwas gwi? Wok ka ɓak zhin inabi a ba̱ ta nguk yandi so wo? Wok ka pi kyo tunga tla a ba̱ta tla zeni gwasa̱n so wo? ");
INSERT INTO gyz_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ilga̱n ɗe a dla̱m go, ka̱a̱ ɓa yeni go daamti gi ga̱ mbala̱n ka? Mba̱t gwe Nya ba̱l Musa mago nu ka̱n dla̱m sa? ");
INSERT INTO gyz_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Nu ka̱n sa̱ lishi ka̱ mba̱t gwe Nya ba̱l Musa wu, <<Ba̱k kusi bi tla ka̱ so kume ta̱ na̱ma ɓot alkama wu.>> Ka̱a̱ da̱ma̱n gwa we ten tla ka̱n Nya na̱ma ga̱ɓa a? ");
INSERT INTO gyz_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Tenni ka̱n sa̱ lish ga̱ɓa gwisi sa? Gem tenni ka̱n sa̱ lishi. Na̱ ma̱n gut zhin na̱ ma̱n cokti alkama mas jwasa̱n sa̱ zi mbadl ka̱n ten ilgwe sa mbi wu. ");
INSERT INTO gyz_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Na̱k gwe ma̱ ɓak ga̱ɓa ga̱ Nya ka̱ mbadl gwaka̱n na̱k kangwe asa̱ ɓak gwe wunda̱l ka̱ zhin wu, byas wul ka kume ma̱ mbi ilgon malki wu? ");
INSERT INTO gyz_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","Kume ma̱jon man pa̱lti nu wu, ma̱ mbuki ta̱n pa̱li man gwasa̱n wu. Mas na̱ nugo, yek ba̱ma pa̱l ilgwe ma̱ mbuki ɗe ta̱n pa̱li wu so. Yek ma̱ dlo mbadl na̱ mas wul ɗa̱ gwe ta̱n tulli ilgwe a dla̱lli ga̱ɓa ga̱ Nya wu ka. ");
INSERT INTO gyz_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Ka̱a̱ yisi ɗe ma̱jwe pa̱l wul ka̱ bii ngemti Nya go ilgwe a mbala̱n tulli ka̱li wu ka̱ɗe ilga̱ nguki gwasa̱n sa? A ma̱jwe ɗe asa̱ taki wul Nya ka̱ lu taktisi go a giɓi ka̱n asa̱ mbi ilga̱ nguki gwasa̱n sa? ");
INSERT INTO gyz_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Nu ka̱n Nya dla̱m ɗe, <<Ma̱jwe dla̱m ga̱ɓa ma̱n ta̱mti go, ta̱s mbi ilga̱ nguki gwasa̱n tumal dla̱mti ga̱ɓa ma̱n ta̱mti.>> ");
INSERT INTO gyz_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","A ɓo taɓa wulti ɗe ta̱k pa̱lini nini wul jwisi so, nin mago ba̱ ɗe we na̱kka̱n a nikii ma lishti ta̱k pa̱lini nini so. Ma̱shka̱n manini ɗa̱ gwe ta̱s le bi ka a ba̱ ba man ɓot ngetl ten iljin ɗe a dla̱m wu sowu. ");
INSERT INTO gyz_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Dla̱mti ga̱ɓa ma̱n ta̱mti a laki a ɓo ngetl ɗe a mbuki so, na̱k ɗe ngetli ka̱n nini ta pa̱li wu. Ba da̱n ɗe wul cit gonti kume a dla̱m ga̱ɓa ma̱n ta̱mti sowu. ");
INSERT INTO gyz_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Kume lamti gi kani ɗe a na̱ma dla̱mti ga̱ɓa ma̱n ta̱mti wu, ngetli ka̱n ta̱s ɓatla̱nni. Ama na̱k ɗe ba̱ lamti gi ka̱ sowu, yek ɓal ɗe ilga̱ pa̱li gini. ");
INSERT INTO gyz_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Yek na̱ yek sa ɓatla̱n ye? Ilgwe sa ɓatla̱n na̱ na̱li go yek ɗe, kume a dla̱m ga̱ɓa ma̱n ta̱mti wu, ta pa̱li ten koo lu, ba wule ta̱s ba̱la̱n mas ilgwe ni ngetli ɗe ta̱s ba̱la̱n wu so ɗe a na̱ma dla̱mti ga̱ɓa ma̱n ta̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Ko ɗe ami wo zhel ga̱ ma̱lgon ka̱ sowu, ama yek a palli gaa gi ɗe zhel ga̱ mas mbala̱n ta dla̱k mbala̱n wonti tet mal Yesu na̱ mas manti gini. ");
INSERT INTO gyz_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","A pal mal ma̱n Yehuda wu, a palli gaa gi na̱ksi ta man ta̱lat gwasa̱n tet mal Yesu. A kume a pal mal ma̱n kopti mba̱t ga̱ɓa ga̱ Musa wu, a palli gaa gi na̱k ma̱n kopti mba̱t ga̱ Muse, (Ko ɗe mba̱ti ni gaa sowu). A pa̱li nu, ta man dla̱kti ga̱ ma̱jwe na̱ma kopti mba̱ti wu. ");
INSERT INTO gyz_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","Kume a ni suk ma̱jwe ma̱n Yehuda ka̱ sowu, a palli gaa gi na̱k ma̱lgwe mba̱t nit gaa sowu (Ba̱ ɗe we a kop mba̱t ka̱ so so, mba̱t ga̱ Almasihu ka̱n a na̱ma kopti). Ta man dla̱kti ga̱ ma̱jwe mba̱t nisi gaa wu. ");
INSERT INTO gyz_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","Kume a ɓal suk ma̱jwe nga̱sti gwasa̱n ten Yesu ɓo nda̱l sowu. A palli gaa gi na̱ksi ta dla̱ksi tet ɗa. A palli gaa gi ɗe wul wonti mal mbala̱n ta man dla̱kti gwasa̱n tet ɗa. ");
INSERT INTO gyz_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","A pa̱l mas wul jwisi ta ma̱dla̱l ga̱ɓa ma̱n ta̱mti, ta mbi hwa wul gini gwe ni ka̱ dla̱mti ga̱ɓa ma̱n ta̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Ka̱a̱ yisi ɗe ma̱jwe asa̱ pa̱l jetit tet yilkeni go, mbala̱n ɗe na̱m ka̱ɗe ma̱n tet gwasa̱n mas asa̱ ɓatlti sa? Aɓa̱nni ta̱k mbi ɓatlti. ");
INSERT INTO gyz_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Ma̱jwe asa̱ jeti go, asa̱ nol gaa gwasa̱n i'e ta̱s mbi ɓatlti gwe a paki wu. Ama mi wo ɓatlti gwe ma̱ na̱ma ngoti go gwe ba̱ a paki sowu ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Yek laki ɗe apti gwe a na̱ma pa̱lti go ten koo lu ka̱ so, a dlanti gi wo na̱k ma̱n ɓot yeta̱l ka̱ so. ");
INSERT INTO gyz_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","A nol dli gini yek a palli dlisi ɗe zhel gini. Ba̱ Nya la̱ka̱n ka̱ so kume a pak dla̱mti ga̱ɓa ma̱n ta̱mti wu. ");
INSERT INTO gyz_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Yilkeni jini, a lami ɗe ta̱k yisi ɗe aba jina̱n tet go mas jwasa̱n sa̱ ni ga̱s nyaze, yek sa̱ koɓi ka̱ dlo bal dla̱lka ma̱n tlal me. ");
INSERT INTO gyz_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","Yek sa̱ pa̱lisi baptisma ka̱ ɓondi suk ka̱ bal zesi ka̱ da̱nti gwasa̱n ɗe ma̱n kopti ga̱ Musa. ");
INSERT INTO gyz_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Mas jwasa̱n sa̱ nguk ilga̱ nguki ga̱ Shishi wunda̱li ɗena̱m. ");
INSERT INTO gyz_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","Mas jwasa̱n sa̱ tla wul ga̱ tle ga̱ Shishi wunda̱li ɗena̱m. Sa̱ tla tet ka̱ paa ga̱ Shishi gwe ngusi kopti gwasa̱n wu. Paa gwisi wo yek ɗe Almasihu. ");
INSERT INTO gyz_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Ama mas na̱ nu, yek ba̱ Nya pa̱l hwol tuk na̱ wonti ka̱si so. Yek hwu gwasa̱n cat ɗa̱nka̱ me ka. ");
INSERT INTO gyz_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Wul jwisi pi ta̱n yeni ni ba̱n za̱n mbadl ten byas wul na̱k gwe sa̱ pa̱li wu so. ");
INSERT INTO gyz_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Ba̱k ngusi atl gunki na̱k gwe jon jwasa̱n pa̱li wu so. Na̱k gwe ni ga̱ lishi wu ɗe, <<Yek mbala̱mi da̱m na̱ zhila yek sa̱ nguk wul, yek sa̱ tla, yek sa̱ tlinya yek sa̱ dlali, na̱k ma̱n waali.>> ");
INSERT INTO gyz_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Ba̱n pa̱n pa̱la̱n na̱k gwe sa̱ pa̱li wu so, gwe laki yek zangu ɗe kutl ɗe lop na̱ mekan ka̱si ma̱sh ten cin ɗe na̱m. ");
INSERT INTO gyz_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Ba̱n cinga̱la̱n Nya na̱k gwe jon jwasa̱n pa̱li wu so. Yek laki yek wuci assi yek sa̱ ma̱shi. ");
INSERT INTO gyz_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Ba̱k nala̱ma̱nni na̱k gwe jon jwasa̱n pa̱li wu so hal yek Yen Shinti ga̱ Nya ma̱n tloti tlosi ka̱wu. ");
INSERT INTO gyz_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Mas wul jwisi pi ta̱n yeni ni. Yek sa̱ lishi ta̱s da̱lini ka̱ng ɗa mi ɗe ma̱ na̱n ka̱ pakti multi wu. ");
INSERT INTO gyz_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Yek laki kume ka̱ da̱ma̱n gwa we ka̱ dla̱l nda̱li wu, pi ɗem-ɗem. ");
INSERT INTO gyz_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Kangwe sa̱ cinga̱lkii wu mas, yisi ɗe sa̱ cinga̱l ma̱jon nu wi pak. Na̱k ɗe Nya wo ma̱n pa̱lti gem ka̱n, ta zak cinga̱lti gwe a man ngetl gwaka̱n wu a mbikii so. Kume sa̱ cinga̱lkii wu, ta pa̱likii tantu gwe ka yil wu aka̱a̱ man dla̱lti. ");
INSERT INTO gyz_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Yela̱n jini kii ɗe a lamkii wu, aɓi ngusti atl gunki. ");
INSERT INTO gyz_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Ga̱ɓa ga̱n go ma̱n ɓotlka̱n ka̱n a nisi ma hwiti, ɓo daama̱nkii ten ilgwe a dla̱m wu. ");
INSERT INTO gyz_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Mbuka hwa wul ga̱ Nya gwe a ma̱ pa̱la̱n hwol tuk na̱ nali go yek laki yek ma̱ palla̱n ɗe na̱m ka̱ hwulan ga̱ Yesu sa? Burodi gwe a ma̱ cali go, yek ɗe ma̱n lakti a ma̱ palla̱n ɗe na̱m ka̱ dli ga̱ Almasihu sa? ");
INSERT INTO gyz_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Na̱k ɗe ba̱redi ɗe na̱m ka̱wu, mi ɗe ma̱na̱n wonti go ɗena̱m ka̱n ma̱na̱nni, na̱k ɗe ba̱redi ɗena̱m ka̱n ma̱ nguka̱n wu. ");
INSERT INTO gyz_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Ɓo yena̱n ma̱n Yisiraila la, ma̱jwe asa̱ nguk ilgwe asa̱ mboshi Nya go, ɗena̱m ka̱n sa̱ni ka̱ ngukti ilgwe sa̱ taki Nyami wu sa? ");
INSERT INTO gyz_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Yek a lamikii dla̱mti a ɗe ye? Ɗe ilgwe asa̱ mboshi gunki go hwa wul laa? Ko ɗe gunki wo hwa wul ka̱n? ");
INSERT INTO gyz_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Ko njet, ilgwe a ma̱n waali mbosh wu ka̱n a na̱ma ga̱ɓa dani. Ma̱n waal wo ma̱zhe ka̱n asa̱ mboshisi wul, Nya ka̱n asa̱ mboshit so. A lami ɗe ta̱ ilgon mokii suk ma̱zhe so. ");
INSERT INTO gyz_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","Kaa tla ka̱ mbuka ga̱ Bagaa aka̱ po tla ka̱ mbuka ga̱ ma̱zhe so. Ka nguk ten tebur ga̱ Almasihu aka̱ po nguk ten tebur ga̱ ma̱zhe so. ");
INSERT INTO gyz_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Ma̱ na̱mma lamti ta̱ daka̱lti ga̱ Bagaa tli ya. Ma̱ nda̱la̱n manti ya? ");
INSERT INTO gyz_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Mbala̱n na̱ma wulti ɗe, <<Sa̱ zaka̱nni ta̱n pa̱la̱n mas wul,>> ama ba̱ mas wul ka̱ mbunikii so. A sa̱ na̱ma wulti ɗe, <<Sa̱ za̱ka̱nni ta̱n pa̱la̱n mas wul.>> ama ba̱ mas wul ka̱ɗe man taimakat ga̱ mbala̱n so. ");
INSERT INTO gyz_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Ba̱ ilga̱ gaa gwa na̱ ngwe hwotki so, ama ta̱ wul ji naa mbala̱n hwotki pak. ");
INSERT INTO gyz_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Nguka̱n mas tlu gwe asa̱ wul ka ka̱ lu motgaa wu, ba̱k kuma̱n ga̱z ga̱ lu gwe yil tet wu so. Ba̱ mbadl gwaka̱n gulsi ka ten lu gwe yil tet wu so ");
INSERT INTO gyz_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Na̱k gwe ga̱ɓa ga̱ Nya dla̱m wu, <<Dii atli na̱ mas ilgwe ni giɓi wu, ga̱ Bagaa ka̱n.>> ");
INSERT INTO gyz_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","Kume ma̱jwe ba̱ ma̱n kopti ka̱ sowu mbekii ɗe ta̱k nguka̱n wul a ɗaasi ka̱wu, nguka̱n mas ilgwe sa̱ ba̱lkii wu ba̱k kuma̱n ga̱zi so ba̱ hwot mbadl gwaka̱n so ɗa. ");
INSERT INTO gyz_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Ama kume ma̱lgon wulkii ɗe tlu ga̱n go gunki ka̱n sa̱ mboshit wu, ba̱k nguka̱n so, a gaa ga̱ ma̱li, a ki mago mbadl a ta̱mik so ");
INSERT INTO gyz_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Ba̱ ɗe kangwe ka̱ daamkii dani wu so, ama kangwe ma̱li a daamti wu. Gon a ma̱lgon wule, <<Yek ka laki a ilgwe mbadl gi lami wu da̱n ɗe wul ga̱ɓa mal ma̱lgon ye?>> ");
INSERT INTO gyz_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","Kume a nguk wul a nima pa̱lti hwol tuk na̱ Nya go, yek ka laki a ma̱lgon yena̱n na̱ duu gwel ten ilgwe a nguki a na̱ma pa̱lti hwol tuk na̱ Nya gwe? ");
INSERT INTO gyz_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Mas ilgwe kaa pa̱li wu, ko ngukti ko tlati, pa̱lini mas ta̱ Nya mbi nalti. ");
INSERT INTO gyz_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Ba̱k laka̱n ma̱lgon ta̱s pa̱l byas wul so, ko ta̱ ma̱n Yehuda, ko ta̱ ma̱jwe ba̱ ma̱n Yehuda ka̱ sowu, ko ta̱ motgaa ga̱ ma̱n kopti ga̱ Yesu. ");
INSERT INTO gyz_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Pa̱li na̱k gwe a na̱ma pa̱lti wu, a na̱ma dlot gini ta pa̱l ilgwe mas mbala̱n a kum ta̱mti na̱ mas ilgwe a na̱ma pa̱lti wu. A pa̱l wul a gaa gi na̱ nge so, ama a gaa ga̱ ta̱ mbala̱n wonti mbi kisti ɗa. ");
INSERT INTO gyz_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Pa̱la̱n ilgwe a pa̱li wu na̱k gwe a pa̱l ilgwe Almasihu pa̱li wu. ");
INSERT INTO gyz_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","A ta̱skii na̱k ɗe ba̱kaa ma̱sa̱na̱n ka̱ mas ilgwe ka̱a̱ na̱ma pa̱lti sowu, ka̱a̱ ngip ilgwe a mbokikii ang dani wu na̱k gwe ka̱a̱ kumi wu. ");
INSERT INTO gyz_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","A lami ɗe ta̱k yisi ɗe Almasihu ka̱ɗe bacina ga̱ mas maani, a maani ka̱ɗe bacina ga̱ modli. A Nya ka̱ɗe bacina ga̱ Almasihu. ");
INSERT INTO gyz_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Mas maani gwe ngem Nya, sogo ta̱ dla̱m ga̱ɓa ga̱ Nya na̱ gaa ga̱ yitle ka̱ go, ta̱ mbul bacina gwasi. ");
INSERT INTO gyz_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Mas kili gwe ngem Nya, sogo ta̱ dla̱m ga̱ɓa Nya a ba̱ta̱ yitla gaa gwas ka̱ sogo, ta̱ mbul bacina gwasi. Ndakce suk ta̱s wutl gaami ka ka̱n. ");
INSERT INTO gyz_vpl VALUES ("C111_6",