﻿USE sofia;
DROP TABLE IF EXISTS sofia.gyrNT_vpl;
CREATE TABLE gyrNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gyrNT_vpl WRITE;
INSERT INTO gyrNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Co yɨpɨndar Jesucristo renondeve yuvɨrecoi vahe aracahe Abraham suindar, mborerecuar guasu David suindar avei: ");
INSERT INTO gyrNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham rahɨr Isaac, Isaac rahɨr evocoiyase Jacob, ipare Jacob rahɨr ahe Judá ambuae tɨquehɨr, tɨvɨreta reseve. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá rahɨr yuvɨrecoi Fares iyavei Zara (ahe ichɨ rer Tamar). Fares rahɨr Esrom, Esrom rahɨr evocoiyase Aram. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram rahɨr Aminadab, Aminadab rahɨr Naasón, Naasón rahɨr evocoiyase Salmón, ");
INSERT INTO gyrNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón rahɨr Booz (ahe ichɨ rer Rahab). Booz rahɨr Obed (ahe ichɨ rer Rut), Obed rahɨr Isaí, ");
INSERT INTO gyrNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí rahɨr mborerecuar guasu David, David rahɨr evocoiyase Salomón, Urías rembirecocuer pɨpe oyesu vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón rahɨr Roboam, Roboam rahɨr Abías, Abías rahɨr Asa. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa rahɨr Josafat, Josafat rahɨr Joram, Joram rahɨr evocoiyase Uzías. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías rahɨr Jotam, Jotam rahɨr Acaz, Acaz rahɨr ahe Ezequías. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías rahɨr Manasés, Manasés rahɨr Amón, Amón rahɨr evocoiyase Josías. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías rahɨr Jeconías tɨvɨreta reseve, Babilonia ve mbiguai yuvɨrecoi vahecuer. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mbiguai yuvɨrecoire Jeconías omboyesu Salatiel, Salatiel rahɨr ahe Zorobabel. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel rahɨr Abiud, Abiud rahɨr ahe Eliaquim, Eliaquim rahɨr evocoiyase Azor. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor rahɨr Sadoc, Sadoc rahɨr ahe Aquim, Aquim rahɨr evocoiyase Eliud. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud rahɨr Eleazar, Eleazar rahɨr ahe Matán, Matán rahɨr evocoiyase Jacob. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob rahɨr José, María mer, María evocoiyase Jesús sɨ secoi. Ahe imembrɨ Tũpa Rembiporavo Poropɨ̃sɨrosar. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Evocoiyase Abraham yesusa sui tuprɨ oyepota oso David yesusa rupive. Ahe catorce yesu yoapɨ agüer. David reco agüer sui oyepota oso ava mbiguai sereco agüer pɨpe Babilonia ve; ahe omomba avei catorce yesu yoapɨ agüer. Mbiguai ava serecosa sui oyepota aravɨter Poropɨ̃sɨrosar haragüer rupi, ahe omomba iri avei ambuae catorce yesu yoapɨ agüer. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na ehi Jesucristo oyesu aracahe. María, ichɨ, ahe omenda pota vahe José rese. Oyese yuvɨrecoiẽhɨ vɨteseve rumo, Espíritu Santo pĩratasa pɨpe imembɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Evocoiyase José, imevɨ, ahe ava seco catuprɨ vahe, “Tapoiño ayase ava icuaẽhɨsa pɨpe che remimbotar rupi ichui” ehi chupe viña ‘co rupi tarecomegua eme co cuñatai rer avɨye vahe’ ohesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aipo opɨhañemoñeta reseve oque. Iquerve rumo, Tũpa rembiguai oyemboyecua chupe aipo ehi: “José, David suindar, eresɨquɨyei rene María rese nde menda ãgua. Esepia, Espíritu Santo sui ou imembɨrã. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María vɨrecose omembrɨ, pemondora sererguã Jesús. Esepia, ahe oipɨ̃sɨrora omu judío eta yangaipa sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Co rupi opa yavɨye yande Yar remimombehugüer aipo ehi vahecuer iñehe mombehusar aracahe: ");
INSERT INTO gyrNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Cuña ndaseco marai vahe imembɨra. Ahe imembrɨ rer-ra Emanuel” ehi (‘Tũpa yande rese ité secoi’ oya aipo ehi). ");
INSERT INTO gyrNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Omahese José, Tũpa rembiguai oyeupe ñehe agüer omboyeroya ité. Ichui omenda María rese cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ndoyapo vɨtei eté rumo mbahe oyese yuvɨreco. Yɨpɨndar imembɨra rane ité, ahese José omondo Jesús sererguã. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes mborerecuar guasu recose, Jesús oha Judea ɨvɨ rupi tecua Belén ve. Coiye yugüeru ava yasɨtata rese oyembohe vahe arɨ sẽsa cotɨ sui Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ahe oporandu Herodes upe yuvɨreco aipo ehi: —¿Que vo aipo oha judío rerecuar guasu? Esepia niha, caharu cotɨ yasɨtata orosepia. Sese oroyu arɨ sẽsa cotɨ sui imboetei ãgua —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aipo ihese, mborerecuar Herodes oyembosɨquɨye tẽi, ava Jerusalén pendar avei ẽgüe ehi pãve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iyavei cũriteimi opa omonuha uca pahi rerecuareta, Moisés porocuaita rese oporombohe vahe avei. Ipare oporandu chupe: —¿Que vo aipo ohara Poropɨ̃sɨrosar? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ahe omboyevɨ yuvɨreco chupe: —Ahe ohara Judea rupi Belén ve —ehi—. Esepia, Tũpa ñehe mombehusar Miqueas rembicuachiagüer pɨpe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Pe, tecua mini Belén pɨpendar, ndahei ɨvɨ cotɨ tẽi vahe ambuae tecua Judá pɨpendar sui peico. Esepia, pe sui osẽra mborerecuar che recua ɨguar Israel yocuai ãgua’ ehi —ehi yuvɨreco Herodes upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aipo hese, Herodes oñehe ñemi ava yasɨtata rese oyembohe vahe upe ‘toicua eme ava yuvɨreco’ oyapave oporandu: “¿Mbahe yasɨ pɨpe ité vo pesepia ramo aipo yasɨtata?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Oyeupe mombehu pare, omondopa Belén ve aipo ehi chupe: —Peso evocoiyase, peseca pĩtani. Acoi peyosuse, co rupi avei peyevɨ cheu icua uca ãgua. Che avei evocoiyase tasomi imboetei —ehi angahu chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aipo oyeupe he pare, yasɨtata rese oyembohe vahe osɨrɨño voi yuvɨraso. Ahe pɨpeve yasɨtata oyemboyecua iri senonera. Ichui pĩtani recosa rese tuprɨ tecua Belén ve opɨta yasɨtata. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Sepiase, ovɨhareté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ipare yuvɨroique oɨ pɨpe, osepia pĩtani ichɨ María reseve yuvɨreco. Ichui oñenopɨha sovai imboeteisa pɨpe. Ipare opõhe ombahe rɨru pɨpe yuvɨreco oicuavẽhe vaherã oporerecosa sepɨrusu vahe oro, itaɨsɨ, ambuae mbahe sɨ̃acua vahe mirra serer vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yuvɨroyevɨse güecuave yuvɨraso, ndoyuvɨroyevɨ iri Jerusalén rupi mborerecuar Herodes upe imombehu. Esepia, Tũpa aipo omombehu iquerve chupe ambuae perɨ rupi iyevɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aipo ava yepepɨ pare, José upe oyemboyecua Tũpa rembiguai iquerve, aipo ehi chupe: “Eñarapuha, eroñemi pĩtani ichɨ reseve eraso Egipto ve. Aheve erepɨtara acoi che amombehuse voi nde yevɨ ãgua. Esepia, mborerecuar Herodes osecara pĩtani yuca ãgua oico” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ahe pɨ̃tu pɨpeve voi José vɨraso pĩtani ichɨ reseve Egipto ve. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aheve yuvɨrecoi co mborerecuar Herodes mano rãro. Co rupi imboavɨyesa Tũpa ñehe mombehusar remimombehugüer: “Egipto sui anose che Rahɨr” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mborerecuar Herodes rumo oñemoɨró iteanga yasɨtata rese oyembohe vahe ombopa tẽisa rese. Sese, “Toyuvɨraso sundao tecua Belén ve, toyucapa chĩhivahe cuimbahemi yuvɨreco opacatu ñuvɨrío aravɨter ovɨreco vahe, chĩhivahemi catu vahe avei, ahe tecua ɨvɨrindar pɨpe avei no” ehi. Esepia, omoñetase yasɨtata rese oyembohe vahe yuvɨreco, oicua ahe aravɨter opa cũritei. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ẽgüe ehi yavɨye Tũpa ñehe mombehusar Jeremías remimombehugüer aipo ehi vahe: ");
INSERT INTO gyrNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Oyeendu ava Ramá ve. Ahe Raquel oyaseho ité omembɨreta manose; ndoyembovɨha catui eté ipɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mborerecuar Herodes manore, Egipto ve José upe oñehe iri Tũpa rembiguai iquerve aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Eñarapuha, eroyevɨ pĩtani ichɨ reseve Israel recuave. Esepia, opa omano pĩtani yuca potasar yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Aipo oyeupe hese, oñarapuha, vɨroyevɨ pĩtani ichɨ reseve Israel recuave. ");
INSERT INTO gyrNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Perɨ rupi oyanduse rumo Arquelao vu recoyar mborerecuar chinise, ahese oyembosɨquɨye aheve oso ãgua. Coiyemi tẽi iquerve Tũpa, “Peso Galilea ɨvɨ rese” ehi chupe. Ichui yuvɨraso tecua Nazaret ve. Aheve opɨta yuvɨreco cute. Ẽgüe ehi yavɨye Tũpa ñehe mombehusar remimombehugüer: “ ‘Nazaret pendar’ ehira serecosa” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ipare Juan Oporoãpiramo vahe Tũpa recocuer rese oñehe oico Judea ɨvɨ rupi ava yemboerecuaẽhɨsave ");
INSERT INTO gyrNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","aipo ehi: “¡Pemboasɨ pe angaipa; peyevɨ Tũpa upe! Esepia, co Tũpa mborerecuasa cõimi secoi yandeu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Co Juan rese niha oñehe yɨpɨve Tũpa ñehe mombehusar Isaías aipo ehi güembicuachiagüer pɨpe: “Oyeendu ñehesa ava yemboerecuaẽhɨsave: ‘Pemoingatu yande Yar raperã; pemohɨvi tuprɨ avei’ ehi” ehi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan turucuar ahese camello ragüer apoprɨ, sumbɨcuasa mbahe pirer, sembihu evocoiyase tucru, eirɨ caha pɨpendar avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Opacatu ava Jerusalén pendar, Judea rupindar tecua, ɨai Jordán rerovɨca pendar avei yuvɨraso iñehe rendu ");
INSERT INTO gyrNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","oangaipagüer mombehu ãgua. Ahese Juan oñapiramo ɨai Jordán pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yugüeru atɨse rumo fariseo iyavei saduceo oñeapiramo uca ãgua, Juan aipo ehi ahe ava upe: “¡Pe mboi mboetasa tẽi peico! ¿Ava vo, ‘Pesẽra Tũpa ñemoɨrosa ou vaherã sui’ ehi tuprɨ tẽi pẽu? ");
INSERT INTO gyrNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yɨpɨndar toyecua tuprɨ rane Tũpa upe pe yevɨsa pe angaipa mboasɨsa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Iyavei ndapeyeroyai chira ‘ore Abraham suindar oroico’ pe hesa rese tẽi pe ñepɨsɨro ãgua. Esepia, Tũpa oicatuño ité co ita sui Abraham suindar nungar tuprɨ apo ãgua oyeupe nara yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hacha niha imoingatusa voi eté opacatu ɨvɨra ndihai vahe sapo rupi yasɨa ãgua. Ichui yasɨa pare imondosa tatave. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Che ɨ pɨpe tẽi opoãpiramo Tũpa upe pe yevɨ ãgua. Oura rumo ambuae che raquɨcuei, ahe pe ãpiramora Espíritu Santo tata nungar pɨpe. Ahe seco pĩrata catu vahe secoi che sui. Sese cheu ndiyai eté ahe ipɨtaquisã yora ãgua ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ahe oipehara mbahe rãhɨi ihɨgüer sui. Sãhɨi evocoiyase oyapocatura, ihɨgüer rumo omondora tata apɨrẽhɨ vahesave” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ipare Jesús oso Galilea sui ɨai Jordán ve Juan recosave ‘tache ãpiramo’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yɨpɨndar rumo Juan ndoipotai eté, aipo ehiño chupe: —Nde rumo iya ité che ãpiramora eve viña, ¿nde rumo ereyu che nde ãpiramo ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—Ẽgüe tehiño aipo. Iyacatu yayapora Tũpa porocuaita —ehi Juan upe. Evocoiyase Juan, “Avɨye” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Oãpiramo pare, osẽ ɨve sui. Ahe pɨpeve voi ɨva oyemboi tuprɨ, aheseve avei osepia Tũpa Espíritu ogüeyɨse ou iharɨve apɨcasu nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iyavei oyeendu ñehesa ɨva suindar aipo ehi vahe: “Co che Rahɨr, che rembiaɨsu. Sese avɨharete vichico” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ipare Tũpa Espíritu vɨraso Jesús ava yemboerecuaẽhɨsave ‘tosecoãha Caruguar’ ohesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Aheve cuarenta arɨ, cuarenta pɨ̃tu ndocarui. Sese ndasɨepoi eté oico. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Evocoiyase oyemboya Caruguar sese secoãha ãgua, aipo ehi chupe: —Tũpa Rahɨr ité nde recose, co ita sui eyapo pan cũritei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús rumo omboyevɨ chupe: —Icuachiaprɨ pɨpe rumo aipo ehi: ‘Ndahei chira pan sui güeraño ava yuvɨrecove. Ẽgüe ehi rumo opacatu Tũpa Ñehengagüer reroya pɨpe ava yuvɨrecovera yepi’ ehi —ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ichui Caruguar vɨraso Jesús Jerusalén maranehɨ pɨpendar tũparo torre apɨterve. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Aheve aipo ehi chupe: —Tũpa Rahɨr ité nde recose, evɨapi cohave sui. Esepia niha, icuachiaprɨ pɨpe: ‘Tũpa oyocuaira güembiguai eta nde rãro ãgua. Ahe nde mopuhara yuvɨreco que ñepei ita nde momara rãgüer sui’ ehi —ehi Caruguar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Evocoiyase omboyevɨ Caruguar upe: —Icuachiaprɨ pɨpe rumo aipo ehi avei no: ‘Nderesecoãhai chira nde Yar Tũpa’ ehi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ipare Caruguar vɨraso iri ɨvɨtrɨ ɨvate vahe apɨterve secoãha ãgua. Aheve aipo opacatu ɨvɨ pɨpendar, tecua guasu pɨpendar mbahe porañete vahe yemboɨvate aisa omboyecua chupe, ");
INSERT INTO gyrNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","aipo ehi: —Che rovai ereñenopɨhase che mboeteisave, co opacatu mbahe nde rembiepia amondora nde mahera —ehi Caruguar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aipo oyeupe hese: —Eyepepɨ che sui cũritei, Caruguar —ehi—. Esepia, icuachiaprɨ: ‘Emboetei nde Yar Tũpa, ahe güeraño tuprɨ avei eremboyeroyara’ ehi —ehi Caruguar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ahese Caruguar oyepepɨ ichui. Ipare Tũpa rembiguai yuvɨrogüeyɨ Jesús rese hañeco ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesús oyanduse Juan roquendasa, oso Galilea ɨvɨ rese Nazaret ve. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ndopɨtai rumo aheve. Osoño Capernaum ve, aheve opɨta. Ahe tecua ɨpa Galilea ɨvɨi, ɨvɨ Zabulón iyavei Neftalí rupi avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na ehi yavɨye Tũpa ñehe mombehusar Isaías rembicuachiagüer aipo ehi vahe aracahe: ");
INSERT INTO gyrNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Co ava ɨvɨ Zabulón pendar, Neftalí pendar, para guasu ɨvɨrindar, ɨai Jordán rovaindar iyavei Galilea pɨpendar ndahei vahe judío, ");
INSERT INTO gyrNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ahe avɨye pɨ̃tumimbisave yuvɨrecoi vahe, osepia ramo vahe tesapesa yuvɨreco; iyavei mano rãgüer pɨpe yuvɨrecoi vahe upe avei avɨye oyecua ramo vahe tesapesa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ahe arɨ suive Jesús omombehu Tũpa recocuer ava upe: “Pemboasɨ pe angaipa; peyevɨ Tũpa upe. Esepia, cõimi eté Tũpa mborerecuasa secoi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Coiye ɨpa Galilea ɨvɨi oguatase, Jesús osepia mbɨa Simón Pedro serer vahe tɨvrɨ Andrés reseve. Ahe pira omboha yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Evocoiyase: —Pe pira recasar peico. Perio che rupi. Na peye aveira ava reca ãgua cheu nara —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aipo he ramoseve, opoi opira mbohasa sui yuvɨreco, yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Coi cotɨ catu aipo Jesús osepia ambuae mbɨa Santiago tɨvrɨ Juan reseve, ahe oguapɨ yuvɨnoi carite pɨpe oyesupa Zebedeo pɨri; omoingatu opira mbohasa yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","“Perio che rupi” he ramoseve, opaño oporavɨquɨsa sui opoi yuvɨreco, oseyaño oyesupa, yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús evocoiyase oguata opacatu Galilea ɨvɨ rupi, judío tũparo yacatu rupi oporombohe oico. Aheve ñehesa avɨye vahe omombehu Tũpa mborerecuasa resendar. Oporombogüera avei opacatu-catu tẽi mbaherasɨsa ava vɨreco vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Oyepotase rumo serãcua opacatu Siria ɨvɨ rupindar upe, ahese güeru opacatu iparaɨsu vahe yuvɨreco chupe: imbaheasɨ vahe, caruguar vɨreco vahe, que nañaca põrai vahe iyavei ndoguatai vahe. Ahe opa tuprɨ ombogüera. ");
INSERT INTO gyrNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ẽgüe ehi ava rehɨi oguata yuvɨreco opacatu iguatasa rupi supi: Galilea pendar, Decápolis pendar, Jerusalén pendar, opacatu Judea pendar, ɨai Jordán rovaindar avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ñepei arɨ pɨpe, ava rehɨi repiase, Jesús oyeupi ɨvɨtrɨ rese. Aheve oguapɨ oĩ. Ahese semimbohe oyemboya yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ichui omboɨpɨ imbohe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sorɨvete catura acoi ava oicuase mbahe ipane vahe Tũpa rese ité güeco tuprɨ ãgua. Esepia niha, chupe nara ité Tũpa mborerecuasa. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Sorɨvete catura acoi ava oyaseho vahe ovɨharẽhɨsa pɨpe. Esepia niha, Tũpa omboura vɨharetesa chupe coiye. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Sorɨvete catura ndaseco asɨimi vahe. Esepia, ahe chupe imondosara co ɨvɨ imahera curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Sorɨvete catura ava oipota vahe teco catuprɨsa Tũpa suindar. Esepia, chupe ité ahe imondosara. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Sorɨvete catura acoi ava oporoparaɨsuereco vahe. Esepia, ahe Tũpa oiparaɨsuerecora. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Sorɨvete catura acoi ava ipɨhañemoñeta tuprɨ vahe. Esepia niha, ahe osepiara Tũpa yuvɨreco curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Sorɨvete catura acoi ava oporomoñeroi vahe mbahe tuprɨ pɨpe. Ahe chupe, ‘Che rahɨr ité’ ehira Tũpa. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Sorɨvete catura acoi ava seco catuprɨ rese imombaraɨsuprɨ. Esepia, ahe chupe nara Tũpa mborerecuasa. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Perorɨvete catura pe acoi ava iñehe-ñehe tẽise pẽu, iyavei pe mombaraɨsuse, acoi oyapo-yapo tẽise güemira-mira tẽi pɨpe mbahe pe rese che recocuer sui tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pe rumo peyembovɨhañora. Esepia, ɨvave tuvichá vahe porerecosa peipɨsɨra curi. Ẽgüe ehi avei niha yɨpɨndar evocoi ava ramoi Tũpa ñehe mombehusareta mombaraɨsu yuvɨreco aracahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Co ɨvɨ pɨpe pe avɨye yucrɨ peico opacatu ava upe. Yucrɨ rumo nasehe irise, ndayaicatui imoehe iri ãgua, ndiporusai chietera; imombopasara ava pɨrunga ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Iyavei pe tesapesa nungar peico opacatu ava upe co ɨvɨ pɨpe inungar que tecua guasu yapoprɨ ɨvɨtrɨ rese. Ahe ndayaicatui ñomi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Iyavei ndayamoendɨi chira tataendɨ mbahevrɨve tẽi. Iyacatu rumo yasupi ɨvate sendave opacatu oɨ pɨpendar ava resape ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pe ẽgüe peye aveira pemboyecua ava eta upe pe recocuer avɨye vahe. Ipɨpe sui tomboetei yande Ru Tũpa ɨva pendar yuvɨreco” ehi ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Aní chira, ‘Co mbɨa revo oporombohe Tũpa ñehe mombehusar rembicuachía mboyeroyaẽhɨ ãgua iyavei Moisés porocuaita cuachiaprɨ mboyeroyaẽhɨ ãgua avei no’ peye tẽi cheu. Ẽgüe ehi rumo che ayu imboavɨye ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Supi eté co ɨva, ɨvɨ avei yandeu oime vɨtemiseve, ndipoi chietera que ñepei yepe Moisés porocuaita, que ambuae Tũpa ñehe mombehusar rembicuachiagüer ocañi tẽi vaherã; ñepei-pei porocuaita imombehuprɨ imboavɨyesaño itera. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Sese acoi ava ndovɨroyai vahe que ñepei mborocuaitamira viña, ombohe avei ava seroyaẽhɨ ãgua, ahe evocoiyase ɨvɨ cotɨ catu vahe aveira Tũpa mborerecuasave yuvɨrecoi. Acoi vɨroya vahe rumo Tũpa porocuaita yuvɨreco iyavei oporombohe vahe yuvɨreco sese, ahe evocoiyase Tũpa osecomboɨvate catura omborerecuasave curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iyavei amombehu pẽu: acoi pe reco ɨ̃vi tuprɨsa ndaheise avɨye catu vahe fariseo recocuer sui iyavei ndaheise avɨye catu vahe Moisés porocuaita rese oporombohe vahe recocuer sui avei, ahese ndapeiquei chietera Tũpa mborerecuasave” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Pe peicua acoi pe ramoi aracahendar upe aipo ehi vahe: ‘Peporoyucai rene. Acoi que ava oporoyuca vahe rumo, ahe serasosara mborerecuar porandusave mbahe sembiapocuer repɨrã’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Che rumo aipo ahe pẽu: acoi ava ambuae ava rese oñemoɨro vahe yuvɨreco, ahe avei serasosara aheve. Iyavei acoi ‘nde ẽgüe ere tẽi vahe eico’ ehi vahe ambuae ava upe, ahe serasosara porandu ãgua mborerecuar ɨvate catu vahe rovai. Acoi ava rumo oñehe marase seroɨ̃rosave ambuae ava upe, ahe iyacatu imondosa ité tata guasuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Sese Tũpa upe pe porerecosa reropovẽhesave tũparo pɨpe pemahenduhase ava pe amotarẽhɨmbar rese, ");
INSERT INTO gyrNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","peseya rane pe porerecosa aheve; peyevɨ rane pe amotarẽhɨmbar upe pẽu iñero ãgua rese. Acoi peñerose oyeupe, ahese voi peyevɨ, tapeicuavẽhe pe porerecosa Tũpa upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Iyavei peyeamotarẽhɨse, peñero voi oyeupe peyoepiase. Anise, avɨyeteramo coiye catu tẽise pe mombehu tẽira pe amotarẽhɨmbar mborerecuar upe pe reraso ãgua. Ichui avɨyeteramo ahe pe roquenda ucara. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Supi eté aipo ahe pẽu: Ndapesẽi chietera acoi peyemboepɨpase voi eté pesẽra ichui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Peicua niha Moisés porocuaita yɨpɨndar: ‘Peaguasai rene ambuae ava rembireco rese’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Che rumo aipo ahe pẽu: Acoi ava omahese cuña rese ipotasa pɨpe, ahe inungar oyapo vahe ité mbahe sese opɨha pɨpe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Iyavei inungar que pe resa pe acato cotɨndar oipota rai ucase mbahe pẽu pe mboangaipa ãgua tẽi, iya penose ité, pemombo amombrɨ peyesui. Aní pe mondo uca opacatu pe recocuer tata guasuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iyavei inungar que pe po pe acato cotɨndar pe mboangaipa ucase, iya peyasɨa ité imombo amombrɨ peyesui. Aní pe mondo uca opacatu pe recocuer tata guasuve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Iyavei aipo ehi Moisés aracahe: ‘Opoi potase que omenda vahe oyesui, iyacatu cuachiar imondosa poisa resendar mborerecuar rovai yuvɨreco chupe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Che rumo aipo ahe pẽu: ava opoise güembireco sui, cuña ndoyavɨise mbahe, ahese ombopɨhañemoñeta tiẽtera güembireco mboaguasa uca ãgua. Iyavei cuimbahe omendase cuña omenda vahecuer rese, oyemboaguasa tẽi avei sese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Iyavei peicua acoi aipo ehi vahe pe ramoi upe aracahe: ‘Pemboavɨye itera pemoingatu tuprɨse Tũpa rer pɨpe mbahe pemombehu vahe yepi’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Che rumo, ‘Ndapeñehei chira que mbahe rer pɨpe, ɨva rer pɨpe tẽi avei’ ahe pẽu. Esepia, ahe niha Tũpa renda; ");
INSERT INTO gyrNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ɨvɨ rer pɨpe tẽi avei ndapeñehei chira. Esepia, ahe Tũpa pɨrunga; Jerusalén rer pɨpe avei ndapeñehei chira. Esepia, ahe niha mborerecuar ɨvate catu vahe recua. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pe ãca rer pɨpe avei ndapeñehei chira. Esepia, ndapeicatui chira que ñepei pe ha momorochi ãgua, imou ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sese niha peñehese, ñepei reseve, ‘Avɨye’ peyera; anise, ‘Aní’ peye voira. Esepia, aipo ndehi vahe mbahe tẽi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Peicua acoi Moisés porocuaita aracahendar aipo ehi vahe: ‘Que ava vɨnose vahe ambuae ava resa ichui, ahe sesa avei senosesara. Iyavei vɨnose vahe sãi ichui, sãi avei senosesara’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Che rumo aipo ahe pẽu: Aní chira pemboyevɨ pẽu mbahe tẽi aposar upe. Acoi que pe amotarẽhɨsar pe rovapetese yuvɨreco, ambuae cotɨ pe rova avei pemoporẽhɨñora chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Porandusave pe rerasose pe camisa rerocua ãgua yuvɨreco pe sui, pe saco avei pemondoñora chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","‘Ñepei legua rupi evosɨi co mbahe rese cheu’ ehise que ava pẽu, pe rumo perasoñora ñuvɨrío legua rupi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Iyavei oporanduse que pe mbahe rese yuvɨreco pẽu, pemondoño avei chupe. Aní chira perecatẽhɨ sese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Iyavei pesendu ñehesa yɨpɨndar: ‘Pesepia potai rene pe amotarẽhɨmbar, pe mborɨpar güeraño pesaɨsu’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Che rumo aipo ahe pẽu: Pesaɨsu catu pe amotarẽhɨmbar iyavei peyeroquɨ pe momara potasar rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Evocoi nungar apo pɨpe pe Ru Tũpa ɨva pendar rahɨr ité peicora. Ahe niha osesape uca arɨ ava naporai vahe upe, ava avɨye vahe upe avei. Ombou avei amar seco catuprɨ vahe upe, ava ndaseco põrai vahe upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pe raɨsupar güeraño pesaɨsu catu tẽise, ndapeipɨsɨi chietera porerecosa evocoi nungar sui. Esepia niha, ava guarepochi rerocuasar ndipɨhai vahe guaɨsupar tẽi osaɨsu yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ndahei yande mborɨpar upe güeraño yayapora ‘avɨrave’. Esepia, ava ndoicuai vahe avei Tũpa oyapo ‘avɨrave’ omborɨpar upe yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sese pe recocuer perecora pe Ru Tũpa ɨva pendar seco catuprɨ vahe nungar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tũpa upe mbahe peyapo potase, ‘Tache repia ava yuvɨreco’ ndapeyei chira. Esepia, ẽgüe peyese, ndapeipɨsɨi chietera pe Ru Tũpa ɨva pendar porerecosa. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Evocoiyase iparaɨsu vahe rese peporerecose, ‘Tamombehupa ava upe vichico’ ndapeyei chira inungar ava Tũpa reroyasar angahu tẽi yuvɨreco yepi. Tũparove iyavei ocar rupi mimbɨ omoñehe yuvɨreco ‘Co ava avɨye ité yuvɨrecoi, tehi angahu yuvɨreco yandeu’ oya tẽi. Supi eté aipo ahe pẽu: Ẽgüe ehi vahe rumo opa voi oipɨsɨ porerecosa co ɨvɨ pɨpe tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pe rumo peporerecose iparaɨsu vahe rese, aní chira pemombehu ambuae ava upe yepera que pe mborɨpar ité viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Peporereco catu ava pe repiaẽhɨsa pɨpe; pe Ru Tũpa niha mbahe ndoyecuai vahe osepia. Ahe omboura porerecosa pẽu opacatu ava rembiepiave curi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Acoi peyerurese, peicoi rene acoi ava ‘tosepia che yeruresa yuvɨreco’ ehi vahe nungar. Esepia, ahe opũha-pũha catu tũparo pɨpe oyeroquɨ yuvɨreco cupiha yacatu avei ‘tayande repia angahu ava’ ohesa pɨpe tẽi. Supi eté che aipo ahe pẽu: Ẽgüe ehi vahe opa voi eté co ɨvɨ pɨpeve tẽi oipɨsɨ porerecosa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Iyacatu rumo pe, peyeroquɨ potase, peiquera pe rẽta pɨpe peyeoquendara pe ae pe yeroquɨ ãgua pe Ru Tũpa upe. Evocoiyase pe Ru Tũpa oicua vahe mbahe pe rembiapo, iporerecora pe rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Iyavei peyeroquɨse, ndapemboyevɨ-yevɨi chira pe ñehe pe poranduse mbahe rese Tũpa upe inungar ava Tũpa ndoicuai vahe. Ahe omboyevɨ-yevɨ oyeruresa ‘Tũpa revo co rupi yande mboyeroya voira’ ohesave yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Aní chira inungar tẽi peico. Esepia, pe Ru Tũpa oicua pe porandu renondeve mbahe ipane vahe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Sese aipo peyera peyeroquɨ: ‘Ore Ru Tũpa, ɨvave ereico vahe, imboeteiprɨ nde rer tasecoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tou nde mborerecuasa oreu. Tayaposa nde remimbotar co ɨvɨ pɨpe, inungar ɨvave yaposa. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Embou ore rembihu arɨ yacatundar oreu co arɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iyavei ndeñero ore angaipa rese oreu inungar ore oreñero ore amotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ore mboangaipa ucai rene eve; eipeha mbahe naporai vahe ore sui’ peyera. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Esepia, pe amotarẽhɨmbar upe peñerose, pe Ru ɨva pendar avei iñerora pẽu; ");
INSERT INTO gyrNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ndapeñeroise rumo, ahe avei niñeroi chietera pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Acoi peyecuacuse, ndapemboyecuai chira pe vɨharẽhɨsa, inungar acoi Tũpa reroyasar angahu tẽi yuvɨreco yepi. Esepia, ahe opa oyeerecomeguapa tuprɨ yuvɨreco, ‘Co oyecuacu vahe, tehi ava yande repiasar yuvɨreco yandeu’ ohesa pɨpe tẽi. Supi eté aipo ahe pẽu: Ẽgüe ehi vahe opa voi oipɨsɨ porerecosa ava güepia pɨpe tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pe rumo peyecuacuse, peñeaca mondoro tuprɨra, peyovai tuprɨ aveira. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Evocoiyase, ‘Co oyecuacu vahe’ ndehi chira ava yuvɨreco pẽu. Pe Ru Tũpa, ndayasepiai vahe, güeraño oicuara pe yecuacusa. Ahe evocoiyase iporerecora pe rese curi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ndapemonuha atɨi chietera mbahe pe rembiereco co ɨvɨ pɨpe. Esepia, ahe mbahe pe rembiereco mbahe rasoi omboaso atɨ-atɨ imocañɨpa, iyavei sãve-sãve tẽi opochi atɨ-atɨ oapocatusave, imonda vahe avei evocoiyase imondaño sese pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iya peseca catu tecocuer avɨye vahe ɨvave nara. Aheve niha ndipoi chira co ɨvɨ pɨpendar nungar pe reco mocañɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Esepia, pe mbahe pe rembiereco setá catu vahesa rupi-rupi pe pɨhañemoñeta yepi, yepera que co ɨvɨ pɨpe, anise que ɨvave avei” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Iyavei yande resa inungar tataendɨ yande retecuer upe. Evocoiyase yande resa avɨyese, opacatu yande retecuer upe osesape; ");
INSERT INTO gyrNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","acoi imarase rumo, opacatu yande retecuer pɨ̃tumimbisave tẽi secoi. Tesapesa oime vahe yande rese, ahe ogüese rumo yande sui, mbahe tẽi eté, pɨ̃tumimbi nungar opacatu yande recocuer upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iyavei ndipoi chietera que ava ñuvɨrío güerecuar omboyeroya vahe. Esepia, ñepei oyamotarẽhɨra imboyeroya potaẽhɨsa pɨpe, ambuae evocoiyase osaɨsu catura imboyeroyasa pɨpe. Ẽgüe peye avei, ndapeicatui Tũpa mboyeroya guarepochi pota raisa pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Iyavei ndapeyemomahenduha guasu ai chira mbahe pe remihura rese pe recove ãgua, pe ɨhu ãgua rese, pe turucuarã rese tẽi avei no. Esepia, yande recovesa avɨye catu vahe tembihu sui, yande retecuer avei avɨye catu turucuar sui no. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Pesepia vɨ̃rai eta oveve vahe: nomahetɨi vahe, nomonuhai avei, ndoyapocatui avei mbahe yuvɨreco. Pe Ru Tũpa ɨva pendar ité niha omoime mbahe itohu. ¡Pe rumo ɨvate catu vahe ité peico vɨ̃rai sui! ");
INSERT INTO gyrNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ndipoi que ñepei pe pãhu pendar oicatu vahe opɨhañemoñetasa pɨpe tẽi güecocuer mopucu iri ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ndahei chira pe turucuarã rese tẽi peyemomahenduha guasu ai. Pemahecua ru mbahe potrɨ caha pɨpendar rese: ndoporavɨquɨi eté iyavei ndoipɨai oturucuarã. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Iyavei yepe mborerecuar guasu Salomón vɨreco setá ombahe iporañete vahe aracahe viña, iturucuar catuprɨgüer rumo ndahoyoyai mbahe potrɨ catuprɨgüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tũpa niha omboporañete raimi tẽi mbahe potrɨ caha pɨpendar, movɨro arɨ tẽi yasepia, ichui sapɨsapaño horno pɨpe. ¡Ahe rumo omondo catura turucuar pẽu, pe ava nimbahe reroya tuprɨi vahe! ");
INSERT INTO gyrNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Sese, ‘¿Mbahe pĩha yahura, yaɨhura?’ Iyavei, ¿mbahe pĩha yamondera?’ ndapeyei chira pe yemomahenduha guasu aisa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ava Tũpa reroyasarẽhɨ aipo nungar reseño tẽi ipɨhañemoñeta yuvɨreco yepi. Pe Ru Tũpa ɨva pendar rumo oicua ité pẽu mbahe ipane vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pemahenduha rane Tũpa rese pe recocuer tuprɨ pɨpe ipovrɨve mbahe pe yapo ãgua semimbotar rupi, ahese omboura opacatu co mbahe ipane vahe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Peyemomahenduha guasa ai eme mbahe peyapo vaherã rese. Iyacatu rumo ahe arɨ oyepotase voi, peyemomahenduhara sese. Esepia, arɨ yacatu rupi oime mbahe pemoingatu vaherã yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ndiyai, ‘Oyavɨ ité mbahe’ peye voiño tẽi ambuae ava upe; evocoiyase Tũpa, ‘Oyavɨ mbahe’ ndehi chira pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Esepia, inungar pe ambuae ava upe peico, ẽgüe ehi aveira niha Tũpa pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¡Mahera ambuae ava rembiavɨmi rese tẽi pemahe! ¡Iya rumo peyese rane mbahe tuvichá catu vahe pesepia! ");
INSERT INTO gyrNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndiyai pẽu, ‘Che toropɨ̃tɨvɨi mbahe nde rembiavɨ rese’ peye vaherã chupe. Esepia, ¡pe peyavɨ guasu catu mbahe ichui! ");
INSERT INTO gyrNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Pe Tũpa reroyasar angahu tẽi peico vahe! Penose uca rane mbahe pe rembiavɨ tuvichá catu vahe peyesui, ahese ramo ambuae ava rembiavɨ tahɨmi vahe moingatu peicatura. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Pemondo eme mbahe maranehɨ ava cave nungar tẽi upe, iyavei ndapemondoi chira mbahe porañete vahe ava cuchi nungar tẽi upe. Avɨyeteramo oyemboyerera mbahe-mbahe tẽi apo yuvɨreco pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Peporandu mbahe rese Tũpa upe, ahese omboura pẽu; peseca ahe mbahe, ahese peyosura; inungar pemota oquenda, ẽgüe peyera pe yeroquɨsa pɨpe Tũpa upe, ahese imbousara pe porandusa pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Esepia, acoi oporandu vahe mbahe rese, ahe mbahe oipɨsɨra; acoi mbahe oseca vahe, oyosura, iyavei acoi oyeroquɨsa pɨpe omota vahe oquenda Tũpa upe, chupe imboisara. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ndipoi eté revo que ñepei pe pãhu pendar omondo vaherã ita tẽi guahɨr upe pan rese oyeupe poranduse. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Que pira rese oyeupe poranduse revo, ndomondoi chiaveira mboi tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yepe ava ndaseco põrai vahe peico viña, pe rahɨr upe rumo pemondoño ité mbahe avɨye vahe. ¡Tahetru pe Ru ɨva pendar oipota catu mbahe avɨye vahe mondo ãgua acoi ava mbahe rese oporandu vahe upe! ");
INSERT INTO gyrNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Acoi mbahe peipota vahe ambuae ava oyapo vaherã pẽu, ahe tuprɨ avei peyapora chupe. Ahe niha Moisés porocuaita iyavei Tũpa ñehe mombehusareta porombohesa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Peique oquendɨpɨ icãhimi vahe rupi. Esepia, oquendɨpɨ guasu iyavei perɨ guasu cañɨ tẽisave oso vahe. Ahe supi setá catu ava yuvɨraso; ");
INSERT INTO gyrNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","teco apɨrẽhɨsave oso vahe rumo oquendɨpɨ, perɨ reseve icãhimi. Supi guata ãgua yavai eté; movɨromi tẽi ava oseca yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Coiye yugüerura ava Tũpa Ñehengagüer mombehusar angahu tẽi pe pãhuve. Ahe ndoyavɨi chira ovesa ndaseco marai vahe yuvɨreco. Ipɨha pɨpe rumo secocuer avɨye mahembiar oñaro ai vahe. Sese peicua catu evocoi nungar sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ava recocuer icuasa sembiapo rese. Esepia, ndahipohosai yu sui uva, ndipohosai avei higuera ha ɨvɨra sãchi atɨ vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Evocoiyase ɨvɨra avɨye vahe, iha avɨye avei; ɨvɨra naporai vahe, iha naporai avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Esepia, ɨvɨra avɨye vahe ndovɨrecoi oha naporai vahe, iyavei ɨvɨra naporai vahe ndovɨrecoi oha avɨye vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Sese opacatu ɨvɨra iha naporai vahe yasɨasa yepi. Ichui imondosapa tatave. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Na peyera ava recocuer cua sembiapo rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ndahei opacatu ava ‘che Yar, che Yar’ ehi vahe yuvɨreco cheu yuvɨroiquera che Ru Tũpa mborerecuasave. Che Ru ɨva pendar remimbotar aposar año tuprɨ rumo yuvɨroiquera aheve. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Arɨ cañɨ pɨpe setá tẽi ava aipo ehira yuvɨreco cheu: ‘Ore Yar, nde ñehe mombehusar niha ore oroico cuese, setá avei oromombo caruguar ava sui nde rer pɨpe, setá poromondɨisa oroyapo’ ehi tẽira yuvɨreco cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Che rumo, ‘¡Aní, ndopocuai! ¡Pe mbahe tẽi peico vahe, peyepepɨ che sui!’ aheñora aipo nungar upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iyavei que ava osendu vahe che ñehengagüer, omboavɨye vahe avei, ahe inungar ava ipɨhañemoñeta tuprɨ vahe omopuha ita harɨve güẽtarã. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yepe ahe oɨ upe oyepota tẽi ɨvɨtu ai, amarusu reseve, ichui oyeapo tẽi avei ɨai chupe, oɨ rumo ndovɨapi eté. Esepia, ita harɨve ité yaposa. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Acoi ava che ñehengagüer rese ndoyapɨsacai vahe rumo, ahe inungar ava opɨhañemoñeta tuprɨẽhɨsa pɨpe omopuha vahe ɨvɨ cuhi harɨve tẽi güẽtarã. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ipare rumo oyepotase ɨvɨtu ai amarusu reseve chupe, ndaracaheimi ahe oɨ omondurupa” ehi Jesús ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iñehe renduse ava rehɨi, “¿Mara ehi rutei?” ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Esepia, ndahei Moisés porocuaita rese oporombohe vahe nungar; ahe rumo oporombohe güeco pĩratasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ɨvɨtrɨ sui ogüeyɨse Jesús, ava rehɨi avei yuvɨrecoi supi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ahese ava lepra vɨreco vahe ou, oñenopɨha sovai aipo ehi chupe: —Che Yar, ereipotase, che mbogüerami eve co mbaherasɨ sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aipo ihese, Jesús opoco sese aipo ehi: —Taa, aipota. ¡Ecuera cũritei! —ehi. Aipo ihe ramoseve, ocuera voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—Nde cuerasa eremombehu eme ambuae ava upe —ehi—. Nde poyavaño eso, eyemboyecua judío pahi upe. Ipare eicuavẽhe nde porerecosa nde cuera agüer resendar Moisés porocuaita rupi. Ipɨpe sui toicua ava nde cuerasa yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ipare Jesús oguataño, ẽgüe ehi tecua Capernaum ve oyepota oso. Aheve oime sundao rerecuar Roma ɨguar. Ahe ou chupe ");
INSERT INTO gyrNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aipo ehi: —Che Yar, che remimboacua imbaheasɨ guasu vupave ou. Ndoguata catui, oiporara tẽi ombaherasɨsa ou —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—Avɨye, cũritei evocoiyase asora imbogüera —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Aní, che Yar, ndiyai eté che rẽta pɨpe nde reique ãgua; iyacatu niha cohapeve ereñeheño tẽi icuera ãgua. Evocoiyase nde ñehe pɨpe tẽi che remimboacua ocuerara. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Esepia, che niha serecua vahe avei no, areco avei sundao che voya. Ahe chupe, “Eso peve” ahese, cũritei oso; ambuae upe, “Erio ave” ahese, ou voi avei cheu; che remimboacua upe, “Ahe mbahe eyapo” ahese, che reroya avei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","“¡Too!” ehi Jesús aipo oyeupe hese. Ichui aipo ehi oyeupindar ava rehɨi upe: —Yepe ahe ndahei vahe judío viña, opacatu Israel recua pɨpendar rumo ndasepiai eté ava imbahe reroya vahe yuvɨreco yepi co ava nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Che aipo ahe pẽu: Setá ava yugüerura añihivei cotɨ sui, caharu cotɨ sui avei no, inungar co sundao rerecuar. Iyavei opacatu ava ɨvɨ rupindar oguapɨra yuvɨreco Tũpa mborerecuasave Abraham, Isaac iyavei Jacob pɨri coiye. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Judío eta rumo, oyeupe ñehesa reroyaẽhɨ pɨpe setá pɨ̃tumimbisave ocañɨ tẽira yuvɨreco. Aheve oyaseho tẽira yuvɨreco iyavei oñeaimbotere-tere tẽira mbaherasɨcuer rereco yuvɨreco —ehi oñehe. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Evocoiyase sundao rerecuar upe aipo ehi: —Eso, nde mbahe reroya pɨpe yaposa nde remimbotar ndeu —ehi. Ahe pɨpeve semimboacua ocuera tuprɨ ité. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ipare Jesús oso Pedro rẽtave. Aheve osepia Pedro rembireco sɨ sohɨ́ iteangase vupave ou. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Opocose ipo rese, ahe ramoseve sohɨ opɨtuhu ichui. Ocuerare, oñarapuha ava rese ohañeco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ipare pɨ̃tu ramose setá caruguar vɨreco vahe ogüeru yuvɨreco chupe. Jesús rumo ñepei reseve oñehe pɨpe tẽi omombopa caruguar ava rehɨi sui, iyavei opacatu imbaheasɨ vahe ombogüera avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ẽgüe ehi omboavɨye Tũpa ñehe mombehusar Isaías rembicuachiagüer aipo ehi vahe aracahe: “Ahe ae vɨrocua opacatu yande mbaherasɨsa yande sui iyavei oiporara opacatu mbahe tasɨ vahe yande rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús osepiase ava rehɨi oyere guasu vahe oyese, oyocuai güemimbohe eta aipo ehi: “Peyemoingatu yandeu ɨpa rovai yande so ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ahese Moisés porocuaita rese oporombohe vahe aipo ehi chupe: —Porombohesar, che mo aso pota nde rupi opacatu nde guatasa rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús rumo aipo ehi imboyevɨ chupe: —Yavaira rumo ndeu. Esepia, vɨ̃rai vɨreco guaitɨ, iyavei aguara vɨreco oquesa; che rumo, Ava Rɨquehɨr, ndarecoi que che rẽta ité che pɨtuhu ãgua yepi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ipare ñepei ivoya aipo ehi chupe: —Che Yar, che ru manore voi che nde rupiño ité aicora —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—Aní, cũritei voi eyu che rupi —ehi—. Ẽgüe tehiño ava secocuer omano vahe nungar, ahe ae toñeñetɨ yuvɨreco —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ipare Jesús yuvɨroha güemimbohe reseve yuvɨraso carite pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ɨpa pɨpe yuvɨraso pucu ramoseve Jesús oque ou. Ahese avɨyeteramo tẽi ɨvɨtu ai opũha ɨpa pɨpe; ɨ ohɨtu vahe ndiguayɨi eté, seni-seni carite oyopɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Evocoiyase semimbohe yuvɨraso voi imomahe: —¡Ore Yar, yande rerasora mo co carite ɨpɨve! ¡Yande pɨ̃sɨro eve! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Evocoiyase aipo ehi: —¡Mahera pesɨquɨye! ¡Ndapeyeroyai eté che rese! —ehi güemimbohe upe. Ahese oñarapuha aipo ehi ɨtu guasu upe, ɨvɨtu ai upe avei no: “Pepɨtuhupa” ehi. Aheseve voi opa tuprɨ opɨtuhu yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","—¿Mara ehi rutei pĩha co? —ehi tẽi semimbohe yuvɨreco chupe—. ¿Mara ehi vahe pĩha co ava secoi? Esepia niha, ɨvɨtu, para guasu avei omboyeroya yuvɨreco no —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús oguataño güemimbohe eta reseve oyepota ɨpa rovai Gadara ɨvɨ rese yuvɨraso. Aheve ñuvɨrío ava caruguar vɨreco vahe yugüeru sovaĩchi. Ahe ava tehõgüer ruvɨpa rupi tẽi yuvɨrecoi vahe, iyavei ndiporomboetei vahe yuvɨreco. Ichui osɨquɨyepave ava ndoguata potai ahe perɨ rupi yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesús repia ramoseve rumo, oñehe pĩrata yuvɨreco chupe aipo ehi: —¡Jesús, Tũpa Rahɨr, eyepepɨ ore sui! Esepia niha, ndoyepota vɨtei arɨ nde ore mombaraɨsu ãgua oreu —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Namombrɨimi cuchi rehɨi yuvɨrecoi ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Caruguar evocoiyase aipo ehi yuvɨreco chupe: —Ore mombopaño tẽi eve evocoi cuchi rese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Avɨye, peso —ehi caruguareta upe. Aipo hese, caruguar opa yuvɨnose ava sui, yuvɨroique cuchi rehɨi avɨterve. Ipare rumo cuchi ndayaracua iri yuvɨreco; iɨvɨ socuer rupi yuvɨnoña yuvɨraso, opa ɨpa pɨpe ocañɨ tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yuvɨnoña evocoiyase cuchi rãrosar tecuave yuvɨraso opacatu mbahe güembiepia mombehu ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ichui opacatu ava tecua pendar yuvɨnose atɨ Jesús upe, “¡Eso cohave sui!” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ipare Jesús oha carite pɨpe osasa iri ɨpa rovai oso güecua Capernaum ve. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aheve, ava ndoguatai vahe omboyovai seraso imbaheasɨ vahe rɨru pɨpe yuvɨreco chupe. Ahe oicuase co ava yuvɨrecoi vahe oyese yeroya, aipo ehi imbaheasɨ vahe upe: —Che rahɨr, eyemopoase, che ñero nde angaipa rese ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","“¡Co mbɨa oyemboɨvate ai tẽi vahe, Tũpa ñehe nungar pɨpe tẽi oñehe!” ehi Moisés porocuaita rese oporombohe vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús rumo oicua ipɨhañemoñetasa, sese aipo ehi chupe: —¡Mahera pepɨhañemoñeta rai pe yapɨsacasa rereco! ");
INSERT INTO gyrNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Uma rupi vo ñehesa ndayavaimi catu: ‘Nde angaipa rese che ñero ndeu’ hesa pĩha, anise, ‘Epũha, eguata’ hesa tie? ");
INSERT INTO gyrNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tapeicua ru che, Ava Rɨquehɨr, areco mborerecuasa co ɨvɨ pɨpe ava angaipa upe che ñero ãgua —ehi. Evocoiyase aipo ehi imbaheasɨ vahe upe: —Epũha, esupi nde rupa seraso nde rẽtave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ahese opũha voi, oso güẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","“¡Too! ¿Mara ehi rutei vo?” ehi ava rehɨi yuvɨreco imboeteisave. “Esepia, ahe niha ombou opĩratasa ava upe” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ichui osose Jesús, che repia, che Roma pendar mborerecuar guasu upe guarepochi rerocuasa mesave che rẽise. Ipare aipo ehi cheu: —Erio che rupi —ehi. Evocoiyase apũha, aso voi supi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ahe arɨ pɨpeve Jesús güemimbohe reseve yuvɨroique che rẽtave. Ambocaru setá ambuae ava guarepochi Roma pendar mborerecuar guasu upe monuhasar reseve, ava angaipa viyar yuvɨrecoi vahe reseve avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Co nungar repiase, fariseo oporandu semimbohe upe yuvɨreco: —¿Mahera ru pe mbohesar ocaru evocoi nungar ava angaipa viyar pãhuve tẽi? —ehi seroɨ̃rosa pɨpe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús rumo, osenduse oyesendar ñehesa, aipo ehi: —Ava nimarai vahe ndosecai eté oporopõsano vahe; imbaheasɨ vaheño rumo oseca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Peyapɨsaca icuachiaprɨ aracahendar aipo ehi vahe rese: ‘Poroparaɨsuerecosa aipota; ndaipotai mbahe cheu serocuavẽheprɨ tẽi’ ehi. Esepia, ndayui ava seco catuprɨ vahe reca, ẽgüe ehi rumo ayu ava angaipa viyar reca —ehi Jesús ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ipare Juan Oporoãpiramo vahe rupindar yugüeru oporandu Jesús upe: —Ore iyavei fariseo eta oroyecuacu yepi, ¿mahera ru evocoiyase nde remimbohe eta ndoyecuacui yuvɨreco yepi? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ahe rumo omboyevɨ ahe ava upe: —¡Ndiyai eté ichohoprɨ mendasave ndoyembovɨhai yuvɨreco imer oicovese ipãhuve! Oimera rumo arɨ imer reraso ãgua ichui curi. Ahese ramo oyecuacura yuvɨreco cute —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ndipoi chietera revo que ava oturucuar cuacua oyapete vahe turucuar ipɨasu vahe pɨpe. Esepia niha, yapetesa ipɨasu vahe oichohoño turucuar cuacua imondoro. Ichorosa evocoiyase tuvicha catu-catuño ité. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iyavei ndiyai ava uva rɨcuer pɨasu oyapocatu sɨru mbahe pirer cuacua vahe pɨpe. Ẽgüe ehise, mbahe pirer opura viña, ocañɨ tẽira, uva rɨcuer avei evocoiyase ocañɨ tẽi aveira viña no. Acoi uva rɨcuer ipɨasu vahe mbahe pirer ipɨasu vahe pɨpe yapocatuprɨ rumo oyoya ndoyemomarai yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús oporombohe vɨteseve, ou mborerecuar oñenopɨha sovai aipo ehi chupe: —Che rayrɨ mo cũritei omano pota ité. Yaso, nde eremondose rumo nde po sese oicovera —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","“Avɨye” ehi. Evocoiyase opũha yuvɨraso güemimbohe reseve supi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ahe pɨpeve cuña doce aravɨter rupi suvɨ ndopai vahe opoco saquɨcuei cotɨ iturucuar popɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Esepia, ahe aipo ehi opɨha pɨpe: “Yepe que iturucuar popɨ resemi tẽi apocora, acuerara rumo” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús evocoiyase oyemboyere cuña rese aipo ehi chupe: —Che rayrɨ, eyemopoase, erecuera cũritei nde yeroyasa pɨpe —ehi. Aipo ihe ramoseve, cuña ocuera voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Oyepotase Jesús mborerecuar rẽtave, osepia omimbɨ vahe iyemoingatupase omano vahe tɨ̃ ãgua, ava yaseho atɨse avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ahese aipo ehi ava oyaseho vahe upe: —Pesẽpa cohave sui. Co cuñatai nomanoi; oque tẽi ou —ehi. Ahe ava rumo opucaete atɨño seroyaẽhɨsave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ichui opa ava omose, ahese oique oɨ pɨpe oipopɨsɨ cuñatai. Evocoiyase ahe oñarapuha voi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Co sembiapo evocoiyase oyandupa voi opacatu tecua rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Acoi osẽse evocoi oɨ sui Jesús, ahese ñuvɨrío ndasesapɨsoi vahe osaquɨcue moña, osapucai yuvɨreco chupe aipo ehi: —¡Jesús, David suindar, ore paraɨsuerecomi tẽi eve! —ehi pucu-pucu yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Oɨ pɨpe seiquese, oyemboya ndasesapɨsoi vahe yuvɨreco sese. Ahese Jesús oporandu chupe: —¿Che reroya ité vo pe mbogüera ãgua rese peye? —ehi. —Nde reroyasa ité, ore Yar —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aipo oyeupe hese, opoco sesa rese, aipo ehi chupe: —Tayapo pe che reroyasa pɨpe mbahe pẽu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aipo ihe ramoseve osareco tuprɨ voi yuvɨreco. Ipare, —Peicua catu. Peicua ucai rene ambuae ava upe —ehi chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ahe rumo ichui oyepepɨ pare, yuvɨraso opacatu tecua rupi, “Jesús ore mbogüera” ehi-ehiño ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ichɨrɨ ramoseve rumo, ambuae ava vɨroyepota ava niñehengatui vahe caruguar rerecosar Jesús upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ichui omosese caruguar, iñehengatu cute. Sepiase opacatu ava, —¡Too! —ehi—. ¡Ndasepiasai vahe ité co nungar mbahe yande recua pɨpe yepi! —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseo eta rumo aipo ehiño yuvɨreco: —Caruguar rerecuar pĩratasa pɨpe co mbɨa omose caruguar ava sui —ehi tuprɨ tẽi yuvɨreco chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ichui opacatu tecua rupi Jesús oguata oporombohe tũparo yacatu. Omombehu tecovesa avɨye vahe Vu mborerecuasa resendar iyavei oporombogüera opacatu-catu tẽi mbaherasɨsa sui avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Osepiase ava rehɨi, oiparaɨsuereco yuvɨreco. Esepia, ahe oñemosaño tẽi mbahe rasɨcuer pãhuve inungar ovesa ndovɨrecoi vahe guãrosar yuvɨreco ");
INSERT INTO gyrNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Evocoiyase aipo ehi güemimbohe upe: —Supi eté mbahe mitɨ imonuhapɨrã setá iteanga; sese oporavɨquɨ vahe rumo movɨromi tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Sese peporandu mbahe mitɨ Yar upe, ahe tomondo ava imonuha ãgua —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Evocoiyase, “Perio” ehi Jesús doce güemimbohe upe. Chupe omondo güeco pĩratasa caruguar ava sui imboyepepɨ ãgua iyavei iporombogüera ãgua opacatu-catu tẽi mbaherasɨsa sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ahe ava doce tuprɨ apóstol yuvɨrecoi vahe: yɨpɨndar Simón Pedro, ahe tɨvrɨ Andrés; ambuae Santiago, Zebedeo rahɨr, ahe tɨvrɨ Juan; ");
INSERT INTO gyrNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás; iyavei che, Mateo, guarepochi monuhasarer; ambuae Santiago, Alfeo rahɨr; ambuae Tadeo; ");
INSERT INTO gyrNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","iyavei Simón, güecua rese secatẽhɨ vahe pãhu pendarer; ipa vahe Judas Iscariote, ahe Jesús omondo vahe yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Ipare oyocuai güemimbohe imondo aipo ehi chupe: “Pesora yɨpɨndar judío recua rupi. Esepia, inungar ovesa ocañɨ vahe, ẽgüe ehi tẽi secocuer yuvɨreco. Evocoiyase pesoi rene ndahei vahe judío recua rupi iyavei ndapeiquei chira tecua Samaria ve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","“Judío recua rupi pesoseve, ‘Cõimi Tũpa mborerecuasa secoi yandeu’ peyera imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Iyavei pembogüera imbaheasɨ vahe, pembogüerayevɨ avei omano vahe, pembogüera lepra rerecosar iyavei caruguar pemboyepepɨ serecosar sui. Esepia niha, peipɨsɨ pĩratasa ndasepɨi vahe. Sese peyapoño evocoi mbahe guarepochi pɨsɨẽhɨsa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Ava oporavɨquɨ pɨpe sui ocaru yepi. Sese ndaperasoi chira guarepochi peyese. Ndaperasoi chiaveira pe mbahe rɨru, iyavei ambuae pe turucuar, pe pɨtaqui; peyesendar güeraño tuprɨ perasora. Pe pococa avei ndaperasoi chira” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Iyavei que tecuave peyepotase, peseca rane ava imboyeroyaprɨ. Ahe sẽtave pepɨtami ranera. Pemboavɨyese pe cuaita, ahese ramo pesora ichui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","“Evocoiyase peique ramoseve oɨ pɨpe, peyapora, ‘Avɨrave, Tũpa tape rovasa’ peyera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Acoi avɨyese oɨ pɨpendar ava pẽu, ahe oipɨsɨra Tũpa porovasasa; acoi ndahavɨyeise rumo ava, ndoipɨsɨi chira Tũpa porovasasa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Acoi ndosendu potaise pe ñehe, ndape pɨsɨ potaise avei yuvɨreco, ahese pesẽño ahe oɨ pɨpe sui, anise tecua sui. Peipɨpetera pe pɨ ɨvɨ rãtachigüer sui, pesẽ pecua ichui ‘toipɨsɨ Tũpa ñemoɨrosa yuvɨreco’ pe yapave. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Evocoiyase supi eté arɨ cañɨ oyepotase co tecua upe, ɨvate catura Tũpa ñemoɨrosa ava Sodoma, Gomorra ɨguar upendar sui curi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Pesendu tuprɨ che ñehe! Che opomondo ovesa nungar ava mbahe mɨmba oñaro ai vahe nungar pãhuve. Sese peresaeté tuprɨra peyese mboi nungar, iyavei inungar apɨcasu seco tuprɨ vahe peicora. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Iyavei peicua catu peamotarẽhɨmbar sui. Esepia, mborerecuar rovai pe rerasora iyavei pe nupara otũparo pɨpe yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ichui pe reraso aveira mborerecuareta ɨvate catu vahe rovai yuvɨreco che recocuer sui tẽi, ẽgüe peyera peñehe che recocuer rese chupe iyavei ava ndahei vahe judío upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Acoi pe rerasose mborerecuar upe yuvɨreco, ‘¿Mbahe pĩha amombehura chupe?’ ndapeyei chira; acoi peñehe potase rumo, Tũpa omondora pe ñehe ãgua pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Esepia, ndahei chira peyesui tẽi peñehe, pe Ru Tũpa Espíritu pemoñehe ucara. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ipare rumo ava vɨvrɨ omondora oamotarẽhɨsar upe ‘toyuca yuvɨreco’ oya. Ẽgüe ehi aveira ava guahɨr upe; tahɨr avei oyamotarẽhɨra oyesupa yuca uca ãgua yuvɨreco che recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Iyavei opacatu ava ndape ambotai chira che recocuer sui tẽi yuvɨreco. Acoi oyemovɨracua vaheño rumo arɨ ipa vahe rupi, ahe ipɨ̃sɨroprɨ yuvɨrecoira curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Iyavei acoi pe mañeco tẽise ñepei tecuave yuvɨreco, ahese peyepepɨñora ichui ambuae tecua pɨpendar upe che recocuer mombehu ãgua. Supi eté Ava Rɨquehɨr oura ndapemboavɨye vɨteiseve pe guatasa judío recua rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ñepei yepe niha ava oyembohe vahe ndahei eté ɨvate catu ombohesar sui; que ava rembiguai ndahei avei ɨvate catu vahe güerecuar sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Iyavei semimbohe, ‘Avɨye ité’ ehiñora ombohesar osecoupitɨse. Ẽgüe ehi aveira mbiguai güerecuar upe. Acoi oɨ yar upe: ‘Caruguar rerecuar Beelzebú’ ehise, aipo ehi aveira niha oɨ pɨpendar upe yuvɨreco no” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Sese ndapesɨquɨyei chira ava pe amotarẽhɨmbar sui. Esepia, yaposa vahe imombehupɨrẽhɨ cũritei, icuasaño itera curi; iyavei mbahe ñomiprɨ, icuasaño aveira no. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Acoi che amombehu vahe pɨ̃tumimbisave pẽu, pemombehu arɨ pɨpe coiye, iyavei acoi amombehu vahe pẽuñomi, perosapucai pe rẽta harɨve imombehu opacatu ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iyavei ndapesɨquɨyei chira acoi ava peyuca potasar sui. Esepia, ndoicatui niha ava hã mocañɨ ãgua yuvɨreco. Tũpa sui rumo pesɨquɨye catura. Esepia, ahe oicatu yande retecuer, yande hã reseve imocañɨ ãgua tata guasu pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Yamondo niha ñuvɨrío vɨ̃raimi repɨrã ñepeimi guarepochi yepi. Yande Ru Tũpa ndoipotaise rumo, ndovɨapi chietera que ñepei vɨ̃raimi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","“Sese pesɨquɨye eme. Esepia, pe niha ɨvate catu vahe ité peico opacatu vɨ̃rai sui. Supi eté Tũpa niha oicua opacatu ñepei-pei pe ha retacuer” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Acoi ava ‘che aicua Jesucristo’ ehi vahe opacatu ava rovaque, che avei evocoiyase: ‘Co ava che rupindar secoi’ ahera che Ru ɨva pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Acoi ava ‘che ndahei Cristo rese aico’ ehi vahe rumo cheu ava rovaque, che avei evocoiyase, ‘Ndahei co che rupindar secoi’ ahera che Ru ɨva pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ ‘Mbahe tuprɨ ai revo güeru co ɨvɨ pɨpe’ ndapeyei chira cheu. Ẽgüe ehi rumo che yusa omoime ucara yeamotarẽhɨsa. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Sese ava oñemu ae oyeamotarẽhɨ-rẽhɨra yuvɨreco; ava oyesupa oyamotarẽhɨra, iyavei cuña membrɨ osɨ oyamotarẽhɨra, cuña vovayar oyamotarẽhɨ aveira. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Iyavei acoi oyesupa tẽi osaɨsu catu vahe che sui, ahe ndiyai eté secoi che voyarã; inungar avei osaɨsu catu vahe guahɨr, anise guayrɨ che sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iyavei acoi noñemosai vahe mbahe rasɨcuer upe, inungar-ra curusu rese ovosɨi vahe ité viña che rupi oguata pɨpe, ahe chupe ndiyai eté che voya seco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Acoi ava oipɨ̃sɨro pota vahe güecocuer tẽi, ahe ocañɨ tẽira; acoi omocañɨ vahe rumo güecocuer che recocuer rese, ahe oñepɨsɨrora” ehi Jesús güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Acoi ava pe pɨsɨ tuprɨ vahe, ahe che pɨsɨ tuprɨ avei yuvɨreco, iyavei acoi che pɨsɨ vahe, ahe oipɨsɨ avei che mbousar. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Acoi ava oipɨsɨ tuprɨ vahe ambuae ava Tũpa ñehe mombehusar secosa rese, ahe oipɨsɨ aveira porerecosa inungar tuprɨ. Iyavei acoi ava oipɨsɨ tuprɨ vahe ava seco catuprɨsa rese, ahe oipɨsɨ aveira porerecosa inungar tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iyavei acoi omondo vahe que chĩhi ɨ sõhɨsa vahe que ñepei seco mbegüemi catu vahe toɨhu che reroyasar seco rese, ahe oipɨsɨ aveira Tũpa suindar porerecosa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Opase Jesús oyocuai doce güemimbohe, ahese yuvɨraso oporombohe Tũpa Ñehengagüer rese judío recua rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ahese Juan Oporoãpiramo vahe voquendasave chinise, oyandu mbahe Jesucristo rembiapo. Sese omondo vupindar Jesús upe mbahe rese ");
INSERT INTO gyrNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","imboporandu ãgua: “¿Nde ité vo Tũpa Rembiporavo aipo sãrombrɨ ereico? anise, ¿oime tie ambuae orosãro vaherã?” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ipare omboyevɨ chupe aipo ehi: “Peso, pemombehupa Juan upe mbahe pe rembiepia iyavei pesendu vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Ndasesapɨsoi vahe osareco tuprɨ cũritei yuvɨreco, ipãri-pãri vahe oguata tuprɨ, iyavei lepra rerecosar ocuerapa tuprɨ, ndayapɨsai vahe avei yapɨsapa, omano vahe opa ocuerayevɨ yuvɨreco iyavei ava iparaɨsu vahe upe imombehusa pɨ̃sɨrosa resendar ñehesa’ peyera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Ovɨharetera acoi ava oyeroyaño vahe che rese!” ehi Juan rupindar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan rupindar yuvɨraso pare, Jesús omboɨpɨ imombehu ava upe Juan recocuer: “¿Pesepiase Juan recocuer ava porẽhɨsave capihiata ɨvɨtu ombova-mbova vahe nungar pĩha? ");
INSERT INTO gyrNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Anise, ¿pesepia tie iturucuar porañete ai vahe iyemboeteise? ¡Aní! Ẽgüe ehi vahe rumo secoi mborerecuar guasu rẽtave yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Evocoiyase pesepiase, ¿‘Ava’ peye vo pe chupe? ¿Tũpa ñehe mombehusar ité pĩha? Taa, ahe ité. Evocoi niha ɨvate catu vahe Tũpa ñehe mombehusar sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ahe chupe ité Tũpa icuachiaprɨ aracahendar pɨpe aipo ehi: ‘Che amondora nde renondeve che ñehe mombehusar nde raperã moingatu ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Supi eté ndipoi que ñepei ava seco ɨvate catu vahe Juan Oporoãpiramo vahe sui. Yepe ahe ɨvate catu vahe viña, Tũpa mborerecuasave rumo ava seco mbegüemi catu vahe ɨvate catu ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juan yusa suive tuprɨ Tũpa povrɨ pendar oiporara mbahe tẽi yuvɨreco. Osãha-sãha ava opĩratasa pɨpe imocañɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Opacatu Tũpa ñehe mombehusar rembicuachía pɨpe, Moisés porocuaita icuachiaprɨ pɨpe avei imombehusa Juan yusa rupive co Tũpa mborerecuasa resendar. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yepe yavaira seroya ãgua pẽu viña, Juan rumo, Tũpa ñehe mombehusar Elías. Ahe imombehuprɨ ou vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Acoi ava osendu pota vahe che ñehe, toyapɨsacaño sese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Mbahe rese pĩha amboyoyara ava recocuer cũriteindar? Esepia, co ava inungar acoi chĩhivahe iguayɨ tẽi vahe ocar rupi. Ipare oñehe pucu-pucu omborɨpar upe yuvɨreco aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Oromoñehe tẽi mimbɨ pẽu, ndapepɨvoi eté rumo iyavei orosapucai tẽi sapucaisa vɨharẽhɨsa resendar pẽu, pe rumo ndapeyasehoi eté’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Esepia, ouse Juan Oporoãpiramo vahe, ahe ndohui tembihu sepɨrusu ai vahe iyavei ndoɨhui uva rɨcuer ipĩrata vahe, sese, ‘Co mbɨa caruguar vɨreco vahe oyese’ peye tuprɨ tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Coiye che ayu, Ava Rɨquehɨr, acaru, aɨhu tuprɨ avei. Ipare, ‘Co icaru guasu ai vahe secoi, iɨhu guasu ai vahe avei’ peye cheu; ‘Ava angaipa viyar mborɨpar tẽi iyavei guarepochi rerocuasar mborɨpar tẽi’ peye avei cheu. Acoi ava supi eté vɨreco vahe Tũpa mbahecuasa, ahe icuasara sembiapo rese yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ahese Jesús oñehe pĩrata movɨro tecua pendar upe. Esepia, aheve acoi oyapo atɨ catu mbahe poromondɨisa viña. Ahe pendar ava rumo ndosecuñaro potai eté güecocuerai Tũpa upe nara yuvɨreco. Evocoiyase aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Peparaɨsu, ava tecua Corazín pendar! ¡Pe avei peparaɨsu tecua Betsaida pendar! Esepia, acoi poromondɨisa pe pãhuve yapoprɨ, yaposara yɨpɨve tecua Tiro, Sidón ve viña, co tecua pendar aracaheve anga omondera turucuar vɨharẽhɨsa resendar, tanimbu avei omondora oãca rese oangaipa mboasɨsa pɨpe yuvɨreco viña no. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pe rumo peipɨsɨra ɨvate catu vahe Tũpa ñemoɨrosa ava Tiro, Sidón pendar sui arɨ cañɨ pɨpe coiye. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Pe avei no, tecua Capernaum pendar pemoha co ɨvave pe reco ãgua viña. ¡Pe rumo pe mombosara ɨvɨcuar ipɨcucu catu vahe pɨpe. Ehi revo tecua Sodoma ve rane, acoi poromondɨisa yapoprɨ vahe pe pãhuve yaposara viña, cũritei oime vɨtera ahe tecua viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sese, pe peipɨsɨra ɨvate catu Tũpa ñemoɨrosa ava Sodoma ɨguar sui arɨ cañɨ pɨpe coiye” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iyavei ahe arɨ pɨpe Jesús oyerure: “Che Ru, avɨye ndeu. Nde niha ɨva pendar, ɨvɨ pɨpendar Yar ereico. Esepia, nde ereñomi co ñehesa supi tuprɨ vahe ava imbahecua vai vahe sui; eremboyecua rumo ava seco mbegüemi vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ẽgüe ere niha mbahe nde remimbotar apo, che Ru” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Opacatu mbahe che Ru ombou cheu iyavei ndipoi ava che cua tuprɨ vahe yuvɨreco, che Ru güeraño ité rumo che cua; ndipoi avei che Ru oicua tuprɨ vahe yuvɨreco no, che güeraño ité aicua iyavei acoi que ava upe aicua uca potase, evocoi nungar upe aicua uca tuprɨra. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Peyu cheu opacatu icuerai vahe. Che amondora pe pɨtuhu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Peico che povrɨve, peyembohe avei che sui. Esepia, che ndache reco asɨi, iyavei che povrɨve pe recosa ndayavaimi eté. Ahese ramo oimera mbɨtuhusa pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mbɨtuhusa arɨ pɨpe Jesús yuvɨraso güemimbohe rese, oguata mbahe mitɨ pãhu rupi. Ahese semimbohe ndasɨepoi. Evocoiyase trigo rãhɨi oipoho-pohomi güemihura yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo yuvɨrecoi vahe osepiase, aipo ehi Jesús upe: —Esepia nde remimbohe. Oporavɨquɨño mbɨtuhusa arɨ pɨpe yuvɨreco —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ahe rumo omboyevɨ ahe fariseo upe: —Peicua tẽi niha icuachiaprɨ aracahendar mborerecuar guasu David rembiapogüer resendar ñehesa ondugüer reseve ndasɨepoise yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ahe niha yuvɨroique ité tũparo pɨpe pan imboeteiprɨ Tũpa upendar hu ãgua ondugüer reseve. Ahe chupe acoi ndipotasai ihu ãgua yuvɨreco viña. Judío pahi yuvɨrecoi vahe upeño ité niha ipotasa ihu ãgua yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ndapeyeroquɨi vo Moisés porocuaita resendar pɨpe? Esepia, judío pahi tũparo rese hañecosar ndopɨtuhui eté tũparo pɨpe yuvɨreco mbɨtuhusa arɨ pɨpe yepi. Ndahei rumo oyemboangaipa ipɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Cũritei cohave oime ava ɨvate catu vahe tũparo sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Evocoiyase pe ndapesenducuai eté Tũpa Ñehengagüer aipo ehi vahe: ‘Che aipota peporoparaɨsuereco, aní chira peropovẽhepa porerecosa mbahe mɨmba tẽi cheu’ ehi vahe. Pesenducuase viña, ahese, “Oyavɨ mbahe” ndapeye voi chira che remimbohe mbahe ndoyavɨi vahe upe viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Esepia, Ava Rɨquehɨr mbɨtuhusa arɨ rerecuar ité secoi —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ichui osose Jesús, oique judío tũparove. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aheve oime mbɨa ipo co cotɨgüer nomɨi vahe. Aheve avei fariseo, “Yaiñehengapo angahu Jesús” ehi yuvɨreco viña. Sese, —¿Iyaño pĩha mbɨtuhusa arɨ pɨpe ava imbogüerasa yepi’ —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Evocoiyase Jesús aipo ehi imboyevɨ: —¿Ava vo pe pãhu pendar acoi mbɨtuhusa arɨ pɨpe ovɨapise seimba ovesa ɨvɨcuarve ndosoi chira senose viña? ");
INSERT INTO gyrNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ava niha avɨye catu ovesa sui! Sese iyacatu yande yayapo mbahe avɨye vahe mbɨtuhusa arɨ pɨpe yepi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ahese aipo ehi aipo mbɨa upe: —Eichoho nde yɨva —ehi. Evocoiyase oichohose oyɨva, ocuera tuprɨ voi inungar ambuae iyɨva. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Evocoiyase fariseo opa yuvɨnose yuvɨraso oyemoingatu Jesús yuca ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Evocoiyase Jesús oicuase fariseo pɨhañemoñetasa, osẽ oso, ava rehɨi avei yuvɨraso supi. Setá avei imbaheasɨ vahe ombogüera, ");
INSERT INTO gyrNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","iyavei, “Che mombehui rene ava upe peyé” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ẽgüe ehi yavɨyepa Tũpa ñehe mombehusar Isaías remimombehugüer: ");
INSERT INTO gyrNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Co ité che mboyeroyasar che rembiporavo. Ahe asaɨsu eteprɨ. Sese ité ayembovɨha. Amondora che Espíritu chupe. Ahe omombehu aveira mbahe ihɨ̃vi vahe opacatu ava ɨvɨ pɨpendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Noiñehepoepɨ-epɨi chira ava, nasase-sasei tẽi chiaveira; iyavei ndosendui chietera ava iñehe ocar rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iyavei nomopei chietera que ñepei patavɨimi oyeapa vahe; nombogüei chiaveira tataendɨ sãtachiñomi tẽi vahe. Ẽgüe ehira mbahe ihɨ̃vi vahe pɨpe opacatu secopɨpa. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Evocoiyase opacatu tecua pendar ava ndahei vahe judío oyeroyara yuvɨreco sese’ ehi Isaías aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ichui ava ndasesapɨsoi vahe, noñehei vahe caruguar rerecosar vɨraso Jesús upe yuvɨreco. Evocoiyase Jesús ombogüera. Ahese osareco, oñehe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Evocoiyase opacatu ava oyepɨhamondɨisave aipo ehi yuvɨreco: “¿Tũpa Rembiporavo David suindar pĩha co?” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Osenduse rumo fariseo, “Co mbɨa caruguar rerecuar Beelzebú pĩratasa pɨpe tẽi omboyepepɨ caruguar ava sui” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Oicuaño rumo ipɨhañemoñetasa. Sese aipo ehi: “Que mborerecuar guasu povrɨ pendar ovava-vavase oyeupe oyeamotarẽhɨsave yuvɨreco, ahese evocoi mborerecuar pĩratasa ocañɨ tẽira. Iyavei que tecua pendar, anise, que ava omu rese ovavase oyeupe, oyoya oyemocañɨ tẽira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ẽgüe ehi avei caruguar. Esepia, serecuar omboyepepɨse opovrɨ pendar, ovavara oyeupe yuvɨreco viña. Evocoiyase ahe oyemocañɨ tẽira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iyavei pe, ‘Beelzebú pĩratasa pɨpe sui tẽi omboyepepɨ caruguar ava sui’ peye tẽi cheu. Evocoiyase, ¿ava pĩratasa pɨpe vo pe voya eta omboyepepɨ caruguar ava sui yuvɨreco? Tũpa pĩratasa pɨpese, che avei evocoiyase ayapo evocoi nungar ipĩratasa pɨpe. Pe voya ae omboyecuara pe ñehe pe rembiavɨ yuvɨreco pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Che rumo Tũpa Espíritu pĩratasa pɨpe amboyepepɨ caruguar ava sui. Sese cũritei pesepia ité Tũpa mborerecuasa. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Iyavei no, que ava oique potase ambuae ava ipĩrata eteprɨ vahe rẽtave imbahe rerocua ãgua ichui viña, yɨpɨndar opa rane itera oñapɨchi-pɨchi. Ipare voi opara vɨrocua imbahe ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Iyavei acoi ava ndache mboyoyai vahe, ahe che amotarẽhɨmbar yuvɨrecoi; acoi ava ndosecai vahe ava cheu nara, ahe omosai tẽi yuvɨreco che sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Sese ava upe oimera ñeroisa opacatu angaipa rese iyavei iñehe mara-mara tẽi vahe upe avei. Co catu acoi iñehe-ñehe tẽi vahe Tũpa Espíritu upe, ahe chupe ndipoi chietera ñeroisa. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iyavei acoi ava oñehe-ñehe tẽi vahe che, Ava Rɨquehɨr rese, ahe chupe oimeño ñeroisa; acoi oñehe-ñehe tẽi vahe rumo Espíritu amotarẽhɨsave, ahe chupe ndipoi chira ñeroisa co ɨvɨ pɨpe iyavei ɨvave” ehi Jesús fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Emoatɨro tuprɨ ɨvɨra, ahe iha avɨyera; nderemoatɨro tuprɨise ɨvɨra, ahe evocoiyase vɨrecora oha naporai vahe. Esepia, ɨvɨra icuasa iha rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Evocoiyase pe, mboi nungar tẽi peico vahe, pe recocuer naporaise, ndapeicatui chira mbahe avɨye vahe rese pe ñehe ãgua! Esepia, pe pɨha pɨpe sui tẽi osẽ pe ñehe ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Iyavei acoi ava avɨye vahe oñehe tuprɨ opɨhañemoñeta catuprɨsa pɨpe; acoi ava recocuer naporai vahe rumo, opɨhañemoñeta raisa pɨpe tẽi oñehe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Sese arɨ cañɨ pɨpe opacatu ava opara omombehu oñehe-ñehe tẽisa Tũpa rovai yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Esepia, pe ñehe avɨye vahe reprɨ peipɨsɨra, pe ñehe naporai vahe reprɨ peipɨsɨ aveira” ehi Jesús. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Evocoiyase fariseo iyavei Moisés porocuaita rese oporombohe vahe aipo ehi yuvɨreco Jesús upe: —Porombohesar, ore orosepia pota mbahe nde rembiapo poromondɨisa nde recocuer cua ãgua —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús rumo omboyevɨ iñehe: —Pe ava ndaseco põrai vahe, ndiporeroyai vahe, peporandu tẽi poromondɨisa tecocuer cua ãgua rese. Che rumo namboyecuai chira ambuae poromondɨisa; Jonás recocuer rese güeraño opomomahenduhara. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Esepia, inungar Jonás secoi mbosapɨ arɨ pira guasu avɨterve aracahe, ẽgüe ehi aveira Ava Rɨquehɨr mbosapɨ arɨ ɨvɨvrɨve tuira omano vahe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Evocoiyase arɨ cañɨ pɨpe ava tecua Nínive pendar porandusave omombehura ava cũriteindar cañɨpa ãgua. Esepia, Nínive pendar niha omboasɨse oangaipa, oyevɨ Tũpa upe yuvɨreco Jonás omombehuse Tũpa Ñehengagüer chupe. Cũritei rumo oime Jonás sui avɨye catu vahe pe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iyavei arɨ cañɨ pɨpe cuña mborerecuar guasu irohɨ cotɨ secua vahe porandusave, omombehura cũriteindar ava cañɨpa ãgua. Esepia, ahe ou amombrɨ sui Salomón mbahecuasa rendu ãgua. Cũritei rumo oime ɨvate catu vahe Salomón sui —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Iyavei caruguar osẽse ava sui, oguata tẽi ɨvɨ ipiru vahe rupi opɨtuhu ãgua reca. Ipare rumo ndoyosuise, ipɨhañemoñeta, ");
INSERT INTO gyrNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Ayevɨ irira che reco agüerve vicho’ ehi. Aheve oyevɨse, osepia iri secocuer inungar oɨ ndiporusai vahe, sahuvaprɨ tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sepiase, oso siete caruguar naporai catu vahe reca. Ichui güeruse, oyoya guasu yuvɨroique co mbɨa pɨha pɨpe. Sese mbahe tẽi catu ité secocuer yɨpɨndar güeco agüer sui. Ẽgüe ehi aveira ava cũriteindar ndaseco põrai vahe upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús oñehe vɨteseve ava upe, ahese ichɨ, tɨvɨreta reseve ocarve yuvɨnohai. Ahe oñehe pota yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Evocoiyase mbɨa omombehu Jesús upe: —Nde sɨ, nde rɨvɨreta reseve co ocarve yuvɨnohai. Ahe oñehe pota yuvɨreco ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ahe rumo, —¿Ava pĩha che sɨ; ava pĩha che rɨvrɨ? —ehi ahe mbɨa upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Evocoiyase omboyecua opo pɨpe güemimbohe eta aipo ehi: —Co che sɨ eta, co che rɨvɨreta. ");
INSERT INTO gyrNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Esepia, acoi che Ru ɨva pendar remimbotar oyapo vahe, ahe che rɨvrɨ, che reindrɨ iyavei ahe che sɨ yuvɨrecoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ahe arɨ pɨpe Jesús osẽ oɨ sui oso, oguapɨ ɨpa popɨve oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aheve ava oñemonuha atɨse yuvɨreco, oha carite pɨpe oguapɨ oĩ, evocoiyase opacatu ava opɨta ɨpa popɨ rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ahese omboyoya-yoya oporombohesa setá mbahe rese aipo ehi: “Ñepei mbɨa osẽ omahetɨ oico. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ahe otɨapɨ-apɨise mbahe rãhɨi oso, movɨro oitɨ perɨ rupi. Vɨ̃rai ogüeyɨse rumo sese, opaño yuvɨrohu. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iyavei movɨro oitɨ ɨvɨ nayanai vahesave ita pãhuve. Sese cũriteimi sorɨ; ");
INSERT INTO gyrNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","arɨ tasɨse rumo, opaño ipiru. Esepia, ndasapoi niha. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Iyavei ambuae mbahe rãhɨi oitɨ yu pãhuve. Ahe yu rumo sorɨ poyava catu yuvɨreco ichui. Sese opaño oyopɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ambuae rumo oitɨ ɨvɨ avɨye vahesave, ahe setá iha imonuhasa; ñepei ihɨ sui osẽ cién iha, ambuae sui osẽ sesenta, ambuae sui treinta. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Acoi ava osenducua pota vahe che ñehe, toyapɨsacaño sese” ehi Jesús ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ichui semimbohe eta oyemboya Jesús rese yuvɨreco mbahe rese oporandu ãgua chupe: “¿Mahera vo eremboyoya-yoya mbahe rese nde porombohesa ava upe yepi?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús aipo ehi: “Pẽu rumo Tũpa oicua uca ité mbahe ndicuasai vahe omborerecuasa resendar; ambuae ava upe rumo ndoicua ucai eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Esepia, acoi vɨreco vahe upe, imondosa catura; acoi ndovɨrecoi vahe evocoi osenducua raimi vahe serocuasañora ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sese añehese chupe, amboyoya-yoya aipo nungar mbahe yavai vahe ambuae mbahe rese yepi. Esepia, ahe osepia tẽi, ndosepiacuai rumo yuvɨreco iyavei osendu tẽi, ndosenducuai avei yuvɨreco no. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Na ehi yavɨye Tũpa Ñehengagüer Isaías remimombehu: ‘Pe niha pesendu tẽira, ndapeicuai chira rumo; iyavei pesepia tẽira, ndapesepiacuai chira rumo. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Esepia, evocoi ava eta upe yavai eté ipɨha pɨpe imbahe reroya ãgua, ndayapɨsai eté sendu potaẽhɨsave; ndoyemboesapɨsoi avei sepia potaẽhɨsave. Esepia, ndosenducua potai opɨha pɨpe yuvɨreco cheu oyevɨ potaẽhɨsave ombogüera ãgua’ ehi Isaías aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Pe rumo perorɨvete ité sepiacuase, pesenducuase avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Supi eté setá Tũpa ñehe mombehusar iyavei ava seco catuprɨ vahe aracahendar osepia pota tẽi mbahe pe rembiepia, ahe rumo ndosepiai eté yuvɨreco; iyavei osendu pota tẽi co pe remiendu, ahe rumo ndosendui avei yuvɨreco” ehi Jesús güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ipare aipo ehi: “Peyapɨsaca omahetɨ vahe recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Acoi osendu tẽi vahe Tũpa Ñehengagüer imborerecuasa resendar, ipare rumo ndosenducuai, ahe inungar acoi mbahe rãhɨi ovɨapi vahe perɨ rupi. Ipare rumo caruguar ou chupe. Ahe ipɨha pɨpe osendu vahe Tũpa Ñehengagüer opa tuprɨño omocañɨ ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Iyavei acoi mbahe rãhɨi seitɨprɨ ita pãhuve, ahe inungar ava recocuer yɨpɨño osendu vahe, oipɨsɨ vahe avei vorɨvetesa pɨpe Tũpa Ñehengagüer. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ipare rumo inungar co mbahe mitɨ ndovɨrecoi vahe guapo ovɨ̃racua ãgua, ẽgüe ehi avei evocoi nungar ava oimese mbahe-mbahe tẽi Tũpa Ñehengagüer sui chupe, cũriteimi seroyaẽhɨsave oyepepɨ ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Acoi mbahe rãhɨi seitɨprɨ yu pãhuve, ahe inungar ava osendu vahe Tũpa ñehe. Ipare rumo ahe ipɨhañemoñeta catu saɨsusave opacatu ombahe eta co ɨvɨ pɨpendar rese. Ipɨpe sui oyembopa uca ombahe eta upe. Ichui ndoguata iriño Tũpa Ñehengagüer rupi. Sese secocuer ndavɨye iri eté, inungar mbahe mitɨ ndihai vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Acoi itɨ̃sa vahe mbahe rãhɨi ɨvɨ avɨye vahe rese, ahe inungar ava osenducua vahe Tũpa Ñehengagüer. Iyavei inungar acoi co mbahe mitɨ ihá iteanga vahe, ẽgüe ehi avei ava secocuer avɨye vahe inungar ñepei-pei sãhɨi sui osẽ que cien iha, sesenta iha, anise que treinta” ehi Jesús güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús omombehu iri co ambuae mbahe rese yembohesa oyoya vahe: “Tũpa mborerecuasa oyoya tuprɨ ava oɨvɨ pɨpe mbahe rãhɨi oñotɨ vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Opacatu ava queseve rumo oyepota yamotarẽhɨsar, caha tẽi rãhɨi oñotɨ trigo pãhuve oso. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Acoi trigo iha potase, supive avei sorɨ caha. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Evocoiyase oporavɨquɨ vahe yuvɨraso, omombehu iyar upe aipo ehi yuvɨreco: ‘Ore rerecuar, ¿ndahei vo acoi mbahe rãhɨi avɨye vahe ereñotɨ nde ɨvɨ pɨpe? ¿Que sui ru caha sorɨ ipãhuve?’ ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Iyar rumo aipo ehi chupe: ‘Oime revo que che amotarẽhɨsar’ ehi. Evocoiyase oporavɨquɨ vahe oporandu yuvɨreco chupe: ‘¿Ndiyai pĩha caha tẽi orosapohopara ichui viña?’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ahe rumo aipo ehi chupe: ‘Aní, avɨyeteramo caha rupive pesapoho tiẽtera trigo’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Evocoiyase peseya, tocuacuaño oyoya yuvɨreco. Yavɨyese voi mbahe mitɨ, ahese che ayocuaira oporavɨquɨ vahe caha tẽi rane rerocua ãgua imboapuha uca sapɨ. Ipare oyapocatura trigo rãhɨi che mbahe apocatusave yuvɨreco’ ehi ɨvɨ yar” ehi Jesús. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús omombehu iri co ambuae mbahe rese yembohesa oyoya vahe: “Tũpa povrɨ pendar oyoya tuprɨ mostaza rãhɨi rese. Ahe mbɨa oñotɨ vahe oɨvɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Supi eté co mostaza rãhɨi tahɨmi catu opacatu ambuae mbahe rãhɨi sui. Ipare rumo, ocuacuase, tuvichá catu ambuae mbahe mitɨ sui inungar ɨvɨra tuvichá vahe. Ahe sãca rese vɨ̃rai rehɨi oyapo guaitɨrã” ehi oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ipare Jesús oporombohe iri ambuae mbahe rese aipo ehi: “Tũpa povrɨ pendar oyoya tuprɨ pan mboapeposa rese, acoi cuña omboyeseha tuprɨ vahe trigo cuhi rese opacatu imboapepo ãgua yepi” ehi oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús omombehu opacatu evocoi nungar mbahe omboyoya-yoyase oporombohesa ambuae mbahe rese opacatu ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Co rumo na ehi Tũpa ñehe mombehusar rembicuachiagüer avɨye ãgua: “Che añehese, amboyoyara che porombohesa ambuae mbahe rese. Iyavei amombehura Tũpa ɨvɨ apo suive mbahe niporẽhɨi vahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ahese Jesús, “Avɨye” ehi ava upe. Ipare oique oɨ pɨpe. Aheve semimbohe oyemboyapa yuvɨreco sese ‘tomombehu trigo pãhuve caha oime vahe resendar yandeu’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Evocoiyase omboyevɨ chupe: “Acoi ava mbahe rãhɨi avɨye vahe oñotɨ vahe, ahe che, Ava Rɨquehɨr. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ɨvɨ mbahe mitɨ rupa, ahe ava co ɨvɨ pɨpendar. Iyavei mbahe rãhɨi avɨye vahe, ahe ava Tũpa povrɨ pendar; caha naporai vahe, ahe ava caruguar suindar yuvɨrecoi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Acoi yamotarẽhɨmbar, oñotɨ vahe caha, ahe niha Caruguar ité. Evocoiyase arɨ mbahe mitɨ pohosa, ahe arɨ cañɨsa; acoi omonuha vahe mbahe mitɨ, ahe Tũpa rembiguai ɨva pendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Iyavei inungar acoi caha tẽi imonuhaprɨ sapɨ ãgua, ẽgüe ehi aveira arɨ cañɨ pɨpe coiye. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Evocoiyase che, Ava Rɨquehɨr, che rembiguai ɨva pendar amondora opacatu ava ambuae omboangaipa uca vahe, mbahe-mbahe tẽi aposar avei rerocua ãgua che povrɨve yuvɨrecoi vahe pãhu sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ichui omondopara tata guasuve. Aheve oyaseho tẽira iyavei ombotere-tere tẽira guãi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aheseve voi ava Tũpa reroyasar seco tuprɨ vahe, arɨ nungar sendɨ yaira Vu mborerecuasave yuvɨreco. Que ava osendu pota vahe che ñehe, toyapɨsacaño sese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Evocoiyase Tũpa mborerecuasa oyoya tuprɨ mbahe sepɨrusu vahe que ɨvɨ pɨpe ñomiprɨ rese. Ipare ava avɨyeteramo tẽi oyosura viña. Ahe rumo aheve avei oñomi. Ipare vorɨvetesa pɨpe opacatu ombahe omondopa co ɨvɨ rerocua ãgua mbahe sepɨrusu vahe pota raisa pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Iyavei Tũpa mborerecuasa inungar ava mbahe rerocuasar oseca vahe mbohɨr icatuprɨ vahe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ahe oyosuse mbohɨr sepɨ catu vahe, oso opacatu ombahe mondo co sepɨ catu vahe rerocua ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Iyavei Tũpa mborerecuasa inungar pira mbohasa. Imondoprɨ ɨpɨve. Ipare omboha opacatu-catu tẽi pira. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Acoi savapɨpose pira mbohasa, vɨnose ɨvɨ ãtasave yuvɨreco. Aheve oiporavo pira avɨye vahe oñoñapa ombahe rɨruve yuvɨnoi, naporai vahe rumo opaño omombo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ẽgüe ehi aveira arɨ cañɨ pɨpe: ahese Tũpa rembiguai ɨva pendar yuvɨnosera opacatu ava ndaseco põrai vahe mboyepepɨ ãgua ava seco catuprɨ vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Evocoiyase ava ndaseco põrai vahe imondosara tata guasuve. Aheve oyaseho tẽira iyavei ombotere-tere tẽira guãi yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Evocoiyase oporandu güemimbohe eta upe: —¿Pesenducua vo aipo opacatu? —ehi. —Taa —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Evocoiyase ahe aipo ehi: —Acoi ava oporombohe vahe porocuaita rese, oyembohe vahe avei che Ru mborerecuasa rese, ahe inungar ava oɨ yar vɨnose vahe ombahe ipɨasu vahe, ocuacua vahe avei yapocatusa sui —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Oñehe pare, Jesús osẽ ichui ");
INSERT INTO gyrNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","oyepota güecuave oso. Aheve ombohe ava judío tũparo pɨpe oico. Evocoiyase ahe pendar ava oyepɨhamondɨi tẽi: —¿Que pĩha co ava oyembohe catu ombahecua ãgua? iyavei, ¿mara ehi pĩha co mbahe poromondɨisa apo? —ehi yuvɨreco—. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ndahei vo acoi carpintero rahɨr tẽi? Ichɨ niha acoi María, iyavei yuvɨrecove tɨvrɨ, ahe Santiago, José, Simón, Judas. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Seindrɨ avei niha yuvɨrecove yande pãhuve. Evocoiyase, ¿que pĩha oyembohera viña? —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ipɨpe sui ndovɨroyai yuvɨreco. Ahe rumo aipo ehi chupe: —Tũpa ñehe mombehusar niha omboetei opacatu rupi yuvɨreco yepi. Secua pɨpendar, sẽta pɨpendar ae rumo nomboetei yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Evocoiyase, ahe ava vɨroyaẽhɨsa rese, movɨro tẽi oyapo mbahe poromondɨisa ipãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ahe arɨ rupi Herodes, mborerecuar guasu Galilea pendar, oyandu Jesús rerãcua. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Evocoiyase aipo ehi opɨ̃tɨvɨisar upe: “Juan Oporoãpiramo vahe revo ocuerayevɨ. Sese oyapo poromondɨisa ipĩrata vahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Esepia niha, yɨpɨndar Herodes Juan oipɨsɨ, oñapɨchi carena pɨpe soquenda ãgua vɨvrɨ Felipe rembireco Herodías sui tẽi, ");
INSERT INTO gyrNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","“Ndiyai eté nde rembireco nungar ererecora” oyeupe hese. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes oyuca pota Juan viña, osɨquɨyeño rumo ava eta sui. Esepia, ahe, “Tũpa ñehe mombehusar secoi” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Acoi Herodes haragüer mboeteisa pɨpe rumo aipo cuña Herodías membrɨ osẽ opɨvoi ava rehɨi rembiepiave. Herodes upe evocoiyase avɨye ai eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Sese ahe oyemoingatu ñepei reseve que mbahe oyeupe oporanduse imondo ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Evocoiyase ahe cuñatai oyeupe osɨ remimombehu rupi, aipo ehi Herodes upe: —Embou Juan Oporoãpiramo vahe ãca poratu pɨpe cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aipo ñehesa nombovɨhai eté Herodes; ndiya iri rumo, “Aní” ohe ãgua. Esepia, opacatu ava güemimborɨ eta rovaque aipo ehi. Sese, “Taperu chupe” ehiño. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ahese oporocuai Juan ãca hasɨa ãgua soquendasave. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ipare vɨraso poratu pɨpe cuñatai upe yuvɨreco. Evocoiyase ahe omondo osɨ upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ahese Juan remimbohe oyepota yugüeru, vɨraso sete ñotɨ yuvɨreco. Ipare yuvɨraso Jesús upe imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús oyanduse Juan manosa, ahese ahe ae oso ava porẽhɨsave carite pɨpe. Ava rehɨi rumo oyanduse, yuvɨnose voi güecua sui, ɨvɨ rupi yuvɨraso osupitɨ secosave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Evocoiyase osẽse carite pɨpe sui, osepia ava rehɨi. Ahese oiparaɨsuereco ava eta. Sese opa ombogüera imbaheasɨ vahe serasoprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Evocoiyase caharuse semimbohe oyemboya yuvɨreco sese aipo ehi: —Caharú ité moco cute iyavei ndipoi oɨ co rupivemi vahe. ¿Ndiyai vo eremondopa ava tecua-tecuami rupi, ahe supi tovɨrocua mbahe güemihura yuvɨreco? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Aní, ndiyai yuvɨraso. Pe pemondora mbahe semihura yuvɨreco —ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Poyandepomi tẽi rumo pan orovɨreco iyavei ñuvɨriomi tẽi avei pira —ehiño semimbohe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Peruño ave cheu —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ipare aipo ehi ava rehɨi upe: “Peguapɨ capihi harɨve” ehi. Evocoiyase oipɨsɨ poyandepomi vahe pan, ñuvɨriomi vahe pira. Ichui omahese ɨva rese, “Avɨye ndeu, che Ru” ehi. Ichui omombɨte-mbɨte pan imondo güemimbohe upe. Ahe evocoiyase omboyaho-yaho ava eta upe semihura yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Evocoiyase opacatu ava ocaru vahe ihɨ̃taropa tẽi yuvɨreco. Ipare semimbohe omboapɨpopa doce tuprɨ ɨruova sembihu rumbɨrer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ahe cuimbahe ocaru vahe retacuer cinco mil. Cuña rumo iyavei chĩhivahe ndipapasai yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ipare Jesús, “Peha pe rane carite pɨpe, pesasa ɨpa peso che renondeve. ‘Avɨye’ tahe rane ava eta upe” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","“Avɨye” ohe pare ava upe, oyeupi oso ahe ae ɨvɨtrɨ rese oyeroquɨ ãgua. Pɨ̃tuse chupe, opɨtaño aheve. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Aheseve carite oso pucuse ɨpa popɨ sui, ɨvɨtu ipĩrata vahe osovaĩchi yuvɨreco. Sese ohɨtu vahe nambegüe-mbegüei ocua sese. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Cõhe potase, oguata ɨ harɨ rupi oso güemimbohe cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Semimbohe ɨ harɨ rupi iguatase, oyembosɨquɨye yuvɨreco ichui. Sese, —¡Ndahei vo evocoi hãgüer secoi! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Güemimbohe upe rumo aipo ehi: —¡Peyemovɨracuaño, che tẽi! ¡Pesɨquɨye eme che sui! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","—Che Yar —ehi Pedro—. Nde ité ereicose, taguata ɨ harɨ rupi vicho nde pɨri —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Erio ru —ehi chupe. Evocoiyase Pedro ogüeyɨ carite pɨpe sui, oguata ɨ harɨ rupi. Osora ipɨri viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ɨvɨtu pĩrata repiase rumo, osɨquɨye ichui. Oso senise rumo ɨpɨve, —¡Che Yar! ¡Che pɨ̃sɨromi eve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ahese cũriteimi voi oipɨsɨ Pedro po rese, aipo ehi chupe: —¡Chĩhi tẽi ereyeroya che rese! ¡Mahera ndereyeroya tuprɨi che rese! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Oyuvɨrohase rumo carite pɨpe, opɨtuhu voi ɨvɨtu. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Evocoiyase carite pɨpe yuvɨrecoi vahe oñenopɨha sovai, —¡Supi eté catu nde Tũpa Rahɨr ereico! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Osasase ɨpa, oyepota Genesaret ɨvɨ rese yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Opacatu ahe pendar ava oicuase Jesús yepota, ahese opacatu tecuami rupi omombehu-mbehu ava upe yuvɨreco. Evocoiyase vɨraso imbaheasɨ vahe chupe, ");
INSERT INTO gyrNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","aipo ehi yuvɨreco: “Topocomi tẽi nde turucuar popɨ rese yuvɨreco” ehi; evocoiyase opacatu sese opoco vahe, ocuerapa voi eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Oyemboya Jesús rese movɨro fariseo iyavei Moisés porocuaita rese oporombohe vahe, yugüeru vahe tecua guasu Jerusalén sui. Ahe oporandu yuvɨreco chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Mahera vo nde remimbohe ndoguatai yande ramoi aracahendar aracuasa rupi yuvɨreco? ¿Mahera vo yande porocuaita mboavɨyeẽhɨsa pɨpe ndoyepoi ocaru ãgua yuvɨreco yepi? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús omboyevɨ aipo ehi chupe: —Pe no, ¡mahera ndapemboyeroyai Tũpa porocuaita pe ramoi aracahendar aracuasa rupi tẽi pe guata ãgua! ");
INSERT INTO gyrNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Esepia, Tũpa aipo ehi: “Pemboyeroyara iyavei peipɨ̃tɨvɨira pe ru, pe sɨ avei no. Acoi iñehe mara vahe oyesupa upe, ahe tomanoño” ehi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pe rumo aipo peye tẽi: “Acoi ava aipo ehi vahe vu upe, osɨ upe avei no: ‘Ndiyai chira mbahe mondo ãgua pẽu. Esepia, che opacatu mbahe areco vahe imondoprɨ Tũpa upe’ ehise, ");
INSERT INTO gyrNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ahese ndiyai eté ipɨ̃tɨvɨi ãgua chupe” peye. Ẽgüe peye pe aracua raisa pɨpe pemocañɨ Tũpa porocuaita peyesui. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Pe Tũpa reroyasar angahu tẽi peico vahe! Supi tuprɨ ité Tũpa ñehe mombehusar Isaías rembicuachía aracahendar omombehu pe recocuer: ");
INSERT INTO gyrNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Co tecua pendar ava oyuru pɨpe tẽi che mboetei yuvɨreco; ipɨhañemoñetasa rumo amombrɨ tẽi che sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Oyerure tuprɨ tẽi yuvɨreco cheu. Esepia, iporombohesa ava porocuaita tẽi’ ehi Isaías rembicuachiagüer pɨpe aracahe —ehi Jesús imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ipare, —Perio —ehi ava rehɨi upe—. Peyapɨsaca, pesenducua tuprɨ che ñehe: ");
INSERT INTO gyrNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","mbahe oique vahe ava yuru rupi nomboangaipa ucai. Mbahe osẽ vahe ava yuru pɨpe sui, ahe rumo omboangaipa uca —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Evocoiyase semimbohe oyemboya sese, oporandu yuvɨreco chupe: —¿Ereicua vo acoi fariseo oñemoɨro nde ñehe renduse yuvɨreco? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ahe rumo aipo ehi chupe: —Opacatu mbahe mitɨ ndahei vahe che Ru ɨva pendar remitɨ, opara sapohosa curi —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ẽgüe tehiño yuvɨreco. Esepia, evocoi inungar ndasesapɨsoi vahe vɨroguata ambuae ava ndasesapɨsoi vahe yuvɨreco. Ahe evocoiyase oyoya voira ovɨapi ɨvɨcuar pɨpe yuvɨraso —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Evocoiyase Pedro oporandu chupe aipo ehi: —Emombehu tuprɨ catu iri mbahe eremombehu vahe oreu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—¿Ndapesenducua vɨtei avei catu pe co ñehesa? ");
INSERT INTO gyrNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ndapeicuai vo opacatu mbahe acoi ava yuru rupi oique vahe oso yavɨterve, ipare osẽ setecuer sui? ");
INSERT INTO gyrNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ava pɨhañemoñetasa sui osẽ vahe rumo iyuru rupi, ahe ava omboangaipa. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Esepia, ava pɨhañemoñetasa sui osẽ pɨhañemoñeta raisa, porapichisa, mendasa sui yemboaguasasa, nomendai vahe yemboaguasa tẽisa, mondasa, temira iyavei ava rese ñemoñeta tẽisa. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Evocoi nungar mbahe rumo omboangaipa ava; ndahei angaipa acoi yande caru renonde yande yepoiẽhɨsa nungar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ichui osẽ Jesús oso, oguata Tiro ɨvɨ rupi, Sidón ɨvɨ rupi avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Cuña cananea, Tiro, Sidón ɨvɨ rese secoi vahe oyemboya Jesús rese aipo ehi: —¡Che Yar, David suindar, che paraɨsuerecomi eve! ¡Che membrɨ vɨreco caruguar oyese! —ehi pucu-pucu ou chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ahe rumo nomboyevɨi eté chupe. Evocoiyase semimbohe oyemboya yuvɨreco sese aipo ehi: —Emboyepepɨ co cuña yande sui. Esepia, sãse pucu-pucu ou yande raquɨcuei —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Evocoiyase aipo ehi güemimbohe upe: —Che Ru Tũpa rumo che mbou Israel recua pendar upeño. Esepia, ahe ovesa ocañɨ tẽi vahe nungar yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ahe cuña rumo oñenopɨha sovai, aipo ehi chupe: —¡Che Yar, che pɨ̃tɨvɨimi eve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ahe rumo aipo ehi chupe: —Naporai rumo yarocua pan tahɨr sui cave tohu yamondo vaherã —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Supi eté, che Yar, cave avei rumo ohuño ité pan rahɨcuer ovɨapi vahe yepi —ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—¡Cuña, tuvichá nde yeroyasa! Avɨye, ẽgüe tehi eté nde remimbotar rupi —ehi. Aipo ihe ramoseve, ocuera voi eté imembrɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ichui Jesús osẽ oso ɨpa Galilea ɨvɨi. Ipare oyeupi ɨvɨtrɨ rese oguapɨ oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Aheve setá ava oyepota, güeru atɨ imbaheasɨ vahe yuvɨreco chupe: ndipɨndugüei vahe, ndasesapɨsoi vahe, ipãri-pãri vahe, niñehengatui vahe, iyavei ambuae setá imbaheasɨ vahe no. Omondose sovai yuvɨreco, ahe opa ombogüera. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ichui ava niñehengatui vahe oñehe; ipãri-pãri vahe ocuera tuprɨ; ndoguatai vahe oguata avei iyavei ndasesapɨsoi vahe osareco yuvɨreco. Sepiase ava rehɨi oyepɨhamondɨi aipo ehi: “Imboeteiprɨ Israel Tũpa tasecoi” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Evocoiyase Jesús oñehe güemimbohe upe aipo ehi: —Iparaɨsu catu co ava yuvɨreco cheu. Esepia, mbosapɨ arɨ yuvɨrecoi yande pɨri iyavei ndipoi eté mbahe semihura. Ndiyai sẽtave sɨe porẽhɨ reseve amondo. Avɨyeteramo ovɨrovɨapi-api tiẽtera tɨeporẽhɨ perɨ rupi yuvɨreco viña —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Evocoiyase semimbohe aipo ehi yuvɨreco chupe: —¿Que sui pĩha orosecara tembihu ava rehɨi upe nara cohave ava porẽhɨsave viña? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—¿Mbovɨ vo pan pereco? —ehi. —Orovɨrecomi siete pan iyavei movɨromi tẽi pirami —ehi semimbohe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Evocoiyase, “Peguapɨ ɨvɨ harɨve” ehi ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ahese oipɨsɨ siete pan, pirami reseve, “Avɨye ndeu” ehi Vu upe. Ichui omboyaho-yaho güemimbohe upe imondo. Ahe evocoiyase omondopa ava rehɨi upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Opacatu ava ocaru vahe ihɨ̃taro yuvɨreco. Ipare semimbohe omboapɨpo iri rane sumbɨrer siete ɨruova yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cuimbahe ocaru vahe retacuer cuatro mil. Cuña, chĩhivahe retacuer rumo ndicuasai. ");
INSERT INTO gyrNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ipare Jesús, “Avɨye” ehi ava upe, ahese oha carite pɨpe oso ɨvɨ Magadán rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo iyavei saduceo yuvɨraso Jesús repia secoãha ãgua yuvɨreco viña. “Emoporẽhɨ Tũpa suindar nde recosa poromondɨisa pɨpe oreu” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Aipo ehi rumo fariseo, saduceo yuvɨrecoi vahe upe: “Supi eté amove caharuse pe aipo peye: ‘Arɨ tuprɨ aira. Esepia, ɨva rese pĩrá iteanga’; ");
INSERT INTO gyrNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","iyavei añihivei: ‘Co pɨpe arɨ naporai chira. Esepia, ɨva rese pĩra vai anga, pɨ̃tu guasu-guasu avei’ peye. Pe niha peicua mbahe ɨva resendar tẽi oyecua vahe mombehu; ndapeicuai rumo mara oyapave co poromondɨisa cũriteindar ava upe imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Co ava ndaseco põrai vahe oyepepɨ vahe Tũpa sui oporandu poromondɨisa rese ‘¿Tũpa suindar ité pĩha?’ oyapave. Che rumo namboyecuai chira ambuae poromondɨisa chupe; acoi poromondɨisa Tũpa oyapo Jonás upe güeraño tuprɨ aseyara chupe” ehi. Ichui oseyapaño ava rehɨi oso. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Evocoiyase semimbohe oyepota ɨpa rovai yuvɨraso. Pan sui rumo sesarai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Evocoiyase Jesús aipo ehi chupe: —Peicua catu fariseo iyavei saduceo pan mboapeposa sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iñehe renduse, semimbohe aipo ehi oyeupe yuvɨreco: —¡Ndayarui eté rumo pan! —ehi-ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ahe rumo oicua güemimbohe pɨhañemoñetasa. Sese aipo ehi chupe: —¡Mahera, “Ndayarui pan” peye! ¡Pe ndapeyeroya tuprɨi che rese! ");
INSERT INTO gyrNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ndapeicua vɨtei vo che rembiapo? ¿Ndapeyemomahenduha vɨtei eté vo acoi poyandepo pan mboyaho agüer acoi ava cinco mil upendar rese, iyavei mbovɨ ɨruova pemboapɨpo sumbɨrer imonuhase? ");
INSERT INTO gyrNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ndapeyemomahenduha vɨtei avei vo acoi amboyaho vahe siete pan ava cuatro mil vahe upe, iyavei mbovɨ ɨruova pemboapɨpo sumbɨrer? ");
INSERT INTO gyrNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¡Too, mara peye rutei pe aipo senducuaẽhɨ! Ndahei mo pan rese ité añehe. Peicua catu fariseo iyavei saduceo pan mboapeposa sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ahese ramo oicua yuvɨreco cute, ndahei pan mboapeposa rese ité oñehe, Jesús rumo oñehe fariseo iyavei saduceo eta porombohesa rese tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Oyepotase Jesús, oso tecua Cesarea cotɨ Filipo ɨvɨ rese, aheve oporandu güemimbohe upe aipo ehi: —¿Mara ehi vo ava oñehe yuvɨreco che rese, Ava Rɨquehɨr che recose? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Semimbohe evocoiyase aipo ehi yuvɨreco chupe: —Amove ava: “Juan Oporoãpiramo vahe” ehi yuvɨreco ndeu; ambuae aipo ehi yuvɨreco: “Elías”; ambuae ava aipo ehi avei yuvɨreco: “Jeremías”; anise ambuae ava, “Tũpa ñehe mombehusar mboetasa” ehi yuvɨreco ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Pe no, ¿‘Ava co secoi’ peye ru pe cheu no? —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Nde niha Tũpa supi eté vahe Rembiporavo imombehuprɨ; Tahɨr ité ereico —ehi Simón Pedro. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Nde sovasaprɨ ereico Simón, Jonás rahɨr. Esepia, ndahei ava tẽi omboyecua co mbahe ndeu, che Ru ɨva pendar teieté omboyecua ndeu —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nde Pedro ereico, co ita guasu harɨve amopuhara che tũparoguã. Ñepei yepe manosa ndosecoreroyɨi chietera opĩratasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Evocoiyase che amondo Tũpa mborerecuasa resendar mboisa ndeu; acoi, “Avɨye” erese que mbahe uve co ɨvɨ pɨpe, ẽgüe ehi aveira ɨvave; iyavei, “Aní” erese que mbahe uve co ɨvɨ pɨpe, ẽgüe ehi aveira ɨvave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ipare Jesús aipo ehi güemimbohe upe: “ ‘Co Tũpa Rembiporavo Poropɨ̃sɨrosar’ peye eme ava upe cheu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ichuive tuprɨ Jesús omboɨpɨ imombehu güemimbohe upe oico: “Iya niha cheu che so ãgua tecua guasu Jerusalén ve. Aheve judío rerecuar, pahi rerecuar ɨvate catu vahe iyavei Moisés porocuaita rese oporombohe vahe, ahe che mombaraɨsu ucara iyavei che yuca ucara yuvɨreco. Che yucasa sui rumo imombosapɨsa arɨ pɨpe acuerayevɨra” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro rumo vɨraso co cotɨmi chupe oñehengata ãgua: —¡Tũpa ndoipotai eté evocoi nungar nde reco ãgua, che Yar! ¡Ndipoi chietera mbahe ndeu! —ehi Pedro chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","—¡Esɨrɨ che sui, Caruguar! —ehi Pedro upe—. Nde che reitɨ pota eve mbahe tẽi pɨpe. Esepia, nandepɨhañemoñetai mbahe Tũpa upendar rese, ava nungar tẽi nde pɨhañemoñeta eico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ipare aipo ehi güemimbohe upe: —Acoi oguata pota vahe che rupi, tasesarai mbahe güemimbotar aposa sui iyavei inungar-ra curusu rese ovosɨira viña, toyemoingatu voi che recocuer rese oparaɨsu ãgua iyavei toguata tuprɨ che rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Esepia, acoi ava güetecuer tẽi raɨsupar, ocañɨ tẽi etera; acoi ava omocañɨ tẽi vahe rumo güetecuer che recocuer rese, ahe oñepɨsɨrora. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Esepia, ¿avɨye ai angahu pĩha ava upe opacatu mbahe co ɨvɨ pɨpendar pɨsɨ ãgua, ahe ae tẽi omocañɨse güecocuer yuvɨreco viña? ¿Mbovɨ pĩha omondora ava güecocuer repɨrã viña? ");
INSERT INTO gyrNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Esepia che, Ava Rɨquehɨr, ayevɨra che Ru reco pĩratasa pɨpe che rembiguai ɨva pendar reseve curi. Che evocoiyase aicuara ñepei-pei ava rembiapo agüer rupi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Supi eté oimera amove cohave ava nomano vɨtei chivaherã, ahe che, Ava Rɨquehɨr, che repia rane itera che yevɨse che mborerecuasa pɨpe yuvɨreco curi —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis arɨ pare Jesús vɨraso Pedro, Santiago, tɨvrɨ Juan reseve co cotɨ ɨvɨtrɨ ɨvate vahesave oyeupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aheve, avɨyeteramo tẽi oñecuñaro güemimbohe rovai. Evocoiyase sendɨ sova inungar arɨ, iturucuar morochí, sendɨ avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Aheseve voi oyemboyecua Moisés, Elías reseve yuvɨreco chupe. Ahe oñemoñeta oyeupe yuvɨnoha. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ahese Pedro aipo ehi chupe: —Che Yar, ¡avɨye ai eté cohave yaico! Ereipotase, ayapora mbosapɨ teyupami: ñepei ndeu nara, ambuae Moisés upe, ambuae evocoiyase Elías upe nara —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Avɨyeteramo tẽi ɨva quɨha rese osesapé ogüeyɨ ou oyopɨpa tuprɨ ité. Ipãhuve oyeendu ñehesa aipo ehi: “Co che Rahɨr, che rembiaɨsu. Che mbovɨharete; peyapɨsaca catu iñehe rese” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aipo renduse, semimbohe osɨquɨyé iteangasa pɨpe opaño ɨvɨ rese oñaca mboya yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ahese oyemboya oso güemimbohe rese, oñatoi aipo ehi chupe: —Pepũha; pesɨquɨyei rene —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Evocoiyase omahe yuvɨreco sese, ahese ahe güeraño osepia imoha yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ipare yuvɨrogüeyɨ ɨvɨtrɨ sui aipo ehi evocoi mbosapɨ güemimbohe upe: —Ndapemombehui chietera que ñepei ava upe co mbahe pesepia vahe, pemombehura rumo acoi che, Ava Rɨquehɨr, acuerayevɨse voi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Evocoiyase semimbohe oporandu yuvɨreco: —¿Mahera ru Moisés porocuaita rese oporombohe vahe: “Elías rane rumo oura curi” ehi yuvɨreco? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Evocoiyase omboyevɨ güemimbohe upe aipo ehi: —Elías rane ité niha oura opacatu mbahe moingatu ãgua curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ahe rumo ou ité cuese. Ndoicuai rumo ava yuvɨreco. Amove rumo opacatu güemimbotar tẽi oyapo yuvɨreco sese. Ẽgüe ahe aveira niha cheparaɨsura ahe ava povrɨve vichico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Evocoiyase semimbohe osenducua ramo iñehe yuvɨreco. Ẽgüe ehi Jesús oñehe Juan Oporoãpiramo vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Vɨroyepota Jesús güemimbohe ava rehɨisave seraso. Aheve mbɨa oyemboya oso sese, oñenopɨha sovai aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Che Yar, ereiparaɨsuerecomi tẽira che rahɨr cheu viña. Esepia, ahe ipɨha mbaheasɨ vahe, oyemombaraɨsú iteanga. Setá yupagüer ovɨapi tatave, ɨve avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Sese aru tẽi nde remimbohe upe. Nombogüera catui rumo yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","—¡Too, ndapeyeroya tuprɨ vɨteí eté che rese! ¡Co cotɨ tẽi vɨte pe pɨhañemoñetasa! ¡Mbovɨ rupi rutei vo aico vɨtera pe pãhuve che ñemosasa pɨpe! Peru evocoi chɨhivahe cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ahese oñehe pĩrata caruguar upe chĩhivahe sui imose. Aheseve ocuera tuprɨ voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ipare semimbohe oporandu co cotɨmi yuvɨreco chupe: —¿Mahera pĩha ndoromose catui eté caruguar ichui? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Esepia, ndapeyeroya tuprɨi Tũpa rese. Supi eté sese pe yeroyasa, yepe ndoyavɨi chira mostaza rãhɨi tahɨmi vahe viña, aipo peyera co ɨvɨtrɨ upe: ‘Esɨrɨ, eso coi cotɨ’ peyera. Evocoiyase ɨvɨtrɨ osɨrɨño itera. Ahese ndapemboavaimi chira mbahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Evocoi nungar caruguar imosesa yayerurese yande yecuacusa pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús oguata vɨteseve Galilea ɨvɨ rupi, aipo ehi güemimbohe upe oico: —Che, Ava Rɨquehɨr, imondoprɨ aicora che amotarẽhɨmbar povrɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Che yuca aveira yuvɨreco. Acuerayevɨra rumo imombosapɨsa arɨ pɨpe —ehi. Osenduse semimbohe aipo ihe, ndovɨhai tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Oyepotase Jesús güemimbohe reseve tecua Capernaum ve, aheve guarepochi rerocuasar tũparo upe nara yuvɨraso Pedro upe, oporandu yuvɨreco chupe: —¿Supi eté pe rerecuar ndomondoi guarepochi tũparo upe nara? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Omboepɨ niha —ehi Pedro chupe. Evocoiyase oiquese Pedro oɨ pɨpe, aheve Jesús rane oñehe chupe aipo ehi: —¿Mara ehi nde pɨhañemoñeta, Simón? ¿Ava sui vo vɨrocua guarepochi mborerecuar guasu co ɨvɨ pɨpe yepi? ¿Omu sui pĩha, ambuae ava sui tie? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro evocoiyase omboyevɨ chupe: —Ambuae ava sui —ehi. —¡Taa! —ehi—. Evocoiyase mborerecuar povrɨ pendar nomboepɨi chira yuvɨreco —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Guarepochi rerocuasar moñemoɨroẽhɨ ãgua rumo, eresora ɨpa pɨpe, epirapoi. Acoi yɨpɨndar pira erenose vahe, ahe iyuru pɨpe ereyosura ñepei guarepochi. Ahe eraso chupe. Ipɨpe iyacatura imboepɨ ãgua yandeu —ehi Jesús Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ahe arɨ pɨpeve semimbohe oyemboya Jesús rese yuvɨreco mbahe rese oporandu ãgua chupe: —¿Uma vo seco ɨvate catu vahe Tũpa mborerecuasa pɨpendar? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Evocoiyase Jesús: “Erio” ehi ñepei chĩhivahemi upe, omondo güemimbohe pãhuve imoha, ");
INSERT INTO gyrNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","aipo ehi: —Supi eté, acoi ndapeñecuñaroise iyavei ndapeicoise chĩhivahemi nungar, ahese ndapeiquei chira Tũpa mborerecuasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Acoi oñemomini vahe rumo inungar co chĩhivahemi, evocoi nungar seco ɨvate catura Tũpa mborerecuasave. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Acoi ava oipɨsɨ vahe co chĩhivahemi nungar che rer pɨpe sereco, che ité che pɨsɨ yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Acoi que ava rumo omboangaipa uca vahe co chĩhivahemi nungar che reroyasar, iyacatu evocoi nungar ava ñapɨchisa ita guasu iyesɨho rese para guasu pɨpe imombo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Iparaɨsu co ɨvɨ pɨpendar che reroyasar omboangaipa uca vahe yuvɨreco! Che reroyasar upe rumo oimeño itera poroãtoisa yepi, ¡ahe imboangaipa ucasar rumo iparaɨsu itera! ");
INSERT INTO gyrNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Sese inungar pe po, anise que pe pɨ avei pemboangaipa uca vahe, peyasɨa, pemombora amombrɨ peyesui viña. Esepia, avɨye catu peiquera tecove apɨrẽhɨsave ñepei pe pɨ, pe po rese, peso rãgüer sui tata guasu apɨrẽhɨsave ñuvɨrío pe po, que ñuvɨrío pe pɨ reseve. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iyavei pe resa pe mboangaipa ucase, penose, pemombo amombrɨ peyesui. Esepia niha, avɨye catu peiquera ñepeimi pe resa rese tecove apɨrẽhɨsave, ñuvɨrío pe resa rese tata guasu apɨrẽhɨsave pe reique rãgüer sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Peroɨ̃roi rene que ñepei chĩhivahemi che reroyasar. Esepia, ɨvave sembiguai che Ru pɨrindar ité yuvɨrecoi yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","“Che niha, Ava Rɨquehɨr, ayu ava ocañɨ tẽi vahe pɨ̃sɨro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Mara ehi pe pɨhave? Acoi vɨrecose mbɨa cien tuprɨ ovesa güeimba, ipare rumo ocañɨra ñepei ichui viña, evocoiyase oseya ranera noventa y nueve tẽi vahe ovesa ɨvɨtrɨ rese. Oyevɨra ocañɨ vahe reca oso. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ipare oyosuse rumo, ovɨharete catuñora evocoi ovesa rese ambuae noventa y nueve nocañɨi vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ẽgüe ehi avei che Ru ɨvave secoi vahe, ndoipotai eté que ñepei ava che reroyasar chĩhivahemi nungar cañɨ ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Acoi nde mboetasa Tũpa reroyasar oyapose que mbahe tẽi ndeu, eresora nde ae, eñehe mbahe ndeu oyavɨ vahe rese chupe. Nde ñehe vɨroyase, ahese peñero oyeupe cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nande reroyaise rumo, ahese ereñehera ñepei, anise ñuvɨrío ava upe nde pɨ̃tɨvɨi ãgua rese. Ahe avei tosendu pe ñehe. Ahese oimera que ñuvɨrío, anise mbosapɨ sendusar. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Acoi ndovɨroyaise pe ñehe, ahese emombehu opacatu Jesús reroyasar upe; ahe ndovɨroyaise ité no, evocoiyase Tũpa ndoicuai vahe nungar pereco iyavei inungar mbahe-mbahe tẽi aposar, ẽgüe peye sereco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Supi eté acoi, ‘Avɨye’ peyese que mbahe upe co ɨvɨ pɨpe; ẽgüe ehi aveira ɨvave. Iyavei co ɨvɨ pɨpe, ‘Aní’ peyese que mbahe upe, ẽgüe ehi aveira ɨvave. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Iyavei co amombehu potami avei pẽu: Acoi ñuvɨrío co ɨvɨ pɨpe pe pɨhañemoñetasa oyoya tuprɨse que mbahe rese peporandu ãgua pe yeruresa pɨpe, evocoiyase che Ru ɨva pendar omondora pe porandusa pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Esepia, acoi ava ñuvɨrío, que mbosapɨ oñemonuhase che rer pɨpe yuvɨreco, aheve che aico ipãhuve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ipare Pedro oyemboya sese oporandu: —Che Yar, ¿mbovɨ rupi vo che ñerora che mboetasa mbahe tẽi cheu oyapose? ¿Siete yupagüer rupi pĩha? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—¡Aní! —ehi—. ¡Setenta rupi siete oyupagüer! —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Tũpa mborerecuasa inungar mborerecuar guasu omoingatu pota vahe güembiguai revesa chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Evocoiyase omboɨpɨ imoingatu ãgua, ahese ipɨ̃tɨvɨisar güeru ireve atɨ catu vahe guarepochi rese chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ahe rumo ndovɨrecoi imboepɨ ãgua. Sese co mborerecuar oyocuai opɨ̃tɨvɨisar aipo ehi: ‘Timondopasa co che rembiguai sembireco reseve, tahɨr iyavei opacatu mbahe vɨreco vahe reseve irevesa mboepɨpa ãgua cheu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Evocoiyase sembiguai oñenopɨha sovai aipo ehi chupe: ‘¡Too! Che rerecuar, eñemosañomi tẽi cheu. Opara niha amboepɨ ndeu’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ahese oiparaɨsuereco, opoi irevesa sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aheseve voi rumo sembiguai osẽse, osepia ambuae ondugüer oyeupe ndaseta tuprɨi vahe ireve. Ahe chupe aipo ehi iyesɨho pɨsɨ: ‘¡Emboepɨpa acoi nde revesa cheu!’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘¡Aní!’ ehi oñenopɨha oso sovai, ‘Eñemosañomi tẽi cheu’ ehi, ‘amboepɨpara niha acoi che revesa ndeu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Niñero potai eté rumo. ‘Tomboepɨpa rane ité orevesa cheu’ ehi soquenda uca. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Osepiase rumo ambuae imboetasa, tasɨ́ iteanga ipɨha pɨpe. Ahese yuvɨraso omombehu güerecuar uve opacatu sembiapocuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Evocoiyase ahe serecuar güeru uca aipo ehi chupe: ‘¡Mbahe tẽi eté nde rembiapo! Che apoiño opacatu nde revesa sui. Esepia, ereyemombaraɨsu catumi ereporandu cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¡Ndiyai vo nde avei ereiparaɨsuereco nde mboetasa viña, inungar che oroparaɨsuereco!’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ichui serecuar oñemoɨrosave oyocuai imombaraɨsu ãgua ‘tomboepɨpa rane ité orevesa cheu’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Indó, evocoiyase ẽgüe ehi aveira che Ru ɨva pendar pẽu ndapeñeroise ité peyeupe” ehi Jesús güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ipare Jesús osẽ Galilea sui, oso Judea ɨvɨ rupi arɨ sẽsa cotɨ ɨai Jordán rovai. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ava rehɨi yuvɨraso saquɨcuei. Aheve setá imbaheasɨ vahe ombogüera. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Evocoiyase oyemboya fariseo Jesús rese yuvɨreco; secoãhasave oporandu yuvɨreco chupe: —¿Avɨye pĩha opoi cuimbahe güembireco sui que mbahe tẽi oyapose? —aipo ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ahe rumo omboyevɨ fariseo upe: —¿Ndapesenducuaimi vo ñehesa icuachiaprɨ pɨpe peyeroquɨse: ‘Yɨpɨndar yande Aposar oyapo cuimbahe, cuña avei’ ehi? ");
INSERT INTO gyrNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iyavei aipo ehi: ‘Sese niha cuimbahe omendase, oyepepɨra oyesupa sui güembireco rese ité yuvɨrecoi ãgua. Evocoiyase ñuvɨrío yuvɨrecoira ñepei ava nungar’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sese ndahe iri ñuvɨrío, ñepei vahe ité yuvɨrecoira. Evocoiyase ava Tũpa omomenda vahe oyese, ndiyai ava tẽi omboyepepɨ yuvɨreco oyesui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Evocoiyase fariseo oporandu yuvɨreco chupe: —¿Mahera ru oyocuai Moisés cuimbahe omondo vaherã güembireco upe cuachiar poisa resendar opoi ãgua ichui? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Pe poreroyaẽhɨsa pɨpe niha Moisés ẽgüe ehi pẽu. Yɨpɨsuive ité rumo Tũpa ndoipotai oyesui opoi ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Esepia, acoi opoi vahe güembireco mbahe ndoyavɨi vahe sui omendase ambuae cuña rese, ahe oyemboaguasa tẽi vahe —ehi fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ipare semimbohe aipo ehi yuvɨreco chupe: —Ẽgüe ehise cuimbahe güembireco rese, evocoiyase avɨye catu ndayamendai chira —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—Ndahei chira rumo opacatu osenducua che aipo ahe vahe yuvɨreco. Tũpa ombou vahe sembiaporã, ahe güeraño osenducuara yuvɨreco —ehi güemimbohe upe—. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Esepia, oime pɨhañemoñetasa ava mendaẽhɨ ãgua: amove ohasa suive ndatahɨi vahe, ambuae nomboahɨ ucai ava yuvɨreco, ambuae evocoiyase nimendasei. Esepia, ahe oporavɨquɨ pota Tũpa mborerecuasa reseño ité. Acoi oicatu vahe co ñehesa reroya ãgua, tovɨroyaño —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ipare ahe pendar güeru movɨro chĩhivahe Jesús upe yuvɨreco ‘tomondo opo iharɨve; toyerure avei sese no’ oyapave; semimbohe rumo, “¿Mahera vo peruño tẽi chĩhivahe?” ehiño serusar upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesús rumo aipo ehi: —¡Mahera ndapeipotai iyu ãgua! Toyugüeruño chĩhivahe cheu. Esepia, co chĩhivahe nungar ava yuvɨroiquera che Ru povrɨve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ipare omondo opo chĩhivahe harɨve osovasa. Ichui osẽ oso. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mbɨa chĩhivahe mbahe yar oso Jesús upe oporandu: —Porombohesar, ¿mbahe vo avɨye vahe ayapora tecovesa apɨrẽhɨ vahe rereco ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—¡Mahera ereporandu cheu mbahe avɨye vahe rese! —ehi—. Ñepeiño ité avɨye vahe oime. Erereco potase rumo tecovesa apɨrẽhɨ vahe, emboyeroya mborocuaita —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Uma vo aipo mborocuaita? —ehi. Ahese omboyevɨ chupe: —‘Ndereporoyucai chira, nandeaguasai chira, nandemondai chira, nanderemirai chiaveira ambuae ava rese, ");
INSERT INTO gyrNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","eremboyeroyara nde ru, nde sɨ avei, eresaɨsura ambuae ava nde yeaɨsu nungar eico’ ehi icuachiaprɨ pɨpe —ehi mbahe yar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Co rumo mborocuaita opacatu amboavɨye ité yepi. ¿Mbahe vo evocoiyase ipane vɨte che ayapo vaherã? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—Ereipotase mbahe tuprɨ pɨpe nde reco ãgua, emondopa rane nde mbahe; ahe seprɨ evocoiyase eremondora ava iparaɨsu vahe upe. Ichui ererecora mbahe avɨye vahe ɨvave. Ipare ereguatara che rupi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Aipo oyeupe hese rumo, ahe mbɨa oyepepɨño ichui ovɨharẽhɨsave oso. Esepia, mbahe yar ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Evocoiyase aipo ehi güemimbohe upe: —Supi eté yavai eteanga imbahe eta vahe upe oique vaherã che Ru mborerecuasave. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aipo ahe iri: Yavai rai camello upe yucuar rupi seique ãgua; ava imbahe eta vahe upe rumo yavai catu che Ru mborerecuasave seique ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Aipo iñehesa renduse, semimbohe oyepɨhamondɨi aipo ehi: —¡Ava angahu pĩha evocoiyase oñepɨsɨrora yuvɨreco viña! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Omahe güemimbohe rese, aipo ehi: —Ava tẽi upe yavai aipo nungar mbahe apo. Tũpa upe rumo mbahe opacatú ndayavaimi eté —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ahese Pedro aipo ehi chupe: —Ore rumo oroseyapa opacatu ore mbahe nde rupi ore guata ãgua. ¿Mbahe evocoiyase oimera oreu? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Oime itera niha mbahe pẽu. Esepia, acoi arɨ oyepotase opacatu mbahe recuñaro ãgua, ahese che, Ava Rɨquehɨr, aguapɨra che rendave che mborerecua guasusave. Pe avei, che rupindar, peguapɨra doce tenda harɨve. Ahese opacatu judío acoi doce imar Israel suindar recocuer rese peporandura curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Acoi opacatu ava oseya vahe güẽta, anise que vɨquehɨr, anise vɨvrɨ, güeindrɨ, que vu, anise osɨ, guahɨr, que oɨvɨ avei che raɨsusa pɨpe, ahe oipɨsɨra omahera cien yupagüer rupi mbahe oseya vahe iyavei vɨrecora tecovesa apɨrẽhɨ vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Seta vai rumo cũritei yɨpɨndar vahe, ipa tẽira yuvɨrecoi; setá aveira cũritei ipa tẽi vahe, yɨpɨndar yuvɨrecoira curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tũpa mborerecuasa inungar acoi ava ɨvɨ yar osẽ añihiveive oyeupe nara oporavɨquɨ vahe reca ‘toporavɨquɨ che uva tɨve yuvɨreco’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oyosuse ava, ahese omoingatu oyeupe oporavɨquɨ vaherã upe ñepei arɨ mboravɨquɨ reprɨ imboepɨ ãgua. Ahese opa omondo ocove imboporavɨquɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ipare osẽ, oso añihivei, arɨvate catumi osepia ocarusu pɨpe ambuae ava oporavɨquɨsa ndovɨrecoi vahe, ");
INSERT INTO gyrNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","aipo ehi chupe: ‘Peso, tapeporavɨquɨ che uva tɨve. Amboepɨ tuprɨra niha pẽu’ ehi. Ahe evocoiyase yuvɨraso oporavɨquɨ ãgua icove. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ipare oso iri mbɨter arɨ rupi oyeupe oporavɨquɨ vahe reca, ẽgüe ehi tuprɨ avei caharuse, las tres rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ipa osẽ iri las cinco pɨpe, aheve avei osepia ambuae ava ndovɨrecoi vahe oporavɨquɨsa yuvɨnoha. Chupe aipo ehi: ‘¿Mahera peyembohɨ tẽi arɨ momba cohave pehã?’ ");
INSERT INTO gyrNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘¡Aní!’ ehi yuvɨreco, ‘Esepia, ndipoi eté ava, tapeporavɨquɨmi, ehi vahe oreu’ ehi. Evocoiyase, ‘Peso, pe avei peporavɨquɨ tɨve’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Pɨ̃tu ramose, cove yar aipo ehi oporavɨquɨ vahe rese yangarecuar upe: ‘Eñehepa ava oporavɨquɨ vahe upe. Emboepɨ ipa yugüeru vahe upe rane iporavɨquɨ yuvɨreco chupe. Ipare tenonendar uve’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Evocoiyase las cinco pɨpe yuvɨroique vahe oporavɨquɨ, ahe rane tenonde yugüeru. Oyacatu ñepei-pei ñepei arɨ rupindar oipɨsɨ guarepochi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ipare tenonde catu yuvɨroique vahe oporavɨquɨ, ahe chupe ipa tẽi imboepɨsa. Ahe ipɨhañemoñeta, ‘Yaipɨsɨ catura revo guarepochi’ ehi oyeupe yuvɨreco viña. Ipare rumo ahe tuprɨño avei oipɨsɨ ñepei arɨ rupindar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Guarepochi pɨsɨre rumo oñemoɨro cove yar upe yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","aipo ehi: ‘Co ava yugüeru ipa tẽi vahe, ñepei horami tẽi oporavɨquɨ yuvɨreco. Nde rumo eremboepɨ oyoya tuprɨño ité oreu eremboepɨ vahe rese. Oroñemosaño tẽi oroporavɨquɨ arɨ momba sacucuer upe oroico’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Cove yar rumo aipo ehi ñepei ipãhu pendar upe: ‘Mborɨ, ndahei mbahe tẽi ayapo ndeu. Esepia, amboepɨ guarepochi ñepei arɨ resendar ndeu acoi, Avɨye, peye vahecuer rese cheu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","‘Evocoiyase ndo co, eipɨsɨ nde guarepochi, eraso. Che rumo amondo pota co ava ipa tẽi oique vahe upe inungar tuprɨ ndeu amboepɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Esepia, cheu iyacatu ité che remimbotar rupi mbahe ayapo che guarepochi rese. Nderecatẽhɨ tie ambuae ava mbahe rese che ayapose mbahe avɨye vahe chupe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Indó, ẽgüe ehi aveira ava seco ɨvɨ cotɨ catu vahe seco ɨvate catura yuvɨreco; iyavei yɨpɨndar ava seco ɨvate catu yuvɨrecoi vahe, ahe seco ɨvɨ cotɨ catu tẽi vaherã yuvɨreco curi” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús oguata oso tecua Jerusalén piar rupi. Ahese co cotɨmi oipeha güemimbohe doce vahe oyeupe aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Peyapɨsaca tuprɨ che ñehe rese: yasora tecua Jerusalén ve. Aheve che, Ava Rɨquehɨr, che pɨsɨra, che mondo pahi eta rerecuar iyavei Moisés porocuaita rese oporombohe vahe povrɨve yuvɨreco. Ahe, “Tomano” ehira yuvɨreco cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ipare che mondora ava ndahei vahe yande mu upe mara-mara tẽi che rereco ãgua che reroɨ̃rosa pɨpe. Ipɨpe che yucara curusu rese yuvɨreco. Imombosapɨsa arɨ pɨpe rumo acuerayevɨra —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ipare Zebedeo rembireco ñuvɨrío omembrɨ reseve, oyemboya Jesús rese yuvɨreco. Ahese oñenopɨha sovai oporandu ãgua mbahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Evocoiyase, —¿Mbahe vo ereipotami? —aipo ehi ichɨ upe. —Che aipota che membrɨ eremboguapɨra ndeyepɨri ñepei nde mbahe rese pocosa cotɨ, ambuae nde mbahe rese pocoẽhɨsa cotɨ nde mborerecuasave —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Pe ndapeicuai mbahe rese peporandu. ¿Peiporara catura pĩha co mbahe-mbahe tẽi aiporara vaherã, inungar-ra que ɨgua iro vahe aɨhu vaherã viña? —ehi. —Taa, oroicatuño itera —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Supi eté peiporarara mbahe-mbahe tẽi. Co rumo ndiyai cheu, che pɨri opomboguapɨ ãgua che mbahe rese pocosa cotɨ, ambuae che mbahe rese pocoẽhɨsa cotɨ avei. Che Ru rumo omoingatu güembiporavo upe nara oguapɨ vaherã che ɨpɨve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Aipo iñehesa renduse ore ambuae diez semimbohe, oroñemoɨro Santiago, Juan upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Evocoiyase, “Perio” ehi oreu. —Peicua niha acoi mborerecuar guasu yuvɨrecoi vahe Tũpa cuaparẽhɨ oporocuai oporoyuca ai tẽisa pɨpe, iyavei acoi ɨvate catu vahe oyeecoapɨrasá omborerecuasa pɨpe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pe rumo ẽgüe ndapeyei chira peico. Iyacatu rumo acoi ava oipota vahe ɨvate catu güeco ãgua pe pãhuve, ihañeco rane itera opacatu ambuae ava rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iyavei acoi pe pãhu pendar oipota vahe tenonde catu güeco ãgua, ihañeco tuprɨ ranera opacatu pe pãhu pendar rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Esepia, che, Ava Rɨquehɨr, ayu ndahei ava che rese ihañeco ãgua, che rumo ayu ava rese che hañeco ãgua iyavei amano vaherã ava eta repɨrã Caruguar povrɨ sui senose ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ipare Jesús, güemimbohe reseve oñocuase tecua Jericó yuvɨreco, ahese ava rehɨi yuvɨraso saquɨcuei. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aheve perɨ popɨve ñuvɨrío ava ndasesapɨsoi vahe oguapɨ yuvɨnoi. Evocoiyase osenduse Jesús ocuase supi, osapucai pĩrata yuvɨreco chupe aipo ehi: —¡Ore Yar, mborerecuar guasu David suindar, ore paraɨsuerecomi tẽi eve! —ehi yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ahe ava oyaca-yacaño: “Quiriri” ehi yuvɨreco chupe. Ahe rumo osapucai pĩrata catuño ité yuvɨreco aipo ehi: —¡Ore Yar, David suindar, ore paraɨsuerecomi tẽira eve viña! —ehi iriño ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Evocoiyase osendu iñehe, opɨta, “Perio” ehi chupe. Ipare, —¿Mbahe vo peipota ayapo vaherã pẽu? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—¡Ore Yar, ore mbosarecomi tẽi eve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Evocoiyase saɨsusave opoco sesa rese. Ahe ramoseve ndasesapɨsoi vahe osareco tuprɨ ai eté yuvɨreco. Ipare yuvɨrasoño ité supi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Acoi orovɨrovɨse Jerusalén, oroyepota tecuami Betfagé popɨve, ɨvɨtrɨ Olivo serer vahe ɨ̃pɨimi. Aheve omondo ñuvɨrío güemimbohe ");
INSERT INTO gyrNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","aipo ehi chupe: —Peso co tecuami yande rovaindarve. Aheve pesepiara guaricu imembrɨ reseve ñapɨchimbrɨ imoha. Ahe peyorañora seru cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Acoi que ava oporanduse yuvɨreco pẽu sese, “Yar oiporu pota, ipare niha omboyevɨ voiñora” peyera chupe —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Co ẽgüe ehi chupe aracahendar Tũpa ñehe mombehusar ñehengagüer mboavɨye ãgua, aipo ehi vahe: ");
INSERT INTO gyrNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Pemombehu Sión pendar upe: ‘Pesepia, pe rerecuar guasu ou oico güeco mbegüesa pɨpe pẽu guaricu harɨve imembrɨ reseve’ peyera” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Evocoiyase evocoi semimbohe yuvɨraso, oyapo ité ocuaisa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Güeru guaricu imembrɨ reseve yuvɨreco chupe. Omondo oturucuar icupeao ãgua yuvɨreco. Ipare Jesús oyeupi iharɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iyavei ava rehɨi oipɨpira oturucuar perɨ rupi imboetei guasusa pɨpe. Ambuae evocoiyase oyasɨa pindo omondo perɨ rupi yuvɨreco saperã. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ava rehɨi senonde, saquɨcuei avei oguata vahe osapucai yuvɨreco aipo ehi: —¡Co mborerecuar guasu David suindar, imboeteiprɨ tasecoi! —ehi—. ¡Sovasaprɨ secoi ou vahe yande Yar rer pɨpe! ¡Ɨvave imboeteiprɨ tasecoi! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Oiquese Jerusalén pɨpe, opacatu co tecua pɨpendar oyepɨhamondɨi yuvɨreco. Iyavei setá oporandu-randu yuvɨreco: —¿Ava pĩha co mbɨa? —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ava rehɨi oguata vahe Jesús rupi aipo ehi yuvɨreco chupe: —Co niha Jesús, Tũpa ñehe mombehusar, ɨvɨ Galilea rupindar, Nazaret pendar —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ipare Jesús oique judío tũparo guasu pɨpe. Ipɨpendar opa omombo ichui ava mbahe mondosar, mbahe rerocuasar. Iyavei ava guarepochi recuñarosar mesa opa ombovɨapi ichui; apɨcasu mondosar renda avei ombovɨapi imondo. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ipare aipo ehi chupe: —Icuachiaprɨ aracahendar pɨpe aipo ehi: ‘Che rẽta yeruresa rẽtarã’ ehi. Pe rumo imonda rai vahe rẽta nungar tẽi pereco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aheve oyemboya Jesús rese yugüeru ava ndasesapɨsoi vahe, ipãri-pãri vahe avei. Ahe opa ombogüera. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Osepiase rumo pahi rerecuar guasu iyavei judío porocuaita rese oporombohe vahe yuvɨreco mbahe ndayasepiai vahe sembiapo, iyavei tũparo pɨpe osenduse chĩhivahe sapucaisa: “¡Imboeteiprɨ David suindar tasecoi!” ehise, ahese oñemoɨro yuvɨreco ");
INSERT INTO gyrNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","aipo ehi chupe: —¡Eresendu vo aipo ehi tẽi vahe chĩhivahe yuvɨreco! —ehi. —Taa, asendu ité —ehi—. Pe no, ¿ndapeyeroquɨi vo sesendar ñehesa icuachiaprɨ pɨpe: ‘Chĩhivahemi, pĩtanimi avei osapucaira nde mboeteisa pɨpe yuvɨreco’ ehi vahe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ipare opaño oseya ava oso tecua Betania ve. Aheve ñepei pɨ̃tu oque. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ahere ayihive añihiveive, oyevɨse tecua Jerusalén ve, Jesús ndasɨepoi oico. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aheve perɨ popɨve osepia ɨvɨra higuera. Ahe sese oyemboya oso ‘¿iha pĩha?’ oya viña. So güeraño tẽi rumo osepia. Evocoiyase ahe aipo ehi chupe: —¡Co pɨpe suive nandehai chietera! —ehi. Aheseve voi opa ipiru. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ahe mbahe repiase, ore, —¡Too, mara ehi rutei pĩha co cũriteimi opa voi ipiru! —orohe tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ahese omboyevɨ oreu: —Acoi peyeroyase ité Tũpa rese, ahese ndahei co mbahe güeraño peyapora. Co ɨvɨtrɨ uve avei rumo: ‘Esɨrɨ ave sui, eso para guasu pɨpe’ peyese, ahe evocoiyase osɨrɨño itera. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Indó, acoi peyerurese mbahe pe porandusa rese Tũpa rese pe yeroyasa pɨpe, peipɨsɨ itera ahe mbahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ichui Jesús oique iri judío tũparo guasu pɨpe oporombohe. Ahese pahi eta rerecuar, judío rerecuar avei oyemboya sese, oporandu yuvɨreco chupe: —¿Ava nde cuaita pɨpe vo ereyapo co nungar eico? ¿Ava vo ombou nde mborerecuarã ndeu? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Evocoiyase ahe aipo ehi chupe: —Che avei aporandura mbahe rese pẽu. Pemboyevɨse che porandusa, ahese che avei amombehura ava porocuaita rupi eté pĩha ayapo co mbahe vichico. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ava vo Juan ombou ava ãpiramo ãgua? ¿Tũpa pĩha, ava tẽi tie? —ehi. Evocoiyase oñemoñeta aipo ehi oyeupe yuvɨreco: “ ‘Tũpa ombou’ yahese chupe, ahe evocoiyase omboyevɨra yandeu: ‘¿Mahera ru evocoiyase ndaperoyai?’ ehira. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Anise, ‘Ava tẽi remimbou’ yahese rumo, avɨyeteramo opacatu ava yande amotarẽhɨra yuvɨreco. Esepia, opacatu: ‘Juan omombehu vahe ñehesa Tũpa suindar’ ehi eté yuvɨreco chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Sese, —Ndoroicuai eté Juan mbousar —ehiño yuvɨreco. Ahese ahe aipo ehi: —Evocoiyase che avei, “Ahe iporocuaita pɨpe co mbahe ayapo” ndahei chietera pẽu —ehi mborerecuar guasu upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iyavei Jesús aipo ehi judío rerecuareta upe: —¿Mara ehi pe pɨhañemoñetasa co rese? Oime mbɨa vɨreco vahe ñuvɨrío guahɨr. Ahe aipo ehi ocuacua catu vahe upe: ‘Che rahɨr, co pɨpe eresora, eporavɨquɨ cove’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘¡Nachequerẽhɨi!’ ehi voiño. Coiye rumo, ‘¿Mahera ẽgüe ahe?’ ehi. Ipare osoño ité, oporavɨquɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ipare oso ambuae guahɨr upe: ‘Eresora, eporavɨquɨ cove’ ehi tuprɨ avei. Evocoiyase, ‘Asora, che ru’ ehi angahu. Ipare rumo ndosoi eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Uma vo co ñuvɨrío yuvɨrecoi vahe oyapo vu remimbotar? —ehi. —Co yɨpɨndar vahe —ehi yuvɨreco. —Supi eté. Esepia, co angaipa viyar mbahe-mbahe tẽi aposar, cuña oyemondo-mondo tẽi vahe avei, ahe rane yuvɨroiquera Tũpa mborerecuasave pe sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Esepia, Juan Oporoãpiramo vahe ou co tecocuer ihɨ̃vi vahe mboyecua ãgua pẽu pe reco tuprɨ ãgua viña. Pe rumo ndaperoyai eté. Co angaipa viyar iyavei co cuña oyemondo-mondo tẽi vahe ava upe, ahe rumo vɨroya ité yuvɨreco. Yepe pesepia tẽi opacatu evocoi mbahe viña, ipare rumo ndapeñecuñaroi pe recocuerai sui seroya ãgua —ehi mborerecuar guasu yuvɨrecoi vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pesendu ambuae ava recocuer rese yembohesa: Oime ɨvɨ yar oñotɨ vahe uva oɨvɨ pɨpe, ahe oñachi tuprɨ sereco, oyapo uva rɨ̃avɨi ãgua; oyapo avei oɨ ɨvate vahe ahe sese mahemoha ãgua. Ipare oseya oɨvɨ ava oporavɨquɨ vahe upe iporu ãgua. Ichui osẽ oso amombrɨ vahesa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Coiye oyepotase arɨ uva pohosa, ahese omondo güembiguai oporavɨquɨ vahe upe imboporandu ãgua ‘taipɨsɨ uva pohoprɨ cheundar cute’ oyapave viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ipare rumo oporavɨquɨ vahe oipɨsɨ sembiguai yuvɨreco: amove oinupa-nupa yuvɨreco, amove oyuca, oyapi-yapi avei amove ita pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ipare rumo ɨvɨ yar setá catu omondo iri güembiguai. Oporavɨquɨ vahe rumo mara-mara tẽiño avei vɨreco yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Coiye rumo guahɨr teieté omondo chupe cute. Ahe ipɨhañemoñeta: ‘Omboyeroya catura revo che rahɨr yuvɨreco’ ehi viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Evocoiyase ahe ava tahɨr repiase, ‘Co aipo oipɨsɨra vu mbahe; yayucaño, evocoiyase co ɨvɨ opɨtara yandeu nara’ ehi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Evocoiyase oipɨsɨ, vɨnose mitɨ pãhu sui, oyuca ité yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Acoi ouse ɨvɨ yar, ¿mbahe vo oyapora oporavɨquɨ vahe upe?” ehi oñehe rendusar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ahe evocoiyase, —Opara revo oyuca saɨsuẽhɨsa pɨpe ité co ava ndipɨhai vahe yuvɨreco. Ipare revo omondora oɨvɨ ambuae ava oporavɨquɨ vahe uve iporu ãgua ‘ahe tombou voimi uva ipohopɨrer cheundar cheu curi’ ohesa pɨpe —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aipo ihe pare, aipo ehi oñehe rendusar upe: —¿Ndapeyeroquɨi vo co aipo ehi vahe icuachiaprɨ pɨpe? ‘Co ita oɨ aposar opaño omombo yuvɨreco. Ahe ita rumo avɨye catu vahe oɨ movɨracua tuprɨ ãgua. Ẽgüe ehi niha Yar yapo yande mohapɨsɨ ai eté’ ehi icuachiaprɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Sese che Ru Tũpa mborerecuasa serocuasara pe sui. Ambuae ava upe rumo imondosara. Ahe vɨrasora che Ru mombahesa chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Acoi que ovɨapi vahe evocoi ita harɨve, opa tẽira ahe ae oyemomara; iyavei acoi ovɨapise evocoi ita que ava harɨve, ahese opa tuprɨ aveira omocañɨ —ehi Jesús oñehe oyese. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Acoi osenduse pahi rerecuar iyavei fariseo yuvɨrecoi vahe, osenducua oyesendar ñehesa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Aheseve oipɨsɨ pota voi yuvɨreco viña. Osɨquɨyeño rumo ava rehɨi sui yuvɨreco. Esepia, opacatu ava ipɨhañemoñeta: “Co ité Tũpa pĩratasa pɨpe oñehe” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ipare Jesús oporombohe iri ambuae ava recocuer rese aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tũpa omborerecuasave inungar mborerecuar guasu guahɨr mendase oyapo pieta. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ipare oyocuai güembiguai eta ‘ava ichohoprɨ upe toyugüeru cute’ oya. Ichohoprɨ rumo niquerẽhɨ iri yugüeru aheve. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ipare oyocuai iri ambuae güembiguai eta aipo ehi: ‘Aipo peyera ichohoprɨ upe: ¡Toyugüeruño ité! Esepia, opa ité oingatu tembihu iyavei ayuca uca tɨvi iyavei ambuae mbahe mɨmba iquɨra vahe. Che opacatu amoingatu. Sese toyugüeruño ité mendasave, ehi, peyera chupe’ ehi güembiguai upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ichohoprɨ rumo ndovɨroyai eté yuvɨreco. Evocoiyase ñepei osoño ocove, ambuae oso ombahe movendesave, ");
INSERT INTO gyrNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ambuae rumo oipɨsɨ sembiguai mara-mara tẽi sereco ãgua. Ahe ipɨpe oyuca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Evocoiyase mborerecuar guasu oñemoɨro eteprɨsave omondo osundao eta co ava oporapichi vahe yuca ucapa ãgua, iyavei secua rapɨpa ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ipare aipo ehi ambuae güembiguai eta upe: ‘Opa oingatu tembihu mendasave. Co rumo yɨpɨndar ichohoprɨ, ndiya iri chira yugüeru vaherã cohave. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sese peso opacatu ava guata catusa rupi, peñehe mendasave yugüeru vaherã opacatu pe rovaĩchisar upe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Evocoiyase sembiguai eta yuvɨnosepa yuvɨraso ocar rupi. Ahe osovaĩchi vahe setá omonuha yuvɨreco que seco tuprɨ vahe, seco rai vahe avei; ẽgüe ehi ava savapɨpo tuprɨ oɨ guasu mendasave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Evocoiyase acoi mborerecuar oique ava ichohoprɨ repia. Ipare omahecua tuprɨ ñepei ava ipãhu pendar rese. Ahe rumo ndomondei turucuar mendasa resendar. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Evocoiyase aipo ehi chupe: ‘Che mborɨpar, ¿mara ere eique ave co turucuar mendasa resendar porẽhɨ?’ ehi. Ahe rumo noñeheiño ité chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Evocoiyase, ‘Peipɨsɨ co mbɨa, peñapɨchi ipɨ, ipo avei, pemose ocarve pɨ̃tumimbisave. Aheve oyaseho tẽira, sãitere-tere tẽira mbaherasɨcuer rereco’ ehi ichohoprɨ rese hañecosar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Esepia, setá tẽi ichohoprɨ, movɨromi tẽi rumo iporavoprɨ ipãhu sui” ehi mborerecuareta uve. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ipare fariseo oñemonuha, ipɨhañemoñeta yuvɨreco oyeupe Jesús ñehe yavɨ uca ãgua mborerecuar rovai imomara-mara tẽi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ahe evocoiyase omondo movɨro ovoya yuvɨreco mborerecuar Herodes rupindar reseve Jesús upe. Ahese aipo ehi angahu chupe: —Porombohesar, ore oroicua nde supi eté vahe mbahe eremombehu eico iyavei ereporombohe mbahe supi tuprɨ vahe Tũpa recocuer rese. Nde niha ndereroyai vahe ava ñehesa tẽi. Esepia, ava pɨhañemoñeta rupi ndereicoi vahe; nde pɨhañemoñeta rumo ñepei reseve erereco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Mara ehi nde pɨhañemoñeta? ¿Avɨyera pĩha yamondo guarepochi rese oporanduse Roma pendar mborerecuar ɨvate catu vahe upe viña, aní tie? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Oicua rumo fariseo pɨhañemoñeta raisa. Sese aipo ehi chupe: —Pe seco tuprɨ angahu tẽi vahe peico. ¡Mahera che moingue pota mbahe tẽi pɨpe peye! ");
INSERT INTO gyrNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pemboyecua ru ñepei guarepochi mborerecuar guasu upendar cheu —ehi. Evocoiyase güeru yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Ava rahanga vo co guarepochi rese chini iyavei ava rer vo co chini sese no? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Roma pendar mborerecuar guasu —ehiño fariseo yuvɨreco chupe. —Pemondora evocoiyase mborerecuar upe mbahe chupendar, Tũpa upendar mbahe evocoiyase pemondora Tũpa upe —ehi fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Osenduse, oyepɨhamondɨi tẽi yuvɨreco. Evocoiyase yuvɨnose yuvɨraso ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ahe arɨ pɨpe saduceo “ndipoi eté cuerayevɨsa” ehi vahe yugüeru Jesús upe, oporandu tẽi angahu yuvɨreco chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Porombohesar, Moisés aipo ehi aracahe: ‘Que cuimbahe omanose guahɨẽhɨseve, ahese tɨvrɨ omendara sembirecocuer rese ahe vɨquehɨr omano vahecuer upe nara tahɨrã oico’ ehi —ehi yuvɨreco chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Cohave, ore pãhuve, oime siete tuprɨ oyesuindar pãve yuvɨrecoi vahe. Yɨpɨndar vahe omenda. Ipare omanoño guahɨẽhɨseve. Evocoiyase tɨvrɨ omenda sembirecocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ahe omano guahɨẽhɨseve avei no. Ẽgüe ehi avei opacatu ambuae tɨvrɨ, omano avei guahɨẽhɨseve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Opacatu imano pare, cuña avei omano cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Evocoiyase opase ocuerayevɨ yuvɨreco, ¿uma rese ité pĩha opɨtara ahe cuña? Esepia, opacatu niha omenda yuvɨreco sese —ehi saduceo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—Pe pɨhañemoñetasa co cotɨ tẽi eté. Esepia, ndapeicuai eté Tũpa ñehe icuachiaprɨ aracahendar, ndapeicuai avei Tũpa pĩratasa —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Esepia, acoi omano vahe ocuerayevɨse, chupe ndipo iri chira mendasa. Ahe rumo Tũpa rembiguai ɨva pendar nungar yuvɨrecoira ɨvave —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Co cuerayevɨsa resendar rumo amombehura pẽu. Avɨye ndapeyeroquɨi anga vahe acoi Tũpa omombehu vahecuer rese. Supi eté ahe aipo ehi aracahe: ");
INSERT INTO gyrNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Che Abraham, Isaac iyavei Jacob Tũpa aico’ ehi. ¡Tũpa ndahei omano vahecuer Tũpa, ahe rumo oicove vahe ité Tũpa secoi! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","“¡Too!” ehi ava rehɨi. “¡Mara ehi rutei iporombohesa!” ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ipare fariseo oyanduse yuvɨreco Jesús omonguiriripañose saduceo oyesui, ahese oñemonuha yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ñepei ipãhu pendar Moisés porocuaita rese oporombohe vahe, ahe oyemboya oso Jesús rese oporandu ‘toyavɨ oñehe Moisés porocuaita sui yandeu’ oyapave viña: ");
INSERT INTO gyrNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Porombohesar, ¿uma ité vo porocuaita avɨye catu vahe opacatu ambuae porocuaita sui? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Evocoiyase ahe aipo ehi chupe: —‘Eresaɨsura nde Yar Tũpa opacatu nde pɨhañemoñetasa pɨpe, opacatu nde recocuer pɨpe, nde yapɨsacasa pɨpe avei’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Co porocuaita avɨye catu vahe ambuae porocuaita sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Imoñuvɨriosa inungar tuprɨ avei aipo ehi no: ‘Eresaɨsura ambuae ava nde yeaɨsu nungar’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Co ñuvɨrío porocuaita rupi oguata opacatu Moisés porocuaita icuachiaprɨ, opacatu Tũpa ñehe mombehusar rembicuachía avei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo ñemonuha vɨteseve, ");
INSERT INTO gyrNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús oporandu chupe: —¿Mara ehi pepɨhañemoñeta acoi Tũpa Rembiporavo ou vaherã ava pɨ̃sɨro ãgua rese? ¿Ava suindar-ra pĩha secoi? —ehi. —Ahe niha David suindar secoira —ehi fariseo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ahese aipo ehi fariseo upe: —¿Mahera pĩha evocoiyase David oñehese Espíritu pĩratasa pɨpe aracahe, “Che Yar” ehi chupe? Esepia, ahe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Yar aipo ehi che Yar upe: Eguapɨ che acato cotɨ acoi che amondose voi eté nde amotarẽhɨmbar nde povrɨve yuvɨreco’ ehi David aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Evocoiyase, ¿mahera ru: “Poropɨ̃sɨrosar David suindar secoira” peye, David teieté, “Che Yar” ehise chupe? —ehi fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Evocoiyase ndoicatu iri imboyevɨ ãgua yuvɨreco cute. Ahe arɨ pɨpe sui ndipo iri que ñepei iquerẽhɨ vahe iñehe avɨ uca ãgua oñehe pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ipare Jesús aipo ehi ava eta upe, oreu avei no: ");
INSERT INTO gyrNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Co Moisés porocuaita rese oporombohe vahe iyavei fariseo eta, ahe icuaita Moisés porocuaita mombehu tuprɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Sese iya peroyaño ité iyavei peyapo opacatu mbahe semimombehu; aní chira rumo peyapo mbahe sembiapo ai. Esepia, omombehu tuprɨ tẽi mbahe viña, ipare rumo co cotɨ tẽi mbahe oyapo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iyavei omondo porocuaita inungar mbahe ndayasupi catui vahe ava upe ‘tomboavɨye opacatu ité yuvɨreco’ oya. Ahe ae rumo nomboavɨyei eté que ñepei oporocuaita yuvɨreco no. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Oyapo angahu mbahe opacatu ava rembiepiave yuvɨreco yepi ‘tayande repia yuvɨreco’ oyapave tẽi. Osɨva rese, oyɨva rese avei ipe guasu vahe vɨreco-reco tẽi oturucuar rese Tũpa Ñehengagüer cuachiaprɨ yuvɨreco. Iyavei ipɨ catu vahe oturucuar popɨ moaro ãgua omondo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Oipota carusa rupi güenara avɨye catu vahe yuvɨreco, oseca avei tenda porañete catu vahe güenara otũparo pɨpe yuvɨreco no. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Oipota avei ava oyeupe ‘avɨrave’ apo ãgua omboeteisave ocar rupi iyavei oipota, ‘Porombohesar’ oyeupe he yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pe rumo, ‘Porombohesar’ ndapembohe ucai chira ava peyeupe. Esepia, pe opacatu guasu peyeɨvrɨ peico, iyavei ñepeiño ité pereco pe Mbohesar. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iyavei, ‘Che ru’ ndapeyei chira que ava co ɨvɨ pɨpendar tẽi upe. Esepia, ñepeiño ité pe Ru pereco, ahe niha ɨva pendar. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndiyai avei, ‘Mborerecuar’ pembohe uca ava peyeupe. Esepia, Poropɨ̃sɨrosar güeraño ité pe rerecuar secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Acoi ava seco ɨvate catu vahe, ahe toporopɨ̃tɨvɨi güeco mbegüesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Esepia, acoi oyemboɨvate ai vahe opara seco reroyɨsa, iyavei acoi ava seco mbegüe vahe, ahe seco mboɨvate catusara curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Peparaɨsu catu itera pe Moisés porocuaita rese oporombohe vahe iyavei pe fariseo peico vahe, pe seco tuprɨ angahu tẽi vahe peico! Pemombɨtaño ava Tũpa povrɨve seique rãgüer sui peico yepi. Pe avei eté ndapeiquei ipovrɨve, iyavei acoi yuvɨroique pota vahe pemombɨtaño seique rãgüer sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Peparaɨsu catu itera pe Moisés porocuaita rese oporombohe vahe iyavei pe fariseo peico vahe, pe seco tuprɨ angahu tẽi vahe peico! Esepia, perocua-rocuaño tẽi cuña imer mano vahecuer rẽta ichui, ipare peyeroquɨ tuprɨ tẽi angahu ava rembiepiave. Sese peipɨsɨra Tũpa ñemoɨrosa ipĩrata catu vahe curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Peparaɨsu catu itera pe Moisés porocuaita rese oporombohe vahe, pe avei fariseo, pe guata tẽi angahu vahe Tũpa rese! Peguata opacatu ɨvɨ rupi iyavei para guasu rovai rupi ava mbohe. Ipare rumo pe remimbohecuer mbahe tẽi catu pe sui. Pe nungar caruguar ratave nara tẽi pereco uca. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Peparaɨsu catu itera, pe ava mbohesar ndasesapɨsoi vahe nungar peico! Pe aipo peye tẽi vahe: ‘Yamombehuse mbahe tũparo rer pɨpe yande ñehe mboavɨye ãgua, ẽgüe yahe tẽi eté; co rumo yamombehuse mbahe oro tũparo pendar rer pɨpe, ahese iya itera yamboavɨye yepi’ aipo peye tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Pe ndapembahecuai vahe nungar, ndasesapɨsoi vahe nungar avei peico! ¿Uma vo avɨye catu vahe: oro pĩha, anise tũparo tie? Tũparo pɨpe niha oro rovasasa yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iyavei co uve avei aipo peye tẽi peico: ‘Yamombehuse mbahe seropovẽheprɨ renda rer pɨpe yande ñehe mboavɨye ãgua, ẽgüe yahe tẽi eté; co rumo mbahe yamombehuse mbahe seropovẽheprɨ renda harɨ pendar rer pɨpe yande ñehe mboavɨye ãgua, ahese iya ité yamboavɨyera yande ñehe yepi’ aipo peye tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Pe ndasesapɨsoi vahe nungar peico yepi! ¿Uma vo avɨye catu vahe? ¿Evocoi porerecosa seropovẽheprɨ pĩha, anise mbahe seropovẽheprɨ renda tie? Ahe tenda harɨve niha porerecosa sovasasa yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sese acoi mbahe omombehu vahe mbahe seropovẽheprɨ renda rer pɨpe oñehe mboavɨye ãgua, ndahei serer pɨpe güeraño, omombehu avei opacatu iharɨ pendar mbahe seropovẽheprɨ rer pɨpe, ");
INSERT INTO gyrNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","iyavei acoi ava omombehu vahe mbahe tũparo rer pɨpe oñehe mboavɨye ãgua, ahe omombehu ipɨpendar rer pɨpe avei. Ahe niha Tũpa secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Iyavei acoi omombehu vahe mbahe que ambuae ava upe ɨva resendar rer pɨpe oñehe mboavɨye ãgua, omombehu avei Tũpa recua rer pɨpe, Tũpa rer pɨpe avei. Esepia, Tũpa aheve ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Peparaɨsu catu itera, pe Moisés porocuaita rese oporombohe vahe iyavei pe fariseo peico vahe, pe peyapo angahu tẽi vahe pe recocuer pɨpe mbahe peico yepi! Yepe pemondo ñepei-pei diez pe remitɨ menta, anis, comino pereco vahe sui ñepei Tũpa uve nara viña, pe rumo pepoi co porombohesa avɨye catu vahe porocuaita resendar sui. Ahe peyapora mbahe ihɨ̃vi vahe, peporoparaɨsuerecora iyavei pemboavɨye tuprɨra pe cuaita yepi. Iyacatu rumo ahe pemboavɨye aveira viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Pe ava mbohesar ndasesapɨsoi vahe nungar peico! Pe pembogua rutei mbahe rahɨcuer sui pe ɨgua; mbahe tuvicha vahe rumo pemocoño ité evocoiyase. Ẽgüe peye co mborocuaita upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Peparaɨsu itera pe Moisés porocuaita rese oporombohe vahe iyavei pe fariseo peico vahe, pe seco tuprɨ angahu tẽi vahe! Esepia, inungar ɨgua rɨru iyavei tembihu rɨru icupe rupi tẽi yoseiprɨ. Ipɨpe rumo iquɨha opɨtaño ité. Ẽgüe ehi tẽi pe recocuer pe monda raisave, mbahe pota-pota tẽisave avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Pe fariseo peico vahe, ndapepɨhañemoñetai vahe mbahe pe rembiapo ai rese, pemoatɨro rane pe pɨha pɨpe mbahe yavaeté vahe sui! Ahese ramo pe rembiapo icatuprɨra cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Peparaɨsu catu itera, pe Moisés porocuaita rese oporombohe vahe, fariseo peico vahe, peyapo angahu tẽi vahe mbahe pe recocuer pɨpe peico! Pe recocuer inungar tuvɨpa imomorochimbrɨ tẽi. Iharɨve tẽi icatuprɨ chupe. Ipɨpe rumo tehõgüer cangüer iyavei opacatu mbahe yavaeté vahe ovɨreco oyese. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ẽgüe peye: ava rembiepiave avɨye pe reco ihɨ̃vi vahe viña, pe pɨha pɨpe rumo oime pe porombopasa iyavei opacatu mbahe-mbahe tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Peparaɨsu catu itera pe Moisés porocuaita rese oporombohe vahe, pe fariseo peico vahe, pe reco tuprɨ angahu tẽi vahe! Esepia, pemoingatu Tũpa ñehe mombehusar ruvɨpagüer peico sese pe yemomahenduha ãgua iyavei pemoporañete ai tẽi ava seco ihɨ̃vi vahe ruvɨpagüer yepi viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ipare aipo: ‘Yande yaicose revo aracahe yande ramoi recose, ndayaipɨ̃tɨvɨi chietera Tũpa ñehe mombehusar yuca ãgua yuvɨreco viña’ peye tuprɨ tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aipo peyese rumo, pemboyecua Tũpa ñehe mombehusarer yucasar suindar pe yesusa. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Pemboyeapɨ iriño evocoiyase pe ramoi rembiapocuerai! ");
INSERT INTO gyrNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Pe mboi vai suindar tẽi peico! Ndapesoyepei chira rumo Tũpa ñemoɨrosa sui, pesora rumo tata guasuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Evocoiyase che amboura pẽu Tũpa ñehe mombehusar ava yaracua vahe iyavei ava pe mbohe ãgua yuvɨreco viña. Amove rumo ipãhu pendar peyucara, ambuae peyatɨcara curusu rese sereco. Ambuae peinupara pe ñemonuhasa rupi iyavei ambuae peseca-secara peico tecua yacatu rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Sese pẽuño ité oura Tũpa ñemoɨrosa opacatu ava avɨye vahe yuca agüer rese co ɨvɨ pɨpe; Abel seco ɨ̃vi tuprɨ vahe yuca agüer sui, ipare opacatu ambuae saquɨcuerindar ava yuca agüer sui, ipa Berequías rahɨr Zacarías sui avei, ahe peyuca vahe tũparo pɨpe mbahe seropovẽheprɨ renda rovai. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Supi eté opacatu co mbahe tẽi oura pe recove vɨteseve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Too rutei, pe Jerusalén pendar, peyuca vahe Tũpa ñehe mombehusar, ita pɨpe peyapi-yapi ava Tũpa remimbou yepi! ¡Setá rupi che opomonuha pota tẽi pe rereco, inungar tacura omonuha vahe omembrɨ opepovrɨve! Ẽgüe ahe pota tẽi pe rereco viña, pe rumo ndapeipotai eté evocoi nungar pe rereco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sese seyapɨrã tẽi peicora. ");
INSERT INTO gyrNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Esepia, ndache repiai chira peye acoi, ‘¡Imboeteiprɨ Yar remimbou tasecoi!’ peyese voi che repia irira peye” ehi Jesús ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ipare Jesús osẽ judío tũparo pɨpe sui oso. Aheseve ore semimbohe oroyemboya sese aipo orohe chupe: “¡Ore Yar, esepia co tũparo!” orohe. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ahe rumo: —Supi eté amombehu pẽu: co opacatu pesepia vahe, ndipoi chietera que ñepei ita oyeha vɨte vahe. Opacatu ité imondurusara curi —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ipare Jesús oso ɨvɨtrɨ Olivo ve oguapɨ oĩ. Aheve ore güeraño tuprɨ oroso chupe mbahe rese ore porandu ãgua: —Emombehu catu oreu: ¿Mbahese vo aipo mbahe yavɨyera? ¿Mbahe poromondɨisa rese rane vo icuasara nde yu ãgua iyavei arɨ cañɨ ãgua? —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—Peicua catu, peyembopa ucai rene ambuae ava upe peico. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Esepia, setá ava yugüerura, ‘Che aico Tũpa remimbou ava pɨ̃sɨro ãgua’ ehi tẽira ava eta mbopa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Iyavei pesendura ñehesa vavasa resendar cohave iyavei que rupi. Ndapeyembosɨquɨyei chira rumo ichui. Esepia, ẽgüe ehi rane itera niha; ndehi vɨtei chira rumo arɨ cañɨsa. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Esepia, ñepei ɨvɨ pɨpendar ovavara ambuae ɨvɨ pɨpendar rese oyeupe yuvɨreco. Ahese oimera tɨavor, ɨvɨ rɨrɨi opacatu-catu tẽi tecua rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Opacatu evocoi mbahe rumo omboɨpɨ ramomi vahe mbahe tẽi porarasa. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ahese pe pɨsɨra yuvɨreco mara-mara tẽi pe rereco ãgua, pe yuca ãgua avei. Iyavei opacatu ava-ava tẽi ndape ambotai chira che recocuer sui tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ahe arɨ rupi evocoiyase setá ava ndache reroya iri chira yuvɨreco. Ahe oyeamotarẽhɨra iyavei omondora ambuae omboetasagüer yamotarẽhɨmbar povrɨve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Iyavei setá Tũpa ñehe mombehusar angahu tẽi oimera, ahe ava ombopa-mbopa tẽira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ombouvicha catura mbahe-mbahe tẽi naporai vahe. Ipɨpe sui ndoyeaɨsu tuprɨ iri chira ava yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Acoi ava oyemovɨracua vaheño rumo arɨ ipa vahe rupi, ipɨ̃sɨroprɨ yuvɨrecoira. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iyavei co ñehesa icatuprɨ vahe Tũpa mborerecuasa resendar imombehusapa ranera opacatu ɨvɨ rupi icua uca ãgua. Ahese ramo oimera cañɨsa co ɨvɨ pɨpe” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Tũpa ñehe mombehusar Daniel oicuachía mbahe-mbahe tẽi aposa resendar oime vaherã tũparo guasu maranehɨ vahe pɨpe aracahe. Ahe pesepiase oɨ maranehɨ pɨpe —acoi oyeroquɨ vahe, ahe tosenducua tuprɨ yuvɨreco—, ");
INSERT INTO gyrNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","evocoiyase Judea ve yuvɨrecoi vahe toñemipa poyava ɨvɨtrɨ rese yuvɨreco ichui; ");
INSERT INTO gyrNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","iyavei acoi güẽta harɨve yuvɨrecoi vahe ogüeyɨse, toique iri eme güẽtave ombahe reca; ");
INSERT INTO gyrNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","iyavei acoi que rupi tẽi yuvɨrecoi vahe, toyevɨ iri eme güẽtave que oyeaosa renose ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Iparaɨsu itera cuña ipuruha vahe, imembɨ pĩtani vahe avei yuvɨreco! ");
INSERT INTO gyrNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Peporandu Tũpa upe pe recua pɨpe sui pe sẽẽhɨ ãgua irohɨ pɨpe, mbɨtuhusa arɨ pɨpe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Esepia, ahe arɨ pɨpe ava iparaɨsu catura opacatu yɨpɨve ava ɨvɨ apo ramo suive yuvɨrecoi vahe sui. Ipare ndipo iri chietera evocoi nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iyavei nomombɨtuhuise Tũpa co arɨ naporai vahe, ndipoi chietera ava oñepɨsɨro vahe yuvɨreco viña. Ahe rumo güembiporavo raɨsusa pɨpe omombɨtuhura” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Iyavei que ava, ‘Esepia co Poropɨ̃sɨrosar secoi’; anise, ‘Peve secoi’ ehise yuvɨreco pẽu, aní chira peroya aipo ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Esepia, yugüerura ava ‘che Poropɨ̃sɨrosar aico’ ehi tẽi vahe iyavei ‘che amombehu vahe Tũpa Ñehengagüer’ ehi angahu tẽi vahe; iyavei oyapora mbahe ava ndoyapoi vahe poromondɨisa güeco pĩratasa mboyecua ãgua yuvɨreco. Ipɨpe osecoãhara Tũpa rembiporavo imbopa ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Opa aipo co senondeve amombehu pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Sese que ava pẽu: ‘Pesepia pe ɨvɨ iporupɨrẽhɨsave secoi’ ehise, pesoi rene aheve seroyasave, aní chiaveira peroya acoi ‘pesepia co secoi oɨ pɨpe’ ehi vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Che rumo inungar overa vahe sendɨ añihivei sui caharu cotɨ ocua ɨva rese, ẽgüe ahera che, Ava Rɨquehɨr, opacatu ava rembiepiave ayevɨ irise vitu curi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Esepia, mbahe rehõgüer reimesave, uruvu oñemonuha atɨ yuvɨreco yepi” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ahe arɨ pɨpe mbahe-mbahe tẽi pare cũriteimi ndoyecua iri chira arɨ, yasɨ avei ndosesape iri chira, yasɨtata avei opara ovɨapi ɨva sui iyavei ɨva resendar mbahe orɨrɨira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ahese oimera ɨva rese iporẽhɨ vahe che, Ava Rɨquehɨr, yu ãgua resendar. Evocoiyase opacatu ava-ava tẽi co ɨvɨ pɨpendar oyaseho tẽira osɨquɨyepave yuvɨreco. Che repia aveira yuvɨreco agüeyɨse ɨva quɨha rese che pĩratasa rendɨgüer porañetesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iyavei amboura che rembiguai eta ɨva pendar. Ahe evocoiyase güemimbɨ omoñehe pĩratara opacatu che rembiporavo co ɨvɨ rupindar que amombrɨ rupi yuvɨrecoi vahe monuha ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Peyembohera ɨvɨra higuera recocuer sui: Co ɨvɨra soquɨ ramose, yaicua cõimi arɨ sacu vahe yepota ãgua yandeu yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na ehi aveira pẽu che ñehe rupi tuprɨ mbahe pesepiase, sese peicuara cõimi eté che yevɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Supi eté yuvɨrecove vɨtera ava osepia vahe co mbahe opase yavɨye. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ɨva, ɨvɨ opara ocañɨ, che ñehengagüer rumo imboavɨyesa rane itera. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ndipoi eté rumo ava oicua vahe arɨ iyavei hora che yevɨ ãgua. Ɨva pendar che Ru rembiguai avei ndoicuai yuvɨreco. Che avei ndaicuai eté. Che Ru güeraño ité rumo oicua. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Inungar ava Noé recose yuvɨrecoi aracahe, ẽgüe ehi tuprɨ aveira che, Ava Rɨquehɨr, yevɨ ãgua renonde. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Yɨpɨve amarusu renonde, ahese ava ocaru, oɨhu; guahɨr, guayrɨ avei omomendaño yuvɨreco. Noé arca pɨpe seiquese, ẽgüe ehi vɨte yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Nomohai eté rumo amarusu vɨapi ãgua yuvɨreco oyeupe viña, ẽgüe ehi rumo avɨyeteramo tẽi amar ovɨapi imocañɨpa. Ẽgüe ahe aveira che, Ava Rɨquehɨr, ayevɨ avɨyeteramo tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Evocoi arɨ pɨpe oimera ñuvɨrío ava amombrɨ güecua sui yuvɨrecoi vahe: ñepei serasosara, indugüer rumo opɨtara. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ẽgüe ehi aveira ñuvɨrío cuña ohɨcho vahe upe: ñepei serasosara, indugüer rumo opɨtara. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Sese pemahemoha yepi. Esepia, ndapeicuai mbahe arɨ pɨpe che, pe Yar, ayevɨra ɨva sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Iyavei peyapɨsaca tuprɨ co rese: inungar acoi oɨ yar oicuase revo que hora pɨ̃tu pɨpe imonda vahe yepota ãgua, ahese imahemohara sese güẽta pɨpe seiqueẽhɨ ãgua viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ẽgüe peye aveira peyemoingatu che yevɨ ãgua rese. Esepia niha, che, Ava Rɨquehɨr, aporoesapɨha tẽira vitu curi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Acoi ava mbahe rese ñangarecuar omboavɨye tuprɨ vahe ocuaita, yaracua vahe avei, ahe chupe serecuar oseya icuaitarã güẽta pɨpendar rese hañeco ãgua ‘tembihu tomondo che rẽta pɨpendar upe che porocuaita rupi’ ohesave. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Acoi omboavɨyese ocuaita, ahese ovɨharetera güerecuar yevɨse. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Supi eté niha serecuar oyocuaira opacatu ombahe rese hañeco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ahe mbiguai rumo ndipɨhaise ‘ndoyepota vɨtei chira revo che rerecuar’ oya, ");
INSERT INTO gyrNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","omboetasa omboɨpɨ mara-mara tẽi sereco iyavei oyemboya caguar tẽi rese ipɨri ocaru iyavei oɨhu tẽi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ipare rumo serecuar oyepotara imahemohaẽhɨseve. ");
INSERT INTO gyrNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ahese omombaraɨsu catura, ‘Tinupasa, ava seco tuprɨ ai angahu tẽi vahe nupasa nungar pɨpe’ ehira chupe. Ahese oyaseho tẽira, oyemoaitere-tere tẽi aveira” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Evocoi arɨ pɨpe Tũpa mborerecuasa inungar-ra mendasave diez cuñatai ndaseco marai vahe vɨrasora tataendɨ ambuae cuña mevɨ pɨsɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ipãhuve yuvɨrecove cinco ndipɨhañemoñetai vahe, ambuae cinco rumo ipɨhañemoñeta tuprɨ vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ipare ndipɨhañemoñetai vahe oipɨsɨ guataendɨrã yuvɨreco, ndovɨrasoi rumo yandɨ guataendɨ rɨru mboapɨpo iri ãgua yuvɨreco; ");
INSERT INTO gyrNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","evocoi ipɨhañemoñeta tuprɨ vahe rumo vɨraso yandɨ sɨru pɨpe guataendɨ reseve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Acoi ndoyepota apɨhaise cuña mevɨ, ahese sopesɨi tẽi yuvɨreco. Coiye opaño yuvɨroque yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pɨ̃tu mbɨter senise rumo, osendu ñehesa aipo ehi vahe yuvɨreco: ‘¡Coi imevɨ turi! ¡Pesẽ ipɨsɨ ãgua cute!’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Evocoiyase opacatu evocoi cuñatai oñarapuha voi iyavei omoingatu guataendɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ahese nimahemohai vahe aipo ehi ambuae imahemoha vahe upe yuvɨreco: ‘Pemboumi tẽi chĩhi pe yandɨ oreu. Esepia, ogüe pota ité ore rataendɨ’ ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Aní, ndiyai chira revo oromondo vaherã pẽu. Iyacatu revo peso imboepɨsave serocua peyeupe nara’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Imboepɨ yuvɨraso vɨteseve, ou cuña mevɨ cute. Oyemoingatu vahe rumo yuvɨroique supi mendasave. Evocoiyase saquɨcuerive voi omboya oquenda rãrosar. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ipare oyepotase ambuae cinco cuñatai yugüeru aipo ehi yuvɨreco oɨ yar upe: ‘¡Emboimi tẽi oreu!’ ehi tẽi yuvɨnoha. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Aní, ndopocuai vahe ité’ ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Pe evocoiyase pemahemohara. Esepia, ndapeicuai mbahe arɨ pɨpe, mbahe hora pɨpe che, Ava Rɨquehɨr, ayevɨra” ehi Jesús oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Iyavei Tũpa omborerecuasave inungar-ra ava mbahe yar oso ãgua renonde ɨvɨ amombrɨsave omonuha güembiguai oguarepochi rãro ãgua viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yɨpɨndar ñepei upe omondo cinco mil guarepochi, ambuae upe omondo dos mil, iyavei imombosapɨsa upe omondo mil tẽi: ahe omondo ñepei-pei upe seco etegüer rupi-rupi. Ipare voi oso cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Evocoiyase evocoi mbiguai oipɨsɨ vahe cinco mil guarepochi, ahe oporavɨquɨ co guarepochi rese. Ipɨpe sui coiye oipɨsɨ catu iri ambuae cinco. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Inungar avei ambuae oipɨsɨ vahe dos mil, ichui oipɨsɨ catu iri ambuae dos mil. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ambuae oipɨsɨ vahe rumo ñepei guarepochi, ahe oyoho ɨvɨcuar. Aheve oñotɨ güerecuar guarepochi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ipare coiye oyevɨse serecuar, ahese oñehe güembiguai upe oguarepochi retacuer cua ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Yɨpɨndar cinco mil guarepochi oipɨsɨ vahe ranengatu oyemboya güerecuar rese aipo ehi: ‘Ndo co acoi erembou vahe cinco mil cheu, ichui co ambuae cinco aipɨsɨ irimi ndeu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Avɨye ité, nde mbiguai seco avɨye vahe ereico iyavei eremboavɨye tuprɨ vahe nde cuaita co movɨro tẽi guarepochi ndeu amondo vahe pɨpe. Sese tuvicha catu amondora nde cuaitarã. Indó, eique che pɨri, yayembovɨhara che rese’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ipare ambuae sembiguai oipɨsɨ vahe dos mil guarepochi, oyemboya güerecuar rese aipo ehi chupe: ‘Ndo co erembou vahe dos mil cheu. Ipɨpe sui co ambuae aipɨsɨ irimi dos mil avei ndeu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Avɨye ité, nde mbiguai seco avɨye vahe, eremboavɨye tuprɨ vahe nde cuaita co movɨro tẽi guarepochi ndeu amondo vahe pɨpe. Sese tuvicha catu amondora nde cuaitarã. Indó, eique che pɨri, yayembovɨhara che rese’ ehi avei chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ipare acoi oyepotase ambuae mbiguai oipɨsɨ vahe mil guarepochi, ahe aipo ehi güerecuar upe: ‘Che aicua nde reco; nde acoi ndihavai vahe ereico. Esepia, ava remitɨgüer tẽi eremonuha iyavei imbovevepɨrer tẽi avei ereipɨsɨ ndeyeupe nara. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Sese che sɨquɨyesa pɨpe añomi ɨvɨvrɨve nde guarepochi. Ndo co nde mbahe’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Nde mbiguai ndaseco põrai vahe, yangaipa vai vahe avei ereico. Nde niha ereicua che recocuer aipɨsɨse mbahe nañotɨi vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ereyapocatumira che guarepochi guarepochi apocatusave cuese rahe viña che yevɨse voi senose ãgua cheu imboyevɨ catumi ãgua viña’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ipare aipo ehi: ‘Perocua guarepochi ichui, pemondora evocoi diez rupi guarepochi omboeta vahe upe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","‘Indó, acoi vɨreco vahe mbahe, chupe imondosa catura, sumbɨre aveira; acoi ndovɨrecoi vahe rumo mbahe, opaño itera serocuasa mbahe sembierecomi ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Sese pemose co mbiguai ẽgüe ehi tẽi vahe ocarve pɨ̃tumimbisave. Aheve toyaseho, tasãitere tẽi oĩ’ ehira serecuar chupe” ehi Jesús oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Che, Ava Rɨquehɨr, ayevɨse, opacatu che Ru rembiguai ɨva pendar reseve che reco ɨvategüer pɨpe, ahese aguapɨra che renda porañete vahesave ava recocuer rese porandu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Evocoiyase ava opacatu tecua rupindar imonuhasara che rovai yuvɨreco. Ahese aipehara ava oyesui, inungar ovesa rãrosar oipeha vahe ovesa cavara sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Che evocoiyase ovesa aipehara mbahe rese che pocosa cotɨ, cavara mbahe rese che pocoẽhɨsa cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ahese che mborerecuar ɨvate catu vahe aipo ahera che acato cotɨndar upe: ‘Perio pe opacatu che Ru sui sovasaprɨ peico vahe, peique che Ru mborerecuasa pɨpe; ahe acoi yɨpɨve ɨvɨ apo ramo suive imoingatuprɨ pẽu nara. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Esepia, ndacherɨepoise, pe evocoiyase pembou mbahe che remihura; iyavei che huseise, pe evocoiyase pembou taɨhu; che aguata tẽise pe recua rupi vichico, pe avei oɨ pembou che que ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Turucuar cheu ipanese, pe avei pembou che turucuarã; chembaheasɨse, peso avei che pɨri; che roquendasave peso avei che repia no’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Evocoiyase evocoi seco catuprɨ vahe aipo ehira yuvɨreco cheu: ‘Ore Yar, ¿mbahese vo nde repiasa nanderɨepoise eico iyavei imondosa nde remihura? ¿Mbahese vo nde repiasa ndehuseise, ipare imondosa tereɨhu? ");
INSERT INTO gyrNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mbahese vo nde repiasa nde guatase ore recua rupi, ipare nde monguesa ore pɨri, ipanese nde turucuarã, ore aipo evocoiyase oromondo ndeu? ");
INSERT INTO gyrNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Iyavei, ¿mbahese vo aipo nde repiasa nembaheasɨse, anise que nde roquendasave, aheve aipo oroso nde repia yepi?’ ehira yuvɨreco cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Evocoiyase che, mborerecuar ɨvate vahe, amboyevɨra yuvɨreco chupe aipo ahera: ‘Supi eté, opacatu mbahe peyapose que ñepei seco mbegüemi vahe che reroyasar pãhu pendar upe viña, cheu rumo ẽgüe peye’ ahera. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ahese aipo ahera cute che mbahe rese pocoẽhɨsa cotɨndar upe: ‘Pesɨrɨ che sui. Esepia, pe peico Tũpa ñemoɨrosavrɨ pendar. Pesopa tata guasu apɨrẽhɨsave, evocoi imoingatuprɨ opacatu caruguar upe nara serecuar reseve. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Esepia, ndacherɨepoise, pe evocoiyase: Yamondomi icaru ãgua, ndapeyei eté cheu; che huseise, ahese, Yamondomi toɨhu, ndapeyei avei cheu; ");
INSERT INTO gyrNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ambuae tecua pɨpe aguata tẽise vichico, ahese, Eique che rẽtave che pɨri, ndapeyei eté cheu. Ipanese che turucuarã, pe rumo ndapemboui cheu, chembaheasɨse vichico, iyavei che roquendasave, Yasomi tẽi sepia, ndapeyei eté cheu’ ahera. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Ore Yar, ¿marase vo aipo nde repiasa nanderɨepoise, anise aipo nde huseise, ipanese nde turucuarã ndeu no, nembaheasɨse, anise nde roquendasave, marase vo mbahe rese nande pɨ̃tɨvɨisai?’ ehi tẽira yuvɨreco cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Supi eté acoi amove mbahe ndapeyapoise que seco mbegüemi vahe upe viña. Ipɨpe rumo cheu avei mbahe ndapeyapoi eté’ ahera. ");
INSERT INTO gyrNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ahe ava yuvɨrasora Tũpa ñemoɨrosa apɨrẽhɨ vahesave. Seco ɨ̃vi vahe rumo teco orɨ opaẽhɨsave yuvɨrasora” ehi Jesús oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ipare Jesús aipo ehi oreu: ");
INSERT INTO gyrNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pe peicua ñuvɨrío arɨ tẽi ipane vɨte co Pascua pieta yepota ãgua yandeu. Ahese che, Ava Rɨquehɨr, imondoprɨ aicora che atɨca ãgua curusu rese yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ahe pɨpeve avei Jerusalén ve, co pahi rerecuareta, iyavei judío rerecuareta oñemonuha yuvɨreco pahi rerecuar ɨvate catu vahe Caifás rẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aheve oñemoñeta: ‘Yambopa ipɨsɨ yuca ãgua’ ehi yuvɨreco oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ahe rumo: —Ndiyai pieta pɨpe ité yaipɨsɨ ava rehɨi yemondɨi guasuẽhɨ ãgua yandeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús tecua Betania ve secoi, Simón lepra vɨreco vahecuer rẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aheve mesave chiniseve, cuña vɨreco vahe mbahe sɨ̃acuá vahe sɨru reseve vɨroyepota chupe. Ahe oipɨyere Jesús ãca rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Orosepiase rumo oroñemoɨro aipo orohe oreyeupe: —¡Mahera vo co omocañɨ tẽi! ");
INSERT INTO gyrNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Omondo vahe ité tie co setá guarepochi rupi ava iparaɨsu vahe pɨ̃tɨvɨi ãgua viña —orohe tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús rumo oicua ore pɨhañemoñetasa. Sese aipo ehi oreu: —¡Mahera vo co cuña pemañeco tẽi! Esepia, co mbahe oyapo vahe avɨye ité cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ava iparaɨsu vahe niha yuvɨrecoiño itera pe pãhuve. Che rumo ẽgüe ndahe vɨteñoi chira vichico pe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Esepia, co cuña oipɨyere mbahe sɨ̃acuá vahe che rese che tɨ̃ ãgua renondeve. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Supi eté aipo ahe pẽu: co ñehesa pɨ̃sɨrosa resendar mombehuse opacatu tecua rupi, imombehusa aveira co cuña rembiapo sese mahenduha ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ipare ñepei ore pãhu pendar, Judas Iscariote, oso, oñehe pahi eta rerecuar yuvɨrecoi vahe upe ");
INSERT INTO gyrNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aipo ehi: —¿Mbovɨ rupi vo pemboepɨra cheu amondose Jesús pẽu viña? —ehi. “Treinta guarepochi rupi” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ahesa reseve voi oseca Jesús mondo ãgua yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Arɨ yɨpɨndar vahe pieta resendar, pan ndayapepoi vahe husa pɨpe, ahese ore Jesús remimbohe oroico vahe oroyemboya sese aipo orohe: —¿Que vo ereipota oromoingatura carusa Pascua pieta resendar yandeu? —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Evocoiyase, —Peso tecua guasuve che cua vahe rẽtave aipo peyera chupe: ‘Ore Mbohesar aipo ehi: Cõimi che mano ãgua, sese ayapo potami sẽtave Pascua pieta che remimbohe reseve, ehi ndeu’ peyera chupe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Evocoiyase oyapo semimombehu rupi tuprɨ ité yuvɨreco, omoingatu carusa Pascua pieta resendar yuvɨreco aheve. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Pɨ̃tu ramomise, opacatu oroguapɨ mesave Jesús pɨri ore caru ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ore carusave aipo ehi oreu: —Supi eté aipo ahe pẽu: ñepei pe pãhu pendar che mondora che amotarẽhɨsar upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","—Che Yar, ¿che pĩha? —orohe-rohe tẽi ñepei-pei ore yacatu ore vɨharẽhɨsa pɨpe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Omondo vahe opo che caro pɨpe, ahe che mondora che amotarẽhɨsar upe —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Imboavɨyesa itera che, Ava Rɨquehɨr, rese ñehesa icuachiaprɨ. ¡Iparaɨsu catura rumo acoi mbɨa che mondosar! Avɨye catura ndoyesuise viña —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ahese Judas imondosavɨ oporandu: —Ore Mbohesar, ¿che tie? —ehi. —Taa, ¡nde ité niha ẽgüe erera! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ore caru vɨteseve, Jesús oipɨsɨ pan, “Avɨye ndeu” ehi Vu upe. Aipo ohe pare, ombohi-mbohi oreu imondo, aipo ehi: —Ndo co, pehu co che rete —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ipare oipɨsɨ ɨgua rɨru, “Avɨye ndeu” ehi Vu upe. Aipo ohe pare ombou oreu aipo ehi: —Peɨhu peyacatu co sui. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Esepia, co che ruvɨ, ahe omoimera che Ru remimbotar ipɨasu vahe pẽu, ahe oyepɨyerera ava rehɨi angaipa rese ñero ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndaɨhu iri chira uva rɨcuer cheu arɨ oyepotase voi che Ru mborerecuasave aɨhura pe rese ambuae uva rɨcuer ipɨasu vahe —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ore sapucaire, oroso ɨvɨtrɨ Olivo ve. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Evocoiyase Jesús aipo ehi oreu: —Opara pemocañɨ che rese yeroyasa peyesui co pɨ̃tu pɨpe. Esepia, acoi icuachiaprɨ pɨpe aipo ehi: ‘Ayucara ovesa rãrosar, ahese oñemosai tẽira ovesa opacatu rupi yuvɨreco’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Che cuerayevɨre rumo, aso voi etera pe renonera Galilea ve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro rumo, —Yepe ambuae opacatu nande reroya iri chira yuvɨreco, che rumo ndayepepɨi chietera nde sui —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Che rumo supi eté aipo ahe ndeu: co pɨ̃tu pɨpeve voi eté tacura ñehe renondeve, “Ndaicuai vahe ité aipo mbɨa” erera mbosapɨ oyupagüer rupi cheu —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro rumo, —Yepe amanora nde rupi viña, che rumo, “Ndaicuai vahe aipo mbɨa” ndahei chietera —ehi-ehi catuño ité chupe. Aipo orohe pãve tuprɨ tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ipare Jesús rupi orosoño Getsemaní ve. Aheve aipo ehi oreu: —Peguapɨ cohave; che aso ranera peve catumi, ayeroquɨ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aheve vɨraso Pedro oyeupi iyavei ñuvɨrío Zebedeo rahɨr. Ahese oyandu ovɨharẽhɨsa oico. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Evocoiyase ahe aipo ehi chupe: —Ndavɨhai eté. Esepia, che hã oyandu ité manosa. Pepɨta rane cohave iyavei pemahemohara pe yeroquɨ pɨpe che rese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Evocoiyase oso tenonde catumi. Aheve oñenopɨha ovapɨ ɨvɨ rese oyeroquɨ Vu upe aipo ehi: “Che Ru, iyase ndeu che renose mbahe-mbahe tẽi sui eve; tayapo eme ru che remimbotar tẽi, nde remimbotar rupi catu tayapo” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ipare oyevɨ güemimbohe upe. Ahe rumo opaño yuvɨroque yuvɨrocua. Ahese aipo ehi Pedro upe: —¡Ndapeñemosai eté vo pe ropesɨi upe che rãro ãgua que ñepei hora che mondugüe ãgua peye! ");
INSERT INTO gyrNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pemahemoha, peyeroquɨ mbahe tẽi pɨpe pe vɨapiẽhɨ ãgua. Supi eté pequerẽhɨ ité viña, pe retecuer tẽi niha nipiratai pẽu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ichui imoñuvɨriosa rupi oso iri oyeroquɨ aipo ehi: “Che Ru, ereipotase che reique ãgua co mbahe tẽi pɨpe, eyapo nde remimbotar che rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ipare oyevɨse, osesapɨha iri iqueseve ou. Esepia, sopesɨi nomboyeroyai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Evocoiyase oseyapa iri oso oyeroquɨ ãgua imombosapɨsa rupi. Aipo ehi tuprɨño avei oyeroquɨ Vu upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ipare oyevɨ iri güemimbohe upe aipo ehi chupe no: —¡Pequeño vɨte vo peyu! Osupitɨ che, Ava Rɨquehɨr, mondo ãgua ava yangaipa vahe povrɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pepũha, yaso. Esepia, cõimi eté che amotarẽhɨsar upe che mondo vaherã secoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ñehe vɨteseve, Judas oyepota oso chupe. Ahe ñepei semimbohe ore pãhu pendar, iyavei setá iteanga ava yugüeru quɨse pucu, ɨvɨra reseve-seve supi. Ahe pahi eta rerecuar yuvɨrecoi vahe judío rerecuareta porocuaita rupi oyapo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yɨpɨndar rumo imondosar Judas aipo ehi: “Asovaupɨtese, ahese peicuara; ahe peipɨsɨra” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ipare oyemboya voi oso sese. —¡Avɨrave, Porombohesar! —ehi sovaupɨte. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—Che mborɨpar —ehi Jesús—, eyapoño mbahe nde remimbotar cheu —ehi. Aheseve voi oipɨsɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Evocoiyase semimbohe secoi vahe supi vɨnose oquɨse pucu, oyasɨa pahi rerecuar ɨvate catu vahe rembiguai nambi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—¡Aní! —ehi güemimbohe upe—. Emoingue sɨru pɨpe nde quɨse pucu. Esepia, acoi ava opacatu ovava vahe oquɨse pɨpe yuvɨreco, ipɨpe avei opara yucasa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ndereicuai vo aporanduse che Ru uve viña, ahe evocoiyase cũritei voi omboura doce mil sui setá catu vahe güembiguai che repɨ ãgua viña? ");
INSERT INTO gyrNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ẽgüe ehise rumo Tũpa Ñehengagüer icuachiaprɨ ndayavɨyei chietera viña, ahe co cũritei osupitɨ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ahese aipo ehi ava rehɨi upe: —Pe quɨse pucu, ɨvɨra reseve-seve rutei co peyu che ropeña che pɨsɨ ãgua imonda rai vahe nungar che rereco peye. Che arɨ yacatu rupi aguapɨse pe pãhuve pe mbohe ãgua tũparo pɨpe, ndapeyapoi eté co nungar cheu. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Co rumo opacatu ẽgüe peye Tũpa ñehe mombehusar rembicuachiagüer mboavɨye ãgua cute —ehi ava rehɨi upe. Ahese voi opacatu oroñemosaipa, oroseya ahe aetemi Jesús ava rehɨi upe imoha. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ahese Jesús pɨsɨsar vɨraso Caifás rẽtave yuvɨreco, ahe pahi rerecuar ɨvate catu vahe secoi. Aheve oñemonuha Moisés porocuaita rese oporombohe vahe, judío rerecuar yuvɨrecoi vahe avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro rumo amombrɨ rupive tẽi osaquɨcue moña oso. Ẽgüe ehi oyepota pahi rerecuar ɨvate catu vahe rẽta rocar ãchisave. Aheve oique ipɨpe, iyavei oguapɨ oĩ sundao pãhuve ‘¿mara ehi etera pĩha sereco yuvɨreco?’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ahese pahi eta rerecuar iyavei opacatu porandusa ɨvate catu vahe pendar, ahe oñehengapo-ngapo uca tẽi ava Jesús amotarẽhɨsave yuca uca ãgua yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","yepe oyemboyecua setá iteanga yamotarẽhɨsar semira-mira tẽi vahe yuvɨreco viña, ndoyosui eté rumo mbahe sembiapo naporai vahe yuca uca ãgua yuvɨreco. Aheseve yugüeru ñuvɨrío yamotarẽhɨsar oporombopa-mbopa tẽi vahe yuvɨreco cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Co mbɨa aipo ehi: ‘Che aicatu co tũparo monduru; aicatu aveira imopuha iri mbosapɨ arɨ rupi’ ehi —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ahese pahi rerecuar ɨvate catu vahe opũha, oporandu Jesús upe: —¿Mahera vo nderemboyevɨi eté iñehe yuvɨreco chupe? ¿Mbahe ehi vo aipo nde amotarẽhɨsar nde rese oñehe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Noñehei eté rumo. Ahese, —Che orocuai Tũpa supi eté vahe rer pɨpe emombehu oreu: ¿Poropɨ̃sɨrosar ité nde ereico, Tũpa Rahɨr? —ehi pahi rerecuar ɨvate catu vahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Taa, supi eté niha aipo aipo ere cheu, co catu amombehura pẽu, che repiara niha peye che, Ava Rɨquehɨr, aguapɨse Tũpa mbahe mboavaisarẽhɨ acato cotɨ, ayevɨse avei ɨva quɨha rese curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Evocoiyase pahi rerecuar ɨvate catu vahe imboasɨpave omondoro oturucuar aipo ehi: —¡Indó, mbahe tẽi eté iñehe Tũpa upe! ¡Mbahe iri vo yaipota vɨte yaico! Yasendupa niha aipo Tũpa upe iñehe-ñehe tẽisa cũritei. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Mara ehi aipo pe pɨhave? —ehi. —Supi eté, oyavɨ mbahe. ¡Tomanoño ité! —ehiño ivoya eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ahese ondɨvɨ-ndɨvɨ sova rese iyavei yuvɨrocua-rocua yuvɨreco sese. Ambuae osovapete-pete, ");
INSERT INTO gyrNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","aipo ehi yuvɨreco chupe: —Nde niha aipo ereico Tũpa remimbou Poropɨ̃sɨrosar, ¿eicua ité ru, ava evocoi ocua nde rese? —ehi yoyai catu-catu yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro evocoiyase oguapɨ sãro ocarve ñachimbrɨ pɨpe oĩ. Aheve oyemboya cuña mbiguai oso sese aipo ehi chupe: —Nde avei Jesús Galilea pendar rupindar ereico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ahe rumo aipo ehiño opacatu ava rovaque: —Ndaicuai aipo nde ñehesa —ehiño cuña mbiguai upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ichui oso oquendɨpɨve. Aheve omahe ambuae cuña sese. Ahe sepiase aipo ehi ava ahe pendar yuvɨrecoi vahe upe imombehu: —Co ava avei acoi secoi Jesús Nazaret pendar rupi yepi —ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—¡Aní! —ehi iri ahe cuña upe—. ¡Tũpa oicua, supi eté ndaicuai aipo mbɨa! —ehi angahu tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Iparemi tẽi aheve yuvɨrecoi vahe, oyemboya sese aipo ehi yuvɨreco chupe: —Nde avei eté niha supindar ereico. Esepia, nde ñehe pãrigüer rese nde cuasaño —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ahe evocoiyase, ¡Tũpa niha oicua ndopombopai eté niha! ¡Che ndaicuai vahe ité evocoi mbɨa, ahe mo aipo pẽu! —ehi angahu tẽi chupe. Aipo iheseve, tacura oñehe. ");
INSERT INTO gyrNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ahese Pedro oyemomahenduha Jesús oyeupe, ‘Acoi tacura ñehe renondeve mbosapɨ oyupagüer rupi: Ndaicuai vahe ité aipo mbɨa, erera cheu’ ihe agüer rese. Ahese osẽ, oyasehó iteanga oso. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Cõhe ramose, ahese opacatu pahi eta rerecuar, judío rerecuar avei oñemonuha atɨ oyemboyoya guasu ‘Jesús tayucasa ité’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ipare oipocua-pocua seraso mborerecuar guasu Pilato upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, acoi Jesús omondo vahe yamotarẽhɨsar uve oicua, “Jesús tayucasa cute” ehise, ahese tasɨ́ iteanga chupe. Evocoiyase oso voi tẽi tũparo guasuve pahi eta rerecuar yuvɨrecoi vahe upe iyavei judío rerecuareta upe treinta guarepochi mboyevɨ ãgua aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Che ayemboangaipa tiẽte vichico. Esepia, amondoño tẽi mbɨa seco catuprɨ vahe pẽu yuca uca ãgua —ehi mborerecuareta upe. —Mara etemo ore orovɨreco. ¡Nde remimbotar niha! —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Evocoiyase opaño guarepochi omombó tũparo pɨpe. Ichui voi oso oyemboyaseco, oyeyuca. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pahi eta rerecuar rumo omonuhase guarepochi aipo ehi yuvɨreco oyeupe: —Ndiyai rumo yamondo co guarepochi porerecosa rɨru pɨpe. Esepia, ava yucapɨrã reprɨ tẽi —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ipare oyoya guasu ipɨhañemoñeta yuvɨreco co guarepochi rese ñaɨhu rese oporavɨquɨ vahe ɨvɨ rerocua ãgua ‘toime ava secua ambuae vahe rehõgüer tɨ̃ ãgua’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sese cũritei co ɨvɨ upe, “Ava ruvɨ reprɨ tẽi” ehi yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ẽgüe ehi co imboavɨye ité Tũpa ñehe mombehusar Jeremías remimombehugüer aipo ehi vahe: “Oipɨsɨpa treinta guarepochi yuvɨreco, ahe ava Israel suindar mborerecuar remimombehugüer rupi eté evocoi mbɨa pɨsɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ipɨpe vɨrocua ñaɨhu rese oporavɨquɨ vahe ɨvɨ yuvɨreco. Cheu che Yar omombehu vahecuer rupi tuprɨ ité oyapo yuvɨreco” ehi Tũpa ñehe mombehusar aracahendar. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús serasosa mborerecuar Pilato upe, ahese Pilato oporandu chupe: —¿Nde ité vo judío rerecuar ɨvate catu vahe ereico? —ehi. —Nde niha aipo, ‘Ahe ereico’ ere cheu —ehiño imboyevɨ Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Evocoiyase acoi pahi eta rerecuar iyavei judío rerecuareta oñemonuha vahe eipeve oiñehengapo-ngapo tẽi yuvɨreco. Nomboyevɨi eté rumo iñehe chupe oyeepɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Evocoiyase: —¿Nderesendui vo aipo co opacatu ndeu ñehe-ñehe tẽisa? —ehi Pilato chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Nomboyevɨi eté rumo que ñepei angara ñehesa chupe viña. “¡Too, mara ehi rutei vo co!” ehi-ehi tẽi mborerecuar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Mborerecuar guasu recosa ité ñepei ava soquendaprɨ renose ãgua Pascua pieta pɨpe ava rehɨi remimbotar rupi yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Aheve oime soquendaprɨ mbɨa icuaprɨ vahe ité Barrabás serer vahe; ");
INSERT INTO gyrNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","evocoiyase ava rehɨi oñemonuha atɨse, Pilato oporandu chupe yuvɨreco: —¿Uma peipota che amose ucara pẽu: Barrabás pĩha, anise Jesús “Poropɨ̃sɨrosar” ehi vahe yuvɨreco chupe tie? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Esepia, ahe oicuaño ité ava rese yemoecatẽhɨsa pɨpe sui imondoprɨ secoise. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato güendave chini vɨteseve, sembireco omondo oñehe chupe aipo ehi: “Ereyapoi rene mbahe evocoi ava seco catuprɨ vahe upe. Esepia, che querve asepia mbahe tẽi eté sesendar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Evocoi pahi eta rerecuar iyavei judío rerecuareta rumo ava rehɨi omonguerẽhɨ, “Barrabás tosẽ; Jesús evocoiyase tomano” he ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Evocoiyase Pilato oporandu iri ava rehɨi upe: —¿Uma peipota catu co ñuvɨrío yuvɨrecoi vahe sui amose vaherã pẽu? —ehi. —¡Barrabás tosẽ! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Mbahe vo evocoiyase che ayapora Jesús rese chupe acoi ava, “Poropɨ̃sɨrosar” ehi yuvɨreco? —ehi. —¡Tayatɨcasa curusu rese! —ehi atɨ-atɨño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Mbahe ité vo oyapo naporai vahe? —ehi tẽi ava rehɨi upe. Ahe rumo: —¡Tayatɨcasa ité curusu rese! —ehi atɨ-atɨ iriño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Evocoiyase Pilato: “Ndaicatui mbahe moingatu sepɨ ãgua” ehi tẽi oyeupe. Sese ava yaɨvu guasu catu-catu irise, ogüeru uca ɨ. Ipɨpe oyepoi opacatu ava rehɨi rovaque aipo ehi: —Ndahei che remimbotar rupi co mbɨa yucasara; pe remimbotar rupi eté —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—¡Ore rese ité, ore rahɨr rese avei tovɨapi que mbahe tẽi co mbɨa mano sui! —ehi atɨño ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ahese Pilato omose uca Barrabás; Jesús rumo oinupá iteanga uca tucumbo tupeicha nungar pɨpe imondo curusu rese yatɨca ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Evocoiyase mborerecuar sundao vɨroique Jesús ambuae oɨ pɨpe. Aheve opacatu omboetasa omboyere tuprɨ uca sese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ahese osequɨipa iturucuar ichui. Ipare omonde turucuar pĩra vahe yuvɨreco sese ");
INSERT INTO gyrNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","iyavei omonde ñaca rese yu pɨaprɨ, omondo avei ñepei tacuarmi mbahe rese ipocosa cotɨ ipove yuvɨreco. Ipare oñenopɨha angahu sovai yuvɨreco aipo ehi: —¡Imboeteiprɨ judío rerecuar tasecoi! —ehi angahu sese oguayɨ tẽisa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iyavei ondɨvɨ-ndɨvɨ yuvɨreco sese. Ipare yuvɨrocua-rocua ipo pendar tacuarmi pɨpe ñaca rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ẽgüe ehi yoyai catu-catu yuvɨreco. Ipare vɨrocuase turucuar pĩra vahe ichui, ahese omonde iturucuar ité yuvɨreco sese. Ichui vɨraso curusu rese yatɨca ãgua yuvɨreco cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Acoi yuvɨnosese yuvɨraso, osepia mbɨa Cirene pendar, Simón serer vahe. Ahe chupe, “Erio, terevosɨi co curusu Jesús vɨreco vahe rese” ehi voiño tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Oyepotase yuvɨraso Gólgota serer vahesave, ahe ‘ava ãcagüer’ oya aipo ehi chupe, ");
INSERT INTO gyrNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","aheve uva rɨcuer imboyesehaprɨ mbahe pɨhaupiar rese omondo tẽi yuvɨreco Jesús toɨhu. Osãha tẽi, ndoɨhu potai rumo. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ipare oyatɨca curusu rese yuvɨreco. Ahese sundao iguayɨño oyeupe iturucuar mboyaho-yaho ãgua rese. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ipare aheve oguapɨ yuvɨnoi sãro. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iyavei omombehu ɨvate curusu rese ñaca harɨve mbahe sui oyuca yuvɨreco: “Co Jesús judío rerecuar guasu” ehi icuachiaprɨ oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ñuvɨrío imonda rai vahe yatɨcasa avei curusu rese supive yuvɨreco, ñepei mbahe rese ipocosa cotɨ, ambuae evocoiyase mbahe rese ipocoẽhɨsa cotɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Acoi ava ñocuasar iñehe-ñehe tẽi, oñeaca mbovava, ");
INSERT INTO gyrNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","aipo ehi yuvɨreco chupe: —Nde acoi, “Opara tũparo amonduru. Ipare mbosapɨ arɨ rupi opa irira amopuha” ere acoi cuese. ¡Eñepɨsɨro ru nde ae cute! ¡Tũpa Rahɨr nde recose, egüeyɨ curusu sui! —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Aipo ehi avei pahi eta rerecuar, Moisés porocuaita rese oporombohe vahe iyavei judío rerecuareta avei; ahe iñehe mara-mara tẽi yuvɨreco chupe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Oipɨ̃sɨro ambuae, ahe ae rumo ndoicatui oñepɨsɨro. Israel rerecuar guasu secoise, ¡togüeyɨ curusu sui cũritei, ahese voi seroyasara! ");
INSERT INTO gyrNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ahe oyeroya Tũpa rese, Tũpa evocoiyase oipotase, toipɨ̃sɨro cũritei. Esepia, ahe, “Che Tũpa Rahɨr aico” ehi yandeu cuese —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Imonda rai vahe avei rumo acoi yatɨcaprɨ supive, ahe avei mara ehi-ehi tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ahese mbɨter arɨ pɨpe, opa tuprɨ pɨ̃tu ɨvɨ rupi. Ẽgüe ehi las tres rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ahese tuprɨ avei Jesús oñehe pĩrata aipo ehi: “Elí, Elí, ¿lema sabactani?” ehi, (ahe ‘che Ru Tũpa, che Ru Tũpa, ¿mahera vo che reya eve?’ oyapave aipo ehi). ");
INSERT INTO gyrNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ava aheve yuvɨrecoi vahe osenduse iñehe, aipo ehi yuvɨreco: —Esendu co mbɨa, Tũpa ñehe mombehusar Elías upe oñehe —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Aheseve voi imboetasa oña, oso mbahe saviyu vahe reca, omoaquɨ vinagre pɨpe imondo ɨvɨra aprɨ rese chupe ‘toɨhu’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ambuae rumo aipo ehiño yuvɨreco: —Ẽgüe tehiño rane, ¿oura pĩha Elías ipɨ̃sɨro ãgua? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ahese Jesús sãse pĩrata iri, omano. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ahe pɨpeve voi tũparo guasu turucuar ɨvate cotɨ sui ovo tuprɨ. Aheseve avei ɨvɨ orɨrɨi iyavei ita guasu-guasu oyeca. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tehõgüer ruvɨpa ita apoprɨ avei oyemboi yuvɨreco iyavei setá Tũpa reroyasar omano vahecuer, ahe avei opa ocuerayevɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ẽgüe ehi Jesús cuerayevɨre, ahe opa yuvɨnose tehõgüer ruvɨpa sui. Ipare yuvɨroique Jerusalén maranehɨ pɨpe. Aheve setá ava upe oyemboyecua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Evocoiyase co sundao rerecuar iyavei Jesús rãrosareta, ahe oyanduse ɨvɨ rɨrɨi yuvɨreco iyavei ambuae mbahe ẽgüe ehi vahecuer repiase, ahese oyembosɨquɨye guasu aipo ehi yuvɨreco: —¡Supi eté catu co mbɨa Tũpa Rahɨr ité secoi! —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iyavei setá cuña aheve amombrɨve osepia catu yuvɨnoha, ahe acoi Galilea sui yugüeru vahecuer Jesús rupi iyavei setá rupi oipɨ̃tɨvɨi yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ahe ipãhuve María Magdalena secoi, iyavei ambuae María ahe Santiago, José sɨ, Zebedeo rahɨr sɨ avei supi secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pɨ̃tu potase, ou mbɨa mbahe yar José serer vahe, ahe Jesús reroyasar tecua Arimatea pendar. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Evocoiyase ahe oso Pilato upe oporandu Jesús rehõgüer rese. Evocoiyase Pilato aipo ehi: “Avɨye, timondosaño chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José evocoiyase vɨraso sehõgüer. Ipare oimama tuprɨ turucuar secose vahe ndiquɨhai vahe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ichui omoingue ombahe tuvɨpa ipɨasu vahe, ita oyoho uca vahe pɨpe. Ipare osovapɨ ita guasu yapayere vahe pɨpe oso. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aheve María Magdalena ambuae María rese suvɨpa rovai oguapɨ yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ahere ayihive mbɨtuhusa arɨ pɨpe, yuvɨraso pahi eta rerecuar iyavei fariseo Pilato upe mbahe rese oporandu ãgua ");
INSERT INTO gyrNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","aipo ehi yuvɨreco: —Ore rerecuar, ore oroyemomahenduha acoi iporombopa serai vahe ñehe agüer rese: “Acuerayevɨra mbosapɨ arɨ pare omano vahe pãhu sui” ehi acoi cuese oicove vɨtese —ehi yuvɨreco—. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Sese emondo sundao sehõgüer ruvɨpa rãro tuprɨ ãgua mbosapɨ arɨ rupi semimbohe ñomiẽhɨ ãgua pɨ̃tu pɨpe yuvɨreco. Avɨyeteramo, “Ocuerayevɨ omano vahe pãhu sui” aipo ehi tuprɨ tẽi tiẽtera ava upe yuvɨreco. Aipo ehise yuvɨreco, yɨpɨndar semira tẽi vahe sui ɨvate catura serecosa —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato evocoiyase aipo ehi chupe yuvɨreco: —Avɨye —ehi—. Amondora sundao pẽu. Peraso, pemovɨracua tuprɨ ité sãro ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Evocoiyase yuvɨraso tehõgüer ruvɨpa rãro tuprɨ ãgua yuvɨreco. Ahese omondo tehõgüer rovapɨsa ita guasu rese mbahe imomɨisa cua ãgua yuvɨreco. Ipare oseya aheve sundao sãro ãgua yuvɨreco cute. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Cõhe ramomise, domingu pɨpe, María Magdalena iyavei ambuae María yuvɨraso tehõgüer ruvɨpa repia yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Avɨyeteramo tẽi orɨrɨi pĩratá ɨvɨ Tũpa rembiguai ɨva sui igüeyɨse. Ẽgüe ehi oyepota tehõgüer ruvɨpave ou, ahe vɨrocua itape guasu sovapɨsa ichui. Ipare iharɨve oguapɨ oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ẽgüe ehi sendɨ́ iteanga avɨye acoi overa vahe. Iturucuar evocoiyase morochí eté. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Osepiase sundao, orɨrɨí eteanga osɨquɨyepave yuvɨreco ichui, opa oyuca pucu-pucu tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tũpa rembiguai rumo aipo ehi voi eté cuña upe: —Pesɨquɨyei rene. Esepia, che aicua pe peseca Jesús yatɨcapɨrer. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ndipoi eté cohave. Esepia, ahe ocuerayevɨ güemimombehu rupi eté. Tapesepia ru supagüer —ehi. Ipare aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","—Peso poyava voi, tapemombehu semimbohe eta upe: ‘Ocuerayevɨ omano vahe pãhu sui iyavei ahe rane osora pe renonera Galilea ve. Aheve pesepiara’ tapeye chupe. Co che cuaita imombehu ãgua pẽu —ehi Tũpa rembiguai cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Evocoiyase cuña yuvɨraso poyava voi suvɨpa sui, osɨquɨye pãhuve rumo ovɨhaño yuvɨreco; ẽgüe ehi yuvɨnoñá iteanga imombehu yugüeru oreu. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ahese Jesús oyemboyecua cuña upe cute omboavɨrave. Ahe cuña evocoiyase oyemboya sese oñenopɨha ipɨcuhaguã imboeteisave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Evocoiyase ahe aipo ehi chupe: —Pesɨquɨyei rene che sui. Pesoño, tapemombehu che reroyasareta upe. Ahe toyuvɨraso Galilea ve. Aheve che repiara yuvɨreco —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Cuña yuvɨraso vɨteseve, ahese movɨro sundao yuvɨroique tecua guasu Jerusalén pɨpe yuvɨreco. Ahe omombehupa pahi eta rerecuar upe opacatu mbahe osepia vahecuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Evocoiyase pahi rerecuareta oñemoñeta judío rerecuar rese opɨhañemoñeta mboyoya ãgua. Ichui omondo setá guarepochi sundao upe yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","aipo ehiño yuvɨreco chupe: —Aipo peyera ava uve: “Oroque vɨteseve pɨ̃tu pɨpe, ahese revo Jesús remimbohe yugüeru sehõgüer ñomi ãgua ore sui” peyera —ehi mborerecuar yuvɨreco chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Acoi oyanduse rumo mborerecuar guasu curi, ahese opovɨroya ucara chupe. Evocoiyase ndipoi chira mbahe pe rese —ehiño pahi eta rerecuar sundao upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Evocoiyase oipɨsɨpa guarepochi yuvɨreco. Ipare yuvɨraso oyapo oyeupe imombehu agüer yuvɨreco. Ẽgüe ehi vɨte cũritei judío Jesús cuerayevɨsa reroyaẽhɨ yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Evocoiyase ẽgüe orohe oroso semimbohe once oroico vahe Jesús remimombehu ɨvɨ Galilea pendar ɨvɨtrɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Acoi orosepiase rumo Jesús, ahese oromboetei oroico, yepe movɨro tẽi ore pãhu pendar ndovɨroya tuprɨ vɨtei yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Evocoiyase ahe oyemboya ore rese aipo ehi oreu: —Tũpa che mbou mborerecuar ɨvate catu vahe che reco ãgua ɨvave, ɨvɨve nara avei no —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Peso ava upe opacatú ɨvɨ rupi iyavei pembohe che recocuer rupi eté yuvɨrecoi vaherã; peñapiramo avei che Ru rer pɨpe, che rer pɨpe, Espíritu Santo rer pɨpe avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iyavei pembohe che opacatu pe mbohe agüer reroya ãgua rese —ehi—. Peicuañora che aicovera pe reseve arɨ yacatu rupi yepi, acoi arɨ ipa vahe rupi —ehi Jesús oreu. Avɨye, aipo rupive.");
INSERT INTO gyrNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Co yɨpɨndar avɨye vahe ñehesa Jesucristo, Tũpa Rahɨr, recocuer resendar amombehu potami pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Yɨpiɨndar Tũpa aipo ehi imombehu oñehe mombehusar Isaías rembicuachía pɨpe aracahe: “Amondora che ñehe mombehusar nde renonera, ndeu perɨ moatɨro ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Oyeendu ñehesa ipĩrata vahe ava porẽhɨsave: ‘Pemoingatu yande Yar raperã; pemohɨvi tuprɨ avei’ ehi” ehi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ẽgüe ehi Juan ou ava ãpiramo ɨvɨ iporupɨrẽhɨsa rupi oico, aipo ehi: “Pemboasɨ pe angaipa, peyevɨ Tũpa upe, ahese opoãpiramora Tũpa pẽu ñero ãgua pe angaipa rese” ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Opacatu ava oyugüeru iñehe rendu ãgua ɨvɨ Judea rupindar, iyavei tecua Jerusalén pendar oangaipagüer mombehu ãgua. Ahese Juan oñapiramo ɨai Jordán pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan turucuar camello ragüer apoprɨ, sumbɨcuasa mbahe pirer, sembihu evocoiyase tucru, eirɨ caha pɨpendar avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ahe aipo ehi oñehe ava upe oico: “Che raquɨcuei oura seco pĩrata catu vahe che sui, sese cheu ndiyai chira ayeaɨvɨ ipɨtaquisã yora ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Che supi eté opoãpiramo ɨ pɨpe tẽi; ahe rumo pe ãpiramora Espíritu Santo pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ipare Jesús osẽ tecua Nazaret sui oso Galilea rupi. Aheve Juan oñapiramo ɨai Jordán pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Osẽ ramoseve ɨ sui, Jesús osepia ɨva oyemboi tuprɨ, ahese Espíritu ogüeyɨ iharɨve apɨcasu nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ahese oyeendu ñehesa ɨva sui aipo ehi: “Nde che Rahɨr ereico, che rembiaɨsu, avɨha eteprɨ nde rese” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ipare voi, Espíritu Santo vɨroguata Jesús ava porẽhɨsa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aheve Jesús secoi cuarenta arɨ mbahe mɨmba vai pãhuve. Aheve avei Caruguar osecoãha; Tũpa rembiguai ɨva pendareta rumo ihañecoño yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan roquenda pare, Jesús oso ɨvɨ Galilea rupi, omombehu ñehesa avɨye vahe Vu recocuer resendar ava upe oico ");
INSERT INTO gyrNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","aipo ehi: “Oyepota arɨ iyavei cõimi eté Tũpa mborerecuasa yandeu. Sese, pemboasɨ pe angaipa, peyevɨ Tũpa upe, iyavei peroya co ñehesa avɨye vahe Tũpa suindar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ñepei arɨ Jesús oguata ɨpa Galilea ɨvɨi. Ahese osepia Simón, tɨvrɨ Andrés avei, ahe pira omboha yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ahese Jesús aipo ehi chupe: —Pe pira recasar peico, perio che rupi, na peye aveira ava reca ãgua cheu nara —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aipo he ramoseve voi, opoi opira mbohasa sui yuvɨreco, yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ipare chĩhi oguata irimise, ahese osepia Santiago, Zebedeo rahɨr, tɨvrɨ Juan reseve carite pɨpe omoingatu opira mbohasa yuvɨnoi vu pɨri. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ahe chupe avei: “Perio che rupi” ehi, evocoiyase vu oseya carite pɨpe ipɨ̃tɨvɨisar reseve, yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Oyepotase tecua Capernaum ve yuvɨreco mbɨtuhusa arɨ pɨpe, Jesús oique oporombohe tũparove. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Evocoiyase ava osenduse iporombohesa, “¿Mara ehi rutei?” ehi tẽi yuvɨreco chupe. Esepia, ahe oporombohe güeco pĩratasa pɨpe, ndahei Moisés porocuaita rese oporombohe vahe nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Aheve mbɨa ahe tecua pendar vɨreco vahe caruguar oyese, oñehe pĩrata chupe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Mahera vo ereyuño tẽi cohave oreu, Jesús Nazaret pendar? ¿Ereyu vo ore mocañɨ ãgua tẽi? Che orocua ité, nde Tũpa suindar ndaseco marai vahe ereico —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Oñehe pĩrata rumo caruguar upe aipo ehi: —¡Quiriri, esẽ co mbɨa sui! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Evocoiyase caruguar mbɨa rese secoi vahe omoehoha seitɨ ɨvɨve, sãse, osẽ oso ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Opacatu ava ombosɨquɨye, ichui oporandu-randu oyeupe yuvɨreco aipo ehi: —¿Mbahe pĩha co? ¡Iporombohesa ipɨasu vahe ité! ¡Co mbɨa vɨreco ité omborerecuasa! ¡Caruguar avei eté omboyeroya oyeupe iñehese! —ehi tẽi ava yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cũriteimi voi yandusa serãcua opacatu ɨvɨ Galilea rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesús yuvɨnosese tũparo sui, yuvɨraso Santiago, Juan rese Simón, Andrés rẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aheve Simón rembireco sɨ sohɨ́ iteanga vupave ou. Evocoiyase omombehu Jesús upe imbaherasɨsa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ahese oso chupe oipɨsɨ ipo rese imopuha, ahe ramoseve, sohɨ opɨtuhu ichui. Ipare voi ahe cuña ihañeco semihura rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pɨ̃tu ramose opacatu imbaheasɨ vahe iyavei caruguar vɨreco vahe vɨraso yuvɨreco chupe imbogüera ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Opacatu ava ahe tecua pendar oñemonuha oquendɨpɨve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Evocoiyase setá ombogüera mbaherasɨ-rasɨ tẽi vɨreco vahe, iyavei omboyepepɨ setá caruguar ava sui. Ndoipotai rumo caruguar ñehe. Esepia, ahe oicua ité evocoiya seco yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ayihiteve Jesús oñarapuha oso ava porẽhɨsave oyeroquɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Evocoiyase Simón ondugüer reseve yuvɨraso seca. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Osepiase, —Opacatu ava nde reca tẽi yuvɨreco —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ahe rumo, —Yaso ambuae tecua namombrɨi vahesa rupi Tũpa Ñehengagüer mombehu ãgua aheve; evocoi nungar apo ãgua niha che ayu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ẽgüe ehi oguata opacatu Galilea ɨvɨ rupi, omombehu Vu Tũpa Ñehengagüer judío tũparo yacatu rupi oico, iyavei setá omose caruguar ava sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ñepei mbɨa lepra rerecosar oyemboya Jesús rese, oñenopɨha sovai aipo ehi: —Ereipotase, iya nde che mbogüerami eve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iparaɨsuerecosave opoco sese. —Aipota. ¡Erecuerara cũritei! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aipo ihe ramoseve, ocuera voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ahese aipo ehi iri chupe icho renondeve: ");
INSERT INTO gyrNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Aní chira eremombehu ambuae ava upe, esoño ipa voi pahi upe nde cuerasa mombehu, iyavei eremondora porerecosa nde cuerasa resendar Moisés porocuaita rupi. Evocoiyase toicua opacatu ava yuvɨreco nde cuerasa —ehi chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ahe mbɨa rumo oso omombehu-mbehu opacatú ava upe. Sese Jesús ndoicatu iri güeique ãgua güecocuer mombehuse tecua rupi; secoiño tẽi tecua popɨ rupi ava porẽhɨsave. Ava rumo yugüeruño ité opacatu tecua rupindar sepia. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ñepei arɨ pɨpe Jesús oyevɨ ou tecua Capernaum ve, ahese opacatu oyandu ñepei oɨve secoise yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Cũriteimi voi eté setá ava oñemonuha yuvɨreco secosave. Sese ndipoi eté ava reique iri ãgua oɨ pɨpe oquendɨpɨ rupi. Ahe rumo omombehuño ité Vu Ñehengagüer. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aheseve irungatu mbɨa vɨroyepota ndoguatai vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ahe rumo ndiyai seroique ãgua Jesús uve ava rehɨisave yuvɨreco. Sese vɨroyeupi oɨ harɨve seraso yuvɨreco. Aheve teca vɨrocua oɨ sui yuvɨreco; supi vɨroyɨ supa reseve imondo Jesús rovai tuprɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ahe oicuase co mbɨa yuvɨrecoi vahe oyese yeroya, aipo ehi imbaheasɨ vahe upe: —Che rahɨr, che ñero nde angaipa rese ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moisés porocuaita rese oporombohe vahe rumo ipɨhañemoñeta aheve yuvɨnoi: ");
INSERT INTO gyrNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Mahera co mbɨa aipo ehiño tẽi oñehe? Ahe oyemboɨvate ai tẽi vahe Tũpa ñehe nungar pɨpe tẽi oñehe. Tũpaño ité niha oicatu ava angaipa upe oñeroi ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ahe rumo oicuaño ipɨhañemoñetasa, sese aipo ehi: —¿Mahera vo pepɨhañemoñeta rai tẽi che rese? ");
INSERT INTO gyrNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Uma rupi vo ñehesa ndayavaimi catu ndoguatai vahe upe: “Nde angaipa rese che ñero ndeu” hesa pĩha, anise: “Eñarapuha, esupi nde rupa, eguata” hesa tie? ");
INSERT INTO gyrNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tapeicua ru che, Ava Rɨquehɨr, areco mborerecuasa co ɨvɨ pɨpe ava angaipa upe che ñero ãgua —ehi. Evocoiyase aipo ehi imbaheasɨ vahe upe: ");
INSERT INTO gyrNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Eñarapuha, esupi nde rupa, eso nde rẽtave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Imbaheasɨ vahe aipo ihe ramoseve, oñarapuha, osupi vupagüer, osẽ oso ichui opacatu ava rembiepiave. Sese opacatu oyepɨhamondɨi yuvɨreco, omboetei Tũpa yuvɨreco aipo ehi: —Yɨpɨsuive ndayasepiai vahe ité co nungar mbahe —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ipare Jesús oso iri ɨpa ɨvɨi. Aheve oporombohe oyese ava rehɨi yemboyase. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ichui oguata vɨtese, osepia Leví, Alfeo rahɨr, guarepochi rerocuasave chinise, aipo ehi chupe: —Erio che rupi —ehi. Evocoiyase Leví opũha, oso voi supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ipare ocaru Leví rẽtave güemimbohe reseve yuvɨreco, ava sui guarepochi rerocuasar iyavei ava yangaipa vahe pãhuve. Esepia, setá ava osaquɨcue moñaño ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Evocoiyase Jesús ocaruse ipãhuve, fariseo eta, oporombohe vahe Moisés porocuaita rese avei oporandu semimbohe eta upe yuvɨreco: —¿Mahera ru pe mbohesar ocaru ava guarepochi rerocuasar iyavei yangaipa guasu vahe pãhuve tẽi? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ahe rumo osenduse iñemoñetasa, aipo ehi chupe: —Ava nimarai vahe ndosecai eté oporoposano vahe, imbaheasɨ vaheño rumo oseca yuvɨreco. Che ndayui ava seco tuprɨ vahe reca; che rumo ayu ava yangaipa guasu vahe reca —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ñepei arɨ pɨpe Juan Oporoãpiramo vahe remimbohe oyecuacu yuvɨreco, fariseo eta avei oyecuacu yuvɨreco no. Evocoiyase movɨro mbɨa ipãhu pendar yuvɨraso, oporandu Jesús upe: —¿Mahera ru nde remimbohe ndoyecuacui eté yuvɨreco? Esepia, Juan remimbohe iyavei fariseo eta oyecuacu yuvɨreco yepi —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Evocoiyase omboyevɨ ahe ava upe: —¡Ndiyai eté ichohoprɨ mendasave iyecuacu ãgua imer oicove vɨtese ipãhuve! ");
INSERT INTO gyrNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Oimera rumo arɨ imer reraso ãgua ichui curi, ahese ramo oyecuacura yuvɨreco cute —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ndiyai yayapete turucuar cuacua turucuar ipɨasu vahe pɨpe. Esepia niha, ipɨasu vahe oichohó turucuar cuacua imondoro iri ãgua, ichorosa evocoiyase tuvicha catu-catuño ité. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iyavei uva rɨcuer ipɨasu vahe ndiyai iñasa mbahe pirer cuacua pɨpe. Esepia, uva rɨcuer ipɨasu vahe osose mbahe pirer cuacua vahe pɨpe, ombopuñora, uva rɨcuer evocoiyase ocañɨpa tẽira, iyavei mbahe pirer ocañɨ tẽi aveira. Sese uva rɨcuer ipɨasu vahe ñoñasara mbahe pirer ipɨasu vahe pɨpe yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ñepei mbɨtuhusa arɨ pɨpe, Jesús oguata güemimbohe rese trigo pãhu rupi fariseo rembiepiave yuvɨreco. Ahese semimbohe oipoho-poho sãhɨi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Evocoiyase fariseo aipo ehi: —¡Mahera nde remimbohe mbɨtuhusa arɨ pɨpe oporavɨquɨño yuvɨreco! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ahe rumo aipo ehi: —Peyeroquɨ niha icuachiaprɨ aracahendar pɨpe mborerecuar guasu David rembiapogüer rese acoi ndasɨepoise ondugüer reseve yuvɨreco aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pahi rerecuar ɨvate catu vahe Abiatar serer vahe recose, ahese David oique Tũpa rẽta pɨpe pan imboeteiprɨ Tũpa upendar reca ondugüer reseve yuvɨrohu ãgua. Ahe chupe acoi ndipotasai ihu ãgua yuvɨreco viña; judío pahi yuvɨrecoi vahe upeño ité niha ipotasa ihu ãgua yepi. Ahe rumo ohuño, omondo avei ava oyeupindar tohu aracahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iyavei aipo ehi: —Mbɨtuhusa arɨ yaposa ava upe nara, ndahei ava yaposa mbɨtuhusa arɨ upe nara. ");
INSERT INTO gyrNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sese Ava Rɨquehɨr mbɨtuhusa arɨ rerecuar secoi —ehi Jesús fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús oique iri judío tũparove. Aheve oime mbɨa ipo co cotɨgüer nomɨi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Aheve avei fariseo ‘¿ombogüerara pĩha mbɨtuhusa arɨ pɨpe?’ oya omahengatu yuvɨreco sese ‘yaiñehengapo angahu’ oyapave tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Evocoiyase Jesús aipo ehi co mbɨa ipo nomɨi vahe upe: —Epũha ore mbɨterve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ipare oporandu ambuae upe: —¿Mbahe vo yaposara mbɨtuhusa arɨ pɨpe yepi: mbahe avɨye vahe pĩha, mbahe naporai vahe tie? ¿Yaipɨ̃sɨro pĩha ava recocuer, yamocañɨ uca tẽi tie? —ehi chupe. Ahe rumo opaño iquiriri tuprɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Evocoiyase omahe ava oyese oyere tuprɨ vahe rese vorɨẽhɨsave iyavei ndovɨhai ava ndosenducua catuise yuvɨreco. Sese aipo ehi ipo nomɨi vahe uve: —Eichoho nde yɨva —ehi. Evocoiyase oichoho oyɨva, ocuera tuprɨ ité. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ahese fariseo opa yuvɨnose yuvɨraso oyemoingatu Herodes rupindar rese Jesús yuca ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ipare Jesús yuvɨraso güemimbohe reseve ɨpa popɨ rupi, ava rehɨi avei ɨvɨ Galilea rupindar yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Oyanduse mbahe sembiapo yuvɨreco, setá avei ambuae ava yugüeru Judea rupindar, Jerusalén pendar, Idumea rupindar, ɨai Jordán cotɨndar avei, opacatu ava Tiro, Sidón pendar yugüeru sepia ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sese oyocuai güemimbohe vɨreco voi vaherã ñepei carite yuvɨreco ava ombotɨ eteprɨẽhɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Esepia, setá imbaheasɨ vahe ombogüera. Sese opacatu ambuae imbaheasɨ vahe yuvɨraso chupe sese opoco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iyavei ava caruguar vɨreco vahe sepiase, oñenopɨha sovai, oñehe pucu-pucu yuvɨreco: —¡Nde Tũpa Rahɨr ereico! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús rumo oñehe pĩrata chupe: “Che mombehui rene ava rovaque peye” ehiño imondo. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ipare Jesús oyeupi ɨvɨtrɨ rese oso. Aheve ava vɨroyasar upe oñehe iporavo ãgua güemimbotar rupi. Ichui oyugüeru yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ahe ipãhu pendar osenoi doce tuprɨ güemimboherã ‘toguataño che rupi, tomombehu Tũpa Ñehengagüer opacatu ɨvɨ rupi’ oya. Ahe osero “apóstol” ");
INSERT INTO gyrNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","‘toipɨsɨ avei mborerecuasa caruguar ava sui imboyepepɨ ãgua yuvɨreco’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Evocoi doce yuvɨrecoi vahe, ahe: Simón (sererguã acoi omondo Pedro), ");
INSERT INTO gyrNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago iyavei tɨvrɨ Juan Zebedeo rahɨr, ahe avei omondo sererguã Boanerges (‘osunu vahe rahɨr’ oya aipo ehi); ");
INSERT INTO gyrNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","iyavei Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago Alfeo rahɨr; Tadeo, Simón, ava güecua rese secatẽhɨ vahe pãhu pendarer; ");
INSERT INTO gyrNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","iyavei Judas Iscariote, ahe omondo vaherã Jesús yamotarẽhɨsar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ipare Jesús oique oɨ pɨpe güemimbohe reseve. Aheve oñemonuha atɨ irise ava yuvɨreco sese, ndiyai icaru ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Oyanduse imu secocuer yuvɨreco, oyugüeru seraso ãgua ‘ndayaracua iri revo’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iyavei oporombohe vahe Moisés porocuaita rese oyugüeru vahe Jerusalén sui aipo ehi: “Co mbɨa caruguar rerecuar Beelzebú oyocuai vahe, ipĩratasa pɨpe tẽi omboyepepɨ caruguar ava sui” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Evocoiyase Jesús omombehu caruguar recocuer aipo ehi: “¿Mara ehira aipo caruguar ahe ae oyeenose ava sui viña? ");
INSERT INTO gyrNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Acoi mborerecuar guasu povrɨ pendar, ahe ovava-vavase oyeupe; evocoi nungar mborerecuar pĩratasa ocañɨ tẽira. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Acoi oñemu oyese ae oyeamotarẽhɨse, oyemboyahose yuvɨreco viña, ahe ndipocopɨi chiaveira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Acoi caruguar oyemboyahose ovava ãgua oyeupe ae yuvɨreco, ndipocopɨi chiaveira yuvɨreco, ahe evocoiyase secocuer ocañɨ tẽi vaherã ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ndipoi eté niha ava oique vahe que ava ipĩrata eteprɨ vahe rẽta pɨpe imbahe rerocuapa ãgua ichui; oñapɨchi rane itera. Ipare voi opara imbahe vɨrocua ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Supi eté aipo ahe pẽu: Acoi ava yangaipa vahe upe Tũpa iñerora opacatu yangaipa rese, iñehe-ñehe tẽisa rese avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Acoi iñehe-ñehe tẽi vahe rumo Espíritu Santo rese, ahe chupe ndipo iri chietera ñerosa apɨrẽhɨ vaherã ité” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Aipo ehi Jesús imboyevɨ ava upe. Esepia, “Caruguar tẽi erereco” ehiño ava yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Coiye opa oyepota Jesús rɨvɨreta iyavei ichɨ; ahe rumo opɨtaño ocarve yuvɨreco. Ichui omondo oñehe yuvɨreco chupe oyeupe ichẽ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yɨvɨi yuvɨnoi vahe oñehe yuvɨreco chupe: —Nde sɨ, nde rɨvɨreta, nde reindrɨ reseve ocarve nde reca tẽi yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ahe rumo, —¿Ava pĩha che sɨ; ava pĩha che rɨvɨreta yuvɨrecoi? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Evocoiyase omahe ava oɨvɨrindar yuvɨnoi vahe rese aipo ehi iri chupe: —Co che sɨ eta; co che rɨvɨreta. ");
INSERT INTO gyrNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Esepia, acoi Tũpa remimbotar oyapo vahe yuvɨreco, ahe che rɨvrɨ, che reindrɨ, che sɨ avei yuvɨrecoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús oporombohe iri ɨpa popɨ rupi. Aheve ava rehɨi oyemboya yuvɨreco sese. Ipare oha carite ɨmbehɨve tui vahe pɨpe. Aheve oguapɨ oĩ oñehe. Ava rumo opacatu ɨvɨ ãtasa rupi opɨtaño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Evocoiyase ava mbohe ãgua omboyoya tecocuer mbahe tɨ̃sa rese aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Pesendu co ñehesa: Ñepei mbɨa osẽ omahetɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ahe otɨapɨ-apɨise mbahe rãhɨi oso, movɨro ovɨapi perɨ rupi. Vɨ̃rai yugüeruse rumo, opaño yuvɨrohu. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iyavei movɨro oitɨ ɨvɨ nayanai vahesave, ita pãhuve. Sese cũriteimi sorɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Arɨ tasɨse rumo, opaño ipiru. Esepia, ndasapoi niha. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Iyavei ambuae mbahe rãhɨi oitɨ yu pãhuve; ahe yu rumo sorɨ poyava catu. Sese opaño oyopɨ. Evocoiyase ahe mitɨ ndihai eté. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ambuae mbahe rãhɨi oitɨ ɨvɨ avɨye vahesave. Ahe opa ocuacua mitɨ, iha tuprɨ ai yuvɨreco: amove iha treinta tuprɨ ohɨ rese, amove sesenta, amove cien tuprɨ ité oha vɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Evocoiyase, “Acoi osendu pota vahe che ñehe, toyapɨsacaño sese” ehi Jesús ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ipare Jesús opɨta ahe ae. Ava opɨta vɨte vahe semimbohe eta reseve oyemboya yuvɨraso sese oporandu yuvɨreco chupe, “¿Mara oya vo co yembohesa aipo ehi?” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ahe aipo ehi: “Pẽu niha Tũpa oicua uca mbahe ndicuasai vahe omborerecuasa resendar. Ndache reroya potai vahe upe rumo imboyoyasa mbahe ambuae mbahe rese yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yepe osepia tẽira, ndosepiacuai chietera rumo yuvɨreco. Iyavei yepe osendu tẽira, ahe rumo ndosenducuai chietera yuvɨreco, Tũpa upe oyevɨ potaẽhɨsave, ipɨpe sui ndipoi chira ñeroisa yuvɨreco chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iyavei aipo ehi: “¿Ndapesenducuaimi vo aipo porombohesa? ¿Mara peyera ru opacatu ambuae che porombohesa cua tuprɨ ãgua? ");
INSERT INTO gyrNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Evocoi mbahe rãhɨi oñotɨ vahe, Tũpa Ñehengagüer mombehusar nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Amove ava recocuer inungar co mbahe rãhɨi seitɨprɨ perɨ rupi: osendu angahu Tũpa Ñehengagüer. Sendu pare rumo, ou Caruguar ovɨrocuapaño oique vahe ipɨha pɨpe ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ambuae ava recocuer inungar mbahe rãhɨi seitɨprɨ ita pãhu rupi: osendu Tũpa Ñehengagüer, oipɨsɨ tuprɨ angahu oyeupe nara vorɨvetesa pɨpe; ");
INSERT INTO gyrNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ndovɨrecoi rumo guapo oyese opĩrata ãgua. Evocoiyase yuvɨrecoise mbahe-mbahe tẽi pɨpe Tũpa Ñehengagüer sui tẽi, cũriteimi seroyaẽhɨsave, ‘Apoira ichui’ ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ambuae ava recocuer inungar mbahe rãhɨi ñotɨmbrɨ yu pãhu rupi: osenduse ñehesa Tũpa suindar, ");
INSERT INTO gyrNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ahe rumo ipɨhañemoñeta catu opacatu ombahe eta co ɨvɨ pɨpendar rese saɨsusave. Oyembopa uca rumo ombahe eta upe. ‘Opacatu ité mbahe tareco’ ehi tiẽte viña. Ipɨpe sui omocañɨ tẽi Tũpa Ñehengagüer. Ndoyapo ucai avei mbahe eta avɨye vahe evocoi nungar ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ambuae ava rumo osendu vahe Tũpa Ñehengagüer seroyasa pɨpe, oyapoño ité mbahe avɨye vahe. Ahe inungar mbahe rãhɨi ñotɨmbrɨ ɨvɨ avɨye vahe rese: amove vɨreco ohɨ rese treinta, ambuae sesenta, ambuae cien” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iyavei aipo ehi: “¿Serecosa vo tataendɨ mbahe rɨruvrɨve nara tẽi iyavei yande rupavrɨve nara tẽi no? Aní, tataendɨ imondosa ɨvate poroesape ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ndipoi chietera mbahe ñomiprɨ ndayasepiai vaherã curi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Acoi osendu pota vahe che ñehe, toyapɨsacaño yuvɨreco sese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iyavei aipo ehi: “Peyapo catu mbahe pesendu vahe. Pe rembiapo nungar rupi tuprɨ asenducua ucara che ñehe pẽu. Iharɨve amondo iri catura pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Vɨreco tuprɨ vahe upe, imondosa catura. Acoi ndovɨreco tuprɨi vahe sui, serocuasañora” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Aipo ehi iri avei Jesús: “Tũpa mborerecuasa co ɨvɨ pɨpe inungar que ava oñotɨ vahe mbahe rãhɨi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Omahetɨ pare, oso oque. Ipare coiye catu oñarapuha. Ahe oñocua pɨ̃tu, arɨ avei, evocoiyase mbahe rãhɨi sorɨ poyava yuvɨreco. Itɨ̃sar rumo ndoicuai mara ehi vorɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ɨvɨ rese niha oyesu mitɨ: yɨpɨndar sorɨ, ipare iha, ipare sãhɨi yuvɨnose sese. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Evocoiyase co mbɨa mbahe ha yavɨyese, oipoho. Esepia, oyepota arɨ ipoho ãgua chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iyavei aipo ehi: “¿Mara ehi vo Tũpa povrɨ pendar co ɨvɨ pɨpe pẽu; mbahe rese pĩha iyacatu imboyoyasa icua ãgua? ");
INSERT INTO gyrNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ahe oyoya tuprɨ mostaza rãhɨi rese. Ahe tahɨmi catu opacatu ambuae mbahe rãhɨi sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ñotɨ pare rumo, sorɨ, ocuacuase tuvichá catu ambuae mbahe mitɨ sui. Sãca tuvichá ité, sese vɨ̃rai oyemboaitɨ sovrɨ rupi yuvɨ́reco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ẽgüe ehi Jesús oporombohe Tũpa Ñehengagüer rese, omboyoya-yoya ñepei mbahe ambuae mbahe rese ava mbahecuagüer rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nomombehui eté mbahe ambuae mbahe rese imboyoyaẽhɨ pɨpe. Ahe rumo omombehu tuprɨ güemimbohe upe ahe aemi yuvɨrecoise. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ahe arɨ pɨpe pɨ̃tu ramomise, aipo ehi güemimbohe upe: —Yaso ɨpa rovai —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Evocoiyase ava sui osɨrɨ yuvɨreco, yuvɨraso carite pɨpe. Ambuae carite pɨpendar avei yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Oyepotase rumo ɨvɨtu ai ipĩrata vahe, ɨ ohɨtu vahe oha guasu-guasu carite pɨpe, omboapɨpo seni yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús rumo oyeatocoño, oque ou supɨta cotɨ. Evocoiyase omomahe voi yuvɨreco, aipo ehi chupe: —¡Porombohesar! ¿Nandemahemohaimi rutei vo yande rese? ¡Opara moco yaso ɨpɨve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Evocoiyase aipo hese, omahe, oñehe pĩrata ɨvɨtu ai upe, ɨpa upe avei: —¡Pepɨtuhu! —ehi. Aheseve voi opɨtuhu tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ipare aipo ehi güemimbohe upe: —¿Mahera pesɨquɨyé iteanga? ¿Ndapeyeroya vɨtei vo che rese? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ahe rumo osɨquɨyepave oporandu-randu oyeupe yuvɨreco: —¿Ava pĩha co mbɨa secoi? Esepia niha, ɨvɨtu ai, ɨpa avei omboyeroya —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús güemimbohe reseve oyepota ɨpa rovai Gerasa ɨvɨ rese yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yuvɨnose pare carite pɨpe sui, ahese mbɨa caruguar rerecosar tuvɨpa pãhu rupi secoi vahe oso Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Co mbɨa tuvɨpa pãhu rupi secoi vahe yepi. Ndipoi eté ava secopɨsar, carena avei eté opa-opaño omondoso. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Setá yupagüer rupi tẽi ñapɨchisa carena pɨpe ipɨ, ipo rupi avei yepi. Ahe rumo opa-opaño ité omondoso carena yepi. Ndipoi eté ava osecoreroyɨ vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Arɨ, pɨ̃tu rupi oguata, osapucai oico ɨvɨtrɨ mahugüer rupi, tuvɨpa mahugüer rupi avei; ocua-ocua ita pɨpe oyese yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Amombrɨ Jesús repia ramoseve, oña senonde oñenopɨha voi sovai, ");
INSERT INTO gyrNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","oñehe pĩrata chupe: —¡Eyepepɨ che sui Jesús, Tũpa seco ɨvate catu vahe Rahɨr! ¡Aporandu Tũpa rer pɨpe che mombaraɨsuẽhɨ ãgua eve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Aipo ehi, esepia, yɨpɨndar Jesús aipo ehi chupe: —¡Caruguar mbahe tẽi vahe, esẽ co mbɨa sui! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aheve oporandu chupe: —¿Mara vo nde rer? —ehi. Ahe omboyevɨ chupe: —Che rer Legión. Esepia, ore rehɨi eté —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Oporanduño chupe omondopaẽhɨ ãgua co ɨvɨ sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ichui namombrɨimi setá cuchi ocaru vahe ɨvɨtrɨ rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sese caruguar oporandu yuvɨreco chupe: —Ore mondopaño cuchi avɨterve eve —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Evocoiyase Jesús omondo caruguar sẽ ãgua ahe mbɨa sui. Ahe opa yuvɨroique cuchi avɨterve. Ahe cuchi retacuer dos mil tuprɨ vahe, ahe yuvɨnoña yuvɨraso ɨvɨvate sui ɨpa pɨpe ocañɨpa. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Evocoiyase cuchi rãrosar yuvɨnoña osɨquɨyepave yuvɨraso imombehu ãgua tecuave, caha pɨpe rupi yuvɨrecoi vahe upe avei. Sese ava opa yugüeru sepia ‘¿mbahe pĩha?’ oya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Oyepotase Jesús recosave, aheve osepia mbɨa caruguar vɨreco vahecuer yuvɨreco oyemonde tuprɨse oĩ, yaracua tuprɨse avei. Ahese oyembosɨquɨye tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mbahe oime vahe caruguar vɨreco vahe rese, cuchi rese avei, ahe sepiasar omombehupa ambuae ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Evocoiyase ava Jesús upe: “Esẽ cohave sui” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Oha irise Jesús carite pɨpe, co mbɨa caruguar rerecosarer oporandu chupe supi oso ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ahe rumo, —Esoño nde rẽtave, nde mu pɨri. Aheve emombehupa Yar oporoaɨsusa pɨpe mbahe oyapo vahecuer nde rese —ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ahe mbɨa oso, omombehu opacatu tecua Decápolis rupi Jesús oyapo vahecuer mbahe sese. Evocoiyase ava opacatu, “¡Mara ehi rutei!” ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Oyevɨse Jesús carite pɨpe ɨpa rovai oso, aheve oñemonuha atɨ ava yuvɨreco chupe. Ahe evocoiyase opɨtaño ɨpa popɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Evocoiyase oyepota mbɨa mborerecuar tũparo pendar, ahe serer Jairo. Jesús repiase, oñenopɨha sovai, ");
INSERT INTO gyrNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","aipo ehi chupe: —Che rayrɨ omano pota. Yaso, teremondomi tẽi nde po iharɨve imbogüera ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Evocoiyase oso supi. Ava rehɨi avei yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ipãhuve avei oime cuña doce aravɨter rupi suvɨ yepɨyere-yere vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iparaɨsú iteanga, setá oporoposano vahe ndoicatui imbogüera yuvɨreco omomandaivete catu iposanosa pɨpe yuvɨreco. Opa tuprɨ tẽi omondo mbahe vɨreco vahe, ɨvate catuño rumo imbaherasɨsa chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Co cuña osenduse Jesús rese ñehesa, oguata saquɨcuei oso ava rehɨi pãhuve, iturucuar rese opoco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aipo ehi oyeupe oico: “Iturucuar rese apocose rumo, acuerara” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ahe ramoseve voi ndasuvɨ yepɨyere iri. Ipare oyandu güetecuer yemoingatu tuprɨsa, ocuerase ombaherasɨsa sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús rumo oyandu osẽse opĩratasa oyesui. Sese omahe guaquɨcuei cotɨ ava rese, ahese oporandu: —¿Ava vo opoco che turucuar rese? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Semimbohe omboyevɨ yuvɨreco chupe: —¿Nderemahei vo ava oyere tuprɨ yuvɨreco nde rese? ¿Mahera ru, ‘¿Ava vo opoco che rese?’ ere iri? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ahe rumo omaheño vɨte ité ava oɨvɨindar rese ‘¿uma ité pĩha opoco che turucuar rese?’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Evocoiyase co cuña oicuase mbahe oyesendar, oyembosɨquɨye. Ipare oso sovai, oñenopɨha, ahese opacatu mbahe supi vahe omombehu chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Evocoiyase Jesús aipo ehi chupe: —Che rayrɨ, erecuera cũritei nde yeroyasa pɨpe. Eso tuprɨ. Esepia niha, erecuera nde mbaherasɨsa sui —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iñehe vɨteseve, oyepota movɨro Jairo rẽta pendar tayrɨ mano mombehu yuvɨreco: —Omano ité nde rayrɨ. Aní eremañeco tẽi vɨte Porombohesar —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ahe rumo Jairo upe aipo ehi: —Aní eresɨquɨye. Eyeroya catuño —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ndoipotai rumo ambuae ava oyeupi icho ãgua; Pedro, Santiago, Juan güeraño oipota. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Oyepotase Jairo rẽtave, osepia ava yemondɨi oyaseho vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ichui oiquese oɨ pɨpe, aipo ehi: —¿Mahera vo perãse guasu tẽi peyaseho peyu? Co cuñatai nomanoi, oque tẽi ou —ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ava rumo opucaete-eteño seroyaẽhɨsave yuvɨreco. Evocoiyase omose opacatu ava. Ipare omoingue iyesupa, ichɨ, oyeupindar reseve cuñatai rehõgüersave. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ipare oipopɨsɨ aipo ehi: —Talita, cum —ehi chupe (‘cuñatai, eñarapuha, ahe ndeu’ ohesave aipo ehi). ");
INSERT INTO gyrNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ahe ramoseve voi cuñatai doce aravɨter vahe oñarapuha, ipare oguata. Sepiase ava, oyembosɨquɨye guasu yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús rumo oyocuai imombehuẽhɨ ãgua ambuae ava upe. Ipare, —Pembocaru co cuñatai —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús osẽ co tecua sui oso güecuave; semimbohe avei yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Oyepotase mbɨtuhusa arɨ, ahese oporombohe tũparo pɨpe. Setá ava iñehe rendusar oyepɨhamondɨisave oporandu-randu yuvɨreco: —¿Que sui vo co ava oicuapa opacatu mbahe? ¿Que sui pĩha vɨnose co mbahecuasa co poromondɨisa apo ãgua? —ehi yuvɨreco oyeupe—. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Co niha carpintero, María membrɨ; Santiago, José, Judas iyavei Simón rɨquehɨr, seindrɨ avei yuvɨrecove yande pãhuve —ehi. Sese ndovɨroyai yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús rumo aipo ehi ahe ava eta upe: —Tũpa ñehe mombehusar avei niha ava omboetei opacatu rupi yuvɨreco yepi, imu sẽta pɨpendar ae rumo nomboetei yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ndoicatui mbahe oporomondɨi vahe apo ãgua ava vɨroyaẽhɨsa pɨpe, sese movɨro tẽi imbaheasɨ vahe harɨve omondo opo imbogüera ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ndoyembovɨhai ava vɨroyaẽhɨsa rese. Ipare Jesús oso, oguata tecua-tecuami namombrɨi vahe rupi oporombohe oico. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Evocoiyase, “Perio” ehi güemimbohe doce vahe upe. Ipare oyocuai ñuvɨrío-río, iyavei omondo güeco pĩratasa caruguar mboyepepɨ ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","—Ndaperasoi chira rumo mbahe peguatasa rupi, pe pococa güeraño ité perasora —ehi—. Ndiyai avei peraso mbahe rɨru, pan, guarepochi avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Iyavei pemondera pɨtaqui güeraño. Ndapemondugüei chiaveira pe camisa seraso. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","—Que pesosave peiquese oɨ pɨpe, pepɨtaño ipɨpe, ichuive tuprɨño ité pesẽra pecua. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Acoi ambuae tecua pendar ndape pɨsɨ potaise, ndosendu potaise avei pe ñehe yuvɨreco, peyepepɨñora ichui. Peipɨpeteño aveira pe pɨ ɨvɨ rãtachigüer sui. Ẽgüe pe hesa omboyecuara cañɨsa apɨrẽhɨ yuvɨreco chupe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Evocoiyase semimbohe eta yuvɨraso, “Pemboasɨ pe angaipa, peyevɨ Tũpa upe” ohe ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Iyavei setá omboyepepɨ caruguar ava sui, setá avei omondo mbahe quɨra ava imbaheasɨ vahe rese imbogüera ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mborerecuar guasu Herodes oyandu ñehesa Jesús resendar, iyavei opacatu rupi oicua yuvɨreco. Sese Herodes aipo ehi: —Juan Oporoãpiramo vahe revo ocuerayevɨ. Sese oyapo poromondɨisa ipĩrata vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ambuae rumo, —Tũpa ñehe mombehusar Elías mo evocoi —ehi yuvɨreco. Ambuae evocoiyase, —Tũpa ñehe mombehusar aracahendar mo evocoi —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Osenduse Herodes co nungar ñehesa, aipo ehi: —Juan ité niha evocoi che añaca asɨa uca vahecuer, ahe cũritei ocuerayevɨ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodías recocuer sui tẽi niha Herodes Juan oñapɨchi uca carena pɨpe soquenda. Esepia, co cuña Herodías yɨpɨndar Felipe rembireco, co Felipe Herodes rɨvrɨ viña. Herodes rumo omendaño vɨvrɨ rembireco rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan aipo ehi Herodes upe: “Ndiyai eté nde ererecora nde rɨvrɨ rembireco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías evocoiyase oyuca pota Juan yamotarẽhɨsave; ndoicatui rumo yuca. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Esepia, Herodes osɨquɨyeño ichui oicuase co mbɨa reco tuprɨ aisa iyavei seco maranehɨse. Sese osepɨ ité; yepe ndoyembohe catui osenduse iñehe viña, ahe rumo osendu pota raiño ité. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Coiye rumo osupitɨ arɨ Herodías remimbotar apo ãgua, ahese Herodes oharagüer pɨpe oyapo carusa guasu mborerecuareta rese, ava Galilea pendar icuaprɨ ɨvate catu yuvɨrecoi vahe rese avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodías membrɨ cuñatai oique carusave. Aheve opɨvoi ava rovaque. Ipɨvoisa avɨye ai Herodes upe, ambuae ava ocaru vahe upe avei. Ichui aipo ehi cuñatai upe: —Eporandu mbahe nde remimbotar rese cheu, che evocoiyase amondora ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ipare aipo ehi iri opacatu ava rovaque chupe: “Amondora nde remimbotar ndeu, anise, che mbahe eta amboyahora ndeu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ahe cuñatai osẽ oso, osɨ upe oporandu: —¿Mbahe rese pĩha aporandura chupe? —ehi. Ichɨ aipo ehi chupe: —Eporandu Juan Oporoãpiramo vahe ãca rese —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ipare cuñatai oña, oique oso mborerecuar guapɨsave, aipo ehi chupe: —Che aipota co pɨpeve voi eremboura Juan Oporoãpiramo vahe ãca poratu pɨpe cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Mborerecuar rumo ndoyembovɨhai tẽi. Esepia, ava ichohoprɨ rovaque ité yɨpɨndar oñehe. Sese ndoicatui, “Aní” ohe ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Evocoiyase ipare voi mborerecuar oyocuai sundao Juan ãca reru ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sundao oso soquendasave, oyasɨa Juan ãca, seru poratu pɨpe. Mborerecuar omondo co cuñatai upe, evocoiyase cuñatai omondo osɨ upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Oyanduse Juan remimbohe, yuvɨraso setecuer reca. Ipare vɨraso yuvɨreco tuvɨpave yapocatu. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Co pare, apóstol oñemonuha Jesús pɨri yuvɨreco. Ipare omombehu mbahe güembiapogüer, oporombohe agüer avei yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ahese aipo ehi oapóstol upe: —Perio cohave, yaso, yapɨtuhumi rane co cotɨ —ehi. Esepia, oyepɨndecuaño ité ava yugüeru chupe, sese ndiyai icaru ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Evocoiyase ahe güeraño apóstol reseve yuvɨraso carite pɨpe co cotɨ ava sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Setá rumo ava osepia ichose. Ichui opacatu ava tecua rupindar osaquɨcue moñaño; ahe ranengatu oyepotapa yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ogüeyɨse rumo carite pɨpe sui, osepia ava rehɨi, ahese iparaɨsu ava eta chupe, inungar ovesa ndovɨrecoi vahe guãrosar. Ipare ombohe opacatu mbahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Caharuse rumo, semimbohe oyemboya yuvɨreco sese, aipo ehi yuvɨreco chupe: —Caharu eteprɨ moco, iyavei ndipoi oɨ co rupivemi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","¿Ndiyai vo eremondopa ava tecua-tecuami cõi vahesa rupi? Aheve tovɨrocua ocaru ãgua yuvɨreco —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ahe rumo omboyevɨ: —Pe pemondora mbahe semihura —ehi. Semimbohe aipo ehi yuvɨreco chupe: —¿Iyacatura pĩha oreu dosciento denario pan repɨrã ava mbocaru ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús aipo ehi: —¿Mbovɨ vo pereco pan? Peso, tapesepia —ehi. Sepia pare, omombehu: —Poyandepo pan, ñuvɨrío pira —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Evocoiyase omboyaho-yaho ava imboguapɨ capihi harɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Cincuenta, cien rupi-rupi oyemboyaho yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ichui Jesús oipɨsɨ poyandepo pan, ñuvɨrío pira. Ipare omahe ɨva rese, “Avɨye ndeu, che Ru” ehi. Imbohi-mbohi pare, opa omondo güemimbohe upe ava rehɨi upe imondo ãgua yuvɨreco. Pira ñuvɨrío vahe avei omboyaho-yaho opacatu ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Evocoiyase opacatu ava ocaru vahe ihɨ̃taropa tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ipare semimbohe omboapɨpopa doce tuprɨ ɨruova pan iyavei pira rumbɨrer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cuimbahe ocaru vahe retacuer cinco mil tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ipare Jesús, “Peha pe rane carite pɨpe, pesasa ɨpa Betsaida ve peso che renondeve. ‘Avɨye’ tahe rane ava eta upe” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","“Avɨye” ohe pare ava upe, oyeupi oso ɨvɨtrɨ rese oyeroquɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Pɨ̃tuse carite ɨpa mbɨterve ité secoi. Jesús rumo ahe ae opɨtaño ɨvɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ahese omahe güemimbohe rese iyeapɨcui catuẽhɨse. Esepia, ɨvɨtu ipĩrata vahe osovaĩchi yuvɨreco. Cõhe potase, oguata ɨ harɨ rupi güemimbohe cotɨ oso. Avɨye ité acoi oñocuaño vaherã oso. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sepiase rumo ‘hãgüer tẽi revo’ oya, sãse pucu-pucu ɨ harɨ rupi iguatase semimbohe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Esepia, opacatu osepiase osɨquɨye yuvɨreco ichui. Ahe rumo aipo ehi: —¡Peyemovɨracuaño, che tẽi! ¡Pesɨquɨye eme che sui! —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ahe ohase carite pɨpe, opɨtuhu voi ɨvɨtu. Evocoiyase, “¡Mara ehi rutei!” ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Esepia, ndoicua vɨtei eté pan apo atɨ agüer yuvɨreco, yavai vɨte seroya ãgua yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Osasase ɨpa, oyepota Genesaret ɨvɨ rese yuvɨraso, ahe ɨmbehɨve oñapɨchiño carite yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Yuvɨnosepa ramomiseve, ava oicua voi Jesús yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ichui opacatu ahe ɨvɨ pɨpendar güeru imbaheasɨ vahe Jesús upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Oyepotase que tecuamive, anise tecua guasuve, caha pɨpe oɨ-oɨmi rupi, ahe supi imbaheasɨ vahe ocar rupi vɨnosepa voi yuvɨreco. “Topocomi tẽi nde turucuar popɨ rese” ehi yuvɨreco chupe. Evocoiyase opacatu sese opoco vahe, ocuerapa voi eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Evocoiyase fariseo eta, Moisés porocuaita rese oporombohe vahe avei yugüeru Jerusalén sui oyemboya Jesús rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ahese ahe osepia Jesús remimbohe ocaru ãgua iyepoiẽhɨse porocuaita mboavɨyeẽhɨse yuvɨreco, sese oñemoɨro yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Esepia, fariseo iyavei opacatu judío eta aracahendar recocuer sui ndipoisai eté yuvɨreco, sese oyepoiẽhɨse ndocarui eté yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mbahe rerocuasa sui oyevɨse, ndocarui oyepoiẽhɨ vɨteseve yuvɨreco. Iyavei tecocuer aracahendar tẽi oyapo vɨte yuvɨreco inungar ɨgua rɨru pɨisa, mbahe rɨru guarepochi apoprɨ iyavei vupa moatɨro tuprɨsa.) ");
INSERT INTO gyrNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Sese fariseo eta iyavei Moisés porocuaita rese oporombohe vahe oporandu Jesús upe yuvɨreco: —¿Mahera vo nde remimbohe yande ramoi aracahendar recocuer ndovɨroya iri yuvɨreco? Esepia ru, ahe ocaruño opo quɨha reseve yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús rumo aipo ehi chupe: —Pe Tũpa reroyasar angahu tẽi peico vahe, supi tuprɨ ité Tũpa ñehe mombehusar Isaías rembicuachía aracahendar aipo ehi: ‘Co tecua pendar ava oyuru pɨpe tẽi che mboetei yuvɨreco; ipɨhañemoñeta rumo amombrɨ tẽi che sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Oyerure tuprɨ tẽi yuvɨreco cheu. Esepia, iporombohesa ava porocuaita tẽi’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ẽgüe peye pepoipa Tũpa porocuaita sui ava recocuer aracahendar rupi tẽi pe guata ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iyavei aipo ehi iri chupe: —Pe ramoi recocuer aracahendar pɨpe tẽi peseyaño co cotɨ Tũpa porocuaita. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Esepia, Moisés aipo ehi: ‘Pemboyeroyara iyavei peipɨ̃tɨvɨira pe ru, pe sɨ avei no. Acoi iñehe mara vahe oyesupa upe ahe, Tomanoño, ehi’ ehi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pe rumo aipo peye tẽi: ‘Acoi ava aipo ehi vahe vu upe, osɨ upe avei no: Ndiyai chira mbahe mondo ãgua pẽu. Esepia, che opacatu mbahe areco vahe Tũpa upe imondoprɨ, ahe Corbán, ehi’ peye; ");
INSERT INTO gyrNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","pe evocoiyase, aipo ehi vahe upe, ‘Ndiyai eté oyesupa pɨ̃tɨvɨi ãgua’ peye. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Co nungar apo pɨpe Tũpa porocuaita ndaperoyai. Esepia, ndapepoi potai ava recocuer aracahendar sui. Setá mbahe co nungar peyapo vɨte —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ipare, “Perio” ehi iri ava rehɨi upe. —Peyapɨsaca, pesenducua tuprɨ che ñehe: ");
INSERT INTO gyrNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ndahei ocar sui tẽi ou ava recocuer monguɨha ãgua. Ahe rumo osẽ ipɨha sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Acoi osendu pota vahe che ñehe, toyapɨsacaño sese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ipare oseyapase ava, oique oɨ pɨpe. Aheve semimbohe eta oporandu yuvɨreco co porombohesa omombehu vahe rese chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ahe evocoiyase aipo ehi güemimbohe upe: —Evocoiyase pe avei no, ¿ndapesenducuai? ¿Ndapeicuai vo acoi ocar sui oique vahe ava avɨterve nomboangaipai eté? ");
INSERT INTO gyrNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Esepia niha, ndahei ipɨhave oso, ahe rumo oso yavɨterve. Ipare osẽ ichui —ehi ‘opacatu tembihu avɨyeño ité’ oyapave aipo ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ipare aipo ehi: —Ava pɨha sui osẽ vahe rumo mbahe, ahe omonguɨha ava recocuer. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Esepia, ava pɨhañemoñetasa sui osẽ pɨhañemoñeta raisa, yemboaguasasa, mondasa, porapichisa, ");
INSERT INTO gyrNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mendasa sui yemboaguasasa, mbahe pota raisa, teco raisa, porombopasa, mbahe tẽi pota raisa, mbahe rese ñemoɨrosa, ava rese ñemoñeta tẽisa, teco ɨvate aisa, pɨhañemoñetasa nihɨvi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Co mbahe opacatu naporai vahe yuvɨnose ava sui imboangaipa uca ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ichui Jesús osẽ oso tecua Tiro cotɨ. Aheve oique oɨ pɨpe, ndoyecua uca potai ava upe viña; ndoicatui rumo ava sui oñemi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Oime cuña vɨreco vahe omembrɨ cuñatai, ahe vɨreco caruguar oyese; ahe cuña oicuase Jesús recosa, oso voi sovai oñenopɨha. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ahe rumo ndahei judía, sirofenícia ɨguar ité. Ahe aipo ehi Jesús upe: “Enose che membrɨ sui caruguar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús rumo aipo ehi chupe: —Tahɨr judío rane toipɨsɨ mbahe yuvɨreco. Esepia, naporai yarocua pan tahɨr sui cave tohu imondo ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Co cuña aipo ehi: —Supi eté, che Yar, cave avei rumo ohuño ité pan rahɨcuer ovɨapi vahe tahɨr mesavrɨ pendar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aipo ihese, aipo ehi: —Avɨye ité nde ñehe. Eyevɨ eso. Caruguar osẽ nde membrɨ sui —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Co cuña oyepotase güẽtave, osepia omembrɨ supave; yɨpɨve rumo osẽ caruguar ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús oyevɨ oso Tiro ɨvɨ sui. Ipare osasa Sidón rupi oso, ambuae tecua eta Decápolis ɨvɨ rupi avei. Ichui oyepota ɨpa Galilea ve. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aheve mbɨa ndayapɨsai, iñehe ɨpɨtɨ-pɨtɨ vahe rerasosar: “Emondomi tẽi nde po iharɨve” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ichui Jesús vɨraso coi cotɨmi ava sui. Aheve ocuã omonde yapɨsa pɨpe. Ipare omondo güendɨ ñapecu rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ipare omahe ɨva rese, ipɨ̃tuhe pucu aipo ehi: “¡Efata!” ehi (‘timboisa’ ohesave aipo ehi). ");
INSERT INTO gyrNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ahe pɨpeve voi yapɨsa tuprɨ, oñehe tuprɨ avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","“Ndapemombehui chira ambuae upe” ehi ahe mbɨa upe. Ahe rumo oicua ucaño ité ambuae ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Evocoiyase ava oyembovɨha guasusave, aipo ehi yuvɨreco: “Avɨye ité rumo mbahe sembiapo. ¡Esepia, ndayapɨsai vahe omboapɨsa, iñehe ɨpɨtɨ-pɨtɨ vahe avei omoñehengatu tuprɨ!” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ñepei arɨ pɨpe setá ava oyemboya iri Jesús rese yuvɨreco. Ndipoi rumo mbahe icaru ãgua. Sese oñehe güemimbohe eta upe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Iparaɨsu catu co ava yuvɨreco cheu. Esepia, mbosapɨ arɨ yuvɨrecoi yande pɨri, iyavei ndipoi eté mbahe semihura. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Amondopase sẽtave sɨeporẽhɨ reseve, vɨrovɨapi-api tiẽtera tɨeporẽhɨ perɨ rupi yuvɨreco viña. Esepia, setami ava yugüeru amombrɨ sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Semibohe aipo ehi yuvɨreco chupe: —¿Mara yahera vo ava tohu mbahe mondo cohave ava porẽhɨsave? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ahe oporandu: —¿Mbovɨ vo pan pereco? —ehi. —Orovɨreco siete pan —ehi semimbohe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Evocoiyase, “Peguapɨ ɨvɨ harɨve” ehi ava rehɨi upe. Ahese oipɨsɨ siete pan, “Avɨye ndeu” ehi Tũpa upe. Ichui omboyaho-yaho pan imondo güemimbohe upe, semimbohe evocoiyase omondo ava rehɨi upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iyavei vɨreco movɨro pirami yuvɨreco, sese avei, “Avɨye ndeu” ehi iri Tũpa upe. Ichui güemimbohe upe, “Pemboyaho-yaho ava upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Opacatu ité ava ocaru vahe ihɨ̃taro yuvɨreco. Ipare rumo semimbohe omboapɨpo iri rane sumbɨrer siete ɨruova yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ava rehɨi ocaru vahe retacuer cuatro mil tuprɨ. Ipare Jesús, “Avɨye, peso tuprɨ” ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ipare voi eté yuvɨraso güemimbohe eta reseve carite pɨpe Dalmanuta ɨvɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ipare fariseo eta oyepota Jesús ñehe poepɨ-epɨ ãgua yuvɨreco. Jesús recoãha ãgua, oporandu ɨva pendar poromondɨisa rese ‘¿Tũpa sui eté pĩha ou?’ oya yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sese Jesús ipɨ̃tuhe pucu, aipo ehi: —¡Mahera vo co ava oipota ɨva pendar poromondɨisa che recocuer cua ãgua yuvɨreco! Namboyecuai chietera rumo que ñepei evocoi nungar mbahe pẽu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ipare oseyapaño ava. Ichui yuvɨroha iri carite pɨpe, osasapa ɨpa yuvɨraso sovai. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesús remimbohe sesarai pan sui yuvɨreco, ñepeimi tẽi pan vɨraso güemihura yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Evocoiyase Jesús aipo ehi: —Peicua catu fariseo iyavei Herodes pan mboapeposa sui —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aipo ehise, semimbohe: “Pan ndayaruise revo aipo ehi yandeu” ehi-ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ahe rumo oicua güemimbohe pɨhañemoñetasa, aipo ehi: —¿Mahera, “Pan ndayarui” peye? ¿Ndapeicua vɨtei vo che rembiapo? ¿Yavai vɨte tie seroya ãgua pẽu? ");
INSERT INTO gyrNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oime tẽi pe resa, ndapesepiai rumo; oime tẽi pe nambi, ndapesendui rumo mbahe. ¿Ndapeyemomahenduha iri vo ");
INSERT INTO gyrNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","acoi amboyaho-yahose cinco pan sui ava cinco mil vahe tohu? ¿Mbovɨ ɨruova vo acoi sumbɨrer pemonuha iri? —ehi. —Doce ɨruova —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Iyavei acoi amboyaho-yahose siete pan sui ava cuatro mil vahe tohu, ¿mbovɨ ɨruova vo acoi pemonuha sumbɨrer no? —ehi. —Siete ɨruova —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ipare aipo ehi: —¿Ndapesenducua vɨtei vo? —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Oyepotase Jesús tecua Betsaida ve, ahe ramoseve voi ogüeru ndasesapɨsoi vahe yuvɨreco chupe ‘epocomi tẽi sese’ oya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Evocoiyase oipopɨsɨ ndasesapɨsoi vahe seraso co cotɨmi tecua sui. Aheve omondo güendɨ sesa rese, omondo avei opo iharɨve. Ipare oporandu chupe: “¿Eresepia vo mbahe?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ndasesapɨsoi vahe omahese, aipo ehi: —Asepia ava inungar ɨvɨra oguata vahe yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Evocoiyase omondo iri opo sesa rese. Ipare co mbɨa omahe tuprɨ ité cute, ocuera ité, opacatu mbahe osepia tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ichui Jesús omondo sẽtave aipo ehi chupe: —Ereyevɨ iri eme tecuave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ipare yuvɨraso Jesús güemimbohe reseve ɨvɨ Galilea sui tecua Cesarea cotɨ, Filipo ɨvɨ rese. Perɨ rupi oporandu güemimbohe upe: —¿Mara ehi vo ava oñehe yuvɨreco che rese? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Semimbohe evocoiyase omboyevɨ yuvɨreco chupe: —Amove ava, “Juan Oporoãpiramo vahe” ehi yuvɨreco ndeu; ambuae evocoiyase, “Elías” ehi; ambuae, “Tũpa ñehe mombehusar mboetasa” ehi yuvɨreco ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Evocoiyase oporandu iri güemimbohe upe: —Pe no, ¿ava, “Co secoi” peye ru pe cheu no? —ehi. Pedro evocoiyase aipo ehi chupe: —Nde niha Tũpa Rembiporavo Poropɨ̃sɨrosar ereico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús rumo, “Pemombehui rene que ñepei ava upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Evocoiyase Jesús omboɨpɨ oporombohe: “Che, Ava Rɨquehɨr, che paraɨsu itera, iyavei opacatu judío rerecuareta, pahi rerecuar ɨvate catu vahe iyavei Moisés porocuaita rese oporombohe vahe remiamotarẽhɨ aicora. Ahe avei che yuca ucara yuvɨreco. Acuerayevɨra rumo mbosapɨ arɨ rupi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ahe omboyecua tuprɨ ité chupe. Evocoiyase Pedro vɨraso co cotɨmi chupe oñehengata ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Oyemboyere rumo, omahe güemimbohe eta rese, oñehengata Pedro upe aipo ehi: —¡Esɨrɨ che sui, Caruguar! Esepia, nde nandepɨhañemoñetai mbahe Tũpa upendar rese; ava nungar tẽi nde pɨhañemoñeta eico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Evocoiyase Jesús, “Perio” ehi güemimbohe upe, iyavei ambuae ava upe aipo ehi: —Acoi ava oguata pota vahe che rupi, topoi mbahe güemimbotar tẽi aposa sui, iyavei inungar-ra curusu rese ovosɨira viña, toyemoingatu voi che recocuer rese oparaɨsu ãgua iyavei toguata tuprɨ che rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Esepia, acoi ava güetecuer tẽi raɨsupar, ocañɨ tẽi etera. Acoi ava omocañɨ tẽi vahe rumo güetecuer che recocuer rese, ñehesa ñepɨsɨrosa sui avei, ahe oñepɨsɨrora. ");
INSERT INTO gyrNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Avɨye ai angahu pĩha ava upe opacatu mbahe ɨvɨ pɨpendar pɨsɨ ãgua tẽi, ahe ae tẽi omocañɨ güecocuer yuvɨreco viña? ");
INSERT INTO gyrNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Mbovɨ pĩha omondora ava güecocuer repɨrã viña? ");
INSERT INTO gyrNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Esepia, acoi ava yuvɨnochi ai vahe che sui iyavei che ñehengagüer sui ava angaipa viyar ndaseco tuprɨi vahe rovai, che avei, Ava Rɨquehɨr, ẽgüe ahera acoi ayevɨse che Ru reco pĩrata porañetesa pɨpe, sembiguai rehɨi ɨva pendar maranehɨ reseve curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ipare Jesús aipo ehi iri: —Supi eté, oimera amove cohave ava nomano vɨtei chivaherã, osepia rane itera ouse Tũpa mborerecuasa ipĩratasa pɨpe yuvɨreco curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis arɨ pare, Jesús vɨraso Pedro, Santiago, Juan reseve ɨvɨtrɨ ɨvate vahesave oyeupi. Aheve avɨyeteramo tẽi oñecuñaro güemimbohe rovai. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Iturucuar sendɨ́, morochí eteanga. Ndipoi eté que ava co nungar co ɨvɨ pɨpe turucuar oyosei vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iyavei avɨyeteramo tẽi oyemboyecua Elías, Moisés reseve Jesús rese oñemoñeta yuvɨnoha. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ipare Pedro aipo ehi chupe: —Ore mbohesar, ¡avɨye ai eté cohave yaico! Toroyapo mbosapɨ teyupami: ñepei ndeu nara, ambuae Moisés upe, ambuae evocoiyase Elías upe nara —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Osɨquɨye tẽi semimbohe yuvɨreco. Sese Pedro ndoicuaise oñehe ãgua, aipo ehiño tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ahe ramoseve avei ogüeyɨ ɨva quɨha iharɨve, oyopɨpa tuprɨ yuvɨreco. Ahe ipãhuve oyeendu ñehesa aipo ehi vahe: “Co che Rahɨr, che rembiaɨsu; peyapɨsaca catu iñehe rese” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ahe ramoseve avei omahese oɨvɨi yuvɨreco, ndosepiai eté que ambuae ava, Jesús güeraño tuprɨ ité osepia opãhuve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ipare ogüeyɨ ɨvɨtrɨ sui yuvɨreco, aipo ehi güemimbohe upe ou: “Ndapemombehui chietera que ñepei ava upe co mbahe pesepia vahe, pemombehura rumo acoi che, Ava Rɨquehɨr, acuerayevɨse voi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Oyeupeñomi tẽi vɨreco aipo ñehesa yuvɨreco, ahe rumo oporandu-randu oyeupe: “¿Mara oya pĩha aipo, ‘Acuerayevɨra’ ehise?” ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Evocoiyase semimbohe oporandu chupe: —¿Mahera ru Moisés porocuaita rese oporombohe vahe: “Elías rane rumo oura curi” ehi yuvɨreco? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Evocoiyase aipo ehi chupe: —Elías rane ité niha oura opacatu mbahe moingatu ãgua. ¿Mahera aracahendar icuachiaprɨ pɨpe aipo ehi: “Ava Rɨquehɨr oiporarara mbahe, yamotarẽhɨmbrɨ avei secoira” ehi? ");
INSERT INTO gyrNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Che niha aipo ahe pẽu: Elías rumo ou ité, ava evocoiyase opacatu güemimbotar tẽi oyapo yuvɨreco sese. Ẽgüe ehi opacatu yavɨye aracahendar icuachiapɨrer sese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ipare oyevɨ yuvɨreco güemimbohe recosave. Aheve osepia ava rehɨi oyere guasuse yuvɨreco sese, iyavei oime aheve Moisés porocuaita rese oporombohe vahe oiñehepoepɨ-epɨ semimbohe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ichui Jesús repiase, opacatu yuvɨnoña yuvɨraso chupe “avɨrave” apo. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Evocoiyase ahe oporandu ava eta upe: —¿Mbahe rese vo peporandu-randu peyeupe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ñepei ipãhu pendar omboyevɨ chupe: —Porombohesar, co aru che rahɨr ndeu, vɨreco vahe caruguar oyese, nomoñehengatu ucai vahe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iyavei que iguatasa rupi co caruguar avɨyeteramo tẽi opocose sese, oitɨ voi ɨvɨve iyavei sendɨrɨyuiyusu, sãitere-tere avei; sese cũritei nipirata iri eté. “Penosemi caruguar ichui” ahe tẽi nde remimbohe eta upe. Ahe rumo ndoicatui eté yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús omboyevɨ chupe: —¡Too, ndapeyeroya tuprɨ vɨtei eté che rese! ¿Mbovɨ rupi rutei vo aico vɨtera pe pãhuve che ñemosasa pɨpe? Peru evocoi chĩhivahe cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Evocoiyase ogüeru yuvɨreco chupe. Osepiase caruguar Jesús, oitɨ uca iri chĩhivahe ɨvɨve. Omboapayere-yere iyavei sendɨrɨyui guasu-guasu. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sese oporandu tu upe: —¿Mbahese vo na ehi chupe? —ehi. Tu evocoiyase aipo ehi: —Ichĩhivahemi suive ité. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Amove co caruguar oitɨ uca tatave, ɨve avei yuca pota uca ãgua yepi. Sese ereicatuse, ore pɨ̃tɨvɨiñomi tẽi catu eve ore paraɨsuerecosave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús aipo ehi chupe: —¡Mahera, “Ereicatuse” ere cheu! Acoi che rese oyeroya vahe upe opacatu mbahe yaposa —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aipo hese tu, —¡Orovɨroya niha, che pɨ̃tɨvɨi ru eve nde reroya catu ãgua! —ehi pĩrata chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Osepiase Jesús ava rehɨi, oyemboyase sese, oñehe pĩrata caruguar upe aipo ehi: —Caruguar noñehei vahe, ndayapɨsai vahe, che orocuai, epoi co chĩhivahe sui, ereique iri eme secocuer rese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Caruguar sãse pucu chĩhivahe yuca tuprɨ oso. “Omano ité co chĩhivahe” ehi ambuae ava yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús rumo oipopɨsɨ imopuha; evocoiyase chĩhivahe opũha tuprɨ voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ichui oique oɨ pɨpe. Aheve semimbohe ahe aemi oporandu yuvɨreco chupe: —¿Mahera pĩha ndoromose catui eté caruguar ichui? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús rumo aipo ehi güemimbohe upe: —Yeroquɨ iyavei yecuacu pɨpeño ité niha co nungar caruguar yaicatu imombo —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ichui yuvɨnosepase, yuvɨraso ɨvɨ Galilea rupi. Jesús rumo ndoyemboyecua uca potai eté que ambuae ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Esepia, güemimbohe güeraño ité ombohe aipo ehi: —Che, Ava Rɨquehɨr, imondoprɨ aicora che amotarẽhɨmbar povrɨve, che yuca aveira yuvɨreco, mbosapɨ arɨ rupi rumo acuerayevɨra —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Semimbohe rumo ndosenducuai eté oyeupe ñehesa yuvɨreco iyavei osɨquɨye chupe porandu ãgua yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ipare oyepota tecua Capernaum ve yuvɨreco. Yuvɨroiquese oɨ pɨpe, —¿Mbahe rese vo acoi peyeaca-aca peico perɨ rupi? —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ahe rumo noñehei tuprɨ yuvɨreco chupe. Esepia, perɨ rupi, “¿Ava pĩha ɨvate catu vahe?” ehi asɨ-asɨ oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Evocoiyase oguapɨsave, “Periopa” ehi güemimbohe upe, aipo ehi avei: —Oimese pe pãhu pendar oyemboɨvate ai vahe, ahe rumo seco ɨvɨ cotɨ catura opacatu sui ava eta pɨ̃tɨvɨi ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ipare oipɨsɨ chĩhivahe güemimbohe pãhuve senoha aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Acoi ava oipɨsɨ vahe co chĩhivahemi nungar che rer pɨpe sereco, che ité che pɨsɨ yuvɨreco; iyavei acoi ava che pɨsɨ vahe, ndahei che güeraño che pɨsɨ, oipɨsɨ aveira che mbousar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Evocoiyase Juan aipo ehi chupe: —Ore mbohesar, orosepia mbɨa nde rer pɨpe omombo vahe caruguar. Ahe rumo ndoguatai cũritei ore rupi; ore ité ndoroipotai chupe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús rumo, —Aní ẽgüe peye —ehi—. Esepia, ndipoi eté que ambuae oyapo vahe poromondɨisa che rer pɨpe, oicatu vaherã oñehe rai che rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sese ndayande amotarẽhɨi vahe, ahe yande mboyoyasar secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Acoi que omondo vahe ɨ vaso pɨpe che rupi pe recosa pɨpe pẽu, evocoi nungar oipɨsɨ itera porerecosa oyeupe nara —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Acoi que ava omboangaipa uca vahe co chĩhivahemi nungar che reroyasar, iyacatu evocoi nungar ñapɨchisa ita mbahe mbocuhisa iyesɨho rese para guasu pɨpe imombo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Sese pe po pe mboangaipa uca vahe peyasɨa ité peyesui. Esepia, avɨye catu peiquera tecove apɨrẽhɨsave ñepei pe po rese, peso rãgüer sui que ñuvɨrío pe po rese tata guasu apɨrẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aheve acoi uru nomanoi vahe, tata ndogüei vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pe pɨ pe mboangaipa ucase, peyasɨa avei peyesui. Esepia, avɨye catu ndape pɨndugüei peique tecovesave, que ñuvɨrío pe pɨ rese peique rãgüer sui tata guasu ndopai vahesave. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Aheve acoi uru nomanoi vahe, tata ndogüei vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pe resa avei pe mboangaipa ucase, penose ité peyesui. Esepia, avɨye catu peique ñepei pe resa rese Tũpa mborerecuasave que ñuvɨrío pe resa rese tata guasu apɨrẽhɨsave pe reique rãgüer sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aheve acoi uru nomanoi vahe, tata ndogüei vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Esepia, opacatu ava imoehesara tata nungar pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sese yucrɨ avɨye ai eté. Nasehe irise rumo, ndayaicatui chira imoehe iri ãgua. Peico catu yucrɨ nungar mbahe tuprɨ pɨpe peyeupe nara” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ipare Jesús osẽ tecua Capernaum sui, oso Judea ɨvɨ rupi ɨai Jordán rovai arɨ sẽsa cotɨ. Aheve ava rehɨi oñemonuha iri yuvɨreco sese. Iyavei ombohe iri ava güecocuer rupi tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Evocoiyase fariseo oyemboya seco rãha ãgua tẽi yuvɨreco sese, “¿Avɨye pĩha cuimbahe omenda vahe opoi güembireco sui?” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ahe rumo omboyevɨ chupe: —¿Mara ehi vo acoi Moisés porocuaita pɨpe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ahe evocoiyase omboyevɨ yuvɨreco chupe: —Moisés remimombehu aipo ehi: “Pemondora pe rembireco upe cuachiar poisa resendar pe poi ãgua pe rembireco sui” ehi —ehi fariseo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Evocoiyase fariseo upe aipo ehi: —Moisés omondo co porocuaita pe poreroyaẽhɨsa pɨpe sui pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yɨpɨsuive ité niha, ‘Tũpa oyapo opacatu mbahe, oyapo avei cuimbahe, cuña reseve. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sese niha cuimbahe omendase, oyepepɨra oyesupa sui güembireco rese ité yuvɨrecoi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Evocoiyase ñuvɨrío yuvɨrecoira ñepei ava nungar.’ Sese ndahe iri ñuvɨrío, ñepei nungar ité yuvɨrecoira. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Evocoiyase ava Tũpa omomenda vahe oyese, ndiyai ava tẽi omboyepepɨ yuvɨreco oyesui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Oɨve yuvɨrecoi vɨtese, semimbohe oporandu iri co mbahe rese yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Evocoiyase ahe aipo ehi: —Acoi opoi vahe güembireco sui omendase ambuae cuña rese, oyemboaguasa tẽi vahe güembireco sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Acoi cuña opoise omer sui omendase ambuae cuimbahe rese, ahe oyemboaguasa tẽi vahe avei —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ipare ogüeru chĩhivahe Jesús upe yuvɨreco sese ipoco ãgua. Semimbohe rumo, “¿Mahera vo peruño tẽi chĩhivahe?” ehi opɨha vɨ̃racuasa pɨpe serusar upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Evocoiyase Jesús osepiase, ndasorɨi güemimbohe upe aipo ehi: —¡Mahera ndapeipotai iyu ãgua! Toyugüeruño chĩhivahe cheu. Esepia, co chĩhivahe nungar ava yuvɨroiquera che Ru Tũpa mborerecuasave. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Supi eté, acoi ndoipɨsɨi vahe che Ru Tũpa mborerecuasa chĩhivahe nungar yuvɨreco, ahe evocoiyase ndoyuvɨroiquei chietera ipɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Evocoiyase oipɨsɨ, omondo opo iharɨve osovasa. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Oguata vɨtese Jesús yuvɨreco, aheseve mbɨa chĩhivahe oña oso sovai, oñenopɨha, oporandu chupe: —Porombohesar avɨye vahe, ¿mbahe vo ayapora tecovesa apɨrẽhɨ vahe rereco ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús evocoiyase aipo ehi ahe mbɨa upe: —¿Mahera vo, “Avɨye vahe” ere cheu? Oime rumo ñepei avɨye vahe ité, ahe Tũpa secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ereicua niha Tũpa porocuaita: ‘Ndereporoyucai chira, nandeaguasai chira, nandemondai chira, nanderemirai chira ambuae ava rese, ndereporombopai chira, eremboyeroyara nde ru, nde sɨ avei’ ehi vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ahe mbɨa rumo, —Porombohesar, che aipo nungar opacatu amboavɨye ité che chĩhivahe suive —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Evocoiyase omahe saɨsusave sese, aipo ehi chupe: —Ñepei mbahe rumo ipane vɨte ndeu: eso, emondopa rane nde mbahe; ahe seprɨ evocoiyase emondo ava iparaɨsu vahe upe. Ichui ererecora mbahe avɨye vahe ɨvave. Ipare ereguatara che rupi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Aipo oyeupe hese rumo, ahe mbɨa oyepepɨño ichui ovɨharẽhɨsave oso. Esepia, ahe mbahe yar ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Evocoiyase omahe oɨvɨindar güemimbohe rese, aipo ehi: —¡Yavai eté rumo ava mbahe yar reique ãgua che Ru Tũpa mborerecuasave! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Semimbohe evocoiyase, “¡Mara ehi rutei!” ehi tẽi iñehe renduse yuvɨreco. Ahe rumo omombehu iri: —Che rahɨreta, ¡yavai eté Tũpa mborerecuasave imbahe eta vahe reique ãgua ombahe eta rese tẽi ipɨhañemoñeta vahe upe! ");
INSERT INTO gyrNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yavai rai camello upe yucuar rupi seique ãgua, ava imbahe eta vahe upe rumo yavai catu che Ru mborerecuasave seique ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Aipo nungar renduse oyepɨhamondɨi guasu yuvɨreco. Oporandu-randu tẽi oyeupe yuvɨreco: “¿Ava angahu pĩha oñepɨsɨrora yuvɨreco viña?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Evocoiyase omahe güemimbohe rese aipo ehi: —Ava tẽi upe rumo yavai aipo nungar mbahe apo ãgua; Tũpa upe rumo ndayavaimi eté. Esepia, Tũpa opacatu mbahe mboavaisarẽhɨ secoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ipare Pedro aipo ehi: —Ore Yar, ore rumo oroseyapa opacatu ore mbahe nde rupi ore guata ãgua —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Omboyevɨ rumo Pedro upe: —Supi eté co aipo ahe pẽu: acoi che raɨsusa pɨpe iyavei ñehesa ñepɨsɨrosa raɨsusa pɨpe oseyapa vahe güẽta, vɨquehɨr, vɨvrɨ, güeindrɨ, vu, osɨ, guahɨr iyavei oɨvɨ, ");
INSERT INTO gyrNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ahe oipɨsɨra omahera co ɨvɨ pɨpe cien yupagüer rupi avei oɨ, vɨvrɨ, güeindrɨ, osɨ, guahɨr iyavei ɨvɨ. Yepe oiporarara mbahe-mbahe tẽi viña. Ipare rumo tecua ambuaeve oipɨsɨ aveira tecovesa apɨrẽhɨ vahe curi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Setá vai rumo cũritei yɨpɨndar vahe; ipa tẽira yuvɨrecoi. Setá aveira cũritei ipa tẽi vahe, yɨpɨndar yuvɨrecoira curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yuvɨrasose Jerusalén ve, Jesús tenonde secoi güemimbohe upe. Semimbohe rumo ndoyembovɨhai iyavei saquɨcuerindar osɨquɨye yuvɨreco. Aheve Jesús oñehe iri co cotɨmi güemimbohe doce yuvɨrecoi vahe upe. Ichui omboɨpɨ imombehu co mbahe-mbahe tẽi reime ãgua chupe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Peicua niha, yasora tecua Jerusalén ve, aheve rumo che, Ava Rɨquehɨr, che pɨsɨra che mondo pahi eta rerecuar iyavei Moisés porocuaita rese oporombohe vahe povrɨve yuvɨreco. Ahe, ‘Tomano’ ehira yuvɨreco cheu. Ipare che mondo aveira ava ndahei vahe yande mu upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mara ehi-ehi tẽira yuvɨreco cheu, ondɨvɨ-ndɨvɨra, oyuvɨrocua-rocuara che rese, che yuca aveira yuvɨreco. Mbosapɨ arɨ rupi rumo acuerayevɨra” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ipare oyemboyase Zebedeo rahɨr Santiago, Juan Jesús rese aipo ehi yuvɨreco chupe: —Ore mbohesar, oroipota ereyapo mbahe avɨye vahe oreu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ahe evocoiyase, —¿Mbahe vo peipota ayapo vaherã pẽu? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—Ore oroipota nde mborerecua porañetesave ore mboguapɨra ndeyepɨri eve, ñepei nde mbahe rese pocosa cotɨ, ambuae nde mbahe rese pocoẽhɨsa cotɨ —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Evocoiyase omboyevɨ: —Pe ndapeicuai mbahe rese pe porandu. ¿Peiporara catura pĩha che co mbahe-mbahe tẽi aiporara vaherã, inungar-ra que ɨgua iro vahe aɨhu vaherã viña? Iyavei, ¿peicatura pĩha che ãpiramosa aipɨsɨ vaherã pɨsɨ? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Taa, oroicatuño itera —ehi yuvɨreco. Evocoiyase ahe aipo ehi chupe: —Supi eté peɨhura co mbahe iro vahe, peipɨsɨ aveira ãpiramosa che aipɨsɨ vaherã nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Co rumo ndiyai cheu che pɨri pe guapɨ ãgua, che mbahe rese pocosa cotɨ, ambuae che mbahe rese pocoẽhɨsa cotɨ. Che Ru Tũpa omoingatu güembiporavo upe nara oguapɨ vaherã che ɨpɨve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Evocoiyase ambuae semimbohe diez yuvɨrecoi vahe iñehe renduse, oñemoɨro Santiago, Juan upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ahe rumo, “Perio” ehi opacatu upe. Ipare aipo ehi: —Peicua niha acoi mborerecuar guasu yuvɨrecoi vahe Tũpa cuaparẽhɨ oporocuai oporoyuca ai tẽisa pɨpe. Iyavei acoi ɨvate catu vahe oyeecoapɨrasá iteanga omborerecuasa pɨpe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pe rumo ẽgüe ndapeyei chira pe yeereco. Iyacatu rumo acoi ava oipota vahe ɨvate catu güeco ãgua pe pãhuve, ihañeco rane itera opacatu ambuae ava rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iyavei acoi pe pãhu pendar oipota vahe tenonde catu güeco ãgua, ihañeco tuprɨ ranera opacatu pe pãhu pendar rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aherã niha che, Ava Rɨquehɨr, ayu ndahei ava che rese ihañeco ãgua; che rumo ayu ava rese che hañeco ãgua, iyavei amondo vaherã che recocuer manosave ava eta repɨrã Caruguar povrɨ sui senose ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ipare oyepota tecua Jericó ve yuvɨreco. Ahe tecua sui yuvɨnosese güemimbohe reseve, ava rehɨi avei, aheve perɨ popɨve mbɨa ndasesapɨsoi vahe Bartimeo serer vahe, Timoteo rahɨr, oguapɨ oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Osenduse, “Jesús Nazaret pendar” hesa, osapucai pĩrata: —¡Jesús, David suindar, che paraɨsuerecomi tẽi eve! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ava rumo oyaca-yacaño, “¡Quiriri!” ehi yuvɨreco chupe. Ahe rumo, —¡David suindar, che paraɨsuerecomi tẽi eve! —ehi pĩrataño ité chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Evocoiyase osenduse iñehe, opɨta, —Peñehe chupe —ehi. Ichui oñehe yuvɨreco chupe: —Eyemonguerẽhɨ, epũha. Esepia, oñehe aipo ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aipo oyeupe he ramoseve, omomboño oturucuar guasu, opũha yesapɨha oso chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Evocoiyase oporandu ndasesapɨsoi vahe upe: —¿Mbahe vo ereipota ayapo vaherã ndeu? —ehi. Ahe evocoiyase, —Porombohesar, che mbosarecomi tẽira eve viña —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Evocoiyase aipo ehi ahe mbɨa upe: —Eso tuprɨño eico; erecuera niha. Esepia, ereyeroya ité che rese —ehi. Ahe ramoseve ndasesapɨsoi vahe osareco tuprɨ ité. Ipare osoño ité Jesús raquɨcuei perɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ovɨrovɨse tecua Jerusalén yuvɨraso, serovɨcave oime ñuvɨrío tecuami: Betfagé, Betania avei ɨvɨtrɨ Olivo ɨ̃pɨimi. Aheve Jesús omondo ñuvɨrío güemimbohe, ");
INSERT INTO gyrNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","aipo ehi chupe: —Peso evocoi tecuami yande rovaindarve. Peyepotase aheve, pesepiara guaricu ñapɨchimbrɨ imoha, ava ndoyeupi vɨtei vahe yuvɨreco sese, ahe peyorañora seru. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Acoi que ava: “¿Mahera vo ẽgüe peye?” ehise pẽu, “Ore Yar oiporu pota, ipare niha omboyevɨ voiñora” peyera chupe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Evocoiyase ahe yuvɨraso perɨ rupi. Aheve guaricu ñapɨchimbrɨ osepia imoha yuvɨreco oquendɨpɨve. Ichui oyoraño seru yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Evocoiyase ahe pendar ava, —¿Mbahe peyapo? ¿Mahera vo peyora guaricu? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ahe rumo Jesús ombohesa rupi tuprɨ ité omboyevɨ yuvɨreco chupe. Evocoiyase, “Tovɨrasoño” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ipare vɨraso guaricu Jesús upe, iyavei oturucuar omondo iharɨve yuvɨreco. Ahese Jesús oyeupi iharɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Setá ava oipɨpira oturucuar perɨ rupi, ambuae ava evocoiyase oyasɨa pindo omondo perɨ rupi saperã yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ava senonendar, saquɨcuerindar avei, —¡Imboeteiprɨ, sovasaprɨ tasecoi ou vahe yande Yar rer pɨpe! —ehi pĩrata yuvɨreco chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Sovasaprɨ yande ramoi David mborerecuasa tasecoi ou vahe oico! ¡Ɨvave imboeteiprɨ tasecoi! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ẽgüe ehi Jesús oiquese Jerusalén ve. Ipare oique tũparo pɨpe. Aheve opacatu rupi mbahe osepia. Ipare yuvɨraso Betania ve caharuse ité doce güemimbohe rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ahere ayihive, yuvɨnosese Jesús tecua Betania sui, ndasɨepoi oico. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Osepiase amombrɨ ɨvɨra higuera so atɨ vahe, oso chupe ‘¿iha pĩha?’ oyapave. Ahe rumo osepia so pãve tẽi sese. Esepia, ahe ɨvɨra upe ndosupitɨ vɨtei iha ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Evocoiyase aipo ehi ahe ɨvɨra upe: —¡Co pɨpe suive ndipo iri chira ava nde ha yuvɨrohu vaherã! —ehi. Semimbohe osendu iñehe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ipare oyepota Jerusalén ve yuvɨreco. Aheve Jesús oiquese judío tũparo guasu pɨpe, omboɨpɨ ava mbahe mondosar, mbahe rerocuasar mombopa tuprɨ ocarve oico iyavei ava guarepochi recuñarosar opa ombovapɨ mesa imondo, apɨcasu mondosar renda avei ombovɨapi imondo. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ndoipotai eté que ambuae mbahe seroiquepɨrã tũparo pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ipare oporombohe aipo ehi: —Icuachiaprɨ aracahendar pɨpe aipo ehi: ‘Co che rẽta yeruresa rẽtarã opacatu ava ɨvɨ pɨpendar uve nara’ ehi. Pe rumo imonda rai vahe rẽta nungar tẽi pereco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pahi eta rerecuar iyavei oporombohe vahe Moisés porocuaita rese osenduse, “¿Mara yahera pĩha sereco yuca uca ãgua?” ehi voi yuvɨreco chupe. Osɨquɨye rumo opacatu ava sui. Esepia, ahe ndoyembovɨhai iporombohesa rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pɨ̃tu ramomise, Jesús yuvɨnose güemimbohe eta reseve yuvɨraso ahe tecua sui. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ahere ayihive, añihiveive yuvɨrasose, osepia ɨvɨra higuera sapo suive ipirupa vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Evocoiyase Pedro oyemomahenduha voi iñehe agüer rese, sese aipo ehi Jesús upe: —Ore mbohesar, esepia co ɨvɨra higuera upe ereñehe rai vahecuer, opa ité ipiru —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús evocoiyase, —Peyeroya Tũpa rese —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Supi eté aipo ahe pẽu: acoi que ava ɨvɨtrɨ upe: ‘Esɨrɨ ave sui, eso para guasu pɨpe’ ehi vahe oyeroya tuprɨse ité aipo hesa rese, ẽgüe ehi etera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sese aipo ahe pẽu: opacatu que mbahe rese peporanduse pe yeroquɨsa pɨpe, peyeroya itera mbahe oime vaherã rese pẽu, ahese peipɨsɨ itera. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Acoi peyeroquɨse, yɨpɨndar peñero rane que pe amotarẽhɨmbar upe, ahese ẽgüe ehi aveira pe Ru ɨva pendar iñero pe angaipa rese pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ẽgüe ndapeyeise, pe Ru ɨva pendar avei niñeroi chira pe angaipa rese pẽu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ipare oyevɨ Jerusalén ve yuvɨreco. Aheve Jesús secoise judío tũparo guasu pɨpe, pahi eta rerecuar, Moisés porocuaita rese oporombohe vahe, ava rerecuar guasu avei oyemboya yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aheve oporandu yuvɨreco chupe: —¿Ava nde cuaita pɨpe vo ereyapo co nungar eico? ¿Ava vo ombou nde mborerecuarã ndeu co nungar apo ãgua? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Evocoiyase omboyevɨ chupe: —Che avei aporandura mbahe rese pẽu: ¿Ava vo Juan ombou ava ãpiramo ãgua; Tũpa pĩha, ava tẽi tie? Pemboyevɨse cheu, ahese che avei amombehura pẽu ava porocuaita rupi eté pĩha ayapo co mbahe vichico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Evocoiyase oñemoñeta aipo ehi oyeupe yuvɨreco: “ ‘Tũpa ombou’ yahese chupe viña, ahe evocoiyase: ‘¿Mahera ru ndaperoyai?’ ehira yandeu. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Ava tẽi remimbou’ ndayahei chiaveira chupe” ehi. Ahe osɨquɨye tẽi ambuae ava sui yuvɨreco. Esepia, opacatu ité oicua Juan oñehe Tũpa suindar ñehesa rese yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Evocoiyase omboyevɨ chupe yuvɨreco: —Ndoroicuai eté Juan mbousar —ehi. Ahese ahe aipo ehiño chupe: —Sese che avei, “Ahe iporocuaita pɨpe co mbahe ayapo” ndahei chietera pẽu —ehi mborerecuar guasu upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Evocoiyase Jesús omboyoya tecocuer ambuae ava recocuer rese aipo ehi: “Oime mbɨa oñotɨ vahe uva oɨvɨ pɨpe, ahe oñachi tuprɨ sereco iyavei oyapo mbahe uva rɨcuer renose ãgua. Oyapo avei oɨ ɨvate vahe opacatu mbahe moha ãgua. Ipare oseya oɨvɨ ava oporavɨquɨ vahe upe iporu ãgua. Ichui osẽ, oso amombrɨ vahesa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Oyepotase arɨ uva pohosa, ahese omondo güembiguai oporavɨquɨ vahe upe imboporandu ‘tomboumi uva pohoprɨ cheundar cheu cute’ oyapave viña. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ahe rumo oipɨsɨño, inupa-nupa imboyevɨ tuprɨ tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Evocoiyase ahe ɨvɨ yar omondo iri ambuae güembiguai. Ahe oyapicha-pichaño ñaca rupi, iñehe mara-mara tẽiño avei yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ipare omondo iri ambuae. Ahe oyucaño yuvɨreco. Ichui omondo atɨ iri tẽi. Ahe ipãhu pendar rese yuvɨrocua-rocuaño yuvɨreco, oyucaño avei ambuae yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Iyavei ñepei opɨta vɨte, tahɨr ité, sembiaɨsu. Ahe omondo ipa ‘co omboyeroyara yuvɨreco’ oyapave viña. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Oporavɨquɨ vahe rumo aipo ehi oyeupe yuvɨreco: ‘Co aipo oipɨsɨra vu mbahe. Yayucaño, yandeu nara pãve topɨta co ɨvɨ’ ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ichui oipɨsɨ, oyucaño yuvɨreco. Ipare ovɨnose sehõgüer ahe mitɨ sui co cotɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Mbahe vo evocoiyase oyapora ɨvɨ yar? Osora chupe, opara oyuca oporavɨquɨ vahe, iyavei omondopara oɨvɨ ambuae ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Ndapeyeroquɨi vo pe co icuachiaprɨ pɨpe? Aipo ehi niha acoi: ‘Co ita oɨ aposar opaño omombo yuvɨreco. Ahe ita rumo avɨye catu vahe oɨ movɨracua tuprɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ẽgüe ehi niha yande Yar yapo. ¡Mara ehi rutei revo!’ ehi icuachiaprɨ pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Evocoiyase ovɨraso pota voi Jesús soquenda ãgua yuvɨreco. Esepia, ahe osenducua ité oyesendar iporombohesa yuvɨreco. Ava sui osɨquɨyepave rumo opoiño yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ipare mborerecuar omondo fariseo iyavei mborerecuar Herodes rupindar avei Jesús upe ‘toyavɨ angahu oñehe’ oya yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ahe yuvɨraso chupe aipo ehi: —Porombohesar, ore oroicua nde supi eté vahe mbahe eremombehu eico, nde niha ndereroyai vahe ava ñehesa tẽi. Esepia, “Ẽgüe ehi co mbɨa” nderei eté ava upe iyavei ereporombohe mbahe supi tuprɨ vahe Tũpa remimbotar apo ãgua rese. ¿Avɨyera pĩha yamondo guarepochi rese oporanduse Roma pendar mborerecuar ɨvate catu vahe upe viña, aní tie? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Oicua ité rumo fariseo pɨhaẽhɨsa, sese aipo ehi voi chupe: —¿Mahera che moingue pota mbahe tẽi pɨpe peye? Peru evocoiyase ñepei guarepochi cheu, tasepia —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ipare fariseo güeru yuvɨreco chupe, ahe guarepochi repiase, oporandu chupe: —¿Ava rahanga vo co chini sese, iyavei ava rer vo co chini sese no? —ehi chupe. —Roma pendar mborerecuar guasu —ehiño fariseo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Evocoiyase aipo ehi fariseo upe: —Pemondora mborerecuar upe mbahe chupendar; Tũpa upendar mbahe evocoiyase pemondora Tũpa upe —ehi. Evocoiyase oyepɨhamondɨi tẽi aipo oyeupe hese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Evocoiyase saduceo “ndipoi eté cuerayevɨsa” ehi vahe yugüeru Jesús upe. Oporandu tẽi angahu yuvɨreco chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Porombohesar, Moisés niha oseya güembicuachiagüer yandeu aipo ehi: “Que cuimbahe omenda vahe omanose guahɨẽhɨseve, tɨvrɨ evocoiyase omendara sembirecocuer rese ahe vɨquehɨr omano vahecuer upe nara tahɨra oico.” ");
INSERT INTO gyrNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oime siete tuprɨ oyesuindar pãve yuvɨrecoi vahe. Yɨpɨndar vahe omenda. Ichui omanoño, ndatahɨi eté rumo. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ipare tɨvrɨ omenda vɨquehɨr rembirecocuer rese. Ahe rumo omanoño, ndatahɨi avei rumo. Ẽgüe ehi tuprɨ avei tɨvrɨ imombosapɨsa. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ẽgüe ehi co siete tuprɨ omenda ahe cuña rese, ndatahɨi eté rumo yuvɨreco. Coiye rumo cuña omano avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Evocoiyase opase ocuerayevɨ yuvɨreco, ¿uma rembireco itera pĩha? Esepia niha, siete tuprɨ ité omenda tẽi yuvɨreco sese —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Evocoiyase Jesús omboyevɨ chupe: —Pe pɨhañemoñeta pɨpe peyavɨ. Esepia, ndapeicuai eté Tũpa ñehe icuachiaprɨ aracahendar, ndapeicuai avei Tũpa pĩratasa. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Supi eté omano vahe ocuerayevɨse, chupe ndipo iri chira mendasa. Ahe rumo Tũpa rembiguai ɨva pendar nungar yuvɨrecoira ɨvave. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Co cuerayevɨsa resendar rumo amombehura pẽu: avɨye ndapeyeroquɨi anga vahe Moisés rembicuachiagüer pɨpe, acoi caha rese sendɨ guasu vahe avɨterve Tũpa aipo ehise chupe: ‘Che Abraham, Isaac, iyavei Jacob Tũpa aico’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Tũpa ndahei omano vahecuer Tũpa! ¡Ahe rumo oicove vahe Tũpa secoi! Sese pe pɨhañemoñeta pɨpe peyavɨ —ehi saduceo yuvɨrecoi vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ñepei Moisés porocuaita rese oporombohe vahe osendu iñehe pĩratase oyeupe yuvɨreco, oicua avei Jesús omboyevɨ tuprɨse iñehe yuvɨreco chupe, evocoiyase oyemboya sese oporandu chupe: —¿Uma vo porocuaita avɨye catu vahe opacatu sui? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús omboyevɨ chupe: —Yɨpɨndar mborocuaita avɨye catu vahe aipo ehi: ‘Pesendu Israel: yande Yar Tũpa aheño ité ñepei yande Yar secoi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Eresaɨsura nde Yar Tũpa opacatu nde pɨhá pɨpe, opacatu nde recocuer pɨpe, opacatu nde yapɨsacasa pɨpe iyavei opacatu nde pĩratasa pɨpe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iyavei imoñuvɨriosa porocuaita ahe co: ‘Eresaɨsura ambuae ava nde yeaɨsu nungar’ ehi. Ndipo iri ambuae porocuaita avɨye catu vahe co sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Evocoiyase porocuaita rese oporombohe vahe aipo ehi chupe: —Avɨye tuprɨ ité aipo nde ñehe, Porombohesar. Supi eté aipo ere oime ñepei Tũpa iyavei ndipoi eté ambuae. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iyavei yasaɨsura Tũpa opacatu yande pɨhá pɨpe, opacatu yande yapɨsacasa pɨpe, opacatu yande pĩratasa pɨpe, iyavei yasaɨsura ava yande yeaɨsu nungar. Ahe ité avɨye catu mbahe seropovẽheprɨ sui iyavei opacatu porerecosa sapɨprɨ tẽi sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Evocoiyase Jesús icuase co ava pɨhañemoñeta tuprɨsa, aipo ehi chupe: —Namombrɨimi ereico Tũpa mborerecuasa sui —ehi. Ipare ndipo iri oyemonguerẽhɨ vahe oporandu vaherã mbahe rese yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús oporombohese tũparo pɨpe aipo ehi: —¿Mahera ru Moisés porocuaita rese oporombohe vahe: “Poropɨ̃sɨrosar David suindar ité” ehi yuvɨreco? ");
INSERT INTO gyrNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Esepia, David ité aipo ehi Espíritu Santo pĩratasa pɨpe: ‘Yar aipo ehi che Yar upe: Eguapɨ che acato cotɨ, acoi che amondose voi eté nde amotarẽhɨmbar nde povrɨve yuvɨreco’ ehi David aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Mahera ru, “Poropɨ̃sɨrosar David suindar secoira” peye, David teieté, “Che Yar” ehise chupe? —ehi. Ava rehɨi oquerẽhɨsave ité osendu Jesús ñehe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús aipo ehi oporombohesave: “Peicua catu Moisés porocuaita rese oporombohe vahe sui. Esepia, ahe oturucuar ipucu vahe rese oguata pota rai yuvɨreco yepi, iyavei oipota oyeupe ‘avɨrave’ apo ãgua ocar rupi omboeteisa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Oseca avei tenda porañete catu vahe güenara otũparo pɨpe yuvɨreco yepi, iyavei carusave tenda avɨye catu vahesave oguapɨ yuvɨreco yepi no. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iyavei cuña imer mano vahecuer rẽta vɨrocua-rocua tẽi ichui. Oarondaguã tẽi avei oyeroquɨ pucu-pucu yuvɨreco. Ahe rumo oipɨsɨra Tũpa ñemoɨrosa ipĩrata catu vahe yuvɨreco curi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ñepei arɨ Jesús oguapɨ oĩ porerecosa rɨru rovai ava repia ãgua mara ehi oporerecosa imondo ipɨpe yuvɨreco. Aheve setá mbahe yar omondoño ité guarepochi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ahe pɨpeve oyepota cuña imer mano vahecuer iparaɨsu vahe. Ahe avei omondo ñuvɨriomi guarepochi oporerecosa ipɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Evocoiyase Jesús oñehe güemimbohe upe aipo ehi: —Supi eté che aipo ahe pẽu: co cuña imer mano vahecuer iparaɨsu vahe setá catu guarepochi oporerecosa omondo ambuae ava eta sui co guarepochi rɨru pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ambuae ava eta rumo oguarepochi rumbɨrermi tẽi omondo oporereco ãgua yuvɨreco; co cuña rumo oparaɨsusa pɨpe opa ité omondo oguarepochi —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús osẽse tũparo guasu pɨpe sui, ahese ñepei semimbohe aipo ehi chupe: —Ore mbohesar, ¡esepia oɨ ita imopuhaprɨ, icatuprɨ ai! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús rumo omboyevɨ chupe: —¿Pesepia co oɨ tuvichá vahe ité? Ndipoi chietera rumo que ñepei ita oyeha vɨte vahe; opacatu ité imondurusara curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Evocoiyase Jesús yuvɨraso ɨvɨtrɨ Olivo ve, ahe ɨvɨtrɨ tũparo guasu rovai tuprɨ. Aheve Jesús oguapɨse oĩ, Pedro, Santiago, Juan iyavei Andrés oporandu co cotɨmi mbahe rese yuvɨreco chupe: ");
INSERT INTO gyrNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“¿Mbahese vo aipo mbahe yavɨyera? ¿Mbahe poromondɨisa rese rane vo icuasara?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús rumo omboyevɨ chupe: “Peicua catu, peyembopa ucai rene ambuae ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Esepia, setá ava yugüerura, ‘Che niha Poropɨ̃sɨrosar aico’ ehi tẽira ava eta mbopa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Pesenduse rumo ñehesa vavasa resendar cohave, iyavei que rupi, ndapeyembosɨquɨyei chietera. Esepia niha, ẽgüe ehi rane itera; ndehi vɨtei chira rumo arɨ cañɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Esepia, ñepei ɨvɨ pɨpendar ovavara ambuae ɨvɨ pɨpendar rese oyeupe yuvɨreco; iyavei oimera ɨvɨ rɨrɨi opacatu-catu tẽi tecua rupi, tɨavor avei. Co rumo omboɨpɨ ramomira mbahe tẽi porarasa. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Peñearo catu. Esepia, pe rerasora mborerecuar rovai yuvɨreco, iyavei pe nupara tũparove yuvɨreco. Pe reraso aveira mborerecuareta rovai, iyavei mborerecuar ɨvate catu vahe rovai che recocuer sui tẽi yuvɨreco. Ẽgüe peyera peñehe che recocuer rese chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Cañɨ renonde rumo co ñehesa pɨ̃sɨrosa resendar opacatu rane ité ava upe icua ucasara ɨvɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Iyavei, ‘¿Mbahe pĩha amombehura chupe?’ ndapeyei chira pe mondose mborerecuar rovai yuvɨreco. Aheve voi eté omboyecuara Tũpa pe ñehe ãgua pẽu. Esepia, ndahei chira peyesui tẽi peñehe, Espíritu Santo ité oñehera. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ipare rumo ava omondoñora vɨvrɨ yamotarẽhɨsar upe ‘toyuca yuvɨreco’ oya. Ẽgüe ehi aveira ava guahɨr upe; tahɨr avei oyamotarẽhɨñora oyesupa yuca uca ãgua yuvɨreco che recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Opacatu avei ava ndape ambotai chira che recocuer sui tẽi yuvɨreco. Acoi ava oyemovɨracua vaheño rumo arɨ ipa vahe rupi, ahe ipɨ̃sɨroprɨ yuvɨrecoira. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Tũparo guasu maranehɨ pɨpe pesepiase mbahe-mbahe tẽi aposa —acoi oyeroquɨ vahe, ahe tosenducua tuprɨ yuvɨreco—, evocoiyase acoi yuvɨrecoi vahe ɨvɨ Judea rupi, toñemipa poyava ɨvɨtrɨ rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Acoi güẽta harɨve secoi vahe, ahe arɨ toique iri eme güẽtave mbahe renose ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Acoi que rupi tẽi secoi vahe, toyevɨ eme avei güẽtave oyeaosa renose ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Iparaɨsu itera cuña ipuruha vahe ahe arɨ pɨpe, imembɨ pĩtani vahe avei! ");
INSERT INTO gyrNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Peporandu Tũpa upe, toime eme co nungar mbahe sõhɨsa vahe pɨpe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Esepia, ahe arɨ pɨpe ava iparaɨsu catura opacatu yɨpɨve ava ɨvɨ apo ramo suive yuvɨrecoi vahe sui; ipare ndipo iri chietera evocoi nungar. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iyavei yande Yar nomombɨtuhuise arɨ naporai vahe, ndipoi chietera oñepɨsɨro vahe yuvɨreco viña; ahe rumo güembiporavo raɨsusa pɨpe omombɨtuhura. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Que oimese aipo ehi vahe: ‘Esepia, co Poropɨ̃sɨrosar secoi’ ehi, anise, ‘Peve secoi’ ehise yuvɨreco pẽu, aní chira peroya aipo ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Esepia, yugüerura ava, ‘Che Poropɨ̃sɨrosar aico’ ehi tẽi vahe, iyavei, ‘Che amombehu vahe Tũpa Ñehengagüer’ ehi angahu tẽi vahe, iyavei oyapora mbahe ava ndoyapoi vahe poromondɨisa güeco pĩratasa mboyecua ãgua yuvɨreco. Avɨyeteramo ombopa aveira ava Tũpa reroyasar. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Peicua catura! opa aipo co senondeve amombehu pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ahe arɨ pɨpe rumo co mbahe-mbahe tẽi pare ndoyecua iri chira arɨ, yasɨ avei ndosesape iri chira, ");
INSERT INTO gyrNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","yasɨtata avei opara ovɨapi ɨva sui, iyavei ɨva resendar mbahe orɨrɨira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ahese che, Ava Rɨquehɨr, ɨva quɨha rese ayecua itera vitu che pĩratasa pɨpe che rendɨgüer porañetesa pɨpe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ipare amboura che rembiguai eta ɨva pendar. Ahe evocoiyase omonuhara opacatu ɨvɨ rupindar che rembiporavo yuvɨreco, que amombrɨ rupi yuvɨrecoi vahe, que ɨva rese yuvɨrecoi vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Peyembohera ɨvɨra higuera recocuer sui: co ɨvɨra soquɨ ramose, yaicua cõimi arɨ sacu vahe yepota ãgua yandeu yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na ehi aveira niha pẽu che ñehe rupi tuprɨ mbahe pesepiase. Sese peicuara che, Ava Rɨquehɨr, cõimi eté che yevɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Supi eté yuvɨrecove vɨtera ava osepia vahe, co mbahe opase yavɨye. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ɨva, ɨvɨ opara ocañɨ; che ñehengagüer rumo imboavɨyesa rane itera. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ndipoi eté rumo ava oicua vahe arɨ iyavei hora che yevɨ ãgua yuvɨreco, che Ru rembiguai ɨva pendar avei ndoicuai yuvɨreco, che avei ndaicuai eté. Che Ru güeraño ité rumo oicua. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Sese niha pemahemohara yepi, che rãrora peye. Esepia niha, ndicuasai che yevɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Inungar que mbɨa amombrɨ oso pota ãgua renonde, güembiguai oseyapa güẽta rãro ãgua, omondo avei ñepei-pei upe iporavɨquɨ ãgua, iyavei omondo güẽta roquendɨpɨ rãro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pe evocoiyase pemahemohara. Esepia, ndapeicuai marase che oɨ yar ayevɨra pẽu, avɨyeteramo pɨ̃tu ramose, pɨ̃tu mbɨter, tacura ñehese, anise añihivei. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ndaipotai pemahemohaẽhɨseve tẽi ayevɨra. ");
INSERT INTO gyrNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Che aipo ahe pẽu, opacatu upe avei: ¡Pemahemohaño ité yepi!” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ipare ñuvɨrío arɨ judío Pascua pieta ãgua ipane, ahe pieta pɨpe yuvɨrohu pan ndayapepoi vahe yepi, pahi rerecuareta, Moisés porocuaita rese oporombohe vahe avei oyemomborandu: “¿Mara yahera Jesús mbopa ipɨsɨ yuca ãgua?” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ambuae rumo aipo ehi yuvɨreco: —Ndiyai pieta pɨpe ité yaipɨsɨ ava rehɨi yemondɨiẽhɨ ãgua yandeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ahese Jesús secoi Betania ve Simón lepra vɨreco vahecuer rẽtave. Aheve mesave chiniseve, cuña güeru mbahe sɨ̃acua vahe sɨru reseve sepɨ́ iteanga vahe. Ahe osovapɨsa rerocua, ipare oipɨyere Jesús ãca rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ambuae ava aheve yuvɨnoi vahe rumo oñemoɨro tẽi aipo ehi yuvɨreco oyeupe: —¿Mahera vo co omocañɨ tẽi mbahe sɨ̃acua vahe? ");
INSERT INTO gyrNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Omondo vahe ité tie co tresciento arɨ rupindar mboravɨquɨ reprɨ rupi ava iparaɨsu vahe pɨ̃tɨvɨi ãgua viña —ehi yuvɨreco. Omañeco tẽi avei ahe cuña yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús rumo aipo ehi ahe ava upe: —Teheni, ẽgüe tehiño, ¿mahera vo pemañeco tẽi? Co mbahe oyapo vahe rumo cheu avɨye ité. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ava iparaɨsu vahe niha yuvɨrecoiño itera pe pãhuve, iyavei peyapoño itera mbahe avɨye vahe peyapo potase chupe; che rumo ẽgüe ndahe vɨteñoi chira vichico pe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iyavei co cuña oyapo mbahe ocatugüer rupi; opa voi omoɨacua che rete che manoẽhɨ vɨteseve. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Supi eté aipo ahe pẽu: ñehesa pɨ̃sɨrosa resendar mombehuse opacatu tecua rupi, imombehusa aveira co cuña rembiapo sese mahenduha ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Evocoiyase Judas Iscariote, semimbohe doce vahe pãhu pendar, oso pahi eta rerecuar upe imoñeta Jesús mondo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Senduse, oyembovɨharete: “Yamondo guarepochi chupe” ehi voi eté yuvɨreco. Evocoiyase Judas oseca voi Jesús mondo ãgua yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Yɨpɨndar arɨ pan ndayapepoi vahe husa pɨpe, ahese avei ovesa Pascua resendar yucaprɨ seropovẽhesa yepi, ahe arɨ pɨpe semimbohe oporandu Jesús upe yuvɨreco: —¿Que vo ereipota oromoingatura carusa Pascua pieta resendar yandeu? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Aipo oyeupe hese, omondo ñuvɨrío güemimbohe, aipo ehi chupe: —Peso tecuave. Aheve pesepiara mbɨa vɨreco vahe cambuchi pɨpe ɨ. Supi pesora, ");
INSERT INTO gyrNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","seiquesave aipo peyera sẽta vahe upe: ‘Ore mbohesar oporandu: ¿Uma oɨ pɨpe vo Pascua pieta resendar orohura che remimbohe reseve? ehi’ peyera. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Evocoiyase ahe omboyecuara oɨ guasu ɨvatendar imoingatuprɨ pẽu. Aheve pemoingatu mbahe yahu vaherã —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Evocoiyase semimbohe yuvɨraso tecuave. Aheve semimombehu rupi tuprɨ osepia mbahe yuvɨreco. Ichui omoingatu carusa Pascua pieta resendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Pɨ̃tu ramomise, Jesús doce güemimbohe rese aheve oyepota yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iyavei ocaruse ité mesave yuvɨnoi, güemimbohe upe aipo ehi: —Supi eté aipo ahe pẽu: ñepei pe pãhu pendar yande pɨri ocaru vahe che mondora che amotarẽhɨmbar upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Evocoiyase semimbohe ndoyembovɨhai tẽi yuvɨreco, iyavei oporandu-randu tẽi ñepei-pei chupe yuvɨreco: —¿Che pĩha? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Omboyevɨ rumo güemimbohe upe: —Ñepei eté pe pãhu pendar ahe co omoaquɨ pan che caro pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Supi eté che, Ava Rɨquehɨr, amboavɨyera icuachiaprɨ; ¡iparaɨsu catura rumo acoi mbɨa che mondosar! Avɨye catura ahe mbɨa ndoyesuise viña —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yuvɨrocaru vɨteseve, Jesús oipɨsɨ pan, “Avɨye ndeu” ehi Vu upe. Aipo ohe pare, ombohi-mbohi imondo güemimbohe upe aipo ehi: —Peipɨsɨ; co che rete —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ipare oipɨsɨ ɨgua rɨru, “Avɨye ndeu” ehi Vu upe. Aipo ohe pare omondo güemimbohe upe, ipare opacatu yuvɨroɨhu. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ahese aipo ehi: —Co che ruvɨ, ahe che Ru remimbotar ipɨasu vahe pẽu nara. Oyepɨyerera ava rehɨi recocuer rese nara. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Supi eté aipo ahe pẽu: ndaɨhu iri chietera uva rɨcuer cheu arɨ oyepotase voi che Ru Tũpa mborerecuasave aɨhura uva rɨcuer ipɨasu vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Osapucaire, opa yuvɨraso ɨvɨtrɨ Olivo ve. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ahese Jesús aipo ehi: —Opara pemocañɨ che rese yeroyasa peyesui. Esepia, acoi icuachiaprɨ pɨpe aipo ehi: ‘Ayucara ovesa rãrosar, ahese oñemosai tẽira ovesa opacatu rupi yuvɨreco’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Che cuerayevɨre rumo aso voi etera pe renonera Galilea ve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Evocoiyase Pedro aipo ehi chupe: —Yepe ambuae opacatu nande reroya iri chira yuvɨreco, che rumo ẽgüe ndahei chietera —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aipo ehi rumo Pedro upe: —Che rumo supi eté aipo ahe ndeu: co pɨ̃tu pɨpeve voi eté tacura ñehe yupagüe renondeve, “Ndaicuai vahe evocoi mbɨa” erera mbosapɨ oyupagüer rupi cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ahe rumo, —Yepe che amano tẽira nde rupi viña, che rumo, “Ndaicuai vahe evocoi mbɨa” ndahei chietera —ehi-ehi catuño ité chupe. Ambuae opacatu aipo ehi tuprɨ tẽi avei yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ipare yuvɨraso Getsemaní ve yuvɨreco. Aheve Jesús aipo ehi güemimbohe upe: —Peguapɨ cohave, che aso ranera ayeroquɨ peve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aheve vɨraso Pedro, Santiago, Juan oyeupi. Ahese ndoyepɨhambovɨhai eté oico ");
INSERT INTO gyrNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","aipo ehi: —Che cũritei ndavɨhai eté. Esepia, che hã oyandu ité manosa. Pepɨta rane cohave, iyavei pemahemohara pe yeroquɨ pɨpe —ehi güemimbohe vɨraso vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Evocoiyase oso tenonde catumi. Aheve oyaɨvɨ ɨvɨ rese oso, oporandu Tũpa upe mbahe tasɨ vahe reimeẽhɨ ãgua oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Oyeroquɨ pɨpe aipo ehi: “Che Ru, che rembiaɨsu, ndeu niha mbahe ndayavai vahe ité: che renose co mbahe-mbahe tẽi sui eve; tayapo eme che remimbotar tẽi, nde remimbotar rupi catu tayapo” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ipare oyevɨ güemimbohe upe. Ahe rumo opaño yuvɨroque yuvɨrocua. Ahese aipo ehi Pedro upe: —Simón, ¿ereque? ¿Ndereñemosai eté vo que ñepei hora nde ropesɨi upe? ");
INSERT INTO gyrNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pemahemoha, peyeroquɨ mbahe tẽi pɨpe pe vɨapiẽhɨ ãgua. Pe niha pequerẽhɨ ité viña, pe retecuer tẽi rumo nipiratai pẽu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ichui oso iri oyeroquɨ, aipo ehi tuprɨ avei oñehe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ipare oyevɨse, osesapɨha iri iqueseve tẽi avei. Esepia, sopesɨi nomboyeroyai eté yuvɨreco, ahese ndoicatui eté iñehe mboyevɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Imombosapɨsa rupi oso irise aipo ehi chupe: —¡Pequeño vɨte vo peyu! Avɨye revo peque. Osupitɨ ité che, Ava Rɨquehɨr, mondo ãgua ava yangaipa vahe povrɨve. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pepũha, yaso. Esepia, cõimi eté che amotarẽhɨsar upe che mondo vaherã secoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús oñehe vɨteseve ohã, Judas oyepota oso chupe, ahe doce pãhu pendar semimbohe, iyavei setá ava yugüeru quɨse pucu, ɨvɨra reseve-seve supi. Ahe pahi eta rerecuar, Moisés porocuaita rese oporombohe vahe, judío rerecuareta porocuaita rupi oyapo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yɨpɨndar rumo imondosar Judas aipo ehi: “Asovaupɨte vahe rese peicuara. Ahe peipɨsɨ tuprɨ itera seraso” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Oyepotase Jesús upe, oyemboya voi oso sese aipo ehi chupe: —¡Porombohesar! —ehi sovaupɨte. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ahese oipɨsɨ Jesús yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Semimbohe secoi vahe supi ovɨnose oquɨse pucu. Ipɨpe oyasɨa pahi rerecuar ɨvate catu vahe rembiguai nambi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ahese Jesús aipo ehi ava upe: —Pe quɨse pucu, ɨvɨra reseve-seve rutei co peyu che ropeña che pɨsɨ ãgua. Imonda rai vahe nungar che rereco peye. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Arɨ yacatu rupi niha pe pãhuve aporombohese tũparove vichico, na ndapeyei eté cheu. Co rumo ẽgüe peye icuachiaprɨ mboavɨye ãgua cute —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ahese semimbohe oñemosaipa oseya Jesús ahe ae tuprɨ imoha yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mbɨa chĩhivahe rumo turucuar pɨpe güerañomi oñemama vahe supive secoi viña; ");
INSERT INTO gyrNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ahe avei oipɨsɨ yuvɨreco. Oipoequɨiño rumo oturucuar reya oso nani tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Evocoiyase Jesús vɨraso pahi rerecuar ɨvate catu vahe rovai yuvɨreco. Aheve oñemonuha pahi eta rerecuar, judío rerecuar, Moisés porocuaita rese oporombohe vahe avei no. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro avei amombrɨ rupive tẽi oique ité oso pahi rerecuar ɨvate catu vahe rẽta ãchisa pɨpe. Aheve oguapɨño mbɨa sundao pãhuve tata ɨpɨve oyepehe oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pahi eta rerecuar rumo iyavei opacatu porandusa ɨvate catu vahe pendar oseca-seca tẽi ava oñehe-ñehe tẽi vaherã Jesús rese yamotarẽhɨsave yuca uca ãgua yuvɨreco; ndoicatui eté rumo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iyavei setá iteanga tẽi semira yuvɨreco sese; oyeecopɨ-copɨ tẽi rumo güemira pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Amove aipo ehi tẽi yuvɨreco seco momara ãgua: ");
INSERT INTO gyrNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Ore orosendu iñehe aipo ehise: ‘Che opara amonduru co tũparo ava tẽi rembiapo. Ipare rumo mbosapɨ arɨ rupi opara amopuha. Ndahe iri chira evocoiyase ava tẽi rembiapo’ ehi —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ndahoyoyai rumo ambuae imombehusa rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ahese pahi rerecuar ɨvate catu vahe opũha oporandu Jesús upe: —¿Nderemboyevɨi chira vo iñehe yuvɨreco chupe? ¿Mbahe vo aipo nde amotarẽhɨmbar oñehe nde rese? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Noñeheiño ité rumo chupe. Pahi rerecuar ɨvate catu vahe rumo oporandu iri chupe: —¿Poropɨ̃sɨrosar ité vo nde ereico, Tũpa imboeteiprɨ Rahɨr? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Taa, ahe ité niha che aico. Pe niha che repiara peye che, Ava Rɨquehɨr, aguapɨse che Ru mbahe mboavaisarẽhɨ acato cotɨ; ayevɨse avei ɨva quɨha rese curi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Evocoiyase pahi rerecuar ɨvate catu vahe omondoro oturucuar aipo ehi: —¿Mbahe iri vo yande yaipota vɨte yaico? ");
INSERT INTO gyrNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yasendupa niha aipo Tũpa upe iñehe-ñehe tẽisa, ¿mara ehi aipo evocoiyase pe pɨhave? —ehi. Ipare opacatu guasu ava, “¡Tomanoño ité!” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ahese amove ava ondɨvɨ-ndɨvɨ sese iyavei osesacua, ipare yuvɨrocua-rocua sese aipo ehi yuvɨreco: —¡Eicua ité ru, ava evocoi ocua nde rese! —ehi-ehi yuvɨreco chupe. Sundao tũparo rãrosar avei osovapete-pete yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro ɨvɨve ñachimbrɨ pɨpe secoi. Aheve cuña oyepota ou pahi mborerecuar ɨvate catu vahe rembiguai chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Osepiase Pedro iyepehese tata ɨpɨve, omahengatu ohã sese aipo ehi chupe: —Nde avei acoi Jesús Nazaret pendar rupindar ereico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ahe rumo aipo ehiño: —Ndaicuai vahe ité rumo aipo mbɨa; ndaicuai avei aipo nde ñehesa —ehiño chupe. Ichui osẽse oquendɨpɨve ohã, ahese oñehe tacura. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Omahe irise co cuña mbiguai sese, ahe aipo ehi ahe pendar ava yuvɨrecoi vahe upe: —Co ava niha supindar ité —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro rumo, “Ndahei eté che” ehiño. Iparemi tẽi ambuae ava aheve yuvɨrecoi vahe aipo ehi iri yuvɨreco chupe: —Nde ité niha supindar ereico. Esepia, nde Galilea ɨguar ité ereico —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pedro evocoiyase, —¡Tũpa niha oicua, ndopombopai eté niha aipo, ndaicuai eté aipo mbɨa pe ñehesa! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aipo iheseve, tacura oñehe imoñuvɨriosa rupi. Ahese Pedro oyemomahenduha, “Tacura ñehe yupagüesa renondeve, mbosapɨ oyupagüer rupi, ‘Ndaicuai vahe evocoi mbɨa’ erera cheu” ihe agüer rese. Sese oyasehó iteanga. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cõhe potase, pahi eta rerecuar, judío rerecuar, Moisés porocuaita rese oporombohe vahe iyavei opacatu ava porandusa ɨvate catu vahe pendar oñemonuha yuvɨreco. Ipare oipocua-pocua Jesús seraso Pilato upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato aheve oporandu chupe: —¿Nde ité vo judío rerecuar ɨvate catu vahe ereico? —ehi. —Nde niha aipo, “Ahe ereico” ere cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pahi eta rerecuar rumo omombehu-mbehu tẽi mbahe sembiavɨẽhɨ yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Evocoiyase Pilato oporandu iri chupe aipo ehi: —¿Mahera vo ndereñehei eté? Esepia, setá mbahe nde rembiavɨ omombehu yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Nomboyevɨi eté rumo Pilato upe. Evocoiyase, “¿Mara ehi rutei pĩha?” ehi tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mborerecuar guasu recosa ité ñepei ava soquendaprɨ renose ãgua Pascua pieta pɨpe ava rehɨi porandusa rupi yepi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mbɨa Barrabás serer vahe, ahe pɨpeve avei soquendasa yuvɨreco ambuae oporapichi vahe reseve. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ava yugüeru Pilato upe ‘tayaposa pieta pɨpe yaposa vahe yepi’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato rumo aipo ehi: —¿Peipota amose vaherã judío rerecuar? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Esepia, Pilato oicuaño ité ava rese yemoecatẽhɨsa pɨpe sui pahi eta rerecuar remimondo secoise. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pahi eta rerecuar rumo ‘Barrabás tosẽ’ ombohe atɨ-atɨ uca ava yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Evocoiyase Pilato oporandu ahe ava upe: —¿Mbahe vo peipota ayapora co mbɨa chupe acoi, ‘Judío rerecuar’ peye vahe rese? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ahe rumo omboyevɨ Pilato upe: —¡Tayatɨcasa curusu rese! —ehi atɨ-atɨño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato rumo aipo ehi ava upe: —¿Mbahe ité vo oyapo naporai vahe? —ehi. Ahe rumo, —¡Tayatɨcasa ité curusu rese! —ehi atɨ-atɨ iriño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Evocoiyase Pilato, mbahe tuprɨ opɨta ãgua ava rese, omose uca Barrabás. Ipare oinupá iteanga uca Jesús tucumbo tupeicha nungar pɨpe, imondo curusu rese yatɨca ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ahese sundao vɨraso mborerecuar rẽta sui ambuae oɨ pɨpe, aheve opacatu omboetasa omonuha yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aheve omboyemonde turucuar pĩraumbɨ vahe pɨpe yuvɨreco, ipare yu pɨaprɨ omonde ñaca rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sãse avei yuvɨreco: —¡Imboeteiprɨ judío rerecuar tasecoi! —ehi angahu yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iyavei yuvɨrocua-rocua ɨvɨra pɨpe ñaca rupi yuvɨreco sese, ondɨvɨ-ndɨvɨ avei oñenopɨha-pɨha avei sovai yuvɨreco imboeteisave angahu. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mara-mara tẽi sereco pare, ovɨrocua iturucuar pĩraumbɨ vahe yuvɨreco ichui, ahese omonde iturucuar ité yuvɨreco sese. Ichui vɨnose ocarve yatɨca ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ñepei mbɨa Simón serer vahe Cirene pendar, Alejandro, Rufo yesupa, ahe pɨpe avei oyepota chupe que co cotɨ rupi sui ou. Oñocua potase ocua viña: “Erio, terevosɨi curusu co Jesús vɨreco vahe rese” ehi voiño tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesús ovɨraso Gólgota serer vahesave yuvɨreco (‘Ava Ãca Cangüer’ oyapave aipo ehi). ");
INSERT INTO gyrNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iyavei uva rɨcuer oyeseha vahe mirra rese omondo tẽi yuvɨreco chupe. Ahe rumo ndoɨhui eté. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Evocoiyase oyatɨca yuvɨreco. Ipare sundao iguayɨño Jesús turucuar rese ‘¿uma pĩha vɨrasora oyeupe’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ahe oyatɨca añihivei la nueve rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Curusu rese rumo omombehu mbahe sui oyuca yuvɨreco: “Judío rerecuar guasu” ehi icuachiaprɨ oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Supive avei yatɨcasa ñuvɨrío imonda rai vahe ñepei mbahe rese ipocosa cotɨ, ambuae mbahe rese ipocoẽhɨsa cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ẽgüe ehi imboavɨye icuachiaprɨ aipo ehi vahe: “Ava mbahe-mbahe tẽi aposar nungar ipãhuve serecosa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Acoi ava ñocuasar iñehe-ñehe tẽi, oñeaca mbovava aipo ehi yuvɨreco chupe: —Nde acoi, “Opara tũparo amonduru. Ipare mbosapɨ arɨ rupi opa irira amopuha” ere acoi cuese. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¡Eñepɨsɨro ru nde ae cute; egüeyɨ curusu sui! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ẽgüe ehi avei pahi eta rerecuar, oporombohe vahe avei Moisés porocuaita rese iñehe mara-mara tẽi yuvɨreco chupe, aipo ehi yuvɨreco oyeupe: —Oipɨ̃sɨro ambuae. Ahe ae rumo ndoicatui oñepɨsɨro. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Poropɨ̃sɨrosar Israel rerecuar guasu, toyeeroyɨ ahe ae curusu sui cũritei, ahese voi seroyasara —ehi. Iyavei supive yatɨcaprɨ mara ehi-ehi tẽi avei chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Osupitɨse rumo mbɨter arɨ, opa tuprɨ pɨ̃tu ɨvɨ rupi. Ẽgüe ehi las tres rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ahese tuprɨ avei Jesús oñehe pĩrata aipo ehi: “Eloi, Eloi, ¿lema sabactani?” ehi, (ahe ‘che Ru Tũpa, che Ru Tũpa, ¿mahera vo che reya eve?’ oyapave aipo ehi). ");
INSERT INTO gyrNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aheve ava yuvɨrecoi vahe rumo osenduse iñehe, aipo ehi yuvɨreco: —Pesendu aipo Tũpa ñehe mombehusar Elías upe oñehe —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Evocoiyase ñepei imboetasa oña oso mbahe saviyu vahe reca. Ahe omoaquɨ vinagre pɨpe imondo ɨvɨra aprɨ rese chupe ‘toɨhu’ oya: —Ẽgüe tehiño rane, ¿oura pĩha Elías seroyɨ ãgua curusu sui? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ahese Jesús sãse pĩrata. Ipare omano. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aheseve tũparo asɨasa turucuar ɨvate cotɨ sui ovo tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Iyavei sundao rerecuar Roma ɨguar, ahe Jesús rehõgüer rese omahengatu ohã. Osenduse Jesús rãse iyavei osepiase imano, aipo ehi: —Supi eté catu, co mbɨa Tũpa Rahɨr ité —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Iyavei cuña aheve amombrɨve osepia catu yuvɨnoha; ahe yuvɨrecoi María Magdalena, José sɨ María, ahe avei Santiago chĩhivahe catu vahe sɨ iyavei ambuae cuña Salomé. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Co cuña eta yuvɨrecoiño vahe ité Jesús rupi, oipɨ̃tɨvɨi vahe avei Galilea ve yuvɨrecoise. Setá avei ambuae ava supi yugüeru vahe Jerusalén ve yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pɨ̃tu ramose, ahe arɨ pɨpe oyemoingatu ava yuvɨreco arɨ mbɨtuhusa upe nara yepi, ");
INSERT INTO gyrNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ahese José, tecua Arimatea pendar, porandusa ɨvate catu vahe pendar, acoi Tũpa mborerecuasa osãro vahe oico, oquerẽhɨsa pɨpe ité oique oso Pilato upe oporandu ãgua Jesús rehõgüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato rumo oyepɨhamondɨi tẽi, “Omano” hese. Oñehe sundao rerecuar upe oporandu ãgua ‘¿marase vo ẽgüe ehi?’ ");
INSERT INTO gyrNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sundao rerecuar omombehuse chupe, ahese omondo sehõgüer José upe. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Evocoiyase José vɨrocua turucuar secose vahe. Curusu sui seroyɨ pare, oimama voi eté ipɨpe. Ipare omoingue tuvɨpa ita yohoprɨ pɨpe. Ichui ita yapayere vahe pɨpe osovapɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena iyavei María, José sɨ, osepiaño yapocatuse yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mbɨtuhusa arɨ pare, María Magdalena, María, Santiago sɨ, Salomé avei, ahe vɨrocua mbahe sɨ̃acua vahe Jesús rehõgüer rese nara yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Iyavei añihiveive, yɨpɨndar arɨ semana pɨpe, oyepota Jesús ruvɨpave icatu ramose yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aheve aipo ehi oyeupe yuvɨreco: —¿Ava pĩha co tehõgüer rovapɨsa vɨrocuara yuvɨreco yandeu? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Osepiase rumo ita guasu yuvɨreco, ndahe irise güendave ihãi, ");
INSERT INTO gyrNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","yuvɨroiquese tehõgüer ruvɨpave yuvɨreco, aheve osepia ombahe rese pocosa cotɨ mbɨa chĩhivahe, iturucuar pucu morochi vahe oguapɨse oĩ. Ahese cuña oyembosɨquɨye yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ahe rumo aipo ehi chupe: —Pesɨquɨye eme. Pe peseca Jesús Nazaret pendar, yatɨcaprɨ. Ahe rumo ocuerayevɨ; ndipoi eté cohave. Pesepia ru supagüer. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Peso, tapemombehu semimbohe eta upe iyavei pemombehu Pedro upe: ‘Jesús rane osora pe renonera Galilea ve. Aheve pesepiara mbahe che remimombehu rupi tuprɨ’ peyera —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Evocoiyase ahe cuña yuvɨnosese tuvɨpa sui, yuvɨnoña yuvɨraso, orɨrɨi avei osɨquɨyepave. Iyavei nomombehui eté ambuae ava upe osɨquɨyepave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús ocuerayevɨre añihiveive domingu pɨpe, oyemboyecua yɨpɨndar María Magdalena upe, ahe ichui acoi siete tuprɨ caruguar opa omboyepepɨ. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ahe oso imombehu supindar upe. Ahe rumo oyaseho vɨte ovɨharẽhɨsave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Osenduse cuña ñehe: “Jesús ocuerayevɨ, che ité asepia” ehise, ndovɨroyai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ipare Jesús oyemboyecua iri ñuvɨrío güemimbohe upe ambuae güepiaca pɨpe perɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ahe avei yuvɨraso omboetasa upe imombehu; ndovɨroya vɨteiño avei rumo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Coiye catumi tẽi, Jesús oyemboyecua güemimbohe once tuprɨ yuvɨrecoi vahe upe mesave yuvɨnoi vɨteseve, oñehengata ahe oyese yeroyaẽhɨsa rese chupe, iyavei ocuerayevɨsa mombehusar reroyaẽhɨ rese avei. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ipare aipo ehi güemimbohe upe: “Peso opacatu ɨvɨ rupi, pemombehu co ñehesa pɨ̃sɨrosa resendar peico. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Acoi vɨroya vahe, iyavei oñeapiramo vahe, ahe oñepɨsɨrora yuvɨreco; acoi ndovɨroyai vahe rumo, ahe imocañɨpɨrã tẽi yuvɨrecoira. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Co mbahe poromondɨisa omboyecuara che reroyasar yuvɨreco: Che rer pɨpe omboyepepɨra caruguar ava sui. Oñehe aveira ñehesa ndicuasai vahe pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Oipɨsɨ aveira mboi yuvɨreco, yuvɨroɨhuse mosa oporoyuca vahe, ndoyapoi chietera mbahe yuvɨreco chupe; iyavei omondose opo ava imbaheasɨ vahe harɨve, ombogüera aveira yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Oñehe pare, yande Yar Jesús oso ɨvave. Aheve oguapɨ Vu Tũpa acato cotɨ oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Semimbohe evocoiyase opa yuvɨraso opacatu ɨvɨ rupi ñehesa pɨ̃sɨrosa resendar mombehu. Yande Yar avei oipɨ̃tɨvɨi, iyavei mbahe poromondɨisa pɨpe omboyecua uca ité ñehesa pɨ̃sɨrosa resendar supi eté vahe. Aipo rupive.");
INSERT INTO gyrNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Imboeteiprɨ Teófilo, setá ava oicuachía yuvɨreco opacatu aracahendar mbahe imombehuprɨ mboavɨyesa cũritei yande pãhuve co Jesucristo recocuer resendar. Acoi ava yɨpɨsuive osepia vahe omombehu tuprɨ vahe Jesucristo recocuer ava upe yuvɨreco, ahe omombehu tuprɨ avei yuvɨreco cheu. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Sese che avei opa aseca tuprɨ yɨpɨsuive opacatu co mbahe cua tuprɨ ãgua, Teófilo. Ichui che amoingatu tuprɨ pota icuachiaprɨ sesendar ndeu nara avei sereco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Evocoiyase nde ereicua tuprɨra co porombohesa supi eté vahe acoi nde mbohe agüer. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yɨpɨndar Jesús ha renondeve, Herodes mborerecuar ɨvɨ Judea rupindar recose aracahe, ahese aipo judío pahi secoi Zacarías serer vahe. Ahe pahi Abías rupindar secoi. Sembireco aipo pahi Aarón suindar, ahe serer Isabel. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Co ñuvɨrío secocuer avɨye tuprɨ Tũpa upe; vɨroya tuprɨ opacatu Yar porocuaita yuvɨreco. Evocoiyase ndipoi eté que ava “mara” ehi vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Zacarías rumo yɨpɨsuive ndatahɨi vahe. Esepia, sembireco ndimembɨi vahe ité, iyavei oyoya ité ocuacua-cuacuami yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ñepei arɨ aipo osupitɨ icuaita tũparo pɨpe imboetasa reseve iporavɨquɨ ãgua Tũpa rovaque yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pahi recosa ité ẽgüe ehi aracahe suive, ahese iporavosa Zacarías yɨpɨndar yasɨaprɨ tũparo maranehɨ pɨpe oique vaherã itaɨsɨ rapɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Itaɨsɨ rapɨ vɨteseve aipo, opacatu ava oyerure yuvɨreco ocarve. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aheseve aipo oyemboyecua yande Yar rembiguai itaɨsɨ renda maranehɨ ɨque cotɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tũpa rembiguai repiase aipo, oyembosɨquɨyé iteanga. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tũpa rembiguai rumo aipo ehiño chupe: —Zacarías —ehi—, eresɨquɨye eme. Tũpa osendu nde yeruresa. Sese nde rembireco Isabel imembɨra ndeu. Ahe nde rahɨr rer-ra Juan. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Erevɨharetera sese, iyavei oyembovɨharetera opacatu ava yuvɨreco nde rahɨr ohase. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Esepia niha, nde rahɨr secocuer tuvichara oico Tũpa rovaque. Ndoɨhui chietera uva rɨcuer sai vahe, iyavei que ambuae mbahe sai vahe; secoira rumo Espíritu Santo rese ohaẽhɨ vɨteseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ẽgüe ehira omonguerẽhɨ setá ava judío Yar Tũpa reroya iri ãgua oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ahe vɨrecora espíritu pĩratasa oyese oyoyara Tũpa ñehe mombehusar Elías rese ‘ava guahɨr rese tiñero yuvɨreco oyeupe’ oya, ‘toyembohe avei ava ndiporeroyai vahe yuvɨreco seco catuprɨ vahe aracuasa mboyeroya ãgua rese’ oyapave. Ẽgüe ehira ava mbohe imoingatu yande Yar pɨsɨ ãgua sereco —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Evocoiyase, —¿Mara ahera pĩha aipo reroya? Che rumo acuacuami eté vichico, iyavei che rembireco ocuacuami avei no —ehi Tũpa rembiguai upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—Aní —ehi chupe—. Che aico Tũpa rembiguai Gabriel, Tũpa rovaindar. Ahe niha che mbou ndeu che ñehe ãgua iyavei co ñehesa avɨye vahe mombehu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nde rumo ndereroyai acoi amombehu vahe ndeu. Sese co pɨpe suive ité nandeñehengatui chira eico. Osupitɨse voi che remimombehugüer, acoi ohase nde rahɨr, ahese ramo ndeñehengatura —ehi aipo Tũpa rembiguai chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Osãro pucu tẽi aipo ocarve ambuae imboetasa eta yuvɨreco. “¿Mahera pĩha nose vɨtei tũparo pɨpe sui?” ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Osẽse aipo tũparo pɨpe sui, niñehengatui voi eté. “Ñaro osepia mbahe tũparo pɨpe” ehiño ité aipo imboetasa eta yuvɨreco chupe. Ipo ãta-ãta tẽi aipo oñehengatuẽhɨse mbahe mombehu oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ipare omboavɨyese ocuaita tũparo pɨpe, oyevɨ oso güẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Coiye aipo sembireco Isabel ipuruha oico. Judío porocuaita mboyeroyasave nose iri eté ambuae ava pɨri poyandepo yasɨ rupi. Ipɨhañemoñeta: ");
INSERT INTO gyrNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yar Tũpa ité ẽgüe ehi cheu ava che rese ñeheẽhɨ iri ãgua yuvɨreco” ehi vorɨvetesa pɨpe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Coiye seis yasɨ pɨpe Tũpa omondo güembiguai Gabriel tecua Nazaret ve ɨvɨ Galilea rupi ");
INSERT INTO gyrNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","cuñatai ndaseco marai vahe upe iñehe ãgua; ahe serer María. Ahe omenda pota vahe cuimbahe mborerecuar guasu David suindar José serer vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tũpa rembiguai oique co cuña rẽtave aipo ehi chupe: —¡María, Tũpa nde rovasa, erereco mbahe icatuprɨ vahe pɨ̃tɨvɨisa Yar Tũpa suindar! Tũpa nde rese ité secoi; nde rovasa catu opacatu cuña sui —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Tũpa rembiguai repiase, “¿Mara oya pĩha co aipo ehi cheu?” ehi tẽi osɨquɨyepave opɨhañemoñeta rereco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Evocoiyase Tũpa rembiguai aipo ehi chupe: —María, eresɨquɨye eme. Esepia niha, Tũpa ité nde poravo nde rovasa ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cũritei voira rumo ndemembɨra: ererecora nde membrɨ; ahe serer-ra Jesús. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ahe niha secouvicha catu vaherã secoira; “Tũpa seco ɨvate vahe Rahɨr secoi” ehira yuvɨreco chupe. Iyavei niha Yar Tũpa ité omoinguera mborerecuar guasu seco ãgua inungar tamoi David aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mborerecuar guasu secoira judío recua rupi apɨrẽhɨ vaherã; imborerecuasa niha apɨrẽhɨ vaherã ité secoira —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Evocoiyase ahe aipo ehi: —¿Mara ahera vo aipo che membɨ viña? Esepia niha, ndaico vɨtei vahe cuimbahe rese —ehi Tũpa rembiguai upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—Espíritu Santo ogüeyɨra nde harɨve ɨva quɨha nungar; Tũpa güeco pĩratasa pɨpe nde momembɨra. Sese acoi ohase nde membrɨ seco maranehɨ vahe, “Tũpa Rahɨr” hesara chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Cũritei nde mu Isabel avei ocuacuami pɨpe imembɨ oico; ahe niha ndimembɨi vahe yɨpɨndar viña, cũritei rumo vɨreco seis yasɨ omembrɨ vɨe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Esepia niha, Tũpa upe ndipoi eté mbahe yavai vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Evocoiyase María aipo ehi: —Che Yar rembiguai aico, tayavɨye ayase Tũpa remimbotar cheu nde ñehe rupi —ehi. Aipo ihe pare, Tũpa rembiguai oyepepɨ oso ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ahese María oso voi eté ɨvɨtrɨ rupi tecua ɨvɨ Judea ve. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Aheve aipo Zacarías rẽta pɨpe oiquese oso, oyapo “avɨrave” omu Isabel upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Evocoiyase Isabel rɨe pɨpe omɨi imembrɨ iñehe renduse. Ahese Espíritu Santo oique Isabel avɨterve. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ipare osapucai pĩrata aipo ehi chupe vorɨvetesave: —¡Tũpa nde rovasa cuña opacatu sui, iyavei osovasa nde membrɨ! ");
INSERT INTO gyrNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Noromohai eté che pɨri ereyu vaherã viña, che Yar sɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Esepia, cheu “avɨrave” ereyapose, che membrɨ omɨi voi vorɨvetesave che rɨe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Sovasaprɨ ereico! Esepia, ereroya ité ñehesa ndeundar. Iyavei Tũpa omboavɨyera güemimombehu nde rese —ehi Isabel chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Evocoiyase aipo ihese, “Che niha amboetei che Yar vichico; ");
INSERT INTO gyrNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","cherorɨveté Tũpa che Pɨ̃sɨrosar rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Esepia, ahe omahe che rese che reco yemominisa pɨpe seroyasar che recosave. Co pɨpe suive, ‘Sovasaprɨ secoi’ ehira opacatu ava yuvɨreco cheu. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Esepia niha, Tũpa mbahe mboavaisarẽhɨ, oyapo mbahe tuvichá vahe cheu. ¡Tũpa imboeteiprɨ catu tasecoi yepi! ");
INSERT INTO gyrNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ahe oiparaɨsuereco opacatu omboeteisar yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nomboavai eté mbahe yapo. Osecoreroyɨ ava oyemboɨvate ai tẽi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Vɨroyɨ mborerecuar seco pĩrata vahe pĩratasa sui; ava seco mbegüemi vahe rumo osecomboɨvate. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ava yaracua pota vahe, omboaracua; ava ‘che aracua vai’ ehi vahe rumo, nomboaracuai eté. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Oipɨ̃tɨvɨi niha opacatu vɨroyasareta judío yuvɨrecoi vahe. Esepia, ndasesarai eté poroparaɨsuerecosa mondo ãgua ");
INSERT INTO gyrNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","güemimombehugüer rupi yande ramoi aracahendar Abraham upe, ichuindar upe avei yepi no” ehi vorɨvetesa pɨpe omu Isabel upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ipare María opɨta Isabel pɨri mbosapɨ yasɨ rupi. Ichui oyevɨ oso güẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Osupitɨse arɨ Isabel upe, imembɨra. Ahe imembrɨ cuimbahemi. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Imu iyavei icotɨndar oyanduse Tũpa rembiapo mbahe avɨye vahe, aipo ehi yuvɨreco chupe: “Avɨye ai catu Yar Tũpa secoi co cuña rese” ehi vorɨvetesave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ocho arɨ pɨpe aipo, ahe pĩtani ombocircuncida yuvɨreco judío porocuaita mboyeroyasa pɨpe. Ipare aipo omondo pota iyesupa Zacarías rer yuvɨreco sese viña, ");
INSERT INTO gyrNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ichɨ rumo, —Aní —ehiño—. Juan itera rumo serer —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—¿Mahera vo? Ndipoi eté rumo nde mu rer aipo nungar —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Evocoiyase aipo omahe pĩtani yesupa rese yuvɨreco ‘¿mbahe pĩha ahe omondo pota sererguã viña?’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Evocoiyase aipo iyesupa oporandu ɨvɨrapemi rese sese serer oicuachía vaherã. Ahe serer oicuachía: ‘Juan sererguã’ ehi imoi. Ahese aipo opacatu ava: “¿Mara ehi rutei pĩha co?” ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ahese ramo Zacarías iñehengatu, omboɨpɨ Tũpa upe osapucai oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Opacatu aipo sẽta cotɨndar oyembosɨquɨye tẽi yuvɨreco, iyavei aipo opacatu Judea recua rupi omombehu-mbehu mbahe osepia vahecuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mbahe osendu vahecuer rese avei aipo oporandu-randu oyeupe yuvɨreco: “¿Mbahe pĩha aipo pĩtani oyapora curi?” ehi. Esepia niha, supi eté Tũpa osovasa. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, Espíritu Santo pĩratasa pɨpe, oñehe Tũpa oyeupe ñehesa pɨpe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Yande Yar Tũpa imboeteiprɨ tasecoi! ¡Esepia niha, ahe ou yande judío yaico vahe pɨ̃sɨro ãgua! ");
INSERT INTO gyrNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ombou niha Poropɨ̃sɨrosar güembiguai David suindar yandeu. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ẽgüe ehi imombehu opacatu oñehengagüer mombehusar seco maranehɨ vahe upe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ahe yande pɨ̃sɨrora yande amotarẽhɨmbar sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ẽgüe ehi Tũpa imbou oporoparaɨsuerecosa yande ramoi aracahendar upe, iyavei iyemomahenduha ãgua güemimbotar maranehɨ mombehu agüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Evocoiyase, ‘Che supi eté ayapora evocoi mbahe’ ehi yande ramoi Abraham upe aracahe ");
INSERT INTO gyrNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yande renose ãgua yande amotarẽhɨmbar povrɨ sui ‘tache mboetei osɨquɨyeẽhɨsa pɨpe yuvɨreco’ oya; ");
INSERT INTO gyrNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","‘toyuvɨrecoi che rembiepiave güeco ɨ̃visa pɨpe iyavei güeco maranehɨsa pɨpe arɨ yacatu rupi’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nde, che rahɨr, ‘Co Tũpa ɨvate vahe ñehe mombehusar secoi’ ehira ava yuvɨreco ndeu. Esepia, nde eremoingatura ava recocuer Yar pɨsɨ ãgua senondeve eico. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Supi eté nde niha eremboyecuara opacatu ava Tũpa upendar yuvɨrecoi vahe upe angaipa sui ñeroisa pɨsɨ ãgua iñepɨsɨro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Esepia, yande Ru Tũpa, oporoparaɨsuerecosa pɨpe ombou oporoesapesa ɨva pendar yandeu yande reco mbopɨasu ãgua ");
INSERT INTO gyrNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","iyavei ava Tũpa cuaparẽhɨ resape ãgua ‘toyuvɨrecoi mbahe tuprɨ pɨpe’ oyapave. Esepia, ahe inungar ava pɨ̃tumimbisave yuvɨrecoi vahe, ocañɨ tẽi vaherã yuvɨreco” ehi Zacarías. ");
INSERT INTO gyrNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ichui pĩtani ocuacua iyavei vɨreco pĩratasa Espíritu suindar oyese. Ipare rumo oso oyemboerecua ɨvɨ iporupɨrẽhɨ rupi. Coiye oyemboyecua omu Israel pendar upe oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Yɨpɨndar mborerecuar guasu Augusto oporocuai oico, “Tayecuachiasa opacatu tecua rupi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ahe yɨpɨndar yecuachiasa mborerecuar Cirenio, Siria pendar rẽise. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Opacatu ava yuvɨraso güecua yacatu rupi oyecuachía ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Sese José avei osẽ Nazaret, Galilea ɨvɨ rupi sui oso ɨvɨ Judea rupindar tecua Belén ve. Esepia niha, aracahendar mborerecuar guasu David aheve oha vahecuer, iyavei José ichuindar avei secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ẽgüe ehi oyoya yuvɨraso güembirecovɨ María rese oyecuachía ãgua. María rumo imembɨra pota ité oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aheve oyepota ramose, osupitɨ arɨ imembɨra ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aheve oha imembrɨ yɨpɨndar vahe cuimbahemi. Ahese María oyao omembrɨ turucuar pɨpe, ẽgüe ehi imoñeno imondo mbahe mɨmba rembihu rɨru pɨpe. Esepia niha, ndoyosui eté oque ãgua aheve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Namombrɨimi Belén sui ovesa rãrosar yuvɨrecoi. Aheve osãro ovesa pɨ̃tu pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Avɨyeteramo tẽi oyemboyecua Tũpa rembiguai ɨva pendar chupe. Tũpa porañetesa avei sendɨ yɨvɨi chupe yuvɨreco. Ahe sepiase, oyembosɨquɨyé iteanga tẽi yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ahe rumo aipo ehi chupe: “Pesɨquɨye eme. Esepia, che ayu mbahe icatuprɨ vahe mombehu ãgua pẽu pe mbovɨharete ãgua iyavei opacatu ava mbovɨharete ãgua avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Co pɨpe oha David recua Belén ve Poropɨ̃sɨrosar pẽu nara. Ahe niha Tũpa Rembiporavo, pe Yarguã secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Icua ãgua peyosura pĩtani yaoprɨ tuprɨmi vahe tui mbahe mɨmba rembihu rɨru pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Avɨyeteramo tẽi oyemboyecua ambuae setá Tũpa rembiguai ɨva pendar yɨvɨi yuvɨreco. Tũpa upe osapucai yuvɨreco aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Imboeteiprɨ tasecoi Tũpa ɨvave! ¡Ɨvɨve ava Tũpa rembiaɨsu toyuvɨrecoi tuprɨ oyeaɨsusa pɨpe!” ehi osapucai yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Opase oyevɨ Tũpa rembiguai ɨvave yuvɨraso, ahese ovesa rãrosar aipo ehi oyeupe yuvɨreco: —Yaso ru Belén ve; yasepiara aipo mbahe, acoi oicua uca vahe Yar oico yandeu —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Evocoiyase ipoyava yuvɨraso. Ipare osepia María, José, Jesús pĩtani avei yuvɨreco cute. Ahe pĩtani omoñenomi mbahe mɨmba rembihu rɨru pɨpe ino. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ipare yuvɨnose omombehu-mbehu ambuae ava upe Tũpa rembiguai remimombehugüer pĩtani resendar ñehesa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Evocoiyase opacatu ava oyepɨhamondɨi co ñehesa renduse yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María rumo opacatu co mbahe rese oyapɨsacaño; ahe ehiño ité ipɨhañemoñetasa. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Oyevɨse ovesa rãrosar yuvɨraso, omboetei iyavei osapucai Tũpa upe yuvɨreco. Esepia niha, opacatu mbahe osendu vahe, osepia vahecuer yuvɨreco imombehuprɨ rupi tuprɨ ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ocho arɨ pɨpe ahe pĩtani ombocircuncida yuvɨreco; omondo sererguã Jesús yuvɨreco, ahe terer tuprɨ avei acoi Tũpa rembiguai omombehu María upe imembɨẽhɨ vɨteseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ipare omboavɨyese oharɨ güẽtave oñemoatɨro ãgua, ahe aipo ẽgüe ehi Moisés porocuaita rupi yuvɨreco yepi, ahese vɨnose pĩtani seraso tecua guasu Jerusalén tũparo pɨpe seropovẽhe ãgua Yar upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ẽgüe ehi yuvɨreco. Esepia, Yar porocuaita aipo ehi icuachiaprɨ pɨpe aracahe: “Opacatu yɨpɨndar pĩtani cuimbahe mini yuvɨroha vahe ipehasara Tũpa upe nara yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yuvɨraso oporerecosa reropovẽhe ãgua yuvɨreco yande Yar porocuaita rupi: “Ñepei oyovaichor reseve pɨcuhi, anise ñuvɨrío apɨcasu peropovẽhera” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ahe pɨpe mbɨa Jerusalén ve secoi Simeón serer vahe. Ahe mbɨa avɨye eteprɨ vahe. Oyerure vahe Tũpa upe, osãro vahe avei Israel recua pendar Pɨ̃sɨrosar imombehuprɨ. Ahe secoi vahe ité Espíritu Santo rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ahe chupe Espíritu Santo opa uca oicua “eresepia rane itera Poropɨ̃sɨrosar Tũpa remimbou nde mano renondeve” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ahe arɨ pɨpe Espíritu Santo vɨroguata tũparove. Oyepotase José, María reseve yuvɨreco tũparove Jesús pĩtani reropovẽhe ãgua Tũpa porocuaita rupi tuprɨ, ");
INSERT INTO gyrNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ahese Simeón oyemboya oso sese, osupi ichɨ sui, vɨroyeroquɨ Tũpa upe señoha aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Che Yar, cũritei che, nde rembiguai, amano tuprɨño itera. Esepia niha, nde remimombehugüer eremboavɨye ité cheu. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Asepia ité niha Poropɨ̃sɨrosar vichico cute. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nde niha erembou opacatu ava rembiepiave. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ahe niha poroesapesa ité secoi. Esepia, omboyecuara mbahe supi eté vahe ava ndahei vahe judío yuvɨrecoi vahe upe, iyavei omondara poromboeteisa nde recua Israel pendar judío yuvɨrecoi vahe upe” ehi oyeroquɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José iyavei María ndoyembovɨhai tẽi yuvɨreco pĩtani rese Simeón yeroquɨ renduse. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Evocoiyase Simeón osovasa ahe pĩtani iyesupa reseve. Ipare aipo ehi ichɨ María upe: —Esendu, co pĩtani reroyaẽhɨsa pɨpe setá yande mu judío ovɨapira mbahe tẽi pɨpe yuvɨreco; ambuae rumo seroya pɨpe sovasaprɨ yuvɨrecoira. Ahe avei omboyecuara mbahe ava upe. Amove rumo vɨroɨ̃roñora yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ipɨpe sui ava pɨhañemoñetasa icuasara curi. Iyavei co opacatu mbahe tasɨra nde pɨha pɨpe inungar quɨse pucu osasara nde pɨha viña —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aheve avei cuña cuacuami yaracua vahe secoi, ahe serer Ana, Fanuel rayrɨ, Aser suindar. Ocuñataimiseve rumo omenda, iyavei secoi raimi tẽi omer rese siete aravɨter rupive. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cũritei secoi omer mano pare ochenta y cuatro aravɨter. Nosei eté tũparo pɨpe sui oico. Ẽgüe ehi yande Yar mboetei pɨ̃tu, arɨ rupi oyecuacusa pɨpe iyavei oyeruresa pɨpe avei oico no. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ahe evocoiyase ahesa reseve avei ou pĩtani upe, “Avɨye ndeu” ehi Tũpa upe. Ipare oñehe secocuer rese opacatu ava Jerusalén pendar osãro vahe güecua pɨ̃sɨro ãgua upe oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Evocoiyase opacatu Moisés porocuaita mboavɨyere, opa oyevɨ Galilea pendar güecua Nazaret ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ahese pĩtani ocuacua catumi imbahecua-ecua irimi eté oico iyavei ipĩrata catu irimi. Esepia, Tũpa osovasa ité sereco no. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Iyesupa yuvɨraso aravɨter yacatu Jerusalén ve Pascua pieta repia yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús doce aravɨter vɨrecose, ahese vɨraso iyesupa Jerusalén ve oyeupi pieta repia yuvɨreco. Esepia, ẽgüe ehi eté judío recocuer pietase yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ahe pieta pare voi, oyevɨse yuvɨreco güecosave, ahese Jesús opɨtaño Jerusalén ve; ichɨ rumo iyavei tu José ndoicuai eté ipɨtase yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","“Ouño revo ava pãhu rupi” ehi yuvɨreco chupe viña; aipo ehiño ité ñepei arɨ pɨpe yuvɨreco chupe. Oseca tẽise rumo omu pãhu rupi, iyavei omborɨpar pãhu rupi avei no, ");
INSERT INTO gyrNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ndoyosui eté yuvɨreco. Ahese oyevɨ iri tẽi Jerusalén ve seca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Imombosapɨsa arɨ pɨpe oyosu ramo tũparo pɨpe yuvɨreco. Aheve oguapɨ ava Tũpa porocuaita rese oporombohe vahe pãhuve oĩ; oyapɨsaca iñehe rese iyavei oporandu-randu ahe ava upe Tũpa Ñehengagüer rese oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Evocoiyase opacatu ava ndoyembovɨhai tẽi imbahecua vaisa rese yuvɨreco. Esepia, oporanduse mbahe rese yuvɨreco chupe, omboyevɨ tuprɨ voi-voiño ité ñehesa. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oyosuse iyesupa, oyepɨhamondɨi yuvɨreco. Ahese ichɨ aipo ehi chupe: —Che membrɨ, ¿mahera vo ẽgüe ere eico oreu? Nde recasa tẽi opacatu rupi, ore mopɨhañemoñeta atɨ uca eve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Evocoiyase, —¿Mahera vo che reca co cotɨ rupi tẽi peye peico? ¿Ndapeicuai vo che Ru rẽta pɨpe aico vaherã? —ehi osɨ upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iyesupa rumo ndosenducuai eté aipo oyeupe hesa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Evocoiyase oyevɨ Nazaret ve oso supi. Aheve omboyeroyaño ité oyesupa. Ichɨ niha opacatu co mbahe rese oyapɨsacaño ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ahese Jesús ocuacua-cuacua iri, iyetei catu avei imbahecua catu iri avei oico no. Secoi tuprɨ ai eté Tũpa upe iyavei ava eta upe avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quince aravɨter pɨpe mborerecuar guasu Tiberio recose, Poncio Pilato evocoiyase mborerecuar secoi Judea rupi, Herodes avei mborerecuar secoi Galilea ve, tɨvrɨ Felipe evocoiyase mborerecuar secoi Iturea ve iyavei Traconite ve, Lisanias avei mborerecuar secoi Abilinia ve. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás iyavei Caifás ahe pahi rerecuar ɨvate catu vahe yuvɨrecoi. Ahese Tũpa, “Emombehu che ñehe ava upe cute” ehi Zacarías rahɨr Juan upe oico ɨvɨ iporupɨrẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan evocoiyase oso opacatu ɨai Jordán ɨvɨi oico, supi aipo ehi ava upe: “Pemboasɨ pe angaipa, peyevɨ Tũpa upe, ahese opoãpiramora Tũpa pẽu ñero ãgua pe angaipa rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Co yavɨye ité Tũpa ñehe mombehusar Isaías rembicuachiagüer pɨpendar aipo ehi vahe: “Sendusa ɨvɨ iporupɨrẽhɨsave ava sapucaisa aipo ehi vahe: ‘Pemoingatu yande Yar raperã, pemohɨvi tuprɨ avei’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","‘Evocoiyase opacatu ɨvɨsocuer opara imboapɨposa chupe, opacatu ɨvɨtrɨ ɨvate vahe iyavei ɨvɨtrɨ mini opara imboyoyasa tuprɨ no. Acoi perɨ ipãri vahe, ahe imohɨvisapara; perɨ ipɨcucu atɨ vahe opara imboapɨposa tuprɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iyavei opacatu ava osendura ñehesa pɨ̃sɨrosa resendar Tũpa remimbou yuvɨreco cute’ ehi vahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ava rehɨi yuvɨnosepa chupe ‘tayande ãpiramo’ oyapave yuvɨreco viña. Ahe rumo aipo ehi: “¡Pe mboi mboetasa tẽi peico! ¿Ava vo, ‘Pesẽra Tũpa ñemoɨrosa ou vaherã sui’ ehi tuprɨ tẽi pẽu? ");
INSERT INTO gyrNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yɨpɨndar toyecua tuprɨ rane yande Yar upe peyevɨsa pe angaipa mboasɨsa pɨpe. Iyavei ndapeyeroyai chira ‘ore Abraham suindar oroico’ pe hesa rese tẽi peñepɨsɨro ãgua. Esepia, Tũpa oicatuño ité co ita sui Abraham suindar nungar tuprɨ apo ãgua oyeupe nara yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hacha niha imoingatusa voi eté opacatu ɨvɨra iha naporai vahe sapo rupi yasɨa ãgua yepi. Yasɨaprɨ evocoiyase imondosapara tatave” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—¿Mbahe pĩha evocoiyase oroyapora ore recocuer recuñaro ãgua oroico? —ehi ava rehɨi oporandu yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—Pe pereco vahe ñuvɨrío pe camisa, ñepei pemondo ava ndovɨrecoi vahe upe; iyavei pe pereco vahe tembihu, pemboyahomi tẽi ambuae ava ndovɨrecoi vahe upe —ehi imboyevɨ ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yugüeru avei movɨro ava sui guarepochi rerocuasar ‘tayande ãpiramo’ oyapave yuvɨreco. Ipare oporandu Juan upe mbahe rese yuvɨreco: —Porombohesar, ¿mbahe vo ore oroyapora Tũpa rupi ore guata ãgua oroico? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Evocoiyase aipo ehi ahe ava yuvɨrecoi vahe upe: —Aní perocua catu iri guarepochi pẽu imombehusa sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iyavei amove sundao oporandu mbahe rese yuvɨreco chupe: —Ore no, ¿mbahe vo ore oroyapora? —ehi. —Ndaperocuai chietera que mbahe ambuae ava sui, ndapeñehe-ñehe tẽi chira ava upe sembiapoẽhɨ rese, iyavei peyembovɨhañora pe poravɨquɨ reprɨ rese —ehi sundao upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ava rumo, “¿Ndahei pĩha co Poropɨ̃sɨrosar sãrombrɨ secoi?” ehi tẽi Juan upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Juan rumo aipo ehi opacatu ava upe: “Che opoãpiramo ɨ pɨpe tẽi; oura rumo ambuae che raquɨcuei, ahe pe ãpiramora Espíritu Santo tata nungar pɨpe. Ahe seco pĩrata catu vahe secoi che sui. Sese cheu ndiyai eté ahe ipɨtaquisã yora ãgua ichui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","“Ahe güeru trigo mbovevesa ihɨgüer sui ipeha ãgua. Sãhɨi evocoiyase yapocatusa, ihɨgüer rumo imondosa tata apɨrẽhɨ vahesave” ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Omombehu-mbehu vɨte ñehesa avɨye vahe ava upe ‘toyemonguerẽhɨ güecocuer recuñaro ãgua yuvɨreco’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ipare rumo Juan oñehe pĩrata mborerecuar Herodes upe secocuerai rese. Esepia, vɨvrɨ Felipe rembireco Herodías rese secoi, iyavei setá ambuae mbahe naporai vahe sembiapo. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Sese Herodes oyapoño ambuae mbahe tẽi: seroyaẽhɨsa pɨpe osoquenda ucaño Juan sereco. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yɨpɨndar rumo voquenda vɨteẽhɨseve Juan oñapiramo setá ava oico, aheseve avei oñapiramo Jesús. Jesús yerure vɨteseve, avɨyeteramo tẽi oyemboi tuprɨ ɨva. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ipare Espíritu Santo ogüeyɨ ou iharɨve apɨcasu nungar, iyavei oyeendu ñehesa ɨva sui aipo ehi vahe: —Nde che Rahɨr ereico, che rembiaɨsu; sese avɨha ité nde rese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús vɨrecose treinta aravɨter, ahese ramo omboɨpɨ oporombohe. Ahe icuaprɨ vahe ité José rahɨr secose viña. José Elí rahɨr secoi, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí evocoiyase Matat rahɨr, ahe Matat evocoiyase Leví rahɨr, Leví evocoiyase Melqui rahɨr, ahe Melqui evocoiyase Jana rahɨr, Jana evocoiyase José rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ahe José Matatías rahɨr, Matatías evocoiyase Amós rahɨr, ahe Amós evocoiyase Nahúm rahɨr, Nahúm evocoiyase Esli rahɨr, ahe Esli Nagai rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai evocoiyase Maat rahɨr, ahe Maat Matatías rahɨr, Matatías evocoiyase Semei rahɨr, ahe Semei evocoiyase Josec rahɨr, Josec evocoiyase Judá rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ahe Judá Joanán rahɨr, Joanán evocoiyase Resa rahɨr, ahe Resa evocoiyase Zorobabel rahɨr, Zorobabel evocoiyase Salatiel rahɨr, ahe Salatiel Neri rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri evocoiyase Melqui rahɨr, ahe Melqui Adi rahɨr, Adi evocoiyase Cosam rahɨr, Cosam evocoiyase Elmadam rahɨr, Elmadam evocoiyase Er rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ahe Er Jesús rahɨr, Jesús evocoiyase Eliezer rahɨr, ahe Eliezer Jorim rahɨr, Jorim evocoiyase Matat rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ahe Matat Leví rahɨr, Leví evocoiyase Simeón rahɨr, ahe Simeón evocoiyase Judá rahɨr, Judá evocoiyase José rahɨr, ahe José Jonam rahɨr, Jonam evocoiyase Eliaquim rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea rahɨr, ahe Melea Mena rahɨr, Mena evocoiyase Matata rahɨr, ahe Matata evocoiyase Natán rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David rahɨr, ahe David evocoiyase Isaí rahɨr, Isaí Obed rahɨr, ahe Obed evocoiyase Booz rahɨr, Booz Sala rahɨr, ahe Sala evocoiyase Naasón rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadab rahɨr, ahe Aminadab evocoiyase Admin rahɨr, Admin evocoiyase Arni rahɨr, Arni evocoiyase Esrom rahɨr, ahe Esrom evocoiyase Fares rahɨr, Fares evocoiyase Judá rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ahe Judá Jacob rahɨr, Jacob evocoiyase Isaac rahɨr, ahe Isaac Abraham rahɨr, Abraham evocoiyase Taré rahɨr, Taré evocoiyase Nacor rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ahe Nacor Serug rahɨr, Serug evocoiyase Ragau rahɨr, ahe Ragau evocoiyase Peleg rahɨr, Peleg Heber rahɨr, ahe Heber evocoiyase Sala rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán rahɨr, ahe Cainán evocoiyase Arfaxad rahɨr, Arfaxad evocoiyase Sem rahɨr, ahe Sem evocoiyase Noé rahɨr, Noé evocoiyase Lamec rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ahe Lamec Matusalén rahɨr, Matusalén evocoiyase Enoc rahɨr, Enoc evocoiyase Jared rahɨr, ahe Jared Mahalaleel rahɨr, Mahalaleel evocoiyase Cainán rahɨr, ");
INSERT INTO gyrNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ahe Cainán evocoiyase Enós rahɨr, Enós evocoiyase Set rahɨr, ahe Set Adán rahɨr, Adán evocoiyase Tũpa rahɨr. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Espíritu Santo rese ité secoi. Ahe osẽ ɨai Jordán sui oso. Ipare Espíritu vɨroguata ɨvɨ iporupɨrẽhɨsa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aheve cuarenta arɨ secoise Caruguar osecoãha. Ndocarui avei oico. Sese ndasɨepoi eté. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Caruguar evocoiyase aipo ehi chupe: —Tũpa Rahɨr ité nde recose, co ita sui eyapo pan cũritei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Evocoiyase Jesús omboyevɨ chupe: —Che Ru ñehe rumo icuachiaprɨ pɨpe aipo ehi: ‘Ndahei chira pan suiño ava yuvɨrecovera’ ehi —ehi Caruguar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ipare Caruguar vɨraso ɨvate vahesave. Aheve ñepei reseve opacatu ava-ava tẽi mborerecuasa ɨvɨ pɨpendar omboyecua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ipare aipo ehi chupe: —Che amondora opacatu ɨvɨ rupindar mborerecuar pĩratasa iyavei mbahe porañete vahe nde povrɨve. Esepia niha, co opacatu cheu imbouprɨ; iya ité amondo vaherã ava upe che remimbotar rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Acoi ereñenopɨhase cheu che mboetei ãgua, ahese opacatu co mbahe ereipɨsɨra nde mahera —ehi tẽi Caruguar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—Icuachiaprɨ pɨpe rumo: ‘Emboetei nde Yar Tũpa, ahe güeraño tuprɨ avei eremboyeroyara’ ehi —ehi Caruguar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ipare Caruguar vɨraso oyeupi tecua guasu Jerusalén ve. Aheve ovɨroyeupi tũparo apɨterve. Aheve Caruguar aipo ehi chupe: —Tũpa Rahɨr ité nde recose, evɨapi cohave sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Esepia niha, icuachiaprɨ pɨpe: ‘Tũpa oyocuaira güembiguai eta nde rãro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ahe nde mopuhara yuvɨreco que ñepei ita nde momara rãgüer sui’ ehi —ehi Caruguar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Evocoiyase omboyevɨ Caruguar upe: —¡Aní! Icuachiaprɨ pɨpe niha aipo ehi avei: ‘Nderesecoãhai chira nde Yar Tũpa’ ehi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ahese Caruguar ndoicatu iri eté Jesús recoãha ãgua oico. Ipare oyepepɨño raimi tẽi oso ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús, Espíritu Santo reco pĩratasa pɨpe, oyevɨ oso Galilea ve. Ipare serãcua oguata opacatu tecua-tecuami rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Esepia, ahe oporombohe judío tũparo pɨpe oico. Ahese opacatu ava omboetei yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ichui Jesús oyevɨ Nazaret ve ocuacua agüerve. Aheve judío mbɨtuhusa arɨ pɨpe oique tũparove inungar oyapo yepi. Ahese opũha ‘tayeroquɨ icuachiaprɨ maranehɨ pɨpe’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Evocoiyase tũparo rese ñangarecuar pɨ̃tɨvɨisar omondo Tũpa ñehe mombehusar Isaías rembicuachía chupe. Oyorase ahe cuachiar, oyeroquɨ icuachiaprɨ aipo ehi vahe pɨpe ohã: ");
INSERT INTO gyrNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—“Yar Espíritu secoi che rese. Esepia niha, ahe ombou che cuaitarã cheu co ñehesa avɨye vahe mombehu ãgua ava iparaɨsu vahe upe. Che cuaita avei ava mbahe-mbahe tẽivrɨve yuvɨrecoi vahe senose ãgua ichui, iyavei ava ndasesapɨsoi vahe ambosarecora; iyavei che cuaita ava mbahe-mbahe tẽi rasɨcuer oiporara vahe sui senose ãgua, ");
INSERT INTO gyrNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","iyavei ‘cũritei Yar oyemoingatu oporovasasa mondo ãgua pẽu’ he ãgua” ehi icuachiaprɨ pɨpe —ehi oyeroquɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sese oyeroquɨ pare, oyapoapɨpa cuachiar imondo tũparo rese ñangarecuar pɨ̃tɨvɨisar upe. Ipare oguapɨ oĩ ava rembiepiave. Ahese opacatu tũparo pɨpendar omahe atɨ yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Evocoiyase ahe oñehe aipo ehi: —Cũritei yavɨye co icuachiaprɨ pɨpendar opacatu pe rovaque —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Opacatu ava oñehe tuprɨño ité yuvɨreco sese. Ndoyembovɨhai tẽi iñehe tuprɨ renduse yuvɨreco. Oporandu-randu rumo yuvɨreco oyeupe: —¿Ndahei vo acoi co José rahɨr tẽi? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ahe rumo aipo ehi ava upe: —Pe aipo peyera cheu: ‘Oporombogüera vahe, eñeposano nde ae eico’ peyera. Ipare aipo peyera cheu: ‘Acoi orosendu vahe nde rembiapogüer Capernaum pɨpe, ẽgüe ere avei eyapo cohave nde recua pɨpe ité’ peyera cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","—Supi eté, ndipoi eté niha que ñepei yepe Tũpa ñehe mombehusar oipɨsɨ tuprɨ vahe güecua pɨpe yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Supi tuprɨ ité Tũpa ñehe mombehusar Elías recose, iñehe rupi tuprɨ ndoquɨi eté mbosapɨ aravɨter yemombɨtesa rupi oico. Sese oime tɨavor opacatu Israel ɨvɨ rupi aracahe. Ahese setá eteprɨ cuña imer mano vahecuer oime Israel recua rupi viña, ");
INSERT INTO gyrNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tũpa rumo nomondoi Elías cuña imer mano vahecuer Israel pendar upe ipɨ̃tɨvɨi ãgua. Ẽgüe ehi rumo omondo cuña ndahei vahe Israel pendar ipɨ̃tɨvɨi ãgua. Ahe cuña tecua Sarepta pendar, ahe Sarepta Sidón ɨ̃pɨimindar. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Iyavei setá ava oime Israel recua pɨpendar imbaheasɨ vahe lepra rerecosar yuvɨreco evocoi Tũpa ñehe mombehusar Eliseo recose. Evocoi ava yuvɨrecoi vahe rumo ndipoi eté que ñepei ocuera vahe yuvɨreco; Naamán año rumo Eliseo opa uca ombogüera, ahe mbɨa Siria pendar ndahei vahe Israel pendar secoi —ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ahese opacatu ava judío tũparo pɨpendar oñemoɨró iteanga yuvɨreco sese aipo mbahe renduse. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Sese opa voi eté opũha Jesús reraso ãgua tecua pɨpe sui ɨvɨtrɨ ɨvɨ socuerve yuvɨreco, ahe iharɨve tecua yaposa. Ahe ichui oitɨ pota yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesús rumo ipãhu sui osẽ tuprɨño oso. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ichui Jesús oso Capernaum ve, ahe tecua Galilea rupindar. Aheve ombohe ava oico mbɨtuhusa arɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ipare opacatu ava, “¡Mara ehi rutei!” ehi tẽi iporombohesa renduse yuvɨreco. Esepia niha, ahe oñehe güeco pĩratasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aheve judío tũparo pɨpe oime mbɨa vɨreco vahe caruguar oyese, ahe oñehe pĩrata Jesús upe: ");
INSERT INTO gyrNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ore mañeco tẽi eme eve! ¡Mahera ereyuño tẽi cohave oreu, nde, Jesús Nazaret pendar! ¿Ereyu vo ore mocañɨ ãgua tẽi? Che orocua ité. Nde niha seco maranehɨ vahe ereico Tũpa suindar —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Evocoiyase, —¡Quiriri, esẽ co mbɨa sui! —ehi oñehe pĩrata caruguar upe. Ahese caruguar ombovɨapi ahe mbɨa ava rovai, osẽ ocua ichui; nomomarai eté rumo. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Opacatu ava oyembosɨquɨye, iyavei oporandu-randu tẽi mbahe rese oyeupe yuvɨreco: —¿Mara ehi vo aipo oñehe oico? ¡Esepia, co mbɨa opĩratasa pɨpe oyocuai caruguar ava sui imose ãgua! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Sese Jesús rerãcua oyandu opacatu tecua-tecuami ɨvɨrindar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Evocoiyase Jesús osẽ judío tũparo pɨpe sui oso, oique Simón Pedro rẽtave. Simón rembireco sɨ sohɨ́ iteanga ou. Evocoiyase oñehe ahe pendar sese Jesús upe ‘tombogüerami tẽi’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Evocoiyase Jesús oyeaɨvɨ oso chupe sohɨ sui imbogüera ãgua. Ocuera pare voi ahe cuña oñarapuha; ohañeco ahe ava yuvɨrecoi vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Arɨ so ramomise opacatu ava imbaherasɨsa ambuae tẽi vahe güeru Jesús upe yuvɨreco. Ahe evocoiyase opo omondo iyacatu iharɨve ñepei-pei imbogüera. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Iyavei setá ava sui opa omose caruguar. Evocoiyase caruguar osapucai tẽi aipo ehi yuvɨreco: —¡Nde acoi Tũpa Rahɨr ité ereico! —ehi. Ahe rumo oñehe pĩrata caruguar upe, nomoñehe iri. Esepia niha, caruguar oicua ité ahe Tũpa Rembiporavo seco rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ahere ayihive cõhe ramomise, Jesús osẽ tecua pɨpe sui, oso ɨvɨ iporupɨrẽhɨsave. Ava rumo oseca-secaño ité yuvɨreco; osupitɨño ité secosave yuvɨreco. Oipota ahe oyesui ichoẽhɨ ãgua ité yuvɨreco vinã. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ahe rumo aipo ehi ava eta upe: —Tamombehu rane catu ambuae tecuave avei ñehesa avɨye vahe Tũpa mborerecuasa resendar ava upe. Esepia, aherã niha che mbousa —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ẽgüe ehi Jesús oguata oporombohe Judea tũparo rupi oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ñepei arɨ Jesús secoi ɨpa Genesaret popɨ rupi. Aheve ava rehɨi oyepota yuvɨreco chupe, oyere atɨ yuvɨreco sese. Esepia niha, ahe osendu pota ité Tũpa Ñehengagüer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Aheve oime ñuvɨrío carite ɨmbehɨ popɨve. Ahe ava pira mbohasar opa yuvɨnose evocoi carite pɨpe sui yuvɨreco. Ipare opira mbohasa oyosei yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Evocoiyase Jesús osepiase, oha Simón carite pɨpe iyavei aipo ehi chupe: “Tosɨrɨ catumi tẽi chĩhi coi cotɨ ɨai popɨ sui” ehi. Ipare oguapɨ oĩ carite pɨpe. Aheve ombohe ava cute. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Oñehe pare aipo ehi Simón upe: —Yaso ɨpa tɨpɨ catu vahesave. Aheve erembohara pira —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón rumo omboyevɨ chupe: —Porombohesar, orosãha tẽi niha pɨ̃tu momba pira mboha oroico. Nde porocuaita pɨpe rumo amondo irira pira mbohasa ɨve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ẽgüe ehise, pira rehɨi omondoromi ombohasa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ahese oyaitɨ yuvɨreco omboetasa evocoi ambuae carite pɨpe yuvɨrecoi vahe upe ‘toyugüerumi yande pɨ̃tɨvɨi’ oyapave yuvɨreco chupe. Ahe yugüeru chupe. Ipare opa ñuvɨrío carite omboapɨpo tuprɨ yuvɨreco; seni iri rumo omondo ɨpɨve. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Co mbahe repiase, Simón Pedro oñenopɨha oso sovai aipo ehi chupe: —¡Eyepepɨmi tẽi che sui, che Yar! ¡Esepia, che yangaipa vahe tẽi aico! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Esepia, Simón iyavei opacatu ava yuvɨrecoi vahe supi osɨquɨyé iteanga co pira rehɨi repiase yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Iyavei Simón mboetasa ambuae carite pɨpendar ahe Santiago, Juan Zebedeo rahɨr yuvɨrecoi. Jesús rumo aipo ehiño Simón upe: —Eresɨquɨye eme; co pɨpe suive inungar pira eremboha, ẽgüe ere aveira ava reca cheu nara —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Evocoiyase opa vɨnose carite ɨvɨ ãtasave yuvɨreco, oseyapaño opacatu mbahe. Ipare yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ñepei arɨ Jesús secoise tecua pɨpe, aheve oime mbɨa lepra vɨreco vahe opacatu güetecuer rese. Jesús repiase, oñenopɨha oyeaɨvɨ oso chupe. Ipare oporandu aipo ehi: —Che Yar, ereipotase, iya nde che mbogüerami eve —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Evocoiyase, opocose sese, —Aipota. ¡Erecuerara cũritei! —ehi chupe. Aipo ihe ramoseve voi eté ocuera. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ipare oyocuai aipo ehi chupe: —Eremombehu eme nde cuerasa ambuae ava upe; esoño, eyemboyecua judío pahi upe. Ipare eicuavẽhe nde porerecosa nde cuerasa resendar Moisés porocuaita rupi. Ipɨpe sui toicua opacatu ava nde cuerasa yuvɨreco —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesús rerãcua rumo oyembouvicha catu-catu iri eté. Evocoiyase setá ava oyemboya yuvɨreco sese iñehe rendu ãgua ‘tayande mbogüerami tẽi yande mbaherasɨsa sui’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ava rehɨi sui rumo amove Jesús oyepepɨño ahe aemi oyerure ãgua yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ñepei arɨ Jesús oporombohe oico. Yar Tũpa pĩratasa vɨreco oyese ava mbogüera ãgua. Aheve avei oguapɨ yuvɨnoi fariseo, Moisés porocuaita rese oporombohe vahe avei ipɨri yuvɨreco. Ahe yugüeru opacatu Galilea tecua-tecuami rupi sui yuvɨreco. Ɨvɨ Judea rupi sui, tecua Jerusalén sui avei yugüeru no. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ahese ava ndoguatai vahe güeru supa pɨpe yuvɨreco. Vɨroique pota oɨ pɨpe sovai eté seroyɨ ãgua yuvɨreco viña; ");
INSERT INTO gyrNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ndoicatui eté rumo seroique yuvɨreco ava rehɨi pãhu rupi. Evocoiyase vɨroyeupi yeupisa rupi ahe oɨ ipe vahe harɨve yuvɨreco. Aheve vɨrocua teca ichui. Supi vɨroyɨ imbaheasɨ vahe supa pɨpe imondo yuvɨreco opacatu ava rembiepiave sovai. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ahe oicuase co mbɨa yuvɨrecoi vahe oyese yeroyasa, ahese aipo ehi imbaheasɨ vahe upe: —Che mborɨpar, che ñero nde angaipa rese ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ichui oporombohe vahe Moisés porocuaita rese iyavei fariseo ipɨhañemoñeta atɨ voi tẽi yuvɨreco: “Co mbɨa oyemboɨvate ai tẽi vahe Tũpa ñehe nungar pɨpe tẽi; Tũpaño ité niha oicatu ava angaipa upe oñero ãgua” ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ahe rumo oicuaño ité ahe ava pɨhañemoñetasa. Evocoiyase aipo ehi chupe: —¡Mahera vo pepɨhañemoñeta rai tẽi che rese! ");
INSERT INTO gyrNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Uma rupi vo ñehesa ndayavaimi catu: ‘Nde angaipa rese che ñero ndeu’ hesa pĩha, anise: ‘Epũha, eguata’ hesa tie? ");
INSERT INTO gyrNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tapeicua ru che, Ava Rɨquehɨr, areco ité mborerecuasa co ɨvɨ pɨpe ava angaipa upe che ñero ãgua —ehi. Evocoiyase, —Eñarapuha, esupi nde rupa, eso nde rẽtave —ehi imbaheasɨ vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ahese opũha voi ava rovaque, osupi vupagüer. Ipare osapucai oso güẽtave Tũpa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ahese opacatu tuprɨ ité ava, “¡Too! ¿Mara ehi rutei pĩha co?” ehi tẽi imboeteisave yuvɨreco. Iyavei osɨquɨyepave aipo ehi yuvɨreco: —Co pɨpe yasepia mbahe ndayasepiai vahe ité —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ichui osẽse Jesús, osepia mbɨa Roma ve nara guarepochi rerocuasar Leví serer vahe, ahe guarepochi rerocuasave chini. Sepiase, —Erio che rupi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Evocoiyase Leví opũha. Oseyapa oporavɨquɨsa, oso supi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ipare Leví oyapo pieta guasu chupe nara güẽtave. Aheve iyemborɨsave setá imboetasa ava guarepochi rerocuasar iyavei ambuae ava ocaru yuvɨnoi ipɨri. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pieta repiasar fariseo yuvɨrecoi vahe rumo iyavei ipãhu pendar Moisés porocuaita rese oporombohe vahe avei, ahe omboɨpɨ semimbohe upe oñehe mara aipo ehi yuvɨreco chupe: —¡Mahera ru pecaru iyavei pecahu guarepochi rerocuasar rese iyavei ambuae ava yangaipa guasu vahe rese tẽi avei no! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús rumo aipo ehi chupe: —Ava nimarai vahe ndosecai eté oporoposano vahe; imbaheasɨ vaheño rumo oseca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Esepia, che ndayui ava seco catuprɨ vahe reca; che rumo ayu ava yangaipa vahe reca Tũpa uve iyevɨ ãgua yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ipare ava oporandu yuvɨreco chupe: —¿Mahera vo oyecuacu serai iyavei oyerure Juan Oporoãpiramo vahe rupindar yuvɨreco, fariseo rupindar avei no; nde remimbohe rumo yuvɨrocaruño ité, yuvɨroɨhuño avei no? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ahe rumo omboyevɨ chupe aipo ehi: —Ndiyai eté ichohoprɨ mboyecuacu mendasave imer oicove vɨteseve ipãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Oimera rumo arɨ imer reraso ãgua ichui, ahese ramo oyecuacura yuvɨreco cute —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iyavei ambuae mbahe rese oporombohe imboyevɨ ãgua: —Ndiyai eté ava upe vɨrocua vaherã turucuar ipɨasu vahe sui ambuae turucuar cuacuami vahe apete ãgua. Esepia niha, ẽgüe ehise evocoiyase turucuar ipɨasu vahe omomara; iyavei turucuar ipɨasu vahe apɨrer naporai chira turucuar cuacua vahe rese —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Iyavei no, ndiyai eté ñoñasa uva rɨcuer pɨasu mbahe pirer cuacua pɨpe no. Esepia niha, ẽgüe ehise, uva rɨcuer pɨasu evocoiyase opara ombopu mbahe pirer cuacua viña, ẽgüe ehira oyepɨyerepa, mbahe pirer avei evocoiyase ocañɨ tẽira viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Uva rɨcuer pɨasu rumo yamondora mbahe pirer pɨasu pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iyavei ndipoi eté que ava oɨhu vahe uva rɨcuer ipɨasu vahe yuvɨreco uva rɨcuer cuacua vahe yusei ai pare. Esepia niha, ava aipo, ‘Co uva rɨcuer cuacua vahe avɨye catu vahe yepi’ ehi yuvɨreco —ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ñepei mbɨtuhusa arɨ pɨpe Jesús vɨroguata güemimbohe mbahe mitɨ pãhu rupi. Semimbohe evocoiyase oipoho-poho yuvɨraso trigo rãhɨi. Ipare oyequɨi opo pɨpe sãhɨi yuvɨreco ɨgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Evocoiyase fariseo osepiase, aipo ehi yuvɨreco semimbohe eta upe: —¡Mahera peporavɨquɨño tẽi co mbɨtuhusa arɨ pɨpe peico! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús rumo omboyevɨ chupe: —Peicua tẽi niha icuachiaprɨ aracahendar mborerecuar guasu David rembiapogüer resendar ñehesa ondugüer reseve ndasɨepoise yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ahe niha oique ité Tũpa rẽta pɨpe, opoco pan imboeteiprɨ Tũpa upendar rese evocoi pahi upe güeraño ipotasa vahe ihu ãgua yepi. Ahe rumo ohu, ondugüer tohu avei omondo —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iyavei aipo ehi chupe: —Ava Rɨquehɨr mbɨtuhusa arɨ rerecuar ité secoi —ehi fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ambuae mbɨtuhusa arɨ pɨpe, Jesús oique judío tũparo pɨpe oporombohe oico. Aheve mbɨa yasu cotɨ ipo nomɨi vahe secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisés porocuaita rese oporombohe vahe, fariseo avei omahengatu Jesús rese yuvɨreco ‘¿ombogüerara pĩha co mbɨa mbɨtuhusa arɨ pɨpe?’ oya; ‘yaiñehengapo angahu’ oyapave tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ahe rumo oicuaño ité ipɨhañemoñetasa oico. Ipare aipo ehi evocoi mbɨa ipo nomɨi vahe upe: —Epũha cohave terehã ava pãhuve —ehi. Ahe mbɨa evocoiyase opũha, opɨta aheve ohã ");
INSERT INTO gyrNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ahese Jesús oporandu ahe ava upe: —Aporandura mbahe rese pẽu —ehi—. ¿Mbahe vo yaposara mbɨtuhusa arɨ pɨpe yepi, mbahe tuprɨ pĩha, anise mbahe naporai vahe tie? ¿Yaipɨ̃sɨro pĩha ava recocuer; yamocañɨ uca tẽi tie? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Evocoiyase omahengatu oyese ava oyere tuprɨ vahe rese. Ipare aipo ehi ava ipo nomɨi vahe upe: —Eichoho nde yɨva —ehi. Ahe mbɨa evocoiyase oichoho oyɨva; evocoiyase ipo ocuera tuprɨ ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Evocoiyase oñemoɨro catuño ité yuvɨreco sese, iyavei oporandu-randu oyeupe yuvɨreco ‘¿mara yahera pĩha imomara ãgua?’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ahe arɨ rupi Jesús oso ɨvɨtrɨve, oyerure pɨ̃tu momba tuprɨ Vu upe oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Cõhese, “Perió” ehi güemimbohe eta upe. Ipãhu sui oiporavo doce tuprɨ, ahe chupe, “Apóstol” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Co ahe yuvɨrecoi: Simón, ahe acoi Pedro avei serer; Andrés Simón rɨvrɨ; Santiago, Juan, Felipe, iyavei Bartolomé; ");
INSERT INTO gyrNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago Alfeo rahɨr; Simón, ava güecua rese secatẽhɨ́ vahe pãhu pendarer; ");
INSERT INTO gyrNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas Santiago rɨvrɨ; iyavei Judas Iscariote, ahe omondo vahe Jesús yamotarẽhɨmbar uve. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ipare Jesús ogüeyɨ ɨvɨtrɨ sui yugüeru co doce güemimbohe reseve. Ipare opɨta ɨvɨ yoya tuprɨsave. Aheve ambuae semimbohe eta oyemboya atɨ yuvɨreco sese iyavei setá ava yuvɨrecoi opacatu tecua Judea rupindar, Jerusalén rupindar iyavei yemboyasa Tiro, Sidón cotɨndar, ahe oyemboya avei yuvɨreco sese. Ahe ava ẽgüe ehi iñehe rendu potasave yuvɨreco ‘tayande mbogüerami tẽi yande mbaherasɨsa sui’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Acoi espíritu naporai vahe remimombaraɨsu avei ocuera tuprɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Evocoiyase opacatu ava opoco pota ité sese yuvɨreco. Esepia niha, ahe oporombogüera opacatu güeco pĩratasa pɨpe oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ipare omahe Jesús güemimbohe rese aipo ehi chupe: “Perorɨvete catu pe iparaɨsu vahe. Esepia niha, Tũpa mborerecuasa pẽu nara ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Perorɨvete catu cũriteindar ndasɨepoi vahe. Esepia niha, pehɨ̃tarora peico curi. “Perorɨvete catu pe acoi ava cũritei oyaseho vahe. Esepia niha, pevɨharetera coiye peico. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Perorɨvete catu pe acoi ava pe amotarẽhɨse, pe mboyepepɨñose avei oyesui yuvɨreco, iñehe-ñehe tẽise yuvɨreco pẽu pe amotarẽhɨsave, iyavei acoi vɨroɨ̃rose pe rer mbahe tẽi pɨpe che, Ava Rɨquehɨr, recocuer sui tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Peyembovɨhaño iyavei perorɨvete catuñora ahe arɨ pɨpe peico. Esepia niha, ipare peipɨsɨra porerecosa tuvichá vahe ɨvave. Ẽgüe ehi tuprɨ avei evocoi ava ramoi aracahendar mara-mara tẽi Tũpa ñehe mombehusar sereco yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“¡Peparaɨsu catu rumo cũritei mbahe yar peico vahe! ¡Esepia niha, pemboavɨye pe rorɨvetesa peico! ");
INSERT INTO gyrNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Peparaɨsu catu acoi pe ihɨ̃taro vahe cũritei! ¡Esepia niha, ndaperɨepoi chira peico coiye! “¡Peparaɨsu catu acoi pevɨha vahe pe pietase cũritei! ¡Esepia, peyasehora pe vɨharẽhɨsa pɨpe peico coiye! ");
INSERT INTO gyrNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Peparaɨsu catu acoi peipɨsɨ vahe pe mboeteisa opacatu co ɨvɨ pɨpendar ava tẽi sui! ¡Esepia niha, ẽgüe ehi tuprɨ tamoi Tũpa ñehe mombehusar angahu tẽi vahe upe yuvɨreco aracahe!” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pe che ñehe rese peyapɨsaca vahe upe rumo aipo ahe: Pesaɨsu ava pe amotarẽhɨmbar; peyapo tuprɨ mbahe avɨye vahe ava nape ambotai vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Peporandu Tũpa porovasasa rese ava pẽu iñehe-ñehe tẽi vahe upe nara; peyerure Tũpa upe pẽu mbahe tẽi oyapo vahe recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Acoi que pe amotarẽhɨmbar pe rovapetese, co cotɨndar avei pemoporẽhɨñora chupe. Iyavei acoi que ava vɨrocuaño tẽise pe yeaosa pe sui, tovɨraso avei pe yemondesa güemimbotar rupi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Acoi oporanduse que pe mbahe rese yuvɨreco pẽu, pemondoño avei chupe. Iyavei acoi que ava vɨrocuaño tẽise pe mbahe pe sui, ndapeporandui chira pẽu imboyevɨ ãgua rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Acoi mbahe peipota vahe ambuae ava oyapo vaherã pẽu, ahe tuprɨ avei peyapora chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Acoi ava pe raɨsupar güeraño pesaɨsu catu tẽise, ndipoi eté mbahe avɨye vahe ipɨpe. Esepia niha, ava naporai vahe ẽgüe ehi yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Anise, acoi ava mbahe tuprɨ ai oyapo vahe pẽu, chupe güeraño mbahe tuprɨ peyapose, ¿mbahe vo evocoiyase oime avɨye vahe ipɨpe? Esepia niha, ava angaipa viyar avei ẽgüe ehi yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Acoi pemondoño tẽise mbahe ava upe ‘tomboyevɨ mbahe cheu’ pe hesave, ¿mbahe vo evocoiyase oime avɨye vahe ipɨpe? Esepia niha, ava angaipa viyar ẽgüe ehi avei yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pe rumo pesaɨsu catura ava pe amotarẽhɨsar, peyapoñora mbahe avɨye vahe chupe. Iyavei pemondoño itera mbahe chupe, ‘Tasãroño rane mbahe cheu imboyevɨ ãgua vichico’ ndapeyei chietera. Ahese oimera porerecosa avɨye catu vahe pẽu. Pe evocoiyase Tũpa seco ɨvate catu vahe rahɨr peicora. Esepia niha, ahe avɨye eteprɨ vahe ava ‘avɨye ndeu’ ndehi vahe upe iyavei ava yangaipa guasu vahe upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pe peporoparaɨsuereco inungar pe Ru Tũpa oporoparaɨsuereco yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ndiyai, ‘Oyavɨ ité mbahe’ peye voiño tẽi ambuae ava upe. Evocoiyase Tũpa, ‘Oyavɨ mbahe’ ndehi chira pẽu. Pemocañɨ uca tẽi eme ambuae ava. Evocoiyase Tũpa ndape mocañɨ tẽi chira. Peñeroño catu ambuae ava upe, ahese Tũpa iñero itera pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pemondose mbahe ava upe, evocoiyase Tũpa omondoño itera mbahe avɨye vahe pẽu inungar-ra omondo pe mbahe rɨru pɨpe pẽu sãhambrɨ tuprɨ avɨye vahe viña. Ẽgüe ehira mbahe imondo pẽu. Tũpa oicua tuprɨ itera pẽu inungar pe mbahe pemondo ambuae ava upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ipare Jesús omombehu co ambuae porombohesa: “¿Oicatu pĩha ñepei ndasesapɨsoi vahe ambuae ndasesapɨsoi vahe reroguata? ¡Aní eté! Esepia, oyoya voi ovɨapira que ɨvɨcuar pɨpe yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ñepei yepe niha ava oyembohe vahe ndahei eté ɨvate catu ombohesar sui. Acoi omomba vahe rumo oyembohesa ahe osupitɨra ombohesar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Mahera ambuae ava rembiavɨmi rese tẽi pemahe? Iya rumo peyese rane mbahe tuvicha catu vahe pesepiara. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndiyai pẽu, ‘Che toropɨ̃tɨvɨi mbahe nde rembiavɨ rese’ peye vaherã chupe. Esepia, pe peyavɨ guasu catu mbahe. ¡Pe Tũpa reroyasar angahu tẽi peico vahe! Penose uca rane pe rembiavɨ tuvicha catu vahe peyesui, ahese ramo ambuae ava rembiavɨ tahɨmi vahe moingatu peicatura” ehi oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","“Ɨvɨra avɨye vahe icuasa iha rese. Esepia, ɨvɨra avɨye vahe, iha avɨye avei; ɨvɨra naporai vahe, iha naporai avei no. Supi eté ndipohosai ɨvɨra sãchi atɨ vahe sui higuera ha, iyavei ndahipohosai uva, yu pãhu sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ẽgüe ehi avei ava upe. Ava avɨye vahe oyapo mbahe tuprɨ. Esepia, ahe vɨreco mbahe tuprɨ opɨha pɨpe yepi. Iyavei acoi ava ndaseco põrai vahe oyapo mbahe tẽi. Esepia niha, ahe vɨreco mbahe tẽi eté opɨha pɨpe yepi. Esepia niha, pe pɨha pɨpe sui tẽi osẽ pe ñehe ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Mahera vo, ‘Che Yar, che Yar’ peye tẽi peico cheu; ipare ndapeyapoi eté mbahe che remimombehu? ");
INSERT INTO gyrNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Amombehura rumo mbahe pẽu uma nungar tuprɨ ité acoi ava ou vahe cheu che ñehe rese oyapɨsaca vahe, iyavei oyapo ité vahe mbahe che remimombehu: ");
INSERT INTO gyrNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ahe inungar tuprɨ ité acoi ava oyapo vahe güẽtara ita harɨve yepi. Yɨpɨndar rumo oyoho pɨcucu rane ité ita harɨve imopuha ãgua. Yepe ahe oɨ upe oyepota tẽi ɨvɨtu ai, amarusu reseve oinupa pĩrata tẽi, nomboyerocuai eté rumo. Esepia niha, vɨreco ité ovɨ̃racuasa. ");
INSERT INTO gyrNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Acoi ava che ñehengagüer rese ndoyapɨsacai vahe rumo, ahe ndoyavɨi acoi ava oyapo vahe güẽtara ɨvɨ cuhi harɨve tẽi, ndovɨrecoi eté ovɨ̃racuasa. Ipare amar, ɨvɨtu ai reseve oinupa pĩratá, opaño omonduru; ocañɨ tẽi eté evocoiyase” ehi Jesús ava mbohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús oñehepase ava upe oico, oso Capernaum ve. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ahe tecua pɨpe sundao rerecuar ndahei vahe judío secoi vɨreco vahe güemimboacua güembiaɨsu. Ahe imbaheasɨ guasu ité ou; omano pota ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesús rerãcua anduse rumo, oyocuai movɨro tẽi omborɨpar judío imboeteiprɨ chupe iñehe ãgua ‘toumi tẽi che remimboacua mbogüera’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ahe judío evocoiyase oyemboya Jesús rese yuvɨreco iyavei oporandu yuvɨreco chupe aipo ehi: —Ore mborɨpar sundao rerecuar oipota nde ereyapomi tẽira mbahe icatuprɨ vahe chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Esepia niha, ore raɨsu iyavei ahe teieté oyapo uca tũparo oreu nara —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Evocoiyase oso ahe yuvɨrecoi vahe rupi. Vɨrovɨse rumo sẽta yuvɨreco, ahese sundao rerecuar omondo ambuae omborɨpar chupe. Imborɨpar evocoiyase omombehu iñehe aipo ehi vahe: “ ‘Che Yar, ereyemañecoi rene. Esepia niha, ndiyai eté che rẽta pɨpe nde reique ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Sese niha che teieté ndasoi nde reca. Nde ñehe pɨpe tẽi rumo che remimboacua erembogüerara. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Esepia, che avei niha areco che cuaita. Iyavei areco sundao che voya. Eso peve, ahese ñepei upe, ahe evocoiyase oso voi eté; ambuae upe: Erio, ahese, ou voiño ité cheu. Ipare, Ereyapora co mbahe, ahese che rembiguai upe, ahe evocoiyase che reroyaño voi’ ehi ore mborɨpar” ehi Jesús upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Aipo oyeupe hese Jesús, “¡Too!” ehi. Ipare aipo ehi vupindareta upe: —Supi eté ndasepiai vahe ité co mbɨa che reroya tuprɨ vahe nungar judío eta pãhuve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yuvɨroyevɨpase sundao rerecuar mborɨpar sẽtave yuvɨreco, aheve osepia evocoi semimboacua yuvɨreco ocuera tuprɨse. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ipare voi Jesús oso tecua Naín ve, iyavei semimbohe yuvɨrasoño ité supi ava rehɨi reseve avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Vɨrovɨse tecua oso, osepia tehõgüer ava vɨrocuase yuvɨreco ñotɨ ãgua. Ahe cuña imer mano vahecuer membrɨ ñepei vahe ité viña. Tecua pɨpendar setá iteanga ava yuvɨraso supi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cuña repiase rumo, oiparaɨsuereco. Ipare aipo ehi chupe: —Ereyaseho eme —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Evocoiyase oyemboya oso, opoco tehõgüer rɨru rese. Sese ovosɨi vahe evocoiyase vɨropɨtaño yuvɨreco chupe. Ipare aipo ehi tehõgüer upe: —Mbɨa chĩhivahe, che aipo ahe ndeu: ¡Eñarapuha! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Evocoiyase omano vahecuer oñarapuha oĩ iyavei oñehe no. Ichui Jesús omondo ichɨ upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Opacatu tuprɨ ité ava oyembosɨquɨye sepiase yuvɨreco: —Cũritei oyemboyecua Tũpa ñehe mombehusar seco ɨvate vahe yande pãhuve cute —ehi yuvɨreco. Iyavei, —Tũpa niha ou güecua pɨ̃tɨvɨi ãgua oico —ehi avei yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ipare co Jesús rerãcua yandusa opacatu Judea rupi, yɨvɨrindar rupi avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan avei oyandu opacatu co mbahe oico. Esepia niha, supindareta omombehupa co mbahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Evocoiyase omondo ñuvɨrío vupindar Jesús upe mbahe rese porandu ãgua ‘¿nde ité vo Tũpa Rembiporavo aipo sãrombrɨ ereico, anise oime tie ambuae orosãro vaherã?’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Evocoiyase oyepota yuvɨraso Jesús upe aipo ehi yuvɨreco chupe: —Juan Oporoãpiramo vahe ore mbou ndeu co mbahe rese porandu ãgua: ¿Nde ité vo Tũpa Rembiporavo ereico imombehuprɨ ereyu vaherã, anise ambuae pĩha orosãrora oroico? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ahe arɨ pɨpeve voi Jesús ombogüera setá ava imbaherasɨsa sui oico, ava caruguar rerecosar sui avei no. Iyavei ava ndasesapɨsoi vahe setá ombogüera. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ahese ramo aipo ehi chupe cute: —Peso, pemombehupa Juan upe mbahe pe rembiepia iyavei pesendu vahe: “Ndasesapɨsoi vahe osareco tuprɨ cũritei yuvɨreco, ipãri-pãri vahe oguata tuprɨ, iyavei lepra rerecosar ocuerapa tuprɨ, ndayapɨsai vahe avei yapɨsapa, omano vahe opa ocuerayevɨ yuvɨreco iyavei ava iparaɨsu vahe upe imombehusa pɨ̃sɨrosa resendar ñehesa” peyera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","¡Ovɨharetera acoi ava oyeroyaño vahe che rese! —ehi Juan rupindar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan rupindar yuvɨraso pare, Jesús omboɨpɨ imombehu ava upe Juan recocuer: “¿Pesepiase Juan recocuer ava porẽhɨsave, capihiata ɨvɨtu ombova-mbova vahe nungar pĩha? ");
INSERT INTO gyrNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Anise, ¿pesepia tie iturucuar porañete ai vahe iyemboeteise? Ẽgüe ehi vahe rumo secoi mborerecuar guasu guapɨsave yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿‘Mara ehi secocuer’ peye vo chupe? ¿Tũpa ñehe mombehusar ité pĩha? Ahe ité, iyavei evocoi niha ɨvate catu vahe Tũpa ñehe mombehusar sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ahe chupe ité Tũpa icuachiaprɨ aracahendar pɨpe aipo ehi: ‘Amondora che ñehe mombehusar nde renondeve nde raperã moingatu ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Aracahe suive ndipoi eté ɨvate catu vahe Juan sui. Yepe ahe ɨvate catu vahe viña, Tũpa mborerecuasave rumo ava seco mbegüemi catu vahe ɨvate catu ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Co iñehe renduse opacatu ava, opacatu guarepochi rerocuasar yuvɨrecoi vahe avei oñeapiramo uca vahecuer Juan upe yuvɨreco: ‘Supi eté Tũpa avɨye vahe ité’ ehi eté yuvɨreco cute. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo eta rumo iyavei Moisés porocuaita rese oporombohe vahe ahe noñeapiramo uca potai vahe Juan upe yuvɨreco, ahe vɨroɨ̃roño Tũpa remimbotar oyeupendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“¿Mbahe rese pĩha amboyoyara ava recocuer cũriteindar? ¿Mara ehi pĩha secocuer? ");
INSERT INTO gyrNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ahe inungar chĩhivahe iguayɨ tẽi vahe ocar rupi. Ipare oñehe pucu-pucu omborɨpar upe yuvɨreco aipo ehi: ‘Oromoñehe tẽi mimbɨ pẽu, ndapepɨvoi eté rumo; iyavei orosapucai tẽi sapucaisa vɨharẽhɨsa resendar pẽu, ndapeyasehoi avei’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Esepia, ou Juan Oporoãpiramo vahe oico. Ahe ndohui vahe pan iyavei ndoɨhui vahe uva rɨcuer. Pe evocoiyase, ‘Co mbɨa caruguar vɨreco vahe’ peye tuprɨ tẽi chupe no. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Coiye che ayu, Ava Rɨquehɨr, acaru iyavei aɨhu tuprɨ avei. Ipare, ‘Co mbɨa icaru guasu ai vahe secoi, iɨhu guasu ai vahe avei no’ peye cheu; ‘Ava angaipa viyar mborɨpar tẽi iyavei ava guarepochi rerocuasar mborɨpar tẽi’ peye avei cheu. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ava Tũpa mbahecuasa vɨreco vahe rumo icuasara sembiapo rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo Simón serer vahe oñehe Jesús upe: “Terecarumi che pɨri” ehi. Jesús evocoiyase oso sẽtave oguapɨ oĩ mesave. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ahese cuña angaipa viyar evocoi tecua pendar secoi vahe oyandu ichose Simón rẽtave icaru ãgua. Sese vɨroyepota aheve mbahe sɨ̃acua vahe sɨru pɨpe seraso sepɨrusu vahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Aheve oyasehó ite oñenopɨha Jesús pɨve iyavei güesaɨ pɨpe opa tuprɨ omoaquɨ ipɨ. Ipare opaño omombiru oha aprɨ pɨpe ichui, iyavei oipɨrupɨte, oipɨyere avei mbahe sɨ̃acua vahe ipɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Sepiase fariseo, ipɨhañemoñeta tẽi: “Co mbɨa Tũpa ñehe mombehusar itese, oicuaño itera co cuña opoco vahe oyese ndipɨhai vahe viña” ehi tẽi fariseo chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Evocoiyase aipo ehi fariseo upe: —Simón, amombehu potami mbahe ndeu —ehi. —Avɨye Porombohesar, emombehu ru cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Evocoiyase Jesús aipo ehi chupe: —Ñuvɨrío mbɨa oime vɨrocua guarepochi mbɨa guarepochi mondosar sui yuvɨreco. Ñepei vɨrocua guarepochi quiniento tuprɨ mboravɨquɨ repɨrã ichui. Ambuae evocoiyase cincuenta rupive vɨrocua. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ipare ndoicatu irise ité imboyevɨ ãgua yuvɨreco chupe, evocoi mbɨa guarepochi mondosar iñeroño chupe yuvɨreco —ehi—. Esãha, emombehu cheu, ¿uma evocoiyase osaɨsu catura mbɨa guarepochi mondosar? —ehi fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Cheu ndoyavɨi guarepochi vɨrocua catu vahe ichui —ehi Simón. —Taa, supi eté aipo ere —ehi Simón upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Evocoiyase omahe cuña rese aipo ehi Simón upe: —¡Emahe co cuña rese! Aiquese acoi nde rẽta pɨpe, nde nderembouimi eté ɨ che pɨsei ãgua cheu; co cuña rumo güesaɨ pɨpe oyosei che pɨ. Ipare omombiru oha aprɨ pɨpe ae no. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Iyavei nde ndache rovarupɨtei eve; co cuña rumo, acoi nde rẽta pɨpe che reique ramomiseve che pɨrupɨte voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Nde nderemondoi mbahe sɨ̃acua vahe che ãca rese; co cuña rumo opa tuprɨ voi oipichi mbahe sɨ̃acua vahe che pɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sese co cuña opa oipɨsɨ ñerosa oangaipa guasu rese. Esepia, che raɨsú iteanga. Acoi ava upe nañerosa tuprɨi vahe rumo, ahe ndoporoaɨsu tuprɨi avei” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ahese aipo ehi cuña upe: —Oime nde angaipa upe ñerosa ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Evocoiyase ambuae ava ichohoprɨ oguapɨ vahe yuvɨnoi aheve, ahe aipo ehi oyeupe yuvɨreco: —¡Uma pĩha co mbɨa iñero vahe ité angaipa upe! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús rumo aipo ehiño cuña upe: —Nde yeroyasa pɨpe ereipɨsɨ pɨ̃sɨrosa. Sese eso tuprɨño eico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ipare Jesús oguata opacatu tecua rupi, omombehu ñehesa avɨye vahe Tũpa mborerecuasa resendar oico. Doce vahe apóstol supive yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cuña avei yuvɨraso supi, ahe ombogüera vahecuer caruguar rerecosa sui imbaherasɨsa sui avei no. Ahe ipãhuve avei María secoi, Magdalena serer yoapɨsa vahe, ahe ichui osẽ vahecuer siete tuprɨ caruguar; ");
INSERT INTO gyrNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","iyavei Juana Cuza rembireco, ahe mbɨa Herodes mbahe rese ñangarecuar; Susana iyavei ambuae setá cuña oipɨ̃tɨvɨi mbahe güembiereco pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Setá ava yuvɨnose tecua yacatu rupi pɨpe sui Jesús repia ãgua yuvɨreco. Ipare oñemonuha guasuse yuvɨreco, ahese Jesús setá mbahe rese omboyoya-yoya oporombohe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ñepei mbɨa osẽ omahetɨ oico. Ahe otɨapɨ-apɨise mbahe rãhɨi oso, movɨro oitɨ perɨ rupi. Ahe opa tẽi oicambe yuvɨreco, iyavei vɨ̃rai opa tẽi yuvɨrohu. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iyavei movɨro tẽi oitɨ ɨvɨ nayanai vahesave ita pãhuve. Sese cũritei sorɨ; opaño rumo ipiru. Esepia niha, ɨvɨ nañaquɨi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Iyavei ambuae oitɨ yu pãhuve. Ipare oyoya tuprɨ sorɨ yuvɨreco; yu rumo opaño oyopɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ambuae rumo oitɨ ɨvɨ avɨye vahesave. Ipare sorɨse, iha vai eté yuvɨreco; ahe iha retacuer amove cien tuprɨ ité ñepei-pei mbahe mitɨ sui osẽ” ehi. Aipo ohe pare, Jesús oñehe pĩratá iteanga aipo ehi: “¡Acoi ava osenducua pota vahe che ñehe, toyapɨsacaño sese!” ehi ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ipare semimbohe eta oporandu yuvɨreco chupe: “¿Mara oyapave vo aipo co yembohesa?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Evocoiyase omboyevɨ chupe: “Pẽu Tũpa oicua uca ité mbahe ndicuasai vahe omborerecuasa resendar; ambuae ava rumo ambohe tẽi ambuae mbahe mboyoyasa pɨpe; yepe osepia mbahe viña ‘tomahecua eme iyavei yepe osenduño mbahe tosenducua eme yuvɨreco’ viya” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Co yembohesa resendar aipo oyapave aipo ehi: Mbahe rãhɨi ahe inungar Tũpa Ñehengagüer; ");
INSERT INTO gyrNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","iyavei mbahe rãhɨi perɨ rupi seitɨprɨ, ahe inungar acoi ava osendu tẽi vahe Tũpa Ñehengagüer yuvɨreco oyapave. Ipare rumo ou vɨ̃rai chupe, ahe inungar caruguar ou vahe chupe opaño oyaracua mocañɨ Tũpa Ñehengagüer sui ‘tovɨroya eme iyavei toñepɨsɨro eme yuvɨreco’ oyapave tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Acoi mbahe rãhɨi seitɨprɨ ita mahugüer rupi, ahe inungar acoi ava osendu tẽi vahe Tũpa Ñehengagüer yuvɨreco iyavei oipɨsɨ tuprɨ ovɨharetesa pɨpe yuvɨreco viña no. Ahe rumo inungar co mbahe mitɨ ndovɨrecoi vahe guapo ovɨ̃racua ãgua; vɨroya raimi tẽi yuvɨreco. Oyepotase rumo mbahe tẽi chupe, oyepepɨ voiño yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Acoi mbahe rãhɨi seitɨprɨ yu pãhu rupi, ahe inungar acoi osendu tẽi vahe. Ipare rumo oyemboyepepɨ uca mbegüeño ambuae mbahe rese opɨhañemoñetá iteangasa pɨpe tẽi, ombahe eta rese iyavei güemimbotarai mbahe tẽi potasa pɨpe avei. Ẽgüe ehi ahe ava inungar mbahe mitɨ ndihai vahe ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Acoi mbahe rãhɨi seitɨprɨ rumo ɨvɨ avɨye vahesave, ahe inungar ava vɨreco vahe opɨhañemoñetasa avɨye vahe iyavei oyemoingatu voi Tũpa Ñehengagüer rese oyapɨsaca ãgua yepi; vɨroya tuprɨ ité no; yuvɨrecoiño ité sese. Ẽgüe ehise, oyapo mbahe avɨye vahe yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ndiyai eté ava upe guataendɨ omoendɨse omoha vahe que mbahe pɨpe, ‘Tamondo che rupavrɨve’ ndehi eté chupe; osupiño ɨvate imoi opacatu oɨ pɨpe yuvɨroique vahe resape ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Esepia, ndipoi eté mbahe ñomiprɨ, ndayasepiai vaherã curi. Iyavei yaposa vahe imombehupɨrẽhɨ, icuasaño itera curi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Sese peyapɨsaca tuprɨ co ñehesa rese. Esepia, acoi oyapɨsaca tuprɨ vahe, chupe imondosa catura; acoi nomombɨtai vahe rumo mbahe güembieroya oyese, ichui serocuasaño itera” ehi oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ichui Jesús sɨ iyavei tɨvɨreta oyepota secosave yuvɨraso. Ndiyai eté rumo chupe yuvɨraso vaherã yuvɨreco ava rehɨi sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Oime rumo ambuae ava imombehusar chupe, —Nde sɨ, nde rɨvɨreta reseve nde repia pota tẽi ocarve yuvɨreco —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ahe rumo aipo ehi chupe: —Acoi ava osendu vahe che Ru Ñehengagüer yuvɨreco, vɨroya tuprɨ vahe avei, ahe che sɨ, che rɨvrɨ yuvɨrecoi —ehiño Jesús chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ñepei arɨ Jesús oha carite pɨpe güemimbohe eta reseve. Ipare aipo ehi: —Yaso peve ɨpa rovai —ehi. Evocoiyase ahe yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yuvɨroguata vɨteseve, oqueño Jesús ou. Ahese ɨpa pɨpe avɨyeteramo tẽi ɨvɨtu ai omboha guasu-guasu carite pɨpe ɨ, omondo pota ité ɨpɨve viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Evocoiyase semimbohe yuvɨraso imomba aipo ehi chupe: —¡Porombohesar! ¡Porombohesar! ¡Yande rerasora moco carite ɨpɨve! —ehi yuvɨreco. Ahese omahe. Ipare oñehe pĩrata ɨvɨtu ai upe iyavei ɨ ohɨtu vahe upe: “¡Pepɨtuhu!” ehi. Aheseve voi opɨtuhu tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Evocoiyase aipo ehi güemimbohe eta upe: —¿Mahera vo ndapeyeroyai che rese? —ehi. Ahe rumo osɨquɨyeño, ndoyembovɨhaiño iyavei oporandu-randu tẽi oyeupe yuvɨreco: —¡Mara ehi vahe pĩha co mbɨa! Esepia niha, ɨvɨtu ai, para guasu avei omboyeroya —ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Coiye oyepota yuvɨraso Gerasa ɨvɨ rese cute, ahe ambuae ɨpa cotɨ ɨvɨ Galilea rovai. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Aheve mbɨa tecua ɨguar caruguar vɨreco vahe secoi. Aracahe suive nani tuprɨ ité secoi iyavei ndopɨtai vahe ité oɨ pɨpe yepi; ẽgüe ehi rumo ahe tehõgüer ruvɨpa rupindar tẽi secoi. Setá rupi caruguar ombohe ité sereco yepi. Yepe ava oipocuhacua-acua carena pɨpe sereco, ipɨ rupi avei no ‘tovɨraso iri eme caruguar’ oyapave yuvɨreco chupe viña, ahe rumo ombosando-sandoño ité iyavei caruguar omoñemi ucaño ava porẽhɨsa rupi sereco. Evocoiyase Jesús osẽse carite pɨpe sui, osovaĩchi ahe mbɨa. Sepiase rumo, ahe mbɨa oñenopɨha voi oso sovai oñehe pĩrata chupe: —¡Eyepepɨ che sui, Jesús, Tũpa seco ɨvate catu vahe Rahɨr! ¡Che mombaraɨsui rene eve! —ehi. Esepia, Jesús opa oyocuai caruguar sereco ‘tosẽ ichui’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—¿Mara vo nde rer? —ehi chupe. —Che rer Legión —ehi. Aipo ehi, esepia niha, setá eteprɨ caruguar yuvɨroique yavɨterve. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Oimese rumo cuchi setá ocaru vahe ɨvɨtrɨ ruambesave, caruguar evocoiyase oporandu chupe aipo ehi: “Toroiqueñomi tẽi co cuchi avɨterve” ehi yuvɨreco chupe ‘tayande mondo eme cañɨ tẽisa apɨrẽhɨ vahe pɨpe’ oyapave viña. “Peiqueño sese” ehi caruguar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ahese opa yuvɨnose mbɨa sui yuvɨroique cuchi avɨterve cute. Aheseve voi cuchi opa yuvɨnoña yuvɨraso ɨvɨvate sui ɨpa pɨpe. Aheve ɨpɨve opa tẽi eté ocañɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuchi rãrosar osepiase ahe mbahe yuvɨreco, opa yuvɨnoña yuvɨraso co mbahe mombehu tecua pɨpe ava upe, cove rupi avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ipare setá ava yugüeru aipo mbahe oime vahecuer repia. Oyepotase rumo secosave yuvɨraso, aheve osepia ahe mbɨa caruguar rerecosarer oguapɨ oĩ ñɨpɨimi, oyemonde tuprɨ, yaracua tuprɨ avei oico. Ahese oyembosɨquɨye tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Acoi ava osepia vahecuer, ahe opa mbahe omombehu yuvɨreco co mbɨa caruguar rerecosar cuera agüer. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ahese opacatu ava Gerasa pendar, yɨvɨrindar avei Jesús upe, “Esɨrɨ cohave sui” ehi yuvɨreco. Esepia niha, osɨquɨyé iteanga yuvɨreco ichui. Evocoiyase oha carite pɨpe. Ipare osoño. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Yɨpɨndar rumo evocoi mbɨa caruguar vɨreco vahecuer, “Tasomi tẽi nde rupi” ehi viña. Ahe rumo, “Epɨtaño” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Eyevɨ nde rẽtave, emombehupa opacatu mbahe Tũpa oyapo vahecuer nde rese —ehi. Ahe mbɨa evocoiyase oso opacatu tecua rupi, Jesús oyeupe mbahe apo agüer mombehu. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Oyevɨse Jesús ɨpa rovai oso, aheve ava rehɨi ovɨharetesa pɨpe oipɨsɨ tuprɨ yuvɨreco. Esepia niha, ava opacatu ité osãro yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ahese Jairo serer vahe oyepota oso Jesús upe, evocoi judío tũparo rese yangarecuar secoi vahe. Ahe mbɨa oñenopɨha sovai oso, oporandu chupe ‘tosomi tẽi che rẽtave che rayrɨ mbogüera’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Esepia niha, vɨreco guayrɨ ñepeimi vahe ité, doce aravɨter vɨreco vahe. Ahe omano potami eté ou. Osose Jairo rẽtave, aheve perɨ rupi ava rehɨi yuvɨrasoño supi; oyembotɨ tuprɨ ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ahe ipãhu rupi oime cuña doce aravɨter rupi suvɨ yepɨyere-yere vahe. Opa-opa tẽi omondo ombahe ocuera ãgua repɨrã yepi; ndocuerai eté rumo. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ahe cuña evocoiyase oyemboya oso saquɨcuei cotɨ opoco iturucuar popɨ rese. Ipare ahe pɨpeve voi opɨtuhu suvɨ ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Evocoiyase Jesús oporandu: —¿Ava vo opoco che turucuar rese? —ehi. Opacatu ava aipo ehi yuvɨreco: “Aní eté” ehi. Pedro evocoiyase aipo ehi chupe: —Porombohesar, ava rehɨi mo oyemboya nde rese iyavei nde moañɨ-añɨi yuvɨreco opacatu rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—Che rumo aicua oime ava opoco vahe che turucuar rese. Esepia, ayandu che pĩratasa osẽse che sui —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ahe cuña ndoicatui oñemi. Sese orɨrɨi oñenopɨha sovai. Oyemombehu chupe opacatu ava rovaque: “Che apoco nde turucuar rese. Esepia, ‘Acuera tuprɨra apocose iturucuar rese’ ahe ndeu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ahese aipo ehi cuña upe: —Che rayrɨ, erecuera tuprɨ ité. Esepia niha, che rese ereyeroya ité. Sese eso tuprɨño —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús ñehe vɨteseve, ahese oyepota aheve mbɨa Jairo rẽta sui aipo ehi Jairo upe oso: —Omano nde rayrɨ cute. Eremañeco tẽi iri rene Porombohesar —ehiño Jairo upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Evocoiyase iñehe renduse aipo ehi Jairo upe: —Aní eresɨquɨye; nde che rese yeroyasa pɨpe ité nde rayrɨ ocuerayevɨra —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Oyepotase Jairo rẽtave oso, aheve ndomoingue uca potai eté ava oyeupi. Pedro, Santiago, Juan iyavei cuñatai yesupa upeño oipota seique ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Aheseve opacatu ava oyaseho atɨ, ndoyembovɨhai tẽi sese yuvɨreco. Jesús rumo aipo ehi chupe: —Peyaseho eme. Co cuñatai nomanoi, oque tẽi ou —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ava rumo opuca ete-eteño seroyaẽhɨsave yuvɨreco. Esepia niha, ahe oicua ité imanose yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Evocoiyase oipopɨsɨ cuñatai. Ipare aipo ehi chupe: —¡Cuñatai, eñarapuha! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ahe evocoiyase oñarapuha voi eté ocuerayevɨ. Ipare Jesús, “Pembocaru” ehi iyesupa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyesupa evocoiyase, “¿Mara ehi rutei pĩha co?” ehi tẽi yuvɨreco chupe. Jesús rumo omombehu chupe: “Ndapemombehui chietera que ñepei ava upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús opa omonuha güemimbohe doce vahe oyeupe. Ipare omondo opĩratasa opacatu upe caruguar ambuae-ae tẽi vahe imboyepepɨ ãgua ava sui iyavei ava mbogüera ãgua imbaherasɨsa sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Opa omondo Vu Tũpa mborerecuasa resendar mombehu ãgua, ava imbaheasɨ vahe mbogüera ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yɨpɨndar rumo aipo ehi chupe: —Ndaperasoi chira mbahe pe guatasa rupi: que mbococa, mbahe rɨru, tembihu, que guarepochi avei no. Perasora rumo ñepei güeraño pe turucuar; ndahei chira ñuvɨrío peraso. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pepɨtami ranera ñepei oɨ pɨpe güeraño tecua yacatu peico. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Acoi ava ndape moingue uca potaise güẽta pɨpe yuvɨreco, peyepepɨñora ichui iyavei peipɨpetera pe pɨ sui ɨvɨ cuhi ‘toicua Tũpa ñemoɨrosa oyeupendar yuvɨreco’ pe hesave —ehi güemimbohe eta mondo. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Evocoiyase opa yuvɨnose yuvɨraso, iyavei oñemosai opacatu tecua rupi omombehu Tũpa Ñehengagüer pɨ̃sɨrosa resendar yuvɨreco iyavei ombogüera-güera ité ava imbaherasɨsa sui opacatu oguatasa rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Co mborerecuar guasu Herodes oyandu opacatu mbahe Jesús rembiapo. Evocoiyase, “¿Mara ahera pĩha?” ehi tẽi. Esepia niha, aipo, “Juan ocuerayevɨ” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ambuae aipo ehi: “Tũpa ñehe mombehusar Elías, ahe tẽi oñemoporẽhɨ iri” ehi yuvɨreco. Ambuae aipo ehi: “Que ñepei Tũpa ñehe mombehusar aracahendar revo, ahe tẽi ocuerayevɨ” ehi yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes rumo aipo ehi: —Che niha ayasɨa uca Juan ãca —ehi—. ¿Uma rerãcua pĩha evocoiyase ayandu? —ehi tẽi. Sese Herodes osepia pota ité Jesús. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Apóstol oyevɨpase Jesús upe, ahese opa tuprɨ mbahe güembiapogüer omombehu yuvɨreco. Ahese opa vɨroyepepɨ ava rehɨi sui, vɨraso ɨvɨ iporupɨrẽhɨsave tecua Betsaida cotɨve. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ahe ava rehɨi rumo oyanduse yuvɨreco, yuvɨrasoño saquɨcuei. Evocoiyase, “Perioño” ehi chupe. Ipare oñehe Vu Tũpa mborerecuasa rese ava upe iyavei ombogüerapa ava imbaherasɨsa sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Caharuse co doce semimbohe oyemboya yuvɨreco sese aipo ehi chupe: —¿Ndiyai vo eremondopa ava, topɨtuhu yuvɨreco iyavei toseca mbahe güemihura tecua-tecuami cõi vahesa rupi? Esepia niha, cohave ndipoi eté mbahe —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ahe rumo aipo ehi güemimbohe eta upe: —Pe pemondora mbahe semihura yuvɨreco —ehi. Semimbohe aipo ehi yuvɨreco chupe: —Poyandepomi tẽi rumo pan orovɨreco, ñuvɨriomi tẽi avei pira, toroso ayase co ava opacatu remihura rerocua —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Esepia niha, cuimbahe retacuer cinco mil tuprɨ. Jesús rumo aipo ehi güemimbohe eta upe: —Pemboyaho cincuenta rupi-rupi imboguapɨ —ehiño. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ẽgüe ehi semimbohe yuvɨreco chupe. Ipare oguapɨ opacatu ava yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Evocoiyase oipɨsɨ poyandepo pan iyavei ñuvɨrío pira. Ipare omahe ɨva rese, “Avɨye ndeu, che Ru” ehi. Imbohi-mbohi pare, opa omondo güemimbohe upe ava rehɨi upe imondo ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Evocoiyase opacatu ava ocaru vahe ihɨ̃taropa tẽi yuvɨreco. Ipare semimbohe omboapɨpopa doce tuprɨ ɨruova sembihu rumbɨrer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ñepei arɨ pɨpe Jesús oyeroquɨ ahe ae güemimbohe pãhuve. Ahese oporandu güemimbohe upe: —¿Mara ehi vo ava oñehe yuvɨreco che rese? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—Amove ava, “Juan Oporoãpiramo vahe” ehi yuvɨreco ndeu; ambuae, “Elías” ehi yuvɨreco ndeu, iyavei ambuae, “Avɨyeteramo que ambuae Tũpa ñehe mombehusar aracahendar ocuerayevɨ” ehi yuvɨreco ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Evocoiyase oporandu güemimbohe upe: —Pe no, ¿“Ava co secoi” peye ru pe cheu no? —ehi. —Nde niha Tũpa Rembiporavo Poropɨ̃sɨrosar ereico —ehi Pedro imboyevɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ahe rumo aipo ehi güemimbohe eta upe: “Pemombehui rene Tũpa Rembiporavo che recosa ava upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iyavei aipo ehi chupe: —Che, Ava Rɨquehɨr, che paraɨsu itera, iyavei opacatu judío rerecuareta, pahi rerecuar ɨvate catu vahe iyavei Moisés porocuaita rese oporombohe vahe remiamotarẽhɨ aicora. Ahe avei che yuca ucara yuvɨreco; mbosapɨ arɨ rupi rumo acuerayevɨra —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ipare aipo ehi opacatu upe: —Acoi oguata pota vahe che rupi, topoi mbahe güemimbotar tẽi aposa sui iyavei inungar-ra curusu rese ovosɨira viña, toyemoingatu voi che recocuer rese oparaɨsu ãgua arɨ yacatu rupi iyavei toguata tuprɨ che rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Esepia, acoi ava güetecuer tẽi raɨsupar ocañɨ tẽi itera; acoi ava omocañɨ tẽi vahe rumo güetecuer che recocuer rese, ahe oñepɨsɨrora. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Esepia, ¿avɨye ai angahu pĩha ava upe opacatu mbahe co ɨvɨ pɨpendar pɨsɨ ãgua tẽi, ahe ae tẽi omocañɨse güecocuer yuvɨreco viña? ");
INSERT INTO gyrNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Esepia, acoi ava yuvɨnochi ai vahe che sui iyavei che ñehengagüer sui avei no, che avei, Ava Rɨquehɨr, ẽgüe ahera ichui acoi ayevɨse che reco pĩratasa pɨpe, che Ru reco pĩrata porañetesa pɨpe avei sembiguai rehɨi ɨva pendar maranehɨ reseve curi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Supi eté, oimera amove cohave ava nomano vɨtei chivaherã, osepia rane itera ouse Tũpa mborerecuasa yuvɨreco curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ocho arɨ pare Jesús oyeupi ɨvɨtrɨ rese oso oyerure ãgua. Pedro, Santiago iyavei Juan ahe vɨraso oyeupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Oyerure vɨteseve, oñecuñaro sepiaca. Iturucuar evocoiyase sendɨ, morochí eteanga. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ahese ñuvɨrío ava oyemboyecua yɨvɨi imoñeta yuvɨnoha. Evocoi ava yuvɨrecoi vahe ahe Moisés, Elías avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Oyere tuprɨ sendɨgüer iporañetesa yuvɨreco sese, iyavei co ñuvɨrío mbɨa oñehe imano ãgua rese yuvɨreco chupe: “Nde niha ereyemomborarara nde mano ãgua Jerusalén pɨpe eico” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Yepe Pedro, ondugüer reseve sopesɨí eteanga yuvɨreco viña. Avɨyeteramo tẽi opa sopesɨi yuvɨreco ichui. Ahese osepia Jesús porañetesa yuvɨreco iyavei co ñuvɨrío mbɨa yuvɨnoha vahe yɨvɨi no. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Evocoi mbɨa oyepepɨse ichui yuvɨreco, ahese Pedro aipo ehi chupe: —Ore mbohesar, ¡avɨye ai eté cohave yaico! Toroyapo mbosapɨ teyupami: ñepei ndeu nara, ambuae Moisés upe, ambuae evocoiyase Elías upe nara —ehi. Pedro rumo ndoicuai eté aipo ohesa. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iyavei iñehe vɨteseve, avɨyeteramo tẽi iporẽhɨ ɨva quɨha, oyopɨpa tuprɨ ité. Evocoiyase osɨquɨye tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ipãhuve oyeendu ñehesa aipo ehi vahe: “Co che Rahɨr, che Rembiporavo ité; peyapɨsaca catu iñehe rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Opase osendu co ñehesa yuvɨreco, ahese osepia Jesús, ahe ae ihãise yuvɨreco. Semimbohe rumo oyeupe tẽi ovɨreco yuvɨreco; ndomombehu vɨtei eté ava upe mbahe osepia vahecuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ahere ayihive, ogüeyɨse ɨvɨtrɨ sui yuvɨreco, setá ava oyugüeru Jesús rovaĩchi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ahese mbɨa ava pãhuve aipo ehi pĩrata voi eté: —Porombohesar, ereyapomira mbahe icatuprɨ vahe cheu viña. Esepia, che rahɨr ñepeimí vahe ité; ");
INSERT INTO gyrNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","caruguar rumo opoco sese, omoase pucu-pucu uca yepi iyavei omoeõha-õha sereco iyavei iyuru rupi tɨyui yusu-yusu. Mara-mara tẽi vɨreco iyavei ndopoi potai eté ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Amombehu tẽi niha nde remimbohe upe ‘tomboyepepɨmi tẽi caruguar ichui’ che yapave viña; nomboyepepɨi eté rumo ichui yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ahe omboyevɨ: —¡Too, ndapeyeroya tuprɨ vɨtei eté che rese, co cotɨ tẽi vɨte pe pɨhañemoñetasa! ¿Mbovɨ rupi rutei vo aico vɨtera pe pãhuve che ñemosasa pɨpe? Eru nde rahɨr cohave cheu —ehi ahe mbɨa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Chĩhivahe oyemboyase rumo sese, caruguar ombovɨapi voi imondo ɨvɨve, imoeõha iri. Jesús rumo oñehe pĩrata caruguar upe imose ãgua chĩhivahe sui. Ahese chĩhivahe ocuera tuprɨ ité. Ipare omboyevɨ tu upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ahese opacatu ava, “¡Mara ehi rutei!” ehi tẽi yuvɨreco Tũpa pĩratasa rembiapo avɨye vahe repiase. Opacatu ava ndoyembovɨhai vɨteseve yuvɨreco, ahese aipo ehi güemimbohe upe: ");
INSERT INTO gyrNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Pesendu tuprɨ che ñehe; peresarai eme ichui: che, Ava Rɨquehɨr, imondoprɨ aicora che amotarẽhɨmbar povrɨve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Semimbohe rumo ndosenducuai eté oyeupe ñehesa yuvɨreco. Esepia niha, Tũpa ndoipotai eté senducua ãgua chupe; osɨquɨye chupe oporandu ãgua yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Coiye semimbohe eta omboɨpɨ oyeecopɨ-copɨ yuvɨreco ‘¿ava ité pĩha ɨvate catu vaherã curi?’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús rumo oicuaño ipɨhañemoñetasa yuvɨreco. Evocoiyase oipɨsɨ chĩhivahemi seru oɨpɨve imoha. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ipare aipo ehi güemimbohe eta upe: —Acoi ava oipɨsɨ vahe co chĩhivahemi nungar che rer pɨpe sereco, che ité che pɨsɨ yuvɨreco; iyavei acoi ava che pɨsɨ vahe, oipɨsɨ aveira che mbousar. Esepia, acoi ava seco mbegüemi catu vahe pe pãhu pendar, ahe avɨye catu vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Evocoiyase Juan aipo ehi chupe: —Ore mbohesar, orosepia niha mbɨa ombogüera vahe caruguar pĩratasa sui ava nde rer pɨpe oico; ore rumo ndoroipotai chupe evocoiya seco ãgua. Esepia niha, ndahei yande rupindar secoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús rumo, —¡Aní ndapeipotai chupe! —ehi—. Esepia niha, evocoi nungar ava ndahei yande amotarẽhɨsar; ahe rumo yande mboyoyasar —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Vɨrovɨse rumo arɨ ɨvave Jesús so ãgua, ahese ahe aipo ehi: “Yaso ru Jerusalén ve cũritei” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Evocoiyase omondo ava güenonera. Ahe yuvɨraso tecua Samaria ɨvɨ rupi ipɨtuhu ãgua moingatu viña; ");
INSERT INTO gyrNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria ɨguar rumo nomoingue potai eté güẽtave yuvɨreco. Esepia, oicua Jerusalén ve ichose yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Co mbahe naporai vahe repiase rumo, semimbohe Santiago iyavei Juan oporandu yuvɨreco chupe: —Ore Yar, toromboumi tata ɨva sui co ava mocañɨ ãgua —ehi yuvɨreco chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","“¡Aní!” ehi oyemboyere chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ipare yuvɨraso ambuae tecuave. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yuvɨrasose perɨ rupi aipo ehi mbɨa Jesús upe: —Che Yar, che nde rupi aso pota opacatu nde guatasa rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ahe rumo aipo ehi: —Aguara vɨreco güẽtara, vɨ̃rai avei vɨreco guaitɨ; che rumo, Ava Rɨquehɨr, ndarecoi que che rẽta che pɨtuhu ãgua —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ipare ambuae upe aipo ehi: —Erio che rupi —ehi. —Che Yar, che ru manose voi, ñotɨ pare aguatara nde rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—Aní —ehi—. Acoi omano vahe nungar ahe ae toñeñetɨño yuvɨreco; nde rumo eso, emombehuño ñehesa Tũpa mborerecuasa resendar ava upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Evocoiyase ambuae aipo ehi chupe no: —Che Yar, che aguata pota nde rupi; yɨpɨndar rumo aso ranera che rẽtave mbahe moingatu che so ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—¡Aní! —ehi ahe mbɨa upe—. Esepia, inungar acoi oipɨsɨ vahe ɨvɨ mboyeresa imohɨvi tuprɨ ãgua, omahese rumo guaquɨcuei cotɨ, evocoi nungar naporai Tũpa mborerecuasave yuvɨroique vaherã —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ipare yande Yar oiporavo setenta y dos ava ñepei-pei tecua rupi ñuvɨrío-río güenonera. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yɨpɨndar rumo aipo ehi: “Supi eté mbahe imonuhapɨrã setá iteanga; sese oporavɨquɨ vahe rumo movɨromi tẽi. Sese peporandu mbahe mitɨ Yar upe, tombou ava imonuha ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Peso, opomondo ovesami nungar ava mbahe mɨmba oñaro vahe nungar pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Perasoi rene mbahe rɨru iyavei guarepochi sɨru reseve. Ndapemondugüei chiaveira pe pɨtaqui; iyavei aní pepɨta ‘avɨrave’ apo ava upe perɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Acoi peiquese que oɨ pɨpe, yɨpɨndar rumo peyapo ranera: ‘Avɨrave. Tũpa tape rovasa’ peyera. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Acoi aheve oimese ava avɨye vahe, ahe oipɨsɨra Tũpa porovasasa; anise evocoiyase ndipoi chira porovasasa chupe nara. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Acoi pe pɨsɨse, aheve ité pepɨtañora; pecarura iyavei peɨhura ahe sembiereco. Esepia, ava poravɨquɨse imboepɨsa chupe. Sese ndapeguatai chira ambuae ava rẽta rupi-rupi tẽi. Ñepei oɨ pɨpe güeraño pepɨtañora. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Acoi que tecuave peyepotase, ahe pendar pe repia potañose yuvɨreco, acoi ahe ombouse mbahe yuvɨreco tapehu, pehuñora ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ahe pendar imbaheasɨ vahe evocoiyase pembogüerara, iyavei aipo peyera chupe: ‘Tũpa mborerecuasa namombrɨimi pe sui’ peyera. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Acoi peyepotase rumo que tecuave, ahe tecua pendar ndape repia potaise yuvɨreco, peseñora ocar rupi aipo peyera: ");
INSERT INTO gyrNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Co pe recua pɨpendar ɨvɨ chimborer oya vahe ore pɨ rese oroipɨpete oreyesui, peicua catu, ore hesa pɨpe. Peicua tuprɨ rumo Tũpa mborerecuasa namombrɨimi pe sui’ peyera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Supi eté acoi arɨ cañɨ oyepotase, oimera Tũpa ñemoɨrosa ahe tecua pendar upe ɨvate catu vahe ava tecua Sodoma pendar sui” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Peparaɨsu ava tecua Corazín pendar, pe avei peparaɨsu tecua Betsaida pendar! Esepia, acoi poromondɨisa pe pãhuve yapoprɨ yaposara yɨpɨve tecua Tiro, Sidón ve viña, ahe tecua pendar aracaheve anga omondera turucuar vɨharẽhɨsa resendar, tanimbu avei omondora oãca rese oangaipa mboasɨsa pɨpe yuvɨreco viña no. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pe rumo peipɨsɨra ɨvate catu vahe Tũpa ñemoɨrosa ava Tiro, Sidón pendar sui arɨ cañɨ pɨpe coiye. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pe avei no tecua Capernaum pendar, ¡pemoha co ɨvave pe reco ãgua viña! ¡Pe mombosapara rumo ɨvɨcuar ipɨcucu catu vahesave! ");
INSERT INTO gyrNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Acoi ava oyapɨsaca vahe pe ñehe rese yuvɨreco, ahe evocoiyase oyapɨsaca avei che ñehe rese. Iyavei acoi ava pe mboyepepɨño vahe oyesui, ahe evocoiyase che avei che mboyepepɨ oyesui yuvɨreco. Acoi ava rumo che mboyepepɨño vahe oyesui, ahe evocoiyase che mbousar avei omboyepepɨño oyesui” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Oyevɨpase ava setenta y dos vahe, ovɨharetesave aipo ehi yuvɨreco chupe: —¡Ore Yar, caruguar avei eté niha ore mboyeroya eteprɨ yuvɨreco nde rer pɨpe! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Evocoiyase aipo ehi güemimbohe eta upe: —Taa, asepia ité niha caruguar rerecuar ovɨapise ɨva sui overa vahe nungar. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Che niha amondo pĩratasa pẽu peguata vaherã mboi iyavei mbahe rumbɨquɨ̃ape harɨ rupi opacatu pe amotarẽhɨsar pĩratasa reroyɨ ãgua, que mbahe pe momaraẽhɨ ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Peyembovɨharetei rene caruguareta pe mboyeroyase. Iya rumo peyembovɨha pe rer ɨva pendar icuachiaprɨ rese —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ahe pɨpeve voi Jesús, Espíritu Santo rese, vorɨvetesa pɨpe aipo ehi: “Che Ru, che oromboetei. Nde niha ɨva Yar, ɨvɨ Yar avei no. Esepia niha, ereñomi co mbahe ava oyesui tẽi mbahe oicua vahe sui iyavei co ɨvɨ pɨpendar ava imbahecua vai vahe sui avei no. Eremboyecua rumo co mbahe ava ndoyembohe tuprɨi vahe upe nde rese oyeroyase. Ahe niha ereipota ité, che Ru” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Opacatu mbahe che Ru ombou cheu. Iyavei ndipoi ava che cua vahe tahɨr che recose; che Ru güeraño ité rumo che cua. Ndipoi avei che Ru oicua tuprɨ vahe yuvɨreco no; che güeraño ité aicua. Iyavei acoi que ava upe aicua uca potase, aicua uca tuprɨ aveira” ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Evocoiyase omahe güemimbohe eta rese, chupe güeraño aipo ehi: “Perorɨvete catu co mbahe pesepia vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Esepia niha, setá eteprɨ ava Tũpa ñehe mombehusar yuvɨrecoi vahe iyavei mborerecuar guasu eta aracahendar osepia pota tẽi mbahe pe rembiepia; ndosepiai eté rumo yuvɨreco. Osendu pota tẽi co pe remiendu yuvɨreco; ahe rumo ndosendui avei yuvɨreco” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iyavei no Tũpa porocuaita rese oporombohe vahe oso Jesús upe secoãha ãgua, mbahe rese oporandu: —Porombohesar, ¿mara ahera vo vichico teco apɨrẽhɨ vahe rereco ãgua? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ahe omboyevɨ: —¿Mara ehi vo Moisés porocuaita icuachiaprɨ pɨpe? ¿Mara ehi vo ereyeroquɨse ipɨpe? —ehi oporombohe vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Evocoiyase oporombohe vahe omboyevɨ: —“Eresaɨsura nde Yar Tũpa opacatu nde pɨhá pɨpe, opacatu nde recocuer pɨpe, opacatu nde pĩratasa pɨpe, opacatu nde yapɨsacasa pɨpe avei; iyavei eresaɨsura ava nde cotɨndar nde yeaɨsu nungar” ehi Moisés porocuaita —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Supi eté —ehi—. Eremboyevɨ tuprɨ ndeyeupe porandusa cheu. Eremboavɨyese evocoi, ahese ererecora tecovesa apɨrẽhɨ vahe —ehi co mbɨa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Co mbɨa rumo oyeepɨ pota. Sese aipo ehi chupe: —¿Ava vo aipo che cotɨndar secoi? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Evocoiyase omboyevɨ chupe: —Oime mbɨa Jerusalén sui oso vahe Jericó ve. Ahe perɨ rupi yuvɨnose ava ndipɨhai vahe yuvɨreco chupe. Ahe vɨrocuapa imbahe yuvɨreco ichui, iturucuar opacatu reseve; iyavei yuvɨrocua-rocua yuvɨreco sese. Ipare oyuca seni seya perɨ rupi yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ahese judío pahi ou ahe perɨ rupi. Evocoi mbɨa repiase rumo, co cotɨ rupi oñacuasaño oso. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ẽgüe ehi tuprɨ avei ambuae mbɨa pahi pɨ̃tɨvɨisar levita, osepiase, oñacuasa tuprɨño avei oso no. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ipare rumo mbɨa sepia potapɨrẽhɨ Samaria ɨguar oso ahe perɨ rupi avei. Ahe osepiase, oiparaɨsuereco. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Evocoiyase ahe mbɨa oyemboya oso sese oiposano yapichasa mbahe quɨra pɨpe, uva rɨcuer sai vahe pɨpe, oicuhacua avei turucuar pɨpe chupe. Ipare osupi güeimba harɨve oaprɨve, vɨraso ava quesave. Aheve ihañeco sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ahere ayihive Samaria ɨguar osose, omondo guarepochi ahe pendar oɨ yar upe. Ipare aipo ehi chupe: “Esãro tuprɨmi tẽi co ava cheu. Acoi ndehañeco catuse sese, amboepɨ catu irira che yevɨse ndeu” ehi sẽta vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Indó, ¿uma vo co evocoiyase mbosapɨ yuvɨrecoi vahe oyemboava acoi ava ndipɨhai vahe remimombaraɨsu upe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Evocoiyase ahe mbɨa aipo ehi: —Acoi mbɨa oiparaɨsuereco vahe iparaɨsu vahecuer —ehi. —Supi eté —ehi chupe—. Eyapo tuprɨ avei nde co nungar eico —ehi Jesús co Moisés porocuaita rese oporombohe vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ipare Jesús güemimbohe eta reseve oguata vɨte oyepota cuña recosave yuvɨraso, ahe cuña rer Marta. Ahe omoingue tuprɨ güẽta pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Icupɨhɨr evocoiyase María serer. Ahe oguapɨ Jesús pɨve iñehe rendu oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta rumo oyembopɨhavɨ̃racua opacatu mbahe rese oico. Ipare oyemboya oso Jesús rese opɨhavɨ̃racuasa pɨpe aipo ehi chupe: —Che Yar, ¿avɨye ai vo evocoi che cupɨhɨr chini tẽi nde pɨri che poravɨquɨ vɨteseve? Emombehu chupe, tou, tache pɨ̃tɨvɨi rane —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Omboyevɨ rumo Marta upe aipo ehi: —Marta, Marta, ¿mahera vo ereyemañeco eteprɨ tẽi setá mbahe apo ãgua eico? ");
INSERT INTO gyrNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Iya rumo ñepei mbahe yaposa. Co nde cupɨhɨr oiporavo ahe mbahe avɨye catu vahe oyeupe che ñehe renduse; ndipoi chietera que ava vɨrocua vaherã ichui —ehi Jesús Marta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ñepei arɨ Jesús oyerure. Iyerure pare semimbohe aipo ehi chupe: —Ore Yar, ore mbohemi tẽi ore yerure ãgua rese eve inungar Juan ombohe güemimbohe eta sereco yepi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","—Avɨye —ehi—. Peyeroquɨse, aipo peyera: ‘Ore Ru Tũpa, ɨvave ereico vahe, imboeteiprɨ nde rer tasecoi. Tou nde mborerecuasa oreu. Tayaposa nde remimbotar co ɨvɨ pɨpe, ɨva pendar nungar. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Embou ore rembihu arɨ yacatundar oreu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Iyavei ndeñero ore angaipa rese oreu. Esepia niha, ore oreñero opacatu ore amotarẽhɨmbar upe. Ore mboangaipa ucai rene eve, ore renose catu mbahe tẽi sui eve’ peyera —ehi ");
INSERT INTO gyrNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iyavei aipo ehi no: —Inungar co perecora pe mborɨpar viña. Ipare pesora ahe sẽtave pɨ̃tu mbɨter rupi aipo peyera chupe: ‘Che mborɨpar, emboumi tẽi mbosapɨ pan cheu tamboyevɨre ndeu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Esepia, ambuae che mborɨpar oyepota ou che rẽtave; ndarecoi eté rumo mbahe amondomi vaherã chupe’ peyera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ipare ahe, ‘Che mañeco tẽi rene eve. Esepia, opa ayoquenda, iyavei co che rahɨr opa aropɨtuhu seru. Sese ndiyai apũha mbahe mondo ndeu’ ehiñora pẽu viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Supi eté, yepe nopuhai chietera mbahe mondo pẽu pe mborɨpar secose viña, opũhaño itera rumo ‘tache mañeco iri eme’ oyapave. Ipare omondoño itera opacatu mbahe pe porandusa pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sese aipo ahe pẽu: Peporandura mbahe rese Tũpa upe, ahese omboura pẽu; peseca ahe mbahe, ahese peyosura; inungar pemota oquenda, ẽgüe peyera peyeroquɨsa pɨpe Tũpa upe, ahese imboisara mbahe mbou ãgua pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Esepia, acoi oporandu vahe mbahe rese, ahe mbahe oipɨsɨra; acoi mbahe oseca vahe, oyosura, iyavei acoi oyeroquɨsa pɨpe omota vahe oquenda Tũpa upe, chupe imboisara. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Oimese tahɨ vahe pe pãhuve, tahɨr oporanduse pira rese vu upe, ¿omondora pĩha mboi tẽi guahɨr upe viña? ");
INSERT INTO gyrNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","anise, ¿omondora pĩha oporanduse mbahe rupiha rese, mbahe rumbɨquɨãpe tẽi chupe viña? ");
INSERT INTO gyrNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","¡Aní! Esepia, pe yepe ava ndaseco põrai vahe peico viña, pe rahɨr upe rumo pemondoño ité mbahe avɨye vahe. ¡Tahetru pe Ru ɨva pendar omondo catura Espíritu Santo acoi ava oyeupe porandusar upe!” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ambuae arɨ pɨpe, Jesús osepia mbɨa caruguar nomoñehengatui vahe. Evocoiyase omose caruguar ichui. Aheseve voi iñehengatu. Ipare ava rehɨi sepiase, ndoyembovɨhai tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amove rumo ava aipo ehi tẽi yuvɨreco: “Beelzebú, caruguar rerecuar pĩratasa pɨpe revo omboyepepɨ caruguar oico” ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ambuae ava secoãhasa pɨpe oporandu yuvɨreco chupe: “Eyapo ru mbahe nde rembiapo ɨva pendar nde recocuer cua ãgua” ehi tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ahe rumo oicuaño ipɨhañemoñetasa. Evocoiyase aipo ehi chupe: “Que mborerecuar guasu povrɨ pendar ovava-vavase oyeupe oyeamotarẽhɨsave yuvɨreco, ahese evocoi mborerecuar pĩratasa ocañɨ tẽira. Iyavei ava omu rese ae oyeamotarẽhɨ vahe, oyemocañɨ aveira yuvɨreco no. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ẽgüe ehi avei niha caruguar. Esepia, serecuar omboyepepɨse opovrɨ pendar, ovavara oyeupe yuvɨreco viña. Ahese oyemocañɨ tẽira yuvɨreco. Co ñehesa aipo ahe pẽu. Esepia pe, ‘Beelzebú pĩratasa pɨpe tẽi opa omose caruguar ava sui oico’ peye tẽi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ẽgüe ahese rumo viña, ¿ava pĩratasa pɨpe ru evocoiyase pe voya omboyepepɨ caruguar ava sui? Pe voya ae omboyecuara pe ñehe pe rembiavɨ yuvɨreco pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Che rumo Tũpa pĩratasa pɨpe caruguar amboyepepɨ ava sui. Sese cũritei Tũpa mborerecuasa oyepota ité pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Inungar oime ava ipĩrata eteprɨ vahe, iyavei vɨreco oyeroyasa. Ipɨpe osãro güẽta opacatu mbahe ipɨpendar avei icañɨẽhɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Acoi ouse rumo ambuae ipĩrata catu vahe chupe, ahe osecoreroyɨse, opa vɨrocua iyeroyasa ichui. Evocoiyase güembierocua ahe opa vɨraso oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Acoi ava ndache mboyoyai vahe, ahe che amotarẽhɨmbar yuvɨrecoi; iyavei acoi ava ndosecai vahe ava cheu, ahe omosai tẽi yuvɨreco che sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Acoi osẽse caruguar ava sui, oguata tẽi ɨvɨ ipiru vahe rupi opɨtuhu ãgua reca. Ipare rumo ndoyosuise, ipɨhañemoñeta oyeupe, ‘Ayevɨ irira che reco agüerve vicho’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Aheve oyevɨse, osepia iri secocuer inungar oɨ sahuvaprɨ tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sepiase, oso siete caruguar naporai catu vahe reca. Ichui güeruse, oyoya guasu yuvɨroique co mbɨa pɨha pɨpe. Sese mbahe tẽi catu ité secocuer yɨpɨndar güeco agüer sui” ehi Jesús ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Oñehe vɨteseve aipo mbahe rese, cuña ava rehɨi pãhu pendar oñehe pĩrata aipo ehi: —¡Evocoi mbɨa sui ereha vahe iyavei nde mboacua vahe, ahe sovasaprɨ tasecoi! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ahe rumo aipo ehi: —¡Acoi osendu vahe ité che Ru Tũpa Ñehengagüer iyavei vɨroya vahe ité, ahe sovasaprɨ secoira che Ru Tũpa rovaque! —ehi ahe cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ava rehɨi oyere atɨ vɨtese Jesús rese yuvɨreco, ahe aipo ehi: “Pe cũriteindar ava ndaseco põrai vahe, peporandu tẽi poromondɨisa che recocuer cua ãgua rese. Che rumo namboyecuai chira ambuae poromondɨisa pẽu. Jonás recocuer rese güeraño opomomahenduhara. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Inungar Jonás poromondɨisa secoi ava Nínive pendar upe, ẽgüe ehi aveira niha Ava Rɨquehɨr reco pɨpe oimera poromondɨisa ava cũriteindar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Acoi arɨ cañɨ pɨpe cuña mborerecuar guasu irohɨ cotɨ secua vahe porandusave omombehura co ava cũriteindar cañɨpa ãgua. Esepia, ahe ou amombrɨ ɨvɨ sui Salomón mbahecuasa rendu ãgua; cũritei rumo oime ɨvate catu vahe cohave Salomón sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Iyavei arɨ cañɨ pɨpe ava tecua Nínive pendar porandusave omombehura ava cũriteindar cañɨpa ãgua. Esepia niha, omboasɨse oangaipa, oyevɨ Tũpa upe yuvɨreco Jonás omombehuse Tũpa Ñehengagüer chupe; cũritei rumo oime ɨvate catu vahe Jonás sui pe pãhuve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Ndayañomi chira tataendɨ que imoendɨ imoi; ndayamondoi chiaveira que mbahevrɨve. Iyacatu rumo yamondora ɨvate tataendɨ rendave ‘tosesape opacatu ava oique vahe oɨ pɨpe’ yande yapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iyavei pe resa inungar tataendɨ pe retecuer upe. Esepia, avɨyese pe resa, opacatu pe retecuer upe osesape. Acoi imarase rumo, pe retecuer pɨ̃tumimbi vahe nungar tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Sese peicua catu co poroesapesa pereco vahe, tape rereco eme pɨ̃tumimbi vahe nungar. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Co supi eté vahe osesape tuprɨse opacatu pe pɨhave, ndipoise que pɨ̃tumimbisa nungar mbahe ipɨpe, evocoiyase ahe inungar tataendɨ osesape vahe opacatu pe recocuer pɨpe. Ahese ndipoi que pɨ̃tu vahe pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Opase oñehe Jesús, fariseo vɨraso güẽtave imbocaru. Oiquese sẽtave oso, oguapɨ mesave oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ocaru renondeve ndoyepoise rumo, ahese fariseo ndoyembovɨhai tẽi nomboavɨyeise judío porocuaita. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ahe rumo aipo ehi fariseo upe: —Inungar ɨgua rɨru iyavei tembihu rɨru icupe rupi tẽi yoseiprɨ, ipɨpe rumo iquɨha opɨtaño ité, ẽgüe ehi tuprɨ avei pe recocuer pe monda raisave mbahe-mbahe tẽi pe reco pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Pe ndayaracuai vahe peico! ¿Ndapeicuai vo pe rete aposar, pe pɨha aposar avei? ");
INSERT INTO gyrNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sese pemondo porerecosa ava iparaɨsu vahe upe pe recatẽhɨẽhɨsa pɨpe. Evocoiyase ipɨpe sui opacatu imoatɨrombrɨ peicora. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Peparaɨsu pe fariseo! Esepia, yepe pe remitɨ sui pemondo peyacatu ñepei-pei diez vahe sui Tũpa upe viña, pe rumo ndaperoyai teco ɨ̃visa iyavei peseyaño tẽi Tũpa poroaɨsusa. Iyacatu rumo peyapora evocoi mbahe pe porerecosa sui pe poiẽhɨsa pɨpe viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Peparaɨsu pe fariseo! Esepia, peipota pe renda porañete catu vahe pe guapɨ ãgua tũparo pɨpe, iyavei peipota pẽu opacatu ‘avɨrave’ oyapora ava pe mboeteisave ocar rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Peparaɨsu! Esepia, pe recocuerai inungar tehõgüer ruvɨpa icuaẽhɨse ava oguata iharɨ rupi yuvɨreco” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Evocoiyase Moisés porocuaita rese oporombohe vahe, —Porombohesar —ehi—, aipo eremombehu vahe pɨpe niha ava ore amotarẽhɨño yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ahe rumo aipo ehi: —¡Peparaɨsu avei pe Moisés porocuaita rese oporombohe vahe! Esepia, pemondo porocuaita yavai vahe ava upe; pe rumo evocoiyase ndapeipɨ̃tɨvɨimi eté ahe ava imboavɨye ãgua rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Peparaɨsu! Esepia, pemoingatu Tũpa ñehe mombehusar ruvɨpagüer peico Tũpa mboeteisa angahu pɨpe tẽi. Pe ramoi teieté rumo oyuca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Evocoiyase pemboyecua co pe ramoi eta pɨhañemoñeta agüer secocuer moña pɨpe peico. Esepia, ahe oyuca Tũpa ñehe mombehusar yuvɨreco. Pe evocoiyase cũritei pemoingatu vɨte suvɨpagüer peico. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Sese Tũpa ombahecuasa pɨpe aipo ehi: ‘Amondora che ñehe mombehusar, apóstol avei ndiporeroyai vahe upe. Ahe ipãhu pendar oyucara yuvɨreco. Iyavei ambuae mara-mara tẽi vɨrecora yuvɨreco’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Esepia, ava ndiporeroyai vahe cũriteindar upe ité omondora oñemoɨrosa opacatu oñehe mombehusar yucagüer rese aracahe suive, cũriteindar avei oyucase yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel yuca agüer suive oyepotara Zacarías yuca agüerve oso. Ahe oyuca tũparo maranehɨ rocar mbahe reropovẽhesa rovai. Supi eté aipo ahe pẽu: Tũpa opara omondo oñemoɨrosa ahe yuca agüer rese ava ndiporeroyai vahe cũriteindar upe curi. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Peparaɨsu pe Moisés porocuaita rese oporombohe tẽi vahe! Esepia, pe mbahecuasa avɨye soquendaprɨ pereco ava sui. Pe niha ndaperoyai, iyavei ambuae ava upe ndapeipotai seroya ãgua” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ipare Jesús osẽ oso ichui. Ahese Moisés porocuaita rese oporombohe vahe iyavei fariseo eta oñemoɨró iteanga yuvɨreco sese. Ahe omañeco tẽi, oporandu-randu mbahe rese yuvɨreco chupe, ");
INSERT INTO gyrNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","osecoãha-ãha tẽi mbahe pɨpe ‘toyavɨ angahu oñehe yandeu’ ohesa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ahe pɨpeve avei ava oñemonuha atɨ́ iteanga oyembotɨ tuprɨ oyemombo guasu-guasu yuvɨreco. Yɨpɨndar Jesús güemimbohe upe rane omboɨpɨ oñehe: “Peñearo tuprɨ fariseo pan mboapeposa nungar sui. Esepia, ahe ndoyavɨi supi tuprɨ vahe viña; ndahei eté rumo. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Esepia, yaposa vahe imombehupɨrẽhɨ cũritei icuasaño itera curi. Iyavei mbahe ñomiprɨ icuasaño aveira no. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Supi eté opacatu mbahe pemombehu vahe pɨ̃tumimbisave, ahe sendusa tuprɨra arɨ pɨpe coiye; iyavei acoi mbahe pemombehu vahe peyeupeñomi ‘tosendu eme ambuae ava’ pe hesa pɨpe, serosapucaisara oɨ harɨve opacatú ava rovaque” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Iyavei aipo ahe pẽu, che mborɨpareta: ndapesɨquɨyei chira acoi ava pe yuca potasar sui. Esepia, ipare ndoicatu iri ambuae mbahe apo ãgua pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Che rumo amombehura pẽu uma sui pesɨquɨyera: acoi oicatu vahe omborerecuasa pɨpe pe yuca pare pemondo tata guasuve. Ahe ichui eté pesɨquɨyera. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Pe pemondo poyandepo vɨ̃rai ñuvɨrío guarepochi rupivemi tẽi yepi. Tũpa rumo ndasesarai eté que ñepei sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Tũpa niha oicua ñepei-pei yande ha retacuer. Sese, pesɨquɨye eme; pe niha ɨvate catu vahe ité peico opacatu vɨ̃rai sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Acoi ava ‘che aroya Jesús’ ehi vahe opacatu ava rovaque, che avei, Ava Rɨquehɨr, ‘Co che reroyasar secoi’ aipo ahera che Ru upe sembiguai rovaque. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Acoi ava ‘che ndaroyai Jesús’ ehi vahe rumo cheu opacatu ava rovaque, che avei evocoiyase, ‘Co ndahei che reroyasar secoi’ ahe aveira che Ru Tũpa upe sembiguai rovaque” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Iyavei opacatu oñehe-ñehe tẽi vahe che, Ava Rɨquehɨr, rese, ahe chupe oimeño ñeroisa. Acoi que ava iñehe-ñehe tẽi vahe rumo Espíritu Santo amotarẽhɨsave, ahe chupe ndipoi chietera ñeroisa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Acoi pe amotarẽhɨsar che recocuer sui tẽi pe rerasose porandusave pe recoãha ãgua yuvɨreco, anise mborerecuar mbahe moingatusar rovai, que ambuae mborerecuareta upe avei no, ‘¿Mbahe pĩha amombehura?’ ndapeyei chira. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Esepia niha, ahe pɨpeve voi Espíritu Santo pe mbohera avɨyeteramo tẽi mbahe mombehu ãgua rese” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ñepei mbɨa ava rehɨi pãhu pendar aipo ehi Jesús upe: —Porombohesar, emombehumi che rɨquehɨr upe, tomboyahomi tẽi mbahe che mombahesa cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ahe rumo omboyevɨ chupe: —Che mborɨpar, che ndachecuaitai mbahe moingatu ãgua, mbahe mboyaho-yaho ãgua avei —ehi ahe mbɨa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ipare aipo ehi: —Peñearo tuprɨ opacatu mbahe pota raisa sui. Esepia niha, ndahei mbahe rereco atɨ ãgua pe recocuer —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ipare omboyoya ambuae mbahe rese imbohe: “Oime mbɨa mbahe yar, iha tuprɨ ai eté semitɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ahese ipɨhañemoñeta oico oyeupe: ‘¿Mara ahera pĩha che rembipoho rereco?’ ehi tẽi. ‘Ndareco iri eté yapocatu ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ipare ipɨhañemoñeta cute: ‘Aicua mbahe che rembiaporã. Opara aroyɨ tembihu rẽta. Ichui ayapo irira ambuae tuvichá catu vahe. Aheve ayapocatura che remitɨ rãhɨi opacatu mbahe areco vahe avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Evocoiyase aipo ahera cheyeupe: Che mborɨpar, oime setá mbahe cheu aravɨter momba-momba ãgua; sese cũritei apɨtuhura vichico, acarura, acahura iyavei ayembovɨharetera no, ahera’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tũpa rumo aipo ehira chupe: ‘Mbɨa, nandearacuai eté eico, co pɨ̃tu pɨpeve voi eté eremanora. Co mbahe nde rembiapocatu, ¿ava mahera pĩha evocoiyase?’ ehira chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ẽgüe ehi eté niha que ava oyeupeñomi tẽi mbahe omonuha atɨ vahe, iparaɨsu rumo Tũpa rovaque” ehi ahe mbɨa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ipare aipo ehi Jesús güemimbohe upe: “Co amombehura pẽu: Ndapeyemomahenduha guasu ai chira pe remihura rese pe recove ãgua, pe turucuarã rese tẽi avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yande recovesa rumo avɨye catu vahe tembihu sui; yande retecuer avei avɨye catu turucuar sui no. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pesepia vɨ̃rai: nomahetɨi vahe, nomonuhai vahe avei, ndovɨrecoi vahe avei mbahe rãhɨi rẽta yuvɨreco. Tũpa rumo omoime mbahe itohu. ¡Pe rumo ɨvate catu vahe ité peico vɨ̃rai sui! ");
INSERT INTO gyrNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ndipoi eté que ñepei pe pãhu pendar oicatu vahe opɨhañemoñetá iteangasa pɨpe tẽi güecocuer mbosasaviño ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Supi eté ndapeicatuise yapo, ndiyai peyemomahenduha guasu ai mbahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Pemahecua ru mbahe potrɨ caha pɨpendar rese: ndoporavɨquɨi eté iyavei ndoipɨai oturucuarã. Iyavei no yepe mborerecuar guasu Salomón vɨreco setá mbahe iporañete vahe aracahe viña, iturucuar catuprɨgüer rumo ndahoyoyai mbahe potrɨ catuprɨgüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tũpa niha omboporañete raimi tẽi mbahe potrɨ caha pɨpendar. Ichui sapɨsapaño horno pɨpe. ¡Ahe rumo omondo catura turucuar pẽu, pe ava nimbahe reroya tuprɨi vahe! ");
INSERT INTO gyrNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Sese, ‘¿Mbahe pĩha yahura, mbahe pĩha yamondera?’ ndapeyei chira pe yemomahenduha guasu aisa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Esepia, ava Tũpa reroyasarẽhɨ co ɨvɨ pɨpendar aipo nungar mbahe reseño tẽi ipɨhañemoñeta yuvɨreco yepi. Pe Ru Tũpa rumo oicua ité pẽu mbahe ipane vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Avɨye catu rumo pesecara pe Yar Tũpa povrɨve pe reco ãgua, ahese omboura que mbahe ipane vahe pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Aní pesɨquɨye, che ovesa nungar, yepe pe movɨromi tẽi peico viña, pe Ru rumo oporoaɨsusa pɨpe oipota opovrɨve pe rereco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pemondopa mbahe pereco vahe ava oipota vahe upe. Ipare pemondo seprɨ avei iparaɨsu vahe upe. Ahe yapocatusa ɨvave mbahe rɨru ndituyui vahe nungar pɨpe. Aheve ava imonda rai vahe ndoiquei chira ñomi ãgua pe sui iyavei mbahe rasoi nomomarai chiaveira. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Esepia, pe mbahe pe rembiereco setá catu vahesa rupi-rupi pe pɨhañemoñeta yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Peyemoingatu tuprɨ che yevɨ ãgua. Inungar tataendɨ ndogüei vahe, pemboyecua tuprɨño ité che recocuer pe recocuer pɨpe ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Peico imboacuaprɨ güerecuar osãro vahe nungar mendasa sui iyevɨse, oquenda imotase, omboi voi vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Avɨye itera serecuar upe osepiase iyemoingatu voi; evocoiyase serecuar ae niha ihañecora sese, omboguapɨra mesave imbocaru. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yepe serecuar oyepotara pɨ̃tu mbɨter ou viña, anise añihiveive, ahe rumo osãroño itera chupe imboi ãgua yuvɨreco. Evocoiyase serecuar avɨye ai etera chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Peyapɨsaca tuprɨ co rese: acoi oɨ yar oicuase mbahe hora imonda vahe yepota ãgua, ahese opɨtara imonda vahe rãro güẽta pɨpe sui mbahe renoseẽhɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ẽgüe peye aveira peyemoingatu che yevɨ ãgua. Esepia niha, che, Ava Rɨquehɨr, aporoesapɨha tẽira vitu curi” ehi Jesús vɨroyasareta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Evocoiyase Pedro oporandu Jesús upe aipo ehi: —Che Yar, ¿oreuñomi pĩha eremombehu co porombohesa eremboyoya vahe ambuae mbahe rese, opacatu upe tie? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Evocoiyase omboyevɨ Pedro upe aipo ehi: “Acoi ava mbahe rese ñangarecuar omboavɨye tuprɨ vahe ocuaita, yaracua vahe avei, ahe chupe serecuar oseya icuaitarã güẽta pɨpendar rese hañeco ãgua ‘tembihu tomondo che rẽta pɨpendar upe che porocuaita rupi’ ohesave. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Acoi omboavɨyese ocuaita, ahese ovɨharetera güerecuar yevɨse. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Supi eté niha, serecuar oyocuaira opacatu ombahe rese hañeco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ahe mbiguai rumo ‘ndoyepota vɨtei chira revo che rerecuar’ oya omboetasa cuimbahe iyavei cuña omboɨpɨ mara-mara tẽi sereco iyavei ocaru, oɨhu tẽi osavaɨpo-ɨpoño avei oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ipare rumo serecuar oyepotara imahemohaẽhɨseve; ahese omombaraɨsu catura inupa sereco, inungar acoi ndiporeroyai vahe rerecosa yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Acoi mbiguai oicua tẽise mbahe güerecuar remimbotar, noyemoingatuise rumo iyavei ndovɨroyaise oico, ahe evocoiyase serecuar oinupara. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Acoi mbiguai nomboavɨyei vahe ocuaita icua tuprɨẽhɨsa pɨpe, nañemoɨrosa rutei chira chupe. Esepia niha, acoi imondosa catu vahe icuaitarã, porandusa catura chupe. Acoi oyeroya catu vahe, oporandu catu aveira sese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Che ayu tata nungar yavai vahe reru ãgua co ɨvɨ pɨpendar upe ‘¡oyandu tarahu yuvɨreco cute viña!’ viya. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Aique ranera rumo mbahe tẽi che recoãhasa pɨpe, ¡ẽgüe ahera che paraɨsú itera imboavɨye ãgua! ");
INSERT INTO gyrNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","‘Mbahe tuprɨ ai revo güeru co ɨvɨ pɨpe’ ndapeyei chira cheu. Ẽgüe ehi rumo che ayu che sui ava yeamotarẽhɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Esepia niha, co pɨpe suive ité que poyandepo tuprɨ revo oñemu yuvɨrecoi vahe amove oyeamotarẽhɨra yuvɨreco che recocuer sui: mbosapɨ oyamotarẽhɨra ñuvɨrío vahe, ñuvɨrío vahe evocoiyase oyamotarẽhɨra mbosapɨ vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Que ava oyamotarẽhɨra guahɨr, anise tahɨr evocoiyase oyamotarẽhɨra vu; cuña oyamotarẽhɨra omembrɨ, imembrɨ evocoiyase oyamotarẽhɨra osɨ; sovayar oyamotarẽhɨra vovayar” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ipare Jesús aipo ehi ava rehɨi upe: “Pe pesepiase mbahe pɨ̃tu arɨ sosa cotɨ sui opũhase, ahese, ‘Oquɨra’ peye. Ẽgüe ehi eté oquɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iyavei acoi ɨvɨtu oipeyuse irohɨ cotɨ sui, ahese, ‘Sacú iteangara’ peye. Ipare ẽgüe ehi eté. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Pe Tũpa reroyasar angahu tẽi peico vahe! Pe niha peicua mbahe ɨva rese oyecua vahe tẽi iyavei ɨvɨ rese mbahe oyecua vahe tẽi mombehu, ¡mahera ru ndapeicuai peyeupe mbahe cũritei oime vaherã mombehu peico!” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Mahera napesãha ranei pe ae ité co mbahe supi eté vahe? ");
INSERT INTO gyrNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Acoi que ava nde amotarẽhɨsar nde soho ucase nde mondo ãgua mborerecuar rovai, emoingatu tuprɨ voi mbahe eico chupe tenondeve nde rerasoẽhɨ ãgua sovai; anise, mborerecuar nde mondora ava naporai vahe rarõsar upe. Ahe evocoiyase nde roquendara. ");
INSERT INTO gyrNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Supi eté nderesẽi chietera acoi eremboepɨpase voi eté eresẽra ichui” ehi ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ahe pɨpeve avei yuvɨraso ava Jesús repia. Ahese omombehu Pilato mbɨa Galilea pendar yuca uca agüer: Ahe mbɨa vɨropovẽhese mbahe mɨmba yucaprɨ yuvɨreco chupe. Ahe suvɨ oyeseha mbahe mɨmba ruvɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ipare Jesús aipo ehi chupe: “Pemoha co pe: Mbahe tẽi oime vahe evocoi mbɨa Galilea pendar upe, yangaipa guasu catu rese ambuae güecua pendar sui ẽgüe ehi mbahe chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Aní rumo! Acoi ndapemboasɨise pe angaipa Tũpa upe pe yevɨ ãgua, pe avei opara pecañɨ tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Peroya avei acoi ava dieciocho tuprɨ yuvɨrecoi vahe omanopase Siloé torre ovɨapise iharɨve, ‘Ahe yangaipa catu yuvɨreco ambuae ava Jerusalén pɨpendar sui’ peye viña no. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Aní rumo; acoi ndapemboasɨise pe angaipa Tũpa upe peyevɨ ãgua, pe avei opara pecañɨ tẽi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Evocoiyase Jesús omombehu mbahe omboyoya oporombohe ambuae mbahe rese aipo ehi: “Oime mbɨa vɨreco vahe ɨvɨra higuera oco pɨpe. Setá arɨ ahe oso sepia ‘¿iha pĩha?’ oyapave. Ndosecai eté rumo iha sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ahese aipo ehi mbɨa oco rãrosar upe: ‘Esendu, che ayu pɨhi tẽi higuera ha reca mbosapɨ aravɨter rupi. Ndasepiai eté rumo que ñepei iha sese yepi’ ehi. ‘Eyasɨapa; ndiyai ihãi tuprɨ tẽi cohave’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ico rarõsar rumo omboyevɨ chupe aipo ehi: ‘Che rerecuar, ẽgüe tehiño vɨte tẽi rane co aravɨter; amonguhira ɨvɨ chupe. Ipare amondora ɨvɨ sũ vahe mbahe repochi resendar sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ahese revo ambuae aravɨter ihara cute; anise ité rumo, ereyasɨa ucaño itera’ ehi ico rãrosar güerecuar upe” ehi Jesús ava mbohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ñepei mbɨtuhusa arɨ pɨpe Jesús oporombohe judío tũparo pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Aheve oime cuña imbaheasɨ vahe, dieciocho aravɨter rupi ahe mbaherasɨsa vɨreco, caruguar tẽi omboyeapami uca sereco. Sese ndoicatui opũha tuprɨ oguata. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Osepiase rumo Jesús, “Erio” ehi chupe. —Cuña, cũritei nanembaheasɨ iri eico cute —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Evocoiyase omondose opo sese, aheseve voi cuña oyemohɨvi. Ipare omboetei Tũpa oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Judío tũparo rerecuar rumo oñemoɨro ahe cuña mbogüerasa rese mbɨtuhusa arɨ pɨpe. Sese aipo ehi ava eta upe: —Oime niha seis arɨ mboravɨquɨ ãgua; ahe arɨ pɨpe peyura peposano ãgua, ndahei chira mbɨtuhusa arɨ pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Evocoiyase ahe mbɨa upe omboyevɨ aipo ehi: —Pe Tũpa reroyasar angahu tẽi peico vahe, ¿nomboɨhui vo pe pãhu pendar acoi güeimba tɨvi iyavei guaricu mbɨtuhusa arɨ pɨpe yuvɨreco yepi no? ");
INSERT INTO gyrNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Co rumo cuña, Abraham suindar Caruguar omombaheasɨ vahe dieciocho aravɨter suive sereco, ¿ndiyai eté pĩha evocoiyase imbogüerasa mbɨtuhusa arɨ pɨpe? —ehi tũparo pendar rerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Aipo ehise, opacatu yamotarẽhɨsar yuvɨnochi tẽi yuvɨreco ichui. Ambuae ava rumo oyembovɨhaño opacatu Jesús rembiapo osepiase yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Evocoiyase Jesús aipo ehi avei: “¿Mbahe nungar pĩha Tũpa povrɨ pendar, iyavei mbahe rese vo amboyoyara? ");
INSERT INTO gyrNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Oyoya tuprɨ ité mostaza rãhɨi rese, inungar acoi mbɨa oñotɨ vahe oco pɨpe. Ichui ocuacua, tuvichá iteanga. Ahe sãca rese vɨ̃rai rehɨi oyapo guaitɨrã” ehi oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Evocoiyase Jesús aipo ehi iri: “¿Mbahe rese pĩha amboyoyara Tũpa povrɨ pendar? ");
INSERT INTO gyrNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Oyoya tuprɨ co pan mboapeposa rese, acoi cuña omboyeseha tuprɨ vahe mbosapɨ sãhambrɨ trigo cuhi rese opacatu imboapepo ãgua yepi” ehi oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ipare Jesús osoño Jerusalén ve, opɨta-pɨta tecua yacatu rupi oporombohe oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ahe supi ichose, ñepei mbɨa oporandu chupe aipo ehi: —Che Yar, ¿supi eté pĩha movɨromi tẽi ava oñepɨsɨrora yuvɨreco? —ehi. Ahe evocoiyase omboyevɨ chupe: ");
INSERT INTO gyrNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Peyemovɨracua tuprɨ catu peique ãgua oquendɨpɨ cãhimi rupi. Esepia niha, supi eté setá ava osãha tẽira yuvɨroique vaherã ahe oquenda rupi yuvɨreco viña, ndoyuvɨroique catui chira rumo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Supi eté ahe inungar oɨ yar ouse oquenda mboya viña. Amove ava evocoiyase ocarve yuvɨrecoi vɨte vahe omota tẽira oquenda, ‘Ore yar, emboimi tẽi oreu’ ehi tẽira yuvɨreco. Ahe rumo aipo ehiñora chupe: ‘Aní, ndopocuai vahe rumo pe’ ehiñora chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Evocoiyase ahe aipo ehi tẽira yuvɨreco: ‘Ore niha orocaru vahe, oroɨhu vahe nde pɨri, iyavei ore mbohe ore rocar rupi eve yepi’ ehi tẽira yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ahe rumo aipo ehira: ‘Ñepei reseve niha acoi, Ndopocuai vahe, ahe pẽu. ¡Pesɨrɨ che sui, pe opacatu mbahe-mbahe tẽi aposar!’ ehiñora chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pe rumo imomboprɨra pe recocuer Tũpa povrɨ sui, sese peyaseho tẽira, peyemoaitere tẽira peico pesepiase Abraham, Isaac, Jacob iyavei opacatu Tũpa ñehe mombehusareta yuvɨrecoise Tũpa povrɨve ɨvave. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iyavei ava yugüerura añihivei cotɨ sui, caharu cotɨ sui, norte cotɨ sui iyavei irohɨ cotɨ sui, ahe evocoiyase yuvɨroguapɨra ocaru Tũpa mborerecuasave ipɨri yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Supi eté amove ava ndoyavɨi ipa tẽi vahe seique ãgua ɨvave Tũpa pɨri viña, ahe ranengatu rumo yuvɨroiqueño itera ipɨpe iyavei amove ava tenonde catu vahe ndoyavɨi ahe rane oique vaherã ɨvave viña. Ahe rumo ipa tẽi yuvɨroiquera —ehi Jesús ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ahe arɨ pɨpe oyepota movɨro fariseo aipo ehi tẽi Jesús upe yuvɨreco: —Eyepepɨño ave sui. Esepia, Herodes niha nde yuca pota oico —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ahe rumo, —Peso, tapemombehu aipo mbɨa aguara nungar tẽi upe: ‘Esepia, co pɨpe iyavei ayihive amboyepepɨñora ava sui caruguareta vichico, ambogüerañora ava imbaherasɨsa sui, curi ayihive evocoiyase amombara che cuaita’ peyera. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Che rumo aporavɨquɨño itera co pɨpe, ayihive iyavei curi ayihive vichico. Ipare asora Jerusalén ve. Esepia niha, ndiyai Tũpa ñehe mombehusar omano co cotɨ tẽi Jerusalén sui yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Too rutei pe Jerusalén pendar, peyuca vahe Tũpa ñehe mombehusar, iyavei ita pɨpe peyapi-yapi ava Tũpa remimbou yepi! ¡Setá rupi che opomonuha pota tẽi pe rereco, inungar tacura omonuha vahe omembrɨ opepovrɨve, ẽgüe ahe pota tẽi pe rereco viña, pe rumo ndapeipotai eté! ");
INSERT INTO gyrNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sese seyapɨrã tẽi peicora. Iyavei ndache repiai chiaveira peye acoi, ‘Imboeteiprɨ Yar remimbou tasecoi’ peyese voi che repia irira peye” ehi Jerusalén pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ñepei mbɨtuhusa arɨ pɨpe Jesús oso ocaru mborerecuar fariseo rẽtave. Aheve ambuae fariseo eta oivɨro yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Aheve avei mbɨa iruru vahe secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Evocoiyase Jesús oporandu Moisés porocuaita rese oporombohe vahe upe iyavei fariseo eta upe avei aipo ehi: —¿Ipotasa vo mbɨtuhusa arɨ pɨpe imbaheasɨ vahe mbogüera ãgua; aní tie? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ahe rumo noñeheiño yuvɨreco chupe. Ahese ahe opoco imbaheasɨ vahe rese, ombogüera. Ipare, “Eso tuprɨño” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Fariseo eta upe evocoiyase aipo ehi: —¿Ava pĩha pe pãhu pendar novɨnose voi chira güeimba guaricu, anise tɨvi ovɨapise ɨvɨcuar pɨpe mbɨtuhusa arɨ pɨpe viña? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ahese nomboyevɨ catui eté iñehe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ava ichohoprɨ oiporavo-ravo güenara imboyeroyaprɨ catu vahe mesave oyeupe nara yuvɨreco. Ahe sepiase aipo ehi Jesús imboaracua: ");
INSERT INTO gyrNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Acoi que yande soho ucase mendasa pietasave yuvɨreco, ndayaguapɨi chira ava imboeteiprɨ catu vahe renda harɨve. Esepia, avɨyeteramo que ambuae ava ichohoprɨ oyepotara yande sui imboeteiprɨ catu vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ipare yande soho ucasar aipo ehira yandeu: ‘Epũha evocoi sui, co mbɨa toguapɨ eipeve’ ehira yandeu. Evocoiyase yande yachĩ tẽira yaso ipami tẽi yaguapɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Yande soho ucase rumo yuvɨreco, yaguapɨra evocoiyase ipa; yande soho ucasar ouse, aipo ehira yandeu: ‘Mborɨ, erio cohave tenda imboeteiprɨ catu vahesave ore pɨri’ ehira. Ẽgüe yahera imboeteiprɨ yaico acoi ava yuvɨroguapɨ vahe rovaque yande pɨri. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Esepia niha, acoi ava oyemboɨvate ai vahe opara seco reroyɨsa; acoi ava seco mbegüe vahe rumo, ahe seco mboɨvate catusara curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ipare aipo ehi avei ichohosar upe: —Ereyapo potase pieta, ndereichoho ucai chira nde mborɨpar, que nde rɨvrɨ, que nde mu iyavei que nde rẽta cotɨndar imbahe eta vahe. Esepia niha, ahe omboyevɨra ndeu, nde soho ucara oyepɨri yuvɨreco; ẽgüe ehira evocoiyase mbahe imboyevɨpa yuvɨreco ndeu. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ereyapose rumo pieta, ereichoho ucara ava iparaɨsu vahe, ava ipo ichutu vahe, anise ipɨ chutu vahe, ipãri-pãri vahe, ndasesapɨsoi vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Esepia niha, ahe ndoicatui mbahe mboyevɨ yuvɨreco ndeu. Opase rumo ocuerayevɨ ava seco catuprɨ vahe yuvɨreco, ahese erevɨharetera eico. Esepia, ereipɨsɨra mbahe avɨye vahe Tũpa suindar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iñehe renduse rumo, ñepei mbɨa yuvɨroguapɨ vahe mesave, ahe aipo ehi Jesús upe: —¡Sovasaprɨ catu ava Tũpa pɨri ocaru vahe imborerecuasave! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Evocoiyase aipo ehi ahe mbɨa upe: —Oime mbɨa oyapo vahe carusa guasu, oichoho uca ava setá oyepɨri. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ipare oyepotase arɨ caru ãgua, ahese aipo ehi güembiguai mondo: ‘Toyugüerupa che pɨri ichohoprɨ. Esepia niha, mbahe opa oingatu cute’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Opacatu rumo ava, ‘Eñemosañomi tẽi cheu’ ehi pãve yuvɨreco. Yɨpɨndar mbɨa aipo ehi: ‘Che rumo arocua ɨvɨ; iya ité aso sepia. Sese eñemosaño cheu’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ambuae mbɨa aipo ehi: ‘Che arocua ramo diez tuprɨ tɨvi, ahe asãha ranera. Sese eñemosaño cheu’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ambuae aipo ehi no: ‘Che amenda ramomi vichico. Sese tẽi ndasoi chira’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Oyevɨse mbiguai, opa tuprɨ omombehu mbahe güerecuar upe. Ahese serecuar aipo ehi oñemoɨrosa pɨpe güembiguai upe: ‘Eso voi evocoiyase opacatu ocar rupi. Supi sui eru ava iparaɨsumi vahe, que ava ipo chutu vahe, anise ipɨ chutu vahe, que ndasesapɨsoi vahe, anise que ava ipãri-pãri vahe avei no’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Coiye ava reru pare aipo ehi mbiguai güerecuar upe: ‘Che rerecuar, aroya ité nde che cuaita; ipane vɨte rumo ava’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Evocoiyase aipo ehi güembiguai upe: ‘Eguata iri ambuae perɨ tecua ɨvɨrindar rupi avei toyugüerumi che rẽtave yuvɨreco che pɨri, tomboapɨpopa ité che rẽta yuvɨreco’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘Esepia niha, acoi yɨpɨndar ava aichoho uca vahe ndipoi chietera que ñepei ocaru vaherã che pɨri’ ehi güembiguai upe —ehi Jesús ahe mbɨa mbohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ava rehɨi Jesús raquɨcuei oguata yuvɨreco. Sese ahe oyemboyere aipo ehi ava upe: ");
INSERT INTO gyrNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Acoi oimese que ava oipota vahe che rupi oguata ãgua, tache raɨsu catu que ambuae ava sui, que oyesupa, osɨ, güembireco, guahɨreta, vɨvɨreta iyavei güeindɨreta sui, oyesui avei. Ẽgüe ndehise, evocoiyase ndiyai chupe che remimbohe seco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iyavei que ava noñemosañoi vahe mbahe-mbahe tẽi upe oiporarase arɨ yacatu rupi inungar-ra ocurusu rese ovosɨi vahe viña che rupi oguata ãgua, ahe chupe ndiyai che remimbohe seco ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Que ava pe pãhu pendar omopuha potase oɨ, ¿ndoyapɨsaca ranei chira ‘¿amomba angara pĩha?’ oyapave? ");
INSERT INTO gyrNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Esepia niha, omondose oɨ renara yɨpɨndar. Ipare rumo nomboavɨye catuise, ahese opacatu ava sepiase vɨroɨ̃rora ");
INSERT INTO gyrNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","aipo ehira yuvɨreco: ‘Aye evocoi mbɨa omopuha pota tẽi oɨ viña, ndoicatui eté rumo imboavɨye’ ehira yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Iyavei que mborerecuar guasu diez mil sundao vɨreco vahe oyeepɨ potase ambuae mborerecuar veinte mil ava vɨreco vahe sui, oyapɨsaca ranera yɨpɨndar icua tuprɨ ãgua ‘¿yaicatura pĩha setá catu vahe rese yavava?’ ohesave. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Esepia, ndoicatuise, evocoiyase ambuae mborerecuar guasu amombrɨ vɨte secoise, omondora mbahe mombehusar mbahe tuprɨ rese porandu ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ẽgüe ehi avei pe recocuer ndapeseya potaise pe mbahe opacatu, ẽgüe ehi vahe ndahei eté che remimbohe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Yucrɨ avɨye vahe ité yandeu; nasehe irise rumo, ndayaicatui chietera imoehe iri ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Naporai eté ɨvɨ upe nara; ndiyai avei ɨvɨ mbahe repochi resendar rese oyeseha vaherã. Evocoiyase ahe imomboprɨ tẽi vaherã. Sese aipo ahe acoi ava oyapɨsaca pota vahe, toyapɨsacaño” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Opacatu ava sui guarepochi rerocuasar yuvɨrecoi vahe iyavei ava eta yangaipa guasu vahe, oyemboya Jesús rese iñehe rendu ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sese fariseo yuvɨrecoi vahe iyavei Moisés porocuaita rese oporombohe vahe yuvɨreco, ahe ovɨroɨ̃ro tẽi yuvɨreco aipo ehi: —Co mbɨa omborɨ pota rai ava yangaipa guasu vahe tẽi oico yepi, ocaru avei ipãhuve no —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Evocoiyase Jesús omombehu ovesa resendar yembohesa: ");
INSERT INTO gyrNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Que ñepei pe pãhuve vɨrecose cien ovesa güeimba, ipare co ocañɨra ñepei ichui viña, oseya ranera evocoiyase evocoi noventa y nueve tẽi avɨye vahesave seco ãgua. Ipare oyevɨra ocañɨ vahe reca oso, oyosu rane itera viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Oyosuse, osupira oachihɨve vorɨvetesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ipare oyepotase güẽtave, omonuhara omborɨpareta, ocotɨndareta avei no. Ipare aipo ehira chupe: ‘Yayembovɨhara che pɨri. Esepia niha, ayosu ité ovesa ocañɨ vahecuer cute’ ehira. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Supi eté ẽgüe ehi aveira oime torɨvetesa guasu catu ɨvave acoi ñepei ava yangaipa guasu vahe oñecuñarose güecocuerai sui noventa y nueve yuvɨrecoi tuprɨ vahe sui yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Acoi que cuña omocañɨse ñepei guarepochi diez tuprɨ vɨreco vahe sui, omoendɨra tataendɨ. Ipare osahuvara oɨ, oseca mbegüera, oyosu rane itera. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Evocoiyase oyosuse, omonuhara omborɨpareta, ocotɨndareta avei no chupe aipo ehira: ‘Yayembovɨhara che pɨri. Esepia niha, ayosu guarepochi che sui ocañɨ vahecuer cute’ ehira. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Supi eté ẽgüe ehi aveira oime torɨvetesa Tũpa rembiguai ɨva pendar rehɨi upe que ñepei ava yangaipa guasu vahe oñecuñarose güecocuerai sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Aipo ehi avei oporombohe: “Oime mbɨa vɨreco vahe ñuvɨrío guahɨr. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chĩhivahe catu vahe aipo ehi oyesupa upe: ‘Che ru, embou mbahe che mombahesa cheu’ ehi. Iyesupa evocoiyase omboyaho ombahe imondo chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ipare coiye catumi, omonuhapa opacatu ombahe. Ichui oso amombrɨ ambuae tecuave. Aheve oguarepochi oiporupa tẽi ombahe pota raisa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Acoi oiporupa tẽise rumo opacatu ombahe, ahese oime tɨavor ahe ɨvɨ rupi. Ahe evocoiyase ndasɨepoi tẽi oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Evocoiyase oso mboravɨquɨ reca mbɨa pɨri aheve. Ahe mbɨa evocoiyase omondo ocove güeimba cuchi rãro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aheve oyemohɨtaro pota tẽi cuchi rembihu pɨpe oico viña. Ndipoi eté rumo omondo vahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Evocoiyase oyemomahenduha tẽi güẽta pendar oporavɨquɨ vahe rese: ‘¡Che ru rẽtave oporavɨquɨ vahe rumo co omoumbɨre guasu-guasu tẽi güembihu yuvɨreco! ¡Che rumo che yuca pota tẽi che rɨeporẽhɨ che rereco cohave! ");
INSERT INTO gyrNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Sese ayevɨra che ru rẽtave. Aipo ahera chupe: Ayemboangaipa Tũpa rese, nde rese avei no. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ahese che ndahe iri chira nde rahɨr nungar aico; iyacatu revo ndeu, oporavɨquɨ vahe nungar tẽi che rerecoñora eve, ahera’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Evocoiyase oyevɨ iri oso vu rẽtave cute. “Amombrɨ vɨtemi tahɨr recose rumo iparaɨsu catu chupe, oña voi oso guahɨr rovaĩchi, oyaco osovaupɨte avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ahese tahɨr aipo ehi chupe: ‘Che ru, ayemboangaipa Tũpa rese, nde rese avei; ndiya iri nde rahɨr che reco ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tu rumo aipo ehi güembiguai upe: ‘Peso, taperumi avɨye catu vahe turucuar pemboyemonde, pemonde avei cuã penda sese, pɨtaqui avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iyavei guaca iquɨra catu vahe peyuca. ¡Yayapora pieta guasu!’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‘Esepia, co che rahɨr avɨye omano vahe secoi viña, cũritei rumo oyevɨ iri cheu’ ehi. Ẽgüe ehi opacatu sorɨvete yuvɨreco pieta apo. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tahɨr cuacua catu vahe rumo ocove vɨte secoi. Oyevɨse ou güẽta rerovɨcave, osendu voi ipieta guasu vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Evocoiyase oporandu mbiguai upe mbahe oime vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Nde rɨvrɨ mo co oyevɨ tuprɨ iri ou. Sese nde ru oyuca uca guaca iquɨra vahe iyevɨsa resendar’ ehiño. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Evocoiyase tɨquehɨr oñemoɨrosa pɨpe, ndoique potai oyesupa uve oɨ pɨpe; tu rumo osẽño ité ocarve ‘eique’ oya chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Evocoiyase tahɨr omboyevɨ chupe aipo ehi: ‘Che niha setá aravɨter rupi oropɨ̃tɨvɨi vichico nde mboyeroyasave viña, nderemboumi eté rumo que mbahe cheu, que mbahe mɨmba angara viña che mborɨpar rese ore pieta ãgua’ ehi vu upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","‘Indó, cũritei oyepota ndeu nde rahɨr, omocañɨ tẽi vahe nde guarepochi cuña ndipɨhai vahe rese tẽi. Ahe eremboetei catú che sui; ereyuca uca rutei guaca iquɨra vahe chupe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Evocoiyase tu: ‘Eyapɨsacaño, che rahɨr, nde niha nderesɨrɨi vahe che sui. Opacatu che areco vahe rumo nde mbahe ité yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Cũritei rumo iyacatu ité yande rorɨvetesave yayapora pieta. Esepia, co nde rɨvrɨ ocañɨ tẽi vahecuer rese yamahe iri’ ehi guahɨr upe” ehi Jesús ava eta mbohe. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús aipo ehi avei güemimbohe eta upe: “Oime mbɨa imbahe eta vahe. Ahe vɨreco mbɨa ombahe eta rese ñangarecuar. Ahe chupe ava yugüeru mbahe mocañɨ tẽi agüer mombehu. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Evocoiyase serecuar ñepei opɨ̃tɨvɨisar omondo seca, ahe güeruse, ‘¿Mbahe vo aipo ereyapo eico; ayandu cũritei nde rerãcua? Emoingatupa tuprɨ voiño nde poravɨquɨsa resendar cheu’ ehi, ‘Nandehañeco iri chira cohave mbahe rese cheu’ ehi, ‘Nandehañeco iri chira cohave mbahe rese cheu’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Evocoiyase mbahe rese ñangarecuar: ‘¿Mara ahera pĩha co evocoiyase vichico imomboprɨ che recose che poravɨquɨsa sui? Ndareco iri rumo pĩratasa cheyese ɨvɨ rese che poravɨquɨ ãgua. Achĩ eteanga aveira rumo mbahe rese che porandu ãgua’ ehi tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‘Aicua rumo cute mara ahera vichico: che poravɨquɨsa sui opa che momboise, oimera che pɨsɨ tuprɨ vaherã oyepɨri’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Evocoiyase oñehe ñepei-pei güerecuar sui mbahe vɨnose tẽi vahe rese chupe. Yɨpɨndar vahe upe oporandu: ‘¿Mbovɨ mbahe erenose tẽi yande rerecuar sui?’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Cien tuprɨ chereve aceite sɨru tuvichagüe vahe rese’ ehi. Evocoiyase, ‘Eguapɨ ru, co oime cuachiar sesendar nde yecuachía agüer. Emondoro, eyapo iri ambuae cincuenta rupindar año’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ichui ambuae mbahe vɨnose tẽi vahe upe oporandu no: ‘¿Mbovɨ mbahe vo erenose tẽi yande rerecuar sui?’ ‘Cuatro ciento quintar rupindar’ ehi. Evocoiyase, ‘Co oime cuachiar sesendar. Yaicuachiara rumo tresciento veinte quintar rupindar’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Evocoiyase serecuar oyanduse, ‘Too, oicua ité mbahe apo’ ehi ombopasa rese ombahe rese ñangarecuarer ndipɨhai vahe upe. Esepia, ahe oyemoingatu voi oyeupe mbahe moingatu ãgua. Supi eté ava ndoicuai vahe Tũpa oicua catu mbahe moingatu ãgua oyeupe Tũpa reroyasar sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Sese che aipo ahe pẽu: peiporu pe guarepochi pereco vahe co ɨvɨ pɨpe pe mborɨpar reime ãgua. Ichui opa tẽise pe guarepochi, oimera pe pɨsɨ vaherã teco apɨrẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Acoi ava mbahe tuprɨ chĩhi oyapo vahe, ahe oyapo tuprɨ catura mbahe tuvichá vahe. Iyavei acoi ẽgüe ndehi vahe chĩhi vahe rese, ẽgüe ndehi chiaveira mbahe tuvichá vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Evocoiyase ndapemboavɨyeise co ɨvɨ pɨpendar pe cuaita guarepochi rese, ahese ndaperecoi chira ɨvave mbahe rese hañeco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iyavei acoi ndapemboavɨye tuprɨise pe cuaita ambuae ava mbahe rãro pɨpe, ¿ava pĩha evocoiyase omondora pe mbahe ité pẽu viña? ");
INSERT INTO gyrNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Iyavei ndipoi chietera ñepei mbiguai omboyeroya vahe ñuvɨrío güerecuar. Esepia, ñepei osaɨsu catura imboyeroyasa pɨpe, ambuae evocoiyase ndoyambotai chira imboyeroya potaẽhɨsa pɨpe. Ẽgüe peye avei ndapeicatui Tũpa mboyeroya guarepochi pota raisa pɨpe” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Aipo ñehesa renduse, fariseo yuvɨrecoi vahe oguarepochi raɨsusa pɨpe ovɨroɨ̃ro yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Evocoiyase aipo ehi fariseo eta upe: “Pe co ava rembiepiave pe recocuer avɨye angahu pe reco viña. Tũpa rumo oicua opacatu pe pɨhañemoñetasa. Esepia, yepe ava rovaque ndoyavɨi avɨye ai vahe pe recocuer viña, Tũpa uve rumo mbahe tẽi eté” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Yɨpɨsuive Moisés porocuaita iyavei Tũpa ñehe mombehusar porombohesa Juan recosa rupive opa. Ichuive tuprɨ ité rumo imombehusa ñehesa avɨye vahe Tũpa mborerecuasa resendar, sese ava iquerẽhɨ catu cũritei aheve yuvɨroique vaherã. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Yavai catura que ñepei Tũpa porocuaita mboavɨyeẽhɨ ãgua co ɨva, ɨvɨ opa vaherã sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Acoi opoi vahe güembireco sui, omendase ambuae cuña rese, ahe oyemboaguasa tẽi vahe. Iyavei acoi omendase cuña omenda vahecuer rese tẽi, oyemboaguasa tẽi vahe avei” ehi Jesús. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Iyavei oime mbɨa mbahe yar, ahe oyemonde turucuar avɨye vahe pɨpe oyemboetei eteanga, iyavei arɨ yacatu oyapo pieta opacatu mbahe rese oyemboetei aisa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oime avei mbɨa iparaɨsu ité vahe Lázaro serer vahe. Ahe mbɨa icaracha atɨ vahe imboguapɨsa ɨvɨve imoi mbahe yar roquendɨpɨve. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Co mbɨa iparaɨsu catu vahe aipo ehi oyeupe, ‘Tomboumi tẽi que güembihu rahɨcuer ovɨapi vahe mesa sui’ ehi mbahe yar upe viña. Aheve mbahe yar reimba cave oyemboya sese, icaracha osere yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Omanose co mbɨa iparaɨsu vahe, ahese Tũpa rembiguai eta ovɨraso yuvɨreco Abraham pɨri ɨvave. Mbahe yar avei omano, opa oñotɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Ahese oso Tũpa ñemoɨrosave. Aheve oparaɨsuse, omahe ɨvate cotɨ, osepia amombrɨ aracahendar Abraham Lázaro reseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Evocoiyase osapucai pĩrata: ‘¡Che ramoi Abraham, che paraɨsuerecomi tẽi eve! Emboumi tẽi Lázaro che ãpecu morohɨsa ãgua ɨve ocuã pɨpe. Esepia, che paraɨsu eteprɨ co tata pĩratagüer pɨpe vitu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Evocoiyase Abraham omboyevɨ aipo ehi chupe: ‘Che rumino, ndemahenduha eipeve nde reco agüer rese nipaneise mbahe ndeu nde recove pɨpe. Lázaro rumo iparaɨsumi tẽi oico’ ehi. ‘Cũritei rumo Lázaro ovɨharete oico cohave, nde evocoiyase nde paraɨsu eipeve eico. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iyavei oime co ɨvɨcuar ipɨcucu vahe rasaẽhɨ ãgua oreu iyavei pẽu no’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ahe mbɨa aipo ehi: ‘Che ramoi Abraham, emondomi tẽi Lázaro ");
INSERT INTO gyrNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","che rɨvrɨ poyandepo vahe upe, chupe iñehe ãgua. Ahe tosecuñaro güecocuer yugüeruẽhɨ ãgua co tecocuer mbahe tẽisave’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham rumo, ‘Vɨreco niha Moisés porocuaita iyavei Tũpa ñehe mombehusar rembicuachiagüer yuvɨreco. ¡Ahe tovɨroya yuvɨreco!’ ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Evocoiyase, ‘Taa, che ramoi Abraham, que omano vahecuer pãhu pendar rumo yuvɨrasose chupe, ahe evocoiyase omoingatura güecocuer yuvɨreco viña’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham rumo aipo ehi chupe: ‘Acoi ndoyapɨsaca potaise Moisés porocuaita rese iyavei ambuae Tũpa ñehe mombehusar remimombehu rese no, ndovɨroyai chiaveira que ava omano vahecuer ocuerayevɨse yuvɨreco’ ehi Abraham ava mbahe yar upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús aipo ehi güemimbohe eta upe: “Oimeño itera poroãtoisa che reroyasar reitɨ ãgua. ¡Ahe imboangaipa ucasar rumo iparaɨsu itera! ");
INSERT INTO gyrNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iyacatu evocoi nungar ava ñapɨchisa ita mbahe mbocuhisa iyesɨho rese para guasu pɨpe imombo ãgua chĩhivahemi nungar mboangaipa uca rãgüer sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Sese peñearo tuprɨ! “Acoi nde mboetasa Tũpa reroyasar oyemboangaipase, pemboaracuara. Omboasɨ pare oyevɨse güecocuer tuprɨ pɨpe, ahese peñerora chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Supi eté acoi que ambuae ava pe amotarẽhɨ vɨtese rumo siete yupagüer ñepei arɨ pɨpe, acoi ouse pẽu siete yupagüer avei, ‘Ẽgüe ndahe iri chira’ ehise, peñero chupe” ehi Jesús güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Co doce tuprɨ apóstol aipo ehi chupe: —Emboumi oreu Tũpa rese ore yeroya catu ãgua —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Evocoiyase yande Yar omboyevɨ chupe: —Supi eté, Tũpa rese pe yeroyasa, yepe ndoyavɨi chira mostaza rãhɨi tahɨmi vahe viña, co ɨvɨra tuvicha vahe upe rumo, ‘Eyeapoho ave sui. Eso eñeñetɨ para guasu avɨterve’ peyese Tũpa rese pe yeroyasa pɨpe, ahe evocoiyase pe mboyeroya itera —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Inungar que pe pãhu pendar vɨrecora güembiguai oporavɨquɨ vahe ɨvɨ mboyere cove, anise que guaca rãro yuvɨ rupi viña; ichui iyevɨse, ¿‘Eique, eguapɨ terecaru’ ehira pĩha serecuar chupe? ");
INSERT INTO gyrNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aní eté, ahe rumo aipo ehiñora chupe: ‘Emoingatu voi mbahe che tohu, che toɨhurã avei. Ipare nde erecarura, ereɨhura’ ehira chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","‘Avɨye ndeu’ ndehi chietera icuai pare chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ẽgüe peye avei mbiguai nungar pe opacatu Tũpa pe cuaitarã ombou vahe mboavɨyere, ‘Yande niha mbiguai tẽi yaico. Esepia, yande cuaita mboavɨyesar tẽi yaico’ peyeñora” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Osose Jesús Jerusalén ve, oguata ɨvɨ Samaria iyavei ɨvɨ Galilea rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Oyepotase tecuamive oso, ahese yuvɨnose diez ava lepra pɨpe imbaheasɨ vahe yuvɨreco chupe. Amombrɨve rumo opɨtaño yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Osapucai yuvɨreco chupe aipo ehi: —¡Jesús, Porombohesar, ore paraɨsuerecomi tẽi eve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sepiase aipo ehi lepra vɨreco vahe upe: —Peyevɨ, peso, tapeyemboyecua pahi eta yuvɨrecoi vahe upe —ehi. Oyevɨse rumo yuvɨraso, opa ocuera tuprɨ ombaherasɨsa sui yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","16","Evocoiyase ñepei ipãhu pendar, Samaria pendar, osepiase ocuerasa, oyevɨ chupe osapucai pĩrata Tũpa upe imboeteisave. Oñenopɨha oso sovai, oyaɨvɨ, “Avɨye ndeu” ehi Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Evocoiyase ahe aipo ehi: —¿Ndahei vo acoi diez tuprɨ opa ocuera ombaherasɨsa sui yuvɨreco? ¿Aique que ru ambuae nueve yuvɨrecoi vahe? ");
INSERT INTO gyrNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¡Co mbɨa ambuae ɨvɨ pendar güeraño rumo oyevɨ ‘avɨye ndeu’ ohesave Tũpa uve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Evocoiyase aipo ehi ahe mbɨa upe: —Eñarapuha, eso tuprɨño. Nde poreroyasa pɨpe niha erecuera eico —ehi Jesús chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ñepei arɨ pɨpe fariseo eta, “¿Marase vo aipo oura Tũpa omborerecuasa pɨpe mbahe moingatu ãgua?” ehi Jesús upe yuvɨreco. Ahe omboyevɨ chupe: —Tũpa mborerecuasa ndahei acoi yasepia vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Co secoi, aheve secoi’ ndapeyei chira chupe. Esepia, ahe oicove ité pe pãhuve —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ipare aipo ehi güemimbohe eta upe: —Oimera arɨ pe peipota tẽira aico vaherã pe pɨri que ñepei arɨ rupi che, Ava Rɨquehɨr, che recosa pɨpe; ndache repiai chira rumo peye. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iyavei ava, ‘Co secoi, aheve aipo secoi’ ehi tẽira yuvɨreco cheu. Ndapesaquɨcue moñai chira rumo. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Esepia, inungar acoi overa vahe osesape guasu ɨva rese ocua yepi, ẽgüe ahera che, Ava Rɨquehɨr, vitu arɨ osupitɨse che yevɨ ãgua curi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Yɨpɨndar rumo co ɨvɨ pɨpe che paraɨsu ranera ava cũriteindar mara-mara tẽi che rerecose yuvɨreco che repia potaẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Inungar ava Noé recose yuvɨrecoi aracahe, ẽgüe ehi tuprɨ aveira che, Ava Rɨquehɨr, yevɨ ãgua renonde. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Esepia, ocaru, oɨhu, omendaño avei yuvɨreco. Oyepotase rumo arɨ ipapaprɨ amarusu vɨapi ãgua, ahese Noé yuvɨroique arca pɨpe. Ambuae ava rumo opa ocañɨ tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ẽgüe ehi avei aracahe Lot recose, ava ocaru tẽi, oɨhu tẽi, vɨrocua tẽi mbahe omahera yuvɨreco iyavei mbahe mondosar tẽi, mbahe tɨ̃sar tẽi, oɨ aposar tẽi avei yuvɨrecoi oyapɨsacaẽhɨsa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Osẽse rumo Lot tecua Sodoma sui, avɨyeteramo tẽi ovɨapi tata amar nungar ɨva sui. Opa tuprɨ oyuca ava rehɨi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ẽgüe ahe aveira avɨyeteramo tẽi che, Ava Rɨquehɨr, ayemboyecuara curi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ahe arɨ pɨpe acoi ava güẽta harɨve secoi vahe, ahe toique iri eme güẽta pɨpe ombahe renose. Iyavei ava que rupi tẽi secoi vahe, toyevɨ iri eme güẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Sese peyemomahenduha co aracahendar Lot rembireco rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Opacatu güecocuer osaɨsu vahe, ahe ocañɨ tẽira. Iyavei setecuer tẽi ocañɨ vahe, ahe rumo oñepɨsɨrora” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ahe pɨ̃tu pɨpe oimera que ñuvɨrío ava vupave yuvɨroque vahe yugüeru: ñepei acoi che reroyasar serasosara, ambuae rumo opɨtara. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ahese avei ñuvɨrío cuña ohɨchora yuvɨreco: ñepei serasosara, indugüer rumo opɨtara. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ẽgüe ehi aveira ñuvɨrío ava amombrɨ güecua sui yuvɨrecoi vahe: ñepei serasosara, indugüer rumo opɨtara” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Aipo ñehesa renduse, oporandu yuvɨreco chupe: —Ore Yar, ¿que vo aipo ẽgüe ehira mbahe curi? —ehi. Ahe evocoiyase, —Mbahe rehõgüer reimesave uruvu oñemonuha atɨra yuvɨreco —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús omboyoya ambuae ava recocuer sui querẽhɨsa pɨpe yerureño ãgua arɨ yacatu rupi ");
INSERT INTO gyrNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","aipo ehi: “Ñepei tecuave oime mbɨa mborerecuar mbahe moingatusar ndosɨquɨyei vahe Tũpa sui, ambuae ava sui avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ahe tecuave avei oime cuña imer mano vahecuer. Ahe oso co mborerecuar rẽtave, ‘Oime ava oyapo mbahe tẽi eté cheu, tomboepɨ cheu’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yɨpɨndar rumo noipɨtɨvɨi potai. Coiye catu rumo cuña ombopɨhavɨ̃racua tẽise, ipɨhañemoñeta iri: ‘Yepe che ndasɨquɨyei vahe Tũpa sui, ava sui avei ndasɨquɨyei vahe ité, ");
INSERT INTO gyrNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","amoingatuñora rumo mbahe co cuña che mañeco tẽisar upe. Ayapoñora semimbotar cheu iyu pɨhiẽhɨ ãgua’ ehi opɨhañemoñetasave” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ipare yande Yar aipo ehi: “Peyapɨsaca aipo mborerecuar naporai vahe ñehe rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tũpa avei niha omoingatura mbahe güembiporavo oyeupe yeruresar arɨ, pɨ̃tu rupindar upe yepi. Nosaro tẽi chiranera opɨ̃tɨvɨi ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Supi eté Tũpa omoingatu voira mbahe avɨye vahe yande porandusa pɨpe yandeu. Co rumo che, Ava Rɨquehɨr, ayevɨse co ɨvɨ pɨpe vitu, oimera ava movɨromi tẽi oyeroya vɨte vahe che rese yuvɨreco” ehi Jesús. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ichui Jesús oporombohe iri ambuae ava recocuer rese. Esepia, oime amove ava avɨye ai angahu secoi oyeupe viña, iharɨve rumo vɨroɨ̃ro ambuae ava. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ñuvɨrío ava yuvɨraso tũparove oyeroquɨ. Ñepei ava fariseo, ambuae evocoiyase ava sui guarepochi rerocuasar. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Evocoiyase fariseo oso tenonde ava rembiepiave oyeroquɨ aipo ehi: ‘Tũpa, avɨye ndeu, che ndahei ambuae ava nungar che recocuer; ndachemondai vahe, ndachereco rai vahe, ndacheaguasa-guasa tẽi vahe. Iyavei ndahei eté che recocuer co mbɨa ava sui guarepochi rerocuasar nungar tẽi aico no. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Iyavei ñuvɨrío yupagüer ñepei semana pɨpe ayecuacu ité nde recocuer rese, iyavei ñepei-pei cien guarepochi che poravɨquɨ reprɨ aipɨsɨ vahe sui amboyaho diez che porerecosa ndeu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ava sui guarepochi rerocuasar rumo opɨtaño amombrɨ ichui. Aheve nomahei ɨva rese oyeroquɨ ãgua oangaipa mboasɨsa pɨpe. Oyepochihanupa-nupa aipo ehi: ‘¡Tũpa, che paraɨsuerecomi eve, che angaipa viyar aico!’ ehi oyeroquɨ” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Sese aipo ahe pẽu: co mbɨa ava sui guarepochi rerocuasar opa oipɨsɨ ñerosa Tũpa suindar güẽtave oso. Fariseo rumo aní eté. Esepia niha, opacatu acoi oyemboɨvate ai vahe, opara seco reroyɨsa. Acoi ava seco mbegüe vahe rumo seco mboɨvate catusara curi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iyavei chĩhivahe güeru Jesús uve yuvɨreco sovasapɨrã. Evocoiyase semimbohe osepiase yuvɨreco, “¿Mahera vo peruño tẽi chĩhivahe?” ehi opɨhavɨ̃racuasa pɨpe serusar upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesús rumo aipo ehi: —¡Mahera ndapeipotai iyu ãgua! Toyugüeruño chĩhivahe cheu. Esepia, co chĩhivahe nungar ava yuvɨroiquera che Ru Tũpa povrɨve. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Supi eté acoi ndoipɨsɨi vahe che Ru Tũpa mborerecuasa chĩhivahe nungar yuvɨreco, ahe evocoiyase ndoyuvɨroiquei chietera ipɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ñepei mbɨa mborerecuar oporandu Jesús upe: —Porombohesar avɨye vahe, ¿mbahe vo ayapora tecovesa apɨrẽhɨ vahe rereco ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús evocoiyase aipo ehi ahe mbɨa upe: —¿Mahera vo, “Avɨye vahe” ere cheu? Oime rumo ñepei avɨye vahe ité, ahe Tũpa secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ereicua niha co porocuaita aipo ehi vahe: ‘Nandeaguasai chira, ndereporoyucai chira, nandemondai chira, nanderemirai chira ambuae ava rese, eremboyeroyara nde ru, nde sɨ avei’ ehi vahe —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ahe mbɨa rumo, —Che aipo nungar opacatu amboavɨye ité che chĩhivahemi suive —ehiño chupe ");
INSERT INTO gyrNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aipo ihese rumo, —Ipane vɨte mbahe ndeu —ehi—. Emondopa rane nde mbahe, ahe seprɨ evocoiyase eremondora ava iparaɨsu vahe upe. Ichui ererecora mbahe avɨye vahe ɨvave cute. Ipare ereguatara che rupi —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Aipo oyeupe hese rumo, ahe mbɨa ndoyembovɨhai tẽi. Esepia niha, mbahe yar ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Sese omahe aipo ehi: —¡Yavai eté rumo ava mbahe yar reique ãgua che Ru Tũpa mborerecuasave! —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yavai rai camello upe yucuar rupi seique ãgua; ava imbahe eta vahe upe rumo yavai catu che Ru mborerecuasave seique ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","—¿Ava angahu pĩha evocoiyase oñepɨsɨrora yuvɨreco viña? —ehi sendusar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Evocoiyase ahe chupe aipo ehi: —Ava tẽi upe mbahe yavai eté, Tũpa upe rumo ndayavaimi eté —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Evocoiyase Pedro aipo ehi: —Che Yar, ore rumo opa oroseya ore mbahe nde rupi ore guata ãgua —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Evocoiyase aipo ehi güemimbohe upe: —Supi eté acoi oseya vahe que güẽta, güembireco, vɨquehɨr, vɨvrɨ, oyesupa, que guahɨr Tũpa mborerecuasa rese, ");
INSERT INTO gyrNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ahe setá iteanga catu oipɨsɨra mbahe avɨye catu vahe co ɨvɨ pɨpe oseya vahe sui. Ipare rumo tecua ambuaeve oipɨsɨ aveira tecovesa apɨrẽhɨ vahe curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Evocoiyase yande Yar opa vɨraso co cotɨmi doce güemimbohe. Aheve aipo ehi: “Cũritei yasora tecua Jerusalén ve yaico, aheve omboavɨyera co Tũpa ñehe mombehusar rembicuachiagüer co che, Ava Rɨquehɨr, resendar ñehesa. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Che imondoprɨ aicora ndahei vahe yande mu upe mara-mara tẽi che rereco ãgua. Che reroɨ̃ro-ɨ̃rora iyavei ondɨvɨ-ndɨvɨra yuvɨreco che rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","“Iyavei che nupa-nupara. Ipare che yucara yuvɨreco. Imombosapɨsa arɨ pɨpe rumo acuerayevɨra omano vahe pãhu sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Semimbohe rumo ndosenducuai eté iñehe yuvɨreco. Esepia niha, yavai eté senducua ãgua yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Evocoiyase Jesús ovɨrovɨse tecua Jericó oso, aheve mbɨa ndasesapɨsoi vahe oguapɨ oĩ perɨ popɨve porerecosa oyeupe mondo ãgua rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Osenduse ahe ndasesapɨsoi vahe ava rehɨi pɨambu, ahese, “¿Mbahe vo pẽu?” ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ahe evocoiyase, “Jesús, Nazaret pendar, ocuara co rupi” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Evocoiyase ahe güendapeve oñehe pĩrata: —¡Jesús, David suindar, che paraɨsuerecomi tẽi eve! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Evocoiyase ava tenonde oguata vahe oyaca-yacaño, “Quiriri” ehi yuvɨreco chupe. Ahe rumo, —¡David suindar, che paraɨsuerecomi tẽi eve! —ehi pĩrataño ité chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Evocoiyase Jesús opɨtase aheve, oyocuai ava seru ãgua. Ovɨrovɨse seru yuvɨreco, aipo ehi ndasesapɨsoi vahe upe: ");
INSERT INTO gyrNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Mbahe vo ereipota ayapo vaherã ndeu? —ehi. —Che Yar, che mbosarecomi tẽira eve viña —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—¡Esareco, erecuera niha! Esepia, ereyeroya ité che rese —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ahe ramoseve ndasesapɨsoi vahe, osareco tuprɨ ité; osoño ité Jesús rupi imboeteisave. Opacatu ava osepia vahe avei omboetei Tũpa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ichui Jesús oique tecua Jericó pɨpe oguata oico. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Aheve mbɨa mbahe yar Zaqueo serer vahe secoi. Ahe ava sui guarepochi rerocuasar rerecuar. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Osepia pota tẽi Jesús ‘taicua ité’ oya viña. Ndoicatui rumo opucuẽhɨse ava rehɨi pãhuve sepia ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Evocoiyase ahe oña tenonde oso ‘tasepia ité’ oyapave, oyeupi ɨvɨra rese ɨvate oĩ senonera. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Evocoiyase oyepotase, omahe Zaqueo rese ɨvate chinise, aipo ehi chupe: —Zaqueo, egüeyɨ poyava. Esepia, asora nde rẽtave nde pɨri —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Aipo oyeupe he ramoseve, Zaqueo ogüeyɨ voi vorɨvetesa pɨpe oipɨsɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sepiase rumo opacatu ava, “Yangaipa guasu vahe rẽtave tẽi oso” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Evocoiyase Zaqueo opũha aipo ehi chupe: —Che Yar, esendu rane, amboyaho tuprɨra che mbahe eta ava iparaɨsu vahe upe; mbahe añomi vahecuer avei, ayapɨrasa catu-catura irungatu rupi imboyevɨ ãgua —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","—Co pɨpe Tũpa oipɨ̃sɨro ité co mbɨa. Esepia, ahe niha Abraham suindar avei secoi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Esepia, che, Ava Rɨquehɨr, ayu co ɨvɨ pɨpe ava ocañɨ tẽi vahe pɨ̃sɨro ãgua —ehi Jesús Zaqueo upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Aipo ñehesa rendu vɨteseve, Jesús oporombohe ambuae tecocuer resendar rese. Esepia, vɨrovɨ Jerusalén, “Oyepota voi etera revo Tũpa mborerecuasa” ehi ava yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ahe rumo aipo ehi ava upe imbohe: “Oime mbɨa imboyeroyaprɨ, ahe senoiprɨ oso vaherã amombrɨ oɨvɨ pendareta rerecuarã oyevɨse. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Oso ãgua renonde oichohopa uca diez tuprɨ güembiguai. Ahese opa omondo ñepei-pei upe guarepochi sepɨrusu vahe, aipo ehi chupe: ‘Peporavɨquɨ co guarepochi rese imboeta ãgua che yevɨse nara’ ehi. Ipare oso. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Setá ava rumo secua pendar saquɨcuei tẽi vɨroɨ̃ro yuvɨreco. Sese omondo movɨro ava ‘tomombehu: Ore rumo ndoroipotai ore rerecuarã secoi ãgua, tehi yuvɨreco’ oya viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ahe rumo mborerecuar guasu güecosa pɨpe oyevɨ ou cute. Opa uca oichoho oguarepochi pɨsɨsarer ‘¿mbovɨ-mbovɨ pĩha oipɨsɨ oyacatu yuvɨreco?’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Evocoiyase yɨpɨndar mbɨa guarepochi oipɨsɨ vahe ou voi chupe, ‘Che rerecuar, nde guarepochi oyemboeta diez rupi cheu’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Evocoiyase mborerecuar guasu omboyevɨ chupe: ‘Mbiguai avɨye vahe ereico, nde cuaita co nde poravɨquɨsa chĩhimi vahe eremboavɨye ité. Sese ereicora diez tecua guasu pendar rese hañeco ãgua’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ipare voi ambuae ou chupe, ‘Che rerecuar, nde guarepochi oyemboeta cinco rupi cheu’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Aipo ehi tuprɨ avei ahe chupe: ‘Nde evocoiyase ereicora cinco tecua pendar rese hañeco ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ipare voi ambuae ou chupe, ‘Che rerecuar, ndo co nde guarepochi aipoqueño turucuarmi pɨpe sereco. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Esepia, che asɨquɨye nde sui. Nderecatẽhɨ mete ai vahe mbahe rese. Ambuae ava poravɨquɨ sui tẽi iyavei acoi ndahei vahe mbahe nde remitɨ, ichui tẽi avei ereipɨsɨ mbahe ndeyeupe nara yepi’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Evocoiyase mborerecuar guasu aipo ehi chupe: ‘Nde mbiguai ndaseco põrai vahe ereico. Nde ñehe sui aicuara nde recocuer. Ereicuase ẽgüe che hesa viña, ");
INSERT INTO gyrNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","evocoiyase, ¿mahera ru ndereyapocatui che guarepochi guarepochi apocatusave che yevɨse voi senose ãgua cheu imboyevɨ catumi ãgua viña?’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Evocoiyase, ‘Perocua guarepochi ichui. Pemondora acoi diez rupi guarepochi omboeta vahe upe’ ehi vupindar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Supindar rumo aipo ehi: ‘Ore rerecuar, ovɨreco rumo evocoi diez tuprɨ avei iharɨve guarepochi’ ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Evocoiyase mborerecuar, ‘Co rumo supi eté vahe: acoi ovɨreco vahe, imondosara setá catu chupe; acoi ndovɨrecoi vahe setá mbahe, ichui serocuasara’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","‘Acoi ava che amotarẽhɨmbar, ndache potai vahe mborerecuarã yuvɨreco, ahe opara peru cohave che rovai yucapa ãgua’ ehi” ehi Jesús ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesús aipo ohe pare, oguata vɨte oso Jerusalén cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Evocoiyase coiye catu tecua Betfagé iyavei Betania rerovɨcave, ɨvɨtrɨ Olivo ɨ̃pɨimi, aheve omondo ñuvɨrío güemimbohe ");
INSERT INTO gyrNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","aipo ehi chupe: —Peso co tecuamive, yande rovaindarve. Peyepotase aheve, pesepiara guaricu ñapɨchimbrɨ imoha ava ndoyeupi vɨtei vahe yuvɨreco sese. Ahe peyorañora seru. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Acoi, ‘¿Mahera vo peyora?’ ehise que ava pẽu, ‘Yar oiporu pota’ peyeñora chupe —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Evocoiyase semimbohe yuvɨraso, semimombehu rupi tuprɨ ité osepia mbahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Evocoiyase oyorase guaricu, —¿Mahera vo peyora ore reimba? —ehi iyar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Yar oiporu pota —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ipare vɨraso Jesús upe yuvɨreco, oicupeao oyeaosa pɨpe guaricu yuvɨreco chupe. Ipare omboyeupi sese oso ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Oyeupise oso guaricu harɨve, oipɨpira ava oturucuar perɨ rupi senonera imboetei guasusave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ovɨrovɨse ɨvɨtrɨ Olivo sui ogüeyɨ ãgua oso, opacatu ava seroyasar supi oguata vahe omboɨpɨ osapucai yuvɨreco vorɨvetesave mbahe poromondɨisa sembiapogüer rese Tũpa upe ");
INSERT INTO gyrNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","aipo ehi yuvɨreco: —¡Sovasaprɨ secoi mborerecuar guasu ou vahe yande Yar rer pɨpe! ¡Mbahe tuprɨ toime ɨvave iyavei imboeteiprɨ Tũpa tasecoi! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Evocoiyase amove fariseo yuvɨrecoi vahe supi aipo ehi chupe: —Porombohesar, eñehe nde rupi oguata vahe upe imonguiriri ãgua —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Evocoiyase aipo ehi: —Supi eté amombehu pẽu: co ava iquiririse yuvɨreco, ita rumo evocoiyase osapucai pĩratara che mboeteisave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Oyepota senimise tecua Jerusalén ve, ahe tecua repiase, oyaseho sese ");
INSERT INTO gyrNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","aipo ehi: “¡Pesenducuara tarahu co co arɨ pɨpe teco tuprɨsa amondo pota vahe pẽu viña, cũritei rumo ocañɨ tuprɨño pe sui, ndapeicatui eté sepia!” ehi oyaseho. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Oimera rumo arɨ imombehuprɨ naporai vahe pẽu curi. Pe amotarẽhɨmbar oñachi irira pe recua. Ipare oyere tuprɨra yuvɨreco pe rese pẽu ovava ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Iyavei yuvɨroiquera pe recua pɨpe, opara pe rẽta omonduru yuvɨreco, pe yuca aveira yuvɨreco. Ndipoi chietera ita que ñepei oya vahe ambuae rese. Esepia, ndapeicuai eté Tũpa ouse pẽu pe pɨ̃sɨro ãgua” ehi Jerusalén pendar rese oyaseho. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ichui Jesús oique judío tũparo guasu pɨpe. Aheve omboɨpɨ ava mbahe mondosar mombopa tuprɨ ocarve oico ");
INSERT INTO gyrNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","aipo ehi: —Icuachiaprɨ aracahendar pɨpe aipo ehi: ‘Che rẽta yeruresa rẽtarã’ ehi. Pe rumo, imonda rai vahe rẽta nungar tẽi pereco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ichui ahe tũparo guasu pɨpe arɨ yacatu oporombohe oico. Aheve avei rumo pahi eta rerecuar yuvɨrecoi vahe, Moisés porocuaita rese oporombohe vahe iyavei tecua rerecuar guasu yuvɨrecoi vahe, ‘¿Mara yahera pĩha yuca uca ãgua viña?’ ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ndoicatui rumo yuvɨreco. Esepia, ava rehɨi oyapɨsaca iporombohesa rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ñepei arɨ Jesús judío tũparo guasu pɨpe güecose, ombohe ava eta, omombehu ñehesa pɨ̃sɨrosa resendar oico. Ahese yugüeru pahi eta rerecuar guasu yuvɨreco iyavei Moisés porocuaita rese oporombohe vahe, ava rerecuar guasu yuvɨrecoi vahe avei ");
INSERT INTO gyrNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","aipo ehi: —¿Ava nde cuaita pɨpe vo ereyapo co nungar eico? ¿Ava vo ombou nde mborerecuarã? —ehi ahe ava yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ahe omboyevɨ chupe: —Che avei aporandura mbahe rese pẽu. Pemboyevɨra cheu —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ava vo Juan ombou ava ãpiramo ãgua: Tũpa pĩha, ava tẽi tie? —ehi ahe ava yuvɨrecoi vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ahese, “¿Mara yahera píha?” ehi-ehi tẽi oyeupe yuvɨreco. “ ‘Tũpa’ yahese chupe, ‘¿Mahera ru ndaperoyai?’ ehira yandeu. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Anise, ‘Ava tẽi remimbou’ yahese chupe, opacatu seroyasar evocoiyase yande api-apira ita pɨpe yuvɨreco. Esepia, ava, ‘Juan omombehu vahe ñehesa Tũpa suindar’ ehi eté yuvɨreco chupe” ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Evocoiyase ahe ava, “Ndoroicuai rumo Juan mbousar, que sui oporoãpiramo oico” ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sese aipo ehi ahe ava upe: —Sese che avei, ‘Ahe iporocuaita pɨpe co mbahe ayapo’ ndahei chietera pẽu —ehi mborerecuar guasu upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ipare Jesús oñehe ava eta upe ambuae ava recocuer rese aipo ehi: “Oime mbɨa oñotɨ vahe uva oɨvɨ pɨpe. Ipare oseya oɨvɨ ava oporavɨquɨ vahe upe iporu ãgua. Ichui oso pucu que amombrɨ vahesa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Evocoiyase oyepotase arɨ uva pohosa, ahese omondo ñepei güembiguai oporavɨquɨ vahe upe imboporandu ‘tomboumi uva pohoprɨ cheundar cheu cute’ oyapave viña. Ahe rumo oinupa-nupaño imboyevɨ tuprɨ tẽi yuvɨreco serecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ipare ambuae güembiguai omondo iri no. Ahe oinupa-nupaño, iñehe mara-mara tẽi avei ipogüer tẽi imboyevɨ imondo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ichui omondo iri tẽi imombosapɨsa rese ambuae güembiguai no. Ahe oyapicha-pichaño imosẽ imondo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Coiye mitɨ yar aipo ehi: ‘¿Mara ahera pĩha? Amondora revo che rahɨr, che rembiaɨsu. Ahe tie revo, osepiase, omboyeroyara yuvɨreco’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Evocoiyase ahe ava tahɨr repiase, ‘Co aipo oipɨsɨra vu mbahe. Yayucaño. Yandeu nara pãve topɨta co ɨvɨ’ ehi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Evocoiyase ovɨnose mitɨ pãhu sui, oyuca ité yuvɨreco. “¿Mbahe vo evocoiyase oyapora ɨvɨ yar ahe ava naporai vahe upe? ");
INSERT INTO gyrNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Oura evocoiyase ahe ava mocañɨpa ãgua, omondora ambuae ava upe oɨvɨ rese oporavɨquɨ vaherã” ehi. Aipo renduse, —¡Egüe tehi eme! —ehi ava yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Omahese rumo ahe ava rese aipo ehi: —¿Mara oya vo co aipo ehi icuachiaprɨ aracahendar pɨpe?: ‘Co ita oɨ aposar opaño omombo yuvɨreco, ahe ita rumo avɨye catu vahe oɨ movɨracua tuprɨ ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Acoi que ovɨapi vahe evocoi ita harɨve, opa tẽira ahe ae oyemomara. Iyavei ovɨapise que ava harɨve, opa tuprɨ aveira omocañɨ —ehi Jesús judío rerecuareta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pahi eta rerecuar guasu iyavei oporombohe vahe Moisés porocuaita rese, iñehe vɨteseve, oipɨsɨ pota tẽi Jesús yuvɨreco. Esepia, osenducua ité oyesendar iporombohesa yuvɨreco. Osɨquɨyeño rumo ava rehɨi sui yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ahe judío rerecuar evocoiyase omondo ava ndaseco asɨimi angahu vahe ivɨro, chupe iñehe ãgua ‘toyavɨ angahu oñehe’ oya vɨraso vaherã mborerecuar Pilato rovai. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ahe evocoiyase, —Porombohesar, ore oroicua nde ñehe iyavei nde porombohesa supi eté vahe. Iyavei nderemboyoavɨratɨi vahe nde ñehe yepi. Nde rumo ereporombohe mbahe supi tuprɨ vahe Tũpa recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Avɨyera pĩha yamondo guarepochi Roma pendar mborerecuar ɨvate catu vahe upe viña? ¿Aní tie? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Opa rumo oicua iñehe porombopasa tẽi. Sese, ");
INSERT INTO gyrNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Pemboyecua ru ñepei guarepochi cheu. ¿Ava rahanga vo vɨreco; ava rer icuachiaprɨ vo co sese? —ehi ahe ava upe. —Roma pendar mborerecuar guasu —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Taa, pemondo ru mborerecuar uve chupendar, iyavei Tũpa upendar pemondoño ité Tũpa upe —ehi ahe ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndoyavɨ uca catui eté iñehe ava rovaque ipɨsɨ ãgua yuvɨreco. Ahe rumo oyeupe imboyevɨse, iquiriripa tuprɨño oyepɨhamondɨisa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ipare saduceo, ahe “ndipoi eté cuerayevɨsa” ehi vahe, yugüeru Jesús upe. Oporandu tẽi angahu yuvɨreco chupe: ");
INSERT INTO gyrNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Porombohesar, Moisés niha oseya güembicuachiagüer yandeu aipo ehi: ‘Que cuimbahe omenda vahe omanose guahɨẽhɨseve, tɨvrɨ evocoiyase omendara sembirecocuer rese. Ahe vɨquehɨr omano vahecuer upe nara tahɨra oico’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Evocoiyase oime siete tuprɨ oyesuindar pãve yuvɨrecoi vahe. Yɨpɨndar vahe omenda. Ipare omanoño guahɨẽhɨseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ichui tɨvrɨ omenda sese. Ahe omanoño avei guahɨẽhɨseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ipare imombosapɨsa tɨvrɨ omenda iri tẽi sese. Ẽgüe ehi tuprɨño avei chupe. Ambuae ichuindar ẽgüe ehi tuprɨ avei omanopa yuvɨreco guahɨẽhɨseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Coiye cuña avei omano cute. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Evocoiyase opase ocuerayevɨ yuvɨreco, ¿uma rembireco itera pĩha omendase opacatu siete yuvɨrecoi vahe rese? —ehi saduceo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ahe rumo omboyevɨ chupe: —Co ɨvɨ pɨpe cuimbahe iyavei cuña omenda vahe yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ocuerayevɨ pare oicatu vahe ɨvave yuvɨroique vaherã, chupe ndipo iri chira mendasa. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iyavei nomanoi chietera aheve. Esepia, yuvɨrecoira Tũpa rahɨr, Tũpa rembiguai eta ɨva pendar nungar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés rembicuachía agüer pɨpe niha caha pãhu sendɨ vahe resendar oicua uca cuerayevɨsa yandeu. Aheve aipo ehi: “Ahe niha yande ramoi aracahendar Abraham, Isaac, Jacob Tũpa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Tũpa ndahei omano vahe Tũpa! ¡Ahe rumo oicove vahe ité Tũpa secoi! Esepia, chupe opacatu yuvɨrecove vahe —ehi saduceo upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Evocoiyase movɨro Moisés porocuaita rese oporombohe vahe aipo ehi: —Supi eté aipo ere, Porombohesar —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Sese niquerẽhɨ iri eté mbahe rese oporandu ãgua yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Evocoiyase Jesús aipo ehi ahe ava upe: —¿Mahera ru, “Poropɨ̃sɨrosar David suindar ité” ehi yuvɨreco? ");
INSERT INTO gyrNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David teieté niha aipo ehi güembicuachía pɨpe: ‘Yar aipo ehi che Yar upe: Eguapɨ che acato cotɨ ");
INSERT INTO gyrNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","acoi che amondose voi eté nde amotarẽhɨmbar ñenopɨha ãgua nde povrɨve yuvɨreco’ ehi David aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Mahera ru, “Poropɨ̃sɨrosar David suindar secoira” peye? David teieté, “Che Yar” ehise chupe —ehi Jesús ahe ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Opacatu ava oñehe rendu vɨteseve, Jesús aipo ehi güemimbohe upe: ");
INSERT INTO gyrNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Peicua catu co Moisés porocuaita rese oporombohe vahe sui. Esepia, ahe oturucuar ipucu vahe rese oguata pota rai yuvɨreco yepi, iyavei oipota oyeupe ‘avɨrave’ apo ãgua ocar rupi omboeteisa pɨpe yuvɨreco. Oseca avei tenda porañete catu vahe güenara otũparo pɨpe, carusave avei oseca tenda avɨye catu vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iyavei vɨrocua-rocuaño tẽi cuña imer mano vahecuer rẽta ichui. Oarondaguã tẽi avei oyeroquɨ pucu-pucu yuvɨreco. Ahe rumo oipɨsɨra Tũpa ñemoɨrosa ipĩrata catu vahe yuvɨreco curi” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ipare Jesús osepia ava imbahe eta vahe omondose oporerecosa guarepochi rɨru pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aheve avei cuña imer mano vahecuer iparaɨsu vahe, omondo ñuvɨriomi guarepochi oporerecosa. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Evocoiyase Jesús aipo ehi: —Supi eté co cuña iparaɨsu vahe omondo catu oporerecosa opacatu mbahe yar sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Esepia, ava imbahe eta vahe, oguarepochi rumbɨrer tẽi omondo oporerecosa Tũpa upe yuvɨreco. Co cuña rumo oparaɨsusa pɨpe vɨrecomi vahe guarepochi oyeupe, opacatu ité omondo oporereco ãgua Tũpa upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Evocoiyase amove semimbohe oñehe yuvɨreco tũparo guasu recocuer rese: “Co tũparo niha icatuprɨ vahe, ita mopuhaprɨ, porerecosa sui opacatu mbahe icatuprɨ ipɨpe” ehi yuvɨreco. Jesús rumo aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Oimera arɨ opacatu co mbahe cũritei pesepia vahe pɨpe ndipoi chietera que ñepei ita oyeha vɨte vahe; opacatu ité imondurusara curi —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Evocoiyase semimbohe eta oporandu yuvɨreco chupe: —Ore mbohesar, ¿mbahese vo aipo mbahe yavɨyera? ¿Mbahe poromondɨisa rese rane vo icuasara curi? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Evocoiyase aipo ehi güemimbohe eta upe: “Peicua catu, peyembopa ucai rene catu. Esepia, setá ava yugüerura, ‘Che niha Poropɨ̃sɨrosar aico, cũritei osupitɨ arɨ imombehuprɨ yandeu’ ehi tẽira yuvɨreco. Ndaperoyai chira rumo ava aipo ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Acoi peyanduse vavasa iyavei tecua pɨpendar oyeupe vavase, ndapeyembosɨquɨyei chira rumo serãcua anduse ichui. Evocoi nungar rane ité niha oimera. Ndehi vɨtei chira rumo arɨ cañɨ” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Ñepei ɨvɨ pɨpendar ovavara ambuae ɨvɨ pɨpendar rese oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ahese avei oimera ɨvɨ rɨrɨi tuvichá vahe, tɨavor, mbaherasɨsa opacatu-catu tẽi tecua rupi. Iyavei pesepiara ɨva rese mbahe pe mbosɨquɨye vahe, poromondɨisa tuvichá vahe avei curi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Co mbahe-mbahe tẽi reime renondeve rumo pe pɨsɨra yuvɨreco che recocuer sui mara-mara tẽi pe rereco ãgua. Pe reraso aveira pẽu porandu ãgua tũparove, pe roquenda aveira, iyavei pe rerasora mborerecuar rovai, mborerecuar ɨvate catu vahe rovai avei yuvɨreco che recocuer sui tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ipɨpe pemombehura che recocuer chupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","‘Aipo ahera añehe’ ndapeyei chira pepɨhañemoñeta rereco pe yeepɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Esepia, che amondora che mbahecuasa pe ñehe ãgua. Ndoicatui chietera evocoiyase pe amotarẽhɨmbar imboyevɨ yuvɨreco pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pe amotarẽhɨra rumo pe yesupa, pe mu, pe rɨvrɨ, pe rɨquehɨr, pe mborɨpar avei. Iyavei oyucara amove pe pãhu pendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Opacatu ava ndape ambotai chira che recocuer sui tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nocañɨi chietera rumo que ñepei pe ha pe ãca sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Peyemovɨracua evocoi nungar mbahe upe pe ñepɨsɨro ãgua! ");
INSERT INTO gyrNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Iyavei pesepiase ava Jerusalén rese sundao oyere tuprɨse, peicuara evocoiyase mbahe-mbahe tẽi reime ãgua yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Evocoiyase Judea ve yuvɨrecoi vahe toñemipa poyava voi ɨvɨtrɨ rese yuvɨreco ichui; tecua Jerusalén pɨpe yuvɨrecoi vahe, ahe toyuvɨnose poyava avei ichui. Iyavei acoi que rupi yuvɨrecoi vahe, ahe toyevɨ iri eme yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Esepia, ahe arɨ oimera Tũpa ñemoɨrosa. Ahe omboavɨyera icuachiaprɨ aracahendar pɨpe imombehuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Iparaɨsu itera ahe arɨ pɨpe cuña ipuruha vahe, imembɨ pĩtani vahe avei! Esepia, oimera tecoasɨsa co ɨvɨ pɨpendar upe, ñemoɨrosa tuvichá vahe ahe ava recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iyavei quɨse pucu pɨpe setá ava omanora yuvɨreco iyavei ambuae setá ava ipɨsɨprɨ serasosara ambuae ɨvɨ rese amombrɨsave. Iyavei ambuae ɨvɨ pɨpendar ava ndahei vahe judío yuvɨrecoi vahe oiporu itera tecua Jerusalén acoi osupitɨse voi eté arɨ imombehuprɨ yuvɨreco chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ɨva rese iporẽhɨra poromondɨisa, arɨ rese, yasɨ rese, yasɨtata rese; iyavei ɨvɨ pɨpe, opacatú tecua rupi ava ndayaracua iri chira yuvɨreco. Oyembosɨquɨye guasu-guasu tẽi aveira yuvɨreco para guasu rɨapugüer renduse. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ahese ava setá yaracua cañɨ tẽira osɨquɨyepave yuvɨreco opɨhañemoñeta guasu aise co ɨvɨ pɨpe mbahe oime vaherã sui. Ahese avei ɨva resendar opacatu mbahe orɨrɨira. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ahese ramo opacatu ava che, Ava Rɨquehɨr, che repiara yuvɨreco, agüeyɨse ɨva quɨha rese che pĩratasa rendɨgüer porañetesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Omboɨpɨse evocoi nungar mbahe, peyemonguerẽhɨ catura, peyemopoase pe querẽhɨsa pɨpe. Esepia, pe renosesa pɨhaivira mbahe tẽi sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Iyavei oporombohe ambuae mbahe rese: “Peicua tuprɨ higuera ɨvɨra recocuer, anise que ambuae ɨvɨra avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Co ɨvɨra soquɨ ramose, yaicua cõimi arɨ sacu vahe yepota ãgua yandeu yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na ehi aveira pẽu che ñehe rupi tuprɨ mbahe pesepiase. Sese peicuara Tũpa mborerecuasa cõimi eté secoise. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Supi eté yuvɨrecove vɨtera ava osepia vahe co mbahe opase yavɨye. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ɨva, ɨvɨ opara ocañɨ, che ñehengagüer rumo imboavɨyesa rane itera” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Peicua catu, aní pemboavai eteprɨ pe mbahe reroya ãgua mbahe tẽi aposa pɨpe, pe caguar tẽisa pɨpe, co ɨvɨ pɨpendar tecocuer rese pe pɨhañemoñeta tẽisa pɨpe avei. Evocoiyase topoesapɨha eme ");
INSERT INTO gyrNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","inungar ɨvonde ovɨapi vahe ahe arɨ pɨpe. Esepia, opacatu ava eta upe oimera evocoi nungar mbahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sese peyemoingatu, peyeroquɨ arɨ rupi co mbahe tẽi sui pe yepepɨ ãgua, pe yemboyecua tuprɨ ãgua che, Ava Rɨquehɨr, rovai” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ẽgüe ehi Jesús oporombohe arɨ rupi tũparo guasu pɨpe. Pɨ̃tu pɨpe evocoiyase opɨta ɨvɨtrɨ Olivo rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iyavei opacatu ava yuvɨraso añihiveive tũparo guasu pɨpe iñehe rendu ãgua yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ovɨrovɨse Pascua pieta pan ndayapepoi vahe hu ãgua, ");
INSERT INTO gyrNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ahese pahi rerecuareta, Moisés porocuaita rese oporombohe vahe avei ava sui osɨquɨyepave, oseca-seca tẽi Jesús yuca ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Evocoiyase Caruguar oique Judas pɨha pɨpe, ahe acoi doce tuprɨ semimbohe pãhu pendar Iscariote serer vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ahe oso pahi eta rerecuar yuvɨrecoi vahe upe, tũparo rãrosar yuvɨrecoi vahe upe avei imoñeta ãgua, “Tamondo Jesús pe povrɨve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ahe evocoiyase oyembovɨharete yuvɨreco. “Yamondo guarepochi chupe” ehi voi eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas evocoiyase, “Avɨye” ehi. Oseca voi ava porẽhɨseve Jesús mondo ãgua yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oyepota arɨ yɨpɨndar vahe pan ndayapepoi vahe hu ãgua. Ahe pɨpeve avei ovesa Pascua pieta resendar yucaprɨ seropovẽhesa yepi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Evocoiyase Jesús omondo güemimbohe Pedro, Juan reseve aipo ehi: —Peso, tapemoingatu yande caru ãgua Pascua pieta resendar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Semimbohe rumo, —¿Que vo ereipota oromoingatura? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Evocoiyase aipo ehi: —Peyepotase tecua pɨpe, aheve pesepiara mbɨa vɨreco vahe cambuchi pɨpe ɨ. Pesora sẽtave supi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Aipo peyera peñehe oɨ yar upe: “Ore mbohesar oporandu: ‘¿Uma oɨ pɨpe vo Pascua pieta resendar orohura che remimbohe rese?’ ehi” peyera. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Evocoiyase ahe omboyecuara oɨ guasu, ɨvatendar pẽu. Aheve pemoingatura yande caru ãgua —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ipare ahe yuvɨraso, semimombehu rupi tuprɨ ité osepia mbahe. Aheve omoingatu carusa Pascua pieta resendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Osupitɨse icaru ãgua apóstol reseve yuvɨroguapɨ mesave. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Evocoiyase aipo ehi: —¡Cueseve tẽi eté niha aipota acaru vaherã pe pɨri Pascua pieta resendar rese che mano ãgua renonde! ");
INSERT INTO gyrNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Esepia niha, ndayapo iri chira pieta Pascua resendar acoi yavɨyese voi eté Tũpa mborerecuasa pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Evocoiyase oipɨsɨ ɨgua rɨru, “Avɨye ndeu” ehi Vu upe, iyavei aipo ehi: —Co amondora pẽu, perova-rova peyacatu. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Esepia, co pɨpe suive ndaɨhu iri chira uva rɨcuer acoi ouse voi Tũpa mborerecuasa —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ipare oipɨsɨ pan, “Avɨye ndeu” ehi Vu upe. Aipo ohe pare ombohi-mbohi imondo güemimbohe upe. —Co che rete, omboyecua imondopɨrã pe recocuer rese. Na peyera pe mahenduhasa pɨpe che rese yepi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ẽgüe ehi avei carusa pare yapo ɨgua rɨru rese aipo ehi: —Co ɨgua rɨru pɨpendar omboyecua che Ru remimbotar ipɨasu vahe pẽu nara, ahe che ruvɨ ipɨyerepɨrã pe recocuer rese nara. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Cũritei rumo oime mbɨa mesave yande pɨri che mondo vaherã che amotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Supi eté imboavɨyesa itera che, Ava Rɨquehɨr, rese ñehesa yɨpɨve imombehuprɨ. ¡Iparaɨsu catura rumo acoi mbɨa che mondosar! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Evocoiyase aipo ehise, semimbohe oporandu-randu tẽi oyeupe: “¿Ava pĩha ẽgüe ehi?” ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ipare voi semimbohe oñemoñeta guasu yuvɨreco oyese, ipɨhañemoñeta ‘avɨyeteramo che imboeteiprɨ catu vahe aicora oporocuaise Jesús’ ohesave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Evocoiyase Jesús aipo ehi: “Ava mborerecuar co ɨvɨ pɨpendar oyocuai pĩrata ava yuvɨreco yepi. Ahe chupe rumo, ‘Mbahe tuprɨ aposar’ ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pe rumo ẽgüe ndapeyei chira. Acoi oyemboɨvate pota vahe, toyemochĩhivaheño güeco mbegüesa pɨpe. Acoi ava cuaisar, tihañeco catu ambuae ava rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Uma pĩha ɨvate catu vahe: co mesave oguapɨ vahe ocaru yuvɨreco? ¿Sese ihañeco vahe tie? Acoi mesave oguapɨ vahe niha. Che rumo co aico pe pãhuve inungar pe rese ihañeco vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Pe rumo peico vahe che rupi yepi opacatú che recoãhasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Sese che amondo pẽu pe mborerecuasa inungar che Ru ombou cheu che mborerecua ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Esepia, pecarura iyavei peɨhura che mborerecuasave che pɨri. Iyavei peguapɨra opacatu judío recocuer rese porandu ãgua” ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aipo ehi avei yande Yar: —Simón, Simón, esendu: Caruguar oporandu pe recoãha ãgua rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Che rumo ayeroquɨ nde rese nde yeroyasa paneẽhɨ ãgua. Ereyevɨse cheu, emonguerẽhɨ catu ambuae nde rɨvɨreta imovɨracua uca ãgua yuvɨreco oyese —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Che Yar, che rumo ayemoingatu voi eté nde rupi che so ãgua nde roquendasave iyavei che mano ãgua nde rupi —ehi Pedro chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Pedro, supi eté amombehu ndeu: co pɨpe, tacura ñehe renondeve, nde, “Ndaicuai eté evocoi mbɨa” erera mbosapɨ oyupagüer rupi cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Evocoiyase Jesús oporandu güemimbohe eta upe: —Opomondose acoi mbahe rɨru porẽhɨ, guarepochi rɨru porẽhɨ, ambuae pe pɨtaqui ndugüer rerasoẽhɨse, ¿ipane vo acoi mbahe ahese pẽu? —ehi. —Aní eté —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Evocoiyase, —Cũritei, acoi mbahe rɨru vɨreco vahe, tovɨrecoveño, guarepochi rɨru vɨreco vahe, tovɨrecoveño avei; acoi ndovɨrecoi vahe quɨse pucu, tomondo oyeaosa quɨse repɨrã. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Supi eté amombehu pẽu: iyacatu ité imboavɨye tuprɨ ãgua co che rese ñehesa imombehuprɨ aipo ehi vahe: ‘Ava vɨreco ndaseco põrai vahe nungar yuvɨreco’ ehi vahe. Supi eté yavɨyera co icuachiapɨrer che resendar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Evocoiyase semimbohe aipo ehi yuvɨreco: —Ore Yar, cohave oime ñuvɨrío quɨse pucu —ehi. —Ahe güeraño ité avɨye —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ipare Jesús osẽ oso ɨvɨtrɨ Olivo ve. Ahe ɨvɨtrɨve oso yepi, aheve semimbohe yuvɨraso yuvɨreco supi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oyepotase aheve yuvɨreco, Jesús aipo ehi güemimbohe upe: —Peyeroquɨ angaipa pe yapoẽhɨ ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ipare oyepepɨ güemimbohe sui, inungar ita imombosa vahe amombrɨmi, aheve oñenopɨha, oyeroquɨ ");
INSERT INTO gyrNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","aipo ehi: “Che Ru, ereipotase, che renose eve co mbahe tẽi sui; tayapo eme che remimbotar tẽi, nde remimbotar rupira rumo” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Evocoiyase oyemboyecua Tũpa rembiguai chupe, seco momirata ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Mbahe-mbahe tẽi porarasa pɨpe oyeroquɨ catu. Ahese sacuvor inungar tuvɨ osẽ ichui otɨquɨ ɨvɨve. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Oñarapuhase oyeroquɨsa sui, oyevɨ oso güemimbohe uve. Ahe rumo opaño yuvɨroque yuvɨrocua ovɨharẽhɨsa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Evocoiyase, —¡Mahera opaño peque! Peñarapuha, peyeroquɨ catu pe vɨapiẽhɨ ãgua mbahe tẽi pɨpe —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ñehe vɨteseve, oyepota atɨ ava yuvɨreco chupe. Judas doce semimbohe pãhu pendar tenonde secoi. Ahe oyemboya oso sese sovaupɨte ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Evocoiyase aipo ehi Judas upe: —Judas, ¿mahera vo che, Ava Rɨquehɨr, rovaupɨtesa pɨpe che mondo eve che amotarẽhɨmbar upe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Semimbohe eta rumo, mbahe-mbahe tẽi repiase, oporandu yuvɨreco: —Ore Yar, ¿yavavara yande quɨse pucu pɨpe? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ñepei rumo supindar, pahi rerecuar ɨvate catu vahe rembiguai nambi yasu cotɨndar oyasɨa. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ahe rumo, —Teheni, evocoi rupive —ehi güemimbohe eta upe. Ipare opoco inambi rese ombogüera voi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ichui aipo ehi güecasar opacatu pahi eta rerecuar upe, tũparo rãrosar upe, tecua pɨpendar rerecuar upe avei: —¿Quɨse pucu, ɨvɨra reseve-seve rutei co peyu che ropeña, imonda rai vahe nungar che rereco peye? ");
INSERT INTO gyrNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Aicose tũparo pɨpe pe pãhuve arɨ yacatu rupi, na ndapeyapoi eté co nungar cheu. Avɨyeño rumo, oyepota ité niha pẽu imombehuprɨ Caruguar pĩratasa pɨpe mbahe-mbahe tẽi apo ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Evocoiyase Jesús oipɨsɨ yuvɨreco, ovɨraso pahi eta rerecuar ɨvate catu vahe rẽtave yuvɨreco. Pedro rumo amombrɨ rupive tẽi osaquɨcue moñaño oso. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aheve ñachimbrɨ pɨpe oyatapɨ yuvɨreco, oyere tuprɨ tata rese oyepehe yuvɨnoi. Aheve avei Pedro ipãhuve chini. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Evocoiyase cuña mbiguai, osepiase Pedro, omahe tuprɨ iri sese aipo ehi: —Co ava avei niha acoi Jesús rupindar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ahe rumo aipo ehiño: —Cuña, ndaicuai vahe ité ahe mbɨa —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Iparemi tẽi ambuae osepiase aipo ehi chupe no: —Nde ité niha acoi supindar ereico —ehi. —Aní mbɨa, aipo ere tẽi, ndahei eté rumo che supindar aico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ñepei hora paremi tẽi, ambuae aipo ehi chupe: —Supi eté rumo co ité supi secoi vahe. Esepia, Galilea ɨguar ité niha —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Sese aipo ehi: —¿Mbahe vo catu aipo nde ñehesa? Ndasenducuai eté —ehi. Aipo ihe vɨteseve, oñehe tacura. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Evocoiyase yande Yar oyemboyere sese. Ahe ramoseve oyemomahenduha: “Co pɨpe tacura ñehe renondeve, ‘Ndaicuai vahe’ erera mbosapɨ oyupagüer rupi cheu” ihe agüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ahese osẽ, oyasehó iteanga oso. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Evocoiyase ava Jesús rãrosar iguayɨ tẽi yuvɨrocua-rocua yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Osesacua yuvɨreco. Ipare oporandu yuvɨreco chupe: —¡Eicua ité ru, ava evocoi ocua nde rese! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iyavei setá mbahe rese oñehe-ñehe tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ahe arɨ pɨpe, cõhese, oñemonuha ava judío rerecuar, pahi eta rerecuar iyavei opacatu Moisés porocuaita rese oporombohe vahe yuvɨreco Jesús reraso uca ãgua ava ñemonuhasa ɨvate catu vahesave, oporandu mbahe rese yuvɨreco chupe: ");
INSERT INTO gyrNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Supi eté vo nde Poropɨ̃sɨrosar ereico? Emombehu ru oreu —ehi yuvɨreco chupe. —Amombehuse rumo pẽu, ndache reroyai chietera peye —ehi judío rerecuar upe—. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Inungar che aporanduse mbahe rese pẽu, pe avei ndapemboyevɨi chietera cheu viña no. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Co pɨpe suive rumo che, Ava Rɨquehɨr, aguapɨra Tũpa mbahe mboavaisarẽhɨ acato cotɨ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ichui opacatu ava oporandu yuvɨreco chupe: —Evocoiyase, ¿nde ité ereico Tũpa Rahɨr? —ehi. —Supi eté niha aipo aipo peye cheu —ehi mborerecuareta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Evocoiyase ahe aipo ehi yuvɨreco: —¡Indó! ¿Ava iri vo evocoiyase mbahe omombehura yandeu? Yasendu niha iñehe ité cute —ehi mborerecuar oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Evocoiyase opacatu ava opũha yuvɨreco Jesús reraso ãgua mborerecuar Pilato rovai. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aheve oiñehengapo aipo ehi yuvɨreco: —Orosepia co mbɨa oipɨhañemoñeta rerova atɨ uca ava yande recua rupindar aipo ehi: “Pemondoi rene Roma pendar mborerecuar ɨvate catu vahe upe guarepochi” ehi. Iyavei, “Che Poropɨ̃sɨrosar mborerecuar ɨvate catu vahe aico” ehi oico —ehi yuvɨreco Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Evocoiyase Pilato oporandu chupe: —¿Nde ité vo judío rerecuar ɨvate catu vahe? —ehi. —Nde niha aipo, “Ahe ereico” ere cheu —ehi imboyevɨ Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Evocoiyase Pilato aipo ehi pahi eta rerecuar upe opacatu ava upe avei: —Che rumo namohai eté co mbɨa que mbahe oyapo vaherã —ehi ");
INSERT INTO gyrNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ahe ava eta rumo, —Supi eté opacatu ava oipɨhañemoñeta mboyeavɨratɨ́ uca opacatu tecua rupindar. Yɨpɨndar omboɨpɨ Galilea rupi oico. Cũritei co Judea ve ẽgüe ehiño ité —ehi ava eta Pilato upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato osenduse aipo ñehesa oporandu, “¿Supi eté pĩha co mbɨa Galilea ɨguar?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ahe pendar ité” ehise yuvɨreco chupe, ahese omondo Herodes upe, ahe acoi mborerecuar Galilea rupindar. Ahese avei secoi Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes sorɨvete Jesús repiase. Esepia, setá arɨ osepia pota tẽi serãcua anduse yepi. Evocoiyase oipota ité poromondɨisa oyapo vaherã oyeovaque viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sese oporandu atɨ mbahe rese chupe. Nomboyevɨi eté rumo Herodes upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aheve opacatú pahi eta rerecuar iyavei Moisés porocuaita rese oporombohe vahe eta seroɨ̃rosave oñemoñeta-ñeta tẽi sese Herodes rovaque yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Evocoiyase Herodes osundao eta reseve iñehe mara-mara tẽi Jesús upe sese oguayɨ tẽisa pɨpe yuvɨreco. Omboyemonde avei turucuar iporañete vahe pɨpe yuvɨreco. Ẽgüe ehi imboyevɨ Herodes Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ahe arɨ pɨpe suive oyemborɨ Pilato Herodes rese. Ndoyeambotai vahe tie yɨpɨndar yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Evocoiyase Pilato opa uca omonuha opacatu pahi eta rerecuar, judío rerecuareta, opacatu ava eta avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ipare aipo ehi chupe: —Pe niha peru co mbɨa cohave cheu, ‘Omañeco tẽi ava secua rupi’ peye. Che rumo aporandu tẽi pe rovaque mbahe rese chupe. Ndipoi eté rumo mbahe sembiapo naporai vahe pe remimombehu rupi. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes avei, ‘Ndipoi mbahe sembiapo naporai vahe imano ãgua’ ehi. Sese omboyevɨño Jesús imbou cheu. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ainupa ucara rumo. Ipare amoseñora —ehi Pilato. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pascua pieta pɨpe iya ité Pilato ava upe ñepei soquendaprɨ mose ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Opacatú guasu rumo ava oñehe pĩrata yuvɨreco aipo ehi: —¡Co topɨtaño oreu! ¡Barrabás emoseño! —ehi ava eta Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Co mbɨa Barrabás tecua pɨpe mbahe tẽi mopuhasa sui iyavei oporapichisa sui oyeoquenda uca vahe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato rumo omose pota Jesús viña. Sese oporandu iri ava upe imose ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ahe rumo osapucai pĩrata catu yuvɨreco: —¡Aní, tayatɨcasa! ¡Tayatɨcasa curusu rese! —ehi atɨ-atɨño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Imombosapɨsa rese Pilato oñehe iri: —¿Mbahe ité vo oyapo naporai vahe? Ndipoi eté niha que mbahe sembiapo yuca ãgua, ainupa uca tẽira rumo. Ipare amoseñora —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","24","Ava rehɨi rumo osapucai pĩratá catu yuvɨreco, “Tayatɨcasa ité” ehi-ehiño yuvɨreco. Sese chupe, “Tayaposa evocoiyase semimbotar yuvɨreco” ehiño Pilato ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ẽgüe ehi imose co mbɨa Barrabás, acoi soquendaprɨ mbahe-mbahe tẽi mopuhasa sui, iporapichisa sui avei ava remimbotar rupi. Ipare omondo Jesús sãrosar upe ava remimbotar apo ãgua sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Oime mbɨa Simón serer vahe Cirene ɨguar ou vahe que co cotɨ rupi sui. Ovɨrasose Jesús yuvɨreco yatɨca ãguave, ahe mbɨa upe, “Nde terevosɨi curusu rese Jesús raquɨcuei” ehi voiño tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ava rehɨi yuvɨraso saquɨcuei. Cuña avei setá oyaseho ovɨharẽhɨsave yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Omahese rumo cuña rese aipo ehiño chupe: —Cuña Jerusalén ɨguar, peyasehoi rene che rese. Peyese ae peyaseho, pe membrɨ rese avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Esepia, oura arɨ naporai vahe. Ahese aipo peye tẽira: ‘Avɨye catu acoi cuña nimembɨi vahe iyavei ndoicuai vahe imocambu omembrɨ’ peye tẽira. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ahese avei ava ɨvɨtrɨ uve aipo ehira yuvɨreco: ‘¡Tovɨapi ore harɨve!’ ehira osɨquɨyepave. Iyavei ɨvɨvate vahe upe: ‘¡Tore mi!’ ehi tẽira yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Esepia, ẽgüe ehise ɨvɨra yɨvɨve vɨtese, ¿mara ehira vo catu oɨpise? —ehi cuña eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iyavei vɨraso ñuvɨrío mbɨa ndaseco põrai vahe supive yatɨcapɨrã yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Oyepotase Ava Ãca Cangüer serer vahesave, aheve oyatɨca curusu rese yuvɨreco. Iyavei oyatɨca ñuvɨrío mbɨa, ñepei mbahe rese ipocosa cotɨ, ambuae evocoiyase mbahe rese ipocoẽhɨsa cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ahese Jesús aipo ehi: —Che Ru, ndeñero co ava upe sembiapo rai rese. Esepia, ndoicuai co mbahe güembiapo yuvɨreco —ehi. Sundao evocoiyase iguayɨño Jesús turucuar rese oyeupe imboyaho-yaho ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ava rehɨi osepia yuvɨreco; mborerecuareta avei seroɨ̃rosave aipo ehi yuvɨreco chupe: —Oipɨ̃sɨro ambuae ava, toñepɨsɨro ru ahe ae ité cute Tũpa Rembiporavo Poropɨ̃sɨrosar güecosa pɨpe —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Iyavei sundao seroɨ̃ropare omondo vinagre itoɨhu yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","iyavei aipo ehi yuvɨreco chupe: —¡Nde niha aipo ava judío eta rerecuar guasu ereico! ¡Eñepɨsɨro ru nde ae ité! —ehi sundao eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Curusu rese ñaca harɨve icuachiaprɨ aipo ehi oĩ: “Co judío rerecuar guasu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Evocoiyase ndaseco põrai vahe yatɨcaprɨ iñehe mara tẽi chupe aipo ehi: —¡Nde Poropɨ̃sɨrosar ereicose, eñepɨsɨro ru nde ae, ore avei ru ore pɨ̃sɨro eve! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ambuae evocoiyase aipo ehi voi ondugüer uve: —¿Nderesɨquɨyeimi rutei vo Tũpa sui? Nde avei niha ocañɨ tẽi vaherã. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yande rumo co yande rembiapo sui tẽi mara-mara tẽi yande rereco yuvɨreco; co mbɨa rumo mbahe sembiapoẽhɨ pɨpe sui tẽi na ehi serecosa —ehi ondugüer upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Evocoiyase aipo ehi iri: —Jesús, che paraɨsuerecomi tẽi eve nde eremboɨpɨse nde mborerecuasa —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Evocoiyase omboyevɨ chupe: —Supi eté co pɨpe ereicora tecua apɨrẽhɨ vahesave che rupi —ehi Jesús ahe mbɨa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Osupitɨse rumo mbɨter arɨ, opa tuprɨ pɨ̃tu ɨvɨ rupi; las tres pɨpe rumo opa icatu. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Arɨ avei ogüe tuprɨ, turucuar guasu tũparo asɨasa avei mbɨter rupi tuprɨ ovo. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Evocoiyase Jesús oñehe pĩrata: —¡Che Ru, amondo che espíritu ndeu! —ehi. Aipo ohe pare voi omano. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Evocoiyase Roma ɨguar sundao rerecuar osepiase co mbahe poromondɨisa Tũpa mboeteisa pɨpe aipo ehi: —Supi eté co mbɨa ndaseco marai vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iyavei opacatu ava supindar yuvɨrecoi vahe osepiase co nungar mbahe, oyepochiha nupa-nupa tẽi oyepɨhamondɨisa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Opacatu avei ava oicua vahe Jesús, ipãhuve cuña Galilea sui yugüeru vahe, osepiaño tẽi amombrɨve co nungar mbahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Oime mbɨa avɨye eteprɨ vahe, ahe serer José, tecua Arimatea pendar. Ahe tecua ɨvɨ Judea pɨpendar, judío rerecuar ñemonuhasa ɨvate catu vahe pendar secoi. Ahe mbɨa vɨroya vahe ité Tũpa ombou vaherã omborerecuasa pɨpe mbahe moingatu ãgua. Sese ndahei ipɨhañemoñeta rupi co mborerecuar oyapo vahe mbahe Jesús upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Evocoiyase ahe oso Pilato rẽtave oporandu ãgua Jesús rehõgüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Curusu sui seroyɨ pare voi, oimama turucuar secose vahe pɨpe, ipoyava imondo tuvɨpa pɨpe ita guasu yohoprɨ ndiporusa vɨtei vaheve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Esepia, ahe arɨ omoingatu mbahe mbɨtuhusa arɨ upe nara, ahe mbɨtuhusa rumo osupitɨ pota ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Cuña yugüeru vahe Jesús rupi Galilea sui, yuvɨrasoño ité suvɨpave, osepia sehõgüer apocatuse yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Oyevɨse güẽtave yuvɨreco omoingatu mbahe sɨ̃acua vahe tehõgüer resendar ipichi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cõhe ramomise domingu pɨpe, oyevɨ yuvɨraso tuvɨpave mbahe sɨ̃acua vahe reseve. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Oyepotase yuvɨreco tuvɨpave, osepia soquendasa ita guasu ndipo irise güendagüerve. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Evocoiyase yuvɨroique voi tuvɨpa pɨpe. Ndoyosui rumo yande Yar rehõgüer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ndoyembovɨhai tẽi; ndoicatu iri. Ahese avɨyeteramo tẽi osepia ñuvɨrío mbɨa iturucuar sendɨ vahe oɨpɨve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Opaño ñaca ɨvɨso ɨvɨ cotɨ yuvɨreco osɨquɨyepave. Evocoiyase co mbɨa aipo ehi yuvɨreco chupe: —¡Mahera peseca tuvɨpa pãhu rupi ava oicove vahe! ");
INSERT INTO gyrNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ndipoi mo cohave; ocuerayevɨ mo ahe. Peyemomahenduha iñehengagüer ɨvɨ Galilea rupi omombehu vahecuer rese, ");
INSERT INTO gyrNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Che, Ava Rɨquehɨr, imondoprɨra ava angaipa viyar povrɨve, iyavei che atɨcara curusu rese yuvɨreco. Mbosapɨ arɨ pare rumo acuerayevɨra” ehi acoi —ehi cuña upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Evocoiyase cuña oyemomahenduha voi Jesús ñehengagüer rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Oyevɨse tuvɨpa sui yuvɨreco, omombehu opacatu co once apóstol yuvɨrecoi vahe upe, opacatu ambuae upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Co omombehu vahe Jesús resendar ñehesa yuvɨreco apóstol eta uve, ahe: María Magdalena, Juana, Santiago sɨ María iyavei ambuae cuña eta no. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Apóstol upe rumo oyeupe mombehuse avɨye aipo ehi tẽi vahe; ndovɨroyai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedro rumo yandu ramoseve voi, osẽ, oña oso tuvɨpave. Omahese tuvɨpa pɨpe, turucuar güeraño osepia co cotɨmi tuise. Evocoiyase oyepɨhamondɨi tẽi ‘¿mara ehi rutei pĩha?’ oya oyevɨ oɨve oso. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ahe arɨ pɨpeve caharuse, ñuvɨrío semimbohe yuvɨraso tecua Emaús ve. Ahe once kilómetro tecua Jerusalén sui. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ahe perɨ rupi oñemoñeta yuvɨraso opacatu co mbahe oime vahecuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Oñemoñeta vɨteseve, Jesús teieté oyemboya sese, oguata supi. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Yepe osepia tẽi, ahe rumo ndoyepiacua ucai eté chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Evocoiyase Jesús oporandu chupe: —¿Mbahe rese vo pe ñehe eteprɨ pe guatasa rupi peico? —ehi. Aipo hese, opɨta, ndovɨhai yuvɨnoha. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ipãhu pendar Cleofas serer vahe omboyevɨ chupe: —Nde güeraño revo Jerusalén ve ereico vahe ndereicuai mbahe oime vahe tecua pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Evocoiyase, —¿Mbahe vo oime yandeu? —ehi. —Jesús mo Nazaret pendar, ahe Tũpa ñehe mombehusar seco pĩrata vahe opacatu mbahe apo ãgua, mbahe mombehu ãgua avei Tũpa rovaque iyavei opacatu ava rovaque. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Omondo pahi rerecuar iyavei yande rerecuareta yamotarẽhɨsave yuca uca ãgua curusu rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ore rumo oroyeroya ité sese. “Ahe yande pɨ̃sɨrora yande amotarẽhɨmbar sui” orohe chupe viña. Cũritei rumo opa mbosapɨ arɨ yucare. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ore pãhu pendar cuña ndore mbovɨhai eté oyevɨse suvɨpa sui yuvɨreco. Esepia, yɨpɨndar yuvɨrasose añihiveive tuvɨpave, ");
INSERT INTO gyrNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ndoyosui eté sehõgüer yuvɨreco. Ahese aipo osepia Tũpa rembiguai aipo ehi vahe yuvɨreco chupe: “Jesús mo oicove cũritei” ehi. Ahe evocoiyase yugüeru imombehu oreu. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Iyavei ambuae ore ndugüer yuvɨrasose tuvɨpave cuña remimombehu rupi tuprɨ avei. Ndosepiai eté rumo Jesús yuvɨreco —ehi Cleofas chupe tuprɨ ité. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Evocoiyase aipo ehi ahe ñuvɨrío mbɨa upe: —¡Ndapeicuai eté rumo pe pɨha pɨpe seroya tuprɨ ãgua opacatu Tũpa ñehe mombehusar remimombehugüer! ");
INSERT INTO gyrNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ndapeicuai vo Poropɨ̃sɨrosar iparaɨsu rane itera mbahe-mbahe tẽi vɨrecosa pɨpe güecua porañetesave güeique ãgua renondeve? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ipare opa omombehu icuachiaprɨ Moisés cuachiar pɨpendar iyavei opacatu Tũpa ñehe mombehusar cuachiar pɨpendar oyese ñehe agüer. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Oyepotase ahe tecuave yuvɨraso, Jesús rumo avɨye oguataño vɨte vaherã senonde. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Co mbɨa rumo oñehe yuvɨreco chupe: —Epɨtaño ore pɨri, caharu eteprɨ. Pɨ̃tura moco ndeu —ehi yuvɨreco chupe. Evocoiyase oique, opɨtaño ipɨri yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Oguapɨse yuvɨnoi mesave, oipɨsɨ pan, “Avɨye ndeu” ehi Tũpa upe. Ipare ombohi co ñuvɨrío mbɨa upe imondo. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ahese voi semimbohe omahecua ramo yuvɨreco sese, ahe rumo cũriteimi ndoyemboyecua iri sovai chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Evocoiyase aipo ehi oyeupe yuvɨreco: —Yande mbopɨhañemoñeta pĩratami eté perɨ rupi oñehese yandeu co tecocuer icuachiaprɨ rese —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ipare ndopɨta pucu iri; oyevɨño voi yuvɨraso tecua Jerusalén ve. Aheve osepia once tuprɨ vahe apóstol, omboetasa avei. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ahese oñemonuha vahe aipo ehi yuvɨreco: —Supi eté rumo yande Yar ocuerayevɨ. Esepia, oyemboyecua ité Simón upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Evocoiyase ahe avei omombehu, “Oreu avei oyemboyecua oroguatase perɨ rupi. Ombohise pan ore pɨri, ahese ramo oroicua” ehi yuvɨreco omboetasa upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ahe oñehe vɨteseve yuvɨreco co tecocuer rese, ahese Jesús oyemboyecua chupe aipo ehi: —Avɨrave, mbahe tuprɨ pɨpe tapeico —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ahe rumo oyembosɨquɨye guasu yuvɨreco ‘hãgüer revo’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—¡Mahera pesɨquɨye! ¡Mahera pereco vɨte pe poreroyaẽhɨsa pe pɨha pɨpe! ");
INSERT INTO gyrNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pemahe che po rese, che pɨ rese avei. Che ité niha co aico. Pepoco ru che rese. Tache reroya ru peye. Esepia, ava hã ndovɨrecoi voho iyavei ocangüer; che rumo areco ité —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aipo ohe vɨteseve omboyecuapa opo, opɨ avei chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ahe rumo vorɨvetesa pɨpe iyavei oyepɨhambosɨquɨye vɨtesa sui ndovɨroya tuprɨ vɨtei eté yuvɨreco. Evocoiyase aipo ehi: —¿Perecomi vo mbahe yande caru ãgua? —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Evocoiyase omondo pira apɨremi oyɨ vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ipare oipɨsɨ, ohu opacatu güemimbohe rovaque. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ipare aipo ehi: —Co rese acoi añehe vichico cuese pe rese aico vɨtese che mano renondeve. Yavɨye ranera opacatu ñehesa che resendar Moisés porocuaita cuachiaprɨ pɨpe, iyavei Tũpa ñehe mombehusar yuvɨrecoi vahe rembicuachiagüer pɨpe, Salmo pɨpe avei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ẽgüe ehi evocoiyase opacatu osenducua uca aracahendar icuachiapɨrer güemimbohe upe ");
INSERT INTO gyrNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","aipo ehi: —Co icuachiasa Poropɨ̃sɨrosar iparaɨsura omano ãgua. Ipare mbosapɨ arɨ pare ocuerayevɨra. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jerusalén sui tuprɨ opacatu ɨvɨ yacatu rupi imombehusara serer pɨpe, “Pemboasɨ pe angaipa, peyevɨ Tũpa upe pẽu ñeroi ãgua” hesara. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pe niha peico opacatu co nungar mbahe repiasar imombehu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Che amboura che Ru remimombehu pe harɨve. Pepɨtañora rumo cohave tecua Jerusalén ve acoi peipɨsɨse voi pĩratasa ɨva suindar —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Evocoiyase Jesús yuvɨnose tecua sui yuvɨraso tecua Betania popɨve. Aheve ñuvɨrío opo omopuha, osovasa mbahe tuprɨ reime ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ipare oyepepɨ güemimbohe sui. Ahe ramoseve serasosa ɨvave. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Semimbohe evocoiyase osapucai imboeteisave. Ipare oyevɨ Jerusalén ve vorɨvetesa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iyavei ahe arɨ yacatu rupi yuvɨraso tũparo guasu pɨpe osapucai Tũpa mboeteisave yuvɨreco yepi. Aipo rupive.");
INSERT INTO gyrNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Jesús yɨpɨsuive ité Tũpa Ñehe secoi. Ahe oicove mbahe apoẽhɨ vɨteseve Tũpa rese. Esepia, ahe niha Tũpa secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ipɨpe avei Tũpa opacatu mbahe oime vahe oyapo; ndipoi eté mbahe sembiapoẽhɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesús niha vɨreco tecovesa apɨrẽhɨ vahe oyese. Ahe tecovesa tesapesa nungar secoi opacatu ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ahe tesapesa omboyecua tecocuer supi eté vahe pɨ̃tumimbi nungar mbahe naporai vahe aposar pãhuve. Ahe mbahe tẽi aposar rumo ndoicatui eté secopɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oime mbɨa Tũpa remimbou. Ahe Juan serer vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ahe rumo ou co tesapesa cua uca ãgua ‘tovɨroya opacatu ava yuvɨreco’ ohesave. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ahe rumo ndahei eté tesapesa; imombehusar tẽi rumo secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Co tesapesa supi eté vahe osesape opacatu ava. Ahe ou ité co ɨvɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yepe tie ipɨpe yapoprɨ opacatu ava viña, sembiapo rumo ndoicuai co ɨvɨ pɨpe secoise yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Supi eté ouse güecuave, secua pendar ae rumo ndoipɨsɨi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Opacatu rumo acoi oipɨsɨ vahe seroyasave yuvɨreco, ahe chupe omondo ñecuñarosa Tũpa rahɨr seco ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ndahei rumo co ɨvɨ pɨpendar rahɨr nungar que oha vahe ambuae ava remimbotar pɨpe tẽi. Ahe rumo Tũpa rahɨr ité yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ipare ahe Tũpa Ñehe, oyeapo ava, oicove yande pãhuve co ɨvɨ pɨpe oporoaɨsusave mbahe supi eté vahe aposa pɨpe. Iyavei orosepia ité seco porañetesa. Co seco porañetesa oipɨsɨ vahe Vu sui Tahɨr ñepei vahe güeco pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan niha oñehe sese ava upe aipo ehi: “Co uve niha acoi aipo ahe vahe cuese: ‘Acoi ou vaherã che raquɨcuei, ahe ɨvate catu vahe che sui. Esepia, yɨpɨve ité secoi che yesuẽhɨ vɨteseve’ ahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Esepia, opacatu ité yaipɨsɨño iporovasasa tuvichá vahe ombouño vahe ité yandeu arɨ yacatu rupi yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mborocuaita yaipɨsɨ Moisés sui; porovasasa rumo iyavei mbahe supi eté vahe, ahe güeru Jesucristo yandeu. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ndipoi eté ava osepia vahe Tũpa; Tahɨr ñepei vahe, secoi vahe ité ipɨri, ahe oicua uca yandeu. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judío rerecuar guasu tecua Jerusalén pendar oyocuai pahi eta iyavei ipɨ̃tɨvɨisareta imondo Juan uve ‘¿Ava vo nde? tehi yuvɨreco chupe’ oyapave icua ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ahe rumo oyemombehu ité aipo ehi: —Che ndahei eté Poropɨ̃sɨrosar aico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Evocoiyase oporandu iri yuvɨreco: —¿Ava ité vo nde? ¿Nde tie Elías ereico? —ehi. —Ndahei eté che ahe aico —ehi. Evocoiyase, —¿Nde tie acoi Tũpa ñehe mombehusar ou vaherã? —ehi yuvɨreco chupe. —Aní eté —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿Ava rutei vo evocoiyase nde? ¡Emombehu oreu ore oromombehu vaherã ore mbousar uve! ¿Mbahe ité vo eremombehura ndeyesuindar oreu? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—Che aico oñehe vahe ɨvɨ iporupɨrẽhɨsa rupi aipo ahe: ‘Pemoingatu pe recocuer yande Yar yepotase nara’ ahe pẽu. Ahe inungar acoi Tũpa ñehe mombehusar Isaías aipo ehi vahe aracahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ahe yuvɨraso vahe chupe, fariseo remimondo yuvɨrecoi, ");
INSERT INTO gyrNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","oporandu yuvɨreco chupe: —Evocoiyase ndahei niha aipo nde Poropɨ̃sɨrosar, ndahei avei Elías, ndahei eté Tũpa ñehe mombehusar imombehuprɨ ereico. ¿Mahera ru evocoiyase ereporoãpiramo? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Evocoiyase fariseo upe aipo ehi: —Che rumo ɨ pɨpe aporoãpiramo; oime rumo mbɨa pe pãhuve ndapeicuai vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ahe co ɨvɨ pɨpe ou vaherã che raquɨcuei. Che rumo ndahei eté seco catuprɨ vahe aico ipɨtaquisã yora ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Co opacatu mbahe yaposa tecua Betania ve, ɨai Jordán rovai añihivei cotɨ. Aheve Juan oporoãpiramo yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ahere ayihive Juan osepia Jesús oyemboyase oyese aipo ehi: “¡Pesepia, co Tũpa remimbou Ovesa nungar seropovẽhepɨrã opacatu ava angaipa mocañɨ ãgua! ");
INSERT INTO gyrNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Añehese sese aipo ahe: ‘Che raquɨcuei oura mbɨa ɨvate catu vahe che sui. Esepia, yɨpɨve vahe ité che sui’ ahe acoi cuese. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Che rumo yɨpɨndar ndaicuai ahe yande remiaro ou vaherã. Sese niha aporoãpiramo ɨ pɨpe vichico imboyecua ãgua che mu judío yuvɨrecoi vahe upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","“Che asepia Espíritu Santo ogüeyɨse ɨva sui inungar apɨcasu, opɨta tuprɨ iharɨve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Yɨpɨndar rumo ndaicuai eté. Tũpa che cuai vahe rumo che poroãpiramo ãgua ɨ pɨpe, aipo ehi cheu: ‘Acoi eresepiase Espíritu Santo ogüeyɨse, opɨtase mbɨa harɨve, ahe mbɨa oporoãpiramora Espíritu Santo pɨpe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Che niha asepia ité. Sese, ‘Co Tũpa Rahɨr ité secoi’ ahe pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ahere ayihive Juan secoi aheve avei ore ñuvɨrío mbɨa oroico vahe reseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús ore cuãse, Juan aipo ehi oreu: —¡Pesepia, ndo co mbɨa Tũpa remimbou Ovesa nungar seropovẽhepɨrã! —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aipo ihe ramoseve, oroguata voi eté supi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Evocoiyase omahe guaquɨcuei cotɨ. Ore repiase, oporandu oreu: —¿Mbahe vo pesecami peico? —ehi oreu. Ore evocoiyase, —Porombohesar, ¿que vo nde recosa? —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Yaso, tapesepia ru —ehi oreu. Evocoiyase oroso, oroyepota las cuatro pɨpe secosave. Aheve ore pɨ̃tu ité ipɨri. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Simón Pedro rɨvrɨ, Andrés, ahe che ndugüer ahese. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ahe rane aipo oseca vɨquehɨr Simón aipo ehi chupe: —Orosepia ité Poropɨ̃sɨrosar —ehi (‘Cristo’ oyapave). ");
INSERT INTO gyrNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ipare voi, vɨraso Simón Jesús uve. Osepiase, Jesús aipo ehi chupe: —Nde Simón, Juan rahɨr, ndererguã rumo Cefas —ehi (‘Pedro’ oyapave). ");
INSERT INTO gyrNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ahere ayihive voi Jesús ipɨhañemoñeta oso ãgua ɨvɨ Galilea rupi. Aheve osepia Felipe, aipo ehi chupe: —Erio che rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","“Avɨye” ehi Felipe, ahe Pedro iyavei Andrés recua Betsaida pendar secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ipare oso Natanael reca, aipo ehi chupe: —Orosepia Poropɨ̃sɨrosar, sesendar acoi Moisés oicuachía cuachiar porocuaita resendar pɨpe aracahe, oicuachía avei sesendar Tũpa ñehe mombehusareta yuvɨreco. Ahe Jesús, José rahɨr, tecua Nazaret pendar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael rumo aipo ehi: —¿Oime pĩha yuvɨnose vahe ava avɨye vahe Nazaret pendar? —ehi. —Yaso, teresepia ru —ehi Natanael upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Acoi oyepota senise Natanael ou, Jesús sepiase, aipo ehi voi chupe: —Co mbɨa secoi judío ete ité, ndoporombopai vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","—¿Mara ere che cua eve? —ehi Natanael chupe. —Che oroepia yɨpɨve Felipe nde reca renondeve ɨvɨra higueravrɨve ereicose —ehi Natanael upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","—Porombohesar, ¡nde niha Tũpa Rahɨr ereico, Israel ɨguar rerecuar guasu! —ehi Natanael chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—¡Che reroya voi eté acoi, “Oroepia ɨvɨravrɨve” che he sui tẽi eve! Eresepiara rumo co mbahe sui avɨye catu vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iyavei aipo ehi opacatu upe: —Supi eté pesepiara ɨva oyemboi tuprɨse iyavei Tũpa rembiguai eta igüeyɨse che, Ava Rɨquehɨr, upe, iyevɨse avei ɨvave yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ipare imombosapɨsa arɨ pɨpe, oime mendasa tecua Caná ve, Galilea ɨvɨ rupi. Jesús sɨ avei secoi aheve, ");
INSERT INTO gyrNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","iyavei Jesús ore semimbohe oroico vahe reseve ore soho avei yuvɨreco aheve. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ẽgüe ehi rumo opa tẽi uva rɨcuer. Evocoiyase Jesús sɨ, —Ndipo iri uva rɨcuer —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—Cuña, ¿mahera vo aipo ere cheu? Che remimbotar rumo arɨ ndoyepota vɨtei cheu —ehi osɨ upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ichɨ rumo aipo ehi ava ɨgua rese ihañeco vahe upe: —Peyapo opacatu semimbotar pe cuaise —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aheve oime seis cambuchi guasu ita cuhi apoprɨ, ñepei-pei cambuchi pɨpe oique cincuenta litro, amove oique setenta litro ɨ ipɨpe. Ahe judío oiporu pietase oyepoi ãgua yuvɨreco Tũpa porocuaita mboavɨye ãgua yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Evocoiyase ahe ava ɨgua rese ihañeco vahe upe aipo ehi: —Pemboapɨpopa co cambuchi ɨ pɨpe —ehi. Omboapɨpopa tuprɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Evocoiyase aipo ehi ava ihañeco vahe upe: —Penosemi chĩhi, peraso pieta rese hañecosar uve —ehi. Ẽgüe ehi eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ihañeco vahe pieta rese osãha ɨ oyeapo vahe uva rɨcuer. Ndoicuai eté que sui osẽ ahe uva rɨcuer; ɨgua rese ihañeco vahe güeraño tuprɨ oicua yuvɨreco. Evocoiyase pieta rese hañecosar oñehe cuimbahe omenda vahe upe ");
INSERT INTO gyrNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aipo ehi chupe: —Opacatu ava omondo uva rɨcuer avɨye catu vahe yɨpɨndar. Ipare acoi ava hɨ̃taropase yuvɨreco, omondo ndasepɨi vahe. Nde rumo ereyapocatupaño avɨye catu vahe, ahe cũritei ramo erenose —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Co yɨpɨndar vahe poromondɨisa Jesús oyapo vahe aheve. Ipɨpe omboyecua güeco pĩratasa. Sese semimbohe vɨroya ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ipare oso tecua Capernaum ve, ichɨ avei, tɨvrɨ reseve supive, iyavei ore semimbohe eta oroso supi. Aheve oroico movɨro arɨ tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ipare judío upendar Pascua pieta yepota senise, Jesús oso Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aheve osepia tũparo guasu pɨpe corero ɨvɨpɨ rupi guarepochi rese mbahe mɨmba eta mondosar; guaca, ovesa iyavei apɨcasu. Aheve avei mbɨa guarepochi recuñarosar yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Co mbahe repiase rumo, Jesús oyapo tucumbo omombopa tuprɨ tũparo sui opacatu ava imbahe reseve-seve, seimba ovesa, seimba guaca avei. Guarepochi recuñarosar sui otɨapɨ-apɨi iguarepochi ɨvɨ rupi, iyavei imesa opa omombo. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Apɨcasu mondosareta uve aipo ehi: —¡Penosepa co mbahe cũritei ave sui! —ehi—. ¡Aní che Ru rẽta mbahe mondosa tẽi pereco! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Aipo hese, ore oroyemomahenduha ñehesa icuachiaprɨ aracahendar aipo ehi vahe rese: “Nde rẽta rese che recatẽhɨsa sui che mocañɨra” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Evocoiyase judío mborerecuar yuvɨrecoi vahe oporandu yuvɨreco chupe: —¿Mbahe vo ereyapora nde mborerecuasa moporẽhɨ ãgua oreu cũritei? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Evocoiyase, —Pemondurupa co tũparo, che evocoiyase mbosapɨ arɨ rupive amopuha irira —ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aipo hese, mborerecuar aipo ehi yuvɨreco chupe: —Co tũparo rumo imopuhasa cuarenta y seis aravɨter rupi, ¿ereicatura pĩha aipo nde imopuha iri mbosapɨ arɨ rupive? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Oñehese Jesús tũparo rese, güete upe tẽi rumo aipo ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ocuerayevɨse rumo manosa sui, ore oroyemomahenduha iñehe agüer rese. Sese orovɨroya sesendar ñehesa icuachiaprɨ pɨpe iyavei semimombehugüer. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús secoi vɨtese Jerusalén ve Pascua pieta pɨpe, setá ité ava vɨroya osepiase poromondɨisa sembiapo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ndoyeroyai eté rumo ahe ava eta rese. Esepia, opacatu ité ava recocuer oicua. ");
INSERT INTO gyrNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ndipoi eté que ambuae ava pɨhañemoñeta mombehu ãgua chupe. Esepia, ahe ité opa oicua. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oime mbɨa fariseo, Nicodemo serer vahe, ahe mbɨa mborerecuar judío pãhuve secoi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ahe oso Jesús pɨri pɨ̃tu pɨpe, aipo ehi chupe: —Porombohesar, oroicua ité Tũpa nde mbouse ore mbohe ãgua —ehi—. Esepia, ndipoi eté que ava oicatu vahe evocoi nungar poromondɨisa apo Tũpa oyese secoẽhɨse —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Evocoiyase, —Supi eté aipo ahe ndeu: acoi ava ndoyesu pɨasu iri vahe, ndoiquei chietera Tũpa mborerecuasave —ehi Jesús chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Oporandu rumo aipo ehi: —¿Mara ehira vo aipo ava oyesu pɨasu iri ocuacua pɨpe viña? —ehi—. ¿Oicatu irira pĩha osɨ avɨterve oique oyesu iri ãgua? —ehi Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús omboyevɨ chupe: —Supi eté aipo ahe ndeu: acoi ava ɨ pɨpe iyavei Espíritu pɨpe ndoyesui vahe, evocoi nungar ndoyuvɨroiquei chira Tũpa mborerecuasave. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Acoi oyesu vahe co ɨvɨ pɨpendar oyesupa sui, inungar tuprɨ avei ahe; Espíritu pɨpe oyesu vahe rumo, ahe espíritu. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ereyepɨhamondɨi rene, ‘Peyesu pɨasu irira’ ahese ndeu. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Co rumo inungar ɨvɨtu oipeyu vahe güemimbotar rupi. Yepe sendusa sɨapu, ndicuasai rumo que sui turi, que oso no. Ẽgüe ehi avei ava oyesu vahe Espíritu pɨpe —ehi Jesús chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Mara ehi pĩha aipo evocoiyase? —ehi Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—¡Nde niha porombohesar ɨvate vahe Israel pendar ereico, nderesenducuai eté rumo co nungar mbahe! —ehi chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Supi eté aipo ahe ndeu: ore oromombehu mbahe oroicua vahe, orosepia vahe ité. Pe rumo ndaperoyai eté ore remimombehu. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Añehe tẽi niha mbahe co ɨvɨ pɨpendar rese pẽu; ndache reroyai eté rumo peye. Tahetru revo mbahe ɨva pendar amombehuse pẽu ndaperoyai chietera viña —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Esepia, ndipoi eté ambuae ava ɨvave oyeupi vahe; che güeraño, Ava Rɨquehɨr, ɨva sui agüeyɨ vahe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Inungar Moisés osupi ɨvate mboi rahanga ɨvɨ iporupɨrẽhɨsa rupi aracahe. Ẽgüe ehi aveira che, Ava Rɨquehɨr, rerecosa ɨvate che rupira yuvɨreco ");
INSERT INTO gyrNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","opacatu ava che reroyasar tecovesa apɨrẽhɨ rereco ãgua yuvɨreco” ehi Jesús Nicodemo upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Supi eté Tũpa osaɨsú iteanga opacatu ava. Sese ombou Guahɨr ñepei vahe ‘tocañɨ tẽi eme che Rahɨr reroyasar yuvɨreco’ oya, ‘tovɨreco tecovesa apɨrẽhɨ vahe’ ohesave. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Esepia, nomboui Tũpa Guahɨr co ɨvɨ pɨpe ava mocañɨ tẽi ãgua; ahe rumo ombou ava pɨ̃sɨro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ava vɨroya vahe Tũpa Rahɨr, ndahei eté ocañɨ tẽi vaherã; acoi ava ndovɨroyai vahe rumo, oipɨsɨ itera cañɨsa yuvɨreco Tũpa Rahɨr ñepei vahe reroyaẽhɨsa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ẽgüe ehi etera chupe yuvɨreco. Esepia, tesapesa supi eté vahe ou co ɨvɨ pɨpe, ahe ava rumo oipota catu mbahe Caruguar suindar pɨ̃tumimbi vahesave güeco ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Supi eté acoi opacatu ava oyapo vahe angaipa, ndosepia potai tesapesa, iyavei ndoyemboyai tesapesa rese yuvɨreco oangaipa mboyecua potaẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Acoi ava yuvɨrecoi vahe rumo mbahe supi eté vahe aposa pɨpe, oyemboya tesapesa rese yuvɨreco mbahe Tũpa remimbotar oyapo vahe cua uca ãgua opacatu ambuae ava upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ipare Jesús oso güemimbohe eta rese ambuae tecua rupi-rupi ɨvɨ Judea ve. Aheve secoi pucu raimi oporoãpiramo. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Iyavei Juan oporoãpiramo vɨte Enón ve, Salim rerovɨcave. Esepia, aheve tuvichá ɨ oime. Aheve ava yugüeru oñeapiramo uca ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Co rumo mbahe yaposa Juan roquendaẽhɨ vɨteseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Evocoiyase Juan remimbohe omboɨpɨ ambuae omu judío rese oyeecopɨ-copɨ vaherã ɨ pɨpe ñeapiramosa resendar sui tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sese yuvɨraso Juan uve aipo ehi: —Ore mbohesar, acoi secoi vahe nde rese ɨai Jordán rovai, sese acoi ereñehe oreu, cũritei ahe oporoãpiramoño tẽi iyavei opacatu yuvɨraso supi —ehi semimbohe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Evocoiyase aipo ehi güemimbohe upe: —Ava ndoicatui mbahe apo Tũpa nombouise chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Pesendu tuprɨ ité che ñehe cuese: “Che ndahei Poropɨ̃sɨrosar aico, che rumo senonde imbouprɨ tẽi aico” ahese pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Esepia, acoi mendasa oimese, vɨreco vahe güembirecovɨ ahe imevɨ, osenduse rumo imborɨpar iñehe yɨvɨi ohã, oyembovɨharete sese. Ẽgüe ahe avei che cũritei, ayembovɨharete Jesús rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ahe niha seco ɨvate catu-catuño itera arɨ rupi oico; che rumo ɨvɨ cotɨ catu aicora ichui —ehi Juan güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ɨva suindar ou vahe ɨvate catu ité opacatu sui. Co ɨvɨ pɨpe oyesu vahe rumo co ɨvɨ pɨpendar ité. Sese niha mbahe ɨvɨ pɨpendar rese tẽi oñehe. Acoi ou vahe rumo ɨva sui, ɨvate catu ité opacatu sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Iyavei mbahe güembiepia osendu vahe reseño ité oñehe. Ndipoi eté rumo semimombehu vɨroya vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Acoi ava vɨroya vahe rumo iñehe, “Supi tuprɨ ité Tũpa omombehu mbahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Co Tũpa remimbou niha omombehu Tũpa ñehe. Esepia, Tũpa omondo ité oEspíritu sese. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tũpa osaɨsu Guahɨr iyavei opacatu mbahe omondo ipove. ");
INSERT INTO gyrNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Opacatu ava vɨroya vahe Tũpa Rahɨr, vɨreco ité tecovesa apɨrẽhɨ; acoi ndovɨroyai vahe rumo, ndovɨrecoi chietera co tecovesa. Ahe rumo oipɨsɨra Tũpa ñemoɨrosa ipĩrata vahe ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo eta oyandu yuvɨreco Jesús vɨreco catuse ava oyeupi oguata vahe iyavei oporoãpiramo catuse avei Juan sui ");
INSERT INTO gyrNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(ndahei eté rumo Jesús oporoãpiramo; semimbohe tẽi rumo ẽgüe ehi yuvɨreco). ");
INSERT INTO gyrNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","4","Jesús oicuase aipo nungar, osẽ Judea sui, oyevɨ iri ɨvɨ Samaria rupi, Galilea ve yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Aheve Samaria ɨvɨ rese oyepota tecua Sicar serer vaheve yuvɨreco. Ahe tecua rerovɨcave oime ɨvɨ Jacob omondo vahecuer guahɨr José upe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aheve oime ɨvɨcuar, chupe, “Jacob ɨguagüer” ehi yuvɨreco. Ahe ɨgua rembe rese Jesús oguapɨ mbɨter arɨ potase ocueraise oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Semimbohe eta rumo opacatu yuvɨraso tecuave mbahe tembihu rerocua. Aheseve cuña, Samaria pendar, oyepota ɨguave ɨ renose. Ahese Jesús aipo ehi chupe: —Emboumi chĩhi nde ɨ taɨhu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Cuña, Samaria pendar, rumo omboyevɨ chupe: —¿Mahera vo, “Embou ɨ taɨhu” ere cheu? Nde rumo judío; che cuña coha pendar aico —ehi chupe. (Esepia, judío noñehei vahe ité ava Samaria pendar upe yuvɨreco yepi.) ");
INSERT INTO gyrNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Evocoiyase omboyevɨ cuña upe: —Ereicuase Tũpa porerecosa ndeundar viña iyavei ereicuase ahe ava ndeu ɨ rese oporandu vahe, nde evocoiyase ereporandura sese chupe. Ahe evocoiyase omondora ɨ ndopai vahe ndeu viña —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Ndererecoi rumo ɨ renose ãgua. Esepia, co ɨgua ipɨcucú ité. ¿Que sui vo aipo evocoiyase eremboura ɨ ndopai vahe cheu viña? —ehi cuña chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Esepia, co ɨgua ore ramoi Jacob oseya oreu. Cohave suiño ité niha ahe oɨhu, tahɨr avei oɨhu yuvɨreco ichui iyavei opacatu seimba. ¿Nde pĩha ɨvate catu ereico ichui? —ehi cuña chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Opacatu ava oɨhu vahe co ɨ, ihuseiño itera yepi, —ehi cuña upe—. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Acoi ava oɨhu vahe rumo ɨ che remimondo, ndihusei iri chietera. Esepia, che amondo vahe ɨ ndopai vaherã ité. Ahe omboura tecovesa ndopai vahe ava upe —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Nde ava, emboumi ahe ɨ taɨhu che husei iriẽhɨ ãgua, tanose iri eme ɨ cohave sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Eso rane nde mer reca, seseve peyu cohave —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Ndarecoi rumo che mer —ehiño cuña chupe. —Supi eté aipo ere, ndererecoi eté nde mer. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Esepia, cinco tuprɨ erereco nde mer iyavei cũritei erereco vahe nde resendar tẽi. Supi eté aipo ere: “Ndarecoi che mer” ere cheu —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Nde ava avɨye moco Tũpa ñehe mombehusar ereico cheu —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ore ramoi eta omboetei Tũpa co ɨvɨtrɨ rese yuvɨreco. Pe rumo, judío peico vahe, “Jerusalén ve yamboeteira Tũpa yepi” peye —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—Che reroya eve cuña, vɨrovɨ arɨ pẽu peso iriẽhɨ ãgua Tũpa mboetei co ɨvɨtrɨ rese iyavei Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pe Samaria pendar peico vahe pemboetei tẽi pe rembiguaẽhɨ. Ore rumo oroicua oromboetei vahe. Esepia, ñepɨsɨrosa ou judío sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Oyepota rumo arɨ cute, ahe ité co cũritei co pɨpe suive supi eté Tũpa omboetei vahe, Tũpa Espíritu pɨpe omboeteira yuvɨreco. Supi eté Tũpa, “Ẽgüe tehi che mboetei yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Esepia, Tũpa niha Espíritu secoi. Sese acoi omboetei vahe oyapora Espíritu pɨpe supi tuprɨ vahe ité yuvɨreco —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Cuña evocoiyase aipo ehi chupe: —Che aicua Poropɨ̃sɨrosar yu ãgua (ahe ‘Cristo’). Acoi ahe ouse, omombehu tuprɨra opacatu mbahe yandeu —ehi cuña chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Che niha ahe aico añehe vahe ndeu —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Aheseve semimbohe eta oyevɨ yuvɨreco, nombovɨhaiprɨ güemimbohe cuña rese oñemoñetase. Ndipoi eté rumo que “¿mbahe rese vo peñemoñeta?” ehi vahe, que “¿mahera vo ereñehe co cuña upe?” ehi vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ahese cuña oseya tuprɨño ocambuchi, oso güecuave aipo ehi ava eta upe: ");
INSERT INTO gyrNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Perio, tapesepia pe ava omombehupa tuprɨ vahe che recocuer cheu. ¿Ndahei pĩha ahe Poropɨ̃sɨrosar? —ehi omu eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Evocoiyase ava rehɨi yuvɨnose tecua sui, yuvɨraso Jesús recosave sepia. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ava yepotaẽhɨ vɨteseve, semimbohe eta, —Ore mbohesar, ecarumi —ehi tẽi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Oimera rumo ambuae mbahe cheu che movɨracua ãgua. Ahe ndapeicuai vahe —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Semimbohe aipo hese oporandu-randu tẽi oyeupe yuvɨreco: —¿Oime pĩha que ava güeru vahe mbahe semihura? —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Güemimbohe upe rumo aipo ehi: —Che movɨracuasa rumo che mbousar porocuaita, ahe ayapora iyavei amboavɨye rane itera iporavɨquɨ —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Esepia, pe aipo peye: ‘Ipane vɨte irungatu yasɨ mbahe mitɨ ha monuha ãgua’ peye yepi; che rumo aipo ahe pẽu: pemahe pe ɨvɨrindar ava eta rese. Opa ité opɨha omoingatu yuvɨreco, ahe inungar mbahe mitɨ ha yavɨye vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Acoi oporavɨquɨ vahe Tũpa upe ava hã pɨsɨ ãgua rese, ahe oipɨsɨra seprɨ yuvɨreco iyavei semimonuha tecovesa ndopai vaheve nara ité yuvɨrecoira. Evocoiyase ava upe oñehe vahe iyavei oipɨsɨ vahe ava hã ɨvave nara, oyoya guasu ovɨharetera ipɨsɨprɨ rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Supi eté co ñehesa aipo ehi vahe: ‘Ñepei eté omahetɨ vahe; imonuhasar rumo ambuae ité’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Che opocuai ava hã pɨsɨ ãgua ambuae ava poravɨquɨsave; yɨpɨndar rumo ambuae oporavɨquɨ́ ité yuvɨreco sese. Pe evocoiyase peique iporavɨquɨ agüer rupi —ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Setá ava tecua Sicar pendar Samaria pɨpe vɨroya cuña ñehe sui yuvɨreco, “Opacatu mbahe che rembiapo omombehu cheu” ihesa sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Evocoiyase ava rehɨi Samaria pendar yuvɨraso chupe ‘epɨtami ore pɨri’ oya. Evocoiyase opɨta ipɨri ñuvɨrío arɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Setá catu iri ava vɨroya yuvɨreco iñehe ité renduse. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Evocoiyase ava eta aipo ehi cuña upe yuvɨreco: —Cũritei orovɨroya ité cute, ndahei nde ñehe suiño orovɨroya. Esepia, ore ité orosendu iñehe cute, oroicua avei ahe supi eté opacatu ava pɨ̃sɨrosar ou vahe —ehi ava eta cuña upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ñuvɨrío arɨ pare, Jesús osẽ ɨvɨ Samaria sui, osoño ɨvɨ Galilea ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ahe ae ité aipo ehi: “Tũpa ñehe mombehusar ndasaɨsusai iɨvɨ rese yuvɨreco yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Oyepotase oɨvɨ Galilea ve, ahe pendar ava oipɨsɨ tuprɨ yuvɨreco. Esepia, setá osepia opacatu mbahe sembiapo Pascua pietase Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Evocoiyase oyevɨ iri tecua Caná ve Galilea ɨvɨ rese, aheve acoi ɨ tẽi oyapo uva rɨcuer. Tecua Capernaum ve oime mbɨa mborerecuar guasu ɨvɨrindar. Ahe vɨreco guahɨr imbaheasɨ vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Oyanduse co mbɨa mborerecuar Jesús yepota Judea sui ɨvɨ Galilea ve, ahe ramoseve oso voi seca ‘toso che rẽtave, tombogüerami che rahɨr omano pota vahe cheu’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Evocoiyase aipo ehi ahe mborerecuar upe: —Pe ndache reroyai eté peye ndapesepiaise mbahe poromondɨisa che rembiapo —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—Che Yar, eyu poyavañomi tẽi che rahɨr mano vɨteẽhɨseve —ehi mborerecuar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Eyevɨ nde rẽtave; nde rahɨr oicove —ehi mborerecuar upe. Ahese vɨroya voi oyeupe ñehesa. Sese oyevɨ voi eté güẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Amombrɨ seco vɨteseve, yuvɨnoña voi sovaĩchi sembiguai imombehu: —¡Nde rahɨr oicove! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Evocoiyase oporandu: “¿Mbahe hora pɨpe tuprɨ ocuera?” ehi. —Irapɨpe caharuse, la una pɨpe, ndasohɨ iri —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ahese mborerecuar ipɨhañemoñeta: “Ahe hora pɨpe tuprɨ niha Jesús aipo ehi cheu: ‘Nde rahɨr oicove’ ehi” ehi. Evocoiyase ahe iyavei opacatu imu eta vɨroya Jesús yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Co imoñuvɨriosa poromondɨisa oyapo Jesús güecocuer cua uca ãgua ɨvɨ Judea sui oyevɨse Galilea ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ipare oime judío pieta guasu Jerusalén ve, aheve Jesús oso. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ahe tecua roquendɨpɨ, Ovesa serer vahe cotɨ, oime ɨvɨcuar ɨ vɨreco vahe, serer hebreo ñehe pɨpe Betzata. Ahe sese oyere tuprɨ poyandepo oquendɨpɨ yapayere vahe pãve. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Aheve ava eta imbaheasɨ vahe oñeno yugüeru ɨvɨ rupi: ndasesapɨsoi vahe, ndoguatai vahe, ndipɨndugüei vahe avei ɨ ñemomɨisa osãro yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Esepia, amove tẽi Tũpa rembiguai ogüeyɨ ahe ɨvɨcuarve ɨ momɨi ãgua, “Acoi ahe rane ocui vahe ɨ ñemomɨiseve ɨve, ocuera voi eté ombaherasɨsa sui” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aheve oime mbɨa ombaherasɨsa vɨreco vahe treinta y ocho aravɨter rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Osepiase Jesús, oicua voi eté vɨreco pucuse ombaherasɨsa. Evocoiyase oporandu chupe: —¿Ereipota vo nde cuera ãgua? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Imbaheasɨ vahe omboyevɨ: —Nde mbɨa, ndipoi eté que ava che mongui vaherã ɨ pɨpe ɨ ñemomɨise. Asãha tẽi ‘tacui’ viya. Ambuae rane-raneño rumo yuvɨrocui che sui yepi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Evocoiyase, —Epũha, esupi nde rupa, eguata —ehi imbaheasɨ vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ahe ramoseve ahe mbɨa ocuera tuprɨ, osupi vupa, oguata voi oico. Mbɨtuhusa arɨ pɨpe tuprɨ rumo ẽgüe ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Evocoiyase judío aipo ehi ocuera vahecuer upe yuvɨreco: —Co pɨpe rumo mbɨtuhusa arɨ, nande cuaitai nde rupa rese ndevosɨi ãgua —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ahe mbɨa evocoiyase, —Che mbogüerasar rumo aipo ehi cheu: ‘Esupi nde rupa, eguata’ ehi cheu —ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Uma vo aipo ehi ndeu? —ehi judío yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ahe mbɨa rumo ndoicua iri ombogüerasar. Sese ndoicatui imboyevɨ ãgua. Esepia, Jesús avɨyeteramo tẽi ndoyecua iri ava rehɨi pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Coiye rumo Jesús osepia iri tũparove ahe mbɨa, aipo ehi chupe: —Ereicua co nde cuerasa cũritei, aní ereyemboangaipa iri mbahe tẽi catu reime iri ãgua ndeu —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ahe mbɨa evocoiyase oso voi eté judío eta rerecuar upe ‘Jesús che mbogüera’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sese judío osaquɨcue moña iyavei oyuca pota yuvɨreco mbɨtuhusa arɨ pɨpe iporombogüera rese tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ahe rumo aipo ehi: —Che Ru niha oporavɨquɨño ité co arɨ rupi iyavei che aporavɨquɨño avei —ehiño judío upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aipo hese, judío, “Yayuca ité” ehi. “Esepia, ndahei mbɨtuhusa arɨ güeraño nomboyeroyai, ahe rumo oyeapo Tũpa nungar, Tũpa uve ‘che Ru’ ohe angahu tẽisa pɨpe” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Evocoiyase Jesús aipo ehi judío upe: “Supi eté aipo ahe: Tũpa Rahɨr ndoicatui eté mbahe apo oyesui tẽi, Vu rembiapo mbahe oicua; aheño tuprɨ avei oyapo yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Esepia, Tu Guahɨr raɨsupave omboyecua opacatu mbahe güembiapo chupe iyavei omboyecuaño vɨte itera mbahe poromondɨisa tuvicha catu vahe sembiaporã, ‘¡Mara ehi rutei co!’ pehe tẽi ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Esepia, che Ru ombogüerayevɨ omano vahe iyavei omondo tecovesa chupe. Ẽgüe ehi avei Tahɨr omondo tecovesa ava upe güemimbotar rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Iyavei Tu nomondo iri ava upe sembiapo reprɨ. Esepia, ombou Guahɨr upe opacatu pĩratasa ava upe sembiapo reprɨ mondo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ẽgüe ehi Guahɨr upe opacatu ava imboetei ãgua yuvɨreco inungar Tu imboeteiprɨ. Acoi ava Tahɨr nomboetei vahe, Tu imbousar avei nomboetei yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Supi eté aipo ahe pẽu: acoi oyapɨsaca vahe che ñehe rese, vɨroya vahe avei che mbousar, ahe vɨrecora tecovesa apɨrẽhɨ vahe; ndahei chietera imocañɨprɨ. Esepia, osẽ manosa sui oipɨsɨ tecovesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Supi eté aicua uca pẽu: oura arɨ imombehuprɨ, cũritei eté co arɨ oyepota, ava eta omano vahecuer osendura Tũpa Rahɨr ñehe. Acoi osendu vahe, oicoveño itera. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Esepia, Tu vɨreco tecovesa oyese. Ẽgüe ehi avei Guahɨr upe imondo tecovesa rereco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ombou avei imborerecua ãgua chupe ava recocuer rese iporandu ãgua. Esepia, ahe Ava Rɨquehɨr secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Peyepɨhamondɨi rene aipo che hesa sui. Esepia, oyepotara arɨ imombehuprɨ, ahese opacatu ava omano vahecuer osendura iñehe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ahese yuvɨnosera vuvɨpa sui. Oyapo vahe mbahe tuprɨ, ocuerayevɨra yuvɨreco tecovesa apɨrẽhɨ rereco ãgua; acoi oyapo vahe rumo mbahe naporai vahe, ocuerayevɨra yuvɨreco Tũpa ñemoɨrosa pɨsɨ ãgua” ehi Jesús judío rerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Che ndaicatui mbahe apo cheyesui tẽi. Che, ‘Pe peyavɨ vahe mbahe, peipɨsɨra che Ru ñemoɨrosa’ ahe ava ndaseco põrai vahe upe che cuaita rupi iyavei che amombehu vahe supi tuprɨ ité. Esepia, che ndaipotai che remimbotar tẽi mbahe apo ãgua. Che Ru, che mbousar remimbotar rumo ayapo. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Que cheyese ae tẽi añehese, ahese ndache reroyai chira peye viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Oime rumo ambuae che mombehusar. Ahe supi eté che mombehu pe seroya ãgua; ahe Juan. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pe niha, pemondo ava chupe imboporandu mbahe rese. Ahe semimombehu niha supi tuprɨ vahe ité. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yepe ahe supi eté viña, che rumo ndayeroyai ava tẽi che mombehusa rese. Che rumo aipota peñepɨsɨro ãgua. Sese aipo ahe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan niha inungar tataendɨ, ẽgüe ehi omboyecua mbahe supi eté vahe. Sese pe peyembovɨha raimi tẽi iporombohesa tesapesa nungar pɨpe peico. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Che rumo areco che yecua ucasar avɨye catu vahe Juan sui. Ahe niha co mbahe ayapo vahe yepi. Ahe sese che Ru che cuai yapo ãgua. Co mbahe ayapo vahe, ahe ité omboyecua che Ru Tũpa che mbousar. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Iyavei che Ru avei eté che cua ucasar. Ahe iñehe rumo ndapesendui vahe ité, iyavei ahe ndapesepiai eté. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Iñehengagüer icuachiaprɨ avei ndoiquei eté pe rese. Ipɨpe niha ndache reroyai eté peye che Ru che mbouse. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pe peicua tuprɨ pota icuachiaprɨ ‘icuapa tuprɨ pɨpe revo tecovesa apɨrẽhɨ yarecora’ peye viña. Co rumo cuachiar che mombehu vahe: ");
INSERT INTO gyrNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","pe rumo ndapeyu potai eté cheu co tecovesa apɨrẽhɨ rereco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ndaipɨsɨi eté ava che mboeteisa tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iyavei opocua Tũpa ndapesaɨsuise. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Che niha ayu che Ru rer pɨpe. Pe rumo ndache reroyai eté peye. Ouse rumo que ambuae ava oyesui tẽi oñehe vahe, evocoi nungar tẽi peroyara. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ndapeicatui eté che reroya ãgua peye. Esepia, pe ae tẽi peyemboetei; ndapesecai eté Tũpa ñepei vahe suindar yemboeteisa. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ndapepɨhañemoñetai chira che pe recocuer mombehu ãgua rese che Ru rovai. Moisés peroya vahe ité niha oicuachía pe Tũpa reroyaẽhɨsa chupe imombehu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Peroyase rumo Moisés ñehe viña, che avei che reroyara peye viña. Esepia, Moisés niha oicuachía che resendar ñehesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ndaperoyaise ahe sembicuachía, evocoiyase ndapeicatui chietera che remimombehu reroya ãgua” ehi Jesús oamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Ipare Pascua pieta ɨ̃pɨimi aipo Jesús osasa ɨpa Galilea serer vahe oso, ahe serer avei Tiberias. Ava rehɨi avei yuvɨraso saquɨcuei. Esepia, osepia ité yuvɨreco oyapose mbahe poromondɨisa guasu imbaheasɨ vahe mbogüerase. Oyepotase ɨvɨ rese yuvɨraso, evocoiyase oyeupi ɨvɨtrɨ rese. Aheve oguapɨ opacatu güemimbohe eta reseve yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","6","Omahese ava rehɨi oyeupindar rese, ahese aipo ehi Felipe upe: —¿Que vo yarocuara mbahe tembihu co opacatu ava upe nara? —ehi secoãhasave. Ahe rumo oicua ité mbahe güembiaporã. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Evocoiyase Felipe omboyevɨ chupe: —Dosciento denario pan ndosupitɨi chietera que chĩhi-chĩhimi ava retacuer viña —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Aipo hese, ñepei semimbohe pãhu pendar, Simón Pedro rɨvrɨ, Andrés aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Co chĩhivahe vɨreco cinco pan, iyavei ñuvɨrío pira, ¿iyacatura vo co ava retacuer? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Evocoiyase aipo ehi: —Pemombehu opacatu upe toguapɨ yuvɨreco —ehi güemimbohe upe. Capihi reimesave opa omboguapɨ yuvɨreco cinco mil ava. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Evocoiyase oipɨsɨ cinco vahe pan, “Avɨye ndeu” ohe pare Vu Tũpa upe, opa ombohi-mbohi imondo ava rehɨi upe. Ẽgüe ehi avei pira upe, imondopa semimbotar rupi-rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Opase ava ihɨ̃taro, —Pemonuhapa sumbɨrer iyemombucaẽhɨ ãgua —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Evocoiyase omonuha doce ɨruova sumbɨrer yuvɨreco pan cincomi vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Evocoiyase ava eta co poromondɨisa guasu Jesús rembiapo repiase, aipo ehi yuvɨreco: —Supi eté co uve revo acoi: “Oura Tũpa ñehe mombehusar ɨvɨ pɨpe” ehi icuachiaprɨ aracahendar pɨpe —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús rumo oicuase ava opĩratasa pɨpe tẽi güeraso pota ãgua mborerecuar guasu vɨreco ãgua oyeupe nara yuvɨreco, ahese oyeupi iri oso ɨvate catu. Aheve ahe ae güeco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pɨ̃tu ramose ogüeyɨ yuvɨraso Jesús remimbohe ɨpave, ");
INSERT INTO gyrNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","yuvɨroha carite pɨpe sasa ãgua yuvɨreco tecua Capernaum ve yuvɨraso. Ahese pɨ̃tu ité. Jesús rumo ndoyevɨ vɨtei eté. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ahese oipeyu pĩrata ɨvɨtu, ɨ avei ohɨtu pĩrata. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yuvɨraso pucumi tẽi cinco, anise seis kilómetro rupi. Ahese osepia Jesús yuvɨreco osupitɨ senise carite. Ahe ɨ harɨ rupi oguata oso chupe. Evocoiyase osɨquɨye ité yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ahe rumo aipo ehi güemimbohe upe: —¡Che Jesús aico, pesɨquɨyei rene! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Evocoiyase sorɨvete yuvɨreco carite pɨpe seroha. Iparemi tẽi oyepota yuvɨraso oyuvɨrasosave. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ahere ayihive ava rehɨi opɨta vahe sovai yuvɨreco, “Semimbohe año rumo yuvɨraso ñepei vahe carite pɨpe. Jesús rumo ndosoi eté güemimbohe rupi” ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aheseve rumo ambuae carite vɨroyepota seru yuvɨreco tecua Tiberias pendar, acoi Jesús ava remihura pan reroyeroquɨ agüer rerovɨcave. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Evocoiyase ava rehɨi oicuase Jesús semimbohe reseve iporẽhɨse yuvɨreco, yuvɨroha yuvɨraso ãgua co ambuae carite pɨpe tecua Capernaum ve seca. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Oyepotase ava rehɨi ɨpa rovai, aheve osepia Jesús yuvɨreco. —Ore mbohesar, ¿marase vo ereyepota cohave? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Evocoiyase aipo ehi chupe: —Supi eté aipo ahe pẽu. Pe rumo che reca peye che pe mbocarusa rese tẽi,, ndahei co che poromondɨisa reroyasave ité peico pota che rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Peporavɨquɨ eme catu tembihu ndasecosei vahe rese; iyacatu rumo peporavɨquɨ tembihu secose vahe rese omondo vahe tecovesa apɨrẽhɨ. Co tembihu che, Ava Rɨquehɨr, amondora pẽu. Esepia, che Ru Tũpa omboyecua ité che ichuindar aicose —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Aipo hese, —¿Mbahe mboravɨquɨ vo oroyapora Tũpa upe? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Tũpa oipota pe che reroyara peye che semimbou che recose —ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Evocoiyase, —¿Mbahe poromondɨisa vo eremboyecua irimira oreu orosepia vaherã nde reroya tuprɨ catu ãgua? ");
INSERT INTO gyrNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Esepia, aracahe ore ramoi eta yuvɨrohu ɨvɨ iporupɨrẽhɨsa rupi. Icuachiaprɨ aracahendar pɨpe omombehu: ‘Omondo pan ɨva pendar semihura’ ehi —ehi ava eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Supi eté amombehu pẽu: ndahei Moisés omondo pan ɨva pendar chupe, che Ru rumo omondo chupe. Cũritei che Ru ombou pẽu pan supi eté vahe ɨva sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Esepia, co pan ombou vahe Tũpa ɨva suindar ité. Ahe omondora tecovesa ɨvɨ pɨpendar upe —ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Evocoiyase, —Ore mbohesar, embouño catu co pɨpe suive aipo pan oreu —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—Che ité ahe pan aico tecovesa mondo ãgua. Acoi ou vahe cheu ndiyumbɨasɨ iri chietera iyavei acoi che reroya vahe ndihusei chiaveira. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aipo ahe niha acoi pẽu. Yepe pe che repia peye viña, pe rumo ndache reroyai eté peye. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Opacatu ombou vahe ava che Ru cheu, cheu ité yugüerura; acoi yugüeru vahe cheu, aipɨsɨra; ndamomboi chietera cheyesui. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Esepia, ndayui ɨva sui mbahe che remimbotar apo ãgua tẽi; ayu rumo che mbousar porocuaita apo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Che Ru che mbousar ndoipotai que ñepei ava ombou vahe cheu amocañɨra. Ahe semimbotar rumo che ambogüerayevɨra ahe arɨ ipa vahe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Che Ru oipota avei opacatu ava oyeroya vaherã che, Tũpa Rahɨr, che recosa rese. Ipɨpe vɨreco aveira tecovesa apɨrẽhɨ vahe yuvɨreco. Supi eté ambogüerayevɨra arɨ ipa vahe pɨpe curi —ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Evocoiyase judío eta oñehe-ñehe tẽi sese yuvɨreco, “Che pan aico, agüeyɨ vahe ɨva sui” ihesa rese ");
INSERT INTO gyrNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","aipo ehi: —Co niha acoi Jesús, José rahɨr. Yande yaicua ité tu, ichɨ avei. ¿Mahera ru, “Che agüeyɨ vahe ɨva sui” ehi no? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Evocoiyase judío eta upe aipo ehi: —Pepoiño che reroɨ̃rosa sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ndipoi chietera que oicatu vahe ou cheu, nomonguerẽhɨise che Ru che mbousar; omonguerẽhɨ vahe rumo oicatu yugüeru cheu. Ahe ambogüerayevɨra arɨ ipa vahe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tũpa ñehe mombehusar cuachiar pɨpe aipo ehi: ‘Tũpa pe mbohera opacatu’ ehi. Sese acoi osendu vahe che Ru ñehe, oyembohe vahe avei sese, evocoi nungar yugüerura cheu. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Ndipoi eté que ñepei ava osepia vahe che Ru; acoi ichui ou vaheño ité, ahe güeraño tuprɨ ité osepia. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Supi eté aipo ahe pẽu: acoi che reroya vahe vɨreco tecovesa apɨrẽhɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Che pan nungar aico amondo vahe tecovesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aracahe pe ramoi eta niha yuvɨrohu ité tembihu maná serer vahe ɨvɨ iporupɨrẽhɨsa rupi. Ahe rumo opa iriño ité omano yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Che rumo añehe pan ɨva sui ogüeyɨ vahe rese, acoi ava ohu vahe, nomanoi chietera. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ahe pan oicove vahe niha che aico ɨva sui ogüeyɨ vahe; acoi ohu vahe co pan, oicovera apɨrẽhɨ vaherã ité. Co pan amondo vaherã, ahe che rete ité. Ahe amondora ava recocuer rese” ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Aipo hese, judío rerecuar oyeecopɨ-copɨ yuvɨreco aipo ehi: —¿Mara ehira vo aipo co imbou tẽi güete yande tohu viña? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—Supi eté aipo ahe pẽu: ndapehuise Ava Rɨquehɨr rete, ndapeɨhuise avei suvɨ, ndaperecoi chietera tecovesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Acoi ohu vahe che rete, oɨhu vahe avei che ruvɨ, vɨreco tecovesa apɨrẽhɨ iyavei che ambogüerayevɨra arɨ ipa vahe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Esepia, che rete supi eté vahe tembihu; che ruvɨ supi eté vahe avei ɨgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Acoi ohu vahe che rete, oɨhu vahe avei che ruvɨ, secoi che rese, che avei aico sese. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Che Ru, che mbousar, vɨreco tecovesa. Ichui che aicove; ẽgüe ehi aveira che husar che sui yuvɨrecovera. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Añehe pan ɨva sui ogüeyɨ vahe rese. Co pan ndahei maná pe ramoi eta yuvɨrohu vahe nungar. Esepia, yande ramoi opaño ité omano yuvɨreco. Acoi ohu vahe rumo co che rete, oicovera apɨrẽhɨ vaherã ité —ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús oporombohe co mbahe rese judío ñemonuhasave tecua Capernaum ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Osenduse co yembohesa, setá Jesús rupi oguata vahe aipo ehi oyeupe yuvɨreco: —Aipo semimombehu yavai eté seroya ãgua; ¿ava vo vɨroya tẽira viña? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús rumo oicua voi eté iñehe-ñehe tẽise co mbahe rese yuvɨreco, evocoiyase oporandu: —¿Pemboasɨño tie che ñehe? ");
INSERT INTO gyrNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Mara peyera pĩha che repiase peye che, Ava Rɨquehɨr, ayeupise che reco agüerve vicho viña? ");
INSERT INTO gyrNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espíritu ité niha omondo tecovesa; yande retecuer rumo ẽgüe ehi tẽi vahe. Co amombehu vahe pẽu ahe espíritu iyavei tecovesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Oime vɨte rumo amove pe pãhuve ndache reroyai vahe —ehi ava rehɨi upe. Esepia, Jesús oicua ité yɨpɨsuive uma ndovɨroyai chira, oicua avei uma ava omondora yamotarẽhɨmbar upe ");
INSERT INTO gyrNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","aipo ehi: —Sese niha acoi aipo ahe pẽu: “Ndipoi chietera que ava ou vaherã cheu che Ru nomonguerẽhɨise imbou” ahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ichuive tuprɨ Jesús rupi oguata vahe setá oseya yuvɨreco; ndoguata iri eté yuvɨreco supi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Evocoiyase oporandu doce tuprɨ vahe güemimbohe upe: —¿Pe avei vo che reyapa pota peye? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro rumo omboyevɨ chupe: —Che Yar, ¿ava upe vo oroso irira? Nde güeraño ité niha erereco ñehesa tecovesa apɨrẽhɨ vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ore nde reroyasar ité oroico iyavei oroicua nde ndaseco marai vahe, Tũpa supi eté vahe remimbou ereico —ehi Pedro chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Che niha opoporavo doce peico vahe, ñepei rumo pe pãhu pendar caruguar ité —ehi Simón upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús oñehe Simón Iscariote rahɨr, Judas, rese. Yepe doce semimbohe pãhu pendar viña, ahe rumo omondora ava yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ipare Jesús oguata ɨvɨ Galilea rupi. Ndoico potai eté ɨvɨ Judea rese. Esepia, aheve ava judío eta oseca ité ‘yayuca’ oya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","3","Vɨrovɨse judío pieta guasu teyupa apo ãgua yuvɨreco, ahese tɨvrɨ aipo ehi yuvɨreco chupe: —Erepɨta eme cohave. Eso ɨvɨ Judea ve; ahe pendar nde rupi oguata vahe avei tosepia poromondɨisa nde rembiapo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Esepia, acoi oyapo pota vahe mbahe, noñomi eté mbahe güembiapo. Nde ereyapo ité mbahe poromondɨisa. Sese iya eremboyecua opacatu ava upe —ehi tɨvrɨ yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Seroyaẽhɨsave tẽi avei tɨvrɨ aipo ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Evocoiyase vɨvrɨ upe aipo ehi: —Ndehi vɨtei rumo arɨ che so ãgua. Pe guata ãgua rumo opacatu arɨño tẽi avɨye. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Esepia, pe ndape amotarẽhɨi eté ava co ɨvɨ pɨpendar; che rumo che amotarẽhɨ ité yuvɨreco. Esepia, che amboyecua ité mbahe sembiapo naporai vahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pesoño pe pieta repia; che rumo ndaso vɨtei chira. Esepia, ndosupitɨ vɨtei arɨ cheundar —ehi vɨvrɨ upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Evocoiyase Jesús opɨtaño Galilea ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Vɨvɨreta so pare, Jesús avei oso pietasave. Ndoyemboyecuai eté rumo ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judío eta oseca tẽi yuvɨreco pietasave aipo ehi: —¿Que pĩha acoi mbɨa? —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ava rehɨi pãhuve setá iteanga oñehe yuvɨreco sese. Amove aipo ehi yuvɨreco: “Ahe mbɨa avɨye vahe”; ambuae rumo aipo ehi: “Ndahei avɨye vahe; ahe rumo ombopa tẽi vahe ava” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Nomboyecuai eté rumo oñehe yuvɨreco sese güerecuar sui osɨquɨyepave. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pieta mbɨterse, Jesús avɨyeteramo tẽi oique ava pãhuve tũparo pɨpe ava mbohe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judío eta rerecuar evocoiyase, —¡Too, mara ehi rutei! —ehi tẽi—. ¿Mara ehi vo co mbahecuá iteanga? ¡Ndoyembohei vahe niha yande yeroquɨsave! —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Judío rerecuar upe rumo aipo ehi: —Che porombohesa ndahei cheyesuindar tẽi, ahe rumo che mbousar suindar —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Que ñepei pe pãhu pendar oyapo potase Tũpa remimbotar, oicuara che porombohesa ndahei vahe che suindar, ahe Tũpa suindar ité. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Esepia, acoi ava oñehe vahe oyesui tẽi, ahe ‘tache mboetei ava yuvɨreco’ ohesave tẽi ẽgüe ehi. Co ava rumo “tomboetei che mbousar” ehi vahe, ahe supi eté vahe; ndipoi eté porombopasa iporombohesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moisés niha omondo tẽi mborocuaita pẽu. Que ñepei pe pãhu pendar rumo ndipoi eté omboyeroya vahe. ¿Mahera ru che yuca pota peye?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—¡Nde erereco caruguar ndeyese! ¿Ava vo nde yuca pota? —ehiño ava eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aipo ehi ava upe: —Cuese acoi ayapose mbahe mbɨtuhusa arɨ pɨpe, ahese, “¡Too, mahera ẽgüe ehi!” peyeño acoi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pe avei rumo amove peporavɨquɨ mbɨtuhusa arɨ pɨpe peporombocircuncidase porocuaita Moisés omondo vahe reroyasave. (Ahe circuncisión rumo ndahei Moisés suindar, ahe rumo yɨpɨve vahe pe ramoi suindar ité.) ");
INSERT INTO gyrNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Oyepotase rumo chĩhivahe mbocircuncida ãgua mbɨtuhusa arɨ pɨpe tuprɨ pẽu, peyapoño rane ité mborocuaita mboavɨye ãgua. ¿Mahera ru cheuño pemboasɨ ñepei mbɨa mbɨtuhusa arɨ pɨpe ambogüera tuprɨ vahe rese? ");
INSERT INTO gyrNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","“Oyavɨ evocoi” peye voi rene catu ava upe; peicua tuprɨ rane ‘¿supi eté pĩha?’ pe yapave —ehi Jesús ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Evocoiyase amove Jerusalén pendar mbɨa aipo ehi oyeupe yuvɨreco: —¿Ndahei vo acoi co oseca tẽi yuca ãgua yuvɨreco? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ahe ité co niha co ava pãhuve oñehe oico, ndipoi eté que mara ehi vahe yuvɨreco chupe. ¿Omoha pĩha mborerecuar co mbɨa Poropɨ̃sɨrosar seco ãgua yuvɨreco? ");
INSERT INTO gyrNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Yande rumo yaicua que sui turi. Acoi ouse rumo Poropɨ̃sɨrosar ité coiye, ndipoi chietera que ava oicua vahe iyusa —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Evocoiyase aipo renduse oporombohe vɨteseve tũparove, oñehe pĩrata aipo ehi: —¡Pe niha aipo, “Oroicua vahe” peye; “Oroicua avei iyusa” peye cheu! Ndayui rumo che remimbotar sui tẽi. Oime rumo che mbousar, ahe seroyaprɨ ité. Ahe pe ndapeicuai vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Che rumo aicua ité. Esepia, che ichui ayu iyavei ahe ité che mbou pẽu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Aipo ihese, oipɨsɨ pota yuvɨreco soquenda ãgua viña. Aní eté rumo. Esepia, ndoyepota vɨtei iharɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Setá iteanga rumo ava vɨroya iyavei aipo ehi yuvɨreco: —Ouse Poropɨ̃sɨrosar, ¿oyapo catura pĩha mbahe poromondɨisa co mbɨa sui? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo eta osendu ava ñehesa Jesús resendar yuvɨreco. Ahe ité iyavei pahi eta rerecuar omondo sundao tũparo rãrosar Jesús pɨsɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús rumo aipo ehi: —Aicove vɨtemira pe rese chĩhi rupive. Ipare voi ayevɨra che mbousar pɨri vicho —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Che reca tẽira peye, ndapeicatui chietera rumo che reca. Esepia, ndapeicatui chiaveira peso vaherã che recosave —ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Evocoiyase judío oporandu-randu oyeupe yuvɨreco: —¿Que pĩha aipo osora yande sui seca iriẽhɨ ãgua? ¿Osora tie que amombrɨ yande mu oñemosai vahe pãhu rupi ambuae ava ndahei vahe yande mu mbohe ãgua? ");
INSERT INTO gyrNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Mara oya pĩha evocoiyase aipo, ‘Che reca tẽira peye, ndapeicatui chietera rumo che reca. Esepia, ndapeicatui chiaveira peso vaherã che recosave’ ehi yandeu? —ehi-ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pieta ipa, ahe imboeteisa catu vahe, ahe arɨ pɨpe Jesús oñehe pĩrata ohã aipo ehi: —Acoi que ava ihusei vahe, toyugüeru cheu. Che evocoiyase tamboɨhu —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Esepia, inungar aipo ehi vahe icuachiaprɨ pɨpe, che reroyasar pɨha sui osẽra ɨai ndopai vahe nungar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","‘Che reroyasar oipɨsɨra Espíritu curi’ ohesave aipo ehi. Espíritu rumo ndou vɨtei ahese. Esepia, Jesús ahese ndoyevɨ vɨtei avei güecosa porañetesave. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Osenduse ava rehɨi aipo nungar, amove aipo ehi: —Supi eté co mbɨa Tũpa ñehe mombehusar imombehuprɨ ou vahe —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ambuae aipo ehi: —Co Poropɨ̃sɨrosar ité —ehi yuvɨreco. Ambuae rumo aipo ehi yuvɨreco: —¿Mahera aipo Galilea sui tẽi oura Poropɨ̃sɨrosar viña? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Icuachiaprɨ pɨpe rumo aipo ehi Poropɨ̃sɨrosar oyesura mborerecuar guasu David sui iyavei ahera Belén pendar, David recua pendar itera —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Evocoiyase ava oyemboyaho-yaho yuvɨreco Jesús recocuer sui tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amove ava vɨraso pota tẽi yuvɨreco soquenda; ndipoi eté rumo ẽgüe ehi vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Sundao tũparo rãrosar oyevɨ yuvɨreco Jesús recosa sui. Fariseo eta iyavei pahi eta rerecuar evocoiyase oporandu yuvɨreco chupe aipo ehi: —¿Mahera vo ndaperui! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sundao tũparo rãrosar evocoiyase aipo ehi: —¡Ndipoi eté que ava oñehe vahe ahe mbɨa nungar! —ehiño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Fariseo eta iyavei mborerecuareta evocoiyase aipo ehi yuvɨreco: —¿Pe avei eté rumo peyembopa uca chupe? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ndipoi eté niha ore mboetasa mborerecuar iyavei fariseo vɨroya vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Co ava rehɨi tẽi ẽgüe ehi yuvɨreco. Ahe rumo ndoicuai vahe Tũpa porocuaita yuvɨreco, sese iñemoɨrosavrɨve ité yuvɨrecoi —ehi sundao tũparo rãrosar upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Evocoiyase Nicodemo, acoi oso vahe pɨ̃tu pɨpe Jesús pɨri, ahe avei eté fariseo pãhuve secoi, ahe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Yandeundar porocuaita mboavɨye ãgua ndiyai, “Ereyavɨ mbahe” yahe voiño tẽi que ava mbahe sembiapocuaẽhɨ vɨteseve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Evocoiyase omboyevɨ yuvɨreco: —¿Nde avei tie ereico Galilea pendar? Eyembohe tuprɨ icuachiaprɨ pɨpe. Ipɨpe eresepiara ndipoi eté que ñepei ou vahe Galilea sui Tũpa ñehe mombehusar —ehi mborerecuareta Nicodemo upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ipare opa yuvɨraso ñepei-pei güẽta rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús rumo oso ɨvɨtrɨ Olivo ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ahere ayihive cõhese, oyevɨ tũparove. Ahese opacatu ava oyemboya yuvɨreco sese. Ahe evocoiyase oguapɨ oĩ oporombohe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Evocoiyase Moisés porocuaita rese oporombohe vahe, fariseo eta avei güeru Jesús upe cuña oyemboaguasa tẽi vahe yuvɨreco ava rehɨi rovai, ");
INSERT INTO gyrNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","aipo ehi yuvɨreco chupe: —Porombohesar, co cuña iyemboaguasase cuimbahe rese osesapɨha ñepei ava. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés porocuaita rumo ore cuai co nungar cuña yuca ãgua ita pɨpe. ¿Mara ere vo catu nde co nungar upe? —ehi fariseo eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ahe rumo secoãhasave tẽi aipo ehi yuvɨreco ‘toyavɨ angahu oñehe yandeu’ oya tẽi. Ahe rumo oyaɨvɨ, ombahecuachía ocuã pɨpe ɨvɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Evocoiyase oporandu vɨtese ava yuvɨreco, opũha aipo ehi: —Que ñepei pe pãhu pendar ndoyemboangaipai vahe, ahe rane toyapi ita pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Oyaɨvɨ iri, ombahecuachía ɨvɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Osenduse rumo judío rerecuareta, omboɨpɨ ñepei-pei yuvɨnose yuvɨreco, cuacua catu vahe sui rane yuvɨnose. Opacatu yuvɨnosepase, Jesús güerañomi cuña rese opɨta yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Evocoiyase opũhase, ahese aipo ehi chupe: —Cuña, ¿que que ru ava? ¿Ndipoi eté que ñepei opɨta vahe nde mocañɨ ãgua? —ehi ");
INSERT INTO gyrNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Aní eté, che Yar, ndipoi eté —ehi. Evocoiyase aipo ehi chupe: —Che avei ndoromocañɨ tẽi potai. Sese cũritei eso, ereyapo iri eme angaipa —ehi cuña upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús oñehe iri ava eta upe aipo ehi: —Che aico tesapesa ava eta upe. Acoi che rupi secoi vahe vɨrecora tesapesa omondo vahe tecovesa apɨrẽhɨ vahe iyavei ndaseco iri chietera pɨ̃tumimbisa nungar mbahe-mbahe tẽi vahe pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Evocoiyase fariseo eta aipo ehi yuvɨreco: —Nde ereñehe ndeyese ae tẽi. Sese nde ñehesa ndaseroyaprɨi eté —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Che ñehe rumo supi vahe ité. Yepe cheyese ae añehe viña, che rumo aicua que sui ayu, que asora no. Pe rumo ndapeicuai eté. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pe peseca ava rembiapo cua tuprɨ ãgua ava tẽi pɨhañemoñeta rupi. Che rumo ndayui evocoi nungar mbahe apo. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Asecase ava rembiapo cua tuprɨ ãgua, ahe supi tuprɨ vahe ité. Esepia, ndahei che ae tẽi ẽgüe ahe, che Ru, che mbousar rumo secoi che rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Porocuaita pẽu icuachiaprɨ pɨpe aipo ehi: “Que oimese ñuvɨrío ava oyoya tuprɨ omombehu vahe mbahe, ahese voi seroyasara” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Supi eté che ae ité niha añehe cheyese viña, che Ru, che mbousar, reseve rumo oyoya tuprɨ oroñehe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aipo ihese, oporandu yuvɨreco chupe: —¿Que vo aipo nde Ru? —ehi yuvɨreco. —Pe ndache cuai eté peye, che Ru avei ndapeicuai. Che cuase rumo peye viña, che Ru avei peicuara viña —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús aipo ehi tũparo pɨpe, guarepochi monuhaprɨ rɨru ɨpɨve oporombohe ohã. Ndipoi eté rumo ahese osoquenda vaherã. Esepia, ndoyepota vɨtei eté ahese iharɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús aipo ehi iri: —Che asose, che reca tẽira peye. Pe rumo opara pemano pe angaipa reseve. Che sosave ndapeicatui chietera peso vaherã —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aipo ihese, judío eta aipo ehi yuvɨreco: —¿Oyeyucara pĩha ahe ae; ayeve pĩha aipo ehi yandeu? —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","—Pe rumo ɨvɨ pendar peico; che rumo ɨvatendar ité aico. Iyavei pe co ɨvɨ pɨpendar tẽi avei peico; che rumo ndahei eté co ɨvɨ pɨpendar aico. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sese niha acoi aipo ahe pẽu: “Pemanopaño itera pe angaipa reseve” ahe. Esepia, ndache reroyaise peye, pe angaipa reseve ité pemanoñora —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Aipo ihese, —¿Ava ité vo nde ereico? —ehiño yuvɨreco chupe. —Yɨpɨsuive niha acoi amombehu vichico pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Setá iteanga areco che ñehe ãgua pẽu mbahe pe rembiavɨ rese. Che mbousar niha supi eté vahe. Ahe iñehe asendu vahe, amombehu opacatu ava upe —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ahe rumo ndosenducuai eté Vu rese iñehese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sese aipo ehi fariseo upe: —Pesupise rumo Ava Rɨquehɨr ɨvɨra rese, ahese voi peicuara che recocuer, ahese avei peicuara cheyesui tẽi mbahe ndayapoise; che rumo amombehu che Ru che mbohesa güeraño. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Che mbousar niha che rupive ité secoi; ndache reyai eté. Esepia, ayapoño ité mbahe semimbotar yepi —ehi ava eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Aipo ihese, setá iteanga ava vɨroya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Evocoiyase Jesús aipo ehi judío eta vɨroyasar upe: —Peico tuprɨse che ñehe rupi, peicora che remimbohe supi eté vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Peicua aveira mbahe supi eté vahe. Ahe evocoiyase pe renosera mbiguai nungar pe recosa sui —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Judío evocoiyase aipo ehi: —Ore rumo Abraham suindar ité oroico, ndoroicoi vahe ité que ava rembiguai tẽi. ¿Mahera ru aipo nde, “Pesẽra mbiguai nungar pe recosa sui” ere oreu? —ehiño judío eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Evocoiyase aipo ehi: —Supi eté aipo ahe pẽu: acoi opacatu ava oyemboangaipa vahe, inungar mbiguai tẽi, ẽgüe ehi oangaipa rereco yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mbiguai tẽi ndahei güerecuar rẽta pɨpe nara ité; tahɨr rumo opɨtaño itera güẽta pɨpe nara. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Sese Tahɨr pe renosese mbiguai tẽi pe recosa sui, supi eté ndapeico iri mbiguai nungar. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Aicua niha Abraham suindar pe recosa. Pe rumo che yuca potaño peye. Esepia, ndaperoyai eté che ñehe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Che niha amombehu che Ru mbahe omboyecua vahe cheu, pe avei peyapo mbahe pe yesupa remimombehu —ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—¡Ore yesupa rumo Abraham! —ehi judío eta yuvɨreco chupe. —Abraham suindar ité peicose, peyapora mbahe sembiapo nungar viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Che rumo, “Tũpa che mbohe mbahe supi eté vahe rese” ahe tẽi pẽu. Pe evocoiyase che yuca potaño ité peye. ¡Abraham rumo ndoyapoi eté co nungar mbahe! ");
INSERT INTO gyrNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Esepia, pe peyapo mbahe peyesupa rembiapo tẽi eté —ehi. Evocoiyase ava aipo ehi yuvɨreco: —¡Ndahei rumo ore oyesu tẽi vahe oroico; ore rumo orovɨreco ñepeiño ité ore yesupa, ahe Tũpa! —ehiño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Evocoiyase aipo ehi co judío eta upe: —Tũpa ité pe yesupase rumo, che raɨsura peye viña. Esepia, che ayu Tũpa sui. Sese cũritei cohave aico. Ndahei cheyesui tẽi ayu, Tũpa rumo che mbou. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Mahera pĩha ndapesenducua catui eté mbahe che remimombehu? Esepia, ndapeyapɨsaca potai eté che ñehe rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Peyesupa niha Caruguar ité, sese niha pe ahe tuprɨ avei peico. Peyapo pota mbahe semimbotar tẽi. Esepia, Caruguar yɨpɨsuive ité oporoyuca serai vahe. Ndoyapoi vahe ité mbahe supi tuprɨ vahe, noñehei avei mbahe supi eté vahe rese. Semirasa iñehe ité. Esepia, semirañete ai vahe ité; ahe ité niha yɨpɨndar semira tẽi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Che rumo añehese mbahe supi tuprɨ vahe rese, ndache reroyai eté peye. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ava pĩha pe pãhu pendar oicua mbahe che rembiavɨ? ¡Aní eté! Che añehe mbahe supi eté vahe rese pẽu, ¿mahera ru evocoiyase ndache reroyai eté peye? ");
INSERT INTO gyrNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Acoi ava Tũpa suindar, ahe osendu pota rai iñehe; pe rumo ndahei eté Tũpa suindar peico. Sese ndapesendu potai eté iñehe —ehi Jesús judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Evocoiyase judío eta aipo ehi Jesús upe yuvɨreco: —Supi eté, ore oroicua nde Samaria ɨguar tẽi ereico, caruguar ité erereco ndeyese —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Che ndarecoi eté caruguar cheyese. Che rumo che Ru amboetei; pe rumo ndache mboetei eté peye. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Iyavei che ndasecai ava che mboetei ãgua. Oime rumo ñepei oipota vahe. Ahe niha omondora ava rembiapo reprɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Supi eté aipo ahe pẽu: acoi omboyeroya vahe che ñehe, nomanoi chietera yuvɨreco —ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Evocoiyase judío omboyevɨ yuvɨreco chupe aipo ehi: —Cũritei oroicua ité cute nde ererecose caruguar ndeyese. Esepia, Abraham iyavei opacatu Tũpa ñehe mombehusar omanopa ité yuvɨreco. ¿Mahera ru aipo nde, ‘Acoi che ñehe reroyasar nomanoi chietera’ ere? ");
INSERT INTO gyrNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nde tie ɨvate catu ereico ore ramoi Abraham sui? Esepia, ahe omano ité iyavei ambuae Tũpa ñehe mombehusar omanopa ité yuvɨreco. ¡Mbahe angahu vo co evocoiyase eremoha ndeyese! —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—Che ae tẽi ayemboeteise mbahe che rembiapo pɨpe, ahese ndahei chira supi vahe viña. Che Ru rumo che mboetei, chupe ité: “Ore Tũpa” peye. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pe rumo ndapeicuai eté. Che rumo aicua. “Ndaicuai” ahese, evocoiyase semirañete ai vahe aicora viña inungar pe peico. Che rumo supi eté aicua. Sese niha amboyeroya iñehe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Esepia, pe ramoi Abraham oyembovɨha ‘asepiara iharɨ oyepotase’ oya cheu. Osepia ité niha. Sese ovɨharete ité —ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Evocoiyase judío eta: —¿Mara erera vo aipo Abraham repia ndererecomi vɨteise cincuenta aravɨter? —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Supi eté aipo ahe pẽu: che aicove vahe Abraham yesuẽhɨ vɨteseve —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aipo ihese, oipɨsɨpa ita yuvɨreco yapi ãgua. Ahe rumo ahe ramoseve oñemi ava eta pãhuve, osẽño ité oso tũparo sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús oguatase ocar rupi, osepia mbɨa ohasa suive ndasesapɨsoi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ore semimbohe oroico vahe, oroporandu chupe: —Ore mbohesar, ¿mahera pĩha co mbɨa ndasesapɨsoi eté oha? ¿Oyesupa angaipa sui pĩha? ¿Oangaipa sui ae tie? —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—Ndahei eté oangaipa sui, ndahei avei oyesupa angaipa sui; co rumo ẽgüe ehi Tũpa mbahe sese mboyecua ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sese oime vɨtese arɨ yandeu che mbousar poravɨquɨsa apo ãgua, iya ité ahe yayapo. Esepia, pɨ̃tura, ahese ndayaicatui chietera mbahe apo. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Co ɨvɨ pɨpe che recove vɨtese rumo, che aico ava upe tesapesa nungar —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aipo ohe pare, ondɨvɨ ɨvɨve, güendɨ pɨpe omoaquɨ vahe ɨvɨ omondo ndasesapɨsoi vahe resa rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ipare aipo ehi chupe: —Eso, tereyovai ɨgua Siloé serer vahe pɨpe —ehi (ahe serer ‘imondoprɨ’ oya aipo ehi). Ndasesapɨsoi vahe evocoiyase oso, oyovai. Oyevɨse ichui, omahe tuprɨ ité. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Evocoiyase sẽta ɨvɨrindar iyavei ava oicua vahe sesapɨsoẽhɨse oporanduse guarepochi rese aipo ehi yuvɨreco: —¿Ndahei vo acoi co oguapɨ oĩ guarepochi rese oporandu yepi? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amove ambuae ava aipo ehi: —Taa, ahe ité —ehi. Ambuae rumo aipo ehi yuvɨreco: —Ndahei ahe. Avɨye tuprɨ ité rumo ahe —ehi. Ahe mbɨa rumo aipo ehi: —Taa, che ité niha ahe aico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Evocoiyase oporandu yuvɨreco chupe: —¿Mara ere vo co esareco? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Acoi mbɨa, Jesús serer vahe, ahe omoaquɨmi güendɨ pɨpe ɨvɨ, oipichi che resa rese aipo ehi cheu: ‘Eso ɨgua Siloé ve, eyovai’ ehi. Evocoiyase aso, ayovaise, ahese amahe tuprɨ ité —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Que vo ahe mbɨa? —ehi yuvɨreco chupe. —Ndaicuai, ¿que vo catu? —ehiño ava güẽta cotɨndar uve. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Mbɨtuhusa arɨ pɨpe aipo Jesús omoaquɨmi güendɨ pɨpe ɨvɨ ndasesapɨsoi vahe mbogüera ãgua. Sese vɨraso ndasesapɨsoi vahecuer fariseo eta rovai yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseo oporandu iri yuvɨreco co mbɨa upe: “¿Mara ere ité vo co esareco?” ehi. Ahe mbɨa aipo ehi: —Omondo ɨvɨ güendɨ pɨpe omoaquɨ vahe che resa rese. Ichui ayovai. Ipare voi asareco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Evocoiyase ambuae aipo ehi yuvɨreco chupe: —Aipo mbɨa ndahei eté revo Tũpa suindar. Esepia niha, nomboetei eté mbɨtuhusa arɨ —ehi yuvɨreco. Ambuae evocoiyase aipo ehi yuvɨreco: —¿Mara ehira aipo poromondɨisa apo ava yangaipa vahe viña? —ehiño yuvɨreco. Oyeavɨratɨ tẽi ipɨhañemoñetasa. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sese oporandu iri ndasesapɨsoi vahecuer upe yuvɨreco aipo ehi: —Nde no, ¿mara ehi nde pɨhañemoñeta co mbɨa rese? —ehi. Ahe evocoiyase aipo ehi: —Che amoha ité Tũpa ñehe mombehusar secose —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ahe fariseo rumo ndovɨroyai eté icuerasa yuvɨreco, oichoho uca rane ité iyesupa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chupe oporandu aipo ehi: —¿Pe rahɨr ité vo co? ¿Ndasesapɨsoi oha? ¿Mara ehi vo co cũritei osareco no? —ehi iyesupa upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—Ore rahɨr ité niha co, ndasesapɨsoi oha. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","¿Mara ehi vo catu co cũritei osareco? iyavei ¿ava vo catu ombogüera? ¡Ndoroicuai eté! Peporandu chupe. Ocuacua niha; ahe ae oicua ucara pẽu —ehiño iyesupa yuvɨreco fariseo upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iyesupa rumo osɨquɨyepave tẽi aipo ehiño yuvɨreco. Esepia, fariseo opa ité oyemoingatu yuvɨreco ava “Jesús Poropɨ̃sɨrosar secoi” ehi vahe oñemonuhasa sui ñepei reseve imombo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sese niha iyesupa aipo ehiño yuvɨreco: “Peporandu chupe. Ocuacua niha” ehiño. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Evocoiyase fariseo güeru uca iri acoi mbɨa imbogüeraprɨ yuvɨreco, aipo ehi yuvɨreco chupe: —Emombehuño oreu Tũpa rovaque mbahe supi tuprɨ vahe. Esepia, ore oroicua ité evocoi mbɨa angaipa viyar seco rese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ahe evocoiyase omboyevɨ chupe: —Che ndaicuai eté angaipa viyar tie revo. Co güeraño catu che aicua: che ndacheresapɨsoi vahecuer aico; cũritei rumo asareco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Evocoiyase oporandu iri yuvɨreco chupe: —¿Mbahe vo oyapo ndeu? ¿Mara ehi vo nde mbosareco? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Amombehu niha acoi pẽu. Pe rumo ndache reroyai eté peye. ¿Mahera vo peipota amombehu vɨte vaherã pẽu? ¿Pe avei tie peguata pota supi? —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ahese oñehe rai tẽi yuvɨreco chupe: —Nde ahe mbɨa rupindar tẽi ereico. Ore rumo yande ramoi aracahendar Moisés rupi oroguata vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Esepia, oroicua ité Tũpa oñehese Moisés upe. Aipo mbɨa rumo ndoroicuai eté que sui osẽ —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—¡Mara peye rutei pe ndapeicuai que suindar ahe! Che rumo che mbosareco. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Supi eté, yaicua Tũpa ndosendui eté ava angaipa viyar ñehe; ava omboeteisar iyavei vɨroyasar ñehe güeraño ité niha osendu. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Esepia, ndipoi eté que avaño tẽi ava oyesu sui ndasesapɨsoi vahe ombogüera vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ahe rumo ndaheise Tũpa suindar ou vahe viña, ndoicatui chietera revo mbahe apo viña —ehi fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Evocoiyase fariseo eta aipo ehi yuvɨreco chupe: —¿Nde co oangaipa reseve oha vahe tẽi, ore mbohe pota mbahe rese eve? —ehi. Ipare omose ñepei reseve oñemonuhasa sui yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús oicua ndasesapɨsoi vahecuer mombosa. Vupitɨse aipo ehi chupe: —¿Ereyeroya nde Ava Rɨquehɨr rese? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mbɨa evocoiyase aipo ehi chupe: —Che mbohesar, emombehumi cheu; tayeroya catu ru sese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Eremahe niha co sese; che ité ahe aico —ehi ndasesapɨsoi vahecuer upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Evocoiyase mbɨa oñenopɨha sovai: —Orovɨroya, che Yar —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ichui aipo ehi: —Che ayu co ɨvɨ pɨpe mbahe supi tuprɨ vahe apo ãgua; ava ndasesapɨsoi vahe nungar upe mbahe supi eté vahe che Ru suindar mboyecua ãgua iyavei ava oicua tẽi vahe mbahe Tũpa suindar mboesapɨsoẽhɨ iri ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Evocoiyase ambuae fariseo eta yuvɨrecoi vahe cõimi ichui osenduse aipo ñehesa, oporandu yuvɨreco chupe: —¿Ore avei tie ndasesapɨsoi vahe nungar oroico? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Evocoiyase omboyevɨ ahe fariseo upe: —Peicose ndasesapɨsoi vahe nungar viña, “Peyavɨ mbahe” ndehi chietera Tũpa pe angaipa rese pẽu viña. Pe rumo, “Ore oroicua tuprɨ Tũpa suindar mbahe” peye tẽi. Sese Tũpa, “Peyavɨ mbahe” ehi eté pẽu —ehi Jesús fariseo eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Supi eté aipo ahe pẽu: acoi ava co cotɨ rupi tẽi yuvɨroique vahe ovesa rẽta pɨpe, ahe imonda rai vahe tẽi yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Oique vahe rumo oquendɨpɨ rupi eté, ahe sãrosar ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Oquendɨpɨ rãrosar omboi chupe. Evocoiyase ovesa rãrosar oñehe serer rupi güeimba ovesa upe senose ãgua sẽta sui. Ahe evocoiyase oicua iñehe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Güeimba ovesa renose pare oguata senonde; seimba ovesa evocoiyase oguata saquɨcuerive. Esepia, oicua ité iñehe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ndoguatai eté rumo oyarẽhɨ rupi yuvɨreco; yuvɨnoña-noñaño ichui. Esepia, ndoicuai eté iñehe” ehi ");
INSERT INTO gyrNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","omboyoya güecocuer ovesa rãrosar rese. Ava rumo ndosenducuai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Evocoiyase Jesús aipo ehi iri: “Supi eté, aipo ahe pẽu: che año ité oquendɨpɨ nungar aico ovesa upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Opacatu ava yugüeru vahe che renonde, imonda rai vahe nungar tẽi yuvɨrecoi. Ava cheundar rumo ndovɨroyai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Che rumo oquenda nungar aico. Acoi oique vahe che rupi, ahera ipɨ̃sɨropɨrã yuvɨrecoi. Iyavei inungar acoi ovesa oique vahe güẽta pɨpe, ichui osẽ capihi reca ãgua igua yepi, ẽgüe ehira che reroyasar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Imonda rai vahe rumo omonda ãgua tẽi ou, oporoyuca ãgua, mbahe mocañɨ ãgua tẽi avei. Che rumo ayu ‘tovɨreco ava tecovesa ndopai vaherã ité yuvɨreco’ viya. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Che ité ava rãrosar avɨye vahe aico. Sese ayemoingatu tuprɨ che recocuer mondo ãgua ava cheundar repɨrã; ");
INSERT INTO gyrNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","acoi guarepochi repɨrã tẽi oporavɨquɨ vahe rumo, osepiase mahembiar oñaro ai vahe, oseyapaño güemiaro, oña oso. Esepia niha, ovesa ndahei eté seimba, ndahei avei eté ahe sãrosar ité secoi. Evocoiyase mahembiar oñaro ai vahe omondɨ-mondɨi eté ipɨsɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Evocoi mbɨa oñaño. Esepia, guarepochi repɨrã tẽi oporavɨquɨ. Sese niha ndosaɨsui eté güemiaro ovesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Che rumo ava rãrosar avɨye vahe ité aico; che Ru che cua ité. Che evocoiyase aicua avei che Ru. Sese che avei aicua che reimba ovesa eta. Ahe avei che cua yuvɨreco. Che niha amondo che recocuer sepɨrã yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Areco avei ambuae ité che reimba ovesa. Ahe avei aru pota che mboyeroya vaherã yuvɨreco. Ahese ñepei reseve guasu che remiaro yuvɨrecoira. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Che Ru niha che raɨsu ité. Esepia, amondo itera che recocuer manosave. Ipare rumo acuerayevɨra. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ndoicatui chira ava ahe ae tẽi che yuca ãgua; che teieté rumo amondora che récocuer che remimbotar rupi eté. Che areco ité pĩratasa imondo ãgua, che cuerayevɨ iri ãgua avei. Sese ité niha che Ru che cuai” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Osenduse judío eta aipo nungar ñehesa, opa ipɨhañemoñeta yoavɨratɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Setá iteanga ipãhu pendar aipo ehi: —¿Mahera vo co pemboyeroya? Vɨreco ité caruguar oyese, ndayaracuai eté —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ambuae rumo aipo ehi yuvɨreco: —Ndipoi eté rumo que ava na ehi vahe oñehe caruguar rerecosar. ¿Omboesapɨso tie caruguar rerecosar ava? —ehi amove judío yuvɨreco Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Arɨ sõhɨsa vahe pɨpe tecua Jerusalén ve tũparo rovasagüer pieta oyepota. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ahese Jesús oguata oico tũparo Salomón oyapo vahecuer rocupe ɨvɨi rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Evocoiyase judío rerecuareta oyere tuprɨ yuvɨreco sese aipo ehi yuvɨreco chupe: —¿Marase rutei vo eremombehu tuprɨra Poropɨ̃sɨrosar nde recosa oreu? Emombehu tuprɨ catu ñepei reseve oreu —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—Amombehu niha acoi pẽu, ndache reroyai eté rumo peye. Mbahe ayapo vahe che Ru mborerecuasa pɨpe omboyecua ité Poropɨ̃sɨrosar che recosa; ");
INSERT INTO gyrNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","pe rumo ndache reroyai eté peye. Esepia, pe ndahei eté che remiaro ovesa peico. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Che remiaro ovesa rumo oicua che ñehe. Che avei aicua ahe yuvɨreco. Ahe evocoiyase che rupi oguata yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Amondo avei tecovesa apɨrẽhɨ yuvɨreco chupe icañɨẽhɨ ãgua; ndipoi chietera que ava vɨrocua iri vaherã che sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Che Ru niha ombou cheu. Esepia, ahe ipĩrata catu opacatu ava sui. Ndipoi chietera que ñepei ava oicatu vahe serocua che Ru sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Che Ru iyavei che oroico ñepeiño ité —ehi judío rerecuareta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aipo ihese, judío rerecuareta osupipa iri ita yuvɨreco yapi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ahe chupe rumo aipo ehi: —Setá mbahe poromondɨisa avɨye vahe pe rovaque ayapo che Ru pĩratasa pɨpe. ¿Uma che rembiapo avɨye vahe sui che api-api pota peye ita pɨpe? —ehi judío rerecuareta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judío rerecuareta omboyevɨ yuvɨreco chupe: —Nande api-apisai chira ita pɨpe que mbahe nde rembiapo avɨye vahe rese. Co rese rumo ẽgüe orohera ndeu. Esepia, nde ereñehe rai tẽi Tũpa rese. Nde moco ava tẽi ereico. Nde rumo ereyeapo Tũpa ndeyeupe ae —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Evocoiyase aipo ehi ahe ava upe: —Pẽundar mborocuaita icuachiaprɨ pɨpe niha aipo ehi: ‘Che aipo ahe pẽu: pe tũpa pãve ité peico’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yaicua niha icuachiaprɨ pɨpendar ndiyai yayamotarẽhɨ. Esepia, Tũpa aipo ehi: ‘Pe tũpa pãve ité peico’ ehi evocoi ava oñehe pɨsɨsar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Che niha che Ru Rembiporavo aico. Ahe che mbou co ɨvɨ pɨpe. ¿Mahera ru evocoiyase, ‘Nde ereñehe rai tẽi Tũpa rese’ peye cheu, ‘Che Tũpa Rahɨr aico’ ahese pẽu? ");
INSERT INTO gyrNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Esepia, acoi ndayapoise mbahe che Ru remimbotar, ahese ndache reroyai chietera peye viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yepe ndache reroyai chira che recocuer rese peye viña, mbahe ayapose rumo ahe tẽi peroyara. Sese tapeicua ñepei reseve che Ru secoise che rese iyavei che sese che recosa —ehi oamotarẽhɨmbareta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Osoquenda pota iri yuvɨreco viña; Jesús rumo osoño ipãhu sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Oyevɨ ɨai Jordán rovai. Aheve acoi Juan yɨpɨndar oporoãpiramo. Aheve opɨta. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ava rehɨi yuvɨraso sepia, aipo ehi yuvɨreco: —Yepe Juan ndoyapoi mbahe poromondɨisa viña. Opacatu mbahe omombehu vahe rumo co mbɨa resendar supi eté —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Setá iteanga ava Jesús vɨroya yuvɨreco aheve. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oime ava imbaheasɨ vahe serer Lázaro, tecua Betania pendar. Güeindrɨ Marta iyavei María reseve yuvɨrecoi aheve. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ahe María, oipɨyere vahe mbahe sɨ̃acua vahe yande Yar pɨ rese. Ipare oiquɨtɨ oha pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ahe seindrɨ omondo oñehe Jesús upe yuvɨreco aipo ehi: —Ore Yar, nde mborɨpar, nde rembiaɨsu, imbaheasɨ ou —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ahe osenduse aipo ehi: —Co mbaherasɨsa rumo ndahei ahe imano ãgua ité. Ẽgüe ehi rumo Tũpa reco porañetesa mboyecua ãgua iyavei Tahɨr reco porañetesa mboyecua ãgua avei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yepe osaɨsú iteanga Marta icupɨhɨr reseve iyavei iquɨvrɨ Lázaro viña, ");
INSERT INTO gyrNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","oyanduse rumo Lázaro mbaherasɨsa, opɨta vɨteño ité ñuvɨrío arɨ güecosave. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ipare omombehu ore supi oroico vahe upe: —Yayevɨ iri ɨvɨ Judea rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ore rumo aipo orohe chupe: —Ore mbohesar, cuesemi tẽi acoi judío rerecuareta ahe pendar nde yuca pota ita pɨpe yuvɨreco; ¿cũritei co ereso pota iri aheve? —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Oreu rumo aipo ehi: —Ñepei arɨ niha vɨreco doce hora. Supi eté acoi oguata vahe arɨ pɨpe ndoyepɨapi eté. Esepia, osepia ité co ɨvɨ resapesa; ");
INSERT INTO gyrNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","acoi oguata vahe rumo pɨ̃tu pɨpe, oyepɨapi eté. Esepia, ipane tesapesa chupe —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ipare aipo ehi: —Yande mborɨpar Lázaro oque tẽi. Che rumo amomahera —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Evocoiyase ore aipo orohe chupe: —Ore Yar, oque tẽise, ocuerara —orohe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","‘Omano ité’ oyapave tẽi aipo ehi. Ore rumo orepɨhañemoñeta: “Oque tẽi revo” orohe chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ipare rumo omombehu tuprɨ ité aipo ehi oreu: —Lázaro omano ité. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Avɨharete che ndaicoise aheve. Esepia, ẽgüe ehise ité avɨye catura pẽu pe che reroya ãgua. Yaso ru catu sepia —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Evocoiyase Tomás, Gemelo serosa vahe, aipo ehi ore imboetasa oroico vahe upe: —Yaso avei ru yande yamano vaherã supi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Betania namombrɨimi Jerusalén sui, tres kilómetro tuprɨ. Evocoiyase ore oroyepota senise ahe tecuave, orosendu “cũritei irungatu arɨ opa Lázaro tɨ̃re” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Setá judío yuvɨraso Marta iyavei María pɨri iquɨvrɨ mano agüer sui imbovɨha ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Oicuase Marta Jesús yepota seni, oso voi eté sapeve; María rumo opɨtaño oɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Evocoiyase Marta aipo ehi voi chupe: —Che Yar, ehi cohave ereicose, nomanoi chietera revo ore quɨvrɨ viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Che rumo aicua Tũpa omboura opacatu nde porandusa ndeu —ehi Marta chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Nde quɨvrɨ rumo ocuerayevɨ irira —ehi Marta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Supi eté aicua niha ocuerayevɨra opacatu omano vahecuer reseve arɨ ipa vahe pɨpe —ehi Marta. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—Che niha cuerayevɨsa aico iyavei tecovesa. Acoi ava che reroya vahe, yepe omano tẽira viña, oicoveño itera rumo. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Acoi che reroya vahe güecoveseve, nomanoi chietera. ¿Ereroya aipo che hesa? —ehi Marta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Orovɨroya ité, che Yar. Nde niha Poropɨ̃sɨrosar ereico Tũpa Rahɨr, ore remiaro ereyu vaherã co ɨvɨ pɨpe oreu nara —ehi Marta Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Aipo ohe pare, Marta oso ocupɨhɨr María reca, chupeñomi aipo ehi: —Porombohesar oicove cohave, “Tou” ehi ndeu —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Evocoiyase María oso voi eté sepia. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús rumo ndoique vɨtei eté tecua pɨpe; Marta rese oyoepiasave vɨteño ité secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Osepiase María sẽ poyava, judío eta sẽtave yuvɨrecoi vahe imbovɨhasar yuvɨraso voi saquɨcuerive, “Oquɨvrɨ ruvɨpave revo osora oyaseho” ehi yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Evocoiyase María oyepotase chupe, oñenopɨha sovai aipo ehi: —Che Yar, ehi revo ereicoveño itese cohave, che quɨvrɨ nomanoi chietera viña —ehi María chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Osepiase María yaseho iyavei judío eta yuvɨraso vahe supi, opɨha pɨpe oyandu ité ovɨharẽhɨsa. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Evocoiyase oporandu: —¿Que vo peñotɨ? —ehi chupe. Ahe aipo ehi yuvɨreco chupe: —Ore Yar, erio, teresepia —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ahese Jesús oyaseho. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judío evocoiyase aipo ehi yuvɨreco: —¡Esepia, osaɨsu ité! —ehi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ambuae rumo ipãhu pendar aipo ehi yuvɨreco: —Co mbɨa omomahe vahe acoi mbɨa ndasesapɨsoi vahe, ¿ndoicatui chira pĩha Lázaro manoẽhɨ ãgua mbahe apo cuese rahe viña? —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús oyemboya suvɨpave ovɨharẽhɨsa pɨpe; ahe suvɨpa ita hoprɨ, sovapɨsa ita avei. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—Perocua sovapɨsa ita ichui —ehi. Marta, omano vahe reindrɨ, rumo aipo ehi: —Che Yar, iné ité revo. Esepia, opa niha irungatu arɨ imanore —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—¿“Che reroyase eve, Tũpa pĩratasa eresepiara” ndahei vo acoi ndeu? —ehi Marta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aipo ihe pare, vɨrocua ita yuvɨreco ichui. Evocoiyase omahe ɨva rese aipo ehi: —Che Ru, “Avɨye ndeu” ahe ndeu. Esepia, eresendu che ñehe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Che aicua nde eresenduño ité che ñehe yepi, che rumo aipo ahe co ava eta rembiepiave ‘tovɨroya avei nde che mbousa co ɨvɨ pɨpe yuvɨreco’ che yapave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aipo ohe pare, oñehe pĩrata aipo ehi: —¡Lázaro, esẽ eipeve sui! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Omano vahe evocoiyase osẽ voi opacatu turucuar omamasa reseve. Jesús evocoiyase aipo ehi ava upe: —Peyorapa imamasa ichui, toguata —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Osepiase co poromondɨisa, judío eta yuvɨraso vahe María rupi setá ité Jesús vɨroya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ipãhu pendar rumo movɨro yuvɨraso voi ava fariseo rerecuareta uve sembiapo mombehu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Evocoiyase fariseo rerecuareta iyavei pahi rerecuareta oñemonuha guasu yuvɨreco aipo ehi: —¿Mara yahera vo sereco? Co mbɨa setá ité oyapo poromondɨisa oico. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndayayapoise mbahe chupe, opacatu tiẽte ava vɨroyara yuvɨreco viña iyavei avɨyeteramo mborerecuar Roma ɨguar yanduse, yugüerura yande tũparo mondurupa iyavei omocañɨ tẽi uca aveira yande recua yande sui —ehi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ñepei rumo mbɨa ipãhu pendar Caifás serer vahe, ahe ité pahi eta rerecuar ɨvate catu vahe ahe aravɨter pɨpe, aipo ehi ava upe: —Pe ndapeicuai eté mbahe, ");
INSERT INTO gyrNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ndapesenducuai avei co tecocuer; avɨye catura ñepei mbɨa omanose yande recocuer rese, ndahei que opacatu yande mocañɨ tẽi ãgua —ehi omboetasa eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ahe rumo ndahei oyesui tẽi aipo ehi; Tũpa ité aipo ombohe uca. Esepia, ahe ité mborerecuar guasu chini ahese. Sese aipo ehi: “Jesús omanora yande recocuer rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iyavei ndahei chira ahe ava reseño, omanora opacatu ava Tũpa Rahɨr oñemosai tẽi vahe ñepei reseve imonuha ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ẽgüe ehi ahe arɨ pɨpeve judío eta rerecuar oyemoingatupa voi yuca ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sese ndoguata iri ava judío eta pãhu rupi. Ahe rumo osẽ ɨvɨ Judea sui, oso ɨvɨ iporupɨrẽhɨ vahe rerovɨcave, tecua Efraín ve. Aheve opacatu oropɨta supi. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Vɨrovɨse judío Pascua pieta apo ãgua, setá iteanga ava ambuae tecua rupindar yuvɨraso tecua Jerusalén ve oyeecocuer moatɨro ahe pieta mboetei ãgua renondeve. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Oseca tẽi Jesús yuvɨreco. Ipare tũparove yuvɨroiquese, oporandu-randu oyeupe yuvɨreco: —¿Mara peye pe, oura pĩha pieta repia, aní chira tie? —ehi-ehi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yɨpɨve rumo fariseo rerecuar iyavei pahi rerecuar oyocuai ava, “Pesepiase Jesús, pemombehu voi oreu ipɨsɨ ãgua” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Seis arɨ ipane vɨtese Pascua pieta ãgua, Jesús oso tecua Betania ve, aheve acoi Lázaro ombogüerayevɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Eipeve ocaru yuvɨreco Jesús mboeteisave. Marta ihañeco sese; Lázaro evocoiyase ocaru yuvɨnoi mesave ipɨri. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Evocoiyase María güeru medio litro mbahe sɨ̃acua vahe nardo, sepɨ́ iteanga vahe. Omondo ipɨ rese. Ipare oiquɨtɨ ohavaprɨ pɨpe ichui. Sɨ̃acuá iteanga evocoiyase opacatu oɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Evocoiyase ore mboetasa Judas Iscariote, ahe acoi omondo vaherã ava yamotarẽhɨmbar uve, aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Mahera vo ndimondosai co mbahe sɨ̃acua vahe tresciento denario rupi ava iparaɨsu vahe pɨ̃tɨvɨi ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas rumo ndahei ava iparaɨsu vahe raɨsupave aipo ehi. Ahe rumo imonda rai vahe tẽi. Setá rupi guarepochi vɨrocua güembiporuguã tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Evocoiyase Jesús aipo ehi: —Toyapoño cheu. Esepia, ahe che mano ãgua renonde ẽgüe ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yuvɨrecoveño itera ava iparaɨsu vahe pe pãhuve yepi; che rumo ndaico pucu iri chira pe pãhuve —ehi Judas upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Setá iteanga ava judío oyandu yuvɨreco Jesús rerãcua Betania ve secoise. Sese yuvɨraso aheve; ndahei Jesús repia güeraño yuvɨraso, ẽgüe ehi rumo imbogüerayevɨprɨ Lázaro repia avei. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Evocoiyase pahi rerecuar, “Yayuca avei Lázaro” ehi yuvɨreco oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Esepia, ahe ichui tẽi niha setá iteanga judío oyepepɨ pahi rerecuar sui Jesús reroya ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ava rehɨi yuvɨraso tecua Jerusalén ve Pascua pieta repia yuvɨreco. Ahere ayihive voi oicua Jesús yepota ãgua ahe tecuave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ahese oyasɨa pindo yuvɨreco. Oyacatu vɨraso Jesús rovaĩchi ãgua, osapucai yuvɨreco chupe: —¡Imboeteiprɨ, sovasaprɨ secoi ou vahe yande Yar Tũpa rer pɨpe! ¡Tũpa tosovasa Israel rerecuar guasu! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yɨpɨndar rumo opa Jesús oseca uca guaricumi. Ipare oyeupi sese icuachiaprɨ aracahendar rupi tuprɨ ité aipo ehi vahe: ");
INSERT INTO gyrNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Pesɨquɨyei rene, Sión pendar; pesepia, pe rerecuar guasu guaricumi harɨve ou pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yɨpɨndar, ore semimbohe eta, ndorosenducuai eté co aracahendar imombehuprɨ. Ipare rumo oyevɨse güecosa porañetesave, ahese oremahenduha aracahendar sesendar icuachiaprɨ rese, “Supi eté omombehu” orohe tẽi sepiase. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Acoi ava yuvɨrecoi vahe Jesús rupi, Lázaro mbogüerayevɨsa osepia vahecuer, ahe opa omombehu-mbehu ambuae ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sese ava eta yuvɨnose voi sovaĩchi ipɨsɨ ãgua. Esepia, oicua ité ahe mbahe poromondɨisa guasu yapose yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Evocoiyase fariseo rerecuareta aipo ehi oyeupe yuvɨreco: —Indó, peicua niha ndayaicatu iri eté mbahe apo chupe cute. Pesepia ru, ¡opacatu guasu ité ava oguata cũritei yuvɨreco supi! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Griego oime ava rehɨi pãhuve yuvɨraso vahe pieta repia Tũpa mboetei ãgua tecua Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ahe oyemboya Felipe, Betsaida pendar rese, ahe tecua Galilea pɨpendar. Ipare aipo ehi yuvɨreco chupe: —Nde mbɨa, orosepia potami aipo Jesús —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe evocoiyase oso imombehu Andrés upe; ichui yuvɨraso ñuvɨrío voi Jesús upe imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Evocoiyase chupe aipo ehi: —Oyepota arɨ cheundar che, Ava Rɨquehɨr, che yevɨ iri ãgua che recua porañetesave. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Supi eté aipo ahe pẽu: inungar acoi trigo rãhɨi nañotɨsaise, ahese ndihai chietera; ñotɨse rumo, ahese iha vaira. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Acoi ava osaɨsuse rumo güecocuer tẽi, ocañɨ tẽira; acoi ndosaɨsui vahe rumo güecocuer co ɨvɨ pɨpendar tẽi che recocuer rese, evocoi nungar vɨrecora tecovesa apɨrẽhɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Acoi ava che mboyeroya pota vahe, toguata che rupi yuvɨreco. Esepia, acoi che mboyeroyasar yuvɨrecoi vahe, ahe avei yuvɨrecoira che pɨri ɨvave. Che Ru Tũpa evocoiyase omboeteira ahe sereco —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“¡Cũritei ayandu ité mbahe-mbahe tẽi oime vaherã cheu! ‘¿Mara ahera pĩha?’ ahe tẽi. ¿Aipo ahera: ‘Che Ru, che pɨ̃sɨro eve cũritei cheu oime vaherã mbahe tẽi sui’ ahera viña? ¡Che rumo aicua evocoi nungarã ité ayu! ");
INSERT INTO gyrNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Che Ru, emboyecua nde pĩratasa nde rer porañetesa mboetei ãgua” ehi oyeroquɨ. Ichui oyeendu ɨva sui ñehesa aipo ehi vahe: “Ẽgüe ahe niha amboyecua che pĩratasa vichico, ẽgüe ahe iri aveira” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aheve ava yuvɨrecoi vahe, “Osunu revo” ehi yuvɨreco viña; ambuae ava, —Tũpa rembiguai revo oñehe Jesús upe —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Evocoiyase aipo ehi ava eta upe: —Ndahei cheundar ñehesa pesendu, ahe rumo pẽundar. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cũritei oimera ñemoɨrosa co ɨvɨ pɨpendar ndache reroyai vahe upe, cũritei avei imombosara Caruguar co ɨvɨ pɨpendar imborerecuasa sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Acoi che rupise ɨvate, opacatu ava arura cheyeupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aipo ñehesa pɨpe omboyecua tuprɨ ité mara ehira omano. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aipo ihese ava eta aipo ehi: —Ore rumo orosendu mborocuaita icuachiaprɨ pɨpe aipo ehi vahe: “Poropɨ̃sɨrosar apɨrẽhɨ vaherã ité” ehi. ¿Mahera ru aipo nde: “Ava Rɨquehɨr osupira ɨvate yuvɨreco” ere no? ¿Uma ru aipo Ava Rɨquehɨr, ambuae tie? —ehi ava eta yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Evocoiyase aipo ehi ava upe: —Pe pereco vɨtemira chĩhi rupive tesapesa pe pãhuve. Peguata catu supi seime vɨteseve. Avɨyeteramo pe resapɨha tẽira pɨ̃tumimbi vahe. Esepia, acoi oguata vahe pɨ̃tumimbisa rupi, ndoicuai que güecosa. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Peroya co tesapesa cũritei pereco vɨteseve, ipɨpe ité pe reco ãgua —ehi. Aipo ohe pare, Jesús osẽ ava rehɨi pãhu sui; ndoyemboyecua iri chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yepe Jesús setá iteanga oyapo mbahe poromondɨisa judío rerecuar rovaque viña, ahe rumo ndovɨroyai eté yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Esepia, imboavɨyesa rane itera Tũpa ñehe mombehusar Isaías rembicuachiagüer aipo ehi vahe: “Che Yar, ava ndovɨroyai yande ñehe yuvɨreco iyavei ndovɨroyai nde pĩratasa eremboyecuase chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Co rese avei ava ndoicatui eté senducua yuvɨreco. Inungar oicuachía Isaías aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Tũpa nomboesapɨsoi ava iyavei nombopɨhañemoñeta tuprɨ iri mbahe rese yuvɨreco. Sese ndosepiacuai eté mbahe, ndosenducuai avei mbahe, ndoyevɨ catui yuvɨreco chupe ombogüera ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías aipo ehi. Esepia, osepia ité Jesús reco porañetesa. Evocoiyase ahe oñehe sese. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Setá ité rumo judío vɨroya yuvɨreco, seco ɨvate vahe avei. Ahe rumo nomboyecuai eté seroyasa yuvɨreco fariseo rerecuar sui osɨquɨyepave ‘avɨyeteramo yande mombora ñemonuhasa sui ñepei reseve yuvɨreco’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Esepia, ahe oipota catu ava tẽi suindar yemboeteisa Tũpa suindar yemboeteisa sui yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yɨpɨndar rumo, Jesús oñehe vɨtese ava rehɨi upe, oñehe pĩrata aipo ehi: “Acoi che reroya vahe ava, ndahei che güeraño che reroya, ahe rumo che Ru avei, che mbousar, vɨroya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iyavei acoi che repia vahe, che mbousar avei osepia. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Che tesapesa aico. Ayu co ɨvɨ pɨpe ava che reroyasar pɨ̃tumimbisave yuvɨrecoiẽhɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Acoi osendu vahe che ñehe, nomoinguei vahe rumo oyese, ndahei che amocañɨra. Esepia, ndayui ava co ɨvɨ pɨpendar mocañɨ ãgua, che rumo ayu ipɨ̃sɨro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Acoi ava che reroɨ̃ro vahe, ndovɨroyai vahe avei che ñehe, oime rumo imocañɨ ãgua: Co che ñehesa supi eté vahe reroyaẽhɨsa pɨpe oyemocañɨ ucara arɨ ipa vahe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Esepia, che nañehei eté cheyesui tẽi; che Ru, che mbousar rumo che cuai che ñehe ãgua, che porombohe ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Che aicua co cheundar porocuaita güeru tecovesa apɨrẽhɨ ava upe. Sese niha amombehu che Ru che cuaisa” ehi Jesús ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pascua pieta renonde Jesús oicua ité oharɨ yepota co ɨvɨ reya ãgua oso vaherã Vu pɨri. Ahe osaɨsu vahe ité ava oyeupendar co ɨvɨ pɨpe yepi. Ẽgüe ehi saɨsu arɨ ipa vahe rupi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Caruguar oique ité Simón rahɨr, Judas Iscariote, pɨha pɨpe imondo ãgua yamotarẽhɨmbar uve. Jesús rumo oicua ité Vu Tũpa sui ousa, oicua avei oyevɨ iri ãgua Vu Tũpa pɨri iyavei Tu omondo opacatu omborerecuasa chupe. Sese ocaruse güemimbohe eta reseve, mesa sui opũha, osequɨi oturucuar yohasa. Ipare omonde ambuae turucuar vumbɨcuasa rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Evocoiyase omondo ɨ yepoisa rɨru pɨpe, oyosei güemimbohe pɨ, omombiru turucuar vumbɨcuasa rese vɨreco vahe pɨpe oico. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ichui Simón Pedro pɨ oyosei potase, ahe aipo ehi chupe: —Che Yar, ¿nde co ereyoseira che pɨ? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Nde rumo nderesenducuai mbahe che rembiapo cũritei. Ipare rumo eresenducuara —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro rumo aipo ehi chupe: —¡Che pɨ rumo ndereyosei chietera! —ehi. —Ndayoseise rumo nde pɨ, ndahei chietera evocoiyase che rupindar ereico —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Pedro evocoiyase aipo ehi: —¡Che Yar, aní catu che pɨ año ereyosei; eyosei che po, che rova avei! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Acoi oyasupa ramo vahe rumo, ahe ndiquɨhai eté. Sese ndiyai oyasu iri. Ipɨ güeraño rumo iya yoseisa. Ẽgüe peye ndipoi eté mbahe pe rese; ndaopacatui rumo ẽgüe peye —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ahe aipo ehi: “Ndaopacatui rumo ẽgüe peye” ehi. Esepia, oicua ité uma omondora yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Güemimbohe pɨ sei pare, omonde iri oturucuar yohasa, oguapɨ mesave aipo ehi: —¿Peicua vo co mbahe ayapo vahe pẽu? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pe niha, “Ore mbohesar, ore Yar” peye cheu. Supi eté niha. Esepia, ahe ité che aico. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yepe supi eté, che pe mbohesar, pe Yar avei aico viña, ayosei rumo pe pɨ. Sese pe avei ñepei-pei peyacatu peyosei aveira pe pɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Che niha ‘na tehi avei yuvɨreco’ viya opombohe pe rereco, ẽgüe ahe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Supi eté aipo ahe pẽu: ava mbiguai tẽi, ahe ndahei ɨvate catu güerecuar sui; ẽgüe ehi avei imbouprɨ ndahei ɨvate catu secoi ombousar sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pesenducuase co nungar mbahe, peyapo tuprɨse, ahese pevɨharete catura peico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Che nañehei opacatu pe rese, che rumo aicua uma yuvɨrecoi vahe che rembiporavo. Icuachiaprɨ rumo yavɨyera: ‘Acoi ocaru vahe che pɨri, oyemboyere che amotarẽhɨ’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Senondeve amombehu pẽu. Evocoiyase ẽgüe ehise ité cheu, che reroyara peye che ité niha aipo ahe vahe vichico. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Supi eté aipo ahe pẽu: acoi che remimondo oipɨsɨ tuprɨ vahe, ahe che pɨsɨ tuprɨ avei; acoi ava che pɨsɨ vahe, oipɨsɨ tuprɨ avei che Ru yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Aipo ohe pare, Jesús ndoyembovɨhai eté iyavei mbahe oime vaherã omboyecua tuprɨ ité, —Supi eté aipo ahe pẽu: ñepei pe pãhu pendar che mondora che amotarẽhɨmbar upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Evocoiyase ore oromahe-mahe tẽi oreyese, “¿Ava upe pĩha aipo ehi?” orohe tẽi oreyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Che sembiaɨsu catu yɨ́pɨve acaru vĩte. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ipare Pedro oyaitɨ-itɨ ‘¿Ava upe vo aipo ere? tehi chupe’ oyapave cheu. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Evocoiyase che asɨrɨ catu irimi yɨ́pɨve, aporandu chupe: —Che Yar, ¿ava ité vo? —ahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ahe aipo ehi cheu: —Cũritei amoaquɨra pan rahɨcuer imondo tohu, ahe ité che mondora —ehi cheu. Aipo ohe pare omoaquɨ pan rahɨcuer imondo Simón Iscariote rahɨr, Judas, upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas oipɨsɨse pan, oguapɨ voi eté Caruguar sese. Evocoiyase aipo ehi Judas upe: —Evocoi ereyapo pota vahe, eyapo voiño ité ru —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Que ñepei rumo mesave orocaru vahe, ndorosenducuai eté aipo ihesa. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Esepia, Judas guarepochi rɨru rãrosar secoi yepi. Sese amove ore pãhu pendar ipɨhañemoñeta: “ ‘Tererocua mbahe pietase nara’ anise, ‘emondo mbahe ava iparaɨsu vahe upe nara’ aipo oya revo omose imondo” ehi yuvɨreco chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Pan pɨsɨ pare, Judas osẽ voi eté oso pɨ̃tuse. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas sẽ pare, Jesús aipo ehi: —Cũritei oyecuara che, Ava Rɨquehɨr, reco porañetesa. Che Ru Tũpa reco porañetesa avei oyecuara che rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Acoi amboyecuase che Ru Tũpa reco porañetesa, ahe avei omboyecuara che reco porañetesa, ẽgüe ehira imboyecua pɨhaivi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Che rahɨreta, che rembiaɨsu, ndaico pucu iri chira pe rese. Che reca tẽira peye; inungar acoi judío rerecuar upe aipo ahe: “Ndiyai chietera peso che sosave” ahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sese co amondo porocuaita ipɨasu vahe pẽu ñepei-pei peyeaɨsu ãgua inungar che opoaɨsu. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Peyeaɨsuse ñepei-pei, opacatu tuprɨ ité ava oicuara yuvɨreco che remimbohe supi eté pe recosa —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pedro oporandu Jesús upe: —Che Yar, ¿que vo aipo eresora? —ehi chupe. Ahese omboyevɨ Pedro upe: —Cũritei ndiyai peso vaherã che sosave che rupi; pesorera rumo che rupi curi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—Che Yar, ¿mahera ru cũritei voi ndiyai nde rupi che so ãgua? ¡Ayemoingatu ité amano vaherã nde rese! —ehi Pedro chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Supi eté pĩha ereyemoingatu ité che rese nde mano ãgua? Nde rumo cõhe potase tacura ñehe renondeve, mbosapɨ oyupagüer rupi, “Ndaicuai eté co mbɨa” erera cheu —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ipare Jesús aipo ehi opacatu oreu: “Pepɨhañemoñeta atɨi rene; peyeroya Tũpa rese, che rese avei peyeroya. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Esepia, che Ru rẽtave setá oime pe reco ãgua; ẽgüe ndehise rumo, namombehui chira aipo pẽu viña. Sese che asora pe recuarã moingatu. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Imoingatu pare ayevɨra pe reca che recosave pe reraso ãgua cheyepɨri. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Pe peicua que vo asora iyavei peicua mara peyera pe yepota ãgua che recosave” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás rumo aipo ehi chupe: —Che Yar, ndoroicuai rumo que vo eresora. ¿Mara orohera vo aipo icua ore so ãgua? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—Che niha perɨ aico supi eté vahe iyavei tecovesa. Che rupi güeraño ité peyepotara che Ru upe —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pe peicua tuprɨse ité che recocuer viña, peicua aveira che Ru viña no. Cũritei suive rumo peicua, pesepia avei cute —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Evocoiyase Felipe aipo ehi chupe: —Che Yar, torosepia ité ru aipo nde Ru. Ahese avɨyera oreu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Felipe, setá arɨ aico pe rese, ¿ndapeicua vɨtei eté vo che recocuer? Acoi ava che repia vahe, ahe osepia ité che Ru; ¿mahera ru evocoiyase, “Torosepia rane ité nde Ru” ere vɨte cheu no? ");
INSERT INTO gyrNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ndache reroyai vo peye che Ru rese ité aicose, che rese avei che Ru secoise? Opacatu mbahe amombehu vahe pẽu, ndahei cheyesui tẽi amombehu. Che Ru secoi vahe che rese, ahe ité oyapo güemimbotar che recocuer rese —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Che reroya peye che Ru rese che recose, ahe avei secoise che rese. Anise, che reroyañomi tẽi catu peye mbahe che rembiapo rese —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Supi eté aipo ahe pẽu: acoi ava che reroya vahe, ahe avei oyapora mbahe che rembiapo nungar, tuvicha catura rumo. Esepia, che asora che Ru pɨri —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Acoi peporanduse que mbahe rese che rer pɨpe, che amondoño itera pẽu. Ipɨpe che amboyecuara che Ru reco pĩratasa. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Che ayapora que mbahe che rer pɨpe pe porandusa —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Che raɨsuse ité peye, pemboyeroya catu che porocuaita. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Che aporandura che Ru upe ombou vaherã Espíritu supi eté vahe pe pɨ̃tɨvɨi ãgua, ahe secoi vaherã ité pe rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ava Tũpa ndoicuai vahe rumo, ndoicatui chietera ipɨsɨ. Esepia, ndosepiai, ndoicuai avei yuvɨreco. Pe rumo peicua ité. Esepia, ahe ité secoi pe rese. Ipare oique itera pe pɨha pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ndopoeyai chira pe güeraño tẽi; ayevɨra niha pe rese aico vaherã. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Chĩhi tẽi oime vɨte arɨ che reroyasarẽhɨ che repia vɨte vaherã yuvɨreco. Ipare rumo ndache repia iri chira yuvɨreco. Pe rumo che repiaño itera peye iyavei peicoveño itera. Esepia, che aicoveño avei. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ahe arɨ pɨpe peicuara che Ru rese che recosa, che rese pe recosa avei iyavei che aicose pe rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Acoi oicua vahe che porocuaita, omboyeroya vahe avei, ahe omboyecua ité che raɨsusa yuvɨreco. Che Ru osaɨsura che raɨsusar; che avei asaɨsura, ayemboyecua aveira chupe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (ndahei vahe rumo Iscariote) aipo ehi: —Che Yar, ¿mahera oreuño ereyemboyecuara; mahera ru ndereyemboyecua iri chira ava nde reroyasarẽhɨ upe? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Evocoiyase aipo ehi Judas upe: —Acoi che raɨsu vahe, omboyeroya vahe che ñehe yuvɨreco, che Ru evocoiyase osaɨsura iyavei che Ru reseve oroyura oroico vaherã sese. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Acoi ndache raɨsui vahe, ahe ndovɨroyai avei che ñehe yuvɨreco. Co ñehesa pesendu vahe ndahei cheyesui tẽi; ahe rumo che Ru, che mbousar suindar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Pe rese che reco vɨtese, opa co mbahe amombehu vichico pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Espíritu Santo rumo, Poropɨ̃tɨvɨisar, che Ru ombou vahe che rer pɨpe, ahe pe mbohera opacatu mbahe avɨye vahe rese. Pe momahenduha aveira opacatu pẽu che ñehe agüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Aseya teco tuprɨsa pẽu, ahe che reco tuprɨsa; ndahei rumo avaño tẽi rembiapo nungar amondo pẽu. Aní, ‘¿Mara yahera pĩha?’ peyera; aní chiaveira pesɨquɨye. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Pesendupa niha acoi, ‘Asora, ipare ayevɨ irira pe rese aico vaherã’ che hesa. Supi eté che raɨsuse peye, pevɨharetera peicuase che Ru pɨri che sosa. Esepia, ahe ɨvate catu vahe ité che sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Sese amombehupa voi co mbahe tenondeve pẽu, ẽgüe ehise ité, ahese peroyara. ");
INSERT INTO gyrNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Namombehu pucu iri chira mbahe pẽu. Esepia, ou ité co ɨvɨ pɨpe oporocuai tẽi vahe. Ahe rumo ndahei ɨvate catu vahe che sui ");
INSERT INTO gyrNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","‘toicua ava che reroyasarẽhɨ che Ru raɨsusa yuvɨreco’ che hesa pɨpe. Ayapoño ité che Ru che cuaita. “Pepũha. Yaso cohave sui” ehi güemimbohe eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ipare Jesús oñehe iri oreu aipo ehi: “Che aico inungar uva hɨ supi eté vahe; che Ru evocoiyase inungar sese ihañeco vahe secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ahe oyasɨa sãca ndihai vahe ichui yepi; iha vahe rumo omoatɨro tuprɨ iha catu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Pe pe recocuer imoatɨroprɨ ité che pe mbohesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Peicoño ité catu che rese inungar che aicoño ité avei pe rese. Uva rãca oise ohɨ sui, ndiha iri ahe ae tẽi; pe avei ẽgüe peyera peyepepɨse che sui” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Che niha uva hɨ nungar aico; pe evocoiyase sãca nungar peico. Acoi secoi vahe che rese, che avei aico sese. Inungar mbahe mitɨ iha atɨ vahe, ẽgüe ehira ahe. Supi eté ndapeicatui chietera che porẽhɨ mbahe apo. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Acoi ndasecoi vahe che rese, ahe imombosara inungar acoi uva rãca yɨpi vahe. Ipare imonuhasa sapɨ ãgua” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Pe peicoñose ité che rese ndaperesaraise avei che porombohesa sui, peporanduño mbahe pe remimbotar rese, ahese imondosara pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","“Che Ru oipɨsɨra omboeteisa pe sui acoi peyapo tuprɨse opacatu che remimbotar. Pemboyecua evocoiyase che remimbohe supi tuprɨ vahe pe recosa. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Che opoaɨsu ité, inungar che Ru che raɨsu. Sese peicoño ité catu che poroaɨsusa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Esepia, pemboyeroyase che porocuaita, peicoveño itera co che poroaɨsusa pɨpe. Inungar che che Ru amboyeroya che cuaisa iyavei aicoveño ité che Ru poroaɨsusa pɨpe vichico. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Che aipo ahe pẽu ‘tovɨreco che vɨhasa oyese yuvɨreco’ viya; ‘toyembovɨharete catu yuvɨreco’ che hesa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Co che porocuaita: Peyeaɨsu ñepei-pei, inungar che opoaɨsu. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ndipoi eté que poroaɨsusa ɨvate catu vahe co sui omondose que ava güecocuer omborɨpar rese nara. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pe che mboyeroyase peye, ahese che mborɨpar peico. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","‘Pe mbiguai peico’ ndahe iri pẽu. Esepia, mbiguai ndoicuai eté mbahe güerecuar pɨhañemoñetasa. Sese, ‘Che mborɨpar’ ahe pẽu. Esepia, aicua ucapa ñehesa che Ru cheu omombehu vahe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pe niha ndache poravoi peye. Che rumo opoporavo iyavei opocuai peporavɨquɨ vaherã ava reru ãgua cheu ‘che rese ité toyuvɨrecoi’ che yapave. Evocoiyase che Ru omboura mbahe pe porandusa che rer pɨpe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Co rese opocuai: Peyeaɨsu catu ñepei-pei peyacatu” ehi Jesús güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Acoi ava ndoicuai vahe Tũpa pe amotarẽhɨse, peicuaño che rane che amotarẽhɨ yuvɨreco yɨpɨndar. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pe peico vɨtese ava Tũpa ndoicuai vahe pãhuve, evocoiyase pe raɨsu aira yuvɨreco viña. Che rumo opoporavo ipãhu sui yuvɨreco. Sese tẽi ndape ambota iri yuvɨreco. Esepia, pe ndahe iri ipãhu pendar peico. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Peyemomahenduha pẽu aipo che hesa rese: ‘Ndipoi eté que mbiguai ɨvate catu vahe güerecuar sui’ ahe. Che niha yɨpɨndar yamotarẽhɨmbrɨ aico, pe avei pe amotarẽhɨra yuvɨreco. Acoi omboyeroya vahe rumo che porombohesa, pe porombohesa avei omboyeroyara yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Co opacatu mbahe che recocuer sui tẽi ẽgüe ehira pẽu. Esepia, ndoicuai niha che mbousar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","24","“Che ndayuise ahe ava upe mbahe sembiavɨ mombehu viña, evocoiyase, ‘Peyavɨ mbahe’ ndehi chira Tũpa chupe yuvɨreco viña. Che rumo ayu ité, amombehu mbahe sembiavɨ yuvɨreco chupe, ayapo avei mbahe ava ndoyapoi vahe yuvɨreco ipãhuve; ahe rumo yepe osepia co mbahe yuvɨreco viña, che amotarẽhɨño, che Ru avei oyamotarẽhɨ yuvɨreco. Sese, ‘Pereco ité mbahe pe rembiavɨ peyese’ ehi Tũpa chupe. Esepia, acoi che amotarẽhɨ vahe, che Ru avei oyamotarẽhɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Co rumo ẽgüe ehi. Esepia, imboavɨyesa rane itera ñehesa sesendar icuachiaprɨ pɨpe aipo ehi vahe: ‘Mbahe apoẽhɨ pɨpe sui tẽi che amotarẽhɨ yuvɨreco’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Acoi ambouse rumo Poropɨ̃tɨvɨisar, Espíritu supi eté vahe che Ru sui pẽu, ahe omombehura che recocuer. ");
INSERT INTO gyrNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Pe avei pemombehura che recocuer. Esepia, yɨpɨsuive ité peico che rupi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","2","“Pe mocañɨehɨ ãgua che rese pe yeroyasa aipo ahe opacatu co mbahe imombehu pẽu: pe mombora judío rerecuar oñemonuhasa sui yuvɨreco, pe yuca aveira yuvɨreco. Ahe rumo omohara, ‘Tũpa uve nara revo na yahe’ ehira yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Evocoi rumo ẽgüe ehira yuvɨreco che Ru cuaẽhɨ pɨpe iyavei che cuaẽhɨ pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amombehu aipo pẽu acoi ẽgüe ehise, peyemomahenduhara che remimombehugüer rese. “Yɨpɨsuive rumo namombehui co mbahe pẽu. Esepia, aicoveño ité pe rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cũritei rumo asora che mbousar pɨri iyavei ndipoi que ñepei pe pãhu pendar ‘¿que vo aipo eresora?’ ehi vahe cũritei cheu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pe rumo ndapeyembovɨhaiño aipo mbahe amombehuse pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Supi eté rumo aipo ahe pẽu: avɨye catura pẽu che asose. Esepia, ndasoise viña, ndoui chietera pe rese Poropɨ̃tɨvɨisar. Asose rumo, che amboura pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ouse ahe, oicua ucara ava che cuaẽhɨsar upe yangaipa, oicua uca aveira tecocuer ɨ̃visa iyavei cañɨsa ndaseco põrai vahe upendar. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Oicua ucara yangaipa chupe ndache reroyaise yuvɨreco; ");
INSERT INTO gyrNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","oicuara rumo che reco ihɨ̃vi tuprɨ vahe yuvɨreco. Esepia, asora che Ru recosave, ahese pe ndache repia iri chietera peye; ");
INSERT INTO gyrNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","iyavei oicuara Tũpa poromocañɨsa. Esepia niha, Caruguar, ahe co ɨvɨ pɨpendar rerecuar oipɨsɨra che Ru Tũpa ñemoɨrosa. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Setá iteanga mbahe oime amombehu vaherã pẽu. Pe rumo ndapeicatui chira cũritei senducua. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ouse rumo Espíritu supi eté vahe, ahe pe mbohera mbahe supi eté vahe rese. Esepia, noñehei chira oyesui tẽi, ahe rumo omombehura mbahe osendu vahe güeraño, oicua uca aveira mbahe coiye oime vaherã. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ahe che mboeteira. Esepia, oicua ucara opacatu mbahe cheundar pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Opacatu mbahe che Ru vɨreco vahe, che mbahe. Sese niha, ‘Espíritu oipɨsɨra opacatu mbahe cheundar, oicua uca aveira pẽu’ ahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Avɨyeteramo tẽi ndache repia iri chira peye. Ipare rumo coiye catumi che repia irira peye” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Evocoiyase ore oroporandu-randu tẽi oreyeupe aipo orohe: —¿Mara oya pĩha: ‘Avɨyeteramo tẽi ndache repia iri chira peye’ ehi yandeu; ipare rumo aipo coiye catumi yasepiara iyavei aipo osora Vu pɨri no? ");
INSERT INTO gyrNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Mara oya vo aipo: ‘Avɨyeteramo tẽi’ ehi? Ndayasenducuai mo aipo iñehesa —orohe oreyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ipare rumo ‘oporandura co mbahe rese yuvɨreco cheu’ oya aipo ehi voi oreu: —¿‘Ipare rumo coiye catumi che repia irira peye’ che he agüer rese co pe porandu vɨte peyeupe? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Supi eté aipo ahe pẽu: peyasehora pe vɨharẽhɨsa pɨpe, ava angaipa viyar rumo ovɨhareteñora yuvɨreco. Yepe pe, ndapevɨhai chira viña, coiye catu rumo pevɨharetera. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Inungar acoi que cuña imembɨra potase, tasɨ chupe oyepotase arɨ imembɨra ãgua; pĩtani oha pare rumo, nimahenduha iri tasɨcuer rese; sorɨveteño omembrɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ẽgüe peye avei; pe cũritei tasɨ avei pẽu, ayevɨ irira rumo pe repia ãgua, ahese pevɨharetera. Ahe vɨharetesa ndipoi chietera que ava vɨrocua vaherã pe sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Ahe arɨ pɨpe, ndapeporandu iri chietera mbahe rese cheu. Supi eté aipo ahe pẽu: che Ru omboura opacatu mbahe pẽu che rer pɨpe peporanduse. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cũritei rumo ndapeporandu vɨtei mbahe rese che rer pɨpe. Peporandu catu sese, ahese peipɨsɨra. Ipɨpe sui perorɨvete catura. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Opacatu mbahe rese niha amboyoya tecocuer pẽu. Oimera rumo arɨ namboyoya iri chira ambuae mbahe rese tecocuer; ipa voi amombehu itera mbahe pẽu che Ru recocuer resendar. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ahe arɨ pɨpe pe peporandura mbahe rese che rer pɨpe; che rumo, ‘Ayeroquɨra pe rese che Ru upe’ ndahei pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Esepia, che Ru ae ité pe raɨsu. Pe raɨsu ité niha. Esepia, pe che raɨsu peye, che reroya avei che Ru Tũpa sui che yuse peye. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Asẽ che Ru sui co ɨvɨ pɨpe vitu; cũritei rumo aseyara co ɨvɨ, ayevɨra che Ru upe” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Evocoiyase ore aipo orohe chupe: —Indó, aipo rupi ereñehe tuprɨ catu ité; nderemboyoya iri ambuae mbahe rese imombehu oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Supi eté ereicua opacatu mbahe, ereicua avei ore porandusa. Evocoiyase ndiya iri ore porandu ãgua mbahe rese ndeu. Sese orovɨroya Tũpa sui nde yusa —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","—¿Evocoiyase che reroya ité peye? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Supi eté oyepota arɨ cute, co pɨpe ité peyemosaipara che sui; che reyara che aemi peye. Ndahei rumo che ae aico. Esepia, che Ru secoi che rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Amombehu co opacatu pẽu che rese mbahe tuprɨ pɨpe pe reco ãgua. Peparaɨsu itera co ɨvɨ pɨpe; peyemonguerẽhɨ catura rumo. Esepia, che opa ité asecopɨ co ɨvɨ pɨpendar mbahe tẽi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Aipo ohe pare, Jesús omahe ɨva rese aipo ehi: “Che Ru, oyepota arɨ cute. Che mboetei eve, ipɨpe sui avei che nde Rahɨr toromboetei. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Supi eté niha, nde erembou che mborerecua ãgua opacatu ava ɨvɨ pɨpendar harɨve iyavei tecovesa apɨrẽhɨ mondo ãgua opacatu ava nde cheu erembou vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Co niha tecovesa apɨrẽhɨ, tande cua nde Tũpa ñepei supi eté vahe nde recose yuvɨreco, tache cua avei nde che mbouse yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Che niha oromboetei co ɨvɨ pɨpe, iyavei ayapo nde che cuaisa. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sese che Ru, embou irimi cũritei che reco porañete ãgua, inungar acoi yɨpɨndar areco vahe nde rese ɨvɨ apoẽhɨseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Co nde rembiporavo ava co ɨvɨ pɨpendar pãhu sui erembou vahe cheu; orocua ucapa chupe. Yɨpɨndar ndeundar yuvɨrecoi. Ipare nde erembou cheu. Ahe vɨroya ité nde ñehe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Cũritei oicuapa opacatu mbahe nde suindar cheu erembou vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Esepia, amombehu ité nde ñehe erembou vahe cheu; ahe vɨroya ité yuvɨreco, vɨroya avei nde che mbousa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Che ayeroquɨ cheu nde remimbou rese ndeu. Esepia, ndeundar ité yuvɨrecoi; ndayeroquɨi rumo ambuae ava che reroyasarẽhɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Opacatu ava cheundar, ndeundar avei; ndeundar evocoiyase cheundar. Ahe sese che reco porañetesa oyecua. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Che ndapɨtai chira co ɨvɨ pɨpe; ahe rumo opɨtara cohave yuvɨreco. Che evocoiyase asora nde pɨri. Che Ru, seco maranehɨ vahe, esãro nde pĩratasa pɨpe nde remimbou cheu oyese yuvɨrecoi tuprɨ ãgua inungar yande yaico. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Aicose co ɨvɨ pɨpe, asãro tuprɨ nde rer pĩratasa cheu erembou vahe pɨpe; chemahemoha yuvɨreco sese mbahe tẽi sui. Ndipoi eté que ñepei ocañɨ tẽi vahe; acoi yɨpɨve ocañɨ vaheño ité rumo ocañɨ tẽi; nde ñehe rupi tuprɨ ité ẽgüe ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Cũritei asora nde recosave. Co ɨvɨ pɨpe che reco vɨtese rumo, amombehu co mbahe chupe ‘tovɨreco che vɨharetesa yuvɨreco’ che yapave. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Che niha amombehu nde ñehe yuvɨreco chupe. Ava che reroyasarẽhɨ rumo oyamotarẽhɨño yuvɨreco. Esepia niha, ndahe iri Caruguar povrɨ pendar yuvɨrecoi inungar che ndahei ipovrɨ pendar aico. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","‘Enose ava Caruguar povrɨ pendar pãhu sui’ ndahei ndeu, che rumo aipota eresepɨra Caruguar sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Inungar che ndahei Caruguar povrɨ pendar aico, ẽgüe ehi avei ahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Eipeha tuprɨ angaipa sui ndeyeupe nara yuvɨreco ñehesa supi eté vahe reroyase. Nde ñehesa niha supi tuprɨ vahe ité. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Inungar nde che mbou eve ava co ɨvɨ pɨpendar pãhuve, ẽgüe ahe avei che imondo ava pãhuve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amondo ité che recocuer ndeu nara ‘toyemondo catu yuvɨreco chupe co ñehesa supi tuprɨ vahe reroya pɨpe’ viya. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ndayeroquɨi co che remimbohe reseño ndeu, ayeroquɨ avei rumo ambuae ava che reroyasar ñehesa sui che reroya vaherã rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aporandu avei ndeu toyuvɨrecoi tuprɨ ité yuvɨreco oyese inungar ñepei vahe, ẽgüe tehi avei yuvɨreco yande rese, che Ru, inungar nde ereico che rese, che avei aico nde rese. Toyuvɨrecoi tuprɨ ité catu yuvɨreco oyese. Ipɨpe sui ava co ɨvɨ pɨpendar tovɨroya nde che mbousa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Che reco porañetesa nde erembou vahe cheu, ahe tuprɨ avei amondo yuvɨreco chupe ñepei vahe nungar yuvɨrecoi ãgua, inungar yande ñepei vahe yaico. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Che aico yuvɨreco sese, nde evocoiyase ereico che rese ahe yuvɨrecoi tuprɨ ãgua inungar ñepei vahe. Ipɨpe sui ava co ɨvɨ pɨpendar toicua nde che mbousar ereico iyavei eresaɨsu che remimbohe yuvɨreco inungar nde che raɨsu eve. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Che Ru, nde niha erembou co che remimbohe cheu. Aipota rumo ahe yuvɨrecoi che pɨri che recosave osepia vaherã teco porañetesa cheu erembou vahe yuvɨreco. Nde niha yɨpɨve ité che raɨsu eve ɨvɨ apoẽhɨseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Che Ru, seco catuprɨ vahe, ava co ɨvɨ pɨpendar tẽi nande cuai yuvɨreco; che rumo orocua ité, co avei oicua nde che mbousa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Orocua uca chupe, orocua ucaño vɨte itera rumo. Evocoiyase nde che raɨsusa tovɨreco avei yuvɨreco, che avei taico yuvɨreco sese” ehi Jesús oyeroquɨ güemimbohe recocuer rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aipo ohe pare, Jesús ore renose ore reraso ɨembɨ Cedrón rovai. Aheve oime mbahe mitɨ rẽta, ipɨpe Jesús ore reroique ore reraso. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iyavei Judas omondo vaherã yamotarẽhɨmbar upe oicua avei aheve secosa. Esepia, setá rupi Jesús rese oroñemonuha aheve yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Sese Judas oyepotaño ité aheve sundao rehɨi reseve iyavei sundao tũparo rãrosar pahi rerecuar iyavei fariseo eta remimondo opacatu oyoepɨsa reseve yuvɨrecoi, guataendɨ reseve-seve avei yuvɨraso. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yɨpɨve ité rumo oicua oyeupe mbahe oime vaherã. Sese osẽ voi eté yuvɨreco chupe oporandu: —¿Ava vo peseca? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ahe ava rehɨi omboyevɨ yuvɨreco chupe: —Jesús, Nazaret pendar, oroseca —ehi. —Che niha ahe aico —ehi ava rehɨi upe. Judas ipãhuve secoi imondo ãgua yamotarẽhɨmbar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Che niha ahe aico” ehise ava upe; guaquɨcuei cotɨ pãve opa ovɨapi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Evocoiyase oporandu iri ava upe: —¿Ava vo peseca? —ehi. Ahe aipo ehi yuvɨreco: —Jesús, Nazaret pendar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Aipo ihese, —“Che niha ahe aico” ahe pẽu —ehi—. Che che recase peye, pepocoi rene catu co ambuae rese, toyuvɨrasopaño —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Co rumo iñehe mboavɨye ãgua ẽgüe ehi: “Acoi che Ru ombou vahe cheu, nocañɨi eté que ñepei che sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Evocoiyase Simón Pedro vɨreco vahe quɨse, vɨnose, oyasɨa Malco serer vahe nambi yasu cotɨndar, ahe pahi rerecuar ɨvate catu vahe rembiguai. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pedro upe rumo aipo ehi: —Emondo iri quɨse sɨru pɨpe —ehi—. Che Ru niha co mbahe yavai vahe ombou cheu. Añemosaño itera chupe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Evocoiyase sundao rerecuar, osundao eta reseve iyavei judío tũparo rãrosar oipɨsɨ Jesús yuvɨreco, oipocua. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Yɨpɨndar vɨraso Anás rẽtave yuvɨreco. Esepia, ahe Caifás rovayar. Ahe aravɨter pɨpe aipo Caifás pahi eta rerecuar ɨvate catu vahe secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás ité aipo ehi omboetasa upe: “Yandeu avɨye catu itera que ñepei mbɨa omanose yande rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ore Pedro rese orosoño ité Jesús raquɨcuei. Che rumo pahi eta rerecuar rẽta pɨpendar opa ité che cua yuvɨreco. Sese aiqueño ité Jesús raquɨcuei mborerecuar rẽtave vicho. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro rumo opɨtaño oquendɨpɨve ocarve. Che rumo pahi eta rerecuar che cua ité yuvɨreco. Evocoiyase asẽ, aporandu oquendɨpɨ rãrosar uve Pedro reique ãgua rese. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Evocoiyase oquendɨpɨ rãrosar oporandu Pedro upe: —¿Ndahei vo nde avei co ava rupindar? —ehi chupe. —Aní, ndahei che ahe —ehi oquendɨpɨ rãrosar upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sõhɨsá iteanga ahe pɨ̃tu pɨpe. Evocoiyase mborerecuar rembiguai iyavei sundao eta oyatapɨ yuvɨreco oyepehe ãgua. Pedro avei aheve ipãhuve oyepehe tata ɨpɨve ohã. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pahi eta rerecuar ɨvate catu vahe, “¿Uma-uma vo nde remimbohe yuvɨrecoi iyavei mbahe rese vo erembohe?” ehi oporandu Jesús upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús rumo aipo ehi chupe: —Che niha añehe opacatu rupi, opacatu ava eta rovaque avei. Esepia, aporomboheño ité niha ava ñemonuhasa rupi, tũparo guasu pɨpe avei. Indó, che nañemi eté añehe vaherã. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Mahera vo evocoiyase cheu tẽi ereporandu? Eporandu catu che ñehe rendusar upe. Ahe tomombehu che oyeupe ñehesa yuvɨreco ndeu. Ahe niha oicua che ñehe agüer yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Aipo ihese, ñepei mbɨa sundao osovapete aipo ehi chupe: —¿Aipo ere rutei pahi rerecuar ɨvate catu vahe upe imboyevɨ? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Evocoiyase omboyevɨ ahe mbɨa upe: —Añehese mbahe tẽi rese, emombehu che ñehe raisa; che rumo añehe tuprɨ ité, ¿mahera vo evocoiyase che rovapete eve? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Evocoiyase Anás omondo pahi eta rerecuar ɨvate catu vahe Caifás upe ipocuasa reseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ahese Pedro oyepeheño vɨte ohã tata ɨpɨve. Aheve aipo ehi yuvɨreco chupe: —¿Ndahei vo nde ité evocoi ava rupindar ereico? —ehi. Pedro rumo, —Aní, ndahei che ahe aico —ehiño. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ipare mbɨa pahi rerecuar ɨvate catu vahe rembiguai, inambi asɨaprɨ mu aipo ehi chupe: —¡Avɨye acoi nde ité oroepia vahe mbahe mitɨ rẽta pɨpe supi! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro rumo, “Aní, ndahei eté che” ehi iriño. Aipo iheseve, tacura oñehe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Evocoiyase vɨraso Jesús Caifás rẽta sui Roma pendar mborerecuar guasu recosave yuvɨreco. Cõhe potase ẽgüe ehi. Judío rumo ndoyuvɨroiquei eté mborerecuar recosave oyemboangaipaẽhɨ ãgua. Esepia, ahe icuaita yuvɨroiquese, ndiyai chietera Pascua resendar ovesa roho hu ãgua yuvɨreco chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sese Pilato osẽ ava upe aipo ehi: —¿Mbahe vo sembiapo naporai vahe? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ahe omboyevɨ yuvɨreco chupe: —Seco catuprɨse, ndorogüerui chietera ndeu viña —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Evocoiyase aipo ehi ava upe: —Peraso, pe ae peyapo mbahe pẽundar ité porocuaita rupi sese —ehi. Judío rerecuar evocoiyase omboyevɨ yuvɨreco: —Ore judío oroico vahe upe rumo ndipotasai oroyuca vaherã que ava —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ẽgüe ehi Jesús ñehe imano ãgua resendar yavɨye. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ahese Pilato oique iri oɨ pɨpe, güeru uca Jesús oyeupe oporandu chupe: —¿Nde ité vo judío rerecuar ɨvate catu vahe ereico? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—¿Ndeyesui eté aipo ereporandu cheu, anise, oime tie que ambuae ava che mombehu vahe ndeu? —ehi Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—¡Che ndahei eté judío aico! Nde recua pendar ae niha pahi eta rerecuar nde reru yuvɨreco cheu. ¿Mbahe vo evocoiyase ereyapo? —ehi Pilato chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—Che mborerecuasa rumo ndahei co ɨvɨ pɨpendar. Co ɨvɨ pɨpendarse viña, che rupindareta ovavara che amotarẽhɨmbar upe che repɨsave yuvɨreco viña. Che mborerecuasa rumo ndahei eté coha pendar —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ahese Pilato aipo ehi chupe: —Evocoiyase nde mborerecuar guasu ité ereico —ehi. —Nde niha aipo, “Mborerecuar guasu ereico” ere cheu. Aherã niha che aha co ɨvɨ pɨpe mbahe supi eté vahe mombehu ãgua. Opacatu ava vɨroya vahe mbahe supi eté vahe, osenduño ité che ñehesa yuvɨreco —ehi Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato rumo, —¿Mbahe vo aipo supi eté vahe? —ehi chupe. Aipo ohe pare, Pilato osẽ iri judío eta upe oñehe aipo ehi: —Che ndayosui eté co mbɨa rese mbahe sembiavɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pe rumo peicua amose ñepei ava soquendaprɨ Pascua pieta pɨpe yepi; ¿peipota amose vaherã judío rerecuar? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aipo ihese, opacatu osapucai pĩratá yuvɨreco aipo ehi: —¡Evocoi aní! ¡Barrabás catu emose! —ehiño yuvɨreco. Barrabás rumo imonda rai vahe secoi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Evocoiyase Pilato oporocuai Jesús nupa ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sundao eta omonde ñaca rese yu pɨaprɨ iyavei omboyemonde turucuar pĩraumbɨ vahe pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ipare oyemboya sese aipo ehi: —¡Imboeteiprɨ judío Rerecuar tasecoi! —ehi angahu sovapete-pete yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato evocoiyase osẽ iri ava upe aipo ehi: —Pesepia, anose pẽu pe icua ãgua che ndayosui eté mbahe sembiavɨ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Evocoiyase vɨnose yu pɨaprɨ oãca rese turucuar pĩraumbɨ vahe reseve senoha ava upe. Ahese Pilato aipo ehi: —¡Ndo co aipo mbɨa cute! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Osepiase pahi eta rerecuar, sundao rerecuar avei, omboɨpɨ osapucai: —¡Tayatɨcasa! ¡Tayatɨcasa! —ehi pãve voi yuvɨreco chupe. Pilato evocoiyase aipo ehi ava upe: —Peraso, peyatɨca pe ae. Esepia, che ndayosui eté mbahe sembiavɨ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judío rerecuar rumo omboyevɨ yuvɨreco: —Ore rumo orovɨreco mborocuaita. Ipɨpe omanoño itera. Esepia, oyeapo tẽi Tũpa Rahɨr —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aipo ñehesa renduse, Pilato oyembosɨquɨyé catu. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Vɨroique iri oɨ pɨpe seraso. Aheve oporandu chupe: —¿Que pendar ité vo nde ereico? —ehi. Ahe rumo nomboyevɨ iri eté iñehe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Evocoiyase Pilato aipo ehi chupe: —¡Mahera ndereñehei eté cheu! ¿Ndereicuai vo che mborerecuar aico nde atɨca uca ãgua, mbahe tẽi sui nde renose ãgua avei? —ehi Pilato chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—¡Aní! Ndererecoi chietera nde mborerecuasa che harɨve Tũpa nombouise ndeu viña. Sese niha ava che mondosar ndeu oyemboangaipa catu nde sui yuvɨreco —ehi Pilato upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ahe ramoseve, Pilato osãha iri tẽi Jesús renose ãgua; judío rerecuar rumo osapucai voiño yuvɨreco chupe: —¡Acoi eremosese co mbɨa, ndahei chietera nde mborerecuar ɨvate catu vahe mborɨpar ereico! ¡Opacatu oyemomborerecua tẽi vahe, ahe evocoiyase mborerecuar ɨvate catu vahe amotarẽhɨmbar tẽi yuvɨrecoi! —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Evocoiyase Pilato osenduse aipo ihesa, vɨnose uca Jesús ocarve, oguapɨ mborerecuar guasu renda harɨve. Ahe mbahe rese porandusa rer hebreo ñehe pɨpe Gabata ‘ita apoprɨ’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Mbɨter arɨ Pascua pieta ãgua Pilato aipo ehi judío eta upe: —¡Ndo co pe rerecuar cute! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ahe rumo osapucai pĩratá aipo ehi yuvɨreco: —¡Tomano! ¡Tomano ité! ¡Tayatɨcasa! —ehi yuvɨreco chupe. Pilato rumo aipo ehi chupe: —¿Evocoiyase ayatɨca ucara pe rerecuar? —ehi. Pahi eta rerecuar rumo omboyevɨ yuvɨreco chupe: —¡Ore ndorovɨreco iri ambuae mborerecuar, Roma pendar mborerecuar ɨvate catu vahe güeraño ité orovɨreco! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ipare Pilato omondo sundao upe yatɨca uca ãgua. Ichui vɨraso yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Evocoiyase Jesús vɨnose curusu seraso “Ava Ãcagüer” serer vahesave (ahe serer hebreo ñehe pɨpe Gólgota). ");
INSERT INTO gyrNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Aheve oyatɨca yuvɨreco. Seseve avei oyatɨca ñuvɨrío ava yuvɨreco, ñepei-pei yɨque ɨvɨi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato oicuachía uca omondo curusu rese aipo ehi vahe: “Co Jesús, Nazaret pendar, judío Rerecuar guasu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Setá iteanga ava oyeroquɨ co icuachiaprɨ rese yuvɨreco. Esepia, icuachiasa hebreo, latín iyavei griego ñehe pɨpe. Iyavei yatɨcasa namombrɨimi eté tecua sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sese pahi eta rerecuar aipo ehi Pilato upe yuvɨreco: —Aní, ‘Judío Rerecuar guasu’ ere icuachía; iyacatu rumo, ‘Oyeapo pota tẽi vahe judío Rerecuar guasu’ erera icuachía imoi —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilato rumo omboyevɨ: —Co aicuachía vahe, ẽgüe ehiño itera oĩ —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesús atɨca pare evocoi irungatu sundao, omonuha iturucuar oyeupe imboyaho ãgua yuvɨreco. Oipɨsɨ avei iturucuar ivrɨ pendar nimbovɨvɨsai vahe, ñepei reseve pucuño tẽi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sundao eta aipo ehi oyeupe yuvɨreco: —Yamondoro eme; avɨye catu yandeguayɨño sese, ¿ava ité pĩha oipɨsɨra? —ehi yuvɨreco. Ẽgüe ehi icuachiapɨrer imboavɨye yuvɨreco aipo ehi vahe: “Omboyaho-yaho ava che turucuar iyavei iguayɨ yuvɨreco sese” ehi vahe. Supi tuprɨ ité ẽgüe ehi sundao yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Curusu ɨvɨpɨve yuvɨrecoi ichɨ, ichɨ cupɨhɨr, María Cleofas rembireco, María Magdalena avei. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Osepiase osɨ iyavei che repiase yɨ́pɨve, che güembiaɨsu, aipo ehi osɨ upe: —Che sɨ, evocoi nde membɨrã ererecora —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ipare voi aipo ehi cheu: —Evocoi nde sɨ —ehi. Ichuive tuprɨ amoingue ichɨ che rẽtave asãro vaherã. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ipare Jesús oicua ité Vu remimbotar yavɨyepa iyavei icuachiapɨrer mboavɨye ãgua aipo ehi: —Che husei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aheve oime mbahe rɨru. Ipɨpe savapɨpo vinagre oĩ. Co vinagre pɨpe omoaquɨ mbahe saviyu vahe yuvɨreco omondo ɨvɨra rese, osupi, imondo iyuruve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Osupɨte pare aipo ehi: —Opa yavɨye cute —ehi. Ipare voi ñaca ɨvɨso omano. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ñepei arɨ Pascua pieta uve ipane vahe pɨpe aipo ẽgüe ehi. Sese judío ndoipotai ava retecuer pɨta curusu rese mbɨtuhusa arɨ pɨpe. Esepia, ahe mbɨtuhusa arɨ imboeteiprɨ guasu ité. Sese Pilato upe oporandu yuvɨreco ahe oyocuai vaherã sundao curusu rese yatɨcaprɨ rẽtɨma mope ãgua ‘tomano’ oyapave curusu sui setecuer reroyɨpa ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Evocoiyase sundao yuvɨrasopa ñuvɨrío mbɨa Jesús rese yatɨcasa vahe yuvɨreco. Ahe sẽtɨma rane opa omope yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Oyemboyase rumo Jesús rese, “Omano ité” ehiño yuvɨreco chupe. Sese nomopei sẽtɨma yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ñepei sundao rumo oicutu yɨqueve lanza pɨpe. Ahe ramoseve voi osẽ suvɨ, ɨ reseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Che asepia vahe ité; supi eté aipo ahe. Evocoiyase amombehu pẽu pe seroya ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Esepia, co mbahe ẽgüe ehi icuachiapɨrer mboavɨye ãgua aipo ehi vahe: “Ndimopesai chietera que ñepei icangüer” ehi vahe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Iyavei ambuae icuachiaprɨ aipo ehi: “Osepiara ava eta icutuprɨ yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ipare José, tecua Arimatea pendar, oporandu Pilato upe Jesús rehõgüer reraso ãgua rese. José aipo Jesús rupindar. Ndoyecua ucai rumo omboetasa judío eta upe pahi rerecuar sui osɨquɨyepave. Pilato evocoiyase, “Avɨye, eraso” ehi chupe. Evocoiyase José oso vɨraso sehõgüer. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo avei oipɨ̃tɨvɨi, acoi oso vahe Jesús upe pɨ̃tuse. Ahe güeru mbahe sɨ̃acua vahe mirra, áloe rese oyeseha vahe, treinta kilo, sehõgüer rese nara. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ẽgüe ehi José, Nicodemo reseve vɨraso sehõgüer yuvɨreco iyavei oimama tuprɨ turucuar secose vahe imoɨacuaprɨ pɨpe yuvɨreco. Ẽgüe ehi judío oyapo ava omano vahe tɨ̃ ãgua yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Namombrɨi Jesús atɨcasa sui oime mbɨa remitɨ rẽta. Aheve ité oime tuvɨpa ita hoprɨ, ipɨasu vahe iporupɨrẽhɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ipɨpe omoingue Jesús rehõgüer yuvɨreco. Esepia, ahe tuvɨpa cõimi eté ichui iyavei vɨrovɨ ité judío pɨtuhusa arɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingu pɨpe María Magdalena oso tuvɨpave pɨ̃tu vɨtemiseve. Ahe osepia ita tuvɨpa rovapɨsa ndahe irise güendave ihãi. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Evocoiyase ahe cuña oña oso Simón Pedro upe, cheu avei aipo ehi: —¡Vɨraso tuvɨpa sui yande Yar yuvɨreco! ¡Ndoroicuai que vo catu omondo yuvɨreco! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Evocoiyase Pedro rese oroña oroso tuvɨpave. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Che rumo aña catu Pedro sui. Che rane evocoiyase ayepota tuvɨpave. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Aivɨro tẽi, turucuar güeraño rumo asepia aheve. Ndaiquei rumo ipɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ipare Pedro oyepota che raquɨcuei, oique voi tuvɨpa pɨpe. Ahe avei osepia turucuar imama agüer tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iyavei osepia turucuar ñaca mamasa. Ndahei eté setecuer mamasa rese tui; ahe rumo co cotɨ ité ipoquesa tuprɨ ou. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Evocoiyase che avei aique; asepia ẽgüe ehi vahe. Ahese aroya voi eté. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ore rumo ndorosenducua vɨtei eté icuachiaprɨ: “Ocuerayevɨra omano vahe pãhu sui” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ipare oroyevɨpa oroso ore rẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María rumo, ore raquɨcuei ou vahe, opɨtaño ité tuvɨpa ɨpɨve, oyaseho. Oyasehoseve oivɨro iri tuvɨpa pɨpe, ");
INSERT INTO gyrNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ahese osepia ñuvɨrío Tũpa rembiguai iturucuar morochí vahe oguapɨ yuvɨnoi sehõgüer rupagüerve. Ñepei oguapɨ oĩ ñaca rupagüer cotɨ, ambuae ipɨ rupagüer cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ahe Tũpa rembiguai oporandu yuvɨreco chupe: —Cuña, ¿mahera vo ereyaseho? —ehi. Ahe aipo ehi: —Esepia, che Yar rehõgüer vɨraso yuvɨreco iyavei ndaicuai que vo catu omondo yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aipo oheseve, oyemboyere, osepia Jesús aheve secoise; “Jesús co secoi” ndehi eté rumo chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Evocoiyase oporandu María upe: —Cuña, ¿mahera vo ereyaseho? ¿Ava vo ereseca? —ehi chupe. Ahe omoha ‘co mbahe mitɨ rẽta rãrosar revo’ oya viña, aipo ehi chupe: —Nde ererasose sehõgüer, emombehuñomi tẽi cheu que vo eremondo. Aheve taso seca —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Evocoiyase, —¡María! —ehi chupe. Ahe aipo hese, oyemboyere, aipo ehi hebreo ñehe pɨpe chupe: —¡Rabuni! —ehi (‘Porombohesar’ ohesave). ");
INSERT INTO gyrNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Evocoiyase María upe, —Erepocoi rene che rese. Esepia, ndayeupi vɨtei che Ru recosave. Esoño, emombehu che reroyasar upe: “Jesús oyeupira Vu Tũpa recosave” erera chupe. Che Ru, pe Ru avei; che Tũpa, pe Tũpa avei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Evocoiyase María Magdalena ou imombehu: “Asepia yande Yar” ehi iyavei opa omombehu mbahe semimombehu oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ahe arɨ pɨpeve, domingu pɨpe, pɨ̃tuse, ore ore ñemonuhasave oroyeoquenda tuprɨ judío rerecuareta sui ore sɨquɨyepave. Ahese Jesús oique ore pãhuve. Ore mboavɨrave. —¡Peico tuprɨ! —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aipo ohe pare, omboyecua opo, oɨque avei oreu. Ahese orerorɨvete yande Yar repiase oroico. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ipare aipo ehi iri: —¡Peico tuprɨ! Inungar che Ru che mbou, ẽgüe ahe aveira co che pẽu —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ichui ore peyu: —Peipɨsɨ Espíritu Santo —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Peñeroise que ava upe, ahese ahe oipɨsɨra ñeroisa; napeñeroise rumo que ava upe, ahe evocoiyase ndoipɨsɨi chira ñeroisa —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ñepei ore mboetasa rumo Tomás icõi vahe, ndipoi eté ore pãhuve Jesús oyemboyecuase oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ipare ore aipo orohe chupe: —Orosepia yande Yar —orohe. Tomás rumo aipo ehi: —¡Too! Acoi asepiase voi eté quɨravo cuarer ipo rese iyavei amoinguese che cuã quɨravo cuarer pɨpe iyavei amoinguese che po yɨque cutu agüerve, ahese ramo aroyara —ehiño oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho arɨ pare, ore oroñemonuha iri oɨ pɨpe oroico. Aheve ramo Tomás secoi ore pãhuve. Yepe oroyeoquenda tuprɨ ité viña, Jesús rumo oiqueño ité ou ore pãhuve, ore mboavɨrave aipo ehi: —¡Peico tuprɨ! —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ipare aipo ehi Tomás upe: —Esepia che po, emoingue nde cuã quɨravo cuarerve; embou ave nde po, emoingue avei che ɨque cutu agüerve. “Tachequerẽhɨ eme seroya ãgua” nderei chira cheu; ¡che reroya eve! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Evocoiyase Tomás aipo ehi: —¡Che Yar Tũpa! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ahese aipo ehi Tomás upe: —¿Cũritei che reroya che repiase eve cute? ¡Avɨye catu ava che repiaẽhɨ pɨpe che reroya vahe! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús oyapo setá ambuae poromondɨisa ore rovaque. Ahe rumo ndaicuachiai co cuachiar pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Co rumo aicuachía ‘tovɨroya Jesús, Poropɨ̃sɨrosar, Tũpa Rahɨr secosa; ipɨpe tovɨreco tecovesa yuvɨreco’ che yapave. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ore sore ɨvɨ Galilea ve, Jesús oyemboyecua iri oreu ɨpa Tiberia ve. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ahese oyeseve Simón Pedro yuvɨrecoi, Tomás ahe acoi icõi vahe, Natanael, ahe aipo tecua Caná pendar ɨvɨ Galilea rese, ñuvɨrío ore Zebedeo rahɨr oroico vahe iyavei ambuae ñuvɨrío Jesús remimbohe. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro aipo ehi: —Asora pira mboha —ehi. Ore avei aipo orohe: —Toroso nde rupi —orohe chupe. Orosoño, oroha carite pɨpe. Ahe pɨ̃tu pɨpe rumo ndorombohai eté pira. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Cõhe potase rumo, Jesús oyemboyecua ɨmbehɨ ɨvɨi. Ore rumo ndoroicuai eté Jesús secose. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Evocoiyase aipo ehi oreu: —Mbɨa chĩhivahe, ¿ndapembohaimi eté pira? —ehi. —Aní eté —orohe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Evocoiyase aipo ehi: —Pemondo pira mbohasa ɨve pe asu cotɨ. Ahese pembohara —ehi. Ẽgüe orohe, ipare voi, “¡Too!” orohe, ndorovɨnose catui eté ɨpɨ sui pira mbohasa oroico. Esepia, savapɨpo tuprɨ ité pira ipɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Evocoiyase che, sembiaɨsu, aipo ahe Pedro upe: —¡Yande Yar niha evocoi! —ahe. Pedro che ñehe rendu ramoseve voi, omonde oturucuar. Esepia, yɨpɨndar nani secoi; opo ɨve oso chupe. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ore evocoiyase orovɨroyepota ité carite ndatɨpɨimisave, oroichoho pira rehɨi imbohasa pɨpe seraso, cien metro tẽi oroico ɨmbehɨ sui. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Orovɨnosese ɨvɨ ãtasave, orosepia tãtapɨi harɨve pira, pan reseve. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Peru movɨro evocoi pira penose ramo vahe —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Evocoiyase Simón Pedro oha carite pɨpe, oichoho ndatɨpɨisave pira guasu rehɨi imbohasa pɨpe, ciento cincuenta y tres tuprɨ; yepe setá viña, imbohasa rumo ndosoroi eté. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Evocoiyase aipo ehi: —Perio, tapecarumi rane —ehi oreu. Ndipoi eté que ñepei ore pãhuve “¿ava vo nde ereico?” ehi vahe chupe. Esepia, oroicuaño ité yande Yar secose. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chupe ore sore, oipɨsɨ pan, ombou oreu, ẽgüe ehi avei pira imbou oreu. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Co rese Jesús oyemboyecua mbosapɨ rupi oreu ocuerayevɨre. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ore caru pare, Jesús oporandu Simón Pedro upe: —Simón, Juan rahɨr, ¿che raɨsu catu ité eve co mbahe sui? —ehi. —Taa, che Yar, ereicua niha che nde raɨsusa —ehi Pedro chupe. —Ndehañeco tuprɨ ru catu che reroya ramomi vahe rese yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Imoñuvɨriosa rupi oporandu iri chupe: —Simón, Juan rahɨr, ¿che raɨsu catu ité eve? —ehi. —Taa, che Yar, nde ereicua che nde raɨsusa —ehi Pedro chupe. —Evocoiyase esãro tuprɨ che reroyasar yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Imombosapɨsa rupi oporandu iri chupe: —Simón, Juan rahɨr, ¿che raɨsu vo eve? —ehi. Aipo oyeupe hese, Pedro ndoyembovɨhai eté aipo ehi: —Che Yar, nde niha opacatu ereicua, nde avei ereicua che nde raɨsusa —ehi. —Evocoiyase ndehañeco tuprɨ catu che reroyasar rese —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Supi eté aipo ahe ndeu: nde chĩhivahe catu vɨtese, ereyemonde vɨte nde ae, ereguata vɨte avei nde remimbotar rupi; nde cuacua catuse rumo, ereyeyɨvamoatara, ambuae evocoiyase nde mboyemondera, nde reraso aveira nde so potaẽhɨsave —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús rumo omboyecua aipo ohe pɨpe mara ehira Pedro omano Tũpa mboeteisave curi. Ipare, —¡Erio che rupi! —ehi Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Che Jesús rembiaɨsu ité aico, che ité acoi carusa ipa vaheve yɨ́pɨve aĩ acoi aporandu chupe: “Che Yar, ¿ava vo nde mondora nde amotarẽhɨmbar upe?” ahe acoi chupe. Aguatase Pedro raquɨcuei, oyemboyere che repia. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ahese oporandu chupe: —Che Yar, evocoi no, ¿mbahe oimera chupe? —ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Evocoiyase omboyevɨ Pedro upe: —Che aipotase secove vɨte ãgua che yevɨse nara, ¿mara vo nde ererecora viña? Nde catu, eguataño che rupi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sese ambuae Jesús reroyasar ipɨhañemoñeta tẽi aipo che namanoi chivaherã ité yuvɨreco viña. Jesús rumo ndahei ‘nomanoi chietera’ ohesave aipo ehi cheu; ahe rumo, “Aipotase secove vɨte ãgua che yevɨse nara, ¿mara vo nde ererecora viña?” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Che ité amombehu co mbahe, che avei aicuachía iyavei yaicua supi tuprɨ vahe ité che remimombehu. ");
INSERT INTO gyrNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Oime avei ambuae mbahe setá Jesús rembiapo, que opacatú icuachiasase viña, ndiyai chietera revo ɨvɨ viña. Aipo rupive.");
INSERT INTO gyrNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Imboeteiprɨ Teófilo, cuese amondo evocoi che rembicuachía Jesús recocuer resendar ndeu. Opa yɨpɨndar sembiapocuer amombehu ndeu iyavei yɨpɨsui iporombohe agüer. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ocuerayevɨre, ɨvave oso renondeve, Jesús omombehu oporocuaita Espíritu Santo pĩratasa pɨpe güembiporavo apóstol upe sembiaporã. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Oyemboyecua güembiporavo upe omanore. Setá rupi omboyecua tuprɨ ocuerayevɨsa chupe. Semimbohe osepia yuvɨreco imanore cuarenta arɨ rupi. Ahese omombehu Tũpa mborerecuasa resendar güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","5","Oicove vɨtese yuvɨreco sese, aipo ehi chupe: —Pesẽi rene Jerusalén sui. Tomboavɨye rane che Ru Tũpa güemimombehu, ahe acoi amombehu pẽu. Juan niha pe ãpiramo ɨ pɨpe tẽi; Tũpa rumo Espíritu Santo pɨpe pe ãpiramora. Movɨromi tẽi arɨ ipane vɨte imondo ãgua pẽu —ehi güemimbohe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Oñemonuhase apóstol yuvɨreco sese, oporandu yuvɨreco chupe: —Ore Yar, ¿erembou irira vo cũritei Israel ɨguar upe pĩratasa iyeyecuai ãgua? —ehi semimbohe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ahe rumo aipo ehi chupe: —Ndiyai ahe arɨ cua ãgua pẽu. Esepia, Tũpa año ité vɨreco omborerecuasa ahe mbahe apo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Peipɨsɨra rumo Tũpa pĩratasa oiquese Espíritu Santo pe pɨha pɨpe. Ahese pemombehu tuprɨra che recocuer Jerusalén pendar upe, Judea pendar, Samaria pendar iyavei opacatu co ɨvɨ pɨpendar upe avei no —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aipo ihe pare, omahe apóstol yuvɨreco sese, aheseve Tũpa vɨraso ɨvave. Ichui Jesús oique ɨva quɨha pãhuve. Evocoiyase ndosepia iri eté yuvɨreco cute. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Omahe vɨteseve yuvɨnoha ɨvave ichosa rese, avɨyeteramo tẽi ñuvɨrío mbɨa, iturucuar morochí vahe, oyemboyecua apóstol ɨpɨve yuvɨnoha ");
INSERT INTO gyrNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","aipo ehi yuvɨreco chupe: —Galilea ɨguar, ¿mahera vo pemahe vɨte ɨva rese pehã? Evocoi Jesús, inungar Tũpa vɨraso ɨvave pe sui, ẽgüe ehi aveira niha ogüeyɨ ou co ɨvɨ pɨpe coiye —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Evocoiyase apóstol oyevɨ yuvɨraso Jerusalén ve ɨvɨtrɨ Olivo sui, ahe ihamombrɨgüer ñepei kilómetro tẽi. Supivemi imombehusa judío guata ãgua mbɨtuhusa arɨ pɨpe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yuvɨroiquese Jerusalén ve, oyeupipa oquesa oɨ ɨvateve yuvɨreco. Aheve Pedro, Juan, Santiago, Andrés, Felipe, Tomás, Bartolomé, Mateo, Santiago ahe Alfeo rahɨr, Simón ahe Zelote iyavei Judas, Santiago rahɨr yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Co opacatu arɨ yacatu rupi oñemonuha oyoya guasu oyeroquɨ ãgua yuvɨreco yepi Jesús rɨvrɨ, ichɨ, ambuae cuña reseve avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Evocoiyase ñepei arɨ pɨpe oñemonuha guasu ciento veinte ava yuvɨreco. Ipãhuve Pedro opũha aipo ehi ava upe: ");
INSERT INTO gyrNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Che mu eta Jesucristo reroyasar, iya ité co imboavɨyesa Tũpa Ñehengagüer Judas recocuer resendar. Ahe imombehuprɨ David upe Espíritu Santo pɨpe aracahe. Evocoi Judas vɨraso vahe Jesús amotarẽhɨmbar ipɨsɨ uca ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ahe acoi secoi yande pãhuve co mboravɨquɨsa rese yande pɨ̃tɨvɨi ãgua avei viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Evocoi güembiapo ai reprɨ pɨpe omboepɨ ɨvɨ. Ipare ñaca ɨvɨso ovɨapi oso ɨvɨve, oyetɨapɨipa. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Opacatu ava Jerusalén pendar oicua Judas recocuer yuvɨreco. Sese co ɨvɨ upe, ‘Acéldama’ ehi yuvɨreco oñehe pɨpe ‘Ɨvɨ Tuvɨ resendar’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Esepia, icuachiaprɨ Salmo pɨpe aipo ehi: ‘Taseyasa sẽta yuvɨreco. Tipo iri eme ava ipɨpe’ ehi. Iyavei ambuae aipo ehi: ‘Toime ambuae secoyar iporavɨquɨ rãgüer pɨsɨ ãgua’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Evocoiyase cohave oime ava yande Yar Jesús secoi vɨtese yande pãhuve ");
INSERT INTO gyrNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ñapiramosa suive yuvɨrecoiño vahe ité yande rupi iyavei ɨvave ichosa osepia vahe avei yuvɨreco. Ahe tiporavosa ñepei ipãhu pendar yande rupi icuerayevɨ agüer mombehu ãgua” ehi omboetasa upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Evocoiyase oiporavo ñuvɨrío mbɨa yuvɨreco: ahe José Barsabás, serosa Justo; ambuae rer Matías. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ipare oyeroquɨ yuvɨreco aipo ehi: “Nde, ore Yar, opacatu ava pɨha ereicua. Emboyecua cohave nde rembiporavo oreu; ¿uma vo ereipota ");
INSERT INTO gyrNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","eremondo vaherã icuaitarã apóstol seco ãgua Judas recuñara? Ahe oangaipa pɨpe oyemocañɨ uca tẽi vahe oico” ehi Tũpa upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Evocoiyase osãha iporavo yuvɨreco. Matías ité vɨnose iporavoprɨ sui yuvɨreco. Ichui tuprɨ ité oique once apóstol pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Oyepotase Pentecostés pieta, opacatu Jesús reroyasar oñemonuha oɨ guasu pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Aheve oɨ pɨpe avɨyeteramo tẽi ɨvɨtu ipĩrata vahe nungar sɨapu guasu ou ɨva sui. Ahe sɨapugüer oyendupa tuprɨ oɨ pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ahese oyecua tata rendɨgüer nungar opacatu aheve yuvɨrecoi vahe harɨve. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ahese avei Tũpa omoingue evocoi ava pɨha pɨpe oEspíritu Santo. Ichui ahe Espíritu omoñehe uca ambuae ñehesa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ahe arɨ pɨpe setá iteanga judío yuvɨrecoi Jerusalén ve omboavɨye vahe ocuaita Tũpa mboeteisa, ahe oñemonuha vahe opacatu ɨvɨ rupindar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mbahe sɨapu guasu vahe renduse, oñemonuha atɨ tẽi yuvɨreco oyese. Ndoyemboaracuai tẽi yuvɨreco ambuae ava oñehe pɨpe ñehese. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","“¡Too!” ehi tẽi oyepɨhamondɨisa pɨpe yuvɨreco. Sese aipo ehi oyeupe: —¿Ndahei vo acoi co ava Galilea ɨguar oñehe vahe yuvɨreco? ");
INSERT INTO gyrNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Mahera pĩha co ñepei-pei oñehe yande ñehe pɨpe yuvɨreco? —ehi tẽi oyeupe yuvɨreco—. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Esepia, cohave yuvɨrecoi vahe: Partias pendar, Media pendar, Elam pendar, Mesopotamia pendar, Judea pendar, Capadocia pendar, Ponto pendar, Asia pendar, ");
INSERT INTO gyrNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia pendar, Panfilia pendar, Egipto pendar, Libia cotɨndar, ahe Cirene cõquɨvotɨndar. Iyavei Roma pendar, ");
INSERT INTO gyrNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","judío yuvɨrecoi vahe, ambuae judío aracuasa reroyasar avei, Creta pendar, Arabia pendar. ¡Yande yasendu opacatu yandeu iñehe yuvɨreco yande ñehe pɨpe Tũpa rembiapo icatuprɨ vahe! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Opacatu oyepɨhamondɨi, ndoicuai opɨhañemoñeta ãgua yuvɨreco. —¿Mara ehi pĩha co na oya yuvɨreco? —ehi-ehi tẽi yuvɨreco oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ambuae ava rumo seroɨ̃rosa pɨpe aipo ehiño yuvɨreco: —¡Osavaɨpo mo evocoi yuvɨreco! —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Evocoiyase Pedro opũha opacatu once vahe apóstol pãhuve, oñehe pĩrata aipo ehi: “Che mu judío eta, opacatu Jerusalén pendar avei, peicua co mbahe amombehu vaherã pẽu; peyapɨsaca tuprɨ che ñehe rese: ");
INSERT INTO gyrNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ndosavaɨpoi moco co mbɨa yuvɨreco. ¿Ndapesepiai vo añihivei vɨte cũritei? ");
INSERT INTO gyrNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Co niha Tũpa ñehe mombehusar Joel oicuachía vahe aracahe: ");
INSERT INTO gyrNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Tũpa aipo ehi: Coiye, arɨ cañɨ renonde, amondora che Espíritu Santo opacatu ava upe. Ipĩratasa pɨpe pe rahɨr, pe rayrɨ oñehera yuvɨreco. Mbɨa chĩhivahe osepiara oquer pendar nungar mbahe yuvɨreco. Oime aveira queraisa supi eté vahe cuacua vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Supi eté ahe arɨ pɨpe amondora che Espíritu che rembiguai cuimbahe upe, che rembiguai cuña upe avei. Ipare oñehera yuvɨreco che rese ipĩratasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Amboyecuara poromondɨisa ɨva rese. Ẽgüe ahe aveira poromondɨisa mboyecua ɨvɨ pɨpe: tuvɨ, tata iyavei tãtachi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Yande Yar arɨ tuvichá vahe imboeteiprɨ renonde ohara pɨ̃tu, yasɨ oyeapora tuvɨ nungar. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Opacatu ava, che Yar che pɨ̃tɨvɨi eve, ehi vahe, ahe oñepɨsɨrora yuvɨreco’ ehi Joel icuachía aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Pe Israel suindar, pesendu che ñehe: Jesús, Nazaret pendar, oyapo poromondɨisa tuvichá vahe, mbahe yavai vahe Tũpa pĩratasa pɨpe pe pãhuve güeco maranehɨ mboyecua ãgua. Ahe niha peicua opacatu. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ipare rumo evocoi Jesús imondosa pẽu yuca ãgua. Ahe rumo Tũpa remimbotar rupi. Esepia, yɨpɨve ité Tũpa oicua pe peipɨsɨra yuca uca ãgua curusu rese ava naporai vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tũpa rumo ombogüerayevɨ manosa sui. Esepia, manosa ndoicatui sereco ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Supi eté mborerecuar guasu David oñehe Jesús recocuer rese aracahe aipo ehi: ‘Che aicua che Yar che rese secoi che acato cotɨ mbahe tẽi pɨpe che vɨapiẽhɨ ãgua yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sese avɨhaño ité vichico, asapucai avei che rorɨvetesa pɨpe. Iyavei che yeroya tuprɨsave asãrora mbahe avɨye vahe che recove iri ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Esepia, nde ndereseyai chira che hã omano vahe pãhuve, nderemonduyu ucai chiaveira nde rembiguai seco maranehɨ vahe retecuer. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Co tecovesa ereicua uca cheu. Che mbovɨhara eve nde rese che recose’ ehi David aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Che mu eta, supi eté yande ramoi David omano, ñotɨsa ita hoprɨ pɨpe aracahe. Ahe suvɨpa ouve vɨte cohave yande pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David rumo Tũpa ñehe mombehusar, oicua Tũpa oyeupe aipo ehi vahe: ‘Supi eté aipo ahe ndeu: nde suindar oimera mborerecuar guasu nde recuñara’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ahe ndoyavɨi osepia vahe ité Poropɨ̃sɨrosar cuerayevɨsa. Evocoiyase aipo ehi oñehe sese: ‘Ihã ndopɨtai chira omano vahe pãhuve iyavei setecuer ndituyui chira’ ehi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Evocoi Jesús, Tũpa remimbogüerayevɨ secoi. Ahe imombehusar opacatu ore oroico. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ipare Tũpa vɨraso oacato cotɨ imboguapɨ. Ahe oipɨsɨ imombehuprɨ Espíritu Santo Vu sui. Evocoiyase ahe opa omondo co ava yuvɨrecoi vahe upe. Ahe pesepia, pesendu avei cũritei peico. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Esepia, evocoi oso vahe ɨvave ndahei David. Ahe ae rumo aipo ehi aracahe: ‘Yar aipo ehi che Yar upe: Eguapɨ cohave che acato cotɨ che pɨri. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Asecopɨpa uca ranera nde amotarẽhɨmbar ndeu, ehi Yar che Yar upe’ ehi David aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Pe tapecuasapa, ticuasapa avei opacatu Israel recua rupi, supi eté evocoi Jesús curusu rese peyatɨca vahecuer, ahe Tũpa omoingo opacatu yande Yarã iyavei yande pɨ̃sɨro ãgua” ehi Pedro ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Aipo renduse, tasɨ́ iteanga ipɨha pɨpe yuvɨreco. Evocoiyase oporandu chupe, ambuae imboetasa upe avei yuvɨreco: —Ore mu, ¿mbahe vo oroyapora evocoiyase? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Evocoiyase aipo ehi ahe ava upe: —Pemboasɨ pe angaipa; peyevɨ Tũpa upe. Iyavei peñeapiramo opacatu Jesucristo rer pɨpe. Evocoiyase Tũpa iñerora pe angaipa rese. Iyavei omondora Espíritu Santo pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Esepia, co ñehesa imombehuprɨ, ahe pẽu nara, pe suindar upe nara iyavei opacatu amombrɨ Tũpa sui yuvɨrecoi vahe upe nara avei, ahe acoi opacatu yande Yar Tũpa oyeupe nara güeru pota vahe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ẽgüe ehi oñehe vɨte ava mboaracua aipo ehi: —¡Peyepepɨ co ava secocuer co cotɨ tẽi vahe sui! —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Acoi ava vɨroya vahe co ñehesa, oñeapiramo uca yuvɨreco. Ahe arɨ pɨpe oyemboeta iri tres mil ava yuvɨreco Jesús vɨroya vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Opacatu vɨroya tuprɨ ité apóstol porombohesa. Opacatu guasu avei oyeaɨsu tuprɨ yuvɨreco, oyeroquɨ iyavei oñemonuha oyeupe pan mboyaho-yaho ãgua yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Opacatu oyembosɨquɨye imboeteisa pɨpe yuvɨreco. Esepia, apóstol oyapo setá poromondɨisa ‘toicua Tũpa suindar yande porombohesa yuvɨreco’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Opacatu Jesús reroyasar ipɨhañemoñeta tuprɨ ité ombahe rese yuvɨreco güecocuer upe nara. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Omondo ambuae ava upe oɨvɨ iyavei ombahe eta yuvɨreco. Seprɨ omondo oyeupe mbahe panesa rupi-rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Arɨ yacatu rupi judío tũparove oñemonuha yuvɨreco. Iyavei oɨ yacatu rupi avei oñemonuha oyoya guasu pan mboyaho ãgua. Ipare oyoya guasu ocaru yuvɨreco oyembovɨhasa pɨpe, opɨhañemoñeta tuprɨsa pɨpe avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Osapucai yuvɨreco Tũpa upe yepi iyavei opacatu ava osaɨsu Jesús reroyasar yuvɨreco. Yande Yar evocoiyase arɨ rupi omboeta catu ava iñepɨsɨro ãgua Jesucristo vɨroya vahe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ñepei arɨ aipo, caharuse las tres pɨpe, Pedro, Juan reseve oyoya yuvɨraso judío tũparove. Ahe hora pɨpe judío oyeroquɨ yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ahe tũparo roquendɨpɨ rer Porañete. Aheve arɨ yacatu rupi vɨraso ñepei ava oyesu suive ndoguatai vahe ‘tomondo guarepochi ava tũparove yuvɨroique vahe yuvɨreco chupe’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ahe ndoguatai vahe omahe Pedro, Juan rese tũparove seique potase, oporandu guarepochi rese chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro, Juan avei rumo omahengatu yuvɨreco sese. Pedro aipo ehi chupe: —Emahe ore rese —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Evocoiyase ahe mbɨa omahengatu sese ‘omboura revo que mbahe cheu’ oya viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Aipo ehi rumo ndoguatai vahe upe: —Che ndarecoi guarepochi, oro avei. Co areco vahe rumo amondora ndeu: Jesucristo, Nazaret pendar, rer pɨpe epũha, eguata —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Evocoiyase oipɨsɨ ipo yasu cotɨndar imopuha. Ahe ramoseve opa tuprɨ ipɨ, ipɨñuha avei ovɨ̃racua. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Evocoiyase opũha, opo, oguata; oique oso tũparove supi. Opo-opo vorɨvetesave iyavei osapucai Tũpa upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Opacatu ava osepia yuvɨreco iguatase iyavei Tũpa upe isapucaise. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Omahecuase sese, “¡Too!” ehi tẽi yuvɨreco. Iyavei ndoyembovɨhai avɨyeteramo tẽi icuerase yuvɨreco. Esepia, evocoi ava oicuapa tũparo roquendɨpɨ Porañete serer vahesave chinise mbahe rese iporanduse yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ndoguatai vahecuer ndoyepepɨ potai Pedro, Juan sui. Yuvɨnoña atɨ, oyepɨhamondɨi ava sepia tũparo Corero Salomón serer vaheve yuvɨrecoise. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pedro evocoiyase aipo ehi ava upe: “Che mu, ¿mahera vo peyemondɨi? ¿Mahera vo ore repia atɨ peye? Ndoyavɨi co ore pĩratasa pɨpe tẽi iyavei Tũpa rese ore pɨhañemoñeta tuprɨsa pɨpe tẽi orombogüera vahe co mbɨa pẽu viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tũpa, ahe acoi Abraham, Isaac iyavei Jacob vɨroya yuvɨreco aracahe iyavei opacatu yande ramoi eta avei no, ahe niha omondo güeco pĩratasa tuvicha catu vahe Guahɨr Jesús upe. Pe rumo acoi pemondoño mborerecuar Pilato povrɨve. Acoi omose potase, pe evocoiyase ndapeipotaiño imose ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ahe seco maranehɨ vahe, seco ɨ̃vi vahe renose rãgüer pɨpe, peporandu: ‘Tosẽ oporapichi vahe’ peye. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ẽgüe peye acoi tecovesa ombou vahe yuca. Tũpa rumo ombogüerayevɨ omano vahe pãhu sui. Ahe niha ore oromombehu oroico pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Co Jesús rer rese yeroya pɨpe ité niha oipɨsɨ pĩratasa co mbɨa ndoguatai vahecuer opacatu pe pesepia vahe iyavei peicua vahe. Jesús rese yeroyasa pɨpe ité niha co pe rembiepiave ocuera tuprɨ” ehi ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Che mu eta, che aicua acoi pe peipɨ̃tɨvɨi vahe pe rerecuar Jesús yuca uca ãgua pe icua tuprɨẽhɨ pɨpe cuese. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ẽgüe ehi Tũpa imboavɨye aracahendar opacatu oñehe mombehusar upe güemimombehugüer: ‘Che Rembiporavo Poropɨ̃sɨrosar oiporarara mbahe-mbahe tẽi rasɨcuer omano’ ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Sese pemboasɨ pe angaipa; peyevɨ Tũpa upe. Ipɨpe sui tomocañɨ pe angaipa pe sui. Avɨyeteramo co sui omboura yande Yar pe reco morohɨsa ãgua, ");
INSERT INTO gyrNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ombou aveira Jesús, ahe yɨpɨsuive iporavoprɨ pe pɨ̃sɨro ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Cũritei rumo Jesucristo ɨvave vɨte secoi acoi Tũpa opase voi omoingatu opacatu mbahe iyevɨ ãgua. Aipo ehi acoi imoñehe uca aracahendar oñehe mombehusar ndaseco marai vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés yande ramoi yuvɨrecoi vahe upe aipo ehi imombehu aracahe: ‘Yande Yar Tũpa omopuhara ñepei oñehe mombehusar pe pãhuve che nungar. Ahe iñehe pesendura, pemboyeroya catu aveira. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Opacatu ndovɨroyai vahe iñehe Tũpa omocañɨra güembiporavo pãhu sui’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ẽgüe ehi opacatu Tũpa ñehe mombehusar Samuel suive aracahe omombehu avei co arɨ cũritei yasepia vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pẽu nara niha Tũpa ñehe mombehusar remimombehugüer aracahendar. Pẽu nara avei acoi Tũpa omombehu vahe güemimbotar yande ramoi eta upe. Esepia, aipo ehi Abraham upe aracahe: ‘Opacatu ava co ɨvɨ pɨpendar ahe sovasaprɨ yuvɨrecoira nde suindar sui’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Acoi Tũpa Guahɨr ombogüerayevɨse, pẽu rane ombou pe rovasa ãgua ‘toseyapa ñepei-pei güecocuerai yuvɨreco’ oya” ehi Pedro ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Pedro, Juan reseve oñehe vɨteseve ava rehɨi upe, ahese oñemoɨrosa pɨpe pahi eta, tũparo rãrosar sundao rerecuar, saduceo avei oyugüeru yuvɨreco chupe. Esepia, Pedro iyavei Juan ombohe ava yuvɨreco aipo ehi: “Jesús ocuerayevɨ; sese oime cuerayevɨsa omano vahe pãhu sui” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ichui oipɨsɨ seraso soquenda yuvɨreco ‘ayihive voi yanosera mbahe rese porandu ãgua’ ohesa pɨpe. Esepia, caharuse tẽi osoquenda yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Setá rumo ava iñehesa osendu vahe vɨroya yuvɨreco. Ahe cuimbahe seroyasar retacuer güeraño seni cinco mil. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ahere ayihive mborerecuareta oñemonuha yuvɨreco Jerusalén ve: judío rerecuar, pahi eta rerecuar, Moisés porocuaita rese oporombohe vahe, ");
INSERT INTO gyrNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","pahi rerecuar ɨvate catu vahe Anás, Caifás, Juan, Alejandro, opacatu omu reseve. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Evocoiyase güeru ucase Pedro iyavei Juan opãhuve yuvɨreco, oporandu yuvɨreco chupe: —¿Ava pe cuaita pɨpe vo, ava rer pɨpe avei vo co mbahe peyapo? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Evocoiyase Pedro, Espíritu Santo pĩratasa pɨpe, aipo ehi chupe: —Pe, mborerecuareta co tecua pɨpendar, pe avei pahi rerecuar: ");
INSERT INTO gyrNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","peporandu niha co ava imbaheasɨ vahe ndoguata catui vahe mbogüera agüer rese oreu —ehi chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Evocoiyase tapeicuapa opacatu pe Israel suindar peico vahe ocuera co ava ndoguata catui vahecuer Jesucristo, Nazaret pendar, rer pɨpe. Ahe niha peyatɨca uca vahecuer curusu rese. Tũpa rumo ombogüerayevɨ iri omano vahe pãhu sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Co Jesús pe remieroɨ̃ro, ahe rumo yande vɨ̃racuasa. Pe evocoiyase inungar oɨ mopuhasar omomboño vahe ita avɨye catu vahe oɨ movɨracuasa rãgüer yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ndipoi que ambuae ava sui poropɨ̃sɨrosa, Jesús güeraño ité oicatu oporopɨ̃sɨro. Esepia, Tũpa nomboui ambuae ava tẽi co ɨvɨ pɨpe yande pɨ̃sɨro ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Mborerecuar osepiase iyembosɨquɨyeẽhɨsa yuvɨreco, “¿Mara ehi pĩha co mbɨa? ¡Ava tẽi, ndoyembohei vahe niha!” ehi tẽi yuvɨreco chupe. Ichui oicua Jesús remimbohegüer secose yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Iyavei acoi ava semimbogüeragüer supive ité secoise, sese ndoicatui chupe oñehe mara ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ipare, “Pesẽ ocarve” ehi mborerecuareta yuvɨreco chupe. Ahe güeraño evocoiyase opɨta oɨ pɨpe oñemoñeta yuvɨreco sese ");
INSERT INTO gyrNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","aipo ehi: —¿Mara yahera vo co ava rereco? Esepia, opacatu ava Jerusalén pendar oicua co mbahe poromondɨisa oyapose yuvɨreco. Ndiyai eté, “Ẽgüe ndehi” yahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Yambosɨquɨye ava upe Jesús rer rese iñehe iriẽhɨ ãgua yuvɨreco. Ipɨpe sui ava tosendu iri eme Jesús resendar ñehesa yuvɨreco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Aipo ohe pare, “Perio” ehi yuvɨreco chupe. “Pesendu, co pɨpe suive peñehe iri eme tuprɨ iyavei pembohe iri eme avei ava Jesús rer pɨpe” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Omboyevɨño rumo oñehe yuvɨreco chupe: —¿Mara ehi pe pɨhave? ¿Uma pĩha avɨye catu Tũpa rovai? ¡Pe porocuaita tie orovɨroya catura Tũpa ore cuaisa sui! ");
INSERT INTO gyrNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ndiyai rumo mbahe ore rembiepia, mbahe orosendu vahe avei mombehuẽhɨ ãgua oreu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Aipo ihese, mborerecuar ombosɨquɨye catu tẽi yuvɨreco. Ichui rumo omose tuprɨño. Esepia, ava omboetei guasu Tũpa yuvɨreco co imbaheasɨ vahe mbogüera repiase. Sese ndoicatui eté mbahe apo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Evocoi ava oipɨsɨ vahe Tũpa poromondɨisa ocuera ãgua, ahe otɨ̃aro catu cuarenta aravɨter vɨreco vahe sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Yuvɨnosese Pedro, Juan avei, oyevɨ yuvɨraso omboetasa pɨri. Aheve oñemonuhasave opa omombehu pahi rerecuar oyeupe ñehe mara-mara tẽisa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aipo rendu pare, oyoya guasu oyeroquɨ yuvɨreco Tũpa upe aipo ehi: “Ore Yar, nde niha Tũpa opacatu ɨva, ɨvɨ, para guasu, opacatu ipor reseve aposar ereico. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Nde Espíritu Santo pɨpe aipo eremombehu uca nde rembiguai mborerecuar David upe aracahe: ‘¿Mahera vo co ava ndahei vahe judío oyamotarẽhɨ yuvɨreco? ¿Mahera vo ipɨhañemoñeta rai tẽi yuvɨreco? ");
INSERT INTO gyrNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mborerecuar guasu eta, ambuae mborerecuar reseve co ɨvɨ pɨpendar oñemonuha yuvɨreco yande Yar Tũpa iyavei sembiporavo amotarẽhɨ ãgua’ ehi aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Ẽgüe ehi eté oñemonuhase Herodes, Poncio Pilato avei, ava ndahei vahe judío, judío eta reseve yuvɨreco co tecua Jerusalén ve. Esepia, oñemonuha yuvɨreco nde rembiguai aracaheve nde Rembiporavo Poropɨ̃sɨrosar Jesús, seco maranehɨ vahe, amotarẽhɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ẽgüe ehi yapo opacatu nde pɨhañemoñeta aracahendar rupi tuprɨ ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iyavei cũritei, ore Yar, emahe ore amotarẽhɨsar rese. Embou nde pĩratasa nde rembiguai oroico vahe upe sɨquɨyeẽhɨsa pɨpe nde ñehengagüer mombehu vɨte ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ipare, nde pĩratasa pɨpe, embogüera imbaheasɨ vahe iyavei eyapo mbahe poromondɨisa yavai vahe nde rembiguai Jesús rer maranehɨ pɨpe” ehi yuvɨreco oyeroquɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Iyeroquɨ pare, Tũpa omborɨrɨi opacatu mbahe iñemonuhasave yuvɨreco chupe. Ahese Espíritu Santo opa oique yuvɨreco sese. Sese osɨquɨyeẽhɨsa pɨpe omombehu tuprɨ Tũpa Ñehengagüer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Setá iteanga Jesús reroyasar yuvɨreco. Opacatu oyoya tuprɨ ipɨhañemoñeta yuvɨreco. Ndipoi eté “co güeraño co che mbahe” ehi vahe; opacatu seroyasar mbahe rumo opacatu mbahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesucristo apóstol omombehu vɨte ipĩratasa pɨpe icuerayevɨ agüer yuvɨreco. Ipɨpe Tũpa osovasa catu vɨte opacatu yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ndipoi eté ipãhu pendar mbahe ndovɨrecoi vahe. Esepia, opacatu ɨvɨ vɨreco vahe iyavei oɨ omondo, ");
INSERT INTO gyrNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ahe seprɨ omondo apóstol upe yuvɨreco yepi. Ahe evocoiyase omboyaho-yaho opacatu upe mbahe ipane vahe rupi-rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ẽgüe ehi ava judío ramoi Leví suindar, Chipre pendar, José serer vahe, apóstol osero, “Bernabé” ehi yuvɨreco chupe (‘porombovɨhasar’ oya aipo ehi), ");
INSERT INTO gyrNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ahe mbɨa omondo oɨvɨ, güeru seprɨ apóstol upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ambuae ava rumo, Ananías serer vahe, güembireco Safira reseve omondo ɨvɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ahe mbɨa rumo omboyaho seprɨ, ñepei iyahocuer vɨreco oyeupe nara, ambuae iyahocuer vɨraso apóstol upe, sembireco avei oicua tẽi opacatu. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Evocoiyase Pedro aipo ehi chupe: —Ananías, ¡mahera ereroya Caruguar nde pɨha pɨpe Espíritu Santo mbopa ãgua, eremboyahoño tẽi nde ɨvɨ reprɨ guarepochi ndeyeupe nara! ");
INSERT INTO gyrNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ndahei vo nde mbahe ité ɨvɨ viña? Eremondo ité niha, evocoiyase nde mbahe ité guarepochi. ¡Mahera ereyapo co nungar! Ndahei ava upe nde remira, Tũpa upe ité rumo nde remira —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Osenduse Pedro ñehesa, ovɨapi sehõgüer oso sovai. Ahese opacatu oyandu vahe osɨquɨye tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ipare mbɨa chĩhivahe yugüeru, osupi sehõgüer, oipoque seraso yuvɨreco ñotɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Mbosapɨ hora pare, sembireco Safira serer vahe oique oɨ pɨpe. Ndoicua vɨtei rumo omer mano. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ahese Pedro oporandu chupe: —Emombehu cheu: ¿Co guarepochi retacuer rupi eté vo pemondo pe ɨvɨ? —ehi chupe. —Evocoi rupive ité niha oromondo —ehiño avei cuña chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Evocoiyase aipo ehi ahe cuña upe: —¡Mahera peyemboyoya pe pɨhañemoñetasa rese pe secoãha ãgua yande Yar Espíritu! Coi yugüeru nde mer tɨ̃sarer. Nde avei nde reraso ãgua yuvɨreco eipeve —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ahe ramoseve avei ovɨapi sehõgüer Pedro rovai. Mbɨa chĩhivahe yuvɨroiquese, oipoque voiño ité sehõgüer seraso imer ɨvɨi ñotɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Opacatu Jesús reroyasar, ambuae ava avei oyembosɨquɨye guasu yuvɨreco yanduse. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Evocoiyase apóstol pɨpe Tũpa omboyecua uca setá poromondɨisa ava pãhuve yuvɨreco. Opacatu Jesús reroyasar oñemonuha judío tũparo ɨque, Salomón serer vahesave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Opacatu ambuae ndoyemboyai yuvɨreco sese osɨquɨyepave. Ava rehɨi rumo, omboetei eteanga apóstol yuvɨrecoi vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Oyemboeta catu yande Yar reroyasar setá cuimbahe, setá avei cuña. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Iyavei ava rehɨi vɨnose yuvɨreco imbaheasɨ vahe supa reseve-seve Pedro renonera, “Oñocuase Pedro, avɨyeteramo omohara ihãgüer. Ahese revo ombogüerara” ehi yuvɨreco oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ava Jerusalén ɨvɨrindar avei güeru omonuha setá imbaheasɨ vahe, caruguar rese yuvɨrecoi vahe apóstol upe imbogüerapɨrã. Ahe evocoiyase opacatu ombogüera yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ichui tẽi pahi rerecuar ɨvate catu vahe, saduceo yuvɨrecoi vahe oñemoɨro yuvɨreco apóstol upe ava rese güecatẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sese oipɨsɨ osoquendapa uca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ipare rumo, pɨ̃tu pɨpe, Tũpa rembiguai ɨva pendar ou omboi oquenda, vɨnose ichui, aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Peso tũparo guasuve, pemombehu avei ava upe co ñehesa tecocuer pɨasu resendar” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Co mbahe rendu pare, supi tuprɨ ité oyapo yuvɨreco. Cõhe ramoseve yuvɨraso judío tũparo guasuve ava mbohe ãgua. Aheseve pahi rerecuar ɨvate catu vahe, supindar avei osenoi opacatu tecua pɨpendar mborerecuar ñemonuha ãgua ɨvate catu vahesave; omondo yuvɨreco güembiguai apóstol reru ãgua soquendasa sui aheve nara viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Oyepotase rumo sembiguai yuvɨreco, oseca tẽi soquendaprɨ. Ichui oyevɨ tẽi yuvɨreco imombehu ");
INSERT INTO gyrNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","aipo ehi: —Oroyepotase ava roquendasave, orosepia opacatu oquenda imboyaprɨ tuprɨ iyavei orosepia opacatu oquendɨpɨ rupi sãrosar osãro tuprɨ ité viña. Oromboise rumo oquenda, ndipoi eté ava soquendaprɨ ipɨpe —ehi tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Osenduse, pahi rerecuar ɨvate catu vahe, tũparo rãrosar rerecuar, pahi rerecuareta avei yuvɨreco, ipɨhañemoñeta tẽi: “¿Que rupi vo opoira co mbahe sui yuvɨreco?” ehi tẽi yuvɨreco oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Aheseve ñepei mbɨa oyepota imombehu: —Evocoi pesoquenda vahecuer, ahe mbɨa cũritei oporombohe tũparove yuvɨreco —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Evocoiyase tũparo rãrosar rerecuar, sembiguai avei yuvɨraso seru ãgua mbahe tuprɨ pɨpe, “Avɨyeteramo yande api-api tiẽtera ava yuvɨreco yaru raise” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Vɨroyepotase yuvɨreco ñemonuhasa ɨvate catu vahesave, ahese evocoi pahi rerecuar ɨvate catu vahe aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Ore mborerecuar tecua pɨpendar, ndoroipotai peporombohe evocoi mbɨa recocuer rese. Pe rumo pembohe opacatu Jerusalén pendar secocuer rese serer pɨpe. Pemombehu avei ava rehɨi upe ore mborerecuar oroyuca uca evocoi mbɨa —ehi pahi rerecuar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro, omboetasa reseve, omboyevɨ pahi rerecuar ɨvate catu vahe upe yuvɨreco: —Ore cuaita ité Tũpa mboyeroya, ndahei chira rumo ava tẽi rane oromboyeroyara —ehi yuvɨreco chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yepe peyatɨca, peyuca uca Jesús curusu rese viña, yande Ru Tũpa rumo acoi yande ramoi eta vɨroya vahe, ahe ité ombogüerayevɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ipare osecomboɨvate ɨvave oacato cotɨ imboguapɨ imoi. Ahe niha Mborerecuar guasu, Poropɨ̃sɨrosar avei ‘tomboasɨ oangaipa, toyevɨ cheu, toipɨsɨ angaipa resendar ñeroisa yuvɨreco’ oya Tũpa Israel suindar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ore Tũpa rembiapo repiasarer imombehu ãgua oroico, Espíritu Santo avei oñehe ore ñehe rupi ava upe, ahe acoi Tũpa ombou vahe vɨroyasar upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Osenduse mborerecuar aipo ñehesa, oñemoɨró iteanga yuvɨreco. Oyucapa pota opacatu apóstol yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mborerecuar pãhu pendar rumo oime mbɨa fariseo, Gamaliel serer vahe, ahe Moisés porocuaita rese oporombohe vahe iyavei imboeteiprɨ catu vahe. Ahe opũha oporocuai, “Toyuvɨnose raimi ocarve apóstol” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ipare aipo ehi ambuae mborerecuareta upe: —Che mu, judío, peicua catu, yandepɨhañemoñeta tuprɨ rane mbahe apo ãgua renondeve co mbɨa upe yuvɨreco —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Peyemomahenduha Teudas recocuer rese. Esepia niha, acoi oyemboɨvate aisa pɨpe vɨroguata cuatrociento ava oyeupi aracaco. Ipare acoi oyuca yuvɨreco. Ahese supindar opa oñemosai tẽi yuvɨreco. Ahe peve secocuer opa. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Coiye catu, omombehuse mborerecuar Roma pendar ava retacuer cua ãgua, ahese Judas, Galilea pendar, oyemomborerecua. Setá avei ava oguata yuvɨreco supi. Ahe avei rumo oyuca yuvɨreco, opa tuprɨño avei supindar oñemosai tẽi yuvɨreco —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Sese cũritei peyapoi rene mbahe co ava upe. Yaseyaño. Esepia, evocoi mbahe sembiapo ndipocopɨi chira oyapose opĩratasa pɨpe tẽi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tũpa suindarse rumo ndapemombɨtuhu catui chietera. Peicua catu, aní chira yayamotarẽhɨ Tũpa ipɨpe —ehi omboetasa upe. Aipo ihese, opacatu imboetasa vɨroya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ichui rumo güeru iri apóstol inupa uca ãgua iñehe iriẽhɨ ãgua Jesucristo rese yuvɨreco. Inupa pare opa omose yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ipɨpe apóstol ovɨhareté iteanga yuvɨreco. Esepia, Tũpa ombou chupe iparaɨsu ãgua yuvɨreco Jesús rer rese iyeroyasa sui tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ipare ndopoi eté arɨ yacatu Poropɨ̃sɨrosar Jesús recocuer mombehusa sui yuvɨreco. Omombehuño ité tũparo pɨpe iyavei opacatu ava rẽta rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ahe aravɨter pɨpe aipo oyemboetase Jesús reroyasar yuvɨreco, griego pɨpe oñehe vahe oñehe rai oyeupe hebreo pɨpe oñehe vahe rese yuvɨreco: “Nihañeco tuprɨi ore mu imer mano vahecuer rese arɨ yacatu mbahe poropɨ̃tɨvɨisa imondosase chupe” ehi oñehe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Evocoiyase doce apóstol omonuhapa uca opacatu Jesús reroyasar. Aheve aipo ehi yuvɨreco chupe: —Ndiyai rumo ore oropoi tẽi Tũpa Ñehengagüer mombehusa sui mbahe poropɨ̃tɨvɨisa mondo ãgua rese tẽi —ehi yuvɨreco—. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sese ore rɨvɨreta, peiporavo siete mbɨa seco avɨye vahe pe pãhu sui, yaracua vahe iyavei Espíritu Santo vɨroya vahe ité opɨha pɨpe. Ahe mbɨa tihañeco co mboravɨquɨsa rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ore evocoiyase, oroyerureñora iyavei oroporomboheño itera Tũpa Ñehengagüer rese —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Opacatu oipotaño yuvɨreco ñehesa oyeupendar. Ichui osenoi Esteban yuvɨreco, ahe oyeroya ité Tũpa rese iyavei vɨroya ité Espíritu Santo opɨha pɨpe. Ichui oiporavo Felipe, Prócoro, Nicanor, Timón, Parmenas iyavei Nicolás evocoi mbɨa Antioquía pendar, ahe vɨroya vahecuer judío aracuasa. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ichui vɨrasopa apóstol upe yuvɨreco. Ahe omondo opo iharɨve oyeroquɨ yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ahese Tũpa Ñehengagüer oyemosai catu tecua pɨpe. Ichui oyemboeta catu iri avei Jesús reroyasar yuvɨreco Jerusalén ve. Setá avei judío pahi vɨroya iñehengagüer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Co mbɨa, Esteban, vɨreco ité Tũpa pĩratasa iyavei Tũpa porovasasa oyese. Oyapo avei mbahe poromondɨisa, yavai vahe opacatu ava pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Evocoiyase Jerusalén ve oime judío tũparo Mbiguaigüer serer vahe. Ahe pendar tecua Cirene ɨguar, Alejandría ɨguar, Cilicia ɨguar iyavei Asia ɨvɨrindar yuvɨrecoi vahe reseve oiñehepoepɨ-epɨ Esteban yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ndoicatui rumo iñehe recopɨ ãgua yuvɨreco. Esepia, ahe oñehe mbahecuasa Espíritu Santo omondo vahe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Evocoiyase yamotarẽhɨmbar omboepɨ ambuae ava upe semira tẽi ãgua sese yuvɨreco. “ ‘Ore orosendu co mbɨa oñehese mbahe naporai vahe rese Moisés amotarẽhɨsave, Tũpa amotarẽhɨsave avei’ aipo peyera peñehe” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Evocoiyase ahe ava oyamotarẽhɨ uca opacatu ava mborerecuar reseve iyavei judío porocuaita rese oporombohe vahe upe avei yuvɨreco. Ichui oipɨsɨ yesapɨha Esteban seraso mborerecuar uve porandusa ɨvate catu vahesave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Iyavei oseca mbɨa semira tẽi vahe oñehe vaherã sese yuvɨreco. Ahe aipo ehi: —Co mbɨa oñehe-ñehe tẽi yande tũparo guasu imaranehɨ vahe amotarẽhɨsave, Moisés porocuaita amotarẽhɨsave avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ore orosendu iñehe: “Jesús Nazaret pendar omocañɨra tũparo guasu iyavei Moisés yande mbohesa avei aipo osecuñarora” ehi —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ahese opacatu mborerecuar oñemonuha vahe yuvɨnoi aheve omahe Esteban rese yuvɨreco. Omahese aipo yuvɨreco sese, ndoyavɨi sepiaca Tũpa rembiguai ɨva pendar rova. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Evocoiyase pahi rerecuar ɨvate catu vahe oporandu chupe: “¿Supi eté vo aipo nde ñehe mara eico?” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ahese omboyevɨ chupe: “Che mu eta, peyapɨsaca che ñehe rese: Tũpa imboeteiprɨ oyemboyecua yande ramoi Abraham upe aracahe. Mesopotamia ve secoi vɨtese, icho renondeve Harán ve seco ãgua, ");
INSERT INTO gyrNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","aipo ehi chupe: ‘Eso nde recua sui; eseyapa nde mu; eso evocoi tecuave che amboyecuara ndeu’ ehi Tũpa chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Evocoiyase osẽ Caldea ɨvɨ sui oso tecua Harán ve güeco ãgua. Omano pare tu Harán ve, Tũpa ombou cohave yande recosave. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Yepe oyepota tẽi cohave aracahe, Tũpa rumo nomondoimi eté que chĩhi ɨvɨ chupendar chupe. ‘Co ɨvɨ amondora ndeu nde mano pare nde suindar upe nara’ ehi Tũpa chupe (ahe rumo ndatahɨ vɨtei ahese). ");
INSERT INTO gyrNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tũpa aipo ehi avei chupe: ‘Nde suindar yuvɨrecoira ambuae ava recua rupi, ahe pendar ava secua vahe rembiguairã semimombaraɨsuguã tẽi avei yuvɨrecoira cuatrociento aravɨter rupi’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Tũpa rumo aipo ehi avei Abraham upe: ‘Che rumo, aicuara evocoi ava nde suindar mombaraɨsusar upe yuvɨreco. Ipare yuvɨnosera ipovrɨ sui che mboetei iri ãgua cohave yuvɨreco’ ehi Tũpa chupe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tũpa oyocuai güemimbotar pɨpe Abraham guahɨr mbocircuncida ãgua rese. Sese Abraham ombocircuncida guahɨr Isaac iha pare ocho arɨ pɨpe. Isaac ẽgüe ehi avei guahɨr Jacob upe. Jacob ẽgüe ehi avei guahɨreta upe, ahe doce vahe Israel suindar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ipare yuvɨrecoi vahe yande ramoi Jacob rahɨr omondo vɨvrɨ guarepochi repɨrã yamotarẽhɨsa pɨpe yuvɨreco. Ahe tɨvrɨ rer José omondo vahe Egipto pendar upe yuvɨreco. Tũpa rumo secoiño ité sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ichui vɨnose opacatu iparaɨsusa sui. Omondo ombahecuasa chupe iyavei seco avɨye tuprɨ ãgua Egipto pendar mborerecuar guasu faraón upe. Evocoiyase faraón ipotasa pɨpe omoingue mborerecuar seco ãgua opacatu ava ɨvɨ Egipto pendar cuai ãgua iyavei güẽta pɨpendar cuai ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Ipare ou tɨavor opacatu Egipto ɨvɨ rupi, Canaán ɨvɨ rupi avei. Iparaɨsu yuvɨreco. Ahese yande ramoi ndoyosui mbahe güemihura yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Oyanduse rumo Jacob Egipto ve oime vɨtese trigo, ahese omondo guahɨr aheve seca, ahe yande ramoi yuvɨrecoi vahe. Ahe yɨpɨndar ichosa Egipto ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ichui yuvɨraso yupagüe irise Egipto ve, ahese José oyecua uca vɨquehɨr upe. Ẽgüe ehi faraón upe oicua uca uma sui oyesu. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Evocoiyase José güeru uca oyesupa Jacob iyavei opacatu omu, ahe imu retacuer setenta y cinco tuprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ẽgüe ehi Jacob yuvɨraso Egipto ve yuvɨrecoi ãgua opacatu guahɨr reseve. Aheve omano iyavei opacatu yande ramoi eta omano yuvɨreco aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Imano pare rumo, suminogüer vɨraso icangüer yuvɨreco tecua Siquem ve. Aheve oñotɨ yuvɨreco. Aheve acoi Abraham vɨrocua tuvɨpa Hamor rahɨr sui aracahe” ehi mborerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ipare, vɨrovɨse arɨ ipapaprɨ Tũpa Ñehengagüer Abraham upendar, ahese yande ramoi setá catu-catu iri oyesu Egipto ve yuvɨreco aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ipare oporocuai ambuae mborerecuar guasu Egipto ve. Ahe ndoicuai vahe ité yande ramoi José. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Evocoi mborerecuar guasu ombopa yande ramoi eta aracahe. Omombaraɨsu avei oyucapa uca israelita rahɨr cuimbahe pĩtani. Ahe oyocuai iyesupa aipo ehi: ‘Peseya pe rahɨr oha ramomi vahe, tomanoño’ ehi yande ramoi upe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aheseve avei aipo Moisés oha. Ahe pĩtani avɨye ité Tũpa uve. Ihare, iyesupa mbosapɨ yasɨmi rupive vɨreco oyese güẽtave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Oseyase rumo iyesupa ɨve yuvɨreco, ahese faraón rayrɨ oseca ahe ɨ rupi sui. Ichui vɨnose seraso güẽtave, omboacua omembrɨ nungar ité sereco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ichui Egipto pendar yaracua vahe opacatu ombahecuasa rese ombohe tuprɨ Moisés sereco yuvɨreco. Evocoiyase Moisés ipĩrata ité oñehese iyavei oyapose mbahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Vɨrecose rumo Moisés cuarenta aravɨter, ipɨhañemoñeta: ‘Tasepia rane che mu israelita cohave yuvɨrecoi vahe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ipare aheve osepia Egipto pendar oinupa-nupa imu sereco yuvɨreco. Ahese oyuca Egipto pendar omu repɨcave. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ahe rumo, ‘Oicua revo che mu Tũpa vɨnose uca ãgua Egipto sui yuvɨreco cheu’ ehi viña. Imu rumo nomohai eté Moisés vɨnose ãgua yuvɨreco evocoi ava po sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ahere ayihive oso omu pãhuve. Aheve osepia ñuvɨrío mbɨa ovavase oyeupe yuvɨreco. Ahe rumo oipota tẽi iñero ãgua oyeupe yuvɨreco viña, aipo ehi chupe: ‘Che mu, oñemu mo peico, ¿mahera vo pevava peyese ae?’ ehi tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Oyemovɨracua catu vahe rumo omombo oyesui. Ichui ahe aipo ehi chupe: ‘¿Ava vo nde moingue ore pãhuve ore rerecuarã ore recocuer moingatu ãgua?’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘¡Che yuca pota avei tie eve inungar ereyuca evocoi Egipto pendar irapɨpe!’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Osenduse rumo co iñehe, oñemi voi eté oso Egipto sui ambuae ɨvɨ Madián ve. Aheve opɨta pucu. Ahe ɨvɨ rumo ndahei secua ité. Aheve oyesu ñuvɨrío tahɨr. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Omboavɨyese cuarenta aravɨter Madián ve, Tũpa rembiguai oyemboyecua ɨvɨtrɨ Sinaí rerovɨcave ɨvɨ iporupɨrẽhɨsave caha rese tata rendɨgüer pãhuve chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Osepiase mbahe sendɨ vahe oyepɨhamondɨi, oyemboya catu sese sepia tuprɨ ãgua viña. Ahese osendu Yar ñehe aipo ehi vahe: ");
INSERT INTO gyrNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Che nde ramoi Tũpa aico. Nde ramoi Abraham, Isaac iyavei Jacob che reroya vahecuer yuvɨreco’ ehi. Evocoiyase Moisés orɨrɨi osɨquɨyesa pɨpe nomahe pota iri sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Evocoiyase Yar aipo ehi chupe: ‘Esequɨi nde pɨtaqui. Esepia, ɨvɨ nimarai vahesave ereico’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","‘Che asepia tuprɨ ité Egipto ve nde mu che rembiporavo paraɨsuse; asendu avei ipoãse tẽisa yuvɨreco yepi. Sese agüeyɨ ndeu nde oromondora aheve senosepa ãgua’ ehi Tũpa Moisés upe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Yepe yande ramoi ndovɨroya potaiño ité yuvɨreco, ‘¿Ava vo nde moingue ore rerecuarã ore recocuer moingatu ãgua?’ ehiño yuvɨreco chupe, Tũpa ité rumo oyocuai güembiguai imbogüeyɨ tata rendɨgüer pãhuve imoñehe Moisés upe iporocuai ãgua, ava renosepa ãgua avei ɨvɨ Egipto pendar mborerecuar povrɨ sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ipare ahe ité vɨnose yande ramoi eta Egipto sui, oyapo avei mbahe poromondɨisa aheve ‘toicua Tũpa yuvɨreco’ oya, para guasu Pĩra vaheve avei oyapo poromondɨisa iyavei ɨvɨ iporupɨrẽhɨsa rupi avei cuarenta aravɨter rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ahe avei aipo ehi israelita upe: ‘Tũpa vɨnosera pe pãhu sui ñepei oñehe mombehusar che nungar’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ahe avei acoi ɨvɨ iporupɨrẽhɨsa rupi ava pãhu rupi secoi. Chupe avei oñehe Tũpa rembiguai ɨvɨtrɨ Sinaí ve yande ramoi rese; ahe avei oipɨsɨ ñehesa tecovesa resendar yandeu imbou ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Yande ramoi eta rumo nomboyeroya potai eté Moisés yuvɨreco. Ipɨhañemoñetaño ité Egipto ve oyevɨ ãgua rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Evocoiyase aipo ehi Aarón upe yuvɨreco: ‘Eyapomi catu ava tũpa rahanga oreu ore reroguata ãgua’ ehi yuvɨreco chupe. ‘¿Que vo catu Moisés, ore renosesarer Egipto sui, secoi? Omano tie revo’ ehi tẽi israelita yuvɨreco aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ipare oyapo uca mbahe rahanga guaca repiaca nungar oyeupe yuvɨreco. Oyuca mbahe mɨmba ahe mbahe rahanga upe vɨropovẽhe vaherã yuvɨreco iyavei oyembovɨha pieta apo yuvɨreco güembiapo ucagüer rese tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sese Tũpa opoiño ahe ava sui, ‘Toyerure evocoiyase yasɨ, yasɨtata upe yuvɨreco’ ehiño chupe. Aipo ehi niha oñehe mombehusar icuachiaprɨ pɨpe: ‘Pe peico vahe israelita, ndahei cheu peyuca mbahe mɨmba seropovẽhe ãgua cuarenta aravɨter pɨpe ɨvɨ iporupɨrẽhɨsa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pe rumo che mboeteiẽhɨsa pɨpe peraso tũpa rahanga Moloc rẽta iyavei yasɨtata rahanga Refán pe ae tẽi peyapo vahe pe tũpaguã. Sese che opovɨnosera pe recua sui pe mondo Babilonia cupe coi cotɨ’ ehi Tũpa chupe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ɨvɨ iporupɨrẽhɨsa rupi yande ramoi eta vɨreco Tũpa porocuaita rẽta oyeupive yuvɨreco aracahe mbahe mɨmba pirer apoprɨ. ‘Na peyera yapo’ ehi Moisés upe. Evocoiyase iñehe rupi tuprɨ oyapo uca. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ahese coiye catu yande ramoi eta vɨreco co oɨ Tũpa rẽta mbahe pirer apoprɨ yuvɨreco iyavei Josué rupi yugüeru vahe güeruño ité avei yuvɨreco, omosepase Tũpa ambuae ava co yande recuavɨ sui. Ẽgüe ehiño vɨte ité ahe sereco yuvɨreco mborerecuar guasu, David, secoise aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ahe David avɨye ité Tũpa upe, oyapo pota setarã ‘toime tũparoguã yande ramoi Jacob rembieroya upe’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Tahɨr Salomón rumo omopuha ité ahe tũparo. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tũpa rumo, seco ɨvate vahe, ndasecoi vahe tũparo ava tẽi rembiapo pɨpe. Inungar acoi omombehu vahe Tũpa ñehe mombehusar aracahe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ɨva che renda iyavei ɨvɨ che pɨrunga. ¿Mbahe nungar oɨ vo peyapora cheu? ehi yande Yar. ¿Que vo evocoiyase che pɨtuhu ãgua? ");
INSERT INTO gyrNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Che niha opacatu co mbahe aposar aico’ ehi Tũpa icuachiaprɨ pɨpe” ehi mborerecuar upe Esteban. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ichui aipo ehi chupe: “Pe rumo ndapeyapɨsaca potai vahe ité peico. Oime tẽi pe nambi, pe pɨha avei, ipɨpe rumo ndapeicuai eté Tũpa. Peico Espíritu Santo amotarẽhɨmbar tẽi inungar pe ramoi aracahe yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¡Uma profeta revo ndovɨreco meguai pe ramoi yuvɨreco! Ahe avei oyucapa yɨpɨndar omombehu vahe ndaseco marai vahe yusa resendar yuvɨreco. Cũritei ou ndaseco marai vahe cute. Pe avei evocoiyase ahe yuca uca ãgua peporocuai. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Pe pereco tẽi Tũpa porocuaita acoi Tũpa rembiguai güeru vahe yuvɨreco; ahe rumo ndaperoyaiño ité peico” ehi Esteban opacatu mborerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Osendupase mborerecuar iñehe, omboasɨ́ iteanga yuvɨreco; oñeaimbotereprɨ ité yamotarẽhɨsave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Esteban rumo vɨreco ité Espíritu Santo oyese. Evocoiyase ɨva rese omahese, osepia Tũpa porañetesa. Osepia avei Jesús opũha ohã Tũpa acato cotɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Evocoiyase aipo ehi: —¡Pesepia! Asepia inungar ɨva imboiprɨ. Aheve asepia Ava Rɨquehɨr Vu acato cotɨ ihãi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mborerecuareta rumo osapucai pĩrata, oyopɨño oapɨsacuar yuvɨreco ichui. Ahese yuvɨnoña guasu yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Vɨraso güecua ɨvɨi yuvɨreco. Aheve oseya oyeaosa Saulo pɨve ‘tosãro’ oya yuvɨreco chupe. Ipare oyapi-yapi ita pɨpe yuca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Oapi-apiseve, Esteban oyerure Tũpa upe: “Che Yar Jesús, eipɨsɨ che hã” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ipare oñenopɨha, oñehe pĩrata Tũpa upe: “¡Che Yar, ndeñero co ava che amotarẽhɨsar angaipa upe!” ehi. Aipo ohe pare, omano. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Iyavei Saulo, “Peyuca ité” ehi catu-catu aheve ohã. Ahe arɨ pɨpeve omboɨpɨ Jesús amotarẽhɨmbar seroyasar reca mara-mara tẽi catu sereco ãgua yuvɨreco Jerusalén ve. Evocoiyase opacatu seroyasar oñemosai yuvɨraso Judea ɨvɨ rupi, Samaria rupi avei. Apóstol güeraño opɨta Jerusalén ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Oime ava Tũpa mboeteisar yuvɨrecoi vahe, ahe vɨ́raso Esteban rehõgüer ñotɨ yuvɨreco. Itɨ̃ pare, oyasehó iteanga yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ahe pɨpeve avei aipo Saulo omombaraɨsu ava Jesús reroyasar yuvɨrecoi vahe seroya ucaẽhɨ ãgua viña. Yuvɨroique-iqueño tẽi aipo sẽta rupi cuimbahe, cuña mbotɨrɨrɨ senose soquenda ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ava oñemosai vahecuer rumo Jerusalén sui omombehuño ité ñehesa pɨ̃sɨrosa resendar que yuvɨrasosa rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe oso Samaria rupi. Aheve omombehu ava upe: “Evocoi Jesús Tũpa Rembiporavo ava pɨ̃sɨro ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ahese ava rehɨi oñemonuha Felipe ñehe rendu ãgua yuvɨreco. Oyapɨsaca tuprɨ iñehe rese yuvɨreco. Esepia, osepia mbahe sembiapo poromondɨisa. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Iyavei setá ava caruguar rerecosar sui omose caruguar. Osẽse ava sui, sãse yuvɨreco. Iyavei setá ava nomɨi vahe, ndoguatai vahe avei ombogüera. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Evocoiyase ovɨharete ahe tecua pɨpendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Aheve rumo mbɨa, Simón serer vahe, yɨpɨve ipaye ai oico, ombosɨquɨye-quɨye ava Samaria pendar. “Che seco ɨvate vahe aico” ehi angahu ava mbopa. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Evocoiyase opacatu ava, cuacua vahe iyavei chĩhivahe catu vahe oyapɨsaca tuprɨ iñehe rese, aipo ehi yuvɨreco: “Co niha Tũpa pĩratasa tuvicha vahe” ehi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Omboyeroya pucu ité yuvɨreco. Esepia, opayesa pɨpe ava ombosɨquɨye eteprɨ oico yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Oyepotase rumo Felipe Samaria ve omombehu ñehesa avɨye vahe Tũpa mborerecuasa resendar, Jesucristo recocuer resendar avei. Ahese ava rehɨi vɨroya yuvɨreco. Ipare oñeapiramo ité yuvɨreco cuimbahe, cuña avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ahe Simón avei vɨroya. Oñeapiramo pare, oso Felipe rupi. Co mbahe poromondɨisa iyavei Tũpa suindar ndayasepiai vahe rese oyepɨhamondɨi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalén ve apóstol yuvɨrecoi vahe oyandu Samaria ve setá ava oipɨsɨse Tũpa Ñehengagüer yuvɨreco. Evocoiyase omondo aheve omboetasa Pedro iyavei Juan yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Oyepotase aheve yuvɨreco, oyerure opacatu ava Jesús reroyasar rese ‘Espíritu Santo toipɨsɨ yuvɨreco’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Esepia, Espíritu Santo ndogüeyɨ vɨtei yuvɨreco sese; oñeapiramoño tẽi vɨte yande Yar Jesús rer pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pedro iyavei Juan oyerurese, omondo opo iharɨve yuvɨreco. Ahese Espíritu Santo ogüeyɨ yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ahe osepiase, Simón omondo pota guarepochi chupe, ");
INSERT INTO gyrNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","aipo ehi: —Cheu avei pemboumi tẽi evocoi pĩratasa, amondose che po que ava harɨve, togüeyɨ avei Espíritu Santo sese yuvɨreco —ehi Simón. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Omboyevɨ rumo Simón upe: —¡Tocañɨpa nde guarepochi nde reseve! Esepia, ndepɨhañemoñeta co Tũpa ombou vahe oreu, ererocua vaherã nde guarepochi pɨpe viña —ehi chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ndeu ndiyai co nungar mbahe apo ãgua. Esepia, nde pɨhañemoñetasa ndahei ihɨ̃vi vahe Tũpa rovaque. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Sese epoi nde pɨhañemoñeta raisa sui, eyerure Tũpa upe. Avɨyeteramo iñerora ndeu —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aicua nde pɨha naporai vɨte iyavei nde pɨhañemoñeta raisa pɨpe vɨte ereico —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Evocoiyase Simón omboyevɨ chupe: —Peyeruremi catu yande Yar upe che rese; tipo eme acoi mbahe pe remimombehu cheu —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Yande Yar ñehesa mombehu pare ahe tecua pendar upe, apóstol omombehu-mbehu co ñehesa pɨ̃sɨrosa resendar Samaria pɨpendar tecua rupi yuvɨreco. Ẽgüe ehi oyepota yuvɨroyevɨ Jerusalén ve yugüeru. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ipare Tũpa rembiguai oyemboyecua Felipe upe aipo ehi chupe: “Epũha, eso irohɨ cotɨ nde yepota ãgua evocoi perɨ ogüeyɨ vahe oso Jerusalén sui, Gaza ve” ehi. Evocoi Gaza piar osasa ɨvɨ iporupɨrẽhɨ rupi oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Evocoiyase opũha oso perɨ rupi. Aheve osovaĩchi ñepei ava, ahe seco ɨvate vahe guarepochi apocatusar Etiopía pendar cuña mborerecuar upe nara yepi, ahe mbɨa oso vahe Jerusalén ve Tũpa mboetei ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Oyevɨse ocãreto pɨpe, oyeroquɨ Tũpa ñehe mombehusar Isaías rembicuachiagüer rese ou. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Evocoiyase Espíritu aipo ehi Felipe upe: “Eyemboya cãretomi rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Evocoiyase vɨrovɨse ahe ava, osendu iyeroquɨ Isaías rembicuachiagüer pɨpe oĩ. Ahese oporandu chupe: —¿Eresenducua aipo Tũpa Ñehengagüer nde yeroquɨsa eĩ? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Etiopía pendar mbɨa omboyevɨ chupe: —¿Mara ahera vo che senducua viña ndipoise imombehu tuprɨsar cheu? —ehi chupe. Ipare, “Erio, eyeupi, tereguapɨ cohave che pɨri” ehi Etiopía pendar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ahe Isaías rembicuachía oyeroquɨ vahe pɨpe aipo ehi: “Inungar ava vɨraso ovesa yuca ãgua, ẽgüe ehi avei ahe mbɨa seraso yuca ãgua yuvɨreco. Iyavei inungar ovesa nasasei eté guagüer rerocuase, ẽgüe ehi avei ahe mbɨa noñehei eté. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Osecomomini yuvɨreco, ndipoi ava sepɨsar. Ndipoi ichuindar. Esepia, omocañɨ co ɨvɨ sui yuvɨreco” ehi Isaías rembicuachía pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Oyeroquɨ pare ahe Etiopía pendar oporandu chupe: —Emombehumi cheu: ¿Ava rese pĩha aipo Isaías oñehe: oyese ae pĩha, ambuae ava rese tie? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Evocoiyase co ñehesa sui omombehu ñehesa avɨye vahe Jesús recocuer resendar Etiopía pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ipare oguata catuse yuvɨreco, Etiopía pendar osepia ɨ. Aheve ahe aipo ehi chupe: —Esepia co ɨ tui. ¿Ndiyai vo cohave che ãpiramomi tẽi eve viña? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ahese omboyevɨ chupe: —Ereroya itese opacatu nde pɨha pɨpe, iya ité ndeu —ehi. —Aroya ité niha Jesucristo ahe Tũpa Rahɨr secoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Evocoiyase omombɨta uca ocãreto, ichui ogüeyɨ ɨve yuvɨraso. Aheve Etiopía pendar Felipe oñapiramo. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Yuvɨnosese ɨ sui, yande Yar Espíritu vɨraso ahe Etiopía pendar sui. Ahese ndosepia iri; ẽgüe ehiño vorɨvete oso perɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe rumo oyemboyecua Azoto ve. Ichui oso co tecua Cesarea piar rupi, omombehu Jesús recocuer opacatu tecua rupi. Ẽgüe ehi oyepota Cesarea ve oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jerusalén ve rumo Saulo oñemoɨró iteanga vɨte yande Yar reroyasar upe oico. Oyucapa potaño ité. Sese oso pahi rerecuar ɨvate catu vahe upe, ");
INSERT INTO gyrNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","oporandu chupe: “Ereyapomira mbahe icatuprɨ vahe cheu” ehi. “Taso Damasco ve, taseca co Tecocuer Pɨasu rupi cuimbahe, cuña yuvɨrecoi vahe” ehi. “Taipɨsɨpa seru cohave nde rer pɨpe” ehi, “evocoiyase eremombehura cuachiar pɨpe Damasco pendar tũparo rerecuar upe” ehi pahi rerecuar ɨvate catu vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ẽgüe ehi yuvɨnose Jerusalén sui, yuvɨraso Damasco ve ambuae ava reseve. Vɨrovɨ potase rumo Damasco yuvɨraso, avɨyeteramo tẽi osesape guasu ɨva sui chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Evocoiyase ovɨapi oso ɨvɨve. Osendu ɨva pendar ñehesa aipo ehi vahe: “Saulo, Saulo, ¿mahera vo che moña-moña eve?” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Evocoiyase oporandu chupe: “¿Ava vo nde ereico, nde mbɨa?” ehi. “Che Jesús, che niha co che moña che rereco eve” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Epũha, eique Damasco ve. Aheve amombehu ucara mbahe nde rembiapoguã ndeu” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ava rumo, yuvɨraso vahe supi, osɨquɨyé iteanga osenduse ñehesa ɨva suindar yuvɨreco. Esepia, ndosepiai eté ɨvate oñehe vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ipare Saulo opũha, omahe tẽi; ndoicatui rumo mbahe repia. Ichui supindar oipɨsɨ iyɨva rese seraso Damasco ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Aheve mbosapɨ arɨ ndasesapɨsoi, ndocarui, ndoɨhui avei oico. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Aheve mbɨa Jesucristo reroyasar Ananías serer vahe secoi. Ahe iquer nungarve oyemboyecua yande Yar aipo ehi chupe: “¡Ananías!” ehi. “Co aico, che Yar” ehi imboyevɨ chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Evocoiyase yande Yar aipo ehi chupe: “Epũha, eso calle Ihɨ̃vi serer vahe rupi. Eporandu Judas rẽtave Saulo, tecua Tarso pendar, rese. Ahe oyeroquɨ cũritei. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Oquerve angahu osepia mbɨa Ananías serer vahe omondose opo iharɨve omboesapɨso iri” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Evocoiyase omboyevɨ chupe: “¡Too! Che Yar, setá rumo evocoi mbɨa recocuer omombehu yuvɨreco cheu. Mbahe tẽi oyapo vahe nde reroyasar reco maranehɨ upe Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Cũritei ou rutei ahe mbɨa pahi rerecuar porocuaita rupi opacatu nde rer rese oyeroya vahe roquendapa ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Yande Yar rumo aipo ehi chupe: “Eso. Esepia, aiporavo evocoi mbɨa che recocuer rese oñehe vaherã ava ndahei vahe judío upe iyavei serecuar guasu yuvɨrecoi vahe upe, judío upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Che ae amboyecuara setá mbahe tẽi chupe oiporara vaherã che remimbotar mboavɨye ãgua” ehi yande Yar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Evocoiyase oso secosave. Oiquese ahe oɨ pɨpe, oso, omondo opo Saulo rese aipo ehi chupe: —Che rɨvrɨ, Saulo, yande Yar Jesús oyemboyecua vahe ndeu perɨ rupi nde yuse, ahe che mbou ndeu nde mboesapɨso iri ãgua. Toique avei catu Espíritu Santo nde rese —ehi Saulo upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ahese voi eté pira pirer nungar mbahe ovɨapipa sesa sui. Ahese voi sesapɨso iri. Ichui opũha. Ipare voi Ananías oñapiramo. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ipare Saulo ocaruse, ipĩrata catu iri. Movɨro arɨ tẽi opɨta iri Jesús reroyasar pɨri Damasco ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ipare voi oso oñehe judío tũparo yacatu rupi Damasco ve aipo ehi: “Jesús Tũpa Rahɨr ité secoi” ehi ahe pendar ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ava opacatu osendu vahe iñehe, —¿Mara ehi pĩha co? —ehi tẽi yuvɨreco—. ¿Ndahei vo acoi co mbɨa Jerusalén ve Jesús reroyasar mara-mara tẽi vɨreco vahe? ¿Ndahei vo acoi co avei ou cohave ava Jesús reroyasar ha pendar pɨsɨ ãgua serasopa ãgua avei Jerusalén ve pahi rerecuar upe viña? —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo rumo omombehu tuprɨ catu Jesús recocuer. Osecopɨ opacatu omu Damasco pendar. Omboyecua catu chupe Jesús Tũpa Rembiporavo ava pɨ̃sɨro ãgua secosa. Sese ndoicatui judío iñehe mboyevɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Setá arɨ pare judío ahe pendar omboguai yuca ãgua Saulo yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ahe rumo oyandu omboguaisa judío osãrose tecua ãchisa roquendɨpɨve arɨ, pɨ̃tu momba yuvɨreco yuca ãgua viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jesús reroyasar rumo pɨ̃tu pɨpe tecua tapia ãchisa oyere tuprɨ vahe tecua rese, icupe rupi ombogüeyɨ ɨruova guasu pɨpe imoñemi imondo yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Coiye Saulo oyepota Jerusalén ve. Aheve oyemboya pota tẽi Jesucristo reroyasar rese. Osɨquɨye rumo yuvɨreco ichui. “Avɨyeteramo co Saulo, ‘Aroya Jesucristo cute’ ehi tuprɨ tẽira yandeu” ehiño oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ipare rumo Bernabé vɨraso Saulo apóstol yuvɨrecoi vahe upe. Aheve Bernabé omombehupa chupe aipo ehi: “Co mbɨa Saulo osepia yande Yar perɨ rupi iyavei yande Yar oñehe chupe. Ichui co oñehe osɨquɨyeẽhɨsa pɨpe Damasco ve Jesús recocuer rese” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Evocoiyase Saulo opɨta aheve ipɨri. Arɨ yacatu rupi apóstol rupi oguata yepi, iyavei omombehu yande Yar recocuer osɨquɨyeẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Oiñehepoepɨ avei secocuer rese judío griego pɨpe oñehe vahe yuvɨreco. Ichui rumo oyuca potaño yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Oicuase rumo Jesucristo reroyasar yuvɨreco, vɨraso voi eté Saulo Cesarea ve. Ichui omondo Tarso ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Evocoiyase opacatu Jesús reroyasar yuvɨrecoi vahe Judea rupindar, Galilea rupindar iyavei Samaria rupindar, chupe oime mbahe tuprɨ. Iyavei oyemovɨracua tuprɨ catu yuvɨreco yande Yar mboeteisa pɨpe, Espíritu Santo oipɨ̃tɨvɨi iyemboeta catu ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro oguata opacatu rupi oso Jesucristo reroyasar repia. Ahe oso, osepia avei tecua Lida pendar Jesús reroyasar. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Aheve osepia mbɨa Eneas serer vahe, ahe ndoguatai vahe. Vupave tẽi tui vahe ocho aravɨter rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pedro aipo ehi chupe: —Eneas, Jesucristo nde mbogüera —ehi—. Eñarapuha, emoingatu nde rupa —ehi chupe. Eneas evocoiyase oñarapuha voi. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Osepiase opacatu Lida pendar, Sarón pendar co ndoguatai vahecuer guatase, vɨroyapa voi eté yande Yar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ahe aravɨter pɨpe Jope ve cuña Tabita serer vahe secoi, griego ñehe pɨpe rumo Dorcas serer. Ahe Jesucristo reroyasar secoi. Ahe secocuer avɨye vahe oporopɨ̃tɨvɨi yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Imbaheasɨ guasu rumo. Coiye omano. Ipare ava sehõgüer oyosei yuvɨreco. Ichui vɨroyeupi oɨ ɨvate vahesave seraso yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope namombrɨimi Lida sui. Evocoiyase oyanduse Jesús reroyasar Jope pendar Pedro Lida ve secoise, ahese omondo ñuvɨrío mbɨa seru poyava ãgua Jope ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Evocoiyase Pedro oso supi yuvɨreco oyepota yuvɨraso Jope ve. Aheve vɨroyeupi oɨ ɨvateve seraso tehõgüersave yuvɨreco. Opacatu cuña imer mano vahecuer oyere atɨ voi, oyaseho Pedro ɨvɨi yuvɨreco. Omboyecua avei oturucuar iharɨ pendar reseve Dorcas rembiapogüer yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ipare Pedro omosepa rane opacatu ava ocarve. Ahese ahe ae oñenopɨha, oyerure Tũpa upe. Ichui omahe ahe cuña omano vahe rese aipo ehi chupe: —¡Tabita, eñarapuha! —ehi sehõgüer upe. Aipo oyeupe hese, Tabita omboi güesa. Pedro repiase, oñarapuha oĩ. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ahese oipɨsɨ Tabita po rese imoñarapuha. Ipare, “Perio” ehi opacatu Jesús reroyasar, cuña imer mano vahecuer upe avei, “Pesepia ocuerayevɨ” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Serãcua oyanduse opacatu Jope rupi yuvɨreco, setá ava yande Yar vɨroya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Evocoiyase Pedro opɨta setá arɨ aheve, mbɨa mbahe pirer mopɨtasar, Simón serer vahe, pɨri. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tecua Cesarea ve mbɨa Cornelio serer vahe secoi, ahe cuartel Italiano serer vahe pendar cien sundao rerecuar. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ahe mbɨa omboetei Tũpa opacatu guahɨr, güembireco reseve yepi. Iyavei omondoño ité judío pɨ̃tɨvɨi ãgua guarepochi, oyeroquɨ avei Tũpa upe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ñepei arɨ, caharuse las tres rupi, osepia oquer nungar pɨpe Tũpa rembiguai güecosave aipo ehi chupe: “¡Cornelio!” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Omahengatuse sese, “¿Mbahe, che Yar?” ehi osɨquɨyepave. Tũpa rembiguai rumo omboyevɨ chupe: “Tũpa oipɨsɨ nde yeruresa; osepia avei nde poroparaɨsuerecosa” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“Emondo mbɨa Jope ve Simón reca. Ahe serer avei acoi Pedro. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ahe secoi ambuae Simón, mbahe pirer mopɨtasar pɨri. Ahe sẽta para guasu popɨve chini” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Osose Tũpa rembiguai ichui, Cornelio oñehe ñuvɨrío güembiguai upe iyavei ñepei sundao Tũpa mboeteisar upe, sese acoi oyeroya vahe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Opacatu Tũpa rembiguai ñehe mombehu pare, omondo Jope ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ahere ayihive vɨrovɨse Jope yuvɨraso, Pedro oyeupi oɨ ipe vahe harɨve mbɨter arɨ senise oyeroquɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Vɨeporẽhɨse ocaru pota viña. Omoingatu vɨteseve rumo semihura yuvɨreco, avɨyeteramo tẽi osepia mbahe oquer pendar nungar: ");
INSERT INTO gyrNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ahese osepia ɨva oyemboise, ahe ichui turucuar tuvicha vahe pɨpe ogüeyɨ mbahe, ñapɨchimbrɨ ipopɨ yacatu ou chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ahe turucuar pɨpe, osepia opacatu mahembiar vai, mboi, vɨ̃rai vai tẽi avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ahese osendu ñehesa aipo ehi vahe: “Pedro, epũha, eyuca, ichui ehu” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro rumo omboyevɨ chupe: “Aní, che Yar, che rumo ndahui vahe ité co mbahe roho ava remimbotarẽhɨ ndihusai vahe yepi” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Osendu iri ñehesa aipo ehi vahe chupe: “Tũpa remimbocatuprɨ upe, ‘Ava remimbotarẽhɨ, ndihusai vahe’ nderei chira” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ẽgüe ehi mbosapɨ oyupagüer rupi chupe. Ipare turucuar oyevɨ ɨvave oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro ipɨhañemoñeta vɨtese mbahe osepia vahecuer rese oquer nungar pɨpe: “¿Mbahe rese pĩha co oyemboyecua cheu?” ehi vɨte oico. Aheseve Cornelio remimondo oporandu-randu pare yuvɨreco, oyepota Simón rẽta roquendɨpɨve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Oñehe pucu oɨ pɨpendar upe yuvɨnoha: “¿Ave vo Simón, ahe Pedro serer vahe, secoi?” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ipɨhañemoñeta vɨteseve Pedro mbahe oyemboyecua vahecuer rese, Espíritu Santo aipo ehi chupe: “Pedro, esendu rane, pe mbosapɨ mbɨa nde reca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Eyemoingatu, egüeyɨ chupe, eso supi. ‘¿Asora pĩha?’ erei rene. Esepia, che ambou evocoi mbɨa nde reca” ehi Espíritu Santo Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Evocoiyase ogüeyɨ oso chupe. —Che, che reca vahe peye. ¿Mbahe rese vo peyu cheu? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ahe evocoiyase omboyevɨ iñehe yuvɨreco chupe: —Ore oroyu sundao rerecuar Cornelio ore cuaisa pɨpe, ahe mbɨa seco ɨ̃vɨ vahe, Tũpa mboeteisar opacatu judío osaɨsu, oipota rai yuvɨreco. Tũpa rembiguai oyocuai nde rese ereso vaherã sẽtave, ahe osendu vaherã nde ñehesa —ehi yuvɨreco Pedro upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Evocoiyase omoinguepa, omombɨtapa oyepɨri ñepei pɨ̃tu. Ahere ayihive oso supi, movɨro Jesús reroyasar Jope pendar yuvɨraso avei supi Cesarea ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ahere ayihive oyepotase Cesarea ve, yuvɨraso sẽtave. Cornelio rumo osãro opacatu omu eta rese yuvɨreco iyavei omborɨparete güembisoho reseve avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Oyepotase sẽtave oso, Cornelio rane osẽ voi, osovaĩchi, oñenopɨha sovai imboeteisa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pedro rumo aipo ehi chupe: —Epũha, che niha nde nungar avei aico —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Evocoiyase ahe omoñeta seroique seraso oɨ pɨpe. Aheve ava oñemonuha vahe setá osepia yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ahe ava upe aipo ehi: —Pe peicua judío porocuaita aipo ehi vahe: “Peiquei rene ndahei vahe judío pɨri. Aní chiaveira pemborɨ evocoi ava peico” ehi acoi —ehi Cornelio rẽta pɨpendar upe—. Tũpa rumo omombehu cheu che quer nungar pɨpe: “ ‘Ava remimbotarẽhɨ peico’ erei rene ambuae ava upe” ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Pe pemondo ava che reca. Che evocoiyase nacheatẽhɨi che yu ãgua pẽu. Sese che aicua pota, ¿mahera vo che reru uca peye? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Evocoiyase Cornelio aipo ehi chupe: —Opa co irungatu arɨ, caharuse co hora rupi tuprɨ avei, che cohave che rẽtave aicose, ndacarui eté che yerure ãgua Tũpa upe. Aheseve oyemboyecua mbɨa Tũpa rembiguai iturucuar rendɨ́ iteanga vahe cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ahe aipo ehi cheu: “Cornelio, Tũpa osendu nde yeruresa iyavei oicua avei nde poroparaɨsuerecosa. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Emondo nde rembiguai Jope ve Simón Pedro serer vahe reca. Ahe oicove ambuae Simón rẽtave, ahe mbahe pirer mopɨtasar. Ahe sẽta para guasu popɨve chini” ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Sese amondo voi eté nde reca ãgua. Avɨye nde ereyu cohave. Cũritei co opacatu yaico cohave Tũpa rovaque. Orosendu pota opacatu nde ñehe yande Yar nde cuai vahe nde ñehe ãgua oreu —ehi Cornelio chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Evocoiyase Pedro aipo ehi chupe: —Aicua cute, supi eté Tũpa nomboyahoi yande raɨsu. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Sese ambuae ɨvɨ pɨpendar omboetei vahe Tũpa, oyapo vahe avei mbahe tuprɨ yuvɨreco, ahe oipɨsɨra Tũpa. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Aracahe Tũpa oñehe avei Israel suindar upe, omombehu ñehesa tuprɨ yeamotarẽhɨẽhɨsa resendar Jesucristo rembiaporã sui, ahe opacatu ava co ɨvɨ pɨpendar yuvɨrecoi vahe Yar. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Pe peicua tuprɨ ité co mbahe oime vahe opacatu judío ɨvɨ rupi. Ahe omboɨpɨ Galilea ve Juan ñeapiramosa mombehu pare. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Peicua revo Tũpa omondo Jesús Nazaret pendar upe opĩratasa, oEspíritu Santo avei. Ipare Jesús oguata opacatu rupi mbahe tuprɨ apo oico. Ombogüera avei opacatu ava iparaɨsu vahe caruguar povrɨve yuvɨrecoi vahe. Esepia, Tũpa secoi sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ore orosepia opacatu Jesús rembiapogüer Judea ɨvɨ rupi, tecua Jerusalén pɨpe avei. Aheve imu oyatɨca uca curusu rese yuca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tũpa rumo ombogüerayevɨ imombosapɨsa arɨ pɨpe. Ipare omboyecua iri oreu. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nomboyecuai rumo opacatu ava upe, omboyecua ore sembiporavo oroico vahe upeñomi. Ore pɨri niha ocaru, oɨhu avei ocuerayevɨ pare. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iyavei ahe ore cuai: “Pemombehu ava upe. Co che Jesucristo, Tũpa Rembiporavo, aico opacatu ava recocuer rese porandu ãgua oicove vɨte vahe, omano vahe avei” ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ahe secocuer avei opacatu Tũpa ñehe mombehusar omombehu yuvɨreco aracahe aipo ehi: “Opacatu acoi seroyasar, ahe vɨrecora Tũpa ñeroisa serer pɨpe angaipa rese yuvɨreco” ehi —ehi Pedro Cornelio rẽta pɨpe yuvɨnoi vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro oñehe vɨteseve, Espíritu Santo ogüeyɨ opacatu ava osendu vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","“¡Too! Evocoiyase ndahei vahe judío upe avei Tũpa omondo Espíritu Santo inungar ombou yandeu” ehi Jesús reroyasar judío yuvɨrecoi vahe Pedro rupi yugüeru vahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Esepia, osendu ahe oñehese ñehesa ndicuasai vahe pɨpe yuvɨreco Tũpa upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Evocoiyase aipo ehi vupindar upe: —¿Oime pĩha ndoipotai vahe co ava ñeapiramo ãgua yande pãhu pendar? Esepia, co oipɨsɨ Espíritu Santo yuvɨreco inungar yande —ehi vupindar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Sese, —Yañapiramopa Jesucristo rer pɨpe yuvɨreco —ehi. Ipare Cornelio rẽta pɨpe yuvɨnoi vahe aipo ehi: “Epɨta vɨtemi movɨro arɨ ore pɨri” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Evocoiyase ambuae apóstol iyavei Jesús reroyasar Judea ve yuvɨrecoi vahe oyandu yuvɨreco ava ndahei vahe judío vɨroya avei Tũpa Ñehengagüer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Oyevɨse rumo Pedro Jerusalén ve oso, ahese setá judío Jesucristo reroyasar vɨroɨ̃ro sovai eté yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","aipo ehi: —¡Mahera eresoño tẽi eté ndahei vahe judío pɨri! Iyavei nde erecaruño tẽi eté ipãhuve yuvɨreco no —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro rumo omombehu tuprɨ yɨpɨsui opacatu mbahe güembiepia yuvɨreco chupe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Che, tecua Jope ve aicose, ayerure. Ahese che quer nungarve asepia turucuar tuvicha vahe nungar ipopɨ yacatu ñapɨchisa vahe ogüeyɨ ou che rovai ɨva sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Asepia ipɨpe opacatu mahembiar ihupɨrẽhɨ, mbahe mɨmba, mboi, vɨ̃rai vai tẽi avei —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iyavei ahese asendu ñehesa aipo ehi cheu: “Pedro, epũha, eyuca, ehu” ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Che rumo aipo ahe chupe: “Aní, che Yar, che rumo ndahui vahe ité co mbahe roho ava remimbotarẽhɨ yepi” ahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ichui asendu iri ñehesa: “Tũpa remimbocatuprɨ upe, ‘Ava remimbotarẽhɨ’ erei rene” ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ẽgüe ehi mbosapɨ oyupagüer rupi cheu. Ipare opacatu oyevɨ iri ɨvave oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Aheseve avei mbosapɨ mbɨa imbouprɨ Cesarea sui oyepota yuvɨreco che recosave che reca. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu Santo che cuai che so ãgua che atẽhɨẽhɨsa pɨpe supi yuvɨreco. Co seis mbɨa Tũpa reroyasar, yande mu, yuvɨraso avei che rupi. Ipare aheve oroyepotase oroso, oroique Cornelio rẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ahe omombehu oreu osepia vahecuer güẽtave Tũpa rembiguai oyemboyecua vahe sovai iyavei aipo ehi vahe chupe: “Emondo mbɨa tecua Jope ve Simón Pedro reru ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ahe omombehura ndeu nde ñepɨsɨro ãgua iyavei opacatu nde rẽta pendar ñepɨsɨro ãgua avei” ehi Tũpa rembiguai Cornelio upe —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Añehe ramoseve chupe, Espíritu Santo ou sese yuvɨreco inungar yande rese ou aracaco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Evocoiyase che chemahenduha voi eté yande Yar ñehengagüer rese aipo ehi vahecuer: “Supi eté ɨ pɨpe Juan oporoãpiramo, pe rumo Espíritu Santo pɨpe peñeapiramora” ehi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Tũpa Espíritu Santo omondo chupe inungar ombou yandeu yayeroyase yande Yar Jesucristo rese. Sese ndaipotai eté Tũpa ayamotarẽhɨra —ehi Pedro omu upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Osenduse rumo co Pedro ñehe, imu noñehe iri sese yuvɨreco. Ahe rumo, —¡Too, evocoiyase Tũpa ombou avei ndahei vahe judío upe secocuer recuñaro ãgua, tecovesa apɨrẽhɨ vahe rereco ãgua! —ehi Tũpa mboeteisa pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Iyavei Esteban yucare, Jesús reroyasar oñemosai Jerusalén sui yuvɨreco. Esepia, Jesús amotarẽhɨmbar oyamotarẽhɨ catu yuvɨreco. Evocoiyase amove Jesús reroyasar yuvɨraso oñemi Fenicia ve, ambuae Chipre ve, ambuae Antioquía ve. Oguatasa rupi omombehuño ité judío upe güeraño Jesús recocuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amove oñemosai vahe Chipre pendar iyavei Cirene pendar oyepota tecua Antioquía ve yuvɨreco. Omombehu rumo ndahei vahe judío upe avei ñehesa avɨye vahe yande Yar Jesús recocuer resendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yande Yar pĩratasa vɨreco yuvɨreco. Evocoiyase setá ava vɨroya; oseya ité yɨpɨndar güembieroya yuvɨreco yande Yar reroya ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Serãcua oyepotase Jesús reroyasar upe Jerusalén ve, ahese omondo Bernabé yuvɨreco Antioquía ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Oyepotase aheve, osepia Tũpa sovasase. Ahese sorɨvete aipo ehi chupe: “Peyemovɨracua catu yande Yar rese. Peyapo semimbotar opacatu pe pɨha pɨpe” ehi chupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé avɨye eteprɨ vahe, vɨroya ité Espíritu Santo iyavei oyeroya ité yande Yar rese. Evocoiyase setá ava oyemboya yande Yar rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ipare oso Tarso ve Saulo reca. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Oyosuse, güeru Antioquía ve. Aheve oyemboya yuvɨreco ambuae vɨroya vahe rese imbohe ãgua ñepei aravɨter rupi. Setá ava oyembohe ipɨri yuvɨreco. Ahese Jesús reroyasar Antioquía pendar upe yɨpɨndar, “Cristo reroyasar” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aheseve Tũpa ñehe mombehusar yugüeru Antioquía ve Jerusalén sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ñepei ipãhu pendar, Agabo serer vahe, opũha aipo ehi Espíritu Santo pĩratasa pɨpe chupe: “Oura tɨavor guasu opacatu ɨvɨ rupi” ehi, (ahe tɨavor oyepota mborerecuar guasu Claudio recose). ");
INSERT INTO gyrNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Evocoiyase Jesús reroyasar Antioquía pendar omondo pota voi guarepochi Jesús reroyasar Judea pendar pɨ̃tɨvɨi ãgua yuvɨreco ocatugüer rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ẽgüe ehi yande Yar reroyasar rãrosar Judea pendar upe porerecosa mondo. Bernabé, Saulo ahe porerecosa vɨraso yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ahe aravɨter pɨpe avei mborerecuar guasu Herodes omboɨpɨ Jesús reroyasar mombaraɨsu. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ahese oyuca uca quɨse pucu pɨpe Santiago, ahe Juan rɨquehɨr. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Oyanduse mborerecuar guasu rembiapo, sorɨvete judío rerecuar yuvɨreco. Sese Herodes oipɨsɨ uca Pedro Pascua pieta pɨpe. Ahe arɨ rupi ohu judío pan ndayapepoi vahe yuvɨreco yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pedro roquenda pare omondo irungatu imar sui irungatu-ngatu sundao omondo sãro ãgua yuvɨreco. Mborerecuar ipɨhañemoñeta: “Opase co Pascua pieta, amboyecua ucara ava rovaque” ehi viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Evocoiyase Pedro opɨta voquendasave sãrombrɨ tuprɨ chini. Jesús reroyasar rumo oyeroquɨ pĩrata Tũpa upe yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ahe arɨ vɨnose potase Herodes Pedro soquendasa sui, ahe pɨ̃tu pɨpe Pedro oque ñuvɨrío sundao guãrosar rese. Ñapɨchisa ñuvɨrío carena pɨpe ou, ñuvɨnohambe avei sãrosar soquendasa roquendɨpɨve. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Avɨyeteramo tẽi Tũpa rembiguai oyemboyecua ique vɨteseve chupe. Ahese sendɨ guasú iteanga soquendasa pɨpe. Ahe oñatoi Pedro ɨqueve imomahe: “¡Epũha poyava!” ehi chupe. Ipũhase, opa voi oyera carena ipo sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ahese Tũpa rembiguai aipo ehi chupe: “Eyemonde, emonde nde pɨtaqui” ehi. Evocoiyase Pedro omonde. Ipare aipo ehi iri: “Emonde avei nde yeaosa, eyu che raquɨcuei” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ẽgüe ehi oso saquɨcuei. Ahe rumo ndoicuai Tũpa rembiguai oyeupe ẽgüe ehise. Ndoyavɨi iquerve tẽi ẽgüe ehi vahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ichui yuvɨnose, oñocua yɨpɨndar guãrosar yuvɨreco. Ipare yuvɨraso catumi ambuae imoñuvɨriosa guãrosar oñocua avei. Oyepota oquenda guasu guarepochi apoprɨve ocarve yuvɨnose ãgua yuvɨreco. Ahe oquenda oyemboi ahe ae ité chupe yuvɨreco. Ipare yuvɨnose yuvɨraso pucumi ocarusu rupi. Avɨyeteramo tẽi Tũpa rembiguai ndoyecua iri chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Evocoiyase Pedro aipo ehi oyeupe: “¡Too! Supi eté Tũpa ombou cheu güembiguai che renose ãgua Herodes povrɨ sui. Tũpa che pɨ̃sɨro judío rerecuar che yuca rãgüer sui” ehi oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Oyese opɨhañemoñeta pare, oso, oyepota Juan Marcos sɨ María rẽtave oso. Aheve setá ava oñemonuha oyeroquɨ yuvɨreco sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Oñehese Pedro oquenda ocar cotɨndarve, cuñatai, Rode serer vahe, osẽ imboi ãgua chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Osenduse rumo Pedro ñehe, oquenda omboi rãgüer sui, oña oique oɨ pɨpe vorɨvetesave, omombehu: “Pe Pedro ihãi oquendɨpɨve” ehi oɨ pɨpendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ahe rumo, —¿Nanderocoi vo eico? —ehiño yuvɨreco chupe. “¡Aní! Supi eté” ehiño Rode chupe. —Ndahei ahe, Tũpa rembiguai mo aipo sãrosar —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Aheseve Pedro oñehe vɨteño ité oquendɨpɨve ohã. Ichui omboise oquenda yuvɨreco chupe cute, oyembosɨquɨye iriño tẽi sepiase yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pedro rumo opo omopuha imonguiriri ãgua. Ichui opa omombehu yande Yar opɨ̃sɨro agüer voquendasa sui chupe yuvɨreco. Ipare aipo ehi chupe: —Pemombehupa Santiago upe iyavei ambuae Jesús reroyasar upe —ehi. Ichui oseño, ambuaeve oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cõhese sundao oyepɨhamondɨi eteanga yuvɨreco. “¿Que pĩha Pedro?” ehi tẽi oyeupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ipare Herodes omondo sundao Pedro reca. Ndoyosui eté rumo yuvɨreco. Evocoiyase Herodes porocuaita rupi oporandu tuprɨ sãrosar upe: “¿Que vo secoi?” ehi tẽi chupe. Sese oyocuai ambuae sundao opacatu ahe sãrosar yucapa ãgua. Ipare Herodes osẽ Judea sui oso Cesarea ve oyemboerecua. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Yɨpɨndar rumo Herodes ndasorɨi eté ava Tiro pendar upe, Sidón pendar upe avei. Evocoiyase ahe pendar oyoya ipɨhañemoñeta yuvɨraso vaherã mborerecuar rovai. Ahe evocoiyase oyemborɨ Blasto rese yuvɨreco, ahe mborerecuar Herodes mboyoyasar. Ahe oporandu Blasto upe Herodes moñero uca ãgua rese yuvɨreco. Esepia, Herodes porocuaita sui oipɨsɨ mbahe güemihura yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes evocoiyase omombehu arɨ oñehe vaherã chupe. Osupitɨse ahe arɨ, omonde sese iturucuar mborerecuar secosa resendar yɨvɨrindar yuvɨreco. Ipare güenda imboeteiprɨ harɨve oguapɨ oĩ. Aheve oñehe ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Evocoiyase ava rehɨi osapucai pĩrata yuvɨreco aipo ehi: “¡Co mbɨa oñehe vahe ndahei ava tẽi, Tũpa ité!” ehi yuvɨreco Herodes upe imboeteisave. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ava aipo iheseve voi, ñepei Tũpa rembiguai oyapo mbaherasɨ guasu chupe. Ichui mbahe rasoi ocaru yavɨter rupi yuvɨreco. Esepia, nomboetei eté Tũpa. Sese omano. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Tũpa Ñehengagüer rumo imombehusa catu opacatu rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Iyavei Bernabé, Saulo ocuaita mboavɨye pare, vɨroyevɨ Juan Marcos seraso yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Evocoiyase Jesús reroyasar Antioquía pendar pãhuve oime Tũpa Ñehengagüer mombehusar, sese oporombohe vahe avei. Ahe Bernabé, Simón (chupe, “Avaũ” ehi yuvɨreco), Lucio evocoi Cirene pendar, Manaén (ahe mbɨa oyoya ocuacua mborerecuar Herodes, Galilea pendar reseve) iyavei Saulo. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ñepei arɨ opacatu Jesús reroyasar oñemonuhase yande Yar mboetei ãgua, oyecuacu avei, ahese Espíritu Santo aipo ehi chupe: “Peiporavo Bernabé iyavei Saulo. Evocoi mbɨa aiporavo cheyeupe mboravɨquɨ apo ãgua” ehi Espíritu Santo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Evocoiyase oyeroquɨ pare, omondo opo yuvɨreco iporavoprɨ ãca harɨve sovasa ãgua. Ipare omondo yuvɨreco ambuae tecua rupi Jesús recocuer mombehu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Evocoiyase Bernabé, Saulo Espíritu Santo remimondo yuvɨraso Seleucia ve. Ichui yuvɨraso carite pɨpe caha pãhu Chipre ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Oyepota yemboyasa Salamina ve yuvɨraso. Aheve omombehu Tũpa Ñehengagüer judío tũparo rupi yuvɨreco. Juan avei oso supi ipɨ̃tɨvɨi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Opase ité oguata caha pãhu Chipre pɨpe yuvɨreco, oyepota ambuae tecua Pafos serer vahesave yuvɨraso. Aheve judío ipaye vahe Barjesús serer vahe osepia yuvɨreco. Ahe oporombohe tẽi: “Che añehe Tũpa Ñehengagüer rese” ehi tuprɨ tẽi vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ahe ipaye vahe oicove Chipre pendar mborerecuar Sergio Paulo serer vahe pɨri, ahe mborerecuar yaracua vahe. Ahe güeru uca Bernabé, Saulo avei Tũpa Ñehengagüer rendu potasave oyeupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ipaye vahe rer griego ñehe pɨpe Elimas. Ahe ndovɨroya ucai güerecuar upe ñehesa supi eté vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Evocoiyase Saulo, Pablo serer vahe, vɨreco ité vahe Espíritu Santo opɨha pɨpe, omahe tuprɨ sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Ipare aipo ehi chupe: —¡Nde iporombopa serai vahe ereico! ¡Ndipɨhai vahe, Caruguar rahɨr tẽi ereico! Opacatu mbahe avɨye vahe amotarẽhɨsar tẽi avei ereico no. ¡Mahera nderepoi potai yande Yar porombohesa supi eté vahe reroɨ̃rosa sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eyapɨsaca, cũritei yande Yar nde mombaraɨsura. Nande mboesapɨsoi chira movɨro arɨ rupi. Ichui ndereicatu iri chietera arɨ rendɨgüer repia ãgua —ehi Pablo chupe. Aipo ehi ramoseve voi, opacatu pɨ̃tumimbi chupe. Oñehe tẽi ava güeraso ãgua upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ahe mbahe repiase, mborerecuar vɨroya yande Yar. Oyepɨhamondɨi porombohesa yande Yar resendar renduse. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Evocoiyase Pablo, supindar avei, yuvɨraso carite pɨpe Pafos sui Panfilia rupindar Perge ve. Juan rumo oseya oyevɨ Jerusalén ve oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perge sui yuvɨraso Antioquía ve, ahe namombrɨi Pisidia sui. Aheve, mbɨtuhusa arɨ pɨpe, yuvɨroique judío tũparove oguapɨ yuvɨnoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Oyeroquɨ pare Tũpa porocuaita resendar cuachiar pɨpe, Tũpa ñehe mombehusar cuachiar pɨpe avei, tũparo pendar rerecuar omondo oñehe Pablo upe: —Ore mu, perecose mbahe pemombehu vaherã co ava monguerẽhɨ ãgua, pemombehumi yandeu cũritei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Evocoiyase Pablo opũha ohã. Omopuha avei opo ‘toyapɨsaca che ñehe rese yuvɨreco’ oya aipo ehi: —Che mu eta, Israel ɨguar, iyavei pe ndahei vahe judío Tũpa mboeteisar, pesendu che ñehe —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israel ɨguar Tũpa oiporavo yande ramoi oyeupe nara, ahe Egipto ɨvɨ pɨpe omboeta secua ambuae vahe secosa pɨpe. Ipare opĩratasa pɨpe vɨnosepa ahe ɨvɨ sui aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ipare Tũpa oñemosaño yande ramoi reco ai upe cuarenta aravɨter rupi, oguatase yuvɨreco ɨvɨ iporupɨrẽhɨsa rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ipare omocañɨ ava eta Canaán pɨpendar siete tuprɨ yuvɨrecoi vahe serecuar reseve-seve. Ipare omondo Canaán ɨvɨ yande ramoi upe nara. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ẽgüe ehi cuatrocientos cincuenta aravɨter rupi yapo yuvɨreco —ehi. “Ipare Tũpa ombou ava recocuer moingatusar oporocuai vaherã. Ipa vahe ipãhu pendar serer Samuel aracahe. Ahe Tũpa ñehe mombehusar avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ahese yande ramoi eta oporandu yuvɨreco Tũpa upe mborerecuar guasu rese. Evocoiyase Tũpa omondo Saúl chupe, ahe Cis rahɨr, ahe yande ramoi Benjamín suindar secoi. Oporocuai cuarenta aravɨter rupi oico. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ipare Tũpa vɨrocua imborerecuasa ichui; omondo David upe yande ramoi cuai ãgua. Ahe secocuer rese aipo ehi: ‘Co David, Isaí rahɨr, oyapo che remimbotar yepi. Ahe omboavɨyera che porocuaita’ ehi Tũpa. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ahe David suindar sui, Tũpa ombou Jesús Israel ɨguar pɨ̃sɨro ãgua. Aracaheve Tũpa omombehu co yande ramoi upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Yande Yar yu renondeve, Juan omombehu opacatu Israel ɨguar upe: ‘Pemboasɨ pe angaipa, peyevɨ Tũpa upe pe ñeapiramo ãgua’ ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan omboavɨye senimise ocuaita, aipo ehi ava upe imombehu: ‘Pepɨhañemoñeta revo: co ité yande pɨ̃sɨrora, peye cheu viña. Oura rumo ambuae che raquɨcuei. Ahe che sui ɨvate catu vahe sese cheu ndiyai ipɨtaquisã yora ãgua ipɨ sui’ ehi Juan” ehi judío tũparo pendar upe imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Che mu eta, pe Abraham suindar iyavei ndahei vahe Abraham suindar Tũpa mboeteisar, opacatu yandeu nara ombou Tũpa co ñehesa pɨ̃sɨrosa resendar. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalén pendar rerecuar avei ndoicuai evocoi Jesús Tũpa remimbou secoise yuvɨreco. Iyavei ndosenducuai Tũpa ñehe mombehusar cuachiar pɨpe oyeroquɨse mbɨtuhusa arɨ yacatu yuvɨreco. Ichui ahe ae oyuca uca yuvɨreco. Ẽgüe ehi imboavɨye Jesús rese Tũpa ñehe mombehusar rembicuachiagüer pɨpendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Yepe ndoyosui mbahe sembiapo rai yuca uca ãgua yuvɨreco viña, ahe rumo oporanduño Pilato upe yuca uca ãgua rese yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","“Ichui omboavɨyese opacatu icuachiaprɨ pɨpendar yuvɨreco, ovɨroyɨ uca curusu sui ñotɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tũpa rumo ombogüerayevɨ iri. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Setá arɨ rupi oyemboyecua oyeupi oguata vahe upe, evocoi ava yugüeru vahe supi Galilea sui, Jerusalén ve. Cũritei ahe ava ité omombehu Jesús recocuer ava upe yuvɨreco” ehi tũparo pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Sese che mu eta, cũritei oromombehu pẽu evocoi ñehesa avɨye vahe Tũpa omondo vahe yande ramoi upe aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tũpa omboavɨye ramo güemimombehugüer yande Israel suindar yaico vahe upe, ombogüerayevɨse Jesús. Evocoi güemimombehu oicuachía uca Salmo moñuvɨriosa pɨpe aipo ehi: ‘Co pɨpe nde che Rahɨr ereico; che nde Ru aico’ ehi Tũpa chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Tũpa omombehu avei güemimbogüerayevɨ sete tuyuẽhɨ ãgua icuachiaprɨ pɨpe aracahe aipo ehi: ‘Che niha oroovasara acoi David upe che ñehe maranehɨ supi tuprɨ vahe mboavɨye ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Sese omombehu avei ambuae icuachiaprɨ pɨpe: ‘Nde, Tũpa, ndereseyai chira nde rembiguai Ava seco maranehɨ vahe rete ituyupa ãgua’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Supi eté, David omboavɨye ocuaita ava rese ohañecosa pɨpe yepi. Ipare omano. Evocoiyase oyapocatu tuvɨpave imu pãhuve yuvɨreco. Ahe setecuer rumo opaño ité ituyu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","“Acoi Tũpa ombogüerayevɨ vahe retecuer rumo ndituyui eté” ehi tũparo pendar upe imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Sese, che mu eta, peyapɨsaca, tapeicua evocoi Jesús recocuer sui oime ñeroisa angaipa rese yandeu. Ahe co amombehumi pẽu. Moisés porocuaita sui ndipoi ñeroisa angaipa rese yande reco mohɨvi ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jesús recocuer sui rumo oime ñeroisa ñepei-pei vɨroya vahe upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“Peicua catu co mbahe sui, tovɨapi eme pe harɨve acoi Tũpa ñehe mombehusar rembicuachiagüer pɨpe aipo ehi vahe: ");
INSERT INTO gyrNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Esepia, pe seroɨ̃rosar peico vahe. Peyepɨhamondɨi, ipare pecañɨ tẽira. Esepia, che ayapora mbahe pe recoveseve. Yepe ambuae omombehu tuprɨ itera pẽu che rembiaporã viña, pe rumo ndaperoyai chietera’ ehi Tũpa” ehi Pablo tũparo pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Yuvɨnose potase tũparo sui, omombɨta Pablo yuvɨreco: “Teremombehu irimi eremombehu vahe ñehesa ambuae mbɨtuhusa arɨ pɨpe oreu” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Yuvɨnosese ava rehɨi tũparo sui, setami judío iyavei ambuae oyembojudío vahe yuvɨraso Pablo, Bernabé rupi yuvɨreco. Ahese, “Peico tuprɨ catu Tũpa pe rovasasa pɨpe” ehi ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ambuae mbɨtuhusa arɨ pɨpe seni opacatu ava ahe pendar oñemonuha yuvɨreco Tũpa Ñehengagüer rendu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Osepiase ava rehɨi, judío rerecuar oñemoɨró iteanga Pablo upe, supindar upe avei yuvɨreco. Vɨroɨ̃ro Pablo ñehe ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Evocoiyase Pablo, Bernabé reseve oñehe yuvɨreco judío upe osɨquɨyeẽhɨsave: —Tũpa ore cuai pẽu rane ore ñehe ãgua. Pe rumo ndapeyapɨsaca potai iñehengagüer rese. Ipɨpe sui ndiyai peipɨsɨ tecovesa apɨrẽhɨ vahe. Evocoiyase orosora, oroñehe ava ndahei vahe judío upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Esepia, yande Yar ombou ore cuaitarã co ñehesa rese aracahendar aipo ehi vahe: ‘Che oroporavo tataendɨ nungar nde reco ãgua ndahei vahe judío yuvɨrecoi vahe upe pɨ̃sɨrosa reroguata ãgua opacatu ɨvɨ rupi’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ava ndahei vahe judío osenduse co ñehesa, ovɨharete yuvɨreco, omboetei avei Tũpa Ñehengagüer. Opacatu ava iporavoprɨ tecovesa apɨrẽhɨ vahe pɨsɨ ãgua, ahe vɨroya yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Evocoiyase Tũpa Ñehengagüer omombehu opacatu ahe ɨvɨ rupi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Judío rumo omonguerẽhɨ cuña imboyeroyaprɨ Tũpa mboeteisar iyavei mbɨa seco ɨvate vahe Pablo, Bernabé mose uca ãgua güecua sui yuvɨreco yamotarẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ahese Pablo, Bernabé oipɨpete opɨtaqui ɨvɨ sui yuvɨreco ‘Tũpa toicua mbahe sembiapo ai rese yuvɨreco chupe’ oya. Ichui yuvɨraso Iconio ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jesús reroyasar rumo ovɨharete yuvɨreco, vɨreco ité Espíritu Santo oyese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pablo, Bernabé oyepota Iconio ve yuvɨraso. Aheve yuvɨroique judío tũparo pɨpe, omombehu tuprɨ yande Yar recocuer yuvɨreco. Sese setá ava vɨroya iñehesa yuvɨreco judío, ndahei vahe avei judío. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Judío ndovɨroyai vahe rumo oipɨhañemoñeta rerova yuvɨreco ava ndahei vahe judío Pablo, Bernabé iyavei ambuae Jesús reroyasar amotarẽhɨ ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ahe rumo opɨta pucu yuvɨreco Iconio ve, omombehuño yande Yar recocuer osɨquɨyeẽhɨsave yuvɨreco. Aheve Tũpa ombou opĩratasa mbahe yavai vahe apo ãgua chupe ‘ichui toicua yuvɨreco Pablo, Bernabé che poroaɨsusa mombehuse’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ahe tecua pendar rumo ipɨhañemoñeta yoɨvɨ yuvɨreco: ñepei judío pɨhañemoñetasa rupindar; ambuae evocoiyase apóstol pɨhañemoñetasa rupindar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Oime judío iyavei ndahei vahe judío oyemboyoya mborerecuar rese mara-mara tẽi sereco ãgua yuvɨreco, “Ita pɨpe avei yayapi-yapi” ehi yuvɨreco chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Oyanduse rumo yuvɨreco, oñemi voi yuvɨraso Licaonia rupi, Listra ve, Derbe ve, ipopɨ rupi avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Supi omombehu ñehesa avɨye vahe Jesús resendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Listra ve yuvɨrecoise, oime mbɨa oha ramomi suive ndoguatai vahe. Ahe mbɨa oguapɨ oĩ ");
INSERT INTO gyrNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","oyapɨsaca Pablo ñehe rese. Ahese Pablo omahengatuse sese, oicua ndoguatai vahe oyeroya ité Tũpa rese ocuera ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Evocoiyase aipo ehi pĩrata chupe: —¡Epũha! —ehi. Ahese opo, opũha, oguata voi. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Osepiase ava rehɨi mbahe sembiapo yuvɨreco, osapucai pĩrata Licaonia ñehe pɨpe yuvɨreco: —¡Tũpa ité ava nungar ogüeyɨ yuvɨreco yandeu! —ehi yuvɨreco Pablo, Bernabé upe viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ipɨhañemoñeta yuvɨreco Bernabé ahe tũpa Zeus iyavei Pablo ahe tũpa Hermes viña. Esepia, Pablo oñehe vahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ahese co tũpa Zeus pahi güeru tɨvi, mbahe potrɨ avei. Ahe tecua tapia roquendave, ahe Zeus tũparo tecua pɨpe ava reiquesa rupi chini. Oyuca pota tɨvi Pablo, Bernabé mboetei ãgua yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Oicuase rumo Bernabé, Pablo, ahese omondoro oturucuar yuvɨnoña ava pãhuve; oñehe pĩrata yuvɨreco: ");
INSERT INTO gyrNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Mbɨa, ¿mahera ẽgüe peye oreu? —ehi—. Ore rumo ava tẽi pe nungar avei oroico. Oromombehu: “Pepoi co mbahe ẽgüe ehi tẽi vahe mboeteisa sui; peroya Tũpa supi eté vahe” orohe pẽu. Ahe oyapo vahe ɨva, ɨvɨ, para guasu, opacatu ipor reseve. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Aracahe rumo Tũpa, “Ẽgüe tehi oguata ndahei vahe judío opɨhañemoñetasa rupi yuvɨreco” ehi viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Tũpa rumo ndasesarai ava upe mbahe tuprɨ apo ãgua sui. Ahe ombou amar pẽu mbahe mitɨ ha avɨye ãgua yepi. Ẽgüe ehi mbahe tembihu imbou iyavei vɨharetesa pẽu —ehi ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Yepe aipo omombehu yuvɨreco chupe, ava rehɨi rumo seniño ité tɨvi oyuca yuvɨreco chupe imboetei ãgua viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ahese oyepota movɨro judío Antioquía sui, Iconio sui avei. Oipɨhañemoñeta rerova ava rehɨi yuvɨreco. Ichui oyapi-yapi ita pɨpe Pablo yuvɨreco. Ipare ombotɨrɨrɨ seraso yuvɨreco tecua ɨvɨi. Ipɨhañemoñeta: “Yayuca ité” ehi yuvɨreco chupe viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Oyere tuprɨ Pablo rese Jesús reroyasar yuvɨreco. Ahe rumo oñarapuha, oique iri oso tecua pɨpe. Ahere ayihive yuvɨnose oyevɨ yuvɨraso Bernabé reseve Derbe ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Omombehu tuprɨse co ñehesa icatuprɨ vahe Derbe rupi, setá ava vɨroya yande Yar yuvɨreco. Ipare oyevɨ yugüeru Listra rupi, Iconio rupi avei, oyepota Antioquía ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ahe supi omonguerẽhɨ catu opacatu Jesús reroyasar yuvɨreco, aipo ehi imombehu: “Yepe ava yande mombaraɨsura yuvɨreco viña, yaroyaño itera rumo Jesucristo. Sese peseya eme ité seroyasa. Yandeu avɨye catu ité mbahe-mbahe tẽi pɨpe yande recose Tũpa mborerecuasave yande reique ãgua” ehi yuvɨreco Jesús reroyasar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ipare oiporavo ava Jesús reroyasar rãro ãgua ñepei-pei ñemonuhasa rupi. Oyeroquɨ iyavei oyecuacu. Ipare vɨropovẽhe yande Yar upe iporavɨquɨ ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ipare yuvɨraso Pisidia rupi, oyepota Panfilia ɨvɨ rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Omombehu Tũpa Ñehengagüer yuvɨreco Perge ve. Ipare yuvɨraso Atalia ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ahe ichui yuvɨraso carite pɨpe Antioquía ve, ahe tecua pɨpe yɨpɨndar imondoprɨ Tũpa upe sovasaprɨ yuvɨrecoi mboravɨquɨ apo ãgua. Aheve tuprɨ avei imboavɨye pare oyevɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Oyepotase Antioquía ve yugüeru, omonuha opacatu Jesús reroyasar yuvɨreco. Aheve omombehu opacatu Tũpa mbahe oyapo vahe oyese yuvɨreco iyavei aipo ehi: “Yande Yar ombou avei ava ndahei vahe judío upe Guahɨr reroya ãgua yuvɨreco” ehi yuvɨreco omboetasa upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Aheve Pablo, Bernabé opɨta pucu yuvɨreco ipɨri. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Evocoiyase movɨro mbɨa Jesús reroyasar judío yugüeru Judea sui Antioquía ve. Ahe ombohe Jesús reroyasar yuvɨreco aipo ehi: “Aracahe Tũpa oyocuai Moisés yande ramoi cuai ãgua: ‘Pembocircuncida opacatu pe mu cuimbahe cheu nara’ ehi Tũpa aracahe” ehi yuvɨreco. “Cũritei acoi ẽgüe ndapeyeise Jesús reroyasar upe, noñepɨsɨroi chietera yuvɨreco” ehi Antioquía pendar upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo, Bernabé reseve rumo oñehe pĩrata yuvɨreco chupe. Nomoingatu catuise rumo mbahe yuvɨreco, ahese Jesús reroyasar omondo Pablo, Bernabé iyavei ambuae omboetasa Jerusalén ve apóstol upe iyavei Jesús reroyasar rãrosar upe aipo mbahe moingatu ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ẽgüe ehi Jesús reroyasar Antioquía pendar yocuai imondo yuvɨreco. Oñocuase Fenicia, Samaria avei yuvɨraso, oguatasa rupi omombehu-mbehu Jesús reroyasar upe ndahei vahe judío recocuer yuvɨreco aipo ehi: “Setá ava ndahei vahe judío opa oseya aracahendar aracuasa Tũpa rupi oguata ãgua yuvɨreco” ehi. Ahese opacatu Jesús reroyasar oyembovɨharete yuvɨreco senduse. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Yuvɨroyepotase Jerusalén ve, apóstol, Jesús reroyasar rãrosar iyavei ambuae Jesús reroyasareta oipɨsɨ tuprɨ yuvɨreco. Aheve omombehu Tũpa mbahe oyapo vahe oyese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Osenduse rumo, movɨro Jesús reroyasar fariseo opũha voi aipo ehi yuvɨreco chupe: —Aní —ehi—. Pembocircuncida rane ité catu opacatu Jesús reroyasar ndahei vahe judío —ehi yuvɨreco—. Peyocuai avei opacatu ambuae Moisés porocuaita mboavɨye ãgua yuvɨreco —ehiño ité yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ahese apóstol, Jesús reroyasar rãrosar avei oñemonuha oyemomborandu ãgua aipo mbahe rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Yemomborandu vɨteseve, Pedro opũha ipãhuve aipo ehi: —Che mu, peicua niha aracaco Tũpa che poravo pe pãhu sui co ñehesa poropɨ̃sɨrosa resendar mombehu ãgua ava ndahei vahe judío upe ‘tovɨroya yuvɨreco’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tũpa oicua ité opacatu ava pɨhañemoñetasa. Chupe avei omondo Espíritu Santo inungar yandeu. Ipɨpe sui yaicua Tũpa oipɨsɨ avei ahe ava oyeupe nara —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Evocoiyase, “Judío avɨye catu vahe ava ndahei vahe judío sui” ndehi Tũpa. Esepia, opacatu oyoya pãve Tũpa upe yaico. Sese omoatɨro ipɨhañemoñeta rai sui oyese yeroyasa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¡Pe tie pesecoãha pota Tũpa! ¡Mahera peyocuai uca pota co Jesús reroyasar mbahe yavai rai vahe apo ãgua! Aní rumo. Esepia, yande ramoi ndoicatui Tũpa porocuaita mboavɨye ãgua yuvɨreco, yande avei ẽgüe yahe —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Co rumo, yaroyase yande Yar Jesucristo, yande pɨ̃sɨrora oporoaɨsusa pɨpe, inungar co ava ndahei vahe judío yuvɨrecoi —ehi Pedro. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Evocoiyase opacatu oyemonguiriri yuvɨreco, osendu Bernabé, Pablo ñehesa, mbahe sembiapo avei yuvɨreco. Evocoiyase omombehu ndayasepiai vahe poromondɨisa Tũpa oyapo uca ava ndahei vahe judío pãhuve yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Osendupase iñehe yuvɨreco, ahese Santiago aipo ehi: —Che mu, Jesús reroyasar, peyapɨsacami che ñehe rese: ");
INSERT INTO gyrNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón omombehu yandeu Tũpa osaɨsu avei ava ndahei vahe judío. Sese oiporavo ahe ava oyeupe nara —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Oyoya tuprɨ Tũpa ñehe mombehusar rembicuachiagüer rese. Ñepei ipãhu pendar oicuachía aracahe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Coiye catu ayevɨra vitu. Ahese ayapo pɨasu irira che rẽta David oyapo uca vahecuer, ahe oɨ imocañɨpɨrer. Ambopɨasu irira oitɨpa vahecuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ẽgüe ahera yapo opacatu ambuae ava, toseca oYar yuvɨreco, che yapave opacatu ava ndahei vahe israelita cheu nara ipehaprɨ reseve. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Evocoi yande Yar rembiaporã icuaprɨ aracahe suive’ ehi Tũpa ñehe mombehusar aracahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Sese chepɨhañemoñeta iya ndayayocuai chira Moisés porocuaita rupi oñecuñaro vaherã ndahei vahe judío Tũpa rupi oguata ãgua yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","“Avɨye rumo yaicuachiase chupe co mbahe resendar güeraño: Pehui rene mbahe mɨmba yucaprɨ mbahe rahanga tẽi upe seropovẽheprɨ iyavei ndapeaguasai chira, pehui rene mbahe mɨmba yucaprɨ suvɨ renosepɨrẽhɨ, mbahe ruvɨ avei” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","“Esepia, opacatu tecua rupi yuvɨrecoi ava omombehu vahe Moisés porocuaita ñepei-pei mbɨtuhusa arɨ pɨpe judío tũparo pɨpe aracahe suive. Aipo rupive” ehi Santiago. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ahese apóstol, Jesús reroyasar rãrosar, ambuae Jesús reroyasar avei omondo pota opãhu pendar Pablo, Bernabé rupi Antioquía ve yuvɨreco. Oiporavo yuvɨreco ñuvɨrío mbɨa, ahe Judas Barsabás iyavei Silas. Ahe imboyeroyaprɨ omboetasa pãhuve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ahe supi aipo ehi icuachía imondo yuvɨreco: “Ore apóstol, Jesús reroyasar rãrosar, pe mboetasa oroico vahe. Pe mboavɨravesa, ndapemarai revo pe ndahei vahe judío Antioquía pendar, Siria pendar, Cilicia pendar avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Oroyandu amove ava ore pãhu pendar pe mañeco tẽi aipo oporombohesa pɨpe yuvɨreco. Ahe ava ndahei ore ocuaita pɨpe yuvɨraso pẽu pe pɨhañemoñeta rerova. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Sese oyoya orepɨhañemoñeta oroiporavo ñuvɨrío mbɨa ore rembiaɨsu ore rɨvrɨ Bernabé, Pablo rupi imondo eipeve pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ahe acoi oyemondo vahe mbahe-mbahe tẽi povrɨve yande Yar Jesucristo recocuer rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Oromondo Judas, Silas avei pẽu: ahe teieté omombehura opacatu cuachiar pɨpendar pẽu yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Avɨye Espíritu Santo upe, oreu avei co porocuaita güeraño oromondo vahe rese pẽu. Ndape cuaisa pota iri rumo ambuae mborocuaita rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Pehui rene mbahe mɨmba yucaprɨ seropovẽheprɨ mbahe rahanga tẽi upendar, ndapehui chiaveira mbahe ruvɨ, mbahe mɨmba yucaprɨ suvɨ renosepɨrẽhɨ vahe iyavei ndapeaguasai chira. Pepoise evocoi mbahe naporai vahe sui, oimera mbahe tuprɨ pẽu. Aipo rupive. Peico tuprɨ” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","“Avɨye” ohe pare, yuvɨraso, oyepota Antioquía ve. Aheve opase omonuha Jesús reroyasar yuvɨrecoi vahe omondo cuachiar yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ahe cuachiar rese oyeroquɨse, oyembovɨharete yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas, Silas Tũpa suindar ñehesa mombehusar avei yuvɨrecoi. Sese ombovɨharete catu iyavei omonguerẽhɨ catu avei ahe ava yuvɨreco oñehe pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Opɨtase movɨro arɨ aheve, Jesús reroyasar Antioquía pendar aipo ehi: “Avɨye. Peyevɨ tuprɨ pe mbousar upe” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas rumo opɨta potaño ité aheve. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo, Bernabé avei opɨta vɨteño ité aheve yuvɨreco, ahe setá ambuae Jesús reroyasar reseve imbohe vɨte ãgua yande Yar resendar ñehesa rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Coiye Pablo aipo ehi Bernabé upe: —Yaso, yasepia iri Jesús reroyasar opacatu yande Yar ñehengagüer yamombehu vahecuer rupi, ¿mara ehi pĩha ahe yuvɨreco? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ahese Bernabé vɨraso pota Juan Marcos oyeupi viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nomboyoyai rumo Pablo ipɨhañemoñeta rese. Esepia, cuese Juan Marcos oseyaño oyepotase yuvɨreco Panfilia ve. “Taipɨ̃tɨvɨiño iporavɨquɨsa rese” ndehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Nomoingatuise mbahe oyeupe yuvɨreco, oyepepɨño yuvɨreco oyesui. Ahese Bernabé vɨraso Marcos oyeupi carite pɨpe Chipre ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pablo rumo oiporavo Silas oyeupi icho ãgua. Yuvɨnose ãgua Antioquía sui, Jesús reroyasar ahe pendar aipo ehi yuvɨreco chupe: “Tape rovasa Tũpa oporoaɨsusa pɨpe” ehi yuvɨreco imondo. ");
INSERT INTO gyrNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ipare yuvɨraso Siria, Cilicia rupi Jesús reroyasar monguerẽhɨ catu ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo ondugüer reseve yuvɨraso Derbe ve, Listra ve avei. Aheve osepia Jesús reroyasar, Timoteo serer vahe, judía, Jesús reroyasar membrɨ. Iyesupa rumo griego. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","“Evocoi Timoteo avɨye eteprɨ” ehi Jesús reroyasar Listra pendar, Iconio pendar avei yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo vɨroguata potaño ité Timoteo oyeupi. Sese seroguata renondeve, ombocircuncida uca seroɨ̃roẽhɨ ãgua judío yuvɨrecoi vahe upe. Esepia, opacatu oicua Timoteo ru griego secose yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Evocoiyase opacatu tecua iguatagüer rupi omombehu ahe mborocuaita apóstol, Jesús reroyasar rãrosar Jerusalén pendar ombou vahe yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sese Jesús reroyasar ahe tecua rupindar oyemovɨracua catu yuvɨreco Jesús reroyasa pɨpe iyavei oyemboeta catu yuvɨreco arɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Espíritu Santo ndoipotai Asia rupi yuvɨraso vaherã Tũpa Ñehengagüer mombehu ãgua. Sese oyahuva yuvɨraso Frigia rupi, Galacia rupi avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ẽgüe ehi oyepota Misia popɨve yuvɨreco. Ichui yuvɨraso pota tẽi Bitinia ve. Jesús Espíritu rumo ndoipotai icho ãgua supi. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ahese osasaviño yuvɨraso Misia sui carite guasu yemboyasa Troas ve oyepota ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Oyepotase aheve, ahe pɨ̃tu pɨpe Pablo oquer nungar pɨpe osepia mbɨa, Macedonia pendar, “Ereyumira Macedonia ve ore pɨ̃tɨvɨi ãgua viña” ehi ohã chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ipare ore oroyemoingatu voi eté Macedonia ve ore so ãgua. Esepia, ore oroicua ité Tũpa aheve ore mondora ñehesa pɨ̃sɨrosa resendar mombehu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Oroso carite pɨpe Troas sui oromohɨviño voi oroso evocoi ɨvɨ para guasu Samotracia ve. Ahere ayihive oroyepota Neápolis ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ichui oroso ɨvɨ rupi Filipos ve, ahe tecua seroyaprɨ catu vahe ambuae tecua sui, ahe ɨvɨ Macedonia rupindar. Aheve Roma ɨguar oyeyecuai, oyocuai avei opacatu tecua ɨvɨrindar ava yuvɨreco. Aheve movɨro arɨ tẽi oroico. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Mbɨtuhusa arɨ pɨpe orosẽ evocoi tecua sui ɨai popɨve. “Aheve oñemonuhara judío oyeroquɨ ãgua” orohe. Aheseve cuña oñemonuha yugüeru. Aheve oroyepota chupe, oroguapɨ ipãhuve. Ipare oromombehu co ñehesa pɨ̃sɨrosa resendar yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ñepei imboetasa, Lidia serer vahe, Tiatira pendar, oyapɨsaca ore ñehe rese oĩ. Ahe Tũpa mboeteisar secoi, turucuar suendɨ vahe mbovendesar avei secoi. Yande Yar omohɨvi ipɨhañemoñetasa iyapɨsaca ãgua Pablo remimombehu rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Sese ñapiramosa, opacatu sẽta pendar reseve. Ipare ore mombɨta pota güẽtave. —Che reroyase peye yande Yar reroyasar che recose, pepɨtara che rẽtave —ehi oreu. Ẽgüe ehi ore monguerẽhɨ. Sese oropɨta sẽtave ipɨri. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ipare ambuae arɨ oroso irise oroyeroquɨ ãgua, cuñatai ore rovaĩchi, ahe cuñatai caruguar pĩratasa pɨpe mbahe mombehusar. Oicatu ava upe mbahe oime vaherã mombehu. Omombehuse mbahe, setá oipɨsɨ seprɨ guarepochi güerecuar yuvɨrecoi vahe upe nara yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ahe cuñatai ou ore raquɨcuei, —¡Co ava Tũpa ɨvate catu vahe upendar oporavɨquɨ yuvɨreco omombehu: “Na ehira Tũpa yande pɨ̃sɨro” ehi yuvɨreco! —ehi pucu-pucu ore mombehu ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Setá arɨ ẽgüe ehi oico oreu. Omañeco tẽise rumo Pablo, oyemboyere chupe cute, aipo ehi icaruguar upe: —Che orocuai Jesucristo rer pɨpe: esẽ co cuñatai sui —ehi. Aheseve voi caruguar osẽ ichui. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Evocoiyase cuñatai rerecuar oyanduse, “Ndoipɨsɨ uca iri chira guarepochi yandeu” ehi yuvɨreco. Imboasɨpave oipɨsɨ Pablo, Silas mborerecuar upe ocarusuve seraso yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ipare mborerecuar yuvɨrecoi vahe upe aipo ehi yuvɨreco: —Co ñuvɨrío mbɨa orogüeru vahe peu, judío tẽi yuvɨrecoi. Ayeve omboaɨvu guasu tẽi yuvɨreco yande recua pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Oporombohe güecocuer rese yuvɨreco. Secocuer rumo naporai oreu. Ore Roma ɨguar oroico, sese ndoroicatui secocuer moña ãgua —ehi yuvɨreco mborerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Evocoiyase ava eta oyamotarẽhɨ Pablo iyavei Silas yuvɨreco iyavei mborerecuar, “Pesequɨi iturucuar ichui. Ipare peinupara ɨvɨra pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Inupá iteanga pare, osoquenda yuvɨreco. Oyocuai pĩrata soquendaprɨ rãrosar yuvɨreco, “Esãro tuprɨ” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aipo oyeupe he ramoseve, soquendaprɨ rãrosar omoingue Pablo, Silas oɨ ava nose catui vahesa pɨpe. Aheve omopaha cepo pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ahe pɨ̃tu mbɨter rupi rumo Pablo, Silas oyeroquɨ, osapucai Tũpa mboeteisave yuvɨreco. Ambuae ava soquendaprɨ evocoiyase osenduño tẽi yuvɨreco isapucai. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ahese avɨyeteramo tẽi ɨvɨ orɨrɨi eteanga. Opa omomara ava roquendasa movɨracuasa, opacatu oquenda oyemboi iyavei opacatu carena oyera soquendaprɨ sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ahese soquendaprɨ rãrosar omahe yesapɨha. Osepiase oquenda imboiprɨ, ahese vɨnose oquɨse pucu sɨru sui oyeyuca ãgua viña. Esepia niha, “Opacatu ité revo soquendaprɨ yuvɨraso” ehi viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pablo rumo, —¡Ereyapoi rene mbahe tẽi ndeyeupe! ¡Esepia, opacatu oroicoveño cohave! —ehi pucu soquendaprɨ rãrosar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Evocoiyase soquendaprɨ rãrosar, “Emboumi tataendɨ” ehi ondugüer upe. Ichui oña oique, orɨrɨi, osɨquɨyepave oñenopɨha Pablo, Silas rovai oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Vɨnose pare soquendasa sui oporandu chupe: —Mbɨa, ¿mara ahera vo che ñepɨsɨro ãgua vichico? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","—Eroya yande Yar Jesucristo. Ichui ahe nde pɨ̃sɨrora, nde rẽta pendar avei —ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ahese omombehu yuvɨreco Tũpa Ñehengagüer soquendaprɨ rãrosar upe, opacatu sẽta pendar upe avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ahe pɨ̃tu pɨpeve avei soquendaprɨ rãrosar vɨraso oyeupi, yapichasa oyoseipa chupe. Ahese Pablo, Silas oñapiramo guãrosarer, sẽta pendar avei yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Vɨraso pare sãrosar güẽtave, ombocaru. Ahe sẽta pendar avei ovɨharete ité yuvɨreco Tũpa reroyasa rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Cõhese mborerecuareta omondo sundao ava rese icuaiprɨ soquendasave yuvɨreco. Oyepotase yuvɨreco, aipo ehi: “Emosepa evocoi mbɨa judío” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ahese soquendaprɨ rãrosar omombehu co ñehesa Pablo upe: —Mborerecuar ombou yuvɨreco ñehesa cheu pe mose ãgua. Peso tuprɨño peico —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Omboyevɨ rumo chupe, —Ore niha romano oroico viña, ore nupasa rumo opacatu ava rovaque. Ndoporandu rane angai eté rumo mbahe rese oreu. Ore roquendapa voiño tẽi yuvɨreco. Ipare aipo ava rembiepiaẽhɨve tẽi ore mosepa uca pota viña. ¡Aní eté rumo! Ahe teieté ru toyugüeru ore mose ãgua —ehi soquendaprɨ rãrosar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ipare sundao ava rese icuaiprɨ omombehu güerecuareta upe Pablo ñehe. Oyanduse Pablo, Silas romano secose, osɨquɨyé iteanga yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ahese ahe teieté yuvɨraso Pablo, Silas oyeupe ñero ãgua rese yuvɨreco: “Peso tuprɨño ore recua sui” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pablo, Silas yuvɨnosese voquendasa sui, yuvɨraso iri Lidia rẽtave. Oñemonuha irise ambuae Jesús reroyasar pãhuve, omonguerẽhɨ catu yuvɨreco. Ipare yuvɨraso ichui. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Oguatase Pablo iyavei Silas, oñocua Anfípolis iyavei Apolonia rupi yuvɨraso. Ẽgüe ehi oyepota tecua Tesalónica ve yuvɨreco. Aheve oime judío tũparo. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Secocuer rupi eté mbɨtuhusa arɨ pɨpe Pablo oique judío tũparove, oñemoñeta ava eta upe mbosapɨ mbɨtuhusa arɨ rupi Tũpa Ñehengagüer rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Omboyecua tuprɨ imombehu Tũpa Rembiporavo ava pɨ̃sɨro ãgua iparaɨsu rane itera, omanora, ipare rumo ocuerayevɨ iriño itera. Ipare aipo ehi: —Jesús, acoi amombehu vahe pẽu, ahe ité niha Tũpa Rembiporavo ava pɨ̃sɨro ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Amove ipãhu pendar seroyasa pɨpe oyemboya sese yuvɨreco. Setá avei ava griego yuvɨrecoi vahe, Tũpa mboeteisar judío aracuasa reroyasar avei. Ipãhuve setá avei cuña oyemboetei vahe oyemboya sese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Judío rumo ndovɨroyai vahe oñemoɨrombave secatẽhɨ ava rese yuvɨreco. Sese omonuha ava yuvɨreco tẽi vahe, ndipɨhai vahe yuvɨreco. Imonuha pare, ahe omboaɨvu guasu uca tẽi ahe ava upe opacatu güecua pɨpe yuvɨreco. Yuvɨraso Jasón rẽtave Pablo, Silas reca, vɨnose pota ava rehɨi pãhuve yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ndoyosuise rumo aheve yuvɨreco, vɨrasoño Jasón, ambuae Jesús reroyasar avei güecua rerecuar rovai yuvɨreco. Vɨroãse guasu sereco yuvɨreco, —¡Evocoi mbɨa Pablo iyavei Silas vɨrova vahe ava recocuer opacatu tecua rupi yuvɨreco, cũritei oyepotapa yuvɨreco cohave! ");
INSERT INTO gyrNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Co Jasón omombɨtuhu güẽtave. ¡Opacatu co yuvɨrecoi vahe ndovɨroyai Cesar porocuaita yuvɨreco iyavei omombehu yuvɨreco: “Oime ambuae mborerecuar guasu, ahe Jesús” ehi niha aipo yuvɨreco! —ehi yuvɨreco mborerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Aipo ñehesa renduse, oyepɨhamondɨi guasu ava eta, mborerecuar avei tecua pɨpendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mborerecuar rumo oipɨsɨpase guarepochi Jasón sui, ambuae Jesús reroyasar sui avei, ahese opa omose. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ahe pɨ̃tu pɨpeve voi ava Jesús reroyasar omondo Pablo, Silas tecua Berea ve yuvɨreco. Oyepotase aheve, yuvɨroique judío tũparo pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea pendar ava avɨye catu ava Tesalónica pendar sui. Ẽgüe ehi ipɨsɨ ohãpɨsɨẽhɨsa pɨpe ñehesa yuvɨreco iyavei arɨ yacatu rupi oseca Tũpa Ñehengagüer pɨpe ‘¿supi eté pĩha Pablo ñehesa?’ oyapave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Evocoiyase setá avei Pablo ñehe reroyasar iyavei setá griego vɨroya yuvɨreco, ndahei cuimbahe güeraño, cuña oyemboetei vahe avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Judío Tesalónica pendar rumo oyandu yuvɨreco Pablo porombohesa Tũpa Ñehengagüer rese Berea ve. Sese yuvɨraso aheve imboaɨvu guasu tẽi uca ãgua ava upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Evocoiyase Jesús reroyasar Berea pendar Pablo vɨroguata poyava voi tecua sui para guasu cotɨ yuvɨreco. Silas iyavei Timoteo rumo opɨta vɨteño aheve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Evocoiyase Pablo rupi yuvɨraso vahe vɨroyepota Atenas ve seraso. Ahe ichui vɨroyevɨ Pablo ñehe Silas upe iyavei Timoteo upe avei yuvɨreco yuvɨraso voi ãgua Pablo pɨri ahe tecuave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pablo osãro vɨteseve Silas iyavei Timoteo Atenas ve oico, ndoyembovɨhai osepiase opacatu rupi tũpa rahanga-anga tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Sese judío tũparo pɨpe omombehu Jesús recocuer judío eta upe iyavei ambuae Tũpa mboeteisar upe avei. Iyavei arɨ yacatu omoñeta ava osepia vahe ocarusu rupi ava ñemonuhasave ahe tecua pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Evocoiyase amove mbɨa oyembohe vahe epicúreo aracuasa rese iyavei mbɨa oyembohe vahe estoico aracuasa rese oñemoñeta Pablo rese yuvɨreco. Amove aipo ehi Pablo upe yuvɨreco seroɨ̃rosave: —¿Mbahe rese angahu pĩha co mbɨa iñehe papa rai ava upe oico? —ehi. Ambuae aipo ehi yuvɨreco: —Ndoyavɨi co mbɨa oñehe vahe ambuae ava Tũpa rese tẽi —ehi yuvɨreco. Esepia, omombehu Jesús recocuer iyavei cuerayevɨsa resendar. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Evocoiyase ahe oyembohe vahe vɨroyeupi Pablo Areópago serer vahesave seraso yuvɨreco. Aheve ava oñemonuhasave aipo ehi yuvɨreco chupe: —¿Ndiyai vo eresenducua uca tuprɨ catumira co porombohesa pɨasu resendar oreu viña? ");
INSERT INTO gyrNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Supi eté niha eremombehu mbahe ndorosendu vɨtei vahe, ore oroicua tuprɨ pota, ¿mara oyapave ité vo aipo ehi? —ehi yuvɨreco Pablo upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Atenas pendar iyavei yugüeru vahe Atenas ve, oyembohe pota serai vahe yuvɨreco. Ahe oñemoñetaño, omombehuño mbahe oyeupe yuvɨreco yepi iyavei osendu pota rai ñehesa ipɨasu vahe. Aheño ité ipɨhañemoñetasa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","23","Evocoiyase Pablo opũha ahe ava pãhuve aipo ehi: “Pesendu rane Atenas ɨguar. Aguatase ocar rupi asepia pe tũpa eta pemboetei vahe. Ahese asepia ñepei tũpa upe seropovẽheprɨ renda. Sese asepia icuachiaprɨ aipo ehi oĩ: ‘Tũpa ndicuasai vahe upendar’ ehi. Evocoi Tũpa ndapeicua vɨtei vahe, ahe secocuer niha amombehu pẽu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Evocoi Tũpa oyapo vahe co ɨvɨ, opacatu mbahe ipor avei. Ahe niha ɨvɨ, ɨva Yar secoi. Sese ndasecoi tũparo ava tẽi rembiapo pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ndahei ava rembiapo pɨpe sui tẽi oicove. Esepia, ndipoi mbahe ipane vahe chupe. Ahe ité niha opacatu upe ombou tecovesa, pɨ̃tuhesa iyavei opacatu mbahe oime vahe ɨvɨ, ɨvave” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Tũpa oyapo opacatu-catu tẽi ava ñepei ava sui ava yesu ãgua opacatu ɨvɨ rupi. Omondo ɨvɨ ava yemboerecua ãgua ñepei-pei upe. Arɨ avei omondo co ɨvɨ pɨpe iyemboerecua ãgua yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ẽgüe ehi ava upe ‘tache reca yuvɨreco’ oya, ‘ipɨpe sui avɨyeteramo che reroyara yuvɨreco’ oyapave. Ẽgüe ehi rumo Tũpa yande resevemi eté. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Esepia niha, Tũpa sui yaicove, ipĩratasa pɨpe yayembovava, ichui avei yareco yande recovesa, inungar oicuachía amove pe recua pendar yuvɨreco, aipo ehi: ‘Yaico ité Tũpa suindar’ ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Sese yande Tũpa suindar yaicose, ‘Co mbahe rahanga oro apoprɨ iyavei guarepochi, ita apoprɨ, ahe revo Tũpa’ ndayahei chira. Esepia, mbahe rahanga ava rembiapo tẽi, ndahei Tũpa” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","“Pe ramoi ndoicua tuprɨise yuvɨreco aracahe, Tũpa oñemosaño mbahe sembiapo rese chupe. Cũritei rumo oyocuai opacatu ava co ɨvɨ pɨpendar ‘tomboasɨ oangaipa, toyevɨ yuvɨreco cheu’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Esepia, ahe oiporavo arɨ opacatu ava recocuer rese porandu uca ãgua güecocuer ɨ̃vi tuprɨsa pɨpe ñepei güembiporavo upe. Ahe ombogüerayevɨ güembiporavo omano vahe pãhu sui ‘toicua opacatu ava güecocuer rese iporandu ãgua’ oya” ehi Atenas pendar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Osenduse yuvɨreco cuerayevɨsa resendar, ahese oime ava oyoyai catu yuvɨreco seroɨ̃rosave. Ambuae rumo aipo ehi yuvɨreco: —Torosendu irimi aipo ñehesa curi —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Sese Pablo osẽ ipãhu sui oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Movɨro rumo mbɨa oyemboya sese, vɨroya ité vahe iñehesa yuvɨreco. Ahe ipãhuve secoi mbɨa Dionisio serer vahe, ahe Areópago pãhu pendar iyavei cuña Dámaris serer vahe. Ambuae oime vɨte yuvɨreco seroyasar. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Coiye catu Pablo osẽ Atenas sui, oso Corinto ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Aheve oyoepia mbɨa judío, Aquila serer vahe rese yuvɨreco. Ahe mbɨa aipo Ponto ve oha vahecuer. Yugüeru ramo rumo Italia sui güembireco Priscila reseve. Yuvɨnose ñepei tecua Italia rupindar Roma sui oyocuaise mborerecuar guasu Claudio: “Toyuvɨnose ité opacatu judío Roma sui” ehise. Pablo oso, ");
INSERT INTO gyrNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","opɨta Aquila pɨri oporavɨquɨ ãgua. Esepia, Pablo, Aquila avei ahe mbahe pirer mbovɨvɨsar pãve yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mbɨtuhusa arɨ yacatu rupi Pablo omombehu Jesucristo recocuer ava upe judío tũparo pɨpe ‘tovɨroya Jesús judío iyavei ndahei vahe judío yuvɨreco’ oyapave. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Oyepotare rumo Silas, Timoteo Macedonia sui yuvɨreco, ahese Pablo oyemondo ité Jesús recocuer mombehu ãgua rese güeraño judío eta upe aipo ehi: “Jesús niha Tũpa Rembiporavo ava pɨ̃sɨro ãgua secoi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Iñehe-ñehe tẽi rumo seroɨ̃rosave yuvɨreco chupe. Sese Pablo oipɨpete oturucuar sovaque ‘oimera mbahe tẽi pẽu’ oya, iyavei aipo ehi chupe yuvɨreco: —Pe ae niha peseca Tũpa ñemoɨrosa peyeupe pe recocuerai sui. Ndahei rumo che resera mbahe. Esepia, che amboavɨye tuprɨ che cuaita pẽu. Che rumo, co pɨpe suive, amombehu catuño itera co ñehesa ava ndahei vahe judío upe vichico —ehi Pablo judío upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Evocoiyase Pablo osẽ judío tũparo sui, oique mbɨa Ticio Justo serer vahe rẽtave, ahe Tũpa mboeteisar avei secoi. Ahe sẽta judío tũparo ɨqueve. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Crispo, ahe judío tũparo rerecuar vɨroya avei yande Yar, opacatu sẽta pendar avei vɨroya yuvɨreco. Setá ambuae Corinto pendar avei vɨroya osenduse iñehesa yuvɨreco. Seroya pare, oñeapiramopa uca yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ñepei pɨ̃tu pɨpe yande Yar oñehe Pablo upe iquer nungarve: “Eresɨquɨyei rene, ereñehe ava upe, che mombehuño eve, erepoi rene che mombehusa sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Esepia, che nde reseve aico. Sese ndiyai ava upe nde momara uca ãgua. Supi eté che areco setá che rahɨrã co tecua pɨpe” ehi yande Yar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Evocoiyase opɨta ñepei aravɨter yemombɨtesa rupi Corinto ve oico. Aheve ombohe Tũpa Ñehengagüer rese ahe pendar ava. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Galión mborerecuar secose opacatu Acaya rupi, judío oñemonuha Pablo amotarẽhɨsave. Ichui vɨraso ahe mborerecuar upe porandusa ɨvate catusave yuvɨreco, ");
INSERT INTO gyrNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","aipo ehi yuvɨreco chupe: —Co mbɨa oipɨhañemoñeta rerova tẽi ava oTũpa mboetei ãgua. Ndahei rumo Roma pendar porocuaita rupi ẽgüe ehi yuvɨreco —ehi yuvɨreco seroɨ̃rosave chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Oñehe pota tẽi viña, Galión rane rumo oñehe judío upe: —Peyapɨsaca mbɨa judío. Pemombehuse cheu ava rembiapo naporai vahe, ahese ayemonguerẽhɨra che yapɨsaca ãgua pe remimombehu rese viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pe rumo peporandu cheu mbahe pe yembohesa resendar, pe Tũpa rer resendar iyavei pe Tũpa porocuaita resendar rese tẽi. Pemoingatu pe ae pe recocuer; ndaipotai aipo nungar mbahe moingatu ãgua —ehi Galión ahe ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ipare opa omboyepepɨ porandusa sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ahese opacatu griego oipɨsɨ judío tũparo rerecuar Sóstenes yuvɨreco. Ipare yuvɨrocua-rocua Galión rovai ahe peve yuvɨreco sese. Galión rumo, “Mara etemo che areco viña” ehiño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo secoi pucu vɨte pare Corinto ve, “Asora vichico cute” ehi Jesús reroyasar upe. Ipare yuvɨraso Aquila, Priscila reseve. Oyepotase Cencrea ve yuvɨreco para guasu popɨve, aheve Pablo oñeapipa tuprɨ oñehe mboavɨye ãgua. Ipare yuvɨraso carite pɨpe Siria ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Siria piar rupi yuvɨraso Efeso ve. Aheve opɨta Aquila, Priscila yuvɨreco. Ichui Pablo oique judío tũparo pɨpe Jesús resendar ñehesa mombehu ãgua chupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ahe pendar omombɨta pota vɨte tẽi yuvɨreco viña, Pablo rumo ndopɨta potai aheve. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Evocoiyase, “Avɨye, taso rane” ehiño chupe yuvɨreco. “Tũpa oipotase cheu, ayevɨ irira vitu pe pɨri” ehi. Ipare oso Efeso sui carite pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Oyepotase Cesarea ve, oso Jerusalén ve “avɨrave” apo ãgua Jesús reroyasar upe. Ipare oso Antioquía ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Opɨta pucu pare aheve, osẽ, oguata iri Galacia rupi, Frigia rupi opacatu Jesús reroyasar monguerẽhɨ catu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Aheseve avei judío Apolos serer vahe oso Efeso ve, ahe Apolos, Alejandría ɨguar. Oñehe tuprɨ ai vahe, oicua tuprɨ avei Tũpa Ñehengagüer. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ahe oyembohe vahe avei yande Yar recocuer rese. Omombehu oquerẽhɨsa pɨpe secocuer ava upe, oporombohe tuprɨ ai avei sese. Ahe rumo oicua Juan oãpiramo agüer güeraño tẽi. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ahe osɨquɨyeẽhɨsave judío tũparo pɨpe omombehu Tũpa Ñehengagüer. Osenduse Aquila, Priscila iñehesa, omombɨta yuvɨreco oyepɨri. Ahese omombehu tuprɨ catu Tũpa recocuer chupe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Oso potase Apolos Acaya cotɨ, ahese Jesús reroyasar Efeso pendar omonguerẽhɨ catu. Oyapo cuachiar Acaya pendar upe imondo yuvɨreco sese hañeco tuprɨ ãgua. Ipare oyepota oso Acaya ve. Aheve oime ava Tũpa guaɨsusa pɨpe sui vɨroya vahe Jesús yuvɨreco. Ahe ava Apolos oipɨ̃tɨvɨi seroya tuprɨ catu ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Omboyecua opacatu rovaque judío pɨhañemoñetasa co cotɨ tẽi vahe. Ahese opa osecopɨ oñehe pɨpe ahe ava. Esepia, Tũpa Ñehengagüer pɨpe omboyecua ité: “Jesús Tũpa Rembiporavo ava pɨ̃sɨro ãgua secoi” ehi eté judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Evocoiyase Apolos Corinto ve ipɨtaseve, ahe tecua Acaya rupindar, Pablo oñocua ɨvɨvaté vahe oyepota Efeso ve oso. Aheve osepia setá Jesús reroyasar. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Evocoiyase oporandu ahe ava upe: —¿Peipɨsɨ vo Espíritu Santo pe pɨha pɨpe peroyase Jesús? —ehi chupe. —Ore ndorosendui eté aipo Espíritu Santo resendar ñehesa —ehiño yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ichui oporandu iri chupe: —Evocoiyase, ¿mbahe nungar vo ãpiramosa peipɨsɨ? —ehi. —Juan poroãpiramosa oroipɨsɨ —ehi ahe ava yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Evocoiyase aipo ehi ahe ava upe: —Juan niha oñapiramo acoi omboasɨ vahe oangaipa oyevɨse Tũpa upe. Ipare rumo omombehu ava upe: “Peroya ahe eté vahe ou vaherã che raquɨcuei” ehi. Ahe ou vaherã, “Jesús upe” aipo ehi —ehi Pablo chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Osenduse Pablo ñehe, opacatu oñeapiramo uca Jesucristo rer pɨpe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Omondose Pablo opo iharɨve yuvɨreco, ahese ogüeyɨ Espíritu Santo, oique ipɨha pɨpe yuvɨreco. Ipare avɨyeteramo tẽi oñehe ambuae ñehesa pɨpe iyavei omombehu Tũpa suindar ñehesa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ẽgüe ehi Tũpa ahe doce mbɨa yuvɨrecoi vahe upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Mbosapɨ yasɨ rupi Pablo oique omombehu Tũpa Ñehengagüer judío upe osɨquɨyeẽhɨsave itũparo pɨpe ipɨhañemoñeta rerova ãgua Tũpa mborerecuasa resendar reroya ãgua rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amove rumo judío ipɨhavɨ̃racua ité seroyaẽhɨ ãgua yuvɨreco. Ipɨpe iñehe-ñehe tẽiño co tecocuer ipɨasu vahe mombehusa rese yuvɨreco ava rehɨi rovaque. Evocoiyase Pablo oyepepɨ ichui, vɨnosepa oyeupi Jesús reroyasar yeroquɨsa Tirano serer vahesave seraso. Aheve arɨ yacatu rupi oñehe yepi. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ẽgüe ehi ñuvɨrío aravɨter rupi. Sese opacatu ava Asia rupindar judío, ava ndahei vahe judío avei osendu yuvɨreco yande Yar ñehengagüer. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Tũpa omondo güeco pĩratasa Pablo upe poromondɨisa apo ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Sese pañueru iyavei turucuar Pablo rese imboyaprɨ, ahe serasosa imbaheasɨ vahe upe imbogüera ãgua. Caruguar avei opa yuvɨnose yuvɨreco ichui. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Amove oime judío oguata vahe ocar rupi caruguar mose ãgua ava sui. Sese nara oiporu pota yande Yar Jesús rer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Evocoiyase aipo ehi caruguar upe: “Pablo Jesús recocuer omombehu vahe rer pɨpe, ‘Peyepepɨ co mbɨa sui’ ahe pẽu” ehi. Ẽgüe ehi pota avei siete Esceva rahɨr mbahe apo yuvɨreco viña. Ahe iyesupa judío pahi rerecuar secoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Caruguar rumo omboyevɨ chupe: “Che aicua Jesús recocuer, aicua avei Pablo; pe rumo ndopocuai, ¿ava vo catu pe peico?” ehiño caruguar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Aheseve ahe cuimbahe caruguar vɨreco vahe opo ipãhuve oso. Opacatu opĩratasa pɨpe opa ité osecopɨ siete mbɨa yuvɨrecoi vahe. Omomara-mara tẽi oguayɨẽhɨsa pɨpe imonanipa tuprɨ imondo. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Co mbahe sembiapo rẽracua opa oyepota opacatu Efeso pendar upe, judío upe, ava ndahei vahe judío upe avei. Evocoiyase oyembosɨquɨye guasu yuvɨreco. Ipɨpe sui opacatu oicua yande Yar Jesús rer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Setá Jesús vɨroya ramo vahe yugüeru opacatu mbahe güembiapocuer naporai vahe mombehu yuvɨreco ");
INSERT INTO gyrNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","iyavei setá ipaye vahe Jesucristo vɨroyase, omonuhapa ocuachiar ombopayesa resendar sapɨ ãgua opacatu ava rovaque yuvɨreco. Sapɨ pare, opa ahe cuachiar reprɨ vɨnose yuvɨreco. Ahe seprɨ cincuenta mil tuprɨ arɨ mboravɨquɨ reprɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ẽgüe ehi Tũpa opĩratasa pɨpe ombouvicha oñehengagüer iyavei iñehe pĩratasa oyecua catu ava rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ipare Pablo ipɨhañemoñeta Jerusalén ve oso ãgua ɨvɨ Macedonia, Acaya rupi. “Coiye catu aheve che reco vɨteseve, ichuive che asora Roma ve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Evocoiyase omondo ñuvɨrío opɨ̃tɨvɨisar Timoteo, Erasto Macedonia ve güenonera. Ahe rumo opɨta vɨtemi Asia rupi oico. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ahe arɨ pɨpe Efeso pendar yaɨvu guasu yuvɨreco co tecocuer ipɨasu vahe rese. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Aheve mbɨa Demetrio serer vahe secoi. Ahe oyapo Artemisa rẽta rahanga guarepochi apoprɨ guarepochi pɨsɨ ãgua. Ambuae ava mbahe rahanga aposar oipɨsɨ tuprɨ avei oporavɨquɨ reprɨ ipɨri yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Sese Demetrio omonuha mbahe rahanga aposar, omonuha avei ambuae oporavɨquɨ vahe Artemisa rahanga rese, ava mboaɨvu guasu uca ãgua. “Pe mbɨa, peicua yayapose mbahe Artemisa nungar, yaipɨsɨ tuprɨ yande poravɨquɨ reprɨ” ehi omboetasa upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","“Peicua avei Pablo opa ovɨrova ava eta pɨha Artemisa mboeteisa sui ‘ndahei Tũpa ité’ ohesa pɨpe yande rembiapo uve. Ndahei rumo cohapeño ẽgüe ehi, opacatu Asia rupi ẽgüe ehi avei imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Avɨyeteramo mbahe tẽi oimera yandeu yande poravɨquɨsa mocañɨ tẽi ãgua, tũparo guasu Artemisa upendar avɨyeteramo ocañɨ tẽi aveira. Opacatu Asia pendar iyavei ava opacatu ɨvɨ rupindar omboetei acoi Artemisa rahanga guasu yuvɨreco viña. Avɨyeteramo rumo ava nomboetei iri chira, iyavei vɨroɨ̃rora yande rembiapo catuprɨsa yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Osenduse aipo ihe ava yuvɨreco, oñemoɨrosa pɨpe vɨrosapucai aipo ehi yuvɨreco: “¡Imboeteiprɨ catu Artemisa yande recua pendar tasecoi!” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Opacatu Efeso rupi ava yaɨvu guasu tẽi. Osapucai vahe oipɨsɨ Gayo iyavei Aristarco, ahe ñuvɨrío Pablo rupindar yugüeru vahe Macedonia sui. Oipɨsɨse, omombo-mombo seraso yuvɨreco ava ñemonuha guasusave. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo oique pota tẽi ava rehɨi pãhuve, ambuae Jesús reroyasar rumo nomoingue uca potai yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Iyavei movɨro mborerecuar imborɨpar Asia rupindar omondo oñehe chupe aipo ehi: “Ereiquei rene ava ñemonuhasa guasuve” ehi avei yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ñemonuhasave amove ava osapucai pĩrata ñepei mbahe rese, amove osapucai ambuae mbahe rese. Esepia, yaɨvu tẽi yuvɨreco. “¿Mahera vo evocoiyase yañemonuha?” ehi tẽi setá ipãhu pendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Amove rumo ava rehɨi pãhuve yuvɨrecoi vahe judío, ahe ombohe-mbohe imoañi-añi imondo Alejandro mbahe mombehu ãgua ava rehɨi rovaque yuvɨreco. Alejandro evocoiyase omopuha tẽi opo ava monguiriri ãgua viña. Osepɨ pota omu judío ava rehɨi rovaque viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ava rehɨi rumo oicuase Alejandro judío secose yuvɨreco. Opacatu guasu osapucai pĩrata yuvɨreco. “¡Imboeteprɨ catu Artemisa yande recua pendar tasecoi!” ehi pucu-pucu yuvɨreco. Ẽgüe ehi ahe osapucai ñuvɨrío hora rupi rutei yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Evocoiyase tecua pɨpendar mbahe cuachiasar oicatuse ava monguiriri ãgua, aipo ehi chupe: “Peyapɨsaca mbɨa pe Efeso pendar, ndipoi ava ndoicuai vahe yande Artemisa tũparo rese yande hañecosa iyavei sahanga ɨva sui ovɨapi vahe rese avei hañecosa. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ndipoi niha ava, ‘Aní’ ehi vaherã che remimombehu rese. Sese peyemonguiririño, peyapoi rene mbahe pe yapɨsacaẽhɨsave. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Peruño tẽi eté co ñuvɨrío mbɨa cohave, ndoyapoi rumo mbahe tẽi Artemisa upe yuvɨreco. Nimondai mbahe rese itũparove, ndovɨroɨ̃roi avei serer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Sese Demetrio iyavei oporavɨquɨ vahe supi ahe oñemoɨrose que ava upe, toyuvɨraso rane ava recocuer moingatusar upe yuvɨreco; aheve tomoingatu güecocuer yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Pemoingatu potase que ambuae mbahe, peso ranera yemomborandusave imoingatu ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Mborerecuar revo oyandura yande rembiapo co pɨpe, ‘¿Mahera peaɨvu guasu tẽi? ¿Che amotarẽhɨmbave tie ẽgüe peye?’ ehi tiẽtera yandeu. Oporanduse yandeu, ndayaicatui chitiẽtera imboyevɨ ãgua iñehe chupe. Esepia niha, co yañemonuha yande remimbotar tẽi cohave” ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Aipo ihe pare, omomba aheve oñemonuhasa yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ava aɨvu guasu pare, Pablo, “Toyugüeru” ehi ava Jesús reroyasar upe. Ahese omboaracua ahe ava. Chupe, “Avɨye” ohe pare, oso Macedonia ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Oguatase Macedonia rupi, omonguerẽhɨ-rẽhɨ avei ambuae Jesucristo reroyasar yuvɨrecoi vahe tecua-tecua rupi. Ipare oyepota Grecia ve oso. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Aheve opɨta mbosapɨ yasɨ. Oso potase Siria ve carite pɨpe, judío ipɨhañemoñeta mara sereco ãgua rese yuvɨreco. Oyanduse, carite pɨpe oso rãgüer sui, oyevɨ iri oso Macedonia ve ɨvɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Yuvɨraso movɨro mbɨa supi, ipãhuve ñepei Berea pendar, Pirro rahɨr Sópater; ñuvɨrío Tesalónica pendar, Aristarco, Segundo; ñepei Derbe pendar, Gayo; ñuvɨrío Asia pendar, Tíquico, Trófimo. Timoteo oso avei supi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Evocoi mbɨa yuvɨraso Pablo renondeve sãro ãgua Troas ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pieta pan ndayapepoi vahe hu pare, orosẽ tecua Filipo sui carite pɨpe, cinco arɨ rupi oroyepota Troas ve. Ahe tecuave oropɨta siete arɨ rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Domingu pɨpe, ore oroñemonuha pan hu ãgua. Ahese Pablo oporombohe oico pɨ̃tu mbɨter rupi. Esepia, ahe osẽ pota ahere ayihive voi ichui. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ahe oɨ ɨvate vahesave ñemonuhasa pɨpe setá tataendɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Mbɨa chĩhivahe, Eutico serer vahe, metanave oguapɨ oĩ. Pablo rumo oñehe pucú iteanga. Evocoiyase omboopesɨi ahe chĩhivahe. Ipare oqué; avɨyeteramo tẽi ovɨapi oɨ ɨvate vahe mbosapɨsa sui. Ahese ava ogüeyɨ sehõgüer rupi ɨvɨ sui yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Evocoiyase Pablo ogüeyɨ ou chupe, oñeno oso sese icuhaguã. Ipare aipo ehi Jesús reroyasar upe: —Pesɨquɨyei rene; nomanoi moco —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ipare oyeupi iri oso ombohi pan igua. Ichui oñehe pucu vɨte. Omomba cõhe senise; ipare oso cute. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Evocoiyase co mbɨa chĩhivahe vɨroyevɨse secosave, opacatu oyembovɨha guasu catu yuvɨreco. Esepia, nomanoi eté. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pablo oso pota ɨvɨ rupi, ore ranengatu rumo oroso carite pɨpe Aso ve. Aheve oroyepota Pablo reraso ãgua semimbotar rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Oroyoepiase aheve, oha carite pɨpe ore pɨri. Ichui oroso cute Mitilene ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ahere ayihive carite pɨpe oroñocua Quío oroso. Ambuae arɨ rese oroyepota Samos ve. Ichui oroso no oroyepota Mileto ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pablo ipoyava. Esepia, oipota Jerusalén ve Pentecostés pieta pɨpe tuprɨ güeco ãgua. Sese Efeso oroñacuasaño oroso. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto ve ore recose, Pablo omondo oñehe Efeso ve ‘toyugüeru Jesús reroyasar rãrosar cheu’ oya. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Oyepotase yuvɨreco chupe, aipo ehi: “Peicua niha che recocuer avɨye ité yɨpɨsuive arɨ che reique ramosa resendar co Asia ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Arɨ yacatu rupi aporavɨquɨ yande Yar upe pe pãhuve vichico che reco asɨẽhɨsave che yasehosa pɨpe. Yepe judío che mboguai eteprɨ che recoãhasave pe recuave yuvɨreco viña, ");
INSERT INTO gyrNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","che rumo ndaicatui ñehesa avɨye vahe mombehuẽhɨ pẽu mbahe avɨye ãgua yepi. Che opombohe ava rehɨi rovaque, opombohe avei ñepei-pei pe rẽta rupi yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","“Amombehu ñehesa judío upe, ava ndahei vahe judío upe avei aipo ahe: ‘Pemboasɨ pe angaipa; peyevɨ Tũpa upe, peroya avei yande Yar Jesús’ ahe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Cũritei asora Jerusalén ve vichico. Aheve che so ãgua Espíritu che cuai che pɨha pɨpe. ‘¿Mara ehira pĩha yuvɨreco peve cheu?’ aipo ahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Co güeraño che aicua: opacatu tecua che sosa rupi Espíritu Santo aipo ehi cheu che roquenda ãgua iyavei che mombaraɨsu ãgua yuvɨreco yepi” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","“Ndacherecatẽhɨi rumo cheyese che mano ãgua. Che rumo amboavɨye potaño ité che poravɨquɨsa Tũpa upe, ahe yande Yar Jesucristo che cuai vahe co ñehesa icatuprɨ vahe mombehu ãgua. Co Tũpa oporoaɨsusa pɨpe ombou ñepei vahe Guahɨr ava pɨ̃sɨro ãgua” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Opa niha Tũpa mborerecuasa amombehu pẽu. Che rumo aicua ndache repia iri chira peye. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Sese tapeicua cũritei: ndayavɨi eté che cuaita mboavɨye ãgua co tecocuer avɨye vahe mombehu pɨpe pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Esepia, ndaicuacui eté Tũpa Ñehengagüer mombehu; che rumo amombehuño ité opacatu Tũpa recocuer pẽu. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Sese peñearo tuprɨ, pesãro avei opacatu Jesús reroyasar Espíritu Santo porocuaita rupi. Inungar ovesa rãrosar, ẽgüe peye tuprɨra sãro. Ahe Tũpa remimboepɨ yuvɨrecoi. Esepia, Jesús oipɨyere vuvɨ opacatu ava angaipa repɨrã. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Aicua che opoeyare, oyugüerura ambuae ava mahembiar oñaro ai vahe nungar pe pãhuve opacatu Jesús reroyasar mocañɨpa pota ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Oime aveira que ava pe pãhu pendar pe mbopa pota aveira yuvɨreco pe reraso ãgua oyeupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Sese pemahemoha tuprɨ peyese. Pemahenduha acoi opomboaracua tuprɨse mbosapɨ aravɨter rupi, pɨ̃tu, arɨ yacatu rupi avei che yasehosa pɨpe pe rereco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Sese, che rɨvɨreta, opoeyara Tũpa povrɨve iyavei iñehesa iporovasasa resendar pɨpe. Ahe pe movɨracua catura pe rereco iyavei omboura opacatu mbahe güemimombehu pẽu opacatu ambuae güembiporavo reseve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ndahei pe guarepochi, que oro iyavei pe turucuar pota raisa pɨpe aso pe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Peicua niha acoi che po pɨpe ité aporavɨquɨ che recove ãgua, che rupindar recove ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ẽgüe ahe amboyecua che recocuer pẽu. Supi avei ẽgüe peyera; yaporavɨquɨ tuprɨ iparaɨsu vahe rese hañeco ãgua. Pepɨhañemoñeta acoi yande Yar Jesús remimombehu rese: ‘Sorɨvete catu ava iporereco vahe, mbahe oipɨsɨ vahe sui’ ehi aracahe” ehi Efeso pendar Jesús reroyasar rãrosar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Oñehe pare, oñenopɨha oyerure ãgua opacatu omborɨpar reseve. ");
INSERT INTO gyrNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","38","Ndoyembovɨhai eté, “Ndache repia iri chira peye” oyeupe ihese. Sese opacatu oyasehó iteanga yuvɨreco, oyaco-yaco, osovaupɨte-pɨte iri tẽi avei yuvɨreco saɨsupave. Ipare yuvɨrasoño ité yuvɨreco supi carite yemboyasave. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Evocoiyase oroseyase ore rɨvɨreta yuvɨreco, oromohɨvi voi oroso carite pɨpe Cos ve. Ahere ayihive oroyepota Rodas ve, ichui oroyepota Pátara ve oroso. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Aheve orosepia carite oso vaherã Fenicia ve, ahe ipɨpe oroha, oroso. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Orosasase para guasu oroso, orosepia caha pãhu guasu Chipre serer vahe. Ahe oroñocua yande mbahe rese pocoẽhɨsa cotɨ, oroso ɨvɨ Siria ve, para guasu rovai. Carite rumo seroyemboyasa tecua Tiro ve ipɨpendar mbahe reya ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Aheve orosepia Jesús reroyasar yuvɨrecoi vahe. Ahese oropɨta siete arɨ ipɨri. Yepe ahe Jesús reroyasar aipo ehi Pablo upe yuvɨreco: “Espíritu Santo oñehe oreu. Evocoiyase eresoi rene Jerusalén ve” ehi yuvɨreco chupe viña, ");
INSERT INTO gyrNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","siete arɨ pare rumo, orosoño ité para guasu popɨve. Opacatu Jesús reroyasar yugüeru, güembireco, guahɨr reseve-seve ore rupi. Aheve oroñenopɨhapa ore yerure ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","“Avɨye, toroso rane” ore he pare chupe yuvɨreco, oroha carite pɨpe. Ahe evocoiyase oyevɨ yuvɨraso güẽtave. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tiro sui oroso Tolemaida ve. Oroyepotase, oroso Jesús reroyasar repia ãgua. Aheve oropɨta ñepei arɨ. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ahere ayihive oroso Cesarea ve. Aheve oroique, oropɨta Felipe rẽta ve, ahe oguata vahe Jesús recocuer mombehu. Ahe mbɨa iporavoprɨ secoi aracaco ambuae seis yuvɨrecoi vahe pãhuve. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Evocoi Felipe vɨreco irungatu guayrɨ ndomendai vahe. Tayrɨ Tũpa ñehe mombehusar pãve yuvɨrecoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Oropɨtase setá arɨmi ipɨri, ahese oyepota Judea sui mbɨa Agabo serer vahe oreu. Ahe avei Tũpa ñehe mombehusar secoi. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ouse ore pãhuve, vɨrocua Pablo rumbɨcuasa ichui. Ipɨpe oñapɨchi opɨ, opo avei. Ahese aipo ehi oreu: —Espíritu Santo oicua uca cheu, na ehira judío Jerusalén pendar co tumbɨcuasa yar ãpɨchi yuvɨreco iyavei omondora ava ndahei vahe judío upe —ehi Agabo imombehu oreu. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Orosenduse aipo ihe, ore, evocoi Cesarea pendar avei, oromombehu Pablo upe: “Eresoi rene Jerusalén ve” orohe tẽi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Omboyevɨ rumo oreu: —¡Mahera peyaseho che rese, ndache mbovɨhai peye! Che rumo ayemoingatu voi che ãpɨchi uca ãgua, che mano ãgua rese avei Jerusalén ve yande Yar Jesús recocuer rese —ehi oreu. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ndoroicatuise ipɨhañemoñetasa rerova ãgua, oropoiño ichui aipo orohe: —Tayaposa ayase yande Yar remimbotar —oroheño chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ipare cute oroyemoingatu ore so ãgua Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ichui yuvɨraso avei movɨro ore rupi Jesús reroyasar Cesarea pendar. Ahe ore reraso Chipre pendarer Mnasón rẽtave. Ahe oremoingue oyepɨri. Ahe yɨpɨve ité vɨroya yande Yar oico. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Oroyepotase Jerusalén ve, ahe pendar Jesús reroyasar nihapɨsɨi ore pɨsɨ yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ahere ayihive Pablo, ore avei oroso Santiago repia. Aheve yuvɨrecove avei opacatu Jesús reroyasar rãrosar Jerusalén pendar. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo, “Avɨrave” ehi opacatu oñemonuha vahe upe. Ipare omombehu tuprɨ yɨpɨsuive oyeupe Tũpa mbahe oyapo uca vahe ava ndahei vahe judío pãhu rupi. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Osenduse, omboetei guasu Tũpa yuvɨreco. Omombehu Pablo upe yuvɨreco: —Che mu, ereicua setá iteanga judío vɨroya Jesús yuvɨreco. Ahe setacuer setá catu mil vahe sui cute. Opacatu evocoi ava iquerẽhɨ vahe Moisés porocuaita aracahendar mboavɨye ãgua yuvɨreco —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Osendu tẽi nde rembiapo yuvɨreco. Omombehu tẽi avei aipo nde he yande mu ambuae tecua rupindar yuvɨrecoi vahe upe: “ ‘Peseya Moisés porocuaita. Pembocircuncida iri rene pe rahɨr. Peico iri rene yande recocuer aracahendar pɨpe’ aipo ehi tẽi oico” ehi nde mombehu yuvɨreco —ehi Pablo upe yuvɨreco—. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Mara yahera vo? Esepia, oyandura nde yepotasa cohave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Avɨye catu ereyapora ore porocuaita oromombehu vahe ndeu. Oime irungatu mbɨa ore pãhuve. Ahe mbɨa omboavɨyera güemimombehu Tũpa upe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Eraso co mbɨa ndeyeupi, eñemoatɨro supi eso, emboepɨ avei mbahe Tũpa upe icuavẽheprɨ. Ahese ahe mbɨa oicatura oñeapi yuvɨreco. Eremboavɨyese evocoi mborocuaita, opacatu judío nde reroyara, oicuara ava semira tẽise mbahe nde rembiapo rese yuvɨreco. Oicua aveira, nde ereroya vɨte Moisés suindar mborocuaita —ehi yuvɨreco chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ndoroyocuai rumo ava Jesús reroyasar ndahei vahe judío evocoi nungar mbahe rese. Esepia, opa icuachiasa chupe: “Pehui rene mbahe mɨmba yucaprɨ mbahe rahanga tẽi upendar seropovẽheprɨ, pehui rene mbahe ruvɨ, pehui rene mbahe mɨmba yucaprɨ suvɨ renosepɨrẽhɨ vahe iyavei peaguasai rene” orohe chupe —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Evocoiyase Pablo vɨraso ahe irungatu mbɨa yuvɨrecoi vahe oyeupi. Ahere ayihive oyoya oñemoatɨro yuvɨreco. Ipare yuvɨroique judío tũparo guasu pɨpe, omombehu yuvɨreco pahi upe: “Oroñemoatɨro ramo. Sese oroyevɨra siete arɨ pɨpe oromombase ore ñemoatɨrosa. Ahese oromondo pota ndeu porerecosa Tũpa porocuaita rupi icuavẽhepɨrã” ehi yuvɨreco pahi upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Opa potase evocoi siete arɨ, judío Asia pendar osepia Pablo tũparo pɨpe yuvɨreco. Ahese omoñemoɨro uca opacatu ava rehɨi tũparo pendar. Ipare ipɨsɨse, ");
INSERT INTO gyrNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","sãse yuvɨreco: “¡Ore mu, ore pɨ̃tɨvɨi peye co mbɨa oroipɨsɨ vahe rese! Esepia, oguata opacatu rupi. Oñehe tẽi yande rese, Moisés porocuaita rese, yande tũparo rese avei iyavei vɨroique ava ndahei vahe judío yande tũparo pɨpe. Sese omonguɨha tẽi yande tũparo maranehɨ” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Co rese aipo ehi. Esepia, cuese osepia Pablo vɨroguatase Trófimo oyeupi, ahe mbɨa Efeso pendar ndahei vahe judío. Sese ipɨhañemoñeta ‘Pablo vɨroguata ava ndahei vahe judío yande tũparo pɨpe’ oya yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Opacatu Jerusalén pendar ndasorɨi yuvɨreco. Cũriteimi ava yuvɨnoña guasu tũparove. Oipɨsɨ Pablo ombotɨrɨrɨ senose tũparo pɨpe sui yuvɨreco. Ahese omboya voi guaquɨcuei tũparo roquenda yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Oyuca potase yuvɨreco, ahese yaɨvu rẽracua oyepota sundao rerecuar guasu upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Cũriteimi serecuar vɨraso sundao, yuvɨnoña yaɨvu vahe upe yuvɨraso. Osepiase ava sundao rerecuar guasu, isundao avei yuvɨreco, ndoyuvɨrocua iri Pablo rese yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ahese ahe sundao rerecuar guasu oyemboya oso Pablo rese, oipɨsɨ uca. Ipare oyocuai osundao, “Tapeicuhacua ñuvɨrío carena pɨpe” ehi. Evocoiyase oporandu ava upe: “¿Ava vo co mbɨa? ¿Mbahe vo oyapo pẽu?” ehi judío eta upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ahese amove ava ñepei mbahe rese oñehe, ambuae, ambuae mbahe rese tẽi yuvɨreco. Evocoiyase sundao rerecuar ndoicatui supi eté vahe mbahe rendu ãgua yaɨvu guasu vahe pãhuve. Sese, “Peraso cuartelve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Vɨroyepotase yeupisave, ichui osupi sundao oachihɨve seraso yuvɨreco ava rehɨi ñemoɨró iteangasa sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ava rehɨi rumo yuvɨrasoño ité saquɨcuei, “¡Tomano!” ehi pucu-pucu yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Omoingue potase Pablo cuartel pɨpe yuvɨreco, aipo ehi sundao rerecuar guasu upe: —¿Iyacatu vo yañemoñeta raimi? —ehi. Evocoiyase, omboyevɨ mborerecuar chupe: —¿Ereicua vo griego ñehe? —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Ndahei vo nde Egipto pendar, vavasa oyapo vahecuer ereico? Nde revo acoi ereraso oporoyuca vahe pãve cuatro mil tuprɨ ɨvɨ iporupɨrẽhɨsa rupi —ehi sundao rerecuar chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Evocoiyase, —Che judío, tecua Tarso pendar aico. Ahe tecua Cilicia pɨpendar imboeteiprɨ vahe secoi. Eyapomi mbahe icatuprɨ vahe cheu, tañehemi rane catu ava upe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Evocoiyase mborerecuar, “Avɨye” ehi chupe. Ipare opũha yeupisa harɨve, omopuha opo ava eta monguiriri ãgua. Ahese oyapɨsaca tuprɨ ava rehɨi yuvɨreco. Ahe ava upe oñehe hebreo ñehe pɨpe aipo ehi: ");
INSERT INTO gyrNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Che mu eta, peyapɨsaca, che añehemira che yoepɨ ãgua pẽu cũritei” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Oñehe hebreo ñehe pɨpe. Sese osenduse, oyapɨsaca tuprɨ catu yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Che judío aico. Aha Cilicia ɨvɨ pɨpe Tarso ve. Cohave rumo acuacua, Jerusalén pɨpe, Gamaliel che mbohe oyeroquɨsave. Aheve ayembohe tuprɨ yande ramoi porocuaita rese. Ahe che mbohesa pɨpe avei ayembohe Tũpa mboetei ãgua rese vichico inungar pe peico cũritei. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Che yɨpɨndar aseca-seca catu ava co Tecocuer Pɨasu rupi oguata vahe yamotarẽhɨsave. Supitɨsave, añapɨchi-pɨchi yuvɨreco yepi, asoquenda-quenda cuimbahe, cuña avei. Ayuca uca pota rai ahe ava yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pahi rerecuar ɨvate catu vahe iyavei opacatu tecua pendar rerecuar oicua che reco yuvɨreco. Ichui niha aipɨsɨ cuachiar aru vaherã yande mu tũparo rerecuar Damasco pendar upe, ‘Taso Damasco ve pahi rerecuar rer pɨpe ava Jesús reroyasar pɨsɨ ãgua. Ichui tarupa cohave imombaraɨsu ãgua’ ahe viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Evocoiyase aso Damasco ve. Ahe ipiar rupi arovɨse vicho mbɨter arɨ rupi, avɨyeteramo tẽi osesape guasu ɨva sui oreu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ahese avɨapi ɨvɨve. Asendu avei ñehesa: ‘Saulo, Saulo, ¿mahera vo che amotarẽhɨ eteprɨ eve?’ ehi vahe cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ahese aporandu: ‘¿Ava vo nde ereico, Mbɨa?’ ahe chupe. ‘Che Jesús, Nazaret pendar aico. Che niha che amotarẽhɨ eteprɨ che rereco eve’ ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Che rupindar osepia sendɨgüer, osɨquɨye avei yuvɨreco ichui. Ndosendui rumo ñehesa cheundar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Aipo ahe chupe no: ‘¿Che Yar, mara ahera vo vichico?’ Ahese ahe aipo ehi cheu: ‘Epũha, eso Damasco ve. Aheve ava opara omombehu mbahe nde rembiaporã’ ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Sendɨ́ iteanga vahe, ndache mboesapɨsoise, ahese che rupindar che po pɨsɨ che reraso Damasco ve yuvɨreco” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Aheve mbɨa, Ananías serer vahe, ou cheu. Ahe Tũpa mboyeroyasar ité, vɨroya tuprɨ vahe avei iporocuaita; sese opacatu judío secua pendar: ‘Co mbɨa avɨye vahe ité’ ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Oyepotase, aipo ehi: ‘Che rɨvrɨ, Saulo, esareco iri’ ehi. Aheseve iporẽhɨ iri mbahe cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ipare aipo ehi: ‘Yande ramoi rembieroya, yande Ru Tũpa, nde poravo güemimbotar cua ãgua. Oipota avei eresepia vaherã ichuindar ava seco ɨ̃vi vahe, eresendu aveira iñehe’ ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","‘Nde evocoiyase eremombehura secocuer opacatu ava upe; eremombehura nde rembiepia, eresendu vahe avei’ ehi cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","‘Evocoiyase, cũritei ndiya iri eresãro’ ehi. ‘Epũha, toroãpiramo. Eporandu yande Yar upe nde reco moatɨro ãgua nde angaipa sui’ ehi Ananías cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Coiye catu, ayevɨ irise Jerusalén ve, ayerure tũparo guasu pɨpe. Ahese che quer nungarve asepia mbahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Asepia yande Yar. Ahe aipo ehi cheu: ‘Nde poyava, eso voi Jerusalén sui. Esepia, Jerusalén pendar ndoyapɨsaca potai chira eremombehuse ñehesa che resendar’ ehi Jesús cheu. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Che aipo ahe chupe: ‘Che Yar, opacatu che cua nde reroyasar roquenda-quendase, ainupa-nupa ucase avei aguatase judío tũparo yacatu rupi’ ahe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Aipo ahe avei chupe: ‘Oyucase Esteban yuvɨreco, ahe nde recocuer mombehusar, che ahese asepia. Chepɨhañemoñeta rupi avɨyeño oyucase yuvɨreco. Sese asãro yucasar yeaosa vihã’ ahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Che Yar rumo omboyevɨ cheu: ‘Eso, oromondora coi rupi ava ndahei vahe judío pãhuve’ ehi che Yar cheu” ehi Pablo ava rehɨi upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Aipo rupi osendu iñehe yuvɨreco. Ahese rumo osapucai pĩrata yuvɨreco chupe: “¡Tomano co mbɨa! ¡Toicove vɨte iri eme co ɨvɨ pɨpe!” ehi yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Osapuca-pucai, osequɨipa oyeaosa oñemoɨrombave yuvɨreco iyavei omombo-mombo ɨvɨ cuhi ɨvate cotɨ yuvɨreco yamotarẽhɨmbave. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ahese sundao rerecuar guasu omoingue uca cuartelve, aipo ehi osundao upe: “Peinupa, ahese revo omombehura mbahe sui vo sãse atɨ yamotarẽhɨmbave ava yuvɨreco chupe” ehi osundao upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Oñapɨchise rumo inupa ãgua yuvɨreco, Pablo omombehu ñepei sundao rerecuar upe: —Yepe che judío, che rumo romano avei aico. ¿Iyacatu pĩha peinupara romano chupe mbahe rese poranduẽhɨseve? —ehi mborerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Osenduse iñehe, oso voi omombehu güerecuar upe. —Eicua catu, aipo mbɨa romano secoi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Evocoiyase sundao rerecuar guasu ou chupe: —¿Supi eté vo aipo nde romano ereico? —ehi. —Taa, ahe ité niha aico —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ahese sundao rerecuar guasu aipo ehi chupe: —Che rumo setá guarepochi amondo romano che reco ãgua —ehi. —Che rumo che ha ramo suive, romano aico —ehiño sundao rerecuar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ahese oinupa pota vahe osɨquɨyepave oyepepɨ yuvɨreco ichui; sundao rerecuar guasu avei oicuase Pablo romano secosa rese, osɨquɨye ñapɨchi ucase. ");
INSERT INTO gyrNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ahere ayihive sundao rerecuar guasu oicua tuprɨ pota: ¿Mbahe sui pĩha judío oyamotarẽhɨ Pablo yuvɨreco? Evocoiyase oyora. Ahese oyocuai porandusa pendar ɨvate catu vahe ahe opacatu judío pahi rerecuar, opacatu ambuae judío rerecuar iñemonuha ãgua yuvɨreco. Ahese ovɨraso uca Pablo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Aheve Pablo omahengatu ava oñemonuha vahe rese ohã aipo ehi chupe: —Che mu, che rembiapo mbahe tuprɨ Tũpa rovaque areco yepi che pɨhañemoñeta tuprɨsa pɨpe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ahese Ananías, ahe pahi rerecuar ɨvate catu vahe, yɨpɨ pendar uve, “Peiyurupete” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ahese Pablo omboyevɨ chupe: —¡Tũpa nde nupara, nde avɨye tuprɨ tẽi angahu vahe ereico! Nde mbahe rese porandu ãgua cheu porocuaita rupi ereĩ. Evocoiyase, ¿mahera ereporocuai che yurupete ãgua mborocuaita mboyeroyaẽhɨsa pɨpe? —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yɨvɨrindar aipo ehi yuvɨreco chupe: —¡Ereñehe rai rutei seroɨ̃rosa pɨpe co Tũpa rembiporavo, co yande pahi rerecuar ɨvate catu vahe upe! —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ahese omboyevɨ chupe: —Che mu, ndaicuai co oñehe vahe pahi rerecuar ɨvate catu vahe secose. Esepia, icuachiaprɨ pɨpe aipo ehi yandeu: ‘Peñehe rai eme pe rerecuar upe’ ehi —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ahese oicuase oñemonuha vahe pãhuve amove oime saduceo, amove fariseo. Ahese oñehe pĩrata chupe: —Che mu, che fariseo aico iyavei fariseo che yesupa yuvɨrecoi. Orovɨroya avei ava ocuerayevɨ vaherã curi. Sese revo co imboasɨpave oporandu mbahe rese yuvɨreco cheu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Aipo he ramoseve voi, fariseo, saduceo oñeñehepoepɨ-epɨ yuvɨreco. Sese oyemboyaho yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Esepia, saduceo ndovɨroyai vahe cuerayevɨsa iyavei “ndipoi Tũpa rembiguai, que espíritu” ehi vahe yuvɨreco. Fariseo rumo vɨroyaño ité opacatu aipo mbahe yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Sese sãse guasu yuvɨreco. Ahese oime amove opũha vahe Moisés porocuaita rese oporombohe vahe fariseo Pablo repɨsave yuvɨreco aipo ehi: —Co mbɨa ndoyapoi eté mbahe tẽi. Avɨyeteramo espíritu que Tũpa rembiguai revo oyemboyecua mbahe mombehu ãgua chupe —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Yaɨvu guasu catu-catu irise yuvɨreco, ahese sundao rerecuar guasu aipo ehi: “Avɨyeteramo ombohi-mbohira Pablo yuvɨreco” ehi. Ahese oyocuai osundao, “Penose ava pãhu sui, pemoingue iri cuartel pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ahe pɨ̃tu pɨpe, yande Yar oyemboyecua chupe aipo ehi: “Eyemonguerẽhɨ catu, Pablo, inungar che mombehu nde sɨquɨyeẽhɨsa pɨpe cohave Jerusalén ve, ẽgüe ere aveira che mombehu Roma ve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ahere ayihive setá judío oñemonuha, omboguai Pablo yuca ãgua yuvɨreco: “Tũpa rovaque ndayayucaise Pablo, ndayacarui chira, ndayaɨhui chiaveira; yayucase voi, yacarura, yaɨhura” ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ahe ava aipo ehi vahe retacuer setá catu cuarenta sui. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ichui yuvɨraso pahi rerecuar upe, tecua pendar rerecuar upe avei aipo ehi: —Oromboguai Tũpa rovaque Pablo; ndorocarui chira ndoroyucaise —ehi yuvɨreco chupe—. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Sese pe, ambuae porandusa ɨvate catu vahe pendar avei peporandu ahe sundao rerecuar guasu upe aipo peyera imombehu chupe: “Ayihive emose uca irimi Pablo oreu; oroicua uca pota iri mbahe sembiapo chupe” peyera —ehi yuvɨreco—. Osẽse, oroquẽtɨrora sese. Oyepotase ou, oroyucara —ehi yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Pablo rihɨr rumo oyanduse sẽracua, oso cuartelve chupe imombehu. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ahese Pablo oñehe sundao rerecuar upe aipo ehi imombehu chupe: —Erasomi tẽi co mbɨa chĩhivahe sundao rerecuar guasu upe. Omombehu pota mbahe chupe —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Evocoiyase mborerecuar vɨraso ahe chĩhivahe güerecuar upe aipo ehi: —Pablo soquendaprɨ oñehe cheu aipo ehi: “Eraso co mbɨa chĩhivahe sundao rerecuar guasu upe” ehi. Co chĩhivahe omombehu pota mbahe ndeu —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ahese mborerecuar guasu oipɨsɨ ipo rese, vɨroyepepɨ ambuae sui, oporandu chupe: —¿Mbahe vo eremombehu pota cheu? —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Evocoiyase ahe aipo ehi: —Judío rerecuar oyemboyoya yuvɨreco. Oporandu angahu tẽira Pablo rese seraso iri ãgua ñemonuhasa ɨvate catu vahesave ayihive yuvɨreco. “Oroporandu pota iri Pablo upe sembiapo rese” aipo ehi tẽira yuvɨreco ndeu —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ndereroyai chira ahe iporandusa yuvɨreco. Esepia, cuarenta sui setá catu ava oquẽtɨro vaherã yuvɨreco sese. Omboguai eté yuca ãgua yuvɨreco. Ndocarui, ndoɨhui chira aipo ndoyucaise yuvɨreco. Cũritei oyemoingatu, osãro vɨteño nde porocuaita yuvɨreco —ehi mbɨa chĩhivahe chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ipare sundao rerecuar guasu omboyevɨ imondo, aipo ehi chupe: “Eremombehui rene ambuae ava upe eremombehu vahe cheu” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Sundao rerecuar guasu ñuvɨrío opovrɨ pendar sundao rerecuar upe aipo ehi yocuai: “Pemoingatu dosciento sundao Cesarea ve yuvɨraso vaherã opɨ rese, ambuae setenta sundao cavayu harɨve iyavei doscientos tuprɨ toguata lanza resendar yuvɨreco. Ipare pesopara pɨ̃tuse las nueve pɨpe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","“Pemoingatu uca avei cavayu Pablo yeupi ãgua. Ẽgüe peye pesãro tuprɨra seraso yande rerecuar Félix upe” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Evocoiyase sundao rerecuar guasu oicuachía Félix upe imondo. Aipo ehi chupe: ");
INSERT INTO gyrNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Imboeteiprɨ ore rerecuar Félix. Che, Claudio Lisias, amondo che mahenduhasa ndeu. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Iyavei co amombehu pota ndeu: judío oipɨsɨ co mbɨa yuvɨreco yuca ãgua viña. Che rumo aicua romano seco rese, ahese araso sundao sepɨ ãgua judío eta sui ");
INSERT INTO gyrNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","‘¿mbahe rese pĩha ndoyambotai yuvɨreco?’ viya. Sese araso judío porandusa ɨvate catu vahe pendar upe iñemonuhasave yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ahese aicua yamotarẽhɨsa judío porocuaita sui tẽi iyavei ndoyapoi mbahe tẽi oreu. Sese ndiyai yuca ãgua oreu, soquenda ãgua avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ayanduse rumo judío oquẽtɨro sese yuvɨreco, amondo voi evocoi mbɨa ndeu. Ipare amombehu yamotarẽhɨsar upe: ‘Peporandu potase Pablo recocuer rese, pesora Félix rovai’ ahe chupe yuvɨreco. Aipo rupive” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Evocoiyase ahe pɨ̃tu pɨpe sundao vɨroguata Pablo ocuaita rupi yuvɨreco, vɨraso Antípatris ve yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ahere ayihive sundao yuvɨraso vahe opɨ rese oyevɨ yugüeru cuartelve. Sundao cavayu arɨ pendar güeraño rumo yuvɨrasoño vɨte. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Vɨroyepotase Cesarea ve, omondo cuachiar mborerecuar guasu upe yuvɨreco. Aheseve avei Pablo omondo yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Oyeroquɨ pare mborerecuar cuachiar rese, oporandu Pablo upe: “¿Que pendar vo nde ereico?” ehi. “Che Cilicia cotɨndar aico” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","—Oyepotase nde amotarẽhɨsar yuvɨreco, asendura nde yoepɨsa —ehi Félix chupe. Evocoiyase oyocuai opɨ̃tɨvɨisar Pablo rãro ãgua güẽtave Herodes rembiapogüer pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Cinco arɨ pare, Ananías, ahe pahi rerecuar ɨvate catu vahe, tecua pɨpendar rerecuar avei yugüeru Cesarea ve. Ou avei mbɨa ava mbahe aposar pɨ̃tɨvɨisar oñehe vaherã Pablo amotarẽhɨ uca ãgua, ahe serer Tértulo. Ahe yugüeru Pablo recocuer mombehu ãgua mborerecuar Félix upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Evocoiyase Félix güeru uca Pablo. Ahese Tértulo omboɨpɨ sese oñehe aipo ehi Félix upe: —Nde imboyeroyaprɨ ereico. Avɨye ndeu nde porocuai tuprɨsa rese. Esepia, ndipoi vavasa ore recua rupi. Ereyapo uca avei ore recua pɨpe mbahe iporañete vahe nde poroaɨsusa pɨpe. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Opacatu rupi nde ereyapo tuprɨ vahe oroipɨsɨ. Sese, “Avɨye ndeu” orohe ndeu, imboyeroyaprɨ Félix. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ndoromombɨta pucu potai rumo che ñehe pɨpe. Sese eyapɨsaca raimi tẽi catu che ñehe rese —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Oroyandu co mbɨa ava mañeco tẽisar oguata opacatu ɨvɨ rupi. Ore judío, ore mboyaho ore yeamotarẽhɨ uca ãgua, ahe Jesús, Nazaret pendar, reroyasar rerecuar —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Vɨroique avei ava ndahei vahe judío ore tũparo pɨpe. Ẽgüe ehi ore tũparo momara. Sese co oroipɨsɨ —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Evocoi sundao rerecuar guasu Lisias rumo oyepota ore pãhuve. Ahe opĩratasa pɨpe vɨnose ore po sui, ");
INSERT INTO gyrNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","aipo ehiño oreu: “Peso, tapemombehu co mbahe sembiapo Félix upe” ehi. Nde avei ereporandura sembiapo rese mbahe sui eté vo ẽgüe orohe chupe —ehi Tértulo. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Aipo ehi tuprɨ avei ambuae judío yugüeru vahe yuvɨreco supi. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ipare Félix oyaitɨ Pablo upe ‘toñehe’ oyapave. Ahese oñehe: —Aicua nde ereporocuai setá aravɨter ore recua rupi. Sese ayoepɨra nde rovaque che rorɨvetesa pɨpe —ehi Félix upe—. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Nde ereicua tuprɨ potase, ereporandura supi eté co pɨpe doce arɨ ramo opa che yepotare Jerusalén ve Tũpa mboetei ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Co judío oicua yuvɨreco nañehengatai ava upe tũparo guasu pɨpe, namboaɨvu ucai avei ava ambuae judío ñemonuhasa rupi iyavei que ambuae ava Jerusalén pendar —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Co mbɨa ndoicatui eté mbahe che rembiavɨ mombehu seroya tuprɨ ãgua yuvɨreco ndeu. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Co rumo amombehu vahe ndeu: che amboetei Tũpa, ore ramoi rembieroya Tecocuer Pɨasu pɨhañemoñetasa rupi. Co judío upe rumo: “Co porombohesa co cotɨ tẽi vahe” ehi. Che rumo aroya ité opacatu icuachiaprɨ porocuaita pɨpendar iyavei Tũpa ñehe mombehusar rembicuachiagüer avei —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Inungar co mbɨa, ẽgüe ahe tuprɨ avei aicua Tũpa ombogüerayevɨra ava omano vahecuer seco avɨye vahe, ndaseco põrai vahe avei coiye. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Sese ayemovɨracua tuprɨ che pɨhañemoñetasa rereco tuprɨ catu ãgua yepi Tũpa rovaque, ava rovaque avei. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Setá aravɨter pare ayevɨ che recua Jerusalén ve ava iparaɨsu vahe upe porerecosa mondo ãgua. Ahese avei mbahe mɨmba ayuca uca Tũpa upe seropovẽhe ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Evocoiyase movɨro judío Asia pendar che repia yuvɨreco Jerusalén ve tũparo pɨpe judío porocuaita rupi che ñemoatɨro pare. Ndipoi ahese ava rehɨi che rupi, namboaɨvu guasu ucai avei ava. Ahe che repia vahe rumo iya yugüeru ndeu che mombehu, que vɨrecose che amotarẽhɨsa yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Anise, avɨyeteramo co oyepota vahe cohave yugüeru, omombehura ndeu que mbahe che rembiavɨ yuvɨreco pahi rerecuar guasu ñemonuhasave che reiquesendar” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","“Co rese revo oñemoɨro yuvɨreco cheu aipo ahe pĩratase ipãhuve: ‘Che aroya ava ocuerayevɨra coiye. Sese che reraso pe rovai co pɨpe che recoãha ãgua yuvɨreco’ ahese” ehi Félix upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Félix oicua tuprɨ co Tecocuer Pɨasu. Sese osendu pare aipo ñehesa, ndoyapo pota vɨtei mbahe, aipo ehiño ava upe: —Oyepotase Lisias, ahe sundao rerecuar guasu, ahese voi aicua tuprɨ catura aipo mbahe sembiapo —ehi Félix ava upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Evocoiyase oyocuai sundao rerecuar Pablo rãro ãgua: “Eremondomira rumo que mbahe semimbotar apo ãgua chupe iyavei imborɨpar yugüeruse, tihañecoño yuvɨreco sese. Ẽgüe ere sãro” ehi Félix sãrosar upe. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Movɨro arɨ pare Félix vɨroyepota güembireco Drusila, ahe judía avei. Ahese Félix güeru uca Pablo, osendu pota iñehe Jesucristo reroyasa resendar yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Pablo rumo omombehuse chupe teco ɨ̃visa resendar, teco ñearosa resendar avei iyavei aipo ehise: “Tũpa oporandura mbahe yande rembiapogüer rese yandeu arɨ cañɨse coiye” ehise, ahese Félix osɨquɨyepave aipo ehi Pablo upe: —Esoño rane. Arecose arɨ nde ñehe rendu iri ãgua, orogüeru uca irira —ehiño. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Félix ipɨhañemoñeta yepi ‘Pablo revo omboura guarepochi cheu osẽ ãgua’ oya viña. Sese osãro pucu tẽi. Iyavei setá oyupagüer güeru uca oyeupe oñemoñeta ãgua sese. ");
INSERT INTO gyrNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ñuvɨrío aravɨter pare rumo, Porcio Festo oique Félix recuñara. Ahese Félix judío mbovɨha ãgua, oseya Pablo soquendasave. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Mbosapɨ arɨ oyepotare Festo osẽ Cesarea sui, oso Jerusalén ve. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Aheve oyepotase, pahi rerecuareta, judío rerecuareta avei omombehu Pablo recocuer yuvɨreco chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Ipare oporandu chupe: “Emboumi uca Pablo cohave oreu” ehi yuvɨreco ‘yayuca perɨ rupive’ oyapave yuvɨreco viña. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festo rumo aipo ehi chupe: “Aní. Esepia, Pablo Cesarea ve soquendasa oico iyavei che ayevɨ pɨaivira vicho aheve” ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","—Sese pemondo pe rerecuar che rupi. Naporaise co mbɨa rembiapo, aheve tomombehu yuvɨreco cheu sembiapocuerai sereco mara ãgua —ehi Festo chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Evocoiyase Festo opɨta Jerusalén ve ocho arɨ rupi revo, anise diez arɨ. Ipare oyevɨ oso Cesarea ve. Ahere ayihive oguapɨ güendave ava reco moingatu ãgua oĩ. Ahese oyocuai Pablo reru ãgua. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Oyepotase Pablo oso, ahese judío yugüeru vahe Festo rupi, oyemboya yuvɨreco sese. Ahese omombehu-mbehu tẽi Festo upe Pablo rembiapo yuvɨreco, ndoicatui eté rumo seroya uca ãgua yuvɨreco. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Esepia, Pablo aipo ehi oyoepɨsave: —Ndayemboangaipai judío porocuaita rese, judío tũparo rese, yande rerecuar guasu Roma pendar Cesar rese avei —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festo rumo ombovɨha pota judío, sese oporandu Pablo upe: —¿Ndequerẽhɨ vo Jerusalén ve ereso vaherã? Aheve co mbahe nde rembiapo rese aporandura ndeu —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ahe rumo omboyevɨ chupe: —Cũritei aico cohave romano mborerecuar guasu porandusa rovai. Aheve ité iyacatu che rembiapo rese porandusara cheu. Nde niha ereicua ndipoi eté mbahe tẽi ayapo judío amotarẽhɨsave —ehi—. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ayapose que mbahe naporai vahe, avɨyeño che yuca uca ãgua eve; ndayapoise rumo co judío omombehu vahe yuvɨreco ndeu, ndiyai che mondo ãgua evocoi ava povrɨve eve. Che rumo aso pota mborerecuar Cesar ɨvate catu vahe upe cheu mbahe rese porandu ãgua —ehi. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ahese Festo oñemoñeta opɨ̃tɨvɨisar oporomboaracua vahe rese, ipare omombehu Pablo upe: —Ereso pota Cesar upe. Avɨye, eresora evocoiyase —ehi chupe. ");
INSERT INTO gyrNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Evocoiyase movɨro arɨ pare, evocoi mborerecuar guasu Agri