﻿USE sofia;
DROP TABLE IF EXISTS sofia.gymNT_vpl;
CREATE TABLE gymNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gymNT_vpl WRITE;
INSERT INTO gymNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesukristo mräkä känekäne jrei Davikri amne Abrahamkri abko nere: ");
INSERT INTO gymNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham abko Isaac rün, Isaac abko Jacob rün, Jacob abko Judá rün amne Judá etbakantre mda mda rün arato, ");
INSERT INTO gymNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá abko Fares amne Zara rün amne, Fares btä Zara meye abko Tamar, Fares abko Esrom rün amne, Esrom abko Aram rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram abko Aminadab rün amne, Aminadab abko Naasón rün amne, Naasón abko Salmón rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón abko Booz rün, (Booz ne meye abko Rahab. Rahab ne abko ñakare israelita.) Booz abko Obed rün, (Obed meye abko ni ñakare israelitare kädian nämane Rut.) Obed abko Isaí rün amne, ");
INSERT INTO gymNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí abko jrei David rün. Jrei David abko Salomón rün. (Salomón ne meye abko nämane käne Uríabe.) ");
INSERT INTO gymNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón abko Roboam rün, Roboam abko Abías rün, Abías abko Asa rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa abko Josafat rün amne, Josafat abko Joram rün amne, Joram abko Uzías rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías abko Jotam rün amne, Jotam abko Acaz rün amne, Acaz abko Ezequías rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías abko Manasés rün amne, Manasés abko Amón rün amne, Amón abko Josías rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías abko Jeconías amne mräkä mda mda rün, (Jeconías näire abko nitre israelita jänikani ngite kä Babiloniate.) ");
INSERT INTO gymNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Abti nükaninta kä Israelite, yebti abko Jeconías abko Salatiel rün, Salatiel abko Zorobabel rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel abko Abiud rün amne, Abiud abko Eliaquim rün amne, Eliaquim abko Azor rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor abko Sadoc rün, Sadoc abko Aquim rün amne, Aquim abko Eliud rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud abko Eleazar rün amne, Eleazar abko Matán rün amne, Matán abko Jacob rün, ");
INSERT INTO gymNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob abko José rün. José ne mden abko ben María namani. María ne mden abko Jesu meye amne, Jesu ne mden abko ie nita Kristo niere. ");
INSERT INTO gymNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ne aisete Abraham näire nebebe jrei David näire nitre israelita ja mräkärebe namani ni jätäbti nibkä ja täritäri. Yebti David näire abti nitre israelita jänikani ngite kä Babiloniate, ye näire nitre israelita ja mräkärebe namani ni jätäbti nibkä ja täritäri arato. Abti nitre israelita jänikani ngite kä Babiloniate ye täbti nitre ja mräkärebe namani ni jätäbti nibkä ja täritäri nebe Kristo därebare ye näire. ");
INSERT INTO gymNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesukristo därebare abko nakaninkä krörö: Jesu ngämi därere, känenkri María, Jesu meye abko nämane mikani jakrä kwärikwäri Josébe. Akwa María ngämi nebe Josébe, ye känenkri María ñan namani mobe, bren kwe kisete Ngöbö Üai Deme köböire. ");
INSERT INTO gymNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Angwane José, ben María rabadre, José ye abko nämane nüne metre Ngöbö ngwärekri amne ñan tö namani María mikai ene ni jökrä ngwärekri, aisete María tuadremetre kwe kä bube tiebe abko namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ye erere José jatanina nuene, btäräbe angele ni Dänkienkwe jatani, käkwe niebare krörö köböre ie: José, jrei David mräkä, makwe ñan kä jürä ngwian jabtä María kare ngäbti ja nän mukore, ñobtä ñan angwane ngäbäkre rabadi kwe, ye abko namani btä Ngöbö Üai Deme di kri köböire. ");
INSERT INTO gymNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mdakäre abko, ngäbäkre däredi brare Maríakwe ye abko makwe kädian Jesu, ñobtä ñan angwane juta kwe ngite ngite kukwe kämekäme kisete, ye abko niarakwe dianditari, aisete makwe kädian kore. Abko kore se, niebare angelekwe Joséye. ");
INSERT INTO gymNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ni Dänkien abko käkwe blitabare kira niara kukwei niekä köböire, ye erere rabadre bare täte, abkokäre kukwe nakaninkä kore. Kukwe niebare ni Dänkienkwe abko tä tikani krörö niara Kukweibtä: ");
INSERT INTO gymNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Meri iti kaibe deme ñan rabadi mobe bren kwe kisete amne ngobo rabadi iti kwe. Ngäbäkre ye abko kädiandi Emanuel, abko niebare ni Dänkienkwe. (Emanuel abko “Ngöböta nibe” nieta.) ");
INSERT INTO gymNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yebti José nükaninta ngwäte angwane, angelekwe dre dre nuemna ie, ye erere nuenbare kwe, käkwe María kani ngäbti ja nän mukore. ");
INSERT INTO gymNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Akwa María ngobo ngämi därere kwe, ye känenkri namanintre ñakare jabe abti ngobo därebare kwe. Ngäbäkre ye abko Josékwe kädiani Jesu. ");
INSERT INTO gymNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesu därebare juta Belénte kä Judeate angwane, ni iti kädian nämane Herodes nämane jreire. Jesu därebare, abti nitre töbtä nünanka mobe kä Judeabtä kä driri nükani juta Jerusalén yete. Nitre ye abko nämane ja töitike mukebtä abko nükani, ");
INSERT INTO gymNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","käkwe kukwe ngwianintari krörö: ¿Jrei nitre israelitakwe därebare abko tä mdente? Muke kwati käkwe niara därebare mikaba gare, ye abko nunkwe tuaba nüke käin kä driri yete, aisete nun jatani mike ütiäte jae, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nitre töbtä ja töitikaka mukebtä käkwe kukwe niebare kore, ye gani jrei Herodekwe angwane, niara namani töbike kri. Erere arato, nitre nünanka juta Jerusalénte namani töbike kri arato. ");
INSERT INTO gymNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Abtä jrei ye käkwe nitre blitaka Ngöböbe ni mda mda diäre dänkientre käräbare amne Kukwe Biani Ngöbökwe Moiséye dirikätre käräbare kwe arato, bti kukwe ngwianintari krörö kwe ietre: ¿Ni Dianinkä Ngöbökwe abko däredre mdente metre? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Angwane niaratre käkwe niebare mda Herodeye: Jrei däredre juta Belénte kä Judeate abko gare nunye, ñobtä ñan angwane ni Ngöbö kukwei niekä käkwe tikani krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Belén, ma abko juta chi kä Judá känti nete. Akwa ma abko ütiäte kri, juta mda mda ngätäite kä Judá ye känti, ñobtä ñan angwane gobran kri däredi yete abko käkwe nitre israelita tikwetikwe ngibiadibti, abko tä tikani Ngöbö Kukweibtä, niebare kwetre Herodeye. ");
INSERT INTO gymNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yebti Herodekwe nitre töbtä ye käräbare tiebe, bti muke tuani ñongwane metre kwetre abko ngwianintari kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Angwane Herodekwe niebare ietre: Mun nän Belén sete amne ngäbäkre ye tä mdente abko munkwe ngwiantari kuin jökrä. Abti kwan munye angwane, tä mdente abko mun jatata niere tie, ti rikadre mike ütiäte siba abkokäre, niebare kwe ietre. Bti juani kwe Belén. ");
INSERT INTO gymNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jrei Herodes käkwe blitabare ünän kore, yebti nitre töbtä ye nikani ta; nikanintre ta angwane muke tuani nüke käin kä driri kwetre, ye ara nikaninta niaratre jie ngwenante abti batibe ngäbäkre nämane, ye känti muke ye namani nünaninkä käin. ");
INSERT INTO gymNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nitre töbtä käkwe muke tuani kore angwane, kä namani nuäre kri btätre. ");
INSERT INTO gymNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nikanintre gwä angwane, ngäbäkre ye nämane gwi meye Maríabe, btä okwä namani. Angwane namani ngukudokwäbti temen, käkwe ngäbäkre ye mikani ütiäte jae. Yebti kaja ngwian nämane kwetre, ye jue tikani kwetre, bti oro amne kri ngwäri ütiäte kri rä bäne bäne kädianta incienso amne mirra biani ngwarbe kwetre ngäbäkre yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yebti jatanintre nikenta angwane, ñan rikadreta Herodes känti ta abko Ngöbökwe mikani gare köböre ietre, aisete nikaninta ji mdabti nebeta ja käite. ");
INSERT INTO gymNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Abti nitre töbtä ye nikaninante angwane, angele ni Dänkienkwe nükani blite köböre Josébe, käkwe niebare ie: Näin krö amne ngäbäkre ye btä meye kwe, ye ben nän ngitie jötrö Egipto sete. Ye känti mun raba nüne abti tikwe kukwe mda niedi mae abko makwe ngibia, ñobtä ñan angwane Herodes bike ngäbäkre ye känentari kämikadre. Abko kore se, niebare angelekwe Joséye. ");
INSERT INTO gymNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ye btäräbe José nükani dikekä krö, nikani jibti Egipto kukwäre ngitie ngäbäkre yebe amne ngäbäkre ye meyebe kä ikote deo. ");
INSERT INTO gymNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ye känti namanintre nünentbe abti Herodes krütani. Kukwe nakaninkä kore, angwane kukwe niebare krörö ni Dänkienkwe niara kukwei niekä köböire ye namani bare: Ti Odei nämane Egipto, tikwe käräbareta mento, abko niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nitre töbtä abko käkwe Herodes ngökani, ye gani Herodekwe angwane, Herodes mätä namani kri krübäte, aisete ñongwane nitre töbtä käkwe muke tuani abko niebare kwetre Herodeye, yebtä Herodekwe töbikabare, käkwe ngäbäkre kiakia därebe nebebe kä kubu ie nämane nüne Belén amne Belén kenta temen abko Herodekwe kämikamna jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herodekwe ngäbäkre kiakia kämikamna jökrä kore, ye köböire abko ni Ngöbö kukwei niekä kädian nämane Jeremías käkwe Ngöbö kukwei tikani abko namani bare krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ni kukwei ruen ngetrekä krikri krübäte juta Ramate, ye abko Raquel ngäbriänkä kiakia kämikani jökrä kän, mden abko tä müaire ye. Niara moto mika tö nebeta jäme, akwa ngäbriänkä kämikani jökrä kän, aisete moto ñan rabadreta jäme, abko tikani kore, mden erere namani bare. ");
INSERT INTO gymNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Abti Herodes krütani angwane, angele ni Dänkienkwe nükani bliteta köböre Josébe Egipto, ");
INSERT INTO gymNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","käkwe niebare ie: Näin krö amne ngäbäkre ye btä meye kwe ye ben nänta kä Israelite, ñobtä ñan angwane nitre tö namani ngäbäkre ye kämikai abko krütanina jökrä, aisete mun rikata, niebare angelekwe Joséye. ");
INSERT INTO gymNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ye btäräbe José nükani dikekä krö, bti nikani jibti ngäbäkre yebe amne ngäbäkre ye meyebe nebeta kä Israelite. ");
INSERT INTO gymNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","José nikaninta kore, nikani, nikani, nikani akwa ni iti kädian nämane Arquelao nämane gobrane mda rün mrö Herodes täte, ye gani kwe angwane, kä jürä namani kri btä. Abtä ñan nikani nebe kä Judeate. Angwane niara ñan rabadre nüne yete abko Ngöbökwe mikani gare köböre ie, abtä käkä Galilea, känti nikani jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Namani Galilea angwane, nikani nüne juta Nazarete. Jesu abko nazarebo niedre btä abko nitre Ngöbö kukwei niekä köböire Ngöbökwe kukwe niebare, ye erere namani bare jökrä kore. ");
INSERT INTO gymNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Abti kä nikanina raire ta angwane, batibe ni iti kädian nämane Juan Bautista jatani dirire kä kaibete kä Judea känti. ");
INSERT INTO gymNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Juan nikani dirire krörö: Ngöbö kä käinbti kebera nüke gobrane ni ngätäite, aisete kukwe kämekäme kite temen, bti ja töi kwiteta Ngöbö kukwäre abko nikani niere kore. ");
INSERT INTO gymNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan ne mden abko btä Ngöbökwe kukwe niebare kira niara kukwei niekä Isaías köböire abko krörö: Ni iti näin ñäke jume ja dibti kä kaibete, käkwe niedi krörö: Ji ükateta kuin biare jrei känenkri, ye kwrere ja töi mike kuin biare ni Dänkien käne munkwe. Ji ükateta niken metre ta, ye kwrere ja töi ükete metre ni Dänkien käne munkwe abko näin niere, abko Ngöbökwe niebare kore Juanbtä Isaías köböire. ");
INSERT INTO gymNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan abko nämane kameo drüen dikani dänre kite jabtä amne nämane mäkete nbikwatabti jae amne mrö kweta nämane kwe abko tröda btä munkö känsenta. ");
INSERT INTO gymNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juan nämane dirire kore angwane, ni kwati nünanka juta Jerusalén amne kä Judeate btä ni kwati nünanka känimekänime Ñö Jordán bäre temen abko nükani jökrä niara kukwei nuen. ");
INSERT INTO gymNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Angwane nitre ye abko namani ja ngite niere Ngöböye angwane, Juan namani ngökö Ñö Jordánte. ");
INSERT INTO gymNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Akwa Juan nämane nitre ngökö ñöte, ye känti nitre bariseo amne nitre saduseo nükani kwati siba abko btä Juan okwä namani angwane, Juankwe niebare krörö ietre: ¡Mun abko tbi krübäte kwrere! ¿Ngöbö kebera mun mike ja ngie nuen kri krübäte, yebtä nirekwe mun mikani mokre amarebti mun kite nüke siba nete ye? ");
INSERT INTO gymNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Munkwe ja töi kwitadreta era metre Ngöbö kukwäre bkänä tödekakäre bti abko erere munkwe nüna ni mda mda okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Erere arato, munkwe ñan töbika krörö jabtä: Nun abko Abraham mräkä, aisete Ngöbökwe ñan nun mikadi ja ngie nuen, munkwe ñan nütü, ñobtä ñan angwane jä tuen temen sete, se abko ngwarbe, akwa Ngöbö raba kwite Abraham mräkäre arato abko ti tö nibi niei metre kore munye. ");
INSERT INTO gymNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mdakäre abko, kri mden mden ñan ngwä nebe kuin, ye abko kräke ü mikanina biare tikakakrä ngätrite ta. Abti tikakata jökrä angwane, ñukwä mikata btä, ye kwrere jire Ngöbökwe mun mikadi ja ngie nuen, munkwe ñan ja töi kwitadre Ngöbö kukwäre angwane. ");
INSERT INTO gymNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nire nire käta ja töi kwiteta Ngöbö kukwäre, käta kukwe kämekäme kite temen, ye abko tita ngökö ñö aibe te, akwa ni jatadi iti ti jiebti abko bäri di kri ti ngwä, aisete ti abko ja ñan rükadre töre jire chi tie sandalia ngwena kräke. Ni ye abko käkwe Ngöbö Üai Deme mikadi nüne munbtä amne mun mikadi deme kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ne abko, niarakwe dre nuendi abko ti bike niere munye abko krörö: Nura kädianta trigo juankata mürete amne trigo kwä kuinkuin aibe ükakröta jenena, bti ükata gwi. Kwata abko kukwata ñukwä jutrate, ye kwrere ni ye abko tä juto biare ni Ngöbökwe erere ükakrökä jökrä nünakäre jabe amne tä juto biare ni kukwe kämekäme nuenkä abko erere kitakäre ñukwä jutra nötöte ñakare te ja tare nikakäre kärekäre. Munkwe ñan ja töi kwitadre Ngöbö kukwäre ne ngwane, kukwe rakadikä kore munbtä arato. Abko kore se, niebare Juankwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kä ye ngwane abko, Jesu nämane Galilea, nikani nebe Juan känti Ñö Jordánte mda, Juankwe ngökadre ñöte abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Akwa namanina yete angwane, Juan ñan tö namani ngökai ñöte, käkwe niebare ie: Ma bäri ütiäte ti ngwä, aisete makwe ti ngökadre ñöte bä amarebti ma kite ja mike ngökadre ñöte tie se, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Angwane Jesukwe niebare mda ie: Jändrän mden mden tuen kuin Ngöböye, yebtä abko nikwe Ngöbö Kukwei mikadre täte, aisete makwe ti ngökadre ñöte, niebare kwe Juanye. Ye erere nükaninbti Juanye angwane, Jesu ngökani ñöte kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesu ngökani ñöte, jataninta ñöte käin angwane, kä käin se namani tuen ñäkänintbe ie angwane, Ngöbö Üai jatani ütü bä kwrere timonkwäre, nükani mate Jesubti, namani tuen ie. ");
INSERT INTO gymNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ye btäräbe ni kukwei jarabare kä käinbti, käkwe niebare: Ni ne abra ti Ngobo tikwe. Niara tare kri tikwe. Niara käi nuäre kri tibtä, niebare kore kä käinbti. ");
INSERT INTO gymNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yebti diablukwe Jesu nuadrete ja käne, abkokäre Ngöbö Üai nikani ngwena kä kaibete mda. ");
INSERT INTO gymNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ye känti köbö gre ketebu dibire rare Jesukwe mröbare ñakare amne mrö jatani krübäte ie. ");
INSERT INTO gymNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Angwane diablu jatani nüke Jesu ken, Jesu nuatekäre ja käne, käkwe niebare ie: Ma abko Ngöbö Odei era metre bkänä ne ngwane, jä se kwite mröre jae, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Akwa Jesu käkwe niebare mda diabluye: Ñakare. Ngöbö Kukwei tä tikani krörö: Ñan mrö aibebti ni rabadre nüne, akwa kukwe kwatirekwatire niebare Ngöbökwe, yebti ni rabadre nüne, abko tä tikani Ngöbö Kukweibtä, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yebti diablu nikani Jesu ngwena juta deme Jerusalén mda, känti nikani Jesu ngwena mobe ju blitakrä Ngöböbe bti käin, ");
INSERT INTO gymNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","käkwe niebare ie: Ma abko Ngöbö Odei era metre bkänä ne ngwane, ja täkete timon nete, ñobtä ñan angwane Ngöbö Kukwei tä tikani krörö mabtä: Ngöbökwe angeletre juandi ma ngibiare abko käkwe ma kadi ngäbti kisete, ma ngoto ñan matadre jäte temen abkokäre, aisete ja täkete timon, ma abko Ngöbö Odei ara mikakäre gare ni jökräye, niebare diablukwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Abtä Jesukwe niebare mda ie: Ñakare. Ngöbö Kukwei tä tikani abko käta niere krörö arato: Ni Dänkien Ngöbö käkwe ja kukwei mikadre täte ya, ñakare ya amne niara di tärä ja kukwei ngwiandre bare ya, ñakare ya abko makwe ñan nuate ja käne ja gakäre ben, abko tä tikani kore, aisete tikwe ñan ma kukwei mikai täte, niebare kwe diabluye. ");
INSERT INTO gymNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yebti mrä, ngitio bäri mente käin, yebti diablu nikani Jesu ngwena mda. Ye känti abko diablukwe juta kä jökräbti temen mikani tuadre Jesuye amne, jändrän ütiäte krikri juta kwatirekwatire te, ye abko mikani tuadre jökrä kwe arato ie. ");
INSERT INTO gymNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Bti niebare kwe ie: Ma rabadi ngukudokwäbti temen ti ngwärekri käkwe ti mikadi ütiäte jae ne ngwane, tikwe juta se btä jändrän ütiäte krikri se biandi jökrä mae, niebare mda kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Abtä Jesukwe niebare ie: Satana, nän mento nete, ñobtä ñan angwane Ngöbö Kukwei tä tikani abko käta niere krörö: Ni Dänkien Ngöbö aibe mikadre ütiäte jae amne niara aibe kräke sribidre, abko nieta kore, aisete tikwe ñan ma kukwei mika täte, niebare mda kwe diabluye. ");
INSERT INTO gymNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Angwane diablukwe kä mikaninkä Jesubtä, bti angele nükani ruäre abko namani Jesu die mike. ");
INSERT INTO gymNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yebti Juan Bautista kitani ngite kä teri gani Jesukwe angwane, Jesu nikaninta Galilea, ");
INSERT INTO gymNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","akwa ñan namani nüne mda juta Nazarete, akwa nikani nüne juta Capernaúmte Ñö Okwä Kri Galilea köräbti. Ñö Okwä Kri Galilea, ye bäre temen abko Zabulón btä Neftalí mräkätre käkwe nünabare kira, känti juta Capernaúm nämane Jesu näire abko te Jesu nikani nüne. ");
INSERT INTO gymNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kukwe niebare Ngöbökwe niara kukwei niekä Isaías köböire rabadre bare, abkokäre Jesu nikani nüne yete. Kukwe ye abko tä tikani krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Kä Zabulónkwe amne kä Neftalíkwe abko tä Ñö Jordán kwärä nakriri amne tä Ñö Okwä Kri köräbäre. Kä ye abko tä kä Galileate arato, känti nitre ñakare israelitare tätre nüne. ");
INSERT INTO gymNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nitre israelita ye abko nämane näin kä ikote, akwa ñotra trä kri dirare jatabare ietre. Erere arato, niaratre nämane nüne kä ikote mento Ngöböye angwane, Ngöbö trä ngitianinkä ngwen kräke, kukwe metre Ngöbökwe mikakäre gare ietre, abko tä tikani Ngöbö Kukweibtä abko erere namani bare. ");
INSERT INTO gymNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kä ye ngwane mentokwäre Jesu nikani dirire, kä nikani niere krörö: Ngöbö kä käinbti kebera nüke gobrane nibti, aisete munkwe kukwe kämekäme kita temen, bti ja töi kwiteta Ngöbö kukwäre munkwe abko Jesu nikani niere kore. ");
INSERT INTO gymNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Abti bati Jesu nämane dikekä Ñö Okwä Kri Galilea köräbäre angwane, ni ja etbare nämane nibu ñö köräbti, btä okwä namani. Ni ye abko iti kädian nämane Simón, akwa kädian nämane Pedro arato amne, etba kwe kädian nämane Andrés. Niaratre abko gwa gaka, aisete nämane krade kite ñöte, btä Jesu okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Angwane Jesu nikani känti, käkwe niebare ietre: Mun brän tibe amne munta gwa gaen ño, ye kwrere tikwe mun mikadi ni ngwianka Ngöböye, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ye btäräbe, niaratre käkwe krade kitani temen, bti nikani Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yebti Jesu nikani mda mentokwäre se kwrere angwane, ni ja etbare nämane nibu mda, btä okwä namani. Nitre ye abko iti kädian nämane Santiago amne etba kwe abko kädian nämane Juan. Niaratre nibu abko Zebedeo ngäbriänkä. Nitre nibu ye abko nämane rute rünbe krade gudike, btä Jesu okwä namani angwane, Jesukwe käräbare ja töitike jabe arato. ");
INSERT INTO gymNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ye btäräbe niaratre käkwe ru amne rün mikaninte yete, bti nikani Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Abti Jesu nikani dikekä kä jökräbti temen kä Galileate angwane, Ngöbö kä käinbti kebera gobrane nibti abko nikani dirire sinagogate kä ketareketare te. Erere arato, ni bren bätäkä ngwarbe abko Jesu namani miketa kuinta. ");
INSERT INTO gymNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yebtä abko blita namani jökrä kä Siriate angwane, ni bren ño ño erere jänamani kite jökrä Jesuye. Erere arato, ni bren üai käme kisete jänamani nüke Jesuye amne kä nötöte nibti amne ni ruen ñakare ngrabare jänamani nüke jökrä Jesuye angwane, Jesu namani miketa kuinta jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Yebtä abko, ni kwati nünanka kä Galileate juta ketareketare te Decápolite amne nitre Jerusalénbo btä ni nünanka kä Judeate amne ni nünanka Ñö Jordánbtä kä driri abko namani dikekä kwati Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nitre namani dikekä kwati dikaro Jesube namani tuen ie angwane, nikani mintokwäre nebe ngitiobtä, känti namani täkänintbe temen. Angwane nitre ja töitikaka ben käkwe krötabare ken. ");
INSERT INTO gymNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Angwane Jesu nikani dirire krörö ietre: ");
INSERT INTO gymNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nire nire käta ja mike bobre Ngöböbtä, ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane Ngöbö kä käinbti tä gobrane bti. ");
INSERT INTO gymNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nire nire tätre ja müaire, ni ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane Ngöbökwe moto mikadita jäme. ");
INSERT INTO gymNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nire nire ñan tä bike kri ni mda mda okwäbti abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane Ngöbökwe kä temen ne biandi ie. ");
INSERT INTO gymNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mröta nebe krübäte nie amne tomna tä nebe krübäte nie, ye kwrere nire nire abko ie nüna metre Ngöbö ngwärekri ye mdei krübäte ie, ni ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane Ngöbökwe mikadi nüne metre täte jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nire nire abko ie ni mda mda tä nebe ruentari tare, ni ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane niara rabadi ruentari tare Ngöböye arato. ");
INSERT INTO gymNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nire nire käta ja töi ngibiare kuin deme, ni ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane niaratre käkwe Ngöbö tuadi. ");
INSERT INTO gymNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nire nire käta sribire ni mda mda mikakäre ja mäketa, ni ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane niaratre abko ja ngäbriänkä niedi Ngöbökwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nire nire käta nüne metre Ngöbökrä abtä tä ja tare nike, ni ye abko Ngöbökwe die mikadi amne kä rabadi nuäre btä, ñobtä ñan angwane Ngöbö kä käinbti tä gobrane bti. ");
INSERT INTO gymNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Amne ni mdakwe ñäkä taretare munye amne mun mika ja tare nike amne tödekabtä tibti ni mda mdakwe kukwe käme nie ngwarbe bätäkä ngwarbe mun rüere, ye ngwane Ngöbökwe mun die mikadi amne kä rabadi nuäre munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mun raba ja tare nike kore angwane, munkwe kä ngwian bäri nuäre jabtä amne kä raba juto munbtä, ñobtä ñan angwane munkwe ja tare nikadi ye ütiäre abko Ngöbökwe jändrän kuin biandi munye kä käinbti sete. Munkwe kä ngwiandre nuäre kore jabtä arato, ñobtä ñan angwane nitre Ngöbö kukwei niekä kira abko rüe käkwe mikani ja tare nike kore arato. ");
INSERT INTO gymNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Mdakäre abko, mren abko kuin ngri ngibiakrä amne jändrän mikakrä bänänte, ye kwrere mun abko mren kwrere kä nebtä, akwa bänän riadrekä rabadre tibo amne ñan bänän rabadreta mren kwrere. Mren bänän rabadre tibo, ye abko rikadre ngwarbe, aisete ñan rabadre kuin mda, aisete kitadrekä amne ni jökrä rabadre dikekä bti ta. Ne aisete mren bänän kuin ye kwrere munkwe ja ngibia, ni mda mda rabadre Ngöbö tuen munbtä abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mdakäre abko, ñotra träte käta nebe tuen nie kä ikote, ye kwrere munta ñotra trä kwrere kä nebtä amne juta mikata ngitio kribti käin, ye abko ñan raba ja rükente ni okwä bäre kä ikote, ye kwrere munta kä nebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Erere arato, ñotra jutra mikata angwane, mikata ñakare kaja täni, akwa mikata mobe üräbtä käin trä rabadre ngitie jökrä gwita temen, ni jökrä gwi, ie kä rabadre tuen abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ye kwrere arato, munta nüne Ngöbö träte, ye rabadre tuen ni mda mdaye, abkokäre munkwe ja töi mika nüne era metre Ngöbökrä mun rabadre ñotra trä ye kwrere ni mda mda okwäbti amne, munkwe jändrän kuinkuin nuendre kore ni mda mda okwäbti, ye köböire abko jatadi mun Rün kä käinbti ye käikitekä siba. ");
INSERT INTO gymNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mdakäre abko, ti jatani nete, ye abko ñan Kukwe Biani Ngöbökwe Moiséye mikakäre ngwarbe. Erere arato, Ngöbö kukwei niekä mda mda käkwe Ngöbö Kukwei tikani ye abko ti ñan jatani mikakäre ngwarbe, akwa ti jatani kukwe ye mikakäre bare täte jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ye abko, ti bike kukwe era erere niere krörö munye: Kä käinta amne kä temen ne tädi kore angwane, tärä okwä bäri kiakia tä tikani Ngöbö Kukweibtä, ye abko ñan diandrekä jire chi kwati abti jändrän jökrä mikanintbe Ngöbökwe rabadi bare täte jökrä ie. ");
INSERT INTO gymNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ne aisete, kukwe biani nuendre Ngöbökwe nie, yebtä kukwe bäri chi tä tikani abko nire nire ñan tä mike täte amne ni mda mda käkwe ñan mikadre täte abko dirita ietre arato, ne ngwane ni ye abko rabadi bäsi ütiäte ñakare kä käinbti, Ngöböta gobrane ye känti; akwa nire nire tä kukwe ye mike täte amne ni mda mdakwe mikadre täte arato abko tä dirire ietre, ni ye abko rabadi ütiäte kri kä käinbti sete, Ngöböta gobrane ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tita niere kore, ñobtä ñan angwane Kukwe Biani Ngöbökwe Moiséye dirikätre btä nitre bariseo tätre nüne ño, yebti ta munkwe ñan nünandre bäri era metre Ngöbö okwäbti ne ngwane, Ngöbö kä käinbti tä gobrane ye känti mun ñan rabadi nüne. ");
INSERT INTO gymNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mdakäre abko, mun mräkä kirakira abko ie Ngöbö Kukwei diribare krörö abko munkwe kukwei nuanina: Makwe ñan ni mda kämika, niebare ietre amne nire nire käta ni mda kämike abko dokwäre mikadre ja ngie nuen. ");
INSERT INTO gymNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Akwa ti abko käta niere krörö munye: Nire nire rabadre romon mräkäkrä, ye dokwäre Ngöbökwe mikadi ja ngie nuen. Nire nire abko käkwe “Ma ngwarbe, dokwä töi ñakare,” niedre kwe mräkäye, ye dokwäre abko järikadre ngite Sanedrin ngwärekri kukwe ükatekäre kräke. Amne nire nire käkwe niedre mräkäye: “Ma ngututu käme ngwarbe,” niedre kwe, ni ye abko rabadi mikani biare kitadre Ngöbökwe ñukwä jutrate kä ja tare nikakrä ye känti mräkä ye dokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ne aisete, ma rika jändrän ngwena kukwadre Ngöböye ñukwä gräbti ja ngite ütiäre ju blitakrä Ngöböbe känti ne ngwane, ma rabara yete, ye btäräbe ma mräkä iti romon makrä, ye rükata töre mae, ");
INSERT INTO gymNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ne ngwane jändrän ye makwe mikate ñukwä grä ken yete, abti ma jana ja mäketa käne ma mräkäbe, bti ma jatata, käkwe jändrän ye bian kukwadre Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mdakäre abko, nane rürümon ütiä mabti ni mdakwe abtä ni ye jata niken ma kite ngise kritoboye angwane, mun ngämi nebe kritobo känti, känenkri makwe kukwe ükate ben, niara ñan rikadre ma ngwena kritobo känti abkokäre, ñobtä ñan angwane makwe ñan nuendre kore ne ngwane, nane ni ye rikadre ma ngwena nebe kritobo ngwärekri amne kritobo abko käkwe ma kitadre ngise guardiaye amne nane guardiakwe ma kitadre ngite kä teri. ");
INSERT INTO gymNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ye känti abko makwe ñan ngwian biandre täte jökrä ja ütiäre, känenkri ma ñan tikadreteta jire chi abko ti tö nibi niei metre munye. ");
INSERT INTO gymNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mdakäre abko, Ngöbö Kukwei tä tikani abko mun tärä kukwei nuen abko krörö: Mata gure, makwe ñan ja mika gure bati bati abko niebare kore. ");
INSERT INTO gymNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Akwa ti abko bike niere krörö munye: Nire nire käkwe meri tuadre ja käne amne tö rabadre ie jakrä, ni ye käkwe meri ye mirira ja ken ja töite, aisete ngite Ngöböye abko tita niere munye. ");
INSERT INTO gymNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ne aisete, ma okwä küde ruenkri, köböite makwe ja mika ngite Ngöbö rüere ne ngwane, ma okwä ye makwe dianka mento jae, bti makwe kitaka mobe, ñobtä ñan angwane ma ngrabare chi ye abko diandrekä mento ye abko rabadre bäri kuin makrä amne ñan ma ngrabare rikadre ngöi jökrä kä ja tare nikakrä känti. ");
INSERT INTO gymNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Erere arato, ma kise ruenkri, köböite makwe ja mika ngite Ngöbö rüere ne ngwane, makwe ja kise ye tikaka ta, bti makwe kitaka mobe mentokwäre, ñobtä ñan angwane ma ngrabare chi diandrekä mento ye abko rabadre bäri kuin makrä amne ñan ma ngrabare rikadre ngöi jökrä kä ja tare nikakrä känti. ");
INSERT INTO gymNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mdakäre abko, kukwe diribare krörö Ngöbö Kukweibtä abko garera munye: Nire nire tö rabadre meri kwe tuaimetre, ye ngwane täräkwata biandre kwe merire kweye, niarata merire kwe ye tuemetre era metre abko mikakrä gare. ");
INSERT INTO gymNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Akwa ti abko käta niere krörö: Meri ja mike ngite ñakare brare mda mdabe, akwa brare kwe käkwe tuadremetre, ye ngwane merire ye käkwe ja mikadre gure brare mdabe angwane, ni gure käta ja mike ngite bati bati ni mda mdabe, ye kwrere brare käne köböite meri ye rabadre ja mike ngite. Erere arato, meri tuanimetre brarekwe, ye ben ni mdakwe ja mikadre gure ne ngwane, ni gure käta ja mike ngite bati bati ni mda mdabe, ye kwrere ja mikadi ngite kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mdakäre abko, kukwe niebare mun mräkä kirakiraye abko munkwe kukwei nuanina arato abko krörö: Jändrän jökrä rabadre bare täte mae mata niere ni Dänkien käbti, ye erere makwe ja kukwei mika täte jökrä, käkwe ñan ja kukwei kitadre temen, niebare kira. ");
INSERT INTO gymNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Akwa ti abko käta niere krörö munye: Munkwe ñan ja kukwei bian jändrän käbti. Erere arato, kä käinta se käbti tita ja kukwei bien, munkwe ñan nie, ñobtä ñan angwane Ngöbö abko tä gobrane kä käinbti yete, aisete bäri ütiäte. ");
INSERT INTO gymNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Erere arato, kä temen ne käbti tita ja kukwei bien, munkwe ñan nie, ñobtä ñan angwane kä temen ne abko Ngöbökwe arato. Erere arato, Jerusalén se käbti tita ja kukwei bien, munkwe ñan nie, ñobtä ñan angwane juta Jerusalén abko juta Jrei kri Ngöbökwe kräke, aisete bäri ütiäte arato. ");
INSERT INTO gymNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mdakäre abko, mun dokwä jen munkwe ye käbti, munta ja kukwei bien, munkwe ñan nie, ñobtä ñan angwane mun di ñakare jire ja dokwä drüen mikakäre krati ngwen amne drüne. ");
INSERT INTO gymNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ne aisete, munkwe “jän” nie ne ngwane, munkwe “jän” nie kwatibe; munkwe “ñakare” nie ne ngwane munkwe “ñakare” nie kwatibe arato. Yebti munkwe kukwe mda niedre ne ngwane, munkwe ja mikadre ngite. ");
INSERT INTO gymNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ngöbö Kukwei tä tikani abko mun tärä kukwe nuen abko krörö: Ni iti käkwe ni okwä diandrete ne ngwane, niara okwä diandrete ie ja dokwäre arato. Erere arato, ni tu diandrekä kwe ne ngwane, tu diandrekä ie ja dokwäre arato abko munkwe kukwe nuani. ");
INSERT INTO gymNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Akwa ti abko käta niere krörö munye: Nane ni mdakwe kukwe nuen blo ma rüere, akwa makwe ñan ja ngie mika amne jirekäbe makwe jändrän kuin nuen krörö kräke: nane ni mdakwe ma meta ngwäre küde ruenkri yebtä ma mikakäre ngwarbe jae, ne ngwane makwe ja ngwäre kwäräkri mika ie. ");
INSERT INTO gymNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Erere arato, nane ni mdakwe ma kita ngise, bti tö raba dän denkä ötati makän ne ngwane, dän mdara jire makwe, ye makwe bian ie arato. ");
INSERT INTO gymNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mdakäre abko, nane ni mdakwe tribe ngwiamna milla krati jakrä mae ne ngwane, ja moto kuinbti ma rika tribe ngwena milla krobu kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Erere arato, nane ni mdakwe jändrän makwe kärä mae angwane, makwe bian ie. Nane ni mdakwe jändrän kärä ütiädre mae ne ngwane, makwe bian ie abko ti tö niei kore munye. ");
INSERT INTO gymNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mdakäre abko, Ngöbö Kukwei tä tikani abko mun tärä kukwe nuen abko krörö: Makwe ma mräkä tare amne ma rüe abkobtä makwe bätä ngwian abko munkwe kukwe nuanina kore. ");
INSERT INTO gymNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Akwa ti abko bike niere krörö munye: Munkwe mun rüe tare amne nire nire tä näin kisere mun jiebti mun mikakäre ja tare nike, ye abko kräke munkwe blita Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Munkwe nuendre kore ne ngwane, mun Rün tä kä käinbti sete, ye kwrere mun rabadi amne mun rabadi niara ngäbriänkäre era metre arato. Munkwe nuendre kore, ñobtä ñan angwane mun Rün kä käinbti tä ñänä mike nüke käin ye abko tä trä ngitiekä jökrä ni käme kräke amne ni kuin kräke. Erere arato, tä ñü mike näkäen temen, ye abko ni nünanka metre niara ngwärekri kräke tä näkäen amne ni nünanka käme niara rüere kräke tä näkäen arato. Mun Rün abko käta ni jökrä tarere kore, ye kwrere munkwe nuendre arato, ");
INSERT INTO gymNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ñobtä ñan angwane ¿nire nire käta mun tarere ye aibe munkwe taredre angwane, Ngöbökwe ütiä biandi munye, munta nütüre ya? Ñakare, ñobtä ñan angwane nitre ngwian käräkä gobran romanobokrä abko tä nebe tuen käme dikaro munye, ye abko tä nuene kore abko kwrere munkwe nuendre siba. ");
INSERT INTO gymNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","¿Erere arato, mun mräkä aibe ie munkwe köbö ngwiandretari, ye angwane munta jändrän nuene bäri kuin ni mdakrä ya? Ñakare, ñobtä ñan angwane nitre ñakare israelitare abko tuen ngututure munye abko käta nuene kore, ye kwrere munkwe nuendre siba. ");
INSERT INTO gymNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ne aisete mun Rün kä käinbti abko kuin era metre, ye kwrere munkwe nüna. ");
INSERT INTO gymNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mdakäre abko, munkwe ñan jändrän kuinkuin nuen tuadre ni jökräye ja bä mikakäre kuin ni mda mda okwäbti, ñobtä ñan angwane munkwe nuendre kore ne ngwane, mun Rün tä kä käinbti ye käkwe ñan sribi ye ütiä biandre jire chi munye. ");
INSERT INTO gymNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ne aisete munkwe jändrän bian ni bobre die mikakrä angwane, ñan mun rika niere kä jökräbti temen kwäräkwärä mikakäre gare. Nitre ja bä mikaka kuin käta jändrän bien kore amne tätre niken mike gare sinagogate amne tätre niken ji ngrabare temen mike gare. Yebtä abko ni mda mda käkwe niaratre käikitadrekä abkokäre tätre nuene, aisete tätre jändrän kuin nuene kore, ye abko ütiä nena kwetre abko tita niere metre, aisete munkwe ñan jändrän nuen niaratre kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne aisete nane munkwe ni bobre die mika angwane, makwe ñan nie jire chi ma kukwe muko bäri kuinye, ");
INSERT INTO gymNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","akwa makwe nuen kaibe kä bube. Makwe nuendre kore ne ngwane, ma Rün, ie jändrän kaibe tiebe tuen, ye käkwe sribi makwe ye ütiä biandi mae. ");
INSERT INTO gymNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Mdakäre abko, mun rika blite Ngöböbe angwane, nitre ja bä mikaka metre tä niken blite krikri Ngöböbe sinagogate. Erere arato, tätre nebe nünaninkä jibtä blitare Ngöböbe. Ye abko, ni jökrä käkwe tuadre blite Ngöböbe, ie töta nebe, käta nuene kore. Ye kwrere munkwe ñan nuen, ñobtä ñan angwane tätre nuene kore ye abko ütiä nena kwetre abko tita niere metre munye. ");
INSERT INTO gymNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne aisete, ma rika blite Ngöböbe angwane, makwe ja ketaka kaibe kä teri gwi, käkwe jukwe dika jabti, bti ma Rün Ngöbö tuen ñakare mae, ben makwe blita kaibe angwane, ma Rün ie jändrän nuenta kaibe makwe abko tuen, käkwe ütiä biandi mae. ");
INSERT INTO gymNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Erere arato, mun rika blite Ngöböbe angwane, nitre ñakare israelitare tä kukwe arabe niere bäre bäre, yebtä abko ngöbötre ngwarbe käkwe kukwe nuadre amne die mikadre kwetre tä nebe nütüre, aisete tätre blite kore, ye kwrere munkwe ñan blita Ngöböbe amne munkwe ñan kukwe arabe nie bäre bäre ngwarbe. ");
INSERT INTO gymNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Munkwe ñan ja mika niaratre kwrere, ñobtä ñan angwane munta dre dre mdei nike, ye mun ngämi kärere mun Rünye, ye känenkri tärä nebe gare ie. ");
INSERT INTO gymNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ne aisete, munkwe blitadre Ngöböbe angwane, munkwe blitadre krörö ben: Nun Rün kä käinbti, ma aibe kä raba mikani ütiäte ni jökräkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jakwe gobrane nun ngätäite nete. Erere arato, ma töta nebe dre dre nuein kä käinbti, erere tä nebe bare täte jökrä, ye kwrere raba nebe bare täte jökrä kä nebtä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mdakäre abko, makwe mrö bian täte nünankrä nunye mtare. ");
INSERT INTO gymNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Amne ni mdata ja mike ngite nun rüere abko nunta den bti ta, ye kwrere makwe nun ngite ma rüere, ye dianka mento nunbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Amne kukwe kämekäme tö nun nuaite ja käne ma rüere, ye känti makwe ñan nun jie ngwian. Akwa makwe nun ngibia nun rüe diablu ngäniene, ñobtä ñan angwane ma aibe tä gobrane amne ma aibe di kri amne ma aibe raba käikitaninkä kärekäre. Abko kore se. Amen. ");
INSERT INTO gymNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Munkwe blitadre kore Ngöböbe, ñobtä ñan angwane ni mda tä ja mike ngite mun rüere angwane, munta den jökrä bti ta ne ngwane, munta ja mike ngite Ngöbö mun Rün rüere, ye mun Rün kä käinbti käkwe diandikä jökrä mento munbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Akwa ni mda tä ja mike ngite mun rüere abko munkwe ñan diandre bti ta amne mun rabadre romon janknu kräke ne ngwane, mun ngite Ngöbö rüere, ye mun Rün kä käinbti käkwe ñan diandrekä mento munbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Mdakäre abko, munkwe ja bäin Ngöbökrä angwane, munkwe ñan ja bä mika diäne nitre ja bä mikaka metre käta nuene ye kwrere, ñobtä ñan angwane nitre bikaka metre, ye tätre ja bäine angwane, ni jökrä käkwe gadre, abkokäre tätre nebe ja bä mike diäne tuadre ni mda mdaye, akwa tätre nuene kore ye abko ütiä nena kwetre abko tita niere metre munye. ");
INSERT INTO gymNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ne aisete makwe ja üka bäin Ngöbökrä angwane, makwe ja ngwäre bätäte amne makwe ja ükate kuin. ");
INSERT INTO gymNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Mata ja bäine ye ñan gadre mabtä ni mda mdakwe amne, ma Rün tuen ñakare mae aibe käkwe gadre kaibe, abkokäre makwe nuen kore. Ye ngwane abko ma Rün, ie jändrän kaibe tiebe tuen, ye abko käkwe ütiä biandi mae. ");
INSERT INTO gymNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mdakäre abko, munkwe ñan jändrän ütiäte kri ükakrö kabre jakrä kä nebtä, ñobtä ñan angwane kä u käta jändrän juen ngwarbe. Erere arato, jändrän tä niken ngwarbe amne gokä tä niken jändrän goire, aisete munkwe ñan jändrän ükakrö kabre jakrä kä nebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Akwa jändrän kuinkuin ütiäte krikri rabadre bäri kabre munkrä kä käinbti abko kräke munkwe sribi, ñobtä ñan angwane kä käinta kä u ñakare jändrän rüere, erere arato jändrän niken ngwarbe ñakare amne ni gokä ñakare arato, aisete munkwe sribi jändrän kä käinbti ye ükakrökäre kabre jakrä, ");
INSERT INTO gymNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ñobtä ñan angwane jändrän ütiäte krikri tädi ükani mdente jakrä munkwe, ye känti mun töi tädi arato. ");
INSERT INTO gymNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mun okwä abko ñotra kwrere munkrä. Ne aisete ma okwä kuin dirare ne ngwane kä trä kuin tä tuen mae, ye kwrere abko ma töita mikani kwatibe Ngöböbti ne ngwane, Ngöbö trä kuin tä nüke gare kuin mae. ");
INSERT INTO gymNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Akwa ma okwä käme ne ngwane, kä rabadi tuen kä iko kwrere ma bäre temen mae, ne aisete kä trä ngwen tärä mabtä, akwa kä trä ye rabadre tuen drüne kwrere mae, ye abko kä iko ara jire abko rabadre tuen bäri drüne mda mae. Ye kwrere ma töi ñan tä mikani kwatibe Ngöböbti ne ngwane, bäri ma rabadre nüne kä ikote amne Ngöbö trä kuin ñan rabadre nüke gare jire chi mae. ");
INSERT INTO gymNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mdakäre abko, ni ñakare jire abko rabadre sribire bkänkä nibu kräke ja näire, ñobtä ñan angwane sribi bkänkä iti rabadre tare kwe amne mdabtä mätä rabadre; iti kukwei mikadre täte jökrä kwe, akwa mda abko ñan kukwei mikadre täte kwe. Ne aisete ni ñan raba ja töi mike kwatibe sribire Ngöbökrä, ja töi mikare kwatibe ngwian ganankrä kwärä jae. ");
INSERT INTO gymNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ne mden kisete, ti bike niere krörö munye: Munkwe mrö ño kwetadre nünankrä amne munkwe dre ñadre tomnane nünankrä jae, yebtä munkwe ñan töbika dikaro. Erere arato, munkwe dän ño kitadre jabtä, yebtä munkwe ñan töbika dikaro, ñobtä ñan angwane nita nüne kä nebtä angwane, nünandre metre Ngöböbe abko bäri ütiäte mrökrä amne ni ngrabare ye abko bäri ütiäte dänkrä, aisete munkwe ñan töbika krübäte dikaro jändrän yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nukwä tä nikenkä käinta, se mika ñäräre munkwe. Nukwä tä nura nökö ñakare jakrä amne tä ngwä ötö ñakare arato amne ju ñakare kwe mrö ükakrä jakrä, akwa mun Rün kä käinbti käta mrö bien ietre kwetadre. Mun abko bäri ütiäte nukwä kräke, ¿se abko mun Rün käkwe ñan mrö biandre munye ya amarebti munta töbike krübäte dikaro se? ");
INSERT INTO gymNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Munkwe ñan töbikadre krübäte dikaro kore, ñobtä ñan angwane ni tö rabare ja tuai bäri kri, akwa di ñakare ja mike niren taiti mda kukwäne. ");
INSERT INTO gymNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mdakäre abko, ¿ñobtä munta töbike krübäte dikaro dänbtä jakrä se? Kri blü tä niren ño, yebtä munkwe töbika. Tä sribire ñakare jakrä, tä dän dike ñakare jakrä, ");
INSERT INTO gymNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","akwa jrei kri Salomón abko nämane jändrän jökrä tuäretuäre bkäne, akwa dän tuäretuäre kri blü se kwrere abko Salomónkwe kitani ñakare jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kri blü tä neme jötrö köböitibe, abti jändrinane angwane mikata ngire ñukwäte, akwa Ngöböta ngibiare kuin, ¿ye mun abko ie dän ñan biandre Ngöbökwe ya amarebti munta tödeke ñakare täte Ngöböbti ye? ");
INSERT INTO gymNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Munkwe ñan töbika dikaro, kä rika kukwe ngwentari krörö jae au: ¿Nikwe mrö ño kwetadi amne nikwe dre ñadi tomnane? Erere arato, ¿nikwe dän ño kitadi jabtä se? munkwe ñan nie kore jae au, ");
INSERT INTO gymNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ñobtä ñan angwane nitre ñakare israelitare abko bäri tä nakwen kisere jändrän ye jiebti, akwa mun käta dre mdei nike, ye abko garera jökrä Ngöbö mun Rün kä käinbti seye amne niarakwe jändrän ye biandi munye, aisete munkwe ñan töbika dikaro jändrän nünankrä yebtä jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ne aisete, jändrän jökrä Ngöbökwe tä mikani jenena munkrä, ye munkwe känäntari käne amne, mun rabadre nüne metre Ngöbö ngwärekri, ye munkwe känäntari arato angwane, jändrän jökrä mdei nikata munkwe ye Ngöbökwe biandi munye arato. ");
INSERT INTO gymNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mdakäre abko, köbö mdara jire jatadi jetbe angwane, dre dre rakadikä, yebtä munkwe ñan töbika dikaro, ñobtä ñan angwane köbö jetbe ye abko jatadi kukwe mdara jire ngwena töbikakrä munye, aisete köbö kwatirekwatire te kukwe tärä keta kabre ni mikakäre töbike, aisete kukwe jatadre mate ño ño munbtä jetbe, yebtä munkwe ñan töbika dikaro. ");
INSERT INTO gymNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mdakäre abko, Ngöbökwe ñan kukwe ükadrete mun rüere, abkokäre munkwe ñan bika kri, käkwe ñäkä blo ni mda mda rüere, ");
INSERT INTO gymNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ñobtä ñan angwane munkwe ñäkädre ño ño ni mda mda rüere, ye kwrere Ngöbökwe kukwe ükadite munkrä. Erere arato, munkwe ñäkädre krübäte ni mda mda rüere ne ngwane, Ngöbökwe kukwe ükadite krübäte mun rüere amne, munkwe ñäkädi chi ni mda rüere ne ngwane, ye näre Ngöbökwe kukwe ükadite mun rüere. ");
INSERT INTO gymNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Mdakäre abko, kukwe käme btä nita ja mike ngite kri, ye abko ti bike bä mike kri oto kri kwrere amne kukwe chi ye abko ti bike bä mike kä büre chi ye kwrere abko krörö: ¿Kri oto bäri kri tä ma okwäte, ye ño abko ma töbikare ñakare jae amarebti kä büre chi ma mräkä okwäte, abkobtä mata nebe ja ngwen ruen tare yere? ");
INSERT INTO gymNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","¿Ye ñobtä kri oto bäri kri tä ma okwäte abko mata dianka nütüre ñakare jae amarebti, kä büre chi ma mräkä okwäte abko ie mata niere: Ti mräkä, kä büre ma okwäte ye, ti tuemetre denkä jae, mata niere ie? ¡Ye ñan ngwarbe, mata ja bä mike kuin ma mräkäbtä, käta kukwe nuene kore yera! Kri oto kri ma okwäte ye ara jire makwe dianka käne jae. Yebti kä raba tuenta kuin mae angwane, batibe makwe kä büre chi ma mräkä okwäte ye dianka mda ie. Ye kwrere, munta kukwe nuene bäri kämekäme abko okwäbti, ni mdata ja mike ngite chi abko mun ñan bika bäri kise ngwen ni yebtä. Munkwe ñan ñäkä jire chi ni yebtä, akwa kukwe käme, yebtä mun raba moto ulire, bti kukwe ye tuemetre jire jökrä käne, abti mun raba mun mräkä die mike. ");
INSERT INTO gymNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ni ruäre abko krübäte amne romon dikaro nukro kwrere. Ni ye ie munkwe ñan jändrän kuin Ngöbökwe bian, ñobtä ñan angwane nane rikwitadre mun rüere amne nukro käkwe ni tikadrekä kiakia ngrabare tubti, ye kwrere jatadre nuene munbtä. Erere arato, ni tärä ruäre abko mtü kwrere käta jändrän ütiäte ni mdakwe perla ütiäte kri kwrere mike ngwarbe jae. Ni ye abko ie jändrän kuin Ngöbökwe ütiäte kri tä munkwe ye abko munkwe ñan kita temen kräke, ñobtä ñan angwane ñan rabadi ütiäte kräke, aisete dikadikä jökrä bti ta kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Käre munkwe jändrän kärä Ngöböye amne Ngöbökwe biandi munye. Erere arato, munkwe jändrän känäntari Ngöbö känti amne kwandi munye. Erere arato, nita neme jukwebtä jändrän kärere ni mdaye, ye kwrere käre munkwe jändrän kärä jukwebtä Ngöböye angwane, Ngöbökwe jukwe tikadi, käkwe biandi munye, ");
INSERT INTO gymNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ñobtä ñan angwane nireta jändrän kärere, ye erere bianta ie amne, nireta jändrän känentari jakrä, ye erere tä kwen ie amne nireta ñäke jukwebtä abko ie Ngöböta jukwe tike amne tä jändrän bien ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ngöböta jändrän bien kore, yebtä abko ti bike kukwe bä mike krörö mda: ¿Mun mden ie ngäbäkre munkwe tä ban ribere kwetadre jae amne munta jä bien kwetadre ie? ");
INSERT INTO gymNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Erere arato, ¿mun mden ie ngäbäkreta gwa kärere kwetadre jae amne munta tbi krübäte bien kwetadre ie? ");
INSERT INTO gymNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mun abko moto käme, akwa ngäbäkre munkwe, ie jändrän kuin bian gare munye. ¿Se mun Rün kä käinbti bäri moto kuin munkrä se abko munkwe jändrän kuin kärädre ie abko ñan biandre kwe munye ya? ¡Jänri! Munkwe dre dre kärädre ie, erere biandi kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Mdakäre abko, ni mda mdakwe jändrän kuin nuendre munkrä, ie mun töta nebe, ye kwrere munkwe jändrän kuin nuen ni mda mdakrä, ñobtä ñan angwane munkwe nünandre kore angwane, Kukwe Biani Ngöbökwe Moiséye amne kukwe tikani nitre Ngöbö kukwei niekäkwe, ye mun rabare mike täte metre. ");
INSERT INTO gymNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mdakäre abko, mun tö näin Ngöbö känti ne ngwane, jukwe krä chi abko känti ta mun rika, ñobtä ñan angwane jukwe kwata kri amne ji kwata kri abko käta niken ni ngwena kä ja tare nikakrä känti amne ni kwati tä niken jukwe kwata kri yete ta amne ji kwata kri yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Akwa jukwe amne ji käta niken ni ngwena nüne kärekäre Ngöböbe abko krä chi amne ni ñan raba dikekä nuäre bti, ye abko nebe tare ni kwati kräke, aisete ni braibe tä niken jukwe krä chi yete ta amne ji krä chi yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mdakäre abko, nitre ni ngökaka tä näin blite Ngöbö käbti tä niere, ye ngäniene munkwe ja ngibia, ñobtä ñan angwane obeja jäme kwrere tätre ja bä mike, bti tätre nüke mun känti, akwa era metre niaratre töi abko lobo krübäte kwrere jire, bti tätre nüke. ");
INSERT INTO gymNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Niaratre tä nüne ño, yebtä rükadre gare munye abko ti bike bä mike krörö: Kri mden mden tukwätetukwäte btä nita uba ngwä ötö ñakare. Erere arato, kri ochitukwä krie kwrere, btä ni higo ngwä ötö ñakare jire chi arato, ");
INSERT INTO gymNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","aisete kri kuin uba o higokrie kwrere abko käre ngwäta nebe kuin amne kri käme abko käre ngwäta nebe käme. ");
INSERT INTO gymNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ye abko, kri kuin ñan ngwä rabadre käme jire chi amne kri käme abko ñan ngwä rabadre kuin jire chi arato. ");
INSERT INTO gymNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kri mden kämekäme abko ngwä nebe ñakare kuinkuin abko erere tikakata, bti kitata ñukwäte abko garera munye. ");
INSERT INTO gymNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ne aisete, nitre ni ngökaka ye tätre nüne ño, yebtä rüka gare munye. ");
INSERT INTO gymNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mdakäre abko, ñan ni jökrä käkwe niedi krörö tie: Ti Dänkien, niedi kwe tie abko köböire näin kä käinbti, akwa ti Rün tä kä käinbti abko tö dreye, ye erere nire nire tä nuene, käta mike täte, ni ye kwrere aibe näin kä käinbti. ");
INSERT INTO gymNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ne aisete Ngöbökwe kukwe ükadite ni jökrä kräke, ye näire ni kwati rabadi niere tie: Ti Dänkien, nunkwe Ngöbö kukwei kuin mikani gare ma käbti amne nunkwe üai kämekäme juanintari mento ma käbti. Erere arato, nunkwe sribi kri ñan tuabare nuenbare kabre ma käbti arato, aisete nun rabadre nüne kärekäre kä käinbti mabe abko ni kwati rabadi niere kore tie. ");
INSERT INTO gymNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Akwa ye ngwane tikwe niedi krörö ietre: ¡Mun gare ñakare jire chi tie amne, mun abko kukwe nuenkä kämekäme, aisete nän mobe mento tibtä! tikwe niedi ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ye mden tita dirire abko ni iti tä ti kukwei nuen amne tä mike täte, ni ye abko ti bike bä mike krörö: Ni iti töbtä käkwe ju mikani jäkwata ribi bti. ");
INSERT INTO gymNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Yebti ñü jatani jobe temen amne ñö nikani niren niren kri jate amne müre nükani mate ribi krübäte ju yebtä, akwa ju ye mikani jäkwatabti, aisete namani janknu amne ñan nikani temen. Ni ti kukwei mikaka täte abko ti tö nibi bä mikai kore. ");
INSERT INTO gymNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Akwa tita kukwe dirire ne ni iti käkwe kukwe nuadre, akwa ti kukwei mikadre täte ñakare kwe, ni ye abko ti bike bä mike krörö: Ni iti töi ñakare käkwe ju mikani angwane, ju ye abko mikani ümanbti kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Yebti ñü jatani jobe temen amne ñö nikani niren kri jate amne müre nükani mate ribi krübäte ju yebtä, käkwe ju kwitaninkä jökrä temen, käkwe ju juani ngwarbe jökrä kän. Ye kwrere abko nire nire ñan tä ti kukwei mike täte abko ti tö nibi bä mikai kore. Abko kore se. ");
INSERT INTO gymNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu käkwe blitabare ünän jökrä kore angwane, ni kwati nämane näin ben, ye ñan töi namani krütare jökrä kukwe diribare kwe yebtä, ");
INSERT INTO gymNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ñobtä ñan angwane ni töbtä di kri käkwe diri ja di ngöi, kwrere jire Jesukwe diribare ietre amne, Kukwe Biani Ngöbökwe Moiséye dirikätre abko nämane dirire, ye kwrere Jesukwe diribare ñakare. Yebtä abko ñan töi namani krütare Jesu kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu nämane ngitiobtä, yebti nikaninta nebeta ngitiobtä ngüsrüri mda angwane, ni kwati nikani niara jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ye btäräbe ni iti bren lebra kisete, abtä ngütüete abko jatani Jesu ngäbti angwane, namani ngukudokwäbti temen Jesu ngwärekri, käkwe niebare ie: Ti Dänkien, ma tö ti mikaita kuinta ne ngwane, ma di tärä nuendre gare tie, aisete makwe ti mikata kuinta, ie ti tö nibi, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Angwane Jesukwe kise mikani btä, käkwe niebare mda ie: Ma rabata kuinta, ie ti tö nibi, aisete gwängwarbe ma bike nebeta kuinta, niebare kwe ie. Ye btäräbe ni ye kwata ngütüete namaninta kuinta jökrä ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Angwane Jesukwe niebare krörö mda ie: Tikwe ma mirita kuinta, ye makwe ñan nie jire chi ni mda mdaye, akwa ma rika ja kwata kuinta mike tuare ni blitaka Ngöböbe ni mda mda diäreye amne ni bren kore tä nebeta kuinta abko käkwe jändrän mden mden biandre niebare Moisékwe, ye erere ma rika ngwena biandre Ngöböye. Yebtä abko ma nenante kuinta abko rabadre gare ni jökräye, abkokäre ma rika jändrän ye ngwena. Abko kore se, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yebti Jesu nikani nebe juta Capernaúmte angwane, rükä dänkien romanobo jatani iti nüke Jesu känti ja di käräkäre ie, ");
INSERT INTO gymNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","käkwe niebare krörö: Ti Dänkien, sribikä tikwe bren jume dikaro tikän amne ruen ñakare ngrabare abko kisete tä ja tare nike krübäte abko ti ki niere mae, makwe mikadre kuinta abkokäre, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Angwane Jesukwe niebare mda ie: Ye ti näin miketa kuinta makrä mtare, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Abtä niarakwe niebare mda Jesuye: Ti Dänkien, ni ütiäte ñakare ti ne kwrere abko gwiriete ni ütiäte ma ye kwrere nin rükadre jire chi ruen tie. Akwa sribikä tikwe rabadreta kuinta abko makwe niedre jirekäbe nete angwane, rabadita kuinta abko gare tie abko ti tö nibi ribei mae, ");
INSERT INTO gymNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ñobtä ñan angwane ni mda bäri ütiäte ütiäte, ben tita sribire, käta dre nuemna tie, erere tita nuene. Erere arato, nitre rükä tä sribire tibe abko, tita juen, ye tä niken jötrö ngwarbe. Jakwe, tita niere ie, jötrö ngwarbe tä kite. Mdakäre abko, ni klabore tikwe, ie sribi ne nuene, tita niere, jötrö ngwarbe tä nuene. Ne aisete, tita dre niere, erere tä nebe bare täte jökrä. Ye kwrere arato, makwe dre dre niedre sribikä bren tikwebtä abko erere rabadi bare täte mae ruen tie, aisete tita ja di ribere kore mae. Abko kore se, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yebtä abko, Jesu ñan töi namani krütare mda ni ye kukwei nuare kore angwane, nitre nämane näin Jesube, ie Jesukwe niebare krörö mda: Ti bike kukwe era erere niere munye abko krörö: Ni tödeke kwatibe Ngöböbti ni ne kwrere, nin ngämi kwen jire tie nitre israelita ngätäite, amarebti ni menteni nünanka juta mdara jire te tä tödeke kwatibe Ngöböbti nüke kwen mtare tie nere. ");
INSERT INTO gymNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nebtä abko ti bike kukwe metre niere krörö munye: Nitre ñakare israelitare kä jökräbti temen abko näin nebe mröre ketetibe Abrahambe, Isaabe amne Jacobobe kä käinbti sete, Ngöböta gobrane ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Akwa mun israelita ye ara jire rabadre käne Ngöbö känti kä käinbti sete, akwa ñan rabadre bare kore, akwa kä bäri iko te Ngöbökwe mun kitadi ju bäre niara okwä bäre mento. Ye känti mun rabadi ja müaire krikri be amne ja tare nikabtä mun rabadi ulire dikaro. Abko kore se, niebare Jesukwe ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yebti rükä dänkien ye ie Jesukwe niebare: Ti di tärä ni sribikä makwe mikakrä kuinta kore nibi era makrä, ye erere nibira kuinta, aisete nänta ja gwiriete, niebare Jesukwe ie. Ye erere bkänä sribikä namaninta kuinta batibe. ");
INSERT INTO gymNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Abti Jesu nikani Pedro gwiriete angwane, Pedro köbrän merire abko nämane bren drangwan kisete, abtä nämane kitanintbe jänbti temen, känti Jesu namani. ");
INSERT INTO gymNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu namani känti angwane, Jesukwe nuaninbtä jirekäbe kisebtä. Ye btäräbe drangwan nikaninbe batibe btä, namanintabe kuinta, aisete nükani dikekäta krö, kä nikani mrö känene Jesu bukakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Yebti kä jatanina iko angwane, ni kwati nämane ja tare nike üai käme kisete abko jänikani Jesu känti angwane, Jesu nikani üai käme ye juentari mento, erere üai käme ngitiani jökrä mento btätre. Erere arato, ni bren ño ño erere jänikani Jesu känti yete abko Jesukwe mikaninta kuinta jökrä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kukwe nakaninkä kore, ye abko ni Ngöbö kukwei niekä kira kädian nämane Isaías abko köböire Ngöbö käkwe kukwe krörökrörö niebare kira Jesubtä abko erere rabadre bare, abkokäre kukwe nakaninkä kore se: Niarakwe bren dianinkä nibtä amne, ni mikaninta kuinta jökrä kwe, abko Ngöbökwe niebare kore Jesubtä Isaías köböire abko erere namani bare. ");
INSERT INTO gymNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yebti ni jatani nüke kwati dikaro Jesu bäre temen namani tuen ie angwane, ja ngwiamna Ñö Okwä Kri Galilea kwärä nakri kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ye btäräbe ni iti Kukwe Biani Ngöbökwe Moiséye dirikä käkwe krötabare Jesu ken, käkwe niebare ie: Dirikä, ma näin mdente erere, ye känti ti rikai siba mabe, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Abtä Jesukwe niebare mda ie: Nukro känsenta, kwe kä mkä tärä nünankrä amne, nukwä nikenkä käinta abko juda tärä kwe nünankrä arato, akwa ti Ni Kä Nebtä Ngobo ne abko kwe kä ñakare jire chi jadükakrä. Ne aisete ma tö jatai tibe ne ngwane, ma rabadre juto biare nüne ti kwrere arato, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yebti ni mda nämane näin Jesube käkwe niebare mda ie: Ti Dänkien, ti tuemetre nikenta ken ja gwiriete, abti ti rün krütadi, tikwe doboi mikadi, ye täbti ti näin mabe, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Angwane Jesukwe niebare mda ie: Nitre ie Ngöbö gare ñakare abko tä ni ngwäkäre kwrere Ngöbö ngwärekri, ye tuametre ni ngwäkäre doboi mike amne ma abko jata janknu ti jiebti, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yebti Jesu nakwani rute amne nitre ja töitikaka ben abko nikani siba niarabe. ");
INSERT INTO gymNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nikanina ñöbti se kwrere angwane, batibe müre jatani mate ribi krübäte ñübe mni mni, ye abko namani ñö kite jökrä rute, aisete ru jatani niken ñöte nguse, akwa Jesu abko nämane kibien. ");
INSERT INTO gymNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yebtä abko nitre ja töitikaka ben nikani gaenkrö, käkwe niebare ie: ¡Nun Dänkien, ni dentari! Ni kite niken ñöte nguse, namani niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Abtä Jesukwe niebare ietre: ¡Se ñobtä munta tödeke ñakare dikaro Ngöböbti amarebti mun nibi nekwetekä krübäte dikaro ja jiebti ye! niebare Jesukwe ietre. Jesukwe ñäkäbare kore ietre, bti nükani dikekä krö, käkwe ñäkäbare müreye amne ñöye. Ye btäräbe müre amne ñö namani kwekbe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yebtä abko, nitre ja töitikaka Jesube ñan töi namani krütare mda Jesubtä, kä namani niere jae kwärikwäri: ¿Ni ne abko ni ño amarebti müre amne ñö käta kukwei mike täte jökrä se? namani niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yebti Jesu nikani nebe Ñö Okwä Kri Galilea kwärä nakri käkä Gadara känti angwane, ni nibu btä üai käme nämane nüne abtä nämane nüne kä mkäte rökabti abko jatani nüke Jesu ken. Nitre nibu btä üai käme nämane nüne ye abko nämane romon krübäte, aisete nämane nüne rökabti, ye käntita ni ñakare jire iti ie ja namani nüke töre dikekä yere. ");
INSERT INTO gymNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Akwa Jesu nikani yere angwane, nitre nibu ye namani niere krörö Jesuye: Jesu Ngöbö Odei, ¿ye ñobtä ma kite nun nike nete ye? ¿Ngöbökwe kä kitani nun mikakäre ja ngie nuen, ye känenkri ma kitera nun mike ja tare nike ya ño yere? namanintre niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kä ye känti abko känime se kwrere mtü nämane kabre mröre ");
INSERT INTO gymNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","angwane, üai käme käkwe niebare Jesuye: Ma bike nun juentari mento nitre nebtä ne ngwane, mtü tuen sete sebtä makwe nun juan, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Angwane Jesukwe niebare üai kämeye: Mun nän mento nitre nebtä, niebare mda kwe. Ye btäräbe üai käme ye nakwaninkäbe mentokwäre nitre yebtä, bti nikanintre jökrä mtü kabre yebtä. Ye btäräbe mtü jökrä käkwe ja täkäninte, nikani betekä jökrä ja jiebti kä btä motokwäre, nikani ngitiekä jökrä ñöte, känti müre neketani jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Angwane nitre mtü ngibiaka nämane yete abko ngitiani jökrä, nikanintre nebeta jutate angwane, nitre nibu btä üai käme nämane abko btä kukwe nakaninkä ño ño amne kukwe nakaninkä ño ño mtübtä ye abko tanbare jökrä kwetre jutate yete. ");
INSERT INTO gymNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yebtä abko nitre nünanka juta yete nikani kwati Jesu känti, namanintre Jesu känti angwane, Jesukwe kä mikadrekä kä ye känti abko namani ribere ie. ");
INSERT INTO gymNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yebti Jesu nakwaninta rute nitre ja töitikaka benbe, bti nikanintreta mda Ñö Okwä Kri Galilea kwärä nakri amne nikani nebeta ja käite Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Abti ni iti ruen ñakare ngrabare abko kisete ñan dikaka kä abko nämane mikani jänkwatabti abko ni mda mda nükani ngwena Jesuye. Nitre nükani ni bren ngwena amne ni bren ye namani tödeke kwatibe Jesubti namani tuen ie angwane, Jesukwe niebare ni bren yeye: Ma ngite Ngöbö rüere, ye tikwe dininkä mabtä, aisete kä raba nuäre mabtä ti mräkä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Angwane Kukwe Biani Ngöbökwe Moiséye dirikätre nämane ruäre yete abko namani töbike krörö Jesubtä: Ni noko käkwe ñäri kore se abko ñäri Ngöbö ara jire rüere kwe, namanintre nütüre Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Akwa niaratre namani töbike kore ye abko gani Jesukwe, abtä niebare kwe ietre: ¿Ye ñobtä amarebti mun töi kämekäme dikaro kore ye? ");
INSERT INTO gymNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Dre abko bäri nuäre niedre: Ma ngite Ngöbö rüere ye tikwe dininkä mabtä abko bäri nuäre niedre ya? o ¿Näin krö, nänta abko bäri nuäre niedre ya? Ye abko, ma ngite Ngöbö rüere ye tikwe dininkä mabtä abko bäri nuäre niere, ñobtä ñan angwane raba bare ya, ñakare ya ñan jatadre munye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Akwa ti Ni Kä Nebtä Ngobo, ne ie Ngöbökwe ja di biani mun ngite Ngöbö rüere diankakäre munbtä kä nebtä, ye abko ti bike bä mike tuadre munye, niebare Jesukwe. Ye btäräbe ni ruen ñakare ngrabare ye ie Jesukwe niebare: Näin krö. Jänkwata makwe ye den kisete amne nänta ja gwiriete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Angwane jötrö ngwarbe ni ruen ñakare ngrabare ye naninkrö krö amne nikaninta ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nitre nämane yete okwäbti kukwe nakaninkä kore, yebtä abko namanintre nekwetekä krübäte, akwa Ngöbökwe ja di biani kri ni kä nebtäye namani tuen ietre, abtä namani Ngöbö käikitekä. ");
INSERT INTO gymNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Abti Jesu nikaninta angwane, kä jändrän ütiä biankrä gobran romanobokrä, känti ni näma täkänintbe iti jändrän ütiä kärere. Ni kädian nämane Mateo, ye abko ti ara, btä Jesu okwä rababa. Angwane Jesukwe nieba tie: Brän tibe, nieba kwe tie. Angwane jötrö ngwarbe ti Mateo rükaba dikekä krö, rikaba Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yebti Jesu näma mröre ti gwiriete angwane, nitre jändrän ütiä käräkä gobran romanobokrä rükaba kwati amne ni mda mda näma tuen käme ni israelita ruäreye abko rükaba amne rababa täkänintbe jökrä mesabtä mröre ketetibe Jesube amne nitre ja töitikaka Jesube ye ben gwaire arato. ");
INSERT INTO gymNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jesu näma mröre kore, ye tuaba nitre bariseokwe angwane, nieba kore kwetre nun ja töitikaka Jesube yeye: ¿Nitre jändrän ütiä käräkä gobran romanobokrä abko käme amne ni mda mda kukwe nuenkä kämekäme se gare ñakare dirikä munkwe seye ya amarebti tä mröre jäme ketetibe ben se? nieba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nitre bariseo käkwe ñäkäba kore, ye jaraba Jesuye angwane, Jesukwe ja bä mikaba ni kräkä bianka kwrere amne nitre jändrän ütiä käräkä amne nitre kukwe nuenkä kämekäme, ye bä mikaba ni bren kwrere, käkwe nieba krörö mda ietre: Ni kuin bren ñakare ye abko ñan tä ni kräkä bianka ribere jabtä, akwa ni bren bren abtä tä ni kräkä bianka ribere jabtä abko ti tö nibi niei munye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ne aisete Ngöbö Kukwei tä tikani krörö ti bike niere, nebtä mun rika ja töitike gwi: Munkwe ni mda mda ngwiandre ruentari tare jae, ye abko ie ti tö bäri. Akwa mun tädre jändrän bien jirekäbe kukwadre tie, ye abko ie ti ñan tö bäri, niebare Ngöbökwe. Yebtä mun rika ja töitike, ñobtä ñan angwane ni ie ja ruen kuin deme au Ngöbö ngwärekri mun kwrere, ye abko ñan ti jatani kärere Ngöbö kukwäre, akwa ni kukwe kämekäme nuenkä Ngöbö rüere ye mden abko ti jatani kärere Ngöbö kukwäre. Abko kore se, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yebti nitre nänkä Juan Bautistabe käkwe krötaba Jesu ken, käkwe nieba ie: Nun nänkä Juanbe btä nitre bariseo, nunta ja bäine Ngöbökrä, ¿se ñobtä abko nitre ja töitikaka mabe abko ja bäine ñakare Ngöbökrä sere? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Abtä Jesukwe kukwe bä mikaba ietre, käkwe ja bä mikaba ni ja mikaka gure kwrere amne nitre ja töitikaka ben abko bä mikaba kwe ni ja mikaka gure kukwe muko kwrere, käkwe nieba ietre: Ni iti tä niken ja mike gure angwane, tä kukwe muko kwekwe nübaire kä ngwiankäre nuäre gwaire jabtä, ¿ye ngwane ni ja mikaka gure ye tädre siba bentre angwane, kukwe muko ye raba moto ulire ja bäine ya? Ñakare, akwa ni ja mikaka gure ye järikadre kukwe muko okwäbti, ye ngwane rabadre ja bäine abko kore rakadikä nitre ja töitikaka tibe yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Mdakäre abko, ti bike kukwe mdara jire bä mike krörö munye: Dän ngututu gudikadre dän kukwän btinbti angwane, dän kukwän btin tä dän ngututu kwaenkä bäri mda abko kisete dän ngututu rötadreteta angwane, rötadrete bäri kri mda, aisete ni ñan raba dän ngututu gudike dän kukwän btinbti. ");
INSERT INTO gymNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Erere arato, chibo kwata dikani kira uba döi ngwäre, te ni ñan raba uba döi mräre keke mikadre kwaka, ñobtä ñan angwane uba döi bänän jatadre dime amne rikadre nokrekä, ye käkwe chibo kwata ngututu trekadre amne rikadre ngwarbe uba döi kwaka ben ngöi jökrä arato. Mden kisete, uba döi mräre mikadre kwaka abko kekadre chibo kwata btinte, uba döi amne chibo kwata ñan rikadre ngwarbe. Abko kore se, nieba Jesukwe nitre nänkä Juanbe yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu näma blite kore, ye btäräbe ni iti ji dokwäte nitre israelita ngätäite jataba, rikaba ngitiekä ngukudokwäbti temen Jesu ngwärekri, käkwe nieba krörö ie: Ti ngänkän küre gwä tikän, akwa ma rikadre tibe, käkwe kise mikadre bti angwane, rükadreta nire nibi ruen tie, aisete ti ki ma kärere btä ye, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ye mden kisete, Jesu rikaba dikekä amne rikaba ni ji dokwäte yebe amne, nun ja töitikaka Jesube rikaba siba ben arato. ");
INSERT INTO gymNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Angwane abko meri rikaba iti Jesu jiebti. Meri ye abko kä kwä jätäbti kubura nikani bren dbä tibiere abko kisete nämane ja tare nike. Meri ye abko käkwe krötaba ja ken Jesu trökri, käkwe dän Jesubtä nuabtaba tiebe köräbtä, ");
INSERT INTO gymNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ñobtä ñan angwane rababa töbike krörö: Tikwe dän körä aibe nuadrebtä Jesubtä angwane, ti rabadreta kuinta, nibi ruen tie, rababa nütüre kore, aisete dän nuabtaba kwe Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Meri ye käkwe dän nuabtaba Jesubtä angwane, Jesu rikwitateba ja jiebti, käkwe niara tuaba ja käne, bti nieba krörö kwe ie: Ti mräkä, makwe tödiri kwatibe tibti, köböire ma nibirate kuinta, aisete makwe kä ngwian nuäre jabtä, nieba Jesukwe ie. Ye btäräbe meri ye rababata kuin batibe. ");
INSERT INTO gymNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yebti Jesu rikaba janknu mentokwäre nebe ni ji dokwäte ye gwiriete angwane, nitre nörä jükaka dobo mikakrä ye namanina biare nörä jüke dobobti, btä Jesu okwä rababa. Erere nitre mürü ngwäkä müaikä nämane ngetrekä krikri be, btä Jesu rababa. ");
INSERT INTO gymNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Angwane Jesukwe nieba ietre: Ngäbäkre merire noko küre ñakare, akwa tä kibien, aisete mun nän jökrä mento nete, nieba kwe ietre. Abtä nitre ye rababa Jesu kötaire jökrä mda. ");
INSERT INTO gymNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Akwa Jesukwe juantariba jökrä mento, bti Jesu rikaba nebe gwi, käkwe mürü ngwäkä ye kaba küdebti angwane, ngäbäkre merire ye rükabata krö batibe. ");
INSERT INTO gymNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kukwe rakakaba kore ye abko kädrie rikaba batibe jökrä kä ngrabare temen Galileate. ");
INSERT INTO gymNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ni ji dokwäte gwiriete Jesu näma, yebti rikabata angwane, ni nibu ie kä tuen ñakare abko rikaba ngwänenkä kri krörö Jesu jiebti: ¡Jrei David tukwe mräkä, nun ngwen ruentari tare jae! rikaba niere Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yebti Jesu rikaba gwä angwane, nitre nibu ie kä tuen ñakare ye käkwe krötaba Jesu ken angwane, Jesukwe nieba ietre: ¿Ti di tärä mun okwä mikakräta kuinta ye abko era munkrä amne yebti munta tödeke ya? nieba Jesukwe ietre. Niaratre käkwe nieba mda: ¡Jänri nun Dänkien! nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Angwane Jesukwe kise mikaba niaratre okwäbtä, bti nieba kwe mda ietre: Munta tödeke ño tibti, ye erere raba bare munkrä, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ye btäräbe niaratre okwä rababata kuin batibe amne kä rababa tuenta kuin ietre. Yebti Jesukwe mäträba krörö mda btätre: Tikwe mun okwä mirita kuinta, ye munkwe ñan nie jire chi ni mda mdaye, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Akwa niaratre nikaninta krire ji ngrabare angwane, Jesukwe mikabata kuinta ño ye tanbare jökrä kwetre kä ngrabare temen Galilea yete. ");
INSERT INTO gymNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nitre nibu ye rikabata krire, ye btäräbe ni mdara jire jataba nüke Jesu känti ni iti kukwe ñakare abko btä üai käme nämane nüne abko rükaba ngwena Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesukwe üai käme juantariba mento ni yebtä, ye btäräbe rababa blite kuin angwane, ni näma kwati yete abko ñan töi rababa krütare mda, kä rababa niere krörö: Kukwe nibi nakenkä ni okwäbti noko kwrere ni ngämi tuen jire chi bati kä Israelite nete, rababa niere kore. ");
INSERT INTO gymNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Akwa nitre bariseo abko rababa niere krörö: Üai käme dänkien kri ara jire käkwe ja di bini ie, ye mden diebti abko üai käme junintari mento kwe ye, rababa niere kore Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yebti sinagoga näma juta krikrite amne juta kiakiate Galilea, käntikänti Jesu rikaba dikekä kwäräkwärä dirikäre mda. Ngöbö jatanina nüke gobrane nibti abko kukwe kuin btä Jesu näma dirire angwane, ni bren bätäkä ngwarbe kisete nämane ja tare nike abko Jesu rababa miketa kuinta. ");
INSERT INTO gymNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Akwa ni nämane kwati dikaro rababa tuen Jesuye angwane, nitre ye rababa ruentari tare kri Jesuye, ñobtä ñan angwane obeja ngibiaka ñakare abko jändrän krübäte tä nike bäri amne di ñakare ja ngibiakrä rüe ngäniene, aibe kisete tä nebe dräre, ye kwrere jire nitre ye rababa tuen Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Abtä nun ja töitikaka ben, ie nieba krörö kwe: Nura nena biare kabre ötadre, ye kwrere ni kwati tä juto biare ngwiandre Ngöböye, akwa sribikä ñakare bökän, ");
INSERT INTO gymNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","aisete sribi Bkänkä Ngöbö käkwe sribikä mda mda juandre jötrö sribire abko munkwe ribe ie, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yebti nun ni jätäbti nibu ja töitikaka Jesube abko Jesukwe käräba, bti ja di bianba kwe nunye üai käme juantarikrä mento. Erere arato, ni bren bätäkä ngwarbe abko nunkwe mikadreta kuinta, abkokäre ja di bianba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nun ni jätäbti nibu ja töitikaka Jesube abko nere: Bäri käne abko Simón (Simón ne arabe kädian nämane Pedro arato) amne Andrés. Andrés ne abko Simón etba, Santiago amne etba kwe Juan. Niaratre nibu ne abko Zebedeo ngobo. ");
INSERT INTO gymNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe amne Bartolomé; Tomás amne ti Mateo. Ti ne mden nämane jändrän ütiä kärere gobran romanobokrä. Santiago (Santiago ne abko Alfeo ngobo) amne Lebeo. Lebeo ne arabe kädian nämane Tadeo arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón cananista amne mrä abko Judas Iscariote. Judas ne mden käkwe Jesu kitani ngise rüeye mrä. ");
INSERT INTO gymNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesukwe nun ni jätäbti nibu juanba dirire angwane, nun töi tikaba krörö kwe: Nitre ñakare israelita tä nüne, ye käntikänti mun ñan rika. Erere arato, nitre Samariabo tä nüne, ye käntikänti mun ñan rika. ");
INSERT INTO gymNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Akwa nitre israelita tä nianinte obeja kwrerekwrere, ye ara jire känti mun rika, ");
INSERT INTO gymNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","käkwe diri krörö ietre: Ngöbö kebera nüke gobrane nibti, munkwe nie ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Amne ni bren bren abko munkwe mikata kuinta. Erere arato, ni krütanikrütani abko munkwe mikata nire amne, ni ngütüete ngrabare lebra kisete abko munkwe mikata kuinta amne nire nire btä üai kämekäme tä nüne abko munkwe juantari mento btätre. Mdakäre abko, tikwe ja di bini munye sribi ne nuenkrä, ye abko tikwe bini ngwarbe munye, aisete munkwe sribi ne nuen angwane, munkwe ñan ütiä kärä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mdakäre abko mun rika angwane, mun ñan rika ngwian orore, platare amne cobrere ngwena jire chi jae. ");
INSERT INTO gymNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ye kwrere arato, mun ñan rika mrö ngwena droare jae amne, mun rika dän jabtäbe te amne mun ñan rika dän mdara jire ngwena kitadre jabtä. Erere arato, mun ñan rika sandalia mda mda ngwena jae amne mun ñan rika mökän mda ngwena biare jae, ñobtä ñan angwane ni sribikä mun kwrere abko nitre mun kukwei kaka ngäbti abko käkwe bukadre aisete. ");
INSERT INTO gymNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Mdakäre abko, mun rika nebe juta krite ya o juta chite, ye känti nire tä biare mun kaen ngäbti töi kuinbti abko munkwe känä iti. Ye känti mun raba nünentbe. Munkwe nünantbe niara ye aibe gwiriete abti mun rika ta. ");
INSERT INTO gymNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Akwa mun rika nebe gwi angwane, ni nünanka gwi ye ie munkwe köbö ngwiantari jäme amne, ");
INSERT INTO gymNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","nitre nünanka ju yete, ie munkwe köbö ngwianditari, ye abko kadre ngäbti kwetre ne ngwane rabadi nünentbe jäme yete, akwa ñan kadre ngäbti kwetre ne ngwane, munkwe ñan ja kukwe gadrete ngwarbe arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Erere arato, nane ju mdente mun rika nebe amne juta mdente mun rika nebe, ye känti nire nire ñan tö raba mun kain ngäbti ja gwiriete amne ñan tö raba mun kukwei tibtä mikai era ne ngwane, munkwe kä mikaka jirekäbe ju o juta yete, käkwe dobro mnü ngrükate ja ngotobtä, niaratre ngite au Ngöbö ngwärekri bä mikakäre ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ni yebtä ti bike kukwe era erere niere munye abko krörö: Ngöbökwe kukwe ükadite ni jökrä kräke, ye näire abko Ngöbökwe nitre ye mikadi ja tare nike bäri kri krübäte. Ngöbökwe nitre juta Sodomabo amne nitre Gomorrabo mikani ja tare nike, yebti ta Ngöbökwe niaratre mikadi ja tare nike abko ti bike niere era metre kore munye, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yebti Jesukwe nieba mda nunye: ¡Olo ketete ti kukweiye munkwe! Ni mda mda abko krübäte lobo kwrere abko ngätäite tita mun juen obeja kwrere, akwa tbi tä juto biare mokrere jabti, ye kwrere munkwe dikaka mokrere kwärä jabti, akwa munkwe dikaka jäme ütü jäme ye kwrere arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Munkwe ñan dikaka okwä kware, ñobtä ñan angwane nitre krikri tä ji dokwäte jutate jutate, ye ie mun kitadi ngise amne niaratre käkwe mun ngö tikakamna sinagogate yete. ");
INSERT INTO gymNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mdakäre abko, tödekabtä tibti mun jänäin ngite gobran ngwärekri amne jrei ngwärekri amne ye känti munkwe blitadre tibtä nitre ñakare israelitare ngwärekri, abkokäre mun jänäin ngite yete. ");
INSERT INTO gymNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Akwa nitre kukwe ükatekä, ngwärekri mun järika ngite angwane, munkwe blitadre ño jakrä amne munkwe dre niedre, yebtä munkwe ñan töbika dikaro, ñobtä ñan angwane mun järabara ja ngwärekri yete angwane, ñan munkwe blitadi kaibe au jakrä akwa, Ngöbö mun Rün abko Üai kwe ara jire käkwe kukwe biandi munye ja kwetakrä jakrä amne blitadi kwe mun köböire munkrä. ");
INSERT INTO gymNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Mdakäre abko, nitre tödekaka tibti abko etba kwekwe tödeke ñakare tibti abko käkwe kitadi ngise müre ketadre amne ngäbäkre tödekaka tibti abko rün kwe amne meye kwe käkwe kitadi ngise müre ketadre arato. Erere arato, ngäbäkre rün amne meye tödekaka tibti ye abko ngobo kwekwe tödekaka ñakare tibti rikwitadi rüere, käkwe kitadi ngise müre ketadre. Ne abko rabadi nakenkä kore nitre tödekaka tibti btä. ");
INSERT INTO gymNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Angwane, ni kwati mätä rabadi munbtä tödekabtä tibti, akwa nire nire käkwe nünandikä dite jabtä, käkwe ñan ti rükandrete abti krütadre, ni ye abko Ngöbökwe dianditari. ");
INSERT INTO gymNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ne aisete juta te mun raba, ye känti mun rüe raba näin kisere mun jiebti mun mikakäre ja tare nike tödekabtä tibti ne ngwane, mun gitia juta mdate. Mun ngämi dikekä juta kwatirekwatire te kä ngrabare temen kä Israelite, ye känenkri ti Ni Kä Nebtä Ngobo abko jatadita ne abko ti tö nibi niei metre kore munye. ");
INSERT INTO gymNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mdakäre abko, ni ja töitikaka ye abko ñakare bäri ütiäte ni dirikä ye kräke amne ni klabore ye ñakare bäri ütiäte bkänkä kwe ye kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ne aisete ni dirikä ti kwrere käkwe ja tare nikadre ño, ye kwrere ni ja töitikaka ben tädre juto biare ja tare nike. Erere arato, sribi bkänkä käkwe ja tare nikadre ño, ye kwrere ni klabore kwe tädre juto biare ja tare nike sribi bkänkä ye kwrere. ¿Ti abko ju dänkien kwrere akwa ti abko Beelzebú ara nieta tibtä mtare, se mun ti mräkätre ñan kädiandre kore arato ya? Jänri, kädiandre jökrä kore ni mdakwe, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Yebti Jesukwe nieba krörö mda nunye: Ni kwati rabadi mun rüere tikwe nini munye, akwa munkwe ñan ni mda mda ye jürä ngwian jabtä, ñobtä ñan angwane jändrän nuenta kaibe tiebe ye abko ñan tä nebe kärekäre tiebe. Erere arato, jändrän rükaninte kaibe, ye abko ñan tä nebe rükaninte kärekäre, ");
INSERT INTO gymNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","aisete tita kukwe niere kaibe kä ikote kwrere munye, ye abko mun rika kädriere ni jökrä ngwärekri kä ngwenbti amne, blitata tiebetiebe ni olote, kwrere jire tita blite munbe, ye abko mun rika niere jubti käin amne munkwe ngrate krikri kukwe nuadre ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mdakäre abko, ni mda raba mun ngrabare aibe kämike, akwa ñan raba mun üai mike ja tare nike kärekäre, aisete munkwe ñan ni mda jürä ngwian jabtä; akwa Ngöbö abko raba mun üai kite mun ngrabare ye ben ngöi kä ja tare nikakrä känti, Ngöbö ye aibe abko jürä ngwian jabtä munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ye abko, nukwä kiakia rürümointa kubu abko ütiä bianta bäri brai, aisete ngwian bianta mnamube ütiäre, akwa Ngöböta nukwä ye tarere, aisete mun Rün kä käinbti ñan töta nebe nukwä ye tuaimetre ngataen angwane, ñan tä ngataen jire chi kwati kä nebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amne mun ara jire abko dokwä drüen kratirekratire abko tä gare jökrä Ngöböye, ");
INSERT INTO gymNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","aisete Ngöbökrä mun abko bäri ütiäte kri nukwä kabre kabre bti ta, aisete mun raba ja tare nike angwane, munkwe ñan kä jürä ngwian jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Mdakäre abko, nire nire tä nekete tibe abko niedre metre kwe ni mda mda ngwärekri, ni ye abko jen tikwe abko tikwe niedi arato Ngöbö ti Rün ngwärekri kä käinbti sete. ");
INSERT INTO gymNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Akwa nire nire käkwe ti rükandrete ni mda mda ngwärekri, ni ye abko gare ñakare tie abko tikwe niedi Ngöbö ti Rün ngwärekri kä käinbti sete arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Erere arato, ti jatani kä nebtä, ye abko ñan ti jatani ni jökrä mikakäre nüne jäme jabe kwärikwäri abko munkwe nütü; akwa ti jatani abtä ni kwati tädi rüre jabe kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne aisete ti dokwäre ngäbäkre rikwitaita rün kwe rüere amne ti dokwäre ngäbäkre merire rikwitaita meye kwe rüere. Erere arato, bosi rikwitaita bie rüere arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ne aisete nitre ja mräkäre gwi arabe rikwitadita ja rüere kwärikwäri ti dokwäre, ñobtä ñan angwane ruäre abko rabadi tödeke tibti, ruäre ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mdakäre abko, nire nire käta rün amne meye tarere bäri tikrä, ni ye abko ñan rabadre jire chi tikwe. Erere arato, nire nire käta ngobo amne ngänkän tarere bäri tikrä, ni ye abko ñan rabadre jire chi tikwe. ");
INSERT INTO gymNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Erere arato, ni kämikata niken krusobtä angwane, nita niken kruso doboko ngwena au jakrä, ye kwrere nire nire käkwe ñan kötä mikadre au jakrä ja tare nikakäre tikrä amne krütakäre tikrä ne ngwane, ni ye ñan rabadre jire chi tikwe. ");
INSERT INTO gymNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ne aisete, nire nire ie ja kwata rabadi ruentari tare, käkwe ja ngibiadi au nünakäre nuäre kä nebtä, ni ye abko käkwe ñan nünandi kärekäre Ngöböbe; akwa nire nire ie ja kwata rabadi ruentari tare ñakare ja tare nikakäre ti dokwäre, ni ye abko käkwe nünandi kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Mdakäre abko, nire nire käkwe mun kadre ngäbti, ni ye abko käta ti ne ara jire kaen ngäbti, ñobtä ñan angwane mun tä näin blite tikrä aisete. Erere arato, nire nire käkwe ti kadre ngäbti, ni ye abko käta Ngöbö ti juanka kaen ngäbti arato. ");
INSERT INTO gymNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Erere arato, ni Ngöbö kukwei niekä rükadre angwane, niara abko Ngöbö kukwei niekä abtä nirekwe kadi ngäbti ja gwiriete, ye ütiäre abko ni Ngöbö kukwei niekä ie jändrän biandre Ngöbökwe, ye kwrere Ngöbökwe biandi arato ni niara kaka ngäbti yeye. Erere arato, ni nüne metre Ngöbö ngwärekri, ye nire nire käkwe kadre ngäbti ja gwiriete angwane, niara nüne metre abtä tä kaen ngäbti, aisete ni nüne metre Ngöbö ngwärekri, ie sribi ütiä biandi Ngöbökwe, ye kwrere biandi kwe arato ni niara kaka ngäbti yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Erere arato, nitre bobre bobre tödekaka tibti ne ie nire nire käkwe ñö tibo aibe biandi chi tomnane, akwa ye abko Ngöbökwe ütiä biandi ie abko ti tö nibi niei metre kore munye. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nun ni jätäbti nibu abko töi tikaba ünän jökrä kore Jesukwe, yebti Jesu rikaba Ngöbö kukwei kuin ye dirire amne mike gare kä ngrabare temen kä Galileate. ");
INSERT INTO gymNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kä ye ngwane abko Juan Bautista nämane ngite kä teri angwane, Kristo namani sribi kri ñan tuabare nuene kri abko gani kwe. Abtä nitre nänkä Juanbe abko Juankwe juani ruäre nebe Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ye erere bkänä nitre ye nikani, nikani nebe Jesu känti angwane, nieba krörö kwetre Jesuye: Ma abko ni Dianinkä juandre Ngöbökwe rükadre ni ngätäite niebare, ye erere ma ara nükani ya o nunkwe ni mdara jire ngibiadre abko nun juanba ngwentari mae, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Angwane Jesukwe nieba mda ietre: Tita dre dre niere abko kukwei nuri munkwe amne tita dre dre nuene tuata munkwe, ye erere mun nän niereta Juanye. ");
INSERT INTO gymNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Amne munkwe nie krörö ie arato: Ni okwä kä drünente abko ie kä nibi tuenta kuin amne ni nakwente abko nibi dikekäta kuin kröta. Erere arato, ni bren bren lebra kisete abko kwata nibi nebeta kuin jökrä amne ni olo ngidianinte abko ie ni kukwei nibi ruenta kuin. Erere arato, ni krütanikrütani abko nibi nüketa nire amne ni bobre bobre abko ie Ngöbö kukwei kuin mika nibi gare abko munkwe nie Juanye. ");
INSERT INTO gymNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Erere arato, nire nire käta tödeke tibti amne ti ne ara nükani tä nütüre amne ñan tä trö kwite tie, ni ye abko ie Ngöbökwe ja di biandi amne ni yebtä kä rabadi nuäre tikwe nini abko munkwe nie kore Juanye. Abko kore se, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yebti nitre juani Juankwe ye nikaninta angwane, nitre nämane yete ye ben Jesu rikaba blite krörö Juanbtä: ¿Mun nikani ni ño tuakäre kä kaibete? ¿Mikä juankata mürekwe nekwäre sekwäre, ye käta ni töi kwitaka jene jene nekwäre sekwäre bä mike, ni ye kwrere tua nikani munkwe ya? ");
INSERT INTO gymNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Mun nikani ni kore tuen ñakare ne ngwane, mun nikani ni ño tuakäre? ¿Ni ja ükaninte kuin käkwe dän ütiäte kri kitani jabtä nämane yete abko mun nikani tuen ya? Ñakare, ñobtä ñan angwane ni dän ütiäte kri kitani jabtä, ni ye kwrere abko tä nüne jrei gwiriete amne ñan tä nüne kä kaibete abko garera munye ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Akwa mun nikani ni ño mike ñäräre metre kä kaibete? ¿Mun nikani ni Ngöbö kukwei niekä mike ñäräre ñan ñan? Jänri, mun nikani ni kore mike ñäräre, akwa Juan ye abko bäri Ngöbö kukwei niekä kri abko mun nikani tuen. ");
INSERT INTO gymNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan ye mdenbtä tärä tä tikani krörö Ngöbö Kukweibtä. Ngöbökwe niebare: Tikwe ja kukwei ngwianka juandi iti ma känenkri. Niarakwe ni töi mikadi biare ma käne, ji ükateta biare ye kwrere, abko tä tikani kore Ngöbö Kukweibtä Juanbtä. ");
INSERT INTO gymNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne aisete, ti bike kukwe era erere niere munye abko krörö: Ni jökrä därebare kä nebtä, ye ngätäite ni ñakare jire iti abko bäri ütiäte Juan Bautistakrä; akwa nire nire bäri bobre, ütiäte ñakare, bti Ngöböta gobrane, ni ye abko bäri ütiäte Juankrä. ");
INSERT INTO gymNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Juan Bautista nükani, ye ngwane mentokwäre abti kä nüke mtare abko Ngöbö rükadre gobrane nibti abko tä niren mentokwäre Ngöbö di kribti, akwa Ngöböta gobrane nibti ye rüe tärä arato abko töta nebe juain ngwarbe. ");
INSERT INTO gymNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mdakäre abko, Ngöbö Kukwei jire jökrä tä blite tibtä, yebti Juan jatani nüke. ");
INSERT INTO gymNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ni Ngöbö kukwei niekä kira kädian nämane Elías abko rükadreta nieta Ngöbö Kukweibtä, ye abko Juan ye ara btä tä niere kore abko tita niere munye. Ne abko mun mden mden tö raba ti kukwei mikai era käkwe mika era. ");
INSERT INTO gymNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nire nire käta ti kukwei nuen, ye käkwe ti kukwei ketate ja olote. ");
INSERT INTO gymNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Mdakäre abko, mun nünanka kä ne näire abko ti bike bä mike krörö: Kä jändrän rürümoinkrä jutate, känti ngäbäkre tä nebe täkänintbe temen, käta ñäke krikri mräkä mda mdaye, yebtä ti bike mun bä mike krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ngäbäkre tä niere mräkäye: Nunkwe nörä jürü tärä mikakrä munye, akwa mun ñan tö nibi tärä mikai, abtä ka ni moto mikakrä ulire abko nunkwe nini mda, akwa munkwe müaniri ñakare arato abko ngäbäkreta niere. Ye mden kwrere munta niere Juanbtä amne tibtä, aisete tita mun bä mike kore. ");
INSERT INTO gymNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan nükani angwane, üai käme tä btä, aisete ñan tä mröre kri amne ñan tä dö ñaen, munta niere rüere. ");
INSERT INTO gymNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Yebti ti, Ni Kä Nebtä Ngobo rükaba mda angwane, ti abko mröre büle krikri amne ti dö ñaen krübäte munta niere tibtä. Mdakäre abko, ti ja getaka ni diän diän ben amne nitre jändrän ütiä käräkä gobran romanobokrä tä tuen käme munye abko ben tita ja gete, abtä munta ñäke ti rüere arato. Ye mdenbtä abko mun ngäbäkre kwrere tita niere, akwa ni nüne töbtä era metre Ngöbö diebti nun kwrere, yebtä abko nun abko ni jen Ngöbökwe era metre abko nunta bä mike. ");
INSERT INTO gymNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yebti juta känti sribi kri ñan tuabare nuenbare kabre Jesukwe, akwa nitre nünanka yete käkwe ja töi kwitaninta ñakare Ngöbö kukwäre, yebtä abko Jesukwe ñäkäba ietre, käkwe nieba krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","¡Aingwaree mun nünanka juta Corazínte amne juta Betsaidate! Mun bobre jakän, ñobtä ñan angwane sribi kri ñan tuabare nuenbare tikwe mun ngätäite, ne kwrere nuendre juta Tiro amne Sidón känti, akräke nitre yete käkwe ja töi kwitadreta Ngöbö kukwäre amne, dän ngutu jüräre kitadre kwetre jabtä amne rabadre täkänintbe ngübrünte ja moto ulire kukwe kämekäme nuenbtä bä mikakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ye mden kisete, Ngöbökwe kukwe ükadite ni jökrä kräke kä mrä angwane, Ngöbökwe mun nünanka juta Corazínte amne juta Betsaidate mikadi ja tare nike bäri kri nitre nünanka juta Tirote amne Sidónte ye kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¿Amne mun nünanka juta Capernaúmte, mun ye abko Ngöbökwe mikadi bäri ütiäte, munta nütüre ya? Ñakare, ñobtä ñan angwane Ngöbökwe mun ye kitadikä kä ja tare nikakrä känti, ñobtä ñan angwane sribi kri ñan tuabare namani bare mun ngätäite nete, ye kwrere rabadre bare juta Sodomate, akräke juta ye tädre mtare. ");
INSERT INTO gymNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ye mden kisete, Ngöbökwe kukwe ükadite ni jökrä kräke kä mrä angwane, Ngöbökwe mun mikadi ja tare nike bäri nitre nünanka juta Sodoma ye kräke abko tita niere metre munye. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Yebti Jesukwe blitaba Ngöböbe, käkwe nieba krörö: Ti Rün, ma abko kä käin amne kä temen Dänkien. Tita ma käikitekä, ñobtä ñan angwane nitre bikaka töbtä krikri abko okwäte makwe kukwe metre makwe ye rükaninte, akwa ni bobre bobre töi ñakare ñakare ruen ie abko ietre makwe mikani gare, ");
INSERT INTO gymNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ma tö namani ño, erere makwe nuenbare. Yebtä tita ma käikitekä, nieba Jesukwe Rün Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yebti nitre näma Jesu kukwe nuen, ye ie Jesukwe nieba mda: Ti Rün käkwe jändrän jökrä mikani gare tie. Niara aibe ie ti gare. Erere arato, ti Rün gare ñakare ni mda mdaye, akwa ti niara Odei ne aibe ie niara gare amne ti tö rabare mikai gare nire nireye, ye erere ie rabadi gare. ");
INSERT INTO gymNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mun mden mden dräre amne tribe doboko mun kötärä, mun ye abko jakwe jökrä tie amne tikwe mun mikadi jadüke. ");
INSERT INTO gymNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Amne kri oto mäkäta nbi dokwäbtä tä niken ngwena, ye kwrere ti bike sribi tikwe bien ngwiandre munye, ye abko munkwe ka ngäbti abti munkwe ja töitika tibe, ñobtä ñan angwane ti abko moto jäme amne tita bike tidrä ni mda mdabtä, yebtä munkwe ja töitika tibe amne munkwe jadükadi jäme, ");
INSERT INTO gymNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ñobtä ñan angwane ja töitika tibe ye abko kri oto doboko mäkäta nbi dokwäbtä abko tä niken ngwena, ye kwrere tita tribe mike mun kötärä ngwiandre munye, ye abko juto amne nuäre ngwiandre. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Abti bati Jesu rikaba dikekä nura ngätäite köbö jadükakrä näire mda angwane, nun ja töitikaka ben, ie mrö rababa krübäte. Abtä nun rikaba trigo ngwä ötö ji ngrabare amne nun rikaba kwete. ");
INSERT INTO gymNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Angwane nitre bariseo näma näin siba nunbe käkwe nun tuaba amne nieba kwetre Jesuye: Jändrän ñan nuendre jire chi köbö jadükakrä näire nieta abko nitre ja töitikaka mabe nibi nuene tuen sete, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Abtä Jesukwe nieba mda ietre: Bati David btä rükä kwekwe ie mrö namani krübäte angwane, kukwe nuenbare krörö kwetre: Ju nuäre ngwiandre känti ban deme nämane mikani Ngöbö ngwärekri, ye känti David nikani gwä, ban diani kwe, bti kwetani kwe rü muko kwekwe ben. Ban ye abko, David btä nitre nämane ben käkwe ñan kwetadre jire chi, ñobtä ñan angwane nitre blitaka Ngöböbe ni mda mda diäre aibe käkwe kwetadre niebare Ngöbökwe, akwa niaratre käkwe kwetani, akwa namani ngite ñakare. Kukwe yebtä mun tärä ñäke Ngöbö Kukweibtä ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Erere arato, ju blitakrä Ngöböbe känti nitre blitaka Ngöböbe ni mda mda diäre tä sribire köbö jadükakrä näire, akwa Kukwe Biani Ngöbökwe Moiséye ye käta mike ngite ñakare arato, yebtä abko mun tärä ñäke arato ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ye abko, ju blitakrä Ngöböbe abko ütiäte kri, akwa nitre blitaka Ngöböbe ni mda mda diäre ñakare ngite, akwa nita iti nete abko bäri ütiäte ju blitakrä Ngöböbe ye kräke abko ti tö nibi niei munye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ngöbö Kukwei käta niere krörö ne abko ngämi nüke gare munye. Ngöbökwe niebare: Munkwe ni mda mda ngwiandre ruentari tare jae, ye abko ie ti tö bäri. Akwa mun tädre jändrän bien jirekäbe kukwadre tie, ye abko ie ti ñan tö bäri, niebare Ngöbökwe. Kukwe ye ngämi nüke gare metre munye ruen tie, ñobtä ñan angwane rabadre gare metre munye, akräke ni ja mike ngite ñakare ye munkwe ñan kitadre ngise ngwarbe, munta nitre ja töitikaka tibe kite ngise ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Akwa köbö jadükakrä näire yebti ta ti Ni Kä Nebtä Ngobo abko bäri ütiäte, aisete nitre ja töitikaka tibe rabadre dre dre nuene köbö jadükakrä näire abko ti di tärä niere ietre. Abko kore se, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yebti Jesukwe kä mikakaba kä ye känti, bti rikaba sinagoga mdate. ");
INSERT INTO gymNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Sinagoga ye känti Jesu rababa angwane, ni iti küde ngrötani kwärä näma yete angwane, nitre bariseo tö rababa Jesu kitai ngise, käkwe nieba ie: ¿Kukwe Biani Ngöbökwe Moiséye tä kä bien nie ni bren miketa kuinta köbö jadükakrä näire ya? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Angwane Jesukwe nieba mda ietre: ¿Mun mden kwe obeja tädre krati abko köbö jadükakrä näire betadrekä nguse munkän, ye mun ñan janandre dentari jakrä ya? Jänri, mun janandre dentari jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ni bäri ütiäte obejakrä, ye mdenbtä abko ni rabadre ni bren miketa kuinta köbö jadükakrä näire abko Kukwe Biani Ngöbökwe Moiséye käta köböi bien nie, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ye btäräbe Jesukwe nieba ni kise ngrötani yeye: Küde ngököte, nieba kwe ie. Ye btäräbe ni ye käkwe küde ngökateba angwane, kise rababata kuin jökrä ie, kise kuin kwäräkri ye kwrere kise rababata. ");
INSERT INTO gymNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Yebtä abko nitre bariseo rikaba ju bäre mda amne Jesu kämikadre ño kwetre abko rikaba kädriere kena jabe kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nitre bariseo rababa kukwe miketbe kore Jesu rüere, ye gaba Jesukwe angwane, kä mikakaba kwe yete, akwa rikaba angwane, ni rikaba kwati ben. Ye ngwane abko ni bren bren erere Jesu rababa miketa kuinta jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Akwa Jesu käkwe ñan ja kädriemna ni mda mda ngwärekri nitre mikaninta kuinta kwe yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kukwe niebare krörö Ngöbökwe niara kukwei niekä Isaías köböire rabadre bare, abkokäre kukwe rakakaba kore: ");
INSERT INTO gymNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Monso tikwe abko tä nete ne tuen. Tikwe niara ne dianinkä jenena jakrä. Niara tare kri tikwe amne käi nuäre kri tibtä. Niara nebtä tikwe ja Üai mikadi nüne amne nitre ñakare israelitare, kräke Ngöböta kukwe miketbe kuin abko mikadi gare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Erere arato, niarakwe ñan ñäkädi ja dokwäre amne kukwe ñan jaradre ji ngrabare ngrente ja dokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nitre bobre bobre tä mikä kroko trekani kwrere, ye abko niarakwe ñan juandi ngwarbe. Erere arato, ñotra jutra mikata krire amne ngübü aibe tä nebe neen krä chi käne, ye kwrere nitre tödekaka krire niarabti tä, ye abko niarakwe ñan di gadrekäta jire chi abti Ngöbö jatadi kukwe ükete metre nikrä ni rüebe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Amne nitre ñakare israelitare abko käkwe tödekadi niarabti, abko niebare kore Isaíakwe abko erere rababa bare Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yebti ni iti ie kä tuen ñakare amne kukwe ñakare arato abko btä üai käme nämane nüne abko järükaba Jesu känti angwane, Jesukwe mikabata kuinta, aisete kä rababa tuenta ie, rababa blite kuin amne üai käme juantariba mento btä Jesukwe arato. ");
INSERT INTO gymNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yebtä abko nitre näma Jesube yete abko ñan töi rababa krütare jökrä Jesubtä, kä rababa niere: ¿David mräkäkri Ngöbökwe ni diandrekä iti abko rükadre niebare, ni ye abko Jesu noko ara ya ño amarebti se? rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Akwa kukwe ye jarabare nitre bariseoye angwane, rababa niere krörö Jesu rüere: Üai käme dänkien kädianta Beelzebú, ye aibe käkwe ja di biani ni nokoye abko diebti tä üai kämekäme juentari mento se, rababa niere Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nitre bariseo rababa töbike blo kore Jesu rüere, ye Jesukwe gaba btätre, abtä nieba kwe mda ietre: Kä mdente erere känti nitre nünanka yete käkwe ja ñäkädrebti ketebu rükäre jabe kwärikwäri, ye ngwane nitre ye tä kä juen ngwarbe au jakän. Erere arato, juta amne ni ja mräkäre nünanka ketetibe käkwe ja ñäkädrebti ketebu rükäre ja rüere kwärikwäri, ye ngwane nitre ye ñan rabadre nüne jire chi mda ketetibe, aisete juta amne ju juandre ngwarbe au jakän kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ye kwrere arato, Satana ara käkwe ja juandretari mento angwane, Satana ara jire tätre rüre ja rüere ñan ñan. Satana käkwe ja ñäkädrebti ketebu ja rüere kwärikwäri au, ye ngwane Satana di tädre kri janknu ya niere tie munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Üai käme dänkien kädianta Beelzebú, diebti tita üai käme juentari mento munta niere tibtä, aisete nitre reketaka munkri ye abko ie nireta ja di bien üai käme juantarikrä mento abko ti tö nibi ngwiaintari munye. Niaratre tä üai käme juentari arato, aisete munta ñäke blo tibtä abko bä mikata niaratrebtä, aisete mun kitadre ngise kwetre ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Akwa tita üai käme juentari mento Ngöbö Üai Deme diebti era metre, ye ngwane Ngöbö nükanina gobrane mun ngätäite abko bä mikata tikwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kukwe nebtä abko ti bike kukwe bä mike krörö: Satana abko ni dite kwrere. Ni dite tä ju jen kwe ngibiare ni gokä ngäniene angwane, ni dite nünanka gwi ñan mäkärete angwane, ni gokä ñan raba jire iti, kä rabadre jändrän kwe denkä kän. Akwa mäkärete angwane, ni gokä rabadre jändrän kwe denkä jire jökrä kän. Ye kwrere ni ye btä üai käme tä abko ju Satanakwe kwrere. Ti bäri dite Satanakrä aisete, ti raba üai käme juentari mento nibtä Satanakän, ni gokäta jändrän denkä ni dite kän ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ye abko nire nire ñan tä nekete tibe, ni ye abko tä rüre ti rüere amne, nire nire ñan tä sribire gwaire tibe abko tä sribi tikwe metekä jirekäbe tikän. ");
INSERT INTO gymNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ne aisete ti bike niere krörö munye: Ni kä nebtä käkwe ja mikadre ngite ño erere Ngöbö rüere amne ñäkädre taretare kwe Ngöbö rüere, akwa ye Ngöbökwe diandrekä mento btätre; akwa ñäkädre käme taretare kwe Ngöbö Üai Deme ara jire rüere ne ngwane, Ngöbökwe ñan diandrekä jire chi mento btä. ");
INSERT INTO gymNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Erere arato, ti Ni Kä Nebtä Ngobo, rüere nire nire käkwe ñäkädre taretare, akwa ye abko Ngöbökwe diandikä mento btä; akwa nire nire käkwe ñäkädre käme taretare Ngöbö Üai Deme ara jire rüere ne ngwane, Ngöbökwe ñan kukwe ye diandrekä jire chi mento btä, aisete rabadi ngite kärekäre Ngöböye kä ne ngwane amne kärekäre rabadi ngite janknu Ngöböye abko ti tö nibi niei munye, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yebti Jesukwe niaratre kukwei bä mikani kri ngwä kwrere, käkwe nieba mda ietre: Kri kuin aibe ngwäta nebe kuin amne kri käme aibe ngwäta nebe käme arato, aisete kri ngwä ño ño yebtä abko kri mden kuin amne mden käme abko tä nüke gare nie. ");
INSERT INTO gymNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Mun abko tbi krübäte kwrere jire, aisete mun moto amne mun töi kämekäme, ye abko munkwe kukwe kuin niedre ño se. Ni moto ño amne ni töi ño, ye kwrere nita blite. ");
INSERT INTO gymNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ne aisete ni moto kuin ne ngwane, nita blite kuin ni mda mda die mikakrä, akwa ni moto käme ne ngwane nita blite ngwarbe diän diän jirekäbe, ye abko ñan tä ni mda mda die mike, ñobtä ñan angwane niara abko töi käme, yebe tä nüne. ");
INSERT INTO gymNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Akwa ti bike kukwe era erere niere munye abko krörö: Kä mrä angwane, Ngöbö jatadi kukwe ükete ni jökrä kräke angwane, ñobtä munkwe kukwe diän diän niebare ngwarbe ye abko mikadi gare jökrä Ngöbö ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ne aisete mun kukwei jen munkwe ye ara jire köböire mun ngite ñakare, niedi Ngöbökwe munye o, mun ngite, niedi kwe munye arato. Abko kore se, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yebtä abko nitre bariseo amne Kukwe Biani Ngöbökwe Moiséye dirikätre käkwe nieba mda Jesuye: Dirikä, Ngöbökwe ma juani bkänä ya, ñakare ya abko nun tö nibi gai metre, aisete sribi kri ñan tuabare nuene jötrö nun okwäbti tuadre nunye nete, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Abtä Jesukwe nieba mda ietre: Mun nünanka kä ne ngwane abko moto kämekäme amne munta Ngöbö tarere munta niere, akwa käre munta niara tuemetre, abtä tikwe sribi kri ñan tuabare aibe nuendre mun okwäbti, ie mun töta nebe, akwa sribi kri ñan tuabare ye tikwe ñan nuendre jire chi mun okwäbti, munta ribere ye kwrere. Akwa Ngöbö nämane Jonábe, käkwe sribi kri ñan tuabare nuenbare Jonákrä, ye kwrere aibe Ngöbökwe bä mikadi mun kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás käkwe nünabare köbömä dibire rare gwa kri teri, ye kwrere arato ti, Ni Kä Nebtä Ngobo ne rabadi köbömä dibire rare dobote nguse. ");
INSERT INTO gymNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ngöbökwe kukwe ükadite ni jökrä kräke kä mrä angwane, nitre nünanka kira juta Nínivete abko käkwe mun nünanka mtare ye kitadi ngise, ñobtä ñan angwane Jonás nikani Ngöbö kukwei niere nitre Níniveboye angwane, niaratre käkwe Ngöbö kukwei mikani täte amne kukwe kämekäme kitani jökrä temen kwetre Jonás kukwei köböire. Akwa tita nete mtare abko bäri ütiäte kri Jonákrä amne mun ñan tö ti kukwei mikai era jae, aisete rakadikä kore munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Erere arato, Ngöbökwe kukwe ükadite ni jökrä kräke kä mrä angwane, jreina nünanka mobe mötarikri nükani kira basare jrei Salomónye ye käkwe mun kitadi ngise arato, ñobtä ñan angwane Salomón nämane kukwe töbtä töbtä niere, ye jreina mobe jatani kukwe nuen jakrä, akwa tita nete abko bäri ütiäte kri Salomónkrä abko mun ñan tö ti kukwei nuai, aisete rakadikä kore munbtä, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yebti Jesukwe nieba: Mdakäre abko, ni iti btä üai käme tädre nüne, abti üai käme ye juandretari mento btä, üai käme rikadre ngwarbe kwäräkwärä kä känene jadükakrä jae kä kaibete, akwa kä ñan kwandre jire chi ie jadükakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Abtä rabadre töbike krörö: Ni nämane ju kwrere tikwe abko te ti nämane nüne, ye känti ti bike nikenta, üai käme rabadre nütüre. Ye erere bkänä, üai käme ye rikadreta ni ye känti, rabadreta yete angwane kä sökaninkä merebe gwita temen amne kä ükaninte kuin gwita, akwa kä tökare, ni ñakare nüne gwi, kwrere jire ni ye kwandre üai kämeye. ");
INSERT INTO gymNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Angwane jötrö ngwarbe üai käme ye rikadre betekä, käkwe üai bäri kämekäme niarakrä känändre krä kükü mda ja mukore, bti rikadre nünenta jökrä ni yebtä. Üai käme ye rabadrera nünenta kore ni yebtä angwane, ni ye rabadre ja tare nike bäri krübäte mda üai käme kisete, ye kwrere rakadikä mun nünanka kä ne ngwane yebtä. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu näma blite kore angwane, niara meye btä etbakantre rükaba jiebti abko tö rababa blitai ben, akwa niara meye btä etbakantre rababa ju bäre, ");
INSERT INTO gymNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","aisete ni iti käkwe nieba Jesuye: Ma meye amne ma etbakantre tä ju bäre nokote abko tö nibi blitai mabe, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Abtä Jesukwe nieba mda ni yeye: ¿Nire abko ütiäte tikrä ti meye kwrere amne nire abko ütiäte tikrä ti etbakantre kwrere amarebti ye? nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Bti nitre ja töitikaka ben näma yete, yebtä kise kitaba kwe, käkwe nieba mda: Nire nire ütiäte ti meye tikwe kwrere amne ti etbakantre kwrere era metre abko erere tä nete ne, ");
INSERT INTO gymNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ñobtä ñan angwane ti Rün kä käinbti ye nire nire käta kukwei mike täte, ni ye abko ti etba tikwe, ti ngwai tikwe amne ti meye tikwe. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Abti Jesu rikaba ju bäre angwane, rikaba Ñö Okwä Kri Galilea, känti rababa täkänintbe ñö okwä köräbti. ");
INSERT INTO gymNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ye ngwane abko, ni kwati käkwe ja ükakröba niara kukwei nuakäre. Abtä Jesu rankwaba rute, rababa täkänintbe amne, nitre käkwe ja ükakröba kwati btä ye abko rababa jökrä ñö köräbäre jateta temen. ");
INSERT INTO gymNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Angwane Jesukwe kukwe keta kabre bä mikaba dirikäre ietre, käkwe nieba krörö: Bati ni nikani iti nura metekä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nura metaninkä kwe angwane nura ruäre nikani mate ji ngrabare temen, ye abko nukwä jatani, käkwe kwetani jökrä kän. ");
INSERT INTO gymNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nura ruäre abko nikani mate jäkwatabti temen, ye känti abko dobo ñakare bökän, aisete nura ye nükani mure jötrö, akwa dobo ñakare mente nguse, ");
INSERT INTO gymNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","bti ñänä jatani ngire, käkwe nura mu ye kukwani jökrä amne ngätri ñakare arato, aisete ngrötaninkä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nura ruäre abko nikani mate kökrä tukwätetukwäte ngätäite, ye abko nükani mure arato, akwa kökrä ye abko rirabare bäri jötrö nura mu yebti ta, käkwe kämikani. ");
INSERT INTO gymNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Akwa nura ruäre abko nikani mate dobo kuinte, ye abko nükani mure amne, rirabare tuärebe amne ngwä namani kabrekabre btä. Datire datire ngwä namani gre ketarike, ruäre abko ngwä namani gre ketamä amne ruäre abko ngwä namani gre bti krä jätä btä. Ne abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nire nire käta ti kukwei nuen, ye abko olo tärä ne ngwane, ti kukwei ne ketate ja olote kwe, kukwe ne rükadre gare kuin munye abkokäre, nieba Jesukwe ni kwati yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Angwane nun ja töitikaka Jesube käkwe krötaba ja ken ben, käkwe nieba krörö ie: Ñobtä mata kukwe bä mike bti mata dirire nitre kwati seye, nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Abtä Jesukwe nieba mda nunye: Ngöbö rükadre gobrane ño nibti abko tä tiebe, akwa Ngöböta mike gare munye, akwa nitre se abko ie Ngöböta mike gare ñakare, aisete tita dirire kore. ");
INSERT INTO gymNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mdakäre abko, nire nire ie Ngöbö Kukwei nüke gare, ye abko ie Ngöbökwe ja kukwei biandi bäri mda amne Ngöbö Kukwei rabadi gare bäri kabre mda ie; akwa nire nire ie Ngöbö Kukwei gare ñakare, ye abko ie Ngöbö Kukwei gare kiakia abko Ngöbökwe diandikä jökrä kän. ");
INSERT INTO gymNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ye mden kisete, tita kukwe bä mike btä tita dirire nitre kwati seye, ñobtä ñan angwane nitre se ie kä tuen kuin kwrere, akwa tita sribi nuene okwäbti abko tuen ñakare ietre. Erere arato, ni kukwei ruen kuin ietre kwrere, akwa tita blite abko ñan tä nebe nüke gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kukweta nakenkä kore nitre sebtä mtare angwane, kukwe niebare ni Ngöbö kukwei niekä Isaíakwe abko tä neme bare abko krörö: Munkwe ti kukwei nuadi blite bäri, akwa tita dre niere ñan rükadi gare munye. Erere arato, tita sribi nuene mun okwäbti, ye abko munkwe tuadi bäri, akwa drekäre tita sribi ye nuene abko ñan jatadre munye, ");
INSERT INTO gymNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ñobtä ñan angwane nitre noko käkwe ja dokwä mikanina ribi ti kukwei kräke, aisete ñan tö namani sribi tikwe tuai. Erere arato, ñan tö namani ti kukwei nuai, käkwe ja olo gu dikani ti kukwei ngäniene amne, ñan tö namani sribi tikwe tuai, abkokäre ja okwä jue mikani kwetre. Mdakäre abko, ti kukwei ñan rükadre gare ietre amne tikwe ñan diandretari, abkokäre nuenbare kore kwetre, niebare Isaíakwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Akwa mun abko btä kä rabadre nuäre, ñobtä ñan angwane mun abko okwä tärä sribi tikwe tuakäre amne mun olo tärä ti kukwei nuakäre, ye abko käi rabadre nuäre munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ne aisete ti bike kukwe era erere niere munye abko krörö: Sribi tikwe tuata ja okwä jenbti munkwe amne ti kukwei nuata ja olo jenbti munkwe, ye abko nitre Ngöbö kukwei niekä kwati nünanka kira amne nitre nünanka metre Ngöbö ngwärekri kwati abko tö namani tuai amne tö namani kukwei nuai, akwa erere tuani ñakare kwetre amne kukwe nuani ñakare kwetre kira, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesukwe nieba mda: Mdakäre abko, ni nura metakaka, btä tikwe kukwe bä miri ye abko tä dre niere metre abko kukwe nuen munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ngöbö kite gobrane ni ngätäite, ye abko nire nire käta kukwe nuen, akwa ñan tä nüke gare ie, ni ye abko nura nikani mate ji ngrabare ye kwrere, ñobtä ñan angwane Ngöbö Kukwei tä nebe nura kwrere btä, akwa diablu tä kite, käta Ngöbö Kukwei ye denkä jökrä töite, mden nini tikwe ye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amne ni ruäre abko käta Ngöbö Kukwei nuen, ye btäräbe käta nebe nuäre btä kare ngäbti, ni ye abko nura nikani mate jäkwatabti ye kwrere, ");
INSERT INTO gymNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ñobtä ñan angwane nura nikani mate jäkwatabti abko ngätri ñan nämane bökän, ye kwrere jire ni ruäre tä Ngöbö Kukwei kaen ngäbti, bti bä jötrö tä näin Ngöböbe, akwa tädre niken ja tare nike tödekabtä Ngöböbti, ye btäräbe tä Ngöbö Kukwei kiteta temen, bti tä nikenta ja jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Amne ni ruäre abko tä Ngöbö Kukwei nuen, akwa tä nakwen bäri jändrän kä nebtä jiebti, erere tä ja töi mike bäri sribi kä nebtä jiebti amne tä ngwian tarere bäri, ye abko käta ngökö. Ne aisete ni ye abko nura nikani mate kökrä tukwätetukwäte ngätäite amne ngatani, ye tä nakenkä ni yebtä, aisete nura ngatani ngwä namani ñakare, ye kwrere jire ni ye tä sribi nuene ñakare Ngöbökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Akwa ni ruäre tä Ngöbö Kukwei nuen amne tä nüke gare ie, käta niken sribi kuinkuin nuene bätäkä ngwarbe Ngöbökrä, ye abko nura nikani mate dobo kuinte abko rirabare kuin amne ngwä kuinkuin namani gre ketarike, ruäre gre ketamä, ruäre abko gre bti krä jätä, kwrere jire ni ye tä sribi nuene Ngöbökrä abko kukwe kore bä miri tikwe ye, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yebti ni jen Ngöbökwe rabadre nüne ni kämekäme ngätäite abti kä mrä angwane Ngöbökwe mikadi nüne jenena jabe, ye bä mikakäre Jesukwe nieba krörö ni kwati yeye: Ngöböta kite gobrane nibti ye rüere abko kukweta niken nakenkä, ne kwrere ti bike niere munye: Bati ni iti käkwe trigo nurai kuin metaninkä tirete jakrä, ");
INSERT INTO gymNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","akwa ni jökrä nikani kibien angwane, kä bkänkä ye rüe jatani tiebe käkwe nura käme nökani trigo nurai kuin ye ngätäite, bti nikaninta. ");
INSERT INTO gymNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yebti trigo rirabare, namani ngwäre angwane, nura käme ye ngwä namani arato abko sribikätre käkwe gani. ");
INSERT INTO gymNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Angwane sribikätre ye nikani kä bkänkä känti, käkwe niebare ie: Nun dänkien, makwe trigo nurai kuin metaninkä tirete jakrä, ¿se ño känti abko nura käme se namanina tirete mae arato se? niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Abtä kä bkänkä käkwe niebare ietre: Ti rüe nükani iti nura käme metekä tiebe tirete tie kwrere ye, niebare kwe. Angwane sribikätre ye käkwe niebare mda ie: ¿Nun rikadre nura kämekäme se erere jäkekä jökrä, ie ma tö nibi ya? niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Akwa kä bkänkä käkwe niebare mda ietre: Ñakare. Mun ñan rika jäkekä, ñobtä ñan angwane mun rikadre nura mu kämekäme ye jäkekä mtare angwane, trigo mu kuin ye räkädrekä ben gwaire siba. ");
INSERT INTO gymNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ne aisete tuadremetre niren ketetibe abko trigo öta näire angwane, tikwe trigo ötaka juandi ye abko käkwe nura kämekäme ye erere ükadikrö käne jenena mento, bti mäkädite jökrä kwetre, käkwe kukwadi ñukwäte amne trigo ngwä kuinkuin ye erere abko ötadi kwetre, bti ju nura ngwä ükakrä tikwe, ye känti kitadi gwi kwetre tikrä, niebare kä bkänkäkwe abko nakaninkä kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yebti Jesukwe kukwe mdara jire bä mikaba, käkwe nieba: Ngöböta kite gobrane nibti ye abko mostasa nurai chi kwrere. Ni iti käkwe mostasa nurai nökani tirete jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nura jökrä munkwe, ngätäite mostasa nurai ye abko bäri kiakia, akwa nökadre tirete angwane, rabadre bäri kri nura jökrä bti ta angwane, nukwä jatadre nüne mostasa krie ye küde ngrabare, ye kwrere jire käne Ngöböta kite gobrane ni braibe bti, akwa mrä angwane Ngöbö rabadi gobrane ni kwatibti abko bä mikata nura chi yebtä, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Erere arato, Jesukwe kukwe mdara jire bä mikaba, Ngöböta gobrane ni braibe bti käne, akwa mrä rabadi gobrane ni kwatibti ye bä mikakäre, käkwe nieba krörö: Ngöböta kite gobrane nibti, ye abko rabadi niren lebadurata niren ye kwrere abko krörö: Meri iti käkwe lebadura kitani chi arina kabre te, bti mritani kwe abti lebadura nikani arina kabre ye ñäre jökrä, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesukwe kukwe bä mikaba jökrä kore, btä blitaba kwe ni kwatibe amne niara nämane dirire angwane, käre kukwe bä mikaba kwe, aibebti diriba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jesukwe diriba kore, yebtä abko ni Ngöbö kukwei niekä kira käkwe kukwe niebare abko erere rababa bare abko krörö: Tikwe kukwe bä mikadi, bti tikwe blitadi amne, Ngöbökwe kä dätebare kena, abti kä nüke mtare kukwe ruäre nämane kaibe tiebe Ngöbökwe abko tikwe niedi, abko ni Ngöbö kukwei niekä käkwe niebare kore Jesubtä, ye erere rababa bare. ");
INSERT INTO gymNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yebti Jesukwe nitre kwati ye mikateba yete, bti rikabata nebeta gwi. Angwane nun ja töitikaka ben käkwe krötaba ken, käkwe nieba ie: Nura mu kämekäme namani tirete makwe nini, ye abko tä dre niere metre abko makwe niedreta nunye abko nun tö nibi ribei mae, nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Angwane Jesukwe nieba mda nunye: Ti, Ni Kä Nebtä Ngobo ne abko nura kuin metakaka ");
INSERT INTO gymNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","amne kä temen ne abko tire kwrere. Nire nire bti Ngöböta gobrane ye abko trigo nurai mu kwrere amne nire nire tä nekete diablukri ye abko nura kämekäme mu ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Amne ti rüe nura kämekäme metakaka ye abko diablu ara jire amne, kä nura öta näire ye abko kä mrä kä ne näin ta abko bä mikata amne nitre nura ngwä ötaka ötaka abko angeletre Ngöbökwe. ");
INSERT INTO gymNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Amne nura kämekäme ötata, bti kitata ñukwäte kukwadre, ye kwrere rakadikä kä mrä angwane, ");
INSERT INTO gymNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","aisete kä mrä angwane ti Ni Kä Nebtä Ngobo ne käkwe angeletre tikwe juandi angwane, nitre bti Ngöböta gobrane, ye ngätäite nire nire köböite ni mda mda tä ja mike ngite Ngöbö rüere amne nire nire kukwe nuenkä kämekäme Ngöbö rüere abko angeletre ye käkwe ükadikrö jökrä, ");
INSERT INTO gymNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","bti ñukwä jutra ngire krübäte te nitre ye kitadi jökrä kwetre. Ye känti abko ni jökrä rabadi ja müaire krikri be amne tu ngöbe rabadi cherere jabtä ja tare nika kisete. ");
INSERT INTO gymNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Angwane nitre nünanka metre Ngöbö ngwärekri abko btätre kä rabadi nuäre amne ñänä träta nebe dirare, ye kwrere jire kä rabadi btätre kä nuärete Rün Ngöbö kwe känti. Nire nire käta ti kukwei nuen käkwe kukwe ne ketate ja olote. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yebti Jesukwe nieba krörö mda: Kä gobrankrä Ngöbökwe abko ngwian kabre tädre rükaninte dobote nguse ye kwrere abko krörö: Ni iti nämane sribire ye känti ngwian kabre ütiäte kri ye kwani ie angwane, niara käkwe ngwian ye ükaninta känime kä ye känti. Abti nikani, käkwe jändrän kwe erere rürümoinbare jökrä, bti nikani käkwe kä ye kökani jakrä, niara rabadre ngwian kabre ye bkäne abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Mdakäre abko, ni bti Ngöböta gobrane, ngätäite kukweta nakenkä krörö arato: Ni iti jändrän ütiäte ütiäte rürümoinkä rikai perla kuin känene kökadre jae. ");
INSERT INTO gymNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Erere bkänä, perla kuin ütiäte kri kwani ie angwane, nikani käkwe jändrän kwe erere rürümoinbare jökrä, bti nikani käkwe perla ye kökani jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Erere arato, krade kitata ñöte angwane gwa bätäkä ngwarbe tä niken te, ye kwrere ti bike Ngöbö gobrain bä mike abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nitre gwa gaka tä krade kite ñöte gwaye. Yebti gwa tärä niken kabre kradete angwane, tädre jäke jate ñö köräbti. Tärä nebe ngwena ñö köräbti angwane, tätre niken ükekrö. Gwa kuinkuin erere tätre ükekrö kutiate jakrä amne gwa kämekäme abko erere tätre kitekä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ye kwrere kukwe rakadikä kä mrä angwane. Angeletre jatadi, käkwe nitre moto kämekäme Ngöbö rüere diandikä jenena nitre nünanka metre Ngöbö ngwärekri ye bäre mento, ");
INSERT INTO gymNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","bti nitre moto kämekäme Ngöbö rüere ye angeletre käkwe kitadi ñukwä jutrate. Ye känti niaratre rabadi ja müaire krikri be amne tu ngö rabadi cherere jabtä ñukwä jutrate ja tare nika kisete. ");
INSERT INTO gymNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yebti Jesukwe nieba mda: ¿Tikwe kukwe nini, ye nü gare jökrä munye ya? nieba kwe nunye. Jänri, nunkwe nieba käre. ");
INSERT INTO gymNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Angwane Jesukwe nieba krörö mda nunye: Ngöböta gobrane ño nibti, yebtä Kukwe Biani Ngöbökwe Moiséye dirikätre mden mden tätre ja töitike, ye ngwane ni ju bkänkä ye kwrere jire tätre nebe, ñobtä ñan angwane jändrän ño ño tä ükani kwetre gwi, ye ngätäite jändrän mden abko mräre amne mden abko kira diankata kwetre abko tä mike gare ietre, ye kwrere nitre dirikä käta kukwe mräre amne kukwe nakaninkä kira dirire, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesukwe kukwe bä mikaba jökrä kore, bti blitaba ünän jökrä kwe, bti kä mikakaba kwe kä ye känti amne rikabata ja käite. ");
INSERT INTO gymNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Rikaba nebeta ja käite Nazaret angwane, rikaba dirire sinagogate angwane, ni jökrä ñan töi rababa nebe krütare niara kukwei nuare, kä rababa niere jae kwärikwäri: ¿Ni noko käkwe ja töitikani mdente amarebti kukwe gare krübäte dikaro ie se? ¿Erere arato, sribi kri ñan tuabare se abko tä nuene ño amarebti tärä nebe bare ie se? ");
INSERT INTO gymNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","José sribikä kri kukwänbtä abko ngobo kwrere nibi tuen nunye. Erere arato, niara meye abko María amne etbakantre abko Santiago, José, Simón amne Judas ñan ñan. ");
INSERT INTO gymNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Mdakäre abko, ¿niara se ngwai tätre nüne jökrä ni ngätäite nete ruen tie ya amarebti mtare di kri dikaro se abko kwani mdenkri ie se? nitre nünanka Jesu käite ye rababa niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Amne Jesu kukwei namani tare btätre. Abtä Jesukwe nieba krörö ietre: Ni Ngöbö kukwei niekä mikata ütiäte kä mda mdabti, akwa ja käite btä mräkä juete abko mikata ütiäte ñakare nieta. Ye kwrere, mun ñan tä ti mike ütiäte jae. Abko kore se, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Angwane nitre nünanka kä ye känti ñan rababa tödeke Jesubti. Abtä sribi kri ñan tuabare abko Jesukwe nuenba ñakare kabre kä ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kä ye ngwane abko, Herodes Antipas nämane gobrane kä Galileate angwane, Jesu namani sribi kri ñan tuabare nuene abko gani kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Angwane nitre sribikä Herodekrä, ie Herodekwe niebare krörö Jesubtä: Juan Bautista tikwe kämikamna, ye ara jire Ngöbökwe mikaninta nire, aisete di tärä sribi kri ñan tuabare nuenkrä ye, niebare kwe sribikäye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodes käkwe niebare kore, ñobtä ñan angwane niara etba Felipe nän muko kädian nämane Herodías abko diani kwe kän. Yebtä abko Juan Bautista käkwe niebare Herodeye: Ma etba nän muko se makwe ñan mikadre jire ja ken kän, Juan nämane niere. Ye dokwäre abko Juan Bautista kamna ngite Herodekwe, bti kitamna ngite kä teri kwe, ye nükaninta töre ie, käkwe ñäkäbare kore. ");
INSERT INTO gymNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes tö namani Juan müre ketai ñäkä dokwäre jae Herodíabtä, akwa ni kwati nämane Juan mike ütiäte jae ni Ngöbö kukwei niekä kwrere, aisete nitre ye abko jürä namani Herodebtä. Abtä Juan müre ketani ñakare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Akwa bati Herodes därebare ye köböi erere nükaninta angwane, Herodekwe bieta nuenbare jae kä ngwiankäre nuäre jabtä. Ye erere ni jökrä nükani angwane, Herodías ngänkän bati nikani tärä mike kwäräkwärä se kwrere nitre nübaibare Herodekwe ye okwäbti. Herodías ngänkän namani tärä mike nuäre kwäräkwärä, ye abko käi namani nuäre krübäte Herodebtä, ");
INSERT INTO gymNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","käkwe ja kukwei biani krörö ie: Ma tö dreye erere makwe kärä tie angwane, tikwe biandi mae, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Angwane Herodías ye abko käkwe ngänkän ye töi diani, aisete niebare krörö kwe Herodeye: Makwe Juan Bautista dokwä mika blatote. Makwe bian tie nete, ie ti tö nibi, niebare kwe Herodeye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Yebtä abko, Herodes moto namani ulire mda, akwa nitre nübaibare kwe ye okwäbti ja kukwei biani kwe, aisete ñan tö namani ja kukwei kitaita temen, käkwe Juan dokwä biamna blatote Herodías ngänkänye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ye erere bkänä, Juan Bautista nämane ngite kä teri abko Herodekwe dokwä tikakamna, erere dokwä tikaninkä, ");
INSERT INTO gymNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","bti Juan dokwä ye mikani blatote, jänikani, biani Herodías ngänkän bati yeye angwane, niara käkwe bianinbe meye Herodíaye mda. ");
INSERT INTO gymNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yebti Juan nämane ngite, ye känti nitre nänkä ben nikani nebe angwane, Juan ngwäkä jänikani kwetre, bti doboi mikani kwetre. Abti Juan müre ketanina abko nikani niere Jesuye mda. ");
INSERT INTO gymNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan Bautista ara nükaninta nire abko Herodes namani nütüre Jesubtä, ye gaba Jesukwe angwane, kä mikakaba kwe kä ye känti mda amne rankwaba rute, bti rikaba kä kaibete Ñö Okwä Kri Galilea kwärä nakri. Angwane nun aibe rikaba Jesube, akwa Jesu rikaba ye nitre nünanka ja ken juta ngrabare yere käkwe gaba angwane, rikaba jökrä kä nötabti ta nebe Jesu ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yebti Jesu rikaba nebe ñö köräbti angwane näma rute, rankwaba timon, ye btäräbe nitre rababara kwati yete ngibiare ngäbti, btä okwä rababa. Angwane rababa tuen bobre Jesuye amne nitre bren bren ngwian nämane kwetre, ye Jesukwe mikabata kuinta jökrä kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Yebti kä jataba dere angwane, nun ja töitikaka Jesube käkwe krötaba ja ken ben, käkwe nieba ie: Kä kitera dere amne nita kä kaibete nete. Ne känti mrö ñakare, aisete nitre noko rikadre mrö kökö jae jutate, abkokäre juenta jirekäbe, nunkwe nieba. ");
INSERT INTO gymNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Abtä Jesukwe nieba mda nunye: Ñobtä niaratre rikadreta, ie mun tö nibi. Niaratre buke munkwe, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Abtä nunkwe nieba mda ie: Ban kunrikebe amne gwa krobu aibe tä nikwe, ¿se abko ni kwati se bukadre ño te? nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Angwane Jesukwe nieba mda nunye: Ban kunrike amne gwa krobu ye ngwen tie nete, nieba kwe. Ye erere nunkwe bianba ie. ");
INSERT INTO gymNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Angwane nitre näma kwati yete, ye Jesukwe juanba täke jökrä temen temen mikäbti, bti ban kunrike btä gwa krobu, ye Jesukwe dianba kisete, käkwe nikraba kä käinbti amne kuin nieba btä kwe Ngöböye, bti ötakaba oto kiakia kwe, bti bianba kwe nun ja töitikaka benye angwane, nunkwe dräiba jökrä nitre kwati yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nitre kwati ye käkwe mröba trinetrine jökrä, bti ni jökrä käkwe mröba ünän angwane, ban btä gwa oto rabateba abko nun ja töitikaka Jesube käkwe ükakröba kutia kwä jätäbti kubu jire. ");
INSERT INTO gymNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nitre kwati käkwe mröba yete abko ni brare brare aibe näma mili krärike jire käkwe mröba amne, nitre merire merire btä ngäbäkre bati kiakia käkwe mröba arato, akwa ye tanba ñakare abko rakakaba kore se. ");
INSERT INTO gymNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Yebti nun ja töitikaka Jesube abko rikadre niara käne nebe Ñö Okwä Kri Galilea ye kwärä nakri, ie Jesu tö namani, aisete nun juanba rute kwe, akwa niara abko rababa nitre kwati ye juenta. ");
INSERT INTO gymNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Abti nitre kwati ye nikaninante jökrä angwane, Jesu nikani kaibe nebe ngitiobti blitakäre Ngöböbe. Yebti kä namanina iko angwane, Jesu nämane kaibe ngitiobti blite Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Angwane ru te nun näma näin ye abko rikabara mente ñöbti amne kä jate abko rababa mobe köre. Angwane ñö jataba romon, rababa ru kitekä nekwäre sekwäre, ñobtä ñan angwane müre rababa mate nun ngäbti, ye abko rababa ñö kitekä kore, kä rababa ru ngrükete nunbe. ");
INSERT INTO gymNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Yebti kä jatabara ngwen ja ken dekä angwane, batibe Jesu rikaba dikekä ñöbti nun ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesu jataba dikekä ñöbti, yebtä nun ja töitikaka ben okwä rababa angwane, nun rekwetakaba krübäte amne nun rababa ngrente krikri be amne kä jürä rababa krübäte nunbtä käkwe nieba: ¡Ni bäkäi kite ni ngäbti ye! nun rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Akwa Jesu abko käkwe nieba nunye: Mun ñan rekwetaka ngwarbe. Tita näin, aisete munkwe ñan ti jürä ngwian, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Angwane Pedro käkwe nieba mda Jesuye: Ti Dänkien, ma ara tä dikekä ñöbti bkänä ne ngwane, ti rikadre dikekä siba ñöbti nebe ma känti abko niere tie, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jakwe, nieba Jesukwe ie. Ye erere bkänä, Pedro näma rute, rankwaba timon ñöte, rikaba dikekä ñöbti Jesu kukwäre. ");
INSERT INTO gymNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Akwa müre rababa mate dite Pedrobtä rababa tuen Pedroye, abtä rekwetakaba mda. Ye btäräbe jataba niken neen ñöte nguse, abtä ngrateba kri krörö kwe Jesuye: ¡Ti dentari ti Dänkien! nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ye btäräbe Jesukwe kaba küdebti, käkwe nieba mda ie: ¡Ye ñobtä mata tödeke chi dikaro tibti ye! Ti di tärä täte ma mikakrä dikekä ñöbti abko makwe ñan miri era jae ye, nieba Jesukwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yebti Jesu rankwaba rute Pedrobe angwane, müre rabababe kwekbe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Angwane nun näma rute ye erere rababa jökrä ngukudokwäbti temen Jesu ngwärekri, käkwe nieba ie: ¡Ma abko Ngöbö Odei era metre bkänä! nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yebti nun rikaba nebe Ñö Okwä Kri Galilea ye kwärä nakri kä Genesarete. ");
INSERT INTO gymNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Angwane nitre nünanka yete, ie Jesu rükaba gare, aisete jötrö ngwarbe Jesu nükani abko mikaba gare kwetre jabtä kä ngrabare temen kä ye känti. Angwane ni kwati rükaba mräkä bren bren ngwena Jesu känti, Jesukwe mikadre kuinta abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Angwane nitre bren bren ye abko Jesukwe tuadremetre dän körä aibe nuenbtä jabtä amne rabadreta kuinta abko mräkä rababa ribere ie. Ye erere bkänä, nitre bren bren rababa dän körä aibe nuenbtä Jesubtä angwane, rababa nebeta kuinta batibe jökrä abko rakakaba kore. ");
INSERT INTO gymNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Abti bati nitre bariseo btä Kukwe Biani Ngöbökwe Moiséye dirikätre nämane Jerusalén abko rükaba Jesu känti, käkwe kukwe ngwiantariba krörö ie: ¿Nun mräkä kirakira käkwe kukwe ükaninte nuendre, ");
INSERT INTO gymNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","se ñobtä abko nitre ja töitikaka mabe käta kite temen se? ¡Ni rabadre dbe Ngöbö ngwärekri, abkokäre ni ngämi mröre, känenkri köbötikadre abti mrödre abko tä ükaninte kore amarebti nitre ja töitikaka mabe abko ñan tä köbötike jire chi mrökrä se! nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Abtä Jesukwe nieba mda ietre: Ti bike kukwe ngwentari kwati munye arato abko krörö: ¿Ñobtä kukwe biani Ngöbökwe nuendre nie abko munta kite jökrä temen, bti kukwe ükaninte au jakrä munkwe abko mikata bäri ütiäte jae munkwe? Ye niere tie. ");
INSERT INTO gymNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tita ngwentari, ñobtä ñan angwane Ngöbökwe niebare krörö: Mun rün btä mun meye mika ütiäte jae munkwe amne, nire nire käkwe ñäkädre tare rün amne meye rüere, ni ye abko kämikadre, niebare Ngöbökwe. ");
INSERT INTO gymNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Akwa mun abko tä niere krörö: Ni iti käkwe niedre rünye amne meyeye: Jändrän tikwetikwe se erere tikwe biani jökrä Ngöböye, aisete ti ñan raba mun die mike jire chi bti, niedre kwe, ye abko dbe, munta niere. ");
INSERT INTO gymNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ne aisete nire nire käkwe nuendre kore, ni ye abko ñan rabadre rün amne meye die mike jire chi mda abko dbe Ngöbökrä munta niere, ye ngwane Ngöbökwe kukwe biani nuendre abko munta kite temen, kukwe ükaninte munkwe mikakäre ütiäte jae. ");
INSERT INTO gymNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Mun ngwarbe ja bä mike kuin nete! Munta ja bä mike kuin, ye mdenbtä abko ni Ngöbö kukwei niekä Isaías käkwe niebare krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Juta ne käta ti mike ütiäte ja kada aibebti, aisete tä ti tarere ñakare era metre. ");
INSERT INTO gymNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tätre ti käikitekä ngwarbe amne, kukwe ükaninte au jakrä kwetre, aibe tätre dirire ti Kukwei täte, niebare kore Isaíakwe munbtä, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yebti Jesukwe ni jökrä käräba, käkwe nieba krörö ietre: Ti bike kukwe niere, ne kukwei nuen munkwe angwane, munkwe mika nüke gare jae abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mrö jökrä kwetata nikwe, ye abko ñan tä ni mike ngite Ngöbö ngwärekri, akwa kukwe jökrä käme nita niere ja kadabti ye abra tä ni mike ngite Ngöbö ngwärekri, nieba Jesukwe ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yebtä abko nun ja töitikaka Jesube käkwe krötaba ja ken ben, käkwe nieba ie: ¿Makwe blitaniri ye abko nitre bariseo käkwe kukwe nuri abtä moto nibi romon jökrä, ye makwe gari ya? nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Abtä Jesukwe nieba mda nunye: Nitre bariseo amne Kukwe Biani Ngöbökwe Moiséye dirikätre ye abko ti bike bä mike kri mu kwrere amne, kri mden mden abko ti Rün kä käinbti käkwe nökani ñakare, ye abko jäkädikä ngätri ngöi jökrä, bti kitadikä mento, ye kwrere rakadikä niaratrebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Erere arato, ni ie kä tuen ñakare, kwrere jire nitre bariseo amne Kukwe Biani Ngöbökwe Moiséye dirikätre tätre dikekä, ñobtä ñan angwane Ngöbö gare ñakare ietre amarebti tö Ngöbö kukwei dirire ni mda mdaye. Ne aisete tuemetre dikekä kore, ñobtä ñan angwane ni nibu ie kä tuen ñakare rikadre ja jie ngwena kwärikwäri, ye ngwane niaratre nibu betadrekä gwaire kä mkäte nguse, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Angwane Pedrokwe nieba mda Jesuye: Makwe kukwe bä miri mröbtä, ye abko makwe dre nini abko niereta nunye, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Abtä Jesukwe nieba mda ie: ¿Munta näin raire tibe, akwa tita dre niere abko ñan tä nüke gare jire chi munye arato ya? ");
INSERT INTO gymNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tikwe kukwe nini abko krörö: ¿Nita mrö kwete, ye abko tä niken jökrä ni bülete, akwa nita nainkrö angwane, mrö ye kitakata jökrä ta, ye abko gare ñakare munye ya? ");
INSERT INTO gymNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nita mröre abti nita kitekäta, akwa kukwe kämekäme nita niere ja kadabti, ye abko tä ni töite amne ni motote abko erere nita niere, aisete kukwe kämekäme nieta nikwe ye abra tä ni mike ngite Ngöbö ngwärekri, ");
INSERT INTO gymNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ñobtä ñan angwane kukwe kämekäme abko tä ni töite amne ni motote abko erere nita niere amne nita nuene. Abtä nita ja mike ngite Ngöbö ngwärekri abko krörö: nita ni mda mda kämike, ni gure käta ja mike gure bati bati tiebe ni mda mdabe. Erere arato, ni merire brare ja mike ngite bätäkä ngwarbe jabe kwärikwäri amne ni jändrän goire ni mda mdakän amne ni blite ngwarbe ni mda mda rüere, erere arato ni ñäke ni mda mdabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Munta kukwe nuene kore angwane, munta ja mike ngite Ngöbö ngwärekri, akwa munkwe köbötikadre mrökrä abko ükaninte kira ye erere munkwe ñan mikadre täte, yebtä mun ñan rabadre ngite jire chi Ngöbö ngwärekri. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yebti Jesu näma yete, ye känti kä mikakaba kwe, bti rikaba juta Tiro amne juta Sidón kukwäre. ");
INSERT INTO gymNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Rababa yete angwane, meri iti Canaánbo, ñakare israelitare nünanka kä ye känti käkwe krötaba Jesu ken, kä rababa ngrente krikri be krörö: Ti Dänkien, ma jrei David tukwe mräkä. Ti ngwen ruentari tare jae, ñobtä ñan angwane ti ngänkän tikwe btä üai käme tä nüne, käta mike ja tare nike krübäte tikän. Yebtä ti die mike, rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Akwa Jesukwe ñäkäba ñakare jire chi meri ye käre. Abtä nun ja töitikaka ben käkwe krötaba Jesu ken, käkwe ribeba krörö ie: Meri se nibi ngrente krübäte dikaro ni jiebti, aisete ngänkän kwe miketa kuinta makwe, bti juenta jirekäbe, nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Angwane Jesukwe nieba meri yeye: Juta israelita tä nianinte obeja kwrere, ye aibe kräke Ngöbökwe ti juani die mike, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Akwa meri ye abko rikaba ngitiekä ngukudokwäbti temen Jesu ngwärekri, käkwe nieba mda ie: Ti Dänkien, ti die mike, rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Abtä Jesukwe nieba mda ie: Mun ñakare israelitare abko käme nukro kwrere nieta nitre israelitakwe munbtä, aisete tikwe ma die mikadre angwane, bäsi ban dianka ngäbäkre nikwe kän, bti kita nukroye, ye kwrere tikwe nuendre, nieba kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Angwane meri ye käkwe nieba mda Jesuye: Jän, ti abra nukro kwrere bkänä nitre israelita okwäte ti Dänkien. Akwa nukro bkänkä tä niken mröre mesabtä angwane, mrö büre tä betekä timontimon abko tätre kwete, ye kwrere tita nete mtare amne makwe ti die mika chi abko ie ti tö nibi, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Abtä Jesukwe nieba mda ie: Ti mräkä, mata tödeke kri era metre tibti, nibi tuen tie, aisete tikwe ma die mikadre, ie ma tö nibi, ye erere bikera nebe bare makrä, nieba Jesukwe ie. Ye btäräbe meri ye ngänkän rababata kuinta batibe abko rakakaba kore. ");
INSERT INTO gymNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yebti Jesukwe kä mikakaba kä ye känti angwane, rikaba nebe Ñö Okwä Kri Galilea ye köräbti. Abti rikaba mda ngitiobti, känti rababa täkänintbe. ");
INSERT INTO gymNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jesu rababa täkänintbe, ye känti ni kwati käkwe ja ükakröba btä. Nitre käkwe ja ükakröba kwati Jesubtä ye rikaba mräkä bren bren krörökrörö ngwena Jesuye: ni ngüre bren abko kisete näin nakwente, ni okwä kä drünente abtä kä tuen ñakare ie amne ni küde ngrötani aisete küde ruen ñakare ie. Erere arato, ni kukwei ñakare amne ni bren bätäkä ngwarbe bren mda mda kisete abko järababa kwetre, käkwe mikaba Jesu ngotobtä temen angwane, Jesukwe mikabata kuinta jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne aisete ni kukwei ñakare abko rababa blite amne ni küde ngrötani abko rababa nebeta kuinta amne ni nakwente abko rababa dikekäta kuin amne ni okwä kä drünente abko ie kä rababa tuen. Yebtä nitre kwati ye ñan töi rababa krütare mda kukwe ye tuare amne rababa Ngöbö nitre israelitakwe ye käikitekä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yebti Jesukwe nun ja töitikaka ben käräba, bti nieba kwe nunye: Nitre tä kwati nete se nibi tuen bobre tie, ñobtä ñan angwane kä nena köbömä jire tätre tibe nete amne mrö ñakare kwetadre ietre. Abtä ti ñan tö nibi juenta mröi ja gwiriete. Nane di krütadre amne kä rötadrete bti ji ngrabare, abtä ti ñan tö nibi juenta mröi, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abtä nun ja töitikaka Jesube käkwe nieba mda ie: Nete kä kaibete amne ni mda nüne ñakare känime nete, ¿se abko mrö kwandre mdente nie ni kwati se bukakrä jökrä? nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Angwane Jesukwe nieba mda nunye: ¿Banta kunbe munkwe? nieba kwe nunye. Angwane nunkwe nieba mda ie: Banta kun kükü be nunkwe amne gwa kiakia tä ruäre nunkwe, nunkwe nieba ie. ");
INSERT INTO gymNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Angwane Jesukwe ni jökrä mikaba täke temen, ");
INSERT INTO gymNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","käkwe ban kun kükü ye dianba kisete amne gwa kiakia ye dianba kisete kwe arato, käkwe kuin nieba btä Ngöböye, bti ban amne gwa ötakaba oto kiakia, käkwe bianba nun ja töitikaka ben yeye angwane, nunkwe dräiba nitre kwati yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Angwane nitre kwati ye käkwe mröba trinetrine jökrä, bti ban amne gwa oto rabateba ye abko nun ja töitikaka Jesube käkwe ükakröbata kutia kwä kükü jire. ");
INSERT INTO gymNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nitre kwati käkwe mröba ye abko ni brare aibe mili kräbkä käkwe mröba amne, nitre merire amne ngäbäkre kiakia näma yete käkwe mröba arato, akwa tanba ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yebti Jesukwe nitre kwati ye juanbata jökrä ja gwiriete, bti Jesu rankwaba rute nun ja töitikaka benbe, bti nun rikaba nebe käkä Magdala ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jesu rababa Magdala yete angwane, nitre bariseo amne nitre saduseo rababa Jesu känti ja tuakäre ben, akwa Jesukwe ja dokwä mikadre kö okwäte, abkokäre rikaba känti. Jesu abko juani era metre Ngöbökwe ya, ñakare ya abko Jesukwe bä mikadre, käkwe sribi kri ñan tuabare nuendre niaratre okwäbti abko rikaba niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Akwa Jesukwe nieba krörö ietre: Käta kite dere angwane, munta niere krörö: Kä jübateniri tain käinta, aisete kä rabadi kuin moren jetbe, munta niere. ");
INSERT INTO gymNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Erere arato, dekä angwane munta niere krörö: Mtare kä bä nibi tain käinta amne kä nibi mütare, aisete kä rabadi käme ñüre, munta niere. Kä bäta nebe ño käinta abtä kä rabadi ño köbö kwatirekwatire tä nüke gare kuin munye, ¿se ñobtä abko Ngöböta sribi ño ño nuene ti köböire mtare kä ne ngwane abko ñan tä nüke gare munye se? ");
INSERT INTO gymNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mun nünanka kä ne ngwane abko moto kämekäme amne munta Ngöbö tarere munta niere, akwa käre munta niara tuemetre, abtä tikwe sribi kri ñan tuabare aibe nuendre mun okwäbti, ie mun töta nebe. Akwa sribi kri ñan tuabare ye tikwe ñan nuendre jire chi mun okwäbti, munta ribere ye kwrere. Akwa Ngöbö nämane Jonábe, käkwe sribi kri ñan tuabare nuenbare kräke, ye kwrere aibe Ngöbökwe bä mikadi mun kräke. Abko kore se, nieba Jesu ietre. Bti Jesukwe kä mikakaba btätre yete amne rikaba kä mdabti. ");
INSERT INTO gymNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yebti nun ja töitikaka Jesube rababa Ñö Okwä Kri Galilea kwärä nakri angwane, nun rikadre ban ngwena abko käi rikwitakaba nunbti. ");
INSERT INTO gymNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ye btäräbe Jesukwe nieba krörö nunye: Olo ketete ti kukweiye munkwe. Lebadura nitre bariseokwe amne nitre saduseokwe, ye ngäniene munkwe ja ngibia kuin, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Angwane nun ja töitikaka Jesube kä rababa blite krörö: ¡Nun ñan ki ban ngwena abtä Jesuta blite kore! nun rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Nun rababa blite kore, ye gaba Jesukwe. Abtä nieba kwe mda nunye: ¿Ye ñobtä munta tödeke ñakare dikaro tibti, kä nibi ban ñakare niere dikaro kore ye? ");
INSERT INTO gymNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ban kunrike be te tikwe ni brare brare aibe mili krärike jire bukaba angwane, ban oto rabateba abko ükakröbata kutia kobe, ye munkwe tuaba ja okwä jenbti. ¿Akwa ti di tärä mun bukakrä ñan nükani gare munye amne töre ñakare munye arato ya ño ye? ");
INSERT INTO gymNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Erere arato, ban kun kükü be te tikwe ni brare brare aibe buri mili kräbkä jire amne ban oto nebete abko ürükrö kutia kobe, ye nebe töre ñakare munye arato ya ño ye? ");
INSERT INTO gymNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ban ñakare nieta munkwe, ñan yebtä tita blite abko ñan nü gare munye ya? Lebadura nitre bariseokwe btä nitre saduseokwe abko ngäniene munkwe ja ngibiadre kuin tikwe nini munye, akwa ñan tita blite lebadura bante yebtä, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Angwane batibe ñan Jesu näma blite lebadura bante btä, akwa kukwe diri näma nitre bariseokwe amne nitre saduseokwe, ye abko Jesu näma bä mike lebadura kwrere abko ngäniene nunkwe ja ngibiadre kuin abko Jesu näma niere nun ja töitikaka benye abko rükaba gare nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yebti Jesu rikaba nebe juta Cesarea Filipote käntita nun ja töitikaka benbe angwane, nieba krörö kwe nunye: ¿Ti Ni Kä Nebtä Ngobo ne abko nire nieta tibtä ni mda mdakwe? nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Angwane nunkwe nieba mda ie: Ma abko Juan Bautista nükaninta nire nieta ni ruärekwe amne ni mda abko käta ma Elías nükaninta niere mabtä. Ni mda abko ma ni Ngöbö kukwei niekä Jeremías nükaninta nire ara niere, akwa ni mda abko tä niere Ngöbö kukwei niekä kirakira mda mda abko nükaninta nire nieta kwe mabtä, nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Angwane Jesukwe nieba mda nunye: ¿Mun abko käta ti nire niere tibtä? nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Angwane jötrö Simón Pedro käkwe nieba Jesuye: Ma abko Ni Dianinkä Ngöbökwe ara amne ma abko Ngöbö nire Odei abko nunta niere, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Angwane Jesukwe nieba mda Pedroye: Simón, Jonás ngobo, kä raba nuäre mabtä amne Ngöbökwe ja di biani mae, ñobtä ñan angwane makwe kukwe nini tie, ye abko ñan ni kä nebtä köböire namani gare mae, akwa ti Rün tä kä käinbti ara jire käkwe mikani gare mae amne makwe nini tie. ");
INSERT INTO gymNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mdakäre abko, ti bike Pedro niere mae amne jä yebti nitre gätäkä ti käbti käkwe tödekadi amne rikadi niren kwati amne gata di kri krübäte ye abko käkwe ñan nitre gätäkä ti käbti ye ganaindre jire chi. ");
INSERT INTO gymNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Erere arato, Ngöbö kä käinbti tä gobrane, ye känti ni kwati rabadi nüke, abkokäre tikwe llabe biandi mae jukwe tikadre niaratre ngwiankäre nebe kä ye känti Ngöböta gobrane. Makwe dre dre mäkädrete kä nebtä, ye abko rabadira mäkäninte käne kä käinbti Ngöbökwe amne, makwe dre dre tikadrete kä nebtä abko rabadira tikaninte käne kä käinbti sete Ngöbökwe. Abko kore se, nieba Jesukwe Simón Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yebtä nun ja töitikaka Jesube, ie nieba krörö kwe: Ti abko Ni Dianinkä Ngöbökwe ara tä nete, ye munkwe ñan nie jire chi ni mda mdaye, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ye ngwane mentokwäre nun ja töitikaka Jesube, ie Jesu rikaba niere krörö: Ti rikadre Jerusalén, akwa ni näin nebe sete angwane, nitre unbre ji dokwäte btä nitre blitaka Ngöböbe ni mda mda diäre dänkien amne Kukwe Biani Ngöbökwe Moiséye dirikätre ye käkwe ti mikadi ja tare nike kri krübäte, käkwe ti müre ketadi, akwa köbömäkäre angwane, ti rükadita nire, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Abtä Pedro käkwe Jesu ngwianba kaibe mentokwäre, bti rikaba mäträre krörö btä: ¡Ti Dänkien, Ngöbö se okwäbti kukwe kore ñan rakadrekä jire chi mabtä näre! nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Akwa Jesu rikwitateba, käkwe Pedro tuaba ja käne, bti nieba mda kwe ie: ¡Satana, nän mento tibtä nete! Tikwe ja mikadre ngite Ngöbö rüere, abkokäre ma kite ñäke kore tie ñan ñan. Kukwe mden tä nebe tuen dbe Ngöböye, ye kwrere tuen ñakare mae amne, ni kä nebtä ie jändrän tuen dbe abko erere tä tuen mae, aisete makwe ñan ñäkä kore tie, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yebti nun ja töitikaka Jesube, ie Jesukwe nieba mda: Nire nire tö ja töi mikai kwatibe nänkrä tibe, ni ye abko tö dre dreye jakrä abko raba käikwitekä jabti amne köbö kwatirekwatire ja kwata raba ruentari tare ñakare ie nünakäre tikrä abko jata ti jiebti, ");
INSERT INTO gymNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ñobtä ñan angwane nire nire tö ja kwata ngibiai jen jakrä abko krütadi kärekäre, erere rabadi kärekäre Ngöbö okwä bäre mento akwa, nire nire krütadi ti dokwäre abko rabadi dianintari nünakäre kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ye abko, ni rabadre jändrän jökrä bkäne kabre kä nebtä, akwa ni krütadre angwane nikwe ñan nünandre mda Ngöböbe, ne ütiäre abko dre rükadre nie. Erere arato, nikwe nünandre kärekäre Ngöböbe, ye abko ni ñan raba kökö jire chi jakrä, ñobtä ñan angwane jändrän ñakare jire abko ni rabadre bien Ngöböye nüna kärekäre ben ye ütiäre. ");
INSERT INTO gymNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Akwa ti Ni Kä Nebtä Ngobo ne jatadita Ngöbö di kri bä nuärebti amne ti jatadita angeletre tikwe ben, ye ngwane abko ni itire itire käkwe dre dre nuenbare, ye erere tikwe kukwe ükadite kräke, käkwe ütiä biandi ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Akwa mun tä nete ne ruäre ngämi krüte, känenkri ti Ni Kä Nebtä Ngobo ne jatadita gobrane, ye abko munkwe tuadi ja okwä jenbti abko ti tö nibi niei metre munye. Abko kore se, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Yebti kä rikaba köbö ti ta mda angwane, Jesukwe Pedro, Santiago amne Santiago etba Juan aibe ngwianba jabe abko ben rikaba ngitio bäri mente käin yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Niaratre nämanena ngitio yebti käin angwane, batibe Jesu bä nikwitani bä jene niaratre okwäbti, aisete ñänä trä dirare ye kwrere Jesu ngwäre bä namani amne, dän Jesubtä abko trä namani ngwen bürere kä trä dirare kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ye btäräbe Moisés btä Elías namani gökökä yete blite Jesube, btä okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Angwane Pedro käkwe niebare Jesuye: Ti Dänkien, nunta nete abko käi nibi nuäre tibtä, aisete ma tö ne ngwane nunkwe ju mikadi kiakia komä munkrä: kwati makrä, kwati Moisékrä amne kwati Elíakrä, niebare Pedrokwe. ");
INSERT INTO gymNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro nämane blite kore Jesube, ye btäräbe müta trä ngwen jatani jüben niaratrebti angwane, müta yete abko ni kukwei jarabare krörö ietre: Ni ne abko ti Odei tare kri tikwe. Niara käi nuäre krübäte tibtä, aisete niara kukwei nua munkwe abko ni kukwei namani kore mütate. ");
INSERT INTO gymNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ni kukwei namani kore mütate, ye jarabare nitre ja töitikaka Jesube yeye angwane, kä jürä namani krübäte btätre, abtä nikaninbe ngitiekä ngwärere temen. ");
INSERT INTO gymNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ye btäräbe Jesukwe krötabare ken, käkwe nuaninbtä, bti niebare kwe ietre: Näin krö. Mun ñan rekwetaka, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ye btäräbe niaratre käkwe nikrabareta angwane, ni mda ñakare amne Jesu aibe nämane kaibe, btä okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Yebti Jesu nikaninta niaratrebe ngitiobtä motokwäre angwane, Jesukwe niebare ietre: Ti Ni Kä Nebtä Ngobo ne ngämi krüte, bti nüketa nire, ye känenkri kukwe turi munkwe ngitiobti käin sete, ye munkwe ñan nie jire chi ni mda mdaye. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abtä nitre nimä ja töitikaka ben ye käkwe niebare mda ie: ¿Ma krütadi bti rükadita nire mata niere ne ngwane, ñobtä abko Elías rükadre Ni Dianinkä Ngöbökwe käne kukwe ükatekäre biare kräke abko Kukwe Biani Ngöbökwe Moiséye dirikätre käta niere? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Amne Jesukwe niebare mda ietre: Elías rükadre käne ye abra era bkänä. Erere arato, niara rükadre, käkwe jändrän jökrä ükadrete kuin metre, ye abra era bkänä. ");
INSERT INTO gymNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Akwa Elías abko nükanina, akwa Kukwe Biani Ngöbökwe Moiséye dirikätre, ie niara ñan nükani gare, aisete tö namani dre dre nuein btä, erere nuenbare kwetre amne mrä müre ketani kwetre. Ye kwrere arato ti Ni Kä Nebtä Ngobo ne käkwe ja tare nikadi kri niaratre kisete arato abko ti tö nibi niei munye. Abko kore se, niebare Jesukwe nitre ja töitikaka ben yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Angwane Jesu nämane blite Juan Bautistabtä abko nükani gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yebti nitre näma kwati ngitiobtä ngüsrüri, ye känti Jesu rikabata angwane, ni iti käkwe krötaba ken amne rikababe ngitiekä ngukudokwäbti temen ngwärekri, käkwe nieba krörö ie: ");
INSERT INTO gymNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ti Dänkien, ngäbäkre tikwe noko ngwen ruentari tare jae tikrä, ñobtä ñan angwane tä nikrenkä krübäte temen tikän abko kisete tä ja tare nike kri. Erere arato, tä kite nikrenkä temen angwane, tä niken mate ñukwäte, ere angwane abko tä niken temen ñöte tikän ");
INSERT INTO gymNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","abko nitre ja töitikaka mabe, ie ti nü ngwena, akwa ñan di nibi mikakäreta kuinta, aisete miketa kuin tikrä abko tita ribere mae, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Abtä Jesukwe nieba mda: ¡Aingwaree, ti moto iko munbtä! Mun ye ño abko moto kämekäme dikaro abti munta tödeke ñakare dikaro Ngöböbti ye. ¿Ti rabadi kä nuäi mda munbe amarebti ye? nieba kwe. Ye btäräbe Jesukwe nieba mda: Ngäbäkre ye ngwen tie, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ye erere bkänä, ngäbäkre järükaba Jesu känti angwane, Jesukwe ngrateba üai kämenbti, käkwe üai käme ye juantariba ngäbäkre yebtä amne ngäbäkre ye rababata kuinta batibe. ");
INSERT INTO gymNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yebti nun ja töitikaka Jesube käkwe nieba kaibe ie: ¿Ñobtä üai käme ñan niki mento nunye ngäbäkre sebtä ruen? nunkwe nieba. ");
INSERT INTO gymNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Abtä Jesukwe nieba mda nunye: Munta tödeke ñakare bkänä Ngöböbti, ye mden kisete üai käme ñan niki mento munye. Ye munkwe tödekadre chi mostasa nurai chi ye näre, akwa munkwe tödekadre era metre Ngöböbti, ye ngwane mun rabadre niere ngitio nokoye: Ja denkä mento yete, bti ma rika kä mdabti, munkwe niedre ie, ye erere ngitio noko rikadre mento amne jändrän ñan rabadre jire tare nuendre munkrä, ye abko ti tö niei metre kore munye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Akwa üai käme ne kwrere juantarikrä mento abko blitadre Ngöböbe amne ja bäindre Ngöbökrä käne aibe köböire munkwe juandretari mento. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yebti nun näma dikekä gwaire Jesube kä Galilea käntita temen mda angwane niarakwe nieba nunye: Ti Ni Kä Nebtä Ngobo ne kitadi ngise ni mdaye ");
INSERT INTO gymNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","amne niaratre käkwe ti müre ketadi, akwa köbömäkäre angwane ti rükadita nire, nieba Jesukwe nunye. Jesukwe kukwe nieba kore nunye, yebtä abko nun moto rababa ulire jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Abti Jesu amne nun ja töitikaka ben rababata juta Capernaúmte angwane, nitre ngwian käräkä ju blitakrä Ngöböbe kräke, ye rikaba nebe Pedro känti, käkwe nieba krörö ie: ¿Dirikä makwe ye tärä ju blitakrä Ngöböbe ye ütiä bien arato ya? nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Angwane Pedro käkwe nieba mda ie: ¡Jänri, tärä ütiä bien yeri! nieba kwe. Yebti Pedro rikaba nebeta gwi angwane, Jesu ara jire käkwe ñäkäba käne ie, käkwe nieba: Simón, kukwe nebtä mata töbike ño abko ti tö nibi ngwiaintari mae abko krörö: ¿Jrei krikri kä nebtä ye abko käta ja ütiä biamna nireye? ¿Ngäbäkre jen kwrere käkwe ja ütiä biandre ie nieta kwe ya? o ¿Ni mda mda abko käkwe ja ütiä biandre nieta kwe? abko niere tie Simón, nieba Jesukwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Angwane Pedrokwe nieba mda Jesuye: Ni mda mda abko käkwe ja ütiä biandre nieta kwe ne abko, nieba Pedrokwe. Angwane Jesukwe nieba mda: Ngäbäkre jreikwe abko käkwe ja ütiä biandre ñakare kore ñan ñan. Ye mden kisete, ju blitakrä ti Rün Ngöbökwe noko tikwe ütiä biandre ñakare arato abko rabadre dbe, ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Akwa nikwe ñan ja ütiä biandre angwane, ni mda mda rabadre töbike blo ni btä abko ngäniene nän gwa kite Ñö Okwä Kri Galilea sete. Makwe kötu kita ñöte angwane, gwa mden raba käne kötubtä, ye makwe dian jate. Gwa ye abko kadate ngwian tädi abko kwandi mae, aisete ngwian tädi täte ma amne ti ütiä biankrä. Ngwian yebti ma rika ja ütiä bien amne makwe ti ütiä bian arato. Abko kore se, nieba kwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Abti kä ye ngwane nun ja töitikaka Jesube käkwe krötaba ken mda, bti nunkwe nieba ie: ¿Ngöböta gobrane nunbti, ne ngätäite nire abko bäri ütiäte ruen? nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Angwane Jesukwe ngäbäkre chi käräba iti, bti mikaba täkänintbe nun ngätäite kwe, ");
INSERT INTO gymNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","käkwe nieba krörö: Ti bike kukwe era erere niere munye abko krörö: Ngäbäkre kiakia tä ja mike bobre, ne kwrere munkwe ñan ja mikadre bobre Ngöböbtä ne ngwane, Ngöbökwe ñan gobrandre jire chi munbti. ");
INSERT INTO gymNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ne aisete, ni bti Ngöböta gobrane, ye ngätäite nire nire käta ja mike bobre Ngöböbtä abko tä ja mike bobre ngäbäkre chi ne kwrere, ye abko bäri ütiäte. ");
INSERT INTO gymNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ye abko, nire nire käta ni ja mikaka bobre Ngöböbtä ngäbäkre chi ne kwrere ye kaen ngäbti ti käbti, ye ngwane ti ne ara jire kata ngäbti kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Akwa nire nire käta ja mike bobre Ngöböbtä ngäbäkre ne kwrere, ye nirekwe ngwiandreta ti käikwitekä jabti, känti rabadre kukwe nuene bäri käme mda, ni ye abko Ngöbökwe mikadi ja tare nike krübäte. Mden kisete, ni ye ngämi ni tödekaka tibti ngwen ti käikwitekä jabti, känenkri jäkwata kri nura ukwakrä ye mäkädre ngärä, bti kitadre mrente nguse känti müre reketadre abko rabadre bäri kuin kräke. Ye kwrere ni ye ñan rabadre ni tödekaka tibti ngwen ti käikwitekä jabti. ");
INSERT INTO gymNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ni kä nebtä, kräke kukwe tärä keta kabre käta ni nuente ja käne abko nita ja mike ngite, ye abko käme nikrä bkänä, akwa ye abko tä käre. Akwa nire nire köböite ni mda mda tä ja mike ngite Ngöbö rüere, ¡ni ye abko bobre jakän! ñobtä ñan angwane Ngöbökwe niara mikadi ja ngie nuen krübäte ni mda mda ye dokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ne aisete ma kise ya o ma ngoto ya, köböite makwe ja mika ngite Ngöbö rüere ne ngwane, makwe tikaka ta jae, bti makwe kitaka mobe ja okwä bäre mento abko bäri rabadre kuin, ñobtä ñan angwane makwe nünandre deme kise kwäräbe amne ngoto kwäräbe rikakäre nüne Ngöböbe kä käinbti abko bäri kuin angwane, ñan ma kise krobu amne ma ngoto krobu ben ngöi jökrä Ngöbökwe ma kitadre ñukwä jutra ngitiekä kärekäre te. ");
INSERT INTO gymNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Erere arato, ma okwä köböite ma raba ja mike ngite Ngöbö rüere, ne ngwane makwe ja okwä ye diante kwati mento, bti makwe kitaka mobe arato, ñobtä ñan angwane ma okwä kwatibe ben ma rikadre nüne kärekäre Ngöböbe, ye abko rabadre bäri kuin makrä amne, ñan ma okwä kubu ben ngöi ma kitadre kärekäre ñukwä jutrate kä ja tare nikakrä känti. Ye mdenbtä tita kukwe bä mike kore mae, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mdakäre abko, ti bike kukwe era erere niere krörö munye: Nitre tödekaka tibti tä ja mike bobre Ngöböbtä, ye abko ngäbäkre kiakia kwrere, se munkwe ñan bätä ngwian btä tikän, ñobtä ñan angwane käre angeletre niaratrekwe tä ti Rün ngwärekri kä käinbti. ");
INSERT INTO gymNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Mdakäre abko, ti Ni Kä Nebtä Ngobo jatani ni nianinte ye diantarikäre. ");
INSERT INTO gymNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yebtä abko ti bike kukwe bä mike krörö munye: Ni iti kwe obeja tädre gre ketarike, akwa obeja krati rikadre ngwarbe kwäräkwärä kän, ye ngwane obeja rabadre gre ketabkä bti krä jätäbti krä ökän (99), ¿ye ñan mikadre kwe ja ngibiare kaibe ngitiobti, bti rikadre obeja nianinte krati ye känentari ya? Jänri, rikadre obeja nianinte ye känentari. ");
INSERT INTO gymNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Abti obeja ye kwandretari ie angwane, obeja kratibe ye abko bäri käi rabadre nuäre btä obeja gre ketabkä bti krä jätäbti krä ökän yebti ta abko ti tö nibi niei metre. ");
INSERT INTO gymNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ye kwrere arato, mun Rün tä kä käinbti sete abko ñan tö nitre tödekaka tibti tä ja mike bobre Ngöböbtä ngäbäkre kiakia kwrere se tuai nente jire iti jakän. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yebti Jesukwe nieba mda: Ma mräkä mden erere käkwe ja mika ngite ma rüere angwane, ma rika käkwe blita kaibe ben amne ja mikani ngite ño ma rüere kwe, ye makwe mika gare ie. Yebti ja ngite niedre kwe mae amne kukwe ükadrete kwe mabe, ne ngwane mun nibirate kuin jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Akwa ñan tö raba ma kukwei nuai amne ñan tö raba kukwe ükaite mabe ne ngwane, makwe ni mda känä iti, nibu ja mukore abko ben ma rika bliteta ma mräkä yebe. Abti makwe blitadi ño ben, ye abko rabadi gare metre ni nibuye, ni nimäye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Akwa ma näin ni mda mda ngwena jabe, ye okwäbti ma mräkä ñan tö raba kukwe ükaite janknu mabe ne ngwane, nitre gätäkä ti käbti tä ja ükekrö ye ie makwe mika gare gätäte; akwa nitre gätäkä ye käkwe blitadre ma mräkä yebe, akwa ñan tö rabadre kukwe ükaite janknu mabe ne ngwane, ni tödekaka ngöbö ngwarbebti, kwrere jire raba tuen munye amne ni ngututu jändrän ütiä käräkä gobran romanobokrä ye kwrere jire raba mun okwäte arato. ");
INSERT INTO gymNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ye abko, ti bike kukwe era erere niere munye abko krörö: Munkwe dre dre mäkädite kä nebtä, ye abko rabadi mäkäninte kä käinbti Ngöbökwe amne munkwe dre dre tikadrete kä nebtä abko rabadi tikaninte Ngöbökwe kä käinbti sete. ");
INSERT INTO gymNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ye kwrere arato, ti bike kukwe era erere niere munye abko krörö: Mun nibu käkwe kukwe ükadrete jabe kwärikwäri kä nebtä käkwe ja töi mikadre gwaire, bti mun tö rabadre dreye, ye abko munkwe kärädre Ngöböye, käkwe blitadre ben amne ti Rün kä käinbti sete käkwe biandi munye, ");
INSERT INTO gymNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ñobtä ñan angwane ni tädre nibu ya o nimä ja ükaninkrö gätäre ti käbti ye abko ti tädi siba ketetibe bentre. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Angwane Pedro rikaba, käkwe kukwe ngwiantariba Jesuye, käkwe nieba: Ti Dänkien, ¿ti mräkä iti käkwe kukwe nuendre blo ti rüere, se abko tikwe diandre bäbe bti ta ruen? ¿Tikwe diandre bä kükü bti ta ya? nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Abtä Jesukwe nieba mda Pedroye: Ñan makwe diandre bä kükübe bti ta abko ti bike niere mae, akwa makwe diandre gre ketamä bti bä jätäbti bä kükü (77) bti ta. ");
INSERT INTO gymNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ne aisete ni bti Ngöböta gobrane, ngätäite kukweta nakenkä krörö abko ti bike bä mike: Bati jrei nämane iti abko nikani rürümon ütiä ükete sribikä kwekwe ben. ");
INSERT INTO gymNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nikani rürümon ütiä ükete krörö, ye btäräbe sribikä iti kwe abko bti rürümon ütiä nämane millone kabre krübäte abko jänükani jrei ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Akwa sribikä ye abko ie ngwian ñan namani jire chi ja ütiä biankrä jrei yeye. Abtä jrei ye käkwe sribikä ye rürümoimna meri kwe amne ngäbriänkä kwekwe amne jändrän kwekwe erere ben ngöi rürümoimna jreikwe rürümon ütiäre. Amne sribikä ye abko rabadre ni klabore ni mdakrä kore, jreikwe sribi ütiä diandre rürümon ütiäre abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Akwa sribikä ye nikani mate ngukudokwäbti temen jrei ye ngwärekri, kä namani ribere kisere krörö jrei yeye: Makwe ti ngibia bätäre abko ti tö nibi ribei mae amne rürümon ütiä tibti ye tikwe ütiä biandita jökrä mae, niebare kwe jreiye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Angwane sribikä ye namani ruentari tare jrei yeye, käkwe rürümon ütiä kabre ye diani jökrä bti ta, käkwe tikaninte. ");
INSERT INTO gymNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yebti sribikä ye nikaninta angwane, sribi muko kwe abko bti rürümon ütiä nämane chi kwe abko ben namani ngätäi. Angwane sribikä ye nikani betekä, käkwe sribi muko kwe ye kani roro mkäbti, nikani roro mkä kekete se kwrere, kä namani niere: ¡Rürümon ütiä mabti, ye makwe ütiä bianta jökrä tie! namani niere ie. ");
INSERT INTO gymNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Akwa sribikä ye nikani mate ngukudokwäbti temen sribi muko ye ngwärekri, kä namani ribere kisere krörö ie: Makwe ti ngibia bätäre abko ti tö nibi ribei mae amne rürümon ütiä tibti ye tikwe ütiä biandita jökrä mae, niebare kwe sribi mukoye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Akwa sribikä ye ñan tö namani sribi muko kwe ye ngwen ruentari tare jae, käkwe kitani ngite kä teri, bti rürümon ütiä ye biandreta jökrä kwe angwane batibe tikadreteta, abkokäre kitani ngite kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Sribikä käkwe nuenbare kore, ye abko matani tare sribikä mda mdabtä. Abtä sribikä käkwe dre nuenbare ye abko sribikä mda mda ye nikani, käkwe niebareta jökrä jreiye. ");
INSERT INTO gymNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Abtä jrei ye käkwe sribikä ye kärämna mda. Nükani jrei känti angwane, niebare kwe ie: ¡Ma moto käme! Rürümon ütiä kabre krübäte mabti abko tikwe diandre mabti ta abko ma rababa ribere kisere tie, erere tikwe nuenba makrä. ");
INSERT INTO gymNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tikwe ma ngwianba ruentari tare jae, käkwe rürümon ütiä kabre diani mabti ta, ye kwrere makwe sribi muko makwe ye ngwiandre ruentari tare jae arato bä amarebti makwe kitani ngite rürümon ütiä chi dokwäre se, niebare jreikwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yebti jrei moto namani romon krübäte sribikä ye kräke, käkwe kitani ngite. Ye känti ngö tikadrekä krübäte mikakäre ja ngie nuen abti rürümon ütiä biandreta jökrä kwe jreiye amne batibe rabadre tikaninte abkokäre abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ye kwrere arato, mun mräkä mden mden käkwe kukwe nuendre blo mun rüere, akwa munkwe ñan diandre bti ta ja moto kuinbti, ye ngwane ti Rün tä kä käinbti se käkwe ñan mun ngite niara rüere diandrekä jire chi munbtä arato. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu näma Galilea yete, käkwe blitaba ünän jökrä kore, bti kä mikakaba kwe kä ye känti, bti rikaba nebe kä Judeate, Ñö Jordánbtä kä driri. ");
INSERT INTO gymNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Angwane nitre rikaba kwati Jesube amne Jesukwe ni bren bren mikabata kuinta kä ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ye ngwane abko nitre bariseo rükaba ruäre Jesu känti abko tö rababa Jesu nuaite ja käne, käkwe nieba krörö ie: ¿Kukwe mden erere nuendre merikwe angwane, rabadre tuen käme nie, yebtä nikwe meri nikwe tuadremetre ye abko dbe abko Ngöbö Kukwei tä niere ya? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Abtä Jesukwe nieba mda ietre: Ngöbö Kukwei käta dre niere kukwe yebtä abko btä mun tärä ñäke, aisete gare kuin munye ruen tie abko krörö: Kena dekä Ngöbökwe kä dätebare angwane, “ni brare btä ni merire dätebare kwe,” abko ie niebare krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ne aisete ni brare käkwe ja mikadre gure angwane, rikadre nüne jenena rünbtä amne meyebtä mento merire kwebe. Angwane ni nibu ye abko rabadi ni itibe kwrere, abko niebare Ngöbökwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ye kwrere ni nibu ye ñan rabadi ni nibu kwrere mda, akwa rabadi ni itibe kwrere. Ye mden kisete, Ngöbökwe ni mikani ni itibe kwrere, ye ni ñan rabadre denkä jire chi jene jene mentokwäre, aisete ni brare käkwe ñan meri tuadremetre, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Abtä nitre bariseo käkwe nieba mda Jesuye: Mata niere kore, ¿se ñobtä abko meri tuadremetre angwane, tärä biandre ie bti juandretari abko Moisékwe köböi biani nunye arato? nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Angwane Jesukwe nieba mda ietre: Mun dokwäkä ribi ribi Ngöbökrä, ye mdenbtä abko munkwe meri tuadremetre abko Moisékwe köböi biani munye ye. Akwa kena Ngöbökwe ñan kukwe mikanintbe kore, ");
INSERT INTO gymNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","aisete ti bike niere krörö munye: Meri ja mike ngite ñakare brare mda mdabe, akwa brare kwe käkwe tuadremetre, bti ja mikadre gure meri mdabe kwe, ye ngwane ni brare ye tä ja mike ngite meri yebe meri käne kwe rüere. Abko kore se, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Angwane nun ja töitikaka Jesube käkwe nieba ie: Meri nikwe abko rabadre ni mdabe aibe dokwäre ni rabadre tuemetre amne kukwe mda mda dokwäre ñakare ne ngwane, nikwe ñan ja mikadre gure jirekäbe abko bäri kuin ñan ñan, nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Abtä Jesukwe nieba mda nunye: Munkwe kukwe nini, ye abko era bkänä, akwa ni kwati ñan raba kaen ngäbti mikakäre täte, aisete nire nire ie Ngöbökwe ja di biandre kukwe ye mikakäre täte aibe tä kaen ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ne aisete kukwe tärä kabre btä ni brare brare kwati ñan tä ja mike gure abko krörö: Ni ruäre tä därere kise tökare biare, abtä ñan tä ja mike gure amne tä nebe kaibe kärekäre. Akwa ni ruäre abko ni mdara jire käta dätere kaibe, abtä tä nebe kise tökare amne ñan töta nebe ja gurebtä, aisete tä nebe nüne kaibe; akwa ni ruäre abko ñan tä ja mike gure jirekäbe nünakäre Ngöbö gobranka kä käinbti ye kräke, aisete nire nire tö raba kukwe ne kaen ngäbti nünakäre kore Ngöbökrä, ye käkwe ka ngäbti. Abko kore se, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yebti ngäbäkre järikaba ruäre nebe Jesu känti abko Jesukwe kise mikadre bti, käkwe blitadre Ngöböbe kräke, akwa nun ja töitikaka Jesube rababa ñäke nitre ngäbäkre ngwianka yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Abtä Jesukwe nieba nunye: Ngäbäkre ye tuemetre kite tie. Munkwe ñan ji öta käne, ñobtä ñan angwane nire nire käta ja mike bobre Ngöböbtä ngäbäkre ne kwrerekwrere, ni yebti abko Ngöböta gobrane, aisete munkwe ñan ji öta käne, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Yebti Jesukwe kise mikaba ünän jökrä ngäbäkrebti, ja di biankäre ietre, bti kä mikakaba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yebti ni rikaba iti nebe Jesu känti, käkwe nieba krörö ie: Dirikä, ¿sribi mden bäri kuin nuendre tikwe abko ütiäre ti rabadre nüne kärekäre Ngöböbe? nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Angwane Jesukwe nieba mda ie: ¿Ye ñobtä abko sribi mden bäri kuin nuendre btä mata kukwe ngwentari tie ye? Ni kuin abra tärä itibe abko Ngöbö ara, akwa ma tö nünai kärekäre Ngöböbe ne ngwane, kukwe biani nuendre nie Ngöbökwe, ye makwe mika täte jökrä, nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Angwane ni bati ye käkwe nieba mda Jesuye: ¿Kukwe mden mden mikadre täte tikwe? nieba kwe ie. Jesukwe nieba mda ie: Makwe ñan ni mda kämika. Ma gure, makwe ñan ja mika gure bati bati ni mda mdabe. Makwe ñan go. Makwe ñan blita ngwarbe ni mda mda rüere kitakäre ngite. ");
INSERT INTO gymNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Erere arato, ma rün amne ma meye mika ütiäte jae. Amne mata ja tarere au, ye kwrere makwe ni mda mda tare arato, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Angwane ni ye käkwe nieba mda Jesuye: Makwe kukwe nini, ye erere tita mike täte jökrä. ¿Se abko tikwe dre nuendre mda se? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Abtä Jesukwe nieba mda ie: Ma tö rabai metre Ngöbö ngwärekri ne ngwane, jändrän tä makwe ye erere nän rürümoine jökrä, bti makwe ngwian ye dräi ni bobre bobrebti angwane, ma rabadi jändrän ütiäte kri bkäne kabre kä käinbti sete. Makwe jändrän rürümoin ünän jökrä kore, bti ma jata ti jiebti. Abko kore se, nieba kwe ni bati yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesukwe nieba kore ie angwane, niara abko jändrän bkäne kabre krübäte, aisete moto rötateba jändrän kwekwe ye jiebti amne moto rababa ulire, ben rikabata. ");
INSERT INTO gymNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yebti nun ja töitikaka Jesube, ie Jesukwe nieba: Ti bike kukwe era erere niere krörö munye: Ni jändrän bkänkä krikri ye käkwe ja mikadre bobre Ngöböbtä, Ngöbökwe gobrandre bti abko tare krübäte kräke, ");
INSERT INTO gymNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","aisete ti bike niereta mda bati munye: Aku okwä chi, yete ta kameo krikri ye ara rikadre nuäre, akwa nitre jändrän bkänkä kri ye käkwe ja mikadre bobre Ngöböbtä, Ngöbökwe gobrandre bti, ye abko bäri tare kräke, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kukwe yebtä nun ja töitikaka Jesube ñan töi rababa krütare mda Jesu kukwei nuare. Abtä nunkwe nieba mda ie: ¿Ni jändrän bkäne kri ñan rabadre dianintari nini makwe, se nire abko rabadi dianintari amarebti se? nunkwe nieba ie. ");
INSERT INTO gymNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Angwane Jesukwe nun tuaba ja käne, käkwe nieba mda nunye: Mun kä nebtä ye kräke abko kukwe ye tare, akwa Ngöbö abko kräke jändrän ñakare tare jire chi, aisete niara aibe raba ni dentari, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Abtä Pedro käkwe nieba mda Jesuye: ¿Nunkwe jändrän jökrä mikaninte, bti nunta näin ma jiebti, se abko Ngöbökwe dre biandi ütiäre nunye? nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Angwane Jesukwe nieba mda: Ti bike kukwe era erere niere munye abko krörö: Ngöbökwe jändrän jökrä ükadite btin kä mrä ngwane, ti Ni Kä Nebtä Ngobo ne rabadi täkänintbe kürä gobrankräbti kä nuärete, ye ngwane mun ja töitikaka tibe ye abko rabadi täkänintbe gwaire siba tibe kürä kwä jätäbti kubu yebti. Ye känti abko juta keta jätäbti ketebu nitre israelitakwe abko kräke munkwe kukwe ükadite siba tibe. ");
INSERT INTO gymNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Amne nänbtä ti jiebti, nire nire käkwe ju mikaninte amne etbakantre amne ngwai mikaninte kwe, erere arato rün, meye amne ngäbriänkä kwekwe mikaninte kwe amne kä kwe erere mikaninte jökrä kwe nänbtä ti jiebti, nitre ye abko ie Ngöbökwe jändrän biandi gre ketarike rike bäri mda amne Ngöbökwe mikadi nüne kärekäre jabe arato. ");
INSERT INTO gymNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Akwa ni kwati tuen bäri ütiäte ütiäte kä ne ngwane, ye abko rabadi ütiäte ñakare Ngöbö ngwärekri; akwa ni kwati tuen ngwarbe, ütiäte ñakare kä ne ngwane, ye abko rabadi bäri ütiäte Ngöbö ngwärekri. Abko kore se, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yebti Ngöbö abko ñan tä sribi ütiä bien ni kä nebtä kwrere abko Jesukwe bä mikaba mda, käkwe nieba krörö: Ngöböta gobrane ño ni kwe ngätäite abko ti bike bä mike ni kä bkänkä kwrere. Bati ni kä bkänkä nikani dekä ni känene sribikäre jakrä uba gräte. ");
INSERT INTO gymNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ye erere sribikä kwani ie angwane, sribi ütiä biandre nuäi köböiti, ye erere ükaninte kwe bentre, bti juani kwe sribire uba gräte. ");
INSERT INTO gymNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yebti ñänä okwä krä ökän näre angwane, nikaninta jutate. Nikani nebeta yete angwane, ni mdara jire nämane nünaninkä ngwarbe kwani ie ");
INSERT INTO gymNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","angwane, niebare kwe ietre: Uba gräta tikwe sete, ye te mun nän sribire siba amne sribi ütiä bianta ño, ye näre tikwe ütiä biandi munye, niebare kwe ietre. Ye erere bkänä, nitre ye nikani sribire. ");
INSERT INTO gymNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Yebti ñänä ruäre näre angwane, kä bkänkä ye nikaninta jutate ni mda mda känene. Erere arato ñänä okwä krämä dere angwane, nikaninta amne nitre kwani ie yete, erere juani sribire kwe arato uba gräte. ");
INSERT INTO gymNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yebti ñänä okwä krärike näre dere angwane, kä bkänkä ye nikaninta jutate amne ni mda nämane ngwarbe abko kwani ie angwane, niebare kwe ietre: ¿Ñobtä munta sribire ñakare amarebti munta ngwarbe nete köböiti jire se? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Angwane nitre ye käkwe niebare mda kä bkänkäye: Sribi bkänkä nun känene ñakare sribikäre jakrä, ¿se abko nunkwe sribidre mdente? niebare kwetre ie. Angwane kä bkänkä käkwe niebare ietre: ¡Mun nän sribire jötrö arato uba gräte tikrä sete! niebare kwe ietre. Ye erere bkänä nitre ye nikani sribire. ");
INSERT INTO gymNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Yebti kä jatanina iko dere angwane, kä bkänkä ye käkwe niebare nitre sribikä ye dänkienye: Sribikätre ye kärere jökrä, bti makwe sribi ütiä bian ietre. Akwa nitre nü sribire bäri mrä, ye ara jire ie makwe sribi ütiä bian käne. Abti nitre niki sribire bäri käne ye abko ie makwe sribi ütiä bian mrä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ye erere bkänä, nitre nükani sribire mrä ñänä okwä krärike dere, ye ie sribi ütiä köböiti biani täte jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yebti nitre nikani sribire bäri käne dekä ye nikani sribi ütiä tuen jae angwane, sribi ütiä biandi bäri kabre ietre namani nütüre, akwa sribi ütiä biandre nuäi köböiti, ye erere biani täte ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Sribi ütiä dianina kore kwetre angwane, nikani ñäke kä bkänkä ye rüere, ");
INSERT INTO gymNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kä namani niere: Nitre nü mrä köre käkwe sribiniri ñänä okwä kratibe, akwa nun abko käkwe sribiniri tare ñänä ngirete ta nebebe kä dere. ¿Se ñobtä abko munkwe sribi ütiä bini ja näre nunye niaratrebe se? niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Abtä kä bkänkä ye käkwe niebare krörö sribikä iti ie: Ja mräkä, ñan tita kukwe nuene blo ma rüere ruen tie, ñobtä ñan angwane sribi ütiä bianta nuäi köböiti, ye erere tikwe biandi mae abko nikwe ürüte kore dekä, ye tä töre mae ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ne aisete sribi ütiä makwe, ye erere kaen ngäbti, bti ma rikata ja gwiriete, ñobtä ñan angwane nitre nü sribire mrä dere abko ie tikwe sribi ütiä bini ja kwrere mabe, ye abko kukwe tikwe, ");
INSERT INTO gymNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ñobtä ñan angwane ngwian ye abko tikwe, aisete ti tö rabadre dre dre nuein bti, ye erere ti rabadre nuene ruen tie. ¿Akwa tita ja moto mike kuin sribikä mrä se kräke, yebtä ma nibi mokrere ben ya ño ye? niebare kwe abko nakaninkä kore. Ne ngörä. ");
INSERT INTO gymNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ne aisete nire nire rabadre mrä, ye abko rabadita käne amne nire nire tä käne ye abko rabadi mrä, ñobtä ñan angwane Ngöböta ni kwati nübaire, akwa ni braibe abko diankata jakrä kwe. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yebti Jesu rikabara ji ngrabare Jerusalén kukwäre angwane, nun ni jätäbti nibu ja töitikaka ben, ye abko käräba kaibe mento kwe, käkwe nieba nunye: ");
INSERT INTO gymNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Mtare nita näin Jerusalén kukwäre. Ni näin nebe Jerusalén, ye känti ti Ni Kä Nebtä Ngobo ne kitadi ngise nitre blitaka Ngöböbe ni mda mda diäre dänkienye amne Kukwe Biani Ngöbökwe Moiséye dirikätre yeye. Niaratre ye abko käkwe ti kitadi ngise müre ketadre amne, ");
INSERT INTO gymNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","nitre romanobo ñakare israelitare abko ie ti kitadi ngise amne niaratre käkwe ti mikadi yakrä kri jae amne ti kwata metadi krübäte kwetre. Yebti ti müre ketadi krusobtä kwetre, akwa köbömäkäre angwane, ti rükadita nire. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Abti Zebedeo ngäbriänkä nibu Santiago btä Juan abko ben meye jataba käkwe krötaba Jesu ken angwane, rikaba ngitiekä ngukudokwäbti temen Jesu ngwärekri ja di käräkäre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Angwane Jesukwe nieba ie: ¿Ma tö nibi dreye amarebti ye? nieba kwe ie. Angwane Zebedeo ngäbriänkä ye meye käkwe nieba krörö mda ie: Ma raba gobrane angwane, makwe ngäbäkre tikwe noko mika bäri ütiäte, käkwe mika täkänintbe iti ja küde ruenkri amne iti ja küde ngeberekri abko ti tö nibi ribei mae, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Abtä Jesukwe nieba mda Zebedeo ngobo nibu yeye: ¿Tikwe ja tare nikadi kri krübäte, ye kwrere munta biare ja tare nike siba ya? nieba kwe ietre. Jänri, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Angwane Jesukwe nieba mda ietre: Munkwe ja tare nikadi kri ti kwrere arato, akwa nire rabadre täkänintbe ti küde ruenkri amne nire rabadre ti küde ngeberekri, ye abko ñan tä ti kisete akwa tä ti Rün kisete. Ye aisete, nire nire kräke kä ye tä ükaninte ti Rünkwe abko erere ie biandi kwe, aisete ti ñan raba bien munye, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesu näma blite kore, ye nun ni jätä ja töitikaka ben käkwe gaba angwane, Juan btä Santiago ye kräke nun moto rababa romon mda. ");
INSERT INTO gymNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Abtä Jesukwe nun käräba, käkwe nieba krörö nunye: Nitre ñakare israelitare käta gobrane angwane, tätre kukwe miketbe tare ni mda mda mikakäre ja ngoto täni. Erere arato, nitre ütiäte krikri ñakare israelitare abko ni mda mdakwe mikadre ütiäte jae, abkokäre tätre bike krikri, ye abko gare kuin munye. ");
INSERT INTO gymNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Akwa mun ja töitikaka tibe, ye ngätäite abko ñan rabadre bare jire chi kore, aisete mun ngätäite abko kukwe rabadre bä jene abko krörö: Nire nire tö rabai bäri ütiäte kri mun ngätäite ye abko käkwe sribidre ni bobre kwrere ni mda mdakrä ");
INSERT INTO gymNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","amne, nire nire mun ngätäite tö rabai bäri käne jändrän jökräbtä, ni ye abko rabadre ni klabore kwrere ni mda mdakrä, ");
INSERT INTO gymNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ti Ni Kä Nebtä Ngobo ne jatani kore ye kwrere, ñobtä ñan angwane ñan ni mda mdakwe sribidre tikrä, abkokäre ti jatani, akwa ti jatani sribikäre ni mda mda kräke amne ti jatani ja mike müre ketadre ni kwati kökatarikäre Ngöbökrä. Abko kore se, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yebti nun näma Jericó, bti nun rikaba ta angwane, ni kwati rikaba siba Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Angwane ni okwä kä drünente näma nibu täkänintbe jibtä. Jesu rikaba ta ji yebti gaba kwetre angwane, rikaba ngwänenkä kri krörö Jesu jiebti: ¡Jrei David tukwe mräkä, nun ngwen ruentari tare jae! rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Angwane nitre nibu ye käkwe kada ketadre, abkokäre nitre kwati rababa ngren ngren bti, akwa niaratre abko rababa ngwänenkä bäri krikri mda, kä rababa niere: ¡Nun Dänkien, ma abko jrei David tukwe mräkä, nun ngwen ruentari tare jae! rababa niere Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Abtä Jesu rababa nünaninkä, käkwe nitre nibu okwä kä drünente ye käräba, ye erere rükaba Jesu känti angwane, Jesukwe nieba ietre: ¿Tikwe dre nuendre munkrä, ie mun tö nibi? nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Angwane niaratre käkwe nieba mda ie: Nun Dänkien, makwe kä mikadre tuen nunye, ie nun tö nibi, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Angwane nitre nibu ye rababa ruentari tare Jesuye, käkwe kise mikaba okwäbtä. Ye btäräbe kä rababa tuen kuin batibe ietre angwane, rikaba siba Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Abti nun jatabara neme ja ken Jerusalén angwane, nun rababa juta Betfagé känti Ngitio Olibobtä. Ye känti Jesukwe nun ja töitikaka ben juanba nibu, ");
INSERT INTO gymNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","käkwe nieba krörö ietre: Juta tuen känime ni ngware ta. Se känti mun nän. Mun rabadi sete angwane, buro möre tädi mäkäninte kwandi munye angwane, buro ye abko ngäbäli tädi btä kwandi munye. Buro möre ye tikate munkwe, mun jata ngwena tie. ");
INSERT INTO gymNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Akwa nane nitre yete käkwe ñäkä munye dokwäre angwane, munkwe nie krörö ietre: Ni Dänkien tö nibi ie, aisete nun bike niken ngwena, akwa gwängwarbe juandita kwe munkrä, nie kore, nieba Jesukwe nitre nibu yeye. Bti juani kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kukwe rababa bare kore, kukwe niebare kira ni Ngöbö kukwei niekäkwe rabadre bare abkokäre. Kukwe ye tä tikani krörö Ngöbö Kukweibtä: ");
INSERT INTO gymNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nitre nünanka juta Siónte, ye ie niere krörö: Jrei munkwe kitera nüke tuen sete. Tä näin bobre buro ngäbälibti. Buro tribe ngwianka abko ngäbälibti tä näin ye, abko nämane tikani kore abko erere rabadre bare, abkokäre Jesukwe nitre juanba kore. ");
INSERT INTO gymNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ye erere bkänä, ni ja töitikaka Jesube juanba nibu kwe, ye abko käkwe dre nuendre nieba kwe ietre, ye erere nuenba kwetre, ");
INSERT INTO gymNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","kä rikaba buro möre ye ngwena ngäbäli ben gwaire, käkwe dän jabtä ye tikateba ötati, bti kitaba buro ngäbäli ye tröbti kwetre ja täkräre Jesuye angwane, Jesu rankwaba buro ngäbäli yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ye ngwane abko nitre näma kwati krübäte amne ni ruäre rababa dän jakwe metete ji ngrabare temen dikakakrä Jesuye amne, ni ruäre abko rababa kri küde tikekä, bti rababa mike ji ngrabare temen dikakakrä Jesu kakäre ngäbti jrei kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Angwane nitre näma näin ruäre Jesu känenkri amne ruäre Jesu jiebti, ye abko rababa ngrente ja dibti, kä rababa niere krörö: ¡Hosana! ¡Jrei David tukwe mräkä, ma kite ni Dänkien Ngöbö käbti! Ma ye aibe raba mikani ütiäte. ¡Hosana! ¡Ari Ngöbö kri kä käinbti käikitekä bäri krikri! abko nitre ye rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yebti Jesu rikaba nebe Jerusalén angwane, jötrö kä rababa nokre jabtä jutate yete amne ni kwati rababa niere krörö: ¿Nire nü amarebti se? rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Angwane nitre nämane yete käkwe niebare ietre: Ni Ngöbö kukwei niekä kädianta Jesu abko nü nete. Niara abko Nazarebo kä Galileate abko mden nü nete, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yebti ju blitakrä Ngöböbe, ye bäre Jesu rikaba angwane, nitre näma jändrän rürümoine yete amne ruäre abko näma jändrän kökö abko Jesukwe juantariba jökrä mento. Erere arato, nitre näma ngwian kwite ni mda mdakrä abko kän Jesukwe mesa kwitakaba temen se kwrere amne ütü rürümoinkä kwe ja täkrä nämane, ye abko Jesukwe kwitakaba jökrä temen se kwrere arato. ");
INSERT INTO gymNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yebti Jesukwe nieba nitre jändrän rürümoinkä yeye: Ngöbö Kukwei tä tikani krörö: Ju tikwe ne abra tä blitakrä tibe, niebare Ngöbökwe, akwa mun abko tä ju ne mike nitre gokä jue kwrere. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ye ngwane abko nitre okwä kä drünente amne nitre näin nakwente nakwente rababa nüke ju blitakrä Ngöböbe ye bäre Jesu känti angwane, Jesu rababa miketa kuinta jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Akwa sribi kri ñan tuabare Jesu rababa nuene, ye abko nitre blitaka Ngöböbe ni mda mda diäre dänkientre btä Kukwe Biani Ngöbökwe Moiséye dirikätre käkwe tuaba angwane, ju blitakrä Ngöböbe ye käntita abko ngäbäkre rababa ngrente krikri, kä rababa niere: ¡Hosana, jrei David tukwe mräkä abko tä nete! Ari käikitekä abko ngäbäkre rababa niere, ye kukwei jaraba ietre angwane, moto rababa romon, ");
INSERT INTO gymNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","käkwe nieba Jesuye: ¡Ngäbäkre tä ma käikitekä kore ye kukwei ruen ñakare mae ya amarebti ye! nieba kwetre Jesuye. Angwane Jesukwe nieba mda ietre: Jänri, kukwe ruen tie. ¿Akwa kukwe kore btä Ngöbö Kukwei tä tikani, yebtä munta ñäke ñakare ya amarebti ye? Ngöbö Kukwei käta niere krörö: Ngäbäkre kiakia käkwe kantadre mae amne ngäbäkre kianbtä kianbtä arato abko ma tö namani kukwei nuai, abko nieta kore, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yebti Jesukwe kä mikakaba nitre yebtä, bti rikabata juta bäre mento angwane, rikaba nebe juta Betaniate, känti kibiaba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yebti dekä angwane, Jesu rikabata juta Jerusalén kukwäre angwane mrö rababa ie. ");
INSERT INTO gymNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Angwane higokrie näma känime jibtä, btä okwä rababa angwane, rikaba nebe higokrie ye känti. Rababa higokrie ye känti angwane, higo kä aibe kwanba btä ie, akwa ngwä abko ñakare. Abtä Jesukwe nieba krörö higokrie yeye: ¡Ma ñan ngwä rabata jire chi mda! nieba kwe ie. Jötrö higokrie ye bä grötakaba nötare. ");
INSERT INTO gymNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kukwe rakakaba kore nun okwäbti, yebtä abko nun ja töitikaka Jesube ñan töi rababa krütare mda, käkwe nieba Jesuye: ¿Ñobtä makwe ñäri jirekäbe higokrie seye amarebti jötrö ngwarbe bä ngrökä nötare mda se? nunkwe nieba ie. ");
INSERT INTO gymNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Abtä Jesukwe nieba mda nunye: Ti bike kukwe era erere niere munye abko krörö: Munkwe tödekadre kwatibe Ngöböbti amne munkwe ñan ja töi mikadre ngwarbe kwäräkwärä, ye ngwane ñan kukwe nuni higokriebtä tikwe, ye kwrere aibe rabadre bare munye, akwa mun rabadre niere ngitio nokoye: Ja denkä mento yete. Ma rika mrente, munkwe niedre ie, ye erere rabadre bare munye. ");
INSERT INTO gymNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Munkwe tödekadre kwatibe Ngöböbti, käkwe blitadre ben angwane, dre dre munkwe kärädre ie, ye rükadre mun kisete. Abko kore se, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yebti ju blitakrä Ngöböbe ye bäre Jesu rikabata mda. Jesu näma dirire yete angwane, nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre unbre ji dokwäte ye jataba nüke Jesu känti, käkwe nieba ie: ¿Nirekwe ma mikani sribi nuene kore amne nire diebti mata kukwe nuene kore nete? nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Angwane Jesukwe nieba mda ietre: Ti bike kukwe ngwentari kwati arato munye. ¿Nirekwe Juan Bautista juani ni ngökö ñöte? ¿Ngöbökwe juani ya o ni kä nebtäkwe mikani sribire ya? Ye niere tie munkwe. Nirekwe juani, ye munkwe niedi tie ne ngwane, nire diebti tita sribi ne nuene abko tikwe niedi munye arato, nieba kwe ietre. Yebtä abko rikabata blite jabe kwärikwäri, kä rababa niere krörö: Ngöbökwe juani, nikwe niedre ie angwane, niarakwe niedre krörö mda: Ngöbökwe juani munta niere, ¿se ñobtä abko munkwe ñan kukwei mikani era jae? niedre kwe nie. ");
INSERT INTO gymNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Akwa, ni kä nebtäkwe mikani, ni ñan rabadre niere jire chi ie, ñobtä ñan angwane Juan abko ni Ngöbö kukwei niekä era metre, ye abko ni jökrä käta mike era, aisete nitre ye abko nita jürä ngwen, aisete Juan mikani sribi ye nuene ni kä nebtäkwe abko ni ñan raba niere jire chi, rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Abtä nieba krörö kwetre Jesuye: Nirekwe Juan juani, ye gare ñakare nunye, nieba kwetre. Angwane Jesukwe nieba mda ietre: Kore ne ngwane, nirekwe ja di biani tie sribi ne nuenkäre abko tikwe ñan niedre munye arato, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yebti Jesukwe nieba mda nitre blitaka Ngöböbe ni mda mda diäre dänkientreye amne nitre unbre ji dokwäteye: ¿Kukwe ne raba tuen ño munye? Bati ni nämane iti abko ngobo nibu kwe. Bati nikani, käkwe niebare ngobo itiye: Ma rika sribire mtare tirete tikrä uba gräte, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Akwa ngobo käkwe niebare ie: Ti ñan tö nibi rikai sribire tirete, niebare kwe rünye. Akwa yebti ja töi kwitaninta kwe amne nikani sribire. ");
INSERT INTO gymNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Yebti ngäbäkre ye rün nikani, käkwe niebare kwrere ngobo mdaye angwane, ni ye ngobo käkwe niebare ie: Jän, ti näin sribire tirete makrä, niebare kwe rünye. Akwa ñan nikani sribire abko nakaninkä kore se. ");
INSERT INTO gymNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ye abko, ¿ngäbäkre nibu ne mden käkwe rün kukwei mikani täte? nieba Jesukwe ietre. Angwane niaratre käkwe nieba: Ngäbäkre käne ye mden käkwe rün kukwei mikani täte, nieba kwetre Jesuye. Abtä Jesukwe nieba mda ietre: Ti bike kukwe era erere niere munye abko krörö: Nitre jändrän ütiä käräkä gobran romanobokrä abko tä nebe tuen käme munye amne meri bti kä ngwarbe ngwarbe abko tä nebe tuen käme munye arato, akwa niaratre abko bti Ngöbö kä käinbti rabadi gobrane bäri käne mun ye ngwä, ");
INSERT INTO gymNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ñobtä ñan angwane Juan Bautista nükani ji kuin era metre Ngöbökwe mike gare munye angwane, munkwe ñan niara kukwei mikani era jae, akwa nitre jändrän ütiä käräkä amne meri bti kä ngwarbe ngwarbe abko käkwe niara kukwei mikani era amne kani ngäbti kwetre, aisete niaratre abko ngäbäkre käne ye kwrere. Akwa kukwe nuenbare Juankwe abko munkwe tuani, akwa munkwe ñan Juan kukwei mikani era jae, käkwe trö kwitani ñakare kukwe kämeye, aisete mun ye abko ngäbäkre mda ye kwrere. Abko kore se, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ti bike kukwe mdara jire bä mike ne kukwe nuen munkwe: Bati ni kä bkänkä nämane iti, käkwe uba nurai nökani, bti ki mikani kwe amne kä ükaninte biare uba ñöi ngwäre kwe. Ju mikani nura ngibiabtikä kräke kwe, bti biani kwe ni mda mdaye sribikrä. Kä biani sribikrä kwe abko ütiäre uba döi biandreta ruäre ie. Yebti nikani kä mdabti. ");
INSERT INTO gymNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Abti uba ngwä ötadre abko käi nükani angwane, sribikä käkwe uba biandreta ruäre kä bkänkäye ye abko kä bkänkä käkwe sribikä kwekwe juani tuenta jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Akwa sribikätre kä bkänkäkwe ye nikani nebe angwane, sribikätre ubabtä ye ie neketaninte, nikani sribikä iti mete ja ñäte kwäräkwärä se kwrere. Iti mda abko kämikani kwetre amne iti mda abko täkäni jäbti kwetre kämikakäre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yebti kä bkänkä käkwe sribikätre juani bäri mda uba tuenta ruäre jakrä, akwa sribikätre ubabtä ye käkwe nuenbareta kwrere arato btätre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Abtä mrä angwane, kä bkänkä ye käkwe odei jen kwe ara jire juani, kä namani töbike krörö: Ti odei ne aibe abko mikadi ütiäte sribikätrekwe, aisete ti bike juen, namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ye erere bkänä juani kwe, akwa kä bkänkä ye odei nikani tuen sribikätre ubabtä yeye angwane, niebare kwetre jae kwärikwäri: Ni se abko rabadi jändrän rünkwe bkäne jökrä, aisete ari kämike amne ni rabadi kä ne bkäne jökrä, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ye erere bkänä, kä bkänkä odei ye neketaninte ietre, nikani ngwena uba grä bäre mento, bti kämikani kwetre se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","¿Yebti kä bkänkä rikadre mda angwane, dre nuendre kwe sribikätre käme yebtä raba ruen munye? nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Angwane nitre yete ye käkwe nieba mda: Kä bkänkä ye ie sribikä moto kämekäme ye rabadre ruentari tare ñakare, käkwe kämikadre jire jökrä. Abti sribikä mden mden käkwe nura ütiä biandre ie nura ngwä öta näire, ye ie tire ye biandre kwe mda, nieba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Bti Jesukwe ja bä mikaba jä kwrere amne, nitre dirikä krikri abko bä mikaba ju mikaka kwrere, käkwe nieba ietre: Kukwe nebtä Ngöbö Kukwei tä tikani abko btä mun tärä ñäke ruen tie abko krörö: Jä ütiäte kri ju mikakrä metre abko nitre ju mikaka käkwe kitaninkä, akwa jä ye abko ni Dänkien käkwe mikani bäri ütiäte ju mikakrä metre. Ye abko namani tuen bäri nuäre nie, abko tä tikani kore. ");
INSERT INTO gymNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ne aisete ti bike niere krörö munye: Munkwe sribibare ñakare era metre, sribikätre käme ye kwrere, aisete Ngöbökwe ñan gobrandre munbti amne juta mda käkwe sribidre era metre Ngöbökrä, ye abko bti Ngöbö rabadi gobrane. ");
INSERT INTO gymNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Angwane ni ütiäte kri jä kwrere tikwe nini, ye abko btä nire nire ritadrete amne rikadre temen jä yebti angwane, jä ye käkwe ni ye ötadibtä kiakia jökrä ngrabare. Erere arato, nire nire bti jä ye rikwitadrekä angwane, gütadikä mnüne jökrä jä ye täni arato. Abko kore se, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesukwe kukwe bä mikaba btä blitaba kwe ye abko nitre blitaka Ngöböbe ni mda mda diäre dänkientre rüere amne nitre bariseo rüere näma blite gaba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Angwane niaratre tö rababa Jesu kitai ngite kä teri, akwa Jesu abko Ngöbö kukwei niekä abko ni kwati näma mike era jae, abtä ni kwati ye jürä rababa btätre. ");
INSERT INTO gymNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yebti Jesu rikaba bliteta amne kukwe mda bä mikaba kwe, käkwe nieba krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ngöbö kä käinbti käta gobrane ño nibti abko ti bike bä mike krörö: Bati jrei nämane iti abko ngobo jatani ja mike gure angwane, jrei ye käkwe mrö sribebare kri kä ngwiankäre nuäre jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Yebti nitre nübaibarera kwe kä ngwen nuäre jabtä ye abko sribikätre juani kärere kwe, akwa nitre nübaibare kwe ye ñan tö namani näin. ");
INSERT INTO gymNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Abtä sribikä mdara jire juani jreikwe, käkwe niebare krörö ietre: Nitre nübaibare tikwe, ye ie munkwe nie krörö: Tikwe nbi kämikamna amne tikwe jändrän mda mda köteköte kämikamna kwetadre, aisete mrö nena biare jökrä amne nitre nübaibare tikwe ye jata kä ngwen nuäre jabtä tibe, munkwe nie ietre, niebare kwe sribikätre yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ye erere sribikätre nikani, käkwe niebare, akwa nitre nübaibare jreikwe ye käkwe sribikätre ye kukwei mikani ngwarbe. Ni ruäre nikani jirekäbe tirete amne ni ruäre abko nikani jändrän mda mda nuene. ");
INSERT INTO gymNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Akwa ni ruäre abko ie sribikätre jreikwe ye neketaninte, nikani mete kwäräkwärä se kwrere, bti mrä kämikani kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Abtä jrei ye moto namani romon krübäte. Abtä rükä kwekwe ye juani kwe, käkwe nitre moto kämekäme ye kämikani jökrä, bti juta ye kukwani jökrä kwetre sribikätre kwe ye dokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yebti jrei ye käkwe niebare sribikätre mda mdaye: Ti ngobo tikwe bike ja mike gure, kräke mrö nena biare jökrä kä ngwiankäre nuäre jabtä, akwa nitre nübaibare tikwe abko rükadre kä ngwen nuäre jabtä, akwa ti kukwei kitani temen kwetre, yebtä abko moto käme bä mikani kwetre jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mtare mun nän ji kri ngrabare sere amne nire nire kwan ji ngrabare munye, ye erere munkwe nübai jökrä kä ngwen nuäre jabtä tibe nete, niebare jreikwe sribikäye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ye erere bkänä, sribikätre ye nikani ji ngrabare angwane, nire nire kwani ietre ji ngrabare, ye erere ükaninkrö jökrä kwetre, ni moto käme amne ni moto kuin, ni ño erere jänikani jökrä kwetre angwane, ju kä ngwiankrä nuäre jabtä, ye te ni namani iti jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Yebti nitre nübaibare kä ngwen nuäre jabtä, ye namanina jökrä gwi angwane, jrei nikani mike ñäräre. Jrei namani gwi angwane, ni nämane iti yete abko dän kitadre jabtä nänkrä kä ngwiankrä nuäre jabtä ni ja mikaka gure känti, ye abko nämane ñakare btä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Abtä jrei ye käkwe niebare ni yeye: Ja mräkä, dän kitadre jabtä makwe abko ñakare mabtä, ye abko ma nü ño gwi nete siba, niebare kwe ie. Angwane ni ye rababa kwekbe jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Angwane nitre mrö mikaka mesabtä mesabtä, ye ie jreikwe niebare: Ni noko ngoto amne kise mäkete, bti munkwe kitaka kä bäri iko te ju bäre sere. Ye känti niara rabadi ja müaire krikri be amne tu ngö rabadi cherere jabtä ja tare nika kisete, ");
INSERT INTO gymNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ñobtä ñan angwane Ngöböta ni kwati nübaire, akwa ni braibe abko diankata jakrä kwe. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yebti nitre bariseo käkwe gätäbare angwane, tö namani Jesu tuai ja dokwä mike kö okwäte, aisete Jesukwe ñäkädre blo gobran romanobo rüere abtä kitadre ngise kwetre, abkokäre ja töi mikani kwatibe kwetre Jesu rüere, ");
INSERT INTO gymNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","käkwe nitre reketaka jakri juani ruäre nitre reketaka Herodekri ben gwaire niekäre krörö Jesuye: Dirikä, mata kukwe era erere niere, ye gare kuin nunye amne ji Ngöbökwe abko dirita era metre arato makwe, ye gare nunye arato. Erere arato, ni mda mda tä ño niere ma rüere diribtä kore, ye abko ñakare ütiäte makrä, ñobtä ñan angwane ñan mata blite ni mda mda moto mikakäre nuäre, ye garera nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ne aisete kukwe nebtä makwe dre niedre abko nun tö nibi gai abko krörö: ¿Emperador romanobo César abko ie nunkwe ja ütiä biandre ye abko dbe ya, ñakare ya niere nunye? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Nitre ye näma töbike blo Jesu rüere, ye Jesukwe gaba btätre. Abtä nieba mda kwe ietre: Mun ngwarbe ja bä mike kuin tibtä nete. ¿Se ñobtä tikwe ja dokwä mikadre kö okwäte au, abkokäre mun kite kukwe ngwentari kore tie ye? ");
INSERT INTO gymNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ngwian bti munta ja ütiä bien, ye mike tuadre tie, nieba Jesukwe ietre. Ye erere bkänä, ngwian denario bianba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Angwane Jesukwe nieba mda ietre: ¿Nire bä amne nire käta tikani ngwian nebtä? nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Angwane niaratre käkwe nieba mda Jesuye: Emperador César bä amne käta btä, nieba kwetre. Abtä Jesukwe nieba mda ietre: Jändrän emperadorekwe erere munkwe bian emperadoreye amne jändrän Ngöbökrä erere munkwe bian Ngöböye. Abko kore se, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesukwe ñäkäba kore ietre, ye kukwei nuaba kwetre angwane, ñan töi rababa krütare Jesu kukweibtä, ñobtä ñan angwane ja kitani ngite ñakare Ngöbö rüere o César rüere aisete. Yebti niaratrekwe kä mikakaba Jesubtä yete, rikabata jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Abti köbö ye arabe näire, nitre saduseo rikaba ruäre ja tuakäre Jesube. Nitre saduseo ye abko ni krütanikrütani mikadreta nire Ngöbökwe abko ñan nämane mike era, aisete jataba kukwe ngwentari Jesuye, käkwe nieba ie: ");
INSERT INTO gymNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Dirikä, Moisékwe niebare krörö: Ni iti tädre gure, akwa ngäbäkre ñakare kwetre amne ni ye krütadre angwane, merire rabadre kaibe, meri ye abko yäräkwe diandre jae mda. Yebti ngäbäkre rabadre kwetre angwane, ngäbäkre ye abko rabadre niara etba krütani ngobo kwrere, niebare Moisékwe. ");
INSERT INTO gymNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ye erere bati nun ngätäite nete nitre ja etbarebe nämane ni kükü. Nitre ye etba mubai käkwe ja mikani gure, akwa ngäbäkre ngämi nebe kwetre angwane, ni ye krütani, aisete merire namani kaibe ie, ye abko namani etba siba kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ye erere bkänä meri ye namani yärä mda yebe, akwa brare krütani kän arato. Abtä meri ye namani yärä mdabe, akwa brare krütaninta kän arato. Ye kwrere nikani nakenkä janknu ja täritäri. Abti nitre ni kükü ye krütani jökrä meri ye kisete. ");
INSERT INTO gymNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Abti mrä angwane, meri ye krütani arato. ");
INSERT INTO gymNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Akwa ni krütani rükadreta nire mata niere, aisete ni brare ni kükü, ben meri ye namani jökrä, abti niaratre ni kükü ye rükadreta nire jökrä angwane, meri ye rabadi nire nän mukore abko niere nunye, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Angwane Jesukwe nieba mda ietre: Ngöbö Kukwei gare ñakare munye amne Ngöbö di kri gare ñakare munye arato, aisete munta töbike ngwarbe blo kore. ");
INSERT INTO gymNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ni krütanikrütani rükadita nire angwane, ni merire, brare käkwe ñan ja mikadre gure, ñobtä ñan angwane niaratre abko rabadi angele kä käinbti kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mdakäre abko, ni krütanikrütani rükadreta nire abko Ngöbö ara jire käkwe niebare kira, niara nämane blite Moisébe angwane. Yebtä mun tärä ñäke ruen tie. Ngöbö Kukwei käta niere krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ti abko Ngöbö Abrahamkwe, Isaakwe amne Jacobokwe, niebare Ngöbökwe Moiséye. Abraham, Isaac amne Jacob krütanina abti Ngöbökwe niebare kore Moiséye. Ngöbö abko ñan ni ngwäkäre Ngöböi akwa Ngöbö abko ni nire Ngöböi gare nie. Ye aisete Abraham, Isaac amne Jacob tä nüne janknu Ngöbö ngwärekri abko gare nie, nieba Jesukwe nitre saduseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesukwe blitaba kore, ye nitre kwati käkwe kukwe nuaba ünän jökrä angwane, Jesukwe diriba ño, yebtä niaratre töi ñan rababa krütare Jesu kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesukwe nitre saduseo kada ketaba kwäräbe jökrä kore, ye abko nitre bariseo käkwe gaba angwane, ja ükakröbata kwetre Jesu känti mda. ");
INSERT INTO gymNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Angwane ni bariseo abko Kukwe Biani Ngöbökwe Moiséye dirikä arato näma iti yete abko tö rababa Jesu tuai ja dokwä mike kö okwäte, käkwe nieba krörö ie: ");
INSERT INTO gymNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Dirikä, ¿Kukwe Biani Ngöbökwe Moiséye nuendre nie, ye mden abko bäri ütiäte? nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Angwane Jesukwe nieba mda ie: Makwe ma Dänkien Ngöbö tare ja di ngöi jökrä, ja üai ngöi jökrä amne ja töi ngöi jökrä abko nieta kore, ");
INSERT INTO gymNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","aisete kukwe ye abko bäri ütiäte amne tä bäri käne arato kukwe jökrä mda mda ngätäite. ");
INSERT INTO gymNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Akwa kukwe tärä kwati mda abko bäsi kukwe käne ye kwrere arato abko käta niere krörö: Mata ja tarere au, ye kwrere makwe ni mda mda tare arato abko nieta kore Ngöbö Kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Munkwe kukwe ketebu ye mikadre täte ne ngwane, kukwe mda mda biani Ngöbökwe Moiséye nuendre nie, ye munkwe mikadre täte jökrä. Erere arato, kukwe biani Ngöbökwe nie ja kukwei niekä niekä köböire, ye munkwe mikadre täte jökrä arato. Abko kore se, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yebti nitre bariseo näma ja ükaninkrö Jesu känti yete angwane, ");
INSERT INTO gymNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesukwe nieba mda ietre: ¿Ni Dianinkä Ngöbökwe abko däredre nirekri nütüta munkwe? nieba Jesukwe ietre. Ni Dianinkä Ngöbökwe abko däredre jrei Davikri, nieba kwetre Jesu käre. ");
INSERT INTO gymNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Abtä Jesukwe nieba mda ietre: Ni Dianinkä Ngöbökwe abko däredre Davikri munta niere, ¿ye ñobtä abko Ngöbö Üai köböire Davikwe “ti Dänkien” niebare Ni Dianinkä Ngöbökwe yebtä? Ni ngätäite nete ni ñakare jire iti käta “ti dänkien” niere ngäbäkre kweye, akwa David abko käkwe niebare krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ti Dänkien Ngöbö käkwe nieba ti Dänkienye: Kä bäri ütiäte kri ti küde ruenkri, ne känti jakwe täke nete. Ye känti ma raba abti tikwe ma rüe mikadi jökrä ma ngoto täni, niebare Davikwe Ni Dianinkä Ngöbökwe yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David ara jire käkwe ja Dänkien niebare Ni Dianinkä Ngöbökwebtä, ¿se ñobtä abko Ni Dianinkä Ngöbökwe abko jatadre Davikri nieta munkwe se, ñobtä ñan angwane nita Dänkien niere ñakare jire ni mräkä bäri mrä nikrä yeye? nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Angwane nitre bariseo ye ñan kukwe gitiaba jire kwati mda Jesu käre, ñobtä ñan angwane kukwe niedre ño ño ñan rababa gare jire chi ietre aisete. Abti köbö ye näire mentokwäre ni ñakare jire iti, ie ja rababa nüke töre kukwe ngwentari Jesuye ja gakäre ben. ");
INSERT INTO gymNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yebti nitre näma yete btä nitre ja töitikaka Jesube, ie Jesukwe nieba mda: ");
INSERT INTO gymNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Kukwe Biani Ngöbökwe Moiséye dirikätre amne nitre bariseo abko tätre dirire Moisés täte, aisete niaratre aibe kukwei ütiäte abko niaratre tä niere jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ne aisete nitre ye kukwei mika täte munkwe amne dre nuemna kwetre, erere munkwe nuen. Akwa niaratre tä nüne ño, ye kwrere munkwe ñan nüna, ñobtä ñan angwane niaratre tä kukwe niere abko erere tätre nuene ñakare, akwa tätre jändrän mda nuene. ");
INSERT INTO gymNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mdakäre abko, tribe kri doboko abko ni ñan raba kaenkä, ye kwrere jire tätre kukwe taretare ükete nuendre munye, bti tätre kite ni mda mda kötärä. Abti niaratre ñan töta nebe kise mikai jire chi tribe yebtä ni mda mda die mikakäre. ");
INSERT INTO gymNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Erere arato, niaratre tä jändrän nuene, ye abko ni mda mda käkwe tuadre abko ie töta nebe abko krörö: kaja chi te Ngöbö Kukwei tä tikani täräbtä abko mikata ja okobtä amne küdebtä, akwa niaratre abko kaja krikri be tätre mäkete ja okobtä amne ja küdebtä tuadre ni mda mdaye. Erere arato, kö kitani kabre dän köräbäre abko tätre kite jabtä bikakäre bäri deme. ");
INSERT INTO gymNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Erere arato, niaratre nübaita bietabtä angwane, ja täkrä ni ütiäte ütiäte kräke, känti tö täkäi temen. Erere arato, ja täkrä ni ütiäte ütiäte kräke sinagogate, känti töta nebe rabai täkänintbe amne ja täkrä ni ütiäte ütiäte kräke, känti tätre nebe täkänintbe. ");
INSERT INTO gymNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mdakäre abko, ni ütiäte krikri, ie köbö ngwiandretari, ye kwrere ni jökrä käkwe köbö ngwiandretari käne ietre kä jändrän rürümoinkrä ye käntita temen, ie töta nebe. Erere arato, ni mda mdakwe kädiandre dirikä abko ie töta nebe. ");
INSERT INTO gymNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Akwa dirikä niedre munye mun mräkäkwe ye abko munkwe ñan ribe jae, ñobtä ñan angwane Dirikä itibe tä munkwe abko Ngöbö ara amne mun abko ja etbare jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mdakäre abko, Ngöbö mun Rün itibe abko tä kä käinbti sete, aisete ni mda mda kä nebtä abko mun rün munkwe ñan nie ietre mikakäre täte Ngöbö kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Erere arato, mun abko ni mda mda jie ngwianka niedre munye abko munkwe ñan ribe jae, ñobtä ñan angwane mun Jie Ngwianka era metre abko tärä munkwe. Mun Jie Ngwianka ye abko Ni Dianinkä Ngöbökwe. ");
INSERT INTO gymNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mdakäre abko, nire nire tö rabai bäri ütiäte mun ngätäite, ni ye abko käkwe ja mika sribikä ni mda mdakrä, ");
INSERT INTO gymNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ñobtä ñan angwane nire nire tö ja mikai kri au, ni ye abko Ngöbökwe mikadi bobre ja ngwärekri, akwa nire nire käkwe ja mikadre bobre, ye abko Ngöbökwe mikadi ütiäte kri ja ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Aingwaree! Mun Kukwe Biani Ngöbökwe Moiséye dirikätre amne mun bariseo käta ja bä mike kuin. Mun ye abko bobre jakän, ñobtä ñan angwane Ngöbö rükadre gobrane ni jökräbti, ye ngäniene munta jukwe dike jite, Ngöbö ñan rabadre gobrane btitre abkokäre. Ngöböta gobrane nibti, ye känti mun ñan tö rikai amne ni mda mda tö rikai abko mun ñan tä tuemetre niken arato, aisete mun bobre jakän. ");
INSERT INTO gymNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Aingwaree! Ngöbö bike mun Kukwe Biani Ngöbökwe Moiséye dirikä amne mun bariseo mike ja ngie nuen kri, ñobtä ñan angwane munta ja bä mike kuin abko krörö: Meri kän brare krütani abko kän munta ju denkä, abti munta nebe bike kuinkuin, käta nebe blite raire Ngöböbe ni jökrä ngwärekri, akwa munta kukwe nuene kore, akwa yebtä Ngöbökwe mun mikadi ja ngie nuen kri. ");
INSERT INTO gymNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Aingwaree! Ngöbö bike mun Kukwe Biani Ngöbökwe Moiséye dirikä amne mun bariseo mike ja ngie nuen kri, ñobtä ñan angwane munta ja bä mike kuin abko krörö: Munta niken kä mdabti amne munta niken mrenbti kä mda mda känti ni mda mda känene töi kwitakäre jakri. Ye erere tärä nebe nekete munkri angwane, kukwe dirita munkwe ietre abko erere tätre nuene. Abtä mun köböite tätre ja mike ngite bäri krübäte mun ngwä. ");
INSERT INTO gymNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Aingwaree! Mun okwäta kä drünente käta ni mda mda jie ngwena. Mun ye abko bobre jakän, ñobtä ñan angwane munta niere krörö angwane munta ni mda mda mike ja mike ngite Ngöbö rüere: Ju blitakrä Ngöböbe se käbti nire käkwe ja kukwei biandre abti kitadre temen kwe, ye ngwane rabadre ngite ñakare Ngöböye, munta niere. Akwa ju blitakrä Ngöböbe känti, orota mikani, oro ye käbti ja kukwei biandre abti ja kukwei kitadre temen kwe, ye ngwane rabadre ngite Ngöböye abko munta niere angwane, munta dirire blo. ");
INSERT INTO gymNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mun ngwarbe töi ñakare amne mun abko ni okwä kä drünente kwrere, aisete Ngöbö Kukwei gare ñakare metre munye, käta kukwe niere kore! ¿Dre bäri ütiäte? ¿Oro tä mikani ju blitakrä Ngöböbe känti ya o ju blitakrä Ngöböbe ara jire köböire oro tä nebe deme Ngöbö ngwärekri ya? Ju blitakrä Ngöböbe abko bäri ütiäte, akwa ütiäte ñakare munta niere. ");
INSERT INTO gymNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Erere arato, ñukwä grä jändrän kukwakrä Ngöböye, ye käbti nire käkwe ja kukwe biandre abti ja kukwei kitadre temen kwe, ye ngwane ñan rabadre ngite Ngöböye, munta niere. Akwa jändrän kukwata ñukwä gräbti ye ara jire käbti nirekwe ja kukwei biandre abti ja kukwei kitadre temen kwe, ye ngwane rabadre ngite Ngöböye munta niere. ");
INSERT INTO gymNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Kä iko mun okwäte Kukwe Ngöbökwebti ñan ñan! ¿Dre bäri ütiäte? ¿Jändrän biandre Ngöböye kukwadre abko bäri ütiäte ya o ñukwä grä köböire jändrän bianta Ngöböye abko tä nebe deme Ngöbö ngwärekri abko bäri ütiäte ya? Ñukwä grä abko bäri ütiäte. ");
INSERT INTO gymNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ne aisete nire nire käta ja kukwei bien ñukwä grä käbti, ye abko ñan ñukwä grä aibe käbti tä ja kukwei bien, akwa jändrän jökrä tä mikani ñukwä gräbti ye käbti tä ja kukwei bien. ");
INSERT INTO gymNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Erere arato, nire nire käta ja kukwei bien ju blitakrä Ngöböbe käbti, ye abko ñan ju ye aibe käbti tä ja kukwei bien, akwa Ngöbö ara jire tä nüne ju yete abko käbti tä ja kukwei bien arato. ");
INSERT INTO gymNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Amne nire nire käta ja kukwei bien kä käinbti se käbti, ye abko kürä gobrankrä Ngöbökwe bti Ngöböta täkänintbe kä käinbti, aisete Ngöbö ara jire käbti tä ja kukwei bien arato, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Yebti Jesukwe nieba mda: ¡Aingwaree! Ngöbö bike mun Kukwe Biani Ngöbökwe Moiséye dirikä amne mun bariseo mike ja ngie nuen kri, ñobtä ñan angwane munta ja bä mike kuin abko krörö: Kri mu ütiäte ñakare kädianta menta, anís amne comino abko munta ükete keta jätä jätä, abti munta mike keteti jenena Ngöbökrä. Akwa jändrän bäri ütiäte kri nuendre abko Kukwe Biani Ngöbökwe Moiséye tä dirire abko munta nuene ñakare abko krörö: Kukwe ükadrete era metre ni mda mdakrä amne ni mda mda ngwiandre ruentari tare jae, erere arato tödekadre kwatibe Ngöböbti, ye abko munkwe nuendre jändrän kiakia nuenta munkwe ye ben gwaire, akwa ye kwrere munta nuene ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne aisete mun abko ni okwä kä drünente kwrere. Ngöbö tö dreye gare ñakare metre munye, akwa munta ja mike Ngöbö kukwei dirikätre, käta ni mda mda jie ngwena blo. Kä u kiakia jäkäteta deme bätärekä dendente ta, ye kwrere jire kukwe kiakia bäsi ütiäte ñakare bökän Ngöbö Kukwebtä, bti munta mokrere krübäte, akwa kukwe bäri ütiäte nuendre tä tikani Ngöbö Kukweibtä ye abko kameo krikri ñaka ngöi jökrä, kwrere jire munta nuene kukwe ütiäte krikribtä, aisete munta mike ütiäte ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Aingwaree! Ngöbö bike mun Kukwe Biani Ngöbökwe Moiséye dirikä amne mun bariseo mike ja ngie nuen kri, ñobtä ñan angwane munta ja bä mike kuin abko krörö: Mun abko baso amne siä bätäteta btärita aibe amne terita abko tä nebe dobrore kwrere jire, aisete mun töita gobtä amne jändrän ni mda mdakwe abko ie mun töta nebe jökrä jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mun bariseo, munta ni okwä kä drünente kwrere, aisete ti bike niere krörö munye: Baso amne blato bätäteta kuin jökrä terita amne btärita tä nebe merebe jökrä, ye kwrere jire munkwe ja töi ara jire mika kuin merebe amne mun ngrabare rabadi kuin merebe jökrä Ngöbö ngwärekri arato. ");
INSERT INTO gymNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Aingwaree! Ngöbö bike mun Kukwe Biani Ngöbökwe Moiséye dirikä amne mun bariseo mike ja ngie nuen kri, ñobtä ñan angwane munta ja bä mike kuin abko krörö: Ni doboi mikata abko känti kä ükateta abti jükata bäta nebe ngwen bürere bäne, akwa ni krütani aibe kroko tä nguse amne jändrän kämekäme rä kure dbe ñakare Ngöbö ngwärekri tä nguse, ye kwrere jire munta nebe. ");
INSERT INTO gymNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ye abko, mun abko kä ükateta kuin rökabti amne jükata tä nebe bäne btärita kwrere jire abko krörö: Munta ja bä mike ni moto kuin kwrere ni mda mda okwäte, akwa mun moto amne töi abko te jändrän kämekäme tä munkwe, aisete munta bike deme amne kukwe jökrä käme btä mun töita, aisete mun röka jükani ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Aingwaree! Ngöbö bike mun Kukwe Biani Ngöbökwe Moiséye dirikä amne mun bariseo mike ja ngie nuen kri, ñobtä ñan angwane munta ja bä mike kuin abko krörö: Nitre Ngöbö kukwei niekä kirakira abko kräke munta kä ükete kuin rökabti niaratre mikakäre ütiäte jae. Erere arato, ni ruäre käkwe nünabare metre Ngöbö ngwärekri abko doboibti munta kä ükete bä nuäre nuäre, ");
INSERT INTO gymNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","bti munta niere krörö: Ni mräkä kirakira käkwe nitre Ngöbö kukwei niekä kämikani, ye ngwane ni tädre nüne akräke nikwe ñan kämikadre jire chi gwaire bentre, munta niere jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Munta blite kore, yebtä mun mräkä kirakira käkwe nitre Ngöbö kukwei niekä kämikani, ye arabe mräkäkri mun jatani abko tä nüke gare munye ñan ñan. ");
INSERT INTO gymNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mun mräkä kirakira käkwe kukwe mikanintbe ño mun käne nitre Ngöbö kukwei niekä rüere, ye kwrere munkwe mika nebe bare täte jökrä tibtä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Mun abko tbi bökän krübäte ye kwrere jire! Ne aisete Ngöbökwe mun mikadi ja ngie nuen kä ja tare nikakrä känti. Yebtä munkwe ñan kwäräbedre jire chi. ");
INSERT INTO gymNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ne aisete nitre Ngöbö kukwei niekä amne nitre töbtä töbtä amne nitre Ngöbö kukwei dirikä ye abko tikwe juandi Ngöbö Kukwei niekäre munye nete, akwa munkwe müre ketadi amne munkwe metadi krusobtä ruäre. Ruäre abko sinagoga käntikänti munkwe kwata metadi amne ruäre rikadi ngitie amne jiebti mun näin kisere juta kwatirekwatire te niaratre mikakäre ja tare nike. ");
INSERT INTO gymNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ne aisete nitre nünanka metre Ngöbö ngwärekri abko kämikanina mun mräkä kirakirakwe, ye dokwäre Ngöbökwe mun mikadi ja ngie nuen kri krübäte. Abel käkwe nünabare metre, ye näire mentokwäre ni müre ketani nebe Berequías ngobo Zacarías näire amne Zacarías abko müre ketani munkwe ju blitakrä Ngöböbe känti ñukwä grä amne kä deme te ruäre. ");
INSERT INTO gymNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nitre müre ketani kore, ye dokwäre abko Ngöbökwe nitre nünanka kä ne ngwane mikadi ja ngie nuen kri krübäte abko ti bike niere metre munye. ");
INSERT INTO gymNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ye btäräbe Jesukwe nitre Jerusalénbo müaiba, käkwe nieba krörö: ¡Aingwaree, mun nünanka Jerusalén nete! Käre munta nitre Ngöbö kukwei niekä müre kete amne nitre juanta Ngöbökwe ja kukwei ngwena abko müre ketata jäbti. Ye abko, kwita ngäbäli kiakia ngibiare ja ngike täni, ye kwrere käre ti tö namani mun ngibiai, akwa mun ñan tö namani ti tuai ja ngibiare. ");
INSERT INTO gymNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ye mden kisete, ju munkwe nete ne rabadi tökare jökrä mun täbtä nete abko tita niere munye, ");
INSERT INTO gymNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ñobtä ñan angwane mtare mentokwäre ti ngämi kiteta, känenkri munkwe ñan ti tuadre jire chi mda, yebti munkwe ti tuadi angwane munkwe niedi krörö: Ni kitera nüke ni Dänkien Ngöbö käbti raba mikani ütiäte kri, munkwe niedi kore ti ngäbti. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yebti Jesu näma ju blitakrä Ngöböbe bäre, rikabata akwa ngämi nikenta mente, känenkri nun ja töitikaka ben käkwe krötaba ken amne nun rababa näkwiteta ja jiebti, kä rababa ju blitakrä Ngöböbe ye driereta ie tuadre. ");
INSERT INTO gymNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ye erere bkänä Jesukwe ju ye mikabata ñäräre, käkwe nieba krörö nunye: Ti bike kukwe era erere niere munye abko krörö: Ju kuin btä mun okwä nibi, köböitira jire ju se juandi ngwarbe jire jökrä, aisete jä ketani jabti jabti se juandi jökrä temen abko ti tö nibi niei munye, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yebti nun rikaba ta nakri Jesube nebe Ngitio Olibobti, ye känti Jesu rababa täkänintbe angwane, nun ja töitikaka ben käkwe krötaba ken, käkwe nieba kaibe ie: ¿Ngöbökwe kä ne juandi ngwarbe jökrä makwe nini, ye abko rakadikä ñongwane? Erere arato, ma jatadreta bobuta amne kä ne rikai ta, ye abko bä mikadi ño nunye abko makwe niedre nunye, ie nun tö nibi, nunkwe nieba Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Abtä Jesukwe nieba krörö nunye: Bäri käne abko, nitre ni ngökaka, ye ngäniene munkwe ja ngibia kuin, ");
INSERT INTO gymNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ñobtä ñan angwane ni jatadi kwati ti käbti käkwe niedi krörö: Ti abko Ni Dianinkä Ngöbökwe ara tä nete, niedi kwetre, ye käkwe ni kwati ngökadi. ");
INSERT INTO gymNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mdakäre abko, munkwe kukwe krörö gadi: Nitre tädi rüre jabe kwärikwäri nete sete abko gadi munkwe amne blita rabadi kabre rübtä, akwa mun ñan rekwetaka, ñobtä ñan angwane kukwe ye rakadikä kore abko erere rabadi nakenkä. Akwa ye ngwane kä mrä ngämi nüke abko raba gare munye, ");
INSERT INTO gymNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ñobtä ñan angwane juta kwatirekwatire rabadi rüre jabe kwärikwäri amne nitre nünanka kä ketareketare te rabadi rüre jabe kwärikwäri. Erere arato, ni kwati rabadi mrö nike krübäte amne dobo rabadi nakaenkä kä ketareketare temen kwäräkwärä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Akwa ye ngwane abko ja tare nika jatadi krire kena kä nebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ye ngwane mun abko mikadi ja tare nike tödekabtä tibti amne mun ruäre abko müre ketadi amne munta tödeke tibti, ye dokwäre ni kwati nünanka kä ketareketare temen mätä rabadi munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Erere arato, kä ye ngwane ni kwati käta ja tödekaka tibti niere abko käkwe trö kwitadita tie, käkwe ti rükandite amne mätä rabadi jabtä kwärikwäri, käkwe ja kitadi ngise ngwarbe kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Erere arato, ni kwati jatadi ja bä mike ni Ngöbö kukwei niekä era metre kwrere ye käkwe ni kwati ngökadi krübäte. ");
INSERT INTO gymNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ni kwati rabadi kukwe nuene kämekäme krübäte, aisete bäsi ni jökrä ñan rabadi ja tarere kwärikwäri mda. ");
INSERT INTO gymNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Akwa nire nire käkwe nünandrekä dite jabtä, käkwe ñan ti rükandrete nebebe kä mrä, ni ye abko rabadi dianintari Ngöbökwe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mdakäre abko, Ngöbö kebera nüke gobrane nibti, ye abko kukwe kuin abko tita niere, ne abko rabadi diribare kä jökräbti temen Ngöböta sribire ño ni ngätäite mikakäre gare angwane, batibe kä mrä jatadi nüke. ");
INSERT INTO gymNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mdakäre abko, ni iti ngwarbe käme käkwe jändrän deme Ngöbökwe mikadi ngwarbe jae, ye mdenbtä abko ni Ngöbö kukwei niekä kädian nämane Daniel käkwe tärä tikani kira. Drebtä tita blite rüka gare munye, ñobtä ñan angwane ni ye tädi nünaninkä kä deme ju blitakrä Ngöböbe ye känti, Daniel käkwe kukwe tikani ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Angwane mun tädre Judeate ye abko gitia mintokwäre ");
INSERT INTO gymNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","amne mun mden mden tädre jubti käin ye abko ñan rika jändrän tuenta jire chi gwi jae amne mun gitia jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mun mden mden tädre sribire tirete ye abko ñan rika dän tuenta jire chi gwi jae, akwa mun gitia gwängwarbe jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Akwa meri doboko doboko amne meri kwe ngäbäkre kiakia kianbtä, ye abko bobre jakän, ñobtä ñan angwane niaratre ñan raba ngitie jötrö. ");
INSERT INTO gymNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Akwa mun gitiadre ye abko ñan rakadrekä kä ñüre näire abko munkwe ribe Ngöböye, ñobtä ñan angwane tare näin jötrö kä ñüre näire amne mun gitiadre ñan rakadrekä köbö jadükakrä näire. ");
INSERT INTO gymNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Munkwe ribe kore Ngöböye, ñobtä ñan angwane kä dätebare kena angwane ja tare nika ñakare krübäte kore abko erere ja tare nikadi kri krübäte kä ye ngwane. Yebti ñan ja tare nikadreta mda ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ye abko, Ngöbökwe ñan köbö krötadre jötrö käne ja tare nikakrä, ye ngwane ni ñan rabadre dianintari jire iti, akwa ni dianinkä jakrä Ngöbökwe abko Ngöböta tarere, aisete köbö ja tare nikakrä krötadi jötrö kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ne aisete, kä ye ngwane kukwe raba nakenkä kore angwane, nane ni mdakwe niedre krörö munye: ¡Ni Dianinkä Ngöbökwe abko tä nete tuen! niedi kwe, o ¡Ni Dianinkä Ngöbökwe tä sete tuen! niedre kwe, akwa munkwe ñan kukwei mika era, ");
INSERT INTO gymNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ñobtä ñan angwane kä ye ngwane ni kwati jatadi ja bä mike Ni Dianinkä Ngöbökwe kwrere amne ni kwati jatadi ja bä mike ni Ngöbö kukwei niekä kwrere, käkwe sribi krikri ñan tuabare nuendi kabre bätäkä ngwarbe ni mda mda ngökakäre amne rabadre ni dianinkä jen jakrä Ngöbökwe ara jire ngökö, ne ngwane ngökadre kwetre, akwa ñan rabadi ngökö. ");
INSERT INTO gymNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ne aisete kukwe ye ngämi nakenkä, känenkri tita mun mike mokre biare. ");
INSERT INTO gymNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ne aisete ni mdakwe nie krörö munye: Ni Dianinkä Ngöbökwe abko tä kä kaibete sete, nie kwe angwane, mun ñan rika tuen känti. Erere arato, nie krörö munye: Ni Dianinkä Ngöbökwe abko tä ja rükaninte nete, nie kwe angwane, munkwe ñan kukwei mika era, ");
INSERT INTO gymNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ñobtä ñan angwane merata trä ngitiekä ngwen käinta angwane, träta jataen batibe nindrini amne kä driri, ye kwrere arato, ti Ni Kä Nebtä Ngobo ne jatadita angwane, ni jökrä käkwe gadi batibe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ye abko, ni ngwäkä tä mdente, btä jüden rabadi ja ükekrö ngwäkä kwete abko nita tuen, ye kwrere ti jatadita ni jökrä käkwe gadi. ");
INSERT INTO gymNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ja tare nikadi kri nini tikwe, yebti btäräbe ñänä se rötadite amne kä rabadi iko jökrä. Erere arato, sö se ñan trä rabadre mda amne muke käinta se abko rabadi betekä timontimon amne jändrän kä käinbti se abko rabadi grükekä arato. ");
INSERT INTO gymNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Angwane ti, Ni Kä Nebtä Ngobo jatadita abko bä mikadi kore kä käinbti sete abko ni jökrä käkwe tuadi. Ye ngwane abko ni kä jökräbti temen rabadi nekwetekä krübäte ja jiebti, käkwe ja müaidi angwane, ti Ni Kä Nebtä Ngobo abko jatadi tuen ja di kri bä nuärebti mütabti abko ni jökrä käkwe tuadi. ");
INSERT INTO gymNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Angwane tikwe angeletre tikwe juandi drü jüke krikri käkwe ni dianinkä jen jakrä ükadikrö jökrä ketetibe. Ni dianinkä jen jakrä nünanka nindrini, kä driri, sekri, nekri abko ükadikrö jökrä kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mdakäre abko, higokrie btä kukweta nakenkä ño, yebtä munkwe ja töitika abko krörö: Higo küdeta niren mräre mda amne käta nebe mräre btä arato angwane, kä töre tärä kite nüke ja ken abko munta gaen, ");
INSERT INTO gymNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ye kwrere arato kukwe nini tikwe ye jata nakenkä jökrä mun okwäbti angwane, ti Ni Kä Nebtä Ngobo nükerate ja ken jukwebtä abko rabara gare munye. ");
INSERT INTO gymNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ti bike kukwe era erere niere munye abko krörö: Nitre nünanka kä nebtä ngämi krüte jökrä, ye känenkri kukwe nini tikwe ye erere rakadikä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mdakäre abko, kä käinta se btä kä temen ne abko Ngöbökwe gadikä jökrä, angwane rikadi ta, akwa ti kukwei abko rabadi kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Akwa ti jatadreta köbö mdente amne ñänä okwä nuäi, ye abko gare ñakare jire chi ni mda mdaye, angele kä käinbti ie gare ñakare amne Ngöbö Odei ie gare ñakare arato, akwa Ngöbö ni Rün aibe ie tä gare kaibe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Mdakäre abko, kukwe nakaninkä ño ño Noé näire angwane ni jökrä nämane nüne jäme, ye kwrere arato ti Ni Kä Nebtä Ngobo ne jatadita angwane, kukwe rakadikä abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kä ye ngwane abko ñü ngämi näkäen temen, känenkri abti Noé nikani rute, ye ngwane ni jökrä tö namani nünai ño, erere nämane nüne, aisete nämane mröre, dö ñaen amne nämane ja mike gure. ");
INSERT INTO gymNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ne aisete nämane jäme, te batibe ñü jatani jobe temen, käkwe ñö mikani niren kri abko nikani nitre ye ngwena jökrä abko müre neketani ñöte, ñobtä ñan angwane niaratre kwani jäme ñüye, ye kwrere arato ti Ni Kä Nebtä Ngobo ne jatadita angwane, kukwe rakadikä kore arato. ");
INSERT INTO gymNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ye abko ti bike bä mike krörö munye: Ti jatadita ye ngwane ni tädi nibu sribire jäme tirete abko btäräbe iti jänäin amne iti abko mikadite. ");
INSERT INTO gymNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Erere arato, meri tädi nibu trigo ukwe jäme abko btäräbe iti jänäin amne iti abko mikadite. ");
INSERT INTO gymNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ti mun Dänkien jatadita ñongwane, ye abko gare ñakare munye, aisete munkwe mokre jabti ti ngibiakäre ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kukwe mdara jire rabadre gare munye arato abko krörö: Ni gore rükadre kä ñongwane, ye rabadre gare ju bkänkäye akräke ju bkänkä käkwe kraidre gwi angwane, jändrän ñan goidre jire kän kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ni gore rükadre ñongwane gare ñakare, ye kwrere ti Ni Kä Nebtä Ngobo ne jatadre ñakare jötrö mun tädi nütüre, aisete mun tädi ngibiare ngäbti ñakare angwane, batibe rükadita, aisete munkwe mokre jabti ti ngibiakäre ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kukwe ye abko ti bike bä mike krörö: Sribikä kuin bti bkänkä rabadre tödeke amne sribikä töbtä ye abko bkänkä tä mikete ju ngibiare jakrä amne sribikä ye abko kä mrökrä erere käita nüke angwane, mrö tärä nebe biare kwe ni gwi bukakrä, sribikä kore yebtä abko ti bike niere krörö munye: ");
INSERT INTO gymNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sribikä kisete bkänkä tä sribi mike, bti bkänkä tä niken kä mdabti, bti tä kite nüketa angwane tä kwen sribi ye nuene täte bkänkäye, sribikä yebtä abko kä rabadre nuäre, ");
INSERT INTO gymNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ñobtä ñan angwane sribikä kore abko sribikä kuin abko ie bkänkä käkwe jändrän kwe mikadi gare jökrä ngibiadre jakrä abko ti tö nibi niei metre kore munye. ");
INSERT INTO gymNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Akwa sribikä moto käme ye abko rabadre töbike krörö: Ti dänkien nikani amne ñan rükadreta jötrö, rabadre nütüre, ");
INSERT INTO gymNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kä rikadre sribikä mda mda ngö tikekä amne nitre dröbaka dröbaka, ben rikadre ja gete amne rikadre mröre, dö ñaen krübäte, ");
INSERT INTO gymNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","aisete tädre jäme, ñan tädre bkänkä ngibiare ngäbti amne kä nuäi angwane bkänkä rükadreta, ye ñan tädre gare ie. Akwa batibe bkänkä rükadita ");
INSERT INTO gymNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","angwane, bkänkä ye käkwe mikadi ja tare nike krübäte amne nitre ja bä mikaka kuin abko mikadre ja ngie nuen, ye ben ketetibe ja tare nikadi kwe. Angwane batibe sribikä ye rabadi ja müaire amne tu ngö rabadi cherere jabtä ja tare nika kisete. Munkwe ñan ti ngibiadre ngäbti ne ngwane, kukwe rakadrekä kore munbtä arato. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Mdakäre abko, kä ye ngwane ni bti Ngöböta gobrane abko btä kukweta nakenkä ni ja mikaka gure kwrere abkobtä ti bike bä mike abko krörö: Bati ni iti nikani ja mike gure angwane, meri bati bati ni jätä käkwe ja mikani juto niara ngibiare ngäbti kä ngwiankäre nuäre jabtä ben amne ñotra diani kisetekisete kwetre abko ben nikani ni ja mikaka gure ye ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Akwa meri nirike abko töi ñakare amne meri nirike mda abko töbtä, ");
INSERT INTO gymNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","aisete meri töi ñakare ye abko nikani ñotra aibe ngwena; ");
INSERT INTO gymNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","akwa meri nirike töbtä ye abko nikani aseite ngwena biare boteate kekadre ñotrate jae. ");
INSERT INTO gymNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Abti meri ni jätä ye namani ni ja mikaka gure ye ngibiare ngäbti, akwa ni ye abko ñan namani nüke jötrö angwane, meri ye ie köbö jatani abti mrä angwane nikaninta kibien jökrä mda. ");
INSERT INTO gymNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yebti kä jatanina nüke ruäre deo angwane, batibe ni kukwei jarabare ngwänenkä krörö ietre: ¡Ni ja mikaka gure kitera nüke! ¡Mun jakwe kaen ngäbti! ni kukwei jarabare kore ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ye btäräbe meri bati bati ni jätä ye naninkrö jötrö, kä nikani ñotra mike biare nänkrä ni ja mikaka gure ye ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Akwa meri nirike töi ñakare ye käkwe niebare meri nirike töbtä yeye: Aseite kitera krüte ñotrate nunkän amne ñotra nibi nötöte nunkän, aisete aseite ngwianta munkwe ye munkwe bian ruäre nunye, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Abtä meri nirike töbtä ye käkwe niebare mda ietre: Nunkwe ñan aseite biandre munye, ñobtä ñan angwane nunkwe biandre munye angwane, ñan rabadre täte ni jökrä kräke, aisete aseite rürümointa ye känti mun rikadre kökö jötrö jakrä abko rabadre bäri kuin, niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ye erere bkänä, meri nirike töi ñakare ye nikani aseite kökö jae. Ye btäräbe ni ja mikaka gure nükani angwane, meri nirike töbtä abko nikani nebe gwi kä ngwiankäre nuäre jabtä ni ja mikaka gure yebe angwane, jukwe dikaninbe kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yebti meri nirike töi ñakare ye jatani nüke mda, kä namani niere krörö jukwebtä: Nun Dänkien, jukwe tike nunye, namani niere. ");
INSERT INTO gymNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Akwa ni ja mikaka gure ye käkwe niebare mda ietre: Era metre mun gare ñakare tie, aisete tikwe ñan jukwe tikadre munye. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ye abko, nane kukwe rakadrekä kore munbtä, ye känenkri munkwe mokre jabti, käkwe ti ngibia ngäbti, ñobtä ñan angwane köbö mdente amne ñänä okwä nuäi angwane ti jatadita abko gare ñakare munye aisete. ");
INSERT INTO gymNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Mdakäre abko, kä ye ngwane ni bti Ngöböta gobrane abkobtä kukweta nakenkä krörö arato: Bati ni nämane iti abko jatani niken mente kä mdabti. Jatanina niken jibti, käkwe sribikä kwekwe käräbare, bti ngwian biani ngibiadre kwe jakrä ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Akwa ni itire itire töi ño ño ye erere btä ngwian biani kwe ietre, aisete ni iti, ie ngwian biani mili krärike kwe amne sribikä mda abko ie biani mili krobu kwe amne sribikä mda abko ie biani mili krati kwe, abti nikani. ");
INSERT INTO gymNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Yebti sribikä ie ngwian biani mili krärike, ye nikani sribire ngwian yebti, aisete ngwian mili krärike yebti ngwian mda ganaibare mili krärike kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ye kwrere arato, sribikä ie ngwian biani mili krobu, ye nikaninbe sribire ngwian yebti arato, aisete ngwian mili krobu, yebti ngwian mda ganaibare mili krobu kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Akwa sribikä ie ngwian biani mili krati, ye abko nikani, käkwe ngwian bkänkäkwe ye nökani jirekäbe dobote nguse. ");
INSERT INTO gymNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Yebti kä nikanina raire ta angwane, sribikä bkänkä nükaninta. Angwane ngwian biani kwe ngibiadre sribikäye, yebtä nikani kukwe ükete bentre. ");
INSERT INTO gymNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Angwane sribikä ie ngwian biani mili krärike kwe ye ara jire nükani käne, käkwe ngwian mili krärike ye bianinta bkänkäye amne ngwian mda biani mili krärike kwe arato, käkwe niebare bkänkäye: Ti Dänkien, makwe ngwian bianba mili krärike tie, akwa ngwian yebti abko tikwe ngwian mda ganaibare mili krärike arato makrä abko tä nete ne, niebare kwe bkänkäye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Abtä sribikä bkänkä käkwe niebare mda ie: Bäri kuin. Ma abko sribikä kuin amne ma kuin tödekakrä. Ngwian braibe bti makwe sribibare kuin tikrä, aisete tikwe sribi bäri kri mikadi ma kisete mda, aisete jakwe kä ngwen nuäre jabtä tibe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Angwane sribikä ie ngwian biani mili krobu kwe ye ara jire nükani mda, käkwe ngwian mili krobu ye bianinta bkänkäye amne ngwian mda biani mili krobu kwe arato, käkwe niebare ie: Ti Dänkien, makwe ngwian bianba mili krobu tie, akwa ngwian yebti abko tikwe ngwian mda ganaibare mili krobu arato makrä abko tä nete ne, niebare kwe bkänkäye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Abtä sribi bkänkä käkwe niebare mda ie: Bäri kuin. Ma abko sribikä kuin amne ma kuin tödekakrä. Ngwian braibe, bti makwe sribibare kuin tikrä, aisete tikwe sribi bäri kri mikadi ma kisete mda, aisete jakwe kä ngwen nuäre jabtä tibe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Akwa sribikä ie ngwian biani mili krati bkänkäkwe, ye nükani mda angwane niebare krörö kwe ie: Ti Dänkien, ma töta nünai ni mda mda aibe diebti, ye gare kuin tie, ñobtä ñan angwane ni mda mda tä nura nökö amne ma abko tä ngwä ötö kabre kän kä ütiäre, akwa ma abko nura nökö ñakare. Erere ni mda mda tä nura metekä amne mata ngwä ötö kabre kän kä ütiäre, akwa ma abko nura metekä ñakare jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ye mdenbtä ma jürä rababa tibtä. Abtä tikwe ngwian makwe ye nökaba jirekäbe dobote nguse, akwa ngwian makwe erere tä jökrä nete ne, niebare kwe bkänkäye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Abtä bkänkä käkwe niebare romone ie: Ma abko sribikä käme amne kä krene mabtä. Tita nura nökö ñakare, akwa tita ngwä ötö ni mda mdakän amne ti nura metekä ñakare, känti tita ngwä ötö ni mda mdakän gare kuin mae mata niere, ");
INSERT INTO gymNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","aisete ma rikadre käkwe ngwian tikwe ye mikadre bankote tikrä, abti ti jatadre nüketa angwane ngwian mda biandre tie ngwian tikwe ye bärire mda näre abko makwe ñan ngwian mikani bankote tikrä, niebare kwe sribikä yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Abti nitre nämane yete, ie sribi bkänkä käkwe niebare: Ngwian mili krati tä ni nokokwe, se denkä kän munkwe, bti sribikä kwe ngwianta mili krä jätä, seye bian munkwe, ");
INSERT INTO gymNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ñobtä ñan angwane nire nire kwe jändrän tärä kabre abko ie jändrän biandi bäri mda amne rabadi jändrän bkäne bäri kabre mda; akwa nire nire jändrän bkäne chi ye abko kän jändrän chi ye diandikä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ye mden kisete, sribikä käme krene noko kitekä kä bäri iko te ju bäre sere munkwe. Ye känti niara rabadi ja müaire amne tu ngö rabadi cherere jabtä ja tare nika kisete. Abko kore se, niebare sribikä bkänkäkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mdakäre abko, ti Ni Kä Nebtä Ngobo jatadita ja di kri bä nuärebti angwane, angeletre tikwetikwe rabadi jökrä bäre temen angwane, kürä gobrankrä bti ti rabadi täkänintbe kä bä nuärete. ");
INSERT INTO gymNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ye ngwane abko nitre nünanka kä jökräbti temen rükadi ja ükekrö ti ngwärekri angwane, ni obeja ngibiaka käta obeja erere ükekrö jenena amne kabra erere tä ükekrö jenena, ye kwrere jire tikwe ni ükadikrö ketebu jene jene. ");
INSERT INTO gymNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Amne ni jen tikwe obeja kwrere erere tikwe mikadi ja küde ruenkri amne ni ñakare tikwe kabra kwrere abko tikwe mikadi ja küde ngeberekri, ni obeja ngibiaka käta nuene obeja amne kabrabtä ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yebti nitre tädi jrei küde ruenkri, ye ie jreikwe niedi krörö: Mun die mikani ti Rünkwe ye erere jakwe jökrä nete. Ngöbökwe kä dätebare kena angwane, kä ye känti niarata gobrane ye abko niarakwe kä ükaninte biare munkrä ne mun jakwe kaen ngäbti, ");
INSERT INTO gymNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ñobtä ñan angwane mrö rababa tie angwane, munkwe ti bukaba; tomna rababa tie angwane, munkwe tomna bianba tie; ti näma dikekä ngwarbe krö kwäräkwärä ni menteni kwrere angwane, munkwe kä bianba kibiakrä tie. ");
INSERT INTO gymNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Erere arato, ti jatani bütie ngitiete angwane, munkwe dän biani tie; ti nämane nebe bren bren angwane, mun nämane nebe basare tie amne ti kita nämane ngite kä teri angwane, mun nämane nebe ti tuenbti tuenbti, aisete mun jakwe kä gobrankrä ne känti nünakäre tibe, niedi Jreikwe nitre niara küde ruenkri yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Angwane nitre nünanka metre ye käkwe niedi krörö jrei yeye: Nun Dänkien, ¿ñongwane nunkwe ma tuani mröi amne nunkwe ma bukani? ¿Erere arato, ñongwane nunkwe ma tuani tomna mdei nike amne nunkwe tomna biani ñadre mae? ");
INSERT INTO gymNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Mdakäre abko, ñongwane nunkwe ma tuani dikekä ngwarbe krö kwäräkwärä ni menteni kwrere amne nunkwe kä biani kibiakrä mae amne, ñongwane nunkwe ma tuani ja bütie nike angwane, nunkwe dän biani mae? ");
INSERT INTO gymNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Erere arato, ñongwane nunkwe ma tuani bren o ngite kä teri angwane, nun nämane niken ma tuenbti tuenbti? niedi kore kwetre jrei yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Abtä jrei ye käkwe niedi mda ietre: Ti mräkätre bäri bobre, kräke munkwe jändrän kuin nuenbare kore, ye ti ne ara jire munkwe die mikani abko ti tö nibi niei metre kore munye, niedi kore Jreikwe. ");
INSERT INTO gymNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yebti nitre tädi jrei küde ngeberekri abko ie Jreikwe niedi krörö: Mun nena biare ja tare nikakäre, aisete ñukwä jutra ngitiekä kärekäre tä ükaninte biare diablu amne üai kämekäme kwe mikakäre ja tare nike, se känti nän siba amne kä mikekä tibtä nete, ");
INSERT INTO gymNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ñobtä ñan angwane mrö rababa tie angwane, munkwe ñan ti bukaba; tomna rababa tie angwane, munkwe ñan tomna bianba tie. ");
INSERT INTO gymNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ti näma dikekä ngwarbe krö kwäräkwärä ni menteni kwrere angwane, munkwe ñan kä bianba kibiakrä tie. Erere arato, ti jatani bütie ngitiete angwane, munkwe ñan dän biani tie; ti näma nebe bren bren amne ti kita nämane ngite kä teri angwane, mun ñan nämane niken ti tuenbti, niedi Jreikwe nitre yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Abtä niaratre käkwe niedi krörö: Nun Dänkien, ¿ñongwane nunkwe ma tuani mrö nike, tomna mdei nike amne ñongwane nunkwe ma tuani ja bütie nike? ¿Erere arato, ñongwane nunkwe ma tuani dikekä ngwarbe krö kwäräkwärä ni menteni kwrere amne ñongwane nunkwe ma tuani bren bren amne ngite kä teri, akwa nunkwe ñan ma die mikani, mata niere ye? niedi kwe jrei yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Angwane jrei ye käkwe niedi krörö mda ietre: Ti mräkätre bäri bobre bobre abko kräke munkwe ñan jändrän kuin nuenbare jire chi, aisete ti ne ara jire kräke munkwe ñan jändrän kuin nuenbare arato abko ti tö nibi niei metre kore munye, Jreikwe niedi nitre yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yebti nitre ye abko näin kä ja tare nikakrä kärekäre ye känti amne nitre nünanka metre metre abko näin nüne kärekäre Ngöböbe. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesukwe diribare ünän jökrä, yebti nun ja töitikaka ben ie nieba krörö kwe: ");
INSERT INTO gymNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Bieta Pascua abko köböi nebera köböbube, ye garera munye angwane, Pascua ye näire abko ti Ni Kä Nebtä Ngobo ne kitadi ngise müre ketadre krusobtä, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ye erere bkänä, kä ye ngwane abko nitre ji dokwäte nitre blitaka Ngöböbe ni mda mda diärebti amne nitre unbre ji dokwäte käkwe ja ükaninkrö gätäbtä nitre blitaka Ngöböbe ni mda mda diäre dänkien kädian nämane Caifás gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ye känti ni ngökadre ño kwetre köböire Jesu kadre ngite kwetre, bti müre ketadre kwetre abko nikani ükete Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Akwa nane ni kwati krübäte nämane Jerusalén Pascua köböikrä käkwe rüdre bentre Jesu dokwäre, aisete Pascua näire ñan nuendre, niaratre namani niere. ");
INSERT INTO gymNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kä ye ngwane abko Jesu näma juta Betaniate Simón juete. Jesu ngämi Simón ye miketa kuinta, känenkri Simón ye abko kädian nämane lebroso arato abko känti Jesu näma. ");
INSERT INTO gymNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ye btäräbe meri jataba iti nüke Jesu ken angwane, jä bä ngwen kädianta alabastro abko dätebare boteare abko krati meri ye näma näin ñö rä bäne ütiäte kri ngwena abko rükaba Jesu känti. Jesu abko näma täkänintbe mesabtä angwane, meri ye käkwe ñö rä bäne ye kekaba Jesu dokwäbti. ");
INSERT INTO gymNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Merikwe ñö rä bäne ütiäte kri ianteba Jesubti nun okwäbti angwane, nun ja töitikaka Jesube moto rababa romon, kä rababa niere krörö: ¿Se ñobtä meri se tä ñö rä bäne ütiäte kri iente ngwarbe se? ");
INSERT INTO gymNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ñö rä bäne se rürümoindre ngwian kabre btä kwe abti ni bobre bobre die mikadre kwe bä amarebti ininte ngwarbe kwe se, nun rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Nun rababa ñäke kore ye kukwei jaraba Jesuye. Abtä nieba kwe nunye: Meri ne käkwe jändrän kuin nuni tikrä. ¿Se ñobtä abko mun nibi nike krübäte dikaro? ");
INSERT INTO gymNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nitre bobre bobre tädi käre mun ngätäite nete abko munkwe die mikadre, akwa ti abko ñan tädi kärekäre munbe nete, aisete niarakwe ti miri ütiäte kore abko tä dbe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Meri ne käkwe ñö rä bäne kiri ti ngrabare, yebti abko ti miri juto biare kwe doboi mikadre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ye abko, ti bike kukwe era erere niere munye abko krörö: Kukwe kuin tibtä ye kädriedi mdente mdente erere, ye känti meri ne käkwe jändrän kuin nuni tikrä mtare ne kädriedi arato, aisete jändrän kuin nuni meri nekwe, yebtä rükadita töre. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Abti nun ja töitikaka Jesube ni jätäbti nibu, ye ngätäite ni iti kädian nämane Judas Iscariote abko rikaba nitre blitaka Ngöböbe ni mda mda diäre dänkientre ye känti, ");
INSERT INTO gymNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","käkwe niebare krörö ietre: Ti tö Jesu kitai ngise munye, akwa ¿ye abko munkwe ütiä biandre nuäi tie? niebare kwe. Angwane nitre ji dokwäte ye käkwe ngwian mnüne biani gre ketamä Judaye Jesu ütiäre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ye näire mentokwäre Judas namani kä kuin ngibiare kisere jae, Jesu kitakäre ngise. ");
INSERT INTO gymNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yebti bieta Te Lebadura Ñakare Bante kweta nämane ye köböi kena rükaba angwane, nun ja töitikaka Jesube käkwe krötaba ken käkwe nieba ie: ¿Mrö kwetadre bieta Pascuakrä ye abko nunkwe sribedre mdente makrä, ie ma tö nibi? nieba nunkwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Angwane Jesukwe nieba krörö nunye: Mun nän juta Jerusalén sete, ye känti ni kwandi iti munye abko ie munkwe nie krörö: Dirikä nunkwe käkwe niemna krörö mae: Kä kitera nüke ja ken ti käne, aisete mrö Pascuakrä abko ti tö kwetai ketetibe nitre ja töitikaka tibe ben, aisete ti näin mröre niaratrebe ma juete, tikwe nini abko munkwe nie ie. Abko kore se, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ye erere bkänä, Jesukwe nun juanba mrö ükete biare, ye kwrere nun janama nuene, käkwe mrö sribeba kwetadre bieta Pascuakrä. ");
INSERT INTO gymNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yebti kä jatabara diore dere angwane, Jesu näma täkänintbe mesabtä nun ja töitikaka ni jätäbti nibu ben. ");
INSERT INTO gymNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nun näma mröre angwane, Jesukwe nieba krörö: Ti bike kukwe era erere niere munye abko krörö: Mun iti tä nete käkwe ti kitadi ngise ti rüeye, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yebtä abko nun moto rababa ulire jökrä angwane, nun itire itire rikaba niere ja täritäri Jesuye: Ti Dänkien, ¿tikwe nuendi ya gwari? nun rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Abtä Jesukwe nieba mda nunye: Ni iti käta ban mike tibo gwaire tibe blato kwatibe te, ye abko käkwe ti kitadi ngise, ");
INSERT INTO gymNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","akwa ti, Ni Kä Nebtä Ngobo abko müre ketadi ño, ye tä tikani Ngöbö Kukweibtä abko erere rakadikä. ¡Akwa ni ti kitaka ngise abko ñan bobre jakän ya! Ni ye nin däredre näre abko därebare, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Angwane Judas kä nämane Jesu kite ngise tiebe ye käkwe nieba mda Jesuye: Dirikä, ¿tikwe ma kitadi ngise ya? nieba kwe. Abtä Jesukwe nieba mda ie: Ma ara käkwe ti kitadi ngise erere makwe nini metre, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yebti nun näma mröre jökrä angwane, Jesukwe ban dianba kunti kisete, käkwe kuin nieba btä Ngöböye, bti ötabtäba kwe, bti bianba kwe nun ja töitikaka benye, käkwe nieba: Ban ne abko ti ngätä ara. Ne kaen ngäbti munkwe, bti munkwe kweta, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yebti uba döi näma basote abko Jesukwe dianba kisete, bti kuin nieba btä kwe Ngöböye, bti bianba kwe nunye, käkwe nieba: Uba döi tä basote ne ñaen ja täritäri munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Uba döi ne abko ti därie tikwe ara. Ngöbökwe kukwe ükadite btin munbe ye abko rabadi bare täte jökrä ti därie nebti. Erere arato, ti därie rimiadite ni kwati kräke köböire ni kwati ngite Ngöbö rüere ye Ngöbökwe diandikä mento btä. ");
INSERT INTO gymNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Akwa Ngöböta gobrane ye känti tikwe uba döi btin ñadita munbe, akwa ti ngämi ñaen munbe, känenkri tikwe ñan ñadreta jire chi abko ti tö nibi niei munye. Abko kore se, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yebti nunkwe ka Salmobtä nieba ünän jökrä, bti nun rikaba Ngitio Olibobti. ");
INSERT INTO gymNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Angwane Jesukwe nieba nunye: Kukwe rakadikä tibtä, yebtä mtare deo mun gitiadi iti iti kwäräkwärä tibtä mentokwäre, ñobtä ñan angwane Ngöbö Kukwei käta ti bä mike obeja ngibiaka kwrere amne mun abko obeja tikwe kwrere abko krörö: Tikwe obeja ngibiaka kämikadi angwane, obeja kwe abko gitiadi kratikrati kwäräkwärä, abko Ngöbö Kukwei tä niere kore munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Akwa ti müre ketadi, bti ti rükadita nire angwane, ti näin mun ngäbti Galilea, känti ni rabadita ketetibe jökrä, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Abtä Pedro käkwe nieba Jesuye: Ni mda mda käkwe ñan tödekadre mabti, aisete gitiadi mabtä mento, akwa ti abko käkwe ñan nuendi jire chi kore, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Abtä Jesukwe nieba mda ie: Mtare deo antlan ngämi ngwäne, känenkri makwe ti rükandite bämä jire abko ti tö nibi niei metre mae, nieba kwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Abtä Pedrokwe nieba mda Jesuye: Ti kämikadre gwaire mabe ya ño, akwa tikwe ñan ma rükandite jire chi, nieba kwe. Amne nun ja töitikaka Jesube abko rababa ñäke gwaire jökrä Pedro kwrere siba. ");
INSERT INTO gymNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yebti nun ja töitikaka Jesube, ben Jesu rikaba nebe käkä Getsemaní känti angwane, Jesukwe nieba nunye: Täke temen yete munkwe amne ti abko bike niken känime nokore blite Ngöböbe, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yebti Pedro amne Zebedeo ngobo nibu Juan amne Santiago aibe ngwianba kwe jabe. Yebti Jesu moto jatani ulire amne moto namani bete krübäte ja jiebti, ");
INSERT INTO gymNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","käkwe niebare nitre nimä yeye: Ti moto nibi ulire krübäte dikaro tie, aisete ti kebera krüte nibi ruen tie, aisete mun raba ti ngibiare nete, akwa munkwe ja ngwätei siba tibe amne munkwe ñan kibia, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ye btäräbe Jesu nikani bä mente temen se kwrere, känti nikani ngitiekä ngukudokwäbti temen, käkwe ja okokrä mikani nebe dobobtä temen amne blitabare krörö kwe Ngöböbe: Ti Rün tikwe, ti kite ja tare nike kri krübäte jakän, akwa tikwe ñan ja tare nikadre kore, ie ma tö ne ngwane, makwe dian ti bäre. Akwa ma tö dreye tikrä, ye erere raba bare tibtä amne ñan ti töi abko erere rabadre bare, niebare kwe Rün Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Yebti nitre nimä ja töitikaka Jesube näma, ye känti Jesu nikaninta angwane, niaratre nämane kibien kuin jökrä, btä Jesu namaninta angwane, Jesukwe niebare Pedroye: ¿Ñänä okwä kratibe abko te kä ñan nü munye ja ngwätere blitakäre Ngöböbe gwaire tibe ya? ");
INSERT INTO gymNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Diablu jatadi mun nuente ja käne ye ngwane, munkwe ñan ja mikadre ngite, abkokäre munkwe ja ngwätei amne munkwe blita jakrä Ngöböbe, ñobtä ñan angwane mun töi abko tä biare jändrän kuin nuene, akwa mun di ñakare, aisete munkwe blita jakrä Ngöböbe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yebti Jesu nikani bliteta bobukäre Ngöböbe, käkwe niebare krörö: Ti Rün, tikwe ja tare nikadre kri krübäte jakän, ye makwe dian ti bäre, akwa tikwe ja tare nikadre kri, abti makwe diandrekä tibti, ye ngwane ma tö dreye, ye erere raba bare tibtä, niebare Jesukwe Rün Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Yebti nitre nimä ja töitikaka Jesube, ye känti Jesu nikaninta angwane, namani kibien kuin jökrä, ñobtä ñan angwane köbö namani krübäte ietre, aisete okwä kwata namani neketekäbe jabtä köbö kisete, btä Jesu namaninta. ");
INSERT INTO gymNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Abtä Jesukwe ñan ñäkäbare mda ietre angwane, nikani bliteta bämäkäre Ngöböbe amne Jesukwe blitabare ño käne, ye kwrere blitabareta kwe Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Abti nitre nimä ja töitikaka Jesube, ye känti Jesu nikaninta angwane, Jesukwe niebare ietre: ¿Mun tä kibien amne mun tä jadüke janknu ya? Nitre kukwe kämekäme nuenkä abko kisete ti Ni Kä Nebtä Ngobo ne kitadi ngise ye abko käi nüra, ");
INSERT INTO gymNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","aisete ni ti kitaka ngise tiebe ti rüeye abko nükera tibtä, aisete näin krö, bränta, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu näma blite kore, ye btäräbe ni iti ja töitikaka ben kädian näma Judas Iscariote ye ara jataba nüke Jesu känti. Judas ye abko näma näin ni kwati ben. Nitre jataba ben ye abko näma näin ngitra ngwena kisete amne ruäre abko näma näin krito ngwena kisete. Nitre ye abko näma näin nitre blitaka Ngöböbe ni mda mda diäre Dänkien käbti amne nitre unbre ji dokwäte käbti arato. ");
INSERT INTO gymNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Angwane Judas, Jesu kitaka ngise, ye abko käkwe nitre töi dianina käkwe niebare ietre: Nire demain tikwe mun okwäbti ye abko Jesu ara, aisete munkwe niara ye ka ngite, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ye erere bkänä, Judas jataba nüke, ye btäräbe rikaba Jesu känti, käkwe nieba krörö ie: ¡Ñantöre Dirikä! nieba kwe. Bti Jesu demainba kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Abtä Jesukwe nieba mda ie: Ja mräkä ma tö nibi dre nuein, ye erere makwe mika nebe bare jötrö, nieba kwe Judaye. Angwane nitre jataba Jesu rüere ye käkwe krötaba Jesu ken, rankwaba btä, käkwe kaba ngite. ");
INSERT INTO gymNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ye btäräbe ni iti ja töitikaka Jesube käkwe ngitra diankaba kwatate, bti ni klabore ni blitaka Ngöböbe ni mda mda diäre dänkienkwe ye olo tikakaba ta kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Abtä Jesukwe nieba ie: Ngitra ye miketa jötrö kwatate yete, ñobtä ñan angwane ni rükä ngitrabti abko kämikata ngitrabti arato, aisete ngitra ye üketa. ");
INSERT INTO gymNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Tikwe ja di kärädre ti Rünye angwane, gwängwarbe niarakwe angele juandre kabrekabre krübäte rüre ti dokwäre, ye gare ñakare mae ya amarebti ye? ");
INSERT INTO gymNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Akwa tikwe ja di kärädre kore ti Rünye angwane, Ngöbö Kukwei tä tikani tibtä abko erere ñan rabadre bare, aisete tikwe ñan angele kärädre ti Rünye rükäre ti dokwäre, nieba Jesukwe nun ja töitikaka ben yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yebti nitre rikaba Jesu kaen ngite, ye ie Jesukwe nieba krörö: ¿Ñobtä abko bäsi ni gokä kri krübäte rüere ngitra jäta niken amne krito jäta niken, kwrere jire mun kite ngwena ti rüere ti kakäre ngite ye? Käre köbö kwatirekwatire tita dirire ju blitakrä Ngöböbe käntita temen, akwa mun ñakare ti kaen ngite. ");
INSERT INTO gymNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Akwa nitre Ngöbö kukwei niekä käkwe tärä tikani tibtä, ye erere rabadre bare täte jökrä tibtä, abkokäre mun nüke ti kaen ngite kore, nieba Jesukwe ietre. Jesukwe ñäkäba kore, ye btäräbe nun ja töitikaka ben käkwe kä mikakaba batibe jökrä amne nun gitiaba iti iti kwäräkwärä amne nunkwe Jesu mikateba kaibe rüeye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yebti nitre Jesu kaka ngite ye nikani Jesu ngwena nebe Caifás gwiriete. Caifás abko ni blitaka Ngöböbe ni mda mda diäre dänkien. Angwane Caifás gwiriete abko Kukwe Biani Ngöbökwe Moiséye dirikätre nämane ja ükaninkrö ketetibe nitre unbre ji dokwätebe abko känti Jesu jänikani. ");
INSERT INTO gymNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jesu jänikani angwane, Pedro abko jatani bä mente temen siba Jesu jiebti. Yebti nikani nebe ju bäre ni blitaka Ngöböbe ni mda mda diäre dänkien ye känti. Pedro nikani siba ki teri angwane, guardia ju blitakrä Ngöböbe ngibiabtikä nämane täkänintbe, ye känti Pedro namani täkänintbe siba amne dre rakadikä mda Jesubtä abko tö namani tuai, aisete nikani yete. ");
INSERT INTO gymNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkien amne Sanedrin namani kukwe känene ngwarbe Jesu rüere Jesu kitakäre ngise müre ketadre, ");
INSERT INTO gymNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","akwa kukwe era erere ñan namani kwen ietre Jesu rüere. Ni kwati namani nüke blite ngwarbe Jesu rüere, akwa kukwe ñan namani kwen jire chi ietre Jesu kitakäre ngise. Yebti ni mdara jire namani nibu ");
INSERT INTO gymNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","abko käkwe niebare krörö Jesu rüere: Ni noko käkwe nieba krörö: Ju blitakrä Ngöböbe se ti raba juen ngwarbe jökrä, abti köbömäkäre angwane, ti raba miketa täte, nieba kwe nun okwäbti, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Yebtä abko ni blitaka Ngöböbe ni mda mda diäre dänkien ye nükani dikekä krö, käkwe niebare Jesuye: ¿Kukwe nie nibi ma rüere, se ño metre amarebti ma nibi kwekbe jirekäbe ye? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Akwa Jesu abko namani kwekbe janknu. Abtä ni blitaka Ngöböbe ni mda mda diäre dänkien ye käkwe niebare mda Jesuye: Ngöbö nire tä nüne se käbti makwe kukwe era erere nie tie abko krörö: ¿Ma abko Ni Dianinkä Ngöbökwe ara ya amne ma abko Ngöbö Odei ara ya? ye niere nunye, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Angwane Jesukwe niebare mda: Jän ti abko ni ño nini makwe, ye kwrere bkänä, akwa ti bike kukwe mdara jire niere arato mun jökräye abko krörö: Kä bäri ütiäte kri Ngöbö Di Kri Jändrän Jökrä Nuenkrä ye küde ruenkri munkwe Ni Kä Nebtä Ngobo tuadi täkänintbe. Erere arato, jatadita mütabti käinta sete amne munkwe tuadi, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Angwane ni blitaka Ngöböbe ni mda mda diäre dänkien ye moto namani romon, käkwe dän ngianinkä seeen jabtä romone, käkwe niebare krörö: ¡Ni ne käta ñäke taretare Ngöbö rüere! ¿Se abko ni mda mda käkwe niara kitadre ngise amne batibe ngite, nikwe niedre ya? Ñakare, ñobtä ñan angwane niarakwe ñäri tare Ngöbö rüere, ye nunkwe kukwe nurira ñan ñan. ");
INSERT INTO gymNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Munkwe töbikadi ño mda kräke? niebare kwe. Angwane nitre jökrä nämane yete käkwe niebare: Niarata ja mike ngite, aisete krütadre jirekäbe, niebare kwetre mda. ");
INSERT INTO gymNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ye btäräbe nitre ye käkwe käli kitani Jesu ngwärebtä amne nikani mete ja käne amne ni mda mda abko namani Jesu mete ngwärebtä mikakäre ngwarbe jae, ");
INSERT INTO gymNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","kä namani niere ie: Ma abko Ni Dianinkä Ngöbökwe bkänä ne ngwane, nirekwe ma miti ngwärebtä ye niere metre nunye, namanintre niere Jesu mikakäre yakrä jae. ");
INSERT INTO gymNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kukwe nämane nakenkä kore Jesubtä angwane, Pedro abko namani täkänintbe ju bäre. Ye btäräbe meri sribikä yete jatani nüke Pedro ken, käkwe niebare ie: Jesu Galileabo se ben ma nämane dikekä siba arato, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Akwa nitre nämane yete, ye ngwärekri jökrä Pedrokwe ja rükaninte, käkwe niebare: Mata blite drebtä abko ñan nebe nüke gare tie, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Yebti Pedro nikani, namani nünaninkä jukwete kibtä, känti meri sribikä mdara jire ie niara jatabare angwane, ni ye käkwe niebare ni mda mdaye: Jesu Nazarebo abko ben ni noko nämane dikekä siba, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Angwane ja rükanrete kwärä Pedrokwe ja kukwe biani, kä namani niere krörö: Ni kädekata Jesu makwe, ni ye gare ñakare jire chi tie, namani niere. ");
INSERT INTO gymNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yebti nitre nämane yete käkwe krötabare mda Pedro ken, käkwe niebare ie: Ma ye tä nekete arato Jesube kwrere, ñobtä ñan angwane mata blite ño, ye aibebti ma reketaka niarakri abko ma nibi bä mike jabtä, niebare kwetre Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Angwane Pedrokwe ja kukwei bianinta amne niarakwe ñan kukwe niedre metre ne ngwane, Ngöbökwe ngürün mikadre btä namani niere, käkwe niebare mda: Ni kädekata Jesu munkwe, ni ye abko gare ñakare jire chi tie, niebareta kwe. Ye btäräbe antlankwe ngwänänbare. ");
INSERT INTO gymNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Angwane Jesukwe kukwe niebare krörö Pedroye abko nükaninta töre ie: Antlan ngämi ngwäne, känenkri makwe ti rükandite bämä jire, niebare Jesukwe ie, ye nükaninta töre ie angwane, nikani mentokwäre se kwrere, käkwe ja müaibare kri kä bäre mento. ");
INSERT INTO gymNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kä jatani ngwen dekä angwane, nitre blitaka Ngöböbe ni mda mda ma diäre dänkientre amne nitre unbre ji dokwäte nitre israelita ngätäite ye käkwe kukwe ükaninte Jesu müre ketakäre. Yebtä abko ja töi mikani kwatibe jökrä kwetre, ");
INSERT INTO gymNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","käkwe Jesu kise mäkäninte jökrä, bti jänikani ngite Pilato ngwärekri. Pilato abko gobran romanobo. ");
INSERT INTO gymNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Angwane Judas Jesu kitaka ngise tiebe ye abko Jesu kitani ngite müre ketadre gani kwe angwane, ja namani ruen ngite krübäte ie. Abtä nikaninta, käkwe ngwian mnüne gre ketamä ye bianinta jökrä nitre ji dokwäteye amne nitre unbre ji dokwäte yeye, ");
INSERT INTO gymNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","käkwe niebare ietre: Jesu abko ngite ñakare, akwa tikwe kitaba ngise müre ketadre. Yebtä abko tikwe ja mikaba ngite Ngöbö rüere, aisete ti bike ngwian bienta jirekäbe munye, niebare kwe. Akwa nitre ye käkwe niebare Judaye: Mata kukwe niere ye abko ngwarbe, ütiäte ñakare nunkrä, ñobtä ñan angwane ye abko kukwe kaibe makwe. Abko kore se, niebare kwetre Judaye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Angwane ju blitakrä Ngöböbe ye känti Judakwe ngwian ye kitani temen, bti Judas nikani, käkwe ja müre ketani köte. ");
INSERT INTO gymNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Abtä nitre ji dokwäte nitre blitaka Ngöböbe ni mda mda diärebti ye käkwe ngwian ye ükaninkrö, käkwe niebare krörö: Ni müre ketadre abko ütiä biani ngwian nebti, aisete ngwian biani Ngöbökrä ye ben ketetibe ni ñan raba ngwian ne mike, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Abti ja töi mikani kwatibe kwetre kä kökakrä ngwian yebti. Kä kädeka nämane ni kantra sribekä abko käi nie nämane, ye abko kökani kwetre ngwian yebti nitre menteni doboi mikakrä, ");
INSERT INTO gymNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","aisete kä ye abko kädianta krörö: Ni Müre Ketani Käi abko nieta kore abko kä nüke mtare. ");
INSERT INTO gymNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kä kökani kore kwetre angwane, kukwe niebare ni Ngöbö kukwei niekä kira Jeremíakwe namani bare abko tä tikani krörö Ngöbö Kukweibtä: Niara ütiä mikani nuäi nitre israelitakwe, ye erere ngwian mnünebe biani gre ketamä niara ütiäre amne, ");
INSERT INTO gymNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ngwian yebti abko kä kädekata Ni Kantra Sribekä Käi nieta abko kökani, ni Dänkien Ngöbö käkwe nuemna ño tie, ye erere namani bare, abko niebare kore Jeremíakwe, ye erere namani bare. ");
INSERT INTO gymNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesu abko jänamani gobran Pilato ngwärekri angwane gobran ye käkwe niebare ie: ¿Ma abko jrei nitre israelitakwe bkänä ya? niebare kwe Jesuye. Angwane Jesukwe niebare mda ie: Jän. Era metre ti ara, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkientre btä nitre unbre ji dokwäte namani Jesu kite ngise krübäte, akwa Jesu abko namani kwekbe jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Abtä Pilato käkwe niebare krörö ie: ¿Kukwe nie nibi bätäkä ngwarbe ma rüere ye jaraen ñakare mae ya amarebti ma nibi kwekbe jirekäbe? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Akwa Jesu namani kwekbe janknu, nin ñäkäbare jire chi kwe Pilato käre. Abtä gobran Pilato ye ñan töi namani krütare mda Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kä kwatirekwatire bieta Pascua näire abko nitre ngite ye ngätäite nire tikadreteta abko nitre israelita kwati nämane niere abko erere käre gobran ye nämane tikete. ");
INSERT INTO gymNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ne aisete kä ye ngwane ni iti ja mikaka ngite kri krübäte abko nämane kitani ngite kä teri yete. Ni ye abko kädian nämane Barrabás. ");
INSERT INTO gymNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Gobran Pilato ye ñan töi namani krütare mda Jesubtä. Yebti ni jökrä namani ja ükaninkrö yete, ie Pilato käkwe niebare mda: Tikwe nire tikadreteta munkrä ie mun tö nibi. Barrabás ya o Jesu Ni Dianinkä Ngöbökwe nieta se tikadreteta, niere tie munkwe, niebare Pilatokwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato abko käkwe niebare kore, ñobtä ñan angwane nitre ji dokwäte ye namani mokrere Jesube, abtä kitani ngite kwetre abko ganina Pilatokwe btätre, aisete niebare kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yebti kürä kukwe ükatekrä gobrankwe, yebti Pilato nämane täkänintbe angwane, merire kwe käkwe kukwe juani krörö kräke: Ni ye abko töi metre amne ngite ñakare, aisete makwe ñan kukwe nuen käme rüere, ñobtä ñan angwane ni yebtä tikwe ja käbätiri krübäte deo abko Pilato merirei ye käkwe niemna kore ie. ");
INSERT INTO gymNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Akwa nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre unbre ji dokwäte käkwe nitre kwati ye töi kwitani jakri amne Barrabás abko tikadreteta amne Jesu abko müre ketadre abko ni jökrä käkwe niedre, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Abtä gobran ye käkwe niebareta mda ietre: ¿Ni nibu tä ngite kä teri nete, ne mden tikadreteta ie mun tö nibi? niebare kwe. Angwane ni jökrä israelita nämane yete käkwe niebare: ¡Barrabás ye tiketeta! namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Angwane Pilatokwe niebare mda ietre: ¿Jesu abko Ni Dianinkä Ngöbökwe nieta, sebtä abko tikwe dre nuendre, ie mun tö nibi amarebti yere? niebare kwe. Angwane ni jökrä käkwe niebare: ¡Jesu ye müre kete krusobtä! namanintre niere mda. ");
INSERT INTO gymNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Abtä Pilato käkwe niebare mda ietre: ¿Drebtä ni nekwe ja mikani ngite amarebti, mun nibi müre ketamna krusobtä tie yere? niebare kwe ietre. Yebtä namani ngrente bäri jume mda, kä namani niere: ¡Müre kete krusobtä, müre kete krusobtä! namanintre niere Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Abtä ni jökrä ñan namani tuen töi kwitare jire chi Pilatoye angwane, niarakwe kukwe niebare, yebtä bäri ni jökrä jatani kä mike bäri nokre. Abtä Pilato käkwe ñö käräbare, bti ja kise bätäninte kwe nitre israelita ngwärekri, käkwe niebare krörö ietre: Jesu müre ketadi, yebtä ti ñan rabadre ngite, ñobtä ñan angwane ye abko kukwe munkwe, aisete mun rabadi ngite Jesu dokwäre, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Angwane nitre israelita käkwe niebare krörö mda Pilato käre: Jesu müre ketadi ye abko nun amne ngäbäkre nunkwe abko rabadi ngite Ngöböye, aisete nunkwe kötä mikadi ie, niebare kwetre Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Angwane Pilatokwe Barrabás tikaninte. Akwa Jesu abko kwata metamna köbti kwe amne biani kwe rükä romanoboye müre ketadre krusobtä. ");
INSERT INTO gymNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ye erere bkänä, nitre rükä gobrankwe ye nikani Jesu ngwena nebe ju gobrankwe känti angwane, nitre rükä käkwe ja ükaninkrö jökrä Jesu bäre mikakäre yakrä jae, ");
INSERT INTO gymNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","käkwe dän tikaninte btä, bti dän bä tain drüne kita nämane jabtä jreikwe, ye kwrere kitani Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Erere arato, jrei kri käkwe korona mikadre ja dokwäbti, ye kwrere kri tukwä krübäte sribebare koronare kwetre, bti mikani Jesu dokwäbti kwetre, bti mökän mikani krati Jesu kise ruenkri kwetre niara mikakäre yakrä jae jrei di kri kwrere. Yebti namanintre jökrä ngukudokwäbti temen Jesu ngwärekri, kä namani niere krörö ie mikakäre ngwarbe jae: ¡Ma jrei nitre israelitakwe, nunta ma mike ütiäte kri mtare! namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kä namani käli kite Jesubtä amne mökän mikani kisete kwetre ye arabebti namanintre Jesu mete dokwäte. ");
INSERT INTO gymNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jesu mikani yakrä kore kwetre jae, bti dän bä tain drüne ye tikaninteta Jesubtä kwetre, bti dän Jesukwe ara kitaninta btä kwetre. Yebti nikanintre ngwena müre ketadre krusobtä. ");
INSERT INTO gymNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yebti namanina ji ngrabare angwane, ni iti nünanka juta Cirenete abko kädian nämane Simón abko namani ngätäi bentre angwane, Simón ye mikani kruso ngwena Jesukrä rükäkwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Bti nikanintre nebe käkä Gólgota känti. Kä Gólgota ye abko “Ni dokwä kroko käi” nieta abko känti nikanintre nebe Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Angwane krikä kwaka mritani uba döibe mni mni biani ñadre kwetre Jesuye. Jesu käkwe dö ye bänän nuani angwane, nin ñani jire chi mda kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Angwane nitre rükä romanobo käkwe Jesu metani krusobtä. Yebti tö namanintre dän Jesukwe ñäkäitbe jabti, käkwe ja gani dän yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Yebti nitre rükä ye namanintre täkänintbe temen Jesu ngibiabtikäre. ");
INSERT INTO gymNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Angwane ñobtä Jesu kitani ngise müre ketadre abko nämane tikani kri kukwänbtä abko mikani krusobtä Jesu dokwä känti käin abko btä kukwe nämane tikani krörö: “NI NE ABKO JESU. NIARA ABKO JREI NITRE ISRAELITAKWE” abko nämane tikani kore. ");
INSERT INTO gymNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jesu metani krusobtä angwane, nitre gokä metani nibu krusobtä käin arato niarabe gwaire. Iti mikani niara küde ruenkri amne iti abko mikani niara küde ngeberekri. ");
INSERT INTO gymNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Angwane nire nire namani kite dikekä Jesu bäre, kä namani dokwä ngrüketbe ñäkäre kwärä Jesuye, Jesu mikakäre ngwarbe jae, ");
INSERT INTO gymNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","kä namanintre niere ie: Ju blitakrä Ngöböbe se makwe juandi ngwarbe abti köbömäkäre makwe mikadreta täte jökrä, makwe niebare, aisete ma Ngöbö Odei bkänä ne ngwane, ja denkä au mento krusobtä yete, bti ma jatata timon, namanintre niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Erere arato, nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne Kukwe Biani Ngöbökwe Moiséye dirikätre amne nitre unbre ji dokwäte abko namanintre Jesu mike yakrä jae, kä namani niere krörö ie: ");
INSERT INTO gymNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ni mda mda dianintari kwe, ¿se ñobtä abko ñan nebe ja dentari au se? Niara abko Jrei nitre israelitakwe nieta kwe jabtä, aisete ja diandrekä au krusobtä mento kwe sete angwane, nunkwe mikadi ütiäte jae. ");
INSERT INTO gymNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mdakäre abko, niarakwe ja töi mikani kwatibe Ngöböbtä, aisete Ngöbö tö era metre ie bkänä ne ngwane, Ngöbö ara jire käkwe diandikä gwängwarbe krusobtä mento mtare. Niara nämane ja Ngöbö Odei niere jabtä amarebti nibi kwekbe krusobtä käin se, namanintre niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Angwane nitre gokä nämane metani kruso mda mdabtä käin arato Jesu ken, ye namani ñäke arato Jesuye, mikakäre yakrä jae. ");
INSERT INTO gymNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Yebti ñänä ruäre angwane, kä ngidianinte mda amne kä namani iko jökrä temen nükebe ñänä okwä krämä dere. ");
INSERT INTO gymNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ñänä okwä krämä nükani, ye btäräbe Jesukwe ngratebare kri ja dibti, käkwe niebare krörö: Elí, Elí ¿lama sabactani? niebare kwe. Kukwe niebare kore Jesukwe ye abko “Ngöbö tikwe, Ngöbö tikwe, ¿ñobtä makwe kä mirikä tibtä jakän amarebti yere?” niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jesukwe ñäkäbare kore, ye abko nitre ruäre nämane yete käkwe kukwe nuani angwane, namanintre niere: ¿Ñan tä ni Ngöbö kukwei niekä kira kädian nämane Elías kärere jabtä, ja die mikakäre ya? namanintre niere kore. Niebare kore kwetre, ñobtä ñan angwane Jesukwe “Elí” niebare angwane, namani ruen “Elías” kwrere ietre aisete. ");
INSERT INTO gymNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ye btäräbe nitre ye nikani betekä iti, käkwe jändrän dän kukwän kwrere kä dianta esponja abko mritaninkä uba ñöi dimente, bti mäkäninte kwe nörä kräbtä, bti biani kwe ñadre tomnane Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Akwa ni mda mda abko käkwe niebare krörö ni yeye: Elías rükadre dentari ya ño ari ngibiare, aisete tuemetre yete, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ye btäräbe Jesukwe ngratebareta jume ja dibti bobuta, käkwe ja üai mikaninta Ngöbö kisete angwane krütani. ");
INSERT INTO gymNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jesu krütani, ye btäräbe dän ngutu ngetbo, bti ju blitakrä Ngöböbe nämane ñäkänintbe abko nianinkä kumu käin nükebe temen amne dobo abko namani nakenkä amne jäkwata abko ngetrani. ");
INSERT INTO gymNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Angwane kä mkä känti nitre nämane doboi mikani, ye mkä ngitianinkä jökrä angwane, ni kwati käkwe nünabare deme Ngöbökrä abko nämane doboi mikani ye nükaninta nire ");
INSERT INTO gymNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","abko käkwe kä mikaninkä rökabti yete. Yebti Jesu nükaninta nire arato angwane, niaratre nikani nebe juta demente Jerusalén. Ye känti ni kwati käkwe tuani. ");
INSERT INTO gymNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ye ngwane nitre rükä dänkien romanobo amne nitre rükä mda mda nämane Jesu ngibiarebti, ye okwäbti dobo namani nakaenkä amne kukwe mda mda namani nakenkä bätäkä ngwarbe niaratre okwäbti angwane, kä jürä namani krübäte btätre, käkwe niebare: ¡Ni noko abko Ngöbö Odei era metre bkänä! niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amne meri ruäre nämane dikekä kwäräkwärä Jesube kä Galileate, kä nämane Jesu die mike sribibtä, ye abko nükani siba Jerusalén abko namani bä mente temen se kwrere okwä Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Meritre ye abko kädian nämane María Magdalabo amne María Santiago amne José meye, erere arato Zebedeo ngäbriänkä Juan amne Santiago mdara jire abko meye nämane siba arato. ");
INSERT INTO gymNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yebti kä jatani dere angwane, ni iti ngwian bkänkä kri kädian nämane José nünanka juta Arimateate abko nükani. José ye abko nämane dikekä siba Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José ye abko nikani Pilato känti, käkwe Jesu ngwäkä käräbare Pilatoye. Ye erere Pilatokwe Jesu ngwäkä biamna Joséye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ye erere bkänä, Josékwe Jesu ngwäkä diani timon angwane, dän kädianta lino abko nämane merebe, te ngwäkä mrianinte kwe. ");
INSERT INTO gymNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Yebti kä muani btin jäkwatate ni doboi mikakrä Josékwe, ye känti Jesu doboi mikani kwe. Jesu doboi mikanina angwane, kä mkä ye dikaninta kuin jite kwe jäkwata kribti, bti nikaninta. ");
INSERT INTO gymNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Akwa María Magdalabo amne María mda nämane yete, ye abko namani täkänintbe yete Jesu doboi mikani ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jesu doboi mikani, yebti jändrinane köbö jadükakrä näire, nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre bariseo nikanintre gwaire nebe Pilato känti, ");
INSERT INTO gymNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","käkwe niebare krörö ie: Nun dänkien, ni ngwarbe ni ngökaka müre ketaba jändrin kädianta Jesu, ye abko nämane nüne angwane, nieba krörö kwe: Ti müre ketadi, akwa köbömäkäre angwane ti rükadita nire, nieba kwe, ye abko nüta töre nunye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ne aisete, makwe guardia mikadre röka ye ngibiarebti kuin nebebe köbömä näre abko nun tö nibi niei mae, ñobtä ñan angwane nane nitre ja töitikaka Jesube käkwe ngwäkä goidre abti nükaninta nire tädre näin niere ni mda mdaye, nane nitre ja töitikaka ben abko rikadre ni ngökö bäri mda, ye abko rabadre bäri käme, aisete nun tö nibi niei kore mae ye, niebare kwetre Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Abtä Pilatokwe niebare mda ietre: Nitre rükä tärä guardiare munkwe yete, ye abko ben mun rika, käkwe kä tärä mika gare kuin röka yebti ni mda mda mikakäre mokre amne munkwe röka ye ngibiadre bäri kuin. Abko kore se, niebare Pilatokwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ye erere bkänä, nitre ye nikani amne jäkwata mikani rökabti, yebtä kä tärä mikani gare kuin kwetre, ni mdakwe ñan Jesu ngwäkä goidre abkokäre. Erere arato, nitre rükä mikaninte ruäre guardiare kwetre röka ngibiarebti yete. ");
INSERT INTO gymNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yebti köbö jadükakrä nikani ta, abti kä jatani ngwen krire bämänte dekä angwane, María Magdalabo amne María mdara jire ye nikaninta dobobti. ");
INSERT INTO gymNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ye btäräbe dobo namani nakaenkä kri krübäte, ñobtä ñan angwane angele ni Dänkien Ngöbökwe nämane kä käinbti abko nükani kä temen nebtä. Angele ye abko nikani nebe rökabti angwane, jäkwata kri mikani kä mkäbti ye abko angelekwe dianinkä mento, bti namani täkänintbe jäkwata yebti. ");
INSERT INTO gymNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Angele ye abko bä namani trä ngitiekä mera trä kwrere amne dän btä abko bä namani ngwen bürere täräkwata kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Angele ye jatabare nitre rükä nämane guardiare rökabti yeye angwane, niaratre namani nekwetekä krübäte, aisete namani grükekä jökrä ngrabare amne kä nötaninte jökrä bti, aisete namanintre kitaninte temen ni ngwäkäre kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Angwane angele käkwe niebare meritre yeye: Mun ñan rekwetaka. Jesu müre ketani krusobtä abko munta näin tuenta känti, ye gare kuin tie, ");
INSERT INTO gymNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","akwa Jesu nürate nire, aisete ñakare nete, niarakwe niebare munye ye kwrere nibi bare, aisete kä mkä aibe nebe tökare niara täbtä nete mun jakwe tuen. ");
INSERT INTO gymNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bti nitre ja töitikaka Jesube ye ie mun rika niereta jötrö krörö: Jesu nürate nire, bike niken Galilea ja ükakrökäreta ketetibe munbe, känti munkwe ja tuadita ben abko munkwe nie kore ietre amne kukwe ne aibe tä niedre tikwe munye. Abko kore se, niebare angelekwe meritre yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ye erere bkänä, meritre nämane dobobti ye nikaninta jötrö angwane, kä jürä namani krübäte btätre, akwa erere arato kä namaninta nuäre krübäte btätre, aisete nikanintre betekä kukwe ngwenante nun ja töitikaka Jesube ye kräke. ");
INSERT INTO gymNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Niaratre nämane näin betekä ji ngrabare angwane, batibe Jesu ara nükani ngätäi bentre, käkwe “Ñantöre” niebare ietre. Ye btäräbe niaratre käkwe krötabare Jesu ken, nikani ngitiekä Jesu ngotobtä temen, käkwe Jesu ngoto kani ja käne angwane, mikani ütiäte kwetre jae. ");
INSERT INTO gymNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Angwane Jesukwe niebare ietre: Mun ñan rekwetaka tibtä. Ti mräkätre ja töitikaka tibe abko rikadre ti ngäbti kä Galileate. Ye känti ti tuadita kwetre abko mun nän niere ietre. Abko kore se, niebare Jesukwe meritre yeye. ");
INSERT INTO gymNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nitre merire nikani kukwe ngwena kore, akwa nämane ji ngrabare angwane, nitre rükä mikani guardiare röka ngibiarebti abko bti kä nükani ruenta amne nikani betekä nebeta jutate Jerusalén amne nitre blitaka Ngöböbe ni mda mda diäre dänkientre, ie kukwe nakaninkä ño ño, ye erere niebare jökrä kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkientre ye abko nikani blite mda nitre unbre ji dokwäte yebe ja töi mikakäre kwatibe gwaire bentre. Angwane niaratre käkwe ngwian biani kabre nitre rükä nämane guardiare rökabti yeye niaratre näkwitakäre, ");
INSERT INTO gymNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","käkwe niebare ietre: Mun nämane kibien deo angwane nitre ja töitikaka Jesube jananbare Jesu ngwäkä goireta rökabti, munkwe nie ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Erere arato, gobran Pilato käkwe kukwe ye gadi angwane, nunkwe blitadi ben niara näkwitakäre. Ye köböire abko kukwe ñan rabadre jire chi mun rüere amne nun rüere, niebare kwetre guardiaye. ");
INSERT INTO gymNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ye erere bkänä, nitre rükä nämane guardiare ye käkwe ngwian kabre ye kani ngäbti. Abti niaratre käkwe dre niedre niebare ietre, ye erere nikanintre niere, aisete nitre ja töitikaka Jesube abko käkwe Jesu ngwäkä goibare abko nie nikani kore kena nitre israelita ngätäite, ye erere nieta janknu abti kä nüke mtare. ");
INSERT INTO gymNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nitre merire käkwe kukwe nieba nun ja töitikaka Jesube yeye angwane, nun ni jätäbti iti abko rikaba bkänä Jesu ngäbti Galilea angwane, ngitio mdenbti nun rikadre niebare Jesukwe, ye känti nun rikaba. ");
INSERT INTO gymNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nun rikaba nebe yete angwane, Jesu jataba nunye angwane, Jesu ara nükaninta nire ye nun ruäre kräke ñan rababa nebe era, akwa nun jökrä rababa Jesu käikitekä. ");
INSERT INTO gymNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Angwane Jesukwe krötaba nun ken, käkwe nieba krörö nunye: Kä käinta se amne kä temen ne Ngöbökwe mikani gare jökrä tie, ");
INSERT INTO gymNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","aisete mun nän, amne nitre nünanka kä jökräbti temen, ye känti mun näin ti mike gare ietre amne munkwe niaratre mika ja töitikaka siba tibe amne munkwe niaratre ngöka ñöte ni Rün käbti, Ngöbö Odei käbti amne Ngöbö Üai Deme käbti. ");
INSERT INTO gymNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Amne kukwe diribare tikwe munye, ye erere munkwe diri jökrä ietre amne niaratre käkwe ti kukwei ye mikadre täte jökrä arato, abkokäre munkwe diri ietre. Ti abko tädi kärekäre munbe köbö kwatirekwatire nebebe kä mrä. Abko kore se, nieba Jesukwe. Abko kukwe nakaninkä kore se. Ne ngörä.");
INSERT INTO gymNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kukwe kuin nuenbare Ngöbö Odei Jesukristokwe abko nakaninkä ño kena ja täritäri abko ti bike tike täräbtä. Jesukristo nämane nüne ño abko ti bike tike täräbtä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bati kira Ngöbökwe Juan ni ngökaka ñöte juandi ni mike biare niara Odei kakäre ngäbti, ye Ngöbökwe niebare niara Odeiye angwane, tikamna krörö täräbtä kwe ja kukwei niekä kädian nämane Isaíaye: Tikwe ja kukwei ngwianka juandi iti ma känenkri. Niarakwe ni töi mikadi biare ma käne, ji ükateta biare ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ni ye näin ñäke jume ja dibti kä kaibete, käkwe niedi krörö: Ji ükateta kuin biare jrei känenkri, ye kwrere ja töi mike kuin biare munkwe. Ji ükateta niken metre ta, ye kwrere ja töi ükete metre ni Dänkien käne munkwe, niebare kwe abko tikani kore täräbtä Isaíakwe Juanbtä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ye erere bati, Juan ni ngökaka ñöte nükani kä kaibete, kä nikani niere: Munta kukwe kämekäme nuene, yebtä mun moto raba ulire. Kukwe käme kite jire jökrä temen munkwe, bti mun jata ja mike ngökare ñöte. Munkwe ye nuendi angwane, Ngöbökwe mun ngite ye diandikä jire jökrä munbtä, bti tikwe mun ngökadi ñöte, niebare Juankwe. Ngöbö Kukwei tikani Isaíakwe Juanbtä abko erere namani bare. ");
INSERT INTO gymNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ye ngwane, nitre nünanka käkä Judeate btä juta Jerusalénte nükani kwati Juan kukwei nuakäre, kä namanintre ja ngite niere Ngöböye angwane, Juan namani ngökö Ñö Jordánte. ");
INSERT INTO gymNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan abko nämane kameo drüen dikani dänre kite jabtä amne nämane mäkete nibi kwatabti jae amne mrö kweta nämane kwe abko tröda btä munkö känsenta. ");
INSERT INTO gymNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juan nämane ñäke angwane, käre namani niere krörö: Ni jatadi iti ti jiebti abko bäri di kri ti ngwä, aisete ja ñan rükadre töre jire chi tie sandalia tikete ni ye ngotobtä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tita mun ngökö ñö aibe te, akwa ni ye abko käkwe Ngöbö Üai Deme mikadi nüne munbtä. Abko kore se, niebare Juankwe. ");
INSERT INTO gymNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan nämane nitre ngökö ñö Jordánte angwane, Jesu nämane juta Nazarete kä Galilea yete. Jatani nüke Juan känti angwane, Juankwe ngökani ñöte, ");
INSERT INTO gymNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","jatani gökökäta ñöte käin, ye btäräbe kä käin ñäkänintbe Ngöbökwe namani tuen ie, bti Ngöbö Üai jatani ütü bä kwrere nüke mate btä, namani tuen ie jabtä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ngöbö kukwei jarabare krörö kä käinbti: Ma ti Ngobo tikwe. Ma tare kri tikwe. Ma käi nuäre kri tibtä, niebare kore kä käinbti Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Yebti Ngöbö Üai nikani Jesu ngwena nebe kä kaibete. ");
INSERT INTO gymNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kä ye känti Jesukwe nünantbebare köbö gre ketebu jändrän känsenta käite. Ye ngwane abko, Satana namani Jesu nuente ja käne, akwa Jesukwe ñan Satana mikani täte. Yebti angele nükani ruäre abko namani Jesu die mike. ");
INSERT INTO gymNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yebti abko, Juan kitani ngite kä teri. Yebti Jesu nikani Galilea, namani kukwe kuin Ngöbökwe niere krörö: ");
INSERT INTO gymNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ti rabadre gare kä nebtä köböi kitani Ngöbökwe abko nüra amne Ngöbö kitera gobrane nibti. Kukwe kämekäme kita temen munkwe, bti kukwe kuin Ngöbökwe nebti tödeka munkwe, Jesu namani dirire kore. ");
INSERT INTO gymNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Abti bati Jesu nikani Ñö Okwä Kri Galilea köräbäre, nikrabare kwe angwane, ni jatabare nibu ie. Iti abko kädian nämane Simón. Etba kwe abko kädian nämane Andrés. Niaratre abko gwa gaka abko nämane krade kite ñöte, btä Jesu okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesukwe niebare ietre: Mun brän tibe amne munta gwa gaen ño, ye kwrere tikwe mun mikadi ni ngwianka Ngöböye, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ye btäräbe, niaratre käkwe krade kitani temen, bti nikani Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nebti Jesu nikani mda mentokwäre ñö köräbäre angwane, ni iti kädian nämane Santiago amne etba kwe abko kädian nämane Juan abko nämane krade gudike rute. Niaratre nibu ye abko Zebedeo ngäbriänkä, btä Jesu okwä namani angwane, ");
INSERT INTO gymNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesukwe käräbare ja töitike jabe arato. Niaratre käkwe sribikä aibe mikaninte rute rün Zebedeobe, bti nikanintre Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yebti nikani jökrä juta kädian nämane Capernaúmte. Abti köbö jadükakräte angwane, Jesu nikani sinagoga yete, känti nikani dirire. ");
INSERT INTO gymNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jesu namani dirire, yebtä ni jökrä ñan töi namani krütare, ñobtä ñan angwane ni töbtä di kri käkwe diri ja di ngöi, kwrere jire Jesukwe diribare ietre amne, Kukwe Biani Ngöbökwe Moiséye dirikätre nämane dirire, ye kwrere Jesukwe diribare ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Angwane ni nämane iti sinagoga yete, btä üai käme nämane nüne. Te batibe ni ye käkwe ngratebare krörö mda: ");
INSERT INTO gymNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¡Jesu Nazarebo, nun tuemetre kaibe nete! ¿Ye ñobtä abko ma kite ja mike kukwe nunkwete ta yere? ¿Ma kite nun gaenkä ya ño yere? Jesu, ma gare kuin tie. Ma abko Ni Deme Ngöbökwe gare tie, niebare üai kämenkwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Abtä Jesukwe niebare mda üai kämeye: ¡Üai käme, kada mkä kete makwe! Ni ye tuemetre gwängwarbe. Nän mento btä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Üai käme ye käkwe ni ye ngrükaninte jume ngrabare, bti ngratebare kri kwe, bti ngitiani mento ni yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nebtä ni jökrä töi ñan namani krütare Jesubtä, kä namani niere jae kwärikwäri: ¡Ni neta kukwe btin dirire ño ño amarebti niara di tärä üai käme juentari jötrö au, tä ñäke kwatibe üai käme juantarikrä mento amne üai käme tä niara kukwei mike täte sere! abko namanintre niere kore jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kukwe nakaninkä kore, abtä Jesu kädrie nikani jötrö ngwarbe, niken kä ketareketare te kä Galilea yete. ");
INSERT INTO gymNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesu nämane sinagoga känti. Nikani angwane, nikani Santiagobe btä Juanbe nebe Simón btä Andrés känti. ");
INSERT INTO gymNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Namani känti angwane, Simón köbrän merire abko nämane bren drangwan kisete, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Abtä Jesu nikani mike ñäräre mda, nikani nebe jänbtä ken se kwrere, käkwe Simón köbrän kani küdebti, bti ganinkrö krö kwe. Ngöbö diebti drangwan nikaninbe batibe btä, namanintabe kuinta, bti nikani mrö känene niaratre bukakrä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kä jatanina iko angwane, ni kwati nünanka juta yete nükani Simón känti mräkä bren bren ngwena amne mräkä nämane ja tare nike üai käme kisete abko jänikani Jesuye mikadreta kuinta kwe abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ni namani kwati krübäte ja ükaninkrö jukwebtä angwane, ");
INSERT INTO gymNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu namani ni bren bätäkä ngwarbe miketa kuinta. Arato üai käme juanintari mento kwe ni kwatibtä. Jesu nämane sribire Ngöbö diebti abko nämane gare üai kämeye, aisete Jesukwe üai käme kukwei ötani jökrä arato. ");
INSERT INTO gymNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Abti de, kä nämane diore angwane, Jesu naninkrö, nikani kä kaibete blitakäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Simón btä kukwe muko mda mda nükani ngwäte angwane, nikanintre Jesu känentari kisere. Te kwanintari ietre angwane, niebare kwetre Jesuye: Ni kwati nibi ma känentari kisere, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesukwe niebare mda ietre: Ti jatani blitakäre kukwe kuin Ngöbökwebtä juta mda mdate arato, aisete mun ani juta mdabti nokore temen, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ye erere bkänä, Jesu nikani dikekä kä jökräbti temen kä Galileate angwane, namani blite kukwe kuin Ngöbökwebtä sinagogate kä ketareketare te. Arato üai käme nibtä abko namani juentari mento btä. ");
INSERT INTO gymNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kukwe namani bare kore angwane, ni iti bren lebra kisete, abtä ngütüete ngrabare jatani Jesu ngäbti angwane, namani ngukudokwäbti temen Jesu ngwärekri, käkwe niebare ie: Ma tö ti mikaita kuinta ne ngwane, makwe ti mikata kuinta, ie ti tö nibi, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Abtä ni ngütüete ye namani ruentari tare kri Jesuye, käkwe kise mikani ni yebti, bti niebare kwe ie: Ma rabata kuinta, ie ti tö nibi, aisete gwängwarbe ma bike nebeta kuinta, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ye btäräbe ni kwata ngütüete ngrabare lebra kisete ye kwata namaninta kuinta jökrä ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Bti Jesukwe niebare ie: Ma nibira kuinta jökrä, ye makwe ñan nie jire chi ni mda mdaye, akwa ma rika ja kwata kuinta mike tuadre ni blitaka Ngöböbe ni mda mda diäreye. Erere arato, ni bren kore tä nebeta kuinta abko käkwe jändrän mden mden biandre niebare Moisékwe, ye erere ma rika ngwena biandre Ngöböye, ma rabadre dbe niara ngwärekri abkokäre. Yebtä abko ma nenante kuinta abko rabadre gare ni jökräye, abkokäre ma rika jändrän ye ngwena. Abko kore se, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Akwa Jesukwe niara mikani kuinta, ye nikani kädriere ni jökrä ben. Yebtä abko, ni kwati tö namani ja tuai Jesube. Abtä Jesu ñan namani dikekä jäme juta ngwäre temen, aisete namani ja gwirie miketbe bäri kä kaibete juta bäre akwa, ni kwati krübäte namani nüke niara känti. ");
INSERT INTO gymNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Abti Jesu nükaninta gwi juta Capernaúm yete. Ye abko gani ni Capernaúmbokwe ");
INSERT INTO gymNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","angwane, ni nükani kwati gwi nükebe jukwebtä, aisete kä ñan namani kwen rabakäre Jesu känti gwi. Angwane Jesu nämane dirire Ngöbö Kukweibtä ni kwati yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Angwane ni jatani nibkä ni bren ngwena iti ja ñäte Jesuye. Ni bren ye abko ni ruen ñakare ngrabare abko kisete dikekä ñakare abko jatani ngwena ja ñäte Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Akwa ni nämane kwati dikaro aisete, ñan namani neme Jesu känti. Abtä nikanintre jubti käin, käkwe ju mkä tikaninkä, bti ni bren ye gibianinkä jänkwata ngöi ju mkäte ta timon kwetre Jesu ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nitre nükani ni bren ngwena amne ni bren ye nämane tödeke kwatibe Jesubti namani tuen Jesuye angwane, Jesukwe niebare ni bren yeye: Tikwe ma ngite Ngöbö rüere ye dininkä mento mabtä ti mräkä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yebtä abko, Kukwe Biani Ngöbökwe Moiséye dirikätre nämane siba, kä namani töbike krörö mda Jesu kukweibtä: ");
INSERT INTO gymNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Ngöbö aibe tä ni ngite niara rüere denkä mento nibtä amarebti, ¿se ñobtä abko ni se tä ñäke kore Ngöbö rüere sere? namanintre töbike kore Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Namanintre töbike kore, ye abko gani Jesukwe. Abtä niebare kwe ietre: ¿Ñobtä munta töbike kore tibtä yere? ");
INSERT INTO gymNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Dre abko bäri nuäre niedre ni ruen ñakare ngrabare nokoye? ¿Ma ngite Ngöbö rüere, ye tikwe dininkä mabtä abko bäri nuäre niedre ya? o ¿Näin krö, jänkwata makwe ye den kisete, bti nän dikekä abko bäri nuäre niedre ya? Ye abko, ma ngite Ngöbö rüere ye tikwe dininkä mabtä abko bäri nuäre niere, ñobtä ñan angwane raba bare ya, ñakare ya ñan jatadre munye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Akwa ti, Ni Kä Nebtä Ngobo ne ie Ngöbökwe ja di biani mun ngite Ngöbö rüere diankakäre mento munbtä kä nebtä, ye abko ti bike bä mike tuadre munye, niebare Jesukwe. Bti niebare kwe ni ruen ñakare ngrabare yeye: ");
INSERT INTO gymNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Näin krö. Jänkwata makwe ye den kisete amne nänta ja gwiriete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Angwane jötrö ngwarbe ni jökrä okwäbti, ni ruen ñakare ngrabare ye naninkrö krö, käkwe jänkwata diani kisete, bti nikaninta. Yebtä ni jökrä ñan töi namani krütare, aisete namani Ngöbö käikitekä, kä namani niere: Kukwe ne kwrere ñan tuabare erere nakaka mtare, namanintre niere kore jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Abti Jesu nikaninta Ñö Okwä Kri Galilea köräbäre mda angwane, ni nükani kwati niara känti angwane, niara namani dirire ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yebti nikani mentokwäre angwane, kä jändrän ütiä käräkrä gobran romanobokrä, känti ni nämane täkänintbe iti jändrän ütiä kärere. Ni ye abko Alfeo ngobo kädian nämane Leví abko nämane jite, btä Jesu okwä namani angwane, Jesukwe niebare Levíye: Brän tibe, niebare kwe ie. Angwane jötrö ngwarbe Leví nikani dikekä krö, nikani Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Abti Jesu nikani mröre Leví känti angwane, nitre jändrän ütiä käräkä gobran romanobokrä nämane kwati amne ni mda mda nämane tuen käme ni israelita ruäreye nämane arato, ñobtä ñan angwane ni kwati ye kwrere nämane näin Jesube. Nitre ye abko bäri käme nie namani nitre bariseokwe abko ben Jesu btä nitre ja töitikaka ben nämane täkänintbe mröre ketetibe. ");
INSERT INTO gymNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jesukwe mröbare kore nitre bariseo Kukwe Biani Ngöbökwe Moiséye dirikätre ruäre okwäbti, abtä niebare kwetre nitre ja töitikaka Jesubeye: ¿Nitre jändrän ütiä käräkä gobran romanobokrä abko käme amne ni mda mda kukwe nuenkä kämekäme se gare ñakare ni seye ya amarebti tä mröre jäme ketetibe ben se? niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nitre bariseo käkwe ñäkäbare kore, ye jarabare Jesuye angwane, Jesukwe ja bä mikani ni kräkä bianka kwrere amne nitre jändrän ütiä käräkä amne nitre kukwe nuenkä kämekäme, ben nämane mröre ye bä mikani ni bren kwrere, käkwe niebare krörö mda ietre: Ni kuin bren ñakare ye abko ñan tä ni kräkä bianka ribere jabtä, akwa ni bren bren abtä tä ni kräkä bianka ribere jabtä abko ti tö nibi niei munye. Ni ie ja ruen kuin deme au Ngöbö ngwärekri mun kwrere, ye abko ñan ti jatani kärere Ngöbö kukwäre, akwa ni kukwe kämekäme nuenkä Ngöbö rüere ye mden abko ti jatani kärere Ngöbö kukwäre. Abko kore se, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Abti bati nitre nänkä Juan Bautistabe btä nitre bariseo nämane ja bäine ja mikakäre metre Ngöbö ngwärekri angwane, ni mdara jire käkwe tuani, aisete jatani, käkwe niebare krörö Jesuye: ¿Ñobtä nitre nänkä Juanbe btä nitre bariseobe käta ja bäine Ngöbökrä amarebti, nitre ja töitikaka mabe ja bäine ñakare Ngöbökrä sere? niebare kore kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Abtä Jesukwe kukwe bä mikani ietre, käkwe ja bä mikani ni ja mikaka gure kwrere amne nitre ja töitikaka ben abko bä mikani kwe ni ja mikaka gure kukwe muko kwrere, käkwe niebare ietre: Ni iti tä niken ja mike gure angwane, tä kukwe muko kwekwe nübaire kä ngwiankäre nuäre gwaire jabtä, ye ngwane ni ja mikaka gure ye tädre siba bentre angwane, ¿kukwe muko ye raba moto ulire ja bäine ya? Ñakare. Ni ja mikaka gure ye tä siba bentre angwane, kukwe muko ñan raba nebe moto ulire ja bäine. ");
INSERT INTO gymNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Akwa ni ja mikaka gure ye järikadre kukwe muko okwäbti, ye ngwane rabadre ja bäine abko kore rakadikä nitre ja töitikaka tibe yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mdakäre abko, dän ngututu gudikadre dän kukwän btinbti angwane, dän kukwän btin tä dän ngututu kwaenkä bäri mda abko kisete dän ngututu rötadreteta angwane, rötadrete bäri kri mda, aisete ni ñan raba dän ngututu gudike dän kukwän btinbti. ");
INSERT INTO gymNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Erere arato, chibo kwata dikani kira uba döi ngwäre, te ni ñan raba uba döi keke mikadre kwaka, ñobtä ñan angwane chibo kwata ngututu rötadrete, rikadre ngwarbe uba döi kwaka ben ngöi jökrä arato. Mden kisete, uba döi mikadre kwaka abko kekadre chibo kwata btinte. Ne abko kore, niebare Jesukwe ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Abti bati Jesu nikani dikekä nura ngätäite köbö jadükakrä näire mda angwane, nitre ja töitikaka ben nämane näin siba, kä nikani trigo ngwä ötö ji ngrabare kwetadre jae. ");
INSERT INTO gymNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Abtä nitre bariseo käkwe niebare Jesuye: Jändrän ñan nuendre jire chi köbö jadükakrä näire nieta abko nitre ja töitikaka mabe nibi nuene tuen sete, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Abtä Jesukwe niebare mda käre: Bati David btä rükä kwekwe ie mrö namani krübäte angwane, kukwe nuenbare krörö kwetre: Ju nuäre ngwiandre känti ban deme nämane mikani Ngöbö ngwärekri, ye känti David nikani gwä, ban diani kwe, bti kwetani kwe rü muko kwekwe ben. Ban ye abko, David btä nitre nämane ben käkwe ñan kwetadre jire chi, ñobtä ñan angwane nitre blitaka Ngöböbe ni mda mda diäre aibe käkwe kwetadre niebare Ngöbökwe, akwa niaratre käkwe kwetani, akwa namani ngite ñakare Ngöböye. Abiatar nämane sribire nitre blitaka Ngöböbe ni mda mda diäre dänkien angwane kukwe ne nakaninkä. Kukwe yebtä mun tärä ñäke Ngöbö Kukweibtä ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ye erere, Ngöbökwe köbö jadükakrä mikani jadükakrä nie, ñan Ngöbökwe ni dätebare kukwe driebare munkwe köbö jadükakräbtä mikakrä täte. ");
INSERT INTO gymNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Amne köbö jadükakrä näire yebti ta abko ti Ni Kä Nebtä Ngobo abko bäri ütiäte, aisete nitre ja töitikaka tibe rabadre dre dre nuene köbö jadükakrä näire abko ti di tärä niere ietre. Abko kore se, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Abti köbö jadükakrä mdara jire te Jesu nikaninta sinagoga mdate angwane, ni iti küde ngrötani kwärä nämane yete. Arato nitre bariseo nämane yete. ");
INSERT INTO gymNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesukwe ni ye mikadreta kuinta köbö jadükakräte ne ngwane, Jesukwe ja mikani ngite Ngöbö rüere niedre kwetre Jesu rüere ni mda mdaye, abkokäre nitre bariseo namani ngibiaretari kisere ni küde ngrötani yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Angwane Jesukwe niebare ni küde ngrötani kwärä yeye: Jakwe ni jökrä ngwärekri nete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Erere bkänä, ni ye nikani angwane, Jesukwe niebare krörö mda nitre bariseoye: ¿Köbö jadükakrä, yebtä Kukwe Biani Ngöbökwe Moiséye käta dre niere? ¿Jändrän kuin nuendre ni mdakrä ya? ¿Kukwe käme nuendre ni mdabtä ya? ¿Ni bren mikadreta kuinta ya? ¿Ni bren kämikadre ja okwäbti ya? Dre nuendre metrere niere tie munkwe, niebare Jesukwe ietre. Akwa namanintre kwekbe jökrä niara kukweibtä, ñobtä ñan angwane ñan tö namani ja kitai ngise au. ");
INSERT INTO gymNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nitre bariseo moto ribi, aisete ni bren ñan namani ruentari tare ie. Abtä Jesu namani ulire krübäte, käkwe mikani ñäräre romone ja bäre temen, bti niebare kwe ni küde ngrötani yeye: Küde ngököte, niebare kwe ie. Ye btäräbe ni ye käkwe küde ngökatebare angwane, kise namaninta kuin jökrä ie. ");
INSERT INTO gymNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yebtä abko, nitre bariseo nikani ju bäre amne Jesu kämikadre ño ja ñäte nitre reketaka jrei Herodes ben abko nikani kädriere jötrö jabe kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Abti Jesu btä nitre ja töitikaka ben nikaninta Ñö Okwä Kri Galilea köräbti rabakäre kaibe, akwa ni nikani kwati jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jesu nämane jändrän kuinkuin nuene, abkotari ni Galileabo, ni Judeabo, ni juta Jerusalénbo, ni Idumeabo, ni nünanka Ñö Jordán bti kä driri, ni juta Tirobo bäre temen, btä juta Sidónbo bäre temen nükani kwati ja tuakäre Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ni nükani kwati dikaro abko nane rabadre Jesu kete dime ja ngätäite, aisete Jesukwe ru chi mikamna biare krati jakrä nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesukwe ni bren bren mikaninta kuinta kwati, abkotari ni mda mda bren rabadreta kuinta abkokäre tö namani kise mikai Jesubtä, aisete namanintre ja kitekäbe kwärikwäri rabakäre Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ye ngwane Jesu namani tuen üaitre kämeye angwane, ni btä nämane ye namanintre ngwen ja mike bobre ngukudokwäbti Jesu ngwärekri, kä namani ngrente krörö: ¡Ma Ngöbö Odei abko gare nunye! namani ngrente kore. ");
INSERT INTO gymNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesu Ngöbö Odei, ye abko Jesu ñan tö namani mikai gare jötrö ngwarbe ni jökräye, aisete Jesu käkwe ñan ja kädriemna ni mda mda ngwärekri üai kämeye. Ye ngwane Jesukwe ni kwati mikaninta kuinta btä üai käme juanintari mento ni kwatibtä kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Abti Jesu nikani mintokwäre nebe ngitiobti angwane, tö namani nire nire ngwiain jabe, erere käräbare kwe abko nikanintre ben mintokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ni ngwiani jabe Jesukwe, ne ngätäite ni dianinkä ni jätäbti nibu kwe abko rabadre ja töitike ben, bti juandre ja kukwei kädriere kwe, abkokäre dianinkä kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ni dianinkä ni jätäbti nibu Jesukwe abko ie ja di biani kwe üai käme juantarikrä mento nibtä ");
INSERT INTO gymNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","abko nere: Simón (ni ye Jesukwe kädiani Pedro mda), ");
INSERT INTO gymNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago btä etba kwe Juan. Ne abko Zebedeo ngäbriänkätre, ne arabe Jesukwe kädiani Boanerges. (Ne abko kukwe unsuni ngö käinta kwrere, aisete kädiani Unsuni Ngobo arato;) ");
INSERT INTO gymNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","btä Andrés, Felipe, Bartolomé, Mateo, Tomás, Santiago, Santiago ne abko Alfeo ngobo; btä Tadeo btä Simón Zelote. ");
INSERT INTO gymNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Mrä abko, Judas Iscariote. Judas ne mden käkwe Jesu kitani ngise rüeye mrä. Jesukwe ni dianinkä ni jätäbti nibu kore. ");
INSERT INTO gymNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nebti Jesu nikaninta gwä angwane, ni nükaninta kwati känti ja tuakäre ben abko ñan namani niara btä nitre ja töitikaka ben tuemetre mröre jire chi. ");
INSERT INTO gymNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesu mräkäkwe kukwe ne gani angwane, kä namani jäme Jesu dokwäbti namani nütüre, aisete nikani niara jiebti, tö namani Jesu ngwianta ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Angwane Kukwe Biani Ngöbökwe Moiséye dirikätre nünanka juta Jerusalén abko nükani ruäre Jesu känti, kä namani niere ni jökräye: Üai käme dänkien kädianta Beelzebú, ye mden käkwe ja di biani ni nokoye abko diebti tä üai kämekäme juentari mento se, namanintre niere kore Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Abtä Jesukwe dirikä ye käräbare, käkwe kukwe bä mikani krörö mda ietre: ¿Satana kädianta Beelzebú arato ye abko raba ja juentari au ya? Ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Erere arato, gobran btä ni nünanka kä ketetibe te rikwitare ja rüere kwärikwäri, ne ngwane gobran kä ye känti ñan rabadre gobrane mda. ");
INSERT INTO gymNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ne ben, ni jakwebe nüne ju kwatibe te rikwitare ja rüere angwane, ñan rabadre nüne ketetibe käre. ");
INSERT INTO gymNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ye mden kwrere abko, Satana rikwitareta ja rüere au ne ngwane, kä rükadre mrä käne, akwa Satana ñan tä rüre jabe au, aisete ti ñan tä üai käme juentari mento nibtä Satana diebti, aisete munta blite ngwarbe. ");
INSERT INTO gymNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yebti Jesukwe kukwe mda bä mikani, käkwe Satana bä mikani ni dite kwrere amne ja bä mikani ni gokä kwrere kwe, käkwe niebare: Satana abko ni dite kwrere. Ni dite tä ju jen kwe ngibiare ni gokä ngäniene, aisete ni dite nünanka gwi ñan mäkärete angwane, ni gokä ñan raba jire iti, kä rabadre jändrän kwe denkä kän, akwa mäkärete angwane, ni gokä rabadre jändrän kwe denkä jire jökrä kän. Ye kwrere ni ye btä üai käme tä abko ju Satanakwe kwrere. Ti bäri dite Satanakrä aisete, ti raba üai käme juentari mento nibtä Satanakän, ni gokäta jändrän denkä ni dite kän ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","Jesu abko btä üai käme nämane, nie namani Kukwe Biani Ngöbökwe Moiséye dirikäkwe, mdenbtä Jesukwe ñäkäbare krörö ietre: Ti bike kukwe era erere niere munye abko krörö: Nire nire käkwe ñäkädre blo Ngöbö rüere, btä ja mikadre ngite ño erere Ngöbö rüere kwe, yebtä Ngöbö raba ni ngite ye denkä mento btä; akwa nire nire käkwe ñäkädre blo Ngöbö Üai Deme rüere, ne ngwane ni ye rabadre ngite kärekäre Ngöböye, aisete ni ngite ye ñan diandrekä btä kwe. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kä namani jäme Jesu dokwäbti, Jesu mräkä namani nütüre, aisete Jesu meye amne etbakantre nükani ju bäre temen jiebti, käkwe kärämna ngwiandreta ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Angwane ni nämane täkänintbe Jesu bäre temen käkwe niebare ie: Ma meye amne ma etbakantre tä ju bäre nokote abko tö nibi blitai mabe, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesukwe niebare mda ietre: ¿Nire abko ti meye amne nire abko ti etbakantre amarebti tö nibi blitai tibe ye? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Bti ni nämane täkänintbe, ye Jesukwe mikani ñäräre kuin, käkwe niebare ietre: Ti meye tikwe amne ti etbakantre era metre abko erere tä nete ne, ");
INSERT INTO gymNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ñobtä ñan angwane nire nire käta Ngöbö kukwei mike täte, ni ye abko ti etba tikwe, ti ngwai tikwe amne ti meye tikwe. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Abti bati Jesu nikaninta dirire mda Ñö Okwä Kri Galilea köräbti angwane, ni kwati käkwe ja ükaninkrö Jesubtä niara kukwei nuakäre. Abtä Jesu nakwani rute, namani täkänintbe. Nitre käkwe ja ükaninkrö kwati btä ye abko namani jökrä ñö köräbti jateta temen. ");
INSERT INTO gymNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Angwane Jesukwe kukwe keta kabre bä mikani dirikäre ietre, käkwe niebare krörö: ");
INSERT INTO gymNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","¡Olo ketete munkwe! Bati ni nikani iti nura metekä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nura metaninkä kwe angwane nura ruäre nikani mate ji ngrabare temen, ye abko nukwä jatani, käkwe kwetani jökrä kän. ");
INSERT INTO gymNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nura ruäre abko nikani mate jäkwatabti temen, ye känti abko dobo ñakare bökän, aisete nura ye nükani mure jötrö, akwa dobo ñakare mente nguse, ");
INSERT INTO gymNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","bti ñänä jatani ngire, käkwe nura mu ye kukwani jökrä amne ngätri ñakare arato, aisete ngrötaninkä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nura ruäre abko nikani mate kökrä tukwäte tukwäte ngätäite, ye abko nükani mure arato. Akwa kökrä ye abko rirabare bäri jötrö nura mu yebti ta, käkwe kämikani, aisete ñan ngwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Akwa nura ruäre abko nikani mate dobo kuinte, ye abko nükani mure amne, rirabare tuärebe amne ngwä namani kabrekabre btä. Datire datire ngwä namani gre bti krä jätä, ruäre abko ngwä namani gre ketamä, ruäre abko ngwä namani gre ketarike. Ne abko nakaninkä kore se. ");
INSERT INTO gymNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nire nire käta ti kukwei nuen, ye abko olo tärä ne ngwane, ti kukwei ne ketate ja olote kwe, kukwe ne rükadre gare kuin munye abkokäre. Abko kore se, niebare kwe ni kwati yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Yebti Jesu namani kaibe angwane, ni ja töitikaka ni jätäbti nibu ben btä ni mda mda nämane näin siba Jesube käkwe niebare ie: ¿Makwe kukwe bä miri, ye dre nini kore makwe yere? niebare kore kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesukwe niebare mda ietre: Ngöbö rükadre gobrane ño nibti abko tä tiebe, akwa tita mike gare munye, akwa ni kwati mda abko ie Ngöböta mike gare ñakare, aisete tita kukwe bä mike kore, Ngöbö Kukwei tä tikani krörö rabadre bare abkokäre: ");
INSERT INTO gymNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kukwe bä mikata kore tikwe, ye jatadre ni mda mdaye, akwa ñan rükadre gare. Ne ben, kukwe nieta tikwe jaradre ie, akwa tebaidre ñakare kwetre. Yebtä ñan jatadreta Ngöbö kukwäre. Arato niaratre ngite Ngöbö rüere, ye Ngöbökwe ñan diandrekä mento btä, abkokäre tita kukwe bä mike kore, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesukwe kukwe bä mikani, ye ñan nükani gare metre nitre ja töitikaka benye. Abtä niebare kwe ietre: ¿Tikwe kukwe bä miri nura metaninkäbtä ñan nü gare munye, ye kukwe mda mda bäri tare bä mikadre tikwe abko rükadre gare ño munye amarebti yere? ");
INSERT INTO gymNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ye mden kisete, kukwe bä miri tikwe käta ño niere metre abko ti bike mike gare munye. Ni Ngöbö kukwei ngwianka, ye abko ni nura metakaka kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nura nikani ngitiekä ji ngrabare, ye nukwä jatani, käkwe kwetani jökrä. Ye kwrere abko, ni ruäreta Ngöbö Kukwei nuen, akwa ñan tä nüke gare metre ie. Btäräbe Satana tä kite, käta Ngöbö Kukwei denkä jökrä kän, mden nini tikwe ye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amne ni ruäre abko käta Ngöbö Kukwei nuen, ye btäräbe käta nebe nuäre btä kare ngäbti, ni ye abko nura nikani mate jäkwatabti ye kwrere, ");
INSERT INTO gymNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ñobtä ñan angwane nura nikani mate jäkwatabti abko ngätri ñan nämane bökän, ye kwrere jire ni ruäre tä Ngöbö Kukwei kaen ngäbti, bti bä jötrö tä näin Ngöböbe, akwa tädre niken ja tare nike tödekabtä Ngöböbti, ye btäräbe tä Ngöbö Kukwei kiteta temen, bti tä nikenta ja jiebti. ");
INSERT INTO gymNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Amne ni ruäre abko tä Ngöbö Kukwei nuen, akwa tä nakwen bäri jändrän kä nebtä jiebti, erere tä ja töi mike bäri sribi kä nebtä jiebti amne, tä ngwian tarere bäri amne töta nebe rabai jändrän mda mda bkäne, ye abko käta ngökö. Ne aisete ni ye abko nura nikani mate kökrä tukwäte tukwäte ngätäite amne ngatani, ye tä nakenkä ni yebtä, aisete nura ngatani, ngwä namani ñakare, ye kwrere jire ni ye tä sribi nuene ñakare Ngöbökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Akwa ni ruäre tä Ngöbö Kukwei nuen amne tä kaen ngäbti, käta niken sribi kuinkuin nuene bätäkä ngwarbe Ngöbökrä, ye abko nura nikani mate dobo kuinte abko rirabare kuin amne ngwä kuinkuin namani gre bti krä jätä, ruäre gre ketamä, ruäre abko gre ketarike, kwrere jire ni ye tä sribi nuene Ngöbökrä abko kukwe kore bä miri tikwe ye, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesukwe kukwe bä mikani krörö mda ni kwati yeye, käkwe niebare: ¿Ñotra jutra mikata gwi, ye jue mikata kaja täni ya? Ñakare. ¿Mikata jän täni jae ya? Ñakare. Ñotra mikata, ye mikata üräbtä käin trä rabadre ngitie jökrä gwita temen, ni jökrä gwi, ie kä rabadre tuen abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ye kwrere abko, Ngöbö Kukwei ñotra kwrere, aisete Ngöbö Kukwei nieta kaibe tikwe mtare abko batira jire kädriedi ji kribti ni mda mdabe. Erere arato, Ngöbö Kukweita tiebe mtare abko batira jire niedi ni kwati ngwärekri, ñotra mikata üräbtä käin trä rabadre jökrä gwita temen ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ni kukwei ruen munye angwane, munkwe kukwe ne ketate olote. Abko kore se, niebare Jesukwe ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Bti Jesukwe kukwe bä mikani mda, käkwe niebare: Olo ketete kuin kukwe neye munkwe. Ti kukwei mikare täte ño munkwe, ye kwrere Ngöbökwe ti kukwei mikadi gare mda munye. Arato niarakwe ti kukwei mikadi gare bäri mda munye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mdakäre abko, nire nire ie Ngöbö Kukwei nüke gare, ye abko ie Ngöbökwe ja Kukwei biandi bäri mda; akwa nire nire ie Ngöbö Kukwei gare ñakare, ye abko ie Ngöbö Kukwei gare kiakia abko Ngöbökwe diandikä jökrä kän, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesukwe kukwe mdara jire niebare krörö ni kwati yeye ñö okwä kri köräbti: Ngöbö gobrainta kite niren ño ni kwe ngätäite abko ti bike bä mike nura metakata btä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ni nura metakaka käta nura metekä, bti tä nikenta gwä. Bti dibire rare tä kibien ya, tä ngwäte ya ño, akwa nura abko tä nüke mure, bti tä niren ño gare ñakare ie. ");
INSERT INTO gymNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Akwa nurata nüke mure ja di jenbti, ye erere batibe nura muta nüke chi, bti tä niken niren, bti tä nebe blüre, bti ngwäta nebe btä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yebti ngwäta neme nötare jökrä angwane, kä nura ötakrä tä nüke. Angwane nura bkänkä tä ötamna sribikätre kweye, ye erere ötata niken. Ye abko, nurata nüke mure, bti ngwäta neme nötare kaibe amne ötata ño, ye kwrere Ngöbö gobrain tä kite niren ni kwe ngätäite. Ne abko kore, niebare Jesukwe ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mdakäre abko, ¿Ngöböta kite gobrane nibti ye abko tikwe bä mikadre dre kwrere ruen munye? ");
INSERT INTO gymNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ngöböta kite gobrane nibti ye abko mostasa nurai chi kwrere. Ni iti käkwe mostasa nurai nökani tirete jakrä. Nura jökrä munkwe, ngätäite mostasa nurai ye abko bäri kiakia, ");
INSERT INTO gymNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","akwa nökadre tirete angwane, rabadre bäri kri nura jökrä bti ta angwane, küdeta nebe ngetre kwäräkwärä, aisete nukwä raba kite nüne küdete käinta kä tiborete, ye kwrere jire käne Ngöböta kite gobrane ni braibe bti, akwa mrä angwane Ngöbö rabadi gobrane ni kwatibti abko bä mikata nura chi yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu nämane kukwe bä mike jändrän mda mdabtä, erere nämane dirire, akwa kukwe bäri tare abko ñan nämane dirire ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Kukwe bä mika nämane jirekäbe Jesukwe, btä nämane dirire ni mda mdaye, akwa nämane nebe kaibe nitre ja töitikaka benbe angwane, kukwe bä mika nämane ni mda mdaye kwe abko nämane dre niere metre abko nämane mike gare jökrä ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jesukwe blitabare kukwe keta kabrebtä, ye näirerabe kä jatani iko angwane, niebare kwe nitre ja töitikaka benye: Brän ñö okwä kri kwäräkri, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Erere bkänä, ru te Jesu nämanena, arabe te jänikani. Arato ru mda mda nikani siba ben. Ni nämane kwati, ye abko namani jökrä ñö okwä köräbti ie. ");
INSERT INTO gymNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Niaratre nikani, nikani te batibe müre jatani mate ribi krübäte, kä nikani ñö mike nakwen kukwäne, aisete namani ñö kite nakwen jökrä rute, kä namani ru krien ñöte nguse. ");
INSERT INTO gymNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Akwa Jesukwe ja dokwäkrä mikani, bti nämane kibien kuin ru körekri. Ye nitre ja töitikaka ben nikani, käkwe ganinkrö, bti niebare kwetre Jesuye: ¡Dirikä, ni kite niken ñöte nguse dbe makrä ya, amarebti ma nibi kibien dikaro yere! niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Abtä Jesu naninkrö, käkwe ñäkäbare krörö müreye amne ñöye: Kwekbe munkwe, niebare kwe. Ye btäräbe kä namaninta kwekbe jökrä. Ñö abko namani nenta jirekäbe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesukwe niebare nitre ja töitikaka benye: ¡Ngöböta mun ngibiare, bti munta tödeke yera, amarebti mun moto nibi bete dikaro ja tari yere! niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Akwa namanintre nekwetekä Jesubtä, töi ñan namani krütare, kä namani niere jae kwärikwäri: ¿Ni se abko, ni ño amarebti, müreta mike täte btä ñöta mike täte sere? namanintre niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yebti Jesu nikani nitre ja töitikaka benbe nebe Ñö Okwä Kri Galilea kwärä nakri käkä Gadara känti. ");
INSERT INTO gymNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Niara nakwani timon, ye btäräbe ni nükani iti Jesu känti abko btä üai käme nämane. Mden kisete nämane nüne rökabti abko nikani Jesu ngäbti. Ni ye abko, ni krübäte üai käme kisete, aisete mäkäte nämane kadenanbti, akwa ñan nämane neketete jire chi ni mda mdaye, ");
INSERT INTO gymNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ñobtä ñan angwane küde mäkäte nämane kadenanbti ie angwane, nämane kadena ötöte jökrä ja küdebtä. Ne ben ngoto mäkäte nämane ie angwane, nämane kadena ötöte kia bürere jökrä ja ngotobtä, aisete ñan namani nuene ni mda mdakrä. Käre mäkäte nämane, akwa nämane ngitieta ben gwaire. ");
INSERT INTO gymNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dibire rare ni ye nämane niken ngwänenkä krikri be rökabtita btä ngudrebtita ja metare kwärä jäbti ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesu jatabare mente ie se kwrere angwane, niara nakwaninkä, nikani betekä Jesu ngäbti, namani känti angwane, nikani ngitiekä ngukudokwäbti temen Jesu ngwärekri ja mikakäre bobre Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesukwe niebare üai kämeye mda: Nän mento ni nebtä, niebare kwe. Abtä ni yekwe ngratebare kri mda, käkwe niebare: Jesu, ma Ngöbö Kri Kä Käinbti Odei, ¿ye ñobtä ma kite ti nike nete ye? Ngöbö se okwäbti, makwe ñan ti mika ja tare nike abko ti tö nibi ribei mae, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Abtä Jesukwe niebare mda üai kämeye: ¿Ma kä ño? Üai käme ye käkwe niebare mda Jesuye: Nun kabre jae, aisete ti kä Kabre, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Bti namani ribere kisere mda Jesuye: Makwe ñan nun juantari mento kä mdabti, üaitre käme namani ribere kisere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ye känti abko, mtü nämane kabre krübäte mröre bä känime ngudrebtäta, ");
INSERT INTO gymNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","aisete namani ribere Jesuye: Mtüta sere, sebtä nun juen, namani niere ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ye erere, Jesukwe üai käme juanintari mento ni yebtä abko juani mda kwe mtübtä. Üai käme nikani mento ni yebtä, bti nikani mda mtübtä angwane, mtü nikani betekä jökrä ja jiebti kä btä motokwäre, nikani ngitiekä jökrä ñöte, känti müre neketani jökrä. Mtü mili krobu näre müre neketani jökrä kore. ");
INSERT INTO gymNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yebtä abko, mtü ngibiakatre ngitiani, nikani kukwe ne niere jutate ta btä ji ngrabare. Abtä ni jatani kwati mda kukwe nakaninkä ye tuakäre. ");
INSERT INTO gymNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nükanintre Jesu känti angwane, ni btä üai käme nämane kabre abko ja ngwä kitani kwe, nämane täkänintbe temen, kä ruen kuin bti, btä nükanintre. Abtä Jesu di kri nükani gare ietre, aisete Jesu jürä namani ni jökräbtä. ");
INSERT INTO gymNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ni btä üai käme nämane kabre btä kukwe nakaninkä, erere arato kukwe nakaninkä ño ño mtübtä abko nitre tuakatuaka namani taentari jire jökrä ja täritäri ni jökrä yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yebtä abko, Jesu jürä namani kri btä, aisete Jesukwe kä mikarekä, rikadre kä mdabti abko ni jökrä namani ribere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ye erere bkänä, Jesu nakwaninta rute angwane, ni btä üai käme juanintari mento kwe, ye abko Jesu rikadre ngwena jabe abko namani ribere Jesuye, ");
INSERT INTO gymNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Akwa Jesukwe niebare mda ie: Ñakare. Ma raba jirekäbe nete. Ma Dänkienkwe dre nuni makrä btä ma tareniri ño kwe, ye nän niereta jire jökrä ma mräkäye ja gwiriete, niebare kore Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ye erere bkänä, Jesukwe kukwe kuin nuenbare ni yekrä, ye niara nikani niere ni jökräye juta kwatirekwatire te kä kädian nämane Decápolite. Yebtä ni jökrä töi ñan namani krütare kukwebtä abko nakaninkä kore se. ");
INSERT INTO gymNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yebti Jesu jataninta rute nüketa Ñö Okwä Kri Galilea kwärä nakri. Jesu nämane ñö okwä köräbäre angwane, ni nükaninbe ja ükekrö kwati ja tuakäre ben. ");
INSERT INTO gymNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Angwane ni nükani iti abko kädian nämane Jairo. Jairo abko nämane ji dokwäte sinagogate. Jesu jatabare ie angwane, nikaninbe ja mike bobre ngukudokwäbti Jesu ngotobtä, ");
INSERT INTO gymNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","kä namani ribere kisere Jesuye: Ngäbäkre chi merire tikwe kite krüte tikän abko rabadreta kuinta tikrä, abkokäre ti ki ma kärere kise mike bti jakrä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ye erere Jesu nikaninbe ben angwane, ni kwati nikani siba, kä namani kete dime ja ngätäite. ");
INSERT INTO gymNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Angwane nitre nikani kwati Jesube, ye ngätäite meri nämane näin iti siba abko kä kwä jätäbti kubura nämane bren dbä tibiere köbö kwatirekwatire ");
INSERT INTO gymNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","abko kisete nämane ja tare nike. Käre nikani kräkä bianka kwati känti angwane, kräkä bian nämane ie, akwa nämane kitetebe bäri mda. Ngwian nämane kwe, erere ganinte jökrä kwe kräkäbtä jakän, akwa nikani bäri bren jume mentokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Akwa Jesu nämane ni miketa kuinta kädrie namani meri ye okwäbti. Abtä nikani siba, namani ja ken Jesube angwane, namani nütüre: Tikwe dän Jesubtä se aibe nuadrebtä angwane, ti rabadreta kuinta, namani nütüre. Ne erere ni kwati ngätäite ta, krötabare ja ken Jesu trökri kwe, bti dän Jesubtä nuaninbtä tiebe kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ye btäräbe namaninta kuinta batibe se kwrere, aisete ja namani ruenta kuin jökrä ngrabare ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesu die näkänintbe ruäre abko Jesukwe gani angwane, ni nämane kwati bäre temen mikani ñäräre kwe, bti niebare kwe ietre: ¿Nirekwe dänkä nuribtä tibtä ye? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abtä nitre ja töitikaka ben käkwe niebare mda ie: ¿Ni nibi kwati ma bäre temen, kä nibi ma kete dime ja ngätäite ñan tuen mae ya, amarebti nirekwe dän mabtä nuribtä ma nibi niere yere? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Akwa nirekwe dän nuaninbtä Jesubtä abko Jesu tö namani gai aisete, kä namani mike ñäräre janknu ja bäre temen. ");
INSERT INTO gymNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jesu namani nikren dikaro, abtä meri ye moto namani bete, aisete namani grükekä jökrä ngrabare, nikani ja mike bobre ngukudokwäbti Jesu ngwärekri, bti jakwe dän nuaninbtä Jesubtä, käkwe ja mikaninta kuinta, niebare metre kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Abtä Jesukwe niebare mda ie: Ti mräkä, makwe tödiri kwatibe tibti, köböire ma nibirate kuinta, aisete nänta jäme, niebare kore kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu nämane blite kore angwane, ni ji dokwäte sinagogate, ye jiebti ni ruäre mda nükani kukwe ngwena, käkwe niebare ie: Ma ngänkän kürera makän. Makwe ñan dirikä nika mda, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ne jarabare Jesuye, abtä Jesukwe niebare ni ji dokwäte yeye: Ma ñan rekwetaka ngäbäkre jiebti jakän. Makwe tödeka kwatibe janknu tibti, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Bti Jesu nikani, käkwe Pedro, Santiago, btä Juan, Santiago etba aibe ngwiani jabe, ben nikani. ");
INSERT INTO gymNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Namanintre ni ji dokwäte juete angwane, ni nämane kwati ngetrekä jume ja dibti, aisete kä nämane nokre gwi, btä namanintre. ");
INSERT INTO gymNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Niara nikani gwä angwane, ngäbäkre krütanina namani gare Jesuye, akwa niebare kwe nitre ngetrakaka ie: Ngäbäkre merire ye kürera munta nütüre, akwa tä kibien. ¿Ñobtä mun ngetrakwe nibi nokre kore gwi yere? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yebtä ni jökrä namani Jesu kötaire ñäkäbtä kore, akwa Jesukwe ni nämane gwi ye juani jökrä ju bäre, bti ngäbäkre meye, rün btä ni ja töitikaka nimä nämane näin Jesube aibe ben nikani nebe ngäbäkre ngwäkä ye känti. ");
INSERT INTO gymNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Namanintre känti angwane, Jesukwe ngäbäkre merire ngwäkä kani küdebti, bti ñäkäbare arameo kwe ie krörö: Talita, kumi, niebare kwe ie. (Ne abko nieta: Ngäbäkre merire chi, näin krö, tita niere mae.) ");
INSERT INTO gymNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ne btäräbe, ngäbäkre merire ye nükani krö, nikaninbe dikekäta. Yebtä nitre nämane kwati, ye töi ñan namani krütare jire chi kukwe nakaninkä yebtä. Ngäbäkre merire ye abko kä kwä jätäbti kubu ie. ");
INSERT INTO gymNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesukwe ngäbäkre mikaninta nire, bti bukamna kwe. Akwa nitre kukwe tuakatuaka abko käkwe ñan kukwe ye kädriedre jire chi ni mda mdabe, niebare kwe ietre. Ne abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yebti Jesu nikaninta ja käite juta Nazarete nitre ja töitikaka benbe. ");
INSERT INTO gymNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Abti köbö jadükakrä nükani angwane, nikani dirire sinagogate. Angwane ni kwati nämane kukwe nuen. Ruäre abko ñan töi nämane krütare Jesu kukweibtä, kä namanintre niere jae kwärikwäri: ¿Ni nokokwe ja töitikani mdente amarebti töbtä dikaro sere? Arato, töi ngitiekä dikaro dirikrä, btä tä sribi kri ñan tuabare nuene Ngöbö diebti. ¿Se abko ño känti gare ie amarebti sere? ¿Niarata bike kri ñan ñan? ");
INSERT INTO gymNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Niara María ngobo sribikä kri kukwänbtä ara. Niara abko Santiago, José, Judas btä Simón etba ara. Niara ngwai tä nüne jökrä kä ne känti arato, namanintre niere jirekäbe jae kwärikwäri. Ne aisete Jesu kukwei namani tare btä. ");
INSERT INTO gymNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Abtä Jesukwe niebare mda ietre: Ni Ngöbö kukwei niekä mikata ütiäte kä mda mdabti, akwa ja käite amne mräkä kwekwe ngätäite amne mräkä juete abko mikata ütiäte ñakare nieta. Ye kwrere mun ñan tä ti mike ütiäte jae. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","6","Nitre Nazarebo käkwe ñan Jesu kukwei mikani ütiäte abko namani tebaidre kri Jesukrä. Abtä ni bren bren nämane ruäre, aibebti Jesukwe kise mikani abko namaninta kuinta, akwa sribi kri nuenbare ñakare mda kwe kä ye känti. Yebti Jesu nikani dirire janknu juta kwatirekwatire Galileate angwane, ");
INSERT INTO gymNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ni ja töitikaka ben ni jätäbti nibu käräbare kwe, ie Ngöbö di biani kwe üai käme juantarikrä, bti juani nibu nibu kwe Ngöbö Kukwei dirire. ");
INSERT INTO gymNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Akwa rikadre känenkri abko töi diani krörö kwe: Mun rikadre angwane, mun ñan rika mrö ngwena, mun ñan rika kra ngwena, mun ñan rika ngwian ngwena, akwa mökän aibe järika munkwe jae amne sandalia mun ngotobtä aibe te mun rika. Arato, dän jabtäbe, te mun rika, ñobtä ñan angwane munkwe nünentbe nirebe abko käkwe mun die mikadre jändrän jökrä yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ne mden kisete, juta mdente mun rika, ye känti munkwe nünantbe ju kwatibe te, bti mun rika ta juta mdate. ");
INSERT INTO gymNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Akwa nane juta mden känti mun ñan ka ngäbti, btä mun ñan kukwe nua tö raba angwane, munkwe dobro ja ngotobtä ye bäbrükate nitre nünanka juta yete okwäbti, niaratre ngite au Ngöbö ngwärekri bä mikakrä tuare ietre. Yebtä abko, kukwe era erere ti bike niere munye. Ngöbökwe ni jökrä mikadi ja tare nike, ye ngwane nitre Sodomabo btä Gomorrabo abko Ngöbökwe ngwiandi ja tare nike krübäte bkänä, akwa ni kä ye känti tä mun kukwei nuen ñakare abko Ngöbökwe ngwiandi ja tare nike bäri krübäte mda. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ye erere bkänä, nitre ja töitikaka Jesube nikani, kä namani niere krörö: Kukwe kämekäme kite temen munkwe, bti tödeke Ngöböbti munkwe, namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ye ngwane, üai käme juanintari mento ni kwatibtä kwetre. Arato ni bren bren mikaninta kuinta kwetre aseite kekare kwärä ni bren bren yebti. ");
INSERT INTO gymNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kä ye ngwane abko, jrei kädian nämane Herodes Antipas nämane gobrane angwane, Jesu nämane dre dre nuene gani kwe, ñobtä ñan angwane ni jökrä nämane Jesu käikitekä kä ketareketare Galileate. Yebtä ni ruäre namanintre niere krörö Jesubtä: Ngöbökwe Juan Bautista mikaninta nire, aisete di tärä sribi kri ñan tuabare nuenkrä ye, namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ni mda mda abko namani niere: Ni Ngöbö kukwei niekä kira kädian nämane Elías ara se, namanintre niere. Ni mdara jire abko namani niere: Nitre Ngöbö kukwei niekä kirakira abko kwrere sere, namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Blita namani Jesubtä, ye namani gare Herodeye angwane, niebare kwe: Juan dokwä tikakamna tikwe, ara nükaninta nire mtare, niebare Herodekwe. ");
INSERT INTO gymNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ñobtä jrei Herodes käkwe Juan dokwä tikakamna abko nakaninkä krörö: Herodes käkwe niebare kore, ñobtä ñan angwane niara etba Felipe nän muko kädian nämane Herodías abko diani kwe kän. Yebtä abko Juan Bautista käkwe niebare Herodeye: Ma etba nän muko se makwe ñan mikadre jire ja ken kän, Juan nämane niere. Ye dokwäre abko Juan Bautista kamna ngite Herodekwe, bti kitamna ngite kä teri kwe, ye nükaninta töre ie, käkwe ñäkäbare kore. Ye mdenbtä Herodías abko tö namani Juan müre ketai, akwa ñan namani nuene kräke, ");
INSERT INTO gymNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ñobtä ñan angwane Juan abko ni era metre nünanka deme Ngöbö ngwärekri nämane gare Herodeye, abtä nämane mike ütiäte, aisete jrei Herodes nämane Juan ngibiare Herodías ngäniene. Arato kä nämane nebe nuäre Herodebtä Juan kukwei nuare, akwa nämane nebe töbike kri btä. ");
INSERT INTO gymNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Te bati, Herodes därebare köböi nükani angwane, Herodekwe sribikä bäri ütiäte krikri käräbare, btä nitre rükä rükä dänkien käräbare kwe. Arato ni ütiäte krikri Galileate käräbare kwe mröre jae. Ye ngwane köbö kuin nükani Herodíakrä. ");
INSERT INTO gymNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Herodías ngänkän bati nikani tärä mike kwäräkwärä se kwrere nitre nübaibare Herodekwe ye okwäbti. Herodías ngänkän namani tärä mike nuäre kwäräkwärä, ye abko käi namani nuäre krübäte Herodebtä amne ni mda mda nämane mröre ben yebtä. Abtä Herodekwe niebare Herodías ngänkänye: Ngöbö se okwäbti, ma tö dre dre ie, erere kärere jökrä tie angwane, tikwe biandi mae. Kä te tita gobrane, ye ma tö käräi ruäre ta tie angwane, tikwe biandi mae. Dre erere ma tö käräi tie, tikwe biandi mae. Ne tita niere mae Ngöbö se okwäbti, niebare kwe bäre bäre ngäbäkre merire yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Dre kärädre kwe abko ñan nükani gare ie. Abtä nikani, käkwe niebare meyeye: ¿Tikwe dre kärä ruen? niebare kwe meyeye. Meyekwe niebare mda ie: Juan Bautista dokwä kärere ie, niebare mda kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ye erere bkänä, Herodías ngänkän nikaninbe mda. Namaninta jrei Herodes känti, käkwe niebare ie: Gwängwarbe, makwe Juan Bautista dokwä mika blatote. Makwe bian tie nete, ie ti tö nibi, niebare kwe Herodeye. ");
INSERT INTO gymNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Yebtä abko, Herodes moto namani ulire mda, akwa nitre nübaibare kwe ye okwäbti ja kukwei biani kwe Herodías ngänkänye, aisete ñan tö namani ja kukwei kitaita temen. ");
INSERT INTO gymNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Yebtä jrei Herodes käkwe, ni rükä juani iti abko käkwe Juan dokwä tikarekä, bti jatadre ngwena niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ye erere Juan nämane ngite, ye känti ni rükä nikani, käkwe Juan dokwä tikaninkä, bti mikani blatote kwe, jänikani, biani kwe Herodías ngänkän bati yeye angwane, niara käkwe bianinbe meye Herodíaye mda. ");
INSERT INTO gymNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan müre ketani, ye nitre ja töitikaka ben käkwe gani angwane, Juan ngwäkä jänikani kwetre, bti doboi mikani kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jesukwe nitre ja töitikaka ben töi diani, bti juani kwe kä ketareketare Galileate. Abti nükaninta jökrä känti angwane, dre dre nuenbare kwetre btä diribare ño ño kwetre, ye kädriebare jire jökrä kwetre Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ye ngwane, ni kwati nämane nüke basare ietre, namani nikenta, täte ni mda namani nüke, namani nikenta aibe janknu, aisete kä ñan namani mrökrä ietre. Abtä Jesukwe niebare nitre ja töitikaka benye: Brän jadüke chi kä kaibete, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ye erere bkänä, nakwani jökrä rute, bti nikanintre kä kaibete. ");
INSERT INTO gymNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Nikanintre angwane, Jesu ara namani rute nükani gare ni kwatiye, aisete nikanintre betekä jiebti. Erere arato, ni kwati nünanka juta mda mdate käkwe gani abko nikanintre betekä Jesu ngäbti, namanina käne kä kaibete ngibiare, btä nikanintre ngitiekä. ");
INSERT INTO gymNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesu nikani mate, nakwani timon angwane, ni nämane kwati ngibiare ngäbti. Nitre ye abko namani tuen bäsi obeja ngibiaka ñakare raba ngwarbe ye kwrere, namani tuen Jesuye, aisete namani tuen bobre ie. Abtä nikani kukwe dirire kabre bätäkä ngwarbe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bti kä jatani dere nitre ja töitikaka Jesube okwäbti angwane, nikanintre, käkwe niebare krörö Jesuye: Kä kitera dere. Nita kä kaibete nete, ");
INSERT INTO gymNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","aisete nitre se juen mrö kökö jae. Känime nere ya, jutate ya, mdente erere juen mrö kökö jae, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesukwe niebare mda ietre: Niaratre buke munkwe, niebare kwe ietre. Niaratre käkwe niebare mda: ¿Ni iti käkwe ngwian ganandre sö krä kwä jire abko näre bti, nun rikadre ban kökö nitre kwati se bukakrä jökrä bäre sera? niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesukwe niebare ietre: ¿Ban tä kunbe munkwe? Ye mun nän tuen, niebare kwe ietre. Erere jananbare tuen, bti jatanintre nüketa, käkwe niebare: Banta kunrike btä gwa krobu, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesukwe nitre juani täke ketareketare temen ja täritäri mikä rerebarebti. ");
INSERT INTO gymNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Erere nitre namani täkänintbe gre ketarike ja täritäri, ruäre abko namani täkänintbe gre ketebu bti ni jätä ja täritäri. ");
INSERT INTO gymNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Bti Jesukwe ban kunrike btä gwa krobu diani kisete, nikrabare kä käinbti kwe, bti kuin niebare btä Ngöböye kwe, bti ban ñäkänintbe kwe, biani kwe nitre ja töitikaka benye ni jökrä bukakrä. Erere gwa krobu te ni jökrä bukani arato. ");
INSERT INTO gymNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ni kwati käkwe mröbare, namanintre trinetrine jökrä, ");
INSERT INTO gymNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","bti ban oto btä gwa oto namaninte abko ükaninkröta kutia kwä jätäbti kubu jire mda. ");
INSERT INTO gymNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ni kwati käkwe mröbare, ye abko ni brare brare aibe mili krärike. Meri btä ngäbäkre nämane kwati abko tanbare ñakare. ");
INSERT INTO gymNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nebti ni nämane kwati, ye Jesu jämi juenta ja gwiriete kwäräkwärä, känenkri nitre ja töitikaka ben juani rute kwe, bti juani Ñö Okwä Kri Galilea kwärä nakri ja ngibiare juta Betsaidate. ");
INSERT INTO gymNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jesukwe ni kwati ye juaninta jökrä ja gwiriete, bti niara nikani mintokwäre mda blitakäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kä jatani iko angwane, nitre ja töitikaka Jesube namani ru ngwena Ñö Okwä Kri Galilea te ruäre. Jesu abko namani kaibe, nämane jate abko okwäbti ");
INSERT INTO gymNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","müre namani mate ribi krübäte nitre ja töitikaka ben ngäbti, aisete namani ñö sökö tare rubtä, namani tuen Jesuye. Kä jatanina ngwen ja ken dekä angwane, batibe Jesu nikani dikekä ñöbti kukwäre. Jatanina nüke ru ken, tö namani näin ru bäre ta, akwa jatabare nitre ja töitikaka benye angwane, ");
INSERT INTO gymNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ni bäkäi nämane dikekä ñöbti, namanintre nütüre, aisete nekwetaninkätre, käkwe ngratebare, ñobtä ñan angwane ");
INSERT INTO gymNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jesu jatabare ietre angwane, nekwetaninkä jökrä. Abtä Jesu käkwe niebare ietre: Ti ara tä näin. Mun ñan rekwetaka, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bti Jesu nikani rute käin, btäräbe müre nötaninkäbe. Abtä nitre ja töitikaka Jesube ñan töi namani krütare, ");
INSERT INTO gymNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ñobtä ñan angwane ñan namani Jesu kukwei kaen ngäbti metre, aisete Jesukwe ban ñäkänintbe Ngöbö diebti angwane, niara ñakare niaratre kwrere abko ñan nükani gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yebti niaratre nükani Ñö Okwä Kri Galilea kwärä nakri juta Genesarete, känti ru mäkäninte kwetre ñö köräbtä, ");
INSERT INTO gymNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","bti nakwanintre timon. Btäräbe nitre nünanka yete, ie Jesu nükani gare, ");
INSERT INTO gymNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","aisete jötrö ngwarbe nikanintre betekä juta ngwäre. Jesu namani niken mdente mdente, ye nükani gare ni bren bren mräkäye angwane, namanintre ni bren bren ye tike jänbti jänbti Jesu kukwäre. ");
INSERT INTO gymNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesu namani niken juta kiakiate, namani niken juta krikrite, namani niken kä kiakiate, mdente erere ni bren bren mika namani jite jite mräkäkwe Jesu ngäbti. Angwane nitre bren bren ye abko Jesukwe tuadremetre dän körä aibe nuenbtä jabtä amne rabadreta kuinta abko mräkä namani ribere Jesuye. Ye erere bkänä, nitre bren bren namani dän körä aibe nuenbtä Jesubtä angwane, namani nebeta kuinta batibe jökrä abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Abti bati nitre bariseo btä Kukwe Biani Ngöbökwe Moiséye dirikätre nämane Jerusalén, nükani Jesu känti Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ye ngwane, Kukwe Biani Ngöbökwe Moiséye dirikätre kirakira käkwe köbötikamna bti mrömna kwetre nitre israelitaye, ye kwrere nitre ja töitikaka Jesube nikani mröre abko ruäre käkwe ñan köbötikani nitre bariseo okwäbti. Abtä namani ñäke btä. ");
INSERT INTO gymNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Nitre israelita ngämi mröre abko känenkri köbötikadre kuin abko Kukwe Biani Ngöbökwe Moiséye dirikätre kirakira käkwe ükaninte nuendre kore, ñobtä ñan angwane kore rabadre dbe Ngöbö ngwärekri, erere nitre bariseo btä nitre israelita käta mike täte jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nitre israelita tä nebe jändrän kökö jae, bti tä nüketa gwi angwane, ñan köbötikadre käne kwetre, ñan mrödre kwetre. Arato kukwe mda mda mikata täte kwetre abko nere: baso bätädrete, mrü bätädrete, unkwen bätädrete, jän bätädrete. Ye abko, Kukwe Biani Ngöbökwe Moiséye dirikätre kirakira abko käkwe kukwe ükaninte nuendre ja mikakäre dbe Ngöbö ngwärekri nitre israelitaye, erere tä nuene janknu ja täritäri.) ");
INSERT INTO gymNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ne mdenbtä abko, nitre bariseo btä Kukwe Biani Ngöbökwe Moiséye dirikätre jatani, käkwe niebare Jesuye: Nun mräkä kirakira käkwe kukwe ükaninte nuendre, ¿se ñobtä abko nitre ja töitikaka mabe käta mike ñakare täte se? Ni rabadre dbe Ngöbö ngwärekri, abkokäre ni ngämi mröre, känenkri köbötikadre abti mrödre abko tä ükaninte kore amarebti nitre ja töitikaka mabe abko ñan tä köbötike jire chi mrökrä se, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesukwe niebare mda ietre: Mun ngwarbe ja bä mike kuin. Mun ye mdenbtä Isaías käkwe Ngöbö Kukwei niebare metre munbtä abko tä tikani krörö: Juta ne käta ti mike ütiäte ja kada aibebti, aisete tä ti tarere ñakare era metre. ");
INSERT INTO gymNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Tätre ti käikitekä ngwarbe amne kukwe ükaninte au jakrä kwetre, aibe tätre dirire ti Kukwei täte, niebare Isaíakwe munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ye abko, kukwe biani Ngöbökwe nuendre nie abko munta kite jökrä temen, amne kukwe ükaninte ni kä nebtäkwe abko mikata bäri ütiäte jae munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ye abko, kukwe biani Ngöbökwe nuendre nie, erere munta mike ngwarbe jae, akwa kukwe ükaninte au jakrä munkwe abko mikata täte munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ye mdenbtä, Ngöbökwe ja kukwei tikamna krörö täräbtä Moiséye: Mun rün btä mun meye mika ütiäte jae munkwe. Nire nire käkwe ñäkädre tare rün amne meye rüere, ni ye abko kämikadre, abko tikamna Ngöbökwe Moiséye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Akwa mun abko tä niere krörö: Ni iti käkwe niedre rünye amne meyeye: Jändrän tikwetikwe se erere Korban, aisete tikwe biani jökrä Ngöböye, aisete ti ñan raba mun die mike jire chi bti, niedre kwe, ye abko dbe, munta niere. ");
INSERT INTO gymNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nire nire käkwe niedre kore angwane, ñan ni rün btä ni meye die mikadre jire chi mda kwe abko munta dirire kore. Ye kwrere munta Ngöbö Kukwei mike ngwarbe jae. ");
INSERT INTO gymNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ye abko, kukwe ükaninte au jakrä munkwe abko mikata täte munkwe, btä kukwe mda mda ne kwrerekwrere, munta nuene janknu ja täritäri. Akwa munta ye nuene angwane, munta Ngöbö Kukwei kite temen. Abko kore se, niebare Jesukwe nitre bariseoye btä Kukwe Biani Ngöbökwe Moiséye dirikätreye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yebti Jesukwe ni jökrä käräbareta mda, bti niebare kwe ietre: Ti bike kukwe niere, ne kukwei nuen munkwe angwane, munkwe mika nüke gare jae abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","mrö jökrä kwetata nikwe, ye abko ñan tä ni mike ngite Ngöbö ngwärekri, akwa kukwe jökrä käme ni töibtä, nita nuene ye abra tä ni mike ngite Ngöbö ngwärekri. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ni kukwei ruen munye angwane, munkwe kukwe ne ketate olote. Abko kore se, niebare Jesukwe nitre kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yebti Jesu nikaninta gwä nitre ja töitikaka benbe. Ni mda mda nämane kwati abko namani jökrä ju bäre. Jesu namaninta gwi angwane, nitre ja töitikaka ben käkwe niebare ie: ¿Kukwe diriniri makwe, ye ño yere? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesukwe niebare mda ietre: ¿Abko kukwe ñan nü gare munye arato ya? Mrö jökrä kwetata nikwe, ye ñan tä ni mike ngite Ngöbö ngwärekri, ");
INSERT INTO gymNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ñobtä ñan angwane nita mrö kwete, ye abko tä niken jökrä ni bülete, akwa nita nainkrö angwane, nita mrö ye kitekäta jökrä, ¿ye abko gare ñakare munye ya? (Ne aisete, mrö jökrä kuin kwetadre, niebare Jesukwe.) ");
INSERT INTO gymNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kukwe kämekäme ni töibtä, nita nuene, ye käta ni mike ngite Ngöbö ngwärekri, ");
INSERT INTO gymNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ñobtä ñan angwane kukwe kämekäme abko tä ni töite amne ni motote abko erere nita nuene abtä nita ja mike ngite Ngöbö ngwärekri abko krörö: Ni merire brare ja mike ngite bätäkä ngwarbe jabe kwärikwäri amne ni jändrän goire ni mda mdakän. Erere arato, nita ni mda mda kämike, ni gure käta ja mike gure bati bati tiebe ni mda mdabe. ");
INSERT INTO gymNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nita gore, jändrän ni mda mdakwe, ie ni tö jökrä jakrä, nita kukwe kämekäme aibe nuene, nita ni ngökö, ni diän diän, ni tö rabai ni mda mda kwrere, nita ñäke ni mdabtä, nita bike kri, ni töbike ñakare metre ja käne. ");
INSERT INTO gymNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kukwe kämekäme keta kabre nita nuene, ñobtä ñan angwane ye tä ni töibtä, käta ni mike ngite Ngöbö ngwärekri. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Abti Jesu nikani juta Tiro bäre temen. Namani yete angwane nikani gwä, akwa ñan tö namani ja mikai tuare ni nünanka kä yete ie, aisete nikani tiebe, akwa nitre kä ye känti käkwe gani. ");
INSERT INTO gymNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ye känti meri nämane iti abko ngänkänbtä üai käme nämane nüne. Meri ye abko griega amne Sirofeneciabo. Niara ñakare israelita. Jesu nükani gani kwe angwane, jötrö ngware nikani, käkwe ja mikani bobre ngukudokwäbti Jesu ngwärekri, bti niebare kwe ie: Üai käme juentari ngäbäkre tikwe sebtä, namani kärere kisere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Abtä Jesukwe niebare mda ie: Tikwe kukwe kri nuendre makrä, ye abko mrö ngäbäkrekrä kita nukro ngäbäli kiakia ie kän, ye kwrere tikwe nuendre nitre israelitabtä, aisete ti ñan raba üai käme juentari ngäbäkrebtä makrä, ñobtä ñan angwane ma abko nukro ngäbäli kiakia ye kwrere aisete. ");
INSERT INTO gymNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Meri ye käkwe niebare mda Jesuye: Jän, ti dänkien, akwa mrö büreta betekä timon ngäbäkre kisete abko nukro ngäbäli kiakia tä kwete mesa täni. Ye mden kisete, tita kukwe ribere mae nete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesukwe niebare mda ie: Mata kukwe era niere. Ngöböta sribire ño ni kwe ngätäite tä gare kuin mae, nibi tuen tie. Arato mata tödeke kwatibe Ngöböbti, nibi tuen tie. Ye köböire tikwe üai käme junina mento ma ngänkänbtä, aisete nibirate kuinta, aisete nänta ja gwiriete. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ye erere bkänä, meri ye nikaninta, namaninta gwi angwane, üai käme nikanina mento ngänkänbtä aisete, nämane jäme jänbti, btä namaninta. Ne abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu nämane juta Tiro bäre temen, nikaninta angwane, nikani juta Sidón känti ta, nikani kä kädian nämane Decápolis känti. Te nükani, namani Ñö Okwä Kri Galilea btä. ");
INSERT INTO gymNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ye känti ni iti abko olo ngidianinte amne kukwe ritete jänükani mräkäkwe Jesuye. Angwane Jesukwe kise mikadre bti mikakäre kuinta abko mräkäkwe ribebare kisere ie. ");
INSERT INTO gymNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ye känti ni nämane kwati Jesu bäre ta, aisete Jesukwe ni ye ngwiani mento, bti kise kriani olote kwärikwäri kwe, tüdrä abko nuaninbtä kälibti kwe, ");
INSERT INTO gymNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","nikrabare kä käinbti kwe blitakäre Ngöböbe, bti büre jäkäni nga kwe, bti ñäkäbare krörö arameo kwe ni neye: ¡Efata! niebare Jesukwe ie. (Kukwe arameo ne abko käta: ¡Olo ngiente tita niere mae! niere). ");
INSERT INTO gymNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ye btäräbe ni ye olo gu ngitianinta, tüdrä namaninta kuinta amne namani blite kuin metre. ");
INSERT INTO gymNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","37","Kukwe nakaninkä kore, ye Jesukwe ñan kädriemna jire chi ni mda mdabe, akwa ni nämane yete, okwäbti Jesukwe kukwe kri nuenbare, ye töi ñan namani krütare, kä namanintre niere: Ni seta jändrän kuinkuin nuene ño, amarebti ni olo ngidianinte ie tä ni kukwei mike ruenta. Ni kukwei ñakare abko tä kukwe tike sere, namanintre niere kore. Mden kisete, kukwe nakaninkä ñan kädriedre abko Jesu namani niere ietre, akwa bäri namani kädriere ni mda mdabe. ");
INSERT INTO gymNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kä ye ngwane, bati ni nükaninta ja ükekrö kwati Jesubtä abko kän mrö krütani jökrä. Abtä Jesukwe nitre ja töitikaka ben käräbare, bti niebare kwe ietre: ");
INSERT INTO gymNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Köbömära jire ni kwati tä tibe nete, ie mrö ñakare kwetadre, aisete nibi tuen bobre tie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ni ruäre nünanka mente jatani tä nete. Tikwe juandreta mröi ja gwiriete angwane, nane kä rötarete bti ji ngrabare, aisete nibi tuen bobre tie. Ti ñan tö juainta mröi, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nitre ja töitikaka ben käkwe niebare mda ie: Nita kä kaibe nete. ¿Kä krörö känti abko ni bukare drete sere? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesukwe niebare mda ietre: ¿Banta kobe munkwe? Niaratrekwe niebare mda ie: Banta kun kükübe nunkwe, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesu käkwe täkämna temen nitre nämane yeye, bti ban kun kükü diani kisete kwe, kuin niebare btä kwe Ngöböye, ñäkänintbe kwe, bti ngökani kwe nitre ja töitikaka benye dräidre ni nämane kwati yebti. Erere bkänä, ban dräibare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Gwa kiakia nämane krobu, krämä kwetre, btä Jesukwe kuin niebare Ngöböye, bti ngökani kwe nitre ja töitikaka benye, bti juani dräire kwe arato. ");
INSERT INTO gymNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ni jökrä käkwe mröbare, namanintre trinetrine jökrä, bti ban oto namaninte, ye abko nitre ja töitikaka Jesube käkwe ükaninkröta kutia kwä kükü. ");
INSERT INTO gymNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ni kwati käkwe mröbare, ye abko ni brare brare aibe mili kräbkä näre amne meri btä ngäbäkre nämane kwati abko tanbare ñakare. Ni jökrä käkwe mröbare trine, bti Jesukwe juaninta ja gwiriete, ");
INSERT INTO gymNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bti niara btä nitre ja töitikaka ben nakwani rute, nikani kä kädian nämane Dalmanuta känti. ");
INSERT INTO gymNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesu btä nitre ja töitikaka ben namani Dalmanuta angwane, nitre bariseo nükani ja kwete ben amne Jesukwe ja dokwä mikadre kö okwäte, abkokäre nükani ja kwete ben. Jesu abko juani era metre Ngöbökwe ya, ñakare ya abko Jesukwe bä mikadre, käkwe sribi kri ñan tuabare nuendre niaratre okwäbti abko nükani ribere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ye namani tare kri Jesubtä, aisete büre jäkäni nga kwe, bti niebare mda kwe ietre: ¡Jo! ¿Ye ñobtä mun nünanka kä ne ngwane tä kukwe ye kwrere ribere dikaro tie yere? Ngöbö tö dre nuein, ye tikwe nin niedi jire chi munye, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Kukwe namani tare kri Jesubtä. Yebti nitre bariseo mikaninte känime kwe, nakwaninta rute, bti nikaninta ja jiebti ñö okwä kri kwärä nakri. ");
INSERT INTO gymNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nämane Dalmanuta angwane abko nitre ja töitikaka Jesube, bti kä nikwitaninkä ban ngwiandre jabe, abkokänti namanina rute angwane, banbe nämane kuntibe kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ye ngwane, Jesukwe nitre ja töitikaka ben mikani mokre, käkwe niebare ietre: Lebadura nitre bariseokwe btä nitre reketaka Herodebe, ye ngäniene munkwe ja ngibia kuin, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Abtä nitre ja töitikaka Jesube namani niere jae kwärikwäri: Ni ñan ki ban mda ngwena, abtä Jesuta blite kore, namani niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ye gani Jesukwe, abtä niebare kwe ietre: ¿Ti abko nire metre ngämi nüke gare munye ya? ¿Ti raba mrö bien munye Ngöbö diebti ngämi nüke gare munye ya? ¿Ye ñobtä ban ñakare munye, munta niere dikaro jae abko mun töi ngitiekä ñakare arato ya? ");
INSERT INTO gymNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Kä tuen munye amarebti tita dre nuene abko nüke gare ñakare munye yere? ¿Ni kukwei ruen munye amarebti mun ti kukwei tebaire ñakare yere? ¿Tikwe dre nuenba, ye töre ñakare munye ya? ¿Ye ñobtä abko ban ñakare mun nibi niere yere? ");
INSERT INTO gymNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Ni mili krärike jire bti tikwe ban kunrikebe dräiba, ye rabateba abko ükakröbata kutia kobe munkwe? niebare Jesukwe nitre ja töitikaka benye. Niaratre käkwe niebare mda: Ban rabateba abko ükakröbata kutia kwä jätäbti kubu nunkwe, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Bti Jesukwe niebare mda ietre: ¿Erere arato, ni mili kräbkä jire bti tikwe ban kun kükübe dräiba, ye rabateba abko munkwe ükakröbata kutia kobe? niebare kwe ietre. Niaratre käkwe niebare mda Jesuye: Ban rabateba abko ükakröbata kutia krikri kwä kükü nunkwe, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Abtä Jesukwe niebare mda ietre: Tikwe jändrän ne nuenba mun okwäbti amarebti, ¿se ñobtä abko drebtä tita blite abko ngämi nüke gare metre munye? Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yebti Jesu btä nitre ja töitikaka ben nikani mate juta Betsaidate angwane, ni iti, ie kä tuen ñakare jänükani mräkäkwe Jesuye. Jesukwe okwä nuadrebtä ja kisebti mikakäre kuinta abko mräkä namani ribere kisere ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ni ie kä tuen ñakare, ye Jesukwe kani küdebti, nikani ben mento juta bäre, namani juta bäre angwane, Jesukwe käli mikani ni ye okwäbtä, bti kise mikani okwäbtä kwe, käkwe niebare ie: ¿Kä nibi tuen mae ya? ");
INSERT INTO gymNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ni ye käkwe niebare: Ni nibi tuen kri kwrere dikekä tie, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ni ye, ie kä namani tuen diore, abtä Jesukwe kise mikaninta mda bati okwäbtä angwane, okwä namaninta kuin jökrä, aisete kä namani tuenta kuin jökrä ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Bti Jesukwe niebare ie: Tikwe ma okwä mirita kuinta, ye makwe ñan kädrie jire chi ni mda mdabe juta Betsaidate. Nänta jirekäbe ja gwiriete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yebti juta kiakia tä juta Cesarea Filipo bäre temen, ye kukwäre Jesu nikani nitre ja töitikaka benbe sribikäre juta kiakia yete. Namanintre dikekä ji ngrabare angwane, Jesukwe niebare ietre: ¿Ti ne abko nire nieta ni mda mdakwe tibtä? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Niaratre käkwe niebare mda Jesuye: Ma abko Juan Bautista nükaninta nire nieta ni ruärekwe amne ni mda abko käta ma Elías nükaninta niere mabtä. Akwa ni mda abko tä niere Ngöbö kukwei niekä kirakira mda mda abko nükaninta nire nieta kwe mabtä, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesukwe niebare mda ietre: ¿Mun abko käta ti nire niere tibtä? niebare kwe ietre. Pedro abko käkwe niebare Jesuye: Ma abko ni Dianinkä juani Ngöbökwe nun ngätäite, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesukwe niebare mda nitre ja töitikaka benye: Ti abko Ni Dianinkä Ngöbökwe abko, munkwe ñan kädrie jire chi ni mda mdabe, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ye känti mentokwäre Jesu nikani dirire nitre ja töitikaka benye angwane, nikani niere: Nitre unbre ji dokwäte, nitre blitaka Ngöböbe ni mda mda diäre dänkien amne Kukwe Biani Ngöbökwe Moiséye dirikätre, käkwe ti Ni Kä Nebtä Ngobo ne mikadi ja tare nike kri amne trö kwitadi kwetre tie, käkwe ti müre ketadi, akwa köbömäkäre angwane, ti rükadita nire, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kukwe ne rakadrekä ño Jesubtä, erere niebare metre ta kwe nitre ja töitikaka benye. Abtä Pedrokwe Jesu käräbare, nikani kaibe ben mentokwäre, bti nikani mäträre btä. ");
INSERT INTO gymNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Abtä Jesu nikwitaninte, käkwe nitre ja töitikaka ben mikaninta ñäräre, bti ñäkäbare krörö kwe Pedroye: Satana, nän mento tibtä nete. Tikwe ja mikadre ngite Ngöbö rüere, abkokäre ma kite ñäke kore tie ñan ñan. Ni kä nebtä ie jändrän tuen dbe abko erere tä tuen mae, aisete makwe ñan ñäkä kore tie, niebare Jesukwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bti Jesukwe nitre ja töitikaka ben btä ni mda mda nämane yete, ye käräbare, bti niebare kwe ietre: Nire nire tö ja töi mikai kwatibe nänkrä tibe, ni ye abko tö dreye jakrä abko raba käikwitekä jabti amne ja kwata raba ruentari tare ñakare ie nünakäre tikrä abko jata ti jiebti, ");
INSERT INTO gymNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ñobtä ñan angwane nire nire tö ja kwata ngibiai jen jakrä abko krütadi kärekäre, erere rabadi kärekäre Ngöbö okwä bäre mento akwa, nire nire krütadi ti dokwäre amne kukwe kuin Ngöbökwe tibtä ye dokwäre abko rabadi dianintari nünakäre kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ye abko, ni rabadre jändrän jökrä bkäne kabre kä nebtä, akwa ni krütadre angwane nikwe ñan nünandre mda Ngöböbe, ne ütiäre abko dre rükadre nie. ");
INSERT INTO gymNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Erere arato, nikwe nünandre kärekäre, ye abko ni ñan raba kökö jire chi jakrä, ñobtä ñan angwane jändrän ñakare jire abko ni rabadre bien Ngöböye nüna kärekäre ben ye ütiäre. ");
INSERT INTO gymNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ne aisete, nire nire käta ti rükente amne kukwe dirita tikwe ne rükente nitre tödekaka ñakare Ngöböbti käta kukwe kämekäme nuene ye ngwärekri, ni ye abko ti Ni Kä Nebtä Ngobo ne jatadita angwane, tikwe ni ye rükandite arato. Ti jatadita angwane ti jatadita ti Rün di kri bä nuärebti, erere arato angele deme Ngöbökwe bä nuärebti, niebare Jesukwe nitre ja töitikaka benye btä ni mda mda nämane yete yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yebti Jesukwe niebare mda: Mun tä nete ne ruäre ngämi krüte, känenkri Ngöböta gobrane ño ja dibti ni kwe ngätäite, ye abko munkwe tuadi ja okwä jenbti abko ti tö nibi niei metre munye. Abko kore se, niebare Jesukwe ni jökrä nämane yete yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yebti kä nikani köbö ti ta mda angwane, Jesukwe Pedro, Santiago amne Juan aibe ngwiani jabe abko ben nikani ngitio bäri mente käin yebti. Niaratre nämanena ngitio yebti käin angwane, Jesu bä nikwitani bä jene niaratre okwäbti, ");
INSERT INTO gymNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Angwane dän Jesubtä namani trä ngitiekä jökrä ngrabare, namani ngwen bürere. Ni ñakare jire iti kä raba dän bätete ngwen bürere dikaro erere dän bä namani Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ye btäräbe Elías btä Moisés namani gökökä yete blite Jesube, btä okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedrokwe niebare Jesuye: Ti Dänkien, nunta nete abko käi nibi nuäre tibtä, aisete ma tö ne ngwane nunkwe ju mikadi kiakia komä munkrä: kwati makrä, kwati Moisékrä amne kwati Elíakrä, niebare Pedrokwe. ");
INSERT INTO gymNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro abko käkwe ñäkäbare kore, ñobtä ñan angwane nitre ja töitikaka Jesube abko namani nekwetekä, aisete ño niedre kwetre abko ñan namani nüke gare ietre. Abtä Pedro namani ñäke kore. ");
INSERT INTO gymNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ye btäräbe müta jatani jüben niaratrebti angwane, müta yete abko ni kukwei jarabare krörö ietre: Ni ne abko ti Odei tare kri tikwe. Niara kukwei nua munkwe abko ni kukwei namani kore mütate. ");
INSERT INTO gymNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ye btäräbe nitre ja töitikaka käkwe nikrabareta ja bäre angwane, ni mda ñakare amne Jesu aibe nämane kaibe, btä okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yebti Jesu nikaninta niaratrebe ngitiobtä motokwäre angwane, Jesukwe niebare ietre: Ti Ni Kä Nebtä Ngobo ne ngämi krüte, bti nüketa nire, ye känenkri kukwe turi munkwe ngitiobti käin sete, ye munkwe ñan nie jire chi ni mda mdaye. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ja rükadreta nire niebare Jesukwe, ye niaratre käkwe ngibiabare tiebe, akwa ye abko dre niebare Jesukwe abko ñan nükani gare ni nimä ja töitikaka benye, aisete namani ngwentari jirekäbe jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Abtä niaratre käkwe niebare mda ie: ¿Ma krütadi bti rükadita nire mata niere ne ngwane, ñobtä abko Elías rükadre bäri Ni Dianinkä Ngöbökwe käne kukwe ükatekäre biare kräke Kukwe Biani Ngöbökwe Moiséye dirikätre käta niere? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Amne Jesukwe niebare mda ietre: Elías rükadre käne ye abra era bkänä. Erere arato, niara rükadre Ni Dianinkä Ngöbökwe käne, käkwe jändrän jökrä ükadrete kuin metre. Akwa ti tö kukwe mda ngwiaintari munye: ¿Ñobtä ti, Ni Kä Nebtä Ngobo, mikadi ja tare nikadi kri amne ti mikadi ngwarbe ni mdakwe abko tä tikani Ngöbö Kukweibtä? Yebtä töbika munkwe. ");
INSERT INTO gymNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Akwa Elías abko nükanina, akwa Kukwe Biani Ngöbökwe Moiséye dirikätre, ie niara ñan nükani gare, aisete tö namani dre dre nuein btä, erere nuenbare kwetre amne mrä müre ketani kwetre, nämane tikani Ngöbö Kukweibtä abko erere namani bare jökrä btä. ");
INSERT INTO gymNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesu jatani nüketa möta nitre ja töitikaka nimä ben angwane, nitre ja töitikaka ben ni ökän namani abko ben Kukwe Biani Ngöbökwe Moiséye dirikätre nämane ruäre abko nämane ja kwete amne, ni mda mda nämane kwati, btä Jesu nükaninta. ");
INSERT INTO gymNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesu nükaninta, ye ni nämane kwati käkwe gani angwane, töi ñan namani krütare, kä nikani betekä jökrä köbö ngwentari Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesukwe niebare mda ietre: ¿Drebtä munta ja kwete nete? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Jötrö ngwarbe ni nämane kwati, ye ngätäite ni nämane iti käkwe niebare Jesuye: Dirikä, üai kämenta jadenkä ngäbäkrebtä tikän abko kisete kukwe ngitie ñakare. Tä niken mdente erere, ye känti tä neketete üai käme yeye, tä kaenkä käinta bti tä kite temen, tä nikrenkä jökrä ngrabare, däbe tä nebe betekä kadate angwane, tä nebe tu ukwe jökrä jabtä. Mden abko makwe mikadreta kuinta tikrä, abkokäre ti ki ngwena mae yere. Akwa nitre ja töitikaka mabe aibe tä nete, ie tikwe üai käme juantarimna ngäbäkrebtä jakrä, akwa ñan niki mento ietre, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Abtä Jesukwe niebare mda ietre: ¡Aingwaree, ti moto iko munbtä! Munta tödeke ñakare dikaro Ngöböbti ye. ¿Ti rabadi kä nuäi mda munbe amarebti ye? niebare Jesukwe. Ye btäräbe Jesukwe niebare mda: Ngäbäkre ye ngwen tie, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Erere ngäbäkre ye jänikani Jesuye, jänikani nebe ken angwane, Jesu jatabare üai kämeye, ye btäräbe üai käme käkwe kä ötanintbe ngäbäkre yebti, nikani ngitiekä temen, namani ja den ngwarbe jabti tata nekwäre, sekwäre, nekwäre, sekwäre. Däbe namani betekä kadate. ");
INSERT INTO gymNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","22","Ye ngwane Jesukwe niebare ngäbäkre ye rünye: ¿Kä kobera üai käme nikani jadenkä kore ngäbäkre nebtä? niebare kwe rünye. Niarakwe niebare mda Jesuye: Nämane chi angwane, üai käme nikani jadenkä btä tikän yere, abko täbe känime. Üai käme töta nebe müre ketai, käta kite ñukwäte, tä kite ñöte tikän, aisete ma di tärä mikakräta kuinta tikrä, ne ngwane nun ngwen ruen bobre jae. Nun die mike. Üai käme juentari mento btä, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesukwe niebare mda ie: Nirekwe tödekadre kwatibe tibti, kräke jändrän jökrä nuäre nuene. ¿Se ñobtä abko ti di tärä üai käme juantarikrä mata ngwentari tie yere? niebare kore Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Abtä ngäbäkre rünkwe ñäkäbare jume ja dibti krörö mda Jesuye: Tita tödeke mabti, akwa mtare ti tö nibi tödekai bäri kwatibe mabti, yebtä ti die mika makwe, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ye btäräbe ni jatani nüke ja ükekrö bäri kabre mda, namani tuen Jesuye. Abtä jötrö ñäkäbare krörö kwe üai kämeye: Üai käme, ma ngäbäkre ne kukwe ötaka amne ma ngäbäkre ne olo dikatekä, ma yeye tita niere, nän mento ngäbäkre nebtä. Ma ñan jata jadenkäta jire chi mda btä, tita niere mae, niebare Jesukwe üai kämeye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Angwane üai kämenkwe ngratebare kri ngäbäkre yebtä, bti kä ötanintbe bti kwe bobuta, nikani ngitiekä temen angwane, üai käme nikani mento. Ngäbäkre abko namani kwekbe temen ngwäkäre kwrere ni kwati ye okwäbti. Abtä namanintre niere: ¡Aiteeje! Ngäbäkre krüta tare yera, ni kwati namani niere kore. ");
INSERT INTO gymNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Akwa Jesu nikani, käkwe ngäbäkre ye kani küdebti, bti ganinkrö krö kwe. Ngäbäkre ye nükaninbe dikekäta krö. Namani kuin jökrä abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yebti Jesu namaninta kaibe gwi nitre ja töitikaka benbe angwane, niebare mda kwetre Jesuye: Nunkwe üai käme junintari mento, ¿ye ñobtä ñan niki mento nunye ruen? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesukwe niebare mda ietre: Munkwe blitadre Ngöböbe btä ja bäindre Ngöbökrä käne, aibe köböire üai käme ye kwrere mun raba juentari mento. Ye munkwe nuni ñakare kore, mden kisete ñan niki mento munye, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesu btä nitre ja töitikaka ben nämane Cesarea Filipo käntita temen, nikaninta angwane nikaninta kä Galilea käntita. Akwa ni mda mdakwe ñan gadre ie tö namani, ");
INSERT INTO gymNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ñobtä ñan angwane Jesu nämane dirire krörö kaibe nitre ja töitikaka benye: Ni mda mda abko ie ti, Ni Kä Nebtä Ngobo, ne biandi müre ketadre, akwa köbömä angwane, ti rükadita nire, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jesukwe dre niebare kore ñan nükani gare nitre ja töitikaka benye, akwa namani ja gaire, aisete ñan namani ngwentarita Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Abti nükaninta mda juta Capernaúmte. Namaninantre ja gwiriete angwane, Jesukwe niebare nitre ja töitikaka benye: ¿Drebtä mun täni ja kwete ji ngrabare yere? niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Namanintre kwekbe jökrä, ñobtä ñan angwane niaratre ngätäite nire bäri ütiäte, abkobtä nämane näin ja kwete ji ngrabare, aisete namanintre kwekbe. ");
INSERT INTO gymNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Drebtä namanintre ja kwete namanina gare Jesuye, aisete Jesu namani täkänintbe, käkwe niebare mda ietre: Mun jakwe ti ken nete. Nire nire tö ja tuai bäri ütiäte kri ni mda mdakrä Ngöbö okwäbti, ye käkwe ja mika bäri bobre ni mda mdakrä amne ja mika ni sribikä ene kwrere ni mda mdakrä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Bti Jesukwe ngäbäkre chi käräbare nüke nitre ja töitikaka ben ngätäite, bti kukwe ye bä mikakäre, ngäbäkre ye diani kisete kwe, bti niebare kwe ietre: ");
INSERT INTO gymNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Nire nire käta ti tarere metre abko käkwe ngäbäkre ne kwrere kadre ngäbti ti käbti. Nirekwe kadre ngäbti kore, ye ngwane ñan ngäbäkre aibe kata ngäbti kwe angwane, ti kata ngäbti kwe arato. Ye kwrere arato, nire nire käkwe ti kadre ngäbti kuin abko käta Ngöbö ti juanka kaen ngäbti arato. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ye ngwane Juan abko käkwe niebare mda Jesuye: Dirikä, nunkwe ni turi iti üai käme juentari ma käbti, akwa nekete ñakare nibe, aisete ñan üai käme juandretari mda kwe ma käbti, nunkwe nini ie, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Abtä Jesukwe niebare mda ietre: Munkwe ñan ñäkä kore ie amne ñan bika kri niarabtä munkwe, ñobtä ñan angwane nirekwe sribi kri ñan tuabare nuendre ti käbti, yebti ñan tä näin ñäke blo ti rüere, akwa tä blite kuin tibtä. ¿Se ñobtä abko, munkwe ñan üai käme juantarimna mda ti käbti ie yere? ");
INSERT INTO gymNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ni ja rüere ñakare nibe, ye abko tä nekete nibe, aisete munkwe ñan ñäkä ie. ");
INSERT INTO gymNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jesukwe niebare: Munta ti mike täte, abtä nirekwe ñö aibe biandre chi tomnane munye, akwa ni ñö bianka munye tä nekete nibe, ni yeye Ngöbökwe sribi kuin ye ütiä biandi abko ti tö nibi niei metre munye. ");
INSERT INTO gymNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Akwa nire nire käta ja mike bobre Ngöböbtä ngäbäkre ne kwrere, ye nirekwe ngwiandreta ti käikwitekä jabti, känti rabadre kukwe nuene bäri käme mda, ni ye abko Ngöbökwe mikadi ja tare nike krübäte kä nakebtä. Mden kisete, ni ye ngämi ni tödekaka tibti ngwen ti käikwitekä jabti, känenkri jä oto kri doboko nura ukwakrä ye mäkädre ngärä, bti kitadre mrente nguse känti müre reketadre abko rabadre bäri kuin kräke. Ye kwrere ni ye ñan rabadre ni tödekaka tibti ngwen ti käikwitekä jabti aisete. ");
INSERT INTO gymNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ye kwrere mun kise mden köböite makwe ja mika ngite Ngöbö rüere ne ngwane, munkwe ja kise ye tikaka ta abko bäri rabadre kuin, ñobtä ñan angwane munkwe nünandre deme kise otore kwärä rikakäre nüne Ngöböbe kä käinbti abko bäri kuin angwane, ñan mun kise krobu ngöi jökrä ben mun rikadre ja tare nike kärekäre ñukwä jutra nötöte ñakare köbö kwatirekwatire ye te. ");
INSERT INTO gymNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kä nakebtä, yete jändrän jökrä tä niken ngwarbe amne nginta kwete kärekäre. Ye kwrere abko ñukwä jutra ngitiekä käre, ni käme Ngöbö ngwärekri mikakäre ja tare nike kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Erere arato, mun ngoto mdenkri, köböite mun raba ja mike ngite, ne ngwane munkwe tikaka ta jae abko bäri rabadre kuin, ñobtä ñan angwane mun ngoto kwäräbe akwa mun rabadre nüne metre Ngöbökrä abtä munkwe nünandre kärekäre ben, ye abko rabadre bäri kuin munkrä amne, ñan mun ngoto krobu ben ngöi Ngöbökwe mun kitadre kä ja tare nikakrä känti. ");
INSERT INTO gymNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kä nakebtä yete jändrän jökrä tä niken ngwarbe amne nginta kwete kärekäre. Ye kwrere abko, ñukwä jutra ngitiekä käre, ni käme Ngöbö ngwärekri mikakäre ja tare nike kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Erere arato, mun okwä köböite mun raba ja mike ngite Ngöbö rüere, ne ngwane munkwe ja okwä ye diante kwati mento, bti munkwe kitaka mobe arato, ñobtä ñan angwane Ngöböta gobrane, ye känti mun okwä kwatibe ben mun rikadre nüne kärekäre ben, ye abko rabadre bäri kuin munkrä amne, ñan mun okwä kubu ben ngöi mun kitadre kä ja tare nikakrä känti. ");
INSERT INTO gymNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kä nakebtä yete jändrän jökrä tä niken ngwarbe amne nginta kwete kärekäre. Ye kwrere abko, ñukwä jutra ngitiekä käre, ni käme Ngöbö ngwärekri mikakäre ja tare nike kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jändrän kukwadre Ngöböye, btä mren mikata mikakäre bänänte, ye kwrere abko munkwe ja tare nikadi mun mikakäre metre. ");
INSERT INTO gymNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mdakäre abko, mren abra kuin jändrän jökrä mikakrä bänänte, akwa mren bänän riadrekä, ye ngwane ñan bänän rabadreta kuin mda. Ye kwrere munta bike kri jabtä kwärikwäri angwane, mun ñan raba sribi nuene Ngöbökrä, aisete mun rabadre ngwarbe mren bänän riadrekä kwrere. Mden kisete munkwe ti mikadi täte metre, ye köböire mun rabadi nüne jäme jabe kwärikwäri. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu nämane Capernaúm, nikani mda nitre ja töitikaka benbe kä Judeate. Arato nikani Ñö Jordánbtä kä driri. Ye känti ni nükaninta ja ükekröta kwati Jesubtä abko, ie Jesu nämanena dirire ño, erere nikani dirireta ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ye ngwane, nitre bariseo nükani ruäre abko tö namani ja gain Jesube niara kitakäre ngite, käkwe niebare ie: ¿Kukwe Biani Ngöbökwe Moiséye käta dre niere abko nikwe mikadre täte ya? ¿Ni gure käkwe ja tuametreta, ye abko dbe ya ño niere nunye? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesukwe niebare mda ietre: ¿Ni gure käkwe ja tuametreta, ye nuemna Moisékwe munye ya ño arato? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Niaratrekwe niebare mda Jesuye: Ni gure käkwe ja tuadremetre abko dbe niebare Moisékwe, akwa nita ja tuemetre abko tikadre täräbtä biandre meriye, niebare Moisékwe, niebare kore nitre bariseokwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Abtä Jesukwe niebare mda ietre: Mun dokwä ribi ribi Ngöbökrä. Ye mdenbtä ni gure käkwe ja tuadremetre abko Ngöbökwe tikamna täräbtä Moiséye munkrä yere. ");
INSERT INTO gymNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Akwa Ngöbökwe kä dätebare kena btä abko tikamna krörö kwe täräbtä Moiséye arato: Ngöbökwe ni brare btä ni merire dätebare. ");
INSERT INTO gymNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ne aisete ni brare käkwe ja mikadre gure angwane, rikadre nüne jenena rünbtä amne meyebtä mento merire kwebe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Angwane ni nibu ye abko rabadi ni itibe kwrere, abko tikamna kore kwe täräbtä Moiséye. Ye kwrere ni nibu ye ñan rabadi ni nibu kwrere mda, akwa rabadi ni itibe kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ye mden kisete, Ngöbökwe ni mikani ni itibe kwrere, ye ni ñan rabadre denkä jire chi jene jene mentokwäre, aisete ni brare käkwe ñan meri tuadremetre. Abko kore se, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yebti Jesu namanina gwi angwane, kukwe ngwianintari nitre bariseokwe, ye arabe nitre ja töitikaka ben nikani ngwentarita ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Abtä Jesukwe niebare nitre ja töitikaka benye mda: Ni brare käkwe merire kwe tuadremetre, bti meri mdara jire ben ja mikadre gure kwe, ni ye käkwe ja mikadre ngite merire käne rüere. ");
INSERT INTO gymNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ye erere arato, ni merire käkwe brare käne kwe tuadremetre, bti rabadre brare mdabe, meri ye abko käkwe ja mikadre ngite brare käne rüere. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yebti ngäbäkre jänikani mräkäkwe Jesuye abko bti Jesukwe kise mikadre ja di biankäre ietre. Akwa nitre ja töitikaka Jesube namani ñäke ngäbäkre mräkäye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ye gani Jesukwe angwane, namani romon nitre ja töitikaka benkrä, käkwe niebare mda ietre: Ngäbäkre ye tuemetre kite tie. Munkwe ñan ji öta käne, ñobtä ñan angwane nire nire käta ja mike bobre Ngöböbtä ngäbäkre ne kwrerekwrere, ni yebti abko Ngöböta gobrane, aisete munkwe ñan ji öta käne. ");
INSERT INTO gymNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nire nire ñan tä ja mike bobre Ngöböbtä ngäbäkre chi kwrerekwrere, ni yebti Ngöbökwe ñan gobrandi amne ñan nünandi kärekäre Ngöböbe kwe abko ti tö niei metre munye. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Bti Jesukwe ngäbäkre diani kisete, kise mikani dokwäbti kwe, bti ja di käräbare kräke kwe Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yebti Jesu jatani nikenta mda angwane, ni jatani iti betekä, nükani ngitiekä ngukudokwäbti temen ngwärekri, käkwe niebare ie: Dirikä kuin, ¿tikwe dre nuendre abko ütiäre ti rabadre nüne kärekäre Ngöböbe? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesukwe niebare mda ie: Ngöbö aibe kuin, yebti ni mda ñakare jire kuin. ¿Ye ñobtä abko mata ti kuin niere tie ye? niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bti Jesukwe niebareta ie: Ma tö nünai kärekäre Ngöböbe angwane, Kukwe Biani Ngöbökwe Moiséye, ye garera mae abko erere makwe mika täte abko krörö: Makwe ñan ni mda kämika. Ma gure, makwe ñan ja mika gure bati bati ni mda mdabe. Makwe ñan go. Makwe ñan blita ngwarbe ni mda mda rüere kitakäre ngite. Makwe ñan ni ngöka jändrän diankakäre kän. Erere arato, ma rün amne ma meye mika ütiäte jae. Ye abko Kukwe Biani Ngöbökwe Moiséye nuendre nie kore, erere makwe mikadre täte jökrä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ni yekwe niebare mda Jesuye: Dirikä, makwe kukwe nini, ye ti nämane bati ngäbäkrere angwane, ti nikani mike täte jökrä abti kä nüke tie mtare, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Niara namani ruentari tare kri Jesuye, käkwe mikani ñäräre, bti niebare kwe ie: Jändrän tä keteti nuendre mae. Jändrän tä makwe ye erere nän rürümoine jökrä, bti makwe ngwian ye dräi ni bobre bobrebti angwane, ma rabadi jändrän ütiäte kri bkäne kabre kä käinbti sete. Makwe jändrän rürümoin ünän jökrä kore, bti ma jata ti jiebti. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yebtä ni ye moto namani ulire Jesu kukwei nuare, ñobtä ñan angwane niara abko jändrän bkäne kabre krübäte, aisete moto nötaninte jändrän kwekwe ye jiebti amne moto namani ulire, ben nikaninta. ");
INSERT INTO gymNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nikaninta angwane, Jesukwe nitre ja töitikaka ben mikani ñäräre, bti niebare kwe ietre: Ni jändrän bkänkä krikri ye käkwe ja mikadre bobre Ngöböbtä, Ngöbökwe gobrandre bti abko tare krübäte kräke, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kukwe niebare Jesukwe, yebtä nitre ja töitikaka ben namani töbike kri, ñobtä ñan angwane ni jändrän bkänkä kri nämane nüne metre Ngöbö ngwärekri, nämane nütüre. Ye aisete Jesukwe niebareta mda ietre: Ti mräkä tikwe, ni ye btä Ngöböta gobrane, yebe ketetibe tare krübäte ni jändrän bkänkä krikri neme ketetibe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Aku okwä chi, yete ta kameo krikri ye ara rikadre nuäre, akwa nitre jändrän bkänkä kri ye käkwe ja mikadre bobre Ngöböbtä, Ngöbökwe gobrandre bti, ye abko bäri tare kräke. ");
INSERT INTO gymNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kukwe yebtä bäri nitre ja töitikaka Jesube ñan töi namani krütare mda, käkwe niebare: ¿Ni jändrän bkäne kri ñan rabadre dianintari nini makwe, se nire abko rabadi dianintari amarebti se? namanintre niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Abtä Jesukwe mikani ñäräre, bti niebareta kwe ietre: Mun kä nebtä, ye kräke abko kukwe ye tare, akwa ñakare Ngöbökrä, ñobtä ñan angwane Ngöbö abko kräke jändrän ñakare tare jire chi, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jötrö ngwarbe Pedrokwe niebare mda ie: Nunkwe jändrän jökrä mikaninte, bti nunta näin ma jiebti, ¿se abko Ngöbökwe dre biandi ütiäre nunye? niebare kwe Jesuye: ");
INSERT INTO gymNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesukwe niebare mda ie: Ti bike kukwe era erere niere munye abko krörö: Nänbtä ti jiebti amne Ngöbö kukwe kuin kabtä ngäbti, nire nire käkwe ju mikaninte o etbakantre o ngwai mikaninte kwe, erere arato meye o rün o ngäbriänkä o kä kwe erere mikaninte jökrä kwe nänbtä ti jiebti, nitre ye abko, ie Ngöbökwe jändrän biandi gre ketarike rike bäri mda amne Ngöbökwe mikadi nüne kärekäre jabe arato. ");
INSERT INTO gymNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Nitre ye tä nüne kä nebtä angwane abko ie Ngöbökwe jändrän biandi gre ketarike rike bäri mda abko krörö: Rabadi ju bkäne bäri kabre mda. Erere arato, etba btä ngwai rabadi bäri mda kwe. Arato meye, ngäbriänkä rabadi kwati kwe. Arato kä sribikrä biandi bäri kabre kwe ie. Arato ja tare nikadi kwe tikrä, akwa kä jatadi mrä angwane, nünandi kärekäre Ngöböbe kä käinbti kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Akwa ni kwati tuen bäri ütiäte ütiäte kä ne ngwane, ye abko rabadi ütiäte ñakare Ngöbö ngwärekri; akwa ni kwati tuen ngwarbe, ütiäte ñakare kä ne ngwane, ye abko rabadi bäri ütiäte Ngöbö ngwärekri sete. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Abti Jesu nämane näin juta Jerusalén kukwäre angwane, nikani bä mente nitre ja töitikaka ben käne. Angwane nitre ja töitikaka ben ñan töi namani krütare Jesubtä angwane, ni mda mda nämane näin jiebti köre, abkobtä kä jürä namani. Te Jesukwe nitre ja töitikaka ben ni jätäbti nibu käräbareta mda kaibe mento, bti dre dre rakadikä btä abko nikani niere jökrä ietre krörö: ");
INSERT INTO gymNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Mtare nita näin Jerusalén kukwäre. Ni näin nebe Jerusalén ye känti ti Ni Kä Nebtä Ngobo ne kitadi ngise nitre blitaka Ngöböbe ni mda mda diäre dänkienye amne Kukwe Biani Ngöbökwe Moiséye dirikätre yeye. Niaratre ye abko käkwe ti kitadi ngise müre ketadre amne, nitre romanobo ñakare israelitare abko ie ti kitadi ngise. ");
INSERT INTO gymNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Niaratre käkwe ti mikadi yakrä kri jae, käli kitadi tibtä kwetre amne ti kwata metadi krübäte kwetre. Yebti ti müre ketadi kwetre, akwa köbömäkäre angwane, ti rükadita nire. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yebti Zebedeo ngäbriänkä nibu Santiago btä Juan namani bike kri, käkwe krötabare Jesu ken, bti niebare kwetre ie: Dirikä, nun tö jändrän ribei mae abko erere makwe nuendre, ie nun tö nibi abko nun ki kärere mae, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesukwe niebare mda ietre: ¿Dre nuendre tikwe munkrä, ie mun tö nibi amarebti yere? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Niaratrekwe niebare mda Jesuye: Ma rabadi gobrane kri ja di jenbti ni jökrä ngwärekri, ye ngwane makwe nun mika bäri ütiäte, käkwe nun mika täkänintbe iti ja küde ruenkri amne iti ja küde ngeberekri abko nun tö ribei mae, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Abtä Jesukwe niebare mda Zebedeo ngobo nibu yeye: ¡Jo! Munta kukwe tare krübäte ribere tie gare ñakare jire chi munye. ¿Tikwe ja tare nikadi kri krübäte, ye kwrere munta biare ja tare nike siba ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","¡Jänri! niebare kwetre Jesuye. Jesukwe niebare mda ietre: Munkwe ja tare nikadi kri ti kwrere arato, ");
INSERT INTO gymNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","akwa nire rabadre täkänintbe ti küde ruenkri amne nire rabadre ti küde ngeberekri, ye abko ñan tä ti kisete, akwa tä Ngöbö kisete. Ye aisete nire nire kräke kä ye tä ükaninte ti Rünkwe abko erere ie biandi kwe, aisete ti ñan raba bien munye. Abko kore se, niebare Jesukwe Santiagoye btä Juanye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesu nämane blite kore, ye ni mda mda ja töitikaka Jesube käkwe kukwe ye gani angwane, moto namani romon Santiagokrä btä Juankrä. ");
INSERT INTO gymNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Abtä Jesukwe käräbare, bti nikani niere ietre: Nitre ñakare israelitare käta gobrane angwane, tätre kukwe miketbe tare ni mda mda mikakäre ja ngoto täni. Erere arato, nitre ütiäte krikri ñakare israelitare abko ni mda mdakwe mikadre ütiäte jae, abkokäre tätre bike krikri, ye abko gare kuin munye. ");
INSERT INTO gymNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Akwa mun ja töitikaka tibe, ye ngätäite abko ñan rabadre bare jire chi kore, aisete mun ngätäite abko kukwe rabadre bä jene abko krörö: Nire nire tö rabai bäri ütiäte kri mun ngätäite ye abko käkwe sribidre ni bobre kwrere ni mda mdakrä ");
INSERT INTO gymNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","amne, nire nire mun ngätäite tö rabai bäri käne jändrän jökräbtä, ni ye abko rabadre ni klabore kwrere ni mda mdakrä. ");
INSERT INTO gymNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Munkwe nünandre kore, ñobtä ñan angwane ti, Ni Kä Nebtä Ngobo ñan jatani ni mda mda mikakäre sribire jakrä, akwa ti jatani sribikäre ni mda mdakrä amne ti jatani ja mike müre ketadre ni kwati kökatarikäre Ngöbökrä. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yebti Jesu nükani juta Jericóte nitre ja töitikaka benbe, nikani ta angwane, ni mda mda nikani kwati jiebti arato nitre ja töitikaka benbe. Niara abko nämane näin käne angwane, ni nämane iti abko kädian nämane Bartimeo (ne abko Timeo ngobo nieta) abko okwä kä drünente, aisete nämane täkänintbe jibtä ngwian kärere jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesu Nazarebo jatani ta gani kwe angwane, namani ngrente ja dibti krörö jite yete Jesuye: ¡Jesu, jrei David tukwe mräkä, ti ngwen ruentari tare jae! namani niere jite. ");
INSERT INTO gymNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ni kwati namani kada ketamna ie akwa, niara namani ngwänenkä bäri krikri mda, kä namani niere: ¡Jrei David tukwe mräkä, ti ngwen ruentari tare jae! namani niere bäri mda kore. ");
INSERT INTO gymNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Abtä Jesu namani nünaninkä käkwe niebare: Ni ye kärere munkwe, niebare kwe. Erere ni mdakwe niebare ni okwä kä ikote yeye: Jesuta ma kärere, aisete kä ngwen nuäre jabtä. Näin krö. Brän jötrö känti, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ye btäräbe, ni okwä kä drünente ye käkwe ja täkäninte käinta, tö namani näin jötrö, aisete dän nga ötati kitani temen kwe, bti nikani nebe Jesu ken. ");
INSERT INTO gymNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Angwane Jesukwe niebare ie: Tikwe dre nuendre makrä, ie ma tö nibi, niebare kwe ie. Ni ye käkwe niebare mda Jesuye: Ti Dänkien, kä rabadre tuen tie, ie ti tö nibi, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesukwe niebare mda ie: Ma nibi tödeke kwatibe Ngöböbti, ye köböire ma okwä nibirate kuin, aisete nänta, niebare Jesukwe ie. Ye btäräbe kä namani tuen kuin jökrä ie, bti nikani siba Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Bti Jesu btä nitre ja töitikaka ben nükanina ja ken Jerusalén angwane, ni namani juta Betania amne juta Betfagé känti Ngitio Olibobtä. Ye känti, Jesukwe nitre ja töitikaka ben juani nibu, ");
INSERT INTO gymNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","käkwe niebare ietre: Juta tuen känime ni ngware ta. Se känti mun nän. Mun raba yete angwane, buro ngäbäli näkwita ngämi kwan mäkäninte munye, ye tikate munkwe, bti mun jata ngwena tie. ");
INSERT INTO gymNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Akwa ¿Ñobtä munta tikete? nie munye angwane, munkwe nie krörö ietre: Ni Dänkien tö nibi ie, aisete nun bike niken ngwena, akwa gwängwarbe juandita kwe munkrä, munkwe nie kore, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Erere nikanintre angwane, buro nämane mäkäninte jukwebtä jite, btä namanintre abko tikaninte kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abtä ni ruäre nämane yete käkwe ñäkäbare krörö ietre: ¿Munta dre nuene yete amarebti yere? ¿Nirekwe buro ye tikatemna munye, amarebti munta tikete yere? niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesukwe ño niemnabare ietre, erere niebare kwetre, aisete buro tuanimetre ngwiandre ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nikanintre buro ngwena, nükani nebe Jesu känti angwane, dän jakwe mikani ötati buro ngäbäli ye tröbti kwetre ja täkräre Jesuye, bti Jesu nakwani buro yebti, bti nikani mda Jerusalén. ");
INSERT INTO gymNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ye ngwane ni kwati namani Jesu ngibiare jite, käkwe dän jakwe metaninte ji ngrabare temen dikakakrä Jesuye. Ni ruäre abko käkwe kriküde tikaninkä Jerusalén bäre temen abko namani mike ji ngrabare temen dikakakrä Jesuye kakäre ngäbti jrei kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Angwane nitre nämane näin ruäre Jesu känenkri amne ruäre abko nämane näin Jesu jiebti, ye abko namani ngrente ja dibti, kä namani niere krörö: ¡Hosana! ¡Ari Ngöbö käikitekä gwaire jökrä! Ni ne kite ni Dänkien Ngöbö käbti. Ma ye aibe raba mikani ütiäte. ");
INSERT INTO gymNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ni mräkä jrei David nämane gobrane kira, ye kwrere Ngöbökwe ni ne mikadi gobrane ni ngätäite nete. ¡Hosana! ¡Ari Ngöbö kri kä käinbti käikitekä bäri krikri! abko namani ñäke kore Jesu ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu namani Jerusalén angwane, nikani ju blitakrä Ngöböbe känti angwane, mikani ñäräre kuin jökrä bäre ta kwe, bti kä jatanina dere, aisete nikaninta nitre ja töitikaka ni jätäbti nibu yebe nebebe juta Betania kibiakäre yete. ");
INSERT INTO gymNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Abti jändrinane Jesu nämane Betania, nikaninta Jerusalén angwane, mrö namani ie, ");
INSERT INTO gymNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","nikrabare kwe angwane, higokrie abko kä namani tuen mobe ie se kwrere. Higokrie ye abko ngwä nämanena, namani nütüre, aisete nikani mike ñäräre btä. Namani känti angwane, higokrie ye ngwä rabadre abko käi ngämi, aisete ngwä ñakare btä angwane, kä aibe kabre btä. ");
INSERT INTO gymNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Abtä Jesukwe ñäkäbare tare higokrie yeye: Ma ñan ngwä raba jire mda kwetadre ni mdaye, niebare kwe higokrie yeye nitre ja töitikaka ben okwäbti. Bti nikaninta janknu ji ngrabare Jerusalén. ");
INSERT INTO gymNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nükani Jerusalén angwane, nikanintre nebe ju blitakrä Ngöböbe känti. Ju bäre temen nitre nämane jändrän rürümoine yete amne ruäre abko nämane jändrän kökö abko Jesukwe juanintari jökrä mento. Erere arato, nitre nämane ngwian kwite ni mda mdakrä abko kän Jesukwe mesa kwitaninkä temen se kwrere amne ütü rürümoinkä kwe ja täkrä nämane, ye abko Jesukwe kwitaninkä jökrä temen se kwrere arato. ");
INSERT INTO gymNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Bti nire nire tö namani jändrän ngwiain ju blitakrä Ngöböbe känti, ye abko Jesu ñan namani tuemetre nüke jire chi kä ye känti, kä ngibiakäre deme Ngöbökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yebti Jesu nikani dirire krörö mda nitre ju blitakrä Ngöböbe dänkientre rüere, käkwe niebare: Ngöbö Kukwei tä tikani krörö: Ju tikwe ne abra tä blitakrä tibe nitre nünanka kä jökräbti kräke, nieta Ngöbökwe ja Kukweibtä. Akwa mun abko tä ju blitakrä Ngöböbe ne mike nitre gokä jue kwrere. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesu namani dirire bä jene abko namani tuen kuin ni jökräye, aisete ñan töi namani krütare Jesu kukweibtä. Ye mden kisete Jesu jürä namani nitre blitaka Ngöböbe ni mda mda diäre dänkientre yebtä amne Kukwe Biani Ngöbökwe Moiséye dirikätre, yebtä Jesu jürä namani arato, aisete namani ji känene jae Jesu kämikakäre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yebti kä jatani dere angwane, Jesu btä nitre ja töitikaka ben nikaninta juta Jerusalén bäre mentokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yebti jändrinane Jesu nikaninta dekä angwane, higokrie ngwä ñakare, ye namanina nötare jökrä nükebe dobote temen. ");
INSERT INTO gymNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Higokrie, ie Jesukwe ñäkäbare nitre ja töitikaka ben okwäbti ye nükaninta töreta Pedroye, käkwe niebare Jesuye: ¡Jo! Dirikä, higokrie ie makwe ñäkäba jändrin, ye nibira nötare jökrä nükebe dobote temen tuen, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Abtä Jesukwe niebare mda ietre: Ngöbö di tärä jändrän jire jökrä nuenkrä, yebti munkwe tödeka kwatibe, ye ngwane mun rabadre kukwe nuene jire jökrä ti kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ti bike kukwe era erere niere munye abko krörö: Nirekwe niedre ngitio nokoye: Ja denkä mento yete. Ma rika mrente, niedre kwe ngitio nokoye, tödekare kwärä Ngöböbti amne Ngöbö di tärä sribi ye nuendre, ye munkwe mikadre ngwarbe ñakare jae angwane, mun rabadre ñäke kore ngitioye angwane, ye erere rabadre bare munye. ");
INSERT INTO gymNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ne aisete, dre dre munkwe kärädre Ngöböye, erere biandi kwe munye, bti munkwe tödekadre kwatibe kore, ne ngwane Ngöbökwe biandi munye. ");
INSERT INTO gymNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mdakäre abko, mun rika blite Ngöböbe angwane, ni mdakwe kukwe nuenbare blo munbtä, ye töre käre munye btä mun moto romon kräke, ye ngwane kukwe ye käikwitaka jabti munkwe angwane, mun Rün kä käinbti käkwe mun ngite niara rüere ye diandrekä jire jökrä munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Akwa ni mdakwe kukwe nuenbare blo munbtä, ye töre käre munye, btä mun moto romon kräke, ye munkwe ñan käikwitadrekä jabti angwane, mun Rün kä käinbti käkwe mun ngite niara rüere ye ñan diandrekä munbtä arato. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yebti Jesu nikani janknu nebe Jerusalén. Nikani dikekä ju blitakrä Ngöböbe bäre temen angwane, ni blitaka Ngöböbe ni mda mda diäre dänkientre btä Kukwe Biani Ngöbökwe Moiséye dirikätre, arato nitre unbre ji dokwäte käkwe krötabare Jesu ken, ");
INSERT INTO gymNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","käkwe niebare ie: ¿Nirekwe ma mikani sribi nuene kore amne nire diebti mata kukwe nuene kore nete? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Angwane Jesukwe niebare mda ietre: Ti bike kukwe ngwentari kwati arato munye. ¿Nirekwe Juan Bautista juani ni ngökö ñöte? ¿Ngöbökwe juani ya o ni kä nebtäkwe mikani sribire ya? Ye niere tie munkwe. Nirekwe juani, ye munkwe niedi tie ne ngwane, nire diebti tita sribi ne nuene abko tikwe niedi munye arato, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yebtä abko nikani blite jabe kwärikwäri, kä namani niere krörö: Ngöbökwe juani nikwe niedre ie angwane, niarakwe niedre krörö mda: Ngöbökwe juani munta niere, ¿se ñobtä abko munkwe ñan kukwei mikani era jae? niedre kwe nie. ");
INSERT INTO gymNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Akwa, ni kä nebtäkwe mikani, ni ñan rabadre niere jire chi ie, aisete nikwe ño niedre ie ruen, namanintre niere kore jae kwärikwäri. Niaratre käkwe blitabare kore, ñobtä ñan angwane Juan abko ni Ngöbö kukwei niekä era metre ni jökrä nämane mike era. Mden kisete ni mdakwe juani niedre kwetre angwane, ni jökrä rabadre ja rüere ben abko jürä namani btä, aisete ño niedre kwetre ñan namani nüke gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Abtä niebare krörö kwetre Jesuye: Nirekwe Juan juani, ye gare ñakare nunye, niebare kwetre. Angwane Jesukwe niebare mda ietre: Kore ne ngwane, nirekwe ja di biani tie sribi ne nuenkäre abko tikwe ñan niedre munye arato. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yebti Jesu nikani kukwe bä mike krörö mda ietre: Bati ni nämane iti, käkwe uba nurai nökani, bti ki mikani kwe amne kä ükaninte biare uba ñöi ngwäre kwe. Ju mikani nura ngibiabtikä kräke kwe, bti biani kwe ni mda mdaye sribikrä. Kä biani sribikrä kwe abko ütiäre uba döi biandreta ruäre ie. Yebti nikani kä mdabti. ");
INSERT INTO gymNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Abti uba ngwä ötadre abko käi nükani angwane, sribikä käkwe uba biandreta ruäre kä bkänkäye ye abko kä bkänkä käkwe sribikä kwe juani iti tuenta jakrä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Akwa ni juani kä bkänkäkwe ye nikani nebe angwane, sribikätre ubabtä ye ie neketaninte, nikani mete ja ñäte kwäräkwärä se kwrere, bti juanintarita kwetre. Nin uba döi biani jire chi kwetre kä ütiäre, bti juanintarita kise tökare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Yebti kä bkänkä käkwe sribikä mdara jire juani uba tuenta ruäre jakrä akwa, ni ye neketaninte sribikäye, metani jökrä dokwäkäte kwetre, bti ñäkäbare diän kwetre ie, bti nikaninta ngwarbe arato. ");
INSERT INTO gymNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Yebti abko, kä bkänkä käkwe sribikä mdara jire juani abko müre ketani sribikätrekwe ja ñäte arato. Abtä niarakwe sribikä mda mda juani kwati mda uba döi tuen jae kä ütiäre, akwa neketaninte sribikätreye, nikani kwata mete kwäräkwärä se kwrere, ruäre abko müre ketani kwetre, akwa nin uba döi biani jire kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Abtä mrä angwane, ni kä bkänkä, ie ni namanina itibe juandre uba döi tuen jakrä. Ye abko odei itibe tare kri kwe aibe namani ie. Namani nütüre: Ti odei ne aibe abko mikadi ütiäte sribikätrekwe, aisete ti bike juen, namani nütüre. Erere juani kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Akwa kä bkänkä odei nikani ngitiekä rün käite angwane, sribikätre ye käkwe niebare jae kwärikwäri: Ni se abko rabadi jändrän rünkwe bkäne jökrä, aisete ari kämike amne ni rabadi kä ne bkäne jökrä, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ye erere bkänä, ni kä bkänkä odei itibe ye neketaninte sribikätreye, müre ketani kwetre, bti ngwäkä kitaninkä kä ye bäre mento kwetre. Ne ngörä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Ne ngwane, uba bkänkä käkwe dre nuendre sribikätre käme yebtä raba ruen munye? Niara rikadre, käkwe sribikätre ye kämikadre jökrä, bti uba grä ye biandre ni mda mdaye kwe sribikrä. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Bti Jesukwe ja bä mikani jä kwrere amne nitre dirikä krikri abko bä mikani ju mikaka kwrere, käkwe niebare ietre: Ngöbö Kukwei käta niere krörö gare munye, raba ruen tie: Jä ütiäte kri ju mikakrä metre abko nitre ju mikaka käkwe kitaninkä, akwa jä ye abko ni Dänkien käkwe mikani bäri ütiäte ju mikakrä metre. Ye abko namani tuen bäri nuäre nie, abko nieta kore Ngöbö Kukweibtä, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesukwe kukwe bä mikani, ye abko nitre dänkien krikri btä dirikätre krikri yebtä matani tare, ñobtä ñan angwane Jesukwe niaratre bä mikani sribikätre käme ye kwrere abko gani kwetre jabtä. Abtä tö namani Jesu kitai ngite, akwa ni mda mda jürä namani btä, aisete kä mikaninkä Jesubtä yete kwetre, nikaninta mentokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Abti Jesukwe ñäkädre blo emperador César rüere abtä kitadre ngise, ye abko nitre dirikä krikri btä nitre dänkin krikri tö namani, abkokäre nitre bariseo btä nitre reketaka jrei Herodekri juani kwetre ja gaen Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Erere nikanintre, namani Jesu känti angwane, niebare kwetre ie: Dirikä, mata kukwe era erere niere, ye gare kuin nunye. Ni mda mda tä ño niere ma rüere diribtä kore, ye abko ñakare ütiäte makrä, ñobtä ñan angwane ñan mata blite ni mda mda moto mikakäre nuäre, akwa ji Ngöbökwe abko dirita era metre makwe, ye garera nie. ¿Akwa emperador romanobo César abko ie nunkwe ja ütiä biandre ye abko dbe ya, ñakare ya niere nunye? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Akwa namanintre bike moto kuin abko ganina btätre Jesukwe. Abtä niebare mda kwe ietre: ¿Se ñobtä tikwe ja dokwä mikadre kö okwäte au, abkokäre mun kite kukwe ngwentari kore tie ye? Ngwianta munkwe, ye ngwen kunti tuadre tie, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ye erere bkänä, ngwian denario biani kwetre Jesuye angwane, Jesukwe niebare mda ietre: ¿Nire bä amne nire käi tä tikani ngwian nebtä? niebare kwe. Niaratrekwe niebare mda: Emperador César bä amne käi tä btä, niebare kore kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Abtä Jesukwe niebare mda ietre: Jändrän emperadorekwe erere munkwe bian emperadoreye amne jändrän Ngöbökrä erere munkwe bian Ngöböye. Abko kore se, niebare kwe. Ye kwrere Jesukwe ja kitani ngite ñakare Ngöbö rüere amne César rüere, akwa kukwe niebare kwe abko bäri nuäre btä bäri metre aisete, nitre bariseo btä nitre reketaka Herodekri ñan töi namani krütare Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yebti nitre saduseo nikani ruäre ja tuakäre Jesube. Nitre saduseo ye abko ni krütanikrütani mikadreta nire Ngöbökwe abko ñan nämane mike era, aisete jatani kukwe ngwentari Jesuye, käkwe niebare ie: ");
INSERT INTO gymNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Dirikä, Ngöbökwe tikamna krörö täräbtä nunkrä Moiséye: Ni iti tädre gure, akwa ngäbäkre ñakare kwetre amne ni ye krütadre angwane, merire rabadre kaibe. Meri ye abko yäräkwe diandre jae mda. Yebti ngäbäkre rabadre kwetre angwane, ngäbäkre ye abko rabadre niara etba krütani ngobo kwrere abko tikani täräbtä Moisékwe nunkrä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ne aisete bati nitre ja etbarebe nämane ni kükü. Nitre ye etba mubai käkwe ja mikani gure, akwa ngäbäkre ngämi nebe kwetre angwane, ni ye krütani. ");
INSERT INTO gymNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Merire namani ie abko namani yärä mda yebe, akwa nin ngämi ngäbäkrei ngibiare angwane, brare krütani kän arato. Meri ye namaninta kaibe bobukäre. Namani yärä mdara jire ben, akwa nin ngämi ngäbäkrei ngibiare angwane, krütani kän arato. ");
INSERT INTO gymNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ye kwrere nikani nakenkä janknu ja täritäri. Abti nitre ni kükü ye krütani jökrä meri ye kisete, akwa nin ngäbäkrei ngibiabare jire iti kwe. Abti mrä meri ye krütani abko kukwe nakaninkä kore nieta. ");
INSERT INTO gymNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Akwa ni krütani rükadreta nire mata niere, aisete ni brare ni kükü ben meri ye namani jökrä, abti niaratre ni kükü ye rükadreta nire jökrä angwane, meri ye rabadi nire nän mukore abko niere nunye, niebare kore nitre saduseokwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesukwe niebare mda ietre: ¿Ngöbö Kukwei gare ñakare munye amne Ngöbö di kri gare ñakare munye arato, aisete munta töbike ngwarbe blo kore ñan ñan? ");
INSERT INTO gymNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tita niere kore, ñobtä ñan angwane ni krütanikrütani rükadita nire angwane, ni merire, brare käkwe ñan ja mikadre gure, ñobtä ñan angwane niaratre abko rabadi angele kä käinbti kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mdakäre abko, ni krütanikrütani rükadreta nire abko btä ti tö nibi kukwe nie munye. Kira, kri chi namani jutra ngitiekä, te Ngöbökwe blitabare Moisébe: Ti abko Ngöbö Abrahamkwe, Isaakwe amne Jacobokwe, niebare kwe Moiséye abko btä mun tärä ñäke. ");
INSERT INTO gymNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ye abko, Abraham, Isaac amne Jacob krütanina abti Ngöbökwe niebare kore Moiséye. Ngöbö abko ñan ni ngwäkäre Ngöböi akwa Ngöbö abko ni nire Ngöböi gare nie. Ye aisete Abraham, Isaac amne Jacob tä nüne janknu Ngöbö ngwärekri abko gare nie. Abko kore se, niebare Jesukwe nitre saduseoye. ");
INSERT INTO gymNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nitre saduseokwe kukwe ngwianintari Jesuye abko, btä Jesu nämane blite angwane, Kukwe Biani Ngöbökwe Moiséye dirikä nükani kukwe nuen. Jesukwe kukwe kani ngäbti kuin, Kukwe Biani Ngöbökwe Moiséye dirikä nämane iti ye okwäbti. Abtä niebare krörö kwe Jesuye: ¿Kukwe biani keta kabre Ngöbökwe Moiséye nuendre nie, ye mden abko bäri ütiäte abko nikwe mikadre täte bäri? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesukwe niebare mda ie: Kukwe bäri ütiäte mikadre täte bäri niebare Ngöbökwe Moiséye abko nieta krörö: Mun israelita olo ketete ti kukweiye munkwe. Ni Dänkien Ngöbö abko itibe. Yebti ngöbö ñakare jire mda. ");
INSERT INTO gymNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Amne ni Dänkien Ngöbö aibe tare ja üai ngöi jökrä, ja töi ngöi jökrä amne ja di ngö jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kukwe ketebu bäri ütiäte mikadre täte abko krörö: Mata ja tarere au, ye kwrere makwe ni mda mda tare arato. Ye abko, Kukwe Biani Ngöbökwe Moiséye nuendre nie bäri ütiäte nere. Nebti kukwe mda mda tärä nuendre, akwa ñakare bäri ütiäte, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Abtä Kukwe Biani Ngöbökwe Moiséye dirikä käkwe niebare mda Jesuye: Dirikä, mata kukwe era erere niere metre. Erere makwe kukwe nini, ye abra era bkänä. Ngöbö abko itibe. Nebti ngöbö ñakare jire mda ");
INSERT INTO gymNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","amne niara taredre kri. Arato niarabe taredre käre ja moto kuinbti. Arato niarabe tädre käre ni töibtä köbö kwatirekwatire. Erere arato, nikwe sribidre ja di ngöi jökrä niarakrä. Mdakäre abko, nita ja tarere ño au, ye kwrere nikwe ni mda mda taredre, nini makwe, ye abra era bkänä, aisete Ngöbö ngwärekri ye bäri ütiäte jändrän kämikata kukwakrä Ngöböye ye ngwä. Erere arato, Ngöbö ngwärekri ye bäri ütiäte jändrän jökrä bianta Ngöböye ye ngwä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kukwe Biani Ngöbökwe Moiséye dirikä ye käkwe Jesu kukwe kani ngäbti kuin dikaro namani tuen Jesuye. Abtä niebare mda kwe ie: Ngöbö kebera nüke gobrane mabtä, nibi tuen tie, niebare Jesukwe ie. Yebti nitre dirikä krikri, ie nin ja nükani töre mda kukwe ngwentari mda ja gakrä Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yebti ju blitakrä Ngöböbe ye bäre temen Jesu nämane dirire angwane, niebare kwe ni kwatiye: Ni Dianinkä Ngöbökwe abko däredre jrei David tukwekri nieta abko Kukwe Biani Ngöbökwe Moiséye dirikätre käta niere. Ye ñobtä abko munta niere kore abko ti tö ngwiaintari. ");
INSERT INTO gymNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","¿Ye ñobtä abko Ngöbö Üai Deme köböire Davikwe “ti Dänkien” niebare Ni Dianinkä Ngöbökwe yebtä? Ni ngätäite nete ni ñakare jire iti käta “ti dänkien” niere ngäbäkre kweye, akwa David abko käkwe niebare krörö: Ti Dänkien Ngöbö käkwe nieba ti Dänkienye: Kä bäri ütiäte kri ti küde ruenkri, ne känti jakwe täke nete. Ye känti ma raba abti tikwe ma rüe mikadi jökrä ma ngoto täni, niebare Davikwe Ni Dianinkä Ngöbökwe yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David ara jire käkwe ja Dänkien niebare Ni Dianinkä Ngöbökwebtä. ¿Se ñobtä abko Ni Dianinkä Ngöbökwe abko jatadre Davikri nieta munkwe se, ñobtä ñan angwane nita “Dänkien” niere ñakare jire ni mräkä bäri mrä nikrä yeye? niebare Jesukwe. Jesukwe diribare kore, ye ni nämane kwati olote namani ngitie nuäre, aisete kä namani nuäre btä Jesu kukwei nuare. ");
INSERT INTO gymNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu nämane dirire angwane niebare kwe: Kukwe Biani Ngöbökwe Moiséye dirikätre, ye ngäniene munkwe ja ngibia kuin, ñobtä ñan angwane niaratre tä dän nga ütiäte kri kite jabtä, bti ni jökrä käkwe köbö ngwiandretari käne ietre kä jändrän rürümoinkrä ye käntita temen, ie töta nebe. ");
INSERT INTO gymNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Erere arato, ja täkrä ni ütiäte ütiäte kräke sinagogate, känti töta nebe rabai täkänintbe amne ja täkrä ni ütiäte ütiäte kräke, känti tätre nebe täkänintbe. Erere arato, niaratre nübaita bietabtä angwane, ja täkrä ni ütiäte ütiäte kräke, känti tö täkäi temen. ");
INSERT INTO gymNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Erere arato, meri kän brare krütani abko kän tätre ju denkä, abti tätre bike kuin, käta blite raire Ngöböbe, akwa yebtä Ngöbökwe mikadi ja tare nike krübäte, aisete munkwe ja ngibia kuin Kukwe Biani Ngöbökwe Moiséye dirikätre ngäniene. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yebti ju blitakrä Ngöböbe bäre temen jändrän dätebare ngwian ükakrökrä nämane mikani ngwian biandre Ngöbökrä ngwäre, ye känti Jesu nikani, namani täkänintbe. Angwane ni kwati namani nüke ngwian kite jändrän ngwian ükakrökräte. Erere arato, ni ngwian bkänkä kabrekabre namani nüke kwati, namani ngwian kite kabre yete okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Te batibe meri bobre kän brare krütani abko jatani, käkwe ngwian sentabo kwrere kitani kubube arato kajate Ngöbökrä Jesu okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Angwane Jesukwe nitre ja töitikaka ben käräbare, bti niebare kwe mda ietre: Ti bike kukwe era erere niere munye abko krörö: Meri bobre kän brare krütani se käkwe ngwian bini bäri kabre ni ngwian bkäne krikri käkwe ngwian kiti kajate Ngöbökrä se ngwä, ");
INSERT INTO gymNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ñobtä ñan angwane niaratre käta ngwian namaninte ie aibe bien, akwa meri bobre ye abko käkwe ngwian ngörä nünankrä kwe erere bini jökrä, aisete niarakwe ngwian bini bäri kabre. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu nämane ju blitakrä Ngöböbe käntita, jatani nikenta angwane ni iti ja töitikaka ben käkwe niebare ie: ¡Jo! Dirikä, ju krikri be bä nuäre nuäre janknu. Jä krikri ketani jabti jabti tuen, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesukwe niebare mda ie: Ju kuinkuin mun okwä nibi btä, ye abko köböitira jire ju se juandi ngwarbe jire jökrä, aisete jä ketani jabti jabti se juandi jökrä temen, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yebti Jesu nikani ju blitakrä Ngöböbe btä nakri, känti namani täkänintbe Ngitio Olibo bti käin, okwä namani ju blitakrä Ngöböbe kukwäre angwane, Pedro, Santiago, Juan btä Andrés käkwe niebare kaibe ie: ");
INSERT INTO gymNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ju blitakrä Ngöböbe juandi ngwarbe nini makwe, ¿ye abko rakadikä ñongwane nun tö gai? Arato kukwe ye rakadrekä ñongwane amne bä mikadi ño nunye abko makwe niedre nunye, ie nun tö nibi, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Abtä Jesukwe niebare mda ietre: Bäri käne abko, nitre ni ngökaka ye ngäniene munkwe ja ngibia kuin, ");
INSERT INTO gymNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ñobtä ñan angwane ni jatadi kwati ti käbti käkwe niedi krörö: Ti abko Ni Dianinkä Ngöbökwe ara tä nete, niedi kwetre, ye käkwe ni kwati ngökadi. ");
INSERT INTO gymNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mdakäre abko, munkwe kukwe krörö gadi: nitre tädi rüre jabe kwärikwäri nete sete abko gadi munkwe angwane mun ñan rekwetaka, ñobtä ñan angwane kukwe ye rakadikä kore abko erere rabadi nakenkä. Akwa ye ngwane kä mrä ngämi nüke abko raba gare munye, ");
INSERT INTO gymNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ñobtä ñan angwane juta kwatirekwatire rabadi rüre jabe kwärikwäri amne nitre nünanka kä ketareketare te rabadi rüre jabe kwärikwäri. Erere arato, dobo rabadi nakaenkä kä ketareketare temen kwäräkwärä amne ni kwati rabadi mrö nike krübäte arato. Akwa ye ngwane abko ja tare nika jatadi krire kena kä nebtä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Bti Jesukwe niebareta mda nitre ja töitikaka benye: Munkwe ñan dikaka okwä kware mun rüe ngätäite, ñobtä ñan angwane nitre israelita käkwe mun kitadi ngise sinagoga yete nitre kritoboreye. Ne känti mun kwata metadi kwetre. Erere arato, jrei kri amne gobran kri ñakare israelita, ye ngwärekri mun jänäin ngite tödekabtä tibti, akwa ye ngwane abko tikwe dre dre nuenbare abko kräke kä rabadi kuin munye blitakäre tibtä nitre ye ngwärekri, abkokäre mun jänäin ngite. ");
INSERT INTO gymNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Angwane kä ne ngämi niken ta, känenkri kukwe kuin tibtä, ye rabadi diribare ni kä jökräbtiye angwane batibe ti jatadita. ");
INSERT INTO gymNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Akwa mun järikadi ngite nitre kritobore ngwärekri angwane, munkwe dre niedi ja kriere, yebtä munkwe ñan töbika, ñobtä ñan angwane Ngöbö Üai Deme tädi munbe. Mden kisete munkwe ño niedre, ye niarakwe mikadi gare munye, erere munkwe nie ja kriere. ");
INSERT INTO gymNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","13","Kukwe ye rakadikä kore munbtä, ñobtä ñan angwane ni kwati mätä rabadi tibtä abko mätä rabadi munbtä tödekabtä tibti arato. Aisete ni tödekaka tibti abko etba kwe käkwe kitadi ngise müre ketadre; ngäbäkre tödekaka tibti abko rün kwe käkwe kitadi ngise müre ketadre tödekabtä tibti. Erere arato, ngäbäkrekwe rün kwe kitadi ngise müre ketadre tödekabtä tibti abko rabadi nakenkä kore ja täritäri nitre tödekabtä tibti yebtä; akwa nire nire tä nüne angwane, ti ñan rükandite ni jökrä ngwärekri kwe, ni ye abko tikwe dianditari. ");
INSERT INTO gymNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yebti Jesukwe niebareta mda ietre: Ti bike kukwe niere, btä munkwe töbikadre kri abko krörö: Ni iti ngwarbe käme käkwe jändrän deme Ngöbökwe mikadi ngwarbe jae, btä Ngöbö mätä jatadi tikani Danielikwe abko kä nin te rabadre abko te rabadi. Ni ye kwrere rüka mun okwäbti, ye ngwane abko mun tädre Judeate ye abko gitia mintokwäre. ");
INSERT INTO gymNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Amne mun mden mden tädre jubti käin ye abko ñan rika jändrän tuenta jire chi gwi jae amne mun gitia jirekäbe; ");
INSERT INTO gymNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","amne mun mden mden tädre sribire tirete ye abko ñan rika dän tuenta jire chi gwi jae, akwa mun gitia gwängwarbe jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Akwa meri doboko doboko amne meri kwe ngäbäkre kiakia kianbtä, ye abko bobre jakän, ñobtä ñan angwane niaratre ñan raba ngitie jötrö. ");
INSERT INTO gymNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Akwa mun gitiadre ye abko ñan rakadrekä kä ñüre näire abko munkwe ribe Ngöböye, ñobtä ñan angwane tare näin jötrö kä ñüre näire aisete. ");
INSERT INTO gymNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Munkwe ribe kore Ngöböye, ñobtä ñan angwane Ngöbökwe kä dätebare kena angwane ni kä nebtä ngämi ja tare nike krübäte dikaro abti kä nüke mtare abko erere ja tare nikadi kri krübäte kä ye ngwane. Yebti ñan ja tare nikadreta mda ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ye abko, Ngöbökwe ñan köbö krötadre jötrö käne ja tare nikakrä, ye ngwane ni ñan rabadre dianintari jire iti, akwa ni dianinkä jakrä Ngöbökwe abko Ngöböta tarere, aisete köbö ja tare nikakrä krötadi jötrö kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ne aisete, kä ye ngwane kukwe raba nakenkä kore angwane, nane ni mdakwe niedre krörö munye: ¡Ni Dianinkä Ngöbökwe abko tä nete tuen! niedi kwe, o ¡Ni Dianinkä Ngöbökwe tä sete tuen! niedre kwe, akwa munkwe ñan kukwei mika era, ");
INSERT INTO gymNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ñobtä ñan angwane kä ye ngwane ni kwati jatadi ja bä mike Ni Dianinkä Ngöbökwe kwrere amne ni kwati jatadi ja bä mike ni Ngöbö kukwei niekä kwrere. Niaratre käkwe sribi krikri ñan tuabare nuendi kabre bätäkä ngwarbe ni mda mda ngökakäre amne rabadre ni dianinkä jen jakrä Ngöbökwe ara jire ngökö, ne ngwane ngökadre kwetre, akwa ñan rabadi ngökö. ");
INSERT INTO gymNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ne aisete kukwe ye ngämi nakenkä, känenkri tita mun mike mokre biare, abtä munkwe ñan dikadrekä okwä kware, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesukwe niebareta ietre: Ja tare nikadi kri nini tikwe, yebti ñänä se rötadite amne kä rabadi iko jökrä. Erere arato, sö se ñan trä rabadre mda ");
INSERT INTO gymNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","amne muke käinta se abko rabadi betekä timontimon amne jändrän kä käinbti se abko rabadi grükekä arato. ");
INSERT INTO gymNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ye angwane, ti Ni Kä Nebtä Ngobo abko jatadi tuen ja di kri bä nuärebti mütabti kä käinbti sete abko ni jökrä käkwe tuadi. ");
INSERT INTO gymNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Angwane tikwe angeletre juandi, käkwe ni dianinkä jen jakrä ükadikrö jökrä ketetibe. Ni dianinkä jen jakrä nünanka nindrini, kä driri, sekri, nekri abko ükadikrö jökrä kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Bti Jesukwe niebareta mda: Mdakäre abko, higokrie btä kukweta nakenkä ño, yebtä munkwe ja töitika abko krörö: Higo küdeta niren mräre mda amne käta nebe mräre btä arato angwane, kä töre tärä kite nüke ja ken abko munta gaen, ");
INSERT INTO gymNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ye kwrere arato kukwe nini tikwe ye jata nakenkä jökrä mun okwäbti angwane, ti Ni Kä Nebtä Ngobo nükerate ja ken jukwebtä abko rabara gare munye. ");
INSERT INTO gymNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ti bike kukwe era erere niere munye abko krörö: Nitre nünanka kä nebtä ngämi krüte jökrä, ye känenkri kukwe nini tikwe ye erere rakadikä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mdakäre abko, kä käinta se btä kä temen ne abko Ngöbökwe gadikä jökrä, angwane rikadi ta, akwa ti kukwei abko rabadi kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Akwa ti jatadreta köbö mdente amne ñänä okwä nuäi ti jatadreta ye abko gare ñakare jire chi ni mda mdaye, angele kä käinbti ie gare ñakare amne Ngöbö Odei ie gare ñakare arato, akwa Ngöbö ni Rün aibe ie tä gare kaibe. ");
INSERT INTO gymNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ye kwrere arato, ti jatadita ñongwane gare ñakare munye. Mden kisete, munkwe ja mika juto käre ti ngibiare ngäbti amne munkwe blita käre Ngöböbe, ");
INSERT INTO gymNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ñobtä ñan angwane ti näinta, bti ti jatadita, ye abko rakadikä ño ti bike bä mike krörö munye: Ni iti jatani yäke mente kä mdabti käkwe sribikä kwekwe mikaninte ju ngibiare jakrä, bti sribi biani jene jene kwe ietre angwane, jukwe ngibiaka abko ie ju ngibiamna kuin kwe jakrä. Ni ye namani niara ngibiare ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ye kwrere abko, ti ju bkänkä kwrere käta mun mikete, aisete munkwe mokre jabti ti ngibiakäre ngäbti, ñobtä ñan angwane mun Dänkien ju bkänkä rükadita dere ya, kä ruäre ya, kä ngwen ja ken dekä ya o kä ngwenbti dekä ya, ñongwane abko gare ñakare jire chi munye. ");
INSERT INTO gymNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ye mden kisete, nane batibe ti jatadreta ñongwane abko, ie mun kwan jäme ngwarbe, mden känenkri munkwe ti ngibia ngäbti käre. ");
INSERT INTO gymNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Munkwe ti ngibia ngäbti tita niere munye, ye ñan mun aibeye tita niere amne ni jökrä käkwe ti ngibiadre ngäbti abkokäre tita niere munye. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yebti Pascua köböi namanina köböbube. Pascua köböi angwane abko bieta Te Lebadura Ñakare Bante kweta nämane Ngöbö mikakäre ütiäte nämane bämän krati angwane, ye känenkri ni blitaka Ngöböbe ni mda mda diäre dänkientre btä Kukwe Biani Ngöbökwe Moiséye dirikätre abko käkwe Jesu kadre ngite müre ketadre ño tiebe abko namanintre ngibiaretari kisere. ");
INSERT INTO gymNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Akwa nane ni kwati krübäte nämane Jerusalén Pascua köböikrä käkwe rüdre bentre Jesu dokwäre, aisete Pascua näire ñan nuendre, niaratre namani niere. ");
INSERT INTO gymNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kä ye ngwane abko, Jesu nämane Betaniate täkänintbe mesabtä mröre ni kädian nämane Simón känti. Jesu ngämi Simón ye miketa kuinta, känenkri kädian nämane lebroso arato abko känti Jesu nämane. Angwane batibe meri nükani iti ñö rä bäne ütiäte kri kädian nämane nardo ngwena jä bä ngwen kädianta alabastro dätebare boteare te. Nardo ye abko ñan nämane mritani jire ñöbe abko meri ye jatani ngwena. Meri ye abko käkwe ñö rä bäne jue tikani, bti kekani kwe Jesu dokwäbti se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yebtä ni nämane siba gwi abko ruäre moto namani romon. Abtä namani niere jae kwärikwäri: ¿Se ñobtä meri se tä ñö rä bäne ütiäte kri iente ngwarbe se? ");
INSERT INTO gymNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ngwian ganainta bäsi kä kwati jire näre, btä ñö rä bäne se rürümoindre, bti ni bobre bobre die mikadre bä amarebti ininte ngwarbe kwe se, namanintre niere kore jae kwärikwäri meri yebtä, bti namani ngren ngren bti. ");
INSERT INTO gymNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Abtä Jesukwe niebare mda ietre: Munkwe ñan meri ne nika. ¿Se ñobtä abko mun nibi nike krübäte dikaro? Meri ne käkwe jändrän kuin nuni tikrä, ");
INSERT INTO gymNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ñobtä ñan angwane nitre bobre bobre tädi käre mun ngätäite nete, ye abko mun tö rabadre die mikai ñongwane, erere munkwe die mikadre; akwa ti abko ñan tädi kärekäre munbe nete. ");
INSERT INTO gymNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ne aisete jändrän kuin rabadre bare tikrä meri neye, erere nuni kwe tikrä, ñobtä ñan angwane ñö rä bäne kiri kwe ti ngrabare, yebti abko ti miri juto biare kwe doboi mikadre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ye abko, ti bike kukwe era erere niere munye abko krörö: Kukwe kuin tibtä ye kädriedi mdente mdente erere, ye känti meri ne käkwe jändrän kuin nuni tikrä mtare ne kädriedi arato, aisete jändrän kuin nuni meri nekwe, yebtä rükadita töre. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yebti, ni blitaka Ngöböbe ni mda mda diäre dänkientre btä Kukwe Biani Ngöbökwe Moiséye dirikätre abko käkwe Jesu kadre ngite müre ketadre ño tiebe abko namanintre ngibiaretari kisere. Ye ngwane ni ni jätäbti nibu ja töitikaka Jesube abko iti kädian nämane Judas Iscariote abko nikani nitre blitaka Ngöböbe ni mda mda diäre dänkientre känti Jesu kitakäre ngise ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Judas nikani Jesu kite ngise gani kwetre angwane, kä namani nuäre btätre, käkwe ngwian bian braibare Judaye, bti Judas nikani. Ye ngwane Judas namani kä kuin ngibiare kisere jae, Jesu kitakäre ngise. ");
INSERT INTO gymNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Abti bämän krati lebadura ñakare bante kweta nämane Ngöbö mikakäre ütiäte jae, ye köböi nükaninta kena. Köbö ye näire kordero kämika nämane kwetadre Pascua köböite angwane, nitre ja töitikaka Jesube käkwe niebare ie: ¿Mrö kwetadre Bieta Pascuakrä ye abko nunkwe sribedre mdente makrä, ie ma tö nibi? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Abtä nitre nibu ja töitikaka Jesube, ie Jesukwe niebare: Mun nän juta Jerusalén sete. Ye känti ni brare tädi iti ñö ngwena kantrate abko rükadi ngätäi munbe ji ngrabare. Ni ye rika mdente gwä, känti mun rika. ");
INSERT INTO gymNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mun rika nebe gwi angwane, munkwe nie krörö ju bkänkäye: Dirikäkwe mrö Pascua köböikrä kwetadi nitre ja töitikaka benbe abkokrä käta ükaninte mdente, ngwiantarimna kwe, munkwe nie kore ie. ");
INSERT INTO gymNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Angwane ju mikani bobu jabti käin, te kä tädira ükaninte biare mrökrä, känti mun jänäin kwe. Ye känti munkwe mrö sribe biare nunkrä. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Erere bkänä, nitre nibu ja töitikaka nikani, namani jutate Jerusalén angwane, Jesukwe kukwe niebare ño ño ietre, erere kwani ietre, känti mrö sribebare kwetre kwetadre Pascuate. ");
INSERT INTO gymNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yebti kä jatanina diore dere angwane, Jesu nikani mröre mda nitre ja töitikaka benbe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nämane mröre angwane, niebare kwe ietre: Ti bike kukwe era erere niere munye abko krörö: Mun mrökä tibe ketetibe, ne ngätäite nita iti käkwe ti kitadi ngise ti rüeye gare kuin tie, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Abtä nitre ja töitikaka ben namani ulire jökrä batibe, kä namani niere itire itire ja täritäri Jesuye: ¿Tikwe nuendi ya gwari? namani ngwentari itire itire Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Abtä Jesukwe niebare mda ietre: Mun ni jätäbti nibu, ye ngätäite nita iti käta ban mike tibo gwaire tibe blato kwatibe te, ye abko käkwe ti kitadi ngise. ");
INSERT INTO gymNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Akwa ti, Ni Kä Nebtä Ngobo abko müre ketadi ño, ye tä tikani Ngöbö Kukweibtä abko erere rakadikä. ¡Akwa ni ti kitaka ngise abko ñan bobre jakän ya! Ni ye nin däredre näre abko därebare, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yebti nämane mröre jökrä angwane, Jesukwe ban diani kunti kisete, käkwe kuin niebare btä Ngöböye, bti ötaninbtä kwe, bti biani kwe nitre ja töitikaka benye, käkwe niebare ietre: Ban ne abko ti ngätä ara. Ne kaen ngäbti munkwe, bti munkwe kweta, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Bti uba döi nämane basote abko Jesukwe diani kisete, bti kuin niebare btä kwe Ngöböye, bti biani kwe ietre. Niaratre jökrä käkwe ñani, ");
INSERT INTO gymNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","bti Jesukwe niebare ietre: Uba döi ne abko ti därie tikwe ara amne Ngöbökwe kukwe ükadite btin munbe ye abko rabadi bare täte jökrä ti därie nebti. Erere arato, ti därie rimiadite ni kwati kräke. ");
INSERT INTO gymNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mdakäre abko, ti bike kukwe era erere niere munye abko krörö: Ngöböta gobrane ye känti tikwe uba döi btin ñadita, akwa ti ngämi ñaen yete, känenkri tikwe ñan ñadreta jire chi abko ti tö nibi niei munye. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yebti Jesu btä nitre ja töitikaka ben käkwe ka Salmobtä niebare ünän, bti nikanintre Ngitio Olibobti. ");
INSERT INTO gymNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Angwane Jesukwe niebare nitre ja töitikaka benye: Mun jökrä gitiadi iti iti kwäräkwärä tibtä mentokwäre gare kuin tie, ñobtä ñan angwane Ngöbö Kukwei käta niere krörö, käta ti bä mike obeja ngibiaka kwrere amne mun abko obeja tikwe kwrere: Tikwe obeja ngibiaka kämikadi angwane, obeja kwe abko gitiadi kratikrati kwäräkwärä, abko Ngöbö Kukwei tä niere kore munbtä. ");
INSERT INTO gymNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Akwa ti müre ketadi, bti ti rükadita nire angwane, ti näin mun ngäbti Galilea, känti ni rabadita ketetibe jökrä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Abtä Pedro abko käkwe niebare mda Jesuye: Ni jökrä käkwe ñan tödekadre mabti abko gitiadi, akwa ti abko ñan gitiadre jire chi mabtä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesukwe niebare mda Pedroye: Mtare deo, antlan ngämi ngwäne bobu, känenkri ma reketaka tibe abko makwe rükandite bämä jire abko ti tö nibi niei metre mae, niebare kwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Akwa Pedro abko namani ja kwete janknu Jesube, kä namani niere: Ti müre ketadre siba mabe akwa ti reketaka mabe, tikwe ñan rükandrete jire chi, Pedro namani niere. Erere ni mda mda ja töitikaka Jesube namani niere gwaire jökrä Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yebti Jesu btä nitre ja töitikaka ben nikani nebe käkä Getsemaní känti angwane, Jesukwe niebare ietre: Täke temen yete munkwe. Ti bike niken blite Ngöböbe, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yebti Pedro, Santiago btä Juan aibe ngwiani kwe jabe. Angwane Jesu moto jatani ulire amne moto namani bete krübäte ja jiebti, ");
INSERT INTO gymNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","käkwe niebare nitre ja töitikaka ben nimä yeye: Ti moto nibi ulire krübäte dikaro tie, aisete ti kebera krüte nibi ruen tie, aisete mun raba ti ngibiare nete, akwa munkwe ja ngwätei siba tibe amne munkwe ñan kibia, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ye btäräbe Jesu nikani bä mente temen se kwrere, känti namani kitanintbe ngwärere timonkwäre temen angwane, niara müre ketadre ye abko Ngöbökwe diandre niarabti ta abko btä blitabare krörö kwe Ngöböbe: ");
INSERT INTO gymNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tata tikwe, ma raba jändrän jökrä nuene, aisete tikwe ja tare nikadre, bti ti müre ketadre, ye ma tö diain ti bäre angwane, makwe dian ti bäre. Akwa ma tö dreye tikrä, ye erere raba bare tibtä amne ñan ti töi abko erere rabadre bare, niebare kwe Rün Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bti nitre mikaninte nimä kwe ja ngibiare, känti nikaninta angwane, nämane kibien kuin jökrä, btä namaninta angwane, niebare kwe Pedroye: ¿Ñänä okwä kratibe abko te kä ñan nü mae ja ngwätere blitakäre Ngöböbe ya? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bti niebareta kwe ietre: Diablu jatadi mun nuente ja käne, ye ngwane munkwe ñan ja mikadre ngite, abkokäre munkwe ja ngwäte amne munkwe blita jakrä Ngöböbe, ñobtä ñan angwane mun töi abko tä biare jändrän kuin nuene, akwa mun di ñakare, aisete munkwe blita jakrä Ngöböbe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yebti Jesu nikani bliteta bobukäre Ngöböbe angwane, ño niebare käne kwe Ngöböye, ye arabe nikani niereta ja täritäri bobukäre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yebti nitre nimä ja töitikaka Jesube, ye känti Jesu nikaninta angwane, namani kibien kuin jökrä, ñobtä ñan angwane köbö namani krübäte ietre, aisete okwä kwata namani neketekäbe jabtä köbö kisete, btä Jesu namaninta angwane, ño niedre kwetre Jesuye ñan namani nüke gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yebti Jesu nikaninta bämäkäre bliteta Ngöböbe. Blitabareta kwe Ngöböbe, bti jatani nüketa angwane, niebare kwe ietre: ¿Mun tä kibien amne mun tä jadüke janknu ya? Munkwe kibianirira dbe. Nitre kukwe kämekäme nuenkä abko kisete ti Ni Kä Nebtä Ngobo ne kitadi ngise ye abko käi nüra, ");
INSERT INTO gymNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","aisete ni ti kitaka ngise tiebe ti rüeye abko nükera tibtä, aisete näin krö, bränta, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu nämane blite kore, ye btäräbe ni ja töitikaka ben ni jätäbti nibu, ye ngätäite ni iti kädian nämane Judas Iscariote ye ara jatani nüke Jesu känti. Judas ye abko nämane näin ni kwati jie ngwena. Nitre jatani Judabe ye abko nämane näin ngitra ngwena kisete amne ruäre abko nämane näin krito ngwena kisete. Nitre ye abko nämane näin nitre blitaka Ngöböbe ni mda mda diäre dänkien käbti amne Kukwe Biani Ngöbökwe Moiséye dirikätre ye käbti amne nitre unbre ji dokwäte käbti arato. ");
INSERT INTO gymNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Angwane Judas, Jesu kitaka ngise ye abko käkwe nitre töi dianina käkwe niebare ietre: Nire demain tikwe mun okwäbti ye abko Jesu ara, aisete munkwe niara ye ka ngite. Mun rika ngwena, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ye erere bkänä, Judas jatani nüke, ye btäräbe nikani Jesu känti, käkwe niebare krörö ie: ¡Dirikä! niebare kwe. Bti Jesu demainbare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Angwane nitre jatani Jesu rüere ye käkwe krötani Jesu ken, nakwani btä, käkwe kani ngite. ");
INSERT INTO gymNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ye btäräbe ni ja töitikaka Jesube nämane iti käkwe ngitra dianinkä kwatate, bti ni klabore ni blitaka Ngöböbe ni mda mda diäre dänkienkwe ye olo tikaninkä ta kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yebti nitre nikani Jesu kaen ngite, ye ie Jesukwe niebare krörö: ¿Ñobtä abko bäsi ni gokä kri krübäte rüere ngitra jäta niken amne krito jäta niken, kwrere jire mun kite ngwena ti rüere ti kakäre ngite ye? ");
INSERT INTO gymNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Käre köbö kwatirekwatire tita dirire ju blitakrä Ngöböbe käntita temen mun ngätäite, akwa mun ñakare ti kaen ngite. Akwa dre dre rakadrekä tibtä tä tikani mekera Ngöbö Kukweibtä abko erere rabadre bare tibtä, abkokäre munta ti kaen ngite mtare, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jesukwe ñäkäbare kore, ye btäräbe nitre ja töitikaka ben käkwe kä mikaninkä batibe jökrä btä amne ngitiani iti iti kwäräkwärä amne niaratre käkwe Jesu mikaninte kaibe rüeye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jesu jänikani angwane abko, ni bati nämane näin ja mrianinte dän aibe te abko nikani siba Jesu jiebti. Ni ye gani Jesu rüekwe angwane neketaninte ietre, ");
INSERT INTO gymNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","akwa niarakwe dän jabtä tikanintbe, bti ngitiani bütiere. ");
INSERT INTO gymNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Angwane Jesu jänikani ni blitaka Ngöböbe ni mda mda diäre dänkien gwiriete. Jänamani angwane, ni blitaka ni mda mda diäre dänkientre käkwe ja ükaninkrö, btä nitre unbre ji dokwäte käkwe ja ükaninkrö. Arato Kukwe Biani Ngöbökwe Moiséye dirikätre nükani ja ükekrö bentre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jesu jänikani angwane, Pedro abko jatani bä mente temen siba Jesu jiebti. Yebti nikani nebe ju bäre ni blitaka Ngöböbe ni mda mda diäre dänkien ye känti. Pedro nikani siba ki teri angwane, guardia ju blitakrä Ngöböbe ngibiabtikä nämane täkänintbe, ye känti Pedro namani täkänintbe siba ñukwäbtä, ñukwä träse. ");
INSERT INTO gymNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre sribikä Sanedrinbe namani kukwe känene Jesu rüere Jesu kitakäre ngise müre ketadre. Akwa kukwe era erere ñan namani kwen ietre Jesu rüere, ");
INSERT INTO gymNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ñobtä ñan angwane ni kwati namani kukwe ngwarbebe niere Jesu rüere, aisete ja kukwei ñan namani nükebti gwaire jökrä ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yebtä ni ruäre käkwe kukwe känäbare ngwarbe mda Jesu kitakrä ngise bäri abko namani niere krörö: ");
INSERT INTO gymNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ju blitakrä Ngöböbe mikani ni kä nebtäkwe, se abko tikwe juandi ngwarbe jökrä, abti köbömäkäre angwane, tikwe ju mdara jire mikadita täte, akwa ñan ni kä nebtäkwe mikadi, nieba kwe nun okwäbti, niebare kwetre Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kukwe känäbare ngwarbe kwetre ni ngökakrä Jesu rüere, akwa ñan namani nükebti gwaire jökrä ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yebtä abko ni blitaka Ngöböbe ni mda mda diäre dänkien nükani dikekä krö ni jökrä ngätäite, käkwe niebare Jesuye: ¿Kukwe nie nibi ma rüere, se ño metre amarebti ma nibi kwekbe jirekäbe ye? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Akwa Jesukwe nin ñäkäbare käre, namani kwekbe jirekäbe. Abtä ni blitaka Ngöböbe ni mda mda diäre dänkien käkwe niebareta bobukäre Jesuye: ¿Ma abko Ni Dianinkä Ngöbökwe ara ya amne ma abko Ngöbö Kri Odei ara ya? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesukwe niebare mda ie: Jän. Ti abko niara ara amne kä bäri ütiäte kri Ngöbö Di Kri Jändrän Jökrä Nuenkrä ye küde ruenkri munkwe Ni Kä Nebtä Ngobo tuadi täkänintbe. Erere arato, jatadita mütabti käinta sete angwane munkwe tuadi, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Angwane ni blitaka Ngöböbe ni mda mda diäre dänkien ye moto namani romon, käkwe dän ngianinkä seeen jabtä romone, käkwe niebare krörö: ¿Tä ñäke kore, se abko ni mda mda käkwe niara kitadre ngise amne batibe ngite, nikwe niedre ya? ");
INSERT INTO gymNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ñakare, ñobtä ñan angwane niarakwe ñäri tare Ngöbö rüere, ye nunkwe kukwe nurira ñan ñan, aisete munkwe töbikadi ño mda kräke, niebare kwe. Ni jökrä käkwe niebare: Niara ngite, aisete müre ketadre, namanintre niere gwaire jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ye ngwane ni ruäre namani käli kite Jesubtä. Ni ruäre abko namani dän kukwän mäke Jesu okwäbti, bti namani mete, namani mete, bti namani niere ie: Ma Ngöbö Odei mata niere, aisete nirekwe ma miti, niere metre nunye, namani niere ie. Angwane guardia ju blitakrä Ngöböbe ngibiabtikä abko namani Jesu mete arato. ");
INSERT INTO gymNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jesu nämane gwi Sanedrin ngwärekri angwane, Pedro abko nämane ju bäre ngüsrüta temen angwane, ni merire iti sribikä ni blitaka Ngöböbe ni mda mda diäre dänkienkwe abko jatani angwane, ");
INSERT INTO gymNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro nämane täkänintbe ñukwäbtä ñukwä träse, btä meri ye okwä namani, mikani ñäräre kuin kwe, bti niebare kwe ie: Jesu Nazarebo se ben ma nämane dikekä siba arato, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Angwane Pedrokwe ja rükaninte, käkwe niebare mda ie: Ni kädianta makwe, ye gare ñakare jire chi tie, aisete mata blite drebtä, ye ñan nebe nüke gare tie, niebare kwe. Bti naninkrö, nikani jukwebtä angwane, btäräbe antlankwe ngwänänbare. ");
INSERT INTO gymNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Bä raire erere, meri sribikä ye arabe jataninta angwane, okwä namaninta Pedrobtä bobukäre angwane, namani niere ni mda mdaye: Ni noko reketaka Jesube arato se, namani niere. ");
INSERT INTO gymNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Akwa Pedrokwe ja rükaninteta. Bti bä raire erere angwane, nitre nämane yete kä namani niere Pedroye: Ma Galileabo, ñobtä ñan angwane ma blite niaratre kwrere, bä amarebti rä jire mata nekete ñakare Jesube, ma nibi niere yere, namanintre niere ie. ");
INSERT INTO gymNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Angwane Pedrokwe ja kukwei bianinta amne niarakwe ñan kukwe niedre metre ne ngwane, Ngöbökwe ngürün mikadre btä namani niere, käkwe niebare mda: Ni kädekata Jesu munkwe, ni ye abko gare ñakare jire chi tie, niebareta kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ye btäräbe antlankwe ngwänänbare bobukäre angwane, Jesukwe kukwe niebare krörö Pedroye abko nükaninta töre ie: antlan ngämi ngwäne bobu, känenkri makwe ti rükandite bämä jire, niebare Jesukwe ie, ye nükaninta töre ie angwane, niara moto nötaninte, käkwe ja müaibare kri. ");
INSERT INTO gymNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kä nükani ngwen dekä angwane, nitre sribikä Sanedrinbe amne nitre blitaka Ngöböbe ni mda mda diäre dänkientre, nitre unbre ji dokwäte btä Kukwe Biani Ngöbökwe Moiséye dirikätre käkwe ja ükaninkrö ketetibe jökrä mda, käkwe Jesu mäkätemnabare, bti jänikani ngite Pilato ngwärekri kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Angwane Pilatokwe niebare ie: ¿Ma abko jrei nitre israelitakwe bkänä ya? niebare kwe Jesuye. Jesukwe niebare mda Pilatoye: Jän. Era metre ti ara, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Angwane ni blitaka Ngöböbe ni mda mda diäre dänkientre namani kukwe niere bätäkä ngwarbe Jesu rüere kitakrä ngise. ");
INSERT INTO gymNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Abtä Pilatokwe niebareta Jesuye: Kukwe keta kabre, btä ma ngite nie nibi ma rüere. ¿Se ñobtä abko ma nibi kwekbe dikaro yere? niebareta Pilatokwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Akwa Jesu namani kwekbe janknu, nin ñäkäbare jire chi kwe Pilato käre. Jesu ñan tö namani rabai tikaninte namani tuen Pilatoye, aisete Pilato ñan töi namani krütare mda Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kä kwatirekwatire bieta Pascua näire ni ngite ngätäite nire tikadrete Pilatokwe, kärä nämane ie abko erere nämane tikete ");
INSERT INTO gymNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","abko erere ye näire ni kädian nämane Barrabás abko nämane ngite ni mda mdabe. Ni ye abko nämane ja rüere gobran romanobobe angwane, ni müre ketani kwe abtä nämane ngite. ");
INSERT INTO gymNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ye ngwane ni nükani kwati niere Pilatoye: Käre mata ni ngite tikete iti kä kwatirekwatire. Ye kwrere makwe ni ngite tikadrete iti abko nun nibi ribere mae, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatokwe niebare mda ietre: ¿Jrei nitre israelitakwe ye tikadrete tikwe abko ie mun tö nibi ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato abko käkwe niebare kore, ñobtä ñan angwane ni blitaka Ngöböbe ni mda mda diäre dänkientre namani mokrere Jesube, abtä kitani ngite kwetre abko ganina Pilatokwe btätre, aisete niebare kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Akwa ni blitaka Ngöböbe ni mda mda diäre dänkientre namani ni jökrä töi den jakri abko käkwe Barrabás tikatemna abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Akwa Pilato tö namani Jesu tikaite, käkwe niebare mda ietre: ¿Jrei nitre israelitakwe nieta munkwe, sebtä abko tikwe dre nuendre, ie mun tö nibi amarebti yere? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jötrö ngwarbe ni jökrä namani ngrente, kä namani niere Pilatoye: ¡Müre kete krusobtä! namanintre niere gwaire jökrä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Abtä Pilatokwe niebareta mda ietre: ¿Drebtä ni nekwe ja mikani ngite amarebti, mun nibi müre ketamna krusobtä tie yere? niebare Pilatokwe ietre. Yebtä namani ngrente bäri jume mda, kä namani niere: ¡Müre kete krusobtä, müre kete krusobtä! namanintre niere Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Akwa Pilato tö namani ni jökrä moto mikai nuäre, aisete Barrabás tikaninte kwe, akwa Jesu abko kwata metamna köbti kwe amne biani kwe rükä romanoboye müre ketadre krusobtä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nitre rükä nikani Jesu ngwena mda ju gobrankwe ye känti. (Kä ye abko kädian nämane pretorio). Angwane nitre rükä käkwe ja ükaninkrö jökrä ketetibe Jesu mikakäre yakrä jae, ");
INSERT INTO gymNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","käkwe dän bä tain kita nämane jabtä jreikwe, ye kwrere kitani Jesubtä, bti jrei kri käkwe korona kitadre ja dokwäbti, ye kwrere kri tukwä krübäte sribebare koronare kwetre, bti mikani Jesu dokwäbti kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yebti namanintre Jesu mike yakrä jae, kä namani niere: ¡Ma jrei nitre israelitakwe, nunta ma mike ütiäte kri mtare! namani niere kore Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Bti nikanintre Jesu mete dokwäte ta kritobti, nikani käli kite Jesubtä, bti nierare namanintre nebe ngukudokwäbti temen Jesu ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jesu mikani yakrä kore kwetre jae, bti dän bä tain drüne ye tikaninteta Jesubtä kwetre, bti dän Jesukwe ara kitaninta btä kwetre. Yebti nikanintre Jesu ngwena müre ketadre krusobtä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jesu jänikani kwetre angwane, ni iti kädian nämane Simón abko Alejandro btä Rufo rün Cirenebo nämane Jerusalén bäre, jataninante, nükani ngätäi bentre angwane, kruso btä Jesu müre ketadre abko nitre rükä romanobo käkwe Simón mikani ngwena Jesukrä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Bti nikanintre nebe käkä Gólgota känti. Kä Gólgota ye abko “Ni dokwä kroko käi” nieta abko känti nikanintre nebe Jesube. ");
INSERT INTO gymNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Angwane krikä kwaka kädianta mirra mritani uba döibe mni mni biani ñadre kwetre Jesuye, akwa Jesukwe ñan kani ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ye btäräbe nitre rükä romanobo käkwe Jesu metani krusobtä, bti tö namanintre dän Jesukwe ñäkäitbe jabti, käkwe ja gani dän yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ñänä okwä krä ökän näre dekä angwane, Jesu metani krusobtä nitre rükäkwe. ");
INSERT INTO gymNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Angwane “NI NE ABKO JREI NITRE ISRAELITAKWE,” tikani kore kri kukwänbtä metani Jesu dokwä känti käin krusobtä. Ye abko ñobtä Jesu nämane ja ngie nuen krusobtä gadre abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesu metani krusobtä angwane, nitre gokä metani nibu krusobtä käin arato niarabe gwaire. Iti mikani niara küde ruenkri amne iti mikani niara küde ngeberekri. ");
INSERT INTO gymNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ne abko nämane tikani krörö kira Ngöbö Kukweibtä, Ni kämekäme ngätäite niarakwe ja ngie nuadi siba, nämane tikani abko erere namani bare kore. ");
INSERT INTO gymNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Angwane nire nire namani kite dikekä Jesu bäre, kä namani dokwä ngrüketbe ñäkäre kwärä Jesuye, Jesu mikakäre ngwarbe jae, kä namanintre niere ie: ¡Jan jan! Ju blitakrä Ngöböbe se makwe juandi ngwarbe abti köbömäkäre makwe mikadreta täte jökrä, makwe niebare, ");
INSERT INTO gymNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","aisete ja denkä au mento krusobtä yete, bti ma jatata timon, namanintre niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ye erere arato, ni blitaka Ngöböbe ni mda mda diäre dänkientre btä Kukwe Biani Ngöbökwe Moiséye dirikätre namani Jesu mike yakrä jae, aisete namanintre niere kwrere arato jae kwärikwäri Jesubtä: Ni mda mda dianintari kwe, ¿se ñobtä abko ñan nebe ja dentari au se? ");
INSERT INTO gymNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Ni se Ni Dianinkä Ngöbökwe mikadre jrei nitre israelitakwe nieta kwe jabtä, aisete ja diandrekä au krusobtä mento kwe sete angwane, nunkwe mikadi ütiäte jae! namanintre niere kore jae kwärikwäri. Ye kwrere arato, ni nämane nibu ja tare nike krusobtä käin Jesube gwaire, ye namani Jesu mike yakrä jae siba. ");
INSERT INTO gymNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Bti ñänä nükani ruäre käin angwane, kä ngidianinte mda. Kä namani iko jökrä temen. Kä namani iko nebebe ñänä okwä krämä dere. ");
INSERT INTO gymNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ñänä okwä krämä nükani, ye btäräbe Jesukwe ngratebare kri ja dibti krörö: Eloi, Eloi, ¿lama sabactani? niebare kwe. (Ne abko: Ngöbö tikwe, Ngöbö tikwe, ¿ñobtä makwe kä mirikä tibtä jakän amarebti yere? nieta.) Abko mden niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jesukwe ñäkäbare kore, ye abko nitre ruäre nämane yete käkwe kukwe nuani angwane, namanintre niere: ¿Ñan tä ni Ngöbö kukwei niekä kira kädian nämane Elías kärere jabtä, ja die mikakäre ya? namanintre niere kore. Niebare kore kwe, ñobtä ñan angwane Jesukwe “Eloi” niebare angwane, namani ruen “Elías” kwrere ietre aisete. ");
INSERT INTO gymNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ye btäräbe, ni nämane yete, ngätäite ni nikani betekä iti, käkwe jändrän dän kukwän kwrere kä dianta esponja abko mritaninkä uba ñöi dimente, bti mäkäninte kwe nörä kräbtä, jatani ben, biani kwe ñadre tomnane Jesuye. Bti ni ye käkwe niebare: Tuemetre yete. Elías rükadi den timon krusobtä yete ni okwäbti ya, ari ngibiaretari, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Akwa Jesu abko käkwe ngratebare bäri kri ja dibti mda, btäräbe krütani. ");
INSERT INTO gymNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesu krütani, ye btäräbe dän ngutu ngetbo, bti ju blitakrä Ngöböbe nämane ñäkänintbe abko nianinkä kumu käin nükebe temen. ");
INSERT INTO gymNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesukwe ngratebare, bti krütani ño nitre rükä dänkien romanobo okwäbti. Abtä niebare mda kwe: Ni ne abko Ngöbö Odei era metre bkänä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ye ngwane, ni merire merire nämane ruäre, namani bä mente temen se kwrere okwä Jesubtä siba. Nitre merire nämane, ye ngätäite María Magdalabo nämane, btä José btä Santiago bäri bati meye María nämane, arato Salomé nämane. ");
INSERT INTO gymNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Meri ye abko, Jesu nämane nüne Galilea angwane nämane nekete ben angwane, nämane niara die mike. Ye ngwane meri mda mda nämane kwati siba abko nämane nekete Jesube, aisete nikani gwaire Jesube nebe Jerusalén. Meri ye abko nämane siba okwä Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ye ngwane abko, köbö jadükakrä känenkri, ni jökrä nämane sribi nuene biare jakrä jadüka mäträ, aisete kä jatani dere angwane, ");
INSERT INTO gymNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José Arimateabo abko ie ja nükani töre, nikani Pilato känti, käkwe Jesu ngwäkä käräbare ie. José Arimateabo abko ni ütiäte kri sribikä siba Sanedrinbe. Ni ye abko, Ngöbö rükadre gobrane ni kwe ngätäite diribare Jesukwe nämane ngibiare kisere arato, aisete nikani Jesu ngwäkä kärere Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Josékwe Jesu ngwäkä käräbare Pilatoye angwane, Pilatokwe ja ngwiani nikenkä, ñobtä ñan angwane Jesu krütani jötrö krübäte, käkwe ni rükä romanobo dänkien käräbare iti, bti Jesu krütanina bkänä abko ngwianintari kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nitre rükä dänkien käkwe Jesu krütanina bkänä niebare Pilatoye angwane, batibe Pilatokwe Jesu ngwäkä biamna Joséye. ");
INSERT INTO gymNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José käkwe dän bäri ütiäte kädianta lino kökani, bti Jesu ngwäkä krusobtä käin diani timon, mrianinte kwe dänte, bti kä muanina biare jäkwatate ni doboi mikakrä, te Jesu doboi mikani kwe, bti jä kri münaninkä kwe abko mikani kä mkä juere kwe Jesu doboibti. ");
INSERT INTO gymNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Angwane María Magdalabo btä María, José meye, nikani siba, okwäbti Jesu doboi mikani. ");
INSERT INTO gymNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yebti köbö jadükakrä nikanina ta angwane, María Magdalabo, María Santiago meye, btä Salomé käkwe jändrän rä mane kökani mda mikadre Jesu ngwäkä ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Abti ñänä jatani gökökä krire käin bämänte dekä angwane, nükanintre mda Jesu doboibti jändrän rä mane mikakäre ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nikanina nebe ja ken dobobti angwane, nikani niere jae kwärikwäri: ¿Jä kri dikaro mikani dobobti ye, nirekwe mikadikä mento nie amarebti yere? namani niere kore jae ji ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Namanina känti angwane, nikrabare kwetre angwane, jä kri abko ñakare täte kä mkäbti amne kä mkäbe tökare se kwrere, btä okwä namanintre. ");
INSERT INTO gymNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Bti nikanintre nikrenkä nguse kä mkäte angwane, ni bati btä dän nga ngwen bürere abko angele aibe nämane täkänintbe niaratre küde ruenkri, btä okwä namani angwane nekwetaninkä ni yebtä. ");
INSERT INTO gymNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Akwa angelekwe niebare nitre merire yeye: Mun ñan rekwetaka tibtä. Jesu Nazarebo müre ketani krusobtä, doboi mikani nete abko munta näin tuenta känti, ye gare kuin tie, akwa Jesu ye nürate nire, aisete ñakare nete amne kä mkä be nebe tökare niara täbti, mun jakwe tuen. ");
INSERT INTO gymNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mun rikata, käkwe nie krörö nitre ja töitikaka Jesube yeye btä Pedroye: Jesu nürate nire, bike niken Galilea ja ükakrökäreta ketetibe munbe, känti munkwe ja tuadita ben, niebare kwe munye ye kwrere, munkwe nie kore ietre, niebare angelekwe nitre merire yeye. ");
INSERT INTO gymNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yebti nitre merire nimä ye nikaninta angwane, nikani betekä ngitieta dobobti mentokwäre, ñobtä ñan angwane nekwetaninkä krübäte. Moto namani bete tükü tükü. Mden kisete namanintre grükekä jökrä ngrabare angwane, kä jürä namani krübäte dikaro btätre, aisete kukwe nakaninkä ño ño nin niebare jire chi kwetre ni mda mdaye abko kukwe nakaninkä kore Jesubtä. Ne abko kore. ");
INSERT INTO gymNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Bämänte dekä, Jesu nükaninta nire angwane, María Magdalabo, btä üai käme nämane krä kükü juanintari Jesukwe, ye ara jire, ie ja mikani tuare käne Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yebti nitre ja töitikaka Jesube nämane diäne müen abko, ie Jesu nükaninta nire, María jananbare niere. ");
INSERT INTO gymNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesu nükaninta nire jakwe tuani niebare Maríakwe, akwa María nämane blite ngwarbe namanintre nütüre btä, aisete ñan kukwei mikani era kwetre. ");
INSERT INTO gymNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Abti ni nibu ja töitikaka Jesube nikani juta Jerusalén bäre mento angwane, batibe Jesukwe ja bä kwitani jene, käkwe ja mikani tuare ietre ji ngrabare, ");
INSERT INTO gymNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","bti nikani mda, käkwe niebare nitre ja töitikaka Jesube mda mda yeye, akwa ñan kukwe mikani era kwetre arato. ");
INSERT INTO gymNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Abti nitre ja töitikaka Jesube ni jätäbti iti nämane mröre angwane, batibe Jesu nükani ja mike tuare ietre. Akwa Jesu nükaninta nire, ye ni tuakatuaka käkwe niebare nitre ja töitikaka ben yeye abko ñan kukwei kani ngäbti jire chi kwetre, yebtä Jesukwe ñäkäbare ietre. ");
INSERT INTO gymNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Bti Jesukwe niebare mda ietre: Kukwe kuin tibtä, ye mun rika mike gare kä ketareketare temen. ");
INSERT INTO gymNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Munkwe kukwe ye mikadi gare, ye nire nire käkwe kadi ngäbti angwane, ja ngökadi ñöte kwe ti käbti, ni ye abko Ngöbökwe dianditari, akwa nire nire käkwe ñan kukwe ye kadre ngäbti abko ñan diandretari kwe, akwa Ngöbökwe mikadi ja tare nike kri. ");
INSERT INTO gymNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Angwane, nitre tödekaka tibti abko käkwe jändrän nuendi krörö ti diebti: Üai käme juanditari mento nibtä kwe, ni kukwei jenena gare ñakare ietre abko bti blitadi kwe Ngöbö Üai köböire. ");
INSERT INTO gymNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nane tbi krübäte diandre kisete kwe, arato nane kräkä krübäte ni kämikakrä ñadre kwe, akwa ñan jraindre kisete. Mräkäre abko, ni bren bren bti kise mikadi kwe abko rabadita kuinta ti diebti. Ye abko, nitre tödekaka tibti, ie kukwe rabadi bare kore. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ni Dänkien Jesu käkwe blitabare ünän kore nitre ja töitikaka benbe, bti Ngöbökwe kaninkä käin, nikani ben kä käinbti, känti mikani täkäninte kwe ja küde ruenkri. Ye kwrere mikani bäri ütiäte kwe jae. ");
INSERT INTO gymNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abti nitre ja töitikaka Jesube abko nikani mda kä ketareketare te. Kukwe kuin nuenbare Jesukwe abko nikanintre mike gare ni jökräye. Angwane jändrän ñan rabadre bare ja di jenbti abko namani nebe bare ietre Jesu diebti, niaratre kukwei rabadre era ni mda mdakrä, abkokäre ni Dänkien Jesu namani die mike kore abko kukwe nakaninkä kore Jesubtä. Ne ngörä.");
INSERT INTO gymNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ngöbökwe kukwe mikanintbe ño ño abko erere namani bare Jesu köböire ni ngätäite, ye abko nitre nikani dikekä käne Jesube käkwe tuani ja okwä jenbti. Kukwe kuin Jesubtä, ye abko ni tuakatuaka ye nämane sribire mikakäre gare. Erere arato, jändrän kuin nakaninkä ño ño Jesubtä ye ni tuakatuaka käkwe niebare nunye, erere ni kwati käkwe tikani täräbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Ye kwrere ti tö namani tikai arato, aisete kä nera kukwe nakaninkä ño ño Jesubtä abko ti nikani ngwentari kuin, aisete mtare ti tö tikai metre ja täritäri makrä, ti kukwe muko ütiäte Teófilo, jändrän nakaninkä ño ño Jesubtä diribarera mae, ye rabadre gare bäri kuin mae, abkokäre tita kukwe ne tike krörö mae: ");
INSERT INTO gymNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bati jrei kädian nämane Herodes Kri nämane gobrane kä Judea yete angwane, ni blitaka Ngöböbe ni mda mda diäre kädian nämane Zacarías nämane nüne yete. Niara abko ni blitaka Ngöböbe ni mda mda diäre kira kädian nämane Abías tukwe mräkä. Niara abko sribikä ju blitakrä Ngöböbe känti. Nitre blitaka Ngöböbe ni mda mda diäre därebare Abías mräkäkri, ye ben nämane sribire. Meri Zacaríakwe kädian nämane Elisabet abko ni blitaka Ngöböbe ni mda mda diäre kira kädian nämane Aarón tukwe mräkä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Niaratre nibu nämane nüne era metre Ngöbö ngwärekri, ñobtä ñan angwane Ngöbö Kukweita dre nuemna, erere nämanentre mike täte metre. Mden kisete kukwe kwani ñakare ni mda mdaye kitakrä ngite. ");
INSERT INTO gymNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ye kwrere nämanentre Ngöbö Kukwei mike täte, akwa Zacarías btä Elisabet nämane bati angwane namani jabe, akwa Elisabet küde mriani jabtä, aisete ngäbäkre ñakare kwetre. Mdakäre arato, namanina unbre jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Akwa batira jire Abías tukwe mräkä blitaka Ngöböbe ni mda mda diäre nämane sribire ju blitakrä Ngöböbe känti, ben Zacarías nämane sribire gwaire angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nämanentre ni den iti ja ngätäite kri ngwäri mnü rä bäne kukwe Ngöbö ngwärekri. Ne abko nämanentre nuene käre köbö kwatirekwatire. Te Zacarías käbä namani sribi yebtä, ñobtä ñan angwane kä ngidianinkä aisete. Ne erere niara diani sribi ye nuenkä kwetre kä demente ju blitakrä Ngöböbete. ");
INSERT INTO gymNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ye erere kä nükani angwane, Zacarías nikani kri ngwäri mnü kukwe kä demente angwane, ni kwati mda namani blite Ngöböbe ju bäre. ");
INSERT INTO gymNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías nämane kri ngwäri mnü kukwe jäme, te batibe angele ni Dänkienkwe jatabare ie. Angele ye nämane ñukwä grä kri mnü rä bäne kukwakrä ne kwäräkri, niara küde ruenkri se kwrere. Btä okwä namani angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","¡aiteeje, ni rä nekwetaninkä ya! Namani grükekä jökrä ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Btäräbe angelekwe niebare ie: Zacarías ma ñan rekwetaka tibtä. Ma btä Elisabet käkwe ngäbäkre käräbare Ngöböye, erere Ngöbökwe mun kukwei nuanina, aisete meri makwe Elisabet yekwe ngäbäkre brare ngibiadi. Ye makwe kädian Juan. ");
INSERT INTO gymNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ngäbäkre däredi ye kä rabadi nuäre mabtä amne, ni kwati mda mda, btä kä rabadi nuäre siba, ");
INSERT INTO gymNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ñobtä ñan angwane niara rabadi ütiäte kri ni Dänkien ngwärekri. Mdakäre abko, niarakwe nin uba döi btä dö kwakakwaka mda ñadre jire chi. Arato niara ngämi därere, känenkri Ngöbö Üai Deme tädira täte btä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Juan rabadi ütiäte kri ni Dänkien ngwärekri, ñobtä ñan angwane niarakwe ni israelita kwati mikadita ja mäketa niaratre Dänkienbe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ne abko Ngöbö kukwei niekä kädian nämane Elías nämane sribire mekera Ngöbö Üai köböire amne Ngöbö diebti, ye kwrere Juankwe sribidi niara Dänkien känenkri, nitre israelita mikakäre biare niaratre Dänkien kaen ngäbti. Mdakäre abko, ni kwati tä ja rüere ngäbriänkätrebe, arato ngäbriänkä tä ja rüere rünbe abko ie ja mäkämnanta jabe kwärikwäri kwe. Erere arato, ni kwati tä ja dokwä mike ribi Ngöbökrä abko ie ja töi kwitamnanta kwe tödekakäre Ngöböbti. Ye kwrere, Juankwe ni kwati mikadi juto, ne abko kwe rabadre biare ni Dänkien kaen ngäbti. Ne mden kisete, kä rabadi nuäre ni kwatibtä, niebare angelekwe Zacaríaye. ");
INSERT INTO gymNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías käkwe ngwianintari mda ie: Ne abko ño sere ti tö nibi gai bäri metre tie. Nun nena unbre, dokwä ngwen bürere jakän. ¿Se ño amarebti, ngäbäkre däredre nunkwe sere? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angwane angele käkwe niebare mda ie: Ti kä Gabriel. Ti ne mdenta sribire Ngöbö ngwärekri kä käinbti. Niarakwe ti juni blite mabe kukwe kuin ne mikakäre gare mae. ");
INSERT INTO gymNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Akwa makwe ñan ti kukwei miri era, aisete mtare mentokwäre ngäbäkre makwe ngämi därere, känenkri ma kukwei rötadi. Akwa kukwe ne rabadi bare täte jökrä angwane, batibe ma kukwei gitiadita. Abko kore se, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kukwe ne nämane nakenkä angwane, nitre nämane ju bäre temen Zacarías ngibiare abko namanintre niere jae kwärikwäri: ¿Ne ñobtä amarebti, Zacarías nibi ngrötöte krübäte kä demente nere? namanintre niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Abti raire erere angwane Zacarías jataninta ju bäre. Niara tö namani blitai bentre, akwa nin kukwe namani ngitieta jire chi angwane, Ngöbökwe kukwe mikani tuare jabtä ie kä demente aisete, namanime blite jirekäbe kisebti kore mda abko nükani gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Kä kitani sribikäre namani bare angwane, Zacarías nikaninta ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Abti mda Elisabet namani bren, bren kwe kisete. Yebtä niara namani ja bäine dikakabtä sö krärike gwi. Nin namani näin kwäräkwärä. Namani nütüre: Ti Dänkien käkwe ti die mikaba, aisete tita ngäbäkre ngibiare. Kä näirare ni kwati käkwe ti mikaba ngwarbe, ñobtä ñan angwane ngäbäkre ñakare tikwe. Mtare ñan rabare ñäke tibtä, ñobtä ñan angwane tita ngäbäkre ngibiare aisete, nütübare kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Nebti Elisabet bren sö krä tira angwane, Ngöbökwe angele Gabriel juani mda kä Galilea yete nebe juta Nazarete, kukwe mike gare meri iti kädian nämane Maríaye. Ni merire ne abko bati kaibe, deme arato; ja mike gure ñakare jire chi, akwa nämanena mikani jakrä kwärikwäri ni kädian nämane Josébe. José abko jrei David tukwe mräkä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ne erere angele nükani María känti, käkwe niebare ie: Ñantöre mae. Ngöböta ja moto mike bäri kuin makrä meri mda mda ngwä, aisete niarata ma die mike, niebare angelekwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maríakwe angele ne mikani ñäräre angwane, nekwetaninkä niara kukweibtä. Abtä namani nütüre: ¿Se ñobtä angele käkwe köbö ngunintari kore tie sere? namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angwane angele käkwe niebare mda ie: María, ma ñan kä jürä ngwian jabtä. Ma käi nuäre Ngöböbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Makwe ngäbäkre brare ngibiadi iti abko makwe kädian Jesu. ");
INSERT INTO gymNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Niara rabadi ütiäte kri. Niara kädiandi Ngöbö Kri Kä Käinbti Odeire amne niara mräkä jrei David tukwe nämane gobrane kira, täte niarakwe gobrandi. ");
INSERT INTO gymNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Niara rabadi gobrane kärekäre nitre israelita ngätäite amne gobrain ñan krütadi jire chi, niebare kore angelekwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maríakwe niebare mda angele yeye: ¿Ti ngämi ja mike gure, amarebti mata niere kore tie yere? ");
INSERT INTO gymNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angele käkwe niebare mda ie: Ne ñobtä tita niere raba ruen mae, ñobtä ñan angwane Ngöbö Üai Deme rükadi mabtä. Ye ngwane Ngöbö Kri Kä Käinbti di tädi mabtä arato. Ye mden kisete ngäbäkre däredi makwe, ye abko deme amne Ngöbö Odei jen kwe. Mdakäre abko ti bike kukwe mda niere mae abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma mräkä Elisabet käkwe ngäbäkre ngibiadi. Niara nena biyore akwa, sö krä tira tä bren, bren kwe kisete arato. Meri ne mden di ñakare ngäbäkre ngibiakrä, aisete odei neme ñakare jire chi, nieta btä amarebti tä kore. ");
INSERT INTO gymNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tita niere mae, Ngöbö di tärä jändrän jökrä nuenkrä abko rabadre gare mae, aisete niara di tärä kukwe ne ngwiankrä bare mabtä arato raba gare mae, abkokäre tita niere mae. Ne abko kore, niebare kore angelekwe Maríaye. ");
INSERT INTO gymNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maríakwe niebare mda ie: Makwe kukwe nini tie, ne erere raba bare jire jökrä tibtä angwane, ti Dänkien tö ti mikai dre dre nuene, erere ti tö nuein tie. Abko kore se, niebare kwe angele yeye. Bti angele nikaninta kä käinbti. ");
INSERT INTO gymNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nebti María nikani jötrö ngwarbe Zacarías btä Elisabet känti kukwe niebare ie Elisabebtä tuakäre. Zacarías amne Elisabet abko nämane nüne mintokwäre kä Judea yete. ");
INSERT INTO gymNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","41","María namani Zacarías känti, nikani gwä, käkwe köbö ngwianintari Elisabeye. María kukwei jarabare Elisabeye angwane, btäräbe ngäbäkrekwe betatebare Elisabebtä amne Ngöbö Üai Deme nükaninbe täte btä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","44","Yebtä kä namani nuäre Elisabebtä, käkwe ñäkäbare jume mda Maríaye: ¡Jo! Ngöböta kukwe kuin nuene era metre makrä ni merire jökrä ngwä. Ye kwrere ngäbäkre ngämi därere makwe, kräke Ngöböta kukwe kuin nuene arato. Angwane meri ti ne kwrere ie basa dre sera amarebti Ngöböta kukwe kuin nuene makrä, ma ye abko nüke basare tie. Ne ñobtä ñan angwane ma abko ti Dänkien meye aisete. ¿Se ñobtä ma nüke basare tie sere? Ne ñobtä raba ruen mae, ñobtä ñan angwane makwe köbö ngunintari tie, btäräbe ngäbäkrekwe bitite tibtä, kä ngwini juto jabtä kwe ma kukweibtä aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ngöbö köböire käta neme nuäre mabtä, ñobtä ñan angwane Ngöbökwe ja kukwei niebare mae ngäbäkre makwebtä abko namani era makrä angwane, dre dre niebare kwe mae, ye erere rabadi bare jire jökrä ie, aisete tita niere mae. Abko kore se, niebare kwe Maríaye. ");
INSERT INTO gymNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Abtä Maríakwe niebare mda: Ti bike ti Dänkien Ngöbö käikitekä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ngöbö ti Diantarikä käi nibi nuäre kri tibtä, ");
INSERT INTO gymNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","ñobtä ñan angwane ti bobre, ütiäte ñakare, akwa ti Dänkien Ngöbö käkwe ti tarebare kri. Ngöbö Di Kri käkwe kukwe nuenba kri tikrä. Nebtä mtare mentokwäre, Ngöbökwe kukwe nuenba kuin krübäte tikrä abko ni jökrä rabadi niere tibtä. Ma abko deme käre Ngöbö. ");
INSERT INTO gymNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ni nünanka kira amne ni nünanka kä ne ngwane käta Ngöbö mike ütiäte jae amne tä niara jürä ngwen jabtä. Ni ye abko tä ruentari tare kärekäre Ngöböye abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ngöbökwe sribi kri nuenbare ja di kribti amne, nire nire nämane bike krikri Ngöbö rüere abko Ngöbökwe juani ngwarbe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Erere arato, gobran krikri abko kitani timon, akwa ni bobre bobre abko Ngöbökwe mikani ütiäte kri, käkwe die mikani. ");
INSERT INTO gymNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mdakäre abko, nitre tu neketebe mrö miare abko ie jändrän kuinkuin biani täte kwe amne, nitre jändrän bkäne kabre abko kän jändrän dianinkä jökrä kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ngöbökwe nitre israelita dianinkä sribikä jabe abko die mikani kwe amne ngwiani ruentari tare kwe jae ño kukwe ükaninte kwe ni ruai mrö känekänebe ye kwrere. Mdakäre abko, Abraham btä Abraham ngäbriänkätre ja täritäri kädianta nitre israelita die mikadi Ngöbökwe. Mden erere ni käi kwitakata ñakare jabti Ngöbökwe amne ni die mikata kärekäre kwe ja täritäri. Abko kore se, niebare Maríakwe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Yebti Maríakwe nünabare sö krämä Elisabet känti, bti jataninta ja gwiriete Nazarete. ");
INSERT INTO gymNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Abti mda ja ngibia käi nükani Elisabeye angwane, ngäbäkre brare därebare iti kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ne gani Elisabet mräkätrekwe btä kukwe muko mda mda käkwe gani angwane, jatanintre käi ngwen nuäre jabtä ben, ñobtä ñan angwane Ngöbökwe kukwe kuin nuenbare Elisabekrä, aisete niaratrekwe käi ngwiani nuäre jabtä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kwäira erere angwane, ngäbäkre ne kwata tikaninkä ñäräkrä mikakrä, ne abko kwe rabadre juta israelitare siba abkokäre. Ye ngwane niara kädian jababare rünbti mräkätrekwe, ");
INSERT INTO gymNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","akwa meye Elisabet abko ñan tö namani, käkwe niebare mda: ¡Ñakare! Ngäbäkre ne kädiandi Juan, niebare kore meyekwe. ");
INSERT INTO gymNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Zacarías mräkätre käkwe niebare: ¿Ma mräkä mden mden kädian tärä kore abko erere ma tö nibi ma ngobo kädiain sere? niebare kwetre mda ie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ne ngwane ngäbäkre rün abko tö namani ngobo ne kädiain ño abko tö namanintre gai, aisete Zacarías käkwe ngäbäkre kä tikadre kri kukwänbtä abko niebare kisebti kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Abtä Zacaríakwe kri kukwän käräbare ietre, ngobo käi tikakäre btä. Ne erere tikani kwe kri kukwänbtä: Ngäbäkre kädian Juan, tikani kore kwe. Nebtä namanintre töbike kri mda. ");
INSERT INTO gymNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Te batibe, Zacarías kukwe ngitianinkäta se kwrere, käkwe Ngöbö käikitaninkä mda. ");
INSERT INTO gymNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yebtä abko, mräkätre nekwetaninkä, töi ñan namani krütare batibe Zacaríabtä amne ngäbäkre kwebtä. Kukwe ne nakaninkä Zacarías juete abko kädrie namani jire jökrä ngwitäräta temen kä kiakiate Judea yete. ");
INSERT INTO gymNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Angwane ni jökrä käkwe kukwe ne gani angwane abko ngäbäkre ne ñakare ngäbäkre mda mda kwrere, ñobtä ñan angwane ni Dänkien nämane niarabe namani tuen ietre, aisete namanintre töbike krörö: ¿Ngäbäkre se rabadi ño sere? namanintre töbike ngäbäkre chi Juanbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yebti Juan rün Zacarías kukwe ngitianinkäta angwane, Ngöbö Üai Deme nükani btä angwane, Ngöbökwe dre nuendi nitre israelitakrä abko niebare krörö kwe: ");
INSERT INTO gymNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ngöbö nitre israelitakwe, ma ti Dänkien. Tita ma demaine, ñobtä ñan angwane ma kitera nitre israelita jen makwe dentari, ");
INSERT INTO gymNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","käkwe ni Diantarikä di kri juni nun kräke. Niara abko jrei David tukwe sribikä makwe ye mräkä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Mekera makwe ni Diantarikä juandi abko makwe niebare nitre israelitaye ma kukwei niekä deme köböire abko mden nere: ");
INSERT INTO gymNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nitre ja rüere nun israelitabe btä nitre mätä nunbtä, ye ngäniene makwe nun ngibiadi amne nun dianditari kwe abko makwe niebare nunye. ");
INSERT INTO gymNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Erere arato, nun ruai mrö känekäne, ye rabadi ruentari tare mae, makwe niebare ietre. Mden kisete makwe kukwe ükaninte kuin metre nun ruai mrö känekänebe, ye ñan käi rikwitadrekäta jire mabti, makwe niebare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ti Dänkien, makwe ja kukwei biani kwatibe nun ruai mrö Abrahamye kira abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Ni rüe jürä ñan rabadre mda nibtä amne, ni rabadre nüne jäme amne deme sribikäre makrä, abkokäre makwe ni dianditari ni rüe ngäniene, makwe niebare Abrahamye abko erere mata ngwena bare. ");
INSERT INTO gymNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Bti Zacaríakwe niebare krörö Juanye: Ma ti ngobo chi tikwe, ma rabadi ünän angwane, ma abko Ngöbö Kri Kä Käinbti kukwei niekä, niedi mabtä, ñobtä ñan angwane makwe nitre israelita töi mikadi biare ni Dänkien käne ño, ji ükateta niken kuin ni dänkien jrei käne ye kwrere. Ma nändi nitre israelita mike biare abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Makwe Ngöbö kukwei niedi kore nitre israelitaye angwane, ni ngite kukwe kämekäme nuenbtä, ye Ngöbökwe diandikä jire jökrä btä, ñan ja tare nikadre kwetre abkokäre, abko erere makwe niaratre mikadi biare ni Dänkien käne. ");
INSERT INTO gymNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ye kwrere Ngöbökwe nuendi, ñobtä ñan angwane nitre israelita ruentari tare kri Ngöböye aisete. Ñänänta kite kuin dekä dekä amne, käta nebe tuen kuin jökrä nie, ye kwrere abko Ngöbökwe ni Diantarikä juandi, käkwe Ngöbö mikadi gare metre nie. ");
INSERT INTO gymNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ño kä ikote käta nebe tuen ñakare nie, angwane kä jüräta nebe krübäte nibtä, ye kwrere ni ie Ngöbö gare ñakare abko gata jürä krübäte btä. Ni ye abko, ie ni Diantarikä juandi Ngöbökwe abko käkwe Ngöbö mikadi gare metre, ñänänta kite kuin dekä dekä amne, käta nebe tuen kuin jökrä nie ye kwrere. Ye köböire abko, ni rabadre nüne jäme Ngöbö ngwärekri kä nebtä amne ñan kä jürä rabadre mda nibtä, abkokäre ni Diantarikä juandi kwe. Abko kore se, niebare Zacaríakwe ngäbäkre chi Juanbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ngäbäkre Juan ne abko nikani niren, nikani niren ja töi metrebti. Niara namani ünän angwane, nikani nüne kä kaibete. Namani nüne yete abti kä nükani ie blitakäre Ngöböbtä nitre israelita ngätäite. ");
INSERT INTO gymNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ne ngwane emperador romanobo kädian nämane Augusto César käkwe ni jire jökrä kä tikamna täräbtä kä jökräbti temen gadre jae. ");
INSERT INTO gymNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kä ye ngwane abko, ni iti kädian nämane Cirenio nämane gobrane käkä Siria yete angwane, emperador Augustokwe kukwe ne mikanintbe krire kena. ");
INSERT INTO gymNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ye mdenbtä ni jökrä nikani ja käite, ruäre ja gwiriete ja kä tikakäre täräbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ne mden erere, José abko nikani Belén ja kä denkä täräbtä. Niara nämane nüne juta Nazaret kä Galilea yete. Niara abko, jrei David tukwe kira mräkä, aisete niara gwirie jen kwe abko Judea juta Belénte. Juta Belén känti jrei David tukwe därebare kira akwa, José nämane nüne Nazaret angwane, emperador Augustokwe kukwe ne mikanintbe, aisete niara nikaninta Belén ja kä diankakäreta täräbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Niara btä María nämane mikani jakrä kwärikwäri, jänikani kwe siba jabe Belén. María abko ñan mobe, bren kwe kisete, akwa jänikani kwe nebe Belén. ");
INSERT INTO gymNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Namani Belén, btäräbe ja ngibia käi nükani Maríaye. ");
INSERT INTO gymNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ngäbäkre mubai därebare brare Maríakwe, mrianinte kwe dän kukwänte. Angwane kri kukwän sribebare jändrän bukakrä, te mikani kwe, ñobtä ñan angwane ju ütiä biandre kibiakrä ñan kwani jire chi ietre nünantbekrä ngäbäkre kwe yebe. ");
INSERT INTO gymNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","9","Kä ye ngwane, nitre nämane obeja ngibiare jakrä dibire ta juta Belén kenta temen. Nämanentre jäme, te batibe angele jatabare iti ietre se kwrere. Btäräbe kä trä Ngöbökwe niabare ngwen jökrä niaratre bäre temen. Abtä nekwetaninkä amne moto namani bete krübäte. ");
INSERT INTO gymNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","11","Btäräbe angelekwe niebare ietre: Mun ñan rekwetaka tibtä, ñobtä ñan angwane ti ki kukwe kuin mike gare munye. Kukwe ne abko, ni jökräkwe käi ngwiandi nuäre kri jabtä, ñobtä ñan angwane mtare ngäbäkre däreniri iti juta Belén, David käite sete. Ngäbäkre ne abko mun Diantarikä. Niara abko Ni Dianinkä Ngöbökwe amne niara abko ni jökrä Dänkien. ");
INSERT INTO gymNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mdakäre abko, ti kukwei metre ya, ñakare ya rükadre gare krörö munye: Mun rika mike ñäräre. Ngäbäkre ye kwandi mrianinte dän kukwänte. Kri kukwän sribebare jändrän bukakrä te tädi mikani, kwandi munye angwane, ti kukwei metre gadi munkwe. Ne abko kore, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ye btäräbe, angele mda mda mata namani kwati angele ne känti okwäbtitre se kwrere, kä namanintre Ngöbö käikitekä krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ngöbö kri kä käinbti, ma aibe ütiäte kri. Nunta ma käikitekä, ñobtä ñan angwane makwe ngäbäkre ne juni kä nebtä, aisete kä jämenta kä temenbtä ni ngätäite. Erere mata blite jäme nitre nebe kä temenbtä, namanintre niere kore obeja ngibiakatre okwäbti, bti nikanintreta kä käinbti. ");
INSERT INTO gymNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nikanintreta jökrä angwane, obeja ngibiakatre namani blite jabe kwärikwäri, kä namani niere: Dreta nakenkä Belén sete abko ni Dänkienkwe miri gare nie, ye brän mike ñäräre, niebare kwetre jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Erere bkänä, nikanintre jötrö ngwarbe Belén. Namanintre yete angwane, ngäbäkre kwani ietre mikani kri kukwänte. María btä José abko nämane täkänintbe ken, btä namanintre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ngäbäkre jatabare ietre, bti nikani angwane, angele käkwe kukwe niebare ietre ngäbäkre yebtä, ye kädriebare kwetre ni mda mdabe. ");
INSERT INTO gymNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kukwe ye gani ni kwatikwe angwane, töi ñan namani krütare erebe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Akwa kukwe niebare ie obeja ngibiakatrekwe, yebtä abko María namani töbike kri kaibe. ");
INSERT INTO gymNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Obeja ngibiakatre käkwe kukwe tuani amne ni kukwei nuani kwetre, yebtä nikani Ngöbö käikitekäta ja jiebti se kwrere. Angele käkwe kukwe niebare ietre, ye erere nakaninkä jökrä btätre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Köbö kwäira erere angwane, María btä José käkwe ngäbäkre ne mikani kwata tikadrekä ñäräkrä mikakrä angwane, kädiani Jesu kwetre arato, angelekwe nuemna Maríaye, niara ngämi bren, bren kwe kisete ye känenkri. Ye erere abko nämane ja töibtä kwe, erere nuenbare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Abti köbö ja mikakräta dbe Ngöbö ngwärekri mikani nuendre Ngöbökwe nitre israelitaye, ye nükani Maríaye angwane, nikani Josébe ju blitakrä Ngöböbe juta Jerusalén yete, ja mikakäreta dbe Ngöbö ngwärekri. Ne erere niaratre nikani ju blitakrä Ngöböbe juta Jerusalén yete ütü kiare kubu o ütü ngäbäli kubu bien kukwadre María kräke Ngöböye, Kukwe Biani Ngöbökwe Moiséye ye mikakäre täte jökrä. Erere arato, María btä José nikanintre Jerusalén angwane, nikanintre ngäbäkre mubai Maríakwe ngwena siba jabe mikakäre gare Ngöböye, ñobtä ñan angwane “Ngäbäkre mubai jire jökrä abko rün btä meye käkwe mikadre gare Ngöböye” abko Dänkien Ngöbö käkwe nuemna kore nitre israelitaye ja Kukweibtä, erere nuenbare kwetre ju blitakrä Ngöböbe yete. ");
INSERT INTO gymNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kä ye ngwane abko, ni nämane nüne iti juta Jerusalén yete abko kädian nämane Simeón. Ni ye abko nämane nüne era metre Ngöbö ngwärekri amne Kukwe Biani Ngöbökwe Moiséye ye nämane mike täte arato. Erere arato, Ni Dianinkä Ngöbökwe käkwe nitre israelita moto mikadi jäme abko Simeón nämane ngibiare ngäbti amne Ngöbö Üai Deme nämane btä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mdakäre abko, Ni Dianinkä Ngöbökwe ne ngämi tuen, känenkri ñan jraindre abko Ngöbö Üai Deme käkwe mikani gare ie. ");
INSERT INTO gymNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ye näire Ngöbö Üai Deme käkwe Simeón töi mikani niken ju blitakrä Ngöböbe ye känti. Angwane María btä José nikani ngäbäkre Jesu ngwena yete arato, Kukwe Biani Ngöbökwe Moiséye ngäbäkre mubaibtä mikakäre täte angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","nikanintre gwäkäre angwane, Simeón ne jatani nemente, käkwe Jesu diani, ketani jabtä kwe, bti Ngöbö käikitaninkä okwäbti kwe se kwrere, käkwe niebare krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Ti Dänkien Ngöbö, makwe kukwe niebare tie, erere mtare nibira bare mae. Ne aisete ti sribikä makwe ne tuemetre jraine jäme jakän, ñobtä ñan angwane makwe ni juani nitre Diantarikä, ni ye mden abko tikwe turira. ");
INSERT INTO gymNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ni ne mden abko makwe juani ni jökrä kräke. ");
INSERT INTO gymNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mdakäre abko, ñotra trä kakata ni käne kä ikote, ye kwrere ma ño abko niarakwe mikadi gare nitre ñakare israelitareye. Ni kwati käkwe nitre israelita mikadi ütiäte, ñobtä ñan angwane niara därebare nitre israelita ngätäite aisete. Abko kore se, niebare Simeónkwe Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Abtä José btä Jesu meye abko töi ñan namani krütare Simeón kukwei nuare Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Nebti Simeón käkwe ja di käräbare Ngöböye kräketre angwane, niebare kwe Jesu meye Maríaye: Ngöbökwe ngäbäkre ne juani akwa niara ünän angwane, ni kwati ütiäte ñakare abko rabadi mikani ütiäte amne ni kwati ütiäte abko rabadi mikani ütiäte ñakare niara köböire. Mdakäre abko, ni kwati moto ño ño abko Ngöbökwe niara mikani mikakäre gare amne, ni kwati tä töbike ño ño Ngöböbtä abko niarakwe mikadi gare. Abtä ni kwati rabadi ja rüere ben, aisete ño ni gitiaka nguse ngitrabti tä ja tare nike krübäte, ye kwrere ma moto ötadite niara jiebti. Abko kore se, niebare Simeónkwe Maríaye. ");
INSERT INTO gymNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Ne känti abko, ni kädian nämane Aser tukwe abko mräkä kädian nämane Fanuel abko ngänkän Ngöbö kukwei niekä kädian nämane Ana nämane siba ju blitakrä Ngöböbe käntita. Ana abko nämane bati ngäbäkrere angwane, namani gure akwa nünabare kä kwä kükübe kwe brarebe amne brare krütani kän, bti namani kaibe. Ana ne abko namanina dokwä ngwen bürere, kä namani gre ketabkä bti kobkära ie, nämane siba ne näire. Batibe nikani ju blitakrä Ngöböbe käntita. Ye känti nämane käre köbö kwatirekwatire Ngöbö käikitekä amne, nämane ja bäine Ngöbökrä amne nämane blite Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ne aisete Simeón nämane blite Maríabe ngäbäkre Jesubtä, ne btäräbe Ana mata nükani, kä nikani Ngöbö käikitekä ngäbäkre Jesubtä. Erere arato, nitre israelita nünanka Jerusalén nämane ni ni diantarikä ngibiare ngäbti abko erere ben Ana nikani blite ngäbäkre Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nebti Kukwe Biani Ngöbökwe Moiséye, erere María btä José käkwe mikani täte jökrä, bti nikaninta ngobo kwebe ja käite, juta Nazarete Galilea. ");
INSERT INTO gymNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Namaninta ja käite, känti ngäbäkre Jesu nikani niren kuin dite ngrabare amne, namani niren bäri töbtä. Ne abko Ngöbö namani ja moto mike kuin kräke, aisete namani niren kore. ");
INSERT INTO gymNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesu nämane niren angwane, bieta ban te lebadura mikani ñakare kweta nämane kädianta Pascua, bieta ne käre nuen nämane kä kwatirekwatire juta Jerusalén. Känti käre kä kwatirekwatire Jesu meye btä José nämane niken siba. ");
INSERT INTO gymNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ne erere bati, kä kwä jätäbti kubu Jesuye angwane, Pascua köböi nükaninta mda. Ye näire abko, José btä María nämane niken käre kä kwatirekwatire, ye erere nikaninta mda Jesube. ");
INSERT INTO gymNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Abti Pascua köböi nikani ta angwane, José btä María ngidianinkä, nikaninta ja gwirie kukwäre amne Jesu ngäbäkrere namani Jerusalén abko nin gani kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Akwa Jesu nämane näin ja kukwe muko ngätäite nämanentre nütüre, aisete namanintre näin jäme. Te nänbarera köböiti jire kwetre ji ngrabare angwane, nikani Jesu känentari mräkä btä kukwe muko ngätäite nekwäre sekwäre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nikani känenentari, nikani känenentari se kwrere, akwa nin kwanintari jire ietre. Abtä nikanintreta ja jiebti nebeta Jerusalén Jesu känentari. ");
INSERT INTO gymNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Kä nikani köbömä ta angwane, nikanintre nebeta Jerusalén, nikanintre nebeta amne Kukwe Biani Ngöbökwe Moiséye dirikätre nämane ju blitakrä Ngöböbe bäre abko ngätäite Jesu nämane täkänintbe. Niara nämane nitre dirikä kukwei nuen. Erere arato nämane kukwe ngwentari kabre mda ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kukwe ngwiantari namani Jesukwe ne abko, ni töbtä töbtä raba blite, se kwrere namani blite. Mden kisete ni niara kukwei nuaka nuaka ñan töi namani krütare kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jesu nämane blite kore, btä meye amne José nikani nebeta angwane, ñobtä abko nämane blite dirikä krikri be abko ñan töi namani krütare tuare ja käne, bti meyekwe niebare mda ie: Ti ngobo tikwe, ¿ñobtä mata nuene kore nunbtä yere, amarebti ma rün noko btä ti mata nun ngwen ja känentari kri töbikare kwärä ja jiebti yere? niebare Maríakwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Abtä Jesukwe niebare mda meyeye: ¿Ye ño munta ti känenentari krübäte dikaro kore yere? ¿Ti tädre ti Rün gwiriete arato, ye gare ñakare munye ya amarebti yere? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jesukwe ñäkäbare ne abko dre niebare kwe niara Rün kwebtä ñan namani nüke gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bti Jesu nikaninta meyebe btä Josébe juta Nazarete. Jesu meye btä José nämane dre dre niere ie, erere nämane mike täte jire jökrä. Akwa kukwe nakaninkä Jesubtä Jerusalén, abkobtä meye nämane töbike kri kaibe mda. ");
INSERT INTO gymNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu abko nikani niren bäri kri amne nikani töi ngitiekä bäri kri arato. Mdakäre abko, Ngöbö nämane niara ngibiarebti kuin janknu amne ni kwati namani niara tarere kri arato. ");
INSERT INTO gymNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Abti kä kwä jätäbti kwärikera emperador Tiberio nikani gobrane ne ngwane, ni nämane gobrane kräke abko nere: Gobernador Poncio Pilato nämane gobrane käkä Judeate. Dänkien tetrarca Herodes Antipas abko nämane gobrane käkä Galileate. Herodes etba kädian nämane Felipe abko nämane gobrane käkä Itureate btä käkä Traconite yete amne dänkien tetrarca Lisanias abko nämane gobrane käkä Abilenete. ");
INSERT INTO gymNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kä ne ngwane Anás btä Caifás nämane nitre blitaka Ngöböbe ni mda mda diäre dänkiene. Te bati Zacarías ngobo kä Juan abko ben Ngöbökwe blitabare kä kaibete. ");
INSERT INTO gymNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Abtä Juan nikaninbe Ngöbö kukwei niere krörö nitre nünanka Ñö Jordán ngrabare yeye: Kukwe kämekäme nuenta munkwe, yebtä mun moto raba ulire, bti mun jata Ngöböye amne mun jata ja mike ngökadre ñöte tie. Ye ngwane mun ngite kukwe kämekäme nuenbtä, ye Ngöbökwe diandikä jire jökrä munbtä, Juan namani niere. ");
INSERT INTO gymNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ye abko, Juan nikani ñäke ño abko nämanena tikani Ngöbö Kukweibtä tärä Isaíabtä abko krörö: Ni iti näin ñäke jume ja dibti kä kaibete, käkwe niedi krörö: Ji ükateta kuin biare jrei känenkri, ye kwrere ja töi mike kuin biare ni Dänkien käne munkwe. Ji ükateta niken metre ta, ye kwrere ja töi ükete metre ni Dänkien käne munkwe, ");
INSERT INTO gymNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ño kä ngitio ngürebtä möta, te dobo keka kabre ükate ruäre ngitio mintrinibe amne raba kiare, ji rabadre metre jreikrä abkokäre. Ye kwrere arato, ngitio krikri btä ngitio kiakia tikakata, bti ükateta kiare jökrä, ji rabadre metre dänkien jreikrä abkokäre. Mdakäre abko, ji tolentolen tikakata niken metre tata amne ji turureturure ükateta niken kiare, ye kwrere munkwe ja töi ükate kuin biare ni Dänkien käne. ");
INSERT INTO gymNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ne abko ni Diantarikä juandi Ngöbökwe, ye ni nünanka kä jökräbti käkwe tuadi, niarakwe niedi, abko Ngöbökwe tikamna kore Isaíaye. ");
INSERT INTO gymNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ye erere Juan nämane blite angwane, ni namani kite kwati ja mike ngökadre ñöte Juanye abko ie Juan namani ñäke krörö: Mun abko tbi krübäte kwrere. ¿Ngöbö kebera mun mike ja ngie nuen kri krübäte, yebtä nirekwe mun mikani mokre amarebti mun kite nüke siba nete ye? ");
INSERT INTO gymNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Munkwe ja töi kwitadre era metre Ngöbö kukwäre bkänä tödekakäre bti abko erere munkwe nüna ni mda mda okwäbti. Erere arato, munkwe ñan nie au jabtä: Nun abko Abraham mräkä, aisete Ngöbökwe ñan nun mikadi ja ngie nuen, munkwe ñan nie au jabtä, ñobtä ñan angwane jä tuen temen sete, se abko ngwarbe akwa Ngöbö raba kwite Abraham mräkäre abko ti tö nibi niei metre kore munye. ");
INSERT INTO gymNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mdakäre abko, kri mden mden ñan ngwä nebe kuin, ye abko kräke ü mikanina biare tikakakrä ngätrite ta. Abti tikakata jökrä angwane, kitata ñukwäte, ye kwrere jire Ngöbökwe mun mikadi ja ngie nuen, munkwe ñan ja töi kwitadre Ngöbö kukwäre angwane. ");
INSERT INTO gymNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Abtä ni nämane yete käkwe niebare Juanye: Ni nun kwrere abko käkwe kukwe kuin nuendre ño, köböire nunta Ngöbö mike ütiäte jae bä rabadre nunbtä, niere nunye niebare kwetre Juanye. ");
INSERT INTO gymNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juankwe niebare mda ietre: Mun mdenkwe dänta ötabu, ye abko ni dän ñakare, ie munkwe dän jakwe bian ötati. Erere arato, mun mden mrö bkäne, mrö ye abko munkwe ni mrö nikaka buka te siba, ye ngwane munta Ngöbö mike ütiäte rükadi gare munbtä, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ne ngwane nitre israelita jändrän ütiä käräkä gobran romanobokrä, ye nükanintre siba ja ngökakäre ñöte arato, käkwe niebare Juanye: ¿Nun abko käkwe kukwe kuin nuendre ño, köböire nunta Ngöbö mike ütiäte jae bä rabadre nunbtä? niebare kwetre Juanye. ");
INSERT INTO gymNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juankwe niebare mda ietre: Gobranta ngwian kärämna nuäi nuäi ni mda mdaye, ye erere munkwe kärä. Akwa munkwe ñan ngwian dianka bäri bti ni mda mdakän, ye ngwane munta Ngöbö mike ütiäte rükadi gare munbtä, niebare kore kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Erere arato, nitre rükä nükani ruäre, käkwe niebare Juanye: ¿Nun abko käkwe kukwe kuin nuendre ño, köböire nunta Ngöbö mike ütiäte jae bä rabadre nunbtä? niebare kwetre ie. Juankwe niebare mda ietre: Ni mda mda rätäkäta munkwe amne munta ngwian btä jändrän kwekwe denkä kän, ye kwrere munkwe ñan nuen jire chi mda. Erere arato, munkwe ñan ni mda mda kita ngise ngwarbe amne sribi ütiä bianta nuäi nuäi munye, yebe ben munkwe nüna jäme. Ye ngwane munta Ngöbö mike ütiäte rükadi gare munbtä. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kä ye ngwane abko, ni jökrä nämane Ni Dianinkä Ngöbökwe ngibiare ngäbti kisere, aisete nane Juan abko Ni Dianinkä Ngöbökwe ara nükani, nitre israelita jökrä namani nütüre, btä nämane töbike kri. ");
INSERT INTO gymNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ye mden kisete Juankwe niebare ietre: Tita mun ngökö ñö aibe te bkänä, akwa ni jatadi iti ti jiebti abko bäri di kri ti ngwä. Niara abko Ni Dianinkä Ngöbökwe, aisete sandalia ngotobtä yebtä nin ja nüke töre jire chi tie kö tikarete ie. Ni ye abko käkwe Ngöbö Üai Deme mikadi nüne munbtä amne Ngöbö Üai Deme rabai ñukwä jutra kwrere munbtä, mun mikakäre deme Ngöbökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ne abko, niarakwe dre nuendi abko ti bike niere munye abko krörö: Niara tä jändrän ngwena kisete trigo juankakrä. Trigo juandikä kwe angwane, trigo kuinkuin erere ükadikrö jenena kwe amne trigo kwata abko ükadikrö jenena kwe. Yebti ñukwä nötöte ñakare abko te trigo kwata ye kukwadi kwe. Tita mun bä mike trigo kwrere amne trigo kwata kwrere. Abko kore se, niebare Juankwe nitre israelitaye. ");
INSERT INTO gymNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ye kwrere Juan namani blite ni kwati ben töi diankäre, kä namani kukwe kuin Ngöbökwe mike gare ietre kore. ");
INSERT INTO gymNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Akwa kä ye ngwane abko, jrei Herodes käkwe etba kwe kädian nämane Felipe abko merie kädian nämane Herodías diani etba kän. Erere arato, nämane kukwe kämekäme nuene bätäkä ngwarbe Ngöbö rüere. Abtä Juankwe ñäkäbare Herodeye ");
INSERT INTO gymNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","abko dokwäre Juan kitani ngite kä teri kwe ne ngwane, ja mikani ngite bäri kri mda kwe Ngöbö rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Akwa Juan kita ngämi ngite kä teri, känenkri nämane ni ngökö ñöte angwane, Jesu ngökani ñöte kwe arato. Jesu jämi nikenta jate angwane, nämane blite Ngöböbe, btäräbe jukwe tika kwrere kä ngitiani kä käinbti, ");
INSERT INTO gymNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","amne Ngöbö Üai Deme, jatani tuen ütü bä kwrere timonkwäre, nikani mate Jesubti. Ne btäräbe ni kukwe jarabare krörö kä käinbti: Ma abko ti Ngobo tikwe. Ma tare kri tikwe. Ma käi nuäre kri tibtä, niebare kore kä käinbti timonkwäre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kä kwä gre bti kwä jätära Jesuye kwrere angwane, jatani sribi Ngöbö Kukweibtä kömiketbe kena. Jesu abko José ngobo nütü nämane ni jökräkwe amne José abko Elí ngobo. ");
INSERT INTO gymNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí abko Matat ngobo, Matat abko Leví ngobo, Leví abko Melqui ngobo, Melqui abko Jana ngobo, Jana abko José mdara jire ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José abko Matatías ngobo, Matatías abko Amós ngobo, Amós abko Nahum ngobo, Nahum abko Esli ngobo, Esli abko Nagai ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai abko Maat ngobo, Maat abko Matatías mdara jire ngobo, Matatías abko Semei ngobo, Semei abko José mdara jire ngobo, José abko Judá ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá abko Joana ngobo, Joana abko Resa ngobo, Resa abko Zorobabel ngobo, Zorobabel abko Salatiel ngobo, Salatiel abko Neri ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri abko Melqui mdara jire ngobo, Melqui abko Adi ngobo, Adi abko Cosam ngobo, Cosam abko Elmodam ngobo, Elmodam abko Er ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er abko Josué ngobo, Josué abko Eliezer ngobo, Eliezer abko Jorim ngobo, Jorim abko Matat mdara jire ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat abko Leví mdara jire ngobo, Leví abko Simeón ngobo, Simeón abko Judá mdara jire ngobo, Judá abko José mdara jire ngobo, José abko Jonán ngobo, Jonán abko Eliaquim ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim abko Melea ngobo, Melea abko Mainán ngobo, Mainán abko Matata ngobo, Matata abko Natán ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán abko David ngobo, David abko Isaí ngobo, Isaí abko Obed ngobo, Obed abko Booz ngobo, Booz abko Salmón ngobo, Salmón abko Naasón ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón abko Aminadab ngobo, Aminadab abko Aram ngobo, Aram abko Esrom ngobo, Esrom abko Fares ngobo, Fares abko Judá mdara jire ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá abko Jacob ngobo, Jacob abko Isaac ngobo, Isaac abko Abraham ngobo, Abraham abko Taré ngobo, Taré abko Nacor ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor abko Serug ngobo, Serug abko Ragau ngobo, Ragau abko Peleg ngobo, Peleg abko Heber ngobo, Heber abko Sala ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala abko Cainán ngobo, Cainán abko Arfaxad ngobo, Arfaxad abko Sem ngobo, Sem abko Noé ngobo, Noé abko Lamec ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec abko Matusalén ngobo, Matusalén abko Enoc ngobo, Enoc abko Jared ngobo, Jared abko Mahalaleel ngobo, Mahalaleel abko Cainán mdara jire ngobo, ");
INSERT INTO gymNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán abko Enós ngobo, Enós abko Set ngobo, Set abko Adán ngobo, Adán abko Ngöbökwe dätebare. ");
INSERT INTO gymNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu nämane Ñö Jordánbtä, känti Juankwe ngökani ñöte angwane, Ngöbö Üai Deme nämanena täte btä, kä nikani Jesu ngwena kä kaibete mda. ");
INSERT INTO gymNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ne känti Jesukwe nünantbebare köbö gre ketebu angwane, diablu namani nüke Jesu nuente ja käne. Köbö gre ketebu Jesukwe mröbare ñakare jire chi, akwa kä ye namani bare angwane, btäräbe mrö namani dikaro ie. ");
INSERT INTO gymNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ne aisete diablu jataninta, käkwe niebare ie: Ma abko Ngöbö Odei era metre ne ngwane, jä se kwite mröre jae, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Akwa Jesu käkwe niebare mda diabluye: Ñakare. Ngöbö Kukwei tä tikani krörö: Ñan mrö aibebti ni rabadre nüne, akwa kukwe kwatirekwatire niebare Ngöbökwe, yebti ni rabare nüne, abko tä tikani Ngöbö Kukweibtä, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nebti ngitio bäri mente käin, yebti diablu nikani Jesu ngwena mda. Ye känti, jötrö ngwarbe kä jökrä amne juta kä jökräbti temen mikani tuadre kwe Jesuye, ");
INSERT INTO gymNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","bti niebare kwe ie: Jändrän ne biani jökrä tie amne ti tö rabai bien nireye, erere tikwe biandre jökrä aisete, makwe ja mikadi ngukudokwäbti temen ti ngwärekri, käkwe ti mikadi ütiäte jae angwane, kä jökrä tä ti kisete btä jändrän jökrä ütiäte krikri tä kä nebtä, se tikwe biandi jire jökrä mae, niebare diablukwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Abtä Jesukwe niebare mda ie: Ñakare. Ngöbö Kukwei tä tikani krörö: Ni Dänkien Ngöbö aibe mikadre ütiäte jae. Niara aibe kräke sribidre, abko nieta kore, aisete tikwe ñan ma kukwei mikai täte, niebare Jesukwe diabluye. ");
INSERT INTO gymNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Nebti diablu nikani Jesu ngwena juta Jerusalénte mda, känti nikani Jesu ngwena mobe ju blitakrä Ngöböbe bti käin, bti niebare kwe ie: Ma abko Ngöbö Odei era metre bkänä ne ngwane, ja täkete timon nete, ñobtä ñan angwane Ngöbö Kukwei tä tikani krörö mabtä: Ngöbökwe angeletre juandi ma ngibiarebti abko käkwe ma kadi ngäbti kisete, ma ngoto ñan matadre jäte temen, abkokäre angeletrekwe ma ketadite käintabe kisete, abko tä tikani Ngöbö Kukweibtä mabtä, aisete ja täkete timon, ma Ngöbö Odei ara mikakäre gare ni jökräye, niebare diablukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Abtä Jesukwe niebare mda diabluye: Ñakare. Ngöbö Kukwei tä tikani abko käta niere krörö arato: Ni Dänkien Ngöbö käkwe ja kukwei mikadre täte ya, ñakare ya amne, niara di tärä ja kukwei ngwiandre bare ya, ñakare ya abko makwe ñan nuate ja käne ja gakäre ben, abko tä tikani kore, aisete tikwe ñan ma kukwei mikai täte. Abko kore se, niebare Jesukwe diabluye. ");
INSERT INTO gymNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nebti diablukwe Jesu nuaninte ünän jökrä ja käne, bti nikani mentokwäre, köbö bäri kuin Jesu nuatekäreta, ye ngibiare jae mda. ");
INSERT INTO gymNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nebti Jesu nikaninta Galileate angwane, Ngöbö Üai Deme di namani kri btä, aisete namani dre dre nuene, abkobtä ni jökrä namani kädriere juta ketareketare temen. ");
INSERT INTO gymNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Erere arato, sinagoga juta ketareketare te, käntikänti Jesu namani niken dirire. Kukwe diri nämane kwe, yebtä ni jökrä namani niara käikitekä. ");
INSERT INTO gymNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesu nämane Galilea, nikaninta juta Nazarete niara rirabare ye känti. Namaninta yete angwane, köbö jadükakrä näire niara nämane niken sinagogate, känti nämane niken käre. Ye erere, bati köbö jadükakräte nikaninta, känti namani nünaninkä ñäkäkäre Ngöbö Kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ne btäräbe, ni Ngöbö kukwei niekä kädian nämane Isaías käkwe tärä tikani abko ngökani Jesuye. Jesu nikani täräkwata ne metete angwane, batibe tärä krörö kwani ie, bti nikani ñäke btä: ");
INSERT INTO gymNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dänkien Ngöbökwe ti dianinkä ja kukwei kuin mikakäre gare ni bobre bobreye, aisete ja Üai mikani tibtä kwe sribi nuenkäre. Ngöböta biare ni ngite ngite tikatekäre abko ti juani niere kwe ietre. Ni ie kä tuen ñakare abko ie kä rabadre tuenta abko ti juani niere kwe ie. Erere arato, nire nire tä ja tare nike ni mda mda ngoto täni kwrere abko ti juani tikete kwe kä rabadre nuäre btä abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mdakäre abko, Dänkien Ngöböta ja moto mike kuin ni kräke abko ti juani niere kwe, abko tärä yebtä Jesukwe ñäkäbare. ");
INSERT INTO gymNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bti tärä, btä Jesukwe ñäkäbare, ye mrianinkäta kwe, ngökaninta kwe sinagoga ngibiaka yeye, bti namaninta täkänintbe dirikäre se kwrere. Angwane Jesukwe ño niedi mda abko ni jökrä namani ngibiare, aisete okwä namani kwekbe jökrä Jesubtä Jesu kukwei ngibiare se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ne btäräbe Jesukwe niebare mda: Kukwe btä tikwe ñäri gwä, ye abko mtare mentokwäre nibira bare jökrä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesu namani kukwe kuinkuin niere dikaro, yebtä ni jökrä ñan töi namani krütare, aisete namanintre Jesu kädriere kuin jökrä. Akwa yebti, namanintre niere krörö jae kwärikwäri Jesubtä: ¿Ni noko ñan José ngobo ya amarebti nibi dirire kore jabtä noko? namanintre niere Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Abtä Jesukwe niebare mda ietre: Ni kräkä bianka, btä nita töbike blo, ie nita niere krörö: ¡A! Ma kräkä bianka kri era metre ne ngwane, makwe ja mika kuinta au angwane, nunkwe ma mikai era jae abko nieta. Ne kwrere munta töbike tibtä, ye gare kuin jabtä tie. Ye kwrere, Ngöbökwe ma juani ni die mikakäre mata niere jabtä, aisete ye bä mike tuadre abko munta nütüre tibtä. Mdakäre abko, sribi kri nuenta Ngöbö diebti, erere namani bare mae Capernaúm kädrieta nun okwäbti, ye kwrere nuene ja käite nete nun kräke tuadre nunye, ne munkwe niedi tie, ye gare kuin tie arato. ");
INSERT INTO gymNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mden kisete ti bike kukwe era erere niere munye: Ni Ngöbö kukwei niekä, ye abko ja käite mikata ütiäte ñakare jae mräkäkwe abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Bati ni Ngöbö kukwei niekä kira kädian nämane Elías nämane nüne abko näire Ngöbökwe kä mikani bäri moren kä komä bti ötare amne nin ñü näkäni jire chi temen, aisete mrö nikani kri kä jökräbti temen Israel känti. ");
INSERT INTO gymNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kä ye ngwane abko, meri kän brare krütani krütani nämanena kabre nitre israelita ngätäite, akwa nin Ngöbökwe Elías juani nüne meritre israelita ye känti, ñobtä ñan angwane nitre israelita ñan nämane Elías mike ütiäte jae. Akwa meri nämane iti kän brare krütani arato, akwa ñakare israelitare nämane nüne mobe Israel bäre juta Sareptate juta kri Sidón bäre abko känti Ngöbökwe Elías juani nüne. ");
INSERT INTO gymNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ye kwrere arato, ni Ngöbö kukwei niekä nämane nüne kira kädian nämane Eliseo abko näire ni ngütüete ngrabare lebra kisete nämanena kwati nitre israelita ngätäite abko nin mikaninta kuinta jire iti Ngöbökwe, ñobtä ñan angwane nitre israelita ñan nämane Eliseo mike ütiäte jae. Akwa ni menteni ñakare israelitare nünanka mobe kä Siria känti ngütüete jökrä ngrabare arato abko kädian nämane Naamán aibe mikaninta kuinta Ngöbökwe. Mräkä israelitakwe mikani ñakare era jae, aisete Ngöbökwe die mikani ñakare. Ye kwrere tä nakenkä tibtä nete. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nebtä ni Jesu kukwei nuaka nuaka sinagogate namanintre moto romon krübäte jökrä kräke, ");
INSERT INTO gymNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","aisete ni jökrä namani ja rüere Jesube, kä nikani kitekä romone ja käne juta bäre mento nebe kä oko romonbtä ngitiobti. Ne känti abko Nazaret nämane. Känti tö namanintre Jesu kitai jräte. ");
INSERT INTO gymNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Akwa Jesu abko nikaninta jäme ni kwati ye ngätäite ta mentokwäre. ");
INSERT INTO gymNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nebti Jesu nikaninta mda motokwäre juta Capernaúmte Galilea. Abti köbö jadükakrä näire nämane niken sinagogate, känti namani dirire ni nämane ja ükekrö yeye ");
INSERT INTO gymNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","amne, niaratre jökrä ñan töi namani krütare kukwe diribare kwe yebtä, ñobtä ñan angwane ni töbtä di kri käkwe diri ja di ngöi, kwrere jire Jesukwe diribare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jesu nämane dirire angwane, ni nämane iti sinagoga yete, btä üai käme nämane nüne. Te batibe ni ye käkwe ngratebare kri ja dibti Jesuye: ");
INSERT INTO gymNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","¡Jesu Nazarebo, nun tuemetre kaibe nete! ¿Ye ñobtä abko, ma kite ja mike kukwe nunkwete yere? ¿Ma kite nun gaenkä ya ño yere? Jesu, ma gare kuin tie. Ma abko Ni Deme Ngöbökwe gare tie, niebare üai kämenkwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Abtä Jesukwe niebare mda üai kämeye: ¡Üai käme, kada mkä kete makwe! Ni ye tuemetre gwängwarbe. Nän mento btä, niebare kwe. Ye btäräbe, ni jökrä ngwärekri, üai käme ni yebtä käkwe nitani temen, bti nikani mento, akwa ñan ni ye mikani bren kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nebtä ni jökrä töi ñan namani krütare Jesubtä, kä namani niere jae kwärikwäri: ¿Ni neta kukwe ño ño dirire amarebti niara di tärä üai käme juentari jötrö au, tä ñäke kwatibe üai käme juantarikrä mento amne, üai käme tärä niken mento ie sere? namanintre niere kore Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yebtä abko, Jesu kädrie namani kä jökräte juta Capernaúm käntita temen. ");
INSERT INTO gymNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesukwe diribare ünän sinagoga yete, bti nikani nebe Simón känti mda angwane, Simón köbrän merire abko nämane bren jume drangwan kisete. Angwane Jesukwe mikadreta kuinta abko mräkä namani ribere ie. ");
INSERT INTO gymNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ye erere Jesu nikani, namani jänbtä Simón köbrän merire ye ken, käkwe drangwan juanintari Simón köbränbtä. Ye btäräbe, drangwan nikaninbe batibe btä, namaninta kuin batibe, namanintabe kuinta amne nükani dikekäta krö, nikani mrö känene niaratre bukakrä. ");
INSERT INTO gymNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nebti ñänä jatanina niken timon dere angwane, ni kwati nämane ja tare nike bren bätäkä ngwarbe kisete abko mräkä namani niken ngwena Jesuye. Ye abko, Jesu namani kise mike bti angwane, namani nebeta kuinta jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Erere arato, ni kwati btä üai käme nämane nüne abko kisete bren jänükani siba Jesuye. Ni ye abko, btä üai käme nämane niken mento, kä namani ñäke krikri be krörö Jesuye: ¡Jesu, ma Ngöbö Odei, ye gare kuin tie! üai käme namani niere kore Jesuye. Abtä Jesukwe kada ketamna üai kämeye. Nin Jesu namani üai käme tuemetre ñäke jire chi mda, ñobtä ñan angwane Jesu abko Ni Dianinkä Ngöbökwe abko namanina gare kuin üai kämeye, aisete ñan niedre kwe gadre ni jökräye, abkokäre Jesukwe kada ketani. ");
INSERT INTO gymNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jändrinane dekä, Jesu nikani kä kaibete juta bäre mento rabakäre kaibe akwa, ni kwati namani känentari kisere kwäräkwärä, te nikani nebe Jesu jiebti. Namanintre Jesu känti angwane, Jesu ñan rikadre, ie tö namani, kä namani Jesu ketete kisere. ");
INSERT INTO gymNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Akwa Jesukwe niebare ietre: Ngöbö kite gobrane ni ngätäite, ye tikwe mikadre gare juta ketareketare te, abkokäre Ngöbökwe ti juani, aisete ti ñan rabadre kwekbe kä ketetibe känti. Abko kore se, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ye erere bkänä, Jesu namani niken kukwe ye mike gare nitre israelitaye sinagogate kwäräkwärä kä Judeate. ");
INSERT INTO gymNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Abti bati, kä jatani ngwen dekä angwane, Jesu nämane Ñö Okwä Kri Genesaret (arabe kädianta Ñö Okwä Kri Galilea) ye köräbti angwane, ni kwati tö namani Ngöbö Kukwei nuai, kä namani Jesu kete dime ja ngätäite namani ruen Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ne btäräbe ni gwa gaka nämane ruäre krade bätete, käkwe ru jakwe mikaninte krobu ñö köräbti, btä Jesu okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu nikani, nakwani ru krati te. Ru te Jesu nakwani, ye abko ru Simónkwe. Jesu namanina rute, ru ngwiamna bäri ñöte kwe Simónye, bti namani täkänintbe Ngöbö Kukwei dirire ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jesukwe diribare ünän angwane, niebare kwe mda Simónye: Ñö okwä bäri mente nguse, ye känti ru ngwena, bti munkwe krade kita ñöte gwa gakrä, niebare Jesukwe Simónye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Abtä Simónkwe niebare Jesuye: Dirikä, deo abko kä kuin gwa gakrä. Nunkwe sribinirira kri dibire ta. Nin nun käbä nibi jire chi, akwa mata ti juen gwa gaenta, aisete ti bike niken, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ye kwrere bkänä, Simón nikani sribi mukobe, namanintre ñö okwä nguse känti, käkwe krade kitani ñöte angwane, batibe gwa neketaninte kabrekabre krade ietre se kwrere. Krade namani nötöte bee kisete gwa täni. ");
INSERT INTO gymNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Amne sribi muko kwekwe nämane ru mdate abko namanintre kärere, kä namani kise minienkä ietre abko rikadre die mike gwa ükekrö abkokäre. Erere sribikä nämane ru mdate, ye nikani gwa ükekrö siba amne gwa ükaninkrö ru krobu bti tabe kwetre. Gwa namani ñakare rute ya, aisete bäsi ru namani niken neen jökrä ñöte nguse gwa däbä täni Simón okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Yebtä ja namani ruen käme btä ngite Jesu ngwärekri Simón Pedroye, aisete nikaninbe ngitiekä ngukudokwäbti temen Jesu ngwärekri, käkwe niebare ie: Ti Dänkien, ma deme ti ngwä. Ti abko moto kämekäme dikaro, aisete nän mento tibtä, niebare Simónkwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Simónkwe ñäkäbare kore Jesuye, ñobtä ñan angwane Simón btä Zebedeo ngäbriänkätre kädian nämane Santiago btä Juan abko käkwe ñan gwa gabare jire erere gwa gani kwetre aisete, Jesu diebtibe gwa gani kabre kore kwe nükani gare ietre aisete, töi ñan namani krütare. Kwrere ni mda mda nämane näin siba Simónbe ñan töi namani krütare arato, gwa gani kabre kwetre yebtä. Simónkwe ñäkäbare kore Jesuye, abtä Jesukwe niebare mda ie: Simón, ma abko gwa gaka, akwa mtare mentokwäre ma jatadi ni gaen Ngöbökrä, aisete ma ñan rekwetaka tibtä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Yebti Simón, Santiago btä Juan nikani ru ngwenante nebe ñö köräbti jate, käkwe jändrän jökrä kwe mikaninte, bti nikanintre Jesube. ");
INSERT INTO gymNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bati Jesu nämane jutate angwane, ni iti bren lebra kisete, abtä ngütüete ngrabare nükani abko ie Jesu jatabare angwane, nikani ngitiekä ngwäre timonkwäre Jesu mikakäre ütiäte, käkwe niebare ie: Ti Dänkien, ma tö ti mikaita kuinta ne ngwane, makwe ti mikata kuinta, ie ti tö nibi, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Angwane Jesukwe kise mikani btä, käkwe niebare mda ie: Ma rabata kuinta, ie ti tö nibi, aisete gwängwarbe ma bike nebeta kuinta, niebare Jesukwe ie. Ye btäräbe ni kwata ngütüete ngrabare ye kwata namaninta kuinta jökrä ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Angwane Jesukwe niebare krörö mda ie: Tikwe ma mirita kuinta, ye makwe ñan nie jire chi ni mda mdaye, akwa ma rika ja kwata kuinta mike tuare ni blitaka Ngöböbe ni mda mda diäreye amne ni bren kore tä nebeta kuinta abko käkwe jändrän mden mden biandre niebare Moisékwe, ye erere ma rika ngwena biandre Ngöböye ma rabadre dbe niara ngwärekri abkokäre. Yebtä abko ma nenante kuinta abko rabadre gare ni jökräye, abkokäre ma rika jändrän ye ngwena. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jesukwe ja dokwä täkäni kore ni mikaninta kuinta kwe yebe, akwa kukwe nakaninkä, yebtä abko bäri ni jökrä namani Jesu kädriere niken juta ngrabare temen, abkotari ni mda mda namani nüke ja ükekrö kwati mda Jesu kukwe nuakäre, ruäre bren abko Jesukwe mikadreta kuinta abkokäre namanintre nüke. ");
INSERT INTO gymNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Akwa Jesu abko nämane niken käre kä kaibete blitakäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bati Jesu nämane dirire mda angwane, nitre bariseo btä Kukwe Biani Ngöbökwe Moiséye dirikätre nünanka juta ketareketare te Galilea amne Judea ngrabare temen, ruäre abko nünanka juta Jerusalénte nükani, namani täkänintbe Jesu kukwei nuen. Ye ngwane Dänkien Ngöbö di kri nämane Jesubtä ni bren bren mikakäreta kuinta. ");
INSERT INTO gymNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jesu nämane dirire gwi angwane, ni ruen ñakare ngrabare abko kisete ñan dikaka kä, mikani jänkwatabti abko ni mda mda nükani ngwena ja ñäte, tö namanintre niken ngwena nebe gwi Jesu ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Akwa ni namani kwati dikaro aisete, ñan namani tuen ngwiane gwä ietre. Abtä nikanintre jubti käin, käkwe ju mkä tikaninkä abko te ta ni bren ye gibianinkä köbtä käin timon kwetre, nükani ngitiekä temen Jesu ngwärekri ni kwati okwäbti se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nitre nükani ni bren ngwena amne ni bren ye namani tödeke kwatibe Jesubti namani tuen ie, käkwe niebare ni bren yeye: Ma ngite Ngöbö rüere, ye tikwe dininkä mabtä ti mräkä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Angwane Kukwe Biani Ngöbökwe Moiséye dirikätre btä nitre bariseo namani töbike krörö Jesubtä: Ngöbö aibe tä ni ngite niara rüere denkä mento nibtä amarebti, ¡se ñobtä abko ni se tä ñäke kore Ngöbö rüere se! namanintre töbike kore Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Akwa niaratre namani töbike kore ye abko gani Jesukwe. Abtä niebare kwe ietre: ¿Ñobtä munta töbike kore tibtä yere? ");
INSERT INTO gymNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Dre abko bäri nuäre niedre? ¿Ma ngite Ngöbö rüere, ye tikwe dininkä mabtä abko bäri nuäre niedre ya? o ¿Näin krö, nän dikekä abko bäri nuäre niedre ya? ");
INSERT INTO gymNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Akwa ti, Ni Kä Nebtä Ngobo ne ie Ngöbökwe ja di biani mun ngite Ngöbö rüere diankakäre mento munbtä kä nebtä, ye abko ti bike bä mike tuadre munye, niebare Jesukwe. Bti niebare kwe ni ruen ñakare ngrabare yeye: Näin krö. Jänkwata makwe ye den kisete amne nänta ja gwiriete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Btäräbe, ni jökrä okwäbti, ni ruen ñakare ngrabare ye naninkrö krö, käkwe jänkwata bti nämane temen diani kisete, bti nikaninta ja gwiriete Ngöbö käikitarekä kwärä se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yebtä ni nämane kwati ye ñan töi namani krütare amne namani Ngöbö käikitekä jökrä, kä namani niere krörö jae kwärikwäri: ¡Aiteeje, mtarebra ñan nikwe jändrän kuin turi ya! Jändrän ne kwrere ni ngämi tuen jire bati, erere nikwe tua mtare yera, ni jökrä namani niere kore jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nebti Jesu nämane jutate, nikaninta angwane, kä jändrän ütiä käräkrä gobran romanobokrä, ye känti ta nikani mda amne, ni kädian nämane Leví nämane täkänintbe jändrän ütiä kärere yete, känti Jesu nikani mate angwane, Jesu okwä namani kwekbe Levíbtä, käkwe niebare ie: Brän tibe, niebare kwe Levíye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Angwane jötrö ngwarbe Levíkwe jändrän jökrä mikaninte, nükani dikekä krö, bti nikani Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Abti Leví tö namani Jesu mikai ütiäte, käkwe bieta köböi kitani ja juete mda Jesukrä. Ye ngwane ni jändrän ütiä käräkä gobran romanobokrä namani kwati täkänintbe, btä ni mda mda nämane täkänintbe mröre siba mesabtä Jesube. ");
INSERT INTO gymNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yebtä abko, nitre bariseo btä Kukwe Biani Ngöbökwe Moiséye dirikätre reketaka jakri bariseobe abko namanintre ñäke nitre ja töitikaka Jesube rüere, käkwe niebare ietre: Nitre jändrän ütiä käräkä gobran romanobokrä abko käme amne ni mda mda kukwe nuenkä kämekäme amarebti munta mröre siä kwatibe te amne munta dö ñaen bentre sere, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nitre bariseo käkwe ñäkäbare kore, ye jarabare Jesuye angwane, Jesukwe ja bä mikani ni kräkä bianka kwrere amne nitre jändrän ütiä käräkä amne nitre kukwe nuenkä kämekäme, ben nämane mröre ye bä mikani ni bren kwrere kwe, käkwe niebare krörö mda ietre: Ni kuin, bren ñakare ye abko ñan tä ni kräkä bianka ribere jabtä, akwa ni bren bren abtä tä ni kräkä bianka ribere jabtä abko ti tö nibi niei munye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ni ie ja ruen kuin deme au Ngöbö ngwärekri mun kwrere, ye abko ñan ti jatani kärere Ngöbö kukwäre, akwa ni kukwe kämekäme nuenkä Ngöbö rüere ye mden abko ti jatani kärere Ngöbö kukwäre, niaratre käkwe ja ngite niedre Ngöböye, bti kukwe kämekäme kitadre temen kwetre amne tödekadre Ngöböbti kwetre, abkokäre ti jatani. Abko kore se, niebare kwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Abti nitre bariseo käkwe niebare krörö Jesuye: Nitre nänkä Juan Bautistabe btä nitre nänkä nun bariseobe abko käre tä ja bäine Ngöbökrä, käre tä blite Ngöböbe. ¿Se ñobtä abko, nitre ja töitikaka mabe abko käre mröre, käre dö ñaen akwa, ja bäine ñakare Ngöbökrä sere? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Abtä Jesukwe kukwe bä mikani ietre, käkwe ja bä mikani ni ja mikaka gure kwrere amne, nitre ja töitikaka ben abko bä mikani kwe ni ja mikaka gure kukwe muko kwrere, käkwe niebare nitre bariseoye: Ni iti tä niken ja mike gure angwane, tä kukwe muko kwekwe nübaire kä ngwiankäre nuäre gwaire jabtä, ye ngwane ¿ni ja mikaka gure ye tädre siba bentre angwane, kukwe muko ye raba moto ulire ja bäine ya? Ñakare. ");
INSERT INTO gymNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Akwa ni ja mikaka gure ye järikadre kukwe muko okwäbti, ye ngwane rabadre ja bäine abko kore rakadikä nitre ja töitikaka tibe yebtä, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Kukwe ngwianintari ja bäinbtä, abtä Jesukwe kukwe bä mikani krörö dän btinbtä amne uba döi btinbtä, käkwe niebare: Ni ñakare jire iti käta dän btin tikekä, bti tä dän ngututu gudike, ñobtä ñan angwane nikwe dän btin kukwän tikadrekä, ye ngwane dän btin juandre ngwarbe. Erere arato, dän ngututu gudikadre kukwän btin bti, ye ñan rabadre kuin. ");
INSERT INTO gymNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Erere arato, chibo kwata dikani kira uba döi ngwäre, te ni ñan raba uba döi mräre keke mikadre kwaka, ñobtä ñan angwane uba döi bänän jatadre dime amne rikadre nokrekä, ye käkwe chibo kwata ngututu trekadre amne rikadre ngwarbe uba döi kwaka ben ngöi jökrä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mden kisete, uba döi mräre mikadre kwaka abko kekadre chibo kwata btinte, uba döi amne chibo kwata ñan rikadre ngwarbe. ");
INSERT INTO gymNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mdakäre abko, nita uba döi sribebare kira ñaen, yebti ni ñan töta nebe uba döi mrä ñaen mda, ñobtä ñan angwane ni uba döi kira ñaka, ye käta uba döi kira abko bäri bänänte niere. Ye kwrere arato, mun ñan tö kukwe btin dirita tikwe kaen ngäbti, tuen tie. Mun ñan tö kukwe ngututu diribare kira tuaimetre, kukwe dirita tikwe kakrä ngäbti, aisete tita kukwe ne niere munye. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Abti bati Jesu nikani dikekä nura ngätäite köbö jadükakrä näire mda angwane, nitre ja töitikaka ben nämane näin siba, kä nikani trigo ngwä ötö ji ngrabare kwetadre jae; nikani münente, münente, nikani kwete ji ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yebtä abko, nitre bariseo nämane näin ruäre, käkwe niebare nitre ja töitikaka Jesubeye: ¿Ye ñobtä jändrän ñan nuendre jire chi köbö jadükakrä näire nieta abko mun nibi nuene sere? niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Abtä Jesukwe niebare ietre: Bati David btä rükä kwekwe, ie mrö namani krübäte angwane, kukwe nuenbare krörö kwetre: Ju nuäre ngwiandre känti ban deme nämane mikani Ngöbö ngwärekri, ye känti David nikani gwä, ban diani kwe, bti kwetani kwe rü muko kwekwe ben. Ban ye abko, David btä nitre nämane ben käkwe ñan kwetadre jire chi, ñobtä ñan angwane nitre blitaka Ngöböbe ni mda mda diäre aibe käkwe kwetadre niebare Ngöbökwe, akwa niaratre käkwe kwetani, akwa namani ngite ñakare. Ngöbö Kukwei yebtä mun tärä ñäke ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ye kwrere abko, köbö jadükakrä näire yebti ta abko ti Ni Kä Nebtä Ngobo abko bäri ütiäte, aisete nitre ja töitikaka tibe rabadre dre dre nuene köbö jadükakrä näire abko ti di tärä niere ietre. Abko kore se, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Abti köbö jadükakrä mdara jire te, Jesu nikani sinagogate, känti namani dirire angwane, ni iti küde ruenkri ara jire ngrötani ie nämane yete. ");
INSERT INTO gymNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ye ngwane Kukwe Biani Ngöbökwe Moiséye dirikätre btä nitre bariseo nämane yete arato. Jesukwe ni ye mikadreta kuinta köbö jadükakräte ne ngwane, Jesukwe ja mikani ngite Ngöbö rüere niedre kwetre Jesu rüere ni mda mdaye, abkokäre namanintre Jesu ngibiaretari kisere ni küde ngrötani yebtä. ");
INSERT INTO gymNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Akwa Kukwe Biani Ngöbökwe Moiséye dirikätre amne nitre bariseo nämane töbike ño Jesubtä, ye Jesukwe gani btätre, käkwe niebare krörö ni küde ngrötani yeye: Jakwe ni jökrä ngwärekri nete, niebare kwe ie. Erere ni ye nikani, namani nünaninkä ni jökrä ngwärekri se kwrere angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesukwe niebare nitre bariseoye amne Kukwe Biani Ngöbökwe Moiséye dirikätreye: ¿Köbö jadükakrä, yebtä Kukwe Biani Ngöbökwe Moiséye käta dre niere? ¿Jändrän kuin nuendre ni mdakrä ya? ¿Kukwe käme nuendre ni mdabtä ya? ¿Ni bren mikadreta kuinta ya? ¿Ni bren tuametre krüte ja okwäbti ya? Dre nuendre metrere niere tie munkwe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bti Jesukwe mikani ñäräre jire jökrä ja bäre temen, bti niebare kwe ie: Küde ngököte, niebare Jesukwe ie. Ye erere ni ye käkwe küde ngökaninte angwane, küde namaninta kuin batibe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yebtä Kukwe Biani Ngöbökwe Moiséye dirikätre btä nitre bariseo käkwe kä mikaninkäbe romone, mätä namani kri Jesubtä, kä namani niere jae kwärikwäri: ¿Nikwe dre nuendi ni noko kitakrä ngite ruen? namanintre niere jae kwärikwäri Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Abti bati Jesu nikani blite Ngöböbe ngitiobti käin. Ye känti kä nükani ngwen ie blitabtä Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kä nükani ngwen dekä angwane, Jesukwe nitre nänkä ben ye käräbare ja känti, bti nitre ye ngätäite ni dianinkä ni jätäbti nibu kwe ja kukwei ngwianka. ");
INSERT INTO gymNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ni dianinkä Jesukwe abko nere: Simón, (ne mden Jesukwe kädiani Pedro arato); btä niara etba kwe Andrés; arato Jacobo, Juan, Felipe, Bartolomé; ");
INSERT INTO gymNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","btä Mateo, Tomás, btä Alfeo ngobo Jacobo; arato Simón Zelote ");
INSERT INTO gymNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","btä Jacobo etba kwe Judas btä Judas Iscariote. (Judas Iscariote ne mden käkwe Jesu kitani ngise müre ketadre.) ");
INSERT INTO gymNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nebti Jesu nämane ngitiobti ni dianinkä ni jätäbti nibu kwe ye ben, nikaninta motokwäre, namaninta kiabti ngüsrüri. Ye känti ni kwati nänkä ben, btä ni kwati nünanka kä ketareketare kä Judeate, juta Jerusalénte amne ni nünanka mren köräbäre juta kädianta Tiro amne Sidón ye ken, käkwe ja ükaninkrö kwati Jesu ngibiare ngäbti, btä Jesu nükaninta. ");
INSERT INTO gymNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ni nükani kwati ne abko jatani Jesu kukwei nuakäre. Ni bren bren abko Jesukwe mikadreta kuinta, abkokäre jatani. Ni ruäre abko nämane ja tare nike üai käme kisete abko namani nebeta kuinta Jesu diebti. ");
INSERT INTO gymNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Erere arato, Jesu die namani kri ni mikare kuinta, abkotari ni jökrä bren bren tö namani Jesu nuainbtä, erere namani nuenbtä angwane, namanintre kuinta Jesu diebti. ");
INSERT INTO gymNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesukwe ni bren bren mikaninta kuinta, yebti nitre ja töitikaka ben amne ni mda mda nämane näin ben, ye mikani ñäräre jökrä kwe, bti niebare kwe ietre: Mun bobre bobre, ye abko Ngöbökwe die mikadi amne kä rabadi nuäre munbtä, ñobtä ñan angwane Ngöbö tä gobrane munbti. ");
INSERT INTO gymNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mun ruäre tä mrö nike mtare, ye abko Ngöbökwe die mikadi amne kä rabadi nuäre munbtä, ñobtä ñan angwane mun ye abko ie Ngöbökwe mrö biandi ere. Mun ruäre tä ja müaire kä nebtä kukwe bätäkä ngwarbe btä, ye abko Ngöbökwe die mikadi amne kä rabadi nuäre munbtä, ñobtä ñan angwane mun ye abko käkwe kötadi bänänte mrä. ");
INSERT INTO gymNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mdakäre abko, ti Ni Kä Nebtä Ngobo Kwrere ne mikabtä täte, ni mda mdakwe bätä ngwiandi munbtä, ñan tö rabadi mun tuai ketetibe jabe, käkwe mun juanditari amne ñäkädi taretare kwe munye. Ni moto kämekäme btä ñäkä raba kämekäme, ye kwrere jire ñäkä rabadi munbtä, mun ye abko Ngöbökwe die mikadi amne kä rabadi nuäre munbtä, aisete mun ñan raba ulire. ");
INSERT INTO gymNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Munkwe ja tare nika kore angwane, munkwe kä ngwian bäri nuäre jabtä amne mun rika nakwenkä kwäräkwärä, ñobtä ñan angwane munkwe ja tare nikadi ye ütiäre abko Ngöbökwe jändrän kuin biandi munye kä käinbti sete. Munkwe kä ngwiandre nuäre kore jabtä arato, ñobtä ñan angwane nitre mun mikaka ja tare nike, ye mräkä kirakira käkwe nitre Ngöbö kukwei niekä kira abko mikani ja tare nike kore arato, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Bti ni ngwian bkäne krikri btä Jesukwe blitabare krörö: Mun ngwian bkäne krikri tödeke ñakare Ngöböbti akwa, ngwian kabre munkwe aibebti munta tödeke, aisete kä nuäre kä nebtä aibe tä munkwe, ñobtä ñan angwane mrä abko jändrän Ngöbökwe ñan rabadi jire chi munkrä. ");
INSERT INTO gymNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ye abko, mun ngwian bkäne krikri käta mröre trinetrine mtare kä nebtä, aisete munta nüne jäme, mun Ngöbö Kukwei töbikaire ñakare. Mun ye abko käkwe mrö nikadi tare jakän. Erere arato, mun ngwian bkäne krikri käta kötö kuin bänänte mtare, akwa mun Ngöbö käi ngwen nuäre ñakare jabtä. Ye aisete mun ye abko moto rabadi ulire ulire ja müaire tare jakän. ");
INSERT INTO gymNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mdakäre abko, kira nitre ni ngökaka jatani ja Ngöbö kukwei niekä niere, mika nämane ütiäte ütiäte ni jökräkwe, ye kwrere mun mikata ütiäte ütiäte jae mtare. Akwa mtare munta Ngöbö mike ñakare ütiäte jae, aisete mrä angwane, Ngöbökwe ñan mun mikadi ütiäte jae. Mun ye abko bobrera jakän. Abko kore se, niebare Jesukwe ni ngwian bkäne krikribtä. ");
INSERT INTO gymNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesukwe niebare: Mun ti kukwei nuaka nete, ye ie ti bike niere krörö: Munkwe mun rüe tare. Nire nire mätä munbtä abko kräke munkwe jändrän kuin nuen. ");
INSERT INTO gymNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nire nire käkwe mun rätäkä taretare, ye kräke munkwe jändrän kuinkuin kärä Ngöböye. Nire nire käkwe mun mikadre ja tare nike krübäte, ye kräke munkwe blita Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Erere arato, nane ni mdakwe ma meta ngwäre küde ruenkri yebtä ma mikakäre ngwarbe jae ne ngwane, makwe ja ngwäre kwäräkri mika demaindre ie ja mäkäkäreta ben. Akwa makwe ñan ja ngie mika. Erere arato, nirekwe dän bäri kuin makwe ja mriatekrä tä mabtä ye dianka makän angwane, dän raba ötadi mabtä, ye makwe bian ie arato. ");
INSERT INTO gymNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nirekwe jändrän munkwe kärä munye, ye erere munkwe bian ie. Erere arato, nirekwe jändrän jen munkwe dianka munkän, munkwe ñan ja ngie mika amne munkwe ñan käräta ie. Munkwe kukwe ne nuendre kore angwane, munkwe mun rüe taredre. ");
INSERT INTO gymNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ni mda mdakwe jändrän kuin nuendre munkrä, ie mun töta nebe, ye kwrere munkwe jändrän kuin nuen ni mda mdakrä. ");
INSERT INTO gymNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mdakäre abko, ni moto kämekäme tä ni niara tarekätarekä tarere, ye kwrere munkwe ni mun tarekätarekä aibe taredre arato angwane, ¿Ngöbökwe ütiä biandi munye, munta nütüre ya? Ñakare, ñobtä ñan angwane ¿dre bä jene nuenta munkwe ni moto kämekäme ngwä? ¿Ye ñan kukwe nuenta ni moto kämekämenkwe arabe munta nuene siba ya? ");
INSERT INTO gymNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Erere arato, ni jändrän kuinkuin nuenkä aibe kräke ni moto kämekäme tä jändrän kuinkuin nuene, ye kwrere ni jändrän kuin nuenkä munkrä aibe kräke munkwe jändrän kuin nuendre angwane, ¿Ngöbökwe ütiä biandi munye, munta nütüre ya? Ñakare, ñobtä ñan angwane ¿dre nuendre munkwe ni moto kämekäme ngwä kore? ¿Ye ñan kukwe nuenta ni moto kämekämenkwe arabe munta nuene siba ya? ");
INSERT INTO gymNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne kwrere arato, ni moto kämekäme aibe tä ngwian bien ütiädre jae kwärikwäri, bti tädre tödeke ngwian jakwebti kwärikwäri. Ye kwrere ni ie mun tö rabadre ja di käräi amne ngwian tädrera kwe mun die mikakrä aisete aibe ie, munkwe ngwian biandre ütiädre angwane, ¿Ngöbökwe ütiä biandi munye, munta nütüre ya? Ñakare, ñobtä ñan angwane ¿dre bä jene nuenta munkwe ni moto kämekäme ngwä? ¿Ye ñan kukwe nuenta ni moto kämekämenkwe arabe munta nuene siba ya? ");
INSERT INTO gymNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ne mden kisete, munkwe ñan mun mräkä aibe die mikadre, akwa munkwe mun rüe taredre amne munkwe jändrän kuin nuen mun rüe die mikakrä. Erere arato, munkwe ngwian bian ütiädre mun rüeye angwane, munkwe ñan biandre ütiä diankräta töre kwäräkrita jae. Munkwe nuendre kore ne ngwane, Ngöbökwe sribi mun rüekrä ye ütiä biandi kri munye kä käinbti. Erere arato, mun rabadi Ngöbö Kri Kä Käinbti ngobore, ñobtä ñan angwane ni diän diän kräke Ngöbö ütiäte ñakare amne ni moto kämekäme tä nüne Ngöbö rüere, akwa Ngöbö mandama kräke, aisete ye kwrere mun rabadre arato. ");
INSERT INTO gymNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ni jökrä ruentari tare Ngöbö mun Rünye, ye kwrere munkwe ni jökrä ngwian ruentari tare jae, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesukwe niebare: Ngöbökwe ñan kukwe ükadrete mun rüere, abkokäre munkwe ñan bika kri, käkwe ni mda mda bä mika käme ja käne. Erere arato, Ngöbökwe ñan mun mikadre ngite, käkwe mun mikadre ja tare nike kärekäre, abkokäre munkwe ñan bika kri, käkwe ni mda mda mika ngite ngwarbe. Ni mdakwe ja mika ngite mun rüere, ye munkwe dian jabti ta angwane, mun ngite Ngöbö ngwärekri, ye Ngöbökwe diandikä jire jökrä munbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ye kwrere arato, nireta jändrän mdei nike, ie munkwe jändrän bian ngwarbe angwane, Ngöbökwe jändrän biandi munye. Ye abko, munkwe jändrän ñäkädi kuin täte, ye kwrere Ngöbökwe jändrän biandi kuin täte munye. Ye mden kisete, munkwe jändrän biandre ngwarbe ño ni mda mdaye, ye kwrere Ngöbökwe jändrän biandi munye arato, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","40","Bti Jesukwe kukwe bä mikani krörö mda: ¿Ni ja töitikaka, ye bäri töbtä kri ni dirikä ie yekrä ya? Ñakare, akwa ni ja töitikaka, ye käkwe ja töi tikadre ünän jökrä angwane, batibe rabadre töbtä dirikä ie ye kwrere, aisete mun ngämi ja töitike ünän, känenkri mun abko ni krörökrörö kwrere: ¿Ni ie kä tuen ñakare, ye raba ni mda niara kwrere jie ngwen kuin ya? Ñakare, ñobtä ñan angwane ni nibu ie kä tuen ñakare ja kwrere rikadre ja jie ngwena kwärikwäri ye kä oko romon mdente tuen ñakare ietre, aisete betadrekä jräte amne rikadre ngwarbe gwaire. Ne aisete, mun ngämi ja töitike ünän, känenkri munkwe ñan bika kri, kä rika ni mda mda jie ngwena, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jesukwe kukwe mda bä mikani krörö, käkwe kukwe käme nikwe bä mikani kri oto bäri kri kwrere amne, kukwe käme nuenta ni mdakwe abko bä mikani kä büre chi kwrere, käkwe niebare: ¿Kri oto bäri kri tä ma okwäte, ye ño abko ma töbikare ñakare jae amarebti kä büre chi ma mräkä okwäte, abkobtä mata nebe ja ngwen ruen tare yere? ");
INSERT INTO gymNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ye ñobtä kri oto bäri kri tä ma okwäte abko mata dianka nütüre ñakare jae amarebti, kä büre chi ma mräkä okwäte abko, ie mata niere: Ti mräkä, kä büre ma okwäte ye, ti tuemetre denkä jae, mata niere ie? ¡Ye ñan ngwarbe, mata ja bä mike kuin ma mräkäbtä, käta kukwe nuene kore yera! Makwe kri oto kri ma okwäte, ye ara jire dianka käne jae, bti kä raba tuenta kuin mae angwane, batibe makwe kä büre chi ma mräkä okwäte ye dianka mda ie. Ye kwrere, munta kukwe nuene bäri kämekäme abko okwäbti, ni mdata ja mike ngite chi abko munkwe ñan bika bäri kise ngwen btä. Munkwe ñan ñäkä jire chi ni yebtä, akwa kukwe käme, yebtä mun raba moto ulire, bti kukwe ye tuemetre jire jökrä käne, abti mun raba mun mräkä die mike, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Bti Jesukwe kukwe mda bä mikani abko krörö: Kri ngwä kuin kwetadre ñan ngwäta nebe käme. Erere arato, kri ngwä käme kwetata ñakare, ye ñan ngwäta nebe kuin. ");
INSERT INTO gymNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ye mden kisete, ngwäta kuin ya, käme ya, yebtä kri kuin ya, käme ya tä nüke gare nie. Ne aisete, ¿kri tukwäte tukwäte btä nita higo ngwä kuin kwetadre ötö ya? Ñakare. Erere arato, ¿kri mda mda tukwäte tukwäte btä nita uba ngwäkä ükekrö ya? Ñakare. ");
INSERT INTO gymNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ye kwrere jire abko, ni moto kuin ne ngwane, nita blite kuin ni mda mda die mikakäre, akwa ni moto käme ne ngwane nita blite ngwarbe diän diän jirekäbe, ye abko ñan tä ni mda mda die mike, ñobtä ñan angwane niara abko töi käme, yebe tä nüne. Ne aisete ni moto ño amne ni töi ño, ye kwrere nita blite, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","47","Bti Jesukwe niebare mda: Mun ti kukwe nuaka nuaka nete, ye ngätäite ni ruäre käta ti Dänkien, niere tie akwa, tita kukwe nuemna abko erere tä nuene ñakare. Ni ye kwrere abko, ti bike bä mike ni krörö btä munye: ");
INSERT INTO gymNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bati ni nämane iti, kä nikani ju mike ñö köräbtä. Käne kä muani mente nguse nguse kwe, bti ürä kuin nökani kwe ju gräre, bti ju mikani kuin jäkwatabti kwe. Abti bati ñü jatani temen, ñö nikani niren niren jate, jatani mate dite jubtä se kwrere, akwa ju mikani kuin kwe, aisete nin ñö nikani ngwena kän. Ye kwrere abko ni ti kukwe nuaka nuaka abko ie tita dre dre nuemna, erere tä nuene, ni ye abko ni iti käkwe ju mikani kuin ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Akwa ni mdara jire käkwe ju mikani ñö köräbtä arato abko käkwe ürä nökani känime ümante abko ñü jatani temen, ñö nikani niren niren kri jate, jatani mate dite jubtä. Ju ye abko namani jueme, aisete ñö jatani mate btä, nikaninbe temen, nikani ngwarbe jire jökrä. Ye kwrere abko, ni ti kukwe nuaka nuaka abko ie tita dre dre nuemna akwa tä nuene ñakare, ni ye abko ni iti käkwe ju mikani jueme, nikani temen ye kwrere. Abko kore se, niebare Jesukwe ni kwatiye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesukwe blitabare ünän ni kwatibe, yebti nikani mda juta Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ye känti rükä dänkien romanobo nämane nüne iti. Ni ye abko kwe, ni nämane iti sribikä jakrä. Sribikä ye abko mika nämane ütiäte kri kwe abko näkäni bren jume, namani tu neketebe kän. ");
INSERT INTO gymNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ne btäräbe Jesu nämane Capernaúmte kädrie namani jabtä ni rükä dänkien ye okwäbti. Jötrö ngwarbe, niara käkwe nitre unbre ji dokwäte nitre Capernaúmbo ngätäite juani Jesu kärere sribikä jakwe miketa kuinta. ");
INSERT INTO gymNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Erere nitre unbre ji dokwäte ye jatani, nükani Jesu känti, kä namani ribere kisere krörö Jesuye: Nitre rükä dänkien abko ñakare israelita. Niara romanobo bkänä akwa, ni israelita tare kri kwe. Niara arabe käkwe ngwian biani sinagoga jue ütiä biankrä nunkrä Capernaúm nete, aisete niara ütiäte, aisete makwe sribikä kwe mikadreta kuinta kräke, ie nun tö nibi abko namanintre ribere kisere kore ie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Te Jesu nikani bentre, nikanina nebe nitre rükä dänkien ye gwirie ken angwane, nitre rükä dänkien ye käkwe kukwe muko juani ruäre Jesu ngäbti ja kukwei niere, käkwe niebare Jesuye: Nitre rükä dänkien käkwe ja kukwei niemna mae abko nun ki niere ma ngäbti abko krörö: Ti Dänkien, ni ütiäte ñakare ti ne kwrere abko gwiriete ni ütiäte ma ye kwrere nin rükadre jire chi ruen tie, aisete makwe ñan ja nikadre dikaro rükakäre ti gwiriete, nibi ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma bäri ütiäte, ye mdenbtä abko nin ja nüke töre jire chi tie, niken ma kärere au sribikä tikwe miketa kuinta, aisete tikwe ni mda aibe juni ma kärere. Akwa sribikä tikwe rabadreta kuinta abko makwe niedre jirekäbe menteninbe angwane, rabadita kuinta abko gare tie abko ti tö nibi ribei mae, ");
INSERT INTO gymNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ñobtä ñan angwane ni mda bäri ütiäte ütiäte, ben tita sribire, käta dre nuemna tie, erere tita nuene. Erere arato, nitre rükä tä sribire tibe abko tita juen, ye tä niken jötrö ngwarbe. Jakwe, tita niere ie, jötrö ngwarbe tä kite. Mdakäre abko, ni klabore tikwe, ie sribi ne nuene, tita niere, jötrö ngwarbe tä nuene. Ne aisete, tita dre niere, erere tä nebe bare täte jökrä. Ye kwrere arato, makwe dre dre niedre sribikä bren tikwebtä abko erere rabadi bare täte mae ruen tie, aisete tita ja di ribere kore mae, niemna kore nitre rükä dänkienkwe mae, niebare rükä dänkien kukwe mukokwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yebtä Jesu ñan töi namani krütare mda, käkwe ni nämane näin ben mikani ñäräre jökrä, bti niebare kwe ietre: Ni tödeke kwatibe Ngöböbti ni ne kwrere, nin ngämi kwen jire tie nitre israelita ngätäite amarebti ni menteni nünanka juta mdara jire te tä tödeke kwatibe Ngöböbti nüke kwen mtare tie nere, niebare Jesukwe ni kwatiye kore. ");
INSERT INTO gymNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bti Jesu nikaninta ja jiebti amne ni Jesu käräkä käräkä abko nikaninta janknu, nikani nebeta nitre rükä dänkien känti angwane, ni klabore nitre rükä dänkienkwe, ye namaninante kuinta, btä nikani nebeta abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nebti Jesu nikani mda juta chi kädian nämane Naín känti nitre ja töitikaka benbe angwane, ni mda mda nikani kwati siba ben. ");
INSERT INTO gymNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nikani ngitiekä jukwebtä juta chi Naín yete angwane, mürü ngwäkä jäjatani doboi mikadre, jänükani ngätäi ben. Mürü ngwäkä ye abko, meri kän brare krütani abko ngobo ngörä itibe kwe ben nämane nüne abko krütani kän. Mden abko ngwäkä ngwian nämane abko ben ni mda mda nämane näin kwati uliere siba, nükani ngätäi ji ngrabare Jesube. ");
INSERT INTO gymNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Meri ngobo ngörä itibe kwe krütani kän, meri ye abko jatabare Jesuye amne namani ruentari tare kri Jesuye, käkwe niebare ie: Ma bobre, ngäbäkre krüta tare makän ne abko, akwa makwe ñan müai jakän, niebare kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ne btäräbe jänkwata bti mürü ngwäkä ngwian nämane, ye ken Jesukwe krötabare, bti kise mikani jänkwatabtä kwe mürü ngwäkä yeye. Abtä ni mürü ngwäkä ngwianka namani nünaninkä jökrä angwane, Jesukwe niebare mürü ngwäkä yeye: Ngäbäkre, nüketa nire tita niere mae, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Erere bkänä, mürü ngwäkä ye nükanintabe nire batibe. Ngäbäkre ye nükani täkänintbe krö, bti nikaninbe bliteta se kwrere. Bti Jesukwe bianinta meyeye ni kwati okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yebtä abko, ni jökrä namani nekwetekä, akwa namanintre Ngöbö käikitekä, kä namani niere krörö Jesubtä: Ni Ngöbö kukwei niekä kri nüke ni ngätäite nete mtare, köböire Ngöböta ni jen kwe die mike, namanintre niere, kä ngwiare nuäre jabtä Ngöbö käikitarekä kwärä se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesukwe mürü ngwäkä mikaninta nire, ye abko kädrie namani batibe jökrä Judeate ta temen btä kä kiakia te Judea bäre temen abko nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kukwe kuin ne namani bare Jesuye, ne abko nitre nänkä Juan Bautistabe nikani, käkwe niebare jire jökrä ie. Abtä Juankwe nitre nänkä ben, ye käräbare nibu ja känti, ");
INSERT INTO gymNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","bti ni nibu ye juani kwe ni Dänkien Jesu känti abko ni Dianinkä juandre Ngöbökwe ne abko Jesu ya, ñakare ya abko tö namani gai. Ñakare ne ngwane, ni mdara jire ngibiadre ngäbti ya, ño abko tö namani gai, käkwe ni juani nibu kukwe ye ngwentari Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Erere bkänä, ni nibu ye nükani Jesu känti, käkwe niebare krörö ie: Ni Dianinkä juandre Ngöbökwe rükadre ni ngätäite niebare, ye erere ma ara nükani ya o nunkwe ni mdara jire ngibiadre abko nun juanba ngwentari mae, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jesukwe kukwe kani ngäbti ñakare jötrö, akwa ne btäräbe ni kwati nämane ja tare nike bren bätäkä ngwarbe kisete abko Jesukwe mikaninta kuinta. Ni ruäre abko, btä üai käme nämane, kisete nämane ja tare nike abko Jesu namani juentari mento btä. Erere arato, ni kwati ie kä tuen ñakare abko ie Jesu namani kä mike tuenta ni juani nibu Juankwe ye okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Bti Jesukwe niebare krörö mda ni nibu yeye: Tita dre dre nuene tuata munkwe amne tita dre dre niere abko kukwei nuri munkwe, ye erere mun nän niereta Juanye. Amne munkwe nie krörö ie arato: Ni ie kä tuen ñakare abko ie kä nibi tuenta kuin amne, ni nakwente abko nibi dikekäta kuin kröta. Erere arato, ni bren bren lebra kisete abko kwata nibi nebeta kuin jökrä amne ni olo ngidianinte abko ie ni kukwei nibi ruenta kuin. Erere arato, ni krütanikrütani abko nibi nüketa nire amne ni bobre bobre abko ie Ngöbö kukwei kuin mika nibi gare abko munkwe nie Juanye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Erere arato, nire nire käta tödeke tibti amne ti ne ara nükani tä nütüre amne ñan tä trö kwite tie, ni ye abko ie Ngöbökwe ja di biandi amne kä rabadi nuäre btä tikwe nini abko munkwe nie kore Juanye. Abko kore se, niebare Jesukwe ni nibu yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ni juani nibu Juankwe nikaninta angwane, nitre nämane yete ye ben Jesu rikaba blite krörö Juanbtä: ¿Mun nikani ni ño tuakäre kä kaibete? ¿Mikä juankata mürekwe nekwäre sekwäre, ye käta ni töi kwitaka jene jene nekwäre sekwäre bä mike, ni se kwrere tua nikani munkwe ya? ");
INSERT INTO gymNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Mun jananbare Juan mike ñäräre angwane, ni ja ükaninte kuin käkwe dän ütiäte kri kitani jabtä nämane yete abko mun jananbare mike ñäräre ya? Ñakare, ñobtä ñan angwane ni dän ütiäte kri kitani jabtä, ni ye kwrere abko tä nüne jäme jrei gwiriete amne ñan tä nüne kä kaibete abko garera munye ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Akwa mun nikani ni ño mike ñäräre metre? ¿Mun nikani ni Ngöbö kukwei niekä mike ñäräre ñan ñan? Jänri, mun nikani ni kore mike ñäräre. Akwa Juan ye abko bäri Ngöbö kukwei niekä kri abko mun nikani tuen. ");
INSERT INTO gymNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan ye mdenbtä tärä tä tikani krörö Ngöbö Kukweibtä: Ngöbökwe niebare: Tikwe ja kukwei ngwianka juandi iti ma känenkri. Niarakwe ni töi mikadi biare ma käne, ji ükateta biare ye kwrere, abko tä tikani kore Juanbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne mden kisete, ti bike kukwe niere krörö munye: Ni jökrä därebare kä nebtä, ye ngätäite ni ñakare jire iti abko bäri ütiäte Juankrä; akwa nire nire bäri bobre, ütiäte ñakare, bti Ngöböta gobrane, ni ye abko bäri ütiäte Juankrä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jesukwe Juan mikani bäri ütiäte kore, abtä ni kwati Jesu kukwei nuaka nuaka amne nitre ngwian käräkä gobran romanobokrä nämane yete käkwe kukwe mikanintbe Ngöbökwe ni diantarikrä diribare Juankwe, ye abko era bä mikani, ñobtä ñan angwane niaratre käkwe ja mikani ngökadre ñöte Juanye aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Akwa nitre bariseo btä Kukwe Biani Ngöbökwe Moiséye dirikätre namani yete Jesu kukwei nuen arato amne kukwe mikanintbe Ngöbökwe ni diantarikrä diribare Juankwe, ye abko niaratre namani mike ngwarbe jae, ñobtä ñan angwane ñan ja mikani ngökadre ñöte kwetre Juanye, ñobtä ñan angwane nin namani moto ulire kukwe kämekämenbtä aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ni jökrä käkwe töbikabare ñakare ja kwrere Juanbtä kore, abtä Jesukwe niebareta ietre: Ne mdenbtä abko ni nünanka kä ne näire abko ti bike bä mike krörö: Kä jändrän rürümoinkrä jutate, känti ngäbäkre tä nebe täkänintbe temen, käta ñäke krikri mräkä mda mdaye, yebtä ti bike ni nünanka kä ne näire bä mike krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ngäbäkre tä niere mräkäye: Nunkwe nörä jürü tärä mikakrä munye, akwa mun ñan tö nibi tärä mikai. Abtä ka ni moto mikakrä ulire abko nunkwe nini mda, akwa munkwe müaniri ñakare arato abko ngäbäkreta niere. Ye mden kwrere munta niere Juanbtä amne tibtä, aisete tita nitre ye bä mike kore, ");
INSERT INTO gymNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ñobtä ñan angwane Juan Bautista nükani angwane, üai käme tä btä, aisete ñan tä mröre kri amne ñan tä dö ñaen, munta niere rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Yebti ti, Ni Kä Nebtä Ngobo rükaba mda angwane, ti abko mröre büle krikri amne ti dö ñaen krübäte munta niere tibtä. Mdakäre abko, ti ja getaka ni diän diän ben amne nitre jändrän ütiä käräkä gobran romanobokrä tä tuen käme munye abko ben tita ja gete, abtä munta ñäke ti rüere arato. Ye mdenbtä abko mun ngäbäkre kwrere tita niere. ");
INSERT INTO gymNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Akwa ni nüne töbtä era metre Ngöbö diebti nun kwrere, yebtä abko nun abko ni jen Ngöbökwe era metre abko nunta bä mike. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nebti bati, bariseo kädian nämane Simón käkwe Jesu ngwiani mröre ja gwiriete. Erere Jesu nikani, namani täkänintbe mesabtä Simón juete angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","meri bti kä ngwarbe nämane nüne juta ne arabe känti abko Jesu nükani mröre Simón gwiriete gani kwe. Angwane ñö rä bäne ütiäte kri kädian nämane nardo nämane jä bä ngwen kädianta alabastro dätebare boteare te, ye jänükani kwe Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Müare kwärä nikani ngitiekä Jesu ngotobtä temen, kä nikani Jesu ngoto bätete ni klabore kwrere, akwa ja okwä ñöibti bätäninte kwe. Jesu ngoto bätäninte ünän kwe, bti rötaninta kwe ja dokwä drüenbti, ngoto demainbare kwe, bti ñö rä bäne kekani kwe Jesu ngotobti, namani Jesu tarere kri mikakäre tuare ie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ye abko nakaninkä Simón, Jesu nübaikä mröre ja känti ye okwäbti. Abtä Simón namani töbike krörö mda Jesubtä: ¡Jo! Ni noko Ngöbö kukwei niekä bkänä ne ngwane, ni ño tä nuenbtä ngotobtä gadre kwe. Amne meri se bti kä ngwarbe ni jökrä tä kädriere kämekäme rükadre gare btä ie arato bä amarebti se, Simón namani nütüre kore Jesubtä. Ne Jesukwe gani Simónbtä, ");
INSERT INTO gymNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","abtä niebare mda kwe bariseo yeye: Simón, ti tö kukwe ngwiaintari kwati mae, niebare Jesukwe ie. Simón käkwe niebare mda Jesuye: ¿Abko dre? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ne btäräbe, Jesu nikaninbe kukwe bä mike meri yebtä Simónye: Bati ni nämane iti abko ngwian bkäne kri. Ni ye abko nämane ngwian bien ütiädre ni mda mdaye. Ni ye abko, ie ni nibu käkwe ngwian käräbare ütiädre ie. Ni iti, bti rürümon ütiä nämane siento krärike jire amne ni mda abko, bti rürümon ütiä nämane gre ketarike. ");
INSERT INTO gymNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Rürümon ütiä nämane krörö ni nibubti, akwa nin ngwian namani kwenta jire ietre biandreta ja ütiäreta. Abtä ngwian bkänkä käkwe niebare ietre: Tikwe ngwian bianba ütiädre munye, akwa ngwian ñakare munye biandreta ja ütiäre tie, aisete ti bike rürümon ütiä munbti ye käikwitekä jabti jökrä, niebare kore kwe ni nibu yeye. ¿Ni nibu ne mdenkwe ni ngwian bkänkä taredi bäri ruen mae? niebare Jesukwe Simónye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simónkwe niebare mda Jesuye: Ni bti bäri rürümon ütiä kri käikwitaninkä jabti ngwian bkänkäkwe, ni ye abko käta ngwian bkänkä tarere bäri raba ruen tie, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Bti meri ye nükani Jesu ngoto bätete, ye Jesukwe mikani ñäräre, käkwe niebare Simónye: Simón, ti nü gwi ma känti nete, makwe ti miri ngwarbe jae, käkwe nin ñö bini jire chi tie ja ngoto bätätekrä ti kakrä ngäbti, akwa meri ne nü, käkwe ti ngoto bätrite ja okwä ñöibti, bti rütüta kwe ja dokwä drüenbti, mike ñäräre makwe, btä makwe töbika. ");
INSERT INTO gymNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Erere arato, ti ki gwäkäre mae angwane, nin makwe ti demainiri jire ti kakrä ngäbti kuin, akwa ti ki gwäkäre amne, meri ne nikirabe ti demaine ngotobtä abti kä nüke nere. ");
INSERT INTO gymNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mdakäre abko, ti nü amne nin makwe olibo köi ütiä brai kiri ti dokwäbti ti kakrä ngäbti kuin, akwa meri ne abko käkwe ñö rä bäne ütiäte kri kiri ti ngotobti. ");
INSERT INTO gymNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Era metre meri ne käkwe ja mikani ngite kabre Ngöbö rüere bkänä akwa, tikwe niara ngite dininkä jire jökrä btä. Mdenbtä abko tä ti tarere bäri makrä bä mirita kore kwe, ni bti ngwian ütiä käikwitaninkä jabti ngwian bkänkäkwe ye kwrere abko ti tö nibi niei mae Simón, ñobtä ñan angwane ni ngite ñakare bökän diankata nibtä, ni ye abko ñan tä ni tarere dikaro. Abko kore se, niebare Jesukwe Simónye. ");
INSERT INTO gymNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bti Jesukwe niebare mda meri yeye: Ma ngite kukwe kämekämenbtä, ye tikwe dininkä jökrä mabtä, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abtä ni mda mda nämane siba yete, ye namani niere krörö jae kwärikwäri: ¿Ni noko nire amarebti tä ni ngite denkä nibtä tä niere sere? namanintre niere kore Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Akwa Jesu abko nikani niere janknu krörö meri yeye: Ma nibi tödeke kwatibe tibti, köböire kukwe kämekäme btä ma ngite, ye tikwe dininkä mabtä, aisete nänta jäme, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nebti Ngöbö jatanina nüke gobrane nibti abko kukwe kuin Jesu nikani niere juta krikrite amne juta kiakiate kä Galileate ta temen. Ye ngwane, nitre ja töitikaka Jesube ni jätäbti nibu nämane näin siba ben. ");
INSERT INTO gymNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Erere arato, ni merire merire bren bren mikaninta kuinta Jesukwe, ruäre abko btä üai käme juanintari kwe, ye abko nämane näin ruäre. Ni merire nämane näin siba Jesube abko nere: María Magdalabo, María ne mdenbtä Jesukwe üai käme krä kükü juanintari mento. ");
INSERT INTO gymNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Arato Juana nämane näin siba. Juana ne abko ni iti kädian nämane Chuza merie. Chuza abko ju ngibiabtikä jrei Herodes Antipas kräke. Arato Susana nämane näin siba. Ye ngwane meri mda mda nämane näin kwati siba abko jändrän nämane kwekwe, erere bti nämane Jesu btä nitre ja töitikaka ben die mike. ");
INSERT INTO gymNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ne ngwane bati ni nünanka juta ketareketare Galilea temen namani nüke ja ükekrö kwati ja tuakäre Jesube abko ie Jesukwe kukwe bä mikani krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Bati ni nikani iti nura metekä. Nura metaninkä kwe angwane, nura ruäre nikani mate ji ngrabare temen. Nura ye abko ni jatani, käkwe rätäbare jökräbti. Bärire mda abko nukwä jatani, käkwe kwetani jökrä kän. ");
INSERT INTO gymNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nura ruäre abko nikani mate jäkwatabti temen abko nükani mure, akwa dobo nötare dikaro, aisete ngrötaninkä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nura ruäre abko nikani mate kökrä tukwätetukwäte ngätäite, ye abko nükani mure arato, akwa kökrä ye abko rirabare bäri jötrö nura mu yebti ta, käkwe kämikani. ");
INSERT INTO gymNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Akwa nura nikani mate dobo kuinte, ye abko nükani mure amne rirabare tuärebe, bti ngwä nikani nebe btä btä amne datire datire ngwä namani gre ketarike. Ne abko nakaninkä kore, niebare Jesukwe ni kwatiye kore. Ye btäräbe, Jesukwe ñäkäbare jume ja dibti krörö mda ni kwati yeye: Nire nire käta ti kukwei nuen, ye abko olo tärä ne ngwane, ti kukwei ne ketate ja olote kwe, kukwe ne rükadre gare kuin munye abkokäre. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jesukwe kukwe bä mikani kore ne ñan nükani gare nitre ja töitikaka benye, käkwe niebare ie: Makwe kukwe bä miri, ye abko dre bä miri kore makwe yere, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Abtä Jesukwe niebare mda ietre: Ngöbö rükadre gobrane ño nibti abko tä tiebe, akwa Ngöböta mike gare munye, akwa ni mda mda abko ie Ngöböta mike gare ñakare, aisete tita kukwe bä mike kore, Ngöbö Kukwei tä tikani krörö rabadre bare abkokäre: Nebtä nikradre bäri kwetre, akwa kukwe ño ñan jatadre metre ietre amne ni kukwei nuadre bäri kwetre akwa, ñan rükadre gare ietre, abkokäre tita kukwe bä mike kore ietre, Ngöbö kukwei niekä kirakira käkwe niebare ni nebtä ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kukwe nini tikwe ye abko tä kukwe krörö bä mike: Ngöbö Kukwei abko nura kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amne nura nikani ngitiekä ji ngrabare temen, ye abko ni ruäre tä Ngöbö Kukwei nuen akwa, diablu tä kite, käta Ngöbö Kukwei ye denkä jökrä töite, ni ye käkwe ñan Ngöbö Kukwei mikadre era amne ñan rabadre dianintari abkokäre, mden nini tikwe ye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amne ni ruäre abko käta Ngöbö Kukwei nuen amne käta nebe nuäre btä kare ngäbti. Ni ye abko nura nikani mate jäkwatabti ye kwrere, ñobtä ñan angwane nura nikani mate jäkwatabti abko ngätri ñan nämane bökän, ye kwrere jire ni ruäre tä Ngöbö Kukwei kaen ngäbti, bti bä jötrö tä tödeke Ngöböbti. Tädre niken ja tare nike tödekabtä Ngöböbti amne käta Ngöbö Kukwei kiteta temen, bti tä nikenta ja jiebti. ");
INSERT INTO gymNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amne ni ruäre abko tä Ngöbö Kukwei nuen, akwa tä nakwen bäri jändrän kä nebtä jiebti amne, tä ngwian tarere bäri amne jändrän nuäre nuäre kä nebtä yebtä tä ja kite, ye abko käta ngökö. Ne aisete ni ye abko nura nikani mate kökrä tukwätetukwäte ngätäite amne ngatani, ye tä nakenkä ni yebtä, aisete nura ngatani ngwä namani ñakare, ye kwrere jire ni ye tä sribi nuene ñakare Ngöbökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Akwa nura nikani ngitiekä dobo kuinte, ye abko ni töi kuin amne tä biare, käta Ngöbö Kukwei nuen angwane, tä ketete dime jabtä amne tä nünenkä dite btä. Ni ye abko nura ngwäta neme kuin ötata kabre, ye kwrere jire ni yeta jändrän kuin nuene Ngöbökrä. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesukwe niebareta: Ni ñakare jire iti käta ñotra jutra mike abti tä jue miketa kaja täni. Erere arato, ñan tä mike jän täni jae, akwa ñotra jutra mikata angwane, mikata üräbtä käin trä rabadre ngitie jökrä gwita temen, ni jökrä gwi, ie kä rabadre tuen abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ye kwrere arato, tita kukwe jire jökrä dirire kaibe tiebe munye mtare, akwa batira jire munkwe mikadi gare ni jökräye. Erere arato, kukwe diribare tiebe tikwe, batira jire rabadi gare metre ja ngwärekri jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ne aisete olo ketete kuin ti kukweiye munkwe, ñobtä ñan angwane nire nire ie Ngöbö Kukwei nüke gare, ye abko ie Ngöbökwe ja Kukwei biandi bäri mda; akwa nire nire ie Ngöbö Kukwei gare ñakare, ye abko ie Ngöbö Kukwei gare kiakia abko Ngöbökwe diandikä jökrä kän. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ye ngwane, Jesu meye amne etbakantre abko nikani jiebti ja tuakäre ben angwane, ni nämane kwati Jesu bäre temen, aisete niaratre ñan namani nebe Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Angwane ni iti käkwe niebare Jesuye: Ma meye amne ma etbakantre tä ju bäre nokote abko tö nibi blitai mabe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesukwe niebare ni jökräye: Nire nire tä Ngöbö Kukwei nuen, erere tä mike täte, ni ye abko ti meye tikwe amne ti etbakantre tikwe era metre, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Abti bati Ñö Okwä Kri Galilea känti Jesu nakwani rute, käkwe niebare nitre ja töitikaka benye: Brän ñö okwä kwärä sekri, niebare kwe. Ye erere nikanintre. ");
INSERT INTO gymNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nikanintre ñöbti angwane, Jesu nikani kibien. Batibe müre jatani mate ribi krübäte ñö okwä ye känti, ye abko namani ñö kite jökrä rute, aisete ru jatani niken ñöte nguse se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yebtä abko nitre ja töitikaka ben nikani gaenkrö, käkwe niebare ie: ¡Dirikä, ni kite niken ñöte nguse! niebare kwetre Jesuye. Angwane Jesu nükaninta krö, käkwe ñäkäbare müreye amne ñöye. Ye btäräbe, müre amne ñö namani kwekbe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bti Jesukwe niebare nitre ja töitikaka benye: ¿Munta tödeke kwatibe Ngöböbti ya ño yere? niebare kwe ietre. Akwa niaratre abko namani nekwetekä krübäte amne töi ñan namani krütare, kä namani niere jae kwärikwäri: ¿Ni ne abko ni ño amarebti tä ñäke müreye amne ñöye amne, tä niara kukwei mike täte se? namani niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nebti niaratre nikani janknu rute ñöbti nebe käkä Gadarete Ñö Okwä Kri Galilea kwäräkri. ");
INSERT INTO gymNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu nämane rute, nikani jate angwane, juta yete ni nämane iti abko btä üai käme nämane abko jatani Jesu ngäbti. Raire abko ni ye nämane dän kite ñakare jabtä amne nämane nüne ñakare gwi, akwa nämane nüne rökabti. ");
INSERT INTO gymNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesu jatabare ie angwane, nikani ngitiekä ngukudokwäbti temen Jesu ngwärekri, käkwe ngratebare kri krörö: Jesu, Ngöbö Kri Kä Käinbti Odei, ¿ye ñobtä ma kite ti nike nete ye? Makwe ñan ti mika ja tare nike abko ti tö nibi ribei mae, namani niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Üai käme rikadre mento btä abko Jesukwe niebarera ie, aisete namani ñäke krikri kore. Batire batire üai käme nämane niken ni yebtä angwane, ñan gitiadre künken, abkokäre kise amne ngotokwä mäkäte nämane jökrä ie kadenanbti, akwa nämane kadena ötöte jökrä angwane, üai käme nämane niken ngwena kä kaibete. ");
INSERT INTO gymNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ni ye abko ie Jesukwe niebare: ¿Ma kä ño? niebare kwe ie. Angwane üai kämentre käkwe niebare mda ie: Ti kä Kabre, niebare kwetre. (Ja kä Kabre, niebare kwe, ñobtä ñan angwane üai käme nämane kabre btä aisete.) ");
INSERT INTO gymNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ye mden käkwe ñan ja juamna kä ja tare nikakrä te Kä Timonbti Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ye känti abko mtü nämane kabre krübäte mröre bä känime ngudrebtäta, aisete üai kämenkwe ja juamna mtü yebtä Jesuye, erere Jesukwe juani mtübtä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Üai käme nämane nibtä, ye abko nikani mento btä, bti nikani mda mtü kabre yebtä. Ye btäräbe mtü kabre ye nikani betekä jökrä ja jiebti kä btä motokwäre, nikani ngitiekä jökrä ñöte, känti müre neketani jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nitre mtü ngibiaka abko okwäbti kukwe nakaninkä kore. Yebtä abko niaratre nikani betekä ngitie, kä nikani kukwe ye niere jökrä juta ngrabare temen amne juta bäre mento arato. ");
INSERT INTO gymNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Abtä kukwe nakaninkä ño abko ni kwati nükani tuen, känti nikanintre nebe Jesu känti angwane, ni btä üai käme nämane abko nikani mento, ni ye abko käkwe dän kitani jabtä amne kä namani ruenta kuin bti nämane täkänintbe Jesu ken, btä namanintre angwane, kä jürä namani kri btätre. ");
INSERT INTO gymNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Angwane ni btä üai käme nämane ye abko namaninta kuinta ño abko nitre tuakatuaka namani niere jökrä ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yebtä abko, Jesu di kri krübäte gani kwetre, aisete kä jürä namani kri nitre Gadarabobtä, aisete jötrö ngwarbe Jesu rikadre kä mdabti abko namanintre ribere ie. Ye erere Jesu nakwaninta rute nitre ja töitikaka benbe, bti nikaninta. ");
INSERT INTO gymNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Akwa Jesu ngämi nikenta, känenkri ni btä üai käme nikani mento ye abko Jesu rikadre ngwena jabe abko namani ribere Jesuye, akwa niara rabadre jirekäbe yete, Jesukwe niebare ie. Angwane Jesukwe niebare krörö mda ie: ");
INSERT INTO gymNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Nänta jirekäbe ja gwiriete amne Ngöbökwe dre nuni makrä, ye erere makwe nie jökrä ni mda mdaye. Abko kore se, niebare Jesukwe ie. Ye erere bkänä, Jesukwe dre nuenbare niara kräke, erere nikani niere jökrä juta ngrabare temen. ");
INSERT INTO gymNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yebti Jesu nikani nebeta Ñö Okwä Kri Galilea kwäräkri mda angwane, ni nämane kwati ngibiare ngäbti, aisete kä namani nuäre btätre Jesu kare ngäbtita. ");
INSERT INTO gymNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ye btäräbe ni kädian nämane Jairo nükani Jesu känti. Jairo abko nämane sinagoga dänkiene juta yete abko jatani, nikaninbe ngitiekä ngukudokwäbti temen Jesu ngotobtä ja mikakäre bobre btä, kä namani Jesu ngwen kisere nebe ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ngänkän itibe kwe abko ie kä kwä jätäbti kubu abko jatani krüte kän, aisete namani Jesu ngwen ja känti. Ye erere Jesu nikani angwane, ni nikani kwati krübäte ben, kä namani kete dime ja ngätäite, namani ruen ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Angwane nitre nikani kwati Jesube, ye ngätäite meri nämane näin iti siba abko kä kwä jätäbti kubura nämane bren dbä tibiere abko kisete nämane ja tare nike amne, ngwian nämane kwe, erere ganinte jökrä kwe kräkäbtä jakrä akwa, ñakare namani nökröta nitre kräkä biankaye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Te meri ye abko nikani, käkwe krötabare ja ken Jesu trökri, käkwe dän Jesubtä nuaninbtä tiebe köräbtä. Ye btäräbe namaninta kuinta batibe se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Angwane Jesukwe niebare: ¿Nirekwe dänkä nuribtä tibtä ye? niebare kwe. Akwa ni jökrä namani ja rükente. Abtä Pedrokwe niebare Jesuye: Dirikä, ni kwati nibi ma kete dime ja ngätäite, kä nibi ma kitekä nekwäre, sekwäre. ¿Ye ñobtä abko nirekwe ma nuribtä ma nibi niere yere? niebare Pedrokwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Akwa Jesukwe niebareta mda: Ni iti käkwe ti nuribtä tikwe gari, ñobtä ñan angwane Ngöbö di tä tibtä abko niki ruäre mento tibtä, nibi ruen tie, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Angwane meri ye käkwe ja rükandrete ño mda ñan namani nüke gare ie, akwa kä jürä namani btä. Abtä namani grükekä jökrä ngrabare, nikani, namani ngukudokwäbti temen Jesu ngotobtä ja mikakäre bobre btä angwane, ñobtä Jesu nuaninbtä kwe amne namaninta kuinta ño abko niebare jökrä kwe ni jökrä ngwärekri Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Angwane Jesukwe niebare mda ie: Ti mräkä, makwe tödiri kwatibe tibti, köböire ma nibirate kuinta, aisete nänta jäme, niebare kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu nämane blite kore angwane, sinagoga dänkien ye jiebti ni mdara jire nükani kukwe ngwena, käkwe niebare ie: Ma ngänkän kürera makän. Makwe ñan dirikä nika mda, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Blitabare kore kwe, ye jarabare Jesuye angwane, Jesukwe niebare: Ma ñan rekwetaka ngäbäkre jiebti jakän, akwa makwe tödeka kwatibe janknu tibti angwane, ma ngänkän rabadita kuinta, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yebti nikanintre nebe gwi angwane, Jesukwe Pedro, Santiago, Juan amne meri bati ye rün amne meye aibe tuanimetre niken nebe gwi jabe. ");
INSERT INTO gymNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Angwane ni jökrä nämane meri bati krütani ye uliere amne müaire krikri be gwi, btä Jesu namani. Akwa niarakwe niebare ietre: Ngäbäkre merire ye kürera munta nütüre, akwa tä kibien, aisete munkwe ñan müai mda, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Akwa meri ye krütani bkänä namani gare ietre, aisete namanintre Jesu kötaire jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Akwa Jesu nikani, käkwe meri ngwäkä ye kani küdebti, bti ñäkäbare krörö kwe ie: Ti ngänkän, ¡Näin krö! niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ye btäräbe üai nükanintabe btä, aisete nükanintabe nire angwane, nükaninbe täkänintbeta krö, bti Jesukwe bukamna mräkäye. ");
INSERT INTO gymNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Meri bati mikaninta nire kore Jesukwe, yebtä abko rün amne meye ñan töi namani krütare mda. Akwa kukwe nakaninkä ño, ye abko ñan kädriedre jire kwetre ni mda mdabe, Jesukwe niebare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yebti Jesukwe nitre ja töitikaka ben ni jätäbti nibu ükaninkrö, bti Ngöbö die biani kwe ietre üai käme bätäkä ngwarbe juantarikrä mento amne ni bren bren mikakräta kuinta arato. ");
INSERT INTO gymNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Bti Ngöböta gobrane ni ngätäite kädriedre kwetre amne ni bren bren mikadreta kuinta kwetre, abkokäre Jesukwe juani, ");
INSERT INTO gymNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","käkwe niebare krörö ietre: Mun ñan rika tribe ngwena jire chi mda jabtä ji ngrabarekäre abko krörö: Mun ñan rika mökän amne kra ngwena jae. Erere arato, mun ñan rika mrö, ngwian amne dän mda ngwena jae, ñobtä ñan angwane munkwe tödekadre Ngöböbti, ie ti tö aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ju mdente mun raba nünentbe, ye aibe känti mun raba. Mun ñan rika ju kwatirekwatire te, akwa mun raba ju kwatibe te, abti mun rikata. ");
INSERT INTO gymNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Akwa juta känti mun ñan ka tö raba ngäbti ni mdakwe, ye känti munkwe kä mikaka, akwa munkwe dobro mnü ngrükate ja ngotobtä, nitre ye ara jire ngite Ngöböye ja töi jenbti bä mikakrä ietre, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ye erere nitre ja töitikaka Jesube nikani juta kwatirekwatire kä ngrabare temen kukwe kuin Jesubtä ye kädriere amne, nikani ni bren bren miketa kuinta arato. ");
INSERT INTO gymNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kukwe namani nakenkä kore Jesu köböire, ye gani Herodekwe angwane, nire köböire nämane nakenkä ñan namani nüke gare ie, ñobtä ñan angwane Ngöbökwe Juan Bautista mikaninta nire abko ni ruäre namani niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Akwa Ngöbö kukwei niekä kira kädian nämane Elías abko nükaninta ni ruäre namani niere. Mdakäre abko, Ngöbö kukwei niekä kira mda abko nükaninta nire, ni mda namani niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Abtä Herodekwe niebare: ¿Tikwe Juan dokwä tikakamna, aisete ni ye ñakare Juan amarebti nire abko btä blitata krübäte dikaro kore ne? niebare Herodekwe. Yebtä abko Herodes tö namani ja tuai Jesube. ");
INSERT INTO gymNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Abti nitre juani ja kukwei ngwianka Jesukwe ye nükaninta jökrä Jesu känti angwane, dre dre nuenbare kwetre, ye erere niebare jökrä kwetre Jesuye. Abti Jesukwe käräbare jenena angwane, nikani ngwena kä kaibete juta Betsaidate. ");
INSERT INTO gymNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Akwa Jesu nikani ye abko ni kwati käkwe gani angwane, nikani niaratre jiebti amne, Jesukwe kani ngäbti kuin, bti Ngöböta gobrane ni ngätäite, yebtä Jesukwe blitabare bentre amne ni bren bren abko mikaninta kuinta kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Yebti kä jatanina dere angwane, nitre ja töitikaka Jesube ni jätäbti nibu nikani, käkwe niebare ie: Nita kä kaibete nete, jändrän ñakare kwetadre, aisete nitre se juenta jökrä jadüke amne mrö känene jae juta käntikänti sete kä ngrabare temen, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Abtä Jesukwe niebare mda ietre: Niaratre buka munkwe, niebare kwe ietre. Abtä niebare kwetre ie: ¿Banta kunrikebe amne gwata krobube nikwe, se abko biandre ño ietre? ¿Ni kwati se kräke, ni rikadre mrö kökö ya? niebare kwetre mda Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ye ngwane abko, ni brare aibe nämane mili krärike jire, akwa Jesukwe niebare mda nitre ja töitikaka benye: Nitre ye mika täkänintbe gre ketebu bti ni jätä jätä ja täritäri, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ye erere Jesu kukwei mikani täte kwetre, käkwe nitre mikani täkänintbe jökrä temen temen. ");
INSERT INTO gymNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bti Jesukwe ban kunrike amne gwa krobu diani kisete, käkwe nikrabare kä käinbti, kuin niebare kwe btä Ngöböye, bti ñäkänintbe kiakia kwe, bti biani kwe nitre ja töitikaka ben yeye dräidre ni kwati yebti. ");
INSERT INTO gymNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Angwane ni jökrä käkwe mröbare, namani trinetrine, bti ban amne gwa oto namaninte abko ükaninkrö kutia kwä jätäbti kubu jire. ");
INSERT INTO gymNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yebti bati Jesu nämane blite kaibe Ngöböbe angwane, nitre ja töitikaka ben nämane yete ben abko ie niebare krörö kwe: ¿Ti ne abko nire nieta ni mda mdakwe tibtä? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Angwane nitre ja töitikaka ben käkwe niebare ie: Ma abko Juan Bautista nükaninta nire nieta ni ruärekwe amne ni mda abko käta ma Elías nükaninta niere mabtä. Akwa ni mda abko tä niere Ngöbö kukwei niekä kirakira mda mda abko nükaninta nire nieta kwe mabtä, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesukwe niebare mda ietre: ¿Amne mun abko käta ti nire niere tibtä? niebare kwe ietre. Angwane Pedro abko käkwe niebare Jesuye: Ma abko Ni Dianinkä Ngöbökwe ara, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pedrokwe niebare kore, abtä Jesukwe niebare mda ietre: Akwa kukwe ye abko ñan niedre jire kwetre ni mda mdaye, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Bti Jesukwe niebare krörö ietre: Nitre unbre ji dokwäte, nitre blitaka Ngöböbe ni mda mda diäre dänkien amne Kukwe Biani Ngöbökwe Moiséye dirikätre, käkwe ti Ni Kä Nebtä Ngobo ne mikadi ja tare nike kri amne trö kwitadi kwetre tie, käkwe ti müre ketadi, akwa köbömäkäre angwane, ti rükadita nire, niebare kwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yebti Jesukwe niebare ni jökrä nämane yete yeye: Nire nire tö ja töi mikai kwatibe nänkrä tibe, ni ye abko tö dreye jakrä abko raba käikwitekä jabti amne, köbö kwatirekwatire ja kwata raba ruentari tare ñakare ie nünakäre tikrä abko jata ti jiebti, ");
INSERT INTO gymNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ñobtä ñan angwane nire nire tö ja kwata ngibiai jen jakrä abko krütadi kärekäre, erere rabadi kärekäre Ngöbö okwä bäre mento. Akwa nire nire krütadi ti dokwäre abko rabadi dianintari nünakäre kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ye abko, ni rabadre jändrän jökrä bkäne kabre kä nebtä, akwa ni krütadre angwane nikwe ñan nünandre mda Ngöböbe, ne ütiäre abko dre rükadre nie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ne aisete, nire nire käta ti rükente amne kukwe dirita tikwe ne rükente angwane, ti Ni Kä Nebtä Ngobo ne jatadita angwane, tikwe ni ye rükandite arato. Ti jatadita angwane, ti jatadita ja di kri bä nuärebti amne Ngöbö di kri bä nuärebti, erere arato angele deme Ngöbökwe bä nuärebti. ");
INSERT INTO gymNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Akwa mun tä nete ne ruäre ngämi krüte, känenkri Ngöböta gobrane ño nibtä, ye abko munkwe tuadi ja okwä jenbti abko ti tö nibi niei metre munye, niebare Jesukwe ni jökrä nämane yete yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesukwe kukwe niebare kore, yebti kwäirare Jesu nikani ngitiobti blitakäre Ngöböbe angwane, Pedro, Santiago amne Juan nikani siba ben. ");
INSERT INTO gymNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesu nämane blite Ngöböbe, te batibe ngwäre bä nikwitani jene amne dän btä abko trä namani ngwen bürere mera trä bä kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ye btäräbe ni nibu namani gökökä yete blite Jesube. Ni nibu ye abko Moisés amne Elías. ");
INSERT INTO gymNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Niaratre nämane ye bäre temen kä trä namani kuin bä nuäre amne Jesu tädi Jerusalén, känti näinta kä käinbti abko btä nämane blite kä ye känti. ");
INSERT INTO gymNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ye ngwane abko Pedro, Santiago amne Juan okwä namani doboko köbö kisete angwane, batibe nükaninta ngwäte angwane, Jesu bä dite amne nuäre tuani kwetre. Erere arato, Moisés amne Elías tuani kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ni nükani nibu Jesu känti, ye jatanina nikenta angwane, Pedrokwe niebare Jesuye: Ti Dänkien, nita nete abko käi nibi nuäre tibtä, aisete ma tö ne ngwane, nunkwe ju mikadi kiakia komä munkrä: kwati makrä, kwati Moisékrä amne kwati Elíakrä, niebare kwe. Pedro abko käkwe ñäkäbare kore akwa, drebtä nämane blite abko ñan nämane gare ie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro nämane blite kore, ye btäräbe müta jatani jüben niaratrebti angwane, kä jürä namani krübäte niaratre nimäbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Angwane müta yete ni kukwei jarabare krörö ietre: Ni ne abko ti Odei tikwe. Ne mden tikwe dianinkä jakrä, aisete niara kukwei nua munkwe abko ni kukwei namani kore mütate. ");
INSERT INTO gymNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ni kukwei jarabare kore angwane, ni nibu ye nikaninta angwane, Jesu aibe namaninta kaibe. Kukwe nakaninkä kore, ye abko nitre ja töitikaka Jesube käkwe tuani, akwa ükani kaibe kwetre jakrä, aisete kä ye ngwane niebare ñakare kwetre ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jesu nämane ngitiobti nitre ja töitikaka nimäbe, bti jändrinane jataninta motokwäre angwane, ni nükani kwati ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ni kwati ye ngätäite ni nämane iti käkwe ngratebare jume, käkwe niebare Jesuye: Dirikä, ti ngobo ngörä itibe tikwe noko jakwe tuen känti tikrä abko tita ribere kisere mae, ");
INSERT INTO gymNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ñobtä ñan angwane üai käme ie niarata neketete, käta mike ngrente kri amne, btäräbe tä kä ötöte bti amne tä kitekä nekwäre, sekwäre amne däbe tä neme betekä kadate. Erere arato, ñan tä nebe gibiekä, ye abko tä mike ja tare nike tikän. ");
INSERT INTO gymNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Abtä nitre ja töitikaka mabe käkwe üai käme juandretari mento btä abko tikwe ribeba kisere ietre, akwa üai käme ñan rikaba mento ietre, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Abtä Jesukwe niebare ietre: ¡Aingwaree, ti moto iko munbtä! Mun ye ño abko moto kämekäme dikaro abti munta tödeke ñakare dikaro Ngöböbti ye. ¿Ti rabadi kä nuäi mda munbe amarebti ye? niebare Jesukwe. Ye btäräbe Jesukwe niebare mda: Ngäbäkre ye ngwen tie, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ye erere, ngäbäkre jänikani nebe ja ken Jesube angwane, üai kämenkwe kitaninta temen amne kä ötaninteta bti kwe, akwa Jesukwe ngratebare üai kämenbti, btäräbe ngäbäkre ye namaninta kuinta angwane, Jesukwe bianinta rünye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ngöbö di kri köböire ngäbäkre namaninta kuinta, yebtä abko ni jökrä ñan töi namani krütare. Ni jökrä ñan töi namani krütare kore angwane, Jesukwe niebare nitre ja töitikaka benye: ");
INSERT INTO gymNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Olo ketete kuin ti kukweiye munkwe amne munkwe ñan käikwitaka jabti. Jötrö ti, Ni Kä Nebtä Ngobo biandi müre ketadre ni mda mdaye, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Akwa dre niebare kore kwe, ye abko ñan nükani gare nitre ja töitikaka benye, ñobtä ñan angwane kukwe niebare Jesukwe, yebtä abko Ngöbö ngämi töi tikekä, aisete ñan nükani gare ietre. Mdakäre abko, namaninta ja gaire kukwe ye ngwiantarita Jesuye, aisete namaninta kwekbe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ye ngwane abko, nitre ja töitikaka Jesube mden bäri ütiäte, abkobtä nikani ja kwete kwärikwäri mda. ");
INSERT INTO gymNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Angwane nämane töbike ño, ye gani btä Jesukwe. Abtä Jesukwe ngäbäkre chi käräbare, mikani täkänintbe ja ken kwe, ");
INSERT INTO gymNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","bti niebare krörö kwe ietre: Nireta ütiäte ñakare ni mda mda okwäte ngäbäkre chi ne kwrere, ye nireta kaen ngäbti ti käbti, ye abko ti ara jire kata ngäbti kwe amne, nireta ti kaen ngäbti ja dänkiene, ye abko Ngöbö ti juanka abko kata ngäbti kwe arato. Ne aisete mun jökrä ngätäite, nire nire tuen ütiäte ñakare munye, ni ye abko bäri ütiäte Ngöbö ngwärekri. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Angwane Juan abko käkwe niebare: Dirikä, nunkwe ni tuaba iti üai käme juentari ma käbti, akwa niara tä nekete ñakare nibe, aisete ñan üai käme juandretari mda kwe ma käbti, nunkwe nieba ie, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Abtä Jesukwe niebare mda: Nireta sribire ñakare mun rüere, ye abko tä nekete munkri, aisete munkwe ñan sribi ye kwrere dokwä täkä mda kän, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Abti Jesu rikadreta kä käinbti abko köböi jatani nüke ja ken, aisete niarakwe ja töi mikani kwatibe nikenta Jerusalén. ");
INSERT INTO gymNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Angwane Jesukwe ni juani ruäre ja käne kä känene juta Samariate nünantbekrä jae. Akwa ");
INSERT INTO gymNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jesu nämane näin Jerusalén kukwäre, ye gani nitre Samariabokwe angwane, Jesu kani ngäbti ñakare kwetre, ñobtä ñan angwane nitre israelita amne nitre Samariabo nämane rüre jabe kwärikwäri aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nitre Samariabo käkwe ñan Jesu kani ngäbti, ye gani Santiagokwe amne Juankwe angwane, niebare kwetre Jesuye: Dänkien, niaratre ñan tö ma kain ngäbti, ye dokwäre Ngöbökwe ñukwä kä käinbti juandre käkwe nitre se gadrekä jökrä abko nunkwe kärädre Ngöböye, ¿ie ma tö nibi ya? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Abtä Jesu nikwitaninte, käkwe mäträbare btätre. ");
INSERT INTO gymNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yebti nikanintre juta mdate. ");
INSERT INTO gymNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Niaratre nämane dikekä ji ngrabare angwane, ni iti käkwe niebare Jesuye: Ti Dänkien, ma näin mdente erere, ye känti ti rikai siba mabe, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Abtä Jesukwe niebare mda ie: Nukro känsenta, kwe kä mkä tärä nünankrä amne, nukwä nikenkä käinta abko juda tärä kwe nünankrä arato, akwa ti Ni Kä Nebtä Ngobo ne abko kwe kä ñakare jire chi jadükakrä. Ne aisete ma tö jatai tibe ne ngwane, ma rabadre juto biare nüne ti kwrere arato, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bti Jesukwe niebare ni mdaye: Brän tibe, niebare kwe ie. Akwa ni ye abko käkwe niebare Jesuye: Ti Dänkien, ti tuemetre nikenta ken ja gwiriete, abti ti rün krütadi, tikwe doboi mikadi, ye täbti ti näin mabe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Abtä Jesukwe niebare ie: Nitre ie Ngöbö gare ñakare abko tä ni ngwäkäre kwrere Ngöbö ngwärekri, ye tuametre ni ngwäkäre doboi mike. Ma abko Ngöböta gobrane ño nibtä, ye abko ma rika kädriere ni mda mdabe, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Abti ni mdara jire käkwe niebare Jesuye: Ti Dänkien, ti tö rikai mabe akwa, ti ngämi niken känenkri ti tö rikai ja tuaita niere ti mräkäye, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Abtä Jesukwe niebare ni neye: Ni sribikä tä niken dobro tikekä aradorebti akwa tä nikrenta ja jiebti, ye ñan tä sribire kuin metre, aisete sribi rabai ngwarbe, aisete nire nire töita niken jändrän mda mda jiebti, ni ye kwrere abko ñakare kuin sribikä kä gobrankrä Ngöbökwebtä. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yebti ni Dänkienkwe ni mdara jire dianinkä gre ketamä bti ni jätä. Jesu rikadre juta mdente mdente, ye känti Jesukwe ni ye juani nibu nibu ja känenkri. ");
INSERT INTO gymNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Akwa käne abko ni kwati nämane juto biare kukwe kuin mike era, abkobtä kukwe bä mikani krörö, käkwe niebare ietre: Nura nena biare kabre ötadre, ye kwrere ni kwati tä juto biare ngwiandre Ngöböye, akwa sribikä ñakare bökän, aisete sribi Bkänkä Ngöbö käkwe sribikä mda mda juandre jötrö sribire abko munkwe ribe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Akwa mun nän. Obeja ngäbälita niken lobo ngätäite, ye kwrere tita mun juen ni krübäte krübäte ngätäite. ");
INSERT INTO gymNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mdakäre abko, mun rika angwane, mun ñan rika ngwian ngwena jabtä. Mun ñan rika kra ngwena jae amne mun ñan rika sabato mda ngwena jae. Erere arato, munkwe ñan kä gate ngwarbe köbö ngwentari ji ngrabare ni mda mdaye nünankakäre raire ji ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Akwa ju mdente mun rika nebe, känti munkwe köbö ngwiantari käne, käkwe nie krörö: Kä jäme Ngöbökwe raba munbtä, nie munkwe. ");
INSERT INTO gymNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Angwane ni nünanka gwi yete tädi biare kä jäme Ngöbökwe ye kaen ngäbti ne ngwane, kadi ngäbti kwe; ñakare ne ngwane, ñan kadre ngäbti kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ju mdente mun raba, ye känti mun raba nünentbe. Munkwe ñan ja kwita ju mda mdate. Mdakäre abko, mrö mden mden kwetata kwetre, erere te mun buka angwane, munkwe kweta, ñobtä ñan angwane ni sribikä abko ie sribi ütiä biandre abko erere munkwe mrödi sribi munkwe ütiäre. ");
INSERT INTO gymNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Erere arato, juta mdente mun raba, ye känti mrö mden mden te mun buka, ye munkwe kweta jäme jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Angwane ni bren bren tärä juta yete ne ngwane, munkwe mikata kuinta amne, Ngöbö kebera nüke gobrane ngätäite abko munkwe nie ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Akwa juta mden känti mun raba angwane, nitre yete käkwe ñan mun ka ngäbti, yebtä abko mun rikata jibti ñäkäre kwärä krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Dobro mnü juta munkwete nete neketaninkä nun ngotobtä abko nunta ngrükete mun ngwärekri jökrä nete. Ne abko mun ñan tö Ngöbö kukwei kain ngäbti, aisete mun ara jire ngite Ngöböye ja töi jenbti bä mikakrä, ye raba gare munye. Akwa Ngöbö kebera nüke gobrane mun ngätäite, ye raba gare munye, aisete munkwe nie kore ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Akwa köbö mrä näire, nitre Sodomabo käkwe ja tare nikadi, yebti ta nitre nünanka juta yete käkwe ja ngie nuadi abko ti tö niei munye, niebare Jesukwe nitre juani kwe yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bti Jesukwe niebare mda: ¡Aingwaree mun nünanka juta Corazínte amne juta Betsaidate! Mun bobre jakän, ñobtä ñan angwane sribi kri ñan tuabare nuenbare tikwe mun ngätäite, ne kwrere nuendre juta Tiro amne Sidón känti, akräke nitre yete käkwe ja töi kwitadreta Ngöbö kukwäre amne, dän ngutu jüräre kitadre kwetre jabtä amne rabadre täkänintbe ngübrünte ja moto ulire kukwe kämekäme nuenbtä bä mikakrä. ");
INSERT INTO gymNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ye mden kisete, Ngöbökwe kukwe ükadite ni jökrä kräke kä mrä angwane, Ngöbökwe mun nünanka juta Corazínte amne juta Betsaidate mikadi ja tare nike bäri kri nitre nünanka juta Tirote amne Sidónte ye kräke. ");
INSERT INTO gymNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amne mun nünanka juta Capernaúmte, ma känti nete tikwe sribi kri ñan tuabare nuenbare kabre, ¿yebtä Ngöbökwe mun mikadi bäri ütiäte, munta nütüre ya? Ñakare, ñobtä ñan angwane Ngöbökwe mun ye kitadikä kä ja tare nikakrä känti. ");
INSERT INTO gymNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yebti Jesukwe niebareta mda nitre juani kwe yeye: Nirekwe mun kukwei mikadre era ye käkwe ti ne ara jire kukwei kadi ngäbti; akwa nirekwe ñan mun kukwei mikadre era, ye abko ti ne ara jire ñan kukwei kadi ngäbti kwe amne nire ñan tö rabadre ti kukwei kain ngäbti, ye abko Ngöbö ti juanka ñan kadi ngäbti kwe. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Abti nitre gre ketamä bti ni jätä juani Jesukwe ye jatani nüketa mda angwane, kä namani nuäre krübäte btätre, käkwe niebare Jesuye: Dänkien, nunkwe üai käme juantariba mento nibtä angwane, ma käbti üai käme nibi nun kukwei mike täte jökrä kore, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Angwane Jesukwe niebare ietre: Munta kukwe era erere niere, ñobtä ñan angwane merata trä ngitiekä jötrö, ye kwrere Satana kä käinbti jataninbe timon sribi munkwe köböire, rababa tuen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ye abko, üai käme krübäte tbi kwrere amne dribe kwrere, kräke tikwe ja di biani munye ganainkäre amne, mun rüe Satana käkwe ñan mun mikadre bren, abkokäre tikwe ja di biani munye ganainkäre. ");
INSERT INTO gymNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Akwa üai käme käta mun kukwei mike täte, ye munkwe ñan käi ngwian nuäre bäri jabtä, akwa munkwe nünandre kärekäre Ngöböbe, aisete mun käi nena tikani täräbtä kä käinbti, ye abko bäri käi ngwian nuäre jabtä munkwe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Yebti, Ngöbö Üai Deme namani täte Jesubtä, köböire kä namani nuäre kri btä, käkwe niebare: Ti Rün, ma abko kä käin amne kä temen Dänkien. Tita ma käikitekä, ñobtä ñan angwane nitre bikaka töbtä krikri abko okwäte makwe kukwe metre makwe ye rükaninte, akwa ni bobre bobre töi ñakare ñakare ruen ie abko ietre makwe mikani gare, ma tö namani ño, erere makwe nuenbare. Yebtä tita ma käikitekä, niebare Jesukwe Rün Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yebti nitre näma Jesu kukwe nuen, ye ie Jesukwe niebare mda: Ti Rün käkwe jändrän jökrä mikani gare tie amne ti abko nire ngobo era metre gare ñakare ni mda mdaye, akwa ti Rün aibe ie ti gare. Erere arato, ti Rün abko gare ñakare ni mda mdaye, akwa ti niara Odei ne aibe ie niara gare amne ti tö rabare mikai gare nire nireye, ye erere ie rabadi gare, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yebti Jesu nikwitaninte, käkwe niebare kaibe nitre ja töitikaka benye: Tita sribi kuin nuene bätäkä ngwarbe, ye abko munta tuen ja okwä jenbti, ye munkwe käi ngwian nuäre kri jabtä, ");
INSERT INTO gymNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ñobtä ñan angwane sribi kri ñan tuabare tuata munkwe, ye abko nitre Ngöbö kukwei niekä kirakira amne jrei kwati kirakira tö namani tuai, akwa tuani ñakare kwetre. Erere arato, ti kukwei nuata munkwe, ye niaratre tö namani kukwei nuai, akwa erere kukwei nuani ñakare kwetre. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yebti bati, Kukwe Biani Ngöbökwe Moiséye dirikä nämane iti, namani nünaninkä krö, käkwe kukwe ngwianintari ja gakäre Jesube, käkwe niebare ie: Dirikä, ¿tikwe dre nuendre köböire ti rabadre nüne kärekäre Ngöböbe? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Abtä Jesukwe niebare mda ie: ¿Kukwe Biani Ngöbökwe Moiséye btä mata ñäke, ye käta dre niere arato? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Angwane dirikä ye käkwe niebare: Ngöbö Kukweita niere krörö: Makwe ma Dänkien Ngöbö tare ja üai ngöi jökrä, ja di ngöi jökrä amne ja töi ngöi jökrä. Erere arato, mata ja tarere au, ye kwrere makwe ni mda mda tare arato, nieta Ngöbö Kukweibtä, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesukwe niebare mda ie: Kukwe era erere nini makwe. Ye kwrere makwe nuendre ne ngwane, ma rabadi nüne kärekäre Ngöböbe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Akwa Kukwe Biani Ngöbökwe Moiséye dirikä käkwe kukwe ngwianintari, yebti tö namani bikai deme, käkwe niebare Jesuye: ¿Ti mräkä mden abko tikwe taredre metre ruen? niebare kwe mda Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Abtä ni menteni amne ni rüe abko ni mräkä metre, ye Jesukwe bä mikani, käkwe niebare krörö ie: Bati ni nämane iti Jerusalén, nikani motokwäre juta Jericó kukwäre angwane, batibe nitre gokä jatani, käkwe jändrän goibare jökrä kän amne, dän btä dianinkä jökrä kän kwetre, bti metani kwetre, namani bä ngwäkäre angwane, mikaninte jite kwetre se kwrere, bti ngitiani. ");
INSERT INTO gymNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ye ngwane ni blitaka Ngöböbe ni mda mda diäre jatani iti ji ye arabebti angwane, ni bä ngwäkäre nämane jite. Yebtä okwä mata namani akwa, nikani mobe menteninta temen bäre se kwrere, bti nikani janknu ta. ");
INSERT INTO gymNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yebti ni levita sribikä ju blitakrä Ngöböbe jatani iti mda, nükani ja ken ni bä ngwäkäre yebe angwane, mikani ñäräre jirekäbe kwe, akwa nikani janknu ta arato. ");
INSERT INTO gymNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Akwa yebti ni jenena Samariabo jatani iti mda ji ye arabebti abko okwä mata namani ni bä ngwäkäre btä angwane, namani ruen bobre ie, ");
INSERT INTO gymNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","käkwe krötabare ken, bti olibo köi amne uba döi mikani träinbti kwe kräkäi mikakäre amne träin mrianinte kwe, bti mikani buro jakwebti kwe, bti nikani ngwena nebe ju ni basakakrä känti. Ye känti ngibiabare kwe ye näire. ");
INSERT INTO gymNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Yebti jändrinane dekä angwane, ngwian ganaindre köböbu näre ye ni Samariabo käkwe biani ju bkänkäye, käkwe niebare ie: Makwe ni ne ngibia tikrä. Nane makwe ngwian gate bäri mda niarakrä ne ngwane, ti jatadita, käkwe ütiä biandi mae, niebare kwe ie. Abko kukwe nakaninkä kore. ");
INSERT INTO gymNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ne aisete ni iti goibare nitre gokäkwe angwane, ni nikani nimä. ¿Nitre nimä ye ngätäite, ni mden käkwe ni mda tuani känti ja mräkä kwrere ruen? niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Angwane Kukwe Biani Ngöbökwe Moiséye dirikä käkwe niebare mda Jesuye: Ni ie ni bren namani ruen bobre, ye abko käkwe ni bren tarebare mräkä kwe kwrere, niebare kwe. Abtä Jesukwe niebare ie: Ni Samariabokwe kukwe nuenbare kuin mräkä mdakrä, ye kwrere nän nuene arato. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yebti Jesu nikani janknu ta nitre ja töitikaka benbe amne nükani juta mdate, känti meri iti kädian nämane Marta nämane nüne. Marta ne abko käkwe Jesu kani ngäbti ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta etba nämane iti abko kädian nämane María. María ye abko nikani, namani täkänintbe Jesu ngotobtä Jesu kukwei nuen. ");
INSERT INTO gymNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Akwa Marta abko namani sribi kabre gwita ye aibe btä töbike, aisete namani sribire janknu, bti nikani, käkwe niebare Jesuye: Ti Dänkien, ¿ti mräkäkwe ti mirite sribire kaibe, se ütiäte ñakare makrä ya? Niara juen jötrö ti die mike, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Akwa Jesukwe niebare mda ie: Marta, ma nibi töbike krübäte dikaro sribibtä, kä nibi ma nike. Erere arato, jändrän keta kabre, btä mata töbike, ");
INSERT INTO gymNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","akwa jändrän ketetibe bäri ütiäte, ye mden abko Maríakwe känäniri jakrä, käta ti kukwei nuen. Ye abko ni ñakare jire abko rabadre denkä kän. Abko kore se, niebare kwe Martaye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bati Jesu nämane blite Ngöböbe kä mda känti, käkwe blitabare ünän angwane, ni iti ja töitikaka ben abko käkwe niebare ie: Ti Dänkien, blitadre ño Ngöböbe abko Juan Bautistakwe diribare nitre ja töitikaka benye, aisete makwe diridre nunye arato, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Abtä Jesukwe niebare ietre: Mun rika blite Ngöböbe angwane, munkwe nie krörö: Ti Rün kä käinbti, ma kä aibe raba mikani ütiäte ni jökräkwe. Jakwe gobrane nun ngätäite nete. Ma tö dreye kä käinbti, erere tä neme bare mae kä käinbti, erere raba bare mae kä nebtä nun ngätäite arato abko nunta ribere mae. ");
INSERT INTO gymNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Köbö kwatirekwatire makwe mrö bian täte nunye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nun ngite kukwe kämenbtä ye denkä mento nunbtä, ñobtä ñan angwane ni mda mda tä ja mike ngite nun rüere, käre nunta den jabti ta köbö kwatirekwatire. Amne kukwe kämekäme tö nun nuaite ja käne ma rüere, ye känti makwe ñan nun jie ngwian, abko munkwe blita kore Ngöböbe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Bti Ngöböta juto biare ni kukwei kaen ngäbti, ye abko Jesukwe bä mikani, käkwe niebare krörö mda ietre: Nane mun kukwe muko jatadre iti kä ruäre deo, käkwe niedre: Ja mräkä, ban ngwen kumä ütiädre tie, ");
INSERT INTO gymNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ñobtä ñan angwane gwä ti kukwe muko nü basare jire tie, akwa bukakrä ñan nebe tie. Abtä ti ki ban tärire mae, tikwe ñan ja gaidre krübäte abkokäre, niedre kwe mae. ");
INSERT INTO gymNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Angwane ni tädre gwi käkwe ñan niedre: Ti nibira jänbti ngäbäkrebe, aisete ti ñan raba nainkröta krö jändrän biankäre mae, aisete makwe ñan ti nika, niedre ñakare jire kwe kukwe kare ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Akwa niara ñan kädriedre blo, abkokäre rükadre krö amne jändrän jökrä kärädre ie kukwe mukokwe, ye erere biandre jökrä kwe ie. Ye abko ñan niara kukwe muko, aisete nuendi kore kwe akwa, ñan ñäkädre rüere abtä rabadre ja gaire, abkokäre nuendi kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Blitadre Ngöböbe, ye mdenbtä abko ti tö kukwe mda niei krörö munye arato: Käre munkwe jändrän kärä Ngöböye amne Ngöbökwe biandi munye. Erere arato, munkwe jändrän känäntari Ngöbö känti amne kwandi munye. Erere arato, nita neme jukwebtä jändrän kärere ni mdaye, ye kwrere käre munkwe jändrän kärä jukwebtä Ngöböye angwane, Ngöbökwe jukwe tikadi, käkwe biandi munye, ");
INSERT INTO gymNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ñobtä ñan angwane nireta jändrän kärere, ye erere bianta ie amne, nireta jändrän känentari jakrä, ye erere tä kwen ie amne, nireta ñäke jukwebtä abko ietre Ngöböta jukwe tike amne tä jändrän bien ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mdakäre abko, Ngöböta jändrän bien kore, yebtä abko ti bike kukwe bä mike krörö mda: ¿Mun mden ngäbäkre rünre, ie ngäbäkreta gwa kärere kwetadre jae angwane, tä tbi krübäte bien kwetadre ie? ");
INSERT INTO gymNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Erere arato, ¿mun mden ngäbäkre rünre, ie ngäbäkreta kwi mrüke kärere angwane, tä dribe bien kwetadre ie? Ni ñakare jire iti käta jändrän krübäte bien ngäbäkre kweye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mun abko moto käme, akwa ngäbäkre munkwe, ie jändrän kuin bian gare munye. Se abko mun Rün kä käinbti bäri moto kuin munkrä abko ie munkwe niara Üai Deme kärädre angwane, biandi kwe munye. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Abti bati ni iti btä üai käme nämane, käkwe kukwe ötani abko btä Jesukwe üai käme juanintari mento. Ye erere üai käme nikani mento btä angwane, namani bliteta kuin. Yebtä abko ni kwati ñan töi namani krütare mda. ");
INSERT INTO gymNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Akwa ni ruäre namani niere: Üai käme dänkien kädianta Beelzebú, ye mden käkwe ja di biani niaraye abko diebti tä üai kämekäme juentari mento se, namani niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Akwa era metre Jesu namani sribire Ngöbö diebti rabadre era kräke, abkokäre Ngöböta kä käinbti käkwe sribi kri ñan tuabare nuendre niaratre okwäbti Ngöbö nämane ben bä mikakäre abko ni ruäre namani kärere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Angwane nitre namani töbike blo Jesu rüere, ye ganina btätre Jesukwe. Abtä niebare kwe ietre: Juta amne ni mräkä mden erere käta ja ñäketbe ketebu rükäre jabe kwärikwäri, ye abko tä ja juen ngwarbe au. ");
INSERT INTO gymNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ye kwrere abko, ¿Satana amne üai käme kwekwe käkwe ja ñäkäretbe ketebu jene jene ja rüere au, ye angwane tädre dite ya? Ñakare. Ye abko, tita üai käme juentari Beelzebú diebti munta niere tibtä, ye mdenbtä abko tita ñäke kore. ");
INSERT INTO gymNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Üai käme dänkien kädianta Beelzebú, diebti tita üai käme juentari mento munta niere tibtä, aisete ¿nitre reketaka munkri ye abko ie nireta ja di bien üai käme juantarikrä mento abko ti tö nibi ngwiaintari munye? Niaratre käkwe mun kitadre ngise ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Akwa tita üai käme juentari mento Ngöbö Üai Deme diebti era metre, ye ngwane Ngöbö nükanina gobrane mun ngätäite abko bä mikata tikwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Akwa ti bike kukwe mdara jire niere munye üai kämenbtä abko krörö: Ni dite kri kwe jändrän tärä kabre rükrä, bti tä jändrän jakwe erere ngibiare kuin jäme gwi abko üai käme kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Akwa ni mda bäri dite ti kwrere jatadre rüre, käkwe ganaindre kwäräbe angwane, jändrän rükrä ni ditekwe, bti tädre tödeke abko diandrekä jökrä ni dite ye kän amne jändrän kwekwe diandrekä jökrä kän, bti dräidre jökrä jabti kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ye abko nire nire ñan tä nekete tibe, ni ye abko tä rüre ti rüere amne, nire nire ñan tä sribire gwaire tibe abko tä sribi tikwe metekä jirekäbe tikän, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yebti Jesu nikani blite krörö mda üai kämenbtä: Ni iti btä üai käme tädre nüne, abti üai käme ye juandretari mento btä, üai käme rikadre ngwarbe kwäräkwärä kä känene jadükakrä jae kä kaibete, akwa kä ñan kwandre jire chi ie jadükakrä, abtä rabadre töbike krörö: ¡A! Ni nämane ju kwrere tikwe abko te ti nämane nüne, ye känti ti bike nikenta, üai käme rabadre nütüre. ");
INSERT INTO gymNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ye erere bkänä, üai käme ye rikadreta ni ye känti, rabadreta yete angwane kä sökaninkä merebe gwita temen amne kä ükaninte kuin gwita, kwrere jire ni ye kwandre üai kämeye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Angwane jötrö ngwarbe üai käme ye rikadre betekä, käkwe üai bäri kämekäme niarakrä känändre krä kükü mda ja mukore, bti rikadre nünenta jökrä ni yebtä. Üai käme ye rabadrera nünenta kore ni yebtä angwane, ni ye rabadre ja tare nike bäri krübäte mda üai käme kisete, niebare kore Jesukwe ni jökräye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu nämane blite kore, ye btäräbe meri nämane iti ni mda mda ngätäite käkwe ñäkäbare jume ja dibti mda: Ma meye kwe ma därebare amne ma mikani kianbtä kwe, meri ye abko Ngöbö diebti abko kä nuäre kri btä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Abtä Jesukwe niebare: Nire nire tä Ngöbö Kukwei nuen amne tä mike täte, ni ye abko Ngöbö diebti käta neme bäri nuäre btä abko ti tö nibi niei, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yebti ni nikani ja ükekrö bäri kwati mda Jesu bäre temen angwane, Jesu nikani niere krörö ietre: Mun nünanka kä ne ngwane abko moto kämekäme, abtä tikwe sribi kri ñan tuabare aibe nuendre mun okwäbti, ie mun töta nebe, akwa sribi kri ñan tuabare ye tikwe ñan nuendre jire chi mun okwäbti, munta ribere ye kwrere. Akwa Ngöbö nämane Jonábe, käkwe sribi kri ñan tuabare nuenbare Jonákrä, ye kwrere aibe Ngöbökwe bä mikadi mun kräke, ");
INSERT INTO gymNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ñobtä ñan angwane kukwe nakaninkä Jonábtä käkwe nitre Nínivebo töi kwitani, abtä Jonás kukwei mikani era kwetre, ye kwrere Ngöböta sribire era metre ti Ni Kä Nebtä Ngobo köböire abko Ngöbökwe bä mikadi metre munye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Erere arato, Ngöbökwe kukwe ükadite ni jökrä kräke kä mrä angwane, jreina nünanka mobe mötarikri nükani kira basare jrei Salomónye ye käkwe mun kitadi ngise arato, ñobtä ñan angwane Salomón nämane kukwe töbtä töbtä niere, ye jreina mobe jatani kukwe nuen jakrä, akwa tita nete abko bäri ütiäte kri Salomónkrä abko mun ñan tö ti kukwei nuai, aisete rakadikä kore munbtä. ");
INSERT INTO gymNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Erere arato, munta nüne kä ne ngwane abko, btä Ngöbökwe kukwe ükadite kä mrä angwane, nitre Nínivebo käkwe mun kitadi ngise arato, ñobtä ñan angwane Jonákwe Ngöbö kukwei niebare angwane, nitre Nínivebo käkwe ja töi kwitani Ngöböbtä, käkwe Ngöbö kani ngäbti, akwa tita nete abko bäri ütiäte Jonákrä, käta Ngöbö kukwei niere munye abko mun ñan tö kukwei nuai amne mun ñan tö ja töi kwitai Ngöböbtä, ye dokwäre abko Ngöbökwe kukwe ükadite munbtä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Bti Jesukwe ja bä mikani ñotra jutra kwrere, käkwe niebare mda: Ni ñakare jire iti käta ñotra jutra mike, abti tä mike kä mkäte nguse. Erere arato, ñan tä mike kaja täni, akwa tä mike üräbtä käin, ye abko ni rikare gwäkäre angwane, kä rabadre tuen kuin nie abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ye kwrere ma okwä abko ñotra kwrere nikrakrä ja bäre temen, aisete ma okwä kuin ne ngwane, käta tuen kuin mae. Ye kwrere abko makwe nünandre metre, ie Ngöbö tö ne ngwane, ni ie kä tuen kuin käta dikekä metre ñotra träbti, ye kwrere ma rabadi nüne kä ngwen Ngöbökwete. Akwa ma okwä bren angwane, kä ñan raba tuen kuin mae ne ngwane, mata kä ikote. Ye kwrere abko makwe kukwe kuin Ngöbökwe mikadre ngwarbe jae ne ngwane, ma töi rabadi käme amne ma rabadi nüne kä ikote Ngöbö rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ne aisete munkwe ja ngibia kuin au, ñotra trä kuin tä munkwe ne ngwane, munta kä trä ngwen Ngöbökwete, ye ngwane mun ñan rabadre kä ikote Ngöbö rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Munkwe ja töi mikadre nüne metre Ngöbö ngwärekri angwane, munkwe ñan nünandi kä ikote kwrere amne, ji Ngöbökwe rabadi gare kuin munye, kä trä kuin tuen nie ye kwrere ne ngwane, munta kä ngwen Ngöbökwete amne kä iko ñakare mun töibtä, aisete jändrän jökrä Ngöbökwe rabai gare kuin munye, käta nebe tuen kuin ñotra träte munye ye kwrere. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesukwe blitabare ünän angwane, ni bariseo käkwe ngwiani mröre ja känti. Ye erere Jesu nikani, namani täkänintbe mesabtä mda. ");
INSERT INTO gymNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Akwa ni rikadre mröre, känenkri köbötikadre käne ja ngibiakäre dbe Ngöbö ngwärekri nämane ükaninte nitre israelitakwe, erere Jesukwe köbötikani ñakare. Yebtä abko bariseo ye ñan töi namani krütare Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Abtä Jesukwe niebare ietre: Mun bariseo abko baso amne siä bätäteta btärita aibe amne terita abko tä nebe dobrore kwrere jire, aisete mun töita gobtä amne mun töi kämekäme. ");
INSERT INTO gymNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mun töi ngitiekä ñakare metre Ngöbö Kukweibtä. ¿Ngöbökwe mun ngrabare dätebare, käkwe mun töi, mun moto dätebare ñakare arato ya? ");
INSERT INTO gymNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Munkwe jändrän jakwe bian ni bobre bobre die mikakrä, ye ngwane mun töi rabadi merebe arato baso amne siä bätäteta btärita amne terita arato ye kwrere, niebare Jesukwe bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bti Jesukwe niebare: ¡Aingwaree mun bariseo! Käre munta kri mu chi, ütiäte ñakare kädianta menta amne kri mda mu kädianta ruda amne kri mu mda mda kuin kwetadre amne kuin kräkäre, akwa ütiäte ñakare ükekrö keta jätä, bti munta mike keteti jenena biandre Ngöbökrä. Akwa jändrän bäri kuin ütiäte nuendre ni bobre kräke amne Ngöbö taredre abko erere munta nuene ñakare. Ye kwrere jändrän bäri ütiäte abko munta nuene ñakare, aisete munkwe jändrän ketebu ye nuendre amne mikadre täte keteti munkwe, akwa jändrän bäri ütiäte abko nuendre bäri munkwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Aingwaree mun bariseo! Käre ja täkrä ni ütiäte ütiäte kräke sinagogate, känti mun töta nebe rabai käre ja mikakrä ütiäte. Erere arato, ni mda mdakwe mun mikadre ütiäte jae, käkwe köbö ngwiandretari käne munye ji ngrabare mrö rürümoinkrä känti, ie mun töta nebe ja mikakrä ütiäte. ");
INSERT INTO gymNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Aingwaree mun bariseo! Kä ni doboi mikakrä, känti kä ükateta kuin ruäre, aisete dobo mikani gare ñakare amne, ni raba dikekä jäme bti ta abtä ja mikata ngite amne tä dbe ñakare Ngöbö ngwärekri, ye kwrere jire mun bä kuin metre, akwa munta ni mda kite ja mike ngite abko gare ñakare ni mda mdaye, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Abtä Kukwe Biani Ngöbökwe Moiséye dirikätre nämane yete abko iti käkwe niebare Jesuye: Dirikä, mata ñäke kore, ye abko mata ñäke nun rüere arato, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Akwa Jesukwe niebare mda ie: ¡Aingwaree mun Kukwe Biani Ngöbökwe Moiséye dirikätre! Käre munta tribe mike kabre ni mda mda tröbtä, tä nebe doboko krübäte kräke, akwa nin munta die mike jire chi abko krörö: Kukwe ükateta kabre nuendre ni jökräye munkwe, ye abko tribe doboko kwrere, akwa munta ja kukwei mike täte ñakare jire chi, niaratre kitakäre kukwe kuin nuene Ngöbökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Erere arato, nitre Ngöbö kukwei niekä kirakira kämikani mun mräkäkwe abko doboibti kä ükateta kuin munkwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ye abko, mun mräkäkwe kukwe nuenbare abko dbe munkrä tuen munbtä, aisete mun mräkäkwe ni Ngöbö kukwei niekä kirakira kämikani amne mun abko tä doboi ükateta kuin nuäre, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Munta töbike kore, ye mdenbtä abko Ngöbö töbtä kri käkwe niebare: Tikwe ja kukwei niekä niekä juandi amne ja kukwei ngwianka ngwianka tikwe juandi arato, ye abko müre ketadi ruäre amne ruäre abko jiebti rikai kisere mikakäre ja tare nike. ");
INSERT INTO gymNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ne aisete nitre ti kukwei niekä därie metaninkä temen, yebtä Ngöbökwe kukwe ükadite munkrä abko krörö: Nitre Ngöbö kukwei niekä kirakira kämikani Abel näire nebebe Zacarías näire. Zacarías ye abko kämikani kwetre ñukwä grä amne ju blitakrä Ngöböbe te ruäre. Abtä Ngöbökwe kukwe ükadite niaratre kämikakabe. Erere arato, yebtä Ngöbökwe kukwe ükadite ni kä ne ngwanebe abko ti tö nibi niei munye, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bti Jesukwe niebare mda: ¡Aingwaree mun Kukwe Biani Ngöbökwe Moiséye dirikätre! Munta kukwe era metre Ngöböbtä rükente ni mda mda käne. Mun ñan tö kukwe era metre mikai gare kuin jae amne mun ñan tä dirire era metre arato ni mda mdaye, aisete rükadre ño Ngöbö känti ñan rükadre gare ietre. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nebti Jesu nikaninta mda angwane, nitre bariseo amne Kukwe Biani Ngöbökwe Moiséye dirikätre moto namani romon krübäte Jesu kukweibtä. Abtä nikanintre kukwe ngwentari kabre Ngöbö kukweibtä ie, ");
INSERT INTO gymNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ye abko Jesukwe ja kitadre au kö okwäte ja kukweibtä, abtä kitadre ngise kwetre, abkokäre namanintre kukwe ngwentari kore ie. ");
INSERT INTO gymNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ye ngwane ni jatani nüke ja ükekrö bäri kwati mda Jesu känti, aisete ni namani kwati krübäte, kä namani ja kitekäbe kwärikwäri. Angwane nitre ja töitikaka Jesube, ie Jesu nikani niere krörö: Lebadura mikata bante tä ngitie jökrä te, ye kwrere jire nitre bariseo töi kämekäme, käta bike kuin deme ye abko käta ngitie ni mda mda töite, käta ni mda mda töi mike ja kwrere, aisete munkwe ja ngibia kuin nitre bariseo ngäniene, ");
INSERT INTO gymNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ñobtä ñan angwane kukwe ñakare jire tiebe abko ni mdakwe ñan gadre. Erere arato, jändrän ñakare jire gore abko ni mdakwe ñan gadre. ");
INSERT INTO gymNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ne aisete jändrän jökrä nieta kaibe munkwe akwa, ni jökrä käkwe kukwe nuadi. Erere arato, kukwe nieta tiebe kaibe gwi munkwe abko kädriedi ji kribti temen ja ngwärekri jökrä, aisete munkwe ñan bika deme nitre bariseo se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ye abko, mun ti kukwe muko tikwe, ie ti tö niei krörö: Ni mda raba mun ngrabare aibe kämike, akwa yebti ñan raba jändrän nuene munbtä, aisete munkwe ñan ni mda jürä ngwian jabtä; ");
INSERT INTO gymNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","akwa nire jürä ngwiandre era metre munkwe jabtä abko ti bike niere munye: Ngöbö aibe jürä ngwian munkwe jabtä, ñobtä ñan angwane mun krütadre, bti Ngöbö di tärä mun kitakrä kä ja tare nikakrä känti aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Akwa mun bäri tare kri Ngöbökwe abko ti bike bä mike krörö munye: Nukwä kiakia rürümointa kwärike abko ütiä bianta bäri brai, aisete ngwian bianta mnamube ütiäre, akwa nukwä kiakia ye käita nikwitekä ñakare Ngöböbti. ");
INSERT INTO gymNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Amne mun ara jire abko dokwä drüen kratirekratire abko tä gare jökrä Ngöböye, aisete Ngöbökrä mun abko bäri ütiäte kri nukwä kabrekabre bti ta, aisete mun raba ja tare nike angwane, munkwe ñan kä jürä ngwian jabtä, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Bti Jesukwe niebare mda: Ti tö kukwe krörö niei mda munye: Nire nire tä nekete tibe abko niedre metre kwe ni mda mda ngwärekri, ni ye abko jen tikwe abko ti, Ni Kä Nebtä Ngobo käkwe niedi arato angeletre Ngöbökwe ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Akwa nire nire käkwe ti rükandrete ni mda mda ngwärekri, ni ye abko gare ñakare tie abko tikwe niedi angeletre Ngöbökwe ngwärekri arato. ");
INSERT INTO gymNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Mdakäre abko, ti Ni Kä Nebtä Ngobo, rüere nirekwe ñäkädre blo, akwa ja töi kwitadreta kwe angwane, Ngöbökwe kukwe käme ye diandrekäta btä; akwa nirekwe ja dokwä mikadre ribi, käkwe Ngöbö Üai Deme mikadre ngwarbe jae, ye aibe Ngöbökwe ñan ngite diandrekäta jire btä. ");
INSERT INTO gymNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Mdakäre abko, sinagoga känti mun järika nitre israelitakwe kukwe ükatekäre amne nitre kritobore ñakare israelitare, ye ngwärekri mun järika kukwe ükatekäre angwane, munkwe blitadre ño jakrä amne munkwe dre niedre, yebtä munkwe ñan töbika dikaro, ");
INSERT INTO gymNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ñobtä ñan angwane munkwe dre niedre jakrä, ye abko Ngöbö Üai Deme käkwe mikadi gare munye abko erere munkwe niedi jakrä kritobo ngwärekri, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Angwane nitre nämane kwati, ye ngätäite ni nämane iti käkwe niebare Jesuye: Dirikä, jändrän namani nun rün mröye, se ti etbakwe dräidre jabti tibe niere ie, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Abtä Jesukwe niebare ie: Ja mräkä, ¿nirekwe ti mikani kritobore mun ngätäite jändrän dräikäre munbti amarebti mata niere kore tie ye? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ni ye tö namani jändrän rünkwe diain kabre jae, aisete Jesukwe niebare mda ietre: Ni rabadre jändrän bkäne kabre, ñan ye köböire kä rabai nuäre nibtä, aisete mun tö jändrän bkäne kabre jakrä, ye ngäniene munkwe ja ngibia, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bti Jesukwe kukwe ye bä mikani krörö: Bati ni nämane iti abko jändrän bkäne kabre krübäte. Batira jire nura nökani kwe, abti ngwä ötani kabrekabre kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Yebti ni jändrän bkänkä kabre ye namani töbike mda: Jändrän ngwä ötani kabre krübäte tikwe noko amne ju ñakare tikwe ükakrä. ¿Tikwe ükadi mdente? namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Te batibe niebare kwe jae: ¡A! Tikwe dre nuendi nüra gare tie. Ju chi tä tikwe nura ükakrä noko tikwe dikandite, bti tikwe ju mikadi bäri kri mda ju chi noko täte abko te tikwe mrö noko ükadi jökrä jändrän jakwebe. ");
INSERT INTO gymNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Bti tikwe niedi krörö jae au: Ti nena jändrän bkäne kabre amne jändrän nena nünankrä raire tie, aisete mtare mentokwäre ti bike jadüke, ti bike mröre, dö ñaen amne ti bike kä ngwen nuäre jabtä kwäräkwärä mda ruen tie, nütübare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Akwa ye btäräbe Ngöbökwe niebare ie: ¡Ma töi ñakare! Mtare deo ma krütadi angwane, ¿jändränta ükani kabre makwe, se abko rabadi nirekrä? niebare Ngöbökwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ye kwrere tä nakenkä munbtä. Munkwe jändrän ükadre kabre jakrä kä nebtä, akwa jändrän kuin tä biandre Ngöbökwe munye, ye abko munkwe känändre ñakare jakrä, angwane mun rabadi bobre Ngöbö ngwärekri angwane, kukwe ne kwrere rakadikä munbtä, niebare Jesukwe ni jökräye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yebti Jesu nikwitaninte, käkwe niebare nitre ja töitikaka benye: Tikwe kukwe nini, yebtä munkwe mrö ño kwetadre nünankrä amne munkwe dän ño kitadre jabtä, yebtä munkwe ñan töbika dikaro abko ti tö nibi niei munye, ");
INSERT INTO gymNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ñobtä ñan angwane nita nüne kä nebtä angwane, nünandre metre Ngöböbe abko bäri ütiäte mrökrä amne ni ngrabare ye abko bäri ütiäte dänkrä, aisete munkwe ñan töbika krübäte dikaro jändrän yebtä. ");
INSERT INTO gymNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ye abko, nukwä kwerbo tä nüne ño, ye mika ñäräre munkwe. Kwerbo tä nura nökö ñakare, tä ngwä ötö ñakare, ju ñakare kwe mrö ükakrä jakrä, akwa Ngöböta mrö bien kwetadre ietre. ¡Mun abko bäri ütiäte nukwä kräke, se abko mun Rün käkwe ñan mrö biandre munye ya amarebti munta töbike krübäte dikaro se! ");
INSERT INTO gymNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Erere arato, munkwe ñan töbikadre krübäte dikaro kore, ñobtä ñan angwane ni tö rabare ja tuai bäri kri, akwa di ñakare ja mike niren taiti mda kukwäne. ");
INSERT INTO gymNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jändrän ne abko chi akwa, mun di ñakare nuenkäre, ¿se ñobtä abko jändrän bäri taretare nuendre abko btä munta töbike krübäte dikaro se? ");
INSERT INTO gymNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mdakäre abko, ¿ñobtä munta töbike krübäte dikaro dänbtä jakrä se? Kri blü tä niren ño, yebtä munkwe töbika. Tä sribire ñakare, tä dän dike ñakare jakrä, akwa jrei kri Salomón abko nämane jändrän jökrä tuäretuäre bkäne, akwa dän tuäretuäre kri blü se kwrere abko Salomónkwe kitani ñakare jabtä. ");
INSERT INTO gymNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kri blü tä neme jötrö köböitibe, abti jändrinane angwane mikata ngire ñukwäte, akwa Ngöböta ükete tuäretuäre. ¿Ye mun abko ie dän ñan biandre Ngöbökwe ya amarebti munta tödeke ñakare täte Ngöböbti ye? ");
INSERT INTO gymNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Munkwe dre kwetadi amne munkwe dre ñadi tomnane, yebtä munkwe ñan töbika krübäte dikaro amne mun ñan raba ulire, ");
INSERT INTO gymNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ñobtä ñan angwane ni kwati kä nebtä tä tödeke ñakare Ngöböbti abko bäri tä nakwen kisere jändrän ye jiebti. Akwa mun käta dre mdei nike, ye abko garera jökrä Ngöbö mun Rün kä käinbti seye amne niarakwe jändrän ye biandi munye, aisete munkwe ñan töbika dikaro jändrän nünankrä yebtä jakrä. ");
INSERT INTO gymNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Akwa jändrän Ngöbökwe tä kä käinbti, ye munkwe känäntari angwane, jändrän jökrä mdei nikata munkwe ye Ngöbökwe biandi munye arato. ");
INSERT INTO gymNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ne aisete mun obeja kiakia tikwe, munkwe ñan kä jürä ngwian jabtä, ñobtä ñan angwane jändrän jökrä kä käinbti, känti Ngöbö mun Rünta gobrane abko mikani gare ja moto kuinbti kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ye aisete, jändränta munkwe, ye erere munkwe rürümoin jökrä, bti munkwe ngwian dräi ni bobre bobrebti angwane, Ngöböta jändrän kuin ütiäte kri ngibiare munkrä kä käinbti, ye känäntari jakrä munkwe. Erere arato, jändrän kuinkuin ütiäte krikri rabadre munkrä kä käinbti, ye munkwe känäntari jakrä, ñobtä ñan angwane Ngöböta jändrän kuin ütiäte kri ngibiare kä käinbti munkrä, ye känti ni gore ñan rabadre gwi amne kebekwe ñan juandre ngwarbe munkän arato, aisete munkwe jändrän ütiäte kri kä käinbti känäntari bäri kabre jakrä. ");
INSERT INTO gymNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Munkwe nuendre kore, ñobtä ñan angwane jändrän ütiäte krikri tädi ükani mdente jakrä munkwe, ye känti mun töi tädi arato, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Bti Jesukwe niebare mda ietre: Ti bike kukwe mdara jire niere munye abko krörö: Munkwe dän kita biare jabtä amne munkwe ñotra jutra mika biare ti ngibiakäre ngäbti, ni klabore tä bkänkä ngibiare ngäbti ye kwrere, ñobtä ñan angwane ni mdata ja mike gure angwane, sribikätre bkänkä tä nüke kä ngwen nuäre jabtä, akwa sribikätre kwe abko tä biare ngibiare ngäbti jukwe tikakäre ie, ye kwrere munkwe ja mika biare ti ngibiare ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ye abko, nitre sribikä tä kwen ngwäte bkänkäye, ye abko käita neme nuäre btä, aisete sribikä kwandre ngwäte bkänkäye ne ngwane, bkänkä ara jire käkwe dän sribikrä kitadi jabtä, bti sribikä kwekwe mikadi täkänintbe mesabtä kwe, mrö mikadi kwetadre kwe ietre mikakäre ütiäte. Ye kwrere munkwe ti ngibiadre ngäbti angwane, ti rükadita angwane, tikwe mun mikadi ütiäte arato abko ti tö niei metre munye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ne aisete, nitre sribikä ye bkänkä rükadreta kä ruäre angwane ya o kä ngwen ja ken dekä angwane rükadreta ya, akwa sribikä kwe tä biare ngibiare ngäbti, ye abko bäri käi rabadre nuäre sribikätre yebtä, erere munkwe ti ngibiadre ngäbti kisere angwane, bäri käi rabadi nuäre munbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kukwe mdara jire rabadre gare munye arato abko krörö: Ni gore rükadre kä ñongwane, ye rabadre gare ju bkänkäye akräke ju bkänkä käkwe kraidre gwi angwane, jändrän ñan goidre jire kän kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ni gore rükadre ñongwane gare ñakare, ye kwrere ti Ni Kä Nebtä Ngobo ne mun tädi ngibiare ngäbti ñakare angwane, batibe rükadita, aisete munkwe mokre jabti ti ngibiakäre ngäbti, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Angwane Pedrokwe niebare mda Jesuye: Ti Dänkien, ¿makwe blitaniri, ye makwe nini kaibe nunkrä ya o makwe nini ni jökrä kräke? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Angwane ni Dänkien käkwe niebare mda: Ni sribikä kuin tä biare abko bkänkä tä mikete sribikätre mda mda ngibiare amne mrödre ñongwane erere käita nüke angwane, tä sribikä mda mda buke. ");
INSERT INTO gymNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ni sribikä mikateta ja täte bkänkäkwe angwane, sribi mikateta kisete bkänkäkwe erere tä nuene täte jökrä, bti bkänkä tä nüketa, käta kukwe ükete kuin kräke, ");
INSERT INTO gymNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","käkwe ni sribikä kuin kore ye abko mikadi jändrän jökrä ngibiabtikä jakrä, aisete käta neme nuäre btä abko ti tö niei metre munye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Akwa sribikä mikadrete sribire ja täte bkänkäkwe ye abko rabadre töbike krörö: Ti bkänkä ñan rükadreta jötrö, rabadre nütüre, kä rikadre sribikä mda mda merire, brare ngötikekä kwäräkwärä amne, rikadre mröre, dö ñaen amne rikadre dröbare jirekäbe angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","bkänkä rükadreta ñongwane gare ñakare ie. Ne aisete tädre jäme angwane, batibe bkänkä jatadre nüketa, yebtä abko bkänkäkwe mikadi ja tare nike kri, sribikä dokwä ribi mda mda ben. ");
INSERT INTO gymNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mdakäre abko, ni sribikä abko bkänkä tö dreye gare kuin ie, akwa bkänkä kwe mikata täte ñakare kwe, aisete metadi tare krübäte kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Akwa sribikä mda abko, bkänkä tö dreye metre gare ñakare ie, käkwe ja mikadre ngite, yebtä mikadre ja ngie nuen, akwa metadre bä räkä, ñobtä ñan angwane kukwe gare ñakare ie aisete. Ne mden kisete, nire nire abko ie sribi ya, jändrän mda mda ya bianta kabre, ye ie käräta bäri mda btä. Erere arato, nirebti tödekata sribi nuenbtä abko ribeta bäri mda btä, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","51","Yebti Jesukwe niebare mda ietre: Tikwe ja tare nikadi kri angwane ti krütadi, akwa ye ngämi nakenkä, känenkri ti moto neme nuäre ñakare. Mdakäre abko, ñan ti jatani mun mikakäre nüne jäme jabe kwärikwäri abko munkwe nütü, akwa ti jatani ñukwä bukete mun ngätäite kä nebtä, ye abko ti tö nena tuai jutra ngitiekä. Ti jatani, abtä ni kwati rabadi nikwite ja rüere kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mtare mentokwäre ni ruäre rabadre tödeke ñakare tibti käkwe rüdi mräkä tödekaka tibti ben, aisete ni ja mräkäre tädi nüne nirike gwi, ye abko nimä rabadi rüre mräkä nibu rüere. Erere arato, ni nibu ye rabadi rüre mräkä nimä ye rüere. ");
INSERT INTO gymNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Angwane ngäbäkre rün rabadi rüre ngobo kwebe amne ngäbäkre rabadi rüre rün kwebe. Erere arato, meye rabadi rüre ngänkän kwebe amne ngäbäkre merire rabadi rüre meye kwebe. Ye kwrere arato, bi rabadi rüre bosibe amne bosi rabadi rüre bibe. Ne abko rabadi nakenkä kore munbtä tödekabtä tibti, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Bti ni nämane kwati yete, ye ie Jesukwe niebare mda: Mütata kite jüben nindrini angwane, ñü räkändi temen munta niere, erere ñüta näkäen. ");
INSERT INTO gymNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Erere arato, müreta kite mate mötarikri angwane, kä rabadi ngire krübäte munta niere, erere käta neme ngire. ");
INSERT INTO gymNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ye aisete ngwarbe munta bike töi ñakare, ñobtä ñan angwane jändränta tuen kä käinbti amne kä temenbtä, ye abko tädre dre bä mike tä nüke gare kuin jökrä munye. ¿Ye ñobtä abko dreta nakenkä kä ne ngwane mun näire Ngöbö diebti mun okwäbti abko tä nüke gare ñakare munye? ¿Ye ñan ngwarbe munta bike töi ñakare ya? ");
INSERT INTO gymNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Mdakäre abko, kukwe raba ja rüere kwärikwäri munkwe angwane, ükadrete ño kuin, ye erere munkwe ükate jabe kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Akwa nane ma rüekwe ma kita ngise kritobo ñakare israelitareye ne ngwane, ma ngämi nebe kritobo ngwärekri, känenkri makwe kukwe ükate ma rüebe ji ngrabare, mun ñan rabadre kritobo ngwärekri abkokäre, ñobtä ñan angwane ma rabadre kritobo ngwärekri angwane, niarakwe ma köböi biandi guardiaye amne guardiakwe ma kitadi ngite kä teri. ");
INSERT INTO gymNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ye känti abko makwe ñan ngwian biandre täte jökrä ja ütiäre, känenkri ma ñan tikadreteta kwe abko ti tö niei munye. Abko kore se, niebare Jesukwe ni nämane kwati yete yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kä ye ngwane ni israelita nämane ruäre Jesu känti yete käkwe niebare ie: Krire nitre Galileabo nämane jändrän jakwe kämike kukwadre Ngöböye, Ngöbö käikitakakäre ju blitakrä Ngöböbe känti angwane, Pilatokwe kämikamna, erere rükä romanobo kwekwe käkwe kämikani. ");
INSERT INTO gymNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Abtä Jesukwe niebare ni jökräye: ¿Nitre Galileabo kämikani kore, aisete niaratre abko bäri kukwe kämekäme nuenkä nitre Galileabo mda mdakrä, munta nütüre ya? ");
INSERT INTO gymNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Akwa ñakare kore ti tö niei munye. Akwa munkwe ñan ja töi kwitadre, käkwe ñan kukwe käme kitadre temen, bti Ngöbö kadre ngäbti munkwe ne ngwane, mun rabadi nianinte, käkwe ja tare nikadi kri Ngöbö okwä bäre mento kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Erere arato, nitre ni jätäbti ni kwä, bti ki Siloéte nikani temen, käkwe kämikani, ¿niaratre ye abko nämane Ngöbö Kukwei mike täte ñakare, abtä nämane ja mike ngite bäri Ngöbö rüere nitre Jerusalénbo mda mdakrä, munta nütüre ya? ");
INSERT INTO gymNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Akwa ñakare kore ti tö niei munye. Munkwe ñan ja töi kwitadre, käkwe ñan kukwe käme kitadre temen, bti Ngöbö kadre ngäbti munkwe ne ngwane, mun rabadi nianinte, käkwe ja tare nikadi kri Ngöbö okwä bäre mento kärekäre. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yebti nitre israelitakwe ñan Ngöbö kadre ngäbti ne ngwane, Ngöbökwe juandre ngwarbe abko mikakäre mokre, Jesukwe kukwe mda bä mikani ietre angwane, nitre israelita krikri bä mikani higo krie kwrere kwe amne Ngöbö bä mikani kä bkänkä kwrere kwe abko krörö: Bati ni nämane iti käkwe higo krie nökani uba nurai ngätäite. Abti higo ngwä namanina ya abko nikani tuenta, akwa higo ngwä kwani ñakare ie. ");
INSERT INTO gymNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Abtä nura ngibiabtikä nämane kwe yete, ie niebare kwe: Higo ne ngwä nena btä ya abko ti nükani tuen kä komä jire ja täritäri akwa, ngwäta kwen ñakare tie amne tä kä den ngwarbe jae, aisete makwe tikaka jirekäbe, niebare kwe sribikäye. ");
INSERT INTO gymNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Akwa nura ngibiabtikä käkwe niebare ie: Ti dänkien, makwe higo krie ye tuametre kä nete. Tikwe dobo muandi dokwä bäre temen, bti tikwe abono mikadi btä. ");
INSERT INTO gymNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ye ngwä rabadi btä akwa, nane ngwä ñan rabadre btä ne ngwane, makwe tikaka ngätrite ta, niebare sribikäkwe bkänkäye. Ne abko nakaninkä kore abko erere rabadre nakenkä munbtä. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Bati köbö jadükakrä näire, Jesu nikani dirire mda sinagogate angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","meri bren nämane iti yete. Meri ye abko kä kwä jätäbti kwä kwära nikani bren. Üai käme nikani btä, käkwe trö dötaninkä, aibe kisete ñan namani nünenkä metre krö. ");
INSERT INTO gymNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Meri ye abko nämane siba yete, btä Jesu okwä namani angwane, käräbare kwe, bti niebare kwe ie: Ti mräkä, ma bikera nementa kuinta mtare, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Bti kise mikani kwe meri bren yebti. Ye btäräbe meri ye namani nünaninkäta metre krö batibe, kä nikani Ngöbö käikitekä kwäräkwärä se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yebtä abko, sinagoga ye dänkien namani romon, ñobtä ñan angwane Jesukwe meri bren mikaninta kuinta köbö jadükakrä näire, käkwe niebare ni jökräye: Kä tärä köbö ti sribikrä, aisete köbö ti ye näire mun bren bren jata ja mikakäreta kuinta, akwa köbö jadükakrä näire, mun bren bren ñan jata ja mikakäreta kuinta, niebare kwe ni jökräye. ");
INSERT INTO gymNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Abtä ni Dänkienkwe niebare mda ie: ¡Mun ngwarbe ja bä mike kuin! ¿Buey amne buro mäkäteta mun itire itirekwe angwane, köbö jadükakrä näire munta tikete ñakare, bti munta niken ngwena tomna ñaen ñakare ya? Mun jökrä tä niken jändrän ye ngwena tomna ñaen ye munta sribire ruen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ye aisete meri ne jatani Abraham mräkäkri. Niara abko bäri ütiäte jändrän ye ngwä abko kä kwä jätäbti kwä kwära neketaninte Satanaye abtä bren, ¿se abko ñan diandrekäta köbö jadükakrä näire Satana kisete ya? niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesukwe ñäkäbare kore angwane, Jesu rüe namanintre ja gaire jökrä, akwa ni mda mda abko btä kä namani nuäre jändrän kuin nuen namani Jesukwe ye tuare. ");
INSERT INTO gymNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Erere arato, Jesukwe niebare: ¿Ngöböta gobrane ño nibti? ¿Ngöböta kite gobrane nibti, ye abko tikwe bä mikadre dre kwrere ruen munye? ");
INSERT INTO gymNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ngöböta kite gobrane nibti ye abko mostasa nurai chi kwrere. Ni iti käkwe mostasa nurai nökani ju bäre jakrä abko nikani niren kri krikri kwrere angwane, nukwä namani nüne kri ye küdebti, ye kwrere jire käne Ngöböta kite gobrane ni braibe bti, akwa mrä angwane Ngöbö rabadi gobrane ni kwatibti abko bä mikata nura chi yebtä. ");
INSERT INTO gymNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ye ngwane Jesukwe kukwe mdara jire bä mikani krörö: ¿Ngöböta kite gobrane nibti ye abko tikwe bä mikadre dre kwrere ruen munye? ");
INSERT INTO gymNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngöböta kite gobrane nibti ye abko rabadi niren lebadurata niren ye kwrere abko krörö: Meri iti käkwe lebadura kitani chi arina kabre te, bti mritani kwe abti lebadura nikani arina kabre ye ñäre jökrä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yebti Jesu nikani janknu Jerusalén kukwäre mda angwane, nikani dirire juta kwatirekwatire te ji ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Angwane bati ni iti käkwe niebare ie: Ti Dänkien, ¿ni braibe rabadi dianintari ya? Abtä Jesukwe niebare mda ni jökräye: ");
INSERT INTO gymNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Munkwe ja di mika kri rikakäre gwä jukwe krä chite ta, ñobtä ñan angwane mrä ni kwati tö rabadi näin gwä akwa ñan rabadi, ");
INSERT INTO gymNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ñobtä ñan angwane ju bkänkä käkwe jukwe dikadi jite, ye ngwane mun rabadi ju bäre abko rabadi ju bkänkä ye kärere, kä rabadi niere krörö ie: Ti Dänkien, jukwe tike nunye, mun rabadi niere. Akwa niarakwe niedi munye: Mun gare ñakare tie amne mun kä mdenbo gare ñakare tie, niedi kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Angwane mun rabadi niere krörö ie: Nunkwe mröbare amne nunkwe tomna ñani gwaire mabe. Erere arato, makwe diribare nun känti, ¡ye töre ñakare mae ya! munkwe niedi. ");
INSERT INTO gymNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Akwa ju bkänkä käkwe niedi munye: Mun gare ñakare tie amne mun kä mdenbo gare ñakare tie. Mun kukwe kämekäme nuenkä nän mobe mento tibtä, niedi kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ye ngwane abko, Ngöböta gobrane, ye känti Abraham, Isaac, Jacob amne Ngöbö kukwei niekätre tädi jökrä, btä mun okwä rabadi angwane, munkwe ja müadi krikri be amne mun moto rabadi romon krübäte ju bkänkäkrä, ñobtä ñan angwane mun abko tädi kitaninkä ju bäre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Mun tädi ngwarbe ju bäre, ye ngwane abko nitre nünanka mintokwäre, mötarikri, kä driri amne nindrini abko rükadi jökrä, rabadi täkänintbe mröre gwaire jökrä Ngöböta gobrane ye känti. ");
INSERT INTO gymNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ye ngwane abko, ni ruäre ütiäte kri mtare abko rabadi ni bobre kwrere mrä amne, ni ruäre bobre mtare abko rabadi ütiäte kri mrä. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kä ye ngwane abko, nitre bariseo nükani ruäre, käkwe niebare Jesuye: Herodes tö ma kämikai, aisete nän ngitie mento nete, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Angwane Ngöbö ñan tö ne ngwane, Herodes ñan rabadre Jesu kämike ja töi jenbti, ye mikakäre gare ietre, abkokäre Jesukwe niebare mda ietre: Herodes abko nukro känsenta kwrere, ye ie mun nän niere krörö: Mtare, jetbe tikwe üai käme juanditari nibtä amne tikwe ni bren bren mikadita kuinta amne münkme tikwe sribidi ünän. ");
INSERT INTO gymNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Akwa mtare, jetbe, münkme ti näin sribire janknu ji ngrabare. Abti ti näin nebe Jerusalén, munkwe nie ie, ñobtä ñan angwane ni Ngöbö kukwei niekä abko ñan krütadre juta Jerusalén bäre mento, aisete ti näin känti. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ye btäräbe Jesukwe nitre Jerusalénbo müaiba, käkwe niebare krörö: ¡Aingwaree, mun nünanka Jerusalén nete! Käre munta nitre Ngöbö kukwei niekä müre kete amne nitre juanta Ngöbökwe ja kukwei ngwena abko müre ketata jäbti. Ye abko, kwita ngäbäli kiakia ngibiare ja ngike täni, ye kwrere käre ti tö namani mun ngibiai, akwa mun ñan tö namani ti tuai ja ngibiare, ");
INSERT INTO gymNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","aisete ju munkwe nete ne rabadi tökare jökrä mun täbtä abko tita niere munye amne, mtare mentokwäre ti ngämi kiteta, känenkri munkwe ñan ti tuadre jire chi mda, yebti munkwe ti tuadi angwane munkwe niedi krörö: Ni kitera nüke ni Dänkien Ngöbö käbti raba mikani ütiäte kri abko munkwe niedi ti ngäbti. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Bati köbö jadükakrä näire, Jesu nikani mröre bariseo ütiäte kri känti angwane, nitre bariseo mda mda namani ngibiaretari kisere kitakäre ngite. ");
INSERT INTO gymNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Angwane ni nämane iti yete abko nüen jökrä ngrabare, aisete nämane bren, btä Jesu okwä namani, ");
INSERT INTO gymNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","käkwe niebare Kukwe Biani Ngöbökwe Moiséye dirikätreye amne nitre bariseoye: ¿Köbö jadükakrä näire ni raba ni bren miketa kuinta ya, ñakare ya? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Angwane niaratre namani kwekbe jökrä. Abtä Jesukwe ni bren käräbare ja ken, mikaninta kuinta kwe, bti juaninta kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yebti Jesukwe niebare mda nitre bariseoye: Buro ya o nbi betadrekä nguse munkän köbö jadükakrä näire, ye mun rikadre jötrö ngwarbe dentarita, ye ngwane munta sribire. ¿Akwa ni bäri ütiäte jändränkrä abko tikwe mirita kuinta abtä ti ngite munta nütüre ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Angwane nitre bariseo namaninta kwekbe jökrä, ñobtä ñan angwane kukwe kwani ñakare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Angwane nitre nübaibare mröre siba abko nikani ja täkrä ni ütiäte ütiäte kräke mesabtä känene jae, bti namani nebe täkänintbe Jesu okwäbti. Abtä Jesukwe kukwe bä mikani ietre, käkwe niebare krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Nane ni iti rika ja mike gure, känti ma nübai kä ngwiankäre nuäre jabtä siba angwane, ja täkrä ni ütiäte kräke, yete ma ñan raba täkänintbe, ñobtä ñan angwane nane ni mda bäri ütiäte makrä nübaibare arato abko jatadre nüke angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ni mun nübaikä ye jatadre, käkwe niedre mae: Ja täkrä känti mata täkänintbe, ye bien ni neye, niedre kwe mae angwane, ma rikadre nebe täkänintbe mrä köre, ye abko rabadre gaidre kri makrä. ");
INSERT INTO gymNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ne aisete ma nübaikä känti ma rika angwane, ja täkrä mrä känti ma raba täkänintbe. Yebti ni ma nübaikä ye jatadre, käkwe niedre krörö mae: Ja mräkä, ja täkrä ni ütiätekrä tä mesabtä ne känti jakwe siba, niedre kwe mae, ye ngwane ma rabadre ütiäte ni mesabtä ye okwäbti abko rabadre bäri kuin. ");
INSERT INTO gymNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tita niere kore, ñobtä ñan angwane nire nire tö bikai kri au abko Ngöbökwe mikadi bobre amne, nire nire tö ja mikai bobre abko Ngöbökwe mikadi ütiäte kri, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yebti Jesukwe niebare niara nübaikä yeye: Makwe mrö sribe kri kä ngwiankrä nuäre jabtä, o ma rika ni mda mda buke mröte dere, ye ngwane ma kukwe muko, ma etba, ma mräkä mda mda amne nitre ngwian bkänkä kri nünanka känime ma bäre temen, ye aibe makwe ñan nübai mröre jabe, ñobtä ñan angwane niaratre bukadre makwe ye ütiäre ma kärädreta kwetre mröre jae, aisete makwe mrö biani ye ütiä biandita kwe mae, aisete nitre ngwian bkäne kri aibe ñan nübai makwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Akwa ma rika mrö sribere kri kä ngwiankrä nuäre jabtä angwane, makwe ni bobre nübai. Erere arato, ni bren bren ngrabare, ni nakwente amne ni okwä kä drünente nübai makwe mröre jae angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","kä rabadi nuäre mabtä, ñobtä ñan angwane niaratre ñan raba ma buketa jire mrö ye ütiäre, akwa nitre metre Ngöbö ngwärekri rükaita nire kä mrä angwane, ye näire Ngöbökwe ütiä biandi mae. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ni metre metre Ngöbö ngwärekri rükadita nire, btä Jesukwe blitabare kore, yebtä abko nitre nämane mesabtä ye ngätäite ni iti käkwe niebare mda Jesuye: Ngöbö jatadi gobrane ni ngätäite angwane, nire tädi mröre yete abko btä kä rabadi nuäre krübäte, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Abtä Jesukwe kukwe bä mikani ietre, käkwe nitre israelita ütiäte kri bä mikani ni nübaibare känekäne kwrere, käkwe niebare mda: Yebtä abko ti bike kukwe bä mike krörö munye: Bati ni iti käkwe mrö sribebare kri kwetadre, käkwe ni kwati nübaimna mröre jae. ");
INSERT INTO gymNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ye erere mrö namanina biare kwetadre angwane, ni ye käkwe niebare sribikä kweye: Nitre nübaibare tikwe, ye nän kärere amne makwe nie krörö ietre: Mrö nibira biare kwetadre, aisete mun jakwe mröre, makwe nie ietre, niebare kwe sribikä kweye. ");
INSERT INTO gymNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ye erere bkänä, sribikä ye nikani akwa, nitre nübaibare abko kwe kukwe mdara jire nämanena nuendre, aisete ñan rikadre namani niere. Ni iti käkwe niebare: Gwä tikwe kä kürü abko ti bike niken tuenbti, aisete ti ñan rikadre, ye abko munkwe dian tibti ta, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ni mda abko käkwe niebare: Tikwe buey kürü krä jätä sribikrä jae abko tä sribire kuin ya, ñakare ya abko ti bike niken nuente, aisete ti ñan rikadre, akwa munkwe dian tibti ta, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ni mdara jire abko käkwe niebare: Gwä tikwe ja miri gure, aisete ti ñan rikadre, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Angwane sribikä ye nikaninta, käkwe niebareta jökrä bkänkäye. Abtä sribikä bkänkä moto namani romon krübäte, käkwe niebare sribikä kweye: Nän jötrö ji kri ngrabare amne ji krä kiakiabti juta ngrabare nokore ni bobre känene, ni bren bren ngrabare känene amne ni okwä kä drünente känene. Erere arato, ni nakwente känene. Ma jata ngwena mröre nete, niebare kwe sribikäye. ");
INSERT INTO gymNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ye erere bkänä, sribikä jananbare. Abti bä raire angwane, sribikä jataninta, käkwe niebare bkänkäye: Ti dänkien, makwe ni kärämna tie, erere tikwe käränirira, akwa kä tä ni mda mdakrä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Angwane sribikä bkänkä käkwe niebare mda ie: Nän ni mda mda känene ji ngrabare juta bäre mento sere. Ma jata ngwena nüke nete, ñan tö raba kite akwa, ma jata ngwena ni mikakrä bäri kwati gwi ti känti nete, ");
INSERT INTO gymNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ñobtä ñan angwane nitre nübaibare känekäne tikwe, ye abko ñan rükadre jire iti mröre tibe mesabtä, niebare kwe. Ye kwrere Ngöbökwe mun ütiäte ütiäte kärädi nüne ja känti angwane, nane mun ütiäte ütiäte ñan rabadre känti, akwa ni bobre bobre rabadi. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesukwe mröbare ünän kore, bti nikani ta angwane, ni nikani kwati jiebti. Abtä niara nikwitaninte, käkwe niebare ietre: ");
INSERT INTO gymNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Nire nire tö näin tibe rabakäre ja töitikaka tibe abko käkwe ti taredre bäri jändrän jökrä bti ta. Akwa nire nire tä rün, meye, merire kwe, brare kwe, etba, ngwai kwe tarere bäri amne tä ja tarere bäri au ne ngwane, ñan rabadre ja töitikaka tibe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Erere arato, ni kämikata niken krusobtä angwane, nita niken kruso doboko ngwena au jakrä, ye kwrere nire nire käkwe ñan kötä mikadre au jakrä ja tare nikakäre tikrä amne krütakäre tikrä ne ngwane, ni ye ñan rabadre ja töitikaka tibe. ");
INSERT INTO gymNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ye abko ti bike bä mike krörö: Nane ni iti rikadre ju mike nura ngibiabtikrä angwane, ngwian tärä täte ju ye mikakrä bare täte jökrä ya, btä tä töbike käne, abti ngwian tärä täte ye ngwane tä ju mike. ");
INSERT INTO gymNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Akwa ngwian ñakare täte ju mikakrä, akwa ju kömikadretbe kwe abti rabadre ötare ñan rabadre käte ie. Yebtä abko ni jökrä rabadi ni ye kötaire, ");
INSERT INTO gymNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kä rabadre niere: ¡A! Ni se nikani ju mike akwa, namani bare ñakare ie abko ni jökrä rabadre niere kötaire kwärä kore btä. Ye kwrere mun mden tö näin tibe käkwe töbika kuin ja käne. ");
INSERT INTO gymNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Yebtä ti bike kukwe mdara jire bä mike abko krörö: Jrei tädre iti kwe rükä tädre mili krä jätä abko jatadre niken rüre jrei mda rüere. Akwa jrei mda ye abko kwe rükä tädre mili krä gre, aisete jrei kwe rükä mili krä jätäbe ye rabadre töbike käne, rükä mili krä gre ye ganaindi kwäräbe kwetre ya abko rabadre töbike. ");
INSERT INTO gymNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Akwa nane rükä mili krä jätä ben jrei ye käkwe ñan ganandre, rabadre tuen ie angwane jrei kwe rükä mili krä gre ye tädre mente angwane, ñan rüdre kwe, aisete ja mäkädreta jirekäbe kwe abkokäre nitre juandre niere kwe jrei mda yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ye kwrere abko, nire nire tö näin tibe rabakäre ja töitikaka tibe, akwa ñan tö jändrän jakwe mikaite jökrä ne ngwane, ñan rabadre ja töitikaka tibe. Ne aisete mun mden tö raba näin tibe käkwe töbika kuin käne. Abko kore se, niebare Jesukwe ni jökräye. ");
INSERT INTO gymNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yebti nire nire tö näin Jesube abko Jesukwe bä mikani mrenbtä, käkwe niebare mda: Mren abra kuin jändrän jökrä mikakrä bänänte, akwa bänän riadrekä rabadre tibo, ye abko rikadre ngwarbe, aisete ñan rabadre kuin mda, ");
INSERT INTO gymNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","amne ñan rabadre kuin dobokrä amne ñan rabadre kuin abono sribekrä, aisete rabadre ngwarbe. Abtä kitadrekä jirekäbe. Tita kukwe niere ne mun mden mden tö näin tibe käkwe ketate ja olote, bti töbika kuin btä munkwe, niebare Jesukwe ni jökräye. ");
INSERT INTO gymNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Angwane ni kwati ngwian käräkä gobran romanobokrä amne ni kwati mda mda namani tuen moto kämekäme nitre bikaka metre Ngöbö ngwärekriye, ye namani nüke Jesu ken niara kukwei nuakäre. ");
INSERT INTO gymNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Abtä nitre bariseo amne Kukwe Biani Ngöbökwe Moiséye dirikätre namani ñäke tiebe Jesu rüere, kä namani niere jae kwärikwäri: Nitre kukwe kämekäme nuenkä se kwrere abko ni noko tä kaen ngäbti jökrä amne tä mröre ketetibe ben, abtä tä ja mike ngite Ngöbö rüere ñan ñan, namanintre niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Angwane Jesukwe kukwe bä mikani krörö mda ietre, nitre namani tuen kämekäme abko ütiäte Ngöbökrä era metre mikakäre gare: ");
INSERT INTO gymNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ni iti mun ngätäite abko kwe obeja tädre gre ketarike abko riadrete krati kän, ye ngwane niarakwe ñan obeja gre ketabkä bti krä jätäbti krä ökän (99) ye mikadrete ja ngibiare kaibe kä kaibete, bti obeja kratibe nianinte, ¿ye niara ñan rikadre känentari kisere ya? ");
INSERT INTO gymNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kwandretari ie angwane, kä rabadre nuäre btä, käkwe kitadre ja kötäbti ta, bti rikadre ngwenante ");
INSERT INTO gymNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ja gwiriete angwane, niara kukwe muko nünanka känimekänime abko kärädre jökrä kwe, bti niedre kwe ietre: Obeja nianinte krati tikän abko kuninantari tie, aisete ari käi ngwen nuäre jabtä tibe, niedre kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ye kwrere abko, ni iti kukwe kämekäme nuenkä ni ne kwrere käta ja töi kwite, käta kukwe käme kite temen amne tä Ngöbö kaen ngäbti, ye abko käita neme bäri nuäre Ngöböbtä kä käinbti sete ni gre ketabkä bti ni jätäbti ni ökän käta Ngöbö mike täte era metre nütüta jabtä munkwe kwrere ye abko ie Ngöbö garera, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Bti Jesukwe niebare mda: Ye kwrere arato, meri tädre iti, kwe ngwian tädre kun jätä abko riadrete kunti kän angwane, meri ye käkwe ñotra mikadre, bti rikadre kä sökökä gwita ngwian ye känäntarikäre. ");
INSERT INTO gymNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Abti kwandretari ie angwane, kukwe muko merire merire nünanka känimekänime abko kärädre kwe, bti niedre kwe ietre: Ngwian nianinte tikän abko kuninantari tie, aisete ari käi ngwen nuäre jabtä tibe, niedre kwe kukwe mukoye. ");
INSERT INTO gymNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ye kwrere abko ni kukwe kämekäme nuenkä käta ja töi kwite, käta kukwe käme kite temen amne tä Ngöbö kaen ngäbti abko käita nebe nuäre angeletre Ngöbökwebtä kä käinbti sete, ye abko ti tö niei munye, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yebti Jesukwe kukwe mdara jire niebare angwane, nitre bariseo romon kräke abko bä mikani ngäbäkre mubai kwrere kwe amne nitre kukwe kämekäme nuenkä abko bä mikani ngäbäkre diän kwrere kwe abko krörö: Bati ni nämane iti abko kwe ngäbriänkä nämane nibu. ");
INSERT INTO gymNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ni ye abko ngobo bäri bati nikani, käkwe niebare ie: Tata, jändränta biandre tie makwe, ye erere makwe bian jötrö tie, niebare kwe rünye. Abtä rünkwe jändrän jakwe ye dräibare niaratre nibubti. ");
INSERT INTO gymNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Yebti kä ngämi niken raire ta angwane, ni bäri bati ye käkwe jändrän jakwe erere rürümoinbare jökrä, bti ngwian diani kwe, bti nikani mobe kä mdabti, känti nikani kukwe nuene ngwarbe diän diän. Abtä ngwian ganinte jökrä jakän kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ngwian krütanina jökrä kän, ye btäräbe kä ye känti mrö nika jatani krübäte, aisete niara nikani mrö nike krübäte arato. ");
INSERT INTO gymNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Angwane ni nämane iti juta yete abko israelita ñakare akwa, niara nikani sribi kärere jakrä ie. Erere bkänä, sribi bäri käme krübäte ni israelitakrä abko biani kwe ie, käkwe niara mikani mtü ngibiare. ");
INSERT INTO gymNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nämane sribire angwane, mtü buka nämane algarobate kwe abko niara tö namani nebe kwetai siba akwa, ñan namani bien jire chi kwetadre ie, aisete mrö namani krübäte ie. ");
INSERT INTO gymNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Abtä bati namani töbike: ¡Jo! Ni kwati tä ganane ti rün känti kwe mrö tärä kabre kwetadre amne ti abko kite jraine jakän mrö miare nete, ");
INSERT INTO gymNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","aisete ti bike nikenta ti rün gwiriete, käkwe niedi krörö ie: Tata, tikwe ja mikani ngite Ngöbö rüere amne ma rüere, ");
INSERT INTO gymNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","aisete makwe ñan ti kata ngäbti ja ngobo kwrere ja juete, akwa nita ganane mae, ye kwrere makwe ti mika ganane jae, tikwe niedi kore tataye, namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ye erere bkänä, nikaninta jibti, nikani nebeta rün gwiriete. Nämane mente se kwrere angwane, jatabare rünye amne namani ruen bäri bobre ie, aisete nikani betekä ngäbti, käkwe küde kitani ngärä demaine kwärä. ");
INSERT INTO gymNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Angwane ngobokwe niebare ie: Tata, tikwe ja mikani ngite Ngöbö rüere amne ma rüere, aisete ti ma ngobo makwe, ye makwe niedre ñakare mda ruen tie, niebare kwe rünye. ");
INSERT INTO gymNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Akwa rün abko käkwe niebare sribikätre kweye: Dän bäri kuinkuin känene. Munkwe kita btä amne anio ni bä mikakrä ütiäte kita kisebtä munkwe, bti sandalia kita ngotobtä munkwe niara ñan bä rabadre ni klabore kwrere abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Bti nbi ngäbäli bäri kuin ngibiata jenena mun rika tuen. Munkwe kämika kwetadre. Ngäbäkre tikwe nüta ye ari käi ngwen nuäre kri jabtä, ");
INSERT INTO gymNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ñobtä ñan angwane ni krüta kwrere jire ngäbäkre tikwe ne nianinkä ti okwäte, akwa nüta mtare. Niara nianinte tikän, akwa nürate, aisete ari käi ngwen nuäre jabtä, niebare kwe. Ye erere, ni jökrä nikani kä ngwen nuäre jabtä. ");
INSERT INTO gymNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Angwane ngäbäkre mubai abko nämane tirete, jataninta gwäkäre mda, nükani bä känime se kwrere angwane, tän ngö amne ka kukwei jarabare ie amne tärä mika nämane namani ruen ie. ");
INSERT INTO gymNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Abtä ni sribikä rünkwe käräbare iti kwe, bti niebare kwe ie: ¿Dreta nakenkä gwi? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Angwane sribikä ye käkwe niebare ie: Käre ma rünta nbi ngäbäli bäri köte ngibiare jenena, ye abko kämikamna, ñobtä ñan angwane ma etba nikani abko nüta. Niara tä kuin, aisete kä nibi nokre gwi ye, niebare kwe ie mda. ");
INSERT INTO gymNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yebtä abko ngäbäkre mubai ye mätä namani kri krübäte, ñan tö namani rikai gwä. Abtä rün nikani känti ju bäre, kä namani ngwen kisere nebeta gwi. ");
INSERT INTO gymNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Angwane niebare kwe rünye: Tikwe sribibarera kä kobe makrä, ye gare kuin mae. Erere arato, tikwe ñan ma kukwei kitabare temen. Käre tita ma kukwe mike täte jökrä, akwa ma ngämi chibo ngäbäli bien jire krati tie kwetadre, kä ngwiankrä nuäre jabtä ti kukwe mukobe. ");
INSERT INTO gymNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Akwa ma ngobo ngutu ngwarbe jananbare, meri bti kä ngwarbe ngwarbe, btä ngwian makwe ganinte jökrä makän abko kräke makwe nbi ngäbäli bäri kuin kämikamna kä ngwiankrä nuäre jabtä, niebare kwe rünye. ");
INSERT INTO gymNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Abtä rünkwe niebare ie: Ma ti ngobo tikwe, käre mata nüne gwi tibe nete amne jändrän jire jökrä tä tikwe, se abko jökrä makwe. ");
INSERT INTO gymNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Akwa ni krüta kwrere jire ma etba nianinkä ti okwäte abko nüta, nämane nianinte tikän, akwa nürate, ye abko käi ngwiandre nuäre jabtä nikwe, abkokäre tikwe mrö sribemna, niebare kwe ngobo mubaiye. Abko nakaninkä kore. Ne ngörä, niebare Jesukwe nitre bariseoye amne kukwe biani Ngöbökwe Moiséye dirikätreye. ");
INSERT INTO gymNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesukwe kukwe mda niebare krörö nitre ja töitikaka benye: Bati ni ngwian bkänkä kri nämane iti abko kräke ni mda nämane jändrän ngibiabtikä. Ni jändrän ngibiabtikä ye abko ñan nämane sribire kuin, aisete jändrän jatani nente kri sribi bkänkäkän niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Abtä sribi bkänkä käkwe sribikä kwe ye käräbare, bti niebare kwe ie: ¿Mata jändrän ngibiarebti ño tikrä amarebti ma kädrieta nüke blo tibe nete? Mata sribire ño ño tikrä, ye niere jökrä tie, ñobtä ñan angwane makwe ñan jändrän ngibiadrebti jire mda, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Abtä ni jändrän ngibiabtikä ye namani töbike kri krörö mda: Sribi bkänkä bike sribi denkä tikän mtare, nebti tikwe ja nuendi mda. Ti di ñakare sribi taretare nuenkäre amne, tita neme ja gaire ngwian kärere ngwarbe jakrä ni mda mdaye, namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Te töi ngitianinkä krörö: Sribi diandrekä tikän angwane, ni mda mda tädre biare ti kaen ngäbti ja gwiriete, abkokäre ti bike kukwe ne nuene, namani nütüre. ");
INSERT INTO gymNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Erere bkänä, ni mda mda bti rürümon ütiä nämane sribi bkänkäkwe, erere käräbare kwe ja känti. Erere ni nükani käne, ie niebare kwe: ¿Rürümon ütiäta nuäi mabti ti bkänkäkwe, niebare kwe ie? Angwane ni ye käkwe niebare: Olibo köi galon siento krä kwä ütiäta tibti, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Abtä ni jändrän ngibiabtikä käkwe niebare ie: Makwe olibo köi diani ütiädre angwane, makwe tärä ükaninte, ye makwe ükateta, aisete jötrö ngwarbe makwe olibo köi mika galon siento kräbkäbe tärä mdabtä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Yebti ni mda nükani abko ie niebare kwe: ¿Ma abko bti rürümon ütiäta nuäi ti bkänkäkwe? niebare kwe. Angwane ni ye käkwe niebare ie: Trigo sako mili krati ütiäta tibti, niebare kwe. Angwane ni jändrän ngibiabtikä käkwe niebare ie: Tärä biani käne mae, ye ükateta amne makwe trigo mika sako siento krä kwäbe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Yebtä abko ni jändrän ngibiabtikä abko ni ngökaka akwa, sribi bkänkä käkwe niara käikitaninkä töbikabtä kuin jakrä kore, ñobtä ñan angwane jändrän nuenta au jakrä, abkokrä ni töi kämekäme kä nebtä bäri tä juto biare jändrän ükete kuin jakrä ni jen Ngöbökwe ngwä. ");
INSERT INTO gymNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne aisete mun kukwe muko rabadre bäri kwati munkwe, abkokäre jändrän kabre munkwe tuen ütiäte ñakare Ngöböye, ye munkwe dräi ni bobre bobrebti. Yebti jändrän krütadre jökrä munkän angwane, ju nünankrä kärekäre kä käinbti ye känti Ngöbö tädira biare mun kakäre ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Mdakäre abko, nire nire käta jändrän braibe ngibiare kuin era metre, ni yebti abko tödekata jändrän kabre ngibiabtä kuin era metre arato. Erere arato, ni ni ngökaka jändrän braibe btä abko käkwe ni ngökadre jändrän kabrebtä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ne aisete jändrän kä nebtä ütiäte ñakare bökän akwa, mun ñan tö ngibiai kuin era metre, ¿se abko Ngöbökwe tödekadre munbti, käkwe mun mikadre jändrän bäri ütiäte kri ngibiarebti? ¡Ñakare jire! ");
INSERT INTO gymNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mdakäre abko, ¿jändrän jenena ni mdakwe munkwe ñan ngibiadre kuin era metre, se abko nirekwe jändrän biandre ngibiadre jakrä munye? ");
INSERT INTO gymNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ne aisete ni klabore ñakare jire abko rabadre sribire bkänkä nibukrä ja näire, ñobtä ñan angwane sribi bkänkä iti rabadre tare kwe amne mda btä mätä rabadre; iti kukwei mikadre täte jökrä kwe, akwa mda abko ñan kukwei mikadre täte kwe. Ne aisete ni ñan raba ja töi mike kwatibe sribire Ngöbökrä, ja töi mikare kwatibe ngwian ganankrä jae kwärä. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ye ngwane abko, nitre bariseo ngwian tarekätarekä käkwe Jesu kukwei nuani. Abtä namani Jesu kukwe mike yakrä jae. ");
INSERT INTO gymNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Abtä Jesukwe niebare mda ietre: Mun ngwarbe tä bike deme ni mda mda okwäbti, akwa mun moto ño ño gare kuin jökrä Ngöböye. Ye abko, jändrän ütiäte kri nikrä abko tä nebe tuen bäri käme Ngöböye, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yebti Jesukwe kukwe mda niebare krörö: Kukwe Biani Ngöbökwe Moiséye amne kukwe tikani nitre Ngöbö kukwei niekäkwe, ye namani mrä Juan Bautista näire. Abti mtare mentokwäre Ngöböta gobrane ño ni ngätäite abko kukwei kuin dirita niken mda amne, Ngöbökwe gobrandre nibtä, ye ni kwati tö Ngöbö mikai nuene jabtä ja di jenbti. ");
INSERT INTO gymNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Akwa nane Kukwe Biani Ngöbökwe Moiséye ye abko ñakare ütiäte mda munkrä, mun rabadre nütüre, akwa era metre ütiäte, ñobtä ñan angwane kä käinta amne kä temen ne juandre ngwarbe jökrä Ngöbökwe, akwa nin tärä okwä bäri chi tä tikani btä diandikä kwitakäre jene, ñobtä ñan angwane Kukwe Biani Ngöbökwe Moiséye abko ütiäte aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Mdakäre abko, ni brare käkwe merire kwe tuadremetre, bti meri mdara jire ben ja mikadre gure kwe, ni ye käkwe ja mikadre ngite merire käne rüere. Erere arato, meri tuanimetre brarekwe, ye ben ni mdakwe ja mikadre gure ne ngwane, ni gure käta ja mike ngite bati bati ni mda mdabe, ye kwrere ja mikadi ngite kwe, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Abti Jesukwe kukwe mdara jire bä mikani krörö: Bati ni nämane iti abko ngwian bkäne kabre krübäte, aisete nämane dän kuinkuin ütiäte krikri kite jabtä amne käre nämane mrö sribere krikri köbö kwatirekwatire kä ngwiankrä nuäre jabtä kukwe mukobe. ");
INSERT INTO gymNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kä ye känti abko, ni bobre nämane iti arato abko kädian nämane Lázaro. Lázaro ye abko ngütüete jökrä ngrabare abko nämane nebe täkänintbe jukwebtä ni ngwian bkänkä kabre ye känti. ");
INSERT INTO gymNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Angwane mrö büre nämane betekä timontimon mesabtä, ye abko ni bobre ye tö namani nebe kwetai trine ni ngwian bkänkä kabre ye känti. Angwane nukro abko nämane nebe Lázaro träin bäse. ");
INSERT INTO gymNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Yebti bati ni bobre ye krütani angwane, angele nikani ngwena kä nuäre känti yete, mikani mröre ketetibe kwetre Abrahambe. Abti ni ngwian bkänkä kabre ye krütani mda abko mräkäkwe doboi mikani jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Angwane ni ngwian bkänkä kabre ye nikani kä ja tare nikakrä känti. Ye känti nämane ja tare nike krübäte, käkwe nikrabare amne Lázaro nämane tuen täkänintbe Abraham ken ie se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Angwane ngwänänkäbare krörö kwe Abrahamye: ¡Rua Abraham, ti ngwen ruen bobre jae! Tita ja tare nike krübäte ñukwä jutrate nete, aisete Lázaro juen ja kise judabti aibe mike tibo ñöte sete, bti jata ketekä ti tüdrä mikakäre tibore nete niere ie, niebare kwe Abrahamye. ");
INSERT INTO gymNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Akwa Abraham käkwe niebare ie: Ti bräi tikwe, ma nämane nüne angwane, ma nämane jändrän bkäne kabre, bti ma nämane kä ngwen nuäre jabtä amne, Lázaro abko nämane ja tare nike kri. Mtare niarata kuin jäme amne ma tä ja tare nike. ");
INSERT INTO gymNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Mdakäre abko, kä oko kri krübäte ni jiete, ¿ne abko ni rikadre ño ja känti kwärikwäri? Ni nekri ñan raba nebe mun känti yete amne mun ñan raba nüke nun känti nete arato, niebare Abrahamkwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Abtä ni ngwian bkänkä kabre käkwe niebare mda Abrahamye: Rua Abraham, ti etbata nirike ti rün juete, ye ñan jatadre siba ja tare nika ne känti, abkokäre Lázaro juen dirire ietre tikrä abko tita ribere mae, niebare kwe Abrahamye. ");
INSERT INTO gymNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abtä Abrahamkwe niebare mda ie: Kukwe Biani Ngöbökwe Moiséye ye tärä kwetre amne nitre Ngöbö kukwei niekä käkwe tärä tikani tä kwetre arato, ye abko mikadre täte kwetre, angwane nünandre metre amne ñan rikadre kä ja tare nika känti mabe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Angwane ni ngwian bkänkä kabre käkwe niebare mda: Rua Abraham, tärä tä ti mräkäkwe ye aibe ñan rabadre dbe kräke, aisete ni krütanina abko rükadreta nire rikadre dirireta ietre abko kukwei mikadre era kwetre amne kukwe käme kitadre temen kwetre ruen tie, niebare kwe Abrahamye. ");
INSERT INTO gymNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Akwa Abraham käkwe niebare mda ie: Kukwe Biani Ngöbökwe Moiséye amne nitre Ngöbö kukwei niekä käkwe tärä tikani tä niaratre kisete abko ñan tä mike täte, ye kwrere ni krütanina rükadreta nire, rikadre dirireta ietre abko ñan kukwei mikadre täte kwetre arato. Abko kore se, niebare Abrahamkwe ie, abko nakaninkä kore. Ne ngörä, niebare Jesukwe ni jökräye. ");
INSERT INTO gymNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Bti Jesukwe niebare nitre ja töitikaka benye: Käre ni mda mda jatadi, kä rabadre ni nuente ja käne, käkwe ni mikadre ja mike ngite Ngöbö rüere, akwa aingwaree ni ni mda ngwianka ja mike ngite Ngöbö rüere. Ni ye abko bobre jakän, ");
INSERT INTO gymNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ñobtä ñan angwane niara ngämi ni mda mike kukwe käme nuene Ngöbö rüere, ye känenkri jä oto kri trigo ukwakrä ye mäkädrete rorobtä, bti kitadre ñöte abko rabadre bäri kuin kräke, ñobtä ñan angwane Ngöbökwe mikadre ja tare nike bäri ni mikabtä kukwe käme nuene ye dokwäre aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ne aisete munkwe ja ngibia kuin. Mdakäre abko, ma mräkäkwe ja mika ngite ma rüere angwane, makwe mäträ btä, abti ja töi kwitata kwe amne moto raba ulire btä ne ngwane, ja mikani ngite kwe, ye makwe dian bti ta. ");
INSERT INTO gymNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ye abko, ja mika ngite bä kükü ma rüere kwe, akwa rikata bä kükü arato niereta krörö mae: Tikwe ja mikaba ngite ma rüere, ye kwrere tikwe ñan nuendre mda, nie kwe mae, angwane ja mikani ngite kwe ma rüere, ye makwe dianta jökrä bti ta, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Angwane nitre Jesu kukwei ngwianka käkwe niebare mda ie: Dänkien, nun die mike tödeke bäri Ngöböbti, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Abtä Jesukwe niebare mda ietre: Munkwe tödekadre bäri chi Ngöböbti mostasa nura chi näre, akwa munkwe tödekadre kwatibe bti angwane, munkwe niedre kri ngätri bäri mente nguse nokoye: Ja jäkekä au yete, bti ma raba mrente sete, munkwe niedre kri yeye, ye erere mun kukwei mikadre täte kwe, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nebti Jesukwe blitabare kukwe mdabtä, käkwe niebare: Mdakäre abko, mun iti kwe ni klabore tädre abko rikadre dobo ükete sribikrä o tädre obeja ngibiare. Ni klabore ye jatadreta dere gwäkäre angwane, bkänkä käkwe ñan niedre ie: Ma dräre, aisete jakwe mröre mesabtä nete, ñan niedre jire kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Akwa niedre krörö ie: Dän mda kite jabtä, bti makwe mrö sribe tikrä. Makwe ti buka amne makwe tomna bian tie. Tikwe mrödi amne tikwe tomna ñadi ünän, yebti makwe mrödi amne makwe tomna ñadi, niedre kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Erere arato, bkänkäkwe sribi nuemna ie, erere nuendre kwe amne niara ñan käikitadrekä bkänkäkwe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ne kwrere arato, Ngöbökwe dre nuemna, ye erere munkwe nuendre täte jökrä angwane, munkwe niedre krörö ie: Nun abko ni klabore ütiäte ñakare makwe Ngöbö, ñobtä ñan angwane sribi nuemna aibe nunkwe nuenbare, aisete munkwe nie kore. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yebti Jesu nikani janknu Jerusalén kukwäre mda angwane, nikani kä Samaria amne kä Galilea ngätäite ta. ");
INSERT INTO gymNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Angwane nikani nebe ja ken juta mdabe. Ye känti ni bren lebra kisete nämane ni jätä, jatani niara ngäbti abko nükani bä mente temen se kwrere, ");
INSERT INTO gymNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kä namani ngrente krikri be krörö: Jesu, dirikä, nun ngwen ruen bobre jae. Nun mikete kuinta, namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu okwä namani btätre angwane, niebare kwe ietre: Ni blitaka Ngöböbe ni mda mda diäre, ye känti mun nän ja kwata mike tuare ietre, niebare kwe ietre. Erere bkänä nikanintre, nämane näin ji ngrabare angwane, batibe namaninante kuinta jökrä ngrabare gani kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nitre namaninta kuinta, ye ngätäite ni jataninta itibe ja jiebti, jatani ngrente krikri be Ngöbö käikitarekä kwärä. ");
INSERT INTO gymNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jatani nüketa Jesu känti angwane, nikani ngitiekä ngwärere timonkwäre Jesu ngotobtä, kuin niekäre ie. Ni ye abko, ni Samariabo aibe nükaninta Jesu känti kuin niekäre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Angwane Jesukwe niebare ie: Ni ni jätä nibita kuin jökrä ñan ñan, ¿akwa ni ni ökän abko ame ");
INSERT INTO gymNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","amarebti ni menteni ñakare israelitare aibe nüketa itibe Ngöbö käikitekä noko? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yebti Jesukwe niebare ni yeye: Makwe tödiri kwatibe Ngöböbti, köböire ma nibita kuinta, aisete näinta krö, bti nänta, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Angwane nitre bariseo nämane yete käkwe niebare Jesuye: Ngöbö rükadi gobrane ñongwane ni ngätäite abko nunkwe gadi ño, niebare kwetre ie. Abtä Jesukwe niebare ietre: Ngöbö rükadre gobrane ni ngätäite, ye abko ñan tuadre jire chi ja okwä jenbti, ");
INSERT INTO gymNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","aisete Ngöböta gobrane nete, sete, mun ñan rabadre niere, ñobtä ñan angwane Ngöbö nena gobrane munbti, akwa ye ñan raba tuen ja okwä jenbti, niebare kwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bti Jesukwe niebare nitre ja töitikaka benye: Batira jire kä jatadi angwane, ti Ni Kä Nebtä Ngobo jatadita ye mun tö rabadi tuai batibe siba, akwa munkwe ñan tuadre. ");
INSERT INTO gymNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Angwane ni ruäre rabadi niere munye: Ni Kä Nebtä Ngobo tä nete, Ni Kä Nebtä Ngobo tä sete, rabadi niere, akwa mun ñan rika tuen känti amne ni ye kwrere, jiebti mun ñan rika, ");
INSERT INTO gymNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ñobtä ñan angwane merata trä ngitiekä ngwen käinta tä jataen batibe jökrä kwäräkwärä, ye kwrere arato ti Ni Kä Nebtä Ngobo ne jatadita angwane, ni jökrä käkwe gadi batibe jökrä aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Akwa käne tikwe ja tare nikadi kri bätäkä ngwarbe amne nitre nünanka kä ne ngwane käkwe mikadi ngwarbe jae. ");
INSERT INTO gymNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Akwa ti Ni Kä Nebtä Ngobo ne jatadita angwane, kukwe nakaninkä ño ño Noé näire angwane ni jökrä nämane nüne jäme, ye kwrere arato ti Ni Kä Nebtä Ngobo ne jatadita angwane, kukwe rakadikä abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kä ye ngwane abko ñü ngämi näkäen temen, känenkri abti Noé nikani rute, ye ngwane ni jökrä tö namani nünai ño, erere nämane nüne, aisete nämane mröre, dö ñaen amne nämane ja mike gure. Te batibe ñü jatani jobe temen, käkwe ñö mikani niren kri abko nikani nitre ye ngwena jökrä abko müre neketani ñöte. ");
INSERT INTO gymNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ye kwrere nakaninkä krörö Lot näire arato: Ni jökrä nämane mröre, dö ñaen, jändrän kökö, jändrän rürümoine, nura nökö amne ju mike. Ni jökrä nämane töbike jändrän ye aibebtä. ");
INSERT INTO gymNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Angwane Lot nikaninta mräkäbe juta Sodoma bäre mento, ye btäräbe Ngöbökwe ñukwä kä käinbti juani asufrebe mni mni, käkwe nitre Sodomabo kämikani jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ye kwrere arato, ti Ni Kä Nebtä Ngobo ne jatadita angwane, kukwe rakadikä kore. ");
INSERT INTO gymNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kä ye ngwane abko, nitre tädre jubti käin amne jändrän tädre gwi kwe ñan rika tuenta ngwiandre jae, akwa gitia jirekäbe amne, ni tädre sribire tirete ye abko ñan rika jändrän tuenta jire chi gwi, akwa gitia gwängwarbe jirekäbe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Angwane kukwe nakaninkä ño meri Lokwebtä, ye munkwe ngwianta töre jae, käkwe jändrän munkwe taredre ñakare, ");
INSERT INTO gymNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ñobtä ñan angwane nire nire abko ie ja kwata rabadi ruentari tare abko krütadi kärekäre Ngöbö okwä bäre mento, akwa nire nire tä biare krüte Ngöbökrä abko käkwe nünandi kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Erere arato, ti Ni Kä Nebtä Ngobo jatadita, ye ngwane ni tädi nibu kibien jänbti deo abko jänäin iti amne iti abko mikadite. ");
INSERT INTO gymNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Erere arato, meri tädi nibu trigo ukwe gwaire abko jänäin iti amne iti abko mikadite, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Erere arato, ni tädi nibu sribire tirete abko jänäin iti amne iti abko mikadite, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Angwane nitre ja töitikaka Jesube käkwe niebare mda ie: ¿Kukwe ye abko rakadikä mdente, Dänkien? niebare kwetre ie. Abtä Jesukwe niebare mda ietre: Ni ngwäkä tädi mdente, btä jüden rabadi ja ükekrö ngwäkä kwete, ye känti rakadikä. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yebti nitre ja töitikaka Jesube ñan di krütadre blitabtä Ngöböbe, abkokäre Jesukwe kukwe mda bä mikani dirikäre ietre, ");
INSERT INTO gymNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","käkwe niebare krörö: Bati ni iti nämane kritobore juta kwati känti. Kritobo ye abko nämane Ngöbö jürä ngwen ñakare amne nämane ni mda mda mike ütiäte ñakare jae. ");
INSERT INTO gymNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Juta ye arabe känti meri kän kwäräi krütani nämane iti arato abko ben ni mda nämane rüre. Abtä meri ye nikani janknu kritobo känti kukwe ükatemna jakrä ie. ");
INSERT INTO gymNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Akwa kä raire kritobo ye käkwe kukwe ükaninte ñakare meri ye kräke. Akwa yebti kritobo namani töbike: Tita Ngöbö jürä ngwen ñakare amne tita ni mda mda mike ütiäte ñakare jae, ");
INSERT INTO gymNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","akwa meri kän kwäräi krütani se käkwe ñan ti nikadre krübäte mda, abkokäre ti bike kukwe ükete kräke, niara ñan jatadreta mda abkokäre, ñobtä ñan angwane tädre nüke janknu kore, käkwe ti moto mikadre iko. Erere arato ni mda mda käkwe ñan töbikadre blo tibtä, abkokäre ti bike kukwe ükete kräke, kritobo namani nütüre, abko nakaninkä kore. Ne ngörä. ");
INSERT INTO gymNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kritobo moto käme akwa, töbikabare kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Akwa Ngöbö abko moto kuin, se abko ni dianinkä jen jakrä kwe käta blite dibire rare ben abko ñan ngie mikadre kwe ya? ¡Niarakwe ñan juandretari jirekäbe ja jiebti! ");
INSERT INTO gymNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngöbö abra kuin käkwe ni kwekwe die mikadre jötrö. ¿Akwa ti, Ni Kä Nebtä Ngobo jatadita angwane, ni tödekaka tibti tädi blite janknu Ngöböbe kwandi ruäre tie nete ya? abko ti tö ngwiaintari munye, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Abti ni ruäre, ie ja nämane nebe ruen metre amne dbe Ngöbö ngwärekri nämane Jesu känti abko ietre ni mda mda nämane tuen käme, abtä Jesukwe kukwe bä mikani krörö ietre: ");
INSERT INTO gymNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Bati ni nikani nibu ju blitakrä Ngöböbe känti blitakäre Ngöböbe. Ni iti abko bariseo amne ni mda abko ngwian käräkä gobran romanobokrä. ");
INSERT INTO gymNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Angwane bariseo ye namani nünaninkä blitakäre Ngöböbe, käkwe niebare jabtä: Ngöbö, tita kuin niere mae, ñobtä ñan angwane ni mda mda tä gore, tä kukwe nuene kämekäme amne tä ja mike gure bati bati, ye kwrere tita nuene ñakare. Erere arato, ti ñakare ni ngututu käme ngwian käräkä noko kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mdakäre abko, tita ja bäine bobu bämän kratirekratire makrä amne, jändrän bianta keta jätä jätä tie amne jändrän ganainta keta jätä jätä tikwe abko tita bien keteti makrä, ye abko tita nuene kore makrä, niebare kwe Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Akwa ni ngwian käräkä ye abko namani bä mente temen se kwrere amne ja ñan namani nüke töre ie nikren kä käinbti, kä namani ja mete mäträte namani ulire kukwe käme nuenbtä bä mikakäre, käkwe blitabare krörö Ngöböbe: Ngöbö, ti abko kukwe kämekäme nuenkä krübäte, aisete ti ngwen ruentari tare jae amne ti ngite denkä mento tibtä, namani niere Ngöböye abko kukwe nakaninkä kore. Ne ngörä. ");
INSERT INTO gymNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kukwe yebtä ti bike kukwe ütiäte niere munye abko krörö: Ni ngwian dianka jämi niken ja gwiriete, känenkri ngite ñakare mda Ngöbökwe niebare amne kani ngäbti kwe, akwa bariseo abko ñan mikani metre ja ngwärekri kwe amne kani ngäbti ñakare kwe, ñobtä ñan angwane nirekwe ja mikadre kuin deme au abko Ngöbökwe mikadi ene, akwa nirekwe ja mikadre bobre Ngöbö ngwärekri abko Ngöbökwe mikadi ütiäte jae. Abko kore se, niebare Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ye ngwane abko ngäbäkre kiakia, bti Jesukwe kise mikadre ja di biankäre ietre, abkokäre jänikani mräkäkwe Jesuye. Akwa nitre ja töitikaka ben käkwe gani angwane, namani ñäke ngäbäkre mräkäye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Abtä Jesukwe ngäbäkre kiakia käräbare, bti niebare kwe: Ngäbäkre ye tuemetre kite tie. Munkwe ñan ji öta käne, ñobtä ñan angwane nire nire käta ja mike bobre Ngöböbtä ngäbäkre ne kwrerekwrere, ni yebti abko Ngöböta gobrane, aisete munkwe ñan ji öta käne. ");
INSERT INTO gymNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ti bike kukwe era erere niere munye abko krörö: Nire nire ñan tä ja mike bobre Ngöböbtä ngäbäkre chi kwrerekwrere, ni yebti Ngöbökwe ñan gobrandi amne ñan nünandi kärekäre Ngöböbe kwe. Abko kore se, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yebti ni iti ji dokwäte käkwe kukwe ngwianintari krörö Jesuye: Dirikä kuin, ¿tikwe dre nuendre abko ütiäre ti rabadre nüne kärekäre Ngöböbe? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Abtä Jesukwe niebare mda ie: Ngöbö aibe kuin, yebti ni mda ñakare jire kuin. ¿Ye ñobtä abko mata ti kuin niere tie ye? ");
INSERT INTO gymNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Akwa ma tö nünai kärekäre Ngöböbe angwane, Kukwe Biani Ngöbökwe Moiséye nuendre nie, ye garera mae abko erere makwe mika täte abko krörö: Ma gure, makwe ñan ja mika gure bati bati ni mda mdabe. Makwe ñan ni mda kämika. Makwe ñan go. Makwe ñan blita ngwarbe ni mda mda rüere kitakäre ngite. Erere arato, ma rün amne ma meye mika ütiäte jae, niebare Ngöbökwe Moiséye abko gare kuin mae ruen tie, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Angwane ni ye käkwe niebare: Makwe kukwe nini, ye ti nämane bati ngäbäkrere angwane, ti nikani mike täte jökrä abti kä nüke mtare tie, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Niebare kore kwe, abtä Jesukwe niebare mda ie: Jändrän tä keteti nuendre mae. Jändrän tä makwe ye erere nän rürümoine jökrä, bti makwe ngwian ye dräi ni bobre bobrebti angwane, ma rabadi jändrän ütiäte kri bkäne kabre kä käinbti sete. Makwe jändrän rürümoin ünän jökrä kore, bti ma jata ti jiebti. Abko kore se, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jesukwe kukwe niebare kore ie angwane, niara abko jändrän bkäne kabre krübäte, aisete moto namani ulire Jesu kukwei nuare. ");
INSERT INTO gymNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yebti namani tuen ulire dikaro Jesuye angwane, Jesukwe niebare: Ni jändrän bkänkä krikri ye käkwe ja mikadre bobre Ngöböbtä, Ngöbökwe gobrandre bti abko tare krübäte kräke. ");
INSERT INTO gymNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Era metre, aku okwä chi, yete ta kameo krikri ye ara rikadre nuäre, akwa nitre jändrän bkänkä kri ye käkwe ja mikadre bobre Ngöböbtä, Ngöbökwe gobrandre bti, ye abko bäri tare kräke, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Angwane nitre Jesu kukwei nuaka käkwe niebare mda ie: ¿Ni jändrän bkäne kri ñan rabadre dianintari nini makwe, se nire abko rabadi dianintari amarebti se? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesukwe niebare mda ietre: Jändrän tare nuene abtä ñan neme bare ni kä nebtäye, ye abko nuäre nuendre Ngöbökrä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Angwane Pedro käkwe niebare Jesuye: Ti Dänkien, ¿nunkwe jändrän jakwe jakwe erere mikaninte jökrä, bti nunta näin ma jiebti, aisete se abko Ngöbökwe dre biandi ütiäre nunye? niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Abtä Jesukwe niebare ie: Ti bike kukwe era erere niere munye abko krörö: Ngöböta gobrane, ye nireta kaen ngäbti, abtä ju mikaninte kwe o rün, meye o etbakantre mikaninte kwe, erere arato, meri kwe o ngäbriänkä kwekwe mikaninte kwe, ");
INSERT INTO gymNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nitre ye abko ie Ngöbökwe jändrän biandi bäri kabre mda kä ne ngwane amne mikadi nüne kärekäre jabe kwe arato. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yebti Jesukwe nitre ja töitikaka ben ni jätäbti nibu käräbare kaibe jenena, käkwe niebare ietre: Nita näin Jerusalén kukwäre. Angwane nitre Ngöbö kukwei niekä kirakira käkwe tärä tikani ño ti Ni Kä Nebtä Ngobo nebtä, ye erere rabadi bare jökrä tibtä abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nitre romanobo ñakare israelitare abko ie ti kitadi ngise amne niaratre käkwe ti mikadi yakrä jae, ñäkädi taretare kwe tie amne käli kitadi tibtä kwetre, ");
INSERT INTO gymNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","bti ti kwata metadi krübäte kwetre. Yebti ti müre ketadi kwetre, akwa köbömäkäre angwane, ti rükadita nire. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Akwa niaratre abko töi namani braibe, aisete drebtä Jesu nämane blite ñan namani nüke gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Abti Jesu nikanina mate ja ken juta Jericóte mda angwane, ni nämane iti abko okwä kä drünente nämane täkänintbe jibtä ngwian kärere jakrä, känti ta Jesu nikani nebe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Angwane batibe ni ye ie ni namani ruen näin kwati dikaro ji ngrabare niara bäre temen. Abtä dre namani nakenkä amarebti ni nikani kwati dikaro, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Angwane Jesu Nazarebo jatani ji ngrabare yete, niebare ie. ");
INSERT INTO gymNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Abtä niarakwe ngratebare kri krörö: ¡Jesu, jrei David tukwe mräkä, ti ngwen ruentari tare jae! namani ngrente jite. ");
INSERT INTO gymNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abtä nitre nämane näin Jesu käne kä namani kada ketamna ie, akwa niara namani ngwänenkä bäri krikri mda, kä namani niere: ¡Jrei David tukwe mräkä, ti ngwen ruentari tare jae! namani niere. ");
INSERT INTO gymNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Angwane Jesu namani nünaninkä, käkwe ngwiamna nüke ja känti. Erere jänükani Jesu ken angwane, Jesukwe niebare ie: ");
INSERT INTO gymNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Tikwe dre nuendre makrä, ie ma tö nibi? niebare kwe ie. Ni okwä kä drünente ye käkwe niebare mda ie: Ti Dänkien, kä rabadre tuen tie, ie ti tö nibi, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Angwane Jesukwe niebare ie: Ma nibi tödeke kwatibe Ngöböbti, ye köböire ma okwä nibirate kuinta, aisete kä raba tuen mae, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ye btäräbe kä namani tuen kuin batibe ie, bti nikani siba Jesube Ngöbö käikitekä angwane, ni jökrä käkwe kukwe ye tuani abko namani Ngöbö käikitekä arato. ");
INSERT INTO gymNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Abti Jesu nikani nebe juta Jericóte mda angwane, nikani ji ngrabare jutate. ");
INSERT INTO gymNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Juta yete abko, ni nämane iti abko kädian nämane Zaqueo. Niara abko nämane nitre ngwian käräkä gobran romanobokrä dänkiene aisete, nämane ngwian bkäne bäri kabre krübäte. ");
INSERT INTO gymNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nire abko Jesu, Zaqueo tö namani tuai, akwa Zaqueo abko chi amne ni namani kwati, aisete niara okwä ñan namani nebe Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Abtä nikani betekä käne amne okwä rabadre Jesubtä, abkokäre ji känti ta Jesu rikadre, ye känti Zaqueo nikani kribtä käin Jesu ngibiare jite. ");
INSERT INTO gymNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Zaqueo nämane, ye känti Jesu nikani nebe angwane, batibe Jesukwe nikrabare kribtä käin, käkwe niebare Zaqueoye: Zaqueo, ti rabadi ma juete mtare, aisete jakweta jötrö timon, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ye erere Zaqueo jataninta jötrö timon amne kä namani juto btä Jesu kare ngäbti ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jesu nikani Zaqueo känti ni mda mda okwäbti, yebtä abko ni jökrä namani ñäke Jesu rüere, kä namani niere: ¡Jo! Jesu bike niken ni kukwe kämekäme nuenkä gwiriete, namanintre niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ye erere Jesu nämane mröre Zaqueo känti angwane, Zaqueo namani nünaninkä, käkwe niebare ni Dänkienye: Ti Dänkien, jändrän jökrä tä tikwe, ye tikwe biandi ruäre ta ni bobre bobreye amne, nire nire kän tikwe ngwian dianinkä bäri mda ne ngwane, tikwe ngwian dianinkä kän ye bärire mda tikwe ngwian mda biandita ketabkä ietre abko ti tö niei metre mae, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Abtä Jesukwe niebare Zaqueoye: Mtare ma amne ma mräkä nibira dianintari abko mata bä mike kore. Zaqueo ne abko Abraham mräkä arato, akwa nämane mente Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ni nianinte niara kwrere abko ti Ni Kä Nebtä Ngobo ne jatani känäntarikäre amne diantarikäre, mden erere nibi bare mtare Zaqueobtä. Abko kore se, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesu nämane blite kore, ye abko ni niara kukwei nuaka nuaka, ie Jesukwe kukwe bä mikani, ñobtä ñan angwane nikanina nebe känime Jerusalén ken, aisete Ngöbö jatadre gobrane gwängwarbe niaratre ngätäite abko ni ruäre nämane nütüre, akwa nämane töbike blo, aisete Jesukwe kukwe krörö bä mikani ietre töi tikakakäre metre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Jesukwe niebare: Bati ni nämane iti. Niara abko jrei mräkä amne niara mikadre gräbti jreire, abkokäre nikani mobe kä mdate. Abti mikadrera jreire, abti jatadreta gobrane, abkokäre jatani niken. ");
INSERT INTO gymNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Akwa ngämi niken, känenkri ni klabore kwekwe käräbare ni jätä kwe, bti ngwian biani kabre kwe ja näre näre itire itire ietre, käkwe niebare: Ti bike niken mente, aisete ti mikakäre nüketa, munkwe sribi nuen ngwian nebti ti käne, abti ti jatadi nüketa, niebare kwe ietre, bti nikani. ");
INSERT INTO gymNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Akwa nitre ye bti jrei ye nämane gobrane abko mätä namani kri ni yebtä, käkwe ni mdara jire juani ni ye jiebti blitakäre krörö niara rüere: Nun ñan tö ni ne tuai jreire ja ngätäite, niedre kwetre, abkokäre juani jiebti. ");
INSERT INTO gymNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Akwa ni ye mikani jreire, bti jatani nüketa ja käite. Nükaninta angwane, ni klabore kwekwe, ie ngwian biani kwe sribikrä ye abko itire itire käkwe ngwian ganaibare nuäi mda ngwian kwebti abko tö namani gai, käkwe käräbare jökrä nüke ja känti. ");
INSERT INTO gymNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ye erere ni nükani iti käne käkwe niebare ie: Ti dänkien, ngwian makwebti tikwe ngwian ganainba keta jätä mda, tä nete ne, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Angwane jrei ye käkwe niebare ie: Ma sribikä kuin krübäte. Jändrän braibe, btä mata sribire kuin era metre, aisete ti raba tödeke mabti tä gare tie, aisete juta keta jätä, bti tikwe ma mikadi gobrane tikrä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yebti ni klabore mda jatani, käkwe niebare jreiye: Ti dänkien, ngwian makwebti tikwe ngwian ganainba ketarike mda, tä nete ne, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Angwane jrei ye käkwe niebare krörö mda ie arato: Kore ne ngwane, tikwe ma mikadi gobrane juta ketarikebti tikrä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yebti ni klabore mdara jire nükani jrei känti, käkwe niebare ie: Ti dänkien, tikwe ngwian makwe ükaba dän kukwänte jirekäbe abko tä nete ne. Tikwe sribibare ñakare bti, ");
INSERT INTO gymNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ñobtä ñan angwane mata mokrere krübäte jändrän makwebti amne ma käbäre, aisete ma ngwian bien ñakare, känti mata ngwian ükekrö ni mdakän. Erere arato, ni mda mda tä nura metekä amne mata ngwä ötö kabre kän kä ütiäre, akwa ma abko nura metekä ñakare jakrä. Ye mdenbtä ma jürä rababa krübäte tibtä, käkwe ngwian ükaba jirekäbe, niebare kwe jreiye. ");
INSERT INTO gymNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Abtä jreikwe niebare mda ie: Ma sribikä käme. Ti ño ño makwe nini tie, ye kwrere tikwe kukwe ükadite makrä. Tita mokrere krübäte jändrän tikwebti amne ti käbäre, aisete ti ngwian bien ñakare, känti tita ngwian ükekrö ni mdakän. Erere arato, ni mda mda tä nura metekä amne tita ngwä ötö kabre kän kä ütiäre, akwa ti abko nura metekä ñakare jakrä, ye gare kuin mae. ");
INSERT INTO gymNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Se ñobtä abko ma ñan jananbare ngwian tikwe mike bankote abko ti rükadreta angwane, ngwian mda biandre chi btä tie? niebare jreikwe sribikä ngwarbeye. ");
INSERT INTO gymNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bti ni mda mda nämane yete, ie jreikwe niebare: Ngwianta ni nokokwe, se denkä kän, bti sribikä kuin käkwe ngwian ganaibare keta jätä mda, seye bien munkwe, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Abtä ni mda mda ye käkwe niebare jreiye: Nun dänkien, ni noko nena ngwian bkäne kabre krübäte, ¿se ñobtä abko mda biandre ie? niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Abtä jreikwe niebare mda ietre: Ti tö kukwe era erere niei krörö munye: Nire nire jändrän bkäne kabre abko ie mda biandi bäri; akwa nire nire kwe jändrän ñakare abko kän jändrän chi kwe diandikä jökrä kän. ");
INSERT INTO gymNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mdakäre abko, nire nire namani ti rüere, ñan tö namani ti tuai jreire ye abko mun jata ngwena nüke ti känti nete, bti munkwe kämika ti ngwärekri nete. Abko kore se, niebare jreikwe abko kukwe nakaninkä kore se. Ne ngörä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesukwe blitabare ünän kore, bti nikani janknu mda Jerusalén kukwäre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nikanina mate ja ken juta Betfagébe amne juta Betaniabe, Ngitio Olibo känti angwane, nitre ja töitikaka ben käräbare nibu kwe, ");
INSERT INTO gymNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","bti niebare kwe ietre: Juta tuen känime ni ngware ta. Se känti mun nän. Mun raba yete angwane, buro ngäbäli näkwita ngämi kwan mäkäninte munye, ye tikate munkwe, bti mun jata ngwena tie nete. ");
INSERT INTO gymNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Akwa ¿Ñobtä munta tikete? nie munye angwane, munkwe nie krörö ietre: Ni Dänkien tö nibi ie, aisete nun bike niken ngwena, munkwe nie kore, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Erere bkänä, nitre ja töitikaka Jesube nikani, nikani nebe angwane, Jesukwe kukwe niebare ño ño ietre, ye erere kwani ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nämane buro tikete angwane, buro bkänkätre jatani, käkwe niebare ietre: ¿Ñobtä munta buro ye tikete nunkän ye? niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Angwane niebare kwetre buro bkänkäye: Nun Dänkien tö nibi ie, käkwe käräniri, aisete nunta tikete, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yebti nikanintre buro ngwena, nikani nebe Jesu känti angwane, dän jakwe mikani ötati buro ngäbäli ye tröbti kwetre ja täkräre Jesuye, bti Jesu nakwani buro yebti. ");
INSERT INTO gymNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bti Jesu nikani janknu mentokwäre angwane, ni jökrä namani dän jakwe metete ji ngrabare temen Jesu kakäre ngäbti jrei kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Angwane Jesu nikanina Ngitio Olibobti käin, jatanina niken motokwäre amne, nitre nämane näin ben, btä kä namani nuäre, kä nikani ngrente krikri be Ngöbö käikitarekä, ñobtä ñan angwane sribi kri ñan tuabare nuenbare Jesukwe tuani kwetre yebtä, ");
INSERT INTO gymNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","kä namani niere: Jrei ne kite ni Dänkien Ngöbö käbti. Ma ye aibe raba mikani ütiäte. ¡Kä raba jäme kä käinbti amne, nunta Ngöbö kä käinbti käikitekä! namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kukwe yebtä, nitre bariseo nämane ruäre ni mda mda ngätäite yete käkwe niebare Jesuye: Dirikä, nitre nänkä mabe se käkwe kada ketadre niere ietre, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Akwa Jesu käkwe niebare nitre bariseoye: Nitre noko rabadre kwekbe angwane, jä oto kabre nere temen käkwe ngradrete Ngöbö käikitakakäre, aisete ngwarbe tikwe kada ketamna ietre abko ti tö nibi niei metre munye, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yebti Jesu namanina Jerusalén ken, okwä namani juta Jerusalénbtä angwane, müaibare kwe, ");
INSERT INTO gymNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","käkwe niebare: Nirekwe kä jäme biandre mun nünanka Jerusalénte yeye, ye rükadre gare mtare munye näre, akwa tä rükaninte mun okwä bäre, aisete tuen ñakare munye. ");
INSERT INTO gymNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Batira jire kä jatadi käme mun rüere angwane, mun rüekwe ki mikadi mun bäre temen amne, mun rüe rabadi jökrä mun bäre temen, käkwe rüdi mun rüere angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","mun juandi ngwarbe jökrä kwetre amne, nitre nünanka nete noko kämikadi kwati kwetre. Erere arato, jä mikani jure amne kire noko dikandite jökrä kwetre arato, ñobtä ñan angwane Ngöbö nükani basare munye, mun diantarikäre akwa, ñan nükani gare munye, aisete rakadikä kore mun nünanka Jerusalénte yebtä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesu nükani Jerusalén, bti nikani ju blitakrä Ngöböbe ye bäre angwane, nitre nämane jändrän rürümoine yete abko Jesu nikani juentari jökrä nekwäre, sekwäre mentokwäre, ");
INSERT INTO gymNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","käkwe mäträbare krörö btätre: Ngöbö Kukwei tä tikani krörö: Ju tikwe ne abra tä blitakrä tibe, nieta Ngöbö Kukweibtä, akwa mun abko tä ju blitakrä Ngöböbe ne mike nitre gokä jue kwrere. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yebti ju blitakrä Ngöböbe bäre Jesu namani dirire käre köbö kwatirekwatire. Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkien amne Kukwe Biani Ngöbökwe Moiséye dirikätre, erere arato nitre unbre ji dokwäte nitre israelita ngätäite abko nämane ji känene jae Jesu kämikakäre. ");
INSERT INTO gymNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Akwa ji ñan namani kwen ietre Jesu kämikakrä, ñobtä ñan angwane Jesu namani blite, ye abko ni jökrä nämane biare kukwe nuen, aisete Jesu kämikadre ño kwetre abko käi ñan namani kwen ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bati ju blitakrä Ngöböbe ye bäre Jesu nämane dirire ni kwatiye amne nämane kukwe kuin Ngöbökwe mike gare angwane, nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne Kukwe Biani Ngöbökwe Moiséye dirikätre nikani nitre unbre ji dokwätebe, ");
INSERT INTO gymNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","käkwe niebare Jesuye: ¿Nirekwe ma mikani sribi nuene kore amne nire diebti mata kukwe nuene kore nete? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Abtä Jesukwe niebare ietre: Ti bike kukwe ngwentari kwati arato munye. ¿Nirekwe Juan Bautista juani ni ngökö ñöte? ¿Ngöbökwe juani ya o ni kä nebtäkwe mikani sribire ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yebtä nikaninta blite jabe kwärikwäri, kä namani niere krörö: Ngöbökwe juani, nikwe niedre ie angwane, niarakwe niedre krörö mda: Ngöbökwe juani munta niere, ¿se ñobtä abko munkwe ñan kukwei mikani era jae? niedre kwe nie. ");
INSERT INTO gymNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Akwa ni kä nebtäkwe mikani, ni ñan rabadre niere jire chi ie, ñobtä ñan angwane Juan abko ni Ngöbö kukwei niekä era ni jökrä kräke, aisete ni mda mdakwe ni kämikadre jäbti ñäkäbtä kore rüere, namanintre niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Abtä niebare krörö kwetre Jesuye: Nirekwe Juan juani, ye gare ñakare nunye, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Angwane Jesukwe niebare mda ietre: Kore ne ngwane, nirekwe ja di biani tie sribi ne nuenkäre abko tikwe ñan niedre munye arato, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yebti nitre nämane yete, ie Jesu nikani kukwe bä mike Kukwe Biani Ngöbökwe Moiséye dirikätrebtä amne nitre blitaka Ngöböbe ni mda mda diäre dänkientrebtä, käkwe niebare krörö: Bati ni nämane iti käkwe uba nurai nökani, bti biani kwe ni mda mdaye sribikrä. Kä biani sribikrä kwe abko ütiäre uba döi biandreta ruäre ie. Yebti nikani raire kä mdabti. ");
INSERT INTO gymNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Abti uba ngwä ötadre abko käi nükani angwane, sribikä käkwe uba biandreta ruäre kä bkänkäye, ye abko kä bkänkä käkwe sribikä kwe juani iti tuenta jakrä. Akwa sribikätre ubabtä ye käkwe sribikä ye metani ja ñäte kwäräkwärä se kwrere, bti juanintarita kise tökare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Yebti kä bkänkä käkwe sribikä mdara jire juani uba tuenta ruäre jakrä, akwa sribikätre ubabtä käkwe sribikä ye metani ja ñäte arato, käkwe ñäkäbare diän diän ie, bti juanintarita kise tökare kwetre arato. ");
INSERT INTO gymNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yebti uba bkänkä käkwe sribikä mdara jire juani uba tuenta, akwa sribikä mda mda ye käkwe metani arato, bti kitaninkä kwetre uba grä bäre mento. ");
INSERT INTO gymNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Yebti ni uba bkänkä käkwe niebare jae: ¿Mtare tikwe dre nuendre mda? namani nütüre. Te batibe töi ngitianinkä, käkwe niebare: Ti odei tare kri tikwe abko ti bike juen. Nane niara mikadre ütiäte jae sribikätrekwe, raba ruen tie, aisete ti bike niara juen, niebare kwe jae. ");
INSERT INTO gymNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ye erere bkänä juani kwe. Akwa kä bkänkä ye odei nikani tuen sribikätre ubabtä yeye angwane, niebare kwetre jae kwärikwäri: Ni se abko rabadi jändrän rünkwe bkäne jökrä, aisete ari kämike amne ni rabadi kä ne bkäne jökrä, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ye erere niaratre nikani kä bkänkä odei ye ngwena uba grä bäre mento, bti kämikani kwetre se kwrere abko nakaninkä kore. Ne ngörä, niebare Jesukwe. Bti Jesukwe niebare ni jökräye: ¿Ne ngwane, uba bkänkä käkwe dre nuendre sribikä yebtä raba ruen munye? ");
INSERT INTO gymNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Niara rikadre, käkwe sribikätre ye kämikadre jökrä, bti uba grä ye biandre ni mda mdaye kwe sribikrä. Abko kore se, niebare Jesukwe. Ye jarabare ni jökräye angwane, niebare kwetre: ¡Kukwe ñan rakadrekä jire kore! niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Akwa Jesu käkwe mikani ñäräre, bti niebare kwe ietre: Kukwe tä tikani Ngöbö Kukweibtä ne käta dre niere abko niere tie munkwe: Jä ütiäte kri ju mikakrä metre abko nitre ju mikaka käkwe kitaninkä, akwa jä ye abko ni Dänkien käkwe mikani bäri ütiäte ju mikakrä metre. nieta Ngöbö Kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Angwane ni ütiäte kri jä kwrere tikwe nini, ye abko btä nire nire ritadrete amne rikadre temen jä yebti angwane, jä ye käkwe ni ye ötadibtä kiakia jökrä ngrabare. Erere arato, nire nire bti jä ye rikwitadrekä angwane, gütadikä mnüne jökrä jä ye täni arato. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yebtä abko, Kukwe Biani Ngöbökwe Moiséye dirikätre amne nitre blitaka Ngöböbe ni mda mda diäre dänkientre, rüere Jesukwe kukwe bä mikani kore gani kwetre jabtä. Abtä jötrö ngwarbe tö namani Jesu kain ngite ye näire, akwa ni nämane kwati Jesu kukwei nuen, ye abko jürä namani btätre, aisete namani kwekbe. ");
INSERT INTO gymNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Angwane ni juani ruäre kwetre Jesu ngibiaretari mda. Niaratre abko namani bike moto jäme, akwa Jesu ngwiandre kukwe nainte kwetre, abtä kitadre ngise kwetre gobernador romanobo ngwärekri, abkokäre namani bike moto jäme. ");
INSERT INTO gymNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Namani Jesu känti angwane, niebare kwetre ie: Dirikä, mata kukwe niere amne mata dirire, ye abko era metre gare kuin nunye amne, ma ñan tä dirire ni ruäre aibe moto mikakrä nuäre, akwa ji Ngöbökwe abko dirita era metre makwe, ye garera nie. ");
INSERT INTO gymNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ye aisete nun tö kukwe ngwiaintari mae abko krörö: ¿Emperador romanobo César abko ie nunkwe ja ütiä biandre ye abko dbe ya, ñakare ya niere nunye? niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Angwane tö namani Jesu ngökai, ye gani Jesukwe btätre, käkwe niebare ietre: ");
INSERT INTO gymNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ngwian ye mike tuadre kunti tie munkwe, niebare Jesukwe ietre. Erere biani tuadre kwetre Jesuye angwane, Jesukwe niebare mda ietre: ¿Nire bä amne nire käi tä tikani ngwian nebtä? niebare kwe. Angwane niebare kwetre ie: Emperador César bä amne käi tä btä, niebare kwetre mda Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Abtä Jesukwe niebare mda ietre: Jändrän emperadorekwe erere munkwe bian emperadoreye amne jändrän Ngöbökrä erere munkwe bian Ngöböye. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jesukwe kukwe kani ngäbti kuin ni jökrä okwäbti, yebtä abko töi ñan namani krütare amne, kukwe kwani ñakare ietre Jesu kitakrä ngise, aisete namanintre kwekbe jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yebti nitre saduseo nikani ruäre ja tuakäre Jesube. Nitre saduseo ye abko ni krütanikrütani mikadreta nire Ngöbökwe abko ñan nämane mike era, aisete jatani kukwe ngwentari Jesuye, käkwe nieba ie: ");
INSERT INTO gymNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Dirikä, Ngöbökwe tikamna krörö täräbtä nunkrä Moiséye: Ni iti tädre gure akwa, ngäbäkre ñakare kwetre amne ni ye krütadre angwane, merire rabadre kaibe. Meri ye abko yäräkwe diandre jae mda. Yebti ngäbäkre rabadre kwetre angwane, ngäbäkre ye abko rabadre niara etba krütani ngobo kwrere abko tikani täräbtä Moisékwe nunkrä. ");
INSERT INTO gymNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ne aisete nun tö nibi kukwe ne ngwiaintari krörö mae: Bati nitre ja etbarebe nämane ni kükü. Nitre ye etba mubai käkwe ja mikani gure, akwa ngäbäkre ngämi nebe kwetre angwane, ni ye krütani. ");
INSERT INTO gymNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Merire namani ie abko namani yärä mda yebe, akwa nin ngämi ngäbäkrei ngibiare angwane, brare krütani kän arato. Meri ye namaninta kaibe bobukäre. ");
INSERT INTO gymNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Namani yärä mdara jire ben, akwa nin ngämi ngäbäkrei ngibiare angwane, krütani kän arato. Ye kwrere nikani nakenkä janknu ja täritäri. Abti nitre ni kükü ye krütani jökrä meri ye kisete, akwa nin ngäbäkrei ngibiabare jire iti kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Abti mrä meri ye krütani abko kukwe nakaninkä kore nieta. ");
INSERT INTO gymNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Akwa ni krütani rükadreta nire mata niere, aisete ni brare ni kükü, ben meri ye namani jökrä, abti niaratre ni kükü ye rükadreta nire jökrä angwane, meri ye rabadi nire nän mukore abko niere nunye, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Angwane Jesukwe niebare mda ietre: Kä ne ngwane, ni brare amne ni merire käta ja mike gure, ");
INSERT INTO gymNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","akwa kä mrä, ni rükadreta nire angwane, nire nire tuen ütiäte Ngöböye nünakäre kärekäre jabe abko ni merire, brare käkwe ñan ja mikadre gure. ");
INSERT INTO gymNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ni ñan krütadre mda, akwa ni rabadre angeletre Ngöbökwe kwrere. Erere arato, ni rükadita nire angwane, ni rabadi Ngöbö odeire jökrä, aisete ni rabadi ja etbare amne ja ngwaire, aisete ñan ja mikadre gure. ");
INSERT INTO gymNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Akwa kri chi namani jutra ngitiekä, ye känti ni rükadreta nire era metre abko Moisékwe bä mikani, käkwe niebare: Ni Dänkien Ngöbö abko Ngöbö Abrahamkwe, Isaakwe amne Jacobokwe, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ye abko, Abraham, Isaac amne Jacob krütanina abti Ngöbökwe niebare kore Moiséye. Ngöbö abko ñan ni ngwäkäre Ngöböi akwa Ngöbö abko ni nire Ngöböi gare nie. Ye aisete Abraham, Isaac amne Jacob tä nüne janknu Ngöbö ngwärekri abko gare nie. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ye ngwane, Kukwe Biani Ngöbökwe Moiséye dirikätre nämane yete, btä käi namani nuäre, ñobtä ñan angwane ni rükadreta nire abko era kräke. Yebtä abko niebare kwetre: Dirikä, makwe blitaniri kuin krübäte, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Angwane kä jürä namani ni jökräbtä, käkwe kukwe ngwianintari ñakare mda Jesuye ja gakäre ben. ");
INSERT INTO gymNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yebti Jesukwe kukwe ngwianintari krörö mda nitre Saduseo yeye: ¿Ñobtä Ni Dianinkä Ngöbökwe abko däredre jrei David tukwekri nieta munkwe ");
INSERT INTO gymNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","amarebti David ara jire käkwe kukwe tikani krörö tärä Salmobtä?: Ti Dänkien Ngöbö käkwe nieba ti Dänkienye: Kä bäri ütiäte kri ti küde ruenkri, ne känti jakwe täke nete. ");
INSERT INTO gymNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ye känti ma raba abti tikwe ma rüe mikadi jökrä ma ngoto täni, niebare Davikwe Ni Dianinkä Ngöbökwe yebtä. ");
INSERT INTO gymNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David ara jire käkwe ja Dänkien niebare Ni Dianinkä Ngöbökwebtä, ¿se ñobtä abko Ni Dianinkä Ngöbökwe abko jatadre Davikri nieta munkwe se? Tita ngwentari kore, ñobtä ñan angwane nita Dänkien niere ñakare jire ni mräkä bäri mrä nikrä yeye, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ni jökrä nämane Jesu kukwei nuen angwane, batibe Jesukwe niebare mda nitre ja töitikaka benye: ");
INSERT INTO gymNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Kukwe Biani Ngöbökwe Moiséye dirikätre, ye ngäniene munkwe ja ngibia kuin, ñobtä ñan angwane niaratre tä dän nga ütiäte kri kite jabtä, bti ni jökrä käkwe köbö ngwiandretari käne ietre kä jändrän rürümoinkrä ye käntita temen, ie töta nebe. Erere arato, ja täkrä ni ütiäte ütiäte kräke sinagogate, känti töta nebe rabai täkänintbe amne ja täkrä ni ütiäte ütiäte kräke, känti tätre nebe täkänintbe. Erere arato, niaratre nübaita bietabtä angwane, ja täkrä ni ütiäte ütiäte kräke, känti tö täkäi temen. ");
INSERT INTO gymNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Erere arato, meri kän brare krütani abko kän tätre ju denkä abti tätre bike kuin, käta blite raire Ngöböbe, akwa yebtä Ngöbökwe mikadi ja tare nike krübäte, aisete munkwe ja ngibia kuin Kukwe Biani Ngöbökwe Moiséye dirikätre ngäniene. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ye ngwane abko, nitre ngwian bkäne krikri namani nüke ngwian kite kajate Ngöbökrä ju blitakrä Ngöböbe bäre Jesu okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Angwane meri bobre kän brare krütani abko jatani, käkwe ngwian sentabo kwrere kitani kubube arato kajate Jesu okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Abtä Jesukwe niebare: Ti bike kukwe era erere niere munye abko krörö: Meri bobre kän brare krütani se käkwe ngwian bini bäri kabre ni ngwian bkäne krikri se ngwä, ");
INSERT INTO gymNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ñobtä ñan angwane niaratre käta ngwian namaninte ie aibe bien, akwa meri bobre ye abko käkwe ngwian ngörä nünankrä kwe erere bini jökrä, aisete niarakwe ngwian bini bäri kabre, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Angwane ju blitakrä Ngöböbe mikakrä bä nuäre amne, ni ruäre käkwe jändrän tuäretuäre biani Ngöböye, bti ju mikani tuäre, yebtä abko ni ruäre nämane blite mda. Abtä Jesukwe niebare ietre: ");
INSERT INTO gymNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Köböitira jire ju tuata munkwe se juandi ngwarbe jire jökrä, aisete jä ketani jabti jabti se juandi jökrä temen, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abtä nitre nämane yete käkwe niebare mda Jesuye: Dirikä, ¿ju blitakrä Ngöböbe juandi ngwarbe nini makwe, ye abko rakadikä ñongwane nun tö gai? Arato kukwe ye kebera nakenkä abko bä mikadi ño nunye abko makwe niedre nunye, ie nun tö nibi, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Abtä Jesukwe niebare mda ietre: Bäri käne abko, nitre ni ngökaka ye ngäniene munkwe ja ngibia kuin, ñobtä ñan angwane ni jatadi kwati ti käbti käkwe niedi krörö: Ti abko Ni Dianinkä Ngöbökwe ara tä nete amne, kä mrä nükera ja ken, niedi kwetre. Akwa niaratre ye abko ni ngökaka, aisete mun ñan rika niaratre jiebti. ");
INSERT INTO gymNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Erere arato, munkwe kukwe krörö gadi: Nitre tädi rüre jabe kwärikwäri ga munkwe angwane, munkwe ñan kä jürä ngwian jabtä, ñobtä ñan angwane kukwe ye abko rakadikä käne kore abko erere rabadi nakenkä, akwa ye ngwane kä mrä ñan jatadi jötrö, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yebti Jesu nikani blite janknu, käkwe niebare: Kä mrä ngämi nüke juta kwatirekwatire rabadi rüre jabe kwärikwäri amne nitre nünanka kä ketareketare te rabadi rüre jabe kwärikwäri amne, ");
INSERT INTO gymNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","dobo rabadi nakaenkä kri krübäte, mrö nika rabadi kri krübäte amne bren nika rabadi krübäte kä ngrabare temen amne Ngöbökwe jändrän krikri krübäte mikadi tuadre käinta, abtä kä jürä rabadi kri ni kwatibtä. ");
INSERT INTO gymNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Akwa kukwe ye ngämi nakenkä, känenkri ni kwati jatadi mun rüere. Sinagoga nitre israelitakwe käntikänti mun jänäin kritobo ngwärekri kwetre, bti mun kitadi ngite kä teri kwetre. Erere arato, jrei amne gobran, ie mun kitadi ngise tödekabtä tibti. ");
INSERT INTO gymNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Akwa ye ngwane, tikwe dre dre nuenbare abko kräke kä rabadi kuin munye blitakäre tibtä nitre ye ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mun jä ngämi niken kritobo ngwärekri, känenkri munkwe ja kwetadi ño ja dokwäre, yebtä munkwe ñan töbika dikaro, ");
INSERT INTO gymNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ñobtä ñan angwane tikwe ja kukwei töbtä kri mikadi gare munye blitakäre ja dokwäre, ye käkwe mun rüe kukwe ötadi jökrä angwane, rabaditre kwekbe jökrä mun käne. ");
INSERT INTO gymNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Akwa ye ngwane abko, mun rün, mun meye, mun etba, mun ngwai, mun mräkä mda mda amne mun kukwe muko abko rikwitadi mun rüere, ye käkwe mun kämikadi ruäre. ");
INSERT INTO gymNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Angwane ni jökrä mätä rabadi kri munbtä tödekabtä tibti. ");
INSERT INTO gymNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Akwa mun ñan riadrete, abkokäre Ngöbökwe mun ngibiadi kuin jökrä, ");
INSERT INTO gymNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","aisete munkwe nünanka dite jabtä angwane, mun rabadi dianintari, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yebti Jesukwe niebare krörö mda: Nitre rükä raba tuen jökrä juta Jerusalén se bäre temen munye angwane abko, juta se juan kebera ngwarbe, ye rabara gare munye. ");
INSERT INTO gymNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ye ngwane mun tädre Judeate ye abko gitia mintokwäre amne nire nire tädre juta Jerusalénte abko gitia juta bäre mento amne, nire nire tädre Jerusalén bäre abko ñan rika ngitieta juta Jerusalénte, ");
INSERT INTO gymNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ñobtä ñan angwane kukwe tä tikani Ngöbö Kukweibtä, ye rabadre bare jökrä, abkokäre Ngöbökwe nitre nünanka kä nebtä mikadi ja ngie nuen kri köbö ye näire. ");
INSERT INTO gymNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Akwa meri doboko doboko amne meri kwe ngäbäkre kiakia kianbtä, ye abko bobre jakän, ñobtä ñan angwane niaratre ñan raba ngitie jötrö, ¡ye abko ñan bobre jakän ya! Kä ye ngwane abko ja tare nika rabadi kri krübäte kä nebtä amne nitre israelita käkwe ja ngie nuadi kri krübäte. ");
INSERT INTO gymNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ne aisete ni ruäre kämikadi ngitrabti amne ni ruäre abko jänäin ngite juta mda mdate angwane, nitre ñakare israelitare, kräke Ngöbökwe köbö kitani nuäi, ye näre juta Jerusalén mikadi ja ngoto täni kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kä mrä angwane, Ngöbökwe sribi kri ñan tuabare nuendi abko bä mikadi kwe ñänänbtä, söbtä amne mukebtä. Angwane ni kä nebtä töi rabadi ngwarbe kwäräkwärä amne mren rabadi romon krübäte, aisete ngö rabadi nebe kri krübäte. Yebtä abko, ni jökrä rabadi töbike kri. ");
INSERT INTO gymNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Erere arato, ni kwati rabadi nekwetekä krübäte amne kä rabadi nötöte bti, ñobtä ñan angwane kukwe rakadikä ño kä nebtä abko rabaditre töbike, ñobtä ñan angwane jändrän jökrä käinta se rabadi grükekä ye abko jürä rabadi kri ni kwatibtä. ");
INSERT INTO gymNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Angwane ti Ni Kä Nebtä Ngobo abko jatadi tuen ja di kri bä nuärebti mütabti kä käinbti sete abko ni jökrä käkwe tuadi. ");
INSERT INTO gymNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ne aisete, kukwe nini tikwe ye erere rabara nakenkä mun okwäbti angwane, munkwe kä ngwian nuäre jabtä, ñobtä ñan angwane Ngöbö kebera nüke mun tiketeta, aisete munkwe kä ngwian nuäre jabtä, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ye btäräbe, kukwe yebtä Jesukwe kukwe bä mikani krörö mda, käkwe niebare: Higokrie amne kri mda mda, ye mika ñäräre munkwe, btä munkwe töbika. ");
INSERT INTO gymNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kri ye tä mutu ngitiekä angwane, kä töre tärä kite nüke ja ken munta gain, ");
INSERT INTO gymNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ye kwrere arato kukwe nini tikwe ye jata nakenkä jökrä mun okwäbti angwane, Ngöbö kebera nüke gobrane ye rabara gare munye. ");
INSERT INTO gymNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ti bike kukwe era erere niere munye abko krörö: Nitre nünanka kä nebtä ngämi krüte jökrä, ye känenkri kukwe nini tikwe ye erere rakadikä jökrä. ");
INSERT INTO gymNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mdakäre abko, kä käinta se btä kä temen ne abko Ngöbökwe gadikä jökrä, angwane rikadi ta, akwa ti kukwei abko rabadi kärekäre, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yebti Jesukwe niebare mda: Munkwe ja ngibia au, munkwe ñan ja töi mika jändrän diän diän nuenbtä amne, munkwe ñan dröba nika amne munkwe ñan töbika jändrän kä nebtä ye aibebtä, ñobtä ñan angwane munkwe ñan ja ngibiadre au ne ngwane, mun kwandre jäme köbö ye näire aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Amne jändrän ngwarbe tä niken jäme, bti batibe tä neme kö okwäte, ye kwrere mun ñan tädre jäme, abkokäre munkwe mokre jabti, ñobtä ñan angwane nire nire kä nebtä tädi jäme, tädi ti ngibiare ngäbti ñakare angwane, ti jatadita. ");
INSERT INTO gymNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Akwa kärekäre mun abko käkwe ja mika biare ti ngibiare ngäbti amne munkwe blita Ngöböbe jakrä angwane, kukwe jatadi taretare yebtä munkwe kwäräbedi jökrä amne, mun rabadi biare rabakäre ti Ni Kä Nebtä Ngobo ne ngwärekri. Abko kore se, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Kä ye ngwane abko, käre köbö kwatirekwatire Jesu namani dirire ju blitakrä Ngöböbe ye bäre amne, ni kwati namani nüke dekä niara kukwei nuen, akwa deo abko Jesu nämane niken kibien Ngitio Olibo känti. ");
INSERT INTO gymNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kä ye ngwane, bieta Te Lebadura Ñakare Bante kweta nämane Ngöbö mikakäre ütiäte. Bieta ye arabe kädian nämane Pascua abko erere köbö jatanina nüketa ja ken. ");
INSERT INTO gymNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne Kukwe Biani Ngöbökwe Moiséye dirikätre abko käkwe Jesu müre ketadre ño abko namanintre ngibiaretari kisere, akwa ni nämane kwati nekete Jesukri abko jürä namani btätre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Angwane nitre ja töitikaka Jesube ni jätäbti nibu, ye ngätäite ni iti kädian nämane Judas Iscariote abko btä Satana nikani. ");
INSERT INTO gymNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ne aisete nikani nitre blitaka Ngöböbe ni mda mda diäre dänkientre känti amne nitre ju blitakrä Ngöböbe guardia dänkientre känti angwane, Jesu kitadre ngise kwe ietre kämikadre abko nikani kädriere bentre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Angwane kä namani nuäre kri btätre, käkwe ngwian bian braibare Judaye, ");
INSERT INTO gymNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ye abko nükaninbti Judaye angwane, Judakwe kitadre ngise ño rüeye ni mda mda okwä bäre abko Judas namani ngibiare kisere jae mda. ");
INSERT INTO gymNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nebti bieta Te Lebadura Ñakare Bante Kweta nämane ye nükani mda. Köbö ye näire kordero kämika nämane kwetadre Pascua köböite abko köböi nükaninta. ");
INSERT INTO gymNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Abtä Jesukwe Pedro amne Juan käräbare, bti niebare kwe ietre: Mun nän mrö sribere kwetadre Pascuate, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Niaratre käkwe niebare mda Jesuye: ¿Nunkwe mrö sribedre mdente, ie ma tö nibi? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Angwane Jesukwe niebare mda ietre: Mun rika nebe jutate. Ye känti ni brare tädi iti ñö ngwena kantrate abko rükadi ngätäi munbe ji ngrabare. Ni ye rika mdente gwä, känti mun rika. ");
INSERT INTO gymNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mun rika nebe gwi angwane, munkwe nie krörö ju bkänkäye: Dirikäkwe mrö Pascua köböikrä kwetadi nitre ja töitikaka benbe abkokrä käta ükaninte mdente, ngwiantarimna kwe, munkwe nie kore ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Angwane ju mikani bobu jabti käin, te kä kri tädira ükaninte biare mrökrä, känti mun jänäin kwe. Ye känti munkwe mrö sribe biare nunkrä amne jändrän jökrä ükate biare. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ye erere bkänä nikanintre angwane, Jesukwe kukwe niebare ño ño ietre, erere kwani ietre, känti mrö sribebare kwetre kwetadre Pascuate. ");
INSERT INTO gymNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ye erere, mrö käi nükani angwane, Jesu nikani, namani täkänintbe mesabtä nitre niara kukwei ngwiankabe angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","niebare kwe ietre: Ti ngämi krüte, känenkri bäri ti tö namani mrö Pascuakrä ne kwetai munbe gwaire abko erere käi nüra mtare. ");
INSERT INTO gymNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ti tö namani mrö Pascuakrä ne kwetai kore munbe, ñobtä ñan angwane Ngöbö ngämi gobrane ni ngätäite, känenkri tikwe ñan mrö Pascuakrä ne kwetadreta jire mda, akwa batibe kukwe bä mikata mrö Pascuakrä nebti rabadi bare angwane, tikwe kwetadita, niebare Jesukwe nitre ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bti uba döi nämane basote diani kisete kwe, kuin niebare btä kwe Ngöböye, bti niebare kwe nitre ja töitikaka benye: Uba döi ne ñaen ja täritäri munkwe, ");
INSERT INTO gymNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ñobtä ñan angwane Ngöbö ngämi gobrane ni ngätäite, ye känenkri tikwe ñan uba döi ñadreta jire mda abko ti tö nibi niei munye, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Yebti Jesukwe ban diani kunti kisete, kuin niebare btä kwe Ngöböye, bti ötaninbtä kwe, bti biani kwe nitre ja töitikaka benye, käkwe niebare ietre: Ban ne abko ti ngätä ara. Ne mden abko tita bien müre ketadre mun kräke. Käre munkwe ban ne kweta kore ti ngwiankrä töre jae, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ye kwrere arato, uba döi nämane basote abko Jesukwe diani kisete, käkwe niebare nitre ja töitikaka benye: Uba döi ne abko ti därie tikwe ara. Ti krütadi angwane, ti därie rimiadite munkrä, köböire Ngöbökwe kukwe ükaditeta btin munbe, ye mden abko uba döi ne tä bä mike. ");
INSERT INTO gymNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Akwa ni ti kitaka ngise ti rüeye abko tä mröre ketetibe tibe mesabtä nete. ");
INSERT INTO gymNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ne abko, ji ükaninte Ngöbökwe ti Ni Kä Nebtä Ngobo ne käne ye erere tikwe mikadre täte jökrä, ¡akwa ni ti kitaka ngise abko ñan bobre jakän ya! niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Angwane nitre ja töitikaka Jesube namani niere jae kwärikwäri: ¿Nirekwe niara kitadi ngise rüeye ruen? namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ye ngwane abko, nitre ja töitikaka Jesube mden bäri ütiäte abko btä nikani ja kwete. ");
INSERT INTO gymNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Abtä Jesukwe niebare ietre: Nitre Ngöbö mikaka ngwarbe jae ye mikata jreire abko tä nebe ja bä mike krübäte ni mda mda okwäte. Erere arato, nitre mikata ni mda mda dänkiene abko krübäte arato, akwa ni se bäri moto kuin, nieta btä abko käita nebe juto btätre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Akwa mun ngätäite abko ñan rabadre bare kore, ñobtä ñan angwane ni bati mikata sribi ngwarbe nuene, ye kwrere nire nire rabadre bäri ütiäte mun ngätäite abko rabadi ni bati ye kwrere. Erere arato, mun mden rabadre ji dokwäte abko käkwe ja mika ni klabore kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ye abko, ti bike kukwe niere munye: ¿Nita täkänintbe mröre mesabtä angwane, ni mrö mikaka mesabtä, ni nibu ye abko mden bäri ütiäte? Ni mrökä mesabtä abko bäri ütiäte ni sribikä mrö sribekä ye kräke raba ruen tie, akwa ni sribikä ye kwrere tita mun ngätäite nete, erere munkwe nüna arato. ");
INSERT INTO gymNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tikwe ja tare nikaba angwane, käre mun näma ketetibe tibe, ");
INSERT INTO gymNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","aisete ti Rünkwe kä biani gobrankrä tie, ye kwrere tita bien munye arato, ");
INSERT INTO gymNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tikwe gobrandi Ngöböbe, ye känti munkwe mrödre amne munkwe dö ñadre ketetibe tibe ti kukwe muko kwrere, abkokäre tita kä gobrankrä bien munye. Ye ngwane, mun ja töitikaka tibe ye abko rabadi täkänintbe kürä kwä jätäbti kubu yebti. Ye känti abko juta keta jätäbti ketebu nitre israelitakwe abko kräke munkwe kukwe ükadite siba tibe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yebti ni Dänkien käkwe niebare mda: Simón, Satana tö mun jökrä nuaite krübäte ja käne, käkwe mun köböi käräba Ngöböye, ");
INSERT INTO gymNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","akwa makwe tödekadre janknu Ngöböbti, abkokäre tikwe blitaba Ngöböbe makrä Simón. Ne aisete ma töi rikwitata ti kukwäre angwane, makwe ma mräkä mda mda nete se die mika nünenkä dite jabtä, niebare Jesukwe Simónye. ");
INSERT INTO gymNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Abtä Simónkwe niebare mda ie: Ti Dänkien, ma kitadre ngite ya o ma kämikadre ya, ye känti tita juto biare niken gwaire mabe, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Abtä Jesukwe niebare mda ie: Pedro, ti bike kukwe era erere niere mae abko krörö: Antlan ngämi ngwäne dekä, ye känenkri ti gare ñakare mae, makwe niedi bämä jire. Abko kore se, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yebti nitre ja töitikaka Jesube, ie Jesukwe niebare: Tikwe mun juanba Ngöbö Kukwei kädriere angwane, mun ñan rikadre ngwian ngwena jae amne, mrö, sabato ye ñan järikadre munkwe jae, tikwe nieba munye. ¿Ye ngwane munkwe ja tare nikani jändrän ye miare ya? niebare Jesukwe ietre. Angwane, Ñakare, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Abtä Jesukwe niebare ietre: Kore tikwe mun juanba akwa, mtare abko ngwian tärä munkwe angwane, mun jata ngwena jae amne mun jata mrö ngwena jae arato, akwa mun mdenkwe ngitra ñakare abko käkwe dän jakwe rürümoin, bti munkwe ngitra köka jae, ñobtä ñan angwane kä taretare kite munkrä, ñobtä ñan angwane ");
INSERT INTO gymNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ngöbö Kukweita tikani krörö tibtä: Ni ngututu kwrere jire niara namani tuen ni mda mdaye, abko tikani kira tibtä, ye abko rabadre bare täte jökrä tibtä. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abtä nitre ja töitikaka ben käkwe niebare ie: Ni Dänkien, ngitra tärä kumu nikwe nete, niebare kwetre. Angwane Jesukwe niebare ietre: Kada kete munkwe. Tikwe dre nini ñan nü gare munye, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yebti Jesu nämane niken käre Ngitio Olibo känti, ye erere nikaninta mda angwane, nitre ja töitikaka ben ni jätäbti iti nikanintre jökrä ben. ");
INSERT INTO gymNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Namaninta ngitiobti angwane, niebare kwe ietre: Kukwe taretare kite mun nuente ja käne angwane, munkwe ñan ja mikadre ngite, abkokäre munkwe blita jakrä Ngöböbe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Yebti jä kitata tä niken mate nuäi temen, ye näre Jesu nikani mentokwäre se kwrere, känti namani ngukudokwäbti temen blitakäre Ngöböbe, ");
INSERT INTO gymNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","käkwe niebare ie: Ti Rün, kukwe kite tare ti rüere ti mikakrä ja tare nike, ye ma tö diain ti bäre ne ngwane, makwe dian ti bäre, akwa ma tö dreye tikrä, ye erere raba bare tibtä amne ñan ti töi abko erere rabadre bare, niebare kwe Rün Ngöböye. ");
INSERT INTO gymNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ye btäräbe angele nämane kä käinbti, nükani Jesu die mike. ");
INSERT INTO gymNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Angwane Jesu namani ja tare nike bäri krübäte, akwa bäri namani blite ja dibti Ngöböbe, aisete krübärie namani ngitiekä abko namani näkäenkä krikri be däri kwrerekwrere abko namani niken mate temen. ");
INSERT INTO gymNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yebti Jesukwe blitabare ünän Ngöböbe angwane, nikaninta nitre ja töitikaka ben ye känti amne niaratre namani ulire krübäte, aisete nämane kibien kuin jökrä, btä Jesu namaninta. ");
INSERT INTO gymNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Abtä niebare kwe ietre: ¿Ye ñobtä munta kibien? Diablu jatadi mun nuente ja käne angwane, munkwe ñan ja mikadre ngite, abkokäre näin krö, blite jakrä Ngöböbe, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu nämane ñäke kore nitre ja töitikaka benye, te batibe ni mda nükani kwati känti. Nitre ye ngätäite abko, ni iti ja töitikaka Jesube kädian nämane Judas abko nämane näin ji ngwena käne, nikani nebe Jesu känti angwane, krötabare Jesu ken kwe, Jesu demainkäre ngwärebtä. ");
INSERT INTO gymNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Akwa Jesukwe niebare ie: Judas, ¿ti, Ni Kä Nebtä Ngobo ne ma tö nibi demaine kore kitakäre ngise ñan ñan? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Angwane nitre ja töitikaka Jesube mda mda okwäbti kukwe ye nikani nakenkä angwane, niebare kwetre Jesuye: Ni Dänkien, nun bike nitre se tikekä ngitrabti, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yebti ni blitaka Ngöböbe ni mda mda diäre dänkien, kwe ni klabore nämane abko olo küde ruenkri tikaninkära ta ie ni itikwe se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Akwa Jesukwe niebare ietre: Nitre ye tuemetre, niebare Jesukwe. Bti ni klabore ye olobtä Jesukwe kise mikani angwane, namaninta kuin batibe. ");
INSERT INTO gymNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yebti nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne guardia ju blitakrä Ngöböbe ngibiabtikä amne nitre unbre ji dokwäte nikani Jesu kaen ngite, ye ie Jesukwe niebare: ¿Ñobtä abko bäsi ni gokä kri krübäte rüere ngitra jäta niken amne krito jäta niken, kwrere jire mun kite ngwena ti rüere ti kakäre ngite ye? ");
INSERT INTO gymNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ju blitakrä Ngöböbe känti käre ti nämane nebe ketetibe munbe angwane, mun ti kaen ñakare ngite amarebti mtare mun kite kore ye. Akwa mtare diablu tä dikekä kä ikote, diebti kä nüra munkrä, aisete mun nüke ti kaen ngite kore mtare, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yebti Jesu kani ngite, jänikani nitre blitaka Ngöböbe ni mda mda diäre dänkien juete angwane, Pedro nikani bä mente jiebti se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jesu jänikani ngite, ye känti namanintre angwane, ni ruäre käkwe ñukwä bukaninte ju bäre, bti namanintre täkänintbe ñukwä bäre temen mda angwane, Pedro nükani, namani täkänintbe siba niaratre ngätäite ñukwä träse. ");
INSERT INTO gymNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Angwane meri sribikä nämane ñukwä träse yete abko ie Pedro jatabare täkänintbe ñukwäbtä amne okwä namani kwekbe btä, käkwe niebare: Ni se nämane dikekä Jesube arato, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Abtä Pedrokwe ja rükaninte, käkwe niebare: Niara gare ñakare tie. ¿Ye ño abko mata ñäke kore ye? ");
INSERT INTO gymNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yebti bä derare angwane, ni mdara jire okwä namani Pedrobtä, käkwe niebare: Mata nekete arato Jesube, niebare kwe ie. Angwane Pedrokwe niebare ie: Tita nekete ñakare niarabe. Makwe ñan ñäkä ngwarbe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yebti kä nikani ñänä okwä krati näre ta mda angwane, ni mdara jire jatani ñäke kisere Pedroye, kä namani niere: Ni ne abko Galileabo, aisete niara ne nämane näin siba Jesube, namani niere. ");
INSERT INTO gymNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Angwane Pedrokwe niebare: Drebtä mata blite ñan nebe nüke gare tie, niebare kwe. Pedro nämane ja rükente kore, ye btäräbe antlankwe ngwänänbare se kwrere ");
INSERT INTO gymNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","angwane, ni Dänkien nikwitaninte, käkwe Pedro mikani ñäräre ja käne angwane, ni Dänkien käkwe kukwe niebare krörö Pedroye abko nükaninta töre ie: Antlan ngämi ngwäne, känenkri makwe ti rükandite bämä jire, niebare ni Dänkienkwe ie, ye nükaninta töre ie. ");
INSERT INTO gymNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Angwane nikani mentokwäre, käkwe ja müaibare kri kä bäre mento. ");
INSERT INTO gymNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Jesu jänikani ngite, ye känti nitre mikani Jesu ngibiabtikä abko käkwe dän kukwän mäkäni Jesu okwäbti, bti namanintre mete amne namanintre mike yakrä jae, kä namani niere ie: Nirekwe ma miti niere metre, namanintre niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Erere arato, namanintre ñäke kämekäme amne taretare Jesuye, mikakäre ene jae. ");
INSERT INTO gymNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Yebti kä jatani ngwen dekä angwane, nitre nämane sribire Sanedrinbtä abko nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne Kukwe Biani Ngöbökwe Moiséye dirikätre käkwe ja ükaninkrö jökrä amne, ye ngwärekri Jesu jänikani. Namani känti angwane niebare kwetre ie: ");
INSERT INTO gymNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma abko Ni Dianinkä Ngöbökwe ara ne ngwane, niere nunye, niebare mda kwetre Jesuye. Angwane Jesukwe niebare: Tikwe jän niedre munye angwane, munkwe ñan ti kukwei mikadre era. ");
INSERT INTO gymNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Erere arato, tikwe kukwe ngwiandretari munye angwane, munkwe ñan ti kukwei kadre ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Akwa mtare Ngöbö Di Kri Jändrän Jökrä Nuenkrä ye küde ruenkri kä ni ütiäte krikrä, känti Ni Kä Nebtä Ngobo rabadi täkäninte gobrane Ngöböbe gwaire, niebare Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Angwane ni jökrä käkwe niebare mda Jesuye: ¿Mata niere kore, aisete ma Ngöbö Odei bkänä ñan ñan? niebare kwetre ie. Angwane Jesukwe niebare mda ietre: ¿Mun ara jire käta ti Ngöbö Odei niere, ye aisete ñan ye kwrere bkänä ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Angwane niebare kwetre: Niarakwe ñäri kore, käkwe ja miri ngite au, nikwe kukwe nuri. ¿Se abko ni mdara jire känändre blite mda rüere ya? niebare kwetre jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yebti ni jökrä nämane yete abko nikani Jesu ngwena mda Pilato ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Angwane nikani Jesu kite ngise krörö Pilatoye: Ni noko tä kukwe miketbe blo nun israelita rüere abko nunkwe gaba btä. Nunkwe ñan ja ütiä biandre emperador romanoboye tä niere. Mdakäre abko, niara Ni Dianinkä Ngöbökwe amne niara abko jrei tä niere emperador rüere, niebare kwetre Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Abtä Pilatokwe niebare Jesuye: ¿Ma abko jrei nitre israelitakwe bkänä ya? niebare kwe. Jesukwe niebare Pilatoye: Jän. Era metre ti ara, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Angwane nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne ni mda mda, ie Pilatokwe niebare: Ni ne ja mike ngite ñakare abtä ñan kämikadre, nibi tuen tie, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Akwa ni jökrä namani ja nike kisere, kä namani niere ie: Ni noko tä kukwe dirire abko käta nun kwite jökrä ja rüere kwärikwäri. Käne nikani dirire Galileate sere, abti mtare kite nüke dirire arato Judeate nere, namanintre niere Pilatoye. ");
INSERT INTO gymNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jesukwe sribi nuenbare kena Galileate niebare, ye jarabare Pilatoye angwane, Jesu abko Galileabo ya ngwianintari kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jesu abko Galileabo gani kwe amne, kä ye känti Herodes nämane gobrane arato aisete kukwe ükadrete nitre Galileabokrä, aisete Herodes nämane Jerusalén, ye känti Pilatokwe Jesu juani. ");
INSERT INTO gymNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesu jatabare Herodeye angwane, käi namani nuäre Herodebtä, ñobtä ñan angwane kä raire nämane ni kukwei nuen blite Jesubtä, aisete tö namani ja tuai ben amne tö namani Jesu tuai sribi kri ñan tuabare nuene keteti ja okwäbti, ");
INSERT INTO gymNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","käkwe kukwe ngwianintari kabre ie. Akwa Jesukwe ñan kukwe kani ngäbti jire chi. ");
INSERT INTO gymNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kä ye känti abko, nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne Kukwe Biani Ngöbökwe Moiséye dirikätre nämane siba yete abko namani Jesu kite ngise kisere Herodeye. ");
INSERT INTO gymNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Angwane Herodes btä rükä namani Jesu mike ngwarbe amne namani mike yakrä jae, käkwe dän bäri kuin kita nämane jabtä jreikwe, kwrere kitani kwetre Jesubtä. Bti Herodekwe juaninta Pilato känti, ñobtä ñan angwane namani tuen ngite ñakare ie aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ne känenkri abko, Herodes nämane ja rüere Pilatobe akwa, ja mäkäninta kwetre köbö ye näire. ");
INSERT INTO gymNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yebti Pilatokwe nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre ütiäte ütiäte ükaninkrö nitre israelita mda mdabe, ");
INSERT INTO gymNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","käkwe niebare ietre: Ni ne nämane kukwe miketbe gobran romanobo rüere, abtä mun ki ngwena tie nete, munkwe nini. Akwa tikwe kukwe ngunintari ie mun okwäbti amne, kukwe btä munta kite ngise abko erere ja mike ngite ñakare tuen tie. ");
INSERT INTO gymNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Erere arato, Herodeye kuni ngite ñakare, aisete juninta jirekäbe kwe tie nete. Ni ne ja mike ngite ñakare. ¿Se ñobtä müre ketadre? ");
INSERT INTO gymNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aisete ti bike kwata metamna köbti jirekäbe, bti tikwe tikaditeta. Abko kore se, niebare Pilatokwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Bieta Pascuate abko, käre gobran romanobo käkwe ni ngite tikadrete. ");
INSERT INTO gymNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilatokwe blitaba kore, abtä ni jökrä namani ngrente, kä namani niere: ¡Barrabás tiketeta nunkrä amne ni ye abko ngwena müre ketadre! namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabás ye abko nämane kukwe miketbe gobran romanobo rüere amne niarakwe ni mda kämikani arato. Abtä nämane kitani ngite kä teri abko ni jökrä namani tikatemna. ");
INSERT INTO gymNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Akwa Pilato abko tö namani Jesu tikaiteta, käkwe ñäkäbareta bobuta ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Akwa niaratre käkwe ngratebare bäri ja dibti mda, kä namanintre niere: ¡Müre kete krusobtä! ¡Müre kete krusobtä! namanintre niere. ");
INSERT INTO gymNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Abtä Pilatokwe niebareta bämäkäre ietre: ¿Drebtä ni nekwe ja mikani ngite? Niara ja mike ngite ñakare nibi tuen tie. ¿Se abko drebtä müre ketadre? Aisete ti bike kwata metamna köbti jirekäbe, bti tikwe tikaditeta, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Akwa ni jökrä namani Jesu kämikamna kisere krusobtä, kä namani ngrente bäri krikri. Te Pilato töi kwitani kwetre Jesu rüere, aisete tö nämane dreye, erere namanina kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ne aisete, niaratre tö namani dreye, ye erere Pilatokwe köböi biani ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Angwane niaratre namani Barrabás tikatemna, ye erere nuenbare kwetre. Barrabás ye abko nämane kukwe miketbe gobran romanobo rüere amne ni kämikani kwe, abtä nämane ngite kä teri abko Pilatokwe tikaninteta amne nitre israelita tö namani Jesu kämikai abko erere kämikamna Pilatokwe. ");
INSERT INTO gymNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abti Jesu jänikani mda müre ketadre krusobtä angwane, ni Cirenebo kädian nämane Simón nämane Jerusalén bäre, jataninta, nükani ngätäi bentre ji ngrabare angwane, kruso mikani Simón kötärä nitre rükäkwe abko nikani ngwena Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ye ngwane ni nikani kwati jiebti angwane, meri nikani kwati siba abko namani uliere krübäte. Abtä nämane näin müen krikri be Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Abtä Jesukwe mikani ñäräre ja käne, käkwe niebare ietre: Mun merire Jerusalénbo, munkwe ñan ti müai, akwa munkwe ja müai au amne munkwe ngäbäkre jakwe müai jakrä, ");
INSERT INTO gymNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ñobtä ñan angwane kä taretare jatadi angwane, niedi krörö nitre merirebtä: Meri kaibe ngäbäkre ngibiare ñakare amne ngäbäkre mike ñakare kianbtä abko btä käta nuäre kri niedi, ñobtä ñan angwane ngäbäkre ñakare munkwe krütadre munkän kukwe taretare näire aisete. ");
INSERT INTO gymNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ye ngwane abko ni jökrä rabadi niere ngitioye: Ngitio ngidien järäre nunbti amne nun doboi mike nun rüe ngäniene, rabadi niere. ");
INSERT INTO gymNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","¿Ye abko ti kri niki kwrere btä tätre kukwe nuene käme kore se abko mun israelita kri nötare kwrere abko btä ñan nuendre kwetre arato ya? niebare Jesukwe meritre yeye. ");
INSERT INTO gymNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesu jänikani müre ketadre krusobtä angwane, ni mda käkwe ja mikani ngite abko jänikani nibu kämikadre gwaire ben krusobtä. ");
INSERT INTO gymNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ye erere käkä Calavera känti Jesu jänamani angwane, metani krusobtä amne ni ja mikaka ngite metani kruso mda mdabtä arato abko nikani iti küde ruenkri amne iti küde ngeberekri. ");
INSERT INTO gymNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Angwane Jesukwe niebare Ngöböye: Ti Rün, nitre tä ja mike ngite ti rüere ne makwe dian bti ta amne makwe ñan mika ja ngie nuen ti dokwäre, ñobtä ñan angwane niaratre tä dre nuene gare ñakare metre ietre, niebare Jesukwe. Angwane nitre rükä abko käkwe ja gani dän Jesukwe ñäkätbekrä jabti. ");
INSERT INTO gymNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ye ngwane ni nämane kwati okwä Jesubtä angwane, nitre ütiäte ütiäte nitre israelita ngätäite namani Jesu mike ngwarbe jae, kä namani niere jae kwärikwäri: Niarakwe ni mda mda dianintari, aisete niara abko Ni Dianinkä Ngöbökwe bkänä ne ngwane, ja diandretari au krusobtä mento kwe, namani niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Erere arato, nitre rükä romanobo namani Jesu mike yakrä, kä namani krötö Jesu ken amne namani uba ñöi dime bien ñadre ie, ");
INSERT INTO gymNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","kä namani niere: Ma ñakare Jrei nitre israelitakwe bkänä, ñobtä ñan angwane kore ne ngwane, makwe ja diandretari au mento, namanintre niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Angwane Jesu dokwä känti käin abko kukwe tikani krörö kri kukwänbtä abko nämane mikani “NI NE ABKO JREI NITRE ISRAELITAKWE” abko namani tikani. ");
INSERT INTO gymNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Angwane ni kukwe käme nuenkä nämane mikaninkä krusobtä käin, ye abko iti namani ñäke diänbe Jesuye arato, kä namani niere: Ma abko ñakare Ni Dianinkä Ngöbökwe bkänä, ñobtä ñan angwane kore ne ngwane, makwe ja diandretari au amne makwe nun diandretari arato, namani niere Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Abtä ni iti mda nämane krusobtä käin arato ye käkwe niebare kukwe muko yeye: ¿Mata ja tare nike ja kwrere ni nokobe, akwa Ngöbö jürä ñakare mabtä ñan ñan? ");
INSERT INTO gymNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ni nibu ne käkwe ja mikani ngite abtä nita ja ngie nuen ye tä dbe. ¿Akwa ni noko ja mike ngite ñakare, akwa tä ja tare nike, se tuen mae ya? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bti niebare mda kwe Jesuye: Jesu, ma raba gobrane angwane, makwe ti ngwianta töre jae amne makwe ti die mika, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesukwe niebare mda ie: Era metre mtare ma rabadi kä kuinte tibe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Yebti ñänä ruäre angwane, kä ngidianinte mda amne kä namani iko jökrä temen nebebe ñänä okwä krämä dere, aisete ñänä trä namani ñakare. Erere arato, dänkwän ngetbo, bti ju blitakrä Ngöböbe nämane ñäkänintbe, ye nianinkäbe ötöbu ta se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Angwane Jesukwe ngratebare kri, käkwe niebare: ¡Ti Rün, ti bike ja üai mike gare mae! niebare kwe. Ye btäräbe krütani. ");
INSERT INTO gymNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jesu krütani kore nitre rükä romanobo dänkien okwäbti angwane, Ngöbö käikitaninkä kwe, käkwe niebare: Ni ne abko ni metre amne ngite ñakare bkänä ñan ñan, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ye ngwane ni nämane kwati yete okwäbti kukwe nakaninkä kore. Abtä moto namani ulire, kä nikani ja mete mäträte, nikaninta mentokwäre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Angwane nitre ja getaka getaka Jesube amne nitre merire merire Galileabo nikani siba Jesube abko namanintre bä mente temen se kwrere okwä Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ye ngwane abko, ni iti sribikä Sanedrinbe kädian nämane José nünanka juta Arimateate kä Judeate nämane. José ne abko moto kuin amne nämane nüne metre Ngöbö ngwärekri. Erere arato, Ngöbö rükadre gobrane ni kwe ngätäite diribare Jesukwe abko José nämane ngibiare kisere amne, Sanedrin käkwe kukwe nuenbare Jesubtä, ye ñan namani dbe kräke. ");
INSERT INTO gymNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ye mden kisete, Jesu krütani angwane, niara nikani, käkwe Jesu ngwäkä käräbare Pilatoye. Erere Pilatokwe köböi biani ie angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","José nikani, Jesu ngwäkä diani krusobtä timon kwe, mrianinte kwe dän bäri ütiäte kädianta lino ye te, bti kä nämane muani jäkwatate ni doboi mikakrä akwa, ni doboi mika ngämi te, ye känti Jesu doboi mikani kwe. ");
INSERT INTO gymNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Köbö ye ngwane abko, nitre israelita nämane jändrän ükete biare köbö jadükakrä ngibiakäre ngäbti, erere köbö jadükakrä jatanina nüke. ");
INSERT INTO gymNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Angwane José nikani Jesu doboi mike angwane, nitre merire Galileabo nikani siba Jesu mukore nebe Jerusalén, ye abko Jesu doboi mikadi mdente Josékwe abko nikani tuen angwane, Jesu doboi mikani mdente metre, ye tuani kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bti nikaninta, namaninta gwi angwane, ñö rä bäne amne kri ngwäri mnü rä bäne sribebare kwetre mikakäre Jesu ngwäkä ngrabare. Yebti kukwe nämane ükaninte ño Ngöbökwe köbö jadükakräbtä, ye erere nitre merire ye käkwe jadükani. ");
INSERT INTO gymNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Akwa ñänä jatani gökökä krire käin bämänte dekä angwane, nitre merire ye nikaninta dobobti mda, kä nikani ñö rä bäne amne kri ngwäri mnü rä bäne sribebare kwetre ye ngwena mikadre Jesu ngwäkä ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Namanintre dobobti angwane, jä mikani kä mkäte Jesu doboibti ye namanina dianinkä mento amne ñakare täte, btä namanintre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Angwane nikanintre nikren kä mkäte nguse se kwrere angwane, ¡jo! ni Dänkien Jesu ngwäkä kwani ñakare nguse ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yebtä abko töi ñan namani krütare. Ye btäräbe ni btä dän ngwen bürere namanintre nünaninkä nibu niaratre ken, btä okwä namani. ");
INSERT INTO gymNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Angwane kä jürä namani kri btätre, abtä nikaninbe mate ngukudokwäbti temen, käkwe ja okokrä mikani dobobtä temen. Akwa angele nibu ye käkwe niebare meritre yeye: ¿Ñobtä munta näin ni nire känentari mürükrä ngätäite ye? ");
INSERT INTO gymNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","¡Ni känäntarita näin munkwe, ye nürate nire, aisete ñakare nete! Niara nämane Galilea munbe angwane, dre niebare kwe, ye munkwe ngwianta töre jae abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ni Kä Nebtä Ngobo ne kitadi ngise nitre kukwe kämekäme nuenkäye, bti niaratre käkwe müre ketadi krusobtä, akwa mukirare angwane, rükadita nire, niebare kwe munye, niebare kwetre meritreye. ");
INSERT INTO gymNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Angwane batibe Jesu kukwei nükaninta töre meritre yeye angwane, ");
INSERT INTO gymNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","nämane dobobti, nikaninta Jerusalén. Namaninta gwi angwane, kukwe nakaninkä ño ño, ye erere niebare jökrä kwetre nitre Jesu kukwei ngwianka ni jätäbti iti yeye amne ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nitre merire nükani kukwe ngwena nitre Jesu kukwe ngwiankaye abko María Magdalabo, Juana, Santiago meye kädian nämane María, amne meri mda mda abko nükani kukwe ngwena. ");
INSERT INTO gymNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Akwa nitre Jesu kukwei ngwianka abko ie meritre ye namani tuen ñäke ngwarbe, aisete ñan tö namani kukwei mikai era. ");
INSERT INTO gymNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Akwa Pedro abko nikani betekä dobobti, namani yete käkwe nikrabare nguse amne, dän te Jesu mrianinte aibe nämane nguse, btä okwä namani angwane, nikaninta akwa kukwe nakaninkä, yebtä töi ñan namani krütare mda. ");
INSERT INTO gymNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Jesu nükaninta nire, ye näire nitre nänkä ben nikani nibu juta Emaús kukwäre. Emaús ye abko nämane kilometro krä jätäbti krati Jerusalén bäre mento, känti nikanintre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nikanintre angwane kukwe nakaninkä ño ño Jesubtä, yebtä nikani blite jökrä ji ngrabare. ");
INSERT INTO gymNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Niaratre nämane näin blite jabe kwärikwäri angwane, Jesu ara jire käkwe krötabare ken amne nikani gwaire bentre mda. ");
INSERT INTO gymNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesu namani tuen ietre, akwa Ngöbökwe ñan Jesu mikani gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Angwane Jesukwe niebare ietre: ¿Mun ye tä näin dre kädriere ji ngrabare ye? niebare kwe ietre. Abtä namanintre nünaninkä moto ulire. ");
INSERT INTO gymNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Angwane ni iti kädian nämane Cleofas käkwe niebare Jesuye: ¿Ni nämane kwati ngätäite ma nämane siba Jerusalén angwane kukwe rakakaba mukira, ye abko ma aibe ie gare ñakare ya? niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesukwe niebare mda ie: Dre nakaninkä niere tie, niebare kwe ie. Niara käkwe niebare mda ie: Kukwe rakakaba Jesu Nazarebobtä. Niara abko ni Ngöbö kukwei niekä amne di kribti nämane sribi kri nuene amne nämane blite kuin Ngöbö Kukweibtä abko Ngöbö amne ni jökrä namani nütüre btä. ");
INSERT INTO gymNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Akwa nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre ütiäte ni israelita ngätäite käkwe kitani ngise nitre romanoboye müre ketadre amne metadre krusobtä abko erere nuenbare kwetre btä. ");
INSERT INTO gymNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Niarakwe ni israelita dianditari nitre romanobo ngoto täni amne ni rabadi tikaninte abko nun nämane nütüre, aisete nun nämane tödeke bti akwa, köbömära kukwe rakakaba kore btä nun okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Akwa mtare nitre merire tä nun ngätäite niki dekä doboibti angwane, nüta, käkwe nun ngwini nikenkä, ");
INSERT INTO gymNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ñobtä ñan angwane janintre doboibti amne, Jesu ngwäkä kuni ñakare ietre, akwa Jesu nürate nire, nini ietre angeletrekwe abko nü niereta gwi abtä nun nekwekä. ");
INSERT INTO gymNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Angwane nun kukwe muko ruäre niki doboibti kukwe ye mike ñäräre, akwa nitre merire käkwe dre nini, ye kwrere täni bkänä btä nibitre, akwa Jesu turi ñakare kwetre abko tä nakenkä. Abko kore se, niebare kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Angwane Jesukwe niebare mda ietre: ¡Mun ye ño amarebti mun töi braibe dikaro amne, nitre Ngöbö kukwei niekä kirakira abko mun ñan tä mike era! ");
INSERT INTO gymNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ni Dianinkä Ngöbökwe ne mika ngämi ütiäte Ngöbökwe, känenkri ja tare nikadre kri kwe, nieta kore Ngöbö Kukweibtä, ye gare ñakare munye ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yebti tärä tikani Moisékwe nebebe tärä tikani kira nitre Ngöbö kukwei niekäkwe abko nämane blite ño ño Jesubtä, yebtä Jesukwe blitabare. ");
INSERT INTO gymNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Yebti juta känti nikanintre ye känti namani angwane, Jesu jatani niken janknu ta bä mikani kwe, ");
INSERT INTO gymNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","akwa niaratre abko namani Jesu ketete nebe jabe jirekäbe, kä namani niere ie: Kä kitera dere amne kä kite iko, aisete ma raba jirekä nunbe nete, namani niere ie. Ye erere Jesu nikani, namani gwi bentre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yebti namanina täkänintbe mesabtä angwane, Jesukwe ban diani kunti kisete, käkwe kuin niebare btä Ngöböye, bti ñäkänintbe kwe, käkwe biani ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ye ngwane Jesu ara namani bentre gani kwetre, akwa Jesu abko käkwe ja ganinkäta okwäte. ");
INSERT INTO gymNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Abtä niebare kwetre jae kwärikwäri: ¿Niara ki blite ji ngrabare nibe Ngöbö Kukweibtä angwane, kä nibi nuäre krübäte nibtä, aisete ni nibi grükekä jökrä ngrabare niara kukwei nuare ñan ñan? namani niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Yebti jötrö ngwarbe Cleofas amne kukwe muko kwe nikaninta ja jiebti Jerusalén. Nikanintre nebebe Jerusalén angwane, nitre Jesu kukwei ngwianka ni jätäbti iti nämane ja ükaninkrö ni mda mdabe, ");
INSERT INTO gymNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ye käkwe niebare Cleofas amne kukwe muko kwe ngäbti: ¡Jesu nükaninta nire bkänä! Niarakwe ja miri tuadre Simónye, niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Angwane Cleofas amne kukwe muko kwe btä kukwe nakaninkä ño ji ngrabare abko niebare jökrä kwetre. Erere arato, Jesukwe ban ñäkänintbe bti angwane, Jesu nükaninta gare ietre, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kukwe nakaninkä ño ño btätre, yebtä nämane blite, btäräbe Jesu nükaninbe niaratre ngätäite se kwrere, käkwe köbö ngwianintari krörö ietre: Kä jäme Ngöbökwe raba munbtä, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Angwane ni üaibe namani tuen ietre namanintre nütüre, aisete namanintre nekwetekä krübäte. ");
INSERT INTO gymNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Abtä Jesukwe niebare ietre: ¿Ñobtä munta töbike ngwarbe kwäräkwärä amarebti mun nibi nekwetekä krübäte dikaro ye? ");
INSERT INTO gymNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ti abko Jesu ara. Ti kise amne ti ngoto träin mike ñäräre munkwe amne, ti nuenbtä munkwe amne ti mike ñäräre munkwe, ñobtä ñan angwane ti ngätä amne ti kroko tärä, ye tuen angwane, ti ñakare ni üai gadi munkwe, ñobtä ñan angwane ni üai abko ngätä amne kroko ñakare, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Niebare kore kwe ietre, ye btäräbe ja kise amne ja ngoto mikani tuadre kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Akwa niaratre btä kä namani nuäre krübäte amne töi ñan namani krütare, aisete namanina Jesu tuenta, akwa ñan namani nebe era kräke. Abtä Jesukwe niebare mda ietre: ¿Mrö tärä munkwe nete ya? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Angwane gwa kukwani nämane kwetre abko oto biani kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesukwe kani ngäbti, bti kwetani kwe niaratre okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bti niebare kwe ietre: Ti ngämi krüte, känenkri ti nämane mun ngätäite angwane, kukwe rakadrekä ño ño tibtä abko tikwe nieba munye, mden erere namani bare tibtä. Kukwe Biani Ngöbökwe Moiséye tä tikani tibtä amne nitre Ngöbö kukwei niekä käkwe tärä tikani tibtä amne Salmobtä tärä nämane tikani ño tibtä, ye erere rabadi bare jökrä, tikwe nieba, mden erere namanina bare, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yebti Jesukwe niaratre töi tikani Ngöbö Kukweibtä mda, ");
INSERT INTO gymNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","käkwe niebare krörö ietre: Ngöbö Kukweita tikani krörö tibtä: Ti, Ni Dianinkä Ngöbökwe krütadi akwa köbömära angwane rükadita nire. ");
INSERT INTO gymNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Angwane ni kä jökräbti käkwe kukwe käme kitadre temen, bti Ngöbö kadre ngäbti kwetre, Ngöbökwe niaratre ngite kukwe käme nuenbtä diandrekä mento btä abkokäre, ye abko tä tikani kore tibtä Ngöbö Kukweibtä. Kukwe ye diri rikadre ti käbti käne Jerusalén, bti kä mda mdabti. ");
INSERT INTO gymNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ne aisete kukwe nakaninkä ño tibtä, munkwe tuani ja okwä jenbti, ye munkwe kädrie ni mda mdabe. ");
INSERT INTO gymNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Angwane ti Rünkwe ni köböi mikani munye abko tikwe juandi täte munbtä, akwa niara di kä käinbti rükadre täte jökrä munbtä, ye abko munkwe ngibia Jerusalén nete, aisete mun raba jökrä nete. Abko kore se, niebare Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Abti Jesu nikani ngwena juta Jerusalén bäre mento angwane, nikani nebe juta Betaniate. Ye känti Jesukwe kise kaninkä käin ja di biankäre ietre. ");
INSERT INTO gymNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jesu nämane ja di bien kore ietre, btäräbe Jesu jänikani kä käinbti se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yebti niaratre abko käkwe Jesu käikitaninkä yete, bti kä namani nuäre btätre amne nikaninta Jerusalén. ");
INSERT INTO gymNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yebti ju blitakrä Ngöböbe, känti namanintre Ngöbö käikitekä käre köbö kwatirekwatire abko nakaninkä kore se. Ne ngörä.");
INSERT INTO gymNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kena dekä, kä ne däte ngämi, känenkri ni kädekata Kukwe nämanena. Niara nämane nüne Ngöböbe amne niara abko Ngöbö ara arato. ");
INSERT INTO gymNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Kena dekä kä ne däte ngämi, känenkri niara nämane ketetibe Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Niara köböire Ngöbökwe jändrän jökrä dätebare amne jändrän ñakare jire chi abko niarakwe dätebare ñakare. ");
INSERT INTO gymNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Niara di nämanena ni mikakäre nire Ngöbökrä amne niara abko ñotra ni jökrä kräke abko krörö: ñotra käta ji metre mike gare nie kä ikote, ye kwrere niarakwe ji Ngöbökwe mikani gare nie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nita nüne mente Ngöböye amne nita nüne kä iko diablukwe te abko kräke ni kädekata Kukwe ye tä trä ngitiekä amne kä iko abko di ñakare kä trä ye ötatekrä. ");
INSERT INTO gymNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bati ni nämane iti abko kädian nämane Juan Bautista. Ni ye abko Ngöbökwe juani ");
INSERT INTO gymNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","blitakäre käne angwane, kukwe gare ño ie ni ñotra kwrere yebtä, ye erere niedre kwe, ni jökrä käkwe tödekadre ni yebti abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","9","Juan ye abko juani käne Ngöbökwe blitakäre ni ñotra kwrere yebtä, akwa Juan abko ñakare ni ñotra kwrere. Akwa ñotra era metre tä trä ngitiekä ni jökräbtä ji metre Ngöbökwe mikakäre gare ietre, ye abko jatanina nüke abko Juan jatani niere käne. ");
INSERT INTO gymNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ni kädekata Kukwe ye abko käkwe jändrän jökrä amne ni jökrä dätebare, akwa nükani kä nebtä nitre töi kämekäme ngätäite angwane, niara abko ni jökrä ye dätekä ara abko ñan nükani gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nükani nüne mräkä kwe israelita ngätäite, akwa mräkä kwe käkwe kani ngäbti ñakare. ");
INSERT INTO gymNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Akwa nire nire käkwe niara kani ngäbti käkwe tödekani bti, ye abko ie kä biani kwe rabakäre Ngöbö ngäbriänkäre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nitre tä Ngöbö ngäbriänkäre ye abko ñan ni därebare rün btä meyekwe, köböire tätre Ngöbö ngäbriänkäre. Erere arato, ñan rün btä meye töi köböire tätre Ngöbö ngäbriänkäre amne ñan ni brare tö namani meriye abko köböire tätre Ngöbö ngäbriänkäre, akwa ja töi jenbti Ngöbökwe mikani ja ngäbriänkäre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ni kädekata Kukwe ye nämane Ngöbö känti. Ngöbökwe juani ni ngätäite, nükani därere ni kwrere amne, ngrabare namani ni kwrere amne nünabare kwe ni ngätäite nete. Niara ütiäte kri bä nuäre, ye abko nunkwe tuaba. Niara abko Ngöbö Odei itibe amne Ngöbö niara Rün käkwe mikani ütiäte kri abko nunkwe tuaba. Ngöbökwe niara mikani ütiäte kri abko kwe niara moto namani kuin ni jökrä kräke amne kukwe era erere mikani gare kwe nie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Niara ye mdenbtä Juankwe blitabare angwane, nikani ngrente krikri be, käkwe niebare krörö: Ni se mdenbtä tikwe blitaba angwane, tikwe nieba krörö: Ni mda jatadi ti jiebti abko bäri ütiäte ti ngwä, ñobtä ñan angwane niara abko nämanena nüne bäri käne tikrä, tikwe nieba, niebare Juankwe Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Niarata ni tarere kri krübäte ja moto kuinbti, ye mdenbtä abko jändrän kuin biani kwe nie ja täritäri abko krörö: ");
INSERT INTO gymNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kukwe Biani Ngöbökwe nuendre nie, ye abko biani mekera kwe Moisés köböire, ye abko jändrän kuin biani ngwarbe käne Ngöbökwe nikrä; akwa Ngöbö moto kuin ni kräke käta ni tarere amne tä kukwe era erere mike gare nie, ye abko namani bare era metre nikrä Jesukristo köböire, ye abko jändrän mdara jire bäri kuin biani ngwarbe kwe nikrä. ");
INSERT INTO gymNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ne abko, ni ñakare jire iti käkwe Ngöbö tuani ja okwä jenbti, akwa Ngöbö Odei itibe tare kri kwe tä nüne ketetibe Rün kwebe. Niara abko Ngöbö ara arato abko käkwe Ngöbö mikani gare nie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juankwe blitabare Jesubtä angwane, kukwe nakaninkä krörö btä: Bati nitre israelita ji dokwäte nämane Jerusalén käkwe nitre blitaka Ngöböbe ni mda mda diäre amne nitre levita ju blitakrä Ngöböbe ye ngibiabtikä juani ruäre, Juan abko Ni Dianinkä Ngöbökwe ya, ñakare ya ngwentari ie. Ye erere nikanintre nebe Juan känti, käkwe ngwianintari kore ie angwane, Juan käkwe kukwe niebare metre krörö ietre: ");
INSERT INTO gymNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ti abko ñakare Ni Dianinkä Ngöbökwe, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Abtä niebareta kwetre Juanye: ¿Ma abko nire amarebti? ¿Ni Ngöbö kukwei niekä kira juandre mda Ngöbökwe Ni Dianinkä Ngöbökwe känenkri kädian nämane Elías abko mare ya? niebare kwetre mda Juanye. Angwane Juankwe niebare mda: Ti abko ñakare Elías, niebare kwe ietre. Angwane niaratre nikani kukwe ngwentari kisere mda Juanye, käkwe niebare ie: ¿Ngöbökwe ja kukwei niekä mdara jire Moisés kwrere juandre nieta Ngöbö Kukweibtä, ye abko ma ara ya? niebare kwetre. Ñakare, niebare Juankwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Abtä niebareta kwetre Juanye: Ma abko nire, ye makwe niedre nunye, ñobtä ñan angwane nitre nun juanka, kräke nun rikadre kukwe ngwenante, aisete ma abko nire ye makwe niedre au jakrä abko erere nunkwe niedre, niebare kwetre Juanye. ");
INSERT INTO gymNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Abtä Juankwe niebare mda ietre: Kira ni Ngöbö kukwei niekä kädian nämane Isaías käkwe niebare krörö: Ni iti tä niken ngrente krikri kä kaibete, käta niken niere: Ji ükateta kuin metre jrei kri kräke, ye kwrere jire ja mika juto ni Dänkien käne munkwe. Ni btä Isaíakwe blitabare abko ti ara, niebare Juankwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Angwane nitre bariseo juani ruäre abko namani yete siba ");
INSERT INTO gymNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","käkwe kukwe ngwianintari krörö mda Juanye: Ma abko ñakare Ni Dianinkä Ngöbökwe, ma ñakare Elías amne ma ñakare ni Ngöbö kukwei niekä Moisés kwrere mata niere, ¿se ñobtä abko mata ni mda mda ngökö ñöte se? ¿Nirekwe kä biani mae ni ngökakäre ñöte se? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juankwe niebare mda ietre: Tita mun ngökö ñö aibe te, akwa mun ngätäite nita iti abko gare ñakare munye. ");
INSERT INTO gymNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ni ye abko jatadi ti jiebti amne, ni klabore aibe käta sandalia tikete ni mdakrä, akwa ti abko bäri ene ruen tie, aisete ti abko ja ñan rükadre töre jire chi tie sandalia tikete ni ye ngotobtä, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kukwe ye abko nakaninkä jökrä kore käkä Betábara känti Ñö Jordánbtä kä driri, Juan nämane ni ngökö ñöte ye känti. ");
INSERT INTO gymNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yebti jändrinane angwane, Jesu jatani Juan kukwäre, ye jatabare Juanye angwane, niebare kwe ni jökräye: Kordero Ngöbökwe kite tuen sete se. Se mike ñäräre munkwe. Ni se mden ni ngite kukwe kämekäme nuenbtä Ngöbö rüere diankaka nibtä. ");
INSERT INTO gymNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ni se mden, btä ti nämane blite, käkwe nieba krörö: Ni mda jatadi ti jiebti abko bäri ütiäte ti ngwä, ñobtä ñan angwane niara abko nämanena nüne bäri käne tikrä, tikwe nieba angwane, ");
INSERT INTO gymNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","niara abko Ngöbö Odei ara ñan nämane gare tie, akwa rükadre gare juta israelitaye, abkokäre Ngöbökwe ti juani ni ngökö ñöte, niebare Juankwe. ");
INSERT INTO gymNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Erere arato, Juankwe kukwe niebare metre Jesubtä krörö: Ngöbö Üai Deme nämane kä käinbti jataba ütü kwrere timonkwäre, rikaba mate niarabtä, tikwe tuaba. ");
INSERT INTO gymNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Akwa ye ngwane, niara abko Ngöbö Odei ngämi nüke gare tie, akwa Ngöbö ti juanka ni ngökö ñöte, ye käkwe niebare krörö tie: Ngöbö Üai rika timonkwäre angwane, raba mate nirebtä ma okwäbti, ni ye abko käkwe Ngöbö Üai Deme mikadi nüne nibtä, nieba kwe tie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ye erere tikwe Ngöbö Üai tuaba nüke btä, aisete niara abko Ngöbö Odei ara tita niere. Abko kore se, niebare Juankwe. ");
INSERT INTO gymNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yebti jändrinane angwane, Juan nämane ni ngökö ñöte, ye känti namaninta angwane, nitre nänkä Juanbe namani nibu ben yete. ");
INSERT INTO gymNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ye btäräbe Jesu jatani tuen dikekä Juanye se kwrere angwane, Juankwe niebare: ¡Kordero Ngöbökwe kite tuen sere se! niebare kwe nitre nibu ye okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Juankwe niebare kore, ye jarabare nitre nibu yeye angwane, nikani Jesu jiebti mda. ");
INSERT INTO gymNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesukwe mikaninta ñäräre ja jiebti, käkwe niebare ietre: ¿Mun ye tö nibi dreye? niebare kwe ietre. Angwane nitre nibu ye käkwe niebare mda: Dirikä, ¿mata nüne mdente? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Abtä Jesukwe niebare mda ietre: Tita nüne mdente brän tuen, niebare kwe ietre. Ye erere nikanintre angwane, Jesu nämane mdente ye abko tuani kwetre. Angwane ye näire ñänä okwä namanina kräbkä dere amne niaratre namani Jesu känti ye näire dere. ");
INSERT INTO gymNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ni nibu käkwe Juan kukwei nuani, nikani Jesu jiebti, ni ye abko iti kädian nämane Andrés. Andrés ye abko Simón Pedro etba. ");
INSERT INTO gymNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés nikaninta angwane, nikaninbe etba Simón känentari. Simón kwanintari ie angwane, niebare kwe ie: Ni Dianinkä Ngöbökwe kädianta Kristo griegore, ye abko kwanba nunye, niebare Andrékwe Simónye. ");
INSERT INTO gymNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Yebti nikani Simón ngwena nebe Jesu känti. Simón ye jatabare Jesuye angwane, Jesukwe niebare ie: Ma abko Simón. Ma Jonás ngobo, akwa mtare mentokwäre ma kä rabadi Cefas arato. Abko kore se, niebare Jesukwe Simónye. (Cefas abko käta “jä” niere kukwe arameore abko Pedro nieta griegore.) ");
INSERT INTO gymNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yebti jändrinane Jesu tö namani rikai kä Galileate, ye erere nikani mda. Namani yete angwane, namani ngätäi Felipebe angwane, niebare kwe ie: Jakwe. Brän tibe, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe ye abko Betsaidabo. Andrés amne Pedro abko Betsaidabo arato. ");
INSERT INTO gymNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jesukwe Felipe ngwiani jabe, yebti Felipe nikani Natanael känene mda. Kwani ie angwane, niebare krörö kwe ie: Ni Dianinkä Ngöbökwe, ye kwanba nunye. Kukwe Biani Ngöbökwe Moiséye, yebtä Moisékwe tärä tikani niarabtä. Erere arato, nitre Ngöbö kukwei niekä mda mda käkwe tärä tikani niarabtä arato. Ni ye abko José Nazarebo ngobo. Niara abko kä Jesu, ye mden abko kwanba nunye, niebare kwe Natanaeliye. ");
INSERT INTO gymNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Abtä Natanaelikwe niebare mda: ¡Jo! Juta Nazaret käme. ¿Yete abko jändrän kuin jatadre ya? niebare kwe Felipeye. Angwane Felipekwe niebare mda ie: Jakwe, brän. Makwe tua ja okwä jenbti, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Erere Natanael jatani nüke ja ken se kwrere, ye jatabare Jesuye angwane, Jesukwe niebare ie: Ni israelita töi era metre kite nüke nete. Niara ne abko ni ngökö ñakare, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Abtä Natanael käkwe niebare mda Jesuye: ¿Mdente ti nükani gare mae amarebti mata niere kore tie ye? niebare kwe ie. Angwane Jesukwe niebare ie: Felipe ngämi nüke ma kärere, ye känenkri tikwe ma turi täkänintbe higo krie täni sete, niebare Jesukwe mda ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Abtä Natanael käkwe niebare Jesuye: ¡Dirikä, era bkänä ma abko Ngöbö Odei amne ma Jrei nitre israelitakwe! niebare mda kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Abtä Jesukwe niebare mda ie: ¿Higo krietäni tikwe ma turi täkänintbe, tikwe nini mae, ye aibebtä ti kukwei nibi era makrä ya? Makwe ti tuadi jändrän bäri krikri nuene mda abko tita niere mae, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yebti Jesukwe niebareta mda: Ti bike kukwe era erere niere krörö munye: Kä käinbti se munkwe tuadi tikani amne angele rabadi kite timonkwäre amne rabadi nikenta kukwäne abko rabadi nüke ti Ngöbö Odeibtä, Ngöböta tibe mikakäre gare abko Ngöbökwe bä mikadi tuare munye. Abko kore se, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Yebti mukirare angwane, ni iti käkwe ja mikani gure juta Canáte kä Galileate. Ye känti Jesu meye nämane arato amne, ");
INSERT INTO gymNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu käräbare arato nitre ja töitikaka benbe, ni iti nämane ja mike gure ye känti. ");
INSERT INTO gymNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jesu nämane yete angwane, uba döi krütani. Abtä Jesu meye käkwe nieba ie: Uba döi küre jire jökrä, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Abtä Jesukwe nieba meyeye: Mama tikwe, kä kitani ti käne abko ngämi nüke tie. ¿Ye ñobtä abko mata niere kore tie? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Angwane nitre näma uba döi dräire, ye ie Jesu meye käkwe nieba: Niarakwe dre nuemna munye, ye erere munkwe nuen jökrä, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kä ye känti abko jä dätebare ñö ngwäre näma kwä ti. Ye abko te nitre israelita nämane ñö köbötikakrä ja mikakäre dbe Ngöbö ngwärekri üke. Jä dätebare ñö ngwäre ye kwatirekwatire te ñö nämane niken bäsi galon krä gre bti krä jätä jätä jire abko näma yete. ");
INSERT INTO gymNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Angwane nitre sribikä yete, ie Jesukwe nieba: Jä dätebare ñö ngwäre tä yete, ye te ñö keka munkwe, nieba Jesukwe. Ye erere sribikä käkwe ñö kekaba jändrän ye iti iti jökrä. ");
INSERT INTO gymNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Angwane Jesukwe nieba mda ietre: Mtare ñö den ruäre, mun rika ngwena. Nita mikani ji dokwäte bietabtä, ye ie munkwe bian, nieba kwe ietre. Ye erere sribikätre käkwe nuenbare jökrä. ");
INSERT INTO gymNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Angwane ñö nikwitani uba döire Jesu diebti ye ni ji dokwäte bietabtä käkwe bänän nuaba, akwa uba döi ye jatani mdenkri abko ñan rababa gare ie. Akwa nitre sribikä käkwe ñö diani ye aibe ie namani gare. Angwane ni ji dokwäte bietabtä, ye käkwe uba döi bänän nuaba, bti ni ja mikaka gure ye käräba kwe, ");
INSERT INTO gymNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","käkwe nieba ie: Ni jökrä käta uba döi bäri kuinkuin keke käne ñadre, bti ni nübaibare bietabtä ye tärä uba döi ñaen kabre, ye ngwane uba döi ñakare kuin bianta mrä ñadre nie. Akwa ma abko käkwe uba döi bäri kuin abko ürü ñadre mrä. Ye abko bäri kuin, nieba kwe ni ja mikaka gure yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesukwe ñö kwitani uba döire juta Canáte Galilea ye abko sribi kri ñan tuabare nuenba kena Jesukwe Ngöbö nämane ben mikakäre gare. Yebtä abko Jesu ütiäte kri bä mikaba tuadre angwane, nitre ja töitikaka ben käkwe tödekaba niarabti. ");
INSERT INTO gymNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Yebti Jesu rikaba juta Capernaúmte mda angwane, niara meye rikaba siba ben. Erere arato, niara etbakantre amne nun ja töitikaka ben rikaba siba, akwa nünanteba bä jötrö kwe juta Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Abti bieta kädianta Pascua nitre israelitakwe abko jatabara nüke ja ken, aisete Jesu rikaba juta Jerusalénte mda. ");
INSERT INTO gymNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Angwane Jesu rikaba ju blitakrä Ngöböbe känti. Ju ye bäre temen nitre näma nbi, obeja amne ütü rürümoine kukwadre Ngöbö käikitakakäre. Erere arato, nitre ngwian kwitakakwitaka näma täkänintbe mesabtä kä ye känti arato, ");
INSERT INTO gymNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","btä Jesu okwä rababa. Angwane Jesukwe kö känänba ruäre, bti kö ye mäkäteba kwe, bti rikaba nitre ye juentari jökrä obeja amne nbi kwekwe ben gwaire ju blitakrä Ngöböbe ye bäre mento se kwrere. Amne nitre ngwian kwitakakwitaka abko kän ngwian kitakaba jökrä tementa kwe se kwrere. Erere arato, mesa bti ngwian näma mikani ye kwitakaba jökrä temen kwe kän. ");
INSERT INTO gymNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Angwane nitre ütü rürümoinkä abko ie nieba krörö kwe: Jändrän noko denkä jökrä mento nete. ¡Ju ti Rünkwe ye munkwe ñan mika jändrän rürümoinkrä jae! nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Angwane nun ja töitikaka Jesube, ie kukwe nämane tikani krörö Jesubtä Ngöbö Kukweibtä abko rükabata töre: “Tita ju makwe tarere kri krübäte Ngöbö, aisete tita mokrere bti,” abko rükabata töre nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nitre jändrän rürümoinkä juantariba jökrä kore Jesukwe angwane, nitre israelita ji dokwäte dokwäte näma yete, käkwe nieba ie: Makwe jändrän nuni kore se abko nirekwe kä biani mae kukwe se nuenkrä, ye bä mike tuadre nunye nete, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Abtä Jesukwe nieba mda ietre: Ju blitakrä Ngöbökwe ne abko dikente jökrä munkwe, bti mukirare angwane, tikwe mikadita täte, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Abtä nitre israelita ye käkwe nieba mda Jesuye: ¡Joo! Kä gre ketebu bti kwä ti jire sribibare amne ju noko namani bare. ¿Se abko mukirare amne makwe mikareta jökrä täte mata niere ya? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Akwa Jesu abko käkwe ñäkäba kore, ye abko ja ngrabare bä mikaba kore kwe ju blitakrä Ngöbökwebtä. ");
INSERT INTO gymNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Akwa Jesu kämikaba bti rükabata nire angwane, niarakwe blitaba ye nitre ja töitikaka ben, ie niara kukwei rükabata töre angwane, Ngöbö Kukwei tikani ye rababa era kräke amne Jesu kukwei mikaba era kwetre arato. ");
INSERT INTO gymNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Angwane Jesu näma Bieta Pascuabtä Jerusalén, ye ngwane sribi kri ñan tuabare Jesu rababa nuene kabre Ngöbö nämane ben mikakäre gare, aisete ni kwati käkwe niara kukwei mikaba era, käkwe tödekaba bti. ");
INSERT INTO gymNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Akwa Jesu abko ie ni töi ño ño amne nita ja töi kwite jötrö gare jökrä, aisete nitre näma yete, yebti Jesu näma tödeke ñakare. ");
INSERT INTO gymNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Erere arato, ni moto ño ño gare jökrä Jesuye, aisete ni moto ño ño, ye ni ñakare jire iti kä rababa mike gare ie. ");
INSERT INTO gymNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kä ye ngwane bati, ni bariseo ütiäte kri nämane iti abko kädian nämane Nicodemo. Niara näma sribire Sanedrinbe nitre israelitakrä. ");
INSERT INTO gymNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ni ye abko nikani deo Jesu känti mda, käkwe nieba ie: Dirikä, mata sribi kri ñan tuabare nuene, yebtä abko Ngöbökwe ma juani dirire nunye abko nüke gare nunye, ñobtä ñan angwane ni btä Ngöbö di ñakare ñan raba sribi nuene jire chi ja di jenbti au, mata nuene ye kwrere, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Abtä Jesukwe nieba mda ie: Ti bike kukwe era erere niere mae abko krörö: Ni brare ya, merire ya ñan däredreta bobukäre Ngöbö köböire angwane, Ngöbökwe ñan gobrandre bti, aisete ñan nünandi kärekäre kwe Ngöböbe, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Angwane Nicodemokwe nieba mda Jesuye: ¿Ni tärä nebe unbre ti ne kwrere abko däredreta ño amarebti mata niere kore tie ye? ¡Ni unbre ti ne kwrere ñan rabadre nikenta bobuta meyebtä, bti därereta bobu kore! ");
INSERT INTO gymNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Angwane Jesukwe nieba mda ie: Ti bike kukwe era erere niere mae abko krörö: Ni brare ya, merire ya ñan däredreta bobukäre ñö köböire amne Ngöbö Üai köböire angwane, Ngöbökwe ñan gobrandre bti. ");
INSERT INTO gymNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nita därere ni rün, ni meye kä nebtäkwe, ye abko nita därere niaratre kwrere; akwa nita därere bobuta Ngöbö Üai köböire ye abko ni üai, ni töi amne ni moto tä neme btin. ");
INSERT INTO gymNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Akwa ti bike kukwe niere mae abko krörö: Ni jökrä däredre bobuta Ngöbö köböire, tita niere, nebtä makwe ñan töbika kri dikaro. ");
INSERT INTO gymNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ne abko, Ngöbö Üai abko müreta mate ye kwrere, ñobtä ñan angwane müre töta neme matai mdente mdente, ye känti tä mate. Ye abko, müre ngö tä ruen nie, akwa müre tä kite mdenkri amne tä niken mdente, ye tä nüke gare ñakare nie. Ye kwrere arato, nita därere bobukäre Ngöbö köböire amne Ngöbö Üai tä sribire ño ño ni itire itire btä, ye tä nüke gare ñakare ni mda mdaye, akwa sribi kwe abko tuata btä, nieba kwe Nicodemoye. ");
INSERT INTO gymNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Angwane Nicodemo käkwe nieba mda Jesuye: ¿Ño köböire kukwe ye rabadre bare amarebti mata niere ye? nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesukwe nieba mda ie: ¿Ma dirikä kri nitre israelita ngätäite abko ie kukwe ne nüke gare ñakare ya? ");
INSERT INTO gymNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ti bike kukwe era erere niere mae: Kukwe gare kuin tie Ngöböbtä, yebtä tita blite amne tikwe kukwe tuani ja okwä jenbti, ye tita niere munye, akwa ti kukwei mikata era ñakare munkwe. ");
INSERT INTO gymNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Akwa kukwe kä nebtä btä tita blite mabe, ye abko tare ñakare, aisete rükadre gare mae, akwa ti kukwei ñan tä nebe era makrä. ¿Ye abko, kukweta nakenkä kä käinbti, yebtä tikwe blitadre abko makwe mikadre era ño ye? ");
INSERT INTO gymNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ni ngämi niken jire iti neme Ngöbö känti kä käinbti abko raba blite kukwe yebtä, akwa ti Ni Kä Nebtä Ngobo kä käinbti jatani nüke kä nebtä, aisete ti raba blite kukwe nebtä mabe. ");
INSERT INTO gymNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Mdakäre abko, kira bronse sribebare tbire abko Moisékwe kaninkä kribtä käin kä kaibete nitre israelita bren bren käkwe mikadre ñäräre angwane, Ngöbökwe diandretari angwane ñan krütadre, ye kwrere ti Ni Kä Nebtä Ngobo ne rabadi kaninkä kribtä käin, ");
INSERT INTO gymNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nire nire käkwe tödekadre tibti abko Ngöbökwe dianditari angwane, nünandi kärekäre kwe Ngöböbe, abkokäre ti ne rabadi kaninkä kribtä käin. ");
INSERT INTO gymNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ye kwrere ni Kä Nebtä Ngobo rabadi kaninkä käin, ñobtä ñan angwane Ngöbö ara käkwe ni jökrä tarebare kri krübäte, käkwe ja Odei itibe biani müre ketadre kräke, ni jökrä käkwe tödekadre Ngöbö Odei yebti angwane, ñan rabadre ganinte kärekäre Ngöbö okwä bäre mento, akwa nünandre kärekäre kwe Ngöböbe, abkokäre Ngöbökwe juani, ");
INSERT INTO gymNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ñobtä ñan angwane ñan Ngöbökwe ja Odei juani ni kukwe kämekäme nuenkä Ngöbö rüere mikakäre ja tare nike, akwa niara köböire rabadre dianintari, abkokäre juani kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nire nire käkwe tödekadre Ngöbö Odeibti, ye abko ñan juandre kä ja tare nikakrä känti Ngöbö okwä bäre mento, akwa nire nire tä tödeke ñakare Ngöbö Odei itibe yebti abko Ngöbökwe kukwe ükaninante kräke amne juandi kwe kä ja tare nikakrä ye känti, ñobtä ñan angwane ñan tä tödeke Ngöbö Odeibti aisete. ");
INSERT INTO gymNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ngöbökwe kukwe ükaninte kore ni juankäre kä ja tare nikakrä känti, ñobtä ñan angwane Ngöbö Odei nükani ñotra kwrere kä nebtä Ngöbö mikakäre gare nie, akwa ni ruäre namani kä iko tarere, tö namani nünai janknu kä ikote, kukwe kämekäme nuenkäre janknu Ngöbö rüere, aisete ñotra ye ñan kani ngäbti kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ye abko, ni jökrä töi kämekäme abko mätäta neme ñotrabtä amne ñan töta neme rikai ñotra träte. Kukwe kämekäme nuenta kwetre Ngöbö rüere ye ñan gadre ni mda mdakwe, abkokäre töta neme ja rükainte kore kä ikote. ");
INSERT INTO gymNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Akwa nire nire tä Ngöbö Kukwei kuin metre ye nuene era metre abko tä niken jäme neme ñotra träte, niarakwe sribi kuin nuenbare Ngöbö köböire, ye ni jökrä käkwe gadre nuäre, abkokäre tä niken jäme ñotra träte. ");
INSERT INTO gymNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Abti Jesu näma Jerusalén, rikabata nun ja töitikaka benbe kä Judea käntita, känti rababa nünentbe bä jötrö nunbe angwane, nun näma ni mda mda ngökö ñöte ben. ");
INSERT INTO gymNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Angwane Juan Bautista abko nämane ni ngökö ñöte arato kä Enónte känime kä Salim ken, ñobtä ñan angwane kä ye känti abko ñö okwä nämane kabre. Ye ngwane, ni nämane kite köbö kwatirekwatire amne Juan namani ngökö ñöte. ");
INSERT INTO gymNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ye ngwane abko, Juan kita ngämi ngite kä teri angwane, kukwe ye rakakaba kore. ");
INSERT INTO gymNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Akwa ja bä mikadre ño dbe ñöbti Ngöbö ngwärekri diribare nitre israelitakwe, yebtä ni ruäre nänkä Juanbe abko käkwe ja kwetani nitre israelita ruäre ben. ");
INSERT INTO gymNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Bti nikani, käkwe niebare Juanye: Dirikä, ni näma iti mabe Ñö Jordánbtä sekri sete, btä makwe blitaba, ni ye abko tä ni mda mda ngökö ñöte arato amne ni jökrä nibi niken niara känti, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Abtä Juankwe niebare ietre: Ngöbökwe ñan jändrän biandre angwane, ni ñan rabadre jändrän bkäne, ");
INSERT INTO gymNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","aisete munkwe ti kukwei nuaba, kukwe era erere tikwe nieba krörö: Ti abko ñakare Ni Dianinkä Ngöbökwe, akwa Ni Dianinkä Ngöbökwe ye rükadre abko känenkri ti juani kwe, tikwe nieba metre munye. ");
INSERT INTO gymNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yebtä ti bike kukwe bä mike jabtä amne Jesubtä munye abko krörö: Ni iti tä niken ja mike gure angwane, ni ja mikaka gure ye abko ni merire rabadre ben, ye abko kwe. Akwa ni ja mikaka gure ye kukwe muko tä känime käkwe ni ja mikaka gure ye kukwei nuadre blite angwane, kä rabadre nuäre kri krübäte btä. Ye kwrere kä nena nuäre kri tibtä mtare, ñobtä ñan angwane Jesu abko ni ja mikaka gure kwrere amne ti abko kukwe muko kwrere aisete. ");
INSERT INTO gymNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Niara rika neme bäri ütiäte, ie Ngöbö tö amne ti abko jatadre nementa ütiäte ñakare, ie Ngöbö tö arato. Abko kore se, niebare Juankwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jesu kä käinbti jatani abko bäri ütiäte ni jökrä bti ta; akwa ni därebare kä temenbtä Juan Bautista kwrere, ye ie kukwe kä temenbtä aibe gare, aisete jändrän kä temenbtä aibebtä blitata kwe. Akwa ni kä käinbti jatani ye abko bäri ütiäte ni jökrä bti ta. ");
INSERT INTO gymNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ni kä käinbti jatani käkwe jändrän tuani amne kukwe nuani kwe kä käinbti, yebtä tä blite, akwa ni kwati ñan tä niara kukwei mike era. ");
INSERT INTO gymNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Akwa nirekwe niara kukwei mikadre era angwane, Ngöbö abko tä kukwe era metre niere abko mikata gare ni mda mdaye, ");
INSERT INTO gymNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ñobtä ñan angwane ni juani Ngöbökwe, ye abko tä Ngöbö kukwei era niere, ñobtä ñan angwane Ngöbökwe ja Üai mikani täte jökrä btä, aisete tä blite kore. ");
INSERT INTO gymNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ni juani Ngöbökwe abko Ngöbö Odei amne, Ngöböta ja Odei tarere amne jändrän jökrä mikani gare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ye aisete, nire nire käkwe tödekadre Ngöbö Odeibti ye käkwe nünandi kärekäre Ngöböbe, akwa nire nire käkwe trö kwitadre Ngöbö Odeiye ye abko käkwe ñan nünandre kärekäre Ngöböbe, akwa Ngöbökwe mikadi ja ngie nuen tare krübäte kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yebti ni rababa niken bäri kwati mda Jesu jiebti amne Jesu rababa ni ngökö bäri kwati ñöte Juan Bautista ngwä abko gani nitre bariseokwe. ");
INSERT INTO gymNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Akwa Jesu ara jire abko näma ni ngökö ñakare ñöte, akwa nun ja töitikaka Jesube abko näma ni ngökö ñöte Jesu diäre.) ");
INSERT INTO gymNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nitre bariseo käkwe kukwe gani kore Jesubtä, ye gaba ni Dänkienkwe angwane, niara näma kä Judeate, känti kä mikakaba kwe, bti rikabata Galileate mda. ");
INSERT INTO gymNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Akwa rikadre kä Samariate ta, ");
INSERT INTO gymNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","aisete juta kä Sicar kä Samariate, känti Jesu rikaba nebe. Kira abko Jacobokwe kä biani ngobo Joséye, ye abko näma känime juta Sicar ken ");
INSERT INTO gymNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","amne, ñö okwä Jacobokwe näma yete, ye känti Jesu rikaba. Akwa Jesu rababa dräre dikaka kisete, abtä rababa täkänintbe ñö okwä ye känti. Ñänä jataba nüke ruäre käin angwane, Jesu rababa täkänintbe yete. ");
INSERT INTO gymNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Akwa nun ja töitikaka ben abko rikaba mrö kökö jae jutate, aisete Jesu näma kaibe yete. Ye btäräbe meri Samariabo jataba nüke iti ñö okwäte yete ñö den jae angwane, Jesukwe niebare ie: Ñö ngwen chi tomnane tie, niebare kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Akwa ni israelita abko ja gete ñakare jire chi nitre Samariabobe, aisete meri ye namani töbike kri Jesu kukweibtä, käkwe niebare krörö mda ie: Nitre israelita tä ja gete ñakare jire chi nun Samariabobe, ¿ye ñobtä abko ma israelita amarebti ti Samariabo abko ie ma kite ñö kärere ñadre jae ye? niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Abtä Jesukwe niebare mda ie: Jändrän kuin tä makrä Ngöbökwe amne nireta blite mabe, ye rabadre gare mae angwane, makwe ñö nire kärekäre ye kärädre tie amne tikwe biandre mae, niebare Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Angwane meri ye käkwe niebare Jesuye: Jändrän ñakare ñö diankakrä mae amne ñö okwä noko mente nguse, ¿se abko ñö nire kärekäre makwe diandre mdente tikrä se? ");
INSERT INTO gymNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mdakäre abko, nun mräkä kira Jacob käkwe ñö okwä noko mikaninte nunkrä amne niarakwe ñö noko ñani. Erere arato, niara ngäbriänkä amne jändrän kwekwe käkwe ñö noko arabe ñani. ¿Akwa mtare abko ja ruen bäri Jacobokrä mae ya? niebare kore kwe mda ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Abtä Jesukwe niebare mda ie: Ni jökrä käta ñö noko ñaen abko ie tomna tä nementa. ");
INSERT INTO gymNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Akwa ñö bianta tikwe ye abko nire nire käkwe ñadre abko ie tomna ñan rabadreta jire mda, ñobtä ñan angwane tikwe ñö biandre abko ñadre kwe, ñö ye abko rabadi neen kärekäre btä, käkwe mikadi nüne kärekäre Ngöböbe, niebare kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Angwane meri ye käkwe niebare mda Jesuye: Tomna ñan rabadreta mda tie amne ti ñan jatadreta ñö mda denta jire chi nete, abkokäre ñö nire kärekäre bianta makwe, mata niere, ye ari bien tie, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Angwane Jesukwe niebare mda ie: Nän ma kwäräi kärere, ben ma jatata nete, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Abtä meri ye käkwe niebare mda ie: Ti kaibe. Ti kwäräi ñakare, niebare kwe Jesuye. Jesukwe niebare ie: Ma kaibe, ma kwäräi ñakare makwe nini, ye abko kukwe era erere nini kuin makwe, ");
INSERT INTO gymNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ñobtä ñan angwane makwe ja kwäräi mikanina nirike jire amne, mtare mata ni brare mdara jire ben, akwa munkwe ñan ja mikani gure metre, aisete ma gure ñakare, makwe nini metre kore, niebare kwe meriye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jesukwe ñäkäbare kore meri yeye angwane, meri ye käkwe niebare mda ie: Ti Dänkien, ma abko ni Ngöbö kukwei niekä era metre nibi tuen tie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Akwa nun mräkä Samariabo kirakira käkwe Ngöbö käikitaninkä ngitio nebti, akwa nun rikadre Ngöbö käikitekä juta Jerusalénte abko mun israelita tä niere, niebare kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Angwane Jesukwe niebare mda ie: Meri, ti kukwe mike era makwe. Kä nükera angwane, munkwe ni Rün Ngöbö käikitadikä mdente erere rabadi dbe Ngöbökrä, aisete mun rikadre känime ngitio Gerizim nokobti ya o mun rikadre Jerusalén Ngöbö käikitakakäre, ye abko ñan rabadre ütiäte. ");
INSERT INTO gymNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mdakäre abko, Ngöbö gare ñakare metre mun Samariaboye, aisete munta nire käikitekä ye gare ñakare metre munye; akwa nun israelita abko käta nire käikitekä, ye gare metre nunye, ñobtä ñan angwane ni diantarikä abko jatadi nun israelitakri. ");
INSERT INTO gymNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Akwa mtare kä jatadi amne kitera nüke angwane, nire nire tö Ngöbö käikitaikä ye abko käkwe nuendi era metre Ngöbö Kukweita dirire ye kwrere amne Ngöbö Üai köböire. Ni Ngöbö käikitakaka kore abko Ngöböta känene jakrä, ");
INSERT INTO gymNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ñobtä ñan angwane Ngöbö abko üai, ye aisete nire nire tö Ngöbö käikitaikä abko käkwe nuen era metre Ngöbö Kukweita dirire ye kwrere amne Ngöbö Üai köböire. Abko kore se, niebare kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Abtä meri ye käkwe niebare mda Jesuye: Ni Dianinkä Ngöbökwe (kädekata Kristo kukwe griegore) abko rükadre, ye garera tie amne, niara rükadre angwane, kukwe era erere niedi jökrä kwe nunye kukwe nebtä, niebare kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Angwane Jesukwe niebare ie: Ni btä mata blite ye abko ti ara. Ti ne mden käta blite mabe ye, niebare mda kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ye btäräbe nun ja töitikaka Jesube jataba nüketa angwane, Jesu nämane blite meribe, yebtä nun ñan töi rababa krütare. Akwa meri ye abko tö namani dreye amne Jesu nämane dre kädriere ben abko nin ja rükaba töre jire nunye ngwentari ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Akwa meri ye käkwe kantra mikateba, bti rikabata jutate, käkwe niebare nitre jutate yeye: ");
INSERT INTO gymNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Tikwe kukwe nuenbare kaibe tiebe, ye abko ni iti käkwe nini jökrä tie, aisete ye abko Ni Dianinkä Ngöbökwe ruen tie abko mun jakwe tuen, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Abtä nitre nünanka juta yete jataba jökrä Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Akwa nitre jutate jataba, ye ngämi nüke Jesu känti, känenkri nun ja töitikaka Jesube rababa niere ie: Dirikä, mrö kwete chi, nun näma niere ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Akwa Jesukwe nieba nunye: Mrö tärä keteti kwetadre tie abko gare ñakare munye, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Angwane nun ja töitikaka ben rababa niere krörö jae kwärikwäri: ¿Ni mda nüra mrö ngwena kwetadre ie ya ño yere? nun rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Akwa Jesu abko käkwe niebata mda nunye: Ngöbö ti juanka tö dreye tikrä amne sribi ye abko tikwe mikadre bare täte jökrä, ye abko mrö kwrere tikrä. ");
INSERT INTO gymNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mdakäre abko, mun abko tä niere: Kä tä sö kräbkä jire nura ngwä ötakrä, munta niere. Akwa ni jökrä kä nebtä abko tire Ngöbökwe amne nire nire tä juto biare tödeke tibti abko nura nena biare ötadre kwrere, aisete nura tirete ye nena biare ötadre, ye munkwe mika ñäräre abko tita niere munye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mtare, nire nire tä biare tödeke tibti, ye nitre nura ngwä ötaka tä ngwena tödekakäre tibti abko ie sribi ütiä bianta. Erere arato, nitre nura ngwä ötaka käta ni jökrä ngwena tie tödeke tibti, rabadre nüne kärekäre abkokäre. Yebtä abko ni nura nökaka käta Ngöbö Kukwei mike gare ni mda mdaye amne ni juto biare tödeke tibti, ye nitre nura ngwä ötaka käta ngwena tödeke tibti käkwe kä ngwiandre nuäre gwaire jabtä abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ye abko, kukwe nieta krörö: Ni iti käta nura nökö, akwa ni mda abko käta ngwä ötö, abko nieta metre kore. ");
INSERT INTO gymNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ye kwrere, munkwe nura nökani ñakare tare, akwa tikwe mun juanba nura ngwä ötö. Ni mda mda käkwe sribibare kri sribi Ngöbökwebtä amne mun abko nikani jirekäbe sribi kwekwe ngwä ötö. Abko kore se, nieba Jesukwe nun ja töitikaka ben yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jesu nämane juta Sicar yete angwane, ni kwati Samariabo nünanka yete käkwe tödekani Jesubti, ñobtä ñan angwane meri ben Jesukwe blitabare ye abko namani niere: Ni menteni gare ñakare tie, akwa kukwe nuenbare kaibe tiebe tikwe abko nini metre jökrä kwe tie, niebare kwe. Yebtä ni kwati käkwe tödekaba Jesubti. ");
INSERT INTO gymNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Yebti nitre Samariabo rükaba Jesu känti angwane, Jesu rabadre basare ietre abko rababa ribere kisere ie, ye erere Jesu rababa köböbu juta Sicar yete. ");
INSERT INTO gymNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Angwane ni kwati käkwe niara kukwei nuaba, abtä ni kwati käkwe tödekaba bti. ");
INSERT INTO gymNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Angwane nieba krörö kwetre meri yeye: Mtare ñan kukwe nieba makwe jabtä nunye aibe köböire niara mikata era nunkwe, akwa nun ara jire käkwe niara kukwei nuri blite, aisete niara abko ni jökrä töi kämekäme Ngöbö rüere Diantarikä abko nena gare era metre nunye, amne niarabti nunta tödeke, nieba kwetre meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yebti kä rikaba köböbu ta angwane Jesu näma juta Sicar, rikabata kä Galileate mda. ");
INSERT INTO gymNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Akwa käre Jesu ara jire näma niere krörö jabtä: Ni Ngöbö kukwei niekä abko mikata ütiäte ñakare ja käite, näma niere.) ");
INSERT INTO gymNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Akwa Jesu rababa kä Galileate angwane, nitre nünanka yete käkwe kaba ngäbti kuin, ñobtä ñan angwane niaratre jananbare arato Bieta Pascuabtä Jerusalén angwane, Jesukwe sribi kri ñan tuabare nuenbare ye abko tuani jökrä kwetre amne tö namani tuai mda, aisete kaba ngäbti kuin kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesu rikaba nebe juta Canáte kä Galilea yete. Juta Caná känti Jesukwe ñö kwitani uba döire, ye känti rababata. Angwane abko ni näma iti sribikä ütiäte kri jreikrä abko kän ngäbäkre näma bren dikaro juta Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Angwane Jesu nämane kä Judeate abko nükaninta kä Galileate abko sribikä ütiäte jreikrä ye käkwe gani angwane rikaba ja tuakäre Jesube. Rükaba Jesu känti, ñobtä ñan angwane ngäbäkre kwe nämane bren jume dikaro amne jatanina krüte, aisete rababa Jesu ngwen kisere neme ja gwiriete ngäbäkre ye mikakäreta kuinta. ");
INSERT INTO gymNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Abtä Jesukwe nieba ni jökrä näma yete ie: Sribi ñan tuabare nuenta tikwe, Ngöböta tibe bä mikakrä, ye ñan rabadre bare Ngöbö diebti tie angwane, mun nünanka nete ye käkwe ñan tödekadre jire chi tibti, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Akwa sribikä ütiäte jreikrä ye käkwe nieba mda Jesuye: Nane ngäbäkre tikwe krüta tikän, ye känenkri brän jötrö ti känti, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Angwane Jesukwe nieba mda ie: Ma ngobo rabadita kuinta, aisete nänta ja gwiriete, nieba kwe ie. Angwane ni ye käkwe Jesu kukwei mikaba era, aisete rikabata ja jiebti. ");
INSERT INTO gymNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nämane dikekä ji ngrabare ja jue kukwäre angwane, nitre sribikä kwe jatani, nükani ngätäi ben, käkwe niebare ie: ¡Ngäbäkre makwe nibirate kuinta! niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Abtä niarakwe niebare mda: Kä nuäi angwane ja ki ruenta mobe ie, niebare kwe. Jändrin, ñänä okwä krati dere angwane, drangwan rikaba btä, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Angwane ñänä okwä ye näre dere Jesukwe niebare krörö ngäbäkre rün yeye: Ma ngobo rabadita kuinta, niebare kwe ie, ye abko nükaninta töre ie amne niara btä mräkä kwekwe erere käkwe tödekani jökrä Jesubti. ");
INSERT INTO gymNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ne abko Jesu näma kä Judeate, rükabata Galileate angwane, sribi kri ñan tuabare nuenba bobukäre kwe Ngöbö nämane ben bä mikakäre. ");
INSERT INTO gymNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Yebti köbö mdara jire te, nitre israelita jataba bieta mda nuene Ngöbö käikitakakrä angwane, Jesu rikabata Jerusalén mda. ");
INSERT INTO gymNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Angwane Jerusalén yete abko jukweta kwati abko kädianta Jukwe Obejakwe. Känime jukwe ye ken ñö okwäta kwati abko kädianta Betesda hebreore amne jukäta kwärike ñö okwä ye bäre temen. ");
INSERT INTO gymNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jukä ye täni ni bren bren näma kwati abko krörö: Ni okwä kä drünente, ni nakwente amne ni ruen ñakare ngrabare aisete dikekä ñakare abko näma kitanintbe tementa yete. Ñö ye abko nämane ngibiare kisere, ");
INSERT INTO gymNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ñobtä ñan angwane nane nane angele nämane kite timonkwäre, kä nämane ñö mike ngrenkä angwane, ni bren rikadre käne ñöte abko rabadreta kuinta, aisete nämane ñö ngibiare kisere. ");
INSERT INTO gymNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ni bren bren ye ngätäite abko ni näma iti abko nikani bren kä kwä gre bti kwä jätäbti kwä kwära abko näma siba. ");
INSERT INTO gymNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ni ye näma kitanintbe temen yete, btä Jesu okwä rababa angwane, kä raire niara nikani bren nike abko ben nämane nüke yete abko Jesukwe gaba btä angwane, nieba kwe ie: ¿Ma tö rabaita kuinta ya? nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Angwane ni bren ye käkwe nieba mda Jesuye: Ti Dänkien, ñö okwä se tä kite ngrenkä batire batire kukwäne angwane, ni mda ñakare ti mikaka te, aisete käre ti töta neme rikai ñö okwä nokote angwane, ni mda tärä niken käne te, aisete käre tita nemente ye, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Angwane Jesukwe nieba mda ie: Näin krö, jänkwata makwe ye den kisete, ben ma rika dikekä, nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ye btäräbe ni ye rababata kuinta batibe, käkwe jänkwata jakwe dianba kisete, bti rikaba dikekä kwäräkwärä se kwrere. Akwa ye näire abko köbö jadükakrä te ni ye rababata kuinta. ");
INSERT INTO gymNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ye aisete ni bren rababata kuinta, ye ie nitre israelita ji dokwäte käkwe nieba: Köbö jadükakrä mtare, ye te makwe jänkwata makwe ye ngwiandre ñakare jire, ¿ye ñobtä mata ngwena ye? nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Abtä ni ye käkwe nieba nitre israelitaye: Ni ti mikakata kuinta käkwe nini krörö tie: Jänkwata makwe ye den kisete, ben nän dikekä, nini kwe tie, erere tita nuene, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Angwane nitre israelita ji dokwäte ye käkwe nieba mda ni yeye: ¿Jänkwata makwe ye den kisete, bti nän dikekä, ye nirekwe nini mae? nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Akwa nirekwe mikabata kuinta abko ñan rababa gare ie, ñobtä ñan angwane Jesukwe niara mikaninta kuinta angwane, ni näma kwati, ye känti Jesukwe kä mikakaba kä bube ngware. ");
INSERT INTO gymNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Yebti ni bren mikabata kuinta Jesukwe ye näma ju blitakrä Ngöböbe känti abko kwanba Jesuye angwane, Jesukwe mäträba btä, käkwe nieba ie: Tuen, mtare ma nenante kuinta Ngöbö diebti, akwa nane kukwe mda rakaka bäri tare mabtä, ye ngäniene makwe ñan ja mika ngite Ngöbö rüere mda, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Angwane batibe Jesukwe niara mikaninta kuinta, ye abko rikaba, käkwe niebare nitre israelita ji dokwäte yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ye kwrere Jesu näma sribi nuene köbö jadükakrä näire, abtä nitre israelita ji dokwäte rababa näin kisere Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Akwa blitaba kwetre Jesube angwane, Jesu abko käkwe nieba krörö ietre: Ti Rün tikwe tä sribire käre abti kä nüke mtare abko erere tita sribire arato, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nebtä abko bäri nitre israelita ji dokwäte tö rababa Jesu müre ketai mda, ñobtä ñan angwane köbö jadükakrä ye abko Jesu ñan namani mike ütiäte jae, namanintre nütüre. Bärire mda abko, Ngöbö abko ja Rün jakwe Jesu rababa niere, yebtä abko Jesu näma ja mike Ngöböre abko dokwäre tö rababa Jesu müre ketai. ");
INSERT INTO gymNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Angwane Jesukwe nieba mda ietre: Kukwe era erere ti bike niere munye: Ti, Ngöbö Odei ne ñan raba jändrän nuene jire chi ja töi jenbti, akwa ti Rünta dre dre nuene, ye erere ti Ngöbö Odei tä nuene, ñobtä ñan angwane jändrän jökrä nuenta ti Rünkwe ye erere tita nuene. ");
INSERT INTO gymNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ye ñobtä ñan angwane ti Rün käta ti niara Odei tarere amne ti Rün käta dre dre nuene, ye erere tä mike gare jökrä tie. Ye abko, ni bren mikaninta kuinta tikwe, yebti ta sribi bäri krikri ñan tuabare munkwe abko ti Rünkwe mikadi tuadre munye ti köböire, abtä mun ñan töi rabai krütare. ");
INSERT INTO gymNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ti Rün käta ni krütani miketa nire amne tä nebe nünenta, ye kwrere arato ti, Ngöbö Odei ne tö rabadre nire nire mikaita nire, ye erere tikwe mikadita nire. ");
INSERT INTO gymNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ti Rün käta kukwe ükete ñakare ni kä nebtä kräke, akwa ti Ngöbö Odei ne kisete sribi mikani kwe, kukwe ükatekäre kä mrä angwane ni kä nebtä kräke, ");
INSERT INTO gymNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ni jökrä käta ti Rün mike ütiäte kri, ye kwrere ti, Ngöbö Odei ne mikadre ütiäte kri kwetre amne käikitadrekä kri kwetre arato, abkokäre kä biani kwe tie kukwe ükatekäre. Ye abko, nire nire käkwe ñan ti Ngöbö Odei ne mikadre ütiäte jae, ye ngwane ti Rün käkwe ti juani ye mikata ütiäte ñakare kwetre arato. ");
INSERT INTO gymNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kukwe era erere ti bike niere mda munye abko krörö: Tita blite ye nire nire tä kukwe nuen amne tä ketete ja olote amne ni ti juanka, yebti tä tödeke, ni ye abko tä neme nünenta kärekäre Ngöböbe amne Ngöbökwe ñan juandi kä ja tare nikakrä känti, ñobtä ñan angwane niara ngämi tödeke tibti, känenkri nämane ni ngwäkäre kwrere, akwa tödekabtä tibti nükani nire kena. ");
INSERT INTO gymNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Akwa kukwe mdara jire era erere ti bike niere munye abko kä kitera nüke mtare angwane, ni ngwäkäre ie ti Ngöbö Odei kukwei jaradi angwane, nire nire käkwe ti Ngöbö Odei kukwei nuadre, bti tödekadre kwe tibti, ye abko rabadi nüne kärekäre Ngöböbe, ");
INSERT INTO gymNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ñobtä ñan angwane Ngöbö di tärä ni mikakrä nire, ye kwrere arato kä biani kwe tie ni mikakäreta nire. ");
INSERT INTO gymNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Erere arato, kä biani täte jökrä kwe tie kukwe ükatekäre ni mda mda kräke, ñobtä ñan angwane ti abko Ni Kä Nebtä Ngobo, aisete kä biani kwe tie sribi ne nuenkäre. ");
INSERT INTO gymNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tita kukwe niere, yebtä munkwe ñan töbika krübäte dikaro, ñobtä ñan angwane kä jatadi köböitira jire abko te ni krütani doboi mikani, ie ti Ngöbö Odei ne kukwei jaradi dobobti angwane, ");
INSERT INTO gymNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","rükadita nire jökrä. Akwa nire nire käkwe sribi nuenbare kuin Ngöbökrä abko rükadita nire nünakäre kärekäre Ngöböbe amne, nire nire käkwe kukwe nuenbare käme Ngöbö rüere abko rükadita nire ja tare nikakäre kärekäre Ngöbö okwä bäre mento. ");
INSERT INTO gymNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mdakäre abko, ti ñan raba kukwe nuene jire chi ja töi jenbti, aisete ti Rünta kukwe ükatemna ño tie ni mda mda kräke, ye erere tita ükete. Amne tita kukwe ükete kuin metre, ñobtä ñan angwane ti ñan tö kukwe nuein jire chi ja töi jenbti kä ngwiankrä nuäre jabtä, akwa ti tö ti Rün ti juanka moto mikai nuäre, aisete niara töta neme dreye, ye erere tita nuene. ");
INSERT INTO gymNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mdakäre abko, ti aibe käkwe blitadre jakrä au, ye ngwane ti kukwei ñan rabadre tuen metre munye, ");
INSERT INTO gymNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","akwa ti Rün arato tä kukwe era erere niere tikrä arato. Niara abra tä kukwe niere metre tibtä abko gare kuin tie. ");
INSERT INTO gymNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ye abko, bati munkwe ni juani kukwe ngwentari Juan Bautistaye angwane, Juankwe blitabare kuin era metre kukwe erabtä tikrä. ");
INSERT INTO gymNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ye abko, ñan ni mda mda käkwe blitadre tikrä abko ütiäte tikrä, aisete Juankwe blitabare abko tita niereta. Akwa Juankwe kukwe niebare tibtä, ye munkwe mikadre era, köböire mun rabadre dianintari, abkokäre tita Juan kukwei niereta munye. ");
INSERT INTO gymNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan abko nükani ñotra kwrere abko trä namani ngitiekä mun ngätäite, kä namani kukwe era erere niere tibtä angwane, bä jötrö mun tö namani käi ngwen nuäre jökrä jabtä Juan kukwei nuare abti mun ñan tö namani kukwei nuai mda. ");
INSERT INTO gymNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Akwa ni mda mda blitaka bäri kuin tikrä Juan ngwä abko nere: Ti Rünkwe sribi nuemna bätäkä ngwarbe tie, ye erere tita nuene. Ye abko, ti Rünkwe ti juani era metre abko sribi ye käta bä mike tibtä. ");
INSERT INTO gymNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Erere arato, ti Rün ti juanka ye abko tä blite metre tikrä. Akwa mun abko käkwe ñan ti Rün kukwei nuabare jire chi amne niara bä ño abko mun tuen ñakare amne ");
INSERT INTO gymNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ti Rün kukwei neketete ñakare munbtä, ñobtä ñan angwane ti juani ti Rünkwe abkobti mun ñan tä tödeke, aisete ti Rün kukwei ñan tä neme munbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ye abko, munta ja töitike krübäte Ngöbö Kukweibtä, ñobtä ñan angwane ye köböire mun rabadre nüne kärekäre abko munta nütüre, akwa Ngöbö Kukwei ara käta blite tibtä, ");
INSERT INTO gymNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","akwa ti nebti mun ñan tö tödekai nünakäre kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mdakäre abko, ni mda mda käkwe ti mikadre ütiäte, käkwe ti käikitadrekä, ye abko ñakare ütiäte tikrä, ");
INSERT INTO gymNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","akwa mun abko gare kuin jökrä tie abko krörö: Munta Ngöbö tarere ñakare, ye gare kuin tie munbtä, ");
INSERT INTO gymNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","44","ñobtä ñan angwane mun abko tä ja käikitekä kwärikwäri amne Ngöbö itibe käkwe mun käikitadrekä, yebtä munta töbike ñakare, aisete ¿mun rabadre tödeke ño tibti? Ni mda mda jatadre kukwe ükaninte au niere mun moto mikakäre nuäre, ye abko munkwe kadre ngäbti jäme jötrö, akwa ti abko jatani ti Rün käbti, niara kukwei niere metre munye angwane, mun ñan tö ti kain ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Akwa kä mrä angwane, ti näin mun kite ngite ti Rün ngwärekri munkwe ñan nütü tibtä, ñobtä ñan angwane Moisés, btä munta ja töi mike, Moisés ye ara käkwe mun kitadi ngite ti Rün ngwärekri, ");
INSERT INTO gymNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","47","ñobtä ñan angwane mun ñan tö tödekai tibti. Akwa Moisés käkwe tärä tikani tibtä abko munta mike ñakare era jae. Ye ti abko kukwei mikadre era ño jae munkwe amarebti Moisékwe tärä tikani tibtä ye mikadre era munkwe, ye ngwane munkwe ti kukwei mikadre era jae arato amne munkwe tödekadre tibti, ñobtä ñan angwane Moisékwe tärä tikani tibtä. Abko kore se, nieba Jesukwe nitre israelita ji dokwäteye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Abti bati Jesu rikabata Galilea mda. Abti Jesu rikabata Ñö Okwä Kri Galilea kwäräkri. (Ñö okwä ye arabe kädianta Tiberias arato). ");
INSERT INTO gymNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Angwane ni rikaba kwati Jesu jiebti, ñobtä ñan angwane Jesu rababa sribi kri ñan tuabare nuene Ngöbö nämane ben bä mikakäre, kä rababa ni bren bren miketa kuinta nitre ye okwäbti, yetari rikaba Jesu jiebti. ");
INSERT INTO gymNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Angwane Jesu rikaba ngitiobtä mintokwäre, känti rababa täkänintbe temen nun ja töitikaka benbe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kä ye ngwane abko bieta nitre israelitakwe kädianta Pascua, ye köböi jatabara nüke ja ken. ");
INSERT INTO gymNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Akwa Jesu rababa täkänintbe dirire ietre. Yebti niara käkwe nikraba angwane, ni näma näin kwati jiebti, yebtä okwä rababa angwane, nieba kwe Felipeye: ¿Ni kwati se kräke nikwe ban kökadre mdente, mata nütüre? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesu abko käkwe dre nuendi abko rababara gare kuin ie, akwa Felipekwe dre niedre abko Jesu tö rababa gai, käkwe nieba kore ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Angwane Felipekwe nieba Jesuye: Ngwian ganaindre sö krä kwä jire rabadre nikwe akwa, ngwian ye näre ñan rabadre täte jire chi mrö kökakrä biandre kiakia nitre kwati seye, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ye btäräbe Simón Pedro etba Andrés ja töitikaka Jesube arato käkwe nieba Jesuye: ");
INSERT INTO gymNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Ngäbäkreta iti nete abko kwe sebada bainta kunrike amne gwa nötare tä krobu kwe, akwa ¿se abko rabadre täte ño nitre kwati bti se? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Abtä Jesukwe nieba mda: Nitre ye rabadre täkänintbe jökrä temen niere ietre munkwe, nieba kwe. Angwane kä ye känti abko kä mikäre temen, känti nitre ye rababa täkänintbe jökrä. Nitre brare brare aibe näma mili krärike jire yete. ");
INSERT INTO gymNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Angwane ban näma kunrike ngäbäkrekwe, ye Jesukwe dianba kisete, kuin nieba btä kwe Ngöböye, bti nitre näma täkänintbe temen, yebti dräiba kwe. Erere arato, gwa dräiba kwe amne ni itire itire tö rababa mröi nuäi nuäi, ye erere bianba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Yebti nitre ye rababa trine trine jökrä angwane, Jesukwe nieba nun ja töitikaka benye: Ban oto nebete se ñan rikadre ngwarbe jire chi, abkokäre ükekrö jökrä munkwe, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ye erere bkänä, sebada bain oto rabateba, ye nunkwe ükakröba kutia krikri kwä jätäbti kubu jire. ");
INSERT INTO gymNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Sribi kri ñan tuabare nuenba Jesukwe Ngöbö nämane ben mikakäre gare, ye abko nuenbare kwe nitre kwati ye okwäbti angwane, niaratre rababa niere jae kwärikwäri: Ni Ngöbö kukwei niekä rükadre kä nebtä niebare Moisékwe abko ara tä nete ñan ñan, rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Akwa niaratre tö namani Jesu ngwiain kisere mikakäre jreire, ye gaba btätre Jesukwe. Abtä Jesu rikabata jirekäbe nementa ngitiobti minti rabakäre kaibe yete. ");
INSERT INTO gymNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Yebti kä jataba iko angwane, nun ja töitikaka Jesube abko jatabata motokwäre nüketa ñö okwä känti. ");
INSERT INTO gymNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ye känti ru näma krati, te nun rükaba. Jesukwe nun juanba juta Capernaúmte abko erere ru yete nun rankwaba, bti nun rikaba ñö okwäbti. Nun rikaba angwane, kä rababara iko, akwa Jesu ngämi nüketa rute. ");
INSERT INTO gymNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nun rikaba, ye btäräbe müre jataba mate ribi ja dibti, kä rikaba ñö kitekä nekwäre sekwäre angwane, ");
INSERT INTO gymNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","nun abko rikabara mobe ñöbti, bäsi kilometro krärike, krä ti näre angwane, Jesu näma dikekä ñöbti. Jesu näma dikekä ñöbti, ye jataba nüke ru ken nun känti, btä nun okwä rababa. Abtä kä jürä rababa kri nunbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Angwane Jesukwe nieba mda nunye: Tita näin, aisete mun ñan rekwetaka tibtä, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Angwane kä rababa nuäre nunbtä Jesu kare ngäbti rute. Ye btäräbe nun rababa ñö köräbti juta Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Yebti jändrinane angwane, ru näma kratibe abko te nun ja töitikaka Jesube rikaba, akwa Jesu abko rikaba ñakare rute nunbe, ye abko nitre kwati rababa ñö okwä kwäräkri ye käkwe gaba. ");
INSERT INTO gymNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ye btäräbe ru mda mda nämane juta Tiberiate abko nükani neme känime, Jesukwe kuin nieba banbtä, bti dräiba kwe, ye ken ru namani. ");
INSERT INTO gymNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Angwane Jesu näma ñakare yete amne nun ja töitikaka ben näma ñakare yete, ye nitre kwati käkwe gaba angwane, rankwaba arato rute, rikaba arato juta Capernaúm kukwäre Jesu känentari. ");
INSERT INTO gymNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ye erere bkänä, rikaba nebe ñö okwä kwäräkri, känti Jesu kwanba ietre angwane, nieba kwetre ie: ¿Dirikä, ma nükani ñongwane nete? nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Angwane Jesukwe nieba mda ietre: Ti bike kukwe era erere niere munye. Sribi kri ñan tuabare tikwe nuenba mun okwäbti Ngöböta tibe bä mikakäre, abkotari munta ti känentari ñakare. Akwa tikwe mun bukaba trine trine bante, aibetari munta näin ti jiebti abko ti tö nibi niei munye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Akwa mrö tä niken ngwarbe jötrö te tikwe mun bukaba, ye kräke munkwe ñan sribi, akwa mrö käkwe ni mikadre nüne kärekäre Ngöböbe, ye kräke munkwe sribi. Mrö ni mikakrä nüne kärekäre, ye abko ti Ni Kä Nebtä Ngobo aibe käkwe biandre munye, ñobtä ñan angwane ti abko dbe Ngöbö ti Rün ngwärekri abko Ngöbö ti Rün käkwe bä mikanina tibtä, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Abtä nitre ye käkwe nieba mda Jesuye: ¿Nunkwe sribi mden nuendre, ie Ngöbö tö abko nun tö gai? nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Angwane Jesukwe nieba ietre: Ti abko juani Ngöbökwe. Tibti munkwe tödekadre, ie Ngöbö tö, aisete ye aibe nuendre munkwe, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Abtä nieba mda kwetre Jesuye: ¿Sribi mden mden ñan tuabare makwe bä mikadre tuare nunye, Ngöböta mabe mikakäre gare nunye, abtä nunkwe tödekadre mabti? ¿Amne sribi mden nuenta makwe abtä nun rabadre tödeke mabti? ye niere nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Makwe nuendre krörö ruen nunye: Nun mräkä kirakira nämane dikekä kä kaibete angwane, mrö kä mana kwetani kwetre abko sribi kri ñan tuabare Moisékwe nuenbare. Kukwe yebtä abko nieta krörö Ngöbö Kukweibtä: Ban kä käinbti kä mana bini kwetadre nie, abko Ngöbö Kukwei käta niere. ¿Ye kwrere makwe nuendre arato ya? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Angwane Jesukwe nieba ietre: Ti bike kukwe era erere niere munye. Moisékwe ban kä käinbti biani ñakare kwetadre munye, akwa Ngöbö ara käkwe biani Moisés köböire. Akwa mtare ti Rün käta ban era metre kä käinbti bien mun kräke, ");
INSERT INTO gymNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ñobtä ñan angwane ban era metre bianta Ngöbökwe ni jökrä kräke, ye abko ni kä käinbti jatani kä nebtä abko tä mun mike nüne kärekäre, ye abra ban era metre, nieba kwe mda ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Abtä nieba kwetre mda Jesuye: Dänkien, makwe ban ye bian käre köbö kwatirekwatire nunye, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Angwane Jesukwe nieba ietre: Ti abko ban käta ni mike nüne kärekäre Ngöböbe. Nire nire tä kite tie amne tä tödeke tibti, ni ye ñan rabadreta mröi jire chi mda. Erere arato, nire nire käta tödeke tibti abko ie tomna ñan rabadre jire chi mda. ");
INSERT INTO gymNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Akwa ye abko tikwe kukwe niebarera munye, erere ti bike niereta munye abko krörö: ti tuata munkwe, akwa mun ñan tö tödekai tibti. ");
INSERT INTO gymNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Akwa nire nire bianta tie ti Rünkwe, ye abko tä kite tie tödekakäre tibti amne, nire nire tä kite tie, ye abko tita ngibiare kuin jakrä amne tita juentarita ñakare jire chi mento. ");
INSERT INTO gymNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ye abko ñan ti kä käinbti jatani kä nebtä kukwe nuenkäre ja töi jakwebti, akwa ti Rün käkwe ti juani, ye abko tö dreye abko erere ti jatani mike täte. ");
INSERT INTO gymNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Amne ti Rün käkwe ti juani abko käkwe nire nire biandre tie, ye abko ñan riadrete jire iti tikän amne kä mrä angwane tikwe mikadreta nire nünakäre kärekäre Ngöböbe abko ie ti Rün tö, ");
INSERT INTO gymNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ñobtä ñan angwane nire nire käkwe ti Ngöbö Odei mikadre ñäräre kuin amne tödekadre tibti kwe abko käkwe nünandi kärekäre amne, köbö mrä angwane tikwe mikadita nire abko ie ti Rün tö abko erere tita nuene, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ti abko ban kä käinbti jatani kä nebtä, nieba Jesukwe, yebtä abko nitre israelita ji dokwäte rikaba ñäke jökrä Jesu rüere mda, ");
INSERT INTO gymNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","käkwe nieba krörö: ¿Jesu noko abko ñan José ngobo ya? Niara rün amne meye gare kuin nie. ¡Se ñobtä nämane kä käinbti abko jatani kä nebtä nibi niere mtare se! rababa niere Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Abtä Jesukwe nieba mda ietre: Kwekbe munkwe. Munkwe ñan ñäkä kore ti rüere. ");
INSERT INTO gymNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ti Rün käkwe ti juani, ye ñan jatadre ni ngwena tie angwane, ni ñan jatadre jire iti ja töi jenbti tie, akwa ni ye tä kite tie abko tikwe mikadita nire nünakäre kärekäre Ngöböbe köbö mrä angwane. ");
INSERT INTO gymNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ye mden kisete, nitre Ngöbö kukwei niekä kira käkwe tärä tikani btä nieta krörö: Ngöbökwe ni jökrä töi tikadi, nieta Ngöbö Kukweibtä. Ne aisete nire nire tä ti Rün kukwei nuen amne ti Rün käkwe töi tikadre, ye abko tä kite tie. ");
INSERT INTO gymNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ye abko, ni ñakare jire iti kä nebtä käkwe ti Rün tuani, akwa ti jatani Ngöbökri ne aibe käkwe ti Rün tuani. ");
INSERT INTO gymNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne aisete, ti bike kukwe era erere niere munye: Nire nire käkwe tödekadre tibti ye abko käkwe nünandi kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ti abko ban käta ni mike nüne kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mun mräkä kirakira käkwe mana kwetani kä kaibete, akwa ye nämane ni mike nüne ñakare kärekäre, aisete niaratre krütani jökrä. ");
INSERT INTO gymNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","51","Akwa ti abko ban kä käinbti jatani kä nebtä ara tä nete amne nire nire käkwe ban ne kwetadre abko ñan krütadre kärekäre, akwa nünandi kärekäre kwe. Akwa ban biandi tikwe kwetadre, ye abko ti ngätä tikwe ne biandi tikwe. Angwane ni jökrä rabadre nünenta kärekäre, abkokäre tikwe ja ngätä ne ara jire biandi müre ketadre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yebtä abko, nitre israelita ji dokwäte rikaba ñäke jae kwärikwäri Jesu rüere, käkwe nieba: ¿Ni se käkwe ja ngätä biandre kwetadre ño nie amarebti nibi ñäke kore se? rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Abtä Jesukwe nieba mda ietre: Ti bike kukwe era erere niere munye, btä ti bike kukwe bä mike krörö munye: Nire nire tä kite tie, ye abko tä ti ngätä kwete kwrere amne nire nire tä tödeke tibti, ye abko tä ti därie ñaen kwrere. Angwane ti Ni Kä Nebtä Ngobo ye munkwe ñan ngätä kwetadre amne munkwe ñan därie ñadre angwane, munkwe ñan nünandre kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ne aisete, nire nire käkwe ti ngätä kwetadre amne ti därie ñadre kwe kore, ye abko käkwe nünandi kärekäre Ngöböbe angwane, tikwe mikadita nire köbö mrä näire, ");
INSERT INTO gymNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ñobtä ñan angwane ti ngätä abko mrö era metre amne ti därie abko tomna era metre. ");
INSERT INTO gymNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ne aisete, nire nire jatadre tie, käkwe ti ngätä kwetadre amne nire nire käkwe tödekadre tibti, käkwe ti därie ñadre, ni ye abko käkwe nünandi ketetibe tibe amne tikwe nünandi ketetibe ben arato. ");
INSERT INTO gymNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ti Rün käkwe ti juani, ye tä nüne amne niara köböire tita nüne, ye kwrere arato nire nire käkwe ti ngätä kwetadre mrö kwrere, ni ye abko käkwe nünandi kärekäre ti köböire. ");
INSERT INTO gymNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ti ngätä ne abko ban kä käinbti jatani kä nebtä. Yebtä tita blite amne kukwe bä mike. Ban ne abko ñakare mana kwetani mun mräkä kirakirakwe ye kwrere, ñobtä ñan angwane niaratre käkwe mana kwetani, akwa krütani jökrä. Akwa ban btä tita blite, ye abko nire nire käkwe kwetadre ye abko tödeka tibti abko tita niere angwane, nünandi kärekäre kwe Ngöböbe. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kukwe ye abko Jesukwe diriba jökrä sinagogate juta Capernaúmte. ");
INSERT INTO gymNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jesukwe diriba kore, ye ni kwati nänkä ben käkwe kukwe nuaba angwane, nieba kwetre: ¿Ni se käkwe blitaniri se abko tare krübäte ni kräke, se nirekwe niara kukwei mikadre täte se? rikaba niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Niaratre rababa blite kore Jesu rüere, ye gaba Jesukwe angwane, nieba mda kwe ietre: ¿Tikwe blitaniri ye nibi mate tare munbtä ya? ");
INSERT INTO gymNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ti Ni Kä Nebtä Ngobo nämane nüne käne, känti rikadreta kä käinbti mun okwäbti, ye ngwane munkwe töbikadre ño btä? ");
INSERT INTO gymNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ngöbö Üai käta ni mike nüne kärekäre Ngöböbe amne, jändrän jökrä kä nebtä ni ngätä kwrere, ye abko ütiäte ñakare, ñobtä ñan angwane ñan raba ni mike nüne kärekäre Ngöböbe. Ye abko, kukwe btä tita blite Ngöbö Üai köböire amne kukwe nini tikwe, ye munkwe mikadre era jae, käkwe tödekadre tibti angwane, munkwe nünandi kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Akwa mun ruäre tä nete abko ñan tö tödekai tibti, aisete mun ñan tö ti kukwei mikai era. Abko kore se, nieba Jesukwe ietre. Jesu abko käkwe ñäkäba kore, ñobtä ñan angwane nire nire käkwe ñan tödekadre bti, ye nämanena gare käne ie. Erere arato, ni iti käkwe niara kitadi ngise rüeye, ye nämanena gare käne ie, aisete ñäkäba kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yebti Jesukwe nieba mda ietre: Mun töi kore, ye mden kisete tikwe nini krörö: Ti Rün käkwe ñan ni biandre tie, ye ngwane ni ñan jatadre jire iti tie ja töi jakwebti, tikwe nini munye, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ye ngwane mentokwäre ni kwati näma näin Jesu jiebti käkwe kä mikakaba btä amne ñan rababa dikekä mda ben. ");
INSERT INTO gymNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Angwane nun ja töitikaka ni jätäbti nibu, ie Jesukwe nieba: ¿Mun tö nibi näinta mento tibtä arato ya? nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","69","Angwane Simón Pedro käkwe nieba: Ti Dänkien, ma kukwei abko kukwe ni mikakrä nire kärekäre amne, ma abko Ni Deme Ngöbökwe ye nena gare nunye amne nunkwe mikanina era jae. ¿Se abko nun rikadre nireye mda se? nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Abtä Jesukwe nieba mda ie: Mun ni jätäbti nibu käkwe ja töitikadre tibe, abkokäre tikwe mun dianinkä, akwa mun iti abko diablu kwrere jire, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesukwe ñäkäbare kore ye abko Simón Iscariote ngobo kä Judas näma ja töitike siba Jesube abko käkwe Jesu kitadi ngise rüeye, abkobtä nieba kore kwe. Akwa Judas abko ni ja töitikaka Jesube arato nun ni jätäbti nibu ngätäite. ");
INSERT INTO gymNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yebti Jesu näma dikekä kwäräkwärä dirire kä Galileate. Niara ñan tö rababa rikaita nebe kä Judeate, ñobtä ñan angwane nitre israelita ji dokwäte näma ngibiare yete müre ketare. ");
INSERT INTO gymNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ye ngwane abko, bieta nitre israelita kädianta Ju Bäkrä jatabare nüke ja ken. ");
INSERT INTO gymNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Abtä Jesu etbakantre käkwe nieba ie: Mata sribi kri ñan tuabare nuene nete, ye nitre nänkä ma jiebti tä nüne kä Judeate ye käkwe tuadre, abkokäre nän nebe bietabtä Judeate. Akwa ma ñan raba Galileate nete, ");
INSERT INTO gymNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ñobtä ñan angwane ni rabadre ütiäte ni mda mda ngätäite, ie ni töta nebe, ye abko ñan nita nebe jändrän nuene kaibe tiebe, aisete mata sribi kri ñan tuabare nuene Galilea nete, ye ma rika nuene ni jökrä ngwärekri Jerusalén arato, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Jesu etbakantre abko ñan nämane tödeke bti, aisete ñäkäbare kore kwetre ie.) ");
INSERT INTO gymNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Akwa Jesukwe nieba mda ietre: Kä kitani ti käne erere ngämi nüke tie, akwa mun abko kräke köbö jökrä kuin nänkrä bietabtä Jerusalén. ");
INSERT INTO gymNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ni mda mda käkwe ñan bätä ngwiandre munbtä, ñobtä ñan angwane mun töi ja kwrere niaratrebe. Akwa ti abko btä bätä ngwianta kwetre, ñobtä ñan angwane niaratre tä kukwe nuene kämekäme Ngöbö rüere, ye abko käme tita niere metre ietre, abtä mätä tibtä, aisete ti ñan rikadre. ");
INSERT INTO gymNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Akwa mun abko rüe ñakare, aisete mun rika bietabtä amne ti abko kä kitani ti käne Ngöbökwe abko ngämi nüke, aisete ti ñan rikadre bieta yebtä. Abko kore se, nieba kwe etbakantreye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesukwe nieba kore etbakantreye, bti niara rababa kä Galileate yete ");
INSERT INTO gymNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","angwane, etbakantre rikaba jökrä bietabtä. Yebti Jesu rikaba köre bietabtä arato, akwa rikaba kä bube tiebe, ñan rikaba ni jökrä ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Angwane Jesu ngämi nüke Jerusalén bietabtä, känenkri nitre israelita ji dokwäte abko rababa Jesu känentari kisere nekwäre, sekwäre bieta yete, kä rababa niere: ¿Ni ngututu ngwarbe ye tä mdente ruen? rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Akwa ni näma kwati bietabtä, ye rababa blite tiebetiebe jökrä Jesubtä. Ni ruäre rababa niere: Ni ye abra moto kuin, rababa niere. Akwa ni ruäre abko rababa niere: Ñakare. Ni ye ñakare kuin amne tä näin ni ngökö jirekäbe, rababa niere tiebe Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Akwa ni jökrä, btä nitre israelita ji dokwäte ye jürä rababa, aisete rababa blite tiebetiebe jabe kwärikwäri amne ñan rababa blite ja ngwärekri jökrä Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Yebti bieta ötöbu ta angwane, ju blitakrä Ngöböbe ye bäre Jesu rikaba amne rikaba dirire. ");
INSERT INTO gymNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Angwane nitre israelita ji dokwäte töi ñan rababa krütare kukweibtä, kä rababa niere: ¿Ni noko jananbare ja töitike ñakare dirikä krikri be, se ño känti abko Ngöbö Kukwei gare krübäte dikaro ie se? rababa niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Abtä Jesukwe nieba ietre: Tita kukwe dirire, ye abko ñakare tikwe, akwa ni ti juanka abko kukwei dirita tikwe. ");
INSERT INTO gymNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ne aisete Ngöbö ti juanka tö dreye, ye erere nire nire tä biare mikakäre täte, ni ye abko ie ti kukwei rükadi gare metre angwane, tita kukwe dirire, ye Ngöbökri ya o tita kukwe dirire ja töi jenbti au abko rükadi gare ie. ");
INSERT INTO gymNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ye abko, nire nire tö ja mikai ütiäte abko käta blite ja töibti au aibe, akwa nire nire tä sribire ni niara juanka mikakäre ütiäte, ni ye abko tä kukwe era erere niere amne ñan tä kukwe ngwarbe niere jire. Ye erere tita dirire. ");
INSERT INTO gymNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés abko käkwe Ngöbö kukwei biani nuendre munye ye abko era ñan ñan. Akwa ni ñakare jire iti mun ngätäite käta kukwe ye mike täte metre. ¿Ye ñobtä mun tö ti müre ketai? nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Abtä nitre näma kwati yete ye käkwe nieba mda: ¿Nire tö nibi ma müre ketai amarebti mata ñäke kore ye? ¡Ye ñan üai käme tä mabtä, kisete mata ñäke kore ya! nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Angwane Jesukwe nieba mda ietre: Tikwe sribi kri ñan tuabare nuenba käkwe ni mikabata kuinta batibe köbö jadükakrä näire, abtä mun ñan töi rababa krütare amne mun rababa romon tikrä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Akwa ja ñäräkrä mikadre ja kwatabtä abko Moisékwe nuemna munye, aisete Moisés kukwei mikakäre täte, munta ni ñäräkrä mike kwatabtä köbö jadükakrä näire. Ye abko ñan Moisékwe nuemna kena, akwa Ngöbökwe nuemna kena nitre israelita mräkä känekäneye, yebti Moisékwe nuemnanta munye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mun ñan töta nebe Moisés kukwei kitai temen, aisete ngäbäkre tä därere abti ñäräkrä mikadre kwatabtä niebare Moisékwe amne, köbö kwäirare ye tä nüke köbö jadükakrä näire akwa, munta ngäbäkre ñäräkrä mike kwatabtä, ye abko sribi, akwa munta nuene. ¿Ye ñobtä abko tikwe ni bren mikaninta kuin täte jökrä köbö jadükakräte abko btä mun romon tikrä? ");
INSERT INTO gymNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mun tö raba kukwe ükaite tikrä angwane, kukwe ño ño nuenta tikwe erere tuen ño munye, abtä munta ti kite ngise ngwarbe. Ye abko munkwe ñan nuendre jire chi mda, akwa kukwe era metrebti munkwe kukwe ükadrete. Abko kore se, nieba Jesukwe nitre israelita ji dokwäteye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Angwane nitre israelita ruäre nünanka Jerusalén rababa niere jae kwärikwäri: ¡Ñan ni se känäntarita nitre ji dokwätekwe müre ketadre yera, ");
INSERT INTO gymNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","amarebti tuen dirire ni jökrä ngwärekri sete se, akwa nitre ji dokwäte ñan nebe ñäke jire chi ie! ¿Ni se abko Ni Dianinkä Ngöbökwe ara juani Ngöbökwe abko nibira era nitre ji dokwätekrä ya ño amarebti ñan nebe ñäke ie se? ");
INSERT INTO gymNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ni se jatani mdenkri garera nie, akwa Ni Dianinkä Ngöbökwe jatadi angwane, jatadi mdenkri ñan rabadi gare nie, aisete ni se abko ñakare Ni Dianinkä Ngöbökwe ruen nunye, rababa niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesu näma dirire ju blitakrä Ngöböbe käntita angwane, nitre kukwei jaraba kore ie angwane, Jesukwe ñäkäba ja dibti, käkwe nieba: Ti gare kuin munye bkänä amne, ti jatani mdenkri, ye gare kuin jökrä munye, munta nütüre ñan ñan. Akwa ñan ti jatani ja töi jenbti amne Ngöbökwe ti juani era metre. Niara gare ñakare munye, ");
INSERT INTO gymNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","akwa ti abko jatani niarakri amne ti juani kwe, aisete niara gare tie. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yebtä ni ruäre tö rababa Jesu kain ngite, akwa niara müre ketadre abko käi ngämi nüke, aisete nitre ye käkwe ñan kise mikaba jire chi btä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Akwa ye ngwane abko, ni kwati käkwe tödekaba Jesubti abko rababa niere: Ni Dianinkä Ngöbökwe rükadre angwane, sribi kri ñan tuabare abko ñan nuendi bäri kuin kwe ni se ngwä, raba ruen nunye, rababa niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nitre tödekaka Jesubti rababa blite tiebe kore, ye kukwei jarabare nitre bariseoye. Abtä nitre bariseo btä nitre blitaka Ngöböbe ni mda mda diäre dänkientre käkwe guardia ju blitakrä Ngöböbe ngibiabtikä juanba Jesu kaen ngite. ");
INSERT INTO gymNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Angwane Jesukwe nieba mda: Tikwe nünandi bä jötrö mda mun ngätäite nete. Yebti ni ti juanka, känti ti näinta. ");
INSERT INTO gymNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Angwane mun rabadi ti känentari kisere, akwa ti ñan kwandretari munye, ñobtä ñan angwane ti tädi, ye känti mun ñan rabadre, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yebtä abko, nitre israelita ji dokwäte rababa niere jae kwärikwäri: ¿Ni se abko näin mdente amarebti ñan kwandretari nie, tä niere se? ¿Nitre israelita tä nüne juta jenenante kwäräkwärä nitre ñakare israelitare ngätäite, känti näin ya ño ruen? o ¿Nitre ñakare israelitare, ie näin dirire ya? Dre nuendi metre kwe ruen ");
INSERT INTO gymNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","amarebti nini krörö kwe nie: Mun rabadi ti känentari kisere, akwa ti ñan kwandretari munye, ñobtä ñan angwane ti tädi, ye känti mun ñan rabadre niken, nini kwe nie, ¿se abko dre nini kore kwe se? rababa niere Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Yebti bieta Ju Bä köböi mrä abko köbö bäri ütiäte, ye näire Jesu rababa nünaninkä krö ju blitakrä Ngöböbe käntita angwane, ñäkäba jume ja dibti kwe, käkwe nieba mda: Mun mden ie tomna nibi angwane, mun jakwe tomna ñaen tie amne, ");
INSERT INTO gymNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","nire nire käkwe tödekadre tibti abko btä ñö nire rabadi neen käre, nieta Ngöbö Kukweibtä ye kwrere, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesukwe blitaba kore angwane abko Ngöbö Üai bä mikaba ñö nire kwrere kwe. Akwa blitaba kwe angwane, Ngöbö Üai ngämi nüke nitre tödekaka Jesubti yebtä, ñobtä ñan angwane Jesu ngämi nikenta kä käinbti, känti Ngöbökwe Jesu mikani ütiäte kri. (Akwa Ngöbökwe Jesu mikani ütiäte kri, yebti abko Jesukwe Ngöbö Üai juani nüne nitre ja töitikaka Jesubti yebtä.) ");
INSERT INTO gymNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesukwe blitaba ye abko nitre näma yete, ye ngätäite ni ruäre käkwe Jesu kukwei nuaba angwane, rababa niere: Ni Ngöbö kukwei niekä rükadre niebare Moisékwe ara tä nete ñan ñan, rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Akwa ni mda mda abko rababa niere: Era metre Ni Dianinkä Ngöbökwe ara noko, rababa niere. Akwa ni mda abko rababa niere: Ni noko abko Galileabo, aisete niara abko ñan Ni Dianinkä Ngöbökwe, ñobtä ñan angwane Ni Dianinkä Ngöbökwe abko ñan jatadre nitre Galileabokri. ");
INSERT INTO gymNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ye abko, Ni Dianinkä Ngöbökwe jatadi jrei David tukwe mräkäkri amne David abko därebare juta Belénte, ye arabe känti Ni Dianinkä Ngöbökwe jatadi arato abko nieta kore Ngöbö Kukweibtä, nieba ni ruärekwe. ");
INSERT INTO gymNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Yebtä abko ni jökrä töi rababa bä jene jene Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ni ruäre abko tö rababa rikai Jesu ngwena ngite, akwa nuenba ñakare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ye mden kisete, guardiatre juani Jesu kaen ngite, ye rikabata kise tökare nebeta bariseotre ye känti amne nitre blitaka Ngöböbe ni mda mda diäre dänkientre ye känti angwane, niaratre käkwe niebare guardiatre yeye: Nunkwe ni kamna ngite, ¿ye ñobtä mun ñan ki ngwena? nieba kore kwetre guardiaye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abtä guardiatre käkwe niebare mda ietre: ¡Ni blite nuäre nuäre ni ye kwrere nunkwe ñan tuabare jire abko erere ni ye tä blite! Abtä nun ñan ki ngwena, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Angwane nitre bariseo ye käkwe niebare mda guardiatreye: ¿Munkwe ja ngökamna kwäräbe ie arato ñan ñan? niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Nitre blitaka Ngöböbe ni mda mda diäre dänkientre amne nitre bariseo tärä iti käta tödeke ni yebti mun okwäbti ya? ¡Ñakare jire! ");
INSERT INTO gymNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Nitre se käta niara mike ütiäte, ie Kukwe Biani Ngöbökwe Moiséye gare ñakare jire chi ye abko btä Ngöböta ngürün mike, ye namanintre niere guardiatreye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Abtä bati ni bariseo kädian nämane Nicodemo jananbare blite deo Jesube ye käkwe nieba: ");
INSERT INTO gymNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Kukweta ükaninte ni ngätäite käta niere krörö: Ni iti käkwe dre nuenbare abtä kitadre ngite, ye niara ngämi blite au jakrä, ni ñan raba kite ngite abko tä ükaninte kore, nieba Nicodemokwe. ");
INSERT INTO gymNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Abtä niaratre käkwe nieba romone Nicodemoye mda: ¿Ma abko ni ngututu käme Galileabo arato ya? Ngöbö Kukwei käta dre niere, yebtä makwe ja töitika angwane, ni Galileabo ñakare jire iti Ngöbö kukwei niekä abko rükadi gare mae, nieba kwetre Nicodemoye. ");
INSERT INTO gymNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Yebti ni jökrä rikabata ja gwiriete. ");
INSERT INTO gymNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Akwa Jesu abko rikaba Ngitio Olibobti. ");
INSERT INTO gymNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Yebti jändrinane dekä angwane, ju blitakrä Ngöböbe ye käntita Jesu rikabata angwane, ni kwati jataba nüke niara ken kukwei nuakäre angwane, niara rababa täkänintbe temen, kä rikaba dirire ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ye btäräbe Kukwe Biani Ngöbökwe Moiséye dirikätre amne nitre bariseo rükaba meri ngwena iti Jesu känti. Meri ye abko nämane ja mike gure kaibe gore abko kwani ietre abko rükaba ngwena. Meri ye abko mikaba nünaninkä kwetre ni jökrä ngwärekri Jesu känti. ");
INSERT INTO gymNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Angwane nieba kwetre ie: Dirikä, meri ne tä ja mike gure kaibe gore akwa, kuni jabtä nunye abko nun ki ngwena mae nete. ");
INSERT INTO gymNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kukwe Biani Ngöbökwe Moiséye, yebtä Moisékwe meri ne kwrere kämikamna jäbti. ¿Akwa ma abko käta dre niere meri kore btä? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Niaratre abko rababa kukwe ngwentari kore ie ja gakäre ben, ñobtä ñan angwane Jesukwe ñäkädre blo, yebtä abko kukwe käme kwandre ietre kitakrä ngise abkokäre. Akwa Jesu abko rababa nünaninkä krö, bti rababa täkänintbe ngürebti, kä rikaba tärä tike kisebti dobrobtä temen. ");
INSERT INTO gymNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Akwa nitre ye rababa kukwe ngwentari janknu Jesuye meri yebtä. Abtä Jesukwe niaratre mikaba ñäräre ja käne, käkwe nieba ietre: Mun mden mden ja mike ngite ñakare jire chi Ngöbö rüere abko käkwe meri ye täkä käne jäbti, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yebti Jesu rababata täkänintbe ngürebti, rikaba tärä tiketa dobrobtä temen nitre ye okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Akwa Jesukwe ñäkäba kore ietre, yebtä abko niaratre rikaba kä mikekä itire itire ja täritäri, akwa nitre bäri unbre unbre ara jire käkwe kä mikakaba käne, bti ni bäri bati bati rikabata mento mrä. Jesu abko rababa kaibe meri yebe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Niara naninkrö krö, bti meri ye mikaba ñäräre ja käne kwe, käkwe nieba ie: ¿Nitre ma kitaka ngise abko ame jökrä nete? ¿Ni ñakare jire iti käkwe ma kiti ngite ñan ñan? nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Angwane meri ye käkwe nieba mda ie: Ni ñakare jire iti käkwe ti kiti ngite se abko, nieba kwe Jesuye. Angwane Jesukwe nieba mda ie: Tikwe ñan ma kitadre ngite arato, aisete nänta. Akwa mtare mentokwäre makwe ñan ja mika ngite janknu mda. Abko kore se, nieba kwe meri yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yebti Jesukwe nieba mda ni kwati näma yete yeye: Ti abko ñotra ni jökrä kräke. Nire nire jatadre ti jiebti abko kwe ñotra trä rabadi die mikakäre amne ñan nünandi jire chi mda kä ikote kwe, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yebtä abko, nitre bariseo käkwe nieba mda Jesuye: Mata nete käta blite au jakrä, aisete ma kukwei ye abko tuen ñakare metre, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Abtä Jesukwe nieba mda ietre: Tita blite au jakrä akwa, ti abko kukwei ütiäte amne metre, ñobtä ñan angwane ti mdente jatani, ye gare kuin tie. Erere arato, ti näinta mdente gare kuin tie, akwa mun abko ie gare ñakare jire chi. ");
INSERT INTO gymNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nitre kä nebtä tä kukwe ükete ño ni kitakäre ngite, ye kwrere munta kukwe ükete tikrä, akwa ti abko tä kukwe ükete ñakare ni kitakäre ngite. ");
INSERT INTO gymNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Akwa nane tikwe kukwe ükarete ni kitakäre ngite, ye ngwane tikwe kukwe ükadrete era metre, ñobtä ñan angwane ñan tita kukwe ükete kaibe ja töi jenbti, akwa ti Rün käkwe ti juani abko käta kukwe ükete ti ben gwaire, aisete tita kukwe ükete kuin metre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Angwane Kukwe Biani Ngöbökwe Moiséye mun kräke, btä nieta krörö: Ni nibu käkwe blitadre ja kwrere ni kitani ngise rüere, ye ngwane niaratre nibu kukwei rabadre ütiäte abko nieta. ");
INSERT INTO gymNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ye abko tä dbe, aisete ti ara jire tä blite au jakrä amne ti Rün käkwe ti juani abko tä blite tikrä arato, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Abtä nitre bariseo käkwe nieba mda Jesuye: ¿Ma rün abko tä mdente? nieba kwetre ie. Angwane Jesukwe nieba mda ietre: Ti abko nire gare ñakare metre munye amne ti Rün gare ñakare munye arato. Ti abko nire rükadre gare munye angwane, ti Rün rükadre gare munye arato. Abko kore se, nieba kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesukwe ñäkäba kore angwane abko näma dirire ju blitakrä Ngöböbe ye bäre. Jesu näma dirire, ye käntita abko kaja näma abko te ngwian kita nämane Ngöbökrä, känti Jesu näma, käkwe kukwe diriba kore. Akwa Ngöbökwe kä kitani angwane Jesu müre ketadre, ye ngämi nüke ie, aisete ñan kaba ngite kwetre müre ketakäre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Bti Jesukwe niebata mda ietre: Ti bike nikenta amne mun abko rabadi ti känentari kisere, akwa mun ngite ye ben gwaire mun krütadre jökrä. Ti näin mdente, ye känti mun ñan raba neme jire ti känti, nieba kwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Angwane nitre israelita ji dokwäte rababa niere jae kwärikwäri: ¿Niara tö kite ja müre ketai au ya ño amarebti, ti bike niken ye känti mun ñan raba, nini kwe ye? rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Angwane Jesukwe nieba mda ietre: Mun abko tä nüne kä temen nebtä, akwa ti abko kä käinbti sete jatani; mun abko tä nüne Ngöbö rüere, akwa ti abko rüre ñakare Ngöbö rüere. ");
INSERT INTO gymNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ye mden kisete, kukwe kämekäme munta nuene Ngöbö rüere, yebtä mun krütadi. Ti abko ni ño tita niere munye, ye munkwe ñan mikadre era jae angwane, mun krütadi angwane, mun rabadi ngite Ngöböye kärekäre, tikwe nini munye ye kwrere, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Angwane niaratre käkwe nieba mda ie: ¿Ma abko nire? nieba kwetre Jesuye. Jesukwe nieba mda ietre: Ti jataba nüke angwane, ti abko nire tikwe nieba käne munye abti kä nüke mtare. ");
INSERT INTO gymNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ye abko, kukwe tärä kabre abko tikwe kädriedre munbe. Erere arato, kukwe tärä kabre abko tikwe ükarete munkrä, akwa ni ti juanka käta kukwe era erere niere abko tita kukwe nuen, ye erere tita niere nitre nünanka Ngöbö rüere ie, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Akwa Jesukwe blitaba ni niara juanka yebtä angwane abko näma blite Rün kwebtä abko ñan rükaba gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Abtä Jesukwe nieba mda ietre: Munkwe Ni Kä Nebtä Ngobo ne kadikä krusobtä käin angwane, ti abko ni ño tita niere munye, ye abko rükadi gare tibtä munye. Erere arato, tita jändrän nuene ñakare ja töi jenbti, akwa ti Rün käkwe dre diribare tie, ye erere tita nuene abko rükadi gare tibtä munye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ni ti juanka ye abko tä tibe amne ti Rün tä ti mikete ñakare kaibe, ñobtä ñan angwane dre tuen kuin ie abko erere tita nuene, kä mikakäre nuäre btä, aisete ñan tä ti mikete kaibe. Abko kore se, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesukwe blitaba kore angwane, ni kwati käkwe tödekaba bti. ");
INSERT INTO gymNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yebti nitre israelita käkwe tödekaba Jesubti, ye ie Jesukwe nieba mda: Munkwe nünandikä kärekäre ti kukweibtä ne ngwane, mun rabadi ja töitikaka era metre tibe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ye ngwane, kukwe era metre Ngöböbtä rükadi gare munye amne kukwe era yebti mun rabadi tikaninte, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Abtä nieba mda kwetre Jesuye: Nun därebare Abraham mräkäkri amne ni mda mda nebe ñakare nun dänkiene. ¿Se ñobtä abko mun rabadreta tikaninte, mata niere se? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesukwe nieba mda ietre: Ti bike kukwe era erere niere munye: Nire nire käta kukwe kämekäme nuene Ngöbö rüere, ni ye abko kukwe kämekäme tä bkäne amne dänkiene, aisete niara abko ni klabore kwrere kukwe kämekäme kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ye abko, ni klabore ye ñan raba nüne kärekäre gwi bkänkä mräkäbe, ñobtä ñan angwane bkänkä raba rürümoine ni mdaye. Akwa ni klabore bkänkä, ye ngäbriänkä aibe käkwe nünandre kärekäre gwi rünbe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ne aisete Ngöbö Odei käkwe mun tikadrete ne ngwane, mun rabadi tikaninte era metre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mun därebare Abraham mräkäkri, ye garera tie, akwa mun tö ti müre ketai, ñobtä ñan angwane tita kukwe niere, ye mun ñan tö kain ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Tikwe dre dre tuaba ja okwä jenbti ti Rün känti, ye erere btä tita blite. Ye kwrere arato, munkwe mun rün kukwei nuani blite ño, ye erere munta nuene arato, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Abtä nieba mda kwetre Jesuye: ¡Nun rün kira abko Abraham abko mräkäkri nun därebare! nieba kwetre Jesuye. Akwa Jesu abko käkwe nieba mda ietre: Mun däredre Abraham mräkäkri bkänä akräke niarakwe nünabare ño, ye erere munkwe nünandre arato. ");
INSERT INTO gymNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Akwa ye kwrere ñakare, aisete kukwe diribare tie Ngöbökwe abko erere tita niere era metre munye. Abtä mun tö ti müre ketai. Akwa Abraham abko rabadre nüne mtare angwane, niarakwe ñan kukwe kore nuendre jire chi abko erere mun tö nuein tibtä. ");
INSERT INTO gymNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ye abko, mun rün tä dre nuene, ye erere munta nuene arato, nieba Jesukwe ietre. Abtä nieba kwetre Jesuye: Ni ja mikaka gure bati bati abko kwe nun därebare ñakare amne nun rün abko era metre. Nun rün abko itibe abko Ngöbö, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Angwane Jesukwe nieba mda ietre: Ngöbö mun Rün era metre bkänä akräke ti rabadre tare munkwe, ñobtä ñan angwane ti jatani Ngöbökri amne tita mun ngätäite nete. Ye ñan ti jatani ja töi jenbti akwa, Ngöbökwe ti juani abkokänti tita nete. ");
INSERT INTO gymNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Akwa mun abko ñan tö ti kukwei kain ngäbti, aisete tita blite abko ñan tä nüke gare munye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ye abko, mun rün era metre munkwe abko diablu amne niara tä mun bkäne, aisete mun abko niara kwrere amne niara töta nebe dreye, ye erere mun tö nuein. Kena abti kä nüke mtare, diablu abko ni kämikaka amne niara ñan tä kukwe era metre niere jire chi bati. Tä blite angwane, kukwe era nieta ñakare jire kwe, angwane tä blite nierare, ñobtä ñan angwane niara abko ni ngökaka amne käne kira niarakwe kukwe niebare ngwarbe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mun abko mun rün diablu kwrere käta kukwe ngwarbe tarere, aisete ti abko käta kukwe era erere niere munye angwane, mun ñan tö ti kukwei mikai era. ");
INSERT INTO gymNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ti kukwe käme nuene ñakare Ngöbö rüere, aisete ni ñakare jire mun ngätäite nete kä raba ti kite ngise kukwe kämenbtä, aisete tita kukwe era erere niere munye, ¿se ñobtä abko mun ñan tö ti kukwei mikai era? ");
INSERT INTO gymNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Akwa nire nire era metre Ngöbökwe abko tä Ngöbö kukwei kaen ngäbti, akwa mun abko ñakare era metre Ngöbökwe, aisete mun ñan tö ti kukwei kain ngäbti. Abko kore se, nieba Jesukwe nitre israelitaye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yebtä abko nitre israelita käkwe nieba mda Jesuye: Ma abko ni ngututu Samariabo amne üai käme tä mabtä, nunta niere ye abko era bkänä ñan ñan, nieba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Abtä Jesukwe nieba mda ietre: Üai käme ñakare jire tibtä, akwa tita ti Rün mike ütiäte jae amne mun abko käta ti mike ngwarbe jae. ");
INSERT INTO gymNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ñan munkwe ti mikadre ütiäte abko känänta au tikwe jakrä, akwa ni tärä iti abko tä ti mike ütiäte amne niara abko kukwe ükatekä ni jökrä kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ti bike kukwe era erere niere munye: Nire nire käkwe ti kukwei mikadre täte abko ñan krütadi, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Angwane nitre israelita ji dokwäte käkwe nieba mda ie: Mtare üai käme tä mabtä nunta niere, ye abko era nüra gare metre nunye mabtä, ñobtä ñan angwane Abraham amne nitre Ngöbö kukwei niekä kirakira krütani jökrä amarebti nire nire käkwe ti kukwe mikadre täte abko ñan krütadi, mata niere ye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Ma abko bäri ütiäte nun mräkä Abrahamkrä ya? Ñakare jire raba ruen nunye, ñobtä ñan angwane Abraham krütani amne nitre Ngöbö kukwei niekä kirakira krütani jökrä. ¿Ma abko nire amarebti ja nibi ruen bäri mae niaratrekrä ye? nieba romone kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu käkwe nieba mda ietre: Tikwe bikadre kri ja mikakäre ütiäte au, ye ngwane tikwe ja mikadre ütiäte ngwarbe, akwa ti Rün ara käta ti mike ütiäte. Ti Rün ye mden abko Ngöbö munkwe munta niere, akwa mikata ñakare ütiäte munkwe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ngöbö ye abko gare ñakare munye, akwa ti abko ie niara gare kuin. Ne aisete niara gare ñakare tie, tikwe niedre, ye ngwane ti rabadre ni ngökaka mun kwrere arato, akwa niara gare kuin tie bkänä amne tita niara kukwei mike täte. ");
INSERT INTO gymNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ti köböi mikani ye abko mun mräkä käne Abraham tö namani tuai, aisete namani töbike ti köböibtä angwane, kä namani juto btä. Yebti ti rükadre köbö ño te abko Abrahamkwe tuani angwane, kä namani nuäre krübäte btä, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yebtä abko, nitre israelita käkwe nieba mda Jesuye: ¡Jo! Nin kä ngämi gre ketebu bti kwä jätä mae. ¿Ma ye abko käkwe Abraham tuani mata niere ya? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Angwane Jesukwe nieba mda ietre: Kukwe era erere ti bike niere munye: Abraham ngämi därere, ye känenkri ti nämanena nüne. Abko kore se, nieba kwe nitre israelita ji dokwäteye. ");
INSERT INTO gymNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Abtä nitre israelita ye käkwe jä dianba kisete Jesu kämikakäre, akwa nitre nämane yete, ye ngätäite Jesukwe ja rükanteba, bti ju blitakrä Ngöböbe bäre Jesu näma, ye känti Jesukwe kä mikakaba tiebe amne rikabata mentokwäre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Abti bati Jesu rikaba ji ngrabare angwane, ni näma iti jite btä Jesu okwä rababa. Ni ye abko okwä kä drünente. Niara abko därebare kore, aisete kä tuen ñakare ie abko näma jite. ");
INSERT INTO gymNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Abtä nun ja töitikaka Jesube käkwe nieba ie: ¿Dirikä, ñobtä ni se därebare okwä kä drünente kore? ¿Niara meye amne rün käkwe ja mikani ngite Ngöbö rüere ya? o ¿Niara ara jire käkwe ja mikani ngite au Ngöbö rüere abtä därebare kore ya? nieba nunkwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Angwane Jesukwe nieba mda nunye: Ñan niara meye amne rün käkwe ja mikani ngite Ngöbö rüere, abtä därebare kore. Erere arato, ñan niarakwe ja mikani ngite abtä därebare kore. Akwa Ngöbö diebti sribi kri ñan tuabare rabadre bare, abkokäre niara därebare kore. ");
INSERT INTO gymNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","5","Tita kä nebtä mun ngätäite nete angwane, ti abko ñotra ni jökrä kräke, aisete tita mun ngätäite nete angwane, ni ti juanka ye kräke nikwe sribidre kä trä ngwenbti, ñobtä ñan angwane ti järikadi munkän angwane, kä jatadi kä iko kwrere, ye näire ni ñan rabadre sribire jire chi mda, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesukwe blitaba kore, yebti tö rababa kukwe ye bä mikai, käkwe ni ye mikaba kuinta krörö: käli kitaba temen kwe, mritaba dobrobe kwe, bti dobro ye jüanteba ni ye okwäbtä kwe, ");
INSERT INTO gymNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","bti nieba kwe ie: Ñö okwä Siloé, ye te nän ja okwä bätete, nieba kwe ie. (Siloé ye abko “juani” nieta kukwe hebreore.) Ye erere ni ie kä tuen ñakare ye rikaba, käkwe ja okwä bätäninte, bti nikaninta ja gwiriete angwane, kä namaninta tuenta ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Abtä nitre nünanka känimekänime niara kenta temen amne nitre kä nämane niara tuen ngwian kärere käre, ye namani niere jae kwärikwäri: ¿Ni noko nämane nebe täkänintbe jite ngwian kärere yera? rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Angwane ni ruäre namanintre niere: Niara ara se, namanintre niere. Akwa ni mda mda abko namani niere: Ñakare, akwa ni mda bäsi niara bä kwrere se, namanintre niere. Akwa ni ye ara jire käkwe niebare: Ti ne ara nämane ngwian kärere jite ye, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Angwane ni mda mda käkwe niebare ie: ¿Ño köböire kä nena tuen mae mtare? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Niara käkwe niebare mda: Ni kädekata Jesu ye käkwe dobro mriti, bti jününte ti okwäbtä kwe amne nini krörö kwe tie: Ñö okwä Siloé, ye känti nän amne makwe ja okwä bätäte, nini kwe tie. Ye erere ti niki, käkwe ja okwä bätrite angwane, kä nibibe tuen tie, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Angwane ni bariseo mda mda ye käkwe niebare mda ie: ¿Ni kädekata makwe ye abko tä mdente? niebare kwetre ie. Niara käkwe niebare mda: Niara tä mdente gare ñakare tie, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesukwe dobro mritaba kälibe, bti ni okwä kä drüente ye okwäbtä jüanteba kwe angwane, kä rababa tuenta ie, ye abko Jesukwe nuenba köbö jadükakrä näire. Yebtä abko ni okwä kä drünente Jesukwe mikabata kuinta ye järikaba mda nitre bariseo ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Angwane ño köböire namaninta kuinta niebare kwetre ie. Niara käkwe niebare ietre: Dobro mriti kwe, jününte ti okwäbtä kwe, bti tikwe ja okwä bätrite amne mtare kä nibi tuen tie, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Abtä nitre bariseo ruäre namani niere: Ni sribi ye nuenkä abko ñan jatani Ngöbökri, ñobtä ñan angwane tä köbö jadükakrä mike ütiäte ñakare jae, namani niere. Akwa bariseo ruäre abko namani niere: ¡Ni ngite Ngöbö rüere ñan rabadre sribi kri ñan tuabare nuene ni noko kwrere! namanintre niere. Yebtä abko namanintre ja kwete kwärikwäri Jesubtä. ");
INSERT INTO gymNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Bti ni okwä kä ikote ie kä namani tuen, ye ie niebareta mda kwetre: ¿Ni käkwe kä mikani tuenta mae, ni ye abko ni ño nieta makwe? niebare kwetre ie. Niara käkwe niebare mda: Niara abko ni Ngöbö kukwei niekä tita niere, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Akwa ni ye abko därebare amne okwä kä drünente, aisete kä tuen ñakare ie, akwa okwä namaninta kuinta, aisete kä namani tuen ie, ye abko nitre israelita ji dokwäte ñan tö namani mikai era, abtä ni okwä kä drünente ye meye btä rün käräbare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ni ye meye btä rün nükani angwane, niebare kwetre ietre: ¿Ni ne abko, mun ngobo munkwe bkänä ya? ¿Erere arato, därebare angwane, kä tuen ñakare ie bkänä, munta niere ya? Ño köböire kä tuen ie mtare, ye niere nunye, niebare kwetre ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Angwane ni ye meye amne rün käkwe niebare mda: Niara abko nun ngobo nunkwe bkänä. Erere arato, därebare angwane, kä tuen ñakare ie bkänä, ");
INSERT INTO gymNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","akwa ño köböire kä tuen ie mtare, ye abko gare ñakare nunye. Erere arato, nirekwe kä mikani tuenta ie, ye gare ñakare nunye, aisete munkwe ngwiantari niaraye. Niara abko nena ünän, aisete dre dre nakaninkä btä, ye niarakwe niedre au jakrä munye, niebare kwetre nitre israelita ji dokwäteye. ");
INSERT INTO gymNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ni ie kä tuen ñakare ye meye amne rün, btä nitre israelita ji dokwäte jürä namani, aisete nieba kore kwetre, ñobtä ñan angwane Jesu abko Ni Dianinkä Ngöbökwe, ye nirekwe niedre, ni ye abko kitadrekä sinagoga bäre mento abko nitre israelita ji dokwäte käkwe ükaninte kore, ye abko jürä namani ni ye meyebtä amne rünbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ne aisete niara meye amne rün käkwe niebare: Niara nena ünän, aisete kukwe nakaninkä ño ño btä, ye munkwe ngwiantari ie amne niarakwe niedi au munye, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Angwane ni okwä nämane kä ikote käne, ye nitre israelita ji dokwäte käkwe käräbareta bobuta, bti niebare kwetre ie: Ngöbö okwäbti kukwe era erere niere nunye, ñobtä ñan angwane Jesu ye abko ni ngututu kukwe kämekäme nuenkä Ngöbö rüere, ye gare kuin nunye, niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ni ye käkwe niebare mda: Niara abko ni kukwe kämekäme nuenkä ya abko gare ñakare tie, akwa ti okwä nämane kä ikote amne niara köböire kä tuen kuin tie mtare. Ye aibe gare tie, niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Abtä nitre israelita ji dokwäte käkwe niebare mda ie: ¿Dre nuenbare kwe mabtä? ¿Ño köböire kä mikani tuen kwe mae? niebare kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Abtä niarakwe niebare: Kukwe gare tie, erere tikwe ninina jökrä munye, akwa munkwe ñan ti kukwei miri era. ¿Se drekäre tikwe kukwe arabe niedreta bobuta munye, ie mun tö nibi ye? ¿Mun tö nibi ja getai arato Jesube ya amarebti mun nibi kukwe ngwentari janknu kore tie ye? niebare kwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Angwane nitre israelita ji dokwäte rikaba ngren ngren ni yebti, käkwe niebare ie: Ma abra ja getaka Jesu yebe, akwa nun abko tä nekete Moisékri. ");
INSERT INTO gymNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ngöbökwe blitabare Moisébe, ye gare kuin nunye, aisete nunta nekete niarakri. Akwa Jesu ye abko jatani mdenkri abko gare ñakare jire chi nunye, niebare kwetre ni yeye. ");
INSERT INTO gymNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Abtä ni ye käkwe niebare mda ietre: ¡Rä jire niara jatani mdenkri gare ñakare munye, yebtä ti töi ñan nebe krütare mda! Akwa ti abko okwä mirita kuinta kwe amne kä nibi tuen tie, ");
INSERT INTO gymNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","aisete ni kukwe kämekäme nuenkä Ngöbö rüere käta ja di kärere Ngöböye sribi kri ñan tuabare nuenkäre abko ie Ngöböta ja di bien ñakare, ye gare kuin nie. Akwa nire nire tä Ngöbö mike ütiäte amne tä Ngöbö Kukwei mike täte aibe die mikata Ngöbökwe sribi kri ñan tuabare nuenkäre, ye abko garera nie arato. ");
INSERT INTO gymNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Erere arato, ni därebare okwä kä drünente ti kwrere abko ni mdara jire käta kä mike tuen ie, ye abko ni ngämi kukwe nuen jire chi. ");
INSERT INTO gymNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ne aisete, Jesu ñan jatadre Ngöbökri, akräke sribi ütiäte kri ñan tuabare ye kwrere ñan rabadre bare jire chi ie Ngöbö diebti, niebare kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Abtä nitre israelita ji dokwäte käkwe niebare mda ie: Kukwe kämekäme kri krübäte Ngöbö rüere mabtä, aisete ma därebare abti kä nüke mtare ma ngite kri Ngöbö rüere. ¿Ma ye abko tö kite dirire nunye mtare ñan ñan? niebare kwetre ie. Bti ni ye juantariba künken kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yebti ni ie kä mikani tuenta Jesukwe, ye kitani künken sinagoga bäre mento gaba Jesukwe. Yebti Jesu rababa ngätäi ben angwane, Jesukwe nieba ie: ¿Ni Kä Nebtä Ngobo bti mata tödeke ya? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Angwane niarakwe nieba mda: Ti Dänkien, nire abko Ni Kä Nebtä Ngobo makwe niedre tie angwane, tikwe tödekadi bti, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesukwe nieba mda ie: Ti ara tuata makwe, ti ne mden ben mata blite, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ye btäräbe ni ye rababa ngukudokwäbti Jesu ngwärekri, Jesu mikakäre ütiäte, käkwe nieba: Tita tödeke mabti ti Dänkien, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yebti Jesukwe nieba mda: Ti jatani kä nebtä kukwe rabadre ükaninte ni jökrä kräke amne, ni ie kukwe metre Ngöbökwe gare ñakare amne ni ie kä tuen ñakare ye kwrere abko ie kä rabadre tuen angwane, kukwe metre Ngöbökwe rabadre gare ie, abkokäre ti jatani. Erere arato, nire nire ie kä tuen kuin tä nütüre, aisete kukwe metre Ngöbökwe garera ie tä nütüre, ni ye abko tä ja ngökö au abko ie kä ñan rabadre tuen, abkokäre ti jatani, nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yebtä abko nitre bariseo näma ruäre Jesube yete käkwe nieba ie: ¿Kukwe metre Ngöböbtä gare ñakare nunye arato, aisete nun okwä kä drünente amne kä tuen ñakare nunye abko mata niere nunye ya? nieba kwetre mda Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Angwane Jesukwe nieba mda ietre: Mun okwä tädre kä drünente angwane, kä ñan rabadre tuen munye, akräke kukwe käme Ngöbö rüere, ye munkwe nuendre ñakare amne mun ñan rabadre ngite Ngöböye; akwa kukwe metre Ngöbökwe garera kuin munye, aisete kä tuen kuin munye munta niere au jabtä, aisete mun ngite janknu Ngöbö rüere. Abko kore se, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","3","Yebti Jesukwe nieba mda: Ti bike kukwe era erere niere munye. Ni obeja ngibiaka era metre abko käre tä ni mda mikete jukwebtä obeja ngibiare deo jakrä. Ye mden kisete, obeja ngibiaka ye tä nüke angwane, ni jukwe ngibiaka tä jukwe tike ie angwane, obeja ngibiaka ye tä niken obeja kä deke kratirekratire ja täritäri. Niara kukwei gare obejaye, aisete obeja kwe tä niken jiebti amne tä niken ngwena ki bäre mento mikä känene. Akwa ni obeja ngibiaka ñakare era metre abko tä nakwen kibti ta, ñobtä ñan angwane niara abko gokä, aisete tä kite tiebe kibti ta. Akwa ni obeja ngibiaka era metre bkänä abko tä nüke jukwebtä obeja kwe kärere. ");
INSERT INTO gymNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yebti obeja kwe tärä niken jökrä ki bäre mento angwane, niara tä niken käne amne obeja tä niken jiebti, ñobtä ñan angwane niara abko kukwei gare kuin obeja kweye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Akwa ni gare ñakare obejaye abko ngäniene obeja tä ngitie jirekäbe amne ñan tä niken jiebti, ñobtä ñan angwane niara abko kukwei gare ñakare obejaye, aisete obeja tä ngitie, nieba Jesukwe nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesukwe blitaba kore jabtä, käkwe nitre bariseo bä mikaba ni gokä kwrere, ye abko dre bä mikaba kore kwe ñan rükaba gare nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Angwane Jesukwe niebata mda: Ti bike kukwe era erere niereta mda munye abko krörö: Ti abko jukwe kwrere abko känti obeja jatadre. ");
INSERT INTO gymNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ni jökrä nükani ti känenkri ja Ni Dianinkä Ngöbökwe niere abko nitre ni ngökaka amne gokä, akwa obeja era metre tikwe abko käkwe kukwei nuani ñakare. ");
INSERT INTO gymNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ti abko jukwe kwrere, aisete nire nire rükadre ti köböire ki teri Ngöbö känti, ye abko rabadi dianintari. Ne aisete, obeja tä niken ki teri, bti tä nikenta ki bäre mento amne mikä kuin tä kwen kwetadre ietre, ye kwrere nire nire rikadre ti köböire Ngöbö känti abko ie jändrän kuin kwandre. ");
INSERT INTO gymNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Akwa ni gokä tä kite gore, ni kämike amne jändrän jökrä juankäre ngwarbe nikän; akwa ti abko jatani ni mikakäreta nire Ngöböbe amne ni rabadre nüne bäri kuin kärekäre, abkokäre ti jatani. ");
INSERT INTO gymNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Mdakäre abko, ti abko ni obeja ngibiaka kuin kwrere. Ni obeja ngibiaka kuin abko tä biare ngataen obeja kräke, obeja diantarikäre. ");
INSERT INTO gymNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Akwa ni ngwian ganainkä jae obeja ngibiabtä abko lobo tä kite tuen ie obeja kukwäre angwane, tä ngitie lobo ngäniene amne tä obeja mikete kaibe, ñobtä ñan angwane niara abko ñakare obeja ngibiaka amne obeja ye ñakare kwe, aisete tä mikete loboye amne lobo tä niken obeja kwete amne tä obeja juentari kratikrati kwäräkwärä. ");
INSERT INTO gymNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ni ngwian ganainkä obeja ngibiabtä ye abko tä ngitie lobo ngäniene amne tä obeja mikete kaibe, ñobtä ñan angwane niara töita ja kwata ngibiabtä, akwa obeja ngibiadre ye abko ütiäte ñakare kräke, aisete tä ngitie kore. ");
INSERT INTO gymNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Mdakäre abko, ti ni obeja ngibiaka kuin kwrere, ñobtä ñan angwane ti gare kuin ti Rünye amne ti Rün gare kuin tie, ye kwrere obeja tikwetikwe erere gare kuin tie amne ti gare kuin ietre arato. Ti abko obeja ngibiaka kuin kwrere, aisete ti gatadi obeja tikwe kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mdakäre abko, nitre ñakare israelitare ngätäite obeja mda mda tärä tikwe, akwa tä ñakare ki kwatibe teri obeja tikwe tikwe nitre israelita ngätäite ben gwaire. Akwa ti jatadre obeja ye ngwena arato mikakäre ki teri obeja nitre israelita ben gwaire, amne obeja ye käkwe ti kukwei nuadre amne ti kukwei mikadre täte kwetre angwane, rabadre nüne ki kwatibe teri jökrä amne niaratre ngibiaka rabadi itibe arato abko ti ara. ");
INSERT INTO gymNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ti abko bike ja kwata bien müre ketadre, ti rabadita nire bobukäre abkokäre, aisete ti Rün tikwe käta ti tarere. ");
INSERT INTO gymNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tikwe ñan ja biandre müre ketadre, ye ngwane ni ñakare jire iti käkwe ti müre ketadre ja töi jenbti. Ti ara jire käta ja bien müre ketadre au, aisete ti müre ketai, akwa ti abko di tärä ja bien müre ketadre amne ti di tärä ja mikakäre nünenta, ye abko ti Rün käkwe nuemna tie, erere tita nuene. Abko kore se, nieba Jesukwe nitre israelitaye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesukwe blitaba kore, ye kukwei nuaba nitre israelitakwe angwane, niaratre töi rababa bä jene jene jökrä. ");
INSERT INTO gymNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ne aisete ni kwati rababa niere: Üai käme tä btä, aibe käta kä kwitekä dokwäbti, aisete tä ñäke kore. ¿Se drekäre munta kukwe mike ütiäte se? nieba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Akwa ni ruäre abko rababa niere: Nire nire btä üai käme tä ye abko ñan raba blite jire chi ni se kwrere. Mdakäre abko, ni ie kä tuen ñakare abko ie üai käme tä kä mike tuenta ñakare jire chi, rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kä ye ngwane abko kä tibo, kä ñüre angwane, ju blitakrä Ngöböbe Jerusalén abko mikaninta dbe Ngöbö ngwärekri mekera abko nitre israelita nämane ngwenta töre jae, aisete nämane jökrä bietabtä Jerusalén. ");
INSERT INTO gymNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Angwane Jesu nämane dikekä ju blitakrä Ngöböbe ye bäre jukä kädianta Jukä Salomónkwe käntita mda angwane, ");
INSERT INTO gymNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","nitre israelita ji dokwäte jataba ruäre, käkwe ja ükakröba Jesu bäre, käkwe nieba ie: Ma abko nire metre abko ñan tä nüke gare nunye, aisete nun moto iko töbikabtä kore, aisete ma abko Ni Dianinkä Ngöbökwe ara ya abko niere gwängwarbe nunye, nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Abtä Jesukwe nieba mda ietre: Ti abko nire, ye tikwe niebarera munye, akwa munkwe ñan ti kukwei mikani era amne mun ñan tä tödeke tibti. Ye abko, sribi ñan tuabare tita nuene ti Rün diebti niarata tibe bä mikakäre, ye abko tä ti mike gare metre, ");
INSERT INTO gymNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","akwa mun ñan tö tödekai tibti, ñobtä ñan angwane mun abko ñakare obeja tikwe, aisete munta nuene kore. ");
INSERT INTO gymNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Akwa obeja tikwetikwe abko ie ti kukwei gare kuin, käta ti mike täte amne, niaratre gare kuin tie arato, aisete obeja tikwe erere tä niken ti jiebti obejata niken ngibiaka jiebti ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Amne tikwe obeja tikwetikwe mikadi nüne kärekäre Ngöböbe amne Ngöbökwe ñan juandi ja okwä bäre mento kä ja tare nikakrä ye känti. Erere arato, ni mda di ñakare jire diankakrä ti kisete. ");
INSERT INTO gymNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ye abko, ti Rün di kri käkwe obeja biani tie, aisete ni mda di ñakare jire obeja ye diankakrä ti Rünkän. ");
INSERT INTO gymNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ye kwrere ti Rün btä ti, nun abko töi ja kwrere amne nunta ketetibe, nieba Jesukwe nitre israelita ji dokwäteye. ");
INSERT INTO gymNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yebtä abko nitre israelita ji dokwäte käkwe jä dianba kisete Jesu kämikakäre jäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Abtä niarakwe nieba mda ietre: Ti Rün diebti tikwe jändrän kuinkuin nuenbare kabre ni mda mda die mikakäre, ¿akwa kukwe kuin nuenbare tikwe, ye mden namani blo mun kräke abko dokwäre mun tö nibi ti kämikai jäbti ye? nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Abtä nitre israelita ji dokwäte käkwe nieba mda Jesuye: Ñan makwe jändrän kuin nuenbare abko dokwäre nun tö ma kämikai jäbti, akwa mata ñäke ngwarbe Ngöbö rüere amne ma ngwarbe nun kwrere käta ja mike Ngöböre au. Yebtä nun tö ma kämikai jäbti, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Abtä Jesukwe nieba mda ietre: Ye abko, Ngöbö Kukwei yebtä Ngöbökwe kukwe niebare krörö: Mun abko ngöbötre, tikwe nieba munbtä, abko Ngöbökwe niebare, tä tikani niara Kukweibtä. ");
INSERT INTO gymNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ngöbö Kukweita tikani kore, ye abko ni ñan raba rükente jire chi abko garera nie amne, ni jökrä ie Ngöbökwe ja Kukwei biani abko ngöbötre niebare kwe ie, ");
INSERT INTO gymNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","aisete ¿se ñobtä abko tita ja Ngöbö Odei niere abko nibi blo munkrä se? Ngöbökwe ti dianinkä ja Odeire, käkwe ti juani nitre kukwe nuenkä kämekäme Ngöbö rüere ye ngätäite, tita niere aisete ¿se ñobtä abko tita ja Ngöbö Odei niere angwane tita ñäke ngwarbe Ngöbö rüere abko munta niere tie? ");
INSERT INTO gymNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ti abko Ngöbö Odei tita niere, akwa tikwe ñan sribi ti Rünkwe nuendre angwane, munkwe ñan ti kukwei mikadre era; ");
INSERT INTO gymNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","akwa tikwe sribi ti Rünkwe nuendre, ye ngwane nane mun ñan tö ti kukwei aibe mikai era abko tä dbe. Akwa tita sribi ti Rünkwe nuene era metre, aisete yebti munkwe tödeka, ti Rünta ketetibe tibe amne tita ketetibe ben ye rükadre gare metre munye, abkokäre munkwe tödeka sribi ti Rünkwe nuenta tikwe yebti. ");
INSERT INTO gymNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Abtä nitre israelita ji dokwäte tö rababa Jesu kain ngite bobukäre, akwa Jesu gitiaba kän. ");
INSERT INTO gymNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Angwane Jesu rikabata Ñö Jordánbtä, Juan Bautista nämane ni ngökö ñöte, ye känti Jesu rababa nünentbe. ");
INSERT INTO gymNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Angwane ni kwati rikaba känti ja tuakäre ben, kä rababa niere: Sribi kri ñan tuabare abko Juankwe nuenbare ñakare, akwa kukwe nieba kwe Jesubtä abko kukwe era erere nieba kwe ñan ñan abko ni kwati rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Angwane ni kwati näma yete käkwe tödekaba Jesubti. ");
INSERT INTO gymNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Kä ye ngwane ni iti kädian nämane Lázaro näma nüne juta Betaniate abko namani bren jume. Juta Betania yete abko Marta amne María näma nüne ngwai Lázarobe. María ye mden abko käkwe ñö rä bäne kekaba ni Dänkien ngotobti, bti ni Dänkien ngoto rötaba ja dokwä drüenbti kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lázaro namani bren jume, aisete ngwai nibu ye mden käkwe ni mda juanba niere krörö Jesuye: Ni Dänkien, ma kukwe muko kuin makwe, mata tarere ye bren abko juanba niere kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Erere bkänä ni ye nikani, rükaba mate Jesu känti angwane, Jesukwe kukwei nuaba kore, bti nieba kwe: Bren ye kisete niara ñan krütadre janknukäre akwa, bren ye köböire Ngöbö di kri amne ti Ngöbö Odei di kri rabadi mikani tuadre, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu abko kwe Marta, María amne Lázaro nämane tare kri, ");
INSERT INTO gymNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","akwa Lázaro bren nie rükaba ie angwane niara näma, ye känti rababa köböbu mda. ");
INSERT INTO gymNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Bti nitre ja töitikaka ben ie nieba kwe: Bränta kä Judeate, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Abtä nun ja töitikaka Jesube käkwe nieba mda ie: Dirikä, nitre israelita ji dokwäte tö rababa ma kämikai jäbti kä Judeate, ye abko käi ngämi niken raire ta. ¿Kä ye känti abko ma tö nibira rikaita bobuta ya? nunkwe nieba ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Abtä Jesukwe nieba mda nunye: ¿Kä ngwen abko tä neme ñänä okwä krä jätäbti krobu ñan ñan? Ne aisete nita dikekä kä ngwenbti angwane, kä tuen kuin nie, aisete ni ngotota ritete ñakare, ñobtä ñan angwane kä trä ngwen kä nebtä yebti abko käta nebe tuen kuin ja käne nie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","11","Akwa nire erere rikadre dikekä deo, ye ngwane kä ñan rabadre tuen ie, aisete ngoto rabadre ritete. Tita niere kore, ñobtä ñan angwane ti abko kä trä ngwen kwrere amne tita nete angwane, kä tärä sribikrä. Ni kukwe muko Lázaro nikani kibien, akwa ti bike niken gaenkröta, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Angwane nun ja töitikaka ben käkwe nieba mda ie: Kiterate kuinta, aisete tä kibien, nunkwe nieba ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Akwa Lázaro abko krütanina abko Jesu näma niere nunye, akwa Lázaro nikani kibien bkänä abko Jesu näma niere, nun rababa nütüre. ");
INSERT INTO gymNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Abtä kukwe era erere nieba metre kwe nunye krörö: Lázaro kürera, ");
INSERT INTO gymNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","akwa tita ñakare känti angwane küre, ye abko käi nibi nuäre tibtä, ñobtä ñan angwane Lázaro küre, ye köböire kukwe mda rakadikä abko rabadi bäri kuin munkrä abko käkwe mun die mikadi tödeke bäri tibti, aisete brän Lázaro tuen, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Angwane ni iti ja töitikaka Jesube kädian nämane Tomás arabe kädian nämane “Munkin” abko käkwe nieba nun ja töitikaka Jesube mda mdaye: Ni kämikadre gwaire niarabe kä Judeate, abkokäre brän siba ben, nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ye erere Jesu rikaba, rikaba nebe juta Betaniate mda angwane, Lázaro doboi mikani abko käi nikanina köböbkä jire ta angwane, Jesu rikaba neme. ");
INSERT INTO gymNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Juta Betania abko näma känime Jerusalén ken, bäsi kilometro krämä näre. ");
INSERT INTO gymNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne aisete nitre israelita ji dokwäte rikaba kwati yete basare Martaye amne Maríaye moto ketabtäkäre kä mikakäreta nuäre btätre, ñobtä ñan angwane ngwai Lázaro krütani kän aisete. ");
INSERT INTO gymNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Angwane Jesu rikaba neme juta ken, ye gaba Martakwe angwane, jataba ngäbti, akwa María abko rababa gwi. ");
INSERT INTO gymNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta rikaba Jesu känti angwane, nieba kwe Jesuye: Ti Dänkien, ma tädre nete akräke ti ngwai ñan krütadre tikän, ");
INSERT INTO gymNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","akwa mtare makwe dre dre kärädre Ngöböye, erere biandi jökrä kwe mae, ye abko gare kuin tie, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Abtä Jesukwe nieba mda ie: Ma ngwai rükadita nire, nieba kwe Martaye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Angwane Martakwe nieba mda: Kä mrä angwane, ni krütani krütani rükadita nire, ye näire Lázaro rükadita nire arato, ye abko gare kuin tie, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Abtä Jesukwe nieba ie: Ti abko ni krütanina mikakata nire amne ti abko ni mikaka nüne ketetibe Ngöböbe. Nire nire käkwe tödekadre tibti abko krütadi era metre, akwa rükadita nire amne, ");
INSERT INTO gymNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","nire nire tä nüne käkwe tödekadre tibti abko ñan krütadre kärekäre Ngöbö okwä bäre mento. ¿Ne abko era makrä ya Marta? nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Angwane niarakwe nieba mda ie: Jän, ti Dänkien. Ma abko Ni Dianinkä Ngöbökwe amne ma Ngöbö Odei abko rükadre kä nebtä, ye abko tita mike era jae, aisete tita tödeke mabti, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martakwe blitaba kore Jesube, yebti Marta rikaba etba María kärere, käkwe nieba tiebe krörö ie: Dirikä tä nete, käkwe ma käräniri, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Martakwe nieba kore Maríaye, ye btäräbe María rükaba dikekä krö, jataba niken ja tuakäre Jesube. ");
INSERT INTO gymNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Akwa Jesu ngämi neme jutate, aisete Marta rükaba ngäbti, ye känti näma juta bäre. ");
INSERT INTO gymNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Angwane nitre israelita näma gwi Marta amne María känti kä mikakäreta nuäre btätre abko okwäbti María rükaba dikekä krö, bti rikaba jötrö, angwane nitre israelita ye rikaba jökrä jiebti, ñobtä ñan angwane María rikaba müen dobobti rababa nütüre, aisete rikaba kore María jiebti. ");
INSERT INTO gymNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Akwa Jesu näma, ye känti María jataba nüke angwane, María rikaba ngitiekä ngukudokwäbti temen Jesu ngotobtä Jesu mikakäre ütiäte, käkwe nieba ie: Ti Dänkien, ma tädre nete akräke ti ngwai ñan krütadre tikän, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Angwane María btä nitre israelita rükaba Maríabe, ye rababa müen jökrä Jesu okwäbti. Abtä Jesu rababa ulire amne moto rababa däre krübäte, ");
INSERT INTO gymNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","käkwe nieba mda ietre: ¿Munkwe Lázaro doboi mikani mdente? nieba kwe. Angwane niaratre käkwe nieba: Jakwe tuen nete ti Dänkien, nieba kwetre mda. ");
INSERT INTO gymNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Angwane Jesukwe müaba arato. ");
INSERT INTO gymNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Abtä nitre israelita käkwe nieba: Lázaro nämane tare kri kwe tuen, rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Akwa ni ruäre abko rababa niere: Ni ie kä tuen ñakare niara se käkwe kä mikani tuenta ie. ¿Se abko Lázaro ñan krütare, abkokäre jändrän mdara jire nuendre kwe kräke abko ñan rabadre bare ie ya? rababa niere Jesu rüere. ");
INSERT INTO gymNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Angwane Jesu moto rababata däre, käkwe krötaba Lázaro doboi kukwäre angwane, kä mkä te Lázaro doboi mikani, yebti jä oto kwata kri näma mikani. ");
INSERT INTO gymNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Angwane Jesukwe nieba: Jä oto ye denkä mento dobobti yete, nieba kwe. Abtä Lázaro ngwai Marta käkwe nieba Jesuye: Ti Dänkien, kä nena köböbkä jire niara krütani amne doboi mikani, aisete rä nena kure, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Abtä Jesukwe nieba mda ie: ¿Makwe tödekadre tibti angwane, Ngöbö di kri bä nuäre ye makwe tuadi, tikwe ñan nini mae ya? nieba Jesukwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Angwane jä oto ye diankaba mento. Ye btäräbe Jesukwe nikraba kä käinbti, käkwe nieba: Ti Rün tikwe, tikwe blitaniri mabe amne mata biare ti die mike, yebtä ti tö kuin niei mae. ");
INSERT INTO gymNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Käre tita blite mabe ja di kärere mae angwane, mata nuene ye gare kuin tie, akwa makwe ti juani ye abko nitre tä nete noko, kräke rabadre era, abkokäre tita blite kore mabe, nieba Jesukwe Rünye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jesukwe blitaba ünän jökrä kore, ye btäräbe ngrateba kri kwe, käkwe nieba: ¡Lázaro, jakweta künken kä mkä ye bäre mento! nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ye btäräbe Lázaro näma nguse, ye kise amne ngoto näma mrianinte jökrä dänte abko erere jataba kä mkä yete mentokwäre angwane, ngwäre abko näma mrianinte jökrä jatabata kä mkäte mento. Angwane nitre näma yete, ye ie Jesukwe nieba: Tikete, bti tuemetre dikekä, nieba kwe. Erere nuenba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesukwe Lázaro mikabata nire, ye abko nitre israelita näma Marta amne María mukore ye käkwe tuaba angwane, niaratre kwati käkwe tödekaba Jesubti. ");
INSERT INTO gymNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Akwa ni mda mda käkwe tödekani ñakare Jesubti abko rikaba nitre bariseo känti angwane, Jesukwe Lázaro mikabata nire ño, ye abko niebare jökrä kwetre nitre bariseoye. ");
INSERT INTO gymNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Abtä nitre bariseo amne nitre blitaka Ngöböbe ni mda mda diäre dänkientre käkwe nitre sribikä Sanedrinbtä käräbare gätäkäre, bti niebare jae kwärikwäri kwetre: Ni kädekata Jesu käta sribi kri ñan tuabare nuene kabre ni ngätäite. ¿Sebtä abko nikwe dre nuendre? ");
INSERT INTO gymNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nikwe tuadremetre sribi nuene janknu kore angwane, ni jökrä rabadi tödeke bti. Yebtä abko nitre romanobo tä nun dänkiene jatadi, käkwe ju blitakrä Ngöböbe nikwe se juandi ngwarbe jökrä amne, juta israelita nikwe noko juandi ngwarbe jökrä kwetre arato, niebare kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Abtä ni iti kädian nämane Caifás abko nämane sribire nitre blitaka Ngöböbe ni mda mda diäre dänkiene kä ye näire abko käkwe niebare ietre: ¡Mun töi ñakare! ");
INSERT INTO gymNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ni gadrekä jökrä juta israelita nete, ye abko rabadre bäri tare, akwa ni itibe krütadre ni jökrä täte amne ni jökrä kräke, ye abko rabadre bäri kuin munkrä abko btä munta töbike ñakare, niebare Caifákwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás abko käkwe ñäkäbare kore, ye abko ñan niebare ja töi jenbti kwe, akwa kä ye ngwane niara nämane nitre blitaka Ngöböbe ni mda mda diäre dänkiene, aisete Jesu krütadre nitre israelita täte abko niebare Ngöbö Üai köböire kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ye abko ñan Jesu krütadre nitre israelita aibe täte amne kräke, akwa Ngöbö ngäbriänkätre nämane kä ketareketare te kwäräkwärä abko rabadreta ükaninkrö jökrä ketetibe nitre Ngöbö ngäbriänkätre juta israelita ben gwaire, abkokäre Jesu krütadre, aisete Caifákwe niebare kore. ");
INSERT INTO gymNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ne aisete köbö ye näire mentokwäre nitre sribikä Sanedrinbtä käkwe ja töi mikani gwaire jökrä Jesu müre ketakäre. ");
INSERT INTO gymNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Abtä Jesu ñan rabadre dikekä ja ngwärekri jökrä nitre israelita ji dokwäte ngätäite angwane, juta kä Efraín näma känime kä kaibe ken, ye känti Jesu rikaba amne rababa nünentbe yete nitre ja töitikaka benbe. ");
INSERT INTO gymNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kä ye ngwane abko, bieta Pascua nitre israelitakwe abko köböi jatabara nüketa ja ken, aisete nitre israelita kwati nünanka Jerusalén bäre rikaba neme Jerusalén ja mikakäre dbe Ngöbö ngwärekri bieta Pascua känenkri, rabadre neme ju blitakrä Ngöböbe känti Pascua mikakäre ütiäte jae, abkokäre rikaba. ");
INSERT INTO gymNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Angwane nitre ye rababa näin jökrä Jesu känentari, kä rababa niere krörö jae kwärikwäri ju blitakrä Ngöböbe ye känti: ¿Munta töbike ño? ¿Jesu rükai bietabtä nete ruen ya? rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Angwane nitre bariseo amne nitre blitaka Ngöböbe ni mda mda diäre dänkientre käkwe nieba krörö ni jökräye: Jesu tä mdente raba gare munye angwane, munkwe mika gare jötrö nunye amne nunkwe kadi ngite, nieba kwetre. ");
INSERT INTO gymNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yebti köbö ti Pascua känenkri, Jesu rikaba Lázaro känti juta Betaniate mda. Lázaro ne mden abko krütani, akwa Jesukwe mikaninta nire abko känti Jesu rikaba. ");
INSERT INTO gymNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesu rababa yete angwane, mrö sribeba kwetadre Jesu mikakäre ütiäte angwane, Marta näma mrö dräire amne Lázaro abko näma täkänintbe siba mesabtä mröre Jesube. ");
INSERT INTO gymNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Angwane María jataba kri ngwäri rä bäne kä nardo ngwena bäsi botea ötare jire. Nardo ye abko ütiäte kri amne ñan nämane mritani jire ñöbe abko María jataba ngwena, bti Jesu mikakäre ütiäte Maríakwe nardo ye kekaba Jesu ngotobti, bti Jesu ngoto rötabata ja dokwä drüenbti kwe. Angwane kä rä rababa bäne jökrä gwita temen nardo ye kisete. ");
INSERT INTO gymNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Angwane ni iti ja töitikaka Jesube kä Judas Iscariote käkwe Jesu kitadre ngise ye käkwe nieba: ");
INSERT INTO gymNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¡Jo! ¡Ngwian ganaindre bäsi kä kwati jire btä kri ngwäri rä bäne se rürümoindre abko bti ni bobre bobre die mikadre bä amarebti ñan rürümoiniri se! nieba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas käkwe ñäkäba kore, akwa ñan ni bobre bobre ruentari tare ie, aisete ñäkäba kore kwe. Akwa niara abko gore, aisete ñäkäba kore kwe. Niara abko ngwian ngibiaka nunkrä, akwa näma ngwian ye goire ruäre nunkän, aisete ñäkäba kore kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Abtä Jesukwe nieba mda Judaye: Niarakwe ti mikadre biare doboi mikadre, abkokäre nämane kri ngwäri ye üke tikrä, aisete tuemetre kaibe. Makwe ñan nika. ");
INSERT INTO gymNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mdakäre abko, nitre bobre bobre abko tädi käre mun ngätäite nete, aisete mun tö raba die mikai ñongwane, erere munkwe die mika, akwa ti abko ñan tädi kärekäre munbe nete. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yebti Jesu näma juta Betaniate abko gaba nitre israelitakwe angwane, ni kwati jataba Jesu känti. Niaratre ye abko ñan jataba Jesu aibe tuakäre, akwa Lázaro krütani, mikaninta nire Jesukwe ye abko jataba tuakäre arato. ");
INSERT INTO gymNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Abtä nitre blitaka Ngöböbe ni mda mda diäre dänkientre käkwe kukwe ükateba Lázaro kämikakäre arato, ");
INSERT INTO gymNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ñobtä ñan angwane Lázaro krütani akwa Jesukwe mikabata nire, aisete Lázaro köböire ni israelita kwati käkwe tödekaba Jesubti amne ñan rababa nekete mda nitre blitaka Ngöböbe ni mda mda diäre dänkientre yekri. Abtä kukwe ükateba kore kwetre Lázaro rüere. ");
INSERT INTO gymNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ye näire, ni rababara kwati krübäte juta Jerusalénte bieta Pascua mikakäre ütiäte amne, jändrinane Jesu jatabara ji ngrabare Jerusalén kukwäre abko nitre kwati ye käkwe gaba. ");
INSERT INTO gymNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Angwane datile kriekä tikakaba kwetre, ben jataba Jesu kakäre ngäbti jrei kwrere, kä rababa ngrente krikri be krörö ie: ¡Hosana! ¡Ma abko Jrei nitre israelitakwe! Ni Dänkien Ngöbö käkwe ma juani. Ma kite ni Dänkien Ngöbö käbti, aisete nunta ma käikitekä, abko nitre israelita rababa niere Jesu ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Angwane Jesu näma näin buro ngäbälibti, rikaba neme Jerusalén mda Ngöbö Kukweita niere ye kwrere: ");
INSERT INTO gymNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mun nünanka juta Siónte nete, mun ñan rekwetaka, ñobtä ñan angwane Jrei munkwe kite buro ngäbälibti, ye mike ñäräre munkwe, abko tä tikani Ngöbö Kukweibtä abko erere Jesukwe nuenbare. ");
INSERT INTO gymNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Akwa ye näire nun ja töitikaka Jesube abko ie kukwe ye ñan rükaba gare, akwa Ngöbökwe Jesu mikaba ütiäte, rikaba ngwenante kä käinbti angwane, batibe kukwe rakakaba ye abko näma tikani jökrä Ngöbö Kukweibtä abko erere nakaninkä btä abko rükabata töre nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesu jataba burobti, ye ngwane abko Lázaro krütani nämane doboi mikani nguse abko Jesukwe käräbata künken amne Jesukwe mikaninta nire, ye abko nitre tuakatuaka rababa niere ni mda mdaye. ");
INSERT INTO gymNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ne aisete ni kwati jataba Jesu ngäbti, ñobtä ñan angwane Jesukwe sribi kri ñan tuabare nuenba, Ngöbö nämane ben bä mikakrä abko gaba kwetre, aisete rababa kite jökrä Jesu ngäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Akwa nitre bariseo abko rababa niere jae kwärikwäri: ¡Ni jökrä nibi niken niara jiebti, ne aisete kitera ni ganaine kwäräbe, tuen sete se! ¿Sebti nikwe dre nuendi mda? rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Angwane nitre rababa kwati Jerusalén Ngöbö mikakäre ütiäte jae bietabtä, ye ngätäite nitre griegore näma ruäre abko ");
INSERT INTO gymNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","jataba nüke Felipe känti. Felipe ye abko nünanka juta Betsaidate kä Galileate. Nitre ye jataba Felipe känti, käkwe nieba ie: Ja mräkä, nun tö nibi ja tuai Jesube, nieba kwetre ie. ");
INSERT INTO gymNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Angwane Felipe rikaba käkwe nieba mda Andréye, bti niaratre nibu rikaba käkwe kukwe ye nieba jökrä Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Angwane Jesukwe nieba mda ietre: Kä kitani Ngöbökwe ti Ni Kä Nebtä Ngobo mikakäre ütiäte abko käi nüra. ");
INSERT INTO gymNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ye abko ti bike kukwe era erere niere munye. Trigo nurai nökata dobote, ye abko nita krüte bä mikata trigo nuraibtä. Ye abko trigo nurai ñan gütadrete kore angwane, trigo nurai ye aibe rabadre kärekäre, akwa trigo nurai ye nökadre, bti gütadrete amne mu rabadre niren angwane, ngwä rabadre kabre. Ti abko trigo nurai ye kwrere. Ti ñan krütadre angwane, ti aibe rabai nüne kärekäre Ngöböbe, akwa ti krütadre angwane, ni kwati jatadi nüne kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mdakäre abko, nire nire israelita ya, ñakare ya ie ja kwata ruentari tare, abtä ñan tö ja tare nikai ti kräke, ni ye abko käkwe ñan nünandi kärekäre Ngöböbe; akwa nire nire ie ja kwata ñan rabadre ruentari tare ja tare nikakrä kä nebtä tikrä, ni ye abko käkwe nünandi kärekäre Ngöböbe. ");
INSERT INTO gymNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ne aisete nire nire tö sribire tikrä abko jata ti jiebti amne ti tädi mdente erere, ye känti sribikä tikwe tädi tibe. Erere arato, nire nire käkwe sribidre tikrä, ni ye abko Ngöbö ti Rün tikwe käkwe mikadi ütiäte. Abko kore se, nieba Jesukwe ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yebti Jesu krütadre abko btä näma töbike kri, käkwe nieba: ¡Aingwaree, ti nibi nekwetekä krübäte dikaro ja jiebti bäre! ¿Nebtä tikwe dre niedre se? ¿Tikwe niedre, Tata tikwe, kukwe kite tare krübäte ti rüere, ngäniene ti nibi nekwetekä, aisete den tibti ta, tikwe niedre ya? Ñakare, raba ruen tie, ñobtä ñan angwane ti jatani kukwe ne mikakäre täte aisete. ");
INSERT INTO gymNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ti Rün tikwe, ja bä mike ütiäte ni jökrä okwäte, ie ti tö. Abko kore se, nieba Jesukwe. Ye btäräbe ni kukwei rababa kä käinbti, käkwe nieba krörö: Tikwe ja mikanina ütiäte, akwa tikwe ja mikadita ütiäte bobuta abko nieba kä käinbti sete. ");
INSERT INTO gymNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Angwane, nitre näma yete, ie ni kukwei kä käinbti jaraba angwane, rababa niere: Unsuni ngö käinta ye, rababa niere. Akwa ni ruäre abko rababa niere: Angele kä käinbti käkwe ñäri Jesuye ye, rababa niere. ");
INSERT INTO gymNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Angwane Jesukwe nieba ietre: Ni kukwei jaraniri kä käinbti munye, ye abko mun die mikakrä tödeke tibti, akwa ñakare tikrä. ");
INSERT INTO gymNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ye abko, gwängwarbe kukwe rabadre ükaninte Ngöbökwe ni jökrä kä nebtä kräke abko käi kitera nüke. Erere arato, diablu tä ni jökrä dänkiene kä nebtä abko juantari mento abko käi kitera nüke arato. ");
INSERT INTO gymNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Akwa ti ne ara rabadre kaninkä krusobtä käin angwane, ti ne ara jire käkwe ni jökrä kärädi jae, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesu abko krütadi ño, ye mden tö rababa niei, käkwe blitaba kore. ");
INSERT INTO gymNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Abtä nitre näma kwati yete, ye käkwe nieba Jesuye: Ni Dianinkä Ngöbökwe abko käkwe nünandi kärekäre, ye abko Ngöbö Kukwei tä niere amne Ni Dianinkä Ngöbökwe amne ni Kä Nebtä Ngobo abko ni itibe, akwa Ni Dianinkä Ngöbökwe ñan krütadre, aisete, ¿ye ñobtä abko Ni Kä Nebtä Ngobo kadikä krusobtä käin, mata niere ye? ¿Nire abko Ni Kä Nebtä Ngobo amarebti btä mata ñäke kore ye? nieba kwetre Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Abtä nitre näma kwati yete, ie Jesukwe nieba mda: Ti abko ñotra kwrere amne jändrän jökrä Ngöbö rüere amne ti rüere, ye abko kä iko kwrere. Ti abko ñotra tä mun ngätäite nete, akwa ñotra ye abko rabadi bä jötrö mda mun ngätäite nete, aisete ñotra tä munbe nete angwane, munkwe dikaka ñotra trä yete, kä iko käkwe ñan mun ganaindre abkokäre, ñobtä ñan angwane nire nire tä dikekä kä ikote ye abko tä niken mden kukwäre ñan tä neme gare ie. ");
INSERT INTO gymNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ti abko ñotra tä mun ngätäite nete. Mun rabare nüne ti kwrere, abkokäre tita nete mun ngätäite angwane munkwe tödeka tibti. Abko kore se, nieba Jesukwe. Jesukwe blitaba ünän jökrä kore, yebti Jesu rikabata, käkwe ja rükantebata bobuta nitre israelita ji dokwäteye. ");
INSERT INTO gymNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesukwe sribi kri ñan tuabare nuenba kabre nitre israelita okwäbti Ngöbö nämane niarabe mikakäre gare ietre, akwa ñan tö namani tödekai jire chi Jesubti, ");
INSERT INTO gymNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ye abko ni Ngöbö kukwei niekä kädian nämane Isaías käkwe tikani krörö abko erere namani bare niaratrebtä: Ti Dänkien, ¿kukwe dirita nunkwe, ye nirekwe mikadi era? ¿Amne ma di kri ye abko makwe mikani tuadre nireye? abko tikani kore Isaíakwe nitre israelitabtä. ");
INSERT INTO gymNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ye mden kisete, nitre israelita kwati ñan namani tödeke Jesubti. Mdakäre abko, Isaías arabe käkwe kukwe mda tikani krörö btätre arato abko nere: ");
INSERT INTO gymNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ngöbökwe kä trä ötaninte niaratre okwäte, niarata dre nuene niaratre okwäbti ñan jatadre metre ietre abkokäre. Erere arato, Ngöbökwe niaratre töi ganinte, kukwe ño ño ñan rabadre nüke gare ietre abkokäre. Ye kwrere ñan jatadreta ti kukwäre angwane, tikwe ñan mikadreta kuinta diantarikäre, abko Isaíakwe tikani täräbtä nitre israelitabtä. ");
INSERT INTO gymNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías abko käkwe Jesu di kri bä nuäre tuani, aisete nämane blite btä, käkwe niebare kore nitre israelitaye kira. ");
INSERT INTO gymNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Nitre israelita kwati käkwe tödekaba ñakare Jesubti, akwa nitre israelita kwati mda abko käkwe tödekaba bti. Erere arato, ni ruäre ji dokwäte abko käkwe tödekaba Jesubti siba, akwa ñan tö rababa niei ja ngwärekri jökrä, ñobtä ñan angwane nane nitre bariseo käkwe gadre amne kitadrekä sinagoga bäre mento abko jürä rababa btätre, aisete nämane tödeke Jesubti abko ñan rababa niere, ");
INSERT INTO gymNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ñobtä ñan angwane nitre kä nebtä käkwe mikadre ütiäte jae abko ie tö rababa bäri amne, Ngöbökwe mikadre ütiäte jae, ye abko rababa ütiäte ñakare kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yebti Jesukwe ngrateba kri, käkwe nieba: Nire nire käkwe tödekadre tibti, ye abko ñan tödekadre ti ne aibebti kwe, akwa ti Rün tikwe käkwe ti juani, yebti tödekadre kwe arato. ");
INSERT INTO gymNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Erere arato, nire nire käta ti tuen, ye tä ti Rün ti juanka tuen arato, ñobtä ñan angwane niarata dre dre nuemna tie aibe tita nuene. ");
INSERT INTO gymNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nire nire tä nüne kä ikote amne Ngöbö gare ñakare ie, käkwe tödekadre tibti abko ñan nünandi mda kä ikote kwe, ñobtä ñan angwane rükadre ño Ngöbö känti rükadre gare ie, abkokäre ti jatani ñotrare mun ngätäite kä nebtä. ");
INSERT INTO gymNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Akwa nire nire käta ti kukwei nuen, akwa ñan tä mike täte amne ñan tä mike era jae, ye kräke tikwe ñan kukwe ükadrete au, ñobtä ñan angwane ñan ti jatani kukwe ükete ni rüere juantarikäre Ngöbö okwä bäre mento, akwa ti jatani ni diantarikäre niaratre ngite ngäniene. ");
INSERT INTO gymNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Akwa nire nire tä bätä ngwen tibtä amne kukwe dirita tikwe ñan tä mike ütiäte jae, ye abko ñan tikwe kukwe ükadite kräke amne ñan tikwe kitadi ngite Ngöböye. Akwa munkwe ñan ti kukwei mikadre era, ye ngwane ti Rün käkwe kukwe ükadite munkrä kä mrä angwane, ");
INSERT INTO gymNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ñobtä ñan angwane tita blite, ye abko ñan tita niere ja töi jenbti, akwa ti Rün tikwe käkwe ti juani ye abko tä dre niemna tie abko erere tita dirire munye. ");
INSERT INTO gymNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ti Rün kukwei, ye abko nire nire käkwe mikadre era jae abko rabadi nüne kärekäre ti Rün Ngöböbe abko gare kuin tie, aisete tita kukwe niere ye abko ti Rün tikwe tä niemna tie, erere tita niere. Abko kore se, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yebti bieta Pascua jatabara nüke angwane, Jesukwe kä mikarekä kä nebtä amne, rikareta kä käinbti niara Rün känti, ye abko kä nükanina abko nämanena gare Jesuye angwane, nitre jen Jesukwe nämane kä nebtä abko Jesu näma tarere, ye abko tareba täte jökrä kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nun jataba mröre dere, akwa nun ngämi mröre, känenkri Simón ngobo Judas Iscariote abko diablukwe töi mikabara Jesu rüere, Jesu kitakäre ngite. ");
INSERT INTO gymNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Akwa Jesu abko, ie Rünkwe jändrän jökrä mikanina gare nämanena gare ie amne, niara jatani Ngöbökri amne rikadita Rün känti, ye abko nämanena gare ie arato. ");
INSERT INTO gymNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ne aisete, batibe rababara täkänintbe mröre mesabtä, akwa rükaba dikekäta krö, käkwe dän tikateba jabtä, bti dän kukwän chi mäkäteba kwe ja mrökarabtä, ");
INSERT INTO gymNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","bti ñö kekaba unkwente kwe, bti rikaba nun ja töitikaka ben ye ngoto bätete, ni klabore käkwe nuendre ye kwrere amne, dän kukwän nämane niara mrökarabtä, yebti rikaba nun ngoto bä rötöta se kwrere. ");
INSERT INTO gymNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jesu rikaba nebe Simón Pedro känti ngoto bätätekäre angwane, Pedrokwe nieba ie: Ti Dänkien, ¿ni klabore käta ni ngoto bätete, kwrere jire ma bike ti ngoto bätete tie ya? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Abtä Jesukwe nieba mda ie: Tita dre nuene ñan nebe nüke gare mae mtare, akwa abti rükadi gare mae, nieba kwe Simón Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Angwane Pedrokwe nieba mda Jesuye: ¡Tikwe ñan ma tuametre ja ngoto bätete jire chi! nieba kwe ie. Abtä Jesukwe nieba mda ie: Tikwe ñan ma ngoto bätärete ne ngwane, ma ñan rabadre jen tikwe, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Angwane Simón Pedro käkwe nieba mda ie: Ti Dänkien, kore ne ngwane, ñan makwe ti ngoto aibe bätäte, akwa makwe ti kise amne ti dokwä bätäte arato, ie ti tö nibi, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Akwa Jesukwe nieba mda ie: Nita jüben krire, bti nita niken känime, ye ngwane ni ngoto aibe tä nebe dobrore, aisete ni ngoto aibe bätärete, ñobtä ñan angwane ni ngrabare abko tärä nebe merebe jökrä amne mun abko nena merebe, akwa era metre mun jökrä ñakare merebe, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesukwe nieba kore, ñobtä ñan angwane nirekwe kitadi ngise ye abko näma gare kuin ie, aisete nieba kore kwe Judas Iscariotebtä. ");
INSERT INTO gymNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesukwe nun ja töitikaka ben ngoto bätäteba ünän jökrä, bti Jesukwe dän kitabata jabtä, bti rababata täkänintbe mesabtä, käkwe nieba: ¿Ñobtä tikwe mun ngoto bätrite ye nü gare munye ya? nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yebti Jesukwe nieba mda nunye: Ti abko Dirikä amne ti mun Dänkien munta niere tie, ye abko kukwe era erere munta niere, ñobtä ñan angwane ti abko Dirikä amne ti mun Dänkien bkänä. ");
INSERT INTO gymNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ti Dirikä amne ti mun Dänkien käkwe mun ngoto bätrite jökrä ni klabore kwrere ne ngwane, ye kwrere munkwe ja mika bobre ni klabore kwrere, käkwe ja ngoto bätädrete jae kwärikwäri, tikwe nuni ye kwrere. ");
INSERT INTO gymNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tikwe ja miri bobre ni klabore kwrere mun jökrä kräke, ye kwrere munkwe nuendre jakrä kwärikwäri, abkokäre tikwe kukwe bä miri kore mun okwäbti. ");
INSERT INTO gymNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ye abko, ti bike kukwe era erere niere munye abko krörö: Ni klabore ye ñakare bäri ütiäte niara bkänkä kräke. Erere arato, ni ni mda kukwei ngwianka ye abko ñakare bäri ütiäte ni niara juanka ye kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ne aisete tikwe kukwe nuni mun kräke, ye nü gare munye angwane, munkwe nuendre kwrere jakrä kwärikwäri arato ne ngwane, kä rabadi nuäre munbtä amne Ngöbökwe ja di biandi munye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Akwa tita kukwe niere, ye abko ñakare mun jökrä kräke, ñobtä ñan angwane tikwe mun mden mden dianinkä jen jakrä ye abko gare kuin tie, akwa Ngöbö Kukwei tä tikani ye abko rabadre bare, abkokäre ni iti käkwe kukwe nuendi krörö btä kukweta tikani: Ni iti tä mröre siä kwatibe te tibe abko nikwitani ti rüere, abko tä tikani Ngöbö Kukweibtä, ye erere rakadikä. ");
INSERT INTO gymNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kukwe ye abko ngämi nakenkä, känenkri tita niere munye, kukwe ye kwrere rabara nakenkä mun okwäbti angwane, TITA abko munkwe mikadre era, abkokäre tita niere munye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mdakäre abko, ti bike kukwe era erere niere mda munye abko krörö: Tita ni juen, ye nire nire käkwe kadre ngäbti, ni ye abko käta ti ne ara jire kaen ngäbti amne, nire nire käta ti kaen ngäbti, ni ye abko käta Ngöbö ti juanka ara jire kaen ngäbti. Abko kore se, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesukwe blitaba kore, ye btäräbe Jesu ñan moto rababa neme nuäre, rababa ruen ie angwane, Judakwe niara kitadi ngise abko nieba metre krörö kwe: Mun iti tä nete käkwe ti kitadi ngise ti rüeye ti müre ketakäre, ye abko ti bike niere metre munye, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Abtä nun ja töitikaka ben rababa ja mike ñäräre kwärikwäri, akwa Jesu näma ñäke nirebtä, ye ñan rababa nüke gare nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Abtä ni iti ja töitikaka ben abko Jesu nämane tarere kri abko näma täkänintbe känime mesabtä mröre Jesu ken angwane, ");
INSERT INTO gymNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","nirebtä näma blite ni ye käkwe ngwiandretari Jesuye abko Simón Pedro käkwe nieba kisebti ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ye erere bkänä, ni ye käkwe gitakaba Jesu kukwäre, käkwe nieba ie: Ti Dänkien, ¿nirekwe ma kitadi ngise? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Angwane Jesukwe nieba mda ie: Ti bike ban oto mike tibo mrö ñöite abko tikwe biandi nireye amne ni ye ara, nieba kwe. Ye btäräbe Jesukwe ban oto mikaba tibo, bti Simón ngobo Judas Iscariote, ie bianba kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas käkwe ban oto kaba ngäbti Jesuye, ye btäräbe Satana rükaba btä angwane, Jesukwe nieba ie: Makwe dre nuendi, ye nuene jötrö, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jesukwe ñäkäba kore Judaye, akwa ñobtä ñäkäba kore kwe ie, nun mda mda ja töitikaka ben näma mröre mesabtä, ie ñan rükaba gare. ");
INSERT INTO gymNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Akwa Judas abko näma ngwian nunkwe ngibiare, aisete Jesukwe juani jändrän kökö bietakrä ya o ngwian biamna kwe ie ni bobre bobreye abko nun ruäre rababa nütüre. ");
INSERT INTO gymNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Akwa Jesukwe ban bianba Judaye angwane, Judakwe kaba ngäbti, ye btäräbe Judas rikaba Jesu kite ngise rüeye. Ye ngwane kä rababara iko jökrä. ");
INSERT INTO gymNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas rikaba mentokwäre, yebti Jesukwe nieba: Mtare ti, Ni Kä Nebtä Ngobo, mun tarekä kri abko di kri bä nuäre rabadi mikani tuare amne Ngöbö mun tarekä di kri bä nuäre rabadi mikani tuare Ni Kä Nebtä Ngobo köböire. ");
INSERT INTO gymNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ye abko, ti Ngöbö Odei käkwe Ngöbö di kri bä nuäre mikadi tuare, ye kwrere arato Ngöbö käkwe ti Ngöbö Odei di kri bä nuäre mikadi tuare arato, ye abko Ngöbökwe nuendi jötrö. ");
INSERT INTO gymNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mdakäre abko, mun ngäbäkre kiakia tare kri tikwe, mun ye ben tikwe ñan nünandre raire mda. Ti näin angwane, mun rabadi ti känentari kisere, akwa tikwe kukwe nieba nitre israelita ji dokwäteye, erere ti bike niere munye: Ti näin mdente, ye känti mun ñan raba niken gwaire tibe. ");
INSERT INTO gymNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Akwa ti bike kukwe bien nuendre btin munye, ne erere munkwe nuen abko krörö: Mun ja töitikaka tibe käkwe ja tare kwärikwäri. Tita mun tarere ño, ye kwrere munkwe ja tare kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Munkwe ja taredre kwärikwäri tita niere munye, ne kwrere munkwe ja taredre ne ngwane, mun abko ja töitikaka tibe ye rabadi gare ni jökräye, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Angwane Simón Pedro käkwe nieba mda ie: Ti Dänkien, ¿ma näin mdente? nieba kwe ie. Jesu käkwe nieba mda ie: Ti näin mdente, ye känti ma ñan raba niken jire chi tibe mtare, akwa abti ma näinta ti jiebti arato, nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Abtä Pedrokwe nieba mda Jesuye: Ti Dänkien, ¡tita juto biare krütakäre makrä! ¿Se ñobtä abko ti ñan rabadre mabe gwaire mtare, mata niere se? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ye ngwane Jesukwe nieba mda ie: ¿Mata biare krüte tikrä bkänä ya? Ti bike kukwe era erere niere mae abko krörö: Antlan ngämi ngwäne, ye känenkri ti gare ñakare mae, makwe niedi bämä jire, nieba kwe Pedroye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yebti Jesukwe nieba mda: Kukwe yebtä mun ñan rekwetaka ja jiebti, akwa munkwe tödeka Ngöböbti amne munkwe tödeka tibti arato, ");
INSERT INTO gymNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ñobtä ñan angwane ti Rün tikwe, känti kä tärä kabre nünankrä. Kä ñakare kore, ne ngwane tikwe niedre munye, akwa kä tärä amne ti bike niken kä ükete biare munkrä. ");
INSERT INTO gymNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ye erere ti näinta kä ükete munkrä, yebti ti jatadita mun tuenta, kä näin mun ngwena jabe angwane, ti tädi ti Rün känti, ye känti mun tädi ketetibe tibe, abkokäre ti näin mun ngwena. ");
INSERT INTO gymNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mdakäre abko, ti näin mdente, ye känti ji garera kuin munye, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Abtä Tomákwe nieba Jesuye: Ti Dänkien, ma näin mdente gare ñakare nunye, ¿se abko ji rabadre gare ño nunye amarebti mata niere kore ye? nieba kwe ie. ");
INSERT INTO gymNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Angwane Jesukwe nieba mda: Ti abko ji ngöräbe, köböire ni jökrä raba nüke ti Rün känti amne, ti aibe abko kukwe era erere mikaka gare Ngöböbtä amne ti aibe abko ni mikaka nire kärekäre, aisete ti ne aibe köböire ni rabadre ti Rün känti. ");
INSERT INTO gymNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ti abko nire metre gare munye ne ngwane, ti Rün garera munye arato. Mun jatani ja töitike tibe abti kä nüke mtare munta ti Rün tuen tibtä amne ti Rün nena gare munye mtare, nieba kwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Angwane Felipe abko käkwe nieba mda ie: Ti Dänkien, ma Rün mike tuadre nunye aibe kwe nun rabadi dbe, nieba kwe Jesuye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Abtä Jesukwe nieba mda Felipeye: Felipe, ¿tikwe nünabarera raire munbe nete, akwa ti abko ni ño, ye ngämi nüke gare mae ya? Nire nire käta ti tuen, ye abko tä ti Rün tuen arato. ¿Ye ñobtä abko tikwe ti Rün mikadre tuadre munye, mata niere tie ye? ");
INSERT INTO gymNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ti tä ketetibe ti Rünbe amne ti Rün tä ketetibe tibe, ye abko ñakare era makrä ñan ñan? Akwa tita kukwe niere munye, ye abko ñan tita niere ja töi jenbti, akwa ti Rün tä nüne ketetibe tibe käta sribi jakwe nuene ti köböire. ");
INSERT INTO gymNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ye abko, tita ketetibe ti Rünbe amne ti Rünta ketetibe tibe, ye mika era munkwe; akwa ne ñan raba neme era munkrä ne ngwane, sribi kri ñan tuabare nuenta tikwe, yebtä ti kukwei mika era munkwe. ");
INSERT INTO gymNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mdakäre abko, ti bike kukwe era erere niere munye: Nire nire käta tödeke tibti, ye abko sribi kri nuenta tikwe, ye kwrere nuendi kwe arato. Akwa mtare ti bike nikenta ti Rün känti, aisete ni ye käkwe sribi bäri kri nuendi Ngöbö diebti. ");
INSERT INTO gymNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ye abko, mun tö raba dre dre käräi ti Rünye ti käbti, ye abko tikwe nuendi mun kräke, ye köböire ti Rün di kri bä nuäre rabadre mikani ütiäte kri ti Ngöbö Odei köböire, abkokäre tikwe nuendi mun kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ye abko, mun tö raba kukwe ño ño käräi tie ti käbti angwane, tikwe nuendi mun kräke. ");
INSERT INTO gymNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yebti Jesukwe nieba mda nunye: Munta ti tarere era metre bkänä ne ngwane, tita kukwe nuemna ye erere munkwe mikadre täte ");
INSERT INTO gymNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","angwane, mun Die Mikaka mdara jire juandre ti Rünkwe ti täte munkrä abko tikwe kärädi ie. Mun Die Mikaka mdara jire ye abko Ngöbö Üai. Niara abko kukwe era erere niekä, ye abko ti Rün tikwe käkwe juandi angwane, rabadre kärekäre munbe abkokäre. Akwa nitre nünanka Ngöbö rüere abko ñan raba mun Die Mikaka ye kaen ngäbti jire chi, ñobtä ñan angwane niaratre ie Ngöbö Üai tuen ñakare amne gare ñakare ietre arato, aisete ñan raba kaen ngäbti; akwa mun abko ben Ngöbö Üai mun Die Mikaka tä nüne amne niara garera munye, ñobtä ñan angwane tä nüne tibtä aisete. Nebti niara rabadi nüne munbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mdakäre abko, ti bike nikenta, akwa mun ñan rabadre uli kwrere nete, ñobtä ñan angwane ti jatadita rabakäre munbe. ");
INSERT INTO gymNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Akwa nitre nünanka Ngöbö rüere käkwe ñan ti tuadreta jire mda abko köböi nükera känime, akwa mun abko käkwe ti tuadita amne tita nüne kärekäre, abtä munkwe nünandi kärekäre arato. ");
INSERT INTO gymNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Akwa munkwe ti tuadita, köbö ye näire tita ketetibe ti Rünbe amne munta ketetibe tibe amne tita ketetibe munbe abko munkwe gadi. ");
INSERT INTO gymNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ye abko, tita kukwe bien nuendre, ye nire nire tä kaen ngäbti abko erere tä mike täte, ni ye tä ti tarere era metre bkänä abko bä mikata kwe. Nire nire käta ti tarere kore, ni ye abko ti Rün tikwe käkwe taredi amne ti ara jire käkwe taredi arato, käkwe ja mikadi gare metre ie, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Abtä Judas (akwa ñakare Judas Iscariote, akwa Judas mdara jire) ye käkwe nieba mda Jesuye: Ti Dänkien, ¿ñobtä makwe ja mikadita tuadre nun aibeye amne ñakare ni jökräye mata niere ye? nieba kwe ie: ");
INSERT INTO gymNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Angwane Jesukwe nieba mda: Nire nire käta ti tarere ye abko tä ti kukwei mike täte amne ti Rün käkwe taredi. Erere arato, ti Rün amne ti, nun jatadi ja gwirie mike ni yebtä. ");
INSERT INTO gymNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Akwa nire nire tä ti tarere ñakare, ni ye abko tä ti kukwei mike täte ñakare. Ti kukwei nuata munkwe, ye abko ñan ti kukwei jen tikwe abko tita niere, akwa ti Rün ti juanka abko kukwei nieta tikwe munye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ye abko, ti tä munbe nete angwane, tita kukwe ne niere jökrä munye kore, ");
INSERT INTO gymNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","akwa mun Die Mikaka Ngöbö Üai Deme juandre ti Rünkwe ti käbti, ye rükadi nüne munbtä angwane, kukwe era Ngöböbtä ütiäte munkrä, erere diridi jökrä kwe munye. Erere arato, tita kukwe niere munye, ye mikadita töre jökrä kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mdakäre abko, kä jäme jen tikwe ti bike mikete munbtä, ye abko ñan nitre nünanka kä nebtä käta kä jäme bien, kwrere jire ti bike bien munye, aisete mun ñan rekwetaka ja jiebti amne munkwe ñan kä jürä ngwian jabtä. ");
INSERT INTO gymNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ti abko bike nikenta, akwa ti rükadita munbe nete, tikwe nini, ye munkwe kukwei nurira. Ye abko, munta ti tarere era metre bkänä ne ngwane, ti bike nikenta kä käinbti ti Rün känti, tikwe nini munye, ye käi rabadre nuäre munbtä, ñobtä ñan angwane ti Rün abko bäri kri tikrä aisete. ");
INSERT INTO gymNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ye abko, tita kukwe niere ne ngämi nakenkä, känenkri tita kukwe jökrä niere munye, akwa rakadrekä angwane, ti kukwei rabadre era munkrä, käkwe tödekadre metre tibti, abkokäre tita niere käne kore. ");
INSERT INTO gymNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Akwa gwängwarbe kä ñan nebera blitakrä kabre dikaro munbe tie, aisete tikwe ñan blitadre kabre mda munbe, ñobtä ñan angwane Satana tä nitre nünanka Ngöbö rüere dänkiene abko kitera ti rüere. Satana abko tä ñakare jire chi ti dänkiene. ");
INSERT INTO gymNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Akwa tita ti Rün tarere abko nitre nünanka Ngöbö rüere ie rabadre gare metre amne ti Rün tä dre nuemna tie, erere tita nuene täte jökrä, ye rabadre gare ietre arato, abkokäre kukwe ye rakadikä kore. Ne aisete, näin krö. Brän. Ari kä mikekä nete, nieba Jesukwe nunye. ");
INSERT INTO gymNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yebti Jesukwe ja bä mikaba uba kökräi kwrere amne nitre tödekaka bti abko bä mikaba uba küdei kwrere kwe, käkwe nieba mda nunye: Ti abra uba kökräi era metre kwrere amne ti Rün abko sribikä uba kökräi yebtä kwrere. ");
INSERT INTO gymNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ye abko, uba küdei mden mden ngwä neme ñakare btä, ye abko ti Rün tä tikekä ta; akwa uba küdei ngwä neme kabre kabre btä, ye abko niarata mutu kiakia aibe tikekä, bti tä bäsekä kuin merebe abko ngwä rabadre bäri kabre btä abkokäre. ");
INSERT INTO gymNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mun abko ie tikwe kukwe niebare, ye munkwe mikani era, käkwe tödekani tibti, aisete kukwe ye köböire mun nena merebe, ngite ñakare Ngöbö ngwärekri. ");
INSERT INTO gymNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mun abko raba nekete janknu ketetibe tibtä amne ti rabadi nekete janknu ketetibe munbtä arato, ñobtä ñan angwane uba küdei tä neketaninte uba kökräibtä aibe angwane ngwäta neme btä; akwa uba küdei kaibe mento uba kökräi bäre, ye ñan ngwä raba neme jire chi btä. Ye kwrere arato, munta ñakare ketetibe tibe, akwa tä ti bäre mento ne ngwane, mun ñan rabadre sribi kuin nuene tikrä amne ni ñakare jire mda käkwe tödekadre tibti mun köböire. ");
INSERT INTO gymNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ti abko uba kökräi era metre kwrere amne mun abko uba küdei kwrere. Nire nire tä nüne ketetibe tibe amne tita nüne ketetibe ben, ni ye abko käkwe sribi kuin nuendi tikrä, köböire ni mda mda käkwe tödekadi Ngöböbti, ye abko uba ngwäta nebe kabre uba küdei kuinbtä ye kwrere. Akwa mun tädre kaibe ti bäre mento angwane, sribi kuin ütiäte Ngöbökrä ñan rabadre bare jire chi munye. ");
INSERT INTO gymNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ye abko, nire nire käkwe ñan nünandre ketetibe tibe, ye abko kitadrekä Ngöbö okwä bäre mento amne, uba küdekrä tikakata tä neme nötare amne ükakröta ketetibe jökrä, bti kukwata, ye kwrere jire Ngöbökwe ni ye kitadi ja okwä bäre mento ja tare nikakäre kärekäre. ");
INSERT INTO gymNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Akwa mun abko käkwe nünandre käre ketetibe tibe amne tita kukwe dirire munye, yebtä munkwe nünandrekä era metre ne ngwane, mun tö raba dre dre käräi Ngöböye, erere munkwe kärä amne biandi kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mdakäre abko, uba ngwäta neme kabre, ye kwrere munkwe sribi kuinkuin nuendi, köböire ni kwati käkwe tödekadre Ngöböbti abko rabadi uba ngwä kabre kwrere, yebtä abko mun ja töitikaka tibe abko rabadi gare metre amne ti Rün rabadi käikitaninkä kri. ");
INSERT INTO gymNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","Ti Rünta ti tarere, ye kwrere tita mun tarere arato. Angwane ti Rün kukwei mikata täte metre tikwe, abtä ti Rünta ti tarere kärekäre tä nüke gare kärekäre tie, ye kwrere jire munkwe ti kukwei mikadre täte ne ngwane, tita mun tarere kärekäre rabadre nüke gare kärekäre munye arato. ");
INSERT INTO gymNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ye abko, munkwe kä ngwiandre bäri nuäre gwaire jabtä tibe amne kä nuäre rabadre täte jökrä munbtä, abkokäre tita blite kore munbe. ");
INSERT INTO gymNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Angwane ti kukwei mikadre täte munkwe abko krörö: Tikwe mun tarebare, ye kwrere munkwe ja tare kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nire tä ja mike müre ketadre kukwe muko diäre, ye ngwane tä kukwe muko tarere era metre abko bä mikata. ");
INSERT INTO gymNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tita dre dre nuemna abko erere munta nuene ne ngwane, mun abko ti kukwe muko tikwe abko bä mikata munkwe. ");
INSERT INTO gymNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ye abko, mun ni klabore tikwe abko tikwe ñan niedre mda, ñobtä ñan angwane ni klabore abko bkänkä tä dre dre nuene, ye gare ñakare ie, akwa ti Rün tä dre dre niere tie, erere tita mike gare jökrä munye, aisete mun abko ti kukwe muko tikwe, tita niere. ");
INSERT INTO gymNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mdakäre abko, ñan munkwe ti dianinkä ja töi jenbti au dirikäre jae, akwa tikwe mun dianinkä ja töitikakäre jabe amne, tikwe mun mikani juandre kwäräkwärä sribire jakrä abko köböire ni mda mda jatadre kabre tödeke tibti abkokäre. Ye aisete, uba ngwäta neme kabre btä, ye kwrere sribi munkwe rabadre abko köböire ni kwati rabadre tödeke kärekäre tibti, abkokäre tikwe mun dianinkä jakrä. Erere arato, tita dre dre nuemna munye, ye kwrere munkwe nuendre ne ngwane, munkwe jändrän ño erere kärädre ti Rünye ti käbti angwane, biandi kwe munye. ");
INSERT INTO gymNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Akwa tita kukwe nuemna munye abko krörö: Munkwe ja tare kwärikwäri abko tita niereta munye, nieba Jesukwe. ");
INSERT INTO gymNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","19","Yebti Jesukwe nieba mda: Nitre nünanka Ngöbö rüere ye ben ketetibe mun tädre, akräke mun rabadre tare kri kwetre. Mun nämane niaratre ngätäite, akwa tikwe mun dianinkä jen jakrä, aisete mtare mun ñan nena nitre nünanka Ngöbö rüere kwrere, aisete tä bätä ngwen munbtä. Nitre nünanka Ngöbö rüere abko käkwe bätä ngwiani käne tibtä, aisete bätä ngwiandi kwetre munbtä arato, ye abko rabadre gare munye. ");
INSERT INTO gymNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Akwa tikwe kukwe nini krörö munbtä, ye munkwe ngwianta töre jae: Ni klabore ye abko ñakare bäri ütiäte niara bkänkäbti ta, tikwe nini munye. Ne aisete ni ruäre tä näin kisere ti jiebti ti mikakäre ja tare nike, ye kwrere arato nändi mun jiebti kwetre mun mikakäre ja tare nike tödekabtä tibti; akwa ni ruäre käkwe ti kukwei mikani ütiäte, ye abko käkwe mun kukwei mikadi ütiäte arato. ");
INSERT INTO gymNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tödekabtä tibti nitre nünanka Ngöbö rüere käkwe kukwe nuendi bätäkä ngwarbe mun rüere, ñobtä ñan angwane Ngöbö ti juanka abko gare ñakare ietre, aisete nuendi kore kwetre munbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ye abko, ti ñan rükadre blite bentre Ngöböbtä akräke kukwe nuenta kwetre, yebtä rabadre ngite ñakare. Akwa ti nükanina blite Ngöböbtä bentre, aisete niaratre ja mike ngite ñakare abko ñan raba niere jire chi jabtä. ");
INSERT INTO gymNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nire nire tä bätä ngwen tibtä, ye abko tä bätä ngwen ti Rünbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Erere arato, sribi kri ñan tuabare, ni mda mdakwe ñan nuenbare jire abko erere ti nükani nuene niaratre ngätäite Ngöböta tibe mikakäre gare, sribi ye abko ti ñan rükadre nuene akräke niaratre tä ja mike ngite, yebtä rabadre ngite ñakare. Akwa sribi kri ñan tuabare tikwe nuenbare abko tuani ja okwä jenbti kwetre, akwa tätre bätä ngwen janknu tibtä amne ti Rünbtä arato. ");
INSERT INTO gymNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Akwa Ngöbö Kukwei krörö rabadre bare, abkokäre niaratreta bätä ngwen kore tibtä amne ti Rünbtä: Ti ja mike ngite ñakare rüere, akwa tä bätä ngwen tibtä, abko tä tikani niaratrebtä. ");
INSERT INTO gymNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Akwa Ngöbö Üai tä ti Rün känti. Niara abko mun Die Mikaka amne tikwe niara juandi munbtä. Ngöbö Üai ye abko kukwe era metre niekä Ngöböbtä amne jändrän jökräbtä abko jatadi ti Rünkri, aisete kukwe era erere niedi tibtä kwe munye, ti mikakäre gare munye. ");
INSERT INTO gymNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Erere arato, tikwe sribi kömikanintbe kena angwane, mun nämane siba tibe abti kä nüke mtare, aisete munkwe kukwe era erere niedi tibtä ni mda mdaye arato, ti mikakäre gare ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Munkwe tödekadre janknu tibti amne munkwe ñan ti gibiarekäta, abkokäre tita kukwe ne niere munye. ");
INSERT INTO gymNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Nitre nünanka Ngöbö rüere käkwe mun kitadikä sinagoga bäre mento, mun ñan rikadre gätäre ketetibe bentre mda abkokäre. Bärire mda abko, kä jatai angwane, nitre ye käkwe mun müre ketadi, akwa niaratre tädi sribi kuin nuene Ngöbökrä rabadi nütüre. ");
INSERT INTO gymNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nitre nünanka Ngöbö rüere abko ie ti Rün gare ñakare amne ti gare ñakare ietre arato, aisete nuendi kore kwetre munbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tita kukwe niere munye, ye kwrere rabadre nakenkä munbtä angwane, tikwe kukwe niebarera käne munye, ye abko munkwe ngwiandreta töre jae, abkokäre tita niere mtare munye. Käne ti jatani sribi kömiketbe angwane, ti nämane ketetibe munbe abti kä nüke mtare, aisete tikwe kukwe ye nieba ñakare käne munye. ");
INSERT INTO gymNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Akwa mtare Ngöbö ti juanka, känti ti bike nikenta rabakäre ketetibe ben, akwa ti bike nikenta mdente mun ngämi ngwentari metre tie. ");
INSERT INTO gymNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Angwane ti bikera nikenta, tikwe nini, abtä mun moto nibi nötöte jirekäbe ja jiebti au, aisete mun nibi ulire ulire jökrä. ");
INSERT INTO gymNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Akwa ti bike kukwe era erere niere munye abko krörö: Ti rikareta ti Rün känti ye abko bäri kuin munkrä, ñobtä ñan angwane ti ñan rikadreta ne ngwane, Ngöbö Üai mun Die Mikaka ñan rükadre nüne munbtä, akwa ti näinta ne ngwane, tikwe niara juandi nüne munbtä. ");
INSERT INTO gymNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ngöbö Üai mun Die Mikaka rükadi angwane, nitre nünanka Ngöbö rüere abko ngite Ngöbö ngwärekri, ye abko mikadi gare kwe ietre amne niaratre ñakare metre Ngöbö ngwärekri mikadi gare kwe ietre arato. Erere arato, nitre nünanka Ngöbö rüere abko kräke Ngöbökwe kukwe ükadite juankäre ngwarbe kä ja tare nikakrä känti abko Ngöbö Üai käkwe mikadi gare ietre, ye ngäniene niaratre käkwe tödekadre tibti, abkokäre kukwe mikadi gare kore ietre. ");
INSERT INTO gymNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ye abko, nitre nünanka Ngöbö rüere abko ngite Ngöböye abko Ngöbö Üaikwe mikadi gare ietre, ñobtä ñan angwane niaratre tä tödeke ñakare tibti. ");
INSERT INTO gymNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Angwane niaratre tä bike metre amne ti abko metre ye ñakare era kräke abko Ngöbö Üaikwe mikadi gare ietre ti diäre, ñobtä ñan angwane ti bike nikenta ti Rün känti kä käinbti, känti munkwe ñan ti tuadita mda. ");
INSERT INTO gymNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Erere arato, nitre nünanka Ngöbö rüere abko kräke Ngöbökwe kukwe ükadite juankäre ngwarbe kä ja tare nikakrä känti abko Ngöbö Üai käkwe mikadi gare ietre, ñobtä ñan angwane Satana tä niaratre dänkiene abko kräke Ngöbökwe kukwe ükaninante mikakäre ja tare nike kärekäre kä ja tare nika känti. ");
INSERT INTO gymNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Mdakäre abko, kukwe mda mda tä kabre tikwe niedre munye, akwa tikwe niedre jökrä angwane, rabadre bäri tare munkrä mtare, aisete tikwe ñan niedre. ");
INSERT INTO gymNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Akwa Ngöbö Üai kukwe era metre Ngöbökwe mikaka gare, ye rükadi nüne munbtä angwane, kukwe era metre jire jökrä tibtä tä dre niere abko niarakwe mikadi gare munye, ñobtä ñan angwane Ngöbö Üai ye käkwe ñan blitadi au jabtä, akwa Ngöbökwe kukwe ño ño niemna tibtä ie, ye aibe mikadi gare kwe munye. Erere arato, kukwe rakadikä ño ja täritäri abko mikadi gare kwe munye arato. ");
INSERT INTO gymNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mdakäre abko, ti abko ütiäte kri amne ti di kri bä nuäre, ye abko mikadi gare kwe munye, ñobtä ñan angwane jändrän tikwe abko niarakwe mikadi gare munye aisete. ");
INSERT INTO gymNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Niara rükadi jändrän tikwe mike gare munye tita niere munye, ñobtä ñan angwane jändrän jökrä tä ti Rünkwe, ye abko jen tikwe arato, aisete Ngöbö Üai rükadi jändrän tikwe mike gare munye tita niere. ");
INSERT INTO gymNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Akwa mtare bä jötrö munkwe ñan ti tuadreta mda, akwa yebti bä jötrö munkwe ti tuadita mda, nieba Jesukwe nun ja töitikaka benye. ");
INSERT INTO gymNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Angwane nun ruäre ja töitikaka Jesube kä rababa niere jae kwärikwäri: ¿Niara tö nibi dre niei nie amarebti nibi ñäke kore nie se? Bä jötrö nikwe ñan tuadreta, nini kwe, yebti bä jötrö angwane nikwe tuadita bobuta, nini kwe. Erere bike nikenta Rün känti, nini kwe. ");
INSERT INTO gymNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Se abko tö nibi dre niei nie amarebti, bä jötrö, nibi niere se? ¿Se abko dre nieta kwe amarebti ñan nebe nüke gare jire chi nie? rababa niere jae kwärikwäri. ");
INSERT INTO gymNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yebtä abko nun tö rababa kukwe ngwiaintari Jesuye abko Jesukwe gaba nunbtä, käkwe nieba nunye: Bä jötrö munkwe ñan ti tuadreta, tikwe nini, bti bä jötrö munkwe ti tuadita, tikwe nini munye, ¿ye abko dre nini tikwe abko munta ngwentari jae kwärikwäri ñan ñan? ");
INSERT INTO gymNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ti bike kukwe era erere niere munye abko krörö: Kä kebera nüke angwane, bä jötrö munkwe ja müaidi amne mun moto rabadi nötöte, akwa nitre nünanka Ngöbö rüere abko btä kä r