﻿USE sofia;
DROP TABLE IF EXISTS sofia.gyl_vpl;
CREATE TABLE gyl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gyl_vpl WRITE;
INSERT INTO gyl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ዳውትተከ አብራሀመታ ሱሳ ማችባብ የሱስ ክርስቶሰታ አጥርንታ ኮችንከስ ኬኔ። ");
INSERT INTO gyl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","አብራሀም ይሳቀም አጬ፥ ይሳቅ ያይቆበም አጬ፥ ያይቆብ ይሁደምከ እስመንንከስም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ይሁዳ ፋረስምኬ ዛሬም ትእማር ጋይምድን ኤተንንዘንካ አጬ፥ ፋርስ ሀስሮንም አጬ፥ ሄስሮንመረ አራምንም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","አራም አምናዳብም አጬ፥ አምናዳብ ነአሶንም አጬ ነአሶነረ ሰልሞንም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ሰልሞነረ ቦኤዝም ረአብ ጋይምድን ኤተንዘንካ አጬ፥ ቦኤዝ እዮበድም ሩት ጋይምድን ኤተንዘንካ አጬ፥ እዮበደረ እሰይም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","እሰየረ ባንችን ዳዊተም አጬ፥ ባንችን ዳውተረ ኦርዮታ ኬነንዘንካ ሰሎሞንም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ሰሎሞነረ ሮብአምም አጬ፥ ሮብአመረ አብያም አጬ፥ አብየረ አሳፍም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","አሳፈረ እዮሳፈጥም አጬ፥ እዮሳፈጠረ እዮራምም አጬ፥ እዮራመረ ኦዝያንም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ኦዛነረ እዮአታምም አጬ፥ እዮአታመረ አካዝም አጬ፥ አካዘረ ህዝቅያሰም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ህዝቅያሰረ ምናሰም አጬ፥ ምናሰረ አሞጽም አጬ፥ አሞጸረ እዮስያሰም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","እዮስያሰረ እስራኤል ዎርሰና ባብሎን ፍጨናሪ ዎእስት ከት ተይምሳን ስለናር እኮንያንምከ ክታ እስመንከስም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ባብሎን ፍጨናርንካ ከት ማቻን ቡር እኮንያን ሰላትያልም አጬ፥ ሰላትያለረ ዘሩባበልም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ዘሩባበለረ አብድዩም አጬ፥ አብድዮረ ኤልያቀም አጬ፥ ኤልያቀረ አዞርም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","አዞረረ ሳዶቀም አጬ፥ ሶዶቀረ አክምም አጬ፥ አክመረ ኤልዮድም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ኤልዮደረ አልዓዛርም አጬ፥ አልዓዛረረ ማታንም አጬ፥ ማታነረ ያይቆበም አጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ያይቆበረ ክርስቶስ ጋይምስባብ የሱሰም አጫን ማራመም ሶርስባብ ዮሴፍም አጬ። ");
INSERT INTO gyl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ይና አብራሀመዘንካ ዳዊት የለልታ ታሜከ ኦይድ አጥሪ፥ ዳውትዘንካ ባብሎን ፍጨናር ዎእስምት ተይምሳን የለልታ ታሜከ ኦይድ አጥሪ፥ ባብሎን ፍጨናር ዎእስምት ተይምሳንዘንካ ክርስቶስ አጥርምተርን የለልታ ታሜከ ኦይድ አጥርዬ። ");
INSERT INTO gyl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","የሱስ ክርስቶሰታ አጥርና ኮግንዴ፥ እንደና ማራመረ ዮሴፍካንታ ሶርምሶ ኮት ዶቅድንካ፥ አⷝነካ የላክዶቆ አያን ጭልንካ ስርሶ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ሶርስባብ ዮሰፍ ላቅም ኤድ ይ ማቻንኦላር፥ ማራመም ኤታ እሪ ኦስንስካንታ ዝጋክዬ፥ ኮካንታ ኖ ኮትም ዛቅካንታ ገቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ኬዛር ማቼ ኮም ሪን ገቅርዘን ክት ዶቅድንካ፥ ጮይስታ ክታይንች Ꮊምስካ Ꮊፈርሶ ኩን ጋይሴ፥ “ዳውተታ ሱሰና ዮሰፎ! የስ ሶርሳን ማራመረ ኮት ስርሳንዳ አያን ጭልንካ ማቻንካንታ፥ ኮትም እንቻካንታ Ꮊይ ጳሴ። ");
INSERT INTO gyl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ና አⷝና ይንች አእተረ፥ ኖየረ ይንታ ዎርሰንም ከታ ጎመናርንካ አቅዝድንካንታ ክታ ላምንመረ የሱስ ጋይተረዬ”። ");
INSERT INTO gyl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ኮነረ ሙዳ ማቻንዳ ጮይስ ኩን ጋይሶ ሳብዘንካ ኤሰርሶ ከዝባብጎካ ኬዝምሳንዳ ቦድምድንግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ኮሰቸቴ፥ አንጃ ሙነክንዳ ስርተረ፥ አⷝና ይንቸረ አእተረ፤ ክታ ላምነረ ‘አማኑኤል’ ጋይምሶ ኤልምተረ” አማኑኤል ጋይንትና “ሳብ ዎንካ ክክኔ” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ዮሴፍ ግንእናርንካ ይ ንግዛንደትካ፥ ጮይስታ ክታይንችና ክትሳንግንዳ ማራመም ይንታ ማና ማስካንታ ይንታ ኤር ተይ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ማታጋካ ዳት፥ ና ይንታ ይንችንም ኮት አእተርን የለልታ ኮትም የላክዬ፥ ክታ ላምንመረ የሱስ ጋይሶ ኤልሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ባንችን ሄሮድሰታ ስለናር፥ ይሁዳ ፍጨናር Ꮊፈርድን ቤተልሄም ካተመናር የሱስ አጠርሳንᎺይካ፥ ቤዝም ሰድሰኮ ጎርስምድባብከስ Ꮊይታ ዉትንታጎካ የሩሳሌም ካተመናር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ኩነረ ጋየረኮ ኦይሰኬ፥ አይሁድንታ ባንች ማትካንታ አጠርምስባብ ኡለና Ꮊብረረ? ቤዝንም Ꮊይንታ ዉትንታጎካ ሰድሶቶ ክትም ጎዝደር Ꮊቶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ባንችን ሄሮድስ ኮሪን ይ ኤሰርሳንደትካ ገቅሴ። የሩሳሌም ካተማ ኤድንከሰረ ሙዳ ክትካ ክክን ገቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ቀሰንከስም ገችዝድባብከስም ሙደንምከ ሙሴታ ህግንም ኤስዝድባብከስም ሳንስሶ ክርስቶስ Ꮊብር ክት አጠርሳናንከረ ከትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ከተረ፥ “ሳብዘንካ ኤሰርሶ ከዛቅባብካ ኩን ጋይድንዳ ቤሪካ ጻፍምሳንካንታ፥ ክርስቶስ አጥርምድንዳ ይሁዳ ፍጫር፥ ቤተልሄም ካተመናሬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘ይሁዳ ፍጨናር Ꮊፈርድንዳ በተልሄሞ! እስታ ዎርሰን እስራኤልም ካርስተርባብከ ጎርስተርባብ የሳርንካ ዉድንካንታ፥ ይሁዳር ዶቅድን አንድር ካተመንከዘንካ Ꮊረከረ የና ቶግዳካዬ’ ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ኮታ ቡሪ ሄሮድስ ቤዝንከስም ሰድሰኮ ጎርስምድባብከስምከ ኤድንከስም ካቼካ ኤልሶ፥ ቤዝና ሰድምሳን ገታ ሰጨን ኦይስሶ ኤሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ኩን ጋይሰረ በተሌሄማር ከትም ኦይቼ፥ “አይሰቶ፥ ኡለንጎካ ኡርስት ኦይስከቴ፥ የᎺፍሳንደትከረ እተረ አይስቶ ክትካንታ እ ጎስተርንግንዳ Ꮊድሰቶ እካንታ ኬዝከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ከተረ ባንችንታ ኬዘንም ኤሰርሳንግንዳ ዉትሰኮ አይሰኬ፥ ይና! Ꮊይንታ ዉትንታጎካ ከት ሰዳን ቤዝና ኡለና ዶቅድን ካርዘን ዎእተርን የለልታ፥ ከታ እሪ አየሮ ከትም ጎርዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ቤዝና ዎእሳንደትም ከታ ይ ሰዳንደትካ አንድር ጉርምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ኤሄናረረ አርድሰኮ ኡለንም እንደን ማራመካ ክክን ሰደኬ፥ ጉፕን ጋይሰኮ ክትካንታ ጎስትሰኬ፥ ከታ ይንታ ሳጥንንከስም ፎችሰኮ ዎርቀን፥ እጣንንምከ ሳየርስንካ ኡርማ ዎዝድን እመንም እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ሄሮድሰደረረ ከት ማዳክንግንዳ ሳብ Ꮊምስካ ከትም ኤግዝምሳንካንታ፥ አብ ጎግካ ከታ ይንታ ፍጨናር ማትሰኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ቤዝንከስም ሰድሶ ጎርስምድባብከስ አይሳንደታ ቡር፥ ጮይስታ ክታይንችና ዮሰፍካንታ Ꮊምስካ መያ ማትሶ፥ “ሄሮድስ ኡለንም ደይሳካንታ ዝግድንኦል፥ አምሰዮ ኡለንም እንደንካ ክክን የድሰዮ ግብጽ ፍጨናር አይሳዮ አጥምካ፥ እ የስም ኬዝተርን የለልታ ኮታር ዶእካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ኮካንታ ዮሴፈረ ሶይትካ አምስንደትከ፥ ኡለንም እንደንካ ክክን የድሶ፥ ግብጽ ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ኮታረረ ሄሮድስ ደእተርን የለልታ ዶቅሴ፥ ኮነረ ማቻንዳ ሳብዘንካ ኤስርሶ ኬዛᎺቅባብካ “እስታ ይንችን ግብጽ ፍጨናርንካ ኤልሳቴ” ጋይሳን ጮይስታ ቃለና ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ኮታ ቡሪ ሄሮድስ፥ ቤዝንከስም ሰድሶ ጎርስምድባብከስ ክትም ከት ገስሳንደትም ኖ ይ ኤሳንደትግንዳ፥ አንድር ኖ ዋጬ፥ ቤተሌሄም ካተመናርከ ኮታ ካንተንከረ ዶቅድን ሞረንከስ ሙደናር ይንታ ዳምንባብከስም ኦይትሶ፥ ቤዝንም ሰድሰኮ ጎርስምድባብከዘንካ ይ ኤሳንዴት ግንዳ፥ በተሌሄማርኬ ኮታ ካንተካ ዶቅድን ሞረንከሳር ከት አጠርስንካ ቃስተን ስላ ማችባብከስምኬ ኬታ ታመካ ዶቅድን አⷝና ይንች ሙደንም ኖ ደይስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ኮታይካ፥ ሳብዘንካ ኤሰርሶ ኬዝባብ ኤርማሰካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ራሄል ይንታ ይንችንከስካንታ ኤብድንካ፥ አንድር ሞርእኬ ኤፍካ ራማ ካተመናር ኤስምሴ፥ ኮታ ይንችንከሰረ ደእሳንኦል ዳንዳእካንታ ና ማታክዬ” ኩን ጋይምሶ ኬዝምሳንዳ ቤርና ቦድምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ሄሮድስ ደእሳን ቡር ጮይስታ ክታይንችና ግብጻር ዮሰፍካንታ Ꮊምስካ መያ ማትሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ኡለን ደይሳካንታ ዝግድን ኤድንከስ ደእሳንካንታ፥ አምሳዮ ኡለን እንደንካ ክክን የድሳዮ፥ እስራኤል ፍጨናር አይካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ዮሰፈረ አምሶ ኡለንም እንደንካ ክክን የድሶ፥ እስራኤል ፍጨናር ማት Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ኬዛርካ ማቼ አርኬላዎስ ይንታ ባቤን ሄሮድሰታ ካርናር ይሁዳ ፍጨንዘን ክት ባንችምሳን ይ ኤሰርሳንደትካ፥ ዮሰፍ ኮታር አይካንታ ጳሴ። ማችንከረ Ꮊምስካ ክትካንታ ክታ እምምሳንጎካ፥ ገሊላ ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","“ናዝረት ፍጨናርንክንባቤ ጋይምተሬ” ጋይምሶ ሳብዘንካ ኤስርሶ ኬዛቅባብከስካ ኬዝምሳንዳ ቦድምድንግንዳ ናዝረት ጋይምድን ካተመናር Ꮊድሶ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ኮትᎺይካ ስእስንባብ ዮሀንስ ይሁዳ ዶቅድን ዴል ቆቼናርጎካ ሳባከሮ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ኖ ኤስዝደረ “ጭላ ባንችምና የልሳንካንታ የንታ ጎማ ፍክስን ዎይስከቴ” ጋይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","“ ‘ጮይስንታ ጎግን ግግስከቴ፥ ሉላ ማስሶ ኡርስከቴ!’ ጋየሮ ዴል ቆቼናር ፍብድን ኤታ ኡፍስ” ጋይሶ ሳብዘንካ ኤስርሶ ኬዝባብ ኢስያስ ኬዛንዳ ክት ዮሀንስጎካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ዮሀንሰታ አፍለና ግመልታ ስጭዘንካ ፍክስምሳንዳ Ꮊቄ፥ ይንታ ዎክጫምናረረ ጋመዘንካ ኡርሰርሳን ሳቅ ሶቆርድ Ꮊቄ፥ ክታ እችምነረ ኤይከንከ ባእተታ ኩር Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ኮታይካ የሩሳሌም ካተመናርኬ ይሁዳር ዶቅድን ፍጨናርንካ፥ ዮርዳኖስ ሎቀንታ ካንተካ ዶቅድን ፍጫ ሙደናርንካ ኤድንከስ ዮሀንሰደር Ꮊድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ኬታ ይንታ ጎመንመረ ቡጨረኮ፥ ዮርዳኖስ ሎቀናር ዮሀንሰታ አንካ ስኤርድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ኬዛርካ ማቼ፥ ዮሀንስ ፈረሳውያን ኤድንከሳርንከ ሰዶቃውያን ኤድንከሳርንካ በድንከስ ስእርካንታ ክደረ ኬት Ꮊድንካ ይ ሰዳንደትካ፥ “የታ ጉን ፉይንታ ይንችንከሶ! Ꮊድን ሳብታ ዋጭንዘንካ የ ሱርተርንግንዳ Ꮊይ የም ኤግዝምሳራ? ");
INSERT INTO gyl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ይና የንታ ጎማፍክስን ዎይስን ሰችዝድን ፍክስን ፍክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘ዎታ አብራሀመታ ይንቾቴ’ ጋይንተካ የ ሱርድን የንደር Ꮊይካማ፥ ሳብ ከትኬ ሰይንንከሳርንካ ክት አብራሀምካንታ ይንች አምስካንታ ማዴ እታ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ይና ታ ማቼ ካልተና Ꮊቀንም ፋክካንታ ጎይናር ግግምቴ። ኮካንታ ኡርማ አፍ ኡዝዳክን Ꮊቃ ሙደና ፋክምሶ ኖሄናር ኦይትምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ይና፥ እታ የ ጎማ ፍክስን ዎይስዝድንግንዳ ሎቀካ የም ስእድቴ፥ እስታ ቡርጎካ Ꮊድባብ ማቸ አያን ጭልንከ ኖሄካ የም ስእተረ፥ ኖ እዘንካ አንድር ስገዴ፥ እታ ክታ ዱትንታ ጫመን ዎራ ባላካንታ ዝግዝድባብ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ጋልደጵነረ ክታ አንናሬ። ኖየረ ይንታ ቆይደንም ቦድሶ ኡርስተሬ። ይንታ ዘርግንመረ ቡለናር ኦይተሬ፥ ምሰንም ማቼ ካይዳክን ኖሄካ አችዝዴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ኮታይካ የሱስ ዮሀንሰታ አንያር ስእርካንታ፥ ገሊላ ፍጨናርንካ ዮርዳኖስ ሎቀናር Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ዮሀንሰረ “ኮና ማታዬ፥ እታ የስታ አንያር ስእር እም ዝግዝድንካ፥ Ꮊስግንደስ የና እዝደር Ꮊዳ!” ጋየሮ ማር ክትም የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","የሱስ ማቼ “ጭለትቼንታ ፍክስን ሙዳ ኮግንደካ ቦድ ዎም ዝግዝድንካንታ፥ ታ ዛእካ፥ ኮግንዳ ኩን ማታ” ጋይሶ ክትካንታ ማስሴ። ዮሀንሰረ ክታ ጋይተንካ ኤእሶ የሱሰም ስእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","የሱሰረ ስኤርሶ ሳነካ ሎቀናርንካ ክት ዉተዳንግንዳ ጭላ ፎችምሴ፥ ሳብታ አያንነረ ዎሌታ ካምስካ Ꮊንቸርሶ የሱሰዘን ዶቅድንካ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ኮታይካ “ይና፥ እታ ክትካ እ ጉርምድባብኬ እ ሶልምድባብ እስታ ይንችና ኖ ኮኔ” ጋይድን ኡፍስ ጭላርንካ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ኮታ ቡሪ፥ የሱስ ዳብሎሴካ ጰጭምካንታ ሳብታ አያንና ክትም ዴል ቆቼናር ተይ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ኮታረረ ቃስቴን ቦንዳ Ꮊየኬ፥ ቃስቴን ቦንዳ ሶይት፥ በቼካ ይ ምክሳንደታ ቡሪ ዳቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ጰጨንባብ የሱሴደር Ꮊድሶ፥ “የና ሳብታ ይንች የስ ማቼ፥ ይና ኬና ሰይንንከስ እችም ማድንግንዳ ክትካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","የሱስ ማቼ “ ‘ኤድ ሳብታ አፋርንካ ዉድን ቃላ ሙደንካ ዳት እችምካ Ꮊክ ዶቃዬ’ ጋይምሶ ጭል ማጻፍናር ጻፍምቴ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ኮታ ቡሪ፥ ዳብሎስ የሱሰም ሳብካንታ ፋስምሳን የሩሳሌም ካተመናር ተይ አይሶ ሳብታ ጭል ኤሄንታ ዱረዘን ዎይስሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ ‘የስታ ዱትንከስ ሰይንካ ጎሄርዳክንግንዳ፥ “ ‘ኬታ ይንታ አንካ የስም ዳቅስተርንግንዳ ኖይንታ ክታይንችን የስካንታ ክዴ’ ጋይምሶ ጭል ማጻፍናር ጻፍምሳንካንታ የና ሳብታ ይንች የስ ማቼ፥ ኮዘንካ የስታ ማተን ጩላ ማስሶ ቡከልካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","የሱሰረ “ ‘የስታ ጮይስ ሳብንም Ꮊይ ጰጬ’ ኩን ጋይምሶ ጭል ማጻፍናር ጉጅሶ ጻፍምቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","አናካርንከረ ዳብሎስ የሱሰም አንድር ጬክን ጋይሳን ገቼንዘን ዉችሶ፥ ኮ ፍጫሙደንታ ባንችንከስም ሙዳ ከታ ቦንቼንካ ክክን ክትም ሰችሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ይርክን ጋይሳዮ እካንታ የስ ጎስትሴ ኮም ሙዳ የስካንታ እምድቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ኮትᎺይካ የሱስ “ ‘የስታ ጮይስ ሳብንካንታ ጎስትካ፥ ክትም Ꮊክ ጎይንካ!’ ጋይምሶ ጭል ማጻፍናር ጻፍምሳንካንታ የና ሰጣን ጎተርካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ኮታቡር ዳብሎስ የሱሰም ዛቅሴ፥ ክታይንችንከሰረ Ꮊድሰኮ ክትም አሌን አልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","የሱስ ዮሀንሰታ ዞክርን ይ ኤሰርሳንደትካ ገሊላ ፍጨናር ማት አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ናዝርት ካተመን ዛቅሶ፥ ዛብሎናርኬ ንፍታሌም ፍጨና ገሊላ ባሀርንታ ላማር ዶቅድን ቅፍርናሆም ካተመናር Ꮊድሶ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ኮነረ ማቻንዳ፥ ሳብዘንካ ኤስርሶ ኬዛቅባብ ኢስያሰካ ኩን ጋይምሶ ቤሪካ ኬዝምሳንዳ ቦድምድንግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ባሃርናር ተይ አይድን ጎግንከ ዮርዳኖስ ሎቀንታ ፋማ፥ Ꮊፈርድባብከስ ዛብሎን ፍጫ፥ ንፍታሌም ፍጫ፥ አይሁድ ማታክን ገሊላ ኤድንከሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ኡማር ዶቅድባብ ዎርሰና አንድር ሳክመን ሰጀኬ፥ ደእታ ስፍት ስፍሳን ፍጨናር ዶቅድባብከስካንተረ ሳክመና ከትካንታ ዉተዴ።” ");
INSERT INTO gyl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ኮታዘንከረ የድሶ የሱስ፥ “ጭላ ባንችምና ቅንችቴ ጎማ የንታ ፍክስን ዎይስከቴ!” ጋየሮ ሳባክ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","የሱስ ገሊላ ባሀርንታ ላመካ ስገድንካ፥ ሞለን የድባብከስ ቃስተን እስመንኬ ካንስካ ከተረ ጴጥሮስ ጋይምስባብ ስምኦንኬ እስመን እንድራሰካ፥ ከታ ይንታ ሞለን የድን ሳከን ባሀርናር ከት ኦይድንካ ኖ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","የሱሰረ “ኮረቴ፥ እም ጎርስምከቴ፥ ሞለን የ የድንደትግንዳ ሙዳ ኤድንከስም ሳብታ ባንችምንካንታ የ ሳንስተርንግንዳ የም ይትቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ከተረ ሳነካ ይንታ ሞለን የድን ሳከን ዛቅሰኮ ክትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ኮታዘንከረ ኦሳ አይሶ፥ አብ ቃስተን እስመንኬ ካንስካ ዛብዶሰታ ይንችን ያይቆብምኬ ዮሀንስምካ ሰዴ። ከተረ ይንታ ባቤን ዛብዶሰከ ክክን ሎቀንዘንካ ቃልዝድን ጃልበንዘን ዶቅሰኮ ሞለን የድን ሳከን ከት ኡርዝድንካ ኤልሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ከተረ ሳነካ ጃልበንምኬ ይንታ ባቤንም ዛቅሰኮ የሱሰም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","የሱሰረ አይሁድንከስታ ምክስ ኤሄናር ኤስሰሮ ሳብታ ባንችምንታ ክላ ኬዛ ቃለን ሳባከሮ፥ Ꮊክ Ꮊክ ሰቅምከ Ꮊዝምካ የደርስባብ ኤድንከስም ፋቸሮ ገሊላ ፍጫ ሙደናር ኦንግድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ክታ ይተና ሶርያ ፍጫ ሙደናር ኤስምሳንካንታ፥ ኤድንከስ Ꮊክ Ꮊክ ሰቅምከ Ꮊዝምካ ማጠርድባብከስም፥ ቱና አያንካ የደርስባብከስም፥ ባልት ዛቅድን ሰቅም ዶቅድባብከስምኬ ዎብንከስም ሙዳ ክደር ተይ Ꮊደኬ፥ ኖየረ ከትም ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ገሊላ ፍጨናርንኬ ታማ ካተመናርንካ የሩሳሌማርንኬ፥ ይሁዳርንካ፥ ዮርዳኖስ ሎቀንታ ፋመንካ Ꮊድባብ በድ ኤድንከስ የሱሰም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","የሱስ ይም ጎርስምድባብ በድ ዎርሰንም ይ ሰዳንደትካ፥ ገቼንዘን ዉትሶ ዶቅሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ክደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ኩን ጋየሮ ከትም ኤስስ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ጭላ ባንችምና ከታ ማቻንኦል አያናር ዶቅንተካ፥ “ሳብም ዝገሮ ዎቸርድባብከስ ኬታ አንጅምስባብከሰኬ”። ");
INSERT INTO gyl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ሳብ ከትካንታ ዳቅንተን እምድንካንታ ሞርእድባብከስ አንጅምስባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ይንታ ማተን ይርክሳ ይድባብከስ ሳብ ከትካንታ ግግሳን ፍጨን ተይድባብ አንጅምስባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ጭለትችን ዳቀርድባብከስኬ ዎቸርድባብከስ ከት ምዝድንካንታ፥ አንጅምስባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","አብንከስካንታ አጨርድባብ አንጅምስባበኬ፥ Ꮊረታ ጋይሴ ሳብ ከትካንታ አጨርድንኦሌ። ");
INSERT INTO gyl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ቡዳ ጭለጭልንከስ አንጅምስባብኬ፥ ሳብም ሰተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ኤድምዝድባብከስ አንጅምስባብከሰኬ፥ ሳብታ ይንች ጋይምደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ጭለትቼንጎካ ዳየርምድባብከስ፥ ጭላ ባንችምና ከትካንታ ማቻንኦል፥ አንጅምስባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“እጎካ ኤድንከስ የም የግድንከኬ የም ዳያ ኦንግድንካ፥ ዳቅልንም ማልትካ የንታዘን ኬዝድንካ አንጅምስባበቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ጭላር የᎺብድን ናክና የካንታ አንድር ኮት ማቻን ኦል የም ጉርምሳ፥ አንድር ጉርመረ ይከቴ። ኤና የንታ እረረ Ꮊቅባብ ሳብዘንካ ኤሰርሶ ከዛቅባብከዘን ኮትኮግንዳ ዳይርምንከ ማጠንም የልስተኬ።” ");
INSERT INTO gyl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ኮታዘንከረ የሱስ፥ “የታ ፍጨዘን ሶቅንግንደቴ፥ ኬዛርንካ ማቼ ሶቅ ሎቅክሳ ነገዴ ና ካርንካ Ꮊስግንዶክ ሎቅካንታ ማዳ? ኦስ ማል ኦይትምሶ ኤታ ዱትያር ሙክምዘንካ አብ ኦስ እር Ꮊራርካንተረ መያዬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“የታ ኮ ፍጫሙደንታ ሳክመቴ፥ ገቼዘን ዶቅድን ካተመና አችምካንታ ማዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ኤድንከስ ዞጰን ዞጵስትዮ ኤሄናር ዶቅድባብ ሙደንካንታ ሳግድንግንዳ ጬክን ጋይሳን ካርዘን ዎደክ ዳት ዞጰን ዳሄታ ዋር ዎዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ኮትኮግንደረ ኤድንከስ የንታ ኡርማ ፍክስን ሰድሰኮ ጭላር የንታ ባቤንም ከት ጋለድንግንዳ፥ የንታ ሳክመነረ ኤታ እሪ ሳካ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","ጉጅሰረ የሱስ “ሙሴታ ህግንምኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ኤስስን ነግስካንታ እ Ꮊዳንዳ የንደር Ꮊይካማ፥ ከት ቦድምድንግንዳ ይስካንታ እታ Ꮊዳት ዳት ነክስካንታ Ꮊዳክቴ”። ");
INSERT INTO gyl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ዶፈን የም ጋይድቴ፥ ጭለኬ ፍጨካ ስገተርን የለልታ ሙሴታ ህግና ሙዳ ቦድምተር ዳት ህግናርንካ ዋልቃ ፍደል አነረ ዋልቃ ጩት ዎራ ነጋዬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ኮካንታ ከትከ ክተንከሳርንካ መራ ማቻን ዋልቀን ዎራ ዉልእድባብኬ አብ ኤድንከሰረ ኮትኮግንዳ ከት ይድንግንዳ ኤስዝድን ኤድ ጭላ ባንቺምናር መራ ጋይምተሬ። ኬዛርንካ ማቼ ክተነከስም ሙዳ ቦድባብኬ አብ ኤድንከሰረ ኮትኮግንዳ ከት ቦድንግንዳ ኤስዝድባብ ኤድ ጭላ ባንችማር አንድር ጋይምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ኮካንታ የንታ ጭለትችና ሙሴታ ህግን ኤስዝድባብከዘንኬ ፈረሳውያን ኤድንከስታ ጭለትችንዘንካ ስጋክንዳ ማቼ ቦድሶ ጭላ ባንችማር የ አርዳክንደትም እታ የካንታ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ኤና እሪ Ꮊቃን ኤድንከስካንታ ጋየርሳንደትም የታ ኤሰርተቴ፥ ኮነረ፥ ‘ኤድም Ꮊይ ደይሴ፥ ኤድም ደይስባብ ፋረድምዴ’ ጋይድንዴ”። ");
INSERT INTO gyl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","እታ ማቼ የም ጋይድቴ፥ ይንታ እስመንዘን ዋጭድባብ ሙደና ፋረድምዴ፥ አነረ ይንታ እስመንም የና መይዳክባብ! ጋይሶ የግድባብ ሙደንዘን አይሁድንታ ቡጫ ጋልተንከስ ክታዘን ፋረተረኬ፥ ቱንይ! ጋይሶ የግድባብ ሙደና ድግዳክን ኖሄካ ፋረድምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“ኮካንታ የና የስታ እመንም ሳብታ ኤሄናር ካሰርድን ካርዘን ሳብካንታ የስ እምድን Ꮊይካ፥ የዘን ይምኤርስባብ እስመና ዶቅድንደትም የስም ገቀርሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","የስታ እመንም ካስ ካርንታ እሪ ዎድሰዮ አይካ፥ እርምሳዮ ክትኮ የስታ እስመንካ ክክን ኤድምካ፥ ኮታ ቡር ማትሳዮ የስታ እመንም እምካ። ");
INSERT INTO gyl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","የስታ ይምኤንባብ የስም ካሰስንካ ክትካ ክክን ፍርድ ኤሀር አያዶቅዳዮ ጎግዘን ሳነካ የስታ ይምኤእንባብካ ክክን ኤእካ። ኩን ማታክንዳ ማቼ የስታ ይምኤንባብ ዳይነንካንታ፥ ዳይነነረ ዞግድባብካንታ ስክስት እምሳንደታ ቡር ዞክና ኤሀር ዞከርዳዬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ዶፈን የስም ጋይድቴ፥ የስታዘን ፋረጃን በእንታ ሳንትምን ናክት የስ በይስተርን የለልታ ቦድሰረ ኮታርንካ ዉዳካዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ ‘Ꮊይበልመቴ!’ ጋይምሳንደትም የታ ኤሰርተቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","እታ ማቼ የም ጋይድቴ ‘ማነም ሰድሶ አንገርስባብ ሙደና፥ ኮትᎺይካ ይንታ ቡዳር ኮትካ ክክን ቤልምቴ’ ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","የስታ ምዝ አፍና ጎመታ ጎግ ኮት ማዴ፥ ዉችተዮ ዛእካ! የስታ ኤደትቸና ሙደና ድግዳክን ኖሄናር ኦይትምተርንዘንካ የስታ ኤደትቸናርንካ ዋልቀና ካይደስናና የስካንታ ኡርሜ። ");
INSERT INTO gyl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","የስታ ምዝ አንና ጎመታ ጎግ ኮት ማዴ፥ ተችት ዛእካ! የስታ ኤደትች ሙደና ድግዳክን ኖሄናር ኦይትምተርንዘንካ የስታ ኤደትቸናርንካ ዋልቀና ካይደስናና የስካንታ ኡርሜ”። ");
INSERT INTO gyl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ይንታ ኬነንም ቡልድባብ ሙደና ኮት ቡልምሳንደታ ማርካትች ዋርቀትን ኮትካንታ እምማ” ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","እታ ማቼ የም ጋይድቴ፥ “ቤልምንጎካ ማታክንዳ ማቼ፥ ይንታ ኬነንም ቡልድባብ ሙደና ኮት ቤልምድንግንዳ ይዴ፥ ቡልምሳንደትመረ እንጅድባብ ሙደና ቤልምባብ ማዴ።” ");
INSERT INTO gyl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ጉጅሰረ ኤና እሪ ኤድንከስካንታ “ካርከካ Ꮊይ ጫቀቴ፥ ኬዛርንካ ማቼ የንታ ጫቀንም ጮይስካንታ ቦድከቴ” ጋይምሳንደትም ኤሰርተቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","እታ ማቼ “ቦድሰረ Ꮊይ ጫቀቴ” የም ጋይድቴ። ጭለና ሳብታ ዶቅንት ጎንጋ ኮት ማቻንካንታ፥ ጭለከረ Ꮊይ ጫቀተ፥ ");
INSERT INTO gyl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ፍጨነረ ጮይስታ ዱትንታ ዎእንትንዳ ኮት ማቻንካንታ ፍጨከረ Ꮊይ ጫቀቴ፥ አንድር ባንችንታ ካተማ ኮት ማቻንኦል የሩሳሌም ካተመንከረ Ꮊይ ጫቀቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","የስታ ማተናርንካ ዋልቀን ዎራ ጫምሳ አነረ ጫልም ማስካንታ የስ ማዳክንካንታ የስታ ማተንከረ Ꮊይ ጫቄ። ");
INSERT INTO gyl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ኮካንታ የንታ ኬዘና “ይያ” ማቼ “ይያ” አነረ “ዋአ” ማቼ “ዋአ” ማታ። ኮዘንካ ስግዳንዳ ዳቅልንዘንኬ። ");
INSERT INTO gyl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ ‘አፍታ ካርያር አፍ፥ አችታ ካርያር አች’ ጋይምሳንደትም ኤሰርተቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","እታ ማቼ ዳቅልን የንዘን ይድባብ ኤድንዘን Ꮊይ ይምኤርቴ። ኬዛርንካ ማቼ ምዝ የስታ ከቼንም ጫቅድባብካንታ የስታ ከች ከቼንም ክትካንታ ስርስካ። ");
INSERT INTO gyl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ዋልቃ ኤድ የስታ ሳምዝንም ተይካንታ ዝግሶ የስም ክት ካሰሴ፥ የስታ ኮትንም ክት ተይድንግንዳ ዛእካ። ");
INSERT INTO gyl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ዋልቃ ኤድ ‘እንካ ክክን ቶክም ጎግ አይካ’ ጋይሶ የስም ማእሴ፥ የና ማቼ ኮታዘን ኮትከካ ጎግ ክትካ ክክን አይካ። ");
INSERT INTO gyl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","የዝደር ምግዝድባብካንታ እምካ፥ የዝደር ታልቃ ዝግድባብካንታ ዋይዬ Ꮊይ ጋዬ”። ");
INSERT INTO gyl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ኮታዘንከረ የሱስ፥ “ ‘የስታ ላኮይትን ሶልምካ፥ የስታ ይምኤንባብም ግርካ’ ጋይምሳንደትም ኤሰርተቴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","እታ ማቼ የንታ ይምኤንባብከስም ሶልምከቴ፥ የም ባድባብከስም አንጅከቴ፥ የም ግርድባብከስካንታ ኡርማ ይከቴ፥ ዳቅልን የንዘን ይድባብከስካንተከ የም ዳይድባብከስካንታ ምክስከቴ” እታ የም ጋይድቴ ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ኮም የ ይዴ፥ ጭለናር ዶቅድን የንታ ባቤንታ የታ ይንች ማተረቴ። ኖ ዳቅልንከስካንተኬ ኡርመንከስካንታ Ꮊይንም ዉችዝዴ፥ ኮትኮግንደረ ጭልንከስካንተኬ ጎመንባብከስካንታ ዶብንም ቃንዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","የም ሶልምድባብከስም Ꮊክ የ ሶልምደ Ꮊራ ናክ የንታ ዶቅዳ? ቃረጭን ተችዝድባብከስ ኮትኮም ይደክ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","የንታ እስመንከስካንታ Ꮊክ አቦ የ ጋይድንዳ ማቼ Ꮊረንት ስገዳን ሪ ይዳ? አይሁድ ማታክባብከስ ኮትኮም ይደክካዮ? ");
INSERT INTO gyl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ኮካንታ ጭለናር የንታ ባቤና ቦድማ ማቻንግንዳ የተረ ቦድማ ማትከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ኮታዘንከረ የሱስ፥ ኤድ ዎም ሰዳ ጋይሶ የንታ ኡርማ ፍክስንም ኤታ እሪ ይይንተዘንካ ካርስምከቴ፥ ኩን የ ይያክንዳ ማቼ ጭለናር የንታ ባቤንደርንካ እምምድንደትም ናክን Ꮊብዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","ኮካንታ ሪንካየንባብካንታ እመንም የ እምድንᎺይካ፥ ኦትረንባብከስ ምክስ ኤሄናርኬ ጎግካ ኤድ ከትም ቦንጅድንግንዳ ጋይሰኮ ከት ይድንግንዳ የተረ Ꮊይ ጬቀቴ፥ እታ የም ዶፈን ከዝድቴ፥ ከታ ይንታ ፍክስንታ ናክንም እርምሰኮ ተይተኬ። ");
INSERT INTO gyl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","የና ማቼ ሪካየንባብከስካንታ እምድ ዶቆ የስታ ምዝ አንና ይድንደትም ከች አንና የስታ Ꮊይ ኤሳ። ");
INSERT INTO gyl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ይና የስታ እመና አቸካ ማታ፥ አቸካ የስ ፍግዝድንደትም ሰድባብ፥ የስታ ኡርማ ፍክስንታ ናክን ኖ ናግዴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“የ ምግዝድንደትᎺይካ ኮ ኦትረንባብከስግንዳ Ꮊይማተቴ! ኬታ ኤድ ከትም ሰድንግንዳ ጋይሶ አይሁድንታ ምክስ ኤሄናርኬ ጎግንታ ካንታር ዎእሶ ኬታ ምክስካንታ ሶልምደኬ። ዶፈን የም፥ ጋይድቴ ኬታ ይንታ ናክንም ተይተኬ። ");
INSERT INTO gyl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","የና ማቼ ምግዝድዮ ኤሄንታ ዋር አርድካ፥ የስታ ፍልተንም ዝጭሳዮ፥ ግፋር ዶቅድን የስታ ባቤንደር ምክስካ አቼካ ፍክስምሳን ሰድባብ የስታ ባቤና የስታ ኡርማ ፍክስንታ ናክንም ናግዴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“የታ ምግዝደቶ አይሁድ ማታክባብከስግንዳ፥ ዉችኩን ማዳክንደትም ካርንካ ካርንካ Ꮊይ አፈረቴ፥ ከታ ካርንካ ካርንካ ጋይተታ በድምካ ሳብ ከታ ምክስን ኤሰርድን ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","የታ ማቼ፥ የንታ ባቤና የካንታ ዝግዝድንደትም ሪን አክ ክትም የ ምክሳክናና እርምሶ ክት ኤዝድንካንታ ከትግንዳ Ꮊይማተቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ኮካንታ የታ ኩን ጋይሶ ምክስከቴ፥ “ጭላር ዶቅድባብ ዎንታ ባቤኖ! የስታ ጭል ላምና ቦንችማ፥ ");
INSERT INTO gyl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","የስታ ባንችምና Ꮊዳ፥ የስታ ጋይተና ጭለናር ማቻንግንዳ፥ ኮትግንደረ ፍጨዘን ማታ፥ ");
INSERT INTO gyl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ሰጨንታ እችምን ታካ ዎካንታ እምካ። ");
INSERT INTO gyl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ዎተረ ዎም ባችስባብም ነጋ ዎ ጋይድንግንዳ፥ ዎንታ ባችንም ነጋ ጋይካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ዳቅልዘንካ አቅስካ ዳት፥ ኦስ ጰጭምናር ዎም Ꮊይ አርችሴ፥ ባንችምና፥ ዎልቀኬ ቦንቼካ ስለንክንደታ የስቴ፥ አምንኤ”። ");
INSERT INTO gyl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ኤድንከስታ ጎመንም ነጋ የ ጋይዴ የመረ ጭላር የንታ ባቤና ነጋ ጋይተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ኤድንከስታ ጎመንም ነጋ የ ገይዳክንዳ ማቼ፥ የንታ ባችንመረ ጭላር የንታ ባበና ነጋ ጋያዬ።” ");
INSERT INTO gyl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","የሱሰረ፥ “በቼካ የ ምግዝድንደት Ꮊይካ፥ ከታ በቼካ ምክስንም ኤድንከስ ኤዝድንግንዳ፥ ከታ ይንታ ባለንም ኦግድባብ ኦትረንባብከስግንዳ የንታ ባለንም Ꮊይሱልሰቴ፥ ዶፈን የም ጋይድቴ፥ ከታ ይንታ ናክንም ተይተኬ። ");
INSERT INTO gyl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","“የና ማቼ በቼካ የስ ምግዝድንደትᎺይካ የስታ ባለንም ስኤርካ የስታ ማተንመረ ሳየርካ። ");
INSERT INTO gyl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ኮግንደካ የስታ በቼካ ምክስንም ግፋር ዶቅድባብ የስታ ባቤንዘንካ አብ Ꮊየነረ ኤዝዳክዬ፥ ግፋር ፍክስምሳንደትም ሰድባብ የስታ ባቤነረ መየካ የስካንታ ናክተሬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ጉጅሰረ የሱስ፥ “ብልኬ ቡይካ ካይዝድን ካርዘን ድብንከሰረ ቁንጭሶ ድብድንደታር፥ ኮ ፍጨዘን የንታ ማታ ካንታ ቆልመን Ꮊይ ሳንሰቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ስግስሰረ ብልኬ ቡይካ ካይስካንታ ማዳክን ካርዘን፥ ድብንከሰረ ቁንጭሶ ድብዳክን ካርዘን ጭላር የንታ ቆልመንም ሳንስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ቆልመና የስታ ዶቅድን ካርዘን የስታ ቡደነረ ኮታር ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ኤደትቸንታ ሳክመና አፍዬ፥ ኮካንታ የስታ አፍና ኡርማ ማቼ፥ የስታ ኤደትቸና ሙዳ ሳክማ ማተረ፥ ");
INSERT INTO gyl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","የስታ አፍና ሰቀርድንዳ ማቼ፥ የስታ ኤደትቸና ሙዳ ኡም ማዴ። ይና የሳር ዶቅድንዳ ሳክመና ኡም ኮት ማቼ ኡምና Ꮊስግንዶክ እንድንካ ኡምሳንዳ ማተራ! ");
INSERT INTO gyl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ዋልቃ ኤች ቃስቴን ማታ ቆልስባብከስታ ፍክስንባብ ማትካንታ ማታዬ፥ አነረ ዋልቃባብም ግርዴ፥ ዋልቃባብንም ሶልምዴ፥ አነረ ዋልቃባብንም ቦንጅዴ፥ አብንመረ ቶጅዴ፥ ኮትኮግንደረ ዋልቃ ኤድ ዋልቃዱት ሳብካንተኬ ብራካንታ ፍክስንባብ ማትካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ኮካንታ ኩን የም ጋይድቴ፥ ‘Ꮊሮንት እችቴ? Ꮊሮንት ዎጭቴ? Ꮊሮንት ቆበርቴ?’ ጋይሰቶ የንታ ገች Ꮊቅንጎካ Ꮊይ ማጠረቴ፥ እችምዘንካ ሰንፓ፥ አፍለዘንከረ የንታ ኤደትቸና ስጋዮ? ");
INSERT INTO gyl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ይና ጭለዘን ፈድን አፍትንከስም ሰድከቴ፥ ከታ ማሳ ካዬ፥ ስካየኬ፥ ቡላር ኦይታየኬ፥ ኬዛርንካ ማቼ ጭላር የንታ ባቤና ከትም እችዝዴ። ይና የታ አፍትንከዘንካ አንድር ስግደት ካዮ? ");
INSERT INTO gyl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ማችንከረ የንታ ዌክያርንካ ማጠርሶ፥ ይንታ ስለዘን ዋልቃ ሰጫ ዎራ ጉጅካንታ ማድባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ጉጅሰረ አፍላካንታ Ꮊረተንት ማጠርዳ? ይና ፍጨዘን ድረንከስታ ቦነነከስ Ꮊስግንዳ ጋጵዳናነረ ሰዳከቴ፥ ከታ ፍክስካ ጋፋየኬ፥ ፉታ ግእዳከኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ኬዛርካ ማቼ፥ ሰሎሞን ዎራ ኮ ሙዳ ይንታ ቦንቼንካ፥ ከታርንካ ዋልቀንግንዳ ቆበራክየ ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ይና ታካ Ꮊፈርሶ ሰናካ ኖሀር ኦይትምድን ዛክንዘን ድረንም፥ ሳብ ኮግንዳ ቆብዝድንዳ ማቼ የታ አሜን ዞገርስባብከስ! የም ማቼ Ꮊስግንዳ ስግስሶ ቆፍሳይንዳ! ");
INSERT INTO gyl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ኮካንታ ‘Ꮊሮንት እችቴ? Ꮊሮንት ዎጭቴ? Ꮊሮንት ቆበርቴ?’ ጋየረቶ ገቅርካ Ꮊይማጠረቴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ኮም Ꮊፍካንታ አይሁድ ማታክባብከሰረ ዝግደኬ፥ የካንታ ኮና ሙዳ የም ዝግዝድንደትም ጭላር የንታ ባቤና ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","የታ ማቼ፥ እርምሰቶ ሳብታ ባንችምንምኬ ጭለትችንም ዝከቴ፥ ነገዳን ሪሙደና የካንታ ጉጅምተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ሰናክንዳ ሰጨና ይንታ ማታ ኮት ማጠራ፥ ሰናክንደትካንታ Ꮊይማጠረቴ፥ ሰጨንካንታ ጋይምሳን ቦርምና ኮትካንታ ማዴ።” ");
INSERT INTO gyl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ኮታዘከረ የሱስ፥ “የዘን ፋረድምተራክንግንዳ፥ Ꮊየንታ ዘነረ Ꮊይ ፋረደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","አብንከዘን የ ፍርድን ፍርደና፥ የንታዘን ፋርድምዴ፥ ኮትኮግንደረ የ ማግድንደትካ ማስትዮ የካንታ ማክምዴ”። ");
INSERT INTO gyl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","የስታ አፋር ዶቅድንደተም ቱስን ሰዳከይ ዶቆ Ꮊረተስ የስታ እስመንታ አፍናር ዶቅድን ዳቅልን ሰዳ? ");
INSERT INTO gyl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ጉጅሶ የስታ አፍናር ቱስ ከከና ዶቅድንካ የስታ እስመንም “ይና ‘የስታ አፍናር ዶቅድን ዳቅልን ዉችትቴ’ Ꮊስግንደስ ጋይዳ? ");
INSERT INTO gyl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","የና ኦተረንባቦ! እርምሶ የስታ አፍናር ዶቅድን ቱስን ዉችካ፥ ኮታ ቡር፥ የስታ እስመንታ አፍናር ዶቅድን ዳቅልን ዉችካንታ ኡርስት ሰዳዬ”። ");
INSERT INTO gyl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ሳብካንታ ፋስምሳን ርን ከታ ይንታ ዱትንከረ ሙግዳክንግንዳ ማተረ የም ከት ጋእዳክንግንዳ አክስንከስካንታ Ꮊይ እመቴ፥ የንታ ቦንችምሳን ርን ጉድምንከስታ እር Ꮊይ ኦይተቴ፥ ጉድምንከስ የንታ ቦንችምሳን ርን ከታ ይንታ ዱትንካ ሙግደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ምክስከቴ የካንታ እምምተሬ፥ ዝከቴ የታ Ꮊፍተረቴ፥ ፍልተን ቆንከቴ የካንታ ፎችምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ምግዝድባብ ሙደና ተይተሬ፥ ዝግድባብ Ꮊፍተሬ፥ ፍልተንመረ ቆንግድባብካንታ ፎችምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","የንታ ዎክያርንካ ክታ ይንችና እችም ኦይሴ ሰይን እምድባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ሞለንም ምክሳን ማቼ ጉንን እምዶ? ");
INSERT INTO gyl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ይና የታ ዳቅል ማትሶ ዶቅድ፥ የንታ ይንችንካንታ ኡርማ ሪም እምንተን የ ኤሳንካ ይና፥ ጭላር ዶቅድባብ የንታ ባበና ምግዝድባብከስካንታ Ꮊስግንዳ ስክስሶ ኡርማ ርን እማይንዳ?” ");
INSERT INTO gyl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ይና ኤድንከስ የካንታ ይድንግንዳ የ ዝግድንደትም ሙዳ፥ የተረ ከትካንታ ኮትግንዳ ይከቴ፥ ሙሴታ ህግኬ ሳብዘንካ ኤስርሶ ከዘቅባብከስታ ኤስስነረ ኮትኮመተ። ");
INSERT INTO gyl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ጩንጭማ ፍልተንካ አርድከቴ፥ ካይንተናር አርጅድንዳ ፍልተና ዳልጌ፥ ጎግነረ ኮታ ሳክምዬ። ኮትካ አይድባብ ኤድና በድንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ኦስ ዶቅንተናር አርጅድን ፍልተና ማቼ ጩንጭሜ፥ ጎግነረ ሉጋ ጎግንግንዴ፥ ኮትም Ꮊብድባብከሰረ ቶክም ኤድንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ቆልታ ጉፍተም ቆበርሶ የንደር Ꮊድባብከዘንካ፥ ኬታ ዋርጎክንዳ ማቼ ቆልንም የድን ጋርመንከስግንዳ ማችባብከስ ካርከካ ሳብዘንካ ኤሰራከክዶቆ ከዝድባብከዘንካ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ከትመረ የ ኤዝድንዳ ከታ ፍክስንታ አፍንኬ። ኡክምታ እክመዘንካ ዎይንታ አፍ፥ ኦንደዘንካ በለስታ አፍን ካምምዶ? ");
INSERT INTO gyl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ኮግንደረ ኡርማ Ꮊቃ ሙደና ኡርማ አፍ ኡዝዴ፥ ዳቅል Ꮊቃ ማቼ ዳቅል አፍ ኡዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ኡርማ Ꮊቀና ዳቅል አፍ ኡስካንታ ማታዬ ዳቅል Ꮊቀነረ ኡርማ አፍ ኡስካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ኡርማ አፍ ኡዝዳክን Ꮊቃ ሙደና፥ ፋክምሶ ኖሀር ኦይትምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ኮካንታ፥ ካርከካ ሳብዘንካ ኤሰራከክዶቆ ከዛዶቅድባብከስም ከታ ፍክስንካ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ጭላር ዶቅድባብ እስታ ባበንታ ጋይተንም ቦድባብ ዳት ‘ጮይስዮ! ጮይስዮ!’ እም ጋይድባብ ሙደና ጭላ ባንችምናር አርድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ፍርደን ሰጨንካ በድንከስ፥ ‘ጮይስዮ! ጮይስዮ! የስታ ላምንካ ቤርካ ኬዛክቶ? የስታ ላምንካ ግምዘንከስም ዉቻኮቶ? የስታ ላምንካ በድ አተንም ፍክሳኮቶ?’ እዝደር ጋይተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","እተረ ኮት ሰጨንᎺይካ፥ ‘ቦድሶ የም ኤዝዳክቴ! የታ ዳቅልንም ፍግዝድባብከስ እዘንካ ኦስ ጎተርከቴ!’ ከትም ጋይትቴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ኮም እስታ ቃለንም ኤሰርሶ ፍክስዘን Ꮊቅዝድባብ ሙደና፥ ይንታ ኤሄንም ሰይን ላዝንዘን ዎጅባብ ኤችንም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ዶብነረ ቃንሴ፥ ሳፍነረ ሙርግዜ፥ ዞገነረ ዞግሶ፥ ኮትኮ ኤሄንም Ꮊቅሴ፥ ማታጋካ ዳት፥ ኤሄና ሰይን ላዝንዘን ዎድምሳንካንታ ዋቻክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ኮም እስታ ቃለንም ኤሰርሶ ፍክስዘን Ꮊቅዝዳክባብ ማቼ፥ ኤሄንም ሸምዘን ዎጅባብ ዳቻ ኤችንም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ዶብነረ ቃንሶ ሳፍነረ ሙርግሶ ኮትኮ ኤሄንም Ꮊቅሴ ኤሄነረ ዋቼ፥ ዋችንተነረ ኮታ ገቅዝድንዳ ማቼ”። ");
INSERT INTO gyl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","የሱሰረ ከትኬና ሪንከስም ኬዝሶ ክት በይሳንደትካ ዎርሰና ክታ ኤስስንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ከት በርእሳንደረ ኖ ሙሴታ ህግንም ኤስዝድባብከስግንዳ ማታክዶቆ፥ ገችታ ኤራ ዶቅድባብግንዳ ከትም ኤስዝድ Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","የሱስ ገቸንዘንካ ክት Ꮊንቸርድንካ፥ አንድር በድ ኤድንከስ ክትም ጎርስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ኮትᎺይካ ዋልቃ እጳ ሰቅምንክንባብ ኤች Ꮊድሶ ክትካንታ ጎስትሶ “ጮይስዮ! የስ ሶልምደ እም ፋችካንታ ማዳየ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","የሱሰረ ይንታ አንንም ኦይትሶ ክትም Ꮊጬ፥ “እታ ጋይድቴ፥ ፋጭካ!” ክትም ጋይሴ። እጳ ሰቅምንክንባበረ ሳነካ እጳ ሰቅምናርንካ ፋጬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ኮታ ቡር የሱስ፥ እጳ ሰቅምንክንባብ ኤችንም ኩን ጋይሴ፥ “ኮም ሪን Ꮊየንካንተረ Ꮊይከዜ፥ ኬዛርንካ ማቼ፥ አይሳዮ የስታ ማተንም ቀሰንካንታ ሰችካ፥ ማርካ ከታዘን ማተርንግንዳ፥ የስታ ፋጭንተንጎካ ሙሳ ክትሳን እመንም እምካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","የሱስ ቅፍራናሆም ካተመናር ክት አርደዳንደትካ፥ ዋልቃ ፖልስንከስም ገችዝድባብ ክደር Ꮊድሶ፥ ኩንጋየሮ ክትም ምክሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ጮይስዮ፥ እስታ ፍክስንባብና ዎብ ማትሶ፥ አንድር ማጥረሮ ኤሄናር ራትሶ ዶቅዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","የሱሰረ፥ “እታ Ꮊድስቶ ክትም ፋችትቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ፖልስንከስም ገችዝድባብ ማቼ ጮይስዮ! የና እስታ ኤሄናር አርድካንታ ዝግዝድን ኤድ ካይቴ፥ ኬዛርንካ ማቼ ዋልቃ ቃላ Ꮊክ ኬዝካ፥ እስታ ፍክስንባበረ ፋጭተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","“እታ እስታ ማታርንካ እዘን ገችታ ኤራ ዶቅድባብከስካንታ ክትምድባብቴ፥ እስታ ታመካ እከትም ክድባብ ዳምንባብከስ ዶቅደኬ፥ ከታርንካ ዋልቀንም ‘አይካ!’ እ ክትም ጋይሴ አይዴ፥ አብንመረ፥ ‘Ꮊድካ!’ እ ክትም ጋይሴ Ꮊዴ፥ እስታ ፍክስንባብመረ፥ ኮም ይካ እ ጋይሴ ይዴ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","የሱሰረ ኮም ይ ኤሰርሳንደትካ በርእሴ፥ ክታ ካርንካ ጎርስምድ Ꮊቅባብ ኤድንከስም ኩን ጋይሴ፥ “ዶፈን የም ጋይድቴ ኮግንዳ አንድር አሜን ዶቅድባብ ዋልቃ ኤደረ እስራኤልንከሳርንካ Ꮊፋክቴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","በድንከስ Ꮊይታ ዉትንታርንኬ Ꮊይታ አርድንታርንካ Ꮊደኬ፥ አብራሀመካ፥ ይሳቀካ፥ ያይቆበካ ክክን ጭላ ባንችማር እችምካንታ ዶቅተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ኮ ባንችምን ተይ ዝግዝድባብከሰክ ዶቆ ማል ዶቅድን ግልድድ ኡምናር ኦይትምተረኬ። ኮታረረ ኤፍኬ አች ቅርጭካ ማተረ”። ");
INSERT INTO gyl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ኮታ ቡር፥ የሱስ ፖልስንከስም ገችዝድባብም “አይካ፥ የስታ አሜንንግንዳ የስካንታ ማታ” ክትም ጋይሴ። ክታ ፍክስንባበረ ኮት ሳአትንዘነረ ፋጬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ኮታርንካ የሱስ ጴጥሮስታ ኤሀር አርደዳንᎺይካ ጴጥሮስታ በይስተና ዘና ሶልካ ሰቀርሶ ራችንካ ኮትም ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ኮታ አንንም ክት Ꮊጫንደትካ፥ ሳነካ ዘና ሶልነረ ኮትም ዛቅስንካ ና ፋጬ፥ አምትዮ የሱሰም ሞካ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ፍጨና ሶይቻንደትካ ኤድንከስ ግምዘንካ የደርስባብ በድ ሰቀርስባብከስም የሱሰደር ተይ Ꮊደኬ፥ ኖየረ ይንታ ቃልንካ ቱና አያንንከስም ዉችሴ፥ ሰቀርስባብከስም ሙዳ ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ኮም ክታ ይተንካ ሳብዘንካ ኤስርሶ ኬዛቅባብ ኢስያስካ፥ “ኖ ዎንታ Ꮊዝምንም ተዬ፥ ዎንታ ሰቅምንመረ ባልሴ” ጋይምሶ ኬዝምሳን ቤርና ቦድምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","የሱስ በድ ኤድንከስ ክታ ካንተንካ ሳንምሳን ይ ሰዳንደትካ ባሀርንታ ፋማ ከት ቃልድንግንዳ ይንታ ካርንካ ጎርስምድባብከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ኮታ ቡር ዋልቃ ሙሴታ ህግንም ኤስዝድባብ፥ የሱሰደር Ꮊድሶ፥ “ኤስስንባቦ፥ የስ አይድን ካሪ ሙደናር እታ የስም ጎርስምድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","የሱሰረ “ደበንንከስታ ጎር ዶቅዴ፥ ጭለዘን ፈድን አፍትንከስካንተረ ከት ሳንምድንደታ ኤሀ ዶቅዴ፥ ኤድ ይንችካንታ ማቸ ይንታ ማተንም ዎራ Ꮊዉስዝድንደታ ካሪ ካዬ” ጋይሶ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ከት ካርንካ ጎርስምድባብከሳርንካ ዋልቀና “የባቦ እርናና አይስቶ እባብም እ ዱግድንግንዳ ጋይካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","የሱሰረ “የና እም ጎርስምካ፥ ደእስባብከስም ማቼ ደእስባብ ዱግድንግንዳ ከትም ዛእካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","የሱሰረ ሎቀንዘንካ ቃልዝድን ጃልበናር አርድንካ፥ ክታ ካርንካ ጎርስምድባብከስ ክትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","አንድር ቡርበች ዞገና ባሀርንዘን አምሳንካንታ ሎቀንዘን ዞገና ጃልበንም ሎቀናር ኤቅዝስካንታ የልሴ፥ የሱስ ማቼ ራትሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ክታ ካርንካ ጎርስምድባብከሰረ የሱሰደር Ꮊድሰኮ፥ “ጮይስዮ! ዎታ ካይታ ይዶቴ ዎም አቅስካ!” ጋይሰኮ ክትም ንግሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ኖየረ፥ “የንታ አሜን ዞገርስባብከስ! Ꮊረተንት ጳዝዳ?” ኬትም ጋይሴ። ኮታ ቡር የሱስ አምሶ ሎቀንዘን አምሳን ቡርበችንምኬ ባሀርንም ዋጬ፥ ኮታዘንከረ አንድር ስምን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ኤድንከሰረ በርእሰኮ፥ “ባሃርንምኬ ባሀርንዘን አምድን ዞገና ክትካንታ ክትምድባብ ኖኮና ኤችና Ꮊይራ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","የሱስ ገሊላ ባሀርንም ቃልሶ፥ ገርገሰኖን ፍጫር ክት Ꮊድንደትካ፥ ግምዘካ የደርስባብ ቃስተን ኤድንከስ ዱክ ዶቅድን ካርያርንካ ዉትሶ Ꮊፈርሰኬ፥ አንድር ማእዝድባብ ከት ማቻንካንታ Ꮊየነረ ኤድ ኮት ጎግንካ ስግዳክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ከተረ፥ “የና ሳብታ ይንችኖ፥ ዎንካክክን የስታ Ꮊራ ዶቅዳ? ሰጨና የላክናና ዎም ማእስካንተስ Ꮊዶ?” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ከታዘንካ ቶክም ጎተርሳን ካርዘን በድ ጉድምንከስታ ዉዳ ግስምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ግምዘንከሰረ “የስ ዎም ዉችዝድንዳ ማቼ፥ ዋደ ኦኮ ጉድምንከስታ ዉደናር ዎም ኦይትካ!” ጋየሮ ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","የሱሰረ “አይከቴ!” ኬትም ጋይሴ። ኮካንተረ ኤድንከሳርንካ ዉትሶ ጉድምንከሳር አይሶ አርደደኬ። ጉድምንከሰረ ሙዳ ከታ ይ ዶቅድን ገችንታ ዱረንዘንካ ታድምሶ ባሀርንታ ዋር ኤቅዝምሰኮ ደእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ጉድምንከስም ግዝድባብከሰረ Ꮊዝሶ ኦስ ካተመናር አርድሰኮ ሙዳ ርን ኬዘኬ፥ ግምዘንካ የደርሳን ኤድንከዘን ይይምሳን ርን ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ኮታ ቡር ካተመናር ኤድንከስ ሙዳ የሱሰም ሰድንካንታ ዉተደኬ፥ ክትም ከታ ይ ሰዳንደትካ ከታ ፍጨናርንካ ዉትሶ ክት አይድንግንዳ ክትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ኮታ ቡር የሱስ ባሃርንዘነካ ቃልዝድን ጃልበናር አርድሶ ባሀርን ቃልሶ ይንታ ገታ ካተመናር Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ኮታረረ ኤድንከስ ሰለዘን ራችባብ ዋልቃ ዎብ ኤችም ባልሰኮ ክደር ተይᎺደኬ። የሱሰረ ከታ አሜንንም ሰድሶ፥ ዎብ ኤችንም “እስታ ይንችኖ! ዳእካ፥ ጎመና የስታ ነገቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ኮታይካ ዋልቃ ዋልቃ ሙሴታ ህግን ኤስዝድባብከስ፥ “ኮና ኤችና ሳብም የግዴ!” ጋየረኮ ይንታ ቡዳር ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","የሱሰረ ከታ ገቅርንም ኤስሶ፥ ኩን ከደር ጋይሴ፥ Ꮊረካንተንት ኮም ዳቅል ሪን የንታ ቡዳር ገቀርዳ? ");
INSERT INTO gyl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ይና ጎመና የስታ ነጋ ጋይምቴ ጋይንተዘንኬ አምሳዮ አይካ ጋይንተዘንካ Ꮊምና ኡርዳ? ");
INSERT INTO gyl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ኬዛርንካ ማቼ “ኤድ ይንች ፍጨዘን ጎመንም ነክስካንታ ገችታ ኤራ ክታ ዶቅድንደትም የ ኤስተርንግንዳ” ዎብ ኤችን “አምሳዮ የስታ ሰለንም ባልሰዮ የስታ ኤር አይካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ኤችነረ አምሶ ይንታ ኤር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ዎርሰነረ ኮም ከታ ይ ሰዳንደትካ በርእሰኬ፥ ኮግንዳ ዶቅድን ገችታ ኤራ ኤድካንታ እምሳንኦል ሳብም ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","የሱስ ኮት ካርናርንካ አምሶ ክት አይድንካ ማቶስ ጋይምስባብ ቃረጭ ተችዝድን ካርዘን ክት ዶቅድንካ ሰድሶ “እም ጎርስምካ” ክትም ጋይሴ ኖየረ አምሶ ክትም ጎርስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ኮታ ቡር የሱስ ማቶሰታ ኤሪ እችምካንታ ዶቅሶ ዶቅድንካ ቃረጭን ተችዝድባብከስከ ጎመንባብከስ በድና ኮታር Ꮊድሰኮ የሱሰደርኬ ክታ ካርንካ ጎርስምድባብከስካ ክክን እችምካንታ ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ፈረሳዊያንንከሰረ ኮም ሰድሰኮ ክታ ካርንካ ጎርስምድባብከስም “የንታ ኤስስንባብ ቃረጭን ተችዝድባብከስኬ ጎመንባብከስካ ክክን Ꮊረትክ እጅዳ?” ከደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","የሱሰረ ኮም ኤሰርሶ፥ “አክም ዝግዝድንዳ ሰቀርስባብከስም ዳት ኡርመንከስካንታ ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","አይከቴ ‘እ ዝግድንዳ አብንካንታ አትርንም ዳት ካሲንም ካዬ’ ጋይምሶ ጻፍምሳንዳ Ꮊስጋይንት ማቸረ ማስት ሰድንተካ ገቀርት ተይከቴ። እ Ꮊዳንዳ ጭልንከስካንታ ማታክናና ጎመንባብከስም ኤልካንቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ኮታይካ፥ ዮሀንሴታ ካርንካ ጎርስምድባብከስ የሱሰደር፥ “ዎንኬ ፈረሳውያን ኤድንከስ ሙዳᎺይካ በቼካ ምግዝዶቴ፥ የስታ ካርንካ ጎርስምድባብከስ ማቼ ከት በቼካ ምግዝዳክንዳ Ꮊረተረ?” ጋይሰኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","የሱሰረ “እንቸንባብ ከትካ ክክን ዶቅድንካ እሰናርንባብከስ ሞርእ ከትም ዝግዝዶ? ኬዛርካ ማቼ እንቸንባብ ከታዘንካ ተይምድን ሰጫ Ꮊዴ ኮትᎺይካ በቼካ ምግዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","ገሰርሳን አፍለዘን ክለንታ ተችምን ዛግድባብ Ꮊየነረ ካዬ፥ ዘን ኮት ዛግድንዳ ማቼ ክለንታ ተችምና ገሳ አፍለንም ፎጭሶ Ꮊእምንም ስግስሶ ዳልግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ኮት ኮግንደረ ገሰርሳን ሎቀታ ሱልፈንካ ክላ ዎይን ጩጰርሳንደትም ዎድባብ Ꮊየነረ ካዬ ኮና ይይምሳን ማቼ ሱልፈና ፉእደ ዎይንነረ ጩጰርሳንደረ ዉልእምዴ፥ ሱልፈነረ ባድሶ መይዳክንዳ ማዴ። ኬዛርካ ማቼ ክላ ዎይን ጩጰረሳን ክላ ሱልፈናር ዎድ ዝግዝዴ፥ ኮግንደካ፥ ቃስተነረ ኡርመካ ካርስምሰኮ ዶቅተረኬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","የሱስ ኮም ከትካንታ ከዛዶቅድንካ፥ ዋልቃ አይሁድንከስም ገችዝድባብ ክደር Ꮊድሶ፥ የሱሰታ እሪ ጉምፈርሶ፥ “ይና፥ እስታ ይንቸና ታ ደእሴ፥ ኬዛርካ ማቼ የና Ꮊድሰዮ የስታ አንን ኮታዘን የስ ዎጄ ና ሰንፐካ ማተረ” ክደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","የሱሰረ አምሶ ኤችንታ ካርካ አይሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ክትካ የካ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ይና፥ ታመከ ቃስተን ስላ ሙዳ ማቀስ ኮታ ዉልእምድንካ ማጠርድ Ꮊቃን ዋልቃ ኤተን፥ የሱሰታ ቡርጎካ Ꮊድሶ ክታ አፍለንታ ካንተንም ዎልሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ኮመረ ኮት ይሳንዳ “ክታ አፍለንም Ꮊክ ዎራ እ ዎልሳናና እታ አቅድቴ” ጋይሶ ይንታ ቡዳር ኮት ገቀርሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","የሱሰረ ዋልን ጋይሶ ኮትም ሰድሶ “ዳእካ እስታ ይንቸኖ! የስታ አሜንና የስም አቅስቴ” ኮደር ጋይሴ። ኤተነረ ሳነካ ፋጬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ኮታ ቡር የሱስ አይሁድንከስም ገችዝድባብታ ኤሪ ክት የልድንካ ሞርእካ ፍቼን ፉገረኮ ኦስኬ ፈንካ ፍፈሮ ኤብድን ኤድንከስም ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ኖየረ “የታ ሙደና ካርንካ ዉትከቴ! ይንቸንና ግንእሳ ዳት ደአክዬ!” ከደር ጋይሴ። ኬታ ማቼ Ꮊልተርካ ክታዘን ይንጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ኤድንከስ ኤሄናርንካ ዉተዳንደታ ቡሪ፥ የሱስ ይንቸንን ዶቅድን ካርናር አርድሶ ኮታ አንንም የጄ፥ ይንቸንነረ አምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ኮና ይይምሳንዳ ኮት ፍጨናር ሙዳ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","የሱስ ካርንኮታርንካ አምሶ ክት አይድንካ አፍይ ዝልንከስ ቃስተንና ክትም ጎርስምሰኬ፥ ከተረ “ዳውተታ ይንችኖ! ዋደ ዎም አጨርካ!” ጋየረኮ ፍብድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","የሱስ ኤሄናር ክት አርደዳንደትካ አፍይ ዝልንከስ ክደር Ꮊደኬ፥ ኖየረ “እታ ኮም እ ይድንደትም የታ አመንደቴ?” ከደር ጋይሴ። ከተረ “ይዬ፥ የ ጮይስዮ!” ጋየረኮ ክደር ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ኮታ ቡር የሱስ ከታ አፍንከስም Ꮊጭሶ “የንታ አሜንንግንዳ የካንታ ማታ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ከታ አፍንከሰረ ፎችምሰኬ፥ “የሱሰረ ኮም ሪን Ꮊየንካንተረ Ꮊይከዘቴ!” ጋይንተካ ዳቅስሶ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ከታ ማቼ አይሰኮ ኮታር ዶቅድን ፍጫ ሙደናር የሱሰታ ፍክስንጎካ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","አፍና ከታ ፎችምስባብ ኤድንከስ ዉትሰኮ ከት አይሳንደትካ አብ ኤድንከስ ግምዘካ የደርስባብ ዋልቃ አፋ ከዝዳክን ኤችም የሱሰደር ተይ Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ግምዘና ክታዘንካ ዉተዳንደትካ አፋ ከዝዳክን ኤችና ኬዜ፥ ዎርሰነረ “ኮግንዳ ር እስራኤልንከሳር ቦድሶ ሰድምሶ ኤስማዬ!” ጋየረኮ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ፈረሳውያንንከስ ማቼ፥ “ክት ግምዘን ዉችዝድንዳ ግምዘንከስም ገችዝድባብጎኬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","የሱሰረ አይሁድንታ ምክስ ኤሄናር ኤስሰሮ፥ ሳብ ባንችምታ ክላ ኬዘን ሳባከሮ፥ ዎርሰንም ሰቅምናርንኬ፥ Ꮊዝምናርንካ ሙዳ ፋችሰሮ፥ ካተመንከሳርኬ ሞረንከሳር ሙዳ ኦንገሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ዎርሰና ማቼ ግስመንባብ ካየን ቆልንከስግንዳ ማጠርስንደትከ ዛቅምሶ ከት ዶቅድንደትም ሰድሶ ከትካንታ ሞርእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ኮካንታ ይንታካርንካ ጎርስምድባብከስም፥ “ስከርድንዳ በድዬ፥ ስክድባብከስ ማቼ ቶክመኬ። ");
INSERT INTO gyl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ይና ፍክስንባብከስም ስክንካንታ ኦይድንግንዳ ስከርድንደታ ጮይስንም ምክስከቴ” ኩን ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","የሱስ ታመኬ ቃስተን ይንታ ካርንካ ጎርስምድባብከስም ይንደር ኤልሶ፥ ቱና አያንንከስም ከት ዉጅድንግንዳ፥ ሰቀርስባብከስምኬ Ꮊዝምክንባብም ሙዳ ከት ፋጅድንግንዳ ገችታ ኤራ ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ታመኬ ቃስተን ኦይተርስባብከስተረ ላምና ኬኔ፥ እርምሶ ጴጥሮስ ጋይምስባብ ስምኦንኬ ክታ እስመን እንደራሰካ፥ ዛብዶሰታ ይንችንከስ ያይቆበኬ ዮሀንሰካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ፍልጶስ፥ በርቶሎመዎስ፥ ቶማስ፥ ቃረጭን ተችዝድባብ ማቶስ፥ እልፎሰታ ይንች ያይቆብ ታደዎስ፥ ");
INSERT INTO gyl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ይንታ ፍጨንካንታ ገቀርድባብ ስምኦን፥ ስክስት እምስባብ አስቆሮንት ይሁዴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","የሱስ ከትከም ታመኬ ቃስተን ኦይትምስባብከስም ኦይቼ፥ ኩነረ ጋይሶ ከትም ክትሴ፥ አይሁድ ማታክባብከዝደር Ꮊይ አየቴ፥ ሳማርያ ካተመንከሳር Ꮊይ አርደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ስግስሶ ቆልንከስግንዳ ካይድባብ እስራኤል ዎርሰንደር አይከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","አይሰቶ ጭላ ባንችምና ቅንችቴ ጋየረቶ ሳባከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ሰቀርስባብከስም ፋችከቴ፥ ደእስባብከስም አምስከቴ፥ እጳ ሰቅምንክንባብከስመረ ፋችከቴ፥ ግምዘንከስመረ ዉችስከቴ፥ ዉች የ ተያንደትም ዉች እምከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ዎርቃ አነረ ዱንድ አነረ ጋይካ ኡርሰርሳን ብራ የንታ ክስያር Ꮊይ የደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ፍክስንባብከስካንታ እችም ዝግዝድንዳ ማቻንካንታ የንታ ጎግንካንታ ሱልፋ፥ ስጥመካ ሳምዝ፥ ጫማ ጉፈረ Ꮊይ የደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","የ አርድን ካተመናር አነረ ሞረናር፥ የም ሞግድባብ Ꮊይናነረ ኡርስት ኤስከቴ፥ ካርን ኮትመረ ዛቅሰቶ የ ዉተርን የለልታ ክትካ ክክን ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ኤታ ኤር አርደቶ አበቶ ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ኤሄና የ አበቶ ጋይድንካ ሞግድባብ ማቼ የንታ አቦና ክትም የላጋካ፥ ሞግዳክባብ ክት ማቼ የንታ አቦና የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ꮊየነረ ኤድ የም ሞግዳክባብ አነረ የንታ ቃለንም ኤሰርዳክባብ ማቼ ኮትኮ ኤሄን አነረ ካተመን ዛቅሶ ዉደቶ ከትካንታ ኤግዝምስ ማድንግንዳ የንታ ዱትታ ቡልንም ድንግስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ዶፈን የም ጋይድቴ፥ ፍርዳ ሰጨንካ ኮትኮ ካተመንዘንካ ስግስሶ ሶዶም ካተመንካንተከ ገሞራ ኤድንከስካንታ ዋጭና ቶግዴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ኮሰቸቴ! ቆልንከስግንዳ ጋርመንከስታ ዎክያር የም ኦይትቴ፥ ኮካንታ ጉንንግንዳ አጋ፥ ዎለንግንዳ ቡዳር ዳቅል ካየንባብ ማትከቴ”። ");
INSERT INTO gyl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ኤድንከስ የም ፍርደን እምድባብከዝደር ስክስት እምተረኬ፥ አይሁድንከስ ይንታ ምክስ ኤሄንከሳር የም Ꮊርተረኬ፥ ኮካንታ ኤድንከዘንካ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","እጎካ፥ ፍጨን ቆልድባብከዝደርኬ ባንችምንከዝደር ፍርዳካንታ የ ተይ አይምድንካንታ ከትኬ አይሁድ ማታክባብከስታ እሪ እስታ ማርከንከስ ማተረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ኤድንከስ ፍርደን እምድባብከዝደር የም ተይᎺድንካ የ ኬዝድን ሪ ኮትኮ ሳዓትንዘን የካንታ እምድንካንታ Ꮊስግንዶንት አነረ Ꮊሮንት ኬዝቴ? ጋይሰቶ ገቅርካ Ꮊይማጠረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","የንታዋር ዶቅሶ ኬዝድባብ ጭላር የንታ ባቤን ሳብንታ አያንና ዳት የታ ካየቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ኤድ ይንታ ገታ እስመንም ደእካንታ ስክስት እምተሬ፥ ኮትኮግንደረ ባቤና ይንታ ገታ ይንችንም ደእካንታ ስክስት እምተሬ፥ ይንችንከሰረ ይም አጭባብከዘን ይምኤንባብ ማትሰኮ አምተረኬ፥ ደእካንተረ ስክስት ከትም እምተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","እጎካ ኤድ ሙደንታ ላመር የታ ቦስምስባብ ማተረቴ፥ ኬዛርንካ ማቼ በእንታ የለልታ ዳቅሶ ዎእድባብ አቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ዋልቃ ካተማር ማጣ የንዘን በጅድንካ፥ ኦስ አብናር አጥምከቴ፥ ዶፈን የም ጋይድቴ ኤድ ይንች ማት Ꮊተርን የለልታ እስራኤልንከስታ ካተመንከስም ሙዳ የንታ ፍክስንም የልሳየቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","ኤስካንታ ዝግድባብከስ ኤስዝድባብዘንካ ስጋየ፥ ፍክስንባብና ይንታ ማታ ቆልስባብዘንካ ስጋየ። ");
INSERT INTO gyl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ኮካንታ ኤስካንታ ዝግድባብ ይንታ ኤስስንባብግንዳ፥ ፍክስንባበረ ይንታ ማተን ቆልስባብግንዳ ማቼ ክትም ማዴ። ኤሄንታ ባቤንም፥ ብኤልዘቡል ጋይሶ ክትም ከት ኤልሴ ክታ ኤሀ ኤድንከስም ኮዘንካ ቦርድን ላምካ Ꮊስግንዳ ኤላይንዳ! ");
INSERT INTO gyl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","ይና ኤድንከስም Ꮊይ ጳሰቴ፥ ክጭምሳንዳ መያ ማት ነገዳክዬ፥ አችምሳንደረ ኤስማክዶቆ ነጋዬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ኮካንታ እ የም ኡማር ኬዝድንደትም፥ የታ ሳክማር ኬዝከቴ፥ ዎክስምካ የ ኤሰርሳንደትም ጬክን ጋይሳን ካርዘን ሳባከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ዋሄንም ደይሰዘንካ ስግሶ ሰንፔንም ደይሳካንታ ማዳክባብ ኤድንከስም Ꮊይጳሰቴ፥ ስክስሰረ ሰንፔንምኬ ዋሄንም ድግዳክን ኖሄናር ካይስካንታ ማድባብ ጮይስንካንታ ጳስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ቃስተን አፍት ስልንከስ ዋልቃ ባከነካ ሰንምደክካዮ? ማታጋካ ዳት፥ ጭላር የንታ ባበና ጋያክናና ዋልቃ ስልና ዎራ ፍጨዘን ዋቻዬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","የንታ ማቼ ማተታ ስጭና ዋልቃ ዋልቀና ዎራ ፋይድምሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ይና የታ ማቼ በድ ስልንከዘንካ አንድር የ ስገድንካንታ ቦድሶ Ꮊይ ጳሰቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ኤታ እሪ እካንታ ይ ማቻንደትም ማርከርድባብ ሙደንካንታ፥ እተረ ጭላር ዶቅድባብ እስታ ባቤንታ እሪ ማርከርትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ኤታ እሪ እም ካድባብም፥ ሙዳ እተረ ጭላር ዶቅድን እስታ ባቤንታ እሪ ክትም ካድቴ”። ");
INSERT INTO gyl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","እ Ꮊዳንዳ፥ ሳራትቼንም ፍጨዘን ተይᎺድካንታ Ꮊዳን የም Ꮊይካማ፥ እታ ፋስምን ዳት ሳራትቼን ተይᎺድካንታ Ꮊዳክቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","እ Ꮊዳንዳ፥ አⷝና ይንችና ባቤንታዘን፥ ማና ይንችና እንደንታዘን፥ ይንችንታ ኬነና ይንችንታ እንደንዘን ይምኤንባብ ማስሶ አምስስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ኮካንታ ኤታ ይምኤንባብከስ፥ ገታ ከታ ኤሀ ኤድንክስ ማደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","እዘንካ ስክስሶ ይንታ ባቤንም አነረ ይንታ እንደንም ሶልምድባብ፥ እካንታ ማት ክትም ዝክሳዬ፥ እዘንካ ስክስሶ ይንታ አⷝና ይንችን አነረ ይንታ ማናይንችን ሶልምድባብ እካንታ ክትም ማት ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ይንታ ገታ ማዝቀልን ባልሶ ደእ የለልታ እም ጎርስምዳክባብ እካንታ ማት ክትም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ይንታ ሰንፔንም አቅስካንታ ዝግድባብ ሙደና ኮትም ካይዝዴ፥ ይንታ ሰንፔንም እካንታ ካይዝድባብ ሙደና ማቼ ኮትም አቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“የም ሞግድባብ እም ሞግዴ፥ እም ሞግድባብ እም ኦይችባብ እስታ ባቤንም ሞግዴ። ");
INSERT INTO gyl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ሳብዘንካ ኤሰርሶ ኬዝድባብም ሳብዘንካ ኤሰርሶ ኬዝድባብታ ላምንካ ሞግድባብ ከታ ናክንም Ꮊፍተሬ፥ ጭልንመረ ጭልንታ ላምካ ሞግድባብ ጭልንታ ናክንም Ꮊፍተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ዶፈን የም ጋይድቴ፥ እስታ ካርንካ ጎርስምድባብ ክት ማቻንካንታ፥ ከትኬና መረንከሳርንካ ዋልቃባብካንታ ዋልቃ ቡርጭቀካ ሎቃ እምድባብ ኤድ ይንታ ናክንም Ꮊፍክሳ ነጋዬ።” ");
INSERT INTO gyl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","የሱስ ታመኬ ቃስተን ይንታካርንካ ጎርስምድባብከስካንታ ከትከ ክተንከስም ይ እምሳን ቡር ኮትኮ ካርንም ዛቅሶ ቅንች Ꮊፈርድን ካተመንከሳር ሳባክካንተኬ ኤስስካንታ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ስእስንባብ ዮሀንስ ዞክና ኤሄናር ዶቅድዮ ክርስቶሰታ ፍክስን ኤሰርሶ ይንታ ካርንካ ጎርስምድባብከሳርንካ ቃስተንን ኦይትሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“ኖ Ꮊዴ ጋይምስባብ ክርስቶስ የኖ? አና አብኖንት ካርስተሮ?” ጋይሶ የሱሰም ኬት ኦይስተርንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","የሱሰረ፥ “አይሰቶ የ ሰዳንደትምከ የ ኤሰርሳንደትም ሙዳ ዮሀንስካንታ ኬዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ኮሰቸቴ፥ አፍ ዝልንከስ ሰተረኬ፥ ዎከልዎከል ጋይድባብከስ ኡርመካ ሙክተረኬ፥ እጳ ሰቅምንክንባብከሰረ ፋጭተረኬ ቃም ቱንንከሰረ ኤሰርተረኬ ደእስባብከሰረ አምደኬ ሪካየንባብከስካንተረ ክላ ኬዘና ሳባክምተረ፥ ");
INSERT INTO gyl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","እም Ꮊኤርዳክባብ ሙደና አንጅምስባበኬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ዮሀንሰታ ክተን ተይᎺድባብከስ አይሳንደታ ቡር፥ የሱስ ዮሀንስጎካ ኩን ጋይሶ ዎርሰንካንታ ኬዛ የጄ፥ “ይና Ꮊራ ሰድንካንተንት ኮ ዴል ቆቸናር ዉተዳራ? ዞገካ ሶግድን ሱንባቀን ሰድንካንቶ? ");
INSERT INTO gyl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ጉጅሰረ አብ Ꮊራ ሰድንካንተንት ዉተዳሬ? ላቅምድን አፍለን ቆበርስባብ ኤድም ሰድንካንቶ? ላቅም አፍላ ቆበርድባብ ባንችምንከስታ ኤሄናር Ꮊፈርደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ይና፥ Ꮊራካንተንት ውተዳራ? ሳብዘንካ ኤሰርሶ ኬዝድባብም ሰድንካንቶ? ይዬ፥ ኮትኮግንደረ ሳብዘንካ ኤሰርሶ ከዝድባብዘንካ አንድር ስገድባብም ሰድንካንተ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ኖ ‘ይና፥ የስታ እሪ እሪ አየሮ፥ የስታ ጎግንም ግግዝድባብ እስታ ክተንም ተይሶ አይድባብም የስታ እር ኦይትቴ’ ጋይምሶ ክትካንታ ጭል ማጻፍናር ጻፍምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ዶፈን የም ጋይድቴ ማነንከስ አጭባብ ኤድንከስታ ዎክያርንካ ስእስንባብ ዮሀንሰዘንካ ስግድባብ አማክዬ። ኬዛርንካ ማቼ ጭላ ባንችማር አንድር ስግድባብ ኖ ፍጨዘን ቶክማ ጋይምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ስእስንባብ ዮሀንሰታ ስለንዘንካ የድሶ ታካ የለልታ ጭላ ባንችምና ዝግምዶቃየ፥ ዳቅስሶ ዝግድባብከስ ማቼ ኮትም Ꮊብደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“ሳብዘንካ ኤሰርሶ ኬዛቅባብ ሙደንታ ኤስስንኬ ሙሴካንታ እምምሳን ህግና ስእስንባብ ዮሀንስ የለልታ ቤርካ ከዝተኬ። ");
INSERT INTO gyl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ይና ከት ኬዛንደትም ተይካንታ የዝግዘ፥ ኖኮና Ꮊዴ ጋይምስባብ ኤላስ ዮሀንሴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ቃም ዶቅድባብ ኤሰራ! ");
INSERT INTO gyl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ኬዛርካ ማቼ ኮ አጥርንከስም Ꮊረክስ ካምስቴ? ጋበታ መለንዘን ዶቅሰኮ ክክ ኤልድን ይንችንም ካምደኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘አንዳለንም የካንታ ፉግዞቴ የታ በይዳከቴ! ሳችሶቴ የታ ኤፋከቴ!’ ጋይድን ይንችንከስም ካምደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ኮትኮግንደረ ስእስንባብ ዮሀንስ ᎺዳንደትᎺይካ እችምን እችክሳ ዎይን ዎጭምን ዎጭክሳ Ꮊድንካ፥ ‘ኮና ክታዘን ግምዛ ዶቅዴ!’ ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ኤድ ይንች እቸሮ ዎጨሮ Ꮊዴ ‘ይና! ኖኮና በድ እችምንኬ ዎጭምም ሶልምድባቤ! ቃረጭን ተችዝድባብከስተኬ ጎመንባብከስተረ ኮችዬ!’ ክትም ጋይሰኬ። ማችንከረ ኤጨታ ዶፈንና ማቼ ይንታ ፍክስንካ መያ ማዴ”። ");
INSERT INTO gyl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ኮታዘንከረ የሱስ አብ ካተመንከዘንካ ስግ በድ አተንከስም ይ ፍክሳን ካተመንከስም፥ ጎማ ፍክስን ከታ ይንታ ዎይሳክንካንታ ኩንጋየሮ ከትም ዎቀስ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ኮራዝኖ የስም የኤ! በቴሳይዶ! የስም የኤ የንካ ይይምሳንዳ አተና ጥሮሳርኬ ሲዶና ካተመንከሳር ይይምተስናና ኮታር ዶቅድን ኤድንከስ ሞርእታ አፍላ ቆበርስንደትኬ ማል ሳየርሶ ኤና እርናና ከታ ይንታ ጎማ ፍክስን ዎይዝደክዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ኮካንታ እታ የም ጋይድቴ ሳብታ ፍርዳ ሰጨንካ፥ የንዘንካ ስግ ጢሮሳርኬ ሲዶና ካተመናር ዶቅድ Ꮊቅባብከስካንታ ዋጭና ከታዘን ቶግዴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","የነረ ጭላር የለልታ ጬክን ጋይሳንዳ ቅፍራናሆም ካተመኖ! ጩልጩል ጎርናር Ꮊንቸርተረየ! የስካ ይይምሳን አተንከስ ሶዶም ካተመናር ይምተስናና ናኮና ካተመና ካያክዶቆ ታካ የለልታ ዶቅተርዶቆ! ");
INSERT INTO gyl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ኮካንታ ዶፈንካ የስም ጋይድቴ፥ ሳብታ ፍርዳ ሰጨንካ የዘንካ ስግ ሰዶም ካተምንካንታ ክታ ዋጭና ቶግዴ!” ");
INSERT INTO gyl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ኮት ሰጨንካ የሱስ ጭለተኬ ፍጨተካ ጮይስ እስታ ባቤኖ! ኮም ሪን ኤጨንባብከዘንከ ኤዝዶቴ ጋይድባብከዘንካ አችሳዮ ይንችንከስካንታ መያ የስ ማስሳንካንታ የስም ጋለድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ይዬ! እስታ ባበኖ! ኮም ይካንታ የስታ ኡርማ ጋይታ ማቴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","እስታ ባቤና ሙዳ ሪን እካንታ እምቴ፥ እባብዘንካ አብ እ ክታ ይንችንም ኤዝድባብ Ꮊየነረ ካዬ። ኮትኮግንደረ እ ክታ ይንችንዘንካ አብ እባብም ኤዝድባብ Ꮊየነረ ካዬ፥ Ꮊየነረ እ ክታ ይንችና ክትም መያ እ ማሳክንዳ ማቼ እባብም ኤስካንታ ማታዬ። ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“የታ ጋፍስባብከስኬ ባላ ደጭባብከስ ሙደና ኮር እዝደር Ꮊድከቴ! እተረ የም Ꮊዉስ እምትቴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","እስታ ቃንበርንም የንታዘን ባልከቴ፥ እዘንከረ ኤስከቴ፥ እታ ኡርመኬ የካንታ ቡዳርንካ አተርድባብቴ፥ የንታ ሰንፔንካንተረ Ꮊዉስ Ꮊፍተረቴ። ");
INSERT INTO gyl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","እስታ ቃንበርና ሳዝ፥ እስታ ባለነረ ደጫይንዴ”። ");
INSERT INTO gyl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ኮትᎺይካ የሱስ አይሁድንታ Ꮊውስ ሰጨንካ ኡሳን ዘርግታ ዎክካ አይድንካ፥ ክታ ካርንካ ጎርስምድባብከስ ከትም ዳቅሳንካንታ ዘርግ ትሰን ታክስሶ ዎክስሶ እች የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ፈረሳውያን ኤድንከስ ኮም ሰድሰኮ የሱሰም “ኮ ሰድካ! የስታ ካርንካ ጎርስምድባብከስ አይሁድንታ Ꮊዉስ ሰጨንካ ጋይማክንደትም ይደኬ!” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","የሱሰረ፥ ዳውትከ ክትካ የካ Ꮊቅባብ ኤድንከስ ከት ዳቀርሳንደትካ ዳውት ይሳንደትም ቦድሶ ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ኖየረ ሳብታ ኤሄናር አርድሶ ቄሰንከዘንካ አብ ኖየረ ማታ ክትካ የካ Ꮊቅባብ ኤድንከስ ከት እጅድንግንዳ ጋይማክንደትም፥ ካስካንታ ግግሰርሳን ባይስንም እቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ጉጅሰረ ቄሰንከስ አይሁድንታ Ꮊዉስ ሰጨንካ ሳብታ ጭል ኤሄናር አይሁድንከስታ Ꮊዉስ ሰጨንም ቦንችክሳ ከት ነግድንካ ባች ማትሶ ከታዘን ፋይድምዳክንደትም ሙሴጎካ እምምሳን ህግናር ጻፍምሳንደትም የታ ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ኬዛርንካ ማቼ ሳብታ ጭል ኤሄንዘንካ ስግድባብ ይና ካሪ ዶቅዴ የንደር ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ጉጅሰረ እ ዝግድንዳ ቡዳርንካ አትርንም ዳት ካሲንም ካዬ ጋይድንደትም ጭል ማጻፍንታ ቃለና Ꮊራ ጋይዳናከረ የ ገቀርደስናና ባች ከታዘን ካየንባብ ኤድንከዘን የታ ፋረተራከት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ኮትኮግንደረ “ኤድ ይንች አይሁድንከስታ Ꮊዉስ ሰጨንተረ ጮይስዬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","የሱስ ካርንኮታርንካ አምሶ አይሁድንከስታ ምክስ ኤሄናር አርደዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ኮታረረ ዋልቃ ኤች አን ዎብ Ꮊቄ፥ የሱሰም ካሰስካንታ ኬዛ ዝግድባብ ዋልቃ ዋልቃ ኤድንከስ “አይሁድንከስታ Ꮊዉስ ሰጨንካ ሰቀርስባብም ፋጅድንግንዳ ጋይምቶ?” ጋየሮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","የሱሰረ፥ “የንታ ዎክያርንካ ዋልቃ ቆለን ዶቅድባብ፥ ክታ ቆለና አይሁድንከስታ Ꮊዉስ ሰጨንካ ጎርያር ዋቼ ጎችትዮ ዉጅዳክባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ይና ኩን ማቼ ኤድ ቆልዘንካ Ꮊስግንዳ እንድንካ ስጋዮ! ኮካንታ አይሁድንታ Ꮊዉስ ሰጨንካ ኡርማ ሪ ይታ ጋይምሳንዴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ኮታ ቡር የሱስ አን ዎብን “የስታ አንንም ፍእስካ” ክትም ጋይሴ። ኖየረ ይንታ አንንም ክት ፍእዝድንካ ክታ አንና ገታ ኡርሶ ዎባክን አንን ዋልቀንግንዳ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ፈረሳውያን ኤድንከስ ማቼ ኮታርንካ ዉትሰኮ የሱሰም Ꮊስ ይይሰኮ ክትም ከታ ይ ደይዝዳናንከረ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","የሱስ ማቼ ከታ ዙዝምን ኤስሶ ኮት ካርናርንካ Ꮊርን ጋይሴ፥ በድ ኤድንከሰረ ክትም ጎርስምሶ አይሰኬ፥ ሰቀርስባብከስ ሙደንመረ ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ኤድንከስም ማቼ ክትጎካ Ꮊየንካንተረ ከት ኬዝዳክንግንዳ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ኮነረ ማቻንዳ ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኢስያስ ኬዛን ቤር ኬዘና ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ይና! እ እጅባብ እስታ ፍክስንባብና ኮኔ! ኖ እ ሶልምድባብከ እ ክትካ ጉርምድባቤ፥ እስታ አያንን ክታዘን ማስትቴ፥ ኖየረ ሉላ ፍርደን ዎርሰንካንታ ኬዝተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ኖ በርምዳክየ አነረ ፍፋዬ፥ ጎግንከዘነረ ክታ ኡፍስን ኤሰርድባብ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ጎድምሳን ሱምባቀን ዎራ ኖ ቁንጫየ፥ የድካንታ ጩብድን ክርንም ድክሳዬ፥ ኮመረ ክት ይድንዳ፥ ሉላ ፍርደና ጋምተርን የለልቴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","አይሁድ ማታክባብከስ ክትካ ጉርምን ይደኬ”። ");
INSERT INTO gyl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ኮታ ቡር ኤድንከስ ዋልቃ ግምዘካ የደርስባብ ዓፊይ ዝል ማችባብኬ አፈረ ከዛይባብም የሱስደር ተይᎺደኬ፥ የሱሰረ ኤችንም ፋችሴ፥ ኤችነረ ኬዘኬ ሰድነረ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ዎርሰነረ ሙዳ በርእሰኮ፥ “ኮና ዳውተታ ይንች ማተርዳቶ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ፈረሳውያንንከስ ማቼ ኮም ኤሰርሰኮ “ኖ ‘ብኤልዘቡል’ ጋይምስባብ ግምዘንከስም ገችዝድባብታ ዎልቀካ ማታክንዳ ማቼ ግምዘንም ዉቻዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","የሱሰረ ከታ ገቅርንም ኤስሶ፥ “ክክ ክክ ፋስምድን ባንችምና ሙዳ ዋጅዴ። ኮትኮግንደረ ዋልቃ ካተመና አነረ ዋልቃ ኤሀኤድ ክክ ክክ ከት ፋስምሴ ዳቅሶ ዶቅካንታ ማታየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ሰጣነረ ሰጣንም ዉጅድንዳ ማቼ ክክ ክክ ፋስምተከ ጋይንትዬ፥ ይና፥ ኩን ማቼ ክታ ባንችምና Ꮊስግንዶክ ዳቅሶ ዎእዳ! ");
INSERT INTO gyl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ጉጅሶ እታ ግምዘንከስም እ ዉችዝድንዳ ብኤልዘቡልካ ማቼ የም ጎርስምድባብከስ Ꮊረከክ ከትም ዉችስተራ? ኮካንታ የንታ ይንችንከስ የንታዘን ፋረደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","እታ ግምዘንከስም እ ዉችዝድንዳ ሳብታ አያንካ ማቼ ይና ሳብታ ባንችምና የንደር Ꮊቴ፥ ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ጉጅሰረ ዋልቃ ኤድ እርናና ዎልቀንክንባብም ዞካክዶቆ ዎልቀንክንባብታ ኤሪ አርድሶ ክታ ሪይንም ቡራካንታ Ꮊስግንድክ ማዳ? ዎልቀንክንባብም ይ ዞክሳንደታ ቡር ገታ ክታ ሪይንም ቡራካንታ ማደ። ");
INSERT INTO gyl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“እንካ ክክን ማታክባብ ሙደና እም ግርዴ፥ እንካ ክክን ሳንዝዳክባብ ኖ ይጭዴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ኮካንታ ኤድ ይ ይድንደትም Ꮊምንመረ ጎመን አነረ አፋርንካ ዉድን የክንም ሙዳ ክትካንታ ነጋ ጋይምተሬ ጋይድቴ፥ አያን ጭልንዘን የግድባብ ዋልቃ ኤችታ ባችና ክትካንታ ነጋ ጋይምተራክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ኤድ ይንችታዘን ዳቅልንም ኬዝድባብ ሙደና ክታ ባችና ነጋ ጋይምተሬ። አያን ጭልንዘን የግድባብ ሙደና ማቼ ኮፍጫ ሙደንዘነረ ማታ Ꮊድን ፍጫሙደንዘን ክታ ባችና ነጋ ጋይምተራክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ꮊቃ ሙደና ይንታ አፍንካ ኤስምድንካንታ ኡርማ Ꮊቃ የካንታ ዶቃ፥ ኮታ አፍነረ ኡርማ ማዴ፥ Ꮊቀና ዳቅል ኮት ማቼ አፍነረ ዳቅል ማደ። ");
INSERT INTO gyl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","የታ ጉንን ፉይንታ ይንችንከሶ! የታ ዳቅልንባብከስ ማደቶ ኡርማ ሪም ኬዛካንታ Ꮊስግንደንት ማዳ? ኤድ ይንታ አፈካ ኬዝድንዳ ይንታ ቡዳር ጮጭሶ ስጣንደትሜ። ");
INSERT INTO gyl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“ኡርማ ኤድ ይንታ ኡርማ ቡደናርንካ ኡርማ ሪን ዉጅዴ፥ ዳቅል ኤደረ ዳቅል ይንታ ቡደናርንካ ዳቅል ርም ዉጅዴ ");
INSERT INTO gyl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ዶፈንካ የም ጋይድቴ፥ ኤድንከስ ዉችኩን ማዳክንደትም ከታ ይ ከዝድንደት ዋልቃ ዋልቃ ኬዘንታ ሳብታ ፍርዳ ሰጨንካ ኦይስምደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","የስታ ኡርማ ኬዘንዘንካ አምሳንዳ ጭልምዳዬ፥ አነረ የስታ ዳቅል ኬዘንዘንካ አምሳንዳ ኡርክና የስታዘን ማተሬ”። ");
INSERT INTO gyl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ኮታይካ ዋልቃ ዋልቃ ሙሴታ ህግንም ኤስዝድባብከስከ ፈረሳውያንንከስ የሱሰም፥ “የ ኤስስንባቦ! የስ አተንም ይድንካ ሰድካንታ ዝግዶቴ!” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","የሱስ ማቼ፥ “ዳቅልኬ አሜንዳክን አጥርንከስ አተንም ሰድንካንታ ዝግዴ፥ ኬዛርንካ ማቼ ሳብዘንካ ኤሰርሶ ኬዛቅባብ ዮናሰታ አተንዘንካ አብ አታ እምማዬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ዮናስ ሞላ ባከንታ ኖርትያር ማከን ሰጫ Ꮊየኬ ሶይትካ ክት ስክሳንግንዳ፥ ኮትኮግንዳ ኤድ ይንች ዱክናር ማከን ሰጨከ ማከን ሶይት ስክስተረ። ");
INSERT INTO gyl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ነነዌ ካተመንታ ኤድንከስ ሳብታ ፍርዳ ሰጨንካ ኮ ስለንታ አጥርንከስካ ክክን አምሰኮ ክታዘን ፋረተረኬ፥ ነነዌ ካተማ ኤድንከስ ዮናሰታ ሳባክን ከታ ይ ኤሰርሳንደትካ ከታ ይንታ ጎማ ፍክስንጎካ ኡቅምሰኮ ይንታ ጎማ ፍክስን ዎይስተኬ። ታ ማቼ ዮናሳዘንካ ስግድባብ ካሪ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ኤተን ባንችን ሳባ ሰሎሞንታ ኤጨንም ኤስርካንታ ፍጨታ ካንታርንካ ኮት Ꮊዳንካንታ ሳብታ ፍርዳ ሰጨንካ ኮ ስለንታ አጥርንከስካ ክክን ና አምሶ ክታዘን ፋረተሬ፥ ታ ማቼ ሰሎሞንዘንካ ስገድባብ ካሪ ዶቅዴ ኩን ከትካንታ ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ኮታዘንከረ የሱስ፥ “ቱና አያንና ኤታ ዋርንካ ዉተዳንደታ ቡር ይ Ꮊዉዝድን ካሪ ዝግመትካ ሎቃ ካየን ዎቻ ካርያር ኦንግዴ። ኬዛርካ ማቼ Ꮊፋዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ኮካንታ ‘እ ዉተዳን ኤሄናር ማት እ አያ’ ጋይዴ። ማተረ ክት Ꮊድንካ፥ ኤሄና ዉችኩን ማትሶ Ꮊጭምሶ፥ ግግምስንካ Ꮊፍተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ኮታ ቡር፥ ቱና አያንና አይሶ ይንዘንካ እድንካ ስገድባብ አብ ታብዛ ዳቅል ግምዘንከስም ተይሶ Ꮊተሬ። ከተረ ኤና እር ግምዘታ ኤሀ Ꮊቃን ኤችንታ ቡደናር አርድሶ የካ ክታር ዶቅተረኬ። ኮካንታ ኤችን ክታ እርንደትዘንካ ስግሶ ቡርንዳ እንድንካ ቦርሳንዳ ማተሬ። ኮ ዳቅል አጥርንዘን ማድንዳ ኮትኮም ካምሳን ካምድን ርንከሰ ኩን ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","የሱስ ዎርሰንካንታ አክ ኬዘዘን ዶቅድንካ፥ ክታ እንደንከ እስመንከስ ክትም ከስስካንታ ዝግሰኮ ማል ዎእሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ኮታር Ꮊቅባብከሳርንካ ዋልቀና የሱሰም፥ “ኮሰቼ የስታ እንደንኬ የስታ እስመንከስ የስም ከስስካንታ ዝግሰኮ ማል ዎእተኬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","የሱስ ማቼ፥ “እስታ እንደነና ና Ꮊይራ? እስታ እስመንንከሰረ ከታ Ꮊይራ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ኮታ ቡር ይንታ አንን ኦይትሶ ይንታ ካርንካ ጎርስምድባብከዝደር ሰቸሮ “እስታ እንደንኬ እስታ እስመንንከስ ኮሰቸቴ ኬናከሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ጭላር ዶቅድባብ እባብታ ጋይተንም ቦድባብ ሙደና እስታ እስመነረ፥ እስታ ምችነነረ፥ እስታ እንደነረ ኖዬ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ኮት ሰጨንካ የሱስ ኤሄናርንካ ዉትሶ ሎቃ ባሀርንታ ካንተዘን ዶቅሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","በድ ኤድንከሰረ ክደረ Ꮊድሰኮ ከት ሳንምሳንካንታ ሎቀንዘንካ ቃልዝድን ጃልበንዘን ዉትሶ ዶቅሴ፥ ዎርሰነረ ሙዳ ባሀርንታ ካንተንዘን ዎእሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ኮተረ ቡር በድ ርንከስም ካምስካ ኩንጋየሮ ከትም ኬዛ የጄ፥ “ኮሰቼቴ! ዋልቃ ዎንንባብ ማሳካንታ ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ክት ማዝድንከረ ዋልቃ ዋልቃ ማሰና ጎግታ ካንተዘን ዋችንካ አፍትንከስ Ꮊድሰኮ ካምት እቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ዋልቃ ዋልቃ ማሰነረ ኡርማ ፍጫ ካየን Ꮊርቸንዘን ዋቼ፥ ፍጨነረ ኮታዘን በድ ካየንካንታ ጩላ ሶሰረ ፍጨና በዳዬ፥ ኮካንታ ማሰነረ ሳነካ ባቀልሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ማታጋካ ዳት Ꮊይና ዉተዳንደትካ ሱልሴ፥ ጫጭ ካየንካንታ ዎቼ። ");
INSERT INTO gyl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ዋልቃ ዋልቃ ማሰነረ ኡክም ዶቅድን ቆቸናር ዋቼ፥ ኡክምነረ ጋጵሶ ባቅለንም ጉርት የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ዋልቃ ዋልቃ ማሰነረ ኡርማ ፍጨዘን ዋችሶ ባቅልስንደትኬ በድ አፍ ኡሴ፥ ዋልቀና ጨታ፥ ዋልቀና ማከን ቦንዳ፥ ዋልቀነረ ቦንደኬ ታማ አፍ ኡሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ቃም ዶቅድባብ ኤሰራ!” ");
INSERT INTO gyl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ኮታ ቡር ክታ ካርንካ ጎርስምድባብከስ የሱሰደር Ꮊድሰኮ፥ “Ꮊራካንተስ ዎርሰንካንታ ካምስካ ከዝዳ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","የሱሰረ፥ “የካንታ ጭላ ባንችምንታ አችምሳንደትም ኤስንተን የካንታ እምምቴ፥ ከትካንታ ማቼ እምማክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ዶቅድባብካንታ ጉጅምሶ እምምተሬ፥ ክትካንታ በተሬ፥ ካየንባብ ኤድንዘንካ ማቼ ና ዶቅድንዳ ዎራ ክታዘንካ ተይምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ኮካንታ ሰደኮ ሰዳክንባብከስግንዳ፥ ኤሰርደኮ ኤሰርዳክንባብከስግንዳ አነረ ገቀርት ተይዳክንባብ ከስግንዳ ከት ማቻንካንታ ይና፥ እታ ካምስካ ከትካንታ ኬዝድቴ”። ");
INSERT INTO gyl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ኮካንታ ሳብዘንካ ኤሰርሶ ኬዛቅባብ እሳስካ፥ ኤስርንም ኤሰርደቴ፥ ኬዛርንካ ማቼ ገቀርት ተይዳከቴ፥ ሰድንመረ ሰደቴ፥ ኬዛርንካ ማቼ ቡዳ ይዳከቴ፥ ኩን ጋይምሶ ጻፍምሳንዳ ከታዘን ቦድምድንግንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ኮ ዎርሰንታ ቡደና ዳቅቴ፥ ቃምነረ ከታ ቱንቴ፥ ከታ አፍነረ ግንእቴ፥ ኩን ማታከስናና ከታ ይንታ አፍንከረ ሰድሰኮ፥ ከታ ይንታ ቃምንከረ ኤሰርሰኮ፥ ከታ ይንታ ቡደንከረ ገቀርት ተይሰኮ፥ እዝደር ከት ማቸስናና ከትም ፋችተርት ዶቆ፥ ኩንጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","የንታ ማቼ አፍንከስ ሰድንካንተኬ፥ ቃምንከሰረ ኤሰርድንካንታ አንጅምስባበቴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ዶፈን የም ጋይድቴ፥ በድ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስከ ጭል ኤድንከስ የ ሰድንደትም ሰድንካንታ አንገርተክ ዶቆ፥ ኬዛርንካ ማቼ ሰዳከኬ፥ የ ኤሰርድንደትመረ ኤስርካንታ አንገርተክ ዶቆ፥ ኬዛርካ ማቸ ኤሰራከኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ይና የታ ማሰንባብታ ካምስንከስታ ቡልና Ꮊራ ኮት ማቸረ ኤሰርከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ጎግታ ካንተናር ዋቻን ማሰና፥ ሳብታ ባንችምንታ ቃለንም ኤሰርሶ ገቀርት ተይዳክን ኤድንም ካምዴ፥ ሳናናና ዳቅልና Ꮊድሶ ክታ ቡደናር ማስምሳን ቃለንም ክታዘንካ ተይዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ꮊርቻ ፍጨንዘን ማስምሳንዳ፥ ቃለንም ኤሰርሶ ሳናናና ጉርምካ ተይድባብ ኤድንም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","“ኬዛርንካ ማቼ ሰጫካንታ ዳት ክታ ቡደናር ጫጭ ኦይታክየ፥ ኮካንታ ቃለንጎካ ዋልቃ ማጣ አነረ ዳይር ክታዘን የልሳንደትካ ሳነካ ኮተርዴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ኡክም ዶቅድን ቆቸናር ማስምሳንዳ ቃለንም ሰጫካንታ ኤሰርድን ኤድንም ሰጅዴ፥ ማታጋካ ዳት ኮ ፍጫሙደንታ ገቅርንከ ቆልመታ ሶልመና ክታ ቡዳር አርድሶ ቃለንም ጉንእት የድንካንታ አፍ ኡስክሳ ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ኡርማ ፍጨንዘን ማሰርሳንዳ፥ ቃለንም ኤሰርሶ ገቀርት ተይድባብ ኤድንም ሰችዝደ፥ ኖ አፍ ኡዝዴ፥ ዋልቀና ጨታ፥ ዋልቀና ማከን ቦንዳ፥ ዋልቀና ቦንደከ ታማ አፍ ኡዝዴ”። ");
INSERT INTO gyl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ኮትኮግንደረ የሱስ አብ ካምስካ፥ “ጭላ ባንችምና ይንታ ዎን Ꮊምናር ኡርማ ማሰንም ማስባብ ኤችንም ና ካምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ኬዛርንካ ማቼ ኤድ ሙደና ራቻንደታ ቡሪ ክታ ይምኤንባብ Ꮊድሶ ዘርግንታዋር ለሰንም ማስሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ዘርግነረ ባቀልሶ ፉጥማ የድንካ ለሰነረ ኮታይካ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ኮካንታ Ꮊምንባብታ ፍክስንባብከስ ክደር Ꮊድሰኮ፥ ‘የ ዎባቦ፥ የስታ ዎን Ꮊምናር ኡርማ ማሰን የና ማሳካ? ይና ኮናና፥ ለሰና Ꮊምንኮክ Ꮊዳሬ?’ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ኖየረ፥ ‘ኮም ይስባብ ኖ ይምኤንባቤ’ ከደር ጋይሴ። ፍክስንባብብከሰረ ‘ይና ኮናና ለሰንም አይሶቶ ዎ ቡጭድንግንዳ ዝግዳ?’ ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ኖ ማቼ ኩንጋየሮ ከትካንታ ማስሴ ‘ኩን ማታዬ ለሰንም የ ቡጭድንካ ዘርግንመረ ዋር ቡጭደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ኮካንታ ዛእከቴ፥ ስከርድን ሰጨና የልተርን የለልታ ዘርግነረ ለሰነረ የካ ከት ጋጳ፥ ስከርድን ሰጨን Ꮊይካ ስክንባብከስም ለሰንም እርናና ቡጭከቴ፥ ኖሄከረ አድንግንዳ ናርካ ዞከተ፥ ዘርግንም ማቼ ሳንስሰቶ እስታ ቡለናር አርችከቴ’ ከትም ጋይድቴ”፥ ኩንጋየሮ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","የሱስ አብ ካምስካ “ጭላ ባንችምና ዋልቃ ኤች ሰናፍጭ ጋየርድን ማሰን ተይሶ ዎን ካርናር ማሳን ማሰንም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ናየረ ማሳ ሙደንዘንካ ቶክሳንዴ ይ ጋጵሳንደትከረ ኮርምሳን ሪ ሙደንዘንካ ና ስገዴ፥ Ꮊቃከከረ ና ማዴ፥ አፍትንከሰረ Ꮊድሰኮ ኮታ ሳቀንከዘን ኤሄን ይንታ ዎድሰኮ ዶቅደኬ” ኩንጋየሮ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ጉጅሰረ የሱስ፥ “ጭላ ባንችምና ዋልቃ ኤተን ማከን ጋበት እለንም ተይሶ ማጠን ኡስዝድን እርሰንካ ክክን ሪችሳን እርሰንም ካምዴ፥ እርሰነረ ማጠና ሙዳ ኡዝድንግንዳ ይሴ” ኮም ካምስንከስም ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","የሱስ ኬና ሙዳ ርን ካምስካ ዎርሰንካንታ ኬዜ፥ ካምስካይሳ Ꮊረርየረ ከትካንታ ከዛክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ኮነረ ኮት ኩን ማቻንዳ ሳብዘንካ ኤሰርሶ ከዛቅባብካ፥ “እስታ ኬዘንም ካምስካ መያ ማዝድቴ፥ ኮፍጫ ሙደና ፍዝምሳንደትዘንካ የድሶ አችምሳንደትም ኬዝድቴ” ኩን ጋይምሶ ጻፍምሳንዳ ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ኮታ ቡር የሱስ ዎርሰንም ዛቅሶ ኤሀር አርደዴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ክደር Ꮊድሰኮ፥ “ዎን Ꮊምናር ዶቅድን ለስንታ ካምስንታ ቡልንም ዎም ኬዝካ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","የሱሰረ፥ “ኡርማ ማሰንም ማስባብ ኤድ ይንቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ዎን Ꮊምነረ ኮፍጫ ሙደኔ፥ ኡርማ ማሰና ሳብታ ባንችምንታ ይንችንከሰከ፥ ለሰነረ ሰጣንታ ይንችንከስከ። ");
INSERT INTO gyl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ለሰንም ማስባብ ይምኤንባብ ዳብሎሴ፥ ስከርድን ሰጨነረ ኮ ፍጫሙደንታ በእንተነ፥ ስክንባብከሰረ ክታይንችንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ገታ ለሰና ቡጭምሶ ኖሄካ አተርድንደትግንዳ ኮ ፍጫሙደንታ በእንተነረ ኮትኮግንዳ ማደ። ");
INSERT INTO gyl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ኮትኮᎺይካ ኤደት ይንች ይንታ ክታይንችን ኦይዴ፥ ከተረ ጎማ ፍክስታ ጎግ ማችባብከስምከ ዳቅል ፍግዝድባብከስም ሙዳ ክታ ባንችምናርንካ ሳንስሶ ከትም ዉችተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ድግዳክን ኖሄናረረ ከትም ኦይተሬ፥ ኮታር ኤፍከ አች ቅርጭካ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ጭልንከስ ይንታ ባበንታ ባንችምናር Ꮊይግንዳ ሳክስተረከ፥ ቃም ዶቅድባብ ኤሰራ!” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ኮታዘንከረ የሱስ፥ “ጭላ ባንችምና ዎን Ꮊምናር አችምሳን ቆልመንም ና ካምዴ። ዋልቃ ኤች ኮትኮ ቆልመንም ይ Ꮊፍሳንደትካ ማስትዮ አቼ፥ ይንታ ጉርምንታ በድምዘንካ አምሳንዳ አይሶ ይንታ ዶቅድንደትም ሙዳ ሰንሶ ኮትኮ ዎን Ꮊምንም ሰንት ተዬ”። ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","አናካርንከረ የሱስ፥ “ጭላ ባንችምና ኡርማ እንቁ ጋየርድንደትም ሰንት ተይካንታ ዝግድባብ ዛለንባብም ና ካምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ዛለንባበረ ስንጋ ማቻን እንቁ ጋየርድንደትም ይ Ꮊፍሳንደትካ አይሶ ይንታ ዶቅድንደትም ሙዳ ኦስ ሰንሶ ኮትኮ እንቁ ጋየርድንደትም ሰንት ተዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","ኮታዘንከረ የሱስ፥ “ኮትኮግንደረ ጭላ ባንችምና ሎቀን ባሀርናር ኦይትምሶ ሞለን የድን ሳከንም ና ካምዴ፥ ናኮና ሳከነረ Ꮊክ Ꮊክ ሞለንከስም የድንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ኮታር ጮጫንደትካ ሞለን የድባብከስ ሎቀን ባሀርንታ ፋማ ጎችት ዉጅደኬ፥ ከታ ዶቅሰረ ኡርማ ኡርመን እድሰኮ ርያር ዎደከ፥ ዳቅል ዳቅልንም ማቼ ኦስ ዛቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","በእንታ ስለናር ኮትኮግንዳ ማዴ፥ ክታይንችና Ꮊድሶ ጎመንባብከስም ጭልንከሳርንካ ከትም ፋስተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ዳቅልንከስም ድግዳክን ኖሄናር ከትም ኦይተሬ፥ ኮታር ኤፍኬ አች ቅርጭካ ማተረ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ጉጅሰረ የሱስ፥ “ኮም ሙዳ ገቀርት ተየቴ?” ከደር ጋይሴ። ከተረ፥ “ይዬ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","የሱስ፥ ኮና ኩን ጋይንትና ዋልቃ ሙሴታ ህግንም ኤስዝድባብ “ጭላ ባንችምንትደትም ኤስሶ ይንታ ቡለናርንካ ክለንምኬ ገሳ ሪንከስም ዉጅድባብ ኤችንም ካምዴ” ኩንጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","የሱስ ከትኬና ካምስንከስም ኬዝሶ ይ በይሳንደታ ቡር ኮት ካርናርንካ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ይ አጠርሳን ናዝሬት ካተመናር Ꮊድሶ አይሁድንታ ምክስ ኤሄናር ዎርሰንከስም ኤስዝድ Ꮊቄ፥ ኤሰርስባብከሰረ ሙዳ በርእካ ኩን ጋይድ Ꮊቀኬ፥ “ኮና ኤችና ኮም ኤጨንምኬ ኮም በርእስዝድን ፍክስን Ꮊምንክክ ተይ Ꮊዳሬ። ");
INSERT INTO gyl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ኖኮና ኤሄን ዎድባብ አናጭንታ ይንችና ካዮ? ክታ እንደንታ ላምና ማራማ ጋይምድንዳ ኮዮ? ክታ እስመንከሰረ ያይቆብ፥ ዮሴፍ፥ ስምኦንኬ ይሁደካ ካየኮ? ");
INSERT INTO gyl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ክታ ምችነንከሰረ ሙዳ ዎንካ ክክን ካየኮ፥ ይና ኮናና ኮና ኤችና ኮም ሙዳ ኤጨንም Ꮊምንክክ Ꮊፍሳሬ?” ");
INSERT INTO gyl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ኮትኮጎከረ ክትካ ጎሄርሰኮ ክታ ኬዘንም ተይክሳ ነገደኬ የሱስ ማቼ፥ “ሳብዘንካ ኤሰርሶ ኬዝድባብ ቦንችምዳክንዳ ይንታ አጠርሳን ፍጨዘንኬ ይንታ ገታ ኤሄናር Ꮊክዬ” ከደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ከት አሜንክሳ ነገዳንጎካ የሱስ ኮታር በድ አተንም ፍክሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ኮታይካ ገሊላ ፍጨን ቆልድ Ꮊቅባብ ሄሮድስ፥ የሱሰታ ፍክስንጎካ ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ይንታ ፍክስንባብከስመረ፥ “ኮና ስእስንባብ ዮሀንሴ፥ ኖየረ ደእያርንካ አምቴ፥ ኬና በርእስዝድን ርንከስ ክትጎካ ይማዶቅድንዳ ኮካንተ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ሄሮድስ ዮሀንሰም የችስሶ ዞክና ኤሀር ዞክስሶ Ꮊቄ፥ ኮመረ ክት ይሳንዳ ክታ እስመን ፍልጶሰታ ኬነን ሄሮድያዳጎከ። ");
INSERT INTO gyl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ꮊረታ ጋይሴ ዮሀንስ ሄሮድስካንታ “የስታ እስመንታ ኬነንም የስ እንጅድንግንዳ ህግና ጋያዬ!” ክትም ጋይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ኮካንታ ሄሮድስ ዮሀንሰም ደይሳካንታ ዝግድ Ꮊቄ፥ ኬዛርንካ ማቼ ዎርሰንከስ ሳብዘንካ ኤሰርሶ ኬዝድባብግንዳ ክትም ከት ሰድንካንታ ዎርሰንከስካንታ ኖ ጳሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ሄሮድሰታ አጥር ሰጨንም ቦንጅድንደትካ ሄሮድያደታ ይንቸና Ꮊድሶ ሶችንከስታ እሪ ይግካ በይደሮ ሄሮድሰም ና ጉርምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ኮካንታ ሄሮድስ፥ “የስ ዝግድንደትም እም ኦይስካ! እተረ የስካንታ እምትቴ!” ኩንጋየሮ ጫቅሶ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ና ይንቸነረ ይንታ እንደንታ ዞረንካ፥ “ስእስንባብ ዮሀንሰታ ቃደንም ጋበትያር ዎታዮ ሳነካ እካንታ እምካ!” ና ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ባንችና ኮ ኬዘንካ ሞርእሴ፥ ማታጋካ ዳት ይንታ ጫቀንጎከ ክትካ ክክን እችምካንታ ዶቅሶ Ꮊቃን ኤድንከስጎካ ኦስንሶ ዮሀንሰታ ቃደና እምምድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ኮካንታ ዞክና ኤሀር ኤድም ኦይትሶ ዮሀንሰታ ቃደንም ተችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ተቻን ቃደንም ጋበትናር ዎትዮ ይንቸንንካንታ እምሴ፥ ና ይንቸነረ ይንታ እንደንካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ዮሀንሰታ ካርንካ ጎርስምድባብከስረ Ꮊድሰኮ ክታ ለይስንም ተይ አይሰኮ ዱክሰኬ፥ ከተረ አይሰኮ ኮም ሪይንም የሱስካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","የሱስ ዮሀንሰታ ደእንም ይ ኤሰርሳንደትካ ሎቀንዘንካ ቃልዝድን ጃልበናር አርድሶ Ꮊርን ጋይሳን ካርዘን ይንት አይሴ። ዎርሰንከሰረ ኮም ሙዳ ይ ኤሰርሳንደትካ ካተመንከሳርንካ ዉትሰኮ ዱትካ ክትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","የሱስ ሎቀንዘንካ ቃልዝድን ጃልበናርንካ ይ Ꮊንቸርሳንደትካ በድ ዎርሰንከስም ሰድሶ ከትካንታ አተርሰ ከታርንካ ሰቀርስባብከስመረ ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ፍጨና ሶይቻንደታ ቡር ክታ ካርንካ ጎርስምድባብከስ ክደር Ꮊድሰኮ “ኮና ካርና Ꮊረነረ Ꮊፈርዳክንዳ ኤድ ካየንካርዬ ፍጨነረ ሶይቴ፥ ኮካንታ ዎርሰና ቅንች ዶቅድን ሞረንከሳር አይሰኮ ከታ ይ እጅድንደትም ሰንት ተይᎺድንግንዳ ከትም ኦይትካ” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","የሱስ ማቼ “የታ ከት እጅድንደትም እምከት ዳት ከትም አይ ዝክሳዬ!” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ክታ ካርንካ ጎርስምድባብከሰረ “ዎንታ ካሪ ዶቅድንዳ ዶንቅ ባይስኬ ቃስተን ሞለካ Ꮊክዬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","የሱሰረ “የንደር ዶቅድን ከትም እዝደር ተይ Ꮊድከቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ኮታዘንከረ ዎርሰና ድረንዘን ዶቅድንግንዳ ክትሴ፥ ዶንቅ ባይስንምከ ቃስተን ሞለን ተይሶ አፍን ይንታ ጭላር ማስሶ ጋለቼ ባይስንመረ አስትዮ ይንታ ካርንካ ጎርስምድባብከስ ካንተረ እምሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ዎርሰንካንታ የልስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ሙደነረ እችሰኮ ምሰኬ፥ ስጣን ዶከንም ክታ ካርንካ ጎርስምድባብከስ ታመከ ቃስተን ጋባስርካ ጮጭ አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","እችባብ ኤድንከሰረ ማነንከስክኬ ይንችንከስ ፋይድማክናና ዶንቅ ሳአ ማድን አⷝኔንከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ኮታ ቡር የሱስ ይንታ ካርንካ ጎርስምድባብከስም፥ “እታ ዎርሰንከስም እ ኦይተርን የለልታ ሎቀንዘንካ ቃልዝድን ጃልበናር አርድሰቶ እርናና ባሃርንታ ፋማ ቃልከተ” ጋይሶ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ዎርሰንም ይ ኦይቻንደታ ቡር ምክስካንታ ይንት ገቸንዘን ዉተዴ፥ ፍጨና ሶይቻንደትከረ የሱስ ኮታር ይንት Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ኮታይካ ሎቀንዘንካ ቃልዝድን ጃልበና ዎእድን ካርንዘንካ ኦስ ባሀርንታ ዎክያር አይድንካ ኮታ እርጎካ Ꮊድን ዞገንካ Ꮊቅመሮ ሎቀንዘን ዶቅድን ዞገንካ ኦስከ ፈንካ ዙብምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ሶይት ሳክላ ሳዓታ ቡር የሱስ ባሀርንዘን ሙከሮ ይንት ይንታካርንካ ጎርስምድባብከዝደር Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ክታካርንካ ጎርስምድባብከሰረ ባሀርንታዘን ሙከሮ አይድንካ ሰድሰኮ አንድር ጳስካ ገቅሰኬ፥ “ኮነረ ቡንኬ!” ጋይሰኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","የሱሰረ ሳናናና፤ “ዳእከቴ! እትቴ Ꮊይጳሰቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ጴጥሮሰረ፥ “የ ጮይስዮ! የስ ማቼ ባሀርንታዘን ሙከርቶ የዝደር እ Ꮊድንግንዳ እም ክትካ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","የሱሰረ “Ꮊድካ!” ክትም ጋይሴ። ኮካንታ ጴጥሮስ ጃልበናርንካ Ꮊንቸርሶ የሱሰደር አይካንታ ባሀርንታዘን ሙከሮ አይ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ኬዛርንካ ማቼ ዞገንታ ዎልቀንም ሰድሶ ጳሴ፥ ባሀርንታ ዋር ኤቅዝም ይ የጃንደትካ “የ ጮይስዮ! እም አቅስካ!” ጋይሶ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ሳነካ የሱስ ይንታ አንን ኦይትሶ የድስንደትኬ፥ “የና አሜን የስታ ዞገርስባብ! Ꮊረተስ Ꮊኤርሳራ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","የሱሰኬ ጴጥሮስካ ጃልበናር ከት አርደዳንደትካ ዞገና ስምን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ኮታዘንከረ ጃልበናር Ꮊቅባብከስ፥ “ዶፈን የና ሳብታ ይንቸዬ!” ጋይሰኮ የሱሳካንታ ጎስትሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ ባሀርንም ቃልሰኮ ገንሰረጥ ፍጨናር የልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ኮት ፍጨናር Ꮊቃን ኤድንከስ ክት የሱስ ማትንተን ከታ ይ ኤሳንደትካ ላመካ ዶቅድን ፍጫ ሙደናርንካ አይሰኮ ሰቀርስባብከስ ሙደንም ክደር ተይᎺችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ሰቀርስባብከሰረ ክታ አፍለንታ ካንተን Ꮊክ ከት ዎልድንግንዳ ክትም ምክሰኬ። ክትም ዎልስባብከሰረ ሙደና ይንታ ሰቅምናርንካ ቦድሶ ፋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ኮታ ቡር የሩሳሌም ካተመናርንካ Ꮊድባብ ፈረሳውያንንኬ ሙሴታ ህግን ኤስዝድባብከስ የሱሰደር Ꮊድሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“የስታ ካርንካ ጎርስምድባብከስ ጋልተንከስታ ዎገንም Ꮊራካንተረ ከት ክትምዳክንዳ? ይና ኮሰቸቴ! እችም ከት እጅድንዳ ከታ ይንታ አንከስም ስኤራክሴ!” ኩንጋይሶ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","የሱሰረ፥ “የታ የንታ ዎገንም ካርስካንታ ጋይሰቶ ሳብታ ክተንም Ꮊራካንተንት ዉልእዳ? ");
INSERT INTO gyl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ሳብ ‘የስታ ባበንምኬ እንደንም ቦንችካ፥ ይንታ ባበንም አነረ ይንታ እንደንም የግድባብዘን ደእታ ዋጭና ክታዘን የልተሬ’ ጋይሶ ክቴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","የታ ማቼ ዋልቃ ኤድ ይንታ ባበንም አነረ ይንታ እንደንም ‘እዘንካ የᎺብድን አለንም ሳብካንታ እማ ማስስቶ እምትቴ’ ከደር ጋይዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‘ኖኮና ኤችና ይንታ ባበንም አና እንደንም ቦንቻ ክትም ዝክሳዮ’ የታ ጋይደቴ፥ ኮካንታ የንታ ዎገንም ካርስካንታ ጋይሰቶ ሳብታ ህግንም ዉልእደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","የታ ኦተረንባብከሶ! ኢስያስ የጎካ ኩንጋይሶ ቤርካ ክት ኬዛንዳ ገተቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘ኮና ዎርሰና ይንታ አፈንካ እም ቦንጅዴ፥ ኬታ ቡደና ማቼ እዘንካ ጎተርሳንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ኤታ ዎገንምኬ ፍክስንም፥ ሳብታ ህግግንዳ ማስሶ ኤስሰሮ ዉችኩን እም ጎይንደኬ’ ” ኩን ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ኮታዘንከረ የሱስ ኤድንከስም ይንደር ኤልሶ፥ “ኤሰርከቴ! ገቀርተረ ተይከቴ! ");
INSERT INTO gyl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ኤድም ቱና ማስዝድንዳ ክታ አፈናርንካ ዉድንዳ ዳት ክታ አፋር አርድንዳ ካዬ!” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ኮታ ቡር ክታ ካርንካ ጎርስምድባብከስ ክደር Ꮊድሰኮ “ፈረሳውያንንከስ ኮም የስ ኬዛንደትም ኤሰርሰኮ ከት ኮተርሳንደትም የና ኤስታ? ኩን ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ኖ ማቼ ጭላርንባብ እስታ ባቤና ኮራክን ኮረና ሙዳ ቡጭምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ኬታ ይንታ ማታ አፍይ ዝልኬ አፍይ ዝልንከስም ጎርዝድባብ ከት ማቻንካንታ ከትም ዛእከቴ፥ አፍይ ዝልና አፍይ ዝልንም ጎርዝዴ ኬታ ቃስተነረ ጎርናር ዋጅደኬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ጴጥሮስ ማቼ የሱሰም “ካምስንታ ቡልን ዎካንታ ኤስምስካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","የሱሰረ “የታ ታ የለልታ ገቀርት ተያከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","አፋር አርድ ሪ ሙደና ልጳር የልሶ ኮታ ቡረረ ኦስ ድራሳን ማትሶ ዉድንደትም ገቀርት ተይዳከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","አፋርንካ ዉድንዳ ማቼ ቡዳርንካ ዉዴ፥ ኤድም ቱንዝድንዳ ኮኔ። ");
INSERT INTO gyl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ኬተረ ዳቅል ገቅር፥ ኤድንም ደይሳ፥ ማነንም ኦካኦንግድባብ፥ ቤልምድባብ፥ ድቢይ፥ ካርከካ ማርክር ኤድም የክይ፥ ኬና ሙደና ኤታ ቡዳርንካ ዉዴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ኤድም ቱና ማስዝድንዳ ኬና ከስ ዳት አን ስኤራክሳ እችና ቱና ማስዝዳክዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","የሱስ ኮታርንካ ዉትሶ ጢሮሳርኬ ስዶና ካተመንከስታ ሞረናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ኮታዘንከረ ከነአን ፍጫ ኤተን የሱሰደር Ꮊድሶ፥ “ጮይስ ማችባብ ዳውትታ ይንችኖ! እስታ ይንቼና ቱና አያንካ የደርሶ አንድር ማጥራዶቅዴ ዋደ እካንታ አተርካ!” ኩንጋየሮ ና ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","የሱስ ማቼ ዋልቀረ ኮትካንታ ከዛክ ዶቆ ጫምን ጋይሴ፥ ኮታይካ ክታ ካርንካ ጎርስምድባብከስ ክደር Ꮊድሰኮ፥ “ናኮና ኤተንና ዎም ጎርስመሮ ኮት ፍብድንካንታ ዋዴ ኮትም ኬዝሶ ማስካ!” ጋየረኮ ክትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ኖየረ “እ ኦይትምሳንዳ እስራኤል ኤድንከሳርንካ ቆልንከስግንዳ ካይድባብከስካንታ Ꮊክዬ” ጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ኤተና ማቼ Ꮊድሶ ክታ ዱትንታዘን ዋችሶ፥ “የ ጮይስዮ! እም አሌንም አልካ!” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","የሱሰረ፥ “ይንችንከስታ እችምን ተይሶ አክስንከስካንታ እማ ኡርማ ካዬ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ኤተነረ “የ ጮይስዮ! ኮና ገቴ ኬዛርንካ ማቼ አክስንከሰረ ከትም ቆልድባብከስታ እችምናርንካ ዋጅድንደትም ድንግመንም እጅደኬ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ኮታይካ የሱስ “የና ኤተኖ የስታ አሜንና! አንድሬ፥ ኮካንታ የስታ ዝግመትንግንዳ የስካንታ ማታ!” ኮትም ጋይሴ። ኤተንንተረ ይንቸና ኮት ሳዓትንዘን ፋጬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","የሱስ ኮታርንካ አምሶ ገሊላ ባሃር ሎቀንታ ላማር Ꮊዴ፥ ገቸንዘን ዉትሶ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","በድ ኤድንከስ ዎከል ዎከልን ጋይድን ኤድንከስም አፍይ ዝልንከስም ዎብንከስም አፋ ከዝዳክባብከስም አብንከስምኬ ሰቅምንክንባብከስም የድሶ የሱሰደር ተይ Ꮊደኬ፥ ክታ ዱትንታ ላመር ዎጀኬ ኖየረ ከትም ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ኮካንታ ዎርሰና አፋ ከዝዳክባብከስ ኬዝድንካ፥ ዎብንከስ ፋጭድንካ ዎከልዎከል ጋይድባብከስ ኡርመካ ከት ሙግድንካ፥ አፍ ዝልንከስ ሰድንካ ከታ ሰድሰኮ በርኤረኮ እስራኤልንከስታ ጮይስንም ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","የሱስ ይንታካርንካ ጎርስምድባብከስም ኤልሶ፥ “ዎርሰንከስ እንካ ክክን ማከን ሰጫ ከት Ꮊቃንጎካ ከት እጅድን ሪ ካየንካንታ ከትጎካ አተርድቴ፥ አይደኮ ጎግዘን ከት ዋጅዳክንግንዳ ከት እቻክናና ኦይትካንታ ዝግዳክቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ክታ ካርንካ ጎርስምድባብከሰረ “ይና ኮ ሙዳ ዎርሰንከስካንታ ማድን እችም ኮ ዴል ቆቼናር Ꮊምንኮንት Ꮊብዳ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","የሱሰረ “የንደር መም ሶላ ዶቅዳ?” ጋይሶ ከትም ኦይሴ። ከተረ “ታብዛ ባይስኬ ቶክም መራ ሞለንከስ ዶቅዴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ኮታ ቡር የሱስ ዎርሰንከስም ፍጨዘን ዶቅድንግንዳ ክትሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ታብዛ ባይስንምኬ ሞለንም የድሶ ይ ጋለቻንደታ ቡር፥ ባይስንም አስትዮ ይንታ ካርንካ ጎርስምድባብከስካንታ እምሴ። ከተረ ዎርሰንከስካንታ የልስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ሙደነረ እችሶ ምሰኬ፥ ስጣንደትመረ ክታ ካርንካ ጎርስምድባብከስ ሳንስሰኮ ታብዛ ጋባስርካ ጮጭ አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","እችባብ ኤድንከሰረ ማነንከስኬ ይንችንከስካ ፋይድማክናና ኦይድ ሳአ አⷝኔንከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ኮታ ቡር የሱስ ዎርሰንም ኦይቼ፥ ሎቀንዘንካ ቃልዝድን ጃልበናር አርድሶ መገዶን ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ፈረሳውያንንከስኬ ሰዱቃዊያንንከስ የሱሰደር Ꮊድሰኮ ክትም ጰጫካንታ ዝግሰኮ “ጭላርንካ ቃዉተንም ዎካንታ ሰችስካ” ኩንጋየሮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","የሱስ ማቼ፥ “ሶይት ጭለና ዘይስንካ የ ሰዴ ‘ፍጨና ኦይጥማ ማዴ’ የታ ጋይደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ፍጨና ሰጭድንካ ‘ጭለና ኡፔካ ዘይሶ ጫልድንካ ታካ ዶብ ቃንዴ’ ጋይደቴ፥ ጭለንም ሰድሰቶ ፋስት ኤዝደቴ፥ ኬዛርንካ ማቼ ስለንታ ቃዉተንም ማቼ ፋስት ኤዝዳከቴ ");
INSERT INTO gyl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ዳቅልንከስኬ አሜንዳክን አጥርንከስ ቃዉተንም ሰድንካንታ ዝግዴ፥ ኬዛርንካ ማቼ ሳብዘንካ ኤሰርሶ ኬዛቅባብ ዮናሰታ ቃዉተንዘንካ አብ ቃዉታ እምምዳክዬ ጋየሮ ከትካንታ ማስሴ”። ኮታዘንከረ የሱስ ከትም ዛቅሶ አብ ካርዘን አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ክታ ካርንካ ጎርስምድባብከስ ባሀርንታ ፋማ ከት ቃልሳንደትካ ባይስንም ባቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","የሱስ ይንታካርንካ ጎርስምድባብከስም “ቡደርሶ ገቀርከቴ ፈረሳዊያንንከስተከ ሰዱቃንንከስታ እርሰንዘንካ ካርስምከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ከተረ “ኮም ክታ ጋይና Ꮊረንግርካ ባይስንም ዎ የዳክንካንታ ማደ” ጋይንተካ ክክክ ከዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","የሱስ ማቼ ከታ ገቅርን ኤስሶ “የታ አሜን ዞገርስባብከሶ! ‘ባይስን ዎ የዳክንካንቴ ጋይሰቶ Ꮊራካንተንት ክክ ክክ ከዝምዳ? ");
INSERT INTO gyl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ታየረ የታ ገቀርት ተያየቴ? ዶንቅ ባይስንም ዶንቅ ሳአ ኤድንከስ እችንካ ስጣንደትም ዶከንም መም ጋባስርካ ጮጭ የ አምሳናንከረ የም ገቀርሳዮ? ");
INSERT INTO gyl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ኮትኮግንደረ ታብዛ ባይስን ኦይድ ሳአ ኤድንከስካንታ ማቻንደትምኬ ስጣን ዶከንም መም ጋባስርካ ጮጭ የ አምሳንደትም የታ ገቀርዳከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ይና ፈረሳውያንንከዘንኬ ሰዱቃውያንንከስታ እርሰንዘንካ ካርስምከቴ!’ ጋይስቶ እ የም ኬዛንዳ ባይስንጎካ ማታክንደትም Ꮊስግንደረ የ ገቀርዳክንዳ?” ");
INSERT INTO gyl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ክታካርንካ ጎርስምድባብከሰረ የሱስ ካርስምከቴ ከትም ክት ጋይሳንደረ ፈርሳውያንንከዘንኬ ሰዱቃውያንንከስታ ዳቅል ኤስስን ዳት ማጠንም ኡስዝድን እርሰንዘንካ ማታክንደትም ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","የሱስ ፍልጶስ ቀሳርያ ጋይምድን ፍጨናር ይ የልሳንደትካ ይንታካርንካ ጎርስምድባብከስም “ኤድንከስ ኤድ ይንችንም Ꮊየክ ጋይዳ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ከተረ “ዋልቃ ዋልቀንከስ ኤና ስእስንባብ ዮሀንሴ፥ አብንከስ ኤላሴ፥ አብንከስ ኤርማሴ አነረ፥ ሳብዘንካ ኤሰርሶ ከዛቅባብከሳርንካ ዋልቀኔ ጋይደኬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","የሱሰረ “የታ ማቼ እም Ꮊየንት ጋይዳ?” ኬትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ካርን ኮታዘን ስምኦን ጴጥሮስ፥ “የና ዶቅንት ሳብንታ ይንች ክርስቶሰየ” ጋይሶ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","የሱሰረ፥ “ዮነታ ይንችን ስምኦኖ! የና አንጅምስባበዬ ኮም የስካንታ መያ ማስስባብ ጭላር ዶቅድባብ እስታ ባቤና ዳት ኤድ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","እተረ የስም ኩን ጋይድቴ፥ የና ጴጥሮሳየ፥ ኮትኮ ላዝንዘን እስታ ምክስ ኤሄንም ዎድቴ፥ ኮትኮ ምክስ ኤሄንም ደእታ ዎልቀና ዎራ ጋማዬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ጭላ ባንችምን ፎጅድንደትም የስካንታ እምትቴ፥ ፍጨዘን የስ ዞክስባብ ሙደና ጭላረረ ዞከርስባብ ማደ፥ ፍጨዘን የስ ቡልስባብ ሙደና ጭላር ቡልምስባብ ማተረ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ኮታዘንከረ የሱስ ይንታ ካርንካ ጎርስምድባብከስም ክት ክርስቶስ ማትንተን Ꮊየሰንካንተረ ከት ኬዝዳክንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ኮታዘንከረ የድሶ የሱስ ይንታ ካርንካ ጎርስምድባብከስም፥ “የሩሳሌም ካተመናር አይ ዎም ዝግዝዴ፥ ኮታረረ ጋልተንከዘንካ ቀሰንከስታ ገችንባብከዘንኬ ሙሴታ ህግንም ኤስዝድባብከዘንካ፥ ማጠና እዘን የልዴ፥ ከታ እም ደይስተረኬ፥ ማችንከረ ማክምስ ሰጨንካ አምድቴ” ኩን ጋይ ከደር የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ጴጥሮስ ማቼ የሱሰም አብንከዘንካ Ꮊርሳ ይይሶ፥ “የ ጮይስዮ! ቦድሶ የዘን Ꮊይማታ! ኮና ሪና ቦድሶ የዘን የላዬ!” ኩንጋየሮ Ꮊጋ ክትም የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","የሱስ ማቼ ዋልንጋይሶ ጴጥሮሰም፥ “የና ሰጣንኖ! ኦስ እስታ ቡር አይካ! የና ኤተን ዳት ሳብትንደትም የስ ገቀርዳክንካንታ የና እካንታ ጎሄዬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ኮታ ቡር የሱስ ይንታ ካርንካ ጎርስምድባብከስም፥ “እስታ ካርንካ ጎርስምካንታ ዝግድባብ ይንታ ማተን ካዳ፥ ይንታ ማጠንመረ ደእ የለልታ ባልሶ እም ክት ጎርስማ። ");
INSERT INTO gyl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ይንታ ሰንፔንም አቅስካንታ ዝግድባብ ሙደና ኮትም ካይዝዴ ኬዛርንካ ማቼ ይንታ ሰንፔንም እካንታ ኮትም ካይዝድባብ ማቼ ኮትም Ꮊብዴ። ");
INSERT INTO gyl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ኤድ ፍጫሙደንታ ቆልመን ክት Ꮊፍሴ፥ ይንታ ሰንፔንም ክት ካይሴ፥ Ꮊሮክ ክትም መይዳ? አነረ ኤድ ይንታ ሰንፔንካንታ ቆትመን Ꮊርክ ናግዳ? ");
INSERT INTO gyl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ኤድ ይንች ይንታ ባቤንታ ቦንቸንካ ማትሶ ይንታ ክታይንችንካ ክክን Ꮊዴ፥ ኮታይከረ ዋልቃ ዋልቃባብከስካንታ ክታ ፍክስንከካ ክትካንታ እምምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ዶፈንካ እታ የም ጋይድቴ፥ ኤድ ይንች ይንታ ባንችምንታ ቦንቼንካ ማትሶ ክት Ꮊድንካ ኬታ ይ ሰተርን የለልታ ኮታር ዎእስባብከስታ ዎክያርንካ ደእዳክባብ ኤድንከስ ዶቅደኬ” ኩን ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ላ ሰጨታ ቡር የሱስ ጴጥሮስም፥ ያይቆበምኬ እስመን ዮሀንስምካ Ꮊክ ጎርስሶ ዋልቃ ጬክን ጋይሳን ገቼንዘን ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ኮታዘን ከትዶቅድንካ ኬታ እሪ ኦክምሴ፥ ክታ ባለነረ Ꮊይግንዳ ሳክሴ፥ ክታ አፍለነረ ጫምሳ ሳክመንግንዳ ማትሶ ሮጵሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ኮታዘንከረ ሙሴከ ኤላሰካ የሱሰካ ክክን ከዝምድንካ ከትካንታ ሰድምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ኮታይካ ጴጥሮስ የሱሰም “የ ጮይስዮ! ካሪ ዎ ዶቅሳናና ዎካንታ ኡርሜ፥ ኮካንታ የስ ዝግዴ ዋልቀንም የስካንታ፥ ዋልቀንም ሙሴካንታ ዋልቀንም ኤላስካንታ ማድን ማከን ዳልቼንከስም ኡርስትቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ጴጥሮስ አክ ኮም ኬዘዘን ክት ዶቅድንካ ሳግድን ኡፓ ከትም ስፍሰ፥ ኡፔታ ዋረረ “ክትካ እም ጉርምዝድባብ እ ሶልምድን እስታ ይንችና ኮኔ፥ ክትም ኤሰርከቴ!” ኩን ጋይድን ኡፍስ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ክታ ካርንካ ጎርስምድባብከሰረ ኮም ኡፍስን ከታ ይ ኤሰርስንደትኬ አንድር ገቅሰኮ ከታ ይንታ ባለንካ ፍጨዘን ጉፕን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","የሱስ ማቼ ከደር Ꮊድሶ ይንታ አንንካ ከትም Ꮊጭሶ “አምከቴ፥ Ꮊይጳሰቴ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ከተረ ጬክን ጋይሰኮ ከት ሰድንካ የሱሰዘንካ አብ Ꮊይመነረ ሰዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ገቼንዘንካ ከት Ꮊንቼርድንካ የሱስ “ኤደት ይንች ደእያርንካ አምተርን የለልታ ኮም የ ሰዳንደትም Ꮊየንካንተረ Ꮊይከዘቴ” ጋየሮ ይንታ ካርንካ ጎርስምድባብከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ክታ ካርንካ ጎርስምድባብከሰረ፥ “ይና፥ ሙሴታ ህግንም ኤስዝድባብከስ እርምሶ Ꮊድ ዝግዝድባብ ኤላሴ Ꮊረተክ ጋይዳ?” ጋየረኮ የሱሰም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","የሱሰረ፥ “ኮና ገቴ ኤላሰረ እርምሶ Ꮊዴ፥ ኖ ሙደንም ኡርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ኬዛርንካ ማቼ ኤላስ ኤና እር Ꮊቴ እታ የም ጋይድቴ፥ ኤድንከስ ማቼ ክትም ኤሳከኬ፥ ኮካንታ ከታ ይ ዝግዛንደትም ሙዳ ክታዘን ይሰኬ። ኮትኮግንደረ ጉጅሶ ኤደት ይንች ከታ አንያር ማጠንም ተይክትም ዝግዝዴ”። ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ኮታይካ ክታ ካርንካ ጎርስምድባብከስ የሱስ ኬዛንዳ ስእስንባብ ዮሀንስጎካ ማትንተን ኤሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","የሱሰከ ክታ ካርንካ ጎርስምድባብ ማከንንከስካ ክክን ዎርሰንደር ከት ማቻንደትካ፥ ዋልቃ ኤች የሱሰደር Ꮊድሶ ክታ እሪ ጉንፈርሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ጮይስዮ! ዋደ እስታ ይንችንካንታ አተርካ ባልት ክትም ኦይተሮ ግምዛ ሰቅምና አንድር ክትም ማእዝዴ፥ ኖሄታ ዋርከ ሎቀታ ዋረረ በድᎺይካ ዋጅዴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","የስታ ካርንካ ጎርስምድባብከዝደረረ ክትም ተይᎺትት ዶቆ፥ ኬዛርንካ ማቼ ክትም ፋችካንታ ማታከኬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","የሱሰረ፥ “የታ አመንምዳክን ዎብ አጥርና! Ꮊንታ የለልትስ የንካ ክክን እታ ዶቅዳ? Ꮊንታ የለልትስ የም እታ ዳንዳእዳ? ይና ይንችንም እዝደር ተይ Ꮊድከቴ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ኮታዘንከረ የሱስ ግምዘንም ዋጬ፥ ግምዘነረ ይንችንዘንካ ዉተዴ፥ ይንችነረ ሳዓትን ኮታዘነ ፋጬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ኮታ ቡር ክታ ካርንካ ጎርስምድባብከስ ከታ ይንት የሱሰደር Ꮊድሰኮ፥ “ዎታ ግምዘንም ዉችካንታ ዎ ማታክንዳ Ꮊረተረ?” ጋይሰኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","የሱሰረ፥ “የንታ አሜንንታ ቶክንታጎኬ፥ ዶፈንካ የም ጋይድቴ፥ ሰናፍጭ ጋየርድንደታ አፍከከንዳ አሜን የንታ ዶቅሳን ማቼ ኮ ገቼንም፥ ‘ኮዘንካ አምሳዮ ኦስ አይካ!’ የ ጋይሴ አይዴ፥ የም ጋምድንዳ Ꮊረርየረ ዶቃዬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(ኮግንዳ ግምዘና ማቼ በቼካ Ꮊቅሶ ምክሳክንዳ ማቼ ቦድሶ ዉዳክዬ” ኩን ከደር ጋይሴ)። ");
INSERT INTO gyl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ክታ ካርንካ ጎርስምድባብከስ ገሊላር ሳንምሰኮ ከትዶቅድንካ የሱስ ከትም ኩን ጋይሴ “ኤድ ይንችንም ስክስት ኤድንከስካንታ ክትም እምተረኬ፤ ");
INSERT INTO gyl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ከተረ ክትም ደይስተረኬ፥ ኖየረ ማክምስ ሰጨንካ አምተሬ” ክታ ካርንካ ጎርስምድባብከሰረ አንድር ሞርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ ቅፍርናሆም ካተመናር ከት የልሳንደትካ ሳብታ ጭል ኤሄንታ ግረን ተይድባብከስ ጴጥሮሰደር Ꮊድሶ፥ “የንታ ኤስስንባብ ሳብታ ጭል ኤሄንታ ግረንም ናግዳክዮ?” ጋይሶ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ጴጥሮሰረ፥ “ይዬ ኖ ናግዴ” ከደር ጋይሴ። ጴጥሮስ ኤሄናር ክት አርደዳንደትካ የሱስ እርምሶ “ስምኦን ጴጥሮሶ! Ꮊሮክ የዝደር ካምዳ? ፍጨዘን ባንችንከስ ቃረጭንከ ግረን ከት ተይድንዳ Ꮊይዘንከረ? ከታ ፍጫ ኤድንከዘንኮ አነረ ፍጫ ኤድ ማታክባብከዘንኮ?” ኩንጋይሶ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ጴጥሮሰረ “ፍጫ ኤድ ማታክባብከዘንኬ” ጋይሳንደትካ የሱሰረ፥ “ኩን ማቼ ከታ ፍጫ ኤድንከስ ግረንም ናካየክ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ኬዛርንካ ማቼ ከትካንታ ጎሀ ማተራክንግንዳ ባሀርናር አይሳዮ ሞለን የድን ማንጠቆን ኦይትካ፥ እርናና ዉድንደት ሞለንታ፥ አፈናርንካ ብራ Ꮊፍተራዬ፥ ኮት ብረንም ተይሳዮ እስተንምኬ የስተንም ናካ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ኮታይካ ክታ ካርንካ ጎርስምድባብከስ የሱሰደር Ꮊድሰኮ “ጭላ ባንቺማር ሙደንዘንካ ስገድባብ Ꮊይራ?” ጋይሰኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","የሱሰረ ዋልቃ ይንች ኤልሶ ከታ ዎክያር ዎይስሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ኩነረ ጋይሴ “ዶፈን የም ጋይድቴ የ ኦክማክንዳ ማቸኬ ይንችንከስግንዳ የ ማታክንዳ ማቼ ቦድሶ ጭላ ባንችምናር አርዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ይና ኮ ይንችንግንዳ ይንታ ማተንም ይርክሳ ይድባብ ጭላ ባንችምናር ሙደንዘንካ ስግ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“ኮግንዳ ዋልቃ ይንች እስታ ላምንካ ሞግድባብ እም ሞግዴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ꮊየነረ ኤድ እንካ አሜንድባብ ከትኬ መረንከሳርንካ ዋልቀንም ጎማር አርጅድንዘንካ ደጭማ ደይስን ሰይንንም ይንታ ባርናር ዞክሶ ባሀርንታ ጨርናር ኦይትምሶ ኤቅዝምሰስ ናና ክትካንታ ኡርዴ”. ");
INSERT INTO gyl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ኮታዘነከረ የሱስ፥ “ኤድንከስ ጎማር አርድንግንዳ ከት ይድን ሪንከስጎካ ፍጫ ሙደን የኤ! Ꮊንተረ ማታ ኤድም ኮተርዝድን ርንከሰታ Ꮊድንተና ነጋዬ፥ ኬዛርንካ ማቼ ኮተርዝድንደትም ተይᎺድባብ ኤችን ክትካንታ የኤ! ");
INSERT INTO gyl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","የስታ አነረ ማታ የስታ ዱትነረ ጎማ የስ ፍግዝድንግንዳ የስም ኮተርዝደ ተችትዮ የዘንካ Ꮊልእስካ! ቃስቴን አን ናንከረ ቃስቴን ዱት የስታ ዶቅስንካ ስለንካ ድግዳክን ኖሄናር የስ ኦይትምተርንዘንካ፥ ዱንግላ አነረ ዎከል ዎከልን ጋይድባብ ማትሳዮ ስለንክንደታ ዶቅንተናር የስ አርደዳናና ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","የስታ አፍነረ ጎማ የስ ፍግዝድንግንዳ የስም ጎማር አርጅደ ዉችተዮ ዛእካ! ቃስቴን አፍ የስታ ዶቅስንካ ድግዳክን ኖሄናር የስ ኦይትምተርንደትዘንካ ዋልቃ አፍ የስታ ዶቅስንካ ስለንክንደታ ዶቅንተናር የስ አርደዳናና ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ጭላር ዶቅድባብ ከታ ክታይንችንከስ ሙዳᎺይካ ጭላር ዶቅድባብ እስታ ባቤንታ ባለንም ከት ሰድንካንታ ከትከ መረንከሳርንካ ዋልቀንመረ ዎራ የ ቶጅዳክንግንዳ ካርስምከቴ።  ");
INSERT INTO gyl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ኤደት ይንቼረ Ꮊዳንዳ ካይድባብም አቅስካንቴ”። ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ኮታዘንከረ የሱስ፥ “ይና የንደር Ꮊረሞክ ካምዳ? ዋልቃ ኤችንታ ጨታ ቆል ክታ ዶቅድንዳ ማቸኬ ከታርንካ ዋልቀና ክታዘንካ ካይዴ ኦይድ ቦንደከ ታመኬ ሳክለን ገቼዘን ዛቅሶ ካይዳንደትም ዋልቀን ዝግመትካንታ አይዳክዮ? ");
INSERT INTO gyl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ዶፈን የም ጋይድቴ፥ ይ Ꮊፍሳንደትከረ ካያክን ኦይድ ቦንደኬ ታመኬ ሳክለንዘንካ ስግ ካይሶ Ꮊፈርሳን ቆለንንጎካ ጉርምዴ”። ");
INSERT INTO gyl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ኮትኮግንደረ ጭላር ዶቅድባብ የንታ ባቤና ከትኬ መረንከሳርንካ ዋልቀነረ ካይድንግንዳ ዝጋዬ። ");
INSERT INTO gyl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“የስታ እስመና የስም ባችሰ የስኬ ክትካ Ꮊክ ማትሰቶ ክታ ባችንም ክትካንታ ከዝካ፥ የስም ክት ኤሰርሴ የስታ እስመና ክትም ማስካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","የዝደር ክት ኤሰራክንዳ ማቼ ቃስተን አነረ ማከን ኤታ ማርከርና ዳቅድንካንታ ቃስተን አነረ ማከን ኤድም የድሶ ክደር አይካ። ");
INSERT INTO gyl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ከትመረ ክት ኤሰርዳክቴ ጋይሴ ምክስ ኤሄናር ኤድንከስካንታ ኬዝካ፥ ምክስ ኤሄናር ኤድንከስካንታ ክት ኤሰርዳክንዳ ማቼ ደራግንደኬ ቶችምሳን ኤድግንዳ ማስሶ ፋይድካ”። ");
INSERT INTO gyl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ዶፈንካ የም ጋይድቴ፥ ፍጨዘን የ ዞግድባብ ሙዳ ጭላር ዞከርስባብ ማቴረ፥ ፍጨዘን የ ማታ ጋይሳንዳ ሙዳ ጭለዘነረ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ጉጅሰረ የም ጋይድቴ፥ የንታርንካ ቃስተና ፍጨዘን Ꮊምን ሪመረ ምክስካንታ ኤእሰኮ ከት ኦይሰኬ ከት ምክሴ፥ ጭላር ዶቅድባብ እስታ ባበና ከትካንታ ቦተረ። ");
INSERT INTO gyl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ቃስተን ናከረ አና ማከን ማትሶ እስታ ላምንካ ከት ሳንምድንደታር እታ ከታ ዎክያር Ꮊፈርትቴ”። ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ኮታይካ ጴጥሮስ የሱሰደር Ꮊድሶ፥ “የ ጮይስዮ! እስታ እስመና እም ክት ባችሰ መም ዱትስ ክትም ነጋ ጋይቴ? ታብዛ ዱቶ?” ጋየሮ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","የሱሰረ፥ “ማከን ቦንደኬ ታሜከ ታብዛ ዱት ዳት ታብዛ ዱት Ꮊክ የስም ጋያይቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“ኮካንታ ጭላ ባንችምና ይንታ ፍክስንባብከስታ አንያር ዶቅድን ብረንም ሰድንካንታ ዝግድባብ ባንችንም ካምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ባንችና ከታ ፍክስንም ሰድን የጃንደትካ በድ ሳአ ብራ ፋይድምድን ባዛ ዶቅድባብ ዋልቃ ፍክስንባብ የድምሶ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ኖኮና ፍክስንባብና ባዘን ናክካንታ ክት ማታክንኦል ኖየረ ክታ ኬነነረ፥ ክታ ይንችነረ፥ ክታ ዶቅድንደትም ሪንም ሙዳ ሰንሶ ባዘንም ናግድንግንዳ ክታ ማታቆልስባብ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ኖኮና ፍክስንባብና ማቼ ይንታ ማተን ቆልስባብታ ዱትንዘን ጉንፈርሶ ‘የ ዎባቦ! ዋደ መራ ሰጫ እካንታ እምካ፥ ሙደንመረ የስካንታ ናክትቴ!’ ጋይሶ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ክታ ማተን ቆልስባበረ ክትካንታ አተርስንደትኬ ክትም ኦይቼ፥ ባዘንመረ ክትካንታ ዛቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ኬዛርንካ ማቼ ኖኮና ፍክስንባብና ኮታርንካ ዉትሶ ክት አያዶቅድንካ ዋልቃ ጨታ ጣገራ ብራ ክታዘንካ ታልቅት ተይባብ ክትካ ክክን ፍግዝድባብ ላኮይትን Ꮊፍስንደትኬ ባርን ክታ ጉንእት የድሶ፥ ‘እየስካንታ ታልቅሳን ብረንም እስታ ናካ!’ ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ኮታዘንከረ ክትካ ክክን ፍግዝድባብ ላኮይትነረ ክታ ዱትንዘን ዋችሶ፥ ‘መራ ሰጫ እካንታ እምካ፥ የስካንታ ናክትቴ!’ ጋይሶ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ኖ ማቼ ዋይዬ ጋይሴ። ኮታዘንከረ ክትም የት አይሶ ባዘንም ናክተረን የለልታ ክትም ዞክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ክትካ ክክን ፍግዝድባብ አብ ላኮይትንከስ ኮት ኮም ከታ ይ ሰዳንደትካ አንድር ሞርእሰኮ፥ ማታቆልስባብደር Ꮊድሰኮ ይምሳንደትም ሙዳ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ክታ ማተን ቆልስባበረ ክትኮ ፍክስንባብም ኤልስሶ፥ ‘የና ዳቅል ፍክስንባብ! የስ እም ምክሳንካንታ የዘን ዶቅድንደትም ባዘንም ሙዳ የስካንታ ዛቅስቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ይና፥ እታ የዘን ባዘን እ ዛቅሳንግንዳ፥ የነረ የስታ ላኮይት ማችባብ ፍክስንባብዘን ባዘንም ክትካንታ ዛቅ የስም ዝክሳዮ?’ ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ኮካንታ ክታ ማታቆልስባበረ ዋጭሶ ባዘንም ሙዳ ክት ናክተርን የለልታ ክትም ዞክና ኤሄንም ክድባብከስካንታ ስክስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“ይና የተረ ዋልቃ ዋልቀንከስ የንታ እስመንም የንታ ቡዳርንካ ነጋ የ ጋይዳክንዳ ማቼ ጭላር ዶቅድባብ እስታ ባቤነረ ኮትኮግንዳ የንዘን ይተሬ።” ");
INSERT INTO gyl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","የሱስ ኮም ኬዝሶ ይ በይሳንደታ ቡር ገሊላ ፍጨናርንካ አምሶ፥ ዮርዳኖስ ሎቀንታ ፋማ ዶቅድን ይሁዳ ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","በድ ዎርሰንከሰረ ክትም ጎርስምሴ ከታርንከረ ሰቀርስባብከስም ኮታር ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ኮታይካ ፈረሳውያንንከስ ክደር Ꮊድሰኮ ጰጫካንታ ክትም ዝግሶ፥ “ኤድ ይንታ ኬነንም Ꮊምንጎግከረ ቡልድንግንዳ ክትካንታ ጋይምቶ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","የሱሰረ፥ “ሳብ እር አⷝነኬ ማነካ ማስሶ ከትም ፍዛንደትም ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ጉጅሰረ ‘ኮጎካ ኤድ ይንታ ባበንምኬ እንደንም ዛቅሶ ይንታ ኬነንካ ክክን ማዴ፥ ከታ ቃስተነረ ዋልቃ ዋሀ ማደኬ’ ");
INSERT INTO gyl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ኮካንታ ከታ ይና ኮዘንካ ኦስ ዋልቃ ዋሄክ ዳት ቃስተን ማታየኬ። ይና ሳብ ዋልቃ ከትም ማስሳን ኤድ Ꮊይ ፋሳ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ፈረሳዊያንንከሰረ “ይና ሙሴ ‘ክእስና ይንታ ከነንካንታ ኮታ ቡልምንታ ማርካ ማድን ዋርቀት እምሶ ብልድንግንዳ’ Ꮊረትክ ክትሳሬ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","የሱሰረ፥ “ሙሴ ማቼ የንታ ከንከስም የ ቡልድንግንዳ ክት የካንታ ጋይሳንዳ የንታ ቡደና ዳቅሶ ዘርዝድባብከስ የማቻንጎኬ” ኤና እሪ ማቼ ኩን ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","“እታ ማቼ፥ ‘ዋልቃ ኤድ ቤልምንጎካ ማታክንዳ ማቼ ይንታ ኬነንም ቡልሶ አብ ማነም ክት እንቼ ኖ ቤልምቴ’ እታ የም ጋይድቴ ኩን ከትም ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ክታ ካርንካ ጎርስምድባብከሰረ፥ “ክእስተኬ ኬነንተካ ዎገና ኩን ኮት ማቼ እንችክሳ ነግና ኡርዴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","የሱስ ማቼ፥ “ኮና ሪና ማድንዳ ሳብዘንካ እምምስባብከስካንታ ዳት ሙደንካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ይንታ እንደንታ ዋርንካ ስላ ማትሶ አጥምስባብከስ ዶቅደኬ፥ ኤድ ከታ ጉስባብከሰረ ዶቅደኬ፥ ጭላ ባንችምንካንታ ጋይሰኮ ከታ ይንታ ማታካንታ እንጅዳክባብከስኬ ይእዳክባብከሰረ ዶቅደኬ፥ ኮካንታ ኮም ማትካንታ ዝግድባብ ማታ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ኮታይካ ይንታ አንን ዎድሶ ከትካንታ ምግዝድንግንዳ ኤድንከስ ይንችንከስም የሱሰደር ተይ Ꮊደኬ፥ ክታ ካርንካ ጎርስምድባብከስ ማቼ ኤድንከስም ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","የሱሰረ፥ “ጭላ ባንችምና ከትከናከስግንደንታ ማቻንካንታ ይንችንከስም ዛእከቴ፥ እዝደር ከት Ꮊዳ፥ Ꮊይ ከትም ማረቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ይንታ አንንመረ ከታዘን ይ ዎጃንደታ ቡር ካርንኮታርንካ ዉትሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ዋልቃሰጭ ዋልቃ ኤች የሱሰደር Ꮊድሶ፥ “ኤስስንባቦ! ስለንክንደት ዶቅንትን Ꮊፍካንታ Ꮊራ ኡርማ ሪ ፍክስ እም ዝግዝዳ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","የሱሰረ፥ “ኡርማ ሪንጎካ Ꮊረተስ እም ኦይዝዳ? ኡርማ ማችባብ ኖ ዋልቄ፥ ስለንካ ዶቅንትናር አርድካንታ የስ ዝግድንዳ ማቼ ክታ ክተንከስም ቦድካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ኤችነረ “Ꮊምን ክተንከስም?” ክደር ጋይሴ። የሱሰረ ኩንጋየሮ ማስሴ “Ꮊይ ደይሴ፥ Ꮊይ በልመ፥ Ꮊይ ድቤ፥ ካርከካ Ꮊይማርከሬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","የስታ ባቤንምኬ የስታ እንደንም ቦንችካ፥ የስታ የለንም የስታ ማታግንዳ ማስሶ ሶልምካ፥ ጋይድን ክተንከሰኬ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ሰከን ኤችነረ “ከትኬና ክተንከስም ቦትቴ፥ አብ እዘንካ ዞገርድንዳ Ꮊረርየረ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","የሱሰረ “ቦድማ ማትካንታ የስ ዝግዘ አይሳዮ የስታ ዶቅድን ሪም ሰንሰዮ ብረንም ሪካየንባብከስካንታ እምካ፥ ጭላረረ ቆልመን Ꮊፍተራዬ፥ ኮታዘንከረ Ꮊድሰዮ እም ጎርስምካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ኖኮና ሰከን ኤችና ማቼ በድ ቆልማ ክታ ዶቅድንካንታ ኮም ይ ኤሰርሳንደትካ ሞርኤሮ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ኮታ ቡር የሱስ ይንታካርንካ ጎርስምድባብከስካንታ፥ “ዶፈን የም ጋይድቴ፥ ቆልመክንባብ ኤድ ጭላ ባንችማር አርድና አንድር ማጠ። ");
INSERT INTO gyl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ጉጅሰረ የም ጋይድቴ፥ ቆልመክንባብ ኤድ ሳብታ ባንችማር አርድንዘንካ ግመል ማርፈታ ጩቅካ አርደስናና ኡርዴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ክታ ካርንካ ጎርስምድባብከስረ ኮም ከታ ይ ኤሰርሳንደትካ አንድር በርእሰኮ “ይና Ꮊይ አቅካንታ ማዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","የሱሰረ ከደር ሰድሶ “ኮና ርና ኤድካንታ ማዳክንዴ፥ ሳብካንታ ማቼ ሙደና ክደር ማዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ኮታይካ ጴጥሮስ “ይና ዎታ ሙደንም ዛቅሶቶ የስም ጎርስምሶቴ፥ ኮናና፥ ዎ Ꮊብድንዳ Ꮊራርዳቶ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","የሱሰረ፥ “ዶፈን የም ጋይድቴ፥ ኤደት ይንች ቦንችምሳን ዶቅንት ጎንገንዘን ዶቅድንደትᎺይካ Ꮊድን ክላ ፍጫሙደንዘን እም ጎርስምድባብከስ የታ፥ ታመኬ ቃስተን ባንችንከስ ዶቅድን ጎንገንዘን ዶቅተረቴ፥ ታመኬ ቃስተን እስራኤልንክስታ አጥርንከዘን ፋረተረቴ። ");
INSERT INTO gyl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","እካንታ ጋይሶ ይንታ ኤሄንም፥ አነረ ይንታ እስመንከስም፥ አነረ ይንታ ምችነንከስም፥ አነረ ይንታ ባበንም፥ አነረ ይንታ እንደንም አነረ ይንታ ይንችንከስም፥ ይንታ ዎንንም ዛቅስባብ ሙደና ጨተዘን ጨታ ጉጅምሳን ተይተሬ፥ ስለንክንደታ ዶቅንትንመረ Ꮊፍተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ኬዛርንካ ማቼ ታ እሪ ማችባብከስ በድንከስ ቡርንባብከስ ማተረኬ፥ ቡርንባብ ማችባብከሰረ እርንባብከስ ማተረኬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ጭላ ባንችምና ዎይንን ኮረርሳን ካርናር ፍግዝድባብከስም Ꮊፍካንታ ዛማ ገልት ዉተድባብ Ꮊምንባብ ኤችንም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ኖኮና ኤችና ዋልቃ ዋልቃባብከስካንታ ዋልቃ ሰጨታ ዋልቃ ጣገራ ብራ ናክካንታ ከትካ ኤእሶ፥ ፍክስንባብከስም ዎይን ኮረርሳን ካርናር ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ዛማ ማኬን ሳዓታዘን ዉትሰኮ ፍክስ ከትም ካይድንካ መለንዘን ዎእስባብ አብ ኤድንከስም ሰዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘የተረ ዎይን ኮረርሳን ካርናር አይሰቶ ፍክስከቴ፥ የካንታ ዝግዝድንደትመረ ናክንም ናክትቴ’ ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ከተረ ዎይንን ኮረርሳን ካርናር አይሰኬ ጉጅሰረ፥ “Ꮊየካ ላ ሳዓታዘንኬ ሳክላ ሳዓታዘን ዉትሶ ኮትኮግንዳ ኤድንከስም Ꮊፍሶ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Ꮊክስን ታሜከ ዋልቃ ሳዓትካ ዉትሶ አብ ኤድንከስ ዎእሶ ዶቅድንካ Ꮊፍስንደትኬ ‘የታ Ꮊቅንተንም ሙዳ ፍክስካይሳ ካሪ የ ዎእሳንዳ Ꮊረተረ?’ ጋይሶ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ከተረ ‘ዎም Ꮊፍሶ ፍክስዝድባብ ኤድ ካይድንኬ’ ክደር ጋይሰኬ፥ ኖየረ ‘ኮማቼ የተረ ዎይን ኮረርሳን ካርናር አይስንደትኬ ፍክስከቴ’ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ፍጨና ሶይቻንደትካ ዎይን ኮረንታ ባበና ፍክስዝድባብም ‘ፍክስንባብከስም ኤልሰዮ ቡርንባብከዘንካ የድሳዮ እርንባብከስ የለልታ ከታ ፍክስንታ ናክንም ናካ’ ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ኮካንታ Ꮊክስን ታመከ ዋልቃ ሳዓታዘን ፍክስን የጅባብከስ Ꮊድሰኮ ከታ ዋልቃ ዋልቀንከስ ዋልቃ ብራ ጣገረን ተየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","እርናና ፍክስን የጅባብከስ Ꮊድሰኮ አብንከዘንካ ስግ ናክንም ከት ተይድን ከደር ካምሳዶቆ፥ ኬዛርንካ ማቼ ከተረ ዋልቃ ዋልቃባብከስ ዋልቃ ብራ ጣገራ ተየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ብረንም ተይሰኮ ዎይን ኮረንታ ባቤንዘን ኩን ጋየረኮ ጉንድምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ከታኬና በእንተንዘን Ꮊድሰኮ ከት ፍክሳንዳ ዋልቃ ሳዓት Ꮊክዬ፥ ኬዛርንካ ማቼ Ꮊቅንተንም ሙዳ Ꮊያር አትረሮቶ አንድር ፍክስካ ጋብድ ዎ Ꮊቅባብካ ክክን የካ ከትም ማስሳዬ’ ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ዎይን ኮረንታ ባቤነረ ይንታ ፍክስንባብከሳርንካ ዋልቀንካንታ፥ ‘እስታ ገርነኖ! Ꮊረነረ የስካንታ ዳቀልሳክቴ፥ ዎ ከዝምሳንደረ ሰጨካ ዋልቃ ጣገራ ብራ የስካንታ ናክካንታ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ኮካንታ የስካንታ የልድንደትም ተይሳዮ አይካ፥ የስካንታ እምምሳንከካ ክትኮ ቡርንባብካንተረ እምካንታ ጋይሳቴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","እስታ ገታ ቤርንካ እ ዝግዛንደትም ይካንታ እስታ ሰና ካዮ? አነረ እታ እምድባብ እ ማቻንካንታ የስም ዳቅል ገቀርሶ?’ ” ኩንጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ኮታ ቡር የሱስ “ኮት ኮግንደረ ቡር ማችባብከስ እርንባብ፥ እርማችባብከስ ቡርንባብከስ ማተረኬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ኮታ ቡር የሱስ የሩሳሌም ካተመናር አየረኮ ጎግዘን ታመከ ቃስተን ይንታ ካርንካ ጎርስምድባብከስም ከትም Ꮊክ ይንደር ኤልሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ይና ታ የሩሳሌም ካተመናር ዉታዶቅዶተ፥ ኮታረረ ኤድይንችም ቀሰንከስም ገችዝድባብከስተኬ ሙሴታ ህግንም ኤስዝድባብከስካንታ ስክስምት እምምዴ፥ ከተረ ደእታ ፍርደንም ከታዘን ፋረተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","አይሁድ ማታክባብከስካንተረ ስክስት ክትም እምተረኬ፥ ከተረ ክታዘን Ꮊልተርተረኬ፥ ክትም Ꮊርተረከ፥ ክትም ሮክተርከ፥ ኖ ማቼ ማክምስ ሰጨንካ ደእናርንካ አምተሬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ኮታዘንከረ ዛብዶሰታ ይንችንከስታ እንደና፥ ይንታ ይንችንከስካ ክክን የሱሰደር Ꮊድሶ ክታ እረረ ጉንፈርሶ ኮትካንታ ዋልቃ ሪ ይድንግንዳ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","የሱሰረ “Ꮊረስ ዝግዳ?” ኮትም ጋይሴ። ናየረ “የስታ ባንችምናር ኬና ቃስተን እስታ ይንችና ዋልቃባብና የስታ ምዝዘን ዋልቀና የስታ ከችዘን ከት ዶቅድንግንዳ ጋይካ!” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","የሱስ ማቼ “የታ የ ምግዝድንደትም ኤዝዳከቴ፥ እታ ቅንች ሰጫር እ ዎጭድንደትም ማጠንታ ኡፕተናር ዎጭምን ዎጭካንታ ማደቴ?” ከትም ጋይሴ። ከተረ፥ “ይዬ ዎጭካንታ ማዶቴ!” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","የሱሰረ “ገታ እ ዎጭድንደትም እስታ ማጠንታ ኡፕተናር ዎጭምን ዎጭተረቴ፥ ኬዛርንካ ማቼ ኤድንከስም እስታ ምዝዘንኬ እስታ ከችንዘን ከት ዶቅድንግንዳ ይድባብ እታ ካይቴ፥ ኮና ካርና እምምድንዳ እባብ ግግሳን ኤድንከስካንቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ነግድባብ ክታ ካርንካ ጎርስምድባብ ታሜንከስ ኮም ምክስን ከታ ይ ኤሰርሳንደትካ ከት ቃስተንንከዘን ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","የሱስ ማቼ ሙደንም ኤልሶ፥ “አይሁድ ማታክባብከስም ገችዝድባብ ይንታ ዎርሰንከስም ቆልድባብከሰኬ፥ ከትም ጎርዝድባብከሰረ ከታዘን ገችታ ኤራ ዶቅድንደትም ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","የንታ ዎክያር ማቼ ኮግንዳ ማትዝክሳዬ። ኬዛርንካ ማቼ የንታ ዋርንካ አንድር ማትካንታ ዝግድባብ የንታ ፍክስንባብ ማታ። ");
INSERT INTO gyl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ኮትኮግንደረ የንዘንካ ስግ ማትካንታ ዝግድባብ የ ሙደንታ ፍክስንባብ ማታ። ");
INSERT INTO gyl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ኤድይንች ኤድካንታ ፍክስካንተኬ በድንከስም አቅስካንታ ይንታ ሰንፔንም ስክስት እምንተካ ቆት ተይካንታ Ꮊዳ ዳት አብንከስ ክትካንታ ፍግዝድንግንዳ Ꮊዳክዬ።” ");
INSERT INTO gyl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ኮታ ቡር ኢያርኮ ካተመናርንካ ዉትሶ ከት አይድንካ በድ ዎርሳ የሱሰም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ይና፥ ጎግታ ካንታር ዶቅስባብ ቃስተን አፍይ ዝልንከስ ጎግንኮትካ ስጋዶቅድባብ የሱስ ማትንተን ከታ ይ ኤሰርሳንደትካ፥ “ጮይስ ዳውተታ ይንችኖ! ዋደ ዎካንታ አጨርካ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ዎርሰነረ “ጫምንጋይከቴ!” ጋይሰኮ ከትም ዋጨኬ፥ ከታ ማቼ “ዳውተታ ይንች ጮይስኖ! ዋደ ዎም አጨርካ!” ጋየረኮ በችሶ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","የሱሰረ ዎእሶ ከትም ኤልስንደትኬ “Ꮊራ እ የካንታ ይድንግደንት ዝግዳ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ከተረ “የ ጮይስዮ! ዎንታ አፍንከስ ሰድንግንዳ ዝግዶቴ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","የሱሰረ ከትካንታ አጨርስንደትኬ ከታ አፍንም Ꮊጬ፥ ሳነካ ከታ አፍንከስ ሰጀኬ፥ ከተረ የሱስም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ የሩሳሌም ካተመናር ከት ቅንችምሳንደትካ ደብረ ዛይት ገቸንዘን Ꮊፈርድን በቴፋገ ጋይምሳን ሞረናር ከት የልድንካ የሱስ ይንታ ካርንካ ጎርስምድባብከሳርንካ ቃስተንን፥ ");
INSERT INTO gyl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“የንታ ኦስ እሪ ዶቅድን ሞረናር አይከቴ፥ ኮታረረ ዋልቃ አከርሳን ኡክል ቅንጭንካ የካ Ꮊፍተረቴ፥ ቡልተረ እዝደር ተይ Ꮊድከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ꮊየነረ ኤድ ዋልቃ ሪ የንደር ጋይሴ ‘ጮይስ ከትም ዝግድንካንተ’ ጋይከቴ። ኖየረ ኡክልከስም ሳነካ ኦይተሬ” ኩን ጋይሶ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ኮነረ ማቻንዳ ሳብዘንከ ኤሰርሶ ከዝድባብካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ጽዮን ካተማ ጋይምድን የሩሳሌምካንታ፥ ‘ይና! የስታ ባንችና ይንታ ማተን ይርክሳ ይድይ ኤድንግንዳ ማትሶ ኡክልታዘንኬ ኡክልታ ቅንጭንዘን ዶቅሶ የዝደር Ꮊተሬ!’ ጋይሰቶ ኮትካንታ ከሰከቴ” ኩን ጋይምሶ ኬዝምሳንዳ ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ክታ ካርንካ ጎርስምድባብከሰረ አይሰኮ የሱስ ከትም ክትሳንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ኡክልንም ቅንጭንካ የካ ክትካንታ ተይ Ꮊደኬ፥ ከታ ይንታ አፍለንከስመረ ኡክልንከስታ ባዝደንዘን ዎጀኬ፥ የሱሰረ ከታዘን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ዎርሰናርንከረ በድንከስ ከታ ይንታ አፍለንከስም ጎግንዘን ታከረሰኬ፥ አብንከስ ጉጅሶ Ꮊቀንታ ሳቀንም ሳርስተኮ ጎግንዘን ይጭሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","እርምሶ ክታ እር አይድባብከስኬ ቡርጎካ ጎርስምድ Ꮊቅባብ ዎርሰነረ፥ “ቦንቼና ዳውተታ ይንችንካንታ! ጮይስታ ላምንካ Ꮊድባብ አንጅምስባቤ! ቦንቼና ጭለዘን ሳብካንታ ማታ!” ጋየረኮ ፍብድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","የሱስ የሩሳሌም ካተመናር አርደዳንደትካ ካተመነረ ኤድንከስ ሙዳ “ኖኮና Ꮊይራ?” ጋይንተካ አዉልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ዎርሰነረ፥ “ኖኮና የሱስ ገሊላ ፍጨናር Ꮊፈርድን ናዝረት ካተመናርንካ Ꮊድባብ ሳብዘንካ ኤሰርሶ ኬዝድባቤ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ኮታዘንከረ የሱስ ሳብታ ጭል ኤሄናር አርደዴ፥ ኮታረረ ኦስ ሰንድባብከስምኬ ፈንክ ሰንት ተይድን ኤድንከስም ሙዳ ዉችሴ። ብረን ኦግድባብከስም ጣርጰዘንከስምኬ ዎለን ሰንድባብከስተረ ጎንገንከስም ቡከልሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“ ‘እስታ ኤሄና ምክስ ኤሄ ጋይምዴ’ ጋይምሶ ጭል ማጻፍናር ጻፍምቴ፥ የታ ማቼ ቡረንባብከስታ የረሳ ማስሰቴ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","የሱስ ሳብታ ጭል ኤሄናር ዶቅድንካ አፍይ ዝልንከስኬ ዎከል ዎከልን ጋይድባብከስ ክደር ከት Ꮊድንካ ኖየረ ከትም ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ኬዛርንካ ማቼ ቀሰንከስታ ገችንባብከስኬ ሙሴታ ህግን ኤስዝድባብከስ የሱስ ይሳን በርእስዝድን ርን ከታ ይ ሰጃንካንተከ ይንችንከሰረ ሳብታ ጭል ኤሄናር “ዳዊታ ይንችንካንታ ቦንቼና ማታ!” ጋየረኮ ከት ፍብድንካ ከታ ይንታ ኤስርንካ አንድር ሰነርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ኮካንታ የሱሰም “ኬና ይንችና ከት ጋይድንደትም የና ኤሰራዶቅዳ?” ጋይሰኬ፥ የሱሰረ “ይዬ፥ ኤሰራዶቅድቴ፥ ‘ይንችንከዘንኬ አምን ጋእድን ኡለንከስታ አፋርንካ ጋለትን ግግሳዬ’ ጋይድንደትም ቦድሶ ናበባከቴ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ከትም ዛቅሶ ካተመናርንካ ዉትሶ፥ ብታንያ ጋይምድን ሞረናር አይሴ፥ ኮታረረ ኖ ገቼ። ");
INSERT INTO gyl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","የሱስ ዛማ ሰጭመናር፥ ካተመን ኮታር ማት አይድዮ ኖ ዳቀርሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ዋልቃ በለስ Ꮊቃ ጎግንታ ካንተዘን ሰድሶ Ꮊቀን ኮደር አይሴ፥ ኬዛርንካ ማቼ ቃምዘንካ አብ Ꮊረሰነረ ኮታዘንካ Ꮊፋክዬ። ኮካንታ “ይና ኮዘንካ ኦስ ቦድሶ አፍ የዘንካ ᎺይᎺፈራ!” ኮትም ጋይሴ። በለስ Ꮊቀነረ ሳነካ ዎቼ። ");
INSERT INTO gyl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ክታ ካርንካ ጎርስምድባብከሰረ ኮም ከታ ይ ሰዳንደትካ፥ “ናኮና በለስ Ꮊቀና ሳነካ Ꮊስግንዶክ ዎቻረ!” ጋይንተካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","የሱሰረ፥ “ዶፈን የም ጋይድቴ፥ አሜን የንታ ዶቅሰኬ የ Ꮊኤራክንዳ ማቼ በለስ Ꮊቀንዘን ማቻንደትግንዳ Ꮊክ ማታክናና፥ ኮም ገቸንም ዎራ ‘ኮዘንካ ቡጭምሳዮ ባሀርናር አይካ!’ የ ጋይዴ የካንታ ማደ። ");
INSERT INTO gyl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","አመንሰቶ ምክስካ የ ኦይዝድንደትም ሙዳ Ꮊፍተረቴ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","የሱስ ሳብታ ጭል ኤሄናር አርድሶ ኤስዝድ Ꮊቄ። ኮታይካ ቀሰንከስታ ገችንባብከስኬ ዎርሰንታ ጋልተንከስ ክደረ Ꮊድሰኮ፥ “ኮ ሙዳ የስ ይድንዳ Ꮊራ ገችታ ኤረከረ? ኮም ገችታ ኤረን የስካንታ እምስባብ Ꮊይራ?” ጋይሰኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","የሱሰረ፥ “እተረ ዋልቃ ኦይስ የም ኦይስትቴ፥ እስታ ኦይስንታ ማስንም የ ማስሴ እተረ ኮም ሙዳ Ꮊራ ገችታ ኤረካ እ ይዳ ማቼረ የካንታ ኬዝትቴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ይና ዮሀንሰታ ስእስና Ꮊምንኮክ Ꮊዳራ? ጭላርንኮ አና ኤድዘንኮ?” ጋይሰኮ ኦይሰኬ። ከተረ ክክ ክክ ኩን ጋየረኮ ዞርምሰኬ፥ “ ‘ጭላርንከ’ ዎ ጋይሴ ‘ኮናና Ꮊረተረ ክትም የ አሜናክንዳ’ ዎም ጋይዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘ኤታ ዘንከ’ ዎ ጋይሴ፥ ዮሀንሰም ሙደና ሳብዘንካ ኤሰርሶ ኬዝድባብግንዳ ከት ሰድንኦል ዎርሰንካንታ ጳዝዶቴ።” ");
INSERT INTO gyl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ኮካንታ “ዎታ ኤዝዳኮቴ” ጋይሰኮ የሱሳካንታ ማስሰኬ። ኖየረ “ኮማቼ እተረ Ꮊራ ገችታ ኤረካ ኮም ሙዳ እ ይዳናከረ የካንታ ኬዛይቴ” ኩንጋየሮ ከደር ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ኮታዘንከረ የሱስ፥ ይና የንደር Ꮊሮክ ካምዳ? ዋልቃ ኤችታ ቃስተን ይንች ዶቅደኬ፥ ከታርንካ እስመንደር Ꮊድሶ፥ እስታ ይንችኖ፥ ታካ እስታ ዎይንን ኮረርሳን Ꮊምናር አይሳዮ የስ ዎንተርንግንዳ ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ይንችነረ ዋይዬ አይዳክቴ ጋይሴ። ማታጋካ ዳት ቡር ማቼ ኡቅምሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ባበነረ ይንችን ካንስንደር አይሶ ክትመረ ኮትግንዳ ክት ዎንተርንግንዳ ክትሴ፥ ይንችነረ ኤኦ እባቦ አይትቴ ጋይሴ። ኬዛርንካ ማቸ ኖ አያክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“ይና ከትኬና ቃስተንናርንካ ይንታ ባቤንታ ጋይተንም ቦጅባብ Ꮊምነረ?” ኩን ከደር ጋይሴ። ከተረ “እስመኔ!” ጋይሰኬ። የሱሰረ፥ “ዶፈን የም ጋይድቴ፥ ቃረጭን ተችዝድባብከስኬ ቤልምድባብከስ ጭላ ባንችማር አርድንተካ የንታ እር ማደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ስእስንባብ ዮሀንስ ጭላትቸታ ጎግንም የም ሰችካንታ ክት Ꮊድንከሬ የታ አሜናከቴ፥ ቃረጭን ተጅድባብከስኬ ቤልምንባብከስ ማቼ ክትም አመንሰኬ፥ ኮት ኮመረ ሰድሰቶ ዎራ ጎማ ፍክስን ዎይስሰቶ ክትም አሜናከቴ”። ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ጉጅሰረ የሱስ፥ “አብ ካምስነረ ኤሰርከቴ፥ ዎይንንም ኮርዝድባብ ዋልቃ ኤች Ꮊቄ፥ ኖ ዎይንን ይ ኮርሳንደታ ካንተካ ጋስንም ጋሴ፥ ዎይንም ጩጰርድን ጎር ኮይስሰ፥ ዎይንን ካርሰርድንደታ ሰይንካ ቃልም ካሪ ኡርሴ፥ ኮታዘንከረ ዎይን ኮረርሳንደትም ዎንንባብከስካንታ እምሶ አብ ፍጫር አይሴ ");
INSERT INTO gyl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","አፍን ካመርድን አርፈና የልሳንደትካ አፍን ይም የልድንደትም ተይካንታ ይንታ ፍክስንባብከስም ዎንንባብከዝደር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ዎንንባብከስ ማቼ ከት Ꮊድባብ ፍክስንባብከስም የድሰኮ ጉጵሰኬ፥ ዋልቀንም ደይሰኬ፥ አብንመረ ሰይንካ አቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ዎይን ኮርተንታ ባበና አናካርንካ እርንባብከዘንካ ፋይደካ ስግድባብከስም አብ ይንታ ፍክስንባብከስም ጉጅሶ ኦይቼ። ዎንባብከስ ከታዘነረ እርንባብከዘን ይሳንግንዳ ይሰከ። ");
INSERT INTO gyl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","በእንተዘነረ ዎይን ኮርንባብ ‘እስታ ይንችንም ቦንችተረኬ!’ ጋይንተካ ይንታ ይንችንም ዎንባብከዝደር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“ዎንባብከስ ማቼ ክታ ይንችንም ከታ ይ ሰዳንደትካ ‘ኖኮና ክታ ባእንም ተይድባቤ፥ ኮረቴ ክትም ደይስሶቶ ባእንም ተይተሮቴ!’ ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ይንችንም የድሰኮ ዎይን ኮረርሳንደታርንካ ኦስ ካንተዘን ዉችሶ ክትም ደይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“ይና፥ ዎይን ኮረንታ ባቤና ይ Ꮊዳንደትካ ከትኬና ዎንንባብከዘን Ꮊራ ክት ይድሞክ የም ካምዳ?” ");
INSERT INTO gyl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ከተረ፥ “ከትኬና ዳቅል ኤድንከስታ ቦድንተና ቦርሳንዳ ከትካንታ ማስተሬ። ዎይን ኮረርሳንደትመረ ኡዝድን አፍን ክትካንታ የልድንደትም ሙዳᎺይካ እምድባብ አብ ዎንንባብከስካንታ እምተሬ” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ኮታዘንካ የሱስ፥ “ጭል ማጻፍንከሳር ‘ሰይን ኤሄንም ዎድባብከስ ቶችሳን ሰይንና ኤሄንካንታ ዝግዝድንዳ ማቼ ና ኮነረ ጮይስታ ፍክስዬ፥ ዎንታ አፍናረረ በርእዝድንዴ’ ጋይምሶ ጭል ማጻፍናር ጻፍምሳን ቦድሶ ናበባከቴ? ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ኮካንታ፥ ሳብታ ባንችምና የንዘንካ ተይምሶ አፍይ ኡዝድን ዎርሰንካንታ እምምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ኮ ሰይንንዘን ዋጅድባብ ቁንጭምደ፥ ሰይንና ክታዘን ዋጅድባብ ኤችና ማቼ አርእስምዴ” ኩን የም ጋይድቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ቀሰንከስታ ገችንባብከስኬ ፈረሳውያንንከስ ኬና ካምስንከስም ከታ ይ ኤሰርሳንደትካ የሱስ ኬዛንዳ ከትጎካ ማትንተን ኤሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ኮካንታ የሱሰም የድካንታ ዝግዘኬ፥ ኬዛርካ ማቼ ዎርሰና ሳብዘንካ ኤሰርሶ ኬዝድባብግንዳ ክትም ከት ሰድንካንታ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","አናካርንከረ የሱስ ካምስካ ኤድንከስካንታ ኩንጋየሮ ኬዛ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ጭላ ባንችምና ይንታ ይንችንካንታ እሰታ እችምን ግክስባብ ባንችንም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ባንችነረ ኤልምሳን ኤድንከስም እሰናር ከት Ꮊድንግንዳ ገቀርስካንታ ይንታ ፍክስንባብከስም ከደር ኦይቼ”፥ ኤድንከስ ማቼ እሰናር Ꮊድካንታ ዝጋከኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ባንችና አብ ይንታ ፍክስንባብከስም አናካርንካ ኩንጋየሮ ኦይቼ፥ ኤልምስባብ ኤድንከዝደር አይሰቶ፥ ይና እሰታ እችምን ግክስትቴ፥ ገዝምንከስምኬ ሞረርስባብ መሔንከስ ማችምተ ሙዳ ሪየረ ግግምቴ ኮካንታ እስታ እችምንደር Ꮊድከቴ! ጋይሰቶ ከትካንታ ኬዝከቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ከታ ኤልምስባብከስ ማቼ ኬዘንም በህ ጋይሶ ዋልቃባብና ይንታ ዎንደር፥ አብነረ ይንታ ዛለንደር አይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ነገድባብከሰረ ፍክስንባብከስም የድሰኮ ጉጵት ደይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ኮካንታ ባንችና ዋጭሶ ይንታ ዳምንባብከስም ኦይትሶ ከትከ ደይስባብከስም ደይስሴ፥ ከታ ካተመንመረ ኖሄካ አችዝድንግንዳ ይስሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ኮታ ቡር ይንታ ፍክስንባብከስመረ፥ ይና እሰንታ እችምና ግግምቴ፥ ኬዛርካ ማቼ ኤልምስባብከስ እሳ እችምንካንታ ዝግዝድባብ ማትሶ Ꮊፈራከኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ኮካንታ ጎግን ባስንዘን አይሰቶ የ Ꮊፍስባብ ኤድንከስም ሙዳ ፈንክ እሰንታ እችምናር ኤልከቴ። ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ክታ ፍክስንባብከሰረ ጎግንዘን ዉትሰኮ፥ ከታ ይ Ꮊፍስባብ ኤድንከስም ሙዳ ዳቅልንከስመረ፥ ኡርመንከስመረ ሳንሰኬ፥ ኮካንታ እሰንታ ጋይምሳን ኤሄን ዳልግናር ኤልምሳን ኤድንክስ ጮጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ኬዛርንካ ማቼ ባንችና ኤልምስባብከስም ሰድንካንታ ኤሄን ዳልግናር ክት አርደዳንደትካ፥ እሰንታ አፍለንም ቆበራክባብ ዋልቃ ኤችም ዋር ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ኩነረ ክትም ጋይሴ፥ ‘እስታ ገርነኖ፥ እሰንታ አፍለንም ቆበርክሳ Ꮊስግንደስ አርድካንተስ ማቻረ?’ ኤችና ማቼ ጫምንጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ባንችነረ ይንታ ፍክስንባብከስም፥ ‘ክታ አንንምኬ ዱትንም ዞክሰቶ ማል ዶቅድን ግልድድ ኡምናር ክትም ዉችት ኦይትከቴ፥ ኮታረረ ኤፍኬ አች ቅርጭካ ክትካንታ ማተረ’ ኖ ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ኮታዘንከረ የሱስ “ኮካንታ ኤልምስባብ በድንከሰኬ፥ እድምስባብከስ ማቼ ቶክመንከሰኬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ኮታ ቡር ፈረሳውያንንከስ አይሰኮ Ꮊስ ይይሶ የሱሰም ክት ኬዝድን ኬዘንካ ከታ ይ የዳናንከረ ዞርምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ከታ ይንታ ካርንካ ጎርስምድባብከስም ሄሮድሰታ ኤድንከስካ ክክን የሱሰደር ኦይትሰኮ፥ “የ ኤስስንባቦ! የስ ዶፈን ማቻንደትምከ ሳብታ ጎግንም ዶፈንካ የስ ኤስዝድንደትም ዎታ ኤዝዶቴ፥ ኤታ ባላካንታ ኦስንዳከየ” ከታ ይ ጋይሳንደታ ቡር፥ ኩን ጋይሶ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","“ይና ዎም የስ ኬዝኔ Ꮊሮክ የስም ካምዳ? ሮማ ባንችንካንታ ግራ ናክ ዝግዝዶ ዝክሳዮ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","የሱስ ማቼ ከታ ዳቅል ገቅርንም ኤስሶ፥ “የታ ኦትረንባብከሶ! Ꮊረተንት እም ጰጭዳ? ");
INSERT INTO gyl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ግረንካንታ ናከርድን ብረንም እካንታ የ ሰችነ!” ከትም ጋይሴ። ኮካንታ ከተረ ዋልቃ ብራ ጣገራ ተይᎺድሰኮ ክትም ሰችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ኖየረ፥ “ኮ ብረንዘን Ꮊፈርድንዳ ምስልንከ ጻፈርሳን ላምና Ꮊይተረ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ከተረ፥ “ሮማ ባንችንቴ!” ክደር ጋይሰኬ፥ ኖየረ፥ “ኮናና ባንችንተን ባንችንካንታ ሳብትን ሳብካንታ እምከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ከተረ ክትም ይ ኤሰርሳንደታ ቡር ክታ ኬዘንካ በርእሰኮ ክትም ዛቅሶ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ኮታይካ፥ “ደእስባብከስታ አምንታ ካዬ” ጋይድባብ ሰዶቃዊያንንከስ የሱሰደር Ꮊድሰኮ ኩንጋየሮ ክትም ኦይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“የ ኤስስንባቦ! ሙሴ ‘ዋልቃ ኤድ ይንች አጣክዶቆ ይንታ ኬነንዘንካ ደእካ ክት ፋስምሴ ክታ እስመና ደእስባብታ ኬነንም ማስሶ ክትካንታ ይንች አጣ’ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ኮትኮግንደረ ታብዛ እስመንከስ ዎንደር ዶቅደኬ፥ ከትሙደንተረ እስመነና ማና እንችሶ ይንች አጣክሳ ደእሴ፥ ኮካንታ ክታ ካንስና ደእስባብታ ኬነንም ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ኮትኮግንደረ፥ ቃስትምስነረ፥ ማክምስነረ ታብስን የለልታ ከታ ሙደነረ ኮትም እንችሰኮ ደእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ከትሙደንተረ በእንተዘን ኤተና ይንታ ማታ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ይና፥ ከታ ታብዘነረ ኮትም እንቻንካንታ ደእናርንካ አምንተን ሰጨንካ Ꮊይቶክ ማና ማዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","የሱስ ማቼ፥ “የታ ጭል ማጻፍንከስምኬ ሳብታ ዎልቀንም የንታ ኤስክሳ ነግንተንካ የታ ኮተርደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ደእስባብከስታ አምንተን Ꮊይካ ኤድንከስ ጭላር ዶቅድን ክታይንችንከስግንዳ ማደክ ዳት እንቻየኬ፥ ይአየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ጉጅሰረ ደእያርንካ አምንተንጎካ ሳብ የካንታ ኬዛንደትም ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ክተረ ጋይሳንዳ ኩኔ፥ ‘እታ አብራሀመታ ሳብ፥ ይሳቀታ ሳብ፥ ያይቆበታ ሳብቴ።’ ኮካንታ ሳብ ሰንፔንክንባብከስታ ሳብ ዳት ደእስባብከስታ ሳብ ካዬ” ኩን ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ዎርሰነረ ኮም ይ ኤሰርሳንደትካ ክታ ኤስስንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","የሱስ ሰዶቃዊያንንከስም ጫምሳ ይስሳንደትም ከታ ይ ኤሰርሳንደትካ ፈረሰዊያንንከስ ዋልቃትቸካ ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ከታርንከረ ዋልቃ ሙሴታ ህግንም ኤስዝድባብ፥ የሱሰም ጰጫካንታ ዝግሶ ኩን ጋይሶ ኦይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ኤስስንባቦ! ሙሴታ ህግን ሙደናርንካ ስገድንዳ ክታ Ꮊምነረ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","የሱሰረ፥ “የስታ ጮይስ ሳብን የስታ ቦድማ ቡዳርንካ፥ ቦድማ የስታ ሰንፔንካ፥ ቦድማ የስታ ገቅርንካ ሶልምካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ሙደንዘንካ ስገድንደትከ እርንደና ክተና ኮኔ። ");
INSERT INTO gyl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ኮትኮመረ ካምድንዳ ቃስትምስ ክተና፥ ‘የስታ የለንም የስታ ማታግንዳ ማስሳዮ ሶልምካ’ ጋይድንደኔ። ");
INSERT INTO gyl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ሙሴታ ህግንከ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ኤስስን ሙደንታ የድና ከትኬ ቃስተን ክቴን ኬዘንኬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ፈረሳውያንንከስ ሳንምሰኮ ዶቅድንካ የሱስ ኩን ጋይሶ ከትም ኦይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ክርስቶስጎካ Ꮊረንት ገቀርዳ? Ꮊይታ ይንችምክ የንደር ካምዳ?” ከተረ “ዳውተታ ይንቼ” ጋይሰኮ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","የሱሰረ፥ “ኮናና፥ ዳውት ሳብታ አያንካ ጎርስምሶ ክት ኬዛንደትካ Ꮊስግንድክ ‘ጮይስዮ’ ጋይሶ ኤልሳረ? ");
INSERT INTO gyl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ጮይስ እስታ ጮይስንካንታ፥ የስታ ይምኤንባብከስም የስታ ዱትንታ ጎይናር እ ሙክስተርን የለልታ፥ እስታ ምዝንዘን ዶእካ! ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ይና ዳውት ይንታ ማታርንካ ‘ጮይስ’ ጋይሶ ክትም ኤልሳንካ ይና ክርስቶስ Ꮊስግንድክ ክታ ይንች ማዳ?” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ኮትኮ ኬዘንታ ዋልቃ ዎራ ኬዝት ማስስባብ Ꮊየነረ ኤድ ካዬ፥ ኮትኮ ሰጨንዘንካ የድሶ ክትም ኦይስካንታ ማችባብ Ꮊየነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ኮታ ቡር የሱስ ዎርሰንከስካንተኬ ይንታካርንካ ጎርስምድባብከስካንታ ኩንጋየሮ ኬዜ፥ ");
INSERT INTO gyl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ሙሴታ ህግንም ኤስዝድባብከስኬ ፈረሳዊያንንከስ ሙሴታ ህግንም ከት ኤስዝድንግንዳ ገችታ ኤራ ከትካንታ እምምቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ኮካንታ ከት የም ጋይድንደትም ሙዳ ይከቴ፥ ካርስከቴ፥ ከት ይድንደትም ማቼ Ꮊይ ይየቴ፥ ከታ ይ ኬዝድንደትም ፍክስዘን Ꮊቅሳየኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ደጭድንደትምኬ ማእዝድን ባለን ኤታ ገትዘን ባልዝደኬ፥ ከታ ይንታ ማተንካንታ ማቼ ግልኤከረ ዎራ ዎልካንታ ዝጋየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ከታ ይንታ ፍክስንም ሙዳ ኤድ ሰዳባብ ጋይሶ ፍግዝደኬ፥ ሙሴታ ህግንም ጻፈርሳንደትመረ ይንታ ባለንዘን ዞግደኬ፥ አፍለነረ ይንታ ቃልዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ዎጨርድን እቸርድን ካርዘነረ ቦንችምሳን ካሪ፥ አይሁድንከስታ ምክስ ኤሄናረረ እርጎካ ጎገንዘን ዶቅንካንታ ዝግደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","መለን ኬዘነረ ኤድ ሙዳ ከትካንታ አን አምዝድንግንደኬ የ ኤስስንባብ! ጋይሶ ከትም ኤልድንግንዳ ዝግደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","የታ ማቼ የንታ ኤስስንባብ ዋልቃ Ꮊክ ክት ማቻንካንተኬ የታ ሙደነረ እስመንኬ ካንስካ የ ማቻንካንታ ኤስስንባብ ጋይምሰቶ Ꮊይ ኤልመቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ጉጅሰረ የንታ ዶቅድባብ ጭላር ዋልቃ ባበና Ꮊክ ክት ማቻንካንታ ፍጨዘን Ꮊይመረ ባቤና ጋይሰቶ Ꮊይ ኤለቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","የንታ ጎርስንባብ ክርስቶስ ማቻንካንታ ሙደንም ኤዝድባብከስ ጋይምሰቶ Ꮊይ ኤልመቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","የንታ ዎክያርንካ አንድር ማችባብ የንታ ፍክስንባብ ማታ። ");
INSERT INTO gyl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ይንታ ማተንም ጬክሳ ይድባብ ቶችምዴ፥ ይንታ ማተንም ቶጅድባብ ማቼ ቦንችምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ኤድ ጭላ ባንችማር አርዳይንግንዳ ፍልተንም ዝጭድባብ የታ ኦትረንባብከሶ፥ ሙሴታ ህግንም ኤዝድባብከስኬ ፈረሳውያንንከሶ! የም የኤ! የታ የንታ ማታርንካ ኮታር አርተራከቴ፥ አርድካንታ ዝግድባብከስም ከት አርዳክንግንዳ የታ ማርደቴ!”  ");
INSERT INTO gyl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ዎም ሰደራ ጋይሰቶ ምክስም ቃልሰረቶ ኮትካ ጋይረረቶ ከታ ክእስንከስ ደእስባብ ማነንከስም ከታ ገች Ꮊቅን በይዝድባብ የታ ኦትረንባብከሶ ሙሴታ ህግን ኤዝድባብከስኬ ፈረሳውያንንከሶ የም የኤ! ኮካንታ እንድንካ ስገዳን ፍርዳ የንዘን የልተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","የታ ኦትረንባብከሶ ሙሴታ ህግን ኤስዝድባብከስኬ ፈረሳውያንንከሶ! የም የኤ! ዋልቃ ኤድ የንታ ካርንካ ጎርስምድባብ የ ማስሳንደታ ቡር ባሀር ሎቀናርንከ ፍጨዘን ኦንግደቴ፥ የንደር የ ማስሳንᎺይከረ የንዘንካ ቃስተን አን ጉጅምሳን ስገዳን ድግዳክን ኖሀካንታ ግግምስባብ ከትም ማዝደቴ! ");
INSERT INTO gyl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","የታ አፊይ ዝል ጎርስንባብከሶ! የም የኤ! ኤድ ሳብታ ጭል ኤሄካ ጫቅሴ፥ Ꮊረሰነረ ካዬ የታ ጋይደቴ፥ ሳብታ ጭል ኤሄንታ ዎርቀንካ ክት ጫቅሳን ማቼ ይንታ ጫቀንካ የደርደ የታ ጋይደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","የታ ዳቸንከስከ አፍዝልንከሶ! ዎርቀዘንኬ ዎርቀንም ጭልዝድባብዘንካ Ꮊምና ስገዳ? ");
INSERT INTO gyl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ኮትኮግንደረ ኤድ ካስካርዘን ጫቅሴ Ꮊረሰነረ ካዬ፥ ካስ ካርንዘን ዶቅድን ርንካ ክት ጫቅሴ ይንታ ጫቀንካ የደርዴ ጋይደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","የታ አፍይ ዝልንከሶ! እመንዘንኬ እመንም ጭልዝድን ካሲንዘንካ Ꮊምና ስገዳ? ");
INSERT INTO gyl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ኮካንታ ካስ ካርንካ ጫቅድባብ፥ ካስ ካርንዘንከ ካሰርድን ዶቅድን ርንካ ሙዳ ጫቅዴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ሳብታ ጭል ኤሄንከረ ጫቅድባብ፥ ሳብታ ጭል ኤሄንኬ ጭል ኤሄናር ዶቅድን ርንካ ጫቅዴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ጭለካ ጫቅድባበረ ሳብታ ዶቅንት ጎንገንኬ ጎንገንታዘን ዶቅድባብካ ጫቅዴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","የታ ኦተርድባብከስ ሙሴታ ህግንም ኤስስንባብከስኬ ፈረሳውያንንከሶ! የም የኤ! ሳዉሰርድን ር አዝሙድ፥ እንስላል፥ ከሙን ጋይድንደታርንካ ታሜናርንካ ዋልቀንም እምደቴ፥ ኬዛርንካ ማቼ ህግናር ዶቅድን ዝግዝድን ሪንከስም የታ ዛቅደቴ፥ ከታ ከነረ ገታ ማቻን ፍርዳ፥ ቡዳርንካ አትርኬ አመንምኬ፥ ከትከም ዛቃከትዶቆ ይ የም ዝግዝድንዳ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","የታ አፊይ ዝል ጎርስንባብከሶ! የ ዎጭድንደታርንካ ሙዳ ትንጋግንዳ መራ ማቻን ሪን ጭልስሰቶ ዎጭደቴ ግመልግንድ ባካ ርም የንታዋር ኤቅዝደቴ! ");
INSERT INTO gyl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","የታ ኦትረንባብከስ ሙሴታ ህግንም ኤስዝድባብከስኬ ፈረሳውያንንከሶ! የም የኤ! ቡርጨቀንምከ ሳሀንንታ ዘንንደትም ስእደቴ፥ የንታ ዋርጎክንዳ ማቼ ቡረከ ድሰካ ጮጫንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","የና አፊይ ዝል ፈረሳውያንኖ! እርምሰዮ ቡርጭቀንተከ ሳሀንንታ ዋርጎክንደትም ስእካ! ኮትᎺይካ ቡርጎክንደረ ኡርማ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","የታ ኦተረንባብከስ ሙሴታ ህግንም ኤስዝድባብከሰኬ ፈረሳውያንንከሶ! የም የኤ! ከታ ዋር ደእስባብ ኤድንከስታ ለፍኬ ቱና ማቻን ር ሙደንካ ጮጭባብከስ፥ ቡርጎካ ቦቀካ ሳይሶ ላቅምድን ዱክንከስም ካምደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ኮትኮግንደረ የታ፥ ማልጎካ ኤድካንታ ጭልንባብከስም ካምሰቶ Ꮊፈረደቴ፥ የንታ ዋርጎካ ማቼ ኦትረኬ ዳቀልስካ ጮጭቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","የታ ኦትረንባብከስ፥ ሙሴታ ህግንም ኤስዝድባብከስኬ ፈረሳውያንንከሶ! የም የኤ! ሳብዘንከ ኤሰርሶ ኬዛቅባብከስታ ዱክንም ኡርዝደቴ፥ ጭልንከስታ ሰይንካ ኡርሰርሳን ዱክን ሰግዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ኤና እሪ ዎንታ ባቤንከስታ ስለናር ዎ ዶቅሰስናና ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ማቀስን ዉልእንካ ከትካ ክክን ዋልቃ ማተራኮት ዶቆ ጋይደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ይና፥ ሳብዘንካ ኤሰርሶ ኬዝድባብከስም ደይስባብ ኤድንከስታ ይንች የንታ ማትንተን ማርከርደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","የተረ ጉጅሶ የንታ ባበንከስ ፍክስ የጃንደትም ቦድከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","የታ ጉን ፉይንታ ይንችንከሶ፥ ስለንካ ድግዳክን ኖሄንታ ፍርደናርንካ Ꮊስግንደንት ሱርትካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ኮካንታ ይና፥ እታ ሳብዘንካ ኤሰርሶ ኬዝድባብከስም፥ ኤጨንባብከስም፥ ኤስስንባብከስም፥ የንደር ኦይድቴ፥ ከታርንካ ዋልቃ ዋልቃባብከስም የታ ደይዝደቴ፥ ዋልቃ ዋልቃባብከስም ሮግደቴ፥ ዋልቃ ዋልቀንከስመረ አይሁድንከስታ ምክስ ኤሄናር Ꮊርደቴ፥ ዋልቃ ካተመናርንካ አብ ካተመናር ከትም ዳይደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ኮትጎካ ክት ጭልን አበልታ ማቀስንዘንካ የድሶ ሳብታ ጭል ኤሄንተከ ካስ ካርንታ ዎክያር የ ደይሳንደዘንካ የድሶ ባራክታ ይንች ዛከራስታ ማቀስን የለልታ ፍጨዘን ዉልእምሳን ጭልንከስታ ማቀስንታ ዋጭና የንታዘን የልዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ዶፈን የም ጋይድቴ፥ ኮና ሙዳ ዋጭና ኮ አጥርንዘን የልዴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ኮታዘንከረ የሱስ፥ “የሩሳለሞ፥ የሩሳሌሞ! የና ሳብዘንካ ኤሰርሶ ኬዝድባብከስም ደይዝድንዶ! የዝደር ኦይትምስባብከስመረ ሰይንካ አቅድንዶ! ባቸና ይንታ ይንችንከስም ይንታ ከፍንታ ጎይናር ኮት ሳንዝድንደትግንዳ፥ እተረ የስታ ይንችንከስም ዋልቃትችካ ሳንስካንታ በድ ሰጫᎺይካ ካርሳቴ፥ የታ ማቼ ዝጋከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ይና ኮዘንካ፥ ሳብታ ጭል ኤሄና ካይዝ ማትሶ ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ኮካንታ ‘ጮይስታ ላምንካ Ꮊድባብ አንጅምስባቤ’ የ ጋይተርን የለልታ ይና ኮዘነካ ኦስ እም ሰዳከቴ የም ጋይድቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","የሱስ ሳብታ ጭል ኤሄናርንካ ዉትሶ ክት አይድንካ ክታ ካርንካ ጎርስምድባብከስ ሰይንካ ዎድምሳን ሳብታ ጭል ኤሄን ክትም ሰችካንታ ክደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ኖ ማቼ “ኮም ሙደን ሰደቴ? ዶፈን የም ጋይድቴ፥ ሰይንና ሰይንንዘን ከልምሳንዳ ዉልእማክዶቆ ነጋዬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","የሱስ ደብረዘይት ጋይምድን ገቸንዘን ዶቅሶ ክት ዶቅድንካ ክታ ካርንካ ጎርስምድባብከስ ከታ ይንት ክደር Ꮊድሰኮ፥ “ኮና ሙዳ ሪና ማድንዳ Ꮊንተረ? የስታ Ꮊድንተንተኬ ፍጫሙደንታ በእንተታ ቃዉተና Ꮊራ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","የሱሰረ፥ Ꮊየነረ ኤድ የም ኮተርዝዳክንግንዳ ካርስምከቴ! ");
INSERT INTO gyl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","በድንከስ እታ ክርስቶስቴ! ጋየረኮ እስታ ላምንካ Ꮊደኬ፥ በድ ኤድንከስመረ ኮተርስተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ዳምንኬ ዳምታ ኬዘንም ኤሰርተረቴ፥ ኬና ሙዳ ቦድም ዝግዝድንካንታ Ꮊይገቀቴ፥ በእንተና ማቼ አክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ዎርሰና ዎርሰዘን፥ ባንችነረ ባንችንዘን አምተሬ፥ Ꮊክ Ꮊክ ካርዘን ዳቅከ ፍጨታ ጭጭ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ከነረ ሙዳ እችረት ማጠታ የድንታ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","ኮታይካ ኤድንከስ ማጣካንታ ስክስት የም እምተረኬ፥ የም ደይስተረኬ፥ እስታ ላምንካንታ ጋይሶ ዎርሳ ሙደንታ ላመር ቦስምስባብከስ ማተረቴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ኮታይካ በድንከስ ይንታ አሜንን ዛቅሰኮ ኮተርደኬ፥ ክክ ክክ ስክስት እምተረኬ፥ ኤድንከሰረ ክክ ክክ ግርተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","በድን ካርከካ ሳብዘንካ ኤሰራከክዶቆ ኬዝድባብከስ አምተረኬ፥ በድንከስመረ ኮተርስተረከ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ዳቅልንከስታ በድምዘንካ አምሳንዳ በድ ኤድንከስታ ሶልመና ጋንተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","በእንታ የለልታ ዳንዳእካ ዳቅድባብ ማቼ ኖ አቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ኤድ ሙደንካንታ ማርካ ማድንግንዳ፥ ኮና ሳብታ ባንችምታ ክላ ኬዘና ፍጫሙደንዘን ሳባክምዴ፥ ኮት Ꮊይካ በእንተና Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","ሳብዘንካ ኤሰርሶ ኬዝባብ ዳንኤልታ ከዘንግንዳ ቱና ማቻንዳ ይንኤርዝድ ሪ ጭልምሳን ካርንዘን ዎእስንካ የ ሰጃንᎺይካ ናበብድባብ ክት ገቀራ! ");
INSERT INTO gyl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ኮታይካ ይሁዳ ፍጨናር ዶቅድባብከስ ገቼንከዝደር Ꮊዛ። ");
INSERT INTO gyl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ኤሄንታ የለንዘን ዶቅድባብ ይንታ ኤሄናርንካ ዋልቃ ሪ ተይካንታ Ꮊይ Ꮊንቼራ። ");
INSERT INTO gyl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ዎን Ꮊማረረ ዶቆድባብ ይንታ አፍለንም ተይካንታ ይንታ ኤሪ Ꮊይማታ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ኮታይካ ስርመንባብከስካንተኬ አም ጋእዝድባብከስም የኤ! ");
INSERT INTO gyl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ኬዛርንካ ማቼ የንታ አጥምና በርግካ አነረ አይሁድንከስታ Ꮊዉስ ሰጨንካ ማተራክንግንዳ ምክስከቴ! ");
INSERT INTO gyl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ኮታይካ ፍጫ ሙደና ፍዝምሳንደትዘንካ የድሶ ታካ የለልታ ይማክንዳ፥ ኦስ እረረ ኮትግንዳ ቦድሶ ይይምዳክንዳ፥ አንድር ማጣ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ከታኬና ሰጨንከስ ሳነካ በእዳከስናና ዋልቃ ኤድ ዎራ አቅተራክዶቆ፥ ኬዛርካ ማቼ እድምሳን ኤድንከስካንታ ጋይሶ ሳብ ከትኬና ሰጨንከስና ሳነካ በእድንግንዳ ይዴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ኮታይካ Ꮊየነረ ኤድ ይና፥ ክርስቶስ ካሪ ዶቅዴ! አነረ ኦኮታር ዶቅዴ! የንደር ጋይሴ Ꮊይ አሜነቴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ካርካ ክርስቶስንከሰኬ ሳብዘንካ ኤሰራከክዶቆ ካርከካ ኬዝድባብከስ አምደኬ፥ ከደር ማደስናና ሳብካንታ እድምስባብከስም ዎራ ኮተርስካንታ አንድር አተነከስምኬ በርእስዝድን ሪንከስም ሰችዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","“ይና ኬና ሪይንም ሙዳ እርናና የም ከዝትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ኮካንታ ‘ይና፥ ዴል ቆቸናር ዶቅዴ!’ የንደር ጋይዴ Ꮊይዉተቴ፥ ‘ይና አቻ ካርያር ዶቅዴ!’ የንደር ጋይዴ Ꮊይ አሜነቴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ዋልቅንት ጭለዘን ሮጵሶ Ꮊይታ ዉትንታርንካ Ꮊይታ አርድንታ የለልታ Ꮊፈርድንግንዳ፥ ኤድ ይንችንታ Ꮊድንተነረ ኮትኮግንዳ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","ደእሳን ሪ ዶቅድን ካርዘን ድገንከስ ሳንምደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ከትኬና ማጣ ሰጨንከስታ ቡር ሳነካ Ꮊይና ኡምተረ፥ አርፈነረ ይንታ ሳክመንም ሳክሳየ፥ ቤዝንከሰረ ጭለዘንካ ዋችተረኬ፥ ጭለንከስተረ ዎልቀና ጭጭተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ኮተረ ቡር ኤድ ይንችታ ቃዉታ ጭለዘን ሰድምተረ፥ ኮታይካ ፍጫሙደንዘን ዶቅድን አጥርንከስ ኤፍተረኬ። አነረ ኤድ ይንች ዎልቀኬ አንድር ቦንቼካ ኡፔዘን ማትሶ Ꮊድንካ ክትም ሰተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","አንድር ፍቼታ ኡፍስ ኤስምዝድባብ ክታይንችንከስም ኖ ኦይተሬ፥ ከታ ኦይድ ፍጫሙደንታ ፍነንካ አይሰኮ ጭለታ ካንተዘንካ ካንታ የለልታ ዶቅድባብከስም ክትካንታ እድምስባብ ኤድንከስም ሳንዝደኬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ካምስንመረ በለስ Ꮊቀንዘንካ ኤስከቴ፥ ኮታ ግዝደና ፉርድንኬ ኮታ ቃምና ጮልድንካ፥ ኮታይካ Ꮊስን የልሳንደትም ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ኮትኮግንደረ የታ ኮም ሙዳ ሰደቶ ኤድይንች Ꮊድንደታ ሰጨና የልሳንደትም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ዶፈን የም ጋይድቴ፥ ኮና ሙዳ ቦድምተርን የለልታ ኮና አጥርና ስገዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ጭለኬ ፍጨካ ስገደኬ፥ እስታ ቃለና ማቼ ቦድሶ ስጋዬ”። ");
INSERT INTO gyl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ኮትኮ ሰጨንተኬ ኮትኮ ሳዓትንታ ማቼ ሳብ ባቤንዘንካ አብ ጭላር ክታይንችንከስ ማቼረ፥ ይንችና ማቼረ Ꮊየሰነረ ኤሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ኖህታ ስለናር ማቻንደትግንዳ ኤድ ይንች Ꮊድንደት Ꮊይከረ ኮትኮግንዳ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ኮት ስለናር፥ ካይዝድን ሎቀና Ꮊተርንደታ እር ኖሄረ ማርከብናር አርደዳን ሰጨን የለልታ ኤድንከስ እቸረኮ ዎጨረኮ፥ እንቸረኮ ይኤረኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ካይዝድን ሎቀና Ꮊድሶ ሙደንመረ ካይስተርን የለልታ ኤሳከኬ፥ ኤድ ይንችታ Ꮊድንተና ኮትኮግንዳ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ኮታይካ ቃስተን ኤድንከስ ዎንዘን ማተረከ፥ ዋልቃባብ ተይምተሬ ቃስትምስና ነግተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ቃስተን ማነንከስ የካ ደይስን ደይስተረኬ፥ ዋልቀና ተይምተሬ፥ ቃስትምስና ነግተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ይና የንታ ጮይስና Ꮊንታ ክት Ꮊዳናንከረ የ ኤዝዳክንካንታ ንግሶ ካርስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ኬዛርንካ ማቼ ይና ኮም ኤስከቴ፥ ኤሄንባብ ሶይት Ꮊራ ሳዓትንዘን ድብና Ꮊድንደትም ይ ኤዝደስናና፥ ንግሶ ኖ ካርስተርዶቆ፥ ክታ ኤሄነረ ኮይምድንግንዳ ዛቅተራክዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ኮትኮግንደረ ኤድይንች የ ገቀራክን ሳዓታር Ꮊድንካንታ ግግምሶ ዶእከቴ”። ");
INSERT INTO gyl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ይንታ ኤሀ ኤድንከስካንታ እችምን እምድንግንዳ፥ ክታ ማታ ቆልስባብ ይንታ ኤሀ ኤድንዘን ክት ዶርድባብ አሜንምስባብኬ ቡደካ ማችባብ ፍክስንባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ክታ ማተን ቆልስባብ ᎺድንደትᎺይካ ኖኮና ፍክስንባብና ኩን ክት ይድንካ Ꮊፍሴ ኖ አንጅምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ዶፈን የም ጋይድቴ፥ ክትኮ ፍክስንባብም ክታ ማተንቆልስባብ ይንታ ርን ሙደንዘን ክትም ዶርዴ። ");
INSERT INTO gyl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ኖኮና ዳቅል ፍክስንባብ ማቼ፥ ‘እስታ ማተን ቆልስባብ ታ ኖ Ꮊዳክዬ ጋምእዴ’ ጋይሶ ክት ገቀርሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ይንታ ፍክስንታ ላኮይትንከስም ጉጵና ክት የጄ፥ ጎዝንባብከስካ ክክን ክት እቸኬ ክት ዎጬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ክትኮ ፍክስንባብታ ማታ ቆልስባብ ክት ካርሳክን ሰጨናርኬ ክት ኤሳክን ሳዓትንዘን ኖ Ꮊዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ክትኮ ፍክስንባብም ክታ ማታ ቆልስባብና ክትም ዋጭዴ፥ ክታ እዋንነረ ኦትረንባብከስካ ክክን ማስተሬ፥ ኮታረረ ኤፍኬ አች ቅርጭካ ክትካንታ ማተሬ”። ");
INSERT INTO gyl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ኮታዘንከረ የሱስ፥ “ኮታይካ ጭላ ባንችምና ከታ ይንታ ዞጰን የድሰኮ፥ እንቸንባብም ሞካካንታ ዉተድባብ ታማ ይንች አንጀንከስም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ከታርንከረ ዶንቅና ዳቸንከስ፥ ዶንቅና ኤጫ ማችባብከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ዳቻ ማችባብ አንጀንከስ ከታ ይንታ ዞጰን የጅንከረ ዞጰንካንታ ማድን ስጥመካ ላምባ የዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ኤጫ ማችባብ ይንችን አንጀንከስ ማቼ ከታ ይንታ ዞጰንካ ክክን ስጥመካ ላምበንም ሪካ የታ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","እንቸንባበረ ጋምእሳንካንታ ከት ሙደንም ግንእስ የጅንካ ራቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ገልትገር ማድንካ ‘ይና እንቸንባብ Ꮊዴ! ዉትሰቶ ሞክት ክትም ተይከቴ!’ ጋይድን አዉል ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ኮታይካ ይንች አንጀንከስ ሙደና አምሰኮ ይንታ ዞጰን ግግሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ዳቻ ይንች አንጀንከስ ማቼ ኤጨንባብከዝደር ዎንታ ዞጰና ድግካንታ ይድንኦል ‘ዋደቴ የንታ ላምበዘንካ ዎካንታ እምከቴ’ ከደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“ኤጫ ይንች አንጀንከስ ማቼ ዎካንተከ የካንታ ማድን ላምባ ዎንደር ካዬ። ኮካንታ ሰንድን ካርያር አይሰቶ የንታ ማታ ካንታ ላምበን ሰንከቴ ጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ዳቻ ማና ይንች አንጀንከስ፥ ላምበንም ሰንማካንታ ከት አይሳንደትካ እንቸንባብ Ꮊዴ። ግግምሶ Ꮊቅባብ ይንች አንጀንከሰረ እንቸንባብካ ክክን እሰንካንታ እችምን ግግስምሳን ኤሄናር አርደደኬ፥ ፍልተነረ ዝጭምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ቡር ነግድባብ ይንች አንጀንከስ Ꮊድሰኮ፥ ‘የ ዎባቦ! የ ዎባቦ! ዋደ ፍልተንም ዎካንታ ፎችካ’ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ኖ ማቼ፥ ‘ዶፈን የም ጋይድቴ፥ እታ የም ኤዝዳክቴ!’ ጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ኮካንታ ሰጨንምከ ሳዓትንም የ ኤዝዳክንኦል ንግሰቶ ካርስከቴ”። ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ኮታይካ ጭላ ባንችምናር አርድንተና ኮትኮግንዳ ማደ፥ ዋልቃ ኤች አብ ፍጫር አይድዮ ይንታ ፍክስንባብከስም ኤልሶ ይንታ ዶቅድን ሪን ከትካንታ እምስባብ ኤችንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ኖ ኤችነረ ዋልቃ ዋልቀንከስካንታ ከታ እምንተንግንዳ ካዝድዮ፥ ዋልቃባብካንታ ዶንቅ ጣገራ ብራ ዋልቀባብካንታ ቃስቴን ጣገራ ብራ፥ አና ዋልቃባብካንተረ ዋልቃ ጣገራ ብራ እምስንደተኬ ሳነካ አብ ፍጫር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ዶንቅ ጣገራ ብረንም ተይባብ ሳነካ አይሶ ብረንካ ዛልአ የድሶ ዶንቅንዘን ዶንቅ ጣገራ ብራ አእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ቃስቴን ጣገራ ብረንም ተይባበረ ኮትኮግንደረ አብ ቃስቴን ጣገራ ብራ አእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ዋልቃ ጣገራ ብረንም ተይባብ ማቼ አይስንደትኬ ፍጫ ኮይሶ ይንታ ማታ ቆልስባብታ ብረንም አቼ። ");
INSERT INTO gyl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","በድ ሰጨታ ቡር ከትኬ ፍክስንባብከስታ ማተን ቆልስባብ Ꮊድሶ ይንታ ፍክስንባብከስካ ክክን ብረካ Ꮊራ ፍክስምሳናንከረ ከዝም የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ዶንቅ ጣገራ ብረንም ተይባብ ፍክስንባበረ ይንታ ማተን ቆልስባብደር Ꮊድሶ ዶንቅ ጣገራ ብረን ክትካንታ እምሶ የባቦ! ዶንቅ ጣገራ ብራ እካንታ እምተይናና፥ ኮሰቼ! አብ ዶንቅ ጣገራ ብራ አእስትቴ! ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ክታ ማተን ቆልስባበረ ኡርማ ይሳዬ፥ የና አመንምሳባብ ላቅም ፍክስንባብ! ቶክም ሪካ አሜንምስባብ ማትሰዮ የስ Ꮊፈርሳንካንታ በድ ሪንከዘን የስም ዶርድቴ፥ ኮሬ የስታ ማተን ቆልስባብታ ጉርምንካ ጉርምካንታ አርድካ! ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ቃስተን ጣገራ ብረን ተይባብ Ꮊድሶ የ ዎባቦ! እካንታ ቃስተን ጣገራ ብራ እምታይናና፥ አብ ቃስተን ጣገራ ብራ አእስትቴ! ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ክታ ማተን ቆልስባበረ ኡርመ! የና አሜንምስባብከ ኡርማ ፍክስንባብ ቶክም ርንካ አሜንምስባብ ማትሰዮ የስ Ꮊፈርሳንካንታ በድ ርንከስታዘን የስም ዶርድቴ፥ ኮሬ የስታ ማታ ቆልስባብታ ጉርምንካ ጉርምካንታ አርድካ! ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ዋልቃ ጣገራ ብረን ተይባበረ Ꮊድሶ፥ የ ዎባቦ! የስ ማሳክንደታርንካ ስግድባብ፥ የስ ይጫክንደታርንካ ሳንዝድባብ፥ ጋርዛ ኤድ የስ ማቻንደትም ኤዝድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ኮካንታ ጳስስቶ አይስቶ የስታ ጣገራ ብረን ፍጨናር አቻቴ፥ ኮንሴ የስታ ጣገራ ብረና! ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ክታ ማተን ቆልስባብ ማቼ፥ የና ዳቅልኬ ቦዛ ፍክስንባብ! እ ማሳክንደታርንካ እ ስክድንደትም እ ይጫክንደታርንካ እ ሳንዝድንደትም የስ ኤዝድንዳ ማቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","እስታ ብረንም ዛለን ዛልድባብከስካንታ እማ የስም ዝግዝዳዶቆ፥ እተረ እ Ꮊዳንደትካ እስታ ብረንም አጥመካ ክክን ተይድትዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ኮካንታ ብረንም ክታዘንካ ተይሰቶ ታማ ጣገራ ብራ ዶቅድባብካንታ እምከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ዶቅድባብካንታ ሙደነረ ጉጅምዴ ክትካንተረ በተሬ፥ ካየንባብከዘንካ ማቼ ና ዶቅድናዳ ዎራ ክታዘንካ ተይምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ክትኮ መይዳክባብ ፍክስንባብም ማቼ ማል ዶቅድን ግልድድ ኡምናር ክትም ዉችተቶ ኦይትከቴ፥ ኮታረረ ኤፍከ አች ቅርጭካ ክትካንታ ማተረ ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","ኤደት ይንች ይንታ ቦንቸካ ክት ᎺድንᎺይካ ክትካ ክክን ሳብካንታ ፋስምስባብ ክታይንችንከስ ሙዳ፥ ኮታይካ ይንታ ቦንችምሳን ባንችንከስታ ዶቅንት ጎንገንዘን ዶቅተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ዎርሰንከስ ሙዳ ክታ እር ሳንምደኬ፥ ግስመንባብ ቆልንከስም ደርትንከዘንካ ፋዝድንደትግንዳ ኖየረ ዎርሰንከስም ዋልቀን አብንከዘንካ ኖ ፋስተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ጭልንከስም ይንታ ምዝንዘን፥ ጎመንባብከስም ይንታ ከችንዘን ከትም ዎይስተረ። ");
INSERT INTO gyl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ኮታይካ ባንችና ይንታ ምዝንዘን ጎካ ዶቅድባብከስም ኩን ከትም ጋይተሬ፥ የታ እስታ ባቤና የም አንጅባብከሶ! ኮረቴ! ፍጫ ሙደና ፍዝምሳንዘንካ የድሶ የካንታ ግክስምሳንደትም ባንችምን ተይከቴ! ");
INSERT INTO gyl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","እ ዳቀርስንካ እም እችስተቴ፥ እ ዎቸርስንካ እም ዎእስተቴ፥ ሶች ማትስቶ እ Ꮊድንካ እም ሞክተቴ ");
INSERT INTO gyl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ዘነካ እ ማችንካ እም ቆፍስተቴ፥ እ ሰቀርስንካ እም ሰቅስተቴ፥ እ ዞከርስንካ እም ኦይስተቴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ጭልንከስ ኩን ጋይሰኮ ክትካንታ ማዝደከ፥ የ ዎባቦ፥ Ꮊንታ የስ ዳቀርስንካ ሰድሶንት የስም እችሳራ? Ꮊንታ የስ ዎቸርስንካ ሰድሶንት የስም ዎእሳራ? ");
INSERT INTO gyl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ꮊንቶንት የስ ሶች ማትሶ Ꮊድንካ የስም ሞክሳረ? Ꮊንቶንት ዘነካ የስ ማችንካ ሰድሶ የስም ቆፍሳራ? ");
INSERT INTO gyl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ꮊንቶንት የስ ሰቀርስንካ አነረ የስ ዞከርስንካ የስም ሰድሶ Ꮊድሶንት ኦይሳራ? ጋይተረክኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ባንችነረ ዶፈን የም ጋይድቴ ከትኬና እስታ እስመንከሳርንካ መራ ማችባብ ዋልቃባብካንታ ዎራ የ ይሳንዳ ሙዳ እካንታ ይሰቴ! ጋየሮ ከትካንታ ማስተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ኮታ ቡር ክታ ከችንዘንጎካ ዶቅድባብከስመረ፥ የታ ባድምስባብከስ! እዘንካ ኦስ ጎተርከቴ! ዳብሎስካንተኬ ክታ ካርንካ ጎርስምድን ክታይንችንካንታ ግግስምሳን ስለንክንደታ ኖሄናር አይከቴ! ");
INSERT INTO gyl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","እ ዳቀርስንካ እም እቻከቴ፥ እ ዎቸርስንካ እም ዎእሳከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ሶች ማትስቶ እ Ꮊድንካ እም ሞካከቴ፥ ዘነካ እ ማችንካ ሰድሰቶ እም ቆፍሳከቴ፥ እ ሰቀርስንከኬ ዞከርስንካ እም ኦይሳከቴ፥ ኩን ከትም ጋይተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ከተረ የ ዎባቦ፥ የስ ዳቀርስንካ አነረ የስ ዎቸርስንካ፥ ሶች የስ ማችንካ አነረ ዘነካ የስ ማችንካ፥ የስ ሰቀርስንካ አነረ የስ ዞከርስንካ ሰድሶቶ Ꮊንቶንት አለንም የስም አልክሳ ነገዳራ? ኩን ጋየረኮ ክትካንታ ማስተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ባንችነረ ዶፈን የም ጋይድቴ፥ ከትኬና መራ ማችባብ ዋልቃባብካንታ ዎራ የ ይያክንዳ ሙዳ እካንተረ የ ይያክንግንዴ ከትም ጋይተሬ። ");
INSERT INTO gyl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“ኮካንታ ከታኬና ስለንክንደታ ዋጭናር ከት አይድንካ፥ ጭልንከስ ማቼ ስለንካ ዶቅንትናር አይተረኬ”። ");
INSERT INTO gyl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","የሱስ ኬና ርንከስም ኬዝት ይ በይሳንደታ ቡር ይንታካርንካ ጎርስምድባብከስም፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ቃስተን ሰጨታ ቡር ፋስጋ ማድንደትም የታ ኤዝደቴ፥ ኤድ ይንች ሮክርካንታ ስክስምት እምምተሬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ኮትኮᎺይካ ቀሰንም ገችዝድባብከስኬ ዎርሰናርንካ ጋልተንከስ ቀሰንከስም ገችዝድባብታ ጋስናር ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ኮታረረ የሱሰም ጩበካ የድካንተኬ ደይሳካንታ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ኬዛርንካ ማቼ “ዎርሰንከስታ ዎክያር አዉል አምዳክንግንዳ ባአል ሰጨንካ Ꮊይማታ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","የሱሰረ ብታንያ ፍጨናር እጳ ሰቅምካ Ꮊቅባብ ስምኦነታ ኤር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ኮታረረ የሱስ እችም ክት እቻዶቅድንካ ዋልቃ ኤተን አንድር ስንጋ ማቻን ዎዝድንደትም አልባስጥሮስ ብልቃትካ የድሶ ክደር Ꮊድስንደትኬ፥ ዎዝድንደትመረ ክታ ማተንዘን ዉልእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ክታ ካርንካ ጎርስምድባብከስ ኮም ሰድሰኮ ዋጨሮ፥ “ኮም ዎዝድንደትም Ꮊረተረ ዉች ባችና? ");
INSERT INTO gyl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ኮና ዎዝድንደና በድ ብራ ሰንምሶ ሪ ካየንባብከስካንታ እምም ዝግዝዳዶቆ!” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","የሱሰረ ኮም ከታ ጋይተንም ኤስሶ፥ “ኮትኮም ኤተንን Ꮊረተንት ማእዝዳ? ና እካንታ ኡርማ ር ይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ሪን ካየንባብከስ ሙዳᎺይካ የንካ ክክነከ እታ ማቼ ሙዳᎺይካ የንካ ክክን ካሪ ዶቃይቴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ና ኮም ዎዝድንደትም እስታዘን ኮታ ዉልእና እም ዱክካንታ ኮት ግግሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ዶፈን የም ጋይድቴ ኮና ፍጫሙደንዘን ክላ ኬዘና ሳባክምድን Ꮊምን ካርዘነረ ኮና ኮት ይሳንዳ ኤድ ገቀርተርንግንዳ ኮትካንታ ከዝምተሬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ኮትኮᎺይካ ታሜከ ቃስተንናርንካ ዋልቀና አስቆሮንት ይሁዳ ቀሰንከስታ ገችንባብከዝደር አይሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“የሱሰም ስክስት እ የካንታ እምሴ Ꮊረንት እምተራ?” ኖ ጋይሴ። ከተረ ቦንደከ ታማ ብራ ፋይት እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ኖየረ ኮትኮ ሳዓተንዘንካ የድሶ የሱሰም ስክስት ይ እምድንደታ ሰጫ ዝግድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ባይስ ባአልንታ እሪ ሰጨንካ ክታ ካርንካ ጎርስምድባብከስ የሱሰደር Ꮊድሰኮ፥ “ፋስገንታ ሶይት እችምን Ꮊብር ዎ የስካንታ ግግዝድንግንደስ ዝግዳ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ኖየረ፥ “ኦስ ካተመናር የ አርድንካ የᎺብድን ኤችንታ ኤሪ አይሰቶ ‘ኤስስንባብ እስታ ሰጨና የልሳንካንታ እስታ ካርንካ ጎርስምድባብከስካ ክክን ፋስጋ ባአልንታ ሶይት እችምን እ እጅድንዳ የስታ ኤር ኖ ጋይዴ’ ክደረ ጋይከቴ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ክታ ካርንካ ጎርስምድባብከሰረ የሱስ ከትም ክትሳንግንዳ ፋስገንተረ ሶይት እችምን ግክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ፍጨና ሶይቻንደትከረ የሱስ ታመከ ቃስተን ክታ ካርንካ ጎርስምድባብከስካ ክክን እችምካንታ ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ከት እጅድንከረ፥ የሱስ “ዶፈን የም ጋይድቴ፥ የንታ ዎክያርንካ ዋልቀና እም ስክስት እምተሬ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ክታ ካርንካ ጎርስምድባብከሰረ ኮትኮ ከዘነካ አንድር ሞርእሰኮ፥ ዋልቃ ዋልቀንከስ የ ጮይስዮ፥ “እታ ማትትዳቶ?” ጋየረኮ ክትም ኦይስ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","የሱሰረ፥ “እም ስክስት እምድባብ እንካ ክክን ይንታ አንንም ጋበትናር ኦይችባቤ። ");
INSERT INTO gyl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ኤድ ይንች ክትጎካ ጭል ማጻፍናር ጻፍምሳንደትግንዳ ኖ ደእዴ፥ ኬዛርንካ ማቸ ኤድ ይንችንም ስክስት እምድባብ ኤችን ክትካንታ የኤ! ኖኮና ኤችና አጥምክሳ ክት ነገደስናና ኡርዳዶቆ።” ");
INSERT INTO gyl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ስክስት እምድባብ ይሁደረ፥ “የ ኤስስንባቦ! እታ ማትትዳቶ?” ኖ ጋይሴ። የሱሰረ፥ “የስ ጋይሳንግንዴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ከት እቻዶቅድንከረ የሱስ ባይስንም አምስሶ አንጄ፥ አስተረ ይንታ ካርንካ ጎርስምድባብከስካንታ “ይንከቴ እችከቴ ኮና እስታ ዋሄ” ጋይሶ ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ኮታዘንከረ ዎጭምን ኡፍተንካ አምስትዮ ሳብም ይ ጋለቻንደታ ቡር፥ “የታ ሙደነረ ኮትኮ ኡፍተናርንካ ዎጭከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ናኮና በድንከስካንታ ከታ ጎመን ነጋ ጋይካንታ ዉልእምድንዳ ክላ ጫቀን መያ ማዝድንዳ እስታ ማቀስኔ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","እስታ ባቤንታ ባንችምናር ክላ ዎይን ዎጭምን የንካ ክክን እ ዎጭተርን ሰጨን የለልታ ይና ኮዘንካ ኦስ ዎይን ዎጭምን አናካርንካ ዎጭዳክቴ” ኩንጋየሮ ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ኮታዘንከረ የችንም የችሰኮ ደብረዛይት ገቼንዘን ዉተደኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ኮትᎺይካ የሱስ፥ ይንታ ካርንካ ጎርስምድባብከስም፥ “ ‘ግስመንባብም ጉጵድቴ፥ ዉዳ ቆልንከሰረ ይጭምደኬ’ ጋይምሶ ጭል ማጻፍናር ጻፍምሳንካንታ ኮ ሶይትናር የታ ሙደና እም ካተረቴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ኬዛርካ ማቸ ደእያርንካ እ አምሳንደታ ቡር ገሊላ ፍጨናር የንዘንካ እርምስቶ አይድቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ኮትᎺይካ ጴጥሮስ፥ “አብንከስ ሙዳ የስም ካጀረ ዎራ እታ ቦድሶ የስም ካዳይቴ!” ጋይሶ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","የሱሰረ “ዶፈን የስም ጋይድቴ፥ ታካ ሶይትን ኮታር ባቻ ቅቅተርንደታ እር የና ማከን ዱት እም ካተራዬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ጴጥሮስ ማቼ “የስካ ክክን ደእ እም ዝክሰረ ዎራ ደእድት ዳት ቦድሶ የስም ካዳይቴ!” ክደር ጋይሴ። ነግድባብ ክታ ካርንካ ጎርስምድባብከሰረ ሙደና ኮትግንዳ ጋይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ኮታ ቡር የሱስ ይንታ ካርንካ ጎርስምድባብከስካ ክክን ገተሰማን ጋይምድን ካርናር አይሴ፥ ኮታረረ ከታ ይ የልሳንግንዳ የሱስ ይንታ ካርንካ ጎርስምድባብከስም፥ “እታ ኦኮታር እ ምግዝድንካ የታ ካሪ ዶእከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ይንካ ክክን ጴጥሮስምከ ዛብዶሰታ ይንች ቃስተንን ጎርስሶ አይሴ፥ ሞርእከ ማጥረረ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ኩነረ ከትም ጋይሴ፥ “እስታ ሰንፔና ደእ የለልታ አንድር ሞርእሴ፥ የታ ካሪ ዶእከቴ፥ ንግዝባብ ማትከቴ።” ");
INSERT INTO gyl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ከታዘንካ ቶክምካ ጎተርሶ፥ ፍጨዘን ይንታ ባለንካ ጉፕንጋይሶ፥ “እስታ ባቤኖ! የዝደር ማድንዳ ማቼ ኮና ማጠታ ኡፕተና እዘንካ ስጋ! ኬዛርካ ማቼ የስታ ጋይታ ማታጋካዳት እስታ ጋይታ Ꮊይማታ” ኩን ጋይሶ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ኮታ ቡር ይንታ ካርንካ ጎርስት ይ አይስባብ ማከንንደር ማትዮ ክት Ꮊድንካ ራትሶ ከትዶቅድንካ ከትም Ꮊፍሴ፥ ኮካንታ፥ ጴጥሮስም፥ “እንካ ክክን ዋልቃ ሳዓትካንታ ዎራ ንግሶ ዳቅካንታ ማታከቴ? ");
INSERT INTO gyl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ጰጨናር የ አርተራክንግንዳ ንግሶ ምክስከቴ፥ የንታ አያንና ግግምቴ፥ የንታ ዋሄና ማቼ ጋፍሳንዴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","አናካርንከረ የሱስ ቃስትምስ ዱት ከታዘንካ ጎተርሶ አይስንደትከ “እስታ ባበኖ! ኮና ማጠንታ ኡፕተና እ ዎጫክናና ስገዳክንዳ ኮት ማቼ የስታ ጋይተና ማታ” ጋየሮ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","አነተረ ይንታ ካርንካ ጎርስምድባብከዝደር ማት ክት Ꮊድንካ ግንእስ ከትም የጅንካ ከት ራትሶ ዶቅድንካ ከትም Ꮊፈሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","አናካርንካ ከትም ዛቅሶ አይስንደትከ እር ይ ምክሳን ምክስን ኮትም ማክምስ ዱት ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ኮታዘንከረ ይንታ ካርንካ ጎርስምድባብከዝደር ማትዮ Ꮊድስንደትኬ፥ “ታየረ አክ ራትዘንከ Ꮊዉስ ዘነንት ዶቅዶ? ይና ኤድ ይንች ጎመንባብከስታ አንያር ስክስምት እምምድንደታ ሳዓትና ቅንችቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","አምሶ ዎም ሙከቴ! ይና ስክስት እም እምድባብ Ꮊድሶ ቅንችቴ!” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","የሱስ አክ ኬዘዜን ክት ዶቅድንካ ይና ታመከ ቃስተን ክታ ካርንካ ጎርስምድባብከሳርንካ ዋልቀና ኖ ይሁዳ Ꮊዴ፥ ከትከረ ክክን ማሰኬ ጉፈካ የጅባብ በድ ኤድንከስ Ꮊደኬ፥ ከተረ ቀሰንከስም ገችዝድባብከዘንኬ ዎርሰንከስታ ጋልተንከዘንካ Ꮊድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","የሱሰም ስክስት እምድባብ ይሁደረ ኤድንከስካንታ “የ ዝግድባብ እ ክትም ሶንቅድባብ ማቻንካንታ ክትም የድከቴ” ጋይሶ ከትካንታ ቃዉታ ከዝታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ይሁደረ ሳነካ Ꮊድሶ የሱሰደር የልሶ “ኤስስንባቦ! አቦ የና ኡርሞ!” ጋይሶ ክትም ሶንቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","የሱሰረ “እስታ ላኮይትኖ! ይና የስ Ꮊዳንደትም ቦድካ” ክትም ጋይሴ፥ ኮታዘንከረ ኤድንከስ የሱሰደር Ꮊድሶ ክትም የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ኮት ሳዓትንዘን የሱሰካ ክክን Ꮊቅባብከሳርንካ ዋልቀና አንን ይንታ አምስሶ ማሰን ጎችትዮ ቀሰንከስም ገችዝድባብታ ፍክስንባብታ ቃምን ተቼ። ");
INSERT INTO gyl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","የሱስ ማቼ፥ “ማሰንም ጎጅድባብ ሙደና ማሰካ ካይደኬ፥ ኮካንታ የስታ ማሰንም ማስሳዮ ሶግናር አርችካ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ይና እታ እስታ ባበንም እ ምክሴ ኖ በድ ሳኤካ ፋይድምድን ዳምንባብከስ ክታይንችንከስም እካንታ ኦይዳክን የንደር ካምዶ? ");
INSERT INTO gyl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ኩን ማደስናና ‘ኮግንዳ ማት ዝግዝዴ’ ጋይድን ጭል ማጻፍንከስታ ቃለና Ꮊስግንዶክ ቦድምዳ?” ");
INSERT INTO gyl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ኮት ሳዓትንዘን ኮታር ሳንምሳን ዎርሰንከስካንታ ኩን ጋይሴ፥ “ፋንገንም የ የድንደትግንዳ እም የድካንታ ማሰንከስምኬ ጉፈንከስም የድሰንት Ꮊዶ? ሰጫ ሙደንካ ሳብታ ጭል ኤሄናር ኤስሰርቶ የንካ ክክን እ ዶቅድንካ እም የዳከትዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ኬዛርካ ማቼ ኮና ሙዳ ማቻንዳ ሳብዘንካ ኤስርሶ ኬዛቅባብከስካ ጭል ማጻፍናር ጻፍምሳንዳ ቦድምድንግዴ” ኮትᎺይካ ክታ ካርንካ ጎርስምድባብከስ ሙደና ክትም ዛቅሶ አጥምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ኮታዘንከረ የሱሰም የጅባብ ኤድንከስ ቀሰንከስታ ገችንባብ ቀያፈደር ተይክትም አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ጴጥሮስ ማቼ ቀሰንከስም ገችዝድባብታ ጋስናር የለልታ የሱሰም ጎትካ ጎርስምሴ፥ ጋስንታ ዋረረ አርድሶ ሪንታ ቦድንተንም ሰድንካንታ ካርሰንባብከስካ ክክን ኖ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ቀሰንከስታ ገችንባብኬ አይሁድንከስታ ቡጫ ጋልተንከሰረ ሙዳ የሱሰም ደይሳካንታ ካርካ ማርከንከስም ዝግድዮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","በድ ካርካ ማርከንከስ Ꮊድንከሬ፥ ደእካንታ ፋረችዝድን ማርካ Ꮊፋከኬ፥ በእንታዘነረ ቃስተን ማርከንከስ Ꮊድሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ኮና ኤችና ‘ሳብታ ጭል ኤሄን ዉልእስቶ ማከን ሰጫር ዎድቴ’ ኖ ጋይቴ” ጋይሶ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ቀሰንከስታ ገችንባብ አምስንደትከ የሱሰደር፥ “ኬና ኤድንከስ የዘን ከት ማርከርድንደታ ሙዳ Ꮊረነረ ማሳያ?” ጋየሮ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","የሱስ ማቼ ጫምን ጋይሴ። ቀሰንከስታ ገችንባበረ አናካርንካ የሱሰም “ዶቅንት ሳብንታ ላምንካ የስም ጫቅዝድቴ! የና ሳብታ ይንች ክርስቶስ የስ ማቻንደትም ዎካንታ ኬዝካ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","የሱሰረ፥ “የስ ጋይሳንደትግንዴ፥ ኬዛርንካ ማቼ የና ኮዘንካ ኦስ ኤድ ይንች ዎልቀንክንባብ ሳብንታ ምዝዘን ዶቅሶ ክት ዶቅድንካ ሰተረቴ፥ ኮትኮግንደረ ጭለዘን ኡፐካ ማትሶ ክት Ꮊድንካ ሰተረቴ እታ የም ጋይድቴ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ኮትᎺይካ ቀሰንከስም ገችዝድባብ ይንታ አፍለንም Ꮊእስሶ ኩን ጋይሴ፥ “ይና ኖ የክንም የክቴ! የተረ ክታ የክንም ኤሰርተቴ! ኮዘንካ ስግ Ꮊራ ማርካ ዝግዝዳ! ");
INSERT INTO gyl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ይና Ꮊሮክ የም ካምዳ?” ከተረ “ደእ ክትም ዝግዝዴ!” ጋየሮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ኮት ሳዓትንዘን ከታ ይንታ ፈጭምን ክታዘን ፈጭምሰኬ፥ ክትም ቱንክሰኬ፥ ክትም ጫቀረኮ፥ ");
INSERT INTO gyl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“ክርስቶስዮ! Ꮊይራ የስም ጉጵስባብ? ይና ቤርንም ዎካንታ ኬዝካ” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ጴጥሮስ ኤሄንታ ማል ቀሰንከስም ገችዝድባብታ ጋስናር ዶቅሶ Ꮊቄ፥ ኮትᎺይካ ዋልቃ ኤተን ፍክስንዳ ክደር Ꮊድሶ፥ “የነረ ገሊላ ፍጨናርንክንባብ የሱሰካ ክክን Ꮊቃዬ!” ክትም ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ኖ ማቼ፥ “የስ ጋይድባብም ኤሳይቴ!” ጋይሶ ሙደንከስታ እሪ ካጄ። ");
INSERT INTO gyl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ኖ ዉትካንታ ፍልተንደር ክት የልድንካ ዋልቃ አብ ኤተን ፍክስንዳ ክትም ሰድስንደትከ ዋር ዶቅድን ኤድንከስካንታ “ኮና ኤችና ናዝረት ፍጨናርንክንባብ የሱሰካ ክክን Ꮊቄ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ጴጥሮሰረ፥ “ኮም የስ ጋይድን ኤችንም ኤሳይቴ!” ጋየሮ ጫቀካ አናካርንካ ካጄ። ");
INSERT INTO gyl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ኮታዘንከረ ቶክም ዶቅሳን ቡር ኮታር ዎእሶ Ꮊቅባብ ኤድንከስ ጴጥሮሰደር እጵን ጋይሰኮ፥ “የስታ ኬዘና የስም መያ ማዝዴ ገታ የነረ ከታርንካ ዋልቃ ባበዬ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ኮት ሳዓትንካ ጴጥሮስ፥ “እታ ኤችን ክትም ኤሳይቴ!” ጋየሮ ባድከ ጫቀረ የጄ። ሳነከረ ባቻ ቅቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ጴጥሮሰረ “ባቻ ቅቃክናና ማከን ዱት እም ካተራዬ” ጋይሶ የሱስ ኬዛን ቃለና ክትም ከልቅን ጋይሴ፥ ጴጥሮሰረ ኦስ ማል ዉትሶ ቡዳርንካ ኤፍሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ዛማ ገልትናር ቀሰንከስም ገችዝድባብከስከ ዎርሰናርንካ ጋልተንከስ ሙዳ የሱሰዘን ደእታ ፍርዳ ፋረችስካንታ ዞርምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ኮታ ቡር የሱሰም ዞክሰኮ ሮማ ፍጨንም ቆልድባብ ጵላጦስካንታ ተይ አይሰኮ ስክስት እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","የሱሰዘን ፋረጃንደትም ይ ሰዳንደትካ ስክስትን እምስባብ ይሁዳ ኡቅምሴ፥ ይ ተያን ቦንደከ ታማ ብረንም ቀሰንከስም ገችዝድባብከስካንተኬ ዎርሰናርንካ ጋልተንከስካንታ ኩንጋየሮ ማስት ከትካንታ እምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ጭል ኤችንም ደእካንታ ስክስት እስታ እምንተንካ ባችስትቴ” ከታ ማቼ “ይና ዎም Ꮊራ ማጫራ! ኮና የስታ ማጤ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ኖየረ ብረንም ሳብታ ጭል ኤሄናር ዛቅሶ አይስንደትከ ድሰርት ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ቀሰንከስታ ገችንባብከስ ቦንደኬ ታማ ብረንም አምስሰኮ፥ “ኮና ብረና ማቀስታ ብራ ኮት ማቻንካንታ ሳብታ ጭል ኤሄናር እመርሳንደትካ ክክን ዎ ቡቅድንግንዳ ዎንታ ህግና ጋይዳክዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ኮካንታ ከታ ይ ዞርምሳንደታ ቡር ሶችንከስታ ዱክ ካሪ ማድንግንዳ ዳሄን ኡርዝድባብታ ፍጨንም ሰንት ተየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ኮትኮጎካ ናኮና ፍጨና ታካ የለልታ፥ “ማቀስ ፍጫ” ጋይመሮ ኤልምዴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ኮግንደካ ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኤርምያሰካ “እስራኤል ዎርሰንከስ ኮካ ማታ ከት ጋይሳን ክታ ናክ ማድንደትም ቦንደከ ታማ ብረንም ተየኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ጮይሰረ እም ክትሳንግንዳ ዳሄን ኡርስዝድባብታ ፍጨንካንታ ናክሰኬ” ጋይምሶ ኬዝምሳን ቤርና ቦድምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ኮትᎺይካ የሱስ ሮማ ፍጨንም ቆልድባብ ጵላጦሰታ እር ዎእሴ፥ ፍጨንም ቆልድባበረ “የና አይሁድንከስታ ባንቻዮ?” ጋይሶ ክትም ኦይሴ፥ የሱሰረ “የስ ጋይሳንግንደ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ኮታዘንከረ ቀሰንከስም ገችዝድባብከስኬ ጋልተንከስ ከት ካሰዝድንካ Ꮊረነረ ከትካንታ ማሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ኮታ ቡር ጵላጦስ፥ “መም ርይካ የስም ከት ካሰዝድንካ ኤሰራያ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","የሱስ ማቼ ሮማ ፍጨንም ቆልድባብ አንድር በርእተርን የለልታ ዋልቃ ካሰስንታ ዎራ ማስንም ከዛክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ሮማ ፍጨንም ቆልድባብ ስለዘን ስለዘን አይሁድንታ ፋስጋ ባአልንᎺይካ ከትካንታ ቡልምድንግንዳ ዎርሰና ዝግዝባብም ዞከርስባብከሳርንካ ዋልቃባብም ክት ቡልድንደታ መጣ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ኮትᎺይካ “ባርባን” ጋይምድባብ ይንታ ባችንካ ኤስምስባብ ዞከርሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ኮካንታ ኤድንከስ ሳንምሳንደትካ ጵላጦስ፥ “Ꮊይም የካንታ እ ቡልድንግንደንት ዝግዳ? ባርባንሞ አና የሱስ ጋይምስባብ ክርስቶሰሞ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ጵላጦስ ኮመረ ክት ጋይሳንዳ የሱሰም ቀምስካ ስክስት ከት እምሳንደትም ይ ኤዝድንደትካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ኮትኮግንደረ ጵላጦስ ፍርዳ እምካንታ ዶቀርድን ጎገንዘን ዶቅሶ ክት ዶቅድንካ ክታ ኬነና፥ “ክትጎካ ናካ ሶይትን Ꮊምስካ በድ ማጠርሳቴ ክትኮ ጭል ኤችንዘን Ꮊራርየሰነረ የስ ይይዳክንግንዳ” ኩንጋይሶ ክታ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ኮትᎺይካ ቀሰንከስም ገችዝድባብከስኬ ጋልተንከስ ባርባን ቡልማ! የሱስ ማቼ ደአ! ጋይሰኮ ከት ጵላጦሰም ኦይዝድንግንዳ ዎርሰንም ኤእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ሮማ ፍጨንም ቆልድባበረ “ቃስተንናርንካ Ꮊምን እ የካንታ ቡልድንግንደንት ዝግዳ?” ጋየሮ ዎርሰንም አነታ ኦይሴ። ከተረ “ባርባንም ዎካንታ የስ ቡልድንግንዳ ዝግዶቴ” ጋየረኮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ጵላጦሰረ፥ “ይና፥ የሱስ ጋይምድባብ ክርስቶሰም Ꮊስስ ክትም ይቴ?” ከደር ጋይሴ። ሙደነረ “ክት ሮከራ!” ጋየሮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ሮማ ፍጨን ቆልድባበረ Ꮊረታ? “ክት ይሳንዳ ባችና Ꮊራ?” ከደር ጋይሴ። ከታ ማቼ “ክት ሮከራ!” ጋየረኮ በድ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ኮካንታ ጵላጦስ ኮና ርና አዉልም አምስዝድንዳ ዳት አብ Ꮊረነረ መይዳክንደትም ይ ሰዳንደትካ ሎቃ ተይᎺችሶ “እታ ኮ ኤችንታ ደእንጎካ ኦይስምዳክቴ፥ ኦይስምድባብ የተቴ!” ጋይሶ ዎርሰንታ እር ይንታ አንንም ስኤርሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ዎርሰነረ ሙዳ፥ “ክታ ደእንጎካ Ꮊድን ዋጭን ዎንዘንኬ ዎንታ ይንችንከዘን ማታ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ኮትᎺይካ ጵላጦስ ባርባንም ቡልት ከትካንታ ኦይቼ፥ የሱሰም ማቼ ይ Ꮊርችሳንደታ ቡር ክት ሮከርድንግንዳ ስክስት ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ኮትᎺይካ ሮማ ፍጨንም ቆልድባብታ ዳምንባብከስ የሱሰም ፍጨንም ቆልድባብታ ጋስናር ተይ አይሰኬ፥ ዳምንባብከስመረ ሙዳ የሱሰታ ካንተንካ ሳንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ክታ አፍለንመረ ክታዘንካ ዉችሰኮ ዘይም አፍላ ቆፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ጋልም ዛዉዳግንዳ ኡርስተኮ ክታ ማተዘን ጉፍሰኬ፥ ክታ ምዝ አንንዘነረ ጉፋ የችሰኬ፥ ክታ እረረ ጉፈረረኮ “አይሁድንታ ባንችኖ! አቦ የና Ꮊስሬ!” ጋየረኮ ክታዘን Ꮊልተርሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ከታ ይንታ ፈጭምንመረ ክታዘን ፈጭምሰኬ፥ ጉፈንመረ ክታዘንካ ተይሰኮ ክታ ዱረንም ካርንካ ካርንካ ጉጵድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ክታዘነረ ከታ ይ Ꮊልተርሳን ቡር ዘይም አፍለንም ዉችሰኮ ክታ አፍለን ማስት ቆፍሰኬ፥ ክትም ሮክካንተረ የድሶ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ሮማ ፍጨንም ቆልድባብታ ጋስናርንካ ከት ዉታዶቅድንካ ስምኦን ጋይምድባብ ቀረና ፍጫ ኤችንም Ꮊፍሰኮ የሱሰታ ማዝቀልን ክት ሶልማክናና ባልድንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ኮታ ቡር ኮታ ቡልና፥ “ራስቅል” ማቻን ጎልጎታ ጋይምድን ካርዘን የልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ኮታረረ ጭስካ ክክን ቡቅምሳን ዎይን ዎጭምንም ክት ዎጭድንግንዳ የሱስካንታ እምሰኬ፥ ኖ ማቼ አፍስሶ ዎጭካንታ ዝጋክዬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","የሱሰም ከታ ይ ሮክሳንደታ ቡር ክታ አፍለን እጫ ዛቅሰኮ ካስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ኮታረረ ዶቅሰኮ ክትም ካርሰሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","“ኮና የሱስ አይሁድንከስታ ባንቼ” ጋይድን ክት ካሰስምሳንደታ ጻፍን ክታ ማተንዘንጎካ ማዝቀልንዘን ዎጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ኮት Ꮊይካ የሱሰካ ክክን ቃስተን ፋንገንከስም ዋልቀን ክታ ምዝዘን ዋልቀን ክታ ከችዘን ሮክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ክታ ላመካ ስገድባብ ኤድንከስ ክትም የከረኮ Ꮊልተርድ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“የና ሳብታ ጭል ኤሄንም ዉልእሳዮ ማከን ሰጫር የና ዎድባብ! ይና የስታ ማተንም አቅስኔ! ሳብታ ይንች የስ ማቼ ይና ማዝቀልንዘንካ የስ Ꮊንቸርኔ!” ጋየረኮ ክታዘን ኦትረካ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ኮትኮግንደካ ቀሰንከስም ገችዝድባብከስ፥ ሙሴታ ህግንም ኤስዝድባብከስኬ ጋልተንከስካ ክክን ኩን ጋየረኮ Ꮊልተርድ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“አብንከስም አቅሴ ይንታ ማተንም ማቼ አቅስካንታ ማታክዬ! ኖ እስራኤልንከስታ ባንች ይ ማቼ ይና ታ ማዝቀልንዘንካ ክት Ꮊንቸራ፥ ዎተረ ክትካ አመንተሮቴ! ");
INSERT INTO gyl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ኖ ሳብካ አመንምቴ፥ ‘እታ ሳብታ ይንችቴ’ ኖ ጋይቴ፥ ኮካንታ ሳብ ክትም ሶልምድንዳ ማቼ ይና ታ ክትም አቅሳ!” ");
INSERT INTO gyl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ኮትኮግንደረ ክትካ ክክን ሮከርስባብ ፋንገንከስ ክትም የግድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ꮊየካ ላ ሳዓታዘንካ የድሶ ሳክላ ሳዓት የለልታ ፍጫሙደንዘን ኡም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ሳክላ ሳዓት ማድንካ የሱስ፥ “ኤሎሄ! ኤሎሄ! ላማ ሰበቅታን?” ጋየሮ አንድር ኡፍስካ ፍፍሴ፥ ኮታ ቡልነረ “እስታ ሳብኖ! እስታ ሳብኖ! Ꮊረተስ እም ዛቅሳሬ?” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ኮታር ዎእሶ Ꮊቅባብ ኤድንከሳርንካ ዋልቃ ዋልቀንከስ ኮም ኤሰርሰኮ “ኮና ኤላሰም ኤላዶቅዴ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ሳነካ ከታርንካ ዋልቀና ፉታግንዳ ጩንጭት የድን ርን ጩምሳን ዎይን ዎጭምናር ዱክትዮ ጉፈታ ታጰዘን ዎድሶ ክት ዎጭድንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","አብንከስ ማቼ “ዎእከቴ ይና ኤልያስ Ꮊድሶ ክትም አቅዝድንዳ ማቼ ዎ ሰዳ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","የሱስ አናካርንካ አንድር ኡፍስካ ፍፍሶ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ኮትᎺይካ ሳብታ ጭል ኤሄንታ ስፍስንደና ፈይንካ ሶ የለልታ Ꮊእሶ ቃስተን ማቼ። ፍጨነረ ጭጬ፥ ላዝንከሰረ Ꮊእሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ዱክንከሰረ ፎችምሰኮ ደእሶ Ꮊቅባብ ሳብካንታ ፋስምሳን ኤድንከሳርንካ በድንከስ አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ዱክናርንከረ ዉትሰኮ የሱስ ደእናርንካ አምሳንደታ ቡር ሳብካንታ ፋስምሳን ካተመን የሩሳሌማር አርደደኬ፥ ኮታረረ በድ ኤድንከስካንታ Ꮊፈረሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ፖልስንከስም ገችዝድባብኬ ክትከረ ክክን የሱሰም ካርሰሮ Ꮊቅባብከስ ፍጨንታ ጭጭንምከ ማቻን ርን ሙዳ ከታ ይ ሰዳንደትካ አንድር ጳስሰኮ፥ “ዶፈን ኮና ሳብታ ይንች Ꮊቄ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ጎትካ ዶቅሰኮ ሰዳዶቅድባብ በድ ማነንከስ ኮታር Ꮊቀኬ፥ ከታ ገሊላ ፍጨናርንካ የድሶ የሱስካንታ ፍክሰረኮ ክትም ጎርስመሮ Ꮊቅባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ከተረ ዎክያርንካ መግደላ ፍጨናርንዳ ማራማ፥ ያይቆበተኬ ዮሴፈታ እንደን ማራማ ኮትኮግንደረ ዛብዶሰታ ይንችንከስታ እንደነረ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ፍጨነረ ሶይቻንደትካ የሶፍ ጋይምድባብ አርማትያስ ካተመናርንካ ዋልቃ ቆልመክንባብ ኤች ኮታር Ꮊዴ፥ ኖየረ የሱሰካ አመንድባብከሳርንካ ዋልቀነ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ኖኮና ኤችና፥ ጵላጦስደር አይስንደትከ የሱሰታ ለይስንጎካ ክደር ምክሴ፥ ጵላጦሰረ ለይስንም እምድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ኮካንታ ዮሶፈረ ክታ ለይስንም Ꮊንችሶ ክላ ዱክ አፍለንካ አክሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ላዝም ቆቅሶ ግክስምሳን Ꮊየነረ ዱከራክን ክላ ጎርናር ዱክሴ፥ ኮታዘንከረ አንድር ሰይንም ቡከልስትዮ ዱክንታ ፍልተንም ዝጭሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","መግደላ ፍጨናርንካ Ꮊዳንዳ ማራመኬ አብ ማራመረ፥ ኮት ዱክንታ የረየር ዶቅሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ዛማክን ሰጨና አይሁድንከስታ Ꮊዉስ ሰጫ ማቻንካንታ፥ ቀሰንከስም ገችዝድባብከስኬ ፈረሳውያንንከስ ዋልቃትችካ ጵላጦሰደር አይሰኮ ኩን ጋይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“የ ዎባቦ! ኖኮና ኮተርስንባብ ሰንፔካ ዶቅድዮ ‘ማከን ሰጨታ ቡር ደእናርንካ አምድቴ’ ክት ጋይሳንዳ ከልቅ ዎም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ኮካንታ ክታ ካርንካ ጎርስምድባብከስ አይሰኮ ለይስንም ከት ድብዳክንግደከ ዎርሰንካንተረ ‘ይና ኖ ደእናርንካ አምቴ’ ከት ጋይዳክንግንዳ ዱክና ማከን ሰጫ የለልታ ካርስምድንግንዳ ክትካ፥ ኩን ይያክንዳ ማቼ ቡርጎካ ዶቅድን ኮትርና እርንደትዘንካ ስግዳንዳ ማተሬ!” ");
INSERT INTO gyl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ጵላጦሰረ “ይና ካርዝድባብ ዳምንባብከስ ዶቅደኬ፥ አይሰቶ የ ኤዝድንጎግካ ካርስስከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ኮካንታ አይሰኮ ዱክንም ማይተምካ የችሰኮ ዱክንም ዳምንባብከስካ ካርስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","አይሁድንታ Ꮊዉስ ሰጨና ስገዳን ቡር ዎጋᎺይካ ዛማ ሰጭመናር መግደላ ፍጨናርንካ Ꮊዳን ማራመትኬ አብን ማራመካ ዱክንም ሰድንካንታ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ይና፥ ከት ገቅራክናና አንድር ፍጨታ ጭጭ ማቼ፥ ጮይስታ ክታይንች ጭላርንካ Ꮊንቸርሶ ዱክንዘን ዎደርሳን ሰይንንም ቡከልስሶ ዘን ዶቅሴ ");
INSERT INTO gyl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ክታይንችንተረ ባለና ዋልቅንትንግንዳ ሳግዝድ Ꮊቄ፥ አፍለነረ ክታ አዝግንዳ ጫምሳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ካርስንባብከስ ክታይችን ጳስዘንካ አምሳንዳ ጭጭካ ደእስባብግንዳ ማቸከ። ");
INSERT INTO gyl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ክታይንችና ማቼ ማነንከስም፥ “የታ ማቼ Ꮊይጳሰቴ፥ ሮከርስባብ የሱሰም የ ዝግድንደትም ኤዝድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ኖ ካሪ ካዬ ኤንገር ይ ኬዛንግንዳ አምቴ። ካሪ ካዬ፥ ክት Ꮊቃን ካርንም Ꮊድሶ ሰትከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ይና ሳነካ አይሰቶ ክታ ካርንካ ጎርስምድባብከስካንታ ‘ደእናርንካ ኖ አምቴ! ይና እርምሶ ገሊላ ፍጨናር አይዴ፥ ኮታረረ ክትም ሰተረቴ!’ ጋይሰቶ ከትካንታ ኬዝከቴ፥ ይና እታ የም ኬዝትቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ኮታዘንከረ ማነንከስ ጳስረኮ አንድር ጉርምካ ዱክናርንካ ሳነካ አይሰኬ፥ ክታ ካርንካ ጎርስምድባብከስካንተረ ኬዛካንታ ዞደረኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","የሱስ ከትም ጎግዘን Ꮊፍሶ “አቦ የታ ኡርመቶ!” ከትም ጋይሴ። ከተረ ክደር Ꮊድሰኮ ክታ ዱትን የድሰኮ ክትካንታ ጎስትሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ኮትᎺይካ የሱስ፥ “Ꮊይ ጳሰቴ! አይሰቶ ገሊላ ፍጨናር ከት አይድንግንዳ እስታ እስመንንከስካንታ ኬዝከቴ፥ እም ኦ ኮታር ሰተረኬ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ማነንከሰረ አይድንካ ዳምንባብከሳርንካ ዋልቃ ዋልቀና ካተመናር አይሰኮ ማቻን ሪይንም ሙዳ ቀሰንከስም ገችዝድባብከስካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ቀሰንከስም ገችዝድባብከስ ጋልተንከስካ ክክን ሳንምሰኮ ከታ ይ ዞርምሳንደታ ቡር ዳምንባብከስካንታ በድ ብራ እምሰኮ ኩን ከትም ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ ‘ዎ ራትሶ ዶቅድንካ ክታ ካርንካ ጎርስምድባብከስ ሶይት Ꮊድሶ ክትም ድብት አይሰኬ’ ጋይሰቶ ዎርሰንካንታ ኬዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ኮም ሪን ሮማ ፍጨንም ቆልድባብ ኤሰርሳ ማቼ ዎታ ኮ ርይን ክትካንታ ኬዝት ቡዳክታር አርችሶቶ የንታዘን ማጣ የልዳክንግንዳ ይቶሮቴ።” ");
INSERT INTO gyl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ኮካንታ ዳምንባብከስ ብረንም ተይሰኮ ገታ ከትካንታ ኬዛንግንዳ ይሰኬ፥ ኮነረ ሪይና ታካ የለልታ አይሁድንከዝደር ኬዝመሮ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ክታ ካርንካ ጎርስምድባብ ታመከ ዋልቀንከስ የሱስ ከት አይድንግንዳ ክትሳን ካርን ገሊላ ፍጨናር Ꮊፈርድን ገቸንዘን አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ክትም ሰድሰረ ክትካንታ ጎስትሰኬ፥ ዋልቃ ዋልቀንከስ ማቼ Ꮊኤርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","የሱስ ከደር Ꮊድሶ፥ “ገችታ ኤራ ሙዳ እካንታ ጭለዘነረ ፍጨዘነረ እምምቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ይና ፍጫሙደንዘን ዶቅድን ዎርሳ ሙደንደር አይከቴ፥ ሳብ ባቤንታ፥ ሳብ ይንችንተኬ አያን ጭልንታ ላምካ ከትም ስእሰረቶ እስታ ካርንካ ጎርስምድባብ ማስስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","እ የካንታ ክትሳንደትመረ ሙዳ ከት ቦድንግንዳ ከትም ኤስስከቴ! ይና፥ እተረ ፍጫሙደንታ በእንታ የለልታ ሙዳᎺይካ የንካ ክክንቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ኮና ሳብታ ይንችን የሱስ ክርስቶስታ ክላ ኬዛ እርንዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኢስያሰካ፥ “ይና የስታ ጎግን ኡርዝድባብ እካንታ ክትምስባብም የስታ እር ኦይድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ኮነረ ‘ጮይስታ ጎግን ግግስከቴ፥ ማለካ Ꮊጭከቴ’ ጋየሮ፥ ዴል ቆቸናር ጬክሳ ይይሶ ፍብድን ኤታ ኡፍስ” ጋይምሶ ጻፍምሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ኮካንታ ስእስንባብ ዮሀንስ “የንታ ጎመንታ ነገትቸን የ Ꮊፍተርንግንዳ፥ ጎማ የንታ ፍክስን ዎይስሰቶ ስኤርከቴ” ጋይንተካ ዴል ቆቸናር ጬቀሮ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ይሁዳ ሞረናርንኬ የሩሳሌም ካተመናርንካ በድ ኤድንከስ ክደር Ꮊድ Ꮊቀኬ፥ ከታ ይንታ ጎመንም ቡጨረኮ ዮርዳኖስ ሎቀናር ክታ አንያር ስኤርድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ዮሀንሰታ አፍለና ግመል ጋይምድንደታ ስጭካ ፍክስምሳንዳ Ꮊቄ፥ ይንታ ዎክጫምንመረ ሳቅካ ሶቀርድ Ꮊቄ፥ ክታ እችምነረ ኤይከንኬ ባእተታ ኩር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ኩነረ ጋይድ Ꮊቄ፥ “ክታ ጫመንታ ዞክነንደትም ይርክን ጋይስቶ ቡልካንታ ዎራ እታ ማዳክባብ እዘንካ አንድርይ ስግድባብ እስታ ቡርጎካ Ꮊዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","እታ የም ሎቀካ ስእዝድቴ፥ ኖ ማቸ አያንይ ጭልንካ የም ስስተሬ።” ");
INSERT INTO gyl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ኮታይካ የሱስ ገሊላ ሞረናር Ꮊፈርድን ናዝረት ካተመናርንካ Ꮊድሶ ዮርዳኖስ ሎቀናር ዮሀንሰታ አንናር ስኤርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ዮሀንሰረ ሳነካ የሱስ ሎቀናርንካ ዉተዳንግንዳ ጭላ ፎችምድንኬ አያን ጭልነረ ዎለታ ካምስካ ማትሶ ክታዘን Ꮊንቸርድንካ ኖ ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ኮታይካ፥ “የስካ እም ጉርምዝድባብ፥ የስም እ ሶልምድባብ እስታ ይንቸዬ” ጋይድን ኡፍስ ጭላርንካ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ሳነካ ሳብታ አያንና የሱሰም ዴል ቆቸናር ተይ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ኮትኮ ዴል ቆቸናረረ ሰጣንካ ክክን ጰጭመሮ ቃስተን ቦንዳ ሰጫ ዶቅሴ፥ ባችርከረ ክክን Ꮊቄ፥ ክታይንችንከሰረ ክትም አሌሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ዮሀንሰረ የደርሶ ዞክና ኤሄናር አርደዳንደታ ቡር የሱስ ሳብታ ክላ ኬዘንም ሳባከሮ ገሊላ ሞረናር Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ኤስዝደረ፥ “ዶፈን ሰጨና ታ Ꮊቴ፥ ሳብታ ባንችምና ና የልሳንካንታ ጎማ የንታ ፍክስን ዎይስከቴ! ክላ ከዘንከረ አመንከቴ!” ጋይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ኮታ ቡር የሱስ ገሊላ ባሀርንታ ላመካ ስገድንካ ስምኦንከ እስመን እንደራስካ ሞላ የድባብከስ ማቻን ኦል ከታ ይንታ ሞለን የድን ሳከን ባሀርናር ከት ኦይድንካ ከትም ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","የሱሰረ፥ “ኮረቴ እም ጎርስምከቴ፥ ሞለን የ የድንደትግንዳ ሙዳ ኤድንከስመረ እካንታ የ ሳንስተርንግንዳ የም ይድቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ከተረ ሳነካ ሞለን የደርድን ሳከንም ዛቅሰኮ ክትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ኮታዘንከረ ቶክም ኦስ ይ ስገዳንግንዳ፥ አብ ቃስተን እስመንምከ ካንስምከ ሰዴ፥ ከተረ ዛብዶስታ ይንች ያይቆብኬ ዮሀንሰካ Ꮊቀኬ፥ ከተረ ሎቀዘንካ ቃልዝድን ጃልበንዘን ማትሰኮ ሞለን የድን ሳከን ይንታ ኡርሰሮ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","የሱስ ሳነካ ከትም ኤልሴ፥ ከተረ ይንታ ባቤን ዛብዶሰምንከ ክታ ፍክስንባብከስካ ክክን ሎቀንዘንካ ቃልዝድን ጃልበንዘን ክትም ዛቅሰኮ የሱሰም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ኮታዘንከረ ስግሶ ቅፍራናሆም ካተመናር የልሰኬ፥ ሳነካ Ꮊድን አይሁድንከስታ Ꮊዉስ ሰጨንካ የሱስ አይሁድንከስታ ምክስ ኤሄናር አርድሶ ኤስስ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","የሱስ ሙሴታ ህግን ኤስዝድባብከስግንዳ ማታክዶቆ ገችንታ ኤረንባብከስግንዳ ኤስዝድዮ ክት Ꮊቃንጎካ ኤሰርስባብከስ ሙደና ክታ ኤስስንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ዋልቃ ዳቅል አያን ክታዘን ዶቅድባብ ከታ ምክስ ኤሄናር ዋልቃ ኤች ኩንጋየሮ ፍፍሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“ናዝረትንክባብ የሱስዮ፥ የስተኬ ዎንተካ ክክን Ꮊራ ዶቅዳ? ዎም ካይስካንተስ Ꮊዶ? የስ Ꮊይማቸረ እታ ኤዝድቴ፥ የና ሳብካንታ ፋስምስባበዬ።” ");
INSERT INTO gyl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","የሱሰረ ዳቅል አያንንም “ጫምን ጋይሰዮ ክታዘንካ ዉትካ!” ጋይሶ ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ዳቅል አያንነረ ኤችን ባልት ዛቅሶ ክትም ጭእሳንደታ ቡር አንድርይ ኡፍስካ ፍፈሮ ክታዘንካ ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","“ኮና Ꮊራ? Ꮊራግንዳ ክላ ኤስሰሬ? ዳቅል አያንንከስም ዎራ ይንታ ገችንታ ኤረንካ ክዴ፥ ከተረ ክትካንታ ክትምደኬ” ጋየረኮ ሙደና በርእካ ክክ ክክ ኦይስም የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ሳነካ፥ የሱሰታ ፍክስና ገሊላ ሞረናር ዶቅድን ፍጫ ሙደናር ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ኮታይካ የሱስ አይሁድንከስታ ምክስ ኤሄናርንካ ዉትሶ ያይቆብኬ ዮሀንሰካ ክክን ስምኦንተኬ እንደርያሰታ ኤሪ አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ኤሄንታ ዋር፥ ስምኦንታ በይስተና ዘና ሶል Ꮊዝምካ ሰቀርሶ ራትሶᎺቄ፥ ኮታ Ꮊዝርንመረ ሳነካ የሱስካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","የሱሰረ ኮደር Ꮊድሶ ኮታ አንንም የድሶ አምሴ፥ ዘና ሶልነረ ሳነካ ኮትም ዛቅሴ፥ ናየረ አምሶ ከትም ሞክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ꮊይና አርድሶ ፍጨና ሶይድንካ ኤድንከስ ሰቀርስባብከስምከ ግምዘካ የደርስባብከስም ሙዳ የሱሰደር ተይ Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ካተመናር ኤድንከስ ሙዳ ማልንዘን ሳንሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","የሱስ Ꮊክ Ꮊክ ሰቅምካ ማጠርድባብ በድ ኤድንከስም ፋችሴ፥ በድ ግምዘንከስመረ ዉችሴ፥ ግምዘንከሰረ የሱስ Ꮊይ ክት ማቸረ ኤዝድዮ ከትᎺቃንካንታ፥ የሱስ ከት ኬዝድንግንዳ ከትካንታ ጋያክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ሰጭካንታ ይድንካ፥ የሱስ ሰጭመንታ ዋር አምሶ ምክስካንታ ዋልቃ Ꮊርን ጋይሳን ካርዘን አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ስምኦንከ ክትካ ክክን Ꮊቅባብከስ ክትም ዝግመት ዉትሰኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ክትም ከታ ይ Ꮊፍሳንደትካ፥ “ኤድንከስ ሙዳ የስም ዝግደኬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","የሱሰረ፥ “እ Ꮊዳንዳ ኤስስካንታ ማቻንኦል ክላ ኬዘንም እ ኤስዝድንግንዳ አብ ዶቅድን ሞረንከሳር ዎም ሙከቴ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ኮካንታ አይሁድንከስታ ምክስ ኤሄናር ሳባከሮ ግምዘንም ዉቸሮ ገሊላ ሞረናር ሙዳ ኦንግድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ዋልቃ ጳስዝድን እጳ ሰቅምንክባብ የሱሰደር Ꮊድሶ ክታ ዱትያር ጉምፈርሶ፥ “የስ እም ሶልምዴ እም ፋችካንታ ማደዬ” ጋየሮ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","የሱሰረ ኤችንካንታ አጨርሶ ይንታ አንን ኦይትሶ ክትም Ꮊጨሮ፥ “ኡራባብ የስም ጋይትቴ፥ ኡርካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ኤችነረ ሳነካ እጳ ሰቅምናርንካ ኡርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","የሱስ ኤችንም ኡርስት ካርስምካ ጋይሶ ክትም ኦይቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ኮም ርን Ꮊየሰንካንተረ የስ ኬዝዳክንግንዳ የስታ ማታ ካርስምካ፥ ኬዛር ማቼ አይሳዮ የስታ ማተንም ቀሰንከስም ገችዝድባብደር ሰችስካ፥ ዎርሰንካንተረ ማርካ ማድንግንዳ የስታ አቅንተንጎካ ሙሳ ክትሳንደትም ካስን እምካ” ጋይሶ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ማታጋካ ዳት ኤችና ኮታርንካ ዉትሶ ኮትኮርን ሙዳ ይምሳንደትም ኤድ ሙደንካንታ ኬዛ የጄ። ኮትኮጎከረ የሱስ Ꮊምን ካተመናረረ መየካ አርድካንታ ማታክዬ። ኬዛርንካ ማቼ ካተመናርንካ ኦስ ኤድ ካየን ካርናር ዶቅድ Ꮊቄ፥ ማችንከረ ኤድንከስ Ꮊክ Ꮊክ ካርናርንካ ክደር ᎺደሮᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ቶክም ሰጨታ ቡር የሱስ ቅፍራናሆም ካተመናር ማትሶ Ꮊዴ፥ ኮታር ኤሄንታ ዋር ክታ ዶቅንተና ዎርሰንደር ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ኤሄና ማዳክንዳ ማችንካ ማልና ዎራ ኡንምተርን የለልታ በድ ኤድንከስ ሳንሰኬ፥ ሳብታ ቃለንመረ ከትካንታ ኤስዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ኮታይካ ኦይድ ኤድንከስ ዋልቃ ዎብ ኤችንም ባልሰኮ ክደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ዎርሰንታ በድምንዘንካ አምሳንዳ ኤች ዎብንም የሱሰደር ተይ Ꮊድ ከትም ጋምስንካ ኤሄንታ የለንም የሱስ ዶቅድንጎካ አምስሶ ዎብንም ክታ Ꮊቸንካ ክክን Ꮊንችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","የሱሰረ ከታ አሜንንም ሰድሶ ዎብንም “የና ይንችኖ የስታ ጎመና የስካንታ ነጋ ጋይምቴ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ኮታር ዶቅሶ Ꮊቅባብ ዋልቃ ዋልቃ ሙሴታ ህግን ኤስዝድባብከስ ከታ ይንታ ቡዳር ኩን ጋይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ኮና ኤችና ኮግንዳ የክን ሳብዘን Ꮊረተክ ከዝዳ? ዋልቃ ሳብ ክታዘንካ ጎመንም ነጋ ጋይካንታ ማድባብ Ꮊይራ?” ");
INSERT INTO gyl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ሳነካ የሱስ ኮም ከታ ቡደንታ ገቅርን ይንታ አያንካ ኤስሶ ኩን ከትም ጋይሴ፥ “Ꮊረተንት የንታ ቡደናር ኮም ገቀርዳ? ");
INSERT INTO gyl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ዎብንም፥ ‘የስታ ጎመና የስካንታ ነጋ ጋይምቴ’ ጋይንታዘንኬ፥ ‘አምሳዮ የስታ Ꮊቸንም ባልሳዮ አይካ!’ ጋይንታዘንካ Ꮊምና ኡርዳ? ");
INSERT INTO gyl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ኬዛርንካ ማቸ ኤደት ይንች ፍጨዘን ጎመንም ነጋ ጋይካንታ ገችታ ኤራ ዶቅድባብ ማትንተን የ ኤስተርንግንዳ” ጋይሶ ዎብንም፥ ");
INSERT INTO gyl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“አምካ፥ የስታ Ꮊቸን ባልስንደትከ የስታ ኤር አይካ የስም ጋይድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ዎብነረ ሳነካ አምስንደትከ ይንታ Ꮊቸንም ባልሶ ኤድንከስ ሙደና ሰድንካ ዉተዴ። ኮካንተረ ኤድንከሰረ ሙዳ በርእሰኮ ኮግንዳ ር ቦድሶ ሰት ኤዝዳኮቴ ጋየረኮ ሳብም ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","የሱሰረ አናካርንካ ኦስ ገሊላ ባሀርንታ ላማር አይሴ፥ ዎርሰነረ ሙዳ ሳንምሰኮ ክደር Ꮊድንካ ኖ ከትም ኤስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ኮትከረ ክት ስገድንካ ቃረጭን ተችዝድን ካርዘን ዶቅሶ Ꮊቅባብም እልፎሰታ ይንችን ለዊም ሰድሶ፥ “እም ጎርስምካ” ጋይሴ፥ ኖየረ አምሶ ክትም ጎርስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ኮታ ቡር የሱስ ለዊታ ኤሪ እችምካንታ ዶቅሴ፥ በድ ኤድንከሰረ ክትም ጎርስምሳንጎካ ከታርንከረ በድ ቃራጭን ተችዝድባብከስ፥ ጎመንባብከስ፥ የሱሰኬ ክታ ካርንካ ጎርስምድባብከስካ ክክን እችምንደር ዶቅተኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ፈረሳዊያንንንከስታ ኮች ማችባብ ሙሴታ ህግን ኤስንባብከስ የሱስ ቃራጭን ተችዝድባብከስኬ ጎመንባብከስካ ክክን ክት እጅድንካ ሰድሰኮ “ቃረጭን ተችዝድባብከስኬ ጎመንባብከስካ ክክን ክት እጅድንደትኬ ዎጭድንዳ Ꮊረተረ?” ጋይንተካ ክታ ካርንካ ጎርስምድባብከስም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","የሱሰረ ኮም ኤስርሶ፥ “ሰቀርስባብከስም ዳት ኡርመንከስም አክም ዝክሳዬ፥ እተረ እ Ꮊዳንደና ጭልንባብከስም ማታክናና ጎመንባብከስም ይንታ ጎመን ከት ዎይዝድንግንዳ ኤልካንቴ”፥ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ዮሀንሰታ ካርንካ ጎርስምድባብከስከ ፈረሳዊያንንከስ በቼካ ምግዝድዮ Ꮊቀኬ። ዋልቃ ዋልቃ ኤድንከስ የሱሰደር Ꮊድሰኮ፥ “ዮሀንሰተከ ፋርሳንከስታ ካርንካ ጎርስምድባብከስ በቼካ ምግዝደኬ፥ የስታ ካርንካ ጎርስምድባብከስ ማቼ በቼካ ምግዝዳክንዳ Ꮊረተሬ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","የሱሰረ “እንቸንባብና ከትካ ክክን ዶቅድንካ ካርንካ Ꮊድባብከስ በቼካ ዶቅደኮ? ኩን ካዬ! እንቸንባብ ከትካ ክክን ዶቅድንካ በቼካ ዶቅ ከትም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ኬዛር ማቼ እንቸንባብ ከታዘንካ ፋስምድን ሰጫ Ꮊዴ፥ ኮትᎺይካ በቼካ ምክስተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ገሳ አፍለንታዘን ክላ አፍላ Ꮊእስትዮ ዛግድባብ Ꮊየረ ካዬ። ኮና ይይምሳን ማቼ፥ ክላ አፍለንታ Ꮊእስምና ገሳ አፍለን ፎእዴ፥ Ꮊእምነረ እርንደትዘንካ ስግዳንዳ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ኮትኮግንደረ ዎይን ዎጭምን የድን ገሰርሳን ሱልፈንታ ዋር ኡሳክን ዎይን ዎጭምን ዎድባብ ካዬ፥ ኮና ይይምሳን ማቼ ዎይን ዎጭምና ሱልፈንም ፉእዝዴ፥ ዎይን ዎጭምነረ ዉልእምዴ፥ ሱልፈነረ መይዳክንዳ ማዴ። ኮካንታ ኡሳክን ዎይን ዎጭምንካንታ ክላ ሱልፋ ዝግዝዴ”፥ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","አይሁድንታ Ꮊዉስ ሰጨንካ የሱስ ዘርግ ትሰንታ ዎክካ አይድንካ፥ ክታ ካርንካ ጎርስምድባብከስ አይደኮ ዘርግ ትሰንም ታክስ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ፈርሳዊያንንከሰረ “ይና፥ የስታ ካርንካ ጎርስምድባብከስ አይሁድንታ Ꮊዉስ ሰጨንካ ጋይማክንደትም Ꮊረተክ ይዳ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","የሱሰረ፥ “ዳዊት ይንካ ክክን ዶቅድባብከስካ ዳቀርሳንደትᎺይኬ ማጠርሳንᎺይካ Ꮊራ ክት ይሳናነረ የታ ናበባከቴ? ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","አብያታር ቀሰንከስም ገችዝድባብ ማትሶ ክት Ꮊቃን ስለናር ኖ ዳውት ሳብታ ኤሄናር አርድሶ፥ ቄሰንከዘንካ አብንከስካንታ እችማ ጋይማክንደትም፥ ሳብካንታ ጋይሶ ፋሰርሳን ካስ እችምን እቼ፥ ክትከረ ክክን ዶቅድን ኤድንከስካንተረ እምሴ”። ");
INSERT INTO gyl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ጉጅሰረ የሱስ “አይሁድንከስታ Ꮊዉስ ሰጨና ኤድ ካንታ ፍዝምሳዳት ኤድ Ꮊዉስ ሰጨንካንታ ፍዝማክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ኮትኮግንደረ ኤድ ይንች አይሁድንታ Ꮊዉስ ሰጨንዘን ጮይስዬ”። ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","የሱስ ካርንካ አይሁድንከስታ ምክስ ኤሄናር አርደዴ፥ ኮታረረ ዋልቃ አን ዎብ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","የሱሰም ካሰስካንታ ዝግዝን ኤድንከስ፥ “ይና አይሁድንታ Ꮊዉስ ሰጨንካ ክትም ፋጅድንዳ ማቸ ዎሰዳ!” ጋይሰኮ ክትም ካርዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","የሱሰረ አን ዎብ ኤችንም፥ “ኮሬ ከታ ዎክናር Ꮊድሶ ዎእካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ኮተረ ቡር “የለቴ Ꮊዉስ ሰጨንካ ይማባብ ጋይምሳንዳ ኡርማ ይይንቶ አና ዳቅል ይይንቶ? ሰንፔም አቅስዮ አና ካይስዮ?” ጋይሶ ከትም ኦይሴ። ከታ ማቼ ጫምን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","የሱሰረ ከታ ቡደንታ ዳቅንተንጎካ ሞርእሶ ይንታ ካንተንካ ዶቅድባብከስም ዋጭ አፍካ ሰድሶ ኤችንም፥ “የስታ አንንም ፍእስካ” ክትም ጋይሴ። ኖየረ ይንታ አንንም ክት ፍእዝድንካ አንና ኡርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ሳነካ ፈረሳዊያንንከስ ዉትሰኮ Ꮊስግንዳ ይሰኮ የሱሰም ከታ ይ ካይስተርንደትም ሄረዶስታ ገቅርን ማታ ጋይድባብ ኤድንከስካ ክክን ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","የሱስ ይንታካርንካ ጎርስምድባብከስካ ክክን ካርንኮትም ዛቅሶ ገሊላ ባሃርንደር አይሴ። ገሊላ ሞረናርንካ በድ ኤድንከስ ክትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ክት ይድ Ꮊቃንደትመረ ርን ሙዳ ኤሰርሰኮ በድ ኤድንከስ ክደር ᎺድᎺቀኬ፥ ከተረ ገሊላርንካ ይሁዳርንካ፥ የሩሳሌማርንካ፥ ኤዶማርንካ፥ ዮርዳኖስ ሎቀንታ ፋማ ዶቅድን ሞረናርንካ፥ ኮትኮግንደረ ጢሮሳርንኬ ሲዶና ካተመንከሳርንካ Ꮊድባብከስ ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ዎርሰንታ በድምንዘንካ አምሳንዳ ኤድንከስ ክትም ኡንኤርዝዳክንግንዳ ሎቀዘንካ ቃልዝድን ጃልባ ግክስሰኮ ክትካንታ ከት እምድንግንዳ ይንታ ካርንካ ጎርስምድባብከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","በድ ኤድንከስም ሰቅምናርንካ ፋችሳንካንታ Ꮊዝምካ ማጠርድባብ ሙደና ከታ ይንታ አንካ ክትም ዎልካንታ ዝግሰኮ፥ ክትም ማእዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ዳቅል አያንንከሰረ ክትም ሰድሰኮ ክታ እር ዋቸረኮ፥ “የና ሳብታ ይንቸዬ!” ጋየረኮ ፍብድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","የሱስ ማቼ ይ Ꮊይናነረ ከት መያ ማሳይንግንዳ ዳቅስሶ ከትም ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","የሱስ ገቸንዘን ዉተዳንᎺይካ ከትከን ይዝግዝባብከስም ይንደር ኤልሴ፥ ከተረ ይንካ ዶቅድባብከስም ዛቅሰኮ ክደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","የሱሰካ ክክን ከት ማድንግንዳ፥ ኤስስካንተረ ከትም ኦይድንግንዳ ታሜከ ቃስተንን እድሶ “ኦይትምስባብከስ” ጋይሶ ከትም ኤልሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ግምዘንም ከት ዉጅድንግንደረ ገችታ ኤራ ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","እድምስባብከሰረ ታመከ ቃስተን ኦይትምስባብከስና ኬናከሰኬ፥ ጴጥሮስ ጋይሶ ክት ኤልስባብ ስምኦን፥ ");
INSERT INTO gyl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ቦኤናርገስ አነረ ጉግንታ ይንችንከስ ጋይሶ ክት ኤልስባብከስ፥ ዛብዶሰታ ይንችንከስ ያይቆበኬ እስመን ዮሀንሰካ፥ ");
INSERT INTO gyl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","እንደርያስ፥ ፍልጶስ፥ በርተሎመዎስ፥ ማቶስ፥ ቶማስ፥ እልፎሰታ ይንች ያይቆብ፥ ታድዮስ ይንታ ፍጨንካንታ ገቀርድባብ ስምኦን፥ ");
INSERT INTO gyl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","የሱሰም ስክስት እምስባበረ አስቆሮንት ካተመናርንክንባብ ይሁዴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ኮታ ቡር የሱስ ማት ኤሄን ኮታር አርደዴ። የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ እችም እችካንታ ዎራ ከትም ጋምተርን የለልታ አናካርንካ በድንከስ ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","“የሱስ ኤይቴ” ጋይምድንካ ኤሰርሰኮ ክታ ሱሰንከስ ክትም የድካንታ ክደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","የሩሳለማርንካ Ꮊድባብከስ ሙሴታ ህግንም ኤስዝድባብከስ፥ “ክታዘን ብኤልዘቡል ዶቅዴ! ግምዘንመረ ክት ዉጅድንዳ ግምዘን ክድባብ ብኤልዘቡልጎኬ!” ጋየረኮ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","የሱሰረ ዎርሰንም ይንደር ኤልሶ ካምስካ ኩን ጋይሴ፥ “ሰጣን ሰጣንም Ꮊስግንድክ ዉችካንታ ማዳ። ");
INSERT INTO gyl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ዋልቃ ባንችና ፋስምሰኮ ክክ ክክ ዋጭምድንዳ ማቼ ኮና ባንችና ዳቅሶ ዎእካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ኮትኮግንደረ ዋልቃ ኤሀኤድ ክክ ክክ ፋስምሴ ዳቅሶ ዎእካንታ ማታዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ኮካንታ ሰጣን ይንታ ማተንም ይ ግርደኬ ክክ ክክን ከት ፋስምሴ ካይደክ ዳት ዶቅካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ኮትኮግንደረ ዋልቃ ዎልቀክንባብ ኤችታ ኤር አርድሶ እርናና ዎልቀንክንባብ ኤችንም ዞካክዶቆ ክታ ርን ቡራካንታ ማድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ዶፈን የም ጋይድቴ፥ ኤድንከስ ከት ፍግዝድንዳ ጎመንኬ ከትየግድን የክና ሙዳ ከትካንታ ነጋ ጋይምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ኬዛር ማቼ አያን ጭልንዘን የግድባብ ሙደንዘን ስለንክንደታ ባዛ ክታዘን ማተረ ዳት ቦድሶ ክታ ጎመና ነጋ ክትካንታ ጋይምዳክዬ።” ");
INSERT INTO gyl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","የሱስ ኮም ክት ከዛንዳ፥ “ቱና አያን ክታዘን ዶቅዴ” ከት ገይሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","የሱሰታ እንደንኬ ክታ እስመንከስካ ክደር Ꮊደኬ፥ ማልጎካ ዎእሰኮ ክደር ኤድ ኦይትሰኮ ኤልስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ክታ ካንተካ ዶቅሶ Ꮊቅባብ ኤድንከስ፥ “ኮሰቼ! የስታ እንደንኬ የስታ እስመንከስ ማል ዎእሰኮ የስም ዝግደኬ” ገይሰኮ ክትም ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","የሱሰረ “ና እስታ እንደና Ꮊይራ? እስታ እስመንከስና Ꮊይከሰረ?” ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ይንታ ካንተንካ ዶቅሶ Ꮊቅባብከዝደር ሰደሮ “ኮሰቸቴ! እስታ እንደንኬ እስታ እስመንከስና ኬናከሰኬ! ");
INSERT INTO gyl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ሳብታ ጋይተን ቦድባብ ሙደና፥ ኖ እስታ እስመነረ፥ እስታ ምችነነረ፥ እስታ እንደነረ ከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","የሱስ አናካርንካ ባሀርንታ ላማር ኤስስን የጄ። አንድር በድ ኤድንከሰረ ክደር Ꮊድሰኮ ከታ ሳንንተንካ ኖ ባሀርንዘን ዶቅድን ጃልባ ገየርድንደታር አርድሶ ዶቅሴ፥ ዎርሰነረ ሙዳ ባሀርንታ ካንተዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","በድ ሪንከስመረ ካምስካ ከትም ኤስይሴ፥ ኤስዝደረ ኩን ከትም ገይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ኤሰርከቴ! ይና፥ ዎንንባብና ማሰንም ማስካንታ ዉተዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ክት ማዝድንካ ዋልቃ ዋልቃ ማሰና ጎግንታ ካንተዘን ዋቼ፥ አፍትንከሰረ Ꮊድሶ እቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","አብ ማሰና በድ ፍጫ ካየን ቦምቸዘን ዋቼ፥ ፍጫ ኮታዘን ካየን ኦላር ሳነካ ባቀልሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ማታጋካ ዳት Ꮊይና ዉተዳንደትካ ሱልሴ፥ በድ ጫጨረ ካየንካንታ ዎቼ። ");
INSERT INTO gyl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","አብ ማሰነረ ኡክምታ ግድያር ዋቼ፥ ኡክምነረ ጋጵሳንደትካ ጉንሳን ካንታ አፍ ኡስክሳ ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","አብ ማሰና ኡርማ ፍጨዘን ዋችሶ ባቀልሴ፥ ባቅለነረ ጋጵሶ አፍ ኡሴ፥ ዋልቀና ቦንደከ ታማ፥ ዋልቀና ማከን ቦንዳ፥ አብነረ ዶንቅ ቦንዳ አፍ ኡሴ።” ");
INSERT INTO gyl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ጉጅሰረ የሱስ፥ “ኤሰርድን ቃም ዶቅድባብ ኤሰራ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","የሱስ ይንት ክት ማቻን Ꮊይካ ክትም ጎርስምድ Ꮊቃን ኤድንከስኬ ታመኬ ቃስተን ክታ ካርንካ ጎርስምድባብከስ ካምስንከስታ ቡልን ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","የሱሰረ፥ “የካንታ ሳብ ባንችምንታ አችምሳን ኤስና እምምቴ”፥ አብንከስካንታ ማቼ ሙዳ ሪን ካምስካ ከትካንታ ኬዝምዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ኮነረ ማድንዳ፥ ከታ ሳብደር ማታይንካንታ ከታ ጎመና ነጋ ጋይምዳክንግንዳ፥ ሰድን ሰደረኮ ቡዳር የዳከኬ፥ ኤስርንም ኤሰረረኮ ገቀራየኬ ጋይምሳንደት ግንዴ። ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","የሱስ፥ “የመረ ኮና ካምስና የም አርዳዮ? ኮናና፥ አብ ካምስንከስም ሙዳ Ꮊስግንደንት ኤስካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ማሰንባብና ሳብታ ቃለንም ማዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ቃለና ማስምሳንደትካ ጎግንታ ካንታር ዋቻን ማሰን ሰችዝድንዳ ቃለን ከት ኤሰርሳንᎺይካ ሳነካ ሰጣን Ꮊድሶ ከታ ቡደናር ማስምሳን ቃለን ከታዘንካ ተይምድባብ ኤድንከሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“ኮትኮግንደረ ቦምቻካርንዘን ማስምሳንዳ ኮት ሰችዝደንዳ ቃለንም ኤሰርደኮ ሳና ጉርምካ ተይድ ኤድንከስሜ፥ ");
INSERT INTO gyl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ማችንከረ ከታ ሰጫካንታ ዳት ከታ ቡደናር ጫጭ ኦይታክየ፥ ቶክም ሰጨታ ቡር ቃለንጎካ ማጣ አነረ ዳይር ከታዘን የልድንካ ሳነካ ኮተርሰኮ ዋጅደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“ኡክምንታ ዎክናር ማሰርሳንዳ ጉጅሶ ሰችዝድንዳ ቃለንም ኤሰርድባብ ኤድንከስሜ፥ ");
INSERT INTO gyl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ማታጋካ ዳት ኮ ፍጫሙደንታ ገቅርና፥ ቆልመታ ሶልመከ አብነረ ዉችኩን አግርና ከታ ቡደናር አርድሶ ቃለንም ጉንእት የድንካንታ አፍ ኡሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ኡርማ ፍጨንዘን ማሰርሳንዳ ማቼ ኮት ሰጅድንዳ ቃለንም ኤሰርሰኮ ገቀርት ተይድባብ ኤድንከስሜ። ኮግንደና ዋልቀና ቦንደከ ታማ፥ ዋልቀና ማከን ቦንዳ፥ ዋልቀነረ ዶንቅ ቦንዳ አፍ ኡዝዴ”። ");
INSERT INTO gyl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","የሱሰረ “ኤድ ዞጰን ዞጵስትዮ ዳሀ ባኬንታ ዋር ናንከረ አነረ ሰለንታ ጎያር ዎዶ? ከት ዎድንዳ፥ ሳክመና Ꮊፈርድንግንዳ ዞጰን ዎደርድንካርዘን ካዮ? ");
INSERT INTO gyl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ኮትኮግንደረ አችምሳንዳ መያማትክሳ፥ አጥምሳንደረ ኤስማክዶቆ ነጋዬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ይና ኤሰርድን ቃም ዶቅድባብ ኤሰራ!” ኩንጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ኮታዘንከረ የሱስ “የ ኤሰርድን ሪይንካንታ ካርስምከቴ! የ ማግድን ርንካ የካንታ ማክምተሬ፥ ኮታዘንከረ ስግዳንዳ የካንታ ጉጅምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ዶቅድባብካንታ እምምተሬ፥ ካየንባብዘንካ ማቼ ና ክታ ዶቅድንዳ ቶክምና ዎራ ክታዘንካ ተይምተሬ” ከትም ገይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ኮታዘንከረ የሱስ፥ “ሳብታ ባንችምና ፍጨዘን ማሰን ማዝድባብ ኤድም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ኤችና ሶይት ራዴ፥ ሰጬ ኖአምዴ፥ Ꮊስግንዳ ኮትናነረ ክት ኤሳክናና ባቀልዴ፥ ጋጵዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ፍጨነረ ይንታ ማታ እርምሶ ባቅለንም፥ ኮታዘንከረ ፉጥመንም ና ሰችዝዴ፥ ኮታቡረረ ፉጥመንዘን ኡሳን አፍ Ꮊፈርዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","አፍ ኡሳንግንዳ ስከርድንዳ ማቻንካንታ ኤችና ሳነካ ባጨንም ግግዝዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","የሱስ፥ “ሳብታ ባንችምን Ꮊረካ ክክኖንት የክስተራ? አና Ꮊራ ካምስንከስኮንት መያ ማስተራ? ");
INSERT INTO gyl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ኤክነንታ አፍ ማሰንም ካምዴ፥ ና ማስምደረ ፍጫዘን ዶቅድን ማሳ ሙደንዘንካ ቶክሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ይ ማስምሳንደታ ቡር ጋጵሶ ኮራ ሙደንዘንካ ና ስገዴ፥ ጭለንታ አፍትንከሰረ ኮታ ጎይናር ኤሀ ዎድሰኮ ከታዶቅንት ካንታ ማተርን የለልታ አንድርይ እክመንከስም ዉጅዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","የሱሰረ ኤድንከስ ገቀርት ተይድንጎካ፥ ከናከስም ካምድን በድ ካምስንከስካ ይንታ ቃለንም ከትካንታ ኬዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ካምስካይሰረ ከትም ኤስሳይ Ꮊቄ፥ ከት ይንት ማድንካ ማቼ ሙዳ ሪም ይንታ ካርንካ ጎርስምድባብከስካንታ ከትም አርድንግንዳ ከዝድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ኮት ሰጨናይካ ሶይት የሱስ ይንታካርንካ ጎርስምድባብከስም “ኦስ ባሀርንታ ፋማ ዎ ቃላ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ዎርሰናርንከረ ፋስምሶ ይ አርድሶ Ꮊቃን ሎቀንዘንካ ቃልዝድን ጃልበንካ የሱሰም ተይ አይሰኬ። አብ ጃልበንከሰረ የካ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ዛብዛንዳ ቡርበች ዞገና አምሶ ሎቀና ጃልበንታ ዋር ጮጭተርን የለልታ ቡርበችና ጃልበንም ዙብድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ኮትᎺይካ የሱስ፥ ጃልበንታ ዋር ቡርጎካ ቃዳ ኦልንደትም ዎድሶ ራትሶ Ꮊቄ፥ ክታ ካርንካ ጎርስምድባብከስ ክትም ንግስሰኮ “ኤስስንባቦ! ዎ ካይድንካ የስካንታ ኤስማዮ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","የሱሰረ ንግሶ ዞገንም ዋጬ፥ ባሃርንመሬ “ጫምን ጋይካ!” ጋይሴ፥ ዞገነረ ዛቅሴ፥ አንድር ስምን ጋይንታ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","የሱሰረ፥ “ኮግንዳ የ ጳዝድንዳ Ꮊራካንተረ? Ꮊስግንዶክ አሜን የንታ ካይዳራ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ከተረ አንድር ጳስሶ፥ ክክ ክክ “ይና ዞገንከ ባሀርንካ ዎራ ክትካንታ ክትምድባብ ኮና ኖ Ꮊይራ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ገሊለታ ባሀርን ቃልሶ ገርገሰኖን ሞረናር የልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","የሱስ ሎቀንዘንካ ቃልዝድን ጃልበናርንካ Ꮊንቸርሳንግንዳ ዋልቃ ቱና አያንካ የደርስባብ ኤች ሳነካ ዱክያርንካ ዉትሶ ክትካ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ኮና ኤችና ዱክያር ዶቅድ Ꮊቄ፥ Ꮊየሰነረ ሳንቸለትካ ዎራ ዞክሶ ዎድካንታ ማታከኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","በድᎺይካ ዱት ዞከርድን ስብልኬ አን ዞከርድን ሳንቸለትካ ኖ ዞከርምድ Ꮊቄ፥ ኬዛር ማቼ ሳንችለትን ታክሰርንደትኬ ዱትንታ ስብልነረ ቁንጨሮ ይንዘንካ Ꮊልእዝድ Ꮊቄ፥ ኮካንታ ክትም የድሶ ዎይስካንታ ማድባብ Ꮊየሰነረ ካያ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ሙዳᎺይከረ ሶይትኬ Ꮊየካ ነጋክ ዶቆ ዱክ ካራርከ ገቸንከዘን ኦንገሮ ፍብድ Ꮊቄ፥ ይንታ ዘነንመረ ሰይንካ ተቸሮ ድደርዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ኖየረ የሱሰም ጎትካ ይ ሰጃን ግንዳ ክደር ዞደካ Ꮊድሶ ይንታ ቡቀንካ ጉምፈርሶ ጎስትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","አንድር ኡፍስከረ ፍፈሮ፥ “የና ሙደንዘንካ ስግ ሳብንታ ይንች የሱስዮ! የስታ እንካ ክክን Ꮊራ ዶቅዳ? ሳብታ ላምካ የስም ምግዝድቴ፥ ዋደ እም Ꮊይማእሴ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ኮመረ ክት ጋይሳን ጎግና፥ “የና ቱና አያንና ኮ ኤችንዘንካ ዉትካ!” ጋይሶ ክትም ክትሳንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","የሱሰረ “የስታ ላምና Ꮊይራ?” ጋይሶ ክትም ኦይሴ፥ ኖየረ “በድንከስ ዎማቻንካንታ እስታ ላምና ለጎኔ” ጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ፍጨን ኮታርከረ ከትም ዳይዳክንግንዳ ዳቅስሶ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ካርንኮታረረ ደንንከስታ ካንተካ በድ ጉድምንከስታ ዉዳ ግስምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ኮካንታ “ዋደ አይሶቶ ጉድምንከሳር ዎ አርድንግንዳ ዎም ጋይካ” ጋይሰኮ ክትም ምክሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","የሱሰረ ከትም አይከቴ ጋይሴ፥ ቱና አያንንከሰረ ኤችን ክታዘንካ ዉትሰኮ ጉድምንከሳር አርደደኬ፥ ዉደናር Ꮊቅባብከስ ቃስተን ሳአ ማድባብ ጉድምንከስ ዎረንዘንካ ታድምካ Ꮊንቸርሰኮ ባሀርናር ኤቅዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ጉድምን ግዝድባብከስ አጥምሰኮ አይሰኬ፥ ካተመናርንኬ ካተማ ካየንካርያር ኬዘኬ፥ ኤድንከሰረ ማቻን ርን ሰድንካንታ ዋልቃ ዋልቀና ይንታ ኤርንካ ዉተደኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","የሱሰደር Ꮊድሰኮ ኖኮና ቱና አያንንካ የደርሶ Ꮊቅባብ ኤችንታ ቡዳ Ꮊድንካ፥ አፍላ ቆበርሶ፥ ዶቅሶ ክት ዶቅድንካ ከታ ሰድሰኮ ገቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ኮመረ እርምሶ ሰድባብ ኤድንከስ ቱና አያንካ የደርስባብ ኤችንኬ ጉድምንከዘን ይይምሳንደትም ሙዳ ከትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ኮታይካ ፍጨን ኮታር ኤድንከስ የሱስ ከታ ፍጨናርንካ ዉትሶ ክት አይድንግንዳ ከታ ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","የሱስ ሎቀንዘንካ ቃልዝድን ጃልበናር ክት አርዳዶቅድንካ ግምዘንካ የደርስባብ ኤችና “ዋደ እ የስታ ካርንካ ጎርስማ!” ጋይሶ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","የሱስ ማቼ ይንታካርንካ ጎርስምድንግንዳ ክትም ጋያክዬ፥ ኬዛር ማቼ፥ “የስታ ኤሪ አይሳዮ ጮይስ Ꮊራከካ አንድር ሪ የስካንታ ይሳንደትምከ Ꮊስግንዳ የስም አጨርሳናንከረ የስታ ኤድንከስካንታ ኬዝካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ኤችነረ የሱስ ክትካንታ ይሳን ሪን “ታማ ካተመንከስ” ገይምድን ሞረንከሳር ኬዛ የጄ፥ ኤሰርስባብከሰረ ሙደና በርእድዮᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","የሱስ ሎቀንዘንካ ቃልዝድን ጃልበንካ ባሀርንታ ፋማ አናካርንካ ክት ማቻንደትካ በድ ኤድንከስ ክደር ሳንምሰኬ፥ ኮታይካ ኖ ባሀርንታ ላማር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ኮታረረ አይሁድንታ ምክስ ኤሄንታ ገችንባብከሳርንካ ዋልቃባብ Ꮊቄ፥ እያእሮስ ጋይምስባብ ኤች የሱሰም ይ ሰጃንደትካ ክታ ዱትንዘን ዋችሶ ");
INSERT INTO gyl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“ይንቸን እስታ መረና ደእካንታ የልሶ ዶቅድንኦል፥ ኮት ፋጭተርንግንደከ ሰንፔካ ኮት ዶቅተርንግንዳ ዋደ Ꮊድሰዮ የስታ አንን ኮታዘን ዎድካ!” ጋየሮ ዳቅስሶ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","የሱሰረ ክትካ የካ አይሴ፥ በድ ኤድንከሰረ ክትም ጎርስምሰኮ ክታ ካንተንካ ኡንምሰሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ታመከ ቃስተን ስላ ማቀስ ዉልእምድንካ ማጠርድንዳ ዋልቃ ኤተን ዋር Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ዋልቃ አክምደርንካ አብ አክምንደር ና አየሮ በድ ማጥርስንደትኬ ይንታ ብረንመረ ሙዳ በይስታ Ꮊቄ። ኬዛር ማቼ እንድንካ ኮታዘን ጉጅመሮ አይሳዳት Ꮊረነረ ኮትካንታ ኡራክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ናየረ የሱሰታ ይተንጎካ ኤሰርሳንካንታ ጉትምድን ዎርሰንታ ዎክናር ክታ ቡርጎካ ና Ꮊድሶ ክታ አፍለን ዎልሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ኮመረ ኮት ይሳንዳ፥ “ክታ አፍለን ዎራ እ ዎልሳናና አቅድቴ” ጋይድን አሜንካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ዉልእምድንዳ ኮታ ማቀስነረ ሳነካ ዎእሴ፥ Ꮊዝምናርንከረ ኮታ አቅንተና ኮታ ዘነንዘን ኤስምሴ ");
INSERT INTO gyl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","የሱሰረ ሳነካ ይንዘንካ ዎልቃ ዉተዳንደትም ኤስሶ፥ ዎርሰንደር ዋልንጋይሶ “አፍለን እስታ ዎልስባብ Ꮊይራ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ክታ ካርንካ ጎርስምድባብከሰረ፥ “ዎርሰና ጉትመረኮ የስም ከት ጎርስምድንካ ሰደረዮ፥ ‘Ꮊይራ እም ዎልስባብ?’ ጋይተራ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","የሱሰረ ኮም ይስባብ Ꮊይናነረ ሰድንካንታ ዋልንጋይሶ ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ኤተና ማቼ ይንዘን ይይምሳን ኤስንተካ ጳስካ ጭጨሮ ክታ እሪ ና ዋችሶ ዶፈንን ሙዳ ክትካንታ ና ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","የሱሰረ “እስታ ይንቸኖ፥ የስታ አሜንና የስም አቅስቴ፥ ኡርመካ አይካ፥ የስታ ማጥርናርንከረ ኡክንካ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","የሱስ አክኮም ኬዘዘን ክት ዶቅድንካ፥ አይሁድንታ ምክስ ኤሄንም ገችዝድባብታ ኤርንካ Ꮊድባብ ኤድንከስ ምክስ ኤሄንም ገችዝድባብም፥ “የስታ ይንቸና ደእቴ፥ ይና Ꮊራካንተስ ኤስስንባብም ጋብዝዳ?” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","የሱስ ማቼ ኮም ኤሰርሶ አይሁድንታ ምክስ ኤሄንታ ገችንባብም፥ “አሜንካ ዳት Ꮊይ ጳሴ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","የሱስ ጴጥሮሰኬ ያይቆብካ፥ ያይቆብተረ እስመን ዮሀንሰዘንካ አብ፥ Ꮊየሰነረ ይም ጎርስምድንግንዳ ጋያክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","አይሁድንታ ምክስ ኤሄንታ ገችንባብታ ኤር ከት የልሳንደትካ የሱስ ኤድንከስ ቃየረኮ ኤብድንካ፥ ከት ፍብድንከረ ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ኤሄናረረ አርድሶ፥ “ኮና ሙዳ አዉልንኬ ኤፍንካ Ꮊረተረ? ይንቸና ራታ ዳት ና ደአክዬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ኤድንከሰረ Ꮊልተርካ ክታዘን ይንጨኬ፥ የሱስ ማቼ ሙደንመረ ኤሄናርንካ ዉችሴ፥ ይንቸንንታ ባቤንም እንደንምኬ ክትከረ ክክን Ꮊቅባብከስም ጎርስሶ፥ ይንቸንና ዶቅድን ካርናር አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ኮታዘንከረ ይንቸንንታ አንን የድሶ፥ “ጣልቶ ዎእካ!” ኮትም ጋይሴ፥ ኮታ ቡልነረ “የና ይንቸኖ አምካ የስም ጋይድቴ” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ይንቼነረ ታመኬ ቃስቴን ስለታ ይንች ና Ꮊቄ፥ ሳነካ አምትዮ ኦስከ ፈንካ ኦንጋ የጄ፥ ኮነረ ማቻንደትካ ኤድንከስ አንድር በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","የሱስ ማቼ ኮም ርን Ꮊየነረ ኤዝዳክንግንዳ ከትም ዳቅስሶ ክትስንደትከ “ኮት እጅድንደትም እምከቴ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","የሱስ ኮታርንካ ዉትሶ ይንታ ፍጨናር Ꮊዴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ክትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","አይሁድንታ Ꮊዉስ ሰጨንካ ከታ ምክስ ኤሄናር ኤስስ የጄ፥ በድ ኤድንከስ ኮታር Ꮊፈርሰኮ ክደር ኤሰርድ Ꮊቀኬ፥ ከተረ “ኮና ኤችና ኮም ሙዳ ርን Ꮊምንክክ Ꮊፍሳሬ? Ꮊስግንዳ ኤጫ ክትካንታ እምምሳረ? ከትከነም አተን ክት ይድንዳ Ꮊስግንደረ?” ጋየረኮ በርእድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ኮታዘንከረ “የለተ ኖኮና Ꮊቀን Ꮊዝድባብ ማራመታ ይንች ካዮ? ያይቆበታ፥ ዮሰታ ይሁደተኬ ስምኦነታ እስመና ካዮ? ክታ ምችነንከሰረ ኬና ዎንካ ክክን ካየኮ?” ጋየረኮ ክትም ቶቸካ ኤሰርክሳ ነገደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","የሱስ ማቼ፥ “ሳብዘንካ ኤስርሶ ኬዝድባብ አብንከዝደር ቦንችምዴ፥ ይንታ ገታ ፍጨንዘን፥ ይንታ ሱሰንከዝደርኬ ይንታ ኤሀ ኤድንከዝደር ማቼ ቶችምዴ” ጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ኮታረረ ቶክም Ꮊዝምባብከዘን ይንታ አንን ዎድሶ ፋችዘንካ አብ አተን ፍክሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ዎርሰና አሜንክሳ ከታ ነግንካ አንድር በርእሴ፥ ኮተረ ቡር የሱስ ሞረንከሳር ኦንገሮ ኤስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ታሜከ ቃስተንከስም ይንደር ኤልሶ ቃስተን ቃስተን ማስሶ ከትም ኦይቼ፥ ዳቅል አያንንከዘነረ ዎልቃ ከትም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ኬታ ጎግታ ጉፈዘንካ አብ ሶለረ ማታ ቦርሳ፥ ብረረ ይንታ ክስናር ከት የዳክንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","“የንታ ዱትናር ጫማ አርችከቴ ዳት ቃስተን ሳምዝ Ꮊይ ቆበረተ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ꮊምንካርዘነረ ዋልቃ ኤታ ኤሪ አርደቶ፥ ካርንኮትም የ ዛቅተርን የለልታ ኮታር ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ኤድንከስ የም ሞግዳክንካርያርከ የም ኤሰርዳክን ካርዘን ሙዳ የንታ ዱትንታ ቡልንም ድንግስሰቶ ኮታርንካ ዉትሰቶ አይከቴ፥ ኮነረ ከትካንታ ኤግዝምስታ ማርካ ከታዘን ማተረ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ኦይትምስባብከሰረ ኮታርካ ዉትሰኮ፥ ኤድንከስ ሙዳ ጎማ ይንታ ፍክስን ከት ዎይዝድንግንዳ ኤስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","በድ ግምዘንከስመረ ዉችሰኬ፥ በድ ኤድንከስመረ ዛይት ሳየረኮ ፋችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","የሱሰታ ላምና ሙደንደር ኤስምሳን ኦል፥ ባንችና ሄረዶስ ክትጎካ ኤሰርሴ። ዋልቃ ዋልቃ ኤድንከስ፥ “ስእስንባብ ዮሀንስ ደእያርንካ አምቴ፥ ኮካንታ ኮና ሙዳ አተና ክትካ ይይምዴ” ጋየሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","አብንከሰረ “ኤላሴ” ጋይሰኬ። ነገድባብከሰረ ጉጅሶ “ኤና እሪ ሳብዘንካ ኤሰርሶ ኬዛቅባብከሳርንካ ዋልቀንግንዴ” ጋይደኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ሄረዶስ ማቼ ኮም ሙዳ ኤሰርሶ፥ “ኮና እ ክታ ባርን ተችስባብ ዮሀንሴ፥ ኮናና! ኖ ደእያርንካ አምሴ”፥ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ኮነረ ሄረዶስ ይንታ እስመን ፍልጶሰታ ኬነን ሄሮድያደም እንቸንካ ዮሀንሰም ኮትጎካ የችሶ ዞክና ኤሀር ዞክስሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ዮሀንሰረ ክት ዞከርሳንዳ፥ ሄረዶሰም “የስታ እስመንታ ኬነንም የስታ እንቸና ዝግዝድንዳ ካዬ!” ጋይድ Ꮊቃንኦሌ። ");
INSERT INTO gyl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ሄሮድያደረ ኮካ ይምኤርሶ ዮሀንሰም ደይስስካንታ ዝግድ Ꮊቄ፥ ኬዛር ማቼ ኮትካንታ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ሄረዶስ እርምሶ ዮሀንስ ጭልምስባብከ ሳብካንታ ፋስምስባብ ማትንተን ይ ኤዝድንኦል ክትም ጳሰሮ ካርዝድ Ꮊቄ። ሄረዶስ ዮሀንሰታ ኬዘንም ይ ኤሰርሳንᎺይካ ሙዳ ኦይምድ Ꮊቄ፥ ማታጋካ ዳት ጉርምካ ክትም ኤሰርድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ሄረዶስ ይ አጠርሳን ሰጨን ቦንቻካንታ ባንችንታ ገችታ ኤረንባብከስካንታ፥ ዳምንባብከስታዘን ዶርምስባብከስካንተኬ ዋልቃ ዋልቃ ኤስምስባብ ገሊላር ዶቅድን ኤድንከስም ሞካካንታ ግክሴ፥ ኮነረ ሄሮድያዳ ክትም Ꮊፍካንታ ኡርማ ሰጫ ኮትካንታ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ኮካንተረ ሄሮድያደታ ይንቸና ሞከርድን ኤሄናር አርድሶ ኮት ይግድንካ ሄረዶሰምንኬ ክትካ ክክን እችምንዘን ዶቅድባብከስም ና ጉርምሴ። ባንችነረ ይንቸን፥ “የስ ዝግድን Ꮊምንመረ ሙዳ እም ኦይስካ፥ እታ የስካንታ እምትቴ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","“እስታ ባንችምንተረ የከንም ዎራ ማቼ፥ እም የስ ኦይዝድንደትም ሙዳ የስካንታ እምድቴ!” ጋየሮ ኮትካንታ ጫቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ናየረ ይንታ እንደንደር አይሶ፥ “Ꮊርስ ክትም ኦይስቴ?” ኮደር ጋይሴ፥ እንደነረ “ስእስንባብ ዮሀንሰታ ቃደን እምካ፥ ጋይሰዮ ክትም ኦይስካ”፥ ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ይንቸነረ ሳና ጭጭመትካ ባንችንደር ማትሶ፥ “ስእስንባብ ዮሀንሰታ ቃደን ጋበትታ ዋር ታ እካንታ እምምድንግንዳ ዝግድቴ” ጋየሮ ና ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ባንችና ኮ ጋይተንካ አንድር ሞርእሴ፥ ማታጋካ ዳት እችምዘን ዶቅስባብከስታ እር ይ አርደዳን ጫቀንታ ኮት ኦይሳንደትም ማርካንታ ዝጋክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ኮካንታ ባንችና ሳነካ ዋልቀን ካርስንባብ ፖልስን ዮሀንሰታ ቃደን ተችትዮ ተይ Ꮊድንግንዳ ኦይቼ፥ ፖልስነረ ዞክና ኤሄናር አይሶ ዮሀንሰታ ቃደን ተቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ተችምሳን ቃደንመረ ጋበትታ ዋር ተይᎺድሶ ይንቸንንካንታ እምሴ፥ ይንቸነረ ይንታ እንደንካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ዮሀንሰታ ካርንካ ጎርስምድባብከስ ኮም ከታ ኤሰርሳንᎺይካ Ꮊድሰኮ ለይስንም ተይ አይሰኮ ዱክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ኦይትምስባብከስ ከታ ይ ክትምሳን ካርናርንካ ማት Ꮊድሰኮ የሱሰታ እር ሳንምሰኬ፥ ከታ ይ ይሳንደትምከ ኤስሳንደትም ሙዳ ክትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","የሱሰረ “የታ የንት ዋልቃ Ꮊርን ጋይሳን ካርዘን አይሰቶ ቶክም Ꮊዉስከቴ”፥ ከትም ጋይሴ፥ ኮመረ ክት ጋይሳንዳ Ꮊረታ ጋይሴ ከደር Ꮊድባብከስከ አይድባብ በድንከስ ማቻንካንታ እችምካንታ ዎራ ሳዓት ከትካንታ ካየንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ኮካንታ ይንት ከታ ዶቅካንታ ሎቀንዘንካ ቃለርድን ጃልበናር አርድሰኮ ዋልቃ Ꮊርን ጋይሳን ካርያር፥ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ማታጋካ ዳት ከት አይድንካ በድ ኤድንከስ ሰድሰኮ ከትም ኤሰኬ፥ Ꮊክ Ꮊክ ካተመንከሳርንከረ ዉትሰኮ ዱትካ ዞደረኮ ከትም እርምሰኮ ከደር ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","የሱስ ሎቀንዘንካ ቃልዝድን ጃልበናርንካ Ꮊንቸርድዮ በድ ኤድንከስም ኖ ሰጄ፥ ግስመንባብ ከታ ካየን ቆልግንዳ ከታ ማትንተንከረ ከትካንታ ሞርእሴ፥ በድ ሪመረ ከትም ኤስስ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ሰጨና ሶይተሮ አይድንካንታ ክታካርንካ ጎርስምድባብከስ ክደር Ꮊድሰኮ ኩን ጋይሰኬ፥ “ኮና ካርና ኤድ ካየንካርዬ፥ ሰጨነረ ሶይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ከት እጅድንዳ ካየንካንታ ሞረናር ዶቅድን ካተመን ካየንከሳርኬ የለንከሳር አይሰኮ እችም ከት ሰንድንግንዳ ኬና ኤድንከስም ኦይትካ” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","የሱስ ማቼ፥ “ከት እጅድንደትም የታ እምከቴ” ጋየሮ ማስሴ። ከተረ “ይና፥ አይሶቶ ከት እጅድንደትም ቃስተን ጸታ ብራ ጣገረካ ሰንት እምተሮቶ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","የሱሰረ “መም ሶላ የንደር ዶቅዳ? ይና አይሰቶ የ ሰድኔ”፥ ከትም ጋይሴ፥ ከተረ ሰድሰኮ “ዶንቅ ሶለኬ ቃስተን ሞለካ ዶቅዴ”፥ ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","የሱሰረ ዎርሰንም Ꮊክ Ꮊክ ፋስሶ፥ ጮልሳን ድረዘን ከትም ዶቅዝድን ግንዳ ይንታ ካርንካ ጎርስምድባብከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ኮካንታ ዎርሰና ባንግና ጸታ አና ባንግና ቃስተን ቦንደከ ታማ ማትሰኮ Ꮊክ Ꮊክ ፋስምሰኮ ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","የሱሰረ ዶንቅ ሶለንምከ ቃስተን ሞለን የድሶ፥ ፈስ ጭላር ሰድሶ ጋለቼ፥ ሶለንም አስትዮ ኤድንከስካንታ ከት የልዝድንግንዳ ይንታ ካርንካ ጎርስምድባብከስካንታ እምሴ። ኮትኮግንደረ ቃስተን ሞለን ሙደንካንታ የልስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ሙደነረ እችሶ ምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ክታ ካርንካ ጎርስምድባብከሰረ ስጣንደትም ዶከን ታመከ ቃስተን ጋበትካ ጮጭ ሳንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ሶለንም እችባብ አⷝነንከስታ ፋይደና ዶንቅ ሳአ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","የሱስ ሳነካ ዎርሰንም ኦይተሮ ክት ዶቅድንካ ክታ ካርንካ ጎርስምድባብከስ ሎቀንዘንካ ቃልዝድን ጃልበንካ ኦስ ፋማ በቴሳይዳ ካተመናር ቃልሰኮ ከት እር አይድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ኮታ ቡር ከታዘንካ ፋስምሶ ምክስካንታ ገቸንዘን ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ፍጨና ሶይድንካ ሎቀንዘንካ ቃልዝድን ጃልበና ባሀርንታ ግድያር ዶቅድንካ የሱስ ማቼ ይንት ፍጫዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ክታ ካርንካ ጎርስምድባብከስ ከታዘን ዞግድን ዞገንጎካ በይካንታ ማጠርድንካ ከትም ሰጄ፥ ሶይትናርንከረ ሳክላ ሳኣትዘንካ የድሶ ታመከ ቃስቴን ሳዓት ዶቅድንደታር ባሀርንዘንካ ሙከሮ ከደር Ꮊዴ፥ ከትም ስግሰረ አይዳ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ኬዛር ማቼ ከታ ባሀርንዘንካ ሙከሮ ክት አይድንካ ሰድሰኮ ቡንከም ካምስንካ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ሙደነረ ክትም ሰዳንደትካ ገቅሰኬ። የሱስ ማቼ ሳነካ፥ “ዳእከቴ! እትቴ! Ꮊይጳሰቴ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ኮታዘንከረ ሎቀንዘንካ ቃልዝድን ጃልበናረረ አርድሶ፥ ከትካ ክክን ክት ማቻንደትካ ዞገና ዎእሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ አንድር በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ይና፥ ከታ ቡደና ገቀርክሳ ነግድንካ ሶለንታ አተንም ገቀርት ተይክሳ ነግሰኮ ዳት ኮና ርና ከትም በርእስስተራክ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ባሀርን ቃልሰኮ፥ ገንሰረጥ ካተመናር የልሰኬ፥ ጃልበንም ባሀርንታ ካንተዘን ዉችሰኮ ዞክሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ጃልበናርንካ ከታ ይ Ꮊንቸርሳንግንዳ ሳነካ ኤድንከስ የሱሰም ኤሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ከተረ ፍጨንኮታር ዞደረኮ የሱስ ዶቅድን ካርናር ሙዳ ሰቅምንባብከስም Ꮊቸካ ባልትዮ ተይ Ꮊድ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ክት አይሳን ካርሙደናር ሞረናርንካ፥ ካተመናርንካ፥ ካተማ ካየናርንከረ ሰቀርስባብከስም መለንዘን ተይ Ꮊደረኮ ክታ እሪ ዎድᎺቀኬ፥ ክታ አፍለንታ ካንተንም ዎራ ከት ዎልድንግንዳ ክትም ምግዝድ Ꮊቀኬ፥ ክትም ዎልስባበረ ሙደና ፋጭድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ፈረሳዊያንንከስ የሩሳሌማርንካ Ꮊድባብከስ ዋልቃ ዋልቃ ሙሴታ ህግንም ኤስዝድባብከስ የሱሰደር Ꮊድሰኮ ክታ ካንተንካ ሳንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","የሱሰታ ካርንካ ጎርስምድባብከሳርንካ ዋልቃ ዋልቀንከስ አርናክን ገይንት ስኤራክን አንካ ሶላ ከት እጅድንካ ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ፈረሳዊያንንከስከ ነግድን አይሁድንከስ ጋልተንከስታ ዎገንም ካርሰካ ከታ ይንታ አንንም ዎገንግንዳ ስኤራክንዳ ማቼ እቻየኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ኮግንደረ ጋበንካ Ꮊድሰኮ ስኤራከክ ዶቆ እቻየኬ፥ ሶርቀን፥ ዳሄን፥ ጋይካ ኡርሰርሳንደትምኬ ሰለንም፥ ስኤርድንደትግንዳ፥ አበረ በድ ዎግን ካርዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ኮካንታ ፈረሳዊያንንከስ ሙሴታ ህግንም ኤስዝድባብከስኬ “የስታ ካርንካ ጎርስምድባብከስ ጋልተንከስታ ዎገንም ግርንተካ፥ Ꮊረተክ ከታ ይንታ አን ስኤራክዶቆ ሶለንም እጅዳ?” ጋየረኮ የሱሰም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","የሱሰረ “የታ ኦትረንባብከሶ!” ኢስያስ ቤርድዮ የጎካ፥ ኮና ዎርሰና ይንታ አፈካ Ꮊክ እምቦንጅደክ ዳት ቡደና እዘንካ ጎተርሳንዴ! ");
INSERT INTO gyl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","“ኤድ ፍክሳን ዎገን ሳብታ ዎገንግንዳ ማስሰኮ ኤሰረኮ ዉችኩን እም ጎይንደኬ! ጋይሶ ክት ኬዛን ቤርና ዶፈኔ፥ ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ኮካንታ የታ ሳብታ ክተን ዛቅሰቶ ኤታ ዎገንም ካርዝደቴ”። ");
INSERT INTO gyl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ኮታዘንከረ የሱስ፥ “የንታ ዎገንም ካርስካንታ ገየረቶ ሳብታ ክተንም ዛቅደቴ፥ ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ሙሳ፥ ‘የስታ ባበንምከ እንደንም ቦንችካ፥ ጉጅሰረ ይንታ ባበንዘን አነረ እንደንዘን ዳቅልን ኬዝድባብ Ꮊየነረ ደእ ክትም ዝግዝዴ’ ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","የታ ማቼ ኩን ጋይደቴ፥ ‘ዋልቃ ኤድ ይንታ ባበንካንታ አነረ ይንታ እንደንካንታ አላ ዝግዝድንካ ይ ክትም ዝግዝድንደትም ሪን ሙዳ ሳብካንታ እ እምሳንዳ እሜ’ የንደር ጋይዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ይንታ ባቤንምኬ ይንታ እንደንም አሌዘንካ ዉች ክትም ነግዝደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ኮግንዳ ይተንከረ የንታ ዎገን ካርስካንታ የ ጋይድንካ ሳብታ ቃለንም ነግዝደቴ፥ ኮትኮግንደረ ኮም ካምድንደትም በድ ሪ ይደቴ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ካርንካ ዎርሰንመረ የሱስ ይንደር ኤልሶ፥ “የታ ሙደና እም ኤሰርከቴ፥ ገቀርከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ኤድም ቱናማዝድንዳ፥ ኤታ ዋርንካ ዉድንዳ ዳት ማልንካ ኤታ ዋር አርድንዳ ቱናማዝዳክዬ! ");
INSERT INTO gyl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ይና ኤሰርድን ቃም ዶቅድባብ ኤሰራ!” ኩን ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","የሱስ ዎርሰንም ዛቅሶ ኤሄናር ክት አርደዳንደታ ቡር ክታ ካርንካ ጎርስምድባብከስ ካምስንከስጎካ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","የሱሰረ ከደር፥ “የተረ ጉጅሶ ኮም ገቀራየቴ? ኤድ እችሶ ይንታ ዋር ኤቅዝድንዳ Ꮊረሰነረ ኤድም ቱና ማዝዳክንደትም የም አርዳዮ? ");
INSERT INTO gyl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ልጳርጎካ ስግሶ ማል ዉዳ ዳት ቡዳር ዶቃዬ” ኩንጋየሮ ማስሴ። ኮከረ የሱስ እችም ሙደና ኡርማ ማትንተን ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ኮታዘንከረ፥ “ኤድም ቱና ማስዝድንዳ ኤታ ቡዳርንካ ዉድን ርንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ከተረ፥ ዳቅል ገቅር፥ ዞምባ፥ ድቢይ፥ ኤድም ደይሳ፥ ");
INSERT INTO gyl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ቤልም፥ ጭጭ፥ ዳቅል፥ ገስ፥ አይተር ማት፥ ጩባ፥ የክ፥ ኦትራ፥ ቦስ፥ ከናከሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ኬና ሙደና ዳቅል ርና ኤታ ቡዳርንካ ዉደኬ፥ ኤድመረ ቱናማዝዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","የሱስ ኮታርንካ አምሶ ትያጥሮስ ካተመንታ ላማር ዶቅድን ሞረናር አይሴ፥ ዋልቃ ኤሀር አርድሶ ዋር ዶቅንትን Ꮊየስነረ ኤሳይንግንዳ ዝግዜ፥ ማታጋካ ዳት ዋር ክታ ዶቅንተና አችምካንታ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ኮታ ይንቸና ዳቅል አያንካ የደርምሳንዳ ዋልቃ ኤተን የሱስጎካ ኤሰርሶ ሳነካ Ꮊዳንግንዳ ክታ ዱትንዘን ና ዋቼ። ");
INSERT INTO gyl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ኤተነረ ስሮፍንቃውያንንከስታ ኮች ማቻንዳ ግርክ ፍጫ ኤተን Ꮊቄ። ናየረ ኮታ ይንቸንንዘንካ ግምዘንም ውችዝድንግንዳ የሱሰም፥ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","የሱስ ማቼ፥ “ይንችንታ እችምን ተይዮ አክስንከስካንታ እም ዝክሳዬ፥ ይና እርምሶ ይንችንከስ ምሳጋካ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ናየረ ማስሶ፥ “ገቴ የ ጮይስዮ፥ ማችንከረ አክስንከሰረ ጋበትንታ ጎያር ማትሶ ይንችና እጅድንካ ዋጅድንደትም ድንግመንም እጅደኬ”፥ ጋየሮ ክትካንታ ና ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ኮካንታ የሱስ፥ “ኮ የስታ ኬዘንካ ግምዘና ይንችንዘንካ ዉቴ፥ ይና ኮዘንካ የስታ ኤር አይካ!” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ናየረ ይንታ ኤር ኮትማቻንደትካ ኮታ ይንቸንን ዳቅል አያንና ዛቅስንካ ሰለንዘን ኡርመካ ራትሶ ዶቅድንካ ና ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","የሱስ ትያጥሮስ ካተመን ዛቅሶ ስዶና ካተመንጎካ ዶቆ ታማ ካተማ ገየርድንደትካ ስግሶ ገሊላ ባሃርንደር ኖᎺዴ ");
INSERT INTO gyl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ኮታረረ ዋልቃ ቃም ቱንከከ አፋ አስ ኤችም ክደር ተይ Ꮊደኬ፥ ይንታ አንንመረ ክታዘን ዎድንግንዳ ክትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","የሱሰረ ኤችንም ዎርሰናርንካ ዉችትዮ ክትም Ꮊክ ተይ አይስንደትከ ይንታ ግልኤንከስም ኤችንታ ቃምንከስታ ዋር አርችሴ፥ ኮታዘንከረ ይንታ ፈጭምነረ ፈጭምሶ ኤችንታ አድምን Ꮊጬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ፈስ ጭላር ሰድሶ ቡዳርንካ ኡክንሶ “ኤፍታ!” ገይሴ፥ ኮታ ቡልነረ “ፍኦችምካ!” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ሳነካ ክታ ቃምንከስ ፎችምሰኬ፥ አድምነረ ብልምሴ፥ ዋልቀረ ማጥርካይሳ ጭርርሳ ኬዛ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","የሱሰረ ኮም ርን Ꮊየሰንካንተረ ከት ኬዝዳክንግንዳ ኤድንከስም ክትሴ፥ ማታጋካ ዳት፥ ከት ኬዝዳክንግንዳ ክትሳንከካ በድካ ስክስሶ ኬዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ኤሰርስባብከሰረ ሙዳ አንድር በድ በርእካ፥ “ሙዳ ርን ኡርመካ ይሴ! ቃም ቱንንከስ ኤሰርድንግንዳ፥ አፋ አስንከስ ኬዝድንግንዳ ኖ ይዴ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ከትኬና ሰጨንከሳር አነታ በድ ኤድንከስ ሳንምሰኬ። ከት እጅድንደረ ካያ Ꮊቄ፥ ኮካንታ የሱስ ይንታ ካርንካ ጎርስምድባብከስም ኤልሶ ኩን ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ይና ኬና ኤድንከስ እንካ ክክን ማከን ሰጫ Ꮊቅተኬ፥ Ꮊረነረ ከት እጅድንዳ እችም ካየንካንታ ከትካንታ አጨርድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ኮከት ዳቀርሳንግንዳ ከትም ከታ ኤሪ እ ኦይዳ ማቼ ጎግያር ጋብደኬ፥ ኮትኮግንደረ ከታርንካ ዋልቃ ዋልቀንከስ ጎትንካ Ꮊድባብከሰኬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ክታ ካርንካ ጎርስምድባብከሰረ፥ “ይና፥ ኮ ዴል ቆቸናር ከትኬና ሙደንከስካንታ ማድን እችም Ꮊብድባብ Ꮊይራ?” ጋይሶ ክትካንታ ማስሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","የሱሰረ “መም ሶላ የንደር ዶቅዳ?” ጋይሶ ከትም ኦይሴ። ከተረ “ታብዛ ሶላ ዎንደር ዶቅዴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","የሱሰረ ፍጨዘን ከት ዶቅተርንግንዳ ዎርሰንም ክትሴ፥ ታብዛ ሶለንም የድሶ ሳብም ጋለቼ፥ Ꮊእስትዮ ዎርሰንካንታ ከት እምድንግንዳ ይንታ ካርንካ ጎርስምድባብከስካንታ እምሴ፥ ከተረ ዎርሰንካንታ የልስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ቶክም መራ ሞለንከሰረ ከደር ዶቅዴ፥ ሞለንከስጎከረ ሳብም ጋለቻንደታ ቡር ዎርሰንካንታ እምድንግንዳ ይንታ ካርንካ ጎርስምድባብከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ኤድንከሰረ ሙዳ እችሰኮ ምሰኬ፥ ስጣንደትመረ ዶከንም ሳንስሶ ታብዛ ጋባስርካ ጮጭ አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","እችባብ ኤድንከስ ኦይድ ሳአ ማድባብ Ꮊቀኬ፥ የሱሰረ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ኮታ ቡር ይንታ ካርንካ ጎርስምድባብከስካ ክክን ሎቀንዘንካ ቃልዝድን ጃልበናር አርድሶ ዳልማኑታ ጋየርድን ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ፈረሳዊያንንከስ የሱሰደር Ꮊድሰኮ ክትካ ክክን በርም የጀኬ። ጰጫካንተረ ገቀርሰኮ ጭላርንካ ዋልቃ ቃዉተን ከትካንታ ሰችዝድንግንዳ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","የሱስ ይንታ አያንካ አንድር ክትካንታ ኤስምስንካ፥ “ኮና አጥርና ቃዉተን ይድንግንዳ Ꮊራካንትክ ዝግዳ? ዶፈንካ የም ጋይድቴ፥ ኮ አጥርንካንታ Ꮊረሰነረ ቃዉተን እምምዳክዬ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ኮታርንከረ ከትም ዛቅሶ ካርንካ ሎቀንዘንካ ቃልዝድን ጃልበንካ ኦስ ፋማ ቃልሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ክታ ካርንካ ጎርስምድባብከስ ሶላ የድን ከት ባቀርሳንጎካ ሎቀንዘንካ ቃልዝድን ጃልበናር ዋልቃ ሶለዘንካ አብ Ꮊረነረ ከደር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","የሱሰረ “ፈረሳዊያንንከስተኬ ሄሮድሰታ እርሰንዘንካ ካርስምከቴ” ጋይሶ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ከተረ “ኮም ክታ ጋይንተና፥ Ꮊረንግርካ ሶላ ዎንደር ካየንካንታ ማዴ” ጋይሰኮ ክክ ክክ ከዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","የሱሰረ ኮም ከታ ገቅርን ኤስሶ ኩን ጋይሴ፥ “ሶላ ዎንደር ካየንካንቴ ጋይሰቶ Ꮊረተንት ገቀርዳ? አክ Ꮊረነረ ገቀርት ተይዳክባብከ የም ዝግዝዳክባበቶ? የንታ ቡደነረ ገቀርዳክንዶ? ");
INSERT INTO gyl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","አፍይ የንታ ዶቅድንካ ሰዳከቴ? ቃም የንታ ዶቅድንካ ኤሰርዳከተ? Ꮊስግንዳ የም ኤልቅ ጋይዳክንዳ? ");
INSERT INTO gyl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ይና ዶንቅ ሶለን ዶንቅ ሳአ ኤድንከስም Ꮊእስት እ እምሳን Ꮊይካ ስጫንደትም መም ጋባስርካ ጮጨንት አምሳሬ?” ኬተረ “ታመከ ቃስተን ጋባስርካ ጮጭዬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ኮትግንደረ ታብዛ ሶለንም ኦይድ ሳአ ኤድንከስካንታ እ Ꮊእስት እምሳንደት Ꮊይካ ስጥመንም መም ጋባስርካ ጮጨንት አምሳሬ?” ጋይሶ ከትም ጋይሴ። ኬተረ “ታብዛ ጋባስርካ ጮጭዬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","የሱሰረ “ይና፥ ታ የለልታ ገቀራከቴ?” ከደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ኮታርከረ በቴሳይዳር ከት የልሳንደትካ ኤድንከስ ዋልቃ አፍይ ዝልን የሱሰደር ተይᎺደኬ፥ ክትም Ꮊጭድንግንደረ የሱሰም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","የሱሰረ አፍይ ዝልን ኤችንታ አንን የድሶ ጎርሰሮ ሞረናርንካ ኦስ አብ ካርዘን ዉችሴ፥ ኤችንታ አፍንከዘነረ ይንታ ፈጭምን ፈጭምሶ ይንታ አንን ክታዘን ዎድሶ “ዋልቃ ር የዝደር Ꮊፈርዶ?” ጋየሮ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","አፍይ ዝልነረ ጬክን ጋይሶ፥ “ይዬ ኤድንከስ እዝደር Ꮊፈርደኬ፥ ማችንከረ ኤድንከስና Ꮊቀም ካምሶ ኦንግድንካ ሰድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","አናካርንከረ የሱስ ኤችንታ አፍንከዘን ይንታ አንንከስም ዎጄ፥ ኮታይካ ኤችና ፍስሳ ሰጄ፥ አፍና ክታ ፎችምስንካ ሙዳ ሪም ፋስት ሰድን የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ኮተረ ቡር የሱስ “ሞረናር Ꮊይአርዴ”፥ ጋይሶ ክት ይንታ ኤር አይድንግንዳ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","የሱሰከ ክታካርንካ ጎርስምድባብከስካ ፍልጶስ ቀሳርያ ጋየርድን ፍጨናር ዶቅድን ሞረንከሳርንካ ዉተደኬ፥ ጎግዘነረ ከትዶቅድንካ የሱስ፥ “ኤድንከስ እም Ꮊይክ ጋይዳ?” ጋየሮ ይንታ ካርንካ ጎርስምድባብከስም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ከተረ፥ “ዋልቃ ዋልቀንከስ ስእስንባብ ዮሀንሴ፥ አብንከሰረ ኤላሴ፥ አብንከሰረ ሳብዘንካ ኤሰርሶ ከዛቅባብከሳርንካ ዋልቀነ የስም ጋይደኬ” ጋየረኮ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“የተስ እም Ꮊየንት ጋይዳ?” ጋይሶ ከትም ኦይሴ። ጴጥሮሰረ፥ “የና ሳይምስባበዬ” ጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","የሱሰረ፥ “ክትጎካ Ꮊየሰንካንተረ ከት ኬዝዳክንግንዳ” ጋይሶ ከትም ኤግዝምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","የሱስ ይንታካርንካ ጎርስምድባብከስም ኩንጋየሮ ኤስስ የጄ፥ “ኤደት ይንች በድ ማጣ ተይ ክትም ዝግዝዴ፥ ጋልተንከዚደር፥ ቀሰንከስታ ገችስንባብከዚደርኬ ሙሴታ ህግንም ኤስዝድባብከዝደር ቶችምዴ፥ ደይስምዴ፥ ማታጋካ ዳት ማከን ሰጨንታ ቡር አምዴ”። ");
INSERT INTO gyl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ኮም ርን መየካ ከትም ኬዜ፥ ኮትኮᎺይካ ጴጥሮስ ክትም Ꮊክ Ꮊርሳ ተይአይሶ ዋጭ ክትም የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","የሱስ ማቼ ዋልን ገይሶ ይንታካርንካ ጎርስምድባብከስም ሰደሮ ጴጥሮስም፥ “የና ሰጣን ኦስ እዘንካ ጎተርካ! የና ኤተን ዳት ሳብትንደትም ገቀርዳከዬ!” ጋየሮ ክትም ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ኮታ ቡር የሱስ ዎርሰንም ይንታ ካርንካ ጎርስምድባብከስካ ክክን ኤልሶ ኩን ከትም ጋይሴ፥ “እም ጎርስምካንታ ሶልምድባብ ይ ዶቅሴ ይንታ ማተንም ዛቃ፥ ማዝቀልንመረ ባልሶ እስታ ካርንካ ጎርስማ፥ ");
INSERT INTO gyl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ይንታ ሰንፔንም አቅስካንታ ዝግድባብ ሙደና ኮትም ካይዝዴ፥ እ ካንተኬ ክላ ኬዘንጎካ ይንታ ሰንፔንም ስክስት እምድባብ ማቼ ኮትም አቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ኤድ ፍጫሙደንታ ቆልመንም ሙዳ Ꮊፍሴ፥ ይንታ ሰንፔንም ክት ካይሴ Ꮊሮክ ክትም መዬ? ");
INSERT INTO gyl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","አና ኤድ ይንታ ሰንፔንካንታ ቆትማ Ꮊርክ ናክ እምካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ኮ ቤልምንባብኬ ጎመንባብከስታ አጥርንታ እሪ እንከ እስታ ቃለንካ ኦስንድባብ ሙደና እተረ ኤደት ይንች እስታ ባቤንታ ቦንቸካ ጭል ክታይንችንካ ክክን Ꮊድቶ ክትካ እታ ኦስንድቴ።” ");
INSERT INTO gyl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ኮታዝንከሬ የሱስ፥ “ዶፈን የም ጋይድቴ፥ ታ ኮታር ዶቅድባብከሳርንካ ዋልቃ ዋልቀንከስ ሳብታ ባንችምና አንድር ዎልቀካ Ꮊድንካ ከት ሰተርን የለልታ ደእዳክባብከስ ዶቅደኬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ላ ሰጨንታ ቡር የሱስ ጴጥሮሰም፥ ያይቆበምከ ዮሀንሰምከ Ꮊክ ጎርስሶ ዋልቃ አንድር ገቸዘን ዉተዴ፥ ከታ እረረ የሱስታ ማልክና ኦክምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ክታ አፍለና አንድር ሮጵሴ፥ ፍጨዘን Ꮊየረ ስእትዮ ጫምስካንታ ማዳክንደትከካ የለልታ አንድር ጫምሳ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ኮታይካ ኤላሰኬ ሙሴካ መያ ማትሰኮ የሱሰካ ክክን ከት ከዝምድንካ ከትካንታ Ꮊፈርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ጴጥሮሰረ የሱሰም፥ “ኤስስንባቦ! ካሪ ዎ ዶቅሰስናና ዎካንታ ኡርሜ፥ ኮካንታ ዋልቃ የስካንታ፥ ዋልቀን ሙሴካንታ፥ ዋልቀን ኤላስካንታ ማድን ማከን ዳልቸንከስም ዎፍክሳ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ክታ ካርንካ ጎርስምድባብከስ ማከንና አንድር ከታ ገቅሰኮ Ꮊቃንጎካ ጴጥሮስ ይ ኬዝድንደትም ኤሳይᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ኮታዘንከረ ኡፓ Ꮊድሶ ከትም ስፍሴ፥ ኡፔንተረ ዋር “እ ሶልምድን እስታ ይንችና ኖ ኮኔ! ክትም ኤሰርከቴ!” ጋይድን ኡፍስ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ሳነከረ ዋልንጋይሰኮ ከታ ይንታ ካንተንካ ከት ሰድንካ ከትካ ክክን የሱሰዘንካ አብ Ꮊይመነረ ሰዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ገቸንዘንከረ ከት Ꮊንችርድንካ የሱስ፥ “ኤደት ይንች ደእናርንካ አምትርን የለልታ ኮም የ ሰጃንደትም Ꮊየንካንተረ Ꮊይከዘቴ” ጋየሮ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ከተረ ክታ ቃለንም ይንታ ቡዳር የጀኬ፥ ማታጋካ ዳት “ኮና ደእያርንካ አምንተና Ꮊራ ጋይንት ማተራ?” ጋየረኮ ክክ ክክ ከዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ከተረ “ሙሴታ ህግንም ኤስዝድባብከስ እርምሶ Ꮊድ ዝግዝድባብ ኤላሴ Ꮊረተክ ጋይዳ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","የሱሰረ፥ “ኮና ገቴ፥ ኤላስ እርምሶ Ꮊዴ፥ ሙደንመረ ኡርዝዴ፥ ማታጋካ ዳት፥ ኤደት ይንች አንድር ማጣ ተይድንደትምከ ቶችምድንደትም ጻፍምሳንዳ Ꮊረተረ? ");
INSERT INTO gyl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","እታ ማቼ ኤላስ እርምሶ Ꮊቴ፥ ኤድንከሰረ ክትጎካ ጻፍሳንግንዳ ከታ ይ ዝግዛንደትም ሙዳ ክታዘን ይተኬ” የካንታ ጋይድቴ። ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","የሱሰኬ ማከንና ክታ ካርንካ ጎርስምድባብከስ ነግድባብ ክታካርንካ ጎርስምድባብከዝደር ማተኮ ከት Ꮊዳንደትካ በድ ኤድንከስ ከታ ካንተካ ሳንምስንካ ሰደኬ፥ ሙሴታ ህግንም ኤስዝድባብከሰረ ክታ ካርንካ ጎርስምድባብከስካ ክክን ቤርምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ዎርሰነረ ሙዳ የሱሰም ሰድሰኮ በርእካ ገቅሰኬ፥ ክደር ዞደካ Ꮊድሰኮ አን የድሰኮ አቦ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","የሱሰረ “ከትካ ክክን የ በርምድንዳ Ꮊራካንተረ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ዎርሰንታ ዎክያርንካ ዋልቀና፥ ኩንጋየሮ ማስሴ፥ “ኤስስንባቦ፥ አፋ ኬዝዳክንግንዳ ይስዝድን አያንካ የደርስባብ እስታ ይንችን የዝደረ ተይᎺትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ክታዘን አምሳንደትካ ክትም ባልት ኦይዴ፥ አፈካ ዱብ Ꮊደሮ አችነረ ቅርጭዴ፥ ዘነነረ ክታ ዎችሶ ለይስንግንዳ ማዴ፥ ቱና አያንነረ ክታዘንካ ዉችዝድንግንዳ የስታ ካርንካ ጎርስምድባብከስም ኦይስትት ዶቆ፥ ኬዛርንካ ማቼ ከታ ዉችካንታ ማታከኬ”። ");
INSERT INTO gyl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","የሱሰረ፥ “የታ አሜንዳክን ኤድንከሶ! Ꮊንታ የለልትስ የንካ ክክን እታ ዶቅዳ? Ꮊንታ የለልትስ ዳንዳእዳ? ይንችንም ኮር እዝደር ተይ Ꮊድከቴ!” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ከተረ ይንችንም ክደር ተይ Ꮊደኬ፥ ቱና አያንነረ የሱሰም ሰጃንደትካ ሳነካ ይንችንም ባልት ዛቅሶ ጭእሴ፥ ይንችነረ ፍጨዘን ቡክለሮ አፈካ ዱብ Ꮊድ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","የሱሰረ ይንችንታ ባበንም፥ “ኮና ሰቅምና ክትም የጅንካ በድ ዶቅቶ?” ጋየሮ ክትም ኦይሴ። ባቤነረ፥ “ኤና ክት ይንችናና የድሶ፥ ");
INSERT INTO gyl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ክትም ደይሳካንተረ ዝገሮ በድᎺይካ ኖሔታ ዋርኬ ሎቀታ ዋር ባልት ክትም ኦይዴ፥ ዋዴ ዋልቃ ር ይይካንታ የዝደር ማድንካንታ ዋደ ዎካንታ አጨርካ! አሌን ዎም አልካ!” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","የሱሰረ፥ “የዝደር ማደረ” የና ጋይተራ? “አሜንድን ኤድካንታ ሙዳ ሪና ማዴ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ሳነካ ይንችንታ ባበና፥ “አመንድቴ፥ እስታ አሜንንታ ቶክንተን አለን አልካ” ጋይሶ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","የሱሰረ ዎርሰና ጭጭመትካ ዞደሮ ከት Ꮊድንካ ሰዴ፥ ቱና አያንንመረ “የና አፋ ከስዝዳክባብከ ቃም ቱንዝድን አያንና ይንችንዘንካ የስ ዉድንግንዳ ክደረረ ማተዮ የስ አርዳክንግንዳ የስም ክድቴ!” ጋይሶ ክትም ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ቱና አያንና አንድር ኡፍስካ ፍፍሴ፥ ይንችንመረ አከካ ጭእሳንደታ ቡር ክታዘንካ ዉተዴ፥ ይንችነረ ደእሳን ለይስንግንዳ ክታ ማትንተንካ በድንከዝደር ደእሳን ከደር ካምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","የሱስ ማቼ ይንችንታ አንንም የድሶ አምሴ፥ ይንችነረ አምትዮ ዎእሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","የሱሰረ ኤሄናር አርደዳንደትካ ክታ ካርንካ ጎርስምድባብከስ፥ “የለቴ ኮም ቱና አያንን ዎታ ዉችካንታ ዎማታክንደና Ꮊረተረ?” ጋይሰኮ ክትም Ꮊክ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","የሱሰረ፥ “ኮግንደና ምክስኬ በቼካ ምክስንካ ማታክንዳ ማቼ አብ Ꮊራርከረ ዉታዬ” ጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ ካርንኮትም ዛቅሰኮ ገሊላ ሞረናርጎካ አይሰኬ፥ ክት ዶቅድን ካርን Ꮊየነረ ኤድ ኤዝድንግንዳ የሱስ ዝጋክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ኮነረ ማቻንዳ የሱስ ይንታ ካርንካ ጎርስምድባብከስም፥ “ኤደት ይንች ኤድንከስታ አንያር ስክስምትቶ እምምዴ፥ ከተረ ክትም ደይዝደኬ፥ ይ ደይስምሳንደታ ቡር ማቼ ማክምስ ሰጨንካ አምዴ” ጋየሮ ከትም ኤስሰሮ Ꮊቃንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ክታካርንካ ጎርስምድባብ ማቼ ኮና ሪና ከትም አርዳክዬ፥ ክትም ከት ኦይዝዳክንግንደረ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ ቅፍራናሆም ካተመናር Ꮊደኬ፥ የሱስ ኤሄናር አርደዳንደታ ቡር ይንታካርንካ ጎርስምድባብከስም “ጎግዘን ዶቅደቶ የ በርምሳንዳ ሪና Ꮊራ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ከታ ማቼ ጫምን ጋይሰኬ፥ ኮነረ ጎግዘን ዶቅደኮ፥ “ዎ ሙደንዘንካ ስገድባብ Ꮊይራ?” ጋየረኮ ቤርምድ ከት Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","የሱሰረ ዶቅሳንደታ ቡር ታሜከ ቃስተንን ኤልሶ፥ “እሪ ማትካንታ ዝግድባብ Ꮊየነረ ኤድ ሙደና ሙደንታ ቡር ማታ ጉጅሰረ ሙደንከስታ ፍክስባብ ክት ማታ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ዋልቃ መራ ይንች ተይᎺድሶ ከታ ዎክያር ዎይስሶ፥ እምጭሰረ ኩን ከትም ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ኮግንዳ ዶቅድን ይንችንከሳርንካ ዋልቀን እስታ ላምንካ ሞግድባብ ሙደና እም ሞግዴ፥ እመረ ሞግድባብ ሙደና እም ማታክናና፥ እም ኦይችባብም ሞግዴ”፥ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ዮሀንሰረ የሱሰም “ኤስስንባቦ፥ ዋልቃ ኤች የስታ ላምንካ ግምዘን ዉጅድንካ ሰዶቴ፥ ማችንከረ ዎንከረ ክክን ክት ማታክንካንታ ማርሶቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","የሱስ ማቼ፥ “እስታ ላምንካ አታ ይየሮ ሳነካ እስታዘን ዳቅል ኬዝድባብ ካየንካንታ ክትም ዛእከቴ፥ Ꮊይማረቴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ዎም ግርዳክባብ ሙደና ዎንካ ክክኔ፥ ");
INSERT INTO gyl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ዶፈን የም ጋይድቴ፥ ክርስቶሰታ የ ማቻንካንታ እስታ ላምንካ ዋልቃ ቡርጭቀካ ሎቃ ዎራ የም እምድባብ ሙደንታ ናክ ካያዬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ꮊየነረ ኤድ እንካ አሜንድባብ ከትኬና መረንከሳርንካ ዋልቀን ኮተርዝድንዘንካ አንድር ደይስን ሰይንም ይንታ ባርያር ዞከርሶ ባሀርናር ክት ኦይትምሰስናና ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ኮካንታ የስታ አንና ጎማ የስ ፍግዝድንግንዳ የስም ኮተርዝደ ኮትም ተችት ዛእካ! ቃስተን አን የስታ ዶቅድንካ ድግዳክን ኖሄናር የስ ኦይትምድንዘንካ ዱንግላ ማትሶ ስለንካ ዶቅንትያር አርድና የስካንታ ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ድግዳክን ኖሄናር ዱርእመና ደእዳክንዳ፥ ኖሄነረ ድግዳክን ካርዬ። ");
INSERT INTO gyl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","የስታ ዱትነረ የስም ኮተርዝደ ተችት ዛእካ፥ ቃስተን ዱት የስታ ዶቅድንካ ድግዳክን ኖሀር የስ ኦይትምተርንዘንካ ዎብ ማትሰዮ፥ ሰንፔካ ዶቅንትያር አርድና የስም ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ድግዳክን ኖሄናረረ ዱርእመና ደእዳክንዳ ኖሄነረ ድግዳክንዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","የስታ አፍነረ የስም ኮተርዝደ፥ ዎልክስት ዉችካ፥ ቃስተን አፍይ የስታ ዶቅድንካ ድግዳክን ኖሄናር ኦይትምዘንካ፥ ዋልቃ አፍይ የስታ ዶቅድንካ ሳብታ ባንችምናር አርድና የስም ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“ድግዳክን ኖሄናረረ ዱርእመና ደእዳክንዳ፥ ኖሄነረ ድግዳክንዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ካሴርድንዳ ሶቅካ ሳዉስምድንግንዳ ዋልቃ ዋልቃ ኤድንከስ ኖሄካ ጰጭምም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“ሶቅ ኡርሜ፥ ማታጋካ ዳት፥ ሶቅታ ሎቅንም ኮት ይንታ ካይሰ Ꮊረከንት ሎቅስዝዳ? “የንከረ ሶልማ ሶቅታ ሎቅንግንዳ ሶልማ የንታዋር ዶቃ፥ ክክ ክከረ ኤእሰቶ ሳራትቸካ ዶእከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","የሱስ ኮታርንካ አምሶ፥ ዮርዳኖስ ሎቀንታ ፋማ ዶቅድን ይሁዳ ሞረናር አይሴ። አንድር በድ ኤድንከሰረ አና ካርንካ ክደር ሳንምድ Ꮊቀኬ፥ የሱሰረ ይንታ መጠንግንዳ ከትም ኤስዝድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ፈረሳዊያንንከሳርንካ ቶክምንከስ ክደር Ꮊደኬ፥ ክትም ጰጫካንተረ ዝግሰኮ፥ “ኤድ ይንታ ኬነንም ቡልድንግንዳ ህግንካ ክትካንታ ጋይምቶ?” ጋየረኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","የሱሰረ “ሙሴ ኮርንካንታ Ꮊርክ የም ክትሳሬ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ከተረ “ሙሴ ማቼ ኮት ብልምሳንደታ ማርካትች ዋርቀትን እምሶ ኮትም ቡልድንግንዳ ጋይቴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","የሱሰረ፥ “ሙሴ ማቼ ኮም ህግን የካንታ ጻፍሳንዳ የንታ ቡደና ዳቅስንካ የ ኤሰራይንጎኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ኬዛር ማቼ ኤና እሪ ፍዝርንዘንካ የችሶ ‘ሳብ አⷝነኬ ማነካ ማስሶ ከትም ፍዜ። ");
INSERT INTO gyl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ኮካንታ ኤድ ይንታ ባቤንምኬ እንደንምካ ዛቅሶ ይንታ ኬነንካ ክክን ዋልቃ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ቃስተነረ ዋልቃ ዋሀ ማደኬ’ ኮዘንከረ ኦስ ቃስተን ከታ ማትንተና ነግሶ ዋልቃ ማደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ይና ሳብ ዋልቃ ማስሳንደትም ኤድ Ꮊይ ፋሳ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ኤሪ ከታ ይ ማቻንደትካ ክታ ካርንካ ጎርስምድባብከስ ኮትኮ ኬዘንጎካ ካርንካ የሱሰም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","የሱሰረ፥ “ይንታ ኬነንም ቡልሶ አብ ማና እንጅድባብ ኮትዶቅድንካንታ ኖ ቤልምቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ኮትኮግንደረ ይንታ ክእስን ብልሶ አብ አⷝና ኤሪ ይእድን ኤተና ቤልምታ ጋይንትዬ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","የሱስ ከትም Ꮊጭድንግንዳ ይንችንከስም ክደር ተይ Ꮊደኬ፥ ክታካርንካ ጎርስምድባብከስ ማቼ ይንችን ተይᎺድባብ ኤድንከስም ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","የሱሰረ ኮም ሰድሶ ዋጬ፥ ይንታካርንካ ጎርስምድባብከስም፥ “ሳብታ ባንችምና ከትኬናከስግንዳ ይንችንታ ማቻንካንታ ይንችንከስ እዝደር ከት Ꮊዳ፥ ዛእከቴ፥ ከትም Ꮊይማረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ዶፈን የም ጋይድቴ፥ ሳብታ ባንችምን ይንችግንዳ ማትሶ ኮትም ተይዳክባብ ቦድሶ ኮታር አርዳክዬ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ኮታ ቡር ይንችንከስም እምጭስንደትከ ይንታ አንንም ከታዘን ዎድሶ ከትም አንጄ። ");
INSERT INTO gyl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","የሱስ ኮታርንካ ዉትሶ አያዶቅድንካ ዋልቃ ኤች ክደር ዞደሮ Ꮊድሶ ክታ እር ጉምፈርሶ “Ꮊልስማ ኤስስንባቦ፥ ስለንካ ዶቅንትን ተይካንታ Ꮊራ እም ይ ዝግዝዳ?” ጋየሮ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","የሱሰረ፥ “Ꮊራጎከስ Ꮊልስማ እም ጋይዳ? ዋልቃ ሳብንዘንካ አብ Ꮊየነረ Ꮊልስማ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ክተንከስም የና ኤዝደዬ፥ ከተረ ‘Ꮊይ ደይሴ፥ ማነን ኦከሮ Ꮊይ ቤልመ፥ Ꮊይ ድቤ፥ ካርከካ Ꮊይማርከሬ፥ Ꮊይ ገስሴ፥ የስታ ባበንምከ የስታ እንደንም ቦንችካ’ ጋይምስባብከሰኬ” ኩንጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ኤችነረ “ኤስስንባቦ፥ ከትኬና ክተንከስም ማቼ ኤና ይንችዘንካ የችስቶ ካርስትቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","የሱሰረ ክትም ሰድሶ ሶልምሴ፥ ኩነረ ክትም ጋይሴ፥ “ዋልቃ ር Ꮊክ የዘንካ ነገቴ፥ አይካ፥ የስታ ዶቅድንደትም ሙዳ ሰንሰዮ የስታ ብረንም ርካየንባብከስካንታ እምካ፥ የስካንታ ሳንምሳን ቆልመንም ጭላር Ꮊፍተረዬ፥ ኮታ ቡር Ꮊድካ፥ እም ጎርስምካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ኤችነረ ኮም ይ ኤሰርሳንደትካ ባለና ክታ ሞርእካ ጫልሴ፥ በድ ቆልመረ ክታ ዶቅድንካንታ ሞርኤሮ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","የሱስ ዋልን ጋይሶ ክትም ሰድስንደትከ ይንታ ካርንካ ጎርስምድባብከስም፥ “ቆልመክንባብከስ ሳብታ ባንችምናር አርድና Ꮊስግንዳ ደጭመሬ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ክታ ካርንካ ጎርስምድባብከሰረ ክታ ቃለንካ በርእሰኬ፥ የሱስ ማቼ ማስሶ፥ “እስታ ይንችንከሶ! ሳብታ ባንችምናር አርድና Ꮊስግንዳ ደጭመሬ! ");
INSERT INTO gyl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ቆልማባብ ሳብታ ባንችምናር አርድንዘንካ ግመል ጋየርድንደና ማርፈታ ጩቅካ አርደስናና ኡርዴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ክታካርንካ ጎርስምድባብከስ አንድር በርእሰኮ፥ “ኮናና ኮግንደካ Ꮊይ አቅካንታ ማዳ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","የሱሰረ ከደር ሰድሶ፥ “ገታ ኮና ርና ኤደር ማታዬ፥ ሳብደር ማቼ ማደ፥ ሳብካንታ ሙዳ ር ማዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ጴጥሮሰረ “ይና ዎታ ሙደን ዛቅሶቶ የስታ ካርንካ ጎርስምሶቴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","የሱሰረ፥ “ዶፈን የም ጋይድቴ፥ እካንተከ ኮ ክላ ኬዘንካንታ ጋይሶ ይንታ ኤሄንም አነረ ይንታ እስመንከስም አነረ ይንታ ምችነንከስም አነረ፥ ይንታ እንደንም፥ አነረ ይንታ ባበንም፥ አነረ ይንታ ይንችንም፥ ናነረ ይንታ ዎንንም ዛቅስባብ ኤድ ሙደና ስክስሶ Ꮊብዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ታ ኮ ፍጫሙደንዘን ዎራ ዳይርንካ ክክን ይንታ ኤሄንም፥ እስመንከስም፥ ምችነንከስም እንደንከስም ይንችንከስም ዎንንም ዶንቅ ቦንደዘን ዶንቅ ቦንዳ ጉጅምሳንደትም ተይዴ፥ Ꮊድን ፍጫሙደንዘን ስለንካ ዶቅንትንም Ꮊፍተሬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ማታጋካ ዳት እር ማትሶ Ꮊቅባብ በድንከስ ቡርንባብ ማተረከ፥ ቡርንባብ ማችባብከሰረ እርንባብ ማተረከ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","የሩሳሌም አይድን ጎግዘን ከትዶቅድንካ፥ የሱስ ከታ እር አይድ Ꮊቄ፥ ክታካርንካ ጎርስምድባብከሰረ ኮርንካ በርእሰኬ፥ ክታ ካርንካ Ꮊድባብ አብንከስ ጳዝድ Ꮊቀኬ። ካርንከረ ታሜከ ቃስተንን ይንደር ተይᎺችሶ፥ ይንዘን የልድን ሪንጎካ ኩንጋየሮ ከትካንታ ኬዜ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ይና፥ የሩሳሌማር ዎንታ አይንቴ፥ ኤድ ይንች ቀሰንከስም ገችዝድባብከስካንተኬ ሙሴታ ህግን ኤስዝድባብከስካንታ ስክስምት እምምተሬ፥ ከተረ ደእታ ፍርደን ክታዘን ፋረተርኬ፥ አይሁድ ማታክባብከስካንታ ስክስት ክትም እምተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","አይሁድ ማታክባብከሰረ ክታዘን Ꮊልተርተረኬ፥ ክታዘን ፈጭምተረኬ፥ ክትም Ꮊርተረከ፥ ክትም ደይስተረኬ፥ ኬዛር ማቼ ማከን ሰጨታ ቡር ኖ አምተሬ”። ");
INSERT INTO gyl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ዛብዶሰታ ይንችንከስ ያይቆበኬ ዮሀንሰካ የሱሰደር Ꮊድሰኮ፥ “ኤስስንባቦ፥ የስም ዎ ምግዝድንደትም ሙዳ የስ ይድንግንዳ ዝግዶቴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","የሱሰረ “Ꮊራ እ የካንታ ይድንግንደንት ዝግዳ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ከተረ “የስታ ቦንችምሳን ባንችምንᎺይካ ዎንታርንካ ዋልቀና የስታ ምዝዘን፥ ዋልቀና የስታ ብተንዘን ዎ ዶቅድንግንዳ ዎካንታ ጋይካ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","የሱስ ማቼ “የታ የ ምግዝድንደትም ኤዝዳከቴ፥ እ ዎጭድን ማጠንታ ዎጭምን ዎጭካንታ ማደቴ? እ ስኤርድንደት ስእርንም ስእርካንታ ማደቴ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ከተረ “ይዬ ዎጭካንታ ማዶቴ” ከታ ጋይሰኬ። የሱሰረ፥ “ዶፈን እ ዎጭድንደትም ማጠንታ ዎጭምን ዎጭተረቴ፥ እ ስኤርድንደትም ስእርን ስኤርተረቴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ኬዛር ማቼ እስታ ምዝዘንኬ እስታ ብተዘን ዶቅንትን እምድባብ እታ ካይቴ፥ ኮና እምምድንዳ ሳብ ይ ግክስባብ ኤድንከስካንታ Ꮊክዬ”። ");
INSERT INTO gyl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ነገድባብከስ ታሜና ኮም ኤሰርሰኮ ያይቆብዘንከ ዮሀንሰዘን ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","የሱስ ሙደንመረ ይንደር ኤልሶ ኩን ከትም ጋይሴ፥ “አይሁድ ማታክባብከስታ ገችንባብ ዎርሰንም ቆልድባብከስ ጋይምሰኮ ኤልምድንግንደከ ከትም ጎርዝድባብከሰረ ከታዘን ገችታ ኤራ ዶቅድንደትም የታ ኤዝደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","የንደር ማቼ ኮግንዳ ማት ዝግስሳዬ፥ የንታ ዎክያርንካ አንድር ማትካንታ ዝግድባብ፥ የንታ ፍክስባብ ማት ክትም ዝግዝዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ኮትኮግንደረ የንታ ዎክያርንካ ሙደንዘንካ ስግ ማትካንታ ዝግድባብ ሙደንታ አይላ ማታ። ");
INSERT INTO gyl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ኤደት ይንች ዎራ ፍክስካንተኬ ይንታ ሰንፔንም በድንከስካንታ ቆትማ ማስሶ እማካንታ Ꮊዳ ዳት ክትካንታ ፍግዝድንግንዳ Ꮊዳክዬ።” ");
INSERT INTO gyl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ኮታ ቡር የሱስ ይንታ ካርንካ ጎርስምድባብከስካ ክክን ኢያርኮ ካተመናር Ꮊዴ። ስግሰረ ካተመናርንካ ዉትሶ ክት አይድንᎺይካ አንድር በድ ዎርሳ ክትም ጎርስምድ Ꮊቄ፥ ጉጅሰረ ጎግንታ ካንታር ጤሜዎሰታ ይንች ማችባብ በርጤመዎስ ጋይምድባብ ዋልቃ ኣፊይ ዝል ዶቅሶ ምግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ኮትከረ ስግድባብ ናዝረት የሱስ ማትንተን ይ ኤሰርሳንደትካ “ዳውትታ ይንች የሱሶ፥ ዋደ እካንታ አጨርካ!” ጋየሮ ፍፍ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","በድንከስ ጫምን ጋይካ! ጋይሰኮ ክትም ዋጨኬ፥ ኖ ማቼ “ዳዊተታ ይንችኖ! ዋዴ እም ኣጬርካ” ጋየሮ ስግስሶ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","የሱሰረ ዎእሶ “ክትም ኤልከቴ!” ጋይሴ፥ ከተረ አፍይ ዝልንመረ “ታ ዛብካ! አምካ! የሱስ የስም ኤልዴ!” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ኤችነረ አፍለን ይንታ ዛቅሶ ጎብሶ አምትዮ የሱሰደር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","የሱሰረ ክትም “Ꮊራ እ የስካንታ ይድንግንደስ ዝግዳ?” ጋየሮ ክትም ኦይሴ። ኣፊይ ዝል ኤችና “ኤስስንባቦ፥ ዋደ እስታ አፍና ሰድንግንዳ እካንታ ይካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","የሱሰረ “ይና አይካ፥ የስታ አሜንና የስም አቅስቴ” ክትም ጋይሴ። ኤችነረ ሳነካ ሰድንካንታ ማቼ፥ ጎግንኮትከረ የሱሰም ጎርስምሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስከ የሩሳሌማር ከት የልሳንደትካ ደብረዛይት ገቼንታ ላማር በቴ ፋጋርኬ ብታንያ ሞረናር የልሰኬ፥ ኮታዘንከረ የሱስ ይንታካርንካ ጎርስምድባብከሳርንካ ቃስተንንም ኩንጋየሮ ከትም ኦይቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“የንታ እሪ ዶቅድን ሞረናር አይከቴ፥ ኮታረረ የ የልሳንግንዳ ሳነካ Ꮊየነረ ኤድ አክ ዶቃክንዳ ኡክልታ ቅንጭ ዞክርሶ ዶቅድንደትም Ꮊፍተረቴ፥ ቡልተቶ እዝደር ተይ Ꮊድከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ꮊየሰነረ ‘Ꮊረተንት ኮም ይዳ?’ የንደር ጋይሴ፥ ‘ጮይስካንታ ዝግዝዴ፥ ሳነካ ማስት ኖ ኦይተሬ’ ጋይሶ ከስከቴ”። ");
INSERT INTO gyl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ከተረ አይሰኮ ኡክልታ ቅንጨን ጎግንታ ካንተዘን ኤሄንታ ዎፈዘን ዞከርስንካ Ꮊፍሰኮ ቡልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ኮታይከረ ዋር ዎእሶ ዶቅድባብ ኤድንከሳርንካ ዋልቃ ዋልቀንከስ። “ኡክልንታ ቅንጭንም የ ቡልድንዳ Ꮊረተረ?” ጋይሶ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ከተረ የሱስ ከደር ጋይሳንደትም ኤድንከስካንታ ኬዘኬ፥ ኤድንከሰረ ከትም ዛቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ክታ ካርንካ ጎርስምድባብከሰረ ኡክልንታ ቅንጭንም የሱሰደር ተይ Ꮊደኬ፥ ከታ ይንታ አፍለንም ኡክልንታ ባዝደዘን ዎጅንካ የሱስ ኮታዘን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","በድ ኤድንከስ ይንታ አፍለንም ጎግንዘን ታከርሰኬ፥ አብንከሰረ ጮልም Ꮊቀንታ ትርሰንም ፋክተኮ ታከርድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","እሪ ስግድባብከስከ ክታ ቡር ጎርስምድባብከስ ሙደና፥ “ሆሳእና! ጮይስታ ላምካ Ꮊድባብ አንጅምስባቤ! ");
INSERT INTO gyl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ꮊድንዳ ዎንታ ባበን ዳውትታ ባንችምና አንጅምሳንዴ፥ ጎፍስና ጬክን ጋይሳን ጭለዘን ሳብካንታ ማታ!” ጋየረኮ ፍብድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","የሱሰረ የሩሳሌማር የልሳንደትካ ሳብታ ጭል ኤሄናር አርደዴ፥ ካንተካ ዶቅድንደትም ርን ሙዳ ሰጄ፥ ሰጨነረ ሶይቻንካንታ ታመከ ቃስተንንከስካ ክክን ብታንያ ሞረናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ዛማክንካ ብታንያርንካ ከት ማድንካ የሱስ ዳቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ቃምና ኮታ ጮልሳንዳ Ꮊቃ ባለስ ጋይምድንደትም ጎትካ ሰድሶ Ꮊረንግርካ አፍ Ꮊፈርዳናንከረ ጋይሶ ኮደር Ꮊዴ፥ ኬዛር ማቼ ኮደር Ꮊድንካ Ꮊቃ በለስና አፍ ኡዝድንደታ አርፍ ማታክንካንታ ቃምዘንካ አብ Ꮊረነረ ኮታዘንካ Ꮊፋክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ኮካንታ የሱስ በለስ Ꮊቀን፥ “ይና ኮዘንካ ኦስ ስለንክንደታ Ꮊየነረ የዘንካ አፍ Ꮊይ እቻ!” ኮትም ጋይሴ። ኮመረ ክት ኬዝድንካ ክታ ካርንካ ጎርስምድባብከስ ኤሰርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","የሩሳሌማር ከታ የልሳንደትካ የሱስ ሳብታ ጭል ኤሄናር አርድሶ ኮታር ሰንድባብምከ ጋብድባብ ኤድንከስም ዉች የጄ፥ ብረን ኦካኦግድባብከስታ ጣርጰዘንምኬ፥ ዎለንም ሰንድባብከስታ ዶቅንት ጎንገንከስም ባልትዮ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ꮊየነረ ኤድ Ꮊረነረ ር ባልትዮ ሳብታ ጭል ኤሄንታ ጋስናር ስገድንግንዳ ጋያይቴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ኩነረ ጋየሮ ከትም ኤስሴ፥ “ ‘እስታ ኤሄና ዎርሳ ሙደንካንታ ምክስ ኤሀ ጋይምዴ!’ ጋይምሶ ጻፍማክዮ? የታ ማቼ ፋንገንከስ አጥምድንግንዳ የርሳ ማስሰቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ቄሰን ከስም ገችዝድባብከስኬ ሙሴታ ህግንም ኤስዝድባብከስ ኮም ክት ኬዝድንካ ኤሰርሰኬ፥ ዎርሰነረ ሙዳ ክታ ኤስስንካ ከት በርእሳንካንታ ክትም ጳሰኬ፥ ማታጋካ ዳት Ꮊስግንዳ ይይሶ ከታ ክትም ይ ደይዝደክ ናነረ ጎግ ዝግድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ፍጨና ሶይቻንደታ ቡር የሱሰኬ ይንታ ካርንካ ጎርስምድባብከስካ ካተመናርንካ ዉተደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ዛማክንᎺይካ ሰጭማ ጎግንካ ከት ስገድንካ ባለስ Ꮊቀና ይንታ ጫጭንካ ዎችንካ ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ጴጥሮሰም ርና ከልቅን ጋይስንካ የሱሰም፥ “ኤስስንባቦ! ኮሰቼ፥ የስ ባድሳን ባለስ Ꮊቀና ዎችቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","የሱሰረ፥ “ሳብካ አመንከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ዶፈን የካንታ ጋይድቴ፥ Ꮊየነረ ኤድ ይንታ ቡዳር Ꮊኤራክዶቆ ክት ዝግድን ርና ክትካንታ ቦድምድንደትም አሜንሶ ኮም ገቸን ‘ኮዘንካ አምሰዮ ባሀርናር አይካ’፥ ክት ጋይሴ ክትካንታ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","“ኮካንታ ምክስካ Ꮊምንመረ ር የ ምክሴ፥ የካንታ ቦድምሳን ማስሰቶ አመንከቴ፥ የ ምግዝድንደትም ሙዳ የካንታ እምምዴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ጭላር ዶቅድባብ የንታ ባቤና የንታ ጎመንም ነጋ ጋይተርንግንዳ የተረ ምክስካንታ የ ዎእድንᎺይካ Ꮊየነረ ዋልቃ ሪካ የም ይምኤርስታ ማቼ ክትካንታ ነጋ ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","የታ አብንከስታ ዳቀልስን ነጋ የ ጋያይንዳ ማቼ ጭላር ዶቅድባብ የንታ ባቤና የንተረ ጎመን ነጋ የካንታ ጋያዬ” ከትካንታ ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","አናካርንካ የሩሳሌማር Ꮊደኬ፥ የሱሰረ ሳብታ ጭል ኤሄናር ክት ኦንግድንካ፥ ቀሰንከስታ ገችንባብከ፥ ሙሴታ ህግንም ኤስዝድባብከስከ ጋልተንከስካ ክደር Ꮊድሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“ከትኬና ሪን የስ ይድንዳ Ꮊራ ገችስታ ዎልቀከረ? አና ከነም ርንከስም የስ ይድንግንዳ ገችስታ ኤረንም የስካንታ እምስባብ Ꮊይራ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","የሱሰረ፥ “ይና እተረ የም ዋልቃ ኦይስ የም ኦይዝድቴ፥ የታ እካንታ የ ማስሴ፥ እተረ ኬና ርንከስም Ꮊራ ገችታ ኤረካ እ ይዳናከረ የካንታ ኬዝድቴ ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ዮሀንሰታ ስእስና ሳብዘንኮ ኤድዘንኮ? እካንታ ማስከቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ከተረ “ይና Ꮊሮንት ጋይቴ?” ጋይንተካ ክክ ክክ ዞርምሰኬ፥ “ ‘ሳብዘንኬ’፥ ዎ ጋይሴ፥ ‘ኮናና Ꮊረተረ ክትካ የ አሜናክንዳ?’ ዎም ኖ ጋይዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘ኤድዘንኬ’ ጋይተሮቶ?” ኮም ከት ጋይዳክንግንዳ ዎርሰና ሙዳ ዮሀንሰም ዶፈን ሳብዘንካ ኤሰርሶ ኬዝድባቤ ጋይድ ከትᎺቃንካንታ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ኮካንታ “ዎታ ኤሳዮቴ” ጋየረኮ ክትካንታ ማስሰኬ። የሱሰረ “ይና ኮናና እተረ Ꮊራ ገችታ ኤረካ ኬና ርንከስም እ ይይዳናንከረ የም ኬዛይቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ኮታዘንከረ የሱስ ኮም ካምስካ ኩንጋየሮ ከትም ኬዛ የጄ፥ “ዋልቃ ኤች ኮረርድን ዎይንንም ኮርሴ፥ ካንተንመረ ጋሴ፥ ዎይንን ጩጴርድንደታ ጎር ኮይሶ ካርሰርድንደታ ላቼረ ኡርሴ። ኮታዘንከረ ዎንንባብከስካንታ እምሶ አብ ፍጫር አይሴ”። ");
INSERT INTO gyl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","አፍ ኡዝድን ለእንካ ዎይንታ አፍንም ካምት Ꮊትርንግንዳ ፍክስንባብከሳርንካ ዋልቀን ዎንንባብከዝደር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ከታ ማቼ የድሰኮ ጉጵሰኬ፥ አንይ ዉች ክትም ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","አናካርንከረ አብ ፍክስንባብም ኦይቼ፥ ከተረ ማተን ክታ ሰይንካ ዛልሰኮ ኦስንስሶ ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ታየረ ካርንካ አብንም ኦይቼ፥ ክትመረ ደይሰኬ፥ ኮትኮግንደረ በድንከስም ኦይችንካ ዋልቃ ዋልቀንከስም ጉጵሰኬ፥ አብንከስመረ ደይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ታ ይይ ክታዘንካ ነገዳንዳ ይ ሶልምድን ይንታ ይንችንም ኦይት Ꮊክዬ፥ ኮካንታ እስታ ይንችንም ከታ ቦንችተረ ዳቶ ጋይሶ ገቅርካ በእንተዘን ዋልቃ ይንታ ይንችን ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ኬዛር ማቼ ክታ ዎንንባብከስ ክክ ክክ ኖኮና ባእንም ተይድባብኔ! ኮረቴ ክትም ደይስተሮቴ! ባእነረ ዎካንታ ማዴ ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ኮካንታ ይንችንም የድሰኮ ደይሰኬ፥ ዎይን ኮርምሳን ካርናርንከረ ጎችት ዉችሰኮ ዛቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ይና ኮዘንካ ዎይንን ኮርምሳን ባበና Ꮊርክ ይቴ? ዎይንንታ ባበና ይንታ ማታርንካ Ꮊዴ፥ ይንታ ዎንንባብከስመረ ደይዝዴ፥ ዎይን ኮረንመረ አብንከስካንታ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ይና፥ “ሰይን ኤሄንም ዎድባብከስ ቶችሳን ሰይንና ዎደርድን ኤሄንታ እድምሳንዳ ማቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ኮነረ ጮይስዘንካ ይምሴ ዎንታ አፍንካንታ በርእዝድንዴ”። ኩን ጋይድንደትም ጭል ማጻፍናርንካ ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","አይሁድንከስም ገችዝድባብከስ የሱስ ኬዛንደትም ካምስንከስና ከትም ሰጅድንዳ ማትንተን ከታ ይ ገቀርሳንካንታ ክትም የድካንታ ዝግተክ ዶቆ፥ ኬዛር ማቼ ዎርሰንም ጳስሰኮ ክትም ዛቅሶ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ፈረሳዊያንንከስ ሄሮድሰታ ኮች ማችባብ ዋልቃ ዋልቃ ኤድንከስ የሱሰም ክት ኬዝድንደትካ ክትም የድካንታ ክደር ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ክደር Ꮊድሰኮ፥ “ኤስስንባቦ፥ የና ዶፈን የስ ማቻንደትም ዎታ ኤዝዶቴ፥ ኤድም ጳስከ ኦስነካ የስ ይድንዳ ር ካዬ፥ ሳብተረ ጎግንም ዶፈንካ ኤስዝደዬ፥ ይና፥ ሮማ ባንችንካንታ ግራ ናክና ዝግዝዶ አና ዝክሳዮ? ዎተረ ግርተሮቶ ግርተራኮቶ?” ኩን ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","የሱሰረ ከታ ኦትረንም ኤስሶ “Ꮊራካንተንት ጭካ እካንታ ዎዳ? ይና ብረን ተይᎺድሰቶ እም ሰችከቴ”፥ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ከተረ ብረንም ክትካንታ ተይ Ꮊደኬ፥ የሱሰረ “ኮ ብረንዘን ዶቅድንዳ ምስልንኬ ጻፈርሳንዳ ላምና Ꮊይተረ?” ጋይሶ ከትም ኦይሴ። ከተረ “ሮመታ ባንችን ቀሳርቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","የሱሰረ “ኮናና ቀሳርትንደትም ቀሳርካንታ፥ ሳብትንደትም ሳብካንታ እምከቴ” ጋየሮ ከትካንታ ማስሴ። ከተረ ክታ ኬዘንታ ማስንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","“ደእስባብታ አምንታ ካዬ” ጋይድባብከስ ሰዱቃዊያን ኤድንከስ የሱሰደር Ꮊድሰኮ ኩንጋየሮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ኤስስንባቦ፥ ‘ዋልቃ ኤድ ይንች አጣክዶቆ ይንታ ኬነንዘንካ ደእካ ክት ፋስምሴ ክታ እስመና ኤተንን ማስሶ ደእስባብታ ካርያር ይንች አጣ’፥ ጋይሶ ሙሳ ዎካንታ ጻፍቴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ይና፥ ታብዛ እስመንከስ Ꮊቀኬ፥ ከት ሙደንታ ባይረና ማና እንችሶ ይንች አጣክዶቆ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ቃስትምስነረ ኤተንን ኮትም ማስሶ፥ ኖየረ ይንች አጣክዶቆ ደእሴ፥ ማክምስነረ ኮትኮግንዳ ደእሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ኮግንደካ ታብዘና ኮትም እንችሰኮ ይንች አጣከክ ዶቆ ደእሰኬ፥ ከትሙደንተረ ቡር ኤተነረ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ይና፥ ታብዛ እስመንከሰረ ኮትም እንችተኬ፥ ይና ደእስባብከስ አምድንደትᎺይካ Ꮊይቶክ ማና ና ማዳ?” ");
INSERT INTO gyl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","የሱሰረ፥ “የ ኮተርድንደና ጭል ማጻፍንከ ሳብታ ዎልቀን ኤስክሳ የንታ ነግንተንካ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ደእስባብከስ አምድንᎺይካ ጭላር ዶቅድባብ ክታይንችንከስግንዳ ማደክ ዳት እንቻየኬ ይአየኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ደእስባብ ማቼ ከት አምድንግንዳ ሳብ፥ “ ‘እታ አብራሀመታ ጮይስ ይሳቀተረ ጮይስ ያይቆበተረ ጮይስቴ’ ክት ጋይሳንደትግንዳ ቆቸናር ኖሄና የድንካ ሙሴካንታ ሳብ Ꮊራክትም ከዛናንከረ ሙሴታ ማጻፍናር ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ኮካንታ ሳብ ስለንካ ዶቅድባብከስታ ጮይስ ዳት ደእስባብከስታ ጮይስ ካዬ፥ የታ ማቼ አንድር ኮተርደቴ” ኩንጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ሙሴታ ህግንም ኤስዝድባብከሳርንካ ዋልቀና ከታ ቤርምን ኤሰርድ Ꮊቄ፥ የሱሰስ ኡርመካ ከትካንታ ኬዛንካንታ ሙሴታ ህግንም ኤስዝድባብ ኖ ገቀርሴ፥ የሱሰደር Ꮊድሶ “ሙደንዘንካ ስግድንዳ ክተና Ꮊምነረ?” ጋይሶ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","የሱሰረ፥ “ሙደንዘንካ ስግድንዳ ክተና፥ ‘እስራኤሎ! የና ኤሰርካ፥ ሳብ ዎንታ ጮይስና ዋልቃ ጮይስዬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","የነረ የስታ ጮይስ ሳብንም የስታ ቦድማ ቡዳርንካ፥ ቦድማ ሰንፔካ፥ ቦድማ የስታ ገቅርንካ፥ ቦድማ የስታ ዎልቀንካ ሶልምካ’፥ ጋይድንዴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ኮመረ ካምድንዳ ቃስትምስ ክተና፥ ‘የስታ የለንም የስታ ማታግንዳ ማስሶ ሶልምካ።’ ከትኬና ቃስተንናርንካ ስግድንዳ አብ ክታ ካዬ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ሙሴታ ህግንም ኤስዝድባበረ የሱሰም፥ “ኤስስንባቦ! ‘ሳብ ዋልቄ፥ ክታዘንከረ አብ ጮይስ ካዬ’ ጋይሶ የስ ኬዛንዳ ገቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ኮካንታ ኤድ ይንታ ቦድማ ቡደካ፥ ቦድማ ይንታ ሰንፔንካ ቦድማ ይንታ ገቅርንካ ቦድማ ይንታ ዎልቀንካ ሳብም ሶልማ ክትም ዝግዝዴ፥ ኮትኮግንደረ ይንታ የለንም ይንታ ማታግንዳ ሶልማ ክትም ዝግዝዴ፥ አችሶ ካሰርድንደትምከ አብ ካስነረ ሳብካንታ እምድንዘንካ ስክስሶ ከትኬና ቃስተን ክተንከስም ካርስና ስገዴ” ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","የሱሰረ ሙሴታ ህግን ኤስዝድባብ ኤጨከ በድ ገቅርካ ክት ማስሳንደትም ሰድሶ፥ “የና ሳብታ ባንችምናርንካ ጎተርስባብ ካየዬ” ክደር ጋይሴ። ኮታ ቡር የሱሰደር ኦይስካንታ ካርችስባብ Ꮊየነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","የሱስ ሳብታ ጭል ኤሄናር ኤስዝድዮ ኩን ጋይሶ ኦይሴ “ሙሴታ ህግንም ኤስዝድባብከስ ‘ክርስቶስ ዳዊትታ ይንችዬ’ Ꮊረተክ ጋይዳ? ");
INSERT INTO gyl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ዳዊት ይንታ ማታርንካ አያንይ ጭልንካ ኬዝድዮ፥ “ ‘ሳብ እስታ ጮይስንካንታ (ሳይምስባብካንታ)፥ የስታ ይምኤንባብከስም የስታ ዱትንታ ጎያር እ ማስተርን የለልታ እስታ ምዝንዘን ዶእካ’ ክትም ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ዳዊት ይንታ ማታርንካ ‘ጮይስ’ ጋይሶ ክት ኤልሳንካ ይና፥ ሳይምስባብ ዳውተታ Ꮊስግንድክ ይንች ማዳ?” በድ ዎርሰነረ ጉርምካ ኤሰርድዮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","የሱስ ኤስዝድዮ፥ “ቃልም አፍለንከስም ቆበርሰኮ ኦስከ ፈንካ ኦንገን፥ ጋባረረ ቦንችምሳን ሳራትቸን ተይካንታ ሶልምድባብ ሙሴታ ህግን ኤስዝድባብከዘንካ ካርስምከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ከታ አይሁድንከስታ ምክስ ኤሄናር ቦንችምሳን ጎንገንም፥ እቸርድን ካርዘነረ ቦንቺምሳን ካርም ዝግደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ኤድ ይምሰዳ ጋይሶ ከት ይድን ቃልማ ምክስንጎካ ገሰረኮ ከታ ክእስንከስ ደእስባብ ማነንከስታ ኤሄን ከታ ሪካይሳ ማዝደከ፥ ኮካንታ ከታዘን ስግዳን ፍርዳ የልተሬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","የሱስ እመን እመርድንደትጎካ ዶቅሶ ክት ዶቅድንካ ዎርሰና ኦይተርድንደታር ከት ብረን ኦይድንካ ሰድ Ꮊቄ፥ በድ ቆልመንክንባብከስ በድ ብራ ኦይድ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ዋልቃ ኤተን ቡድና ርካየንዳ Ꮊድሶ ዋልቃ ሳንትም ማድን ቃስተን ባከና ኮታር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","የሱሰረ ይንታ ካርንካ ጎርስምድባብከስም ኤልሶ፥ “ዶፈን የም ጋይድቴ፥ ብረን ሳንሰርድንደታር ኦይችባብ ኤድ ሙደንከሳርንካ ስክስሶ ኦይቻንዳ ናኮና ርካየንዳ ቡድነኔ። ");
INSERT INTO gyl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","አብንከስ ሙዳ ከት እምሳንዳ ከታ ዶቅድን ቆልመናርንካ ስጫንደትሜ፥ ናማቼ ሪካየንዳ ማትሶ ዶቅድዮ Ꮊረነረ ነክሳክዶቆ ይንታ ዶቅድንደትም ሙዳ እምሴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","የሱስ ሳብታ ጭል ኤሄናርንካ ዉድንካ ክታ ካርንካ ጎርስምድባብከሳርንካ ዋልቀና፥ “ኤስስንባቦ! ከትከነም ሰይንንከስምከ ሰይን ኤሄንከስም ሰድካ፥ በርእስዝድባብከሰኬ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","የሱሰረ ማስሶ “ከነም አንድር ሰይን ኤሄንከስም የና ሰዳዶቅዳ? ኬና ሰይንንከስ ሙዳ ዉልእምደኬ፥ ሰይን ሰይንዘን ከልምሶ ነገዳክዬ” ጋይሶ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","የሱስ ሳብታ ጭል ኤሄንታ የረየር ደብረዘይት ገቼንዘን ዶቅሶ ክት ዶቅድንካ ጴጥሮስ፥ ያይቆብ፥ ዮሀንሰከ እንድራሰካ ከታ ይንት የሱሰደር Ꮊድሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ኮና ርና ማድንዳ Ꮊንተረረ? ኮነረ ሙዳ ቦድካንታ የልድንካ ቃዉተና Ꮊራ? ይና ዎም የና ኬዝካ” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","የሱሰረ፥ “Ꮊየነረ የም ኮተርዝዳክንግንዳ ካርስምከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","በድንከስ፥ ‘እታ ክርስቶስቴ!’ ጋየሮ እስታ ላምንካ Ꮊተረኬ፥ በድ ኤድንከስመረ ኮተርስተረከ። ");
INSERT INTO gyl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","የንታ ላማር ዳም ዳምምድንከ ጎትንከረ ዳምትንደትም ኤሰርደቶ Ꮊይገቀቴ፥ ኮና ሙዳ ማትካንታ ነጋይንዴ፥ ማታጋካ ዳት በእንተና አክዬ። ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ዎርሰና ዎርሰንዘን፥ ባንችና ባንችንዘን አምተሬ፥ በድ ካርዘን ፍጨታ ጭጭከ ዳቅከ ማተሬ፥ ኬና ሙዳ እችር ማጠታ የድንታ ማተሬ”። ");
INSERT INTO gyl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“የተረ የንታ ማታ ካንታ ካርስምከቴ፥ ኤድንከሰረ ፍርደን ፋረድባብከስካንታ ስክስት የም እምተረኬ፥ አይሁድንከስታ ምክስ ኤሄናር የም Ꮊርተረከ፥ ማርካ እካንታ የ ማድንግንዳ እጎካ ዎርሰን ገችዝድባብከዝደርከ ባንችንከስታ እር ፋረድምካንታ ዎእተረቴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ኮና ሙዳ ማተርንደታ እሪ ማቼ ክላ ኬዘና ፍጫሙደንዘን ዎርሰንካንታ ሳባክም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ኤድንከስ የድሰኮ ፍርዳካንታ የም የልዝድንካ፥ ‘Ꮊሮንት ከስተራ?’ ጋይንትካ እርምሶ Ꮊይማጠረቴ፥ ኬዝድባብ አያንይ ጭልና ዳት የታ ካየቴ። ኮካንታ ኮት ሳዓትንካ የካንታ እምድንደትም Ꮊክ ኬዝከቴ ");
INSERT INTO gyl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","እስመና ይንታ እስመንም፥ ባበና ይንታ ይንችንም ደእ ካንታ ስክስት እምተሬ፥ ይንችንከሰረ አጥመንባብከዘን አምተረኬ፥ ከትም ደይስተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","እስታ ላምንካንታ ጋይሶ ኤድ ሙደንደር ቦስምስባብ ማተረቴ፥ በእንታ የለልታ ዳንዳእካ ዳቅድባብ ማቼ አቅተሬ”። ");
INSERT INTO gyl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ጉጅሰረ Ꮊፍር ዝግዝዳክን ካርዘን ካይስዝድን ቱና ር ሰተረቴ፥ ኮመረ ናበብድባብ ክት ገቅራ፥ ኮታይካ ይሁዳ ሞረናር ዶቅድባብከስ ገቼንከዝደር ከት Ꮊዛ። ");
INSERT INTO gyl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ኤሄንታ የለንዘን ዶቅድባብ Ꮊንቼርሶ ይንታ ኤሄናርንካ ዋልቃ ሪየረ ተይካንታᎺይ አርዳ፥ ");
INSERT INTO gyl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ዎን Ꮊምናርንባበረ ይንታ አፍለን ተይካንታ ቡር Ꮊይማታ። ");
INSERT INTO gyl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ኮትᎺይካ ማና ስርመንከስ ካንተከ አምን ጋእዝድባብከስካንታ አንድር ማጣ ማተረ! ");
INSERT INTO gyl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ኮና ሙዳ በርግካ ማተራክንግንዳ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ኮትኮ አርፈንካ ሳብ ፍጫ ሙደን ፍዛንደትዘንካ የችሶ ታ የለልታ ይምድንካ ሰድማክንዳ ማጣ ማተረ፥ ኦስ እረረ ኮትም ካምድንዳ ይምዳክንዳ ማጣ ኮታይካ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ጮይስ ከትከ ሰጨንከስም ጨቻክናና Ꮊየነረ አቃይ ዶቆ፥ ኬዛር ማቸ እድምስባብ ኤድንከስካንታ ጋይድንካ ኬና ሰጨንከስ ጬደኬ”። ");
INSERT INTO gyl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ኮታይካ Ꮊየነረ ማቸ ክርስቶስ ኮንሴ ኖ ካሬ! አነረ ኖ ኦኮታሬ! የም ጋይዴ Ꮊይ አሜነቴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ካርካ ክርስቶስንከሰከ ሳብዘንካ ኤሰራክዶቆ ኬዝድባብ ካርከንባብከስ Ꮊደኬ፥ ከታ ከትካንታ ማደስናና እድምስባብከስም ዎራ ኮተርስካንታ አተንምከ በርእስዝድን ርንከስም ይደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ኬዛር ማቼ ሙዳ ርን እርምስቶ የካንታ ከዝትቴ ይና ካርስምከቴ! ");
INSERT INTO gyl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ኮታይካ፥ ኮት ሙዳ ማጠንታ ቡር፥ Ꮊይና ኡምተሬ፥ አርፈነረ ይንታ ሳክመንም ሳክስተራክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","“ቤዝንከሰረ ጭለዘንካ ዋችተረኬ፥ ጭላር ዶቅድን ዎልቀንከሰረ ጭጭተረኬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ኮተረ ቡር ኤድ ይንች አንድር ዎልቀከ ቦንቸካ ኡፔካ ክት Ꮊድንካ ሰተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ይንታ ክታይንችንመረ ኦይዴ፥ ከታ ኦይድ ፍነካ አይሰኮ ፍጨታ ካንተዘንካ ጭለታ ካንታ የለልታ Ꮊፈርድባብ ሳብካ እድምስባብ ኤድንከስም ሳንዝደኬ”። ");
INSERT INTO gyl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ꮊቃ በለስንታ ካምስንከስታ ኤስስና የም አርዳ፥ እክመና ኮታ ፉርድንከ ቃምነረ ጮልድንካ ኮታይካ Ꮊስን የልሳንደትም ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ኮግንደረ የታ ኬና ሙዳ ማድንካ ሰደቶ ኤድ ይንች Ꮊድን ሰጨና ፍልተዘን የልሳንደትም ኤስከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ዶፈን የም ጋይድቴ፥ ኮና አጥርና ስገተርንደታ እር ኮና ሙዳ ቦድምዴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ጭለኬ ፍጨካ ስገደኬ፥ እስታ ቃለና ማቼ ስጋዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ኬዛር ማቼ ኮትኮ ሰጨንተኬ ኮትኮ ሳዓትንታ ሳብ ባቤንዘንካ አብ Ꮊሀየነረ ኤዝድባብ ካዬ፥ አብ ነግሶ ጭላር ክታይንችነረ ማታ፥ ይንችነረ ኤሳዬ። ");
INSERT INTO gyl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ሰጨና Ꮊንታ ማዳናንከረ የታ ኤሳይን ካንታ ካርስምክቴ፥ ዳእከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ኮነረ፥ ይንታ ኤሄንም ዛቅሶ ጎት ፍጫር አይስባብ ኤችንም ካምዴ፥ ኖየረ ዋልቃ ዋልቃ ፍክስንባብከስም Ꮊክ Ꮊክ ፍክስንዘን የችሴ፥ ካርሰንባበረ ዳቅሶ ክት ካርዝድንግንዳ ክትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“ኮካንታ ኤሄንባብ ክት Ꮊድንደት ሰጨን የ ኤዝዳክንካንታ ካርስምከቴ፥ Ꮊረንግርከረ ሶይት፥ አነረ ገልትገር፥ አነረ ባቻ ቅቅድንካ፥ አነረ ዛማ ገልትናር Ꮊዳ ዶቅተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ኤችና ፉትን ጋይሶ ክት Ꮊድንካ የ ራትሶ ዶቅድንካ Ꮊብዳክንግንዳ ዛብከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","የካንታ እ ኬዛንደትግንዳ አብንከስካንተረ ሙዳ ኬዝድቴ፥ ዛብከቴ! ጋይድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ፋስገኬ ባይስ ባአልን ቦንችካንታ ቃስተን ሰጫ ነገድንካ ቄሰንከስታ ገችንባብከስኬ ሙሴታ ህግንም ኤስዝድባብከሰ የሱሰም ጩበካ ይ የድንደትምከ ይ ደይዝድንደትም ጎግ ዝግድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ኬዛር ማቼ ዎርሰና ዋጭማ አምሳይንግንዳ “ባአል ሰጨንታር ማት ዝክሳዬ” ጋየሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","የሱስ ብታንያ ሞረናር እጳ ሰቅምንክንባብ ስምኦነታ ኤር Ꮊቄ። እችምዘን ክት ዶቅድንካ፥ ዋልቃ ኤተን አንድር ስንጋ ማቻንደትከ ጭልሰርሳን ናርዶስ ጋይምድን Ꮊቀንዘንካ ፍክስምሳንዳ ዎዝድንደትም አልባስጥሮስ ብልቃትንካ የት Ꮊዴ፥ ብልቃትንም ድክስሶ ዎዝድንደትም የሱሰታ ማተንዘን ና ዉልእሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ኮታር Ꮊቅባብከሳርንካ ዋልቃ ዋልቀንከስ ኮታ ይተንካ ዋጭሰኮ፥ “ኮ ዎዝድንደትም ዉችኩን ባችና Ꮊረተረ? ");
INSERT INTO gyl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ኮና ዎዝድንደና ማከን ጸታ ጣገራ ብርርዘንካ ስግ ሰንምሶ ብረና ሪካየንባብከስ ካንታ እምምሳ ናና ኡርማ ዶቆ!” ክክ ጋይሰኬ፥ ኤተንንመረ ቦሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","የሱስ ማቼ፥ “ኮትም ዛእከቴ! Ꮊረተንት ኮትም ዘርዝዳ? ና እካንታ ኡርማ ር ይቴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ሪካየንባብከስ ሙዳᎺይካ የንካ ክክን ከት ማቻንካንታ የ ዝግዛንᎺይካ ኡርመን ከትካንታ ይካንታ ማደቴ፥ እታ ማቼ ሙዳᎺይካ የንካ ክክን ዶቃይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ኮና ኤተና ይንደር ማድንደትም ና ይቴ፥ እስታ ዋሄና ዱክምተርንደታ እርምሶ ግክስካንታ ዎዝድንደትም ና ሳይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ዶፈን የም ጋይድቴ፥ ኮ ፍጫሙደንዘን ኮና ክላ ኬዘና ሳባክምድን Ꮊምንካርዘነረ፥ ኮና ኮት ይሳንደና ገቀርዝድንዳ ማተሮ ኮትጎካ ኬዝምዴ” ከደር ኩንጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ታመኬ ቃስተንናርንካ ዋልቀና አስቆሮንት ፍጨናርንክንባብ ይሁዳ የሱሰም ስክስት እምካንታ ቀሰንከስም ገችዝድባብከዝደር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ከተረ ኮም ኤሰርሳንደትካ ከትም ጉርምሴ፥ ብረረ ክትም እማካንታ ኤእሰኬ። ኖየረ የሱሰም ስክስት እማካንተረ ኡርድን ሰጨም ካርሰሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ፋስገንታ ቆለን ከት ማጅድንዳ ባይስ ባልንታ እር ሰጨንካ፥ ክታካርንካ ጎርስምድባብከስ የሱሰደር Ꮊድሰኮ፥ “ፋስገንታ ሶይት እችምን እችካንታ Ꮊብር ዎ ግግዝድንግንደስ ዝግዳ?” ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","የሱሰረ ይንታ ካርንካ ጎርስምድባብከሳርንካ ቃስተንን ኩንጋይሶ ከትም ኦይቼ፥ “ካተመናር አይከቴ፥ ኮታረረ ዳሀካ ሎቃ ባልስባብ ኤችም Ꮊብደቴ፥ ክትም ጎርስምከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ክት አርድን ኤሄናረረ አይሰቶ ኤሄን ባብም፥ ‘ኤስስንባብ፥ እስታ ካርንካ ጎርስምድባብከስካ ክክን ፋስገንታ ሶይት እችምን እ እጅድንደታ እካንታ ማድንዳ ሶችታ Ꮊዉስንታ ኤሄና Ꮊምነረ?’ ጋይዴ ክደር ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ኖየረ ኤሄታዘን ዎደርሳን ኤሀ ዶቅድንደትም ግክሰርሳንደትኬ ታከረርሳንደትም ሳክማ ኤሀ የም ሰችተረ፥ ዋር ዎካንታ ግግስከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ቃስተና ክታ ካርንካ ጎርስምድባብከስ ኮታርንካ ዉትሰኮ ካተማናር አይሰኬ፥ ገታ የሱስ ከትም ጋይሳንግንደረ Ꮊፍሰኬ፥ ፋስገንተረ ሶይት እችምን ኮታር ግክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ፍጨና ሶይችንካ የሱስ ታመኬ ቃስተንንከስካ ክክን Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","እችምዘን ከትዶቅድንካ የሱስ፥ “ዶፈን የም ጋይድቴ፥ የንታ ዎክያርንካ ዋልቀና እም ስክስት እምተሬ፥ ኖየረ ታ እንካ ክክን ሶይት እችምንዘን ዶቅዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ከተረ ኮ ኬዘንካ ሞርእሰኮ “እታ ማትትዳቶ?” ጋየረኮ ዋልቃ ዋልቃ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","የሱሰረ፥ “ኖኮና ኤችና የ ታመከ ቃስተንናርንካ ዋልቀና እንካ የካ አንንም ጋበትናር ኦይድባቤ። ");
INSERT INTO gyl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ኤድ ይንች እምሶ ክትጎካ ጻፈርሳንደት ደእና ክታ ነጋዬ፥ ኬዛር ማቼ ኤድ ይንችም ስክስት እምድባብ ክትኮ ኤችንካንታ የኤ! ኖኮና ኤችና አጠማከስ ናና ኡርማ ዶቆ!” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ከታ እችምዘን ዶቅድንካ ሶለንም አምስትዮ አንጄ፥ አስተረ ይንታ ካርንካ ጎርስምድባብከስካንታ እምድዮ “ይኤቴ፥ ኮና እስታ ዋሄኔ” ጋይሶ ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ኡፍተንም አምስሶ ጋለትሶ ከትካንታ እምሴ፥ ሙደነረ ኡፍተናርንካ ዎጨኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","የሱሰረ፥ “ኮና በድንከስካንታ ውልምድንዳ እስታ ጫቃ ማቀሴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ዶፈን የም ጋይድቴ፥ ሳብ ባንችምናር ክላ ዎይን ዎጭምን እ ዎጭተርን የለልታ ኮ ዎይንንታ ዎጭምን ቦድሶ ዎጫይቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ኮታዘንከረ የችንም የችሰኮ ደብረዘይት ገቸንዘን ዉተደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","የሱስ ይንታካርንካ ጎርስምድባብከስካንታ፥ “ ‘ግስመንባብም ጉጵድቴ፥ ቆልንከሰረ ይጭምደኬ’ ጋይምሶ ጻፍምሳንግንዳ የታ ሙደነረ፥ እንካ ኮተርተረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“ኬዛር ማቼ ደእያርንካ እ አምሳንደታ ቡር የም እርምስቶ ገሊላ ካተመናር አይድቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ኮታይካ ጴጥሮስ “አብንከስ ሙዳ ዎራ የስካ ከት ኮተርዴ፥ እታ ቦድሶ የስካ ኮትራይቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","የሱሰረ “ዶፈን የስም ጋይድቴ፥ ኮ ሶይትናር ባቻ ቃስተን ዱት ቅቅተርንደታ እር ማከን ዱት እም ካተራዬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ጴጥሮስ ማቼ “ደእ ዎራ ዝክሴ የስካ ክክን ደእድት ዳት ቦድሶ የስም ካዳይቴ!” ጋየሮ ዳቅስሶ ኬዜ። ነገድባብከሰረ የሱሰታ ካርንካ ጎርስምድባብከስ ኮትግንዳ ጋይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ኮተረ ቡር ገተሰማን ጋየርድን ካርንዘን አይሰኬ፥ የሱስ ይንታ ካርንካ ጎርስምድባብከስም፥ “እ ኦኮታር ምግዝድንካ የታ ኮዘን ዶእከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ጴጥሮስምከ ያይቆብም ዮሀንሰመረ ጎርስሶ አይሴ፥ ኮታረረ አንድር ሞርኤሮ ማጥር የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ኮታዘንከረ “እስታ ሰንፐና ደእ የለልታ አንድር ሞርእሴ፥ ኮዘን ዶእከቴ፥ ዳቅሶ ካርስከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ከታዘንካ መራ ጎተርሶ አይሴ፥ ፍጨዘነረ ይንታ ባለንካ ጉፕን ጋይሶ የዝደር ማድንዳ ማቼ ናኮና ሳዓትና ክታዘንካ ስገድንግንዳ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“እስታ ባበኖ፥ ሙዳ ርና የስካንታ ማዴ፥ ኮም ማጠንታ ኡፍተን እዘንካ አምስካ፥ ኬዛር ማቸ የስታ ጋይተንግንዳዳት እስታ ጋይተንግንዳ Ꮊይማታ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ይንታ ካርንካ ጎርስምድባብ ማከንንከዝደር ማትሶ ክት Ꮊዳንደትካ፥ ራትሶ ዶቅድንካ ከትም Ꮊፍሴ፥ ኮካንታ ጴጥሮስም፥ “ስምኦኖ፥ የና ራታ? ዋልቃ ሳዓት ዎራ ንግሶ ዶቅ የስም ጋምሶ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ይና የ “ጰጫር አርተራክንግንዳ ዳቅሶ ምክስከቴ፥ አያንና ግግምቴ፥ ዋሄና ማቸ ጋፍሳንዴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ካርንከረ አይሶ እር ይ ምክሳንደትም ካርንካ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ጉጅሰረ ማት ክት Ꮊድንካ፥ አፍና ከታ ግንእካ ደጭንካ ራትሶ ከትዶቅድንካ Ꮊፍሴ፥ ክትካንታ ከታ ይ ማዝድንደትም ኤሳይ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ማክምስ ዱት ከደር Ꮊድሶ፥ “ታየረ ራትሰንት ዶቅዶ? ታየረ ኡክንተረቴ? ይና ማተረ! ሳዓትና የልቴ! ኮሰቸቴ! ኤድ ይንች ጎመንባብከስታ አንያር ስክስምት እምምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ይና አምከቴ! ሙከቴ! ስክስትን እም እምድባብ Ꮊቴ!” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","አክ የሱስ ኮም ክት ኬዘዘን ዶቅድንካ ታመከ ቃስተንከሳርንካ ዋልቀና ይሁዳ Ꮊዴ፥ ክትከረ ክክን ማሰከ ጉፈካ የጅባብ በድ ኤድንከስ Ꮊቀኬ፥ ከተረ ቀሰንከስም ገችዝድባብከሳርንካ፥ ሙሴታ ህግንም ኤስዝድባከስከ፥ ቡጫ ጋልተንከዝደርንካ ኦይትምስባበኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ስክስት እምድባበረ ይሁዳ፥ “የታ የ የድባብ እታ አቦ ጋይስቶ እ ሶንቅድባብመ፥ ክትም ካርስምሰቶ የድሶ አይከቴ”፥ ጋይሶ ቃዉታ ከትካንታ ኖ ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ይሁዳ ሳነካ Ꮊድሶ የሱሰደር ቅንችሶ፥ “ኤስስንባቦ!” ጋይሶ ሶንቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ኮታ ቡር ኤድንከስ የሱሰም የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ኮታር ዎእሶ Ꮊቅባብከሳርንካ ዋልቀና ማሰንም ጎችትዮ ቀሰንከስም ገችዝድባብታ ፍክስንባብታ ቃምንም ተቼ። ");
INSERT INTO gyl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","የሱሰረ፥ “ማሰከ ጉፈከ የድሰቶ የ Ꮊዳንዳ እም ፋንገንከስግንዳ የድካንቶ? ");
INSERT INTO gyl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ሰጭንካ ሰጭንካ ሳብታ ጭል ኤሄናር እ ኤስሰርቶ የንካ ክክን እ ዶቅድንካ እም የዳከቴ፥ ኬዛር ማቼ ኮና ማቻንዳ ጭል ማጻፍንከስታ ቃለና ቦድምድንግንዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ኮታዘንከረ ክታካርንካ ጎርስምድባብከሰረ ሙደና ክትም ዛቅሰኮ አጥምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","አፍላ ላጠና Ꮊክ ቆበርስባብ ዋልቃ ማርንድ የሱሰም ጎርስመሮ Ꮊቄ፥ ኤድንከሰረ ክትም የጃንደትካ ");
INSERT INTO gyl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","አፍለን ላጠነን ዛቅሶ ዘና ጫለንካ Ꮊዝሶ አጥምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","የሱሰም ማቼ ቀሰንከስም ገችዝድባብደር ተይ አይሰኬ፥ ኮታረረ ቀሰንከስም ገችዝድባብከስ፥ ጋልተንከስከ ሙሴታ ህግንም ኤስዝድባብ ከስ ሙደና ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ጴጥሮሰረ ቀሰንከስም ገችዝድባብታ ጋስናር የለልታ የሱሰም ጎትካ ጎርስምድ Ꮊቄ። ኮታረረ አብንከስካ ክክን ዶቅሶ ኖሀ ኦይጠርድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ቀሰንከስም ገችዝድባብከስኬ ቡጫ ጋልትንከስ ሙደና የሱሰም ደይስስካንታ ማርካ ዝግድ Ꮊቀኬ፥ ማችንከረ Ꮊፋከኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","በድንከሰረ ካርከካ ክታዘን ማርከርሰኬ፥ ማችንከረ ከታ ማርከርና ዋልቃ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ዋልቃ ዋልቀንከሰረ አምሰኮ ኩን ጋየረኮ ካርከካ ክታዘን ማርከርሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“እታ ኮም ኤታ አንካ ዎድምሳንደትም ሳብታ ጭል ኤሄንም ዉልእስቶ ማከን ሰጫር አብ ኤታ አንካ ዎድማክንደትም ዎድቴ ጋይሶ ክት ኬዝድንካ ዎታ ኤሰርቶቴ።” ");
INSERT INTO gyl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ኩን ከት ጋይስንከረ ከታ ማርክርና ዋልቃ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ቀሰንከስታ ገችንባበረ ከታ ዎክያር ዎእሶ፥ “ዋልቃ ሪየረ ማሳያ? ከናኤድንከስ የስታዘን ከት ማርከርድንዳ Ꮊራ?” ጋየሮ የሱሰም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","የሱስ ማቼ ጫምን ጋይሳ ዳት Ꮊረነረ ከደር ማሳክዬ። ቀሰንከስም ገችዝድባበረ “አንጅምስባብ ሳብታ ይንች ሳይምስባብና የኖ?” ጋየሮ አናካርንካ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","የሱሰረ “ይዬ፥ እትቴ፥ ኤድ ይንች ሳብታ ምዝዘን ዶቅስንካ ሰተረቴ! ኮትኮግንደረ ጭለዘን ኡፔካ ማት Ꮊድንካ የታ ሰተረቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ቀሰንከስታ ገችንባበረ ዋጭካ ይንታ አፍለን Ꮊእስሶ “አብ ማርካ Ꮊራ ዝግዝዳ? ");
INSERT INTO gyl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ኮሰቸቴ! ኮም ሳብዘን ዎራ ክት የግድንካ ኤሰርተቴ፥ ይና የም Ꮊሮክ ካሜ?” ጋይሴ። ሙደነረ ዋልቃ ኡፍስካ፥ “ደእ ክትም ዝግዝዴ!” ጋይሰኮ ክታዘን ፋረጀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ዋልቃ ዋልቀንከሰረ ከታ ይንታ ፈጭምን ክታዘን ፈጭምተሮቴ ጋይ የጀኬ፥ ክታ አፍንመረ አፍለካ ዞክሰኮ “የና ሳብዘንካ ኤሰርሶ ኬዝድባብ የስ ማቼ ይና የስም Ꮊይ ጉጵሳናንከረ ኤስካ!” ጋየረኮ ክትም ቱንከሮ Ꮊቀኬ። አብንከሰረ ክትም ጫቀረኮ ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ጴጥሮስ ቀሰንከስታ ገችንባብታ ኤሄንታ ታመርጎካ ጋስንታ ዋር ክት ዶቅድንካ ቀሰንከስታ ገችንባብታ ፍክስንባብከሳርንካ ዋልቀንዳ Ꮊዴ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ናየረ ጴጥሮስ ኖሀ ኦይጠርድንካ ፍስሳ ክትም ሰድስንደትከ “የነረ ናዝረታርንባብ የሱሰካ ክክን Ꮊቀዬ”፥ ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ጴጥሮስ ማቼ “እታ ኤሳይቴ፥ የስ ጋይድንዳ እም አርዳዬ”፥ ጋየሮ ካጄ። ኮመረ ጋይሶ ማል ክት ዉተዳንግንዳ ባቻ ቅቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ና ፍክስንንደረ ጴጥሮስም ሰድሶ፥ ዋር ዎእስባብከስካንታ “ኖ ኮነረ ከታ ኮችናርንከ!” ጋየሮ አነታ ና ኬዛ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ኖ ማቼ አናካርንካ ካጄ። Ꮊዉእሳ ክት ዶቅሳንደታ ቡር ኮታር ዎእስባብ ኤድንከስ ጴጥሮስም፥ “ገሊላ ኤድ የስታ ማትንተና ገታ የስታ ኬዘንካ ኤስምደዬ፥ ኮካንታ ዶፈን የነረ ከታ ኮችናርንከዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ኖ ማቼ “ኮም የ ጋይድባብ ኤችንም ኤሳይቴ!” ጋየሮ ይንታ ማተን ባደሮ ጫቃ የጄ። ");
INSERT INTO gyl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ሳነካ ባቸና ቃስትምስ ዱት ቅቅሴ፥ ጴጥሮሰረ “ባቻ ቃስተን ዱት ቅቃክናና ማከን ዱት እም ካተራዬ” ጋይሳንዳ የሱሰታ ቃለና ክትም ከልቅን ጋይሴ፥ ኮታዘንክሬ ቡዳርንካ ኤፍሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ዛማ ሰጭማ ቀሰንከስታ ገችንባብከስ ጋልተንከሳርንካ፥ ሙሴታ ህግንም ኤስዝድባብከሳርንካ፥ ቡጫ ጋልተንከስካ ሙዳ ክክን ዙዝምሰኬ፥ ኮተረ ቡር የሱሰም የችስት ጵላጦስካንታ ስክስት እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ጵላጦሰረ “አይሁድንታ ባንችና የኖ?” ጋይሶ ኦይሴ። የሱሰረ “የስ ጋይሳንግንዴ”፥ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ቀሰንከስታ ገችንባብከስ ማቼ የሱሰም በድካ ማእዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ኮካንታ ጵላጦሰረ “መም ሪካ የስም ካሰዝዳናንከረ ሰድካ! ቦድሶ ዋልቃ ሪየረ ማሳያ?” ጋየሮ አናካርንካ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ጵላጦስ በርእተርን የለልታ ታየረ የሱስ Ꮊረሰረ ማሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ጵላጦስ ስለዘን ስለዘን አይሁድንከስታ ፋስጋ ባአልንᎺይካ ቡልምድንግንዳ ኤድንከስ ኦይስባብም ዋልቃ ዞከርስባብም ብልድንደታ ዎጋ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ኮታይካ ዳቀልስም አምስስሶ ሰንፓ ደይስሶ ዞከርስባብከሳርንካ ዋልቀና ባርባን ጋይምድባብ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ዎርሰነረ ጵላጦሰደር Ꮊድሰኮ ከታ መጠንግንዳ ከትካንታ ይድንግንዳ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ጵላጦሰረ “አይሁድንታ ባንችንም ቡልት እ ኦይድንግንዳ ዝግደቴ?” ጋይሶ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ኮመረ ክት ጋይሳንዳ ቀሰንከስም ገችዝድባብከስ የሱሰም ስክስት ከት እምሳንዳ ቀምስካ አምሶ ማትንተን ይ ኤዝድንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ቀሰንከስም ገችዝድባብከስ ማቼ፥ “የሱስ ቡልምድንዘንካ ባርባን ዎካንታ ብልምድንግንዳ” ጋይሰኮ ጵላጦሰም ከት ኦይዝድንግንዳ ዎርሰንም አምስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ጵላጦሰረ፥ “ይና፥ ኮም አይሁድንታ ባንችን የ ጋይድባብም Ꮊስስ ይቴ?” ጋይሶ ኤድንከስም ካርንካ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ከተረ “ክትም ሮካ!” ጋየረኮ አነታ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ጵላጦሰረ “Ꮊረታ? ክት ይሳንዳ ባችና Ꮊራ?” ከደር ጋይሴ። ከታ ማቼ “ክትም ሮካ!” ጋይሰኮ እርንደትዘንካ ስክስሶ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ጵላጦስ ዎርሰንም ጉርምስካንታ ጋይሶ ባርባንም ከትካንታ ቡልሴ፥ የሱሰም ማቼ Ꮊርችሶ ሮከርድንግንዳ ስክስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ፖልስንከስ የሱሰም ፍጨን ገችዝድባብታ ፕራይቶርዮን ጋይምድባብ ባንችንታ ኤር ጋስናር ተይ አይሰኬ፥ ነግድባብ ፕሆልስንከስመረ ሙዳ ኤልሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ዘይም አፍለረ ክትም ቆፍሰኬ፥ ጋልታ ዛዉዳ ላጭሶ ክታ ማተንዘን ጉፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ኮታዘንከረ “አይሁድንታ ባንችኖ! ዎዜ ካዉታ ማታ!” ጋየረኮ Ꮊልተርካ ጎይንድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ጉፈካ ክታ ማተንም ጉጵሰኬ፥ ይንታ ፈጭምነረ ክታዘን ፈጭምሰኬ፥ ክታ እረረ Ꮊልተርካ ጉምፈረረኮ ክትካንታ ጎዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ከታ ይ Ꮊልተርሳንደታ ቡር ዘይም አፍለንም ክታዘንካ ዉችሰኮ፥ ክታ አፍለንም ቆፍሰኬ፥ ክትም ሮክካንታ ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ከት አያዶቅድንካ ቀረና ፍጫ ኤች ማችባብ አላክሳንደርተከ ሩፎስታ ባበና ስምኦን ካተማ ካየናርንካ ክት Ꮊድንካ Ꮊፍሰኬ፥ የሱሰታ ማዝቀልንም ክት ባልድንግንዳ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ኮተረ ቡር የሱሰም ኮታ ቡልና ራስቅል ጋይምሳን ጎልጎታ ካርያር ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ኮታረረ ከርበ ጋይምድንደትካ ቡቅምሳንዳ ዎይንንታ ዎጭምንም እምሰኬ፥ የሱስ ማቼ ዋይት ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ኮተረ ቡር ክትም ሮክሰኬ፥ የሱስታ አፍለንመረ Ꮊይ ተይተር ናንከረ እጫ ዛቅሰኮ አፍለንም ካስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","የሱሰም ከት ሮግድንካ ሳዓትና ዛማ ማከን ሳዓት Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ካሰስንታ ጻፈርሳንደረ “አይሁድንታ ባንችን” ጋይድንዳ ጻፍምታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","የሱሰካ ክክን ቃስተን ፋንገንከስም ተይᎺድሰኮ ዋልቀንም ክታ ምዝዘን ዋልቀንመረ ክታ ብተዘን ሮክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ኮግንደከረ “ባችንባብከስካ ክክን ፋይድምሴ” ጋይድንዳ ማጻፍናር ጻፍምሳንዳ ቃለና ቦድምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ኮት ጎግንካ ክታ ላመከረ ስገሮ Ꮊቃን ኤድንከሰረ ክትም ቶቸካ ከታ ይንታ ቃደንም ረክሰረኮ ኩን ጋየረኮ የግድ Ꮊቀኬ፥ “ኤቦ፥ የና ሳብታ ጭል ኤሄንም ዉልእሰዮ ማከን ሰጨካ ዎድቴ ጋይድባብና! ");
INSERT INTO gyl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ይና ታ ማዝቀልንዘንካ Ꮊንቸርሰዮ የስታ ማተንም የስ አቅስኔ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ኮግንደካ ቀሰንከስም ገችዝድባብከስኬ ሙሴታ ህግንም ኤስዝድባብከሰረ ክክ ክክ ኩን ጋየረኮ ክታዘን Ꮊልተርድ Ꮊቀኬ፥ “አብንከስም አቅስቴ፥ ይንታ ማተንም ማቸ አቅስካንታ ማታዬ! ");
INSERT INTO gyl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ኖ ክርስቶስ እስራኤልንታ ባንችን ይ ማቼ ማዝቀልንዘንካ ክት Ꮊንቸራ፥ ዎተረ ሰድስንደትከ ዎ አሜና!” ኮትኮግንደረ ክትካ ክክን ሮከርስባብ ክትም የግድᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ሰጨና ላ ሳዓት ማቻንዘንካ የድሶ ሳክላ ሳዓት የለልታ ፍጫሙደንዘን ኡም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ሳክላ ሳዓትንዘን የሱስ “ኤሎሄ! ኤሎሄ! ላማ ሳበቅተን?” ጋይሶ ፍፍሴ። ኮታ ቡልነረ “ጮይስዮ፥ ጮይስዮ! Ꮊረተስ እም ዛቅሳራ?” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ኮታር ዎእሶ Ꮊቅባብከሳርንካ ዋልቃ ዋልቀንከስ ኮም ኤሰርድንካ፤ “ኤላሰም ኤልዳ ማደ” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ከታርንከረ ዋልቀና ዞድሶ ጫቅምድንደትም ስፎንግ ጋይድንዳ ዳልች ሎቃ የድንግንዳ የጃንደትም ጉፈታ ታጰካ ክት ዎጭድንግንዳ የሱስካንታ እምሶ “ይና ገታ ኤላስ Ꮊድሶ ክትም Ꮊንጅድንዳ ማቸረ ዎሰዳ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ኮተረ ቡር የሱስ አንድር ኡፍስካ ፍፍሴ፥ ክታ ሰንፔነረ ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ሳብታ ጭል ኤሄንታ ስፍስንደና ፈይንካ ሶ የለልታ Ꮊእሶ ቃስቴን ፋስምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","የሱሰካ የረየር ዎእሶ Ꮊቅባብ ፖልስንከስታ ገችንባብ ኮግንዳ ፍብድንካ ሰንፔና ክታ Ꮊስግንዳ ዉተዳናንከረ ይ ሰዳንደትካ፥ “ኮና ኤችና ዶፈን ሳብታ ይንች Ꮊቄ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ኮታይካ ጎትካ ማትሰኮ ሰድባብ፥ ዋልቃ ዋልቃ ማነንከሰረ ኮታር Ꮊቀኬ። ከተረ ዎክያርንካ መግደላ ፍጭንካ Ꮊዳንዳ ማራማ፥ ካንስ ያይቆበተኬ ዮሰታ እንደን ማራማ፥ ኮትግንደረ ኤተን ሰሎም ጋይድንዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ኬታ የሱስ ገሊላር ክት Ꮊቃንደትካ ጎርስመረኮ ክትካንታ ፍክሰረኮ Ꮊቀኬ። ኮትኮግንደረ የሱሰካ ክክን የሩሳሌማር Ꮊድባብ በድ አብ ማነንከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ፍጨና ሶይቻንካንታ አይሁድንከስታ Ꮊዉስ ሰጨና Ꮊድሶ የልድንካ ግግምተረ ሰጫ ማቼ፥ ");
INSERT INTO gyl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ኮታይካ አይሁድንከስታ ቡጫ ጋልተንከስታርንካ ዋልቀና ዮሴፍ ጋይምድባብና ቦንችምስባብ አርማትያስ ፍጨናርንክንባብ ኤች Ꮊዴ። ኖየረ ሳብታ ባንችምን ጉርምካ ካርዝድባብ Ꮊቄ። ሙቅምካ ጵላጦሰታ እር Ꮊድሶ የሱሰታ ለይስን እምድንግንዳ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ጵላጦሰረ “Ꮊስግንድክ ኮግንዳ ሳነካ ደእሳሬ?” ጋይሶ በርእሴ። ፖልስንከስም ክድባብም ኤልስሶ “ገታ ደእስንካ ዶቅቶ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","የሱሰታ ደእንም ፖልስንከስም ክድባብዘንካ ይ ኤሰርሳንደታ ቡር የሱሰታ ለይስንም ዮሰፍካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ዮሰፈረ ዱክታ አፍላ ሰንሴ ለይስንም Ꮊንችሶ አፍለንካ አክሳንደታ ቡር ላዝይ ሰይን ቆቀርሳንደታር ዱክሴ። አንድር ሰይንመረ ቡከልስት ዱክንታ ፍልተን ዝጬ። ");
INSERT INTO gyl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","መገደላ ፍጨናርንዳ ማራመትኬ ዮሰታ እንደን ማራመካ የሱሰም Ꮊብር ከት ዱክሳናንከረ ከታ ሰድዮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","አይሁድንታ Ꮊዉስ ሰጨና ስግዳን ቡር ማግዶላ ፍጨናርንካ Ꮊዳንዳ ማራማ፥ ያይቆበታ እንደን ማራመትኬ ሳሎመከረ ክክን Ꮊድሰኮ የሱሰታ ለይስንም ሳይካንታ ዎዝድንደትም ሰንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ሳምንትንታ እር ሰጨንታ ዛማ ሰጭመናር፥ አክ Ꮊይ ዉተዳንግንዳ ዱክናር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ከተረ “ሰይንንም ዱክንታ ፉልተንዘንካ Ꮊይ ዎካንታ ቡከልስተራ?” ጋይንተካ ክክ ከዝምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ኮመረ ከት ጋይሳንዳ ዱክና ዝጭምሳን ሰይንና አንድር ባካ ማቻንካንቴ፥ ጬክን ጋይሶ ከት ሰድንካ ሰይንና ቡከልስንካ ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ዱክናረረ ከት አርድንካ ሮጵድን አፍላ ቆበርስባብ ሰከን ምዝዘንጎካ ዶቅሶ ክት ዶቅድንካ ሰድሰኮ አንድር ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ኖ ማቼ፥ “ዛብከቴ፥ Ꮊይ ጳሰቴ፥ የ ዝግድባብ ሮከርስባብ ናዝረት የሱሰም ማቻንደትም ኤዝድቴ፥ ኖ አምቴ፥ ካሪ ካዬ፥ ኮሰቸቴ ክት ዱከርሳን ካርነረ ኮንሴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ኬዛር ማቼ አይሰቶ ክታ ካርንካ ጎርስምድባብ ጴጥሮስካንታ ‘ገሊላር ኖ እርምሶ አይዴ፥ ኮታረረ ክትም ሰተረቴ’ ጋይሰቶ ከትካንታ ኬዝከቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ማነንከሰረ ጳስካ ጭጨረኮ ዱክናርንካ ዉትሰኮ Ꮊዘኬ፥ አንድር ከታ ይ ጳሳንካንታ Ꮊረሰነረ ር Ꮊየሰንካንታ ከዛከኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","የሱስ ሳምንትንታ እሪ ሰጨናይካ ሰጭማ ዱክናርንካ ይ አምሳን ቡር፥ እርምሶ ታብዛ ግምዘንም ይ ዉችሳን ኤተን ማግደላ ፍጫርንደት ማራማ ካንታ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ናየረ አይሶ፥ የሱሰካ ክክን Ꮊቅባብ ሞርእዘንኬ ኤፍዘን ዶቅድባብከስካንታ ና ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ከተረ ሰንፔካ ክት ማቻንደትምኬ ኮትካንተረ ክት Ꮊፈርሳንደትም ኮት ኬዝንከረ ኤሰርሰኮ አሜናከኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ኮተረ ቡር ካተማ ካየንደታር አያዶቅድባብ ቃስተን ክታካርንካ ጎርስምድባብከስካንታ የሱስ አብ ኤድም ካምሶ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ከተረ ማትሰኮ ነግድባብ ክታ ካርንካ ጎርስምድባብከስካንታ ኬዘኬ፥ ክታ ካርንካ ጎርስምድባብከስ ከትመረ አሜናከኬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ኮተረ ቡር ታመከ ዋልቀንከስና እችምዘን ከትዶቅድንካ የሱስ ከትካንታ መያ ማቼ፥ ኬዛርካ ማቼ “የሱስ ደእናርንካ አምሶ ሰንፔካ ዶቅዴ ጋይሴ፥ ዎታ ዎንታ አፍከረ ክትም ሰቶቴ” ጋይሰኮ ከትካንታ ከዝባብከስም አሜናክንካንተኬ ከታ ጫልንጎካ Ꮊግዜ። ");
INSERT INTO gyl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ኮታዘንከረ፥ “ፍጫ ሙደናር አይከቴ፥ ፍዝር ሙደንካንታ ክላ ኬዘንም ሳባከቴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","አመንስባብከኬ ስኤርስባብ አቅተሬ፥ አመናክባብ ማቼ ፋረድምተሬ። ");
INSERT INTO gyl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","እንካ አሜንድባብከስ ሙደና ኬና ቃዉተን ይተረኬ፥ እስታ ላምንካ ግምዘንከስም ዉችተረኬ፥ ክላ አፋ ከስተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ጉንንከስም ይንታ አንካ የተረኬ፥ አነረ ደይዝድን ር ዎጨረ ከትም ቦድሶ ኡፈልስተራክዬ፥ ከታ ይንታ አንንመረ Ꮊዘርስባብታዘን ዎተረኬ ከተረ ፋጭተረኬ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ጮይስ የሱስ ኮም ሙዳ ከትም ይ ኬዛንደታ ቡር ፈስ ጭላር አይሴ። ሳብተረ ምዝንዘን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ኮታዘንከረ የሱሰታ ካርንካ ጎርስምድባብከስ ዉትሰኮ ካሪ ሙደናር ሳባክሰኬ፥ ጮይሰረ ከትካ ክክን ፍግዝድ Ꮊቄ። ከት ኤስዝድንግንደረ ቦድምድን ቃዉተን ይንታ ቃለንካ ዳቅዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ቦንችምስባብ ቶፍሎስዮ፥ ዎንታ ዎክያር ቦድምሳን ሪንከስም መይምዝድንዳ ኤንገር ፍክስምሶ ስገዳንደትም ኮታ ኤና እር በድንከስ ጻፍተኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ኮትኮ ክተንም ዎካንታ የልስስባብከስ እርንደትዘንካ አምስሶ አፍካ ሰድሰኮ ማርካ ማችባብከስኬ ቃለንም ኬዛቅባብከሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ኮትኮግንደረ እታ እርንደትዘንካ አምስስቶ ሙዳ ሪን በድ ኤግዝምካ ፋስት እ ኤሳንቡር ፍክስምሶ ስገዳንደትም እርንደትም እሪ፥ ቡርንደትመረ ቡር ማስስቶ የስካንታ እ ጻፍተርንግንዳ ኡርማ ማችንካ ሰድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ኮመረ እ ይሳንዳ የስ ኤሳን ኤስስና ዶፈን ማትንተን የስ ኡርስት ኤስተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ሄሮድስ ይሁዳ ፍጨንታ ባንችን ክት ማቻን ስለናር፥ ኤና እሪ አብያ ቀስ ማትሶ ፍክሳᎺቃንደትም ፍግዝድባብ ዛከርያስ ጋየርድባብ ቄሳ Ꮊቄ። ክታ ኬነነረ አሮነታ ሱሳርንካ አጥርምሳንዳ ኤልሳበጥ ጋይምድንዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ከታ ቃስተነረ ሳብታ እር ጭል ማትሰኮ Ꮊቀኬ፥ ጮይስንተረ ክተንምኬ ዎገንም ካርሰረኮ ይንኤርዝድን ር ከታዘን Ꮊፈራክናና Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ማታጋካ ዳት ኤልሳበጥ ሴካ ኮት ማቻንካንታ ይንች ከታ ካያ Ꮊቄ፥ ከታ ቃስተነረ ዶንጀርተኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ኮት ሰጨናይካ ዛከርያስ ሳብታ ጭል ኤሄናር ቀሰንከስታ ፍክስንታ የችናር እጣ የልስንካ ክት ፍግዝድን ሰጫ Ꮊቄ፥ ኮካንታ ኖ ሳብታ እር ቀሰንከስታ ፍክስን ቦድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ይና ኖ ቄሰንከስ ፍግዝድን ዎገንግንዳ ኤሄናር አርድሶ እጣንን ጩብዝድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","እጣንን ጩፍሰርድንካ ዎርሰና ሙዳ ሳብታ ጭል ኤሄንታ ማላር ዎእሶ ምግዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ጮይስታ ክታይንችና እጣንን ጩፍሰርድን ካስ ካርንታ ምዝዘንጎካ ዎእሶ ክትካንታ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ዛካራሰረ ክታይንችንም ይ ሰዳንደትካ ገቅሶ አንድር ጳሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ክታይንችና ማቸ፥ ዛካራሶ! “Ꮊይ ጳሴ! የስታ ምክስና ኤስምቴ። የስታ ኬነና ኤልሳበጥ አⷝና ይንች የስካንታ አእእተረ፥ ክታ ላምነረ ዮሀንስ ጋይተራዬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ክትካ ጉርምከ Ꮊላ ጋይንተንም Ꮊፍተራዬ፥ በድንከሰረ ክታ አጥርንካ ጉርምተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ጮይስታ እር ኖ አንድር ማተሬ። ዎይን ዎጭምንምኬ አበረ ጎስዝድን ዎጭምን ዎጭተራክዬ፥ እንደንታ ሳቅማር ዶቅድዮ ጭል አያንካ ጮጭተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","እስራኤል ዎርሰንከሳርንካ በድንከስም ከታ ጮይስ ሳብንደር ከትም ማስተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ባበንከስተከ ይንችንከስታ ቡደን ዋልቃ ማስካንታ፥ ክትምዳክባብከስመረ ጭልንባብከስታ ጎግንዘን ማስተሬ። Ꮊድን ጮይስንካንታ ማድን ዎርሰን ግግስካንታ ኤላሰካ ፍክሳን ጭል አያንንታ ዎልቀካ ማትሶ ጮይስታ እር አይተሬ” ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ዛካራሰረ ክታይንችንም፥ “ኮም Ꮊረክስ ኤዝዳ? እታ ዶንጅቴ፥ እስታ ኬነነረ ዶንጀርቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ክታይንችነረ፥ “እታ ሳብታ እር ዎእድባብ ገብረልቴ፥ ኮም እ የስካንታ ኬዝድንግንደኬ ኮትኮ ክላ ኬዘን የስካንታ እ ሳባግድንግንዳ ኦይትምትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ይና ሰጨንም ካርስሶ ማድንደትም እስታ ቃለን የስ አመናክንኦል፥ ኮነረ ቦድምተርን ሰጨን የለልታ አፋ ቱንይ ማተራዬ፥ ከዝተራከዬ” ኩንጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ኮታይካ ዎርሰና ዛካራስ ሳብታ ጭል ኤሄናርንካ ዉታክዶቆ Ꮊራካንታ ጋምእሳናከረ በርእካ ካርሰሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ኖ ይ ዉተዳንደታ ቡረረ፥ ከትም ከስስካንታ ማታክዬ፥ ቃዉተካ ሰች ዘንካ አብ ኬዛካንታ ክት ማታክን ኦላር ሳብታ ጭል ኤሄናር ለምለም ጋይድንካ ክት ሰዳንዳ ዶቅዳ ማደ ጋይሰኮ ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ዛካራሰረ ሳብታ ፍክስ ሰጨና ቦድምሳን Ꮊይካ ይንታ ኤር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ኮታ ቡር ኬነና ኤልሳበጥ ስርሴ፥ ዶንቅ አርፍ ይንታ ማተንም ኤድካንታ Ꮊፍሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ናየረ “ጮይስ ይንታ ነጋትቸንካ እስታ ይንእርንም ኤታ ዎክያርንካ እዘንካ Ꮊልእስካንታ አጭርሶ ኮም እካንታ ይቴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ላስ አርፈንካ፥ ሳብ ይንታ ክታይንችን ገብረልም ገሊላር Ꮊፈርድን ናዝረት ጋየርድን ካተመናር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ክት ኦይትምሳንደረ ዳውተታ ሱሳ ማችባብ ዮሰፍ ጋይምድባብካንታ ሶርምምሳንዳ ዋልቃ አንጃ ሙነክንዳ Ꮊቄ፥ ኮታ ላምነረ ማራሜ። ");
INSERT INTO gyl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ክታይንችነረ ኮት ዶቅድንደታር አርድሶ፥ “አንድር ሶልምምሳንዶ ሳራትችና የስካንታ ማታ! ጮይስ የስካ ክክኔ፥ የና አንድር አንጅምሳንዳዬ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ማራመረ ክታ ኬዘንካ አንድር ገቅሶ “ኮና Ꮊራግንዳ ሳራትቸረ?” ጋየሮ ገቅር የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ክታይንችነረ፥ “ማራሞ፥ ሳብታ እር ጎፍስ Ꮊፍታዬ Ꮊይ ጳሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ይና የና ስርተረዬ፥ አⷝና ይንቸረ አእተራዬ፥ ክታ ላምንመረ የሱስ ጋይተራዬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ኖየረ አንድር ማተሬ፥ ሳብታ ይንቸረ ጋይምተሬ፥ ጮይስ ሳብነረ ክታ ባቤን ዳዊትታ ባንችም ዶቅንት ጎንገን ክትካንታ እምተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ያይቆበታ ሱሰንዘን ስለንክንደታ ኖ ባንችምዴ፥ ክታ ባንችምንተረ በእንታ ካዬ” ኩን ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ማራመረ ክታይንችንደር “እታ ሙነክቴ፥ ኮና Ꮊስግንዶክ ማዳ?” ና ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ክታይንችነረ ማስሶ፥ “አያን ጭልና የስታዘን Ꮊዴ፥ ጮይስ ሳብታ ዎልቀና የስታዘን ማተረ፥ ኮካንታ የዘንካ አጥርምድባብ ጭል ሳብታ ይንች ጋይምተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ይና፥ የስታ ሱሰና ኤልሳበጠረ ይንታ ጋልተር ገርዘን አⷝና ይንች ስርቴ። ሴካ ጋይምሳንደረ ላስ አርፈንንም ይንታ ፋይቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ሳብም ጋምድንዳ ር ካዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ማራመረ፥ “ይና እታ ጮይስታ ፍክስንድቴ፥ የስ ጋይሳንግንዳ እካንታ ማታ” ና ጋይሴ። ክታይንችነረ ኮታዘንካ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ማራመረ ኮትኮ ሳምንትንካ ጭጭመትካ አምሶ ገቻ Ꮊክ ፍጨናር፥ ኦስ ይሁደታ ካተመናር ና አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ዛካራሰታ ኤረረ አርድሶ ኤልሳበጣካንታ የና ኡርሞ Ꮊስሬ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ኤልሳበጠረ ማራመታ የና ኡርሞ Ꮊስሬ ኮታ ጋይንም ኤሰርሳንደትግንዳ፥ ኡለና ኮታ ሳቅምናር ሶይሴ። ኤልሳበጥረ አያንይ ጭልንካ ጮጬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ናየረ ኡፍስንም ይንታ ጬክሳ ይይሶ፥ “የና ማነንከስታ ዎክያርንካ አንጅምሳንዳዬ፥ የስታ ሳቅምናርንካ አጥርምድን ይንችና አንጅምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","እስታ ጮይስንታ እንደና እዝደር Ꮊድንግንዳ እታ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ይና የስታ ሳራትችንታ ኡፍስና እስታ ቃምናር ኤስምሳንደትግንዳ እስታ ሳቅምናር ዶቅድን ኡለና ጉርምካ ሶይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ጮይስ ይ ኬዛንደትም ቦዴ ጋይሶ አሜንሳንዳ የና Ꮊስግንዳ አንጅምሳንደሬ!” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ማራመረ፥ “እስታ ሰንፔና ጮይስም ጬክ ጬክሳ ይዴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","እስታ አያንነረ እስታ ኤልን ሳብንካ ጉርምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","እ ክታ ፍክስንእንደታ ቶችምን ኖ ሰቴ። ታክንዘንካ የችሶ አጥር ሙደና ና ጭልዬ እም ጋይተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ዎልቀንክንባብ ሳብና ኖ አንድር ር እካንታ ይቴ፥ ላምነረ ክታ ጭልዬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ሳብም ጳዝድባብከስካንታ ክታ አጭርና አጥርዘንካ አጥር የለልታ ዶቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ይንታ ዳቅማ ቀስንካ ፍክስንም ፍክስቴ፥ ከታ ይንታ ቡዳ ገቅርንካ ኦተርድባብከስም ይጭቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","“አንድርካ ቆልድባብከስም ከታዶቅንት ጎንገንዘንካ Ꮊንችስቴ፥ “ይንታ ማተንም ይርክሳ ይድባብከስም ማቼ ጬክ ጬክሳ ከትም ይቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ዳቀርስባብከስም ኡርማ ርካ ምስስቴ፥ ቆልመንባብከስም ማቼ አን ዉች ከትም ኦይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ይንታ አጭር ገቀርንካ፥ ይንታ ፍክስንባብ እስራኤልም አሌን አልቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ኮነረ ዎንታ ባቤንከስካንታ ኬዝምሳን ግንዳ፥ አብረሀምካንተከ ክታ ሱሰንካንታ ጋይሳንደትም ስለንክንደታ Ꮊድን ጉርም ቃለንም ቦድካንቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ማራመረ ማከን አርፍ ማታባብ ኤልሳበጠደር ይ ዶቅሳንደታ ቡር ይንታ ኤሪ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ኤልሳበጠተረ አጥመታ ሰጨና የልስንካ አⷝና ይንች አጬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ኮታ የለንከስከ ሱሰንከስ ጮይስ አንድር ነጋትች ኮትካንታ ይሳንደትም ኤሰርሰኮ ኮትካ ክክን ጉርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ላማካይስ ሰጨንካ ይንችንታ ሶለን ተችስካንታ Ꮊደኬ፥ ባበንታ ላምንካ ዛካራስ ጋይካንታ ዝግዘኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","እንደና ማቸ “ኩን ማታዬ፥ ክታ ላምና ዮሀንስ ጋይም ዝግዝዴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ከተረ “የስታ ሱሳርንካ ኮ ላምንካ ኤልምስባብ Ꮊየነረ ካዬ” ኮደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ባበንምረ Ꮊይ ጋይሶ ላምን ዎድ ክት ዝግዳ ናነረ ቃዉተካ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ኖየረ ጻፈርድን ሪ ኬት እምድንግንዳ ምክስሶ፥ “ላምና ክታ ዮሀንስ” ጋይሶ ጻፍሴ፥ ሙደነረ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ኮታዘንከረ ሳነካ ክታ አፈና ፎችምሴ፥ አድምነረ ቡልምሴ፥ ሳብመረ ጋለተሮ ኬዛ የጄ። ");
INSERT INTO gyl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","የለንከሰረ ሙዳ ጳስካ ጮጨኬ፥ ኮና ሙዳ ሪይና ገቻ ፍጨን ይሁዳር ሙዳ ከዝምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ኮም ኤሰርስባብና ሙዳ፥ “ኮና ኡለና Ꮊርክ ማተራዳቶ?” ጋየረኮ ከታ ይንታ ቡዳር የጀኬ። ጮይስታ አንና ገታ ክትካ ክክን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ኡለንታ ባበና ዘካራስ አያንይ ጭልንካ ጮጭሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“እስራኤልንታ ጮይስ ባበና ጋለትማ፥ Ꮊድሶ ዎርሰንም ቆት ተዬ”። ");
INSERT INTO gyl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","“ዎንታ ጮይስና አይላ ዳውተታ ሱሰናርንካ አንድር አቅዝድባብም ዎካንታ አምስቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ኮና ኤና እር ሳብካንታ ፋስምስባብ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ አፈካ ኬዛንግንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ክታ አቅስንተነረ ዎንታ ይምኤንባብኬዘንከ ዎም ግርድባብ ሙደንታ አንናርንካ አቅስካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ኮመረ ክት ይሳንዳ ዎንታ ባቤንከስካንታ አጭርንም ሰችካንተከ ጭል ይንታ ጫቀንም ገቀርስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ኮመረ ይንታ ጫቀን ቦንችካንታ Ꮊድን ጉርም እምምሳንዳ ዎንታ ባቤን አብረሀም ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ዎንታ ይምኤንባብከስታ አንያርንካ ዉትሶቶ፥ ጳስካይሳ ዎ ክትካንታ ፍግዝድንግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ዎንታ ስለናረረ ሙዳ ሳብካንታ ፋስምስንደትከ ጭልምካ ክታ እሪ ዎ ዎእድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ጉጅሰረ የና ኡለኖ፥ ሙደንዘንካ ስግ ሳብዘንካ ኤሰርሶ ኬዝድባብ ጋይምተራዬ፥ ጮይስታ ጎግንም ኡርስካንታ ክታ እሪ አይተራዬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ዎርሰንካንታ አቅንተንታ ኤሰንም Ꮊፍንዘንካ አምሳንዳ፥ ከታ ጎመን ላላ ጋይንተንም ከትካንታ እምምተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ዎንታ ጮይስና አጨርድባብከ አተርድባብ ማቻንካንታ፥ አቅዝድንዳ ሰጭማ Ꮊይና ጭላርንካ ዎካንታ ዉችዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ኮነረ ኡማር ዶቅድባብከስካንተኬ፥ ደእታ ሽፍያር ዶቅድባብከስካንታ ሳግዝድን ግንዳ፥ ዎንታ ዱትንመረ ኦስ ሳረትቺ ጎግንካ ጎርዝዴ” ኩንጋየሮ ቤርካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ኡለነረ ጋጵሴ፥ አያንከረ ዛብዜ፥ እስራኤል ዎርሰንካንታ መያ ይ Ꮊፈርተርን ሰጨን የለልታ ኤድ ካየንካርያር ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ኮትኮሰጨንካ ሮማ ፍጨንታ ባንችን አዉግስጦስዘንካ ክታ ጎያር ቆልምድባብ ዎርሳ ሙደና ፋይድምድንግንደከ ላም ከታ ጻፍምድን ግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ኮነረ ቀራኖስ ሶራ ፍጨን ክት ቆልድንᎺይካ ዎርሰና ፋይድምድንግንዳ ይምሳንዳ እርንደኔ። ");
INSERT INTO gyl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ኮካንታ ዋልቃ ዋልቃ ኤድና ይንታ ላምን ጻፍስካንታ ይ አጠርምሳን ካተመናር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ዮሴፈረ ዳዊተታ ገርና ይ ማቻንካንታ ገሊላ ፍጨናር Ꮊፈርድን ናዝረት ካተመናርንካ አምሶ ይሁዳ ፍጨናር ዳውት አጥርምሳን በትለሄም ካተመናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ኖይንታ ላምን ጻፍስካንታ ክት አይሳንደረ ሶርምሶ ዶቅድዮ ስርሶ Ꮊቃን ማራመካ ክክኔ። ");
INSERT INTO gyl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ቤተለሄም ካተመናር ከትዶቅድንካ ኮታ አጥመታ ሰጨና የልሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ይንታ ዳነዝ ይንች ማችባብም አⷝና ይንች አጬ፥ ቱርጫ ቆፍስትዮ ዋክታ ካላር ራችሴ፥ Ꮊረታ ጋይሴ ሶችንከስታ Ꮊዉስንታ ካሪ ከታ ይ Ꮊፋክንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ኮትኮ ፍጨናር ሶይት ዉደንም ካርሰሮ ቦንገዘን ገጅድባብ ግስመንባብከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ጮይስታ ክታይንችና ከደር Ꮊድሶ ከታ ላመር ዎእሴ፥ ጮይስተረ ቦንቸና ከታ ካንተንካ ሳክሴ፥ አካ ጳሰረ ከትም የጄ። ");
INSERT INTO gyl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ክታይንችና ማቸ “Ꮊይ ጳሰቴ! ዎርሳ ሙደንካንታ ማድን አንድር ጉርምከ ክላ ኬዛ የካንታ ተይᎺትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ታካ ዳውተታ ካተመናር የም አቅዝድባብ የካንታ አጥርምቴ፥ ኖየረ ጮይስ ክርስቶስዬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ኡለንም ቱርጫ ቆፍሰርስንካ ዋክን እችዝድን ዎምእናር Ꮊፍተረቴ” ኮና የካንታ ቃዉታ ኮት ማታ፥ ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ከት ገቀራክናና ጭለዘን በድ ዳምንባብከስካ ክክን ክታይንችና ከትካንታ Ꮊፈርሰኬ፥ ሳብመረ ጋለተረኮ፥ ");
INSERT INTO gyl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ቦንቻ ሳብካንታ ጭላር ማታ! ሳራትችነረ ሳብም ሶልምድን ኤድንከስካንታ ፍጨዘን ማታ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ክታ ይንችንከስ ከታዘንካ ፋስምሶ ጨዳ ጭላር ከት አይሳንደታ ቡር ግስመንባብከስ ክክ ክክ “ጮይስ መያ ማስሳንደትምከ ይምሳንደትም ሰድን ካንታ ኦስ ቤተለሄም ካተመናር ሙከቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ከተረ ሳነካ አይሰኮ ማራመም ዮሴፈምኬ ኡለንመረ ዋክታ ካለናር ራትሶ ዶቅድንካ Ꮊፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ከታ ኡለንም ይ ሰጃንደታ ቡር ይና ክታይንችና ኡለንጎካ ኬዛንደትም መያ ማስሶ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ኮመረ ኤሰርስባብ ሙደና ግስመንባብከስ ከዛንደት ርንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ማራማ ማቸ፥ ኮም ሙዳ ይንታ ቡዳር የድሶ ገቀረሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ግስመንባብከሰረ ሙዳ ርና ከትካንታ ኬዝምሳንግንዳ ማትሶ Ꮊፍርንካ ከታ ይ ኤሰርሳንደተከ ሰጃንደትካ ሙዳ ሳብም ቦንቸረኮ ጋለተሮ ማቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ላማካይ ሰጨታ ቡር ኡለንታ ሶለንም ተቸርድንደታ ዎገንዘን ክታ ላምና “የሱስ” ጋይምሶ ኤልምሴ። ኮነረ አክ ክት ስርምተርንደታ እር ክታይንችና ክታ ዎጃን ላምዬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ሙሴታ ህግንግንዳ፥ አርንንታ ለእና ቦድምሳንደትካ፥ ዮሴፈኬ ማራመካ ኡለንም ጮይስታ እሪ ክትም ዎይስካንታ እመደር ተይሰኮ የሩሳሌም ካተመናር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ኮመረ ከትይሳንዳ ጮይስ ህግንካ አⷝና ማችባብ ዳነዝ ሙደና ጮይስካንታ ጭልምስባብ ማተረ ጋይምሶ ጻፍምሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ኮካንታ ጮይስታ ህግንካ “ቃስቴን ቴርንከስም ናነረ ቃስቴን ዎለታ ይንችንከስም ጋይምሳንግንዳ” ካሲንም እማ ጋይድንዳ ክታ Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ኮትᎺይካ ሳብታ እሪ ዶፈን ማችባብከ ሳብም ጳዝድባብ ስምኦን ጋይምድባብ ዋልቃ ኤች የሩሳሌም ካተመናር Ꮊቄ፥ ኖየረ እስራኤልንከስታ አቅንተንታ ጉርምንም ካርዝድባብከ አያን ጭልነረ ክታዘን Ꮊቅባቤ። ");
INSERT INTO gyl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ኖየረ ጮይስ ክርስቶሰም ሰዳክዶቆ ይ ደአይንደትም አያን ጭልንካ ክትካንታ መያ ማችንካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ኮታይካ አያንካ ጎርስምሶ ሳብታ ጭል ኤሄናር ኖ አርደዴ። ኡለንታ ባቤንኬ እንደንካ ህግንታ መጠንግንዳ ዝግዝድንደትም ቦድካንታ ኡለን የሱሰም እምጭሶ አርደዳንደትካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ስምኦን ኡለን እምጭት ተይሶ፥ ሳብም ጋለተሮ፥ ");
INSERT INTO gyl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ጮይስዮ! ጉርም ቃለን የስ እካንታ አርደዳንደት ቦድምሳንካንታ፥ ታ የስታ እ አይለን ኡርመካ ኤልካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","እስታ አፍና ኤድ ሙደንታ እሪ የስ ግግሳንደትም አቅስንም ሰቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ኖ አይሁድ ማታክባብከስካንታ ዶፈንንም መያ ማዝድን ሳክማ፥ የስታ ዎርሰን እስራኤልንከስካንተረ ቦንቼ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ዮሰፍከ ማራመካ ኡለንጎካ ከዘርሳን ኬዘንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ስምኦነረ ከትም ይ አንጃንደታ ቡር ኡለንታ እንደን ማራመም፥ “ይና ኮና ኡለና እስራኤልንከሳርንካ በድንከስካንታ ካይንተተከ ፋጭንተተካ ጎግ ማድንግንዳ፥ ጉጅሰረ ክትም ግርድባብከስካንታ ቃዉታ ክት ማድንግንዳ ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","በድንከስታ ቡዳር አችምሳን ገቅርና መያ ማተረ፥ የስታ ቡደነረ አንድር ሞርእታ ማሰንካ እክምተሬ” ኩን ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ኮትኮግንደረ አሰርታ ሱሳ ማቻንዳ ፋኑኤልታ ይንቸን ሀና ጋይምድንዳ ሳብዘንካ ኤሰርሶ ኬዝድንዳ Ꮊቄ። ናየረ ሙነካ ዶቅድዮ ይእሶ በድ ዶንጀርታ Ꮊቄ፥ ይንታ ክእስንካ ክክነረ ታብዛ ስላ ዶቅሳንደታ ቡር ክእስና ደእስንካ ቡድና ማቸ። ");
INSERT INTO gyl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ስለነረ ኮታ ኦይድ ቦንደከ ኦይድ ስላ ማተርን የለልታ Ꮊየከ ሶይትካ ሳብታ ጭል ኤሄናርንካ Ꮊልአክሳ በቸካ ምክሰሮ ሳብካንታ ፍግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ኮት ሰጨንከረ የልሶ ሳብም ጋለቼ፥ የሩሳሌም ካተመንታ ቆት ተይምን ካርሰሮ ዶቅድባብ ሙደንካንታ ኡለንጎካ ና ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ዮሰፈከ ማራመካ ጮይስታ ህግካ ክተርሳንደትም ሙዳ ቦጃን ቡር ገሊላ ፍጨናር ዶቅድን ከታ ይንታ ካተመን ናዘረታር ማቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ኡለነረ ጋጵሴ፥ ኤጨክንባብ ማቼ፥ ሳብተረ ዉች እምንተና ክታዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","የሱሰታ ባቤንኬ እንደንካ ስለዘን ስለዘን ፋስጋ ባአልን ቦንቻካንታ የሩሳሌም ካተመናር አይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","የሱሰረ ታመከ ቃስተን ስላ ክታ ማቻንደትካ ከታ መጠንግንዳ ባአልናር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ባአልንም ከታ ይ በይሳንደታ ቡር ከታ ይንታ ኤሪ ከት ማድንካ ይንችና የሱስ የሩሳሌም ካተመናር ነገዴ፥ ዮሰፈከ ማራመካ ማቼ ኦኮታር ክታ ነግንተንም ኤሳከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ዎርሰንካ ክክን ዶቅድም ካምስንካ ዋልቃ ሰጨታ ጎግ ሙክሰኬ፥ ኮታዘንከረ ይንታ ሱሰንከዝደርከ ከትም ኤዝድባብ ኤድንከዝደር ክትም ዝግመት የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ከታ ክትም ይ Ꮊፋክንካንታ ዝገረኮ የሩሳሌም ካተመናር ማቸከ። ");
INSERT INTO gyl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ማከን ሰጨታ ቡር ኤስስንባብከስታ ዎክናር ዶቅሶ ከትም ኤሰረሮ ከትም ኦይሰሮ ክት ዶቅድንካ ሳብታ ጭል ኤሄናር ክትም Ꮊፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ክታ ኦይስንምከ ማስንም ኤሰርስባብከስ ሙደና ክታ ገቅርንከ ክታ ማስንካ በርኤሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ባበንከ እንደንካ ክትም ሰድሰኮ በርእሰኬ፥ እንደነረ “እስታ ይንችኖ! Ꮊረተስ ኩን ዎንዘን ይሳራ? የስታ ባበንከ እንካ ማጥርሶቶ ዝግድ Ꮊቀርሴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","የሱሰረ፥ “Ꮊረተንት እም ዝግዛራ? እባብታ ኤሪ Ꮊፍር እም ዝግዝድንደትም የታ ኤሳከቴ?” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ከታ ማቼ ክት ኬዛንደትም ገቀራከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ኮታዘንከረ የሱስ ከትካ ክክን ናዝረት ካተመናር አይሴ፥ ከትካንተረ ክትመሮ Ꮊቄ። እንደነረ ኮም ሙዳ ሪን ይንታ ቡዳር የድይ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","የሱሰረ ኤጨከ ዎይተካ አነረ ጎፍስካ ሳብተኬ ኤድተካ እሪ ጋጰሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ሮመታ ባንችን ጢባሮስ ባንችምሳንደት ታመከ ዶንቅስ ስለናር፥ ጰንጠና ጵላጦስ ይሁዳ ፍጨን ገችዝድባብ Ꮊቄ፥ ሄሮድስ ማቸ ገሊላ ፍጨን ቆልድባብ Ꮊቄ፥ ኮትኮግንደረ ክታ እስመን ፍልጶሰረ እጡራሰተከ ጥራኮንዶስ ፍጨን ኦይችምስ ዱት ቆልስባብ፥ ልሳኖሰረ አብለነ ፍጨን ኦይችምስ ዱት ቆልስባብከስ Ꮊቀኬ ");
INSERT INTO gyl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ሀነከ ቀያፈካ ቀሰንከስም ገችዝድባብ ማትሰኮ ከትዶቅድንካ፥ ሳብ ይንታ ቃለንም ዘካርያሰታ ይንች ዮሀንሳካንታ ኤድ ካየንካርያር ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ኖየረ “የንታ ጎመንታ ነገትቸን የ Ꮊፍተርንግንዳ ጎማ ፍክስን ዎይስሰቶ ስኤርከቴ” ጋይሶ ዎርሰንካንታ ኬዘሮ ዮርዳኖስ ሎቀንታ ላማር ዶቅድን ካሪ ሙደናር ኦንግዜ። ");
INSERT INTO gyl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ኮነረ ማቻንዳ ሳብዘንካ ኤሰርሶ ኬዝባብ ኢሳስታ ቤር ማጻፍናር፥ “ኤድ ካየናር ኩንጋይሶ ፍብድን ኤታ ኡፍስ ‘ጮይስታ ጎግን ግክስከቴ! Ꮊጭሰረ ሉልስከቴ! ");
INSERT INTO gyl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ቦደና ሙዳ ጮጫ! ገቸንኬ ደንካ ሙዳ ይርክን ጋያ! ዎብ ጎግና ኡራ! ቦርችምሳ ገርደነረ ኡርስማ! ");
INSERT INTO gyl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ኤድ ይንች ሙደና ሳብታ አቅስንም ሰዳ!’ ” ኩን ጋይምሶ ጻፍምሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ዮሀንሰረ ክታ አንያር ስእርካንታ Ꮊዳን ኤድንከዝደር “የታ ጉን ፉይንታ ይንችንከሶ! Ꮊድን ሳብታ ዋጭንዘንካ የ ሱርድንግንዳ Ꮊይ የም ዞርሳሬ? ");
INSERT INTO gyl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ይና የንታ ጎማ ፍክስን ዎይስዝድን ፍክስንም ፍክስከቴ ዳት፥ የንታ ቡዳር አብረሀም ዎንታ ባበና ዶቅዴ ጋይሰቶ Ꮊይ ጋይርመቴ። ሳብ ኬና ሰይንንከሳርንካ አብራሀምካንታ ይንች አምስስካንታ ማድንደትም የካንታ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ታ ዎራ Ꮊቀን ፋግድንዳ ካልተና Ꮊቀንከስታ ጎያር ዶቅቴ። ይና ኡርማ አፍ ኡዝዳክን Ꮊቃ ሙደና ፋክምሶ ኖሀር ኦይትምዴ” ኩን ጋይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ዎርሰነረ “ይና፥ Ꮊሮንት ይቴ?” ጋየረኮ አይሶ ዮሀንሰም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ዮሀንሰረ፥ “ቃስተን አፍላ ዶቅድባብ Ꮊረነረ ካየንባብካንታ እማ፥ እችም ዶቅድባበረ ኮትግንዳ ይያጋካ” ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ቃረጭን ተችዝድባብከሰረ ስእርካንታ ክደር Ꮊድሰኮ “ኤስስንባቦ! ዎታ Ꮊሮንት ይቴ?” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ኖየረ፥ ህግንካ የም “ክተርሳንዘንካ ስግስሶ ቃረጭን Ꮊይ ተችሰቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ዳምንባብከሰረ Ꮊድሰኮ፥ “ዎታ Ꮊሮንት ይቴ?” ጋይሶ ኦይሰኬ። ኖየረ፥ “Ꮊየንዘንከረ ብረም ጩበካ Ꮊይ ቡረቴ፥ ኤድመረ ማልትካ Ꮊይ ካሰሰተ፥ የንታ ፍክስንካንታ ናከርድንዳ የም ማዴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ዎርሰና ጉርምካ ካርሰዘን ከት ዶቅድንካ፥ “ኖኮና ክርስቶስ ዳቶ?” ጋየረኮ ሙደና ይንታ ቡዳር ዮሀንስጎካ ገቅር የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ዮሀንሰረ ሙደንከስካንታ፥ “እታ የም ሎቀካ ስእዝድቴ፥ ኬዛርንካ ማቼ እዘንካ ስገድባብ Ꮊዴ፥ እተረ ክታ ጫመንታ ዞክነንም ቡልካንታ ማታይባብቴ፥ ኖየረ አያን ጭልንኬ ኖሄካ የም ስእዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ቆይደንም ቦድሶ ኡርስካንተኬ ዘርግንመረ ቡለናር ኦይትካንታ ጋልደጵና ክታ አንያሬ፥ ምሰንመረ ድግዳክን ኖሄንካ አችዝዴ” ኩን ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ዮሀንሰረ በድ ጎግካ አብንከስካንታ ዞረካ ዎርሰንም ኤግዝሰሮ ክላ ኬዘን ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ኬዛር ማቼ ዮሀንስ፥ ገሊላ ፍጨንም ቆልድባብ ሄሮድስ ይንታ እስመንታ ኬነንም ክት እንቻንጎከ አብ በድ ዳቅል ር ክት ይሳንካንታ ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ሄሮድስ ዳቅልንዘን ዳቅልን ጉጀካ ዮሀንሰም ዞክና ኤሄናር አርችሴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ዎርሳ ሙደና ስኤርሳን ቡር የሱሰረ ስኤርሴ፥ ክት ምክሰሮ ዶቅድንካ ጭላ ፎችምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","አያን ጭልና ዎለም ካምሶ ክታዘን Ꮊንቸርሴ፥ ጭላርንከሬ፥ “እ ሶልምድን እስታ ይንችና የናዬ፥ የስካ እም ጉርምዝዴ” ጋይድን ኡፍስ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","የሱስ ፍክስን ክት የድንካ ስለና ክታ ቦንደከ ታማ ማድንዳ Ꮊቄ፥ ዎርሰንከስካንታ የሱስ ዮሴፈታ ይንች ካምድ Ꮊቄ። ኖየረ ኤልታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ማትታ ይንች፥ ለዊታ ይንች፥ ምልከታ ይንች፥ ዮነታ ይንች፥ ዮሰፈታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ማታትታ ይንች፥ አሞጸታ ይንች፥ ናሆመታ ይንች፥ ኤስልታ ይንች፥ ናገታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ማአትታ ይንች፥ ማታትታ ይንች፥ ሰመይታ ይንች፥ ዮሰፈታ ይንች፥ ዮደታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ዮናነታ ይንች፥ ረሰታ ይንች፥ ዘሩባበልታ ይንች፥ ሰላትያልታ ይንች፥ ነርታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ምልክታ ይንች፥ Ꮊድታ ይንች፥ ዮሳስታ ይንች፥ ቆሳምታ ይንች፥ ኤልሞዳመታ ይንች፥ ኤርታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ዮሰእታ ይንች፥ ኤልኤዛርታ ይንች፥ ዮራመታ ይንች፥ ማጣተታ ይንች፥ ለዊታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ስምኦነታ ይንች፥ ይሁደታ ይንች፥ ዮሰፈታ ይንች፥ ዮናንታ ይንች፥ ኤልያቀምታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","መልያታ ይንች፥ ማይናንታ ይንች፥ ማጣተታ ይንች፥ ናታነታ ይንች፥ ዳውተታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","እሳይታ ይንች፥ እዮበድታ ይንች፥ ቦኤዝታ ይንች፥ ሰልሞንታ ይንች፥ ነአሶንታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","አመናዳብታ ይንች፥ አራመታ ይንች፥ አሮንታ ይንች፥ ኤሰሮመታ ይንች፥ ፋረስታ ይንች፥ ይሁደታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ያይቆበታ ይንች፥ ይሳቀታ ይንች፥ አብራሀመታ ይንች፥ ታረታ ይንች፥ ናኮረታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ሰሮሄታ ይንች፥ ራገታ ይንች፥ ፋለቀታ ይንች፥ አበርታ ይንች፥ ሳለታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ቃይናነታ ይንች፥ አርፋክስድታ ይንች፥ ሰምታ ይንች፥ ኖህታ ይንች፥ ላመታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ማቱሳለታ ይንች፥ ሄኖክታ ይንች፥ ያረድታ ይንች፥ መላልኤልታ ይንች፥ ቃይናንታ ይንች፥ ");
INSERT INTO gyl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ሄኖሰታ ይንች፥ ሴተታ ይንች፥ አዳመታ ይንች፥ ሳብታ ይንች። ");
INSERT INTO gyl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","የሱስ አያን ጭልንካ ጮጭሶ ዮርዳኖስ ሎቀናርንካ ማቼ። አያን ጭልነረ ኤድ ካየንካርያር ተይ አይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ዋረረ ቃስተን ቦንዳ ሰጫ ዳብሎሰካ ጰጭምሴ። ከትኬና ሰጨናር Ꮊረርየረ ይ እቻክንካንታ በእንተዘን ዳቀርሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ዳብሎሰረ “ሳብታ ይንች የስ ማቸ ይና ኮና ሰይንና እችም ማድንግንዳ ክትካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","የሱሰረ “ኤድ እችምካ Ꮊክ ዶቃዬ ጋይምሶ ጻፍምቴ” ኩን ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ኮታዘንከረ ዳብሎስ ዋልቃ ጬክን ጋይሳን ካርዘን ዉችሶ ፍጫሙደንታ ባንችምንከስም ሙዳ አፍታ ይፍቻር ክትም ሰችሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“ከትኬና ባንችምንከስታ ገችንምከ ቦንቸንካ ሙዳ እካንታ እምምቴ፥ እተረ እ ዝግድባብካንታ እምድን ኦል የስ ካንተረ እምድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ኮካንታ የስ እካንታ ጎስትሴ ኮና ሙዳ የስካንታ ማተሬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","የሱሰረ ማስሶ “ጮይስ የስታ ባበንካንታ ጎስትካ! ክትመረ Ꮊክ ጎይንካ! ጋይምሶ ጭል ማጻፍናር ጻፍምቴ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ኮታርንከረ ዳብሎስ የሱሰም የሩሳሌም ካተመናር ተይአይሶ ሳብታ ጭል ኤሄንታ ዱረንዘን ዎይስሶ፥ ሳብታ ይንች የስ ማቼ፥ ይና የስታ ማተንም ኮዘንካ ቃዳ ጩላ ማስሶ ጎብሶ Ꮊንችርካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ꮊራካንታ ጋይሴ፥ የስም ካርዝድንግንዳ፥ ክታይንችንከስም ሳብ የስካንታ ክዴ፥ ኩን ጋይምሶ ጭል ማጻፍናር ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","“ ‘የስታ ዱትነረ ሰይንካ ጎሄርዳክንግንዳ ከታ ይንታ አንካ የድሶ አምዝደኬ’ ጋይምሶ ጭል ማጻፍናር ጻፍምቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","የሱሰረ፥ “ ‘የስታ ሳብ ጮይስን Ꮊይ ጰጬ’ ጋይምቴ ኩን ጋይምሰረ ጭል ማጻፍናር ጻፍምቴ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ኮታዘንከረ ዳብሎሰረ ጰጨንም ሙዳ ይ በይሳንደታ ቡር ኦስ እር አብ ሰጨን ይ Ꮊፍተርን የለልታ ክታዘንካ ፋስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","የሱሰረ ጭል አያንታ ዎልቀካ ማትሶ ገሊላ ፍጨናር ማቼ፥ ክትጎከረ ካንተካ ዶቅድን ፍጫ ሙደናር ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ኖየረ አይሁድንከስታ ምክስ ኤሄናር ኤስስሴ፥ ኤድንከስረ ሙዳ ክታ ኤስስንካ ጋለተሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ኮታርከረ ይ ጋጵሳን ናዝረት ካተመናር Ꮊዴ፥ ይንታ መጠንግንደረ አይሁድንከስታ Ꮊዉስ ሰጨንካ ከታ ምክስ ኤሄናር አርድሶ ጭል ማጻፍን ናበብካንተረ አምትዮ ዎእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኢሳሰታ ቁረርሳን ማጻፍና እምምሴ፥ ቁረርሳን ማጻፍንም ክት ፎጅድንካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ጮይስታ አያንንና እስታ ዘኔ፥ ሪካየንባብከስካንታ ክላ ኬዘንም እ ሳባግድንግንዳ፥ ኖ እም ሳይቴ፥ ዞከርስባብከስካንታ ቡልምን፥ አፍ ዝልንከስካንተረ ሰድንተም እ ጬቅድንግንዳ፥ ኡንእምስባብከስም ዉችኩን እ ዉጅድን ግንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ሶልምምሳን ጮይስታ ስለንም እ ጬቅድንግንዳ እም ኦይቴ” ኩን ጋይምሶ ጻፍምሳን ካርን Ꮊፍሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ኮታዘንከረ ማጻፍንም ቁርትዮ ከትም ጎርዝድባብካንታ ማስት እምሶ ዶቅሴ፥ አይሁድንከስታ ምክስ ኤሄናር Ꮊቅባብከሰረ ሙዳ ማለካ ፍስሳ ክትም ሰድዮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ኖየረ፥ “ኮና የንታ ቃምካ የ ኤሰርሳንዳ ጭል ማጻፍንታ ቃለና ታካ ቦድምሴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ሙደነረ ክትጎካ ኡርመንም ኬዘሮ Ꮊቀኬ፥ ጉጅሰረ ክታ አድምናርንካ ዉድን ክታ ኡርማ ኬዘንካ በርኤረኮ፥ “ኮና ዮሴፍታ ይንች ካዮ?” ጋየሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","የሱሰረ፥ “ ‘የና ኤልንባቦ፥ የስታ ማተንም ፋችካ፥ ቅፍራናሆማር የስ ይሳንደትም ዎ ኤሰርሳን ሪይንም የስታ ካተመናር ጉጅሶ ይካ’ ጋይድንደትም ካምስን የ እዘን ከስተርንደትም Ꮊእራይቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ጉጅሰረ፥ “ዶፈን የም ጋይድቴ፥ ሳብዘንካ ኤሰርሶ ኬዝድባብ ይንታ ገታ ካተመናር ቦንችምማዬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ኬዛርንካ ማቼ ዶፈን የም ጋይድቴ፥ ጭለና ማከን ስለከ ባንግካ ዶብ ቃንክሳ እስራኤል ፍጫሙደንዘን Ꮊቃንደትካ ኤላሰታ ስለናር፥ በድ ማና ቡድነንከስ እስራኤልንከሳር Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ኤላሰረ ስዶና ፍጨናር ሰራጵታ ጋይምድን ሞረናር ዶቅድን ዋልቃ ክእስ ደእሳን ኤተንንደር Ꮊክ ዳት አብንከዝደር ኦይትማክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኤልሳእታ ስለናር እስራኤልንከሳር በድ ዱርገች ሰቅምንክንባብከስ Ꮊቀኬ፥ ኬዛርንካ ማቼ ሶራ ፍጨናርንክንባብ ንእማንዘንካ አብ ከታ ዎክያርንካ Ꮊየሰነረ ፋጫክዬ” ኩን ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","አይሁድንከስታ ምክስ ኤሄናር Ꮊቃን ኤድንከስ ሙደና ኮም ኤሰርሰኮ አንድር ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ከታ ይ ዶቅሳንደትዘንከረ አምሰኮ ካተመናርንካ ክትም ዉችሰኮ ጩለረ ክትም ቡክልስካንታ ካተመን ኡርሰርሳን ደንንታ ዱረንዘን ተይ አይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ኖ ማቼ ከታ ዎክንካ ስግሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ኮታዘንከረ ገሊላ ፍጫር Ꮊፈርድን ቅፍራናሆም ካተመናር አይሴ፥ ኮታረረ አይሁድንታ Ꮊዉስ ሰጨንካ ዎርሰንም ኤስስ የጄ። ");
INSERT INTO gyl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ክት ከዝድንደና ገችታ ዎልቀካ ማቻንካንታ ክታ ኤስስንካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","አይሁድንከስታ ምክስ ኤሄናረረ ቱና አያንካ የደርስባብ እሪ Ꮊቄ፥ ኖየረ ጬክን ጋይሳን ኡፍስካ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“የና! ናዘረት ፍጨናርንክንባብ የሱስዮ! Ꮊራ የስምከ ዎምካ የልዝድን ሪ ዶቅዳ? የስ Ꮊዳንዳ ዎም ካይስካንቶ? የስ Ꮊይ ናንከረ ኤዝድቴ፥ የና ሳብካንታ ፋስምስባበዬ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","የሱሰረ “ጫም ጋይሳዮ ኮ ኤችንዘንካ ዉትካ!” ጋይሶ ዋጬ፥ ግምዘነረ ኤችንም ዎርሳ ሙደንታ እር ባልት ዛቅሶ Ꮊረሰነረ ኡፈልሳክዶቆ ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ኤድንከስ ሙዳ በርእሰኬ፥ ክክ ክከረ “ኮና Ꮊራግንዳ ኤስሰሬ? ገችታ ዎልቀከ ሙቅምካ ቱና አያንንም ክዴ፥ ከተረ ክትምሶ ዉደኬ” ጋይሶ ከዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","የሱሰተረ ይተና ኮት ፍጨናር ሙደናር ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ኮታ ቡር የሱስ አይሁድንከስታ ምክስ ኤሄናርንካ ዉትሶ ስምኦነታ ኤሪ አርደዴ። ስምኦነታ በይስተነረ አንድር ዘና ሶልካ ማጠርድ Ꮊቄ፥ ኮት ጎካ የሱሰም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ኮደረ Ꮊድንደትከ ኮታ ላማር ዎእሶ ዘና ሶልንም ዋጬ፥ ዘና ሶልነረ ኮትም ዛቅስንካ ሳነካ አምሶ ከትም ሞክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ꮊይና አርድንካ፥ Ꮊክ Ꮊክ ሰቅምካ የደርስባብ ኤድንከስ ሙደንም የሱሰደር ተይ Ꮊደኬ፥ ኖየረ ዋልቃ ዋልቀንከዘን አንን ይንታ ዎድሶ ከትም ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ግምዘንከሰረ ጉጅሶ “የና ሳብታ ይንቸዬ!” ጋየረኮ ፍፈሮ በድ ኤድንከዘንካ ዉተደኬ፥ ኖ ማቸ ከትም ዋጬ፥ ከተረ ክት ክርስቶስ ማትንተንም ኤዝድᎺቃንካንታ ዋልቀረ ከት ኬዝዳክንግንዳ ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ፍጨና ሰጭድንካ የሱስ ዋልቃ Ꮊርን ጋይሳን ካርዘን አይሴ፥ ዎርሰነረ ክትም ዝግድ Ꮊቀኬ፥ ክት ዶቅድን ካርናረረ Ꮊደኬ ከታዘንካ ፋስምሶ ክት አይዳክንግንዳ ማር የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ኖ ማቼ “አብ ካተመንከሳር አይስቶ ሳብታ ባንችምንታ ክላ ኬዘንም ጬቅ እም ዝግዝዴ፥ እ ኦይትምሳንዳ ኮካንቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ኮካንታ ይሁዳ ፍጨናር ዶቅድን አይሁድንከስታ ምክስ ኤሄናር ሳባከሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ዋልቃሰጭ የሱስ ገንሰረጥ ባሀር ሎቀንታ ጋስትዘን ዎእሶ ክት ዶቅድንካ፥ ዎርሰና ክት ኤስዝድንደትም ሳብታ ቃለንም ኤስርካንታ ክታ ካንተንካ ኡንእምሰሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ኮታይካ ሎቀንዘንካ ቃልዝድን ቃስተን ጃልበንከስም ኖ ሰጄ፥ ሞለንም የድባብከስ ማቼ ጃልበናርንካ Ꮊንቸርሰኮ ሞለን የድን ሳከንም ስኤሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","የሱሰረ ጃልበንከሳርንካ ስምኦነትንደታር አርድሶ ፍጨዘንካ መራ ኦሳ ባሀርናር እጵሳ ይድንግንዳ ክትም ኦይሴ፥ ኮታዘንከረ ጃልበንዘን ዶቅሶ ዎርሰንም ኤስስ የጄ። ");
INSERT INTO gyl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ኬዘንም ይ በይሳንደታ ቡር ስምኦነም፥ “ኦስ ሎቀን ባሀርንታ ዎክያር አይሰቶ ሞለን የድካንታ የንታ ሳከንም ኦይትከቴ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ስምኦነረ ማስሶ፥ “እስታ ማተን ቆልስባቦ፥ ሶይትንም ሙዳ ጋፍካ ገችሰረ Ꮊረሰነረ የዳኮቴ፥ የስ ጋይሳንካ ሳከንከስም ኦይዶቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ሳከንም ከት ኦይድንካ አንድር በድ ሞላ የጀኬ፥ ከታ ሳከነረ ታክካንታ የልሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ኮካንታ አብ ጃልበናር Ꮊቅባብ ላኮይትንከስ Ꮊድሰኮ አለን አልድንግንዳ ቃዉተካ ኬትም ዎስሴ፥ ከተረ Ꮊድሰኮ ቃስተን ጃልበንከሳር ሞለን ጮችሰኬ፥ ጃልበንከሰረ ሎቀንታ ዋር ኤቅዝም የጄ። ");
INSERT INTO gyl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ስምኦን ጴጥሮሰረ ኮም ይ ሰጃንደትካ የሱሰታ ዱትንዘን ዋችሶ፥ “ጮይስዮ፥ እታ ጎማ ኤድቴ እዝደር Ꮊይ የሌ!” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ኮመረ ክት ጋይሳንዳ ክትኬ ክትካ ክክን Ꮊቅባብከስ ሙደና ከት የጃን ሞለንታ በድምንካ በርእሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ኮትኮግንደረ ስምኦነታ ላኮይት ማችባብከስ ዛብዶሰታ ይንችንከስ ያይቆበከ ዮሀንሰካ በርእሰኬ። የሱሰረ ስምኦንም፥ “Ꮊይ ጳሴ፥ ይና ኮዘንካ ኦስ ኤድም ፈንካ እዝደር ተይ Ꮊድባብ ማተራዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ከተረ ጃልበንከስም ፍጨዘን ይ የልሳንደታ ቡር ሙደንም ዛቅሰኮ የሱሰታ ካርንካ ጎርስምድባብከስ ማቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","የሱስ ካተመንከሳርንካ ዋልቀናር ክት ዶቅድንካ፥ ዋልቃ እጳ ሰቅምንካ የደርስባብ ኤች ካተመን ኮታር Ꮊቄ፥ ኖኮና ኤችና የሱሰም ይ ሰጃንደትካ ክታ እር ጉፕን ጋይሶ “ጮይስዮ! የስ እም ሶልምድንዳ ማቼ እም ፋችካ” ጋይሶ ክደር ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","የሱሰረ አንን ይንታ ኦይትሶ ክትም ይ Ꮊጫንግንዳ “የስ ፋጭድንግንዳ ጋይትቴ!” ጋይሴ። ሳነከረ እጳ ሰቅምናርንካ ኤችና ፋጬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","የሱሰረ “ኮም Ꮊየንካንተረ Ꮊይከዜ፥ ኬዛርንካ ማቼ አይሳዮ የስታ ማተንም ቄሰንካንታ ሰችካ፥ ዎርሰንካንተረ ማርካ ማተርንግንዳ የስታ ፋጭንተንም ሙሴ ክትሳን ካሲንም እምካ ጋየሮ ክትሴ”። ");
INSERT INTO gyl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ማታጋካ ዳት የሱስጎካ ከዘርድን ኬዘና ስግስሶ ሳከሮ አይሴ፥ አንድር በድ ኤደረ ክት ኬዝድንደትም ኤስርካንተከ ይንዘን ዶቅድን Ꮊዝምንዘንካ ፋጭካንታ ሳንመሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","የሱስ ማቼ በድᎺይካ Ꮊርን ጋይሳን ካርዘን አይሶ ምግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ዋልቃሰጭ የሱስ ኤስስዘን ዶቅድንካ ገሊላርከ ይሁደታ ሞረንከሳርንካ ሙዳ ኮትኮግንደረ የሩሳሌም ካተመናርንካ Ꮊድባብከስ ፈረሳውያንንከስኬ ሙሴታ ህግን ኤስዝድባብከሰረ ዋር ዶቅሶ Ꮊቀኬ። ከትም ፋችተርንግንዳ ጮይስታ ዎልቀና ክትካ ክክን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ኮትኮᎺይከረ ኤድንከስ ዋልቃ ዎብ ኤችም ሰለካ ባልት Ꮊድሰኮ፥ የሱስ Ꮊቃን ኤሄናር አርችሶ ክታ እር ዎድካንታ ዝግዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ኬዛርንካ ማቼ ዎርሰንታ በድምንዘንካ አምሳንዳ ኤሄናር አርች ከትም ጋምሳንካንታ ኤሄንታ ዱረንዘን ዉትሰኮ ኤሄንታ የለንም ፖእሰኮ ኤችን ዎብንም ሰለንካ የካ ዎርሰንታ ዎክካ የሱሰካ የረየር ክታ እር Ꮊንችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","የሱሰረ ከታ አሜንንም ሰድሶ “የና ኤችኖ! የስታ ጎመና ላላ ጋይምቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ሙሴታ ህግንም ኤስዝድባብከስኬ ፈረሳውያንከሰረ “ኮና ሳብዘን የክካ ኬዝድባብ ኖ Ꮊይራ? ዋልቃ ሳብን ክታዘንካ ጎመንም ላላ ጋይካንታ Ꮊይ ማዳ?” ጋይሰኮ ገቅር የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","የሱሰረ ከታ ገቅርንም ይ ኤሳንካንታ፥ “Ꮊረተንት የንታ ቡዳር ኮም ገቀርዳ? ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","‘ጎመና የስታ ላላ ጋይምሴ’ ጋይንታዘንከ ‘አምተዮ አይካ ጋይንታዘንካ’ Ꮊምና ቶግዳ? ");
INSERT INTO gyl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ኬዛርንካ ማቼ ኮም እ ጋይሳንዳ ኤድ ይንች ፍጨዘን ጎመንም ላላ ጋይስካንታ ገችታ ዎልቃ ዶቅድንደትም የ ኤዝድንግንዴ” ኮታዘንከረ ዎብ ኤችንም፥ “አምሰዮ የስታ ሰለንም ባልሰዮ የስታ ኤር አይካ የስም ጋይድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ዎብ ኤችነረ ሳነካ አምሶ ከታ እር ዎእሴ፥ ይ ራትሶ Ꮊቃንደትመረ ሰለንም ባልሶ ሳብም ጋለተሮ ይንታ ኤር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ኮታይካ Ꮊቃን ኤድንከስ ሙደና ኤቦ “ታካ በርእዝድ ርም ሰጆቴ” ጋየረኮ ጳስካ ሳብመረ ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ኮታ ቡር የሱስ ኮታርንካ ዉትሶ አይድንካ ለዊ ጋይምስባብ ዋልቃ ቃረጭን ተችዝድባብ ይ ተችዝድን ካርንዘን ዶቅድንካ ይ ሰዳንግንዳ “እም ጎርስምካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ኖየረ ሙደንም ዛቅሶ አምሶ ክትም ጎርስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ሌዊረ የሱስካንታ ይንታ ኤር አንድር እችምግክሴ፥ በድ ቃረጭን ተችዝድባብከስኬ አብ ኤድንከሰረ ከትካ ክክን እችምንዘን Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ፈረሳውያንንከስከ ሙሴታ ህግንም ኤስዝድባብከስ “ቃረጭን ተችዝድባብከስኬ ጎመንባብከስካ ክክን የ እጅድንደትከ የ ዎጭድንዳ Ꮊረተረ?” ጋየረኮ የሱሰታ ካርንካ ጎርስምድባብከዘን ጉንድምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","የሱሰረ “ሰቀርስባብከስም ዳት ኡርመንከስካንታ ኤል ዝክሳዬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","እተረ ጎመንባብከስ ይንታ ጎማ ፍክስን ዎይስሶ ከት ማድንግንዳ ዳት ጭልንባብከስም ኤልካንታ Ꮊዳክቴ” ኩን ከደር ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ከተረ “ዮሀንሰታ ካርንካ ጎርስምድባብከስ በድᎺይካ በቸካ ምግዝደኬ፥ ፈረሳዊያንንከስታ ካርንካ ጎርስምድባብከሰረ ኮትኮግንዳ ይደኬ፥ የስተንባብከስ ማቼ ከት እጅድንደትኬ ዎጭድንደና Ꮊረተረ?” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","የሱሰረ “እንቸንባብ ከትካ የካ ዶቅድንካ ካርንክንባብከስ በቼካ ምግዝድንግንዳ ይይማዬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ኬዛርንካ ማቼ እንቸንባብ ከታዘንካ ተይምድንደታ ሰጨና Ꮊዴ፥ ኮታይካ በቼካ ምግዝደኬ” ኩንጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ጉጅሰረ “ክላ አፍላዘንካ Ꮊእስትዮ ገሳ አፍለንዘን ዛግድባብ Ꮊየነረ ካዬ፥ ኩን ይሳን ማቼ ክላ አፍለን Ꮊእዝዴ፥ ክላ አፍለና ገሴን ካንታ ኡራዬ። ");
INSERT INTO gyl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ኮትኮግንደረ ጉንዳ ዎይን ዎጭምን ገሳ ሱልፈናር ካይሶ ዎድባብ Ꮊየነረ ካዬ፥ ኩን ይሳን ማቼ ጉንዳ ዎይን ዎጭምና ሱልፈንም ፉእዝዴ፥ ዎይን ዎጭምነረ ዉልእምዴ፥ ሱልፈነረ መያይንዳ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ኮካንታ ጉንዳ ዎይንንታ ዎጭምና ክላ ሱልፈናር ዎድ ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“ይና ጫርሳን ዎይንንታ ዎጭምን ዎጫንደታ ቡር ጉንደንም ዝግድባብ Ꮊየነረ ካዬ፥ Ꮊረታ ጋይሴ ‘ጫርሳንደና ኡርማ ማዴ’ ጋይምዴ” ኩንጋየሮ ካምስካ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","አይሁድንከስታ Ꮊዉስ ሰጨንካ የሱስ ዘርግ ትሰንታ ዎክካ ስገድንካ ክታ ካርንካ ጎርስምድባብከሰረ ትሰን ታክስተኮ ዎክስሶ እቸሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ፈረሳዊያንንከሳርንካ ዋልቃ ዋልቀንከስ ማቼ “አይሁድንታ Ꮊዉስ ሰጨንካ ይም ዝግዝዳክንደትም Ꮊረተንት ይዳ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","የሱሰረ “ዳዊት ይ ዳቀርሳንᎺይካ ይንታ ላኮይትንከስካ ክክን ይሳንደትም ቦድሶ የታ ናበባከቴ? ");
INSERT INTO gyl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ኖየረ ሳብታ ኤሄናር አርድሶ ቄሰንከዘንካ አብንከስ እጅድንግንዳ ጋይማክንደትም ጭልምሳን ባይስንም አምስትዮ እቼ፥ ይንካ ክክን ዶቅድን ኤድንከስካንተረ እምሴ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ጉጅሰረ “ኤድ ይንችና አይሁድንታ Ꮊዉስ ሰጨንታ ባበኔ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","አና አብ አይሁድንከስታ Ꮊዉስ ሰጨንከረ ከታ ምክስ ኤሄናር አርድሶ ኤስዝድ Ꮊቄ፥ ኮታረረ ክታ ምዝ አንና ምጨልስባብ ዋልቃ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ሙሴታ ህግንም ኤስዝድባብከስከ ፈረሳውያንንከስ የሱሰም ካሰስካንታ ኬዛ ዝግመትካ “ይና አይሁድንከስታ Ꮊዉስ ሰጨንካ ክት ፋጅድንዳ ማቼ ዎ ሰዳጋካ” ጋይሰኮ ካርሰሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","የሱስ ማቼ ከታ ገቅርንም ኤስሶ አንን ምጨልስባብ ኤችንም “አምተዮ ከታ ዎክያር ዎእካ!” ክትም ጋይሴ፥ ኤችነረ አምትዮ ዎእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","የሱሰረ “ይና ዋልቃ ር እ የም ኦይሳ፥ አይሁድንከስታ Ꮊዉስ ሰጨንካ ጋየርሳንዳ ኡርማ ፍክስዮ አና ዳቅል ፍክስዮ? ሰንፓ አቅስዮ አና ካይስዮ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ጉጅሰረ የሱስ ይንታ ጋስትንካ ዶቅድባብከስ ሙደን ይ ሰዳንደታ ቡር ኤችንም “የስታ አንን ፍእስካ!” ክትም ጋይሴ። ኤችነረ ይም ጋይሳንግንዳ ይሴ፥ ክታ አንነረ ቦድሶ ኡርሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ሙሴታ ህግንም ኤስዝድባብከስኬ ፈረሳውያንንከስ ማቼ አንድር ዋጭሰኮ የሱሰም Ꮊራ ይ ከትም ዝግዝዳናነረ ክክ ክክ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ከትኬና ሰጨንከሳርንካ ዋልቀንካ የሱስ ምክስካንታ ገቸንዘን ዉተዴ፥ ሶይትነረ ሙዳ ሳብደር ምግዝድ ገቼ። ");
INSERT INTO gyl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ፍጨና ሰጭድንከረ ይንታካርንካ ጎርስምድባብከስም ኤልሶ ከታርንካ ታመከ ቃስተንንከስም እጄ፥ ከት ከመረ “ኦይትምስባብከስ” ጋይሶ ላም ከታ ዎጄ፥ ");
INSERT INTO gyl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ከተረ ጴጥሮስ ጋይምሶ ኤልምስባብ ስምኦንኬ እስመን እንደራስ፥ ያይቆብ፥ ዮሀንስ፥ ፍልጶስ፥ ");
INSERT INTO gyl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ማቶስ፥ ቶማስ፥ እልፎሰታ ይንች ያይቆብ፥ ይንታ ፍጨንካንታ ጉርድባቤ ጋይምሶ ኤልምድባብ ስምኦን፥ ");
INSERT INTO gyl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ያይቆበታ ይንች ይሁደኬ ቡር ስክስት እምስባብ አስቆሮንት ፍጨናርንክንባብ ይሁደካ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","የሱሰረ ኦይትምስባብከስካ ክክን ገቸንዘንካ Ꮊንቸርሶ ሳንከንዘን ዎእሴ፥ ክታ ካርንካ ጎርስምድባብከስታ ሱሰናርንካ አንድር በድ ኤድንከስ ኮታር Ꮊቀኬ። ጉጅሰረ ይሁዳ ፍጫርንካ ሙዳ፥ የሩሳሌም ካተመናርንካ፥ ጥሮስታርንኬ ሲዶና ባሀርንታ ላማርንካ Ꮊድባብ በድ ዎርሰረ ኮታር Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ከነረ ከት Ꮊዳንዳ ክትም ኤሰርካንታ፥ ይንዘንዶቅድን Ꮊዝምንዘንካ ፋጭካንተኬ ቱና አያንንካ ማጥመሮ Ꮊቅባበረ ፋጭካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ክታዘንከረ አቅስታ ዎልቀና ዉተሮ ሙደንመረ ፋቸሮ Ꮊቃንካንታ ኤድ ሙደና የሱሰም ዎልካንታ ዝገሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","የሱስ ይንታ ካርንካ ጎርስምድባብከዝደር ሰደሮ፥ የታ ሪካየንባብከስ አንጅምስባበቴ! ሳብታ ባንችምና የ ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","የታ ታ ዳቀርድባብከሶ አንጅምስባበቴ! ቡር ምዝደቴ፥ የታ ታ ኤብድባብከሶ ጭለቴ! ቡር ይንጭተረቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ኤድንከስ ኤድ ይንችጎካ የም ቦዝድንካ፥ ይንታ ዎክያርንካ የም ፋዝድንከከ የም ከት ይንኤርድንካ፥ ዳቅል ላምከረ ከት የም ኤልድንካ የታ አንጅምስባበቴ! ");
INSERT INTO gyl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ይና የንታ ናክና ጭላር አንድሬ፥ ኮትᎺይካ የም ጉርምሳ፥ ኮካንተረ ጎብከቴ፥ ኤና እሪ ኬታ ባቤንከሰረ ሳብዘንካ ኤሰርሶ ከዛቅባብከስመረ ከት ይያᎺቃንዳ ኮትኮግንዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","የታ ቆልመንባብከሶ ታ የም ኡርድንደትም ሙዳ የ Ꮊፍሳንካንታ የም የኤ! ");
INSERT INTO gyl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","የታ ታ ምስባብከሶ የም የኤ! ቡር ዳቀርደቴ። የታ ታ ይንጭድባብከሶ የም የኤ፥ ቡር ሞርእደቴ አነረ ኤብደቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ኤድንከስ ሙደና የጎካ ኡርመንም ኬዝድንካ የም የኤ! ኤና እር ከታ ባበንንከስ ሳብዘንካ ኤሰራክዶቆ ካርከካ ከዛቅባብከስካንተረ ኮትኮግንዳ ይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ኬዛርንካ ማቼ የ እም ኤሰርድባብካንታ ጋይድቴ፥ የንታ ይምኤንባብከስም ሶልምከቴ፥ የም ቦዝድባብከስካንተረ ኡርመንም ይከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","የም ባድባብከስም አንጅከቴ፥ የንዘን ዳቅል ፍግዝድባብከስካንታ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ዋልቃ ከቸን የስታ ጫቅድባብካንታ አብን ከቸን ጉጅሶ ሰችካ፥ የስታ ዘንንደት አፍለን ተይድባብካንታ የስታ ሳምዝነረ ክትም Ꮊይ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","የዝደር ምግዝድባብ ሙደንም እምካ፥ የስታ ርን ተይድባብ የስካንታ ማዝድንግንዳ ክትም Ꮊዮይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ኤድንከስ ይ ዝግድንደትም የካንታ ይድንግንዳ የተረ ኮት ግንዳ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“የም ሶልምድባብም የ ሶልምሴ Ꮊረንት ስግዳን ር Ꮊብዳ? ጎመንባብከሰረ ዎራ ይም ሶልምድባብከስም ሶልምደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","የካንታ ኡርማ ይስባብከስካንታ ኡርመን የ ይሴ Ꮊረንት ስገድን ር Ꮊብዳ? ጎመንባብከሰረ ዎራ ኮትኮግንዳ ይደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ታልቀንም ማዝዴ የ ጋይድባብካንታ የ ታልቅዴ Ꮊረንት ስገዳን ር Ꮊብዳ? ጎመንባብከሰረ ዎራ ይ ታልቅሳንደትከካ ማስት ተይካንታ ‘ጎመንባብከስካንታ’ ታልቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ኬዛርንካ ማቼ የታ የንታ ይምኤንባብከስም ሶልምከቴ! ኡርመንም ይከቴ፥ ‘ማስት ተይካንተረ ጉርም ይያከት ዶቆ’ ታልቅከቴ፥ ኮትኮከረ የንታ ናክነረ አንድር ማተሬ፥ ሙደንዘንካ ስግ ሳብንታ ይንች ማተረቴ፥ ኖ ጋለዳክንባብከስካንተኬ ዳቅልንከስካንታ Ꮊልስሜ። ");
INSERT INTO gyl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ጭላር የንታ ባቤና አጨርድባብ ክት ማቻንግንዳ የተረ አጨርድባብ ማትከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ꮊይ ፋረደቴ፥ ሳብ የንዘን ፋረተራክዬ፥ Ꮊይ ጩበቴ፥ ሳብ የንዘን ጩባዬ፥ ነጋ ጋይከቴ፥ ነጋ ጋይምተረቴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","እምከቴ፥ የካንታ ሳብዘንካ እምምተሬ፥ የ ማግድን ርንካ ማስሶ ሳብ የካንታ ማግድንኦል፥ ቅምሰርሳንዳ፥ የርቅሰርሳንደትኬ ጮጭሶ ዉልእምድንዳ ኡርማ ማከርድንደትካ ማክምሶ የካንታ ስጥንዳ እምምተሬ”። ");
INSERT INTO gyl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ጉጅሰረ “ዝልና ዝልንም ጎርስካንታ ማዶ? ቃስተና የድምሰኮ ጎርያር አርዳየኮ? ");
INSERT INTO gyl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ክታ ካርንካ ጎርስምድባብ ኤስዝድባብዘንካ ስጋዬ፥ ኬዛርንካ ማቼ ዝግዝድንከካ ኤስባብ ኤድ ሙደና ኤስዝድባብግንዳ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“የስታ እስመንታ አፍናር ዶቅድን ፍንጭን Ꮊረተስ ሰዳ? የስታ አፍናር ራቻንደትም ዛቤንም ሰዳካ? ");
INSERT INTO gyl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","የስታ አፍንታ ዋር ዶቅድንደትም ዛንበን ሰዳካይ ዶቆ የስታ እስመንም ‘የ እስታ እስመኖ፥ የስታ አፍያር ዶቅድን ዳቅልን ዉችትቶ’ Ꮊስግንደስ ጋይካንታ ማዳ? የና ኦትረንባቦ፥ እርምሶ የስታ አፍናር ራቻንደትም ዛንበንም ዉችካ፥ ኮታ ቡር የስታ እስመንታ አፍናር ዶቅድን ዳቅልንም ዉችካንታ ኡርስት ሰዳዬ” ኩንጋየሮ ካምስካ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ኡርማ Ꮊቃ ማትሶ ዶቅድዮ ዳቅል አፍ ኡዝድንዳ ካዬ፥ ኮትኮግንደረ ዳቅል Ꮊቃ ማትሰረ ኡርማ አፍ ኡዝድንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ꮊቃ ሙደና ይንታ አፍንካ ኤስምዴ፥ ጋልዘንካ በለስ ጋይምድን Ꮊቀንታ አፍ ካምማዬ፥ Ꮊልምዘንካ ዎይን ጋየርድን Ꮊቀንታ አፍ ካምማዬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ኡርማ ኤድ ይንታ ቡደናር ጮጫን ኡርማ ሪይናርንካ ኡርመንም ዉጅዴ፥ ዳቅል ኤድነረ ይንታ ቡደናር ጮጫን ዳቅል ሪይናርንካ ዳቅል ሪንም ዉጅዴ፥ ኤድ ይንታ ቡዳር ጮጫንደትም አፈካ ኬዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“እ የም ጋይድንደትም ይዳከቴ፥ ይና Ꮊረተረ ‘ጮይስዮ! ጮይስዮ!’ የ እም ጋይድንዳ? ");
INSERT INTO gyl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","እዝደር Ꮊድባብኬ እስታ ቃለንም ኤሰርሶ ቦድባብ ሙዳ Ꮊይም ክት ካምዳናንከረ እ የም ሰቻ፥ ");
INSERT INTO gyl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ኤሄን ይንታ ዎድካንታ ማለካ ኮይስባብከ ላዝንታዘን ዎጅባብ ኤችንም ካምዴ፥ ሳፍ ሎቀና Ꮊድሶ ኮትኮ ኤሄንም Ꮊንቅሴ፥ ላዝዘን ዎድምሳንኦል ሶክካንታ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","እስታ ቃለንም ኤሰርሶ ቦዳክባብ ማቼ ኤሄን ኮያክዶቆ ፍጨዘን ዎጅባብ ኤችንም ካምዴ፥ ሳፍንታ ጮጭነረ ኤሄንም Ꮊንቅሳንደትካ ሳነካ ዋቼ፥ አንድር ካርችምሴ”። ");
INSERT INTO gyl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","የሱስ ኮም ሙዳ ዎርሰንታ እሪ ኬዝሶ ይ በይሳንደታ ቡር ቅፍራናሆማር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ኮታረረ ፖልስንከስም ገችዝድባብ ዋልቃ ሮማ ፍጫ ኤች Ꮊቄ፥ አንድር ክት ሶልምድን ፍክስንባብ ሰቀርሶ ደእካንታ የልሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ኖየረ የሱሳ ጎካ ይ ኤሰርሳንደትካ ፍክስንባብም ክትካንታ ፋጅድንግንዳ ኦይሳባብ አይሁድንከስታ ጋልተንከስም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ከተረ የሱሰደር Ꮊድሰኮ፥ “ኮም ክትካንታ ይ የስም ዝግዝድባብ ኤቼ፥ ");
INSERT INTO gyl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ꮊረታ ጋይሴ ኮና ኤችና ዎንታ ዎርሰንም ሶልምደ፥ ዎንታ ምክስ ኤሄንመረ ዎችስባብ ኖዬ” ኩን ጋየረኮ ዳቅስሶ ክትም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","የሱሰረ ከትካ ክክን አይሴ። ኤችንታ ኤሄንደር ክት የልሳንደትካ፥ ፖልስንከስም ገችዝድባብ ይንታ ሱሰንከስም ኦይትሶ፥ “ጮይስዮ፥ እስታ ኤሄንታ የለንታ ጎይካ የስም አርድ ዝግዝድን ኤድ ካይቴ Ꮊይ ጋፌ ");
INSERT INTO gyl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","እተረ የስታ እር ዎራ ቅንችም ዝግዝድንግንዳ እስታ ማተንም ፋይዳይቴ፥ ኮ ኦል ዋልቃ ቃላ Ꮊክ ኬዝካ፥ እስታ ፍክስንባበረ ፋጭዴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","እስተረ ዘርመካ እም ክድባብ ዶቅዴ፥ እስታ ጎይከረ እ ክድባብ ዳምንባብከስ ዶቅደኬ፥ ዋልቃባብም ‘አይካ!’ እ ጋይድንካ አይዴ፥ አብንም ‘ኮሬ!’ እ ጋይሴ Ꮊዴ፥ እስታ ፍክስንባብመረ፥ ‘ኮም ይካ!’ እ ጋይድንካ ይ ክትምሳንደትም ይዴ” ኩንጋይሶ የሱሰደር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","የሱሰረ ኮም ኤሰርሶ በርእሴ፥ ዋልን ጋይሰረ ጎርስምድ Ꮊቃን ዎርሰንም፥ “ኮግንዳ ዶቅድን አንድር አሜንን እስራኤልንከሳርንካ ዎራ Ꮊፋክቴ” እታ የም ጋይድቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ክትምስባብ ኤድንከሰረ ፖልስንከስም ገችዝድባብታ ኤር ከት ማድንካ ፍክስንባብ ፋጭሶ ዶቅድንካ ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ኮታ ቡር የሱስ በድ ዶቃክዶቆ ናይን ጋይምድን ካተመናር አይሴ፥ የሱሰታ ካርንካ ጎርስምድባብከስከ በድ ዎርሰረ ክትካ ክክን አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ኦስ ካተመንታ አርድንታ ፍልተንደር የልድንካ፥ ኤድንከስ ዋልቃ ኤችታ ለይስ ባልሰኮ ካተመናርንካ ዉተደኬ፥ ደእስባብነረ እንደንታ ዋልቃ ይንችኖ ይንትዬ፥ እንደነረ ቡድኔ፥ ካተመናርከረ በድ ዎርሰና ኮትካ ክክን Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ጮይሰረ ኮትም ይ ሰዳንደትካ አጨርሶ፥ “ዛብካ Ꮊይ ኤፌ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","እጵን ከደር ጋይሶ Ꮊቸንም ዎልሴ፥ ባልስባብ ኤድንከስ ዎእሰኬ፥ የሱሰረ፥ “የና ይንችን ማርንድኖ የና አምካ እታ የስም ጋይድቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ደእስባብ ይንችነረ ሰንፐና ክታ Ꮊድንካ ጬክን ጋይሶ ዶቅሶ ኬዘረ የጄ። የሱሰረ ተዮ እንደንካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ከት ሙደንም ጳስ የጅንካ “አንድር ማችባብ ሳብዘንካ ኤሰርሶ ኬዝድባብ ዎንታ ዎክያርንካ አምቴ”፥ “ሳብ ይንታ ዎርሰንም አቅስካንታ Ꮊቴ” ጋየረኮ ሳብም ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ኮነረ የሱሰታ ይተና ይሁዳ ፍጨን ሙደናርኬ የለናር ዶቅድን ፍጫ ሙደናር ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ዮሀንሰታ ካርንካ ጎርስምድባብከሰረ ከናከስም ሙዳ ዮሀንስካንታ ኬዘኬ። ኖየረ ከታ ዎክያርንካ ቃስተንን ኤልሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","“ኖ Ꮊዴ ጋይምስባብ አቅስንባብና የኖ? አና አብኖንት ካርስተሮ? ጋይከቴ” ጋይሶ ጮይስ የሱሰደር ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ኤድንከሰረ የሱሰደር Ꮊድሰኮ “ስእስንባብ ዮሀንስ፥ ‘ኖ Ꮊዴ ጋይምስባብ አቅስንባብና የኖ? አና አብኖንት ካርስተሮ?’ ክትም ኦይስከተ ጋይሶ ዎም ኦይቼ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ኮትᎺይካ የሱስ በድ ኤድንከስም ሰቅማርኬ Ꮊዝማርንካ ፋችሴ፥ ቱና አያንንከስመረ ዉችሴ። በድ አፍ ዝልንከስተረ አፍንም ሰድንግንዳ ይስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","የሱስ ዮሀንሰደርንካ ክትምሶ Ꮊድባብከስመረ፥ “አይሰቶ የ ሰዳንደትምኬ የ ኤሰርሳንደትም ዮሀንስካንታ ኬዝከቴ፥ አፍ ዝልንከሰረ ሰተረኬ፥ ዱት ዎብንከሰረ ᎺላᎺል ሙክተረኬ፥ እጳ ሰቅምንክንባብከስ ኡርተረኬ፥ ቃም ቱንንከሰረ ኤሰርተረኬ፥ ደእስባብከሰረ አምተረኬ፥ ሪካየንባብከስካንተረ ክላ ኬዘና ሳባክምተረ፥ ");
INSERT INTO gyl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","እንካ አሜንምንካ Ꮊኤርዳክባብ ኤድ ሙደና አንጅምስባቤ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ዮሀንሰዘንካ ክትምስባብከስ አይሳንደታ ቡር የሱስ ዎርሰንካንታ ዮሀንስጎካ ኬዛ የጄ፥ የታ ቆቸናር Ꮊራ ሰድንካንተንት ዮሀንሰደር ዉተዳሬ? ዞገና ሶግዝድንደትም ሱንባቀኖ? ");
INSERT INTO gyl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","አነረ Ꮊራ ሰድንካንተንት ዉተዳሬ? ላቅምሳን አፍለን ቆበርስባብ ኤድሞ? ላቅምሳን አፍለካ ሰግድባብኬ Ꮊላ ጋይሶ ዶቅድባብከስ ባንችንከስታ ኤሄናር ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ይና! Ꮊራ ሰድንካንተንት ዉተዳሬ? ሳብዘንካ ኤሰርሶ ኬዝድባብም ሰድንካንታ ዳቶ? ይዬ እታ የም ጋይድቴ፥ የ ሰድንካንታ ዉተዳንዳ ሳብዘንካ ኤሰርሶ ከዝድባብዘንካ ስገድባብሜ። ");
INSERT INTO gyl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ኩን ጋይምሰረ ክትካንታ ጻፍምስባብ ኖዬ፥ ጎግንም የስታ እር ኡርዝድባብ እስታ ክተንም ተይሶ አይድባብም የስታ እር ኦይትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“እታ የም ጋይድቴ ማናዘንካ አጥርምስባብከስታ ዎክያርንካ ዮሀንሰዘንካ ስገድባብ ካዬ፥ ሳብ ባንችምናር ማቼ ሙደንዘንካ ቶግድባብ ዮሀንሰዘንካ ስገዴ” ኩንጋየሮ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ኮም ኤሰርስባብከስ ሙደና፥ ቃረጭን ተችዝድባብከስ ዎራ ነጋክናና ዮሀንሰታ ስእስን ስእረሮ ሳብታ ፍክስና ጭል ማትንተን ኤሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ፈረሳዊያንንከስ ሙሴታ ህግንም ኤስዝድባብከስ ማቸ ዮሀንሰታ አንያር ስኤራክንካንታ ሳብ ከትም ጋይሳን ክተንም ግርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ኮታዘንከረ የሱስ፥ ይና ኮ አጥርንከስም Ꮊረክስ ካምስቴ? Ꮊረመክ ካምዳ? ");
INSERT INTO gyl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ጋባ ካርዘን ዶቅሰኮ ክክ ኤልመረኮ፥ “አንዳለንም የካንታ ፉግዞቴ፥ የታ በይዳከቴ፥ የካንታ ሳችንም ሳችሶቴ፥ የታ ኤፋከቴ፥ ኩን ጋይድን ይንችንከስም ካምደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Ꮊራካንታ ጋይሴ ስእስንባብ ዮሀንስ እቻክሳ ዎይን ዎጭምን ዎጫክሳ ክት Ꮊድንካ ግምዛ ክታዘን ዶቅዴ ጋይሰቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ኤድ ይንችና እቸሮ ዎጨሮ Ꮊዴ፥ ኮና ኤችና እችምባብ፥ ዎጭምባብ፥ ቃረጭን ተችዝድባብከስተኬ ጎመንባብከስታ ሱሴ ክትም ጋይሰቴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ይና ኤጨና ገታ ማትንተና ዶፈን ኮትም ተይባብከስታ ባንግር ኤስምዴ”። ");
INSERT INTO gyl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ኮታ ቡር ፈረሳዊንንከሳርንካ ዋልቀና እችምን ይንካ ክክን እጅድንግንዳ የሱሰም ኤልሴ፥ ኖየረ ፈረሳዊያንታ ኤሪ አይሶ እችምካንታ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ኮትኮ ካተመናር ዶቅድንዳ ዋልቃ ጎመክንዳ ኤተን የሱስ ፈረሳዊያንንደር ኤር እችምንዘን ክት ዶቅድንደትም ኤሰርሶ ዋልቃ አልብስጥሮስ ጋይምድን ሰይንዘንካ ኡርስምሳን ብልቃትካ ጮጭ ዎዝድንደትም ተይሶ Ꮊዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","የሱሰታ ቡርጎካ ክታ ዱትንታ ላማር ዎእሶ ኤፈሮ ክታ ዱትንም ይንታ ኤርመንካ ጫፍሰሮ ይንታ ማተንካ ሱተረ የጄ። ክታ ዱትንመረ ሶንቀሮ ዎዝድንደትም ሳይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ኤልስባብ ፈረሳዊያንና ኮም ይ ሰዳንደትካ፥ “ኮና ኤችና ሳብዘንካ ኤሰርሶ ኬዝድባብ ይ ማቸስናና ክትም ዎልሳንደና ኤተንና Ꮊይ ኮት ማቸረ፥ ጉጅሰረ Ꮊራ ኤተን ኮት ማቸረ ኖ ኤስተርዶቆ፥ ና ጎመንዴ” ጋይሶ ይንታ ቡዳር ገቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","የሱሰረ፥ “ስምኦኖ እ የስም ኬዝድንዳ ር ዶቅዴ” ጋይሴ። ኖየረ፥ “ኤስስንባቦ! እም ኬዝካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","የሱሰረ “ዋልቃ ታልቅድባብዘንካ ብራ ታልቅስባብከስ ቃስተን ኤድ Ꮊቀኬ፥ ዋልቃባብና ዶንቅ ጨታ ጣገራ ብራ፥ ቃስትምስነረ አና ቃስተን ቦንደከ ታማ ጣገራ ብራ ክታዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ናግድንዳ ከትም ካይድንካ ባዘንም ከት ቃስተንን ካንታ ዛቅሴ። ይና ከት ቃስተን ታልቀንባብከሳርንካ ስክስሶ ክትም ሶልምድባብ Ꮊምነረ?” ");
INSERT INTO gyl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ስምኦነረ “በድ ባዘንም ክትካንታ ዛቅምስባቤ” ጋይሶ ማስሴ። የሱሰረ “ገታ ኬዛዬ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ኮታዘንከረ ኦስ ኤተንንደር ዋልን ጋይሶ ስምኦነደር፥ “ኮትኮ ኤተንን ሰዳዶቅዳ? እታ የስታ ኤር አርደዳቴ፥ የና እስታ ዱትታ ሎቃ ዎራ እማከዬ፥ ናማቼ እስታ ዱትን ይንታ ኤርመንካ ጫፍሰሮ ይንታ ማተንካ ሱቼ። ");
INSERT INTO gyl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","የና ቦድሶ እም ሶንቀረዮ አቦ ጋያከዬ፥ ናማቸ እ አርደዳንዘንካ የችሶ ዱትን እስታ ሶንቀሮ አቦ ጋይን ዛቃክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","የና እስታ ማተንም ዛይትንካ ሳያከዬ፥ ናማቸ እስታ ዱትንም ዎዝድንደትካ ሳይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ኮካንታ እታ የስም ጋይድቴ፥ አንድር እም ኮት ሶልምሳንጎካ በድ ጎመና ኮታ ላላ ጋይምቴ፥ መርሰካ ላላ ጋይምስባብ ማቼ ክት ሶልምድንዳ ቶክምኬ” ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","የሱሰረ ኤተንንም “የስታ ጎመና ላላ ጋይምቴ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ክትካ ክክን እችምዘን ዶቅድባብ ሶችንከሰረ፥ “ኮና ጎመንም ዎራ ላላ ጋይስዝድባብ ኖ Ꮊይራ?” ጋይሰኮ ክክ ክክ ከዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","የሱሰረ ኤተንንም፥ “የስታ አሜንና የስም አቅስቴ፥ ኡርመካ አይካ!” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ኮታ ቡር የሱስ ሳብታ ባንችምንታ ክላ ኬዘንም ኬዘሮ ካተመናርኬ ሞረንከሳር ኦንግድ Ꮊቄ። ታሜከ ቃስቴንንከሰረ ክትካ ክክን Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ኮትኮግንደረ ቱና አያንይ ከታዘንካ ዉተድባብከስከ Ꮊዝማርንካ ፋጭባብ ዋልቃ ዋልቃ ማነንከስ ክትካ ክክን Ꮊቀኬ። ከተረ ታብዛ ግምዘንከስ ኮታዘንካ ዉተዳንዳ መግደላ ፍጫርንካ Ꮊዳንዳ ማራሜ፥ ");
INSERT INTO gyl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ሄሮድሰታ ኤር ፍክስንባብከስም ገችዝድባብ ኩዘታ ኬነና ዮሀና፥ ሶስነኬ አበረ በድንከስ Ꮊቀኬ፥ ከታ ከነረ ይንታ ዶቅድን ሪንካ የሱሰምከ ክታ ካርንካ ጎርስምድባብከስካንታ አሌንም አልድዮ Ꮊቅባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","በድ ዎርሰና ዋልቃትቸካ ሳንምሶ ከትዶቅድንካ፥ Ꮊክ Ꮊክ ካተመናርንካ ኤድንከስ ፈንክ ክደር ሳንምስንካ፥ ኮም ካምስንከስንም ኩንጋየሮ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ዋልቃ ዎንንባብ ማሰንም ማሳካንታ ዉተዴ፥ ክት ማዝድንከረ ዋልቃ ዋልቃ ማሰንከስ ጎግታ ካንታር ዋቼ፥ ዱትያረረ ሙክምሴ፥ አፍትንከሰረ እቸኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ዋልቃ ዋልቃ ማሰንከሰረ ስልዘን ዋቼ፥ ባቀልሳንግንዳ ፍጨና ኡድማ ማታክንካንታ ዎቼ። ");
INSERT INTO gyl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","አብ ማሰነረ ጋልታ ዎክያር ዋቼ፥ ጋልነረ የካ ጋጵሶ ጉንሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","አብነረ ማሰና ኡርማ ፍጨዘን ዋቼ፥ ባቀልስንደትከረ ጨታ ዘን ጉጅሶ ኮትከካ ኡሴ”። ኮም ኬዝት ይ በይሳን ቡር ኡፍስን ይንታ ጬክሳ ይይሶ፥ “ቃም ዶቅድባብ ኤሰራ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","የሱሰታ ካርንካ ጎርስምድባብከሰረ ካምስንከስታ ቡልንም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ኖየረ “ሳብታ ባንችምንታ አችምሳንደትም የ ኤዝድንግንዳ የካንታ እምምቴ፥ አብንከስካንታ ማቼ ካምስካ ኬዝድቴ፥ ኮነረ፥ “ሰደረኮ ቡደርዳክንግንዳ፥ ኤሰረረኮ ገቀርዳክንግንዴ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ይና ካምስንከስታ ቡልና ኮኔ፥ ማሴ ጋይምሳንደና ሳብታ ቃሌ። ");
INSERT INTO gyl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ጎግንታ ካንተንዘን ዋቻንዳ ቃለንም ኤሰርድባብከሴ፥ ኬዛርንካ ማቼ አሜንሶ ከት አቅዳክንግንዳ ዳብሎስ Ꮊድሶ ቃለንም ከታ ቡደናርንካ ተይዴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ስል ካርንዘን ዋቻንደረ ቃለን ኤሰርድዮ ጉርምካ ተይድባብከሰከ፥ ከታኬና ሰጨታ አመንደክዳት ጫጭ ከታ ካየንካንታ ጰጨና የልድንᎺይካ ሳነካ ካድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ጋልንታ ዎክያር ዋቻንደረ ቃለንም ኤሰርድባብከሰኬ። ኬናከሰሬ ኮ ፍጫሙደንታ ገቅር፥ ቆልመከ Ꮊላ ጋይሶ ዶቅንትና ጉንእት ከትም የጅንካ አፍካይሳ ከትም ማዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ኡርማ ፍጨንዘን ዋቻንደረ ቃለንም ሉለከ ኡርማ ማቻን ቡደካ ኤሰርሶ ካርዝድባብከሴ፥ ከተረ ቃለንካ ዳቅሶ አፍ ኡዝድባበኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ዞጰንም ዞጵስትዮ ዳሀ ባከንታ ዋር ናንከረ ሰለታ ጎያር ዎድባብ Ꮊየነረ ካዬ፥ ስክስሰረ ኤሄንታ ዋር አርደድባብከስ ሳክመንም ከት ሰድንግንዳ ዞጰንካንታ ኡርሰርሳን ካርንዘን ዎዴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ኮትኮግንደረ መያ ማዳክንዳ አችምሳንዳ፥ ኤስምዳክንዳ ሳክማር ዉዳክንዳ አጥምሳን ር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ኮካንታ Ꮊስግንዳ የ ኤሰርዳናንከረ ካርስምከቴ፥ ይና ዶቅድባብካንታ ጉጅምዴ፥ ካየንባብዘንካ ና ክታ ዶቅድን ካምድንደረ ሙዳ ዎራ ክታዘንካ ተይምዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ኮታ ቡር የሱሰታ እንደንኬ እስመንከስካ ክት ዶቅድንደታር Ꮊደኬ፥ ከተረ ዎርሰንታ በድምንዘንካ አምሳንዳ ክደር የልካንታ ማታከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ኮካንታ “የስታ እንደንኬ የስታ እስምንከስ የስም ሰድንካንታ ዝግሰኮ ማል ዎእተኬ” ጋይሰኮ የሱሰደር ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ኖየረ ማስሶ፥ “እስታ እንደንኬ እስታ እስመንንከስ ሳብታ ቃለንም ኤሰርሶ ይድባብከስኬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ዋልቃ Ꮊይካ የሱስ ይንታካርንካ ጎርስምድባብከስካ ክክን ሎቀንዘንካ ቃለርድን ጃልበናር አርድሶ፥ “ባሀርንታ ፋማ ዎ ቃላ” ከደር ጋይሴ፥ ከተረ ጃልበንካ አይ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ከት አያዶቅድንካ የሱሰም ግንእስ የጅንካ ራቼ፥ ኮታይካ ባሀርንታዘን ዞጋ የጄ፥ ሎቀነረ ጃልበንታ ዋር አርደዳንጎካ ኤቅዝምካንታ የልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ክታ ካርንካ ጎርስምድባብከሰረ ክደር “ማተን ቆልስባቦ ማተንቆልስባቦ፥ በእታ ይዶቴ!” ጋየረኮ ክትም ንግሰኬ። ኖየረ ንግሶ ዞገንምኬ፥ ሎቀንዘን አምድን ቡርበችን ዋጬ፥ ኮታዘንከረ ዞገንኬ ሎቀንዘን አምሳን ቡርበችና ዛቅሴ፥ ስምነረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ኖየረ ይንታ ካርንካ ጎርስምድባብከስም “የንታ አሜንና Ꮊማ?” ጋይሴ። ከተረ ጳሰረኮ አና በርኤረኮ፥ “ኮና ዞገንምከ ሎቀንም ክድባብ፥ ከተረ ክትካንታ ክትምድባብ ኖ Ꮊይራ?” ክክ ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ኮታ ቡር ገሊላ ፍጨንታ ፋማ ዶቅድን ኦስ ገርገሰኖን ፍጨናር ጃልበካ ቃልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","የሱስ ጃልበናርንካ ፍጨዘን ይ Ꮊንቸርሳንደትካ ግምዘንከስካ የደርስባብ ዋልቃ ኤች ኮትኮ ካተመናር የሱሰካ Ꮊፈርሴ፥ ኖኮና ኤችና በድᎺይካ አፍላ ቆበራክዶቆ፥ ኤሀረረ ዶቃክዶቆ፥ ዱክ ካርመረ ይንታ ኤሀ ማስስባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","የሱሰመረ ይ ሰዳንደትካ ፍፈሮ ክታ እር ቡከልሴ፥ አንድር ኡፍስከረ “ሙደንዘንካ ስግ ሳብንታ ይንችን የሱሶ! እንካ ክክን Ꮊራ የስታ ዶቅዳ? እም የስ ማእዝዳክንግንዳ እታ የስም ምግዝድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ቱና አያንና ኮም ጋይሳንዳ ኤችንዘንካ ክት ዉታባብ የሱስ ክትሳንጎኬ። ቱና አያነረ ሙዳ ሰጨካ ክታዘን አምድንካንታ ኤችና ሳንቸለትካ ክታ አንንኬ ዱትያር ስብልካ ዞክርሶ ካርስምስንከረ ዞከርሳን ዱትናር ስብልን ታክሰሮ Ꮊቃን ግምዘና ቆቻር ክትም ተይ አየሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","የሱሰረ “የስታ ላምና Ꮊይራ?” ጋይሶ ክትም ኦይሴ፤ ኖየረ በድ ግምዛ ክታር አርድሶ Ꮊቃንጎካ “እስታ ላምና ለጎኔ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ግምዘንከሰረ ጩልጩል ጎርናር አይከቴ ጋይሶ ክዳክንግንዳ ዳቅስሶ ክትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ኮት ሞረናር ገቸንታ ዎክያር በድ ጉድምንከስታ ዉዳ ግስምድ Ꮊቄ፥ ግምዘንከሰረ ጉድምንከስታ ዉደናር አርድከቴ ጋይሶ ከትም ጋይተርንግንዳ ምክሰኬ፥ ኖየረ ኬትም ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ግምዘንከሰረ ኤችንዘንካ ዉትሶ ጉድምንከሳር አርደደኬ፥ ጉድምንከስተረ ዉደና ገቸንታ ዱረንዘንካ ጩላ ታድምካ ባሀርናር አርድሶ ኤቅዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ግስመንባብከሰረ ማቻንደት ሪይንም ሰጃንደትካ ዞድሶ አይንተካ ካተመናርከ ፍጨን ኮታር ሙዳ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ዎርሰነረ ይምሳንደት ሪይንም ሰድንካንታ ይዶቅድንደታርንካ ዉትሰኮ የሱሰደር Ꮊደኬ። ግምዘንከስ ዉተድባብ ኤችነረ አፍላ ቆበርሶ ቡደካ ማትሶ የሱሰታ ዱትንታ ጎያር ዶቅስንካ ሰድሶ ጳሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ግምዘካ የደርስባብ ኤችና አቃንደትም ሰድባብከሰረ Ꮊስግንዳ ክት አቃናንከረ ዎርሰንካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ገርገሰኖን ፍጨንታ ሞረናር ኤድንከስ ሙዳ አንድር ከታ ይ ጳሳንካንታ፥ ኮታርንካ ክት አይድንግንዳ የሱሰም ምክሰኬ። ኖየረ ጃልበናር አርድሶ ማትሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ግምዘንከስ ዉተዳን ኤችነረ የሱሰካ የካ ማትካንታ ምክሴ፥ ኖ ማቸ ኩን ጋይንተካ ክትም ኦይቼ፥ ");
INSERT INTO gyl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“የስታ ኤር ማትሰዮ ሳብ የስካንታ ይሳንደትም አንድር ሪንከስካ” ኤችነረ የሱስ ክትካንታ ይሳንደትም አንድር ርን ካተመናር ሙዳ መያ ኬዘሮ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ዎርሰና ሙዳ ክታ Ꮊድንተን ካርሰሮ Ꮊቃንጎካ የሱስ ማት ክት Ꮊዳንደትካ ጉርምካ ሞክት ተየኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ኮትኮᎺይካ እያእሮስ አይሁድንከስታ ምክስ ኤሄንታ ገችንባብ Ꮊድሶ፥ የሱሰታ ዱትንዘን ዋችሶ ይንታ ኤር ክት Ꮊድንግንዳ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ኮመረ ክት ምክሳንዳ ስለና ኮታ ታመከ ቃስተን ስላ ማቻንዳ ዋልቃ Ꮊክ ክታ ይንቸን ኮት ማቻንካንቴ፥ ና ደእካንታ የልሶ Ꮊቄ። የሱስ ኦስ አያዶቅድንካ ዎርሰና ጉትነካ አንድር ክትም ማእዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ታመከ ቃስተን ስላ ማቀስ ዉልእምድንካ ዶቅድንዳ ዋልቃ ኤተን Ꮊቄ፥ ይንታ ዶቅድንደትም ሙዳ ኤልንባብከስካንታ በይስንከረ ኮትም ፋችካንታ Ꮊየነረ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ናየረ የሱሰታ ቡርጎካ እጵን ጋይሶ ክታ አፍለንታ ካንተንም ዎልሴ፥ ዉልእምድዮ Ꮊቃን ማቀስነረ ሳነካ ኮታ ዎእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","የሱሰረ “እም ዎልስባብ Ꮊይራ?” ጋይሴ። ሙደነረ ዎታ ዎላኮቴ ጋይስንካ ጴጥሮስ “ማተን ቆልስባቦ! ዎርሰና ሙዳ የስታ ካንተንም የድሶ ጉትነካ የስም ማእዝዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","የሱስ ማቸ “ዋልቃ ኤድ እም ዎልቴ፥ ዎልቃ እዘንካ ዉተዳንደትም እታ ኤዝድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ኤተንነረ ካቸካ አይካንታ ኮደር ማትማክንደትም ይ ኤሳንደትካ ጭጨሮ Ꮊድሶ ክታ ዱትንዘን ጉፕን ጋይሴ፥ Ꮊረታ ይ ዎልሳናንከረ አነረ Ꮊስግንድ ሳነካ ይ ፋጫናንከረ ዎርሰን ሙደንታ እር ና ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ኖየረ “እስታ ይንቸኖ፥ የስታ አሜንና የስም ፋችቴ፥ ኡርመካ አይካ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","የሱስ አክ ኬዘዘን ዶቅድንካ ዋልቃ ኤች አይሁድንታ ምክስ ኤሄንታ ገችንባብ እያኢሮሰታ ኤርንካ Ꮊድሶ “የስታ ይንቸንና ደእቴ፥ ኮታ ቡር ኤስስንባብም Ꮊይጋፍሰ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","የሱሰረ ኮም ኤሰርሶ እያእሮሰም “አሜንካ ዳት Ꮊይ ጳሴ፥ የስታ ይንቸንና ፋጭዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","እያእሮስታ ኤር አርድዮ ጴጥሮስ፥ ዮሀንሰከ ያይቆብካ አነረ ይንቸንንታ ባበንከ እንደንዘንካ አብ Ꮊየሰነረ ክትካ ክክን አርድንግንዳ ጋያክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ኮታይካ ኤድ ሙደና ኮትካንታ ቃየሮ ኤፈሮ Ꮊቀኬ። የሱስ ማቸ “Ꮊይ ኤፈቴ፥ ና ግንእታ ዳት ደአክዬ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ኤድንከሰረ ኮታ ደእንም ከታ ይ ኤሳንካንታ ክታዘን ይንጨኬ። ");
INSERT INTO gyl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","የሱስ ማቸ ኮታ አንን የድሶ “የና ይንቸኖ አምካ!” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ይንቸንንተረ ሰንፐና ማቸ፥ ሳነካ አምሶ ዎእሴ፥ የሱሰረ ኮት እጅድንደትም እምድንግንዳ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ይንቸንንተረ እንደንከ ባበንካ በርእሰኬ፥ የሱስ ማቸ ይይምሳን ርን Ꮊየሰንካንተረ ከት ከዛይንግንዳ ከትም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","የሱሰረ ታመኬ ቃስተን ኦይትምስባብከስም ዋልቃትቸካ ኤልሶ ግምዘንከስም ሙዳ ከት ዉጅድንግንዳ፥ Ꮊዝምንባብከስም ፋችታ ዎልቀንምኬ ገችታ ኤረን ኬትም እምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ጉጅሰረ ሳብታ ባንችምን ሳባግድንግንደከ ሰቀርስባብከስም ከት ፋጅድንግንዳ ከትም ኦይድዮ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“የንታ ጎግንካንታ ጉፋ ማችንከረ፥ ሱልፋ ማችንከረ፥ እችም ማችንከረ ብራ ማችንከረ፥ ቃስተን ኦክሶ የ ቆበርድንደትም አፍለረ ማታ Ꮊረሰነረ የድይ የም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ኮትኮ ካተመናርንካ የ ዉተርን የለልታ እርምሶ የ አርደዳንደታር Ꮊየንተረ ኤር ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ካተመንታ ኤድንከስ የም ሞክሳ ነገዴ ከታ ካተመንም ዛቅሶ አይደቶ፥ ከትካንታ ኤግዝምስ ማድንግንዳ የንታ ዱትንታ ቡልን ድንግስሰቶ ዉትከቴ”። ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ከተረ ኮትኮግንዳ ዉትሰኮ ክላ ኬዘን ኬዘረኮ ካሪ ሙደናር ሰቀርስባብከስም ፋቸረኮ ሞረናር ሙዳ ስገሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ዋልቃ ዋልቃ ኤድንከስ “ስእስንባብ ዮሀንስ ደእያርንካ አምቴ” ጋየረኮ ኬዝድ ከት Ꮊቃንጎካ ገሊላ ፍጨንታ ኦይችምስ ዱት ገችስንባብ ሄሮድሰረ የሱስ ይሳንደትም ሙዳ ኤስርንካ ታንትምሰ፥ Ꮊረታ ጋይሴ ስእስንባብ ዮሀንስ ደእያርንካ አምሴ ከት ጋይድንኦሌ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","አብንከስ ኤላስ ማት Ꮊዳን ግንዳ፥ አብንከሰረ ጉጅሶ ኤና እር ሳብዘንካ ኤሰርሶ ከዝድባብከሳርንካ ዋልቀና ደእናርንካ አምሴ ጋይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ሄሮድሰረ “ስእስንባብ ዮሀንሰታ እታ እስት ክታ ቃደንም ተችስትተ፥ ክትጎካ ኮግንዳ ኩን ከዝምድንካ ኤሰርምድባብ ኖኮና ኤችና Ꮊይራ?” ጋይሴ። ይንታ አፍከረ የሱሰም ሰድካንታ ዝግድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ኦይትምስባብከሰረ ማት ከታ ይ Ꮊዳንደትካ ከታ ይ ይሳንደትም ሙዳ የሱስካንታ ኬዘኬ፥ የሱሰረ ከትም የድሶ በቴሳይዳ ጋይምድን ካተመናር ከትም Ꮊክ ተዮ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ዎርሰነረ ኮትኮም ኤሰርሶ ክትም ጎርስምሰኬ፥ ኖየረ ከት Ꮊዳንግንዳ ሳብታ ባንችምንጎካ ኬዘሮ Ꮊቄ፥ ፋጭ ዝግሶ Ꮊድባብከስም ሙዳ ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ፍጨነረ ሶይትካንታ ይድንካ፥ ክታ ካርንካ ጎርስምድባብ ታመከ ቃስተንንከስ ክደር Ꮊድሶ “ዎ ዶቅድንዳ ኤድ ካየንካር ማቻንካንታ ዎርሰና ዎንታ ካንተንካ ዶቅድን ሞረናርከ ካተመንካየን ካርያር አይሰኮ ይንታ ገችንት ካርኬ እችም ከት ዝግድንግንዳ ከትም ኦይትካ” ከታ ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","የሱስ ማቼ “ከት እጅድንደትም የታ እምከቴ” ጋይሴ። ከተረ “ኮ ሙዳ ዎርሰንካንታ ማድን እችም አይሶ ዎ ሰናክን ማቼ፥ ዎንታ ዶቅድንዳ ዶንቅ ሶለከ ቃስተን ሞለካ Ꮊክዬ” ጋይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ፋይድምስባብከስ ዶንቅ ሳአ ማድባብ አⷝነንከስ ዋር Ꮊቀኬ። የሱሰረ ይንታ ካርንካ ጎርስምድባብከስም “ዎርሰንም ቃስተን ቦንደከታማ፥ ቃስተን ቦንደከታማ ማስሰቶ ከትም ዶቅስከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ክታ ካርንካ ጎርስምድባብከሰረ ከታ ይ ክትምሳንግንዳ ኤድንከስ ዶቅድንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","የሱሰረ ዶንቅ ሶለንምኬ ቃስተን ሞለንም የድሶ ጭላር ሰድሶ ሳብም ጋለቼ፥ አስተረ ዎርሰንካንታ እምድንግንዳ ይንታ ካርንካ ጎርስምድባብከስካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ሙደነረ እችሶ ምሰኬ። ክታ ካርንካ ጎርስምድባብከሰረ ከታዘንካ ስጣንደትም ዶካ ሶለን ታመከ ቃስተን ጋበትካ አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ኮታ ቡር የሱስ ይንት ምክሰሮ Ꮊቄ፥ ክታ ካርንካ ጎርስምድባብከሰረ ክትካ ክክን ማትካንታ ክደር Ꮊደኬ፥ “ዎርሰና እም Ꮊየክ ጋይዳ?” ጋይሶ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ከታርንከረ “ዋልቃ ዋልቀንከስ ስእስንባብ ዮሀንሴ፥ አብንከስ ኤላሴ፥ አብንከሰረ ጉጅሶ ኤና እር ሳብዘንካ ኤሰርሶ ከዛቅባብከሳርንካ ዋልቃባብ ደእያርንካ አምቴ ጋይደኬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ኖየረ “የተስ እም Ꮊየንት ጋይዳ?” ከደር ጋይሴ። ጴጥሮሰረ “የና ክርስቶስ አቅስንባብ ሳብካ እድምስባበዬ” ጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","የሱሰረ ኮም Ꮊየንካንተረ ከት ኬዝዳክንግንዳ ዳቅስሶ ከትም ኤግዝምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ኮታዘንከረ “ኤድ ይንች በድ ማጣ ተይክትም ዝግዝዴ፥ ኮትግንደረ ጋልተንከስ፥ ቄሰንከስም ገችንባብከስኬ ሙሴታ ህግንም ኤስዝድባብከስታ ባንግር ቶችምዴ፥ ደእዴ፥ ማክምስ ሰጨንከረ ደእናርንካ አምዴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ኮታዘንከረ ሙደንካንታ ኩን ጋይሴ፥ “እስታ ካርንካ Ꮊድካንታ ዝግድባብ Ꮊየነረ ዶቅሴ ይንታ ማተንም ክት ዛቃ፥ ይንታ ማዝቀልን ባልሶ ሰጫ ሙደናይካ እም ጎርስማ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ኬዛርንካ ማቼ ሰንፔንም ይንታ ፋችካንታ ዝግድባብ ሙደና ኮትም ካይዝዴ፥ ሰንፔንም ይንታ እጎካ ጋይሶ ኮትም ካይዝድባብ ማቼ አቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ኤድ ኮ ፍጫሙደንዘን ቆልመንም Ꮊፍሶ ይንታ ሰንፔንም ክት ካይስሴ፥ አነረ ክት ዞግሴ Ꮊሮክ ክትም መዬ? ");
INSERT INTO gyl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ꮊየነረ እንኬ እስታ ቃለንካ ኦስንድባብ ሙደና፥ ኤድ ይንች ይንታ ቦንቸንካ፥ ኮትኮግንደረ ሳብ ባቤንታ ቦንቸከ ጭልምሳን ክታይንችንከስታ ቦንቸንካ Ꮊድንካ ክትካ ኦስንተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ዶፈን የም ጋይድቴ፥ ኮዘን ዶቅድባብከሳርንካ ሳብታ ባንችምን ሰዳክዶቆ ደእዳክባብ ኤድንከስ ዶቅደኬ”። ");
INSERT INTO gyl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","የሱስ ኮም ክት ኬዛንካ ላማካይ ሰጨታ ቡር ጴጥሮሰም፥ ዮሀንሰምኬ ያይቆበም የድሶ ምክስካንታ ዋልቃ ገቸዘን ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ምክስዘን ክት ዶቅድንካ ማልክና ክታ ኦክምሴ፥ አፍለነረ ዋልቅንትግንዳ ሮጵድንዳ ጫምሳ ማቸ። ");
INSERT INTO gyl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ይና ቃስተን ኤድ Ꮊድሰኮ ከተረ ሙሴከ ኤላሰካ ክትካ ክክን ኬዝመሮ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ቦንቸከረ መያ ማትሶ ኬዝመሮ Ꮊቃንደረ የሱስ የሩሳሌም ካተመናር ሳብታ ጋይተንም ቦድንደትምኬ የሩስለማር ክት ደእድንንደትም Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ጴጥሮሰከ ክትካ ክክን ዶቅድባብከስ ማቸ ግንእ ከታዘን ደጭንካ ራታ Ꮊቀኬ፥ ከታ ንግሶ የሱሰታ ቦንቸንምከ ክትካ ክክን ዎእስባብ ቃስተን ኤድንከስም ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ቃስተን ኤድንከሰረ የሱስዘንካ ፋስምሶ አይድንካ ጴጥሮስ “ማተን ቆልስባቦ፥ ኮዘን ዎ ዶቅደስናና ዎካንታ ኡርሜ፥ ኮካንታ ማከን ዳልቻ ኡርስተሮቴ፥ ዋልቀና የስካንታ፥ ዋልቀና ሙሴታ፥ ዋልቀነረ ኤልያስ ካንታ ማዴ” ጋይሴ፥ ጴጥሮስ ይ ከዝድንደትመረ ኤሳይ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ጴጥሮስ ኮመረ ክት ከዛዶቅድንካ ኡፓ Ꮊድሶ ከትም ኦቼ፥ ኡፔነረ ከትም ኦጅድንካ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ኡፔንታ ዋርከረ “እ እጅባብ እስታ ይንችና ኮኔ፥ ክትም ኤሰርከቴ!” ኩን ገይድንዳ ኡፍስ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ኡፍስነረ ኤስምሳንደታ ቡር የሱስ ይንት ማትሶ Ꮊፈርሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ርን ይንታ ቡዳር የጀክ ዳት ሰዳን ሪንጎካ Ꮊየንካንተረ ከዛከከ። ");
INSERT INTO gyl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ዛማክንከረ ገቸንዘንካ ከት Ꮊንቸርሳንደታ ቡር በድ ዎርሰና Ꮊድሰኮ የሱሰካ Ꮊፈርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ኮታይካ ዎርሰንታ ዎክያርንካ ዋልቃ ኤች ኡፍስን ይንታ ጬክሳ ይይሶ “ኤስስንባቦ፥ እስታ ዶቅድባብ ይንችና ክት Ꮊክ ማቻንካንታ የስ ክትም ሰተርንግንዳ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ቱና አያንና ክትም የጃንካንታ ገቀራክናና ፍፍስሶ ክትም ቡከልዝዴ፥ አፋ ዱብካ ክትም ጉጵስንደትከ ክትም ይ ኡፈልሳንዳታ ቡር መም ማጠካ ዛቅዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","የስታ ካርንካ ጎርስምድባብከሰረ ከት ቱና አያንን ዉጅድንግንዳ ምክሳቴ፥ ኬዛርንካ ማቼ ከደር ማታክዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","የሱሰረ “የንታዋር አሜን ካየንባብ ዎብ አጥርንከስ፥ Ꮊንታ የለልትስ የንካ ክክን ዶቅዳ? Ꮊንታ የለልትስ የም ዳንዳእዳ? ይና የስታ ይንችንም ፈንካ ተይ Ꮊድካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ይንችና Ꮊድዘን ዶቅድንከረ ግምዘና ፍጨዘን ባልት ኦይትሶ ክትም ጭእሴ፥ የሱስ ማቼ ቱና አያንንም ዋጭሶ ይንችን ፋችሴ፥ ባበንካንታ ማስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ዎርሰነረ ሙዳ ሳብታ አንድር ዎልቀን ሰድንተካ በርእሰኬ። ክት ይሳንደትካ ኤድ ሙደና በርኤረኮ ከትዶቅድንካ፥ የሱስ ይንታ ካርንካ ጎርስምድባብከስም ");
INSERT INTO gyl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ኮም የካንታ እ ኬዝድን ርን ቦድሶ የ በህ ጋያይንግንዳ ኤድ ይንች ኤታ አንያር ስክስምት እምምዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ከታ ማቼ ኮ ኬዘን ገቀርት ተያከከ፥ ከት ገቀርት ተያይንግንዳ ኬዘና ከታዘንካ አችምሶ Ꮊቄ፥ ማስት ክትም ከት ኦይሳይንግንደረ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ከታርንካ Ꮊይ ስገዳናንከረ ክታ ካርንካ ጎርስምድባብከስ ቤርም አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","የሱሰረ ከታ ቡደንታ ገቅርን ኤስሶ ዋልቃ ኡለም የድሶ ይንታ ባንግር ዎይስሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ኖየረ “ኮ ኡለን እስታ ላምንካ ሞግድባብ Ꮊየነረ ዶቅሴ እም ሞግዴ፥ እም ሞግድባብ ጉጅሶ እም ኦይችባብም ሞግዴ። የንታ ዎክያርንካ ሙደንዘንካ ቶግድባብ ኖ ሙደንዘንካ ስገድባብ ማተሬ”። ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ኮተረ ቡር ዮሀንስ፥ “ማተን ቆልስባቦ ዋልቃ ኤች የስታ ላምንካ ግምዘንም ዉጅድንካ ሰዶቴ፥ ዎንካ ክክን ማትሶ ክት ጎርስምዳክንካንታ ማርሶቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","የሱሰረ “Ꮊይ ማረቴ፥ የም ግርዳክባብ ሙደና የንካ ክክኔ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","የሱስ ጭላር ክት አይድን ሰጨና የልሳንካንታ የሩሳሌም ካተመናር አይካንታ ገቀርሶ አምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","እርምሶ ክትምስባብከስም ካተመናር ኦይቼ። ከተረ ማድንደትም እርናና ግግስካንታ ዋልቃ ሳማረታ ሞረናር አርደደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ኮታር ዶቅድን ዎርሰና ማቼ የሩሳሌም ካተመናር ክት ጎርሳዶቅድንኦል ከታ ኤስሰኮ ክትም ሞካካንታ ዝጋከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ክታ ካርንካ ጎርስምድባብከሰረ ያይቆበከ ዮሀንሰካ ኮም ሰድሰኮ፥ “ጮይስዮ! ዋልቃ ዋልቃ ማጻፍና ኤላስ ይሳንደትግንዳ ጋይሶ ጉጅድንደትግንዳ ኖሀ ጭላርንካ Ꮊንቸርሶ ከትም ካይዝድንግንዳ ዎ ጋያባብ ዝግዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","የሱስ ማቼ ዋልን ጋይሶ ከትም ዋጬ። “የታ Ꮊራግንዳ አያናርካ የ ማቻናንከረ ኤዝዳከቴ፥ ኤድ ይንች Ꮊዳንዳ ኤታ ሰንፔም ፋችካንታ ዳት ካይስካንታ ካዬ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ኮታርንካ አምሶ አብ ሞረናረረ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","የሱሰከ ክታ ካርንካ ጎርስምድባብከስ ጎግ ከት አይድንካ ዋልቃ ኤች Ꮊድሶ፥ “የስ አይድንደታር ሙዳ የስም ጎርስምድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","የሱሰረ “ደበንንከስታ ጎር ዶቅዴ፥ አፍትን ከስተረ ኤሀ ዶቅዴ፥ ኤደት ይንችታ ማቼ Ꮊዉስንተታ ካሪ ካዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","አብ ኤችንመረ “እም ጎርስምካ” ክትም ጋይሴ። ኤችነረ “ጮይስዮ እርናና አይስቶ እስታ ባበንም እ ዱክተርንግንዳ እም ጋይካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","የሱሰረ “ደእስባብ ደእስባብከስም ዱግድንግንዳ ከትም ዛእካ፥ የና ማቼ አይሳዮ ሳብታ ባንችምንጎካ ኬዝካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","አብ ኤች አና “ጮይስዮ እታ የስም ጎርስምትቴ፥ ኬዛርንካ ማቸ እርናና እስታ ኤር ኤድንም አቦ እ ጋይድንግንዳ እም ጋይካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","የሱስ ማቼ “እርፍንም የድሶ ቡር ሰድባብ ኤድ ሳብ ባንችምንካንታ ዝግዝድባብ ካዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ኮታ ቡር ጮይስ አብንከስ ማከን ቦንደከ ታመከ ቃስተን ኤድንከስም እድሶ ዶርሴ፥ ይ አይድን ካርያርከ ካተመን ሙደናር ክትም እርምሶ ከት አይድንግንዳ ቃስተን ቃስተን ማስሶ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ከትም ኦይድዮ ስከርድንዳ በድዬ፥ ስክንባብከስ ማቸ ቶክመኬ፥ ኮካንታ ስከርድንደታ ባበና ስክንባብከስም ስከርድንካርዘን ኦይድንግንዳ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ይና አይከቴ፥ ቆልንከስግንዳ ፉገንከስታ ዎክካ የም ኦይትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","የንታ ጎግንካንታ Ꮊረሰነረ Ꮊይ የደቴ፥ ብረታ ካርጭተረ Ꮊይየደቴ፥ አና ጫመረ Ꮊይ የደቴ፥ ጎግዘን Ꮊየንካንተረ አቦ ጋየረቶ የንታ ሳዓትን ጎግዘን Ꮊይ በይሰቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ꮊምን ኤሀረረ አርደቶ እርምሶ ኡርመና ኤሄን ኮካንታ ማታ ጋይከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ሳራትቸን ሶልምድን ኤድ ኮታር ዶቅሴ፥ የንታ ኡርመና ክታዘን ማተሬ። ኩን ማታክንዳ ማቸ የንታ ኡርመና የካንታ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","የካንታ እምሳንደትም ሙዳ እቸረቶ ዎጨረቶ ኮትኮ ኤሄናር ዶእከቴ፥ ፍግዝድባብ ይንታ ፍክስንታ ናክን Ꮊፍ ክትም ዝግዝዴ። ዋልቃ ኤሄናርንካ አብ ኤሄናር Ꮊይ ኦንገቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ꮊምን ካተማረረ የ አርድንካ ኤድና የም ሞክት ተዬ፥ የካንታ ከት እምሳንደትም እችከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ኮታረረ ሰቀርሶ ዶቅድባብከስመረ ፋቸረቶ፥ ‘ሳብታ ባንችምና የንደር ቅንችምቴ’ ከደር ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ኬዛርንካ ማቼ ዋልቃ ካተመናር የ አርድንካ የም ከት ሞካ ግርዴ መለንዘን ዉትሰቶ ኩን ጋይከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ዎንታ ዱትንዘን ዶቅድን የንታ ካተመንታ ቡልን ዎራ የካንታ ኤግዝምስ ማተርንግንዳ ጎግንዘን ዉትሶቶ ድግስተሮቴ፥ ኬዛርንካ ማቼ ሳብታ ባንችምና ቅንችሳንደትም ኮም ኤስከቴ’። ");
INSERT INTO gyl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","እታ የም ጋይድቴ፥ ሳብታ ፍርዳ ሰጨንካ ኮትኮ ካተመንዘንካ ስግስሶ ኤና ሰዶመትንዳ ፍርደና ቶክማ ማዴ እታ የም ጋይድቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ኮታዘንከረ የሱስ “ኩራዝኖ የኤ! በቴሳይዶ የኤ! የንካ ይይምሳን አተና፥ ጢሮሳርንኬ ሲዶናር ይምሶ Ꮊቀስ ናና ዋር ዶቅድ Ꮊቅባብ ኤድንከስ ሞርእታ አፍለን ቆበርስንደትከ ብንድዘን ዶቅሰኮ ኤና እር ጎማ ይንታ ፍክስን ከታ ዎይዘደክ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ኬዛርንካ ማቼ ሳብ ፍርዳ ሰጨናይካ የንዘንካ ስግስሶ ጢሮስካንተኬ ሲዶናካንታ ደጫዬ። ");
INSERT INTO gyl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","የነረ ቅፍራናሆሞ! ፈስ ጭላር ጬክ ጬክን ጋይሳ? ጩላ ጩልጩል ጎርናር Ꮊንቸርተራዬ”። ");
INSERT INTO gyl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","የሱስ ይንታካርንካ ጎርስምድባብከስም ይና “የም ኤሰርድባብ እም ኤሰርዴ፥ የም ሞግዳክባብ እመረ ሞካዬ፥ እመረ ሞግዳክባብ እም ኦይችባብመረ ሞካዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","የሱሰታ ካርንካ ጎርስምድባብ ማከን ቦንደከ ታመከ ቃስተንንከሰረ ይ ኦይትምሳንደታርንካ ጉርምካ ማትሰኮ፥ “ጮይስዮ፥ ግምዘንከስ ዎራ የስታ ላምካ ዎካንታ ክትምክዮ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","የሱሰረ “ሰጣን ዋልቅንትግንዳ ጭላርንካ Ꮊንቸርድንካ ሰድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ይና ጉንንኬ Ꮊንገርጭን የ ሙግድንግንዳ፥ የንታ ይምኤንባብታ ዎልቃ ሙደንዘን ገችታ ኤራ የካንታ እምትቴ፥ የም ኡፈልዝድንዳ ዋልቃ ሪየረ ዶቅተራክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ማታጋካ ዳት ቱና አያንንከስ የካንታ ክትምሳንጎካ ኮትኮካ Ꮊይጉርመቴ፥ ኬዛርንካ ማቼ የንታ ላምና ጭላር ጻፍምሳንካንታ የም ጉርምሳ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ኮትᎺይካ የሱስ ጭል አያንካ ጉርምሶ፥ “ጭለተከ ፍጨተካ ጮይስ እስታ ባቤኖ! ኮም ሙዳ ኤጨንባብከዘንከ ኤዝድባብከዘንካ አችሳዮ ይንችንከስካንታ መያ የስ ማስሳንኦል እታ የስም ጋለድቴ፥ ዬ፥ እስታ ባበኖ! ኮና የስታ ኡርማ ጋይተና ማቴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“ሙደንዘን ገችታ ኤራ እስታ ባበንዘንካ እካንታ እምምቴ፥ ጉጅሰረ ይንችና Ꮊይ ክት ማቼረ ሳብ ባቤንዘንካ አብ ኤዝድባብ ካዬ፥ ሳብ ባቤና ክት Ꮊይናነረ ክት ይንችንዘንካ አብ አነረ ኖ ይንችና መያ ማስካንታ ክት ጋይድባብዘንካ አብ ኤዝድባብ Ꮊየነረ ካዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","የሱስ ይንታ ካርንካ ጎርስምድባብከዝደር ዋልን ጋይሶ ከትካንታ Ꮊክ፥ “የ ሰድንደትም ሰድን አፍንከስ አንጅምስባበኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","እታ የም ጋይድቴ፥ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስኬ ባንችምንከስ የ ሰድንደትም ሰድንካንታ ዝግሰኮ ሰዳከኬ፥ የ ኤሰርድንደትመረ ኤስርካንታ ዝግሰኮ ኤሰራከኬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ይና ዋልቃሰጭ፥ ዋልቃ ሙሴታ ህግን ኤዝድባብ የሱሰም ጰጫካንታ አምሶ፥ “ኤስስንባቦ! ስለንክንደታ ዶቅንትንም ተይካንታ Ꮊርስ ይቴ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","የሱሰረ “ሙሴታ ህግ ማጻፍናር ጻፍምሳንዳ Ꮊራ? Ꮊሰስ ኮትም ናበብዳ?” ጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ኤችነረ ማስሶ፥ “የስታ ጮይስ ሳብም ቦድማ ቡዳርንካ፥ ቦድማ የስታ ሰንፔንካ፥ ቦድማ ዎልቀከ ቦድማ የስታ ገቅርንካ ሶልምካ፥ የስታ የለን የስታ ማታግንዳ ሶልምካ ጋይዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","የሱሰረ፥ “ገታ ጋይሰዬ፥ የነረ ኮትግንዳ ይካ! ስለንካ ዶቅንተን Ꮊፍተራዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ኖ ኤችነረ ይንታ ማተንም ጭል ማስካንታ ዝግሶ፥ “ይና እስታ የለንከስ Ꮊይራ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","የሱሰረ “ዋልቃ ኤች የሩሳሌም ካተመናርንካ ኢያርኮ ካተመናር Ꮊንቸርድዮ ፋንገንከሰታ አንያር የድምሴ፥ አፍለንመረ ክታ ዉችሶ ጉጵሰኬ፥ ደእካንታ ክት ይድንካ ዛቅሶ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ኤች ዋልቃ ቄሳ ይንታ ጋይሶ ጎግንኮትካ ጩላ Ꮊንቸርድዮ ኤችንም ሰድሶ Ꮊርን ጋይሶ ስገዴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ኮትኮግንደረ ዋልቃ ለዊ። ኮትኮ ካርንዘን የልሶ ኤችንም ሰድሶ Ꮊርን ጋይሶ ስገዴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ዋልቃ ሳማራ ካተማ ኤችና ማቼ ይንታ ጋይሶ ጎግንም ክት አይድንካ ኤችና ዶቅድንካርንዘን የልሴ። ክትም ይ ሰዳንግንዳ አጨርሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ክደር ቅንችሰረ ክታ ድድንዘን ዛይተከ ዎይን Ꮊቀንታ አፍዘንካ ጩጰርሳንደትም ዉልእሶ ዞክሴ። ይንታ ኡክልንዘን ዶቅስሶ ሶችንከስታ Ꮊዉስ ኤሄናር ተይ አይሶ ኮታረረ ክትም ጱልጬ። ");
INSERT INTO gyl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ዛማክንከረ ቃስተን ጣገራ ብራ ዉችትዮ ሶችንከስታ Ꮊዉስ ኤሄንባብካንታ እምሶ፥ ‘ኤችንኮም ዋደ ሰቅስካ፥ ኮዘንካ ስግ የስ ዉችሳንደትመረ እታ ማድቶ የስካንታ ናግድቴ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“ይና ከትኬና ማከንናርንካ ፋንገንከስታ አንናር ጉጰርስባብ ኤችንታ የላ ማችባብ Ꮊምና የስም ካምዳ?” ኩንጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ሙሴታ ህግንም ኤዝድባበረ “ክትካንታ አጨርስባብ ዳት” ጋይሴ። የሱሰረ “የነረ አይሳዮ ኮትኮግንዳ ይካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","የሱሰከ ክታ ካርንካ ጎርስምድባብከስ ጎግ ከት አይድንካ ዋልቃ ሞራር የልሴ፥ ማርታ ጋይምሳንዳ ዋልቃ ኤተነረ ይንታ ኤሪ ክትም ሞክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ኮተረ ማራም ጋይምድንዳ ምችነና ዶቅዴ። ማራመረ ቃለንም ኤሰረሮ የሱሰታ ዱትንታ ጎያር ዶቅሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ማርታ ማቼ ፍክስታ በድምዘንካ አምሳንዳ ታንታን ጋየሮ ክደር Ꮊድሶ፥ “እስታ ጮይስኖ! እስታ ምችነና ፍክስንም እዘንᎺክ ዛቅሶ ኮት ዶቅድንካ ጫምነስ ጋይዶ? እም አላ አልድንግንዳ ኮትም ኬዝካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ጮይስ የሱስ “ማርቶ! ማርቶ! የና በድ ርካንታ ማጠርዳዬ፥ አዉልዳዬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","የስም ዝግዝድንዳ ማቸ ዋልቃ እር Ꮊክዬ፥ ማራማ ማቼ ይም ኡርድንደትም ይንተን ና እቴ፥ ኮነረ ኮታዘንካ ተይምዳክዬ” ኩንጋየሮ ኮደር ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ዋልቃሰጭ የሱስ ዋልቃ ካርዘን ምግዝድ Ꮊቄ፥ ምክስን ክት በይሳንግንዳ የሱሰታ ካርንካ ጎርስምድባብከሳርንካ ዋልቀና፥ “ጮይስዮ! ዮሀንስ ይንታ ካርንካ ጎርስምድባብከስም ምክስን ከትም ኤስሳንግንዳ የነረ ምክስን ዎም ኤስስካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","የሱሰረ የታ ምግዝደቶ ኩን ጋይከቴ፥ ጭላር ዶቅድባብ ዎንታ ባቤኖ! የስታ ላምና ቦንችማ፥ የስታ ባንችምና Ꮊዳጋካ። ");
INSERT INTO gyl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ሰጨንታ እችምን ዎካንታ ሰጨንካ እምካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ዎተረ ዎም ባችስባብም ሙዳ ነጋ ዎ ጋይድንደትግንዳ፥ ዎንታ ባችንም ነጋ ዎካንታ ጋይካ፥ ዎም ጰጨናረረ Ꮊይ አርቼ፥ ዳቅልንዘንካ ዎም አቅስካ ዳት ኩንጋይሶ ምክስከቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ጉጅሰረ የንታ ዋርንካ ዋልቃ ገርና ዶቅድባብ ገልትገር ክደር አይሶ፥ “እስታ ገርነኖ፥ ማከን ሶላ እካንታ ሞልሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ዋልቃ ላኮይትና ጎግ Ꮊቅሶ እዝደር Ꮊድንካ እ እምድንዳ Ꮊረርየረ እዝደር ካዬ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ኤሄንታ ዋር ዶቅድባበረ “እም Ꮊይማእሴ፥ ፍልተና ዝጭምቴ፥ እስታ ይንችነረ እንካ የካ ራቴኬ፥ ኮዘንክ አምስቶ እምካንታ ማታይቴ” ጋይዶ? ");
INSERT INTO gyl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","የም ጋይድቴ ገርና ይንታ ማትንተንካ አምሶ ይ እማክንዳ ማቼረ ክታ ናጭንካንታ ጋይሶ ክት ዝግድንደትም ሙዳ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ኮካንታ የም ጋይድቴ፥ ምክስከቴ የካንታ እምምዴ፥ ዝከቴ Ꮊብደቴ፥ ፍልተንደር Ꮊድሰቶ ቆንከቴ የካንታ ፎችምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ꮊረታ ጋይሴ ምግዝድባብ ሙደና ተይዴ፥ ዝግድባብ Ꮊብዴ፥ ፍልተንደር Ꮊድሶ ቆንግድባብካንታ ፎችምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“የንታ ዎክያርንካ ባበና ማችባብ ክታ ይንችና ሞለም ምክሴ ጉን እምድባብ ዶቅዶ? ");
INSERT INTO gyl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","አነረ ሙቃ ምክሴ Ꮊንገርጭ እምዶ? ");
INSERT INTO gyl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","የታ ዳቅልንከስ ዶቅደቶ የንታ ይንችካንታ ኡርማ እምንተንም የ ኤሳንካ፥ ጭላር ዶቅድባብ የንታ ባበና ይና ምግዝድባብከስካንታ ጭል አያንንም Ꮊስግንዳ ስክስሶ እማዮ!” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ዋልቃᎺይካ የሱስ አፋ ከስዝዳክን ግምዘን ዉጅድንካ ግምዘነረ ኤችንዘንካ ዉተዳንደታ ቡር አፈን ከዛይንባብ ኤችና ኬዜ፥ ዎርሰነረ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ኬዛርንካ ማቼ ከታርንካ ዋልቃ ዋልቀንከስ “ግምዘን ከስም ዉችዝድባብ ግምዘንከስም ገችንባብ ብኤልዘቡልኬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ዋልቃ ዋልቀንከስና ጉጅሶ ጰጫካንታ ጭላርንካ ቃዉተም ከትካንታ ክት ሰችዝድንግንዳ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","የሱስ ማቼ ከታ ገቅርንም ኤስሶ “ክክ ክክ ፋስምድን ባንችምና ሙዳ ካይዴ፥ ኮትኮግንደረ ክክ ፋስምድን ኤሀ ኤድንከስ ዋጅደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ሰጣነረ ክክ ክክ ከት ፋስምድንዳ ማቼ ክታ ባንችምና Ꮊስግንዶክ ዳቅዳ? ክት ግምዘንም ዉችዝድንዳ ብኤልዘቡልኬ እም ጋይደቴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ይና እታ ግምዘንከስም እ ዉችዝድንዳ ብኤልዘቡልካ ማቸ፥ የንታ ካርንካ ጎርስምድባብከስ Ꮊይከክ ዉችተራ? ኮካንታ ከታ የንዘን ፋረደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","እታ ማቼ ግምዘንም ዉችዝድንዳ ሳብታ ዎልቀካ ማቼ፥ ሳብታ ባንችምና የንደር Ꮊዳንደትም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ዳቅማ ኤች ይም ዝግዝድንደትም ዳምካንታ ሶቀርሶ ይንታ ኤሄንም ካርሰ፥ ርና ክታ ኡርመካ ካርስምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ኬዛርንካ ማቼ ክታዘንካ ስግ ዳቅማ ማችባብ ኤች Ꮊድሶ ጉጵሶ ክትም ጋምሴ ክት አሜንምሶ Ꮊቃንደትም ሶቅርንም ቡልዝዴ፥ ክታ ዶቅድንደትም ተይሶ አብንከስካንታ ካዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“እንካ ክክን ማታክባብ እም ግርዴ፥ እንከረ ክክን ሳንዝዳክባብከሰረ ይጭዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ቱና አያን ኤድታዘንካ ዉተዳንደትካ Ꮊዉስ ዝግመት ሎቃ ካየንካርያር ኦንግዴ፥ Ꮊዉዝድን ካሪ ይ Ꮊፍክሳ ነገዴ፥ እ ዉተዳንደት ኤሄናር ማድቴ” ጋይዴ ");
INSERT INTO gyl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ክት ማድንከረ ኤሄና Ꮊጭምሶ ግግምሳንደትም ኖ Ꮊብዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ኮታ ቡር አይሶ አብንከስ ክታዘንካ እንድንካ ስግድባብ አብ ታብዛ ግምዘንከስም ተይ Ꮊዴ፥ አርድሰረ ኮታር ዶቅደኬ፥ ኮ ኤችንካንታ እርንደትዘንካ ስግሶ ቡርንደና ቦርሳንዳ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","የሱሰረ ኮም ኬዘዘን ክት ዶቅድንካ፥ ዎርሰናርንካ ዋልቃ ኤተን ኡፍስን ይንታ ጬክሳ ይይሶ “የስም አጥሶ ይንታ አምንም ጋእሳን እንደና አንጅምሳንዴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","የሱስ ማቼ፥ “አንጅምስባብከስ ሳብታ ቃለንም ኤሰርሶ ክትምድባብ ከሴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","በድ ዎርሳ ክደር ሳንምሳንደትካ የሱሰረ “ኮና አጥርና ዳቅልዬ፥ ቃዉታ ሰድካንታ ዝግደኬ፥ ኬዛርንካ ማቼ ዮናሰታ ቃዉተዘንካ አብ እምምዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ꮊራካንታ ጋይሴ ዮናስ ነነዌ ኤድንከስካንታ ቃዉታ ማቻንግንዳ ኤድ ይንች ኮ አጥርንካንታ ቃዉታ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ሶስጎክንባብከስታ ኤተን ባንችና ኮ አጥርንታዘን አምሶ ሳብ ፋረድንᎺይካ ናየረ ፋረዴ። ና ሰሎሞንታ ኤጨንም ኤስርካንታ ፍጨታ ካንታርንካ Ꮊቴ፥ ይና ሰሎሞንዘንካ ስግድባብ ካሪ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ሳብታ ፍርደናይካ ነነዌ ኤድንከስ ኮ አጥርንከስካ ክክን አምሰኮ ክታዘን ፋረደኬ፥ ከተረ ዮናሰታ ሳባክን ኤሰርሰኮ ጎማ ይንታ ፍክስን ዎይስተኬ፥ ይና ዮናሰዘንካ ስገድባብ ካሪ ዶቅዴ”፥ ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ዞጰንም ዞጵስትዮ ስፍስት አቻ ካርያር ዎድባብ Ꮊየነረ ካዬ፥ ስክስሶ አርድባብ ኤድንከስ ሳክመንም ሰድንግንዳ ዞጰን ዎደርድን ካርንዘን ዎዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“የስታ ዘነታ ሳክመና የስታ አፍኔ፥ የስታ አፍና ኡርማ ማቼ ሙዳ የስታ ዘነና ሳክመካ ጮጫንዳ ማዴ፥ አፍና የስታ ሰቀርድንዳ ማቼ የስታ ዘና ሙደና ኡም ማዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ኮካንታ የሳር ዶቅድን ሳክመና ኡም ማዳክንግንዳ ካርስምካ። ");
INSERT INTO gyl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ይና የስታ ዘና ሙደና ሳክማ ማቼከ ኡምሳንዳ የስታ ዘነንታዋር ካያ ማቼ የስታ ኤደትቸንታ ዞጰና የስካንታ ዋልጭን ጋይሳን ሮጵድንዳ ሳክማ ማዴ”። ");
INSERT INTO gyl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","የሱስ ኬዘንም በይሳንግንዳ ዋልቃ ፈረሳው ኤች ክትካ ክክን እችም እጅድንግንዳ ኤልሴ፥ ኖየረ ክትካ ክክን አርድሶ እችምካንታ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ፈረሳው ኤችነረ የሱስ እችምን ይ እችተርንደታ እር ከታ ዎገንግንዳ አንንም ስኤራክንደትም ሰጃንደትካ በርእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ጮይስ የሱሰረ “ይና የታ ፈረሳውያንንከስ ኡፍተንተኬ ጋበትንታ ቡርጎክንደትም ስእደተ፥ የንታ ዋርጎክንዳ ማቼ ቡረኬ ዳቀልስካ ጮጫንዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","የታ ዳቸንከሶ ቡርጎካ ዘነንም ፍዝባብ ዋርጎክንደትም ፍዛክዮ? ");
INSERT INTO gyl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ኬዛርንካ ማቼ ኡፍተንተከ ጋበትንታ ዋር ዶቅድንደትም ሪካየንባብከስካንታ እምከቴ፥ ኮታ ቡር ሙደና የካንታ ጭልምሳንዳ ማተሬ”። ");
INSERT INTO gyl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“የታ ፈረሳውያንንከሶ የም የኤ! ሳዉሰታ ኤልከ ጫልትካ፥ ኮት ኮግንደረ ኮራ ኮርሶ እቸርድን ሙደናርንካ ታመናርንካ ዋልቀን ዉችዝደቴ፥ ማችንከረ ዶፈን ፍርደንምከ ሳብም ሶልመንም በህ የታ ጋይደቴ ኬዛርንካ ማቼ ኮትም ዛቃክዶቆ ኮመረ ይ የም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“የታ ፈረሳውያንንከሶ የም የኤ! አይሁድንታ ምክስ ኤሄናር ቦንችምሳን ጎንገን፥ ጋባረረ ቦንቸታ ሳራትችን ዝግደቴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“ኤድንከስ ኤሳክዶቆ ኮታ ዘንካ አይድንደትም አችምሳን ዱክም የ ካምድንካንታ የም የኤ!” ");
INSERT INTO gyl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ሙሴታ ህግንም ኤዝድባብከሳርንካ ዋልቀና ማስትዮ “ኤስንባቦ! ኩን የስታ ኬዘንካ ዎም የክሳዬ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","የሱሰረ “የታ ህግንም ኤዝድባብከሶ ጉጅሶ የም የኤ! ኤድንከስም ደጭድንደትም አንድር ባለን ባልዝደቴ፥ የታ የንታ ማታርንካ ማቸ የንታ ግልኤንካ ዎራ ዎላየቴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“የንታ ባበንከስ ደይስባብከስታ፥ ሳብዘንካ ኤስርሶ ከዛቅንባብከስታ ዱክንም የ ኡርዝድንኦል የም የኤ! ");
INSERT INTO gyl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ይና የንታ አክስንከስተከ ባበንከስታ ፍክስንም ዳቅስካ የታ ማርከቴ፥ ከታ ሳብዘንካ ኤሰርሶ ኬዝድባብከስም ደይሰኬ፥ የተረ ከታ ዱክንም ኡርዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ኮካንተረ ሳብታ ኤጨና ኩን ጋይዴ፥ ሳብዘንካ ኤስርሶ ኬዝድባብከስከ ኦይትምስባብከስም የካንት ኦይድቴ፥ ከተረ ዋልቃ ዋልቀንም ደይዝደኬ፥ አብንከስመረ ዳይደኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ኮካንታ ፍጫ ሙደና ፍዝምሳንደትዘንካ የድሶ ሳብዘንካ ኤስርሶ ኬዛቅባብከስታ ዉልእምሳን ማቀስን ሙደንታ ኮና አጥርና ኦይስምደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","አበለታ ማቀስንዘንካ የድሶ ዘካርያስ የለልታ ካስን ካርዘንከ ሳብታ ጭል ኤሄንታ ዎክናር ዉልእምሳን ማቀስንጎካ ኮና አጥርና ኦይስምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“የታ ሙሴታ ህግንም ኤዝድባብከስ የም የኤ! ኤሄንታ ፍልተንም ፎጅድን ዶፈን ፎችንደትም የተቴ፥ የታ የንታ ማታ አርዳከቴ፥ አርድካንታ ዝግድባብከስም አርዳክንግንዳ ማርተቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","የሱስ ኮታርንካ አይካንታ ክት አምድንካ ሙሴታ ህግንታ ኤስንባብከስኬ ፈረሳውያንንከስ ክትም ግረረኮ በድ ኦይስ የጀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ኮመረ ከት ይሳንዳ ክታ አፋርንካ ዉድን ኬዘንካ የድካንታ ዝግሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ኮትᎺይካ በድ ሳኤካ ፋይድምድን ኤድንከስ ክክ ክክ Ꮊንቀረኮ ክክ ሙክምተርን የለልታ ሳንሶ ከትዶቅድንካ፥ የሱስ ይንታ ካርንካ ጎርስምድባብከስካንታ ኩን ጋይ የጄ፥ ፈረሳዊያንንከስታ ዳቅል ገቅርንዘንካ ካርስምከቴ፥ ኮነረ ከታ ኦትረኔ። ");
INSERT INTO gyl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","መያ ማዳክንዳ ክጭምሳንዳ፥ ኤስምዳክንዳ አጥምሳንዳ Ꮊረሰነረ ር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ኮካንታ ኡማር የ ኬዛንዳ ሙዳ ሳክመናር ኤስምዴ፥ ዝጭምሳን ኤሄናር ቃምያር የ ዎክስምካ ከዛንደረ ጬክን ጋይሳን ካርዘን ከዝምተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","እስታ ገርነንከሶ የም ጋይድቴ፥ ዋሄንም ደይሰዘንካ አብ Ꮊረሰነረ ይካንታ ማዳክባብከስካንታ Ꮊይጳሰቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ኬዛርንካ ማቼ ጳስ የም ዝግዝድንደትም ኬዝድቴ፥ ይ ደይሳንደታ ቡር ድግዳክን ኖሄናር ኦይትካንታ ገችታ ኤራ ዶቅድባብ ሳብም ጳስከቴ፥ ይዬ ክትም ጳስከቴ የም ጋይድቴ! ");
INSERT INTO gyl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ዶንቅ አፍት ስልንከስ ቃስተን ባኬና ካንታ ሰንምደክ ካዮ? ማታጋካ ዳት ከታርንካ ዋልቀን ዎራ ሳብ ባቀራዬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","የንታ ማተንታ ባቅለነረ ሙዳ ዎራ ፋይድምሳንዴ፥ ይና በድ አፍት ስልን ኬዘንካ ስገዳንዳ ናክ የንታ ዶቅድንካንታ Ꮊይጳሰቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ኮታዘንከረ የሱስ የም ጋይድቴ ጋይሴ፥ “ኤታ እር ኦስና ካይሳ እካንታ ማርከርድባብካንታ ሙዳ እተረ ጉጅሶ ኤድ ይንች ሳብታ ክታይንችከስታ እር ክትካንታ ማርከርትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ኤታ እር እም ካድባብም እታ ሳብታ ክታ ይንችንታ እር ክትም ካድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“ኤደት ይንችታዘን ቶቻ ኬዛ ኬዝድባብ ሙደንታ ላላ ጋይምተሬ አያንይ ጭልንም የግድባብም ማቼ ክታ ባችና ላላ ጋይምተራክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“ኤድንከስ የም ተይሰኮ አይሁድንከስታ ምክስ ኤሄናር ገችንባብከዝደርከ ኤረንባብከዝደር የልዝድንᎺይካ ‘Ꮊስግንዳ አነረ Ꮊራ የ ማዝደናከረ’ Ꮊይማጠረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ኮት ሳዓትንካ አያንይ ጭልና ኬዛካንታ የም ዝግዝድንደትም ኤስስተሬ”። ");
INSERT INTO gyl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ዎርሰንታ ዎክያርንካ ዋልቃ ኤችና የሱሰም፥ “ኤስንባቦ! ዎንታ ባቤና ኬክሳንደትም ባእንም እካንታ ክት ካዝድንግንዳ እስታ እስመንንካንታ ኬዝካ” ጋይሴ ");
INSERT INTO gyl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","የሱሰረ “የና እስታ ገርነኖ፥ የንታዘን ፋረድባብከ አና የንታ ባእንም ካሳባብ እም ዶርስባብ Ꮊይራ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ጉጅሰረ “ኤታ ሰንፔና ቆልመታ በድምካ ማዳክንካንታ የታ ካርስምከቴ፥ ኡዝምዘንከረ ሙዳ የንታ ማተንም ካርስከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ኮታዘንከረ የሱስ ኩን ጋይሶ ካምስካ ከትም ኬዜ፥ ዋልቃ ቆልመክንባብ ኤችታ ዎን Ꮊምናር አንድር አፍ ኡሳንዳ እስን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ኖ ኤችነረ ኡሳንደትም እ ሳንዝድንደታ ካሪ ካየንካንታ Ꮊስስ ይቴ? ጋይሶ ይንታ ቡዳር ገቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ኩነረ ጋይሴ ኩን ይድቴ፥ እስታ ዶቅድንደትም ቡለንከስም ዉልእስቶ አብ ሳክም ቡላ ኡርስትቴ፥ ኮታር ኡሳን እስንንምከ እስታ ርን ሙዳ ሳንዝድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ኮታ ቡር እስታ ሰንፔንመረ፥ እስታ ሰንፔኖ! በድ ስላካንታ ማድንደትም ቆልማ የስካንታ ሳንስትቴ፥ ይና Ꮊዉስካ፥ እችካ፥ ዎጭካ፥ የስም ጉርምሳ ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ሳብ ማቼ የና ዳቼኖ! የስታ ሰንፔና ኮ ሶይትናር ተይምተሬ፥ ይና የስታ ማታካንታ የስ ሳንሳንዳ Ꮊይካንቶክ ማዳ? ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“ይንታ ማታ ካንታ ፍጨዘን ቆልመም ሳንዝድባብ ሳብታ እሪ ሪካይሳ ማችባብ ኤድ ኮግንዳ ማዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ኮተረ ቡር የሱስ ይንታ ካርንካ ጎርስምድባብ ከስካንታ ኩን ጋይሴ፥ “የንታ ሰንፔንካንታ Ꮊሮንት እችተራ፥ ዎንታ ዘነንዘን Ꮊሮንት ቆበርተራ ጋይንተካ የንታ ዶቅንተንካንታ Ꮊይማጥረቴ”፥ ");
INSERT INTO gyl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","እችምዘንካ የንታ ሰንፔና አፍለዘንከረ የንታ ዘነና ስገዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ቁረንከስም ሰድከቴ! ከታ ማሳየከ፥ ስካየኬ፥ አነረ ሳንዝድንዳ ቡለረ ከታ ካዬ፥ ማታጋካ ዳት ሳብ ከትም እችዝዴ። የተረ አፍትንከዘንካ አከካ ስግደት ካዮ? ");
INSERT INTO gyl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ይና የንታ ዎክያርንካ ማጥርካ ይንታ ስለንዘን ዋልቃ ሰጫ ጉጅድባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ይና ቶክማ ርነሬ ዎራ የንደር ይማይንዳ ማቼ፥ አብ ሪይንካንታ Ꮊረተንት ማጠርዳ? ");
INSERT INTO gyl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ይና ቦነንከስ Ꮊስግንዳ ጋጵዳናከረ ሰድከቴ፥ ከታ ፍክስካ ጋብዳከኬ፥ ፉታ ግእዳከኬ፥ ኬዛርንካ ማቼ የም ጋይድቴ ባንችን ሰሎሞን ዎራ ይንታ ቦንቻ ሙደንካ ከት ከናርንካ ዋልቀንግንደረ ቆበራክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ይና ሳብ ታካ Ꮊፈርሶ ሰናካ ኖሄታር ኦይትምድን ቦንገንታ ድረንም ኮግንዳ ሰክስሶ ቆብዝድንዳ ማቼ፥ የታ አሜን ዞገርስባብከሶ፥ የም Ꮊስግንዳ ስግስሶ ቆፍሳይንዳ! ");
INSERT INTO gyl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ኮካንታ Ꮊሮንት እችተራ! Ꮊሮንት ዎጭተራ! ጋየረቶ ገቅርካ Ꮊይማጠረቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ኮትኮም Ꮊፍካንታ ሳብም ኤዝዳክን ኤድንከስ ማጠርደኬ፥ የም ማቼ ኮና ሙዳ የካንታ ዝግዝድንደትም ጭላር የንታ ባቤና ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ስግስሶ ሳብታ ባንችምና Ꮊክ የም ገቀርሳ፥ ኬና ሪና ሙዳ የካንታ ጉጅምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“የታ መራ ዉደንግንዳ ማችባብ እስታ ገርነንከሶ Ꮊይጳሰቴ፥ ጭላር የንታ ባበና ባንችምን እምካንታ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","የንታ ዶቅድንደትም ሙዳ ሰንሰቶ ብረንም ሪካየንባብከስካንታ እምከቴ፥ ድቢይ ተይዳክንደታር፥ ብል እጅዳክንደታር፥ ገሰርዳክን ቦርሰናርከ ቦድሶ በእዳክንደታር ጭላር ሳንስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","የንታ ብረና ዶቅድን ካርናር የንታ ቡደነረ ኮታር ማተሬ”። ");
INSERT INTO gyl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ኮታዘንከረ የሱስ “ሙዳ ርይካ ግግምሶ ሶቀርሰቶ ሙዳᎺይካ ፍክስካንታ ግግምከቴ፥ የንታ ዞጰና ዞጵሳንዳ ማታ። ");
INSERT INTO gyl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ከታ ማተን ቆልስባብ እሰናርንካ ማትንተን ካርዝድባብከስግንደከ Ꮊድሰረ ፍልተን ክት ቆንግድንካ ሳነካ ፎችካንታ ግግምስባብ ፍክስንባብከስም ካምከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ከታ ማተን ቆልስባብና ᎺድንᎺይካ ንግሰኮ ከትዶቅድንካ ክት Ꮊብድን ፍክስንባብከስ ጭለኬ፥ ኖየረ ግግምሶ ከትም ዶቅስሶ እችዝዴ፥ ከትመረ ሞግዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ከታ ማተን ቆልስባብ ገልትገረናነረ አና ሰጭመረ ክት Ꮊድንካ ንግስንደትከ ዳቅሶ ከት ክትም ካርዝድንካ ክት Ꮊብድን ፍክስንባከስ አንጅምስባበኬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ኮም ማቸ ኤስከቴ፥ ድብና Ꮊራ ሳዓታዘን Ꮊዳናከረ ኤሄንታባበና ይ ኤዝደስናና ኤሄና ኮይምድንካ ጫምን ጋይዳክዶቆ። ");
INSERT INTO gyl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","የተረ ግግምሰቶ ካርስከቴ፥ ኤድ ይንች የ ገቀራክን ሳዓታዘን Ꮊዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ጴጥሮሰረ “ጮይስዮ! ኮም ካምስንከስም የስ ኬዝድንዳ ዎካንታ Ꮊክዮ አነረ ሙደንካንቶ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ጮይስ የሱሰረ ይና እችምንም ከትካንታ ዝግድንደትካ ከትም እምድንግንዳ ከታ ማታ ቆልስባብ ይንታ ኤር ኤድንከዘን ክት ዶርድባብ አሜንምስባብከ አጋ ማትሶ ከትም እችዝድባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ክታ ማተን ቆልስባብ ማድንካ ይ ክትምሳንግንዳ ፍክሰሮ ዶቅድንካ ክት Ꮊብድባብ ኖ አንጅምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ዶፈን የም ጋይድቴ ዶቅድን ር ሙደንዘን ክትም ዶርዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ኬዛር ማቼ ኮና ፍክስንባብ እስታ ባቤና ሳና Ꮊዳየ ጋምእዴ፥ ጋይሶ ገቅርካ አⷝነንከ ማነን ፍክስንባብከስም ክት ጉጰዴ፥ ጉጅሰረ ይም ዝክሳንግንዳ እቸሮ ዎጨሮ ጎዝ ክት የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ክትኮ ፍክስንባብታ ማተን ቆልስባብ ክት ገቀራክን ሰጨከ ክት ግግማክን ሳዓትንዘን ክደር Ꮊዴ። ኮካንታ ክትም ቃርጫ ቃርጫ ይይሶ፥ ክታ ኡዋንን አሜንዳክባብከስካ ክክን ማስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ይንታ ማተን ቆልስባብታ ጋይተንም ኤስሶ ግግምዳክባብከ ክታ ክተንም ይዳክን ፍክስንባብ ኖ አንድር ጉጰርዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ኬዛርንካ ማቼ ኖ ፍክስንባብና ኮም ኤሳክዶቆ ይም ጉጵዝድንከካ ይስባብ ቶክመካ ጉጵምዴ። በድካ እምምስባብ ኤድ ሙደንዘንካ በድካ ዝግምዴ፥ በድ ዋደንም ተይባብዘንካ በድ ክታዘንካ ካርስምዴ፥ ኩንጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“እ Ꮊዳንዳ ፍጨዘን ኖሀ የችይ ካንቴ፥ ታ ኩን የደስናና Ꮊስግንድስ ጉርምቴ! ");
INSERT INTO gyl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ኬዛርንካ ማቼ እ ስኤርድንዳ ማጠታ ስእር ዶቅዴ፥ ኮት ቦድምተርን የለልታ Ꮊዉስ እስታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ፍጨዘን ኡርመንም እ ተይᎺዳንዳ የንደር ካምዶ? የም ጋይድቴ ኩን ካዬ፥ እ Ꮊዳንዳ ፋስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ታ ኮዘንካ የድሶ ክክ ክክ ፋስምድባብ ዋልቃ አጥርያር ዶንቅ ኤድ ዶቅደኬ፥ ማከና ቃስተንዘን ቃስተንነረ ማከንንዘን አምሶ ፋስምደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","“ባበና ይንታ ይንችንዘን ይንችነረ ይንታ ባበንዘን፥ እንደና ይንታ ይንቸንንዘን ይንቸነረ እንደንዘን፥ ይንችንታ እንደና ይንታ ይንችንታ ከነንዘን ይንችንታ ኬነና ይንችንታ እንደንዘን አምሶ ፋስምደኬ”። ");
INSERT INTO gyl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ጉጅሰረ ዎርሰንካንታ፥ “ኡፐና Ꮊይንታ አርድንታጎካ ዉድንካ ሰደቶ ሳና ዶብ Ꮊድካንታ ይዴ የታ ጋይደቴ፥ ኮትኮግንደረ ማዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ሶስጎካ ዞገነረ ዞግድንካ፥ ሰጨና ኦይጥማ ማዴ ጋይደቴ፥ ኮትኮግንደረ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","የታ ኦትረንባብከሶ ፍጨንተከ ጭለንታ ካምንተንም ገቅር ኤዝደትካዮ፥ ይና ታ ሰጨን ኮም ገቅር የም ጋምሶ?” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ኮዘንከረ የሱስ፥ ይና የታ ዶፈን ማቻን ር Ꮊረተረ የ ፋረዳይንዳ? ");
INSERT INTO gyl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","የስታ ይምኤንባብካ ክክን ዳይነንታ እሪ አይደዮ፥ አክ ጎግዘን የስ ዶቅድንካ ኤድምካንታ ጉርካ፥ ኩን ማታክንዳ ማቼ ጎችሶ የስም ዳይነንደር ተይ አይዴ። በርምስን ባበረ ፖልስንካንታ ስክስትዮ የስም እምዴ፥ ዞክስንባበረ ዞክና ኤሄናር የስም ኦይዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","የስም ጋይድቴ፥ የዘን ጋየርሳን በእንታ ብረንም የስ ናክተርን የለልታ ዋርንካ ዉዳካዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ኮትᎺይካ Ꮊድሶ፥ ጵላጦስ ኬታ ማቀስንም ካሲንካ ክክን ቡቅሳንካንታ ገሊላ ኤድንከስጎካ Ꮊድሰኮ የሱሰደር ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ኖየረ “ይና ኬና ገሊላ ኤድንከስም ኮና ማጠና የልሳንዳ ገሊላ ኤድን አብንከዘንካ ሙዳ ስግ ጎመንባብከስ ከት ማቻን ካንታ የንደር ካምዶ? ");
INSERT INTO gyl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“ኩን ካዬ፥ ጎማ ፍክስን የንታ የ ዎይሳክንዳ ማቼ የታ ሙደና ከትግንዳ ካይደቴ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","አነረ ሰልሆማር ሰይን ኤሄና ዎርግምስንካ ደእስባብከስ ታመከ ልማካይ ኤድ የሩሳሌም ካተመናር ዶቅድባብ ኤድ ሙደንዘንካ ስግሶ ባችባብ ከት ማቻን የንደር ካምዶ? ");
INSERT INTO gyl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ኩን ካዬ! ጎማ ፍክስን የ ዎይሳክንዳ ማቼ የታ ሙደና ከትግንዳ ካይደቴ የም ጋይድቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ጉጅሰረ “ዋልቃ ኤችታ ዎይን Ꮊቀን ኮረርሳን Ꮊምናር ዋልቃ Ꮊቃ ባለስ ኮርምሶ Ꮊቄ። ኖየረ አፍ ዝግሶ ክት Ꮊድንካ Ꮊረሰነረ Ꮊፋክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ዎይን Ꮊቀንታ Ꮊምናር ፍግዝድባብም፥ ይና አፍ Ꮊፍካንታ ዝግሶ ማከን ስላ ኦግዝቴ፥ ማችንከረ Ꮊረነረ ኮታርንካ አፍ Ꮊፋክቴ ታ ማቼ ፓካ እስታ ፍጨንም Ꮊረቶክ ባጅዳ ጋይሴ፥ ኩንጋየሮ ኮም ካምስካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“ኖ ኤችን ፍክስንባብ ማቼ፥ እስታ ማታቆልስባቦ! ኮታ ካንተንካ ቦክሰርቶ ዝክ እ ኦይተርን የለልታ ታ ስለን ኮም Ꮊክ ኮትም ዛእካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ኦስ እሪ ኮት ኡሴ ኡርሜ፥ ኡሳክንዳ ማቼ ኮትም ፋክተረዬ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","የሱስ አይሁድንታ Ꮊዉስ ሰጨንካ ዋልቃ ከታ ምክስ ኤሄንከሳርንካ ዋልቀናር ኤስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ኮታረረ ቱና አያንና ታሜከ ላመካይ ስላ ሙዳ ዎብ ኮትም ማስሳንዳ ዋልቃ ኤተን Ꮊቄ፥ ናየረ ይንታ ባዝደን ኩዘንዘንካ አምሳንዳ ቦድሶ ጬክን ጋይዳክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","የሱስ ኮትም ይ ሰዳንደትካ ኮትም ኤልሶ “የና ኤተኖ! የስታ ሰቅምናርንካ ፋጭተዬ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ይንታ አንንም ኮታዘን ዎጄ፥ ናየረ ሳነካ ጋዝድን ጋይሶ ዎእሴ። ሳብመረ ና ጋለቼ። ");
INSERT INTO gyl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","አይሁድንከስታ ምክስ ኤሄንታ ገችንባብ ማቼ የሱስ ከታ Ꮊዉስ ሰጨንካ፥ ፋችሳንካንታ ዋጭሶ ዎርሰንም “ፍክስካንታ ዝግዝድንዳ ላ ሰጨንከስ ዶቅደኬ፥ ኮካንታ ከትኬና ሰጨንካ Ꮊደረቶ ፋጭከት ዳት አይሁድንታ Ꮊዉስ ሰጨንካ Ꮊይማታ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ጮይስ የሱስ ማስሶ፥ “የታ ኦትረንባብከሶ፥ የንታ ዎክያርንካ ዋልቃ ኤችታ ገዝምን ካላርንካ አነረ ክታ ኡክልን ገቻንዘንካ አይሁድንከስታ Ꮊዉስ ሰጨንካ ቡልትዮ ሎቃ ዎእስካንታ ተይ አይዳ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ይና ኮና ኤተና አብራሀመታ ሱሳ ማቻንዳ ታሜከ ላማካይ ስላ ሙዳ ሰጣንካ ዞከርሶ ዶቅድንካ፥ ኮ ዞክነናርንካ አይሁድንታ Ꮊዉስ ሰጨንካ ቡልም ኮትም ዝክሳዮ?” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ኮም ክት ኬዛንደትካ ክትም ግርድባብከስ ሙደና ኦስንሰከ፥ ዎርሰንከስ ማቼ ክት ይሳን አታ ፍክስ ሙደንካ ከታ ጉርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ኮታዘንከረ የሱስ “ሳብታ ባንችምና Ꮊረሞክ ካምዳ? አነረ Ꮊረክስ የክስተ? ");
INSERT INTO gyl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ዋልቃ ኤች ይንታ ዎንᎺምናር ሰናፍጭ ጋየርድንደትም ማሰርሳን አፍ ቶክምንም ና ካምዴ፥ ና ጋጵሶ Ꮊቃ ማቼ፥ አፍትንከሰረ ኮታ እክመንከዘን ኤሄንም ዎጀኬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ጉጅሰረ “ሳብታ ባንችምን Ꮊረክስ የክስስተ? ");
INSERT INTO gyl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ሳብታ ባንችምና ዋልቃ ኤተን ማጠና ሙዳ ኡዝድንግንዳ ጋበትካ ማከን ማቻን እለናር ኦይተርሳን ኡስዝድን እርስንም ካምዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ኮታ ቡር የሱስ ኦስ የሩሳሌማር አይድዮ ካተመንከሳርኬ ሞረንከሳር ኤድን ኤሰሮ ስጋᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ኮትᎺይካ ዋልቃ ኤች “ጮይስዮ! ፋጭድባብከስ ቶክም ኤድ Ꮊክ ዳቶ?” ጋየሮ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","የሱሰረ “ጩንጭማ ፍልተንካ አርድካንታ ጉርከቴ፥ ኮትኮ ፍልተንካ አርድካንታ ዝግድባብ በድንከሴ፥ ኬዛርንካ ማቼ ከደር አርድማዬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ኤሄንባበረ አምሶ ፍልተንም ዝጭተሬ፥ የተረ ፍልተንም ቆንከረቶ ‘ማታቆልስባቦ! ዋደ ዎካንታ ፎችካ’ ጋይተረቴ። “ኖ የተረ የ Ꮊምንካ Ꮊዳናንከረ ኤዝዳክቴ ጋይሶ የካንታ ማስተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“ኮትᎺይካ የታ ‘የስካ ክክን የካ እችቶቴ፥ የካ ዎጭቶቴ፥ ዎንታ መለንዘነረ ኤስስተዬ’ ክደር ጋይተረቴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“ኖየረ አነታ፥ ‘Ꮊብርንካ የ Ꮊዳናንከረ ኤዝዳክቴ፥ የታ ባችንባብከስ ሙደና እዘንካ ጎተርከቴ!’ የም ጋይተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","አብራሀመም፥ ይሳቀም ያይቆብም፥ ሳብዘንካ ኤሰርሶ ከዛቅባብከስመረ ሙዳ ሳብታ ባንችምናር ከትም ሰተረቴ፥ የታ ማቼ ማልጎካ ዛቅምሰቶ የ ነግድንደትᎺይካ ኤፍከ አች ቅርጭካ የም የልተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","በድ ኤድንከስ Ꮊይታ ዉትንታጎከ Ꮊይታ አርድንታጎካ፥ ፈስጎከ ሶስ ጎካ Ꮊተረከ፥ ሳብታ ባንችምናረረ እችምዘን ዶቅተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ኮካንታ ቡርንባብከስ እር፥ እርንባብከስ ቡርንባብ ማተረከ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ኮትᎺይካ ዋልቃ ዋልቃ ፈረሳውያንንከስ ፈንክ የሱሰደር Ꮊድሰኮ፥ “ሄሮድስ የስም ደይሳካንታ ዝግድንኦል ካርን ካርንካ ዉትሰዮ አይካ” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","የሱስ ማቼ ከትም “አይሰቶ ኮ ደበንን ካንታ፥ ይና ታከከ ሰናከካ ግምዘንም ዉችዝድቴ፥ ሰቀርስባብከስም ፋችዝድቴ፥ ማክምስን ሰጨንከረ እስታ ፍክስን በይዝድተ ጋይዴ ክደር ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ማታጋካ ዳት ታከከ ሰናከካ ሰናካ Ꮊቄ ኦክስ የሩሳሌም ካተመናር አይ እም ዝግዝዴ፥ ሳብዘንካ ኤሰርሶ ኬዝድባብ የሩሳሌም ካተመንታ ላማር ዳት አብ ካርዘን ደእ ዝግሳዬ። ");
INSERT INTO gyl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“የሩሳለሞ፥ የሩሳሌሞ፥ የና ሳብዘንካ ኤሰርሶ ኬዝድባብከስም ደይዝድንዶ፥ ኦስ የዝደር ኦይትምስን ክተርስባብከስም ሰይንካ አቅድንዶ! ባቼና ይንታ ይንችንም ይንታ ካፍንታ ጎይናር ሳንዝድንግንዳ፥ እተረ መምᎺይክስ የስታ ይንችንከስም ሳንስካንታ ዝግዛረ፥ የስኬ የስታ ዎርሰንካ ማቼ ዋይ ጋይሰቴ። ");
INSERT INTO gyl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ኮካንታ የንታ ሳብንታ ጭል ኤሄና ኦና ማትሶ ነገተሬ። ዶፈን የም ጋይድቴ፥ ጮይስታ ላምካ Ꮊድባብና አንጅምስባቤ የ ጋይተርን ሰጫ የለልታ ኮዘንካ እም ሰተራከቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","አይሁድንታ Ꮊዉስ ሰጨንካ የሱስ እችም እችካንታ ፈረሳውያን ኤድንም ክድባብከስታርንካ ዋልቃ ኤችንታ ኤር አርደዳንደትᎺይካ፥ ኤድንከስ የሱስ ይድንደትም ሰድንካንታ ካርዝድᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ዋረረ ዘና ፍችካ ማጠርድባብ ዋልቃ ኤች የሱሰታ እሪ መያ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","የሱሰረ ህግን ኤዝድባብከስምኬ ፈረሳውያን ኤድንም፥ “አይሁድንታ Ꮊዉስ ሰጨንካ ህግንግንዳ ሰቀርስባብከስም ፋች ዝግዝዶ አና ዝግሳዮ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ከታ ማቼ ጫም ጋይሰኬ። የሱሰረ ሰቀርስባብ ኤችንም የድሶ ይ ፋችሳንግንዳ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ጉጅሰረ፥ “የንታርንካ ዋልቀና ክታ ይንች አነረ ክታ ገዝም አይሁድንታ Ꮊዉስ ሰጨንካ ጎርያር አርደዳንማቸ ሳነካ ዉቻይባብ Ꮊይራ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ከተረ ኮታ ማስንም ማሳከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","የሱስ እችምንካንታ ኤልምስባብከስ ቦንቻ ካሪ ከት እድንካ ሰድሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ዋልቃ ኤች የስም እሳር ኤልሴ፥ ቦንችምሳንካርዘን Ꮊይ ዶቄ፥ Ꮊረንግርካ ቦንቸካ የዘንካ ስገድባብ ኤልምታ ማተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ይና የ ቃስተንንም ኤልስባብ Ꮊድሶ ካርንም ኮ ኤችንካንታ ዛእካ የስም ጋይዴ፥ የነረ ኦስነራዮ ይርክን ጋይሳን ካርዘን ዶቅተራዬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ኬዛርንካ ማቸ የስ ኤልምሳንᎺይካ ይርክን ጋይሳንካርን ሰድሶ ዶእካ፥ የስም ኤልስባብ Ꮊድሶ እስታ ገርነኖ ጨዳ ጬክን ጋይሶ ዶእካ ጋይተሬ፥ የነረ ኮትᎺይካ የስካ ክክን እችምዘን ዶቅስባብከስታ ሙደንታ እር ቦንችምዳዬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ꮊረታ ጋይሴ ይንታ ማተንም ጬክ ጬክሳ ይድባብ ሙደና ይርክን ጋይዴ፥ ይንታ ማተንም ይርክ ይርክሳ ይድባብ ሙደና ጬክን ጋይዴ” ኩንጋየሮ ኮም ካምስንከስም ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","የሱሰረ ጉጅሶ ይም ኤልስባብ ኤችንም፥ “Ꮊየካ ናንከረ አነረ ሶይት እችምካንታ የስ ኤልድንደት Ꮊይካ ይምኤርካ የስ ኤላይንግንደከ ካርያረረ የስካንታ ማሳይንግንዳ የስታ ገርነንከስም አነረ የስታ እስመንከስም አነረ የስታ ሱሰንከስም አነረ ቆልመንክንባብ የስታ የለንም Ꮊይ ኤሌ። ");
INSERT INTO gyl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ኬዛርንካ ማቼ እችም የስ ግግዝድንᎺይካ ር ካየንባብከስም ዎብዝባብከስምከ አፍይ ዝልንከስም ኤልካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ኮም የስ ይሴ አንጅምተራዬ። ከታኬና ከስ ካርያር ከት ማሳይንካንታ ሳብ ጭልንከስ ደእናርንካ አምንተንᎺይካ የስታ ናክንም የስካንታ ናክተሬ” ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","የሱሰካ ክክን እችምንዘን ዶቅስባብከስታ ዎክያርንካ ዋልቀና ኮም ኤሰርሶ “ሳብታ ባንችምናር እችምንም እጅድባብ አንጅምስባቤ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","የሱሰረ ኩን ጋይሴ፥ “ዋልቃ ኤች ሶይት እችምን አንድር ግግስሶ በድ ኤድም ኤልሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","እችምንተረ ሳዓትና የልሳንደትካ ኤልምስባብ ሶችንከስም፥ ‘ይና ሙዳ ርና ግግስምቴ ኮረቴ’ ጋይሶ ኬዝድንግንዳ ይንታ ፍክስንባብም ከደር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“ኬዛርንካ ማቼ ዋልቃ ዋልቀና ኤልምሳን ካርንዘን ነግካንታ ስርስ ኬዛ ዉች የጀኬ፥ ዋልቀና አክ ታ Ꮊም እ ሰንሳንጎካ አይስቶ ሰድን እም ዝግዝዴ፥ ኮካንታ እዝደር Ꮊድማዬ ዋደ ነጋ እም ጋይካ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ዋልቃባብነረ ዎንካንታ ‘የድ ዶንቅ ገዝምንከስም ሰንትቴ፥ ከትም ጰጫካንታ እ ይድን ኦላር ዋደ እም ነጋ ጋይካ’ ጋይሴ ");
INSERT INTO gyl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","አብነረ ጉጅሶ ‘አክ እሳ እ እንቻንካንታ እዝደር Ꮊድማዬ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ፍክስንባበረ ማት Ꮊድሶ ከት ጋይሳንደትም ኤችንካንት ኬዜ። ኮታይከረ ኤሄንታባበና ዋጭሶ ፍክስንባብም፥ ‘ሳነካ ካተመንታ ባስ ጎግንዘንከ ኦስከ ፈንካ ኦንገርድን ጎግንዘን ዉትካ፥ ር ካየን ባብከስምከ ዎብንባብከስም አፍይ ዝልንከስም ዎከል ዎከልን ጋይድባብከስም ኮር ከትም አርችካ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“ፍክስንባበረ ‘እስታ ባበኖ የስ ክትሳንደትም ሙዳ ቦትቴ፥ አክ ታየረ ካርና ዶቅዴ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“ማተንቆልስባበረ ይንታ ፍክስንባብም ኦስ ጎግንከሳርከ ካተመንካየን ጎግናር ዉትካ እስታ ኤሄና ጮጭድንግንዳ የስ Ꮊፍስባብም ሙዳ ከት Ꮊድንግንዳ ይካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","የም ጋይድቴ ኤልምስባብ ከትኬና ኤድንከሳርንካ ዋልቃ ኤድ ዎራ እ ግግሳን እችምን እችተራክየ ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","በድ ዎርሳ ክትካ ክክን ሙካ ዶቅድንካ የሱስ ማት ቡደካ ከትም ሰድሶ ኩን ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“እዝደር Ꮊድባብ ሙደና ይንታ ባበንምከ እንደንም፥ ይንታ ከነንምከ ይንታ ይንችንም፥ ይንታ እስመንንከስምከ ምችነንከስም፥ ይንታ ዶቅንተን ዎራ ነጋክናና እዘንካ ስግስሶ ሶልምድባብ ማቼ እም ጎርስምድባብ ማታዬ”፥ ");
INSERT INTO gyl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ይንታ ማተን ደእ የለልታ ስክስት እምዳክባብ እም ጎርስምድባብ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","የንታርንካ ዋልቃ ኤች ሰይን ኤሀ ዎድካንታ ይ ዝግዘ ይ በይዝድንደትም አና ይ በይሳንደትም እርናና ዶቅሶ ብረንም ገቀርዳክባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ኩን ማታክንዳ ማቸ የድንም የድሶ በይስና ክትም ጋምሴ፥ ሰድባብከስ ሙደና ይንጭካ ክታዘን ከዝተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ኮና ኤችና ሰይን ኤሄን ዎድ የታ ዶቆ በይስ ክትም ጋምሴ፥ ኩነረ ጋየረኮ Ꮊልተርካ ከዝተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ታማ ሳአ ዳምንባብ ዶቅድባብም ዋልቃ ባንችን ቦንዳ ሳአ ዳምንባብከስም የድሶ Ꮊድባብዘንካ አብ ባንችንካ ክክን ዳም ይ ዝግዘ እርምሶ ይንታ ይምኤንባብም ጋምካንታ ይ ማድንደትም ኤስካንታ ዶቅሶ ዞርምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ጋማይ ይ ማቼ አብ ባንችና አክ ክት ጎት ናና ክተንባብከስም ኦይትሶ ኤድምካንታ ኦይዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ኮትኮግንደረ የንታርንካ Ꮊየነረ ይንታ ዶቅድንደትም ሙዳ ዛቃይባብ እም ጎርስምድባብ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“ሶቅ ኡርሜ፥ ሶቅ ይንታ ሎቅምንም ይ ካይሳን ማቸ Ꮊስ ይሶክ ሎቅካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","“ኮግንዳ ሶቅና ፍጨም ኤቅስካንተረ መያይንዳ ማትንተንካ ኦስ ማል ኦይትምዴ። ኤሰርድን ቃም ዶቅድባብ ኤሰራ”። ");
INSERT INTO gyl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ዋልቃሰጭ ቃረጭን ተችዝድባብከስኬ በድ ጎመንባብከስ ሙደና የሱሰደር ኤስርካንታ ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ፈረሳውያንንከስኬ ሙሴታ ህግንም ኤስዝድባብከስረ፥ “ኮና ኤችና ጎመንክንባብከስም ይንደር ኤልዴ፥ ከትካ ክክን እጅዴ” ጋየረኮ ጉንድምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","የሱሰረ ኩንጋየሮ ኮም ካምስንከስም ከትካንታ ኬዜ፤ ");
INSERT INTO gyl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“የንታ ዎክያርንካ ዋልቃባብታ ጨታ ቆል ዶቅሳንማቼ ከታዋርንካ ዋልቀና ካይዴ፥ ኦይድ ቦንደከ ታሜከ ሳክለንም ቦንገንዘን ዛቅሶ ካይዳንደትም ይ Ꮊፍተርን የለልታ ዝግካንታ አይዳክባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ይ ᎺፍሳንደትᎺይካ ጉርምሶ ይንታ ገትንዘን ባልሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ይንታ ኤር ማዴ። ኮታዘንከረ ይንታ ገርነንከስምኬ የለንከስም ዋልቃትችካ ኤልሶ፥ ‘ካይዳን እስታ ቆለንን Ꮊፍትቴ እንካ ክክን የም ጉርምሳ’ ኖ ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ኮትኮግንደረ ጎማ ፍክስን ይንታ ዎይዝዳክባብከሳርንካ ኦይድ ቦንደኬ ታሜኬ ሳክላ ጭልንከዘንካ ስግሶ፥ ጎማ ይንታ ፍክስን ዎይዝድባብ ዋልቃ ኤችካ ጭለዘን በድ ጉርም ማዴ” የንደር ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“አና ታማ ጣገራ ብራ ዶቅድን ኤተን ታሜናርንካ ዋልቀና ኮታ ካይዴ፥ ይ Ꮊፍተርን የለልታ ዞጰን ሳክስትዮ ና ይንታ ኤሄንም Ꮊጭሶ ማለካ ዝጋይንዳ ኤተን Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","“ይ ᎺፍሳንደትᎺይከረ ይንታ ገርነንከስምከ ይንታ የለንም ዋልቃትቸካ ና ኤልሶ፥ እስታ ካይዳን ዋልቃ ጣገራ ብረንም Ꮊፍትቴ እንካ ክክን የም ጉርምሳ ና ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","እታ የም ጋይድቴ፥ ኮትኮግንደረ ጎማ ይንታ ፍክስን ዎይዝድባብ ዋልቃ ኤችካ ሳብታ ክታ ይንችንታ ባንግር ጉርም ማዴ”። ");
INSERT INTO gyl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ጉጅሰረ የሱስ፥ ዋልቃ ኤችታ ቃስተን ይንች Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ካንስነረ ባቤንም፥ እባቦ፥ የስታ ሪይናርንካ እካንታ የልድንደትም እምካ ጋይሴ፥ ባበነረ ይንታ ቆልመንም ከት ይንችንካንታ ካሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","በደረ ሰጫ ዶቃክሳ፥ ካንስና ይም የልሳንደትም ሙዳ ሳንስትዮ ጎት ፍጫ አይሴ። ኮታረረ ዉችኩን ብረንም ካይስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ኖየረ ዶቅድንደትም ሙዳ ክት በይሳንደታ ቡር፥ ኮትኮ ፍጨናር ዳቅሳን ዳቅ ማቼ፥ ማጣረረ ኖ አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ኮካንታ ፍጨንኮታር ዶቅድባብከሳርንካ ዋልቃባብታ ኤር አርደዴ፥ ኤችነረ ጉድምን ክት ግዝድንግንዳ ቦንጋር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ጉድምንከስ እጅድንደትም እስንታ ንፔርሳን ዎምፔንም ዎራ እችካንታ አንገርድ Ꮊቄ፥ ኬዛርንካ ማቼ ኮትም ዎራ ክትም እምድባብ ኤድ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ይንታ ቡዳር ይ ገቀርሳንደታ ቡር ኩን ጋይሴ፥ እስታ ባበንታ ፍክስንባብከስ መምንካንታ እችምና ስጥሶ ዶቅዳ፥ እታ ማቼ ኮታር ዳቅካ ደእካንታ የልትቴ! ");
INSERT INTO gyl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","እታ አምስቶ እስታ ባቤንደር አይስቶ፥ ኩን ጋይትቴ። እስታ ባቤኖ፥ ሳብተኬ የስተካ እረረ ባችትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ይና ኮዘንካ የስታ ይንች ጋይሶ ኤልም እም ዝክሳዬ፥ የስታ ፍክስንባብከሳርንካ ዋልቀንከስግንዳ እም ፋይድካ፥ ጋይትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ኮካንታ አምትዮ ይንታ ባበንደር አይሴ። ክት አክ ጎትናና፥ ባበና ሰድሶ አጨርሴ፥ ክደር ዞደካ አይሶ እምጭሶ ሶንቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ይንችነረ እባቦ! ሳብተከ የስተካ እር ባችትቴ፥ ኮዘንካ ኦስ የስታ ይንች ጋይምስቶ ኤልም እም ዝግሳዬ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“ባቤና ማቼ ፍክስንባብከስም ኩን ጋይሴ፥ ‘ሳናናና ሙደናርንካ ኡርማ ማቻን አፍላ ተይ Ꮊድሰቶ ቆፍስከቴ፥ አንታ ግልኤናር አርቸርድንደትም ኡርማ ዎርቃ፥ ክታ ዱትናረረ ጫመን አርችከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ዱድሳን ገዝም ተይ Ꮊድሰቶ ማችከቴ፥ እቸርተሬ፥ ጉርመርተሬ! ");
INSERT INTO gyl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","“ ‘ኮና እስታ ይንችና ደእቴ ጋይሳት ናና፥ ታ ማቼ ሰንፔካ ማቴ፥ ካይሰረ Ꮊቃዶቆ ታ Ꮊፈርቴ’ ኮካንታ ክትጎካ ጉርም የጀኬ”። ");
INSERT INTO gyl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","ኮትᎺይካ እስመና ዎንᎺማር Ꮊቄ፥ ዋርንከረ ማትሶ ኤሄንደር ክት የልድንካ ሶንግተኬ በይደታ ኡፍስ ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ኖየረ ፍክስንባብከሳርንከረ ዋልቀንም ኤልሶ፥ ርና Ꮊራ ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ፍክስንባበረ፥ የስታ ካንስና Ꮊቴ፥ ኡርመካ ክት Ꮊዳንካንታ የስታ ባቤና ዱድሳን ገዝም ክትካንታ ማችቴ፥ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","እስመነረ ዋጬ፥ ኤር አርደረ ዝጋክዬ፥ ባበነረ ማል ዉትሶ ክት አርድንግንዳ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ኖ ማቸ ማስትዮ ባበንም ኩን ጋይሴ፥ ይና ኮካ ስላ አይላግንዳ የስካንታ ፍክስትቴ፥ የስታ ክተናርንከረ ዋልቀንም ዎራ ዞግሳክቴ። የና ማቸ እስታ ላኮይትንከስካ ክክን እ ጉርምድንግንዳ ዋልቃ ደርትታ ቅንጭ ዎራ እም እማካዬ። ");
INSERT INTO gyl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ኬዛርንካ ማቸ ኮና የስታ ይንችና የስታ ቆልመንም ማነካ ቤልምዘን በይስሶ Ꮊድንካ፥ ጮመርሳን ገዝምም ክትካንታ ማቻዬ። ");
INSERT INTO gyl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ባበነረ ኩን ክደር ጋይሴ፥ እስታ ይንችኖ፥ የና ሙዳᎺይካ እንካ ክክነየ፥ እስታ ማቻንዳ ሙዳ የስቴ። ");
INSERT INTO gyl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ኮና የስታ ካንስና ማቸ ደእቴ ጋይሳት ናና፥ ታ አፈካ ማቸ፥ ካይሶ Ꮊቄ፥ ታ Ꮊፈርሴ፥ ኮካንታ ጉርመሮቶ ዎም ጉርምዝድንደትም ፍክስ ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","የሱስ ይንታ ካርንካ ጎርስምድባብከስካንታ ኩን ጋይሴ፥ ዋልቃ ቆልመክን ኤችታ ዋልቃ አመንማክዶቆ ካርዝድባብ ኤች Ꮊቄ፥ ኮና ካርስንባብ የስታ ርን ዉች ባቻዶቅዴ ጋይሰኮ ቆልመንባብደር ካሰሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ኮካንታ ክትም ኤልስሶ፥ ኮና የዘን ኤስምድንዳ Ꮊረርየረ? ይና ኮዘንካ የና አሜንምስባብ ካርሰንባብ እስታ የስ ማታክንካንታ፥ የስ ገችዝድን እስታ ርን ፋይደርድንደትም እካንታ እምካ ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","አመንማክን ካርስንባብነረ ይንታ ቡዳር ኩን ጋይሴ፥ እስታ ማታቆልስባብ እ ካርዝድንደትዘንካ እም ነክስስካንቴ፥ ዎነንታ ዎልቃ እስታ ካዬ፥ ምክስትዮ ተይ እታ ኦስንድቴ፥ ኮካንታ Ꮊስስ ይቴ? ");
INSERT INTO gyl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ካርስንዘንካ እ ነገዳን ማቼ ኤድንከስ ይንታ ኤር ሞክት ኬት እም ተይድንግንዳ እ ይድንደትም እታ ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ኮካንታ ይንታ ማተንቆልስባብታ ባዛ ዶቅድባብ ኤድንከስ ዋልቃ ዋልቀን ኤልሴ፥ እርንባብ ኤችንም፥ እስታ ማተንቆልስባብታ ባዘና የዘን መሞክ ዶቅዳ? ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ኖየረ፥ ዋልቃ ጨታ ዳሀካ እዘን ዶቅዴ ጋይሴ። “አመንማክን ካርስንባበረ፥ ፍክስንካንታ የስ ኤእሳን ዋርቀትን ይእ፥ ሳና ዶቅሰዮ ቃስተን ቦንደኬታማ ዳሀ ጋይሰዮ ጻፍካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ኮታዘንከረ አብንም፥ የነሰ የዘን መም ባዛ ዶቅዳ? ክትም ጋይሴ። ኖየረ፥ ዋልቃ ጨታ አልንካ እዘን ዘርግ ዶቅደ ጋይሴ። አመንምዳክን ካርስንባበረ፥ የስ ታልቃ Ꮊቃን ጻፈርሳንደትም ይእየ፥ ኦይድ ቦንዳ አሌ ጋይሰዮ ጻፍካ ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ክታ ማተንቆልስባበረ አመንምዳክን ካርስንባብም ክታ ሩርምካ በርእሴ። ኮነረ ሳብ ኤድንከዘንካ ስግስሶ ሳብም ኤዝዳክን ኤድንከስ ፍጨዘን ይንታ ዶቅንተንካ ሩርምባብ ማትንተንም ሰጅዴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ኮካንታ ጋይድቴ፥ ኮ ፍጫሙደንዘን ብረና በእሳንደትካ ስለንካ ዶቅድን ኤሄናር ተይምድባብ የ ማተርንግንዳ፥ ኮትኮ ብረንካ ሱሰንከስም የንታ ማታ ካንታ በችስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ቶክማ ሪካ አሜንምስባብ አንድርንከረ አመንምዴ፥ ቶክማ ርይካ አመንማክባብ አንድርንከረ አመንማዬ። ");
INSERT INTO gyl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ይና፥ ኮ ፍጫሙደንዘን፥ ቆልመንካ የ አመንማክንዳ ማቼ፥ ዶፈን ቆልመን Ꮊይ ኮም ካርስካ ጋይሶ የም እምተራ? ");
INSERT INTO gyl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","አብ ኤድንታ ቆልመንካ የ አመንማክንዳ ማቼ፥ የንታ ማታ ማድን ቆልመን Ꮊይ የካንታ እምተራ? ");
INSERT INTO gyl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ዋልቃ ኤች ቃስተን ማታ ቆልስባብከስካንታ ቆልምድባብ ካዬ፥ ኩን ማቼ ዋልቀንም ቦስሶ አብንም ሶልምደ። አና ዋልቀንደር ቅንችዴ፥ አብንም ቶጅዴ። ሳብካንተከ ብራካንታ ቆልም የም ዝግሳዬ”። ");
INSERT INTO gyl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ብረም ሶልምድባብ ፈረሳውያንንከስ ኮም ሙዳ ከታ ይ ኤሰርሳንደትካ፥ የሱሰዘን Ꮊልተርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","የሱስ ማቼ፥ “የታ ኤታ እሪ የንታ ማተንም ጭልዝድባብከሰቴ፥ ሳብ የንታ ቡደንም ኤዝዴ። ኤታ ላማር ቦንችምስባብ፥ ሳብታ እር ቶችምስባበቴ”። ");
INSERT INTO gyl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ሙሴታ ህግንኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ማጻፍና ስእስንባብ ዮሀንስ የለልታ ኬዘሮ Ꮊቄ፥ ኮታ ቡር ማቼ ሳብታ ባንችምንታ ክላ ኬዘና ከዝምተሬ፥ ኤድ ሙደና ኮ ባንችምናር አርድካንታ ጉርደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ኬዛርንካ ማቼ ህግንዘንካ ዋልቃ ር ነግድንዘንካ ጭለኬ ፍጨካ ካይደስናና ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ይንታ ኬነንም ቡልሶ አብንም እንጅድባብ ሙደና ቤልምባቤ፥ ክእስንዘንካ ቡልምሳን ኤተንንም እጅድባብ ቤልምባቤ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ጉጅሰረ የሱስ፥ ዘይም ኡርማ አፍላ ቃልምን ቆበርስባብ ሙዳᎺይካ Ꮊላ ጋይሶ ጉርምካ ዶቅድባብ ዋልቃ ቆልመክንባብ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","አነረ አልዓዛር ጋይምድባብ ሙዳ ክታ ዘነና ድድᎺክ ማችባብ ዋልቃ ር ካየንባብ ክትኮ ቆልመንባብ ኤችንታ ፍልታር ኤድንከስ ክትም ተይ Ꮊድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ቆልመንባብ ኤችና እችም እጅድንካ ዋጅድን ድንግመንም ዎራ እችካንታ አንገረሮ Ꮊቄ፥ አክስንከሰረ Ꮊድሶ ክታ ድድንም ላኤሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ኖኮና ሪ ካየንባበረ ደእሴ፥ ክታይንችነረ አብራሀመታ ባንግር ክትም ተይ አይሰኬ፥ ቆልመንባብ ኤችነረ ደእስንካ ዱክምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ጩልጩል ጎርናር ማጠረሮ ዶቅድ ጬክን ጋይሶ ጎትካ አብራሀመም ሰጄ፥ አልዓዛርመረ ክታ ካፋር ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ኖየረ አብረሀም እስታ ባበኖ! እካንታ አጨርካ! ኮ ኖሄንታ ሎግንችናር እ ማጠርድንካንታ፥ አልዓዛር ይንታ አንንታ ግልኤንካ ሎቀንም ዱክትዮ እስታ አድምን ክት ጋንችተርንግንዳ ዋደ እካንታ ኦይትካ ጋየሮ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","አብራሀም ማቼ፥ እስታ ይንችኖ! የና ፍጨዘን የስ ዶቅድን ስለናር ኡርማ ሪንከስም የስ ተያንግንዳ፥ አልዓዛረረ ዳቅል ሪንከስም ተያቀንደትም ገቀርካ፥ ታ ማቼ ክት ኮር ጉርምድንካ፥ የና ማጠዘን ዶቅተረዬ። ");
INSERT INTO gyl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ኮ ሙደንዘንካ ስግ ኮዘንካ ኦስ የንደር ስግካንታ ማትማይንዴ፥ ኦኮታር ዶቅድባብከስ ዎንደር ከት ቃልተራክንግንዳ የንተኬ ዎንተካ ዎክያር አንድር ዎራ ማቴ፥ ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ቆልመንባበረ፥ ባቦ! ይና አልዓዛርም እስታ ባበንታ ኤር የስ ኦይተርንግንዳ የስም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","እስታ ዶንቅ እስመንንከስ ዶቅድንካንታ፥ ከተረ ኮ ማጣ ካርናር ከት Ꮊተራክንግንዳ ከትም ኤግዝምሳ ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","አብራሀም ማቼ፥ ሙሴተኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ማጻፍና ዶቅደኬ፥ ከትም ኬት ኤሰራ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ኖየረ፥ አብረሀም እስታ ባቤኖ! ኩን ካዬ፥ ዋልቃ ኤድ ደእያርንካ አምሶ አይሳናና ጎማ ፍክስን ይንታ ዎይዝደኬ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","አብራሀመረ፥ ሙሴተኬ ሳብዘንካ ኤሰርሶ ኬዝድባብከስታ ማጻፍን ኤሰርዳክባብከስ ማቼ፥ ዋልቃ ኤድ ደእያርንካ አምሴ ዎራ አመናየኬ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","የሱስ ይንታካርንካ ጎርስምድባብከስም፥ ኤድን ከስም ጎሄርዝድን ሪ Ꮊድን ነጋዬ፥ ኬዛርንካ ማቼ ጎሄርስና Ꮊድንግንዳ ጎግማድባብ ክት ኮ ኤችንም የኤ! ");
INSERT INTO gyl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ኖኮና ኤችና ከትኬና ቶክምንከሳርንካ ዋልቃባብም ኮተርዝድባብ ደይስን ሰይንም ይንታ ባርያር ዞክርሶ ባሃርናር ኦይትምሰስናና ክትካንታ ኡርማ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ኮካንታ የንታ ማተንም ካርስምከቴ። “የስታ እስመና የስም ባችሰ ዋጭካ፥ ይንታ ዳቅል ፍክስንጎካ ክት አተርሰ ነጋ ጋይካ። ");
INSERT INTO gyl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“ሰጫር የስም ታብዛ ዱት ባችሰኬ ታብዛ ዱት ‘ቡዳርንካ አተርሳቴ’ ጋየሮ የዝደር ክት ማቼ ነጋ ጋይካ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ኦይትምስባብከሰረ ጮይስ የሱሰም፥ “አሜንንም ዎካንታ ጉጅካ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ጮይስ የሱሰረ “ኤክነታ አፍከከንዳ አሜን የንታ ዶቅሴ፥ ኮ Ꮊቃ ሳመንም ‘ቡጥምሳዮ ባሀርንታ ዋር ኮርምካ’ የ ጋይሴ የካንታ ክትምዴ” ኬትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ጉጅሰረ የሱስ፥ “የንታ ዎክያርንካ ዋልቃ ኤችታ ዎንባብ ናንከረ አና ቆል ግዝድባብ ክታ ፍክስባብ ዶቅሴ፥ ክት ዎንያርንካ Ꮊድንካ፥ ‘ሳነካ እችምደር Ꮊድካ’ ክትም ጋይደቴ? ");
INSERT INTO gyl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ኮዘንካ ስክስሶ፥ ‘ሶይት እችምን እ እጅድንግንዳ እካንታ ግክስካ፥ እ እችተርን ዎጭተርን የለልታ ግግምሶ እካንታ ፍክስካ፥ ኮታ ቡር የነረ እችተራየ ዎጭተራዬ’ ክትም ጋያዮ? ");
INSERT INTO gyl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ይና ኮና ኤችና ፍክስንባብም ክት ክትሳንደትም ቦድንተንካ ማስሶ ክትም አንጅዶ? ");
INSERT INTO gyl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ኮካንታ የተረ ኮትኮግንዳ የ ክትምሳንደትም ሙዳ የ ቦጃንደትካ፥ ‘ፋይደታ ዋር አርዳክን ፍክስንባቦቴ፥ ፍክስ ዎም ዝግድንደትም ፍክስቶቴ’ ጋይከቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ኮተረ ቡር የሱስ የሩሳሌም ካተመናር አይድዮ፥ ሳማራርከ ገሊላ ፍጨናርጎካ ስገዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ዋልቃ ሞረናር ክት አርደዳንግንዳ እጳ ሰቅምካ የደርስባብከስ ታማ ኤድ Ꮊፈርሰኬ፥ ከተረ ጎትካ ዎእሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ከተረ አንድር ኡፍስካ፥ “ዎንታ ባበን የሱስዮ፥ ዎካንታ አጨርካ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ኖየረ ከትም ይ ሰዳንደትካ “አይሰቶ የንታ ማተንም ቀሰንከስካንታ ሰችስከቴ!” ከትም ጋይሴ። ከተረ ኦስ አይዘን ዶቅደኮ ፋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ከታርንካ ዋልቀና ይንታ ፋጭንተንም ይ ሰዳንደትካ አንድር ኡፍስካ ሳብም ጋለተሮ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","የሱሰተረ ዱትንዘን ይንታ ባለንካ ጉፕን ጋይሶ ክትም ጋለቼ፥ ኖኮና ኤችነረ ሳማራ ፍጨናርንካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","የሱሰረ፥ “ፋጭባብከስ ታማ ኤድ ካየኮ? ይና ሳክለንከስና Ꮊብረረ? ");
INSERT INTO gyl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ኮ ሳማርያ ፍጫ ኤችን አለግንዘንካ አብ ማትᎺድሶ ሳብም ጋለድባብ ካያ ጋይንትዮ?” ኩን ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ኤችንመረ፥ “አምሶ አይካ፥ የስታ አሜንና የስም አቅሰቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ፈርሳውያንንከስ ሳብታ ባንችምና Ꮊንታ ኮት Ꮊዳናንከረ የሱሰም ከት ኦይሳንደትᎺይካ፥ “ሳብታ ባንችምና የ ካርዝድንጎግካ Ꮊዳየ፥ ");
INSERT INTO gyl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ኤድንከሰረ፥ ‘ካሮ’ አነረ ‘ኦ ኮታሮ’ ጋይካንታ ማታየኬ፥ ኮካንታ ሳብታ ባንችምና የንታ ዎክያሬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ይንታ ካርንካ ጎርስምድባብከስካንተረ፥ ኤደት ይንች Ꮊድን ሰጨንከሳርንካ ዋልቀንም ሰድን ካንታ የ አንገርድን ሰጫ Ꮊዴ፥ አነረ ሰተራከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ኤድንከሰረ፥ ኮታሮ አነረ ኦኮታሮ የንደር ጋይተረ፥ ከትም ጎርስምሶ Ꮊይ አየቴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ꮊረታ ጋይሴ ዋልቅንት ዋልቅንቼ ጭለታ ካንተዘንካ ካንታ የለልታ ሳግዝድንደትግንዳ፥ ኤደት ይንችነረ Ꮊድን ሰጨንካ ገታ ኮትኮግንዳ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ኬዛርንካ ማቼ ኮና ማተርንደታ እርምሶ ኤደት ይንች በድ ማጥርኬ ኮ አጥርንዘንካ ቶችም ክታዘን Ꮊድ ነጋዬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ኖህታ ስለናር ማቻንግንዳ ሙዳ ኤደት ይንች Ꮊድን ሰጨንካ ኮትኮግንዳ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ኖህ ሎቀንዘንካ ቃልዝድን ማርከብናር አርደዳን ሰጨን የለልታ ኤድንከስ እቸረኮ ዎጨረኮ፥ ይኤረኮ እንቸረኮ Ꮊቀኬ፥ ካይዝድን ሎቀነረ Ꮊድሶ ሙደንም ካይስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ኮትኮግንደረ ሎጥታ ስለናር ማቻንደትግንዳ ማተረ፥ ኤድንከስ እቸረኮ ዎጨረኮ፥ ኦስ ሰነረኮ ፈንክ ሰንት ተየረኮ፥ ኮረርድንደትም ኮረረኮ ኤሀ ዎደሮ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ሎጥ ሶዶማርንካ ዉተዳን ሰጨንካ ማቼ ኖሄኬ አድንዳ ዎልስም ጭላርንካ ዶብግንዳ ቃንሶ ሙደንም ካይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ኤድ ይንችና መያ ክት ማድን ሰጨንካ ኮትኮግንዳ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ኮት ሰጨንከረ ኤሄንታ የለንዘን ዶቅድባብ Ꮊየነረ ኤድ ኤሄንታ ዋር ዶቅድን ርም ተይካንታ Ꮊይ Ꮊንቸራ፥ ኮትኮግንደረ ዎን Ꮊማር ዶቅድን ኤደረ ይንታ ኤር Ꮊይማታ። ");
INSERT INTO gyl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ሎጥታ ኬነንም ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ሰንፔንም ይንታ አቅስካንታ ዝግድባብ ሙደና Ꮊፋዬ፥ ሰንፔንም ይንታ ስክስት እምድባብ ማቼ ኮትም አቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“እታ የም ጋይድቴ፥ ኮትኮ ሶይትንካ ቃስተን ኤድንከስ ዋልቃ ሰለዘን ራተረኬ፥ ዋልቀና ተይምተሬ፥ ቃስትምስና ነግተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ቃስተን ማነንከስ የካ ደይስን ደይስተረኬ፥ ዋልቀንዳ ተይምተሬ ና ቃስትምስና ነግተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ቃስተን ኤድና ዎን ካርዘን የካ ማተረኬ፥ ዋልቀና ተይምተሬ፥ ቃስትምስና ነግተሬ።” ");
INSERT INTO gyl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ክታ ካርንካ ጎርስምድባብከሰረ ማስሶ፥ “ጮይስዮ፥ ከት ተይምድንዳ Ꮊብረረ? ጋይሰኬ። ኖየረ ደእማ ዶቅድን ካርዘን ድገንከስና ሳንደኬ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ክታ ካርንካ ጎርስምድባብከስ ጋፋክዶቆ ዳቅሶ ሙዳᎺይካ ምክስ ከትም ዝግዝድንደትም ኤስስካንታ የሱስ ኮም ካምስንከስም ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ኩነረ ከደር ጋይሴ፥ ዋልቃ ካተመናር ዶቅድባብ ሳብም ጳዝዳክባብኬ ኤድመረ ቦንጅዳክባብ ዋልቃ ዳይና Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ኮትኮ ካተመናር ዶቅድንዳ ዋልቃ ኤተን ቡድና Ꮊቄ፥ ናየረ እስታ ይምኤንባብካ ክክን ዶቅድን ኬዘንታ ፋረድካ ጋየሮ ክደር ካርንካ ካርንካ ማተሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ዳይነነረ በድᎺይካ ኮታ ኬዘንም ኤሰራክዬ፥ ዋልቃሰጭ ይንታ ቡዳር፥ Ꮊረነረ ሳብም እ ጳሳይ ናንከረ፥ ኤድመረ እ ቦንቻይ ናንከረ! ");
INSERT INTO gyl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","“ናኮና ኤተን ቡድነና እዝደር ኮት ጫንጭድን ኦል ኮትካንታ ፋረትቴ፥ ኩን እ ይያክንዳ ማቼ ሙዳᎺይካ Ꮊደሮ እም ዘርዝዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ጮይሰረ፥ “ዳቅል ዳይነና ጋይሳንደትም ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ይና ሳብ Ꮊየከ ሶይትካ ክደር ፍብድባብ እድምስባብከስካንታ ፋረዳዮ? ሙደንዘንካ ስክስሶ ከትም እልን ጋይተሮ? ");
INSERT INTO gyl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","እታ የም ጋይድቴ፥ ሳነርሶ ከትካንታ ፋረተሬ፥ ኬዛርንካ ማቼ ኤደት ይንችና Ꮊድንደትካ ፍጨዘን አሜንን Ꮊፍተር ዳቶ?” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ከታ ይንታ ማተንም ዶፈንንባብከስግንዳ ፋይድንተካ ጬቅድባብከስኬ አብንከስም ቶቸካ ሰድባብ ኤድንከስካንታ ኩንጋየሮ ኮም ካምስንከስም ከትካንታ ኬዜ፥ ");
INSERT INTO gyl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ቃስተን ኤድ ምክስካንታ ሳብታ ጭል ኤሄናር አይሰኬ፥ ዋልቀና ፈረሳውያን፥ ቃስትምስና ቃረጭን ተችዝድባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ፈረሳዊያንና ዎእሶ ይንታ ቡደናር ኩንጋየሮ ምግዝድ Ꮊቄ፥ ‘ሳብዮ! እታ አብ ኤድንከስግንዳ ቡራባብ፥ ኤእዳክባብ፥ ማነም ኦካ ኦንግድባብ፥ ስክስሰረ ክትኮ ቃረጭን ተችዝድባብግንዳ እ ማታክንኦል እታ የስም ጋለድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ሳምንታር ቃስተን ዱት በቼካ ምግዝድቴ፥ እ Ꮊብድን ሪ ሙደናርንካ ታሜናርንካ ዋልቀን ዉጅድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“ቃረጭን ተችዝድባብ ማቼ ጎትካ ዎእሶ፥ ጭላር ጬክን ጋይሶ ሰድንካንተረ ዎራ ዝጋክዬ፥ ኬዛርንካ ማቸ ኦንገዝን ይንታ ጎደሮ ‘ሳብዮ፥ እ ጎመንባብም ማርካ’ ጋየሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“እታ የም ጋይድቴ፥ ፈረሳውያንንከዘንካ ስክስሶ ኮና ሳብታ እሪ ጭል ማትሶ ይንታ ኤር ኖ ማቼ፥ ይንታ ማተንም ጬክ ጬክሳ ይድባብ ሙደና ይርክን ጋይተሬ፥ ይንታማተንም ይርክ ይርክሳ ይድባብ ማቼ ጬክን ጋይተሬ”። ");
INSERT INTO gyl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","የሱስ ከታዘን ይንታ አንን ዎድንግንዳ ኤድንከስ ይንችንከስም ክደር ተይ Ꮊድ Ꮊቀኬ፥ ክታ ካርንካ ጎርስምድባብከሰረ ኮም ሰድሰኮ ከትም ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","የሱስ ማቼ ይንችንከስም ይንደር ኤልሶ፥ “ይንችና እዝደር ከት Ꮊድንግንዳ ጋይከቴ፥ Ꮊይማረቴ፥ ሳብታ ባንችምና ከትከናከስግንደንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ዶፈን የም ጋይድቴ! ሳብታ ባንቺምን ይንችንምግንዳ ተይዳክባብ ሙደና ቦድሶ ኮታር አርዳዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","አይሁድንከስታ ገችንባብታርንካ ዋልቀና፥ “Ꮊልስማ ኤስስንባቦ! ስለንክንደታ ዶቅንተንም ተይካንታ Ꮊርስ ይቴ?” ጋየሮ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","የሱሰረ፥ “Ꮊረተስ እም Ꮊልስማ ጋይዳ? ዋልቃ ሳብንዘንካ Ꮊልስማ Ꮊየነረ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‘ማነንም Ꮊይ ኦካ ኦንጌ፥ Ꮊይ ደይሴ፥ Ꮊይ ድቤ፥ ካርከካ Ꮊይማርከሬ፥ የስታ ባበንምከ እንደንም ቦንችካ’ ጋይድንደትም ክተንም የና ኤዝደዬ” ኩንጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ኤችነረ፥ “ከናከስ ክተንም እስታ ይንችርንካ የድስቶ ካርስትቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","የሱሰረ ኮም ይ ኤሰርሳንደትካ፥ “ይና ዋልቃ እር የዝደር ነገዴ፥ የስታ ዶቅድንደትም ሙዳ ሰንሳዮ ርካየንባብከስካንታ እምካ፥ ጭላር የስታ ቆልማ ዶቅተሬ፥ ኮታዘንከረ Ꮊድሰዮ እም ጎርስምካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ኤችና ማቸ ኮም ኤሰርሶ፥ በድ ቆልማ ክታ ዶቅድንካንታ አንድር ሞርእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","የሱሰረ ኤችና ሞርእሳን ሰድሶ፥ “በድ ቆልማ ዶቅድባብከስካንታ ሳብ ባንችማር አርድንታ Ꮊስግንዳ ማጠሬ? ");
INSERT INTO gyl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ቆልመንባብ ሳብታ ባንችምናር አርድንደትዘንካ ስግሶ ግመል ማርፈታ ጩቅንካ አርደደስናና ኡርዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ኮም ኤሰርሳን ኤድንከሰረ፥ “ይና Ꮊይ አቅተራ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","የሱሰረ፥ “ኤደር ማዳክንዳ ሳብደር ማተዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ጴጥሮሰረ፥ “ይና ዎታ ዎንታ ዶቅድር ሙዳ ዛቅሶቶ የስም ጎርስምሶቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","የሱሰረ፥ “ዶፈን እታ የም ጋይድቴ፥ ሳብታ ባንችምንካንታ ጋይሶ ይንታ ኤሄንም ናንከረ ይንታ ኬነንም ናንከረ ይንታ እስመንከስም ናንከረ ይንታ ባበንምከ እንደንም አነረ ይንታ ይንችን ዛቅስባብ ");
INSERT INTO gyl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ኮ ስለናር በድ ጉጅምሳንደትም፥ Ꮊድን ስለናረረ ስለንክንደትም ሰንፐን ተይዳክባብ Ꮊየነረ ካዬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","የሱሰረ ታመከ ቃስተን ይንታ ካርንካ ጎርስምድባብከስም Ꮊክ ከትም ተይ አይሶ፥ “ይና የሩሳሌም ካተመናር ዉትካንታ ይዶቴ፥ ሳብዘንካ ኤስርሶ ኬዛቅባብ ኤድ ይንችንጎካ ጻፍምሳንደረ ሙዳ ኮታር ቦድምዴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","አይሁድ ማታክባብከስካንታ ስክስት ክትም እምተረኬ፥ ከተረ Ꮊልተርካ ክታዘን ከዝተረኬ፥ ክትም የክተረኬ፥ ክታዘን ፈጭምተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ክትም ከታ ይ Ꮊርጃንደታ ቡር ደይስተረኬ፥ ኖየረ ማክምስ ሰጭንካ ደእናርንካ አምተሬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ክታ ካርንካ ጎርስምድባብከስ ማቼ ኮ ሙደናርንካ ከት ኤሳንዳ ዋልቃ ሪየረ ካዬ፥ ክታ ጋይተነረ ከታዘንካ አችምሶ Ꮊቄ፥ Ꮊረታ ክት ኬዛ ናንከረ ኤሳከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","የሱስ ኢያርኮ ካተመናር ክት የልሳንደትካ፥ ዋልቃ አፊይ ዝል ጎግታ ካንተዘን ዶቅሶ ምግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","አፍይ ዝልነረ ዎርሰና ኮትኮ ጎግንካ ከት ስገድንካ ኤስርሶ “ኮና Ꮊራ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ከተረ፥ “ናዝረታርንክንባብ የሱስ ኮካ ስጋዶቅዴ” ጋይሶ ክትም ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ኖየረ፥ “ዳውተታ ይንችን የሱሶ! እም አጨርካ!” ጋየሮ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","እር አያዶቅድን ኤድንከስ ጫምን ክት ጋይድንግንዳ ክትም ዋጨኬ። ኖ ማቼ “ዳውተታ ይንችኖ! እም አጨርካ!” ጋየሮ አንድርካ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","የሱሰረ የዝግን ጋይሶ ኤችንም ክደር ከት ተይ Ꮊድንግንዳ ክትሴ። ክደር ክት የልሳንደትካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","የሱስ “Ꮊራ እ ይያባበስ ዝግዳ?” ጋይሶ ክትም ኦይሴ። አፍይ ዝልነረ፥ “ባቦ! ሰድንካንታ ዝግድቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","የሱሰረ፥ “ሰድካ! የስታ አሜንና የስም አቅስቴ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ኤችነረ ሳነካ ሰጄ፥ ሳብመረ ቦንቸሮ የሱሰም ጎርስምሴ። ዎርሰነረ ሙዳ ኮም ሰደረኮ ሳብም ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","የሱስ ኦስ ኢያርኮ ካተመናር አርድሶ ክት ስገድንካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ላምና ክታ ዛከዎስ ጋይምድባብ ዋልቃ ኤች ኮታር Ꮊቄ፥ ቃረጭን ተችዝድባብከስታ ማተን ቆልስባብ ቆልመክንባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ኖየረ የሱስ ጋይምስባብና Ꮊምና ክት ማቸረ ሰድንካንታ ዝግድ Ꮊቄ፥ ዎይተነረ ክታ ጬድ ማቻንካንታ ዎርሰንታ በድምንዘንካ አምሳንዳ ክትም ሰድካንታ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","የሱስ ኮትኮ ጎግንካ ስገድንኦል፥ ክትም ሰድንካንታ ኦስ እር ዞድሶ ዋልቃ Ꮊቃ ሳመንታ ዘን ክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","የሱሰረ ኮትኮ ካርንዘን ይ የልሳንደትካ፥ ጬክን ጋይሶ፥ “ዛከዎሶ! ታካ የስታ ኤር Ꮊቅ እም ዝግዝዴ ሳነካ Ꮊንቸርካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ኖየረ ሳነካ Ꮊንቸርሶ ጉርምካ የሱሰም ሞክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ኮታረረ Ꮊቅባብ ኤድንከሰረ ኮት ኮም ሰድሶ፥ “ጎማባብታ ኤር አርድሶ ሞክምታ ይዴ” ጋይንተካ ሙደነረ ጉንድም የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ዛከዎስ ማቼ ዎእሶ ጮይስም፥ “ባቦ! ይና እስታ ዶቅድን ቆልማ ሙደናርንካ ባንግንም ሪካየንባብከስካንታ እምትቴ፥ Ꮊየንመረ እታ ካርከካ እ ቡርታ ማቼ፥ ኦይድንታዘን ኦይድ ጉጅስቶ ማስትቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","የሱሰረ፥ ጉጅሶ ኮና ኤችና አብራሀመታ ሱሳ ማቻንጎካ ታካ አቅንተና ኮ ኤሀ ኤድንካንታ Ꮊቴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“Ꮊረታ ጋይሴ ኤድ ይንችና Ꮊዳንዳ ካይድባም ዝግመትካንተኬ አቅስካንቴ” ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ዎርሰና ኮም ኤሰረሮ ከትዶቅድንካ ካምስካ ኬዘንም የጄ፥ Ꮊረታ ጋይሴ ኦስ የሩሳሌም ካተመናር ቅንችምሳንካንታ፥ ኤድንከዝደር ሳብታ ባንችምና ሳነካ መያ ማድን ከደር ካምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","የሱሰረ፥ “ዋልቃ ፍጨንታ ማታቆልስባብ ባንችን ይም ማስዝድንደትም ተይካንታ ጎት ፍጫ አይሴ”። ");
INSERT INTO gyl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ፍክስንባብከስታ ዎክያርንካ ታመንም ኤልሶ ዋልቃ ዋልቀንካንታ ታማ ጣገራ ብራ ከትም እምሶ “ማት እ Ꮊተርን የለልታ ኮ ብረንካ ዛለንም ዛልከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“ፍጫ ኤድንከስ ማቼ ክትም ቦሳንኦል፥ ‘ኮና ኤችና ዎንዘን ባንችምድንግንዳ ዝግዳኮቴ’ ጋይሰኮ ክታ ባዝደካ ክተንባብከስም ክደር ኦይቸኬ”። ");
INSERT INTO gyl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ማተጋካ ዳት ኖኮና ኤችና ባንች ማትሶ ይንታ ፍጨዘን ይ Ꮊዳንደትካ፥ ከታኬና ፍክስንባብከሰረ ክት እምሳን ብረንካ ዛልእሰኮ Ꮊረከካ ከት ስእሳናከረ ኤስካንታ ከትም ኤልስሴ”። ");
INSERT INTO gyl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","እርንባበረ Ꮊድሶ፥ ባቦ! የስ እምሳን ብረንዘን ታማ ብራ ስጥማ Ꮊፍስስቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ማታቆልስባበረ፥ የና አሜንምስባብ ፍክስንባቦ፥ ኡርማ ይተዬ፥ መራ ሪካ አሜንምስባብ ማትሳዮ የስ Ꮊፈርሳንካንታ ታማ ካተመንዝን ገችስታ ኤራ የስካንታ እምትቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“ቃስትምስነረ Ꮊድሶ፥ ባቦ! ‘የስ እምሳን ብረንዘን ዶንቅ ብራ ስጥማ Ꮊፍስስቴ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ማታቆልስባበረ፥ ‘ጉጅሶ የነረ ዶንቅ ካተመንከዘን ገችታ ኤራ የስም እምትቴ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“አብነረ ፍክስንባብና Ꮊድሶ፥ ባቦ! ቱርጨካ ኦችትቶ እ ዎጃንዳ ብረና ኮንሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","የና የስ ዎዳክንደትም ተይድባብ፥ የስ ማሳክንደትም ስግድባብ፥ ኤእዳክባብ ኤች የስ ማቻንደትም እ ኤሳንጎካ ጳስቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ክታ ማተንቆልስባበረ ኩን ጋይሴ፥ የና ኤእዳክባብ ፍክስንባብ! የስታ ኬዘንካ የዘን ፋርድቴ፥ እ ዎዳክንደትም ተይድባብ፥ እ ማሳክንደትም ስግድባብ፥ እ ኤእዳክን ኤች ማትንተንም የስ ኤሳንካ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","እታ Ꮊድስቶ ብረንም ስጥመንካ የካ እ ተይድንግንዳ Ꮊረተረ ፍግዝድባብ ኤድንከስካንታ የስ እማክንዳ? ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ኮታዘንከረ ማተንቆልስባብ፥ ዋር ዎእስባብከስም፥ ብረንም ክታዘንካ ተይሰቶ ታማ ብረን ዶቅድባብካንታ እምከቴ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“ከተረ ‘ጮይስዮ! ክታ ታማ ብራ ዶቅዴ’ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“ኖየረ ኩን ጋይሴ ‘ዶቅድባብካንታ ጉጅምተሬ፥ ካየንባብዘንካ ማቼ ና ዶቅድንዳ ዎራ ክታዘንካ ተይምተሬ’። ");
INSERT INTO gyl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ኬዛርካ ማቼ፥ እ ከታዘን ባንችምዳክንግንዳ ዝግዝባብከስም ከትኬና ይምኤንባብከስም ኮር እዝደር ተይ Ꮊድሰቶ እስታ እር ከትም ደይስከቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","የሱስ ኮም ይ ኬዛንደታ ቡር፥ የሩሳሌም ካተመናር ዉትካንታ ከታ እር አይ የጄ። ");
INSERT INTO gyl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ደብረዛይት ጋይምድን ገቸንታ ላማር ዶቅድን፥ በቴ ፋጋርኬ ብታንያ ሞረንከሳር ይ ቅንችሳንደትካ፥ ይንታ ካርንካ ጎርስምድባብከሳርንካ ቃስተንንም ኩንጋየሮ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“የንታ እር ዶቅድን ሞረናር አይከቴ፥ ኮታረረ የ አርድንካ Ꮊየሰነረ ዶቃክንዳ ኡክልታ ቅንጭ ዞከርስንካ Ꮊፍተረቴ፥ ቡልተቶ ፈንካ ተይ Ꮊድከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ꮊየነረ ‘Ꮊረተንት ቡልዳ?’ ጋይሶ የም ኦይሴ፥ ‘ጮይስ ኮትም ዝግዛንካንቴ’ ጋይከቴ”። ");
INSERT INTO gyl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ክተርስባብከስ አይሶ ገታ ክት ኬዛንግንዳ ማችንካ Ꮊፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ኡክልንባብከሰረ ኡክልንታ ቅንጭን ከት ቡልድንካ ሰድሰኮ “ኡክልንታ ቅንጭን Ꮊረተንት ቡልዳ?” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ከተረ፥ “ጮይስካንታ ዝግዝዴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ኮታዘንከረ ኡክልንታ ቅንጭን ፈንካ የሱሰደር ተይ Ꮊደኬ። ከታ ይንታ አፍለንመረ ኡክልንታ ቅንጭንዘን ኦይትሰኮ የሱሰም ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ኤድንከሰረ ክት አይድን ጎግንዘን ይንታ አፍለንም ታከረሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ደብረዝይት ገቸንዘንካ፥ ጩላ አይድን ጎግንዘን ቅንችምሳንግንዳ ፋይደና አንድር በድ ማችባብ ክታ ካርንካ ጎርስምድባብ ከታ ይ ሰጃን አታ ሙደንካ ጉርመረኮ ኡፍስን ይንታ ጬክሳ ይይሰኮ! ");
INSERT INTO gyl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ጮይስታ ላምንካ Ꮊድባብ ባንችና አንጅምስባቤ!” “ጭላር ሳረትች፥ ፈ ሳብ ዶቅድን ካርንካንተረ ቦንቻ ማታ!” ኩን ጋየረኮ ሳብም ጋለት የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ዎርሰንታ ዎክያር Ꮊቅባብ ዋልቃ ዋልቃ ፈረሳዊያንና የሱሰም፥ “ኤስስንባቦ! የስታ ካርንካ ጎርስምድባብከስ ጫምን ጋይድንግንዳ ዋጭካ” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ኖየረ የም ጋይድቴ፥ “ከት ጫምን ጋይሰረ፥ ሰይንንከስ ፍብደኬ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","የሱሰረ የሩሳሌም ካተመንደር የልሶ ካተመንም ሰድሶ ኮትካንታ ኤፍሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ኩነረ ጋይሴ፥ “ሳራትች የስካንታ ማድንደትም Ꮊረ ታካ የስ ኤሰስናና! ታ ማቼ የስታ አፍንዘንካ አችምቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","የስታ ይምኤንባብከስ የስታ ጋስትንካ ጋስ ጋስሶ፥ ሙዳ ፈንካ ቀንሶ የስም ከት ማእዝድን ሰጫ Ꮊዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","የስምኬ የስታ ጋስንታ ዋር ዶቅድባብከስም የስታ ይንችንመረ ከታ ፍጨዘን ኦይትሰኮ ካይስተረኬ፥ ሰይንካ ዎድምሳን ኤሄና ዉልእምዴ፥ ሳብ የስም አቅዝድን ሰጨንም ኤሳከዬ”። ");
INSERT INTO gyl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ኮታ ቡር የሱስ ሳብታ ጭል ኤሄናር አርድሶ ዛላ ዛልድባብከስም ዉችሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ጉጅሰረ “ ‘እስታ ኤሄና ምክስ ኤሀ ማተረ ጋይምሶ’ ጭል ማጻፍናር ጻፍምቴ። የታ ማቼ ፋንገንከስታ የርሳ ማስሰቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","የሱሰረ ሰጫ ሰጨንከረ ሳብታ ጭል ኤሄናር ኤስዝድ Ꮊቄ። ቀሰንከስታ ገችንባብ፥ ሙሴታ ህግን ኤስዝድባብከስከ አይሁድንከስም ጎርዝድባብከሰረ ክትም ደይሳካንታ ዝግድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ኬዛር ማቼ ዎርሰና ሙዳ ክታ ኤስስና ዋልቀረ ከታዘንካ ሱርታይንግንዳ ክደር ከት ኤሰርድንካንታ፥ ከት ይተርንደታ ጎግ ከትም ካይዴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ዋልቃሰጭ የሱስ ዎርሰንም ሳብታ ጭል ኤሄናር ኤስዝድንከ ክላ ኬዘን ክት ኬዝድንካ ቀሰንከስም ገችዝድባብከስ ሙሴታ ህግን ኤስዝድባብከስኬ፥ ጋልተንከስ ሳንምሰኮ ክደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ከተረ፥ “ከትኬና ርንከስም የስ ይድንዳ Ꮊራ ገችታ ኤረካ ማቼረ ዎካንታ ኬዝካ፥ ገችንታ ኤረን የስካንታ እምስባብ ኖ Ꮊይራ?” ጋይሰኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","የሱሰረ “እተረ ዋልቃ ኦይስ እ የም ኦይሳ፥ የታ እካንታ ማስከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ዮሀንሰታ ስስንታ ኤረና ሳብዘንኮ አና ኤድዘንኮ?” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ከተረ፥ “ ‘ሳብዘንኬ’ ዎ ጋይሴ፥ ‘ኮናና Ꮊረተረ ክተንካ የ አመንማክንዳ?’ ዎም ጋይተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘ኤድዘንኬ’ ዎ ጋይሴ ዎርሰና ሙዳ ዮሀንስ ሳብዘንካ ኤስርሶ ኬዝድባብ ማትንተን ከት አመንድንካንታ ሰይንካ ዎም አቅትረኬ” ኩን ጋየረኮ ክክ ክክ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ኮካንታ፥ ኤረና “Ꮊምንካ ማቸረ ኤሳዮቴ” ጋይሰኮ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","የሱሰረ “ይና ኮናና እተረ ኬና ርንከስም Ꮊራ ገችታ ኤረንካ እ ይዳናንከረ እታ የካንታ ኬዛይቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ኮታ ቡር የሱስ ኩንጋየሮ ኮም ካምስን ዎርሰንካንታ ኬዛ የጄ። ዋልቃ ኤች ዎይንንም ኮርሴ። ዎንንባብከስ ክትካንታ ዎንድንግንዳ እምሶ አብ ፍጫር አይሶ በድ ሰጫ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","እስንን ሳንሰርድን አርፈንንከሳር ዎይንንታ አፍናርንካ ክትም የልድንደትም ከት ኦይታባብ ይንታ ፍክስንባብም ከትኬና ዎንንባብከዝደር ኦይቼ፥ ዎንንባብከስ ማቼ ክታ ፍክስንባብም ጉጵሰኮ አን ዉች ክትም ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ኮታዘንከረ አብ ይንታ ፍክስንባብም ኦይቼ፥ ዎንንባብከሰረ ጉጅሶ ክትመረ ዳቅልካ ጉጵሰኬ፥ ክትም ኦስንስሶ አን ዉች ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ታየረ አነታ ማክምስ ይንታ ፍክስንባብም ኦይቼ፥ ዎንባብከሰረ ጉጅሶ ክትመረ ድደርስሰኮ ኦስ ማል ክትም ዉችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ዎይንን ኮርተንታ ባበነረ፥ ይና Ꮊርስ ይቴ? አና ጉጅሶ እ ሶልምድን እስታ ይንችንም ኦይትቴ፥ Ꮊረንግርካ ክትም ቦንጅድባብ ማተረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ዎንንባብከስ ማቼ ክትም ሰድሰኮ ኮነረ ባእን ተይድባቤ Ꮊድከቴ ክትም ደይስተሮቴ! ባእነረ ዎካንታ ማተሬ! ክክ ጋየረኮ ዞርምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ዎይንን ኮረርሳን Ꮊምናርንካ ኦስ ጋስትዘን ዉችሰኮ ደይሰኬ። ይና ዎይንን ኮርስባብ “Ꮊስ ክት ይሶክ ኡርተራ? ");
INSERT INTO gyl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ኖ Ꮊድሶ ከትኬና ዎንንባብከስም ካይዝዴ፥ ዎይንን ኮርምሳን Ꮊምንም አብ ዎንንባብከስካንታ እምተሬ”። ዎርሰነረ ኮም ከታ ይ ኤሰርሳንደትካ፥ “ኮ ግንደንም Ꮊይ ተይᎺዳ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","የሱሰረ ከደር ሰድሶ፥ “ ‘ይና ሰይን ኤሄን ዎድባብከስ ቶችሳን ሰይንና፥ ኤሄንታ ፍክስንካንታ ዝግዝድንዳ ማቼ’ ጋይምሶ ጭል ማጻፍናር ጻፍምሳንደታ ቡልና Ꮊራርየረ? ");
INSERT INTO gyl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“ኮ ሰይንንታዘን ዋጅድባብ ሙደና ቁንጭምደ፥ ሰይንነረ ክታዘን ዋጅድባብ ሙደና ኢሳስታ ቤርንግንዳ ደይስምዴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ሙሴታ ህግንም ኤስዝድባብከ ቀሰንከስታ ገችን ባብከሰረ ኮም ካምስንከስንም ክት ኬዛንዳ ከታዘን ማትንተን ከታ ይ ኤሳንጎካ፥ ኮት ሳዓትንካ ክትም የድይ ካንታ ዝግዘኬ፥ ኬዛር ማቼ ዎርሰንም ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","የሱሰም ስክስት እምካንታ ኡርድን ሰጨም ዝግድ Ꮊቀኬ። ሮማ ፍጨን ቆልድባብታ ዎልቀንካንተከ፥ ገችንታ ኤረንታ ጎይናር እምካንታ፥ አነረ ክታ አፋርንካ ዉድን ኬዘንካ የድካንታ ዝገሮ Ꮊቀኬ። ኮካንተረ ጭልንባብከስም ካምሰኮ ጭርስሶ ሰድባብከስም ክደር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ጭርስሶ ሰድባብከሰረ፥ “ኤስስንባቦ! የና ዶፈንን የስ ከዝድንደትምከ የስ ኤስዝድንደትም ኮትኮግንደረ ሳብታ ጎግንም ዶፈንካ የስ ኤስዝድንደትም Ꮊየሰንተረ ባላካንታ ጋይሶ የስ ፍግዝዳክንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ዎንታ ህግንግንዳ ሮማ ባንችንካንታ ግራ ናክ ዝግዝዶ ዝግሳዮ?” ኩን ጋየረኮ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","የሱስ ማቼ ከታ ጩበንም ኤስሶ ኩን ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ይና ዋልቃ ሳንትም እካንታ ሰችከቴ። ዘን ዶቅድንዳ ማልክና Ꮊይሞክ ካሜ፥ ጻፈርሳንደረ ላምና Ꮊይተረ?” ከተረ “ቀሳርቴ” ጋይሶ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","የሱሰረ፥ “ኮናና ቀሳርተን ቀሳርካንታ፥ ሳብተን ሳብካንታ እምከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ኮካንታ ክት ኬዛንደትካ ዎርሰንታ እር የድይ ካንታ ማታከኬ፥ ክታከዘንታ ማስንካ በርእሰኮ ጫምን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ደእያርንካ አምንታ ካዬ ገይድባብ ሰዱቃዊያንንከሳርንካ ዋልቃ ዋልቀና የሱሰደር Ꮊድሰኮ ኦይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ኩነረ ጋይሰኬ፥ “ኤስስንባቦ! ‘ዋልቃ ኤች ማና እንችሶ ይንች አጣክዶቆ ደእሴ። ክታ እስመነና ኤተንንም እንችሶ ይንች አጣባብ’ ሙሳ ዎካንታ ህግ ማጻፍናር ጻፍቴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ይና፥ ኤች ዋልቃባብታ ታብዛ አⷝና ይንች Ꮊቀኬ፥ እርንባበረ ማና እንችሶ ይንች አጣክሳ ደእሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ቃስትምስነረ ኮትኮ ኤተንንም እንቼ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ጉጅሶ ማክምስነረ ኮትም ማስሴ፥ ይና ታብዘነረ ኮትኮግንዳ ኮትም ማስሰኮ ይንች አጣክዶቆ ደእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","በእንተዘን ኤተና ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ይና ታብዘና ማስሳንጎካ፥ ደእናርንካ አምንተናᎺይካ Ꮊይቶክ ማና ማዳ?” ");
INSERT INTO gyl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","የሱሰረ፥ ኮ ፍጫሙደንታ ይንችና እንጅደከ ይእደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ꮊድን ፍጨንዘን ዶቅካንተከ ደእያርንካ አምንተንም Ꮊፍ ዝግድባብከስ ማቸ እንቻየኬ፥ ይአየኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ከተረ ክታይንችንከስግንዳ ማድንኦል ኮታ ቡር ደአየኬ፥ ደእናርንከረ ከታ ይ አምሳንካንታ ሳብታ ይንቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ሙሳ Ꮊቀንታ እክመና ኖሄካ የድንካ ሰድሶ ጻፍሳን ፍክስምሶ ስገዳንደታር ጮይስም፥ አብራሀመታ ጮይስ፥ ይሳቀታ ጮይስ፥ ያይቆበታ ጮይስ ጋይሶ ደእስባብከስ አምድንደትም ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ሙደነረ ክትካንታ ሰንፔካ ከት ማድንካንታ፥ ኖ ሰንፔክንባብታ ሳብ ዳት ደእስባብከስታ ካዬ፥ ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ዋልቃ ዋልቃ ሙሴታ ህግንም ኤስዝድባብከሰረ፥ “ኤስስንባቦ! ኡርማ ኬዛዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ኮታ ቡር ዋልቃ ኤድ ዎራ ክትም ሙቅምካ ኦይስካንታ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ኮታ ቡር የሱስ፥ ኤድንከስ ክርስቶሰም Ꮊስግንደክ ዳዊተታ ይንቼ ክትም ጋይዳ? ");
INSERT INTO gyl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ꮊረታ ጋይሴ ዳዊት ይንታ የችናር ኩን ጋይቴ፥ ሳብ እስታ ጮይስን! ");
INSERT INTO gyl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“እታ የስታ ይምኤንባብከስም፥ “የስታ ዱትናር ሙክማባብ እ ማስተርን የለልታ፥ እስታ ምዝንዘን ዶእካ ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ይና ዳውት ክትም፥ “ጮይስዮ ጋይሶ ኤልድንካ Ꮊስግንድክ ክታ ይንች ማዳ?” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ዎርሰና ሙዳ ክትም ኤሰረሮ ከትዶቅድንካ ይንታ ካርንካ ጎርስምድባብከስም፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ቃልም አፍላ ቆበርሶ ኦንጋ ሶልምድባብከስ፥ ጋባ ካርዘን የና ኡርሞ Ꮊስረረ ጋይድንደትም ዝግድባብከዘንካ፥ ምክስ ኤሄናር ቦንችምሳን ጎንገንም ዝግድባብከስ፥ እችምካንተከ ዎጭምካንታ ኤለርሳን ካርዘነረ ቦንቻ ካርም ዝግድባብከዘንኬ ሙሴታ ህግንም ኤስዝድባብከዘንካ ካርስምከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ከተረ ማና ቡድነንከስታ ኤሄንም ካላ ማዝድባብከሰኬ፥ ሰድምካንታ ከታ ይንታ ምክስንም ቃልዝደኬ፥ ከትከነም ቦርሳንዳ ፍርዳ ካርዝዴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","የሱስ ጬክን ጋይሶ ክት ሰድንካ ቆልመንባብከስ ሳብታ ጭል ኤሄናር ከታ ይንታ እመንም ሳንሰርድንደታር ከት ኦይድንካ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ጉጅሰረ ዋልቃ ርካየንዳ ኤተን ቡድነና ቃስተን ባከነንም ኮታር ኮት ኦይድንካ ሰድሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","“ዶፈን የም ጋይድቴ፥ ናኮና ርካየንዳ ቡድነና ሙደንዘንከረ ስግስሶ እምቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ኬና ኤድንከስ ከት እምሳንዳ ይንታ ስጥመናርንካ ማድንካ፥ ናማቸ ኮት እምሳንዳ ይንታ ዞግናርንካ ዶቅድንደት ይንታ ገችንተንም ሙዳ እምቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ዋልቃ ዋልቀና ክታ ካርንካ ጎርስምድባብከስ ኮና ሳብታ ጭል ኤሄና፥ Ꮊስግንዳ ላቅምድንደሬ? እድምሳን ሰይንንከ እምምሳን እመንከስካ ሰክስቴ ጋየሮ ከዝምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","የሱሰረ “ኮና የ ሰድንዳ ሙዳ ሰይንና ሰይንዘን ከልምሳንዳ ዉልእማክዶቆ ነገዳክንዳ ሰጫ Ꮊዴ”። ");
INSERT INTO gyl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ከተረ “ኤስስንባቦ! ይና ኮና ሙዳ ማድንዳ Ꮊንተረ? ጉጅሰረ ኮና ማድንደታ ቃዉተና Ꮊረርየረ?” ጋይሶ ክትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","የሱሰረ “የ ኮተርተራክንግንዳ ካርስምከቴ! በድንከስ ‘ዎታ ክርስቶሶተ ጋይንተካ ጉጅሰረ፥ ሰጨና ቅንችቴ’ ጋየረኮ እስታ ላምካ Ꮊተረኬ፥ የታ ማቼ ከትም Ꮊይ ጎርስመቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ዳምንምኬ ዎርሰንታ አዉልንም የ ኤሰርሳንደትካ Ꮊይገቀቴ፥ ኮና እርምሶ ይም ዝግዝድንዴ፥ ማታጋካ ዳት በእንተና ኮታ ሳነካ ማታዬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ኮታዘንከረ የሱስ ዎርሰና ዎርሰዘን፥ ባንችነረ ባንችታዘን አምተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ፍጨንታ ሶይነረ አንድር ማተረ፥ ዳቅከ Ꮊዝምካ Ꮊክ Ꮊክ ካርዘን ማተረ፥ ጳስዝድን ሪየረ ኮትግንዳ ጭለዘን አንድር ቃዉታ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ኮና ሙዳ ማተርንደታ እር፥ ኤድንከስ የም የተረኬ፥ የም ዳይተረኬ፥ ፍርዳካንታ አይሁድንታ ምክስ ኤሄናርኬ ዞክና ኤሄናር የም አርችተረኬ፥ ባንችንከስተኬ ቆልድባብከስታ እር የም ተይ Ꮊተረኬ፥ ኮነረ ሙዳ እስታ ላምንካንታ የንዘን የልተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ኮነረ እጎካ የ ማርከርተርንግንዳ ኡርማ ጎግ የካንታ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ኮካንታ Ꮊራ ጋይሶንት ማስተራ ጋይንተካ እርምሶ የ ማጠርዳክንግንዳ ኮም የንታ ቡዳር ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","የንታ ይምኤንባብከሳርንካ Ꮊየነረ የም ዎይስካንተኬ ጋምካንታ ከደር ማታይንደትም ቃለከ ኤጨካ እታ የካንታ እምትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","የም አጭባብከስ፥ የንታ እስመንከስ፥ የንታ ሱሰንከስኬ የንታ ላኮይትንከስ ዎራ ነጋከክዶቆ ስክስት የም እምተሬ፥ የንታ ዋርንከረ ዋልቃ ዋልቀን ደይስተረኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","እንካ የ አሜንድንጎካ ኤድ ሙደንታ ባንግር ቦስምስባብ ማተረቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ኬዛርንካ ማቼ የንታ ማተንታ ዋርንካ ስጭ ዋልቃ ዎራ ካይዳክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ዛብሰቶ የንታ ዎእንተንካ ሰንፔንም የንታ አቅስተረቴ፥ ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ጉጅሰረ የሱስ “የሩሳሌም ካተመና ዳምንባብከስካ ቀንምስንካ የ ሰዳንደትካ፥ ካይንተና ኮታ ቅንችምሳንደትም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ኮትኮᎺይካ ይሁዳ ፍጨናር ዶቅድባብከስ ገቸንዘን አጥማ፥ ካተመናር ዶቆድባበረ ዋርንካ ከት ዉታ፥ ካተመንዘንካ ጎት ዶቅድባብከሰረ ፈንክ ካተመናር Ꮊይ አርዳ። ");
INSERT INTO gyl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","“ኮካንታ ጻፍምሳንዳ ሙዳ ቦድምድንግንዳ ኮና ደእካ ፋረድምድን ሰጬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ፍጨዘን አንድር ማጣ ማተረ፥ ኮ ዎርሰንታዘን ሳብታ ዋጭ Ꮊተሬ፥ ኮካንታ ኮት ለእንካ ማና ስርማባብካንተኬ አም ጋእዝድን እንደንንከስካንታ የኤ! ");
INSERT INTO gyl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ከታርንከረ በድንከስ ማሰካ ደእተረኬ፥ ኦስ ፍጫ አብንከሳረረ ዎእስምትዮ ተይምተረኬ፥ የሩሳሌም ካተመነረ አይሁድ ማታክባብከስታ ገችንታ ስለና ቦድምተርን የለልታ ከታ ዱትንታ ጎያር ሙክምሳንዳ ማተሬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","ጉጅሰረ የሱስ “Ꮊይዘን፥ አርፈንዘንኬ ቤዝታ ዘን ቃዉታ ማተሬ፥ ባሃርንተኬ ዞገንተካ ኡፍስንዘንካ አምሳንዳ፥ ፍጨዘን ዶቅድባብ ዎርሰንከስ ማጠርተረኬ፥ አዉልምተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ጭለንታ ዎልቀነረ ጭጭድንካንታ፥ ኤድና ጳስካ ፍጫሙደንዘን Ꮊራ Ꮊተራዳቶ ጋየረኮ ካርስካ ገቅተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ኮትᎺይካ ኤድ ይንች ዎልቀኬ አንድር ቦንቸካ ኡፔካ Ꮊድንካ ክትም ሰትረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","የተረ ኬና ሪንከስ ቦድምድንካ የንታ አቅንተና ቅንችምሳንካንታ ጋዝድን ጋይሰቶ ዎእከቴ፥ የንታ ማተንም ፈስ ጨዳ ጬክሳ ይይሰቶ ሰድከቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ኮታዘንከረ የሱስ፥ Ꮊቃ በለስንምኬ አብ Ꮊቀንከስም ሰድከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ግዝደና ከታ ፉርድንካ ሰድሰቶ ኮታይካ Ꮊስንና የልሳንደትም የንታ ማታርንካ የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ኮትኮግንደረ ኬና ርንከስ ሙዳ ቦድምድንካ ሰድሰቶ ሳብታ ባንችምና ቅንችምሳንደትም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ዶፈን እታ የም ጋይድቴ፥ ኮና ሙዳ ቦድምተርን የለልታ ኮና አጥርና ስገዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ጭለኬ ፍጨካ ስገተረኬ፥ እስታ ቃለና ማቼ ስገዳክዬ” ኩንጋየሮ ኮም ካምስንም ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","ኮታዘንከረ የሱስ፥ “ይና እችምተኬ ዎጭምታ በድምካ ጎዝካ የንታ ሪን ይጭኬ ኮ ፍጫሙደንዘን ዶቅንተታ ማጥርካ የንታ ቡደና አንቸርዳክንግንደኬ አና ሰጨና ጭካግንዳ የ ገቅራክናና የንዘን የልዳክንግንዳ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ና ኮና ሰጨና ፍጨዘን ዶቅድባብ ሙደንዘን ጭካግንዳ የልተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ኮካንታ Ꮊድን ሙደንዘንካ የ ሱርተርንግንደከ ኤድ ይንችንታ እሪ የ ዎእተርንግንዳ ሙዳᎺይካ ዳቅሶ ምክስከቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","የሱሰረ ሰጨንካ ሰጨንካ ሳብታ ጭል ኤሄናር ኤስሰሮ ሶይት ማቼ ደብረዝይት ጋይምድን ገቸንዘን ዉትሶ ገጅድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ዎርሰነረ ሙዳ የሱሰም ኤስርካንታ ሰጭመናር ሳብታ ጭል ኤሄናር Ꮊድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ኮትኮᎺይካ ፋስጋ ጋየርድንዳ ባልስ ባአልን የልታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ቀሰንከስታ ገችንባብከስከ ሙሴታ ህግንም ኤስዝድባብከስ ዎርሰንም ከታ ይ ጳሳንካንታ Ꮊስ ይሰኮ የሱሰም ከታ ይ ደይዝዳናንከረ ክታ ባዝደካ ከዝምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ታመከ ቃስተንንከስካ ክክን ፋይድምስባብ አስቆሮንት ፍጨናርንክንባብ ይሁዳ ጋይምስባባረ ሰጣን አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ኮካንታ ይሁደረ ቀሰንከስም ገችዝድባብከዝደርከ ሳብታ ጭል ኤሄንም ካርስካንታ ዶርምስባብከዝደር አይሶ የሱሰም Ꮊስግንደካ ስክስትዮ ከትካንታ ይ እምድንደትም ከትካ ኬዝምሴ ");
INSERT INTO gyl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ከተረ ኮካ ጉርምሰኮ ብራ እምካንታ ኤእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ኖየረ ኬዘንካ ኤእሶ የሱሰም ስክስት እምካንታ ዎርሳ Ꮊፈርዳክን ከትካንታ ኡርድን ሰጨም ካርዝድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ኮታዘንከረ ፋስገታ ቆል ማቸርድንዳ ባልስ ባአልን የልሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","የሱሰረ “ፋስገንታ ሶይት እችምን ዎ እችተርንግንዳ አይሰቶ ዎካንታ ግግስከቴ” ጋይሶ ጴጥሮስምከ ዮሀንስምካ እርናና ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ከተረ “Ꮊብር ዎ ግግሳባበስ ዝግዳ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","የሱሰረ ከትም፥ “ይና ካተመናር የ አርድንካ ሎቃ ዳህ ባልስባብ ዋልቃ ኤች የም Ꮊፍተሬ፥ ክት አርድን ኤሄናር የለልታ ክትም ጎርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ኤሄንባብካንታ ‘ኤስስንባብና እስታ ካርንካ ጎርስምድባብከስካ ክክን ፋስገንታ ሶይት እችምን እ እጅድንግንዳ ሶችንከስ አርድን ካርና Ꮊምነረ?’ የስም ጋይዴ ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ኖየረ ኤሄንታዘን ዎደርሳን ኤሄናር ዶቅድን ታከርምሶ ግግምሳን ዳልግ ካሪ የም ሰችተረ፥ ኮታር ግግስከቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ከተረ አይሰኮ ገታ የሱስ ጋይሳንግንዳ ማችንካ Ꮊፍሰኬ፥ ፋስገነረ ኮታር ግክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ሳዓትና የልሳንደትካ የሱስ ኦይትምስባብከስካ ክክን እችምካንታ ዶቅሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ኮታዘንከረ “ማጠንም እ ተይተርንደታ እርምሶ ኮትኮ ፋስገንም የንካ ክክን እችካንታ አንድር አንገርድ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","እታ የም ጋይድቴ ሳብ ባንችማር ኮትኮታ ቡልና ቦድምተርን የለልታ ኮትኮ ፋስገንም ቃስትምስ እቻይቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ኡፍተንም ተይሶ ይ ጋለቻን ቡር፥ “ይኤቴ የታ ሙደና ኮታርንካ ካስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","እታ የም ጋይድቴ፥ ይና ኮዘንካ የድሶ ሳብታ ባንችምና Ꮊተርን የለልታ ኮትኮ ዎይን ዎጭምን ዎጫይቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ባልስንም አምስሶ ጋለቼ፥ አስትዮ ከትም እምሶ “ኮና የካንታ እምምድንዳ እስታ ዋሄ፥ ናኮና እም የም ገቀርስዝድንዳ ማስከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ኮትኮግንደረ ሶይት እችምንታ ቡር ኡፍተንም አምስሶ “ኮና ኡፍተናርንካ የካንታ ዉልእምድንዳ እስታ ማቀስንካ ዎእድንዳ ክላ ጫቄ። ");
INSERT INTO gyl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ኬዛርንካ ማቼ፥ ስክስት እም እምድባብ ኤችንታ አንና እችምናር እንካ ክክኔ። ");
INSERT INTO gyl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ኤድ ይንችና እርምሶ ሳብ ጋይሳንደትግንዳ ደእዴ፥ ኬዛርንካ ማቸ ክትም ስክስት እምድባብ ክትኮ ኤችንም የኤ!” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ከተረ ይንታ ዎክያርንካ ኮም ይተርባብ Ꮊይ ማተርናንከረ ክክ ክክ ኦይስ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ጉጅሰረ ከታ ዎክያርንካ Ꮊይ ስገዳናንከረ ክክ ክክ ቤርም የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","የሱሰረ ኮ ፍጫሙደንታ ባንችንከስ ከታ ይንታ ዎርሰንከስም ዎልቀካ ቆልደኬ፥ ከታዘን ገችዝድባብከሰረ ኡርማ ፍግዝድባብከሰከ ጋይምሰኮ ኤልም ዝግደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","የታ ማቼ ኩን Ꮊይማተቴ፥ ኬዛርንካ ማቼ የንታ ዋርንካ አንድር ማችባብ ቶክም ክት ማታ፥ ኤድም ቆልድባብ ይ ማቼረ ፍክስንባብግንዳ ክት ማታ። ");
INSERT INTO gyl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","የ ሰድኔ! እችምንዘን ዶቅስባብዘንከ ዎእሶ እችዝድባብዘንካ Ꮊይ ስገዳ? እችምንዘን ዶቅስባብ ካዮ? እታ ማቼ የንታ ዎክያር እ ዶቅድንዳ ዋልቃ ፍክስባብግንድቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“የተረ እዘንካ ፋስማከትዶቆ እስታ ማጠናይካ እንካ ክክን ዛብሶ ዎእስባብከሰቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ኮካንታ እባብ እም ዶርሳንግንዳ እተረ ጉጅስቶ እስታ ባንችምናር የም ዶርትቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ኮነረ እስታ ባንችምናር እስታ እችምናርንካ የ እጅድንግንደኬ የ ዎጭድንግንዳ አነረ ቦንቻ ጎንገንዘን ዶቅሰቶ ታመኬ ቃስተን እስራኤል ገርነንከዘን የ ፋረተርንግንዴ”። ");
INSERT INTO gyl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ኮታዘንከረ የሱስ “ስምኦንዮ ስምኦንዮ! ይና ሰጣን የም ዘርግምግንዳ Ꮊችካንታ ሳብደር ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","እታ ማቼ የስታ አሜንና የዘንካ ካይዳክንግንዳ የስኦላር ሳብደር ምክሳቴ፥ የነረ የስ ማቻንᎺይካ የስታ እስመንከስም ዳቅስካ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ስምኦነረ “ጮይስዮ፥ እታ የስካ ክክን ዞክርካንተከ ደእካንተረ ግግምትቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","የሱሰረ “ጴጥሮሶ! ታካ ባቻ ቅቃክናና እታ ክትም ኤሳይቴ ጋይሰዮ ማከንዱት እም ካተረየ፥ እታ የስም ጋይድቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ኮታዘንከረ የሱስ ይንታካርንካ ጎርስምድባብከስም “ሱልፋ፥ ብራ የደርድን ቦርሰከ ጫማካይሳ እ የም ኦይቻንደትካ የም ዞገርሳን ር ዶቅዶ?” ጋይሶ ከትም ኦይሴ። “ከተረ Ꮊረነረ ዎም ዞገራክዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","የሱሰረ ታ ማቸ ሱልፋ፥ ቦርሰረ ዶቅድባብ ኤድ የዳ፥ ማሳ ካያንባበረ አፍለን ይንታ ሰንሶ ሰንት ክት የዳ። ");
INSERT INTO gyl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","“እታ የም ጋይድቴ ባችንባብከስካ ክክን ፋይድምሴ ጋይምሶ ጭል ማጻፍናር ጻፍምሳንዳ እንካ ቦድም ዝግዝዴ፥ እጎካ ጻፍምሳንዳ ቦድምድንዳ ታ የልቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ክታ ካርንካ ጎርስምድባብከሰረ፥ “ጮይስዮ፥ ቃስተን ማሰንከስ ዶቅደኬ” ክደር ጋይሰኬ። የሱሰረ “ኬና ማተረከ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","የሱስ ይንታ መጠንግንዳ ዉትሶ ኦስ ደብረዝይት ገቸንዘን አይሴ። ክታ ካርንካ ጎርስምድባብከሰረ ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ኮታረረ ከት የልሳንደትካ፥ የሱስ “ጰጭምንታዋር የ አርተራክንግንዳ ምክስከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ከታዘንከረ ሰይንታ አቅና የልድንከካ ጎተርሶ ጉምፈርስደትከ ምግዝድዮ። ");
INSERT INTO gyl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","እባቦ “የስታ ጋይታ ማቼ ኮትኮ ማጠንታ ኡፍተን እዘንካ ተይካ፥ ኬዛርንካ ማቼ እስታ ጋይተካ ማታክዶቆ የስታ ጋይተና ቦድማ” ኩነረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ኮታይካ ክታይንች ጭለዘንካ መያ ማትሶ ክትም ዳቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","አንድር ማጥርካ ዳቅስሶ ምግዝድᎺቄ። ዘነንክታርንከረ ማቀስግንደና ኤርማ ፍጨዘን ጮንግድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ምክስንዘንከረ አምሶ ይንታካርንካ ጎርስምድባብከዝደር Ꮊዴ፥ ከተረ ሞርእዘንካ አምሳንዳ ራትሶ ከትዶቅድንካ ከትም Ꮊፍሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Ꮊረተንት ራዳ? ጰጨንታዋር የ አርተራክንግንዳ አምሴቶ ምክስከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","የሱስ አክ ኬዘሮ ክት ዶቅድንካ፥ በድ ኤድንከስ Ꮊደኬ፥ ታመከ ቃስተን የሱሰም ጎርስምድባብከሳርንካ ዋልቃባብና ይሁዳ ጋይምስባብ ኤችና ከትም ጎርሰሮ Ꮊቄ። የሱሰም ሶንቅና ካንታ እጵን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","የሱስ ማቼ “ይሁዶ! ኤድ ይንችንም ሶንቅነካ ስክስት እምተራ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","የሱሰታ ካርንካ ጎርስምድባብከሰረ ይምድንደትም ሰድሰኮ “ጮይስዮ! ማሰካ ከትም ተችቶሮቶ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ከታርንከረ ዋልቀና ቀሰንከስም ገችዝድባብታ ፍክስንባብም ፋክሶ ክታ ምዝ ቃምን ተቼ። ");
INSERT INTO gyl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","የሱስ ማቼ፥ “ዛእካ! ኮግንዳ ር Ꮊይ ይዬ” ጋይሴ፥ ኤችንተረ ቃምን Ꮊጭሶ ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ኮታዘንከረ የሱስ ክትም የድካንታ Ꮊድባብከስም ቀሰንከስም ገችዝድባብም፥ ሳብታ ጭል ኤሄንታ ካርስንባብከዘን ዶርምስባብከስምኬ ጋልተንከስም “ፋንገንከስም የ የድንደትግንዳ ማሰከ ጉፈካ የድሰቶ Ꮊደቴ? ");
INSERT INTO gyl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ሰጨን ሰጨንካ ሳብታ ጭል ኤሄናር የንካ ክክን እ Ꮊቃንደትካ የታ እም የዳከቴ። ኮና ማቸ ኡምና ባንችምሳንዳ የንታ ሰጬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ኮታ ቡር የሱሰም የድሰኮ ተይ አይሰኬ፥ ቀሰንከስም ገችዝድባብታ ጋስናር ክትም አርችሰኬ፥ ጴጥሮሰረ ጎትካ ክትም ጎርስምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ኤድንከስ ቀሰንከስም ገችዝድባብታ ጋስናር ኖሀ ኦስሰኮ ከትዶቅድንካ፥ ጴጥሮሰረ ከትካ ክክን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ዋልቃ ኤተን ፍክስንዳ ጴጥሮስ ኖሄንታ ባንግር ክት ዶቅድንካ ፍስሳ ክትም ሰድሶ፥ “ኮና ኤችና የሱሰካ ክክን Ꮊቄ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ጴጥሮስ ማቼ፥ “የና ኤተኖ! እታ ክትም ኤሳይቴ” ጋይሶ ካጄ። ");
INSERT INTO gyl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ቶክም ዶቅሳን ቡር ዋልቃ አብ ኤች ክትም ሰድሶ “የነረ ከታርንካ ዋልቀነዬ!” ክትም ጋይሴ። ጴጥሮስ ማቼ “የና ኤችኖ! እታ ካይቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ዋልቃ ሳዓት ማታባብ ዶቅሳን ቡር አብ ኤቸረ “ኮና ኤችና ገሊላ ፍጫ ኤች ክት ማቻንካንታ ዶፈንካ የሱሰካ ክክን ኖᎺቄ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ጴጥሮስ ማቼ፥ “የና ኤችኖ የስ ጋይድባብም እታ ኤስክቴ” ጋይሴ። ኮም ክት ከዝትዮ በይሳክናና ባቻ ቅቅሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ጮይስ የሱሰረ ዋልን ጋይሶ ጴጥሮሰም ሰጄ፥ ጴጥሮሰረ፥ “ታካ ባቻ ቅቃክናና ማከን ዱት የና እም ካተረዬ” ጋይሶ ጮይስ ኬዛን ቃለና ክትም ኤልቅን ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ጴጥሮሰረ ኦስ ማል ዉትሶ ቡዳርንካ ኤፍሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","የሱሰም የድሶ ካርሰሮ Ꮊቃን ኤድንከሰረ Ꮊልተርካ ክታዘን ኬዘረኮ ጉጵነረ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","አፍን ክታ ኦችሰኮ፥ “ይና ሳብዘንካ ኤሰርሶ ኬዝድባብ የስ ማቼ የስም ጉጵስባብ Ꮊይራ?” ጋይሰኮ ክትም ኦይሰሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","አበረ በድ የከረኮ ክታዘን ኬዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ፍጨና ሰጫን ቡር ዎርሰንታ ጋልተንከስ፥ ቄሰንከስም ገችዝድባብከስኬ ሙሴታ ህግን ኤስዝድባብከስካ ሳንምሰኮ የሱሰመረ ፍርደንባብከዝደር ተይᎺደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ከተረ፥ “የና አቅስንባብ ክርስቶስዮ? ይና ዎም የስ ኬዝኔ” ክትም ጋይሰኬ። የሱሰረ፥ “እ የም ኬዘረ እም አመናየቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“እ የም ኦይሰረ ማሳየቴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ኬዛርንካ ማቼ ታይንዘንካ የችሶ ኤድ ይንችና አንድር ሳብንታ ምዝንዘን ዶቅተሬ” ኩን ኬደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ኮትᎺይካ ሙደነረ “ኮናና የና ሳብታ ይንቾ?” ክትም ጋይሰኬ። የሱሰረ “እስታ ማትንተንም የታ ኬዘቴ” ኬደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ከተረ “ይና ኮዘንካ አብ Ꮊራ ማርካ ዎም ዝግዝዳ? ይና ገታ ክታ አድምናርንካ ዎታ ዎንታ ማታርንካ ኤሰርቶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ኮታር ሳንምስባብ ኤድንከስ ሙዳ አምሰኮ የሱሰም ኦስ ጵላጦሰደር ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ኩነረ ጋየረኮ ክትም ካሰስ የጀኬ። “ኮና ኤችና ዎንታ ዎርሰንም ኮተርዝድንካ፥ ሮማ ባንችንካንታ ግራ ናግዳክንግንዳ ማርድንካ፥ ጉጅሰረ እታ አቅስንባብ ክርስቶስ ባንችቴ ክት ጋይድንካ Ꮊፍሶቴ”። ");
INSERT INTO gyl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ጵላጦሰረ “የና አይሁድንከስታ ባንቾ?” ጋይሶ የሱሰም ኦይሴ። “የሱሰረ ይዬ የስ ጋይሳንግንዴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ኮታዘንከረ ጵላጦስ ቀሰንከስም ገችዝድባብከስምኬ ዎርሰንካንታ “እታ ኮ ኤችንታ ዘን Ꮊረነረ ባች ክታዘንካ Ꮊፋክቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ኬታ ማቼ “ኮና ኤችና ገሊላ ፍጫርንካ የድሶ ካሪ የለልታ ይሁዳ ፍጨናረረ ሙዳ ይንታ ኤስስንካ ኤድም አዉልዝዴ” ጋየረኮ ዳቅስሶ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ጵላጦሰረ ኮም ኤሰርሶ “ኮና ገሊላ ፍጫ ኤዶ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","የሱስ ሄሮድስ ገችዝድንደታርንካ Ꮊድባብ ክታ ማትንተንም ጵላጦስ ኤስሶ ሄሮድስ ኮትᎺይካ የሩሳሌም ካተመናር ክት ዶቅድንካንታ ኦስ ክደር ክትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ሄሮድሰረ የሱሰም በድᎺይካ ሰድንካንታ ዝግድ Ꮊቃንካንታ የሱሰም ሰድንተንካ በድ ጉርምሴ፥ ክትጎካ ኤሰረሮ ይ Ꮊቃንጎካ የሱስ አታ ርም ክት ፍግዝድንካ ሰድንካንታ ጉርምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ሄሮድሰረ የሱሰም በድ ኦይስነረ ኦይሴ፥ ኖ ማቼ Ꮊረነረ ማሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ቄሰንከስም ገችዝድባብከስኬ ሙሴታ ህግን ኤስዝድባብከስ ዋር ዎእሰኮ ክትም ካሰዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ሄሮድሰረ ፖልስንከስካ ክክን ክትም ቶችሰኬ፥ Ꮊልተርከረ ክታዘን ኬዘኬ፥ ቦንችምሳን አፍለረ ክትም ቆፍስሶ ኦስ ጵላጦስደር ማስሶ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ሄሮድስከ ጵላጦሰካ ኮትኮ ሰጨንታ እር ክክ ተችይ Ꮊቀኬ፥ ኮታይካ ማቼ ክክ ሱስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ጵላጦሰረ ቄሰንከስም ገችዝድባብም፥ አይሁድንከስም ቆልድባብከስምኬ ዎርሰንም የካ ሳንስሶ፥ ");
INSERT INTO gyl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“ኮና ኤችና ዎርሰን ዳቅልታ አምስዝዴ ጋይሰቶ ተይ Ꮊተትናና፥ እተረ የንታ እር ኦይስስቶ የ ክትም ካሰሳንግንዳ ዋልቀረ ዳቀልስ ክታዘን Ꮊፋክቴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ጉጅሰረ ሄሮድስ ኮትኮግንዳ Ꮊረነረ ክታዘን ይ Ꮊፋክንካንታ ፈንክ ዎንደር ክትም ማስቴ፥ የ ሰድንግንዳ ኮና ኤችና ደእካንታ ክትም የልዝድንደትም Ꮊረርየረ ፍክሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ኮካንታ ክትም Ꮊርድስቶ ቡልድቴ” ኩነረ ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ኮም ክት ጋይሳንዳ ፋስጋ ባአልንካ ዞከርስባብከሳርንካ ዋልቃባብ ከትካንታ ቡልም ዝግዝድንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ዎርሰነረ ሙዳ ዋልቃትቸካ “ኮ ኤችንም ኦስ ደይስካ! ባርባንም ዎካንታ ቡልካ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ባርባነረ ካተመናር አዉላ አምስስካ ኤድም ደይስሶ ዞከርስባብ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ጵላጦሰረ የሱሰም ቡልካንታ ይ ዝግዛንኦል አነታ ከደር ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ከታ ማቼ፥ “ክትም ሮካ! ሮካ!” ጋየረኮ ፍብድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ጵላጦሰረ ማክምስ ዱት “Ꮊረተረ? ኮና ኤችና Ꮊራር ክት ፍክሳንዳ ባች ዶቅዳ? ደእካንታ ክትም የልዝድንደትም Ꮊረነረ ባች እታ ክታዘን Ꮊፋክቴ፥ ኮካንታ Ꮊርድስቶ ክትም ቡልድቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ኬታ ማቼ ኡፍስን ይንታ ጬክሳ ይሰኮ ክት ሮከርድንግንዳ ዳቅስሶ ክትም ምክሰኬ፥ ፍፍሰረ ጋምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ኮካንታ ጵላጦስ ከት ኦይሳንደና ቦድምድንግንዳ ጋይሶ ክታዘን ፋረጄ። ");
INSERT INTO gyl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ዎርሰንም ባችታ አምስሳንካንተከ ኤድም ደይስሶ ዞከርስባብም ከትካንታ ቡልምድንግንዳ ከት ምክስባብ ባርባንም ከትካንታ ቡልሴ፥ የሱሰም ማቼ ከታ ዝግመትንግንዳ ስክስት ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","የሱሰመረ የድሰኮ ከት አይድንካ ስምኦን ጋይምስባብ ቀረና ፍጫ ኤች ካተማ ማታክን ፍጫርንካ Ꮊድንካ የድሰኮ ማዝቀልን ክትም ባልስሶ የሱሰታ ካርንካ ክት አይድንግንዳ ክት ሶልማክናና ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","በድ ዎርሰንከሰረ ኦንገዝን ይንታ ጎደረኮ ክትካንታ ኤብድን ማነንከሰረ የሱሰታ ቡርጎካ ጎርስምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","የሱስ ማቼ ፈንክ ከደር ዋልን ጋይሶ “የታ የሩሳሌማር ማነንከሶ፥ የንታ ማታካንተኬ የንታ ይንችንካንታ ኤፍከት ዳት እካንታ Ꮊይ ኤፈቴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ይና ‘ሴካ ማችባብከስ፥ አጣክን ሳቅምንከስኬ፥ ጋእሳክን አምንከሰረ ጭለኬ’ የ ጋይድን ሰጫ Ꮊተሬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ኮትኮᎺይከረ “ገቼንከስም ‘ዎንዘን ይፍከቴ’ ‘ደንንከስመሬ፥ ዎም አችከቴ’ ጋይተረኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“ይና Ꮊቀን ጋንድንዘን ኩን ከት ይድንዳ ማቼ፥ Ꮊቀን ዎቸንዘን Ꮊስግንደክ ይተራ?” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ኮታዘንከረ ክትካ ክክን ከት ደእድንግንዳ ቃስተን አብ ባችንባብከስም ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ራስቅል ጋይምሳን ካርዘን ከታ ይ የልሳንደትካ ክትም ሮክሰኬ፥ ባችንባብከስመረ ዋልቃባብም ክታ ምዝንዘን፥ ዋልቃባብመረ ክታ ከችንዘን ኬትም ሮክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","የሱሰረ፥ “እባቦ! ከታ ይ ይድንደትም ኤሳየኬ ነጋ ከትም ጋይካ” ጋይሴ። ዳምንባብከስ ክታ አፍለንም እጨካ ካስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ዎርሰነረ ዎእሰኮ ሰደሮ Ꮊቀኬ። አይሁድንከስም ገችዝድባብከሰረ “አብንከስም አቅሴ ሳብካ እድምስባብና አቅስንባብ ክርስቶስ ይ ማቼ፥ ይና ይንታ ማተነረ ክት አቅሳ!” ጋየረኮ Ꮊልተርካ ክታዘን ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ዳምንባብከሰረ Ꮊድሰኮ Ꮊልተርካ ክታዘን ኬዘረኮ፥ ጫቅምድንደትም ዎይንን ክትካንታ እምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“ይና የና አይሁድንከስታ ባንች የስ ማቼ የስታ ማተን አቅስካ” ጋየሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ክታ ቃደንታ ዘርመርጎካ ማዝቀልንዘን “ኮና አይሁድንከስታ ባንቼ” ጋይድን ጻፍምሳንደትም ዎጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ሮከርስባብ ባችንባብከሳርንካ ዋልቃባብ “የና አቅስንባብ ክርስቶስ ካያ? ይና፥ የስታ ማተነረ ዎመረ አቅስካ” ጋየሮ ክትም የክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ቃስትምስ ባችንባብና ማቼ “ክክ ካምድን ፍርደም ተያዶቅደዮ ቦድሶ ሳብም ጳሳያ? ");
INSERT INTO gyl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ዎታ ዎ ይሳን ሪንታ ዋጭ ዎ ተያዶቅድንካንታ ዎም ዝግዝድን ፍርድምዘኖቴ፥ ኮና ኤችና ማቼ ዋልቀረ ዳቅል ሪ ይያክዬ” ኩንጋየሮ ክትም ዋጬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ጉጅሰረ “የሱሶ! የስታ ባንችምንካ የስ Ꮊዳንደትካ እም ገቀርካ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","የሱሰረ “እታ ዶፈን የስም ጋይድቴ፥ ታካ እንካ ክክን ገነታር ማተረዬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ኮነረ ይይምሳንዳ Ꮊየካ ላ ሳዓት ማታባብዘን፥ ሳክላ ሳዓት የለልተረ ፍጫሙደንዘን ኡም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ꮊይነረ ኡምሴ። ሳብታ ጭል ኤሄናር ስፍስንደና Ꮊእሶ ቃስቴንካርዘን ፋስምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","የሱሰረ አንድር ኡፍስካ ፍፍሶ፥ “እባቦ! እስታ ሰንፔንም የስታ አንናር እምድቴ!” ጋይሴ፥ ኮመረ ጋይሶ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ፖልስንከስም ክድባበረ ይምሳንደት ርን ሰድሶ “ኮና ኤችና ዶፈን ጭል Ꮊቄ” ጋይሶ ሳብም ጋለቼ። ");
INSERT INTO gyl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ኮትኮመረ ሰድንካንታ ካርንዘን ሳንምሶ Ꮊቅባብ ኤድንከስ ሙዳ ይይምሳን ርን ከታ ሰዳንደትካ ሞርእካ ይንታ ኦንገዝን ጎደረኮ ኤር ማቸኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ኬዛርንካ ማቼ የሱሰም ኤዝድባብከስ ሙደና ኮትኮግንደረ ገሊላ ፍጨናርንካ የድሶ ክትም ጎርስምስባብከስ ማነና ኮም ሰደረኮ ጎትካ ዎእሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","አይሁድንታ ካተመናር ዶቅድባብ ቡጫ ጋልተንከስም ዞርድባብ ዋልቃ ዮሰፍ ጋይምድባብ Ꮊልስማ ማችባብ ጭል ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ኮና ኤችና ቡጫጋልተንከስታ ዞረምናርከ ከታ ይተናር ከትካ ክክን ኖ ማታክባብ Ꮊቄ። ኖየረ አርማትያስ ጋይምድን አይሁድንከስታ ካተመናርንካ ይ ማቻንካንታ ሳብታ ባንችምንታ Ꮊድንተን ካርዝድ ኖ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ኖ ኮና ኤችነረ ጵላጦስ ገችዝድን ይሁዳ ካተመናር አይሶ የሱሰታ ለይስንም ክትካንታ እምምድንግንዳ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ዱካ ክትም ጋይሳንደትካ ለይስንም Ꮊንችሶ ኡርማ ዱክ አፍለካ አክሴ፥ ሰይንም ቆቅሶ አክ ኡርሰርሳን Ꮊየነረ ዱከራክን ካርዘን ዱክሴ። ");
INSERT INTO gyl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ናኮና ሰጨነረ አይሁድንታ Ꮊዉስ ሰጨና የልሳንካንታ ኤድ ይንታ ር ግግዝድን ሰጫ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ገሊላ ፍጨናርንካ የድሶ የሱሰካ ክክን Ꮊድባብ ማነንከሰረ ጎርስምሰኮ ዱክንም ሰጀኬ፥ ክታ ለይስን Ꮊስግንዳ ክት ዱክሳናንከረ ሰጀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ዋርንከረ ይንታ Ꮊዉስ ኤሄናር ማትሰኮ ዎዝድንደትምከ ሳየርድንደትም ግግሰኬ፥ ሙሴታ ህግና ክድንደትግንዳ አይሁድንታ Ꮊዉስ ሰጨንካ ኡክንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ሳምንትንታ እሪ ሰጭ ማነንከስ ከታ ይ ግግሳን ዎዝድንደትም የድሰኮ ዛማ ሰጭመናር ክትም ዱከርሳንደታር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ሰይንነረ ዱክንታ ፍልተንዘንካ ቡከልስንካ Ꮊፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ዱክናር አርድሰኮ ጮይስ የሱሰታ ዋሄንም Ꮊፋከኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ኮትኮ ሪይንካ በርኤረኮ ከትዶቅድንካ አንድር ሮጵድንደትም አፍላ ቆበርስባብ ቃስተን ኤድ ከት ገቅራክናና ላማር ከታ ዎእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ማነንከሰረ አንድር ጳስሰኮ ባለን ይንታ ይርክሳ ይሰኮ ከትዶቅድንካ፥ ኤድንከስ “አፈካ ማችባብም Ꮊረተንት ደእስባብከስታ ዎክያር ዝግዳ? ");
INSERT INTO gyl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ኖ አምቴ፥ ካሪ ካዬ፥ ጉጅሶ ገሊላ ፍጨናር ይ Ꮊቃንደትካ Ꮊስ የም ክት ጋይሳናከረ ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘ኤድ ይንችና ጎመንባብከስታ አንያር ስግምሶ እምምካንታ፥ ሮክርካንተከ ማክምስ ሰጨንካ አምካንታ ዝግዝዴ’ የንደር ጋየሮ Ꮊቄ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ማነንከሰረ ኮት ሳዓትንካ የሱሰታ ቃለንም ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ከተረ ዱክ ካርናርንካ ማትሰኮ ኮም ሙዳ ርን ታመከ ዋልቀንከስካንተከ ነግድባብ ሙደንካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ኮመረ ኦይትምስባብከስካንታ ከዝባብከሰረ መግደላ ፍጨናርንካ Ꮊዳንዳ ማራማ፥ ዮሀናኬ፥ ያይቆበታ እንደን ማራመካ ከትካ ክክን Ꮊቅባብ አብ ማነንከሰረ ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ከታ ማቼ ማነንከስ ኬዝድንዳ ዛዝርም ከደር ካምሳንካንታ ከትም አሜናከኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ጴጥሮስ ማቼ አምትዮ ኦስ ዱክንደር ዞጄ፥ ኮታር የልሶ ይርክን ጋይሶ ክት ሰድንካ አፍለና Ꮊክ ዶቅድንካ ሰዴ፥ ይይምሳን ሪንካ በርኤሮ ይንታ ኤሪ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ኮትኮᎺይካ የሱሰም ጎርስምድባብከሳርንካ ቃስተንና፥ የሩሳሌም ካተመንዘንካ ማከን ሳዓት ጎግ ማታባብ ጎተርድንዳ ኤማሁስ ጋይምድን ሞረናር አይዘን ዶቅደኮ፥ ");
INSERT INTO gyl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ከታ ይይምሳን ሪ ሙደንታ ክክ ክክ ኬዝመሮ Ꮊቀኬ ");
INSERT INTO gyl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ከዝመረኮ ክክ ከት ዞርምድንካ የሱስ ይንታ ማታርንካ ከደር Ꮊድሶ ከትካ ክክን አይ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ኬዛርንካ ማቼ ክትም ከት ኤዝዳክንግንዳ ከትም ኡልምስንካ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ኖየረ “አየረቶ ጎግንዘን ክክ ክክ ኮም የ ኬዝምድንዳ Ꮊረርየረ?” ከትም ጋይሴ። ከተረ ሞርእካ ገቅሰኮ ዎእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ከታርንካ ዋልቀና፥ ቃለዮጳ ጋይምስባብ “ከትኬና ሰጨናር የሩሳሌም ካተመናር ይምሳንደት ርም የና ኤዝዳክባብ፥ የና የስት ዶቅድባብ ፍጨንካንታ ሶችዮ?” ጋይንትካ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","የሱሰረ “ይይምሳን ርና Ꮊረርየረ?” ከትም ጋይሴ። ከተረ ናዝረት ፍጨናርንክንባብ የሱስጎኬ! ኖየረ “ሳብተኬ ኤድ ሙደንታ እሪ ይንታ ፍክስንኬ ይንታ ኬዘንካ ዳቅማ ሳብዘንካ ኤስርሶ ኬዝድባቤ። ");
INSERT INTO gyl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ክትመረ ቀሰንከስም ገችዝድባብ ከስከ ዎንታ ማታ ቆልስባብከስ ደእ ፍርደንካንታ ስክስተረ እምሰክ፥ አነረ ክትም ሮክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ዎታ ማቼ እስራኤል ዎርሰን ቆትይ ተይተረ ጋይሶቶ ጉርም ዎ ይሳንዳ ክትም ዶቆ፥ ማታጋካ ዳት ኮና ማችንካ ታካ ማክምስ ሰጬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","አነረ ዎንታ ዎክያርንካ ዋልቃ ዋልቃ ማነንከስ ዎም በርእሰኬ፥ ከተረ ሰጭመናር ዱከርሳንደታር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ኬዛርንካ ማቼ ለይስን ክታ Ꮊፋከክ ዶቆ Ꮊደኬ። ‘ክት ሰንፔካ ዶቅድንደትም ከትካንታ ኬዝባብ ክታይንችም ለምለም ጋይድንካ ሰዶቴ’ ጋየረኮ Ꮊድሶ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ዎንታ ዎክያርንከረ ዋልቃ ዋልቀንከስ ዱክንደር አይሰኮ ገታ ማነንከስ ኬዛንግንዳ ማችንካ Ꮊፍሰኬ፥ የሱሰም ማቸ ሰዳከኬ”። ");
INSERT INTO gyl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","የሱሰረ “የታ ገቀርዳክን ኤድን ከሶ፥ ቡደና የንታ ሳብዘንካ ኤስርሶ ኬዛቅባብከስ ኬዛንደትም ሙዳ አሜንክሳ ነገቴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ክርስቶስ ኮ ማጠንም ሙዳ ተይንተከ ይንታ ቦንቸናረረ አርድንታ ክትም ዝክሳዮ?” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ሙሴዘንከ ሳብዘንካ ኤስርሶ ኬዛቅባብ ሙደንዘንካ የድሶ ጭል ማጻፍንከሳር ክትጎካ ጻፍምሳንደትም ከትካንታ መየካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ከተረ ይ አይድን ሞረናር ቅንችምሰኮ የሱስ ጎት ከታዘንካ አይድን ከትም ካምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ከታ ማቼ፥ “ፍጨነረ ሶይታዶቅደ፥ ሰጨነረ Ꮊክሳንካንታ ዎንካ ክክን ገችካ” ጋይሰኮ ዳቅስሶ ክትም ምክሰኬ፥ ኮካንታ ከትካ ክክን ገችካንታ አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ከትካ የከረ እችምካንታ ዶቅሳንደትካ ሶለንም አምስሶ ሳብም ጋለቼ፥ አስተረ ከትም እምሴ ");
INSERT INTO gyl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ከታ አፍነረ ፎችምሴ፥ ክትመረ ከታ ኤሰኬ። የሱሰረ ከታዘንካ አጥምሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ከተረ፥ “ጎግዘን ዎ ዶቅድንካ፥ ዎም ክት ከዝድንከ ጭል ማጻፍንከስመረ መያ ማስሶ ዎንታ ቡዳር አርድንግንዳ ክት ኬዝድንካ ቡደና ዎንታ አትረሮ Ꮊቃካዮ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ኮትኮ ሳዓትንካ አምሰኮ ፈንክ የሩሳሌም ካተመናር ማቼኬ። ታሜኬ ዋልቀንከስኬ ከትካ ክክን Ꮊቅባብከስ ኮታር የካ ሳንምሰኮ ዶቅድንካ ከትም Ꮊፍሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ከተረ “ጮይስ የሱስ ገታ አምቴ! ስምኦናካንተረ Ꮊፈርቴ” ክክ ጋይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","የሱሰታ ካርንካ ጎርስማᎺቅባብ ቃስተና ጎግዘን ይይምሳንደትምከ፥ የሱስ ሶለንም ክት አሳንደትካ Ꮊስግንዳ ክትም ከታ ይ ኤሳናንከረ ከትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ኮትኮም ከት ኬዝመሮ ዶቅድንካ የሱስ ይንታ ማታርንካ ከታ ዎክያር ዎእሶ፥ “ሳራትቸና የካንታ ማታ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ከተረ ማቼ ገቅሰኮ ቡንከም ሰዳን ከደር ካምስንካ ጳስካ ጭጨኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","የሱሰረ ከትም “Ꮊረተንት ገቅዳ? Ꮊራካንቶክ የንታ ቡደና Ꮊኤረዳ? ");
INSERT INTO gyl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","እስታ አንንምኬ እስታ ዱትንም ሰድከቴ፥ እታ እስታ ማታርንክቴ፥ አነረ ዎልሰረ እም ሰድትከተ፥ እዘን የ ሰድንግንዳ አያን ዋሄከ ለፍ ካዬ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ኮም ጋይሶ ይንታ አንንምኬ ዱትንም ከትካንታ ሰችሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ከተረ ጉርምዘንኬ በርእዘንካ አምሳንዳ አክ አሜናከኬ። የሱሰረ “ካሪ እቸርድን ዋልቃ ር የንደር ዶቅዶ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ከተረ አቼርሳን ሞለዘንካ መርሳ ክትም እምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ኖየረ ተይሶ ከታ እሪ እቼ። ");
INSERT INTO gyl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","የሱሰረ “የንካ ክክን እ Ꮊቃንደትካ፥ ሙሴታ ህግናር፥ ሳብዘንካ ኤስርሶ ኬዛቅባብከስተኬ የችንከሳር እጎካ ጻፍምሳንዳ ሙዳ ቦድም ዝግዝዴ ጋይስቶ የም እ ኬዛንዳ ቃለና ኮኔ” ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ኮትᎺይካ ጭል ማጻፍንከስም ከት ገቀርድንግንዳ ማክቸን ከታ ፎቼ። ");
INSERT INTO gyl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“ክርስቶስ ማጠንም ተይተሬ፥ ማክምስ ሰጨንከረ ደእናርንካ አምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","የሩሳሌም ካተመናርንካ የድሶ ዎርሳ ሙደንካንታ ጎማ ፍክስን ዎይስኬ ነጋትቼና ክታ ላምንካ ሳባክምተረ፥ ኩን ጋይምሶ ጭል ማጻፍንከሳር ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","የተረ ኮታ ማርከቴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ይና! እተረ እባብ እምሳን Ꮊድን ጉርምን የካንታ ኦይትቴ። የታ ማቼ ፈይንካ ዎልቀን የ ተይተርን የለልታ የሩሳሌም ካተመናር ዶእከቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ኮታ ቡር ይንታካርንካ ጎርስምድባብከስም የሩሳሌም ካተመናርንካ ብታንያ ፍጫ የለልታ ከትም የድሶ ዉተዴ። ይንታ አንንም አምስሶ ኬትም አንጄ። ");
INSERT INTO gyl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ከትም አንጃዶቅድዮ ከታዘንካ ፋስምሶ ፈስ ጭላር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ከተረ ክትካንታ ጎስትንደትኬ አንድር ጉርምካ ፈንክ የሩሳሌም ካተመናር ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ሳብመረ ጋለተረኮ ሙዳᎺይካ ሳብታ ጭል ኤሄናር ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","እርምሶ ቃለና Ꮊቄ፥ ቃለነረ ሳብካ ክክን Ꮊቄ፥ ኮነረ ቃለና ሳብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ኖየረ እርምሶ ሳብታ ላማር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ሙዳ ርና ክትጎካ ፍዝምሴ፥ ፍዝምሳን ሙዳ ሪያርንካ፥ ዋልቃ ሪየረ ክት ካይሳ ፍዝምሳንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ክትካ ሰንፓ Ꮊቄ፥ ኮነረ ሰንፔና ኤድንከስታ ሳክማ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ሳክመና ኡምናር ሳግዝዴ ኡምነረ ሳክመንም ጋማክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ሳብዘንካ ክትምስባብ ዮሀንስ ጋይምድባብ ዋልቃ ኤች Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ክታ ማርካትቸን ኤሰርሶ ኤድ ሙደና አሜንድንግንዳ ሳክመንጎካ ማርካ ማትሶ ኖ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ኖ ሳክመንካንታ ማርክርደር Ꮊዳ ዳት ኖይንታ ማታ ሳክማ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ኤድ ሙደንካንታ ሳግዝድባብ ዶፈን ሳክመና ፍጫሙደንዘን Ꮊዳ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ኖየረ ፍጫሙደንዘን Ꮊቄ፥ ፍጫ ሙደና ፍዝምሳንዳ ክትኬ፥ ፍጫ ሙደና ማቼ ክትም ኤሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ይንታ ማችባብከዝደር ኖ Ꮊዴ ክታ ኮችንከስ ማቼ ክትም ግርደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ማታጋካ ዳት ክትም Ꮊፍስባብከስካንተኬ ክታ ላምካ አመንስባብከስካንታ ሙዳ ሳብታ ይንች ማትንተታ ሸን ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ከተረ ሳብዘንካ አጥምሰክ ዳት ኤታ ሱሳርንካ፥ ጋይንትነረ ዋሄታ ጋይተካ አነረ ኤታ ጋይተካ አጥማከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ቃለነረ ኤድ ማቼ፥ ዉች እምንተኬ ዶፈንነረ ጮጭሶ ዎንታ ዎክያር ዶቅሴ፥ ባቤንታ ዋልቃ ይንት ይንችና ይንታ ባቤንታ ላማር ዶቅድንደትግንዳ ክታ ቦንቼንም ሰቶቴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ዮሀንሰረ “ ‘ኖ እስታ ካርንካ Ꮊድባብ እስታ እሪ ክት Ꮊቃንኦል እዘንካ አንድርይ ስገዴ’ ጋይስቶ እ የካንታ ኬዛንዳ ይና ኮኔ” ጋየሮ ማርከርሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ክታዘንካ ዉች እምንተንታ በድምናርንካ ዎታ ሙደና ዉች እምንተንዘን እምንተንም ተይቶቴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ሳብ ህግን ሙሴጎካ እምሴ፥ ዉች እምንተንኬ ዶፈና ማቼ የሱስ ክርስቶስጎካ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ሳብም ሰጅባብ ቦድሶ Ꮊየነረ ካዬ፥ ማታጋካ ዳት ሳብ ባቤንካ ክክን ዶቅድባብ ጮይስ ማችባብ ዋልቃ ክታ ይንችና Ꮊክ ክትም መያ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","አይሁድንከስታ ገችንታ ኤረንባብከስ የሩሳለማርንካ ቄሰንከስምኬ ሌዊንከስም ዮሀንሰደር ኦይትሰኮ፥ “የና Ꮊይራ?” ጋይሶ ኬት ክትም ኦይስሳንᎺይካ ከትካንታ ክት እምሳንዳ ማርካትቸና ኮም ካምዴ፤ ");
INSERT INTO gyl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ኖ “እታ ሳይምስባብ ካይቴ” ጋይሶ ማርከርሳ ዳት ካዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ከተረ “ይና የና Ꮊይራ? የና ኤላሶ?” ጋየረኮ ክትም ኦይሰኬ። ኖየረ “እታ ካይቴ” ጋይሶ ከደረ ማስሴ። ከተረ “Ꮊዴ ጋይምስባብ ሳብዘንካ ኤሰርሶ ኬዝድባብ የኖ?” ክደረ ጋይሰኬ። ኖየረ “እታ ካይቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ከተረ “ይና የና Ꮊይራ? ዎም ኦይችባብ ኤድንከዝደረ ማስንም ዎ ኬዝድንግንዳ የስጎካ Ꮊረስ ጋይዳ?” ክደረ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ኖየረ ሳብዘንካ ኤሰርሶ ኬዝባብ ኢስያስ ኬዛንደትግንዳ “እታ ‘ጮይስንታ ጎግን ሉልስከቴ’ ጋየሮ ዴል ቆቸናር ፍብድን ኤታ ኡፍስቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ኤድንከስ ኦይትምሳንደና ፈረሳዊያንንከሳርንኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ኮካንታ “የና ሳይምስባብ አነረ ኤላስ አነረ Ꮊዴ ጋይምስባብ ሳብዘንካ ኤሰርሶ ኬዝድባብ የስ ማታክንዳ ማቼ ይና፥ Ꮊረተስ ስእዝዳ?” ጋይሶ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ዮሀንሰረ ኩንጋየሮ ከደረ ማስሴ፥ “እ ስዝድንዳ ሎቀኬ፥ ኬዛር ማቼ የታ የ ኤዝዳክባብ የንታ ዎክያር ዎእቴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ኖ እስታ ቡርጎካ Ꮊድባቤ፥ እታ ክታ ጫመንታ ዞክነንደትም ብልካንታ ዎራ ማድባብ ካይቴ።” ");
INSERT INTO gyl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ኮና ማቻንዳ ዮሀንስ ስእዝድ Ꮊቃን ዮርዳኖስ ሎቀንታ ፋማ Ꮊፈርድን ብታንያ ካተመናሬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ዛማክንካ ዮሀንስ የሱስ ፈንካ ክደር Ꮊድንካ ሰድሶ፥ “ይና ፍጫሙደንታ ጎመንም Ꮊልእዝድባብ ሳብታ ቆለና ኮኔ! ");
INSERT INTO gyl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘ኖ ኦኮና እስታ ካርንካ Ꮊድባብ እስታ ኤና እሪ ክት Ꮊቃንካንታ እዘንካ አንድርይ ስገዴ’ እ የካንታ ጋይሳንዳ ኮኔ። ");
INSERT INTO gyl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","እተረ እስታ ማታርንካ ኤሳይቴ፥ ኬዛር ማቼ ኖ እስራኤል ዎርሰንካንታ መያ ማድንግንዳ እታ ሎቀካ ስእሰሮ Ꮊዳተ ጋይሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ኮታዘንከረ ዮሀንስ፥ “አያንይ ጭልና ዎላ ግንዳ ጭላርንካ Ꮊንችርድንከ ክታዘን ማድንካ ሰጅቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","እታ እስታ ማታርንካ ክትም ኤሳይቴ፥ ኬዛር ማቼ ሎቀካ እ ስእዝድንግንዳ እም ኦይችባብ፥ ‘አያን ጭልና Ꮊንቸርድንከኬ ክታዘን ዶቅድንካ ሰድምድባብ አያን ጭልንካ ስእዝድባብ ኖዬ’ ጋየሮ እም ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","እተረ ኮም ሰትቴ፥ ኮካንታ ኖ ሳብታ ይንች ማትንተን እታ ማርከርድቴ ጋይሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ዛማክንካ ዮሀንስ ቃስተን ይንታካርንካ ጎርስምድባብከስካ ክክን ካርንካ አነታ ኮታር ዎእሶ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ዮሀንሰረ የሱስ ኮትካ ስገድንካ ሰድሶ፥ “ይና፥ ሳብታ ቆለን!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ቃስተና ዮሀንሰታ ካርንካ ጎርስምድባብከስ ዮሀንስ ኮም ጋይድንካ ኤሰርሶ፥ የሱሰም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","የሱስ ዋልን ጋይሶ ከት ክትም ጎርስምድንካ ሰድስንደትኬ “Ꮊረንት ዝግዳ?” ከደረ ጋይሴ። ከተረ “ረቢ! የስ ዶቅድንዳ Ꮊብረረ?” ክደር ጋይሰኬ። (ረቢ ጋይንትና ኤስስንባብ ጋይንትዬ)። ");
INSERT INTO gyl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ኖየረ “Ꮊድሰቶ ሰድከቴ” ከደረ ጋይሴ። ኮካንታ አይሰኮ Ꮊብር ክት ዶቅዳናነረ ሰጀኬ። ኮት ሰጨንካ ክትካ ክክን የካ Ꮊቀኬ፥ ሳዓትና ታማ ማታባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ዮሀንስ ኬዛንደትም ቃለንም ኤሰርሶ የሱሰታ ካርንካ ጎርስምስባብከሳርንካ ዋልቀና ስምኦን ጴጥሮስታ እስመን እንደርያስ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","እንደራስ እርምሶ ይንታ እስመን ስምኦነደር አይሶ “መስም Ꮊፍሶቴ!” ክደረ ጋይሴ። (መስይ ጋይንትና ክርስቶስ አነረ ሳይምስባብ ጋይንትዬ) ");
INSERT INTO gyl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ኮታ ቡር እንደራስ ስምኦነም የሱሰደር ተይᎺዴ። የሱሰረ ፍስሳ ክትም ሰድሶ “የና ዮነታ ይንችና ስምኦነዬ፥ ይና ኮዘንካ ኦስ ማቼ ከፋ ጋይምደዬ” ክደረ ጋይሴ። (ከፋ ጋይንትና ጴጥሮስ ጋይንት ናንከረ አነረ ላዝይ ጋይንት ማዴ)። ");
INSERT INTO gyl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ዛማክንካ የሱስ ገሊላ አይካንታ ዝግዜ፥ ፍልጶሰመረ Ꮊፍስንደትከ “እም ጎርስምካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ፍልጶስ እንደርያስግንደኬ ጴጥሮስግንዳ በቴሳይዳ ካተማ ኤድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ፍልጶሰረ ናትናኤልም Ꮊፍሶ፥ “ሙሳ ህግ ማጻፍናር፥ ሳብዘንካ ኤሰርሶ ኬዝድባብከሰረ ቤር ማጻፍናር ክትጎካ ጻፍሳንደትም Ꮊፍሶቴ፥ ኖየረ የሶፍታ ይንች ናዝረት የሱስየ” ክደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ናትናኤል ማቼ፥ “ናዝረታርንካ ኡርማ ር ቦድሶ Ꮊፈርዶ?” ክደር ጋይሴ። ፍልጶሰረ “Ꮊድሶ ሰድካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ናትናኤል ፈንካ ክደር Ꮊድንካ ሰድሶ የሱሰረ “ይና! ጩባ ካየንባብ ዶፈን እስራኤል ኤድ!” ጋየሮ ክትጎካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ናትናኤለረ “Ꮊብረስ እም ኤዝዳ?” ክደር ጋይሴ። የሱሰረ “ፍልጶስ የስም ኤልተርንደታ እር በለስ Ꮊቀንታ ጎያር የስ ዶቅድንካ ሰጅቴ” ጋየሮ ክደር ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ኮትᎺይካ፥ ናትናኤል፥ “ኤስስንባቦ! የና ሳብታ ይንቸዬ! የና እስራኤልታ ባንቻዬ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","የሱሰረ፥ “የስ አሜንሳንዳ፥ ‘በለስ Ꮊቃንታ ጎያር ማትሶ የስ ዶቅድንካ ሰጅቴ’ እ ጋይሳን ኦሎ? ኮዘንካ ስግዳን ርንከስም አክ ሰተራዬ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ዶፈን፥ ዶፈን የም ጋይድቴ፥ ጭላ ፎችምድንካ ሳብታ ክታ ይንችነረ ኤድ ይንችንታ ዘን ዉድንኬ Ꮊንቸርድንካ ሰተረቴ ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ማክምስ ሰጨንካ፥ ገሊላ ፍጫር Ꮊፈርድን ቃና ጋይምድን ካተመናር እሳ ዶቅድንካ የሱሰታ እንደነረ ኮታር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስካ እሴናር ኤልምታ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","እሳ እችምንዘን ዎጨርድንዳ ዎይንና በእሳንደትካ የሱሰታ እንደና የሱሰም፥ “ዎይን ዎጭምና ከደር በእቴ!” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","የሱሰረ “እስታ እንደኖ! የስካ ክክን Ꮊራ ሪ እስታ ዶቅዳ? እስታ ሰጨና አክ የላክዬ” ኮደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ኮታይካ እንደና ዋር ዶቅድን ፍክስንባብከስም፥ “ክት የም ጋይድን ሙዳ ይከቴ” ከትም ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","አይሁድንከስታ አርንንታ ዎጋ ከታ Ꮊቃንጎካ ላ ጎላ ዳሀ ኮታር Ꮊቀኬ፥ ዋልቃ ዋልቃ ጎላ ዳሄንከስ ቃስተን አነረ ማከን ዳሀካ ሎቃ የድንዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","የሱስ ፍክስንባብከስም “ጎላ ዳሄንከስም ሎቃ ጮችከቴ” ከትም ጋይሴ፥ ከተረ ዳሄንከስካ ሙዳ ጮችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ኮታ ቡር የሱስ ፍክስንባብከስም፥ “አልቀንባብከስም ይና ታ ዱቅሰቶ ኤሄንባብካንታ እምከቴ” ከደር ጋይሴ፥ ከተረ ክትካንታ እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","አልቀንባብከስም ክድባብ ዎይን ዎጭምና ኦክምሳን ሎቀንም አፍሳንደትካ፥ Ꮊብርንካ Ꮊዳናንከረ ኤሳክዬ፥ ሎቀን ቆልእስባብ አልቀንባብከስ ማቼ ኤዝድ Ꮊቀኬ፥ ኮካንታ እችንባብከስታ ክተንባብ፥ እሰንባብም ኤልሶ፥ ");
INSERT INTO gyl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ኤድ ሙደና እርምሶ እምድንዳ ኡርማ ዎይን ዎጭምኔ፥ ኤልምስባብከስ ዎጫንደታ ቡር ሎቅዳክንደትም እምዴ፥ የና ማቼ ኡርማ ዎይን ዎጭምን ታ የለልታ ዶቅሰዬ ጋይሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","የሱስ ኮም አታ ቃዉታ ሙደንታ እርንዳ ማቻን አታ ቃዉተን ገሊላ ፍጫ ቃና ካተመናር ይሴ፥ ኮግንደካ ይንታ ቦንቸንም መያ ማስሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ክትካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ኮታ ቡር የሱስ ይንታ እንደንኬ ይንታ እስመንከስካ፥ ክታ ካርንካ ጎርስምድባብከስከረ ክክን ቅፍረናሆም ካተመናር Ꮊንቸርሴ፥ ኮታረረ ቶክም ሰጫ ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","አይሁድንከስታ ፋስጋ ባአል የልሳንኦል የሱስ የሩሳሌማር አይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ሳብታ ጭል ኤሄናረረ ገዝምንከስም፥ ቆልንከስምኬ ዎለንከስም ሰንድባብከስምኬ ብረን ኦካኦንግድባብከስ ዶቅሶ ከት ጋበን ጋብድንካ Ꮊፍሴ። ");
INSERT INTO gyl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ኮታይᎺካ ዝራፍ ምርስንደትከ ኤድንከስም ሙዳ፥ ቆልንከስምኬ ገዝምንከስምካ ክክን ሳብታ ጭል ኤሄናርንካ ከትም ዉችሴ፥ ብረን ኦግድባብከስመረ ብረን ከታ ይጭሴ፥ ከታ ገበትንከስመረ ባልት ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ዎለን ሰንድን ኤድንከስመረ “ኮም ሙዳ ኦስ ተይከቴ! እስታ ባበንታ ኤሄን የንታ ዛለታ ኤሀ Ꮊይማሰቴ!” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ኮታይካ ክታ ካርንካ ጎርስምድባብከስ “የስታ ኤሄንጎካ እስታ ዶቅድን ቀምስና እም አተርዝዴ” ጋይምሶ ጻፍምሳን ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ኮታ ቡር አይሁድንታ ገችንታ ኤረንባብከስ የሱሰም፥ “የና ኮም ይካንታ ገችታ ኤራ የስታ ዶቅድንደትም Ꮊረስ ቃዉታ ማድን አተን ዎካንታ ሰጅዳ?” ክደረ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","የሱሰረ “ኮም ሳብታ ጭል ኤሄንም የታ ዉልእከቴ፥ እታ ማከን ሰጨካ ማስት ዎድቴ” ኖ ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ከተረ “ኮም ሳብታ ጭል ኤሄን ዎድካንታ ቃስተን ቦንደከ ላ ስላ በይስቴ፥ ይና የና ማከን ሰጨታ ዋር ዎትራ?” ክደረ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","የሱስ ማቼ “ሳብታ ጭል ኤሄን” ጋይሶ ክት ኬዛንዳ ይንታ ኤደትቸንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ኮካንታ የሱስ ደእናርንካ ክት አምሳንደትᎺይካ ክታ ካርንካ ጎርስምድባብከስ ኮም ከዝድ ክት Ꮊቃንደትም ገቀርሰኬ፥ ኮጎካ ጭል ማጻፍናር ጻፍምሳንደትምኬ የሱስ ኬዛን ቃለን አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","የሱስ ፋስጋ ባአልንᎺይካ የሩሳሌማር ዶቅድዮ ክት ይያቃን ቃዉተንከስም ሰድንተንካ በድ ኤድንከስ ክትካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","የሱስ ማቼ ኤድንከስም ሙዳ ኤዝድ ይ Ꮊቃንኦል ከትም አመናክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ኖ ኤታ ቡዳር ዶቅድንደትም ሙዳ ኤዝድ ይ Ꮊቃንኦል ኤድጎካ Ꮊየነረ ክትካንታ ኬዝድንግንዳ ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ንቀድሞስ ጋይምድባብ ዋልቃ ኤች Ꮊቄ፥ ኖ ፈርሳዊያንንከስታ ኮች ማችባብ አይሁድንከስም ክድባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ኮና ኤችና ገልትገር የሱሰደር Ꮊድሶ፥ “ኤስስንባቦ፥ ሳብ ክትካ ክክን ማታክን የለልታ ከናከስም የስ ይድንደትም ቃዉተንከስም ይይካንታ ማድባብ Ꮊየሰነረ ካዬ፥ ኮካንታ የና ሳብታ ላማርንካ Ꮊድባብ ኤስስንባብ የስ ማቻንደትም ዎታ ኤዝዶቴ” ክደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","የሱሰረ “ዶፈን፥ ዶፈን እታ የስም ጋይድቴ፥ ኤድ አናካርንካ አጥማክንዳ ማቼ ሳብታ ባንችምን ሰድንካንታ ማታዬ” ክደረ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ንቀድሞሰረ “ይና፥ ኤድ ይ ዶንጀርሳንደታ ቡር Ꮊስግንዳ አጥርካንታ ማዳ? ቃስትምስ ይንታ እንደንታ ሳቅምናር አርድሶ አጥርካንታ ማዶ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","የሱሰረ፥ “ዶፈን፥ ዶፈን ጋይድቴ፥ ኤድ ሎቀዘንኬ አያን ጭልንካ አጠራክንዳ ማቼ ሳብታ ባንችምናር አርድካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ኤድዘንካ አጠርምስባብ ኖ ኤድ፥ አያንዘንካ አጠርምስባብ ኖ አያኔ። ");
INSERT INTO gyl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ኮካንታ ‘ቃስትምስ አጥር የም ዝግዝዴ’ እ የስም ጋይሳንደትካንታ Ꮊይ በርኤ። ");
INSERT INTO gyl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ዞጋ ይ ዝግዛንደትጎካ ዞግዴ፥ ኡፍስንም ኤሰርደዬ፥ ኬዛር ማቼ Ꮊብርንካ ኮት Ꮊዳናንከረ Ꮊብር ኮት አይዳናንከረ ኤዝዳከዬ፥ አያንዘንካ አጠርምስባብ ሙደና ኮግንዴ ጋይሶ ማስሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ንቀድሞሰረ “ኮና Ꮊስግንዶክ ማትካንታ ማዳ?” ጋይሶ ክደረ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","የሱሰረ፥ “የና እስራኤልታ ኤስስንባብ ማትሰዮ ኮም ኤዝዳካ? ");
INSERT INTO gyl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ዶፈን፥ ዶፈን እታ የስም ጋይድቴ፥ ዎ ኤዝድንደትም ኬዝዶቴ፥ ዎ ሰዳንደትመረ ማርከርዶቴ፥ የታ ማቼ ዎንታ ማርክርን ተይዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ፍጨዘንደት ርም የም ዎ ኬዝድንካ አሜንዳክባብ የ ማቼ ጭላር ሪንጎካ እ የም ኬዝድንካ Ꮊስግንደንት አመንዳ? ");
INSERT INTO gyl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ጭላርንካ Ꮊንቼርስባብ ኤድ ይንችዘንካ አብ ጭላር አይስባብ Ꮊየነረ ካዬ ጋይሶ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“ሙሳ ዴል ቆቸናር ጉንንም ጬክሳ ይይሶ ክት ሮክሳንደትግንዳ ኮትኮግንደረ ኤድ ይንች ጬክን ጋይሶ ሮክር ክትም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ኮነረ ማድንዳ ክትካ አሜንድባብ ሙዳ ስለንክንደታ ዶቅንት Ꮊብድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“ክትካ አሜንድባብ ሙዳ ስለንካ ዶቅንት ዶቅድንግንዳ ዳት ከት ካይዳክንግንዳ ሳብ ፍጫ ሙደን አንድር ሶልምሳንካንታ ዋልቃ ይንታ ይንችንም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ሳብ ይንታ ይንችን ፍጫሙደንዘን ክት ኦይቻንዳ፥ ፍጫ ሙደና ክታ ይንችንካ አቅድንግንዳ ዳት ፍጫሙደንዘን ፋረድካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“ክትካ አመንድባብዘን ፋረድማዬ፥ ክትካ አሜንዳክባብ ማቼ ዋልቀን ሳብታ ይንችንካ አመናክንካንታ እርምሶ ክታዘን ፋረድምቴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“ፊረድነረ ኮኔ፥ ሳክመና ፍጫሙደንዘን Ꮊዴ፥ ኤድንከስ ማቼ ከታ ፍክስና ዳቅል ማቻን ኦል ሳክመንዘንካ ስግስሶ ኡምንም ሶልምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ዳቅል ሪን ይድባብ ሙደና ሳክመንም ቦዝዴ፥ ዳቅል ክታ ፍክስነረ መያ ማዳክንግንዳ ፈንክ ሳክመንደር Ꮊዳየ። ");
INSERT INTO gyl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ዶፈን ማቻን ርን ይድባብ ማቼ ፈንካ ሳክመንደር Ꮊዴ፥ ሳክመንደር Ꮊድባበረ ክት ይሳን ሪነረ ሳብታ ክተንግንዳ ማትና መየካ Ꮊፈርድንግንዴ።” ");
INSERT INTO gyl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ኮታ ቡር የሱስ ይንታ ካርንካ ጎርስምድባብከስካ ክክን ይሁዳ ፍጫር አይሴ፥ ኮታረረ ስእሰሮ ከትካ ክክን ቶክም ሰጫካንታ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ኮታይካ ዮሀንሰረ በድ ሎቃ ዶቅድንኦል ሳለምታ ባንግር ሄኖን ጋይምድን ካርያር ስእዝድ Ꮊቄ፥ ኤድንከሰረ Ꮊደረኮ ስእረሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ኮታይካ ዮሀንስ አክ ዞከራክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ኮታይካ ዮሀንሰታ ካርንካ ጎርስምድባብከሳርኬ አይሁድንታ ዎክያር አርንንታ ዎገንጎካ በርም አምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ዮሀንሰታ ካርንካ ጎርስምድባብከስ ዮሀንሰደር Ꮊድሶ “ኤስስንባቦ፥ ኖ ኦኮና ዮርዳኖስ ሎቀንታ ፋማ የስካ ክክን ኖ Ꮊቅባብ፥ የና ክትካንታ የስ ማርከርስባብ፥ ይና፥ ኖ ስእዝዴ፥ ኤድንከሰረ ሙዳ ክደር አይደኬ” ክደረ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ዮሀንሰረ፥ “Ꮊየነረ ኤድ ሳብ ከትካንታ እማክናና Ꮊራ ሪየረ ክታ ዶቃዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘ክታ ኤና እር ኦይትምትት ዳት እታ ሳይምስባብ ካይቴ’ ጋይስቶ እ ኬዛንግንዳ የታ የንታ ማታርንካ ማርከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ይእድን ይንቸንና ዶቅድባብ ኤችና ኖ እንቼንባቤ፥ እንቼንባብታ ላኮይትና ማቼ እንቼንባብታ ላማር ዎእሶ ኤሰረሮ ክትምዴ፥ ክተረ ኡፍስን ኤስርካ ኖ ጉርምዴ፥ ኮካንታ እስተረ ጉርምና ኮኔ፥ ኖየረ ታ ቦድማ ማቴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ኖ ጬክ ጬክ ጋይ ክትም ዝግዝዴ፥ እታ ማቼ ይርክ ይርክ ጋይ እም ዝግዝዴ ጋይሶ ማስሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ፈይንካ Ꮊድባብ ሙደንዘንካ ስግዬ፥ ፍጨዘንካ ማችባብ ፍጨቴ፥ ፍጨትንደት ሪመረ ኬዝዴ፥ ፈ ጭላርንካ Ꮊድባብ ሙደንዘንካ ስግዬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ኖ ይ ሰጃንደትምኬ ይ ኤሰርሳንደትም ማርከርዴ፥ ኬዛር ማቼ ክታ ማርከርንም ተይድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ክታ ማርክርንም ተይድባብ ማቼ ሳብ ዶፈን ማትንተን ዳቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ሳብ ይንታ አያንን ክት እምድንዳ የርክስት ማታክንካንታ ሳብ ኦይችባብ ሳብታ ቃለን ኬዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ሳብ ባበና ይንታ ይንችን ሶልምደ፥ ሙዳ ሪመረ ክታ አንያር እምቴ። ");
INSERT INTO gyl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ሳብ ይንችንካ አሜንድባብ ስለንክንደታ ዶቅንት ዶቅዴ፥ ሳብ ይንችንካ አሜንዳክባብ ማቸ ሳብታ ዋጭና ክታዘን ዶቅተሬ ዳት ዶቅንትን Ꮊፋዬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ኮታይካ የሱስ ዮሀንሰዘንካ ስግ በድ ኤድንከስም ይንታካርንካ ጎርስምድባብከስ ማዝድንደትምኬ ክት ስእዝድንደትም ፈረሳዊያንንከስ ኤሰርሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ማችንከረ ስእዝድ Ꮊቅባብከስ ክታ ካርንካ ጎርስምድባብከስ ዳት ኖ ይንታ ማታርካ ስእሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ክትጎካ ጋይምሳንደትም ፈረሳዊያንንከስ ኤሰርሳንደትም ይ ኤሳንደትካ የሱስ ይሁዳ ፍጨንም ዛቅሶ ኦስ ገሊላር ማት አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ኮታር አይድዮ ሳማርያ ጎካ ስግና ክታ ነገዳክንዳ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ኮካንታ ያይቆብ ይንታ ይንችን ዮሴፍ ካንታ እምሳን ካርንታ ላማር Ꮊፈርድን፥ ስካር ጋይምሶ ኤልምድን ሳማርያ ካተመናር Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ኮታረረ ያይቆብታ ጎር ሎቃ Ꮊቄ፥ የሱስ ጎግ ሙክንትዘንካ አምሳንዳ ጋፍሶ ጎር ሎቀንታ ባንግር ዶቅሴ፥ ሰጨነረ ቶምራ ላ ሳዓት ማታባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ኮታይካ ዋልቀንዳ ሳማርያ ፍጫ ኤተን ሎቀን ቆልእካንታ ጎርንደር ና Ꮊዴ፥ የሱሰረ “ሎቃ እም ዎእስካ!” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ኮታይካ ክታ ካርንካ ጎርስምድባብከስ እችም ሰንማካንታ ካተማ አይተክ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ና ኮነረ ሳማራ ኤተና የሱሰም፥ “የና አይሁታ ኮች ማደዮ Ꮊስግንደስ እ ሳማረንደር ‘ሎቃ እም ዎእስካ!’ ጋይሰዮ እም ኦይዝዳ?” ና ጋይሴ፥ ኮም ኮታ ጋይና፥ አይሁድንከስ ሳማርያ ኤድንከስካ ክክን ከት ኡራይንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","የሱሰረ “ሳብታ ዉች እምንተኬ ‘ሎቃ እም ዎእስካ!’ የስም ጋይድባብ Ꮊይ ክት ማቼረ የስ ኤስታ ናና፥ ክትም ምክስ ዝግዝድንዳ የስም ዶቆ፥ ኖየረ ዶቅንት ሎቀን የስም እምዳ ዶቆ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ናየረ፥ “ባቦ! የስታ ቆልእንዳ ካዬ፥ ጎርነረ ጩልጩልዬ፥ ይና፥ ዶቅንት ሎቀንም የና Ꮊብርንከስ Ꮊፍተራ? ");
INSERT INTO gyl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","የና ኮም ጎርን ዎም እምስባብ ዎንታ ባቤን ያይቆብዘንካ ስገዳ? ክትኬ ክታ ይንችንኬ፥ ክታ ቆልመንከሰረ ኮትኮ ጎር ሎቀናርንካ ዎጭተኬ ኩንጋየሮ ክደር ማስሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","የሱሰረ፥ “ኮ ሎቀናርንካ ዎጭድባብ ሙደና አናካርንካ ዎቸርዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","እ እምድን ሎቀን ዎጭድባብ ስለንክንደታ ቦድሶ ዎቸራዬ፥ እ እምድን ሎቀን ዎጭድባብ ኤድ ስለንክንደት ዶቅንትታ ፉእድን ሎቀታ ቱት ማተረ ኩንጋየሮ ኮደር ማስሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ኤተነረ “ባቦ! ይና ኮዘንካ ኦስ ሎቃ እስታ ቡዳ ዎቻይንግንደኬ ካረረ ቆልእካንታ እ Ꮊዳክንግንዳ ዋደ ኮግንዳ ሎቀን እካንታ እምካ!” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","የሱሰረ “አይሳዮ የስታ ክእስንም ኤልት Ꮊትካ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ኤተነረ “ክእስ እስታ ካዬ” ጋየሮ ና ማስሴ፥ ኮታይካ የሱስ፥ “ክእስ እስታ ካዬ ጋይንተና ገቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ዶንቅ የስታ ክእስንከስ ዶቅደኬ፥ ታየረ የስካ ክክን ዶቅድባብ ኤችና የስታ ክእስ ካዬ፥ ኮካንታ ዶፈንን የና ከዝተዬ” ኩን ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ኤተነረ፥ “የባቦ! የና ሳብዘንካ ኤሰርሶ ኬዝድባብ የስ ማቻን ታ እታ ኤሳቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ዎንታ ባበንከስ ኮ ገቼንዘን ጎስትሰኬ፥ የታ ማቼ ‘ኤድንከስ ጎስት ከትም ዝግዝድንዳ የሩሳለማረ’ የታ ጋይደቴ” ኩን ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","የሱሰረ ኮትም፥ “የና ኤተኖ፥ ኮ ገቼንዘን አነረ የሩሳሌማር ሳብ ባበንካንታ የ ጎዝዳክንደታ ሰጫ Ꮊድንደትም የና እንካ አሜንካ፥ ");
INSERT INTO gyl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","የታ የ ኤዝዳክን ጮይስንካንታ ጎዝደቴ፥ ዎታ ማቼ አቅንታ Ꮊድንዳ አይሁድዘንካ ማቻንኦል ዎ ኤዝድን ጮይስንካንታ ጎዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ኬዛር ማቼ ዶፈንካ ክትም ጎዝድባብከስ፥ ሳብ ባቤንካንታ አያንካ ማትስንደትኬ ዶፈንካ ከት ጎዝድን ሰጫ Ꮊዴ፥ ታየረ Ꮊቴ፥ ሳብ ባቤነረ ክት ዝግድንዳ ኮግንደካ ክትም ጎዝድባብሜ። ");
INSERT INTO gyl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ሳብ አያነረ፥ ክትም ጎዝድባበረ አያንካ ማትስንደትኬ ዶፈንካ ክትካንታ ጎስት ከትም ዝግዝዴ ኮትም ኩን ጋይሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ኤተነረ “ክርስቶስ ጋይምድባብ ሳይምስባብ Ꮊድንደትም ኤዝድቴ፥ ኖ Ꮊድሶ ሙዳ ሪይንም ዎካንታ ኬዝዴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","የሱሰረ “ኮሰዳ! ታ ኮ የስም ከስዝድባብ እትቴ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ኮታይካ ክታ ካርንካ ጎርስምድባብከስ ይ አይሳንደታርንካ ማት Ꮊደኬ፥ የሱስ ማነካ ክክን ክት ከዝምንካ ከታ በርእሰኬ፥ ማታጋካ ዳት “Ꮊረስ ዝግዳ? አነረ ኮትካ ክክን Ꮊረስ ከዝምዳ?” ጋይሶ ኦይስባብ Ꮊየነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ኮታ ቡር ኤተና ዳሄንም ዛቅሶ ኦስ ካተመናር አይስንደትኬ ኤድንከስካንታ፥ ");
INSERT INTO gyl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“እ ፍክሳንደትም ሙዳ እካንታ ኬዝባብ ኤችን ኮሪ Ꮊድሰቶ ሰድከቴ! Ꮊረንግርካ ኖ ሳይምስባብ ማተርዳቶ?” ና ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ኤድንከሰረ ካተመናርንካ ዉትሶ የሱሰደር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ኮታይካ ክታ ካርንካ ጎርስምድባብከስ የሱሰም፥ “ኤስንባቦ! ር እችካ” ጋየሮ ክትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ኖ ማቼ፥ “የ ኤዝዳክንዳ እ እጅድንዳ እችም እስታ ዶቅዴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ኮካንታ ክታ ካርንካ ጎርስምድባብከስ፥ “ዋልቃ ኤደረ እችም ክትካንታ ተይᎺታ ዳቶ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","የሱሰረ፥ “እስታ እችምና እም ኦይችባብታ ጋይተን ይይንተኬ ክታ ፍክስንም ቦችዬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","የታ ‘አክ ኦይድ አርፍ ነገዴ፥ ኮታ ቡረረ ስክም ለእ ማዴ’ ኩን ጋይደት ካዮ? እታ ማቼ ‘ጬክን ጋይከቴ እስንንከስ ስክም ካንታ የልሳንደትም ሰድከቴ’ እታ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ስግድባብ ይንታ ናክን ተይዴ፥ ስለንክንደታ ዶቅንት ማድን አፍን ሳንዝዴ፥ ኮካንታ ማዝድባበረ፥ ስክድባብከረ የካ ጉርምደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ኮጎካ ‘ዋልቀና ማዝዴ፥ አብና ስግዴ’ ጋይምሳን ጋይተና ዶፈኔ። ");
INSERT INTO gyl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","እተረ የ ጋፋክንደትም የ ስክድንግንዳ የም ኦይቻቴ፥ አብንከስ ፍክስካ ጋፍሰኬ፥ የታ ማቼ ከታ ጋፍንታ አፍን የንታ ማስሰቴ ኩንጋየሮ ከትካንታ ማስሴ”። ");
INSERT INTO gyl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ኤተነረ “እ ፍክሳንደትም ሪን ሙዳ እካንታ ኬዜ” ጋይሶ ኮት ማርከርሳንደት ግንዳ ኮትኮ ካተመናርንካ በድ ሳማርያ ኤድንከስ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ኮካንታ ሳማርያ ፍጨናር ኤድንከስ የሱሰደር ከት ᎺዳንᎺይካ ከትካ ክክን ክት ዶቅድንግንዳ ክትም ምክሰኬ፥ ኖየረ ቃስተን ሰጫ ዋር ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ክታ ቃለንጎከረ አብ በድ ኤድንከሰረ ክትካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ኤተንንመረ “ይና ኮዘንካ ክትም ዎ አሜንድንደና የስ ዎም ኬዛን ቃለንካ Ꮊክ ማታክናና ዎታ ዎንታ ማታርንካ ዎ ኤሰርሳንካንተኬ ገታ ኖ ፍጫሙደንታ አቅስባብ ማቻንደትም ዎ ኤሳንካንቴ” ኮደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","የሱስ ሳማርያር ቃስተን ሰጫ ዶቅሳንደታ ቡር ገሊላር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ኖይንታ ማታርንካ “ሳብዘንካ ኤሰርሶ ኬዝድባብ ይንታ ገታ ፍጨንዘን ቦንችማዬ” ጋይሶ ከስታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ኬዛር ማቼ ገሊላር ክት የልሳንደትካ ገሊላ ኤድንከስ ኡርመካ ክትም ሞክሰኬ፥ ኮነረ ይይምሳንዳ ፋስጋ ባአልንካንታ የሩሳሌማር ክት አይሶ Ꮊቃንደትካ ክት ኮታር ይሳንደትም ሙዳ ከታ ይ ሰጃንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ኮታ ቡር የሱስ ሎቀንም ዎይን ዎጭም ማስሶ ክት ኦክሳን ገሊላ ፍጫር Ꮊፈርድን ቃና ካተመናር አናካርንካ ማቼ፥ ኮትᎺይካ ቅፍራናሆማር ክታ ይንች ሰቀርስባብ ዋልቃ ባንችንታ ዶርምስባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ኖየረ የሱስ ይሁዳ ፍጨናርንካ ገሊላር ክታ Ꮊድንም ኤሰርሶ ክደር አይሴ፥ ቅፍራናሆማር ክት Ꮊንቸርድንግንደኬ ዘና ሰቀርሶ ደእካንታ የልስባብ ይንችንም ክትካንታ ፋችዝድንግንዳ የሱሰም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","የሱሰረ “የታ አተንምኬ በርእዝድ ር የ ሰዳክንዳ ማቼ Ꮊረሰነረ የታ አመንዳከቴ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ኖ ዶርምስባብነረ “የባቦ! እስታ ይንችና ደእተርንደታ እር ዋደ ሳነካ Ꮊትካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","የሱሰረ “የስታ ኤር አይካ! የስታ ይንችና ሰንፔካ ዶቅተሬ” ክደር ጋይሴ። ኤችነረ የሱስ ኬዛንደትም ቃለን አሜንሶ ይንታ ኤሪ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ክት አይድንከረ ፍክስንባብከስ ጎግያር ክትም Ꮊፍስንደትከ “የስታ ይንችና ፋጭቴ” ጋይሶ ክደር ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ኖየረ ይንችና ኡርማ ክት ማቻን ሳዓትን ከትም ኦይሴ። ከተረ “ናካ ታብዛ ሳዓትንዘን ዘና ሶልና ክትም ዛቅሴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ባበነረ የሱስ “የስታ ይንችና ሰንፔካ ዶቅተሬ” ጋይሳንደረ ኮትኮ ሳዓትንዘን ማቻን ኖ ኤሴ፥ ኮካንታ ኮትኮ ሰጨንዘንካ የድሶ ክትኬ ኤር ኤድንካ ሙዳ የሱሰም አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ኮና አታ ቃዉተና የሱስ ይሁዳርንካ ገሊላር Ꮊድሶ ክት ይሳንዳ ቃስትምስ አታ ቃዉቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ኮታ ቡር አይሁድንከስታ ባአል ማቻንኦል የሱስ የሩሳሌማር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","የሩሳሌማር ቆልንከስታ ፍልተንታ ባንግር፥ እብራይስጥ አፈካ በቴሳይዳ ጋየርድንዳ ዋልቃ ከርምሳን ቱት ሎቃ Ꮊቄ፥ ኮታ ካንተንከረ ዶንቅ ኮታዘን ጉፍና ዶቅድንዳ ስገርድንዳ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","አንድር በድ ሰቀርስባብከስ፥ አፍይ ዝልንከስ ዎከልዎከል ጋይድባብከስኬ ዎብንከስ አይምድን ጎግንዘን እችሶ Ꮊቀኬ። ከታ ከነረ ሎቀንታ ሶክን ካርሰረኮ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ዋልቃ ዋልቃሰጭ ጮይስታ ክታይንችና ኬርምሳን ቱት ሎቀን Ꮊንቸርሶ ሶክሰሮ Ꮊቄ፥ ሎቀን ሶክሳንደታ ቡር እርምሶ ከርምሳን ሎቀናር አርድባብ ክታዘን ዶቅድን Ꮊምን ሰቅምንዘንካ ፋጨሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ኮታረረ ቦንደኬ ታሜኬ ላማካይ ስላ ሙዳ ሰቀርስባብ ዋልቃ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","የሱስ ኮ ኤችን ኮታር ራችንካ ሰድስንደትከ በድ ሰጨዘንካ የድሶ ክታ ሰቅርንም ኤስሶ፥ “አቅካንታ ዝግዳ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ሰቅምንባበረ “የባቦ! ሎቀና ሶግድናይካ እም ተዮ ከርምሳን ሎቀናር አርጅድባብ ኤድ እስታ ካዬ፥ እ አይትቴ ጋይድንካ አብና እም እርምሶ አርደኬ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","የሱሰረ “አምካ! የስታ ሰለንም ባልሰዮ አይካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ኤችነረ ሳነካ አቄ፥ ሰለንመረ ባልሶ አይሴ። ኮነረ ማቻንዳ አይሁድንከስታ Ꮊዉስ ሰጨንካ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ኮካንታ አይሁድንታ ገችንባብከስ ክትኮ አቃን ኤችን “ታካ Ꮊዉስ ሰጫ ማቻን ኦል ሰለንም የስ ባልድንግንዳ ህግና ጋያዬ” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ኖ ማቼ “እም አቅስባብ ኤችና የስታ ሰለንም ባልሶ አይካ” እም ጋይቴ ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ከተረ “የስታ ሰለንም ባልሰዮ አይካ የስም ጋይስባብ Ꮊይራ?” ጋየረኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ኤችና ማቼ ዎርሰና በጃን ኦልከ የሱስ ኮታርካ Ꮊርን ጋይሶ አይሳን ኦል ክትም አቅስባብ Ꮊይ ማቼረ ኤሳክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ኮታ ቡር የሱስ ኤችንም ሳብታ ጭል ኤሄናር ክትም Ꮊፍሶ “ኮሰቼ ታ አቅተዬ፥ ኮዘንካ ቦርሳን ር የዘን የልዳክንግንዳ ኮዘንካ ኦስ ጎማ Ꮊይፍክሴ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ኤችነረ አይስንደትከ ክትም አቅስባብ የሱስ ማትንተን አይሁድንታ ገችንባብከስካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ኮም ሪንም አይሁድንከስታ Ꮊዉስ ሰጨንካ ክት ይሳንካንታ አይሁድንከስታ ገችንባብከስ የሱሰም ዳይ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","የሱስ ማቼ “እስታ ባቤና ሙዳᎺይካ ፍግዝዴ፥ እተረ ፍግዝድቴ” ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ኮነረ ጋይንተና አይሁድንከስታ ገችንባብከስ የሱሰም ከት ደይዝድንግንዳ እንድንካ ከትም አምስሴ፥ ኮነረ ማቻንዳ ኖ አይሁድንከስታ Ꮊዉስ ሰጨንክታ ነክስንካ Ꮊክማታክ ናና “ሳብ እስታ ባበኔ” ጋይንተካ ይንታ ማተንም ሳብካ ክክን የክሳን ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","የሱሰረ፥ “ዶፈን፥ ዶፈን የም ጋይድቴ፥ ሳብ ባበና ፍግዝድንካ ይ ሰዳንደትም ፍክስዘንካ አብ ሳብ ይንችና ይንታ ገችታ ኤረንካ Ꮊረነረ ፍክስካንታ ማታዬ። ሳብ ባበን ይድንደትም ሳብ ይንችነረ ኮትግንዳ ይዴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ሳብ ባበና ይንታ ይንችን ሶልምድን ኦል ይ ፍግዝድንደትም ሙዳ ክትካንታ ሰችዝዴ፥ የተረ የ በርእተርንግንዳ ኮዘንካ ስግዳንደትም ፍክስነረ ክትም ሰጅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ሳብ ባቤና ደእስባብከስም አምዝድንግንደኬ ሰምፔም ከትካንታ እምድንግንዳ፥ ሳብ ይንችነረ ኮትኮግንዳ ሰንፓ ዝግድን ኤድካንታ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ሳብ ባቤና Ꮊየንዘነረ ፋረዳዬ፥ ኬዛር ማቼ ፍርደንም ሙዳ ይንታ ይንችንካንታ እምቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ኮመረ ክት ይሳንዳ ኤድንከስ ሙዳ ሳብ ባቤንም ቦንጅድንግንዳ፥ ኮትኮግንደረ ሳብ ይንችንመረ ቦንጅድንግንዴ፥ ሳብ ይንችንመረ ቦንጅዳክባብ፥ ሳብ ይንችንም ኦይችባብ ሳብ ባቤንም ቦንቻየኬ”። ");
INSERT INTO gyl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ዶፈን፥ ዶፈን የም እታ ጋይድቴ፥ እስታ ቃለንም ኤሰርድባብኬ እም ኦይችባብካ አሜንድባብ ስለንክንደታ ዶቅንት ክታ ዶቅዴ፥ ኖ ደእያርንካ ዶቅንትያር ቃልሳንኦል ፋረድምዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ዶፈን ዶፈን እታ የም ጋይድቴ፥ ደእስባብ ኤድንከስ ሳብ ይንችንታ ኡፍስንም ከት ኤሰርድንደታ ሰጫ Ꮊዴ፥ ሰጨነረ ታዬ፥ ኤሰርድባብከሰረ ሙደና ሰንፔካ ዶቅተረኬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ሳብ ባቤና ይንታ ማታ ሰንፔታ ቱት ይ ማቻንደትግንዳ ኮትኮግንደረ ይንችንመረ ሰንፔታ ቱት ክት ማድንግንዳ ይቴ”። ");
INSERT INTO gyl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ኤደት ይንች ማትንተንከረ ፍርደን ፋረድንግንዳ ገችታ ኤረን ክትካንታ እምቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ኮ ሪንከረ Ꮊይ በርእቴ፥ ዱክያር ዶቅድባብከስ ሙደና ክታ ኡፍስንም ከት ኤሰርድንደታ ሳዓት Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ኡርማ ፍክስባብከስ ደእያርንካ አምሶ ሰንፔካ ዶቅተረኬ፥ ዳቅልን ፍክስባብከስ ማቼ ደእያርንካ ከት አምሴ ከታዘን ፋረድምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“እታ እስታ ገችንታ ኤረንካ Ꮊረሰነረ ይካንታ ማታይተ፥ ኬዛር ማቼ ሳብ ባቤንዘንካ እ ኤሰርሳንደትም ፋረድቴ፥ እም ኦይችባብታ ጋይተንም ዳት እስታ ጋይተንም እ ይዳክንኦል እስታ ፍርደና ዶፈኔ። ");
INSERT INTO gyl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","እታ እጎካ እ ማርከርሴ እስታ ማርከርና ዶፈን ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ኬዛር ማቼ እጎካ ማርከርድባብ አብ ዶቅዴ፥ ኖየረ እጎካ ክት ማርከርድንዳ ማርክርና ዶፈን ማትንተን ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","የተረ ዮሀንሰደር ክተንባብከስም ኦይተት ዶቆ፥ ኖየረ ዶፈንንጎካ ማርከርቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ኮመረ እስታ ጋይንተና የ አቅተርንግንዳ ዳት እታ ኤታ ማርክርና እካንታ ዝክሳንካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ዮሀንስ የድንደትግንደኬ ሳግዝድንደት ሳክማግንዳ Ꮊቄ፥ የተረ መራ ሰጫካንታ ክታ ሳክመካ ጉርምካንታ ዝግዘቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","እታ ማቼ ዮሀንሰታ ማርክርዘንካ ስግዳንዳ ማርክር እስታ ዶቅዴ፥ እስታ ማርከነረ እስታ ባቤና እ ፍግዝድንግንዳ እካንታ እምሳንዳ ፍክስዬ፥ ኮነረ እ ፍግዝድንዳ ፍክስና፥ ሳብ ባቤና እም ኦይቻንግንዳ እጎካ ማርከርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","እም ኦይችባበረ ሳብ ባቤና፥ ይንታ ማታ እጎካ ማርከርቴ፥ የታ ማቼ ክታ ኡፍስንም ቦድሶ ኤሰራከቴ፥ Ꮊይም ክት ካምዳናንከረ ቦድሰቶ ሰዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ክት ኦይችባብም የ አሜንዳክንኦል ክታ ቃለና የንደር ዶቅተራክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","የታ ጭል ማጻፍንከሳር ስለንክንደታ ሰንፓ የᎺብድን የንደር ካምድንኦል ከትም ማስት ማስት ሰደቴ፥ ከተረ እጎካ ማርክርድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ማታጋካ ዳት የታ ዶቅንትን Ꮊፍካንታ እዝደር Ꮊድ ዝጋየቴ”። ");
INSERT INTO gyl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“እታ ቦንቼንም ኤድዘንካ ዝጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","የታ የንታ ቡዳርንካ ሳብም ሶልምዳክባብከስ የንታ ማትንተን እታ ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","እታ እስታ ባቤንታ ላምካ Ꮊዳቴ፥ የታ ማቼ እም ሞካከቴ፥ አብና ይንታ ላምካ Ꮊዳን ማቼ የታ ክትም ሞግደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","የታ ክክ ክክታ ቦንቸም ዝግድባብከስ ዋልቃ ሳብዘንካ Ꮊፈርድንደትም ቦንቸንም ማቼ ዝግዳክባብከስ፥ Ꮊስግንደንት አሜንካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","እታ እስታ ባቤንታ እሪ የም እ ካሰዝድን Ꮊይካማ፥ የም ካሰዝድባብ የ ጉርም ክታዘን ይድባብ ሙሴ። ");
INSERT INTO gyl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ሙሴም የ አሜንተስናና ኖየረ እጎካ ጻፍሳንካንታ እመረ አሜንተረትዶቆ። ");
INSERT INTO gyl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ክት ጻፍሳንደትም የ አሜናክንዳ ማቼ እስታ ቃለንም Ꮊስግንደንት አመንዳ?” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ኮታ ቡር የሱስ ጢባሮስ ጋይምድን ገሊላ ባሀርንታ ፋማ ቃልሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","በድ ኤድንከስ የሱስ ሰቀርስባብከስም ፋችካ ክት ይሳንደት አተንም ሰጃንኦል ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","የሱስ ገቸንዘን ዉትሶ ኮታዘን ይንታ ካርንካ ጎርስምድባብከስካ ክክን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","አይሁድንከሰተረ ፋስጋ ባአልና የልታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ኮትᎺይካ የሱስ በድ ዎርሳ ክደር Ꮊድንካ ጬክን ጋይሶ ሰድስንደትኬ ፍልጶሰም፥ “ኮ ሙዳ ኤድን ማድን እችም Ꮊምንኮንት ሰንዳ?” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","የሱስ ኮም ኬዛንዳ ፍልጶሰም ጰጫካንታ ዳት፥ ይ ይድንደትም ኖይንታ ማታ ኤዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ፍልጶሰረ “ዋልቃ ዋልቀን ካንታ መርሳ መርሳ አስም ዎራ ከትካንታ እምምድንግንዳ ቃስተን ጨታ ጣገራ ብረታ ሶለነረ ከትም ማታዬ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ክታ ካርንካ ጎርስምድባብከሳርንካ ዋልቀና ስምኦን ጴጥሮስታ እስመና እንደራሰረ ኩን ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ዶንቅ ጎስ ሶለኬ ቃስተን ሞላ የጅባብ ዋልቃ ይንች ኮታር ዶቅዴ፥ ኬዛር ማቼ ኮና ኮ ሙዳ ዎርሰንም Ꮊቦክ ማዳ?” ");
INSERT INTO gyl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","የሱሰረ “ኤድንከስ ከትዶቅድንግንዳ ይከቴ” ጋይሴ። ኮት ካርንዘነረ በድ ድራ Ꮊቄ፥ ኤድንከሰረ ዶቅሰኬ፥ ከታ ፋይደነረ ዶንቅ ሳአ ማድባብከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ኮታ ቡር የሱስ ሶለንም አምስሶ ይንታ ባበንደር ጋለቻንደታ ቡር ዶቅስባብ ኤድንከስካንታ የልስሴ። ኮትግንደረ ሞለንከስመረ ከትካንታ ካሴ፥ ሙደነረ ይም ዝግዝድንከካ Ꮊፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ሙደነረ እችሰኮ ምሳንደታ ቡር የሱስ ይንታካርንካ ጎርስምድባብከስም፥ “ዋልቃ ሪየረ ዉች ነግዳክንግንዳ ስጣንደት ዶከንም ሳንስከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ከተረ ኤድንከስ እችሶ ስጣን ዶከንም ዶንቅ ጎስ ሶለንታ ዶከንም ታመኬ ቃስተን ጋበትካ ጮችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ኤድንከሰረ የሱስ ይሳንደትም አተንም ከታ ሰጃንደትካ፥ “ገታ ኮና ኮ ፍጫሙደንዘን Ꮊድባብ ሳብዘንካ ኤሰርሶ ኬዝድባቤ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ኤድንከስ ማቼ ክት ዝጋክናና ተይ አይሶ ባንችምስካንታ ከት ገቀርሳንደትም ይ ኤሳንደትካ የሱስ ይንት አነታ ከታዘንካ ጎተርሶ ደንንዘን አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ሶይቻንደት Ꮊይከረ ክታ ካርንካ ጎርስምድባብከስ ባሃርንደር Ꮊንቸርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ሎቀንዘንካ ቃልዝድን ጃልበንካ ኦስ ቅፍራናሆም ካተመናር ሙክሰኬ፥ ኮት ሳዓትንከረ ፍጨና ኡምታ Ꮊቄ፥ የሱሰረ አክ ከደር Ꮊዳክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","አንድር ዞጋ ዞገሮ ዶቅድንኦል፥ ባሃርና ሶክሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ክታ ካርንካ ጎርስምድባብከሰረ ዋልቃ ኡል ማድን ከት በየሮ አይሳንደታ ቡር የሱስ ባሀርንታዘን ሙከሮ ሎቀንዘን ቃለርድን ጃልበንደር ክት የልድንካ ሰድሰኮ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","የሱስ ማቸ “እትቴ! Ꮊይጳሰቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ከተረ ጉርምካ ክትም ሞክት ሎቀንዘን ቃለርድን ጃልበናር ክትም አርችካንታ ዝግዘኬ፥ ሳነካ ጃልበና ከት አይድን ካርናር የልሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ዛማክንካ ባሀርንታ ፋማ ነገድባብ ኤድንከስ፥ ባሀርንታዘን ዋልቃ Ꮊክ ሎቀንዘንካ ቃለርድንዳ ጃልባ ዶቅድንኦል ኮትከረ ክታ ካርንካ ጎርስምድባብከስ ከታ ይንት አይሰኬ፥ የሱስ ማቸ ከትካ ክክን ጃልበናር አርዳክንደትም ሰተኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ማችንከረ አብ ሎቀንዘንካ ቃልዝድን ጃልበንከስ ጢባርያዶሳርንካ አምሶ የሱስ ይንታ ባቤንም ይ ጋለቻን ካርናርከ ዎርሰና ሶለን ከት እቻን ካርንታ ባንግር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ኤድንከሰረ የሱስ ናነረ ክታ ካርንካ ጎርስምድባብከስ ኮታር ከት ካየንደትም ሰዳንደትካ ከትኮ ሎቀንዘንካ ቃልዝድን ጃልበንከስካ አርድሰኮ የሱሰም ዝግመት ቅፍራናሆማር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ባሀርንታ ፋማ ክትም ከታ Ꮊፍሳንግንደረ፥ “ኤስስንባቦ፥ ካሪ Ꮊንተስ Ꮊዳሬ?” ከታ ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","የሱሰረ፥ “ዶፈን፥ ዶፈን የም ጋይድቴ፥ የታ እም የ ዝግድንዳ ሶላ የ እቻንካንተኬ የ ምሳንኦል ዳት አታ ቃዉተንም የ ሰጃንኦል ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ካይድን እችምካንታ Ꮊይ ፍክሰቴ፥ ስግስሰረ ሳብ ባቤና ክት ገታ ዶቅንት እችም ማትንተን መይምሳንኦል፥ ኤደት ይንች የካንታ እምድንደታ፥ ስለንክንደታ ዶቅንት ማድን እችምንካንታ ፍክስከቴ” ኩን ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ኤድንከሰረ “ይና፥ ሳብታ ፍክስንም ፍክስካንታ Ꮊራ ይ ዎም ዝግዝዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","የሱሰረ “ሳብታ ፍክስና ማቼ ሳብ ኦይችባብካ አመንሜ” ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ከተረ፥ “ዎታ ሰድሶቶ የስካ ዎ አሜንድንግንዳ Ꮊረስ አታ ቃዉተንም ይተራ? Ꮊረስ ፍክስተራ? ");
INSERT INTO gyl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","‘ከት እጅድን ግንዳ ጭላርንካ ሶላ ከትካንታ እምሴ’ ጋይምሶ ጻፍምሳንግንዳ፥ ዎንታ ባቤንከስ ዴል ቆቸናር ማኔን እችተኬ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ኮካንተረ የሱስ፥ ዶፈን፥ ዶፈን የካንታ ጋይድቴ፥ ጭላርንካ Ꮊንቸርሳን ሶለንም የካንታ እምስባብ ሙሴ ካዬ፥ ዶፈን ሶለንም ጭላርንካ የካንታ እምድባብ እስታ ባቤኔ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","“ሳብታ ሶለና ጭላርንካ Ꮊንቸርድንደትከ ፍጫ ሙደን ካንታ ሰንፐን እምድባቤ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ኮካንታ ኤድንከስ “የባቦ! ኮ ግንደን ሶለንም ሙዳᎺይካ ዎካንታ እምካ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","የሱሰረ፥ “ዶቅንት ሶለና እትቴ፥ እዝደርᎺድባብ ቦድሶ ዳቀራዬ፥ እንካ አሜንድባብ ቦድሰረ ዎቸራዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","የታ ማቼ እም ሰተቴ፥ ማችንከረ እንካ የታ አሜናከቴ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ሳብ ባበና እካንታ እምድን ሙደና እዝደር Ꮊዴ፥ እዝደር Ꮊድባብመረ ቦድሶ ኦስ ማል ዳያይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","እታ ጭላርንካ እ Ꮊንቸርሳንዳ እም ኦይችባብታ ጋይተን ይታ ካንታ ዳት እስታ ጋይተንም ይካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","እም ኦይችባብታ ጋይተንም፥ እም ክት እምሳንደት ሙደናርንካ ዋልቀረ ዎራ ካይሳክትዶቆ በእንታ ሰጨንካ ደእያርንካ ከትም አምዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ይዬ! እስታ ባቤንታ ጋይተና ሳብ ይንችንም ሰድባብኬ ክትካ አሜንድባብ ሙደና ስለንክንደታ ዶቅንትን Ꮊብድንግንዴ፥ እተረ በእንታ ሰጨንካ ደእያርንካ አምዝድቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ኮካንታ የሱስ “ጭላርንካ Ꮊንቸርስባብ ሶለና እትቴ” ጋይንተካ አይሁድንከስ ክታዘን ጉንድምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ኩነረ ጋይሰኬ፥ “ኮና ዮሰፍታ ይንች የሱስ ካዮ? እንደንምከ ባቤንምኬ ኤዝዶት ካዮ? ይና፥ ታ ኖ Ꮊስግንድክ ‘ጭላርንካ Ꮊንቸርሳቴ’ ኖ ጋይዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","የሱሰረ፥ ክክ ክክ Ꮊይ ጉንድመቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","እም ኦይችባብ ሳብ ባቤና ክትም ኤላክን የለልታ እዝደር Ꮊድካንታ ማድባብ Ꮊየሰነረ ካዬ፥ እዝደር Ꮊድባብም በእንታ ሰጨንካ ደእያርንካ አምዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ሳብዘንካ ኤሰርሶ ኬዝድባብከስታ ማጻፍንከስ ኤድንከስ ሙደና ሳብዘንካ ኤስባብ ማደኬ ጋይምሶ ጻፍምቴ፥ ኮካንታ ሳብ ባቤንዘንካ ኤሰርሶ ኤስባብ ሙደና እዝደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ኮም ጋይንተነረ ሳብ ባቤንም ሰጅባብ ኤድ ዶቅዴ ጋይንት ካዬ፥ ሳብ ባቤንም ሰጅባብ ሳብደርንካ Ꮊድባብ ኖ Ꮊክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ዶፈን፥ ዶፈን የም ጋይድቴ፥ (እንካ) አሜንድባብ ኤድ ስለንክንደታ ዶቅንት ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ዶቅንት ሶለነረ እትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","የንታ ባቤንንከስ ዴል ቆቸናር ማኔን እቸኬ፥ ኬዛርካ ማቼ ደእሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ጭላርንካ Ꮊንቸርሳንዳ ሶለና ኮኔ፥ ኮም ሶለንም እጅድባብ ቦድሰረ ደእዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ጭላርንካ Ꮊንቸርስባብ ዶቅንት ሶለንም እምድባብ እትቴ፥ ኮ ሶለንዘንካ እጅድባብ ሙደና ስለንካ ዶቅተሬ፥ ፍጫ ሙደን ካንታ ዶቅንት ማድንግንዳ እ እምድንዳ ሶለና እስታ ዋሄኔ ኩንጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ኮትኮ ሰጨንᎺይካ አይሁድንከስ “ኮና ኤችና ክታ ዋሄንም ዎ እጅድንግንዳ Ꮊስግንድክ እምካንታ ማዳ?” ጋይንተካ ክክ ክክ ከታ ቤርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ኮካንታ የሱስ፥ “ዶፈን፥ ዶፈን የም ጋይድቴ ኤደት ይንችታ ዋሄን የ እቻክን ማቼ፥ ማቀስንመረ የ ዎጫክን ማቼ ዶቅንት የንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","እስታ ዋሄንም እጅድባብኬ እስታ ማቀስንም ዎጭድባብ ሙደና ስለንካ ዶቅንት ዶቅዴ፥ እተረ በእንታ ሰጨንካ ደእያርንካ ክትም አምዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","እስታ ዋሄነረ ዶፈን እችሜ፥ እስታ ማቀስነረ ዶፈን ዎጭሜ። ");
INSERT INTO gyl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","እስታ ዋሄንም እጅድባብኬ እስታ ማቀስንም ዎጭድባብ ሙደና እንካ ዶቅተሬ፥ እተረ ክትካ ዶቅድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ስለንካ ዶቅድባብ ሳብ ባቤና እም ኦይቻንግንደኬ እተረ ክትካ ስለንካ ዶቅድባብ እ ማቻንግንዳ ኮትኮግንደረ እስታ ዋሄንም እጅድባብ ሙደና እንካ ስለንካ ዶቅድባብ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ይና ጭላርንካ Ꮊንቸርስባብ ሶለና ኮኔ፥ ኖየረ የንታ ባቤንከስ እቻንግንዳ ካዬ፥ ኮትኮም ሶለንም እችባብከስ ደእተኬ፥ ኮም ሶለንም እጅድባብከስ ማቼ ስለንካ ዶቅተረኬ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","የሱስ ኮም ክት ኬዛንዳ ቅፍረናሆም ካተመናር አይሁድንከስታ ምክስ ኤሄናር ኤስዝድንᎺይኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ክታ ካርንካ ጎርስምድባብከሳርንካ በድንከስ ኮም ከታ ይ ኤሰርሳንደትካ፥ “ኮና ኬዘና አንድሬ፥ Ꮊይ ተይካንታ ኮም ማዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","የሱሰረ ክታ ካርንካ ጎርስምድባብከስ ኮ ሪን ካንታ ከት ጉንድምዳክንግንዳ ይንታ አያንካ ኤስሶ፥ “ኮና ሪና የም ኮተርዝዶ? ");
INSERT INTO gyl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ኤደት ይንች ይ Ꮊቃንደታር ማትዮ ክት አይድንካ የታ ሰደቶ Ꮊረን ጋይተራ? ");
INSERT INTO gyl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ዶቅንትን እምድባብ ሳብታ አያነ፥ ኤታ ዎልቃ ማቼ Ꮊረነረ መያዬ፥ እታ የካንታ እ ኬዛንዳ ቃለና አያነ፥ አነረ ዶቅንትዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ኬዛር ማቼ የንታ ዎክያርንካ ዋልቃ ዋልቀንከስ አመንዳክባብከስ ዶቅደኬ” ከትም ጋይሴ። የሱስ ኮም ከትካንታ ክት ኬዛንዳ እርንደትዘንካ የድሶ አመንዳክባብከስ Ꮊይከስ ዶቅዳናንከረ ስክስት እምድባበረ Ꮊይማቼረ ይ ኤዝድ Ꮊቃንኦሌ። ");
INSERT INTO gyl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ኮታዘንከረ የሱስ “ሳብ ባቤንዘንካ ክትካንታ ጋይምሳንዳ ማታክንዳ ማቼ እዝደር Ꮊድካንታ ማድባብ ካዬ እ የንደር ጋይሳንደና ኮካንቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ኮታ ጎግካ ክታ ካርንካ ጎርስምድባብከሳርንካ በድንከስ ኦስ ቡር ማቼኬ፥ ኮት ሰጨንዘንካ የችሶ የሱሰም ጎርስምን ዛቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ኮካንታ የሱስ ታመከ ቃስተን ክታ ካርንካ ጎርስምድባብከስም፥ “የተረ ጉጅሶ አይካንታ ዝግደቴ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ኮት ሰጨንካ ስምኦን ጴጥሮስ፥ ኩንጋየሮ ማስሴ፥ “ጮይስዮ! Ꮊይደሮንት አይዳ? የዝደር ስለንካ ዶቅንትታ ቃላ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ዎታ ማቼ አመንቶቴ፥ ጭል ሳብታ ይንች የስ ማቻንደትም ኤስቶቴ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","የሱሰረ “የም የ ታሜከ ቃስተንከስም እዳክቶ? ኬዛር ማቼ የንታ ዎካርንካ ዋልቀና ዳብሎስዬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ኮመረ ክት ጋይሳንዳ ስምኦነታ ይንች አስቆሮንት ይሁዳጎካ Ꮊቄ፥ ይሁደረ Ꮊረሰነረ ዎራ ታሜከ ቃስተንናርንካ ዋልቀና ማችንከረ የሱሰም ስክስት እምድባብ ክት ማቻንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ኮታ ቡር የሱስ ገሊላር ኦንገሮ Ꮊቄ፥ አይሁድንከስ ክትም ደይስካንታ ዝገሮ ከትᎺቃንካንታ ኖ ማቼ ይሁዳር ኦንጋካንታ ዝጋክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ኮታይካ አይሁድንከስታ ዳልቻ ባአልና ቅንችታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ኮካንታ ክታ እስመንከስ የሱሰደር ቅንችሶ፥ “የስታ ካርንካ ጎርስምድባብከስ የስ ይድንደትም ፍክስን ከት ሰድንግንዳ ኮታርንካ አምሳዮ ይሁዳ ፍጨናር አይካ፥ ");
INSERT INTO gyl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","መየካ ኤስምካንታ ዝግድባብ ኤድ ይንታ ፍክስንም አቸካ ይዳክዬ፥ የነረ ኬና ሪንከስም ሙዳ የስ ይድንካ የስታ ማተንም ፍጫሙደንካንታ መያ ማስ የስም ዝግዝዴ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ኮመረ ከት ጋይሳንደና ክታ እስመንንከስ ዎራ ክትካ ከት አመናክን ኦሌ። ");
INSERT INTO gyl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","የሱሰረ፥ “እስታ ሰጨና አክ የላክዬ፥ የንታ ሰጨና ማቼ ሙዳᎺይካ ኡርሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","“ፍጫ ሙደነረ የም ግርካንታ ማታዬ፥ እታ ማቼ ፍክስና ዳቅል ማትንተን እ ማርከርድንኦል እም ግርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","የታ ባአልናር አይከቴ፥ እታ ማቼ እስታ ሰጨና አክ የላክንኦል ኮትኮ ባአልናር አይዳክቴ” ከትካንታ ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ኮመረ ጋይሶ ኖ ገሊላር ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ኬዛር ማቼ ክታ እስመንንከስ ባአልናር አይሳንደታ ቡር ኖ መየካ ማታክናና አጥምካ ባአልናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ባአልንታዘን “ኖ Ꮊብሬ?” ጋየረኮ አይሁድንከስ ዝገረኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ዎርሰነረ ክትጎካ ዎክስምካ ከዝምድ Ꮊቀኬ፥ ዋልቃ ዋልቀንከስ “ኖ ኡርማ ኤዴ” ጋይድንካ፥ አብንከስ ጉጅሶ “ኩን ካዬ ኖ ዎርሰንም ኮተርዝዴ” ጋየረኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ማታጋካ ዳት አይሁድንከስታ ገችንታ ኤረንባብከስም ጳስካ Ꮊየሰነረ ክትጎካ መየካ ከዛክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ባአልንታ ዎክገርዘን የሱስ ሳብታ ጭል ኤሄናር አይሶ ኤስስ የጄ። ");
INSERT INTO gyl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","አይሁድንከሰረ፥ “ኮና ኤችና ኤሳክዶቆ ኮም ሙዳ Ꮊስግንድክ ኤስካንታ ማቻሬ?” ጋየረኮ በርኤሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ኮካንታ የሱስ፥ “እስታ ኤስስና እም ኦይችባብ ሳብ ባቤንዘንካ Ꮊፈርድንዳ ዳት እዘንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","እም ኦይችባብታ ጋይተንም ይካንታ ዝግድባብ ዶቅሴ ኮም ኤስስንም ሳብዘንካ Ꮊፈርሳንዳ አነረ እታ እስታ ማታርንካ እ ኬዛንደት ማትንተን ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ይንዘንካ ኬዝድባብ ይንታ ማታ ቦንቻ ዝግዴ፥ ኦይችባብታ ቦንቸንም ዝግድባብ ማቼ ዶፈኔ፥ ማልት ክታዘን ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ሙሴ ህግን የካንታ እምታ ካዮ? ኬዛር ማቼ የንታ ዋርንካ ህግንም ቦድባብ Ꮊየነረ ካዬ። የታ Ꮊረተንት እም ደይስካንታ ዝግዳ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ዎርሰነረ “የዘን ግምዛ ዶቅዴ፥ Ꮊይ የስም ደይሳካንታ ዝግዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","የሱሰረ፥ “እታ ዋልቃ ፍክስ እ ፍክሴ፥ የተረ ሙደና ኮ ፍክስንካ በርእደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ሙሳ ሶላ ተችርታ ዎገንም የካንታ እምሴ፥ ኮነረ ዎገና Ꮊፈርሳንዳ፥ ባቤንከዘንካ ዳት ሙሴዘንካ ካዬ፥ የተረ አይሁድንከስታ Ꮊዉስ ሰጨንካ ኤድንታ ሶለንም ተጅደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ይና ሙሴታ ጎግካ እመርሳንዳ ህግና ነገዳክንግንዳ አይሁድንከስታ Ꮊዉስ ሰጨንካ ኤድንታ ሶለንም ተቸርድንዳ ማቼ ይና፥ እታ አይሁድንከስታ Ꮊዉስ ሰጨንካ ኤታ ኤደትቸንም እስታ ፋችንተንካ Ꮊረተንት ዋጭዳ? ");
INSERT INTO gyl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ዶፈን ፍርደን ፋረድከቴ ዳት ኤታ ባለም ሰድሰቶ ኦስነካ Ꮊይ ፋረደቴ” ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","የሩሳሌም ኤድንከሳርንካ ዋልቃ ዋልቀንከስ ኩን ጋይሰኬ፥ “ክትም ደይሳካንታ ከት ዝግድባብ ኤችና ኮና ካዮ? ");
INSERT INTO gyl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ይና፥ ኖ መየካ ኬዝዴ፥ ከተረ Ꮊረሰነረ ክትም ጋያከኬ፥ ኮና ኤችና ሳይምስባብ ማትንተንም ገችንታ ኤረንባብከስ ዶፈንካ ኤስተክ ዳቶ? ");
INSERT INTO gyl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ማችንከረ ኮና ኤችና Ꮊምንካ ክት ናነረ ዎታ ኤዝዶቴ፥ ሳይምስባብ Ꮊድንካ Ꮊምንካ ክት ናነረ ኤዝድባብ Ꮊየሰነረ ካዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ኮካንታ የሱስ ሳብታ ጭል ኤሄናር ኤስዝድዮ ይንታ ኡፍስንም ጬክሳ ይይሶ ኩን ጋይሴ፥ “እም የታ ኤዝደቴ፥ Ꮊምንካ እ Ꮊዳናንከረ የታ ኤዝደቴ፥ ኬዛርካ ማቼ እታ እስታ ገችታ ኤረካ Ꮊዳክቴ፥ እም ኦይችባብ ኖ ዶፈኔ፥ የታ ማቼ ክትም ኤዝዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","እታ ማቼ ክደርንካ እ Ꮊዳንጎከ ክት እም ኦይቻንካንታ እታ ኤዝድቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ኮት ሰጨንካ ክትም የድካንታ ዝግድ Ꮊቀኬ፥ ኬዛር ማቼ ሰጨና አክ የላክንኦል Ꮊየነረ ክትም የዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ማችንከረ ዎርሰናርንካ በድንከስ ክትካ አመንሰኬ፥ ኩነረ ጋይሰኬ፥ “ሳይምስባብ Ꮊድን ሰጨንካ ኮና ኤችና ክት ይሳን አታ ቃዉተንዘንካ ስግዳንደትም ይዶ?” ");
INSERT INTO gyl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ኤድንከስ የሱስጎካ ዎክስምካ ከት ከዝምድንካ ፈርሳዊያንንከስ ኤሰርሰኬ፥ ኮካንታ ቄሰንከስም ገችዝድባብከስኬ ፈርሳዊያንንከስኬ የሱሰም የችስ ካንታ ሳብታ ጭል ኤሄንታ ካርሰንባብከስም ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ኮት ሰጨንካ የሱስ “የንካ ክክን መራ ሰጫ ዶቅድቴ፥ ኮታ ቡር እም ኦይችባብደር አይድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","የታ እም ዝግተረቴ፥ ማችንከረ እም Ꮊፍተራከቴ፥ እ ዶቅድንደታር፥ የታ Ꮊድካንታ ማታየቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ኮካንታ አይሁድንታ ገችንታ ኤረንባብከስ፥ “ዎ ክትም Ꮊብዳክን ግንዳ ኮና ኤችና Ꮊብር አይካንተረ? Ꮊረንግርካ ግርክንከስታ ዎክያር ይጭምስባብ አይሁድንከዝደር አይሶ አይሁድ ማታክባብከስም ኤስስካንታ ዳቶ? ");
INSERT INTO gyl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘እም ዝግተረቴ፥ ኬዛር ማቼ Ꮊፍተራከቴ፥ እ ዶቅድንደታር የታ Ꮊድካንታ ማዳከቴ’ ጋይድንካ Ꮊራ ጋይንተሬ?” ክክን ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ባአልንታ በእንታ ማቻን ኤስምሳን ሰጨንካ የሱስ ዎእሶ ይንታ ኡፍስንም ጬክሳ ይይሶ፥ “ሎቃ ዎቸርስባብ ዶቅሴ እዝደር Ꮊድሶ ዎጫ፥ ጋይሶ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","እንካ አሜንድባብ ጭል ማጻፍና ጋይድንግንዳ፥ ዶቅንት ሎቀንታ ቱትና ክታ ዋርንካ ፉእዴ።” ");
INSERT INTO gyl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ኮመረ ክት ኬዛንዳ ክትካ አሜንድባብከስ ከት ተይድን አያን ጭልንጎካ Ꮊቄ፥ የሱስ አክ ቦንቸዘን ዉታክንኦል አያን ጭልና አክ እምማክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ኮካንታ ዎርሰናርንካ ዋልቃ ዋልቀንከስ ኮም ቃለንም ኤሰርሳንደትካ፥ “Ꮊዴ ጋየርስባብ ሳብዘንካ ኤሰርሶ ኬዝድባብ ገታ ኮኖ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","አብንከሰረ “ኮና ሳይምስባቤ” ጋይሰኬ። አብንከስ ማቼ “ሳይምስባብ Ꮊድንደና ገሊለንኮ? ");
INSERT INTO gyl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ሳይምስባብ ዳውተታ ሱሳርንካ አጥምድንግንደከ ዳውተታ ካተመን በተለሄማርንካ Ꮊድንደትም ጭል ማጻፍናር ጻፍምታ ካዮ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ኮካንታ ክትጎግካ ዎርሰንታ ዎክያር ፋስም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ዋልቃ ዋልቀንከስ ክትም የድካንታ ዝግታ Ꮊቀኬ፥ ኬዛር ማቼ Ꮊየሰነረ ክትም የዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ኮታ ቡር ካርስንባብከስ ቀሰንታ ገችንባብከዝደርኬ ፈረሳዊያንን ከዝደር ማት አይሰኬ፥ ከተረ “Ꮊረታ ክትም የ ተይ Ꮊዳክንደና?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ክትምስባብከሰረ “ኮና ኤችና ኬዝድንግንዳ Ꮊየሰነረ ኬዝሶ ኤሳዬ” ጋይሰኮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ፈረሳዊያንንከስ ማቼ፥ “የተረ ጉጅሶ ኮተርሰቴ? ");
INSERT INTO gyl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ꮊረንግርካ ገችንታ ኤረንባብከሳርንካ አነረ ፈረሳዊያንንከሳርንካ ክትካ አመንስባከስ ዶቅደኮ? ");
INSERT INTO gyl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ኮነረ ሙሴታ ህግንም ኤዝዳክን ዎርሰና ገታ ባድምስባበኬ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ኮታ እሪ የሱሰደር አይሶ Ꮊቅባብከ ፈረሳዊያንን ከሳርንካ ዋልቃባብ ንቀድሞስ፥ ");
INSERT INTO gyl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ዎንታ ህግንግንዳ ዋልቃ ኤድ ካሰስንታ ማስን እርምሶ ክታዘንካ ኤሰራክዶቆ Ꮊራ ክት ይሳናንከረ ኤስማክናና ክታዘን ፋረድምዶ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ከተረ “የነረ ገልላርንኮ? ሳብዘንካ ኤሰርሶ ኬዝድባብ ገሊላርንካ አምዳክንደትም ፋስት ኤስካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ዋልቃ ዋልቀነረ ይንታ ኤር ማቼ። ");
INSERT INTO gyl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ኮታ ቡር የሱስ ደብረዛይት ገቼንዘን አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ዛማክንከረ ዛማ ገልት ሳብታ ጭል ኤሄናር ማት Ꮊዴ፥ ዎርሰነረ ሙዳ ክደር Ꮊደኬ፥ ኖየረ ዶቅሶ ኤስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ህግንታ ኤስንባብከስኬ ፈረሳዊያንንከስ ኤተንና ቤልምድንካ የድምሳንደትም ተይᎺድሰኮ ዎርሰንታ ዎክያር ኮትም ዎይስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","የሱሰመረ፥ “ኤስስንባቦ፥ ኮሰቼ፥ ኮና ኤተና ኮት ቤልምድንካ ና የድምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ኮግንዳ ማነና ሰይንካ አቀርሶ ኮት ደእድንግንዳ ሙሳ ዎንታ ህግንካ ክቴ፥ የና ኮትጎካ Ꮊረስ ጋይዳ?” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ኮመረ ከት ጋይሳንዳ ክታዘን ክስታ ጎግ ከት Ꮊፍተርንግንዳ ክትም ጰጫካንታ ዝግሶ Ꮊቄ፥ የሱስ ማቼ ይርክን ጋይሶ ይንታ ግልኤካ ፍጨዘን ጻፍ የጄ። ");
INSERT INTO gyl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ካርንካ ካርንካ ኬት ክትም ኦይሳንደትካ ጬክን ጋይሶ፥ “የንታ ዎክያርንካ ጎማ ካየንባብ እርምሶ ሰይንካ ኮትም አቃ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ኮታ ቡረረ ካርንካ ይርክን ጋይሶ ፍጨዘን ጻፍሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ከተረ ኮም ኤሰርሳንደትካ ጋልተን ኬዘንካ የድሶ ሙደና ዋልቃ ዋልቃ ጋየረኮ ኮታዘንካ አይትበእሰኬ፥ ኮካንታ የሱስ ከታ ዎክናር ዎእሶ Ꮊቃን ኤተንከ ክትከ Ꮊክ ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ኮታ ቡር የሱስ ጬክን ጋይሶ፥ “የና ኤተኖ የስም ካሰስንባብከስ Ꮊማ? የዘን ፋረጅባብከስ Ꮊየሰነረ ካዮ?” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ናየረ “የባቦ! Ꮊየሰነረ ካዬ” ና ጋይሴ። የሱሰረ “እተረ የዘን ፋረዳክቴ፥ አይካ፥ ካርንካ ጎማ Ꮊይፍክሴ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ካርንከረ የሱስ “እታ ፍጫሙደንታ ሳክምቴ፥ እም ጎርስምድባብ ሙደና ሰንፔታ ሳክመን Ꮊብዴ፥ ኡምናረረ ኖ ኦንጋዬ” ጋየሮ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ፈረሳዊያንንከስ “የና የስታ ማታካንታ ማርከርደዬ፥ የስታ ማርከርና ዶፈን ካዬ” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","የሱሰረ፥ “Ꮊረሰነረ ዎራ እታ እስታ ማታ ካንታ እ ማርከርሰረ Ꮊብንካ እ Ꮊዳናንከረ፥ Ꮊብር እ አይዳናንከረ እ ኤዝድንካንታ እስታ ማርክርና ዶፈኔ፥ የታ ማቼ Ꮊብንካ እ Ꮊዳናንከ Ꮊብር እ አይዳናንከረ የታ ኤዝዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","የታ ዋሄታ ገቅርካ ፋረደቴ፥ እታ Ꮊየንዘነረ ፋረዳይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","እ ፋረጀረ ዎራ እም ኦይችባብ ሳብ ባቤና እንካ ክክን ማቻንጎከ እታ እስት እ ፋረዳይንካንታ እስታ ፍርደና ዶፈኔ። ");
INSERT INTO gyl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ቃሰተን ኤድንከስታ ማርክርና ዶፈን ማቻንደትም የንታ ህግናር ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ኮካንታ እታ እስታ ማታካንታ ማርከርድቴ፥ እም ኦይችባብ ሳብ ባቤና እጎካ ማርከርዴ።” ");
INSERT INTO gyl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ኮታይካ ከታ “የስታ ባቤና Ꮊማ?” ጋይሰኮ ክትም ኦይሰኬ። የሱሰረ “እመረ ማታ እስታ ባቤንም የታ ኤሳየቴ፥ እም የ ኤዝደስ ናና እስታ ባቤንመረ ኤዝደት ዶቆ” ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","የሱስ ኮም ቃለንም ክት ኬዛንደና ሳብታ ጭል ኤሄናር ብረንም ተየርድን ሳጥንታ ባንግር ዎእሶ ኤስዝድንኬ። ይና፥ ክታ ሰጨና አክ የላክንካንታ Ꮊየሰነረ ክትም የዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ካርንከረ የሱስ፥ “እታ አይድቴ፥ የተረ እም ዝግደቴ፥ ኬዛርካ ማቸ የንታ ጎመንካ የካ ደእደት ዳት እ አይድንደታር የታ Ꮊድካንታ ማተየቴ ጋይሶ ማስሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","አይሁድንታ ገችንባብከሰረ “ ‘እ አይድንደታር የታ Ꮊድካንታ ማታየቴ’ ክታ ጋይና ይንታ ማተንም ደይሳካንታ ማተርዳቶ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ኮታዘንከረ የሱስ፥ “የታ ታማርንከቴ፥ እታ ዘርማርንክቴ፥ የታ ኮ ፍጫሙደንዘንከቴ፥ እታ ኮ ፍጫሙደንዘንካ ካይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","እስታ ኤደትቸንም ኤስሰቶ የ አሜናክንዳ ማቼ የታ የንታ ጎመንካ የ ደእድባብከስ ማቻንካንታ የታ ደእደቴ እ ጋይሳንደና ኮካንቴ ኩን ከትም ጋይሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ከተረ “የና Ꮊይራ?” ጋይሰኬ። የሱሰረ፥ “እርንደትዘንካ አምስስቶ የካንታ እ ከዛንግንድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","የጎካ እ ከዝድንደትኬ እ ፋረድንደና በድ ሪ እዝደር ዶቅዴ፥ ማታጋካ ዳት እም ኦይችባብ ኖ ዶፈኔ፥ እተረ ኮ ፍጫሙደንካንታ እኬዝድንደና ክታዘንካ እ ኤሰርሳንደትሜ ኩን ከደር ጋይሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ከታ ማቼ ሳብ ባቤንጎካ ክት ኬዛንዳ ከትም አርዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ኮካንታ የሱስ፥ “ኤድ ይንችም ጬክሳ ይሴቶ የ ሮግድንᎺይካ እ ክት ማቻንደትም የታ ኤስተረቴ፥ ኮትኮግንደረ ሳብ ባቤና እም ኤስሳንደትም እ ኬዝድንግንዳ ዳት እስታ ገችታ ኤረንካ Ꮊክ Ꮊረሰነረ እ ይዳክንደትም ኮትᎺይካ የታ ገቀርተረቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","እም ኦይችባብ እንካ ክክኔ፥ ሙዳᎺይካ እ ይድንደና ክትም ጉርምዝድን ሪ ማቻንካንታ እም Ꮊክ ኖ ዛቃክዬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","የሱስ ኮም ከዛንደትᎺይካ በድ ኤድንከስ ክትካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","የሱስ ክትካ አሜንስባብ አይሁድን፥ “የታ እስታ ቃለናር የ ዶቅሴ ገታ እስታ ካርንካ ጎርስምድባብ ማተረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ዶፈንን የታ ኤዝደቴ፥ ዶፈነረ ዉች የም ዉችዝዴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ከታ ማቼ። “ዎታ አብራሀመታ ይንቾቴ፥ ቦድሶ Ꮊየንካንተረ አይላ ማትሶቶ ኤዝዳኮቴ፥ ይና፥ የና ‘ዉች ዉተረቴ’ የስ ዎም ጋይድንደና Ꮊስግንደረ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","የሱሰረ፥ “ዶፈን ዶፈን የም ጋይድቴ፥ ጎማ ፍግዝድባብ ሙደና ጎመታ አይሌ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","አይላ ሙዳᎺይካ ኤር ዶቃዬ፥ ይንች ማቼ ሙዳᎺይካ ኤር ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ኮካንታ ሳብ ይንችና ዉች የም ዉችሴ ገታ ዉች ማደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","አብራሀመታ ይንች የንታ ማትንተንም እታ ኤዝድቴ፥ ኬዛር ማቼ እስታ ቃለንም የ ተይዳክንካንታ እም ደይሳካንታ ዝግደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","እታ እስታ ባበንታ ባንግር እ ሰዳንደትም ኬዝድቴ፥ የታ ማቼ የንታ ባቤንዘንካ የ ኤሰርሳንደትም ይደቴ ኩንጋየሮ ከትካንታ ማስሴ።” ");
INSERT INTO gyl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ከተረ “ዎንታ ባቤነና አብራሀሜ” ጋየረኮ ክትካንታ ማስሰኬ። የሱሰረ፥ “አብራሀመታ ይንች የ ማቸስ ናና አብራሀመታ ፍክስንም ፍግዝደትዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","እታ ሳብዘንካ እ ኤሰርሳንደትም ዶፈንን የካንታ ከዛቴ፥ የታ ማቼ ደይሳካንታ እም ዝግደቴ፥ አብራሀመረ ኩን ይያክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ይና የታ የ ፍግዝድንደና የንታ ባቤንታ ፍክስኔ” ኩን ከትም ጋይሴ። ከተረ “ዎታ ቤልምካ አጥምሶ ቡቅምስባብ ካዮቴ፥ ዋልቃ ዎንታ ባቤና ዶቅዴ፥ ኖየረ ሳብዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","የሱሰረ፥ “ሳብ የንታ ባቤና ማታናና እም ሶልምደት ዶቆ፥ እታ ኮር እ Ꮊዳንዳ ሳብደርንከ፥ እም ኦይችባብ ኖ ዳት እታ እስታ ገችንታ ኤረንካ Ꮊዳክቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ꮊረተረ እስታ ኬዘና የም አርዳይንደና? እስታ ኬዘንም ኤስርካንታ የ ዝጋይንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","የታ የንታ ባቤን ዳብሎስታ ይንቸቴ፥ የንታ ዝግመትነረ የንታ ባቤንታ አግርንም ቦችዬ፥ ኖ እርንደትዘንካ የድሶ ሰንፓ ደይዝድባብ Ꮊቄ፥ ዶፈና ክትካ ካየንካንታ ዶፈንካ ክክን Ꮊረሰነረ ዋልቃትች ክታ ካዬ፥ ኖ ካርካባብኬ ካርካ ሙደንታ ባቤና ማቻንካንታ ካርከን ከዝድንደትᎺይካ ይንታ ማታርንካ ዉችሶ ኬዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","እታ ማቼ ዶፈንንም እ ከዝድንካንታ እም የታ አመንዳከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ማችንከረ የንታርንካ ‘የና ጎማ ባበዬ’ ጋይሶ እም ዳቅልካ ኬዝተርባብ Ꮊይራ? ዶፈንንም እ ኬዝድንዳ ማቼ ኮናና፥ Ꮊረተረ እም የ አመንዳከንዳ? ");
INSERT INTO gyl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ሳብደርካ ማችባብ ሳብታ ቃለንም ኤሰርዴ፥ ይና የታ ሳብታ ቃለንም ኤሰርዳክባብከስ፥ ሳብደርንካ የ ማታክንካንቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","አይሁድና “የና ሳማራ ኤደዬ፥ ግምዘረ የዘን ዶቅዴ፥ ዎንታ ጋይንተና ገታ ካዮ?” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","የሱሰረ፥ “እዘን ግምዛ ካዬ፥ ኬዛር ማቼ እስታ ባቤንም ቦንጅድቴ፥ የታ ማቼ እም ቶጅደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ማታጋካ ዳት እታ እስታ ማታ ቦንቸን ዝጋይቴ፥ እስታ ቦንችምን ዝግድባብከ ፋረድባብ አብ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ዶፈን፥ ዶፈን የም ጋይድቴ፥ ቃለንም ካርዝድባብ ቦድሶ ደእዳክዬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","አይሁድንከስ፥ “ግምዛ የዘን ዶቅድንደትም ታ ኤሶቴ፥ አብራሀም ዎራ ደእቴ፥ ሳብዘንካ ኤሰርሶ ኬዝድባብከሰረ ደእተኬ፥ የና ማቼ ‘እስታ ቃለንም ካርዝድባብ ደአዬ’ ጋይደዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ማችንከረ የና ደእስባብ ዎንታ ባቤን አብራሀምዘንካ ስግዳ? ሳብዘንካ ኤሰርሶ ኬዝድባብከስ ደእተኬ፥ ኮናና የና የስታ ማተን Ꮊይመስ ማስዝዳ?” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","የሱሰረ፥ “እታ እስታ ማተንም እ ቦንችሴ እስታ ቦንቸና መያዬ እም ቦንጅድባብ እስታ ባበኔ፥ ኖየረ ‘የታ ዎንታ ጮይስዬ’ የ ጋይድባቤ። ");
INSERT INTO gyl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ማችንከረ የታ ክትም ኤሳከቴ፥ እታ ማቼ ኤዝድቴ፥ እታ ክትም ኤዝዳክቴ እ ጋይዴ የግንዳ ካርካባብ ማድት ዶቆ፥ እታ ማቼ ክትም ኤዝድቴ፥ ክታ ቃለንመረ ካርዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","የንታ ባቤን አብራሀመታ አግርና እስታ ሰጨንም ሰድሶ ጉርምካንታ Ꮊቄ፥ ሰድሰረ ጉርምሴ” ኩን ጋይሶ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ኮታይካ አይሁድና፥ “የስታ አክ ቃስተን ቦንደከታማ ስላ ዎራ የስታ ማታክዬ፥ ኮናና Ꮊስግንደስ አብራሀመም ሰትቴ ጋይዳ?” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","የሱሰረ “ዶፈን፥ ዶፈን የም ጋይድቴ፥ አብራሀም አጠርተርንርደታ እሪ እታ ዶቅድቴ፥ ታየረ ኦስ እረረ ዶቅድቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ኮካንታ አይሁድንከስ ክትም አቅና ካንታ ሰይን አምሰኬ፥ የሱስ ማቸ ከታዘንካ አጥምስንደትከ ሳብታ ጭል ኤሄናርንካ ዉትሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","የሱሰረ ኮትኮ ጎግንካ ስገድንካ አፍይ ዝልይ ማትሶ አጥምስባብ ኤችም ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ክታ ካርንካ ጎርስምድባብከስ የሱሰም “ኤስስንባቦ፥ ኮና ኤችና ዝልይ ማትሶ ክት አጥምሳንዳ Ꮊይታ ጎመከረ? ይንታ ጎመኮ አና ክትም አጭባብከስጎኮ?” ጋየረኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","የሱሰረ፥ “ኮና ኤችና ዝልይ ማትሶ ክት አጥምሳንዳ ክትጎካ አነረ አጥመንባብከስታ ጎመንጎካ ካዬ፥ ኬዛር ማቼ ሳብታ ፍክስና ክትካ መያ ማተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ሰጨና ዶቅድንካ እም ኦይችባብታ ፍክስንም ፍክስ እም ዝግዝዴ፥ Ꮊየነረ ኤድ ፍክስካንታ ማዳክንዳ ሶይትና Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ኮ ፍጫሙደንዘን ዶቅድቶ እታ ፍጫሙደንታ ዎርሰንካንታ ሳክምቴ” ኩን ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ኮም ይ ኬዛንደታ ቡር ፍጨዘን ፈጭምሶ ይንታ ፈጭምንካ ፍጨንም ቶቀልስሶ ቶቅለንከረ ዝልንታ አፍን ሳይስንደትኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“አይሳዮ ሳሎም ከርምሳን ሎቀናር ስኤርካ” ክትም ጋይሴ። (ሳሎም ጋይንት “ኦይትምስባብ” ጋይንትዬ) ኮካንታ ኤችና አይሶ ስእርንደትኬ ሰደሮ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","የለንከስኬ ኤና እሪ ክት ምግዝድንካ ሰድᎺቅባብከስ “ኮና ኤችና ዶቅሶ ምክሰሮ Ꮊቅባብ ኖ ካዮ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ዋልቃ ዋልቀንከስ “ይዬ፥ ኖዬ!” ጋይሰኬ፥ አብንከስ ጉጅሶ “ክትም ካምዳ ዳት ኖ ካዬ!” ጋይሰኬ። ኖ ማቼ “እትቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ኤድንከሰረ “ኮናና የስታ አፍንከስ Ꮊስግንዶክ ፎችምሳሬ?” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ኖየረ “የሱስ ጋይምስባብ ኤች ቶቅላ ቶቀልስሶ እስታ አፍንከስም ሳይሶ ‘ኦስ ሳሎማር አይሳዮ ስኤርካ’ እም ጋይሴ። እተረ አይስቶ ስኤርስቶ ሰድንካንታ ማቻቴ” ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ከተረ “ኖ ኤችና ታ Ꮊብረረ?” ጋይሰኬ። ኖየረ “Ꮊብር ክት ዶቅዳናንከረ እታ ኤሳይቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ኮታ ቡር ኤድንከስ አፍይ ዝልን ማትሶ Ꮊቅባብ ኤችን ኦስ ፈረሳያዊንንከዝደር ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","የሱስ ቶቅለንካ ኤችንታ አፍን ከስ ሰድንግንዳ ክት ይሳንዳ አይሁድንታ Ꮊዉስ ሰጨንካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ፈረሳዊያንንከስ “Ꮊስግንደስ ሰድካንታ ማቻሬ?” ጋይሰኮ ኤችንም አናካርንካ ኦይሰኬ። ኖየረ “እስታ አፍንከዘን ቶቅላ ሳይስንካ ስኤርስቴ፥ ኮታ ቡር ሰድንካንታ ማችቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ኮትᎺይካ ፈርሳውያንከሳርንካ ዋልቃ ዋልቀንከስ፥ “ኮና ኤችና አይሁድንታ Ꮊዉስ ሰጨንም ክት ቦንጅዳክን ኦል ሳብዘንካ ካዬ” ጋይሰኬ። አብንከስ ማቼረ “ኮናና ጎመካ ማችባብ ኤድ ከነም አታ ቃዉተን Ꮊስግንድክ ፍክስካንታ ማዳ?” ጋይሰኬ። ኮጎካ ከታ ዎክያር ፋስም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ኮካንታ አፍይ ዝልይ Ꮊቅባብ ኤችና፥ “የና የስታ አፍንከስም ሰችሴ የስ ጋይድን ኤችንጎካ የና Ꮊረስ ጋይዳ?” ጋየረኮ ጉጅሶ ክትም ኦይሰኬ። ኖየረ “ሳብዘንካ ኤሰርሶ ኬዝድባቤ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ኮና ኤችና አፍይ ዝልይ ማትሶ ክት Ꮊቃንደትምኬ ክታ አፍንከሰረ ቡር Ꮊስግንዳ ፎችምሳናነረ ክትም አጭባብከስም ኤልሶ ከታ ይ ኦይስተርን የለልታ አይሁድንታ ገችንታ ኤረንባብከስ አሜናከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ኮካንታ ክትም አጭባብከስም፥ “ዝልይ ማትሶ አጥምሴ የ ጋይድባብ የንታ ይንችና ኮና ኖ? ታ Ꮊስግንድክ ሰድንካንታ ማቻራ?” ጋየረኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ክትም አጭባብከሰረ፥ “ኮና ዎንታ ይንች ክት ማቻንደትምከ ዝልይ ማትሶ ክታ አጥርን ኤዝዶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ኬዛር ማቼ ታ Ꮊስግንዳ ክት ሰዳናነረ አፍንከስመረ Ꮊይ ክትካንታ ሰችሳናነረ ዎታ ኤሳዮቴ፥ ክትም ኦይስከቴ፥ ኖይንታ ማተን ኤስባብ ክት ማቻንካንታ ኖ ይጎካ ኬዛካንታ ማዴ” ኩንጋየሮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ክትም አጭባብከስ ኮም ከት ጋይሳንዳ የሱሰም “ሳይምስባቤ” ጋይድባብ ኤድ ዶቅሴ አይሁድንከስታ ገችንታ ኤረንባብከስ አይሁድንታ ምክስ ኤሄናርንካ ክትም ዉችካንታ ክክን ከት ኤእሶ Ꮊቅንካንታ ከትም ጳስኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ኮካንታ ክትምአጭባብከስ፥ “ኖይንታ ማተን ኤስባብ ኤዴ፥ ክትም ኦይስከቴ” ኩን ጋየረኮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ኮጎካ ዝልይ ማትሶ Ꮊቅባብ ኤችን አነታ ኤልትዮ “የና ዶፈንን ኬዝካ ሳብም ቦንችካ፥ ኮና ኤችና ጎማባብ ማትንተን ዎተረ ኤዝዶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ዝልይ ኤችነረ፥ “ኖ ጎማባብ ክታ ማትንተንም እታ ኤሳይቴ፥ ዋልቃ ሪ ኤዝድቴ፥ ኮነረ እታ ዝልይ ማትስቶ እ Ꮊቃንደትምኬ ታ ሰድንካንታ እ ማቻንደትም ኮም Ꮊክ ኤዝድቴ” ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ከተረ “Ꮊርክ የስካንታ ይሳሬ? የስታ አፍንከስም ክት ሰድንግንዳ ይስሳንዳ Ꮊስግንደረ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ኖየረ “እርምስቶ የም ከዛቴ፥ የታ ማቼ ኤስርካንታ ዝጋከቴ፥ ይና፥ Ꮊራካንተንት አናካርንካ ኤስርካንተንት ዝግዳ? የተረ ክታ ካርንካ ጎርስምድባብ ማትካንታ ዝግደቴ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ከተረ፥ “ክታ ካርንካ ጎርስምድባብ የነዬ፥ ዎታ ማቼ ሙሴታ ካርንካ ጎርስምድባቦቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ሳብ ሙሴም ከስሳንደትም ኤዝዶቴ፥ ኮና ኤችና ማቼ Ꮊብርንካ ክት ናነረ ዎታ ክትም ኤሳዮቴ” ኩን ጋየረኮ ክትም የክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ኤችነረ፥ “ኮና ኤችና Ꮊብርንካ ክት ናነረ የንታ ኤስክሳ ነግና በርእስዝዴ! ኬዛር ማቼ እስታ አፍንከስም ሰችስባብ ኖዬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ሳብ ጎመንባብከስም ኤሰርዳክንዳ ኤስምሳንዴ፥ ኬዛር ማቼ ሳብም ጎይንድባብከ ክታ ጋይተንም ቦድባብ ኤድ ዶቅሴ ክትም ሳብ ኤሰርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ዝልይ ማትሶ አጠርምስባብ ኤታ አፍንከስም ሰችስባብ ዶቅዴ ጋይምድንካ ፍጫ ሙደና ፍዝምሳንደትዘንካ የድሶ ኤስርምሶ ኤስማዬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ኮና ኤችና ሳብዘንካ ይ ማታክናና Ꮊረሰነረ ይካንታ ማታይ ዶቆ” ኩን ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ከተረ “የስታ ኤደትቼና ጎመካ ጮጭንካ አጥምስባብ! የና ዎም ኤስስካንቶ?” ጋይሰኮ አይሁድንታ ምክስ ኤሄናርንካ ክትም ዉችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ኤችንም አይሁድንታ ምክስ ኤሄናርንካ ዉችሳንደትም የሱስ ኤሰርሴ፥ ክትም Ꮊፍሳንደትከረ “ኤደት ይንችካ የና አመንዳ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ኖየረ “ጮይስዮ! ክትካ እ አሜንድንግንዳ ኖ Ꮊይራ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","የሱስ “ኮታ እሪ የና ክትም ሰተዬ፥ ታየረ የስም ከስዝድባብ ኖዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ኖየረ “ጮይስዮ! እታ አመንድቴ” ጋይሶ ክትካንታ ጎስትሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","የሱሰረ “ሰዳክባብ ሰድንግንዳ፥ ሰድባብከሰረ ከታ አፍና ዝልድንግንዳ እታ ኮ ፍጫሙደንዘን ፋረድካንታ Ꮊትቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ኮታይካ የሱሰታ ላመር Ꮊቅባብከስ ፈረሳዊያንንከስ ኮም ኤሰርሰኮ “ኮናና ዎተረ ዓፊይ ዝል ማቾቶ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","የሱሰረ “ዝልንከስ የ ማተስናና ጎማ የንታዘን ማዳክዶቆ፥ ታ ማቼ ሰዶቴ የ ጋይድንካንታ፥ ጎመንክንባብከስ ማትሰቶ ነገደቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ኮታዘንከረ የሱስ፥ “ዶፈን፥ ዶፈን የም ጋይድቴ፥ ቆልንከስታ ካለንደር ፍልተካ ማታክናና አብጎካ አርድባብ ኤድ ድብኬ ፋንገኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ፍልተንካ አርድባብ ማቸ ኖ ቆልንከስታግስመንባቤ። ");
INSERT INTO gyl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ክትካንታ ፍልተንታ ካርስንባብ ፍልተን ክትካንታ ፎጅዴ፥ ክታ ቆልንከስ ክታ ኡፍስን ኤሰርደኬ፥ ኖየረ ይንታ ቆልንከስም ከታ ላምንካ ከትም ኤልዴ፥ ከትም ጎርሰሮ ማል ዉችዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ይንታ ቆልንከስም ይ ዉችሳንደታ ቡረረ ከታ እሪ እሪ ኖ አይዴ፥ ክታ ቆልንከሰረ ክታ ኡፍስን ይ ኤዝድንካንታ ክትም ጎርስምደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","አብንታ ኡፍስንም ማቼ ከታ ኤዝዳክንካንታ ክታዘንካ አጥምደክ ዳት ጎርስምዳከኬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","የሱስ ኮም ካምስንም ከትካንታ ኬዜ፥ ከታ ማቼ ኬዛንደትም ገቀርት ተያከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ኮካንታ የሱስ ካርንካ፥ ዶፈን፥ ዶፍን የም ጋይድቴ፥ እታ ቆልንከስታ ፍልትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","እስታ እሪ Ꮊድባብከስ ሙደና ድብንከስኬ ፋንገንከሰኬ፥ ቆልንከስ ማቼ ክትም ኤሰራከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ፍልተና እትቴ፥ እዝደርጎካ አርድባብ አቅዴ፥ አርዴ፥ ዉዴ፥ ግስምድን ካረረ Ꮊብዴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ድብና Ꮊድንዳ ድብካንታ፥ ማችካንተኬ ካይስካንታ Ꮊክዬ፥ እታ ማቼ እ Ꮊድንዳ ሰንፓ ከት Ꮊብድንግንደኬ ጮጭ ማቻን ዶቅንትን ከት ዶቅተርንግንዳ ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ኮትኮግንደረ “ኡርማ ግስመንባብ እትቴ፥ ኡርማ ግስመንባብ ይንታ ሰንፔንም ይንታ ቆልንከስካንታ ስክስት እምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ቆልንከስ ክታ ማታክባብ ሰጫካንታ ዳት ዶፈን ማታክን ግስመንባብና ማቼ ፉገና Ꮊድንካ ኖ ይ ሰዳንደትካ ቆልንከስም ዛቅሶ አጥምዴ፥ ፉገነረ ቆልንከስም ቡርሶ ከትም ይጭዴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ግስመንባብና ክት አጥምድንደረ ሰጫካንታ ግዝድባብ ማቻንካንተኬ ቆልንከስካንተረ ገቀርዳክንኦሌ። ");
INSERT INTO gyl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ኡርማ ግስመንባብ እትቴ፥ እታ እስታ ቆልንከስም ኤዝድቴ፥ እስታ ቆልንከሰረ እም ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","እታ ከትም እ ኤዝድንዳ ሳብ ባቤና እም ኤዝድንደትግንደኬ እተረ ሳብ ባቤንም እ ኤዝድንደትግንዴ፥ እታ እስታ ቆልንከስካንታ እስታ ሰንፔንም ስክስት እምድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ኮ ዉደንከስታ ዋር ማታክባብከስ አብ ቆልንከስ እስታ ዶቅደኬ፥ ከትመረ ተይ Ꮊድንት እም ዝግዝዴ፥ ከታ እስታ ኡፍስን ኤሰርደኬ፥ ዋልቃ ዉዳ ማደኬ፥ ግስመንባበረ ዋልቃ ማዴ”። ");
INSERT INTO gyl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“አናካርንካ ማስት እ ኮትም ተይተርንግንዳ ሰንፔን እስታ እ እምድንካንታ ሳብ ባቤና እም ሶልምደ። ");
INSERT INTO gyl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","እስታ ሰንፔንም እስታ ጋይተካ እምድት ዳት እዘንካ ኮትም ተይድባብ Ꮊየነረ ካዬ፥ እስታ ሰንፔንም እምካንተኬ ማስት ተይካንታ ገችታ ኤራ እስታ ዶቅዴ፥ ኮም ክተንም እ ተያንዳ እስታ ባቤንዘንኬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ኮ ኬዘንዘንካ አምሳንዳ አይሁድንከስታ ዎክያር አናካርንካ ፋስም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ከታርንከረ በድንከስ፥ “ክታዘን ግምዛ ዶቅዴ፥ ኤይቴ፥ Ꮊረተንት ክትም ኤሰርዳ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","አብንከስ “ኮና ኬዘና ግምዛ ዶቅድን ኤታ አድማርንካ ዉድንዳ ካዬ፥ ግምዘና ዝልንታ አፍን ሰችካንታ ማትሮ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","የሩሳሌማር ሳብታ ጭል ኤሄን ኡርስታ ባአልን ቦንችምድን ሰጨና የልሴ፥ ለእነረ በርግ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","የሱስ ሳብታ ጭል ኤሄናር ሰለሞንታ ኤሄንታ ፍልተዘንጎካ ኦንገሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ኮትᎺይካ አይሁድና ክታ ካንተንካ ሳንሰኮ፥ “Ꮊንታ የለልተስ Ꮊኤርካ ዎም ዶቅስተራ? የና ሳይምስባብ የስ ማቻን መያ ዎም ከስካ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","የሱሰረ፥ “እታ የም ከዝትቴ፥ የታ ማቼ አመንዳከቴ፥ እስታ ባቤንታ ላምካ እ ፍግዝድን ፍክስና እጎካ ማርከርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","የታ ማቼ እስታ ቆልንከሳርንካ የማታክን ካንታ አመንዳከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","እስታ ቆልንከስ እስታ ኡፍስን ኤሰርደኬ፥ እተረ ከትም ኤዝድቴ፥ ከተረ እም ጎርስምደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","እታ ስለንክንደታ ዶቅንትን ከትካንታ እምድቴ፥ ኮካንታ ቦድሶ ካይዳከኬ፥ እስታ አንያርንካ Ꮊየነረ ዉስት ከትም ተያዬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ከትም እካንታ እምስባብ እስታ ባቤና ሙደንዘንካ ስገዴ። እስታ ባቤንታ አንናርንካ ከትም ዉስትዮ ተይካንታ ማድባብ Ꮊየነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","እንከኬ ሳብ ባቤንካ ዋልቆቴ” ኩን ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ኮትኮᎺይካ አይሁድና የሱሰም አቅና ካንታ አነታ ሰይን አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","የሱሰረ “ሳብ ባቤንደርንካ በድ ኡርማ ፍክስንከስም የም ሰችስቴ፥ ይና ኮናና፥ የ እም አቅድንዳ ከትከናከሳርንካ Ꮊምን ፍክስንጎከረ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","አይሁድነረ “ዎ የስም አቅድንዳ ሳብዘን የክይ ኬዘን የስ ኬዛንካንታ ዳት የስታ ኡርማ ፍክስንካንታ ካዬ፥ ኮነረ የና ኤድ ማትሶ ዶቅደዮ፥ የስታ ማተንም ጮይስ የስ ማስሳን ካንቴ” ጋየሮ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","የሱሰረ፥ “የንታ ህግናር ‘የታ ጮይስንከሰቴ እታ ጋይሳቴ’ ጋይድንዳ ጻፍምታ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ይና ጭል ማጻፍንም ሳይማዬ፥ ሳብታ ቃላ ከትካንታ Ꮊዳንደትም ጭል ማጻፍን ጮይስንከሰኬ ጋይሶ ከት ኤልሴ ");
INSERT INTO gyl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ኮናና፥ ሳብ ባቤና ይንታ ክትም ፋሳንደትምኬ ኮ ፍጫሙደንዘን ኦይችባብም ‘እታ ሳብታ ይንችቴ’ ክት ጋይሳንካንታ Ꮊረታ ‘ሳብዘን የክይ ኬዘን ከዝደዬ’ የታ ክትም ጋይደቴ? ");
INSERT INTO gyl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","እታ እስታ ባቤንታ ፍክስን እ ፍክሳይንዳ ማቼ እም Ꮊይ አሜነቴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","እስታ ባቤንታ ፍክስን እ ፍግዝድባብ ማቼ እንካ ዎራ የ አሜናክንዳ ማቼ እስታ ፍክስንካ አመንከቴ፥ ኮግንደካ ሳብ ባቤና እንካ ማቻንግንደኬ እተረ ሳብ ባቤንካ እ ማቻንደትም ማለካ ኤዝደቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ከተረ አናካርንካ ክትም የድካንታ ዝግዘኬ፥ ኖ ማቼ ከታ አንናርንካ ሱርትሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","አናካርንከረ የሱስ ዮርዳኖስ ሎቀን ቃልሶ ዮሀንስ እሪ ስእዝድ Ꮊቃን ካርናር አይሴ፥ ኮታረረ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","በድ ኤድንከስ ክደር Ꮊድሰኮ “ዮሀንስ Ꮊረነረ አታ ቃዉተን ይያክዬ፥ ኬዛር ማቼ ዮሀንስ ኮ ኤችንጎካ ክት ኬዛንዳ ሙዳ ዶፈን Ꮊቄ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ኮታረረ በድ ኤድንከስ የሱሰካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ብታንያ ሞረናር አልዓዛር ጋይምድባብ ዋልቃ ኤች ሰቀርሶ Ꮊቄ፥ ብታንያ ካተመና ማራመትኬ ምችነን ማርተትካ ከት ዶቅድን ሞራ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ናኮና ማራማ ጮይስታ ዱትን ዎዝድንደትካ ሳይሳንደትኬ ይንታ ማተንካ ና ሱቻንዴ፥ ሰቀርስባበረ አልዓዛር ኮታ እስመና Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ምችነንኬ ካነንካ “ጮይስዮ፥ ኖ የስ ሶልምድባብ ሰቀርቴ” ጋይሶ የሱሰደር ክታ ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","የሱሰረ ኮም ይ ኤስርሳንደትካ፥ “ኮና ሰቅምና ደእካንታ የልዝድንዳ ካዬ፥ ኬዛር ማቼ ሳብካንታ ቦንቻ ማድንግንደከ ሳብታ ይንችነረ ኮትኮጎካ ቦንችምድንግንዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","የሱስ ማርተትምኬ ምችነን ማራመትም ከታ እስመን አልዓዛርመረ ሶልምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ማችንከረ አልአዛርታ ሰቅርን ኤሰርሰረ ይ ዶቅድን ካርናር ሰጫ ቃስተን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ኮታ ቡር ይንታ ካርንካ ጎርስምድባብከስም “ኦስ ይሁዳ ፍጫር አናካርንካ ዎም ሙከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ክታ ካርንካ ጎርስምድባብከሰረ “ኤስስንባቦ! አይሁድና መራ ሰጨታ እር የስም አቅናካንታ ከታ ዝግደኮ Ꮊቀኬ፥ ይና ካርንካ ኮታር ማተዮ አይተራ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","የሱሰረ፥ “ሰጫር ዶቅድንዳ ታመከ ቃስተን ሳዓት ካዮ? Ꮊየካ ኦንግድባብ ኮ ፍጫሙደንታ ሳክመን ይ ሰድንካንታ ጎሄራዬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ኬዛር ማቼ ሶይትካ ኦንግድባብ ሳክመና ክትካንታ ካየንኦል ጎሄርዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","የሱስ ኮም ከትካንታ ጋይሳን ቡር፥ “ዎንታ ገርነና አልዓዛር ግንእቴ፥ እታ ማቼ ክታ ግንእናርንካ ክትም አምስካንታ አይድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ክታ ካርንካ ጎርስምድባብከሰረ “ጮይስዮ! ክት ግንእተንዳ ማቼ ኡርዴ ጋይንትዬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","የሱስ ኮም ክት ኬዛንዳ አልአዛርታ ደእንጎካ Ꮊቄ፥ ከታ ማቼ ግንእ ጎካ ክት ኬዛን ከደር ካምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ኮካንታ የሱስ መየካ ከትም፥ “አልዓዛር ደእቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","የ አሜንድንግንዳ ኦኮታር እስታ ዶቃክሳ ነግንተንካ የጎካ እም ጉርምስቴ፥ ታ ማቼ ኦስ ክደር ዎም ሙከቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ኮታይካ ድድሞስ ጋይምስባብ ቶማስ አብንከስ ክታ ካርንካ ጎርስምድባብከስም፥ “ክትካ ክክን ዎ ደእተርንግንዳ ዎመረ ሙከቴ” ከትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","የሱስ ኮታር ክት የልሳንደትካ አልዓዛር ዱከርስንካ ኦይድ ሰጫ ማታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ብታንያ ሞረና የሩሳለምዘንካ ጎተርድንዳ ኡል ማከን ጎግ ማድንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","አይሁድንከሳርንከረ በድንከስ ማርተትምከ ማራመም ከታ እስመንታ ደእንጎካ ዳቅስካንታ ከደር Ꮊድሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ማርታ የሱሰታ Ꮊድንተንም ይ ኤሰርሳንደትካ ሞካካንታ ዉተዴ፥ ማራማ ማቼ ኤሄናር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ማርታ የሱስም “ጮይስዮ! የስ ካሪ ዶቅደስናና እስታ እስመና ደአይ ዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ኬዛር ማቼ ታየረ የስ ምግዝድንደትም ሙዳ ሳብ የስካንታ እምድንደትም ኤዝድቴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","የሱሰረ “የስታ እስመና ደእናርንካ አምዴ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ማርተረ “በእንታ ሰጨንካ ደእናርንካ አምንተናይካ አምድንደትም ኤዝድቴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","የሱሰረ “አምንተንከኬ ዶቅንተንካ እትቴ፥ እንካ አሜንድባብ ደእሰረ ዎራ ሰንፐካ ዶቅተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ሰንፔካ ዶቅድባብከ እንከረ አሜንድባብ ሙደና ቦድሶ ደአዬ፥ ኮም የና አመንዳ?” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ናየረ “ይዬ ጮይስዮ! የና ፍጫሙደንዘን Ꮊድባብ ሳይምስባብ ሳብታ ይንች የስ ማትንተን አመንድቴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ማርታ ኮም ይ ኬዛንደታ ቡር አይስንደትኬ ይንታ ምችነን ማራመም “ኤስስንባብ Ꮊቴ፥ ኖ የስመረ ኤልዴ” ጋይሶ ካቸካ ኮትም ኤልሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ማራማ ኮም ይ ኤሰርሳንደትካ ሳነካ አምሶ የሱሰደር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ኮትᎺይካ የሱስ ማርታ ክትም Ꮊፍሳን ካርናር Ꮊቄ ዳት ኦስ ሞረናር አክ አርዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ኮትመረ ዳቅስን ካንታ Ꮊድሶ ኤሄናር ኮትካ የካ Ꮊቅባብከስ አይሁድና ማራማ ጭጭመትካ አምትዮ ኮት ዉድንካ ሰድሰኮ አልአዛርታ ዱክንደር ና አይሶ ኮት ኤብድን ከደር ካምስንካ ከታ ኮትም ጎርስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ማራመረ የሱስ ዶቅድ Ꮊቃን ካርያር Ꮊድሶ ክትም ይ ሰጃንደትካ ክታ ዱትንዘን ዋችሶ “ጮይስዮ፥ የስ ካሪ ዶቅደስናና እስታ እስመና ደአይ ዶቆ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","የሱስ ኮት ኤብድንከ ኮትካ የካ Ꮊድባብከሰረ አይሁድና ከት ኤብድንካ ሰድሶ ቡዳርንካ አተርሶ ሞርእካ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Ꮊብረንት ዱክሳሬ?” ጋይሴ። ከተረ “ጮይስዮ! ኮር Ꮊድሶ ሰትካ” ከታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","የሱሰረ ኤርመካ ኤፍሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ኮካንታ አይሁድና “Ꮊስግንዳ ክት ሶልምዳ ናነረ ሰትከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ከታርንካ ዋልቃ ዋልቀንከስ ማቼ፥ “ዝልንታ አፍንከስም ሰችስባብ፥ ኮና ኤችና ደእዳክንግንዳ ይካንታ ማታዮ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","የሱስ አንድርይ ሞርኤሮ ዱክንደር አይሴ፥ ዱክነረ ሰይንካ ዝጭምሳንዳ የርሳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","የሱስ “ሰይንንም አምስከቴ” ጋይሴ። ደእስባብታ ምችነና ማርታ፥ “ጮይስዮ፥ ክት ደእስንካ ኦይድ ሰጫ ማቴ፥ ታ ሶቅዴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","የሱሰረ “የስ አሜንሴ ሳብታ ቦንቸን የና ሰተረዬ የስም ጋያክቶ?” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ኤድንከሰረ ሰይንንም አምሰኬ፥ ኮታ ቡር የሱስ ፈስ ጭላር ሰድሶ፥ “እስታ ባበኖ! እም የስ ኤሰርሳንካንታ የስም ጋለድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ሙዳᎺይከረ እም የስ ኤሰርድንደትም ኤዝድቴ፥ ኬዛር ማቼ ኮም እ ጋይሳንዳ፥ ኮዘን ዎእስባብ ኤድንከስ የስ እም ኦይቻንደትም ከት አሜንድንግንዳ ጋይስቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","የሱስ ኮም ኬዛንደታ ቡር፥ “አልአዛሮ! ኮሬ ዉትካ!” ጋይሶ አንድርይ ኡፍስካ ኤልሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ደእስባብ አልዓዛረረ አንንከስከ ዱትንከስ አክሰርድንደትካ አክስምሳንግንዳ ዱክናርንካ ዉተዴ፥ ክታ አፍንመረ አፍለካ ዞክረሳን ግንዳ Ꮊቄ፥ የሱሰረ “ብልሰቶ ክትም ዛእከቴ ክት አያ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ማራመም ዳቅስካንታ Ꮊድሶ Ꮊቅባብ አይሁድንከሳርንካ በድንከስ ይምሳንደትካ ሰድሰኮ የሱሰካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ዋልቃ ዋልቀንከስ ማቼ ኦስ ፈረሳያዊንንከዝደር አይሰኮ የሱስ ይሳንደትም ከትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ኮካንታ ቄሰንከስታ ገችንባብከስኬ ፈረሳዊያንንከስ ቡጫ ጋልተንከስካ የካ Ꮊቅድባከስም ሳንስሶ ኩን ጋይሰኬ “ኮና ኤችና በድ አታ ቃዉታ ክት ይድንኦል Ꮊስ ዎ ይሶክ ኡርተራ? ");
INSERT INTO gyl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ዉችኩን ክትም ዎ ዛቅሴ ኤድ ሙደና ክትካ አሜንደኬ፥ ሮማ ኤድንከሰረ Ꮊድሰኮ ዎንታ ሳብታ ጭል ኤሄንምከ ዎንታ ዎርሰንም ሙዳ ካይዝዴ።” ");
INSERT INTO gyl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ኬዛር ማቼ ከታርንካ ዋልቀና ኮት ስለናር ቀሰንከስታ ገችንባብ Ꮊቅባብ ቀያፋ ኩን ጋይሴ፥ “የታ ማቼ Ꮊረነረ ኤሳየቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ዎርሰና ሙዳ ካይድንጀንካ ዋልቃ ኤድ ዎርሰን ካንታ ደእሳን ማቼ የካንታ ኡርማ ማድንደትም ቦድሰቶ ገቀርት ተያከቴ?” ");
INSERT INTO gyl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ኖየረ ኮም ክት ኬዛንዳ፥ ይንዘንካ ዉችሶ ካዬ፥ ኬዛር ማቼ ኮት ስለናር ኖ ቄሰንከስታ ገችንባብ ማትሶ ክት Ꮊቅንኦል፥ የሱስ ዎርሰን ካንታ ደእ ክትም ዝግዝድንደትም ሰችካንታ ኮም ቤርንም ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ክት ደእድንደረ ዎርሰንካንታ Ꮊክ ማታክናና፥ ይጭምስባብከስመረ ሳብታ ይንችን ከትም ዋልቃ ማስሶ ሳንስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ኮካንታ ኮት ሰጨንዘንካ የድሶ የሱሰም ደይሳካንታ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ኮታዘንካ ኦስ የሱስ አይሁድንታ ዎክናር መየካ ኦንጋክዬ፥ ኬዛር ማቸ ኮታርንካ ዉትሶ ዴል ቆቸንታ ላማር ዶቅድን ኤፍረም ጋይምድን ካተመናር አይሴ፥ ኮታር ይንታ ካርንካ ጎርስምድባብከስካ ክክን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","አይሁድንታ ፋስጋ ባአልን ቅንችታ Ꮊቄ፥ በድንከሰረ ፋስጋ ባአልን የልተርንደታ እር፥ ይንታ ማተን አርንስካንታ Ꮊክ Ꮊክ ካርያርንካ ፈንክ የሩሳሌማር ዉተደኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ከተረ ሳብታ ጭል ኤሄናር ዎእሰኮ የሱሰታ Ꮊድንተንም ካርሰሮ Ꮊቃንጎካ “የታ Ꮊረንት ገቀርዳ? ባአልናር ክት Ꮊድን የም ካማዮ?” ጋየረኮ ክክ ክክ ኦይስመሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ጉጅሰረ ቀሰንከስታ ገችንባብኬ ፈረሳዊያንንከስ የሱሰም ከት የድንግንዳ ክት ዶቅድን ካርን ኤዝድባብ ኤድ ዶቅሴ ከትካንታ ኤስምዝድንግንዳ ኤድም ሙዳ ክትሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","አይሁድንታ ፋስጋ ባአልና ቦንችምካንታ ላ ሰጫ ነገድንካ፥ የሱስ ብታንያር አይሴ፥ ብታንያ የሱስ ደእናርንካ አምስባብ አልዓዛር ዶቅድን ሞሬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ኮታር ሶይት እችም ክትካንታ ከታ ግክሰኬ፥ ማርተረ ፍክስዘን Ꮊቄ፥ አልዓዛረረ የሱሰካ ክክን እችምካንታ ዶቅስባብከሳርንካ ዋልቀና Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ኮታይካ ማራማ ሰንት ተየርድንደና አንድርይ ስንጋ ማቻንዳ ኡርማ ናርዶስ ጋየርድንደትዘንካ ፍክስምሳንዳ፥ ጣሳ ዋልቃ ማድንዳ ዋልቃ ብልቃትካ ዎዝድንደትም ና ተይሶ፥ የሱሰታ ዱትንዘን ዉልእሴ፥ ይንታ ማተንከረ ሱቼ፥ ኤሄነረ ዎዝድንደታ ዎስመንካ ጮጬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ክታ ካርንካ ጎርስምድባብከሳርንካ ዋልቀና የሱስም ስክስትዮ እምድባብ አስቆሮንት ይሁዳ የሱሰም ግርንተካ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ኮና ዎዝድንደና ማከን ጨታ ጣገራ ብራ ሰንምሶ ርካየንባብከስካንታ Ꮊረታ እምማይንዳ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ኖ ኮም ክት ኬዛንዳ፥ ርካየንባብከስካንታ ሞርእሶ ማታክናና ድቢይ ክት ማቻን ኦሌ፥ ብረን የድንዳ ቦርሰን የድባብ ኖ ማትንተንካ ቦርሰናር ኦይትምድንደትም ብረን ተይድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","የሱሰረ፥ “ክት ዱከርድንደት ሰጨንታ ኮት ይሳንዳ ግክስ ማቻንካንታ ኮትም ዛእከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ሪካየንባብከስ ሙዳᎺይካ የንካ ክክነኬ፥ እታ ማቸ ሙዳᎺይካ የንካ ክክን ዶቃይቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ኮታይካ አይሁድንከሳርንካ በድንከስ የሱስ ብታንያር ክታ ማትንተን ኤስሶ Ꮊደኬ፥ Ꮊድባብከሰረ የሱስጎካ Ꮊክ ማታክናና የሱስ ደእናርንካ አምስባብም አልዓዛርመረ ሰድንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ቄሰንከስታ ገችንባብከስ ማቼ አልዓዛርመረ ደይሳካንታ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ክታዘንካ አምሳንዳ አይሁድናርንካ በድንከስና ይንታ አሜንን ዛቀረኮ የሱሰካ አመነረኮ ከት Ꮊቅንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ዛማክንካ ፋስጋ ባአልንካንታ Ꮊድባብ በድ ኤድንከስ የሱስ የሩሳሌማር ክት Ꮊድንደትም ኤሰርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ኮካንታ መጫ የድሰኮ ሞክት ተይካንታ ዉተደኬ፥ “ሆሳእና! ጮይስታ ላምንካ Ꮊድባብ እስረልንታ ባንችና አንጅምስባቤ!” ጋየረኮ ከታ ፍብድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","የሱስ ኡክልንታ ቅንጭ Ꮊፍስንደትከ ክታዘን ዶቅሶ፥ ኮነረ ማቻንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“የና ጽዮንታ ካተማ፥ የሩሳሌሞ Ꮊይ ጳሴ! ኮሰቸቴ! የስታ ባንችና ኡክል ቅንጭታ ዘን ዶቅሶ ኖ Ꮊዴ” ጋይምሶ ጻፍምሳንዳ ቤርና ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ክታ ካርንካ ጎርስምድባብከስ ኮና ርና እሪ ከትም አርዳክ Ꮊቄ፥ ማቼረ የሱስ ቦንቼካ ፈስ ጭላር አይሳንደትካ ኮና ሪይና ክትጎካ ጻፍምሳንግንደኬ ክት ካንተረ ይምሳንደትም ከታ ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","የሱስ አልዓዛርም ዱክናርንካ ኤልሳንደትከ ደእናርንካ ክትም አምሳንደታይካ ክትካ የካ Ꮊቅባብከስ ሙዳ የሱስጎካ ማርከረሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","በድ ኤድንከስና ክትካ Ꮊፍርካንታ ዉተድባብከሰረ ኮም አታ ቃዉተን ክት ይሳን ኤሰርሰኮ ከት Ꮊቅን ኦሌ። ");
INSERT INTO gyl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ኮታይካ ፈረሳዊያንንከስ፥ “ይና ኮሰቸቴ፥ ፍጫሙደንታ ዎርሰና ሙደናክትም ጎርስምተኬ! ዎታ Ꮊረነረ ይካንታ ዎማዳክንደትም ሰደት ካዮ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ባአልንᎺይካ ጎስትካንታ የሩሳሌማር አይስባብ ኤድንከሳርንካ፥ ዋልቃ ዋልቃ ግርክ ኤድንከስ Ꮊፈርድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ከተረ ገሊላ ፍጫርንካ በቴሳይዳ ፍጫ ኤድ ማችባብ ፍልጶሰደር Ꮊድሶ፥ “የባቦ፥ የሱስም ሰድንካንታ ዎታ ዝግዶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ፍልጶሰረ አይሶ እንደራስካንታ ኬዜ፥ እንደራሰከ ፍልጶስከ የካ አይሰኮ የሱስካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","የሱሰረ፥ “ይና ኮሰቸቴ፥ ኤድ ይንች ክት ቦንችምድን ሳዓትና የልቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ዶፈን፥ ዶፈን እታ የም ጋይድቴ፥ ዘርግታ ሶንተና ፍጨዘን ዋችሶ ጫፋክንዳ ማቼ፥ ና ይንት ነገዴ፥ ይጫፍሳንዳ ማቼ በድ አፍ ኡዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ይንታ ሰንፔንም ሶልምድባብ ኮትም ካይስዝዴ፥ ኮ ፍጫሙደንዘን ሰንፔን ይንታ ቦዝድባብ ማቼ ስለንክንደትካንታ ኮትም ካርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","እካንታ ፍክስ ዝግድባብ እም ጎርስማ፥ እ ዶቅድን ካርናር እስታ ፍክስንባብ ኮታር ማዴ፥ እካንታ ፍግዝድባብመረ ሳብ ባበና ክትም ቦንጅዴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","ኮታዘንከረ የሱስ፥ “ይና ኮሰቸቴ! እስታ ሰንፔና ማጠርቴ፥ Ꮊርስ ጋይቴ? ‘እስታ ባቤኖ! ኮ ሳዓትንዘንካ እም አቅስካ ጋይትቶ?’ ኮም እ ጋይተራክንግንዳ እ Ꮊዳንዳ ኮትኮ ማጣ ሳዓትን ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","እስታ ባቤኖ! የስታ ላምን ቦንችስካ” ጋይሴ። ኮታ ቡር “እስታ ላምን ቦንችስትቴ፥ ጉጅሰረ ቦንጅድቴ!” ኩን ጋይድንዳ ኡፍስ ጭላርንካ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ኮታር ዎእስባብ ኤድንከስ ኮም ኤሰርሳንደትካ፥ “ጉግኔ!” ጋይሰኬ። አብንከስ ጉጅሶ “ክታይንቼ ኬዝባብ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","የሱስ፥ “ኮና ኡፍስና Ꮊዳንዳ የካንታ ጋይሶ ዳት እካንታ ጋይሶ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ኮና ፍጫ ሙደና ኮት ፋረድምድንዳ ሰጨና ታዬ፥ ኮፍጫ ሙደን ቆልድባብ ሰጣን ኦስ ማል ክት ኦይትምድንዳ ታዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","እተረ ፍጨዘንካ ጨዳ ጬክን እ ጋይሳንደትካ ኤድ ሙደን እዝደር ተይᎺድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","የሱስ ኮም ክት ኬዛንዳ Ꮊራ ግንዳ ደእ ይ ደእዳ ናነረ ሰችዝድንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ኤድንከሰረ “ህግንካ ጻፍምስንካ ዎ Ꮊብድንዳ ‘ሳይምስባብ ስለንክንደታ ዶቅተሬ’ ጋይድንዴ፥ ይና፥ የና፥ ‘ኤድ ይንች ጨዳ ጬክን ጋይ ክትም ዝግዝዴ’ Ꮊሰስ ጋይዳ? ኮና ኤድይንችና Ꮊይራ?” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","የሱስ፥ “ታ መራ ሰጫካንታ የንካ ክክን ሳክማ ዶቅዴ፥ ኡምና የንዘን የልዳክንግንዳ ሳክመና የንታ ዶቅድንደትካንታ ኦንግከቴ፥ ኡምናር ኦንግድባብ Ꮊብር ይ አይዳናንከረ ኤሳዬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ሳክመንታ ይንች የ ማድንግንዳ ሳክመና የንታ ዶቅድንካንታ ሳክመን ማችባብካ የታ አመንከቴ” ኩን ጋይሴ። ኮታዘንከረ የሱስ ኮም ይ ኬዛንደታ ቡር አይስንደትከ ከታዘንካ አጥምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","የሱስ በድ አታ ቃዉተንከስም ከታ እር ይስንከረ ዎራ አይሁድና ክትካ አሜናከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ኮነረ ማቻንዳ ሳብዘንካ ኤሰርሶ ኬዝባብ ኢስያስ፥ “ጮይስዮ ዎንታ ማርከርን Ꮊይ አመንሳሬ? ጮይስታ ዎልቀና Ꮊይካንቶክ መያ ማቻሬ?” ጋየሮ ኬዝምሳን ቃለና ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ካርንከረ ኢስያስ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ከታ ይንታ አፍንካ ሰድስንደትከ ከታ ይንታ ቡደንካ ገቀርሰኮ ከት ማዳክንግንደከ ከት ፋጭዳክንግንዳ ሳብ ከታ አፍን ዝልስቴ፥ ከታ ቡደንመረ ገቀርዳክንግንዳ ይሴ” ኩንጋየሮ ከታ አሜንክሳ ነግን መያ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ኢስያስ ኮም ክት ጋይሳንደረ ሳይምስባብታ ቦንቸንም ይ ሰዳንካንቴ፥ ኮካንታ ኮም የሱስጎካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ማችንከረ አይሁድንታ ገችንባብከሳርንከረ ዎራ በድንከስ የሱሰካ አሜንተኬ፥ ኬዛር ማቼ ፈረሳዊያንንከስ አይሁድንታ ምክስ ኤሄናርንካ ከትም ዉጅዳክንግንዳ ጳስካ፥ መየካ ክትካንታ ማርከራከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ኮመረ ከት ይሳንዳ ሳብዘንካ Ꮊፈርድን ቦንቸዘንካ ስግ ኤድዘንካ Ꮊፈርድን ቦንቸን ከት ሶልምሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","የሱሰረ ይንታ ኡፍስን ጬክሳ ይይሶ፥ “እንካ አሜንድባብ እንካ Ꮊክ ማታክናና፥ እም ኦይችባብከረ አሜንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","እም ሰድባብ እም ኦይችባብም ሰዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","እንካ አሜንድባብ ሙደና ኡማር ዶቅዳክንግንዳ እታ ሳክማ ማትስቶ ፍጫሙደንዘን Ꮊትቴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","እስታ ቃለን ኤሰርሶ ፍክስዘን Ꮊቅዝዳክባብ ክታዘን ፋረድባብ እታ ካይቴ፥ እ Ꮊዳንዳ ፍጫ ሙደን አቅስካንታ ዳት ፍጫሙደንዘን ፍርዳካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","እም ዝግዳክባብኬ እስታ ቃለንመረ ተይዳክባብ ኤድ ክታዘን ፋረድባብ ዶቅዴ፥ እ ኬዛንዳ ቃለና በእንታ ሰጨንካ ክታዘን ፋረዴ። ");
INSERT INTO gyl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","እታ እስታ ገችንታ ኤረንካ ኬዛክቴ፥ እ ጋይድንደትምኬ እ ኬዝድንደት ክተንም እካንታ እምስባብ እም ኦይችባብ ሳብባበኔ። ");
INSERT INTO gyl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ክተረ ክተና ስለንክንደታ ዶቅንተንደር ጎርዝድንዳ ማቻንደትም ኤዝድቴ። ኮካንታ እ ኬዝድንዳ ሳብ ባቤና እካንታ ከዛንደትሜ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ይና ሰጨና አይሁድንከስታ ፋስጋ ባአልን የልታ Ꮊቄ፥ የሱስ ኮፍጫ ሙደን ዛቅሶ ሳብ ባቤንደር ክት አይድንደታ ሳዓትና የልንተንም ኤሴ። ኮ ፍጫሙደንዘን ዶቅድባብከስ ይንታ ኮችንከስም ኖ ሶልምድ Ꮊቄ፥ በእንታ የለልተረ ከትም ሶልምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","የሱሰከ ክታ ካርንካ ጎርስምድባብከስካ ሶይት እችምን እጅድ Ꮊቀኬ፥ ስምኦነታ ይንች አስቆሮንት ይሁዳ ማቼ የሱሰም ስክስት እምድንግንዳ ዳብሎስ ክታ ቡደናር ዳቅል ገቅር ገችስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ሳብ ባቤና ገችታ ኤረን ሙዳ እምሳንደትግንደከ ሳብዘንካ ዉትሶ Ꮊዳንደት ግንዳ፥ ሳብደረረ ይ አይድንደትም የሱስ ኤዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ኮካንታ እችምንዘንካ አምስንደትከ አፍለን ይንታ ዎጄ፥ ሱተርደን ዳንጭንመረ አምስትዮ ይንታ ዎክ ጫምናር ዞክሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ኮታ ቡር ዱትን ስእርድን ጋበትናር ሎቃ ዎድሶ ይንታ ካርንካ ጎርስምድባብከስታ ዱትን ስእ የጄ፥ ይ ዞከርሳን ሱተርድን ዳንጭንከረ ከታ ዱትን ሱቼ። ");
INSERT INTO gyl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","የሱስ ስምኦን ጴጥሮሰደር Ꮊዳንደትካ ጴጥሮስ፥ “ጮይስዮ! የና እስታ ዱት ስእተራ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","የሱሰረ “እ ይድንደትም የና ታ ኤዝዳከዬ፥ ኮታ ቡር ማቼ ገቀርዳዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ጴጥሮሰረ “የና እስታ ዱትን ቦድስ ስእዳካዬ!” ጋይሴ። የሱሰረ “እታ የስታ ዱትን እ ስአክንዳ ማቼ እዝደር ካሪ የስታ ካዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ስምኦን ጴጥሮሰረ “ጮይስዮ! ኩን ማቼ እስታ ዱትን Ꮊክ ማታክናና እስታ አንነረ፥ እስታ ማተንመረ ስእካ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","የሱሰረ “ዘነንም ስኤርስባብ ዘነና ክታ ኡርማ ማትንተንካ ዱትንም ስርንዘንካ አብ ክትም ዝክስሳየ፥ የተረ ጭልን ከሰቴ፥ ኬዛርካ ማቼ የታ ሙደና ጭልንከስ ካየቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","የሱስ “የታ ሙደነረ ጭል ካየቴ” ክት ጋይሳንደረ ይም ስክስትን እምድባብ Ꮊይ ናነረ ይ ኤዝድን ኦሌ። ");
INSERT INTO gyl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ከታ ዱትን ስእሳንደታ ቡር አፍለንም ቆበርሶ ይንታ ካርንዘን ማትሶ ዶቅሴ፥ ኩነረ ከትም ጋይሴ፥ “Ꮊራካንታ እ የካንታ ይሳናከረ ገቀርት ተይተቴ? ");
INSERT INTO gyl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","የታ ‘ኤስስንባብኬ ጮይስዬ’ እም ጋይደቴ፥ እታ ኤስስንባብኬ ጮይስ እማቻን ኦል የ ጋይስንዳ ገቴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ይና እታ የንታ ጮይስኬ ኤስስንባብካ እ ማድንካ የንታ ዱትን እ ስእሴ የተረ ክክ ክክ የንታ ዱትን ስኤር የም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","እታ የካንታ ይሳንደትግንዳ የተረ የ ይድንደትግንዳ ካምስንም የም እምትቴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ዶፈን ዶፈን የም ጋይድቴ፥ ፍክስንባብ ማታ ቆልስባብዘንካ ስጋየ፥ ክትምስባበረ ኦይችባብዘንካ ስጋዬ። ");
INSERT INTO gyl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ኮትኮም ሪን የ ኤሰኬ ፍክስዘን የ Ꮊቅሴ አንጅምስባበቴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","ኮም እ ኬዝድንዳ የ ሙደንጎካ ካዬ፥ እ የም እጅባብከስም ኤዝድቴ፥ ኬዛርካ ማቼ ‘እስታ ሶለንም እችባብ እዘን ይምኤርካ አምሴ’ ጋይድንደና ጭል ማጻፍንታ ቃለና ቦድ ኮትም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ኮና ማተርንደታ እሪ ታ እሪናና የም እ ኬዝድንዳ፥ ቦጃንደታ ቡር፥ እንካ የ አመንድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ዶፈን ዶፈን የም ጋይድቴ፥ እ ኦይድባብም ሞግድባብ እም ሞግዴ፥ እመረ ሞግድባብ እም ኦይችባብም ሞግዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","የሱስ ኮም ይ ጋይሳንደታ ቡር ይንታ አያንካ ማጥምሶ፥ “ዶፈን ዶፈን ጋይድቴ፥ የንታርንካ ዋልቀና ስክስት እም እምዴ” ጋየሮ መየካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","የሱሰታ ካርንካ ጎርስምድባብከስ ኮም Ꮊይካንታ ኬዛ ናንከረ ከታ ይ ኤሳክን ኦል ክክ ክክ ዳንድምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","የሱስ ይ ሶልምድ Ꮊቅባብ የሱሰታ ካርንካ ጎርስምድ ባብታርንካ ዋልቀባብ የሱሰታ ላመር ዶቅሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ስምኦን ጴጥሮሰረ ክትም ቃዉተካ ሰችሶ “Ꮊይካንታ ክት ኬዛ ናንከረ የና ኦይስካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ኮካንታ ኖ የሱሰደር እጵን ጋይሶ “ጮይስዮ! ስክስት የስም እምድባብ Ꮊይራ?” ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","የሱሰረ “ኖ ኮ ሶለን ማጭንካ ዱክትቶ እ ባርዝድ ባቤ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ይሁዳ ባርስንም ይ ተያንደታ ቡር ሳና ሰጣን ክታር አርደዴ፥ የሱሰረ ይሁደም፥ “ይካንታ የስ ገቀርሳንደትም ሳነካ ይካ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","የሱስ ኮም Ꮊረታ ክት ጋይሳናከረ እችምንደር ዶቅስባብ ከስካንታ አርዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ይሁዳ ብራ የድባብ ክት ማቻን ኦል ክታ ካርንካ ጎርስምድባብከሳርንካ የሱስ “ባአልንካንታ ዎም ዝግዝድንደትም ሰንካ አነረ ርካየንባብከስካንታ እምንተንም እምካ” ክት ጋይሳን ከትም ካምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ይሁደረ ባርስንም ይ ተያንግንዳ ሳና ናና ዉትሶ አይሴ፥ ፍጨነረ ገልትገር ማዴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ይሁዳ ዉትሶ አይሳንደታ ቡር የሱስ፥ “ታ ሳብ ይንች ቦንችምቴ፥ ክት ጎከረ ሳብ ቦንችምቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ሳብ ክትጎካ ክት ቦንችምሰ ሳበረ ክትም ቦንችዝዴ ሳነከረ ቦንችዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","እስታ ይንችን ከሶ፥ የንካ ክክን በድ ሰጫ ዶቃይቴ፥ የተረ እም ዝግተረቴ፥ አይሁድንከስታ ገችንባብ ከዝደር ‘እ አይድንደታር የታ Ꮊድካንታ ማታየቴ’ እ ከትም ጋይሳንደት ግንዳ፥ ታየረ የካንታ ኩን ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ክክ ክክ የ ሶልምድን ግንዳ ክላ ክታ የም እምድቴ፥ እ የም ሶልምሳን ግንዳ የተረ ክክ ክክ ሶልምከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ክክ ክክ የ ሶልምሳ ማቸ እስታ ካርንካ ጎርስምድባብ የ ማቻንደትም ኤድ ሙደና ኮካ ኤዝደኬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ኮታ ቡር ስምኦን ጴጥሮስ የሱስም፥ “ጮይስዮ! Ꮊብረስ አይዳ?” ጋይሶ ኦይሴ። የሱሰረ “እ አይድንደታር ታ እም ጎርስምካንታ ማዳካዬ፥ ቡር ማቼ እም ጎርስምዳዬ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ጴጥሮሰረ “ጮይስዮ! Ꮊረተረ ታ እ የስም ጎርስምካንታ ማታይንዳ? እታ እስታ ሰንፔን ዎራ የስጎካ ስክስት እምድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","የሱሰረ “የና የስታ ሰንፔን እካንታ ስክስት እምዳ? ዶፈን ዶፈን የስም ጋይድቴ፥ ታካ ባቻ ቅቅተርንደታ እሪ ማክን ዱት እም ካተራዬ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ካርንከረ የሱስ፥ “የንታ ቡደና Ꮊይማጠራ፥ ሳብካ አመንከቴ፥ እንከረ አመንከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","እስታ ባቤንታ ኤሪ በድ ዶቅንትታ ካሪ ዶቅዴ፥ ኩን ማታከስናና እታ የካንታ ኬዝድትዶቆ የ ዶቅተርንደትም ካሪ ግግስካንታ አይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","አይስቶ ካሪ የካንታ እ ኡርሳንደታ ቡር እ ዶቅድንደታር የ ዶቅተርንግንዳ ካርንካ Ꮊድስቶ የም እዝደር ተይ አይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","እ አይድንደት ካርናር የልዝድን ጎግን የታ ኤዝደቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ቶማስ “ጮይስዮ! Ꮊብር የስ አይዳ ናነረ ኤሳዮቴ፥ ይና፤ ጎግንም Ꮊስ ይሶንት ኤዝዳ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","የሱሰረ ክትካንታ፥ “ጎግንከ ዶፈንና ሰንፔነረ እትቴ፥ እጎካ ማታክንዳ ማቼ Ꮊየሰነረ ሳብ ባቤንደር Ꮊድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","እመረ የ ኤስታ ናና እስታ ባቤንመረ ኤዝደት ዶቆ፥ ኮዘንካ ኦስ ማቼ የታ ኤስተረቴ፥ ክትም ሰተቴ” ኩንጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ፍልጶሰረ “ጮይስዮ! ሳብ ባቤንም ሰችስካ ዎም ማዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","የሱሰረ፥ “ፍልጶሶ! ኮካ ስላ የንካ ክክን እ ዶቅድንካ እም ኤዝዳካ? እም ሰጅባብ ሳብ ባቤንም ሰጄ፥ ይና የና ‘ሳብ ባበንም እም ሰችካ’ Ꮊሰስ ጋይዳ? ");
INSERT INTO gyl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","እታ ሳብ ባቤንካ እ ዶቅድንደትም፥ ሳብ ባቤነረ እንካ ዶቅድንደትም አመናያ? የካንታ እከዝድንዳ ቃለና እስታ ኤረካ ካዬ፥ ኬዛርካ ማቼ፥ ፍክስንም ሙዳ ፍግዝድባብ እንካ ዶቅድባብ ሳብ ባቤኔ። ");
INSERT INTO gyl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","እታ ሳብ ባቤንካ እ ዶቅድንደትግንዳ ሳብ ባቤነረ እንካ ዶቅድንደትም አመንከቴ፥ ኩን ካየንዳ ማቼ እስታ ፍክስን ከስ ጎካ እም አመንከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ዶፈን ዶፈን የም ጋይድቴ እንካ አመንድ ባብ እ ፍግዝድንደትም ፍክስን ፍግዝዴ፥ ኮት ኮግንደረ ኮታዘንካ ስገዳን ፍግዝዴ፥ እታ ሳብ ባበንደር እ አይድን ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ሳብ ባቤና ይንችን ጎካ ቦንችምድን ግንዳ እስታ ላምንካ የ ምግዝድንደትም ሙዳ የካንታ ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ꮊረሰነረ ር እስታ ላምንካ የ ምክሴ እታ ይድቴ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“እም የ ሶልምዳ ማቼ እስታ ክተን ካርስከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","እታ ሳብ ባቤንም ምክስትቴ፥ ኖየረ ስለንካ የንካ ክክን ዶቅድንደትም አብ ዳንዳእዝድንደትም የካንታ እምምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ና ኮነረ ዶፈንንታ አያነረ፥ ፍጫ ሙደና ክትም ሰዳይንካንተከ ኤሳይንካንታ ተይካንታ ማታዬ፥ የታ ማቼ፥ ኖ የንካ ክክን ማቻን ካንተከ የንታ ዋረረ ዶቅድንካንታ ክትም ኤስተረቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“እንደንከኬ ባቤንካ ካየን ይንችግንዳ የም Ꮊክ ዛቅዳክቴ፥ ማትቶ የንደር Ꮊድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ቶክማ ሰጨታ ቡር ፍጫ ሙደና እም ሰዳዬ፥ የታ ማቼ እም ሰደቴ እታ ሰንፔካ እ ማቻን ካንታ የተረ ሰንቴካ ዶቅተረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","እታ ሳብ ባቤንካ ዶቅድንደትግንዳ የተረ እንካ የ ዶቅድንደትግንዳ እተረ የንካ እ ዶቅድንደትግንዳ ኮት ሰጨንካ ኤስተረቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“እም ሶልምድባብ እስታ ክተንም ተይድባብኬ ፍክስዘን Ꮊቅዝድባቤ፥ እመረ ሶልምድባብም እስታ ባቤና ሶልምዴ፥ እተረ ሶልምድቴ፥ እስታ ማተንመረ ክትካንታ Ꮊብዝድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","አስቆሮንት ይሁዳ ማታክባብ አብ ይሁዳ፥ “ጮይስዮ! የስታ ማተንም ፍጫ ሙደን ካንታ ማታክናና ዎካንታ መያ የስ ማስዝድንዳ Ꮊስግንደረ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","የሱሰረ፥ “እም ሶልምድባብ እስታ ቃለን ካርዝዴ፥ እስታ ባቤነረ ክትም ሶልምደ፥ ዎታ ክደር Ꮊድሶቶ ክትካ ክክን የካ ዶቅዶቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","እም ሶልምያይባብ እስታ ቃለን ካርሳዬ፥ ኮና የ ኤሰርድን ቃለና እም ኦይችባብ ሳብ ባቤንታ ዳት እስታ ካዬ። ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ታ የንከረ ክክን ዶቅድቶ ኮም ርይን የም ከዝትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ሳብ ባቤና እስታ ላምካ ኦይድንዳ ዳንዳእዝድንዳ አያንይ ጭልና ማቼ ሙዳ ርይን የም ኤስዝዴ፥ እ ኬዛንደትም ሙዳ የ ገቀርድንግንዳ ይዴ።” ");
INSERT INTO gyl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ሳራትችን የካንታ ዛቅድተ እስታ ሳራትችንመረ እምድቴ፥ እ የም እምድንዳ ሳራትችና ፍጫ ሙደና እምድንደት ግንዳ ካዬ፥ የንታ ቡደና Ꮊይ ማጥማ፥ ጉጅሰረ Ꮊይ ጳሳ። ");
INSERT INTO gyl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘እታ አይድቴ፥ ማተረ የንደር Ꮊድቴ’ እ ጋይሳን ግንዳ ኤሰርተቴ፥ እስታ ባቤና እዘንካ ስግድን ኦል እም የ ሶልምታ ናና ሳብ ባቤንደር እስታ አይንተንካ ጉርም የም ዝግዝዳዶቆ። ");
INSERT INTO gyl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ኮና ማድንደትᎺይካ የ አመንድንደትግንዳ ማትንተንታ እር የም ከዝትቴ። ");
INSERT INTO gyl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ኮ ፍጫሙደንታ ገችንባብ ማችባብ ሰጣን ክታ Ꮊድንታ ማቻን ካንታ ኮዘንካ ኦስ የንካ ክክን በድ ከዝማይቴ። ክታ ማቼ እዘን Ꮊረሰነረ ዎልቃ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ኬዛር ማቼ እታ ሳብ ባቤንም እ ሶልምድንደት ግንዳ ፍጫ ሙደና ኤስተርን ግንዳ ሳብ ባቤና እም ክትሳንደትም ሙዳ ታ ቦዳዶቅድቴ፥ አምከቴ ካርንካ ዎም ሙከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ዶፈን ዎይንንታ ዛንበና እትቴ፥ ኮረንባብ እስታ ባቤኔ፥ ");
INSERT INTO gyl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","እስታዘን ዶቅድን አፍን ኡዝዳክንደትም ሳቀንም ሙዳ እስታ ባቤና ቃርጭት ዛቅዴ፥ አፍ ኡዝድን ሳቀን ማቼ በድ ኡዝድን ግንዳ ሳቅት ኡርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","የተረ እከዛን ቃለንጎካ ታ ጭልምስባበቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","እንካ ዶእከቴ፥ እተረ የንካ ዶቅትቴ ሳቀና ዛንበን ዘን ዳቅሶ ዶቃክ ማቼ ይንት አፍ ኡስካንታ ማዳክንደትግንዳ የተረ እንካ የ ዶቃክንዳ ማቼ አፍ ኡስካንታ ማታየቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“እታ ዎይንንታ ዛንብቴ፥ የተረ ሳቀቴ፥ በድ አፍ ኡዝድባብ እንከረ ዶቅድባብከ እተረ ክትካ ዶቅድባቤ፥ ኬዛርካ ማቼ እ ካይሳ Ꮊረሰረ ይካንታ ማታየቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","እንካ ዶቃይባብ ሳቀንግንዳ ማል ዛቅምሶ ዎጅዴ፥ ኮግንዳ ማችባብ ሳቀንከስ ሳንስምት ኖሀር ኦይትምዳ አችምደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","እንካ የ ዶቅሴ እስታ ቃለነረ የንካ ዶቅሴ የ ዝግዛንደትም የ ምክሰ Ꮊብደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","በድ አፍ የ ኡዝደኬ እስታ ካርንካ ጎርስምድባብ የ ማዴ ኮትካ እስታ ባቤና ቦንችምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ሳብ ባቤና እም ሶልምሳንደት ግንዳ እተረ የም ሶልምሳቴ፥ ኮካንታ እስታ ሶልመንካ ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","እታ እስታ ባቤንታ ክተንም እ ቦንችሳንደትግንደኬ ክታ ሶልመንካ እ ዶቅድንግንዳ የተረ እስታ ክተንም የ ቦችሰ እስታ ሶልመንካ ዶቅተረቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ኮም እ የካንታ ኬዛንዳ እስታ ጉርምና የንካ ማድንደትግንደከ የንተረ ጉርምና ቦድማ ማድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","እስታ ክተና እ የም ሶልምሳን ግንዳ የተረ ክክ ክክ የ ሶልምድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ኤድ ይንታ ገርነን ካንታ ሰንፔንም ስክስት እመዘንካ ስገዳንዳ ሶልማ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","የተረ እ ክድንደትም የ ቦችሰ እስታ ገርነንከሰቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","አይለንከስ ማታ ቆልስባብ ይድንደትም ከት ኤሳይንደትካንታ ኮታዘንካ ኦስ አይለንከሰ የም ጋያይቴ፥ ኬዛር ማቼ እስታ ባቤንዘንካ እ ኤሰርሳንደትም ሙዳ የካንታ መያ እ ማስሳንደት ኦል እስታ ኮችንከሰ ጋይትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","እታ የም እጃት ዳት የታ እም እዳከቴ አይሰቶ በድ አፍ የ ኡዝድን ግንዳ፥ የንታ አፍነረ ዶቅድንዳ ማድንግንዳ የም ዶርሳቴ። ኮካንታ እስታ ላምንካ የ ምግዝድንደትም ሙዳ ሳብ ባቤና የካንታ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ይና እታ የም ክድንዳ ክክ ክክ ሶልምተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ኮፍጫ ሙደና የም ግርሰ ኤና እሪ እም ግርዳንደትም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ኮፍጫ ሙደን ኮታ የ ናና የም ሶልምዳ Ꮊቄ፥ ኬዛርካ ማቼ ኮ ፍጫሙደንታ የ ማታክንደት ኦላርከ እታ ኮ ፍጫሙደንዘንካ ፋስስቶ እ የም እጃንደት ኦል፥ ኮፍጫ ሙደና የም ግርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","አይለና ማታ ቆልስባብዘንካ ስጋየ እ ጋይሳንደትም ገቀርከቴ፥ እም ይ ዳይሳንካ የመረ ዳይደኬ፥ እስታ ቃለንም ከት ካርሰ የንተረ ቃለንም ካርዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","እም ኦይችባብም ከት ኤሳይንካንታ እጎካ ኮም ሙዳ የንዘን ይዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","እታ Ꮊድስቶ የካንታ ኬዛክናና ጎማ የንዘን ማዳክ ዶቆ ታ ማቼ ከታ ጎመንታ ስርስ ኬዛ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","እም ቦዝድባብ እስታ ባቤንመረ ግርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","አብ ኤድ ይያክንደትም ፍክስ ከታ ዎክያር ፍክስማከስናና ጎማ ከታዘን ማተራክዶቆ፥ ታ ማቼ ኮም ሙዳ ሰጃንደታ ቡር እመረ እስታ ባቤንመረ ግርተኬ። ");
INSERT INTO gyl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ኮነረ ማቻንዳ፥ ‘ስርስ ኬዝካይሳ እም ግርተኬ’ ጋይምሶ ከታ ህግናር ጻፍምሳንዳ ቃለና ቦድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ኬዛር ማቼ ሳብ ባቤንዘንካ ዉድንደትኬ እተረ ሳብ ባቤንዘንካ የካንታ እ ኦይድንዳ ዳቅስንባብ ዶፈን አያንና Ꮊድሶ ኖ እጎካ ማርከርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","የተረ እርንደትዘንካ አምስሶ እንካ ክክን የ Ꮊቃንኦል ማርከርደቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ይና፥ ኮም ሙዳ እ የካንታ ኬዛንዳ የንታ አሜንና ዙብምተራክን ግንዳ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","አይሁድንከስታ ምክስ ኤሄናርንካ ዉችሰኮ የም ዳይደኬ፥ ኮግንደረ የም ደይዝድባብ ሙደና ሳብካንታ ከት ፍግዝድን ካምድን ሰጫ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ኮመረ ከት ይድንዳ ሳብ ባቤንመረ ማታ እም ከታ ይ ኤሳክን ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ኮም የካንታ እስታ ኬዘና ማቼ ሰጨና የልድንካ Ꮊራ እ የም ጋይሳናከረ የ ገቀርድን ግንዴ” ኮም ሙዳ ኮታ እር እ የካንታ ከዛክንዳ የንካ ክክን Ꮊቃንካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ታ ማቼ እም ኦይችባብደር እታ አይድቴ፥ ማችንከረ የንታ ዋርንካ Ꮊበስ አይዳ? ጋይሶ እም ኦይዝድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ማታጋካ ዳት ኮም ሙዳ እ የም ኬዛን ጎካ የንታ ቡደና ሞርእካ ጮጭቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","እታ ማቼ ዶፈን ዶፈን የም ጋይድቴ፥ እስታ አይንተና የካንታ መይዴ፥ እ አያክንዳ ማቼ ዳቅስንባብ የንደር Ꮊዳዬ፥ እ አይሳን ማቼ አያን ጭልን ክትም የካንታ ኦይድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","አያን ጭልና ᎺዳንደትᎺይካ ጎማካንታ፥ ጭልምጎካ ሳብታ ፍርዳጎካ ኮ ፍጫሙደንታ ኤድንም መያ ማስሶ ሰጅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ጎመን ካንታ መያ ማዝድንዳ እንካ ከት አመንዳክንካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ጭለትቺንካንታ መያ ማዝድንዳ ሳብ ባቤንደር አይድን ካንተከ ኮታዘንካ ኦስ እም የ ሰዳይንካንታ፥ ");
INSERT INTO gyl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ፍርደንጎካ መያ ማዝድንዳ ኮ ፍጫሙደንታ ገችንባብ ሰጣን ፋረድምሳን ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","አክ እ የም ኬዝድንዳ በድ ር ዶቅዴ፥ ኬዛርካ ማቼ ታ የም ደጭዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ዶፈን አያንና ᎺዳንደትᎺይካ ዶፈንንደር ሙዳ የም ጎርዝዴ። አያን ጭልና ኬዝድንዳ ይ እዘንካ ኤሰርሳን ዳት ይንተን ማታክንካንታ ኖ ኦስ እሪ ማድንደትም ሪይንከስም የካንታ ኬዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","እስታ ማቻንደትዘንካ ተይዮ የካንታ ኬዝድን ካንታ እም ቦንጅዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ሳብ ባቤንታ ማቻንዳ ሙዳ እስቴ እስታ ማቻንደትዘንካ ተይዮ የካንታ ኬዝዴ እ ጋይሳንዳ ኮካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ቶክም ሰጨታ ቡር እም ሰዳየቴ፥ አና ቶክም ሰጨታ ቡር እም ሰደቴ”። ");
INSERT INTO gyl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ክታ ካርንካ ጎርስምድባብከሳርንካ ዋልቃ ዋልቀንከስ “ኮና፥ ‘ቶክም ሰጨታ ቡር እም ሰዳከቴ፥ ጉጅሶ ቶክም ሰጨታ ቡር እም ሰደቴ፥ ጉጅሶ ሳብ ባቤንደር አይድቴ’ ዎንደር ክት ጋይድንዳ ሪና Ꮊራ?” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“ይና ኮና ‘ቶክም ሰጨታ ቡር’ ጋይድንዳ ሪና Ꮊራ? ክት ኬዝድንደትም ርን ኤሳዮቴ” ክክ ክክ ጋይንተካ ኦይስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","የሱሰረ ከት ኦይስካንታ ዝግዛንደትም ኤስሶ ኩን ከትም ጋይሴ፥ ክክ ክክ የ ኦይስምድንዳ፥ “ቶክም ሰጨታ ቡር እም ሰዳከቴ፥ አና ቶክም ሰጨታ ቡር እም ሰደቴ” እ የም ጋይሳን ካንቶ? ");
INSERT INTO gyl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ዶፈን ዶፈን የም ጋይድቴ፥ የታ ኤብደቴ፥ ፍብደቴ፥ ኮፍጫ ሙደንም ማቼ ጉርምዝዴ፥ የታ ሞርእደቴ፥ ኬዛርካ ማቼ የንታ ሞርእና ጉርምያር ኦክምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ማና ይ አጥንደትᎺይካ ጋእርታ ሰጨና ኮታ የልሳን ካንታ ሞርእደ፥ ይ አጫንደታ ቡር ማቼ ኮ ፍጫሙደንዘን ኡላ አጥምሳን ካንታ ይንታ ጉርምንዘንካ አምሳንዳ ይንታ ማጠንም ገቀራዬ። ");
INSERT INTO gyl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ኮትኮግንደረ የታ ታ ሞርእደተ ኬዛርካ ማቼ እታ ካርንካ የም ሰድቴ፥ የንታ ቡደነረ ጉርምዴ የንታ ጉርምንመረ የንዘንካ ተይድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ኮት ሰጨንካ እዘንካ Ꮊረሰን ር ምክሳየቴ፥ ዶፈን ዶፈን የም ጋይድቴ ሳብ ባቤንም እስታ ላምካ የ ምግዝድንደትም ሙዳ ሪን የም እምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ታካ የለልታ እስታ ላምንካ Ꮊራ ሪየረ ምክሳከቴ፥ ምክስከቴ የካንታ እምምዴ የንታ ጉርምነረ ቦድማ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ታ የለልታ ካምስካ ከዛቴ፥ ኮታዘንካ ኦስ ካምስካ እከዝዳክንደታ ሰጫ Ꮊዴ፥ ኬዛርካ ማቼ ሳብ ባቤን ጎካ ሙዳ ሪይንም እታ መያ ማስስቶ የም ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ኮት ሰጨንካ እስታ ላምንካ ምግዝደቴ፥ እተረ ሳብ ባቤንም የካንታ ምግዝድተ ጋያይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ꮊረታ ጋይሴ ሳብ ባቤን ይንታ ማታርካ የም ሶልምድን ካንታ፥ ሳብ ባቤነረ የም ሶልምድንዳ እም የ ሶልምሳን ካንተከ ሳብታ ላማርንካ እ Ꮊዳን ግንዳ የ አሜንሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ሳብ ባቤንዘንካ ዉትስቶ፥ ኮ ፍጫሙደንዘን Ꮊትቴ፥ ካርንከረ ኮፍጫ ሙደን ዛቅስቶ፥ ሳብ ባቤንደር አይድቴ”። ");
INSERT INTO gyl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ክታ ካርንካ ጎርስምድባብከስ ኩን ጋይሰኬ፥ “ይና! ታ ካምስካ ማታክናና መየካ ኬዛዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","የና ሙደን የስ ኤዝድንግንደከ Ꮊየነረ ኦይስ ግክስካንታ ዝግዝዳክንደትም ታ ኤሶቴ፥ ኮካንታ ሳብዘንካ የስ ዉተዳንደትም አሜንዶቴ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","የሱሰረ፥ “ታ የታ አሜንተቴ? ");
INSERT INTO gyl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ማታጋካ ዳት የታ ዋልቃ ዋልቀና የም ዝክሳን ጎካ የ ይጭምድንደትኬ እም Ꮊክ የ ዛቅድንደታ ሳዓት Ꮊዴ፥ ሳዓትነረ ታ የልቴ ኬዛርካ ማቼ ሳብ ባቤና እንካ ክክን ማቻን ካንታ እስት ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ኮም የካንታ እስታ ኬዘና እንካ ማትሰቶ ሳራትችና የካንታ ዶቅድንግንዳ ጋይስቴ፥ ኮ ፍጫሙደንዘን የ ዶቅድንካ ማጣ የንዘን ዶቅዴ፥ ኬዛርካ ማቼ ዳእከቴ፥ እታ ኮፍጫ ሙደን ጋምትቴ” ኩን ከትካንታ ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","የሱስ ኮም ይ ኬዛንደታ ቡር ጬክን ጋይሶ ፈስ ጭላር ሰደሮ ኩን ጋይሴ፥ “እባቦ! ይና፥ ሳዓትና የልቴ፥ የስታ ይንችና የስም ቦንጅድን ግንዳ የስታ ይንችንም ቦንችካ፥ ");
INSERT INTO gyl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","የስ ቦንጅድንደረ የስ እካንታ እምስባብ ሙደንካንታ ስለንካ ዶቅንትን እ እምድን ግንዳ ኤድንከስ ሙደንታዘን ገችታ ኤራ ክትካንታ የስ እምሳን ኦሌ። ");
INSERT INTO gyl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ስለንካ ዶቅንትነረ፥ ጋይንት የና Ꮊክ ዶፈንን ጮይስንከ የስ ኦይችባብ የሱስ ክርስቶሰም ኤስንቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","እታ የስ እካንታ እምሳን ፍክስን ቦድስቶ ፍጨዘን የስም ቦንችስትቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","እባቦ! ፍጫ ሙደና ፍዝምተርንደታ እርምሶ የስካ ክክን እስታ ዶቅድንደት ቦንቸንካ ታየረ የስታ ባንግር እም ቦንችካ። ");
INSERT INTO gyl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ፍጫሙደንታ ዋርንካ እተዮ እካንታ የስ እምስባብ ኤድንከስካንታ የስታ ኤደትቼን መያ ማስሳቴ፥ ከታ የስታ Ꮊቀኬ፥ የና ከትም እካንታ እምሰዬ፥ ከተረ የስታ ቃለን ካርስተኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","የስ እካንታ እምሳንዳ ሙደና የዘንካ ማቻንግንዳ ከታ ታ ኤስተኬ። ");
INSERT INTO gyl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","የስ እካንታ እምሳን ቃለን ከትካንታ እምትቴ፥ ከተረ ኮትም ተይተኬ፥ የስታ ባንግርንካ እ Ꮊዳንደትም ዶፈንካ ኤስተኬ፥ የስ እም ኦይቻንደትመረ ከታ አሜንተኬ። ");
INSERT INTO gyl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“እ ምግዝድንዳ ከትካንቴ፥ ከታኬና የስ እካንታ እምስባብ የስታ ከት ማቻንጎካ ከትካንታ ምግዝድቴ፥ ፍጫሙደንካንታ ምክሳይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","እስታ ማቻን ሙደና የስቴ የስተረ ማችባብ እስቴ፥ እተረ ከትካ ቦንችምድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","እታ ኮዘንካ ኦስ ፍጫሙደንዘን ዶቃይቴ፥ ከታ ማቼ ፍጫ ሙደንዘኔ። እታ የዝደር Ꮊድቴ፥ ጭል እስታ ባቤኖ፥ ኬና እካንታ የስ እምስባብ ዎግንዳ ዋልቃ ከት ማድንግንዳ እካንታ የስ እምሳን የስታ ላምንካ ከትም ካርስካ። ");
INSERT INTO gyl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","እታ ከትካ የካ እ Ꮊቃንደትካ የስ እካንታ እምሳን የስታ ላምንካ ከትም ካርስትቴ፥ እተረ ከትም ካርሳቴ፥ ኮ ኦላር ጭል ማጻፍንታ ቃለና ቦድምድን ግንዳ ክትኮ ካይንታ ይንችንዘንካ አብ ከታርንካ ቦድሶ Ꮊየነረ ካያክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ታ እታ የዝደር Ꮊድቴ፥ ፍጫሙደንዘን ዶቅድቶ ኮም እ ኬዝድንዳ እስታ ጉርምና ከታዘን ቦድማ ማድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","እታ የስታ ቃለን ከትም እምትቴ፥ እታ ፍጫሙደንዘንካ እ ማታክንግንዳ ከተረ ፍጫሙደንዘንካ ካየኬ፥ ኮካንታ ፍጫ ሙደና ከትም ግርዴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ዳቅልንዘንካ ከትም የስካርዝድንግንዳ ዳት ፍጫሙደንዘንካ ኦስ አበር የስ ከትም ተይ አይድን ግንዳ ምክሳይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","እታ ፍጫሙደንዘንካ እ ማታክንግንዳ ከተረ ኮ ፍጫሙደንዘንካ ካየኬ። ");
INSERT INTO gyl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","የስታ ዶፈንንካ የስካንታ ፋስምስባብ ከትም ማስካ፥ የስታ ቃለና ዶፈኔ። ");
INSERT INTO gyl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","የና እም ኮ ፍጫሙደንዘን የስ እም ኦይቻንግንዳ እተረ ከትም ኮ ፍጫሙደንዘን ከትም ኦይችቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ከታ ዶፈንካ የስካንታ ፋስምስባብከስ ከት ማድንግንዳ እታ እስታ ማተንም ከትካንታ ጋይስቶ ፋስምስባብ ማዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ከታ ቃለንጎካ እንከረ ከት አሜንምድን ኦል ምግዝድት ዳት ከትካንታ Ꮊክ ምክሳይቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","እተረ እ ምግዝድንዳ ሙደነረ ዋልቃ ከት ማድንግንዴ፥ ኮትኮግንደረ እባቦ! የና እንካ የስ ዶቅድንደትም፥ እተረ የስካ እ ዶቅድንደትም፥ ከተረ ዎንካ ከት ዶቅተርንግንዴ፥ የስ እም ኦይቻንግንደረ ፍጫ ሙደና አሜንድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ዎታ ዋልቃ ዎ ማቻንግንዳ ከተረ ዋልቃ ከት ማተርንግንዳ እካንታ የስ እምሳን ቦንቸን ከትካንታ እምትቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","እ ምግዝድንዳ እታ ከትካ የነረ እንካ የስ ማቻንግንዳ ከተረ ቦድመካ ዋልቃ ከት ማድንግንዴ፥ ኮትኮግንደረ እም የስ ኦይቻንግንደከ እም የስ ሶልምሳን ከካ ከትመረ የስ ሶልምሳንግንዳ ፍጫ ሙደና ኤዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“እባቦ! ፍጫ ሙደና ፍዝማክናና የስ እም ሶልምሳንጎካ የስ እካንታ እምሳን እስታ ቦንቸን ከት ሰድንግንዳ ከታኬና የስ እካንታ እምስባከሰረ እ ዶቅድን ካርዘን እንካ ክክን ከትዶቅድንግንዳ እታ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ጭል እባቦ! ፍጫ ሙደና የስም ኤሳክዬ፥ እታ ማቸ የስም ኤዝድቴ፥ ከታከነረ የስ እም ኦይቻንደትም ኤስተኬ። ");
INSERT INTO gyl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","የና እም የስ ሶልምሳን ሶልመና ከታዘን ማድንግንደከ እተረ ከትካ እ ማተርንግንዳ ከተረ የስም ከት ኤስተርንግንዳ ይትቴ፥ ጉጅሰረ ከት ኤዝድንግንዳ ከትም ማስትቴ።” ");
INSERT INTO gyl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","የሱስ ኮም ምክስን ይ በይሳንደታ ቡር ይንታ ካርንካ ጎርስምድባብከስካ ክክን ኦስ ቀድሮን ቦደንታ ፋማ አይሴ፥ ኦ ዋረረ ዶቅድንደት ኮረርሳን ኮረናር ይንታ ካርንካ ጎርስምድባብከስካ ክክን አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","የሱሰኬ ክታ ካርንካ ጎርስምድባብከስ ካርንኮታር ሙዳᎺይካ ሳንምደኮ Ꮊቃንጎካ ስክስትዮ ክትም እምስባብ ይሁዳ ካርን ኮትም ኤዝዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ኮካንታ ይሁዳ ዋልቃ ዙግር ዳምንባብከስም፥ ኮትኮግንደረ ቀሰንከስም ገችንባብከስኬ ፈረሳዊያንንከዘንካ ኦይትምስባብከስ ካርስንባብከስም ክድባብከስም ጎርስሶ ካርንኮታር Ꮊዴ፥ ከተረ ኩራዝካ ሳግዝድንደትምኬ ዞንበካ ኖሀ ዞጵስሶ፥ ዳምይ ካችመረ የተክ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","የሱሰረ ይም የልድንደትም ሙደንም ኤስሶ ኦስ ከደር ዉትሶ “የታ Ꮊይመንት ዝግዳ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ከተረ “ናዝረትንክንባብ የሱሰም ዝግዶቴ” ክደር ጋይሰኬ። ኖየረ “እትቴ!” ከደር ጋይሴ። ስክስት እምድባብ ይሁደረ ከትከረ ክክን ዎእሶ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","የሱሰረ “እትቴ” ከደር ጋይሳንደትካ ቡደካ አይሰኮ ፍጨዘን ዋቸኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","የሱሰረ “Ꮊይመንት ዝግዳ?” ጋየሮ አነታ ከትም ኦይሴ። ከተረ “ናዝረትንክንባብ የሱሰም ዝግዶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","የሱሰረ “እትቴ የንደር ጋይትቴ፥ ይና የ ዝግድንዳ እም ማቼ ከትከነም ዛእከቴ፥ ከት አያ” ኖ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ኮነረ ማቻንዳ፥ (እባቦ፥ የስ እካንታ እምሳን ኤድንከሳርንካ ዋልቀንም ዎራ እታ ካይሳክቴ) ጋይሳን ቃለና ቦድምድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ስምኦን ጴጥሮስ ዳም ማሰን የድሶ Ꮊቃንጎካ ጎችትዮ ቀሰንከስም ገችዝድባብታ ፍክስንባብም ፋክሶ ክታ ምዝ ቃምን ተቼ፥ ክትኮ ፍክስንባብተረ ላምና “ማልኮስ” ጋይምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","የሱስ ማቼ ጴጥሮስም፥ “የስታ ዳምይ ማሰንም ሶግናር አርችካ፥ እባብ እካንታ እምሳንደትም ማጠንታ ኡፍተናር ዎጭምን እ ዎጭዳክን የስም ካምዶ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ኮታ ቡር ዳምንባከስኬ ከትም ክድባብ፥ አይሁድንከስታ ካርስንባብከስም ክድባብከሰረ የሱሰም የድሰኮ ዞክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","እርምሶ ኦስ ሀነደር ክትም ተይ አይሰኬ፥ ሀነረ ኮት ስለናር ቄሰንከስታ ገችንባብ ቀያፈታ በይስስ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ቀያፋ “ዋልቃ ኤድ ዎርሰንካንታ ደእሰስናና ኡርዴ” ጋይንተካ አይሁድንታ ገችታ ኤረንባብከስም ዞርስባቤ። ");
INSERT INTO gyl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ስምኦን ጴጥሮስከ አብ ክታ ካርንካ ጎርስምድባብ የሱሰም ጎርስምሰኬ፥ ኖኮና አብ ክታ ካርንካ ጎርስምድባብ ቀሰንከስም ገችዝድባብደር ኤስምስባቤ፥ ኮካንታ የሱሰካ ክክን ቄሰንከስም ገችዝድባብታ ጋስናር አርደዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ጴጥሮስ ማቼ አርድን ፍልተንታ ማልጎካ ዎእሶ Ꮊቄ፥ ቄሰንከስታ ገችንባብደር ኤስምስባብ የሱሰታ ካርንካ ጎርስምድባብ Ꮊድሶ ፍልተንዘን ዶቅድን ማና ይንቸንካንታ ኬዝሶ ጴጥሮሰም ጋስናር አርችሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ፍልተንዘንደረ ይንቸና ጴጥሮስም “የነረ ኮ ኤችንታ ካርንካ ጎርስምድባባርንካ ዋልቀና ካዮ?” ክትም ና ጋይሴ። ኖ ማቼ “እታ ካይቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ሰጨና ቃዝ ቃዝድንኦል ፍክስንባብከስኬ ካርስንባብከስም ክድባብከስ ኖሀ የችሰኮ ኦይጥረሮ Ꮊቀኬ፥ ጴጥሮሰረ ከትካ ክክን ዎእሶ ኖሄን ኦይጠርድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ኮትᎺይካ ቄሰንከስም ገችዝድባብ የሱሰም ክታ ካርንካ ጎርስምድባብከስጎኬ ክታ ኤስስንታ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","የሱሰረ፥ “እታ ኤድ ሙደንካንታ መየካ ከዛቴ፥ አይሁድንከስ ሙዳ ከት ሳንምድን ከታ ምክስ ኤሄናርንከ ሳብታ ጭል ኤሄናር፥ ሙዳᎺይካ ኤስስቴ፥ አቸካ እከዛንዳ Ꮊረርየረ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ይና፥ Ꮊረተስ እም የና ኦይዝዳ? እ ከትካንታ ኬዝድንካ እዝደር ኤሰርስባብከስም ኦይስካ፥ እ ኬዛንደትም ከታ ኤዝደኬ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","የሱስ ኮም ክት ኬዛንደትካ ካርን ኮታር ዎእሶ Ꮊቅባከሳርንካ ካርስንባብከስም ክድባባርንካ ዋልቀና፥ “ቀሰንከስም ገችዝድባብደር የስ ክትም ማዝድንዳ ኮግንደኮ?” ጋይሶ የሱሰም ጫቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","የሱሰረ “ዳቅል ኬዘም እ ከስታ ማቼረ ዳቅል እስታ ኬዘንም ማርከርካ፥ እከዛንዳ ገታ ኮት ማቼ Ꮊረተስ እም ጉጵዳ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ኮታ ቡር ሀና፥ የሱሰም ክት ዞከርሳን ግንዳ ቄሰንከስም ገችዝድባብ ቃያፈደር ማስትዮ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ኮታይከረ ስምኦን ጴጥሮስ ዎእሶ ኖሀ ኦይጠርድ Ꮊቄ፥ አብ ኤድንከሰረ “የና የሱሰታ ካርንካ ጎርስምድባብከሳርንካ ዋልቀነይ ካዮ?” ክትም ጋይሰኬ። ኖየረ “እታ ካይቴ” ጋይሶ ካጄ። ");
INSERT INTO gyl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ጴጥሮስ ቃምን ክታ ተችባብ ኤችንታ ሱሳ ማችባብ ቀሰንከስታ ገችንባብታ ፍክስንባባርንካ ዋልቀና ኮረንከስም ኮረርሳን ካርናር ክትካ ክክን የስም ሰዳክቶ? ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ጴጥሮሰረ አነታ ካጄ፥ ሳነካ ባቸና ቅቅሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ኮታ ቡር የሱሰም ቀያፈታ ኤር ፍጨንም ቆልስባብ ጵላጦሰታ ጋስናር ተይ አይሰኬ፥ ሰጨነረ ዛማ ሰጭማ Ꮊቄ፥ አይሁድና ፋስጋ ባአልንታ ማችምድን ቆለን እች ከትም ዝግዝድን ኦል ከት ቱና ማዳክንግንዳ ጋይንተካ ፍጨን ቆልድባብታ ጋስናር አርዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ኮካንታ ጵላጦስ ከደር ዉትሶ “ኮ ኤችንታ ዘን የንታ ክስና Ꮊራ?” ጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ከተረ “ኮና ኤችና ዳቅል ፍግዝድባብ ማታከስ ናና የስካንታ ስክስት እምተራኮትዶቆ” ጋየረኮ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ጵላጦሰረ “የታ የንታ ማታርንካ ተይ አይሰቶ የንታ ህግንግንዳ ክታዘን ፋረድከቴ” ከትም ጋይሴ። አይሁድነረ “ዎ ኤድም ደይዝድንግንዳ ዎካንታ ጋይማክዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ኮነረ ማቻንዳ የሱስ Ꮊስግንዳ ደእካ ደእዳ ናንከረ ክት ኬዛን ቃለና ቦድምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ጵላጦሰረ አነታ ይንታ ጋስናር ማትዮ አርደዴ፥ የሱሰመረ ኤልሶ “የና አይሁድንታ ባንቾ?” ጋየሮ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","የሱሰረ “የስ ኮም ጋይድንዳ የዘንኮ? አነረ አብንከስ ኮም እጎካ የስም ከዘኮ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ጵላጦሰረ “እታ አይሁድቶ? የስም እካንታ ስክስት ከት እምሳንዳ የስታ ኮችንከስከ ቀሰንከስም ገችዘድባብከስኬ፥ Ꮊራ ሪየረ የስ ይሳንዳ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","የሱስ “እስታ ባንችምና ኮ ፍጫሙደንዘንካ ካዬ፥ እስታ ባንችምና ኮ ፍጫሙደንዘንካ ማቸስናና አይሁድንታ ገችታ ኤረንባብከስታ አንናር እ ዋችተራክን ግንዳ እስታ ፍክስንባብከስ እካንታ ዳምተረክዶቆ፥ እስታ ባንችምና ኮ ፍጫሙደንዘንካ ካዬ” ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ጵላጦሰረ ይና፥ የና ይንትም ባንቸዬ ክትም ጋይሴ። የሱሰረ “እ ባንችን ማቻንደትም የና ጋይሳዬ፥ እ አጥምሳንደትኬ ኮ ፍጫሙደንዘን እ Ꮊዳንዳ ዶፈንንጎካ ማርከርካንቴ፥ ዶፈንንዘንካ ማቻንዳ ሙደና እስታ ቃለንም ኤሰርደኬ” ጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ጵላጦሰረ “ዶፈንና Ꮊራ?” ጋይሶ ኦይሴ። ኮታ ቡር ጵላጦስ አነታ አይሁድንከዝደር ዉትሶ ኩን ከደር ጋይሴ፥ “እታ Ꮊረነረ ባች ክታዘንካ Ꮊፋክቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ኬዛርካ ማቼ የንታ መጠንግንዳ ፋስጋ ባአልንካ ሙዳᎺይካ ዋልቃ ዞከርስባብም ብልድቴ፥ ኮካንታ አይሁድንታ ባንችንም የካንታ ብልድንግንዳ የታ ዝግደቴ?” ");
INSERT INTO gyl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ከታ ማቼ “ባርባንም ዎካንታ ብልካ ዳት ክትኮም ካዬ!” ጋየረኮ ፍፍሰኬ። ባርባን ማቼ ፋንጋ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ኮታ ቡር ጵላጦስ የሱሰም ተይ አይሶ Ꮊርችሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ዳምንባብከሰረ ጋልም ቆጵ ኡርስተኮ የሱሰታ ማተንዘን ዎጀኬ፥ ዘይም አፍለመረ ክትም ቆፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ክደረረ Ꮊደረኮ Ꮊልተርካ “አይሁድንከስታ ባንችኖ! ሳራትቸና የስካንታ ማታ!” ክትም ጋየሮ አነረ፥ ክትም ጫቀረኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ጵላጦሰረ አነታ ማል ዉትሶ “እታ ክታዘን Ꮊረነረ ዳቀልስ እ Ꮊፋክንደትም የ ኤስተርንግንዳ ክትም የካንታ ማል ዉጅድቴ” ከደር ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ኮካንታ የሱስ ጋልንታ ቆጵን ዎድንደትከ ዘይም አፍለን ቆበርሶ ማል ዉተዴ፥ ጵላጦሰረ “ይና ኤችና የንታ ኮኔ!” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ቄሰንከስታ ገችንባብከስከ ካርስንባብከስም ክድባብከስካ የሱሰም ሰድሰኮ “ሮካ! ሮካ!” ጋየረኮ ፍፍሰኬ። ጵላጦስ ማቼ “እጎካ ማቸ Ꮊረነረ ዳቀልስ ክታዘን Ꮊፋክቴ፥ የ ክትም ዝግዜ የታ ተይ አይሰቶ ክትም ሮከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","አይሁድንከሰረ “ዎንታ ህግ ዶቅዴ፥ ኮና ኤችና ይንታ ማቴን ሳብታ ይንች ክት ማስሳንጎካ ዎንታ ህግንግንዳ ክትም ደእ ዝግዝዴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ኮም ሙዳ ርም ይ ኤሰርሳንደትካ ጵላጦስ ስግ ጳሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ይንታ ጋስናረረ አርድሶ የሱሰም “የና Ꮊምንከረ?” ጋይንተካ ኦይሴ። የሱስ ማቼ Ꮊረነረ ክትካንታ ማሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ኮካንታ ጵላጦስ “የና እካንታ ከዛያ? እታ የስም ቡልካንታ አነረ የስም ሮክካንታ ገችታ ኤራ እስታ ዶቅድንደትም የና ኤሳያ?” ክትም ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","የሱሰረ “ሳብዘንካ ገችታ ኤራ የስካንታ እምማከስናና እዘን Ꮊረነረ ገችታ ኤራ የዘን ዶቅተራክ ዶቆ፥ ማችንከረ የስካንታ ስክስት እም እምስባብ ስግ ጎማ ክታዘን ዶቅዴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ጵላጦስ ኮም የሱሰታ ኬዘን ኤሰርሳንደትካ ብልት ኦይትካንታ ዝግዜ፥ አይሁድንከስ ማቼ “ኮ ኤችንም የስ ብልሴ የና ሮማ ባንችንታ ገርና ካየዬ፥ ይንታ ማተን ባንችን ማዝድባብ ሙደና ባንችንታ ይምኤንባቤ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ጵላጦስ ኮም ይ ኤሰርሳንደትካ የሱሰም ማል ዉችሶ “ላጳ ላጵይ ሰይን” ጋይምሳን ካርዘን ፍርደን እመርድን ጎንገንዘን ዶቅሴ፥ ኮና ካርና እብራይስጥ አፈካ “ገበታ” ጋይምዴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ሰጨነረ ፋስጋ ባአልንታ ግክስ ሰጭ Ꮊቄ፥ ኮትካ ላ ሳዓት ማታባብ Ꮊቄ፥ ኮትᎺይካ ጵላጦስ አይሁድንከስም “የንታ ባንችና!” ከደር ጋይሴ ");
INSERT INTO gyl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ከታ ማቼ “ክትም Ꮊልእስካ! ክትም Ꮊልእስካ! ክትም ሮካ!” ጋየረኮ ፍፍሰኬ። ጵላጦሰረ “የንታ ባንችን ሮክትቶ?” ከደር ጋይሴ። ቀሰንከስም ገችዝድባብከሰሬ “ሮማ ባንችንዘንካ አብ ባንች ዎንታ ካዬ!” ጋየረኮ ክትካንታ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ኮትᎺይካ የሱስ ሮከርድን ግንዳ ጵላጦስ ስክስትዮ ክትም ከትካንታ እምሴ፥ ከተረ የሱሰም የድሰኮ ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ኮታ ቡር የሱስ ማዝቀልን ባልሶ “ራስቅል” ጋይምድን ካርዘን ዉተዴ፥ ኮና ካርና ዕብራይስጥ አፈካ “ጎልጎታ” ጋይምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ኮታረረ ክትም ሮክሰኬ፥ የሱሰም ዎክያር ማስሰኮ፥ ክትካ ክክን አብንከስመረ ቃስተን ኤድም ክታ ብተዘንጎኬ ምዝዘንጎካ ሮክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ጵላጦስ “ናዝረት የሱስ፥ አይሁድንከስታ ባንቼ” ጋይድንደትም ጻፍትዮ ማዝቀልንዘን የሱሰታ ቃደንታ ዘርመዘን ቶሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","የሱስ ሮከርሳን ካርና ካተመን ካንታ ቅንች Ꮊቃንጎካ፥ አይሁድናርንካ በድንከስ ጻፈርሳንደትም ናበብዘኬ፥ ጻፍምሳንደረ እብራይስጥካ፥ ላትንከ፥ ግርክ አፈካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","አይሁድ ቀሰንከስታ ገችንባብከስ ጵላጦሰም፥ “የና ‘አይሁታ ባንችን’ ጋይሰዮ Ꮊይጻፌ፥ ኬዛር ማቸ ‘ኮና ኤችና እታ አይሁድንታ ባንችቴ’ ጋይቴ ጋይሶ ጻፍካ” ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ጵላጦስ ማቼ “እ ጻፍሳንደትም ጻፍትቴ” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ዳምንባብከስ የሱሰም ከታ ይ ሮክሳን ቡር፥ ክታ አፍለንከስም ተየኮ ዋልቃ ዋልቃ ዳምንባብም ዋልቃ ካስ የልድን ግንዳ ኦይድ ካርዘን ካሰኬ፥ ሳምዝንመረ ኮትኮግንዳ ይሰኬ፥ ኬዛር ማቼ ሳምዝና ዛግማክዶቆ፥ ፈይንካ ሶ የለልታ ዉች ፍክስምሳንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ኮካንታ ዳምንባብከስ “Ꮊይካንታ የልዳ ናንከረ ኤስካንታ እጫ ዎታ ዛቅቶሮት ዳት፥ Ꮊእሰርዳክዬ” ጋይሰኬ። ኮነረ ማቻንዳ፥ “እስታ አፍለንም ካስምሰኬ፥ እስታ ሳምዝንተረ እጫ ዛቅሰኬ” ጋይድንዳ ጭል ማጻፍንታ ቃለና ቦድምድንግንዴ፥ ዳምንባብከሰረ ኮትኮግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","የሱሰታ ማዝቀልንታ ላማር እንደንኬ እንደንታ ምችነንካ፥ ቃሎጴታ ኬነን ማራመትኬ ማግደላ ፍጨንካ Ꮊዳን ማራመትካ ዎእሶ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","የሱስ ይንታ እንደንምኬ ይ ሶልምድባብም ይንታ ካርንካ ጎርስምድባብ ክታ ላመር ዎእሳንደትም ሰዳንደትካ፥ ይንታ እንደንም “እስታ እንደኖ! ይና፥ የስታ ይንችና!” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ኮታ ቡር ይንታ ካርንካ ጎርስምድባብም “ይና ኮሰቼ የስታ እንደና!” ክትም ጋይሴ፥ ኮት ሳዓትንዘንካ የድሶ ክታ ካርንካ ጎርስምድባብ ይንታ ኤር ኮትም ተይ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ኮታ ቡር የሱስ ታ ሙዳ ሪነረ ቦድምሳንደትም ኤስሶ ጭል ማጻፍናር ጻፍምሳንዳ ቃለና ቦድምድን ግንዳ “ቡዳ እስታ ዎቼ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ኮታር ጫቅምድንደትም ጮቸርሳንዳ ዋልቃ ርይካ ዎጅንካ Ꮊቄ፥ ኮካንታ ኮታር Ꮊቅባብ ኤድንከስ፥ ጫቅምድንደትም ስፎንግ ጋየርድንዳ ጩንጭት የድ ር ዳልች ግንደንካ ጮችሰኮ ህሶጵ Ꮊቀካ የተኮ ክታ አፈንዘን የልስሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","የሱሰረ ጫቅምድንደትም ይ ዎጫንደታ ቡር “ቦድምሴ!” ጋይሴ። ይንታ ማተን ከለዘን ማስሶ ሰንፔን ይንታ ስክስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ኮታ ቡር አይሁድንታ ገችታ ኤረንባብከስ፥ ሮከርስን ኤድንከስታ ገስን ቁንጭሰኮ፥ ከታ ለይስን ማዝቀልንዘንካ ከት Ꮊንችድን ግንዳ ጵላጦሰም ምክሰኬ፥ ኮመረ ከት ይሳንዳ አይሁድንታ Ꮊዉስ ሰጨንታ ግክሰርድን ሰጫ ማቻንካንተከ ናኮና አይሁድንታ Ꮊዉስ ሰጨነረ አንድር ባአል ማቻን ካንታ፥ ኮትኮ Ꮊዉስ ሰጨንካ ከታ ለይስና ማዝቀልዘን ማዳክንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ኮካንታ ዳምንባብከስ አይሰኮ፥ የሱሰካ ክክን ሮከርስባብ ኤድንከስታ ገስን ቁንጨኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","የሱሰደር ከት የልድንካ ማቼ፥ ኖ እርምሶ ክት ደእሳንደትም ሰድሰኮ፥ ክታ ገስን ቁንጫከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ኬዛር ማቼ ዳምንባከሳርንካ ዋልቀና፥ ከለን ክታ ካችምካ እክሴ፥ ሳነካ ክታ ከለናርንካ ማቀስከ ሎቀካ ዉልእምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ኮም ሰድባብከስ፥ የ አመንምተርን ግንዳ ማርከርሴ፥ ክታ ማርካትችነረ ዶፈኔ፥ ክት ኬዝድንደረ ዶፈን ማቻንደትም ኖ ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ኮነረ ማቻንዳ “ክታርንካ ዋልቃ ለፍ ዎራ ቁንጭምዳክዬ” ጋይድንዳ ጭል ማጻፍንታ ቃለና ቦድምድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ጉጅሰረ አብ ጭል ማጻፍናር ከታ “ይ እክስባብም ሰተረኬ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","አይሁድንታ ገችታ ኤረንባብከስም ጳስካ የሱሰታ ካርንካ ጎርስማᎺቅባብ አርማትያስ ዮሴፍ አቸካ የሱሰታ ለይስን ተይ አይካንታ ጵላጦሰም ምክሴ። ጵላጦሰረ ዱካ ክትም ጋይሴ። ኮካንታ ዮሴፍ አይሶ ለይስንም Ꮊንችሶ ተይ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ኮታ እሪ ገልትገር የሱሰደር አይስባብ ንቆድሞሰረ በድ ስንጋ ማቻንደትም ከርበኬ ጫቅምድንደትካ ኖሀ ኤልካ ቡቅምሳንደትም የድሶ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ቃስተን ኤድንከስ የሱሰታ ለይስን ተይሰኮ አይሁድንከስታ አክስንግንዳ ዎዝድንደትካ ክክን ሳዝ አፍለካ አክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","የሱስ ሮከርሶ Ꮊቃን ካርና ኮረንከስም ኮረርሳን ካሪ Ꮊቄ፥ ኮትኮ ኮረን ኮረርሳን ካርናር Ꮊየነረ ዱከራክንዳ ክላ ዱክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","አይሁድንታ Ꮊዉስንታ ግክስ ሰጭ Ꮊቃንጎከ ዱክ ካርነረ ቅንች ማቻንጎካ የሱሰታ ለይስንም ኮታር ዱክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ዎጋᎺይካ ዛማ ሰጭማ፥ አክ ማላ ዘያክናና፥ ማግደላ ፍጨናርንዳ ማራማ የሱሰታ ዱክንደር አይሴ፥ ኦኮታረረ ይ የልሳንግንዳ ዱክንም ዝጭሶ Ꮊቃን ሰይንና ዱክንታ ፍልተንዘንካ ቡከልስንካ ና ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ኮካንታ ና ስምኦን ጴጥሮስደርኬ የሱስ ሶልምድን አብ ክታ ካርንካ ጎርስምድባብከዝደረ ዞደሮ አይሶ “ጮይስም ዱክናርንካ ዉችትዮ ተይተኬ፥ Ꮊብር ከት ዎጅንዳ ማቸረ ዎታ ኤሳዮቴ” ና ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ኮታይካ ጴጥሮስኬ አብ ክታ ካርንካ ጎርስምድባብካ ዉትሰኮ ዱክንደር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ቃስተንንከሰረ የካ ዞደሮ Ꮊቀኬ፥ ኬዛር ማቼ አብና የሱሰታ ካርንካ ጎርስምድባብ ጴጥሮስዘንካ ስግ ሳነካ ዞደሮ እርምሶ ዱክንደር የልሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ይርክን ጋይሶ ዱክናር ክት ሰድንካ ክትም አክሰርሳን አፍለና ይንት ዶቅድንደትም ኖ ሰጄ፥ ኬዛር ማቼ ዱክንታ ዋር አርዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ስምኦን ጴጥሮሰረ ክትም ጎርስምሶ ይ Ꮊዳንግንዳ ዱክንታ ዋር አርደዴ፥ ኖየረ አክሰርሳን አፍለና ዋር ዶቅድንካ ሰዴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","የሱሰታ ማተን ከት ዞክስንካ Ꮊቃን አፍለና ክትም አክሰርሳን አፍለንካ ክክን ማታክዶቆ ይንት Ꮊክ አብ ካርዘን ቁርምሶ ዶቅድንካ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ኮታዘንከረ እርን Ꮊድባብ የሱሰታ ካርንካ ጎርስምድባብ ዱክናር አርድሶ ሰድሶ አሜንሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ኮነረ “ደእያርንካ አም ክትም ዝግዝዴ” ጋይድንደትም ጭል ማጻፍንታ ቃለን አክ ገቀርት ተያከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ኮታ ቡር ቃስተነረ የሱሰታ ካርንካ ጎርስምድባብከስ ማተኮ ይንታ ኤሪ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ማግደላ ፍጨናርንዳ ማራማ ኤፈሮ፥ ዱክ ጎርንታ ማልጎካ ዎእሶ Ꮊቄ፥ ኤፈሮ ይርክን ጋይሶ ዱክንታ ዋር ና ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","የሱሰታ ለይስን Ꮊቃን ካርንዘን ጫምሳ አፍላ ቆበርስባብከስ ቃስተን ክታይንችንከስ ዋልቃባብ ቃዳኦል ጎካ ዋልቃባብ ዱት ኦል ጎካ ዶቅሶ ዶቅድንካ ና ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ከተረ ማራመም፥ “የና ኤተኖ! Ꮊረተስ ኤብዳ?” ኮደር ጋይሰኬ። ናየረ “እስታ ጮይስን ተይ አይሰኬ፥ Ꮊብር ከት ዎጃ ናነረ ኤሳይቴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ኮመረ ና ጋይሶ ይንታ ቡር ዋልን ኮት ጋይድንካ የሱሰም ዎእሶ ክት ዶቅድንካ ክትም ሰዴ፥ የሱስ ክት ማቻንደትም ና ኤሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","የሱስ፥ “የና ኤተኖ Ꮊረተስ ኤብዳ፥ Ꮊይመስ ዝግዳ?” ኮትም ጋይሴ። ናየረ Ꮊምንባብ ካምስንካ፥ “እባቦ! የስ ተይንዳ ማቼ የስ Ꮊብር ዎጃናንከረ ዋደ እም ከስካ፥ እታ ተይ አይትቴ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","የሱሰረ “ማራሞ!” ኮትም ጋይሴ። ናየረ ክደር ዋልን ጋይሶ እብራይስጥ አፈካ “ረቡን!” ክትም ጋይሴ፥ ቡልነረ “የና ኤስስንባቦ!” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","የሱሰረ “አክ እባብደር አያክቴ እም Ꮊይ ዎሌ ኬዛርንካ ማቼ እስታ እስመንከዘደር አይሳዮ ‘እታ እባብደርኬ የንታ ባቤንደር፥ እስታ ጮይስንደርኬ የንታ ጮይስንደር አይድቴ ኖ ጋይቴ’ ጋይሰዮ ከትም ኬዝካ” ኮትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ኮካንታ ማግደላ ፍጨናርንዳ ማራማ የሱሰታ ካርንካ ጎርስምድባብከዝደር አይሶ ጮይስም ይ ሰዳንግንደኬ ኖየረ Ꮊስ ኮትካንታ ጋይሳናነረ ከትካንታ ና ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ኮትኮ ሳምንትንታ እር ሰጨን ዎጋᎺይካ ሶይት የሱሰታ ካርንካ ጎርስምድባብከስ አይሁድንከስታ ገችታ ኤረንባብከስም ጳስካ፥ ፍልተንም ዝጭሰኮ፥ ኤሄንታ ዋር ሳንሶ Ꮊቀኬ፥ ፍልተንከስ ዝጭምሶ ዶቅድንካ የሱስ ክታ ካርንካ ጎርስምድባብከስ ሳንምሳን ኤሄናር አርደዴ፥ ከታ ዎክናረረ ዎእሶ፥ “ሳራትቸና የካንታ ማታ!” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ኮመረ ጋይሶ ይንታ አንንከስምኬ ይንታ ከለን ከትም ሰችሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ጮይስም ከታ ይ ሰዳንደትካ ጉርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ኮታ ቡር የሱስ አነታ “ሳራትቸና የካንታ ማታጋካ! ሳብ ባቤና እም ኦይቻንግንዳ እተረ የም ኦይድቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ኮም ጋይሶ ኡፍ ከታዘን ጋይስንካ “አያን ጭልንም ተየኬ፥ ");
INSERT INTO gyl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","የታ ኤድንከስታ ጎመን ነጋ የ ጋይዴ ነጋ የካንታ ጋይምተሬ፥ የታ ኤድንከስታ ጎመን ነጋ ጋይዳክንዳ ማቼ፥ ነጋ የካንታ ጋይምተራክዬ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","የሱስ ይንታ ካርንካ ጎርስምድባብከዝደር Ꮊዳንደትካ ታመከ ቃስተንንከሳርንካ ዋልቀና፥ ድድሞስ ጋይምስባብ ቶማስ ከትካ ክክን Ꮊቃክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ኮካንታ አብንከስ የሱሰታ ካርንካ ጎርስምድባብከስ ቶማዝደር “ጮይስም ሰዶቴ” ክደር ጋይሰኬ። ኖ ማቼ “ምስማርንካ እከርስባብ ክታ አንንከስም እ ሰዳክንዳ ማቸኬ እስታ ግልኤንም ምስማርንካ እከርሳንደታር እ አርቻክንዳ ማቼ፥ እስታ አንንታ ግልኤንም ክታ ከለን እከርሳንደት ካርናር እ አርቻክንዳ ማቼ አመናይቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","“ላመካይ ሰጨታ ቡርጎካ የሱሰታ ካርንካ ጎርስምድባብ አነታ ኤሄንታ ዋር Ꮊቀኬ፥ ቶማሰረ ከትካ የካ Ꮊቄ፥ ፍልተንከስ ዝጭምሶ ዶቅድንካ የሱስ Ꮊድሶ ከታ ዎክያር ዎእሶ እስታ ሳራትቸና የካንታ ማታ!” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ኮታ ቡር ቶማስም፥ “የስታ ግልኤን ኮር ተይ Ꮊድሶ እስታ አንንከስም ሰድካ፥ የስታ አንንመረ ተይᎺድሶ እስታ ከለንዘን አርችካ፥ አሜንካ ዳት Ꮊይ Ꮊኤእሬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ቶማሰረ “እስታ ጮይስኖ! እስታ ሳብኖ!” ጋየሮ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","የሱሰረ ቶማሰም “የና ማቼ የስ እም ሰዳንኦል አሜንሳዬ፥ እም ሰዳከክ ዶቆ አሜንድባብከስ ማቼ ከታ አንጅምስባበኬ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","የሱስ ኮማጻፍናር ጻፍማክንደትም በድ አታ ክታ ካርንካ ጎርስምድባብከስታ እር ይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ኬዛር ማቼ የሱስ ሳይምስባብ ሳብታ ይንች ማትንተን የ አሜንተርንግንደኬ፥ የታ አሜንሰረ ክታ ላምንካ ስለንካ ዶቅድን ሰንፔንም የ Ꮊፍተርንግንዳ ኮና ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ኮታ ቡር የሱስ ጢብራዶስ ባሀርንታ ላማር፥ ይንታ ካርንካ ጎርስምድባብከስካንታ አነታ መያ ማቼ፥ ክታ መያ ማትነረ ኮግንዳኩኔ፥ ");
INSERT INTO gyl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ስምኦን ጴጥሮስ፥ ድድሞስ ጋይምስባብ ቶማስ፥ ቃና ገልለንክንባብ ናትናኤል፥ ዛብዶሰታ ይንችንከስኬ አብንከስ ቃስተን ክታ ካርንካ ጎርስምድባብከስ የካ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ስምኦን ጴጥሮስ “ሞላ የድካንታ እታ አይድቴ” ከደር ጋይሴ። ከተረ “የስካ ክክን አይዶቴ” ክደር ጋይሰኬ፥ ዉትሰረ አይሰኮ ሎቀዘንካ ቃልዝድን ጃልበናር አርደደኬ፥ ኬዛር ማቼ ኮት ሶይትንካ ዋልቃ ሞላ ዎራ የዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ሰጭድንካ የሱስ ባሀርንታ ላማር ዎእሴ፥ የሱሰታ ካርንካ ጎርስምድባብከስ ማቼ የሱስ ክት ማትንተን ኤሳከኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","የሱሰረ “እስታ ይንችንከሶ! ዋልቃ ሞላ የንደር ዶቅዶ?” ከደር ጋይሴ። ከተረ “Ꮊረነረ ዎንደር ካዬ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ኖየረ “የንታ ሞለን የድን ሳከን ሎቀንዘንካ ቃልዝድን ጃልበንታ ምዝዘን ጎካ ኦይትሰቶ Ꮊብደቴ” ከትም ጋይሴ። ኮካንታ ሞለን የድን ሳከን ባሀርንታ ዋር ኦይቸኬ፥ በድ ሞለረ ከታ የድንዘንካ አምሳንዳ ሳከን ጎችና ከትም ጋምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ኮትᎺይካ የሱስ ሶልምድን ክታ ካርንካ ጎርስምድባብ ጴጥሮሰም “ጮይስ ዳት!” ክደር ጋይሴ። ስምኦን ጴጥሮስ “ጮይስዬ” ጋይንተንም ይ ኤሰርሳንደትካ ፍክስካንታ ጋይሶ ይንታ አፍለን ዉችሶ ይ Ꮊቃንኦል ሳነካ አፍለን ቆበርሶ ባሀርናር ጎብሶ አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","አብንከስ የሱሰታ ካርንካ ጎርስምድባብከስ ማቼ ፍጨንዘንካ ከት ጎተርሳንዳ ጨታ ኡል ማታባብ Ꮊክ ማቻንጎካ ሞላ ጮጫንደትም ሳከንም ጎቸረኮ ሎቀንዘንካ ቃልዝድን ጃልበንካ Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ሎቀንዘንካ ቃልዝድን ጃልበንዘንካ ከት ᎺንቸርሳንደትᎺይካ ሞላ ኮታዘን ዶቅድንዳ ጭልስታ ዎልስምኬ ሶለካ ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","የሱሰረ “ታ የ የጃንደታርንካ ሞለን ተይᎺድከቴ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ኮካንታ ስምኦን ጴጥሮስ ሎቀንዘንካ ቃልዝድን ጃልበናር አርድሶ ዋልቃ ጨተኬ ኦይድ ቦንደኬ ታሜኬ ማከን አንድር ሞለንከስ ጮጫን የድን ሳከን ፍጨዘን ጎቼ፥ ኮ ከከን በድ ሞለን የጅንከረ ሳክና Ꮊአክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ኮታ ቡር የሱስ “ኮረቴ ዳይጨን እችከቴ” ከትም ጋይሴ። ጮይስ የሱስ ማቻንደትም ሙደነረ ኤስሶ Ꮊቃንጎካ ክታ ካርንካ ጎርስምድባብከሳርንካ ዋልቃ ዎራ፥ “የና Ꮊይራ?” ጋይሶ ክትም ኦይስካንታ ካርችስባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ኮታዘንከረ የሱስ Ꮊድሶ፥ ሶለንምኬ ሞለንምካ አምስሶ ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","የሱስ ደእናርንካ አምሳንዘንካ ፈንክ ክታ ካርንካ ጎርስምድባብከስ ክትም ሰድንካ ኮና ማክምስ ዱቴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ዳይጫ ከት እቻንደታ ቡር የሱስ ስምኦን ጴጥሮሰም፥ “ዮነታ ይንች ስምኦኖ! ከናከስ እም ሶልምድንዘንካ ስግ እም ሶልምዳ?” ክትም ጋይሴ። ኖየረ “ይዬ፥ እስታ ጮይስዮ! እ የስም ሶልምድንደትም የና ኤዝደዬ” ጋይንተካ ክትካንታ ማስሴ። የሱሰረ “እስታ ቅንጭንከስም እችስካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ቃስትምስ ዱተረ “ዮነታ ይንች ስምኦንዮ! የና እም ሶልምዳ?” ክደር ጋይሴ። ኖየረ “ይዬ፥ እስታ ጮይስኖ! እ የስም ሶልምድንደትም የና ኤዝደዬ” ክደር ጋይሴ። የሱሰረ “እስታ ቡትልንከስም ካርስካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ማክምስ ዱተረ “ዮነታ ይንች ስምኦንዮ! የና እም ሶልምዳ?” ክትም ጋይሴ። ማክምስ ዱት “የና እም ሶልምዳ?” ክትም ጋይሳንካንታ ጴጥሮስ ሞርእሶ “ጮይስዮ! የና ሙደንም ኤዝደዬ፥ እ የስም ሶልምድንግንደረ ኤዝደዬ” ክደር ጋይሴ። የሱሰረ ኩን ክትም ጋይሴ፥ “እስታ ቆልንከስም ግስካ”፥ ");
INSERT INTO gyl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ዶፈን ዶፈን የስም ጋይድቴ፥ የና ማርምድ ዶቅደዮ የስታ ሳቅን የስታ አን ገተንካ ሶቀርሰዮ የስ ዝግዛንደር አይድ Ꮊቀዬ፥ የስ ጋልተርሳን Ꮊይካ ማቼ የና የስታ አንን አብደዬ አብ ኤድ የስም ቆፍስተረ፥ የስ ዝግዳክንደታር የስም ተይ አይደኬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ኮመረ የሱስ ጋይሳንዳ ጴጥሮስ Ꮊራግንዳ ደእካ ሳብም ቦንቻ ዝግዝድንደትም ሰችካንታ ጋይሴ፥ ኮታ ቡር ጴጥሮስም “እም ጎርስምካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ጴጥሮስ ዋልን ጋይሶ የሱስ ክትም ሶልምድባብ ክታ ካርንካ ጎርስምድንካ ሰዴ፥ ኮና የሱሰታ ካርንካ ጎርስምድባብ ሶይት ጋለን ከት እጅድንካ የሱሰደር እጵን ጋይሶ፥ “ጮይስዮ፥ የስም ስክስት እምድባብና Ꮊይራ?” ጋይሶ ኦይስባብኔ። ");
INSERT INTO gyl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ጴጥሮስ ክትም ሰድሶ፥ “ጮይስዮ! ኮና ኤችና Ꮊርክ ማተራ?” ጋየሮ የሱሰም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","የሱሰረ “እታ Ꮊተርን የለልታ ዶቃባብ እ ጋይሴ የስም Ꮊራ አርችሳሬ? የና እም ጎርስምካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ኮጎካ የሱሰም ጎርስምድባብከስታ ዎክያር፥ “ኮና ክታ ካርንካ ጎርስምድባብ ደእዳክዬ” ጋይድንዳ ኬዛ ኤስምሴ፥ ኬዛር ማቼ የሱስ፥ “እ Ꮊተርን የለልታ ዶቃባብ እ ጋይሴ የስም Ꮊራ አርችሳሬ” ጋይሳ ዳት፥ “ደእዳክዬ” ጋያክዬ። ");
INSERT INTO gyl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ከትኬና ርን ከስጎካ ሙዳ ማርከርስባብከ ከትከነመረ ርንከስም ጻፍስባብ ኮና ክታ ካርንካ ጎርስምድባቤ፥ ክተረ ማርካትቸና ዶፈን ማቻንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","የሱስ ፍክሳንዳ አብ በድ ርንከስ ጉጅሶ ዶቅደኬ። እም ካምድን ግንዳ ማቼ ክት ፍክስባብ ሪንከስ ሙዳ ዋልቃ ዋልቀና ሙዳ ጻፍምሰስ ናና ጻፍምድን ማጻፍንከስም ፍጫ ሙደና ባላካንታ ማታይዶቆ። ");
INSERT INTO gyl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ቶፍሎስዮ! እሪ እ ጻፍሳን ማጻፍናር የሱስ ፍክሳንደትምኬ ክት ኤስሳን ሙዳ ጻፍትቴ። እ ጻፍሳንደረ የሱስ ይንታ ፍክስን ክት የጃንዘንካ የድሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ኮነረ ጭላር አይተርን የለልታ ክት ፍክሳንደትሜ። ጭላር ክት አይሳንደረ ይ እጅባብ ኦይትምስባብከስካንታ ክተንም አያን ጭልንጎካ ከትካንታ ይ እምሳንደታ ቡርዬ። ");
INSERT INTO gyl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","በድ ማጣ ተይሶ ክት ደእሳንደታ ቡር በድ መያ ማቻን ማርካትቼካ ሰንፔካ ማትሶ ከትካንታ Ꮊፈርሴ። ቃስተን ቦንዳ ሰጨንታዋር ከትካንታ መያ ማተሮ ሳብታ ባንችምንጎካ ከትም ኤስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ከትከረ ክክን እችምዘን ዶቅድዮ ኩንጋየሮ ከትም ክትሴ፥ “እ የም ኬዛንደትም እባብዘንካ እምምሳን ጉርምን ካርስከቴ ዳት የሩሳሌም ካተመናርንካ Ꮊይዉተቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ዮሀንሳ ሎቀካ ስእሴ፥ የታ ማቼ ቶክም ሰጨታ ቡር አያን ጭልንካ ስኤርተረቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ከተረ ዋልቃ ካርዘን ሳንሶ ዶቅደኮ፥ “ጮይስዮ! ባንችምን እስራኤልንከስካንታ ማስተዮ የስ ዎይዝድንዳ ሰጨና ታ ዳቶ?” ኩንጋይሰኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","የሱሰረ፥ “እባብ ይንታ ገችንታ ኤረንካ ክት ጋይሳን ሰጨንምከ ስለንም የታ ኤዝዳከቴ ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ኬዛር ማቼ አያን ጭልና የንታዘን ᎺንቸርሳንᎺይካ ዎልቀንም ተይተረቴ፥ ኮታይካ የሩሳሌም ካተመናር፥ ይሁዳ ፍጫ ሙደናር፥ ሳማርያ ካተመናርኬ፥ ፍጨታ ካንታ የለልታ እስታ ማርካ ማተረቴ።” ");
INSERT INTO gyl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ኮመረ ይ ጋይሳንደታ ቡር ከት ሰድንካ ፈስ ጭላር ሳብ ክትም ይንደር ተዬ፥ ኡፈረ ከታ አፍንዘንካ ክትም አቼ። ");
INSERT INTO gyl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ክተረ ጭላር አይድንካ ከተረ ፍስሳ ፈስ ሰድንካ፥ ጫምሳ አፍላ ቆበርስባብከስ ቃስተን ኤድ ከታ ላማር ዎእሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“የታ ገሊላ ፍጫ ኤድንከሶ፥ ፈስ ጭላር ሰደረቶ ኮዘን የ ዎእሳንዳ Ꮊረተረ? ኮና ፈስ ጭላር አይድንካ የ ሰድባብ የሱስ፥ ፈስ ጭላር ክት አይድንካ የ ሰዳንግንዳ ኮትኮግንደካ ማትዮ Ꮊዴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ኮታቡር ደብረዘይት ጋይምሳን ገቼንዘንካ ፈንክ የሩሳሌም ካተመናር ማቼኬ፥ ደብረዘይት ገቼና የሩሳሌም ካተመንዘንካ አይሁድንከስታ Ꮊዉስ ሰጨንካ ጎግ ሙካባብ ጋይምሳንከካ ጎተርዴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ፈንክ የሩሳሌም ካተመናር Ꮊድሰኮ ከታ ይ ዶቅድን ኤሄታዘን ዎደርሳን ኤሄናር አርደደኬ፥ ከተረ “ጴጥሮስ፥ ዮሀንስ፥ ያይቆብ፥ እንደርያስ፥ ፍልጶስ፥ ቶማስ፥ በርተለሞስ፥ ማቶስ እልፍዮሰታ ይንች ያይቆብ፥ ኡርማ ገቅርካ ይንታ ፍጨንካንታ ቀምዝድባብ ስምኦንከ ያይቆብታ ይንች ይሁደካ” Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ከታኬና ሙዳᎺይካ ምክስካንታ ዋልቃትቸካ ሳንምድ Ꮊቀኬ፥ ከትከር ክክን ዋልቃ ዋልቃ ማነንከስከ የሱሰታ እንደን ማራማ፥ ኮትኮግንደረ የሱሰታ እስመንከሰረ ዋር Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ኮታይካ ጴጥሮስ ላ ቦንዳ ማድን አሜንድባብከስታ ዎክያር ዎእሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“እስመንከስከ ምችነንከሶ፥ የሱሰም የጅባብ ኤድንከስታ ጎርስባብ ማችባብ ይሁዳጎካ፥ አያን ጭልና እርምሶ ዳውተታ አፈካ ኬዝምሳንግንዳ ጭል ማጻፍንታ ቃለና ቦድም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ይሁደረ ዎንታ ዋርንካ ዋልቃባብግንዳ ፋይድምሶ ኮትኮ ሳብታ ፍክስን ዎንካ ክክን ፍግዝድባብ ማታዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ኬዛር ማቼ ኮና ኤችና ይንታ ዳቅል ፍክስንታ ብረንካ ፍጫ ሰንሴ፥ ኮታዘንከረ ኖይንታ ባለንካ ዋችንካ፥ ክታ ዎክናርንካ ቃርጭምሶ ኖርትነረ ክታ አፍምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ኮነረ ሪና የሩሳሌም ካተመናር ዶቅድባብከስ ሙደንካንታ ኤስምሴ፥ ኮካንታ ናኮና ፍጨና ከታ አፈንካ ‘አከልዳማ’ ጋይምሶ ኤልምሴ፥ ኮታ ቡልነረ ‘ማቀስታ ፍጬ’ ጋይንትዬ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ኮነረ ኮት ማቻንደታ ጎግና የችይ ማጻፍናር፥ ክታ ዶቅንተና ዉችኩን ኮት ማታ፥ Ꮊየነረ Ꮊይዶቃ፥ ጉጅሰረ ክታ ዶርምን አብ ኤድ ክታዘንካ ተያ ጋይድንዳ ጻፍምሶ Ꮊቃንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ኮካንታ ጮይስ የሱስ ዎንታ ዎክያር ዎንካ የካ ኦንገሮ ክት Ꮊቃናይካ ሙዳ ዎንካ ክክን Ꮊቅባብከሳርንካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ኮትኮግንደረ ዮሀንሰታ ስእስንዘንካ የድሶ ጮይስ ፈስ ጭላር አይሳን ሰጫ የለልታ ዎንካ የካ Ꮊቅባብ ኬና ኤድንከሳርንካ ዋልቀና ዎንካ ክክን ክታ ደእናርንካ አምንተንታ ማርካ ማት ዝግዝዴ”። ");
INSERT INTO gyl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ኮታ ቡር ቃስተን ኤድም ግግሰኬ፥ ከተረ በርሳባስ ናነረ እዮስጦስ ጋይምድባብ ዮሰፍከ፥ ማታስካ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ኩነረ ጋየረኮ ምክሰኬ፥ “ኤድ ሙደንታ ቡደን ኤዝድባብ ጮይስዮ፥ ከትኬና ቃስተንናርንካ Ꮊይም የስ እጃናንከረ ዎም ሰችስካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ይሁዳ ይንታ ገታ ካርንም ዛቅሶ ክት አይሳንካንታ ኮትኮ ሳብታ ዎንንምኬ ኦይትምስባብ ማትሶ ፍግዝድባብም ዎካንታ መያ የስ ማዝድንግንዳ ምግዝዶቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ኮታዘንከረ እጫ ዛቅሰኬ፥ እጨነረ ማታሰታ ዉተዴ፥ ኮካንታ ኖየረ ታመከ ዋልቃ ኦይትምስባብከስካ ክክን ፋይድምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ጴንጣቆስጠ ጋይምድን ባአልንታ ሰጨና የልሳንᎺይካ የሱሰታ ካርንካ ጎርስምድ Ꮊቅባብከስ ሙደና የካ ዋልቃ ካርዘን ሳንምሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ከት ገቅራክናና አንድር ዞጋ ቡርበችታ ኡፍስም ካምድንዳ ጭላርንካ Ꮊድሶ ከት Ꮊቃን ኤሄንም ሙዳ ጮጬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ኖሄታ ሎግንችን ካምድን አድምንከስ ከትካንታ Ꮊፈርሴ፥ ፋስምሰረ ዋልቃ ዋልቃባብዘን ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ሙደነረ አያን ጭልንካ ጮጨኬ፥ አያን ጭልና ከት ኬዝድንግንዳ ከትካንታ እምምሳንከካ አብ አፈንከስካ ኬዛ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ኮ ፍጫሙደንዘን ዶቅድን ፍጫ ሙደናርንካ Ꮊድባብ፥ ምክስካ ዳቅስባብ አይሁድንከስ የሩሳሌም ካተመናር Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ኮትኮም ኡፍስን ከታ ይ ኤሰርሳንደትካ በድ ኤድንከስ ሳንምሰኬ፥ ከታ ከት ሳንምስባብ ዋልቃ ዋልቃ ኤድንከስታ አፈንካ ኬዝድንካ ኤሰረረኮ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ከተረ በድ በርኤረኮ ኩን ጋይሰኬ፥ “ከናከስ ኩን ኬዝድባብከስ ሙደና ገሊላ ኤድ ካየኮ?” ");
INSERT INTO gyl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ይና ዎታ ዎ አጥምሳን ፍጨንታ አፈንካ ከት ኬዝድንደትም ዎ ኤሰርድንዳ Ꮊስግንደረ? ");
INSERT INTO gyl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ዎታ ጳርታ ፍጨናርንክንባብ፥ መድ ፍጨናርንክንባብ፥ ኤላም ፍጨናርንክንባብ፥ መስጰጦምያ ፍጨናርንክንባብ፥ ይሁዳ ፍጨናርንክንባብ፥ ቀጵዶቅያ ፍጨናርንክንባብ፥ ጳንጦስ ፍጨናርንክንባብ፥ እስያ ፍጨናርንክንባብ፥ ");
INSERT INTO gyl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ፍርግያ ፍጨናርንክንባብ፥ ጵንፍልያ ፍጨናርንክንባብ፥ ግብጽ ፍጨናርንክንባብ፥ ቀረና ፍጨንታ ላማር ዶቅድን ልብያ አዉራጀንከሳር ዎታ ዶቅድባቦቴ፥ ሮማርከረ ዎታ Ꮊድባብ አይሁድንኬ አይሁድማታኮት ዶቆ አይሁድ ማትሶ ዎታ አርደድባብከስ ዶቅዶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ኮትኮግንደረ “ቃርጠስ ፍጨናር ኤድንከስኬ አረብ ፍጨናር ኤድንከሰረ ዋር ዶቅደኬ፥ ከተረ ኬና ሙደና ሳብታ አንድር ፍክስን ዎንታ አፈንካ ከት ኬዝድንካ ኤሰርዶቴ!” ");
INSERT INTO gyl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ኮካንታ ሙደነረ በርኤረኮ ከት ጋይድንዳ ከትም ካይድንካ “ኮና ርና Ꮊሮክ ማተራ!” ክክተረ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ዋልቃ ዋልቀንከስ ማቼ “ኡስት ማታክን ዎይን ዎጭምን ዎጭሰኮ ጎዝተኬ!” ጋየረኮ ከታዘን Ꮊልተርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ኮትᎺይካ ጴጥሮስ ታሜከ ዋልቀንከስካ ክክን ዎእሶ፥ ይንታ ኡፍስን ጬክሳ ይይሶ ዎርሰንከስካንታ ኩንጋየሮ ኬዜ። “የታ ይሁዳ ፍጨናር ኤድንከስኬ የሩሳሌም ካተመናር ዶቅድባብ ሙደና፥ ኮ ማቻን ሪን ኤስካንታ እ ኬዝድንደትም ኤሰርከቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ፍጨና አክ ዛማ ማከን ሳዓት ማቻንካንታ የ ገቀርሳንግንዳ ከታኬና ኤድንከስ ጎዛከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ኬዛር ማቼ ኮና ማቻንዳ ኤና ሳብዘንካ ኤስርሶ ኬዝባብ እዮኤለካ ኩን ጋይምሶ ኬዝምሳንዳ ቃለና ቦድምድንግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ሳብ በእንታ ሰጨንካ ኩን ማተረ ጋይዴ፥ እስታ አያንንም ኤድ ሙደንዘን ዉልእድቴ፥ የንታ አⷝና ይንችንከስከ ማና ይንችንከስ ቤርንም ቤርተረኬ የንታ ሰከንንከሰረ ለምለም ጋይድንካ ሰተረኬ፥ የንታ ጋልተንከሰረ Ꮊምይ Ꮊመርተረከ። ");
INSERT INTO gyl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ኮትኮግንደረ ከትኬና ሰጨናር አⷝና ይንችንከዘንኬ ማናይንችን እስታ ፍክስንባብከዘን እስታ አያንን ዉልእትቴ፥ ከተረ ቤርንም ቤርተረኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ፈስ ጭለዘን በርእስዝድን ሪንከስም፥ ፍጨዘነረ አተንም ሰችስትቴ፥ ማቀስ፥ ኖሀ ጩበተረ ቃይቃየና ሰድምተረ። ");
INSERT INTO gyl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","አንድርኬ በርእስዝድንዳ ጮይስታ ሰጨና Ꮊተርንደታ እር፥ Ꮊይና ኡምተሬ፥ አርፈነረ ማቀስም ካምተሬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ጮይስታ ላምንም ኤልድባብ ሙደና አቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","የታ እስራኤል ዎርሰንከሶ! ኮም ቃለንም ኤሰርከቴ፥ የታ የንታ ማታርንካ የ ኤዝድንግንዳ ሳብ የንታ ዎክያር ክት የሱስጎካ ቦጃን አንድርይ ፍክስንከስ፥ አተንከ ቃዉተንከስ ናዝረት ፍጨናርንክንባብ የሱሰታ ኤደትቸና መያ ማስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ሳብ ኤና እር ይ ገቀርሳንደትከ ይ ኤሳን ይንታ ፍክስንግንዳ ክትም የካንታ ስክስት እምምሴ፥ የተረ ክትም ግርድባብከስታ አንናር ሮከርድንግንደከ ደእድንግንዳ ክትም ይሰቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ሳበረ ማቼ ደእታ ማጠንም Ꮊልእስሶ ደእናርንካ ክትም አምሴ፥ Ꮊረታ ጋይሴ ደእ ክትም የድሶ ነግስካንታ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ዳውተረ ክትጎካ ኩን ጋይዴ፥ ጮይስም ሙዳᎺይካ እስታ እር ሰድቴ፥ እ ጳዝዳክንግንደረ ኖ እስታ ምዝዘኔ ");
INSERT INTO gyl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ኮካንታ እስታ ቡደና ጉርምሴ፥ እስታ አድምነረ ጉርምን ኬዜ፥ ኮትኮግንደረ እስታ ዋሄነረ Ꮊድን ጉርምካ ዶቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","እስታ ሰንፔን ደእስባብከስ ዶቅድን ካርናር ዛቅዳካዬ፥ የስታ ጭልምስባብመረ ዱክናር ጫፍሶ ነግድንግንዳ ይዳከዬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ዶቅንት ጎግን እ ኤዝድንግንዳ ይሰዬ፥ እንከረ ክክን የስታ ማትንካ እስታ ጉርምና ቦድማ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","እስታ እስመንከስከ ምችነንከሶ! ኤና እር ባበንከሳርንካ ዋልቀና ዳውት ደእሶ ክት ዱከርሳንግንዳ፥ ክታ ዱክነረ ታካ የለልታ ዎንደር ዶቅድንደትም መያ እ የካንታ ኬዛ። ");
INSERT INTO gyl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ኬዛር ማቼ ዳዊት ኮም ክት ኬዛንዳ ሳብዘንካ ኤስርሶ ኬዝድባብ ይ ማቻንካንተኬ ሳብ የስታ ሱሰናርንካ ዋልቀንም የስታ ባንችም ጎንገንዘን የስካንታ ዶቅስትቴ ክት ጋይሳንዳ ጫቀካ ክትካንታ እምሳን ጉርም ቃለን ይ ኤዝድ Ꮊቃንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ኮጎከረ ዳውት ክርስቶስ ደእስባብከስ ዶቅድን ካርናር ነግዳክንደትምኬ ክታ ዋሄነረ ዱክናር ጫፍሶ ነግዳክንደትም እርምሶ ሰድሶ ክታ ደእናርንካ አምንተንጎካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ክትኮ የሱሰም ሳብ ደእናርንካ አምስሴ፥ ዎተረ ሙደና ኮትኮጎካ ማርኮቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ኮካንታ ሳብታ ምዝንዘን ዶቅንትካንታ ጬክ ጬክ ክት ጋይሳንደትካ አያን ጭልንታ ጉርምን ሳብ ባቤንዘንካ ይ ተያንደትካ ኮም የ ሰድንደትምከ የ ኤሰርድንደትም ዉልእሴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","ይና ፈስ ጭላር ዉተድባብ ዳዊት ይ ማታክንጎካ ዳዊት ይንታ ማታርንካ ኩንጋየሮ ኬዝቴ፥ ጮይስ እስታ ጮይስንካንታ፥ የስታ ይምኤንባብከስም የስታ ዱትንታ ጎያር ሙክንትንዳ እ ማስተርን የለልታ፥ እስታ ምዝንዘን ዶእካ ኖ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ይና ኮም የ ሮክስባብም የሱሰም ሳብ ጮይስከ ክርስቶስ ክትም ማስሳንደትም እስራኤል ዎርሳ ሙደና ዶፈንን ኤሳ!” ");
INSERT INTO gyl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ኤድንከሰረ ኮም ኤሰርሳንደትካ ከታ ቡደና ሞርእስንካ ጴጥሮስምንከ አብንከስ ኦይትምስባብከስም፥ “ዎንታ እስመንከሶ! ይና Ꮊሮንት ይቴ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ጴጥሮሰረ፥ “ጎማ የንታ ፍክስን ዎይስከቴ፥ ጎመና የንታ ነጋ ጋይምተርንግንዳ የታ ዋልቃ ዋልቀና የሱስ ክርስቶስታ ላምንካ ስኤርከቴ፥ ሳብታ እምንታ ማቻን አያን ጭልንም ተይተረቴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ꮊድን ጉርም ቃለና የካንተከ የንታ ይንችካንታ፥ ጮይስ ዎንታ ሳብና ይንደር ይ ኤልድባብከስካንተከ ጎተረ ዶቅድባብከስ ሙደንካንቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","አብ በድ ቃለን ከትካንታ ማርከረሮ፥ “ኮ ዎብ አጥርንዘንካ የንታ ማተን አቅስከቴ!” ጋይንተካ ከትም ዞርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ከታርንካ በድንከስ ሳብታ ቃለንም ኤሰርሰኮ ስኤርሰኬ፥ ኮት ሰጨንካ ማከን ሳአ ማድን ኤድ አሜንሰኮ ጉጅምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ከተረ ኦይትምስባብከስታ ኤስስን ኤስርካ፥ ዋልቃትቸካ፥ እችምንመረ የካ እቸረኮ ምክስካ ዛበሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ኮታይካ ኦይትምስባብከስታ አንካ በድ አተከ በርእስዝድን ሪንከስ ይይምድ Ꮊቃንካንታ ሙዳ ኤድንከሰረ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","አሜንድባብ ሙደና የካ ዋልቃትቸካ Ꮊቀኬ፥ ከታ ዶቅድር ሙደነረ ከታ የካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ከታ ይንታ ዎንንምከ ቆልመንም ሰነረኮ ብረንም ዋልቃ ዋልቃባብከስካንታ ዝግዝድንከካ ፋስሶ እምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ሙዳ ሰጫᎺይካ ሳብታ ጭል ኤሄናር ዋልቃትቼካ ሳንምድዮ Ꮊቀኬ፥ ከታ ዋልቃ ዋልቀንከስታ ኤረረ እችምን ግግሰረኮ ጉርምኬ ኡርማ ቡደካ እቼሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ከተረ ሳብም ጋለተረኮ፥ ኤድ ሙደነረ ከትም ቦንጅድ Ꮊቄ፥ ጮይሰረ አቅድን ኤድንከስም ሰጫ ሙዳᎺይካ ከታዘን ጉጅድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ዋልቃሰጭ ጴጥሮስኬ ዮሀንሰካ ምክስካንታ Ꮊየካ ሳክላ ሳዓታዘን ሳብታ ጭል ኤሄናር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ኮታር “ላቅም” ጋይመሮ ኤልምድንዳ ፍልታ Ꮊቄ፥ አጥምደረ ዎብ ማችባብ ዋልቃ ኤችም ኤድንከስ ሙዳ ሰጫᎺይካ ተይᎺደረኮ ካርንኮትዘን ዎድይ Ꮊቀኬ፥ ኖ ኮታር ዶቅሶ ሳብታ ጭል ኤሄናር አርድን ኤድንከዘንካ ር ተይካንታ ምግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ኮና ኤችና ጴጥሮስኬ ዮሀንሰካ ሳብታ ጭል ኤሄናር ከት አርድንካ ሰድሶ ር ተይካንታ ከደር ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ከተረ ኤችንም ፍስሳ ሰድሰኮ ጴጥሮስ “ፈንክ ዎንደር ሰድካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ኖየረ ር ከት እምድን ካምስንካ ፍስሳ ከትም ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ጴጥሮስ ማቼ “ብረከ ዎርቀካ እስታ ካዬ፥ ኬዛር ማቼ እስታ ዶቅድንደትም የስካንታ እምድቴ፥ ናዝረትንክንባብ የሱስ ክርስቶስታ ላምንካ አምሰዮ ኦንካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ክታ ምዝ አንንመረ የድሶ ክትም አምሴ፥ ሳነካ ክታ ዱትንታ ቅልጨና ዳቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ላእን ጋይሰረ ዎእሴ፥ ሙከረረ ከትካ ክክን ሳብታ ጭል ኤሄናር አርደዴ፥ ሙከርንደትኬ ጎበሮ ሳብም ጋለድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ኤድንከሰረ ሙዳ ክት ሙግድንከ ሳብመረ ክት ጋለድንካ ሰደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","“ላቅም ፍልታ” ጋይመሮ ኤልምድን ሳብታ ጭል ኤሄንታ ባንግር ዶቅሶ ሪይንም ተይካንታ ምግዝድ Ꮊቅባብ ኤችንክት ማትንተን ኤሰኬ፥ ክታዘነረ ይይምሳን ርንካ ኤድንከስ አንድር በርእ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ፋጫን ኤችና ጴጥሮስዘንኬ ዮሀንሳዘንካ ፋስምዳክቴ ጋይንተካ የድሶ ክት ዶቅድንካ ኤድንከስ በርእሰኮ፥ “ሰለሞን ኦንግድን ፍልታ” ጋይምድን ካርንዘን ከደር ዞድሰኮ Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ጴጥሮሰረ ኤድንከስም ይ ሰዳንደትካ፥ “የታ እስራኤል ኤድንከሶ! ኮርንካ Ꮊረተንት በርእዳ? Ꮊረተንት ፍስሳ ዎም ሰዳ? ዎታ ዎንታ ዎልቀካ አነረ ዎንታ ኡርማ ፍክስካ ኮ ኤችና ክት ሙግድንግንዳ ዎ ይሳን የንደር ካምዶ? ");
INSERT INTO gyl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ዎንታ ባቤንከስ፥ አብራሀመታ፥ ይሳቀታ፥ ያይቆበታ ሳብ፥ ይንታ ይንችን የሱሰም ቦንችሴ፥ የታ ማቼ ክትም ጵላጦሳካንታ ስክስት እምሰቴ፥ ጵላጦሰረ ኦይትካንታ ክትም ዝግዝንከረ ‘የታ ግርደቴ’ ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","የታ ሳብካንታ ፋስምስባብምኬ ጭልንም ‘ዝግዳኮቴ’ ጋይሰቶ ኤድም ደይስባብ ዋልቃ ኤድ የካንታ ቡልምድንግንዳ ምክሰቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ሰንፓ እምድባብም ደይሰቴ፥ ሳብ ማቼ ደእያርንካ ክትም አምሴ፥ ኮካንታ ዎተረ ማርኮቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ኮና የ ሰድባብከ የ ኤዝድባብ ኤችና ፋጭሶ ክት ዳቅሳንዳ የሱሰታ ላምንካ Ꮊፈርሳን አሜንኬ። የሱሰታ ላምንካ አሜንካ የ ሙደንታ እር ይንታ ዎብናርንካ ቦድሶ ኡርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ታየረ እስታ እስመንከስኬ ምችነንከሶ! የሱሰዘን የ ይሳን ርን የተረ የንታ ገችንባብከስግንዳ ኤሳክዶቅሰቶ የ ይሳንደትም እታ ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ሳብ ማቼ እርምሶ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስ ሙደንታ አፈካ ‘ክርስቶስ ማጠንም ተይክትም ዝግዝዴ’ ጋይሳን ቃለና ኮግንደካ ቦድምድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ይና የንታ ጎመና ነገድንግንዳ የንታ ጎማ ፍክስን ዎይስሰቶ ፈንክ ሳብደር ማትከቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ꮊረታ ጋይሴ ሳብደርንካ ክላ የ ማድንደታ ስለንከስ የካንታ Ꮊተሬ፥ ሳብ እርምሶ የካንታ ይ እጅባብ ክርስቶስ የሱሰም ኦይተሬ። ");
INSERT INTO gyl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ኖየረ ጭላር ክት ጋምእድንዳ ሳብ እርምሶ ጭል ሳብካንታ ፋስምሶ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ አፈንካ ኬዛንደትግንዳ ፍጫ ሙደና ክላ ማተርን የለልቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ኤና ሙሴረ፥ ‘ጮይስ የስታ ሳብና እም አምሳንደትግንዳ ኮትኮግንዳ የንታ እስመንንከስታ ዎክያርንካ ሳብዘንካ ኤሰርሶ ኬዝድባብም አምስተሬ፥ ክት የካንታ ኬዝድንደትም ሙዳ ኤሰርከቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ክትኮ ሳብዘንካ ኤሰርሶ ኬዝድባብም ኤሰርዳክባብ ሙደና ዎርሰናርንካ ፋስምሶ ካይዴ’ ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ኮታዘንከረ ሳመልዘንካ የድሶ Ꮊቅባብ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስ ሙደና ኮ ስለንጎካ ኮግንዳ ከዝተኬ። ");
INSERT INTO gyl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","የተረ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ካርንም የድባበቴ፥ ኮትኮግንደረ ሳብ አብረሀማካንታ፥ ‘ፍጨዘን ዶቅድባብ ዎርሳ ሙደና የስታ ሱሰንካ አንጅምደኬ’ ጋይሶ ዎንታ ባቤንከስካ ክክን ክት አርደዳን ጫቃ ቃለን ተይድባብከሰቴ። ");
INSERT INTO gyl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ኮካንታ ሳብ ይንታ ይንችን ክት ኦይቻንዳ እርምሶ የካንታ Ꮊቄ፥ ኮመረ ክት ይሳንዳ የ ዋልቃ ዋልቀን የንታ ዳቅል ጎግንዘንካ ማስካ የም አንጃካንቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ጴጥሮስኬ ዮሀንሰካ ዎርሰንካንታ ኬዘሮ ከትዶቅድንካ ቄሰንከሳርንኬ ሳብታ ጭል ኤሄንታ ካርስንባብከስታ ክተንባብ ኮትኮግንደረ ሰዱቃውያን ኤድንከስ ከደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ቃስተና ኦይትምስባብከስ የሱሰታ ደእያርንካ ክታ አምንተን ዎርሰንካንታ ከታ ኤስስንኬ ደእናርንካ አምንታ ዶቅድንደትም ከት ኬዛንካንታ አንድር ዋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ኮካንታ ከትም የድሰኮ ፍጨና ሶይቻንካንታ ሰጭተርን የለልታ ዞክና ኤሀር ከት ዶቅድንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ኬዛር ማቼ ሳብታ ቃለንም ኤሰርስባብከሳርንካ በድንከስ አመንሰኬ፥ አሜንስባብ አⷝነንከስታ ፋይደና ዶንቅ ሳአ ማታባብ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ዛማክንከረ አይሁድንከስታ ገችንባብከስኬ ጋልተንከስካ፥ ሙሴታ ህግን ኤስዝድባብከሰረ የሩሳሌም ካተመናር ሳንምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ሳንምስባብ ኤድንከስታ ዎክያርንካ ቀሰንከስታ ገችንባብ ሀናና፥ ቃያፋ፥ ዮሀንሰኬ እስክንድሮስኬ፥ ቀሰንከስታ ገችንባብታ ኤሀ ኤድንከስ ሙደና ኮታር ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ከተረ ጴጥሮሰምኬ ዮሀንሰም ይንታ ዎክያር ዎይስሰኮ፥ “ኮም የ ይሳንዳ Ꮊራ ዎልቀካ አነረ Ꮊይታ ላምከረ?” ኩንጋይሰኮ ከትም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ኮታይካ ጴጥሮስ አያን ጭልንካ ጮጭሶ፥ “የታ ዎርሰን ገችዝድባብከስኬ ጋልተንከሶ! ");
INSERT INTO gyl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ዎታ ታካ ዋልቃ ዎብ ኤችንጎካ ይይምሳን ኡርማ ፍክስንኬ Ꮊስግንዳ ጎግካ ክት ፋጫናንከረ ዎ ኦይዝድንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ኮና ኤችና ፋጭሶ የንታ እሪ ክት ዎእሳንዳ የ ሮክስባብከ ሳብ ማቼ ደእያርንካ አምስባብ ናዝረትንክንባብ የሱስ ክርስቶስታ ላምንካ ማቻንደትም የ ሙደንካንተኬ እስራኤል ዎርሰንካንታ ሙዳ ኤስምሳንዳ ማታ። ");
INSERT INTO gyl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","የታ ሰይን ኤሄንም ዎድባብከስ የ ቶችሶ ዛቅሳን ሰይንና ኖዬ፥ ኬዛርንካ ማቼ ኖ ኤሄንታ ዱራ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ኮካንታ አቅንተና ክታዘንካ አብ Ꮊይከነረ ካዬ፥ ዎ ክትካ አቅድን ግንዳ ሳብ ኤድንከስካንታ እምሳንዳ ፍጫሙደንዘን ላም ክተንዘንካ አብ ላም ካዬ” ኩንጋየሮ ከትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ጴጥሮስከ ዮሀንሰካ ጳስካይሳ ከታ ኬዘን ቡጫ ጋልተንከስ ሰድሰኮ ኤስ ኤሄናር አርድሰኮ ኤሳክባብኬ ኤጫ ከታ ካየንባብ ማትንተን ከታ ይ ኤዝድንጎካ በርእሰኬ፥ የሱሰካ ክክን ከት Ꮊቃንደትመረ ኤሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ፋጫን ኤችነረ ከትካ ክክን ዎእስንካ ከታ ይ ሰዳንካንታ ከታዘን ኬዛካንታ ማታከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ኮካንታ ቡጫ ጋልተንዘንኬ ፍርደን እምድን ካርንዘንካ ኦስ Ꮊርሳ ከትም ይይሶ መራ ዶቅሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“ይና ከት ኬና ኤድንከዘን Ꮊሮንት ይቴ? ኮና አንድር አተና ከታ አንናር ፍክስምና የሩሳሌም ካተመናር ዶቅድባብ ሙደንካንታ ኤስምቴ፥ ኮካንታ ካድካንታ ማታዮቴ። ");
INSERT INTO gyl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ኬዛር ማቼ ዎርሰንከዝደር ዳልገሮ አይዳክንግንዳ ይና ኮዘንካ የሱሰታ ላምን ኤለረኮ Ꮊየንካንተረ ከት ኬዝዳክንግንዳ፥ ከትም ኤግዝምስተሮቴ” ኩንጋየሮ ዞርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ኮታ ቡር ከትም ኤልሰኮ የሱሰታ ላምንካ ቦድሶ ከት ኬዝዳክንግንዳ አነረ ከት ኤስዝዳክንግንዳ ዳቅስሶ ከትም ክትሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ጴጥሮስኬ ዮሀንሰካ ማቼ ማስሰኮ “ሳብካንታ ክትምዘንካ ስግስሶ የካንታ ክትም ሳብታ እር ዝግዝድንዶ? ይና የታ የንታ ማታርንካ ኬዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ዎታ ማቼ ዎ ሰዳንደትምኬ ዎ ኤሰርሳንደትም ከዘዘንካ ቡር ማታዮቴ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ዎርሰንታ ገችንባብከስኬ ቡጫ ጋልተንከሳርንክንባብከስ ጴጥሮስምንኬ ዮሀንሰም ዋጨረባብ Ꮊረነረ ጎግ ከታ Ꮊፋክንጎካ ዎርሰንመረ ጳስሰኮ አናካርንካ ኤግዝምስሶ ከትም ኦይቸኬ፥ ኮመረ ከትይሳንዳ ዎርሰና ይይምሳን ርንካ ሳብም ጋለድዮ ከት Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ኮ አተንካ ፋጭባብ ኤችንክታ ስለና ቃስተን ቦንደዘንካ ስግᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ጴጥሮስኬ ዮሀንሰካ ብልምሰኮ ከታ ይንታ አሜንድባብ ኮችንከዝደር ማቻንደትካ ቀሰንከስታ ገችንባብከስኬ አይሁድንታ ጋልተንከስ ከት ጋይሳንደትም ሙዳ ከትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ከተረ ኮትኮም ይ ኤሰርሳንደትካ ከታ ይንታ ኡፍስን ዋልቃትካ ጬክሳ ይይሰኮ ሳብደር፥ “ጭለንም፥ ፍጨንም፥ ባሀርንም፥ ከታ ዋር ዶቅድንደትም ሙደንም የና ፍዝባብ ሙደንዘንካ ስግ ሳብኖ! ");
INSERT INTO gyl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","አያን ጭልንጎካ የስታ ፊክስንባብ ዎንታ ባቤን ዳዊትታ አፈካ ኩን ጋይሰዮ ኬዝባብ የነዬ። “አይሁድ ማታክባብከስ Ꮊረተክ ዋጫረ? ዎርሰንከስ ዉችኩን Ꮊረተክ ዳቅልንም ገቀርሳሬ? ");
INSERT INTO gyl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ፍጨንታ ባንችንከስ ዙገርሰኮ፥ ገችዝድባብከሰሬ የካ ሳንምሰኮ፥ ጮይስዘንከ ሳይምስባብዘን አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“ገተረ ሄሮድስከ ጰንጥዮስ ፍጨናርንባብ ጵላጦስ አይሁድ ማታክባብከስኬ እስራኤል ዎርሰንካ ክክን ኮትኮ ካተመናር ሳንምሰኮ ሳይምስባብ የስ ማስስባብ የስካንታ ፋስምስን ፍክስንባብ የሱስዘን አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ኩነረ ማቻንዳ የና እርምሶ የስታ ገታ ዎልቀንከ የስታ ገታ ጋይተንካ ኤና እር የስ ገቀርሳንደትም ቦድካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ታ ማቼረ ጮይስዮ ከታ ኬዝካ ዝግመትን ሰድካ፥ የስታ ፍክስንባብከስ የስታ ቃለንም ጳስካይሳ ሙቅምካ ከት ኬዝድንግንዳ ማስስካ። ");
INSERT INTO gyl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","የስካንታ ፋስምስባብ የስታ ፍክስንባብ የሱሰታ ላምንካ Ꮊዘርስባብከስ ከት አቅድንግንደኬ አተንመረ፥ በርእስዝድን ሪንከሰረ ይምድንግንዳ የስታ አንን አምስካ”። ");
INSERT INTO gyl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ምክስንም ከታ በይሳንደታ ቡር ሳንምሶ ከት Ꮊቃን ካርና ሶይሴ፥ ከታ ሙደነረ አያን ጭልንካ ጮጨኬ፥ ሳብታ ቃለንመረ ጳስካይሳ ሙቅምካ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","አሜንድባብከስ ሙደና ዋልቃ ቡደኬ ዋልቃ ገቅር ከታ Ꮊቄ፥ ከታርንካ Ꮊየነረ ኤድ “ኮና እስቴ” ክት ጋይድንዳ ር ካዬ፥ ከታ ዎክያረረ ሙዳ ርና ከታ የካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ኦይትምስባብከሰረ ጮይስ የሱሰታ ደእናርንካ አምንተን አንድር ዎልቀካ ከታ ማርከርድ Ꮊቀኬ፥ ከት ሙደንዘነረ አንድር ሳብታ ዉች እምንተና ከታዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ፍጫ ናንከረ አነረ ይንታ ኤሄንከስም ሙዳ ኦስ ሰነረኮ ብረንም ተይᎺድዮ ከትᎺቃንካንታ ከታ ዎክያርንካ ዋልቃባበረ ማጠርድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ብረንመረ ተይᎺድሰኮ ኦይትምስባብከስካንታ እምድ Ꮊቀኬ። ዋልቃ ዋልቃባብካንተረ ዝግዝድን ከካ ፋስትዮ እማᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ቆጵሮስ ፍጫር አጠርምስባብ፥ ዮሴፍ ጋይምድባብ ዋልቃ ለዊ Ꮊቄ፥ ኦይትምስባብከስ ክትም “ባርናባስ” ጋየረኮ ኤልድ Ꮊቀኬ፥ ክታ ልምንታ ቡልነረ “ዳቅዝድን ይንች” ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ኖየረ ይንታ ፍጨን ሰንሶ ብረንም ተይᎺድሶ ኦይትምስባብከስካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ሀነና ጋይምድባብ ዋልቃ ኤች ሳጰራ ጋይምድን ኬነንካ ክክን ማትሰኮ ከታ ይንታ ፍጨንም ሰንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ክታ ኬነነረ ኤዝድዮ ፍጨን ሰነርሳን ብረናርንካ ፋስምን ነግስስንደትከ ፋስምን ተይᎺድሶ ኦይትምስባብከስካንታ እምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ጴጥሮስ ማቼ “ሀነኖ! አያን ጭልንዘን የስ ማልተርንግንደኬ ፍጨን ሰንምሳንደታርንከረ ፋስምን የስ ነግስተርንግንዳ ይስስባብ ሰጣን Ꮊረተክ የስታ ቡዳር አርደዳሬ? ");
INSERT INTO gyl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","የስ ሰንተርንደታ እሪ ፍጨና የስታ ካዮ? የስ ሰንሳንደታ ቡር ብረና የስታ ካዮ? ይና፥ ኮግንዳ ርን Ꮊራካንተስ የስታ ቡዳር ገቀርሳሬ? የስ ማልትሳንዳ ሳብዘን ዳት ኤታዘን ካዬ ኩን ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ሀናነረ ኮም ኬዘን ይ ኤሰርሳንግንዳ ዋችሶ ደእሴ፥ ኮም ርን ኤሰርስባብ ኤድንከስ ሙደና አንድር ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ሰከንንከስ አምሰኮ ለይስንም አክስሰኮ ተይ አይሰኮ ዱክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ማከን ሳዓት ማታባብንታ ቡር ሀነነታ ኬነና ይንታ ክእስንዘን ማቻን ርን ኤሳክዶቆ ና Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ጴጥሮሰረ “ይና እካንታ የስ ኬዝኔ የንታ ፍጨን የ ሰንሳንደና ኮካ ማድን ብረቶ?” ኮደር ጋይሴ። ናየረ “ይዬ! ኮካ ማድን ብረቴ” ና ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ጴጥሮሰረ “ሳብታ አያንን ጰጫካንታ Ꮊስግንደንት ኤእሳሬ? ይና! የስታ ክእስን ዱክሰኮ ማድባብ ኤድንከስ ፍልታዘነኬ፥ የስመረ ተይ አይሰኮ ዱግደኬ” ኮደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ናየረ ካርንኮታዘን ክታ ዱትንዘን ዋችሶ ደእሴ፥ ሰከንንከሰረ ከት አርድንካ ኮት ደእሳንደትም ሰድሰኮ ተይ አይሶኮ ክእስታ ባንግር ኮትም ዱክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ምክስ ኤሄናር ኤድንከስ ሙደንከ ኮትኮርን ኤሰርስባብ ኤድ ሙደንዘን አንድር ጳስዝድንዳ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","በድ አተንኬ በርእዝድን ርንከስ ዎርሰንታ ዎክያር ኦይትምስባብከስታ አንያር ፍክስምድ Ꮊቄ፥ ሙደነረ ዋልቃ ቡዳ ማትሰኮ ሶሎሞንታ ማልካ አይድን ጎግንዘን ሳንምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ከታዘንካ አብ ኤድንከሳርንካ ዋልቃ ዎራ ከትካ ክክን ማትካንታ ካርችስባብ ካዬ፥ ማታጋካ ዳት ዎርሰና ከትም ቦንጅድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ጮይስካ አሜንድባብ አⷝነንከስኬ ማነንከስታ ፋይደና አንድር በደሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ኤድንከስ በድ Ꮊዘርስባብከስም ጎግዘን ዉቸሮ ሰለዘንከ Ꮊቸዘን ራችሰሮ Ꮊቀኬ፥ ኩነረ ከትይሳንዳ ጴጥሮስ ጎግንኮትካ ስገድንካ ክታ ስፍና ዎራ ዋልቃ ዋልቀንከዘን ማድንግንዳ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","በድ ኤድንከስ የሩሳሌም ካተመንታ ካንተካ ዶቅድባብ ካተመንከሳርንካ Ꮊዘርስባብከስምኬ ቱና አያንካ ማጠርድባብከስ በድንም ትይᎺድዮ Ꮊቀኬ፥ ሙደነረ ፋጭድዮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ቀሰንከስም ገችዝድባብኬ ክትካ ክክን Ꮊቅባብ ሰዱቃውያን ኤድንከስታ ኮችንከስ ሙደና ቀምስካ ጮጭሰኮ ከታዘን አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ኦይትምስባብከስም የድሰኮ ዎርሰንታ ዞክና ኤሄናር ከትም አርችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ሳብታ ክታይንችና ማቼ ሶይት ዞክና ኤሄንታ ፍልተንከስም ፎችሶ ከትም ዉችስንደትኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“አይከቴ! ሳብታ ጭል ኤሄናር ዎእሰቶ ኮትኮ ዶቅንት ቃለን ሙዳ ዎርሰንካንታ ከስከቴ!” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ኦይትምስባብከሰረ ክተንም ተይሰኮ ሰጭመናር ሳብታ ጭል ኤሄናር አርድሰኮ ዎርሰን ኤስስ የጀኬ። ኮታይካ ቄሰንከስም ገችዝድባብኬ ክትካ ክክን Ꮊቅባብከስ Ꮊድሰኮ ቡጫጋልተንከሳር ዶቅድባብከስምኬ አይሁድንታ ጋልተንከስም ሙዳ ዋልቃትቼካ ከትም ሳንሰኬ፥ ኦይትምስባብከስመረ ተይᎺድንግንዳ ኤድንከስም ዞክና ኤሄናር ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ካርሰንባብከስም ክድባብከስ ማቼ ዞክና ኤሄናር አይሰኮ ኦይትምስባብከስም ኮታር Ꮊፋከኬ፥ ማተረ Ꮊድሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ዞክና ኤሄንታ ፍልተና ማለካ ዝጭምሶ ካርሰንባብከሰረ ፉልተንዘን ዎእሰኮ ከትዶቅድንካ Ꮊፍሶቴ፥ ዞክና ኤሄንታ ፍልተን ዎ ፎጅድንካ ማቼ ኤሄንታ ዋር Ꮊይመነረ Ꮊፋኮቴ” ጋይሰኮ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ሳብታ ጭል ኤሄን ካርዝድባብከስም ክድባብኬ ቄሰንከስም ገችዝድባብከስ ኮም ኤሰርሳንደትካ “ኮና ርና Ꮊሮክ ማተራ?” ጋይሰኮ ታንትምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ኮትᎺይካ ዋልቃ ኤድ Ꮊድሶ “ኮሰቸቴ፥ ዞክና ኤሄናር የ ኦይቻን ኤድንከስ፥ ሳብታ ጭል ኤሄናር ዎእሰኮ ዎርሰንም ኤስዝደኬ” ጋይሶ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ሳነካ ሳብታ ጭል ኤሄንታ ካርሰንባብከስም ክድባብኬ ክትካንታ ክትምድባብከስ አይሰኮ ከትም ተይ Ꮊደኬ፥ ተይᎺድባብከሰረ ዎልቀካ ማታክናና ከትም ኤእስሴ፥ ኮመረ ከትይሳንዳ ዎርሰና ሰይንካ ከትም አቅዳክንግንዳ ጳስኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ከትም ተይᎺድሰረ ቡጫጋልተንከስታ እር ዎይስሰኬ፥ ቀሰንከስታ ገችንባበረ ኩንጋየሮ ከትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“የሱሰታ ላምንካ የ ኤስዝዳክንግንዳ ዳቅስሶ የም ክቶትዶቆ፥ ኬዛርንካ ማቼ ይና የታ የሩሳሌማር የንታ ኤስስንካ ጮጨቴ፥ የታ ኤችንክታ ደእንጎካ ዎም ኦይስምምድባብከስ ማስካንታ ዝግደቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ጴጥሮስከ አብንከስ ኦይትምስባብከስካ ማቼ፥ “ኤድ ካንታ ክትምዘንካ ሳብካንታ ክትም ዎም ዝግዝዴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ዎንታ ባቤንከስታ ጮይስን የታ Ꮊቀዘን ሮክሰቶ የ ደይስባብ የሱሰም ደእናርንካ አምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ሳብ እስራኤል ዎርሰንካንታ ጎማ ፍክስ ዎይስንምኬ ጎመንካንታ ነገትቸን እምድንግንዳ የሱሰም ጎርስባብከ አቅስባብ ማስሶ ይንታ ምዝዘን ቦንቼካ ክት ዶቅድንግንዳ ይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ኮርንካንታ ዎታ ማርኮቴ፥ ሳብ ይካንታ ክትምድባብ ሙደንካንታ ክት እምሳን አያን ጭልነረ ማርኬ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ቡጫ ጋልተንከሳርንክንባብከስ ኮም ኤሰርሳንደትካ አንድርይ ዋጭሰኮ ኦይትምስባብከስም ደይሳካንተረ ዝግዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ኬዛር ማቼ ዎርሰንደር ቦንችምስባብከ ሙሴታ ህግንም ኤስዝድባብ፥ ገማልያል ጋይምስባብ ዋልቃ ፈረሳው ፍጨንታ ቡጫ ጋልታ ማችባብከሳርንካ ዋልቃባብ አምሶ መራካንታ ኦይትምስባብከስም Ꮊርሳ ከታዘንካ ይድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ኮታ ቡር ቡጫ ጋልተንከሳርንክንባብከስም፥ “የታ እስራኤል ኤድንከሶ! ከትኬና ኤድንከዘን የ ይድን ርንካ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ኤና ኮታ እሪ ተዎዳስ ጋይምድባብ ኤች እታ አንድር ኤችቴ ጋይሶ አምታ Ꮊቄ፥ ኦይድ ጨታ ማድባብ ኤድንከሰረ ክትካ ክክን ዋልቃ ማቸኬ። ኬዛርንካ ማቼ ኖ ደይስምሴ፥ ክታ ካርንካ ጎርስምድባብከሰረ ሙደና ይጭምሰኬ፥ ክታ ገቅርነረ ቦድምክሳ ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ኮተረ ቡር፥ ዎርሰና ፋይድምሳን ስለናር ገሊላ ፍጨናርንክንባብ ይሁዳ አምሶ በድ ኤድንከስ ክትም ጎርስምድንግንዳ ይታ Ꮊቄ፥ ኖየረ ደይስምሴ፥ ክትም ጎርስምስባብከሰረ ሙደና ይጭምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ኮካንታ ታየረ የም እ ጋይድንዳ ከት ኬና ኤድንከዘንካ የ ጎተርተርንግንደኬ ከትም የ ዛቅድንግንዴ፥ ኮና ገቅርንከ ፍክስንካ ኤድዘንካ Ꮊዳንዳ ማቼ ና ካየዴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ሳብዘንካ Ꮊዳንዳ ማቼ ከትም ካይስካንታ ማዳከቴ፥ Ꮊረንግርካ ኮም የ ይዴ ሳብካ ክክን የም ዋእዝድንዳ ማተረ” ኩን ከትም ጋይሴ። ከተረ ጋማልያልታ ዞረንም ኤሰርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ኮታ ቡር ኦይትምስባብከስም ከታ ይንደር ኤልስሶ Ꮊርችስሴ፥ የሱሰተረ ላምንካ ከት ኬዝዳክንግንዳ ክትሰኮ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ኦይትምስባብከስ ማቼ የሱሰታ ላምንካንታ ቶችርን ተይካንታ ግግምስባብ ከታ ይንታ ማትንተንካ ጉርምካ ቡጫጋልተንከስታ እርንካ ዉትሰኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ሰጫ ሙዳᎺይካ ሳብታ ጭል ኤሄናርኬ ከታ ይንታ ኤረረ ክላ ኬዘንታ ኬዘና ክት ሳይምስባብ የሱስጎካ ኤስስንም ዛቃከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ኮታይካ አሜንድባብከስታ ፋይደና በደሮ አይድንካ ግርክታ አፈን ኬዝድባብከስ አይሁድና ይሁዳ ፍጨናር አጥምስባብ አይሁድን ኬዘን ጉንድም የጀኬ፥ ከት ጉንድምሳንደረ ሙዳ ሰጫᎺይካ ከትካንታ እምምድ Ꮊቃን አለንካ ክእስና ከታ ደእስባብ ማነንከስም ከት ባቀርሳን ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ኮካንታ ታመኬ ቃስተን ኦይትምስባብከስ አሜንድባብከስ ሙደን ሳንስሰኮ፥ “ዎታ እችምን የልስካንታ ጋይሶቶ ሳብታ ቃለን ኤስስን ዛቅ ዎም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ይና እስታ እስመንከስኬ ምችነንከሶ፥ ኡርማ ይንታ እዘንካ ጎፍስምስባብከስ፥ አያንይ ጭልንከ ኤጨካ ጮጭባብከስ ታብዛ ኤድንከስም የንታ ዎክያርንካ እድከቴ፥ ከትም ኮርንጎካ ዶርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ዎታ ማቼ ምክስካንተከ ቃለንም ኤስስካንታ ጉርተሮቴ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ኮና ጋይንትና ሙደንመረ ጉርምሴ፥ ኮታዘንከረ ዶቅድን ኤድንከስ እድምሰኬ፥ ከተረ አሜንከ አያንይ ጭልንካ ጮጭባብ እስጥፋኖስ፥ ፍልጶስ፥ ጵሮኮሮስ፥ ንቃሮን፥ ጢሞና፥ ጰርመና አይሁድንታ አሜንን አሜንሶ Ꮊቅባብ አንጾክያ ፍጫርንክንባብ ንቆሎስመረ እጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ከትከናከስም ኦይትምስባብከስታ እር ዎይስሰኬ፥ ኦይትምስባብከሰረ ምክስሰኮ አን ከታዘን ዎጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ኮግንደካ ሳብታ ቃለና ዳልገሮ አይሴ፥ የሩሳሌም ካተመናር አሜንድባብከስታ ፋይደና አንድርይ በደሮ አይሴ፥ ቀሰንከሳርንከረ በድንከስ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","እስጥፋኖስ ሳብታ ዉች እምንተንኬ ዎልቀንካ ጮጭሶ በርእስዝድን ሪንከስምኬ አንድር አተን ዎርሰንታ ዎክያር ይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ኮታይካ “ባዛካይሳ ዉድባብከስታ ምክስ ኤህ” ጋይምሶ ኤልምድን አይሁድንከስታ ምክስ ኤሄናር ኤድንከስ፥ ቃረና ፍጨናርንከ እስክንድርያ ፍጨናርንካ ኤድንከስ፥ ኪልቅያ ፍጨናርንከ እስያ ፍጨናርንካ ዋልቃ ዋልቃ ኤድንከስ አምሰኮ እስጥፋኖሰም ግርንተካ ክትካ በርምድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ኬዛርንካ ማቼ እስጥፋኖስ ኬዝድ Ꮊቃን ኤጨንምከ አያንን ጋምካንታ ማታከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ኮታይካ “ኮና ኤችና እስጥፋኖስ ሙሴምከ ሳብም የግድንካ ኤሰርቶቴ” ጋይድን ኤድንከስም አቸካ ክታዘን አምስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ኮግንደካ ዎርሰንምኬ ጋልተንከስመረ ሙሴታ ህግንም ኤስዝድባብከስም ክታዘን አምስሰኬ፥ እስጥፋኖስደር አይሰኮ ክትም የተኮ ቡጫጋልተንከስታ እሪ ተይᎺደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ክታዘን ካርከካ ማርከርድባብ ዋልቃ ዋልቃ ኤድንከስመረ ተይᎺደኬ፥ ካርካ ማርከንከሰረ፥ “ኮና ኤችና ኮ ሳብታ ጭል ኤሄንዘንከ ሙሴታ ህግንዘን የክ ኬዘን ዛቃክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ጉጅሰረ ‘ኮና ናዝረት ፍጨናርንክንባብ የሱስ ኮም ሳብታ ጭል ኤሄን ዉልእዴ፥ ሙሴረ ዎካንታ ክት ስክሳን ዎገን ኖ ኦግዴ’ ጋይሶ ክት ኬዝድንካ ኤሰርቶቴ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ኮታይካ Ꮊፈርስባብ ቡጫ ጋልተንከስ ሙደና እስጥፋኖሰም ፍስሳ ክትም ከት ሰድንካ ባለና ክታ ክታይንችታ ባለም ካምሶ ከትካንታ ሰድምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ቀሰንከስታ ገችንባብ እስጥፋኖሰም “ኮና ጋይምሳን ርና ዶፈኖ?” ጋየሮ ክትም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","እስጥፋኖሰረ፥ “እስመንከስኬ ባቤንከሶ! እዝደር ኤሰርከቴ! ዎንታ ባቤን አብራሀም ካራን ፍጨናር ዶቅካንታ ይ አይተርንደታ እሪ መስጰጦምያ ፍጨናር ዶቅድንካ ቦንቻ ጮይስና መያ ክትካንታ ማትሶ”፥ ");
INSERT INTO gyl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","የስታ ፍጨናርንካ ዉትሰዮ፥ የስታ ሱሰንዘንካ ፋስምሰዮ፥ እ የስም ሰጅድን ፍጨናር አይካ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ኮታይካ ካለዳውያን ፍጨናርንካ ዉትሶ ካራን ፍጨናር ዶቅሴ። ክታ ባቤና ደእሳንደታ ቡረረ ሳብ ካራን ፍጨናርንካ ዉችሶ ታካ የ ዶቅድን ፍጨናር ክትም ተይᎺዴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ማታጋካ ዳት ዱት ሙክሳን ካርከካ ዎራ ባእ ክትካንታ እማክዬ፥ ኬዛር ማቼ ኮትኮ ፍጨን ክትካንተከ ክተረ ቡርጎካ ክታ ሱሰንካንታ ባእ ማስሶ ይ እምድንደትም ጉርም ኬዜ፥ ኮም ጉርምንም ክት ከዛንደረ አብራሀመታ ይንች አክ ካያ ናኔ። ");
INSERT INTO gyl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ክታ ሱሰነረ ኤድ ፍጫር ዳይርባብ ማትሶ ዶቅድንግንደኬ ኮት ፍጨናረረ ኦይድ ጸታ ስላ አይላ ማስሶ ቃምእስካ ከትም ቆልድንደትም ክትካንታ ከዝታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ኮታዘንከረ አይላ ከትም ማስሶ ቆልድን ዎርሰንዘን እታ ፋረድቴ፥ ኮተረ ቡር ዉችኩን ዉትሰኮ ኮካርንዘን እካንታ ጎይንተረኬ ጋይሶ ሳብ ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ሶላ ተችርንተረ ጫቃ ቃለን ክትካንታ እምሴ፥ ኮካንታ አብራሀመረ ይሳቀም ይ አጫንደትካ ላማካይስ ሰጨንካ ሶለንም ክታ ተቼ፥ ኮትኮግንደረ ይሳቀረ ይንታ ይንችን ያይቆበም አጥሶ ሶለን ክታ ተቼ። ያይቆበረ አጥርንከስታ ባበንንከስ ማችባብ ታመኬ ቃስተን ይንችንከስም አጥሶ ኬታ ሶለን ተቼ። ");
INSERT INTO gyl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","ያይቆብታ ይንችንከስ ከታ ይንታ ካንስ ዮሴፈዘን ቀምስሰኮ ግብጽ ፍጨናር አይላ ማድንግንዳ ሰንሰኬ፥ ሳብ ማቼ ክትካ ክክን Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ማጣ ሙደናርንካ ክትም ዉችሴ፥ ግብጽ ፍጨናር ባንችን ፋሮንታ እረረ ጎፍስምንከ ኤጨንም ክትካንታ እምሴ። ባንችነረ ግብጽ ፍጨንዘንከ ይንታ ኤሀ ሙደንዘን ክድባብ ክትም ማስሶ ዶርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ኮታይካ ግብጽ ፍጨናርከ ከነአን ፍጫሙደንዘን አንድርይ ማእዝድንዳ ዳቅ ማቼ፥ ዎንታ ባቤንከሰረ እጅድንደትም Ꮊፋከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ያይቆበረ ግብጽ ፍጨናር እስን ዶቅድንደትም ይ ኤሰርሳንደትካ እርንደትም ዎንታ ባቤንከስም ግብጽ ፍጨናር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ቃስትምስ ዱት ግብጽ ፍጨናር ማት ከት አይሳንደትካ ዮሰፍ ይንታ እስመንከስካንታ ይንታ ማተን መያ ማስሴ፥ ዮሴፈታ ሱሰንከሰረ ፋሮነደር ኤስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ኮታ ቡር ዮሴፍ ይንታ ባቤን ያይቆብምኬ ይንታ ሱሰንከስም ሙዳ ይንደር ተይᎺችሴ፥ ከተረ Ꮊድባብ ኤድንከስ ማከን ቦንደኬ ታሜኬ ዶንቅ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ኮካንታ ያይቆብ ግብጽ ፍጨናር አይሴ፥ ክትኬ ዎንታ ባቤንከሰረ ፍጨንኮታር ደእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ኬታ ለፍነረ ሰከም ፍጨናር ተይ አይምሶ አብራሀም ሰከም ፍጨናር ኤሞርታ ይንችንዘንካ ይንታ ብረካ ሰንሳን ዱክ ካርናር ዱክምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","ሳብ አብራሀም ካንታ ጫቀካ እምሳን ጉርምና ቦድምድን ሰጨና የልድንካ ግብጽ ፍጨናር Ꮊቅባብ ዎንታ ዎርሰንታ ፋይደና በደሮ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ኮታ ቡር ዮሴፈም ኤዝዳክባብ አብ ባንችን ግብጽ ፍጨናር ባንችምሳን ሰጨና የልሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ኖኮና ባንችና ዎንታ ዎርሰንዘን ጩበካ አምሶ ዎንታ ባቤንከስም ቃምእስ የጄ፥ ከታ ይንችን ከሰረ ደእድንግንደኬ ኦስ ማል ዉችሶ ኬት ዛቅድንግንዳ ዎንታ ባቤንከስም ማእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ኮታይካ ሙሴ አጥምሴ፥ ኖየረ ሳብታ እሪ ላቅምድን ይንች Ꮊቄ፥ ማከን አርፍ ባቤንታ ኤር በድ ካርስምካ ጋጵሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ኦስ ማል ክትም ዛቅምሳንደትᎺይካ ፋሮንታ ይንቼን ክትም Ꮊፍትዮ ይንታ ይንችግንዳ ማስሶ ጋጵሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ሙሴረ ግብጽ ፍጫ ኤድንከስታ ኤጨንም ሙዳ ኤሴ፥ ኖይንታ ኬዘንኬ ይንታ ፍክስንካ ዳቅማ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","ሙሴታ ቃስተን ቦንዳ ስላ ማቻንደትካ ይንታ እስመንከስ እስራኤል ይንችን ሰድንካንታ ይንታ ቡዳር ገቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ክታ እስመንከሳርንከረ ዋልቀን ዋልቃ ግብጽ ፍጫ ኤችና ማእሰሮ ክትም ኡፈልዝድንካ ሰድሶ አለንም አልሴ፥ ኡፈልሶ Ꮊቃን እስመንጎካ ይምኤርሶ ግብጽ ኤችን ጉጵት ደይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ሳብ ክትጎካ ዉችኩን ከትም ዉጅድንደትም ክታ ኮችንከስ ገቀርት ተይድን ክደር ካምሶ Ꮊቄ፥ ከታ ማቼ ኮም ገቀርት ተያከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ዛማክንከረ አና ቃስተን እስራኤልንከስ ከታ ክክ ክክ ኬት ዋጭምድንካ ሰድሶ ከትም ቃይሳካንታ ዝግሶ የታ ኤድንከሶ፥ የታ ማቼ እስመንኬ ካንስከቴ፥ Ꮊረተንት ዋጭምዳ? ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ኖኮና ይንታ ላኮይትን ጉጳዶቅድባብ ኤችና ሙሴም ኦስ Ꮊንቅሶ የስም ዎንታዘን ዎም የስ ቆላባብኬ ዎንዘን የስ ፋረዳባብ Ꮊይ ይሳራ? ");
INSERT INTO gyl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ናካ ግብጽ ፍጫ ኤችንም የስ ደይሳንግንዳ እመረ ደይሳካንታ ዝግዳ? ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ሙሴረ ኮም ይ ኤሰርሳንግንዳ ግብጽ ፍጨናርንካ Ꮊዝሶ ምድያም ፍጨናር አይሶ ኮታር ባርቅባብ ማትሶ ዶቅሴ፥ ኮታረረ ቃስተን አⷝና ይንችንከስም አጬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ሙሴረ ኮት ፍጨናር ቃስተን ቦንዳ ስላ ይ ዶቅሳን ቡር ሲና ገቼንታ ዴል ቆቸናር Ꮊቀንከስታ እክመና የድንደታር ዋልቃ ክታይንች ኖ ሰጄ። ");
INSERT INTO gyl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ሙሴረ ኮም ይ ሰዳንደትካ በርእሴ፥ ቅንችምሰረ ክት ሰድንካ ኩን ጋይድንደትም ጮይስታ ኡፍስይ ኤሰርሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","እታ የስታ ባቤንከስታ ሳብቴ፥ አብራሀመታ ሳብ፥ ይሳቀታ ሳብ፥ ያይቆበተረ ሳብቴ፥ ሙሴረ ጳስካ ጭጬ፥ ሰድንካንተረ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ጮይሰረ፥ የስ ዎእሳን ካርና ጭልምሳን ፍጫ ማቻንካንታ የስታ ጫመን ዉችካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ግብጽ ፍጨናር ዶቅድን እስታ ዎርሰንታ አንድር ማጠንም ገታ ሰትቴ፥ ማጥርካ ከት ፍብድን ኤሰርትቴ፥ ኮካንታ ከትም አቅስካንታ እታ Ꮊንቸርትቴ፥ ታማቸረ የና ኮሬ! እታ የስም ግብጽ ፍጨናር ኦይትቴ። ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","እስራኤል ዎርሰንከስ ሙሴም ዎንዘን የስ ዎም ቆላባብከ ዎንዘን የስ ፋረዳባብ ይስባብ Ꮊይራ? ጋይሰኮ ክትም ግርድባብከሰኬ፥ ማታጋካ ዳት ሳብ ክትኮ ሙሴም Ꮊቀንከስታ እክመናር ክትካንታ Ꮊፈርሳን ክታይንችንጎካ ቆልድባብከ ዉች ዉችዝድባብ ማስሶ ከደር ክትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ግብጽ ፍጨናር፥ ዘይም ባሀርንዘንኬ ኤድ ካየን ካርናር በርእስዝድን ሪንከስምኬ አተንም ይይንተካ ዎርሰንም ዉችሶ ቃስተን ቦንዳ ስላ ከትም ጎርስባብ ኖኮና ሙሴ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","የንታ ጮይስ ሳብና እም አምሳንግንዳ ኮትኮግንዳ የንታ እስመንከስታ ዎክያርንካ ሳብዘንካ ኤሰርሶ ኬዝድባብም የካንታ አምስተሬ ጋይሶ እስራኤልንከስካንታ ኬዝባብ ኖኮና ሙሳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ዴል ቆቸናር ሳንምሶ Ꮊቅባብ ዎርሰንካ ክክን ሲና ገቼንዘን ኬዛን ክታይንችንካ ክክን ኮትኮግንደረ ዎንታ ባቤንከስካ ክክን Ꮊቅባብ ኖዬ። ሳብዘንካ ክተንከስም ዎካንታ ስክስት እምስባብ ኖኮና ሙሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","ዎንታ ባቤንከስ ማቼ ክትም ግርደክ ዳት ክትካንታ ክትማከኬ፥ ከታ ይንታ ቡዳረረ ግብጽ ፍጨናር ማትካንታ ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","አሮንመረ ኮና ግብጽ ፍጨናርንካ ዎም ዉችስባብ ሙሴ Ꮊራ ክታዘን የልሳናነረ ዎ ኤዝዳክንካንታ ዎንታ እሪ አየረኮ ዎም ጎርዝድን ጮይስንከስም ዎካንታ ኡርስካ ክትም ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ኮታይካ ዋከን ቅንጭታ ካምስካ ጮይስ ማታክንደትም ኡርስትዮ ኮትካንታ ካስ እምሰኬ፥ ከታ ይ ኡርስሳን ይንታ አን ፍክስንከረ ጉርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ሳብ ማቸ ከታዘንካ ፋስምሴ። ጭለተረ ቤዝንም ከት ጎይንድንግንዳ ስክስት ከትም እምሴ፥ ኮነረ ሳብዘንካ ኤስርሶ ኬዛቅባብከስካ ኩን ጋይምሶ ጻፍምሳንግንዴ፤ “የታ እስራኤል ኤድንከሶ! ማችምሳን መሄንምኬ ካሲንም ቃስተን ቦንዳ ስላ ሙዳ ዴል ቆቼናር የ እምሳንዳ እ ካንቶ? ");
INSERT INTO gyl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","የድሰቶ የ አይሳን ሞሎክታ ዱንካንከ ረፋን ጋይምድን የንታ ጮይስ ማታክን ቤዝንታ ካምስንከስ Ꮊቄ፥ ከተረ የንታ አንካ ኡርስሰቶ የ ጎይንድ Ꮊቃን ጮይስ ማታክባብከሰኬ። እተረ ባብሎን ፍጨናርንካ ኦስ የ ዳይምድንግንዳ ይትቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","ዎንታ ባቤንከስታ ዴል ቆቼናር ማርካትቻ ዱንካንና ከታ Ꮊቄ፥ ኮትኮ ዱንካንንመረ ሳብ ክትም ኬዛንግንደኬ ክትም ሰችሳን ግንዳ ኮትም ኡርስባብ ሙሳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ሳብ ከታ እሪንካ ከትካንታ ዳይስባብ አይሁድ ማታክባብከስታ ፍጨን ከታ ይ ተያንደትካ ዎንታ ባቤንንከስ ኮትኮም ይ ተያን ዱንካንን ኢያስካ ክክን ኦኮታር አርችሰኬ፥ ዳውትታ ስለን የለልታ ኦኮታር ዱንካንና ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ዳውተረ ሳብታ እሪ ጎፍስ Ꮊፍሶ ያይቆብታ ጮይስን ሳብንካንታ ገችንተታ ካሪ ማድንደትም ኤሀ ዎድካንታ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ኬዛርካ ማቼ ሳብካንታ ኤሄን ዎጅባብ ሶሎሞንዬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","ማችንከረ ሙደንዘንካ ስግ ሳብና ኤታ አንካ ዎድምሳን ኤሄታዋር ኖ ዶቃዬ፥ ኮነረ ሳብዘንካ ኤስርሶ ኬዝባብ ኩንጋየሮ ጻፍሳንደትግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ጭለና እ ባንችምሶ ዶቅድን ጎንጌ፥ ፍጨነረ እስታ ዱትንታ ሙክንትንዴ ይና እካንታ Ꮊስግንዳ ኤሄንት ዎተራ? እ ኡክንድን ካርና Ꮊስግንደረ? ጋይዴ ጮይስ። ");
INSERT INTO gyl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ኮም ሙዳ እታ እስታ አንካ እ ፍክሳንዳ ካዮ? ጋይዴ ሳብ። ");
INSERT INTO gyl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“የታ ጉልመንባብከስ የንታ ቡደና ቱንስባብከስ! የንታ ቃምነረ ኤሰርዳክባብ! የተረ ገታ የንታ ባቤንከስግንዳ ሙዳᎺይካ አያን ጭልን ግርደቴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ዎክያርንካ የንታ ባቤንከስ ዳያክባብ Ꮊይ ዶቅዳ? ከተረ ጭልንባብታ Ꮊድንተን እርምሶ ከዝባብከስም ደይሰኬ፥ የተረ ታ ኮም ጭልን ስክስት እምንተካ ክትም ደይሰቴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","የታ ክታይንችጎካ ሳብንታ ህግንም ተይተትዶቆ፥ ኬዛር ማቼ የታ ኮትም ካርሳከቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ቡጫ ጋልተንከስ ኮም ኤሰርሰኮ ሰነርሰኬ፥ እስጥፋኖሰታ ዘነረ ዋጭካ አፋ ጋእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ኖ ማቼ አያን ጭልንካ ጮጭሶ ፈስ ጭላር ፍስሳ ክት ሰድንካ ሳብታ ቦንቼንም ሰጄ፥ የሱሰመረ ሳብታ ምዝንዘን ዎእሶ ክት ዶቅድንካ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ኮካንታ “ይና፥ ጭላ ፎችምሶ ኤድይንች ሳብታ ምዝዘን ዎእስንካ ሰዳዶቅድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ኮታይካ ከታ አንድር ኡፍስካ ፍፍሰኬ፥ ከታ ይንታ ቃምን ይንታ አንካ የድሰኮ የካ ክደር ዞጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ካተመናርከረ ክትም ዉችሰኮ ሰይንካ አቅሰኬ፥ ማርከንከሰረ ከታ ይንታ አፍለን ተይሶ ሳዉል ጋይምድባብ ዋልቃ ሰከን ከትካንታ ካርዝድንግንዳ ክታ ዱትንታ ላማር ዎጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ሰይንካ ከት አቃዶቅድንካ እስጥፋኖስ፥ “ጮይስ የሱስዮ! እስታ ሰንፔን ተይካ!” ጋይሶ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ጉምፈርሰረ “ጮይስዮ! ኮም ከታ ባችን ከታዘን Ꮊይ ፋይደ!” ጋይሶ አንድር ኡፍስካ ፍፍሴ፥ ኮመረ ጋይሶ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ሳዉለረ እስጥፋኖሰም ደይሰርድንደትካ ኤእታ Ꮊቄ፥ እስጥፋኖስ ደእሳን ሰጨንካ የሩሳሌም ካተመናር Ꮊፈርድን አመንድባብከስታዘን አንድር ዳይር አምሴ፥ ኦይትምስባብከስ Ꮊክ ነገድንካ አሜንድባብ አብንከስ ሙደና ይሁዳርከ ሳማርያ ፍጨናር ይጭምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ምክስካ ዳቅስባብ ኤድንከስ እስጥፋኖሰም ዱክሰኬ፥ አንድር ኡፍስካ ፍፈረኮ ክትካንታ ኤፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ሳዉል ማቼ አሜንድባብከስም ካይስካንታ ዝግድ Ꮊቄ፥ ኤሀርንከረ ኦስ አብ ኤሀር አርደሮ አሜንድባብከስ አⷝነንምከ ማነንከስም ጎችትዮ ዉጅድ Ꮊቄ፥ ዞክና ኤሀረረ ከትም አርጅድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ይጭምስባብከሰረ አመንድባብ ይ አይሳን ካሪ ሙደናር ሳብታ ቃለንም ሳባግድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ፍልጶሰረ ሳማርያ ካተማር አይሶ ኤድንከስም ሳይምስባብጎካ ከትም ሳባክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ኤድንከሰረ ፍልጶሰታ ቃለን ኤሰርሳንግንደኬ ክት ይድን አተንከስም ሰድሰኮ ዋልቃ ገቅርካ ኡርስት ክትም ኤሰርድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ቱና አያንንከሰረ አንድርይ ኡፍስካ ፍፈረኮ በድ ኤድን ኬዘንካ ዉድዮ Ꮊቀኬ፥ በድ ዎብዝባከስኬ ዎከልዎከል ጋይድባብከስ ፋጭድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ኮካንታ ኮትኮ ካተመናር አንድርይ ጉርም ማቼ። ");
INSERT INTO gyl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ኮትኮ ካተመናር ስምኦን ጋይምድባብ ዋልቃ ኤች Ꮊቄ፥ ኖኮና ኤችና ኤና ኮታ እር ካተመናር ሳጋ ፍክሰሮ ሳማርያ ካተመንታ ዎርሰን በርእሰሮ Ꮊቄ፥ “እታ አንድር ኤድቴ!” ጋየሮ ኬዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ኤድንከስ ሙዳ መረነረ ባከነረ “ኮና ኤችና አንድር ጋይምሶ ክት ኤልምድንዳ ሳብታ ዎልቄ!” ጋየረኮ ኡርስትዮ ክትም ኤሰርደኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ኡርስተሬ ክትም ከት ኤሰርድ Ꮊቃንደረ በድ ሰጨዘንካ የችሶ ይንታ ሳጋ ፍክስንካ ከትም በርእስዝድ Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ኬዛር ማቼ ፍልጶስ ሳብታ ባንችምንጎከ የሱስ ክርስቶስታ ላምንጎካ ክት ኬዛን ክላ ኬዘን ከታ ይ ኤሰርሳንደትካ አⷝነንከስከ ማነንከሰረ አሜንሰኮ ስኤርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ስምኦን ዎራ ነጋክ ዶቆ አሜንሶ ስርስንደትከ ፍልጶሰካ ክክን ማቼ፥ ከት ይድንደትመረ በርእስዝድን ሪንከስምከ አንድር አተንከስም ይንታ ሰድንካ በርእድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","የሩሳሌም ካተመናር Ꮊቅባብ ኦይትምስባብከስ ሰማርያ ካተማ ኤድንከስ ሳብታ ቃለን ከት ተያንደትም ከታ ይ ኤሰርሳንደትካ ጴጥሮስምንኬ ዮሀንሰም ሳማርያ ካተመናር ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ኮካንታ ሳማርያ ካተማ ኤድንከስ አያን ጭልን ከት ተይድንግንዳ ጴጥሮስኬ ዮሀንሰካ አይሰኮ ከትካንታ ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ሳማርያ ካተማ ኤድንከስ ጮይስ የሱሰታ ላምካ ስኤርሶ Ꮊቀክ ዳት አያን ጭልና ዋልቃባብዘነረ ዎራ Ꮊንቸራክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ኮካንታ ጴጥሮስኬ ዮሀንሰካ፥ ከታ ይንታ አንንከስም ከታዘን ዎጃንደትᎺይካ ኤድንከስ አያን ጭልን ተየኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ኦይትምስባብከስ ከታ ይንታ አንንከስም ከታዘን ዎድንካ አያን ጭልና አሜንድባብ ኤድንከስካንታ እምምሳን ስምኦን ይ ሰዳንደትᎺይካ ብራ ከትካንታ ተይᎺድሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“እተረ እስታ አንን እ ዎድን ኤድ አያን ጭልንም ክት ተይድን ግንዳ ኮም ገችታ ኤረን እካንታ እምከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ጴጥሮስ ማቼ፥ “ሳብታ እምንተን ብረካ Ꮊፍካንታ የስታ ገቅርንካ የስታ ብረና የስካ ክክን ካያ! ");
INSERT INTO gyl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","የስታ ቡደና ሳብታ እሪ ሉላ ማታክንካንታ ኮ ሪይናርንካ የስም የልድንዳ አነረ እጫ የስታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ይና ኮ የስታ ዳቅል ገቅርንዘንካ አተርሰዮ ጎማ ፍክስን የስታ ዎይስካ፥ Ꮊረንግርካ የስታ ቡደንታ ዳቅል ገቀርን ነጋ የስም ጋይዳ ናንከረ ሳብም ምክስካ። ");
INSERT INTO gyl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","የና ዳቅል ቀምስካ የስ ጮጫንግንደኬ ጎመካ ዞከርስባብ የስ ማቻንደትም ሰድቴ” ኩን ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ስምዖነረ “ታ የ ከዛንደታርንካ ዋልቃ ዎራ እዘን የልዳክንግንዳ የታ የንታ ማታርንካ ጮይስደር እካንታ ምክስከቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ጴጥሮስኬ ዮሀንሰካ ኬታ ይ ማርከርሳንደትኬ ጮይስተረ ቃለን ኬታ ይ ኬዛንደታ ቡር በድ ሳማርያ ካተመንታ ሞረንከሳር ክላ ኬዘንም ኤስምሰረኮ የሩሳሌም ካተመናር ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ጮይስታ ክታይንችና ፍልጶሰም፥ “አምሰዮ የሩሳሌም ካተመናርንካ ኦስ ጋዛ ካተመናር ተይ አይድን ጎግንካ ሶስ ጎካ አይካ” ክትም ጋይሴ፥ ናኮና ጎግና ዴል ቆቼናር አይድን ጎግ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ኖየረ አምሶ አይሴ፥ ይና፥ ዋልቃ ስላ ማችባብ ኢትዮጳርንክንባብ ኤች ሳብካንታ ጎይንደረ ኦስ የሩሳሌም ካተመናር አይሴ፥ ኮና ኤችና ህንደኬ ጋይምሳን ኢትዮጰታ ባንችን Ꮊቃንደታ አብን ክድባብኬ ብረንም ኮታ ገችዝድባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ኖይንታ ፍጨናር ማድዮ ፋራ ጎጅድን ሰረገላ ጋየርድንደትዘን ዶቅሶ ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኢስያሰታ ማጻፍን ናበብድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ኮትኮᎺይካ አያን ጭልና ፍልጶሰም “አይካ ኦ ፋረን ጎጅድን ሰረገለንደር የልሰዮ ክትካ Ꮊፈርካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ኮካንታ ፍልጶስ ኦስ ዞደሮ አይሶ ኢትዮጳ ኤችና ሳብዘንካ ኤሰርሶ ኬዛቅባብ ኢሳሰታ ማጻፍን ናበብድንካ ኤሰርሶ “የስ ናበብድንደታ ቡልና የስም አርዶ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ኢትዮጵያ ኤችነረ “ቡዳር እስታ አርድንግንዳ ይድባብ ኤድ ካያ ማቼ Ꮊስግንዶክ እም አርድካንታ ማዳ?” ጋይሶ ፍልጶሰም “ፋረን ጎጅድን ሰረገለንዘን ዉትሰዮ እንካ ክክን ዶእካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ኖየረ ናበብድ ክት Ꮊቃንዳ ጭል ማጻፍንታ ካርና ኩን ጋይድንዳ Ꮊቄ፥ ኖ ማችርካንታ በይምድን ቆለንግንዳ Ꮊቄ፥ ስጭንም ተጅድንካ ጫምን ጋይድን ቡትልንግንዳ፥ ኖየረ ኬዛካንታ አፋ ቡላክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ኖየረ ቶችምሴ፥ ሉላ ፍርደረ ክትካንታ እምማክዬ፥ “ሰንፔነረ ክታ ፍጨዘንካ ተይምቴ አጥርንከስም Ꮊይ ኬዝተራ?” ");
INSERT INTO gyl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ስላ ማችባብ ኢትዮጵያ ኤችነረ ፍልጶሰም፥ “ሳብዘንካ ኤሰርሶ ኬዝባብ ኮም ኬዛንደና Ꮊይካንተረ? ይንታ ማታካንቶ አነረ አብንካንቶ? ዋደ እካንታ ኬዝካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ፍልጶሰረ ኮ ጭል ማጻፍንታ ካርንዘንካ የድሶ የሱስጎካ ክላ ኬዘንም ክትካንታ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ከታ አይድዮ ሎቃ ዶቅድን ካርያር የልሰኬ፥ ስላ ማችባብ ኢትዮጵያ ኤችነረ “ይና ኮታር ሎቃ ዶቅዴ፥ እ ስኤርዳክንግንዳ ማርድንዳ ርና Ꮊራ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(ፍልጶሰረ “ቦድማ ቡዳርንካ የስ አሜንሴ ስእርካንታ ማደዬ” ክትም ጋይሴ። ስላ ማችባብ ኢትዮጵያ ኤችነረ “የሱስ ክርስቶስ ሳብታ ይንች ክት ማትንተን አመንድቴ” ጋይሴ።) ");
INSERT INTO gyl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ስላ ማችባብ ኢትዮጵያ ኤችና ፋረና ጎጅድን ሰረገለና ዎእድንግንዳ ጋይሴ፥ ቃስተና ከተረ ሎቀናር Ꮊንቸርሰኮ ፍልጶስ ስላ ማችባብ ኢትዮጵያ ኤችንም ስእሴ። ");
INSERT INTO gyl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ሎቀናርንካ ከት ዉተዳን ቡር ጮይስታ አያንና ፍልጶሰም ተይ አይሴ፥ ስላ ማችባብ ኢትዮጳያ ኤችነረ ቃስትምስ ክትም ሰዳክዬ፥ ማታጋካ ዳት ኖ ጉርመሮ ይንታ ሙክንትን የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ፍልጶስ ማቼ አዛጦስ ፍጫር Ꮊፈርሴ፥ ቅሳራ ፍጫረረ ይ Ꮊተርን የለልታ ካተመንከስ ሙደናር አየሮ ክላ ኬዘንም ሳባግድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ኮታᎺይካ ሳዉል ጮይስታ ካርንካ ጎርስምድባብከስም ደይሳካንታ ጳስሰሮ ቀሰንከስም ገችንባብደር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ጮይስታ ጎግንካ ጎርስምድባብ ኤድንከስም አⷝነንከስምከ ማነንከስም ይ Ꮊፍሴ ዞከሮ ፈንክ የሩሳሌም ካተመናር ተይᎺድካንታ ክትም ማስዝድን ጻፈርሳንደትም ደማስቆ ካተመናር አይሁድንታ ምክስ ኤሄንከስካንታ እምምድንግንዳ ቄሰንከስም ገችዝድባብም ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","አይድዮ ደማስቆ ካተመናር የልሳንደትካ ክታ ካንተካ ክት ገቀራክናና ጭላርንካ ሳክመና ክትካንታ ሮጵሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ኮትᎺይካ ፍጨዘን ኖ ዋቼ፥ “ሳዉሎ፥ ሳዉሎ፥ Ꮊረተስ እም ዳይዳ?” ጋይድን ኡፍስ ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ሳዉለረ “ጮይስዮ! የና Ꮊይራ?” ጋይሴ፥ ኖየረ “እታ የስ እም ዳይድባብ የሱስቴ”፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ታ ማቼ “አምሰዮ ካተመናር አርድካ፥ የስም ይይ ዝግዝድንደትም ኦኮታር ኬዝተሬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ሳዉልካ ክክን አይድ Ꮊቅባብ ኤድንከስ ኡፍስ ኤሰረረኮ Ꮊይመንመሬ ሰዳክንካንታ ከታ ይ ከዝተርንደት ካይድንካ፥ ጫምን ጋይሰኮ ዎእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ሳዉለረ ይ ዋቻን ፍጨንዘንካ አምሴ፥ ክታ አፍነረ ማቼ Ꮊረነረ ሰድካንታ ማታክዬ፥ ኮካንታ ኤድንከስ ክታ አንን የድሶ ጎርሰረኮ ኦስ ደማስቆ ካተመናር ክትም ተይ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ማከን ሰጫ ሙዳ Ꮊረነረ ሰዳክዶቆ አነረ እችክሳ ዎጭክሳ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ኮትᎺይካ ደማስቃ ካተመናር ሀነና ጋይምድባብ ዋልቃ ከታ ካርንካ ጎርስምድባብ Ꮊቄ፥ ጮይስ ለምለም ጋይድንካ ሰድምሶ “ሀናኖ!” ጋይሶ ክትም ኤልሴ፥ ኖየረ “ዮ የ ጮይስዮ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ጮይሰረ ክትም፥ “የረየር ጋይምድን ጎግንደር አይካ፥ ኮታር ይሁደታ ኤር ሳዉል ጋይምድባብ ጠርሰስ ፍጫ ኤችንም ዝካ፥ ኖ ታ ምክስታ ዘኔ፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ሳዉለረ ክታ አፍንከስ አናካርንካ ሰተርንግንዳ ሀናና ጋይምድን ኤች ክደር አርድሶ ይንታ አንን ክታዘን ዎድንካ ለምለም ጋይድንካ ሰዴ” ኩን ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ሀናና ማቼ፥ “ጮይስዮ! ኮና ኤችና የሩሳሌም ካተመናር ዶቅድባብ አመንድባብዘን በድ ዳቅልር ክት ይ Ꮊቃን በድንከዘንካ ኤሰርትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ካረረ የስታ ላምን ኤልድባብከስም ሙዳ ዞክና ካንታ ቄሰንከስም ገችንባብከዘንካ ገችታ ኤረን ተይቴ” ኩንጋየሮ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ጮይስረ ሀናንየም፥ “ኖ አይሁድ ማታክባብከስካንታ፥ ባንችምንከስካንተኬ እስራኤል ኤድንከስካንታ እስታ ላምን ኤስምዝድባብ፥ እስታ እድምስባብ እ ክትካ ፍግዝድባብ ማቻንካንታ ኦስ ክደር አይካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","እጎካ Ꮊስከካ በድ ማጠም ክት ተይዳናነረ እታ ክትካንታ መያ ማዝድቴ” ኩን ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ኮካንታ ሀነና ኦኮታር አይሶ ክት Ꮊቃንደታረረ ኤሄናር አርደዴ፥ ይንታ አንንከስመረ ሳዉልዘን ዎድሶ፥ “እስታ እስመን ሳዉሎ! ኮር የስ Ꮊዳ ዶቅድንካ ጎግዘን የስካንታ Ꮊፈርስባብ ጮይስ የሱስ አናካርንካ የስ ሰድንካንታ ማድንግንዳ አያን ጭልነረ የሳር ጮጭድንግንዳ የዝደር እም ኦይቼ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ሳነከረ ኦፍርም ካምድንዳ ር ክታ አፍንዘንካ ዋችንካ ኖ ሰጄ፥ አምሰረ አሜንድባብከስታ ስእርን ስኤርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","እችምነረ እችሶ ዳቅሴ፥ ደማስቆ ካተመናር ዶቅድባብ አሜንድባብከስካ ክክን ቶክም ሰጫካንታ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ሳነከረ ሳዉል ደማስቆ ካተመናር “የሱስ ሳብታ ይንቼ” ጋየሮ አይሁድንታ ምክስ ኤሄናር ሳባክ የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ኤሰርስባብከስ ሙደነረ፥ “ኮና ኤችና የሩሳሌም ካተመናር ኮ ላምን ኤልድባብከስም ሙዳ ካይሰሮ Ꮊቅባብ ካዮ? ካረረ ክት Ꮊዳንዳ ከትም ዞከሮ ቀሰንከስም ገችዝድባብከዝደር ተይ አይካንታ ካዮ?” ኩን ጋይንተካ በርእድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ሳዉል ማቼ እሪንደትዘንካ ስግስሶ ዳቅሴ፥ የሱስ ሳይምስባብ ማትንተን ቡዳር ከታ አርድንግንዳ ይየሮ ደማስቆ ካተመናር ዶቅድባብ አይሁድንከስም ኬዘታ ማስና ከታዘንካ ካይድንግንዳ ይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","በድ ሰጨታ ቡር አይሁድና ሳዉልም ደይሳካንታ ዞርምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ኖ ማቼ ከታ ጩባ ገቀርን ኤሴ፥ ከተረ ክትም ደይሳካንታ ሙዳ ሰጫᎺይካ ክት ዉድን ካተመንታ ፉልተንከስም ካርሰሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ኬዛር ማቼ ሶይት ክታ ካርንካ ጎርስምድባብከስ ሳዉልም ኩርኩራር ዶቅስሶ ሰይን ጋስንታ ዉልፈካ ሶስ ጩላ ክትም Ꮊንችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ሳዉል የሩሳሌም ካተመናር አይሳንᎺይካ ኮታር ዶቅድባብ ከታካርንካ ጎርስምድባብከስካ ክክን ቡቅም ካንታ ዝግዜ፥ ከታ ማቼ ክታ ክርስቶስካ አሜንና ዶፈን ከትም ካማክንካንታ ሙደነረ ክትም ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ባርናባስ ማቼ ሳዉልም ኦይትምስባብከዝደር ተይᎺድንካ ጎግዘን ክት ዶቅድንካ ጮይስ Ꮊስግንዳ ክትካንታ መያ ማቻናከረ Ꮊስግንዳ ክትም ከስሳናንካ ደማስቆ ካተመናር የሱሰታ ላምንካ Ꮊስግንዳ ሙቅምካ ኤስሳናንከረ ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ኮካንታ ሳዉል ከትካ ክክን ማትሶ የሩሳሌም ካተመናር ኦንግድ Ꮊቄ። ጮይስተረ ላምንካ ሙቅምካ ሳባግድ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ግርክ ፍጨንታ አፈን ኬዝድባብ አይሁድንካ ክክን ኬዘሮ ቤርምድ Ꮊቄ፥ ከታ ማቼ ክትም ደይሳካንታ ገቀርሶ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","አሜንድባብከስ ኮም ኤሳንደትካ ኦስ ቀሳርያ ፍጨናር ተይክትም አይሰኬ፥ ኮታዘንከረ ጠርሰስ ፍጨናር ክት አይድንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ይሁዳ ፍጨናር፥ ገሊላርኬ ሳማርያ ካተማ ሙደናር ዶቅድን አሜንድባብከስ ሳራትቸን Ꮊፍሴ፥ ዛብዜ፥ ጮይስም ቦንቸሮ አያን ጭልንካ ዳቀሮ ፋይደነረ ከታ ጉጅምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ጴጥሮስ ፍጫ ሙደናር ኦንገሮ ክት ዶቅድንካ ልዳ ካተመናር ዶቅድን አሜንድባብከስም ሰድንካንታ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ኮታረረ ላማካይ ስላ ሙዳ ሰለዘን ራችባብ ኤንያ ጋይምድባብ ዎብም Ꮊፍሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ጴጥሮሰረ “ኤንዮ! የሱስ ክርስቶስ የስም ፋጅዴ፥ አምሰዮ የስ ራታᎺቃን ካርን ቁርካ!” ክትም ጋይሴ፥ ኖየረ ሳነካ አምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ልዳ ካተመናርኬ ሳሮን ፍጨናር ዶቅድባብከስ ሙደናክትም ሰድሰኮ ጮይስንም አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ኢዮጴ ካተመናረረ ጣብታ ጋይምደንዳ ዋልቃ አመንድንዳ Ꮊቄ፥ አብ ኮታ ላምነረ ዶርቄ፥ ና ኡርማ ርም ይይንተኬ ሪካየንባብከስካንታ ቡዳርንካ እምድን ኤተን Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ኮታይካ ና ሰቀርሶ ደእሴ፥ ኮታ ዘነን ስእተኮ ኤሄታዘን ዎደርሳን ኤሀር ዎጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ልዳ ካተመና እዮጰ ካተመንካንታ ቅንች ማቻንኦል እዮጳር ዶቅድባብ አሜንድባብከስ ጴጥሮስ ልዳር ክታ ዶቅንትን ኤሰርሰኮ “ዋደ ጋምአከይዶቆ ሳነካ ዎንደር የልካ” ጋይሰኮ ቃስተን ኤድም ክደር ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ኮካንታ ጴጥሮስ አምሶ ክተን ተይᎺድባብከስካ ክክን Ꮊዴ፥ ክት የልሳንደትካ ኤሄንታዘን ዎደርሳን ኤሄናር ክትም ተይ አይሰኬ፥ ከታ ክእስንከስ ደእስባብ ማነንከስ ሙዳ ካንተንካ ዎእሰኮ ኤፈረኮ ዶርቃ ሰንፔካ ዶቅድዮ ከትካ ክክን ኮት ፍክሳᎺቃን ስንስንከስምከ አፍለንከስም ሰቸረኮ ክታ እር ዎእሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ጴጥሮስ ማቼ ሙደንም ማል ዉችሶ ጉምፈርሶ ምክሴ፥ ለይስንደር ማትሶ “ጣቢቶ! አምካ!” ጋይሴ፥ ናየረ ይንታ አፍንከስካ ሰድን የጄ፥ ጴጥሮስመረ ሰጄ፥ ና አምተሬ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ኖየረ ይንታ አንንም ኦይትሶ ኮትም የትዮ አምሴ፥ ከታ ክእስንከስ ደእስባብ ማነንከስኬ አበረ አሜንድባብከስም ኤልሶ ኮትመረ ሰንፔካ ከታ እሪ ዎይስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ኮነረ ሪና ኢዮጴ ፍጫ ሙደናር ኤስምሴ፥ በድ ኤድንከሰረ ጮይስካ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ጴጥሮሰረ ስምኦን ጋይምድባብ ዋልቃ ጋማ ጭርድባብካ ክክን በድ ሰጫካንታ እዮጳር ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ቅሳርያ ካተመናር ዶቅድባብ ቆረነሎስ ጋይምድባብ ዋልቃ ኤች Ꮊቄ፥ ኖየረ ሮማ ፍጨናር ዳምንባብከስታ ጎያር “ጣላንታ ዳምንባብከሰኬ” ጋይምድንደታር ዳምንባብከስም ገችዝድባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ኖይንታ ኤሀ ኤድን ሙደንካ ክክን ሳብም ጎይንድባከ ጳዝድባብ ኤች Ꮊቄ፥ ር ካየንባብከስካንተረ በድ እመንም እምድዮ Ꮊቄ፥ ሳብደረረ ሙዳᎺይካ ምግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ዋልቃሰጭ Ꮊየካ ሳክላ ሳዓትካ ሳብታ ክታይንች ክደር አርድዮ “ቆርነሎሶ!” ጋይሶ ክትም ኤልድንካ ለምለም ጋይድንደትካ መያ ክትካንታ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ፍስሳ ይይሶ ክታይንችንደር ሰድሶ ገቅካ “ጮይስዮ! Ꮊረ?” ጋይሴ። ክታይንችነረ፥ “የስታ ምክስንኬ ሪካየንባብከስካንታ የስ ይድን እመና ኡርማ የስካንታ ገቅርምድንዳ ማትሶ ሳብታ እሪ Ꮊፈርቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ታየረ ኤድንከስም እዮጰ ካተመናር ኦይትሰዮ ጴጥሮስ ጋይምድባብ ስምኦንም ኤልስስካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ኖ ታ ሎቀን ባሀርንታ ላመር Ꮊፈርድን ጋመን ጭርድባብ ስምኦንታ ኤር ሶች ማትሶ ዶቅዴ” ኩን ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ኮም ኬዝባብ ክታይንችና ፋስምሶ አይሳንደትካ ቆርነሎስ ይንታ ፍክስንባብከሳርንካ ቃስተንንምኬ ክታ ማችን ዳምንባከሳርንካ ሳብም ጳዝድባብም ዋልቀንም ኤልሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ሙዳ ሪመረ ከትካንታ ኬዛንደታ ቡር ኦስ እዮጰ ካተመናር ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ዛማክንካ ካተመንኮታር ከት የልድንካ Ꮊየካ ቶርማ ማታባብ ማድንካ ጴጥሮስ ይ Ꮊቃን ኤሄናርንካ ኤሄንታዘን ኤሀ ዎድምሳንደታር ምክስካንታ ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ኮታይካ ጴጥሮስም ዳቅስንካ ዋልቃ ርም እችካንታ ዝግዜ፥ Ꮊየካ እችመረ ግግምዘን ዶቅድንካ ለምለም ጋይድንካ ኖ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ለምለም ጋይድንካ ክት ሰዳንደረ ጭላ ፎችምሶ ኦይድ ካንታ ዶቅድንዳ አንድር ስፍስታ አፍለም ካምድንዳ ር ጩላ ፍጨር Ꮊንቸርድንኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ኮታ ዘነረ Ꮊክ Ꮊክ ኦይድ ዱትካ ሙግድባብ ባችርንከስ፥ ፍጨካ ጎችምድን ፍዝርንከስኬ ፈድባብ አፍትንከሰረ ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ይና “ጴጥሮስዮ! አምሰዮ ከትከናከስም ማቸረዮ እችካ!” ጋይድን ኡፍስ ኖ ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ጴጥሮስ ማቼ “ጮይስዮ! ኮና ማታዬ! እታ ጭለጭል ማታክንደትም አነረ ቱና ርም እችስቶ ኤስክቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ጉጅሰረ “ሳብ ጭለጭል ይሳንደትም ኮና ቱነ የስም ጋይንት ዝክሳዬ” ጋይድን ኡፍስ አነታ ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ኮነረ ማከን ዱት ማቻን ቡር ናኮና አፍለን ካምድን ርና ሳነካ ፈስ ጭላር ተይምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ጴጥሮስ ለምለም ጋይድንካ ሰዳንደታ ቡልና “Ꮊሮክ ማተራ?” ጋየሮ ይንታ ገቅርንካ ክት ማጠርድንካ ቆርነሎስ ኦይችባብ ኤድንከስ ኦይስካ ስምኦንታ ኤሄንም Ꮊፍሶ ፉልተንዘን ዎእሶ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","አንድር ኡፍስካ ኤልሰረ “ጴጥሮስ ጋይምድባብ ስምኦን ሶች ማትሶ ክት ዶቅድንዳ ኤሄንካሮ?” ጋይሰኮ ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ጴጥሮስ ለምለም ጋይድንካ ይ ሰዳንደት ርን ገቅርዘን ክት ዶቅድንካ አያን ጭልና፥ “ይና! ማከን ኤድንከስ የስም ዝግደኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","አምሰዮ Ꮊንቸርካ፥ ከትም ኦይችባብ እ ማቻንካንታ ኦስ ፈንክ ጋያከይ ዶቆ ከትካ ክክን አይካ” ኩን ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ጴጥሮሰረ Ꮊንቸርሶ ኤድንከዝደር የልሶ “ይና የ ዝግድን ኤችና እትቴ፥ የ Ꮊዳንደና Ꮊረተረ?” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ከተረ “ዎ Ꮊዳንዳ ጸታ ዳምንባብከስም ገችዝድባብ ቆርነሎስደርንካ Ꮊዶቴ፥ ኖ አይሁድ ዎርሰና ሙዳ ክትም ቦንጅድባብ ሳብመረ ጎይንድባብ ጭል ኤዴ፥ የስም ይንታ ኤር ኤልስሶ የስ ጋይድንደትም ክት ኤሰርድንግንዳ ጭል ክታይንችና መያ ማስሶ ክትካንታ ከስቴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ጴጥሮሰረ ይዶቅድን ኤሄናር አርችሶ ከትም ሞክሶ ገችሴ። ዛማክንከረ አምሶ ከትካ ክክን አይሴ፥ ኢዮጴ ካተመናር ዶቅድን እስመንከሳርንካ ዋልቃ ዋልቀንከሰረ ክትካ ክክን አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ቃስትምስ ሰጨንካ ቅሳርያ ካተመናር የልሰኬ፥ ቆርነሎሰረ ይንታ ሱሰንከስምኬ ቅንች ይንታ ገርነንከስም ኤልሶ ጴጥሮስከስም ካርዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ጴጥሮስ ኤሄናር ክት አርድንካ ቆርነሎስ ክደር Ꮊድሶ ክታ ዱትንዘን ዋችሶ ክትካንታ ጎስትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ጴጥሮስ ማቼ “አምካ! እተረ የስግንዳ ኤድቴ!” ጋይሶ ክትም አምስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ክትም ከሰሮ ኤሄናር ክት አርድንካ በድ ኤድንከስ ሳንሶ ከትዶቅድንካ Ꮊፍሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ኮታዘንከረ፥ “አይሁድ ማችን ኤድ አብ ዎርሰንካ ክክን ዋልቃ ማትካንተከ Ꮊፍርካንታ ዎንታ አሜንንታ ህግናር ጋይዳክንደትም የታ የንታ ማታርንካ ኤዝደቴ፥ ኬዛር ማቼ Ꮊይመንመሬ ጭለጭል ማታክባበ አነረ ቱና እ ጋይዳክንግንዳ ሳብ እካንታ መያ ማስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ኮካንታ የ እዝደር ኤድን ኦይችንካ ግራክትዶቆ የንደር Ꮊዳቴ፥ ይና Ꮊረታ እም የ ኤልሳናነረ ኤስካንታ ዝግድቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ቆርነሎሰረ፥ “ኦይድ ሰጨታ እሪ ኮትኮግንዳ Ꮊየካ ሳክላ ሳዓትንዘን እስታ ኤር ምክሰሮ እ ዶቅድንካ፥ እ ገቀራክናና ዋልቃ ሮጵድን አፍላ ቆበርስባብ ኤች እስታ እሪ ዎእሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ኖየረ ‘ቆርነሎሶ! ሳብ የስታ ምክስን ኤሰርቴ፥ ሪካየንባብከስካንተረ የስታ እመና ገቅርምቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ይና ኢዮጴ ካተመናር ክታ ኦይትሰዮ ጴጥሮስ ጋይምድባብ ስምኦንም ኤልስስካ፥ ኖየረ ሎቃ ባሀርንታ ላማር Ꮊፈርድን ጋመን ጭርድባብ ስምኦነታ ኤር ሶች ማትሶ ዶቅዴ’ ኩን እም ጋይሴ ");
INSERT INTO gyl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ኮካንታ ሳነካ ኤድንከስም የዝደር ክታ ኦይቻቴ፥ የነረ የስታ Ꮊድንተንካ ኡርማ ይሳዬ፥ ይና ጮይስ የስ ኬዝድንግንዳ የስም ክትሳን ሙዳ ኤስርካንታ ዎታ ሙደና ሳብታ እር ካሪ ሳንምቶቴ” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ጴጥሮሰረ፥ ዶፈንካ ሳብ ኤድም ኤድዘንካ ስግ ማስዝዳክንደትም ኤስቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ꮊምን ፍጫ ኤድ ማቼረ ሳብም ጳዝድባብኬ ዶፈን ርም ፍግዝድባብ ማቼ ሳብ ክትም ይንታ ማዝዴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ሳብ እስራኤል ዎርሰንካንታ ኮ ይንታ ቃለንም ክት ኦይቻንዳ ኤስምሳንዴ፥ ሙደንታ ጮይስ ማችባብ የሱስ ክርስቶስጎካ ሳራትቼንም ሳባከሮ Ꮊዳንደረ ከትካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ዮሀንስ ስእርን ጎካ ሳባክሳን ሰጨንዘንካ የድሶ ገሊለዘንካ አምስሶ ይሁዳ ፍጨናር ሙዳ ይይምሳን ርም የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ሳብ ናዝረትንክንባብ የሱሰም አያን ጭልንካ ሳይሳንግንደከ ዎልቀረ ክትም እምሳንደትም ኤዝደቴ፥ ሳብ ክትካ ክክን ዶቅድንካንታ ኖየረ ኡርማ ርም ፍክሰሮ ዳብሎስካ የደርስባብም ሙዳ ፋቸሮ ኦንግዜ። ");
INSERT INTO gyl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“ይሁዳ ፍጨናር ካተማ ካየን ካርናርንኬ የሩሳሌም ካተመናር ክት ይሳን ር ሙደንታ ዎታ ማርኮቴ፥ ክትም ማቼ Ꮊቀዘን ሮክሰኮ ደይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ኬዛር ማቼ ሳብ ማክምስ ሰጨንካ ደእናርንካ አምስሶ ኤድንከስካንታ መያ Ꮊፈርድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ክት መያ Ꮊፈርሳንደረ እርምሶ ሳብካ ዎ እድምስባብ ማርከንከስካንታ ዳት ዎርሰን ሙደንካንታ ካዬ፥ ክት ደእናርንካ አምሳንደታ ቡር ዎታ ክትካ ክክን የካ እችባብከ ዎጭባብ ክታ ማርከንከሶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ኮም ርን ዎርሰንከስካንታ ዎ ኤስምዝድንግንዳ ኖ ሰንፔካ ዶቅድባብዘንኬ ደእስባብዘን ፋረድንግንዳ ሳብካ ጋይምስባብ ክት ማቻንደትም ዎ ማርከርድንግንዳ ዎም ክቴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ክትካ አሜንድባብ ሙደና ክታ ላምንካ ጎመታ ነገትቼን Ꮊፍተርንደትም ሳብዘንካ ኤሰርሶ ኬዛቅባብከስ ሙደና ክትካንታ ማርከርደኬ” ኩንጋየሮ ኬዛ የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ጴጥሮስ ኮም ከዝድንደትᎺይካ ቃለን ኤሰርስባብ ኤድ ሙደንታዘን አያን ጭልና Ꮊንቸርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ጴጥሮስካ ክክን Ꮊድባብከስ ሶለን ይንታ ተችባብ አይሁድ አመንድባብከዘንካ ሳብ አይሁድ ማታክባብከስካንታ አያን ጭልን እምምሳን ሰድሰኮ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","አይሁድ ማታክባብከስካንታ አያን ጭልና እምምሳንግንዳ ከት ኤሳንደረ አይሁድ ማታክባብከስና አብ አፈንከስካ ከት ከዝድንኬ ሳብም ጋለትካ ከት ቦንጅድንካ ከታ ይንታ ኤስርንኬ። ኮት ሳዓትንካ ጴጥሮስ፥ ");
INSERT INTO gyl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ኬና ኤድንከስ ዎግንዳ አያን ጭልንም ተይተኬ፥ ይና፥ ከታ ሎቀካ አሜንድባብከስታ ስእርን ስኤርዳክንግንዳ Ꮊይ ከትም ማርዳ?” ጋይሶ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ኮካንታ የሱስ ክርስቶሰታ ላምካ ከት አሜንድባብከስታ ስእርን ስኤርድንግንዳ ክትሴ፥ ኮታ ቡር ጴጥሮስ ከትካ ክክን ቶክም ሰጨታ ክት ዶቅድንግንዳ ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ይሁዳ ፍጨናር Ꮊፈርድባብ ኦይትምስባብከስኬ አሜንድባብ እስመንከስ አይሁድ ማታክባብከስ ሳብታ ቃለንም ከት ተያንደትም ኤሰርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ጴጥሮስ የሩሳሌም ካተመናር ማትሶ ክት አይሳንደትካ ሶላ ተችርና ዝግዝድንዳ ማትንተን አሜንድባብ አይሁድንከስ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Ꮊረተስ ሶለን ተቸራክን ኤድንከስታ ኤር አርድሰዮ ከትካ ክክን እችምን እቻራ?” ጋይንተካ ክትም ይንኤርካ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ጴጥሮስ ማቼ ከትካንታ ኩንጋየሮ ሙዳ ሪመረ ከታ ቡዳር አርድንግንዳ ኬዜ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“እታ ኢዮጴ ካተመናር ምክስዘን እ ዶቅድንካ ለምለም ጋይድንደትካ ሰድቴ፥ እ ሰዳንደረ አንድር ስፍስንደት አፍላ ካምድንዳ ር ኦይድ ካንተንም የድሶ ጭለዘንካ Ꮊንቸርድንከኬ እዝደር Ꮊድንካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ሪን ኮትም ፍስሳ ይስቶ እ ሰድንካ ስፍስንደት አፍለንታዘን መሄንከስም፥ ባችርንከስም፥ ልጴካ ጎችምድን ፍዝርንከስምከ ፈድን አፍትንከስም ሰድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","‘ጴጥሮስዮ! አምሰዮ ከናከስም ማችሶ እችካ!’ እም ጋይድንደትም ኡፍስ ኤሰርስቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","እታ ማቼ ‘ማታዬ ጮይስዮ! ጭለጭል ማታክንደትም አነረ ቱና ር እስታ አፋር እችሶ ኤስክቴ’ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ኬዛር ማቼ ቃስትምስ ዱት፥ ‘ሳብ ጭለጭል ማስሳንደትም የና ኮና ቱነ ጋይ የስም ዝክሳዬ’ ጋይድን ኬዘታ ማስን ጭለዘንካ ኤሰርስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ኮነረ ማከንዱት ሰድምሳንደታ ቡር ናኮና አፍለን ካምድን ርና ሙዳ ፈስ ጭላር ተይምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ይና፥ ኮትኮᎺይካ ቅሳርያ ፍጨናርንካ እዝደር ክትምስባብከስ ማከን ኤድንከስ እ Ꮊቃን ኤሄንታ ፍልተዘን የልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ꮊኤርክሳ ከትካ ክክን እ አይድንግንዳ አያን ጭልና እም ኬዜ፥ ከነረ አሜንድባብ ላ እስመንከሰረ እንካ ክክን Ꮊቀኬ፥ ከትከረ ክክን የካ ቆርነሎስ ጋይምስባብ ኤችንታ ኤር አርደዶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ኖየረ ክታ ይንችን ይንታ ኤር ዎእስንካ ሰዳንደትግንዳ ‘እዮጴ ካተመናር ኤድም ኦይትሰዮ ጴጥሮስ ጋይምስባብ ስምኦንም ኤልስሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ኖየረ የስከ የስታ ኤሀ ኤድንከ ሙዳ የ አቅድንደታ ቃላ የካንታ ኬዝተሬ’ ክትም ጋይሳንግንዳ ዎካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","እተረ ኬዛ እ የጃንደትካ አያን ጭልና እርምሶ ዎንዘን Ꮊንቸርሳንግንዳ ከታዘነረ Ꮊንቸርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ኮታይካ ‘ዮሀንስ ሎቀካ ስእሴ፥ የታ ማቼ አያን ጭልንካ ስኤርትረቴ’ ጋይሶ ጮይስ ኬዛን ቃለና እም ገቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ዎታ ጮይስ የሱስ ክርስቶሳር አሜንሳንᎺይካ ሳብ ዎካንታ እምሳን እምንተን ከትካንተረ እምምሳንዳ ማቼ፥ ይና፥ ሳብም ማርካንታ ማድባብ እታ Ꮊይራ!” ");
INSERT INTO gyl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ከተረ ኮም ኤሰርሳንደትካ ከት ማዝድንደት ካይድንካ ጫምን ጋይሰኬ፥ “ይና ሳብ አይሁድ ማታክባብከስካንተረ ዶቅንትካንታ ከትም ማስዝድን ጎማ ፍክስ ከት ዎይስዝድንግንዳ ጋይቴ” ጋይንተከረ ሳብም ጋለቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","እስጥፋኖስ ሰይንካ አቀርሶ ደእሳን Ꮊይካ አምሳን ዳይርንጎካ ይጭምስባብ አሜንድባብከስ ፍንቃ ፍጨናርከ ቆጵሮስ ካተመናር የለልታ ኮትኮግንደረ አንጾክያ ካተመናር አይሰኬ፥ ቃለንመረ አይሁድንከስካንታ Ꮊክ ዳት አብንከስካንታ ከዛከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ማታጋካ ዳት ቆጵሮስ ካተመናርኬ ቃረና ፍጨናርንካ Ꮊድባብከስ ዋልቃ ዋልቃ አሜንድባብከስ አንጾክያር አይሳንᎺይካ ግርክ አፈን ኬዝድን ኤድንከስካንታ ዎራ ጮይስ የሱስጎካ ኡርማ ክላ ኬዘንም ሳባክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ጮይሰረ ይንታ ዎልቀንካ ከትም አለን አልድ Ꮊቄ፥ በድ ኤደረ አሜንሰኮ ፈንክ ጮይስደር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","የሩሳሌም ካተመናር ዶቅድባብ አሜንድባብከስ ኮም ኤሰርሰኮ ባርናባሰም አንጾክያ ካተመናር ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ባርናባሰረ አይሶ ሳብ ይንታ ዉች እምንተን ዎርሰንካንታ Ꮊስግንዳ እምሳናንከረ ሰድሶ ጉርምሴ፥ ሙደነረ ቦድማ ቡዳርንካ ዳቅሰኮ ጮይስካንታ አሜንምስባብከስ ማትሰኮ ከትዶቅድንግንዳ ከትም ዞርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ኖየረ አያን ጭልንኬ አሜን ጮጭባብ ላቅም ኤድ Ꮊቄ። ፋይደነረ ከታ በድ ማችባብ ኤድንከስ ፈንክ ጮይስንደር ማቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ኮታ ቡር ባርናባስ ሳዉልም ዝግመትካንታ ጠርሰስ ካተመናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ክትም ይ Ꮊፍሳንደትካ አንጾክያ ካተመናር ክትም ተይᎺዴ፥ ከታ ቃስተነረ ዋልቃ ስላ ጮጭ የለልታ ምክስ ኤሄናር ሳንምሰኮ በድ ኤድንከስም ኤስሰኬ፥ አንጾክያ ካተመናር አሜንስባብከስ ኮታዘንካ የድሶ “ክርስቶሳር ማችባብከስ” ጋይምሰኮ ኤልምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ኮታይከረ ዋልቃ ዋልቃ ሳብዘንካ ኤሰርሶ ኬዝድባብ ጋይምሶ ኤልምድባብከስ የሩሳሌም ካተመናርንካ ኦስ አንጾክያ ካተመናር አይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ከታርንከረ ዋልቀና አጋቦስ ጋይምድባብ አምሶ ፍጫሙደንዘን አንድርይ ዳቅ ማድንደትም አያን ጭልና አምስንካ ቤርካ ኬዜ፥ ኮነረ ማቻንደና ሮማ ፍጨናር ባንችምስባብ ባንችን ቃለዉዶስታ ስላር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ኮካንታ አንጾክያ ካተመናር ዶቅድን አሜንድባብከስ ይሁዳ ፍጨናር ዶቅድባብ እስመንከስካንታ ዋልቃ ዋልቃባብከስ ከታ ይንታ ዶቅድንደትከካ ዉችሰኮ አላ ከትካንታ ኦይትምድንግንዳ ጋይሰኮ ከዝምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ዉቸንም ዉችሰኮ ባርናባሰተኬ ሳዉልተካ አንካ ምክስ ኤሄናር ጎርዝድባብከስካንታ ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ኮትኮ ስለናር ባንችን ሄሮድስ ዋልቃ ዋልቃ ምክስ ኤሄናር ኤድንከስም ዳይ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ዮሀንሰታ እስመን ያይቆበም ማሰካ ደይስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ኮና ርና አይሁድንም ጉርምሳንደትም ሰዳንደትካ ጴጥሮስመረ ጉጅሶ የችሴ፥ ኮነረ ማቻንዳ አይሁድና ባይስ ባአልን ከት ቦንጅድን ሰጨንከስካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ጴጥሮስም ይ የችሳንደታ ቡር ዞክና ኤሀር ክትም ኦይቼ፥ አይሁድንታ ፋስጋ ባአልንታ ቡር ዎርሰንካንታ ይ ክትም ተይᎺተርን የለልታ ኦይድ ኦይድ ማትሰኮ ክትም ከት ካርዝድንግንዳ ኦይድ ካርዘን ካስምስባብ ዳምንባብከስካንታ ስክስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ኮካንታ ጴጥሮስ ዞክና ኤሄናር የድርሶ ካርስምድ Ꮊቄ፥ ኬዛር ማቼ አሜንድባብከስ ክትጎካ ሳብደር ዳቅስሶ ምግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ሄሮድስ ዛማክንካ ጴጥሮስም ዎርሰንካንታ ተይᎺድካንታ ገቀርታ Ꮊቄ፥ ጴጥሮሰረ ኮት ሶይትንካ ቃስተን ሳንቼለትካ ዞከርሶ ቃስተን ዳምንባብከስታ ዎክያር ራትሶ Ꮊቄ፥ አብ ዳምንባብከሰረ ዞክና ኤሄንታ ፍልተን ካርዝድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ኮታይካ ጮይስታ ክታይንች መያ ማትሶ ክትካንታ Ꮊፈርሴ፥ ዞክና ኤሄንታ ዋር ሳክመና ሳክሴ፥ ክታይንችነረ ጴጥሮሰታ ከለን ዎልሶ ይ ንክሳንደታ ቡር “ሳነካ አምካ!” ክትም ጋይሴ፥ ሳንችለትንከሰረ ክታ አንንከዘንካ ዋቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ክታይንችነረ “የስታ አፍለንም ቆበርካ! የስታ ኮጰንም አርችካ!” ክትም ጋይሴ። ጴጥሮሰረ ይም ክትሳንግንዳ ይሴ፥ ክታይንችነረ “አፍለን የስታ ቆበርሰዮ እስታ ካርንካ ጎርስምካ!” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ጴጥሮሰረ ዉትስንደትኬ ክትም ጎርስምሴ፥ ለምለም ጋይድንካ ሰድንም ካምሳ ዳት ክታይንችና ይሳን ርና ሙዳ ዶፈን ክደር ካማክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ዋልቀንምኬ ቃስትምስን ካርስንባብም ስግሶ ኦስ ካተማ የልስዝድን ስብል ዝጭንደር የልሰኬ፥ ዝጭነረ ኤድ ዎላክናና ዉችኩን ከትካንታ ፎችምስንካ ዉትሰኮ ዋልቃ ሉጋ ጎግካ ስግሰኮ አይሰኬ፥ ክት ገቀራክናና ክታይንችና ክታዘንካ ፋስምሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ጴጥሮሰረ ቡዳ ክታ Ꮊዳን ቡር “ጮይስ ይንታ ክታይንችን ኦይትሶ ሄሮድሰታ አንናርንኬ አይሁድንታ ዎርሰና ካርዝድ Ꮊቃን ር ሙደንዘንካ እም አቅስባብ ማትንተን ታ አክ ዶፈንካ ኤስቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ኮም ይንታ ቡዳር ገቀርሳንደታ ቡር በድ ኤድንከስ ዋልቃትቼካ ሳንምሰኮ ከት ምግዝድን ማራመታ ኤር አይሴ፥ ናኮና ማራመረ ማርቆሰ ጋይምስባብ ዮሀንሰታ እንደና Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ጴጥሮስ ዋር የልሶ ማልጎካ ፍልተንም ቆንክሳንደትካ ሮዳ ጋይምድንዳ ዋልቃ ፍክስንዳ Ꮊይ ማቸረ ኤስካንታ ፍልተንደር ና Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ጴጥሮሰታ ኡፍስ ማትንተን ይ ኤሳንደትካ ይንታ ጉርምንታ በድምዘንካ አምሳንዳ ፍልተንም ፎቻክዶቆ ዞደካ ኤሄናር አርድሶ “ጴጥሮስ ፍልተዘን ዎእቴ!” ጋየሮ ና ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ከተረ “የና ኤይተዬ!” ኮትም ጋይሰኬ። ና ማቼ “ዶፈንካ ኖዬ!” ጋየሮ ኬዜ፥ ከተረ ኮማቼ “ክታይንች ማተረ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ጴጥሮስ ማቼ ፍልታ ቆንክንም ጉጅሴ፥ ከተረ ፍልተንም ፎችሰኮ ክትም ይ ሰዳንደትካ በርእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ኖ ማቼ ጫምን ከት ጋይድንግንዳ ይንታ አንካ ሰችሶ ጮይስ ዞክና ኤሄናርንካ Ꮊስግንዳ ክትም ዉችሳናነረ ከትካንታ ኬዝሶ “ኮም ርን ያይቆብ ካንተኬ ነግድን አሜንድባብከስካንታ ከስከቴ” ከትም ጋይሴ። ከታዘንካ ፋስምሰረ አብ ካርያር ኖ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ፍጨና ሰጭድንካ ዳምንባብከስ “ጴጥሮስም Ꮊራ ክትም የልሳ ዳቶ?” ጋይንተካ አንድር አዉል የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ሄሮድሰረ ይጎካ ጴጥሮስም ዝግዝንካ ክት Ꮊፈርክሳ ነገዳን ቡር ካርስንባብከስም ማለካ ኦይስሶ ከት ደይስምድንግንዳ ክትሴ፥ ኮተረ ቡር ሄሮድስ ይሁዳርንካ ኦስ ቀሳርያ ፍጨናር አይሶ ኮታር ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ሄሮድስ ትያጥሮስ ፍጨናርንኬ ሲዶና ፍጫ ኤድንከስታዘን ዋጫንካንታ፥ ከተረ የካ Ꮊድሰኮ፥ ባንችንካንታ ክትምድባብ ብላስጦስ ከደር ዋልቃ ማድንግንዳ ምክስሶ ኤእሳንደታ ቡር ባንችንም ኤድምስካንታ ኦይሰኬ፥ ኮመረ ከትይሳንዳ ከታ ፍጫ ኤድና እችም Ꮊብድንዳ ባንችን ገችዝድንደታርንካ ማቻንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ጋይምሳን ሰጨንካ ሄሮድስ ባንችም አፍለን ቆበርሶ ይንታ ባንችምንታ ጎንገንዘን ዶቅሶ ዎርሰንካንታ ኬዛ የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ዎርሰነረ “ኮና ሳብታ ኡፍስ ዳት ኤታ ኡፍስ ካዬ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ሄሮድስ ሳብካንታ ቦንቻ እምክሳ ክታ ነግንተንካ ካርንኮታዘን ጮይስታ ክታይንችና ክትም ጫርጵስንካ ዘነና ክታ ካቸካ እቸርሶ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ሳብታ ቃለና ማቼ ሙዳᎺይካ ጋጰርንደትኬ ዳልገሮ አይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ባርናባሰኬ ሳዉልካ ሳብታ ፊክስን ቦድሰኮ የሩሳሌም ካተመናርንካ አንጾክያ ካተመናር ማቼከ፥ ማርቆስ ጋይምስባብ ዮሀንሰመረ ከታ ይንካክክን የድሰኮ Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","አንጾክያ ካተመናር ዶቅድን ምክስ ኤሄናር ሳብዘንካ ኤሰርሶ ኬዝድባቤ ጋይምሶ ኤልምድባብከስኬ ኤስስንባብከስ Ꮊቀኬ፥ ከተረ ባርናባስ፥ ጫልምዬ ጋይምስባብ ስምኦን፥ ቀረና ፍጨናርንክንባብ ሉክዮስ፥ ኦይችምስ ዱት ዎርሰንም ቆልስባብ ሄሮድሰካ የካ ጋጵስባብ ምናሄኬ ሳዉልካ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ከተረ ጮይስካንታ ጎይነረኮ እችክሳ ዎጭክሳ ከት ምግዝድንካ አያን ጭልና “እ ከትም ኤልሳን ፍክስንካንታ ባርናባስምንኬ ሳዉልም እካንታ ፋስኬቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ከተረ በቼካ ምክስሰኮ አና ከትካንታ ምክስንደትኬ ከታ ይንታ አንን ክታዘን ዎጃንደታ ቡር ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ባርናባሰኬ ሳዉልካ አያን ጭልንካ ኦይትምሶ ኦስ ሰለዉቃ ፍጨናር አይሰኬ፥ ኮታርከረ ሎቀንዘንካ ቃልዝድን ማርከብንካ ቆጵሮሳር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ኦስ ሰላምስ ካተማር ከታ ይ የልሳንደትካ አይሁድንታ ምክስ ኤሄናር ሳብታ ቃለንም ኤስሰኬ፥ ዮሀንስ ጋይምድባብ ማርቆሰረ ከትካ ክክን ማትሶ ከትም አሌን አልድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ሎቀንታ ዎክያር ደንን ቆጰሮስም ስግሰኮ ኦስ ጳፋ ካተመናር ከት የልሳንደትካ ባርየሱስ ጋይምድባብ ዋልቃ አይሁድንታ መጫ ካይድባብም Ꮊፍሰኬ፥ ኖየረ ካርከካ ሳብዘንካ ኤሰራክዶቆ ኬዝድባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ክት ዶቅድንደረ ሰርግዮስ ጳውሎስ ጋይምድባብ ገቅርካ ፍጨንም ቆልድባብካ ክክን Ꮊቄ፥ ኖኮና ፍጨንም ቆልድባብ ባርናባሰምንኬ ሳዉልምካ ኤልስሶ ሳብታ ቃለንም ኤስርካንታ ዝግዜ። ");
INSERT INTO gyl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ኬዛር ማቼ ግርክ አፈካ “ኤልማስ” ጋይምሶ ኤልምድባብ መጨንም ካይድባብ ባርየሱስ ፍጨንም ቆልድባብ ክት አመንዳክንግንዳ ዝግሶ ባርናባሰምንኬ ሳዉልም ግርንተካ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ጳውሎስ ጋይምስባብ ሳዉል ማቼ አያን ጭልንካ ጮጭሶ ኤችንም ፍስሳ ሰድሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“የና ዳብሎሰታ ይንችኖ! ጭላትች ሙደንታ ይምኤንባብና! ገስኬ ዳቅልካ ሙዳ የሳር ጮጭባብ፥ ሉላ ማቻን ጮይስታ ጎግንም ዎብስንም የና ዛቃያ! ");
INSERT INTO gyl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ታየረ ይና፥ ጮይስታ አንና የስም ጉጵተሬ፥ ዝለረ ማተረዬ፥ ቶክምᎺይክንደተረ Ꮊይታ ሳክመንም የና ሰተራከዬ” ኩን ክትም ጋይሴ። ሳነከረ ክታ አፍንም ዳላ ኦቼ፥ ክታ አንንም የድሶ ጎርዝድባብመረ ኤድ ይንታ ካንተንካ ታፍት የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ፍጨንም ቆልድባበረ ይይምሳን ርን ይ ሰዳንደትካ አሜንሴ፥ ጮይስጎከረ ይ ኤሰርሳን ኤስስንከረ በርእሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ኮታ ቡር ጳውሎስኬ ክታ ላኮይትንከስካ ሎቀንዘንካ ቃልዝድን ማርከብናር አርድሶ ጳፋ ካተመናርንካ ጵንፍልያ ፍጨናር Ꮊፈርድን ኦስ ጰርገ ካተመናር አይሰኬ። ማርቆስ ጋይምስባብ ዮሀንስ ማቼ ከታዘንካ ፋስምሶ ኦስ የሩሳሌም ማት አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ከታ ማቼ ጴርጋ ካተመናርንካ አምሶ ጵዝድያ ፍጨናር Ꮊፈርድን አንጾክያር ካተመናር አይሰኬ፥ አይሁድንታ Ꮊዉስ ሰጨንካ ዋልቃ አይሁድንታ ምክስ ኤሄናር አርድሶ ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ሙሴታ ህግንኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ማጻፍንከስ ናበብምሳንደታ ቡር አይሁድንታ ምክስ ኤሄንታ ገችንባብከስ “እስመንከሶ፥ ዎርሰንም ዳቅስዝድንዳ ዞረታ ቃላ የንደር ዶቅሴ ኬዝከቴ” ጋይሰኮ ጳውሎስ ከዝደር ኤድም ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ኮካንታ ጳውሎስ አምሶ ዎርሰንም ይንታ አንካ ሰችሴ፥ ኩነረ ጋየሮ ኬዜ፥ እስራኤል ኤድንከስኬ ሳብም ጳዝድባብከስ የታ አይሁድ ማታክንባብከስ! ኤሰርከቴ! ");
INSERT INTO gyl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ኮ እስራኤል ዎርሰንታ ጮይስና ኤና እሪ ዎንታ ባቤንከስም እጄ፥ ግብጽ ፍጨናር ከት ᎺቃንደትᎺይከረ አንድር ዎርሳ ክትም ማስሴ፥ ይንታ አንድር ዎልቀንከረ ኮትኮ ፍጨናርንካ ከትም ዉችሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ቃስተን ቦንዳ ስለረ ማታባብ ዴል ቆቸናር ከትም ዳንዳእሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ኮታ ቡር ከነአን ፍጨናር ታብዛ ኮችንከስም ካይስሶ ከታ ፍጨንም ከት ተያባብ ይስሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ኮተረ ቡር ኦይድ ጸተኬ ቃስተንቦንደኬ ታማ ስላ ማታባብ ሳብዘንካ ኤሰርሶ ኬዝባብ ሳሙኤል የለልታ ከታዘን ፍርዳ እመሮ ከትም ገችዝድባብከስም ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ኮታዘንከረ ጉጅሶ ባንችን ከትካንታ ባንችዘድንግንዳ እስራኤል ዎርሰና ኦይሰኬ፥ ሳበረ ብንያመታ ኮች ማችባብም ቂስታ ይንች ሳኦልም ቃስተን ቦንዳ ስላ ከትካንታ ባንችምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ሳኦልመረ ክታ ባንችምንዘንካ ይ Ꮊንችሳንደታ ቡር ዳዊተም ከትካንታ ባንችምሴ፥ ሳበረ ዳዊትጎካ ማርከርድዮ፥ እስታ ዝግመትንግንዳ ማድባብም፥ እስታ ጋይተንም ቦድባብ እሰይታ ይንች ዳዊተም Ꮊፍስቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ኮ ኤችንታ ሱሳርንካ ሳብ ይ አርደዳን ጉርም ቃለንዘንካ አምሳንዳ እስራኤል ዎርሰን አቅስንባብ የሱሰም ከትካንታ አምስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","የሱስ Ꮊተርንደታ እሪ ዮሀንስ እስራኤል ኤድንከስ ሙደንካንታ ጎማ ፍክስን ዎይስታ ስእርን ሳባክታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ዮሀንሰረ ፍክስንም በይሳዶቅድዮ እታ Ꮊይምስ የንደር ካምሳረ? እታ ኖ ካይቴ፥ ከዛርማቼ ክታ ጫመንታ ዞክነንደትም ቡልካንታ ዎራ እታ ማዳክባብቴ፥ እስታ ቡር አብና Ꮊዴ ጋይድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","የታ አብራሀመታ ሱሳርንካ አጥምስባብኬ የተረ ሳብንም ጳዝድባብ አይሁድማታክባብከስ ዎንታ እስመንከሶ! ኮና አቅንተታ ቃለና ኦይትምሳንዳ ዎካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","የሩሳሌም ካተመናር ዶቅድን ኤድንከስኬ ከትም ገችዝድባብከስ የሱስ አቅዝድባብ ማትንተን ኤሳከኬ፥ አይሁድንታ Ꮊዉስ ሰጨንከረ ናበብምድን ሳብዘንካ ኤሰርሶ ከዛቅባብታ ማጻፍን ኤሳክንካንታ ከታ ፍርደና ቦድምድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ꮊረነረ ዎራ ደእካንታ ክትም የልስዝድን ጎግ Ꮊፍክሳ ከት ነግድንከረ ክትም ከትካንታ ደይስዝድንግንዳ ጵላጦሰም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ክትጎካ ጻፍምሳንደትም ሙዳ ከት ቦጃንደታ ቡር ማዝቀልንዘንካ Ꮊንችሰኮ ዱክሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ኬዛር ማቼ ሳብ ደእያርንካ ክትም አምስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ገሊላ ፍጨናርንካ ፈንክ የሩሳሌም ካተመናረረ ክትካ ክክን Ꮊድባብከስካንተረ በድ ሰጫ ከትካንታ Ꮊፈርሴ፥ ከተረ ታ ዎርሰንታ እሪ ክታ ማርኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ዎተረ የካንታ ዎ ሳባግድንዳ ሳብ ዎንታ ባቤንከስካንታ ጉርምካ እምሳንደትም ክላ ከዘኔ። ");
INSERT INTO gyl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ሳብ የሱሰም ደእናርንካ ክትም አምስንካ ኮትኮም ጉርምን ዎ ኬታ ይንችንካንታ ቦቴ፥ ኮንረ የቺ የድይ ቃስትምስናር፥ የና እስታ ይንቸዬ፥ እታ የስም ታካ አእትቴ። ጋይምሶ ጻፍምሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ክት ጫብዳክንግንዳ ሳብ ክትም ደእያርንካ አምሳንደትም ኤድ ማለካ ኤዝድንግንዳ ይይካንታ፥ “ሳብካንታ ፋስምሳንደትምኬ አሜንምሳን አንጀንም፥ ዳዊትካንታ እምምሳን ጉርምን የካንታ እምትቴ” ጋይሶ ከስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ጉጅሰረ የቺ ማጻፍ የድይ አብናር፥ “ ‘የስካንታ ፋስምስባብ የስታ ይንችና ጫፍድንግንዳ ይዳከዬ’ ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“ኬዛር ማቼ ዳዊት ይ ዶቅድን ስለንከሳር ሳብታ ፍክስንም ሳብታ ጋይተን ግንዳ ይ ቦጃን ቡር ደእሴ፥ ይንታ ባቤንከስ ዱከርሳንደታር ዱከርሴ፥ ኖ ጫፍሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ሳብ ደእናርንካ አምስባብ ኖ ማቼ ጫፋክየ። ");
INSERT INTO gyl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","ይና እስታ እስመንከስኬ ምችነንከሶ! ጎመታ ነጋትቼና Ꮊፈርድንዳ የሱሳር ማትንተን የካንታ ሳባክምሳንደትም ኤስከቴ፥ ኮትኮግንደረ ክትካ አሜንድባብ ሙደና ሙሴጎካ እምምሳን ህግና ጭልስካንታ ማታክን ጎማ ሙደንዘንካ ጭልዝዴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ኮካንታ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስካ ኩን ጋይምሶ ኬዝምሳንዳ የንዘን የልዳክንግንዳ ካርስምከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘የታ Ꮊልተርንባብከስ ሰድከቴ! በርእከቴ! ካይከቴ! Ꮊየነረ ኤድ የካንታ ኬዝዴ፥ የ አሜንዳክንደትም ፍክስ የንታ ስለናር ፍክስትቴ።’ ” ");
INSERT INTO gyl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ጳውሎስኬ ባርናባሰካ አይሁድንታ ምክስ ኤሄናርንካ ከት ዉድንካ ኮትኮርን Ꮊድን አይሁድንታ Ꮊዉስ ሰጨንካ አናካርንካ ከትካንታ ኬዝድንግንዳ ኤድንከስ ከትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","አይሁድንታ ምክስ ኤሄናር ሳንምስባብ ይጭምሳን ቡር በድ አይሁድንከስታ ኮችንኬ አይሁድንከስታ አሜንናር አርድሰኮ ሳብም ጎይንድባብ ኤድንከስ ጳውሎስምኬ ባርናባሰም ጎርስምሰኬ፥ ጳውሎስኬ ባርናባሰካ ኤድንከስም ከስሶ ሳብታ ዉች እምንተናር ዳቅሶ ከትዶቅድንግንዳ ከትም ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ቃስትምስ አይሁድንታ Ꮊዉስ ሰጨንካ ካተመናር ዶቅድባብከሳርንካ ቶክምና ነገድንካ በድንከስ ሳብታ ቃለንም ኤሰርካንታ ሳንምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","አይሁድንከስ ዎርሰንታ በድምን ሰዳንደትካ ቀምስምካ ጮጨኬ፥ ክታ ኬዘንመረ ግረረኮ ጳውሎስም የክሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ጳውሎስኬ ባርናባሰካ ማቼ፥ “ሳብታ ቃለና እርምሶ የካንታ ከዝም ዝግዝድንዴ፥ የታ ተይዳኮቴ የ ጋይሰኬ ስለንካ ዶቅንትና የም ዝግዝዳክንደትግንዳ የንታ ማታርንካ የ ፋረጃን ማቼ ኮሰቼቴ፥ ዎታ ዋልን ጋይሶቶ አይሁድ ማታክባብከዝደር አይዶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ኮመረ ዎ ይድንዳ ጮይስ ‘አቅንተንም ፍጨታ ካንታ የለልታ የስ የልዝድንግንዳ አይሁድ ማታክባብከስካንታ የስም ሳክማ ማስትቴ’ ጋይንተካ ዎም ክትሳንካንቴ” ኩን ጋየረኮ ሙቅምካ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","አይሁድ ማታክባብከስ ኮም ኤሰርሳንደትካ ከትም ጉርምሴ፥ ጮይስተረ ቃለን ቦንችሰኬ፥ ስለንካ ዶቅንትታ እድምስባብከሰረ ሙደና አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ጮይስተረ ቃለና ኮት ፍጨናር ሙዳ ዳልግዜ። ");
INSERT INTO gyl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","አይሁድን ጎርዝድባብከስ ማቼ አይሁድንታ አሜንን ጎርስምድባብ ማችባብከስ ቆልመንባብ ማነንከስኬ ካተመንታ አንድር ኤድንከስ ዙዝምስሰኮ ጳውሎስዘንኬ ባርናባስዘን ዳይርና አምድንግንዳ ይሰኬ፥ ከታ ይንታ ፍጨናርንከረ ከትም ዉችሴ። ");
INSERT INTO gyl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ጳውሎስኬ ባርናባሰካ ከትካንታ ኤግዝምስ ማድንግንዳ ከታ ይንታ ዱትንታ ቡልን ድግስሰኮ ኦስ እቆንዮን ካተመናር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","አንጾክያ ፍጨናር አሜንድባብከስ ጉርምኬ አያን ጭልንካ ጮጨኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","እቆንዮን ካተመናር ጳውሎስኬ ባርናባሰካ የካ አይሁድንታ ምክስ ኤሄናር አርደደኬ፥ ኮታረረ በድ አይሁድንኬ አይሁድ ማታክባብከሳርንካ አንድር በድ ኤድንከስ አመንተርን የለልታ ኤስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","አመናክን አይሁድና ማቼ አይሁድ ማታክባብከስም አምስሶ አሜንድን እስመንከዘን ዋጭማ አምድንግንዳ ይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ኮካንታ ጳውሎስኬ ባርናባሰካ ጮይስትንደትም ሙቅምካ ኬዘረኮ ኮታር በድ ሰጫ ዶቅሰኬ፥ ጮይሰረ አተንምኬ በርእዝድን ሪንከስም ኬታ አንያር ፍክስምድንግንዳ ገችታ ኤራ እምንተካ፥ ክታ ዉች እምንተንታ ቃለና ዶፈን ማትንተን መያ ማስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ካተመናር ዶቅድባብ ኤድንከስ ማቼ፥ ቃስተንካርዘን ፋስምሰኮ የከና አይሁድንከስካ ክክን የከንከስ ኦይትምስባብከስካ ክክን ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","አይሁድ ማታክባብከስኬ አይሁድንታ ገችንባብከስካ ክክን ማትሰኮ ጳውሎስምንኬ ባርናባሰምንካ ጋፍስካንተኬ ሰይንካ ከትም አቅናካንታ ዝግዘኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ጳውሎስኬ ባርናባሰካ ኮም ከታ ይ ኤሳንደትካ ልስጥራርኬ ደርቤ ጋይምድን ልቃኦን ካተመንከሳርኬ ከታ ካንተካ ዶቅድን ፍጨናር አጥምሶ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ኦኮታረረ ክላ ኬዘንም ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ልስጥራ ካተመናር ዱት ምጨልስባብ ዋልቃ ኤች Ꮊቄ፥ ኮና ኤችና ይ አጠርሳንደትዘንካ የድሶ ዎብ ይ ማቻንጎካ ይንታ ዱትካ ሙክሶ ኤዝዳክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ኮና ኤችና ጳውሎስ ከዝድንደትᎺይካ ዶቅሶ ኤሰርድ Ꮊቄ፥ ጳውሎስ ኤችንም ፍስሳ ሰድሶ አቅንታካንታ ማስዝድንዳ አሜን ክታ ዶቅድንደትም ይ ሰዳንደትካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","“ጋዝድን ጋይሰዮ የስታ ዱትንካ ዎእካ!” ጋየሮ አንድር ኡፍስካ ኬዜ፥ ኤችነረ ጎበካ አምሶ ሙክንት የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ኤድንከሰረ ጳውሎስ ይሳን ሰዳንደትካ፥ ከታ ይንታ ኡፍስንም ጬክሳ ይሰኮ “ጮይስንከስ ኤድም ካምሶ ዎንደር Ꮊንቸርሴ!” ጋይንተካ ልቃኦን ፍጨንታ አፈንካ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ባርናባሰመረ “ድያ” ጋይሰኬ፥ ሙደንዘንካ ስግ ኬዝድባብ ጳውሎስ ማቻንካንታ ክትም “ሄርመን” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ካተመንታ እሪጎካ ዶቅድን ድየታ ጭል ኤሄንታ ቄስነረ ገዝምትንከስምከ ቦነንከስካ ኡርሰርሳን ማተዘን ዎደርድንደትም ካተመንታ ፍልተዘን ተይᎺድሶ ዎርሰንካ ክክን ዋልቃ ማትሶ ጳውሎስካንተከ ባርናባሰካንታ ካስ እምካንታ ዝግዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ኦይትምስባብ ጳውሎስኬ ባርናባሰካ ማቼ ኮም ከታ ይ ኤሰርሳንደትካ ሞርእካ ይንታ አፍለንከስም Ꮊእሰኬ፥ ዎርሰንደር ዞደረኮ ፍፈሮ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“የታ ኤድንከስ Ꮊረተንት ኮም ይዳ? ዎተረ የግንዳ ኤዶቴ፥ ዎታ ካሪ ዎ Ꮊዳንዳ የታ ኮ መይዳክን ር ሙደንዘንካ ጎተርሰቶ ጭለም፥ ፍጨም፥ ባሀርንኬ ከታ ዋረረ Ꮊፈርድባብከስም ሙዳ ፍዝባብ ዶቅንት ሳብንደር የ ማድንግንዳ ክላ ኬዘን የካንታ ሳባክካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ኤንገር ስግዳን ስለንከሳር ዎርሰንከስ ሙዳ ይንታ ጎግካ አይድንግንዳ ሳብ ከትም ዛቅቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ማታጋካ ዳት ኖ Ꮊስግንዳ Ꮊልስማ ጮይስ ማትንተን ማርከርድን ኡርማ ፍክስን ይንታ ዛቃክዬ፥ ጭለዘንካ ዶብን የካንታ ቃንሴ፥ እስን ስከርድን አርፍንመረ የካንታ እምሴ፥ እችምከ ጉርምካ የንታ ቡደን Ꮊዉስሴ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ኦይትምስባብከስ ኮ ከከረ ከት ኬዝንከረ ዎራ ዎርሰና ከትካንታ ካስን እምዳክንግንዳ ነክሳንዳ በድ ማጠኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","አይሁድንከስ ማቼ አንጾክያ ካተመናርኬ እቆንዮን ካተመናርንካ Ꮊድሶ ዎርሰንም አምስስሰኮ ጳውሎስም ሰይንካ ከት አቅድንግንዳ ይሰኬ፥ ክት ደእሳን ከደር ካምስንካ ጎችሰኮ ካተመናርንካ ዉችሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ኬዛር ማቼ አሜንድባብከስ Ꮊድሰኮ ክታ ካንተንካ ከት ዎእሳንደትካ ጳውሎስ አምሶ ካተመናር አርደዴ። ዛማክንከረ ባርናባሰካ ክክን ደርቤ ካተመናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ጳውሎስኬ ባርናባሰካ ደርቤ ካተመናር ክላ ኬዘን ኤስሰኮ በድ ኤድንከስም አመንሳንደታ ቡር ልስጥራ ካተመናርከ እቆንዮን ካተመናርንካ ስግሰኮ ጵዝድያ ፍጨናር Ꮊፈርድን አንጾክያ ካተመናር አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ከትኬና ፍጨንከሳር ሙዳ አሜንድባብከስ ይንታ አሜንካ ዳቅድንግንዳ ከትም ዛብሰርንደትኬ ዞረሮ “ሳብታ ባንችምናር አርድካንታ በድ ማጣ ተይ ዎም ዝግዝዴ” ጋየረኮ ከትም ኤስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ምክስ ኤሄንከሳረረ ጋልተንከስም ዶርስሰኬ፥ በቼካ ምክሰረኮ አናካርንካ ምክሳንደተረ ቡር ከት አመንሳን ጮይስንካንታ ዋደካ ከትም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ጵዝድያ ፍጨናርጎከረ ስግሰኮ ጵንፍልያ ካተመናር አይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ጰርገም ፍጨናር ሳብታ ቃለንም ከታ ይ ኤስሳን ቡር ኦስ አጣልያ ካተመናር አይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ኮታዘንከረ ከታ ይ ቦጃን ፍክስንታ ሳብታ ዉች እምንተንካንታ ዋደካ ከትም ስክስት እምምሳንደር ኦስ አንጾክያ ካተመናር ሎቀንዘንካ ቃለርድን ማርከብንካ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ኮታረረ ከታ ይ የልሳንደትካ አሜንድባብከስም ሙዳ ሳንስሰኮ ሳብ ከትካ ክክን ማትሶ ይሳንደትም ሙደንምኬ አይሁድ ማታክባብከሰረ ከት አሜንድንግንዳ Ꮊስግንዳ ይይሶ ፍልታ ከትካንታ ፎችምሳናንከረ ከትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ኮታረረ አሜንድባብከስካ ክክን በድ ሰጫ ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ዋልቃ ዋልቃ ኤድንከስ ይሁዳ ፍጨናርንካ ኦስ አንጾክያ ካተመናር አይሰኮ፥ “ሙሴካንታ እምምሳን ህግንግንዳ ሶለን የንታ የ ተቸራክንዳ ማቼ አቅንታካንታ ማዳከቴ” ጋየረኮ አሜንድባብከስም ኤስስ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ጳውሎስኬ ባርናባሰካ ኮርንጎካ ኤድንከስካ ክክን አንድር ዋጭመኬ ቤርምካ የጀኬ፥ ኮታ ቡር ጳውሎስኬ ባርናባሰካ አንጾክያ ካተመናር ዶቅድባብ አብንከስ ቶክም እስመንከስካ ክክን ማትሶ የሩሳሌም ካተመናር አይድንግንደኬ ሪንም ኦይትምስባብከስካንተኬ ጋልተንከስካንታ ኬዝድንግንዳ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ኮካንታ ከታ ምክስ ኤሄናርንካ ክትምሰኮ አይሰኬ፥ ፍንቃ ፍጨናርኬ ሳማራ ካተመናር ከት ስገድንከረ አይሁድ ማታክባብከስ ሳብደር ከታ ማትንተን ኬዘኬ፥ ኮነረ ኬዘና አሜንድባብከስም ሙዳ ጉርምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","የሩሳሌም ካተመናር ከታ ይ የልሳንደትካ ምክስ ኤሄናር ኤድንከስኬ ኦይትምስባብከስ፥ ጋልተንከሰረ ከትም ሞክሰኬ፥ ክትምስባብከሰረ ሳብ ከትካ ክክን ማትሶ ይሳንደትም ሙዳ ከትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ኬዛር ማቼ ፈረሳዊያንንከስታ ኮች ማችባብ ዋልቃ ዋልቃ አሜንድባብከስ አምሰኮ “አይሁድ ማታክባብከስ ሶለን ተቸርድንግንደኬ ሙሴታ ህግንም ካርዝድንግንዳ ይይ ዝግዝዴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ኦይትምስባብከስኬ ጋልተንከስ ኮ ኬዘንጎካ ዞርምካንታ ሳንምሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","በድ ከት በርምሳን ቡር ጴጥሮስ አምሶ፥ “እስመንከሶ፥ አይሁድ ማታክባብከስ እጎካ ክላ ኬዘንታ ቃለን ኤሰርሰኮ ከት አሜንድንግንዳ ኮታ ኤና እር ሳብ እም የንታ ዎክያርንካ እጃንደትም የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ኤታ ቡደን ኤዝድባብ ሳብ፥ አያን ጭልን ዎካንታ እምሳንግንዳ ከትካንተረ እምንተካ ይንታ ከትም ማስካ ማርከርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ከታ ቡደንም አሜንካ ይ ጭልሳንካንታ ዎንተኬ ከተካ ዎክያር Ꮊረሰነረ ፋስም ዶቃባብ ይያክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ይና፥ ዎንታ ባቤንከሰረ ማታ ዎተረ ዎ ባላካንታ ማታክንደትም ቃምበርንም አሜንድባብከስታ ቁመዘን ባልስካ Ꮊረተረ ታ ሳብም የ ጰጭድንዳ? ");
INSERT INTO gyl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ዎተረ ዎ አቅድንዳ ገታ ከትግንዳ ጮይስ የሱሰታ ዉች እምንተንካ ማትንተን አሜንዶቴ” ኩን ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ኮትኮᎺይካ ሳንምስባብከስ ጫምን ጋይሰኮ ባርናባሰከ ጳውሎስካ ከታ ጎግካ ሳብ አይሁድ ማታክባብከስታ ዎክያር ይሳንደትም አተንምኬ በርእስዝድን ርን ሙዳ ከት ኬዝድንካ ኤቦ ጋየረኮ ኤሰርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ከት ከዝት በይሳን ቡር፥ ያይቆብ፥ “እስመንከሶ! እዝደር ኤሰርከቴ! ");
INSERT INTO gyl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ሳብ ዋልቃ ይንታ ላምንካ ኤልድን ዎርሰንም ከታ ዎክያርንካ እድካንታ እርምሶ አይሁድ ማታክባብም Ꮊስግንዳ ሰዳናንከረ ስምኦን ዎንታ ቡዳር አርድንግንዳ ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ኮ ገቀርንከረ ክክን ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ቃለና ኤእዴ፥ ኮነረ ኩንጋይሶ ጻፍምሳንግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ሳብ ጋይድዮ፥ ኮታ ቡር እታ ማድቴ፥ ዋቻን ዳውትታ ኤሄንም ዎድቴ፥ ዉልእምስባብከስመረ ጳጭስቶ አናካርንካ ዎይዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ኮመረ እ ይድንዳ ነገዳን ኤድንከስኬ እስታ ላምንካ ኤልምስባብ አይሁድ ማታክባብከስ ሙደና እ ጮይስም ከት ዝግተርንግንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ኤንንደትዘንካ የድሶ ከነም ሙዳ ኤስምስባብ እታ ጮይስ ኩን ጋይድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“ኮካንታ እስታ ገቅርና ሳብደር ማድባብ አይሁድ ማታክባብከስም ዎ ማእስተራክንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ስግስሶ ‘ጮይስ ማታክባብካንታ ካስምሳንጎካ ቱና ማቻን እችምን Ꮊይ እቸቴ፥ ቤልምዘንካ ጎተርከቴ፥ ባር ተችማክንደትምኬ ማቀሰረ ዉልእማክናና ጉንእምት ደእሳን መሄንታ ዋሄንም Ꮊይ እቸቴ፥ ማቀሰረ Ꮊይ እቸቴ’ ጋይሶቶ ዎ ከትካንታ ጻፋ። ");
INSERT INTO gyl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ኤና እርንደትዘንከረ የድሶ ሙሴታ ህግና አይሁድንታ Ꮊዉስ ሰጨንካ ከታ ምክስ ኤሄናር ናበብምድ Ꮊቄ፥ ቃለነረ ካተመንከሳር ሳባክምሴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ኮታ ቡር ኦይትምስባብከስ፥ ጋልተንከስኬ ምክስ ኤሄናር ኤድንከስካ ክክን ማትሰኮ ሳንምሳን ዎርሰንታ ዎክያርንካ ቶክም ኤድንከስም እድሶ ጳውሎስኬ ባርናባሰካ ክክን አንጾክያ ካተመናር ኦይትካንታ ጋይሰኬ፥ ኮካንታ አመንድባብከስታ ዎክያር ጎርስካ ኡርማ ላም ዶቅድባብከስም በርሳባስ ጋይምድባብ ይሁደምኬ ስላስምካ እጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ጻፍምሳን ክተን ኬታ አንካ ኦይቸኬ፥ ጻፍምሳን ክተነረ፥ “ዎታ የንታ እስመንከስ ኦይትምስባብከስከ ጋልተንከስ አንጾክያ ካተመናርንከ ሶርያ ፍጨናር፥ ኪልቅያ ፍጨናረረ የ ዶቅድባብካንታ አይሁድ ማታክን ኮችንከሳርንካ የ ማችባብ ዎንታ እስመንከስምኬ ምችነንከስም አቦ ጋይዶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ዎንታ ዎክያርንካ ዋልቃ ዋልቃ ኤድንከስ ዎከትም ክታክናና የንደር Ꮊድሰኮ የካንታ ከት ኬዛን ቃለንካ የም ከት ዘርሳንግንደኬ የም ዳንድምሳንደትም ኤሰርቶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ኮካንታ የካ ማትሶቶ ዎ ሳንምሳንደታ ቡር ክተንም ተይሶ አይድባብከስም እድሶቶ ሶልምምስባብ ዎንታ እስመንከስ ባርናባሰከ ጳውሎሰካ ክክን ከትም የንደር ኦይትካንታ ዎታ ኤእቶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ባርናባሰኬ ጳውሎስካ ዎንታ ጮይስን የሱስ ክርስቶስታ ላምንካንታ ከታ ይንታ ሰንፔንም ስክስት እምስባበኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","የካንታ ዎ ጻፍሳንደትም አፌከረ ጉጅሶ ኬዝድንግንዳ ይሁደምንኬ ስላስምካ ኦይቶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ከትኬና ዝግዝድን ሪንከዘንካ አብ ደጭድን ባላ የንዘን ዎ ባልዝዳክንግንዳ አያን ጭልንኬ ዎንካ ኡርማ ማችንካ ሰቶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ጮይስ ማታክን ሪንካንታ ካስምሳንጎካ ቱና ማቻን እችምን Ꮊይ እቼቴ፥ ጉንእምሶ ደእሳን መሄንታ ዋሄንም Ꮊይ እቸቴ፥ ማቀሰረ Ꮊይ እቸቴ፥ ቤልምዘንካ ጎተርከቴ፥ ከትኬና ሪንከዘንካ ሙዳ የ ካርስምሰ ኡርመንም ይደቴ፥ ኡርማ ዶእከቴ” ኩን ጋይድንዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ክተንም ተይሶ Ꮊድባብከሰረ ኡርማ ዶእከቴ ጋይንደትከ ኦስ አንጾክያ ካተመናር አይሰኬ፥ አመንድባብከስመረ ሳንስሶ ጻፍምሶ Ꮊዳንደትም ከትካንታ እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","አሜንድባብከሰረ ጻፍምሳንደትም ናበብሰኮ ዳቅዝድን ክታ ማትንተንካ አንድር ከትም ጉርምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ይሁደከ ስላስካ ሳብዘንካ ኤሰርሶ ኬዛቅባብ ማቻንካንታ እስመንከስምከ ምችነንከስም በድ ቃለካ ዞርሰኮ ዳቅሰኬ፥ አነረ ዛፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ይሁደከ ስላሰካ ቶክም ሰጫ ኮታር ዶቅሳን ቡር አሜንድን እስመንከስምኬ ምችነንከስካ ክክን አቦ ኡርማ ዶእከቴ ጋይንደትኬ ከትም ኦይችባብከዝደር ማትሰኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(ስላስ ማቼ ኮታር ነግካንታ ዝግዜ)። ");
INSERT INTO gyl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ጳውሎስኬ ባርናባሰከረ አብንከስ በድ አሜንድባብከስካ ክክን ማትሶ ጮይስታ ቃለን ኤስሰረኮ፥ ሳባከሮ ቶክም ሰጫ አንጾክያ ካተመናር ዶቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ቶክም ሰጨታ ቡር ጳውሎስ ባርናባሰም “ኮሬ ዎታ ማትሶቶ ኮታ ኤና እሪ ጮይስታ ቃለን ዎ ኤስምሳን ካተመንከሳር ሙዳ ዶቅድባብ እስመንከስምኬ ምችነንከስም ዎ ሰዳ፥ Ꮊስግንዳ ከት ዶቅዳናንከረ ዎ ከተን ኤሳ” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ባርናባሰረ ማርቆስ ጋይምስባብ ዮሀንስ ከትካ ክክን የካ አይድንግንዳ ዝግዜ። ");
INSERT INTO gyl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ጳውሎስ ማቼ ኮና ኤችና ከትካ ክክን አይድንግንዳ ጋያክዬ፥ ክትም ክት አይዳክንግንዳ ጋይሳንደረ ኖ ጵንፍላ ፍጨናር ከታዘንካ ፋስምሶ ክት ነገዳንካንተከ ፍክስካንተረ ከትካ ክክን አያክንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ኮጎካ ጳውሎሰተኬ ባርናባሰታ ዎክያር ደጫንዳ ቤርም አምስንካ ፋስምሰኬ፥ ኮካንታ ባርናባስ ማርቆሰም የድሶ ሎቀንዘንካ ቃልዝድን ማርከብንካ ሎቀንታ ግድናር ዶቅድን ቆጵሮስ ደንንዘን አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ጳውሎስ ማቼ ስላስም እጄ፥ እስመንከስኬ ምችነንከሰረ ጳውሎሰም ጮይስታ ዉች እምንተንካንታ ዋደ ጋይሰኮ ክትም እምሳንደታ ቡር ኖ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ኖየረ Ꮊክ Ꮊክ ምክስ ኤሄናር አሜንድባብከስም ዛብሰሮ ሶርያ ፍጨናርከ ኪልቅያ ፍጨናርጎካ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ጳውሎስ ኦስ ደርቤ ካተመኬ ልስጥራ ካተመናር አይሴ፥ ጢማቶስ ጋይምድባብ አሜንድን ኤች Ꮊቄ፥ ክታ እንደና አይሁድ ማትሶ አሜንድንዳ Ꮊቄ፥ ባቼና ማቸ ግርክ ኤድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ጢማቶስ ልስጥራ ካተመናርኬ እቆንዮን ፍጨናር ዶቅድን አሜንድባብከዝደር ኡርማ ላም ክታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ጳውሎስ ጢማቶሰም ይንካ ክክን አይድንግንዳ ይዝግዛንካንታ ካርንኮታር Ꮊቅባብ አይሁድንከስጎካ ሶለን ተቸርድንግንዳ ክትም ይሴ፥ ኮመረ ክት ይሳንዳ ከታ ጢማቶስታ ባቤና ግርክ ኤድ ማትንተን ኤዝደኮ ከት Ꮊቃንጎካ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ጳውሎስኬ ስላስካ ካተመንከሳር ከት ስገድንካ የሩሳሌም ካተመናር ዶቅድን ኦይትምስባብከስኬ ጋልተንከስ ከት ጋይሳን ዎገን አሜንድባብከስካንታ ኤስምዝድ Ꮊቀኬ፥ ፍክስዘነረ Ꮊቅዝድንግንዳ ከትም ገቀርዝድ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ኮካንታ Ꮊክ Ꮊክ ምክስ ኤሄናር አሜንድባብከስ አሜንካ ዛብዘኬ፥ ከታ ፋይደነረ ሰጨንካ ሰጨንካ ጉጅመሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ጳውሎስከ ስላስካ እስያ ፍጨናር ቃለንም ከት ኬዝዳክንግንዳ አያን ጭልና ከትም ማርሳንጎካ ፍርግያ ፍጨናርኬ ገላትያ ፍጨናርጎካ አይሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ኦስ ምስያ ፍጨንታ ገረንዘን ከት የልሳንደትካ ኦስ ብታንያ ፍጨናር አይካንታ ገቀርሰኬ፥ ኬዛር ማቼ የሱሰታ አያንና ኦኮታር ከት አይድንግንዳ ጋያክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ኮካንታ ምስያ ፍጨናርጎካ ስግሰኮ ጥሮአዳ ካተመናር Ꮊንቸርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ኮታር ሶይት ዋልቃ መቅዶንያ ፍጫ ኤች ዎእሶ “መቅዶናር ቃልሰዮ ዎም አለን አልካ!” ጋየሮ ክትም ምግዝድንካ ጳውሎስ ለምለም ጋይድንካ ሰዴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ጳውሎስ ኮም ለምለም ጋይድንካ ይ ሰዳንደታ ቡር ሳነካ ኦስ መቅዶንያ ፍጨናር አይካንታ ዝግዞቴ፥ ኮነረ ማቻንዳ መቅዶንያ ኤድንከስካንተረ ክላ ኬዘንም ዎ ሳባግድንግንዳ ጮይስ ዎም ኤልሳንደትም ዎ ኤሳንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ጥሮአዳ ፍጨናርንካ ሎቀንዘንካ ቃልዝድን ማርከብናር አርድሶቶ ገታ ኦስ ሳሞትራቄ ጋይምድን ሎቀንታ ዎክያር ዶቅድን ደንንዘን አይሶቴ፥ ዛማክንከረ ኦስ ናጱሌ ካተመናር አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ኮታርከረ አምሶቶ ኦስ ፍልጵስዮስ ካተመናር የልሶቴ፥ ፍልጵስዮስ መቅዶናር Ꮊፈርድንዳ አንድር ካተመኬ ሮማ ኤድንከስ ገችዝድን ካተማ Ꮊቄ፥ ኮትኮ ካተመናር ቶክም ሰጨንከስም ኮታር ስግሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","አይሁድንታ Ꮊዉስ ሰጨንካ ምክስካንታ ከት ሳንምድ Ꮊቃን ካተመንዘንካ ኦስ Ꮊፈርድን ሎቀንታ ካንታር አይሶቴ፥ ዋረረ ዶቅሶቶ ካርንኮታር ሳንምስባብ ማነንከስካንታ ሳብታ ቃለንም ከዞቴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ዎንደር ኤሰርድ Ꮊቅባብ ማነንከሳርንካ ዋልቀንዳ ትያጥሮን ካተማር አጥምሳንዳ ጩላ አፍለታ ክር ዛለን ዛልድንዳ፥ ልድያ ጋይምድንዳ ኤተን Ꮊቄ፥ ናየረ ሳብም ጎይንድንዳ ኤተን Ꮊቄ፥ ጮይሰረ ኮታ ቡደንም ፎቻንካንታ ጳውሎስ ኬዝድን ቃለን ኤሰርድ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ኮትከ ኮታ ኤር ዶቅድን ኤድንከስ ሙዳ አሜንንታ ስእርን ስኤርሳንደታ ቡር፥ “ጮይስያር እ አመንድንዳ ማትንተን መያ እካንታ የ ማስሳንካ እስታ ኤር አርድሰቶ ዶእከቴ” ጋየሮ ዳቅስሶ ና ዎም ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ዋልቃሰጭ ምክስ ካርናር ዎአይድንካ ኦስ እሪ ይምድርም ቤርስካ ከስዝድንዳ ቱና አያን ኮታዘን ዶቅድንዳ ዋልቃ ፍክስንዳ ይንቼን አንጃ ጎግዘን ዎም Ꮊፍሴ፥ ናኮና ይንቼና ይንታ ቤርስንካ ይም ገችዝድባብከስካንታ በድ ርም ስጥመካ Ꮊፍስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ናየረ ጳውሎስምንከ ዎመረ ጎርስመሮ፥ “ኬና ኤድንከስ ሙደንዘንካ ስግ ሳብንታ ፍክስንባብከሰኬ! ከታ አቅንተታ ጎግን የካንታ ከዝተረኬ!” ጋየሮ ና ፍብድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ኮመረ በድ ሰጫ ና ይድ Ꮊቄ፥ ጳውሎስ ማቼ ሳነካ ዋልን ጋይሶ ቱና አያንን “የሱስ ክርስቶስታ ላምንካ ኮታዘንካ የስ ዉድንግንዳ የስም ክድቴ!” ጋይሴ። ቱና አያንነረ ሳነካ ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ኮትም ገችዝድባብከስ መይድር ከት Ꮊብድን ጉርምና ከታዘንካ ነገዳንደትም ሰድሰኮ ጳውሎስምንኬ ስላሰም የጀኬ፥ ከትም ጎቸረኮ ኤድ ሳንምድን መለንዘን ተይ አይሶ ዶርምስባብከስታ እሪ ከትም ዎይስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ሮመንከስታ ገችታ ኤረንባብከዝደር ከትም ተይᎺድሰኮ፥ “ኬና ኤድንከስ አይሁድንከስታ ኮቸኬ፥ ዎንታ ካተመናረረ አዉል አምስዝደከ፥ ");
INSERT INTO gyl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ዎታ ሮማ ኤድንከስ ዎተይዳክንደትም አነረ ዎ ይድንግንዳ ጋይማክንደትም ዎገን ኤስዝደኬ” ኩን ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ዎርሰነረ ሙዳ ዋልቃትቼካ ማትሰኮ ከታዘን አምሰኬ። ገችንባብከሰረ ጳውሎስተኬ ስላስታ አፍለን ዉችሰኮ ጉፈካ ከትም ጉጵድንግንዳ ክትሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","በድ ከት ጉጰርሳንደታ ቡር ዞክና ኤሄናር አርችሰኬ፥ ዞክና ኤሄንም ካርዝድባብና ኡርስት ከትም ካርዝድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ካርስንባብና ኮም ክተን ይ ተያንደታ ቡር፥ ዞክና ኤሄንታ ዋርጎካ ካርናር ከትም አርችሴ፥ ከታ ዱትንመረ Ꮊቃ ቅረርሳን ዛምበንታ ዎክያር የችሶ ዞክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ሶይት ገልትገር ማድንካ ጳውሎስከ ስላሰካ ምክስከ የቺካ ሳብመረ ጋለድ Ꮊቀኬ፥ አብንከሰረ ዞከርስባብ ከትም ኤሰርድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ከት ገቀራክናና ዞክና ኤሄንታ የድና ሶይተርን የለልታ አንድር ፍጨና ሶይ የጄ፥ ፉልተንከሰረ ሙዳ ዋልቃዱት ፎችምሰኬ፥ ዞከርስባብ ሙደንተረ ሳንችለትና ብልምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ካርስንባብና ይንታ ግንእናርንካ ክት ንግድንካ ዞክና ኤሄንታ ፍልተንከስ ፎችምሳንደትም ይ ሰዳንደትካ ዞከርስባብከስ ክታዘንካ ሱርትሶ አይተም ካምስንካ ይንታ ማተንም ደይሳካንታ ማሰንም ጎቼ። ");
INSERT INTO gyl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ኬዛር ማቼ ጳውሎስ፥ “ዎታ ሙደና ኮር ዶቅዶቴ! ኮካንታ የስታዘን ኡፈልዝድንደትም Ꮊይ የልሴ!” ጋይሶ አንድር ኡፍስካ ፍፍሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ኮትካ ካርስንባብና ዞጳ ተይᎺድሶ ዞደሮ ዞክና ኤሄናር አርደዴ፥ ጭጨረረ ጳውሎስተከ ስላስተካ ዱትዘን ይንታ ባለንካ ጉፕን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ኦስ ማለረ ከትም ዉችሶ “የ ዎባብከሶ! አቅንታካንታ Ꮊራ እም ይይዝግዝዳ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ከተረ “ጮይስ የሱሰካ አሜንካ፥ የና አቅተራዬ፥ የስታ ኤሀ ኤድንከሰረ አቅተረኬ” ክትካንታ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ጮይስታ ቃለንመረ ክትካንተከ ክታ ኤር ዶቅድባብ ሙደንካንተረ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ኮት ሳዓትንከረ ሶይት ዞክና ኤሄንታ ካርስንባብ ተይከትም አይሶ ድድንም ከታ ስእሴ፥ ሳነካ ክትኬ ክታ ኤሀ ኤድንኬ ሙዳ አመንንከስታ ስእርን ስኤርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ኮታ ቡር ጳውሎስምንኬ ስላስም ይንታ ኤር ተይ አይሶ እችም ከትካንታ እምሴ፥ ሳብከረ አመንሳንጎካ ይንታ ኤሀ ኤድን ሙደንካ ክክን ክትም ጉርምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ፍጨና ሰጭንካ ገችንታ ኤረንባብከስ “ከታኬና ኤድንከስ ኦይትማ” ጋይሰኮ ዳምንባብከስም ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ዞክና ኤሄንታ ካርስንባበረ “የ ቡልምተርንግንዳ ገችንታ ኤረንባብከስ ኤድም ኦይተከ፥ ይና ዉትሰቶ ኡርመካ አይከቴ” ጋየሮ ጳውሎስካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ጳውሎስ ማቼ “ዎታ ሮመታ ኤድንከስ ዎማድንካ ፍርድካይሳ ዎርሳ ሳንምድን መለንዘን Ꮊርድሰኮ ዞክናኤሀር ዎም አርችተኬ። ታ ጉጅሶ ዞክና ኤሄናርንካ አጥምካ ዎ ዉድንግንዳ ይደኮ? ኮና ማታዬ! ከታ ይንታ ማታርንካ Ꮊድሰኮ ዎም ዉቻ!” ጋይሶ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ፖልስንከሰረ ኮም ርን ገችንታ ኤረንባብከስካንታ ኬዘኬ፥ ገችንታ ኤረንባብከሰረ ጳውሎስኬ ስላስካ ሮማ ኤድንከስ ከታ ማትንተን ከታ ይ ኤሳንደትካ ጳሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ኮካንታ Ꮊድሰኮ ነጋዎም ጋይከቴ ጋይሰኮ ከትም ኦይስንደትከ ዞክና ኤሄናርንካ ከትም ዉችሴ፥ ካተመናርንከረ ከት አይድንግንዳ ከትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ጳውሎስኬ ስላስካ ዞክና ኤሄናርንካ ዉትሰኮ ኤተን ልድየታ ኤር አርደደኬ፥ ኮታረረ አመንድባብከስም Ꮊፍሶ፥ ከትም ዳቅስንደትኬ ካተመናርንካ ዉትሶ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ጳውሎስኬ ስላስካ አንፍጶልሳ ካተማጎኬ አጶሎንያ ካተማ ጎካ ስግሶ ኦስ ተስሎንቃ ካተመናር አይሰኬ፥ ኮታረረ አይሁድንታ ምክስ ኤሀ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ጳውሎስ ይንታ መጠንግንዳ አይሁድንታ ምክስ ኤሄናር አርደዴ፥ ማከን አይሁድንታ Ꮊዉስ ሰጨንካ ጭል ማጻፍንከሳርንካ አምስሶ ኬዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ክርስቶስ ማጣ ተይኬ ደእያርንካ አም ክትም ዝግዝድንደትም መያ ማስካ ኬዝት ቡዳር ከታ አርቼሮ “ኮና እታ የካንታ እ ኤስምስዝድባብ የሱስ ክርስቶስዬ” ጋየሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ኮካንታ ከታርንካ ዋልቃ ዋልቀንከስ ቃለንም ማለካ ይንታ ቡዳር አርችሶ ጳውሎስኬ ስላሰካ ክክን የካ ማቼኬ፥ ኮትኮግንደረ ሳብም ጎይነረኮ አንድር በድ ግርክ ኤድንከስኬ ካተመናር ኤስምስባብከስ በድ ማነንከስ ቃለና ዶፈን ማቻንደትም ተይሰኮ ከትካ የካ ማቸከ። ");
INSERT INTO gyl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","አይሁድና ማቼ ቀምስምሶ ኬዝካ ባቻኦግድባብ ፍክስ ካየንባብከስም ጎግንከዘንካ ሳንስሰኮ ከታዘን አምስሰኬ። ካተመንታ ዋረረ ዋጭማ አምድንግንዳ ይሰኬ፥ ጳውሎስምኬ ስላስም ዉችሰኮ ዎርሰንካንታ እምካንተረ እያሶነታ ኤሄንታ ፉልተን ቁንጭሶ አርደደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ኬዛር ማቼ ከትም ከታ ይ Ꮊፋክንካንታ እያስንምንኬ ዋልቃ ዋልቃ አሜንድባብከስም ካተመናር ገችንታ ኤረንባብከስካንታ እምካንታ ከትም ጎቸሮ ተይ አይሰኬ፥ ኩነረ ጋየሮ ፍፈሮ Ꮊቀኬ፥ “ከናከስ ፍጫ ሙደን አዉልስባብ ኤድንከስ ታ ጉጅሶ ኮር Ꮊተኬ! ");
INSERT INTO gyl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","እያሶነረ ከትም ሞክቴ፥ ‘የሱስ ጋይምድባብ አብ ባንች ዶቅዴ’ ጋየረኮ ሮማ ባንችንታ ክተን ግርደኬ።” ");
INSERT INTO gyl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ዎርሰንኬ ካተመንታ ገችንታ ኤረንባብከስ ኮም ኤሰርሳንደትካ ኦይምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","እያሶንምንኬ አብንከስመረ ዋሳ ኤልስሶ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","አሜንድባብከስ ሳነካ ጳውሎሰምኬ ስላሰም ሶይትንካ ኦስ ቤርያ ካተመናር ከት አይድንግንዳ ይሰኬ፥ ኮታረረ ከታ ይ የልሳንደትካ አይሁድንታ ምክስ ኤሄናር አርደደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ቤርያ ካተመናር ዶቅድባብ አይሁድና ተስሎንቃር ዶቅድባብዘንካ ስግ ኡርማ ገቀር ዶቅድባብከስ ማቻንካንታ ቃለንም አንድር አግርካ ተየኬ፥ ቃለንተረ ዶፈንንም መያ ማስካንታ ሰጫ ሰጨንካ ጭል ማጻፍንከስታ ዋር ማስት ማስት ሰድᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ኮካንታ ከታርንካ በድንከስ አመንሰኬ፥ አነረ ግርክ ፍጨናር ቆልመካ ዶቅድባብ ማነንከስከ በድ አⷝነንከሰረ አመንሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ኬዛር ማቼ ተስሎንቃር ዶቅድባብ አይሁድና ጳውሎስ ቤርያ ካተመናረረ ሳብታ ቃለንም ክት ኤስምሳንደትም ከታ ይ ኤሳንደትካ ኮታር Ꮊድሰኮ ዎርሰንም ዙዝምስሶ ዋጭመም አምስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ኮታይካ አሜንድባብከስ ሳነካ ጳውሎስ ባሀርንታ ላማር ክት አይድንግንዳ ይሰኬ፥ ስላስኬ ጢማቶስካ ማቼ ቤርያ ካተመን ኮታር ነገደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ጳውሎስም ጎግን ስክስባብ ኤድንከስ አተና ካተማ የለልታ ክትም የልስሰኬ “ስላስኬ ጢማቶሰካ ጋምአክዶቆ ሳነካ እዝደር ከት Ꮊዳ” ጋይድንደትመረ ጳውሎስታ ክተን የድሰኮ ኦስ ቤርያ ካተመናር ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ጳውሎስ አተና ካተመናር ማትሶ ስላስምንኬ ጢማቶሰም ካርሰሮ ክት ዶቅድንካ ካተመናር ጮይስ ማዳክን ጎይንካ ጮጫንደትም ሰዳንደትካ ይንታ አያንካ ማጠርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ኮካንታ አይሁድንታ ምክስ ኤሄናር አይሁድንኬ ሳብም ጎይንድን ኤድንከስካ ክክን ዎርሳ ሳንምድን መሌንዘነረ ሰጫ ሰጨንካ ይ Ꮊብድን ኤድንከስካ ክክን ከዝምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ኤፒኮሮሶንከስኬ እስቶይኮ ጋይምስባብከስ ኤጫ ዶቅድባብከስ ክደር Ꮊደረኮ ቤርምድ Ꮊቀኬ። ዋልቃ ዋልቀንከስ “ኮና አፈርድባብና Ꮊራ ጋይካንትክ ዝግዳ?” ጋየሮ፥ አብንከስካንታ ጉጅሶ “ክላ አብ ጮይስንከስካንታ ኬዝድባብም ካምዴ” ጋየሮ Ꮊቀኬ፥ ኮመረ ከት ጋይካንታ ማቻንዳ ጳውሎስ የሱሰትንደትምኬ ክታ ደእያርንካ አምንተንታ ኡርማ ኬዘንም ኤስምሳን ኦሌ። ");
INSERT INTO gyl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ኮካንታ ጳውሎስም የድሶ አርዮስፋጎስ ጋይምሳን ዎርሰን ሳንምድን መሌንዘን ተይᎺድሰኮ ኩን ጋይሰኬ፥ “ኮና የስ ኤስዝድንዳ ክላ ኤስና Ꮊራ ኮት ማቸረ ዎታ ኤስካንታ ማዶቶ? ");
INSERT INTO gyl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ዋልቃ ዋልቃ ሶች ሪንከስም ዎካንታ ኤስምስተዬ፥ ኮካንታ ኬና ርንከስ Ꮊራ ከት ማቸረ ዎታ ኤስካንታ ዝግዶቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ኮመረ ከት ጋይሳንዳ አተና ካተመናር ዶቅድባብከስከ አቴነታ ዋር ዶቅድባብ አብ ፍጫርንክንባብ ኤድንከስ ሙዳ ክላ ር ኬዘኬ ኤስርካ Ꮊክ ይንታ ሰጨንም ስክስ ሶልምድ ከት Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ኮታይካ ጳውሎስ አርዮስፋጎሳር ሳንሳን ዎርሰንታ እር ዎእሶ ኩን ጋይሴ፥ የታ አተና ኤድንከሶ! ሙዳ ጎከረ ጎይንድባብከስ የንታ ማትንተን እታ ሰዳተ፥ ");
INSERT INTO gyl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","የንታ ካተመናር ኦንገርቶ የ ጎይንድን ካርንከስም እ ሰድንካ ኤስምዳክን ሳብካንታ ጋይምሶ ጻፍምሳንደትም ካስ ካሪ Ꮊፍስቴ፥ ይና እታ ታ የም እ ኬዝድንዳ ኮ ኤሳከትዶቆ የ ጎይንድን ሳብጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ኖ ፍጫ ሙደንኬ ፍጫሙደንዘን ዶቅድንደትመረ ሙዳ ፍዝባበ፥ ጭለተከ ፍጨተካ ጮይስዬ፥ ኖ ኤታ አንካ ዎድምሳን ሳብታ ጭል ኤሄ ጋይምሳንደታር ዶቃዬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ዶቅንተንምኬ ሰንፔንም፥ አብ ሪንከስም ኤድ ሙደንካንታ እምድባብ ክት ማቻንካንታ Ꮊረርየረ ክትም ዞገራዬ፥ ኤታ አሌረ ክትም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ኖ ኤታ ሱሰም ሙዳ ዋልቃ ኤድዘንካ ፍዜ፥ ፍጫሙደንዘን ከትዶቅድንግንዳ ይሴ፥ ከትካንታ ጋይምሳን ስለንከስምኬ ከትዶቅድን ካርንከስመረ ካሴ። ");
INSERT INTO gyl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ኮመረ ክት ይሳንዳ ኤድንከስ ሳብም ከት ዝግድንግንደከ ካርንካ ማስሶ ሰድንትካ ዝግሰኮ ክትም ከት Ꮊብድንግንዴ፥ ማችንከረ ኖ ዎ ዋልቃ ዋልቀንዘንካ ጎት ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ሰንፔም ዎ Ꮊብድንደትኬ ዎ ሶይድንደረ፥ ዎ ዶቅድንደረ ክትኬ፥ ኮነረ የንታ ዋርንካ ሳችንባብከስ ዎታ ሙደና ክታ ይንቾቴ ጋይሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","ይና ዎታ ክታ ይንች ዎ ማቼ ሳብ ኤታ ኤጨኬ ገቅርካ ዎርቀካ አነረ ጋይካ አነረ ሰይንካ ፍክስምሳንደትም ካምዴ ጋይሶቶ ገቅር ዎም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ይና ኤድንከስ ኤና ስለናር ኤሳከክ ዶቆ ከት ይሳንደትም ሳብ ጫምን ጋይሶ ስክስተ፥ ታ ማቼ ፍጫ ሙደናር ዶቅድን ኤድንከስ ሙዳ ጎማ ይንታ ፍክስን ከት ዎይዝድንግንዳ ክቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ኖ ይ እጅባብ ኤድንጎካ ፍጫሙደንዘን ዶፈንካ ይ ፋረድን ሰጨንም ጫትሳ ከስቴ፥ ኮትኮመረ ሙደንካንታ መያ ማስሳንዳ ክትኮም ይ እጅባብ ኤችን ደእናርንካ ይንታ አምስንኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","“ደእናርንካ አም” ጋይድንደትም ቃለን ከታ ይ ኤሰርሳንደትካ ዋልቃ ዋልቀንከስ ክታዘን Ꮊልተርሰኬ፥ አብንከስ ማቼ “ኮሪንጎካ አብ ሰጫᎺይካ የስ ኬዝድንካ ዎታ ኤሰርተሮቴ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ኮታ ቡር ጳውሎስ ዎርሰናርንካ ዉትሶ አይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ዋልቃ ዋልቃ ኤድንከስ ማቼ ክትካ ክክን የካ ማትሰኮ ክታ ኤስስንካ አመንሰኬ፥ አሜንስባብ ኤድንከስታ ዎክያርንከረ አሮስፋጎሳር ሳንሳን ዎርሰንታ ዋርንካ ማችባብ ዋልቀና ድዮናስ ጋይምስባብ ኤችኬ ደማርስ ጋይምሳንዳ ዋልቃ ኤተን፥ አነረ አብንከሰረ Ꮊፈርደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ኮታ ቡር ጳውሎስ አተና ካተመንካ አምሶ ቆርንቶስ ካተማር አይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ኮታር ጳንጦስ ፍጨናር አጥምስባብ ኤች አቅላ ጋይምድባብም ዋልቃ አይሁድ ኤችም Ꮊፍሴ፥ ሮመታ ባንችን ቃለዉዶስ አይሁድ ሙደና ሮማርንካ ከት ዉድንግንዳ ክትሶ Ꮊቃንጎካ አቅላ ይንታ ኬነን ጵርስቅለካ ክክን እጣለንካ አክ ኖ Ꮊዳ ዶቆ፥ ኮካንታ ጳውሎስ ከደር አይሶ ከትካ ኤስምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ክታ ፍክስና ገታ ከትግንዳ ዱንካንም ዛግድ Ꮊቃንካንታ ከትካ ክክን ዶቅሶ ፍግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","አይሁድንታ Ꮊዉስ ሰጨንከረ ምክስ ኤሄናር Ꮊፍረረኮ ከደር ኬዘሮ አይሁድንከስካንተከ ግርክ ኤድንካንታ ከት ማለካ ኤዝድንግንዳ ከዛቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ስላስኬ ጢማቶስ መቅዶና ፍጫርንካ ከት Ꮊዳንደትካ ጳውሎስ “የሱስ ክርስቶስዬ” ጋይንተካ አይሁድንካንታ ዳቅንተካ ማርከረሮ ኤስስካ ሰጨንም ሙዳ ስግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ኬዛር ማቼ አይሁድንከስ ክትም ግርሰኮ የክሳንደትካ ከትካንታ ኤግዝምስ ማድንግንዳ አፍለንታ ቡልን ድክችሶ “ይና እ የንዘን ፋረዴ የንታ ማታ ባችኬ! እም ኦይስዝድንዳ ካዬ፥ ይና ኮዘንካ ፈንክ አይሁድ ማታክባብከዝደር አይድቴ!” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ኮካንታ ከታዘንካ ፋስምሶ ትቶስ እዮስጦስ ጋይምስባብ ኤችታ ኤር አይሴ፥ ኮና ኤችና ሳብም ጎይንድባብ Ꮊቄ፥ ክታ ኤሄነረ አይሁድንታ ምክስ ኤሄንታ ላማር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ቃረስጶስ ጋይምድባብ አይሁድንታ ምክስ ኤሄንታ ገችንባብ ይንታ ኤሀ ኤድንካ ሙዳ ክክን ጮይስካ አመንሰኬ፥ በድ ቆርንቶስ ኤድንከሰረ ጳውሎስ ኬዝድንካ ኤስርሶ አሜንሰኮ ስኤርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ጮይሰረ ጳውሎሰም ሶይት ለምለም ጋይድንካ ኩን ክትም ጋይሴ፥ “Ꮊይ ጳሴ፥ ከስካ፥ ጫምን Ꮊይ ጋዬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","እታ የስካ ክክንቴ፥ ኮካተመናር በድ ኤድንከስ እስታ ዶቅደኬ የዘን ኡፈልዝድ ር የልስካንታ ማድባብ Ꮊየነረ ካዬ”። ");
INSERT INTO gyl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ኮካንታ ጳውሎስ ሳብታ ቃለንም ዎርሰንካንታ ኤስሰሮ ዋልቃ ስለኬ ባንግካ ኮታር ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ጋልዮስ አካያ ፍጨን ቆልድባብ ማትሶ ዶርምሳንᎺይካ አይሁድንከስ ዋልቃ የካ ማትሰኮ ጳውሎስዘን አምሰኬ፥ ኦስ ፍርድ እምድባብከዝደር ተይ አይሰኮ፥ ");
INSERT INTO gyl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ኮና ኤችና ሙሴታ ህግንም ኤድንከስ ግርሶ ሳብም ጎይንድንግንዳ ይዴ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ጳውሎስ ከታ ኬዘንታ ማስካንታ ግግምሶ ዶቅድንካ ጋልዮስ አይሁድንከስም ኩን ጋይሴ፥ “የታ አይሁድንከስታ ኮችንከሶ! ዳቀልስ አነረ ደጭድን ባች የንዘን ቦድምተስናና የንታ ክስንም ዳንዳእካ ኤሰርድት ዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ኬዛር ማቼ የንታ አፋርንካ ከዘንጎኬ ላምንከስጎካ የንታ ህግንጎከረ የ በርምድንዳ ማቼ የንታ ማታ የጎካ በይስከቴ፥ እታ ኬና ሪንታዘን ፋረድካንታ ዝጋይቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ኩነረ ጋይሶ ፍርደን እምድባብከዝደርንካ ከትም ዉችሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ኮትኮᎺይካ ሙደነረ አይሁድንታ ምክስ ኤሄንታ ገችንባብ ሶስተንስም የድሶ ፍርደን እምድባብከስታ እሪ ጉጵሰኬ፥ ኮና ሙዳ ማድንካ ጋልዮስ Ꮊረነረ ክትካንታ ኤስማክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ጳውሎስ አሜንድባብከስካ ክክን በድ ሰጨንከስም ቆርንቶስ ካተመናር ዶቅሳን ቡር ኡርማ ዶእከቴ ከትም ጋይሶ ሶርያ ፍጫ አይሴ፥ ጵርስቅለከ አቅለረ ክትካ ክክን Ꮊቀኬ፥ ኬዛር ማቼ ቃንግ ክታ ዶቅድንካንታ ይ አይተርንደታ እሪ ክንክርያ ጋይምድን ካርዘን ይንታ ማተንም ሞከርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ኤፈሶን ካተመናረረ ከታ ይ የልሳንደትካ ጵርስቅለምንከ አቅለም ኮታር ከትም ዛቅሴ፥ ኖ ማቼ ከታ ምክስ ኤሄናር አርድሶ አይሁድንካንታ ኬዘሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","በድ Ꮊይክንደታ ከትካ ክክን ክት ዶቅድንግንዳ ክትም ከት ምክስንከረ ኤኦ ከትካንታ ጋያክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ኬዛር ማቼ “ሳብታ ጋይታ ማቼ አብᎺይካ የንደር ማትᎺትቴ” ከትካንታ ጋይንደትኬ ኤፈሶናርንካ ሎቀንዘንካ ቃልዝድን ማርከብናር አርድሶ አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ቅሳርያ ካተመናር ክት የልሳንደትካ ኮታርከረ የሩሳሌም ካተመናር አይሶ አሜንድን ኤድንከስካንታ አቦ የታ ኡርመቶ ይ ጋይሳንደታ ቡር አንጾክያ ካተመናር Ꮊንቸርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ኮታረረ ቶክም ሰጫ ዶቅሴ፥ ኮታ ቡር ገላትያርከ ፍርግያ ፍጨናር ኦንገሮ አሜንድባብከስም ዳቅስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","እስክንድራ ፍጨናር አጥምስባብ አጵሎስ ጋይምስባብ ዋልቃ አይሁድ ማችባብ ኤፈሶን ካተመናር Ꮊዴ፥ ኖ ጭል ማጻፍንከስም ኡርስት ኤስባብኬ ኡርማ ኬዘታ ኤስንታ ዶቅድባብ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ጮይስታ ጎግንም ኤስባብኬ አያናረረ አተርድባብ ማትሶ የሱስጎካ ዶፈንን ሳባከርንደትኬ ኤስሰሮ Ꮊቄ፥ ማታጋካ ዳት ኖ ክት ኤዝድንዳ ዮሀንሰታ ስእስን Ꮊክ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ኖ ሙቅምካ አይሁድንታ ምክስ ኤሄናር ኬዛ የጄ፥ ኬዛር ማቼ ጵርስቅለከ አቅለካ ኤሰርሰኮ ይንታ ኤር ተይ ከትም አይስንካ ሳብታ ጎግንም ኤና እርንዘንካ ስግስሶ ገታ ጫረርሳ ክትካንታ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","አጵሎስ አካያ ፍጨናር አይካንታ ክት ገቀርሳንደትካ አሜንድባብከስ ክታ ገቅርን ዳቅሰኬ፥ አካያር ዶቅድባብ አሜንድባብከስ ኡርማ ገቅርካ ክትም ከት ሞግድንግንደረ ክተን ክትካንታ ጻፍሰኬ። ኮታረረ ክት የልሳንደትካ ሳብታ ዉች እምንተንካ አሜንድባብከስ ማትካንታ የልስባብም አንድር ከትም አልሴ። ");
INSERT INTO gyl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","የሱስ ክርስቶስ ማትንተን ጭል ማጻፍ ቃለንካ ቡዳር ከታ አርድንግንዳ ኬዘሮ ዳቅማ ቤርምካ አይሁድንም ጋምድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","አጵሎስ ቆርንቶስ ካተመናር ክት Ꮊቃንደትካ ጳውሎስ ዘርመር ዶቅድን ፍጨናርጎካ ስግሶ ኤፈሶን ካተመናር የልሴ፥ ኮታረረ ቶክም አሜንድባብከስም Ꮊፍሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ኖየረ ከደር፥ “የ አሜንሳንᎺይካ አያን ጭልንም ተይተቴ?” ጋየሮ ከትም ኦይሴ። ከተረ “ዎታ ተያኮቴ፥ አያን ጭልና ዶቅድንደትም ዎራ ኤሰርሶ ኤሳዮቴ” ጋይሰኮ ማስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ጳውሎሰረ “ይና፥ Ꮊራግንዳ ስእርነንት ስኤርሳሬ?” ከደር ጋይሴ። ከተረ “ዮሀንሰታ ስእስንሜ” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ጳውሎሰረ ዮሀንሰታ ስእስነረ ጎማ ፍክስን ዎይስንጎካ ቦድምሳንዴ፥ “ዮሀንሰረ ዎርሰንካንተረ ኬዝድዮ እስታ ቡርጎካ Ꮊድባብካ አመንምከቴ ጋየሮ Ꮊቄ፥ ኖየረ የሱስዬ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ኮም ከታ ይ ኤሰርሳንደትካ ጮይስ የሱሰታ ላምካ ስኤርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ጳውሎስ ይንታ አንንም ከታዘን ክት ዎጃንደትካ አያን ጭልና ከታዘን Ꮊንቸርስንካ አብ አፈካ ኬዘኬ፥ ቤርከረ ኬዛ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ኤድንከሰረ ሙዳ ታመኬ ቃስተን ማድባብከስ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ጳውሎስ አይሁድንከስታ ምክስ ኤሄናር አይሶ ማከን አርፍ ማታባብናር ሳብታ ባንችምንጎካ በርመርንደትኬ ዎርሰንታ ቡዳር አርድንግንዳ ካርችካ ኤስሰሮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ዋልቃ ዋልቀንከስ ማቼ ይንታ ይምኤንም ቦድባብ ማትሰኮ ጮይስታ ጎግን ዎርሰንታ እሪ የከረኮ አመንዳኮቴ ከትጋይሳንካንታ ከታዘንካ ጎተርሴ፥ አመንድባብከስመረ Ꮊክ ተይ አይሶ ጢራኖስ ጋይምድን ኤስስ ኤሄናር ሰጫ ሰጨንካ ኤስዝድ ከትም Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ጳውሎስ ኮም ክት ይይሳንዳ ቃስተን ስላ ማታባብናረ፥ ኮታይከረ እስያ ፍጨናር ዶቅድባብ አይሁድንከ አይሁድ ማታክባብከስከ ሙደና ጮይስታ ቃለንም ኤሰርካንታ ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ሳብ አንድር በርእስዝድን አተንከስም ጳውሎስታ አንካ ፍግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ኮታ ጎግከረ ጳውሎስታ ዘነንም ዎልሳን አፍለንምኬ ማራብን ተየረኮ Ꮊዘርስባብከዘን ዎድንካ Ꮊዝምንክንባብከሰረ ፋጨሮ Ꮊቀኬ፥ ቱና አያንንከሰረ ከታዘንካ ዉድዮ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ግምዘንከስመረ ኤድንከዘንካ ዉቸረኮ Ꮊክ Ꮊክ ካርያር ኦንግድባብከስ አይሁድና “ጳውሎስ ሳባግድን ጮይስን የሱስታ ላምካ የ ዉድንግንዳ የም ክዶቴ” ጋይንተካ ግምዘንከስም ኤድንከዘንካ ዉችካንታ ጉረሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","አይሁድ ቀሰንከስታ ገችንባብ ማችባብ አስቀዌተታ ታብዛ ይንችንከሰረ ኮትኮግንዳ ይድ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ከዛር ማቼ ቱና አያንና “የሱሰም ኤዝድቴ! ጳውሎስጎከረ ኤዝድቴ! የታ ማቼ Ꮊይከሰረ?” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ዋልቃ ቱና አያንካ የደርስባብ ኤች ጎብሶ ከትም ጉንእት የድንተካ ከታዘን ዳቅሰ ከትመረ ጋምሴ፥ ከትም ድደርስንካ ዘና ጫለንካ ማትሰኮ ኤሄናርንካ አጥምሰኮ ዉተደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ኮነረ ርና ኤፈሶን ካተመናር ዶቅድን አይሁድንከዝደርኬ አይሁድማታክባብከዝደር ኤስምሳንካንታ ሙደና ጳሰኬ፥ ጮይስ የሱሰተረ ላምና አንድር ቦንችምሳንዳ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","አመንስባብከሳርንከረ በድንከስ ዳቅል ይንታ ፍክስንም መየካ ፋጨረኮ ᎺድᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","በድ ሳገንባብከስ ይንታ ሳጋ ማጻፍንከስም ሳንስሰኮ ዎርሰን ሙደንታ እሪ አቺሰኬ፥ ማጻፍንከስታ ባዘን ከዘርድንካ ቃስተን ቦንደኬ ታማ ሳአ ጣገራ ብራ ማትሶ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ኮግንደካ ጮይስታ ቃለና ዎልቀካ ዳልገርንደትኬ ጋመሮ አይድᎺቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ኮና ሙዳ ይይምሳን ቡር ጳውሎስ መቅዶንየኬ አካያ ጎካ ዶቆ የሩሳሌም ካተመናር አይካንታ ይንታ አያንካ ገቀርሶ “ኮታር እ የልሳንቡር ኦስ ሮማ ፍጨናር አይ እም ዝግዝዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ኮካንታ ክትም አለን አልድባብ ኤድንከሳርንካ ቃስተንን፥ ጢማቶሰምንኬ ኤራስጦሰም መቅዶንያ ፍጨናር ኦይትሶ ኖይንታ ማታ እስያ ፍጨናር ቶክም ሰጫካንታ ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ኮታይካ ጮይስታ ጎግንጎካ ኤፈሶን ካተመናር አንድር አዉል አምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ዋልቃ ድመጥሮስ ጋይምድባብ ዱንድን ፋግድባብ አርጠምስታ ጎይን ኤሄንታ ካምስካ ብረዘንካ ኡርሰሮ ፋኬን ፋግድባብከስካንታ በድ ስጥመም Ꮊፍስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ኮካንታ ኮና ኤችና ፋኬን ፋግድባብከስምከ ከተንግንዳ ፍክስ ዶቅድባብከስም አብ ኤድንከስመረ ሳንስሶ ኩንጋይሴ፥ “የታ ኤድንከሶ! ዎ ቆልማ Ꮊብድንዳ ኮ ፍክስንካ ማትንተን የታ ኤዝደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ኮና ኖ ጳውሎስ ኤታ አንካ ፍክስምስን ካምስንከስ ጮይስ ማታክባብ ጎይንንከስ ካየኬ ጋየሮ ኤፈሶን ካተመናር Ꮊክ ማታክናና ቶክም ፍጨንከስ ነግተርዳት እስያ ፍጫ ሙደናር Ꮊስከካ በድ ዎርሰም ኤእሳንግንደከ አመንሳንግንዳ የታ የንታ ማታርንካ የ ሰዳንደትኬ የ ኤሰርሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ኮግንደካ ኮና ዎንታ ፍክስና ቶችምዴ፥ ኮነረ Ꮊክ ማታክናና እስያርንኬ ፍጫሙደንዘን ኤድ ሙደና ኮትም ጎይንድንዳ አንድር ጮይስ አርጤምስታ ጎይን ኤሄና ዉችኩን ማትሶ ነገዴ፥ ኮተረ አንድርትቸነረ ካይዴ”። ");
INSERT INTO gyl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ኤድንከሰረ ኮትኮም ኤሰርሳንደትካ ዋጭሰኮ፥ “ኤፈሶን ኤድንከስታ አርጤምስ ና አንድሬ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ኮታ ካተመነረ ሙዳ አዉልሴ፥ ዎርሰነረ መቅዶንያ ፍጨናርንካ ማችባብ ጳውሎሰካ ክክን አያቅባብ ቃስተን ላኮይትንከስም፥ ጋይዮሰምንከ አርስጥሮኮሰም የተኮ ጎቸረኮ ዎርሰና ሳንምድን መለንዘን ዞጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ጳውሎስ ዎርሰንደር አይካንታ ዝግዛንካንታ፥ አሜንድባብከስ ማቼ ክት አይዳክንግንዳ ማርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","እስያ ፍጨናርንካ ገችንታ ኤረንባብከሰረ ክታ ላኮይት ማችባብከስ ዋልቃ ዋልቀንከስ ጳውሎስደር ኤድም ኦይትሰኮ “ኤድንከስ ሳንምድን መሌንዘን አይሳዮ የስ Ꮊፈርዳክንግንዳ” ጋየረኮ ክትም ምክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ዎርሰንታ ዎክያር አንድር አዉል አምሳንካንታ በድንከስና Ꮊረታ ከታ ይ ሳንምሳናንከረ ዎራ ከታ ኤሳይ Ꮊቀኬ፥ ኮትኮጎካ ዋልቀና ዋልቃ ር ጋየሮ ፍብድንካ አብነረ ጉጅሶ አብ ርም ጋየሮ ፍብድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ዋልቃ ዋልቃ አይሁድንከስታ ኮችንከስ እስክንድር ጋይምስባብ ኤችም ዎርሰናርንካ አምስሶ ኦስ እር ክትም Ꮊቅሰኬ፥ ዎርሰንተረ ዋርንካ ዋልቃ ዋልቀንከስ ኡርስት ከትካንታ ክት በርምድንግንዳ ዞርሰኬ፥ እስክንድረረ ዎርሰና ጫምን ከት ጋይድንግንዳ ይንታ አንካ ከትም ሰችሶ ከትኦል በርምካንታ ግግምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ኬዛር ማቼ እስክንድር አይሁድ ክት ማቻንደትም ኤድንከስ ሙዳ ኤሳንደታ ቡር “ኤፈሶንታ አርጤምስ ና አንድሬ!” ጋየረኮ ቃስተን ሳዓት ማታባብ ሙደነረ ዋልቃ ኡፍስካ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","በእንተዘን ካተመንታ ጻፍንባብና፥ ዎርሰንም ጫምሳ ይይሶ ኩን ጋይሴ፥ “ኤፈሶን ኤድንከሶ! ኤፈሶን ካተመናር ዶቅድባብከስ፥ አንድር ማቻን አርጤምስታ ጎይን ኤሄንከ ጭላርንካ Ꮊንቸርሳን ካምስንከስን ከት ካርዝድንደትም ሙደንታ ባንግር ኤስምሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ኮም ካድባብ Ꮊየነረ ካየንካንታ ዳብን የ ጋይተርንግንደኬ ሳነርሰቶ ዳቅል ርም ይይንተዘንካ የ ካርስምድንግንዳ ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ሳብታ ጭል ኤሄንም ቡራክባብምኬ ዎንታ ጮይስንዘን የካክባብ ኤድንከስም ኮር የድሰቶ Ꮊተቴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ድመጥሮስከ ክትካ ክክን ዶቅድባብ ፋኬን ፋካኦንግድባብከስ ከት ካሰዝድን ኤድ ዶቅሴ ፍርዳ ከታዘን እምድባብ ዳይነንከስ ዶቅደኬ፥ ገችታ ኤረንባብከሰረ ዶቅደኬ፥ ኦኮታር ከት ይንታ በርማ። ");
INSERT INTO gyl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","አብ የ ዝግድን ር ዶቅድንዳ ማቼ ገታ ቡጫ ጋልተንከስካ ሰድምዴ። ");
INSERT INTO gyl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ኮካያ ማቼ ታካ ይይምሳን ሪንካ ‘አዉለም አምስስቴ’ ጋይምሶቶ ዎ ካሰስምዳክንግንዳ ጳስዝዴ፥ ‘ኮና ዋጭመና Ꮊራጎካ አምሳራ’ ጋይምሶ ዎ ኦይስምዴ ዎ እምድን ማስ ከታዘን ካዬ” ");
INSERT INTO gyl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ኮመረ ጋይሶ ሳንምሳን ኤድንከስ ይጭምድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","አዉልና ዳብን ጋይሳንደታ ቡር ጳውሎስ አሜንድባብከስም የካ ኤልስሶ ዞራ ቃለንካ ከትም ዳቅሴ፥ ኡርማ ዶእከቴ ጋይንደትኬ መቅዶና ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ይ ስገድን ከትኬና ካርንከሳር አሜንድባብከስም በድ ዞረካ ከትም ዛብሰሮ ኦስ ግርክ ፍጨናር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ኮታረረ ማከን አርፍ ዶቅሴ፥ ኮታ ቡር ሎቀዘን ቃልዝድን ማርከብካ ሶርያ ፍጫር አይካንታ ገቀርሴ፥ ማችንከረ አይሁድና ከታዘን ዙዝምሳን ይ ኤሳንደትካ መቅዶንያ ጎካ ማትካንታ ገቀርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ጵርሁስታ ይንች ሶጳጥሮስ ቤርያ ካተመንካ፥ አርስጥሮኮስከ ስኮንዶስ ተሴሎንቃ ካተመንካ፥ ጋዮስ ደርቤ ካተመንካ፥ ጢማቶስ፥ ትክቆስኬ ጢሮፍሞስ እስያ ፍጨናርንካ ክትካ የካ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ከታ እርምሶ አይሰኮ ዎም ጥሮአዳ ሞረናር ካርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ዎታ ማቼ ባልስ ባአልንታ ቡርጎካ ፍልጵስዮስ ካተመናርንካ ሎቀንዘንካ ቃልዝድን ማርከባር አርድሶቶ ዶንቅ ሰጨካ ከትዶቅድን ጢሮአዳር የልሶቶ ከትካ Ꮊፈርሶቴ፥ ኮታር ታብዛ ሰጫ ስክሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ሳምንትንታ እሪ ሰጨን Ꮊይካ ባልስን አስት የካ እችካንታ ሳንምሶቴ፥ ጳውሎስ ዛማክንካ አይክትም ዝግዝድንኦል ሳንምሳን ኤድንከስካንታ ኬዛ የጄ፥ ኖይንታ ኬዘንመረ ሶይት ገልትገር የለልታ ቃልሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ዎ ሳንምሶ Ꮊቃን ኤሄንታዘን ዎድምሳን ኤሄናር በድ ዞጳ ዋር Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","አዉጥክስ ጋይምስባብ ዋልቃ ማርምድ ማስኮታዘን ዶቅሶ Ꮊቄ፥ ጳውሎሰረ ኬዘን ክት ቃልሳንደትካ ኖኮና ማርምድና አንድር ግንእ ክትም የጄ፥ ግንእነረ ክትም ጋምሳንካንተረ ማክምስ ኤሄንታዘን ዎድምሳን ኤሄንዘንካ ጩላ ዋቼ፥ ኤድንከስ ክትም አምዝድንካ ደእሶ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ኬዛር ማቼ ጳውሎስ Ꮊንቸርሶ ይንችንዘን ይርክን ጋይንተካ ክትም እምጭሶ “ይንችና ደአክዬ፥ Ꮊይገቀቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ጳውሎስ ኤሄንታዘን ዎደርሳን ኤሄናር ማትዮ አይሶ ባይስንም አስት አሜንድባብከስካ ክክን እቼ፥ ሰጭተርን የለልተረ ኤድን ከስካ ክክን ኬዝመሮ ይ Ꮊቃንደታ ቡር አይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ኤድንከሰረ ፋጭባብ ማርምድን ኤር ተይ አይሰኬ፥ ኮትኮከረ ክክ በድካ ዳቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ጳውሎስም ሎቀንዘንካ ቃልዝድን ማርከብንካ ሞክት ተይካንታ ዎ ገቀርሳንጎካ ዎታ እርምሶ ማርከብንካ አሶስ ካተመናር አይሶቴ፥ ኮመረ ዎይሳንዳ ጳውሎስ አሶሳ የለልታ ይንታ ዱትንካ አይካንታ ክት ጋይሳንካንተኬ ኮትኮግንዳ ዎ ይድንግንዳ ዎም ክት ክትሳንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ክትካ ክክን አሶሳር ዎ Ꮊፈርሳንደትካ ማርከብናር ክትም አርችሶቶ ምልጥንታ ካተመናር ክትካ የካ አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ዛማክንካ ኮታርንካ አምሶቶ ክዮስታ የረየር ዶቅድን ካርዘን ማርከብንካ የልሶቴ፥ አብ ሰጨናይከረ ሳሞሳር ቃልስንደትኬ ኮታ ዛማክንካ ምልጥናር የልሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ጳውሎስ እስያር ዉች ሰጨና ስገዳክንግንዳ ጋይሶ ኤፈሶንም ስግሶ አይካንታ ዝግዜ፥ ኮመረ ክት ይሳንዳ ጰንጠቆስጠ ባአልንካ የሩሳሌም ካተመናር Ꮊፍርካንታ ገቀርሶ ክት Ꮊቃንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ጳውሎስ ምልጥናርንካ ኤፈሶናር ኤድም ኦይትሶ ምክስ ኤሄናር ጋልተንከስም ኤልስሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ክደረ ከት Ꮊዳንደትካ፥ “እስያር እ አርደዳን ሰጨንዘንካ የችሶ ሙዳᎺይካ የንካ ክክን Ꮊስግንዳ እ ዶቅሳናንከረ የታ ኤዝደቴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","አይሁድንከስታ ዙዝምንካ ማጠና እዘን የልስንከረ ዎራ ቦድማ እስታ ማተን ይርክሳ ይይንተኬ በድ ኤፍካ ጮይስካንታ ፍግዝድ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","መለንዘነረ ማታ የንታ ኤረረ የም እ ኤስዝድቶ የም መይድንደትም ሙዳ ከዛት ዳት፥ Ꮊራ ሪየረ የንዘንካ ነግሳክቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","አይሁድነረ ማታ ግርክ ኤድንከስ ጎመን ይንታ ፋጭሶ ሳብደር ከት ማድንግንደኬ ዎንታ ጮይስን የሱሰካ ኬት አሜንድንግንዳ ከትም ኤግዝምስትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ታየረ ኮታር እ የልድንካ Ꮊራ እም የልዳናነረ ኤሳክትዶቆ አያንይ ጭልንካ ክትምስቶ የሩሳሌማር አይድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ማታጋካ ዳት አያን ጭልና እንካ ክክን ማትሶ Ꮊክ Ꮊክ ካተመናር ዞክርከ ማጠካ እም የልድንደትም ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ሳብትንደትም ዉች እምንታ ክላ ኬዘን ኤስስካንታ ጮይስ የሱስዘንካ እ ተያንደትም ነግምዳክን ፍክስን እ ቦጃንደታ ቡር እስታ ሰንፔንካንታ ናክ እማይቴ፥ እስታ ሰንፔንካንተረ አተራይቴ” ኩን ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ታ የለልታ የ ሙደንታ ዎክያር ኦንገርቶ ሳብታ ባንችምን ሳባግድ Ꮊቃቴ፥ ኮዘንካ ኦስ ማቼ የንታ ዋርንካ Ꮊየነረ ቦድሶ እስታ ባለንም ሰዳክንደትም ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ኮካንታ የንታ ዋርንካ ዋልቃባብ ዎራ ካይዴ እም ኦይስዝድንዳ ካየንደትም ታካ ሰጨንካ እታ የም ገቀርዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ሳብታ ገቅርንም ሙዳ የካንታ ከዛት ዳት Ꮊረነረ የንዘንካ እ ነግሳንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","አያን ጭልና የም ጎርዝድባብከስ ማስሶ ዶርቴ፥ ይና የንታ ማታካንተከ ዉደንካንተኬ ካርስምከቴ፥ ሳብ ይንታ ገታ ይንቺንታ ማቀስንካ ቆቲ ተያን ምክስ ኤሄናር ኤድንከስም ግስከቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","እ የንዘንካ አይሳን ቡር ዉደንካንታ አጨርዳክባብ ጋርመንከስግንዳ ጋርዛ ማችባብ ኤድንከስ የንደር አርድንደትም ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ኮትኮግንደረ ዋልቃ ዋልቃ ኤድንከስ የንታ ዎክያርንካ አምሶ ዎብ ኤስስን ኤስስካ በድ አሜንድባብከስም ከታ ይንደር ማዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ኮካንታ የ ዋልቃ ዋልቃባብከስም ማከን ስላ Ꮊየከ ሶይትካ ኤርመካ ኤፈርቶ እ የም ዞርሳንከካ ገቀረረቶ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ታየረ የም ዛብስካንተኬ ሳብካንታ ፋስምስባብከስተረ ዎክያር ባእ የካንታ እማካንታ ማድባብ ሳብካንተኬ ክታ ዉች እምንታ ቃለንካንተረ ዋደካ እምትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","እታ Ꮊየንተረ ብራ፥ ዎርቃ አነረ አፍላ አንገራክቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","እስታ ገታ አንንከስካ ፍክሰርቶ እስታ ማተንመረ ማትስቶ እስታ ላኮይትንከስም እ አላᎺቃንደትም የታ የንታ ማታርንካ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","‘ፈንክ ተይድባብዘንካ ስግስሶ ኦስ እምድባብ አንጅምስባቤ’ ጋይድንደትም ጮይስ የሱሰታ ቃለን ገቅርካ፥ ዎንታ አንካ ፍክሰሮቶ ጋፍስባብከስም አላ ዎም ዝግዝድንደትም በድ ጎግካ የካንታ ሰችትቴ።” ");
INSERT INTO gyl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ኮታ ቡርጎካ ጳውሎስ ሙደንከስከረ ክክን ጉምፈርሶ ምክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ሙደነረ ኤፍሰኮ ጳውሎስም እምጭሰኮ ሶንቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ስክስሰረ አንድር ከት ሞርእሳንዳ፥ “ይና ኮዘንካ እም ሰዳከቴ” ከደር ጋይሳንጎኬ፥ ሎቀንዘንካ ቃልዝድን ማርከብን የለልታ ክትም የልስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ከታዘንካ ዎ ፋስምሳን ቡር ሎቀንዘንካ ቃልዝድን ማርከብናር አርድሶቶ የረየር ቆስ ጋይምድን ሎቀንታ ግድያር ዶቅድን ደንንዘን አይሶቴ፥ ዛማክንከረ ሩድ ጋይምድን ሎቀንታ ዎክንታር ዶቅድን ደንንዘን የልሶቴ፥ ኮታርከረ ጳጥራ ጋይምድን ካተመናር አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ኮታረረ ኦስ ፍንቄ ፍጨናር አይድንዳ ሎቀንዘንካ ቃልዝድን ማርከብ Ꮊፍሶቶ ኮታር አርድንደትኬ፥ ዎንታ አይን የጆቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ሎቀንታ ዎክናር ዶቅድን ቆጵሮስ ደንን ዎንታ ከችዘንጎካ ዛቅሶቶ ኦስ ሶራ ፍጨናር አየሮቶ ማርከብና ዎእድን ካሪ ኦስ ጢሮስዘን አይሶቴ፥ Ꮊረታ ጋይሴ ማርከብናር ጫነርሳንደትም ኮታዘን Ꮊንች ዝግዝድንኦሌ። ");
INSERT INTO gyl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ኮታረረ አመንድባብከስም ዝግሶ ዎ Ꮊፍሳንደትካ ከትካ ክክን ታብዛ ሰጫ ዶቅሶቴ። ከተረ አያን ጭልንካ ጎርስምሰኮ ጳውሎስም የሩሳሌም ካተመናር Ꮊይ አዬ ጋይሰኮ ክትም ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ኮታር ዎ ዶቅድን ሰጨና በእድንካ ከታዘንካ ፋስምሶቶ ዎንታ አይን የጆቴ፥ ሙደነረ ከታ ይንታ ማነንከስኬ ይንችንከስካ ክክን ማትሰኮ ካተመናርንካ ዉትሰኮ ጎግንዘን ዎም የልስሰኬ፥ ባሀርንተረ ካንተዘን ጉምፈርሶቶ ምክሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ኮተረ ቡር አቦ ኡርማ ዶእከቴ ጋይሶቶ ፋስምሶ ማርከብናር ዎ አርድንካ ከተረ ይንታ ኤር ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ይና ትያጥሮስ ካተመናርንካ አምሶቶ ጰጠለማይስ ፍጨናር የልሶቴ፥ ኮታር አሜንድባብከስካ ክክን Ꮊፈርሶቶ አቦ ዎ ጋይሳን ቡር ከትካ ክክን ዋልቃሰጭ ስክሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ዛማክንካ ኮታርንካ ዉትሶቶ ኦስ ቅሳርያ ካተመናር አይሶቴ፥ ኮታር ሳብታ ፍግዝድባብ ታብዘንከሳርንካ ዋልቀና ሳባግድባብ ፍልጶስደር ኤር አርድሶቶ ክትካ ክክን ዶቅሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ክተረ ቤር ኬዘታ እምንታ ዶቅድባብ አንጃ ሙነክንባብከስ ኦይድ ማና ይንቺ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","በድ ሰጫ ኮታር ዎ ዶቅሳንደትካ አጋቦስ ጋይምድባብ ሳብዘንካ ኤሰርሶ ኬዝድባብ ይሁዳ ፍጫርንካ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ኮና ሳብዘንካ ኤሰርሶ ኬዝድባብ ዎንደር Ꮊድሶ፥ ጳውሎስታ ሳቅንም ተይሶ ይንታ ገታ አንንከስምከ ዱትንከስም ዞክሶ “አያን ጭልና ኮ ሳቅንባብም የሩሳሌም ካተመናር ዶቅድባብ አይሁድንከስ ኮግንዳ ክትም ዞክሰኮ አይሁድ ማታክባብከስካንታ ስክስት እምተረኬ ጋይዴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ኮም ዎ ኤሰርሳንደትካ ዎተረ ኮታር Ꮊቅባብ ኤድንከሰረ ጳውሎስ የሩሳሌም ካተመናር አይዳክንግንዳ ክትም ምክሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ጳውሎስ ማቼ “ኮግንዳ ኩን የታ ኤፈረቶ Ꮊረተንት እም ሞርእስዝዳ? እታ ጮይስ የሱስታ ላምንካንታ የሩሳሌማር ዞክርካንታ Ꮊክ ማታክናና ደእካንተረ ግግምትቴ” ጋይንተካ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ዎንታ ዞረንም ተያ ክት ግርዳንደትካ “ይና ጮይስ ጋይሳንዳ ማታ” ጋይሶቶ ክትም ዛቅሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ኮታር ቶክም ሰጨንከስም ዎ ዶቅሳን ቡር ዎታ ግግምሶቶ የሩሳሌም ካተመናር አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ቅሳርያ ካተመናር ዶቅድባብ ዋልቃ ዋልቃ አመንድባብከስ ዎንካ የካ Ꮊደኬ፥ ከተረ ምናሶነታ ኤር ዎ ኡክንድንግንዳ ክደር ኤር ዎም ጎርሰኬ፥ ኮና ኤችና እርምሶ አሜንስባብ፥ ቆጵሮሳር አጥምስባብ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","የሩሳሌም ካተመናር ዎ የልሳንደትካ አመንድባብከስ ጉርምካ ዎም ሞክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ዛማክንካ ጳውሎስ ዎንካ ክክን ያይቆብደር አይሴ፥ ምክስ ኤሄናር ጋልተንከሰረ ሙዳ ዋር Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ጳውሎስ ሙደንካንታ አቦ ኡርመቶ ጋየሮ ይ የልሳንደታ ቡር ክትጎካ ሳብ አይሁድ ማታክባብከስታ ዎክያር ይሳንደትም ሙዳ ዋልቃ ዋልቀን ይምሶ ስገዳንደትም ከትካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ኮትኮም ከታ ይ ኤሰርሳንደትካ ሙደነረ ሳብም ጋለቸኬ፥ ጳውሎስመረ ኩን ጋይሰኬ፥ “እስመኖ! በድ ሳአ ፋይድምድን አመንድባብከስ አይሁድንከስታ ዎክያር ዶቅድንደትምኬ ሙደነረ ህግንካንታ ቀምዝድባብከስ ማቻንደትም የና ኤዝደዬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","የና አይሁድ ማታክባብከስታ ዎክያር ዶቅድባብከስም አይሁድን ሙዳ ‘የንታ ይንችንታ ሶለንም Ꮊይተቸቴ አነረ ዎገንም Ꮊይቦደቴ’ ጋየረዮ ኤስስካ ሙሴታ ህግን ከት ዛቅድንግንዳ ይደዬ ጋይመሮ ከዝምድንደትም ኤሰርተኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ይና Ꮊራ ይ ኡርተራ? የስታ Ꮊድንተን ገታ ኤሰርደኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ኮካንታ ዎ የስም ጋይድንደትም ይካ፥ ዎንታ ዎክያር ቃንግ ከታዘን ዶቅድባብ ኦይድ ኤድንከስ ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ከትም የድሰዮ ከትካ ክክን ማትሶ የስታ ማተን አርንስካ፥ ከታ ይንታ ማተንመረ ሞከርድንግንዳ ሳብታ ጭል ኤሄንካንታ እምምድን ብረንም ከትካንታ ናካ፥ ኮም የስ ይዴ የስታዘን ኬዝምሳንዳ ሙዳ ዉች ማዳክንዳ ማድንደትምኬ የነረ የስታ ማታርካ ሙሴታ ህግንካንታ ክትምድባብ የስታ ማትንተን ሙደነረ ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","አይሁድ ማታክባብከስታ ኮች አመንስባብከስ ማቼ ‘ጮይስ ማታክን ጎይንንካንታ ካሰርሳንዘንካ አምሳንዳ ቱና ማቻን እችምን Ꮊይ እቼቴ፥ ማቀሰረ Ꮊይ እቼቴ፥ ጉንእምሶ ደእሳን ዋከንታ ናንከረ ቆለንታ ዋሀ Ꮊይ እቼቴ፥ ቤልምዘንካ ጎተርከቴ’ ጋይድን ኬዘን የጃን ጻፍሶቶ ኦይቶቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ኮታ ቡር ጳውሎስ ኤድንከስም ተይአይሶ ዛማክንካ ከትካ ክክን ይንታ ማተን አርንሴ፥ ከት አርንድን ሰጨንከስ Ꮊንታ በእዳ ናንከረ ዋልቃ ዋልቃባብከሰረ ካስንም ሳብካንታ እመርድን ሰጨና Ꮊንታ ማድንከረ ኤስምስካንታ ሳብታ ጭል ኤሄናር አርደዴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ታብዛ ሰጨነረ በእካንታ የልድንካ እስያ ፍጨናርንካ Ꮊድባብ አይሁድና ጳውሎስም ሳብታ ጭል ኤሄናር ሰድንካ ዎርሰንም ሙዳ አምስስሶ ክትም የጀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“የታ እስራኤል ኤድንከሶ! ዎም አላ አልከቴ! ዎንታ ዎርሰንምኬ ዎንታ ህግን፥ ኮ ካርንመረ የከሮ ፍጫ ሙደናር ዶቅድን ዎርሰንም ሙዳ ኤስዝድባብና ኮና ኤችኔ፥ ኮነረ ክትም ማታዬ ጋይሶ ግርክ ኤድንከስም ሳብታ ጭል ኤሄናር አርችካ ኮም ጭልምሳን ካርንም ቱና ማስቴ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ኮመረ ከት ጋይሳንዳ ኮታ ኤና እሪ ኤፈሶን ካተመናር አጥምስባብ ጢሮፍሞሰም ክትካ ክክን ካተመናር ሰድሶ Ꮊቃንጎካ ክትም ጳውሎስ ሳብታ ጭል ኤሄናር የድሶ አርደዳን ከደር ካምሳዶቆ። ");
INSERT INTO gyl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ካተመነረ ሙዳ አዉልሴ፥ ዎርሰነረ ሙዳ ዞደረኮ የካ Ꮊድሰኮ ጳውሎስም የድሰኮ ክትም ጎቸረኮ ሳብታ ጭል ኤሄናርንካ ክትም ዉችሰኬ፥ ሳብታ ጭል ኤሄንተረ ፉልተንከስም ሳነካ ዝጨኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ኤድንከስ ጳውሎስም ክትም ደይሳካንታ ከት ዝግሳንደትካ “የሩሳሌምታ ካተመና ሙዳ አዉልቴ” ጋይድን ክተና ሮማ ኤድንከስታ ዳምንባብከስም ክድባብካንታ የልሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ኮካንታ ኖ ዳምንባብከስምኬ ዳምንባብከስም ክድባብከስም ጎርስሶ ሳና ዞደሮ ኤድንከዝደር አይሴ። ኤድንከሰረ ዳምንባብከስም ክድባብምኬ ዳምንባብከስም ሰዳንደትካ ጳውሎስም ጉጵነንም ዛቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ዳምንባብክስም ክድባበረ Ꮊድሶ ጳውሎስም የድሶ ቃስተን ስብል ዛንካ ዞከርድንግንዳ ክትሴ፥ ኮታ ቡር Ꮊይ ክት ናነረ Ꮊራክት ይሳናነረ ኤስካንታ ዝግሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ዎርሰነረ ዋልቃ ዋልቀንከስ ዋልቃ ር ከት ጋይድንካ፥ አብንከስ አብ ር ጋይድ Ꮊቀኬ፥ ዳምንባብከስም ክድባብ ዎርሰንታ ፍፍንዘንካ አምሳንዳ ዶፈን ርን ኤስካንታ ይማታክንጎካ ጳውሎስም ዳምንባብከስ ዶቅድን ካርናር ክትም ተይ አይድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ጳውሎስ ጬክን ጋይሳንዘን ክት የልሳንደትካ ዎርሰና ሙዳ አንድር ዋጭካ አምሰኮ ማጣ ክታዘን የልስካንታ ከታ ዝግንተንካ ዳምንባብከስ ክትም ባልሰኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ዎርሰነረ “ክት ደይስማ!” ጋየረኮ ፍፍካ ጎርስመረኮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ዳምንባብከስ ከታ ይ ዶቅድን ካርናር ክትም አርችካንታ የልሳንደትካ ጳውሎስ ዳምንባብከስም ክድባብም “ዋልቃ ር የስካንታ እ ኬዝድንግንዳ ጋይዳ?” ክደር ጋይሴ። ዳምንባብከስም ክድባበረ “ግርክታ አፈን ኤዝዳ? ጋይሶ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ይና፥ ኦስኮ ታ አክ ኤታ ዎክናር ዋጭመም አምስስሶ ኦይድ ሳአ ኤድም ደይስባብከስም የድሶ ዴል ቆቸናር አጥምስባብ ግብጽ ኤችና የና ካዮ?” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ጳውሎሰረ “እታ ኪልቅያ ፍጨናር Ꮊፈርድን ኤስምሳን ማቻን ጤርሰስ ካተመናር አጥምስባብ አይሁድቴ፥ ዋደ ዎርሰንካንታ እ ኬዝድንግንዳ ጋይካ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ክት ኬዝድንግንዳ ጋይሳንደትካ ጳውሎስ ጬክን ጋይሳንዘን ዎእሶ ዎርሰና ጫምን ጋይድንግንዳ አንካ ሰችሴ፥ ዎርሰና ጫምን ከት ጋይሳንደትካ ዕብራይስጥ አፈካ ኩንጋየሮ ኬዛ የጄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“እስታ እስመንከስኬ እስታ ባበንከሶ! ይና፥ ታ የካንታ እ እምድን ማስን እዝደር ኤሰርከቴ!” ");
INSERT INTO gyl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ዕብራይስጥ አፈካ ክት ኬዝድንካ ከታ ይ ኤሰርሳንደትካ እንድንካ ጫምን ጋይሰኬ፥ ጳውሎሰረ ይንታ ኬዘንም ኬዘሮ ኩን ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","እታ ኪልቅያ ፍጨናር Ꮊፈርድን ጤርሰስ ካተመናር አጥምስባብ አይሁድቴ፥ እ ጋጵሳንዳ ማቼ ኮትኮ የሩሳሌም ካተመናሬ። እም ኤስስባበረ ጋማልያል ጋይምድባብ Ꮊቄ፥ ባቤንከስታ ህግን ኡርስት ኤስባብኬ ገታ ታካ የታ የ ይድንግንዳ ሳብም አያናር ቀምስካ ክትካንታ ፍግዝድባብ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ኮ አሜንንም ጎርስምድባብከስ እስመንከስምኬ ምችነንከስም ሙዳ እ ደይስተርን የለልታ ዳይድባብ ኤች Ꮊቃቴ፥ ከትም ዞከርቶ ዞክና ኤሀር ኬት አርድንግንዳ ይድ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ኮነረ ዶፈን ማትንተን ቄሰንከስም ጌችዝድባብኬ ቡጫ ጋልተንከስ ሙዳ እካንታ ማርከርደኬ። ኮትኮግንደረ ደማስቃ ካተመናር ዶቅድባብ ከትኬና ኤድንከስም ዞክስቶ የሩሳሌማር ተይᎺድካንተከ ከትም ሰርካንታ እ ማድንደትም ደማስቃር ዶቅድን ከታ ይንታ ኮችንከዝደር ከት ጻፍሳንደትም እ ተያንዳ ከታዘንኬ። ");
INSERT INTO gyl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“እታ ደማስቃር እ አይድንኬ ካተመናረረ እ ቅንችምድንካ ፍጨና ቶመርታ ቶህ ጋይድንካ እ ገቀራክናና አንድር ሳክማ ጭለዘንካ እስታ ካንተካ ሮጵሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ኮታይካ ፍጨዘን እ ዋችንካ፥ ሳዉሎ! ሳዉሎ! Ꮊረተስ እም ዳይዳ? ጋይድን ኡፍስ ኤሰርሳቴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","እተረ የ ጮይስዮ! የና Ꮊይራ? ጋይሳቴ፥ ኖየረ እታ የስ እም ዳይድባብ ናዝረት የሱስቴ እዝደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","እንካ ክክን ዶቅድን ኤድንከስ ሳክመንም ሰደክ ዳት ክት እም ከስዝድንካ ክታ ኡፍስንም ኤሰራከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","እተረ ‘የ ጮይስዮ! Ꮊርስ ይቴ?’ ጋይስቴ። ጮይሰረ ‘አምሰዮ ደማስቃ ካተመናር አይካ፥ ይይ የስም ዝግዝድንደትም ር ሙዳ ኦኮታር የስካንታ ከዝምተሬ’ እም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ሳክመንታ ሮጵንዘንካ አምሳንዳ ሰድንካንታ እ ማታክንጎካ እንካ የካ Ꮊቅባብ ኤድንከስ እስታ አንንም የድሶ እም ጎርሰረኮ ደማስቃ ካተመናር የልስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ኮታር ሀነና ጋይምድባብ ዋልቃ ኤች Ꮊቄ፥ ኮና ኤችና ደማስቃ ካተመናር ዶቅድባብ አይሁድ ሙደንደር ቦንችምስባብ፥ ህግንመረ ካርዝድባብ አያንክንባብ ኤች Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ኖ እዝደር Ꮊድሶ እስታ ላማር ዎእሶ ‘እስታ እስመን ሳዉሎ! አፍና የስታ አና ካርንካ የስካንታ ሰዳ!’ እም ጋይሴ፥ ካርንኮትዘን አፍይ ይፍችካ እስታ አፍና ሰጄ፥ ክትመረ ሰጅቴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ኖየረ ኩን እካንታ ጋይሴ፥ ‘ዎንታ ባቤንከስታ ጮይስና ክታ ጋይተንም የስ ኤዝድንግንዳ ክታ ጭለትቼንም የስ ሰድንግንደከ ክታ ኡፍስንመረ የስ ኤሰርድንግንዳ እርምሶ የስም እቴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ኮመረ ክት ይሳንዳ የስ ሰዳንካንተኬ የስ ኤሰርሳንካንታ ኤድ ሙደንታ እሪ ክታ ማርከርድባብ የስ ማድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ይና፥ ታ Ꮊረስ ካርዝዳ? አምሰዮ ክታ ላምንም ኤልንተካ አሜንድባብከስታ ስእርንም ስኤርካ፥ የስታ ጎመናርንከረ ጭልምካ’ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ኮታ ቡር የሩሳሌም ካተመናር ማትስቶ ሳብታ ጭል ኤሄናር እ ምግዝድንካ ቱምቱምሳ እም ይድንካ ለምለም ጋይድንካ ሰድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ጮይሰረ እካንታ መያ ማትሶ ‘የና እጎካ የስ እምድንደትም ማርካትቼን ከት ኤሰርዳክንኦል ዶቃካይዶቆ ሳነካ የሩሳሌማርንካ ዉትካ’ እም ጋይሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","እተረ ኩን ጋይሳቴ፥ ‘ጮይስዮ! Ꮊክ Ꮊክ አይሁድንታ ምክስ ኤሄናር አየርቶ የስካ አሜንስባብከስ ሙደን እ ዞካᎺቃንደትምኬ እ ጉጳᎺቃንደትም ከታ ይንታ ማታርንካ ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","የስታ ማርካ ማትሶ Ꮊቅባብ እስጥፋኖስ ደይስምሳንᎺይካ እተረ እስታ ማታርንካ ደይሰንባብከስታ ባንግር ዎእስቶ ከትካ ክክን ኬዘንካ ኤእትቴ፥ ከታ አፍለንመረ ካርዝድᎺቃቴ’ ");
INSERT INTO gyl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ጮይሰረ ‘ጎት ዶቅድባብ አይሁድ ማታክባብከዝደር የስም ኦይድንካንታ አምሰዮ አይካ!’ እምጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ኮ የለልታ ዎርሰና ሙዳ ጳውሎስታ ኬዘንም ኤሰርድᎺቀኬ፥ ኮታ ቡር ኡፍስን ይንታ ጬክሳ ይሰኮ፥ “ኮግንዳ ኤድ ፍጨዘንካ Ꮊልአጋካ! ኮግንዳ ኤድ ሰንፔካ ዶቅ ክትም ዝክሳዬ!” ጋየረኮ ፍፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ከታ ፍፈረኮ አፍለን ይንታ አቅት ኦይተርንደትኬ ቡልም ጭላር ይጭድᎺቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ከትም ክድባበረ ኮም ሰዳንደትካ ጳውሎስም ዳምንባብከስ ዶቅድን ካርናር አርጅድንግንዳ ክትሴ፥ ዎርሰና ክታዘን Ꮊረታ ኮከካ ፍብዳናንከረ ኤስካንተረ አንድር Ꮊርደርመሮ ኦይስምድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ኬዛርንካ ማቼ ጋመካ ክትም ጬጵሰኮ Ꮊርድናካንታ ከት ግግምድንካ ጳውሎስ ክታ ባንግር ዎእስባብ ዳምንባብከስታ ገችዝድባብም “ሮማ ፍጫ ኤድ ማችባብም ፍርዳ እምማክናና የ Ꮊርድንግንዳ የካንታ ጋይምቶ?” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ዳምንባብከስም ገችዝድባብ ኮም ይ ኤሰርሳንደትካ ይም ክድባብደር አይሶ “Ꮊራ የና ይይካንተረ? ኮና ኤችና ሮማ ፍጫ ኤዴ!” ክደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ኮካንታ ክተንባብና ጳውሎስደር እጵን ጋይሶ “የስ እም ኬዝኔ፥ የና ሮማ ፍጫ ኤዶ?” ጋይሴ፥ ኖየረ “ይዬ”፥ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ክተንባበረ “እታ ኮም ሮማ ፍጫ ኤድ ማትንተን እ ሰንትተያንዳ በድ ብረከ” ጋይሴ። ጳውሎሰረ “እታ ማቼ ሮማ ፍጫ ኤድ ማትስቶ አጥምሳቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","“ኮካንታ ከታኬና ካርንካ ክትም ኦይስካንታ ግግምሶ Ꮊቃን ኤድንከስ ሳነካ ክታዘንካ ጎተርሰኬ፥ ክተንባበረ ሮማ ፍጫ ኤድ ማችባብም ስብልካ ዞክነንም ይ ገቀርሳንደትካ ጳሴ”። ");
INSERT INTO gyl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ዛማክንካ ክተንባብ፥ አይሁድና ጳውሎስም ከት ካሰሳን ገታ ጎግና Ꮊራ ኮትናነረ ኤስካንታ ዝግዜ፥ ኮካንታ ቀሰንከስም ገችዝድባብከስኬ ጋልተንከሳር ዶቅድባብከስ ሙደና ሳንምድንግንዳ ክትሴ፥ ጳውሎስመረ ክት ዞከርሳናርካ ብልስት ተይᎺድሶ ከታ እሪ ክትም ዎይስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ጳውሎሰረ ቡጫ ጋልተንከስም ፍስሳ ሰድሶ “እስታ እስመንከሶ! ታካ የለልታ ሙዳᎺይካ ሳብታ እሪ እ ዶቅሳንዳ ኡርማ ገቅርኬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ቄሰንከስም ገችዝድባብ ሀናንያ ማቼ ጳውሎስታ አፈን ኬት ጉጵድንግንዳ ጳውሎስታ ባንግር ዎእስባብ ኤድንከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ኮትኮᎺይካ ጳውሎስ ሀናንየም፥ “የና ቦቃ ጫምንካ ሳይምሳን ዶቼንም ካምድባብ! የስመረ ሳብ ጉጵተሬ! ህግንታ ጎግካ እስተንደትም ፋረድካንታ ዶቅደይ ዶቆ ህግካይሳ ኬት እም ጉጵድንግንዳ የና ክተራ?” ");
INSERT INTO gyl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ኮታር Ꮊቅባብ ኤድንከስ ጳውሎስም “ሳብታ ቄሰንከስታ ገችንባብም የግዳ?” ክደር ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ጳውሎሰረ “እስታ እስመንከሶ! ቀሰንከስታ ገችንባብ ክት ማቻንደትም ኤሳክቴ፥ Ꮊረታ ጋይሴ ‘ዎርሰን ገችዝድባብታዘን ዳቅል ኬዛ Ꮊይከዜ’ ጋይምድንዳ ሙሴታ ህግ ማጻፍናር ጻፍምቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ጳውሎስ ኮታር Ꮊቅባብ ኤድንከስ የከና ሰዱቃዊያን ጋይምድባብከስ የከንከስና አና ፈረሳውያንንከስ ማትንተን ኤስሶ “እስመንከሶ! እታ ፈረሳውያንንዘንካ አጥምስባብ ፈረሳውቴ፥ ይና! ታ ፍርደታ እሪ እ ዎእሳንዳ እምምሳን ጉርምንጎከ ደእናርንካ አምንተንጎኬ” ጋየሮ ኡፍስን ይንታ ጬክሳ ይይሶ ቡጫጋልተንከስታ ዎክያር ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ጳውሎስ ኮም ኬዛንደትካ ፈረሳውያንንከስተኬ ሰዱቃውያንንከስታ ዎክያር ዋጭማ አምሶ ቡጫ ጋልተንከስ ቃስተንካርዘን ፋስምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ሰዱቃዊያን ኤድንከስ “ደእያርንካ አምንተረ ካዬ፥ ክታይንችንከሰረ ካየኬ፥ አያነረ ካዬ” ኬት ጋይድንካ ፈረሳዊያን ኤድንከስ ማቼ “ኬና ሙደና ዶቅደኬ ጋይሰኮ” አሜንደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ኮትኮᎺይካ አንድር አዉል ማቼ፥ ፈረሳውያንንከስታ ኮችናርንካ ማችባብ ዋልቃ ዋልቃ ሙሴታ ህግንም ኤስዝድባብከሰረ አምሰኮ “ዎታ ኮ ኤችንታዘንካ Ꮊራርየረ ዳቅልሪ ክታዘንካ Ꮊፋኮቴ፥ አያን ናንከረ አነረ ክታይንች ክትካንታ ከዝታ ማተሬ፥ ዎታ Ꮊሮንት ኤዝዳ?” ጋይንተካ ቤርምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ከታ ዋጭመና አንድር ዳቀሮ አይሳንካንታ ኤድንከስ ጳውሎሰም ታክስት ታክስት ኬት ዛቅዳክንግንዳ ጳስስሶ ክተንባብና “የታ Ꮊንቸርሰቶ ጳውሎስም ኤድንከስታ ዎክያርንካ ዉችተቶ ተይ Ꮊድከቴ! ዳምንባብከስ ዶቅድን ካርያር ክትም ተይ አይከቴ!” ጋየሮ ፖልስንከስም ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ኮታይካ ሶይት ጮይስ ጳውሎስታ ላማር ዎእሶ “ዳእካ የሩሳሌም ካተመናር እካንታ የስ ማርከርሳንግንዳ፥ ኮትኮግንደረ ሮማ ካተመናር እካንታ ማርከርካንታ የስም ዝግዝዴ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ፍጨና ሰጫንደትካ አይሁድንከስ ሳንምሰኮ “ጳውሎስም ዎታ ደይሳኮትዶቆ እችም እጅዳኮቴ፥ ሎቀረ ዎጭዳኮቴ” ጋይሰኮ ክክ ኤእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ኮትኮ ዙዝምንካ ኤእሳን ኤድንከስታ ፋይደና ቃስተን ቦንደዘንካ ስግድባብ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ከታ ቄሰንከስም ገችዝድባብከዝደርኬ ጋልተንከዝደር አይሶ ኩንጋየረኮ ከትካንታ ኬዘኬ፥ “ጳውሎስም ደይሳኮትዶቆ እችም እጅዳኮቴ ጋይሶቶ ጫቅቶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ኮካንታ “የታ ቡጫ ጋልተንከስካ ኤእሰቶ ዳቅስሶ የ ክትም ኦይዝድን ር ዶቅድን ካምስሰቶ ጳውሎስም የካንታ ተይ Ꮊድንግንዳ ፖልስንከስም ክድባብም ኦይስከቴ፥ ዎተረ ካሪ ክት የልተርንደታ እሪናና ክትም ደይሳካንታ ግግምቶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ኬዛር ማቼ ጳውሎስታ ምችነንታ ይንች ኮም ዙዝምን ኤሰርሳንጎካ ፖልስንከስ ዶቅድን ካርያር አይሶ ጳውሎስካንታ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ጳውሎሰረ በድ ዳምንባብከስም ገችዝድባብከሳርንካ ዋልቀንም ኤልሶ “ኮና ይንችና ዳምንባብከስም ክድባብካንታ ክት ኬዝድን ር ዶቅድንካንታ ክደር የልስስካ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ዳምንባብከስም ገችዝድባበረ ይንችንም ዳምንባብከስም ክድባብደር የድሶ አርድንተካ “ዞከርስባብ ጳውሎስ እም ኤልሶ ኮና ይንችና የስካንታ ክት ኬዝድንዳ ር ዶቅድንካንታ የዝደር ክትም ተይᎺድንግንዳ እም ምክሴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ዳምንባብከስም ክድባበረ ይንችንታ አንንም የድሶ ኤድንከዘንካ Ꮊርሳ ይይሶ “የስ እካንታ ኬዝድንዳ ሪይና Ꮊረርየረ?” ጋየሮ ክትም Ꮊክ ኦይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ይንችነረ ኩን ጋይሴ፥ “አይሁድንከስ ጳውሎስታ ርን ኡርስት ኦይዝድም ካምስንካ ሰናካ ቡጫጋልተንከስካንታ ክትም የስ የልዝድንግንዳ የስም ኦይስካንታ ከታ ኤእተኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ኬዛርንካ ማቼ የና ከደር Ꮊይ ኤኤ፥ ክትም ደይሳኮትዶቆ እችም እጅዳኮቴ፥ ሎቀረ ዎጭዳኮቴ ጋይንተካ ክክ ጫቅስባብከስ ቃስተን ቦንደዘንካ ስግድን ኤድንከስ ክትም ደይሳካንታ ከዝምተኬ፥ ታ ከታ የስታ አፋርንካ ዉድንደትም Ꮊክ ካርሰኬ”። ");
INSERT INTO gyl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ዳምንባብከስም ክድባበረ “ኮርን እካንታ የስ ኬዛንደትም Ꮊየሰንካንተረ Ꮊይ ኬዜ” ጋይሶ ይንችንም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ኮታ ቡር ዳምንባብከስም ክድባብ በድ ፖልስንከስም ገችዝድባብከሳርንካ ቃስተንን ኤልሶ “ሶይትናርንካ ማከን ሳዓት ማድንካ ቅሳርያ ካተመናር አይድባብከስ ቃስተን ጸታ ዳምንባብከስኬ ማከን ቦንደኬ ታመካ ፋረካ አይድባብከስ፥ ካችምካ ዳምድባብከስመረ ቃስተን ጸታ ግግሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ጳውሎስካንተረ ፋራ ግግስሰኮ ፍጨንም ቆልድባብ ፍልክስደር ኡርመካ የልድንግንዳ ይከቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ኩን ጋይድን ክተረ ጻፍሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ቀላዉዶስ ሉስዮስዘንካ፥ ቦንችምስባብ ፍጨንም ቆልድባብ ፍልክስካንታ! ሳራትቼና የስካንታ ማታ! ");
INSERT INTO gyl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ኮ ኤችንም አይሁድንከስ የድሰኮ ደይዝደክዶቆ፥ እታ ማቼ ሮማ ፍጫ ኤድ ክታ ማትንተን እ ኤሳንጎካ ዳምንባብከስካ ክክን የልስቶ ክትም አቅሳቴ። ");
INSERT INTO gyl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ꮊራ ጎካ ኬት ክትም ካሰሳናነረ ኤስካንታ ዝግስቶ ከታ ቡጫ ጋልተንከዝደረረ ተይᎺትት ናና፥ ");
INSERT INTO gyl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ከት ክትም ካሰሳንደረ ከታ ህግንጎካ ማትንተን ኤሳቴ፥ ኬዛርንካ ማቼ ደእካንታ ናንከረ ዞክና ካንታ ክትም የልስዝድር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ኮ ኤችንም ደይሳካንታ ክታዘን ዙዝምሳንደትም እ ኤሰርሳንደትካ ሳነካ የዝደር ክትም ኦይቻቴ፥ ክትም ካሰዝድባብከሰረ ክታዘን ከታ ዶቅድን ክስን የስታ እሪ ከት ኬዝድንግንዳ ከትም ክትሳቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ኮካንታ ዳምንባብከስ ከት ክትምሳንግንዳ ጳውሎስም ሶይት ተይ አይሰኮ አንትጳጠርስ ጋይምድን ካርዘን ክትም የልስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ዛማክንከረ ፋረንክንባብከስ ጳውሎሰካ ክክን አይድንግንዳ ይሰኮ ከታ ዳምንባብከስ ይ ዶቅድን ሞረናር ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ፋረንባብከሰረ ቅሳርያ ካተመናር ከታ ይ የልሳንደትካ ጻፍምሳን ክተን ፍጨንም ቆልድባብካንታ እምሰኮ ጳውሎስም ክታ እሪ ዎይስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ፍጨንም ቆልድባበረ ጻፍምሳን ክተን ይ ናበብዛንደታ ቡር ጳውሎስም “የና Ꮊብር ፍጫርከረ?” ጋይሶ ክትም ኦይሴ፥ ኪልቅያ ፍጫ ኤድ ማትንተን ይ ኤሳንደትካ ");
INSERT INTO gyl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“የስም ካሰዝድባብከስ Ꮊዴ የስታ ኬዘንም ኤሰርትቴ” ክደር ጋይሴ። ሄሮድሰታ ጋስናር ክት ካርስምድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ዶንቅ ሰጨታ ቡር ቀሰንከስታ ገችንባብ ሀናንያ ዋልቃ ዋልቃ ጋልተንከስኬ ጠርጠሉስ ጋይምድባብ ቡካታ ማትሶ በርምድባብካ ክክን ቅሳርያ ካተመናር አይሰኬ። ከተረ ዎርሰን ገችዝድባብ ፍልክስደር Ꮊድሰኮ ጳውሎስም ካሰሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ጳውሎስ ኤልምሶ Ꮊዳንደትካ ጠርጠሉስ ኩንጋየሮ ካሰስን የጄ፥ “ቦንችምስባብ ፍልክሶ! የስ ጎካ በድ ሳራትቼን Ꮊፍቶቴ፥ ኡርመካ የስታ ገችና ዎንታ ዎርሰንካንታ ኦክም Ꮊፈርቴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","አንድር የና ቦንችምስባብ ፍልክሶ ኮም የስታ ኡርማ ይተንም ካር ሙደናርንኬ ሰጫ ሙደንካ ዎ ተይድንዳ ጬክን ጋይሳን ጎፍስኬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ታ ማቼ ሳዓትንም በይሳክት ዶቆ ጬድካ እ የስም ኬዝድንደትም የስታ Ꮊልስምንካ የስ ዎንደር ኤሰርድንግንዳ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ኮና ኤችና ዳቅል ሰቅም ዎንዘን ማቴ፥ ፍጫሙደንዘን ዶቅድባብከስ አይሁድ ሙደንታዘን አዉልም አምስዝዴ፥ ናዘራኖቴ ጋይምድባብከስታ ኖ ጎርስንባቤ። ");
INSERT INTO gyl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ሳብታ ጭል ኤሄንመረ ቱና ማስካንታ ክት ይድንካ የቶቴ፥ ዎንታ ህግንግንዳ ክታዘን ፋረድካንታ ገቀርቶት ዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ኬዛር ማቼ ዳምንባብከስም ክድባብ ሉስዮስ Ꮊድሶ አንድር ዎልቀካ ዎንታ አንናርንካ ቡርትዮ ክትም ተዬ። ክትም ካሰዝድባብከሰረ የዝደር ኬት Ꮊድንግንዳ ክትሴ፥ ");
INSERT INTO gyl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ኮም ክታዘን ዎ ሳንሳን ካሰስን ሙዳ ዶፈን ማትንተን የና የስታ ማታርንካ ክትም ኦይስሰዮ ገታ ማትንተን ኤስካንታ ማደዬ”። ");
INSERT INTO gyl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","አይሁድና “ኮና ሙዳ ሪይና ዶፈኔ” ጋየረኮ ካሰስንካ ኤእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ፍጨንም ቆልድባብ ፍልክስ ይንታ አንካ ሰችሶ ጳውሎስ ኬዝድንግንዳ ክትም ጋይሴ፥ ጳውሎሰረ ኩንጋየሮ ማስሴ፥ “በድ ስለንከስካንታ ኮ ዎርሰንዘን ፋረድባብ የስታ ማትንተን እ ኤዝድንጎካ እዝደር Ꮊዳን ክስንታ እስታ ማስን የስታ እሪ እ ኬዝድንካ አንድር እም ጉርምዝዴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ሳብም ጎይንካንታ የሩሳሌም ካተመናር እ አይስንካ ታመኬ ቃስተን ሰጨዘንካ ስግዳክንደትም የና የስታ ማታርንካ ኤስካንታ ማደዬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ሳብታ ጭል ኤሄናረረ ማታ አይሁድንከስታ ምክስ ኤሄናር አነረ ካተመናር Ꮊየንከረ ክክን በርምድንካ ናነረ ዎርሰን አዉላ ካንታ እ አምስዝድንካ እም Ꮊፋከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ታ እም ከት ካሰሳን ክስንታ ሙዳ Ꮊረነረ ማርካ ተይᎺድካንታ ማታየኬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ኬዛር ማቼ ኮም የስካንታ መያ ማስካንታ ሶልምድቴ፥ ከታ ኮተርዝድን ጎግዬ ጋይድንደትም አሜንካ ዎንታ ባቤንከስታ ጮይስን ጎይንድቴ። ሙሴታ ህግንጎኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ማጻፍንከሳር ጻፍምሳንደትመረ ሙደን አመንድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ከተረ Ꮊድን ጉርም ይድንደትግንዳ እተረ ጭልንባብከስኬ ጎመንባብከስ ደእያርንካ ከት አምድንደትም ሳብካ Ꮊድን ጉርም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ኮካንታ ሳብተኬ ኤተካ እሪ ጭለጭል ገቅር እስታ ዶቅድንግንዳ ሙዳᎺይካ ጉርድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“የሩሳሌም ካተመናርንካ እ ዉተድንካ በድ ስለንከስ ስገዳን ቡር እስታ ኮችንከስካንታ ማድን አላ ብረንኬ ሳብካንታ እምምድን እመን የድስቶ Ꮊዳቴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ሳብታ ጭል ኤሄናረረ እም ከት Ꮊፍሳንዳ ኮም እ ይድንኬ፥ ኮትᎺይካ አርንታ ዎገንም ቦትቴ፥ እንካ ክክን በድ ዎርሳ Ꮊቃክዬ፥ አዉለረ አማክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ኬዛር ማቼ እስያ ፍጨናርንካ Ꮊድባብ አይሁድና ኮታር Ꮊቀኬ፥ ከታ እም ካሰዝድንዳ ዶቅሴ የስታ እሪ Ꮊድሰኮ ከት ኬዛ። ");
INSERT INTO gyl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","አነረ ቡጫጋልተንከስታ እሪ እ ዎእሳንደትካ እ ይሳን ዳቀልስ ዶቅድንደትም ኬና Ꮊድባብ ኤድንከስ ኬት ኬዛ። ");
INSERT INTO gyl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ገታ ከታ ዎክያር ዎእስቶ ‘ደእስባብከስታ አምንታ ዶቅዴ እስታ ጋይንተንካ ታካ ፍርዳ ኤስርካንታ የንታ እሪ Ꮊትቴ’ ጋይስቶ ጬክን ጋይሳን ኡፍስካ ኬዝትቴ፥ ኮዘንካ አብ እ ይሳን ር ካዬ።” ");
INSERT INTO gyl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ፍልክስ ማቼ አሜንንጎካ ኡርስት ኤዝድንካንታ “ዳምንባብከስም ክድባብ ሉስዮስ Ꮊዳንደትካ የንታ ኬዘንጎካ በእንተንም ኬዝድቴ” ጋይሶ ከትም ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ጳውሎስም ካርሰሮ Ꮊቅባብ ዳምንባብከስም ገችዝድባብመሬ “በደረ ኡንእምሳከይ ዶቆ ክትም ካርስካ፥ ክታ ገርነንከሰረ ክትም ዝግዝድንደትም ሙዳ የድሰኮ ከት Ꮊድንካ ከትም Ꮊይማሬ” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ቶክም ሰጨታ ቡር ፍልክስ ድርስላ ጋይምሳን አይሁድ ማቻን ኬነንካ ክክን Ꮊዴ፥ ጳውሎስመረ ኤልስሶ የሱስ ክርስቶሳር አሜንድንጎካ ክት ኬዝድንካ ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ጳውሎስ ጭላትቸንጎከ ኤድ ይንታ ማተም ቆልንጎካ፥ Ꮊድን ፍርደንጎከረ ክት ኬዛንደትካ ፍልክስ ጳስሶ “ታ አይካ፥ እም ኡርሴ አብ ሰጫᎺይካ የስም ኤልስዝድቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ፍልክስ ጳውሎስዘንካ ጉባ ተይካንታ ዝግሶ ጉርም ይድ Ꮊቄ፥ ኮካንታ በድᎺይካ ጳውሎስም ኤልስሰሮ ክትም ከስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ቃስተን ስለታ ቡር ጶርቅዮስ ፍስጦስ ፍልክስታ ካርያር ማቼ፥ ፍልክስ አይሁድንከስም ጉርምስካንታ ዝግሶ ጳውሎስም ክት ዞከርሳንግንዳ ክትም ዛቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ፍስጦስ ይ ቆልድን ቅሳርያ ፍጨናር አርድሶ ማከን ሰጫ ዶቅሳን ቡር ኮታርንካ ኦስ የሩሳሌም ካተመናር ዉተዴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ዋረረ ቀሰንከስም ገችዝድባብከስኬ ዋልቃ ዋልቃ አንድር ኤስምሳን አይሁድንከስ ጳውሎስም ካሰስን የጀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“ጳውሎሰም የሩሳሌም ካተመናር ተይᎺችካ ዎካንታ ኡርማ ርን ይካ” ጋየረኮ ክትም ምክሴ፥ ኮመረ ከት ጋይሳንዳ ጳውሎስም ጎግዘን Ꮊፍሰኮ ደይሳካንታ ዝግዘኬ ");
INSERT INTO gyl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ፍስጦስ ማቼ “ጳውሎስ ቅሳርያ ፍጨናር ዞክና ኤሄናር ካርስምቴ፥ እተረ ታ ሳነካ ማትስቶ ኦስ ኮታር አይድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","የንታ ገችንታ ኤረንባብከስ እንካ ክክን ቅሳርያ ካተመናር ከት አያ፥ ጳውሎስ ይሳን ዳቀልስ ዶቅሴ ኮታር ክትም ከት ካሰሳ” ከትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ፍስጦስ ላማካይ ናነረ አና ታማ ሰጨዘንካ ስጋክን ከትካ ክክን ስክሳን ቡር ቅሳርያ ፍጨናር አይሴ፥ ኮታር ይ የልሳንደትካ ዛማክንካ ፍርዳ ጎንገንዘን ዶቅሶ ጳውሎስም የትይ ተይᎺድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ጳውሎስ Ꮊዳንደትካ የሩሳሌማርንካ Ꮊድባብ አይሁድንከስ ክታ ካንተንካ ክርክርሳ ዎእሰኮ ማርካ ክታዘን ከታ ይ Ꮊብዳክንደትም በድ አንድርካ ካሰሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ጳውሎሰረ “እታ አይሁድንታ ህግንዘነረ ማት ሳብታ ጭል ኤሄናር አነረ ሮመታ ባንችንዘን እ ይሳን ዳቀልስ ካዬ” ጋየሮ ይ ካሰስምሳንደታ ማስንም ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ፍስጦስ ማቼ አይሁድንከስም ጉርምስካንታ ዝግሶ ጳውሎስም “ኦስ የሩሳሌማር አይሳዮ ኮ ኬዘንጎካ ኦኮታር እስታ እር ፋረድምካንታ ዝግዳ?” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ጳውሎስ ማቼ ኩንጋየሮ ማስሴ፥ “ይና! እታ ፋረድም ካንታ ዝግዝድንደትም ሮማ ባንችንታ ፍርዳ ጎንገንታ እር ዎእትቴ፥ የነረ ኡርስት የስ ኤዝድንደትግንዳ አይሁድንታዘን እ ይሳን Ꮊረነረ ዳቀልስ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ዳቀልስባብ እ ማቼ አነረ ደእካንታ እም የልስዝድንዳ ዳቀልስ እ ይሴ ደእዘንካ አቅትቴ ጋያይቴ፥ ኬዛር ማቼ ከታ ካሰስና ዉችኩን ኮት ማቼ Ꮊየነረ ከትካንታ ስክስት እም እምካንታ ማታዬ፥ እታ ሮማ ባንችንደር ይግባይን ኦይስትቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ኮታይካ ፍስጦስ ክትም ዞርድባብከስካ ክክን ኬዝምሶ “ሮማ ባንችንደር ይግባይን የስ ኦይስንካ ባንችንደር አይተራዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ቶክም ሰጨታ ቡር አግርጴኬ በርንቀካ ፍስጦስም “ባካ ኡርመካ Ꮊዳየ” ጋይካንታ ቅሳርያ ፍጨናር Ꮊደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ኮታረረ በድ ሰጫ ከታ ዶቅንተንካ ፍስጦስይ ጳውሎስታ ርን ኩንጋየሮ ባንችን አግርጳካንታ መያ ማስሴ፥ “ፍልክስ ዞክሶ ክት ዛቅስባብ ካሪ ዋልቃ ኤድ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","እታ የሩሳሌም ካተመናር እ ዶቅድንᎺይካ ቀሰንከስታ ገችንባብከስኬ አይሁድንታ ጋልተንከስከ ኮ ኤችንታ ይተንጎካ እዝደር ኬዝሰኮ ክታዘን ፋረድምድንግንዳ እም ኦይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","እታ ማቼ ‘ካሰስምስባብ ካሰዝድባብከስታ እሪ ዎእሶ ይ ካሰስምሳን ሪንታ ማስን ክት ኬዛክናና ካሰስምስባብም ስክስት እም ሮማ ኤድንከስታ ዎጋ ካዬ’ ጋይስቶ ከትካንታ ማስሳቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ኮካንታ ክትም ካሰዝድባብከስ ሳንምሰኮ ኮር ከት Ꮊዳንደትካ ጋምአክትዶቆ ዛማክንካ ፍርዳ ጎንገንዘን ዶቅስቶ ጳውሎስም እስታ እሪ ከት ተይᎺድንግንዳ ክትስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ክትም ካሰዝድባብከሰረ ኬዛካንታ ክታ ባንግር ከት ዎእሳንደትካ እታ ዳቅልር ኖ ፍክስቴ ጋይስቶ እ ገቀርሳንከካ ክትም ካሰስካንታ የልስዝድንዳ Ꮊረርየረ ክታዘን ተይᎺዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ኬዛር ማቼ ክትካ ክክን ከት በርማቃንዳ ከታ ይንታ አሜንንጎከኬ ደእስባብ ኤችን የሱስጎካ ጳውሎስ ማቼ ‘ኖ ሰንፔካ ዶቅዴ’ ክት ጋይድንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","እተረ ኮትኮግንዳ ርን ኦይስት የልና እም ማእሳንካንታ ጳውሎስም ‘ኦስ የሩሳሌም ካተመናር አይሳዮ ኦኮታር ኮርንካ የና ፋረድምካንታ ሶልምዳ?’ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ኖ ማቼ ክታ ሪና ሮማ ባንችንደር ሰድምድንግንዳ ዝግሶ ባንችንደር ይግባይን ክታ ኦይስንተንካ ኦ ኮታር እ ክትም ኦይተርን የለልታ ዞክና ኤሄናር ክት ዶቅድንግንዳ ክትስቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","አግርጰረ ፍስጦስም “እተረ ኮና ኤችና ኬዝድንካ ኤስርካንታ ዝግድቴ” ክደር ጋይሴ። ፍስጦሰረ “ሰናካ የና ኤሰርተረዬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ኮካንታ ዛማክንካ አግርጰከ በርንቀካ ባንችምንታ አፍለን ቆበርሰኮ አንድር መነካ ማትሰኮ ዳምንባብከስም ገችዝድባብከስኬ ካተመናር አንድር ኤድንከሰረ ዙግርሶ Ꮊድሰኮ ፍርደን እመርድን ኤሄንባከናር አርደደኬ። ኮተረ ቡር ፍስጦስይ ጳውሎስም ኤልስሴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ኩነረ ጋይሴ፥ “ባንችን አግርጶ! የተረ ዎንካ ክክን ዶቅድባብ ኤድንከስ ሙደና! አይሁድና ‘ኮና ኤችና ይና ኮዘንካ ሰንፔካ ዶቅ ክትም ዝግሳዬ’ ጋይንተካ ፍፈረኮ የሩሳሌም ካተመናረረ፥ ካረረ ክታዘን ፋረድምድንግንዳ እም ከት ምክሳንዳ ኮ የ ሰድን ኤችንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","እታ ማቼ ደእ ክትም ዝግዝድንደትም Ꮊረነረ ዳቀልስ ክታዘን Ꮊፋክቴ፥ ኖ ሮማ ባንችንደር ይግባይንን ክት ኦይሳንደታ ኦ ኮታር ኦይትካንታ ገቀርሳቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ማታጋካ ዳት ክትጎካ እስታ ማታቆልስባብካንታ እ ጻብድንዳ መያ ማቻን ር እካንታ ካዬ፥ ኮካንታ ኤችና ክት ኦይስምሳንደታ ቡር እ ጻብድንደትም Ꮊፍትት ዶቅተሬ ጋይስቶ የንታ እሪ ስግስሰረ ባንችን አግርጶ! የስታ እሪ ክትም ተይᎺትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ዞከርስባብም ዘርመካ ዶቅድባብደር ኦይትምድዮ፥ ክት ካሰስምሳንደትም መያ ማስክሳ ነግና ዳችርም ካምሶ እካንታ Ꮊፈርቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","አግርጳ ጳውሎስም “የስታ ማታ ካንታ የስ ኬዝድንግንዳ የስካንታ ጋይምቴ” ጋይሴ። ጳውሎሰረ ይንታ አንንም አምስሶ ኩንጋየሮ ማስ ኬዘንም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","የና ባንችን አግርጶ! አይሁድና እም ካሰሳን ርንካ ሙዳ ታካ የስታ እሪ እስታ ማስ ኬዘንም እ እምድንካ አንድር ጉርምዝዴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","አብንዘንካ ስግስሶ የስ አይሁድንታ ዎገንምከ ቤርምን ሙዳ ኡርስት ኤዝደዬ፥ ኮካንታ ዳንዳእካ የስ እም ኤሰርድንግንዳ እታ የስም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“እስታ ይንችርንካ የድስቶ Ꮊስግንዳ እ ዶቅሳናንከረ አይሁድና ኤዝደኬ፥ ኤና እርንዘንካ አምስሶ እስታ ዎርሰንታ ዎክያርኬ የሩሳሌም ካተመናር እ ዶቅሳንደትም እስታ ዶቅንተን ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ጉጅሰረ ማርክር ካንታ ኬት ጋይዴ ዎንታ አመንናር በድ ዎገንም ጫልዝድባብከሳር ፈረሳዊን ማትስቶ እ ዶቅሳንደትም እርንደትዘንካ አምስሰኮ ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ታ ማቼ እዘን ፍርደን ኤስርካንታ ካር እ ዎእሳንዳ ሳብ ዎንታ ባቤንከስካንታ ክት እምሳን ጫቃ ቃለንታ Ꮊድን ጉርምጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ኮትኮ Ꮊድን ጉርምንደር የልካንታ ታመኬ ቃስተን አጥርንከስ ሳብም Ꮊየከ ሶይትካ ክትም ጎይነረኮ ካርዝድ Ꮊቀኬ፥ ባንችኖ! እተረ አይሁድንከስካ እ ካሰስምሳንዳ ኮትኮ Ꮊድን ጉርምንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ሳብ ደእስባብከስም አምዝድባብ ማትንተና Ꮊረተረ የ አመንዳክንደትግንዳ ይሳንደና?” ");
INSERT INTO gyl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“እታ እስታ ማታርንካ ናዝረትንክንባብ የሱሰታ ላምን እዝደር ማድንከካ ግር እም ዝግዝዴ ጋይስቶ ገቀርድ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","የሩሳሌም ካተመናር እ ይሳንደረ ኮትኮም Ꮊቄ፥ ቀሰንከስታ ገችንባብከዘንካ እ ተያን ገችታ ኤረንካ አሜንድባብከሳርንካ በድንከስ ዞክና ኤሀር አርድንግንዳ ይስስትቴ፥ ከትም ከት ደይዝድንከረ ከትም ደይዝድባብከስከረ ክክን ኤእትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","በድᎺይካ አይሁድንታ ምክስ ኤሄናር ከት ሰርምድንግንዳ እስታ ይይንተና ጮይስዘን የክካ ከት ኬዝድንግንዳ ከት ሶልማክናና ይስዝድ Ꮊቃቴ፥ ከታዘነረ በድ ዋጭስቶ አብንከዝደር ኦስ ጎት ፍጨንከስታ ካተመናር ዉትስቶ አይድዮ ዎራ ከትም ዳይድቶ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ኮርንታ ቄሰንከስም ገችንባብከዘንካ ገችታ ኤረንምኬ ክተንም ሙዳ ተይስቶ ኦስ ደማስቃር እ አይድንካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ባንችኖ! እታ ጎግዘን እ ዶቅድንካ ገታ ቶርማ ቶህ ጋይድንካ Ꮊይታ ሳክመዘንካ ስገድን ሳክማ ሰድቴ፥ ኮነረ ሳክመና እስተኬ እንካ ክክን ሙካዶቅድባብ ኤድንከስታ ካንተካ ጭላርንካ ሳክሴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ዎታ ሙደነረ ፍጨዘን ዋችሶቶ ዎ ዶቅድንካ እብራይስጥ አፈካ ‘ሳዉሎ! ሳዉሎ! Ꮊረተስ እም ዳይዳ? እግድን Ꮊሰርሳን ሶለን የስ ግርዴ የስታ ማተንም ኡፈልዝደዬ’ ጋይድን ኡፍስ ኤሰርሳቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","እተረ ‘ጮይስዮ! የና Ꮊይራ?’ ጋይሳቴ፥ ጮይሰረ ኩን እዝደር ጋይሴ፥ ‘የስ እም ዳይድባብ እታ የሱስቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ታ ማቼ አምሰዮ የስታ ዱትንካ ዎእካ፥ እ የስካንታ መያ ማቻንዳ ታ እም የስ ሰዳንደትዘንከ ኦስ እረረ እታ የስካንታ መያ ማዝድን ርንካ ሳብታ ፍክስንባብኬ ማርካ እካንታ የስ ማድንግንዳ የስም ዶርትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","እስራኤል ዎርሰንዘንኬ ከደረረ እ የስም ኦይድን አይሁድ ማታክባብከስታ አንናርንካ የስም አቅዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","አፍን ከታ የስ ፎጅድንግንደኬ ኡምናርንካ ፈንክ ሳክመናር ከትም የስ ዉጅድንግንዳ ሰጣን ከትም ቆልሳናርንካ ፈንክ ሳብደር ከትም የስ ማዝድንግንዳ የስም ዶርድቴ፥ ከተረ እንካ አሜንምንጎካ ይንታ ጎመንታ ነገትቼን Ꮊፍተረኬ፥ እድምስባብከስታ ዎክያረረ ባእንም ካስምደኬ’። ");
INSERT INTO gyl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ኮካንታ ባንችን አግርጶ! ጭለዘንካ እካንታ እምምሳን ለምለም ጋይድንካ እ ሰዳንደትም ዋይቴ ጋያክቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ኬዛር ማቼ እርምስቶ ደማስቃ ካተመናር ዶቅድን ኤድንከስ፥ ኮታዘንከረ የሩሳሌም ካተመናርኬ ይሁዳ ፍጨናር ሙዳ ዶቅድባብ ኮትኮግንደረ አይሁድ ማታክባብከሰረ ጉጅሶ ጎማ ይንታ ፍክስን ዎይስሰኮ ሳብደር ከት ማድንግንዳ እታ ከትም ኤስሳቴ፥ ጎማ ይንታ ፍክስንም ዎይስን ሰችዝድን ር ኬት ይተርን ግንደረ ኤስስትቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ኮትኮጎካ አይሁድና ሳብታ ጭል ኤሄናር እ ዶቅድንካ እም የድሰኮ ደይሳካንታ ጉርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ታካ የለልታ ሳብታ አለና እዘንካ ፋስማክዬ፥ ኮካንታ መረንካንተኬ አንድርንካንታ ማርከረርቶ ካሪ ዎእሳቴ፥ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስኬ ሙሴካ እርምሰኮ ኩን ማተረ ከት ጋይሳንደትም ኬዘንዘንካ አብ Ꮊረነረ ኬዛክቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ከተረ ኬት ኬዛንዳ ‘ክርስቶስ ማጠንም ተይተሬ፥ ደእናርንካ አምንተከረ እርንባብ ማትሶ አቅንተታ ሳክመን እስራኤል ዎርሰንካንተኬ አይሁድ ማታክባብከስካንታ መያ ማዝዴ’ ጋይሴ”። ");
INSERT INTO gyl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ጳውሎስ ኮም ኬዘሮ ክት ዶቅድንካ ፍስጦስይ “ጳውሎሶ! ታ የና ዛዘርሰዬ፥ በድ የስታ ኤስና ዛዝርዘን የስም የልስሴ!” ጋየሮ ፍፍሶ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ጳውሎስ ማቼ ኩንጋየሮ ማስሴ፥ “አንድር የና ቦንችምስባብ ፍስጦሶ! ዶፈንንከ ገታ ማቻንደት ርም ከዝድት ዳት እታ ዛዘራክቴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ክታ እሪ መየካ እ ኬዛንደትም ባንችና ኮም ርን ኤዝዴ። ኮነረ አቼካ ይማክንዳ ማቻንካንታ ባንችና ኮም ክት ኤዝድንደትም እካንታ ኤስምዴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ባንችን አግርጶ! ሳብዘንካ ኤሰርሶ ኬዛቅባብከስም አመንደይ ካያ? የስ አመንድንደትመረ ኤዝድቴ”። ");
INSERT INTO gyl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","አግርጰረ ጳውሎስም፥ “የና ኮ ቶክም ሳዓትናር አሜንድባብ እም ማስካንታ ዳት” ክትም ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ጳውሎሰረ “ቶክም ሳዓትንከረ ማታ በድ ሳዓተረ የና Ꮊክ ማታከይ ዶቆ ታካ እስታ ኬዘንም ኤሰርስባብ ሙደና ኮ እስታ ዞክርንዘንካ አብ እግንዳ ከት ማድንግንዳ ሳብም ምግዝድቴ!” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ኮታ ቡር ባንችና፥ ፍጨንም ቆልድባብከ ባርንቀካ፥ ከትከረ ክክን ዶቅሰኮ Ꮊቅባብከሰረ ኤድንከስ ሙደና አምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ኮታርንከረ ዉትሶ አይደኮ፥ “ኮና ኤችና ደእካንታ አነረ ዞክርካንታ ክትም የልስዝድንዳ Ꮊረነረ ር ይያክዬ” ክክ ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","አግርጰረ ፍስጦሰም “ኮና ኤችና ሮማ ባንችንደር ይግባይን ክት ኦይሳከስናና ዉቺ ቡልምካንታ ማዳዶቆ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ኦስ ኢጣልያ ፍጨናር ሎቀዘንካ ቃልዝድን ማርከብንካ ዎ አይድንግንዳ ኬዝምሳንደትᎺይካ ጳውሎስምኬ አብንከስ ዞከርስባብከስም አዉግስጦስታ ዳምንባብከሳር Ꮊቅባብ ዮልዮስ ጋይምድባብ ፖልስንከስም ገችዝድባብካንታ ከትም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","እስያ ፍጨናር ባሀርንታ ካንተዘን ዶቅድን ጎግንከዘን አይድን አድራምጥዮን ካተመንታ ማርከብናር አርድሶቶ አይ የጆቴ፥ ተስሎንቃ ካተመናር ዶቅድባብ መቅዶንያ ኤችና አርስጥሮኮሰረ ዎንካ ክክን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ዛማክንካ ኦስ ሲዶና ካተመናር የልሶቴ፥ ዩሎስ ጳውሎስካንታ ላቅም ኤድ ይማቻንጎካ ክታ ገርነንከዝደር አይሶ ክትም ዝግዝድንደትም አለንም ክትካንታ አልድንግንዳ ከትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ኮታርከረ አምሶቶ ዞገና ዎንታ እርጎካ ዞገሮ Ꮊቃንካንታ ሎቀንታ ዎክያር ዶቅድን ቆጵሮስ ደንን ኮታዘን ገክንሶቶ ማርከብንካ ዎንታ አይንም የጆቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ክልቅያርኬ ጰነፍልያ ፍጨንታ ላማር ዶቅድን ባሀርን ዎ ቃልሳን ቡር ልቅያ ፍጨናር ዶቅድን ኦስ ሙራ ጋይምድን ካተመናር የልሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ኮታር ፖልስንከስም ገችዝድባብታ ኦስ ኢጣልያ ፍጨናር አይድንዳ እስክንድርያ ካተመንታ ማርከብን Ꮊፍሶ ኮታር ዎ አርድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","በድᎺይካ ዳልግሳ ሙክሶቶ በድ ማጠካ ቀንዶስ ካተመንታ ላማር የልሶቴ። ዞገነረ ኦስ እሪ ዎ አይዳክንግንዳ ዎም ማርሳንካንታ ሰልሞና ካተመንታ ላመካ ስግሶቶ ቀርጤስ ሎቀንታ ግድናር ደንንካ ገክንሶቶ አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","በድ ማጠካ ካንተን ካንተንካ ዎ ስገዳን ቡርጎካ ላስያ ካተመንታ ላማር Ꮊፈርድን ማርከብን ዎእድን “ላቅም ካርዬ” ጋይምድን ካርዘን የልሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ዎንታ ሙክንትንዘን በድ ሳዓት ስገዳንጎኬ በቼካ ምክሰርድንደታ ሰጨና ስገዳንካንታ ኮትኮᎺይካ ባሀርንዘንካ አይና አንድር ዘርዝድንዳ ማቻንጎካ ጳውሎስ ኤድንከስካንታ ኩንጋየሮ ከትም ኤግዝምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“የታ ኤድንከሶ! ይና ኮዘንካ ኦስ ዎ አይድንደታዘን ዘርዝድንዳ ዶቅድንደትም እዝደር Ꮊፈርዴ፥ ጫነርሳን ርንዘንከ ማርከብንዘንካ Ꮊክ ማታክናና ኤታ ሰንፔዘነረ አንድር ኡፈልዝድንደትኬ ካይንተረ የልዴ”። ");
INSERT INTO gyl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ፖልስንከስም ገችዝድባብ ማቼ ጳውሎስታ ዞረንዘንካ ስግ ማርከብን ክድባብተኬ ማርከብንታ ባቤና ኬት ጋይድንደትም ኤሰርድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ናኮና ጎግንዘን Ꮊዉስ ካርና በርግን ስግስካንታ ኡርማ ማታክንኦል በድ ኤድንከስ “ጎግንም አይደኮ ከደር ማደስናና ዘርመርጎኬ ታማርጎካ የረየር ዶቅድን ፍንቄ ፍጨናር ቀርጤስ ማርከብን ዎይሰርድን ካርንዘን የልሶቶ በርግንም ኮታር ዎ ስክሳ” ጋይሰኮ ኬዘኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","መርሳ ታማርጎካ ዞገና ዞግድንካ ከታ ይ ሰዳንደትካ ኬት ገቀርሳንግንዳ ከትካንታ ማቻን ካምስንካ ማርከብን ዎይስዝድን ሪን አምስሰኮ ጎግንም አይ የጀኬ፥ ማርከብን ዎይሰርድን ካርንዘንከረ አምሰኮ ቃርጠስ ሎቀንታ ዎክናር ዶቅድን ደንንታ ካንተካ ስገደኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ኬዛር ማቼ ቶክም ሰጨታ ቡር “ዘርመርጎካ Ꮊይታ ዉትንታጎካ ቡርበች ዞገና” ሎቀንታ ዎክናር ደንንዘንካ አምሶ ባሀርንዘን ከደር Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ማርከብነረ የረየር Ꮊድን ዞገንካ Ꮊቅምሳንካንተኬ ዞገንም ዎይስካንታ ከደር ማታክን ካንታ ጫምን ጋይሶቶ ዞገንካ Ꮊንቅመሮቶ አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ሎቀንታ ዎክናር ዶቅድን ቄዳ ጋይምድን ደንን መረን ገክንሶቶ ዎ አይድንካ መራ ዞገና አንድር ዘርዝድንካ ማርከብንካ ክክን ዶቅድን መራ ጃልበን የድሶቶ አቅሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","መርከብናርንባብከስ ጃልበንም ማርከብንደር ጎችሶ ዉችሳን ቡር ማርከብንታ ካንተካ ዛንም ላጨኬ፥ ማርከብና ሱርትስ ጋይምድን ሻምይ ካርያር ዋጅዳክንግንዳ ጳስሰኮ ሻረን Ꮊንችሰኮ ዞገካ በይመረኮ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ቡርበች ዞገና ዎንዘን ዳቀሮ Ꮊፈርሳንጎካ ዛማክንካ ማርከብንዘን ዳርጵምሳን ርንከሳርንካ ዋልቃ ዋልቀን ባሀርናር ኦይት የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ማክምስ ሰጨንከረ ማርከብንካንታ ፍግዝድንደትም ርን ከታ ይንታ ገታ አንንካ ሎቀናር ዛቅት ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","በድ ሰጫካንታ Ꮊይ ዉተዴ፥ ቤዝንከስ Ꮊፈራክንካንተኬ ዞገነረ ዎንዘን ዳቀሮ አይሳን ካንታ ይና ኮዘንካ ኦስ ዎንደር አቅምዳክዬ ጋይሶቶ ዎንታ ጉርምን ተቾቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ኤድንከስ Ꮊረነረ እችም እቻክዶቆ በድ ሰጫ ዶቅሰኬ፥ ኮካንታ ጳውሎስ ከታ ዎክያር ዎእሶ ኩን ጋይሴ፥ “የታ ኤድንከሶ! እ የም ጋይሳን ኤሰርሰቶ ቃርጠሳርንካ የ አማከስናና ኮና ሙዳ ኡፍልንከ ካይንተንከ የም የልተራክ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ታየረ ማርከብና Ꮊክ ኡፈልተራ ዳት የንታ ዋርንካ Ꮊየንዘነረ ካይንተና የልዳክዬ፥ ኮካንታ ዳእከቴ፥ Ꮊይጳሰቴ! ጋይስቶ የም ዞርድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","እታ ክታ ማችባብኬ፥ እ ጎይንድባብ ጮይስና ናካ ሶይት ክት ኦይቻን ክታይንችና እስታ ላማር ዎእሶ፥ ");
INSERT INTO gyl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘ጳውሎሶ! Ꮊይ ጳሴ! ሮማ ባንችንታ እሪ የስም ዎእንት ዝግዝዴ! ይና የስካ ክክን አይድባብከስመረ ሙዳ ሳብ የስካንታ ጋይሶ ደእያርንካ ከትም አቅዝዴ’ ጋይሶ እካንታ ከዝቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ኮካንታ የታ ኤድንከሶ ዳእከቴ! ሳብ ኮም እካንታ ኬዛንደትም Ꮊረነረ ነግሳክዶቆ ክት ቦድንደትም አመንድቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ማችንከረ ዞገና ዋልቃ ሎቀንታ ዎክያር ደንንታ ካንታር ተይ አይሶ ዎም ዛቅዴ”። ");
INSERT INTO gyl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ታመኬ ኦይችምስ ሰጨንካ ሶይት አድርያ ባሀርናር ዞገንካ Ꮊቅመሮቶ ዎ አይድንካ ሶይት ገልትገር ማርከብናር ፍክስንባብከስ ፍጨዘን ከደር የልምሳን ካምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ኮካንታ ባሀርንታ ጎርና የርክሰርድን ዛንንዘን ሰይን ዞክሶ ኬት ኦይድንካ ኦይድ ቦንዳ የርጋ ማድንዳ ማትሶ Ꮊፈርሴ፥ ቶክም ዶቅሰኮ የርክሰርድንደትም ካርንካ ኬት ኦይድንካ ማከን ቦንዳ የርጋ ማታባብ ጎር ማችንካ Ꮊፍሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ዎንታ ማርከብና ባሀርንታ ካንታ ዶቅድባብ ሰይንንከስካ ባዉጭምዳክንግንዳ ጳስሰኮ ማርከብንታ ቡርጎካ ኦይድ ማርከብን ዎይስስዝድን ስብልንከስም ባሀርናር ኦይቸኬ። ኮታ ቡር ሶይትና ከታዘንካ ስግሶ Ꮊየክና ከትካንታ Ꮊድንግንዳ ምክስ የጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ማርከብናር ፍግዝድባብከስ ማርከብናርንካ ዉትሰኮ አጥም ካንታ ዝግዛንጎካ ማርከብንታ እርጎካ ማርከብን ዎይስዝድባብከስ ኦይድ ስብልንከስ ካምስንካ ማርከብንታዘን Ꮊቃንደት ጃልበን ባሀርናር ኦይቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ኮትኮᎺይካ ጳውሎስ ፖልስንከስም ገችዝድባብከስምኬ ዳምንባብከስም “ኬና ማርከብናር ፍግዝድባብከስ ማርከብንታዘን Ꮊዉስሶ ከት ዶቃክንዳ ማቼ የታ አቃየቴ” ከደር ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ኮካንታ ዳምንባብከስ ጃልበንም የጃን ዛንንም ተችሰኮ ሎቀንዘን ላግድንግንዳ ዛቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ፍጨና ሰጭካንታ ይድንካ ሙደነረ እችም ከት እጅድንግንዳ ጳውሎስ ከትም ምክሴ፥ ኩነረ ከትም ጋይሴ፥ “Ꮊረነረ እችም አፋር ባራከትዶቆ የ ካርዝድንካ ታሜከ ኦይድ ሰጫ ስክስተቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ኮካንታ እችም የ እችተርንግንዳ የም ምግዝድቴ፥ ኮነረ ዳቅንታ የካንታ እምዴ፥ ይና ኮዘንካ ቦድሶ Ꮊረነረ የንዘን ኡፈልዝድን እር የልዳክዬ”። ");
INSERT INTO gyl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ኮመረ ይ ጋይሳን ቡር እችምን አምስትዮ ሙደንታ እር ሳብንም ጋለቼ፥ አስተረ እች የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ኮትኮም ክት ይድንካ ሙደነረ ዳቅሰኮ እችም እቸኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ማርከብንታ ዋር ሙደና ቃስተን ጨተኬ ማከን ቦንደኬ ታሜኬ ላ ኤድንከስ Ꮊቆቴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ሙደነረ እችሶ ከት ምሳንደታ ቡር ዳርጵምሳን ዘርግንም ባሀርናር ኦይትንተካ ማርከብንታ ደጭምና ላዉን ጋይድንግንዳ ይስሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ፍጨና ሰጭድንካ ከታ ይ የልሳን ካርንም ኤሳከኬ፥ ኬዛር ማቼ ሻም ዶቅድንደትም ባሀርንታ ካንተን ሰደኬ፥ ከደር ማደስ ናና ማርከብን Ꮊንቅሰኮ ኦስ ካንተዘን ዉችካንታ ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ማርከብን ዎይዝድን ስብልንከስም ብልሰኮ ባሀርንታ ዋር ከትም ኦይቸኬ፥ ኮታይከረ ሎቀንም Ꮊንቅድንደታ ዛንንመረ ብልሰኬ፥ ኮር ጎካ ዶቅድን ሻረንም ዞገንዘን ጬክሳ ይይሰኮ ባሀርንታ ካንተዘን ዉትካንታ አይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ኬዛር ማቸ ማርከብና ሻምን ሳንሳንደትካ ክክን ባዉጭምሶ አፍ ጩላ ዋቼ፥ እርጎከረ ጩላ ቶስምሶ ሶግዳክንዳ ማቼ፥ ቡርጎክንዳ ማቼ ሎቀንዘን ዞገንታ Ꮊቅነዘንካ አምሳንዳ ቁንጭም የጄ። ");
INSERT INTO gyl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ዞከርስባብከሳርንካ ዋልቃ ዎራ ሎቀንታ ዋር ልመካ ሱርድባብ ዶቅሴ ዳምንባብከስ ኬትም ደይሳካንታ ኤእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ፖልስንከስም ገችዝድባብ ማቼ ጳውሎስም አቅስካንታ ይ ዝግዛንጎካ ከታ ገቅርን ኤሰራክዬ፥ ስክስሰረ ልማ ኤዝድባብከስ እርምሶ ማርከብናርንካ ባሀርናር ጎብሶ ልመካ ፍጨንዘን ኬት ዉድንግንዳ ክትሴ። ");
INSERT INTO gyl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ነገድባብከስ ጉጅሶ ፍልተን ፎእምሳንዘንኬ ማርከብንታ ቁንጭምንከዘን ማትሰኮ ከት ዉድንግንዳ ክትሴ፥ ኮግንደካ ሙደነረ ኡርመካ ፍጨዘን የልሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ፍጨዘን ኡርመካ ዎ የልሳን ቡር ዎየልሳን ሎቀንታ ዎክያር ደንና ማልታ ጋይምድንዳ ማትንተን ኤሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ኮትኮ ሎቀንታ ዎክያር ዶቅድን ደንንዘን ዶቅድባብከስ በርእስዝድን ኡርማ ሪ ዎካንታ ይሰኬ፥ ኮትኮᎺይከረ ዶብ ቃንሳንካንተኬ ፍጨና ጋንድንካንታ ኖሀ የችሰኮ ዎም ሞክሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ጳውሎስ Ꮊቃ ይቤንከስም ሳንስሶ ኖሄናር ክት ኦይድንካ፥ ኖሄንታ ኦይጥምንዘንካ አምሳንዳ ዋልቃ ጉኒ ዉትሶ ክታ አንንዘን ላጭምሶ ክትም ጋእሴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ሎቀንታ ዎክናር ዶቅድን ማልታ ደንንዘን ዶቅድን ኤድንከስ ጉኒና ጳውሎስታ አንንዘን ላጭምሶ ክትም ጋእሳን ሰድሰኮ “ኮና ኤችና ገታ ኤድም ደይስባቤ! ባሀርንታ ዞገንዘንካ ኡርመካ ክት ዉተድንከረ ዎንታ ጮይስንታ ፍርደንዘንካ ሱርትሶ ሰንፔካ ዶቅካንታ ማታክዬ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ጳውሎስ ማቼ ጉኒንም ኖሄንታ ዋር ይንታ አንንዘንካ ድክችት ኦይቼ፥ Ꮊረነረ ክትም ይያክዬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ኤድንከሰረ “ይና ታ ኮዘን ክታ ዘነና ፍችተሬ፥ አነረ ገቅርማክናና ደእሶ ዋችተረ” ጋይሰኮ ካርሰረኮ Ꮊቀኬ። ኬዛር ማቼ በድᎺይካ ክትም ከት ካርዝድንካ Ꮊረነረ ክትም ቦርድንዳ ክታዘን የላክንደትም ከታ ሰዳንደትካ ከታ ይንታ ገቅርን ኦክሰኮ “ኮና ጮይስዬ!” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ዎ Ꮊቃን ኮትካርንታ ላማር ሎቀንታ ዎክናር ደንንም ቆልድባብ ፑፕሎስታ ፍጫ Ꮊቄ፥ ኮና ኤችና ይንታ ኤር ዎም ሞክሶ ማከን ሰጭ ኡርመካ ገችሴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ኮታይካ ፑፕሎስታ ባቤና ዘና ሶልኬ ዋር ዳቅልካ ክትም የጅንካ ሰቅምካ ራትሶ Ꮊቄ፥ ጳውሎስ ክደር አርድሶ ክትካንታ ምክሴ፥ ይንታ አንንመረ ክታዘን ዎድሶ ፋችሴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ኮና ይይምሳን ቡር ደንንዘን ዶቅድባብ አብንከስ ሰቀርስባብ Ꮊድሰኮ ፋጨኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ኤድንከስ በድ እማ ዎካንታ ተይ Ꮊደኬ፥ ከታ ይ ዎም ቦንጅድንደትመረ መያ ማስሰኬ፥ ማርከብንካ አይካንታ ዎ አምሳንደትከረ ዎም ዝግዝድንደትም ሙዳ ማርከብንዘን ዎጀኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ማከን አርፍ ማልታ ደንንዘን ዎ ዶቅሳን ቡር በርግንም ኮት ደንንዘን Ꮊቃን እስክንድርየታ ማርከብናር አርድሶቶ አምሶቴ፥ ማርከብና ድዮስ ቆሮስ ጋይምድን መንቲ ጮይስ፥ ጮይስ ማታክን ካምስንከስ ኮታዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ኦስ ሰራኩስ ካተመናር ዎ የልሳንደትካ ኮታር ማከን ሰጫ ዶቅሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ኮታርከረ ባሀርናር ስርሶቶ ኦስ ርግዮም ካተመናር የልሶቴ፥ ኮታር ዋልቃ ሰጫ ዎስክሳን ቡር ታመሪ ጎክንዳ ዞገና ዞግዛንጎካ ቃስትምስ ሰጨንካ ኦስ ፑትዮሎስ ካተመናር አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ዋር አሜንድባብከስም Ꮊፍሶቶ ከትካ ክክን ታብዛ ሰጫ ዎ ዶቅድንግንዳ ዎም ምክሰኬ። ኮታ ቡር ኦስ ሮማ ካተመናር አይሶቴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ሮማ ካተመናር ዶቅድባብ አሜንድባብከስ ዎጎካ ከታ ይ ኤሰርሳንደትካ አፍዮስ ጋበን የለልተኬ “ኤድ ገጅድን ማከን ኤሀ” ጋይምድን ካሪ የለልታ ዎም ሞካካንታ Ꮊደኬ፥ ጳውሎስ ከትም ይ ሰዳንደትካ ሳብም ጋለትሶ ዳቅሴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ሮማ ካተመናር ዎ አርደዳንደትካ ጳውሎስ ዋልቃ ክትም ካርዝድባብ ዳምንባብ ክትካንታ እምምስንካ ክት ይንት ዶቅድንግንዳ ክትካንታ ጋይምሴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ማከን ሰጨታ ቡር ጳውሎስ ሮማር ዶቅድባብ አይሁድንታ አንድር ኤድንከስም ኤልስሴ፥ ከት ሳንምሳንደትከረ ኩን ከትም ጋይሴ፥ “እስታ እስመንንከሶ እስራኤል ዎርሰንከዘንኬ ባቤንከስታ ዎገንዘን እ ይሳንዳ Ꮊረሰነረ ዳቀልስ ካዬ፥ ማታጋካ ዳት የሩሳሌማር ዞከርስቶ ሮማ ኤድንከስካንታ ስክስት እም እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ሮማ ኤድንከስ እም ከታ ይ ኦይሳን ቡር ደእካንታ እም የልስዝድንዳ ር እዘን ከታ ይ Ꮊፋክንጎካ ዉችኩን እም ኦይትካንታ ገቀርተክናና፥ ");
INSERT INTO gyl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","አይሁድና ማቼ እስታ ዉች ኦይትምን ኬት ግርዳንደትካ ኦስ ሮማ ባንችንደር ይግባይን ኦይስካንታ ነግምዳክንዳ ማቼ፥ ማችንከረ እስታ ዎርሰን እ ካሰዝድን ር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ታየረ እ የም ኤልስስባብ የ ሰዳንግንደኬ ኮመረ የካንታ እ ከዝድንግንደ፥ እታ ኮ ስብልዛንካ እ ዞከርሳንዳ እስራኤልንካንታ እምምሳን Ꮊድን ጉርምንጎኬ”። ");
INSERT INTO gyl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ከተረ ኩንጋየሮ ጳውሎስካንታ ማስሰኬ፥ “ይሁዳ ፍጨናርንካ የስጎካ ጻፍምሳንዳ ዎም የላክዬ፥ ኮር Ꮊድባብ ኤድንከሳርንካ Ꮊየነረ የስጎካ ዳቅል ኬዝባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ኮትኮም የስ ጎርስምድንደት አሜንንጎካ ካርሙደናር ኤድንከስ ግርድንደትም ኤዝዶቴ፥ ኮካንታ የስታ ገቅርና Ꮊራኮት ማቼረ ኤስርካንታ ዝግዶቴ” ጋይሰኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ሰጫ ክትካንታ እምሳን ቡር በድ ማትሰኮ ክታ ዶቅንት ኤሄናር Ꮊደኬ፥ ኖየረ ዛመንዘንካ ሶይት የለልታ ሳብታ ባንችምንጎካ ማርክርካ ይንታ ገቅርንም ከትካንታ መያ ማስሴ፥ ከትመረ አመንስካንታ ሙሴታ ህግናርንኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ማጻፍናርንካ አምሴሮ የሱስጎካ ኬዝት ከታ ቡዳር አርችሴ። ");
INSERT INTO gyl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ዋልቃ ዋልቀንከስ ክት ኬዛን ቃለን አመንሰኬ፥ አብንከስ ማቼ አሜናከኬ። ");
INSERT INTO gyl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ከተረ ክክ ክክ ኤአከክ ዶቆ ፋስምሰኬ። ማችንከረ ከት ፋስምተርንደታ እሪ ጳውሎስ በእንተዘን ኬዝድዮ ኩን ጋይሴ፥ አያን ጭልና ሳብዘንካ ኤሰርሶ ኬዝባብ ኢስያስ ጎካ የንታ ባቤንከስካንታ ክት ኬዛንዳ ገታ Ꮊቄ! ");
INSERT INTO gyl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","ክት ከዛንደረ ቃለና ኮኔ፥ ኮዎርሰንደር አይሳዮ ኤስርን ማቼ ኤሰርደቴ፥ ማችንከረ ገቀርት ተይዳከቴ፥ ሰድን ሰደቴ፥ ማችንከረ ቡዳ ይዳከቴ ከትም ጋይካ፥ ");
INSERT INTO gyl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ከትኬና ኤድንከስታ ቡደና ዳቅቴ፥ ከታ ቃምነረ ቱንቴ፥ ከታ አፍነረ ግንእቴ፥ ኩን ማታከስ ናና፥ ከታ ይንታ አፍካ ሰድሶ፥ ከታ ይንታ ቃምንካ ኤሰርሶ፥ ከታ ይንታ ቡዳረረ ገቀርት ተይሰኮ፥ እዝደር ከታ ማቼስናና እተረ ከትም ፋጅድት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“ይና ሳብታ አቅስንታ ክተና አይሁድ ማታክባብከስካንታ ኦይትምሳንደትም ኤስከቴ፥ ከተረ ኤኤኮ ጋይሶ ተይደኬ”። ");
INSERT INTO gyl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","“ጳውሎስ ኮም ይ ኬዛን ቡር አይሁድና ዳቅሶ በርመረኮ ዋርንካ ዉትሰኮ አይሰኬ”። ");
INSERT INTO gyl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ጳውሎስ ይ የጃን ኤሄናር ቃስቴን ስላ ጮጭ ኮታር ዶቅሴ፥ ክደረረ Ꮊድባብ ኤድንከስመረ ሙዳ ሞግድ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ሳብተረ ባንችምን ሳባከርንደትኬ ጮይስ የሱስ ክርስቶስጎካ Ꮊየነረ ክትም ማራክ ናና ሙቅምካ መያ ማስሶ ኤስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","የሱስ ክርስቶሰታ ፍክስንባብ ማችባብዘንኬ፥ ኦይትምስባብ ማትካንታ ኤልምስባብዘንካ፥ ሳብተረ ክላ ኬዘንም ኤስስካንታ እድምስባብ ጳውሎስዘንካ ኦይትምሳንዳ ክታ። ");
INSERT INTO gyl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ኮነረ ክላ ኬዘና ሳብዘንካ ኤሰርሶ ኬዝድባብከስጎካ ጭል ማጻፍንከሳር እርምሶ እምሳን ጉርም ቃሌ። ");
INSERT INTO gyl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ክላ ኬዘና ሳብታ ይንችንጎካ፥ ኤድ ማትሶ ዳዊትታ ሱሳርንካ ክታ አጥርን ኤስምስዝድንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ኮትኮግንደረ ዎንታ ጮይስ የሱስ ክርስቶስ ይንታ ፋሳን አያንካ ደእያርንካ ይንታ አምንተንካ አንድር ዎልቀካ ሳብ ይንች ማትንተና ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ክርስቶስታ ላምንካንታ አይሁድ ማታክባብ ሙደና ከት አሜንድንግንደኬ ክትምድንግንዳ ይይካንታ ክትጎካ ዉቺ እምንተንኬ ኦይትምስባብ ዎም ማዝድንደትም ተይቶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","የተረ የሱስ ክርስቶሰታ ማድንግንዳ ሳብ ኤልስባብ ኮችንከስታ ዎክያርንከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ኮካንታ ሮማር የ ዶቅድባብካንታ፥ ሳብ የም ሶልምስባብከ ክታ ኮች የ ማድንግንዳ የ ኤልምስባብ ሙደንካንታ፥ ዎንታ ባቤን ሳብዘንኬ ጮይስ የሱስ ክርስቶስታ ዉቺ እምንተንኬ ሳራትቸንካ የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","የንታ አሜንና ፍጫሙደንዘን ኤስምሳንካንታ፥ ሙደንዘንካ እርምስስቶ የሱስ ክርስቶስጎካ የ ሙደንካንታ እስታ ጮይስን ጋለድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ሙዳᎺይካ እስታ ምክስንካ የም እ ገቀርድንደትም፥ ክታ ይንችንጎካ ኬዝድንደትም ክላ ኬዘን ኤስስካ ቡዳርንካ እ ክትካንታ ፍግዝድባብ ሳብ እስታ ማርኬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ጉጅሶ ታ በእንተዘን የንደር Ꮊድካንታ ሳብታ ጋይታ ማችንካ እስታ ጎግና ፎችምሳንዳ ማድንግንዳ ሙዳᎺይካ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","አሜንካ የ ዳቅድንግንዳ የም ይድንደትም አያናር እምንተን የካንታ ካስካንተከ የም ሰድንካንታ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ኮመረ እስታ ጋይንተና እታ የንታ አሜንካ፥ የተረ እስታ አሜንካ ክክ ክክ ዎ ዳቅዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","እስታ እስመንከስኬ ምችነንከሶ! አብንከስ አይሁድ ማታክባብከስታ ዎክያር በድ አሜንድባብከስም እ Ꮊፍሳንግንዳ ኮግንደረ የንታ ዎክያር አሜንድባብከስም Ꮊፍካንታ ዝግትትዶቆ፥ ኬዛር ማቼ የንደር Ꮊድካንታ በድᎺይካ ገቀርስቶ ታ የለልታ እካንታ ቦድማክንዳ ማትንተን የ ኤዝድንግንዳ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ግርክ ኤድንከስካንተረ ማታ ግርክ ማታክባብካንተረ፥ ኤሰንም ኤስባብከሰረ ማታ ኤሰንም ኤሳክን ዎርሰን ክላ ኬዘን ኤስስታ ነጋይንዳ ባዛ እዘን ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ኮካንታ ሮማ ፍጨናር የ ዶቅድባብካንታ ክላ ኬዘን የም ኤስስካንታ አንገርድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","እታ ክላ ኬዘንታ ቃለንካ ኦስናይቴ፥ ክላ ኬዘንታ ቃለና እርምሶ አይሁድንከስካንታ ጉጅሰረ አይሁድ ማታክባብከስካንታ፥ ኮትግንደረ አሜንድን ኤድንከስም ሙዳ አቅዝድንዳ ሳብታ ዎልቄ። ");
INSERT INTO gyl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ጭልና አሜንካ ዶቅንተን Ꮊብዴ ጋይምሶ ጻፍምቴ፥ ሳብታ ጭለትችነረ ክላ ኬዘንካ Ꮊፈርሳንጎካ እርንደትዘንካ የድሶ በእንታ የለልታ ኤድ ጭልምድንዳ አሜንኬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ኤድንከስ ይንታ ባችንካ ዶፈንና ኤስምዳክንግንዳ ይደኬ፥ ሳብመረ ጳስክሳ ከት ነገዳንጎኬ ከታ ባችንጎካ ሙደንዘን ሳብታ ዋጭና ጭላርንካ መያ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ከትም ዋጭድንደረ ሳብጎካ ኬትም ኤስንታ ዝግዝድንደትም ሳብ ይንታ ማታርንካ መያ ማስሳን ኤሰሮ ኬት Ꮊቃንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ፍጫ ሙደና ፍዝምሳንዘንካ የድሶ ኤድንከስካንታ Ꮊፈርዳክንዳ ሳብታ እዘና፥ ና ኮነረ ስለንክንደታ ክታ ዎልቀንከ ክታ ጮይስትቸና ክት ፍዛን ሪንከዘን መያ ማትሶ Ꮊፈርሳን ኦል ኤድንከስ ባጅድን ባችንታ ከት ሱርድንደታ ጎግ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ከታ ሳብም ኤዝድዶቀኮ ክትካንታ ክታ ጮይስትቸንግንዳ ክትካንታ ዝግዝድንደትም ቦንቼኬ ጋለትካ እማከኬ፥ ከታ ይንታ ገቀርንከረ ሪካንታ ማዳክባብ ማቼኬ፥ ከታ ገቀርዳክን ቡደነረ ቱንይ ማቼ፥ ");
INSERT INTO gyl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","“ኤጨንባቦቴ” ኬት ጋይድንካ ዳቼንከስ ማቼኬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ካይዳክባብ ሳብም ቦንቸርድንደታ ካርያር ካይድን ኤታ ካምስንከስካ፥ አፍትካ፥ ኦይድ ዱት ዶቅድባብከስም፥ ፍጨካ ጎችምድን ፍዝርንከስምኬ ካምስካ ፍክስምስባብከስካንታ ቦንቻ እምሰኬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ኮካንታ ክክ ክክ ይንታ ገታ ዘነንዘን ኦስንዝድን ይተንም ኬት ይድንግንዳ ሳብ ቱና ጮጫን ኬታ ዳቅል አንግርን ካንታ ቆልምድባብከስ ማተርንግንዳ ኬትም ስክስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ኮነረ ማቻንዳ ሳብታ ዶፈንን ካርከካ ከት ኦክሳንካንታ፥ ፍዝባብታ ካርያር ፍዝምስ ርም ከት ጎይንሳንጎኬ፥ ከት ፍክሳን ካንቴ። ሳብ ማቼ ስለንክንደታ ጋለትምስባቤ፥ አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ኬታ ማነንከስ ዎራ አⷝነንከስካ የል ዝግዝድንካ ማነኬ ማነካ ክክን ከታ የልንዘንካ አምሳንዳ ሳብ ዝግዝዳክን የለርዝድን አንግርን ካንታ ስክስት ከትም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ኮት ኮግንደረ አⷝንከስ ማነንከስካ ክክን የልንተን ዛቅሰኮ ክክ ክክ አንገርሰኬ፥ ኮካንታ አⷝንከስ አⷝነንከስካ ክክን የልሰኬ፥ ኬታ ይንታ ኮትርንጎካ ኬትም ዝግዝድን ዋጭን ይንታ ዋሄንዘን ተይደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ኤድንከስ ሳብም ኤስካንታ ከትዝጋክን ኦል የለርዝድን ር ኬት ይድንግንዳ ሳብ መይዳክን ማክቻ ካንታ ስክስት ከትም እምሴ። ");
INSERT INTO gyl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ኮካንታ ዳቀልስካ፥ ባችካ፥ ድሰካ፥ ጩበካ፥ ቀምስካ፥ ሰንፓ ደይሰካ፥ ዋጭመካ፥ ገስካ፥ ዳቅል አንግርካ ሙዳ ጮጭባብከስ፥ ኮትኮግንደረ ካሪ ኬዝድባብከሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ኤታ ካሪ ኬዝድባብከስ፥ ሳብም ግርድባብከስ፥ ኤድም ቶጅድባብከስ፥ ኦትረንባብከስ፥ ጬቅድባከስ፥ ዳቅልን ፍክስካንታ ጎግ ዝግድባብከስ፥ አጭባብከስካንታ ክትምዳክባብከስ፥ ");
INSERT INTO gyl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ገቀርት ተይዳክባብከስ፥ ኬዝምሶ ኤእሳንደትም ግርድባብ፥ ሶልማ ካየንባብከስ፥ ጋርዝድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","“ከትኬና ሪን ይድባብከስም ሙዳ ደእ ከትም ዝግዝዴ” ጋይድንደትም ሳብታ ህግንም ኤሰረኮ ኮም ሙዳ ይደኬ፥ ይይንታ Ꮊከረ ማታክናና ኮግንዳ ይድባብ ኤድንከስም ዳቅዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","አብ ኤድንዘን የና ፋረድባብ የስታ ማታካንታ የስ ሱርድንዳ ጎግ ካዬ፥ ኮካንታ፥ አብ ኤድንዘን የስ ፋረድንካ የስታ ማተንዘን ፋረደዬ፥ የና ኤታዘን ፋረደረዮ፥ የስ ፋረጅባብ ኤችንክት ይድንደትም የና ይደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ኮም ይድባብ ኤድንከዘን ሳብ ከትም ዝግዝድንደትም ከታዘን ፋረድንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","የና ኤችኖ! ኩን ይድባብ ኤድንከስታዘን ፋረደረዮ፥ ከት ይድንደትም የስ ይድንካ ሳብታ ፍርደንዘንካ የስ ሱርድንደትም ካምዶ? ");
INSERT INTO gyl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","አነረ ሳብታ ገቅር ላቅምንኬ ሙደን ክታ ጋምንተን፥ ክታ ዳንዳእንታ በድምን የና ቶችተራ? ሳብ የስካንታ ይንታ ላቅምንም ክት በችሳንዳ ጎማ ፍክስን ዎይሰርድንደታር የስም ጎርስካንታ ማቻንደትም የና ኤሳያ? ");
INSERT INTO gyl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ይና የና ጎማ ፍክስን ዎይሳክሳ የስታ ነግንኬ ጉልማባብ የስታ ማትንተንካ ሳብታ ዋጭንኬ ገታ ክታ ፍርደና መያ ማድን ሰጨንካ የዘን ዋጭና በድንግንዳ ይደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ሳብ ዋልቃ ዋልቀንካንታ ክታ ፍክስንግንዳ ክትካንታ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ኡርማ ፍክስካ ዳቅንተካ ጋለትንኬ ቦንቼን ካይዳክን ዶቅንተን ዝግድባብከስካንታ ሳብ ስለንካ ዶቅንትን ከትካንታ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ኬታ ይንታ ማታካንታ መይድንደትም ዝግድባብከስካንታ፥ ዶፈንንካንታ ክትምዳክባብከስካንተኬ ዳቅልንካንታ ክትመሮ ኤድዘን ዙዝማኦንግድባብከዘን ማቼ ሳብታ ዋጭኬ ጋደካ ከታዘን Ꮊተሬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","እርምሶ አይሁድንዘን፥ ኮታዘንከረ አይሁድ ማታክባብከስ ዳቅልን ይድባብ ኤድ ሙደንዘን ማጠኬ ኦይምካ ከታዘን Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ኬዛር ማቼ ኡርማ ሪን ይድን ኤድንከስ ሙደን አይሁድን ካንተረ ማታ አይሁድ ማታክባብከስካንታ ጋለትኬ ቦንቸካ ሳራትቸነረ ከትካንታ እምምተሬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ሳብ ኤድንከስታ ባላካንታ ጋይሶ ፍክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ሙሴታ ህግ ከትካንታ ካየንድትከረ ጎማ ፍግዝድባብከስ ሙደና ህግና ከትካንታ ካየንዳ ማቼረ ካይደኬ፥ ሙሴታ ህግ ኬታ ዶቅድንካ ጎመን ፍግዝድባብከስ ማቼ ሙደና ህግንካ ፋረድምደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ሳብታ እሪ ጭልምድባብከስ ሙሴታ ህግንም ኤሰርሶ ፍክስዘን Ꮊቅዝድባብ ከሰክ ዳት ህግንም ኤሰርሰኮ ፍክስዘን Ꮊቅዝዳክባብከስ ካየኬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ሙሴታ ህግ ካየንባከስ አይሁድ ማታክባብ ኬታ መጠንግንዳ ዶቅድን ሙሴታ ህግና ክድንደትም ቦደኬ፥ ኮትኮጎከረ ህግና ኬታ ካያናንከረ ኬታ መጠንካ ዶቅድን ህግን ይ ኬትም ዝግዝድንደትም ኬታ ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ኮነረ ከታ ይተና ህግና ክድን ርና ሙዳ ከታ ቡደናር ጻፍምሳንዳ ማትንተን ሰጅዴ፥ ጉጅሰረ ከታ ገቅርና ከታዘን ማርከርዴ፥ ከታ ገቅርና ዋልቃ ዋልቃ ከትም ገቀርስዝዴ፥ ዋልቃ ዋልቀረ ከትም ዳቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ኮነረ ማድንዳ እ ኤስምዝድን ክላ ኬዘንታ ቃለንግንዳ ሳብ የሱስ ክርስቶስጎካ ኤድንከስ ከት ፍክሳን አችምሳን ሪንታዘን ፋረድን ሰጨንኬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ይና፥ የና “አይሁድቴ” ጋይደዬ፥ ሙሴታ ህግንከረ ገክንደዬ፥ ሳብተረ የስታ ማትንተንካ ጋይርደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","የና ሳብታ ጋይተንም ኤዝደዬ፥ ሙሴታ ህግን የስ ኤሳንካንታ ኡርማ ይተንም ኤዝደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","“የና አፍ ዝልንከስታ ጎርስንባብቴ፥ ኡማር ዶቅድባብከስካንተረ ሳክምቴ ጋይሶ የስታ ማተንም የስ ጬቅዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ኤሳክባብከስመረ ኤስዝድቴ፥ ይንችንከስመረ ኤስዝድቴ” ጋይደዬ፥ ኮትኮግንደረ “ሙሴታ ህግንካ ኤሰንካ ዶፈንንታ ካምስና እስታ ዶቅዴ” ጋይደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","አብንከስም ኤስዝድባብ ማዳዮ ይና የስታ ማተን Ꮊረተረ የስ ኤስዝዳክንዳ? Ꮊይድበቴ ጋይደዬ፥ የና ማቼ ድብደዬ፥ ");
INSERT INTO gyl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ꮊይ ቤልምቴ ጋይደዬ፥ የና ማቼ ቤልምደዬ፥ የና ሳብዘንካ አብ ሪን ጎይንንም ቦዝደዬ፥ ሳብታ ጭል ኤሄናርንካ ማቼ የና ቡርደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","የና ሳብታ ህግንካ ጋይርደዬ፥ ኬዛርንካ ማቼ ህግንም ዉልእንተካ ሳብም የና ቶጅደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ኮነረ፥ “የ አይሁድንከስጎካ ሳብታ ላምና አይሁድ ማታክባብከዝደር የክምዴ” ጋይምሶ ጻፍምሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ሶለንም ተችና ገታ የስም መይድንዳ ሙሴታ ህግንም የስ ቦጀ ዳት፥ ህግንም የስ ዉልእድባብ ማቼ የስታ ሶለንም ተችርና የስ ተቸራክንግንዳ ፋይድምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ኮካንታ ሶለንም ተቸራክንባብ አይሁድ ማታክባብከስታ ኮችና ህግንታ ክተንም ቦድባብ ማቼ፥ ክት ሶለንም ተቸራክንደና ተቸርሳን ግንዳ ፋይድምዳ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ጻፍምሳን ሙሴታ ህግ የስካንታ ዶቅድንካ ሶለንም ተቸርስባብ ማትሰዮ ህግንም የስ ዉልእሴ ዋሄካ ሶለንም ተቸራክባብ ማትሶ ሙሴታ ህግንም ቦድባብ አይሁድ ማታክባብከስታ ኮችና የዘን ፋረደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ይና ላምንካ Ꮊክ አይሁድ ማችባብ ዶፈን አይሁድ ካዬ፥ ኮትኮግንደረ ዘንጎካ Ꮊፈርድን ዋሄታ ሶለንም ተችርና ዶፈን ተችርካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ዶፈን አይሁድ ማትንተና ዋርጎካ አይሁድ ማችባቤ፥ ዶፈን ሶለንም ተችርና ሳብታ አያናር ማድንዳ ቡደታ ሶለንም ተችርና ዳት ሙሴታ ህግንካ ጻፍምሳን ግንዳ ዋሄታ ሶለንም ተችርካዬ። ኮግንዳ ኤድና ጎፍስን ክት Ꮊብድንዳ ሳብዘንካዳት ኤድዘንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ይና አይሁድ ማችባብ አይሁድ ማታክባብዘንካ ስገድንዳ Ꮊረከረ? ሶለን ተችርና Ꮊሮክ መዬ? ");
INSERT INTO gyl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ገታ አይሁድ ማትና በድ ጎግካ ስገዴ፥ ዝግዝድ ሪይና ሳብ ይንታ ቃለን አይሁድንከስካንታ ዋደካ ክታ እምንተኔ። ");
INSERT INTO gyl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ይና፥ አይሁድንከሳርንካ ዋልቃ ዋልቀንከስ አሜንምስባብ ማትሶ Ꮊፈራክ ከት ማቼ፥ ኬታ አሜንምክሳ ነግና ሳብ አሜንምስባብ ማቻንደትም ነግዝዶ? ");
INSERT INTO gyl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ቦድሶ ነግሳዬ! “የስታ ቃለንዘንካ አምሳንዳ ዶፈን ማደዬ፥ የስታ ይምኤንባብም ሳብታ ፍርደናᎺይካ ጋምደዬ” ጋይምሶ ጻፍምሳን ግንዳ ኤድ ሙደና ካርካባብ ማችንከረ ሳብዶፈኔ። ");
INSERT INTO gyl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ኬዛር ማቼ ዎንታ ጎመና ሳብታ ጭላትችን ሰጅድንዳ ማቼ ይና ዎታ Ꮊሮንት ጋይቴ? ሳብ ዎንታ ጎመንጎካ ዎም ዋጭዴ ገታ ኖ ፋረድባብ ካዬ ጋይንትዮ? ኮዘን እ ኬዝድንዳ ኤታ ገቀር ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ቦድሶ ኩን ካዬ! ኩን ኮት ማቼ ሳብ ፍጫሙደንዘን Ꮊስክ ፋረዳ? ");
INSERT INTO gyl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ኬዛር ማቼ ካርካባብ እስታ ማትንተና ሳብታ ዶፈንን መያ ማስካ፥ ክታቦንቼንታ በድምን ሰጅድንዳ ማቼ ይና፥ እም ጎማባብ ማስሶ ክት ፋረድንዳ Ꮊራጎከረ? ");
INSERT INTO gyl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ዋልቃ ዋልቃ ኤድንከስ “ኡርማ ሪም Ꮊፍካንታ ዳቅል ሪም ዎ ይያ” ጋየርቶ ኤስዝድባብ እም ካምስሰኮ ካሰዝደኬ፥ ኮካንታ ኮግንዳ ዶቅድባብከዘን ፋረድምድን ፍርደና ገቴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ይና፥ ዎታ አይሁድንከስ አይሁድ ማታክባብከዘንካ ስግዶት ጋይንትዮ? ቦድሶ ኩን ካዬ! ኤድንከስ ሙዳ አይሁደረ ማታ አይሁድ ማታክባበረ ጎማባብከስ ኬታ ማትንተን እርምስቶ ቡዳር አርድንግንዳ ኬዝትቴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ኩን ጋይምሶ ጻፍምሳንግንዳ “ዋልቃ ዎራ ጭል ኤድ ካዬ፥ ");
INSERT INTO gyl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ገቀርድባበረ ካዬ፥ ሳብመረ ዝግድባብ ዋልቀረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ሙደነረ ሳብታ ጎግንዘንካ ዉተኬ፥ የካ መይዳክባብከስ ማተኬ። ላቅም ፍክስን ፍግዝድባብ ዋልቃ ኤድ ዎራ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ኤድም ሰቅዝድን ዳቅል ኬዛካንታ፥ ከታ ጎርዝና ዱክታ ጎርግንዳ ፎችምሳንዴ፥ ከታ ይንታ አድምንካ ገስዝደኬ፥ ኬታ አፈናርንካ ዉድን ዳቅል ኬዘነረ ጉኒ ፋክት ደይዝድንደት ግንዳ ኡፈልዝድንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ኬታ አፈናርንካ ዉድንዳ ባድከ ዳቅል ኬዝካ ጮጫንዴ ");
INSERT INTO gyl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ኬታ ዱትነረ ኤድም ደይሳካንታ ሳነርሳንዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ኬታ አይድን ካርሙደናር Ꮊፈርድንዳ ካይንተከ ማጠኬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ሳራትቼንታ ጎግን ኤሳየኬ፥ ");
INSERT INTO gyl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ሳብመረ ቦድሶ ጳስ ኬታዘን Ꮊፈራዬ”። ");
INSERT INTO gyl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ሙሴታ ህግና ሰጅድንዳ ህግታ ጎያር ዶቅድባብከስም ማቻንደትም ዎታ ኤዝዶቴ፥ ኮጎካ ኤድንከስ ኬዝድንደታ ጎግ ካይድንካ ጫም ጋይደኬ፥ ፍጫ ሙደና ሳብታ ፍርደንታ ጎይያር ማዴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ኮካንታ Ꮊየነረ ኤድ ሳብታ እሪ ሙሴታ ህግን ቦድካ ጭልማዬ፥ ህግና ሰጅድንዳ ኤድ ሙደና ጎማባብ ማትንተኔ። ");
INSERT INTO gyl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ታ ማቼ ሳብ ኤድንከስም ክት ጭልዝድን ጎግና ሙሴታ ህግን ካይሳ ማትንተና መያ ማቴ፥ ኮነረ ሙሴታ ህግናርኬ ሳብዘንካ ኤሰርሶ ኬዛቅባብከስካ ማርከርምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ኮካንታ ሳብ Ꮊረሰነረ ፋሳክዶቆ የሱስ ክርስቶሰካ አሜንድባብም ሙዳ ጭለትቸንም እምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ኤድንከስ ሙደና ጎማ ፍክሴ፥ ሳብ ከትካንታ እምሳን ቦንቼና ከታዘንካ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ኮካንታ ኤድንከስ የሱስ ክርስቶስ ቦጃን አቅስንታ ፍክስንካ ሳብታ ዉቺ እምንተንካ Ꮊክ ጭልምደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ሳብ የሱስ ክርስቶሰም ካሲ ማስሶ ግግሳንደና ክትካ አመንምድባብ ሙደና ክታ ማቀስንካ ኬታ ጎመንታ ላላ ጋይን ኬት Ꮊብድንግንዴ፥ ሳብ ኮም ክታ ይይና ይንታ ዳንዳእንካ ኤና እሪ ኬታ ጎመን ካያ ማስካ ይንታ ገታ ፍርደን መያ ማስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ታ ኮስለናረረ ሳብ ይንታ ማታርንካ ጭል ማትንተን ሰጅድንዳ የሱሰካ አሜንድባብከስም ሙዳ ጭልስኬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ይና ዎ ጋይርድንዳ ሪ Ꮊራዶቅዳ? Ꮊራርከረ ጋየራዮቴ! ዎ ጋየርዳክንዳ Ꮊራጎከረ? ሙሴታ ህግን ዎ ቦድንጎኮ? ኩን ካዬ፥ ኬዛር ማቼ አሜንኬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ኮካንታ ሳብ ኤድም ክት ጭልዝድንዳ፥ ኤድ ሙሴታ ህግንታ ፍክስንም ቦድንተካ ማታክናና አሜንካ ማትንተንም ገቀርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","አና ሳብ አይሁድንከስታ Ꮊክ ጮይስዮ? አይሁድ ማታክባብከስታ ጮይስካዮ? ገታ አይሁድ ማታክባብከስተረ ኖ ጮይስዬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Ꮊረታ ጋይሴ ሶለን ተቸርስባብከስም አሜንካ ሶለን ተቸራክባብ ከስመረ ኮትኮ አሜንካ ጭልዝድባብ ኖ ዋልቃ ሳብዬ። ");
INSERT INTO gyl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ይና አሜንንጎካ ሙሴታ ህግንም ነግዝዶት ጋይንትዮ? ኩን ካዬ፥ ስግስሶ ሙሴታ ህግን ዳቅስሶ የዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ይና ዋሄካ ዎንታ ባቤና ማችባብ አብራሀም Ꮊፍሴ ዎ ጋይድንዳ Ꮊራርየረ? ");
INSERT INTO gyl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","አብራሀም ጭልምሳንዳ ፍክስካ ማቼስናና፥ ይ ጋይርድ ር Ꮊብዳዶቆ፥ ማታጋካ ዳት ሳብታ እሪ ጋይር ካንታ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ጭል ማጻፍና “አብራሀም ሳብካ አሜንሴ፥ ክታ አሜንነረ ጭል ማትሶ ክትካንታ ፋይድምሴ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ፍግዝድባብ ኤድ ክት Ꮊብድን ፍክስንታ ናክና ዝግዝድንዳ ክት ፍክሳንከካ ዳት ዉቺ እምንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ኤታ ኡርማ ፍክስ ካያ ማቼረ ዎራ ጎመንባብከስም ጭልዝድን ጮይስንካ አሜንሴ ክታ አሜንና ጭል ማትሶ ክትካንታ ፋይድምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ዳውተረ ይጎካ ሳብ ኡርማ ፍክስካይሳ ክት ጭልዝድን ኤድ Ꮊራከካ አንጅምስባብ ማትንተን መያ ማዝድዮ፥ ");
INSERT INTO gyl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“ኬታ ባችንም ነጋ ጋይምስባከስኬ ጎመን ኬታ ነጋ ጋይምስባብ ኤድንከስ ከታ አንጅምስባበኬ! ");
INSERT INTO gyl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ጮይስ ክታ ጎመን ክታዘን ፋይዳክን ኤችና አንጅምስባቤ!” ኩን ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ይና፥ ዳዊት ኬዛንዳ ኮና አንጀና ሶለን ተቸርስባብከስካንታ Ꮊክዮ? አና ሶለን ተቸራክንባብከስካንተረ ዋሮ? ሶለን ተቸራክንባብከስካንተረ ዎሬ፥ “አብራሀም ሳብካ አሜንምሳንኦል ክታ አሜንና ጭል ማትሶ ክትካንታ ፋይድምሴ” ጋይቶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ይና አብራሀመታ አሜንና ጭል ማትሶ ክትካንታ ፋይድምሳንዳ Ꮊንተረረ? ሶለንም ክት ተቸርተርንደታ እርዮ አነረ ክት ሶለን ተቸርሳንደታ ቡርዮ? ሶለን ክት ተቸርተርንደታ እሪ ዳት ሶለን ክት ተቸርሳንደታ ቡር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","አብራሀም አክ ክት ሶለንም ተቸርተርንደታ እሪ አሜንና ክታ ጭል ማትሶ ክትካንታ ፋይድምሳን ግንዳ መያ ማስታ ቃዉታ ክትካንታ ማድንግንዳ ሶለንም ተቸርሴ፥ ኮካንታ አብራሀም፥ ሶለን ተቸራክዶቆ አሜንድባብከስካንተኬ ኬታ አሜንና ጭል ማትሶ ከትካንታ ፋይድምድባብ ሙደንታ ኖ ባቤኔ። ");
INSERT INTO gyl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ኮትኮግንደረ አብራሀም ሶለን ተቸርስባብከስተረ ባቤኔ፥ ሶለን ተቸርስባብከስካንተረ ባቤና ክት ማቻን ጎግና ከታ ተቸርንካ Ꮊክ ማታክናና ኖ ይ ተቸርተርንደታ እሪ ክታ Ꮊቃን አሜንን ከታ ጎርስምንከረ ዎሬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","አብራሀመኬ ክታ ሱሰንካ ፍጫ ሙደን ኬት ተይድንደትም ሳብ Ꮊድን ጉርምን ክትም እምሳንዳ አሜንካ ክት Ꮊፍሳን ጭለትቼንካንታ ዳት ሙሴታ ህግንም ክት ቦጃንካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Ꮊድን ጉርምን ተይድባብከስ ሙሴታ ህግንም ቦድባብ ኤድንከስ ኬት ማቼ አሜንንታ መይንታ ካዬ፥ Ꮊድን ጉርምነረ ዉቺኩን ማዴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ሙሴታ ህግና ተይᎺድንደና ሳብታ ዋጭኔ፥ ሙሴታ ህግና ካያማቼ ህግንዘንካ ስግና ባች ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ኮካንታ ጉርምና ዶቅድንግንዳ ይምሳንዳ አሜንንታ ዘኔ፥ ኮነረ ጉርምና አብራሀመታ ሱሳ ሙደንካንታ ሳብዘንካ ዉቺ እምንተንካ እምምሳን ማትንተና ኮካ መያ ማቴ። ኮነረ ሙሴታ ህግንም ጎርስምድባብከስካንታ Ꮊክ ማታክናና አብራሀምግንዳ አመንስባከስ ሙደንካንቴ፥ ኮዘንከረ አምሳንዳ አብራሀም ዎ ሙደንተረ ባበኔ። ");
INSERT INTO gyl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","አብራሀምጎከረ፥ “በድ ዎርሰታ ባቤና የስም ማስትቴ” ጋይምሶ ጻፍምቴ፥ ኮነረ ጉርምና አብራሀምካንታ እምምሳንዳ ኖ ደእስባብከስም አምስዝድባብኬ ካየንደትም ዶቅድንግንዳ ይድባብ ጮይስንካ ክት አመንሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","አብራሀመም የስታ ሱሰና አንድር በተሬ ጋይምሶ ከዝምሳንደትግንዳ በድ ዎርሰንታ ባቤና ክት ማድንደትም አመንሳንደትኬ ጉርም ክት ይሳንዳ Ꮊረነረ ጉርም ይምዳክን ሪዘኔ። ");
INSERT INTO gyl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ስለነረ ክታ ዋልቃ ጸታ ማታባብ ማችንከረ ክታ አⷝናትችንታ ጋፍንካ ደእስባብግንዳ ማትንተንጎካ አጥማካንታ ይ ማዳክንደትምኬ ሳረረ ዶንጀርሶ አጥማ ካንታ ኮት ማዳክንደትም ኖ ይ ኤስንከረ ይንታ አሜንካ ጋፍስባብ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ይንታ አሜንካ ዛብዝባብ ማትሶ ሳብካንታ ቦንቻ እምሳ ዳት ሳብ ክትካንታ እምሳን Ꮊድን ጉርምንካ አሜንዳክቴ ጋይሶ Ꮊኤራክዬ። ");
INSERT INTO gyl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ሳብ ክትካንታ እምሳን ጉርምና ቦድምድንዳ ማትንተን ቦድማ ቡዳርንካ አመንድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ኮካንታ አብራሀመታ አሜንና ጭል ማትሶ ክትካንታ ፋይድምሴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ኬዛር ማቼ “ጭል ማትሶ ክትካንታ ፋይድምሴ” ጋይድን ቃለና ጻፍምሳንዳ አብራሀም ካንታ Ꮊክ ማታክናና፥ ");
INSERT INTO gyl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ዎካንተረ ዋሬ። ዎንታ ጮይስን የሱሰም ደእናርንካ አምስሳን ጮይስንካ ዎ አሜንድባብ ዎካንተረ ዎንታ አሜንና ጭል ማትሶ ፋይድምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ኮና ዎንታ ጮይስን የሱሰረ ዎንታ ጎመንካንታ ደእካንታ ስክስምት እምምስባብኬ ዎመረ ጭልስካንታ ደእያርንካ አምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ይና ዎታ ጭላትችንም Ꮊፍሳንዳ አሜንካ ማቻንካንታ ዎንታ ጮይስን የሱስ ክርስቶስካ ሳብካ ክክን ሳራትች ዎንታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ታ ፈንክ አሜንካ ዳቅሶቶ ዎ Ꮊፈርድን ሳብታ ዉቺ እምንተናር ዎ አርደዳንዳ ክትካ ማቻንካንታ Ꮊድን ጉርምንካ ሳብታ ቦንቸን ካስምድባብ ዎንታ ማትንተንካ ጋይርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ኮካ Ꮊክ ማታክናና ማጠና ዳንዳእንም ዎካንታ Ꮊፍስዝድንደትም ዎ ኤዝድንካንታ ዎንታ ማጠንታ ዋረረ ጋይርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ኬዛር ማቼ ማጠናር ዳንዳእንም ዳንዳእናርከረ ጰጨንካ ዳቅንተን፥ ዳቅንተናርከረ Ꮊድን ጉርምና Ꮊፈርዴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ዎካንታ እምምሳን አያን ጭልንጎካ ሳብታ ሶልመና ዎንታ ቡዳር ጮጫንጎካ ጉርምና ዎም ኦስንሳዬ። ");
INSERT INTO gyl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ጋፍስባብ ማትሶ ዎ ዶቅድንካ ሳብ ማታ ጋይሳን ሰጨንካ ክርስቶስ ጎመንባብከስካንታ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ጭል ኤታ ካርያር ማትሶ ደእድ ኤድም Ꮊፍና አንድር ማጤ፥ ኮትኮግንደረ ላቅም ኤታ ካርያር ደእካንታ ማድባብና Ꮊረንግርካ Ꮊፈርዳ ማተረ። ");
INSERT INTO gyl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ኬዛር ማቼ ዎታ ጎማባብ ማትሶ ዎ ዶቅድንካ ክርስቶስ ዎንታ ካርያር ደእቴ፥ ኮነረ ሳብታ ሶልመና ዎካንታ ዶቅድንዳ Ꮊስከካ አንድር ማትንተን ዎ ኤዝድንግንዳ ይዴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ይና ዎ ጭልምሳንዳ የሱስ ክርስቶስታ ማቀስንካ ማቼ ስግሰረ ሳብታ ዋጭንዘንካ ዎ አቅድንዳ ክትጎኬ። ");
INSERT INTO gyl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ዎታ ሳብታ ይምኤንባብከስ ማትሶቶ ዎ ዶቅድንካ ክታ ይንችንታ ደእንካ ሳብካ ክክን ኤድምቶቴ፥ ታ ሳብካ ክክን ዎ ኤድምሳንደታ ቡር ክታ ይንችንታ ዶቅንተንጎካ ስግሶ አቅዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ኮነረ Ꮊክ ማታክናና ሳብካ ክክን ኤድመን ዎ Ꮊፍሳን ዎንታ ጮይስን የሱስ ክርስቶስጎካ ሳብ ዎካንታ ይሳንደትካ ጋይርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ዋልቃ ኤድጎካ ጎማ ፍጫሙደንዘን Ꮊዴ፥ ጎመታ ጎግከረ ደእ Ꮊዴ፥ ኮትኮግንደረ ኤድ ሙደና ጎማ ፍክሳንካንታ ደእ ኤድ ሙደንዘን Ꮊዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ሙሴታ ህግና እምምተርንደታ እሪ ጎማ ኮ ፍጫሙደንዘን Ꮊቄ፥ ማታጋካዳት ሙሴታ ህግ ካየንደትካ ጎማ ይንታ ማታርንካ ጎማግንዳ ፋይድማይ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ማቼረ አዳምግንዳ ሳብታ ህግንም ስግንተካ ጎማ ፍክሳክባብከዘን ዎራ ነጋክ ዶቆ ደእ አዳምዘንካ አምስሶ ሙሴ የለልታ ኤድ ሙደንታዘን ዎልቃ Ꮊፍሴ። ኮና አዳም ኦስ እሪ Ꮊድባብ ክርስቶስታ ካምስ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ኬዛር ማቼ ሳብታ ዉቺ እምንተና ኤታ ጎመንዘንካ ስግዴ፥ ዋልቃ ኤታ ጎማጎካ በድንከስ ደእሳንደትግንዳ ኮትኮግንደረ ሳብታ ዉቺ እምንተንኬ ክት ዋልቀን ኤድ ማችባብ የሱስ ክርስቶስጎካ Ꮊፈርሳን ሳብታ ዉቺ እምንተና በድንከስካንታ ስጥመካ እምምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ኮት ኮግንደረ ሳብታ ባዛካይሳ እምንተና ተይᎺዳንዳ ሳብታ ዉች እምንተንታ አፍና ዋልቃ ኤችንታ ጎመና ተይᎺዳን አፍንግንዳ ካዬ። ዋልቃ ኤታ ጎመንጎካ እምምሳን ፍርደና ዋጭም ተይᎺዴ፥ በድ ጎመን ጎካ እምምሳን ባዛካይሳ እምንተና ጭለትቸን ተይᎺዴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ዋልቃ ኤታ ጎማጎካ ደእ ኤድ ሙደንዘን ዎልቃ ኮት Ꮊፍሴ፥ ሳብታ ስጣን ዉች እምንተንኬ ባዛካይሳ እምንተን ተይሰኮ ጭልምስባከስ ሙደና ዋልቃ ኤድ ማችባብ የሱስ ክርስቶስጎካ፥ ጋምንተካ ሰንፔካ ዶቅተረኬ። ");
INSERT INTO gyl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ይና ዋልቃባብ አዳመታ ጎመና ዋጭንታ ፍርደን ኤድ ሙደንዘን ተይᎺዳን ግንዳ ኮትኮግንደረ ዋልቃባብ የሱስ ክርስቶስታ ጭለትች ፍክስና በድንከስም ዋጭናርንካ ባዛካይሳ ማስሶ ሰንፔንም እምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","አዳመታ ክትምክሳ ነግንተንካ በድንከስ ጎማባብ ማቻንግንዳ ኮትኮግንደረ ክርስቶሰታ ክትምን ጎካ በድንከስ ጭልምደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ሙሴታ ህግንታ Ꮊድንተንካ ባች በጄ፥ ኬዛር ማቼ ጎማ በጃንደትከካ ሳብታ ዉቺ እምንተና ስግሶ በጄ። ");
INSERT INTO gyl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ኮነረ ማቻንዳ ደእንጎካ ጎመና ባንችምሳንግንዳ ሙደነረ ኮትግንዳ ዎንታ ጮይስን የሱስ ክርስቶስጎካ ስለንክንደታ ዶቅንት Ꮊፈርድንግንዳ ሳብታ ዉቺ እምንተና ጭለትቼን እምንተካ ባንችምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ይና Ꮊሮንት ጋይዳ? ሳብታ ዉቺ እምንተና በድንግንዳ ጎመካ ዳቅሶ ዶቅተሮቶ? ");
INSERT INTO gyl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ኩን ካዬ! ዎታ ደእዘንካ ፋስመርድንደትከካ ጎመዘንካ ፋስምስባብ ማትሶ ዶቅዶቶ Ꮊስግንዶንት ጎመካ ዳቅሶ ዶቅዳ? ");
INSERT INTO gyl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","የሱስ ክርስቶስካ ክክን ዋልቃ ማትካንታ ዎታ ስኤርስባብከስ ሙደና ክታ ደእንመረ ክትግንዳ ተይድባብ ማትካንታ ዎንታ ስእርንም ኤሳየቴ? ");
INSERT INTO gyl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ስእርንካ ክርስቶሰካ ክክን ዎ ዱከርሳን Ꮊይካ ክታ ደእንም ክትግንዳ ተይድባብ ማቶቴ፥ ኮካንታ ክርስቶስ ሳብ ባቤንታ ቦንቸካ ደእናርንካ አምሳንደት ግንዳ ዎተረ ክላ ዶቅንት ዶቅተሮቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ክርስቶስታ ደእንካ ክትካ ክክን ኮግንዳ ዋልቃ ዎ ማቼ ኮትኮግንዳ ክታ ደእናርንካ አምንተንካ ክትካ ክክን ዋልቃ ማዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ጎማ ፍግዝድን ዎንታ እዘና Ꮊልእተርንግንደከ ጎመታ አይላ ዎንታ ማትንተና ነግድንግንዳ ጎማ ፍግዝድን እዘን ክርስቶሰካ ክክን ሮከርሳንደትም ዎታ ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ደእሳን ኤድ ጎማካንታ ቆልማዬ። ");
INSERT INTO gyl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ይና ክርስቶሰካ ክክን ዎ ደእሴ ክትካ ክክን ሰንፔካ ዎ ዶቅድንደትም አሜንዶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ክርስቶስ ደእናርንካ አምሳንካንታ አናካርንካ ክት ደአይንደትምኬ ደእነረ ክታዘን ዎልቃ ካየንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ክት ደእሳንደትካ ጎማ ክተዘን ዎልቃ ዶቃይንግንዳ ካርንካ ጉጅምዳክንጎግካ ዋልቃዱት ኖ ደእቴ፥ ታየረ ሰንፔካ ኖ ዶቅድዮ ሳብካንታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ይና ደእ ኤድም ፋዝድንደትከካ ጎመዘንካ የታ ፋስምተቴ። የሱስ ክርስቶስጎካ ማቼ ሳብካንታ ሰንፔካ የ ዶቅድንደትም ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ኮካንታ ደእድን የንታ ዘነንዘን ጎመታ ዎልቃ ዶቅድንግንደኬ ዋሄታ አንግርን ካንተረ ቆልምድንግንዳ የም ይሳባብ ስክስት Ꮊይ እመቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ኮትኮግንደረ የንታ ዘነንታ ሱከንከስም ባችታ ፍክስ ር ማስሰቶ Ꮊይ ገችሰቴ፥ ኬዛር ማቼ ደእያርንካ አምሴቶ ስለንካ ዶቅድባብ የ ማቻንግንዳ ማስሰቶ የንታ ማተን ሳብካንታ እምከቴ፥ የንታ ዘነንታ ሱከንከስመረ ሙዳ ጭለትቼንታ ፍክስ ሪ ማስሰቶ ሳብካንታ ገችስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ታ የ ዶቅድንዳ ሳብታ ዉቺ እምንተንታ ጎያረት ዳት ሙሴታ ህግታ ጎያር የ ማታክንካንታ ጎማ የም Ꮊይ ቆላ። ");
INSERT INTO gyl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ይና Ꮊሮንት ጋይቴ? ሙሴታ ህግንታ ጎይናር ዎንታ ማትና ነግሶ ሳብታ ዉቺ እምንተንታ ጎያር ዎ ማቻንካንታ ጎማ ዎ ፍክሳ ጋይንትዮ? ቦድሶ ኩን ካዬ! ");
INSERT INTO gyl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ዋልቃ ኤድካንታ ፍክስባብ ማትሰቶ ክትምካንታ የንታ ማተንም የ ግግዝድንካ ክትኮ የ ክትምድን ኤችንካንታ ፍክስባብ የንታ ማትንተን ኤዝደቴ፥ ኮትኮግንደረ ጎማካንታ የ ክትምዴ ደእም የንዘን ተይ Ꮊድን ጎመታ ፍክስባብ ማደቴ፥ ሳብካንታ የ ክትምዴ ጭለትቼንም Ꮊፍተረቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","የታ እሪምሰቶ ጎመታ አይላ Ꮊቀቴ፥ ታ ማቼ የተያን ኤስስንካንታ ቡዳርንካ የንታ ክትምንካ ሳብካንታ ጋለትና ማታ። ");
INSERT INTO gyl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ጎመታ አይላርንካ ዉቺ ዉትሰቶ ጭለትቼንታ ፍክስንባብከስ ማተቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","እታ ኮግንዳ ኤድን አርድን አፈካ እ ኬዝድንደና የንታ ገቅርንታ ጋፍንዘንካ አምሳንዴ። እርምሰቶ የንታ ዘነንታ ሱከንከስም ቱነተኬ ባችታ ፍክስባብ ማስሰቶ የ ግግሳንደትግንዳ ሙዳ ኮትኮግንደረ ታ የንታ ዘነንታ ሱከንከስ ሳብካንታ ፋስምሳንዳ ማድንግንዳ ጭለትቼንታ ፍክስባብ ማስሰቶ እምከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ጎመታ አይላ ማትሰቶ የ Ꮊቃንደትካ ጭለትቼን ፍክስካንታ Ꮊረነረ የም ኤስማይ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ይና ኤና ኮታይካ Ꮊረንት መይድር Ꮊፍሳሬ? ታ የም ኦስንዝድን ሪዘንካ አብ Ꮊረነረ መይድር Ꮊፋከቴ፥ ኮትኮ ሪንተረ በእንተና ደእዬ። ");
INSERT INTO gyl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ታ ማቼ ጎመታ አይላትቻርንካ ዉቺ ዉትሰቶ ሳብታ ፍግዝድባብከስ የንታ ማትንተካ ሳብካንታ ፋስምስባብ ማደቴ፥ ሳብካንታ ፋስምንተረ በእንተና ስለንክንደታ ዶቅንትዬ። ");
INSERT INTO gyl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ጎመዘንካ Ꮊፈርድን ናክና ደእዬ፥ ሳብዘንካ እምምድን እምንተና ማቼ ዎንታ ጮይስን የሱስ ክርስቶስጎካ Ꮊፈርድንዳ ስለንክንደታ ዶቅንትዬ። ");
INSERT INTO gyl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","እስታ እስመንከስኬ ምችነንከሶ! ኮም የታ ኤሳየቴ? እከዝድንደና ህግም ኤዝድባብከስካንቴ፥ ህግ ኤድዘን ገችታ ኤራ ዶቅድንደና ኤድ ሰንፔካ ዶቅድንካ Ꮊክዬ ");
INSERT INTO gyl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ካምስካንታ፥ ይእሳን ኤተና ኮታ ክእስና ስንፔካ ክት ዶቅድን የለልታ ክትካ ክክን ህግካ ናዞክምሳንደ፥ ኮታ ክእስና ደእሳን ማቼ ይ ዞክምሳን ሙሴታ ህግንዘንካ ና ቡልምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ኮካንታ ክእስና ሰንፔካ ዶቅድንካ አብ አⷝና ኤር ኮት ይእሴ በልምንእንዳ ና ጋይምዴ። ኮታ ክእስና ደእሳንማቼ ክትካ ክክን ይ ዞክምሳን ህግንዘንካ ና ቡልምቴ፥ አብ አⷝና ኤር ኮት ይእሴረ በልምንእንዳ ና ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","እስታ እስመንከስኬ ምችነንከሶ የንተረ ይተና ኮትኮግንዴ፥ የታ ክርስቶሰታ ዘነንታ ሱካ የ ማቻን ጎካ ደእካ ፋስመርድንደትከካ ህግዘንካ ፋስምተቴ፥ ኮካንታ ሳብታ ፍክስንካንታ አፍ ዎ ኡዝድንግንዳ ደእናርንካ አምስባብ ክርስቶስታ ኮችንከስ ማተቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ኤታ ገቅርካ ዎ ኦንግድ Ꮊቃንደት Ꮊይካ ህግንዘንካ አምድን ዳቅል አንግርና ደእታ አፍ ዎ ኡስተርንግንዳ ዎንታ ዘነንታ ሱከንከሳር ፍግዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ታ ማቼ ዎም ዞክሶ Ꮊቃን ህግንዘንካ ደእዘንካ ፋስምከካ ዎ ፋስምሳን ካንታ ህግንታ ዞክነናርንካ ቡልምቶቴ፥ ኮካንታ ዎ ፍግዝድንዳ ክላ አያንንታ ክተንካ ዳቲ እርምሶ ጻፍምሳን ገሳ ሙሴታ ህግንታ ክተንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ይና Ꮊሮንት ጋይዳ? ሙሴታ ህግና ይንታ ማታርንካ ጎሞ? ኩን ካዬ! ኬዛር ማቼ ጎማ Ꮊራ ኮት ማቼረ እ ኤዝድንግንዳ እም ይሳንዳ ሙሴታ ህግዬ። ሙሴታ ህግና “Ꮊይ አንገሬ” ጋያክናና አንግር Ꮊራናንከረ እታ ኤዝዳክት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ጎማ ሙሴታ ህግንዘንካ Ꮊዳን ክተንካ ካሪ Ꮊፍሶ አንግርንም ሙዳ እ አንገርድን ግንዳ ይሴ። ሙሴታ ህግ ካያ ማቼ ጎማ ደእሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ኤና እሪ ሙሴታ ህግ ካየንደትᎺይካ እታ ሰንፔካ ዶቅድ Ꮊቃቴ፥ ሙሴታ ህግንታ ክተና Ꮊዳንደትካ ማቼ እ ደእስንካ ጎማ ካሪ Ꮊፍሴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ሰንፓ ካንተረ እምምሳንዳ ሙሴታ ህግንታ ክተና እስታዘን ደእንም ተይᎺዴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ጎማ ሙሴታ ህግንታ ክተንም ጎግ ማስሶ እም ገስሴ፥ ኮትኮ ክተንታ ጎግንከረ እም ደይሴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ኮካንታ ሙሴታ ህግና ጎመዘንካ ፋስምሳንዴ፥ ክተንከሰረ ፋስምሳንደትኬ ዶፈን ና ኡርሜ። ");
INSERT INTO gyl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ይና፥ ኮና ኡርማ ማቻን ሪና እካንታ ደእንም ተይᎺዳ ጋይንትዮ? ኩን ካዬ! ኬዛር ማቼ ጎማ፥ ጎማ ማትሶ Ꮊፈርድን ግንዳ ኡርማ ሪይንጎካ ደእንም እዘን ተይ Ꮊዴ፥ ኮነረ ማቻንዳ ጎማ ክተንጎካ እንድንካ ጎማ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ሙሴታ ህግና አያናርንካ ማትንተንም ኤዝዶቴ። እታ ማቼ ጎመታ አይላ ማትካንታ ሰንምስባብ ዋሄክንባብቴ ");
INSERT INTO gyl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","እታ እ ይድንደትም ኤዝዳክቴ እ ሶልምድንደትም ሪን ይይን ዛቅስቶ እ ቦዝድንደትም ርይም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ይና እ ይድንዳ እ ዝግዳክን ሪም ማቼ ሙሴታ ህግና ኡርማ ሪ ማትንተንም ማርከርድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","እ ይዝግዳክንደት ርይም እ ይድንዳ እስታ ዋር ዶቅድን ጎመና ዳት እታ ካይቴ ");
INSERT INTO gyl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","እንካ አነረ እስታ ዋሄታ እዘንካ Ꮊረሰነረ ኡርማ ሪካየንደትም ኤዝድቴ፥ ኡርማ ርይን ይይንታ ካንታ ዝግመት እስታ ዶቅስንከረ ዎራ ኮትኮ ኡርማ ርይን ይይካንታ ማድባብ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","እ ታ ይይያዶቅድንደና ይይካንታ እ ዝግድንደትም ኡርማ ሪይንም ይያቴ፥ ኬዛር ማቼ እ ዝግዳክንደትም ዳቅል ርይም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ይካንታ እ ዝግዳክንደትም ዳቅል ርይም እ ይድንዳ ማቼ ኮም ይድንዳ እስታ ዋር ዶቅድንዳ ጎመና ዳት እታ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ኮካንታ ህግ ፍክስዘን Ꮊቅንደትም ሰድቴ ኡርማ ርይን ይይካንታ እ ዝግድንካ ዳቅልሪ እ ይያባብ እም ገቀርስዚዴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","እስታ ዋርንዳ ሳብታ ህግንካ ጉርምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ማታጋካ ዳት እስታ ማክቼናር ህግንካ ክክን ይምኤረርቶ እስታ ዘነንታ ሱከንከስታ ዋር ፍግዝድን ጎመንታ ህግና ዞከርስባብ እም ማዝድንደትም አብ ህግ እስታ ዘነንታ ሱከናር ዶቅድንደትም ሰድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","እታ Ꮊረከካ መይዳክን ኤደረ! ኮ ደእድን ዘነንዘንካ Ꮊይ እም አቅዝዳ? ");
INSERT INTO gyl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ዎንታ ጮይስን የሱስ ክርስቶስጎካ እም አቅዝድን ሳብንካንታ ጋለት ማታ! ይና እታ እስታ ማክቼንካ፥ ሳብታ ህግንታ ቆልምድባብ እ ማድንካ እስታ ዋሄንታ እዘንካ ጎመታ ህግንካ ቆልምድባብ ማትቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ኮካንታ የሱስ ክርስቶስካ ዶቅድባብኬዘን ታ ከታዘን ኡርክ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","የሱስ ክርስቶስካ Ꮊፈርድንደትም ሰንፓ እምድን አያን ጭልንታ ህግና ጎመታርንኬ ደእታ ህግናርንካ ዉቺ ዎም ዉችቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ኤድ ጎማባብ ማትንተታ እዘንታ ጋፍንተንዘንካ አምሳንዳ፥ ሙሴታ ህግና ይይካንታ ማታክንደትም ሳብ ይቴ፥ ይንታ ገታ ይንችንመረ ጎመክንባብ ኤታ ካምስካ ጎማጎካ ኦይትሶ ክታ ዋሄንካ ጎመንም ፍርደካ Ꮊልእሴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ኮመረ ክት ይሳንደና ዋሄታ ጋይተካ ማታክናና አያንታ ጋይተንካ ዎ ኦንግድባብ ዎንካ ዶፈንን ሙሴታ ህግንታ ክተና ቦድምድን ግንዴ ");
INSERT INTO gyl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ኤታ ጎማ ፍግዝድን ዋሄንታ ጋይተካ ዶቅድባብከስ ኤታ ጎማ ፍግዝድን ዋሄንታ ገቅርን፥ አያንታ ጋይተንካ ዶቅድባብ ማቼ አያንታ ርይን ገቀርደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ኤታ ጎማ ፍግዝድን ዋሄትንደትም ገቅርና ደእም ተይᎺዴ፥ አያንትንደትም ገቅርና ማቼ ሰንፔንምኬ ሳራትችን እምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ኤታ ጎማ ፍግዝድን ዋሄትንደትም ገቅርድባብ ኤድ ሳብታ ህግንካንታ ክትማይን ካንተኬ ክትምካንተረ ማታይንካንታ ሳብካ ይምኤርድባቤ። ");
INSERT INTO gyl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ኤታ ጎማ ፍግዝድን ዋሄንታ ገቅርንካንታ ቆልምድባብከስ ሳብም ጉርምስካንታ ማታየኬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","የታ ማቼ ሳብታ አያን የንታዋር ዶቅድንዳ ማቼ አያንታ ገቅርካ ዳት ኤታ ጎማ ፍግዝድን ዋሄንታ ገቅርካ ዶቃየቴ፥ ክርስቶሰታ አያን ካየንባብ ኤታ ክርስቶሰታ ኖ ኮች ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","ክርስቶስ የንታዋር ማቼ Ꮊረሰረ ዎራ የንታ ዋሄና ጎመንጎካ ደእድንዳ ማቼ ሳብ የም ጭልሳንካንታ የንታ አያንና ሰንፔኬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","የሱሰም ደእያርንካ አምስባብ ሳብታ አያንና የንታዋር ዶቅሴ የሱስ ክርስቶሰም ደእያርንካ አምስባብ፥ የንታዋር ዶቅድን አያንንጎካ የንታ ደእድን ኤደትቼንካንታ ጮይስ ሰንፔን እምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ኮካንታ እስታ እስመንከስኬ ምችነንክሶ! ዎ ዶቅድን ዶቅንትንካ ነገዳክንዳ ባዛ ዎንዘን ዶቅዴ፥ ኬዛር ማቼ ኮና ዎንዘን ነገዳክን ባዘና ኤታ ጎማ ፍግዝድን ዋሄንታ ገቀርግንዳ ዶቅካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ኤታ ጎማ ፍግዝድን ዋሄንታ ገቅርካ የ ዶቅሴ ደእደቴ፥ ኬዛር ማቼ፥ አያንጭልንታ ዎልቀካ የንታ ጎማ ፍግዝድን ዋሄንታ ፍክስን የ ደይሴ ሰንፔካ ዶቅተረቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ሳብታ አያንካ ጎርስምድባብ ሙደና ሳብታ ይንችኬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ኮካንታ “ባቦ! ዎንታ ባቤኖ!” ጋይሰቶ የ ኤልድንድትም ክታ ይንች የ ማድንደታ አያን ተየት ዳት ጳስካ ዶቅካንታ አናካርንካ አይላትቸታ አያንን ተያከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ሳብታ አያን ዎንታ አያንንካ ክክን ማትሶ ሳብታ ይንች ዎንታ ማትንትን ዎካንታ ማርከርዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ይና ሳብታ ይንቺ ዎ ማቼ ክት ዎካንታ ግክሳንደትም ተይድባቦቴ፥ ክርስቶሰከረ ክክን ተይዶቴ፥ ታ ክርስቶሰታ ማጠን ተይድባብ ዎ ማቼ ኮታ ቡር ክታ ቦንቼን ካስምድባቦቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ታ ዎንታ ማጠና ኦስ እሪ ዎካንታ መያ ማድን ቦንቼንካ ክክን ዎ የርግዝደ Ꮊራ ርይከረ የካ ማትካንታ ማታይንደትም ፋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ፍዝር ሙዳ ሳብታ ይንችንከስታ መያ ማትን አንድር ሱነካ ካርዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ፍዝር ሙዳ ዉቺኩን ማድንግንዳ ፋረድምቴ፥ ኮነረ ይንታ ማታ አንግርካ ማታክናና ጉርምካ ካርዝድንግንዳ ይሳን ሳብታ ጋይተንኬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ጉርምነረ ፍዝርና ይንታ ማታርንካ ካይንተታ አይላትቻርንካ ዉቺ ዉትሶ ሳብታ ይንችንከስካ ክክን ዉቺ ማትንተተኬ ቦንቸን ካስምድባብ ማድንደት ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ፍዝር ሙደና ዋልቀዘን ታካ የለልታ እቺርታ ማጣ የጅንካ አትርዘን ዶቅድንደትም ዎታ ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ኬዛር ማቼ አትርዘን ዶቅድን ፍዝርና Ꮊክ ካዬ፥ እርንደትም አያን ጭልንታ ዉቺ እምንተን ዎታ ተይባብ ከስ ዎተረ ዎንታ ዘነንታ ናክ ማችባብ ሳብታ ይንች ማትንተን Ꮊድን ጉርምካ ካርሰሮቶ ዎንታ ዋር ዘነካ አትርዘን ዶቅዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ዎ አቃንደና ኮት ኮ Ꮊድን ጉርምንኬ። ኬዛር ማቼ Ꮊድን ጉርምን ዎ ይድን ርና ሰድምድንደትም ማቼ Ꮊድን ጉርም ማትና ነገዴ፥ ሰድምድንደትም Ꮊይ ጉርም ይዳ? ");
INSERT INTO gyl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ዎ ሰዳክን ርም ጉርም ዎ ይሳን ማቼ ዳንዳእካ ካርዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ኮት ኮግንደረ Ꮊስግንዳ ምክስ ዎም ዝግዝዳ ናከረ ዎ ኤዝዳክንካንታ አያን ጭልና ዎንታ ጋፍንካ ዎም አላ አልዴ፥ ኬዘካ መያ ማዳክንደት አትርካ ዎካንታ ጋልትምዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ኤታ ቡደን ኤዝድባብ ጮይስና አያን ጭልንታ ገቅርና Ꮊራ ኮት ማቸረ ኤዝዴ። አያን ጭልና አመንድባብከስካንታ ጋልትምድንዳ ሳብታ ጋይተንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ሳብም ሶልምድባብከስካንተኬ ክታ ጋይተን ግንደረ ኤልምስባብ ኤድንከስካንታ ሳብ ሙዳ ርን ኡርመን ከትካንታ ይድንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ኮነረ ማቻንደታ ጎግና እርምሶ ክት ኤስባብከስ ይንችንም ኬት ካምድንግንደኬ ይንችነረ በድ እስምንከስታ ዎክያርንካ ባይራ ማድንግንዳ ሳብ እርምሶ ማታ ጋይሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","እርምሶ ይ ማታ ጋይስባብከስም ኬትም ኤልሴ ይ ኤልስባብከስመረ ጭልሴ ይ ጭልስባብከስመረ ቦንችሴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ይና ኮርንካንታ Ꮊሮንት ጋይዳ? ሳብ ዎንካ ክክን ማቼ Ꮊይ ዎም ግርዳ? ");
INSERT INTO gyl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ሳብ ይንታ ይንች ዋልቀንካንታ አጨራክ ዶቅሶ ዎካንታ ስክስት ክት እምሳንካ Ꮊስግንዳ ይንታ ይንችንካ ክክን ሙዳ ርም ዉቺ ዎካንታ እማይንዳ? ");
INSERT INTO gyl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ሳብ እጅባብከስም Ꮊይ ካሴዝዳ? ኬትም ጭልዝድባብ ሳብ ኖዬ። ");
INSERT INTO gyl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ꮊይራ ፋረድባብ? የሱስ ክርስቶስ ኬታዘን ፋረዶ? ኖ ዎካንታ ደእስባብ፥ ደእያርንካ አምሶ ሳብ ባቤንታ ምዝዘን ዶቅስባብ ዎካንታ ጋልትምድባቤ። ");
INSERT INTO gyl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ክርስቶስታ ሶልመንዘንካ ዎም ፋስካንታ ማድባብ Ꮊይራ? ዘሮ አነረ ማጦ? ዳይርዮ፥ አነረ ዳቅዮ? አነረ ዘና ጫለንካ ማቶ፥ አነረ፥ ደእካንታ የልዝድንዶ? አነረ ማሶ? ");
INSERT INTO gyl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ኮነረ፥ “የስጎካ ሰጫ ሙዳᎺይካ በድ ርና ዎም ደይዝዴ፥ ማችምድን ቆልንከስ ግንደረ ፋይድምሶቴ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ይና ዎም ሶልምስባብ ክርስቶሰካ ከና ሪንከስም ሙዳ ጋምንተካ ጋምድባብከዘንካ ስግዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ኮካንታ ደእ ማቼረ ሰንፓ ማቼረ ክታይንች ማቼረ፥ ገችንባብከስ ማቼረ ታ ዶቅድንዳ ማቼረ ቡር Ꮊድንዳ ማቼረ አንድርንከስ ማቼረ፥ ");
INSERT INTO gyl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ጬክን ጋይንታ ማችንከረ ይርክን ጋይንታ ማቼረ Ꮊምነረ ፍዝር ማችንከረ ዎንታ ጮይስን የሱስ ክርስቶሰካ ዎ Ꮊፍሳን ሳብታ ሶልመንዘንካ ፋስካንታ ማድንዳ Ꮊረርየረ ካየንደትም ገታ ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ክርስቶሰካ ዶፍንን ኬዝድቴ፥ ማልዳክቴ፥ አያን ጭልንካ ጎርስምድንደና እስታ ገቀርንረ እ ማልዳክንድትም ማርከርዴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","አንድር ሞርእኬ ነገዳክንዳ ማጣ እስታ ቡዳር ዶቅዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ዋሄካ እስታ ሱሳ ማችባብ እስታ ገርነንከስካንታ ጋየርቶ እታ ክርስቶዘንካ ፋስምስቶ ሳብታ ባድና እዘን የልደረ ሶልምድት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ከታ እስራኤልን ከሰኬ፥ ሳበረ ከትም ይንታ ይንች ማስሴ፥ ይንታ ቦንቼንም ከትካንታ መያ ማስሴ፥ ጫቀረ ኬትካንታ አርደዴ፥ ሳብ ህገረ ኬትካንታ እምቴ፥ ሳብታ ጭል ኤሄንታ ጎይንንታ ዎገን ከትካንታ ሰችሴ፥ ጉርም ቃለን ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ኬታ ይንታ አጥርንካ ኤና እሪ ባቤንከዘንካ Ꮊድባብ ከሰኬ፥ ክርስቶሰረ ዋሄካ ክት Ꮊዳንዳ ከታ ሱሰናርንኬ፥ ኖ ኬት ሙደንዘንካ ስግዬ፥ ስለንክንደተረ አንጅምስባብ ጮይስዬ፥ አምንኤ! ");
INSERT INTO gyl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ማታጋካ ዳት ሳብታ ቃለና ኦክምቴ ጋይንት ካዬ፥ እስረልንከስታ ሱሳ ሙደና ዶፈን እስራልንከስ ካየኬ። ");
INSERT INTO gyl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ኮት ኮግንደረ አብራሀመታ ሱሳ ሙደና አብራሀመታ ይንቸኬ ጋይንት ካዬ። ሳብ አብራሀመም “ሱሳ የስካንታ አጥምድንዳ ይሳቀኬ” ክትካንታ ጋይሳንካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ኮካንታ ዋሄካ አጠርምስባብከስ ሳብታ ይንቺ ካየኬ ኬዛርካ ማቼ ሱሳ ማትሶ ፋይድምድባብከስ Ꮊድን ጉርም ቃለንታ ይንችንከስ Ꮊከኬ። ");
INSERT INTO gyl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ኮነረ ሳብ እምሳን ጉርም ቃለና “ታይን ለእ ስላ ኮዘን Ꮊድቴ፥ ሳረረ አⷝና ይንችና አእተሬ” ጋይድንዳ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ኮነረ Ꮊክ ማታክናና ሪብቃ ኤና እሪ አጥርምስባብ ዎንታ ባቤን ማችባብ ይሳቀዝንካ መንቲ ይንችንከስም ኮት ስርሳንደትካ፥ ");
INSERT INTO gyl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ሳብታ እድና ፍክስካ ማታክናና ኤልንተካ ማትን መያ ማስካንታ ቃስተን ይንችንከስ አጠርተርንደትኬ ዳቅልነረ ማታ ኡርመን ኬት ይተርንደታ እርምሶ ");
INSERT INTO gyl_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ሳብ ሪብቀም “ባይረና ይንታ ካንስንካንታ ቆልምድባብ ማተረ” ኮትካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ኮነረ “ያይቆበም ሶልምሳቴ ኤሳውም ማቼ ይዝንሳተ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ይና Ꮊሮንት ጋይቴ? ሳብ ኤታ ባለንካንታ ኦስንደ ጋይንትዮ? ሳብ ኤታ ባላካንታ ቦድሶ ኦስናዬ! ");
INSERT INTO gyl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ሳብ ሙሴም “እታ አጭርካንታ እ ዝግድባብም አጨርድቴ፥ እ ሶልማካንታ ዝግድባብም ሶልምድቴ” ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ኮካንታ ሳብታ እድና Ꮊፈርድንዳ ኤታ ጋይተኬ ኤታ ፍክስካ ማታክናና ሳብታ አጭርንኬ። ");
INSERT INTO gyl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ኮት ጎካ ጭል ማጻፍናር ግብጽ ፍጨንታ ባንችንካንታ “የስካ እስታ ዎልቀን ሰችካንተኬ እስታ ላምነረ ኮ ፍጫሙደንዘን ኤስምድንግንዳ ይካንታ የስም ባንችምስትቴ” ጋይድንዳ ቃላ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ኮካንታ ሳብ ይዝግድባብም አጨርዴ ይዝግዳክባብመረ ጉልማባብ ክትም ማዝዴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ኮካንታ “ሳብታ ጋይተን ግርካንታ Ꮊየሰነረ ማታዬ፥ ይና ኖ ኤድንከስም ከታ ዳቅል ፍክስንካ Ꮊረትክ ይንኤርዳ” ጋይሳዮ እም ኦይዝዳይ ማተራዬ። ");
INSERT INTO gyl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","የና ኤችኖ! ሳብካ ክክን በርምካንታ Ꮊራ የስታ ሽኒ ዶቅዳ? ድግድ ሪይና ኡርዝድባብም “Ꮊረተስ ኩን ይይሶ እም ኡርሳሬ?” ጋይካንታ ማዶ? ");
INSERT INTO gyl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ድግድ ር ኡርዝድባብ ዋልቃ ካምድን ፍጨዘንካ ዋልቀን ቦንቻካንታ፥ አብን መይዳክን ፍክስካንታ ማስሶ ፍክስካንታ ክታ እብላ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ሳብ ይንታ ዋጭንም ሰችካንተኬ ይንታ ዎልቀንም መይምስካንታ ዝግሶ ካይካንታ ግግምስባብከስም በድᎺይካ ኬትም ዳንዳእታናንከረ Ꮊረስ የና ኤዝዳ? ");
INSERT INTO gyl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ኮመረ ክት ይሳንደና እርምሶ ቦንቻካንታ ይ ግክሳን ይ አጨርስባብከስካንታ ይንታ ቦንቼንታ በድምን ሰችካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ክታ አጭርና አይሁድንከስም Ꮊክ ማታክናና አይሁድ ማታክባብከሳርከረ ዎም ኤልቴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ኮነረ ሳብዘንካ ኤሰርሶ ኬዝድባብ ሆሳዕካ፥ “እስታ ዎርሳ ማታክባብከስም ‘እስታ ዎርሳ!’ ሶልምማክንባብከስም ዎርሰን ‘ሶልምምስባብ!’ ጋይስቶ ኤልድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ኬታ ‘እስታ ዎርሳ ካየቴ’ ጋይምሳን ካርያር፥ ‘ስለንካ ዶቅድባብ ሳብንታ ይንች ጋይምሰኮ ኤልምደኬ’ ኩን ጋይምሳንግንዴ”። ");
INSERT INTO gyl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ኢሳሰረ እስራኤልንከስ ጎካ ኬዝድዮ፥ “እስራኤል ይንችንታ ፋይደነረ ባሀርናር ሻም ግንዳ በጀረ ዎራ ከታርንካ አቅድባብከስ ቶክመንከስ Ꮊከኬ፥ ");
INSERT INTO gyl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ጮይስ ጋምአክ ዶቅሶ ሳነካ ኮ ፍጫሙደንዘን ፍርደን ፋረዴ”። ኩንጋየሮ ይንታ ኡፍስንም ጬክሳ ይይሶ ኬዜ። ");
INSERT INTO gyl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ኮትኮግንደረ ኢስያስ “ሙደንም ቆልድባብ ጮይስና ሱሳ ክት ዎካንታ ነግሳክናና ሶዶመኬ ገሞራ ካተመንከስ ካይዳንግንዳ ዎተረ ካይዶት ዶቆ” ጋየሮ እርምሶ ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ይና Ꮊሮንት ጋይዳ ጭለትችን ጎርስማክባብ አይሁድማታክባብከስ ጭለትችን Ꮊፍሰኬ፥ ኮነረ ጭለትችና አመንዘንካ Ꮊፈርድንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ኬዛርካ ማቼ ጭልትችን Ꮊብዝድን ሙሴታ ህግን ጎርስምድ Ꮊቅባብ እስራኤልን ከስ ህግንም ቦድክሳ ከታ ነግንተንካ ጭለትችንደር የላከኬ። ");
INSERT INTO gyl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","“Ꮊራ ጎከረ ከት ጭላትችንደር ከት የላክንደና?” ጋይምሴ ከታ ጭለትችን Ꮊፍካንታ ከት ዝግዛንደና አሜንካ ማታክናና ፍክስካ ማቻንካንቴ፥ ኮካንታ ኮተርዝድን ሰይንካ ኮተርሰከ፥ ");
INSERT INTO gyl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ኮነረ፥ “ኮሰቸቴ ይና ኤድንከስም ኮተርዝድን ሰይንና ጽዮናር ዎድቴ፥ ኮነረ ሰይንና ኤድንከስም ኮተርስካ ዋችዝድንዳ ላዝዬ፥ ክትካ አሜንድባብ ማቼ ኦስናዬ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","እስታ እስመንከስኬ ምችነንከሶ! እስታ ቡዳር ዶቅድንደና አንድር አንግርንኬ ሳብድር እ ምግዝድን ምክስና እስራኤልንከስ አቅድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ዶፈን ኤሰንካ ማትክሳ ነግና ዳት ኬታ ሳብካንታ አያናር ቀምስ ዶቅድንደትም እታ እስታ ማታርንካ ኬትካንታ ማርከርድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ሳብ ኤድንከስም ጭልዝድንጎግን ኬታ ኤስክሳ ነግንካ ኬታ ይንታ ማተንም ጭለትችንታጎግን ጎርስምሰክ ዳት ሳብታ ጭለትችን ጎርስማከኬ። ");
INSERT INTO gyl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","ኤድ ሙዳ አሜንካ ጭልምድንግንዳ ሙሴታ ህግና ክርስቶሰካ ቦድምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ሙሴታ ህግን ጎርስምካ Ꮊፈርድን ጭለትችን ጎካ ሙሴ ጻፍሳንደና “ህግን ቦድባብ ሙደና ሰንፔካ ዶቅተሬ” ጋይድንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ሳብ ኤድንከስም አሜንካ ጭልዝድን ጎካ ማቼ፥ ኩን ጋይምሶ ጻፍምቴ “የስታ ቡደንካ ጭለዘን ውተርባብ Ꮊይራ?” Ꮊይ ጋዬ፥ ኮነረ ክርስቶሰም Ꮊንችካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","አነረ የስታ ቡዳር “ጩልጩል ጎርናር Ꮊይ Ꮊንቸርዳ” Ꮊይ ጋዬ፥ ኮነረ ክርስቶሰም ደእያርንካ አምስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ጉጅሰረ፥ “ሳብታ ቃለና የስታ ባንግሬ፥ ኮግንደረ የስታ አፈናርኬ የስታ ቡዳሬ” ኮነረ ቃለና ዎ ከዝድንደና አሜንንታ ቃለኔ። ኩን ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","የሱስ ጮይስ ማትንተን የስታ አፈንካ የስ ማርከርሰኬ ሳብ ክትም ደእያርንካ አምሳንደትመረ የስታ ቡዳርንካ የስ አሜንሴ አቅተራዬ። ");
INSERT INTO gyl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ኤድ ቡዳርንካ ይ አሜንሴ ጭልምዴ፥ ይንታ አፌከረ ይ ማርከርሴ አቅዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ጭል ማጻፍናር ጻፍምሳን ግንዳ “ክትካ አሜንድባብ ሙደና ኦስንዳክዬ”። ");
INSERT INTO gyl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ይና ዋልቃ ጮይስና ሙደንተረ ጮይስ ማቻን ካንታ አይሁድ ማችባብከስተኬ አይሁድ ማታክባብከስታ ዎክያር Ꮊረሰነረ ፋስም ካዬ፥ ኖ ጮይሰረ ምግዝድባብ ሙደንካንታ አንጀንም በችሶ እምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","“ጮይስታ ላምን ኤልድባብ ሙደና አቅዴ” ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ኬዛር ማቼ ክትካ አመናክዶቆ Ꮊስግንድክ ክትም ኤልካንታ ማዳ? ክትጎካ ኤሰራክ ዶቀኮ Ꮊስግንደክ አመንዳ? ሳባግድባብ ካያናና ኬታ Ꮊስግንድክ ኤስርካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ሳባግድባብከስ ኦይትማክንዳ ማቼ ቃለንም Ꮊስግንደክ ሳባክካንታ፥ ማዳ? ኮነረ “ኡርማ ክላ ኬዘንም ኬዝድባብከስታ Ꮊድንተና Ꮊስግንዶክ ጉርምዝዳ!” ጋይምሶ ጻፍምሳንደትግንዴ ");
INSERT INTO gyl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ኬዛር ማቼ ኢስያስ፥ “ጮይስዮ ዎ ኬዛን ቃለን Ꮊይ አመንሳራ፥ ጋይሶ ክት ኬዛንግንዳ ሙደነረ ክላ ኬዘንታ ቃለን አሜናከኬ። ");
INSERT INTO gyl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ኮካንታ አሜን Ꮊፈርድንዳ ክላ ኬዘንም ኤስርኬ፥ ክላ ከዘንተረ ቃለና Ꮊፈርድንዳ ክርስቶስጎካ ኬዝድን ሳብታ ቃለናርንኬ። ");
INSERT INTO gyl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ይና እ ኦይሳ፥ ኮማቼ ቃለንም ኤሰራክ ጋይንትዮ? ጭል ማጻፍናር፥ “ኬታ ኡፍስና ፍጫ ሙደናር ኤስምሴ፥ ኬታ ቃለነረ ፍጨታ ካንታ የለልታ የልሴ” ጋይምሶ ጻፍምሳን ግንዳ ገታ ኤሰርተኬ። ");
INSERT INTO gyl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ጉጅሰረ እስራኤልንከስ ቃለንም ኤሳከክ ጋይንትዮ? ኮና ጋይማይን ግንዳ ሙሴ እርምሶ “ቶችምሳን ዎርሰንካ ቀምስስስትቶ ኬትም ኡቅምስዝድቴ፥ ገቀርዳክን ዎርሰከረ ከትም ዋእስዝድቴ” ኖ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ኢሳሰረ፥ “እም ዝጋክባብ ከስካንታ Ꮊፈርሳቴ፥ ሳብ Ꮊብረ? ጋይሶ እም ኦይሳክባብከስካንተረ መያ ማቻቴ” ጋይንተካ ካርችካ ከስቴ። ");
INSERT INTO gyl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","እስራኤልንከስጎካ ማቼ፥ “ክትምዳክባብኬ ግርድን ዎርሰና እዝደር Ꮊድንግንዳ ሰጨንም ሙዳ እስታ አንንከስም ከትካንታ ኦይቻቴ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ይና ጉጅሶ እ ኦይሳ፥ ሳብ ይንታ ዎርሰን ዛቅቶ? ቦድሶ ዛቃክዬ! እታ እስታ ማታርንከረ እስራኤልቴ፥ አብራሀመታ ሱሳርንካ ማችባብ ብንያመታ አጥርያርንክቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ሳብ እርምሶ ይ እጅባብ ዎርሰንም ኖ ዛቃክዬ፥ ጭል ማጻፍና ኤላስጎካ Ꮊራ ጋይሳናከረ ገቀርዳከቴ? ጉጅሰረ ኤላስ እስራኤልታ ዎርሰን ሳብታ እሪ Ꮊራ ጋይሶ ካሰሳናከረ የታ ኤሳየቴ? ");
INSERT INTO gyl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","ኮትᎺይካ ኤላስ “ጮይስዮ! ሳብዘንካ ኤሰርሶ ኬዝድባብከስም ደይሰኬ፥ ዎንታ ካሲታ ካርንም ዉልእሰኬ፥ እታ Ꮊክ ነገድቴ እመረ ኬታ ደይስካንታ ዝግደኬ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ኬዛርካ ማቼ ሳብ Ꮊራ ጋይስክ ክትካንታ ማስሳረ? “ባአል ጋይምድን ሳብ ማታክን ካንታ ጎስታክባብከስ ታብዛ ሳአ ኤድ እካንታ ነግስትቴ” ክደር ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ታ ስለንከሳር ማቼ፥ ሳብታ ዉቺ እምንተንካ እድምሰኮ ነገድባብ ቶክም እስራኤልንከስ ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","እድና ሳብታ ዉቺ እምንተንካ ማቼ ፍክስዘንካ ማትንተና ነገታ ጋይንትዬ፥ ፍክስከስናንካ ሳብታ ዉች እምንተና መይዳክንዳ ማዳዶቆ። ");
INSERT INTO gyl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ይና አፍና Ꮊሮክ ማቻራ? እስራኤልንከስ ይ ዝግዛንደትም Ꮊፋከኬ፥ እድምስባብከስ ማቼ Ꮊፍሰኬ፥ ነገድባብከስ ኬታ ይንታ ቡደን ዳቅሰኬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ኮነረ ማቻንዳ “ሳብ ከታ ቡደና ገቀርዳክን ግንዳ ይሴ ኮካንታ ታካ የለልታ ከታ ይንታ አፍንካ ሰዳየኬ፥ ከታ ይንታ ቃምንከረ ኤሰራየኬ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ዳዊተረ፥ ኬት እችምካንታ ሳንምድን ካርና የድን ጭካ፥ ባልት ኦይድንዳ ጎር ማትሶ ኬትም ማእሳ! ከትይሳንዳ ዳቀልስና ከታዘን ማታ! ");
INSERT INTO gyl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ኬታ አፍና ሰዳክንግንዳ ኡማ፥ ኬታ ባዝደነረ ሙዳᎺይካ ኩዛ ኖ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ይና፥ ካርንካ እ ኦይሳ፥ አይሁድንከስ ዋቻንዳ አና ካርንካ አምምዳክን ግንዶ? ኩን ካዬ! አይሁድንከስታ ባችንታ ጎግካ አይሁድ ማታክባብከስ አቅንተን Ꮊፍሰኬ፥ ኮነረ ማቻንዳ አይሁድንከስ አይሁድ ማታክባብከስካ ኬት ይምኤርድን ግንዳ ይይካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","አይሁድንከስታ ባችና ፍጫሙደንካንታ በድ አንጀን Ꮊፍስስቴ፥ ኬተረ ዋችንተና አይሁድ ማታክባብ ከስካንታ አንጃ ማቴ፥ አይሁድንከስ አቅተስ ናና አንጀና በድ ማዳ ዶቆ! ");
INSERT INTO gyl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ታ ኮዘንካ እ ኬዝድንዳ የ አይሁድ ማታክባብከስካንቴ፥ አይሁድ ማታክባብከስተረ ኦይትምስባብ እ ማቻንከካ እስታ ሳብካንታ ፍክስካ ቦንቻ እካንታ ኤስምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ኮመረ እስታ ይይንተና እስታ ዋሀ ሱሳ ማቺባብከስም አይሁድንም ቀምስስካንታ፥ ኮ ይይተንከረ Ꮊረንግርካ ኬታርንካ ዋልቃ ዋልቀንከስ አቅንታካንታ ማደኬ ጋይንተኬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ሳብ አይሁድንከስም ዛቅሳንድት Ꮊይካ አብ ፍጫሙደንታ ዎርሰና ክትካክክን ኤድምሰ ሳብ ይ ዛቅስባብ ኬትም ይንደር ማዝድንᎺይካ Ꮊራ ማድንደትሞክ የንደር ካምዳ? ኮነረ ደእያርንካ አምንታከኬ! ");
INSERT INTO gyl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ዋልቃ ካምድን ማጠናርንካ እርንደና ሳብካንታ ፋስምሳንዳ ማጠና ሙዳ ሳብካንታ ፋስምሳንዳ ማዴ ኮት ኮግንደረ ዋልቃ Ꮊቀንታ ጫጭና ሳብካንታ ፋስምሳንዳ ማቼ ሳቀና ሳብካንታ ፋስምስባብከስ ማደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ኬዛር ማቼ ዎይራ Ꮊቀንታ ሳቀንከስ ማችባብ አይሁድና ፋክምሶ ኬት ዋቻንካ የታ ድራር Ꮊቃ ዎይረንታ ሳቀንከስ ማችባብ አይሁድ ማታክባብከስ ኬታ ካርያር ማትሰቶ ኬታ ቆልመንምኬ አንጀንም ካስምድባብከስ የማቼ፥ ");
INSERT INTO gyl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","የታ አይሁድ ማታክባብከስ ፋክምሶ ዋችባብ ሳቀንከስ ግንደና አይሁድን ኬዘን Ꮊይ ኦተረቴ፥ የ ኦተርሳን ማቼ የታ ሳቀና Ꮊክ የንታ ማትንተንካ ጫጭና የም ባልዳ ዳት የታ ጫጭንም ባልዳክባብ የንታ ማትንተንም ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ኬዛርንካ ማቼ “ሳቀንከስ ቁንጭምሶ ዋቻንዳ እታ ኬታ ካርዘን እ ማድንግንዴ” የታ ጋይደት ማዴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","የንታ ጋይተና ገቴ፥ ኬዛር ማቼ ኬታ ፋክምሶ ከት ዋቻንዳ ኬታ አሜንክሳ ነግንተንካ ማድንካ የታ ዳቅሰቶ የ ዎእሳንዳ የንታ አሜንኬ፥ ይና ጳስ ዝግዝዳ ዳት ኦትራ የም ዝግሳዬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ሳብ ፍዝርካ ሳቀንከስ ማችባብ አይሁድንከስካንታ አጨራክንዳ ማቼ የካንተረ አጨራዬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ይና ሳብታ ላቅምንኬ ክታ ጋርዘንም ሰትከቴ፥ ክታ ጋርዝምና ሰችዝድንዳ ዋችባብኬዘን ማድንካ ይንታ ላቅምን ክት ሰችዝድንዳ የካንቴ፥ ኮት ኮመረ ክት ይድንዳ ክትም አሜንካ ዳቅሰቶ የ ዶቅሴ፥ የ ዳቃክንዳ ማቼ የተረ ፋክምሰቶ ዋጅደቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","አይሁድንከስ አሜንክሳ ይንታ ነግንተንም ኬት ዛቅሳንዳ ማቼ ኤና ይንታ እሪ ካርናር ማደኬ፥ ሳበረ ኤና እሪ ኬታ ካርናር ኬትም ማዝዴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","የታ አይሁድማታክባብ ከስ ማቼ የንታ ፍዝርንካ ድራር ዎይራ Ꮊቀንታ ሳቀን ማትሰቶ የ ዶቅድንካ የንታ ካር ካይሳ Ꮊምያር ዎይራ Ꮊቀንታዘን ኮርምካንታ ማተቴ፥ ኩን ማቼ ከታኬና ይንታ ፍዝርንካ Ꮊምያር ዎይራ Ꮊቀንታ ሳቀንከስ ማችባብ አይሁድና ኤና እሪ ይንታ ካርናር ማትሰኮ Ꮊረተረ ከት ኮርማይንዳ! ");
INSERT INTO gyl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","እስታ እስመንከስኬ ምችነንከሶ! “ዎታ ኤዝድባብከሶቴ” ጋይሰቶ Ꮊይ ጋይረቴ፥ እ የም ኬዝድንዳ ዋልቃ አችምሳን ር ዶቅዴ፥ ና ኮነረ እስረልንከስታ ዋይ ጋይንተና ቦጅድንዳ ማታክናና አይሁድማታክባብከስ ሙደና ነጋክ ዶቆ ሳብደር ከት Ꮊተርን የለልቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ይና ኮግንደካ እስራኤልንከስ ሙዳ አቅደኬ። ኮካንተረ፥ አቅስንባብ ጽዮናርንካ Ꮊዴ፥ ያይቆበተረ ሱሰን ሙደንዘንካ ዳቀልስን Ꮊልእዝዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ኬታ ጎመንመረ ኬትካንታ እ ካይሳንደትካ ኬትካ ክክን እ አርድንዳ ጫቀና ኮኔ። ኩንጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","እስራኤልንከስ ክላ ኬዘንታ ቃለንም ኬታ ተይክሳ ነግንተንካ የጎካ አይሁድ ማታክባብከስታ መይንጎካ ሳብካ ይምኤርድባብ ማተኬ፥ ኬዛርካ ማቼ ከታእድምንካ ኤና እሪ ባቤንከስታ አጥርንጎካ ሳብታ ገርነንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ሳብ ይ እጃንደታ ቡርከ ይንታ ዉች እምንተን ይ እምሳንደታ ቡር ይ ይሳን ሪይንካ ኡቅማዬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","የታ አይሁድ ማታክባብከስ ኤና እሪ ሳብካንታ ክትምዳክባብ Ꮊቀቴ፥ ታ ማቼ አይሁድንከስ ክትምክሳ ነግንተንጎካ የታ ሳብታ ኣጭሪንም Ꮊፍሰቴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","የታ ኣጭሪንም የ Ꮊፍሳንደትካ፥ ከተረ ኣጭሪንም Ꮊብድንግንዳ ኬታ ታ ሳብካንታ ክትምዳክባብከስ ማተኬ። ");
INSERT INTO gyl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ሳብ ይንታ ኣጭሪንም ኤድ ሙደን ሰችካንታ ጋየሮ ኤድንከስ ሙዳ ኬታ ይንታ ዋይ ጋይንተንካ ዞከርስባብ ከት ማድንግንዳ ከትም ይሴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ሳብታ ቆልንተንኬ ኤጫ፥ ኤሰነረ Ꮊሰን ይስንከረ የልምዳክንዴ! ክታ ፍርደነረ ገቀርምዳክንዳ፥ ክታ ጎግነረ ኤስምዳክንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“ጮይስታ ገቅርን ኤዝድባብ Ꮊይራ? ክትም ዞርድባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ሳብ ማስት እምድንግንዳ ታልቅድባብኬ ይ ታልቅስንደትመረ ማስት እምድንግንዳ ኦይዝድባብ Ꮊይራ?” ");
INSERT INTO gyl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ሙዳ ርና Ꮊፈርሳንደና ክታዘንካ፥ ክትኬ ክትካንቴ፥ ስለንክንደትካንታ ቦንቻ ክትካንታ ማታ! አምንኤ! ");
INSERT INTO gyl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ይና እስታ እስመንከስኬ ምችነንከሶ! ሳብም ጉርምዝድን፥ ስለንካ ማቻንደትምኬ ሳብካንታ ፋስምሳን ካስ ማስሰቶ የንታ ኤደትቼን የ ግክስተርንግንዳ አጨርንባብ ሳብታ ላምንካ የም ምግዝድቴ፥ ኮነረ ግክስ የም ዝግዝድንደና ሉላ ማቻንዳ ሳብካንታ ጎይንኔ። ");
INSERT INTO gyl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ኡርመንምኬ ጉርምዝድንደትም ቦድማ ማቻን ሳብታ ጋይተንም የ ኤስተርንግንዳ የንታ ማክቼን ኡርስካ ሰንፔና የንታ ኦክማ ዳት ኮ ፍጫሙደንታ ዳቅል ፍክስን Ꮊይካመቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ጉጅሰረ የታ ዋልቃ ዋልቀንከስ ሳብ የካንታ እምሳን አመንንከካ ማተን የንታ ይርክሳ ይንተካ ገቀርከት ዳት የም ዝግዝድንደትዘንካ ስግ የንታ ማታ ካንታ ኦተረካ Ꮊይ ገቀረቴ ጋይስቶ እካንታ እመርሳን ዉች እምንተንካ የም ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ዋልቃ ዎንታ ዘነንዘን በድ ሱከንከስ ዶቅደኬ፥ ዋልቃ ዋልቃ ዘነንታ ሱከንከስ ᎺክᎺክ ፍክስ ኬታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ኮትኮግንደረ ዎታ በድንከስ ማትሶ ዶቅዶቶ ክርስቶስካ ዋልቃ ሱኮቴ ዋልቃ ዘነታ ሱከንከስ ዎንታ ማትንተከረ ክክ ክክ የድምቶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ኮካንታ ሳብ ይንታ ዉች እምንተንካ ዎካንታ ክት እምሳንደትም Ꮊክ Ꮊክ ፍክስዘን Ꮊቅስተሮቴ፥ ዎንታ እምንተነረ ሳብታ ቤርን ኬዛ ማቼ ዎንታ አመንንከካ ሳብታ ቤርን ኬዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ዎንታ እምንተና አብንከስካንታ ፍክስ ኮት ማቼ ዳቅሶ ዎ ፍክሳ፥ ዎንታ እምንተና ኤስስ ማቼ ዎም ዝግዝድን ከካ ዎ ኤስሳ፥ ");
INSERT INTO gyl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ዎንታ እምንተና ዞራ ኮት ማቼ ዎ ዞራ፥ ዎንታ እምንተና አብንከስካንታ እመርድንደታ ኮት ማቼ ቡዳርንካ ዎ እማ፥ ዎንታ እምንተና ገችስ ኮት ማቼ ዳቅንተካ ዎ ገችሳ፥ ዎንታ እምንተና አጭር ኮት ማቼ ኮትኮም ጉርምካ ይቶሮቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ሴካ ካየንዳ ዶፈን የንታ ሶልማ የካንታ ዶቃ፥ ዳቅል ርይን ዛእከቴ፥ ኡርማ ርይም ጎርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","ክክ ክክ እስመንኬ ካንስካ ግንዳ ሶልምከቴ፥ ክክ ክክ ቦንችከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","ጋፋከት ዶቆ ቡዳርንካ ማቻን የንታ ገታ አያናር ማትሰቶ ጮይስካንታ ፍክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Ꮊድን ጉርምንከረ የም ጉርምሳ ማጣᎺይከረ ዳንዳእከቴ፥ ሙዳᎺይካ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","አሜንድባብ የንታ እስመንከስምኬ ምችነንከስም ኬታ ማጠንካ የንታ ዶቅድንደትዘንካ ፋስተቶ አላ አልከቴ፥ ሶች ማትሶ Ꮊድባብከስመረ ሞከን Ꮊይባቀረቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","የም ዳይድባብከስም አንጅከቴ፥ ከትም አንጅከት ዳት ከትም Ꮊይ ባደቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","ጉርምድባብ ከስካ ክክን የም ጉርምሳ፥ ኤብድባብ ከስካ ክክነረ ኤፍከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ክክ ክከረ ዋልቃ ገቅርካ ኤእሰቶ ዶእከቴ፥ የንታ ማቴን ጬክሳ ይንተዘንካ ስግስሶ ኦትረንም ዎይስሰቶ ይርክን ጋይስባብከስካ ካየንባብከስካ ክክን ዋልቃትችካ ዶእከቴ የታ የንታ ማታርንካ ኤዝድባቦቴ Ꮊይ ጋየቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","ኤድ ሙደንታ እር ኡርማ ማቻን ሪ ይከት ዳት፥ ኤድንከስ የንዘን ዳቅልሪ ይድንካ የተረ ማስተቶ ዳቅል ርይም ከታዘን Ꮊይ ይየቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","የንደር ማድንዳ ማቼ ኤድ ሙደንካ ክክን ኡርመካ ዶቅካንታ የጎካ ዝግዝድንደትም ሙዳ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","እስታ ገርነንከሶ! ዋጭመን ሳብካንታ ዛእከት ዳት የንት Ꮊይ ይምኤረቴ፥ “ይምኤንም ማዝድባብኬ ይምኤንታ ካርያር ናግድባብ እትቴ ጋይዴ ጮይስ” ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","ኮካንታ ይምኤን ማስን ዛቅሳዮ የስታ ይምኤንባብም ዳቅሴ እችስካ፥ ክት ዎቸርሰረ ዎእስካ፥ ኮም የስታ ይይንተንካ ኖሀ ዎልስም ክታዘን የስታ ዎድንካ ኖሄካ አትርሶ ኦስንድንደትግንዳ ኖ ኦስንተሬ ");
INSERT INTO gyl_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","ኮካንታ ዳቅል ሪይንም ኡርማ ሪካ ጋምካ ዳት ዳቅልርንካ Ꮊይ ጋመሬ። ");
INSERT INTO gyl_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ꮊምነረ ገችታ ኤራ Ꮊፈርድንዳ ሳብታ ጋይተንካ ማቻን ካንታ ታ ዶቅድባብከሰረ ገችንታ ኤረንባብከስ ኬት ዶርምሳንዳ፥ ሳብካ ማቻንካንታ ኤድ ሙደና ኬትም ገችዝድባብከስካንታ ክትም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","ኮካንታ ገችታ ኤረንባብከስም ግርድባብ ሙደና ሳብታ ክተንም ግርደኬ ክትምዳክባብ ሙደና ይንታዘን ዋጭታ ፍርደንም ተይ Ꮊዴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","ቆልድባብከስ ኬት ጳስዝድንደና ዳቅልን ይድባብከስም ዳት ኡርማ ይድባብከስም ካዬ፥ ገችንታ ኤረንባብከስም ጳስክሳ ነግካንታ ዝግዳ? ይና ኡርማ ርይም ይካ፥ ኡርማ የስታ ፍክስንካ ቦንቼን Ꮊብደዬ። ");
INSERT INTO gyl_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ገችንታ ኤረንባብ የስካንታ ኡርማ ይድንግንዳ ዶርምስባብ ሳብታ ፍክስባቤ፥ ገችንታ ኤረንባብ ከት ማሳ ሶቀርሳንዳ ዉችኩን ማታክን ካንታ ዳቅልን ይድባብ የስማቼ ገችንታ ኤረንባብከስም ጳስካ፥ ኖ ዳቅል ይድባብከስም ዋጨርንደትኬ ሳብታ ይምኤንም ማስካ ሳብካንታ ፍግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","ኮካንታ ባንችንታ ገችታ ኤረንባብከስካንታ ክትም የም ዝግዝዴ የ ክትምድንደረ ሳብታ ዋጭን ጳስካ Ꮊክ ማታክናና የንታ ገቅርና የም ገቀርዝድን ካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ግራ የ ግርድንዳ ኮካንቴ፥ ገችንታ ኤረንባብከስ ኮ ፍክስንዘን ማችባብከስ ሳብካንታ ፍግዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ይና ገችታ ኤራ ዶቅድባብካንታ ይይዝግዝድንደትም ሙዳ ይከቴ፥ ግራ ዝግዝድባብካንታ ግራ ቃረጭ ዝግዝድባብካንታ ቃረጭን ናከቴ፥ ጳስ ዝግዝድባብካንታ ጳስ፥ ቦንቻ ዝግዝድባብካንታ ቦንቸም እምከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Ꮊየንተረ ባዛ የንዘን Ꮊይ ዶቃ፥ የንዘን ዶቅ ዝግዝድን ባዘና ክክ ክክ ሶልማ Ꮊክ ማታ። ኤድም ሶልምድባብ ሙሴታ ህግን ቦዴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","“Ꮊይቤልመ፥ Ꮊይደይሴ፥ Ꮊይ ድቤ፥ አብ ኤታ ማቻንደትም Ꮊረነረ Ꮊይ አንገሬ” ጋይድን ክተንከስኬ አብ ክተንከስ ሙዳ “ኤድም የስታ ማታግንዳ ማስሶ ሶልምካ” ጋይድን ክታ ሙደና ኮታር የድምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ኤድም ሶልምድባብ ሙዳ ይ ሶልምድባብዘን ዳቅልር ክታዘን ይዳክዬ፥ ኮካንታ ኤድም ሶልምድባብ ሙሴታ ህግን ሙዳ ቦዴ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","ይና ግንአርንካ የ አምድንደታ ሳዓትና ታ የልሳንደትም ኤስከቴ፥ ኤና እር ዎ አሜንሳንደትዘንካ ስግስሶ ታ ዎ አቅድንደታ ሰጨና እንድንካ ዎንደር የልቴ። ");
INSERT INTO gyl_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","ሶይትና ስገዶቅዴ ሰጨነረ የልቴ፥ ኮካንታ ኡማር ፍክስምድንደትም ፍክስን ዛቅቶሮቴ፥ ሳክመንትንደትም ዳምንታ ቆብርን ዎ ቆብራ። ");
INSERT INTO gyl_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","ሳክማር ዎ ኦንግድንደትግንዳ ኦንግተሮት ዳት፥ ይግካ፥ ጎዝካ፥ ቤልምካ፥ ኦከካ፥ ጫንጭኬ ቀምስካ፥ ማታክናና፥ ሳክማር ዶቅድባብ ከስግንዳ ዎንታ ማተን ካርስሶ ዎ ኦንጋ። ");
INSERT INTO gyl_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ኬዛር ማቼ ጮይስ የሱስ ክርስቶሰም ቆበርከት ዳት የንታ ዋሄንታ አንግርን ጉርምስካንታ Ꮊይገቀረቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","የንታ ዎክያር ይንታ አሜንካ ጋፍስባብ ኤድ ዶቅሴ ፈንካ የንደር ማስከት ዳት ክታ ገቅርንም ይንኤርካ Ꮊይፋረደቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","ዋልቃ ኤድ Ꮊራ ሪመረ ክት እጅድንግንዳ ይስዝድንዳ አሜን ክታ ዶቅተሬ፥ ይንታ አሜንካ ዳቃክን ኤድ ማቼ ኮርምሳን ርይም Ꮊክ እጅዴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","ኮካንታ Ꮊምንመረ ሪ እጅድ ኤድ እጅዳክን ኤድም Ꮊይ ይንኤራ እጅዳክባበረ እጅድን ኤድዘን Ꮊይ ክት ፋረዳ፥ ክትመረ ሳብ ኡርማ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ይና አብ ኤድ ፍክስንባብዘን ፋረድባብ የና Ꮊይራ? ክት ዎእሴ አነረ ክት ዋቼረ ይንታ ጮይስካንቴ። ኮት ኮትኮግንደረ ሳብ ክትም ዎይዚድንካንታ ዳቅሶ ዎእዴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ኮትኮግንደረ ዋልቃ ሰጨና አብ ሰጨንዘንካ ስግሶ ቦንችምሳንዴ ጋይሶ ገቀርድባብ ዶቅዳ ማተረ፥ አብነረ ጉጅሶ ሰጨንከስ ሙዳ የካ ቦንቻ ኬታ ዶቅዳ ዳት ሰጨንከስታ ዎክያር ፋስም ካዬ ጋይሶ ገቀርዴ። ይና ኮም ካምሳን ሪይንካ ዋልቃ ዋልቃ ኤድና ይንታ ቡዳርንካ አመንሳንደትም ክት ይያ። ");
INSERT INTO gyl_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ዋልቃ ሰጨን አብ ሰጨንዘንካ ስግስሶ ቦንጅድባብ ኤድ ይ ዶቅሴ ኮም ክታ ይተና ጮይስካንታ ቦንቼ ጋይሴ፥ Ꮊምነረ እችምን እጅድባብ ጮይስታ ቦንቻካንታ ጋይሶ እጅዴ፥ ይ እጅድን እችምንተረ ሳብም ጋለዴ፥ Ꮊምነረ እችም እጅዳክባብ ጮይስታ ቦንቻካንታ ጋይሶ እቻዬ፥ ይንታ እችክሳ ነግንተንከረ ሳብም ጋለዴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","ዎንታርንካ Ꮊየነረ ይንታ ማታ ካንታ ዶቅሶ ይንታ ማታ ካንታ ደእድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","ዎ ዶቅሴ ጮይስካንታ ዶቅዶቴ ዎ ደእደሬ ጮይስካንታ ደእዶቴ፥ ኮካንታ ዎ ዶቅሰረ፥ ዎ ደእደሬ ጮይስቶቴ ");
INSERT INTO gyl_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","ኮካንታ ክርስቶስ ደእሶ ደእያርንካ አምሳንዳ አፈካ ዶቅድባብተኬ ደእስባብከስታ ጮይስማት ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","ይና የና የስታ እስመንታ ዘን Ꮊረተስ ፋረዳ? አነረ የስታ እስመንም Ꮊረተስ ቶችዝዳ? ዎታ ሙደና ሳብታ ፍርዳ ካርንዘን ዎእዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","ኮጎከረ “እታ ስለንካ ዶቅድባብቴ ጋይዴ ሳብ፥ ኤድ ሙደና ይንታ ቡቀንካ እስታ እሪ ጉምፈርደኬ፥ ይንታ አድምንከረ እ ሳብ ማትንተን ማርከርዴ” ጋይምሶ ጻፍምቴ ");
INSERT INTO gyl_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","ኮካንታ ዎታ ዋልቃ ዋልቀና ዎንታ ማታ ፍክስንታ ሳብታ እር የልሶቶ ዎ ኦይስምድንደታ ማስንም ማዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","ኮካንታ ዎንታርንካ ዋልቃባብ ዋልቃባብዘን ዎ Ꮊይፋረዳ፥ ኬዛር ማቼ Ꮊየነረ ኤድ ይንታ እስመንዘን ኮተርዝድባብ አነረ ጎሄርዝድባብ ማትንዘንካ ክት ካርስማ። ");
INSERT INTO gyl_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","ዋልቃ ር ቱነ ጋይሶ ገቀርድባብ ኤችካንታ ና ሪይና ክትካንታ ቱና ማዳ ዳት Ꮊምነረ ሪ ይንታ ማታርንካ ቱና ማታክንደትም ጮይስ የሱሰካ ኤስስትቴ ");
INSERT INTO gyl_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","የና የስ እጅድን እችምን ጎካ የስታ እስመንካንታ ጎሀ የስ ማቼ ሶልመካ የና ዶቅድባብ ካያዬ፥ ኮካንታ ክርስቶስ ክትካንታ ደእስባብ ኤድ የስ እጅድን እችምን ጎካ ካይድን ግንዳ Ꮊይ ይዬ። ");
INSERT INTO gyl_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","ይና የንደር ኡርማ ማቻን ርይም አብንከስካንታ ይንኤርድን ግንዳ Ꮊይ የቴ ");
INSERT INTO gyl_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","ሳብታ ባንችምና አያን ጭልንካ Ꮊፈርድንዳ ጭለትች፥ ሳራትችኬ ጉርምካ ዳት እችምኬ ዎጭምካ ሰችዝድንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","ኮግንደካ ክርስቶስካንታ ፍግዝድባብ ኤድ ሳብም ጉርምዝዴ፥ ኤደረረ ቦንችምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","ኮካንታ ሳራትች Ꮊፈርድንደትምኬ ክክ ክክ ዳቅሰሮቶ ጎርስምተሮቴ። ");
INSERT INTO gyl_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","እችምታ ጎግካ ሳብታ ፍክስን ዎ Ꮊይዉልአ። እችም ሙደና ኡርሜ፥ ኬዛር ማቼ አብ ኤድም ኮተርዝድን እችምን እችና ኡርማ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","ኮካንታ የስታ እስመንም ኮተርዚዳክን ግንዳ ዋሀ እችክሳ፥ ዎጭምንመረ ዎጭክሳ ነግና፥ አነረ Ꮊምንመረ ኮተርዝድን ርይም ይክሳ ነግና ኡርሜ። ");
INSERT INTO gyl_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","ይና ኮና የስታ አሜንና የስተኬ ሳብተካ ዎክያር ማታ፥ ኮናገቴ ጋይሶ ይ አሜንድን ርን ክት ይድንካ ክታ ገቅርና ክትም ገቀርዝዳክባብ ኤድ ቦንችምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ꮊኤረሮ እጅድባብ ኤድ ማቼ ክቴና አሜንዘን ማታክንካንታ ክታዘን ፋረዴ፥ አሜንካ ይይማክን ሪሙደና ጎሜ። ");
INSERT INTO gyl_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","ዎታ አሜንካ ዳቅማ ማችባብ፥ አሜንካ ጋፍስባብከስታ ጋፍንም ባላ ዎም ዝግዝዳ ዳት ዎንታ ማተን Ꮊክ ጉርምዝድባብ ማት ዝክሳዬ፥ ");
INSERT INTO gyl_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","ዎታ ዋልቃ ዋልቀና አብ ኤድና ይንታ አሜንካ ክት ዛብድን ግንዳ ክትም መይድንደትምኬ ክትም ጉርምዝድን ሪ ዎ ይያ። ");
INSERT INTO gyl_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","ክርስቶስ ይንታ ማተንም ጉርምሳክዬ፥ ስግስሰረ “ኤድንከስ የስም የክሳን የክና እስታዘን የልሴ” ጋይድንደና ጭል ማጻፍንከስታ ጋይተና ክታዘን የልሴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","ጭል ማጻፍንከሳርንካ ዎ Ꮊብድ ሪይና ዳንዳእኬ ዳቅንተካ Ꮊድን ጉርም ዎንታ ዶቅድንግንዳ እርምሶ ጻፍምስባብ ሙደና ኤስስታ ዎካንታ ማድንግንዳ ጻፍምተኬ። ");
INSERT INTO gyl_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","ዳንዳእንምኬ ዳቅንተን እምድባብ ጮይስና ክክ ክክ የሱስ ክርስቶሰታ ካምስን ጎርስምካ የካ ዶቅንትታ ዋልቃትችን የካንታ እማ። ");
INSERT INTO gyl_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","ኮትኮግንደረ ዎንታ ጮይስን የሱስ ክርስቶሰታ ባቤን ሳብና ዋልቃ ቡደኬ ዋልቃ ኬዝካ ክትም ቦንችተርን ግንዳ የምክት ማሳ። ");
INSERT INTO gyl_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","ክርስቶስ ሳብታ ቦንቻካንታ የም ክት ተያንደትግንዳ የታ ሙደነረ ዋልቀና አብን ጉርምካ ሞካ። ");
INSERT INTO gyl_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","ኮመረ ክት ኬዝድንካ ሳብ ኤና እር ባበንከስካንታ ክት እምሳንዳ Ꮊድን ጉርምና ቦድንግንደኬ ሳብተረ ዶፈንና ኤስምድን ግንዳ ክርስቶስ አይሁድንከስካንታ ፍክስባብ ማቼ እስታ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","ክርስቶስ አይሁድንከስታ ፍክስንባብ ክት ማቻንደረ አብ ጎግና አይሁድማታክባብከስ ሳብም ክታ አጭርንጎካ ኬት ጋለድንግንዴ፥ ኮነረ፥ “ኮካንታ አይሁድ ማታክባብ ከስታ ዎክናር የስም ጋለድቴ የስታ ላምንካንተረ ጋለትካ የጅድቴ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","ጉጅሰረ፥ “የታ አይሁድ ማታክባብከሶ፥ ሳብታ ዎርሰንካ ክክን የም ጉርምሳ!” ጋይምሶ ጻፍምቴ ");
INSERT INTO gyl_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","ካርንከረ “አይሁድ ማታክባብከስ ሙዳ! ጮይስም ጋለትከቴ፥ ዎርሳ ሙደነረ ጋለትከቴ!” ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","ኮትኮግንደረ ኢስያስ፥ “እሴይታ ሱሱሳርንካ አጥምድባብ Ꮊዴ፥ አይሁድማታክባብከስተረ ጎርስባብ ማትሶ አምዴ፥ ከተረ ይንታ Ꮊድን ጉርምን ክታዘን ይደኬ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","የንታ Ꮊድን ጉርምና አያን ጭልንታ ዎልቀካ ጋጰሮ አይድንግንዳ Ꮊድን ጉርምን እምድባብ ጮይስን ክትካ የንታ አሜንምንካ ጉርምኬ ሳራትችን በችሶ የካንታ እማ። ");
INSERT INTO gyl_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","እስታ እስመንከስኬ ምችነንከሶ! ላቅም ኤድ የንታ ማትንተንካ ኤሰካ ጋጵስባብኬ የታ ዋልቃ ዋልቀነረ አብንም ዞራካንታ ማድባብ የንታ ማትንተን እታ ኤስትቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","ዋልቃ ዋልቃ ሪይንከስም ገቀርስካንታ እታ ዝግስቶ ኮም ክተንም ሳብ እካንታ እምሳን ዉቺ እምንተን ግንዳ ሙቅምካ የካንታ ጻፍሳቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","ኮነረ ዉች እምንተና እካንታ እምምሳንዳ ሳብታ ክላ ኬዘታ ቃለንም አይሁድ ማታክባብከስካንታ ኬዝካ ቄሳ ግንዳ ማትስቶ የሱስ ክርስቶሰታ ፍክስካንቴ፥ ኮካንታ አይሁድ ማታክባብከስም አያን ጭልንካ ሳብካንታ ፋስምስባብኬ ሳብመረ ጉርምዝድን ካሲ ማትሰኮ ከት Ꮊፈርድን ግንዳ እታ ሳብካንታ ፍግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","ኮትኮጎካ የሱስ ክርስቶስካ ሳብካንታ ፍክስባብ እስታ ማትንተንካ ጋይርድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","አይሁድ ማታክባብከስ ክትምድባብ ኬት ማድንግንዳ ይይካንታ ክርስቶስ እስታ ኬዘንኬ ፍክስንጎካ ክት ፍክሳን ርና ማታክንዳ ማቼ Ꮊረነረ ሙቅምካ ኬዛይቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","ኮትኮግንደረ አንድር አተንከስኬ በርእዝድን ፍክስንከስካ አያን ጭልንተረ ዎልቀካ የሩሳሌማርኬ ሞረንከሳርንካ የድሶ እልዋርቆን ፍጫ የለልታ ክርስቶስታ ክላ ኬዘን ኤስስትቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","ሙዳᎺይካ እስታ አንግርነረ አብ ኤድ የጃን የድንዘን የድይ ማታክናና ክርስቶሰታ ላም ኤስማክን ካሪ ሙደናር ክላ ኬዘን ኤስምስዬ። ");
INSERT INTO gyl_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","ኮነረ፥ “ኮታ እሪ ክትጎካ Ꮊረሰነረ ከትካንታ ከዝማክባብ ኤድንከስ ክትም ሰደኬ፥ ክትጎካ ኤሰራክባብከሰረ ገቀርት ተይደኬ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","ታካ የለልታ የንደር Ꮊድካንታ እ ማታክንደና እርምሶ እ ከዛንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","ታ ማቼ ኮ ሞረናር ዶቅድን ፍጨንከሳር እ ፍግዝድንደታ ካሪ ካየንካንታ፥ ኮት ኮግንደረ በድ ስለንከሳርንካ የድስቶ የም ሰድንካንታ አንድር እስታ አንግር ዶቅድንካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","እስፔን ፍጨናር እ አይድንደትᎺይካ ጎግንኮትካ የም ሰድንካንታ ገቀርትቴ። መራ ሰጫካንታ የንካ ክክን እም ጉርምስንካ እ ዶቅሳንደታ ቡር ጎግን እ አይድንግንዳ ይድን አሌንም እካንታ የ ይድንደትም ጉርም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","ታ ማቼ አሜንድባብ ከስካንታ እምምድን ብረታ አሌን የድስቶ የሩሳሌማር አይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","ኮነረ መቅዶንያ ፍጨናርኬ አካያ ፍጨናር ዶቅድባብ አሜንድባብከስ የሩሳሌማር ዶቅድን ር ካያባብከስካንታ ብረታ አሌን ኦይትካንታ ቡዳርንካ ገቀርሰኮ ከት ኤእሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","ኮመረ አሌን ይንታ ጋይተካ እምስባብከስ ከታዘንካ ነጋይንዳ ማቻንካንቴ፥ አይሁድ ማታክባብከስ አይሁድንካ ክክን አያንንታ አንጀንም ካስምድባብከስ ኬት ማቼ ከተረ ፍጨዘን ዶቅድን አንጀንካ አይሁድንከስም አሌና ከታዘንካ ነጋይንዴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","ኮካንታ ኮም ሳንስምሳንደትም ብረን አሌን የሩሳሌማር ተይ አይስቶ እ እምሳንደታ ቡር የንደርጎካ እፔፈን ፍጨናር አይድቶ የመረ ሰድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","የንደር እ ᎺዳንደትᎺይከረ ክርስቶሰታ አንጀን ጮጭካ የካንታ ተይ እ Ꮊድንደትም ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","እስታ እስመንከስኬ ምችነንከሶ! እጎካ ሳብደር ምክስካ እስታ ፍክስንታ ጉርንካ እም የ አልድንግንዳ ዎንታ ጮይስን የሱስ ክርስቶሳርኬ አያንጭልንታ ሶልመንካ የም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","እካንታ የ ምግዝድንደረ ይሁዳ ፍጨናር ዶቅድን አሜንዳክን ኤድንከስታ አንያርንካ እ አቅድንግንደኬ የሩሳሌማር እስታ ዶቅድን ፍክስነረ አሜንድባብ ከዝደር ኡርማ ማድንግንዴ ");
INSERT INTO gyl_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","ኮነረ ማቻንደታ ቡር ሳብ ጋይሴ ጉርምካ የንደር Ꮊድስቶ ቶክም ሰጫ ኡክንድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","ሳራትችንታ ጮይስና የሙደንካ ክክን ማታ! አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","ዎንታ ምችነን ፌባ ክንክርያ ካተማ ምክስ ኤሄናር ፍግዝድንዳ አመንምሳንዳ ኮታ ማትንተን የኤዝድንግንዳ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","ና እመንኬ አብንከስመረ በድ ኤድም አሌን አልሳንዳ ኮት ማቻንካንታ አሜንድን ሶችንከስም ሞካ ኬትም ዝግዝድንግንዳ ጮይስታ ላምንካ ኮትም ሞክሰቶ ኮትም ዝግዝድ ር ሙደንካ ኮትም የ አሌን አልድንግንዳ ዋደ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","የሱስ ክርስቶሰታ ፍክስንካ እንካ ዋልቃ ማችባብከስካንታ ምችነን ጵርስቅላካንተኬ ዎንታ እስመን አቅላካንታ እስታ ሳራትቼን የልስከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ከታ እስታ ካርያር ደእካንታ ዎራ ግግምስባብከሰኬ፥ ኮጎካ ሙዳᎺይካ እታ ኬትም ቦንጅድቴ፥ እተረ Ꮊክ ማታክናና አይሁድማታክባብከሳርንካ አሜንስባብከስ፥ Ꮊክ Ꮊክ ምክስ ኤሄንከሰረ ጉጅሶ ኬትም ቦንጅዴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","ከታ ኤር ምክስካንታ ሳንምድባብ አሜንድባብ ከስካንታ እስታ ሳራትችን የልስከቴ። እስያ ፍጨናር እርምሶ ክርስቶሰካ አመንስባብካንተኬ እ ሶልምድባብ ኤጰነጦሳ ካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","የካንታ በድካ ጋፍሳን ማራማ ካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","እንካ ክክን ዞከርሶ Ꮊቅባብከስካንተኬ ኦይትምስባብከስታ ዎክያር ኤስምድᎺቅባብ አይሁድ ማችባብ እስታ ሱሰንከስ፥ ዎንታ እስመን አንድሮቆሳካንተኬ ዎንታ ምችነን ዩንያስካንታ እስታ ሳራትችን የልስከቴ፥ ከታ ክርስቶሰካ አሜንካ እዘንካ እርምደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","ጮይስታ ላምካ እ ሶልምድባብ አምጵልያቶስካንታ እስታ ሳራትችን የልስከቴ ");
INSERT INTO gyl_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ክርስቶሰታ ፍክስንካ ዋልቃ ማችባብ ኡርባኖስካንተኬ እ ሶልምድባብ እስጣኩስ ካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","ክርስቶሳር ክታ ማትንተን ጰጭምሶ ክትካንታ ማርከርምስባብ አጰልስካንታ፥ አርስጦቡሎስታ ኤር ኤድ ማችባብከስካንተረ እስታ ሳራትችን የልስከቴ ");
INSERT INTO gyl_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","አይሁድ ማችባብ እስታ ሱሳ ሄሮድዮንካንታ፥ ናርስሰታ ኤር ኤድን ጮይስታ ላምንካ አሜንስባብከስካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","ጮይስታ ፍክስካ ጋብድባብከስካንታ ዎንታ ምችነን ቱርፍያ ካንተኬ ዎንታ ምችነን ቱሩፎሳ ካንታ፥ ጮይስታ ፍክስካ አንድር ኮት ጋፍሳን ክርስቶሰታ ላምካ ኮትም እ ሶልምድን ፈርስሳ ካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","ጮይስካንታ ፍክስካ አንድር ኤስምስባብ ዎንታ እስመን ሩፎስ ካንተኬ፥ እመረ ይንታ ይንችግንዳ እም ሶልምድ Ꮊቃን እንደንካንተረ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","አስንክርቶእስ ካንተኬ ፍልጎንካንታ ሄርመስ ካንታ፥ ፋትሮባስ ካንታ፥ ሄርማስ ካንተኬ ከትካ ክክን ዶቅድን እስመንከስካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","ዎንታ እስመን ፍሎሎጎስ ካንታ ዎንታ ምችነን ዩልያ ካንታ ምችነን ነርያ ካንተኬ ኮታ ምችነን ካንታ፥ ኮትኮግንደረ ኦሉምፋሳ ካንተኬ ከትካ ክክን ዶቅድባብ አሜንድባብ ሙደንካንታ እስታ ሳራትችን የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","ኡርማ ቡዳርንካ ማቻን ሳራትችንካ ክክ ክክ ሶንቅምከቴ። ክርስቶስካ አሜንስባብ ᎺክᎺክ ምክስ ኤሄናርንባብከስ ሙደና ኡርመቶ የም ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","እስታ እስመንከስኬ ምችነንከሶ! የተያን ኤስስን ግርድባብከስ ማትንተካ የንታ ዎክያር ፋስምኬ ማጠም ተይᎺድን ኤድንከዘንካ ካርስምከቴ፥ ከታዘንከረ ጎተርከቴ! ");
INSERT INTO gyl_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","ከትኬናከስግንዳ ኤድና ይንታ ማታ ካንታ ዳት ዎንታ ጮይስ ክርስቶስካንታ ፍክሳየኬ። ኡርማ ካምድን ሳርስ ኬዝካ ጩባ ካየን ኤድንከስታ ቡደን ገስዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","ክላ ኬዘንታ ቃለንካ ክትምድባብ የንታ ማትንተንካ ኤድ ሙደንደር ኤስምሳንካንታ ዎም ጉርምሳንዳ ማችንከረ፥ ኬዛር ማቼ ኡርማ ርካንታ ኤጨንክንባብከስ ዳቅልር ካንታ ማቼ ቡዳርንካ አተርድባብከስ የ ማተርንግንዳ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","ኮም የ ይይሴ ሳራትችንታ ጮይስና ሳነካ ሰጣንም የንታ ዱትንታ ጎያር ኖ ሙክተሬ። ዎንታ ጮይስ የሱስ ክርስቶሰታ ዉች እምንተና የንካ ክክን ማታ። ");
INSERT INTO gyl_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","እንካ የካ ፍግዝድባብ ጢማቶስ፥ ኮት ኮግንደረ አይሁድ እስታ ሱሰንከስ ማችባብ ሉቅዮስኬ እያሶን፥ ሶስጴጥሮሰረ አቦ የም ጋይደኬ። ");
INSERT INTO gyl_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","ኮም ክተን ጻፍስባብ እተረ ጠርጥዮስ ጮይስታ ላምንካ አቦ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","እምንኬ ሙዳ ምክስ ኤሄናር ዶቅድባብከስም ሞግድባብ ጋይዮስ፥ ካተመን ገችዝድባብከሳርንካ ዋልቀና፥ ኤራስጦስ፥ ዎንታ እስመን ቀዋርጦስ አቦ የም ጋይተኬ።  ");
INSERT INTO gyl_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","ዎንታ ጮይስን የሱስ ክርስቶሰታ ዉች እምንተና ዎ ሙደንካ ክክን ማታ! አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","እከዝድን ክላ ኬዘንታ ቃለና የሱስ ክርስቶስጎካ ኬዝምድን ክተንኬ ኤና እሪ ስለንዘንካ የድሶ አችምሶ Ꮊቃንዳ፥ ታ ማቼ መይምሳን ዶፈንንታ አችምሳን ኬዘንጎካ ሳብ የንታ አሜንካ የ ዎእድንግንዳ ይይካንታ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","ታ ማቼ ኮና ዶፈንና መያ ማቴ፥ ስለንክንባብ ጮይስንታ ክተንካ ሙደነረ አሜንሶ ኬት ክትምድንግንዳ ሳብዘንካ ኤሰርሶ ኬዝድባብከስታ ማጻፍንጎካ ዎርሳ ሙደና ኬት ኤዝድንግንዳ ይይምቴ። ");
INSERT INTO gyl_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","ኖ Ꮊክ ኤጫ ዶቅድባብ ዋልቃ ሳብንካንታ የሱስ ክርስቶስጎካ ስለንክንደት የለልታ ቦንቻ ክትካንታ ማታ! አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","ሳብታ ጋይተካ የሱስ ክርስቶስታ ኦይትምስባብ ማትካንታ ኤልምስባብ ጳውሎስዘንኬ ዎንታ እስመን ሶስተንዘንካ፤ ");
INSERT INTO gyl_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","ቆሮንቶስ ካተማር Ꮊፈርድን ሳብታ ምክስ ኤሄን ኮታ ዋረረ ክርስቶስ የሱሰካ ጭልምስ ባብከስካንተኬ ሳብካንታ ፋስምስባብ ኬት ማተርንግንዳ ኤልምስባብከስካንታ፥ ኮግንደረ ካሪ ሙደናር ከትካንተኬ ዎካንታ ጮይስ ማችባብ ዎንታ ጮይስን የሱስ ክርስቶስታ ላምን ኤልድባብከስካንታ ሙዳ፥ ");
INSERT INTO gyl_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","ዎንታ ባቤን ሳብዘንከ ጮይስ የሱስ ክርስቶስዘንካ ዉች እምንተኬ ሳራትቼንካ የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","የሱስ ክርስቶስካ ይንታ ዉች እምንተን የካንታ እምሳንካንታ የጎካ ሙዳᎺይካ እስታ ሳብንም ጋለድቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","ሙዳ ርይካ ኬዘከረ ማታ ኤሰከረ ክርስቶሳር ቆልተቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","ኮነረ ማቻንዳ ክርስቶስጎካ ዎ የካንታ ኬዛንዳ ማርካትቼና የንደር ዳቅቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ኮካንታ ዎንታ ጮይስን የሱስ ክርስቶስታ መያ ማትንተን ሱነካ ካርሰረቶ የ ዶቅድንካ Ꮊረሰነረ አያንታ እምንተና የንዘንካ ዞገራዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","ዎንታ ጮይስን የሱስ ክርስቶስታ ቃስትምስ Ꮊድንተካ ይንኤርም ካይሳ ማትሰቶ የ Ꮊፈርተርን ግንዳ ኖ በእንታ የለልታ ዳቅሶ የ ዶቅተርንግንዳ ይይተሬ። ");
INSERT INTO gyl_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","ክታ ይንችን ዎንታ ጮይስን የሱስ ክርስቶስካ ክክን ዋልቃትች የንታ ዶቅተርንግንዳ የም ኤልስባብ ሳብና አሜንምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","እስታ እስመንከስኬ ምችነንከሶ! “ፋስም የንታ ዎክያር Ꮊይ ዶቃ፥ የታ ሙደነረ ክክ ኤእሰቶ ዋልቃ ኬዘኬ ዋልቃ ገቅርካ ዳቅሶ ዶእከቴ” ጋይስቶ ዎንታ ጮይስን የሱስ ክርስቶስታ ላምካ የም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","እስታ እስመንከስኬ ምችነንከሶ! የንታ ዎክያር ዋጭማ ዶቅድንደትም ቀሎኤታ ኤር ኤድን ኬዘንካ እታ ኤሰርትቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","ኮነረ የታ ዋልቃ ዋልቀንከስ “እታ ጳውሎስትተ፥ እታ አጵሎሰትቴ፥ እታ ጴጥሮስትቴ፥ እታ ክርስቶሰትቴ” የታ ጋይደቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","ይና ክርስቶስ ፋስምቶ? ጳውሎስ የካንታ ሮክርምቶ? አና የ ስኤርሳንዳ ጳውሎስታ ላምኮ? ");
INSERT INTO gyl_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","እታ ቃርስጶሰምኬ ጋዮሰዘንካ አብ Ꮊይመሰነረ እ ስእሳክንጎካ ሳብም ጋለድቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","ኮካንታ “እ ጳውሎስታ ላምካ ስኤርትቴ” ጋይሶ ኬዝድባብ Ꮊየሰነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","(ገታ ማቼ፥ እስጥፋኖሰታ ኤር ኤድንም ስእስትቴ፥ ኬት ከነዘንካ አብ እ ስእስባብ ኤድ ዶቅዴ ጋይስቶ ገቀራይቴ፥) ");
INSERT INTO gyl_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","ክርስቶስ እም ኦይቻንዳ ክላ ኬዘንም ኤስዝድንግንዳ ዳት እ ስእዝድንግንዳ ካዬ፥ ክርስቶሰታ ማዝቀልና ዉች ማትሶ ነግዳክንግንዳ ክላ ኬዘንም እ ኤስዝድንዳ ኤታ ኤረዘንካ Ꮊፈርሳን ኬዝካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","ማዝቀልንታ ቃለና ካይድን ኤድንከስካንታ ዳችርምግንዳ ፋይድምዴ፥ ዎ አቅድባብከስካንታ ማቼ ሳብታ ዎልቄ። ");
INSERT INTO gyl_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","“ኤረንባብከስታ ኤረንም እታ ካይዝድቴ፥ በድ ኤዝድባብከስታ ኤሰንም ቦዝድቴ” ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","ይና ኤረንባብ Ꮊብረረ? በድ ኤዝድባበረ Ꮊብረረ? ኮ ፍጫሙደንታ ፍዘንም ሙዳ ኤስካንታ ዝግድባብከስ Ꮊብረረ? ሳብ ኮ ፍጫሙደንዘን ኤጨንም ዳቻ ማሳክዮ? ");
INSERT INTO gyl_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","ኮ ፍጫሙደንታ ኤድንከስ ይንታ ገታ ኤጨንካ ሳብም ኤስካንታ ከት ማዳክንግንዳ ሳብ ይንታ ኤጨንካ ከታዘን ዝጬ፥ ኬዛር ማቼ ዳችርምግንዳ ፋይድምድንዳ ዎ ኤስዝድን ክላ ኬዘንካ አሜንድባብከስም አቅስካንታ ሳብታ ጋይተና ማቴ። ");
INSERT INTO gyl_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","አይሁድንከስ አተንም ሰድካንታ ዝግደኬ፥ ግርክ ኤድንከስ አና ኤጨንም ዝግደኬ። ");
INSERT INTO gyl_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","ዎታ ማቼ ክርስቶስ ዎካንታ ሮከርምሳንደትም ኤስዝዶቴ፥ ኮነረ አይሁድንከስካንታ ጎሄ፥ ግርክ ኤድንከስካንታ ዳችርዬ። ");
INSERT INTO gyl_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","ኤልምስባብከስካንታ ማቼ አይሁድን ከስካንተረ ማታ ግርክ ኤድንከስካንታ፥ ክርስቶስ ሳብታ ዎልቀኬ ሳብታ ኤጬ። ");
INSERT INTO gyl_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","ሳብታ ዳችርዬ ጋይምሶ ገቅርምድንዳ ኤታ ኤጨንዘንካ ስገዴ፥ ሳብታ ጋፍርዬ ጋይምሶ ገቅርምድንዳ ኤታ ዎልቀዘንከረ ስገዴ። ");
INSERT INTO gyl_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","እስታ እስመንከስኬ ምችነንከሶ! ሳብ የም ኤና ኤልድናይካ Ꮊራ ግንዳ ኤድ የ Ꮊቃናንከረ ገቀርከቴ፥ ኤታ ገቅርግንዳ የንታ ዎክያርንካ በድንከስ ኤጨንከስ ናንከረ ዳቅመንከስ አነረ አንድር ኤድንከስ ካያ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","ኬዛር ማቼ ሳብ ኤጨን ባብከስም ኦስንስካንታ ፍጫሙደንዘን ዳቻግንዳ ፋይድምድባብ ኤድንከስም እጄ፥ ዳቅመን ከስመረ ኦስንስካንታ ፍጫሙደንዘን ጋፍስ ባብከስግንዳ ፋይድምድባብከስም እጄ። ");
INSERT INTO gyl_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","ሳብ ፍጫ ሙደን ኤድንከዝደር ዶቅዴ ጋይምሶ Ꮊፈርድን ሪንከስ ኬትም ካያ ግንዳ ማስካንታ ፍጫሙደንዘን ኦስንሳንደትምኬ ቶችምሳንደትም ሪይካንታ ካምሶ Ꮊፈርዳክን ሪም እጄ። ");
INSERT INTO gyl_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ኮመረ ክት ይሳንዳ Ꮊየሰነረ ኤድ ሳብታ እሪ ጬቅዳክን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","የም ማቼ ሳብ የሱስ ክርስቶስካ ክክን ዋልቃትች የካንታ ዶቅተርንግንዳ ይሴ፥ ኮካንታ ሳብ የሱስ ክርስቶሰም ዎንታ ኤጫ፥ ዎንታ ጭልም፥ ዎንታ ሳብካንታ ፋስምንኬ ዎንታ ቆትማ ክት ማድን ግንዴ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","ኮነረ “ጬቅድባብ ጮይስካ ጬቃ” ጋይምሶ ማጻፍናር ጻፍምሳንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","እስታ እስመንከስኬ ምችነንከሶ! እታ የንደር እ Ꮊዳንደትካ ሳብታ አችምሳን ዶፈን ማቻን እ ማርከርሳንዳ ኬዘታ ኤስም እዘንካ ዉቸርቶ ኤጨም ሰችካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","የንካ ክክን እ Ꮊቃንደትካ የሱስ ክርስቶስ ማዝቀልዘን ሮከርሶ ክታ ደእንዘንካ አብ Ꮊረሰነረ ር ኤሳይቴ ጋይትት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","ኮካንታ የንካ ክክን እ Ꮊቃንደትካ ጋፍካ ጳስኬ በድ ጭጭካ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","እስታ ኬዘንኬ ሳባክንካ ኤድካንታ እምምሳን ኤጨኬ ኬዘም ኡርስካ ማታክዶቆ ሳብታ አያንካ ዎልቀንም መያ ማስካ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","ኮመረ እ ይሳንዳ የንታ አሜንና ኤታ ኤጨታዘን የድምሳንዳ ማታክናና ሳብታ ዎልቀካ ገክንምሳንዳ ማድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","ኬዛር ማቼ አያናር ዶቅንትካ ኡስባብከስካንታ ኤጫ ኬዘንም ኬዝዶቴ፥ ማታጋካ ዳት ዎከዝድንዳ ኮ ፍጫሙደንታ ኤጨንናንከረ ኬታ በእንተና ካይንታ ማድንደትም ኮ ፍጫሙደንዘን ቆልድባብከስታ ኤጨንም ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","ዎ ኬዝድንዳ ማቼ ሳብ እሪምሶ ኤና ስለንከስታ እሪ ዎንታ ቦንቼንካንታ ግግሳንደትምኬ አችምሶ Ꮊቃንደትም ሳብታ አችምሳን ኤጨንሜ። ");
INSERT INTO gyl_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","ኮፍጫ ሙደን ቆልድባብከስታ ዎክያርንካ ኮ ኤጨን ኤስባብ Ꮊየነረ ካዬ፥ ክትም ከታ ይ ኤስተስናንካ ቦንቻ ጮይስንም ሮክተራከክ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","ማታጋካ ዳት ማጻፍና፥ “ኤታ አፍይ ሰዳክንደትም፤ ኤታ ቃምይ ኤሰራክንደትም፤ ኤታ ቡዳ ገቀራክን፤ ሳብ ይ ሶልምድባብከስካንታ ግግስቴ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","ዎካንታ ማቼ ሳብ ይንታ አያንንጎካ ይንታ አችምሳንደትም ዎካንታ መያ ማስቴ፥ ሳብታ አያንና መያ ማዳክንደትም ሳብታ አችምሳንደትም ዎራ ነጋክናና ሙዳ ርም ፋስት ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","ኤድጎካ ማቻንዳ ማቼ ክታ ዶቅድን አያንንዘንካ አብ ክታር ዶቅድን ገቅርን ኤዝድባብ Ꮊይራ? ኮትኮግንደረ ሳብታ አያንዘንካ አብ ሳብታ ገቅርን ኤዝድባብ Ꮊየነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","ሳብዘንካ ዉችኩን ዎካንታ እምምሳንደት ርም ዎ ኤዝድንግንዳ ሳብታ አያንን ዳት ኮ ፍጫሙደንታ አያንን ተያኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","ኮካንታ ዎታ አያንንታ ሪን አያንክንባብ ኤድንከስካንታ ዎ ኤስዝድንዳ ኤድዘንካ Ꮊፈርድን ኤጨካ ማታክናና ሳብታ አያንዘንካ Ꮊፈርድን ኤጨኬ። ");
INSERT INTO gyl_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","ሳብታ አያንይ ካየንባብ ዋሄክንባብ ኤድ ማቼ ሳብታ አያንዘንካ እምምድን እምንተንከስም ተይ ካንታ ማታዬ። እምንተንታ አንድርትችና ሰድምድንደና አያናር ማቻን ጎግካ ገቀርት ተይካንታ ኖ ማታዬ፥ ኮትኮግንደረ ኮና ክትካንታ ዳችርም ካምሶ Ꮊፈርዴ። ");
INSERT INTO gyl_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","ሳብታ አያን ዶቅድባብ ማቼ ሙዳ ርም ሰድካንታ ማዴ፥ ኖይንታ ማታርንካ ማቼ Ꮊየንከረ ሰድምዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","ኮነረ፦ “ጮይስታ ገቅርን Ꮊይ ኤስካንታ ማዳ? ክትም ዞራካንታ ማድባብ Ꮊይራ?” ጋይምሶ ጻፍምሳን ግንዴ። ዎካንታ ማቼ ክርስቶሰታ ቡዳ ዎንታ ዋር ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","እስታ እስመንከስኬ ምችነንከሶ! እ የም ኤስዝድንካ ዋሄክንባብኬ ክርስቶሳር አክ የታ ዳቃክባብ ኡላ የ ማቻንግንዳ ዳት አያንክንባብ የ ማቻንግንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","ዛብና እችምን እጅዳክን ኡለንከስግንዳ የ ማቻንካንታ እ የም እችሳንዳ ራጭ ዳት ዛብና እችም ካዬ፥ ታ ማቼረ ዛብና እችም እችካንታ ማዳክባበቴ። ");
INSERT INTO gyl_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","የታ ታየረ አክ ዋሄክንባበቴ፥ ክክ ክክ የ ቀምስምድን ኦላርኬ የ በርምድንጎካ ዋሄክንባብ የንታ ማትንታ ካዮ? የ ፍግዝድንደረ ኤታ መጣ ግንዳ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","ዋልቃባብ “እታ ጳውሎሰትቴ” አብነረ አና “እታ አጵሎሰትቴ” ጋይድንካ ኮ ፍጫሙደንዘን ኤታ መጠንግንዳ የንታ ማትንተና ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","ይና አጵሎስ Ꮊራ? ጳውሎሰረ Ꮊራ? ከታ የ አሜንድንግንዳ ይስባብ ፍክስንባብከሰኬ፥ ከታ ዋልቃ ዋልቀና ከት ፍግዝድንደረ ጮይስ ዋልቃ ዋልቀን ከስካንታ የችሳን ፍክስንመ፥ ");
INSERT INTO gyl_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","እታ ኮርሳቴ፥ አጵሎስ ሎቃ ዎእሴ፥ ጋጵስባብ ማቼ ሳብዬ። ");
INSERT INTO gyl_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","ኮካንታ ፍክስንታ ባቤና ማችባብ ኮረንም ጋጵስባብ ሳብ ዳት ኮርስባበረ ማታ ሎቀን ዎእስባብ Ꮊረሰነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","ኮርስባበረ ማታ ሎቃ ዎእስባብ ኬታ የከኬ፥ ዋልቃ ዋልቀንከሰረ ይንታ ፍክስንከካ ናክንም ተይተሬ። ");
INSERT INTO gyl_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","ዎታ ሳብካንታ የካ ፍግዝድባብ ፍክስንባቦቴ፥ የተረ ሳብታ ዎን Ꮊምኬ ሳብታ ሰይን ኤሄቴ። ");
INSERT INTO gyl_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","ሳብ እካንታ እምሳን እምንተንከካ ሰይን ኤሄንም ዎድባብ ሩርምባብ ግንዳ የድንም የጅቴ፥ አብነረ እ የጃን የድንታ ዘን ኤሄንም ዎዴ፥ ኬዛር ማቼ ዋልቃ ዋልቀና ኮታዘን Ꮊስግንዳ ይ ዎዳናንከረ ካርስም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","ዋልቃዱት የድምሳን የድንዘንካ አብ Ꮊየነረ አብ የድይ የድካንታ ማታዬ፤ ኮነረ የድና የሱስ ክርስቶስዬ። ");
INSERT INTO gyl_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","ኮ የድንዘን ዎርቀካ፥ አነረ ጋይካ ቦንችምሳን ሰይንካ፥ አነረ Ꮊቀካ፥ ድረከረ ማታ ምሴካ ዎድባብ ዶቅሴ ");
INSERT INTO gyl_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ከትኬና ዋልቃ ዋልቃ ኤታ ፍክስና መያ ማድንዳ ፍርደታ ሰጫ Ꮊዴ፥ ኮት ሰጨንካ ዋልቃ ዋልቃ ኤታ ፍክስና Ꮊራ ግንዳ ናንከረ ኖሄካ ጰጭምሶ መያ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","ዋልቃ ሰይን ኤሄንም ዎድባብ የድን ዘን ክት ፍክሳን ፍክስና ኖሄካ ጰጭምሶ አትክሳ ዛብሶ ዎእሴ ኤሄንም ዎጅባብ ናክንም ይንታ Ꮊፍተሬ። ");
INSERT INTO gyl_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","ክታ ፍክስና ኖሄካ አትሶ ካይድባብ ሰይን ኤሄን ዎድንባብታ ናክና ክታዘንካ ነገዴ፥ ማታጋካ ዳት ኖይንታ ማታርንካ ኖሄታ ዋር ስግሶ አታክ ዶቆ ነገድን ኤድግንዳ አቅድባብ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","ሳብታ ጭል ኤሀ የ ማቻንደትምኬ ሳብታ አያንና የንታዋር ዶቅድንደትም የታ ኤዝዳከቴ? ");
INSERT INTO gyl_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","ይና ኤድ ሳብታ ጭል ኤሄን ካይስሴ ሳብ ክትም ካይዝዴ፥ ሳብታ ጭል ኤሄና ጭልዬ፥ ኮነረ ጭል ኤሄና የተቴ። ");
INSERT INTO gyl_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Ꮊየነረ ይንታ ማተንም Ꮊይገስሳ፥ ኮ ፍጫሙደንዘን ኤጨንካ ኤጫባብ ካምሶ የንታ ዎክያር Ꮊፈርድባብ ዶቅሴ ኤጨንባብ ማትካንታ ይንታ ማተንም ዳቻግንዳ ክት ፍይዳ። ");
INSERT INTO gyl_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","ኮ ፍጫሙደንታ ኤጨና ሳብታ እሪ ዳችርሜ፥ ኮነረ፥ “ሳብ ኤጨንባብከስም ኬታ ጩበንካ ከትም የዴ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","ኮትኮግንደረ፥ “ጮይስ ኤጨን ባብከስታ ገቅርና ዉችኩን ማትንተን ኤዝዴ” ጋይድንዳ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","ኮካንታ ሙዳ ር የንታ ማቻን ካንታ Ꮊየነረ ኤድካ Ꮊይ ጬቃ። ");
INSERT INTO gyl_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","ጳውሎሰረ ማታ አጵሎሰረ ማታ፥ ጴጥሮሰረ ማታ፥ ኮፍጫ ሙደነረ ማታ፥ ዶቅንተረ ማታ፥ ደኤረ ማታ፥ ታ ዶቅድንደረ ማታ፥ ቡር Ꮊድንደረ ማታ ሙደነረ የንቴ። ");
INSERT INTO gyl_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","የታ ማቼ ክርስቶሰተቴ፥ ክርስቶሰረ ሳብቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","ይና ኤድ ሙደና ዎም ክርስቶሰታ ፍክስንባብ ዎ ማቻን ግንዳ ሳብታ አችምሳን ኬዘን መያ ማስታ ባላ ዎካንታ እምምስባብ ዋደን ተይባብ ዎ ማቻንግንዳ ማስሶ ኬታ ዎም ፍይዳ። ");
INSERT INTO gyl_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","ኩን ማቼ ዋደን ተይባብከሰረ አመንምስባብከስ ማትሶ Ꮊፍር ከትም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","እጎካ ማቼ የተረ እስታዘን አነረ አብ ኤድ እስታዘን ፋረጄ Ꮊረሰነረ እም ካማዬ፥ ዶፈንካ እታ እስታዘን ዎራ ፋረዳክቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","እ ኤዝድንግንዳ ማቼ እካንታ ኤስምድንዳ ካዬ፥ ኮነረ እ ጭለጭል ማትንተን ሰቻዬ፥ ኬዛር ማቼ እዘን ፋረድባብ ጮይስ Ꮊክዬ። ");
INSERT INTO gyl_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","ኮካንታ ሰጨና የላክናና፤ ጮይስ ፍርዳካንታ Ꮊተርንደታ እሪ Ꮊየንዘነረ Ꮊይ ፋረደቴ፤ ክት Ꮊድን ሰጨናይካ ኡማር አችምሳንደትም አቻ ኬዘን ሳክማር ዉጅዴ፤ ኤድንከስታ ቡዳር አችምሳንደትም ገቅርን መያ ማዝዴ፤ ኮታይካ ዋልቃ ዋልቀና ሳብዘንካ ዝግዝድን ጎፍስ Ꮊፍተሬ። ");
INSERT INTO gyl_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","እስታ እስመንከስኬ ምችነንከሶ! የካንታ ማታባብ ጋይስቶ እንምኬ አጵሎሰምካ ኮጎካ ካምስ ማስስቶ ከዛቴ፤ ኮመረ እ ይሳንዳ “ጻፍምሳንዘንካ Ꮊይ ስጌ” ጋይድን ዞረንታ ቡልን ዎንዘንካ የ ኤስተርን ግንዳ ጋይስቴ፤ ኮካንታ ዋልቃ ኤድካ ጬቀረቶ አብ ኤድንም ቶቻ የም ዝግሳዬ። ");
INSERT INTO gyl_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","የና አብን ኬዘንካ Ꮊረከስ ስግዳ? አብንዘንካ የስ ተያክንዳ Ꮊራ ር ዶቅዳ? ይና ሙዳ ርን የስ ተያንዳ አብንከዘንካ ማቼ ተያክን ኤድግንዳ Ꮊረተስ ጬቅዳ? ");
INSERT INTO gyl_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","ታ ማቼ የም ዝግዝድንደትም ር ሙዳ Ꮊፍተቴ፥ ታ ማቼ ቆልመንባብከስ ማተቴ፥ ዎንዘንከረ ፋስምሰቶ ባንችምተቴ፥ ገታ የ ባንችምተስናና፥ ዎተረ የንካ ክክን የካ ዎ ባንችምደስናና ኡርማ ማተርዶቆ። ");
INSERT INTO gyl_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","ሳብ ዎ ኦይትምስባብም ደእ ከታዘን ፋረድምስንካ ኬት ደይሰርድን ካርዘን ተይአይምድባብ ኤድንከስታ ዎክያርንካ በእንተዘን ዎም ይሳን እም ካምዴ፥ ኮዘንከረ አምሳንዳ ፍጫሙደንዘን ክታይንችከረ ማታ ኤድንከስታ እሪ ለቀንደት ማትሶቶ ሰድምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","ዎታ ክርስቶስካንታ ጋይሶቶ ዳቸንከስ ማቶቴ፥ የታ ማቼ ክርስቶስካ ኤጫባብ ማተቴ፥ ኮግንደረ ዎታ ጋፍባብ ማቶቴ የታ ማቼ ዛብዝባብከስ ማተቴ፥ የታ ቦንችምስባብ ማተቴ፥ ዎታ ማቼ ቶችምስባብ ማቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","ታ ማቼረ ኮ ሳዓት የለልታ ዳቀርዶቴ፥ ዎቸርዶቴ፥ ዘና ጫለንከረ ማዶቴ፥ ጉጰርዶቴ፥ ኤሄታ ካይንተካ ኦስ ፈንክ ላንቃኦግዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","ዎንታ ገታ አንካ ፍክሰሮ ጋብዶቴ፥ ኬት ዎም ባድንካ ዎታ ከትም አንጅዶቴ፥ ኬት ዎም ዳይድንካ ዳንዳእዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","ኬት ዎም የግድንከኬ ዎንታ ላምንመረ ከት ካይዝድንካ ዎንታ ማተን ይርክሳ ይንተካ ከትካንታ ማዝዶቴ፥ ታ የለልታ ኮ ፍጫሙደንዘን ዋችባብኬ ዳቅል Ꮊጭመረ ማቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","እታ ኮም የካንታ ጻብድንዳ ሶልምምስባብ እስታ ይንችግንዳ ማስስቶ የም ዞራካንታ ገቅርስቶ ዳት የም ኦስንስካንታ ጋይስቶ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Ꮊረነረ ዎራ ክርስቶሳር በድ ጎርዝድባብ የካንታ ዶቅሴ በድ ባበንከስ የንታ ካዬ፤ እታ ማቼ ክርስቶስ የሱስታ ክላ ኬዘንካ የም አእትቴ ");
INSERT INTO gyl_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","ኮካንታ እስታ ካምስንም የ ጎርስምተርንግንዳ እታ የም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","ኮጎካ ሶልምምስባብከ አመንምስ ባብ ጮይስካ እስታ ይንች ማችባብም ጢማቶስም የካንታ ኦይትቴ፤ ካሪ ሙደናርኬ Ꮊክ Ꮊክ ምክስ ኤሄንከሳር እ ኤስዝድን ግንዳ ኖ እ ክርስቶስካ ዋልቃ ማትስቶ Ꮊፍሳንደትም ክላ ዶቅንትታ ጎግን የም ገቀርስተሬ። ");
INSERT INTO gyl_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","ኬዛር ማቼ የንታ ዋርንካ ዋልቃ ዋልቀንከስ እታ የም ሰድንካንታ እ Ꮊተራክም ኬትም ካምስንካ ኦትረካ ጮጭተኬ። ");
INSERT INTO gyl_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","ማታጋካ ዳት ጮይስታ ጋይታ ማቼ ቅንች ሰጫር የንደር Ꮊድቴ፤ ኮታይካ ኬትኬና ኦትረንባብከስታ ኬዘንም Ꮊክ ማታክናና ከታ ዎልቀንመረ ኤስካንታ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Ꮊረታ ጋይሴ ሳብታ ባንችምና ኬዝካ ማታክናና ሳብታ ዎልቄ። ");
INSERT INTO gyl_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","የ ዝግድንዳ Ꮊራ? ዋጭካንታ ጉፋ የትቶ የንደር እ Ꮊድንግንዳ ዝግደቴ? አና ሶልመከኬ ማተን ይርክሳ ይንተታ አያንካ እ Ꮊድንግንዳ ዝግደቴ? ");
INSERT INTO gyl_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","የንታ ዎክያር ኦስንዝድን በልም ዶቅድንደትም ገታ ኬዝምዴ፥ ኮግንደና በልም አይሁድ ማታክባብከዝደር ዎራ ይምዳክንዴ፥ ና ኮነረ ጋጵሳን እንደንም ይንታ ኬነን ግንዳ ማስሶ ዶቅድባብ ዶቅዴ ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","ይና፤ ኮግንዳ ዶቅድን ኦስንዝድን ር የንታ ዎክያር ዶቅድንካ ኦተርተቴ። ስግስሶ ኮሪንካ ሞርእሰቶ ኮግንዳ ፍክስን ፍክስባብ ኤድን የንታ ዎክያርንካ ዉች ዝክሳዮ? ");
INSERT INTO gyl_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Ꮊረሰረ ዎራ እታ ዋሄካ የንካ የካ እ ማታክናንከረ አያንካ የንካ ክክንቴ፤ ገታ የንካ የካ እ ዶቅድንግንዳ ማትስቶ ኮግንዳ ፍክስን ፍግዝድባብ ኤድንዘን ጮይስ የሱስ ክርስቶስታ ላምንካ ክታዘን ፋረትቴ፤ ");
INSERT INTO gyl_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","የ ሳንምድንደት Ꮊይካ እተረ ዎንታ ጮይስን የሱሰታ ዎልቀካ የንታ ዎክያር አያንካ እ Ꮊፈርድንጎካ፤ ");
INSERT INTO gyl_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","ጎመካ ጮጫን ኮ ኤችንታ ዋሄና ካይድንግንዳ ሰጣንካንታ ስክስተቶ ክትም እም የም ዝግዝዴ። ኮመረ የ ይድንዳ ጮይስ የሱስ ፋረድካንታ Ꮊድን ሰጨንካ ኮ ኤችንታ ሰንፔና አቅድንደትግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","ይና የንታ ጬቅና ኡርማ ካዬ፥ ቶክም እርስና ማጣ ሙደን ኡስዝድንደትም ኤዝደትካዮ? ");
INSERT INTO gyl_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","ታ የ ማቻንደትግንዳ ሙዳ እርሰና ኮታር ካየን አክ ማጤረሳን የ ማተርንግንዳ እር Ꮊቃን እርስንም Ꮊልእስከቴ፤ ዎንታ ፋዝገንታ ቆልይ ማችባብ ክርስቶስ ካሲ ማቴ፤ ");
INSERT INTO gyl_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","ኮካንታ ጩበኬ ዳቀልስ ጮጫንደታር እርንደት እርሰንካ ማታክናና እርሰን ካየንደትካ ሉለተኬ ዶፈንንታ ባይስ ባአልን ዎ ቦንቻ። ");
INSERT INTO gyl_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","ኮታ እሪ የካንታ እ ጻፍሳን ክተንካ ቤልምባብከስካ ክክን Ꮊይዙገረቴ የም ጋይትት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","ኮመረ እ ጋይድንካ ሙዳ ኮ ፍጫሙደንዘን ቤልምንባብከስካ አነረ ሪይታ ጭጭድን ኤድንከዘንካ አነረ ድብንከዘንካ አነረ አብ ርም ጎይናኦንግድባብከስካ ክክን Ꮊይዙገረተ ጋይንት ካዬ፤ ኮግንዳ ማቼ ፍጫሙደንታ ዋርንካ ዉት የም ዝግዝዴ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","እታ ማቼ የካንታ እ ጻፍሳንዳ አሜንድባብከስ ጋይምሰኮ ቤልምድባብከሳርንካ አነረ ሪካንታ ጭጭድባብከዘንካ፥ አነረ አብ ሪም ጎይንድባብከዘንካ አነረ ኤታ ላምም ካይሳኦንግድባብከዘንካ አነረ ጎዝድባከዘንካ፥ አነረ ቡርድባብከስካ ክክን Ꮊይዙገረቴ ጋይስቴ። ኬት ኬናግንዳ ዶቅድን ኤድንከስካ ክክን፥ እችም ከትካ የካ Ꮊይ እቸቴ። ");
INSERT INTO gyl_vpl VALUES ("C15_12","076_5_12","1CO","5","12","12","አሜንድባብከስታ ዋልቃ ትችንዘንካ ማል ዶቅድን ኤድንከዘን ፋረድካንታ እታ Ꮊይራ? አመንድ ባብከስታ ዋልቃትቸንታ ዋር ዶቅድባብ ኤድንከስጎካ የታ ፋረድካንታ ማደት ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C15_13","076_5_13","1CO","5","13","13","ማል ዶቅድን ኤድንከስጎካ ፋረድባብ ሳብዬ፥ ይና ማጻፍና ጋይድንግንዳ “ዳቅል ኤድን የንታ ዎክያርንካ ዉችከቴ”። ");
INSERT INTO gyl_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","የንታ ዋርንካ ዋልቀና አመን ማችባብ ይንታ እስመን አመንድባብካ ክክን ዋጭምሰ ዋጭመንም አሜንድባብከስ ፍርደካ ክትካንታ ሰድንግንዳ ይዘንካ ካሰስካንታ ኦስ አይሁድ ማታክባብ ቡጫ ጋልተንከዝደር Ꮊስግንድክ አይዳ? ");
INSERT INTO gyl_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","ሳብ ኤድንከስ ፍጫሙደንዘን ፋረድንደትም የታ ኤሳየቴ? ይና ፍጫሙደንዘን ፋረድባብ የ ማድንካ ኮ ቶክም ሪንዘን ፋረድ የም ጋምዶ? ");
INSERT INTO gyl_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","ክታይንችንታ ዘን ዎራ ዎ ፋረድንደትም የታ ኤሳየቴ? ይና፤ ኮ ፍጫሙደንታ ገች Ꮊቅንከዘን ስግስሶ ፋረድ Ꮊስግንዳ ዎንደር ማታይንዳ? ");
INSERT INTO gyl_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","ይና ክክ ክክ የ ዋጭምደ አሜንድባብከስታ ዋልቃትችናርንካ ማል ማችባብከስኬ ቶችምስባብ ኤድንከስታ እሪ የንታ ኬዘን Ꮊስግንደንት የልዝዳ? ");
INSERT INTO gyl_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","ኮም እ ጋይድንዳ የ ኦስንድን ግንዳ ጋይስቴ፤ ኤቦ ይና አመንድን እስመንንከስትኬ ምችነንከስታ ዎክያር ኩን ማታ ጋይሶ ኬዛካንታ ማድባብ ገቀርት ተይድባብ ጋልታ Ꮊፈራዮ? ");
INSERT INTO gyl_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","ይና፤ ዋልቃ አሜንድባብ አብ ይንታ እስመን አመንድባብም ካሰስሶ አመንዳክባብከስታ ፍርዳ ኤሄናር ተይ አይክትም ዝግዝዶ? ");
INSERT INTO gyl_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","ኮትኮግንደረ የታ ክክ ክክ ካሰስምሰቶ በርም ይንታ ማታርንካ የካንታ ኦስኔ ስክስሶ የታ የ ኡፈልሰስናና ኡርተራክዮ? ኮትኮግንደረ የታ የ ገስምሰስናና ኡርተራክዮ? ");
INSERT INTO gyl_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","የታ ማቼ የንታ እስመንከስ ማችባብ አሜንድባብከስታዘን ዎራ ኡፈልስኬ ገስንም ቦደቴ። ");
INSERT INTO gyl_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","ዳቀልስንባብከስ ሳብታ ባንችምን ኬት ተይዳክንደትም ኤዝደት ካዮ? ኮ ሪንካ Ꮊይገስመቴ፥ ቤልምድባብከስ፥ አነረ አብ ርን ጎይንድባብከስ፥ አነረ ማነም ኦካኦንግድባብከስ፥ አነረ ማነኬ ማነካ ናንከረ አⷝነኬ አⷝነካ ክክን ቤልምድባብከስ፥ ");
INSERT INTO gyl_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","አነረ ድብድባብከስ፥ አነረ ሪይካንታ ጭጭድባብከስ፥ አነረ ጎዝድባብከስ፥ አነረ ኤታ ላም ካይዝድባከስ፥ አነረ ቡርድባብከስ ሳብታ ባንችምን ተይዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","የንታ ዋርንከረ የታ ዋልቃ ዋልቀንከስ ኮትኮግንዳ Ꮊቀቴ፥ ታ ማቼ ጮይስ የሱስ ክርስቶስታ ላምንኬ ዎንታ ጮይስንታ አያንንካ ጎመዘንካ ስኤርተቴ፥ ሳብካንታ ፋስምስባብ ጭልምሳን ዎርሳ ማተቴ፥ ጭልምተቴ። ");
INSERT INTO gyl_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","“ሙዳ ሪና እካንታ ጋይምቴ” ማቼረ ሙዳ ርና እካንታ መይድንዴ ጋይንት ካዬ፥ ሙዳ ሪና እካንታ ጋይምቴ፥ ማታጋካ ዳት Ꮊምን ሪካንተረ አይላ ማትስቶ ቆልማይቴ። ");
INSERT INTO gyl_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","“እችም ልጳ ካንቴ። ልጴረ እችምካንቴ” ይና ሳብ እችምንመረ፥ ልጴንመረ ኬትም ካይዝዴ፥ ኬዛር ማቼ ዎንታ ኤደትቼና ዎንታ ጮይስ የሱስ ካንቴ፥ ጮይስ የሱሰረ፥ ዎንታ ኤደትቼን ካንታ ማቻን ኦል ዎንታ ኤደትቼንም ቤልምካንታ Ꮊቅስ ዎም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","ሳብ ጮይስ የሱሰም ደእያርንካ አምስስቴ፥ ዎመረ ይንታ ዎልቀንካ ደእያርንካ አምስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","የንታ ኤደትቼና ክርስቶስታ ዘነታ ዋርንካ ዋልቀና ማትንተን ኤዝደት ካዮ? ይና ክርስቶስታ ዘነታ ዋርንካ ዋልቀን ተይስቶ በልም ኤተንታ ዘነታ ዋርንካ ዋልቀና ማድንግንዳ እም ዝግዝዶ? ቦድሶ ዝክሳዬ! ");
INSERT INTO gyl_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","በልም ኤተንካ ክክን የልድን ኤድ ኮትካ ክክን ዋልቃዘና ማትንተን ኤዝደት ካዮ? “ኬታ ቃስተነረ ዋልቃዘና ማደኬ” ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","ጮይስ የሱሰካ ክክን ዋልቃ ማድን ኤድ ማቼ ክትካ ክክን አያንካ ዋልቃ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","ኮ ኦላር ቤልምዘንካ ጎተርከቴ፥ ኤድ ይድንዳ አብ ጎማ ሙደና ክታ ኤደትቸንዘንካ አብ ይይምድንዴ፥ በልም ቤልምድባብ ኤድ ማቼ ይንታዘን ጎማ ፍግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","የንታ ኤደትቼና ሳብዘንካ የ ተያንደትኬ የንታ ዋረረ ዶቅድንዳ አያን ጭልንታ ጭል ኤሀ ማትንተን የታ ኤዝደት ካዮ? ይና የታ ሳብተት ዳት የንታ ማታ ካንታ ካየቴ። ");
INSERT INTO gyl_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","ሳብ የም ይንታ ይንችንታ ማቀስካ ቆቴ። ኮ ኦል የንታ ኤደትቼንካ ሳብም ቦንችከቴ። ");
INSERT INTO gyl_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","የ እካንታ ጻፍሳን ኦይስን ጎካ ኤድ ማነካ ክክን የላከስናና ኡርሜ። ");
INSERT INTO gyl_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","ኬዛር ማቼ ቤልምዘንካ ጎተርካንታ ዋልቃ ዋልቃ አⷝነን ካንታ ክታ ማታ ኬነና ዶቃ፥ ዋልቃ ዋልቃ ማነንተረ ኮታ ማታ ክእስ ዶቃ። ");
INSERT INTO gyl_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","ክእስ ይንታ ከነንካንታ ይ ክትም ዝግዝድንደትም ክት Ꮊይ ማራ፥ ኮትኮግንደረ ኬነና ይንታ ክእስንካንታ ይ ዝግዝድንደትም ኮት Ꮊይማራ። ");
INSERT INTO gyl_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","ኬነና ይንታ ዘነንዘን ኤራ ኮታ ካዬ፥ ኮታ ዘነንዘን ኤራ ዶቅድባብ ክእስኔ። ኮትኮግንደረ ክእስ ይንታ ዘነንዘን ኤራ ክታ ካዬ፥ ክታ ዘነንዘን ኤራ ዶቅድንዳ ኮት ከነንቴ። ");
INSERT INTO gyl_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","ምክስካ ዳቅ ካንታ የታ ቃስተና ኤእሰቶ ቶክም ስጫካንታ ማታክን ማቼ ፋስምካ ዋልቀና አብንታ እንቸንጎካ Ꮊይማራ። ኮጎከረ የንታ ማተን ካርስ የም ጋምስንካ ሰጣን የም ጰጭዳክንግንዳ የካ ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","ኮም ማቼ እ የም ጋይድንዳ ዞራግንዳ ዳት ክታግንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","ኤድ ሙዳ እግንዳ ማና እንቻክሳ ዶቅሳናና ሶልምድት ዶቆ፥ ኬዛር ማቼ ዋልቃ ዋልቀንከስካንታ ሳብ Ꮊክ ማቻን እምንተን ክትካንታ እምቴ፥ ዋልቀንታ ዋልቃ እምንታ፥ አብንካንተረ አብ እምንታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","ይአክባብከስካንተኬ ኮትኮግንደረ ኬታ ክእስን ደእስባብ ማነንከስካንታ እ ጋይድንዳ ኩኔ፥ ይአከክዶቆ እግንዳ ማትሶ ከት ዶቅሳናና ኡርሜ። ");
INSERT INTO gyl_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","ኬዛር ማቼ ዋሄታ አግርካ አትርዘንካ ክክ እንችምና ኡርማ ዶቆ ከታ ይንታ ማተን ካርስም ከትም ጋምሴ እንችማ። ");
INSERT INTO gyl_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","ይእስባብከስካንታ ማቼ እ እምድንዳ ክተና ኮኔ፥ ኮነረ ክተና ጮይስታ ዳት እስታ ካዬ፥ ይእሳን ኤተና ይንታ ክእስንዘንካ Ꮊይ ፋስማ። ");
INSERT INTO gyl_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","ና ይ ፋስምሰረ ይአክዶቆ ይንት ኮት ዶቃ፤ አነረ ይንታ ክእስንካ ክክን ኮት ኤድማ፤ ኮትኮግንደረ ክእስ ይንታ ኬነንም Ꮊይ ቡላ። ");
INSERT INTO gyl_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","አብንከስካንታ ማቼ ጮይስ ማታክናና እታ እስታ ማታርንካ እ ጋይድንዳ ኩኔ፥ ዋልቃ አሜንድባብ ኤችታ አሜንዳክንዳ ኬነና ክታ ዶቅሴ የካ ዶቅካንታ ኮት ዝግዜ ኮትም ክት Ꮊይቡላ። ");
INSERT INTO gyl_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","አሜንድን ኤተንታ አሜንዳክባብ ኮታ ክእስ ዶቅሴ ኮትካ የካ ዶቅካንታ ክት ዝግዜ ኮት ክትም Ꮊይ ቡላ ");
INSERT INTO gyl_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","አመንማታክባብ ክእስና አመንማቻን ኬነንጎካ ሳብታ ኮች ማዴ፥ አሜን ማታክንዳ ኬነነረ አሜን ማችባብ ክእስንጎካ ሳብታ ኮች ና ማዴ፥ ኩን ማታክንዳ ማቼ የንታ ይንችነረ ሳብታ ኤድንከስ ማትካንታ ማታየኬ፥ ኮግንደካ የ ዶቅሳንዳ ማቼ የንታ ይንችና ሳብታ ኤድንከስ ማደኬ ");
INSERT INTO gyl_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","አሜን ማታክባብ ዋልቀና ፋስም ይ ዝግዜ ፋስማ፥ ኮት ሰጨንካ ማቼ አመን ማችባብ ዋልቀና ክእሰረ ማታ ኬነና Ꮊራሪከረ ኦይስማዬ። ሳብ ዎም ክት ኤልሳንዳ ሳራትቼካ ዎ ዶቅድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","የና አሜንድን ኤተኖ፥ አሜን ማታክባብ የስታ ክእስን Ꮊረንግርካ የስ አቅዝዳናንከረ Ꮊረስ ኤዝዳ? የና አሜንድባብ ኤችኖ፥ አሜን ማታክንደትም የስታ ኬነንም Ꮊረንግርካ የስ ኮትም አቅዝዳናንከረ Ꮊረስ ኤዝዳ? ");
INSERT INTO gyl_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","ዋልቃ ዋልቀና ጮይስ ክትካንታ እምሳን እምንተኬ ሳብ ክትም ኤልሳንደትᎺይካ ይ ዶቅድንደትግንዳ ክት ዶቃ፥ Ꮊክ Ꮊክ አመንድባብከስካንታ ሙዳ እ እምሳንዳ ክተና ኮትኮሜ። ");
INSERT INTO gyl_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Ꮊየነረ ኤድ ሶለንም ተቻንደታ ቡር ኤልምስባብ ማቼ ሶለንም ተቼራክባብግንዳ ማትካንታ Ꮊይገቀራ፥ ሶለንም ተቼራክዶቆ ኤልምስባብ ማቼረ ተችርንም ክት Ꮊይዝጋ። ");
INSERT INTO gyl_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","ሶለንም ተችረረ ማታ ተቼርክሳ ነግነረ Ꮊረሰንካንተረ መያዬ። ዶፈን ሪና ሳብታ ክቴንም ቦድንተኔ። ");
INSERT INTO gyl_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","ኮካንታ ዋልቃ ዋልቃ ኤድና ሳብ ክትም ኤልሳንደት Ꮊይካ ይ ዶቅድንደትግንዳ ዶቃ። ");
INSERT INTO gyl_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","ሳብ የስም ኤልድንደትᎺይካ አይለስ Ꮊቆ? ኩን የስ ማቼረ Ꮊረንካዬ፥ Ꮊይማጠሬ፥ ዉች ዉትንተታ ኡዋን የስ Ꮊፍሳንማቼ ኮና ኡዋና የዘንካ Ꮊይነጋ። ");
INSERT INTO gyl_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","አይላ ማትሶ ዶቅድንካ ጮይስካ ኤልምስባብ ኤድ ጮይስያር ዉች ዉትንተን Ꮊፍቴ፥ ኮትኮግንደረ ዉች ማትሶ ክት ዶቅድንካ ኤልምሳን ኤድ ክርስቶሰታ አይሌ። ");
INSERT INTO gyl_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","ሳብ ይንታ ይንችንታ ማቀስንካ የም ሰንሳንጎካ ኤታ አይለንከስ Ꮊይማተቴ። ");
INSERT INTO gyl_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","ኮካንታ እስታ እስመንከስኬ ምችነንከሶ ዋልቃ ዋልቃ ኤድና ይ ኤልምሳንደት Ꮊይካ ይ ዶቅድንደትግንዳ ሳብካ ክክን ኮታር ክት ዶቃ። ");
INSERT INTO gyl_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","ይአክን ኤድንከስጎካ ጮይስዘንካ እ ተያንዳ ክታ ካዬ፥ ኬዛር ማቼ ጮይስታ አጭርንካ አሜንምስባብ እ ማቻንከካ እስታ ገቅርና ኮዘንካ ኦስ ዶቅድንዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","ታ ዎ ዶቅድን ሰጨና ማጣ ሰጭ ማቻን ኦል ይአከክ ዶቆ ይንት ዶቅና ኡርመም እም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","ማቼረ ማና የስ እንችታ ማቼ ቡልካንታ Ꮊይዝጌ፤ ማና የስ እንቻክንዳ ማቼ እንቻካንታ Ꮊይዝጌ። ");
INSERT INTO gyl_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","ኬዛር ማቼ የና ማና የስ እንቼ ጎማ የስካንታ ማዴ ጋይንት ካዬ፥ ኮትኮግንደረ ዋልቃ ይንቼን አንጃ አⷝና ኤር ኮት ይእሴ ጎማ ኮታዘን ማዴ ጋይንት ካዬ፥ ማታጋካ ዳት እንጅድን ኤድንከስ ኮ ፍጫሙደንዘን በድ ዶቅንተታ ማጣ ኬትም የልዴ፥ እስተረ አንግርና ኮ ማጠንዘንካ የ አቅተርን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","እስታ እስመንከስኬ ምችነንከሶ! እ የም ጋይድንዳ ኩኔ፥ በእንታ ሰጨና የልቴ፥ ይና ኮዘንካ ኦስ ማና ክታ ዶቅድንዳ ማና ካየንደት ግንዳ ማትሶ ኬት ዶቃ። ማነን ከስ ኬታ ዶቅድባብ ኬታ ካየንባብከስ ግንዳ ማትሶ ኬት ዶቃ። ");
INSERT INTO gyl_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","ሞርእድባብከሰረ ሞርዳክባብከስግንዳ፥ ጉርምድባብከሰረ ጉርምዳክባከስግንዳ ማትሶ ኬት ዶቃ፥ ር ሰንድባብከስ፥ Ꮊረሰነረ ሪካየንባብከስ ግንዳ ማስሶ ኬት ፍይዳ። ");
INSERT INTO gyl_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","ኮ ፍጫሙደንዘን ቆልመካ ገጅድባብ ሙደና ኮትካ ገጅዳክባብ ግንዳ ማትሶ ከት ዶቃ፥ ታ ኮ ፍጫሙደንታ ይተና ስገድንደ። ");
INSERT INTO gyl_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","ኮካንታ Ꮊረሰን ገቅርካ ማጠራከት ዶቆ የ ዶቅተርንግንዳ እታ ሶልምድቴ፥ ማና እንቻክባብ ኤድ ጮይስ ክታዘን ጉርምድንደት ርም ክት ዝግድን ኦል ክታ ገቅርና፥ ጮይስም ካምድን ፍክስታ ዘኔ። ");
INSERT INTO gyl_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","ማና እንችባብ ኤድ ማቼ ክት ገቀርድንዳ ኮ ፍጫሙደንታ ሪከኬ ይንታ ኬነንመረ ጉርምዝድን ሪዬ። ");
INSERT INTO gyl_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","ኮግንደካ ገቅርና ቃስተን ፋስምቴ ጋይንትዬ። ኮትኮግንደረ አⷝና ኤር ይአክንዳ ማና ናንከረ ይንች አንጃ ይንታ ዋሄንኬ ይንታ አያንካ ጭልምሶ ጮይስታ ማትካንታ ይ ዝግድንካንታ ኮታ ገቅርና ጮይስም ሰችዝድን ፍክስኬ። ይእሳን ማነና ማቼ ይንታ ክእስን ጉርምስካንታ ኮት ዝግድን ኦል ኮት ገቀርድንዳ ፍጫሙደንታ ሪዬ። ");
INSERT INTO gyl_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","እ የም ኮም ጋይድንዳ ጭኬታ ዋር አርድሰቶ የ ማጠርድንግንዳ ጋይስቶ ማታክናና የካንታ መይድንግንዳ ጋይስቴ፥ እስታ አንግርነረ የታ ዝግዝድንደት ግንዳ የ ዶቃባብኬ የንታ ገቅርና ዉች ነጋክናና የንታ ቡዳርንካ ጮይስካንታ የ ፍክስተርን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","ዋልቃ ኤድ ይንታ ሶርምሳንደትም እንችክሳ ነግካንታ ይ ገቀርሳንደታ ቡር ኮም ይተና ይንቼንካንታ ኡርማ ክት ይያክንዳ ማትንተና ክትካንታ ኤስምሴ፥ ኮታዘንከረ አብ ኮትም እንቻካንታ ክታ ዶቅድን ዝግመትና ዳቅማ ማቼከ ኬታ እንችምና ገታ ክትም ካምሴ ይ አንገርሳንግንዳ ኮትም ክት እንቼ ጎማ ክታዘን ማታዬ፥ ኮካንተረ ኬት እንቻ። ");
INSERT INTO gyl_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","ኬዛር ማቼ ዋልቃ ኤድ ይንታ ቡደካ ክት ዳቅሴ ሶልማክናና ኢንጅድንግንዳ ይስዝድንዳ ካየንዳ ማቼ ይንታ አግርንም ነክስካንታ ክት ማቼከ ይ ሶርሳንደትም እንጅዳክተ ጋይሶ ክት ገቀርሴ ኡርማ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","ኮካንታ ማና እንጅድባብ ኡርመንም ይዴ፥ እንጅዳክባብ ማቼረ እንድንካ ኡርሳን ይዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","ኬነና ክእስና ሰንፔካ ዶቅድን የለልታ እንችምንታ ህግንካ ና ዞክምሳንዴ፥ ኮታ ክእስና ደእሳን ማቼ ና ይ ዝግዝባበር ይእ ኮትም መራዬ፥ ማችንከረ ኮት ይእድባብ ኤችነረ አሜንድባብ ማት ክትም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","እስታ ገቅርንካ ማቼ ይአክ ዶቆ ይንት ኮት ማደስናና ስግስሶ ጉርምካ ና ዶቅተረ፥ እተረ ሳብታ አያንና እንካ ዶቅድንደትም ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","ጮይስ ማታክባብከስካንታ ካሰርሳንዳ ዋሀ ኮቲ ማቼ፥ ገቴ “ዎ ሙደንታ ኤስ ዎንታ ዶቅዴ” ማታጋካ ዳት ኤስና ኦተርዝዴ፤ ሶልማ ማቼ ዳቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","“ኤስ እስታ ዶቅዴ” ጋይሶ ገቀርድባብ ኤድ ዶቅሴ ይም ዝግዝድንደትከካ አክ ኤሳክዬ። ");
INSERT INTO gyl_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","ሳብም ሶልምድባብ ማቼ ሳብታ ላማር ኤስምስባብ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","ኮካንታ ጮይስ ማታክባብከስካንታ ካሰርሳን ዋሀ እች ጎካ ማቼ አብ ጮይስ ጋይምድንዳ ሰንፓ ካየንዳ ማቻንደትግንደኬ ዋልቃ ሳብን ዘንካ አብ ጮይስ ካየንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Ꮊረሰን ዎራ ጮይስ ማታከክ ዶቆ ጮይስንከስ ጋይምሶ ኤልምድባብ በድ ጮይስንከስ ጭለዘነረ ማታ ፍጨዘን ዶቅደኬ ጋይምሴ ");
INSERT INTO gyl_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","ዎንታ ጮይስና ማቼ ሙዳ ሪይታ ፍዛባብኬ ዎተረ ክታ ማችባብ ዋልቃ ሳብ ባቤና Ꮊክዬ፥ ኮትኮግንደረ ሙዳ ር ክትካ ፍዝምሳንደትኬ ዎተረ ክትካ ዶቅድባብ ዋልቃ ጮይስ የሱስ ክርስቶስ Ꮊክዬ። ");
INSERT INTO gyl_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","ኬዛር ማቼ ኮም ኤዝድባብከስ፥ ሙደንከሰረ ካየኬ፥ ዋልቃ ዋልቀንከስ ታ የለልታ ጮይስ ማታክባብከስካንታ ጎይንን ኬታ ይንታ መጣ ማስሳን ኦል ዋሄን እጅድባከስ ጮይስ ማታክባብከስካንታ ካሰርሳን ማስሴ። ኮካንታ ከታ ገቅርና ጋፍሳንዳ ማትንተንካ ቱና ማደኬ። ");
INSERT INTO gyl_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","ኬዛር ማቼ ሳብደር ዎም የልዝድንዳ እችም ካዬ፥ ዎ እቻክናነረ ዎም ዞገርድ ሪ ካዬ፥ ዎ እቼረ ዎ ስእዝድ ሪ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","ማታጋካ ዳት ኮና የንታ ዉች ዉትንተና አሜንካ ዳቃክባብ ኤድንከስካንታ ጎሀ የማተራክንግንዳ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","“ኤስ እስታ ዶቅዴ” ጋይሰዮ ጮይስ ማታክባብከስካንታ ካሰርሳን ካሰርድን ኤሄናር የስ እጅድንካ ይንታ አሜንካ ዳቃክባብ ኤድ የስም ሰዴ ኮና የስታ ይተና ኤችን ጮይስ ማታክባብከስካንታ ካሰርሳንደትም ክት እጅድንግንዳ ይዳ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","ኮካንታ የስታ “እታ ኤዝድባብቴ” ጋይንተንካ ክርስቶስ ክትካንታ ደእስባብኬ ይንታ አሜንካ ዳቃክባብ አመንድባብና ካይዴ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","ኮ ይተንካ አሜንድባብ የንታ እስመንከስም ባችኬ ጋፍሳን ከታ ገቅርንካ ጎሄርሰረቶ ክርስቶስዘን ጎማ ፍግዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","ኮካንታ እችም አሜንድን እስታ እስመንም ጎሄርዝድንደና ኮት ማቼ እስታ እስመንም ጎሄርዝዳክቴ ጋይንተካ ቦድሶ ዋሀ እጅዳክቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","እታ ዉች ዶቅካንታ ማድን ኤድ ካይቶ? እታ ኦይትምስባብ ካይቶ? እታ ዎንታ ጮይስን የሱሰም ሰዳክቶ? የተስ ጮይስያር እስታ ፍክስንታ አፍይ ካየቶ? ");
INSERT INTO gyl_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","ጮይስያር እ ኦይትምስባብ ማትንተንታ መይምዝድንዳ ማይተምና የ ማቻንካንታ አብንከስካንታ ዎራ ኦይትምስባብ እ ማታክን ማቼረ የካንታ ገታ ኦይትምስባብቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","“ኦይትምስባብ ማትንተታ ሸንይ የስታ ካዬ” ጋይሰኮ እዘን ኬዝድባብ ዶቅሴ እ እምድን ማስና ኮኔ። ");
INSERT INTO gyl_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","ዎታ እችምንኬ ዎጭምካ Ꮊፍካንታ ሸንይ ዎንታካዮ? ");
INSERT INTO gyl_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","አብ ኦይትምስባብከስግንደኬ ጮይስታ እስመንከስግንዳ አንረ ጴጥሮስ ግንዳ አሜንድን ማነም ጎርስሶቶ ኦንገታ ሸንይ ዎንታ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","አነረ ፍክስካ ጉረሮቶ ዶቅንት ዝግዝድንዳ ባርናባስምንኬ እንካ Ꮊክዮ? ");
INSERT INTO gyl_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","ፍክስታ ናከርድንደት ካይሳ ይንታ ብረንካ ፖልስ ማትሶ ፍግዝድባብ Ꮊይራ? ዎይንንም ኮርስሶ አፍን እጅዳክባብ Ꮊይራ? ይንታ ዉዴን ካርሰሮ ዋክንታ ራጭን ዎጭዳክባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","ኮም እ ኬዝድንዳ ኤታ ገቅርካ Ꮊክዮ? ሙሴታ ህግነረ ኩን ጋይዳካዮ? ");
INSERT INTO gyl_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","“ዎንድን ጌዝምንታ አፈን Ꮊይዞኬ” ጋይምሶ ህግንካ ጻፍምቴ፥ ይና ሳብ ኮም ጋይሳንዳ ገዝምንከስካንታ ገቅርኮ? ");
INSERT INTO gyl_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","ሳብ ኮም ጋይሳንዳ ገታ ዎካንታ ገቅርካ ካዮ? ዎንን ዎንድባብ ጉርምካ ዎንድንግንዳ፥ እስንን ጉጵድባበረ ጉርምካ ጉጵድንግንዳ፥ ኮግንደካ ሙደነረ ይም የልድንደትም Ꮊብድንግንዳ ኮና ጻፍምሳንዳ ገታ ዎካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","ዎታ አያናርንድትም የካንታ ዎ ማሳንዳ ማቼ የንታ ዋሄንታ አንጀን ዎ ስክዴ ና አንድሮ? ");
INSERT INTO gyl_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","አብንከስ ኮም ሪን የንዘንካ ካስምታ ሸን ኬታ ዶቅድንዳ ማቼ ይና፥ ዎንታ ኮዘንካ ስግድንዳ ሸን Ꮊረታ ዶቃዮ? ዎካንታ ማቼ ኮና ሽንና መያክዬ፥ ኮም ዎንታ ይንተነረ ክርስቶሰታ ክላ ኬዘን ሳክስዘንካ ዎ ይሳይን ግንዳ ገቅርካ ሙዳ ርን ዳንዳእሶቶ ማዝዶቴ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","ሳብታ ጭል ኤሄናር ፍግዝድባብከስ ከታ ይንታ እችምን ሳብታ ጭል ኤሄናርንካ ከት Ꮊብድንግንደከ ካስን ካርዘን ካስን እምድባብከስኬ ፍግዝድባብከስ ካስንዘንካ ካስምሰኮ ኬት እጅድንደትም ኤዝደት ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","ኮትኮግንደረ ጉጅሶ ክላ ኬዘን ኤስዝድባብከስ ከታ ይንታ እችምን ኮትኮ ከታ ይንታ ፍክስናርንካ ከት Ꮊብድንግንዳ ጮይስ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","እታ ማቼ ከትኬ ሸንናርንካ ዋልቀነረ እም መይድን ግንዳ ይያክቴ፥ ኮመረ እ ጻፍሳንዳ ኮና እስታ ሸንና ቦንችምክሳ Ꮊረቶክ ነገዳራ? ጋይንተካ ካዬ። ኤድ እስታ ጬቅንም ዉችኩን ማስተርንዘንካ ስግስሶ ደእ እም ኡርዴ። ");
INSERT INTO gyl_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","ክላ ኬዘን ኤስስና እስታ ነግዳክንዳ ማቻንካንታ እ ኮትካ ጋይርድ ር ካዬ፥ ኮትኮግንደረ ክላ ኬዘን ኤስስክሳ እ ነገዴ እም የኤ! ");
INSERT INTO gyl_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","ክላ ኬዘንታ ቃለን Ꮊየነረ ማእሳክናና እስታ ገቅርካ እ ኬዛናና ጋፍንታ ናክ እስታ ዶቅተሬ፥ Ꮊየነረ እም ማእስንካ እ ይዳ ማቼ ዋደካ እካንታ እምምሳንደትም ፍክስን ቦጃትዳት አብ እ ይሳንዳ ሪ ዶቅዴ ጋይንት ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","ይና፥ እስታ ጋፍንታ ናክና Ꮊራ? ይና እስታ ጋፍንታ ናክና ክላ ኬዘን እስታ ኤስስንካ ዶቅድን ሸንና እካንታ መይድንግንዳ ይያክት ዶቆ ክላ ኬዘን ኤስስንታ እስታ ፍክስን ናክካይሳ ዉችኩን ቦዴ። ");
INSERT INTO gyl_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","እታ Ꮊየንተረ አይላ ማታክት ዶቆ ዉች ኤድቴ፥ ማታጋካ ዳት እዝደር ማድን ኬካ በድንከስም አቅስካ መይንታ ካንታ ጋይስቶ ሙደንተረ አይላ ማችቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","አይሁድን ከስካ ክክን ማድቶ አይሁድንከስም አቅስካንታ አይሁድን ከስግንዳ ማቻቴ፥ እታ ህግንታ ታመካ እ ማታክናንከረ ዎራ ህግንታ ታማር ዶቅድባብከስም አቅስካንታ ጋይስቶ ህግንታ ታማር ዶቅድባብ ኤድንከስ ግንዳ ማቻቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","እታ ሳብታ ህግና እካንታ ዶቅድባብኬ ክርስቶሰታ ህግንታ ጎያር እ ማቼረ ዎራ ህግን ካየንባብ አይሁድ ማታክባብከስም አቅስካንታ ጋይስቶ ህግ ካየንባብ ኤድ ማቻቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","አሜንካ ጋፍስባብ ማችባብከስም አቅስካንታ ጋይስቶ ጋፍስባብከስግንዳ ጋፍስባብማቻቴ፥ እዝደር ማድንከካ ቶክምንከስም አቅስካንታ ሙደንካ ክክን ሙዳ ሪካ ማቻቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","ኮም ሙዳ እስታ ይይንተና ክላ ኬዘንታ አንጀንም ካስምካንታ ክላ ኬዘንጎካ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","ዞደካ ጋምካንታ ሙደና ዞድንደትግንደኬ ኬታ ዋርንከረ ዋልቀና Ꮊክ እመርድንደትም ተይድንደትም ኤዝደት ካዮ? ኮካንታ የተረ እመርድንደትም ተይካንታ ዞድከቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","ጋድምካንታ አርድባብ ሙደና ጋብዝድንካ ኤስን ካንታ ይደኬ፥ ከታ ኮን ከት ጋብድንዳ ካይድንደትምኬ ሰጫካንታ ማድንደትም ዛዉደንም Ꮊፍካንቴ፥ ዎታ ማቼ ዎ ጋብድንዳ ካይዳክንደትምከ ስለንክንደታ ማቻን ዛዉደን Ꮊፍካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","እታ ማቼ ቦድንታ ካየን ኤድ ግንዳ ዉችኩን ዞዳይቴ፥ ዞገም ቱንግድባብ ኤድ ግንዳ ዉችኩን አን ቶጵዝድባብ ኤድግንዳ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","ኮካንታ አብንከስም ዞደንደር እ ኤልሳንደታ ቡር እታ እስታ ማታርንካ ዞደናር ካያባብ ማትስቶ እ Ꮊፈርተራክን ግንዳ እስታ ማተን ካርሰርቶ እካንታ ክትምድንግንዳ ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","እስታ እስመንከስኬ ምችነንከሶ! ዎንታ ባበንከስም ኡፓ ከታዘን ስፍስሶ ከትም ጎርሰሮ Ꮊቃንግንደኬ ሙደና ባሀርን ኬት ቃልሳንግንዳ የም ገቀርስካንታ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","ሙሴካ የካ ማትካንተረ ኮትኮ ኡፔናርኬ ኮ ባሀርናር ስኤርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","ሙደነረ ዋልቃ አያንታ እችምን እቼኬ። ");
INSERT INTO gyl_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ሙደነረ ዋልቃ አያንታ ዎጭምን ዎጨኬ፥ ኬት ዎጫንደረ ኬትም ጎርስምድ Ꮊቃን አያንታ ላዝንዘንካ ፉእሳንዳ ቱትዬ፥ ኮነረ ላዝና ይንታ ማታርካ ክርስቶስዬ። ");
INSERT INTO gyl_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","ኮነረ ማችንካ ሳብ ከት በድንከስካ ጉርማክዬ፥ ኮካንታ ከታ ለይስነረ ዴል ቆቸናር ዋችሶ ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","ከታ ዳቅልር ከት አንገርሳንግንዳ ዎተረ ዳቅልር ዎ አንገርዳክን ግንዳ ኮና ሙዳ ዎካንታ ኤግዝምስታ ካምስ ማቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","“ኤድንከስ እችካንተኬ ዎጭካንታ ዶቅሰኬ፥ በድ ይግካንታ አምሰኬ” ጋይምሶ ከትጎካ ጻፍምሳንግንዳ፥ ከተረ ሳብዘንካ አብ ሪም ኬት ጎይንሳንግንዳ የተረ ከትግንዳ ሳብዘንካ አብ ሪም Ꮊይ ጎይነቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","ከታርንካ ዋልቃ ዋልቀንከስ ቤልምሳን ግንዳ ዎ Ꮊይቤልማ፥ ከት ቤልምሳን ካንታ ከታርንካ ቦንደኬ ማከን ሳአ ኤድንከስ ዋልቃ ሰጨካ ደእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","ከታርንከረ ዋልቃ ዋልቀንከስ ጮይስም ጰጫንደትግንደኬ ጉኒካ ጋእርሶ ከት ደእሳን ግንዳ ዎተረ ጮይስም Ꮊይ ዎ ጰጫ። ጮይስ ጋይድንደትም አብ ማጻፍንከስ (ክርስቶስ) ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","ከታርንካ ዋልቃ ዋልቀና ከት ጉንድምሳንግንደኬ ካይዝድን ክታይንችንካ ኬት ካይዳን ግንዳ የተረ Ꮊይ ጉንድመቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","ኮና ሙዳ ርና ከትም የልሳንዳ ዎካንታ ኤግዝምስታ ካምስ ማድንግንዴ፥ ጻፍምሳንደረ ስለንከስታ በእንተንዘን ዎ Ꮊፈርድባብ ካንታ ኤስስ ማድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","ኮካንታ ዎእሳን ካምሶ Ꮊፈርድን ኤድ ይ ዋችተራክንግንዳ ካርስማ። ");
INSERT INTO gyl_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","ኤድዘን የልድን ጰጨዘንካ አብ ጰጫ የም የላክዬ፥ ሳብ አሜንምስባቤ፥ የ ባላባብንዘንካ ስግዳን ጰጫ የንዘን የላባብ ጋያዬ፥ የ ጰጭምድንደት Ꮊይካ የ ዳንዳእተርን ዎልቃ እምንተካ ጰጨንታ ዋርንካ የ ዉተርንደትም ጎግ የካንታ ግግስተሬ። ");
INSERT INTO gyl_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","ይና እስታ ገርነንከሶ! ጮይስ ማታክባብከስካንታ ጎይንንዘንካ ጎተርከቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","ኮመረ እ የም ጋይድንደረ ገቀርድባብከስ የ ማቻንካንቴ፥ ኮካንታ እ ኬዝድንደትም የታ የንታ ማታርንካ ፋረድከቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","ዎታ ሳብም ጋለትሶቶ ዎ ካስምድንዳ አንጀታ ኡፍተና ክርስቶሰታ ማቀስንካ ክክን ዋልቃትች ዶቅድንዳ ካዮ? ዎ አስቲ ተይድንደረ ባልስና ክርስቶሰታ ዋሄንካ ክክን ዋልቃትች ዶቅድንዳ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","ባልስነረ ዋልቃ ማትንተንካ ዎተረ ኮትኮ ዋልቃ ባልስንዘንካ ካስምድባብ ዎማቻንጎካ Ꮊረሰነረ ዎራ በድንከስ ዎማቼረ ዋልቃ ዘኖቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","ይና እስራኤል ዎርሰንከስ ከት ይሳንደትም ሰድከቴ፥ እመርድን ካስን እጅድባከስ ካሰርድንደትካ ክክን ዋልቃትች ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","ይና ኮም እ ጋይድንካ ጮይስማታክባብከስካንታ ካሰርሳን ዋሄን መይድ ሪዬ እስታ ጋይንትዮ? አነረ ጮይስማታክባብከስና መይድርዬ እስታ ጋይንትዮ? ");
INSERT INTO gyl_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","ኩንካዬ! አይሁድ ማታክባብከስ ካስን ከት እምድንዳ ሳብካንታ ማታክናና ግምዘንከስካንቴ፥ ኮካንታ የታ ግምዘንከስካ ክክን ዋልቃትች የንታ ዶቅድንግንዳ እታ ዝግዳክቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","ጮይስትን ኡፍተናርንካ ዎጨረቶ አነረ ግምዘንከስታ ኡፍተናርንካ ዎጭ የም ዝክሳዬ፥ ጮይስታ እችምን የካ እጅድባብ ማትሰቶ አነረ ግምዘንከስታ እችምን የካ እች የም ዝክሳዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","ኮናና ኮም ይይንተካ ጮይስም ቀምስስተሮቶ? ዎታ ክታዘንካ ስግሶ ዛብዶቶ? ");
INSERT INTO gyl_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","ሙዳ ርና ይምድን ግንዳ ጋይምቴ። ኬዛር ማቼ ሙዳ ርና መያዬ፥ ሙዳ ርና ይምድን ግንዳ ጋይምቴ፥ ኬዛር ማቼ ሙዳ ርና አርንዝዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","ዋልቃ ዋልቃ ኤድና አብንከስተረ መይንተን ገቅራጋካ ዳት ይንታ ማታ መይድንደትም Ꮊክ Ꮊይዝጋ። ");
INSERT INTO gyl_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","የንታ ገቅርናርንካ አምድን Ꮊእርን Ꮊልእስሰቶ Ꮊምንመረ ጋባር ሰነርድንደትም ዋሀ Ꮊኤራከት ዶቆ እችከቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","“ፍጨኬ ኮታዘን ዶቅድሪ ሙዳ ጮይስቴ”። ");
INSERT INTO gyl_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","አሜን ማታክን ኤድ የም ኤልሳንዳማቼኬ የ አይሴ የካንታ እምምድን Ꮊምንመረ እችምን የንታ ገቅርንዘንካ አምድንደትም Ꮊእርንም Ꮊልእስሰቶ Ꮊኤራክሳ እችከቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","ኬዛር ማቼ ዋልቃ ኤድ “ኮና ዋሄና ጮይስ ማታክባብከስካንታ ካሲምሳንዴ” የም ጋይሴ ኮም ኬዝባብ ኤችንጎከ የንታ ገቅርን ጎካ ዋሄንም Ꮊይ እቸቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","ገቅርዬ እ የካንታ ጋይድንዳ ኤችንታ ገቅርን እስታ ጋይንታ ዳት የንታ ገቅርን እስታ ጋይንታ ካዬ፥ ይና አብ ኤታ ገቅርታ ጎግካ እስታ ባዛካይሳ ዶቅንትንዘን ፋረድንደና Ꮊረተረ? ");
INSERT INTO gyl_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","እታ ሳብም ጋለተርቶ እ እቻንማቼ ሳብም እ ጋለድን ሪንካ Ꮊረተስ ከዚምዳ? ");
INSERT INTO gyl_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","ይና የ እጅድንከረ ማታ የ ዎጭድንካ አነረ Ꮊረሰነረ ር የ ይድንካ ሙዳ ርንመረ ሳብታ ቦንቻካንታ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","አይሁድንም ማቼረ፥ አይሁድ ማታክባብከስመረ፥ ሳብተረ ምክስ ኤሄንም ማቼረ፥ Ꮊይመነረ Ꮊይ ጎሄርሰቴ። ");
INSERT INTO gyl_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","እታ ሙደነረ ከት አቅድንግንዳ አብንከስታ መይንተን ዳት እስታ ማታ መይድንደትም ዝጋክትዶቆ ኤድም ሙዳ እ ይድን ር ሙደንካ እ ጉርምዝድንደትግንዳ የተረ ኮትኮግንዳ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","እታ ክርስቶሰም እ ካምድንደትግንዳ የተረ እም ካምከቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","ሙዳᎺይካ እም የ ገቀርድንኦልኬ እ የካንታ እምሳን ዎገን ኡርስት የ የጃንኦል እታ የም አንጅድቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","ኬዛር ማቼ አⷝና ሙደንታ ዱረና ክርስቶሴ፥ ማነታ ዱረና አⷝኔ፥ ክርስቶሰታ ዱረና ሳብ ባቤና ማትንተንም የ ኤስተርንግንዳ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","ይንታ ማተንም ጉተርሶ ምግዝድባብ አነረ ቤሪታ ቃለን ኬዝድባብ አⷝና ሙደና ይንታ ማተንም የለርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","ኮትኮግንደረ ይንታ ማተን ዞከራክዶቆ ምግዝድንዳ አነረ ቤሪ ቃለንም ኬዝድንዳ ማነና ማነንታ ዘን ገችታ ኤራ ዶቅድባብ አⷝነንም የለርዝዴ፥ ይንታ ማተን ዞከርዳክንዳ ማነና ይንታ ማተን ሞከርሳንደትግንዳ ፋይድምዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","ማና ይንታ ማተን ዞከርዳክንዳ ማቼ ይንታ ማተን ኮት ተቸራ፥ ኬዛር ማቼ ይንታ ማተን ተችርናንከረ አነረ ሞክር ኮትም የለርዝድንዳ ር ማቼ ይንታ ማተን ኮት ዞከራ። ");
INSERT INTO gyl_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","አⷝና ሳብታ ካምንተኬ ሳብታ ቦንቸና ክታዘን Ꮊፈርድንዳ ማቻንኦል ይንታ ማተን ጉተር ክትም ዝክሳዬ፥ ማና ማቼ አⷝነታ ቦንቼ። ");
INSERT INTO gyl_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","ማና አⷝነዘንካ Ꮊፈርሳ ዳት አⷝና ማነዘንካ Ꮊፈራክዬ። ");
INSERT INTO gyl_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","ኮትኮግንደረ ማና አⷝናካንታ ፍዝምሳዳት አⷝና ማና ካንታ ፍዝማክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","ኮጎኬ ክታይንችንጎከረ ማና ገችታ ኤራ ቃዉተንታ ጎያር ማቻን ይንታ ማተን ዞከርድንደትካ ኮት ዞከራ። ");
INSERT INTO gyl_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","ጮይስያር ዎንታ ዶቅድን ዶቅንተንካ ማና አⷝና ካይሳ ዶቃዬ፥ አⷝነረ ማና ካይሳ ዶቃዬ። ");
INSERT INTO gyl_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","ማና አⷝነዘንካ Ꮊፈርሳንግንዳ ኮትኮግንደረ አⷝና አጥምድንደና ማና ዘንከ፥ ኬዛር ማቼ አⷝነረ ማታ ማነረ አብ ሪነረ ሙዳ Ꮊፈርድንዳ ሳብዘንኬ። ");
INSERT INTO gyl_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","ይና የንታ ማተን ፋረድከቴ፥ ማና ይንታ ማተን ዞከራክዶቆ ሳብደር ኮታ ምክስና ዝግዝድንዶ? ");
INSERT INTO gyl_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","አⷝና ይንታ ማተን ጋጵዚድንዳ ማቼ ኦስንዝድንዳ ክታዘን ማትንተን ፍዝርና ይንታ ማታርንካ የም ኤስዝዳ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","ማና ማቼ ማታ ኮትካንታ እምምሳንዳ ይንታ ማተን ኮት ዞከርድን ግንዳ ማቻንኦል ማተን ይንታ ኮት ጋጵሴረ ኮትካንታ ቦንቼ። ");
INSERT INTO gyl_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","ኮጎካ ቤርም ዝግድባብ ኤድ ዶቅሴ ዎተረ ማትሶ አነረ አብንከስ ሳብታ ᎺክᎺክ ምክስ ኤሄናር አሜንድባብከስ ኮዘንካ Ꮊክ መጣ ዎንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","የሳንምድንደትካ የ ይድንዳ ዳቅል ዳት ኡርማሪ ማታክንኦል ታ እ የም እምድን ኤስስንካ የም አንጃይቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","ሙደንዘንካ እሪ ምክስ ኤሄናር የ ሳንምድንደት Ꮊይካ የንታዎክያር ፋስም ዶቅንተን ኤሰርትቴ፥ እ ኤሰርሳንደረ ርና ባንግና ዶፈን ማትንተን አመንድቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","ዶፈን ማችባብከስ Ꮊይከስ ናንከረ ፋስምሰኮ ኬት ኤስምድንግንዳ የንታ ዎክያር ፋስም ዶቅንተና ነግማይንዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_20","076_11_20","1CO","11","20","20","ዋልቃትቼካ የሳንምድንደትካ የ እጅድንደና ክርስቶሰታ ደእንም ገቀርዝድንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C111_21","076_11_21","1CO","11","21","21","እጅደቶ ዋልቃባብ አብንም ካርሳክዶቆ ይንተንም ይንት እጅዴ፥ ኮግንደካ ዋልቃባብ ዳቀርድንካ አብና ጎዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_22","076_11_22","1CO","11","22","22","ይና የ እጅድንደትኬ የ ዎጭድንዳ ኤሀ የንታ ካዮ? አነረ ሳብታ ምክስ ኤሄንም ቶችተረቴ? አና Ꮊረነረ ካየንባብ ማጠርስባብከስም የለርስተረቴ? ይና Ꮊርስ የም ጋይቴ? ኮሪንታ እታ የም አንጅትቶ? ቦድሶ የም አንጃይቴ! ");
INSERT INTO gyl_vpl VALUES ("C111_23","076_11_23","1CO","11","23","23","ጮይስዘንካ እ ተያንደትኬ የካንተረ እ ስክስት እምሳንዳ ኤስስና ኮኔ፥ ጮይስ ይንታ ማተን ስክስት እምሳን ሶይትንካ ባልስንም አምሴ፥ ");
INSERT INTO gyl_vpl VALUES ("C111_24","076_11_24","1CO","11","24","24","ጋለት ምክስን ምክስሶ አስትዮ “ይኤቴ እችከቴ ኮና የካንታ ማድንዳ እስታ ዋሄ፥ ኮትኮም እም የም ገቀርስዝድንደትም ማስስከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("C111_25","076_11_25","1CO","11","25","25","ኮትኮግንደረ ሶይት እችምንታ ቡር ኡፍተንካ ዎጭምን አምስትዮ “ናኮና ኡፍተናር ዎጭምና እስታ ማቀስንካ ማድንዳ ክላ ጫቄ፥ የ ዎጭድንደት Ꮊይካ ሙዳ ኮትኮም እም የም ገቀርዝድንደትም ማስከቴ” ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("C111_26","076_11_26","1CO","11","26","26","ኮትኮም ባልስን የ እጅድንደትከ ኮትኮመረ ኡፍተናርንካ ዎጭምን የ ዎጭድንደትᎺይካ ሙዳ ጮይስ Ꮊተርን የለልታ ክታ ደእንም ኬዝተረቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_27","076_11_27","1CO","11","27","27","Ꮊየነረ ኤድ ዝግዝድንዳ ማታክንጎግካ ጮይስንታ ደእን ገቀርዝድን ባልስን ክት እቼኬ ኡፍተናርንካ ዎጭምን ክት ዎጬ ጮይስታ ዋሄንምኬ ማቀስን ይንታ ቶክስስንካ ኖ ኦይስምዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_28","076_11_28","1CO","11","28","28","ኮ ኦላር Ꮊየሰነረ ኤድ ኮም ባልስን ይ እችተርንደተኬ ኮትኮመረ ኡፍተናርንካ ዎጭምን ይ ዎጭተርንደታ እሪ ይንታ ማተንም ገቅር ክትም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_29","076_11_29","1CO","11","29","29","Ꮊየሰነረ ኤድ ጮይስታ ዋሄና Ꮊራ ናነረ ፋስት ኤሳክዶቆ ጮይስታ ደእን ገቀርዝድን ባልስን ክት እቻንዳ ማቼኬ ኡፍተናርንካ ክት ዎጬ ይንታ ማተንዘን ፍርደንም ተይᎺዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_30","076_11_30","1CO","11","30","30","የንታ ዎክያርንካ በድንከስ ጋፍስባብከስኬ ሰቀርስባከስ ዋልቃ ዋልቀንከሰረ ደእስባብከስ ኮ ጎኬ። ");
INSERT INTO gyl_vpl VALUES ("C111_31","076_11_31","1CO","11","31","31","ዎንታ ማተንዘን ዎ ፋረታ ናና ዎንታዘን ፋረድምተራክዶቆ። ");
INSERT INTO gyl_vpl VALUES ("C111_32","076_11_32","1CO","11","32","32","ኬዛር ማቼ ኦክስ ፍጫ ሙደንካ ክክን ዎ ካያባብካይሳ ጮይስ ታ ዎም ፋረደሮ ዋጭዴ። ");
INSERT INTO gyl_vpl VALUES ("C111_33","076_11_33","1CO","11","33","33","ኮካንታ እስታ እስመንከስኬ ምችነንከሶ! ክርስቶሰታ ደእን ገቀርዝድን እችምንካንታ የ ሳንምድንደት Ꮊይካ ሙደና Ꮊተርንካ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("C111_34","076_11_34","1CO","11","34","34","የንታ ሳንምና ፍርዳካንታ ማተራክንግንዳ የንታ ዎክያርንካ ይም ዳቅስባብ ኤድ ዶቅሴ ይንታ ኤር ክት እቻ። ነገዳን ሪንካንታ እታ ኮታር Ꮊድስቶ የካንታ የ ጎርስምድን ህግ ጉጅሶ እምትቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_1","076_12_1","1CO","12","1","1","እስታ እስመንከስኬ ምችነንከሶ ይና ታ አያን ጭልንታ እምንተንከስም የ ኤስተርንግንዳ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_2","076_12_2","1CO","12","2","2","አይሁድማታክሳ የ Ꮊቃንደትካ የ ኤዝዳክንርካ ጎርስምሰቶ ኬዛካንታ ማዳክን ጮይስ ማታክን ጎይንንከዝደር የ አይድ Ꮊቃን ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_3","076_12_3","1CO","12","3","3","ኮካንታ ሳብታ አያንካ ጎርስምሶ የሱሰም ባድባብ Ꮊየነረ ካዬ፥ ኮትኮግንደረ አያን ጭልንካ ጎርስምሶ ማታክንዳ ማቼ “የሱስ ጮይስዬ!” ጋይድባብ Ꮊየነረ ካየንደትም እታ የካንታ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_4","076_12_4","1CO","12","4","4","Ꮊክ Ꮊክ አያን ጭልንታ እምንተንከስ ዶቅደኬ፥ አያን ጭልና ማቼ ዋልቄ። ");
INSERT INTO gyl_vpl VALUES ("C112_5","076_12_5","1CO","12","5","5","Ꮊክ Ꮊክ ፍክስንከሰረ ዶቅዴ፥ ጮይስ ማቼ ዋልቄ። ");
INSERT INTO gyl_vpl VALUES ("C112_6","076_12_6","1CO","12","6","6","Ꮊክ Ꮊክ ፍክስንከሰረ ዶቅዴ፥ ኬዛርንካ ማቼ ሙደንም ይድባብ ዋልቃ ሳብዬ። ");
INSERT INTO gyl_vpl VALUES ("C112_7","076_12_7","1CO","12","7","7","ዋልቃ ዋልቃባብካንታ አያን ጭልንም መያ ማስታ እምንተን እምድንዳ ሙደንም መይድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C112_8","076_12_8","1CO","12","8","8","አያን ጭልና ዋልቃ ኤድካንታ ኤጨካ ኬዘርድንደታ ኤረን እምዴ፥ አብ ኤድ ካንተረ ጉጅሶ ናኮና አያንና ኤስካ ኬዘታ ኤረን እምዴ። ");
INSERT INTO gyl_vpl VALUES ("C112_9","076_12_9","1CO","12","9","9","ናኮና ዋልቃ አያንና ዋልቃባብካንታ አሜንን እምዴ፥ አብንካንተረ ፋችታ እምንተን እምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("C112_10","076_12_10","1CO","12","10","10","ኮትኮጎንደረ ዋልቃባብካንታ አተንም ይይንተታ ዎልቃ እምዴ፥ አብንካንታ ቤርታ ቃለን ኬዘታ ኤረን እምዴ፥ አብንካንታ ጉጅሶ እምንተንከስ አያን ጭልንዘንካ ማትንተን አነረ ዳቅል አያንንከዘንካ ማትንተን ፋስት ኤስንተታ ኤረንም እምዴ፥ ኮግንደረ ዋልቀንካንተረ Ꮊክ Ꮊክ አፈንከስካ ኬዘንታ ኤረንም እምዴ፥ አብንካንተረ ጉጅሶ Ꮊክ Ꮊክ አፈንከስካ ከዝምሳንደትም ቡልታ ኤረንም እምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("C112_11","076_12_11","1CO","12","11","11","ማታጋካ ዳት ኮም ሙዳ ይድንዳ ናኮና ዋልቃ አያን ጭልኔ፥ አያን ጭልና እምንተንም ይ ጋይሳንግንዳ ዋልቃ ዋልቃ ኤድንካንታ ካሰሮ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("C112_12","076_12_12","1CO","12","12","12","ዋልቃ ኤታ ዘነንዘን በድ ሱከንከስ ዶቅደኬ፥ ዘነንታ ሱከንከስ በድ ማትሶ ከትዶቅድንካ ኬት Ꮊፈርድንዳ ኮትኮ ዋልቃ ዘነንዘኔ። ኮትኮግንደረ ክርስቶሰታ ዘነንዘን በድ ሱከንከስ ዶቅድንደትግንዳ ዋልቃ ዘኔ። ");
INSERT INTO gyl_vpl VALUES ("C112_13","076_12_13","1CO","12","13","13","አይሁድንከስ ዎ ማችንከረ አይሁድ ማታክባብ ኤድንከስ ዎ ማቼረ፥ አይለንከስ ዎ ማቼረ፥ ባዛካይሳ ኤድንከስ ዎ ማቼረ፥ ዋልቃዘና ማትካንታ አያን ጭልንካ ስኤርቶቴ፥ ዎታ ሙደነረ ኮትኮ ዋልቀን አያንንዘንካ ዎጭቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_14","076_12_14","1CO","12","14","14","ዋልቃዘና ፈዝምሳንዳ በድ ሱከንከዘንካ ዳት ዋልቃ ዘነንታ ሱከዘንካ Ꮊክ ካዬ! ");
INSERT INTO gyl_vpl VALUES ("C112_15","076_12_15","1CO","12","15","15","ዱት “እታ አን እ ማታክንካንታ ዘነንታ ሱካ ካይቴ!” ጋይሴ ይና ኩን ይንታ ጋይንተንካ ዘነንታ ሱካ ማትንተና ነገዶ? ");
INSERT INTO gyl_vpl VALUES ("C112_16","076_12_16","1CO","12","16","16","ቃመረ “እታ አፍይ እ ማታክንካንታ ዘነንታ ሱካ ካይቴ” ጋይሴ፥ ይና፥ ኩን ይንታ ጋይንተንካ ዘነንታ ሱካ ማትንተና ነገዶ? ");
INSERT INTO gyl_vpl VALUES ("C112_17","076_12_17","1CO","12","17","17","ዋልቃ ዘነና ሙዳ አፍይ Ꮊክ ማቼስ ናና Ꮊረኮክ ኤሰረረዳ? ዋልቃ ዘነና ሙዳ ቃም Ꮊክ ማቼስናና Ꮊረኮክ ዎሰርዳ? ");
INSERT INTO gyl_vpl VALUES ("C112_18","076_12_18","1CO","12","18","18","ታ ማቼ ሳብ ይ ዝግዛንግንዳ ዋልቃ ዋልቀን ዘነንታ ሱከን ዘነንታዋር ዝግዝድን ካሪ የድሶ Ꮊፈርድን ግንዳ ፍዜ። ");
INSERT INTO gyl_vpl VALUES ("C112_19","076_12_19","1CO","12","19","19","ሙደንከሰረ ዋልቃ ሱካ Ꮊክ ማቼስ ናና ኤታ ኤደትችና Ꮊስ ይሶክ ኤስምዳ! ");
INSERT INTO gyl_vpl VALUES ("C112_20","076_12_20","1CO","12","20","20","ታ ማቼ በድ ዘነንታ ሱከንከስ ኬት ዶቅሰረ ዘነና ማቼ ዋልቃ Ꮊክዬ። ");
INSERT INTO gyl_vpl VALUES ("C112_21","076_12_21","1CO","12","21","21","አፍይ አንም “የና እካንታ ዝግዝዳከዬ!” ጋይዳክዬ፥ ቃደነረ ዱትም “የና እካንታ ዝግዝዳከዬ!” ጋይዳክዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C112_22","076_12_22","1CO","12","22","22","ኮትግንደረ አንድር ጋፍስባብከስ ካምሶ Ꮊፈርድባብከስ ዘነንታ ሱከንከስ ስግስሶ ዝግዝድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("C112_23","076_12_23","1CO","12","23","23","ቶክም ቦንቻ ዶቅድባብከስ ካምሶ ዎካንታ Ꮊፈርድባብከስ ዘነንታ ሱከንከስ ስግስሶ ቦንቻ ከትካንታ እምዶቴ፥ ሰድንካንታ ኦስንዝድባብከስ ካምሶ ዎካንታ Ꮊፈርድባብከስ ዘነንታ ሱከንከስ ስክስሶ ቦንቻ እምሶቶ ካርስምዶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C112_24","076_12_24","1CO","12","24","24","የረየር Ꮊፈርድባብከስ ዘነንታ ሱከንከስ ማቼ ኮና ሙዳ ከትካንታ ዝክሳዬ፥ ሳብ ማቼ ሰድንካንታ ኦስንዝድባብከስ ካምሶ ዎካንታ Ꮊፈርድባብከስ ዘነንታ ሱከንከስም ስገድንቦንቼካ ኬት የድምድንግንዳ ይይሶ ዘነንታ ሱከንከስም የችቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_25","076_12_25","1CO","12","25","25","ኮመረ ይስባብ ዘነንታ ሱከንከስታ ዎክያር ፋስም ዶቃክናና ክክ ክክ ኬት ገቀርድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C112_26","076_12_26","1CO","12","26","26","ዋልቃ ዘነንታ ሱከና ማጠርድንካ አብንከሰረ ዘነንታ ሱከንከስ ሙደና የካ ማጠርደኬ፥ ዋልቀና ዘነንታ ሱከና ቦንችምድንካ አብንከሰረ ኤደትቼንታ ሱከንከስ የካ ክክን ጉርምደኬ። ");
INSERT INTO gyl_vpl VALUES ("C112_27","076_12_27","1CO","12","27","27","የተረ ክርስቶስታ ዘነቴ፥ የታ ዋልቃ ዋልቀነረ ክታ ዘነንታ ሱከንከሰቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_28","076_12_28","1CO","12","28","28","ኮካንታ ሳብ ዋልቃ ዋልቃ ኤድ ምክስ ኤሄናር Ꮊክ Ꮊክ ፍክስ ዶቅድንግንዳ ይይቴ፥ ኮግንደካ እሪምሶ ኦይትምስባብከስም፥ ቃስትምስ ሳብዘንካ ኤስርሶ ኬዝድባብከስም፥ ማክምስ ኤስንባብከስም ዶርቴ። ኮታዘንከረ አቴንም ፍግዝድባብከስም፥ ኮታዘንከረ Ꮊክ Ꮊክ ፋችታ እምንታ ዶቅድባብከስም፥ ኤድንከስም አላካንታ እምንታ ዶቅድባብከስም፥ ገችንባብከስምኬ Ꮊክ Ꮊክ አፈካ ኬዝድባብ ኤድንከስም ማስቴ። ");
INSERT INTO gyl_vpl VALUES ("C112_29","076_12_29","1CO","12","29","29","ሙደነረ ኦይትምስባብከሶ? ሙደነረ ሳብዘንካ ኤሰርሶ ከዝድባብከሶ? ሙደነረ ኤስስንባከሰኮ? ሙደነረ አተንም ፍግዝድባብከሰኮ? ");
INSERT INTO gyl_vpl VALUES ("C112_30","076_12_30","1CO","12","30","30","ሙደነረ Ꮊክ Ꮊክ ፋችታ እምንታ ዶቅድባብከሰኮ? ሙደነረ Ꮊክ Ꮊክ አፈካ ኬዘታ ኤራ ኬታ ዶቅዶ? ሙደነረ Ꮊክ Ꮊክ አፈካ ከዝምሳንደትም ቡልካንታ ኬታ ኤራ ዶቅዶ? ");
INSERT INTO gyl_vpl VALUES ("C112_31","076_12_31","1CO","12","31","31","ኮካንታ አንድር ስገድንደትም እምንተንከስም Ꮊፍካንታ ዝከቴ። ታ ጉጅሰረ ሙደንዘንካ ስገድንደትም ጎግ የካንታ ሰጅድቴ። ");
INSERT INTO gyl_vpl VALUES ("C113_1","076_13_1","1CO","13","1","1","ኤድከረ ማታ ክታይንችታ አፈካ ኬዘታ ኤራ እስታ ዶቅሰረ ዎራ ሶልማ እስታ ካያ ማቼ ኦልድን ሉልንግንደኬ ዎረን ግንዳ ማድቴ። ");
INSERT INTO gyl_vpl VALUES ("C113_2","076_13_2","1CO","13","2","2","ቤር ኬዘታ እምንታ እስታ ዶቅሰረ አችምሳንደትመረ ሙዳ እ ኤዝዴ፥ ኤሰረ ሙዳ እስታ ዶቅሴ፥ ገቼንም ዋልቃ ካርዘንካ አብ ካርዘን ስርዝድንዳ አመነረ ሙዳ እስታ ዶቅሴ ሶልማ እስታ ካያ ማቼ እም መይዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("C113_3","076_13_3","1CO","13","3","3","እስታ ዶቅድንደትም ሙዳ ሪካየንባብከስካንታ እ ካሴ፥ እስታ ዋሄነረ ዎራ ነጋክናና ኖሄካ አተርድንግንዳ ስግስት እ እምሴ፥ ሶልማ እስታ ካያ ማቼ Ꮊረሰነረ እም መያዬ። ");
INSERT INTO gyl_vpl VALUES ("C113_4","076_13_4","1CO","13","4","4","ሶልማ ዳንዳእስዝዴ፥ ሶልማ ኡርመንም ይይዴ፥ ሶልማ ቀምዝድባብ ማስሳዬ፥ ሶልማ ዶቅድባብ ኤድ ጋይራዬ፥ ሶልማ ዶቅድባብ ኤድ ኦትራዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C113_5","076_13_5","1CO","13","5","5","ሶልማ ዎጋካያባብ ማስሳዬ፥ ሶልማ ዶቅድባብ ኤድ ይንታ ማታ መይድንደትም Ꮊክ ዝጋዬ፥ ሶልማ ዶቅድባብ ኤድ ማጥራዬ፥ ሶልማ ዶቅድባብ ኤድ ይም ዳቀልሰሬ ዳቀልስን ዳቀልስግንዳ ፍይዳዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C113_6","076_13_6","1CO","13","6","6","ሶልማ ዶቅድባብ ኤድ ዶፈን ማቻን ሪካ ጉርምዳ ዳት ገታ ማታክንሪካ ጉርማዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C113_7","076_13_7","1CO","13","7","7","ሶልማ ዶቅድባብ ኤድ ሙደንም ጋምዴ፥ ሙደንተረ ዘን አመንምዴ፥ ሙደንተረዘን ጉርምዴ፥ ሙዳ ሪከረ ዳቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C113_8","076_13_8","1CO","13","8","8","ሶልማ ዶቅድባብ ኤድ ሙዳᎺይከረ ዋቻዬ፥ ቤርንም ኬዝድንደታ እምንተና ስገዴ፥ Ꮊክ Ꮊክ አፈካ ኬዘታ ኤረና ስገዴ፥ ኤሳ ማቼረ ስገዴ። ");
INSERT INTO gyl_vpl VALUES ("C113_9","076_13_9","1CO","13","9","9","ዎ ኤዝድንዳ ማቼረ ቤር ዎከዝድንደረ ፋስሴ። ");
INSERT INTO gyl_vpl VALUES ("C113_10","076_13_10","1CO","13","10","10","ኬዛርንካ ማቼ ቦድማ ማቻን ር Ꮊድንካ ፋስም ማቻን ሪና ነገዴ። ");
INSERT INTO gyl_vpl VALUES ("C113_11","076_13_11","1CO","13","11","11","ኤና ይንች ዶቅድቶ ይንችግንዳ ኬዛᎺቃቴ፥ ይንችግንዳ ገቅራᎺቃቴ፥ ይንችግንዳ መርምድ Ꮊቃቴ፥ እ ጋጵሳንደታ ቡር ማቼ እስታ ይንች ገቅርን ዛቅሳቴ። ");
INSERT INTO gyl_vpl VALUES ("C113_12","076_13_12","1CO","13","12","12","ታ ማስታታሪ ዎ ሰድንግንዳ ዳልዳል ጋይድንካ ሰዶቴ፥ ኮታይካ ማቼ መያ ሰዶቴ፥ ታ እ ኤዝድንዳ ፋስሜ፥ ኮታይካ ማቼ ሳብ እም ኤዝድንደትከካ ሙዳ ኤሳ እስታ ዶቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("C113_13","076_13_13","1CO","13","13","13","ይና አሜን፥ ጉርም፥ ሶልማ፥ ኬና ማከንና ዳቅሶ ዶቅተረኬ፥ ኬዛር ማቼ ከትኬናከስታ ዎክያርንካ ስግድንዳ ሶልሜ። ");
INSERT INTO gyl_vpl VALUES ("C114_1","076_14_1","1CO","14","1","1","ይና ሶልመንም ጎርስምከቴ፥ አያን ጭልንታ እምንተንከስም ስግስሰረ ቤርንም ኬዘታ እምንተን ዛብሶ ዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_2","076_14_2","1CO","14","2","2","Ꮊክ Ꮊክ አፈንከስካ ኬዝድባብ ሳብካንታ ዳት ኤድ ካንታ ኬዛዬ፥ አቻ ማቻን ሪ አያን ጭልንታ ዎልቀካ ኬዝድን ኦል ክት ኬዝድንደትም ቃለን ኤዝድባብ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_3","076_14_3","1CO","14","3","3","ቤርንም ኬዝድባብ ማቼ አብን አመንናር ዎይስካንታ፥ ዛብስካንተኬ ዳቅስካንታ ኤድንከስካንታ ኬዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_4","076_14_4","1CO","14","4","4","Ꮊክ Ꮊክ አፈንከስካ ኬዝድባብ ኤድ ይንታ ማተንም Ꮊክ አመንናር ዎይስዝዴ፥ ቤርን ኬዝድባብ ማቼ አሜንድባብከስም አመንናር ዎይስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_5","076_14_5","1CO","14","5","5","የታ ሙደነረ Ꮊክ Ꮊክ አፈንከስካ የከዝዳ ናና እታ ሶልምድትዶቆ፥ ስግ እ ሶልምድንዳ ማቼ ቤርንም የ ከዝደስናነ፥ አሜንድባብከስ አሜንካ ዛብድንግንዳ Ꮊክ Ꮊክ አፈንከስካ ከዝምሳንደትም ቡልድባብ ካያማቼ፥ Ꮊክ Ꮊክ አፈንከስካ ኬዝድባብ ኤድዘንካ ስግስሶ ቤርንም ኬዝድባብ ኤድ ስገዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_6","076_14_6","1CO","14","6","6","ይና እስታ እስመንከስኬ ምችነንከሶ! የንደር እ ᎺድንደትᎺይካ Ꮊክ Ꮊክ አፈንከስካ ከዘርቶ እ Ꮊዳናንካ Ꮊርስ የም መይዳ? ስግስሶ ሳብታ አችምሳንደትም መይምስን፥ ኤሰንም፥ ቤር ኬዘንም፥ ኤስስን የካንታ የድስቶ እ Ꮊዳናና የም መይድቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_7","076_14_7","1CO","14","7","7","አንዳላግንደኬ ሶንግ ግንዳ ዶቅድባብከስ ሰንፓ ካየንባብከስ ይግታ ሪንከስ ዎራ Ꮊክ ኡፍስታ የችይ ኬታ ካየንዳ ማቼ ኬት እምድንዳ ይግንታ ኡፍስና Ꮊራ ኮት ማቼረ Ꮊስግንዶክ ኤስምዳ? ");
INSERT INTO gyl_vpl VALUES ("C114_8","076_14_8","1CO","14","8","8","ኤስምዳክን ኡፍስካ ፍቻ ፉግምሴ፥ ዳምካንታ Ꮊይ ግግምዳ? ");
INSERT INTO gyl_vpl VALUES ("C114_9","076_14_9","1CO","14","9","9","ኮትኮግንደረ የታ የንታ አፈንካ የ ከዝምድንካ መያ ማቻን ኬዘንም የ ከዛክንዳ ማቼ የ ኬዝድንደትም Ꮊይ ኤዝዳ? ዞጋ ካንታ ኬዝድባብግንዳ ማተረቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_10","076_14_10","1CO","14","10","10","ፍጫሙደንዘን በድ አፈንከስ ዶቅደኬ፥ ቡል ካየንዳ አፋ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_11","076_14_11","1CO","14","11","11","ይና እታ ኬዝምድን አፈንታ ቡልን እ ኤሳይንዳ ማቼ ኬዝድባብ ኤድንካንታ ሶች ማድቴ፥ ኖየረ እካንታ ሶች ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_12","076_14_12","1CO","14","12","12","የተረ አያን ጭልንታ እምንተንከስም ዛብሶ የ ዝግድን ኦል ስግ ዝግ የም ዝግዝድንዳ አሜንድባብከስ አሜንካ ዛብድንደትም እምንተንከስ የካንታ በድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_13","076_14_13","1CO","14","13","13","ኮካንታ Ꮊክ Ꮊክ አፈንከስካ ኬዝድን ኤድ ቡልተረ ኤራ ክታ ዶቅተርንግንዳ ክት ምክሳ። ");
INSERT INTO gyl_vpl VALUES ("C114_14","076_14_14","1CO","14","14","14","Ꮊክ Ꮊክ አፈንከስካ እ ምግዝደ እስታ አያንና ምግዝዳ ዳት እስታ ማክቼና ኮታር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_15","076_14_15","1CO","14","15","15","ይና Ꮊራ እም ይ ዝግዝዳ? እስታ አያንንካ ምግዝድት፥ እስታ ማክቼንከረ አና ምግዝድቴ፥ እስታ አያንካ የችንም የጅድቴ፥ እስታ ማክቼንካ አና የችንም የጅድቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_16","076_14_16","1CO","14","16","16","ኩን ማታክንዳ ማቼ የና አያንካ ሳብም የስ ጋለድንካ፥ የስ ጋይድንደትም ኤዝዳክባብ ሶች ኤድ የስታ ጋለትንታ ምክስን “አምንኤ” ጋይካንታ Ꮊስግንድክ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("C114_17","076_14_17","1CO","14","17","17","ገታ የስ እምሳን ጋለትንኬ ምክስንካ ኡርመኬ፥ ኬዛር ማቼ አብ ኤድና ኮትካ ዎአዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_18","076_14_18","1CO","14","18","18","እታ የ ሙደንዘንካ ስግ Ꮊክ Ꮊክ አፈንከስካ እ ከዝድንጎካ ሳብም ጋለድቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_19","076_14_19","1CO","14","19","19","ኬዛር ማቼ Ꮊክ Ꮊክ አፈንከስካ በድ ሳኤካ ፋይድምድን ኬዘንከስም ከዘዘንካ ስግስሶ አብንከስም ኤስስካንታ ጋይስቶ ምክስ ኤሄናር ኤድንከስካንታ ዶንቅ ኤስምድን አፈካ ኬዘንም እስታ ማክቼንካ ኬዛ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_20","076_14_20","1CO","14","20","20","እስታ እስመንከስኬ ምችነንከሶ! ዳቅል ሪ ካንታ ይንች ማትከቴ ዳት የንታ ገቅርንካ ይንችግንዳ Ꮊይማተቴ፥ ስግስሰረ የንታ ገቅርንካ ኡስባብ ማትከቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_21","076_14_21","1CO","14","21","21","ኮነረ “ ‘Ꮊክ Ꮊክ አፈንከስካ ከዘድን ኤድንከስኬ ፋለንባብ ኤድንከስታ አፈካ ኮ ዎርሰንካንታ ኬዝድቴ፥ ኮና ማችንከረ እም ኤሰራየኬ’ ጋይዴ ጮይስ ሳብና” ጋይምሶ ህግ ማጻፍናር ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_22","076_14_22","1CO","14","22","22","ኮካንታ Ꮊክ Ꮊክ አፈንከስካ ኬዛ ቃዉታ ማድንደና አሜንዳክን ኤድንከስካንታ ዳት አሜንድን ኤድንከስካንታ ካዬ፥ ቤር ቃለንም ኬዛ ማቼ ቃዉታ ማድንዳ አሜንድን ኤድንከስካንታ ዳት አሜንዳክን ኤድንከስካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_23","076_14_23","1CO","14","23","23","አሜንድባብከስ ሳንምድንደት Ꮊይካ ዋልቃ ዋልቃባብ አሜንድባብ Ꮊክ Ꮊክ አፈንከስካ ኬት ኬዘ ኤዝዳክባብከስ ናነረ አሜንዳክን ኤድንከስ Ꮊድሶ ኬዝድባብከስም “ኬና ኤድንከስ ኤየርተኬ” ኬትም ጋያዮ? ");
INSERT INTO gyl_vpl VALUES ("C114_24","076_14_24","1CO","14","24","24","ኬዛር ማቼ ዋልቃ ዋልቃባብ ቤር ኬዘንም ኬት ኬዘ አሜንዳክባብ አነረ ኤዝዳክን ኤድ Ꮊድሶ ይ ኤሰርድን ቃለንካ ሙዳ አተርዴ፥ ኮትኮግንደረ ይ ኤሰርድን ቃለንካ ሙዳ ጎማባብ ይንታ ማትንተንካ ፋረድምዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_25","076_14_25","1CO","14","25","25","ክታ ቡዳር አችምሳን ሪና መያ ማዴ፥ ይንታ ባለንከረ ጉፕን ጋይሶ “ገታ ሳብ ዎንታ ዎክያሬ!” ጋይንተካ ሳብካንታ ጎዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_26","076_14_26","1CO","14","26","26","እስታ እስመንከስኬ ምችነንከሶ! ይና Ꮊስ ይ ዝግዝዳ? ምክስካንታ የ ሳንምድናይካ የንታርንካ ዋልቀና የችይ የጅድንደታ እምንታ ክታ ዶቅዴ፥ አብና ኤስስታ እምንታ ክታ ዶቅዴ፥ ዋልቀና አቻር ማቻን ሪም መያ ማስታ እምንታ ክታ ዶቅዴ፥ ዋልቀና Ꮊክ Ꮊክ አፈንከስካ ኬዘታ እምንታ ክታ ዶቅዴ፥ አብና ቡልታ እምንታ ክታ ዶቅዴ። ይና ኮና ሙዳ እምንተና አሜንድባብከስም አሜንካ ዛብሲዚድንዳ ማት ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_27","076_14_27","1CO","14","27","27","Ꮊክ Ꮊክ አፈንከስካ ኬዝድባብከስ ዶቅሴ ቃስተን ናንከረ በጃን ማቼ ማከን ማትሶ ዋልቃባብ ኬዜ ዋልቃባብ ኬዛ፥ ከት ከዝድንደትመረ አብ ኤድ ቡላ። ");
INSERT INTO gyl_vpl VALUES ("C114_28","076_14_28","1CO","14","28","28","ቡልድባብ ካያ ማቼ Ꮊክ Ꮊክ አፈንከስካ ኬዝድባብከስ ኤድ ሳንምሶ ከዝምድንዘን ጫምን ክት ጋያ፥ ይንታ ማታ ካንተኬ ሳብካንታ Ꮊክ ክት ኬዛ። ");
INSERT INTO gyl_vpl VALUES ("C114_29","076_14_29","1CO","14","29","29","ቤርን ኬዝድባብከስ ቃስተን ናንከረ ማከን ማትሶ ከት ኬዛ፥ አብንከስ ማቼ ከዝምሳንደትም ኤሰርሰኮ ኤግዝምካ ፋስት ኬት ሰዳ። ");
INSERT INTO gyl_vpl VALUES ("C114_30","076_14_30","1CO","14","30","30","ሳንምሶ ኬዘዘን ዶቅድባብ አብ ኤድ ዋልቀረ ለምለም ጋይሶ ክትካንታ Ꮊፈርሰረ፥ እርንባብ ከዘንባብ ጫምን ክት ጋያ። ");
INSERT INTO gyl_vpl VALUES ("C114_31","076_14_31","1CO","14","31","31","ዋልቃ ዋልቃባብ ኤስተርንግንደከ ዳቅተርንግንዳ የታ ሙደነረ ዋልቃባብ ኬዜ ዋልቃባብ ካርስሰቶ ሳብታ ክተንም ኬዛካንታ ማደቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_32","076_14_32","1CO","14","32","32","ሳብዘንካ ኤሰርሶ ኬዛቅባብከስታ ቤር አያንና ሳብዘንካ ኤሰርሶ ከዝድባብከስካንታ ቆልምዴ። ");
INSERT INTO gyl_vpl VALUES ("C114_33","076_14_33","1CO","14","33","33","ሳብ ሳራትቼታ ጮይስ ዳት አዉለታ ጮይስ ካዬ፥ Ꮊክ Ꮊክ ምክስ ኤሄናር ሙዳ ይይምድንዳ ኮኔ። ");
INSERT INTO gyl_vpl VALUES ("C114_34","076_14_34","1CO","14","34","34","አሜንድባብከስ ሳንምድንደታር ማነንከስ ጫምን ጋያ፥ ህግና ክድንደትግንዳ ኬት ክትምድንደት ግንዳ ዳት ኬት ኬዝድንግንዳ ከትካንታ ጋይማክዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_35","076_14_35","1CO","14","35","35","ዋልቃ ዋልቃ ሪም ኤስ ይ ዝግዴ ይንታ ክእስንከስም ኤር ኬት ኦይሳ፥ ምክስታ ሳንምሳንደትᎺይካ ማና ኬዝድንግንዳ ዝግዝድንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C114_36","076_14_36","1CO","14","36","36","ይና ሳብታ ቃለና Ꮊዳንዳ የንደርኮ? አነረ ሳብታ ቃለና የልሳንዳ የንደር Ꮊክዮ? ");
INSERT INTO gyl_vpl VALUES ("C114_37","076_14_37","1CO","14","37","37","እታ ሳብዘንካ ኤሰርሶ ከዝድባብቴ አነረ አያናር እምንተና እስታ ዶቅዴ ጋይድን ኤድ ዶቅሴ ኮና እ የካንታ ጻፍሳንዳ ጮይስታ ክታ ማትንተን ክት ኤሳ። ");
INSERT INTO gyl_vpl VALUES ("C114_38","076_14_38","1CO","14","38","38","ኮም ኤዝዳክባብ ዶቅሴ ኖየረ Ꮊይ ኤስማ። ");
INSERT INTO gyl_vpl VALUES ("C114_39","076_14_39","1CO","14","39","39","ኮካንታ እስታ እስመንከስኬ ምችነንከሶ! ቤርንም ኬዛካንታ ዛብሶ ዝከቴ፥ Ꮊክ Ꮊክ አፈንከስካ ኬዘንመረ Ꮊይማረቴ። ");
INSERT INTO gyl_vpl VALUES ("C114_40","076_14_40","1CO","14","40","40","ኬዛር ማቼ ሙደና ዝግዝድንግንደኬ ዎጋ ዶቅድንዳ ማታ። ");
INSERT INTO gyl_vpl VALUES ("C115_1","076_15_1","1CO","15","1","1","ታ ጉጅሶ እስታ እስመንከስኬ ምችነንከሶ! እ የም ኤስሳን ክላ ኬዘንታ ቃለን የም ገቀርስካንታ ዝግድቴ፥ ና ኮነረ ክላ ኬዘንታ ቃለና የ ተያንደትኬ ዳቅሶ የ ዎእሳንደኔ። ");
INSERT INTO gyl_vpl VALUES ("C115_2","076_15_2","1CO","15","2","2","እ የም ኤስሳን ክላ ኬዘንታ ቃለን ምትሳ የ የጄ ክርስቶሳር አቅተረቴ፥ ኩን ማታክንዳ ማቼ የአሜንሳንዳ ዉች ኩኔ። ");
INSERT INTO gyl_vpl VALUES ("C115_3","076_15_3","1CO","15","3","3","እ ተያንደትም ኤና እርንደትዘንካ ዶቅድን ርን የካንታ ስክሳቴ፥ እ የካንታ ስክሳንደረ ርና ጭል ማጻፍንከሳር ጻፍምሳን ግንዳ ክርስቶስ ዎንታ ጎመንካንታ ደእሴ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_4","076_15_4","1CO","15","4","4","ዱከርሴ፥ ጭል ማጻፍንከሳር ጻፍምሳን ግንደረ ማክምስ ሰጨንካ ደእናርንካ አምሴ ጋይድንዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_5","076_15_5","1CO","15","5","5","ኖ ጴጥሮስካንታ Ꮊፈርሴ፥ ኮታ ቡረረ ታመከኬ ቃስተን ኦይትምስባብከስካንታ Ꮊፈርሴ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_6","076_15_6","1CO","15","6","6","ዶንቅ ጨተዘንካ ስገድን ክታ ካርንካ ጎርስምድባብከስካንተረ ዋልቃዱት ከትካንታ Ꮊፈርሴ፥ ከታርንከረ በድንከስ ታ የለልታ ሰምፔካ ዶቅደኬ፥ ዋልቃ ዋልቀንከስ ማቼ ደእተኬ። ");
INSERT INTO gyl_vpl VALUES ("C115_7","076_15_7","1CO","15","7","7","ኮተረ ቡር ያይቆብ ካንታ Ꮊፈርሴ፥ ኦይትምስባብ ሙደንከስካንተረ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("C115_8","076_15_8","1CO","15","8","8","በእንታዘነረ እ ፉጭማ ግንደንካንታ Ꮊፈርሴ። ");
INSERT INTO gyl_vpl VALUES ("C115_9","076_15_9","1CO","15","9","9","እታ ሳብታ ምክስ ኤሄናር ኤድንከስም ዳይስባብ እ ማቻንኦል ኦይትምስባብከስ ሙደናርንካ እታ ቶክስባብኬ ኦይትምስባበረ ጋይምሶ ኤልም እም ዝግዝዳክባብቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_10","076_15_10","1CO","15","10","10","ኬዛርካ ማቼ እታ ታ እ ማቻንደትም ማትስቶ እ Ꮊፈርድንዳ ሳብታ ዉች እምንተንኬ፥ እካንታ እምምሳንደረ ሳብታ ዉች እምንተና አፍካይሳ ነጋክዬ፥ ኮትግንደረ አብንከዘንካ ስግሶ ፍክስንካ ጋፍትቴ፥ ኬዛር ማቼ ኮም ይሳንዳ እንካ ክክን ዶቅድንዳ ሳብታ ዉች እምንተና ዳት እታ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_11","076_15_11","1CO","15","11","11","ይና እተረ ማታ ከተረ ዎ ኤስዝድንደና ኮትኮሜ፥ የተረ የ አሜንሳንዳ ኮትሜቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_12","076_15_12","1CO","15","12","12","ኬዛርካ ማቼ ክርስቶስ ደእናርንካ አምሳንግንዳ ዎ ኤስዝድንዳ ማቼ የንታ ዋርንካ ዋልቃ ዋልቀንከስ ደእናርንካ አምንታ ካዬ Ꮊስግንደክ ጋይዳ? ");
INSERT INTO gyl_vpl VALUES ("C115_13","076_15_13","1CO","15","13","13","ደእስባብከስ አማይንዳ ማቼ ክርስቶስ ደእናርንካ አማክ ጋይንትዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_14","076_15_14","1CO","15","14","14","ክርስቶስ ደእናርንካ አማክንዳ ማቼ ዎንታ ኤስስነረ ማታ የንተረ አሜንና ዉችኩን ማዴ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_15","076_15_15","1CO","15","15","15","ጉጅሰረ ሳብ ክርስቶሰም ደእናርንካ ክትም አምስቴ ጋይሶቶ ዎንታ ኤስስንካ ካርከካ ሳብዘን ማርከርድባብከስ ማቶቴ ጋይንትዬ፥ ይና ደእስባብ ኤድንከስ ደእናርንካ ከት አማክ ማቼ ሳብ ክርስቶሰም ደእናርንካ አምሳክዬ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_16","076_15_16","1CO","15","16","16","ደእስባብ ኤድንከስ ደእናርንካ አማክንዳ ማቼ ክርስቶሰረ ደእናርንካ አማክ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_17","076_15_17","1CO","15","17","17","ክርስቶስ ደእናርንካ አማክንዳ ማቼ የንታ አሜንና ዉችዬ፥ አክ የንታ ጎመናር ዶቅተረት ጋይንትዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_18","076_15_18","1CO","15","18","18","ኮትኮግንደረ ክርስቶሰካ አሜንሶ ደእስባብከስ ካይተከ ጋይንትዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_19","076_15_19","1CO","15","19","19","ክርስቶሰካ ጉርም ዎ ይድንዳ ኮ ፍጫሙደንዘን Ꮊክ ማቼ ኤድ ሙደንዘንካ ስግ አብና ዎካንታ አተርድንግንዳ ይስዝድባብ ማዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_20","076_15_20","1CO","15","20","20","ኬዛር ማቼ ክርስቶስ ደእእስባብከስካንታ ደእናርንካ አምንተንካ ዳነዝ ማትሶ ገታ ደእናርንካ ኖ አምቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_21","076_15_21","1CO","15","21","21","ደእ Ꮊዳንዳ ዋልቃ ኤች አዳምጎካ ማቻንግንዳ ደእናርንካ አምንተነረ Ꮊድንደረ ዋልቀን ኤችን ክርስቶስጎኬ። ");
INSERT INTO gyl_vpl VALUES ("C115_22","076_15_22","1CO","15","22","22","አዳምጎካ ኤድ ሙደና ደእድንደትግንዳ ኮትኮግንደረ ክርስቶስጎካ ኤድ ሙደና ሰንፔም Ꮊብዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_23","076_15_23","1CO","15","23","23","ኮነረ ማድንዳ ዋልቃ ዋልቀንባብካንታ የችንግንዴ፥ ክርስቶስ ደእናርንካ አምንተንታ እርናና ካምስ ማቴ፥ ክርስቶስ ማት ክት ᎺድንደትᎺይካ ክታ ማችባብከስ አምደኬ። ");
INSERT INTO gyl_vpl VALUES ("C115_24","076_15_24","1CO","15","24","24","ኮታዘንከረ ኖ ይ ቆልድንደትምከ ገችታ ኤረን አነረ ዎልቀንም ሙዳ ካይስሶ ባንችምን ሳብ ባቤንካንታ ክት እምድንደትᎺይካ ኮ ፍጫሙደንታ በእንታ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_25","076_15_25","1CO","15","25","25","ሳብ ክታ ይምኤንባብከስም ሙዳ ክታ ገችንታ ኤረንታ ጎይናር ክትካንታ ይተርን የለልታ ክርስቶሰም ባንችም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_26","076_15_26","1CO","15","26","26","ጋመርሶ በእንተዘን ካይድን ይምኤንባብና ደእዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_27","076_15_27","1CO","15","27","27","“ሳብ ሙዳ ርም ክርስቶስታ ገችንታ ኤረንታ ጎያር ማስቴ” ጋይምድንዳ ጻፍምቴ፥ ኬዛር ማቼ “ሙዳ ርና ክታ ገችንታ ኤረንታ ጎያር ማቴ” ጋይምድንካ ሙዳ ርም ክታ ገችንታ ኤረንታ ጎይናር ይስባብ ሳብ ባቤንም ጉጃዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_28","076_15_28","1CO","15","28","28","ሙዳ ርና ክርስቶሰታ ገችታ ኤረንታ ጎይናር ማቻንደታ ቡር ሳብ ባብቤና ሙደንካ ማድንግንዳ ይንችና ይንታ ማታርንካ ሙዳ ርም ክታ ገችንታ ኤረንታ ጎይናር ይስስባብ ሳብ ባቤንታ ገችንታ ኤረንታ ጎይናር ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_29","076_15_29","1CO","15","29","29","ይና ደእስባብ ኤድንከስ ከት አምዳክንዳ ማቼ ደእስባብ ኤድንከስካንታ ስኤርድባብከስ ሙደንታ ስጥመና Ꮊራ? ደእስባብ ኤድንከስ ቦድሶ ከት አማይ ማቼ ኤድንከስ ከታ ካርያር Ꮊረተክ ስኤርዳ? ");
INSERT INTO gyl_vpl VALUES ("C115_30","076_15_30","1CO","15","30","30","ዎታ ማቼረ ሙዳ ሳዓትንካ ማጣካንታ መያ ማተሮቶ ዎ ዶቅድንዳ Ꮊረተረ? ");
INSERT INTO gyl_vpl VALUES ("C115_31","076_15_31","1CO","15","31","31","እስታ እስመንከስኬ ምችነንከሶ! እም ሙዳᎺይካ ደእ እንካ ማስምዴ፥ ኮመረ የካንታ እ ኬዝድንዳ ዎንታ ጮይስን የሱስ ክርስቶስጎካ የንታዘን እስታ ዶቅድንዳ ጨቅና ገታ ማቻንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_32","076_15_32","1CO","15","32","32","ኤታ ገቅርግንዳ እታ ኤፈሶን ካተመናር ባችርካ ክክን እስታ ጉርንታ እም መይድንዳ Ꮊራ? ደእስባብከስ ደእያርንካ ከት አማይ ማቼ “ሰናካ ዎ ደእድን ኦል ኮረቴ እቸርተሬ፥ ዎጨርተረ” ጋይምሳንግንዳ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_33","076_15_33","1CO","15","33","33","Ꮊይገስመቴ፥ “ዳቅል ላኮይትና ኡርማ እዘን ባችዝዴ”። ");
INSERT INTO gyl_vpl VALUES ("C115_34","076_15_34","1CO","15","34","34","ቡደካ ማትከቴ፥ ጎመንመረ Ꮊይ ፍክሰቴ፥ የንታ ዎክያር ዋልቃ ዋልቀንከስ ሳብም ኤዝዳክባብከስ ዶቅደኬ። ኮመረ እ ጋይድንዳ የ ኦስንተርን ግንዳ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_35","076_15_35","1CO","15","35","35","ዋልቃ ኤድ “ደእስባብ ኤድንከስ ደእናርንካ አምድንዳ Ꮊስግንደረ? ደእናርንካ ከት አምድንካ ከታ ዶቅድንዳ ዘነና Ꮊረሞክ ካምዳ?” ጋይሶ ኦይዝዳ ማተረ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_36","076_15_36","1CO","15","36","36","የና ዳቸኖ! የስ ማዝድን እስና ደአክ ማቼ ባቀልሶ ጋጵ ካንታ ማታዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_37","076_15_37","1CO","15","37","37","የና ማዝደዮ ዘርግ ናንከረ አብ እስንታ አፍ ዋልቀንደትም Ꮊክ ማዝደይ ዳት ባቀልሶ ዉድንደትም ሙዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_38","076_15_38","1CO","15","38","38","ሳብ ማቸ ማሰንካንታ ይ ዝግዛንግንዳ ዘነንም እምዴ፥ ዋልቃ ዋልቃ ማሰንካንተረ Ꮊክ Ꮊክ ዘነን እምዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_39","076_15_39","1CO","15","39","39","ዋሀ ሙደና ዋልቀም ካምድንዳ ካዬ፥ ኤታ ዋሄረ ዋልቀም ካምዴ፥ መሄንከስታ ዋሄና Ꮊክዬ፥ አፍትንከስታ ዋሄነረ Ꮊክዬ፥ ሞለታ ዋሄነረ Ꮊክዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_40","076_15_40","1CO","15","40","40","ኮትኮግንደረ ጭላርንደታ ዘና ዶቅዴ፥ ፍጫ ዘንደተረ ዘና ዶቅዴ፥ ኬዛር ማቼ ጭለዘን ዘነንታ ቦንቸና ዋልቃ ክክ ካምዴ፥ ፍጨዘን ዘነንታ ቦንቸና Ꮊክ Ꮊክዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_41","076_15_41","1CO","15","41","41","Ꮊይንታ ሳክስንታ ቦንቼና ዋልቄ፥ አርፈንንታ ሳክስታ ቦንቼና Ꮊክዬ፥ ቤዝንከስተረ ሳክስንታ ቦንቼና አና Ꮊክዬ፥ ዋልቃ ቤዝና አብ ቤዝንዘንካ Ꮊክ ቦንቻ ኮታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_42","076_15_42","1CO","15","42","42","ደእናርንካ አምድን ኤድንከስታ ይተና ኮትኮም ካምዴ፥ ካይድንዳ ደእድን ዘና ማትሶ ማስምሳንዳ ካይዳክንዳ ስለንካ ዶቅድን ዘና ማትሶ አምዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_43","076_15_43","1CO","15","43","43","ቶችምካ ማስምሳንዳ ቦንቼካ አምዴ፥ ጋፍሳንዳ ካምሶ ማስምሳንዳ ዎልቀካ ማትሶ አምዴ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_44","076_15_44","1CO","15","44","44","ኮ ዋሄንታ ዘና ማትሶ ማስምሳንደና አያንታ ዘና ማትሶ አምዴ። ዋሄታ ዘና ዶቅሳንካ አያንንታ ዘነነረ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_45","076_15_45","1CO","15","45","45","ኮካንታ “እርንባብ ኤችን አዳም ሰምፔካ ዶቅድባብ ፍዝር ኖ ማቼ” ጋይምሶ ጻፍምቴ፥ ቡርንባብ አዳም ኖየረ ክርስቶስ ማቼ ሰንፔንም እምድባብ አያን ማቼ። ");
INSERT INTO gyl_vpl VALUES ("C115_46","076_15_46","1CO","15","46","46","ኬዛር ማቼ እርናና Ꮊድባብ ዋሄክንባብ ዳት አያንክባብ ካዬ፥ አያንክባብ ማትሶ Ꮊድባብ ዋሄንክባብታ ቡርዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_47","076_15_47","1CO","15","47","47","እርንባብ ኤች አዳም ክት ፍዝምሳንዳ ፍጨዘንካ ማቻንኦል ፍጨትንባቤ፥ ቃስትምስ ኤችና Ꮊዳንዳ ጭላርንኬ። ");
INSERT INTO gyl_vpl VALUES ("C115_48","076_15_48","1CO","15","48","48","ፍጨዘንካ ማችባብከስ ፍጨዘንካ ፍዝምስባብግንደከ፥ ጭለዘንካ ማችባብከስ ጭላርንካ Ꮊድባብግንደኬ። ");
INSERT INTO gyl_vpl VALUES ("C115_49","076_15_49","1CO","15","49","49","ፍጨንዘንባብ ኤችንታ ካምንተን ዎ ካምድንደትግንዳ ጭለናርንባብ ኤችንታ ካምንተን ዎታ ካምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_50","076_15_50","1CO","15","50","50","እስታ እስመንንከስኬ ምችነንከሶ! እ የም ኬዝድንዳ ኮኔ፥ ዋሄከ ማቀስካ ሳብታ ባንችምን ተይዳክዬ፥ ኮትኮግንደረ ካይድንዳ ደእድን ዘነና ካይዳክን ስለንካ ዶቅድን ዘነን ተይዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_51","076_15_51","1CO","15","51","51","ይና፥ ዋልቃ አችምሳንደትም የካንታ ኬዝድቴ። ዎታ ሙደነረ ደእዳኮቴ፥ ኬዛር ማቼ ዎታ ሙደነረ ኦክምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_52","076_15_52","1CO","15","52","52","ዎ ኦክምድንደረ በእንተንታ ፍቼና ፉግምድንᎺይካ አፍታ ይፍቺ ግንዳ ዋልቃ ዱቴ። ፍቼና ፉግምዴ፥ ደእስባብ ኤድንከሰረ ካይዳክን ስለንካ ዶቅድባብከስ ማትሰኮ አምደኬ፥ ዎተረ ኦክምዶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C115_53","076_15_53","1CO","15","53","53","ኮና ካይድንዳ ካይዳክንደትም ኮነረ ደእድንዳ ደእዳክንደትም ቆብር ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_54","076_15_54","1CO","15","54","54","ኮና ካይድንዳ ካይዳክንደትም ኮነረ ደእድንዳ ደእዳክንደትም ቆበርድንደት Ꮊይካ “ደእታ ዎልቀና ጋመርሴ!” ጋይምሶ ጻፍምሳንዳ ቦድምዴ። ");
INSERT INTO gyl_vpl VALUES ("C115_55","076_15_55","1CO","15","55","55","ኮትኮግንደረ፤ “ደእዮ! ጋምንተና የስታ Ꮊብረረ? ደእዮ! ኤድም የስ ኡፈልዝድንዳ ዎልቀና Ꮊብረረ?” ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("C115_56","076_15_56","1CO","15","56","56","ደእታ እክነንዳ ዎልቀና ጎመዘንኬ፥ ጎመተረ ዎልቀና ህግዬ። ");
INSERT INTO gyl_vpl VALUES ("C115_57","076_15_57","1CO","15","57","57","ኬዛርንካ ማቼ ዎንታ ጮይስን የሱስ ክርስቶስጎካ ጋምንተንም ዎካንታ እምድባብ ሳብካንታ ጋለትና ማታጋካ! ");
INSERT INTO gyl_vpl VALUES ("C115_58","076_15_58","1CO","15","58","58","ኮካንታ ሶልምምስባብ እስታ እስመንከስኬ ምችነንከሶ! ዳቅሶ ዎእከቴ፥ Ꮊራ ርከረ Ꮊይ ጭጨተ፥ ጮይስታ ፍክስንጎካ የ ጋብድንዳ ዉችኩን ማታክንደትም ኤስሰቶ፥ ዛቃከትዶቆ ሙዳᎺይካ ጮይስታ ፍክስንም ፍክስካንታ ዳእከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_1","076_16_1","1CO","16","1","1","አሜንድባብከስካንታ ይይምድን ብረታ ዉቸን ጌለትያ ፍጨናር Ꮊክ Ꮊክ ምክስ ኤሄንካንታ እ እምሳን ህግንግንዳ የተረ ኮትግንዳ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_2","076_16_2","1CO","16","2","2","እ ᎺድንደትᎺይካ ብረታ ዉቼን ይይምዳክንግንዳ ሳምንት ሳምንት ዎጋይካ የንታርንካ ዋልቃ ዋልቀና ይ Ꮊብድንደትከካ ዉቼሮ Ꮊክ ክት ዎዳ። ");
INSERT INTO gyl_vpl VALUES ("C116_3","076_16_3","1CO","16","3","3","እታ የንደር እ Ꮊድንደት Ꮊይካ የታ የ እድባብ ኤድንከስ የ ዉችሳን ብረን የድሰኮ የሩሳሌም ከት አይድንግንዳ ጻፈርሳንደትካ ክክን ከትም ኦይድቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_4","076_16_4","1CO","16","4","4","እስተረ አይንተና ዝግዝድንዳ ኮት ማቼ፥ እንካ የካ አይደኬ። ");
INSERT INTO gyl_vpl VALUES ("C116_5","076_16_5","1CO","16","5","5","መቅዶንያ ፍጨናር ጎካ አይካንታ እ ገቀርሳንኦል ኮትካ ስግድቶ ዋልቃ ኮትካ የንደር Ꮊድቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_6","076_16_6","1CO","16","6","6","እ አይድን Ꮊምን ካርናረረ እስታ ጎግ ካንታ ማድንደትም አሌንም እካንታ የ አልተርንግንዳ ጋየርቶ Ꮊረንግርካ የንደር እ ዶቅድንዳ ማቼ በርግንም የንካ ክክን ስግዝድት ማተሬ፥ ");
INSERT INTO gyl_vpl VALUES ("C116_7","076_16_7","1CO","16","7","7","ታ ስገርቶ ጎግንኮትካ የም ሰድካንታ ዝጋይቴ፥ ጮይስታ ጋይተና ማቼ በድ ሰጫ የንካ ክክን ዶቅካንታ ጉርምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_8","076_16_8","1CO","16","8","8","ኬዛር ማቼ ጰንጣቆስጠ ባአልን የለልታ ኤፈሶን ካተመናር ዶቅድቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_9","076_16_9","1CO","16","9","9","በድ ፍክስ ዶቅድንዳ ሳክማ ፍልታ እካንታ ፎችምቴ፥ እም ግርድባብከስ ማቼ በድንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("C116_10","076_16_10","1CO","16","10","10","ጢማቶስ የንደር ᎺድንᎺይካ ኦይምካይሳ የንካ ክክን ክት ዶቅድንግንዳ አሌን አልከቴ፥ ኖየረ እግንዳ ጮይስታ ፍክስንም ፍግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C116_11","076_16_11","1CO","16","11","11","ኮካንታ Ꮊየነረ ክትም Ꮊይቶቻ፥ ኖ እስመን ከስካክክን እዝደር Ꮊድንግንዳ እ ክትም ካርዝድንካንታ እዝደር ሳራትቼካ ማት Ꮊድንግንዳ ክታ ጎግታ ማድንደትም አልከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_12","076_16_12","1CO","16","12","12","ዎንታ እስመና አጵሎስ አብ እስመንከስካ ክክን የም ከት ሰድንግንዳ ኡርስት ምክስትት ዶቆ፥ ኬዛር ማቼ ኖ ታ የንደር Ꮊድካንታ ኤአክዬ፥ ይም ኡርሳን ማቼ Ꮊተሬ። ");
INSERT INTO gyl_vpl VALUES ("C116_13","076_16_13","1CO","16","13","13","ንከቴ፥ አሜንካ ዳቅሶ ዎእከቴ፥ ዛብከቴ፥ ዳቅማ ኤድ ማትከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_14","076_16_14","1CO","16","14","14","የ ይድንደትም ሙዳ ሶልመካ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_15","076_16_15","1CO","16","15","15","እስታ እስመንከስኬ ምችነንከሶ! እስጥፋኖሰታ ኤሀኤድ አካያ ፍጫር እርንባብ አሜንድባብከስ ማቻንግንደኬ አሜንድባብከስካንታ ፍክስካንታ ከታ ይንታ ማተንም ስክስተኮ ከት እምሳንደትም የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_16","076_16_16","1CO","16","16","16","ከት ከናከስግንዳ ዶቅድባብ ኤድንከስኬ ከትከረ ክክን ፍክስንካ ጋብድባብከስካንታ ሙዳ የ ክትምድንግንዳ ኡርስት የም ገቀርዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_17","076_16_17","1CO","16","17","17","እስጥፋኖሰኬ ፈርዶናጦስ አካይቆሰረ እዝደር ኬታ Ꮊድንተና እም ጉርምስቴ፥ የታ እንካ ክክን የ Ꮊፈራክንደና ኬታ የንታ ካርያር እስታ ዞገርሳንደትም ጮችተኬ። ");
INSERT INTO gyl_vpl VALUES ("C116_18","076_16_18","1CO","16","18","18","ኬታ እስታ አያንንኬ የንተረ አያንን ኡክንስቴ፥ ኮካንታ ከትኬናከስግንዳ ዶቅድባብ ኤድንከስም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_19","076_16_19","1CO","16","19","19","እስያ ፍጨናር ዶቅድባብ Ꮊክ Ꮊክ ምክስ ኤሄና የም አቦ አቦ ጋይተኬ፥ አቅለከ ጵርስቅለከ፥ ከታ ኤሄናረረ ሳንምድባብ አሜንድባብከስ ሙደና ቡዳርንካ የም አቦ አቦ ጮይስንታ ላምንካ ጋይተኬ። ");
INSERT INTO gyl_vpl VALUES ("C116_20","076_16_20","1CO","16","20","20","ካሪ ዶቅድባብ አሜንድባብከስ ሙደና አቦ አቦ የም ጋይደኬ፥ ዶፈን ማቻንደትካ ሶንቅመረቶ አቦ አቦ ክክ ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_21","076_16_21","1CO","16","21","21","እታ ጳውሎስ ኮም አቦ አቦ ጋይንትን እስታ ገታ አንካ የካንታ ጻፍትቴ። ");
INSERT INTO gyl_vpl VALUES ("C116_22","076_16_22","1CO","16","22","22","ጮይስም ሶልምዳክባብ ዶቅሴ ባድምስባብ ማታ! ዎንታ ጮይስኖ፥ Ꮊትካ! ");
INSERT INTO gyl_vpl VALUES ("C116_23","076_16_23","1CO","16","23","23","ጮይስ የሱሰታ ዉች እምንተና የንካ ክክን ማታ። ");
INSERT INTO gyl_vpl VALUES ("C116_24","076_16_24","1CO","16","24","24","እስታ ሶልመና የሱስ ክርስቶስካ የ ሙደንካ ክክን ማታ፥ አምን ኤ። ");
INSERT INTO gyl_vpl VALUES ("C21_1","077_1_1","2CO","1","1","1","ሳብታ ጋይተካ የሱስ ክርስቶስታ ኦይትምስባብ ማችባብ ጳውሎስዘንኬ ዎንታ እስመን ጢማቶስዘንካ፥ ቆርንቶስ ካተመናር Ꮊፈርድን ሳብታ ምክስ ኤሄንከ ኮትኮግንደረ ሙዳ አካያ ፍጨናር Ꮊፈርድን አሜንድባብ ዎርሳ ሙደና፥ ");
INSERT INTO gyl_vpl VALUES ("C21_2","077_1_2","2CO","1","2","2","ዎንታ ባበን ሳብዘንካ፥ ጮይሰረ የሱስ ክርስቶሰታ ዉች እምንተኬ ሳራትቼና የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("C21_3","077_1_3","2CO","1","3","3","አጭርንታ ባበንኬ ዳቅንተን ሙዳ እምድባብ ኮትግንደረ ዎንታ ጮይስን የሱስ ክርስቶስታ ባቤን ሳብካንታ፥ ጋለትና ማታ። ");
INSERT INTO gyl_vpl VALUES ("C21_4","077_1_4","2CO","1","4","4","ዎታ ሳብዘንካ ዎ Ꮊብድን ዳቅንተንካ ማጠዘን ዶቅድባብከስም ሙዳ ዳቅስካንታ ዎ ማድንግንዳ ሳብ ዎም ዎንታ ማጣ ሙደንካ ዳቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C21_5","077_1_5","2CO","1","5","5","ክርስቶሰታ ማጠና ዎካንታ በጃንከካ ኮትኮግንደረ ክርስቶሰካ ዳቅንተነረ ዎካንታ በዴ። ");
INSERT INTO gyl_vpl VALUES ("C21_6","077_1_6","2CO","1","6","6","ዎታ ማጠን ዎ ተይድንካ የታ ዳቅንተንምኬ አቅንተንም Ꮊፍተረቴ፥ ዎ ዳቅድንካ ጉጅሰረ የተረ ዎ ተይድንደትም ካምድንደት ማጠን ዳንዳእካ ተይሰቶ ዳቅተረቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C21_7","077_1_7","2CO","1","7","7","ዎንታ ማጠን የ ካስምድንደት ከካ ዎንታ ዳቅንተንመረ የ ካስምድንደትም ዎ ኤዝድንኦል የንታዘን ዎንታ ዶቅድን ጉርምና ዳቅሜ። ");
INSERT INTO gyl_vpl VALUES ("C21_8","077_1_8","2CO","1","8","8","እስታ እስመንከስኬ ምችነንከሶ! እስያ ፍጨናር ዎ ዶቅድንደትᎺይካ ዎንዘን የልሳን ማጠን የ ኤዝድንግንዳ ሶልምዶቴ፥ ኮነረ ዎንዘን የልሳን ማጠና ባላካንታ ዎም ደጭድንዳ ማቻንጎካ ሰንፔካ ዶቅንትካንታ ዎንታ ዶቅድን ጉርምና ዎራ ነግታ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("C21_9","077_1_9","2CO","1","9","9","ኮትኮግንደረ ደእ ዎንዘን ፋረድምሳን ኬካ ዎካንታ ኤስምታ ዶቆ፥ ኮነረ ሙዳ ዎንዘን የልሳንዳ፥ ዎ አመንምድባብ ደእስባብከስም አምስዝድባብ ሳብካ ዳት ዎንታ ዎልቀካ ማታክንደትም ዎ ገቀርት ተይድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C21_10","077_1_10","2CO","1","10","10","ኮካንታ ኖ ደእካንታ የልዝድን ማጠንዘንካ ዎም አቅስቴ፥ አነረ ኖ ዎምአቅሰተሬ፥ ጉጅሰረ ዎም አቅዝድንደት ግንዳ ዎንታ ጉርምና ክትኬ። ");
INSERT INTO gyl_vpl VALUES ("C21_11","077_1_11","2CO","1","11","11","የተረ ዎም ምክስካ አላ ዝግዝዴ፥ በድ ምክስካ ዎታ ሳብታ አለን ዎ Ꮊብድንካ በድ ኤድንከስ ጉጅሶ ዎጎካ ሳብም ጋለደኬ። ");
INSERT INTO gyl_vpl VALUES ("C21_12","077_1_12","2CO","1","12","12","ዎ ጨቅድንዳ ሪና ኮኔ፥ ኮነረ ዶፈን ማትንተን ዎንታ ማክቼና ዎካንታ ማርከርዴ፥ አብን ኤድንከዘንኬ ስግስሰረ የንካ ክክን ዶቅድንዳ Ꮊፍርና ሳብዘንካ ዎ Ꮊፍሳን ሳብካንታ ፋስምንኬ ሉለዘን የድምሳንዴ፥ ኮነረ ማቻንዳ ሳብታ ዉች እምንተንካ Ꮊቃ ዳት ኤታ ኤጨካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C21_13","077_1_13","2CO","1","13","13","ናበብሰቶ ገቅርት የ ተይካንታ የ ማዳክንዳ ማቼ አብ Ꮊረነረ የካንታ ጻፋዮቴ፥ ሙደንም ገቅር ካንታ የ ማድንግንዳ ጉርም ይድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C21_14","077_1_14","2CO","1","14","14","ታ ዎጎካ የ ኤዝድንዳ ቶክምየ፥ ኦስ እር ማቼ ቦድሶ የ ገቀርድንደትም Ꮊድን ጉርም ይድቴ፥ ኮጎከረ ጮይስ የሱስ Ꮊድንደት Ꮊይካ ዎታ የንካ ዎ ጬቅድንደት ግንዳ የተረ ዎንካ ጬቅተረቴ። ");
INSERT INTO gyl_vpl VALUES ("C21_15","077_1_15","2CO","1","15","15","ኮርንካ ገታ እ ማቻንጎካ ቃስተን ዱት የካንታ መይድን ግንዳ ጋይስቶ የም እርምስቶ ሰድንካንታ ገቀርትትዶቆ፥ ");
INSERT INTO gyl_vpl VALUES ("C21_16","077_1_16","2CO","1","16","16","እ ገቀርሳንዳ ኦስ መቅዶና ካተመናር ስገርንደትኬ ኮታርንከረ እ ማድንደትᎺይካ የም ሰድካንቴ፥ ኮግንደከረ ኦስ ይሁዳ ፍጨናር እ አይድንደትካ እም አሌንም አልተረቴ ጋይንተካ ገቀርስቴ። ");
INSERT INTO gyl_vpl VALUES ("C21_17","077_1_17","2CO","1","17","17","ኮም እ ገቅርሳንደትካ እ ይድንደትም እታ ኤሳይባብ ኦስ ፈንክ ጋይድባብ የንደር ካምዶ? አነረ ኮም እስታ ገቅርንካ ዋልቃዱት “ይየኬ ዋአ” ጋየርቶ ኦስ ፈንክ ጋይንትካ ኤታ ገቀርካ እ ይሳንዳ የም ካምዶ? ");
INSERT INTO gyl_vpl VALUES ("C21_18","077_1_18","2CO","1","18","18","ሳብ አሜንምስባብ ማቻን ኦል ዎተረ የም ዎ ኬዝድን ኬዘና “ይያ ናንከረ ዋአ” ጋይድን ኦስ ፈንክ ጋይስዝድንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C21_19","077_1_19","2CO","1","19","19","እንኬ ስላስካ፥ ጢማቶሰከረ ሳብታ ይንችን የሱስ ክርስቶሰም የካንታ ዎ ሳባክሳንዳ ሙዳᎺይካ “ይዬ” ጋይድን ቃለካ ዳት፥ “ይዬ ናንከረ ዋአ” ጋይድን ኦስ ፈንክ ኦክምድን ቃለካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C21_20","077_1_20","2CO","1","20","20","ሳብ ዎካንታ እምሳን Ꮊድን ጉርምን ሙዳ “ይያ” ማድንዳ ክርስቶሰኬ፥ ኮካንቴ ሳብካንታ ቦንቼና ክርስቶስጎካ “አምንኤ” ዎ ጋይድንዳ። ");
INSERT INTO gyl_vpl VALUES ("C21_21","077_1_21","2CO","1","21","21","ዎም የንካ ክክን ክርስቶሳር ዎ ዛብድን ግንዳ ዎም ይስስባብ ሳብዬ፥ ይንታ ፍክስንካንታ ዎም እጅባብ ኖዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C21_22","077_1_22","2CO","1","22","22","ክታ ዎ ማቻንደታ ማርካ ማድንዳ ማይተምን ዎንዘን ይስባብኬ ኦስ እር ዎካንታ እምምድን ቆልማጎካ ዎንታ ቡዳር አያን ጭልን ዋሳ ማስሶ እምስባብ ኖዬ። ");
INSERT INTO gyl_vpl VALUES ("C21_23","077_1_23","2CO","1","23","23","እታ ቆርንቶስ ካተመናር ማትስቶ እ Ꮊዳክንዳ ጎግና የም እ ሞርእዝዳክንግንዳ የካንታ አጨርስቴ፥ ኮትኮካንተረ ሳብ እስታ ማርኬ፥ ");
INSERT INTO gyl_vpl VALUES ("C21_24","077_1_24","2CO","1","24","24","የታ የንታ አመንንካ ዳቅስባብ የ ማቻንጎካ የም ጉርምዝድን ግንዳ የንካ ክክን ፍግዝዶት ዳት የንታ አሜንካ የም ክዳኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_1","077_2_1","2CO","2","1","1","ይና የም እ ሞርእሳይንግንዳ ገቅርካ የም ሰድንካንታ የንደር ማት Ꮊዳክቴ ጋይስቶ እስታ ቡዳር ገቀርስቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_2","077_2_2","2CO","2","2","2","Ꮊረሰነረ ዎራ የም እ ሞርእስንከረ እ የም ሞርእስባብ የንዘንካ አብ እም ጉርምዝድባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("C22_3","077_2_3","2CO","2","3","3","ኮትግንዳ የካንታ እ ጻፍሳንደረ የንደር እ Ꮊድንካ እም ጉርምስካንታ ዝግዝድባብ ኤድንከስ እም ከት ሞርእዝዳክን ግንዳ ጋይስቴ፥ እስታ ጉርምና የ ሙደንታ ጉርም ማትንተን አመንድቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_4","077_2_4","2CO","2","4","4","አንድር ሞርእኬ ቡዳርንካ ማጥርካ፥ በድ ኤርመካ ማትስቶ የካንታ እ ጻፍሳንዳ አንድር እ የም ሶልምድባብከስ እስታ ማትንተን የ ኤዝድንግንዳ ጋይስቶ ዳት የም ሞርእስካንታ ጋይስቶ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C22_5","077_2_5","2CO","2","5","5","ኤድም ሞርእስስባብ Ꮊየነረ ዶቅሴ ክት ሞርእሳንዳ እም ማታክናና ክታ ባችንም ጎፍስ ኮት Ꮊይማታጋካ ዳት አብጎካ የንታርንካ በድንከስም ኖ ሞርእስቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_6","077_2_6","2CO","2","6","6","ኮግንዳ ኤድንካንታ የንታርንካ በድንከስ ክታዘን ፋረጃንዳ ዋጭና ክትካንታ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C22_7","077_2_7","2CO","2","7","7","ኮካንታ ኮና ኤችና አንድር ክታ ሞርእዘንካ አምሳንዳ ጉርምን ክት ተቻይን ግንዳ ስግስሶ ነጋ የ ክትም ጋይተርንግንደኬ ክትም የ ዳቅስተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C22_8","077_2_8","2CO","2","8","8","ኮግንደረ ክትም የ ሶልምድባብ የንታ ማትንተን ካርንካ የ ሰችተርን ግንዳ እታ የም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_9","077_2_9","2CO","2","9","9","ኮካንታ ኮትኮ ክተን የካንታ እ ጻፍሳንዳ ጰጭምሰቶ ሙዳ ሪካ ክትምስባብ የንታ ማትንተን ኤስካንታ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_10","077_2_10","2CO","2","10","10","የታ ነጋ የ ጋይድባብ ኤድካንታ እተረ ነጋ ክትም ጋይድቴ፥ ነጋ እ ጋይድን ባች ክታ ዶቅሴ እታ ክርስቶስታ እሪ ነጋ እ ክትም ጋይድንዳ የካንታ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_11","077_2_11","2CO","2","11","11","ኮመረ እ ይድንዳ ሰጣንታ ጩባ ፍክስን ዎ ኤዝድንኦል ሰጣን ዎም ገሳይንግንዳ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_12","077_2_12","2CO","2","12","12","ኮታ ቡር ክርስቶስታ ክላ ኬዘን ኤስስካንታ ኦስ ጥሮአዳ ፍጨናር እ አይሳንደትካ ጮይስ ዳልግማ ፍክስታ ፍልታ ፎችታ Ꮊቄ፥ ");
INSERT INTO gyl_vpl VALUES ("C22_13","077_2_13","2CO","2","13","13","ኬዛር ማቼ እስታ እስመን ቲቶም እ Ꮊፋክን ኦል እስታ አያንና Ꮊዉሳክዬ፥ ኮካንታ ኦ ዋር ዶቅድባብ አሜንድባብከስም ኡርማ ዶእከቴ ጋይስቶ ኦስ መቅዶና ፍጨናር አይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_14","077_2_14","2CO","2","14","14","ኬዛር ማቼ ዎም ሙዳᎺይካ ክርስቶስ ይንታጋምንተንካ ዎም ጎርዝድባብኬ ኡርማ ዎዝድንዳ ዶቅድን ዎስመንግንዳ ክርስቶስጎካ ዎንታ ዶቅድን ኤስንም ካሪ ሙደናር ዎ የልዝድንግንዳ ዎ ማዝድባብ ጮይስንካንታ ጋለትና ማታ! ");
INSERT INTO gyl_vpl VALUES ("C22_15","077_2_15","2CO","2","15","15","ዎታ አቅድባካንተረ ማታ ካይድባካንታ እጣንታ ኡርማ ዎስማ ዶቅድንደትግንዳ ክርስቶስካ ሳብካንታ ማቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C22_16","077_2_16","2CO","2","16","16","ዋልቃባብካንታ ደይዝድንዳ ደእ ከደር ዎሳባብ ማዶቴ፥ አብንካንታ ዶቅንት ማድንግንዳ ከደር ዎዝዶቴ፥ ይና ኮፍክስን ካንታ ማታባብና Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("C22_17","077_2_17","2CO","2","17","17","ዛልአ ሪን ቡቃኦግድባብ በድንከስግንዳ ዎታ ሳብታ ቃለንም ቡቃዮቴ፥ ኬዛር ማቼ ሳብዘንካ ክትምስባከስግንዳ ሉለካ ክትምስባብከስ ክርስቶስካ ማትሶቶ ሳብታ እሪ ኬዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C23_1","077_3_1","2CO","3","1","1","አናካርንካ ዎንታ ማተንም ቦንች የተሮቶ? አነረ ዋልቃ ዋልቀንከስ ይድንግንዳ የካንታ አነረ የንዘንካ ዎም ኤስምዝድንዳ ክታ ዝግዝዳ ዳቶ? ");
INSERT INTO gyl_vpl VALUES ("C23_2","077_3_2","2CO","3","2","2","ኤድ ሙደና የም ኤዝድንደትኬ የም ናበብድንዳ ዎንታ ቡዳር የታ ጻፍምስባብ ዎም ኤስምስታ ክተንከስ የተቴ። ");
INSERT INTO gyl_vpl VALUES ("C23_3","077_3_3","2CO","3","3","3","የታ ዎንታ ፍክስንካ Ꮊድባብከስ ክርስቶሰታ ክታ የንታ ማትንተና መዬ፥ ኮነረ ክተና ጻፍምሳንዳ ዶቅንት ሳብንታ አያንካ ዳት ዉች ፍደልካ ካዬ፥ ኮትኮግንደረ ኤታ ቡደዘን ዳት ሰይን ዘን ጻፍምሳንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C23_4","077_3_4","2CO","3","4","4","ኮም ዎ ጋይድንደና ክርስቶስጎካ ሳብዘን አሜን ዎንታ ዶቅድንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C23_5","077_3_5","2CO","3","5","5","ዎንታ ፍክስንም ዎ ቦተርንግንዳ ዎ ማታባብ ይድባብ ሳብ ዳት ዎታ ዎንታ ማታርንካ Ꮊረነረ ይይካንታ ማድባብ ካዮቴ። ");
INSERT INTO gyl_vpl VALUES ("C23_6","077_3_6","2CO","3","6","6","ክላ ጫቀንታ ፍክስንባብከስ ዎ ማድንግንዳ ማትንቴን ዎካንታ እምስባብ ኖዬ፥ ኮነረ ፍደልካ ጻፍምሳን ሙሴታ ህግና ማታክናና አያን ጭልንታ አሌንኬ፥ ፍደልካ ጻፍምሳን ሙሴታ ህግና ደእንም ተይᎺዴ፥ አያን ጭልና ማቼ ዶቅንትን እምዴ። ");
INSERT INTO gyl_vpl VALUES ("C23_7","077_3_7","2CO","3","7","7","ሙሴታ ህግና ጻፍምሳንዳ ሰይንዘን ፍደልኬ፥ ሙሴታ ህግና እምምሳንደት Ꮊይካ Ꮊቃን ሳክመና Ꮊልኤሮ አይድንዳ ማቼ እስራኤልንከስ ሙሴታ ባለንም ፍስሳ ሰድካንታ ማታከኬ፥ ይና ደእንም ተይᎺዳንዳ ህግና ኮግንዳ ቦንቸካ Ꮊፈርሴ ");
INSERT INTO gyl_vpl VALUES ("C23_8","077_3_8","2CO","3","8","8","ይና አያን ጭልንጎካ Ꮊፈርድንዳ ፍክስና ስግድንዳ ቦንቻ ዶቅተራክዮ? ");
INSERT INTO gyl_vpl VALUES ("C23_9","077_3_9","2CO","3","9","9","ኤድንከስም ኡርክ ማስሳን ፍክስና ኮከካ ቦንቻ ዶቅሴ ኤድንከስ ጭልምድን ፍክስና Ꮊስግንዳ አንድር ስግድንዳ ቦንቻ ዶቅተራክዮ? ");
INSERT INTO gyl_vpl VALUES ("C23_10","077_3_10","2CO","3","10","10","Ꮊድን ቦንቼና አንድር ስገዳንዳ ማትንተዘንካ አምሳንዳ እርንደታ ቦንቼና Ꮊረነረ ማትሶ ፋይድማዬ። ");
INSERT INTO gyl_vpl VALUES ("C23_11","077_3_11","2CO","3","11","11","ናኮና ዳበርዳበርይ ጋየሮ አይድ Ꮊቃንዳ ሪና ኮከካ ቦንቻ ዶቅሴ፥ ስለንክንደታ ዳቅሶ ዶቅድን ሪና ማቼ አንድርይ ስገዳንዳ ቦንቻ Ꮊስግንዳ ዶቃይንዳ! ");
INSERT INTO gyl_vpl VALUES ("C23_12","077_3_12","2CO","3","12","12","ኮግንደና Ꮊድን ጉርም ዎንታ ዶቅድንኦል ካርችካ ኬዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C23_13","077_3_13","2CO","3","13","13","ሙሴታ ላንቀሮ አይድንዳ ባለንታ ሮጵና Ꮊልእተርን የለልታ እስራኤልንከስ ኬት ሰዳይንግንዳ ባለን ይንታ ክጨሮ Ꮊቄ፥ ዎታ ማቼ ክትግንዳ ካዮቴ። ");
INSERT INTO gyl_vpl VALUES ("C23_14","077_3_14","2CO","3","14","14","ኬታ ቡደና ገታ አንቼርቴ፥ ታከረ የለልታ እርንደት ጫቃ ማጻፍን ኬት ናበብድንካ ኬታ ቡደና ኮትኮ ክጨርድን ሪንካ ክጨርሳንግንዴ። ኮነረ ማድንዳ ናኮና ክጭምሳንዳ ኮት Ꮊልእድንዳ ክርስቶሰካ Ꮊክ ማቻን ኦሌ። ");
INSERT INTO gyl_vpl VALUES ("C23_15","077_3_15","2CO","3","15","15","ታከረ ዎራ ማቼ ሙሴታ ህግ ማጻፍንከስም ናበብሳንከካ ኬታ ቡደና ክጭምድን ርይካ ክጭምዴ። ");
INSERT INTO gyl_vpl VALUES ("C23_16","077_3_16","2CO","3","16","16","ኬዛር ማቼ ኤድ ጮይስደር ማድንካ “ክጨርድን ሪና Ꮊልእዴ”። ");
INSERT INTO gyl_vpl VALUES ("C23_17","077_3_17","2CO","3","17","17","ጮይስ አያኔ፥ ጮይስተረ አያን ዶቅድንደታር ባዛካይሳ ዶቅንት ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C23_18","077_3_18","2CO","3","18","18","ዎታ ሙደና ክጨራክን ሪንታ እሪ ማትሶቶ ማስታታር ሰድምድንደት ግንዳ ጮይስታ ቦንቼን ሮጵዝዶቴ፥ ዎተረ አያን ማቻንደትም ጮይስታ ካምንተን ካምካንታ ቦንቼዘንካ ኦስ ቦንቻር ኦክምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_1","077_4_1","2CO","4","1","1","ሳብ ይንታ አጭርንካ ኮም ፍክስን ዎካንታ እምሳንካንታ ጉርምን ዎንታ ተቻዮቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_2","077_4_2","2CO","4","2","2","አችምሳንደትምኬ ኦስንዝድ ሪ ማቻንደትም Ꮊልእስቶቴ፥ ጩበከረ ፍክሳዮቴ፥ ሳብተረ ቃለን ኦካዮቴ፥ ስግስሶ ዶፈንን መያ ሰጅዶቴ፥ ዎንታ ማተንመረ ኤድ ሙደንታ ገቅርን ካንታ ሳብታ እሪ መያ ማዝዶቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C24_3","077_4_3","2CO","4","3","3","ዎ ኤስሳንዳ ክላ ኬዘንታ ቃለና Ꮊረንግርካ አችምሳንዳ ማችንከረ አችምሳንዳ ካይድባብከስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_4","077_4_4","2CO","4","4","4","ኮፍጫ ሙደን ቆልድባብ ሰጣን አሜንዳክን ኤድንከስታ ቡደን ዝልሴ፥ ኮከረ ሳብም ካምካ መያ ማችባብ ክርስቶሰታ ቦንቼንታ ክላ ኬዘና ከትካንታ ሳግዝድን ሳክመን ከት ሰዳክንግንዳ ይስሴ። ");
INSERT INTO gyl_vpl VALUES ("C24_5","077_4_5","2CO","4","5","5","ዎ ኤስዝድንዳ የሱስ ክርስቶስ ጮይስ ማትንተንምኬ ዎተረ ዎንታ ማታ የሱስካንታ የንታ ፍክስንባብከስ ዎንታ ማትንተና ዳት ዎንታ ማታካንታ ሳባክዳኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_6","077_4_6","2CO","4","6","6","“ሳክመና ኡምናር ሳካ!” ጋይሶ ኬዝባብ ሳብ ክርስቶሰም ካምንተካ ሳግዝድን ሳብታ ቦንቼን ኤስንተታ ሳክመን ዎም እምድንግንዳ ይንታ ሳክመን ዎንታ ቡዳር ሳግድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("C24_7","077_4_7","2CO","4","7","7","ኬዛር ማቼ ኮና ሙደንዘንካ ስገድን ዎልቀና ሳብታ ዳት ዎንታ ማታክንደትም ኤስምድንግንዳ ኮም ቦንቻ ሪንም ዎታ ድግድ ሪ ግንዶትዶቆ የቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_8","077_4_8","2CO","4","8","8","ፍና ሙደንካ ማጣ ዎንዘን የልዴ፥ ማቼረ ዎታ ጋመራዮቴ፥ በድᎺይካ ዎም ታንትምዝዴ፥ ማችንከረ ጉርምን ተቻዮቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C24_9","077_4_9","2CO","4","9","9","ይምኤንባከስ ዎም ዳይደኬ፥ ማቼረ ገርናካይሳ ነጋኮቴ፥ ጉጰርሶቶ ዋጅዶቴ፥ ማቺንከረ ደእዳኮቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C24_10","077_4_10","2CO","4","10","10","የሱሰታ ዶቅንትና ዎንታዘን መያ ማድንግንዳ የሱሰዘን የልሳን ደእን ዎንተረ ዘነንዘን ሙዳᎺይካ ባልሶቶ ኦንግዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_11","077_4_11","2CO","4","11","11","የሱስታ ዶቅንትና ዎንታ ደእድን ዘነንዘን መያ ማድንግንዳ ዎታ አፈክንባብ የሱስጎካ ሙዳᎺይካ ደእካንታ ስክስምት እምምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_12","077_4_12","2CO","4","12","12","ኮካንታ ዎታ ማቲ ማቲ ደእካንታ መያ ዎ ማድንካ የታ ማቼ ዶቅንትካንታ መያ ማደቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_13","077_4_13","2CO","4","13","13","ማታጋካ ዳት “አሜንስቴ፥ ኮካንታ ኬዝቴ” ጋይምሶ ጻፍምሳንግንዳ፥ ዎተረ ና ኮትኮ ዋልቀና አሜንንታ አያንና ዎንታ ዶቅድንኦል አሜንዶቴ፥ ኮካንተረ ኬዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_14","077_4_14","2CO","4","14","14","ጮይስ የሱሰመረ ደእያርንካ አምስባብ ሳብ ዎመረ የሱሰካ ክክን አምዝድንደትግንደኬ የንከረ ክክን ይንታ እሪ ዎም የልዝድንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C24_15","077_4_15","2CO","4","15","15","ኮና ሙዳ የካንታ መይድንዳ ማቻንዳ ዉች እምንተና ስጥሶ በድ ኤድንከስካንታ የልሳንደትኬ ሳብካንታ ቦንቻ ማድንዳ ጋለትና በድንደትግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C24_16","077_4_16","2CO","4","16","16","ኮካንታ ጉርምን ዎንታ ተቻዮቴ፥ Ꮊረነረ ዎራ ዎንታ ማልጎካ Ꮊፈርድን ዘነና ኮት ካይደረ ዎንታ ዋርጎክንዳ ዘነና ሰጨን ሰጨንካ ክላ ማዴ። ");
INSERT INTO gyl_vpl VALUES ("C24_17","077_4_17","2CO","4","17","17","ኮነረ ቶክመኬ ሰጫካንታ ማቻንዳ ዎንታ ማጠና የክስ ካየንደትም አንድር ባካ ማቻን ስለንክንደታ ቦንቼን ዎካንታ Ꮊፍስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C24_18","077_4_18","2CO","4","18","18","ዎ ካርዝድንዳ Ꮊፈርዳክ ርይን ዳት Ꮊፈርድንደትም ካዬ፥ Ꮊፈርድን ርና ሰጫ ካንቴ፥ Ꮊፈርዳክንዳ ማቼ ስለንክንደኔ። ");
INSERT INTO gyl_vpl VALUES ("C25_1","077_5_1","2CO","5","1","1","ኮና ዱንካንንግንዳ ሰጫካንታ ማቻንዳ ፍጨዘን ዎንታ ዋሄና ደእድንካ ኤታ አንካ ማታክናና ሳብካ ዎድምሳንዳ ስለንክንደታ ዶቅንት ጭላር ዎንታ ዶቅድንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_2","077_5_2","2CO","5","2","2","ጭላርንደታ ዶቅንትን ቆብርካንታ ሱነርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_3","077_5_3","2CO","5","3","3","ኮት ኮመረ ቆበርሶቶ ዘና ጫለንካ ማትሶቶ Ꮊፈራዮቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_4","077_5_4","2CO","5","4","4","ኮ ፍጨዘንግንዳ ዱንካን ማቻን ዎንታ ዋሄንታ ዋር ዎ ዶቅድንካ ዎም ደጭንካ አተርዶቴ፥ ዎ አተርድንደረ ደእና ዶቅንትካ ኦክምድን ግንዳ ጭላርንደት ዘነን ስግስሶ ዎ ቆበርድንግንዳ ዳት ኮ ፍጨዘን ዎንታ ዋሄንዘንካ ፋስም ካንታ ዝግሶ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C25_5","077_5_5","2CO","5","5","5","ኮ ሪንካንተረ ዎም ግክስባብ ሳብዬ፥ ኮታዘንከረ ስግ ዎካንታ እምምድ ሪ ሙደንካንታ ዋሳ ማድንግንዳ ይንታ አያንን ዎካንታ እምስባበረ ሳብ ኖዬ። ");
INSERT INTO gyl_vpl VALUES ("C25_6","077_5_6","2CO","5","6","6","ፍጨዘን ዎንታ ኤደትቼንካ ዎ ዶቅድን ሰጨናር ጮይስዘንካ ዎ ጎተርስባብ ማትንተን ዎ ኤሰረ ዎራ ሙዳᎺይካ ክትካ አሜንምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_7","077_5_7","2CO","5","7","7","ዎ ዶቅድንደረ ጮይስም አሜንካ ዳት ሰድንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C25_8","077_5_8","2CO","5","8","8","ኮ ዎንታ ዶቅንትንዳ ማቻን ዋሄንዘንካ ፋስምሶቶ ጮይስካ ክክን ማትካንታ አንገርዶቴ፥ ኮካንታ አሜንምሶ ዶቅዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_9","077_5_9","2CO","5","9","9","ኮዎንታ ዋሄንካ ክክን ዎ ማችንከረ አነረ ዋሄንዘንካ ዎ ፋስምሰረ ዎንታ ገቅርና ጮይስም ጉርምስዬ። ");
INSERT INTO gyl_vpl VALUES ("C25_10","077_5_10","2CO","5","10","10","ዋልቃ ዋልቀና ፍጨዘን ይንታ ዶቅንትንካ ይሳን ዳቅልንከረ ማታ ኡርማ ርንካ ይንታ ፍክስንግንዳ ናክንም ተይካንታ ዎታ ሙደነረ ክርስቶሰካ ፍርዳ ካርንዘን ክታ እር የልንት ዎም ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C25_11","077_5_11","2CO","5","11","11","ጮይስም ጳስና Ꮊራ ናንከረ ዎ ኤዝድንካንታ ኤድንከስም ኤዝድንግንዳ ይዶቴ፥ ዎታ Ꮊራ ዎ ማዳናንከረ ሳብ ኤዝዴ፥ የተረ የንታ ቡደናር Ꮊራ ዎ ማዳናንከረ የ ኤዝድንግንዳ Ꮊድን ጉርም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_12","077_5_12","2CO","5","12","12","ቡዳርንካ ዶቅድንደትካ ማታክናና ሰድምድንደትካ ጋየርድባከስካንታ ኬዘንታ ማስን የ ማዝድባብ ማተርንግንዳ ዎንካ የ ጋይርተርንግንዳ የም ጋይዶት ዳት ዎንታ ማተን የካንታ ቦንችሳዮተ። ");
INSERT INTO gyl_vpl VALUES ("C25_13","077_5_13","2CO","5","13","13","ኤየርስባብከስ ግንዳ ዎም ከት ፋይጅንከረ ዎታ ሳብካንታ ጋይሴ፥ ማክቸክንባብከስ ዎ ማቼረ የካንታ ጋይንተኬ። ");
INSERT INTO gyl_vpl VALUES ("C25_14","077_5_14","2CO","5","14","14","ዋልቃዱት ክርስቶስ ሙደንካንታ ክታ ደእንምኬ፥ ሙደነረ ክታ ደእን ካስምድባብ ከታ ማትንተን ዎ ኤሳንኦል ክርስቶሰታ ሶልመና ዎ ፍግዝድንግንዳ ይስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C25_15","077_5_15","2CO","5","15","15","ሰንፔካ ዶቅድባብከስ ሙደና ከትካንታ ደእስባብካንተኬ ደእናርንከረ አምስባብካንታ ከትዶቅድንግንዳ ዳት ኮዘንካ ኦስ ይንታ ማታ ካንታ ጋየረኮ ኬት ዶቅዳክንግንዳ ክርስቶስ ሙደንካንታ ደእሴ። ");
INSERT INTO gyl_vpl VALUES ("C25_16","077_5_16","2CO","5","16","16","ይና ኮዘንካ ኦስ ዎታ Ꮊይመነረ ኤድም ዋሀ አፍካ ሰደራየ፥ ኮታ ኤና እሪ ክርስቶስመረ ዎ ሰዳንዳ Ꮊየነረ ኤድግንዳ ዋሀ አፍካ ማቼ ኦስ እርንደታ ኮም ይዳኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_17","077_5_17","2CO","5","17","17","ኮካንታ Ꮊየነረ ኤድ ክርስቶሰታ ኮች ማቼ ክላ ፍዝርዬ፥ ገሳ ፍዝርና ስገቴ፥ ይና ክለና ካርንም የቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_18","077_5_18","2CO","5","18","18","ኮነረ ሙደና ማቻንዳ ዎም ይንካ ክክን ክርስቶስጎካ ኤድምስባብኬ ኤድምስተረ ፍክስን እምምሳንዳ ሳብዘንኬ። ");
INSERT INTO gyl_vpl VALUES ("C25_19","077_5_19","2CO","5","19","19","ኮነረ ሳብ ክርስቶስካ ፍጫሙደንታ ኤድንከስም ሙዳ ይንካ ክክን ኤድምሴ ጋይንትዬ፥ ኬታ ባችንመረ ኬታዘን ፋይዳክዬ፥ ዎካንተረ ኤድም ጮይስካ ክክን ዎ ኤድምዝድንደትም ቃላ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("C25_20","077_5_20","2CO","5","20","20","ሳብ ኤድንከስም ዎጎካ ኤልድንኦል ዎታ ክርስቶስታ ክትምስባብከሶቴ፥ ኮካንታ “ሳብካ ክክን ኤድምከቴ!” ጋይሶቶ ክርስቶሰታ ላምንካ ዎታ ምግዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C25_21","077_5_21","2CO","5","21","21","ዎታ ክርስቶስካ ሳብታ ጭለትቼን ዎ Ꮊብድባብ ማተርንግንዳ ሳብ ጎማ ካያባብ ክርስቶሰም ዎንታ ጎመን ክት ባልድንግንዳ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("C26_1","077_6_1","2CO","6","1","1","ሳብካ ክክን የካ ፍግዝድባብ ዎ ማቻንከካ የ ተያንደትም ሳብታ ዉች እምንተን ዉችኩን Ꮊይ ነክሰቴ ጋይሶቶ የም ምግዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_2","077_6_2","2CO","6","2","2","ሳብ፥ “ሶልምምሳንደት ሰጨንካ የዝደር ኤሰርሳቴ! አቅንታ ሰጨንከረ የስም አልሳቴ!” ጋይድንኦል፥ “ይና ሶልምምሳን ሰጨና ታዬ፥ አቅንተንታ ሰጨነረ ታዬ”። ");
INSERT INTO gyl_vpl VALUES ("C26_3","077_6_3","2CO","6","3","3","ዎንታ ፍክስና ይንኤርምዳክንግንዳ Ꮊረሰን ሪከረ Ꮊየን ካንታ ኮተርስባብ ማታዮቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_4","077_6_4","2CO","6","4","4","ስግስሰረ ማጠንምኬ ዘረም ገቅርካ ኦይምመረ ዳንዳኤሮቶ ሳብታ ፍክስንባብከስግንዳ ዎንታ ማተንም Ꮊምንጎግከረ ግግዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_5","077_6_5","2CO","6","5","5","ሳብታ ፍክስንባብ ዎንታ ማትንተንም ዎ መያ ማዝድንደረ Ꮊርድርካ፥ ዞክርካ፥ አዉልካ፥ ፍክስካ ጋፍካ፥ ግንአክሳ ነግንካ ዳቅርኬ፥ ");
INSERT INTO gyl_vpl VALUES ("C26_6","077_6_6","2CO","6","6","6","ኮትኮግንደረ ጭለጭልኬ፥ ኤሰካ፥ ዳንዳእካ ጋይንተካ፥ ላቅም ኤድ ማትንተካ፥ አያን ጭልንካ ጎርስምኬ አፈካ ገስ ካየንደት ሶልመካ፥ ");
INSERT INTO gyl_vpl VALUES ("C26_7","077_6_7","2CO","6","7","7","ዶፈን ቃለንኬ ሳብታ ዎልቀንካ ኦስ ዎ ካይዝድንደረ ማታ ዎንዘን የልዳክንግንዳ ዎ ማርድንዳ ዎንታ ዳምንደና ጭለትቼኔ፥ ");
INSERT INTO gyl_vpl VALUES ("C26_8","077_6_8","2CO","6","8","8","ቦንቻ ካንታናንከረ የላካንታ ዳቅልካ ከዝር ካንተረ ማታ አነረ ቦንችምካንታ ዎታ ግግምስባቦቴ፥ ዶፈንንከስ ዎ ናና፥ ገስንባብከስ ጋይምሶቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_9","077_6_9","2CO","6","9","9","ኤስምስባቦት ናና ኤስማክባብከስ ማቾቴ፥ ደእተኬ ዎም ጋይድንካ፥ ሰንፔካ ማትሶ Ꮊፈርዶቴ፥ ዎ ጉጰርስንከረ ደአኮቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C26_10","077_6_10","2CO","6","10","10","ሞርእ ዎም የልሰረ ሙዳᎺይካ ጉርምዶቴ፥ ሪካየንባብከስ ማትሶ ዎ ዶቅድንካ፥ በድንከስም ቆልማባብከትም ማስዝዶቴ፥ Ꮊረነረ ካየንባብ ዎ ማድንካ ሙዳ ሪ ዎንታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("C26_11","077_6_11","2CO","6","11","11","የታ ቆርንቶስ ካተመናር ዶቅድን ኤድንከሶ! ይና፥ መየካ የካንታ ከዝቶቴ፥ ዎንታ ቡደንመረ የካንታ መያ ማስቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_12","077_6_12","2CO","6","12","12","የታ የንታ ሶልመንም ዎካንታ ኡዘት ዳት ዎታ የካንታ ኡዛኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_13","077_6_13","2CO","6","13","13","ባቤና ይንታ ይንችንከስካንታ ኬዝድንግንዳ እ ኬዛጋካ፥ ዎታ ዎንታ ቡደን የካንታ መያ ማስቶቴ፥ ዎንታ ገቀንመረ የካንታ መያ ማስሳንግንዳ የተረ ኮትግንዳ ይይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_14","077_6_14","2CO","6","14","14","ዝግዝዳክንጎግካ አሜንዳክባብ ኤድንከስካ ክክን Ꮊይዙገረቴ፥ ጭለትቼኬ ጎመካ Ꮊስግንደክ የካ ማዳ? ሳክመኬ ኡምካ Ꮊስግንደክ የካ ዶቅካንታ ማዳ? ");
INSERT INTO gyl_vpl VALUES ("C26_15","077_6_15","2CO","6","15","15","ክርስቶስኬ ዳብሎሰካ Ꮊስግንደክ ክክ ኤእዳ? አመንድባብኬ አመንዳክባብካ Ꮊረከክ ኮችምዳ? ");
INSERT INTO gyl_vpl VALUES ("C26_16","077_6_16","2CO","6","16","16","ሳብታ ጭል ኤሄና ጮይስ ማታክባብከስም ጎይነርድንደትካ Ꮊራ ዋልቃትች ዶቅዳ? ሳበረ “እስታ ዶቅንቴን እስታ ዎርሰንታ ዎክያር ማስዝድቴ፥ ከትከረ ክክን ዶቅትቴ፥ እታ ከታ ጮይስ ማትቴ፥ ከተረ እስታ ዎርሳ ማደኬ” ጋይሶ ኬዛንደትግንዳ ዎታ ዋልቃ ዋልቀና ስለንካ ዶቅድባብ ሳብንታ ጭል ኤሆቴ። ");
INSERT INTO gyl_vpl VALUES ("C26_17","077_6_17","2CO","6","17","17","ጉጅሰረ ጮይስ ኩን ጋይቴ፥ ከ ኤድንታ ዎክያርንካ ፋስምሰቶ ዉትከቴ፥ ቱና ማቻን ሪን Ꮊይዎለቴ፥ እተረ የም እስታ ማስስቶ ኤልድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C26_18","077_6_18","2CO","6","18","18","እታ የንታ ባቤና ማድቴ፥ የተረ እስታ አⷝና ይንችኬ ማና ይንች ማተረቴ፥ ጋይዴ ሙደንም ጋምድባብ ጮይስ። ");
INSERT INTO gyl_vpl VALUES ("C27_1","077_7_1","2CO","7","1","1","ይና እስታ ኮችንከሶ፥ ኮና ሙዳ Ꮊድን ጉርምና እምምሳንዳ ዎካንታ ማቻንኦል ዋሄንምኬ አያንን ቱና ማዝድን Ꮊራ ሪዘንከረ ዎንታ ማተን ዎ ጭልሳ፥ ሳብመረ ጳስካ ሳብካንታ ዎንታ ፋስምና ቦድማ ማድንግንዳ ዎ ይያ። ");
INSERT INTO gyl_vpl VALUES ("C27_2","077_7_2","2CO","7","2","2","የንታ ቡዳርንካ ዎም ሞከቴ፥ ዎታ Ꮊይመነረ ዳቀልሳኮቴ፥ Ꮊይመነረ ኡፈልሳኮቴ፥ Ꮊይመንመረ ዎንታ ማታካንታ መይድንግንዳ ይያኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_3","077_7_3","2CO","7","3","3","ኮመረ እ ጋይድንዳ የንዘን ፋረድካንታ ካዬ። ኮታ ኤና እሪ የካንታ እ ኬዛንግንዳ የታ ዎንታ ቡዳር ዶቅደቴ፥ ኮካንታ ዶቅንተከረ ማታ ደእከረ ሙዳᎺይካ የንዘንካ ፋስምዳኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_4","077_7_4","2CO","7","4","4","የንታዘን እስታ ዶቅድንዳ አሜንና አንድሬ፥ የንታዘን እስታ ዶቅድን ጬቅና አኬ፥ የንከረ ዳቅድቴ፥ ዎንታ ማጣ ሙደንካ አንድርካ ጉርምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_5","077_7_5","2CO","7","5","5","መቅዶና ፍጨናር ዎ የልሳንደትካ ዎራ በድ ፍነንካ ማጣ ዎም የልሳ ዳት Ꮊረነረ Ꮊዉስ Ꮊፋኮቴ፥ ማልጎካ ዋጭማ ኤርጎካ ጳስ ዎንዘን Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("C27_6","077_7_6","2CO","7","6","6","ኬዛርንካ ማቼ ቶችምስባብከስም ዳቅዝድባብ ጮይስና ቲቶታ Ꮊድንተንካ ዎም ዳቅስቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_7","077_7_7","2CO","7","7","7","ዎ ዳቅሳንደረ ክታ Ꮊድንተንካ Ꮊክ ማታክናና የታ ክትም ዳቅስባከስ ማትንተን ዎንታ ኤስርንተንከረ ዋሬ፥ እካንታ የንታ ዶቅድን ሱነከ ሞርእን የንታ ኦይምንመረ ዎካንታ ክት ኬዛንደትካ ስግ ዎም ጉርምሴ። ");
INSERT INTO gyl_vpl VALUES ("C27_8","077_7_8","2CO","7","8","8","ኮታ እሪ የካንታ እ ጻፍሳንዳ ክተና የም ሞርእዝድንዳ ማቼረ ዎራ ክቴን እስታ ጻፍንካ ኡቁምዳክቴ፥ እ ኡቁምሳናነረ ዎራ እ ኡቁምሳን እስታ ክቴና ቶክምካ የም ሞርእሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_9","077_7_9","2CO","7","9","9","ታ ማቼ እም ጉርምስቴ፥ እም ጉርምሳን ጎግና የም እ ሞርእሳንካንታ ማታክናና የንታ ሞርእንጎካ ጎማ የንታ ፍክስን ዎይስሰቶ የንታ ኦክምንኬ፥ ይና የንታ ሞርእና ሳብታ ጋይተንግንዳ ማቻንጎካ ዎታ የም Ꮊረነረ የም ዳቀልሳኮቴ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("C27_10","077_7_10","2CO","7","10","10","ሳብታ ጋይተንግንዳ ማድንዳ ሞርእና ኦስ አቅንተደር ጎርዝድንዳ ጎማ ፍክስን ዎይስካ Ꮊፈርድን ኦክምን Ꮊፍዝድን ኦል ኡቁምስዝዳክዬ፥ ኮ ፍጫሙደንዘን ዶቅድን ሞርእና ማቼ ደእንም ተይᎺዴ። ");
INSERT INTO gyl_vpl VALUES ("C27_11","077_7_11","2CO","7","11","11","ኮና የንታ ሞርእና ሳብታ ጋይተካ ማትና Ꮊስግንዳ ዶቅድን ዎንዘን የልዳክንግንዳ ማስን እምካንታ፥ Ꮊስግንዳ ዶቅድን ሳነካ ዋጭን፥ Ꮊስግንዳ ዶቅድን ጳስን፥ Ꮊስግንዳ ዶቅድን ሱነም፥ Ꮊስግንዳ ዶቅድን ቀምስምን፥ Ꮊስግንዳ ዶቅድን ዋጭንመረ ተይᎺዳንደትም ቡደርሶ ገቀርከቴ። የታ ጉጅሶ ሙዳ ርከረ የም ኦይስዝድ ሪያርንካ ባዛካይሳ የንታ ማትንተን የታ ማርከርስተቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_12","077_7_12","2CO","7","12","12","ኮካንታ Ꮊረነረ ዎራ የካንታ እ ጻፍሴ እ የካንታ ጻፍሳንዳ ዎካንታ የንታ ዶቅድን ዳቅና ሳብታ እሪ የካንታ መያ ማድንግንዳ ጋይስቶ ዳት ዳቀልስ ፍክስባብካንተኬ ዳቀልስ ክታዘን ቦድምስባብ ኤድጎካ ጋይስቶ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C27_13","077_7_13","2CO","7","13","13","ዎ ዳቅሳንደዘንከረ ስግ ቲቶ Ꮊፍሳን ጉርምንካ ስግስሶ ጉርምቶቴ፥ ዎ ጉርምሳንደረ የታ ሙደና ትቶም የ ዳቅሳንካንተኬ ክታ አያንን የ ኡክንሳንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("C27_14","077_7_14","2CO","7","14","14","የንካ እስታ ዶቅድንደትም ጬቅን ቲቶካንታ ከስትት ዶቆ፥ የተረ እም ኦስንሳከቴ፥ ሙዳᎺይከረ ዶፈንን የም ከዝድ Ꮊቆቴ፥ ኮነረ የጎካ ቲቶካንታ ዎ ኬዛን ጬቅና ዶፈን ማትንተካ መያ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("C27_15","077_7_15","2CO","7","15","15","የታ ሙደነረ ክትምድባብከስ የ ማቻንግንዳ ጳስከ ጭጭከረ ክትም የ ሞክሳንግንዳ ትቶ ገቀርድንካ፥ የካንታ ክታ ዶቅድን ሶልመና አንድር በድዬ። ");
INSERT INTO gyl_vpl VALUES ("C27_16","077_7_16","2CO","7","16","16","እተረ ሙዳ ጎግካ የንካ አሜንምካንታ እስታ ማትንተንካ ስግሶ እም ጉርምስቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_1","077_8_1","2CO","8","1","1","እስታ እስመንከስኬ ምችነንከሶ! ሳብ መቅዶና ፍጨናር ዶቅድባብ Ꮊክ Ꮊክ ምክስ ኤሄናር ኤድንከስ እምሳን ዉች እምንተን የ ኤዝድንግንዳ ሶልምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_2","077_8_2","2CO","8","2","2","ኬታ በድ ማጠካ ጰጭምተኬ፥ ማታጋካ ዳት ኬታ ጉርምና አንድሬ፥ አንድር ሪካየንባብከስ ከት ማቼረ ዎራ አንድር ማቻን ቡዳርንካ እምንተን እምተኬ። ");
INSERT INTO gyl_vpl VALUES ("C28_3","077_8_3","2CO","8","3","3","ከደር ማድንከከኬ ከደር ማድንደትዘንከረ ስግስሶ ኬታ ይ ገቀርሳንደትም እምሳንግንዳ እታ ከትካንታ ማርከርድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C28_4","077_8_4","2CO","8","4","4","ይሁዳ ፍጨናር ዶቅድን አሜንድባብከስም አሌን እመርድንዳ ኬታዘንካ ነግምዳክንግንዳ ዳቅስሶ ዎም ምክሰኬ፥ ");
INSERT INTO gyl_vpl VALUES ("C28_5","077_8_5","2CO","8","5","5","ኬት ይሳንዳ ዎ ካርሳንደትዘንካ ስግዬ፥ እሪምሶ ከታ ይንታ ማተንም ጮይስካንታ እምሰኬ፥ ኮታዘንከረ ሳብታ ጋይተካ ከታ ይንታ ማተን ዎካንታ እምተኬ። ");
INSERT INTO gyl_vpl VALUES ("C28_6","077_8_6","2CO","8","6","6","ኮም ፍክስን እርምሶ የጅባብ ትቶ ማቻንካንታ ታየረ ኮትኮም ቡዳርንካ እምንታ ፍክስን ቦድንታ የልዝድንግንዳ ክትም ምክስቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_7","077_8_7","2CO","8","7","7","የታ አሜንካ፥ ኬዝካ፥ ኤሰካ፥ ዳቅንተካ፥ ዎካንተረ የንታ ዶቅድን ሶልመካ ሙዳ ርይካ ስገደቴ፥ ኮ ቡዳርንካ እምንታ ፍክስንከረ የ ስገድንግንዳ ማታ። ");
INSERT INTO gyl_vpl VALUES ("C28_8","077_8_8","2CO","8","8","8","ይና፥ ኮም እ የም ጋይድንዳ ክተካ ካዬ፥ ኬዛር ማቼ አብንከስታ እምንተታ ዳቅንተን የንታ ዳቅንተካ ክክን የክስካ የንታ ሶልመንታ ዶፈንን ኤስካንታ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_9","077_8_9","2CO","8","9","9","የታ ዎንታ ጮይስን የሱስ ክርስቶሰታ ዉች እምንተን የታ ኤዝደቴ፥ ኖ ክርስቶስ Ꮊረነረ ዎራ ቆልመካ ማቼረ ክትካ ሪ ካየንባብ ማትና የታ አና ቆልመካ ማተርንግንዳ የካንታ ጋይሶ ኖ ሪ ካየንባብ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("C28_10","077_8_10","2CO","8","10","10","ኮርንጎካ የካንታ ኡርመም ካምሶ እካንታ Ꮊፈርሳን ዞረን የካንታ እምድቴ፥ ስገዳን ስለናር እማካንታ Ꮊክ ማታክናና ኮም ይካንታ እርምሶ ዝግዝባብከስ የታ Ꮊቀቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_11","077_8_11","2CO","8","11","11","ኮካንታ የ እምካንታ ገቀርሳን ገቅርና ፍክስዘን Ꮊቅሶ ቦድንተዘን የልድን ግንዳ የ ጋይሳን ከካ የ ገቀርሳን ኮትም ታ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_12","077_8_12","2CO","8","12","12","እማካንታ ኡርማ የስታ ገቅር ዶቅሴ ኤድ ቡዳርንካ እምድንደና ዝግዝድንዳ ካምሶ Ꮊፈርድንደና ይንታ ዶቅድን ከካ እምድንካ ዳት ይንታ ካየንደትዘንካ እምድንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C28_13","077_8_13","2CO","8","13","13","ኮመረ እ ጋይድንካ የታ ሙደነረ የካ የ ማድንግንዳ ዳት የታ እምንተካ የ ማጠርድንካ አብንከስ Ꮊዉዝድን ግንዳ ጋይስቶ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C28_14","077_8_14","2CO","8","14","14","የ ማጠርድንደት Ꮊይካ ከታ ቆልመና የንታ ማጣካንታ Ꮊቅድን ግንዳ ታ የንታ ቆልመና ከታ ማጠንካንታ Ꮊቃ፥ ኮግንደካ የንታ ዎክያር የካ ማትንታ ዶቅተሬ። ");
INSERT INTO gyl_vpl VALUES ("C28_15","077_8_15","2CO","8","15","15","ኮነረ፦ “በድ ሳንስባብካንተረ ና ክትካንታ ስጣክዬ፥ መርሰን ሳንስባብካንተረ ና ክትካንታ ዞገራክዬ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C28_16","077_8_16","2CO","8","16","16","እታ የካንታ እ ገቀርድንደትከካ ቲቶረ የካንታ ይንታ ቡዳርንካ ክት ገቀርድንግንዳ ይስባብ ጮይስ ጋለትማ። ");
INSERT INTO gyl_vpl VALUES ("C28_17","077_8_17","2CO","8","17","17","ትቶ የንደር ክት Ꮊድንዳ ይንታ ገቅርካ አምሶ ጉርምካ ዳት ዎታ ክትም ምክሳን ካንታ Ꮊክ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C28_18","077_8_18","2CO","8","18","18","ክላ ኬዘን ክታ ሳባክንካ Ꮊክ Ꮊክ ምክስ ኤሄናር ሙዳ አንጅምስባብ እስመንም ክትካ ክክን ኦይቶሮቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_19","077_8_19","2CO","8","19","19","ኮዘንከረ ስግ ኮና እስመና ዎታ ኮኡርማ ፍክስን ጮይስታ ቦንቻካንታ ዎ ቦድንከ ፍክስካንታ ዎንታ ዶቅድን ኡርማ ገቅርን ዎ መያ ማዝድንካ ዎንካ የካ አየሮ ፍግዝድባብ ማድንግንዳ Ꮊክ Ꮊክ ምክስ ኤሄናርንካ እድምስባቤ። ");
INSERT INTO gyl_vpl VALUES ("C28_20","077_8_20","2CO","8","20","20","ኮም ቡዳርንካ እምምሳን ብረን ዎ ገችዝድንካ Ꮊረሰነረ ይንኤር ዎንዘን የልዳክንግንዳ ካርስምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_21","077_8_21","2CO","8","21","21","ዎንታ ገቅርና ጮይስታ እሪ Ꮊክ ማታክናና ኤድንከስተረ እሪ ኡርማ ማቻን ሪም ይንቴ። ");
INSERT INTO gyl_vpl VALUES ("C28_22","077_8_22","2CO","8","22","22","በድᎺይካ በድ ጎካ ጰጭምሶ ዳቅማ ማትሶ Ꮊፈርስባብ ዎንታ እስመንም ቲቶ ከስካክክን ዎ ኦይችባበረ ኮትኮጎኬ፥ ኖ የንታዘን ክታ ዶቅድን አሜንና አንድርይ ማቻንካንታ ታ ኮ ፍክስንካ አላካንታ ክታ ዶቅድን ዳቅና ሙዳᎺይካ ስግዳንዴ። ");
INSERT INTO gyl_vpl VALUES ("C28_23","077_8_23","2CO","8","23","23","ቲቶ ጎካ ኤስ ዝክሴ የም አላካንታ እንካ የካ ፍግዝድባብ እስታ ፍክስታ ላኮይቴ፥ ክትካ ክክን Ꮊድባብ አብን እስመንከስጎካ ማቻንዳ ማቼ ከታ Ꮊክ Ꮊክ ምክስ ኤሄንከስታ ካርያር ማድባብ ክርስቶስታ ቦንቼንካንታ ዎእስባበኬ። ");
INSERT INTO gyl_vpl VALUES ("C28_24","077_8_24","2CO","8","24","24","ኮካንታ የንታ ሶልመን ከትካንታ መያ ማስስከቴ፥ ኮግንደካ ዎንታ ሶልመንኬ የንዘን ዎንታ ዶቅድን ጬቅና ዉችኩን ማታክንደትም Ꮊክ Ꮊክ ምክስ ኤሄንከስካንታ ሙዳ ሰጅደቴ። ");
INSERT INTO gyl_vpl VALUES ("C29_1","077_9_1","2CO","9","1","1","ይሁዳ ፍጨናር ዶቅድባብ አሜንድባብከስካንታ ይይምድን ዉቸንጎካ እ ጻብድንግንዳ የካንታ ዝክሳዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C29_2","077_9_2","2CO","9","2","2","“አካያ ፍጫ ኤድንከስ ስገዳን ስለንዘንካ የድሶ አላካንታ ግግምስባብከሰኬ” ጋይስቶ መቅዶና ፍጫ ኤድንከዝደር የጎካ እ ጋይርድንዳ የንታ ዳቅንተን እ ኤዝድንካንቴ፥ የንተረ ዳቅንተና አብንከስም አምስስቴ። ");
INSERT INTO gyl_vpl VALUES ("C29_3","077_9_3","2CO","9","3","3","ኮ ሪንካ የንታዘን ዎንታ ዶቅድንዳ ጬቅና ዉች ማትሶ ነጋይንግንዳ ኬና እስመንከስም ኦይድቴ፥ የተረ ገታ እታ ኮታ እሪ እ ኦይቻንግንዳ ግግምሶ ካርስከቴ። ");
INSERT INTO gyl_vpl VALUES ("C29_4","077_9_4","2CO","9","4","4","መቀዶንያ ኤድንከስ እንካ ክክን የንደር Ꮊድሶ ግግማክባብ ማትሶ የ ዶቅድንካ የም Ꮊፍሴ የንካ ዎንታ ጋይርንካ ኦስንዶቴ፥ የታ ማቼ እንድንካ ኦስንደቴ። ");
INSERT INTO gyl_vpl VALUES ("C29_5","077_9_5","2CO","9","5","5","ኮካንታ እምካንታ የ ጋይሳን ቡዳርንካ እምንተን እሪናና የ ግግዝድን ግንዳ የም ገቀርዝድንግንዳ ጋይንተካ ኬና እስመንከስ እዘንካ እሪምሶ የንደር ኬት Ꮊድንግንዳ ይይንተና ዝግዝድንዳ ማቻንኦል፥ ኮግንደካ እ ᎺድንᎺይካ ቡዳርንካ የንታ እምንተና ግግምሳንዳ ማዴ፥ የተረ የ እምድንዳ ሶልማክሳ ማታክናና የንታ ቡዳርንካ ማትንተንም ሰጅዴ። ");
INSERT INTO gyl_vpl VALUES ("C29_6","077_9_6","2CO","9","6","6","“ቶክም ማስባብ ቶክምካ ስክዴ፥ በድ ማስባብ በድካ ስክዴ” ጋይድንደትም ጋይተን ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("C29_7","077_9_7","2CO","9","7","7","ኮካንታ ሳብ ሶልምድንዳ ጉርምካ እምድባብ ኤድም ማቻንካንታ ዋልቃ ዋልቀና እማካንታ ይዝግዛንደትም ይንታ ቡዳር ጋይሶ ጉርምካ እማ ዳት እምትቶ ነክትቶ ጋየሮ ሶልማክ ዶቆ Ꮊይ እማ። ");
INSERT INTO gyl_vpl VALUES ("C29_8","077_9_8","2CO","9","8","8","ሙዳᎺይካ ሙዳ ሪካ የንታ ማተንካንታ ማድባብ ማትሰቶ ኡርማ ፍክስዘን ሙዳ Ꮊቅስካንታ የም ማተርንግንዳ ሳብ በድካ ይንታ አንጀንም የካንታ እምተሬ። ");
INSERT INTO gyl_vpl VALUES ("C29_9","077_9_9","2CO","9","9","9","ኮነረ፥ “ሪካየንባብከስካንታ ቡዳርንካ እምሴ፥ ክታ ጭለትቼነረ ስለንክንደታ ዶቅተሬ” ጋይምሶ ጻፍምሳን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C29_10","077_9_10","2CO","9","10","10","ማዝድባብካንታ ማሰንም፥ እችምካንታ ሶለንም እምድባብ ጮይስ የ ማዝድን ማሰን በችሶ የካንታ እምዴ፥ የንታ ቡዳርንካ እምንተንታ አፍን የካንታ በችስተሬ። ");
INSERT INTO gyl_vpl VALUES ("C29_11","077_9_11","2CO","9","11","11","የንታ ቡዳርንካ እምንተና ዎጎካ ከትም የልድን ኤድንከስ ሙዳ ሳብም ጋለተርንግንዳ ሙዳᎺይካ ቡዳርንካ የ እምድንግንዳ ሳብ ሙዳ ሪካ የም ቆልማባብ ማስተሬ። ");
INSERT INTO gyl_vpl VALUES ("C29_12","077_9_12","2CO","9","12","12","ኮና የ ቦድንዳ ቡዳርንካ እምንታ ፍክስና አሜንድባብከስም ማጠናርንካ ዉችዘንከረ ስግ ኤድንከስ ሳብካንታ በድ ጋለቻን እምድንግንዳ ከትም ይስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C29_13","077_9_13","2CO","9","13","13","ኮና የንታ ቡዳርንካ እምንታ ፍክስና የታ ክርስቶሰታ ክላ ኬዘንም ኤሰርሰቶ አሜንምስባብከስ የንታ ማትንተን ከትካንተከ አብንከስካንተረ የንታ ቡዳርንካ እምንተን መያ ማስዝድንዳ ማቻን ካንታ ሙደነረ ሳብም ጋለደኬ። ");
INSERT INTO gyl_vpl VALUES ("C29_14","077_9_14","2CO","9","14","14","ከተረ ሳብ የካንታ እምሳንዳ ስግ ማቻንጎካ የም ከት ሶልምድንካንታ የካንታ ምግዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("C29_15","077_9_15","2CO","9","15","15","ኤታ ኬዝካ ከስት በይስምዳክን ዉች ክታ እምንተንጎካ ሳብ ጋለትማ። ");
INSERT INTO gyl_vpl VALUES ("C210_1","077_10_1","2CO","10","1","1","እታ ጳውሎስ የንታ እሪ እ ዶቅድንካ ማታ ይንታ ይርክሳ ይድባብ ጋይምስቴ፥ የንዘንካ እ ጎተርድንካ ማቼ የንዘን ሙቅምባብ ጋይምስቴ፥ ክርስቶሰታ Ꮊልስምናርንኬ ላቅምናር እታ የም ምግዝድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C210_2","077_10_2","2CO","10","2","2","እ የም ምግዝድንደረ የንደር እ Ꮊድንደት Ꮊይካ ሙቅምካ እ ኬዝድንግንዳ የ ይያባብካይሴ፥ ዋሄታ ገቅርካ ዎ ኦንግድንደትግንዳ ማስሶ ሰድን ዋልቃ ዋልቃ ኤድንከስታ እሪ ሙቅምካ ኬዛካንታ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_3","077_10_3","2CO","10","3","3","Ꮊረነረ ዎራ ፍጫሙደንዘን ዎ ዶቅሰረ ዎዳምድንዳ ፍጫሙደንታ ዳምና ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C210_4","077_10_4","2CO","10","4","4","ዎንታ ዳምይ ካችምንከሰረ ዳምንጎካ ጋይሶ ሰይንካ ኡርሰርሳን ጋስን ዉልእካንታ ማስዝድንዳ ሳብታ ዎልቃ ዶቅድባብከስ ዳት ኮ ፍጫሙደንታ ዳምይ ካችምንከስ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C210_5","077_10_5","2CO","10","5","5","ሳብም ኤስንታ ዘን ጎሀ ማትሰኮ አምድን ቤርምከ ኦትረም ዉልእዶቴ፥ ኤድተረ ገቅርንም ሙዳ ፈንክ ማሰሮቶ ክርስቶስካንታ ክትምድንግንዳ ይዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_6","077_10_6","2CO","10","6","6","የንታ ክትምና ቦድማ ማድንካ Ꮊምንመረ ክትምክሳ ነግንም ዋጭካንታ ግግምስባብ ማዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_7","077_10_7","2CO","10","7","7","የ ሰድንደና ማልጎካ Ꮊፈርድን ርም Ꮊክዬ፥ Ꮊየነረ ኤድ እታ ክርስቶሰትተ ጋይሶ ክት አሜንምሰ ካርንካ ክት ገቅራ፥ ዎተረ ክትግንዳ ክርስቶስታ ዎንታ ማትንተን ክት ገቅራ። ");
INSERT INTO gyl_vpl VALUES ("C210_8","077_10_8","2CO","10","8","8","ጮይስ ዎካንታ እምሳን ገችታ ኤረንካ አንድር እ ጋይርሰረ እታ ክትካ ኦስናይቴ፥ ኮና ገችታ ኤረና ዎካንታ እምምሳንዳ የም ዎይስካንታ ዳት ዉልእካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C210_9","077_10_9","2CO","10","9","9","እስታ ክተንከስካ የም እ ጳስዝድንዳ Ꮊይካማ። ");
INSERT INTO gyl_vpl VALUES ("C210_10","077_10_10","2CO","10","10","10","Ꮊረንግርካ ዋልቃ ዋልቀንከስ “ጳውሎሰታ ክተንከስ ደጭመኬ ዳቅመኬ፥ ኖይንታ ማታርንካ ዎንካ ክክን ማድንካ ማቼ ኖ ጋፍስባቤ፥ ክታ ኬዘነረ ቶችምምሳንዴ” ጋይደክ ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("C210_11","077_10_11","2CO","10","11","11","ኮም ጋይድን ኤድንከስ ዎታ ጎትካ ማትሶቶ ዎንታ ክተንከስካ ዎ ጻብድንደትኬ ቅንችከረ የንካ ክክን ማትሶቶ ዎ ፍግዝድንደታ ዎክያር Ꮊረነረ ፋስም ካየንደትም ከት ገቅራ። ");
INSERT INTO gyl_vpl VALUES ("C210_12","077_10_12","2CO","10","12","12","ማታጋካ ዳት ኬታ ይንታ ማተንም ጎፍዝድን ዋልቃ ዋልቃ ኤድንከስካ ክክን ዎንታ ማተንም የክስካንታ ናንከረ አና ዎንታ ማተን የርክስካንታ ጉራዮቴ፥ ኬታ ማቼ ይንታ ማተንም ይካችካ የርክስንከ ኬታ ይንታ ማተን ይካችካ የክስንካ ገቀርት ተይድባብከስ ካየኬ። ");
INSERT INTO gyl_vpl VALUES ("C210_13","077_10_13","2CO","10","13","13","ዎታ ማቼ የንደር ዎ የልተሪን የለልታ ዎራ ሳብ ዎካንታ እምሳን ፍክስንታ ጋይርዶት ዳት ዝግዝድንደትዘንካ ስግ ጋየርድባብ ካዮቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_14","077_10_14","2CO","10","14","14","የተረ የ ዶቅድንዳ ዎንታ ፍክስን ኮታር የ ማቻንካንታ ክርስቶሰታ ክላ ኬዘንም ኤስስካንታ የንደር ዎ ᎺዳንደትᎺይካ ፍክስንኮታ ገረንዘንካ ስጋኮቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_15","077_10_15","2CO","10","15","15","ኮካንታ ሳብ ዎካንታ ጋይሳን ገረንዘንካ ስግሶቶ አብንባብከስታ ፍክስንካ ዎታ ጋየራዮቴ፥ ስግስሰረ የንታ አሜንና ጋጵድንግንደከ ዎንተረ ፍክስና ሳብ ዎካንታ ጋይሳን ገረን ግርዳ የንታ ዎክያር ስግሶ ዳልግድንግንዳ ጉርም ይዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_16","077_10_16","2CO","10","16","16","ይና አብ ኤታ ፍክስንታ ገራር አርድሶቶ እሪምሶ ፍክስምሳን ፍክስካ ጋየራኮት ዶቆ የንዘንካ ኦስ ዶቅድን ፍጨንከሳር ክላ ኬዘንም ኤስምስካንታ ማዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C210_17","077_10_17","2CO","10","17","17","ኬዛር ማቼ “ጋየርድባብ ጮይስካ ጋይራ”። ");
INSERT INTO gyl_vpl VALUES ("C210_18","077_10_18","2CO","10","18","18","ኤድ ጎፍስምካንታ ማድንዳ ጮይስ ክትም ጎብዝድንካ ዳት ይንታ ማተንም ይንት ጎብዝድንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C211_1","077_11_1","2CO","11","1","1","ቶክም እስታ ዳችርን የ እም ዳንዳእተርንደትም ጉርም ይድቴ፥ ዋደቴ እም ዳንዳእከቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_2","077_11_2","2CO","11","2","2","ዋልቃ ይንቼን አንጃ ሙነክንዳ ዋልቃ አⷝናካንታ ሶርምድንግንዳ እተረ የም ክርስቶስካንታ እ ሶርሳንጎካ አያናር ማችሶ ጋይስቶ የካንታ ገቀርድቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_3","077_11_3","2CO","11","3","3","ጉንና ሄዋነትም ይንታ ጩበንካ ኮተርሳንግንዳ Ꮊረንግርካ የንተረ ገቅርና ባድሶ ክርስቶስካንታ የንታ ዶቅድን ሉለከከ ጭለጭል ማቻን የንታ አሜንምን ዛቅተሬ ጋይስቶ እታ ጳዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_4","077_11_4","2CO","11","4","4","ዋልቃ ኤድ የንደር Ꮊድሶ ዎ ሳባክሳንደትም ማታክናና አብ የሱስ ጋይሶ የካንታ ክት ሳባክሴ አነረ የተያን አያንን ማታክናና አብ አያንን የ ተዬ፥ አነረ የተያን ክላ ኬዘንም ማታክናና አብ ክላ ኬዘንም የ ተይዴ፥ ጫምን ጋይሰቶ ስግዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_5","077_11_5","2CO","11","5","5","ኬዛር ማቼ እታ ከትኬና አንድር ኦይትምስባብከዘንካ Ꮊራርከረ እታ ቶግድባብ ካይቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_6","077_11_6","2CO","11","6","6","ኬዝካ ሩርምባብ እ ማታክባብ ማቸረ ዎራ እስታ ኤስና እዘንካ ዞገራዬ፥ ኮመረ በድᎺይካ በድ ጎግካ መየካ የንታ ቡዳር አርድንግንዳ ይቶቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_7","077_11_7","2CO","11","7","7","እታ ሳብታ ክላ ኬዘን ናክካይሳ የካንታ እስታ ሳባክንከ የም ጬክሳ ይካንታ እስታ ማተንም ቶችና Ꮊረንግርካ ጎማግንዳ እዘን ፋይድምታ ዳቶ? ");
INSERT INTO gyl_vpl VALUES ("C211_8","077_11_8","2CO","11","8","8","የካንታ ፍግዝድቴ ጋይስቶ አብ Ꮊክ Ꮊክ ምክስ ኤሄናርንካ አለንም ተይትቴ፥ ና ኮነረ ከትም ቡረም ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("C211_9","077_11_9","2CO","11","9","9","የንካ ክክን ዶቅድቶ ማጣ እዘን የልሳን Ꮊይካ መቅዶንያ ፍጨናርንካ Ꮊድባብ እስመንከስ እም ዝግዝድ ሪ ሙደንካ እካንታ አለንም አልድዮ ከትᎺቃንካንታ Ꮊየንካንተረ ባላ ማታክቴ፥ ታ የለልታ የንዘን Ꮊራርከረ ባላ ማታክቴ፥ ኦስ እርንካንተረ ባላ የንዘን ማታይቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_10","077_11_10","2CO","11","10","10","ክርስቶስታ ዶፈንና እስታ ዋር ዶቅንተንካ እ ጬቅዳክንግንዳ እም ይስዝድንዳ አካያ ፍጨናር Ꮊየነረ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C211_11","077_11_11","2CO","11","11","11","Ꮊራካንተረ? እ የም ሶልምዳክንደትጎኮ? እ የም ሶልምድንደትም ሳብ ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C211_12","077_11_12","2CO","11","12","12","ከታኬና አብና ኦይትምስባብከስ “ዎተረ ከትግንዳ ፍግዝዶቴ” ጋየረኮ ከት ጋይርድን ጎግንም ካይስካንታ ታ እ ይድንደትም ኦስ እሪንካንተረ ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_13","077_11_13","2CO","11","13","13","ከት ኬናግንዳ ዶቅድባብ ኤድንከስ ክርስቶሰታ ኦይትምስባብከስም ካምካንታ ከታ ይንታ ማተንም ኦንግድባብ ካርከካ ኦይትምስባብከስከ ገስካ ፍክሳ ኦንግድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("C211_14","077_11_14","2CO","11","14","14","ኮነረ በርእስዝድን ሪ ካዬ፥ ሰጣን ዎራ ሳክመንታ ክታይንችም ካምካንታ ይንታ ማተንም ኦንግዴ። ");
INSERT INTO gyl_vpl VALUES ("C211_15","077_11_15","2CO","11","15","15","ኮካንታ ከታኬና ሰጣንታ ፍክስንባብከስ ጭለትቼንታ ፍክስንባብከስም ካምካንታ ኬታ ይንታ ማተንም ኦክስንከረ በርእሳዬ፥ በእንታዘነረ ኬታ ይንታ ፍክስንታ ናክንም Ꮊብደኬ። ");
INSERT INTO gyl_vpl VALUES ("C211_16","077_11_16","2CO","11","16","16","“Ꮊየን ኤድካንተረ እታ ዳቻ እ ማቻን Ꮊይካማ” ጋይስቶ ካርንካ ኬዝድቴ። ዳቻ እ ማትስቶ የንደር እ Ꮊፈርስንከረ ዎራ መራ እ ጬቅድንግንዳ ዳቻ እም ማስሰቶ ፋይድከቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_17","077_11_17","2CO","11","17","17","ኮግንደረ ጋይርካ እ ኬዝድንካ ና ኬዘና ጮይስታ ጋይተንግንዳ ማታክናና ዳቸንግንዳ ማትስቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_18","077_11_18","2CO","11","18","18","በድንከሰረ ዋሀ ሪካ ኬት ጋይርድንካንታ እተረ ጋይርድቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_19","077_11_19","2CO","11","19","19","የታ ገቀርት ተይድባብ የ ማቻንከካ ዳቼንከስም ጉርምካ ዳንዳእደቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_20","077_11_20","2CO","11","20","20","ኮትኮግንደረ Ꮊየነረ አይላግንዳ የም ማስሰረ፥ Ꮊየነረ የንታ ዶቅድንደትም ሙዳ ተየረ፥ Ꮊየነረ ይም መይድንግንዳ የም ማስሰረ፥ Ꮊየነረ የም ቶችሰረ፥ Ꮊየነረ የንታ አፍያር ጫቅሴ ዳንዳእደቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_21","077_11_21","2CO","11","21","21","እም ኦስንዝድንዳ ማቸረ ዎራ ኬና ሪንከስም ይይካንታ ዛብዝባብከስ ዎ ማታክንደትም የካንታ መያ ማዝድቴ፥ ኬዛር ማቼ Ꮊየነረ ጋይር ካንታ ማዴ እተረ ክትግንዳ ጋይርድቴ፥ ኮመረ እ ጋይድንዳ ታየረ ዳቼንግንዳ ማትስቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_22","077_11_22","2CO","11","22","22","ኬታ ዕብራውያን ኤደኮ? እተረ ዕብራውያን ኤድቴ፥ ኬታ እስራኤል ኤደኮ? እተረ እስራኤል ኤድቴ፥ ኬታ አብራሀመታ ሱሰኮ? እተረ አብራሀመታ ሱስቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_23","077_11_23","2CO","11","23","23","ኬታ ክርስቶስታ ፍክስን ባበኮ? እተረ ከታዘንካ ስግ ክርስቶሰታ ፍክስባብቴ፥ ኮመረ ጋይድቶ ዛዝርባብግንዳ ማትስቶ እ ኬዝድንዳ፥ ከታዘንካ ስግ በድᎺይካ ፍክስካ ጋፍትቴ፥ በድᎺይካ ዞከርትቴ፥ በድᎺይካ Ꮊርደርትቴ፥ በድᎺይካ እም ደይዝድ ሪይካንታ የልትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C211_24","077_11_24","2CO","11","24","24","ቦንደከ ታሜከ ሳክላ፥ ቦንደከ ታሜከ ሳክላ ዝራፍካ ዶንቅ ዱት አይሁድ ኤድንከስካ Ꮊርደርትቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C211_25","077_11_25","2CO","11","25","25","ማከንዱት ጉፈካ ጉጰርትቴ፥ ዋልቃዱት ሰይንካ አቀርትቴ፥ ማከንዱት ሎቀዘንካ ቃልዝድን ማርከብንታ ማጣ እም የልቴ፥ ዋልቃ ሰጫ ሶይትከ Ꮊየካ ባሀርናር Ꮊቃቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C211_26","077_11_26","2CO","11","26","26","እስታ በድ ጎግ ሙክንትንካ ሙሪግድን ሎቀተኬ ሳፍተካ፥ ፋንገንከዘንከረ ማጠና እም የልቴ፥ አይሁድ እስታ ኮችንከዘንኬ አይሁድ ማታክባብከዘንካ ማጣ እም የልቴ፥ ካተመናርንካ ዴል ቆቼናርንኬ ባሃርናርከረ ማጣ እም የልቴ፥ ኮትግንደረ ካርካ አመንድባብከዘንካ ማጣ እዘን የልቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_27","077_11_27","2CO","11","27","27","በድ ፍክስኬ ጋፍ እዘን Ꮊቄ፥ በድᎺይካ ግንአክቴ፥ ዳቅርኬ ሎቃ ዎጭካንታ ዎችርካ ማጠርትቴ፥ በድᎺይከረ እችም እካንታ ካይቴ፥ ቃዝርኬ ዘና ጫለንካ ማትንተረ እም የልቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_28","077_11_28","2CO","11","28","28","አብንመረ ሙዳ ሪ ፋይዳክትዶቆ Ꮊክ Ꮊክ ምክስ ኤህን ሙደንጎካ ሰጨን ሰጨንካ ገቀርካ ማጠርድ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("C211_29","077_11_29","2CO","11","29","29","ዋልቃ ኤድ ጋብድንካ እታ ክትካ የካ እ ጋፋክንዳ ሰጫ ዶቅዶ? ዋልቃ ኤድ ጎመካ ኮተርድንካ እ ሰነራክንዳ Ꮊንተረ? ");
INSERT INTO gyl_vpl VALUES ("C211_30","077_11_30","2CO","11","30","30","ጋይር ዝግዝድንዳ ማቼረ እ ጋየርድንዳ እ ጋፍስባብ ማትንተን ሰጅድን ሪንከስኬ። ");
INSERT INTO gyl_vpl VALUES ("C211_31","077_11_31","2CO","11","31","31","ስለንክንደታ ጋለትምስባብ ዎንታ ጮይስን የሱስ ክርስቶስታ ጮይስኬ ባቤን ሳብ እ ማልዳክንደትም ኤዝዴ። ");
INSERT INTO gyl_vpl VALUES ("C211_32","077_11_32","2CO","11","32","32","ደማስቆ ካተመናር እ Ꮊቃንደትካ ባንችን አረታስታ ታመካ ዶቅድባብ ፍጨንም ቆልድባብ እም የድካንታ ዝግሶ ካተመንታ ፉልተንከስም ካርዝድባብከስካ ካርስዝድ Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("C211_33","077_11_33","2CO","11","33","33","ኬዛር ማቼ ኤድንከስ ጋስንታ ማስኮትዘንጎካ ኩርኩርታ ዋር አርችተኮ ኬት እም Ꮊንችስንካ ክታ አንናርንካ ሱርችቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_1","077_12_1","2CO","12","1","1","Ꮊረነረ ዎራ ጋይርንካ መይድሪ Ꮊፈራክንዳ ማቼረ ጋይር ዝክሴ ጮይስ እካንታ እምሳን መያ ማትንከ ለምለም ጋይድንካ እስታ ሰድንካ ጋይርድቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_2","077_12_2","2CO","12","2","2","ክርስቶስታ ማችባብ ዋልቃ ኤድ ኤዝድቴ፥ ኖኮና ኤችና ታመኬ ኦይድ ስለታ እሪ ማክምስ ጭለን የለልታ ተይ አይምሴ፥ (ክት ተይ አይምሳንደረ ይንታ ዋሄንከረ ማታ ማትክሰረ ነጋ እታ ኤሳይቴ፥ ሳብ ኤዝዴ) ");
INSERT INTO gyl_vpl VALUES ("C212_3","077_12_3","2CO","12","3","3","ኬዛር ማቼ ኮና ኤችና አሜንሶ ደእስባብከስታ Ꮊዉስ ካርናር ተይምሳንግንዳ ኤዝድቴ፥ ኬዛር ማቼ ይንታ ዋሄንካ የከረ ማታ ማታክሰረ ነጋ እታ ኤሳይቴ፥ ሳብ ኤዝዴ፥ ");
INSERT INTO gyl_vpl VALUES ("C212_4","077_12_4","2CO","12","4","4","ኖ አሜንሶ ደእስባብከስታ Ꮊዉስ ካርናር አይሶ ኤታ ኬዘካ መያ ማትካንተኬ ኤድካ ኬዝምካንታ ማዳክንደት ሪም ኤሰርሴ። ");
INSERT INTO gyl_vpl VALUES ("C212_5","077_12_5","2CO","12","5","5","ኮግንዳ ዶቅድን ኤድካ ጋይርድቴ፥ እስታ ማተንካንታ ማቼ እስታ ጋፍንዘንካ አብ እ ጋይርድንዳ ሪ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C212_6","077_12_6","2CO","12","6","6","ይና፥ እታ ዶፈንን ከዝድንጎካ ጋይር እ ዝግዘረ ዳቻ ማታይቴ፥ ኬዛር ማቼ Ꮊየነረ እዘን ሰድንደትዘንከ እዘንካ ኤሰርድንዘንካ ስግ ካሪ ኬት እምዳክንግንዳ ጋይስቶ እስታ ጋይርንም ዛቅሳቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_7","077_12_7","2CO","12","7","7","ከትኬና እካንታ መያ ማችባብ አንድር ሪንከዘንካ አምሳንዳ እ ኦተርዳክንግንዳ እስታ ዋሄንም ጋል ግንዳ እግድን ማጣ እካንታ እምምሴ፥ ኮነረ ሰጣንታ ክታይንች ማትንተካ ቱንከሮ እም ማእስካ እ ኦተርዳክንግንዳ ይዴ። ");
INSERT INTO gyl_vpl VALUES ("C212_8","077_12_8","2CO","12","8","8","ኮና እም ማእዝድን ሪና እዘንካ Ꮊልእድንግንዳ ጮይስም ማከን ዱት ምክስቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_9","077_12_9","2CO","12","9","9","ኬዛር ማቼ ኖ “እስታ ዎልቀና ቦድማ ማትሶ መያ ማድንዳ የስታ ጋፍንካ ማቻንካንታ እስታ ዉች እምንተና የስም ማተሬ” እም ጋይሴ፥ ኮካንታ ክርስቶሰታ ዎልቀና እስታዘን ማተርንግንዳ Ꮊምን ሰጨዘንከረ ስግስሶ እስታ ጋፍንካ ጉርመርቶ ጋይር ካንታ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_10","077_12_10","2CO","12","10","10","ዎልቃ እ Ꮊብድንዳ ጋፍስባብ እ ማቻንደትᎺይካ ማቻንካንታ ክርስቶስጎካ እታ ጋብድቶ፥ የከርድቶ፥ ማጠርድቶ፥ ዳየርምድቶ፥ ኡንእምድቶ ጉርምድቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_11","077_12_11","2CO","12","11","11","ዳቸንግንዳ ኬዝቴ! ይና፥ ኩን እ ኬዝድንግንዳ እም ይስስባብ የተቴ፥ እም ቦንቻ ዝግዝድባብከስ የተቴ፥ እስታ ኤደትቸንካ ኤስማክባብ ኤድ እ ማችንከረ ዎራ አንድረከ ጋይምሶ ኦይትምስባብከሳርንካ Ꮊራርከረ እታ ቶካይቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_12","077_12_12","2CO","12","12","12","እታ ዶፈን ኦይትምስባብ ማትንተን የንታ ቡዳር አርድንግንዳ ይድን ሪንከስ እታ የንታ ዎክያር ዶቅድቶ ዳንዳእካ እ ቦዳᎺቃንዳ ፍክስንከሰ፥ ኬናከሰረ ቃዉተንከስ፥ በርእዝድን ሪንከስኬ አተንከሴ። ");
INSERT INTO gyl_vpl VALUES ("C212_13","077_12_13","2CO","12","13","13","የንታዘን ባላ ማታክት ዶቆ እስታ ነግንዘንካ አብ Ꮊክ Ꮊክ ምክስ ኤሄናር እ የም ቶክሳንዳ Ꮊረከረ? ኮነረ ባች ማትሶ ኮት ፋይድምሴ ነጋ እም ጋይከቴ! ");
INSERT INTO gyl_vpl VALUES ("C212_14","077_12_14","2CO","12","14","14","የንደር Ꮊድካንታ እ ግግምድንካ ታ እስታ ማክምስ ዱቴ፥ እታ የንዘን ባላ ማትካንታ ዝጋይቴ፥ እ ዝግድንዳ የም ዳት የንታ ብረንም ካዬ። ከታ ይንታ ይንችንከስካንታ ቆልማ ሳንስ ከትም ዝግዝድባብ አጥመንባብከስ ዳት ይንችንከስ አጥመንባብከስካንታ ቆልመን ሳንሳየኬ። ");
INSERT INTO gyl_vpl VALUES ("C212_15","077_12_15","2CO","12","15","15","የካንታ ዎራ እስታ ብረንም እስታ ማተንመረ ስክስት እ እምሰረ አንድር በድ እም ጉርምዝዴ፥ ይና እታ ኮከካ በችስቶ እ የም ሶልምድንካ የታ እም የሶልምድንደና ኮግንዳ ቶክምኮ? ");
INSERT INTO gyl_vpl VALUES ("C212_16","077_12_16","2CO","12","16","16","ማታጋካ ዳት ባላ የንታዘን ማታክቴ፥ ኬዛርንካ ማቼ ጩበኬ ገስካ እ የም የጃን ካምዴ። ");
INSERT INTO gyl_vpl VALUES ("C212_17","077_12_17","2CO","12","17","17","እ የካንታ ኦይችባብ ኤድንከሳርንካ ዋልቀንጎካ ዎራ እካንታ መይድንግንዳ ይስቶ? ");
INSERT INTO gyl_vpl VALUES ("C212_18","077_12_18","2CO","12","18","18","ቲቶ የንደር Ꮊድንግንዳ ክትም ምክስቴ፥ ኮ ዎንታ እስመንመረ ክትካ ክክን ኦይቻቴ፥ ይና ቲቶረ ይም መይድንግንዳ የንዘንካ ይይሶ? እንኬ ክትካ ዎ የካንታ ፍክሳንዳ ዋልቃ አያንካ ካዮ? ዎንታ ሙክንትና ዋልቃ ካዮ? ");
INSERT INTO gyl_vpl VALUES ("C212_19","077_12_19","2CO","12","19","19","የታ ሙደነረ ታ የለልታ የ ገቀርድንደና ዎታ የንታ እሪ ዎንታ ማተንዘን የልዳክንግንዳ ዎማርድን ካምስሰንት ሰጆ? ዎታ ክርስቶሳር ማትሶቶ ዎ ኬዝድንዳ ሳብታ እሪዬ፥ እስታ ገርነንከሶ! ዎታ ኮም ሙዳ ዎ ኬዝድንዳ የም ዎይስካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("C212_20","077_12_20","2CO","12","20","20","እታ ኦ ዋሪ ᎺድንደትᎺይካ Ꮊረንግርካ የ ማታባብ እ ዝግድንግንዳ የ ማታክሳ፥ እቴረ የ ዝግድንግንዳ ማታክሳ Ꮊፈርቴሮት ማተረ ጋይስቶ ጳዝድቴ፥ ኮትኮግንደረ የንደር ቴቺ፥ ቀምስ፥ ዋጭ፥ ይንታ ማተም ሶልማ፥ ኤታ ላም ካይስ፥ ካሪ ኬዛ፥ ኦትረኬ አዉል ዶቅዳ ማተሬ ጋይስቶ ጳዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C212_21","077_12_21","2CO","12","21","21","ካርንካ የንደር እ Ꮊድንካ እስታ ጮይስና Ꮊረንግርካ የንታ እሪ እም ቶችስተሬ ጋይስቶ ጳዝድቴ፥ ኮታ ኤና እሪ ጎማ ፍክስሰኮ ኮትኮ ኬታ ይ ፍክሳን ቱነንታ፥ ቤልምንተኬ አይተር ይንታ ማትንተንታ ጎማ ይንታ ፍክስን ዎይሳክን ኤድንከስካንታ ሞርእዘን እታ ዋጅድቴ ጋይስቶ ጳዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("C213_1","077_13_1","2CO","13","1","1","ይና የንደሪ እ Ꮊድንካ ኮና ማክምስዬ፥ ይና ሙዳ ሪ መያ ማድንዳ ቃስተንካ ናንከረ አና ማከን ማርከኬ። ");
INSERT INTO gyl_vpl VALUES ("C213_2","077_13_2","2CO","13","2","2","ቃስትምስ እ የም ሴታ Ꮊድንደትካ የንካ ክክን እ Ꮊቃንደትካ ካርስምከቴ ጋይስቶ ከዝትት ዶቆ፥ ታየረ ጉጅሶ ጎት ማትስቶ ኮታ ኤና እሪ ጎማ ፍክስባብከስካንተኬ አብንከስካንተረ ኤግዝምስካ ኬዝድቴ፥ ታ የንደር ማትስቶ እ ᎺድንᎺይካ Ꮊየንካንተረ አጨራይቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C213_3","077_13_3","2CO","13","3","3","ክርስቶስ እያር ገችሶ ኬዝድባብ ማትንተን የታ ኤስካንታ ዝግደቴ፥ የንደር Ꮊፈርድንደና ክታ ዎልቀና ዳት ክታ ጋፍና ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C213_4","077_13_4","2CO","13","4","4","ኖ ማዝቀልዘን ሮከርሶ ክት ደእሳንዳ ጋፍካ ማችንከረ ታ ሳብታ ዎልቀካ ሰንፔካ ዶቅዴ፥ ዎተረ ክትካ ክክን ጋፍስባብ ማቶቴ፥ የንካ ክክን ዎንታ ዶቅድን Ꮊፍርንካ ማቼ ክትካ ክክን ሳብታ ዎልቀካ ዎታ ዶቅቶሮቴ። ");
INSERT INTO gyl_vpl VALUES ("C213_5","077_13_5","2CO","13","5","5","የንታ አሜንካ ዳቅስባብ የንታ ማትንቴን ኤስካንታ የንታ ማተንም ሰድከቴ፥ የንታ ማተንም ጰጭከቴ፥ የሱስ ክርስቶስ የንታዋር ማትንቴን የታ ገቀራከቴ? ኮካያ ማቼ ጰጨንካ ዋችተት ጋይንትዬ፥ ");
INSERT INTO gyl_vpl VALUES ("C213_6","077_13_6","2CO","13","6","6","ዎታ ጰጨንካ ዎንታ ዋችክሳ ነግን የ ገቀርድንደትም Ꮊድን ጉርም ይዶቴ። ");
INSERT INTO gyl_vpl VALUES ("C213_7","077_13_7","2CO","13","7","7","ዳቅልሪ የ ይዳክንግንዳ ሳብደሪ ምግዝዶቴ፥ ዎ ምግዝድንደረ Ꮊረነረ ዎራ ዎታ ማድባብከስ ማትሶቶ ዎ Ꮊፈራክንዳ ማቼረ የታ ሙዳᎺይካ ኡርማ ማቻን ሪም የ ይድንግንዳ ዳት ዎታ ማድባብ ማትሶ Ꮊፍርን የም ሰችካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C213_8","077_13_8","2CO","13","8","8","ዎታ ዶፈንንካንታ ፍግዝዶት ዳት ዶፈን ማታክንደትም Ꮊራርየረ ዎታ ፍክሰራዬ። ");
INSERT INTO gyl_vpl VALUES ("C213_9","077_13_9","2CO","13","9","9","ዎታ ጋፍስባብ ማችንከረ የታ ዳቅመንከስ የ ማድንካ ዎም ጉርምዝዴ፥ ዎንታ ምክስና የ ቦድመንከስ ማተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("C213_10","077_13_10","2CO","13","10","10","ኮም ክቴን የንዘንካ ጎተርሶ ዶቅድቶ የካንታ እ ጻፍሳንዳ ኮጎኬ፥ ኮግንደካ የንደሪ እ ᎺድንᎺይካ ጮይሰረ እካንታ እምሳን ገችንታ ኤረንካ የም ማእሳይቴ፥ ጮይስ ገችንታ ኤረን እም እምሳንዳ የም ዎይስስካንታ ዳት የም ይጭ ካንታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("C213_11","077_13_11","2CO","13","11","11","ይና ኮዘንካ ኦስ ነገዳንደትካ እስታ እስመንንከስኬ ምችነንከሶ! ኡርማ ዶእከቴ! የንታ ዶቅንተን ኡርስከቴ፥ እስታ ዞረንም ጎርስምከቴ፥ ክክ ክክ ኤእከቴ፥ ሳራትቼከረ ዶእከቴ፥ ሶልመንተኬ ሳራትቼንታ ጮይስና የንካ ክክን ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("C213_12","077_13_12","2CO","13","12","12","ዶፈን ሶልመካ ክክ ሶንቀረቶ አቦ ጋይከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("C213_13","077_13_13","2CO","13","13","13","አሜንድባብከስ ሙደና የም አቦ ጋይደኬ። ");
INSERT INTO gyl_vpl VALUES ("C213_14","077_13_14","2CO","13","14","14","ጮይስ የሱስ ክርስቶስታ ዉች እምንተና፥ ሳብታ ሶልመና፥ አያን ጭልንታ ዋልቃትቼና የ ሙደንካ ክክን ማታ። ");
INSERT INTO gyl_vpl VALUES ("GL1_1","078_1_1","GAL","1","1","1","ኤድንከዘንካ ናንከረ ኤድጎካ ኦይትምሳንዳ ማታክናና፥ የሱስ ክርስቶሰም ደእናርንካ አምስስባብ ሳብባበንጎካ ኦይትምስባብ እ ጳውሎስዘንካ፥ ");
INSERT INTO gyl_vpl VALUES ("GL1_2","078_1_2","GAL","1","2","2","እንከረ ክክን ዶቅድባብ እስመንከስ ሙደንዘንካ ገላትያር Ꮊክ Ꮊክ ምክስ ኤሄንከስካንታ፥ ");
INSERT INTO gyl_vpl VALUES ("GL1_3","078_1_3","GAL","1","3","3","ዎንታ ባበን ሳብንዘንካ፥ ዎንታ ጮይስን የሱስ ክርስቶስዘንካ ዉች ክታ እምንተንከ ሳራትቸና የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("GL1_4","078_1_4","GAL","1","4","4","ዎንታ ጮይስንግንደከኬ ዎንታ ባቤን ሳብታ ገቅርንግንዳ፥ ኮ ፍጨዘን ዶቅድን ዳቅልንዘንካ ዎም አቅስካንታ ዎንታ ጎመንጎካ ይንታ ማተንም ስክስት እምሴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_5","078_1_5","GAL","1","5","5","ስለንክንደትዘንካ ስለንካ የለልታ ሳብካንታ ቦንቻ ማታ! አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("GL1_6","078_1_6","GAL","1","6","6","ክርስቶሰታ ዉች እምንተንካ የም ኤልስባብ ክትም ዛቅሰቶ አብ ክላ ኬዘንደር ኮግንደካ ጭጭሰቶ የንታ ማትና እም በርእስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_7","078_1_7","GAL","1","7","7","ዶፈን ማቼ አብ ክላ ኬዛ ካዬ። ማችንከረ የም ዳንድምዝድባብከስኬ ክርስቶሰታ ክላ ኬዘንም ዎፍስካንታ ጉርድባብ ዋልቃ ዋልቃ ኤድንከስ ዶቅደኬ። ");
INSERT INTO gyl_vpl VALUES ("GL1_8","078_1_8","GAL","1","8","8","ማታጋካ ዳት ዎታ ማቼረ፥ ጭላር ክታይንች ዎራ፥ የካንታ ከዘርሳን ክላ ኬዘናርንካ Ꮊክ ክላ ኬዘንም የካንታ ሳባግድባብ ኖ ባድምስባብ ማታጋካ! ");
INSERT INTO gyl_vpl VALUES ("GL1_9","078_1_9","GAL","1","9","9","እርምሶ ዎ ጋይሳንግንዳ ታየረ ጉጅስቶ ጋይድቴ፥ Ꮊየረ የ ኤሰርሳንደትዘንካ አብ Ꮊክ ክላ ኬዘን የካንታ ሳባግድባብ፥ ኖ ስለንክንደታ ባድምስባብ ማታ! ");
INSERT INTO gyl_vpl VALUES ("GL1_10","078_1_10","GAL","1","10","10","ታ እም ኡርሜ ጋይድንግንዳ እ ዝግድንዳ ኤታዝንኮ ሳብዘንኮ? አና እ ጉርድንዳ ኤድም ጉርምስካንቶ? ኤድም ጉርምስካንታ እ ጉርድንዳ ናና፥ ክርስቶሰታ ፍክስንባብ ማተራክት ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("GL1_11","078_1_11","GAL","1","11","11","እስታ እስመንከስኬ ምቺነንከሶ! የካንታ እ ሳባክሳን ክላ ኬዘን ኤድ ፍክሳንዳ ማታክንደትም የ ኤስተርንግንዳ ዝግድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_12","078_1_12","GAL","1","12","12","ኮም ክላ ኬዘን ኤድ Ꮊየንዘንከረ ተያክቴ፥ አነረ Ꮊየንዘንከረ ኤሳክቴ፥ ስግስሰረ የሱስ ክርስቶስ እካንታ መያ ማስስንካ ተያቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_13","078_1_13","GAL","1","13","13","እርምሰረ አይሁድንታ አሜንካ Ꮊስግንዳ እ ዶቅሳናንከረ፥ አመንድ ባብከስም Ꮊስግንዳ አንድሪ ከትም ዳየርቶ ካይስ ካንተረ Ꮊስግንዳ እ ጉርሳናንከረ የታ ኤሰርተቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_14","078_1_14","GAL","1","14","14","እስታ ስለናር ዶቅድባብ በድ አይሁድንከዘንካ ስግ አይሁድንከስታ አሜንካ ስግድባብ Ꮊቃቴ፥ ባበንከስታ ዎገንካንተረ አንድሪ ቀምዝድ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_15","078_1_15","GAL","1","15","15","ኬዛርንካ ማቼ፥ እስታ እንደንታ ሳቅምናርንካ የድሶ እም ፋስ ባብከ ይንታ ዉች እምንተንካ ኤልስባብ ሳብዬ። ");
INSERT INTO gyl_vpl VALUES ("GL1_16","078_1_16","GAL","1","16","16","አይሁድ ማታክባብከስታ ዎክያር ክትካንታ እ ሳባግድንግንዳ ሳብ ይንታ ይንችንም እንካ መይምስካንታ ይ ሶልምሳንደትካ Ꮊየንከረ ክክን ኖ ዞርማክዬ። ");
INSERT INTO gyl_vpl VALUES ("GL1_17","078_1_17","GAL","1","17","17","እስታ እሪ ኦይትምስባብከዝደር የሩሳሌም ካተመናረረ ዉታክቴ፥ ኬዛርንካ ማቼ ሳነካ አረብ ፍጫር አይሳቴ፥ ኮታ ቡረረ ደማስቃር ማቻቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_18","078_1_18","GAL","1","18","18","ኮታርከረ ማከን ስለታ ቡር፥ ጴጥሮሰም Ꮊፍካንተኬ ክትካ ኬዝምካንታ የሩሳሌም ካተመናር ዉተድቴ፥ ክትካ ክክነረ ታሜከ ዶንቅ ሰጫ ዶቅስቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_19","078_1_19","GAL","1","19","19","ኬዛርንካ ማቼ ጮይስ የሱሰታ እስመን ያይቆብዘንካ አብ ኦይትምስባብከሳርንካ Ꮊየንመረ ሰዳክቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_20","078_1_20","GAL","1","20","20","የካንታ እ ጻብድናር ሳብታ እሪ ማልት ኮት ማታይንደትም ዳቅስስቶ የክንታ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_21","078_1_21","GAL","1","21","21","ኮታ ቡር ሶርያ ፍጨናርኬ ኪልቅያ ፍጨናር አይሳቴ። ");
INSERT INTO gyl_vpl VALUES ("GL1_22","078_1_22","GAL","1","22","22","ክርስቶስካ አሜንድባብከስ ይሁዳ ፍጨናር ዶቅድባብ ኮታ ኤና እሪ እም ሰድሶ ኤዝዳከኬ። ");
INSERT INTO gyl_vpl VALUES ("GL1_23","078_1_23","GAL","1","23","23","ከታ ማቼ፥ “እርምሶ ዎም ዳያᎺቅባብ ኤችና፥ ኮታ ኤና እሪ ካይስካንታ ይ ዝጋᎺእቃን አሜንንም ኖ ሳባካ ዶቅዴ” ጋይድንደትም ኬዘንም ኤሰርድ Ꮊቀኬ፥ ");
INSERT INTO gyl_vpl VALUES ("GL1_24","078_1_24","GAL","1","24","24","እ ጳውሎስ ጎከረ ሳብም ቦንቸሮ Ꮊቀኬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_1","078_2_1","GAL","2","1","1","ታመኬ ኦይድ ስለታ ቡረረ አነታ ኦስ የሩሳሌም ካተመናር ዉተድቴ። ኮትኮᎺይካ ባርናባሰካ ክክን ቲቶከረ የካ አይሳቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_2","078_2_2","GAL","2","2","2","እ ኦስ አይሳንደረ ሳብ እካንታ መያ ማስሳንዘንካ አምሳንዴ። ኮታ ኤና እሪ እፍክሳንደረ ማታ ታ እ ፍግዝድንዳ ዉች ማትሶ ነጋይንግንዳ ጋይንተካ አይሁድ ማታክባብከስካንታ እሳባግድን ክላ ኬዘንም አንድር ማትሶ ዶቅድባብ ጎርዝድባብከስካንታ Ꮊክ ኤስምሳቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_3","078_2_3","GAL","2","3","3","እንካ ክክን Ꮊቅባብ ቲቶ ዎራ ግርክ ፍጫ ኤድ ማችንከሬ፥ ሶለንም ክት ተቸርድን ግንዳ ጋያከኬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_4","078_2_4","GAL","2","4","4","ኬዛርንካ ማቼ ዋልቃ ዋልቃ ካርከን ከዝድባብ እስመንንከስ ክርስቶስ የሱሳር ዎ Ꮊፍሳን ባዛካይሳ ዶቅንትን ጰጫካንተኬ አይላ ዎም ማስካንታ ፈንክ ዎንደር ላጵሶ ከታ አርድንተንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_5","078_2_5","GAL","2","5","5","ከትኬና ኤድንከስካንታ ዋልቃዱት ዎራ ቆልማኮቴ። ኮካንታ ክላ ኬዘንታ ዶፈንና የንካ ክክን ዳቅሶ ዶቅድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_6","078_2_6","GAL","2","6","6","ከታኬና ጎርስንባብከስም ካምሶ Ꮊፈርድን ኤድንከስታ ኤደትቸንጎካ እም ማእሳዬ፥ ሳብ ኤታ ባለን ሰድሶ ኦስናዬ፥ ከታከነረ ኤድንከስ እስታ ክተንዘን ኬት ጉጅሳንዳ ር ካዬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_7","078_2_7","GAL","2","7","7","ኬዛር ማቼ ጴጥሮስ አይሁድን ከስካንታ ክላ ኬዘን ክት ኬዝድንግንዳ ዋደ ጋይሶ ክትካንታ እምምሳንከካ፥ እተረ አይሁድ ማታክባብከስካንታ ክላ ኬዘን እ ኬዝድንግንዳ ዋደ ጋይሶ እካንታ እምምሳንደትም ገቀርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_8","078_2_8","GAL","2","8","8","ጴጥሮስ አይሁድንከስካንታ ኦይትምስባብ ማትሶ ክት ፍግዝድንግንዳ ይስስባብ ሳብ፥ እተረ አይሁድ ማታክባብከስካንታ ኦይትምስባብ ማትስቶ እ ፍግዝድንግንዳ ሳብ እም ማስቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_9","078_2_9","GAL","2","9","9","ኤሄታ ቱስግንዳ ፋይድምድባብከስ ያይቆብ፥ ጴጥሮስኬ ዮሀንሰካ እካንታ እምምሳን እምንተን ኬታ ይ ኤሳንደትካ፥ ኬታ ይንታ ዋልቃትቼን ሰችካንታ እካንተኬ ባርነባስካንታ ኬታ ይንታ ምዝ አንን እምስንካ የድምሶቴ። ኮታዘንከረ ዎታ ኦስ አይሁድ ማታክባብከዝደር፥ ከተረ አና ኦስ አይሁድንከዝደር አይድንግንዳ ኤእሰኬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_10","078_2_10","GAL","2","10","10","ዳቅስሶ ዋደ ዎም ከት ጋይሳንደና ሪካየንባብከስካንታ ዎንታ ገቅርን ዎዛቅዳክንግንዴ። እተረ ኮትኮም ይይካንታ አንግር እስታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_11","078_2_11","GAL","2","11","11","ጴጥሮስ አንጾክያ ካተመናር ክት Ꮊዳንደትካ፥ መየካ ኮትርሶ ክት Ꮊቃንካንታ መየካ ክትም ዋጫቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_12","078_2_12","GAL","2","12","12","ዋልቃ ዋልቃ ኤድንከስ ያይቆብታ ላማርንካ ኬት Ꮊተርንደታ እሪ አይሁድ ማታክባብከስካ የካ ኖ እጅድ Ꮊቄ፥ ኬት Ꮊዳንደታ ቡር ይንታ ሶለንም ተቸርስባብከስካንታ ጳስሶ አይሁድ ማታክባብከዘንካ ቡደካ ኖ ዶልእ የጄ። ");
INSERT INTO gyl_vpl VALUES ("GL2_13","078_2_13","GAL","2","13","13","ዋልቃ ዋልቃ አይሁድንከስታ ኮችናርንካ ማችባብ አሜንድባብከስ ዎራ ጴጥሮስታ አፈታ ገስንካ ጎርስምሰኬ፥ ባርናባስ ዎራ ነጋክ ዶቆ ክታ አፈንታ ገስንካ ጎርስምሴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_14","078_2_14","GAL","2","14","14","ኬታ ፍክስና ክላ ኬዘንታ ዶፈንንግንዳ ማታክንደትም እ ኤሳንደትካ፥ አንጾክያ ካተመናር ዶቅድን አመንድባብከስ ሙደንታ እሪ ጴጥሮስም፥ “የና አይሁድ ማትሶ ዶቅደዮ፥ አይሁድ ማታክባብከስታ ዎገናር ዳት አይሁድንከስታ ዎገናር ዶቅዳካዬ፥ ይና አይሁድ ማታክባብከስታ ዎገንም ኬት ጎርስምድንግንዳ Ꮊስግንደስ ከትም ማእዝዳ?” ክትም ጋይሳቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_15","078_2_15","GAL","2","15","15","ዎታ ዎንታ አጥርንካ አይሁዶት ዳት፥ አይሁድ ማታክባብ ጎመንባብከስግንዳ ካዮቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_16","078_2_16","GAL","2","16","16","ኤድ የሱስ ክርስቶሰካ አሜንካ ዳት፥ ህግን ካርስንተካ ሳብታ እሪ ጎማ ካይሰንባብ ማትካንታ ማታይንደትም ኤዝዶቴ። ኮካንታ ህግን ካርስንተካ ማታክናና፥ ክርስቶሰካ አሜንምሶ ሳብታ እሪ ጎማ ካየንባብ ማትሶ ክርስቶስ የሱሳር አመንቶቴ። ህግንም ካርስንተካ Ꮊየነረ ሳብታ እሪ ጎማ ካየንባብ ማታዬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_17","078_2_17","GAL","2","17","17","ክርስቶሰካ አሜንሶ ጎማ ካይሳ ሳብታ እሪ ማትካንታ ዎ ዝግድንካ፥ ዎታ ዎንታ ማታርንካ ጎመንባብከስ ማትሶ ዎ Ꮊፈርዴ፥ ይና ክርስቶስ ጎማ ዳልጋባብ ይዶ? ቦድሶ ይያዬ! ");
INSERT INTO gyl_vpl VALUES ("GL2_18","078_2_18","GAL","2","18","18","እ ዉልእሳንደትም ህግንታ ዎገንም ማስትቶ እ ይድንዳ ማቼ ህግንም እ ቃላዶቅድባብ ማትንተን እታ እስታ ማታርንካ ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_19","078_2_19","GAL","2","19","19","ሳብካንታ እ ዶቅተርንግንዳ ህግን ካርስንተካ ህግንካንታ ደእትቴ። ");
INSERT INTO gyl_vpl VALUES ("GL2_20","078_2_20","GAL","2","20","20","ክርስቶሰካ የካ እ ሮከርሳንደትከካ ደእትቴ። ይና ኮዘንካ እታ እስታ ማታ ካንታ ዶቃይቴ። ኬዛርንካ ማቼ ክርስቶስ እስታ ዋሪ ዶቅተሬ። ታየረ ዋሄካ እ ዶቅድን ዶቅንትና እም ሶልምስባባርኬ እካንታ ጋይሶ ይንታ ማተን ስክስት እምስባብ ሳብታ ይንችንዘን እስታ ዶቅድን አሜንኬ። ");
INSERT INTO gyl_vpl VALUES ("GL2_21","078_2_21","GAL","2","21","21","ሳብታ ዉች እምንተን እታ ቶክሳይቴ፥ ጎማ ካይሳ ሳብታ እር ማትና ህግንጎካ Ꮊፈርድንዳ ማቼ፥ ክርስቶስ ዉችኩን ደእሴ ጋይንት ዳት! ");
INSERT INTO gyl_vpl VALUES ("GL3_1","078_3_1","GAL","3","1","1","የታ ገላትያ ፍጨናር ዶቅድን ዳቻ ኤድንከሶ! ይና ዶፈንንካንታ የ ክትምዳክንግንዳ የንዘን Ꮊይ ናይሳሬ? የሱስ ክርስቶስ ሮከርሳንግንዳ ማትሶ የንታ እሪጎካ መየካ ምስል ማታዶቆ። ");
INSERT INTO gyl_vpl VALUES ("GL3_2","078_3_2","GAL","3","2","2","የንደርካ ዋልቃ ሪ Ꮊክ ኤስካንታ ዝግድቴ፥ አያንንም የ ተያንዳ ህግንም ካርስንተኮ አና ክላ ኬዘንም ኤስርሶ አመንኮ? ");
INSERT INTO gyl_vpl VALUES ("GL3_3","078_3_3","GAL","3","3","3","ኮከካ የታ ገቀርዳክባቦ? አያንካ የድሰቶ ኤታ ገቅርግንዳ ቦድካንታ ጉርደቴ? ");
INSERT INTO gyl_vpl VALUES ("GL3_4","078_3_4","GAL","3","4","4","ገታ ዉች ማዳክ ሪይታ ማቼ፥ ኮከካ ክላ ኬዘንጎካ ማጠንም የ ተያንዳ ዉች ኩኖ? ");
INSERT INTO gyl_vpl VALUES ("GL3_5","078_3_5","GAL","3","5","5","ሳብ ይንታ አያንንም እምድንዳ፥ የንደር አተንም ፍግዝድንዳ ህግንም የ ካርሳንኦሎ አና የ ኤሰርሳንደትም አሜንሳንካንቶ? ");
INSERT INTO gyl_vpl VALUES ("GL3_6","078_3_6","GAL","3","6","6","ይና አብራሀመም የ ገቅርኔ፥ “ኖ ሳብም አሜንሴ፥ ጭለትቼረ ማትሶ ክትካንታ ፋይድምሴ”። ");
INSERT INTO gyl_vpl VALUES ("GL3_7","078_3_7","GAL","3","7","7","ይና ኬና አመንድባብከስ አብረሀመታ ይንች ኬት ማቻንደትም ኤስከቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_8","078_3_8","GAL","3","8","8","ጭል ማጻፍነረ፥ ሳብ አይሁድ ማታክባብከስም አሜንካ ኬትም ጭልዝድንደትም እሪምሶ ሰድሶ፥ “ዎርሰነረ የስካ አንጅምዴ” ጋይንተካ ክላ ኬዘንም አብራሀማካንታ እሪምሶ ኤስምሴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_9","078_3_9","GAL","3","9","9","ኮካንታ አሜንካ ማችባብከስ፥ አሜንካ ማችባብ ኤችን አብራሀመካ ክክን አንጅምስባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("GL3_10","078_3_10","GAL","3","10","10","ህግን ካርስንተካ አመንድባብከስ ሙደና ባድምተኬ፥ “ህግ ማጻፍንከሳር ጻፍምሳንደትም ሙዳ ይዳክባብ ባድምስባቤ” ጋይምሶ ጭል ማጻፍናር ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_11","078_3_11","GAL","3","11","11","“ጭልምስባብ አሜንካ ዶቅዴ” ጋይምሳንጎካ፥ Ꮊየነረ ሳብታ እሪ ሙሴታ ህግንካ ኤድ ጭልምዳክንዳ መዬ። ");
INSERT INTO gyl_vpl VALUES ("GL3_12","078_3_12","GAL","3","12","12","ህግነረ አሜንታ ዘን ዎእሳንዳ ካዬ፥ ኮትኮግንደረ “ኤድ ህግካ ዶቅካንታ ማድንዳ ህግንታ ክተንም ሙዳ ቦድንኬ” ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_13","078_3_13","GAL","3","13","13","“Ꮊቀዘን ሮከርድባብ ሙደና ባድምስባቤ” ጋይምሶ ጻፍምሳንኦል፥ ክርስቶስ ዎካንታ ባድምስባብ ማትሶ ህግና ዎንዘን ተይᎺድን ባድንዘንካ ዎም ቆት ተዬ። ");
INSERT INTO gyl_vpl VALUES ("GL3_14","078_3_14","GAL","3","14","14","አብራሀም ካንታ እምምሳንዳ አንጀና፥ ክርስቶስ የሱሰካ አይሁድ ማታክባብከስካንታ የልድንግንዳ ዎም ቆት ተዬ፥ ኮነረ አሜንካ አያንንታ ጉርምን ዎ ተይድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_15","078_3_15","GAL","3","15","15","እስታ እስመንከስኬ ምችነንከሶ! ኤድ ሙዳᎺይካ ይድን መጤንግንዳ ካምስ ማስስቶ እ ኬዛ፥ ኤታ ጫቃ ዎራ ዋልቃዱት ጭልምሳን ቡር Ꮊየነረ ነግስካንታ አነረ ኮታዘን ጉጃካንታ ማዳክዬ፥ ናኮና Ꮊድን ጉርምነረ ኮግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_16","078_3_16","GAL","3","16","16","ጉርምንተረ ቃለና ኬዝምሳንዳ አብራሀም ካንተከ ክታ ሱሰንካንታ Ꮊቄ፥ ጭል ማጻፍና በድ ኤድካንታ ከዝምድንግንዳ፥ “ክታ ሱሰንከስካንታ” ጋያዬ፥ ኬዛርንካ ማቸ ዋልቃ ኤችካንታ ከዝምድንግንዳ፥ “የስታ ሱሰንካንተረ” ጋይዴ፥ ኖየረ ክርስቶስዬ። ");
INSERT INTO gyl_vpl VALUES ("GL3_17","078_3_17","GAL","3","17","17","ይና እ ጋይድንዳ ኩኔ፥ ኦይድ ጸተኬ ቦንደኬ ታማ ስለታ ቡሪ እምምሳን ህግና፥ እርምሶ ሳብካ ዳቅሳንደት ጫቀን ዉልእሶ Ꮊድን ጉርምንታ ቃለንም ነግሳዬ። ");
INSERT INTO gyl_vpl VALUES ("GL3_18","078_3_18","GAL","3","18","18","ባእንም ተይና ህግካ ማደስናና፥ Ꮊድን ጉርም ቃለንካ ማተራክዶቆ፥ ሳብ ማቼ Ꮊድን ጉርም ቃለንጎካ አብረሀምካንታ እምቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_19","078_3_19","GAL","3","19","19","ይና ህግና እምምሳንደና Ꮊረተረ? ህግና ጉጅምሳንዳ አብረሀምካንታ ጉርምካ እምምስባብ ይንችና Ꮊተርን የለልታ ዳቅል ፍክስና Ꮊራ ኮትናንከረ ሰችካንቴ፥ ህግና Ꮊዳንዳ ሳብተኬ ኤተካ ዎክናርንባብ ኤችንካንታ ክታይንችካ ኬዝምሴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_20","078_3_20","GAL","3","20","20","ማችንከረ ዎክናርንባብ ዋልቃባብካንታ Ꮊክ ጋይሶ ዎእስባብ ካዬ፥ ሳብ ማቼ ዋልቄ። ");
INSERT INTO gyl_vpl VALUES ("GL3_21","078_3_21","GAL","3","21","21","ኮናና ህግና ሳብታ ጉርም ቃለን ግርድንዶ? ቦድሶ ኩን ካዬ፥ ህግና እምምሳንደና ዶቅድንደትም Ꮊፍስስካንታ ማደስናና፥ ዶፈንከረ ጭለትቼና ህግንጎካ Ꮊፈርተር ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("GL3_22","078_3_22","GAL","3","22","22","ጭል ማጻፍና ማቼ ፍጫ ሙደና ጎመታ ጎይያር ቆልምሳንደትም ኤስምዝዴ፥ ኮነረ የሱስ ክርስቶስካ አሜንምካ Ꮊድን ጉርም ቃለን አሜንድባብከስ ሙደንካንታ እምምድን ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_23","078_3_23","GAL","3","23","23","ኮና አሜንና Ꮊተርንደታ እሪ ሙሴታ ህግንጎካ ዞከርስባብ ማትሶ Ꮊቆቴ፥ ናኮና አሜንና Ꮊፈርተርን የለልታ ዎንታዘን ዝጭምስንካ Ꮊቆቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_24","078_3_24","GAL","3","24","24","ኮካንታ አመንንካ ዎ ጭልምድንግንዳ ሙሴታ ህግና ኦስ ክርስቶሰደር ዎም ጋጵስንዳ ማቸ። ");
INSERT INTO gyl_vpl VALUES ("GL3_25","078_3_25","GAL","3","25","25","ታ ማቼ ናኮና አሜንና Ꮊዳንጎካ፥ ይና ኮዘንካ ሙሴታ ህግና ጋጵስንደታ ጎይያር ካዮቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_26","078_3_26","GAL","3","26","26","የታ ሙደነረ ክርስቶስ የሱሰካ አሜንካ ሳብታ ይንቸቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_27","078_3_27","GAL","3","27","27","ክርስቶሰካ ክክን ዋልቃ የ ማተርንግንዳ የታ ስኤርስባብከስ ሙደና ክርስቶሰም ቆበርተቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_28","078_3_28","GAL","3","28","28","አይሁድንተኬ ግርክንታ፥ አይለተኬ ማታቆልስባብታ፥ አⷝነንተኬ ማነታ ዎክያር ፋስም ካዬ፥ የታ ሙደነረ ክርስቶስ የሱሳር ዋልቀቴ። ");
INSERT INTO gyl_vpl VALUES ("GL3_29","078_3_29","GAL","3","29","29","ይና ክርስቶስታ የ ማቻንካ የታ አብራሀመታ ሱሰቴ። Ꮊድን ጉርም ቃለንግንደረ ባእንም ተይድባበቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_1","078_4_1","GAL","4","1","1","ታየረ እ ጋይድንዳ ኮኔ፥ ባእንም ተይድባብ ይንችና አክ ኡላ ማትሶ ዶቅድዮ ሪን ሙደንታ ማታቆልስባብ ይ ማችንከረ ዎራ አይለዘንካ Ꮊረከረ ኖ ስጋዬ። ");
INSERT INTO gyl_vpl VALUES ("GL4_2","078_4_2","GAL","4","2","2","ኬዛርንካ ማቼ ባቤና ክትካንታ ጋይሳን ሰጨና የልተርን የለልታ ጋጵስንባብከስተኬ እችስንባብከስታ ኖ ጎያሬ። ");
INSERT INTO gyl_vpl VALUES ("GL4_3","078_4_3","GAL","4","3","3","ኮትኮግንደረ ዎታ አያናርጎካ ኡላግንዳ ዎ Ꮊቃንደትካ ፍጫሙደንታ ዎገንታ ጎያር ማትንተካ አይላትቻር ቆልምሶ Ꮊቆቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_4","078_4_4","GAL","4","4","4","ኬዛር ማቼ ሳብ ጋይሳን ስለና የልሳንደትካ፥ ሳብ ማነዘንካ አጥርምስባብም፥ ሙሴታ ህግንካ ክትምድባብ ይንታ ይንችን ዎካንታ ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("GL4_5","078_4_5","GAL","4","5","5","ኮነረ ይይምሳንዳ ሳብታ ይንች ዎ ማተርንግንዳ ሙሴታ ህግን ክትመሮ ዶቅድባብከስም ቆትማ ካንቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_6","078_4_6","GAL","4","6","6","ይንቼረ የ ማቻን ኦል ሳብም፥ “ባቦ እስታ ባቤኖ” ጋይሶ ፍብድን ይንታ ይንችንታ አያንን ዎንታ ቡዳር ኦይቼ። ");
INSERT INTO gyl_vpl VALUES ("GL4_7","078_4_7","GAL","4","7","7","ኮካንታ ኮዘንካ ፈንክ ክታ ይንች ዳት አይላ ካየዬ፥ ይንቼረ ክታ የስ ማቻንኦል፥ ሳብ ባእንም የስ ተይድንግንዳ ማስቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_8","078_4_8","GAL","4","8","8","ሳብም የ ኤስተርንደታ እሪ፥ ኬታ ይንታ መጤንካ ጮይስ ማታክባብከስካንታ አይላ ማትሰቶ Ꮊቀቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_9","078_4_9","GAL","4","9","9","ታ ማቼ የታ ሳብም ኤስተቴ፥ ስግስሰረ ሳበረ የም ኤስቴ፥ ይና አነታ ኦስ ቶችምሳንደታርኬ መይዳክን ጮይስ ማታክንባብከስታ ዎገንደር Ꮊስግንደንት ማዳ? አነታ ኬታ አይላ ማትሰቶ ቆልምካንታ ዝግደቴ? ");
INSERT INTO gyl_vpl VALUES ("GL4_10","078_4_10","GAL","4","10","10","Ꮊክ ማቻን ሰጨን ከስም፥ አርፈንን፥ ለእንምኬ ስለንም ቦንጅደቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_11","078_4_11","GAL","4","11","11","ይና የካንታ ዉችኩን እ ጋፍሳንዳ ካምድንኦል እታ የካንታ ጳዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_12","078_4_12","GAL","4","12","12","እስመንከስኬ ምችነንከሶ! እታ የም ምግዝድቴ፥ እታ የም እ ካምድንካንታ የተረ እም ካምከቴ። የታ ዋልቀረ እካንታ ቦርድሪ ይያከቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_13","078_4_13","GAL","4","13","13","የ ኤዝድንደትግንዳ እሪምሶ የካንታ ክላ ኬዘንም እ ኬዛንዳ እታ ሰቀርሶ ዶቅድዬ። ");
INSERT INTO gyl_vpl VALUES ("GL4_14","078_4_14","GAL","4","14","14","እስታ Ꮊዝምና የካንታ ጰጫ የንታዘን ማችንከረ ዎራ፥ እም ቦሳከቴ፥ አነረ እም ይንኤራከቴ። ኬዛርንካ ማቼ ሳብታ ክታይንችግንዳ፥ ኮትኮግንደረ ክት የሱስ ክርስቶሰምግንዳ ማስሰቶ እም ሞክሰቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_15","078_4_15","GAL","4","15","15","ማችንከረ ናኮና ሙዳ ጉርምና Ꮊብሮክ አይሳሬ? የካንታ ማደስናና አፍይን የንታ ማቼረ ዎራ ዉችተቶ እካንታ የ እምድባብ የንታ ማትንተን፥ የ እካንታ ይዳክንዳ ሪካየንደትም ማርከርድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_16","078_4_16","GAL","4","16","16","ዶፈንን የካንታ እ ኬዛን ኦል ይምኤንባብስ የንዘን ማቾ? ");
INSERT INTO gyl_vpl VALUES ("GL4_17","078_4_17","GAL","4","17","17","ኬታኬና ኤድንከስ ይንደር የም ማስካንታ ጉርደኬ፥ ኡርመንካንታ ካዬ። ኬት ዝግድንዳ የም ዎንዘንካ ፋስተኮ ከትካንታ Ꮊክ ዳቅሶ የ ገቀርድንግንዳ ማስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_18","078_4_18","GAL","4","18","18","ኬዛርንካ ማቼ የንታ ገቅርና ኡርመን ካንታ ማቻን የለልታ ኡርሜ፥ ኮነረ ማት ዝግዝድንዳ ሙዳᎺይካ ዳት እታ የንካ ክክን እ ዶቅድንደትካ Ꮊክ Ꮊይማታ። ");
INSERT INTO gyl_vpl VALUES ("GL4_19","078_4_19","GAL","4","19","19","እ የም ሶልምድባብ እስታ ይንችንከሶ፥ ክርስቶስ የንታዘን ክት Ꮊፈርተርን የለልታ የካንታ አነታ እችረት እም የቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_20","078_4_20","GAL","4","20","20","የንተና እም Ꮊኤርዝድንደትካንታ ማጠርድቴ፥ ታ የንታ ዎክያር Ꮊፈርስቶ የንካ ክክን መያ ኬዝምካንታ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_21","078_4_21","GAL","4","21","21","የታ ሙሴታ ህግንታ ጎያር ቆልምካንታ ዝግድባብ ይና የ እካንታ ኬዝኔ፥ ህግና Ꮊራ ኮት ጋይዳናንከረ የታ ኤሰራከቴ? ");
INSERT INTO gyl_vpl VALUES ("GL4_22","078_4_22","GAL","4","22","22","አብራሀም ዋልቀንም ይንታ አይለንዘንካ፥ ዋልቃባብም ገታ ይንታ ኬነንዘንካ ቃስተን ይንች ክታ Ꮊቃንደትም ጭል ማጻፍናር ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_23","078_4_23","GAL","4","23","23","አይላ Ꮊቃንደት ኤተንንዘንካ Ꮊፈርስባብ ይንችና ኤታ ጋይተክንግንዳ Ꮊቄ፥ ገታ ክታ ከነንዘንካ አጥርምስባብ ማቼ Ꮊድን ጉርም ቃለንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_24","078_4_24","GAL","4","24","24","ኬና ማነንከስ ቃስተን ጫቀንከስም ሰችዝድንኦል፥ ኮና ሪና ካምስንከስግንዳ ሰድምድንዴ። ዋልቃ ጫቀና ሲና ገቼንዘንካ ማድንካ፥ አይላትችካንታ ማድባብከስ ይንችንም አጥንዴ፥ ናየረ አጋሬ። ");
INSERT INTO gyl_vpl VALUES ("GL4_25","078_4_25","GAL","4","25","25","ይና አጋራ አረብ ፍጫር ዶቅድንዳ ሲና ገቸንታ ካርያሬ፥ ታ ዶቅድንደት የሩሳሌም ካተመን ካምዴ፥ ይንታ ይንችንካ ክክን ና አይላትቻሬ። ");
INSERT INTO gyl_vpl VALUES ("GL4_26","078_4_26","GAL","4","26","26","ፈ ጭላርንካ ማቻንዳ የሩሳሌም ማቼ ባዛካይሳ ና ዶቅተሬ፥ ናየረ ዎንታ እንደኔ። ");
INSERT INTO gyl_vpl VALUES ("GL4_27","078_4_27","GAL","4","27","27","ጭል ማጻፍናር፥ “የና አጣክንዳ ሴኬኖ! የስም ጉርምሳ፥ የና እችረትካ ጋእርሶ ኤዝዳክንዶ! እልስካ ፍፍካ፥ ክእስ ዶቅድንደትዘንካ ስግስሶ ይንት ዶቅድን ኤተንንታ ይንችና በተኬ” ኩን ጋይምሶ ጻፍምቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_28","078_4_28","GAL","4","28","28","ይና እስመንከስኬ ምችነንከሶ፥ የተረ ይሳቅግንዳ Ꮊድን ጉርም ቃለንታ ይንቼቴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_29","078_4_29","GAL","4","29","29","ኮታይካ ኤታ ጋይታግንዳ አጥርምስባብ፥ ይንችና ሳብ አያንታ ዎልቀካ አጥርምስባብም ዳይሴ፥ ታየረ ኮትኮግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_30","078_4_30","GAL","4","30","30","ኬዛርንካ ማቼ ጭል ማጻፍና Ꮊሮክ ጋይዳ? “አይለንምኬ ኮታ ይንቺንም ክክን Ꮊልእሴ፥ Ꮊረታ ጋይሴ አይለንታ ይንችና ባዛካይሰንደታ ይንችንካ ክክን ባእንም ተያዬ” ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("GL4_31","078_4_31","GAL","4","31","31","ኮካንታ እስመንከስኬ ምችነንከሶ፥ ዎታ ባዛ ካይሰንደታ ይንቾት ዳት ኮት አይለንታ ይንች ካዮቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_1","078_5_1","GAL","5","1","1","ክርስቶስ ባዛካይሳ ዎም ዉችሳንዳ ባዛካይሳ ዎ ዶቃባብዬ። ኮካንታ የ Ꮊፍሳን ባዛካይሳ ዶቅንተናር ዳቅሶ ዶእከቴ፥ ማቲ አና ቃስትምሰረ አይላ ቃምበርናር Ꮊይ የድመቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_2","078_5_2","GAL","5","2","2","እ ጋይድንደትም ኤሰርከቴ፥ የንታ ሶለን ተችካንታ የ ዝግዴ፥ ክርስቶስ ቦድሶ የካንታ መያይንደትም እታ ጳውሎስ የካንታ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_3","078_5_3","GAL","5","3","3","ሶለንም ተችርካንታ ዝግድባብ ሙደና ሙሴታ ህግንም ሙዳ ቦድንተና ነገዳክንዳ ማትንተን አነታ ዋልቃ ዋልቃባብካንታ መያ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_4","078_5_4","GAL","5","4","4","ሙሴታ ህግካ ጭልምካንታ ዝግድባብከሶ፥ ክርስቶስዘንካ ፋስምተቴ፥ ሳብታ ዉች እምንተንዘንካ ጎተርተቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_5","078_5_5","GAL","5","5","5","ዎታ ማቼ ሳብታ አያንካ ጭላትቼንታ Ꮊድን ጉርምንም አሜንካ ካርዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_6","078_5_6","GAL","5","6","6","ክርስቶስ የሱሳር አሜንሶ ዶቅድባብ ማቼ፥ ኬት ሶለን ተቸርሰረ አና ኬት ተችራክንዳ ማቼረ መያዬ፥ መይድንዳ ሶልመዘን የድምሶ ፍግዝድንዳ አሜንኔ። ");
INSERT INTO gyl_vpl VALUES ("GL5_7","078_5_7","GAL","5","7","7","ኤና እሪ ክርስቶሰካ ክክን Ꮊቃን የንታ ዶቅንትና ኡርማ ዶቆ፥ ይና የም ኮተርስባብኬ ዶፈንንካንታ የ ክትምዳክንግንዳ መርስባብ Ꮊይራ? ");
INSERT INTO gyl_vpl VALUES ("GL5_8","078_5_8","GAL","5","8","8","ኮግንዳ ዶቅድን ዞረና የም ኤልስባብ ሳብንዘንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("GL5_9","078_5_9","GAL","5","9","9","ኮነረ “ቶክም እርስና ማጠንም ሙዳ ኡስዝዴ” ጋይምድንደት ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_10","078_5_10","GAL","5","10","10","ጮይስያር ዎንታ ዶቅድን ዋልቃትቼንዘንካ አብ ገቅር የንታ ካየንደትም እታ አመንድቴ። የም ዳንድምዝድባብ Ꮊየነረ ማታ Ꮊየን፥ ፍርደን ተይተሬ። ");
INSERT INTO gyl_vpl VALUES ("GL5_11","078_5_11","GAL","5","11","11","እስመንከስኬ ምችነንከሶ፥ ታካ የለልታ ሶለን ተቸርንጎካ እ ሳባግድንዳ ማቼ፥ ይና ታ የለልታ አይሁድንከስና Ꮊረተክ እም ዳይዳ? ኮት ኮግንዳ ማደስናና፥ ክርስቶሰታ ማዝቀልና ኤድንከስካንታ ጎሀ ማትና ነገዳ ዶቆ። ");
INSERT INTO gyl_vpl VALUES ("GL5_12","078_5_12","GAL","5","12","12","የም ዳንድምዝድባብ ኤድንከስና ከታ ይንታ ሶለን ተች Ꮊክ ማታክናና ጉሳጋካ! ");
INSERT INTO gyl_vpl VALUES ("GL5_13","078_5_13","GAL","5","13","13","እስመንከስኬ ምችነንከሶ፥ ባዛካይሳ የ ማድንግንዳ ኤልምተቴ። ባዛካይሳ የንታ ማትንተን ማቼ የንታ ዋሄታ አንግርን ቦድንታ Ꮊይ ማሰቴ፥ ስግስሶ ዋልቀና ዋልቃባብካንታ ሶልመካ ፍክሳ። ");
INSERT INTO gyl_vpl VALUES ("GL5_14","078_5_14","GAL","5","14","14","ሙሴታ ህግ ሙደና ዋልቃ ቃለካ ዞክምቴ፥ ኮነረ፥ “የስታ ላኮይትን የስታ ማታግንዳ ሶልምካ” ጋይድንዴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_15","078_5_15","GAL","5","15","15","ኬዛርንካ ማቼ ክክ ክክ ኬዝካ እክምምድባብከ ሰቅዝድባብ የ ማቼ፥ ክክ ክክ የ ካይዳክንግንዳ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_16","078_5_16","GAL","5","16","16","ይና አያን ጭልንካ ዶእከቴ ጋይድቴ፥ ዋሄተረ አንግርንም ቦተራከቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_17","078_5_17","GAL","5","17","17","Ꮊረታ ጋይሴ ኤታ አንግር አያን ጭልን ዝግዳክንደትም፥ አያን ጭልነረ ኤታ አንግር ዝግዳክንደትም አንገርዴ፥ ኬና ክክ ክክ ዳዉጭምድን ኦል፥ የ ዝግድንደትም ይተራከቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_18","078_5_18","GAL","5","18","18","አያን ጭልንካ የ ጎርስምሴ ሙሴታ ህግንታ ጎያር ካየቴ። ");
INSERT INTO gyl_vpl VALUES ("GL5_19","078_5_19","GAL","5","19","19","ኤታ አንግርታ ፍክስና መየከ፥ ከቴረ በልም፥ ቱና፥ ኦካ፥ ");
INSERT INTO gyl_vpl VALUES ("GL5_20","078_5_20","GAL","5","20","20","አብ ሪይም ጮይስዬ ጋይሶ ጎይን፥ ብታ፥ ይምኤሪ፥ ዋጭመም አምስስ፥ ቀምስ፥ ስነር ማተም ሶልማ፥ ፋስም፥ ኤታዘን ዙዝም፥ ");
INSERT INTO gyl_vpl VALUES ("GL5_21","078_5_21","GAL","5","21","21","አብ ኤታ ጋጵንታ ዝጋይባብ፥ ጎዝ፥ ጎማር ጎርዝድን ይግ፥ ኬት ከናከስግንደን ካምድንዴ። እሪምሶ እ የም ኤግዝምሳንግንዳ ታየረ የም ኤግዝምዝድቴ፥ ኮግንደካ ዶቅድባብ ሙደና ሳብታ ባንችምን ተያየኬ። ");
INSERT INTO gyl_vpl VALUES ("GL5_22","078_5_22","GAL","5","22","22","አያን ጭልንታ አፍና ማቼ ሶልማ፥ ጉርም፥ ሳራትች፥ ዳንዳእ፥ Ꮊልስም፥ ላቅም፥ አመንም፥ ");
INSERT INTO gyl_vpl VALUES ("GL5_23","078_5_23","GAL","5","23","23","ቡዳርንካ አብንካንታ አተርድባብ፥ ይንታ ማተንም ቆሌ። ኬት ኬናከስግንደን ማሪድን ህግ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("GL5_24","078_5_24","GAL","5","24","24","ክርስቶስ የሱሰታ ማችባብ ኤድንከስ ዳቅል አንግርንምኬ ዝግመትን የካ ሮክተኬ። ");
INSERT INTO gyl_vpl VALUES ("GL5_25","078_5_25","GAL","5","25","25","አያን ጭልንካ ዎ ዶቅድንዳ ማቼ፥ አያን ጭልና ዎም ጎርዝድንደትካ ዎ ዶቃ። ");
INSERT INTO gyl_vpl VALUES ("GL5_26","078_5_26","GAL","5","26","26","ክክ ክክ ዎታ ዳቅል ፍክስካንታ አምስሰርንደትኬ ቀምስመሮቶ ዉች ጎፍስምካ ዎ Ꮊይጋየራ። ");
INSERT INTO gyl_vpl VALUES ("GL6_1","078_6_1","GAL","6","1","1","እስመንከስኬ ምችነንከሶ! ዋልቃ ኤች ጎመታ ዋሪ አርድሶ Ꮊፈርሴ አያን ጭልንካ ማችባብከስ የታ ቡዳርንካ አትርካ ክትም ማስ የም ዝግዝዴ። ኬዛርንካ ማቼ የና ይና የስ ጰጭምተራክንግንዳ የስታ ማተንም ካርስካ። ");
INSERT INTO gyl_vpl VALUES ("GL6_2","078_6_2","GAL","6","2","2","የንታ ዋርንካ ዋልቃባብ አብንከስታ ባለንም ባላ፥ ኮግንዳ ይተካ ክርስቶሰታ ህግንም የታ ቦተረቴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_3","078_6_3","GAL","6","3","3","ዋልቃ ኤድ አብንከዘንካ ስግ ክትም ማዝድሪ ካያናና፥ እታ አብንዘንካ ስግቴ ጋይድባብ ይንታ ማተንም ገስዝዴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_4","078_6_4","GAL","6","4","4","ዋልቃ ዋቅልቀና ይንታ ይተንም ሰዳጋካ፥ ኮታ ቡሪ አብ ኤድንካ የካ ይንታ ማተንም የክሳክሳ፥ ይንታ ማታ ካንታ ይ ጋይርድንደትም Ꮊብዴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_5","078_6_5","GAL","6","5","5","ኮካንታ ዋልቃ ዋልቀና ይንታ ማታ ባለንም ባል ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_6","078_6_6","GAL","6","6","6","Ꮊየረ ሳብታ ቃለንም ኤስካንታ ዝግድባብ ኡርማ ማቻን ሪ ሙደን ኤስንባብካ ክክን ካስምዴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_7","078_6_7","GAL","6","7","7","የንታ ማተንም Ꮊይገስሰቴ፥ ሳብዘን Ꮊይለቀቴ። ኤድ ይ ማዝድንደትም ኮትም ስክተሬ። ");
INSERT INTO gyl_vpl VALUES ("GL6_8","078_6_8","GAL","6","8","8","ኤታ አንግርታ ገቅርንም ጮችካንታ ማዝድባብ ኤታ አንግርዘንካ ደእንም ስክተሬ። አያን ጭልንም ጉርምስካንታ ማዝድባብ ማቼ አያን ጭልንዘንካ ስለንካ ዶቅድን ሰንፔንም ስክተሬ። ");
INSERT INTO gyl_vpl VALUES ("GL6_9","078_6_9","GAL","6","9","9","ኮካንታ ኡርማ ሪንም ይተንዘንካ Ꮊይ ዎ ቦዘራ፥ Ꮊድን ጉርምን ዎ ተቻክንዳ ማቼ ሰጨና የልድንካ ስክምን ስክተሮቴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_10","078_6_10","GAL","6","10","10","ይና ሰጫ ዎ Ꮊፍሴ ኤድ ሙደንካንታ ስግስሰረ አሜንድን ኤሀ ኤድንከስካንታ ኡርማ ሪም ይተሮቴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_11","078_6_11","GAL","6","11","11","Ꮊስግንዳ ዶቅድን ባካ ፍደልንከስካ የካንታ እስታ አንካ እ ጻፍሳንደትም ሰድከቴ! ");
INSERT INTO gyl_vpl VALUES ("GL6_12","078_6_12","GAL","6","12","12","የ ሶለን ተቸርድንግንዳ የም ማእዝድባብ ማልጎካ ኡርማ ማትሶ Ꮊፍርካንታ ዝግድን ኤድንከሰኬ፥ ኮም ይድባብከሰረ ክርስቶሰታ ማዝቀልንዘን ደእንጎካ ዳይርና ከታዘን የልዳክንግንዳ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_13","078_6_13","GAL","6","13","13","ኬታ የንታ ዋሄንታ ሶለንም ተችስካ ጋይርምካንታ ዝግሰኮ ዳት፥ ሶለንም ይንታ ተቸርስባብከስ ሙሴታ ህግንም ካርዝድባብ ካየኬ። ");
INSERT INTO gyl_vpl VALUES ("GL6_14","078_6_14","GAL","6","14","14","ዎንታ ጮይስን የሱስ ክርስቶስታ ማዝቀልንዘንካ አብ ጋይርና እዘንካ ጎተራ፥ ኮትኮ ማዝቀልንካ ፍጫሙደንታ ሪና ደእም ካምድንደትካ እዘንካ ፋስምቴ፥ እተረ ፍጫሙደንታ ዳቅል ሪንዘንካ ፋስምትቴ። ");
INSERT INTO gyl_vpl VALUES ("GL6_15","078_6_15","GAL","6","15","15","ሶለንም ተችርነረ ማታ ተቸርክሳ ነግነረ መያዬ፥ መይድንደና ክርስቶሳር ክላ አጥር ማትኔ። ");
INSERT INTO gyl_vpl VALUES ("GL6_16","078_6_16","GAL","6","16","16","ኮ ክተንም ጎርስምድባብ ሙደንኬ ሳብታ ገርነና ማችባብ እስራኤልንከስካንታ ሳራትቸንኬ አጭርንካ ማታ። ");
INSERT INTO gyl_vpl VALUES ("GL6_17","078_6_17","GAL","6","17","17","በእንተዘን እ ጋይድንዳ እታ የሱሳካንታ ጋይስቶ እ ተያን ማጠንታ አፍንን እስታ ዋሄንዘን ባልትቴ፥ ናየረ የሱሰታ ፍክስንባብ እ ማቻንደትም ሰጅድንካንታ ኮዘንካ ፈንክ Ꮊየነረ እም ማእሳዬ። ");
INSERT INTO gyl_vpl VALUES ("GL6_18","078_6_18","GAL","6","18","18","እስመንከስኬ ምችነንከሶ! ጮይስ የሱስ ክርስቶሰታ ዉች እምንተና የንካ ክክን ማታ! አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","ሳብታ ጋይተካ ክርስቶስ የሱሰታ ኦይትምስባብ ጳውሎስዘንካ፥ ክርስቶስ የሱሳር ዶቅድን አሜንምስባብ፥ ኤፈሶን ካተመናር ዶቅድባብ ጭልንከስካንታ፥ ");
INSERT INTO gyl_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","ሳብ ዎንታ ባቤንዘንኬ፥ ጮይስ የሱስ ክርስቶስታ ዉች እምንተንኬ ሳራትችንካ የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","ጭላር ዶቅድን አያንታ አንጀንም ሙዳ ክርስቶስካ ዎም አንጅባብ ዎንታ ጮይስንኬ የሱስ ክርስቶስታ ባቤን ማችባብ ሳብና አንጅማ፥ ");
INSERT INTO gyl_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","ክታ እሪ ጭልምስባብኬ ይንኤርዝድ ሪካይሳ ማትሶቶ ሶልመካ ዎ ዶቅተርንግንዳ ፍጫ ሙደና ፍዝምተርንዘንካ እሪምሶ ክርስቶስካ ዎም እጄ። ");
INSERT INTO gyl_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","የሱስ ክርስቶስጎካ ክታ ይንች ዎ ማድንግንዳ፥ ሳብ ይንታ ኡርማ ገቅርንካ እሪምሶ ዎም እጄ። ");
INSERT INTO gyl_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","ኮነረ ይይምሳንዳ፥ ሶልምምስባብ ይንታ ይንችንጎካ ቦንችምሳንዳ ዉችኩን ዎካንታ እምምሳን እመና ጋለትምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","ሳብታ ዉች እምንተንታ በድምንዘንካ አምሳንዳ ክታ ይንቺንታ ማቀስንካ ቆትምሶቶ ዎንታ ጎመንታ ነገትቼን Ꮊፍሶቴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","ይንታ ዉች እምንተንመረ ኤጨኬ ኤስ ሙደን ዎካንታ በችሴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ሳብ ይንታ ላቅምንካ ክርስቶስጎካ እርምሶ ፍክስካንታ ይ ገቀርሳንግንዳ ክታ አችምሳን ኬዘን ዎ ኤዝድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","ስለንታ በእንተንዘን ማትካንታ ዶቅድን ክታ ገቅርና ጭለዘነረ ፍጨዘነረ ዶቅድሪ ሙደንታ ዱራ ማችባብ ክርስቶስታ ገችታ ኤረንታ ጎይያር ማስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","ሙደንም ይንታ ጋይተንግንዳ ፍዝድባብ ሳብ እሪምሶ ዎካንታ ይ ገቀርሳንግንዳ ክርስቶስጎካ ክታ ኮች ዎ ማድንግንዳ ዎም እጄ። ");
INSERT INTO gyl_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","ኮነረ ክርስቶሰካ Ꮊድን ጉርም ይይንተካ እርንባብ ዎ ማቻንዳ ሳብታ ቦንቼንም ጋለትካ መያ ዎ ማዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","የተረ ዶፈን ቃለን፥ ኮነረ የንታ አቅንተታ ክላ ኬዘንም ኤሰርሰቶ ክርስቶሰካ አሜንተቴ፥ ኮትኮግንደረ ኖ የም እምካንታ Ꮊድን ጉርም ይሳን አያን ጭልንታ ማተምንካ የችምሰቴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","ክታ ቦንቼንታ ጋለት ማትካንታ ሳብታ ማችባብከስ ሙደና ቆት ኬት ተይምተርን የለልታ፥ ኖየረ ዎ ተይድን ባእንታ ሳቼ። ");
INSERT INTO gyl_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","ኮካንታ ጮይስ የሱሳር የንታ ዶቅድን አሜንንጎኬ ሳብካንታ ፋስምስባብከስ ሙደንካንታ የንታ ዶቅድን ሶልመን ኤሰርስቶ፥ ");
INSERT INTO gyl_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","የጎካ ሳብም ጋለተርቶ እ ምግዝድንደትካ የም ገቅርን ዛቃክቴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","ቦንቻ ዝግዝድባብ ዎንታ ጮይስ የሱስ ክርስቶስታ ባቤን ሳብም ስግስሶ የ ክትም ኤዝድንግንዳ፥ ኤጨንምኬ መያ ማስዝድን አያን ጭልን የካንታ እምምድንግንዳ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","ኮትኮግንደረ ክትካ የ ኤልምሳን Ꮊድን ጉርም፥ ኮነረ ሳብካንታ ፋስምስባብከዝደር ዶቅድን ቦንችምሳን ባእንታ ቆልመና Ꮊራከካ ማዳናነረ የ ኤዝድንግንደኬ የንታ ቡደንታ አፍንከስ ፎችምድንግንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","ዎ አሜንድባብከስካንተረ ሙደንዘንካ ስግ አንድር ማችባብም ክታ ዎልቀን የ ኤዝድንግንዳ ምግዝድቴ። ኮነረ ይንታ አንድር ዎልቀንታ ፍክስን ክት ሰችሳንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","ክርስቶሰም ደእያርንካ አምስሶ ጭላር ይንታ ምዝንዘን ዶቅስንኬ። ");
INSERT INTO gyl_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","ክት ዶቅሳንደረ ሙደንም ቆልንተተኬ ገችታ ኤራ፥ ዎልቃ ሙደንዘን አነረ ማታ ቆልድባብ ሙደንዘንከረ ስግ ኮትኮግንደረ ኮ ፍጫሙደንዘን Ꮊክ ማታክናና Ꮊድን ፍጫ ሙደንዘነረ ላም ሙደንታ ዘርመካ ማቻን ቦንችምሳን ላምን ክትካንታ እምንተኬ። ");
INSERT INTO gyl_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","ሳበረ ሙዳ ሪን ክታ ገችንታ ኤረንታ ጎይናር ማስሴ፥ ምክስ ኤሄንዘነረ ሙደንዘንካ ስግ ክት ዱራ ማድንግንዳ ማስሶ ዶርሴ። ");
INSERT INTO gyl_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","ምክስ ኤሄነረ ሙዳ ሪም ሙደናሪ ጮጅድንዳ ክታ ጮችንዴ፥ ክርስቶሰተረ ና ዘኔ። ");
INSERT INTO gyl_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","የታ የንታ ባችንተኬ የንታ ጎመንጎካ ደእስባብ ማትሶ Ꮊቀቴ፥ ");
INSERT INTO gyl_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","ከትከነከረ፥ ፍጫሙደንታ ዳቅልጎግን ጎርስምድ Ꮊቀቴ፥ ዞገዘን ዶቅድባብ አያንንከስታ ዎልቀን ቆልድባብም ክትምድ Ꮊቀቴ፥ ኖየረ ሳብካንታ ክትምዳክባብ ኤድንከዘን ፍግዝድባብ ቱና አያኔ። ");
INSERT INTO gyl_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","ዎታ ሙደና ከትኬና ይንችንታ ዎክያር ዎንታ ዋሄንታ አንግርን ጮቸሮቶ ዎንታ ጎግንመረ ጎርስመሮቶ ኬታ ዎክያር ዶቀሮ Ꮊቆቴ፥ ኬት አብንከስግንደረ ሳብታ ዋጭንታ ጎይያር Ꮊቆቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","ኬዛርንካማቼ ይንታ አጭርንካ ቆልማባብ ማችባብ ሳብ ዎካንታ ክታ ዶቅድን አንድር ሶልመንዘንካ አምሳንዳ፥ ");
INSERT INTO gyl_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","ዎንታ ባችንካ ደእስባብ ማትሶ ዎ ዶቅድንካ፥ ሳብ ክርስቶሰካ አፈካ ዎም ማስሴ፥ የ አቃንደና ክታ ዉች እምንተንኬ። ");
INSERT INTO gyl_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","ሳበረ ክርስቶስካ የካ ዎም ደእያርንካ አምሴ፥ ክርስቶስ የሱሳር ጭላር ክትካ ክክን ዎም ዶቅሴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","ኮመረ ሳብ ይሳንዳ Ꮊድን ስለናር ክርስቶስ የሱሰካ ይንታ Ꮊልስምንምከ ዎካንታ መያ ማስሳን ሙደንዘንካ ስግ ይንታ እምንተንታ ቆልመን ሰችካንታ ጋይሴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","የታ የ አቃንዳ አሜንካ ዉች እምንተንጎኬ፥ ና ኮነረ ሳብታ እምንታ ዳት የንዘንካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Ꮊየነረ ጋይርዳክንግንዳ አቅንተንታ ዉች እምንተና Ꮊፈርሳንዳ ክታ ፍክስካ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","Ꮊረታ ጋይሴ፥ ሳብ እርምሶ ዎካንታ ክት ግግሳንዳ ኡርማ ፍክስን ዎ ፍግዝድንግንዳ ክርስቶስ የሱሳር ፍዝምስባብ ፍዝሮቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","ኮካንታ የታ ኤና የንታ አጥርንካ አይሁድ ማታክባበቴ፥ አይሁድንከስ ኤታ አንካ ሶለን ይንታ ተችርንካ ጋይረረኮ፥ የም የንታ ሶለን ተቸራክንባብከስ ከት ጋየሮ Ꮊቃንደትም ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","ኮት ስለናር ክርስቶስዘንካ ፋስምሰቶ፥ እስራኤልንከስታ ሱሳ የ ማድንደትዘንካ ጎተርሰቶ፥ Ꮊድን ጉርም ጫቃ ቃለንካንታ ሶች ማትሰቶ፥ ኮ ፍጫሙደንዘን ጉርም ካይሰኬ ሳብካይሳ የ Ꮊቃንደትም ገቀርከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","የታ ኤና ጎተርሶ Ꮊቅባብከስ፥ ታ ማቼ ክርስቶስ የሱሳር ማትሰቶ ክርስቶሰታ ማቀስንጎካ ቅንችምሰቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","አይሁድንምኬ አይሁድ ማታክባብከስም ዋልቃ ማስስባብ፥ ከትም ፋሳᎺቃን ዋጭንታ ካዝመን ዉልእስባብ ዎንታ ሳራትቼና ክርስቶስዬ። ");
INSERT INTO gyl_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","ህግንታ ክተንከስምኬ ዎገንከስም ይንታ ዋሄንታ ደእንካ Ꮊልእሴ። ኮና ገቅርነረ ከት ቃስተንናርንካ ዋልቀን ክላ ኤድ ይንታ ፍስትዮ ሳራትችን እምካንቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","ማዝቀልንዘን ይንታ ደእንካ ይምኤንባብ ኬታ ማትንተን Ꮊልእስሶ ቃስተንንከስም ዋልቃዘና ማስስካ ሳብካ ክክን ኤድምሴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Ꮊድሰረ የ ጎተርሶ Ꮊቅባብ፥ አይሁድ ማታክባብከስካንተኬ ቅንችምሶ የ Ꮊቅባብ አይሁድንከስካንተረ ሳራትቼንታ ክላ ኬዘንም ሳባክሴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","ዎታ ሙደነረ ክትጎካ ዋልቃ አያንንካ ሳብ ባቤንደር የልዶቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","ኮዘንካ አምሳንዳ የታ ሳብካንታ ፋስምስባብከስካ ክክን ዋልቃ ፍጫባብኬ ሳብተረ ኤሀ ኤደት ዳት፥ ይና ኮዘንካ ኤድ ፍጫር ዶቅድባብኬ ሶችንከስ ካየቴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","ኦይትምስባብከስተኬ ሳብዘንካ ኤስርሶ ኬዛᎺቅባብከስታ የድንዘን ዎድምተቴ፥ ኤሄን የለንታ ዱረና ክርስቶስ የሱስዬ። ");
INSERT INTO gyl_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","ክትካ ኤሄንታ የለና ሙዳ የካ የድምሰኮ ሳብታ ጭል ኤሀ ማትካንታ ጋጵዴ። ");
INSERT INTO gyl_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","የተረ አና ሳብ ይንታ አያንንካ ክት ዶቅድን ገችንት ኤሀ የ ማተርንግንዳ ክርስቶሰካ የካ ዎድማዶቅደቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","ኮካንታ እታ ጳውሎስ የሱስ ክርስቶስታ ዞከርስባብ እ ማቻንዳ የ አይሁድ ማታክባብከስካንታ ጋይስቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","የም መይድንግንዳ እካንታ እምምሳን ሳብታ እምንተንታ ፍክስን ገታ ኤሰርተቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","እርምስቶ ጬድካ የካንታ እ ጻፍሳንግንዳ፥ ለምለም ጋይድንካ ሳብ ይንታ አችምሳንደትም እ ኤዝድንግንዳ ሰችቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","ይና ኮም እ የካንታ ጻፍሳንደትም ናበብደቶ፥ ክርስቶስጎካ አችምሳንደትም Ꮊስግንዳ እ ገቀርት ተያናንከረ የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","ኮነረ ገቅርና ታ ሳብካንታ ፋስምሶ ኦይትምስባብከስካንተኬ ሳብዘንካ ኤሰርሶ ከዛᎺቅባብከስካንታ መያ ማቻንደትግንዳ ኤንገር ስገዳን ስለናር Ꮊቃን ኤድንከስካንታ መያ ማታክዬ። ");
INSERT INTO gyl_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","ኮነረ ገቅርና አይሁድ ማታክባብከስ ክላ ኬዘንጎካ እስረልንከስካ ክክን ባእን ተይድባብከስ ዋልቃ ኤደትቼታ ዘና ማድንግንደኬ ክርስቶስ የሱሰካ ማቻን Ꮊድን ጉርምንካ ክክን ማድባብከስኬ። ");
INSERT INTO gyl_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","እተረ ክታ ዎልቀንታ ፍክስንካ እምምሳን ሳብታ ዉች እምንተንካ ኮ ክላ ኬዘታ ፍክስንባብ ማትቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","ጭልንባብከስ ሙደንዘንካ ቶክስባብ እ ማችንከረ ወራ ጌራ ኮታ ካየንደት ክርስቶስታ አንድርትችን አይሁድንከስካንታ እ ኬዝድንግንዳ ኮና ሳብታ ዉች እምንተና እካንታ እምምሴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","ኮትኮግንደረ ሙደንም ፍዝባብ ሳብካ ኤንገር ስግድባብከስ ጎካ በድ ስላ አችምሳንደትም ኮ ገቀርንታ ፍክስንም ሙደንካንተረ መያ ማዝድንግንዳ እካንታ እምምሴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","ክታ ገቅርነረ ታ ስለናር አሜንድባብከስጎካ በድ ጎግ ዶቅድንዳ ሳብታ ኤጨን ጭላር ዶቅድባብ ክድባብከስኬ ገችንታ ኤረንባብከስካንታ ኤስምድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","ኮነረ ክርስቶስ የሱስ ዎንታ ጮይስንጎካ ቦጃንዳ ስለንካ ሳብታ ገቅርንዘንካ አምሳንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","ክታዘንኬ ክትጎካ ዎንታ ዶቅድን አሜንንጎካ ባዛካይሳ ማትሶቶ ቡዳ ጮጭካ ሳብደር ቅንችምዶቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","ኮካንታ የንታ ቦንቻ ኮት ማድንካንታ የኦል እም የልድን ማጠንካ ጉርምን የ ተችተራክንግንዳ ዋደ የም ጋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","ኮጎከረ ሳብ ባቤንታ እሪ ጉምፈርስቶ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","ጭለዘነረ ፍጨዘን ዶቅድን ኤሀኤድ ሙደና ላም ከት Ꮊብድንዳ ሳብዘንኬ። ");
INSERT INTO gyl_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","ክታ አያንንጎካ የንታዋር ኤደትቼንካ የ ዛብተርንግዳ ይንታ ቦንችምሳን ቆልመናርካ የካንታ እምተርንግንዳ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","ኮነረ ክርስቶስ የንታዋር አሜንካ ገጅድንግንዴ። አነረ ጫጭ ኦይትሰቶ ሶልመናር የ ዛባባብዬ። ");
INSERT INTO gyl_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","ክርስቶስታ ሶልመንታ ዳልግምንኬ ቃልምንካ፥ ጬክን ጋይንተንኬ ጩለረ የልምዳክንዳ ማትንተና Ꮊስከካ ማዳናንከረ፥ ጭልንከስ ሙደንካ ክክን ገቀርት የ ተይድን ዎልቀን የ Ꮊብድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","ሳብታ ጮጭምናር የልሶ የ ጮጭድንግንዳ፥ ኤስንተንዘንካ ስግ ማቻን ክርስቶሰታ ሶልመን የ ኤዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","ይና ዎንታ ዋር ፍግዝድንደትግንዳ ክታ ዎልቀንከካ ዎ ምግዝድንደትምናነረ ዎ ገቀርድንደዘነንካ ሙዳ አንድር ስግስሶ ይድባቤ፥ ");
INSERT INTO gyl_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","ምክስ ኤሄናረረ ኮትኮግንዳ ክርስቶስ የሱሳር ስላ ሙደንካ ስለንክንደትዝንካ ስለንካ የለልታ ክትካንታ ቦንቻ ማታ፥ አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","ይና ጮይስካንታ እስታ ፍክስንተንካ ዞከርስባብ እታ ጳውሎስ፥ የ ኤልምሳን ኤልምንታ ዝግዝድንደት ማቻን ዶቅንት የ ዶቅተርንግንዳ እታ የም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","ሶልመካ ክክ ክክ የታ ዳንዳኤረቶ ሙዳᎺይካ ማተን የንታ ቶቼረቶ Ꮊልስመኬ ክክካንታ ኤእንተካ ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","ሳራትቼንካ ዞክምሰቶ ሳብታ አያንንዘንካ Ꮊፈርድን ዋልቃትቼን ካርስካንታ ዛብከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","የ ኤልምሳንደትᎺይካ Ꮊድን ጉርምንታ የ ኤልምሳንደትግንዳ ዋልቃ ኤደትቼኬ ዋልቃ አያን የንታ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","ኮትኮግንደረ ዋልቃ ጮይስ ዋልቃ አሜንኬ ዋልቃ ስእር ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","ጉጅሰረ ሙደንዘንካ ስግ ማችባብ ሙደንከረ ፍግዝድባብ ሙደንከረ ዶቅድባብ ሙደንተረ ባቤና ማችባብ ዋልቃ ጮይስ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","ኬዛር ማቼ ክርስቶስ እምካንታ ይ ጋይሳንደትከካ ዎ ዋልቃ ዋልቀንካንታ ክታ ዉች እምንተና ዎካንታ እምምቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","ኮነረ፥ “ፈስ ጨዳ ጭለዘን ይ ዉተዳንደትካ በድንከስም ዎእስትዮ ተዬ፥ “ኤድንከስካንተረ ዉች እምንተንም እምሴ” ጋይምሳንደት ግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","ይና ኮ “ፈስ ጨዳ ዉተዴ” ጋይድን ቃለና እርምሶ ኮ ፍጨንዘን፥ ፍጨንዘንከረ ሶስ ይርክን ጋይሳን ካርዘን ክታ Ꮊንችርና ማታክን የለልታ አብ Ꮊረሞክ ሰጅዳ? ");
INSERT INTO gyl_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","ኮና ሶስ Ꮊንቸርስባብ ጉጅሰረ ሙደንም ጮችካንታ ጭላ ሙደንዘንካ ዘርመካ ኖ ዉተድባቤ። ");
INSERT INTO gyl_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","ኖየረ ዋልቃ ዋልቀን ኦይትምስባብከስ፥ ዋልቃ ዋልቀንከስም ሳብዘንካ ኤስርሶ ከዝድባብ፥ ዋልቃ ዋልቀንከስም ክላ ኬዘንም ኬዝድባብከስ፥ ዋልቃ ዋልቀንከስም አሜንድን ኤድን ግዝድባብ፥ ዋልቃ ዋልቀንከስም ኤስዝድባብከስ ማታባብ እምንተንከስም ከትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","ኮትኮመረ ክት ይሳንዳ ክርስቶስታ ኤደትች ማቻንዳ ምክስ ኤሄና ዎድምድንግንዳ አሜንድባብከስ ክርስቶሳር ማችባብከስታ ፍክስንካንታ ኬትም ግግስካንቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","ኮትኮግንደረ ሳብታ ይንችን ኤስንተካ አሜንካ Ꮊፈርድንደት ዋልቃትችንደር የልሶቶ፥ ክርስቶስ ቦድመኬ ጮጭ ክት ማቻንግንዳ ዎተረ ጮጭ ኤድ ዎ ማተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","ይና ኮዘንካ ፈንክ ኤድንከስታ ጩባ ታውንዘንኬ ገስስ ግግምሳን ኮተርዝድን ኤስስ ዞገንኬ ጭጭንካ ኦስኬ ፈንክ Ꮊንቅምሶ ተይምድን ኡለንከስግንዳ ማታዮቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","ስግስሰረ ዶፈን ሶልመካ ኬዘሮቶ ሙዳ ሪከረ ዱራ ማችባብ ክርስቶስደር ጋጵዶቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Ꮊክ Ꮊክ ዘነንታ ሱከንከስ የችምድንዳ ክርስቶስኬ፥ ዘነነረ ሙዳ ክክ የድምሳንዳ ሱከንከስጎኬ፥ ኮካንታ ዋልቃ ዋልቃ ዘነንከስ ከትካንታ እመርሳን ዝግዝድን ፍክስን ፍግዝድንካ ዘነና ሙዳ ጋጵዴ፥ ሶልመንከረ ዛብዴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","ይና ኮዘንካ ፈንክ ገቅርና ኬታ ዉች ማቻንግንዳ አይሁድ ማታክባብከስግንዳ Ꮊይ ዶቀቴ ጋይስቶ ጮይስታ ላምካ ኤግዝምዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","ኬታ ማክቼና ኡምቴ፥ ኬታ ኤስክሳ ነግንተንኬ ኬታ ቀምስንጎካ ሳብ እምድን ሰንፔዘንካ ፋስምተኬ። ");
INSERT INTO gyl_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","ኦስና ከታዘንካ ካይድንካ ቱነንከስም ሙዳ ቦድካንታ ኬታ ይንታ ማተን ዋሄታ አንግርንካንታ ስክስት እምተኬ። ");
INSERT INTO gyl_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","የታ ማቼ ክርስቶስጎካ የ ኤሳንደና ኮግንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","ገታ ክትጎካ የታ ኤሰርተቴ፥ የሱሳር ዶቅድን ዶፈንንታ የድን ክታዘንካ ኤስተቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","ኮካንታ ገስሶ ጎማር ጎርዝድን አንግርካ ባጃን እሪምሶ የ ዶቅድ Ꮊቃንደትም፥ የንካ የካ ፍዝምሳን ገሳ እዘን Ꮊልእስከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","የንታ ቡደንኬ ማክቼንካ ኦክማ። ");
INSERT INTO gyl_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","ዶፈን ጭልምኬ ሳብካንታ ፋስምስባብ ሳብታ ካምስካ ፍዝምሳን ክላ ኤደትቼን ቆበርከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","ኮካንታ ማልት Ꮊይ ኬዘቴ፥ ዎታ ሙደና ዋልቃ ዘነንታ ሱካ ማቻንኦል ክክ ክክ ዎ ዶፈንን ኬዛ። ");
INSERT INTO gyl_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Ꮊረንግርካ ዋጭተረትዳት! የንታ ዋጭንዘን ማቼ ጎማ Ꮊይ ፍክሰቴ፥ የንታ ዋጭነረ ነጋ ጋይማክናና Ꮊይና እንደናር Ꮊይ አርዳ። ");
INSERT INTO gyl_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","ዳብሎስካንታ አርድንተታ ዉልፋ Ꮊይ እመቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","ድብድ Ꮊቅባብ ኮዘንካ ኦስ Ꮊይ ድባ። ስግስሰረ ማጠርስባብከስካንታ እምምድንግንዳ ብራ ክታ ዶቅድንግንዳ ገታ ይንታ አንካ ኡርማ ርን ክት ፍክሳ። ");
INSERT INTO gyl_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","ቦድሶ የንታ አፋርንካ ዳቅል ኬዛ Ꮊይ ዉታ፥ ኬዛር ማቼ ኤሰርድባብከስም ጉርምዝድንደትኬ ዳቅስካንታ መይድን፥ ኤድንከስካንተረ ዝግዝድን ኬዘን ኬዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","የ ቆት ተይምሳን ሰጨና ዶፈን ማድንግንዳ የካንታ እመርሳን ጭል ሳብታ አያንን Ꮊይ ሞርእሰቴ። ");
INSERT INTO gyl_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","ጫቅም፥ ስነር፥ ዋጭ፥ አዉል፥ የክኬ Ꮊረርየረ ዳቅል ሙዳ የንዘንካ ኦስ ጎተራ። ");
INSERT INTO gyl_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","ስግስሶ ክክ ክክታ ኡርመኬ አተርድባብ Ꮊልስመኬ ቡዳርንካ አጨርድባብ ማትከቴ፥ ሳብ ክርስቶሰካ ነጋ የም ጋይሳንግንዳ የተረ ክክ ክክ ነጋ ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","ይና ሶልምምስባብ ይንችንከስግንዳ የተረ ሳብታ ካምስንም ጎርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","ክርስቶስ ዎም ሶልምሳንግንደኬ ሳብም ጉርምዝድንዳ ኡርማ ዎስማ ዶቅድንዳ እምንተኬ ካስ ማስሶ ይንታ ሰንፔንም ዎካንታ ስክስትዮ እምሳንግንዳ የተረ ሶልመካ ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","በልም፥ ቱና፥ ድሳ ኬናከስግንደን ፍክስ ነግሶ ኬዛ ዎራ ሳብካንታ ፋስምሳን ኤድንከስታ ባንግር ቦድሶ Ꮊይ ኤስማ። ");
INSERT INTO gyl_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","ስግስሰረ ሳብም ጋለትከት ዳት ይምኤርዝድንደትምኬ ዳቼታ ኬዘም አነረ ሴካ ኬዛ የም ዝክሳዬ፥ ኬናግንዳ ሪና የካንታ ኡርድንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","ማነም ኦካኦግድባብ ማቼረ፥ Ꮊምንመረ ቱነታ ፍክስንም ይድባብ ማቼ አነረ ጭጭመተረ ጮይስማታክን ሪንካንታ ጎይንድባብግንዴ፥ ኮካንታ ክርስቶሳርኬ ሳብ ባንችማረረ ባእ ክታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","ከትኬና ሪንከስጎካ ክትምዳክን ኤድንከዘን ሳብታ ዋጭና Ꮊድንካንታ Ꮊየሰነረ ማዳክን ኬዘካ Ꮊይ የም ገስሳ። ");
INSERT INTO gyl_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","ኮካንታ ከታኬና ክትምዳክባብ ኤድንከስካ ክክን Ꮊይ ዙገርቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","ኤና እሪ የታ ኡምንታ ዋር ዶቅድ Ꮊቀቴ፥ ታ ማቼ የታ ጮይስታ የ ማቻን ኦል የታ ሳክመቴ፥ ኮካንታ ሳክማር ዶቅድባብ ኤድንካስግንዳ ኦንግከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","Ꮊረታ ጋይሴ ኡርመትች ሙዳ ጭለትችንተኬ ዶፈንንታ አፍ Ꮊፈርድንዳ ሳክመዘንኬ። ");
INSERT INTO gyl_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","ኮካንታ ጮይስም ጉርምዝድንዳ ሪና Ꮊራ ማቼረ ዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","ኦስ ሳክመናር ዉችሰቶ መያ ማስከት ዳት አፍ ካያ ማቻን ኡምንታ ፍክስንካ ክክን Ꮊይ ማተቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","ኡማር ዶቅድባብ ኤድንከስ አቸካ ኬት ይድን ሪን ኬዛካንታ ዎራ ኦስንዝዴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","ሙዳ ሪና ኦስ ሳክማር ዉድንካ ዶፈና መያ ማትሶ Ꮊፈርተሬ። ");
INSERT INTO gyl_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","መየካ Ꮊፈርድንዳ ሙዳ ሳክሜ፥ ኮ ኦላር፥ “የና ግንእድባቦ ንግካ፥ ደእናርከረ አምካ፥ ክርስቶሰረ የስካንታ ሳግዝዴ” ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","ይና Ꮊስግንዳ የ ዶቅተርናከረ አግምሶ ገቀርከቴ፥ ኤጨንባብከስግንዳ ዳት ዳቸንከስግንዳ Ꮊይ ዶቀቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","ሰጨንከስና ዳቅለኬ፥ ስለንም የንታ ማታ ካንታ ማስከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","ኮካንታ ጮይስታ ጋይተና Ꮊራ ማቼረ ገቀርከቴ ዳት ዳቼንከስ Ꮊይማተቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","ኦስ ካይንታር የም ጎርዝድንዳ ማቻንካንታ ዎይን ዎጭምንካ Ꮊይጎዘቴ፥ ስግስሰረ አያን ጭልንካ ጮጭከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","የችከኬ ዴእስካ አያናረረ ሳችካ ክክ ክክ ኬዝምከቴ፥ የንታ ቡዳርንካ ደእስኬ የቺካ ጮይስም ጋለትከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","ዎንታ ጮይስን የሱስ ክርስቶስታ ላምንካ ሙዳ ሪንካንታ ሙዳᎺይካ ሳብ ባቤንም ጋለትከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","ክርስቶስካንታ ቦንቻ ማድንግንዳ የንታ ዋርንካ ዋልቃ ዋልቀና አብንከስካንታ ቆልማ። ");
INSERT INTO gyl_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","የታ ይእስባብ ማነንከሶ! ጮይስ የሱስካንታ የ ክትምድንግንዳ የንታ ክእስንከስካንታ ክትምከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","ክርስቶስ ምክስ ኤሄንታ ዱራ ማቻንግንዳ ክእስነረ ኬነንታ ዱሬ፥ አነረ ክርስቶስ ይንታ ዘና ማቻን ምክስ ኤሄንም አቅዝዴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","ምክስ ኤሄንከስ ክርስቶስካንታ ክትምድንግንዳ ኮትኮግንደረ ይእስባብ ማነንከስ ሙዳሪካ፥ ይንታ ክእስንከስካንታ ኬት ክትማ። ");
INSERT INTO gyl_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","ክእስንከሶ! ክርስቶስ ምክስ ኤሄንከስም ሶልምሳንግንደኬ ይንታ ማተንመረ ኮትካንታ ስክስት እምሳንከካ የተረ የንታ ኬነንከስም ሶልምከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","ክርስቶስ ኮም ክት ይሳንዳ ምክስ ኤሄንም ሳብካንታ ፋስምስንዳ ማስካንታ ዝግሴ፥ ክት ሳብካንታ ፋሳንደረ ይንታ ቃለንጎካ ሎቀካ ስእሴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","ኮግንደካ ምክስ ኤሄንም ጭም አነረ ባላ ቱችኬ ኮም ካምድን አብ ዳቅልር Ꮊፈራክናና ሳብካንታ ፋስምስአንዳ፥ ቦርድር ካየንደትኬ ላቅምድንዳ ማስሶ ይንደር ሳንዝዴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","ኮትኮግንደረ ክእስንከስ ይንታ ማተንም ሶልምድንግንዳ ኬታ ይንታ ኬነንከስም ሶልማ ዝግዝዴ፥ ይንታ ኬነንም ሶልምድባብ ይንታ ማተን ሶልምዴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","ይንታ ገታ ዘነን ግርድባብ Ꮊየነረ ካዬ፥ ስግስሰረ ክርስቶስ ምክስ ኤሄንካንታ ይድንደትግንዳ እችዝዴ ኡርስተረ ካርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","ዎተረ ክርስቶስታ ዘኖቴ፥ ");
INSERT INTO gyl_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","“ኮጎካ ኤድ ይንታባበንምኬ እንደንም ዛቅሶ ይንታ ኬነንካ ክክን ዋልቃ ማተሬ፥ ቃስተነረ ዋልቃዘና ማደኬ” ጋይምቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","ኮና አችምሳን ኬዘና አንድሬ፥ ኮትኮመረ እ ጋይድንዳ ክርስቶስጎኬ ምክስ ኤሄንጎካ ካምስ ማስስቴ። ");
INSERT INTO gyl_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","ኬዛር ማቼ ኮና ሪና የመረ ይይዝግዝድንዴ፥ ኮካንታ ክእስ ይንታ ኬነንም ይንታ ማታግንዳ ማስሶ ሶልማ፥ ኬነነረ ይንታ ክእስንም ቦንቻ። ");
INSERT INTO gyl_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","ይንችንከሶ! የም አጭባብከስካንታ ጮይስካ ክትምከቴ፥ ኮነረ ዝግዝድንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","“የስታ ባቤንምኬ እንደንምኬ ቦንችካ” ጋይድን ክቴና ጉርም ቃላ ዶቅድንዳ ኤና እሪ ክቴ፥ ");
INSERT INTO gyl_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","ኮትኮመረ ጉርም ቃለን የስ ይሴ “ሙዳ ሪይና የስካንታ ኡርተረ፥ ኮ ፍጨዘን ስለና የስታ ቃልተሬ” ጋይድንዴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","የተረ አጥመንባብከሶ! ጮይስ የሱሰታ ዎገን ኤስሰረቶ፥ ዳቅል ፍክስናርንካ ማሰረቶ Ꮊገካ ከትም ጋጵስከት ዳት የንታ ይንችን ዋጨረቶ የንታዘን Ꮊይሰነርሰቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","የታ አይለንከሶ! ዋሄዘን የንታ ማታቆልስባብከስካንታ ጳሰርንደትኬ ጭጭካ ክትምከቴ፥ ክርስቶስካንታ የ ፍግዝድንደትግንዳ ኡርማ ቡደካ ከትካንታ ክትምከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","የ ክትምድንደረ ሳብታ ጋይተንም ቡዳርንካ ኬት ቦድባብከስግንዳ ክርስቶሰታ ፍክስንባብከስግንዳ ማትሰቶ ዳት፥ ኤድም ጉርምስካንታ ጋይሰቶ ሰድምካንታ Ꮊይማታ። ");
INSERT INTO gyl_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","ኤድም ማታክናና ጮይስካንታ የ ፍግዝድንግንዳ ማትሰቶ ኡርማ ገቅርካ ፍክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","አይለነረ ማታ አነረ ማተን ቆልስባበረ ዋልቃ ዋልቃባብና ይ ፍክሳን ኡርማ ፍክስንካ ጮይስደርካ ናክንም ክት ተይድባብ ማትንተን የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","የተረ ማተን ቆልስባብከሶ! ኤታ ባላካንታ ኦስንዳክባብ የንተኬ ከተካ ጮይስ ጭላር ዶቅድንደትግንዳ ገቅርካ ኬዛ ዝግመትን ዛቅሰቶ የንታ አይልንከስካንታ ኡርመንም ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","ይና ጮይስያርኬ ክታ አንድር ዎልቀንካ ዛብከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","ዳብሎሰታ ጩባ ፍክስን የ ግርተርንግንዳ ሳብታ ዳም ካችምን ሙዳ ቆበርከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","ዎንታ ዳምና ኤድካ ክክን ማታክናና ኮ ኡም ፍጫሙደንዘን ፍግዝድባብከስታ ገችንባብከስካ፥ ኤረንባብከስኬ ኮ ኡም ፍጫ ሙደን ቆልድባብከስካ ክክን ጭለዘን ዶቅድን ቱና አያንንከስታ ዳምንባብከስካ ክክኔ። ");
INSERT INTO gyl_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","ኮካንታ ዳቅል ሰጨንካ ይምኤንባብታ ዎልቀን ጋምካንታ የ ማተርንግንደኬ ሙደንመረ ቦድሰቶ ዛብሶ ዎእካንታ የ ማተርንግንዳ ሳብታ ሙዳ ዳም ካችምን አምስከቴ! ");
INSERT INTO gyl_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","ይና ዶፈን የንታ ዎክ ጫምናር ሶቅርሰቶ ኦንገዘን ኤድ ስብልም ቆበርድንግንዳ ጭለትቼንም ቆብርሰቶ፥ ");
INSERT INTO gyl_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","ሳራትቼንታ ክላ ኬዘንም ጫማግንዳ የንታ ዱትናር አርችሰቶ ግግምካ ዎእከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","ኮ ሙደንዘንከረ ስግ ኖሀግንዳ ሎግንጅድባብከስ ዳብሎስታ ዶንግን ሙዳ የ ካይስዝድንደትም አሜንን ግትማግንዳ የድከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","አቅንተንም ማተዘን ቆጵግንዳ የንታ ማተንዘን ጉፍከቴ፥ ኮትኮግንደረ አያን ጭልንዘንካ Ꮊፈርድንደትም ዳምታ ማሰንም የድከቴ ና ኮነረ ሳብታ ቃለኔ። ");
INSERT INTO gyl_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","ሙዳᎺይካ አያን ጭልንካ ጎርስመረቶ ምክስከቴ። ኮ ገቅርንካ ሳብ ጭልስባብ ኤድንከስካንታ ንግስንደትኬ ዳቅሶ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","ክላ ኬዘንታ አችምሳንደትም ጳስካይሳ እ መያ ማዝድንግንዳ፥ እ ኬዝድንᎺይከረ ዝግዝድን ቃለና እምምድንግንዳ እካንተረ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","ታየረ ስብል ዛንካ ዞከርስቶ ኮትኮ ክላ ኬዘንታ ክተምስባብቴ፥ ኮካንታ እም ዝግዝድንደትከካ ጳስካይሳ እ ኬዝድንግንዳ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","ሶልምምስባብ ዎንታ እስመንኬ ጮይስ የሱሰታ አሜንምሳን ፍክስንባብ ቲኪቆስ እጎክንዳ Ꮊስግንዳ ማዳናንከረ አና Ꮊራ ፍክስምዳናንከረ ሙዳ ሪን የካንታ ኬዝተሬ። ");
INSERT INTO gyl_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","ኮካንታ ዎታ Ꮊስግንዳ ዎ ማቻናንከረ የ ኤስተርንግንደኬ የመረ ዳቅዝድንግንዳ ጋይንተካ ክትም የንደር ኦይትቴ። ");
INSERT INTO gyl_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","ሳብ ባቤንዘንኬ ጮይስ የሱስ ክርስቶስዘንካ ሳራትች፥ ሶልመኬ አሜንካ ክክን እስመንከስካንተኬ ምችነንከስካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","ነግዳክን ሶልመካ ዎንታ ጮይስን የሱስ ክርስቶሰም ሶልምድባብከስ ሙደንካንታ ሳብታ ዉች እምንተና ከትካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("PP1_1","080_1_1","PHP","1","1","1","የሱስ ክርስቶስታ ፍክስንባብ ማችባብከስ ጳውሎስዘንኬ ጢማቶስዘንካ፥ ፍልጵስዮስ ካተመናር ዶቅድባብከስካንታ፥ የሱስ ክርስቶስካ ሳብካንታ ፋስምስባብ ሙደንካንታ፥ ኮትኮግንደረ ምክስ ኤሄናር ጎርዝድባብከስካንተኬ ከትም አሌን አልድባብከስካንታ፥ ");
INSERT INTO gyl_vpl VALUES ("PP1_2","080_1_2","PHP","1","2","2","ዎንታ ባቤን ሳብዘንኬ ዎንታ ጮይስን የሱስ ክርስቶስዘንካ ዉች እምንተንኬ ሳራትቸንካ የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("PP1_3","080_1_3","PHP","1","3","3","የም እ ገቀርድንᎺይካ ሙዳ እስታ ጮይስን ጋለድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("PP1_4","080_1_4","PHP","1","4","4","የ ሙደንካንተረ እ ምግዝድንᎺይካ ሙዳ እስታ ምክስና ጉርምካ ጮጫንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_5","080_1_5","PHP","1","5","5","እርንደትዘንካ የድሶ ታካ የለልታ ክላ ኬዘንም ሳባክንካ እንካ የካ ፍግዝድባብከስ የማቻንኦል ሳብም ጋለድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("PP1_6","080_1_6","PHP","1","6","6","ኮም ኡርማ ፍክስን የንካ የጅባብ ጮይስና፥ የሱስ ክርስቶስ ፍርደንካንታ Ꮊድን ሰጨንካ ቦድምድንደትም እታ ኤስትቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_7","080_1_7","PHP","1","7","7","ታ እ ዞክና ኤሀር ዶቅድንኬ እ ዞከርተርንደታ እሪ ክላ ኬዘንታ ዶፈንን ካርስስካንተኬ ኮትመረ ዳቅስስካንታ ሳብ ይንታ ዉች እምንተንካ እካንታ እምሳን እዋንካ የታ ሙደነረ ካስምድባብከስ የማቻንኦል ሙዳᎺይካ እስታ ቡዳር የም ገቀርድቴ። ኮካንተረ የጎካ እካንታ ኤስምድንዳ ኡርማ ገቅርዬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_8","080_1_8","PHP","1","8","8","የሱስ ክርስቶስታ ሶልመንካ የ ሙደንከስም Ꮊራከካ እ የም ሱነርዳናከረ ሳብ እስታ ማርኬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_9","080_1_9","PHP","1","9","9","የንታ ሶልመና ኤሰኬ ገቀርት ተይንታ ጮጫንዳ ማትሶ ጋጰሮ አይድንግንዳ እታ ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_10","080_1_10","PHP","1","10","10","ኮነረ እንድንካ ኡርድን ሪ የታ የ ፋስት ኤስተርንግንደኬ ክርስቶስ ማት ክት Ꮊድን ሰጨንካ ጭለጭልኬ ኦስንዝድን ሪ ካየንባብከስ ማትሰቶ የ Ꮊፈርድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_11","080_1_11","PHP","1","11","11","ኮግንደከረ የንታ ሰንፔና የሱስ ክርስቶስዘንካ Ꮊፈርድን ጭለትችንታ አፍ ጮጫንዳ ማትሶ ሳብካንታ ቦንቸኬ ጋለት Ꮊፍስዝድባብከስ ማተረቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_12","080_1_12","PHP","1","12","12","እስመንከስኬ ምችነንከሶ! እስታዘን የልሳን ሪና ሙዳ ክላ ኬዘና ስግስሶ ዳልግድንግንዳ ይይንተን የ ኤዝድንግንዳ እታ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_13","080_1_13","PHP","1","13","13","እተረ እ ዞከርሳንዳ ክርስቶስጎካ ማትንተን ባንችንከስ ዶቅድን ኤሄን ካርዝድባብከስኬ አብንከሰረ ኮታር ዶቅድባብ ኤድንከስ ሙደና ኤዝደኬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_14","080_1_14","PHP","1","14","14","እስታ ዞክርንጎካ አሜንድባብ እስመንከሳርንካ በድንከስ ኤንገር እርንደትዘንካ ስግስሶ ጮይስካ አሜንምድባብከስ ማቼኬ፥ ኮካንታ ሳብታ ቃለን ጳስካይሳ ኬዛካንታ ኤና እሪንደትዘንካ ስግስሶ ሙቅም Ꮊፍተኬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_15","080_1_15","PHP","1","15","15","ማታጋካ ዳት ዋልቃ ዋልቀንከስ ክርስቶሰታ ክላ ኬዘን ኤስምዝድባብከስ ዳቅል ቀምስምካ፥ አብንከሰረ Ꮊይዘንካ Ꮊይ ቶግዳ ጋይድን አያንኬ፥ አብንከስ ማቼ ክርስቶሰም ሳባግድባብከስ ሉላ ቡዳርንኬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_16","080_1_16","PHP","1","16","16","ከታኬና ሳብታ ቃለን ሉላ ቡዳርንካ ኤስምዝድባብከስ ሶልመዘንካ አምሳንዴ፥ ከተረ እታ ክላ ኬዘንታ ዶፈንን ካርስስካንታ ኮታር እ ዶርምሳንደትም ከት ኤዝድንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_17","080_1_17","PHP","1","17","17","ከታኬና ማቼ ክርስቶስጎካ ዎብስሶ ከት ሳባግድንዳ ሉለካ ማታክናና ይንታ ማተን ሶልመኬ እስታ ዞክርንዘን ጉጅምድን ማጣ እዘን ተይᎺድካንታ ገቅርሰኬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_18","080_1_18","PHP","1","18","18","ኮነረ ኩን ኮት ማታጋካ ዳት ኮትኮካ እም ጉርምዝዴ፥ ካምስሰረ ማታ ዶፈንከረ፥ ሙዳ ጎግንከረ ክርስቶስ ሳባክምዴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_19","080_1_19","PHP","1","19","19","አብ እ ጉርምድን ጎግና የንታ ምክስንኬ የሱስ ክርስቶስታ አያንታ አሌንካ ባዛካይሳ እ ዉድንደትም እ ኤዝድንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_20","080_1_20","PHP","1","20","20","ቦድሶ እ ኦስንዳክንደትም Ꮊድን ጉርምንካ ካርዝድቴ፥ ኬዛርንካ ማቼ ሙዳᎺይካ እ ይድንግንደኬ ታካ ሰንፔካ እ ዶቅሰረ አነረ እ ደእሰረ ክርስቶስ እስታ ኤደትቼንካ ቦንችምዴ ጋይስቶ ሙቅምካ ኬዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_21","080_1_21","PHP","1","21","21","ኮካንታ እስታ ሰንፔና ጋይንትና ክርስቶስካ ዶቅንትዬ፥ ደእነረ እካንታ መይድንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_22","080_1_22","PHP","1","22","22","ማታጋካ ዳት ኮ እስታ ዋሀ ኤደትቼንካ ኦስ እ ዶቅደስናና አፍይ ዶቅድን ፍክስም ፍክሳት ጋይንትዬ፥ ማችንከረ ኮዘንካ ኦስ ዶቅንትዘንኬ ደእዘንካ Ꮊምንም እ እዳናከረ እታ ኤሳይቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_23","080_1_23","PHP","1","23","23","ከትኬና ቃስተን ገቅርንከስታ ዎክያር እታ የድምትቴ፥ ዋልቃጎካ ክርስቶስካ ክክን ማትና ሙደንዘንካ ስገድን ሪ ማቻንካንታ ኮ ዶቅንትንዘንካ ፋስምስቶ ክርስቶስካ ክክን ማትን ዝግድቴ፥ ኮነረ ክርስቶሰካ ክክን ዶቅና እንድንካ ኡርድንዳ ማቻንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_24","080_1_24","PHP","1","24","24","ኬዛርንካ ማቼ እስታ ሰንፔካ ዶቅና የካንታ ስግ ዝግዝድንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_25","080_1_25","PHP","1","25","25","ኮትኮካ አሜንምካ እታ ደእዘንካ አቅስቶ የንታ አሜንና ጋጵድንግንደኬ ጉርምን የ Ꮊብድንግንዳ የ ሙደንካክክን ዶቅተርንደትም እታ ኤዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_26","080_1_26","PHP","1","26","26","እተረ አናካርንካ የንደር እ Ꮊድንካ እጎካ የንታ ዶቅድንዳ ጋይርና የሱስ ክርስቶሰካ በተሬ። ");
INSERT INTO gyl_vpl VALUES ("PP1_27","080_1_27","PHP","1","27","27","ይና ሙደንዘንከረ ስግ የንታ ዶቅንተና ክርስቶስታ ክላ ኬዘን ጋለችዝድንዳ ማታ፥ ኮነረ እታ Ꮊድስቶ የም ሰጀረ አነረ የንዘንካ እ ጎተርሰ ዋልቃ ገቅርካ የንታ ዳቅሶ ዎእንተንኬ ክላ ኬዘን ዋልቃትችካ የልስካንታ የንታ ጉርንም ኤሰርድቴ፥ ");
INSERT INTO gyl_vpl VALUES ("PP1_28","080_1_28","PHP","1","28","28","የም ግርድባብከስመረ Ꮊራ ሪከረ Ꮊይ ጳሰቴ፥ ኮነረ የንታ ሙቅምና ኬትካንታ ካይንተታ ቃዉታ ማድንካ የካንታ ማቼ ሳብዘንካ ማቻን የንታ አቅንተንታ ቃዉቴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_29","080_1_29","PHP","1","29","29","ክርስቶስካንታ የ ፍግዝድንግንዳ የካንታ እመርሳንዳ ክትካ Ꮊክ የ አሜንድንግንዳ ማታክዶቆ ክትጎካ ማጣ የ ተይተርንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP1_30","080_1_30","PHP","1","30","30","ኮካንታ ታ እንካ ክክን ማጠንም ካስምድባብ ማተቴ፥ ኮነረ ማጠና ኤና ኮታ እሪ እዘን የልስንካ የ ሰዳንደትኬ ታየረ እዘን የላዶቅድንዳ ማትንተን የ ኤሰራዶቅድንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_1","080_2_1","PHP","2","1","1","ክርስቶሳር ዳቅንታ የንታ ዶቅሴ፥ ክታ ሶልመንከረ የ ዳቅሳንዳማቼ፥ አያን ጭልንካ ክክን ዋልቃትች የንታ ዶቅሴ፥ ክክ ክከረ ላቅም እዘንኬ አጭርንም የ ሰችሴ፥ ");
INSERT INTO gyl_vpl VALUES ("PP2_2","080_2_2","PHP","2","2","2","ዋልቃ ገቅርንካ፥ ሶልመንካ፥ አያንካ፥ የ ገቀርድን ሪካ ኤኤረቶ እስታ ጉርምና ቦድማ ማድንግንዳ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_3","080_2_3","PHP","2","3","3","የንታ ማቴን ይርክሳ ይይንተካ አብ ኤድንከስ የንዘንካ ስግሶ ኡርማ ከት ማድንግንዳ ማስሰቶ ፋይድከት ዳት የንታ ማቴን ሶልመካ አነረ “እግንዳ Ꮊይዶቅዳ” ኩን ጋይንተካ ጬቀሮ Ꮊረሰነረ Ꮊይ ይየቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_4","080_2_4","PHP","2","4","4","ኮትኮግንደረ ዋልቃ ዋልቀና ይንታ ማታካንታ መይድንደትም Ꮊክ ማታክናና አብ ኤድንካንተረ መይድንደትም ክት ገቅራ። ");
INSERT INTO gyl_vpl VALUES ("PP2_5","080_2_5","PHP","2","5","5","ኮግንደካ የሱስ ክርስቶስ ሰችሳን ይንታ ማቴን ይርክሳ ይይንተና የንታ ዋረረ ዶቅ ዝግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_6","080_2_6","PHP","2","6","6","ኖ ሙዳᎺይካ ይንታ እዘንካ ሳብዬ። ማታጋካ ዳት ሳብካ ክክን ክትም ጋድ ማስዝድንደትም ሳብም ካምሶ ዶቅንተን ዎልቀካ ይ የጃንግንዳ ፋይዳክዬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_7","080_2_7","PHP","2","7","7","ስግስሰረ ይንታ ዶቅድን ቦንቼን ሙዳ ዛቅሶ አይላግንዳ ማትሶ Ꮊፈርሴ ኤድግንደረ አጥምሴ፥ ኤድም ካምሰረ መያ ማቼ፥ ");
INSERT INTO gyl_vpl VALUES ("PP2_8","080_2_8","PHP","2","8","8","ይንታ ማተን ይርክሳ ይሴ፥ ደእ የለልታ፥ ኮነረ ማዝቀልንዘን ሮከርሶ ደእ የለልታ፥ ክትምስባብ ማቼ። ");
INSERT INTO gyl_vpl VALUES ("PP2_9","080_2_9","PHP","2","9","9","ኮጎካ ሳብ ሙደንዘንካ ስግ ዶቅድን ቦንቻ ካርናር ጬክሳ ይሴ፥ ላም ሙደንዘንካ ስገድንደትም ላም ክትካንታ እምሴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_10","080_2_10","PHP","2","10","10","ኮካንታ የሱስታ ላምንካንታ ቦንቻ፥ ጭለዘንከ ፍጨዘን፥ ፍጨታ ታመከረ ዶቅድባብከስ ሙደና ከታ ይንታ ቡቀንካ ጉምፈርደኬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_11","080_2_11","PHP","2","11","11","ከታ ይንታ አድምንከረ “የሱስ ክርስቶስ ጮይስዬ” ጋይሰኮ ማርክርካ ሳብ ባቤንካንታ ቦንቻ እምደኬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_12","080_2_12","PHP","2","12","12","እስታ ገርነንከሶ! እታ የንካ ክክን እ Ꮊቃንደትካ ሙዳᎺይካ ክትምድባብከስ የ ማቻንግንዳ፥ ስግስሰረ ታ የንዘንካ እ ጎተርሳንደትካ እንድንካ ክትምድባብከስ የ ማድንግንዳ የም ገቀርስዝድቴ፥ ኮካንታ የታ ዋልቃ ዋልቀና የንታ አቅንተን ቦድማ ማስካንታ ጳስኬ ቦንቸካ ዳቅሰቶ ፍክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_13","080_2_13","PHP","2","13","13","ሳብ ይንታ ኡርማ ጋይተንግንዳ ክትምን የካንታ እመሮ ይንታ ገቅርንም ቦድማ ማስካንታ የንካ ፍግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_14","080_2_14","PHP","2","14","14","Ꮊምንመረ ፍክስ የ ፍግዝድንደትᎺይካ Ꮊይ ጉንድመቴ፥ አነረ Ꮊይ ቤርመቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_15","080_2_15","PHP","2","15","15","ኩነረ ማቼ ኮ ዎብከ ዳቅል አጥርንታ ዎክያር ኦሰንዝድንደትኬ ይንኤእርዝድንዳ ካየንባብ ጭለጭል ሳብታ ይንች ማትንተካ ኮ ፍጫሙደንዘን ቤዝንከስግንዳ ሳክስተረቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_16","080_2_16","PHP","2","16","16","ኮነረ ማድንዳ ሰንፓ Ꮊፈርድን ቃለን ዛቃከትዶቆ ዳቅስሰቶ የድንተኬ፥ ኮግንደካ እስታ ዞደነረ ማታ ፍክስና ዉችኩን ማትሶ ነገዳክንኦል ክርስቶስ ማትሶ ክት ᎺድንᎺይካ እ ጋይርድንደታ ጎግ ዶቅተሬ ጋይንትዬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_17","080_2_17","PHP","2","17","17","ሳብካንታ አሜንካ የ እምድን ካሲንኬ ሳብታ ዎንንዘን እስተረ ሰንፔና ጉጅምሶ ካሲ ማትሶ እምምደረ ዎራ እም ጉርምዝዴ፥ የንከረ ክክን አንድር ጉርምድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_18","080_2_18","PHP","2","18","18","ኮትኮግንደረ የታ ጉርምሰቶ እመረ የንታ ጉርምንካ እ ጉርምድንግንዳ ይስዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_19","080_2_19","PHP","2","19","19","እታ የጎክንደትም ኤስርካ እ ዳቅድንግንዳ ጢማቶሰም ሳነካ የንደር ኦይትካንታ እ ማድንደትም ጮይስ የሱሰካ ጉርም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_20","080_2_20","PHP","2","20","20","የጎክንደትም ቡዳርንካ ገቅርድባብ ጢማቶስዘንካ አብ ኤድ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_21","080_2_21","PHP","2","21","21","አብንከስ ማቼ ይም መይድንደትም Ꮊክ ዝግደክዳት የሱስ ክርስቶስታ ፍክስንጎካ Ꮊረነረ ገቅር ከታ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_22","080_2_22","PHP","2","22","22","ጢማቶስታ አሜንምና ጰጭምሶ ክትካንታ ማርከርምስባብ ማትንተኬ እንከረ ክክን ባቤንኬ ይንችክንግንዳ የካ ማትሶቶ ክላ ኬዘንም ኤስስንካ ፍግዝድ ዎንታ Ꮊቅንተን የታ የንታ ማታርንካ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_23","080_2_23","PHP","2","23","23","ኮካንታ እስተና Ꮊረዘን ኮት የልዳናከረ እ ኤሳንደታ ቡሪ ጢማቶሰም ሳነካ የንደር እ ኦይድንደትም Ꮊድን ጉርም ይድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_24","080_2_24","PHP","2","24","24","ኮትኮግንደረ እታ እስታ ማታርንካ ሳነካ የንደር እ Ꮊድንግንዳ ጮይስ እም አሌንም አልዴ ጋይስቶ አሜንምድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_25","080_2_25","PHP","2","25","25","ኮትኮግንደረ እም ዝግዝድንደትካ ሙዳ አለን እም አልተርንግንዳ የ ኦይችባብ እስታ እስመን ኤጳፍሮድቱስም ኦስ የንደር ኦይት ዝግዝድንዳ ማቻንደትም ኤስትቴ፥ ኖ እንካ ክክን ዎእስባብ ዳምንባብኬ እንካ ክክን ላኮይት ማትሶ ፍግዝድ Ꮊቅባቤ። ");
INSERT INTO gyl_vpl VALUES ("PP2_26","080_2_26","PHP","2","26","26","ክትም ኦስ የንደር እ ኦይድንደረ የ ሙደንመረ ሰድንካንታ ክት ሱነርሳንካንተኬ የተረ ክታ ሰቅርንም የንታ ኤስርንካ ክት ማጠርሳንጎኬ። ");
INSERT INTO gyl_vpl VALUES ("PP2_27","080_2_27","PHP","2","27","27","ዶፈንካ ኖ ሰቀርሶ ደእካንታ የልሶ Ꮊቄ፥ ኬዛርንካ ማቼ ሳብ ክትም አጨርሴ፥ ክትካንታ Ꮊክ ማታክናና ሞርእዘን ሞርእ ጉጅምዳክንግንዳ እካንተረ ዎራ አጨርሴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_28","080_2_28","PHP","2","28","28","ኮካንታ የታ ክትም ሰድሶ የ ጉርምድንግንደኬ እስተረ ሞርእና ነግድንግንዳ ክትም ኦስ የንደር ሳነካ ኦይትካንታ ዝግትቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_29","080_2_29","PHP","2","29","29","ይና ጮይስካ ክት አሜንድንኦል አንድር ጉርምካ ክትም ሞከቴ፥ ክትግንዳ ዶቅድባብ ኤድንከስም ሙዳ ቦንችከቴ። ");
INSERT INTO gyl_vpl VALUES ("PP2_30","080_2_30","PHP","2","30","30","የታ ቅንችካ Ꮊፈርሰቶ እካንታ የ ይታ ገቀርሳንዳ የንደር ማታክን አለን ኖ ቦድካንታ ጋይሶ ክርስቶሰታ ፍክስንጎካ ይንታ ሰንፔንካንታ አጨርክሳ ደእካንታ የልሴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_1","080_3_1","PHP","3","1","1","ይና ኮዘንካ ኦስ እስመንከስኬ ምችነንከሶ! ጮይስካ የም ጉርምሳ፥ ኤና እሪ እ ጻፍሳን ኮትም አናካርንካ እ የካንታ ጻብደ እም ቦስሳዬ፥ የም ማቼ ኮትርዘንካ ካርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_2","080_3_2","PHP","3","2","2","አክስንከስግንዳ ኦንግድባብ ዳቅልንከዘንካ ካርስምከቴ፥ ዋሄታ ሶለን ተችርና ጭልዝድን ካምስሶ ካርከካ ኤስዝድን ኤስንባብከዘንካ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_3","080_3_3","PHP","3","3","3","ዎታ ሳብም አያንካ ጎይንድባብኬ ማልጎካ Ꮊፈርድን ዎገንካ ማታክናና የሱስ ክርስቶስካ Ꮊክ ጋይርድባብ ዎ ማቻንካንታ ዶፈንካ ዎንታ ሶለንም ተቸርቶቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_4","080_3_4","PHP","3","4","4","ጬቅ ዝግዝደስናና እታ በድ ሪካ ጬቅድትዶቆ፥ ኤድካንታ Ꮊፈርድን ዎገንጎካ ጬቅድባብ ዶቅሴ እታ ክታዘንካ ስግ እ ጬቅድንደታ በድ ጎግ ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_5","080_3_5","PHP","3","5","5","እታ እ አጠርሳንግንዳ ላማካይስ ሰጨንካ እስታ ሶለንም ተቸርሳቴ፥ እስታ አጥርንከረ ብንያመታ አጥርᎺርንካ ማችባብ እስራኤልቴ፥ ኮዘንከረ አምሳንዳ ኤስምስባብ እብራውቴ። አይሁድንታ ህግን ካርስንታጎካ ማቼ እታ ፈረሳው Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_6","080_3_6","PHP","3","6","6","ሙሴታ ህግንጎካ ቀምስከረ ማቼ ምክስ ኤሄናር አሜንድባብከስም ዳይድ Ꮊቃቴ። ሙሴታ ህግን ካርሰካ ጭልምንጎከረ ይንኤርዝድ ሪካይሳ Ꮊቃቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_7","080_3_7","PHP","3","7","7","ይና ኤና ኮታ እሪ መይድ ሪየኬ ጋይስቶ እ አሜንድᎺቃን ሪንከስም ሙዳ ክርስቶስካንታ ጋይስቶ Ꮊራ ሪካንተረ መይዳክን ሪ ማስስቶ ፋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_8","080_3_8","PHP","3","8","8","ኮዘንከረ አብ እስታ ጮይስን የሱስ ክርስቶሰም ኤስንዘንካ ስገዳንዳ አብ Ꮊራ ሪየረ ካየንደትም እ አሜንድንኦል ሙዳ ሪም መይዳክን ሪ ማስስቶ ፋይድቴ፥ ክትካንታ ጋይስቶ ሙዳ ርም ዛቅትቴ። ክርስቶሰም Ꮊፍካንታ ጋይስቶ ሙዳ ርም Ꮊጭማግንዳ ፋይድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_9","080_3_9","PHP","3","9","9","ኮመረ እ ይድንደታጎግና ሙሴታ ህግንታዘን የድምሳን እስታ ጭለትቼን አሜንንዘን የድምሳን ሳብታ ጭለትችን ክርስቶሰካ አሜንሶ Ꮊፍካንተኬ ክትካ ክክን ማትካንቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_10","080_3_10","PHP","3","10","10","አብነረ ክርስቶሰምከ ክርስቶሰታ ደእናርንካ አምንተንታ ዎልቀን ኤስካንታ፥ ክታ ማጠንም ዎራ ካስምካንተኬ ክታ ደእንከረ ክትም ካምካንቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_11","080_3_11","PHP","3","11","11","ኮትኮግንደረ እ ደእሳንደታ ቡሪ አምስቶ ስለንክንደታ ሰንፔካ ዶቅካንታ Ꮊድን ጉርም ይይንተኬ። ");
INSERT INTO gyl_vpl VALUES ("PP3_12","080_3_12","PHP","3","12","12","ኮም ሙዳ አክ Ꮊፋክቴ፥ አነረ ኮካ ሙዳ ቦድማ ማትተ ጋያይቴ፥ ማታጋካ ዳት የሱስ ክርስቶስ እም ይንታ ማስሶ እካንታ ክት ግግስሶ እምድንደትም Ꮊፍካንታ ጋይስቶ ኦስ እር ዞድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_13","080_3_13","PHP","3","13","13","እስመንከስኬ ምችነእንከሶ! ኬዛርንካ ማቼ ኦ ኮታር እ የልሳንግንዳ ፋይዳይቴ፥ ኬዛር ማቼ ዋልቃ ሪ ይድቴ፥ ኮነረ እስታ ቡርጎካ ዶቅድንደትም ባቅረርቶ እስታ እሪ ዶቅድንደትም የድካንታ ጉርድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_14","080_3_14","PHP","3","14","14","እካንታ ግግምሶ እምምድን Ꮊፍካንታ ኦስ እስታ እር ቦድንተንደር የልካንታ ዞድቴ፥ ኮነረ ግግምሶ እምምድንዳ ሳብ የሱስ ክርስቶስጎካ ይንደር ፈስ ኤልሶ እካንታ ክት እምድን ሰንፔ። ");
INSERT INTO gyl_vpl VALUES ("PP3_15","080_3_15","PHP","3","15","15","ይና አያናር ዶቅንትካ ዎታ ዛብዝባብ ሙደና ኮም ካምድን ገቅር ዎንታ ዶቅ ዝግዝዴ፥ የ ፋስምድንደታ ገቅር የንታ ዎክያር ዶቅሴ ኮትኮም ገቅርን ሳብ መያ የካንታ ማስተሬ። ");
INSERT INTO gyl_vpl VALUES ("PP3_16","080_3_16","PHP","3","16","16","ማታጋካ ዳት ታ ዎ የልሳን ዶቅንትና አያንካ ክክን ማታ። ");
INSERT INTO gyl_vpl VALUES ("PP3_17","080_3_17","PHP","3","17","17","እስመንከስኬ ምችነንከሶ! እም ካምሰቶ ጎርስምከቴ፥ ዎንተረ ካምስንም ጎርስምድባብከስም ሙዳ ቡደርሶ ሰድከቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_18","080_3_18","PHP","3","18","18","ታ ኮታ ኤና እሪ በድᎺይካ እ የም ኬዛንግንደኬ ታየረ እስታ ኤርመንም ዉልኤርቶ እ የም ኬዝድንግንዳ ሙዳ በድንከስና ይንታ ይተንካ ክርስቶሰታ ማዝቀልንታ ይምኤንባብከስ ማተኬ። ");
INSERT INTO gyl_vpl VALUES ("PP3_19","080_3_19","PHP","3","19","19","ኬታ ጮይስና ኬታ ልጰኔ፥ ኦስንዝድን ሪ ከትካንታ ቦንቼ፥ ኬታ ገቅርነረ ፍጨዘንደትሜ፥ ኮካንታ ኬታ በእንተነረ ካይንቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_20","080_3_20","PHP","3","20","20","ዎታ ማቼ ጭላር ባንችምንታ ኤዶቴ፥ ፈ ኮታርንካ Ꮊድባብ አቅስንባብ ዎንታ ጮይስን የሱስ ክርስቶሰም ሱነካ ካርዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("PP3_21","080_3_21","PHP","3","21","21","ኖ ኮትኮም ቶችምሳን ዎንታ ዘነን ኦከካ ክታ ቦንችምሳን ዘነን ካምድንግንዳ ይዴ፥ ኮመረ ክት ይድንዳ ሙደንም ይንታ ገችታ ኤረንታ ጎያር ማስካንታ ክታ ዶቅድን ዎልቀንኬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_1","080_4_1","PHP","4","1","1","እ የም ሶልምድባብከስኬ እ የም ሱነርድባብ፥ እስታ ጉርምንተኬ እስታ ፍክስንታ ዛዉዳ ማችባብ እስመንከስኬ ምችነንከሶ! ጮይስካ ዳቅሰቶ ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_2","080_4_2","PHP","4","2","2","ኤዎድየኬ ስንጥክካ ክክ ክክ ጮይስያር ዋልቃ ገቅርካ ኤእሰኮ ዶቅተርንግንዳ ከትም ምግዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_3","080_4_3","PHP","4","3","3","የነረ ኦ ኮታር ዶቅዳዮ አሜንምስባብ እስታ ፍክስንታ ላኮይትኖ፥ ኬና ማነንከስም የስ አሌን አልድንግንዳ እታ የስም ምግዝድቴ፥ ኬና ማነንከስ እንካ ክክን ቀለምንጦሰከኬ ኬታ ላምና ዶቅንት ማጻፍናር ጻፍምስባብከስ አብንከሳርንከረ እስታ ፍክስንታ ላኮይትንከስካ ክክን ማትንተካ ክላ ኬዘንም የልስንጎካ ጉርተኬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_4","080_4_4","PHP","4","4","4","ሙዳᎺይካ ጮእይስካ የም ጉርምሳ፥ ጉጅሰረ ጋይድቴ “የም ጉርምሳ!” ");
INSERT INTO gyl_vpl VALUES ("PP4_5","080_4_5","PHP","4","5","5","ላቅም ኤድ የንታ ማትንተና ኤድ ሙደንደር ኤስምሳንዳ ማታ፥ ጮይስ ማትዮ Ꮊድካንታ የልቴ፥ ");
INSERT INTO gyl_vpl VALUES ("PP4_6","080_4_6","PHP","4","6","6","ኮካንታ ሙዳ ሪካንተረ ምክስካ፥ አብንከስካንታ ጋልትምኬ ጋለትካ ክክን የንታ ኦይስን ሳብካንታ ኤስምስከት ዳት Ꮊራ ሪካንተረ Ꮊይ ማጠረቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_7","080_4_7","PHP","4","7","7","ኤድ ሙደንታ ገቅርዘንካ ጬክን ጋይሳንዳ ሳብታ ሳራትቼና የንታ ቡደንምኬ የንታ ማክቼንም የሱስ ክርስቶሰካ ካርዝዴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_8","080_4_8","PHP","4","8","8","ይና ኮዘንከረ እስመንከስኬ ምችነንከሶ! ዶፈንን፥ ቦንቼን፥ ጭለትቼን፥ ይልቻ ይልችን፥ ጉርምዝድንደትምኬ አንጅምሳንዳ ማቻን ሪንከስም ሙዳ ገቀርከቴ። የንታ ማክቼና ከትኬና ሙዳ ሪንከዘንካ ስገድንደትኬ ጋለችዝድንደት፥ ኡርማ ሪንከስካ ጮጫንዳ ማታ። ");
INSERT INTO gyl_vpl VALUES ("PP4_9","080_4_9","PHP","4","9","9","እዘንካ የ ኤሳንደትምኬ የ ተያንደትም፥ ዎገን የ ኤሰርሳንደትምኬ የ ሰዳንደትም ሙዳ ይከቴ፥ ሳራትቼንታ ጮይስና የንካ ክክን ማተሬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_10","080_4_10","PHP","4","10","10","በድ ሰጨታ ቡሪ አናካርንካ እስታ ማጠንካንታ ገቅር የ የጃንካንታ ጮይስካ አንድር ጉርም እካንታ ኤስምዴ፥ ኮመረ ጋይድቶ የ ገቅርሳንደትም ፍክስት ሰችካንታ ኡርማ ጎግ የ Ꮊፋክንካንታ ጋይድት ዳት እስታ ማጠንጎካ የንታ ገቅርን ዎይስተቴ እስታ ጋይንት ካዬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_11","080_4_11","PHP","4","11","11","ጉጅሰረ ኮም እ ጋይድንዳ እስታ ገች Ꮊቅንጎካ ዝግዝድንዳ እካንታ ካይድንካ ካዬ፥ እታ ማቼ “እስታ ዶቅድን ሪና እካንታ ማዴ” ጋይንተን ኤስትቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_12","080_4_12","PHP","4","12","12","ኮካንታ Ꮊፍንመረ ማታ ካይንተንም ኤዝድቴ፥ Ꮊምን ካርዘነረ ማታ Ꮊምን ሰጨንከረ ምስንትንምኬ ዳቅርንም፥ Ꮊፍንተተኬ ካይንተታ ጎግንም ኤስትቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_13","080_4_13","PHP","4","13","13","ዎልቀን እካንታ እምድባብ ክርስቶሰካ ሙዳ ሪን ይይካንታ ማድቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_14","080_4_14","PHP","4","14","14","ማታጋካ ዳት የታ እስታ ማጠንም ካስምድባብ ማትሰቶ የንታ Ꮊፍርንካ ኡርማ ሪ ይሰቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_15","080_4_15","PHP","4","15","15","ኮዘንከረ አብ ክላ ኬዘንም ኤስምስ እ የጃንደትካ መቄዶንያ ፍጨናርንካ እ ዉድንካ የ ፍልጵሶስ ካተመናር Ꮊፈርድባብ አሜንድባብኬዘንካ አብ እመከረ ማታ ሞክት ተይንተካ እንካ ክክን የካ ማችባብ አሜንድባብ አብ ዎርሳ ካየንደትም የታ የንታ ማታርንካ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_16","080_4_16","PHP","4","16","16","ተሴሎንቃ ካተመናር ማጣ እዘን የልሳንደትም ኤስሰቶ አሌንም ካርንካ ካርንካ እካንታ ኦይተቴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_17","080_4_17","PHP","4","17","17","ኮመረ እ ጋይድንዳ የንታ እመን Ꮊፍካንታ አንግርካ ማታክናና የንታ እመንታ አፍና የካንታ በድንግንዳ አንግርኬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_18","080_4_18","PHP","4","18","18","እካንታ ዝግዝድንደትምኬ እካንታ ዝግስምድንደትዘንካ ስግ እካንታ የ ኦይቻንደትም እመን ኤጳፍሮድቱስታ አንያርንካ ተይትቴ፥ ኮነረ የንታ እመና ኡርማ ዎዝድንደትካ ጮጫን ካሲንግንዳ ሳብካንታ ዝግዝድንደትኬ ክትም ጉርምዝድንዴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_19","080_4_19","PHP","4","19","19","ኮካንተረ እስታ ሳብና ይንታ ቦንችምሳን ቆልመንዘንካ ክርስቶስ የሱስጎካ የም ዝግዝድንደትም ሙዳ የካንታ እምዴ። ");
INSERT INTO gyl_vpl VALUES ("PP4_20","080_4_20","PHP","4","20","20","ዎንታ ባቤንካንተኬ ዎንታ ጮይስንካንታ ስለንክንደታ ቦንቻ ማታ፥ አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("PP4_21","080_4_21","PHP","4","21","21","አሜንድባብከስ ሙደንካንታ የሱስ ክርስቶሳር አቦ ከትም ጋይከቴ፥ እንከረ ክክን ዶቅድባብ እስመንከስኬ ምችነንከስ አቦ የም ጋይደኬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_22","080_4_22","PHP","4","22","22","አብ አሜንድባብከስ ሙደና ስገረ ሮማ ፍጨንታ ባንችንታ ኤሀ ኤድንከስ አቦ የም ጋይደኬ። ");
INSERT INTO gyl_vpl VALUES ("PP4_23","080_4_23","PHP","4","23","23","ዎንታ ጮይስን የሱስ ክርስቶሰታ ዉች እምንተና የንካ ክክን ማታ፥ አምንኤ። ");
INSERT INTO gyl_vpl VALUES ("CL1_1","081_1_1","COL","1","1","1","ሳብታ ጋይተካ የሱስ ክርስቶስታ ኦይትምስባብ ጳውሎስዘንከ ዎንታ እስመን ጢማቶስዘንካ፥ ");
INSERT INTO gyl_vpl VALUES ("CL1_2","081_1_2","COL","1","2","2","ቆላስያሳር ዶቅድባብከስ ክርስቶሳር ፋስምስባብከስኬ አሜንምስባብ እስመንከስ፥ ሳብ ዎንታ ባቤንዘንካ ዉች እምንተንኬ ሳራትቼንካ የካንታ ማታጋካ። ");
INSERT INTO gyl_vpl VALUES ("CL1_3","081_1_3","COL","1","3","3","የካንታ ዎ ምግዝድንደትካ ዎንታ ባቤን የሱስ ክርስቶስታ ባቤን ሳብም ሙዳᎺይካ ዎታ ጋለዶቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_4","081_1_4","COL","1","4","4","Ꮊራካንታ ጋይሴ የሱስ ክርስቶሳር የንታ ዶቅድን አሜንንከኬ አሜንድባብከስጎካ ሙዳ የንታ ዶቅድን ሶልመንም ኤሰርቶቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_5","081_1_5","COL","1","5","5","ዶፈንንታ ቃላ ማቻንዳ ክላ ኬዘና እሪናና የንደር የልሳንደትካ ክትካ ዶቅድንደትም Ꮊድን ጉርምንም ኤሰርተቴ፥ ኮካንታ የንታ አሜንንከኬ ሶልመና የድምሳንዳ ጭላር ግግምሶ የም ካርዝድን ኮትኮ Ꮊድን ጉርምንዘኔ። ");
INSERT INTO gyl_vpl VALUES ("CL1_6","081_1_6","COL","1","6","6","የታ ክላ ኬዘን የ ኤሰርሳንደትዘንኬ ሳብተረ ዉች እምንተንታ ዶፈንን ቡደካ የ ኤሳን ሰጨንዘንካ የድሶ ኮና ክላ ኬዘና የንታ ዎክያር ማቻንግንዳ ፍጫሙደንዘን አፍይ ኡስዘንኬ ጋጵዘን ዶቅዴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_7","081_1_7","COL","1","7","7","ኮመረ ዎንታ ካርያር ክርስቶስታ አሜንምስን ፍክስንባብ ማችባብኬ ዎንከረ ክክን የካ ፍግዝድባብ ሶልምምስባብ ኤጳፍራ የካንታ ኤስንም ኤስስቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_8","081_1_8","COL","1","8","8","ኮግንደረ ኖ ሳብታ አያንካ ክክ ክክ የንታ ሶልመንም ዎካንታ ኬዝቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_9","081_1_9","COL","1","9","9","ኮካንታ ኮም ዎ ኤሰርሳንደትዘንካ የድሶ የታ አያናር ዶቅድን ኤጨኬ ገቅርካ ሙዳ ሳብታ ጋይተንም ገቀርት የ ተይድን ጮጭ ኤስ የካንታ ዶቅተርንግንዳ የካንታ ምክስንምኬ ሳብም ኦይስን ዎይሳኮቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_10","081_1_10","COL","1","10","10","ኮትኮግንደረ ጮይስካንታ ዝግዝድንጎግካ ዶቅንትካ ክትም ቦድመካ የ ጉርምስተርንግንዳ Ꮊምንመረ ኡርማ ፍክስን ፍክስካ አፍይ የ ኡስተርንግንደኬ ሳብም ኤስንተካ የ ጋጵተርንግንዳ ምግዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_11","081_1_11","COL","1","11","11","ጮይስ ይንታ ኤስምሳን ዎልቀንካ ይንታ ዳቅንተንም ሙዳ የካንታ እማ፥ ዳንዳእንከረ ሙዳ ሪን ጋምካንታ ጉርምካ ግግምስባብ የ ማታባብ የም ማሳ ");
INSERT INTO gyl_vpl VALUES ("CL1_12","081_1_12","COL","1","12","12","ጉጅሰረ ሳክማ ባንችምናር ጭልንባብከስካ ክክን ባእንም ካስምተርንግንዳ የም ማስስባብ ሳብ ባቤንም ጉርምካ ጋለትከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_13","081_1_13","COL","1","13","13","ኖ ኡምንታ ዎልቀንዘንካ አቅስሶ ሶልምምሳን ይንታ ይንቺንታ ባንችምናር ዎ አርድንግንዳ ይሴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_14","081_1_14","COL","1","14","14","ክትካ ቆት ተይምሶቶ ዎንታ ጎመንታ ነገትቼን Ꮊፍቶቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_15","081_1_15","COL","1","15","15","ክርስቶስ Ꮊፈርዳክን ሳብታ ዶፈን ካምስዬ። ኖ ፍዝር ሙደንዘንካ አንድርከኬ ጬክን ጋይስባብ ዳነዜ። ");
INSERT INTO gyl_vpl VALUES ("CL1_16","081_1_16","COL","1","16","16","ጭለዘንኬ ፍጨዘን ዶቅድባብ፥ ሰድምድባብኬ ሰድምዳክባብ፥ ጭለዘን ዎልቀንከስኬ ቆልድባብከስ፥ ገችንባብከስኬ ገችታ ኤረንባብከስ ሙደና ፍዝምሳንዳ ክትኬ። ሳብ ሙዳ ሪን ክርስቶሰካ ፍዝሶ ክትካንታ ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_17","081_1_17","COL","1","17","17","ኖ ሙዳ ሪዘንካ እሪናና ዶቅዴ፥ ሙዳ ሪነረ የድምሶ ዎእሳንዳ ክትኬ። ");
INSERT INTO gyl_vpl VALUES ("CL1_18","081_1_18","COL","1","18","18","ኖየረ ክታ ዘና ማቻን ምክስ ኤሄንታ ዱሬ፥ ሙዳ ሪካ እሪ ማድንግንዳ ደእያርንካ አምንተከረ እርንባብኬ አነረ ዳነዜ። ");
INSERT INTO gyl_vpl VALUES ("CL1_19","081_1_19","COL","1","19","19","ኮነረ ማቻንዳ ሳብታ ጮጭ ገቅርና ክታ ይንቺንካ ዶቅተርንግንዳ ሳብ ባቤንታ ጋይታ ማቻንኦሌ። ");
INSERT INTO gyl_vpl VALUES ("CL1_20","081_1_20","COL","1","20","20","ክትጎከረ ጭለዘነረ ማታ ፍጨዘን ዶቅድን ሪንከስም ሙዳ ይንካ ክክን ኤድምሴ፥ ማዝቀልንዘን ዉልእምሳን ይንታ ይንቺንታ ማቀስንከረ ሳራትቼን እምሴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_21","081_1_21","COL","1","21","21","ኤና ሳብዘንካ ጎተርሰቶ ዶቅድᎺቀቴ፥ የንታ ገቅርንኬ የንታ ዳቅል ፍክስንጎካ ክትካ ይምኤርስባብ Ꮊቀቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_22","081_1_22","COL","1","22","22","ታ ማቼ ሳብካንታ ፋስምስባብኬ ይልችን ጋይስባብ፥ ይንኤርዝድ ሪየረ የንዘን ካየንባብከስ ማስሶ ይንታ እሪ የልስካንታ፥ ክታ ይንቺና ዋሄካ ክት ደእሳንጎካ ሳብ ይንካ ክክን የም ኤድምሴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_23","081_1_23","COL","1","23","23","ኮነረ ማድንዳ የንታ የድንዘን የድምሳንደትኬ ሶግዳክባብ ማትሶ ክላ ኬዘንካ Ꮊፈርሳን Ꮊድን ጉርምንካ ዙብማከትዶቆ አሜንካ ዳቅሰቶ የ ዶቅድንካ Ꮊክዬ፥ ኮና ክላ ኬዘነረ የ ኤሰርሳንደትኬ ፍጫሙደንዘን ዶቅድን ኤድንከስካንታ ሙዳ ሳባክምሳንዴ፥ እታ ጳውሎሰረ ፍክስንባብ እ ማቻንዳ ኮትኮ ክላ ኬዘንካንቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_24","081_1_24","COL","1","24","24","ታ የካንታ እ ተይድን ማጠንካ እም ጉርምዝዴ፥ ክርስቶስታ ዘና ማቻን ምክስ ኤሄናሪ ኤድንከስጎከረ ክርስቶስ ማጥርምሳንደትም ካስምና እዘንካ ዞገርሳን እስታ ዋሄንካ ጮችዝድቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_25","081_1_25","COL","1","25","25","ሳብታ ቃለን የካንታ ሙደንም እ መያ ማዝድንግንዳ ሳብዘንካ እካንታ ዋደካ እምምሳን ፍክስንባብግንዳ ምክስ ኤሄናር ኤድንከስካንታ ፍክስባብ ማቻቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_26","081_1_26","COL","1","26","26","ኮነረ ሳብታ ቃለና ስግዳን ስለንከሳር ኤድ ይንችንኬዘንካ አጥምሶ Ꮊቃንደትኬ ታ ማቼ ሳብ አሜንድባብከስካንታ ሙዳ ክት መያ ማስሳንዳ አችምሳንደትሜ። ");
INSERT INTO gyl_vpl VALUES ("CL1_27","081_1_27","COL","1","27","27","ሳበረ ፋስምስባብከስካንታ መያማስካንታ ክት ጋይሳንዳ ዶቅድንደትም ኮ አችምሳን ቦንቼታ ቆልመንኬ የ አይሁድ ማታክባብከስታ ዎክያር Ꮊራከካ ክታ አንድር ማትንተኔ። ኮነረ አችምሳን Ꮊድን ጉርምካ ዎ ካርዝድንዳ ቦንቻ Ꮊፈርድንዳ ክርስቶስ የንታ ዎክያር ማትንተኔ። ");
INSERT INTO gyl_vpl VALUES ("CL1_28","081_1_28","COL","1","28","28","ዋልቃ ዋልቃ ኤድ ክርስቶስካ ማድን ኤድ ማድንግንዳ ይይሶቶ ግግስካንታ ኤድ ሙደን ኤጨንም ሙዳ ኤስስኬ ዞረካ ክርስቶስጎካ ሳባክዶቴ። ");
INSERT INTO gyl_vpl VALUES ("CL1_29","081_1_29","COL","1","29","29","ሳብ ይንታ አንድር ዎልቀንካ እስታ ዋሪ ክት ፍግዝድንኦል ኮትኮ ዎልቀንጎካ ኮና ገቅርና ቦድምድንግንዳ ዛብስቶ ጉረርቶ ጋብድቴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_1","081_2_1","COL","2","1","1","የካንተኬ ሎዶቅያ ፍጨናር ዶቅድን ኤድንከስካንታ ኮትኮግንደረ እስታ ባለንም ዎራ ሰድሰኮ ኤዝዳክን ኤድን ሙደንካንታ Ꮊራከካ ዛብሶ እ ጉርዳናንከረ የ ኤዝድንግንዳ ሶልምድቴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_2","081_2_2","COL","2","2","2","እ ጉርድንደረ ኬታ ቡደና ዳቅስንደትኬ ሶልመካ ዞክምሶ፥ ቦድማ ገቀርት ተይንም ሙዳ በችካ ሳብታ አችምሳን ማችባብ ክርስቶሰም ከት ኤዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_3","081_2_3","COL","2","3","3","ኤጨተኬ ኤሰታ ቆልማ አችምሶ Ꮊፈርድንዳ ክርስቶሰደርንኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_4","081_2_4","COL","2","4","4","ኮመረ እ የም ጋይድንዳ Ꮊየነረ ገስ ቃለካ የም ገስሳይንደትግንዳ ጋይስቴ፥ ");
INSERT INTO gyl_vpl VALUES ("CL2_5","081_2_5","COL","2","5","5","ዋሄካ የንዘንካ እ ጎተርሰረ አያንካ የንካ ክክንቴ፥ ኡርማ ዎገካ የንታ ዶቅንተንምኬ ክርስቶስዘን የንታ ዶቅድን ዳቅማ አሜንን እታ ሰደርቶ ጉርምድቴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_6","081_2_6","COL","2","6","6","ጮይስ የሱስ ክርስቶሰም የ አሜንሳንደትግንዳ ክትካ ዶእከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("CL2_7","081_2_7","COL","2","7","7","ክትካ የድምሳን የድንዘን ኤሀግንዳ ዎድምሰቶ የም ኤስሳንግንዳ የንታ አሜንካ ዳቅሰቶ ዶእከቴ፥ ጮጭሶ ስጥንደትም ጋለትን እምከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_8","081_2_8","COL","2","8","8","ክርስቶስዘን የድምሳንዳ ማታክናና ኤድ ፍክሳን ዎገኬ ፍጫሙደንዘን ፋይዳር አርዳክን ዎገንዘን የድምሳንዳ ይንዘንካ ዉችሰኮ ዉች ገስካ Ꮊየነረ ይንተናሪ የዳክንግንዳ ካርስምከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_9","081_2_9","COL","2","9","9","ጮይስትቼንታ ቦድማ ጮጭንተና መያ ማትሶ ዶቅድንዳ ኤዳትቼና ክርስቶሰኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_10","081_2_10","COL","2","10","10","የተረ ሙዳ ዶቅንትን የ Ꮊፍሳንደና ክታ ፍዛ ሙደንዘን ቆልድንደተኬ ገችታ ኤራ ሙደንታ ዱራ ማችባብ ክርስቶሰኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_11","081_2_11","COL","2","11","11","ክትከረ የንታ አሜንምንካ የንታ ሶለንም ተቼርተቴ፥ ኮነረ የንታ ሶለንም ተችርና ጎመክን ዋሄንታ ይተንም የንዘንካ Ꮊልእስካንታ ክርስቶስካ ይምሳንዳ ዳት ኤታ አንካ ይምሳንዳ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_12","081_2_12","COL","2","12","12","የ አሜንድባብከስታ ስእርን ስኤርሳንደትካ ክርስቶሰካ ክክን ዱከርሰቴ፥ ክትከረ ክክን ደእያርንካ አምተቴ፥ ደእናርንካ የ አምሳንደረ ክርስቶሰም ደእያርንካ አምሳን ሳብታ ዎልቀንካ የንታ አሜንምንኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_13","081_2_13","COL","2","13","13","ጎማ የንታ ፍክስንተኬ የንታ ጎማ ዋሄን ክርስቶስካ አሜንምካ ሶለንም ተቼርክሳ ነግንተካ ደእስባብ Ꮊቀቴ፥ ታ ማቼ ሳብ ክርስቶሰካ ክክን ስለንካ የ ዶቃባብ ማስቴ፥ የንታ ጎመንመረ ሙዳ ነጋ የካንታ ጋይቴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_14","081_2_14","COL","2","14","14","ኖ ኤና ኮትኮ ዎም ካሰሰሮ ግረሮ Ꮊቃን ህግናር ክትምሶ ዶቅድንደትም ባዘታ ጻፍምሳንደትም Ꮊልእሴ፥ ማዝቀልንታዘን ምስማርካ እከርሶ ዎንዘንካ Ꮊልእሴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_15","081_2_15","COL","2","15","15","ዎልቀንከስምኬ ገችታ ኤረንከስም ይንታ ማዝቀልንካ ጋምሶ ከታ ሶቅርንም ቡልሳንደታ ቡሪ ዎእስት ተይምስባብ ማትሶ መያ ከት Ꮊፈርድንግንዳ ከትም ማስሴ። ");
INSERT INTO gyl_vpl VALUES ("CL2_16","081_2_16","COL","2","16","16","ይና እችምካ ናነረ ዎጭምካ ባዓልንከስም ናንከረ አርፍንካ ቦንቼርድንደትም ናንከረ ዎገንም ቦንቸርድንደትጎካ Ꮊየነረ የንዘን Ꮊይፋረዳ። ");
INSERT INTO gyl_vpl VALUES ("CL2_17","081_2_17","COL","2","17","17","ኬና ሙዳ ኦስ እሪ Ꮊድን ሪንከስካንታ ስፍግንደኬ፥ ዶፈንና Ꮊፈርድንዳ ማቼ ክርስቶስኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_18","081_2_18","COL","2","18","18","እንድንካ ይንታ ማተንም ይርክሳ ይይንተካ ክታይንችም ጎይንካ ጬቅድባብ Ꮊየሰነረ ኤድ ናክካይሳ የም ነግዝዳክንግንዳ ካርስምከቴ፥ ኮግንዳ ኤድና ለምለም ጋይድንካ ይ ሰዳን ሪንካ ይንታ ማተን ጬቀሮ ዉች ኩንኬ ዋሄታ ማቻን ገቅርካ ኦተርደኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_19","081_2_19","COL","2","19","19","ኮግንዳ ኤድና ሪ ሙደንታ ዱራ ማችባብ ክርስቶሰካ ክክን ክትም Ꮊረነረ የልስዝድር ካዬ፥ ዘነንም ሙዳ ክክ ሱግድንደትኬ ዝንካ የችሶ እችዝድባብ ሪ ሙደንታ ዱረኔ። ሳብ ዘና ሙደንታ ጋጵንተን ክት እምድንደረ ኮግንደኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_20","081_2_20","COL","2","20","20","ክርስቶስካ ክክን ደእሰቶ ኮ ፍጫሙደንታ ዝግዝድን ዎገንከዘንካ ቦድሰቶ ፋስምስባብከስ የ ማቻንዳ ማቼ ታ ፍጫሙደንዘንካ ፋስማክባብግንዳ ማትሰቶ Ꮊራካንተት ኮግንዳ ዶቅድን ክተንከስካንታ ቆልምዳ፥ ");
INSERT INTO gyl_vpl VALUES ("CL2_21","081_2_21","COL","2","21","21","ክታ ክተንከሰረ “Ꮊይየዴ፥ Ꮊይአፍሴ፥ Ꮊይዎሌ” ጋይምድባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_22","081_2_22","COL","2","22","22","ከናከስ ሙዳ ኤታ አንታ ፍክስታ ክቴኬ ኤስስታዘን የድምስባብከስ ከት ማቻንኦል ፍክስዘን ከታ ይ Ꮊቃንደታ ቡር ካይንታካንታ ጋይምስባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("CL2_23","081_2_23","COL","2","23","23","ከታኬና ክተንከስ ገታ ኤታዘንካ ዉተዳንዳ ጎይንኬ ዝግዝዳክን ማተም ይርክሳ ይይንተኬ ዘነመረ ላቅስስዘን ማለካ ኬታ ይ ሰድንኦል ኤጫ ኬታ ዶቅድባብከስም ካምድባብ ማተረኬ፥ ኬዛርንካ ማቼ ዋሄታ አግርን ገችስካ ሪካንታ ማዳክባብከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("CL3_1","081_3_1","COL","3","1","1","ይና ክርስቶሰካ ክክን ደእያርንካ የ አምሳንካ ክርስቶስ ሳብታ ምዝዘን ዶቅሶ ዶቅድን ፈ ጭላር ዶቅድን ርንከስም ዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_2","081_3_2","COL","3","2","2","ሙዳᎺይካ ፈ ጭላር ዶቅድን ሪንከስካንታ ገቀርከት ዳት ፍጨዘን ዶቅድን ሪንከስካንታ Ꮊይገቀረቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_3","081_3_3","COL","3","3","3","የታ ደእተቴ፥ የንታ ሰንፔነረ ክርስቶሰካ ክክን ሳብታ ዋሪ አችምቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_4","081_3_4","COL","3","4","4","የንታ ሰንፓ ማችባብ ክርስቶስ መያማድንᎺይካ የተረ ክትካ ክክን ቦንቼካ መያማደቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_5","081_3_5","COL","3","5","5","ኮካንታ የንዘን Ꮊፈርድን ፍጨዘን ዶቅንትታ አግርን ሙዳ ደይስከቴ፥ ከተረ በልም፥ ቱና፥ ቤልምካንታ አንግር፥ ዳቅል አንግር፥ ጭጭ ና ኮነረ ሳብዘንካ አብን ጎይንንከሰኬ። ");
INSERT INTO gyl_vpl VALUES ("CL3_6","081_3_6","COL","3","6","6","ከትኬና ሪንከስጎካ ክትምዳክን ኤድንከዘን ሳብታ ዋጭና Ꮊተሬ። ");
INSERT INTO gyl_vpl VALUES ("CL3_7","081_3_7","COL","3","7","7","የተረ የንታ ማታርንካ ኮታ ኤና እሪ ክትምዳክን ኤድንከስታ ዎክያር ዶቅደቶ ከትግንዳ ዶቅድ Ꮊቀቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_8","081_3_8","COL","3","8","8","ታ ማቼ ዋጭም፥ ስነርንም፥ ጩበም፥ ኤታ ላም ካይስንም የንታ ዎክያርንካ ዎይስከቴ፥ ኦስንዝድን ኬዘረ የንታ አፋርንካ Ꮊይዉታ። ");
INSERT INTO gyl_vpl VALUES ("CL3_9","081_3_9","COL","3","9","9","ኤና እሪ የንታ መጤንም ፍክስንካ የካ ዉችተቶ የ ዛቅሳንኦል ክክ ክክ የታ ማልትንም Ꮊይኬዘቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_10","081_3_10","COL","3","10","10","ፍዝባብታ ካምስካ ክልምሳን ኤሰንካ ኦክምሳን ክላ ኤደትቼን ቆበርከቴ ");
INSERT INTO gyl_vpl VALUES ("CL3_11","081_3_11","COL","3","11","11","ኮግንደካ ግርክ ኤድንተኬ አይሁድ ኤድንታ፥ ሶለን ተቸርስባብተኬ ተቼራክንባብታ፥ ኤሳ ክታ ዶቅድንካ ሳብም ኤዝዳክንባብተኬ ኤሳ ክታ ካየንባብ ሳብም ኤዝዳክንባብተኬ፥ አይለተኬ ቦንችምስባብተካ ዎክያር ፋስም ካዬ፥ ክርስቶስ ሙደንቴ፥ ጉጅሰረ ሙደናሬ። ");
INSERT INTO gyl_vpl VALUES ("CL3_12","081_3_12","COL","3","12","12","ይና ሳብታ እድምስባብኬ ሳብካንታ ፋስምስባብ፥ ሶልምምስባብከሰረ የ ማቻንካ አጭርን፥ Ꮊልስምን፥ ማታ ቆልን፥ ኤድካንታ ቡዳርንካ አትርን፥ ዳንዳእንም ቆበርከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_13","081_3_13","COL","3","13","13","ክክ ክክ ዳንዳእከቴ፥ የንታ ዋርንካ ዋልቀና አብንዘን ይምኤርሳን ሪ ዶቅሴ ነጋ ክክ ጋይከቴ፥ ክርስቶስ ነጋ የም ጋይሳንግንዳ የተረ ክክ ክክ ነጋ ጋይከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_14","081_3_14","COL","3","14","14","ከትኬ ሙደንታ ዘርመካ ማቻን ቦድማ ዋልቃትቼካ ዞክምካንታ ሶልመንም ቆበርከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_15","081_3_15","COL","3","15","15","ዋልቃ ዘነታ ሱከንከስ ማትሰቶ ገታ ኤልምስባብከስ ኮ ሳራትቼንጎካ ማቻንኦል ክርስቶሰታ ሳራትችና የንታ ቡዳሪ ባንችማ፥ ጋለድባብ ማትከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_16","081_3_16","COL","3","16","16","ክርስቶስታ ቃለና ጮጭ የንታ ቡዳር ዶቃ፥ ኤጫ ሙደንካ ክክ ክክ ኤስስከቴ፥ ዞርምከቴ፥ የቺከኬ ዴእስካ፥ አያናር የቺንም የቼሮ ሳብም ቡዳርንካ ጋለተረቶ የቺከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_17","081_3_17","COL","3","17","17","የሱስጎካ ሳብ ባቤንም ጋለተረቶ ኬዘከረ ማታ ፍክስካ የ ይድንደትም ሙዳ ጮይስ የሱስ ክርስቶሰታ ላምንካ ይከቴ፥ ክትከረ ሳብ ባቤንም ጋለትከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_18","081_3_18","COL","3","18","18","የታ ኬነንከሶ! ጮይስታ እሪ ዝግዝድንዳ ማቻንኦል የንታ ክእስንከስካንታ ክትምከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_19","081_3_19","COL","3","19","19","የታ ክእስንከሶ! የንታ ኬነንከስም ሶልምከቴ፥ ከታዘን ጋርዝድባብ Ꮊይማተቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_20","081_3_20","COL","3","20","20","የታ ይንችንከሶ! ኮና ጮይስም ጉርምዝድንዳ ማቻንካንታ ሙዳ ሪካ የም አጭባብከስካንታ ክትምከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_21","081_3_21","COL","3","21","21","የታ አጭባብከሶ! ጉርምካይሳ ከት ማዳክንግንዳ የንታ ይንችንም ዋጭካ Ꮊይሰነርሰቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_22","081_3_22","COL","3","22","22","አይላትች ዎገናር ዶቅድባብ! ፍጨዘን የንታ ማታቆልስባብከስካንታ ሙዳ ሪካ ክትምከቴ፥ የክትምድንደረ ከታ የም ሰድንኦላርኬ ኤድም የ ጉርምዝድንኦል ሰድምካንታ ማታክዶቆ ጮይስም ጳስኬ ላቅም ቡዳርንካ ማታ። ");
INSERT INTO gyl_vpl VALUES ("CL3_23","081_3_23","COL","3","23","23","የ ይድንደትም ሙዳ ኤድካንታ ማታክናና ጮይስ የሱስካንታ የ ይድንግንዳ ቦድማ ቡዳርንካ ይከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL3_24","081_3_24","COL","3","24","24","ኮካንተረ ጮይስና ጭላር ባእንም ናክ ማስሶ የም እምድንደትም የታ ኤዝደቴ፥ የ ፍግዝድንደረ ጮይስ ክርስቶስካንቴ፥ ");
INSERT INTO gyl_vpl VALUES ("CL3_25","081_3_25","COL","3","25","25","ሳብ Ꮊየንተረ ባላካንታ ኦስናይንኦል ዳቅል ፍግዝድባበረ ይንታ ዳቅል ፍክስንጎካ ዋጭንም ተይዴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_1","081_4_1","COL","4","1","1","የታ ማተን ቆልስባብከሶ! የተረ ጭላር የንታ ማታቆልስባብ ዶቅድንደትም ኤስሰቶ የንታ ፍክስንባብከስም ሉለከኬ ሙደን የካ ሰድሶ ገችስከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_2","081_4_2","COL","4","2","2","ሳብም ጋለትካ ዛብሰቶ ዛቃክዶቆ ምክስከቴ፥ ");
INSERT INTO gyl_vpl VALUES ("CL4_3","081_4_3","COL","4","3","3","ኮትኮከረ ክክን ሳብ ይንታ ቃለንካንታ ፍልታ ዎካንታ ፎችተርንግንደኬ እታ ክትጎካ ዞከርስቶ Ꮊፈርድንደትም ክርስቶስታ አችምሳንደትም ኤስምስካንታ እ ማተርንግንዳ ዎካንታ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_4","081_4_4","COL","4","4","4","እተረ እም ዝግዝድንግንዳ ቃለንም መየካ እ ኬዝድንግንዳ እካንተረ ምክስከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_5","081_4_5","COL","4","5","5","Ꮊምን ሰጨከረ ማታ የም ኮት መይድንግንዳ አሜንዳክባብከስታ ባንግር ኤጫ ማትሶ ዶእከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_6","081_4_6","COL","4","6","6","ዋልቃ ዋልቃ ኤድንካንታ ዝግዝድንደትም ማስንም ማስካንታ የ ኤስተርንግንዳ ሙዳᎺይካ የንታ ኬዘና ኤድካንታ ሎቅድን ሶቅግንደኬ ሳብታ ዉች እምንተንካ ማታ። ");
INSERT INTO gyl_vpl VALUES ("CL4_7","081_4_7","COL","4","7","7","ቲኪቆስ እጎካ ሙዳ ሪም የካንታ ኬዝተሬ፥ ኖ ሶልምምስባብ እስመና፥ አሜንምስባብ ፍክስንባብከ ጮይስታ ፍክስንም እ ፍግዝድንካ ኖ እስታ ላኮይት Ꮊቄ። ");
INSERT INTO gyl_vpl VALUES ("CL4_8","081_4_8","COL","4","8","8","ክትም የንደር እ ኦይቻንደና ዎጎካ የም ኬዝድንግንደኬ የንታ ቡደንመረ ዳቅዝድንግንዴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_9","081_4_9","COL","4","9","9","ክትከረ ክክን የንታ ኮች ማችባብ አሜንምስባብኬ ሶልምምስባብ እስመን ኦነስሞስ የንደር Ꮊዴ፥ ከታ ኮካርንዘን ዶቅድን ሪን ሙደንካንታ የካንታ ኤስምስተሬ። ");
INSERT INTO gyl_vpl VALUES ("CL4_10","081_4_10","COL","4","10","10","እንካ ክክን ዞከርስባብ አርስጥሮኮሰረ አቦ የም ጋይዴ፥ ዋልቃዱት፥ “የንደር እ ᎺድንደትᎺይካ ክትም የ ሞክተርንግንዳ” ጋይስቶ የም እ ገቀርስሳንዳ ባርናባሰታ እርክስታ ይንች ማርቆሰረ አቦ የም ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_11","081_4_11","COL","4","11","11","ኢዮስጦስ ጋይምሶ ኤልምድባብ ኢያሱ አቦ የም ጋይዴ። ሳብታ ባንችምንጎካ እንካ ክክን የካ ፍግዝድባብከስታ ዎክያርንካ አይሁድንከስታ ኮች ማችባብከስ ከታኬና Ꮊከኬ፥ እመረ ዳቅስተኬ። ");
INSERT INTO gyl_vpl VALUES ("CL4_12","081_4_12","COL","4","12","12","የንታ ኮች ማችባብ የሱስ ክርስቶስታ ፍክስባብ ኤጳፍረረ አቦ የም ጋይዴ፥ አያናር ዶቅንትካ ጋጰረቶ ዳቅሶ የ ዎእተርንግንደኬ ሳብተረ ጋይተን ሙዳ የ ቦተርንግንዳ ኖ የጎካ ሙዳᎺይካ ምግዝዴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_13","081_4_13","COL","4","13","13","የጎካ ሎዶቅያ ፍጨናርንኬ ሂራፖሊስ ካተመንከሳር ዶቅድባብ ኤድንከስካንተረ አንድር ክት ጋፋዶቅድንደትም እታ እስታ ማታርንካ ክትካንታ ማርከርድቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_14","081_4_14","COL","4","14","14","ሶልምምስባብ አክምና ሉቃስኬ ደማሰረ አቦ የም ጋይዴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_15","081_4_15","COL","4","15","15","ሎዶቅያር ዶቅድባብ እስመንከስካንታ ንምፉካንተኬ ኮታ ኤሄናር ዶቅድን ምክስ ኤሄንካንታ እስታ አቦ ጋይንተንም የልስከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_16","081_4_16","COL","4","16","16","ኮትኮም ክቴን የ ናበብዛንደታ ቡር ሎዶቅያ ኤድንከዝደር ዶቅድን ምክስ ኤሄናሪ ናበብምድንግንዳ ይከቴ፥ የተረ ሎዶቅያርንካ የካንታ ኦይትምድንደትም ክቴን ናበብከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_17","081_4_17","COL","4","17","17","አርክጳስካንተረ “ጮይስታ ፍክስ የስካንታ እምምሳን ፍክስንም ካርስምሶ የስ ቦተርንግንዳ” ጋይሰቶ ክትም ኬዝከቴ። ");
INSERT INTO gyl_vpl VALUES ("CL4_18","081_4_18","COL","4","18","18","ኮ ሳራትቼን እስታ ገታ አንካ ጻፍስባብ እታ ጳውሎስቴ፥ እስታ ዞክርንመረ ገቀርከቴ። ሳብታ ዉች እምንተና የንካ ክክን ማታ። ");
INSERT INTO gyl_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","ሳብ ባቤንተኬ ጮይስ የሱስ ክርስቶስታ ኮች ማችባብ ተሰሎንቄ ካተመናር ዶቅድን ምክስ ኤሄንካንታ፥ ጳውሎስዘንካ፥ ስላስዘንኬ ጢማቶሰዘንካ ኦይትምሳንዳ ክቴ፥ ዉች እምንተንኬ ሳራትችና የካንታ ማታ። ");
INSERT INTO gyl_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","ዎታ ሙዳᎺይካ የም ዎንታ ምክስንካ ገቅረሮቶ ሳብም ጋለዶቴ። ");
INSERT INTO gyl_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","ዎንታ ጮይስንተኬ ዎንታ ባቤንታ እሪ የንታ አሜንና ፍግዝድንደትም፥ ሶልማካንታ የ ይድንደትምኬ ዎንታ ጮይስ የሱስ ክርስቶሳር የንታ ዶቅድን Ꮊድን ጉርምን ዳንዳእካ የንታ ካርስን ባቀራኮትዶቆ ገቀርዶቴ። ");
INSERT INTO gyl_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","ሳብካ ሶልምምስባብ እስታ እስመንከስኬ ምችነንከሶ፥ ሳብ የም እጃንደትም ኤዝዶቴ። ");
INSERT INTO gyl_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","ዎንታ ክላ ኬዘንም የካንታ ዎ ኤስምሳንዳ ኬዘካ Ꮊክ ማታክናና ዎልቀኬ አያን ጭልንካ፥ ኮ ክላ ኬዘንታ ዶፈንንጎካ ዎተረ ዶፈን ማትንተኬ፥ የንካ ክክን ዎ ᎺቃንደትᎺይካ የካንታ ጋይሶቶ Ꮊስግንዳ ዎ ዶቅሳናንከረ የታ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","በድ ማጣ የንዘን የልስንከረ ዎራ አያን ጭልንዘንካ Ꮊፈርሳን ጉርምንጎካ ቃለንም ተይሰቶ ዎንተኬ ጮይስ የሱሰታ ካምስንም ጎርስምድባብከስ ማተቴ። ");
INSERT INTO gyl_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","ኮካንታ መቅዶንያርኬ አካያ አዉራጀናር ዶቅድን አሜንድባብከስ ሙደንካንታ ኡርማ ካምስ ማተቴ። ");
INSERT INTO gyl_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","ጮይስታ ቃለና የንዘንካ ዉትሶ ኤስምሳንዳ መቀዶንያርኬ አካያ አዉራጀናር Ꮊክ ማታክናና ሳብካ የንታ ዶቅድን አሜንና ሙዳ ካርያር ኤስምቴ፥ ኮትኮጎካ Ꮊረሰነረ ኬዛ ዎም ዝክሳዬ። ");
INSERT INTO gyl_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","የንደር ዎ Ꮊዳንደትካ Ꮊስግንዳ ዎም የ ሞክሳናንከረ ስለንካ ዶቅድባብምኬ ዶፈን ጮይስንታ ፍክስካንታ ጮይስ ማታክባብከዘንካ ፋስምሰቶ ሳብደር Ꮊስግንዳ የ ማቻናንከረ ከታ ኤድንከስ ይንታ ማታርንካ ማርከርደኬ። ");
INSERT INTO gyl_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","ኮትኮግንደረ ሳብ ደእያርንካ አምስስባብምኬ፥ Ꮊድን ዋጭንዘንካ ዎም አቅዝድባብ፥ ክታ ይንችን የሱሰታ ጭላርንካ Ꮊድንተን Ꮊስግንዳ የ ካርዝዳናንከረ የካንታ ማርከርደኬ። ");
INSERT INTO gyl_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","እስመንከስኬ ምችነንከሶ! ዎንታ የንደር Ꮊድንተና አፍካይሳ ማታክንደትም የታ የንታ ማታርንካ ኤዝደቴ። ");
INSERT INTO gyl_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","የ ኤዝድንደትግንዳ ኮታ እሪ ፍልጵስዮስ ካተመናር ዎ Ꮊቃንደትካ ማጠኬ የክካ ዎንዘን የልቴ፥ ኬዛር ማቼ አንድር ግርና ዎንዘን የልስንከረ ዎራ ክላ ኬዛንም የካንታ ዎ ኤስዝድንግንዳ ዎንታ ሳብና ዎካንታ ዎልቃ እምቴ። ");
INSERT INTO gyl_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","ዎታ የም ዎ ዞርሳንዳ ኮትርካ አነረ ዳቅል ገቅርካ ጎርስምሶቶ ካዬ፥ የም ገስካንታ ዎ ይሳንዳ Ꮊረሰነረ ሪ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","ስግስሶ ሳብ ክላ ኬዘን ዎካንታ ዋደካ ክት እምሳንዳ ዎንካ አሜንምሶ ማቻንኦል ዎታ ኬዝዶቴ፥ ኮመረ ዎ ይድንዳ ዎንታ ቡደን ፋስት ኤዝድባብ ሳብም ጉርምስካንታ ጋይሶ ዳት ኤድም ጉርምስካንታ ጋይሶቶ ካዬ። ");
INSERT INTO gyl_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","ዋልቃዱተረ ኬዘም ኡርስካ አነረ ብረታ አንግር ዎንታ ዶቅስንካ ቦድሶ ዎ ኬዛክንደትም የታ የንታ ማታርንካ ኤዝደቴ፥ ሳበረ ዎንታ ማርኬ። ");
INSERT INTO gyl_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","የንዘንከረ ማታ አብ Ꮊይ ኤድንዘንከረ ቦንቼንም ዝጋኮቴ። ");
INSERT INTO gyl_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","ክርስቶሰታ ኦይትምስባብ ዎንታ ማትንተንካ ዎም ዝግዝድንደትም የንዘንካ ኦይስካንታ ማዶት ዶቆ፥ ኬዛር ማቼ እንደና ይንታ ይንቺንካንታ ገቀርድንደትግንዳ ቡዳርንካ አትርካ የንታ ዎክያር ኦንግዞቴ። ");
INSERT INTO gyl_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","ኮትኮግንደረ አንድር የም ዎ ሶልምድንካንታ ሳብታ ክላ ኬዘን የካንታ ኤስምስ Ꮊክ ማታክናና ዎንታ ሰንፔንም ዎራ የካንታ እማካንታ ግግምስባብ Ꮊቆቴ። ");
INSERT INTO gyl_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","እስመንከስኬ ምችነንከሶ! Ꮊስግንዳ ዎ ፍክሳናን