﻿USE sofia;
DROP TABLE IF EXISTS sofia.gwr_vpl;
CREATE TABLE gwr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gwr_vpl WRITE;
INSERT INTO gwr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Omu ntandiika oKibbumba yabbumbire eigulu nʼekyalo. ");
INSERT INTO gwr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Oweyatandiikiire okubbumba, ekyalo kyabbaire kyereere nga kitiringanie. Era endikiirya yabbaire nabuli wantu oku maizi, ngʼoMwoyo wa Kibbumba yeebuuga oku ngulu oku maizi. ");
INSERT INTO gwr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Awo oKibbumba nʼakoba ati, “Wabbeewo ekitangaala.” Era ni wabbaawo ekitangaala. ");
INSERT INTO gwr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","OKibbumba nʼabona ngʼekitangaala kisa, nʼakyawula oku ndikiirya. ");
INSERT INTO gwr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Ekitangaala nʼakyeta musana, kaisi endikiirya nʼagyeta bwire. Awo ni bwirugala era ni buca, ni lubba lunaku olusooka. ");
INSERT INTO gwr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Awo oKibbumba nʼakoba ati, “Wabbeewo eibbanga okwabulamu amaizi agali ansi wʼeibbanga nʼagali e ngulu omwibbanga, gabbe omu bifo bibiri.” ");
INSERT INTO gwr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Nʼateekawo eibbanga okwawula amaizi agali ansi wʼeibbanga nʼamaizi agali e ngulu omwibbanga, era ni kibba kityo. ");
INSERT INTO gwr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Eibbanga nʼalyeta angulu. Awo ni bwirugala era ni buca, ni lubba lunaku lwokubiri. ");
INSERT INTO gwr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Awo oKibbumba nʼakoba ati, “Amaizi agali ansi wʼeigulu gakumbaanire omu kifo kimo, olukalu luboneke.” Era ni kibba kityo. ");
INSERT INTO gwr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Olukalu nʼalweta itakali, kaisi amaizi ageekumbaanirye, nʼageeta nyanza. Era nʼabona nga kisa. ");
INSERT INTO gwr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","OKibbumba nʼakoba ati, “Eitakali limere ebimera. Ekikoba kiti, eisubi eribala ensigo, nʼemisaale egya buli ngeri egineneka ebineneka omu ngeri yaabyo. Era ebineneka ebyo bibbe nga mulimu empalwa.” Era ni kibba kityo. ");
INSERT INTO gwr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Eitakali ni limera ebimera. Ekikoba kiti, eisubi erya buli ngeri eribala ensigo omu ngeri yaalyo, nʼemisaale egya buli ngeri egibala ebineneka ebirimu empalwa. Era oKibbumba nʼabona nga kisa. ");
INSERT INTO gwr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Awo ni bwirugala era ni buca, ni lubba lunaku lwokusatu. ");
INSERT INTO gwr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Awo oKibbumba nʼakoba ati, “Wabbeewo ebyaka angulu byawulenge omusana nʼobwire. Era ebyaka ebyo biragenge ebiro, nʼenaku, nʼemyanka. ");
INSERT INTO gwr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Era ebyaka ebyo byakirenge angulu ni biwa ekitangaala oku kyalo.” Era ni kibba kityo. ");
INSERT INTO gwr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","OKibbumba nʼakola ebyaka bibiri ebinene. Ekikoba kiti, ekyaka ekikiraku obunene, okufuganga omusana, nʼekitono kyaku okufuganga obwire. Era nʼakola nʼenkota. ");
INSERT INTO gwr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","OKibbumba nʼabiteeka angulu biwenge ekitangaala oku kyalo, ");
INSERT INTO gwr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","era bifugenge omusana nʼobwire, byawulenge ekitangaala nʼendikiirya. Era nʼabona nga kisa. ");
INSERT INTO gwr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Awo ni bwirugala era ni buca, ni lubba lunaku lwokuna. ");
INSERT INTO gwr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Awo oKibbumba nʼakoba ati, “Amaizi gabbeemu ebibbumbe bingi ino ebiri nʼobwomi, era nʼebinyonyi bibbeewo bigulukenge omwibbanga e ngulu wʼoku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kale oKibbumba nʼabbumba ebibbumbe ebinene ebyʼomu maizi bingi ebiri nʼobwomi. Nʼabbumba nʼebibbumbe ebindi ebya buli ngeri ebyʼomu maizi ebiri nʼobwomi. Era nʼabbumba nʼebinyonyi ebya buli ngeri. OKibbumba nʼabona nga kisa. ");
INSERT INTO gwr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Era nʼabiwa enkabi ngʼakoba ati, “Mubyalagane era mweyongere obungi, era mwizulye enyanza, era nʼebinyonyi byeyongere obungi oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Awo ni bwirugala era ni buca, ni lubba lunaku lwokutaanu. ");
INSERT INTO gwr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Era oKibbumba nʼakoba ati, “Eitakali libyale ebibbumbe ebya buli ngeri ebiri nʼobwomi. Ekikoba kiti, ebyayo, nʼebibbumbe ebyekuusa okwitakali, nʼebisolo ebyʼomu kigona.” Era ni kibba kityo. ");
INSERT INTO gwr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","OKibbumba nʼakola ebisolo byʼomu kigona ebya buli ngeri, nʼebyayo ebya buli ngeri. Nʼakola ebyekuusa okwitakali nabuli kimo omu ngeri yaakyo. Era nʼabona nga kisa. ");
INSERT INTO gwr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Awo oKibbumba nʼakoba ati, “Tukole omuntu omu kifaananyi kyaiswe abbe nga iswe, afugenge enyanyi nʼebinyonyi. Era afugenge nʼebyayo, nʼebisolo byonabyona ebyʼomu kigona, era nabuli kibbumbe ekyekuusa okwitakali.” ");
INSERT INTO gwr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Awo oKibbumba nʼabbumba omuntu omu kifaananyikye, omu kifaananyikye iye oKibbumba mu yamubbumbiire; ekikoba kiti, yabbumbire omusaiza nʼomukali. ");
INSERT INTO gwr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","OKibbumba nʼawa omusaiza nʼomukali enkabi ngʼabakoba ati, “Mubyalagane era mweyongere obungi, mwizulye ekyalo era mukifuge. Mufugenge ebyʼomu nyanza, nʼebinyonyi, era nabuli ekitambula okwitakali.” ");
INSERT INTO gwr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Awo oKibbumba nʼakoba abantu abo ati, “Mubone, mbawaire ebimera byonabyona ebibala ensigo, ebiri oku kyalo kyonakyona. Era mbawaire nabuli musaale oguneneka ebineneka ebirimu empalwa. Ebintu ebyo byabbanga kyokulya kyanywe. ");
INSERT INTO gwr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Era ebibbumbe byonabyona ebiri nʼobwomi, ekikoba kiti, ebisolo byonabyona ebyʼoku kyalo, nʼebinyonyi byonabyona, nabuli kibbumbe ekyekuusa okwitakali, mbiwaire ebimera byonabyona okubbanga ekyokulya kyabyo.” Era ni kibba kityo. ");
INSERT INTO gwr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","OKibbumba nʼabona nabuli ekyakolere nga kisa ino. Awo ni bwirugala era ni buca, ni lubba lunaku lwomukaaga. ");
INSERT INTO gwr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Kale bityo, eigulu nʼekyalo, nʼebintu byonabyona ebibirimu, ni biwa okubibbumba. ");
INSERT INTO gwr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Olunaku lwomusanvu owerwatuukiire, oKibbumba yabbaire amalire omulimogwe gwonagwona oguyabbaire akola. Kale nʼawuumula oku lunaku olwomusanvu. ");
INSERT INTO gwr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","OKibbumba nʼawa enkabi olunaku olwomusanvu, nʼalutukulya olwʼokubba oku lunaku olwo, luyawuumuliireku ngʼamalire omulimo gwonagwona ogwʼokubbumba oguyabbaire akolere. ");
INSERT INTO gwr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Atyo oMusengwa niiye oweyabbumbire eigulu, nʼekyalo, nʼebintu ebibirimu. OMusengwa oweyakoleire ekyalo nʼeigulu, ");
INSERT INTO gwr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","wabbaire tiwabbangawo misaale, waire ebimera ebindi oku kyalo. Ekyo kityo olwʼokubba oMusengwa yabbaire akaali okutoonyesya oku kyalo oikendi, era nga mpaawo muntu alima eitakali. ");
INSERT INTO gwr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Neye amaizi gaazwanga omwitakali, ni gadodya ekyalo. ");
INSERT INTO gwr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","OMusengwa nʼakwata eitakali nʼabbumbamu omuntu, nʼamufuwa omu nyindo omwota ogwʼobwomi, omuntu oyo nʼatandiika okubba mwomi. ");
INSERT INTO gwr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Awo oMusengwa nʼakoma omusiri omu kifo ekibeeta Edeni, nga kiri ku lubba olwʼe buzwaisana wʼe Kanani, nʼateeka omwo omuntu oyo oguyabbumbire. ");
INSERT INTO gwr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Era oMusengwa nʼamerya omwo nabuli musaale ogusangaalya okubona, era oguneneka ebineneka ebisa okulya. Omu musiri ogwo, aakati mwabbairemu omusaale ogwʼobwomi, nʼomusaale oguleeta okumanya ekisa nʼekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Omwiga ni gusinzirira omwEdeni okusukiriranga omusiri nago, ni gwegawuliramu eeyo, ni gibba emiiga ena. ");
INSERT INTO gwr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ogusooka, eriina lyagwo Pisoni. Ogwo niigwo ogweruguulya ekitundu kyonakyona ekyʼe Kavira ekirimu ezaabbu. ");
INSERT INTO gwr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Era ekitundu ekyo kirimu ezaabbu eyʼomutindo ogwʼangulu, nʼebyakaloosa ebifunya kusani, nʼamabbaale agʼebbeeyi! ");
INSERT INTO gwr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Eriina lyʼomwiga ogwokubiri, Gikoni. Ogwo niigwo ogweruguulya ekitundu kyonakyona ekyʼe Kuusi. ");
INSERT INTO gwr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Omwiga ogwokusatu, Tigiriisi, ogubita e buzwaisana wʼAsiiriya. Nʼomwiga ogwokuna, Ewufulaate. ");
INSERT INTO gwr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Awo oMusengwa nʼatwala omuntu odi, nʼamuteeka omu musiri gwʼomwEdeni agulimenge, era agulabirirenge. ");
INSERT INTO gwr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nʼamukoba ati, “Oyezya okulya ekineneka kyʼomusaale gwonagwona ogwʼomu musiri ogwo. ");
INSERT INTO gwr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Neye ekineneka kyʼomusaale oguleeta okumanya ekisa nʼekibbikibbi tokiryanga, olwʼokubba olunaku oluwalikiriiraku, mazima walifa.” ");
INSERT INTO gwr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Atyanu oMusengwa nʼakoba ati, “Tikisa omusaiza okubba yenkani. Nzwa kumukolera omubbeeri amusaanira.” ");
INSERT INTO gwr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","OMusengwa nʼakwata eitakali nʼakolamu ebisolo byonabyona, nʼebinyonyi. Awo nʼabireetera omusaiza okubona amaliina ageyabiwa, era nabuli kibbumbe ekiri nʼobwomi, eriina eriyakiwaire lyabbaire niiryo eryo. ");
INSERT INTO gwr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Omusaiza oyo nʼawa nabuli kyayo, nabuli kisolo ekyʼomu kigona, nabuli nyonyi eriina. Neye omu bibbumbe ebyo ebiri nʼobwomi, ni mutabbaamu mubbeeri asaanira omusaiza oyo. ");
INSERT INTO gwr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kale oMusengwa nʼaleetera omusaiza nago endoolo nyingi. Era oweyabbaire omu ndoolo, oMusengwa nʼamutoolamu ompete moiza, kaisi egiyatoire ompete nʼaizulyawo enyama. ");
INSERT INTO gwr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ompete oguyatoire omu musaiza nago, nʼamukolamu omukali, nʼamutwala e giri omusaiza nago. ");
INSERT INTO gwr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Awo omusaiza nago nʼakoba ati, “Dala atyanu onu niiye eigumba erizwire omwigumba lyange, era omubiri oguzwire omu mubiri gwange. Bamwetanga bati, ‘mukali,’ olwʼokubba bamutoire mu musaiza.” ");
INSERT INTO gwr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kagira omusaiza yalekanga oiteeye nʼomaaye, ni yeekwata nʼomukaliwe, era ni basuuka muntu moiza. ");
INSERT INTO gwr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Omusaiza nʼomukaliwe bombi babbaire bwere, neye ngʼensoni tigibakwata. ");
INSERT INTO gwr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Atyanu ompiri yabbaire mukalabakalaba okukiraku ebisolo byonabyona ebyʼomu kigona, oMusengwa ebiyakolere. Lwabbaire lumo ompiri nʼabuulya omukali ati, “OKibbumba dala yabalagiire okutalyangaku ekineneka kyʼomusaale gwonagwona ogwʼomu musiri gunu?” ");
INSERT INTO gwr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Omukali nʼamwiramu ati, “Twezya okulya ebineneka byʼemisaale gyonagyona egyʼomu musiri gunu, ");
INSERT INTO gwr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","okutoolaku ebineneka byʼomusaale oguli aakati wʼomusiri. OKibbumba yatugaine okugulyaku newankubbaire okugukwataku, kaisi titwafa.” ");
INSERT INTO gwr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ompiri nʼakoba omukali ati, “Okufa timwalifa.” ");
INSERT INTO gwr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","OKibbumba yabakobere atyo olwʼokubba yabbaire amaite ati, olunaku olumwaliguliiraku, amaiso gaanywe lugaliiguka. Era nywena mwalibba ngʼoKibbumba okumanyanga ekisa nʼekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Awo omukali nʼabona omusaale nago nga guboneka kusani. Nʼabona ngʼebineneka byagwo byezya okubba binoli ino okulya. Era nʼagwegomba olwʼokubba guleetera omuntu amalabuki. Kale nʼanokolaku ebineneka byagwo nʼalyaku, nʼawaaku nʼoibaaye yena nʼalya. ");
INSERT INTO gwr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Awo amaiso gaabwe bombi ni gaiguka, ni beetegeera nga babbaire bwere era ni batunga ebikoola byʼemisaale ni beesiba. ");
INSERT INTO gwr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Awo akanaigulo ako omusaiza nʼomukaliwe, ni bawulira ensindo gya Musengwa ngʼatambula omu musiri nago, ni bamwebisaku omu misaale gyʼomu musiri nago. ");
INSERT INTO gwr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Neye oMusengwa nʼayeta omusaiza ati, “Adamu oli yaina?” ");
INSERT INTO gwr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Omusaiza nʼakoba oKibbumba ati, “Mpuliire ensindo ngʼotambula omu musiri, ni ntya, olwʼokubba mbaire bwere kale ni neebisa.” ");
INSERT INTO gwr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","OKibbumba nʼamubuulya ati, “Naani akukobeire ati obbaire bwere? Oliire ekineneka kyʼomusaale ogunakulagiire okutalyaku?” ");
INSERT INTO gwr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Omusaiza nʼamwiramu ati, “Omukali oguwampaire okubbanga aanu na nze, niiye ampaireku ekineneka kyʼomusaale nago, era ni ndya.” ");
INSERT INTO gwr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Awo oMusengwa nʼakoba omukali ati, “Niki ekyo ekyokolere?” Omukali nʼamwiramu ati, “Ompiri niiye ambeyabbeyere, ni nkirya.” ");
INSERT INTO gwr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kale oMusengwa nʼakoba ompiri ati, “Atyanu olwʼokubba okolere ekintu ekyo, Osunire ekiraami omu byayo byonabyona nʼebisolo byonabyona ebyʼomu kigona! Weekuusiranga kida era waalyanga itakali enaku gyonagyona egyʼobwomibwo. ");
INSERT INTO gwr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Era nateekawo ekinakoolo akatiwo nʼomukali oyo, nʼakati wʼeibyaireryo nʼeibyairerye. Eibyairerye lyatentenanga emitwe gyʼeibyaireryo nʼeibyaireryo lyaboizanga ebitindiro byʼeibyairerye.” ");
INSERT INTO gwr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","OKibbumba nʼakoba omukali iye ati, “Nakwongera nakimo ino obulumi omu kubyala. Owewaabbanga obyala waabbanga nʼobulumi. Weegombanga oibaawo nʼakubba kumpi, neye era yakufuganga.” ");
INSERT INTO gwr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kaisi oKibbumba nʼakoba iye omusaiza nga niiye Adamu ati, “Olwʼokubba owulisisirye omukaliwo, nʼolyaku ekineneka kyʼomusaale ogunakulagiire okutalyaku, Eitakali lisunire ekiraami oku lulwo. Omu kukalabana mu wasunanga ekyokulya, enaku gyonagyona egyʼobwomibwo. ");
INSERT INTO gwr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Eitakali lyakumereryanga amawa nʼonamuswata, era waalyanga bimera byʼomu musiri. ");
INSERT INTO gwr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Omu kukola nʼotuuyaana mu wasunanga ekyokulya paka oluwalikanga omwitakali, olwʼokubba mu wazwire. Ekyo kityo olwʼokubba bakukolere mwitakali, era omwitakali mu walikanga.” ");
INSERT INTO gwr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Awo Adamu nʼawa omukaliwe eriina ati, Kaawa. Yamuwaire eriina eryo olwʼokubba yabbaire wʼokubba maaye wʼabantu bonabona. ");
INSERT INTO gwr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Era oMusengwa nʼakolera Adamu nʼoKaawa omukaliwe ebizwalo byʼamadiba, nʼabazwalisya. ");
INSERT INTO gwr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Era oMusengwa nʼakoba ati, “Atyanu omuntu asuukire nga iswe, amaite ekisa nʼekibbikibbi. Era bateekwa okutamwikirirya okunokola nʼalya ekineneka ekyʼomusaale ogwʼobwomi, nʼawangaala emirembe nʼemirembe.” ");
INSERT INTO gwr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kale oMusengwa nʼamubbinga omu musiri oguli Edeni, okwaba alimenge eitakali omu bamukolere. ");
INSERT INTO gwr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Oluzwanyuma lwʼokubbingamu omuntu, nʼateeka e buzwaisana omu musiri ebibbumbe ebiriku ebiyaya, ebibeeta Bakeruubbi, nʼempiima emesya nga yeebuuba okukuumanga enzira eyaba oku musaale ogwʼobwomi. ");
INSERT INTO gwr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Awo oluzwanyuma Adamu ni yeegaita nʼoKaawa omukaliwe. Era oKaawa nʼabba kida, nʼabyala omwana mwisuka nʼamuwa eriina ati, Kaini, ngʼakoba ati, “OMusengwa ambeereire ni mbyala omwana omwisuka.” ");
INSERT INTO gwr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Oluzwanyuma oKaawa nʼabyala omwana ogondi omwisuka nʼamuwa eriina ati, Abberi. Era owebakulire, Abberi nʼabba muliisya, neye oKaini iye nʼabba mulimi. ");
INSERT INTO gwr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Atyanu ebiseera byʼamakungula owebyatuukire, oKaini nʼatwala ebimo oku bibalabye ebiyakungwire, nʼabiwaayo eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abberi yena nʼatwalaku omoiza oku baana bʼentaamagye egigyasookere okubyala, nʼamwita era nʼawaayo ebitundu ebikira obusa. OMusengwa nʼasiima Abberi nʼekiyawaireyo, ");
INSERT INTO gwr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","neye nandi nʼasiima oKaini nʼekiyawaireyo. Kale oKaini nʼasunguwala ino, era nʼanyinkaala omu maiso. ");
INSERT INTO gwr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Awo oMusengwa nʼabuulya oKaini ati, “Lwaki osunguwaire era lwaki onyinkaire omu maiso? ");
INSERT INTO gwr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Singa okolere ekintu ekisa tinankusiimire ekyowaireyo? Neye olwʼokubba okolere ekintu ekitali kisa, ekikole ekibbikibbi kikwebisiriire okukulumba. Kitaka okukufuga, neye oteekwa okukiwangula.” ");
INSERT INTO gwr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Awo oKaini nʼakoba Abberi omugandawe ati, “Twabe omu musiri.” Atyanu owebabbaire nga bali eeyo, oKaini nʼagwa oku mugandawe Abberi, nʼamwita. ");
INSERT INTO gwr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Awo oluzwanyuma oMusengwa tete nʼabuulya oKaini ati, “Omugandawo Abberi aliina?” Nʼamwiramu ati, “Timmaite. Nze ninze omukuumi wa muganda wange?” ");
INSERT INTO gwr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","OMusengwa nʼamukoba ati, “Niki ekyo ekyokolere? Omusaaye gwʼomugandawo guli kunkungirira nga gusinzirira omwitakali nga gutaka nkubonereze. ");
INSERT INTO gwr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kale atyanu osunire ekiraami, era nkubbingire okwitakali erinywire omusaaye gwʼomugandawo oguwasukire. ");
INSERT INTO gwr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Era okuzwa atyanu, owewalimanga okwitakali eryo, tiryakubalirenge ebibala. Era waabbanga mulaaduuki era nga mpaawo e gyotyama oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Awo oKaini nʼairamu oMusengwa ati, “Ekibonerezo ekyʼompaire, kibitiriri ino okukiraku nze ekimpezya okugumira. ");
INSERT INTO gwr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Aale obone, ombingire okwitakali linu era ombingire omumaisogo. Era naabbanga mulaaduuki nga mpaawo e gintyama oku kyalo, era omuntu yenayena oweyalinsangaana yalinjita-bwiti.” ");
INSERT INTO gwr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Neye oMusengwa nʼamwiramu ati, “Bbe, tibalikwita. Era omuntu yenayena oweyalikwita, nalimubonereza emirundi musanvu okukiraku ngʼowenkubonerezere.” Awo oMusengwa nʼateeka oku Kaini akamanyiciryo okulabula nabuli amusangaana, okutamwita. ");
INSERT INTO gwr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kale oKaini nʼazwa omumaiso ga Musengwa, nʼayaba nʼatyama omu kyalo kyʼe Noodi ekiri e buzwaisana wʼEdeni. ");
INSERT INTO gwr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Oluzwanyuma oKaini ni yeegaita nʼomukaliwe, era omukaliwe nʼabba kida, nʼabyala omwana mwisuka, nʼamuwa eriina ati, Enoka. Omu kiseera ekyo oKaini yabbaire ayombeka ekibuga, kale nʼakyeta ati, Enoka, eriina lyʼomwanawe. ");
INSERT INTO gwr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Atyanu Enoka oweyakulire nʼabyala oIradi, oIradi nʼabyala oMekuyayeeri, oMekuyayeeri nʼabyala oMesusayeeri, oMesusayeeri nʼabyala oLaameeka. ");
INSERT INTO gwr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","OLaameeka yafumbiirwe abakali babiri, Ada nʼoZiira. ");
INSERT INTO gwr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada nʼabyala oYabbali, era oYabbali oyo niiye ozeiza wʼabo abaliisya era abagona omu weema. ");
INSERT INTO gwr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Omuganda wa Yabbali yabbaire Yubbali, era oYubbali oyo niiye ozeiza wʼabo abakubba otongoli era abafuwa omulere. ");
INSERT INTO gwr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Atyanu iye oZiira omukali ogondi owa Laameeka, nʼabyala oTubbaali Kaini, eyabbaire omuyeesi wa buli kintu ekyʼekyoma ekibakolesya. Omwonyoko wa Tubbaali Kaini yabbaire niiye oNaama. ");
INSERT INTO gwr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lwabbaire lumo oLaameeka nʼakoba abakalibe ati, “Ada nʼoZiira, mumpulisisye, inywe bakali bange, muwulire ebintumula. Nʼaitire omusaiza olwʼokubba yansumutire, ekyagirire ni njita omuvubuka oyo, yantemwire. ");
INSERT INTO gwr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Neye singa omuntu yenayena aita oKaini, bali nʼokumubonereza emirundi musanvu, kaisi singa omuntu anjita nze, bali nʼokumubonereza emirundi 77.” ");
INSERT INTO gwr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Atyanu Adamu tete ni yeegaita nʼomukaliwe era omukaliwe nʼabba kida, nʼabyala omwana mwisuka. Era omukali nʼawa omwana oyo eriina ati, Seezi, olwʼokubba yakobere ati, “OKibbumba ampaire omwana ogondi omwisuka okwira omu kifo kyʼAbberi, oKaini oguyaitire.” ");
INSERT INTO gwr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","OSeezi oweyakulire, yena nʼabyala omwana mwisuka, nʼamuwa eriina ati, Enosi. Era omu biseera ebyo, abantu webatandiikiire okusinzanga oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Atyanu binu niibyo ebikwata okwAdamu nʼeibyairerye. OKibbumba oweyabbumbire omuntu, yamubbumbire ngʼamufaanana. ");
INSERT INTO gwr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Yabbumbire omusaiza nʼomukali, nʼabawa enkabi, era nʼabawa eriina ati, “Muntu.” ");
INSERT INTO gwr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Atyanu Adamu oweyabbaire nga wʼemyanka 130, nʼabyala omwana omwisuka amufaanana, aali ooti niiye era nʼamuwa eriina ati, Seezi. ");
INSERT INTO gwr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adamu nʼawangaala emyanka egindi 800 ngʼamalire okubyala oSeezi, era omu myanka egyo, Adamu nʼabyaliramu abaana abandi abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Era nʼafa nga wʼemyanka 930. ");
INSERT INTO gwr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","OSeezi oweyabbaire nga wʼemyanka 105, nʼabyala omwana omwisuka bati, Enosi. ");
INSERT INTO gwr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Era oSeezi nʼawangaala emyanka egindi 807 ngʼamalire okubyala Enosi. Era omu myanka egyo oSeezi nʼabyaliramu abaana abandi, abaisuka nʼabaala, ");
INSERT INTO gwr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","awo nʼafa nga wʼemyanka 912. ");
INSERT INTO gwr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosi oweyabbaire nga wʼemyanka 90, nʼabyala omwana omwisuka bati, Kenani. ");
INSERT INTO gwr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enosi nʼawangaala emyanka egindi 815 ngʼamalire okubyala oKenani. Era omu myanka egyo Enosi nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosi nʼafa nga wʼemyanka 905. ");
INSERT INTO gwr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Atyanu oKenani oweyabbaire nga wʼemyanka 70, nʼabyala omwana omwisuka bati, Makalaleeri. ");
INSERT INTO gwr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","OKenani nʼawangaala emyanka egindi 840 ngʼamalire okubyala oMakalaleeri, era omu myanka egyo oKenani nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Era nʼafa nga wʼemyanka 910. ");
INSERT INTO gwr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","OMakalaleeri oweyabbaire nga wʼemyanka 65, nʼabyala omwana omwisuka bati, Yaledi. ");
INSERT INTO gwr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","OMakalaleeri nʼawangaala emyanka egindi 830 ngʼamalire okubyala oYaledi, era omu myanka egyo oMakalaleeri nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Era nʼafa nga wʼemyanka 895. ");
INSERT INTO gwr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","OYaledi oweyabbaire nga wʼemyanka 162, nʼabyala omwana omwisuka bati, Enoka. ");
INSERT INTO gwr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","OYaledi nʼawangaala emyanka egindi 800 ngʼamalire okubyala Enoka, era omu myanka egyo oYaledi nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Era nʼafa nga wʼemyanka 962. ");
INSERT INTO gwr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Atyanu Enoka oweyabbaire nga wʼemyanka 65, nʼabyala omwana omwisuka bati, Mesuseera. ");
INSERT INTO gwr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Era Enoka nʼabba nʼenkolagana eyʼamaani nʼoKibbumba era oluzwanyuma lwʼokubyala oMesuseera, Enoka nʼawangaala emyanka egindi 300. Era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Gyonagyona aamo Enoka nʼawangaala emyanka 365. ");
INSERT INTO gwr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Yawangaire emyanka egyo gyonagyona ngʼali nʼenkolagana eyʼamaani nʼoKibbumba. Era lwabbaire lumo nʼagotawo olwʼokubba oKibbumba yamutwaire nga mwomi. ");
INSERT INTO gwr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Atyanu oMesuseera oweyabbaire nga wʼemyanka 187, nʼabyala omwana omwisuka bati, Laameeka. ");
INSERT INTO gwr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","OMesuseera nʼawangaala emyanka egindi 782 ngʼamalire okubyala oLaameeka, era omu myanka egyo oMesuseera nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Era nʼafa nga wʼemyanka 969. ");
INSERT INTO gwr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","OLaameeka oweyabbaire nga wʼemyanka 182, nʼabyala omwana omwisuka. ");
INSERT INTO gwr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Era nʼamuwa eriina ati, Nuwa, ngʼakoba ati, “Omwana onu niiye eyalituleetera okuwumuka okukalabana omu mirimo gyaiswe oku kyalo oMusengwa ekiyalaamire.” ");
INSERT INTO gwr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","OLaameeka nʼawangaala emyanka 595 ngʼamalire okubyala oNuwa, era omu myanka egyo oLaameeka nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Era nʼafa nga wʼemyanka 777. ");
INSERT INTO gwr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ONuwa oweyabbaire nga wʼemyanka 500, nʼabyala oSeemu, nʼoKaamu, nʼoYafeesi. ");
INSERT INTO gwr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Abantu owebatandiikire okweyongera obungi oku kyalo, babyaire abaana abaala. ");
INSERT INTO gwr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Awo abaana ba Kibbumba ni babona ngʼabaala bʼabantu basiipoono, kale ni balondangamu abebasiimire ni babafumbirwa. ");
INSERT INTO gwr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Awo oMusengwa nʼakoba ati, “Tinalekenge abantu okuwangaala emirembe nʼemirembe, olwʼekikule kyʼemibiri gyabwe, bali nʼokufa. Era okuzwa olwatyanu bawangaalanga emyanka egitakirawo 120.” ");
INSERT INTO gwr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Omu biseera ebyo nʼebiseera ebyairireku, wabbairewo abantu abanene eino, abawanvu era abʼebifubba, oku kyalo. Abantu abo, abamo oku baana ba Kibbumba abebabyaire nʼabaala bʼabantu. Era abo niibo abantu abʼamaani abatutumukire omu biseera ebyʼeira. ");
INSERT INTO gwr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Atyanu oMusengwa nʼabona ngʼabantu bakola ino ebikole ebibbibibbi oku kyalo. Era nabuli kufumintiriza kwʼemyoyo gyabwe nga kubbikubbi kwereere bulijo. ");
INSERT INTO gwr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Awo oMusengwa ni yeejusa olwa kubbumba abantu nʼabateeka oku kyalo, era ni kimulumya ino. ");
INSERT INTO gwr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kale oMusengwa nʼakoba ati, “Nalisaanyawo abantu oku kyalo abenabbumbire. Era nalisaanyawo nʼebisolo, nʼebyekuusa okwitakali, nʼebinyonyi. Ekyo kityo olwʼokubba neejusa olwa kubibbumba.” ");
INSERT INTO gwr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Neye oNuwa iye, nʼabba mukoda eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Atyanu binu niibyo ebikwata oku Nuwa nʼeibyairerye. ONuwa yabbaire musaiza omutuukirirye, era nga niiye yenkani abulaku ekisobyo ekyʼokumunenya ekiseera ekyo. Era oNuwa omu bwomibwe yabbaire nʼenkolagana nʼoKibbumba. ");
INSERT INTO gwr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Era oNuwa yabyaire abaana basatu, oSeemu, nʼoKaamu, nʼoYafeesi. ");
INSERT INTO gwr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Atyanu ekiseera ekyo abantu abandi bonabona babbaire bakola ebikole ebibbibibbi omumaiso ga Kibbumba. Era nga nabuli wantu abantu bakola ebikole ebyʼobukambwe. ");
INSERT INTO gwr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","OKibbumba nʼabona ngʼekyalo kibebenyekere, olwʼokubba abantu bonabona babbaire bakola ebikole ebibbibibbi. ");
INSERT INTO gwr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kale oKibbumba nʼakoba oNuwa ati, “Nsalirewo okujigirica abantu bonabona olwʼokubba ekyalo kiizwire bikole ebyʼobukambwe ebibakola. Atyanu, njaba kujigirica abantu bonabona aamo nʼekyalo. ");
INSERT INTO gwr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kale weekolere iwe nʼabʼekisitokyo eryato omu mbaabo gyʼomusaale omusa. Oliteekemu ebisenge, era amabbanga agali omunda nʼoku ngulu kwʼeryato ogateekemu opati. ");
INSERT INTO gwr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Era olikole nga lyʼefuuti 450 omu buwanvu, nʼefuuti 75 omu bugalami, nʼefuuti 45 omu bugulumali. ");
INSERT INTO gwr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Olikole nga lya kalina isatu, era olekeku amandegeyi okweruguulya eryato nga gʼefuuti moiza nʼeinci mukaaga okuzwa oku kisooto e ngulu, era oliteekeku omulyango oku lubba olumo. ");
INSERT INTO gwr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Njaba okusindika amataba oku kyalo, okujigirica nabuli kibbumbe ekiri nʼobwomi. Era nabuli kintu ekiri oku kyalo kyaba kufa. ");
INSERT INTO gwr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Neye nalikola na iwe endagaano era nsuubiza nti nalikutaasa okufa. Era walingira omu lyato, iwe nʼomukaliwo, nʼabaanabo, nʼabalyabo. ");
INSERT INTO gwr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Era walingirya omu lyato nabuli ekibbumbe ekiri nʼobwomi ekisaiza nʼekikali, kaisi mbitaase amataba aamo na iwe. ");
INSERT INTO gwr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Era walingirya nabuli kika kyʼebinyonyi, nabuli kika kyʼebisolo, nabuli ekyʼekuusa okwitakali, era walibingirya bibiri bibiri, birame okufa. ");
INSERT INTO gwr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Era oteekwa okutwala nabuli kika kyʼebyokulya ebibyo ebiwaliryanga nʼabantubo era nʼebibbumbe.” ");
INSERT INTO gwr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kale oNuwa nʼakola byonabyona ngʼoKibbumba oweyabbaire amulagiire. ");
INSERT INTO gwr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Awo oMusengwa nʼakoba oNuwa ati, “Oingire nʼabʼomu kisitokyo bonabona omu lyato, olwʼokubba nkuboine nga niiwe wenkani omutuukirirye omu mulembe gunu. ");
INSERT INTO gwr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Era ku buli bisolo ebirongoole, otwaleku epeeya musanvu musanvu ekisaiza nʼekikali. Neye ku buli bisolo ebitali birongoole, otwaleku peeya peeya, ekisaiza nʼekikali. ");
INSERT INTO gwr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nʼebinyonyi byona ku buli kika otwaleku epeeya musanvu musanvu, ebisaiza nʼebikali. Okole ekyo kaisi nabuli kika kyʼebisolo nʼebinyonyi byʼeyongere okubbaawo nga byomi okubyala tete oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ekyo kityo olwʼokubba oluzwanyuma lwʼenaku musanvu okuzwa olwatyanu, njaba kutoonyesya oikendi enaku 40 omusana nʼobwire. Oikendi oyo ayaba okujigirica nabuli kibbumbe ekiri nʼobwomi ekinakolere oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Era oNuwa nʼakola byonabyona oMusengwa ebiyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Atyanu oNuwa yabbaire wʼemyanka 600, amataba owegabbeereire oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Era oNuwa nʼomukaliwe nʼabataane aamo nʼabalyabe ni baingira omu lyato okulama amataba ago. ");
INSERT INTO gwr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Awo ebisolo ebirongoole, nʼebitali birongoole, nʼebinyonyi, nʼebyekuusa okwitakali, ");
INSERT INTO gwr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","peeya peeya ekisaiza nʼekikali ni bingira nʼoNuwa omu lyato ngʼoKibbumba oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Awo oluzwanyuma lwʼenaku musanvu egiyakobere, amataba ni gatandiika. ");
INSERT INTO gwr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Oku lunaku olweikumi na musanvu, omu mweri gwokubiri, omu mwanka oNuwa oguyabbeereire nga wʼemyanka 600, ensulo gyonagyona egyʼomu nyanza enene ni gyeigula, nʼebituli byʼeigulu ni byeigula. ");
INSERT INTO gwr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Era oikendi nʼasusuka oku kyalo okumala enaku 40 omusana nʼobwire. ");
INSERT INTO gwr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Oku lunaku olwo oikendi oluyatandiikiireku, oNuwa nʼomukaliwe lubaingiriire omu lyato. Baingiire aamo nʼabataane baabwe abasatu, oSeemu, nʼoKaamu nʼoYafeesi, nʼabakali bʼabataane baabwe abo. ");
INSERT INTO gwr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Era baingire omu lyato nabuli kika kya kisolo omutono nʼomunene, ebyayo, nʼebisolo ebyʼomu kigona, nabuli kika kyʼebinyonyi, nʼebyekuusa okwitakali. ");
INSERT INTO gwr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ebyaingiire nʼoNuwa omu lyato, byabbaire peeya peeya, ku buli kika kyʼekibbumbe ekiri nʼobwomi. ");
INSERT INTO gwr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Era ebyo ebyaingiire byabbaire kisaiza nʼekikali, ngʼoKibbumba oweyabbaire alagiire oNuwa. Oluzwanyuma ngʼoNuwa aingiire omu lyato oMusengwa nʼaigalirawo e nza olwigi. ");
INSERT INTO gwr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Oikendi nʼasusuka oku kyalo enaku 40, era amaizi ni geeyongera obungi ni gasetula eryato okwitakali. ");
INSERT INTO gwr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Amaizi ni geeyongera ino obungi oku kyalo, era eryato ni lireera oku maizi. ");
INSERT INTO gwr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Amaizi ni geeyongerera nakimo oku kyalo, era ni gamira nʼensozi egikirira nakimo obuwanvu. ");
INSERT INTO gwr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Geeyongeire ni gabita oku manairungu gʼensozi egyo okwaba e ngulu, obuwanvu obubitawo efuuti aabiri. ");
INSERT INTO gwr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Era nabuli kintu ekyabbaire nʼobwomi oku kyalo ni kifa, ekikoba kiti, ebyayo, nʼebisolo ebyʼomu kigona, nʼebinyonyi, nʼebyekuusa okwitakali, nʼabantu bonabona. ");
INSERT INTO gwr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Era nabuli kintu ekyabbaire nʼobwomi oku kyalo ni kifa. ");
INSERT INTO gwr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","OMusengwa yajigiricirye nabuli kibbumbe ekiri nʼobwomi ekyabbaire oku kyalo, ekikoba kiti, abantu, nʼebisolo, nʼebinyonyi, nʼebyekuusa okwitakali. ONuwa yenkani niiye eyasigairewo, nʼabo abeyabbaire nabo omu lyato. ");
INSERT INTO gwr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Era amaizi ago ni gasigala nga mangi okumala enaku 150. ");
INSERT INTO gwr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Awo oKibbumba nʼaseega oku Nuwa, na ku buli kibbumbe oNuwa ekiyabbaire nakyo omu lyato. Era oKibbumba nʼasindika ompunga nʼafuwa oku kyalo, era amaizi ni gatandiika okukendeera. ");
INSERT INTO gwr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Era ensulo egyʼenyanza nʼebituli ebyʼomwigulu ni byeigala, oikendi nʼalekeraawo okutoonya. ");
INSERT INTO gwr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Amaizi ni gaaba nga gakendeera era oluzwanyuma lwʼenaku 150, amaizi gabbaire gakendeire. ");
INSERT INTO gwr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Oku lunaku olweikumi na musanvu omu mweri gwamusanvu, eryato ni lityama omu kitundu kyʼensozi ekibeeta Alalati. ");
INSERT INTO gwr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Amaizi ni geeyongera okukendeera paka mu mweri gweikumi. Awo oku lunaku olusooka omu mweri ogweikumi, amanairungu gʼensozi egyo ni gaboneka. ");
INSERT INTO gwr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Awo oluzwanyuma lwʼenaku 40, oNuwa nʼaigula edinisa yʼeryato eriyakolere. ");
INSERT INTO gwr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ONuwa olwʼokutaka okumanya embeera yʼekyalo, nʼasindika onankololo. Kale nʼaguluka nʼayaba, era nʼasigala ngʼayaba nʼaira oku lyato paka amaizi owegakalire oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Awo nʼasindika onjiiwa ngʼataka okumanya ngʼamaizi gakendeire oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Neye onjiiwa nʼatasuna awantu wʼokwemerera, olwʼokubba amaizi gabbaire gakaali gabbuunire oku kyalo kwonakwona. Kale nʼakanga oku lyato, awo oNuwa nʼabuluca engalo e nza, nʼamwingirya omu lyato. ");
INSERT INTO gwr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Awo nʼakuumaku enaku egindi musanvu, kaisi tete nʼasindika onjiiwa okwaba okubona ngʼamaizi gakalire oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eigulo onjiiwa nʼakanga e giri oNuwa omu lyato, ngʼonjiiwa ali nʼakakoola kʼomuzaituuni akabisi omu munwa. Awo oNuwa nʼategeera ati amaizi gakendeire oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tete nʼakuumaku enaku egindi musanvu, kaisi tete nʼasindika onjiiwa okwaba oku kyalo, neye oku mulundi gunu onjiiwa tiyakangire e gyali. ");
INSERT INTO gwr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Awo oku lunaku olusooka omu mweri ogusooka omu mwanka oNuwa oguyabbeereire nga wʼemyanka 601, amaizi gabbaire gakalire oku kyalo. Awo oNuwa nʼabiikulaku ekitundu engulu oku lyato, nʼalola nabuli ku lubba nʼabona ngʼekyalo kikalire. ");
INSERT INTO gwr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Oku lunaku lwa 27 omu mweri ogwokubiri, amaizi gabbaire gakaliire nakimo. ");
INSERT INTO gwr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Awo oKibbumba nʼakoba oNuwa ati, ");
INSERT INTO gwr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Owuluke omu lyato, nʼomukaliwo, nʼabataanebo, nʼabalyabo. ");
INSERT INTO gwr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Obuluceemu nabuli kibbumbe ekiri nʼobwomi, ekikoba kiti, ebisolo, nʼebinyonyi, era nabuli ekyekuusa okwitakali. Ebibbumbe ebyo bibyalagane bibbe bingi, era obungi bwabyo bweyongerenge oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kale oNuwa nʼawuluka omu lyato nʼomukaliwe, nʼabataanebe, nʼabalyabe. ");
INSERT INTO gwr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nʼebisolo byonabyona, nʼebyekuusa okwitakali byonabyona, nʼebinyonyi byonabyona, ekikoba kiti, nabuli bibbumbe byonabyona, omu bika byabyo, ni biwuluka omu lyato. ");
INSERT INTO gwr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Awo oNuwa nʼayombekera oMusengwa ekyoto. Era oku bisolo byonabyona nʼalondaku ebirongoole, nʼoku binyonyi byonabyona nʼalondaku ebirongoole, nʼabiwaayo oku kyoto ni bibba sadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Oluvululu olusa olwʼesadaaka eyo ni lutuuka eeri oMusengwa nʼasiima, era nʼakoba omu mwoyogwe ati, “Tinaliiramu tete okulaama ekyalo olwʼebikole ebibbibibbi abantu ebibakola. Ekyo kityo olwʼokubba okuzwa omu butobuto enseega yʼabantu mbiibbi, kale tinaliiramu tete okusaanyawo nabuli kibbumbe ekiri nʼobwomi, ngʼowenkolere. ");
INSERT INTO gwr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ekyalo nga kikaali kiriwo, okusiga nʼokukungula, nʼobuwolondoki, nʼeibbugumu, nʼokweisana, nʼokwaikendi, nʼomusana, nʼobwire, tibyalikoma.” ");
INSERT INTO gwr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Awo oKibbumba nʼawa oNuwa nʼabataane enkabi, nʼabakoba ati, “Mubyalagane era mweyongere mubbe bangi, mwizule ekyalo. ");
INSERT INTO gwr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Era ebisolo byonabyona ebyʼoku kyalo, nʼebinyonyi byonabyona, nʼebibbumbe byonabyona ebyekuusa okwitakali, nʼenyanyi gyonagyona byabatyanga. Era byonabyona mbibawaire omu bwezye bwanywe. ");
INSERT INTO gwr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Mbawaire nabuli ekiri nʼobwomi ekitambula kibbenge kyokulya kyanywe, ngʼowenabawaire ebimera. ");
INSERT INTO gwr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Neye timwalyanga enyama ekaali erimu omusaaye, olwʼokubba obwomi bubba mu musaaye. ");
INSERT INTO gwr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Era nabuli eyasaanyangawo obwomi bwa muntu, bamuvunaananga olwʼobwomi obwo. Era nabuli kisolo ekyaitanga omuntu bakivunaananga ni bakiita kyona. Era eyaitanga omuntu yena bamuvunaananga ni bamwita.” OKibbumba ni yeeyongera ati, ");
INSERT INTO gwr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Nabuli eyaitanga omuntu, yena omuntu niiye eyamwitanga. Ekyo kityo olwʼokubba oKibbumba yakolere omuntu ngʼamufaanana. ");
INSERT INTO gwr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Atyanu inywe mubyalagane era mweyongere mubbe bangi, mwizule ekyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Awo oKibbumba nʼakoba oNuwa nʼabataane ati, ");
INSERT INTO gwr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Aale mubone, nkola endagaano yange na inywe era nʼeibyaire lyanywe eryaliirawo. ");
INSERT INTO gwr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Era nabuli kibbumbe ekiri nʼobwomi ekyabbaire aamo na inywe, ekikoba kiti, ebinyonyi, nʼebyayo era nʼebisolo byʼomu kigona nʼebibbumbe ebiri nʼobwomi byonabyona ebyazwire na inywe omu lyato. ");
INSERT INTO gwr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nakuumanga endagaano yange na inywe omu ngeri enu eti, tinalijigirica tete ebibbumbe ebiri nʼobwomi byonabyona omulundi gwokubiri nʼamataba. Kale tiwakaali wabbaawo amataba tete omulundi gwokubiri okujigirica ekyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Era oKibbumba nʼakoba oNuwa ati, “Kanu niiko akaabbanga akamanyiciryo akʼendagaano egindagaana na inywe, nʼeeri nabuli kibbumbe ekiri nʼobwomi ekiri na inywe, nʼabʼemirembe egyaliirawo. ");
INSERT INTO gwr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nteeka ofudu wange oku bireri, era yaabbanga kamanyiciryo kʼendagaano egindagaanire nʼekyalo. ");
INSERT INTO gwr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kale nabuli owenaleetanga ebireri bya ikendi ni biboneka oku kyalo, nʼofudu nʼaboneka oku bireri ebyo, ");
INSERT INTO gwr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kyandeteranga okuseega oku ndagaano yange, egindagaanire na inywe nabuli kibbumbe ekya buli ngeri ekiri nʼobwomi. Amaizi agʼamataba tigaliiramu okutoonya okujigirica ebibbumbe byonabyona ebiri nʼobwomi. ");
INSERT INTO gwr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Nabuli ofudu oweyabonekanga oku kireri, naseeganga oku ndagaano eedi eyenkalaakalira. Eeyo nze eginalagaanire nabuli kibbumbe ekiri nʼobwomi ekya buli ngeri, ekiri oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kale oKibbumba nʼakoba oNuwa ati, “Ako niiko akamanyiciryo kʼendagaano yange eginakuumanga na iwe, era nabuli kibbumbe ekiri nʼobwomi.” ");
INSERT INTO gwr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Abataane ba Nuwa abazwire omu lyato babbaire Seemu, nʼoKaamu, nʼoYafeesi. OKaamu yabbaire niiye oiteeye wa Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Abataane ba Nuwa abasatu abo, niibo abantu bonabona abʼoku kyalo omu bazwire. ");
INSERT INTO gwr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Awo amataba owegakalire, oNuwa nʼatandiika okubba omusaiza omulimi, nʼakoma omusiri gwʼemizabbibbu. ");
INSERT INTO gwr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lwabbaire lumo, oNuwa nʼanywaku enviinyo egiyakunyire omu mizabbibbugye nʼateemeera, kale nʼagona omu weemaye ngʼali bwere. ");
INSERT INTO gwr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","OKaamu oiteeye wa Kanani, oweyaboine oiteeye ngʼali bwere, nʼawuluka e nza nʼakoberaku abagandabe bombi. ");
INSERT INTO gwr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Neye oSeemu nʼoYafeesi ni batoola olugoye, ni balwanzululya ni baluteeka oku mabega gaabwe bombi, kaisi ni batambula kyenyumaanyuma, ni baaba ni babiika oitewaabwe. Era bamubiikire nga tibamulolereku okutamubona ngʼali bwere. ");
INSERT INTO gwr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kale oNuwa, obuteemeere owebwamuwoireku, nʼategeera ekintu oKaamu omutaane omutomuto ekiyamukolere. ");
INSERT INTO gwr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Awo nʼakoba ati, “OKanani asunire ekiraami! Yaabbanga mugalama asembayo obwice omu bagalama bʼolulyolwe.” ");
INSERT INTO gwr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Era oNuwa nʼakoba ati, “OMusengwa bamuwuuje, iye oKibbumba wa Seemu. Oleke oKanani abbenge mugalama wa Seemu. ");
INSERT INTO gwr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Oleke oKibbumba awe oYafeesi eibyaire erinene era agalamye ensalogye. Era eibyaire lya Yafeesi lityamenge aamo omu weema nʼerya Seemu. Era erya Kanani libbenge ligalama lya Yafeesi.” ");
INSERT INTO gwr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Amataba nga gamalire okubbaawo, oNuwa nʼawangaala emyanka 350. ");
INSERT INTO gwr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Gyonagyona aamo oNuwa nʼawangaala emyanka 950, kaisi nʼafa. ");
INSERT INTO gwr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Linu niiryo eibyaire lyʼabaana ba Nuwa: OSeemu, nʼoKaamu, nʼoYafeesi. Abaanabe abo, basunire eibyaire ngʼamataba gamalire okubbaawo. ");
INSERT INTO gwr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Eibyaire lya Yafeesi niiryo linu: OGomeri, nʼoMagogi, nʼoMadayi, nʼoYavani, nʼoTubbaali, nʼoMeseki, nʼoTiraasi. Abo babbaire niibo abazeiza bʼabantu bʼebika nʼamawanga agʼamaliina gaabwe ago. ");
INSERT INTO gwr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Abʼeibyaire lya Gomeri babbaire niibo abantu banu: ABasukenaazi, nʼaBalifaasi, nʼaBatogaluma. ");
INSERT INTO gwr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ibo abʼeibyaire lya Yavani babbaire niibo abantu banu: ABeerisa, nʼaBatalusiisi, nʼaBakitimu, nʼaBalodanimu. ");
INSERT INTO gwr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Abantu abo bazwire mwibyaire lya Yafeesi, ni beeyabulyagamu amawanga agʼenjawulo, nʼentumu egyʼenjawulo omu bika ebyʼenjawulo. Era ibo basunire obutyami ku bizinga nʼokumpi nʼaganyanza. ");
INSERT INTO gwr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Eibyaire lya Kaamu lyabbaire niiryo linu: OKuusi, nʼoMisiri, nʼoPuuti, nʼoKanani. Abo babbaire niibo abazeiza bʼabantu bʼebika nʼamawanga agʼamaliina gaabwe ago. ");
INSERT INTO gwr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Era abʼeibyaire lya Kuusi babbaire niibo abantu banu: ABaseebba, nʼaBakavira, nʼaBasabbuta, nʼaBalaama, nʼaBasabbuteeca. Era abʼeibyaire lya Laama babbaire niibo abantu banu: ABaseebba, nʼaBadedani. ");
INSERT INTO gwr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Omoiza okwibyaire lya Kuusi babbaire bamweta Ndimuloodi. Era niiye omuntu eyasookere okubba owʼamaani oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Atyanu olwa bubbeeri bwa Kibbumba, oNdimuloodi yasuukire muyiigi owʼamaani. Era kagira abantu bakoba bati, “Oleke oKibbumba akusuuce wʼamaani ooti Ndimuloodi omuyiigi owʼamaani.” ");
INSERT INTO gwr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Era ebibuga ebyasookere omu bwakabaka bwa Ndimuloodi byabbaire Bbabbeeri, nʼEreki, nʼAkadi, nʼoKalune. Ebibuga ebyo byabbaire mu kyalo ekibeeta Sinali. ");
INSERT INTO gwr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Era yazwire omu kyalo ekyo nʼayaba Asiiriya nʼayombekayo ebibuga oNineeve, nʼoLekobbosi Yira, nʼoKala, ");
INSERT INTO gwr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nʼoLeseni. Ekibuga oLeseni kyabbaire kinene nga kiri aakati wa Nineeve nʼoKala. ");
INSERT INTO gwr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Abʼeibyaire lya Mizulaimu babbaire niibo abantu banu: ABaludimu, nʼaBaanamimu, nʼaBalekabbimu, nʼaBanafutukimu, ");
INSERT INTO gwr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","nʼaBopasulusimu, nʼaBakasulukimu abazwiremu aBafirisuuti, nʼaBakafutolimu. ");
INSERT INTO gwr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","OKanani nʼabyala omwanawe omubere ogubayeta oSidoni, nʼabyala ogondi bati, Kesi. ");
INSERT INTO gwr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Era omwibyaire lya Kanani niimwo omwazwire nʼaBayebbusi, nʼaBamooli, nʼaBagirugaasi, ");
INSERT INTO gwr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","nʼaBakiivi, nʼaBaaluki, nʼaBasiini. ");
INSERT INTO gwr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Era niimwo omuzwa nʼaBaluvada, nʼaBazemali, nʼaBakamasi. Era oluzwanyuma abantu abo basalaanikiire oku kyalo kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Era ensalo yʼekyalo kyʼaBakanani nʼebba ngʼezwera omu kibuga e Sidoni, paka mu kibuga e Gerali okumpi nʼe kibuga e Gaza. Ate olubba lwʼe bugwaisana nʼebba ngʼetuuka e Sodoma, nʼe Gomola, nʼAduma, nʼe Zebboyimu okutuuka okumpi nʼekibuga e Lasa. ");
INSERT INTO gwr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Eryo niiryo eibyaire lya Kaamu. Beeyabulyagiremu ni babba mawanga agʼenjawulo nga bali omu byalo ebyenjawulo, nʼentumu egyʼenjawulo omu bika ebyenjawulo. ");
INSERT INTO gwr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Era nʼoSeemu omuganda wa Yafeesi omukulu, yabbaire mubyaire, era niiye eyabbaire ozeiza wʼabantu bonabona abebayeta aBebberi. ");
INSERT INTO gwr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Abataane ba Seemu babbaire niibo banu: Eramu, nʼAsuli, nʼAlupakusaadi, nʼoLudi, nʼAlamu. Abo babbaire niibo abazeiza bʼabantu bʼebika nʼamawanga agʼamaliina gaabwe ago. ");
INSERT INTO gwr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Kaisi abʼeibyaire lyʼAlamu babbaire niibo abantu banu: ABawuuzi, nʼaBakuuli, nʼaBageseri, nʼaBameseki. ");
INSERT INTO gwr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Era Alupakusaadi niiye eyabyaire oSeera, kaisi oSeera nʼabyala Ebberi. ");
INSERT INTO gwr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Iye Ebberi yabyaire abaana babiri, omoiza waaku babbaire bamweta Peregi, olwʼokubba omu biseera ebyo ebiyabbeereirewo, abantu oku kyalo babbaire basalaanikire. Kaisi omugandawe iye babbaire bamweta Yokutaani. ");
INSERT INTO gwr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","OYokutaani abʼeibyairerye babbaire niibo abantu banu: ABaalumodaadi, nʼaBaserefu, nʼaBakazalumaveesi, nʼaBayera, ");
INSERT INTO gwr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","nʼaBakadolaamu, nʼaBawuzali, nʼaBadikula. ");
INSERT INTO gwr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","NʼaBobbali, nʼaBaabbimayeri, nʼaBaseebba, ");
INSERT INTO gwr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","nʼaBofiri, nʼaBakavira, nʼaBayobbabbu. Abo bonabona lyabbaire ibyaire lya Yokutaani. ");
INSERT INTO gwr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Era eibyaire lya Yokutaani ekyalo ekibatyaimemu kyabbaire kizwa e Mesa okutuuka e Sefala omu kyalo ekyʼe buzwaisana ekyʼensozisozi. ");
INSERT INTO gwr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Eryo niiryo eibyaire lya Seemu. Beeyabulyagiremu ni babba mawanga agʼenjawulo nga bali omu byalo ebyʼenjawulo, nʼentumu egyʼenjawulo omu bika ebyenjawulo. ");
INSERT INTO gwr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Abantu abo bonabona niibo eibyaire lya Nuwa, ngʼoweryabbaire omu ndyo gya bubyale bwabwe. Era oluzwanyuma amataba nga gamalire okubbaawo, mwabo niimwo omwazwire abantu abeeyabulyagiremu amawanga ni basalaanikira oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Atyanu, eira omu kusooka abantu bonabona oku kyalo babbaire batumula olutumu lumo era nga tibaawukana omu bibono. ");
INSERT INTO gwr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Awo abantu owebabbaire nga basenguka okusimba e buzwaisana, ni batuuka omu kitundu ekibulamu ensozi omu kyalo e Sinali, ni batyama omwo. ");
INSERT INTO gwr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lwabbaire lumo ni beekubbirizangana bati, “Mwize tukubbe amatafaali, era tugayoce kusani.” Awo ni bakola batyo era ni babba nʼamatafaali omu kifo kyʼamabbaale, era ni babba nʼokolansi omu kifo kyʼomusenye nʼosiminti. ");
INSERT INTO gwr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kale ni bakoba bati, “Aale atyanu oleke tweyombekere ekibuga, era nʼomunaala ogutuuka oku kireri, kaisi tututumuke era titwasalaanikira oku kyalo kyonakyona.” ");
INSERT INTO gwr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Awo abantu owebatandiikire okwombeka, oMusengwa nʼaika okubona ekibuga nʼomunaala abantu abo ebibabbaire bombeka. ");
INSERT INTO gwr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Nʼakoba ati, “Obone, atyanu abantu banu abali ekimo, era abʼolutumu olumo, owebabba batandiikire kukola biinu ebiti, mpaawo kintu ekibategekere okukola ekyabakaisya. ");
INSERT INTO gwr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mwize twikeyo tutabuletabule olutumu lwabwe, bakaye nabuli muntu okutegeera omwinaye.” ");
INSERT INTO gwr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kale oMusengwa nʼayaba nʼasalaanicirya abantu abo oku kyalo kyonakyona, era ni balekeraawo okwombeka ekibuga. ");
INSERT INTO gwr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Nʼolwekyo ni bakiwa eriina bati, Bbabbeeri olwʼokubba eeyo, oMusengwa giyatabuliire-tabuliire olutumu lwʼabantu bonabona oku kyalo. Era nʼokuzwera aawo oMusengwa nʼabasalaanicirya oku kyalo kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Linu niiryo eibyaire lya Seemu. Wabbaire wankubitawo emyanka mibiri okuzwa ngʼamataba owegabbeereirewo, era oSeemu nga wʼemyanka 100, nʼabyala Alupakusaadi. ");
INSERT INTO gwr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Era oSeemu oweyabyaire Alupakusaadi, oSeemu nʼawangaala emyanka egindi 500, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alupakusaadi oweyabbaire nga wʼemyanka 35, nʼabyala oSeera. ");
INSERT INTO gwr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Era oweyabyaire oSeera, Alupakusaadi nʼawangaala emyanka egindi 403, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","OSeera oweyabbaire nga wʼemyanka 30, nʼabyala Ebberi. ");
INSERT INTO gwr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Era oweyabyaire Ebberi, oSeera nʼawangaala emyanka egindi 403, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebberi oweyabbaire nga wʼemyanka 34, nʼabyala oPeregi. ");
INSERT INTO gwr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Era oweyabyaire oPeregi, Ebberi nʼawangaala emyanka egindi 430, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","OPeregi oweyabbaire nga wʼemyanka 30, nʼabyala oLewu. ");
INSERT INTO gwr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Era oweyabyaire oLewu, oPeregi nʼawangaala emyanka egindi 209, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","OLewu oweyabbaire nga wʼemyanka 32, nʼabyala oSeruga. ");
INSERT INTO gwr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Era oweyabyaire oSeruga, oLewu nʼawangaala emyanka egindi 207, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","OSeruga oweyabbaire nga wʼemyanka 30, nʼabyala oNakoli. ");
INSERT INTO gwr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Era oweyabyaire oNakoli, oSeruga nʼawangaala emyanka egindi 200, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ONakoli oweyabbaire nga wʼemyanka 29, nʼabyala oTeera. ");
INSERT INTO gwr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Era oweyabyaire oTeera, oNakoli nʼawangaala emyanka egindi 119, era omu myanka egyo nʼabyaliramu abaana abandi, abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","OTeera oweyabbaire nga wʼemyanka 70, nʼabyala oIbbulaamu, nʼoNakoli nʼoKalani. ");
INSERT INTO gwr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Linu niiryo eibyaire lya Teera. OTeera yabbaire niiye oiteeye wa Ibbulaamu, nʼoNakoli, nʼoKalani, kaisi oKalani nʼabba iteeye wa Luuti. ");
INSERT INTO gwr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","OKalani yafeereire mu kibuga e Yuuli e gibamubyaliire omu kyalo kyʼaBakaludaaya, era omu biseera ebyo oitewaabwe oTeera yabbaire akaali aliwo. ");
INSERT INTO gwr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","OIbbulaamu nʼoNakoli bombi ni basuna abakali. Omukali wa Ibbulaamu yabbaire niiye oSalaayi, kaisi owa Nakoli nʼabba niiye oMirika. OMirika yabbaire nʼomugandawe eriinalye bati, Isika, era oitewaabwe yabbaire niiye oKalani. ");
INSERT INTO gwr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Iye oSalaayi yabbaire abula mwana. ");
INSERT INTO gwr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","OTeera nʼakwata omutaane oIbbulaamu, nʼomwizukuluwe oLuuti omutaane wa Kalani, era nʼomulyawe oSalaayi omuka mutaane oIbbulaamu ni bazwa e Yuuli, omu kyalo kyʼaBakaludaaya, ni basimbuka okwaba e Kanani. Neye owebatuukire e Kalani, ni batyama yeeyo. ");
INSERT INTO gwr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","OTeera yawangaire emyanka 205, era nʼafeera mu Kalani. ");
INSERT INTO gwr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Atyanu oMusengwa yabbaire akobere oIbbulaamu ati, “Ozwe omu kyalo kyʼe waanywe, era omu bʼekikaakyo, nʼekisito kya iteewo, oyabe omu kyalo ekinalikulaga. ");
INSERT INTO gwr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Era nalikuwa abaizukulu bangi ino ni basuuka igwanga erinene eryʼamaani, era nakuwanga enkabi. Era nalitutumuca eriinalyo kaisi iwe nʼozwerangaku abantu okusuna enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nawanga enkabi abo abakusabiranga enkabi, nabuli eyakulaamanga zena namulaamanga. Era amawanga gonagona agʼoku kyalo naligawa enkabi nga mbitira mu baizukulubo.” ");
INSERT INTO gwr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kale oIbbulaamu nʼazwa e Kalani, ngʼoMusengwa oweyamukobere; era oLuuti nʼayaba naye. OIbbulaamu oweyazwereire omu Kalani yabbaire wʼemyanka 75. ");
INSERT INTO gwr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Era oIbbulaamu nʼayaba nʼomukaliwe oSalaayi, nʼoLuuti omwana wa muganda wa Ibbulaamu, nʼebintu byabwe byonabyona ebibabbaire bakumbaanirye era nʼabagalama abebasunire omu Kalani. Bazwireyo ni baingira omu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Awo oIbbulaamu nʼabantu abeyabbaire nabo ni batambula omu kyalo ekyo paka mu kifo kyʼe Sekemu, awabbaire omuvule gwʼe Moole. Era omu biseera ebyo aBakanani niibo ababbaire abatyami bʼomu kyalo ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Awo oMusengwa nʼabonekera oIbbulaamu, nʼamukoba ati, “Naliwa eibyaireryo ekyalo kinu.” Kale nʼayombekera aawo oMusengwa eyamubonekeire, ekyoto. ");
INSERT INTO gwr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Awo Ibbulaamu nʼazwa e Sekemu nʼasimba omu nsozisozi e giri e buzwaisana wʼekibuga kyʼe Bbeseri. Era nʼakomeka eweemaye aakati wʼe Bbeseri nʼAyi, e Bbeseri nga kiri oku lubba olwʼe bugwaisana, kaisi ekibuga kyʼAyi nga kiri oku lubba olwʼe buzwaisana. Era nʼayombekera aawo oMusengwa ekyoto, nʼasinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Awo oluzwanyuma oIbbulaamu ni yeeyongerayo ngʼasimba omwidungu oNegevu. ");
INSERT INTO gwr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Awo ni wagwawo enzala omu kyalo kyʼe Kanani, kale oIbbulaamu nʼaserengeta okwaba omu Misiri okutyamakuuyo olwʼokubba enzala yabbaire nene. ");
INSERT INTO gwr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Awo, oweyabbaire yatira okutuuka omu Misiri, nʼakoba oSalaayi omukaliwe ati, “Atyanu, mmaite ngʼobwoli mukali musiipoono. ");
INSERT INTO gwr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Era aBamisiri owebakubona, bakoba bati, ‘Oyo mukaliwe.’ Kale banjita, neye iwe ni bakuleka nga tibakwitire. ");
INSERT INTO gwr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Atyanu iwe wabakoba oti oli mwonyoko wange kaisi ni bambitya kusani oku lulwo, era ni ndama oku lulwo.” ");
INSERT INTO gwr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kale oIbbulaamu oweyatuukire omu Misiri, aBamisiri ni babona omukali oyo nga musiipoono ino. ");
INSERT INTO gwr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Era nʼabakungu ba Falaawo owebaboine omukali oyo, ni bamuwuuja eeri oFalaawo era ni bamutwala omu lubiri lwa Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Era oFalaawo nʼabitya kusani oIbbulaamu oku lwa Salaayi. Kale ni bawa oIbbulaamu entaama, nʼente, nʼempunda ensaiza nʼenkali, nʼabagalama abasaiza nʼabakali, nʼengamira. ");
INSERT INTO gwr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Neye oMusengwa nʼasindika endwaire egyʼamaani oku Falaawo nʼabʼomu kisitokye olwa Salaayi omukali wa Ibbulaamu. ");
INSERT INTO gwr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kale awo oFalaawo nʼalagira ni beeta oIbbulaamu, nʼamukoba ati, “Kinu niki ekiwankolere? Lwaki tiwankobeire oti mukaliwo? ");
INSERT INTO gwr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Lwaki wankobere oti oSalaayi mwonyokowo, kaisi ni mmutwala okubba mukali wange? Aale atyanu omukaliwo yooyo, omutwale era mwabe!” ");
INSERT INTO gwr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Era oFalaawo nʼalagira abakungube ni babbinga oIbbulaamu omu Misiri nʼomukaliwe nʼebintu byonabyona ebiyabbaire nabyo. ");
INSERT INTO gwr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Awo oIbbulaamu nʼazwa omu Misiri nʼasimba e mambuka, iye nʼomukaliwe nʼebintu byonabyona ebiyabbaire nabyo, nʼoLuuti aamo naye ni baingira omwidungu oNegevu. ");
INSERT INTO gwr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Era oIbbulaamu yabbaire nʼobusuni bungi obwʼente, nʼefeeza, nʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Era nʼasenguka omwidungu oNegevu, ni yeeyongerayo nʼasimba e Bbeseri era nʼakomeka eweemagye aakati wʼe Bbeseri nʼAyi omu kifo eweemagye awegyasookere okubba. ");
INSERT INTO gwr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Era aawo omu kusooka niiwo e giyabbaire ayombekere ekyoto. OIbbulaamu nʼasinzira eeyo oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Atyanu oLuuti, yena yabbaire nʼembuli nʼente nʼamaweema. ");
INSERT INTO gwr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kale ekiriisiryo ni kitayezya okubamala bombi nga batyaime mu kifo kimo ekyo olwʼokubba ebyayo byabwe byabbaire bingi ino. ");
INSERT INTO gwr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Era ni wabbaawo okayaani aakati wʼabaliisya ba Ibbulaamu nʼaba Luuti. Omu kiseera ekyo aBakanani nʼaBaperizi bona babbaire batyami bʼomu kyalo ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kale oIbbulaamu nʼakoba oLuuti ati, “Tiwaabbaawo okayaani aakati wange na iwe, ooba aakati wʼabaliisya bange nʼababo, olwʼokubba tuli bʼomulyango gumo. ");
INSERT INTO gwr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kaisi eitakali tiririwo linene eryoyezya okutwala? Aale tugawukane. Singa iwe wasimba oku ngalo engooda, nze nasimba ku ndiiro, ooba owewasimba oku ngalo endiiro, nze nasimba ku ngooda.” ");
INSERT INTO gwr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Awo oLuuti nʼasiirya amaisoge, nʼalengera ekyalo ekibulamu ensozi okumpi nʼomwiga oYoludaani kyonakyona nga mulimu ensulo nyingi. Ekyalo ekyo kyabbaire kifaanana ooti Edeni omusiri gwa Musengwa, era ooti kyalo kyʼe Misiri ngʼoyaba omu Zowaali. Omu kiseera ekyo oMusengwa yabbaire akaali okujigirica oSodoma nʼoGomola. ");
INSERT INTO gwr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kale oLuuti nʼalondaku ekyalo ekibulamu ensozi ekya Yoludaani era nʼasimbuka ngʼasimba e buzwaisana. Era eeyo niiyo engeri abasaiza abo ababiri egibagawukaniremu. ");
INSERT INTO gwr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Iye oIbbulaamu nʼatyama omu kyalo kyʼe Kanani, kaisi oLuuti nʼatyama omu bibuga ebyʼomu kyalo ekyo ekibulamu ensozi, era nʼakomeka eweemagye okumpi nʼe Sodoma. ");
INSERT INTO gwr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Atyanu ibo abantu abʼomu Sodoma babbaire bagwagwa era nga bakola ino ebikole ebibbibibbi omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Awo oMusengwa nʼakoba oIbbulaamu oluzwanyuma lwa Luuti okugawukana nʼoIbbulaamu ati, “Osiirye amaisogo aawo e gyoli olole e mambuka nʼe maserengeta, nʼe buzwaisana, nʼe bugwaisana. ");
INSERT INTO gwr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Eitakali lyonalyona eryobona, nakuwa iwe nʼeibyaireryo emirembe nʼemirembe. ");
INSERT INTO gwr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Era nalikuwa abaizukulu bangi ino ni babba tibabalika ooti musenye gwʼoku kyalo. ");
INSERT INTO gwr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Aale osetuke, oyabe olambuule eitakali eryo olwʼokubba nalirikuwa.” ");
INSERT INTO gwr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kale oIbbulaamu nʼasenguca eweemagye, nʼayaba nʼatyama awabbaire agavule ga Mamule agabbaire e Kebbulooni, era nʼayombekerayo oMusengwa, ekyoto. ");
INSERT INTO gwr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Awo omu kiseera ekyo, Amulafeeri okabaka wʼe Sinali, nʼAliyooki okabaka wʼErasaali, nʼoKedolawomeeri okabaka wʼEramu, nʼoTidali okabaka wʼe Goyiyimu, ");
INSERT INTO gwr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ni balwana nʼoBbera okabaka wʼe Sodoma, nʼoBbirusa okabaka wʼe Gomola, nʼoSinabbu okabaka wʼAduma, nʼoSemebbeeri okabaka wʼe Zebboyimu, nʼokabaka wʼe Bbera okuti ekibeeta oZowaali. ");
INSERT INTO gwr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Abakabaka abo bonabona abataanu ni beeyimbya aamo okulwana na badi abana omu kiinamo kya Sidimu ekiri okumpi nʼeNyanza eNfu. ");
INSERT INTO gwr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Abakabaka badi abataanu babbaire bamalire emyanka ikumi na mibiri ngʼokabaka oKedolawomeeri niiye abafuga, neye omu mwanka ogweikumi na misatu ni beediima. ");
INSERT INTO gwr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Awo omu mwanka ogweikumi nʼeena oKedolawomeeri nʼabakabaka abeyeeyimbirye nabo, ni baaba ni bawangula aBaleefa ababbaire omwAsuteroosi Kalunayimu, nʼaBazuuzi ababbaire omu Kaamu, nʼaBemimu ababbaire omu Saave Kiriyasaimu. ");
INSERT INTO gwr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Era ni bawangula nʼaBakooli omu kyalo kyʼensozisozi kyʼe Seiri, ni bababbinga paka Erupalaani ekiri okumpi nʼeidungu. ");
INSERT INTO gwr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Awo ni bakanga kaisi ni baaba e Nuumisupaati okuti ekibeeta oKadesi, ni bawamba ekyalo kyonakyona ekyʼaBamereki, era nʼekyʼaBamooli ababbaire abatyami bʼomu kibuga e Kazazoni Tamali. ");
INSERT INTO gwr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Awo entalo egyo owegyawoire, kaisi okabaka wʼe Sodoma nʼokabaka wʼe Gomola nʼokabaka wʼAduma nʼokabaka wʼe Zebboyimu era nʼokabaka wʼe Bbera okuti ekibeeta oZowaali, ni bakumba ni baaba era ni bacaana enyiriri egyʼolutalo omu kiinamo kyʼe Sidimu. ");
INSERT INTO gwr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Bakolere batyo nga bataka kulwanisya Kedolawomeeri okabaka wʼEramu, nʼoTidali okabaka wʼe Goyiyimu, nʼAmulafeeri okabaka wʼe Sinali, nʼAliyooki okabaka wʼErasaali. Ekikoba kiti, abakabaka abana nga balwana nʼabakabaka abataanu. ");
INSERT INTO gwr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Era ekiinamo kyʼe Sidimu kyabbaire kiizwire ebiina ebibakwiremu okoolansi. Kale okabaka owʼe Sodoma nʼokabaka owʼe Gomola owebabbaire bairuka, abaisirikale baabwe abamo ni bagwa omu biina ebyo, kaisi abasigairewo ni bairukira omu nsozisozi. ");
INSERT INTO gwr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Awo abakabaka abana abebabbaire balwana nabo ni banyaga ebintu byonabyona ebyʼomu Sodoma nʼe Gomola, nʼebyokulya byabwe byonabyona, kaisi ni beeyabira. ");
INSERT INTO gwr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Era bawambire nʼoLuuti omwana wa muganda wa Ibbulaamu era ni baaba nʼebintubye olwʼokubba yabbaire atyama mu Sodoma. ");
INSERT INTO gwr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Awo oluzwanyuma omusaiza omoiza eyawunukire, nʼayaba nʼakobera oIbbulaamu oMwebbulaniya. Atyanu iye oIbbulaamu yabbaire atyama kumpi nʼagavule ga Mamule owʼeigwanga lyʼaBamooli, omuganda wʼEsukoli, era omuganda wʼAneri bonabona ababbaire nʼenkolagana omu byʼolutalo nʼoIbbulaamu. ");
INSERT INTO gwr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","OIbbulaamu oweyawuliire ati bawambire owʼolulyolwe, nʼayeta abasaizabe abatendeke 318 ababyale bʼomu nyumbaye ni baaba babayiiga paka mu kibuga e Daani. ");
INSERT INTO gwr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Obwire oIbbulaamu nʼagawulamu abasaizabe okulumba abalabe era ni bawangula abalabe abo. Era oIbbulaamu nʼabasaizabe ni bababbingirira paka Kobba, ekiri e mambuka wʼe Damaasiko. ");
INSERT INTO gwr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Era banunwire ebintu byonabyona abalabe abo ebibbaire banyagire, ni banunula nʼoLuuti omwana wa muganda wa Ibbulaamu, nʼebintu bya Luuti, era nʼabakali, nʼabantu abandi abalabe abo abebabbaire bawambire. ");
INSERT INTO gwr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Oluzwanyuma lwa Ibbulaamu okukanga okuzwa omu kuwangula abakabaka abana omulimu oKedolawomeeri nʼabakabaka abainaye, okabaka wʼe Sodoma nʼazwayo okumwaniriza omu kiinamo kyʼe Seeve okuti ekibeeta eKiinamo kya Kabaka. ");
INSERT INTO gwr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Awo oMerikizedeki okabaka wʼe Saalemu nʼaleeta ekyokulya nʼenviinyo. Era oMerikizedeki yabbaire niiye okabona wa Kibbumba oNambulaku aMwagaagana. ");
INSERT INTO gwr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Era nʼamusabira enkabi ngʼakoba ati, “OKibbumba oNambulaku aMwagaagana, era eyabbumbire eigulu nʼekyalo awe oIbbulaamu enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Era oKibbumba oNambulaku aMwagaagana bamuwuuje iye eyakwezyeserye okuwangula abalabebo.” Awo oIbbulaamu nʼawa oMerikizedeki ekimo ekyʼeikumi ekyʼebintu byonabyona ebiyabbaire anunwire okuzwa omu lutalo. ");
INSERT INTO gwr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Awo okabaka wʼe Sodoma nʼakoba oIbbulaamu ati, “Ebintu ibyo otwale neye nkusaba onjirirye abantu bange aboonunwire.” ");
INSERT INTO gwr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Neye iye oIbbulaamu nʼakoba okabaka wʼe Sodoma ati, “Nsiirya engalo gyange nga ndayira eeri oMusengwa, oKibbumba oNambulaku aMwagaagana, era eyabbumbire eigulu nʼekyalo. Era nga ndayira nti, ");
INSERT INTO gwr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mpaawo ekikyo ekinatwala, newankubbaire akawuuzi ooba olukoba lwʼekiraato, kaisi okayeku naire okukoba oti ongaigawairye. ");
INSERT INTO gwr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Mpaawo ekinatwala okutoolaku nakoma ku biibyo abasaiza bange ebibaliire. Neye Aneri, nʼEsukoli, nʼoMamule abenabbaire nabo, ibo oleke batwale omugabo ogwabwe.” ");
INSERT INTO gwr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Oluzwanyuma lwʼebyo, oMusengwa nʼatumula nʼoIbbulaamu omu kwolesebwa ati, “Ibbulaamu tiwaatya. Nakukuumanga eeri akabbikabbi, era nalikuwa akasiimo akʼamaani.” ");
INSERT INTO gwr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Neye oIbbulaamu nʼakoba ati, “Oo Musengwa iwe oMukulu, akasiimo akewampa kangasa niki nze onambula mwana? Era mbona ngʼomugalama wange Eryeza owʼe Damaasiko niiye eyalinsika!” ");
INSERT INTO gwr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Era oIbbulaamu ni yeeyongera ati, “Tompaire eibyaire era nʼomoiza oku bagalama bange niiye eyalibba omusika wange.” ");
INSERT INTO gwr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Era oMusengwa nʼatumula naye omu kwolesebwa ati, “Eryeza tiyalibba musikawo, neye omutaanewo iwe onanyere oguwalibyala niiye eyalibba omusikawo.” ");
INSERT INTO gwr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Awo nʼamuwuluca e nza kaisi nʼamukoba ati, “Olole angulu omwibbanga kaisi obale enkota, owoobba nga dala oyezya okugibala.” Era nʼamukoba ati, “Abʼekiizukulukyo balibba bangi ooti nkota egyo.” ");
INSERT INTO gwr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Awo oIbbulaamu nʼaikirirya oMusengwa ekyakoba era nʼolwekyo oMusengwa nʼamubala okubba atuukiriire. ");
INSERT INTO gwr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Era oMusengwa nʼamukoba ati, “Ninze oMusengwa eyakutoire omu Yuuli ekyʼaBakaludaaya, okukuwa eitakali linu libbe liryo.” ");
INSERT INTO gwr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Neye oIbbulaamu nʼamubuulya ati, “Oo Musengwa iwe oMukulu, niki ekyammanyikisya nga lyalibba lyange?” ");
INSERT INTO gwr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kale awo oMusengwa nʼamukoba ati, “Ondeetere onte ompaki, nʼombuli okisonga, nʼontaama omusaiza, nga byonabyona byʼemyanka misatu misatu. Era oleetereku nʼompuuwu, nʼonjiiwa omutomuto.” ");
INSERT INTO gwr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Awo oIbbulaamu nʼatwalira oMusengwa ebintu ebyo byonabyona. Era ebisolo nʼabisalangamu aakati okutoolamu ebitundu bibiri bibiri, kaisi nʼateekanga nabuli kitundu ekya buli kisolo nga kiringiriire ekiinaye kyaku. Neye enyonyi igyo, nandi nʼagisalamu okusunamu ebitundu ebibiri bibiri. ");
INSERT INTO gwr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Awo ensega ni gigwa oku nyama nago neye oIbbulaamu nʼagibbinga. ");
INSERT INTO gwr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Awo eisana oweryabbaire nga ligwa, endoolo nyingi ni gitwala oIbbulaamu era endikiirya eyʼamaani etiisya nʼemubbaaku. ");
INSERT INTO gwr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Era oMusengwa nʼakoba oIbbulaamu ati, “Okimanye kusani oti eibyaireryo lyalibba ligeni omu kyalo ekitali kyabwe. Era lyalikola obugalama era ni balibitya bundi emyanka 400. ");
INSERT INTO gwr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Neye, nalisalira omusango era ni mbonereza eigwanga eryalibasuuca abagalama, neye oluzwanyuma lwʼebyo balizwayo nʼobusuni obwʼamaani. ");
INSERT INTO gwr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Neye iwe waliwangaala emyanka mingi era nʼofa mwidembe ni bakuliika. ");
INSERT INTO gwr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Era omu mugigi ogwokuna, abaizukulubo baliira aanu. Ekyo kityo olwʼokubba ekibbikibbi kyʼaBamooli kikaali okutuuka omu bwizulye kaisi njezye okubabonereza nʼokubatoola omu kyalo munu omu batyaime.” ");
INSERT INTO gwr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Awo eisana oweryagwire, era nʼendikiirya ngʼekwaite, ekibange ekiduunya omwosi era nʼogumole ogulunkuuma ni bibita aakati wʼebitundu ebibiri bibiri bidi ebyʼenyama. ");
INSERT INTO gwr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Oku lunaku olwo oMusengwa nʼakola nʼoIbbulaamu endagaano, ngʼakoba ati, “Eibyaireryo ndiwaire eitakali eryo, okuzwera oku mwiga ogwʼe Misiri okutuuka oku mwiga omunene Ewufulaate. ");
INSERT INTO gwr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Era ngʼeitakali nago lirimu aBakeeni, nʼaBakenizi, nʼaBakadumooni, ");
INSERT INTO gwr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nʼaBakiiti, nʼaBaperizi, nʼaBaleefa, ");
INSERT INTO gwr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","nʼaBamooli, nʼaBakanani, nʼaBagirugaasi, era nʼaBayebbusi.” ");
INSERT INTO gwr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Atyanu omu biseera ebyo oSalaayi omuka Ibbulaamu, yabbaire akaali okubyalaku nʼoIbbulaamu omwana. Neye oSalaayi yabbaire nʼomugalama omukali, owʼe Misiri eriinalye bati Agali. ");
INSERT INTO gwr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kale oSalaayi nʼakoba oIbbulaamu ati, “OMusengwa anjimire olubyalo. Aale oyabe omwa mugalama wange Agali, amo mwiye ni nsunaku eibyaire.” Awo oIbbulaamu nʼaikirirya oSalaayi ekyakobere. ");
INSERT INTO gwr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kale oSalaayi omuka Ibbulaamu, nʼakwata Agali omugalamawe owʼomu kyalo kyʼe Misiri, nʼamuwa oibaaye oIbbulaamu okubba mukaliwe. Ekyo yakikolere nga bamalire omu Kanani emyanka ikumi. ");
INSERT INTO gwr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Era oIbbulaamu ni yeegaita nʼAgali era nʼabba kida. Awo Agali oweyamanyicirye ngʼali kida, nʼatandiika okubityamu omusengwawe oSalaayi amaiso. ");
INSERT INTO gwr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kale oSalaayi nʼakoba oIbbulaamu ati, “Niiwe oli kuzwerangaku Agali okumbityamu amaiso. Nakwikiriirye okwingira omumwe era atyanu olwʼokubba amaite ati ali kida, ali kumbityangamu amaiso. Aale oMusengwa atulamule nze na iwe.” ");
INSERT INTO gwr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Neye oIbbulaamu nʼairamu oSalaayi ati, “Agali omugalamawo ali mu bwezyebwo. Omukole ekyobona ekisaanira.” Era awo oSalaayi, nʼatandiika okumubitya bundi, era Agali nʼamwirukaku. ");
INSERT INTO gwr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Awo omalaika wa Musengwa nʼayajirya Agali okumpi nʼeiruba erikulumuka amaizi omwidungu, eriri oku luguudo olwaba e Suuli. ");
INSERT INTO gwr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Era omalaika nʼamubuulya ati, “Agali omuweererya wa Salaayi, ozwa yaina? Era oyaba yaina?” Yena nʼamwiramu ati, “Njiruka musengwa wange oSalaayi.” ");
INSERT INTO gwr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Awo omalaika wa Musengwa nʼamukoba ati, “Okangeyo e giri omusengwawo, era omugondere.” ");
INSERT INTO gwr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Era omalaika nʼayongeraku ati, “Nalikuwa abaizukulu bangi ino ni babba nga tibabalika.” ");
INSERT INTO gwr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Era tete omalaika wa Musengwa nʼamukoba ati, “Atyanu oli kida, era walibyala omwana mwisuka. Walimuwa eriina oti, Isimairi, olwʼokubba oMusengwa aboine okunyolwakwo. ");
INSERT INTO gwr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Era yalibba wʼekinabbiri nga tafugika ooti mpunda wʼomu kigona. Yalibba mulabe wa buli muntu, era nabuli muntu yalibba mulabewe. Era yalibba wa bulabe eeri abantube bonabona.” ");
INSERT INTO gwr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Era Agali nʼawa oMusengwa eyatumwire naye, eriina ati, “Niiwe oKibbumba ambona,” olwʼokubba yakobere ati, “Atyanu mboine Oyo iye ambona.” ");
INSERT INTO gwr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Era eyo niiyo ensonga kagira beeta eiruba eriri aakati wʼe Kadesi nʼe Bberedi bati, “Eiruba lya Nanzwa wʼoBwomi iye aMbona.” ");
INSERT INTO gwr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kale Agali nʼabyala nʼoIbbulaamu omwisuka era oIbbulaamu nʼawa omwana oyo eriina Agali oguyabyaire ati, Isimairi. ");
INSERT INTO gwr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agali oweyabyaliire oIsimairi, oIbbulaamu yabbaire wʼemyanka 86. ");
INSERT INTO gwr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Awo oIbbulaamu oweyabbaire nga wʼemyanka 99, oMusengwa nʼamubonekera, nʼamukoba ati, “Ninze oKibbumba oWabwezye Bwonabwona, ongonderenge era obbenge mutuukirirye. ");
INSERT INTO gwr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Naliragaana endagaano yange na iwe, era nʼalikuwa abaizukulu bangi ino.” ");
INSERT INTO gwr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Awo oIbbulaamu nʼafuunama nʼaica empumi ansi okwitakali kaisi oKibbumba nʼamukoba ati, ");
INSERT INTO gwr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nze oku lwange endagaano eyange na iwe eri eti, walibba zeiza wʼamawanga mangi. ");
INSERT INTO gwr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Kale tibakaali bakweta Ibbulaamu, neye eriinalyo lyabbanga Ibbulaimu olwʼokubba nkusuucirye iteeye wʼamawanga amangi. ");
INSERT INTO gwr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Era nalikuwa abaizukulu bangi ino. Naligira nʼozwamu amawanga era nʼabamo kwibo balibba bakabaka. ");
INSERT INTO gwr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Era nalikola endagaano yange ngʼendagaano eyenkalaakalira aakati wange na iwe nʼeibyaireryo eryaliirawo. Yalibba ndagaano eyalikola omu mirembe egyaliirawo, era ngʼekoba eti, ‘Ninze oKibbumbawo era oKibbumba wʼeibyaireryo eryaliirawo.’ ");
INSERT INTO gwr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Era nalikuwa iwe nʼeibyaireryo eryaliirawo ekyalo kyonakyona ekyʼe Kanani ekyolimu ngʼomugeni, ni kibba kikyo nʼeibyaireryo emirembe nʼemirembe. Era nze, naabbanga Kibbumba wʼeibyaireryo.” ");
INSERT INTO gwr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Awo oKibbumba nʼakoba oIbbulaimu ati, “Iwe, oteekwa okukuuma endagaano yange, era nʼeibyaireryo eryʼemirembe egyaliirawo bona bateekwa okugikuuma. ");
INSERT INTO gwr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Enu niiyo engeri egimuli nʼokukuumamu endagaano yange, iwe nʼeibyaireryo eryaliirawo: Nabuli musaiza mwinywe yateekwanga okubba mukomole. ");
INSERT INTO gwr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Mwabbanga nʼokukomola era kaabbanga niiko akamanyiciryo akʼendagaano aakati wange na inywe. ");
INSERT INTO gwr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Omu bʼemirembe egyaliirawo, nabuli mwisuka mwinywe eyamalanga enaku omunaana, bateekwanga okumukomola. Omwo ngʼotwaliiryemu abaana abaisuka abemwabyalanga, era nʼabanamawanga abemwagulanga-obuguli. ");
INSERT INTO gwr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Abo abemwabyalanga, nʼabo abemwagulanga-obuguli, mwateekwanga okubakomola. Era ako kaabbanga niiko akamanyiciryo akʼobuliwo oku mibiri gyanywe, akʼendagaano yange eyenkalaakalira. ");
INSERT INTO gwr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Nabuli musaiza ogubatakomolenge, tiyaabbenge moiza oku bantu bange era yaabbanga tagondeire endagaano yange.” ");
INSERT INTO gwr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Era oKibbumba nʼakoba oIbbulaimu ati, “OSalaayi omukaliwo, tokaali omweta Salaayi, neye Saala niiryo eryabbanga eriinalye. ");
INSERT INTO gwr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Nalimuwa enkabi, era mazima nalikuwa omwisuka mwiye era oSaala nʼabba maaye wʼamawanga, nʼabamo kwibo ni babba bakabaka.” ");
INSERT INTO gwr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","OIbbulaimu nʼafuunama nʼaica empumi ansi okwitakali, neye nʼaseka, era ni yeebuulya omu mwoyogwe ati, “Dala kyezyeka omusaiza owʼemyanka 100 okubyala? Era dala kyezyeka oSaala owʼemyanka 90 okubyala?” ");
INSERT INTO gwr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Era oIbbulaimu nʼakoba oKibbumba ati, “Amo koizi oIsimairi niiye eyatwala enkabigyo!” ");
INSERT INTO gwr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Neye oKibbumba nʼamukoba ati, “Bbe, oSaala omukaliwo walibyala naye omwisuka era nʼomuwa eriina oti, Isaka. Nalikola endagaano yange na niiye, okubba endagaano eyenkalaakalira eeri eibyairerye eryaliirawo oluzwanyumalwe. ");
INSERT INTO gwr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","NʼoIsimairi, mpuliire ebyomusabiire. Era mazima nʼamuwa enkabi, era yalibba kibyali, era eibyairerye ni libba linene ino. Yalibba iteeye wa bafugi ikumi na babiri, era nalimuwa abaizukulu bangi ino ni babba igwanga erinene era eryʼamaani. ");
INSERT INTO gwr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Neye nalikola endagaano yange eyenkalaakalira nʼoIsaka, oSaala oguyalikubyalira omu mwanka ogwiza omu biseera ooti biinu.” ");
INSERT INTO gwr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Awo oKibbumba oweyamalire okutumula nʼoIbbulaimu, oKibbumba nʼamuleka aawo nʼayaba. ");
INSERT INTO gwr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Oku lunaku olunanyere olwo oIbbulaimu nʼakomola omutaane oIsimairi. Era kwolwo nʼakomola nʼabasaiza bonabona abandi ababbaire omu kisitokye, ngʼotwaliiryemu abagalama abebabyaliire omu kisitokye era nʼabeyabbaire agulire-obuguli. ");
INSERT INTO gwr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","OIbbulaimu yabbaire wʼemyanka 99 owebamukomoleire, ");
INSERT INTO gwr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","kaisi iye omutaane oIsimairi yabbaire wʼemyanka ikumi na misatu. ");
INSERT INTO gwr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","OIbbulaimu nʼomutaane oIsimairi babakomoire ku lunaku lunanyere olwo oMusengwa oluyamubonekeire. ");
INSERT INTO gwr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Era ni bakomola nʼabasaiza bonabona abʼomu kisitokye ngʼotwaliiryemu abo abebabyaliiremu, nʼabo abeyagulire oku banamawanga. ");
INSERT INTO gwr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lumo oIbbulaimu yabbaire okumpi nʼagavule aga Mamule oMusengwa nʼamubonekera. OIbbulaimu yabbaire atyaime nza oku mulyango gwʼeweema omusana ngʼakasana kapalukuka. ");
INSERT INTO gwr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Awo oIbbulaimu nʼasiirya amaisoge nʼabona abasaiza basatu nga beemereire okumpi aawo. Oweyababoine, nʼayalamuka okuzwa oku mulyango gwʼeweema okubasangaana, era nʼafuunama nʼaica empumi okwitakali ");
INSERT INTO gwr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","kaisi nʼakoba ati, “Owoobba nga sengwa onsiimire, tiwambitaku nze omuweereryawo. ");
INSERT INTO gwr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Aale oleke baleete otwizi, munaabeku ebigere, era muwuumulireku omu musaale gunu aanu. ");
INSERT INTO gwr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Era njaba okubasuniraku nʼekyokulya mulyeku okwiramu amaani kaisi mwabe. Ekyo kityo olwʼokubba mubitiireku e wange nze omuweererya waanywe.” Ni bakoba bati, “Ekyo kisa ino era okole otyo, ngʼowookobere.” ");
INSERT INTO gwr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kale oIbbulaimu nʼayanguwa okwaba omu weema egiri oSaala nʼamukoba ati, “Otegeke mangu ebipimo bisatu ebyʼobusye obusa, okande era osumbe ekyokulya.” ");
INSERT INTO gwr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Awo oIbbulaimu nʼairuka omu kiraalo kyʼente, ni yeeseeyamu okitobba omugondi era omusa, nʼawa omugalama era omugalama nʼayanguwa nʼamusala era nʼamusumba. ");
INSERT INTO gwr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Era oIbbulaimu nʼakwata amakita, nʼamata, nʼenyama egibasumbire, nʼainula abasaiza nago. Owebabbaire balya nʼayemerera okumpi nabo omu musaale okubaweererya ngʼomusimaami. ");
INSERT INTO gwr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Awo ni bamubuulya bati, “OSaala omukaliwo ali yaina?” Iye nʼabairamu ati, “Ali mu weema.” ");
INSERT INTO gwr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Awo oMusengwa nʼakoba ati, “Mazima nʼaliira eenu omwanka ogwo omu kiseera kinu, era oSaala omukaliwo yalibba aliku omwana mwisuka.” OSaala yabbaire awulisisya omu weema ngʼali oku mulyango oMusengwa e giyabbaire akubbiire omugongo. ");
INSERT INTO gwr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","OIbbulaimu nʼoSaala babbaire bakairiire, era nga babitiriire emyanka era ngʼoSaala yabitireku emyanka gyʼokubyala. ");
INSERT INTO gwr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kale oSaala nʼasekera omu kifubba ngʼakoba ati, “Nga nkairiire era nʼomusengwa wange yena ngʼakairiire, nkaali mpezya okusuna okwisangaalo lyʼokwegaita naye?” ");
INSERT INTO gwr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Awo oMusengwa nʼakoba oIbbulaimu ati, “Lwaki oSaala asekere era nʼakoba ati, ‘Dala nalibyala omwana nga nkairiire nti?’ ");
INSERT INTO gwr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Waliwo ekikaya oMusengwa? Omu biseera ebiragaane naliira eenu omwanka ogwiza era oSaala yalibba aliku omwana mwisuka.” ");
INSERT INTO gwr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","OSaala nʼatya, kale ni yeegaana ngʼakoba ati, “Tinsekere.” Neye oMusengwa nʼakoba ati, “Oleke okwegaana, osekere.” ");
INSERT INTO gwr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Awo abasaiza ni basetuka okuzwa e wa Ibbulaimu, ni baaba awantu okulengera oSodoma era oIbbulaimu nʼayaba nabo okubeerekaku. ");
INSERT INTO gwr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Awo oMusengwa nʼakoba ati, “Tinabisabise oIbbulaimu ekindi kumpi okukola. ");
INSERT INTO gwr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ekyo kityo olwʼokubba mazima eibyaire lya Ibbulaimu lyalibba igwanga erinene era eryʼamaani, era amawanga gonagona agʼoku kyalo galisuna enkabi kubitira mu niiye. ");
INSERT INTO gwr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Era kagira mmulondere, kaisi ayezye okulungamya abaanabe nʼabaizukulube abaliirawo okungonderanga nze oMusengwa nga bakola ebyobutuukirirye nʼebyʼobwenkanya. Olwo kaisi nze oMusengwa mpezye okumukolera ebinamusuubizire.” ");
INSERT INTO gwr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Awo oMusengwa nʼakoba oIbbulaimu ati, “Okwezulugumira abantu bʼe Sodoma nʼe Gomola kubitiriri ino, era bakola ebikole bibbibibbi ino. ");
INSERT INTO gwr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kale oleke nserengeteyo mbone ooba ngʼokwezuluguma okwo okutuukire egyendi kutuuce ooba bbe era obanga tikityo, namanya.” ");
INSERT INTO gwr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Awo abasaiza badi ababiri ibo ni bazwa aawo ni basimba e Sodoma, neye oIbbulaimu nʼasigala ngʼakaali ayemereire omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Kale oIbbulaimu nʼaigerera e gyali kaisi nʼamubuulya ati, “Wajigirica abatuukirirye aamo nʼabakola ebikole ebibbibibbi? ");
INSERT INTO gwr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Olwo singa omu kibuga mwabbaamu abatuukirirye 50? Olwo dala wakijigirica era nandi nʼokisoniya oku lwʼabatuukirirye 50 abakirimu? ");
INSERT INTO gwr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kyabba tikisa okukola otyo, iwe okwita abatuukirirye aamo nʼabakola ebikole ebibbibibbi, era okubitya abatuukirirye nʼabakola ebikole ebibbibibbi omu ngeri efaanana. Era mazima tiwakikola. Aale oMulamuzi wʼekyalo kyonakyona takola ekintu ekituuce?” ");
INSERT INTO gwr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","OMusengwa nʼairamu oIbbulaimu ati, “Singa nayajirya abatuukirirye 50 omu kibuga e Sodoma, naleka ekibuga kyonakyona oku lwabwe.” ");
INSERT INTO gwr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","OIbbulaimu tete nʼakoba ati, “Musengwa onsoniye okuguma ni neeyongera okutumula na iwe newankubbaire nga ndi muntu-buntu era ndi nkungu era ikoke. ");
INSERT INTO gwr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Olwo singa oku batuukirirye 50 kwabba kubulaku abataanu? Era wajigirica ekibuga ekyo kyonakyona olwʼokubba abataanu babulaku?” Awo oMusengwa nʼakoba ati, “Owenayajiryayo 45 tinakijigirice.” ");
INSERT INTO gwr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tete era oIbbulaimu nʼamukoba ati, “Olwo singa wayajiryayo 40 bonkani?” Iye nʼamwiramu ati, “Oku lwʼabantu 40 tinakijigirice.” ");
INSERT INTO gwr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Awo oIbbulaimu nʼamukoba ati, “Nkwegairiire Musengwa tiwasunguwala era oleke ntumuleku tete. Olwo singa wayajiryayo 30.” Iye nʼamwiramu ati, “Tinakikole singa nayajiryayo 30.” ");
INSERT INTO gwr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Era oIbbulaimu nʼakoba ati, “Musengwa onsoniye okuguma ni yeeyongera okutumula na iwe. Olwo singa wayajiryayo aabiri bonkani?” Iye oMusengwa nʼakoba ati, “Oku lwʼabantu aabiri tinakijigirice.” ");
INSERT INTO gwr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Awo oIbbulaimu nʼakoba ati, “Nkwegairiire Musengwa tiwasunguwala, era oleke tete ntumuleku omulundi ogundi gumo gwonkani. Olwo singa wayajiryayo ikumi?” Iye nʼairamu ati, “Oku lwʼabantu eikumi tinakijigirice.” ");
INSERT INTO gwr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Awo oMusengwa oweyamalire okutumula nʼoIbbulaimu ni yeeyabira era nʼoIbbulaimu yena nʼakanga e wuwe. ");
INSERT INTO gwr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Awo abamalaika nago ababiri ni batuuka e Sodoma eigulo, era oLuuti yabbaire atyaime oku mulyango gwʼekikomera kyʼoku kibuga kyʼe Sodoma. OLuuti oweyababoine, nʼasetuka okubasangaana era nʼafuunama nʼaica empumi ansi okwitakali okubawa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Awo oLuuti nʼakoba ati, “Basengwa bange, mbegairiire mwawukeku e wange, nze omuweererya waanywe. Era muyinza nʼokunaabaku ebigere era ni mugonawo, kaisi eizo amakeezi ni mwaba omu lugendo lwanywe.” Ibo ni bairamu bati, “Bbe, iswe twagona nza mu kiweeru aawo.” ");
INSERT INTO gwr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Neye iye nʼabaazya ino era nʼabatwala e wuwe. Era nʼabasumbira ekiinulo nʼemigaati egibulamu okazumbulukuca era ni balya. ");
INSERT INTO gwr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Awo owebabbaire nga bakaali okugona, abasaiza abatobato nʼabakulu abangi eino okuzwa omu bitundu ebitali bimo ebyʼekibuga ekyʼe Sodoma, ni bazingiza enyumba ya Luuti. ");
INSERT INTO gwr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Era ni beeta oLuuti bati, “Abasaiza bali yaina abacaire aanu eigulo? Obatuwulucirye twegaite nabo.” ");
INSERT INTO gwr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Awo oLuuti nʼawuluka e nza e gibali era nʼaigalawo olwigi, ");
INSERT INTO gwr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","kaisi nʼabakoba ati, “Mbegairiire bainange, timwakola ekikole ekibbikibbi ekyenkanaawo. ");
INSERT INTO gwr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Aale mubone eenu, ndi nʼabaala bange babiri abakaali abaguna. Oleke mbabawulucirye era mwezye okubakola ekimutaka, neye abasaiza abo timwabakola ekintu kyonakyona. Ekyo kityo olwʼokubba abasaiza abo bageni bange kale ndi nʼokubakuuma.” ");
INSERT INTO gwr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Awo ibo ni bairamu bati, “Otuzwerewo.” Era ni bakoba bati, “Iwe omusaiza omuwuli niiwe otuwa ekyokukola! Aale atyanu twakubitya niiwe obundi okukiraku ibo.” Era ni beeyongera okukaluubirira ino oLuuti, era ni baigerera okuvuna olwigi. ");
INSERT INTO gwr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Neye abasaiza badi ababiri ababbaire omu nyumba ni bawuluka ni bakuusawo oLuuti ni bamukanja omu nyumba era ni baigalawo olwigi. ");
INSERT INTO gwr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Era awo ni boofuwalya abasaiza badi ababbaire oku mulyango, abatobato nʼabakulu kaisi tibayezya okubona omulyango. ");
INSERT INTO gwr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Awo abasaiza nago ababiri ni bakoba oLuuti bati, “Oliku aanu nʼabantu abandi? Ekikoba kiti, abasaiza abasuubizire okufumbirwa abaalabo, nʼabaanabo, ooba omuntu wʼolulyolwo yenayena aanu omu kibuga? Obwekibba kityo aale obatoole aanu, ");
INSERT INTO gwr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","olwʼokubba twaba okujigirica ekibuga kinu. Era okwezulugumira abantu baakyo eeri oMusengwa kwʼamaani ino, kale era atutumire kukijigirica.” ");
INSERT INTO gwr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kale oLuuti nʼayaba era nʼatumula nʼabasaiza ababbaire basuubizire okufumbirwa abaalabe, era nʼabakoba ati, “Mwanguweku muzwe omu kibuga kinu olwʼokubba oMusengwa ali kumpi okukijigirica.” Neye abasaiza abasuubizire okufumbirwa abaalabe baseegere bati oLuuti ajanja. ");
INSERT INTO gwr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Awo owebwaceire amakeezi, abamalaika ni bakubbiriza oLuuti nga bamukoba bati, “Oyanguweku! Okwate omukaliwo, nʼabaalabo bombi abali aanu mwabe kaisi tibabajigirica nga babonereza ekibuga.” ");
INSERT INTO gwr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Neye oLuuti ni yeezizyazizya. Kale awo abasaiza ni bamukwata oku ngalo, nʼoku ngalo ya mukaliwe, nʼoku ngalo gyʼabaalabe bombi. Era ni babawuluca omu kibuga olwʼokubba oMusengwa yabbaire abakwatiire ekisa. ");
INSERT INTO gwr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Awo nga bankubawulucaamu, omoiza oku bamalaika nago nʼabakoba ati, “Mwiruke mulame okufa! Timwalola e nyuma, era timwemerera awantu wonawona omu kyalo ekibulamu ensozi! Mwirukire mu nsozi, nga bbe baaba kubajigirica!” ");
INSERT INTO gwr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Neye oLuuti nʼabakoba ati, “Bbe, basengwa bange, mbegairiire! ");
INSERT INTO gwr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Munsiimire nze omuweererya waanywe, era mundagire ekisa kyʼamaani nga mundamya okufa. Neye timpezya okwirukira omu nsozi. Nnaabba nkaali okutuukayo akabbikabbi ako ni kantuukaku ni nfa. ");
INSERT INTO gwr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Neye aale obone eedi ekibuga kidi ikyo kiri kumpi, oleke njirukire omwo era nkako katono. Ondeke njirukire omwo, nkikyo kitono, tiniikyo? Awo kaisi obwomi bwange bulame.” ");
INSERT INTO gwr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Awo omalaika nʼamwiramu ati, “Kale ekyo kyona ekyosabire nkiikiriirye. Era tinaire okujigirica ekibuga ekyotumwireku. ");
INSERT INTO gwr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Neye era oirukireyo mangu olwʼokubba timpezya okukola ekintu kyonakyona ngʼokaali okukituukamu.” Ekibuga ekyo kagira bakyeta Zowaali. ");
INSERT INTO gwr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Eisana lyabbaire lizwireyo oLuuti oweyatuukiire omu Zowaali. ");
INSERT INTO gwr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Awo oMusengwa nʼatoonyesya oku Sodoma nʼoku Gomola omusyo nʼobuganga bwa mabbaale ebyoca eino nga bizwa omwigulu. ");
INSERT INTO gwr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Omu ngeri eyo nʼajigirica ebibuga ebyo, nʼekyalo ekyo kyonakyona ekibulamu ensozi, aamo nʼabantu bonabona ababbaire omu bibuga ebyo, ekikoba kiti nabuli kintu ekimera okwitakali. ");
INSERT INTO gwr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Neye omukali wa Luuti, nʼalola e nyuma nʼasuuka kikondo kya cumbi. ");
INSERT INTO gwr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Awo oIbbulaimu nʼasetuka eizo amakeezi nʼakanga omu kifo aweyabbaire ayemereireku omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kale nʼalingirira e Sodoma nʼe Gomola e gibiri, era nʼeeri ekyalo kyonakyona ekyo ekibulamu ensozi, nʼalengera ogwosi ogwʼamaani nga guzwerayo nga guduunya ooti guudi oguzwera omu tanuulu. ");
INSERT INTO gwr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kale oKibbumba oweyajigiricirye ebibuga ebyʼomu kyalo ekyo ekibulamu ensozi oLuuti omu yabbaire omutyami, nʼayebukirya oIbbulaimu era nʼatoola oLuuti omu kujigirika okwabbaire omu bibuga ebyo. ");
INSERT INTO gwr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Awo oLuuti nʼaniinaniina nʼazwa omu Zowaali, nʼayaba nʼatyama omu nsozi nʼabaalabe bombi olwʼokubba yatiire okutyama omu Zowaali. Eeyo omu nsozi, iye nʼabaalabe bombi babbanga mu mpuku. ");
INSERT INTO gwr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lwabbaire lumo omwala wa Luuti omukulu waaku nʼakoba omutomuto waaku ati, “Oitewaiswe akairiire, kaisi mpaawo kunu musaiza, kale titwezya kwegaita nʼomusaiza ngʼempisa yʼoku kyalo kyonakyona obweri. ");
INSERT INTO gwr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Nʼolwekyo, tunywisye oitewaiswe enviinyo ateemeere, kaisi twegaite naye atubyalemu abaana tubbeesyewo eibyairerye nga tubitira mu niiye.” ");
INSERT INTO gwr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Era ekiire ekyo ni banywisya oitewaabwe enviinyo era omwala omukulu nʼayaba ni yeegaita nʼoitewaabwe. Olwʼobuteemeere oitewaabwe tiyakimanyicirye ngʼomwala yeegaita naye era tiyakimanyicirye ngʼomwala asetukawo. ");
INSERT INTO gwr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Awo oku lunaku olwairireku, omwala omukulu waaku nʼakoba omutomuto waaku ati, “Eizo obwire neegaitire nʼobbaabba. Oleke tumunywisye enviinyo tete ekiire kinu era wena oyabe weegaite naye atubyalemu abaana kaisi tubbeesyewo eibyairerye nga tubitira mu niiye.” ");
INSERT INTO gwr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Era ni banywisya oitewaabwe enviinyo nʼekiire ekyo kyona, era omwala omutomuto waaku yena nʼayaba ni yeegaita naye. Tete era olwʼobuteemeere oitewaabwe tiyamanyicirye nga yeegaitire naye era tiyamanyicirye ngʼomwala asetukawo. ");
INSERT INTO gwr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Kale awo abaala ba Luuti bombi ni babba bida bya itewaabwe. ");
INSERT INTO gwr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Iye omwala omukulu waaku nʼabyala omwana mwisuka, nʼamuwa eriina ati, Mowaabbu, ngʼoyo niiye ozeiza wʼaBamowaabbu paka atyanu. ");
INSERT INTO gwr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Era nʼomutomuto waaku yena nʼabyala omwana mwisuka, nʼamuwa eriina ati, Bbenami, ngʼoyo niiye ozeiza wʼaBaamoni paka atyanu. ");
INSERT INTO gwr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Atyanu awo oIbbulaimu nʼazwa e Mamule nʼayaba omwitwale lyʼeidungu oNegevu era nʼatyama omu kifo ekiri aakati wʼe Kadesi nʼe Suuli. Oluzwanyuma nʼatyamaku omu Gerali akaseera katyayi kati, ");
INSERT INTO gwr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","era eeyo niiyo oIbbulaimu e giyatumuliire oku Saala omukaliwe ati, “Oyo mwonyoko wange.” Era awo Abbimereki okabaka wʼe Gerali nʼalagira bamutwalire oSaala era nʼamutwala obufumbo. ");
INSERT INTO gwr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Neye oKibbumba nʼabonekera Abbimereki obwire omu kirooto kaisi nʼamukoba ati, “Obwoli aawo iwe oli mufu olwʼomukali ogwotwaire. Oyo mukali mufumbo.” ");
INSERT INTO gwr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Atyanu iye Abbimereki yabbaire akaali okwegaita naye kale nʼakoba ati, “Musengwa Kibbumba, waita omuntu onambulaku omusango? ");
INSERT INTO gwr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Aale iye oIbbulaimu tiyankobere ati oSaala mwonyokowe? Era oSaala yena tiyankobere ati oIbbulaimu mwonyokowe? Ekyo nʼakikolere nga mmaite nti ekinkola tikibbikibbi era nga timpulira musango omu mwoyo gwange.” ");
INSERT INTO gwr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Awo oKibbumba nʼamukoba omu kirooto ati, “Niikyo ekyo, mmaite ngʼekiwakolere mwabbaire mpaamu musango, era zena tinakuganyire okukola ekibbikibbi eeri nze. Niikyo ekyo kagira tinakuganyire nʼokwegaita naye. ");
INSERT INTO gwr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Aale atyanu omukali oyo omukanjirye oibaaye, olwʼokubba oibaaye naabbi, yakusabira era nʼobba mwomi. Neye owootamukanje, oli nʼokumanya oti iwe nʼabantubo bonabona mazima muli bafu.” ");
INSERT INTO gwr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Awo Abbimereki nʼasetuka eizo amakeezikeezi, nʼayeta abakungube bonabona, era oweyabakobeire ebyo byonabyona ebyabbaire bituukirewo ni batya ino. ");
INSERT INTO gwr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Awo Abbimereki nʼalagira ni beeta oIbbulaimu kaisi nʼamukoba ati, “Watukolere niki? Nakusoberye niki okundeetera nze nʼobwakabaka bwange omusango ogwʼamaani guti? Ebiwankolere tibikolekeka.” ");
INSERT INTO gwr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Era Abbimereki nʼabuulya oIbbulaimu ati, “Wabbaire na nsongaki okukola ekyo?” ");
INSERT INTO gwr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Iye oIbbulaimu nʼamwiramu ati, “Naseegere nti, ‘Mazima aanu mpaawo muntu atya oKibbumba era banjita olwa mukali wange.’ ");
INSERT INTO gwr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Neye era iye dala mwonyoko wange, olwʼokubba oitewaiswe moiza newankubbaire abamawaiswe baawule, neye era yasuukire mukali wange. ");
INSERT INTO gwr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Era oKibbumba oweyankobere okuzwa e waiswe, nʼakobere oSaala nti, ‘Enu niiyo engeri egyoyezya okundagangamu ngʼontaka: Nabuli wantu egitwabanga, okobenge abantu oti ndi mwonyokowo.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Awo Abbimereki nʼakwata entaama, nʼente, nʼabagalama abasaiza nʼabakali, nʼabiwa oIbbulaimu era nʼamukanjirya nʼoSaala omukaliwe. ");
INSERT INTO gwr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Era Abbimereki nʼamukoba ati, “Atyanu, eitakali lyange nkuwaire, kiri gyoli okutyama wonawona e gyotaka.” ");
INSERT INTO gwr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Era Abbimereki nʼakoba iye oSaala ati, “Atyanu ndi kuwa omwonyokowo esekeri gyʼefeeza 1,000. Ekyo kiri kubba ngʼakamanyiciryo okulaga abooli nabo bonabona nti obuliraku nakimo omusango.” ");
INSERT INTO gwr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Era awo oIbbulaimu nʼasaba oKibbumba era oKibbumba nʼalamya Abbimereki, nʼomukali wʼAbbimereki era nʼabagalama bʼAbbimereki abakali, kaisi abantu abo bayezye okubyala tete. ");
INSERT INTO gwr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ekyo kyabbaire kityo olwʼokubba oMusengwa yabbaire asibireku abakali bonabona abʼomu kisito kyʼAbbimereki okubyala olwa Saala omukali wa Ibbulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Awo oMusengwa nʼakwatira oSaala ekisa ngʼoweyabbaire asuubizire. ");
INSERT INTO gwr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kale oSaala nʼabba kida nʼabyalira oIbbulaimu omwana mwisuka omu kiseera oKibbumba ekiyabbaire asuubizire oIbbulaimu. Omu kiseera ekyo oIbbulaimu yabbaire akairiire. ");
INSERT INTO gwr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","OIbbulaimu nʼawa omwana oyo eriina oSaala oguyamubyaliire ati, Isaka. ");
INSERT INTO gwr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Awo oIsaka oweyayererye enaku omunaana, oIbbulaimu nʼamukomola okutuukirirya ekiragiro oKibbumba ekiyabbaire amuwaire. ");
INSERT INTO gwr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","OIbbulaimu yabbaire wʼemyanka 100, owebabyaliire omwanawe oIsaka. ");
INSERT INTO gwr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Awo oSaala nʼakoba ati, “OKibbumba ampaire eisangaalo, era nabuli muntu eyakiwulirangaku yena yasangaalanga.” ");
INSERT INTO gwr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Era oSaala nʼayongeraku ati, “Aale naani eyandikobere oIbbulaimu ati oSaala yaliyonkesya abaana, oIbbulaimu nʼaikirirya? Neye aale obone mbyaire naye omwana omwisuka omu myankagye egyʼobukaire.” ");
INSERT INTO gwr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kale omwana nʼalawuka ni bamuzirisya, era oku lunaku olubamuzirisiiryeku, oIbbulaimu nʼasumba embaga eyʼamaani. ");
INSERT INTO gwr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lwabbaire lumo oSaala nʼabona oIsimairi, omwana Agali oMumisiri oguyabyaire nʼoIbbulaimu, ngʼayereza oIsaka. ");
INSERT INTO gwr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Awo oSaala nʼakoba oIbbulaimu ati, “Obbinge omugalama oyo omukali nʼomwanawe, olwʼokubba omwana wa mugalama oyo tali nʼokugabana oku byʼobusika bya mwana wange oIsaka.” ");
INSERT INTO gwr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ekyo kyanakuwairye ino oIbbulaimu olwʼokubba oIsimairi yena yabbaire mwanawe. ");
INSERT INTO gwr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Neye oKibbumba nʼakoba oIbbulaimu ati, “Oleke okunakuwala olwa Isimairi nʼolwʼomugalamawo omukali. Okole nabuli kintu oSaala ekyakukoba, olwʼokubba omwIsaka mu walisunira abaizukulu. ");
INSERT INTO gwr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Era omutaane wʼomukali oyo omugalamawo yena nʼalimuwa abaizukulu bangi ni babba igwanga, olwʼokubba yena mwanawo.” ");
INSERT INTO gwr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kale awo oIbbulaimu nʼalamuka eizo amakeezikeezi, nʼatoola ekyokulya nʼekisawo kyʼeidiba ekibasukiremu amaizi nʼabiwa Agali. Era nʼabimuyeekesya oku mabega kaisi nʼamuseebula nʼomwana. Agali nʼayaba nʼagadangada omwidungu eryʼe Bberusebba. ");
INSERT INTO gwr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Awo amaizi owegawoire omu kisawo, Agali nʼayaba nʼateeka omwana omu busaalesaale. ");
INSERT INTO gwr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kaisi iye nʼayaba nʼatyama yalaku, okuzwa e giri omwana nga waliwo emita ooti 100. Yakolere atyo olwʼokubba yakobere omu mwoyogwe ati, “Timpezya okuguma ni mbona omwana wange ngʼafa.” Era Agali oweyabbaire atyaime, nʼatandiika okukuukulya. ");
INSERT INTO gwr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Awo oluzwanyuma oKibbumba nʼawulira omwana nago ngʼakunga, kale omalaika wa Kibbumba ngʼali omwigulu nʼayeta Agali, nʼamukoba ati, “Agali, obbaire niki? Tiwaatya, olwʼokubba oKibbumba awuliire omwanawo ngʼakunga. ");
INSERT INTO gwr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Osetuke, omusetule, omwemererye era omusaninkirirye. Ekyo kityo olwʼokubba nalimuwa eibyaire linene ino ni libba igwanga erinene era eryʼamaani.” ");
INSERT INTO gwr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Awo oKibbumba nʼalaga Agali eiruba, era Agali nʼayaba nʼasena amaizi nʼaizulya ekisawo ekiyabbaire nakyo, nʼagawa omwanawe nʼanywaku. ");
INSERT INTO gwr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Era oKibbumba nʼalabiriranga omwana oyo nga waakula, omwana oyo nʼabba mutyami wʼomwidungu, era nʼasuuka mukubbi wʼakalaso. ");
INSERT INTO gwr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Eidungu eryo omuyabbaire omutyami babbaire balyeta Palani. Omaaye nʼamusunira omukali owʼomu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lwabbaire lumo okabaka Abbimereki nʼayaba nʼoFikoli omuduumiriwe owa maje e giri oIbbulaimu, kaisi Abbimereki nʼakoba oIbbulaimu ati, “OKibbumba akubbeera iwe mu byonabyona ebyokola. ");
INSERT INTO gwr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Atyanu ntaka ondayirire aanu omumaiso ga Kibbumba oti, tiwalimbitya kubbikubbi nʼabaana bange, waire abaizukulu bange. Neye wankoleranga ebyʼekisa nze nʼabantu bʼomu kyalo kinu omwotyaime, nga zena obwenkukoleire.” ");
INSERT INTO gwr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kale oIbbulaimu nʼakoba ati, “Ndayira tinalikubitya kubbikubbi.” ");
INSERT INTO gwr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Awo oIbbulaimu ni yeezuluguma eeri Abbimereki olwʼeiruba abaweererya bʼAbbimereki eribabbaire bamunyagireku. ");
INSERT INTO gwr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Neye Abbimereki nʼakoba ati, “Timmaite omuntu eyakolere ekintu ekyo, kaisi wena tiwankobeireku ekyo. Era olwatyanu lunsookere okukiwulira.” ");
INSERT INTO gwr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Awo oIbbulaimu nʼakwata entaama nʼente, nʼagiwa Abbimereki, era bombi ni bakola endagaano. ");
INSERT INTO gwr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Neye oIbbulaimu nʼakwata entaama enduusi musanvu omu kiraalokye nʼagyawulaku. ");
INSERT INTO gwr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Awo Abbimereki nʼabuulya oIbbulaimu ati, “Entaama egyo enduusi omusanvu egyoyawireku, gitegeeza niki?” ");
INSERT INTO gwr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","OIbbulaimu nʼamwiramu ati, “Oikirirye otwale entaama egyo enduusi omusanvu, ekyo kibbe kamanyiciryo akakakasa kati oikiriirye oti ninze enakwire eiruba eryo.” ");
INSERT INTO gwr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Nʼolwekyo ekifo ekyo ni bakyeta Bberusebba, olwʼokubba eeyo niiyo bombi e gibakoleire endagaano. ");
INSERT INTO gwr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kale awo owebamalire okukola endagaano e Bberusebba, Abbimereki nʼoFikoli omuduumiriwe owʼamaje ni bakanga omu kyalo kyʼaBafirisuuti. ");
INSERT INTO gwr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Awo oIbbulaimu nʼakoma omu Bberusebba omusaale ogubeeta bati, tamalisika, era nʼasinzira eeyo oMusengwa aTawaawo. ");
INSERT INTO gwr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Era oIbbulaimu nʼabba mutyami omu kyalo kyʼaBafirisuuti, okumala eibbanga linene. ");
INSERT INTO gwr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Awo nga wabitirewo ekiseera, oKibbumba nʼagezesya oIbbulaimu okubona ngʼamugondera, kale nʼamweta ati, “Ibbulaimu!” OIbbulaimu nʼayetuka ati, “Waitu!” ");
INSERT INTO gwr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","OKibbumba nʼamukoba ati, “Okwate omwanawo oIsaka, oyo ogwoli naye omoiza yenkani era ogwotaka eino, oyabe naye omu kyalo kyʼe Moliya, oku lusozi olunalikulaga. Oyabe omuweereyo eeyo abbe sadaaka egibooca yonayona.” ");
INSERT INTO gwr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Eizo amakeezikeezi, oIbbulaimu nʼalamuka nʼabbeeta enkwi egyʼokwocerya esadaaka, era nʼategeka ompundawe. Awo nʼakwata ababiri oku baweereryabe, nʼomwanawe oIsaka, ni basimbuka okwaba omu kifo oKibbumba ekiyabbaire amukobere. ");
INSERT INTO gwr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Awo nga bamalire enaku ibiri, olwokusatu oIbbulaimu nʼasiirya amaiso nʼalengera ekifo egibabbaire baaba. ");
INSERT INTO gwr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Awo nʼakoba abaweereryabe ati, “Musigale aanu nʼompuda, nze nʼomwana wange twabe eedi tusinze, kaisi oluzwanyuma twire e gimuli.” ");
INSERT INTO gwr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kale awo oIbbulaimu nʼatoola enkwi egyʼokwocerya esadaaka nʼagitiika omwanawe oIsaka, iye oIbbulaimu nʼakwata amakala agaliku omusyo nʼempiima, ni baaba aamo bombi. ");
INSERT INTO gwr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Awo oIsaka nʼayeta oiteeye ati, “Bbaabba!” OIbbulaimu nʼayetuka ati, “Waitu, okoba otya mwana wange.” OIsaka nʼamukoba ati, “Mbona tuli nʼamakala agaliku omusyo nʼenkwi, neye ontaama omutomuto owʼesadaaka egibooca yonayona ali yaina?” ");
INSERT INTO gwr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","OIbbulaimu nʼamwiramu ati, “Mwana wange, oKibbumba iye onanyere yagabirira ontaama omutomuto owʼesadaaka eyo.” Awo bombi ni beeyongera nga batambula. ");
INSERT INTO gwr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Atyanu owebatuukire omu kifo oKibbumba ekiyabbaire amukobere, oIbbulaimu nʼayombeka ekyoto, nʼapangaku enkwi, kaisi nʼasiba omwanawe oIsaka, nʼamugalaamirirya oku nkwi egiri oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Awo oIbbulaimu nʼatoola empiima okwita omwanawe. ");
INSERT INTO gwr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Neye omalaika wa Musengwa ngʼali omwigulu, nʼamweta ati, “Ibbulaimu! Ibbulaimu!” OIbbulaimu nʼayetuka ati, “Waitu!” ");
INSERT INTO gwr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Omalaika nʼamukoba ati, “Tiwaita omwanawo era tomukolaku akabbikabbi konakona. Atyanu ntegeire ngʼotya oKibbumba. Ekyo kityo olwʼokubba tiweezizyazizirye oku kyʼokuwaayo omwanawo, omwana omoiza yenkani.” ");
INSERT INTO gwr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Awo oIbbulaimu nʼasiirya amaiso nʼabona ontaama omusaiza ngʼamazigage geekwatiire omu bisaale. Kale nʼayaba nʼamutoolayo, nʼamuwaayo abbe sadaaka egibooca yonayona omu kifo kyʼokuwaayo omwanawe. ");
INSERT INTO gwr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kale oIbbulaimu nʼawa ekifo ekyo eriina ati, “OMusengwa aGabirira.” Era paka lwatyanu ekifo ekyo abantu bakyeta bati, “Oku lusozi olubeeta bati, ‘OMusengwa aGabirira.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Awo omalaika wa Musengwa ngʼali omwigulu nʼayeta oIbbulaimu omulundi ogwokubiri. ");
INSERT INTO gwr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Era nʼamukoba ati, “OMusengwa akoba ati, ‘Nze onanyere ndayira, olwʼokubba okolere otyo, tiweezizyazizirye oku kyʼokuwaayo omwanawo, omwana omoiza yenkani, ");
INSERT INTO gwr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","dala nalikuwa enkabi. Era nalikuwa eibyaire linene ino ni libbaamu abantu bangi ooti nkota egiri angulu egitabalika, era bangi ooti musenye oguli oku mbale kwʼenyanza ogutabalika. Era eibyaireryo lyaliwangula era ni liwamba ebibuga byʼabalabe baabwe. ");
INSERT INTO gwr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Era amawanga gonagona agʼoku kyalo naligawa enkabi nga mbitira mwibyaireryo, olwʼokubba ongondeire.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Awo oIbbulaimu nʼoIsaka ni bakanga egiri abaweererya ba Ibbulaimu. Era ni basimbuka bonabona aamo ni bakanga e Bberusebba, era oIbbulaimu ni yeeyongera okubba mutyami waayo. ");
INSERT INTO gwr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Awo nga wabitirewo ekiseera, ni bakobera oIbbulaimu bati, “OMirika yena mukali mubyaire, era yabyaire nʼomugandawo oNakoli abaana munaana. ");
INSERT INTO gwr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Omutaane waabwe omubere niiye oWuzi, kwoyo ni kwiraku oBbuzi, ni kwiraku oKemwiri oiteeye wʼAlamu. ");
INSERT INTO gwr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Awo ni kwiraku oKesedi, kwoyo ni kwiraku oKazo, ni kwiraku oPirudaasi, ni kwiraku oIdulaafu, ni kwiraku oBbeesweri.” ");
INSERT INTO gwr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","OBbeesweri oyo niiye oiteeye wa Labbeeka. Abo niibo abaana omunaana oMirika abeyabyaire nʼoNakoli omuganda wa Ibbulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Atyanu oLewuma omukali wa Nakoli ogondi yena nʼabyala abaana bana: OTebba, nʼoGakamu nʼoTakasi, nʼoMaaka. ");
INSERT INTO gwr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","OSaala yawangaire emyanka 127, ");
INSERT INTO gwr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","nʼafeera omu kibuga e Kiriyaasi Alubba, okuti ekibeeta Kebbulooni omu kyalo kyʼe Kanani. Era oweyafiire, oIbbulaimu nʼaingira omu weema omulambo omugwabbaire, nʼamukunga, era nʼakulumuca nʼamaliga. ");
INSERT INTO gwr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Awo oluzwanyuma oIbbulaimu nʼasetuka nʼazwa e giri omulambo gwʼomukaliwe, nʼayaba eeri aBakiiti, nʼabakoba ati, ");
INSERT INTO gwr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Nze ndi musenze era tindi wʼeigwanga lyanywe. Mungulyeku eitakali lyʼokuliikangamu abafu, mpezye okuliikamu omufu wange.” ");
INSERT INTO gwr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Awo aBakiiti ni bamwiramu bati, ");
INSERT INTO gwr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Mukulu iswe tubbaire tukoba tuti, iwe tukutwala ngʼomukungu wa Kibbumba mwiswe. Oliike omufuuwo omu magombe agʼempuku agewasiimaku, ku gonagona agetulinago. Kwiswe mpaawo muntu eyakugaana okuteeka omufuuwo omu magombe agewasiima.” ");
INSERT INTO gwr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Awo oIbbulaimu nʼasetuka nʼakotama omumaiso ga Bakiiti okubawa ekitiisya, ");
INSERT INTO gwr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","kaisi nʼabakoba ati, “Obwemubba nga musiima ndiike aanu omufu wange, mbaire nkoba nti muneegairirireku Efulooni omutaane wa Zokali, ");
INSERT INTO gwr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","angulye empukuye eeri e Makupera, iyo eeri omwitakalirye egirikoma. Mumusabe agingulirye yaanu mumaiso gaanywe, oku bbeeyi yaayo entuuce, kaisi ebbe yange eyʼokuteekangamu abafu.” ");
INSERT INTO gwr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Atyanu Efulooni yena yabbaire atyaime aawo aamo nʼaBakiiti abainaye, okumpi nʼomulyango gwʼekikomera kyʼoku kibuga. Awo Efulooni nʼairamu oIbbulaimu ngʼabantu bonabona abaliwo bawulira ati, ");
INSERT INTO gwr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kadi, mukulu nze mbaire nkoba nti, nkuwa ekigona kyonakyona, nʼempuku erimu. Era ndi kubikuweera yaanu mumaiso gʼabantu bange, iwe oteekemu omufuuwo.” ");
INSERT INTO gwr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tete oIbbulaimu nʼakotama omumaiso ga Bakiiti okubawa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Era nʼakoba Efulooni ngʼabantu bonabona abaliwo bawulira ati, “Nze mbaire nkoba nti, eitakali lyonalyona owoobba ngʼoikiriirye okulimpa, nʼakugulaku-buguli. Oikirirye nkusasule, awo kaisi ndiikemu omufu wange.” ");
INSERT INTO gwr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Era tete Efulooni nʼairamu oIbbulaimu ati, ");
INSERT INTO gwr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mukulu, mbaire nkoba nti, eitakali eryo ligula esekeri gyʼefeeza 400, neye ekyo tikikulu, iwe oliikemu omufuuwo.” ");
INSERT INTO gwr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Awo oIbbulaimu nʼaikirirya ebbeeyi Efulooni egiyamukobere, era nʼamuwa esekeri egyʼefeeza 400 egiyabbaire amukobere ngʼabantu bonabona abaliwo bawulira. OIbbulaimu yabalire esekeri egyʼefeeza 400, ngʼakolesya ekipimo kyʼabasuubuuzi. ");
INSERT INTO gwr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kale omu ngeri etyo eitakali lyʼEfulooni eryʼe Makupera ekiri e buzwaisana bwʼekitundu ekibeeta Mamule, ngʼotwaliiryemu empuku, nʼemisaale gyonagyona okutuukira nakimo egirikoma, ni lisuukira nakimo lya Ibbulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Lityo eitakali ni lisuuka lirye ngʼabantu bonabona ababbaire okumpi nʼomulyango gwʼekikomera kyʼoku kibuga babona era ngʼaBakiiti niibo abajulizi abakakasa. ");
INSERT INTO gwr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Awo oIbbulaimu oweyamalire okugula eitakali eryo nʼateeka omukaliwe oSaala omu mpuku eyʼomwitakali nago eryʼe Makupera okumpi nʼe Mamule. OMamule okuti bakyeta Kebbulooni era kiri mu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kale eitakali eryabbairemu empuku, era eryabbaire erya Bakiiti, ni lisuukira kimo lya Ibbulaimu lyʼokuliikangamu bafu. ");
INSERT INTO gwr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Atyanu omu kiseera ekyo oIbbulaimu yabbaire akairiire ino, era oMusengwa ngʼamuwaire enkabi omu bintu byonabyona oIbbulaimu ebiyakolere. ");
INSERT INTO gwr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Lwabbaire lumo oIbbulaimu nʼakoba omuweereryawe akira obukulu omu kisitokye era onyampala wʼebintu byonabyona ati, “Okwate ansi oku kisambi kyange, ");
INSERT INTO gwr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ngʼolayira omumaiso ga Musengwa iye oKibbumba owʼeigulu nʼekyalo, oti tiwakwere omwana wange omukali kuzwa mu bantu banu aBakanani abetutyaimemu. ");
INSERT INTO gwr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Neye ntaka oyabe e waiswe omu kyalo e gibambyala, era omu bʼekika kyange, mwobba okwere omwana wange oIsaka omukali.” ");
INSERT INTO gwr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Awo omuweererya nʼakoba oIbbulaimu ati, “Olwo kaisi omukali obweyalibba taikiriirye okuzwa e waabwe okwiza na nze omu kyalo kinu? Olwo omutaanewo niiye ogunalitwala omu kyalo ekyo e giwazwire?” ");
INSERT INTO gwr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Iye oIbbulaimu nʼamukoba ati, “Togezyanga okutwala omwana wange eeyo. ");
INSERT INTO gwr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ekyo kityo olwʼokubba oMusengwa iye oKibbumba owʼeigulu, era oyo eyantoire omu kisito kya bbaabba, nʼomu kyalo kyʼe waiswe, era eyatumwire na nze nʼansuubiza ngʼalayira ati, ‘Naliwa eibyaireryo ekyalo kinu,’ oKibbumba oyo yalituma omalaikawe okukwekubbembera nʼakwezyesya okukwera omwana wange omukali kuzwa yeeyo. ");
INSERT INTO gwr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Neye omukali obweyalibba taikiriirye okwiza na iwe, iwe tiwalibbaaku musango olwʼokulayira okwo. Neye ekyotagezyanga okukola, niikyo okutwala eeyo omwana wange okutyamayo.” ");
INSERT INTO gwr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kale awo omuweererya wa Ibbulaimu nʼalayira ngʼakwaite ansi oku kisambi kya musengwawe, nʼamulayirira mwebyo oIbbulaimu ebiyamukobere. ");
INSERT INTO gwr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Awo omuweererya oyo nʼatoolaku engamira ikumi oku gya musengwawe, nʼayabiraku omu kibuga oNakoli omu yabbaire omutyami. Ekibuga ekyo kiri mambuka wʼeitwale lyʼe Mesopotamiya. Omuweererya nago yatwaire ebirabo byonabyona ebisa, ebiyatoire e wa musengwawe. ");
INSERT INTO gwr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Oweyatuukire eeyo, nʼaica engamira okwitakali aawo okumpi nʼeiruba e nza wʼekibuga. Oweyatukiire aawo obwire bwabbaire bwatira okwirugala, era kyabbaire kiseera abakali ekibaabirangamu okwiruba okusena amaizi. ");
INSERT INTO gwr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Awo omuweererya nʼasaba ati, “Oo Musengwa, iwe oKibbumba wa musengwa wange oIbbulaimu, nkusaba ompe enkabi olwatyanu omu nsonga endeetere eenu, era okolere omusengwa wange oIbbulaimu ebyʼekisa. ");
INSERT INTO gwr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Aale obone ngonu njemereire aanu okumpi nʼeiruba, abaala bʼomu kibuga egibaiza okusena amaizi. ");
INSERT INTO gwr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Oganye omwala onkooto ogunakoba nti, ‘Otiikule ensakayo, ompeeku amaizi nnyweku,’ era nʼakoba ati, ‘Onywe, era nʼengamiragyo njaba okugisenera amaizi ginywe,’ abbe niiye oyo ogwolondeire omuweereryawo oIsaka. Era ekyo niikyo ekimba ntegeerereku ngʼokoleire omusengwa wange ebyʼekisa.” ");
INSERT INTO gwr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Yabbaire akaali okumala okusaba, oLabbeeka nʼatuuka ngʼagingiire ensakaye okwibega. OLabbeeka oyo yabbaire mwala wa Bbeesweri omutaane wa Mirika omuka Nakoli, oNakoli omuganda wa Ibbulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","OLabbeeka yabbaire mwala musiipoono ino, nga nkooto era nga muguna ngʼomusaiza tamumanyangaku. Kale nʼaserengeta okwiruba, nʼasena amaizi nʼaizulya ensakaye. Awo oweyabbaire ngʼazwayo akanga, ");
INSERT INTO gwr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","omuweererya wa Ibbulaimu nʼairuka okwaba okumusangaana, kaisi nʼamukoba ati, “Nkwegairiire, ompeeku amaizi agʼomu nsakayo nnyweku.” ");
INSERT INTO gwr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Awo oLabbeeka nʼamukoba ati, “Mukulu, onyweku.” Amangu ago oLabbeeka ni yeetiikula ensaka, nʼagikwatirira, nʼamuwa amaizi nʼanywa. ");
INSERT INTO gwr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Awo oLabbeeka oweyamalire okumuwa amaizi okunywa, nʼamukoba ati, “Oleke nsenere nʼengamiragyo gyona ginywe agagimala.” ");
INSERT INTO gwr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kale awo nʼayanguwa okutwala amaizi agabbaire omu nsakaye, nʼagasuka omu kintu ebisolo omu binyweramu amaizi, era nʼairuka nʼakanga okwiruba, nʼasenera engamira gyonagyona egyʼomuweererya oyo amaizi. ");
INSERT INTO gwr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","OLabbeeka yakolanga ebyo ngʼomuweererya amwekalikica amaiso mu kasirinkiriri, okubona ooba ngʼoMusengwa amuwaire iye omuweererya enkabi omu lugendolwe. ");
INSERT INTO gwr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Engamira owegyamalire okunywa amaizi, omuweererya nʼatoolayo empeta yʼoku nindo eyʼezaabbu eyʼebbeeyi, nʼobukomo bwʼoku ngalo bubiri, obwʼezaabbu obwʼebbeeyi. ");
INSERT INTO gwr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Kaisi nʼamubuulya ati, “Nkwegairiire onkobereku, oli mwala waani? Era, omu kisito kya iteewo mwezya okubba mulimu enyumba nze nʼabanange omu twezya okugona?” ");
INSERT INTO gwr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Iye nʼamwiramu ati, “Ndi mwala wa Bbeesweri omutaane wa Nakoli nʼomukaliwe oMirika.” ");
INSERT INTO gwr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Era nʼamukoba ati, “Tuli nʼebisubi bingi ebyʼokwalira ebisolo okugonaku, nʼebyokulya byagyo, era tuli nʼekifo iwe nʼabainawo awemwezya okugona.” ");
INSERT INTO gwr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Awo omuweererya nago, nʼakoma amazwi era nʼakotamya omutwe nʼasinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Era nʼakoba ati, “Musengwa, iwe oKibbumba wa musengwa wange oIbbulaimu bakuwuuje, olwʼokubba oyabire ngʼomulaga ngʼobwoli owʼekisa era omwesigwa e gyali. Era zena Musengwa onnungamirye nʼontuca omu kisito kyʼabaganda ba musengwa wange.” ");
INSERT INTO gwr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Awo omwala nʼairuka nʼayaba e ika nʼakobera ababbaire omwamaaye byonabyona ebibbairewo. ");
INSERT INTO gwr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Atyanu oLabbeeka yabbaire nʼomwonyoko, eriinalye bati Laabbaani. Kale oLaabbaani nʼayalamuka okuwuluka nʼayaba okwiruba okusangaana omusaiza nago. ");
INSERT INTO gwr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","OLaabbaani oweyaboine omwonyoko nʼempeta yʼoku nindo nʼobukomo oku ngalo, era nʼawulira nʼokuwulira oLabbeeka ngʼalonsya ebintu omusaiza nago ebyamukobere, awo nʼayaba eeri omusaiza nago era nʼamwajirya ngʼali aawo nʼengamiragye okumpi nʼeiruba. ");
INSERT INTO gwr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Awo oLaabbaani nʼamukoba ati, “Oize twabe e ika iwe omuntu, oMusengwa ogwawaire enkabi! Kibba kitya iwe okusigala e nza eenu? Ntegekere enyumba nʼekifo engamira e gigyabba.” ");
INSERT INTO gwr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kale awo omusaiza nago nʼayaba, nʼaingira omu nyumba egibamutegekeire kaisi oLaabbaani nʼasindibula emigugu oku ngamira. Era ni baleeta ebisubi ebyokugyalirira okugonaku, nʼebindi ebyokulya. Awo ni baleetera omusaiza nago nʼabeyabbaire nabo amaizi okunaaba ebigere. ");
INSERT INTO gwr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kaisi ni bainula omusaiza nago nʼabeyabbaire nabo ekyokulya, neye nʼabakoba ati, “Tinaalye nga nkaali okwanjula ekindeetere.” Iye oLaabbaani nʼamukoba ati, “Aale otukobere.” ");
INSERT INTO gwr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Awo omusaiza nago nʼatoolera okubasonzolera ati, “Nze ndi muweererya wa Ibbulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","OMusengwa yawaire omusengwa wange enkabi mbitiriri, era nʼasuuka musuni. Amuwaire ebiraalo byʼente nʼebyʼembuli nʼebyʼentaama. Era amuwaire efeeza nʼezaabbu, nʼamuwa nʼabagalama abakali nʼabasaiza, nʼengamira, nʼempunda. ");
INSERT INTO gwr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Era nʼoSaala omuka musengwa wange, nʼabyala naye omwana mwisuka, omu myanka gya Saala egyʼobukaire. Era omusengwa wange nʼawa omwana oyo ebintubye byonabyona. ");
INSERT INTO gwr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Era omusengwa wange nʼankolesya ekirayiro ngʼankoba ati, ‘Tokweranga omwana wange omukali kuzwa mu bantu banu aBakanani abetutyaimemu. ");
INSERT INTO gwr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Neye oyabanga mu kisito kya bbaabba, era mu bʼekika kyange, mwokweranga omwana wange omukali.’ ");
INSERT INTO gwr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ni mbuulya omusengwa wange nti, ‘Olwo kaisi omukali oweyalibba taikiriirye okuzwa e waabwe okwiza na nze?’ ");
INSERT INTO gwr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Iye nʼanjiramu ati, ‘OMusengwa bulijo ogunjabire nga ngondera, yalituma omalaikawe okukwekubbembera nʼakuwa enkabi omu lugendolwo, era nʼakwezyesya okukwera omwana wange omukali kuzwa mu bʼekika kyange era bʼomu kisito kya bbaabba. ");
INSERT INTO gwr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Atyanu singa walyaba omu bʼekika kyange, kaisi ni bataikirirya omwala okwiza na iwe, awo iwe walibba obulaku omusango olwʼokulayira okwo.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Awo omusaiza nago ni yeeyongera ati, “Olwatyanu ntuukire okwiruba, ni nsaba nti, ‘Oo Musengwa, iwe oKibbumba wa musengwa wange oIbbulaimu, nkwegairira owoobba nga wampa enkabi omu lugendo lwange, ");
INSERT INTO gwr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","obone, atyanu njemereire aanu okwiruba. Oganye omwala omuguna eyaiza okusena amaizi, kaisi ni mmukoba nti, “Nkwegairiire, ompeeku amaizi agʼomu nsakayo nnyweku,” ");
INSERT INTO gwr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","era nʼakoba ati, “Onywe, era nʼengamiragyo njaba okugisenera amaizi ginywe,” oganye abbe niiye oyo, iwe oMusengwa ogwʼolondeire omutaane wʼomusengwa wange.’ ");
INSERT INTO gwr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Mbaire nkaali nʼokumala okusaba oKibbumba omu kasirinkiriri, oLabbeeka nʼaiza nʼensaka okwibega, nʼaserengeta okwiruba nʼasena amaizi. Awo ni mmukoba nti, ‘Nkwegairiire, ompeeku amaizi nnyweku.’ ");
INSERT INTO gwr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Amangu ago yeetiikwire ensakaye okwibega, era nʼakoba ati, ‘Onywe, era nʼengamiragyo gyona njaba okugisenera ginywe.’ Awo ni nnywa, era nʼengamira gyona agiseneire ni ginywa. ");
INSERT INTO gwr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Awo kaisi ni mmubuulya nti, ‘Oli mwala waani?’ Nʼairamu ati, ‘Ndi mwala wa Bbeesweri omutaane wa Nakoli nʼomukaliwe oMirika.’ Kale awo ni mmuteeka empeta oku nindo, nʼobukomo oku ngalogye. ");
INSERT INTO gwr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Awo kaisi ni nkoma amazwi era ni nkotamya omutwe ni nsinza oMusengwa. Era ni mpuuja oMusengwa iye oKibbumba wa musengwa wange oIbbulaimu, olwʼokubba annungamirye omu nzira entuuce, ni nsunira omwana wa musengwa wange omukali kuzwa mu baana ba muganda wa musengwa wange. ");
INSERT INTO gwr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Aale atyanu munkobere, abba nga mwakolera omusengwa wange ebyʼekisa era ebyʼobwenkanya, era obwemubba nga timwamukolere kyona munkobere, awo kaisi nsalewo ekinakola.” ");
INSERT INTO gwr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Awo oLaabbaani nʼoBbeesweri ni bairamu bati, “Ekyo kizwire wa Musengwa, iswe tubula kitwezya okusalawo. ");
INSERT INTO gwr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","OLabbeeka ngoyo, oyabe naye omutwale abbe mukali wa mwana wa musengwawo, ngʼoMusengwa owakulagire.” ");
INSERT INTO gwr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Awo omuweererya wa Ibbulaimu oweyawuliire ebibono ebibamwiriremu, nʼakoma amazwi era nʼakotamya omutwe nʼasinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kaisi awo nʼatoolayo amajolobero agʼezaabbu, nʼagʼefeeza, nʼebizwalo, nʼabiwa oLabbeeka. Era nʼawa nʼomwonyoko oLaabbaani nʼomaaye ebirabo ebyebbeeyi. ");
INSERT INTO gwr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Awo omuweererya wa Ibbulaimu, nʼabasaiza abeyabbaire nabo, ni balya ebyokulya ni banywa nʼebyokunywa, era ni bagonawo. Kale owebalamukire eizo amakeezi, omuweererya nʼakoba ati, “Munseebule nkange egiri omusengwa wange.” ");
INSERT INTO gwr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Neye omwonyoko wa Labbeeka nʼomaaye ni bakoba bati, “Atyanu oleke omwala agire ngʼabbaaku na iswe enaku ooti ikumi, awo kaisi omutwale.” ");
INSERT INTO gwr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Awo omuweererya nago nʼakoba ati, “Mbegairiire mututeere titwasigala eenu, olwʼokubba oMusengwa ampaire enkabi omu lugendo lwange. Kale munseebule nkange egiri omusengwa wange.” ");
INSERT INTO gwr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Awo oLaabbaani nʼomaaye ni bakoba bati, “Aale oleke twete omwala tumubuulye ekyaseega.” ");
INSERT INTO gwr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kale ni beeta oLabbeeka, kaisi ni bamubuulya bati, “Waaba nʼomusaiza oyo?” Iye nʼairamu ati, “Naaba naye.” ");
INSERT INTO gwr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Awo ni baseebula oLabbeeka, era ni bamuwa nʼomukali eyamulerere ayabe naye. Kale ni baaba nʼomuweererya wa oIbbulaimu, era nʼabasaiza abʼeyabbaire aizire nabo. ");
INSERT INTO gwr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Atyanu babbaire bakaali okubaseebula, ni basabira oLabbeeka enkabi, nga bakoba bati, “OKibbumba akuganye mwala waiswe obyalagane, enkali nʼensaiza, era eibyaireryo liwangulenge ebibuga byʼabalabe baalyo.” ");
INSERT INTO gwr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Awo oLabbeeka nʼabagalamabe abakali ni basetuka ni baniina oku ngamira, ni baaba nʼomuweererya wa Ibbulaimu. Atyo omuweererya oyo nʼasimbuka nʼoLabbeeka, ni baaba. ");
INSERT INTO gwr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Atyanu omu kiseera ekyo oIsaka yabbaire azwire omu kyalo ekirimu eiruba eribeeta bati, “Eiruba lya Nanzwa wʼoBwomi iye aMbona,” ngʼabba mu Negevu. ");
INSERT INTO gwr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lwabbaire lumo eigulo oIsaka yabbaire atambulatambula omu musiri ngʼafumintiriza, nʼasiirya amaiso nʼalengera engamira nga gyaba e gyali. ");
INSERT INTO gwr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Atyanu oLabbeeka yena nʼasiirya amaiso, nʼalengera oIsaka, awo nʼazwa oku ngamira, ");
INSERT INTO gwr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kaisi nʼabuulya omuweererya wa Ibbulaimu ati, “Omusaiza odi aali kutambula omu musiri ngʼaiza okutusangaana, niiye onaani?” Iye omuweererya nʼamwiramu ati, “Niiye omusengwa wange oIsaka.” Awo oLabbeeka nʼatoola ekitambaalakye, ni yeebiika omumaiso. ");
INSERT INTO gwr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kale awo omuweererya nʼakobera oIsaka byonabyona ebiyabbaire akolere omu lugendolwe. ");
INSERT INTO gwr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Awo oIsaka nʼatwala oLabbeeka omu weema omaaye oSaala omuyabbanga, era nʼafumbirwa oLabbeeka. Era oIsaka nʼataka oLabbeeka, kale ekyo ni kigumya oIsaka olwa maaye oSaala eyamufiireku. ");
INSERT INTO gwr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Awo oSaala oweyafiire, oIbbulaimu nʼafumbirwa omukali ogondi eriinalye bati, Ketula. ");
INSERT INTO gwr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Era oKetula nʼabyala naye oZimulaani, nʼoYokosaani, nʼoMedaani, nʼoMidiyaani, nʼoIsubbaaki nʼoSuuwa. ");
INSERT INTO gwr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","OYokosaani nʼabyala oSeebba nʼoDedani. Eibyaire lya Dedani lyabbaire niiryo linu: ABasulimu nʼaBaletusimu, nʼaBalewumimu. ");
INSERT INTO gwr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Abaana ba Midiyaani babbaire niibo banu: Efa, nʼEferi, nʼoKanoki, nʼAbbida, nʼEruda. Abo bonabona babbaire niibo abʼeibyaire lya Ketula. ");
INSERT INTO gwr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Awo Ibbulaimu nʼakwatisya oIsaka ebintu byonabyona ebiyabbaire nabyo. ");
INSERT INTO gwr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Neye oIbbulaimu oweyabbaire ngʼakaali mwomi, nʼakwata ebirabo nʼabiwa abaanabe abeyabyaire nʼabakalibe abandi, kaisi nʼabasindika omu kyalo ekyʼe buzwaisana, bayezye okubba yala nʼomwanawe oIsaka. ");
INSERT INTO gwr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","OIbbulaimu yawangaire emyanka 175, ");
INSERT INTO gwr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","nʼafa nga musaiza mukaire ino, era atyo nʼabba yeeyimbirye oku bazeizabe. ");
INSERT INTO gwr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Awo abataanebe, oIsaka nʼoIsimairi ni bamuteeka omu mpuku eyʼomwitakali lyʼe Makupera ekiri e buzwaisana wʼe Mamule, omwitakali eryabbaire eryʼEfulooni omutaane wa Zokali oMukiiti. ");
INSERT INTO gwr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Eryo niiryo eitakali oIbbulaimu eriyagulire oku Bakiiti. Era omu mpuku eyabbaire omwitakali eryo niimwo omu bateekere amagumba ga Ibbulaimu, era niimwo omu yabbaire ateekere amagumba gʼomukaliwe oSaala. ");
INSERT INTO gwr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","OIbbulaimu oweyamalire okufa, oKibbumba nʼawa oIsaka enkabi, oIsaka nʼayaba nʼabba mutyami omu kifo ekirimu eiruba eribeeta Eiruba lya Nanzwa wʼoBwomi iye aMbona. ");
INSERT INTO gwr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Atyanu linu niiryo eibyaire lya Isimairi, omutaane wa oIbbulaimu, oguyabyaire nʼAgali oMumisiri omugalama wa Saala. ");
INSERT INTO gwr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ganu niigo amaliina gʼabaana ba Isimairi ngʼowebairanganaku: ONebbayoosi niiye omutaane wa Isimairi omukulu, ni kwiraku oKedali, ni kwiraku Adubbeeri, ni kwiraku oMibbusaamu, ");
INSERT INTO gwr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ni kwiraku oMisima, ni kwiraku oDuma, ni kwiraku oMasa, ");
INSERT INTO gwr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ni kwiraku oKadadi, ni kwiraku oTema, ni kwiraku oYetuli, ni kwiraku oNafisi, ni kwiraku oKedema. ");
INSERT INTO gwr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Abo niibo abaana ba Isimairi, era basuukire bafugi bʼebika eikumi na bibiri ebibawaire amaliina ago, era ni bagawa ebyalo omu babbaire batyami nga mu bateekere enkambi gyabwe. ");
INSERT INTO gwr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Era oIsimairi yafiire nga wʼemyanka 137, era atyo nʼabba yeeyimbirye oku bazeizabe. ");
INSERT INTO gwr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Eibyaire lya Isimairi lyabbaire lityami okuzwera nakimo omwitwale lyʼe Kavira okutuuka omwitwale lyʼe Suuli. Ekitundu ekyo kiri buzwaisana wʼe Misiri ngʼoyaba Asiiriya. Era abantu abo babbaire bʼobulabe eeri abaganda baabwe bonabona. ");
INSERT INTO gwr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Linu niiryo eibyaire lya Isaka omutaane wa Ibbulaimu: OIbbulaimu yabbaire iteeye wa Isaka. ");
INSERT INTO gwr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Era oIsaka yabbaire wʼemyanka 40 oweyafumbiriirwe oLabbeeka omwala wa Bbeesweri era omwonyoko wa Laabbaani. OBbeesweri yabbaire wʼomwigwanga lyʼaBalameeni owʼe Padanalaamu. ");
INSERT INTO gwr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Atyanu olwʼokubba oLabbeeka yabbaire tabyalangaku, oIsaka ni yeegairira oMusengwa oku lwa mukaliwe oyo. Era oMusengwa nʼairamu okusabakwe, awo oLabbeeka nʼasuna ekida. ");
INSERT INTO gwr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ekida kyabbaire kyʼabaana balongo, neye ni babba nʼokayaani omu kidaakye. OLabbeeka nʼakoba ati, “Lwaki ekintu ekiti kiri kumbangaku?” Kale awo nʼayaba ni yeebuulyaku oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","OMusengwa nʼamukoba ati, “Abaana ababiri abali omu kidaakyo balibba bazeiza bʼamawanga mabiri. Era abantu ababiri abali omu kidaakyo balyawukana. Omuntu omoiza yalibba wʼamaani okukiraku ogondi, era omukulu yaliweereryanga omutomuto.” ");
INSERT INTO gwr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Awo enakugye egyʼokubyala ni gituuka, era nʼabyala balongo nga baisuka. ");
INSERT INTO gwr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Era omubere ni bamubyala nga mutukuliki, era ngʼolususulwe luliku ebyoya ooti bbulangiti owʼebyoya. Kale omwana oyo ni bamuwa eriina bati, Esawu. ");
INSERT INTO gwr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Awo nʼowokubiri yena ni bamubyala era nʼawuluka ngʼengaloye ekwaite ekitindiro kyʼEsawu, kale ni bamuwa eriina bati, Yaakobbo. Atyanu oLabbeeka yabyaire abalongo abo ngʼoIsaka wʼemyanka 60. ");
INSERT INTO gwr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Awo abaisuka ni bakula, era Esawu nʼasuuka muyiigi omukugu, omusaiza anyumirwa ebyʼomu kigona. Iye oYaakobbo nʼabba musaiza muwombeeki, era nʼabbanga ika mu weema. ");
INSERT INTO gwr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kale oIsaka nʼataka ino Esawu, olwʼokubba yaalyanga oku bisolo Esawu ebiyayiiganga. Neye oLabbeeka nʼataka ino Yaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lwabbaire lumo oYaakobbo nʼasumba ekyokulya. Atyanu Esawu nʼazwa omu kigona nʼakanga e ika, ngʼadembere era ngʼenzala emuli bundi. ");
INSERT INTO gwr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kale Esawu nʼakoba oYaakobbo ati, “Enzala endi bundi! Ompeeku ekyokulya ekyo ekitukuliikiriri ekyoli kusumba.” Era kagira Esawu bamweta Edomu. ");
INSERT INTO gwr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","OYaakobbo nʼamwiramu ati, “Osooke onsuubize nga wampaamu omugabogwo ogwoli nʼokusuna ngʼomwana omubere.” ");
INSERT INTO gwr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Awo Esawu nʼamukoba ati, “Aale obone, nze enzala enjita, atyanu ebyomugabo ogwange ngʼomwana omubere byalingasa niki?” ");
INSERT INTO gwr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","OYaakobbo era nʼakoba ati, “Osooke ondayirire nga wampaamu omugabogwo.” Kale Esawu nʼamulayirira, ngʼasuubiza okuwa oYaakobbo omugabogwe ogwali nʼokusuna ngʼomwana omubere. ");
INSERT INTO gwr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Awo oYaakobbo nʼawaaku Esawu omugaati nʼebyokulya ebisumbe ebyʼenkolimbo. Era Esawu nʼalya ebyokulya, era nʼanywa, nʼasetuka nʼayaba. Kale Esawu atyo niiye obweyalagajaliire omugabogwe oguyabbaire nʼokusuna ngʼomwana omubere. ");
INSERT INTO gwr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Atyanu enzala nʼegwawo omu kyalo oIsaka e giyabbaire atyama, neye nga tiniiyo eedi eyasookere okugwawo omu biseera bya Ibbulaimu. Kale oIsaka nʼayaba e Gerali eeri Abbimereki okabaka wʼaBafirisuuti. ");
INSERT INTO gwr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","OMusengwa nʼabonekera oIsaka, era nʼamukoba ati, “Tiwaserengeta okwaba e Misiri, otyame mu kyalo ekinakulaga. ");
INSERT INTO gwr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Otyameku aanu omu kyalo kinu, era naabbanga aamo na iwe, era nakuwanga enkabi. Nakuwa iwe nʼeibyaireryo, eitakali linu lyonalyona. Era natuukirirya ekisuubizo ekinasuubizire oiteewo oIbbulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Nalikuwa eibyaire linene ni libbaamu abantu bangi ooti nkota egiri angulu egitabalika era nalibawa eitakali linu lyonalyona. Era okubitira omwibyaireryo, amawanga gonagona oku kyalo mwegalisunira enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ekyo kityo olwʼokubba oIbbulaimu yangonderanga, era yakwatanga amateeka gange gonagona nʼebiragiro byange.” ");
INSERT INTO gwr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kale oIsaka nʼatyama e Gerali. ");
INSERT INTO gwr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Awo abasaiza baayo owebamubwirye ebikwata oku mukaliwe, yakobere ati mwonyokowe. Yatiire okutumula ati mukaliwe, ngʼaseega ati abasaiza baayo bayinza okumwita ni batwala oLabbeeka omukaliwe, olwʼokubba yabbaire mukali musiipoono. ");
INSERT INTO gwr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Neye oluzwanyuma ngʼoIsaka atyaime eeyo okumala eibbanga, lumo Abbimereki okabaka wʼaBafirisuuti nʼalengerera omu dinisa ngʼoIsaka agwa oLabbeeka omukaliwe omu kifubba. ");
INSERT INTO gwr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kale Abbimereki nʼalagira ni beeta oIsaka, kaisi nʼamukoba ati, “Mazima oLabbeeka mukaliwo. Lwaki wakobere oti mwonyokowo?” OIsaka nʼamwiramu ati, “Olwʼokubba naseegere nti bayinza okunjita era ni bamutwala.” ");
INSERT INTO gwr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Awo Abbimereki nʼakoba ati, “Niki kinu ekyotukolere? Singa omoiza oku basaiza bange yeegaitire nʼomukaliwo, obbaire otuleetereku omusango.” ");
INSERT INTO gwr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kale Abbimereki nʼalabula abantu bonabona abʼomu Gerali ati, “Nabuli eyabitya bundi omusaiza oyo, ooba omukaliwe, mazima nʼamwita.” ");
INSERT INTO gwr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Awo oIsaka nʼasiga ensigo omu kyalo ekyo, era nʼakungula emirundi 100 mwebyo ebiyasigire omu mwanka ogwo, olwʼokubba oMusengwa yamuwaire enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Era oIsaka ni yeeyongera okugaigawala, paka oweyasuukire musuni ino. ");
INSERT INTO gwr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Era olwʼokubba yabbaire nʼebiraalo bingi ebyʼente nʼebyʼentaama nʼebyʼembuli, era nʼabaweererya bangi, aBafirisuuti ni bamukwatira engongi. ");
INSERT INTO gwr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kale aBafirisuuti ni baliikawo amaluba gonagona, abaweererya ba iteeye oIbbulaimu agebakwire ngʼoIbbulaimu akaali mwomi. ");
INSERT INTO gwr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Awo Abbimereki nʼakoba oIsaka ati, “Ozwe omu kyalo kyaiswe, olwʼokubba osuukire wʼamaani ino okutukiraku.” ");
INSERT INTO gwr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kale oIsaka nʼazwayo, nʼayaba nʼakomeka eweemagye omu kiinamo kyʼe Gerali, era nʼatyama eeyo. ");
INSERT INTO gwr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","OIsaka nʼaigulya amaluba abaweererya ba iteeye oIbbulaimu agebabbaire bakwire, ngʼoIbbulaimu akaali mwomi, era aBafirisuuti agebabbaire baliikirewo ngʼoIbbulaimu amalire okufa. Era oIsaka nʼageeta maliina gananyere gadi, oiteeye ageyagawaire. ");
INSERT INTO gwr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Oluzwanyuma lwʼekyo abaweererya ba Isaka ni bakuula eiruba omu kiinamo kyʼe Gerali, era ni bavumbulayo ensulo egyʼamaizi amasa. ");
INSERT INTO gwr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Neye abaliisya abʼe Gerali ni bakayaana nʼabaliisya ba Isaka, ngʼabaliisya bʼe Gerali bakoba bati, “Eiruba linu lyaiswe.” Kale oIsaka nʼayeta eiruba eryo eriina ati, Eseki. Yalyetere atyo olwʼokubba abaliisya abʼe Gerali bakayaanire nʼabaliisyabe. ");
INSERT INTO gwr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Awo abaweererya ba Isaka ni bakuula eiruba erindi, era lyona ni balikayaanira. Kale oIsaka nʼalyeta eriina ati, Situna. ");
INSERT INTO gwr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Nʼasenguka nʼayaba omu kifo ekindi, era nʼakuula eiruba erindi. Eryo iryo ni batalikayaanira, era nʼalyeta eriina ati, Lekobbosi era nʼakoba ati, “Atyanu oMusengwa atuwaire eitakali erigalami, era aanu twaba okukulaakulana.” ");
INSERT INTO gwr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","OIsaka nʼazwayo nʼayaba e Bberusebba. ");
INSERT INTO gwr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","OMusengwa nʼamubonekera ekiire ekyo, nʼamukoba ati, “Ninze oKibbumba wa iteewo oIbbulaimu. Tiwaatya, olwʼokubba nze ndi aamo na iwe, nakuwanga enkabi, era nalikuwa eibyaire linene, olwʼendagaano eginakolere nʼomuweererya wange oIbbulaimu.” ");
INSERT INTO gwr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kale oIsaka nʼayombeka eeyo ekyoto, era nʼasinza oMusengwa. Nʼakomeka eeyo eweemaye, era abaweereryabe ni bakuulayo eiruba. ");
INSERT INTO gwr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Lwabbaire lumo okabaka Abbimereki nʼazwa omu Gerali, ngʼali aamo nʼAkuzaasi omukaagwawe oguyeewuulyaku, nʼoFikoli omuduumiri wʼamaje gʼAbbimereki, ni baaba eeri oIsaka. ");
INSERT INTO gwr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","OIsaka nʼababuulya ati, “Lwaki mwizire egyendi ate nga mwancaawire era ni mumbinga omu kyalo kyanywe?” ");
INSERT INTO gwr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ni bairamu bati, “Atyanu tumaite kusani ngʼoMusengwa ali na iwe, era tuseega tuti tukole endagaano akatiwo na iswe, era tulayiranganire tuti, ");
INSERT INTO gwr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","iwe tiwatukoleku akabbikabbi, nga swena obwenandi tukukolaku akabbikabbi. Twakubityanga kusani era ni tukuseebula mwidembe. Era atyanu iwe oMusengwa akuwaire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Awo oIsaka nʼabasumbira embaga, ni balya era ni banywa. ");
INSERT INTO gwr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kale eizo amakeezikeezi, oIsaka nʼokabaka Abbimereki ni bakola ekirayiro. Awo oIsaka nʼabaseebula, era ni beeyabira mwidembe. ");
INSERT INTO gwr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Oku lunaku olunanyere olwo, abaweererya ba Isaka ni baaba ni bamukobera ebikwata okwiruba eribakwire, ni bamukoba bati, “Tutuukire oku maizi.” ");
INSERT INTO gwr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kale oIsaka nʼaliwa eriina bati, Sibba, era eiruba eryo egiriri ekibuga ekiriwo ni bakyeta Bberusebba paka lwatyanu. ");
INSERT INTO gwr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esawu oweyabbaire nga wʼemyanka 40, nʼafumbirwa oYudisi omwala wa Bbeeri oMukiiti. Era nʼafumbirwa nʼoBbasemasi omwala wʼEroni yena oMukiiti. ");
INSERT INTO gwr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Neye ni kinakuwalya oIsaka nʼoLabbeeka ababyaire bʼEsawu. ");
INSERT INTO gwr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Atyanu oIsaka oweyabbaire ngʼakairiire, era ngʼafiiremu amaiso, nʼatuma ni bamwetera Esawu omwanawe omukulu, kaisi nʼamweta ati, “Mwana wange!” Esawu nʼayetuka ati, “Waitu.” ");
INSERT INTO gwr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Awo oIsaka nʼamukoba ati, “Owulisisye, atyanu nkairiire, era natira okufa. ");
INSERT INTO gwr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kale atyanu, okwate ebintubyo ebyokolesya omu kuyiiga, oyabe omu kigona onjiigire okisolo. ");
INSERT INTO gwr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Awo kaisi onsumbire enyama eyo eyakaboobo ngʼowentaka, era ogindeetere ndye, kaisi nkusabire enkabi nga nkaali okufa.” ");
INSERT INTO gwr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Atyanu oLabbeeka yabbaire awulisisya ngʼoIsaka atumula nʼomutaane Esawu. Kale Esawu oweyaabire omu kigona okuyiiga okisolo, ");
INSERT INTO gwr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","oLabbeeka nʼakoba oYaakobbo omwanawe ati, “Owulisisye! Mpuliire oiteewo ngʼakoba omugandawo Esawu ati, ");
INSERT INTO gwr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Oyabe onjiigire okisolo era omuleete, onsumbire enyama eyʼakaboobo ngʼowentaka, ngirye kaisi nkusabire enkabi omumaiso ga Musengwa nga nkaali okufa.’ ");
INSERT INTO gwr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kale atyanu mwana wange, ompulisisye nakusani, era okole ebinkukoba. ");
INSERT INTO gwr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Oyabe omu kiraalo ekyʼembuli, ondeetere embuli entonto ensava ibiri, kaisi, nsumbire oiteewo enyama eyʼakaboobo ngʼowaataka. ");
INSERT INTO gwr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Era ogimutwalire alye, kaisi akusabire enkabi ngʼakaali okufa.” ");
INSERT INTO gwr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Neye oYaakobbo nʼakoba omaaye ati, “Omaite ngʼomuganda wange Esawu musaiza ali nʼebyoya oku mubirigwe gwonagwona, neye omubiri ogwange igwo gubulaku ebyoya. ");
INSERT INTO gwr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Amo obbaabba nʼankwataku, nʼazuula ati mmubbeya, omu ngeri eyo ni neeretaku ekiraami, omukifo kyʼokusuna enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Omaaye nʼamwiramu ati, “Mwana wange, oleke ekiraami ekyo kibbe ku ninze. Neye okole ekinkukoba, oyabe ondeetere embuli.” ");
INSERT INTO gwr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kale nʼayaba omu kiraalo nʼaleetera omaaye embuli ibiri ni bagisala. Kaisi omaaye nʼasumba enyama eyʼakaboobo enyerenyeere oiteeye wa Yaakobbo egyataka. ");
INSERT INTO gwr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Awo oLabbeeka nʼatoolayo ebizwalo ebyʼEsawu omwanawe omukulu, ebikira obusa ebiyabbaire abisire omu nyumba, nʼabiwa oYaakobbo omwanawe omutomuto nʼabizwala. ");
INSERT INTO gwr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Era nʼasiba amadiba gʼembuli entonto egyo oku ngalo gya Yaakobbo, nʼokwikoti okwabbaire okubula ebyoya. ");
INSERT INTO gwr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Era nʼakwatisya omwanawe oYaakobbo omugaati nʼenyama eyʼakaboobo egiyabbaire asumbire. ");
INSERT INTO gwr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Awo oYaakobbo nʼayaba egiri oiteeye, nʼayeta ati, “Bbaabba!” OIsaka nʼayetuka ati, “Waitu mwana wange. Niiwe onaani?” ");
INSERT INTO gwr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","OYaakobbo nʼakoba oiteeye ati, “Ninze Esawu omwanawo omubere. Nkolere ekyonkobere okukola. Osetuke otyame olyeku enyama eginkusumbiire, kaisi onsabire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Neye oIsaka nʼabuulya omutaane ati, “Mwana wange osunire otya okisolo amangu ago?” OYaakobbo nʼamwiramu ati, “OMusengwa iye oKibbumbawo ogwʼoweererya niiye ambeereire okumusuna.” ");
INSERT INTO gwr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Awo oIsaka nʼakoba oYaakobbo ati, “Oigerere aanu nkukwateku, mwana wange, kaisi mmanye ooba nga dala niiwe omwana wange Esawu ooba bbe.” ");
INSERT INTO gwr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kale oYaakobbo nʼaigerera e giri oiteeye oIsaka. OIsaka nʼamukwataku, nʼakoba ati, “Eigono livuga ooti lya Yaakobbo, neye engalo giri ngʼegyʼEsawu!” ");
INSERT INTO gwr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","OIsaka nʼatamutegeera ati dala niiye oYaakobbo, olwʼokubba engalogye gyabbaireku ebyoya ngʼegyʼomugandawe Esawu. Kale nʼasalawo okumusabira enkabi, ");
INSERT INTO gwr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","neye nʼamubuulya tete ati, “Dala niiwe omwana wange Esawu?” OYaakobbo nʼamwiramu ati, “Ninze Esawu.” ");
INSERT INTO gwr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Awo oIsaka nʼakoba ati, “Mwana wange oigererye enyama egyosumbire ndye kaisi nkusabire enkabi.” Kale oYaakobbo nʼamwigerererya, era nʼalya. Era nʼamuwa nʼenviinyo nʼanywa. ");
INSERT INTO gwr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Awo oiteeye nʼamukoba ati, “Mwana wange oigerere ongweku omu kifubba!” ");
INSERT INTO gwr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kale nʼaigerera, nʼamugwa omu kifubba, oIsaka nʼafunyirya olusu oluli omu bizwalo nʼategeera ati byʼEsawu. Kale nʼamusabira enkabi, nʼakoba ati, “Olusu lwʼomwana wange luli ngʼokufunya okusa okwʼomusiri oMusengwa ogwawaire enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Nsaba nti oKibbumba akugabirirenge oikendi mungi okuzwa omwigulu, era oKibbumba ajimucenge emisirigyo. Era ebiwakungulanga bibbenge bingi nʼenviinyo gibbenge nyingi. ");
INSERT INTO gwr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nsaba oKibbumba nti abantu abʼamawanga bakuweeryenge, era bakugonderenge. Ofugenge abantu bʼekikaakyo era nʼabʼolulyolwo bakugonderenge. Nsaba oKibbumba alaamenge nabuli eyakulaamanga, era awenge enkabi abo abakusabiranga enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Awo oIsaka oweyabbaire nga yankumala okusabira oYaakobbo enkabi, era ngʼoYaakobbo yankuzwa e giri oIsaka oiteeye, Esawu omuganda wa Yaakobbo nʼaira ngʼazwa okuyiiga. ");
INSERT INTO gwr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Era yena nʼasumba enyama eyʼakaboobo, nʼagitwalira oiteeye. Kaisi nʼakoba oiteeye ati, “Bbaabba, osetuke otyame olyeku enyama eginkusumbiire, kaisi onsabire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","OIsaka nʼamubuulya ati, “Niiwe onaani?” Nʼairamu ati, “Ninze Esawu omwanawo omubere.” ");
INSERT INTO gwr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Awo oIsaka nʼatukuta ino, era nʼabuulya ati, “Odi abbaire naani ayiigire nʼandeetera enyama ya kisolo ni ndya, ngʼokaali okwiza, ni mmusabira enkabi? Dala mmusabiire enkabi, era yasigala ngʼaali nagyo.” ");
INSERT INTO gwr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esawu oweyawuliire oiteeye ebyakoba, nʼakuukulya ino, nʼakoba oiteeye ati, “Bbaabba, nkwegairiire, zena onsabire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Neye oIsaka nʼakoba ati, “Omugandawo aizire nʼambeya, era ni mmusabira niiye enkabi egimbaire nakusabira.” ");
INSERT INTO gwr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Awo Esawu nʼakoba ati, “Tikyewuunyisya kiti eriinalye niiye oYaakobbo, olwʼokubba gunu mulundi gwokubiri ngʼandyakula. Yantoireku ebyomugabo gwange ngʼomwana omubere, era atyanu ngonu antoireku nʼenkabi gyange!” Awo nʼabuulya oIteeye ati, “Mpaawo kintu ekindi ekyosigairyekuuwo ekyoyezya okunsabira?” ");
INSERT INTO gwr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","OIsaka nʼairamu ati, “Owulisisye, mmusuucirye okubba nga niiye akufuga, era abʼekikaakye bonabona bali nʼokuweereryanga niiye. Era mmusabiire nti ebiyakungulanga byabbanga bingi, nʼenviinyo gyabbanga nyingi. Kale niki ekinakukolera iwe mwana wange?” ");
INSERT INTO gwr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Era Esawu ni yeeyongera okukungirira oiteeye ati, “Bbaabba, obba nʼenkabi egyʼomulundi gumo gwonkani? Ii bbaabba, onsabireku zena enkabi,” Era Esawu nʼakuukulya. ");
INSERT INTO gwr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Awo oiteeye nʼamukoba ati, “Aale owulire! E giwatyamanga emisirigyo tigyabbengemu obujimu, era oikendi okuzwa omwigulu tiyatoonyengeyo. ");
INSERT INTO gwr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ebyokwebbeesyawo wabisunanga mu kulwana ntalo, era waabbanga muweererya wa mugandawo. Neye obwewalisalawo okumugyemera, yalibba takaali ayezya okukufuga.” ");
INSERT INTO gwr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Awo Esawu nʼacaawa omugandawe oYaakobbo, olwʼenkabi oiteeye egiyasabiire oYaakobbo. Era Esawu nʼakoba omu mwoyogwe ati, “Obbaabba ngonu yatira okufa era owetwamala olumbe kaisi awo njite omuganda wange oYaakobbo.” ");
INSERT INTO gwr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Neye owebakobeire oLabbeeka ebyo Esawu omwanawe omubere ebyateesa okukola, nʼatuma omuntu okweta oYaakobbo omwanawe omutomuto, nʼamukoba ati, “Owulisisye, omugandawo ateesa okukwita okwemalaku ekiruyi. ");
INSERT INTO gwr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kale atyanu, mwana wange, okole ekinkukoba. Oirukire mangu e wa koizawo oLaabbaani omu kibuga kyʼe Kalani, ");
INSERT INTO gwr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","era obbe naye okumala akaseera, paka omugandawo oweyaliikaikana obusungu, ");
INSERT INTO gwr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ni yeerabira ekiwamukolere. Olwo kaisi ni ntuma omuntu okukukoba nʼoira e ika. Tintaka okubafiirwa mwembi oku lunaku olumo.” ");
INSERT INTO gwr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Awo oLabbeeka nʼakoba oIsaka ati, “Obwomi bwange bwazuzwire abakali bʼEsawu aBakiiti! Era oYaakobbo oweyalifumbirwa omukali oMukiiti, wakiri nʼalifa.” ");
INSERT INTO gwr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Awo oIsaka nʼatuma ni beeta oYaakobbo kaisi oIsaka nʼamusabira enkabi, era nʼamulaabbira ati, “Tofumbirwanga omukali oMukanani. ");
INSERT INTO gwr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Wazira osetukiremu oyabe e Padanalaamu, omu kisito kya zeizaawo oBbeesweri abyala omaawo, era eeyo osuneyo omoiza oku baala ba koizawo oLaabbaani omufumbirwe. ");
INSERT INTO gwr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nsaba nti oKibbumba oWabwezye Bwonabwona akuwe enkabi, era akuwe abaana nʼabaizukulu bangi, era basuuke igwanga erinene eryʼebika ebingi. ");
INSERT INTO gwr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Era nsaba nti akuwe iwe nʼeibyaireryo enkabi egiyawaire oIbbulaimu. Era osikire eitakali linu eryobbaire otyamamu ngʼomugeni, oKibbumba eriyawaire oIbbulaimu.” ");
INSERT INTO gwr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Awo oIsaka nʼasindika oYaakobbo e Padanalaamu e wa koizawe oLaabbaani omutaane wa Bbeesweri oMwalameeni. ");
INSERT INTO gwr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Atyanu Esawu nʼategeera ati oIsaka asabiire oYaakobbo enkabi, era ati amusindikire e Padanalaamu okusunayo omukali. Era nʼategeera ati oIsaka oweyasabiire oYaakobbo enkabi, yamulaabbiire okutafumbirwa omukali oMukanani. ");
INSERT INTO gwr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Era Esawu nʼategeera ati oYaakobbo yagondeire oiteeye nʼomaaye nʼayaba e Padanalaamu. ");
INSERT INTO gwr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Atyanu awo nʼategeera ati oiteeye tasiima abakali aBakanani. ");
INSERT INTO gwr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kale Esawu nʼayaba e wa Isimairi omutaane wa Ibbulaimu, nʼasunayo omukali ogondi okwongera oku bakali abandi abeyabbaire nabo. Omukali oyo yabbaire mwala wa Isimairi nga bamweta bati, Makalaasi era nga mwonyoko wa Nebbayoosi. ");
INSERT INTO gwr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Atyanu oYaakobbo oweyazwire omu Bberusebba, nʼasimba omu kibuga e Kalani. ");
INSERT INTO gwr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ni wabbaawo ekifo e kiyatuukiremu ngʼeisana ligwa, kale nʼasalawo okugona awo. Era nʼatoola erimo oku mabbaale agʼomu kifo ekyo, nʼalyeigikaku omutwegwe, nʼagalaamirira era nʼagona. ");
INSERT INTO gwr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Oweyabbaire agonere, nʼaloota ngʼabona amadaala amakomeke okwitakali, empembi yaago nga gatuuka omwigulu, era abamalaika ba Kibbumba nga bali kuniinanga, era nga baniinuka oku madaala nago. ");
INSERT INTO gwr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Omu kirooto omwo oYaakobbo nʼabona ngʼoMusengwa ayemereire empembi wʼamadaala era ngʼakoba ati, “Ninze oMusengwa, era oKibbumba wa Ibbulaimu ozeizawo, era oKibbumba wa Isaka oiteewo. Eitakali linu eryʼe Kanani eryogalaamiriireku nalirikuwa iwe nʼeibyaireryo. ");
INSERT INTO gwr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Eibyaireryo lyalibba linene ino, ngʼabantu tibabalika ooti musenye gwʼoku kyalo ogutabalika. Era balisalaanika ni batyama e bugwaisana nʼe buzwaisana, nʼe mambuka nʼe maserengeta. Era amawanga gonagona agʼoku kyalo naligawa enkabi nga mbitira mu niiwe nʼeibyaireryo. ");
INSERT INTO gwr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Okimanye oti, naabbanga na iwe, era nakukuumanga wonawona e giwaabanga, era nalikwirya okwitakali linu. Tinalikulekawo, era nakukoleranga byonabyona ebinkusuubizire.” ");
INSERT INTO gwr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Awo oYaakobbo nʼalamuka, nʼakoba omu mwoyogwe ati, “Mbaire timmaite nti oMusengwa ali omu kifo kinu! Neye mazima dala alimu!” ");
INSERT INTO gwr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Era nʼatya kaisi nʼakoba omu mwoyogwe ati, “Ekifo kinu nga kyʼentiisya! Ekifo kinu mazima niiwo oKibbumba e gyabba, era niigwo omulyango gwʼeigulu!” ");
INSERT INTO gwr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","OYaakobbo nʼasetuka eizo amakeezikeezi, nʼakwata eibbaale eriyeigikireku omutwe, nʼalikoma libbe kiijukizo. Awo nʼalisukaku amafuta gʼomuzaituuni okuliwongayo eeri oKibbumba. ");
INSERT INTO gwr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Era nʼayeta ekifo ekyo eriina ati Bbeseri. Neye ekibuga ekyo omu kusooka bakyetanga Luuzi. ");
INSERT INTO gwr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Awo oYaakobbo ni yeeyama eeri oMusengwa ati, “Owoobba waabba aamo na nze, nʼonkuuma omu lugendo lwange lunu, era nʼompa ebyokulya nʼebyokuzwala, ");
INSERT INTO gwr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ni mpezya okwirayo mwidembe omu kisito kya bbaabba, olwo waabbanga Kibbumba ogunasinzanga. ");
INSERT INTO gwr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Era eibbaale linu erinkomere okubba ekiijukizo, kyabbanga kifo abantu e gibaizanga okukusinza. Era nakuwanga ekimo ekyʼeikumi oku bintu byonabyona ebiwampanga.” ");
INSERT INTO gwr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Awo oYaakobbo ni yeeyongerayo nʼolugendolwe, nʼatuuka omu kyalo ekyʼe buzwaisana wʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Era ngʼali eeyo nʼabona eiruba omu kigona amantasuubira. Nʼabonawo ebiraalo bisatu ebyʼentaama nʼembuli, nga bigonere aawo oku mbale wʼeiruba nago, olwʼokubba omwiruba omwo, niimwo omu banywisyanga. Era eiruba eryo lyabbaire lisaanikeku eibbaale erigalami. ");
INSERT INTO gwr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ebiraalo byonabyona owebyakumbaananga aawo, abaliisya baabyo batoolangaku eibbaale eryo, ni banywisya entaama nʼembuli, kaisi ni bairyaku eibbaale nago okusaanikira okwiruba. ");
INSERT INTO gwr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Awo oYaakobbo nʼabuulya abaliisya bʼebiraalo nago ati, “Bainange, muzwera yaina?” Ni bamwiramu bati, “Tuzwera Kalani.” ");
INSERT INTO gwr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Era nʼababuulya ati, “Mumaite omusaiza ogubeeta oLaabbaani omwizukulu wa Nakoli?” Ni bamwiramu bati, “Tumumaite.” ");
INSERT INTO gwr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kaisi nʼababuulya ati, “Aliyo musa?” Ni bamwiramu bati, “Aliyo musa, era obone eedi omwalawe oLaakeeri ngodi aiza nʼentaama nʼembuli.” ");
INSERT INTO gwr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","OYaakobbo nʼakoba ati, “Ngonu bukaali musana, era ekiseera ekyokukanja ebyayo e ika kikaali okutuuka. Lwaki timubinywisya, era ni mubiiryayo okubiriisya.” ");
INSERT INTO gwr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ni bairamu bati, “Titwezya okukola ekyo okutoolaku ngʼebiraalo byonabyona bimalire okukumbaana aanu. Kaisi awo ni tutoolaku eibbaale okusaanukula eiruba, era ni tunywisya entaama nʼembuli.” ");
INSERT INTO gwr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","OYaakobbo yabbaire akaali atumula nabo, oLaakeeri nʼatuuka nʼentaama nʼembuli gya iteeye, olwʼokubba niiye eyagiriisyanga. ");
INSERT INTO gwr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","OYaakobbo oweyaboine oLaakeeri omwala wa koizawe oLaabbaani aamo nʼentaama gya Laabbaani, nʼayaba nʼatoolaku eibbaale okusaanukula eiruba, nʼanywisya entaama nʼembuli gya Laabbaani okoizawe. ");
INSERT INTO gwr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Awo nʼagwa oLaakeeri omu kifubba, era nʼakunga. ");
INSERT INTO gwr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","OYaakobbo nʼakobera oLaakeeri ati, “Ndi nʼolulyo nʼoiteewo, era ndi mwana wa Labbeeka oisengawo.” Kale oLaakeeri nʼairuka nʼayaba nʼakobera oiteeye. ");
INSERT INTO gwr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Awo oLaabbaani oweyawuliire ati oYaakobbo omwana wa mwonyokowe aizire, nʼayanguwa okwaba okumusangaana. Nʼamugwa omu kifubba, nʼamwaniriza omu kisitokye. Awo oYaakobbo nʼakobera oLaabbaani byonabyona ebimufaaku. ");
INSERT INTO gwr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kaisi oLaabbaani nʼamukoba ati, “Mazima dala tuli baluganda, era tuli bʼolulyo lumo.” Awo oluzwanyuma ngʼoYaakobbo amalire e wa Laabbaani omweri gumo, ");
INSERT INTO gwr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","oLaabbaani nʼakoba oYaakobbo ati, “Tiwampeereryenge bwereere newankubbaire tuli bʼolulyo lumo. Onkobere, otaka nkusasulenge kyenkana kitya?” ");
INSERT INTO gwr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Atyanu oLaabbaani yabbaire nʼabaalabe babiri, omukulu nga niiye oLeeya, omutomuto nga niiye oLaakeeri. ");
INSERT INTO gwr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Amaiso ga Leeya gabbaire gasangaalya, neye oLaakeeri yabbaire musiipoono, era amaisoge nga gasikiriza. ");
INSERT INTO gwr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","OYaakobbo nʼataka oLaakeeri, nʼolwekyo nʼakoba oLaabbaani ati, “Nakukolera okumala emyanka musanvu ompeemu omwalawo oLaakeeri.” ");
INSERT INTO gwr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","OLaabbaani nʼairamu ati, “Okumukuwa iwe okumufumbirwa kikiraku okumufumbirisya omusaiza ogondi. Kale okole ngʼowookobere.” ");
INSERT INTO gwr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","OYaakobbo nʼakola emyanka musanvu okusuna oLaakeeri, era ni gimubonekera ngʼenaku entono, olwʼokubba yabbaire ataka ino oLaakeeri. ");
INSERT INTO gwr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Awo emyanka omusanvu owegyawoireku, oYaakobbo nʼakoba oLaabbaani ati, “Emyanka omusanvu giwoireyo kale ompe omukali wange tukole obufumbo.” ");
INSERT INTO gwr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kale oLaabbaani nʼakola embaga yʼobugole era nʼayaniriza abantu bonabona ababbaire abatyami bʼomu kitundu ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Neye owekwairugaire, omukifo kya Laakeeri, oLaabbaani nʼakwata Leeya okuwa oYaakobbo, era oYaakobbo ni yeegaita naye. ");
INSERT INTO gwr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ebyo nga bikaali okubbaawo, oLaabbaani yabbaire amalire okukwata omugalamawe omukali oZirupa ngʼamuwaire oLeeya okubba omugalamawe. ");
INSERT INTO gwr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Awo eizo waaku amakeezi, oYaakobbo nʼamanyica ati yeegaitire nʼoLeeya. Kale nʼakoba oLaabbaani ati, “Niki kinu ekiwankolere? Nze nkukoleire iwe kumpa Laakeeri. Neye lwaki ombeyere?” ");
INSERT INTO gwr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","OLaabbaani nʼairamu ati, “Timpisa yaiswe omu kyalo kinu okufumbirisya omwala omutomuto ngʼomukulu waaku akaali okufumbirwa. ");
INSERT INTO gwr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Osooke omaleku enaku omusanvu egyʼekigole nʼoLeeya, kaisi nkuwe oLaakeeri yena omufumbirwe. Neye waabba nʼokunkolera okumala emyanka egindi musanvu.” ");
INSERT INTO gwr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kale oYaakobbo nʼaikirirya, era enaku omusanvu egyʼekigole nʼoLeeya owegyawoireku, oLaabbaani nʼamuwa oLaakeeri yena okubba omukaliwe. ");
INSERT INTO gwr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Era oLaabbaani nʼakwata omugalamawe omukali oBbirika nʼawa omwalawe oLaakeeri, okubba mugalamawe. ");
INSERT INTO gwr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","OYaakobbo ni yeegaita nʼoLaakeeri yena, era nʼataka oLaakeeri okukiraku ngʼowaataka oLeeya. Era nʼakolera oLaabbaani okumala emyanka egindi omusanvu. ");
INSERT INTO gwr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Awo oMusengwa oweyaboine ngʼoYaakobbo tataka ino oLeeya ngʼowaataka oLaakeeri, nʼawa oLeeya olubyalo, neye oLaakeeri nʼabba ngʼabulaku omwana. ");
INSERT INTO gwr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","OLeeya nʼabba kida, nʼabyala omwana mwisuka. Era oLeeya nʼakoba ati, “OMusengwa aboine okugada kwange, era atyanu oibawange yantaka.” Kale oLeeya nʼawa omwana eriina ati, Lubbeeni. ");
INSERT INTO gwr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Era oLeeya nʼabba kida tete, nʼabyala omwana mwisuka era oLeeya nʼakoba ati, “OMusengwa abuliire ati ndi munobe kagira ampaire omwana onu yena.” Kale oLeeya nʼawa omwana oyo eriina ati, Simyoni. ");
INSERT INTO gwr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Era nʼabba kida tete, nʼabyala omwana mwisuka, era oLeeya nʼakoba ati, “Omulundi gunu oibawange yaneekwataku ino, olwʼokubba mbyaire naye abaana abaisuka basatu.” Kale oLeeya nʼawa omwana eriina ati, Leevi. ");
INSERT INTO gwr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Era oLeeya nʼabba kida tete, nʼabyala omwana mwisuka. Era nʼakoba ati, “Omulundi gunu nawuuja oMusengwa.” Kale oLeeya nʼawa omwana eriina ati, Yuda. Era nʼalekeraawo okubyala. ");
INSERT INTO gwr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Atyanu oLaakeeri oweyaboine nga talikubyala nʼoYaakobbo abaana, nʼakwatira omugandawe engongi, kale nʼakoba oYaakobbo ati, “Ombyalemu abaana, obanga bbe wakiri nfe!” ");
INSERT INTO gwr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","OYaakobbo nʼasunguwalira oLaakeeri era nʼamukoba ati, “Oseega oti ninze oKibbumba akwimire olubyalo?” ");
INSERT INTO gwr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Awo oLaakeeri nʼakoba ati, “OBbirika omukali omugalama wange ngonu, weegaite naye, ambyalireku abaana, era okubitira mwiye zena nsune eibyaire.” ");
INSERT INTO gwr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kale nʼamuwa oBbirika omukali omugalamawe, abbe mukaliwe. Era oYaakobbo ni yeegaita nʼoBbirika, ");
INSERT INTO gwr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","era oBbirika nʼabba kida era nʼabyalira oYaakobbo omwana omwisuka. ");
INSERT INTO gwr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","OLaakeeri nʼakoba ati, “OKibbumba antoireku omusango, era awuliire okusaba kwange, nʼampa omwana omwisuka.” Kale oLaakeeri nʼamuwa eriina ati, Daani. ");
INSERT INTO gwr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Awo oBbirika omukali omugalama owa Laakeeri, nʼabba kida tete, era nʼabyalira oYaakobbo omwana omwisuka owokubiri. ");
INSERT INTO gwr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Awo oLaakeeri nʼakoba ati, “Mbaire nʼekinakoolo ekyamaani nʼomuganda wange era mpangwire.” Kale oLaakeeri nʼawa omwana eriina ati Nafutaali. ");
INSERT INTO gwr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","OLeeya oweyaboine ngʼayemereiryemu okubyala, yena nʼatoola oZirupa omukali omugalamawe, nʼamuwa oYaakobbo abbe mukaliwe. ");
INSERT INTO gwr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","OZirupa nʼabyala nʼoYaakobbo omwana mwisuka. ");
INSERT INTO gwr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Awo oLeeya nʼakoba ati, “Mbaire wʼenkabi!” Kale oLeeya nʼawa omwana eriina ati, Gaadi. ");
INSERT INTO gwr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","OZirupa nʼabyala nʼoYaakobbo omwana omwisuka owokubiri. ");
INSERT INTO gwr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Awo oLeeya nʼakoba ati, “Ndi musangaali, era atyanu abakali banjeta musangaali.” Kale oLeeya nʼawa omwana eriina ati, Aseri. ");
INSERT INTO gwr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Omu biseera ebyʼeikesa lyʼengaano, oLubbeeni nʼayaba omu musiri, nʼayajiryayo ebimera ebibeeta mandulake, nʼabireetera oLeeya omaaye. Awo oLaakeeri nʼakoba oLeeya ati, “Nkwegairiire, ompeeku omandulake wʼomutaanewo.” ");
INSERT INTO gwr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Neye oLeeya nʼamwiramu ati, “Okuntoolaku oibawange tikimala? Atyanu otaka okuntoolaku nʼomandulake wʼomutaane wange yena?” OLaakeeri nʼamukoba ati, “Singa wampa omandulake wʼomutaanewo, naikirirya oYaakobbo ni yeegaita na iwe ekiire kinu okukusasulamu omandulake wʼomutaanewo.” ");
INSERT INTO gwr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kale oYaakobbo oweyabbaire azwa omu musiri eigulo, oLeeya nʼawuluka okumusangaana, nʼamukoba ati, “Olwatyanu oli nʼokugona mwange, olwʼokubba mpaire oLaakeeri ebimera bya mutaane wange ebibeeta omandulake, okukwikirirya okwegaita na nze.” Kale ni yeegaita naye ekiire ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","OKibbumba nʼairamu okusaba kwa Leeya. OLeeya nʼabba kida, era nʼabyalira oYaakobbo omwana omwisuka owokutaanu. ");
INSERT INTO gwr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Awo oLeeya nʼakoba ati, “OKibbumba ampaire empeera olwʼokubba nawaire oibawange omukali omugalama wange.” Kale oLeeya nʼawa omwana eriina ati, Isakaali. ");
INSERT INTO gwr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","OLeeya nʼabba kida tete, nʼabyalira oYaakobbo omwana omwisuka owomukaaga. ");
INSERT INTO gwr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","OLeeya nʼakoba ati, “OKibbumba ampaire ekirabo ekisa. Atyanu oibawange yambitya kusani ngʼampa ekitiisya, olwʼokubba mbyaire naye abaana abaisuka mukaaga.” Kale oLeeya nʼawa omwana oyo eriina ati, Zebbulooni. ");
INSERT INTO gwr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Oluzwanyuma nʼabyala omwana omwala, era nʼamuwa eriina ati, Dina. ");
INSERT INTO gwr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Awo oKibbumba nʼaseega oku Laakeeri. Era oKibbumba nʼairamu okusaba kwa Laakeeri nʼamuwa olubyalo. ");
INSERT INTO gwr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","OLaakeeri nʼabba kida, nʼabyala omwana mwisuka, era oLaakeeri nʼakoba ati, “OKibbumba antoireku okuswala nʼampa omwana.” ");
INSERT INTO gwr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kale oLaakeeri nʼawa omwana oyo eriina ati, Yusufu era nʼakoba ati, “Musengwa onnyongere omwana ogondi omwisuka.” ");
INSERT INTO gwr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Awo oluzwanyuma oLaakeeri ngʼamalire okubyala oYusufu, oYaakobbo nʼakoba oLaabbaani ati, “Onseebule nkange e ika omu kyalo kyʼe waiswe. ");
INSERT INTO gwr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Era oganye njabe nʼabakali bange nʼabaana bange, olwʼokubba mbasunire kubitira mu kukukolera mirimo. Dala iwe omaite ngʼowenkukoleire emirimo kusani.” ");
INSERT INTO gwr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Neye oLaabbaani nʼamukoba ati, “Oleke ntumule kinu. Nvumbwire okubitira omu kulagula nti oMusengwa ampaire enkabi kubitira mu niiwe. ");
INSERT INTO gwr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Otaka nkusasule kyenkana kitya? Onkobere era nakusasula.” ");
INSERT INTO gwr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","OYaakobbo nʼamwiramu ati, “Iwe onanyere omaite emirimo eginkukoleire, era nʼebisolobyo ngʼowebyeyongeire obungi, nga ninze mbirabirira. ");
INSERT INTO gwr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Wabbaire nʼebisolo bitono nga nkaali okwiza, neye atyanu byeyongeire obungi, era oMusengwa akuwaire enkabi okubitira mu buli kinkolere kyonakyona. Neye atyanu nalisuna di ekiseera zena okukola ebintu ebigasa ekisito ekyange?” ");
INSERT INTO gwr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","OLaabbaani nʼabuulya ati, “Nakusasula kyenkana kitya?” OYaakobbo nʼairamu ati, “Tiwansasula empeera. Neye neeyongera okulabirira ebyayobyo, singa wankolera kinu. ");
INSERT INTO gwr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Onganye mbite omu biraalobyo byonabyona olwatyanu, nga njaba ntoolamu nabuli ntaama omwirugazu era nabuli mbuli owa mabalabala ooba onasusi. Era egyo niigyo egyabba empeera yange. ");
INSERT INTO gwr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Era walimanya ooba nga mbaire wʼamazima. Owewaliiza okukebera empeera yange, singa nalibba nʼombuli yenayena atali wa mabalabala ooba onasusi, ooba ontaama atali mwirugazu walimanya oti oyo njibbire wuwo.” ");
INSERT INTO gwr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","OLaabbaani nʼairamu ati, “Njikiriirye kale oleke kibbe kityo ngʼowookobere.” ");
INSERT INTO gwr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Neye oku lunaku olwo, oLaabbaani nʼatoolamu embuli empanya egya mabalabala nʼenasusi, nʼembuli enkali gyonagyona enasusi nga giriku amabala ameeru, era nʼentaama gyonagyona enjirugazu. Era nʼagikwatisya abataanebe okugirabirira. ");
INSERT INTO gwr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Awo oLaabbaani nʼabaanabe ni baaba nagyo ni batambula olugendo lwʼenaku isatu kaisi babbe yala ino okuzwa e giri oYaakobbo. OYaakobbo ni yeeyongera okulabirira ebyayo bya Laabbaani ebyasigairewo. ");
INSERT INTO gwr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Awo oYaakobbo nʼakwata ebisaga ebibisi ebyʼomusaale ogubeeta populaali nʼebisaga ebibisi ebyʼomusaale ogubeeta alumondi nʼebyʼogundi ogubeeta omupulaane nʼabikuujuulyaku ebikuta ebimo, ni bibonekaku emyalaala emyeru. ");
INSERT INTO gwr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ebisaale ebyo ebyakuujwiryeku ebikuta ebimo okubonecaaku emyalaala, nʼabikomeka omu bintu ebyayo omu binywera amaizi, olwʼokubba ebyayo byawakanga owebyabanga okunywa amaizi omu bintu ebyo. ");
INSERT INTO gwr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kale owebyawakanga nga biringiriire ebisaale ebyo, nga bibyala abaana abawoolere, nʼabamabalabala nʼabanasusi. ");
INSERT INTO gwr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Awo oYaakobbo nʼatoolyamu abaana abo abʼebyayo nʼabaawula. Neye ebisigairewo owebyabbanga biwaka nʼabiringiriryanga ebyʼebiwoolere nʼebyayo ebiirugazu ebya Laabbaani, awo ni gibyalanga abaana abawoolere nʼabamabalabala. Era omu ngeri eyo ebisolobye ni byeyongeranga obungi era nʼabyawulanga oku bya Laabbaani. ");
INSERT INTO gwr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Awo ebyayo bidi ebijimu owebyabbanga biwaka, oYaakobbo yakomekanga ebisaale bidi ebiyakuujwirye, omu bintu bidi ebiri omumaiso gʼebyayo, kaisi biwakire ebisaale bidi egibiri. ");
INSERT INTO gwr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Neye ebyayo owebyabbanga tibijimu, tiyateekangawo ebisaale ebyo. Nʼolwekyo ebyayo ebitali bijimu niibyo ebyabbanga ebya Laabbaani, kaisi ebijimu ni bibbanga bya Yaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Era omu ngeri eyo oYaakobbo nʼasuuka musuni ino nʼabba nʼebyayo bingi. Era nʼabba nʼabagalama abasaiza nʼabakali, nʼengamira, nʼempunda. ");
INSERT INTO gwr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Awo oYaakobbo nʼawulira ati abataane ba Laabbaani bakoba bati, “OYaakobbo atwaire ebintu byonabyona ebyabbaire ebya itewaiswe, era obusunibwe bwonabwona buzwire mu bintu ebyabbaire ebya itewaiswe.” ");
INSERT INTO gwr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Era oYaakobbo nʼabona ngʼoLaabbaani takaali amuseegaku kusani ngʼoweyakolanga eira. ");
INSERT INTO gwr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Awo oMusengwa nʼakoba oYaakobbo ati, “Okange omu kyalo kyʼe waanywe era eeri abʼekikaakyo, era naabbanga na iwe.” ");
INSERT INTO gwr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kale oYaakobbo nʼatuma ni beeta oLaakeeri nʼoLeeya ni baaba okumusangaana omu kiriisiryo e giri ebyayobye. ");
INSERT INTO gwr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Awo nʼabakoba ati, “Mboine ngʼoitewaanywe takaali anseegaku kusani ngʼoweyakolanga eira, neye oKibbumba wa bbaabba ali aamo na nze. ");
INSERT INTO gwr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mumaite muti nkoleire oitewaanywe nʼamaani gange gonagona. ");
INSERT INTO gwr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Neye oitewaanywe nʼandebalebania, era nʼacuusacuusa empeera yange emirundi nʼemirundi, cooka oKibbumba nʼandi nʼamuganya okunkolaku akabbikabbi. ");
INSERT INTO gwr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nabuli oweyakobanga ati, ‘Ebyayo ebyamabalabala niibyo ebyabba empeerayo,’ ebyayo byonabyona ni bibyala byʼamabalabala. Era nabuli oweyakobanga ati, ‘Ebyayo ebinasusi niibyo ebyabba empeerayo,’ ebyayo byonabyona ni bibyala biidi ebinasusi. ");
INSERT INTO gwr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kale omu ngeri eyo oKibbumba nʼatoola okwitewaanywe ebyayo nʼabimpa ninze.” ");
INSERT INTO gwr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Awo oYaakobbo ni yeeyongera ati, “Omu biseera byʼebyayo okuwaka nalootere, ngʼembuli empanya egiwakisirye ekiraalo, gibbaire gya mabalabala nʼenasusi. ");
INSERT INTO gwr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Omalaika wa Kibbumba nʼanjeta omu kirooto ati, ‘Yaakobbo!’ Ni njetuka nti, ‘Waitu!’ ");
INSERT INTO gwr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kaisi nʼankoba ati, ‘Osiirye amaisogo obone. Empanya gyonagyona egiwakisirye ekiraalo egimo gya mabalabala nʼegindi nasusi. Ekyo kityo olwʼokubba mboine byonabyona oLaabbaani ebyakukola. ");
INSERT INTO gwr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ninze oKibbumba eyakubonekeire e Bbeseri, eeyo e giwasukiire amafuta gʼomuzaituuni okwibbaale ngʼekiijukizo, okuliwongayo eeri oKibbumba, era e giweeyamiire egyendi. Atyanu osetuke okange omu kyalo egibakubyala.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Awo oLaakeeri nʼoLeeya ni bamwiramu bati, “Titukaali tuli nʼomugabo ooba obusika omu kisito kya itewaiswe. ");
INSERT INTO gwr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Era atyanu atubitya ooti tuli banamawanga. Yatutundire, era nʼemaali egibatukweire agiriire nʼagimalawo. ");
INSERT INTO gwr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Obusuni bwonabwona oKibbumba obwatoire okwitewaiswe niibwo obwaiswe, era niibwo obwa baana baiswe. Kale atyanu okole kyonakyona oKibbumba ekyakukobere.” ");
INSERT INTO gwr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Awo oYaakobbo nʼasetuka, nʼaniinisya abaanabe nʼabakalibe oku ngamira. ");
INSERT INTO gwr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Era nʼatwala nʼebyayobye byonabyona nʼebintubye byonabyona ebiyabbaire asunire omu Padanalaamu, nʼasimbuka okukanga e giri oIsaka oiteeye, omu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Omu kiseera ekibasimbukiiremu, oLaabbaani yabbaire ayabire kusalaku ntaamagye byoya. Kale oLaakeeri nʼakolesya enkabi egyo okwibba ebifaananyi bya iteeye ebyasinza. ");
INSERT INTO gwr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Era oYaakobbo ni basodoka-busodoki ngʼoLaabbaani oMwalameeni tamaite, olwʼokubba oYaakobbo tiyamukobeire ngʼayaba. ");
INSERT INTO gwr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Batyo ni basodoka nʼebyabwe byonabyona, era ni bambuka omwiga Ewufulaate, ni basimba omu Gireyaadi ekyalo ekyʼensozisozi. ");
INSERT INTO gwr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Awo oluzwanyuma lwʼenaku ibiri, oku lwokusatu, ni bakobera oLaabbaani bati oYaakobbo yairukire. ");
INSERT INTO gwr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kale oLaabbaani nʼakwata abantu abeyabbaire nabo, ni baaba bayiiga oYaakobbo okumala enaku musanvu, era ni bamwaja mu Gireyaadi ekyalo ekyʼensozisozi. ");
INSERT INTO gwr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Neye oKibbumba yabbaire atumwire nʼoLaabbaani oMwalameeni ngʼamulabula ati, “Weegendereze okutakoba oYaakobbo ebibono ebimutiisyatiisya omu ngeri yonayona.” ");
INSERT INTO gwr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Awo oLaabbaani nʼatuuka oku Yaakobbo era nʼamwajirya ngʼakomekere eweemaye omu kyalo ekyʼensozisozi ekyʼe Gireyaadi. Era nʼoLaabbaani nʼabantu abeyabbaire nabo bona ni bakomeka eeyo eweema egyabwe. ");
INSERT INTO gwr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Awo oLaabbaani nʼakoba oYaakobbo ati, “Niki ekyo ekiwakolere? Lwaki wasodokere nʼabaala bange ooti-so obawambire mu lutalo? ");
INSERT INTO gwr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Lwaki wansodokereku? Lwaki tiwankobeire ngʼoyaba kaisi ni nkuseebula omwisangaalo nga twemba tukubba obugoma nʼotongoli? ");
INSERT INTO gwr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tiwanganyire kadi nʼokugwaku abaizukulu bange nʼabaala bange omu bifubba okubaseebula! Wakolere kya busirusiru. ");
INSERT INTO gwr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Era ndi nʼobwezye okubakola akabbikabbi. Neye oKibbumba wa iteewo yandabwire omu kirooto obwire obutakolesya ebibono ebikutiisyatiisya omu ngeri yonayona. ");
INSERT INTO gwr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Atyanu nkitegeire lwaki watakire ino okukanga e wa iteewo. Neye lwaki waibbire ebifaananyi byange ebyʼokusinza ebyʼabakibbumba bange?” ");
INSERT INTO gwr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Awo oYaakobbo nʼairamu oLaabbaani ati, “Nasodokere olwʼokubba natiire, era naseegere nti wantoolaku abaalabo nʼempaka. ");
INSERT INTO gwr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Neye oguwaajirya nʼebifaananyi byʼabakibbumbabo, bamwite. Aanu omumaiso gʼabantu baiswe, otoolemu nabuli ekindi nakyo nga kikyo okitwale.” Cooka oYaakobbo yabbaire tamaite ati oLaakeeri yaibbire ebifaananyi ebyʼokusinza nago. ");
INSERT INTO gwr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kale oLaabbaani nʼaingira okwaza omu weema ya Yaakobbo, nʼomu weema ya Leeya, nʼomu weema yʼabagalama ababiri abakali, neye nandi nʼabona ebifaananyibye nago ebyʼokusinza. Era omu kusembayo nʼaingira omu ya Laakeeri. ");
INSERT INTO gwr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Cooka oLaakeeri yabbaire atwaire ebifaananyi ebyo ngʼabibisire omu kisawo ekibateekamu ebintu oku ngamira era ngʼabityaimeku. Era oLaabbaani nʼayaza eweema ya Laakeeri yonayona, neye era nandi nʼabona. ");
INSERT INTO gwr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Awo oLaakeeri nʼakoba oiteeye ati, “Bbaabba, nkusaba nti tiwasunguwala okubona nga tinjemereire okukuwa ekitiisya, olwʼokubba ndi munsonga gyʼekikali.” Era oLaabbaani nʼanoonia, neye era nandi nʼabona ebifaananyibye ebyo. ");
INSERT INTO gwr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Awo oYaakobbo nʼasunguwala, nʼakaabukira oLaabbaani ati, “Nsoberye niki? Nkolere kikoleki ekibbikibbi ekigira nʼonjiiga otyo? ");
INSERT INTO gwr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Aale ngoyo oyazire ebintu byange byonabyona, niki ekikyo ekyoboinemu? Owoobba ngʼoboinemu, okiteeke aanu omumaiso gʼabantu baiswe kaisi batusalirewo oku babiri kwiswe naani omutuuce.” ");
INSERT INTO gwr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Awo oYaakobbo ni yeeyongera ati, “Omu myanka egyo aabiri egimbaire na iwe, entaamagyo nʼembuligyo tigisumulangaku, era tindyangaku ontaama omusaiza owʼomu kiraalokyo. ");
INSERT INTO gwr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Okisolo oweyaitanga ontaamawo ooba ombuliwo, nga ninze njiryawo. Era mazima dala obbaire ngʼombanza okwiryawo nabuli ntaamawo, ooba ombuliwo okisolo ogwabba aliire omusana ooba obwire. ");
INSERT INTO gwr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mbaire nga nkaanya eisana era nga nkaanya empewo eyʼobwire nga nʼendoolo tigiiza. ");
INSERT INTO gwr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Embeera ebbaire etyo okumala emyanka aabiri egimbaire omu kisitokyo. Nakukoleire emyanka ikumi nʼeena nga mpakasa abaalabo ababiri, era ni ngaitaku egindi mukaaga nga wansasula ntaama nʼembuli, neye iwe nʼocuusacuusa empeera yange emirundi nʼemirundi. ");
INSERT INTO gwr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Singa oKibbumba wa zeiza oIbbulaimu nʼoIsaka obbaabba, tabbairenge aamo na nze, mazima wandibbaire ngʼonseebula nga mbula kantu. Neye oKibbumba aboine okugada kwange okwo nʼokutegana kwange okwo, nʼakusalira omusango omu kiire ekibitire.” ");
INSERT INTO gwr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Awo oLaabbaani nʼairamu oYaakobbo ati, “Abaala abo, baala bange, era nʼabaana baabwe, bange, era nʼebyayo ebyo byange. Era nʼebintu byonabyona ebyobona aanu byange. Neye timpezya okukuuma abaala bange abo nʼabaana baabwe. ");
INSERT INTO gwr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kale atyanu, tukole endagaano nze na iwe, ebbe bujulizi akatiwo na nze.” ");
INSERT INTO gwr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Awo oYaakobbo nʼatoola eibbaale nʼalikoma okubba ekiijukizo. ");
INSERT INTO gwr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Era nʼakoba abantu abeyabbaire nabo ati, “Mukumbaanie amabbaale.” Era ni batoola amabbaale ni bagabbiirya ekibbiiryo. Kaisi awo abantu oYaakobbo nʼoLaabbaani abebabbaire nabo ni baliira aawo ebyokulya okumpi nʼekibbiiryo nago. ");
INSERT INTO gwr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Era oLaabbaani nʼawa ekibbiiryo nago eriina ati, Yegali Sakaduta, kaisi oYaakobbo iye nʼakiwa eriina ati, Galeedi. ");
INSERT INTO gwr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Era oLaabbaani nʼakoba ati, “Ekibbiiryo kinu kiijukizo kyʼendagaano akatiwo na nze olwatyanu.” Kagira bakiwaire eriina bati, Galeedi ");
INSERT INTO gwr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","era bati, Mizupa, olwʼokubba oLaabbaani yakobere ati, “OMusengwa alamulenge akatiwo na nze owetwabba nga titukaali tubonangana. ");
INSERT INTO gwr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Owewagadyanga abaala bange, ooba owewalifumbirwa abakali abandi, waire nga tinalikimanya, oyebukiryanga oti oKibbumba iye mujulizi akatiwo na nze.” ");
INSERT INTO gwr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Awo oLaabbaani nʼakoba oYaakobbo ati, “Obone ekibbiiryo kinu ekyʼamabbaale nʼeibbaale linu erikome ngʼekiijukizo kyʼendagaano akatiwo na nze. ");
INSERT INTO gwr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ekibbiiryo kinu nʼeibbaale linu erikome byabbanga kiijukizo kyʼendagaano yaiswe. Era endagaano eyo ngʼekoba eti, tinalitambuka ekibbiiryo kinu okukulumba okukukola akabbikabbi. Era wena tiwalitambuka ekibbiiryo kinu nʼeibbaale eryo nʼonnumba okwange okunkola akabbikabbi. ");
INSERT INTO gwr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Nsaba nti oKibbumba wa Ibbulaimu era oKibbumba wa Nakoli, era oKibbumba wa itewaabwe, alamulenge akatiwo na nze.” Kale oYaakobbo nʼalayira oKibbumba wa iteeye oIsaka, ati yakuumanga endagaano eyo. ");
INSERT INTO gwr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Awo oYaakobbo nʼawa oKibbumba esadaaka nga bali eeyo omu kyalo kyʼensozisozi, era nʼayaniriza abantu bonabona ababbairewo oku kiinulo. Owebamalire okulya, ni bagona eeyo ekiire ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Eizo amakeezikeezi oLaabbaani nʼalamuka, era nʼagwa abaizukulube nʼabaalabe omu bifubba era nʼabasabira enkabi. Awo nʼasimbuka okukanga e wuwe. ");
INSERT INTO gwr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Awo oYaakobbo ni yeeyongerayo omu lugendolwe, abamalaika ba Kibbumba ni bamusangaana. ");
INSERT INTO gwr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","OYaakobbo oweyababoine, nʼakoba ati, “Ganu niigo amaje ga Kibbumba.” Nʼawa ekifo ekyo eriina ati, Makanaimu. ");
INSERT INTO gwr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Awo oYaakobbo nʼatuma abakwenda bamwesooke eeri Esawu omugandawe eyabbaire omutyami wʼomu nsozi egibeeta Seiri, omu kyalo ekibeeta Edomu. ");
INSERT INTO gwr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nʼabatuma ati, “Mukobe omusengwa wange Esawu muti, ‘OYaakobbo omuweereryawo nenca abbanga wa Laabbaani, era abbaire niiyo paka atyanu. ");
INSERT INTO gwr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Era ali nʼente nʼempunda nʼebiraalo byʼentaama nʼembuli, era nʼabagalama abasaiza nʼabakali. Era ali kukusindikira obukwenda iwe omusengwawe, kaisi omukwatire ekisa.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Abakwenda owebazwire e giri Esawu, ni bakanga e giri oYaakobbo ni bamukoba bati, “Twabire eeri omugandawo Esawu, era ali kwiza nʼabasaiza 400 okukusangaana.” ");
INSERT INTO gwr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Awo oYaakobbo nʼatya ino, ni yeeraliikirira. Kale nʼagawulamu abantu abeyabbaire nabo ebibbubbu bibiri. Era nʼagawulamu nʼekiraalo kyʼentaama, nʼekyʼembuli, nʼekyʼente, nʼekyʼengamira ebibbubbu bibiri bibiri. ");
INSERT INTO gwr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakolere atyo ngʼaseega ati, “Singa Esawu yalumbaku ekibbubbu ekimo nʼakikubba, ekibbubbu ekindi amo ni kiwunuka.” ");
INSERT INTO gwr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Awo oYaakobbo nʼasaba ati, “Oo, Kibbumba wa zeiza wange oIbbulaimu, era oKibbumba wa bbaabba oIsaka. Oo, Musengwa Kibbumba iwe owankobere oti nkange omu kyalo kyʼe waiswe era e giri abʼekika kyange, wansuubizire oti wampanga enkabi era waabbanga na nze. ");
INSERT INTO gwr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tinsaanira okunkwatira ekisa ekyo kyonakyona ekiwankwatiire era nʼobwesigwa bwonabwona obuwandagire nze omuweereryawo. Owenayambukiire omwiga oYoludaani, nabbaire nʼomukoomero gwonkani. Neye atyanu njirire nga ndi nʼebibbubbu bibiri ebyʼabantu era nʼebibbubbu bibiri bibiri ebyʼebisolo ebyʼenjawulo. ");
INSERT INTO gwr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kibbumba nkusaba ondamye omuganda wange Esawu olwʼokubba mmutya, ademba nʼaiza nʼatwita swenaswena, nʼabakali nʼabaana. ");
INSERT INTO gwr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Neye wankobere oti wampanga enkabi era waabbanga na nze, era oti walimpa eibyaire linene abantu ni babba bangi ooti musenye ogwʼoku nyanza ogutabalika.” ");
INSERT INTO gwr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Era oYaakobbo nʼasigala nʼagona aawo ekiire ekyo. Awo eizo waaku amakeezi nʼatoola ebimo oku bisolo ebiyabbaire nabyo nʼaweererya Esawu omugandawe ngʼekirabo nga niibyo binu: ");
INSERT INTO gwr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Embuli enkali 200, nʼempanya aabiri, nʼentaama enkali 200, nʼensaiza aabiri. ");
INSERT INTO gwr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Era nʼamuwa nʼengamira 30 nʼabaana baajo, nʼente ebisonga 40, nʼenumi ikumi, nʼempunda enkali aabiri, nʼensaiza ikumi. ");
INSERT INTO gwr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Era oYaakobbo nʼabigawulamu, nʼabikwatisya abagalamabe, nga nabuli kiraalo kiriku mugalama waaku, kaisi nʼabakoba ati, “Muneekubbemberemu, neye mulekengewo eibbanga aakati wʼekiraalo ekimo nʼekindi.” ");
INSERT INTO gwr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Awo oYaakobbo nʼalagira omugalamawe eyeekubbembeiremu ati, “Omuganda wange Esawu oweyakusangaana nʼakubuulya eriina lya musengwawo, era nʼakubuulya nʼegyoyaba era nʼakubuulya nʼonanyere ebisolo ebyodooma, ");
INSERT INTO gwr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","wamwiramu oti, ‘bya muweereryawo oYaakobbo. Era ibyo kirabo ekyakuweereirye iwe Esawu omusengwawe. Era oYaakobbo yena onyere ali eeyo e nyuma aiza.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Era oYaakobbo nʼawa biragiro binanyere ebyo omugalama wokubiri, nʼowokusatu, nʼabagalama abandi bonabona ababbaire abadooma ebiraalo. Era nʼabakoba ati, owebasangaana Esawu bali nʼokumukoba bintu binanyere ebyo. ");
INSERT INTO gwr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Era ati bali nʼokukoba Esawu bati, omuweereryawe oYaakobbo yena onanyere ali e nyuma eeyo aiza. OYaakobbo yaseegere ati ebirabo ebyasookere nʼaweererya eeri Esawu nga bakaali okusangaana, amo ni biikaikania Esawu nʼamwaniriza. ");
INSERT INTO gwr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Awo nʼasooka nʼaweererya ebirabo, neye iye nʼasigala awo omu nkambi era nʼagonawo ekiire ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Awo omu kiire ekyo oYaakobbo nʼasetuka, nʼakwata abakalibe ababiri, nʼabakalibe abagalama ababiri, nʼabaanabe eikumi na moiza, nʼabasomoca omwiga oYabboki. ");
INSERT INTO gwr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Era oweyamalire okubasomoca nʼakangayo nʼalagira ni baaba basomoca nʼebintu byonabyona ebiyabbaire nabyo. ");
INSERT INTO gwr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kale oYaakobbo nʼasigala omu nkambi yenkani. Awo ni wabbaawo omusaiza eyaizire, nʼalwana naye paka emambya oweyasalire. ");
INSERT INTO gwr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Neye omusaiza nago oweyaboine nga tiyawangule oYaakobbo, nʼamukubba nʼamuniokola einiko ngʼalwana naye. ");
INSERT INTO gwr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Awo omusaiza nago nʼakoba oYaakobbo ati, “Onteere njabe obwire buceire.” Neye oYaakobbo nʼamukoba ati, “Tinakuteere okutoolaku ngʼompaire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Era omusaiza nago nʼabuulya oYaakobbo ati, “Eriinalyo niiwe onaani?” Iye nʼamwiramu ati, “Yaakobbo.” ");
INSERT INTO gwr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Awo omusaiza nago nʼakoba oYaakobbo ati, “Tibakaali bakweta Yaakobbo, wazira bakwetanga Isirairi olwʼokubba oyezyerye okuguma nʼolwana nʼoKibbumba era nʼabantu.” ");
INSERT INTO gwr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Awo oYaakobbo nʼakoba omusaiza nago ati, “Nkwegairiire, onkobere eriinalyo.” Neye iye nʼamwiramu ati, “Lwaki ombuulya eriina lyange?” Era omusaiza nago nʼaweera oYaakobbo enkabi omu kifo ekyo. ");
INSERT INTO gwr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kale oYaakobbo nʼakoba ati, “Mboine oKibbumba maiso ku maiso, kaisi era ni nsigala nga ndi mwomi!” Nʼolwekyo nʼawa ekifo ekyo eriina Peniyeeri. ");
INSERT INTO gwr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Awo ngʼeisana lizwayo, nʼazwa e Penweri ngʼacooda olwʼeinikolye eriniokole. ");
INSERT INTO gwr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Era nʼolwekyo paka lwatyanu aBaisirairi tibalya enyama eyʼebisolo eyʼokwiniko olwʼokubba oku nyama eyo niikwo oku bakubbire oYaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Awo oluzwanyuma oku lunaku olunanyere olwo, oYaakobbo nʼasiirya amaisoge, nʼalengera Esawu ngʼaiza nʼabasaizabe 400. Kale oYaakobbo nʼagawula nabuli mukali nʼabaanabe, ekikoba kiti oLeeya nʼababe, nʼoLaakeeri nʼababe era nʼabakalibe abagalama ababiri bona nabuli moiza nʼabaanabe. ");
INSERT INTO gwr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kaisi awo nʼateeka abakalibe abagalama nʼabaana baabwe omumaiso. Awo nʼairyaku oLeeya nʼabaanabe, kaisi nʼasembyayo oLaakeeri nʼomutaane oYusufu. ");
INSERT INTO gwr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Awo oYaakobbo nʼabeekubbemberamu nʼayaba okusangaana omugandawe. Era oYaakobbo oweyaigereire e gyali, oYaakobbo nʼakotama okumuwa ekitiisya. Ekyo nʼakikola emirundi musanvu omumaiso gʼomugandawe. ");
INSERT INTO gwr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Neye Esawu nʼavulumuka okumusangaana, era nʼamugwa omu kifubba, kaisi bombi ni bakulumuca amaliga olwʼeisangaalo. ");
INSERT INTO gwr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Awo Esawu nʼasiirya amaisoge, nʼalola oku bakali nʼabaana, kaisi nʼabuulya ati, “Banaani abo abooli nabo?” OYaakobbo nʼamwiramu ati, “Abo niibo abaana oKibbumba olwʼekisaakye abeyawaire omuweereryawo.” ");
INSERT INTO gwr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Awo abakali ba Yaakobbo abagalama ni baigerera nʼabaana baabwe, ni bakotama omumaiso gʼEsawu. ");
INSERT INTO gwr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Era nʼoLeeya nʼabaanabe bona ni baigerera omumaiso gʼEsawu ni bakotama. Awo omu kukomenkereza oYusufu nʼoLaakeeri omaaye bona ni baigerera omumaiso gʼEsawu, ni bakotama. ");
INSERT INTO gwr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Era Esawu nʼabuulya oYaakobbo ati, “Wategeezere niki okuweererya ebiraalo bidi byonabyona ebinsangaine omu luguudo?” OYaakobbo nʼamwiramu ati, “Ebyo birabobyo musengwa kaisi onkwatire ekisa.” ");
INSERT INTO gwr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Neye Esawu nʼamukoba ati, “Ebindinabyo bimmala muganda wange. Ebyolinabyo obisigaze.” ");
INSERT INTO gwr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","OYaakobbo nʼamukoba ati, “Kadi, nkwegairiire! Owoobba ngʼonkwatiire ekisa, oikirirye ebirabo ebinkuwaire. Ekyo kityo olwʼokubba okukubonaku nʼonsangaalira, kiri ooti-so kubona Kibbumba maiso ku maiso. ");
INSERT INTO gwr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Nkwegairiire oikirirye ebirabo ebinkuleeteire olwʼokubba oKibbumba ankoleire ebyʼekisa, era ebindinabyo bimmala.” Era oYaakobbo ni yeegumya okumwegairira paka Esawu oweyabiikiriirye. ");
INSERT INTO gwr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Awo Esawu nʼakoba oYaakobbo ati, “Aale okole twabe, nze nakwekubbemberamu.” ");
INSERT INTO gwr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","OYaakobbo nʼamukoba ati, “Musengwa wange, omaite ngʼabaana bakaali batobato ate nga ndi nʼokulabirira entaama nʼente egyonkesya. Owenagyanguwisya okumala olunaku olulamba, ebisolo byonabyona ebyo byafa. ");
INSERT INTO gwr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Kale oleke iwe musengwa wange oyabenge, nga zena omuweereryawo wenkuzwaku e nyuma nʼebisolo nga mbikoomya okwabirana nʼabyo, nʼabaana paka owenakutuukaku musengwa omu Seiri.” ");
INSERT INTO gwr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Awo Esawu nʼakoba oYaakobbo ati, “Kale oleke nkulekere abamo oku bantu abendi nabo.” Neye oYaakobbo nʼamukoba ati, “Ekyo tikyetaagisya. Ngʼowonkwatiire ekisa nʼonjaniriza kusani otyo musengwa wange, ekyo kimala.” ");
INSERT INTO gwr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kale Esawu nʼasimbuka oku lunaku olunanyere olwo nʼakanga e Seiri. ");
INSERT INTO gwr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Neye oYaakobbo tete iye nʼayaba Sukosi nʼatembulayo ekisito, era nʼayombekera nʼebisolobye ebisiisira. Ekifo ekyo kagira bakyetere Sukosi. ");
INSERT INTO gwr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Oluzwanyuma oYaakobbo nʼatuuka mirembe omu kibuga kyʼe Sekemu, ekiri omu kyalo kyʼe Kanani, ngʼamalire okuzwa e Padanalaamu, era nʼakomeka eweemagye okumpi nʼekibuga kyʼe Sekemu. ");
INSERT INTO gwr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Era nʼagula eitakali oku baizukulu ba Kamoli oiteeye wa Sekemu. Yaligulire amairambula gʼefeeza 100, era niiwo egiyakomekere eweemagye. ");
INSERT INTO gwr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Era omu kifo ekyo nʼayombekamu ekyoto nʼakiwa eriina Ero Eroke Isirairi. ");
INSERT INTO gwr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lwabbaire lumo oDina, omwala oLeeya oguyabyaire nʼoYaakobbo, nʼayaba okucaalira abaala aBakanani. ");
INSERT INTO gwr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","OSekemu omutaane wa Kamoli oMukiivi, omufugi wʼekyalo ekyo, oweyamuboine nʼamukwata okalijata. ");
INSERT INTO gwr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Era oDina omwala wa Yaakobbo nʼasikiriza ino oSekemu, era oSekemu nʼamutaka ino, era nʼamusimoolya. ");
INSERT INTO gwr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Kale oSekemu nʼakoba oKamoli oiteeye ati, “Onkwere omwala oyo.” ");
INSERT INTO gwr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Atyanu oYaakobbo nʼawulira ngʼoDina omwalawe, oSekemu yamusoberyeku. Neye olwʼokubba abataane ba Yaakobbo babbaire baabire kuliisya bisolo, nʼasirika paka owebairire. ");
INSERT INTO gwr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Awo oKamoli oiteeye wa Sekemu nʼayaba eeri oYaakobbo okutumula naye oku nsonga eyo. ");
INSERT INTO gwr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Era omu kiseera ekinanyere ekyo abataane ba Yaakobbo ni baira okuzwa omu kuliisya. Owebawuliire ebifa oku Dina, ni kibalumya ino, era ni basunguwala ino. Ekyo kyabbaire kityo olwʼokubba oSekemu yabbaire akolere ekyʼomuliko ekitakoleka era ekiswaza oIsirairi, oweyakwaite omwala wa Yaakobbo okalijata. ");
INSERT INTO gwr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Neye oKamoli nʼakoba oYaakobbo nʼabataane ati, “Omutaane wange oSekemu ataka omwala waanywe. Mbegairiire mumuwe amufumbirwe. ");
INSERT INTO gwr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Era tufumbirwaganenge, mutuwenge abaala baanywe, nywena ni mutwala abaala baiswe. ");
INSERT INTO gwr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mwezya nʼokubbanga aamo na iswe okwitakali eryaiswe, ni mutyama e gimutaka, era ni mwetayaaya, ni musuna nʼebyobusuni.” ");
INSERT INTO gwr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Awo oSekemu eyabbaire atambwire nʼoiteeye, yena nʼakoba oiteeye wa Dina nʼaboonyoko ba Dina ati, “Mbegairiire mwikirirye okusaba kwaiswe era kyonakyona ekimwataka nabawa. ");
INSERT INTO gwr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Munsalire emaali, nʼebirabo ebimutaka, nʼowebyabba byenkana bitya obungi, nabawa, kasita owemwampa omwala oyo okumufumbirwa.” ");
INSERT INTO gwr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Awo abataane ba Yaakobbo ni bairamu oSekemu nʼoiteeye oKamoli nga babakiina olwʼokubba oSekemu yabbaire asoberye oku Dina omwonyoko waabwe. ");
INSERT INTO gwr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Era abataane ba Yaakobbo ni babakoba bati, “Titwezya okukola ekyo, okuwa omusaiza atali omukomole omwonyoko waiswe, olwʼokubba ekyo kyabba kyʼensoni egituli. ");
INSERT INTO gwr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Neye twabaikirirya ni mumufumbirwa singa mwakola nga iswe, abasaiza bonabona abʼomwigwanga lyanywe ni babba bakomole. ");
INSERT INTO gwr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Olwo awo twaikirirya okubawanga abaala baiswe, swena ni tufumbirwanga abaala baanywe. Era twabbanga kintu kimo na inywe, era ni tubba ooti bantu abʼekika ekimo. ");
INSERT INTO gwr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Neye singa mwagaana okukomola, twabatoolaku omwala waiswe, ni tweyabira naye.” ");
INSERT INTO gwr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Era ebiseego byabwe ebyo ni bibba bisa eeri oKamoli nʼomutaane oSekemu. ");
INSERT INTO gwr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Awo omwisuka oyo oSekemu, eyabbaire nga niiye akira ekitiisya omu kisito kya iteeye, nʼasetukiramu okukola ekibakobere olwʼokubba yasiimire ino omwala wa Yaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Oluzwanyuma oKamoli nʼomutaane oSekemu, ni baaba okumpi nʼomulyango gwʼekikomera kyʼekibuga kyabwe, ni batumula nʼabasaiza abʼomu kibuga ekyo, nga babakoba bati, ");
INSERT INTO gwr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Abasaiza badi babula kigosi na iswe. Tubaleke batyame okwitakali lyaiswe era beetaayaaye, olwʼokubba ekifo kigalami kibamala. Twezya nʼokufumbirwanga abaala baabwe, era bona ni bafumbirwanga abaala baiswe. ");
INSERT INTO gwr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Neye abasaiza nago baikirirya okutyama okwitakali linu aamo na iswe nga tuli ooti bʼekika kimo lwʼekintu kimo. Bataka iswe abasaiza tubbe bakomole. ");
INSERT INTO gwr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kaisi nago owetwakola tutyo, ente gyabwe nʼebyobusuni byabwe, nʼebisolo byabwe ebindi byonabyona oluzwanyuma byalibba byaiswe. Kale twikirizaganye nabo batyame okwitakali lyaiswe aamo na iswe.” ");
INSERT INTO gwr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Awo abasaiza bonabona ababbaire bakumbaine okumpi nʼomulyango gwʼekikomera kyʼekibuga kyabwe, ni baikirirya ebya Kamoli nʼomutaane oSekemu, era nabuli musaiza omu kibuga ni bamukomola. ");
INSERT INTO gwr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Awo oluzwanyuma lwʼenaku ibiri, oku lwokusatu nga bamalire okubakomola nʼempiima ngʼebiso bibaluma, abataane ba Yaakobbo ababiri, oSimyoni nʼoLeevi aboonyoko ba Dina, ni bakwata empiima gyabwe, ni bavumbiikirirya ekibuga ni baita abasaiza bonabona. ");
INSERT INTO gwr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Era baitiiremu nʼoKamoli nʼomutaane oSekemu, era ni batoola oDina omu nyumba ya Sekemu ni bazwayo. ");
INSERT INTO gwr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Oluzwanyuma abataane ba Yaakobbo abandi owebayajiirye nga babaitire, ni banyaga ebyʼomu kibuga nga beesasuza olwa mwonyoko waabwe ogubasoberyeku. ");
INSERT INTO gwr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Era banyagire entaama, nʼembuli, nʼente, nʼempunda, nabuli kintu kyonakyona ekyabbaire omu kibuga nʼebyabbaire omu misiri. ");
INSERT INTO gwr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Era batwaire ebyobusuni byonabyona, ni banyaga abaana abatobato bonabona nʼabakali bonabona, nʼebintu byonabyona ebyabbaire omu manyumba. ");
INSERT INTO gwr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Awo oYaakobbo nʼakoba oSimyoni nʼoLeevi ati, “Mundeeteire ekinakoolo! Atyanu aBakanani, nʼaBaperizi, nʼabandi bonabona abʼomu kyalo ekyo baaba kumpalana. Ndi nʼabantu batono, kale singa badi bonabona balyeyimbya ni bannumba, balimmalawo nʼabʼomu kisito kyange bonabona.” ");
INSERT INTO gwr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Neye ibo ni bamwiramu bati, “Olwo iye yakolere kisa okubitya omwonyoko waiswe ooti malaaya?” ");
INSERT INTO gwr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Awo oluzwanyuma oKibbumba nʼakoba oYaakobbo ati, “Osetukiremu oyabe e Bbeseri, otyame eeyo era onnyombekereyo ekyoto. Ninze oKibbumba eyakubonekeire owewairukiire omugandawo Esawu.” ");
INSERT INTO gwr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kale oYaakobbo nʼakoba abʼomu nyumbaye, nʼabantu abandi bonabona abeyabbaire nabo ati, “Mweyambulye abakibbumba abemuli nabo abʼamawanga agandi, era mwetukulye, mucuuse nʼebizwalo byanywe muzwale ebitukula. ");
INSERT INTO gwr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Aale musetukiremu twabe e Bbeseri eginayombekera oKibbumba ekyoto, oyo eyambeereire omu kiseera ekinabbeereire omu bugosi. Era abbaire na nze nabuli e gimbairenge.” ");
INSERT INTO gwr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kale ni bawa oYaakobbo ebifaananyi byonabyona ebyʼokusinza ebyʼabakibbumba ebibabbaire nabyo, era ni bamuwa nʼempeta egibabbaire nagyo oku matwi gaabwe. Era oYaakobbo nʼabiriika ansi wʼomuvule okumpi nʼekibuga oSekemu. ");
INSERT INTO gwr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Awo oYaakobbo nʼabaanabe owebabbaire basimbuka, entiisya eya Kibbumba enene nʼekwata abʼomu bibuga ebyeruguuliriirye aawo, era abantu abo ni batabasenjaku okubalumba. ");
INSERT INTO gwr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Awo oYaakobbo aamo nʼabantube bonabona abeyabbaire nabo, ni batuuka e Luuzi okuti ekibeeta Bbeseri, ekiri omu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Era eeyo nʼayombekayo ekyoto, era nʼawa ekifo ekyo eriina Ero Bbeseri, olwʼokubba eeyo oKibbumba giyabonekeire oYaakobbo, oweyairukiire omugandawe. ");
INSERT INTO gwr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Awo oDebola eyalerere oLabbeeka nʼafa, ni bamuliika e maserengeta wʼekibuga oBbeseri, ansi wʼomuvule. Era omuvule ogwo ni baguwa eriina Alooni Bbakusi. ");
INSERT INTO gwr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","OYaakobbo oweyazwire omu Padanalaamu, oKibbumba nʼamubonekera tete ngʼali e Bbeseri. Era oKibbumba nʼamuwa enkabi, ");
INSERT INTO gwr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ngʼamukoba ati, “Nenca obbaire niiwe oYaakobbo. Neye okuzwa olwatyanu tibakaali bakweta batyo. Okuzwa olwatyanu niiwe oIsirairi.” Kale oKibbumba nʼamuwa eriina ati, Isirairi. ");
INSERT INTO gwr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Era oKibbumba ni yeeyongera okukoba oYaakobbo ati, “Ninze oKibbumba oWabwezye Bwonabwona. Obbe kibyali era osune eibyaire linene. Walizwamu eigwanga linene kaisi era nga tirimo lyonkani neye mawanga amangi. Era walibba zeiza wʼabakabaka. ");
INSERT INTO gwr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Era nkuwaire eitakali erinawaire oIbbulaimu nʼoIsaka, era naliriwa nʼabaizukulubo abaliirawo.” ");
INSERT INTO gwr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Awo oKibbumba nʼazwawo nʼaleka aawo oYaakobbo egiyatumuliire naye. ");
INSERT INTO gwr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Era oYaakobbo nʼakomawo eibbaale ngʼekiijukizo omu kifo oKibbumba omu yatumuliire naye. Yasukire okwibbaale eryo ekyokunywa ekibawaayo, nʼamafuta gʼomuzaituuni okuliwonga eeri oKibbumba. ");
INSERT INTO gwr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kale oYaakobbo nʼawa ekifo ekyo eriina ati, Bbeseri. ");
INSERT INTO gwr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Awo oYaakobbo nʼabʼomu kisitokye ni basimbuka okuzwa e Bbeseri. Babbaire bakaali balikuuwo nʼolugendo okutuuka Efulaasi, ebiseera ebya Laakeeri ebyʼokubyala ni bituuka, era nʼalumwa ino. ");
INSERT INTO gwr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Awo obulumi owebwabitiriire eino, nʼabyala omwana era omubyalisya nʼamukoba ati, “Laakeeri ogume, onu yena ogwobyaire mwisuka.” ");
INSERT INTO gwr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Neye oLaakeeri gabbaire gamuwoire. Era oweyabbaire afa, nʼawa omwana eriina ati, Bbenoni. Neye oiteeye wʼomwana nʼamuwa eriina ati, Bbenyamini. ");
INSERT INTO gwr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Awo oLaakeeri oweyafiire, ni bamuliika okumpi nʼenzira eyaba Efulaasi, okuti egibeeta bati, Bbeserekeemu. ");
INSERT INTO gwr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Era oYaakobbo nʼakoma eibbaale oku magombege era paka lwatyanu liraga ekifo amagombe ga Laakeeri egigali. ");
INSERT INTO gwr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Awo oYaakobbo ni yeeyongerayo omu lugendolwe, nʼayaba nʼakomeka eweemaye ngʼabitireku oku kifo ekibeeta Migidala Ederi. ");
INSERT INTO gwr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Awo oYaakobbo oweyabbaire ngʼakaali ali omu kifo ekyo, oLubbeeni omutaane omukulu ni yeegaita nʼoBbirika omuka iteeye, era oYaakobbo nʼakitegeera. OYaakobbo yabbaire nʼabataane ikumi na babiri. ");
INSERT INTO gwr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Abeyabyaire nʼoLeeya niibo banu: OLubbeeni omwana omubere owa Yaakobbo, nʼoSimyoni, nʼoLeevi, nʼoYuda, nʼoIsakaali, nʼoZebbulooni. ");
INSERT INTO gwr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ibo abeyabyaire nʼoLaakeeri niibo banu: OYusufu nʼoBbenyamini. ");
INSERT INTO gwr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Nʼabeyabyaire nʼoBbirika omugalama wa Laakeeri niibo banu: ODaani nʼoNafutaali. ");
INSERT INTO gwr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Kaisi abeyabyaire nʼoZirupa omugalama wa Leeya niibo banu: OGaadi nʼAseri. Abo niibo abataane ba Yaakobbo abeyabyaire ngʼali omu Padanalaamu. ");
INSERT INTO gwr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Awo oYaakobbo nʼakanga egiri oiteeye oIsaka e Mamule okumpi nʼekibuga Kiriyaasi Alubba, nga niikyo oKebbulooni. Eeyo niiyo oIbbulaimu nʼoIsaka e gibaabbanga. ");
INSERT INTO gwr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","OIsaka yawangaire emyanka 180 ");
INSERT INTO gwr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","era nʼafa, atyo nʼabba yeeyimbirye oku bazeizabe nga mukaire ino. Era abaanabe Esawu nʼoYaakobbo ni bamuliika. ");
INSERT INTO gwr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Linu niiryo eibyaire lyʼEsawu, eriinalye erindi bati, Edomu. ");
INSERT INTO gwr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esawu yafumbiirwe abakali bʼomu kyalo kyʼe Kanani. Asooka yabbaire Ada omwala wʼEroni oMukiiti. Owokubiri yabbaire Okolibbama omwala wʼAna era omwizukulu wa Zibbiyoni oMukiivi. ");
INSERT INTO gwr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Kaisi owokusatu nʼabba Bbasemasi omwala wa Isimairi era omwonyoko wa Nebbayoosi. ");
INSERT INTO gwr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada nʼabyala nʼEsawu omwisuka ogubeeta Erifaazi, kaisi oBbasemasi nʼabyala nʼEsawu omwisuka ogubeeta oLeweri. ");
INSERT INTO gwr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Iye Okolibbama nʼabyala nʼEsawu abaisuka basatu, oYeewusi, nʼoYalamu, nʼoKoola. Esawu yabyaire abaana abo bonabona ngʼali mu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Awo Esawu nʼakwata abakalibe nʼabaanabe abaala nʼabaisuka, nʼabantu bonabona abʼomu kisitokye, nʼebisolobye byonabyona, nʼebintubye byonabyona ebiyasuniire omu kyalo kyʼe Kanani, nʼayaba omu kyalo kyʼe yala okuzwa egiri omugandawe oYaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Yazwireyo olwʼokubba ekyalo omu babbaire batyaime, kyabbaire nga tikibamala iye nʼomugandawe olwʼokubba babbaire nʼebisolo bingi. ");
INSERT INTO gwr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kale Esawu ogubeeta Edomu nʼatyama omu kyalo ekyʼensozisozi ekibeeta Seiri. ");
INSERT INTO gwr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Linu niiryo eibyaire lyʼEsawu eyabbaire ozeiza wʼaBeedomu ababbaire abatyami bʼomu kyalo ekyʼensozisozi ekya Seiri: ");
INSERT INTO gwr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Era ganu niigo amaliina gʼabataane bʼEsawu: Erifaazi oguyabyaire nʼomukaliwe Ada, nʼoLeweri oguyabyaire nʼomukaliwe oBbasemasi. ");
INSERT INTO gwr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Abataane bʼErifaazi niibo banu: OTemani, nʼOmali, nʼoZeefo, nʼoGatamu nʼoKenazi. ");
INSERT INTO gwr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Erifaazi omutaane wʼEsawu yabbaire nʼomukali ogondi eriinalye, Timuna oguyabyaire naye omwana ogubeeta Amereki. Abo babbaire baizukulu bʼAda omuka Esawu. ");
INSERT INTO gwr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Banu niibo abataane ba Leweri omutaane wʼEsawu: ONakasi, nʼoZeera, nʼoSama nʼoMiiza. Era abo babbaire baizukulu ba Bbasemasi omuka Esawu. ");
INSERT INTO gwr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Era banu niibo abaana Esawu abeyabyaire nʼomukaliwe ogubeeta Okolibbama omwala wʼAna era omwizukulu wa Zibbiyoni: OYeewusi, nʼoYalamu, nʼoKoola. ");
INSERT INTO gwr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ganu niigo amaliina gʼabaana bʼEsawu abasuukire abeekubbemberi bʼebika byabwe: Abataane bʼErifaazi omwana omubere owʼEsawu niibo abazwiremu ebika binu: ABatemani, nʼaBomali nʼaBazeefo, nʼaBakenazi, ");
INSERT INTO gwr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","nʼaBagatamu, nʼaBamereki. Ebyo niibyo ebika ebyazwire omwibyaire lyʼErifaazi ngʼali omu kyalo kyʼe Edomu. Era abantu abʼebika ebyo babbaire baizukulu bʼAda. ");
INSERT INTO gwr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ibo abataane ba Leweri omutaane wʼEsawu niibo abazwiremu ebika binu: ABanakasi, nʼaBazeera, nʼaBasama, nʼaBamiiza. Ebyo niibyo ebika ebyazwire omwibyaire lya Leweri ngʼali omu kyalo kyʼEdomu. Era abantu bʼebika ebyo babbaire baizukulu ba Bbasemasi omuka Esawu. ");
INSERT INTO gwr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Kaisi abaana Esawu ebeyabyaire nʼomukaliwe Okolibbama niibo abazwiremu ebika binu: ABayeewusi, nʼaBayalamu era nʼaBakoola. Ebyo niibyo ebika ebyazwire omwibyaire lyʼomuka Esawu ogubeeta Okolibbama omwala wʼAna. ");
INSERT INTO gwr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ebika ebyo niibyo ebyazwire omwibyaire lyʼEsawu ogubeeta Edomu. ");
INSERT INTO gwr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","OSeiri yabbaire wʼeigwanga lyʼaBakooli abasookere okubba abatyami bʼomu kyalo kyʼEdomu. Omu kiseera ekyo Esawu yabbaire akaali okwaba okutyamayo. Era ebika ebyazwire omwibyaire lya Seiri niibyo binu: Ekika ekyʼaBalotani, nʼaBasobbali, nʼaBazibbiyoni nʼaBaana, ");
INSERT INTO gwr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","nʼaBadisoni, nʼaBezeri, nʼaBadisani. Ebyo niibyo ebika byʼaBakooli era niibo abaizukulu ba Seiri, abatyami bʼomu kyalo kyʼEdomu. ");
INSERT INTO gwr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Abataane ba Lotani babbaire niibo banu: OKooli nʼoKamani. Omwonyoko wa Lotani yabbaire niiye oTimuna. ");
INSERT INTO gwr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ibo abataane ba Sobbali niibo banu: Aluvaani, nʼoManakaasi nʼEbbali, nʼoSeefo nʼOnamu. ");
INSERT INTO gwr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Era abataane ba Zibbiyoni niibo banu: Aiya nʼAna. Ana oyo niiye eyavumbwire amaluba gʼamaizi agooca omwidungu, oweyabbaire ngʼaliisya empunda gya Zibbiyoni oiteeye. ");
INSERT INTO gwr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Abaana bʼAna babbaire niibo banu: ODisoni nʼomwala ogubeeta Okolibbama. ");
INSERT INTO gwr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ibo abataane ba Disoni niibo banu: OKemudaani, nʼEsubbaani, nʼoIsulaani era nʼoKerani. ");
INSERT INTO gwr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ibo abataane bʼEzeri babbaire niibo banu: OBbirikaani, nʼoZaavani, era nʼAkani. ");
INSERT INTO gwr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Kaisi abataane ba Disani niibo banu: OWuzi nʼAlani. ");
INSERT INTO gwr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Banu niibo abakulu bʼebika ebyazwire omu Bakooli: OLotani, nʼoSobbali, nʼoZibbiyoni, nʼAna, ");
INSERT INTO gwr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","nʼoDisoni, nʼEzeri, nʼoDisani. Abo niibo abakulu bʼebika ebyazwire omu Bakooli era ngʼebika byabwe byabbaire mu kyalo kyʼe Seiri. ");
INSERT INTO gwr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nga wakaali kubbaawo kabaka yenayena afuga aBaisirairi, banu niibo abakabaka abafugire ekyalo kyʼEdomu: ");
INSERT INTO gwr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","OBbera omutaane wa Bbeyoli nʼafuga ekyalo kyʼEdomu, era ekibuga omu yabbaire nga bakyeta Dinukabba. ");
INSERT INTO gwr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","OBbera oweyafiire, oYobbabbu omutaane wa Zeera owʼe Bbozira nʼamusikira ngʼokabaka. ");
INSERT INTO gwr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Era oYobbabbu oweyafiire, oKusamu owʼomu kyalo kyʼaBatemani nʼamusikira ngʼokabaka. ");
INSERT INTO gwr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kaisi oKusamu oweyafiire, oKadadi omutaane wa Bbedadi nʼamusikira ngʼokabaka. OBbedadi niiye eyalwaine nʼaBamidiyaani omu kyalo kyʼe Mowaabbu, nʼabawangula. Era ekitebe ekikulu ekyʼobwakabaka bwa Kadadi kyabbaire mu kibuga ekibeeta Avisi. ");
INSERT INTO gwr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","OKadadi oweyafiire, oSamula owʼomu kibuga kyʼe Masuleeka nʼamusikira ngʼokabaka. ");
INSERT INTO gwr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Era oSamula oweyafiire, oSyawulo owʼomu kibuga kyʼe Lekobbosi ekiri okumpi nʼomwiga Ewufulaate nʼamusikira ngʼokabaka. ");
INSERT INTO gwr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Iye oSyawulo oweyafiire, oBbaali Kanani omutaane wʼAkubbooli nʼamusikira ngʼokabaka. ");
INSERT INTO gwr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kaisi oBbaali Kanani omutaane wʼAkubbooli oweyafiire, oKadali nʼamusikira ngʼokabaka. Era ekibuga oKadali omu yabbaire nga bakyeta Pawu. Omukaliwe yabbaire niiye oMeketabberi omwala wa Mantirida, era oMantirida yabbaire mwala wa Mezakaabbu. ");
INSERT INTO gwr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ganu niigo amaliina gʼabakulu bʼebika ebyazwire omwibyaire lyʼEsawu, era nʼebika byabwe egibyabbaire bityaime: OTimuna, nʼAluva, nʼoYesesi, ");
INSERT INTO gwr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","nʼOkolibbama, nʼEra, nʼoPinoni. ");
INSERT INTO gwr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Era nʼoKenazi, nʼoTemani, nʼoMibbuzaali. ");
INSERT INTO gwr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Era nʼoMagadiyeri, nʼoIramu. Abo niibo abakulu bʼebika ebyazwire omwibyaire lyʼEsawu era nga niiye ogubeeta bati, Edomu ozeiza wʼaBeedomu. Era ebika ebyo byatwalanga maliina gʼebitundu omu byatyamanga. ");
INSERT INTO gwr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Atyanu oYaakobbo nʼatyama omu kyalo kyʼe Kanani, oiteeye e giyatyamanga. ");
INSERT INTO gwr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Era binu niibyo ebikwata oku Yaakobbo nʼeibyairerye: OYusufu oweyabbaire nga mwisuka wʼemyanka ikumi na musanvu, yaliisyanga nʼabagandabe entaama nʼembuli egya itewaabwe. Era abagandabe abo babbaire baana ba Bbirika nʼoZirupa. Ibo abo babbaire bakali abandi abaiteeye wa Yusufu. OYusufu nʼaloopanga abagandabe egiri oiteeye ebikole ebibbibibbi abagandabe abo ebibakolanga. ");
INSERT INTO gwr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Atyanu oYaakobbo yatakanga oYusufu okukiraku abaanabe abandi bonabona, olwʼokubba yamubyaire ngʼakayiriire. Era nʼamutungira ekizwalo ekyʼenjawulo. ");
INSERT INTO gwr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Abaganda ba Yusufu owebategeire bati oitewaabwe amutaka okukiraku owabataka ibo, ni bacaawa oYusufu, era nga tibamusugirya omu mwoyo omusa. ");
INSERT INTO gwr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Lwabbaire lumo oYusufu nʼaloota ekirooto. Neye oweyakikobeire abagandabe, ni beeyongera okumucaawa. ");
INSERT INTO gwr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Bamucaawire olwʼokubba yabakobere ati, “Muwulire ekirooto ekinalootere. ");
INSERT INTO gwr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Atyanu twabbaire tusiba ebinywa byʼengaano omu musiri, ekinywa ekyange ni kisetuka, ni kyemerera. Kaisi ebinywa ebyanywe ni biiza ni bikyeruguulirirya, era ni bikotama eeri ekinywa ekyange.” ");
INSERT INTO gwr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Awo abagandabe ni bamukoba bati, “Olwo-so oseega oti walisuuka kabaka waiswe, ooba oti iwe dala walitufuga?” Kale ni beeyongera okumucaawira nakimo olwʼebirootobye, nʼebibonobye. ");
INSERT INTO gwr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Oluzwanyuma oYusufu nʼaloota ekirooto ekindi, nʼakikobera abagandabe ati, “Muwulisisye, nalootere ekirooto ekindi, ngʼeisana, nʼomweri, nʼenkota ikumi na moiza bikotama egiri nze.” ");
INSERT INTO gwr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Nʼakikobera nʼoiteeye, neye oiteeye nʼamukaabukira ati, “Kirootoki ekyo ekiwalootere? Oseega oti nze nʼomaawo nʼabagandabo, dala twaliiza ni tukotama egyoli okukuwa ekitiisya?” ");
INSERT INTO gwr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Awo abaganda ba Yusufu ni bamukwatira engongi, neye oiteeye ni yeeyongera okubba ngʼaseega kwebyo oYusufu ebiyatumwire. ");
INSERT INTO gwr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Lumo abaganda ba Yusufu baabire okumpi nʼekibuga kyʼe Sekemu okuliisya entaama nʼembuli gya Yaakobbo oitewaabwe. ");
INSERT INTO gwr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","OYaakobbo nʼakoba oYusufu ati, “Abagandabo bali okumpi nʼekibuga kyʼe Sekemu, era gibali kuliisirya entaama nʼembuli. Kale oize nkutume egibali.” OYusufu nʼamwiramu ati, “Kale Sebo.” ");
INSERT INTO gwr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Awo oiteeye nʼamukoba ati, “Atyanu oyabe obone embeera abagandabo egibalimu, nʼentaama nʼembuli, kaisi oire onkobere.” Kale nʼamutuma okuzwa egibabbaire batyama omu kiinamo kyʼe Kebbulooni. OYusufu oweyatuukire e Sekemu, ");
INSERT INTO gwr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","omusaiza nʼamubona ngʼatambulatambula omu kigona, nʼamubuulya ati, “Onoonia niki?” ");
INSERT INTO gwr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","OYusufu nʼamwiramu ati, “Nnoonia baganda bange abali kuliisya entaama nʼembuli. Oyezya okundagiriraku egibali kuliisirya.” ");
INSERT INTO gwr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Awo omusaiza nago nʼamwiramu ati, “Bazwire aanu, neye mbawuliire nga bakoba bati baaba Dosani.” Kale oYusufu nʼasenjaaku abagandabe, era nʼabaajirya mu Dosani. ");
INSERT INTO gwr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Abaganda ba Yusufu ni bamulengera ngʼakaali ali yala, era oweyabbaire ngʼakaali okubatuukaku, ni bateesa okumwita. ");
INSERT INTO gwr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ni bakobangana bati, “Omulooti omukulu ngoyo aiza. ");
INSERT INTO gwr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kale oleke tumwite era tumudyake omu kimo oku biina binu. Era twakobera obbaabba tuti, ‘Okisolo owʼomu kigona niiye eyamuliire,’ kaisi tubone obanga ebirootobye byalituukirira.” ");
INSERT INTO gwr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Neye oLubbeeni oweyawuliire ekyo, ni yeefaaku okulamya oYusufu ngʼakoba ati, “Titwamwita.” ");
INSERT INTO gwr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","OLubbeeni era nʼabakoba ati, “Timwasuka omusaaye. Mumumume mu kiina kinu ekiri aanu omwidungu, era timwamukolaku akabbikabbi.” Yakobere atyo nga yeefaaku alamye oYusufu, era amukanje egiri oiteeye. ");
INSERT INTO gwr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Kale oYusufu oweyatuukire oku bagandabe, bamutoiremu ekizwalokye ekyʼenjawulo ekiyabbaire azwaire. ");
INSERT INTO gwr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Era ni bamukwata, ni bamumuma omu kiina ekyabbaire ekikalu nga mpaamu maizi. ");
INSERT INTO gwr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Awo owebabbaire balya, ni basiirya amaiso, ni balengera ekibinja kyʼabasuubuuzi aBaisimairi nga bazwa omu Gireyaadi, nga bali nʼengamira egyetiikire ebyakaloosa nʼebyobuboobo ebibeeta bbaamu nʼomiira, nga babitwala e Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Awo oYuda nʼakoba abagandabe ati, “Kyatugasa niki okwita omuganda waiswe kaisi ni tubisabisa okufaakwe? ");
INSERT INTO gwr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Wazira oleke tumugulye abasuubuuzi aBaisimairi, era iswe titwamukolaku akabbikabbi olwʼokubba muganda waiswe, era musaaye gwaiswe.” Kale abaganda ba Yuda ni baikirirya ekiyabakobere. ");
INSERT INTO gwr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Era abasuubuuzi abazwire e Midiyaani owebabbaire babitawo, abaganda ba Yusufu ni bakuusa oYusufu omu kiina, ni bamugulya abasuubuuzi aBaisimairi oku sekeri gyʼefeeza aabiri. Era abasuubuuzi aBaisimairi ni batwala oYusufu omu Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Oluzwanyuma oLubbeeni oweyakangire oku kiina okuzwa egiyabbaire, nʼayagirya ngʼoYusufu abulamu, era olwʼokunakuwala nʼanyiira ebizwalobye. ");
INSERT INTO gwr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nʼakangayo egiri abagandabe, nʼabakoba ati, “Omwisuka abulayo. Atyanu nze nakola ntya?” ");
INSERT INTO gwr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Awo ni baita ombuli, ni bainika ekizwalo kya Yusufu omu musaaye ogwo ogwa mbuli. ");
INSERT INTO gwr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ni batwala eganduula nago eyʼenjawulo egiri oitewaabwe, ni bamukoba bati, “Tuzwire ekizwalo kinu. Atyanu obone obanga niikyo ekizwalo ekyʼomwanawo ooba bbe.” ");
INSERT INTO gwr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","OYaakobbo nʼagimanyica, nʼakoba ati, “Niikyo ekizwalo kyʼomwana wange. Okisolo wʼomu kigona ateekwa okubba amuliire. Era mazima dala oYusufu, okisolo amunyiiranyiiriremu!” ");
INSERT INTO gwr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kale oYaakobbo olwʼokunakuwala nʼanyiira ebizwalobye, ni yeesiba ebibenga, era nʼamala enaku nyingi ngʼakunga omwanawe. ");
INSERT INTO gwr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Awo abataanebe bonabona nʼabaalabe ni baiza okumugumya, neye iye nʼagaana, era nʼakoba ati, “Bbe, nasigala nga nkaali nkunga paka owenalifa ni njaba e magombe egiri omwana wange.” Kale ni yeeyongera okukunga omwanawe oYusufu. ");
INSERT INTO gwr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Omu kiseera ekinyere ekyo, abasuubuuzi badi abazwire e Midiyaani babbaire batuukire omu Misiri era nga batundire oYusufu. OPotifaali omoiza oku bakungu ba Falaawo niiye eyabbaire amugulire. OPotifaali yabbaire niiye omukulu wʼabaisirikale abakuuma olubiri lwa Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Atyanu omu biseera ebyo, oYuda yazwire eeri abagandabe, nʼayaba omu kibuga kyʼAdulaamu era eeyo nʼabba mutyami okumpi nʼomusaiza oMwadulaamu, eriinalye bati Kira. ");
INSERT INTO gwr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Era eeyo, oYuda nʼasunayo omwala wa musaiza ogubeeta bati Suuwa oMukanani. OYuda nʼafumbirwa omwala oyo, era oweyeegaitire naye, ");
INSERT INTO gwr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","omwala nʼabba kida nʼabyala omwana mwisuka, oYuda nʼamuwa eriina ati, Eri. ");
INSERT INTO gwr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nʼabba kida tete, nʼabyala omwana mwisuka, nʼamuwa eriina ati, Onani. ");
INSERT INTO gwr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Era tete nʼabyala omwana mwisuka, nʼamuwa eriina ati, Seera. Era omu kiseera ekyo owebabyaliire omwana oyo babbaire Kezibbu. ");
INSERT INTO gwr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Oluzwanyuma nga wabitirewo ekiseera, oYuda nʼakwera Eri omwanawe omubere, omukali eriinalye Tamali. ");
INSERT INTO gwr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Neye Eri, omwana wa Yuda omubere, yabbaire akola ebikole ebibbibibbi era ekyo nga tikisangaalya oMusengwa, kale oMusengwa nʼamwita. ");
INSERT INTO gwr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Awo oYuda nʼakoba Onani ati, “Osike omuka mugandawo, era otuukirirye obuvunaanyizibwabwo nga iwe omwiziwe, kaisi omu ngeri eyo osunire omugandawo abaana.” ");
INSERT INTO gwr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Neye Onani yamaite ati abaana tibalibba babe. Kale oweyeegaitanga nʼonamwandu oyo, amaizi yagasukanga ansi kaisi tiyasunira omugandawe abaana. ");
INSERT INTO gwr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ekiyakolere ni kitasangaalya oMusengwa. Kale nʼoyo yena oMusengwa nʼamwita. ");
INSERT INTO gwr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Awo oYuda nʼakoba oTamali omulyawe ati, “Okange omu kisito kya iteewo era osigale ngʼoli namwandu, paka omwana wange oSeera oweyakula nʼabba ngʼatuukire okukusika.” Yakobere atyo, olwʼokubba yatiire ati nʼoyo yena ayinza okufa ngʼabagandabe. Kale oTamali nʼayaba nʼatyama omu kisito kya iteeye. ");
INSERT INTO gwr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Oluzwanyuma lwʼekiseera ekiwanvu, omuka Yuda, omwala wa Suuwa nʼafa. Ebiseera ebyʼokukunga owebyawoireku, oYuda nʼayaba e Timuna eeri abasaiza ababbaire bali kusalaku entaamagye ebyoya. Eeyo yaabire nʼomukaagwawe oKira oMwadulaamu. ");
INSERT INTO gwr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Atyanu omuntu oweyakobeire oTamali ati, “Oisibyalawo ayaba e Timuna okusalaku entaamagye ebyoya.” ");
INSERT INTO gwr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","OTamali yabbaire akimaite ati oSeera yakulire neye ni batamumuwa okumusika. Kale ni yeeyambulyamu ebizwalo ebyʼobwanamwandu nʼazwala ebindi. Era ni yeebbuulisya ekitambaala oku mutwe nʼomumaiso abantu okutamumanyica. Awo nʼayaba nʼatyama oku mulyango gwʼekikomera kyʼEnaimu, ekibuga ekiri oku nzira eyaba e Timuna. ");
INSERT INTO gwr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Awo oYuda oweyaboine oTamali, nʼaseega ati malaaya, olwʼokubba yabbaire yeebiikire omumaiso. ");
INSERT INTO gwr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kale oYuda nʼayaba e gyali oku mbale kwʼenzira, nʼamukoba ati, “Oize ntaka kwegaita na iwe,” nga tamumanyica ati mulyawe. OTamali nʼamubuulya ati, “Wampa niki kaisi weegaite na nze?” ");
INSERT INTO gwr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","OYuda nʼamwiramu ati, “Nakuweererya ombuli omutomuto okuzwa omu kiraalo kyange.” OTamali nʼamubuulya ati, “Wampa musingoki kaisi nkakase nti wampeererya ombuli?” ");
INSERT INTO gwr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","OYuda yena nʼamubuulya ati, “Musingoki ogumbe nkuwe?” OTamali nʼamwiramu ati, “Empeta eriku eriinalyo nʼakasibiro kaaku, nʼomukoomero ogwokwaite.” Kale oYuda nʼabimuwa, ni yeegaita naye era nʼamuwa ekida. ");
INSERT INTO gwr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Awo oTamali nʼakanga e waabwe, ni yeetoolaku ekitambaala oku mutwe, nʼazwala tete ebizwalobye ebyʼobwanamwandu. ");
INSERT INTO gwr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Oluzwanyuma oYuda nʼatuma omukaagwawe oKira oMwadulaamu okutwalira oTamali ombuli omutomuto, era atooleyo omusingo, neye oKira nandi nʼamubona. ");
INSERT INTO gwr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kale oKira nʼabuulya abamo oku basaiza abʼEnaimu ati, “Omukali omalaaya eyabbaire atyaime aanu oku nzira, ali yaina?” Ni bairamu bati, “Aanu tiwabbangakuuwo mukali omalaaya.” ");
INSERT INTO gwr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kale oKira nʼakanga egiri oYuda, nʼamukoba ati, “Timmuboine. Era abasaiza abʼEnaimu bakobere bati, ‘Aanu tiwabbangakuuwo mukali omalaaya.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Awo oYuda nʼamukoba ati, “Oleke asigaze ebintu ebyo, abantu tibatusekerera, kasita namuweereirye ombuli oyo omutomuto, neye iwe nandi nʼomubona.” ");
INSERT INTO gwr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Owewabitirewo emyeri ngʼemisatu, ni bakobera oYuda bati, “OTamali omulyawo, yakolere obwamalaaya, era atyanu ali kida.” Awo oYuda nʼalagira ati, “Mumuwuluce omu kibuga era mumwoce.” ");
INSERT INTO gwr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Owebabbaire bamubuluca, nʼasindikira oisibyalawe obukwenda bunu obuti, “Omusaiza onanyere ebintu binu, niiye eyampaire ekida. Nkwegairiire, weetegereze empeta eriku akasibiro nʼomukoomero, binu byani?” ");
INSERT INTO gwr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","OYuda oweyaboine ebintu nago nʼabitegeera, nʼakoba ati, “Omukali oyo ankirireku, niiye omutuuce olwʼokubba tinamuwaire oSeera omutaane wange okumusika.” Era oYuda nandi nʼairayo okwegaita naye omulundi ogundi. ");
INSERT INTO gwr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Atyanu ekiseera kya Tamali ekyʼokubyala owekyatuukire, ni kimanyikana ngʼayaba kubyala balongo. ");
INSERT INTO gwr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Oweyabbaire ngʼalumwa okubyala, omoiza oku baana nʼawulucaaku engaloye. Kale omubyalisya nʼagikwata, nʼagisibaku ewuuzi entukuliki ngʼakoba ati, “Onu niiye asookere okuwuluka.” ");
INSERT INTO gwr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Neye omwana oweyakanjiryeyo engaloye, omugandawe nʼawuluka omu kida. Omubyalisya nʼakoba ati, “Ee, otyo bwʼoyazirye nʼowuluka!” Kale ni bamuwa eriina bati, Pereezi. ");
INSERT INTO gwr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Oluzwanyuma omugandawe eyabbaireku ewuuzi entukuliki oku ngalo nʼawuluka, era ni bamuwa eriina bati, Zeera. ");
INSERT INTO gwr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Atyanu oluzwanyuma lwʼokutunda oYusufu, aBaisimairi abamugulire bamuserengeterye ni bamutwala e Misiri. Eeyo eyamugulire yabbaire Mumisiri ogubabbaire beeta bati, Potifaali, eyabbaire omoiza oku bakungu ba Falaawo. OPotifaali yabbaire niiye omukulu wʼabaisirikale abakuuma olubiri. ");
INSERT INTO gwr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","OMusengwa nʼabba aamo nʼoYusufu, nʼabba wʼenkabi omu bintu byonabyona ebiyakolanga. Era yaabbanga mu kisito kya musengwawe oPotifaali oMumisiri. ");
INSERT INTO gwr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Atyanu omusengwawe oyo nʼategeera ati oMusengwa ali aamo nʼoYusufu era amuwa enkabi mu buli kyakola. ");
INSERT INTO gwr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Omusengwawe oyo nʼamusiima, kale nʼamusuuca muweereryawe owʼenjawulo, nʼamuwa obuvunaanyizibwa okulabiriranga ekisitokye, nʼokukuumanga ebintubye byonabyona. ");
INSERT INTO gwr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Era okuzwa kwolwo, ekisito kyʼoMumisiri oyo, nʼebintubye byonabyona ebiyabbaire nabyo omu kisitokye, nʼomu misirigye, oMusengwa nʼabiwa enkabi oku lwa Yusufu. ");
INSERT INTO gwr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kale oPotifaali nʼakwatisya oYusufu ebintubye byonabyona okubirabiriranga, nga takaali yeeraliikirira olwʼekintukye kadi kimo, okutoolaku ekyokulya ekiyalyanga. Atyanu oYusufu yabbaire aboneka kusani nga muŋoono, era amaisoge nga gasangaalya. ");
INSERT INTO gwr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Era owewabitirewo ekiseera, omuka musengwawe nʼamwegomba. Kale lwabbaire lumo nʼamukoba ati, “Oize weegaite na nze.” ");
INSERT INTO gwr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Neye oYusufu nʼagaana, nʼakoba omuka musengwawe ati, “Owulisisye, omusengwa wange yankwatisirye ebintubye byonabyona okubirabirira, era takaali yeeraliikirira olwʼekintukye kadi kimo aanu omu kisitokye olwʼokubba nze ndiwo. ");
INSERT INTO gwr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mpaawo ankiraku obwezye omu kisito kinu. Era mpaawo kintu omusengwa wange ekinandi nʼankwatisya okutoolaku iwe, olwʼokubba oli mukaliwe. Nʼolwekyo, timpezya okukola ekikole ekibbikibbi ekyenkanaawo, ni nsobya omumaiso ga Kibbumba.” ");
INSERT INTO gwr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Newankubbaire ngʼomukali oyo yeeyongeire okukoba oYusufu nabuli lunaku okwegaita naye, oYusufu yagaine waire okumwerirania. ");
INSERT INTO gwr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Neye lwabbaire lumo, oYusufu nʼaingira omu nyumba ya musengwawe okukola emirimogye, era timwabbairemu abaweererya abandi. ");
INSERT INTO gwr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Awo omuka Potifaali nʼamukwata ekizwalo ngʼamukoba ati, “Oize weegaite na nze.” Neye oYusufu nʼamwetaisulya nʼamulekera ekizwalokye omu ngalo, era nʼavulumuka nʼawuluka e nza. ");
INSERT INTO gwr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Omukali nago oweyaboine ngʼoYusufu avulumukire amulekeire ekizwalokye airukire e nza, ");
INSERT INTO gwr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","nʼayeta abaweererya abandi abʼomu kisitokye, nʼabakoba ati, “Mubone, oMwebbulaniya oibawange oguyaleetere aanu ali kutujooga. Aingiire omu kisenge e gimbaire, nʼataka ankwate okalijata, neye ni nkubba enduulu. ");
INSERT INTO gwr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Era owenkubbire enduulu alekere aanu ekizwalokye, nʼavulumuka nʼairuka e nza.” ");
INSERT INTO gwr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kale omukali nago nʼabisa ekizwalo kya Yusufu paka omusengwa wa Yusufu oweyakangire e ika. ");
INSERT INTO gwr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Era nʼamukobera ati, “Omugalama oMwebbulaniya oguwaleetere aanu, aingiire omu kisenge e gimbaire ngʼataka okunkwata okalijata. ");
INSERT INTO gwr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Neye owenkubbire enduulu, alekere aanu ekizwalokye era nʼavulumuka nʼairuka e nza.” ");
INSERT INTO gwr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Awo omusengwa wa Yusufu oweyawuliire ngʼomukaliwe amukobera engeri oYusufu egyamubitiryemu, nʼasunguwala ino. ");
INSERT INTO gwr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kale nʼalagira ni bakwata oYusufu, ni bamwigalira omu mabbuusu e gibakuumiranga abasibe ba kabaka. Neye oYusufu oweyabbaire omu mabbuusu eeyo, ");
INSERT INTO gwr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","oMusengwa nʼabba aamo naye, nʼamukwatira ekisa, era nʼamwezyesya okubba mukoda eeri omukulu wʼamabbuusu. ");
INSERT INTO gwr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Nʼolwekyo omukulu wʼamabbuusu, nʼakwatisya oYusufu abasibe bonabona ababbaire omu mabbuusu omwo okubalabiriranga. Yamukwatisirye nʼobuvunaanyizibwa ku buli kintu ekibabbaire bakola omu mabbuusu omwo. ");
INSERT INTO gwr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Omukulu wʼamabbuusu tiyeeraliikiriranga olwʼekintu kadi kimo ekiyakwatisirye oYusufu. Ekyo kityo olwʼokubba oMusengwa yabbaire aamo nʼoYusufu, nʼamuwanga enkabi mu buli kimo ekiyakolanga. ");
INSERT INTO gwr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Oluzwanyuma nga wabitirewo ekiseera, omukungu wa oFalaawo eyamuwanga ebyokunywa, nʼomukulu wʼabasumbi ba Falaawo ni basobya eeri omusengwa waabwe oyo. ");
INSERT INTO gwr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Era oFalaawo nʼasunguwalira ino abakungube abo bombi. ");
INSERT INTO gwr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kale nʼalagira ni babaigalira omu mabbuusu, omu kisito kyʼomukulu wʼabaisirikale abakuumi bʼolubiri. Era omu mabbuusu omunyere omwo mu babbaire baigaliire oYusufu. ");
INSERT INTO gwr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bamalire omu mabbuusu ekiseera kiwanvu, era omukulu wʼabaisirikale abakuuma olubiri nʼalonda oYusufu okubba muweererya wa bakungu abo. ");
INSERT INTO gwr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Lwabbaire lumo omu kiire, omukungu wa Falaawo eyamuwanga ebyokunywa, nʼomukulu wʼabasumbi ba Falaawo, nabuli moiza nʼaloota ekirooto nga nabuli kimo kiri nʼamakulu gʼenjawulo. ");
INSERT INTO gwr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Eizo amakeezi oYusufu oweyaabire egibabbaire, yaboine nga beeraliikiriire. ");
INSERT INTO gwr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Awo nʼababuulya ati, “Niki ekibeeraliikiriirye mutyo olwatyanu?” ");
INSERT INTO gwr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ni bamwiramu bati, “Nabuli moiza kwiswe yalootere ekirooto, neye aanu mpaawo muntu eyatuvuunulira amakulu gʼebirooto ebyo.” Awo oYusufu nʼabakoba ati, “OKibbumba yenkani niiye ayezesya abantu okuvuunula ebirooto. Kale munkobere ebimwalootere.” ");
INSERT INTO gwr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Awo omukungu wa Falaawo eyamuwanga ebyokunywa nʼakobera oYusufu ati, “Omu kirooto kyange, naboine omuzabbibbu nga guli omumaiso gange, ");
INSERT INTO gwr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","nga guliku amasaga masatu. Era owegwasebukire, amangu ago ni gusasika, ni guneneka emizabbibbu emyengi. ");
INSERT INTO gwr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Era nabbaire nkwaite ekikopo kya Falaawo, kale ni ntoola emizabbibbu, ni ngikamulira omu kikopo kya Falaawo, ni nkimuwa.” ");
INSERT INTO gwr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Awo oYusufu nʼamukoba ati, “Ganu niigo amakulu gaakyo, amasaga amasatu, niigyo enaku eisatu. ");
INSERT INTO gwr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Era omu naku isatu oFalaawo ayaba okukutoola omu mabbuusu, akusoniye. Era yakukanja omu kifookyo ngʼomukunguwe amuwa ebyokunywa. Era wamuwanga ebyokunywa ngʼowewakolanga eira owewabbeereire omukunguwe amuwa ebyokunywa. ");
INSERT INTO gwr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Neye nkwegairiire, byonabyona owebyalikwabira kusani onjebukiryanga. Era nʼonkwatira ekisa nʼokoberaku oFalaawo ebinfaaku, nʼombeera okuzwa omu mabbuusu munu. ");
INSERT INTO gwr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ekyo kityo olwʼokubba bannyagire-bunyagi okuzwa e waiswe omu kyalo kyʼaBeebbulaniya. Era nʼaanu omu Misiri bandibbaire nga tibanjigalira omu mabbuusu, olwʼokubba mpaawo kibbikibbi ekinakolere.” ");
INSERT INTO gwr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Atyanu omukulu wʼabasumbi oweyawuliire ngʼoYusufu avuunuliire omwinaye kusani, nʼakoba oYusufu ati, “Zena nalootere ekirooto, nga neetiikire ebiibo bisatu ebirimu emigaati. ");
INSERT INTO gwr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Era omu kiibo ekyʼe ngulu mwabbairemu emigaati egya buli ngeri, nga gya Falaawo, neye enyonyi nga giri kulyanga emigaati egyo omu kiibo ekyo ekineetiikire.” ");
INSERT INTO gwr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Awo oYusufu nʼairamu ati, “Ganu niigo amakulu gaakyo, ebiibo ebisatu niigyo enaku eisatu. ");
INSERT INTO gwr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Era oFalaawo ayaba okukutoola omu mabbuusu, kaisi alagire abaisirikale bakutemeku omutwe, bakwanike oku musaale, era enyonyi girye omulambogwo.” ");
INSERT INTO gwr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Awo oluzwanyuma lwʼenaku ibiri, oku lwakusatu lwabbaire lunaku lwa kwebukiriryaku olubabyaliireku oFalaawo. Kale oFalaawo nʼategeka embaga era nʼayaniriza abaweereryabe bonabona. Era nʼalagira ni bateera abakungube badi, eyamuwanga ebyokunywa, nʼomukulu wʼabasumbi, ni babatwala omumaiso gʼabaweereryabe. ");
INSERT INTO gwr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","OFalaawo nʼairya eyamuwanga ebyokunywa omu kifookye ekyʼokumuwanga ebyokunywa. Yakolere atyo kaisi omukungu oyo tete yeeyongere okumuwanga ebyokunywa. ");
INSERT INTO gwr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Neye oFalaawo nʼalagira okwita omukulu wʼabasumbi nʼokumwanika oku musaale, ngʼoYusufu oweyabavuunuliire ebirooto. ");
INSERT INTO gwr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Neye ebyo owebyawoire, omukungu eyaawanga oFalaawo ebyokunywa nandi nʼaseega oku Yusufu, era nʼamwerabirira nakimo. ");
INSERT INTO gwr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Awo ngʼemyanka mibiri mirambirira gibitirewo, oFalaawo nʼaloota. Yalootere ngʼayemereire oku mbale kwʼomwiga oKiyira. ");
INSERT INTO gwr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Era omu kirooto nʼabona ente musanvu egiboneka kusani era egyageizere, nga gizwa omu mwiga ogwo, ni gitandiika okulya eisubi. ");
INSERT INTO gwr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Oluzwanyuma nʼabona ente egindi musanvu egiboneka obundi era ennyondi, nga gyona gizwa omu mwiga ogunanyere ogwo. Ni gyemerera oku mbale kwa mwiga nago, okumpi nʼente gidi egyageizere. ");
INSERT INTO gwr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ente egiboneka obundi era ennyondi ni girya gidi egiboneka kusani era egyageizere. Awo oFalaawo nʼasisimuka. ");
INSERT INTO gwr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Era tete nʼagona nʼaloota ekirooto ekindi. Omu kirooto nʼabona ebigala byʼengaano musanvu ebijimu era ebisa, nga bisanswirye biri oku kikolo kimo. ");
INSERT INTO gwr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Era nʼabona ebigala byʼengaano ebindi musanvu, nga bisanswirye, nga bitontono neye nga bibabukire olwʼempewo yʼeibbugumu ezwa omwidungu. ");
INSERT INTO gwr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ebigala byʼengaano ebitontono ni bimira bidi ebijimu era ebisa. Awo oFalaawo nʼasisimuka, nʼategeera ati abbaire aloota. ");
INSERT INTO gwr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Atyanu eizo amakeezi oFalaawo ni yeeraliikirira, kale nʼalagira ni beeta abalaguli bonabona nʼabasaiza bonabona abʼomu Misiri. Nʼabakobera ebirootobye, neye ni watabbaawo kadi moiza ayezya okumuvuunulira amakulu gaabyo. ");
INSERT INTO gwr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Awo eyaawanga oFalaawo ebyokunywa nʼakoba oFalaawo ati, “Sengwa, olwatyanu njebukiirye ensobi eginakolere. ");
INSERT INTO gwr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Enyumaku watusunguwaliire iswe abaweereryabo, nze nʼomusumbi omukulu, nʼotwigalira omu mabbuusu agali omu kisito kyʼomukulu wʼabaisirikale abakuumi bʼolubiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Lwabbaire lumo omu kiire nga tuli omu mabbuusu omwo, nabuli moiza kwiswe ababiri nʼaloota ekirooto, era nga nabuli kimo kiri nʼamakulu gʼenjawulo. ");
INSERT INTO gwr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Atyanu twabbaire omwo nʼomwisuka oMwebbulaniya, era eyabbaire omuweererya wʼomukulu wʼabaisirikale abakuumi bʼolubiri. Ni tumukobera ebirooto byaiswe, nʼatuvuunulira amakulu gaabyo ngʼekirooto kya buli moiza owekyabbaire. ");
INSERT INTO gwr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Era buli kimo ni kituukirira ngʼoweyabituvuunuliire. Ekikoba kiti, nze wanjiriirye ekifo kyange ekyokubba omukunguwo akuwa ebyokunywa, era odi iye ni bamwita ni bamwanika oku musaale.” ");
INSERT INTO gwr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Awo oFalaawo nʼalagira batwale oYusufu, kale ni bamutoola mangu omu mabbuusu. Era oYusufu ni bamumwaku enziri, nʼazwala ebizwalo ebindi, kaisi nʼayaba e gyali. ");
INSERT INTO gwr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","OFalaawo nʼakoba oYusufu ati, “Nalootere ekirooto, neye aanu mpaawo muntu ayezya okuvuunula amakulu gaakyo. Neye bankobeire bati oyezya okuvuunula ebirooto.” ");
INSERT INTO gwr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","OYusufu nʼairamu oFalaawo ati, “Tininze, neye oKibbumba niiye eyakuvuunulira nʼowuumula omwoyo.” ");
INSERT INTO gwr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Awo oFalaawo nʼakoba oYusufu ati, “Omu kirooto kyange, nʼaboine nga njemereire oku mbale kwʼomwiga oKiyira. ");
INSERT INTO gwr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ente musanvu egiboneka kusani era egyageizere, ni gizwa omu mwiga ogwo, ni gitandiika okulya eisubi. ");
INSERT INTO gwr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Nʼente egindi musanvu egiboneka obundi era ennyondi ni gisenjaaku. Era mbaire timbonangaku ente ennyondi ngʼegyo omu kyalo kyonakyona ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Awo ente egyo egiboneka obundi era ennyondi, ni girya gidi egiboneka kusani era egyageizere. ");
INSERT INTO gwr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Neye owegyamalire okugirya, mpaawo muntu eyabbaire ayezya okumanya ati gigiriire, olwʼokubba gyasigaire nnyondi ngʼowegyabbaire omu kusooka. Awo ni nsisimuka. ");
INSERT INTO gwr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Atyanu omu kirooto ekindi, ni mbona ebigala ebyʼengaano musanvu ebijimu era ebisa, nga bisanswirye biri oku kikolo kimo. ");
INSERT INTO gwr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Oluzwanyuma ni mbona ebigala ebindi ebyʼengaano musanvu ebisanswirye, nga biwotoki, bitontono, nga bibabukire olwʼempewo yʼeibbugumu ezwa omwidungu. ");
INSERT INTO gwr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ebigala ebitontono ni bimira bidi omusanvu ebijimu. Ebirooto ebyo nabikobeire abalaguli, neye nandi ni wabbaawo ayezya okubinsonzolera.” ");
INSERT INTO gwr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Awo oYusufu nʼakoba oFalaawo ati, “Ebirootobyo byombi biri nʼamakulu gamo. Era oKibbumba akulagire ebyayaba okukola. ");
INSERT INTO gwr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ente omusanvu egiboneka kusani, niigyo emyanka omusanvu. Nʼebigala omusanvu ebijimu, niigyo emyanka omusanvu. Ebirooto byombi biri nʼamakulu gamo. ");
INSERT INTO gwr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Atyanu ente omusanvu egiboneka obundi era ennyondi, egyairire ku gidi egyasookere, era nʼebigala omusanvu ebibabukire olwʼempewo yʼeibbugumu ezwa omwidungu, egyo myanka musanvu egyʼenzala. ");
INSERT INTO gwr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ekyo niikyo ekinkukobeire Falaawo nti, oKibbumba akulagire ebiyatira okukola. ");
INSERT INTO gwr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Waabbaawo emyanka musanvu egyʼamakungula amangi omu kyalo kyonakyona ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Neye oku myanka egyo kwasenjaaku emyanka musanvu egyʼenzala. Era emyanka gyʼamakungula amangi abantu baligyerabira, era enzala yalibbuuca kumalawo abantu. ");
INSERT INTO gwr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Era ekiseera kyʼamakungula amangi abantu balikyerabirira nakimo, olwʼokubba enzala eyalisenjaaku, yalibba nene ino. ");
INSERT INTO gwr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Era ekigirire Falaawo nʼosuna ekirooto omu ngeri eibiri, kitegeeza kiti oKibbumba akakasire ekintu ekyo, era ayaba kukituukirirya mangu ino. ");
INSERT INTO gwr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Kale atyanu Falaawo oli nʼokulonda omusaiza owʼamalabuki era omutegeeri, kaisi era omuwe obwezye okufuga ekyalo kyonakyona ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Era oli nʼokulonda abakungu abandi okukumbaania ekitundu kimo oku bitundu ebitaanu oku byokulya byonabyona ebibalima omu kyalo kyʼe Misiri, omu myanka omusanvu egyabba egyʼamakungula amangi. ");
INSERT INTO gwr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Obalagire bakumbaanie ebyokulya omu myanka egyo egyʼamakungula amangi egiiza. Obawe nʼobwezye bakubisire ebyokulya ebyo omu bibuga, era babikuume. ");
INSERT INTO gwr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ebyokulya ebyo, niibyo ebyalibba ebyʼokwekuumisya omwigwanga, omu myanka omusanvu egyʼenzala eyalibbaawo omu kyalo kyʼe Misiri, kaisi abantu tibaafa enzala.” ");
INSERT INTO gwr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Atyanu oFalaawo nʼabaweereryabe bonabona, ni basiima amalabuki ago. ");
INSERT INTO gwr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kale oFalaawo nʼakoba abaweereryabe ati, “Twezya okuzuulayo omusaiza aali ngʼonu, omusaiza aizwire omwoyo wa Kibbumba?” ");
INSERT INTO gwr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Awo oFalaawo nʼakoba oYusufu ati, “NgʼoKibbumba owakulagire ebyo byonabyona, atyanu kimanye nti mpaawo muntu owʼamalabuki, era omutegeeri nga iwe. ");
INSERT INTO gwr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nakuwa obwezye okufuga ekyalo kyange, era abantu bange bonabona bagonderanga biragirobyo. Era ninze zenkani, enakukirangaku okubba nʼobwezye olwʼokubba ninze oFalaawo.” ");
INSERT INTO gwr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kale oFalaawo nʼakoba oYusufu ati, “Atyanu nkuwaire obwezye okufuga ekyalo kyonakyona ekyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Awo oFalaawo ni yeetoola oku ngalo empetaye eriku eraama yʼobwakabaka, nʼagizwalisya oYusufu oku ngalo. Nʼamuzwalisya amaganduula aga lineni omusa eino, nʼazwalisya oYusufu omu mamiro akajegere akʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Nʼamuwa ekigaali ekiiririra oku kikye obusa mwabba atambulira, era nga kiraga kiti niiye airirira oku Falaawo omu bwezye. Era abaisirikalebe ni bamwekubbembera nga bakooka bati, “Muzwe omu nzira.” Era oFalaawo nʼawa oYusufu obwezye okufuga ekyalo kyonakyona ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Awo oFalaawo nʼakoba oYusufu ati, “Newankubbaire nga ninze oFalaawo, mpaawo muntu omu kyalo kyʼe Misiri eyakolanga ekintu kyonakyona nga tasunire olukusa kuzwa gyoli.” ");
INSERT INTO gwr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Era oFalaawo nʼawa oYusufu eriina ati, Zafenansi Paneya, nʼamuwa Asanansi omwala wa Potifera okabona wʼomu kibuga Oni, okumufumbirwa. Era oYusufu nʼabba nʼobwezye oku kyalo kyʼe Misiri kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Atyanu oYusufu yabbaire wʼemyanka 30 oweyatandiikiire okuweererya oFalaawo. Nʼazwa omu lubiri lwa Falaawo, nʼatambula omu kyalo kyonakyona ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Omu myanka omusanvu egyʼamakungula, ekyalo ni kibalya ebyokulya bingi. ");
INSERT INTO gwr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kale oYusufu nʼalagira abakoli ni bakumbaania ebyokulya byonabyona, ni babiteeka omu bibuga. Era mu buli kibuga nʼabisa ebyokulya ebyʼomu misiri egikyeruguuliriirye. ");
INSERT INTO gwr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","OYusufu nʼalagira abantu ni babisa ebyokulya bingi ino ooti musenye ogwʼoku nyanza, era nʼalekeraawo okupima, olwʼokubba byabbaire nga tibikaali bipimika. ");
INSERT INTO gwr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Atyanu emyanka egyʼenzala nga gikaali okutuuka, oYusufu nʼabyala nʼAsanansi omwala wa Potifera okabona wʼomu kibuga Oni abaana abaisuka babiri. ");
INSERT INTO gwr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","OYusufu nʼawa omwanawe omubere eriina ati, Manase, ngʼakoba ati, “OKibbumba agirire ni neerabira okugada kwange kwonakwona nʼabantu bʼomu kisito kya bbaabba bonabona.” ");
INSERT INTO gwr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Nʼawa omwanawe owokubiri eriina ati, Efulaimu ngʼakoba ati, “OKibbumba ampaire abaana omu kyalo omu ngadiire.” ");
INSERT INTO gwr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Atyanu emyanka omusanvu egyʼamakungula owegyabbairewo omu kyalo kyʼe Misiri ni giwaaku. ");
INSERT INTO gwr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Awo emyanka omusanvu egyʼenzala ni gitandiika, ngʼoYusufu oweyabbaire akobere. Ni wabbaawo enzala omu kyalo kyonakyona. Neye omu kyalo kyʼe Misiri, imwo mwonamwona ni mubbaamu ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Enzala oweyatandiikire okuluma abantu bʼomu Misiri mwonamwona, ni beekungirira oFalaawo olwʼebyokulya. Awo oFalaawo nʼabakoba ati, “Mwabe e giri oYusufu, era ekiyabakoba kimwakola.” ");
INSERT INTO gwr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Atyanu enzala nʼebba nene, nʼemalaku ekyalo kyʼe Misiri kyonakyona. Kale oYusufu nʼaigulawo esitoowa gyonagyona, nʼagulyanga aBamisiri ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Era abantu ni bazwanga omu kyalo kyonakyona, ni baaba omu Misiri egiri oYusufu okugula ebyokulya, olwʼokubba enzala yabbaire nene omu kyalo kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Atyanu oYaakobbo oweyawuliire ati omu kyalo kyʼe Misiri waliyo ebyokulya, nʼakoba abataane ati, “Lwaki mutyamiraawo anambula kimukola, ni mwira mu kulolanganaku?” ");
INSERT INTO gwr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Era nʼabakoba ati, “Muwulisisye, mpulira nambu omu kyalo kyʼe Misiri waliyo ebyokulya. Muserengete mwabe, mutugulirekuuyo ebyokulya ebyezya okutulamya titwafa enzala.” ");
INSERT INTO gwr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Awo abaganda ba Yusufu eikumi, ni baserengeta okwaba e Misiri okugula ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Neye oYaakobbo nandi nʼaikirirya oBbenyamini owʼekida ekimo nʼoYusufu, okwaba aamo nʼabagandabe. Yakolere atyo olwʼokubba yatiire ati demba akabbikabbi ni katuuka oku Bbenyamini. ");
INSERT INTO gwr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Awo abataane ba Yaakobbo ni baaba nʼabantu abandi okugula ebyokulya, olwʼokubba wabbairewo enzala omu kyalo kyʼe Kanani kyona. ");
INSERT INTO gwr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Atyanu oYusufu niiye eyabbaire omufugi wʼekyalo kyʼe Misiri. Era niiye eyagulyangaku abantu bonabona ebyokulya, abo abaazwanga wonawona omu kyalo. Kale abagandabe owebatuukireyo, ni bakoma amazwi era ni baica empumi gyabwe ansi okwitakali okumuwa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","OYusufu oweyaboine abagandabe, yabamanyicirye, neye nʼababitya ngʼabantu abaatamaite, era nʼababuulya nʼobukambwe ati, “Muzwera yaina?” Ni bairamu bati, “Tuzwera mu kyalo kyʼe Kanani, era twizire kugula byokulya.” ");
INSERT INTO gwr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Waire ngʼoYusufu yamanyicirye abagandabe, neye ibo tibamumanyicirye. ");
INSERT INTO gwr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Awo oYusufu nʼayebukirya ebirooto ebiyabalootereku eira, kaisi nʼabakoba ati, “Muli bakeeti, mwizire kubona bitundu ebyʼomu kyalo kyaiswe ebinambulamu obukuumi.” ");
INSERT INTO gwr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ni bamwiramu bati, “Kadi, musengwa waiswe titwizire kukeeta. Neye iswe abaweereryabo twizire kugula byokulya. ");
INSERT INTO gwr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Swenaswena tuli baana ba musaiza moiza. Era iswe abaweereryabo, tuli bantu bʼamazima, tituli bakeeti.” ");
INSERT INTO gwr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","OYusufu nʼabakoba ati, “Kadi, mwizire kubona bitundu ebinambulamu obukuumi.” ");
INSERT INTO gwr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ibo ni bamwiramu bati, “Iswe abaweereryabo tuli baganda, era tuli ikumi na babiri, era tuli baana ba musaiza moiza. Omusaiza oyo mutyami wʼomu kyalo kyʼe Kanani. Omuganda waiswe onankoma, iye asigaireyo nʼobbaabba, iye omuganda waiswe ogondi yatuzwire oku maiso.” ");
INSERT INTO gwr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Neye oYusufu ni yeekanyangula kubakoba ati, “Niikyo nakimo ngʼowenkobere nti, inywe muli bakeeti. ");
INSERT INTO gwr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Atyanu enu niiyo engeri eginjaba okubagezesya okukakasa ooba ngʼebimutumula bituuce. OFalaawo ngʼobwali mwomi, ndayiire timwazwe aanu, okutoolaku ngʼomuganda waanywe onankoma aizire aanu. ");
INSERT INTO gwr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Aale atyanu mulondeku omoiza kwinywe mumutume ayabe amuleete aanu. Oyo ngʼayaba okumusyoma inywe mwabba mu mabbuusu, kaisi olwo tubagezye okukakasa ooba ngʼebimutumula byʼamazima. Owebyabba nga tibituuce, oFalaawo ngʼobwali mwomi, kyabba kitegerekeka nga inywe dala muli bakeeti.” ");
INSERT INTO gwr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Era awo nʼabateeka bonabona omu mabbuusu, okumala enaku isatu. ");
INSERT INTO gwr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Awo owegyabitirewo enaku ibiri, oku lwokusatu oYusufu nʼabakoba ati, “Nze ndi muntu awa oKibbumba ekitiisya. Nʼolwekyo mukole ekinjaba okubakoba, kaisi mulame okufa. ");
INSERT INTO gwr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Obwemubba nga muli bantu bʼamazima, mulondeku omoiza kwinywe asigale aanu omu mabbuusu, kaisi inywe abandi mutwalire abʼomu bisito byanywe ebyokulya, ibo enzala abeeri bundi. ");
INSERT INTO gwr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Neye muteekwa okundeetera omuganda waanywe onankoma. Ekyo kyakakasa kiti ebimutumwire byʼamazima, era tibalibaita.” Era bona ni baikirirya okukola batyo. ");
INSERT INTO gwr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Kaisi ni bakobangana bati, “Mazima bali kutugadya lwʼekikole ekitwakolere omuganda waiswe eira. Ekyo kityo olwʼokubba twaboine okugada okuyabbairemu oweyatwegairiire okutamukola akabbikabbi, neye iswe ni tugaana okuwulira, ekyo niikyo ekigira tuli kugada tuti!” ");
INSERT INTO gwr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Awo oLubbeeni nʼabairamu ati, “Aale nze tinabakobere nti timwakola omwisuka akabbikabbi, neye inywe ni mugaana okumpulisisya? Atyanu bali kutugadya lwʼokufaakwe.” ");
INSERT INTO gwr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Neye ibo tibamanyicirye ngʼoYusufu ategeire ebibatumula, olwʼokubba yatumulanga nabo nga waliwo abagalucirya. ");
INSERT INTO gwr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kale oYusufu nʼazwa aawo e gibali, nʼayaba nʼakulumuca amaliga. Oweyaikaikanire, nʼakangayo e gibali era tete nʼatumula nabo. Awo nʼatoolamu oSimyoni, era ni bamusiba ngʼabagandabe babona. ");
INSERT INTO gwr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Awo oYusufu nʼalagira abaweereryabe okwizulya ekotiya gya bagandabe ebyokulya, nʼokwirirya nabuli moiza empiiyagye omu kotiyaye. Era nʼalagira ni babawa ebyokulya ebibaaba okukolesya nga bali omu lugendo bakanga, era ni babakolera batyo. ");
INSERT INTO gwr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kale abagandabe ni batiika ebyokulya byabwe oku mpunda gyabwe, ni basimbuka okukanga e ika. ");
INSERT INTO gwr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Neye owebatuukire omu kifo egibagonere ekiire ekyo, era omoiza kwibo nʼasibindula ekotiyaye okuwa ompundawe ebyokulya, yaajiirye empiiyagye nga giri oku ngulu oku byokulya ebyabbaire omu kotiyaye. ");
INSERT INTO gwr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Nʼaceera ngʼakoba abagandabe ati, “Mubone! Empiiya egyange baginjiriirye, nginu omu kotiya yange.” Neye abagandabe emyoyo ni gibacemuka, ni batukuta, era ni bakobangana bati, “Niki kinu oKibbumba ekyʼatukolere?” ");
INSERT INTO gwr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kale owebatuukire eeri oYaakobbo oitewaabwe, omu kyalo kyʼe Kanani, ni bamukobera byonabyona ebyabbaire bibatuukireku e Misiri bati, ");
INSERT INTO gwr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Omusaiza omufugi wʼekyalo kyʼe Misiri yatumwire na iswe nʼobukambwe, nʼatubitya ngʼabakeeti abali kukeeta kyalokye. ");
INSERT INTO gwr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Neye iswe ni tumukoba tuti, ‘Iswe tuli bantu bʼamazima, tituli bakeeti. ");
INSERT INTO gwr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tuli baganda, era tuli ikumi na babiri, era tuli baana ba musaiza moiza. Omuganda waiswe ogondi yatuzwire oku maiso, kaisi omuganda waiswe onankoma, iye asigaireyo nʼobbaabba omu kyalo kyʼe Kanani.’ ");
INSERT INTO gwr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Awo omusaiza odi omufugi wʼekyalo kyʼe Misiri, nʼatukoba ati, ‘Atyanu enu niiyo engeri eginategeeramu ooba nga muli bantu bʼamazima. Muleke omoiza kwinywe asigale aanu na nze, kaisi inywe abandi mutwalire abʼomu bisito byanywe ebyokulya, ibo enzala abeeri bundi. ");
INSERT INTO gwr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kaisi mundeetere omuganda waanywe onankoma, awo nakakasa nti timuli bakeeti, neye muli bantu bʼamazima. Era awo, nabairirya omuganda waanywe, era mwetayaayanga omu kyalo kinu!’ ” ");
INSERT INTO gwr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Atyanu owebasindwire ekotiya gyabwe nga bataka okusukumula ebyokulya, nabuli moiza nʼayajirya omu kotiyaye ebbandaliye eyʼempiiya. Neye ibo nʼoitewaabwe owebaboine ebbandali egyo, ni beeraliikirira. ");
INSERT INTO gwr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Awo oYaakobbo oitewaabwe nʼabakoba ati, “Mummalireku abaana bange! OYusufu yanzwire oku maiso, nʼoSimyoni yena ngoyo anzwire oku maiso. Era atyanu mutaka okuntoolaku nʼoBbenyamini yena. Ebyo byonabyona birumya ninze!” ");
INSERT INTO gwr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Awo oLubbeeni nʼakoba oiteeye ati, “Singa owentaliirya oBbenyamini egyoli, waliita abataane bange bombi. Omunkwatisye ninze, nalimwirya e gyoli.” ");
INSERT INTO gwr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Neye oYaakobbo nʼamwiramu ati, “Kadi tinjikirirya omwana wange okuserengeta okwaba eeyo na inywe, olwʼokubba omugandawe yafiire, era iye, niiye asigairewo yenkani oku mawaabwe. Akabbikabbi owekamutuukaku nga muli omu nzira mwaba, nze ndi mukaire, enima egimwabba mundeeteire yanjita!” ");
INSERT INTO gwr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Atyanu enzala ni yeeyongera era nʼebba nene omu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Kale owebamalire okulya ebyokulya ebibatoire omu kyalo kyʼe Misiri, oitewaabwe nʼabakoba ati, “Mukangeyo mutugulireku ebyokulya ebindi.” ");
INSERT INTO gwr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Neye oYuda nʼamwiramu ati, “Omusaiza omufugi waayo, yatulabuliire nakimo ati, ‘Tinalibawulisisya naire, okutoolaku nga mwizire nʼomuganda waanywe onankoma.’ ");
INSERT INTO gwr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kale owewaikirirya omuganda waiswe okwaba na iswe, twaserengeta twaba ni tubagulirakuuyo ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Neye owoobba tomwikirirya okwaba na iswe, titwabe, olwʼokubba omusaiza odi omufugi yatukobere ati, ‘Tinalibawulisisya naire, okutoolaku nga mwizire nʼomuganda waanywe onankoma.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Awo oYaakobbo eriinalye erindi bati, Isirairi nʼabakoba ati, “Lwaki mwandeeteire ekigosi ekyʼamaani ekyo, okukobera omusaiza omufugi oyo muti muliyo nʼomuganda waanywe ogondi?” ");
INSERT INTO gwr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ni bamwiramu bati, “Omusaiza odi omufugi yatubwirye ino ebitufaaku, nʼoku bʼekika kyaiswe ati, ‘Oitewaanywe akaali mwomi? Mulikuuyo nʼomuganda waanywe ogondi?’ Iswe twamwiriremu bibuulyo ebiyatubwirye. Titwategeire tuti yatukoba ati, ‘Mundeetere omuganda waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Era oYuda nʼakoba oYaakobbo oiteeye ati, “Onkwatisye ninze omwisuka oyo nga twaba, awo swenaswena twasetuka ni twaba. Olwo kaisi iswe na iwe, nʼabaana baiswe abatobato twezye okutafa enzala. ");
INSERT INTO gwr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nze neeyamire okumukuuma, walimumbuulya ninze. Singa tinalimwirya egyoli, ni mmukuleetera omumaisogo, omusango gubbe ku ninze enaku gyonagyona. ");
INSERT INTO gwr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Singa titulwirewo oku nsonga enu, atyanu twankabbaire twabire ira era nga twirire nʼomulundi ogwokubiri.” ");
INSERT INTO gwr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Awo oYaakobbo oitewaabwe nʼabakoba ati, “Obwekibba nga kiteekwa kubba kityo, mukole muti; mukwate ebimo oku bineneka ebyʼomu kyalo kinu ebikira obusa, muteeke omu kotiya gyanywe muserengete mwabe mutwalire omusaiza omufugi nago. Mumutwalireku ebyakaloosa ebibeeta bbaamu, nʼomujenene, nʼebyakaloosa ebibeeta miira, nʼebimaido, nʼebineneka ebibeeta alumondi. ");
INSERT INTO gwr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","“Era mutwale empiiya gyʼemirundi mibiri olwʼokubba muteekwa okukanja egyo egimwairiirye omu kotiya gyanywe. Amo-so ni babba nga bagiteekeremu mubutagenderera. ");
INSERT INTO gwr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Mutwale nʼomuganda waanywe onankoma, musetuke mukange eeri omusaiza oyo omufugi. ");
INSERT INTO gwr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Nsaba oKibbumba oWabwezye Bwonabwona abakwatire ekisa nga muli omumaiso gʼomusaiza oyo omufugi. Era omusaiza oyo ayezye okubairirya omuganda waanywe oSimyoni, nʼoBbenyamini. Nze obwemba ndi nʼokufiirwa abaana bange, oleke mbafiirwe.” ");
INSERT INTO gwr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Kale awo abaganda abo ni bakwata ebirabo nʼempiiya egyʼemirundi emibiri mibiri, ni baaba nʼoBbenyamini, ni baserengeta e Misiri. Ni baaba omumaiso ga Yusufu. ");
INSERT INTO gwr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","OYusufu oweyaboine nga bali nʼoBbenyamini, nʼakoba onyampala wʼekisitokye ati, “Otwale abasaiza banu omu kisito kyange. Kaisi osale okisolo era omusumbe, olwʼokubba baaba kuliira aamo na nze ekyamusana.” ");
INSERT INTO gwr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kale onyampala oyo nʼakola ngʼoYusufu oweyamulagiire, nʼatwala abaganda abo omu kisito kya Yusufu. ");
INSERT INTO gwr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Neye abaganda abo ni batya olwʼokubatwala omu kisito kya Yusufu. Ni bakobangana bati, “Batuleetere eenu, lwʼempiiya egibateekere omu kotiya gyaiswe oku mulundi ogutwasookere okwiza eenu. Akolere ati kaisi ayezye okutuvunaana, era atunyageku empunda gyaiswe, era atusuuce bagalamabe.” ");
INSERT INTO gwr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kale awo ni baigerera e giri onyampala wʼekisito kya Yusufu, ni batumula naye, nga bali oku muzigo gwʼekisito. ");
INSERT INTO gwr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ni bamukoba bati, “Sebo, twaizireku eenu okugula ebyokulya omulundi ogwasookere. ");
INSERT INTO gwr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Owetwatuukire omu kifo e gitwagonere nga tukanga e ika twasindwire ekotiya gyaiswe, nabuli moiza yaajiiryemu empiiyagye nga gyenkana na gidi egiyabbaire asaswire. Gyabbaire giri oku ngulu oku byokulya ebyabbaire omu kotiya ya buli moiza, era tugiirirye. ");
INSERT INTO gwr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Titumaite eyairirye empiiya omu kotiya gyaiswe egitwasaswire kugula byokulya. Wazira tuleetere nʼempiiya egindi okugulaku ebyokulya.” ");
INSERT INTO gwr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Neye iye onyampala nʼabakoba ati, “Timweraliikirira, era timwatya. OKibbumba waanywe era oKibbumba wa itewaanywe niiye eyabateekeire empiiya egyo omu kotiya gyanywe. Nze nasunire empiiya gyanywe egimwasaswire.” Kaisi awo nʼabatoolerayo oSimyoni. ");
INSERT INTO gwr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Awo onyampala nago nʼatwala abaganda abo omu kisito kya Yusufu, nʼabawa amaizi ni banaaba ebigere, era nʼawa nʼempunda gyabwe ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kale awo ni bategeka ebirabo byabwe ebibaawa oYusufu oweyaabba aizire egibali omusana. Bakolere batyo olwʼokubba babbaire babakobeire bati baliira yeeyo aamo nʼoYusufu ekyamusana. ");
INSERT INTO gwr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Atyanu oYusufu oweyakangire e ika, awo abagandabe abo ni bakwata ebirabo ebibabbaire nabyo ni bamutwalira egiyabbaire, era ni bakoma amazwi era ni baica empumi gyabwe ansi okwitakali okumuwa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Oluzwanyuma nʼababuulya ati, “Muliwo basa?” Era nʼababuulya ati, “Oitewaanywe omukaire ogumwatumwireku akaali mwomi? Era ali atya?” ");
INSERT INTO gwr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ibo ni bamwiramu bati, “Omuweereryawo oitewaiswe akaali mwomi, era aliyo musa.” Awo tete ni bakoma amazwi era ni baica empumi gyabwe ansi okwitakali. ");
INSERT INTO gwr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Awo oYusufu nʼasiirya amaisoge nʼabona omugandawe onankoma oBbenyamini, omwana wa maaye, nʼababuulya ati, “Oyo niiye omuganda waanywe onankoma ogumwankobeireku?” Kaisi nʼakoba oBbenyamini ati, “Mwisuka, oKibbumba akukwatire ekisa!” ");
INSERT INTO gwr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Awo oYusufu omwoyo ni gumucemuka olwʼokubonaku omugandawe onankoma ogwataka eino. Kale nʼazwa mangu omu kisenge ekyo nʼaingira omu kisenge ekindi, nʼakulumucirya omwo amaliga. ");
INSERT INTO gwr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Oweyamalire okukungaku, nʼokunaabaku amaliga, nʼawulukamu ngʼagumire, awo nʼalagira abaweereryabe okwinula ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","OYusufu bamwinwire yenkani, nʼabagandabe abo ni babainula bonkani, nʼaBamisiri abaliire oku kiinulo ekyo bona ni babainula bonkani. Babainwire batyo olwʼokubba kyabbaire kya muliko aBamisiri okuliira aamo nʼaBeebbulaniya. ");
INSERT INTO gwr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Owebabbaire balya, batyamisirye abaganda nago nga balingiriire Yusufu. Babatyamisirye ngʼowebairanganaku okuzwera oku mukulu okutuuka oku mutomuto, ni balolanganaku ni beewunya. ");
INSERT INTO gwr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Babainwire ebyokulya okuzwa oku menza ya Yusufu. Era ni bawa nabuli muntu yenkani, neye ebyokulya ebibawaire oBbenyamini ni bibba bingi ino okukiraku ebibawaire abagandabe badi abandi. Era ni balya, ni banywa, ni bajaagaanira aamo nʼoYusufu. ");
INSERT INTO gwr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Awo ebyo owebyawoire, oYusufu nʼalagira onyampala wʼekisitokye ati, “Oteeke omu kotiya gyʼabasaiza abo ebyokulya ebibayezya okwetiika. Era oteekere nabuli moiza empiiyagye oku ngulu oku byokulya ebiri omu kotiyaye. ");
INSERT INTO gwr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Era oteeke nʼekikopo kyange ekya feeza, oku ngulu oku byokulya ebiri omu kotiya ya muganda waabwe onankoma, era oteekemu nʼempiiyagye egyasaswire ebyokulya.” Kale onyampala nʼakola atyo ngʼoYusufu oweyamukobere. ");
INSERT INTO gwr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Owebwaceire amakeezikeezi, ni baseebula abaganda abo ni baaba nʼempunda gyabwe. ");
INSERT INTO gwr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Owebabbaire bakaali okwabirira okuzwa omu kibuga, oYusufu nʼakoba onyampala wʼekisitokye ati, “Osetukiremu osenjeeku abasaiza abo. Owewabatuukaku, obakobe oti, ‘Iswe tubakoleire bisa, lwaki inywe mutusaswiremu bikole ebibbibibbi? ");
INSERT INTO gwr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Lwaki mwibbire ekikopo kya musengwa wange ekya feeza? Ekyo tiniikyo ekikopo omusengwa wange ekyanyweramu era ekyʼakolesya ngʼalagula? Ekintu ekimukolere kibbikibbi ino!’ ” ");
INSERT INTO gwr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Onyampala oyo oweyabatuukireku, yabakobere bibono binanyere ebyo. ");
INSERT INTO gwr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ibo ni bamwiramu bati, “Sebo, niki ekigira nʼotumula ebibono ebityo? Iswe titwezya okukola ekintu ekityo. ");
INSERT INTO gwr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Omaite nga twabairiirye empiiya egitwajiirye oku ngulu oku byokulya ebyabbaire omu kotiya gyaiswe, owetwabbaire tukangire omu kyalo kyʼe Kanani? Olwo twandiibbire feeza ooba zaabbu omu kisito kya musengwawo? ");
INSERT INTO gwr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Atyanu sebo, kwiswe abaweereryabo, yenayena ogubayajirya ngʼali nʼakyo bamwite, era swena abaabba basigairewo twabba bagalamabo.” ");
INSERT INTO gwr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Nʼabakoba ati, “Kale njikiriirye ekimukobere. Neye oyo ogubayajirya nʼakyo, niiye yenkani eyaabba omugalama wange. Inywe abandi timwabbeeku omusango.” ");
INSERT INTO gwr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Awo abaganda abo ni batiikula mangu ekotiya gyabwe, ni bagiteeka ansi, era nabuli moiza nʼasibindula ekotiyaye. ");
INSERT INTO gwr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Atyanu onyampala wʼekisito kya Yusufu nʼatandiika okwaza. Nʼazwera okwakira obukulu nʼamaliirirya nʼakira obutobuto, kaisi ekikopo nʼacaajirirya mu kotiya ya Bbenyamini. ");
INSERT INTO gwr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Awo abaganda abo olwʼokunakuwala ni banyiira ebizwalo byabwe, era nabuli moiza nʼakanja ebintu oku mpundawe, ni bakangayo omu kibuga. ");
INSERT INTO gwr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Atyanu oYusufu yabbaire akaali ali ika, oYuda nʼabagandabe ni batuuka omu kisitokye, ni beeyala ansi omumaisoge. ");
INSERT INTO gwr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Awo oYusufu nʼabakoba ati, “Niki kinu ekimukolere? Timumaite muti omuntu aali ooti ninze, ayezya okulagula?” ");
INSERT INTO gwr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","OYuda nʼamwiramu ati, “Twakukoba niki musengwa wange? Kinu twakisonzola tutya? Kinu twewozyaku tutya? OKibbumba alagire ngʼowetuli nʼomusango. Era atyanu swenaswena tuli bagalamabo, nga tiyoodi yenkani ogubayajiirye nʼekikopo.” ");
INSERT INTO gwr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Neye oYusufu nʼabakoba ati, “Kadi, timpezya okukola ekyo. Oyo yenkani ogubayajiirye nʼekikopo, niiye eyaabba omugalama wange. Inywe abasigairewo, mwekangire mwidembe eeri oitewaanywe.” ");
INSERT INTO gwr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Awo oYuda nʼaigerera egiri oYusufu nʼamukoba ati, “Musengwa wange, nkwegairiire oganye nze omuweereryawo, mbeeku nʼekintumula egyoli. Mmaite ngʼoli nʼobwezye ngʼobwa Falaawo, nʼolwekyo nsaba tiwansunguwalira. ");
INSERT INTO gwr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Musengwa wange, watubwirye iswe abaweereryabo oti, ‘Oitewaanywe akaali mwomi?’ Era oti, ‘mulikuuyo nʼomuganda waanywe ogondi?’ ");
INSERT INTO gwr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Iswe ni tukwiramu tuti, ‘Oitewaiswe akaali mwomi neye mukaire, era abba nʼomuganda waiswe onankoma, oguyabyaire omu bukaire. Omuganda waiswe oyo, yabbaire nʼomugandawe omukulu neye yatuzwire oku maiso. Atyanu iye niiye yenkani eyasigairewo oku maaye, era oitewaiswe amutaka ino.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Awo nʼotukoba iswe abaweereryabo oti, ‘Mumundeetere mmuboneku.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ni tukukoba musengwa wange tuti, ‘Omwisuka tayezya okuzwa okwiteeye, olwʼokubba singa amuzwaku, oiteeye ayinza okufa.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Neye nʼotukoba oti, ‘Tinalibawulisisya naire, okutoolaku nga mwizire nʼomuganda waanywe oyo.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Owetwakangire egiri oitewaiswe omuweereryawo, twamukobeire ebibono ebiwatukobere. ");
INSERT INTO gwr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Awo ebyokulya owebyawoire nʼatukoba ati, ‘Mukange mutugulireku ebyokulya ebindi.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Neye iswe ni tumukoba tuti, ‘Titwezya okwaba eeyo, olwʼokubba omusaiza omufugi waayo tiyatuwulisisye naire, okutoolaku nga twabire nʼonankoma waiswe. Owewatwikirirya okwaba nʼomuganda waiswe oyo, awo twaba.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Awo obbaabba yatukobere ati, ‘Mumaite ngʼomukali wange oLaakeeri yambyaliire abaana abaisuka babiri bonkani. ");
INSERT INTO gwr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Era omwana omoiza yanzwire oku maiso, ni nkoba nti mazima dala, oYusufu okisolo amunyiiranyiiriremu! Era tinjirangamu kumubonaku okuzwa kwolwo. ");
INSERT INTO gwr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Awo nʼakoba ati, owemwantoolaku nʼonu yena, akabbikabbi ni kamutuukaku, nze ndi mukaire, enima egimwabba mundeeteire yanjita!’ ” ");
INSERT INTO gwr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Awo oYuda ni yeeyongera okukoba ati, “Atyanu musengwa timpezya okukanga e giri obbaabba omuweereryawo nga mbula onankoma waiswe oyo. Obwomi bwa bbaabba bukwatagana ino nʼobubwe, ");
INSERT INTO gwr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","owenatuuka e giri obbaabba nʼabona nga tubula omuganda waiswe oyo, obbaabba yaafa. Era iswe abagalamabo, enima egitwaleetera oitewaiswe omukaire, yamuzweramu okufa. ");
INSERT INTO gwr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nze neeyamire egiri obbaabba, nti nʼakuuma omuganda waiswe oyo, era obbaabba nʼamukobere nti, ‘Singa tinalimwirya e gyoli, ni mmukuleetera omumaisogo, omusango gubbe ku ninze enaku gyonagyona.’ ");
INSERT INTO gwr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Atyanu musengwa wange, nkwegairiire onjikirirye nze nsigale aanu nsuuke mugalamawo, omu kifo kyʼomuganda waiswe oyo. Omwikirirye iye akange e ika nʼabaganda baiswe. ");
INSERT INTO gwr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Nkusabire ntyo olwʼokubba timpezya okukanga egiri obbaabba, nga mbula omuganda waiswe oyo. Timpezya okuguma okubona akabbikabbi akatuuka oku bbaabba.” ");
INSERT INTO gwr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","OYusufu oweyamalire okuwulira ebyo, era nʼakaya okuguma okutakungira omumaiso gʼabaweereryabe, awo nʼalagira abaweererya abo bonabona okuwuluka omu kisenge omu babbaire. Nandi ni musigalamu omuweererya waire moiza, awo oYusufu ni yeeyanjulira abagandabe. ");
INSERT INTO gwr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Era nʼakuukulya, nʼaBamisiri ababbaire e nza wʼenyumba ni bamuwulira, ni baaba bakoberaku nʼabʼomu lubiri lwa Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","OYusufu nʼakobera abagandabe ati, “Ninze oYusufu! Obbaabba akaali mwomi?” Neye abagandabe owebawuliire ekyo, ni batya ino era nandi ni bayezya okumwiramu, olwakweyajirya nga bali mumaisoge. ");
INSERT INTO gwr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Neye iye oYusufu nʼakoba abagandabe ati, “Bainange, mwigerere aanu e gyendi!” Ni baigerera, kaisi nʼabakoba ati, “Ninze oYusufu omuganda waanywe, ogumwagulirye abʼomu Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Neye timwanakuwala waire okwesalira omusango, muti olwʼokubba mwantundire omu bantu bʼeenu. OKibbumba niiye eyansindikire nze okwiza eenu nga inywe mukaali okwiza, olwʼokulamya obwomi bwʼabantu. ");
INSERT INTO gwr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Enzala yankuluma emyanka mibiri gyonkani, neye ate nga wakaali wasigaireyo emyanka egindi mitaanu, egibatalimiremu, waire okukunguliramu. ");
INSERT INTO gwr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Wazira iye oKibbumba yansindikire nze okwiza omu kyalo kinu nga inywe mukaali okwiza, lwʼokulamya obwomi bwanywe nʼeibyaire lyanywe omu ngeri eyeewunyisya. ");
INSERT INTO gwr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Kale tiniinywe omwansindikire eenu, wazira Kibbumba. Era yansuucirye mpamalabuki omukulu owa Falaawo wʼekyalo kinu. Ndabirira ebintubye byonabyona, era ndi mufugi wʼabantu bonabona abʼomu Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Atyanu mwanguweku mukange egiri obbaabba, mumukobere muti omwanawo oYusufu akoba ati, oKibbumba yamusuucirye mufugi wʼekyalo kyʼe Misiri kyonakyona, osetukiremu oyabe egyali. ");
INSERT INTO gwr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Iwe oyaba kubba mutyami wʼomwitwale lyʼe Goseni. Iwe nʼabaanabo, nʼabaizukulubo, nʼentaamagyo nʼembuligyo, nʼentegyo, nʼebintu byonabyona ebyoli nabyo, mwabbanga kumpi naye. ");
INSERT INTO gwr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ayaba okukulabiriranga ngʼotyaime eeyo omu Goseni, iwe nʼabʼomu kisitokyo, nʼebintubyo byonabyona ebyoli nabyo, kaisi tiwabbaawo ekimudamba. Ayaba okukola atyo olwʼokubba enzala enu eyaba okuluma okumala emyanka egindi mitaanu.” ");
INSERT INTO gwr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Awo oYusufu nʼakoba abagandabe ati, “Atyanu inywe abanyere, nʼomuganda wange Bbenyamini wena, mwezya okubona ni mukakasa muti ninze oYusufu onyerenyeere atumula na inywe. ");
INSERT INTO gwr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Era Mwabe mukobere obbaabba ngʼobwendi nʼekitiisya ekyʼamaani omu Misiri, mumukobere nʼebintu byonabyona ebimuboine. Mwanguweku mundeetere obbaabba aanu.” ");
INSERT INTO gwr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Awo oYusufu nʼagwa omugandawe oBbenyamini omu kifubba, era bombi ni bakulumuca amaliga olwʼeisangaalo. ");
INSERT INTO gwr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","OYusufu nʼagwa abagandabe bonabona omu bifubba, nga waakulumuca amaliga. Ebyo owebyawoire, abagandabe ni balonsya naye. ");
INSERT INTO gwr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Amawuliro owegatuukire omu lubiri lwa Falaawo, bati abaganda ba Yusufu baizire, oFalaawo nʼabakungube ni basangaala ino. ");
INSERT INTO gwr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Awo oFalaawo nʼakoba oYusufu ati, “Okobe abagandabo oti, ‘Mutiike emigugu oku bisolo byanywe, mukange omu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Mwabe muleete oitewaanywe nʼabʼomu bisito byanywe, mwize eenu. Nabawa eitakali erikira obujimu omu kyalo kinu ekyʼe Misiri, era mwasunanga amakungula amasa omu kyalo kinu.’ ");
INSERT INTO gwr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Era oFalaawo nʼakoba oYusufu okubalagira ati, ‘Mwabeku nʼebigaali okuzwa omu kyalo kinu ekyʼe Misiri, oku mwaleetera abaana baanywe abatobato nʼabakali baanywe, era mwize nʼoitewaanywe. ");
INSERT INTO gwr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Era timweraliikirira ekyʼokulekayo ebintu byanywe ebimo, olwʼokubba ebintu ebikira obusa omu kyalo kyonakyona ekyʼe Misiri, baaba okubawa bibbe byanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Awo abaana ba Yaakobbo ni baikirirya okukola batyo ngʼoFalaawo oweyakobere. Era oYusufu nʼabawa ebigaali ngʼoFalaawo oweyabbaire amulagiire. Nʼabawa nʼebyokulya ebibaalya nga bali omu lugendo bakanga. ");
INSERT INTO gwr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Era nʼawa nabuli moiza ebizwalo ebindi, neye nʼawa oBbenyamini iye emigigi gyʼebizwalo mitaanu nʼesekeri egyʼefeeza 300. ");
INSERT INTO gwr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","OYusufu nʼaweererya oiteeye empunda ikumi egyetiikire emigangi gyʼebintu ebisa ebyʼomu Misiri, nʼempunda enkali ikumi egyetiikire ebyokulya. Mwebyo mwabbairemu engaano, nʼemigaati, nʼebyokulya ebindi, oitewaabwe ebiyaliriira omu nzira. ");
INSERT INTO gwr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Atyo nʼaseebula abagandabe ngʼabakoba ati, “Mwekuume timwayombera omu nzira!” ");
INSERT INTO gwr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kale abaganda abo ni bazwa omu Misiri, ni bakanga egiri oYaakobbo oitewaabwe omu kyalo kyʼe Kanani. ");
INSERT INTO gwr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Owebatuukire egiri oitewaabwe ni bamukobera bati, “OYusufu akaali mwomi, era niiye omufugi wʼekyalo kyonakyona ekyʼe Misiri.” OYaakobbo oweyawuliire ebibono ebyo, nʼasamaalirira, era nʼagaana okwikirirya ekibakoba. ");
INSERT INTO gwr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Neye owebamulonseirye ebintu byonabyona oYusufu ebiyabakobeire, era oweyaboine ebigaali oYusufu ebyaweereirye okumutwaliramu, nʼaikaikana. ");
INSERT INTO gwr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Awo oYaakobbo nʼakoba ati, “Ekimunkobeire kimala, omwana wange oYusufu akaali mwomi. Nayaba mmuboneku nga nkaali okufa.” ");
INSERT INTO gwr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Awo oYaakobbo eriina erindi bati, Isirairi nʼasimbuka, era nʼayaba nʼebintubye byonabyona ebiyabbaire nabyo. Oweyatuukire e Bberusebba nʼawaayo esadaaka eeri oKibbumba wa iteeye oIsaka. ");
INSERT INTO gwr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Era oKibbumba nʼatumula nʼoYaakobbo obwire omu kirooto, nʼamweta ati, “Yaakobbo, Yaakobbo!” Nʼayetuka ati, “Waitu!” ");
INSERT INTO gwr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","OKibbumba nʼamukoba ati, “Ninze oKibbumba, oKibbumba wa iteewo. Tiwaatya okwaba e Misiri, olwʼokubba eeyo nalikuwa abaizukulu bangi ino ni babba igwanga erinene eryʼamaani. ");
INSERT INTO gwr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Naserengeta ni njaba na iwe e Misiri, era naliirya eibyaireryo omu kyalo kinu. Owewalifa, oYusufu niiye eyalikugolola.” ");
INSERT INTO gwr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Awo oKibbumba oweyamalire okutumula nʼoYaakobbo, oYaakobbo nʼasimbuka okuzwa e Bberusebba, era abataane ni bamuteeka iye nʼabaana baabwe nʼabakali baabwe, omu bigaali oFalaawo ebiyabbaire aweereirye okubatwaliramu. ");
INSERT INTO gwr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kale oYaakobbo ni basimbuka nʼebisolo byabwe, nʼebintu byabwe byonabyona ebibasuniire omu kyalo kyʼe Kanani, ni baaba omu Misiri. OYaakobbo yaabire nʼeibyairerye lyonalyona, ");
INSERT INTO gwr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ekikoba kiti, abataanebe, nʼabaizukulube abaisuka, nʼabaala nʼabaizukulu bʼabaalabe. ");
INSERT INTO gwr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ganu niigo amaliina gʼaBaisirairi, ekikoba kiti, oYaakobbo nʼeibyairerye abaabire omu kyalo kyʼe Misiri: OLubbeeni omutaane wa Yaakobbo omubere. ");
INSERT INTO gwr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Nʼabataane ba Lubbeeni banu: OKanoki, nʼoPalu, nʼoKezirooni nʼoKalumi. ");
INSERT INTO gwr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Nʼomutaane wa Yaakobbo ogondi bati, Simyoni, nʼabataane ba Simyoni banu: OYemweri, nʼoYamini, nʼOkaadi nʼoYakini, nʼoZokali, nʼoSyawulo omwana oguyabyaire nʼomukali oMukanani. ");
INSERT INTO gwr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Nʼomutaane wa Yaakobbo ogondi bati, Leevi, nʼabataane ba Leevi banu: OGerusoni, nʼoKokasi, nʼoMerali. ");
INSERT INTO gwr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Nʼomutaane wa Yaakobbo ogondi bati, Yuda, nʼabataane ba Yuda banu: Eri, nʼOnani, nʼoSeera, nʼoPereezi, nʼoZeera. Neye Eri, nʼOnani babbaire bamalire okufeera omu kyalo kyʼe Kanani. Era nʼabataane ba Pereezi banu bona baabire e Misiri: OKezirooni nʼoKamuli. ");
INSERT INTO gwr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Nʼomutaane wa Yaakobbo ogondi bati, Isakaali, nʼabataane ba Isakaali banu: OTola, nʼoPuva, nʼoYasabbu, nʼoSimulooni. ");
INSERT INTO gwr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Nʼomutaane wa Yaakobbo ogondi bati, Zebbulooni, nʼabataane ba Zebbulooni banu: OSeredi, nʼEroni, nʼoYaleeri. ");
INSERT INTO gwr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Eryo niiryo eibyaire oLeeya eriyasunire nʼoYaakobbo omu Padanalaamu. Era oYaakobbo nʼoLeeya babbaire nʼomwala ogubeeta Dina. Eibyaire lyonalyona erya Yaakobbo nʼoLeeya eryazwire omu Padanalaamu babbaire abantu 33. ");
INSERT INTO gwr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Era mwabo abaabire e Misiri mwabbairemu nʼomutaane wa Yaakobbo ogondi bati, Gaadi, nʼabataane ba Gaadi banu: OZifiyooni, nʼoKaagi, nʼoSuni, nʼEzubbooni, nʼEri, nʼAlodi, nʼAleri. ");
INSERT INTO gwr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Nʼomutaane wa Yaakobbo ogondi bati, Aseri, nʼabataane bʼAseri banu: OImuna, nʼoIsuva, nʼoIsuvi, nʼoBberiya, nʼomwonyoko waabwe oSeera. Nʼabataane ba Bberiya banu: OKebberi, nʼoMalukiyeeri. ");
INSERT INTO gwr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Eryo lyabbaire niiryo eibyaire lya Yaakobbo nʼomukaliwe oZirupa omugalama oLaabbaani oguyawaire oLeeya omwalawe. Eibyaire eryo babbaire abantu ikumi na mukaaga. ");
INSERT INTO gwr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Era abaabire e Misiri mwabbairemu nʼabaisuka ababiri oLaakeeri abeyabyaire nʼoibaaye oYaakobbo nga niibo banu: OYusufu nʼoBbenyamini. ");
INSERT INTO gwr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","OYusufu nʼAsanansi omwala wa Potifera okabona wʼOni, nga bali omu Misiri babyaire abaana abaisuka babiri, oManase nʼEfulaimu. ");
INSERT INTO gwr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Nʼabataane ba Bbenyamini banu bona baabire e Misiri: OBbera, nʼoBbekeri, nʼAsubbeeri, nʼoGera, nʼoNamani, nʼEki, nʼoLosi, nʼoMupimu, nʼoKupimu, nʼAludi. ");
INSERT INTO gwr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Eryo niiryo eibyaire lya Yaakobbo nʼomukaliwe oLaakeeri. Era eibyaire eryo babbaire bonabona abantu ikumi na bana. ");
INSERT INTO gwr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Abaabire e Misiri era mwabbairemu nʼomutaane wa Yaakobbo ogondi bati, Daani, nʼomutaane wa Daani bati, Kusimu. ");
INSERT INTO gwr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nʼomutaane wa Yaakobbo ogondi bati, Nafutaali, nʼabataane ba Nafutaali banu: OYakuzeeri, nʼoGuuni, nʼoYezeri, nʼoSiremu. ");
INSERT INTO gwr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Eryo niiryo eibyaire lya Yaakobbo nʼoBbirika, omugalama oLaabbaani oguyawaire oLaakeeri omwalawe. Eibyaire eryo babbaire bonabona abantu musanvu. ");
INSERT INTO gwr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Eibyaire lya Yaakobbo lyonalyona eryabire omu Misiri, babbaire abantu 66, nga tobaliireku abakali ba bataanebe. ");
INSERT INTO gwr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Obwoyimbya abataane ba Yusufu ababiri abeyabyariire omu Misiri, oku bantu bonabona abʼomu kisito kya Yaakobbo abaabire omu Misiri babba 70. ");
INSERT INTO gwr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Atyanu oYaakobbo nʼatuma oYuda okwekeerera okwaba eeri oYusufu amusabe abasangaane e Goseni. Era oYaakobbo ni batuuka omu kitundu ekyʼe Goseni. ");
INSERT INTO gwr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Awo oYusufu nʼategeka ekigaalikye, nʼayaba e Goseni okusangaana oYaakobbo oiteeye. Oweyamusangaine, nʼagwa oiteeye omu kifubba, era nʼakulumuca amaliga okumala ekiseera kiwanvu olwʼeisangaalo. ");
INSERT INTO gwr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kaisi oYaakobbo nʼakoba oYusufu ati, “Atyanu nʼowenfa, kasita nkuboineku ni mmanya nti okaali oliwo mwomi.” ");
INSERT INTO gwr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Awo oYusufu nʼakoba abagandabe nʼabantu abʼomu kisito kya iteeye ati, “Nteekwa okwaba nkobere oFalaawo nti abaganda bange nʼabantu bonabona abʼomu kisito kya bbaabba, ababbaire batyama omu kyalo kyʼe Kanani, baizire kutyama kumpi na nze. ");
INSERT INTO gwr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Njaba okumukobera nti muli baliisya, era muliisya byayo, era nti mwizire nʼebiraalo byʼentaama gyanywe, nʼembuli gyanywe, nʼente gyanywe, nʼebintu byanywe byonabyona ebimuli nabyo. ");
INSERT INTO gwr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","OFalaawo oweyabeeta nʼababuulya ati, ‘Mukola mulimoki?’ ");
INSERT INTO gwr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mwamwiramu muti, ‘Iswe, tubbaire baliisya okuzwa omu butobuto bwaiswe nʼokutuuca atyanu, ngʼabazeiza baiswe owebabbaire.’ Owemwamwiramu mutyo, mwezya okutyama omu kitundu ekyʼe Goseni. OYusufu yakobere atyo olwʼokubba aBamisiri babbaire bazuzuula okutyama aamo nʼabaliisya.” ");
INSERT INTO gwr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Awo oYusufu nʼayaba eeri oFalaawo, nʼamukoba ati, “Obbaabba nʼabaganda bange batuukire okuzwa omu kyalo kyʼe Kanani. Baizire nʼentaama nʼente gyabwe, nʼebintu byonabyona ebibali nabyo, era atyanu bali mwitwale lyʼe Goseni.” ");
INSERT INTO gwr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Era oYusufu nʼalondamu abataanu oku bagandabe nʼabatwala eeri oFalaawo. ");
INSERT INTO gwr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","OFalaawo nʼababuulya ati, “Mukola mulimoki?” Ni bamwiramu bati, “Iswe abaweereryabo, tuli baliisya ngʼabazeiza baiswe owebabbaire.” ");
INSERT INTO gwr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Era ni bongeraku bati, “Twizire kubbaaku omu kyalo kinu, olwʼokubba omu kyalo kyʼe Kanani enzala nene, era mpaayo nʼeisubi lyʼokuliisya ebyayo byaiswe. Kale atyanu, tukwegairiire, otwikirirye iswe abaweereryabo tubbe omwitwale lyʼe Goseni.” ");
INSERT INTO gwr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Awo oFalaawo nʼakoba oYusufu ati, “Atyanu oiteewo nʼabagandabo baizire egyoli, ");
INSERT INTO gwr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ate ngʼekyalo kyʼe Misiri kiri mu bwezyebwo. Obateeke awakira obujimu omu kyalo kinu ekyʼe Misiri, babbe omwitwale lyʼe Goseni. Era ooba ngʼomaite mwibo abayezya okulabirira ebisolo, obakwatisye ebyange babirabirire.” ");
INSERT INTO gwr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Awo oYusufu nʼatwala oYaakobbo oiteeye, era nʼamwanjula eeri oFalaawo. OYaakobbo nʼasabira oFalaawo enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","OFalaawo nʼabuulya oYaakobbo ati, “Oli nʼemyanka mimeka?” ");
INSERT INTO gwr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","OYaakobbo nʼamwiramu ati, “Mbaire oku kyalo okumala emyanka 130 nga nsengukasenguka. Emyanka egyo gibbaire migosi era mitono tigyenkanankana nʼegyʼabazeiza egibamalire oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Era oYaakobbo nʼasabira oFalaawo enkabi ngʼamuseebula, kaisi oYaakobbo nʼazwayo. ");
INSERT INTO gwr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Awo oYusufu nʼakola ngʼoFalaawo oweyamulagiire, nʼawa oiteeye nʼabagandabe eitakali batyamemu. Yabawaire mu kitundu kyʼe Lameseesi awakira obujimu omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","OYusufu nʼasuniranga oiteeye nʼabagandabe ebyokulya. Yasuniranga nʼabʼomu kisito kya iteeye bonabona ngʼoteekereku nʼabaana abakira obutobuto. ");
INSERT INTO gwr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Atyanu wabbaire mpaawo byokulya omu kyalo kyonakyona, kale enzala nʼebba nene ino, era abantu abʼomu Misiri nʼabʼomu Kanani ni bawaamu amaani olwʼenzala. ");
INSERT INTO gwr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","OYusufu ngʼagulya abantu engaano, nʼakumbaania empiiya gyonagyona egyʼomu kyalo kyʼe Misiri, nʼegyʼomu kyalo kyʼe Kanani, era nʼagitwala omu lubiri lwa Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Empiiya gyonagyona owegyawoire oku bantu bʼe Misiri, nʼabʼe Kanani, abantu bʼe Misiri bonabona ni baaba eeri oYusufu, ni bamukoba bati, “Otuwe ebyokulya. Lwaki otuleka ni tufa ngʼolingiriire. Empiiya gituwoireku.” ");
INSERT INTO gwr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","OYusufu nʼakoba ati, “Aale muleete ebyayo byanywe mbaweemu ebyokulya, abba ngʼempiiya gibawoireku.” ");
INSERT INTO gwr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kale ni batwaliranga oYusufu ebyayo byabwe nga iye abawaamu ebyokulya. Bamuwanga embalaasi, nʼentaama, nʼembuli, nʼente, nʼempunda. Era nʼabambuca omwanka ogwo ngʼomu byayo byabwe byonabyona abawaamu ebyokulya. ");
INSERT INTO gwr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Awo omwanka ogwo owegwawoireku, ni baaba egyali omu mwanka ogwairirireku, ni bamukoba bati, “Titwakubisabise musengwa waiswe. Ekikulu kiri kiti, empiiya gyaiswe gyonagyona gyatuwoireku, kaisi ngʼebyayo byaiswe byonabyona atyanu bibyo. Mpaawo ekindi ekitusigazire ekitwezya okukuwaamu, okutoolaku okukuwa obwomi bwaiswe nʼamatakali gaiswe. ");
INSERT INTO gwr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tiwatuleka ni tufa ni tuleka nʼamatakali gaiswe nga mpaamu bantu. Otugule iswe abanyere nʼamatakali gaiswe, otuweemu ebyokulya. Twabbanga bagalama ba Falaawo, nʼamatakali gaiswe gaabba gage. Otuwe engaano egyʼokulya kaisi titwafa, era otuwe nʼegyʼokusiga tusige emisiri gyaiswe.” ");
INSERT INTO gwr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kale awo oYusufu nʼagulira oFalaawo eitakali lyonalyona omu Misiri. Nabuli Mumisiri nʼatunda eitakalirye, olwʼokubba enzala yababitiriireku. Eitakali lyonalyona ni libba lya Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Abantu bʼomu Misiri okuzwa oku nsalo okutuuka oku nsalo egendi eyʼekyalo kyʼe Misiri, oYusufu nʼabasuuca bagalama ba Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Eitakali lyʼabakabona lyonkani niiryo erinandi nʼagula, olwʼokubba oFalaawo yaawanga abakabona ensako eyababbeesyangawo, kagira tibatundire amatakali gaabwe. ");
INSERT INTO gwr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Awo oYusufu nʼakoba abantu ati, “Mbagulire, inywe atyanu muli bantu ba Falaawo, era ni mbagulaku nʼamatakali gaanywe gona atyanu ga Falaawo. Kale ensigo nginu mwezye okusiga emisiri. ");
INSERT INTO gwr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Neye omu makungula, muli nʼokuwa oFalaawo ekitundu kimo oku bitundu ebitaanu ebyʼamakungula. Ebitundu ebina ebisigalawo, niibyo ebyabbanga ebyanywe ebyʼokusiga nʼokulya, inywe aamo nʼabʼomu bisito byanywe.” ");
INSERT INTO gwr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Abantu ni bakoba oYusufu bati, “Otulamirye okufa! Era musengwa twikiriirye okubba bagalama ba Falaawo olwʼokubba otulagire ekisa.” ");
INSERT INTO gwr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Awo oYusufu nʼateeka eiteeka omu Misiri erikaali liriwo paka lwatyanu, abantu okuwanga oFalaawo ekitundu ekimo oku bitundu ebitaanu ebyʼamakungula. Amatakali gʼabakabona gonkani niigo etigasuukire ga Falaawo. ");
INSERT INTO gwr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Atyanu aBaisirairi ni batyama omu kyalo kyʼe Misiri, omwitwale lyʼe Goseni. Era nga bali eeyo ni basuna ebyobusuni era ni babyalagana, ni beeyongera ino obungi. ");
INSERT INTO gwr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","OYaakobbo nʼamala emyanka ikumi na musanvu omu kyalo kyʼe Misiri, atyo nʼayerya emyanka 147. ");
INSERT INTO gwr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Oweyabbaire nga yatira okufa, nʼayeta omwanawe oYusufu, nʼamukoba ati, “Obwobba ngʼonseegaku kusani, okwate ansi oku kisambi kyange, kaisi olayire oti walindaga ekisa era nʼobba mwesigwa nandi nʼondiika omu Misiri. ");
INSERT INTO gwr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Wazira owenalifa ni nsenja abazeiza bange, walintoola omu Misiri, nʼoyaba nʼondiika mu kifo e gibaliikire abazeiza bange.” OYusufu nʼairamu ati, “Nalikola ekyonkobere.” ");
INSERT INTO gwr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","OYaakobbo nʼakoba ati, “Olayire oti walikola otyo.” Awo oYusufu nʼalayira era oYaakobbo nʼakotamya omutwe aawo oku buliribwe nʼasinza. ");
INSERT INTO gwr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Awo ekiseera owekyabitirewo, ni bakobera oYusufu bati oIteeye mulwaire. OYusufu nʼayaba nʼabataane bombi, oManase nʼEfulaimu okubona oYaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Era ni bakobera oYaakobbo bati, omwanawe oYusufu ayabire okumubona. OYaakobbo ni yeeyazya okusetuka, nʼatyama oku buliri. ");
INSERT INTO gwr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Era nʼakoba oYusufu ati, “OKibbumba oWabwezye Bwonabwona yambonekeire e Luuzi omu kyalo kyʼe Kanani, nʼampeera eeyo enkabi, ");
INSERT INTO gwr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","era nʼankoba ati, ‘Nalikuwa abaana bangi kaisi abaizukulubo ni mbasuuca mawanga amangi. Era naliwa eibyaireryo ekyalo kinu, ni kibba kyabwe emirembe gyonagyona.’ ");
INSERT INTO gwr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Atyanu abataanebo bombi, Efulaimu nʼoManase abewabyaliire omu kyalo kyʼe Misiri nga nkaali okwiza egyoli omu Misiri, mbatwala ngʼabange. Era baabbanga bataane bange ngʼoLubbeeni nʼoSimyoni obwebali. ");
INSERT INTO gwr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kaisi abaana abewalibyala abaira okwEfulaimu nʼoManase, niibo abalibba ababo, neye emiwuluko gyabwe baligisuna kwEfulaimu nʼoManase. ");
INSERT INTO gwr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ekyo nkikolere olwʼokubba nasunire enima mpitiriri oLaakeeri omaawo oweyanfeereireku omu kyalo kyʼe Kanani nga nzwa omu Padani. Yanfeereireku omu nzira nga wakaali wasigaireyo olugendo okutuuka omwEfulaasi, ni mmuliika eeyo okumpi nʼenzira eyaba omwEfulaasi ekibeeta e Bbeserekeemu.” ");
INSERT INTO gwr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","OIsirairi oweyaboine abataane ba Yusufu, nʼabuulya ati, “Abo niibo abanaani?” ");
INSERT INTO gwr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","OYusufu nʼairamu oiteeye oIsirairi ati, “Niibo abaana bange oKibbumba abampeereire aanu omu kyalo kyʼe Misiri.” OIsirairi nʼakoba ati, “Obaleete egyendi mbasabire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Amaiso ga Isirairi gabbaire goofuwaire olwʼobukaire, nga takaali abona kusani. OYusufu nʼamusembererya abaana. OIsirairi nʼabagwa omu bifubba. ");
INSERT INTO gwr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","OIsirairi nʼakoba oYusufu ati, “Nabbaire tinsuubira nga naliirayo okukubonaku. Neye atyanu oKibbumba anjikiriirye okubona nʼoku baanabo!” ");
INSERT INTO gwr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","OYusufu nʼabatoola omu bigere bya Isirairi, era nʼafuunama nʼaica empumi ansi okwitakali okumuwa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","OYusufu nʼabakwata bombi, Efulaimu omu ngaloye endiiro ngʼamusimbya oku lubba olwʼengalo engooda eya Isirairi. Era nʼakwata nʼoManase omu ngaloye engooda ngʼamusimbya oku lubba olwʼengalo endiiro eya Isirairi, nʼabasemberya egiri oIsirairi oiteeye. ");
INSERT INTO gwr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Neye oIsirairi nʼagolola engalogye, nʼagisalisyamu. Endiiro nʼagiica ku mutwe gwʼEfulaimu newankubbaire nga yabbaire niiye omutomuto waaku, kaisi engooda nʼagiica oku Manase omukulu waaku. ");
INSERT INTO gwr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Awo nʼasabira oYusufu enkabi ati, “OKibbumba, ozeiza wange oIbbulaimu nʼobbaabba oIsaka ogubaweereryanga, oKibbumba ondabiriirenge okuzwa omu butobuto bwange paka lwatyanu, owe abaana banu enkabi. ");
INSERT INTO gwr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Omalaika owannunwire mu buli kabbikabbi konakona, obawe enkabi. Eriina lyange nʼerya zeiza wange oIbbulaimu, nʼerya bbaabba oIsaka, okubita omu baana banu, abantu bageebukiryenge. Basune eibyaire linene oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","OYusufu oweyaboine ngʼoiteeye ateekere engaloye endiiro ku mutwe gwʼEfulaimu, ni kimunakuwalya. Nʼakwata engalo ya iteeye okugitoola oku mutwe gwʼEfulaimu, okugiteeka oku mutwe gwa Manase. ");
INSERT INTO gwr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","OYusufu nʼakoba oiteeye ati, “Bbaabba ekyokola tikituuce, olwʼokubba onu niiye omukulu. Oteeke engaloyo endiiro ku mutwegwe.” ");
INSERT INTO gwr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Cooka oiteeye nʼagaana. Nʼakoba ati, “Mmaite, mwana wange, mmaite. Eibyaire lya Manase lyona lyalisuuka igwanga, era balibba bakulu. Neye omutomuto oku Manase iye yalimukira obukulu, era eibyairerye lyalisuuka mawanga mangi.” ");
INSERT INTO gwr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kale awo nʼabasabira enkabi oku lunaku olwo ati, “ABaisirairi owebaabbanga basabira omuntu enkabi, bakolesyenge amaliina gaanywe, nga bakoba bati, ‘OKibbumba akusuuce obbe wʼenkabi ooti Efulaimu nʼoManase.’ ” OYaakobbo omu nkola eyo nʼabba akulirye Efulaimu okukiraku oManase. ");
INSERT INTO gwr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Awo Isirairi nʼakoba oYusufu ati, “Obone natira okufa, neye oKibbumba yaabbanga aamo na inywe, era yalibakanja omu kyalo kyʼabazeiza baanywe. ");
INSERT INTO gwr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Era iwe niiwe ogumpaire eitakali lyʼe Sekemu erijimu, erinalwaine ni ntoola oku Bamooli nga nkolesya ebirwana byange. Ndiwaire niiwe, neye tibagandabo.” ");
INSERT INTO gwr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Awo oYaakobbo nʼayeta abaanabe nʼabakoba ati, “Mukumbaane mbakobere ebyalibatuukaku egibwiza. ");
INSERT INTO gwr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mukumbaane baana bange, mumpulisisye nze oitewaanywe oYaakobbo. ");
INSERT INTO gwr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Lubbeeni, omwana wange omubere, niiwe ekibala kyʼamaani gange, omwana wange owʼomu maisuka, akira ekitiisya nʼamaani. ");
INSERT INTO gwr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Tolungamizika ooti maizi gʼamataba, kale tiwalibba mukulu. Ekyo kityo olwʼokubba weegaitire nʼomukali wange oku buliri bwange era nʼoyemula obuliri bwange nze oiteewo. ");
INSERT INTO gwr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Iwe Simyoni nʼoLeevi mufaanana empisa, mukwata empiima gyanywe okukola obuvuuyo. ");
INSERT INTO gwr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Tintaka okubeegaitaku omu nkiiko gyanywe, waire okubeegaitaku omu nkumbaana gyanywe. Ekyo kityo olwʼokubba omu busungu bwanywe, mwaitire abantu, era omwiralu lyanywe, mwatemere ebigere byʼente endaawo ni mubiremalya olwʼokwesangaalya. ");
INSERT INTO gwr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Kale atyanu obusungu bwanywe tibwirangayo okukola, nʼobukambwe bwanywe obwʼentiisya tibwirangayo okukola tete. Eibyaire lyanywe balirisalaanicirya omwIsirairi mwonamwona. ");
INSERT INTO gwr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Kaisi iwe Yuda, abagandabo bakuwuujanga. Bakotamyanga emitwe okukuwa ekitiisya, olwa iwe okuwangula abalabebo. ");
INSERT INTO gwr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Mwana wange Yuda, oli muzira ooti mpologoma akangire e giyeegonera ngʼamalire okweriira omuyiigo. Ompologoma oyo yeegonera ni yeegolola, nga mpaawo ayezya okumutaganya. ");
INSERT INTO gwr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yuda niiwe owakwatanga omwigo ogwʼobufugi, era omwibyaireryo niimwo omwazwanga abafugi, paka amawanga owegaligondera eibyaireryo. Era niiryo abantu eribagonderanga. ");
INSERT INTO gwr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Emizabbibbu gyʼeibyaireryo, gyabalanga ino. Nʼoyoza amaganduulago omu nviinyo, era nʼoyoza eganduulagyo omu mubisi gwʼemizabbibbu. ");
INSERT INTO gwr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Waabbanga nʼemizabbibbu mingi nʼolwekyo amaisogo gatukulikanga okukiraku enviinyo, era waabbanga nʼamata mangi nʼolwekyo amainogo gatukulanga okukiraku amata. ");
INSERT INTO gwr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Iwe Zebbulooni, eibyaireryo lyatyamanga kumpi nʼenyanza enene, eeyo e waabbanga omwalo emeeri egigituukira. Ensaloyo e mambuka yatuukanga paka mu kibuga e Sidoni. ");
INSERT INTO gwr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Kaisi iwe Isakaali, oli wʼamaani ooti mpunda, agonere aakati wʼemigugu mibiri. ");
INSERT INTO gwr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Cooka owaabona ngʼekifo omwawuumuliire kisa, era nga nʼekyalo kyesiimisya, agonda nʼaika ni bamuyeekesya emigugu, atyo nʼasuuka ooti muntu ogubakolesya emirimo emikalanguki. ");
INSERT INTO gwr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Iwe Daani waabbanga mwekubbemberi owa bantubo owʼamazima, ngʼebika ebindi ebya Isirairi. ");
INSERT INTO gwr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daani waabbanga wʼakabbikabbi ooti mpiri ali oku luguudo, era ooti nfulugundu ali oku nzira aluma ombalaasi ebigere, kaisi amutyaimeku nʼayanukaku nʼagwa.” ");
INSERT INTO gwr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Awo oYaakobbo nʼasaba ati, “Oo Musengwa, nkusaba onnunule.” ");
INSERT INTO gwr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Era oYaakobbo ni yeeyongera okulaamirya abaanabe ati, “Iwe Gaadi ekibinja ekyʼabanyagi kyalikulumba, neye walyerwanaku nʼokibbingirira. ");
INSERT INTO gwr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aseri, eitakaliryo lyabalanga ebyokulya ebyomutindo ogwʼangulu. Era ebyokulya ebiwalimanga niibyo okabaka ebiyalyanga. ");
INSERT INTO gwr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Kaisi iwe Nafutaali waabbanga nʼeidembe okukola ekyotaka ooti kisolo wʼomu kigona ogubeeta bati kimaadu ataayuuka-obutaayuuki, era nʼabyala abaana ababoneka okusani. ");
INSERT INTO gwr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Iwe Yusufu waabbanga kibyali ooti kikolo kyʼomuzabbibbu ekibala eino, era nga kiri kumpi nʼeiruba erikulumuka amaizi, era eibyaireryo lyabbanga ooti kikolo ekiri nʼamasaga agalandire ni gawoisya omugingi. ");
INSERT INTO gwr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abalabebo bakulumbire nʼobukambwe, era ni bakulwanisya nʼebirwana byabwe nga babula kisa. ");
INSERT INTO gwr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Neye wagumiirye nakimo ekirwanakyo, nʼengalogyo ni gisuna amaani agazwa eeri oWabwezye oKibbumba wa Yaakobbo, oMulabiriri afaayo oku ntaama, era oMukuumi wa Isirairi. ");
INSERT INTO gwr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","OKibbumba oyo oiteewo ogwasinza, akubbeerenge, era oyo oWabwezye Bwonabwona akuwenge enkabi egyo egizwa omwigulu, nʼenkabi egizwa ansi omwitakali, nʼenkabi egyʼokusuna eibyaire nʼebisolo. ");
INSERT INTO gwr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Oleke enkabi egyosuna okuzwa egiri oiteewo, gikirire nakimo enkabi egizwa omu nsozi, ensozisozi egibbaawo emirembe nʼemirembe. Era gikirire kimo nʼebintu ebisa ebizwa oku busozi obwabbairewo okuzwa eira. Kale Yusufu, nkusabira enkabi egyo obbenge nagyo. Ekyo kityo olwʼokubba niiwe ogubalitongola okuzwa omu bagandabo, ngʼomwekubbemberi owʼensikirano. ");
INSERT INTO gwr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Kaisi iwe Bbenyamini waabbanga ooti musege ogukaavuula omuyiigo amakeezi, kaisi eigulo ni gumaliiriryawo ogusigaire.” ");
INSERT INTO gwr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Eikumi na babiri abo niibo abazeiza bʼebika eikumi na bibiri ebya Isirairi. Era ebyo niibyo ebibono oitewaabwe ebiyabalaamiirye nabuli moiza ngʼowebimusaaniire. ");
INSERT INTO gwr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Awo oYaakobbo nʼakalaatira abaanabe, nʼabakoba ati, “Ndi kumpi okufa mbe neeyimbirye oku bazeiza bange. Munteekanga aamo nabo omu mpuku eeri omwitakali eryabbaire eryʼEfulooni oMukiiti, ");
INSERT INTO gwr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","e Makupera, e buzwaisana bwʼe Mamule, omu kyalo kyʼe Kanani. OIbbulaimu yagulire empuku eeyo nʼeitakali eryo okwEfulooni oMukiiti, okubba ekifo ekyʼokuliikangamu abafu. ");
INSERT INTO gwr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Era omu mpuku omwo niimwo omu bateekere amagumba ga Ibbulaimu nʼaga Saala omukaliwe. Era niimwo omu bateekere oIsaka nʼomukaliwe oLabbeeka, era niimwo omu nateekere omukali wange oLeeya. ");
INSERT INTO gwr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Eitakali nʼempuku erimu, babigulire ku Bakiiti.” ");
INSERT INTO gwr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Awo oYaakobbo oweyamalire okukalaatira abaanabe, nʼasetula ebigerebye nʼairawo oku buliribwe nʼagona, era nʼafa, atyo nʼabba yeeyimbirye oku bazeizabe. ");
INSERT INTO gwr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Awo oiteeye wa Yusufu oweyafiire, oYusufu ni yeemuma okwiteeye nga waakunga era nga wamwevambiryaku. ");
INSERT INTO gwr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","OYusufu nʼalagira abaweereryabe abasawo, okukola oku mulambo gwa iteeye okutavunda mangu. Era abasawo ni bakola ngʼoYusufu oweyabalagiire. ");
INSERT INTO gwr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ni bamala enaku 40 nga bagukolaku okutavunda mangu, era nga niigyo enaku egibamalanga bulijo okukola oku mulambo okutavunda mangu. ABamisiri ni bamala enaku 70 nga bamukunga. ");
INSERT INTO gwr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Enaku egyʼokumukunga owegyawoireku, oYusufu nʼakoba abakungu ba Falaawo ati, “Obwemba ndi mukoda egimuli, mbegairiire mwabe munkobereku oFalaawo muti, ");
INSERT INTO gwr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","obbaabba oweyabbaire yatira okufa yandayirisirye okumuteeka mu magombe gʼempuku ageyategekere omu kyalo kyʼe Kanani. Kale anjikirirye njabe ndiike obbaabba kaisi njire.” ");
INSERT INTO gwr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Awo oFalaawo nʼaikirirya okusaba kwa Yusufu era nʼamukoba ati ayabe aliike oiteeye, ngʼoweyamulayirisirye. ");
INSERT INTO gwr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kale oYusufu nʼayaba nʼaliika oiteeye. Era abakungu ba Falaawo bonabona omwo nga mulimu abalamuzi nʼabantu abakulu abandi bonabona omu kyalo kyʼe Misiri, ni bamwereka. ");
INSERT INTO gwr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Era kwabo kwegaitireku abʼomu kisito kya Yusufu bonabona, nʼabagandabe, nʼabʼomu kisito kya iteeye bonabona. E Goseni wasigaireyo baana baabwe abatobato, nʼentaama, nʼembuli, nʼente gyabwe. ");
INSERT INTO gwr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Era oYusufu nʼayaba nʼabaisirikale abʼoku bigaali, nʼabʼoku mbalaasi, kale ni kibba ekiziima kinene ino. ");
INSERT INTO gwr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Owebayambukire omwiga oYoludaani ni batuuka omu kifo ekibeeta Atadi e gibakonera engaano, ni babba omu mazingo gʼamaani. OYusufu nʼakola eeyo omukolo ogwʼokukunga oiteeye okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Abatyami bʼomu Kanani owebaboine abantu abo, nga bakuukulirya omu kifo e gibakonera engaano ekyʼAtadi, ni bakoba bati, “ABamisiri bali kukola mukolo gwʼokukunga mufu.” Era kagira ekifo ekyo ekiri okumpi nʼomwiga oYoludaani bakiwaire eriina bati, Abberi Mizulayimu. ");
INSERT INTO gwr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kale abaana ba Yaakobbo ni bakola ngʼoitewaabwe oweyabbaire abalagiire. ");
INSERT INTO gwr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ni baginga omulambogwe, ni bagutwala omu kyalo kyʼe Kanani, ni baguteeka omu mpuku eyʼomwitakali lyʼe Makupera, okumpi nʼekibuga kyʼe Mamule. Empuku eyo aamo nʼeitakali eryo oIbbulaimu niiye eyagulire okuliikangamu abafu era yaligulire kwEfulooni oMukiiti. ");
INSERT INTO gwr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","OYusufu oweyamalire okuliika oiteeye, nʼakanga omu Misiri nʼabagandabe, era nʼabantu bonabona abeyabbaire ayabire nabo okuliika oiteeye. ");
INSERT INTO gwr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Awo abaganda ba Yusufu owebaboine ngʼoitewaabwe amalire okufa, ni bakoba bati, “Amo-so oYusufu nʼatucaawa okwesasula ebintu ebitali bisa ebitwamukolere!” ");
INSERT INTO gwr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kale ni baweererya oYusufu obukwenda bati, “Obbaabba oweyabbaire ngʼakaali okufa, ");
INSERT INTO gwr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","yatukobere tukusabe otusoniye omusango ogutwabbengere owetwakusobyeryeku. Era atyanu tukwegairiire otusoniye omusango ogutwakubbengereku iswe abaweererya ba Kibbumba wa iteewo.” OYusufu oweyawuliire obukwenda obwo, nʼakunga amaliga. ");
INSERT INTO gwr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Awo abagandabe ni baaba egiri oYusufu, ni bakotamya emitwe gyabwe omumaisoge okumuwa ekitiisya, nga bakoba bati, “Ngonu tuli bategeke okubba baweereryabo.” ");
INSERT INTO gwr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Neye oYusufu nʼabakoba ati, “Timwatya! Timpezya kweteeka omu kifo kya Kibbumba asoniya abantu. ");
INSERT INTO gwr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Inywe mwagendereire okunkola akabbikabbi, neye oKibbumba nʼakisuucaamu kintu ekisa atyanu okulamya obwomi obwʼabantu abangi. ");
INSERT INTO gwr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kale dala timwatya. Nabalabiriranga nʼabaana baanywe.” Atyo nʼabagumya nʼebibono ebyʼekisa. ");
INSERT INTO gwr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","OYusufu ni yeeyongera okubba omu Misiri nʼabʼekisito kya iteeye bonabona, era nʼawangaala emyanka 110. ");
INSERT INTO gwr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yawangaire era nʼabonaku abaana nʼabaizukulu bʼEfulaimu. Era nʼalera nʼoku baana ba mwizukulu oMakiri omutaane wa Manase era nʼabatongola okubba bamo okwibyairerye. ");
INSERT INTO gwr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Awo oYusufu nʼakoba abagandabe ati, “Ndi kumpi okufa, neye oKibbumba mazima yalibabbeera, nʼabalungamya ni muzwa omu kyalo kinu ekyʼe Misiri. Yalibakanja omu kyalo ekiyalayiire okuwa oIbbulaimu, nʼoIsaka, nʼoYaakobbo.” ");
INSERT INTO gwr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Era oYusufu nʼalayiza abaana ba Isirairi ngʼabakoba ati, “OKibbumba oweyalibabbeera era nʼabalungamya okukanga e Kanani, mwaliteekwa okwaba nʼamagumba gange okugatoola omu kyalo kinu.” ");
INSERT INTO gwr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kale oYusufu nʼafeera omu Misiri, nga wʼemyanka 110. Era owebamalire okukola oku mulambogwe okutavunda mangu, ni baguteeka omu sanduuku.");
INSERT INTO gwr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ganu niigo amaliina gʼabaana ba Isirairi, ogubeeta oYaakobbo abeyaabire nabo omu kyalo kyʼe Misiri, aamo nʼabʼomu bisito byabwe: ");
INSERT INTO gwr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","OLubbeeni, nʼoSimyoni, nʼoLeevi, nʼoYuda; ");
INSERT INTO gwr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","nʼoIsakaali, nʼoZebbulooni, nʼoBbenyamini; ");
INSERT INTO gwr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","nʼoDaani, nʼoNafutaali, nʼoGaadi, nʼAseri. ");
INSERT INTO gwr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abantu bonabona abʼeibyaire lya Yaakobbo abaabire e Misiri babbaire 70, ngʼobaliireku oYusufu eyabbaire yaabire eira omu Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ebiseera owebyabitirewo, oYusufu nʼabagandabe nʼabantu bonabona abandi abʼomu mugigi ogwo, ni bafa. ");
INSERT INTO gwr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Neye abaizukulu baabwe ni babyalagana, ni babitirira ino obungi. Era ni baizula omu kyalo kyʼe Misiri nabuli wantu. ");
INSERT INTO gwr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Awo nga wabitirewo emyanka mingi, ni waizawo omu bwezye okabaka ogondi omu kyalo kyʼe Misiri eyabbaire tamaite ebifa oku Yusufu. ");
INSERT INTO gwr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Okabaka oyo nʼakoba abantube ati, “Aale mubone, aBaisirairi batubitiriireku ino obungi, era batukira amaani. ");
INSERT INTO gwr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Atyanu tubasalire amalabuki, kaisi tibeeyongera obungi. Ekyo kityo olwʼokubba singa abalabe baiswe batanula olutalo okutulwanisya, aBaisirairi abo bayinza okubeeyimbyaku ni batulwanisya kaisi awo ni batwirukaku okuzwa omu Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Nʼolwekyo aBamisiri ni basuuca aBaisirairi bagalama baabwe. Era ni babateekaku abanyampala okubagadya nʼokubakolesya emirimo emikalanguki. Era ni bombekera oFalaawo ekibuga Pitomu, nʼekindi Lameseesi, okukola ngʼesitoowa gyʼebintu. ");
INSERT INTO gwr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Neye aBamisiri egibakomerye okugadya aBaisirairi, nʼaBaisirairi gibakomerye okweyongera obungi nʼokusalaana omu kyalo ekyo. Kale aBamisiri ni beeraliikirira olwʼaBaisirairi, ");
INSERT INTO gwr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","era ni bakolesya aBaisirairi emirimo na itima. ");
INSERT INTO gwr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ABaisirairi ni babba omu bwomi obukalanguki, ngʼaBamisiri babakaka okukubba amatafaali nʼokutabula opuyo ogubakolesya omu kwombeka, omu bukalubo, nʼokukola omu misiri gyabwe. Omu mirimo egibakolanga gyonagyona, aBamisiri babakolesyanga na itima. ");
INSERT INTO gwr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Awo okabaka wʼe Misiri nʼakoba oSifula nʼoPuwa, abakali abo ababyalisyanga abakali aBeebbulaniya, ati, ");
INSERT INTO gwr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Owemwabbanga mubyaliisya abakali aBeebbulaniya, ni mubona ngʼomwana mwisuka, mumwitenge. Neye nga mwala, mumulekenge nʼabba mwomi.” ");
INSERT INTO gwr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Neye ababyalisya abo ni batya oKibbumba, nandi ni bakola ngʼokabaka wʼe Misiri oweyabalagiire, ni balekanga abaana abaisuka nga boomi. ");
INSERT INTO gwr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kale okabaka wʼe Misiri nʼayetesya ababyalisya abo, nʼababuulya ati, “Lwaki muli kukolanga kiikyo? Lwaki muli kulekanga abaana abaisuka nga boomi?” ");
INSERT INTO gwr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ababyalisya ni bamwiramu bati, “Abakali aBeebbulaniya tibali ooti bakali aBamisiri. Ekyo kityo olwʼokubba ibo tibakaluba omu kubyala, tubba tukaali okubatuukaku nga bamalire ira okubyala.” ");
INSERT INTO gwr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Kale awo oKibbumba nʼawa ababyalisya abo enkabi, era aBaisirairi ni beeyongera obungi. ");
INSERT INTO gwr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Era olwʼokubba ababyalisya abo bawaire oKibbumba ekitiisya, oKibbumba nʼabawa eibyaire. ");
INSERT INTO gwr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Awo oFalaawo nʼalagira abantube bonabona ati, “Nabuli mwana omwisuka oMwebbulaniya oguyabyalanga, mumumumenge mu mwiga oKiyira, neye nabuli mwana omwala mumulekenge nʼabba mwomi.” ");
INSERT INTO gwr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Atyanu omu biseera aBaisirairi owebabbeereire abagalama bʼaBamisiri, wabbairewo omusaiza owʼekika kyʼaBaleevi, eyafumbiirwe omukali nga yena wʼomu kika ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Omukali oyo nʼabba kida, era nʼabyala omwana mwisuka. Oweyaboine ngʼomwana aboneka kusani ino, nʼamubisa okumala emyeri misatu. ");
INSERT INTO gwr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Neye oweyaboine nga takaali ayezya okweyongera okumubisa, nʼasuna ogudubi gwʼentooko, nʼagusiigaku opati. Awo nʼateekamu omwana oyo kaisi nʼaguteeka omu bitooko oku mbale kwʼomwiga oKiyira. ");
INSERT INTO gwr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Iye omwonyoko wʼomwana nago nʼayaba nʼayemerera yalaku, kaisi nʼalingirira okubona ekyatuuka oku mwana oyo. ");
INSERT INTO gwr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Awo omwala wa Falaawo nʼaserengeta oku mwiga oKiyira okunaaba, ibo abakali abaweereryabe nga bali kutambulatambulanga oku mbale kwʼomwiga ogwo. Awo omwala wa Falaawo nʼalengera ogudubi omu bitooko, nʼatuma omoiza oku bakali abaweereryabe okuguleeta. ");
INSERT INTO gwr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Omwala wa Falaawo oweyasaanukwire ogudubi, nʼabonamu omwana. Era ngʼomwana ali kukunga nʼamukwatira ekisa, kaisi nʼakoba ati, “Onu moiza oku baana bʼaBeebbulaniya!” ");
INSERT INTO gwr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Awo omwonyoko nago owʼomwana nʼaigerera nʼabuulya omwala wa Falaawo ati, “Njabe nkwetere omoiza oku bakali aBeebbulaniya akwonkeserye omwana oyo?” ");
INSERT INTO gwr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Omwala wa Falaawo nʼamwiramu ati, “Kale oyabe omwete.” Era omwala oyo nʼayaba nʼayeta maaye wʼomwana oyo. ");
INSERT INTO gwr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Awo omwala wa Falaawo nʼakoba omukali nago ati, “Otwale omwana onu omunnyonkeserye, nalikuwa empeera.” Kale omukali oyo nʼatwala omwana era nʼamwonkesya. ");
INSERT INTO gwr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Atyanu omwana oweyakulire, omukali oyo nʼamutwalira omwala wa Falaawo. Omwala wa Falaawo nʼamusuuca mutaanewe, era nʼamuwa eriina ati Musa, olwʼokubba yakobere ati, “Namutoire mu maizi.” ");
INSERT INTO gwr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Lwabbaire lumo, nga wabitirewo emyanka mingi, era nʼoMusa ngʼakulire, nʼawuluka omu lubiri nʼayaba okucaalira abʼeigwangalye aBeebbulaniya. Oweyatuukire eeyo nʼabona nga babagadya, era nʼabona nʼoMumisiri ngʼakubba oMwebbulaniya, omoiza oku bʼeigwanga lya Musa. ");
INSERT INTO gwr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","OMusa nʼalolyamika oku lubba nʼolubba, nʼabona nga mpaawo muntu, awo nʼaita oMumisiri, era nʼamuliika omu musenye. ");
INSERT INTO gwr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Oku lunaku olwairireku, tete oMusa nʼawuluka omu lubiri nʼakangayo, nʼabona abasaiza aBeebbulaniya babiri nga balwana, nʼakoba odi omusobya ati, “Niki ekigira okubba omwinawo?” ");
INSERT INTO gwr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Neye omusaiza nago nʼamwiramu ati, “Naani eyakusuucirye omufugi era omulamuzi waiswe? Otaka kunjita ngʼowewaitire oMumisiri?” Kale awo oMusa nʼatya, nʼakoba omu mwoyogwe ati, “Abantu bategeire ekintu ekinakolere!” ");
INSERT INTO gwr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","OFalaawo oweyawuliire ebyabbairewo, nʼataka okwita oMusa. Neye oMusa nʼamwirukaku nʼayaba okutyama omu kyalo kyʼe Midiyaani. Era oweyatuukire eeyo yaabire nʼatyama okwiruba. ");
INSERT INTO gwr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Atyanu okabona wʼe Midiyaani yabbaire nʼabaala musanvu. Abaala abo ni baiza okusena amaizi, baizulye ebintu byʼamaizi banywisye entaama nʼembuli gya itewaabwe. ");
INSERT INTO gwr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Neye abaliisya abandi ni baiza ni bababbingawo. Kale oMusa nʼasetuka nʼabbeera abaala abo era nʼasena amaizi nʼanywisya embuli nʼentaama gyabwe. ");
INSERT INTO gwr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Owebakangire eeri oLeweri ogubeeta oYesero oitewaabwe, nʼababuulya ati, “Nga mwirire mangu olwatyanu?” ");
INSERT INTO gwr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ni bamwiramu bati, “Omusaiza owʼe Misiri niiye atulamirye abaliisya, era nʼatusenera amaizi, nʼanywisya ebisolo byaiswe.” ");
INSERT INTO gwr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Awo nʼabuulya abaalabe ati, “Omusaiza nago ali yaina? Lwaki mumulekereyo? Mwabe mumwete aize alyeku ebyokulya.” ");
INSERT INTO gwr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Kale oMusa nʼaikirirya okwaba era nʼasalawo okutyama nʼokabona nago oLeweri, era nʼawa oMusa omwalawe oZipola okumufumbirwa. ");
INSERT INTO gwr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","OZipola nʼabyala omwana omwisuka, oMusa nʼamuwa eriina ati, Geresomu, olwʼokubba yakobere ati, “Ndi musenze omu kyalo ekitali kyʼe waiswe.” ");
INSERT INTO gwr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Oluzwanyuma lwʼemyanka mingi, oFalaawo nʼafa. Neye aBaisirairi ni basigala nga bakaali bakaanya olwʼobugalama bwabwe. Ni bakunga, era owebakungire nga bataka obubbeeri, okukunga kwabwe ni kutuuka eeri oKibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","OKibbumba nʼawulira okukunga kwabwe, nʼayebukirya endagaanoye egiyakolere nʼoIbbulaimu, nʼoIsaka, nʼoYaakobbo. ");
INSERT INTO gwr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","OKibbumba nʼabona aBaisirairi nga bagada, era nʼabalumirwa. ");
INSERT INTO gwr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Lwabbaire lumo oMusa ngʼaliisya ekiraalo kyʼentaama nʼembuli gya kabona wʼe Midiyaani, nʼakibitya omwidungu, nʼatuuka e Kolebbu, oku lusozi lwa Kibbumba. Okabona oyo babbaire bamweeta Yesero oiteeye wa mukaliwe. ");
INSERT INTO gwr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","OMusa ngʼali eeyo oku lusozi aliisya, omalaika wa Musengwa nʼamubonekera omu ndimi gya musyo aakati omu kisaka. OMusa nʼabona ekisaka nga kyaka, neye nga tikiya. ");
INSERT INTO gwr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","OMusa nʼakoba ati, “Oleke njigerere mbone ekintu kinu ekyewuunyisya, lwaki ekisaka tikiya.” ");
INSERT INTO gwr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","OMusengwa oweyaboine ngʼoMusa aigereire okubona, nʼamweta ati, “Musa, Musa!” OMusa nʼayetuka ati, “Waitu!” ");
INSERT INTO gwr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","OKibbumba nʼakoba ati, “Tiweeyongera okwigerera eenu. Otoolemu ebiraitobyo olwʼokubba ekifo ekyo ekyoyemereiremu kitukulye.” ");
INSERT INTO gwr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Era nʼakoba ati, “Ninze oKibbumba wa iteewo, era wa Ibbulaimu, era wa Isaka, era wa Yaakobbo.” OMusa oweyawuliire ebyo ni yeebiika omumaiso, olwʼokubba yatiire okulola oku Kibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Awo oMusengwa nʼakoba ati, “Mboneire nakimo okugada kwʼabantu bange abali omu Misiri, era mpuliire okukunga kwabwe, nga basaba okubataasa abo ababakolesya obugalama. Era atyanu mmaite okugada okubalimu. ");
INSERT INTO gwr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kale kagira njikire ni njiza okubataasa obufugi bwʼaBamisiri, nʼokubatoola omu kyalo ekyo, mbatwale omu kyalo ekijimu era ekigalami. Ekyalo ekinabatwalamu kirimu ebyobusuni era kiizwire amata nʼomujenene. Era nga kyalo ekirimu aBakanani, nʼaBakiiti, nʼaBamooli, nʼaBaperizi, nʼaBakiivi, nʼaBayebbusi. ");
INSERT INTO gwr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Era mpuliire okukunga kwʼaBaisirairi, era mboine engeri aBamisiri egibabagadyamu. ");
INSERT INTO gwr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kale atyanu, nkutuma oyabe eeri oFalaawo, otooleyo abantu bange aBaisirairi omu kyalokye.” ");
INSERT INTO gwr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Neye oMusa nʼairamu oKibbumba ati, “Ninze onaani ali nʼokwaba egiri oFalaawo era nʼokutoola aBaisirairi e Misiri?” ");
INSERT INTO gwr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","OKibbumba tete nʼamukoba ati, “Nalibba aamo na iwe era owewalimala okutoola abantu abo e Misiri, mwalinsinzira oku lusozi lunu, era ako niiko akamanyiciryo akalikukakasa nga ninze nkutumire.” ");
INSERT INTO gwr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Neye oMusa nʼabuulya oKibbumba ati, “Olwo owenalituuka egiri aBaisirairi ni mbakobera nti, ‘OKibbumba wʼabazeiza baanywe antumire egimuli,’ kaisi ni bambuulya bati, ‘Eriinalye niiye onaani?’ Nalibakoba ntya?” ");
INSERT INTO gwr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","OKibbumba nʼakoba oMusa ati, “NINZE NDI.” Wakoba aBaisirairi oti, “NDI niiye antumire egimuli.” ");
INSERT INTO gwr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","OKibbumba era nʼakoba oMusa ati, “ABaisirairi wabakoba oti, NDI, oKibbumba wʼabazeiza baanywe, iye oKibbumba wa Ibbulaimu, era wa Isaka, era wa Yaakobbo, niiye antumire egimuli. Eryo niiryo eriina lyange abantu abʼemirembe nʼemirembe eribanjebukiriryangaku. ");
INSERT INTO gwr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Oyabe okumbaanie aamo abeekubbemberi bʼaBaisirairi, kaisi obakobe oti, ‘OMusengwa iye oKibbumba wʼabazeiza baanywe, iye oKibbumba wa Ibbulaimu, era owa Isaka, era owa Yaakobbo, yambonekeire nʼankoba ati, “Mbaire nga neekeenenya ebibafaaku era mboine ebibabakolere e Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Era nsalirewo okubatoola omu kyalo kyʼe Misiri e gibabagadirya, mbatwale omu kyalo ekirimu aBakanani, nʼaBakiiti, nʼaBamooli, nʼaBaperizi, nʼaBakiivi, nʼaBayebbusi. Ekyalo ekyo ekirimu ebyobusuni era kiizwire amata nʼomujenene.” ’ ");
INSERT INTO gwr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Abantu bange baliwulisisya ekiwalibakoba. Awo iwe nʼabeekubbemberi ba Isirairi, mwalyaba egiri oFalaawo, ni mumukoba muti, ‘OMusengwa iye oKibbumba wʼaBeebbulaniya yatubonekeire. Kale atyanu tukwegairira, otwikirirye tutambule olugendo lwʼenaku isatu omwidungu, twabe tuweeyo esadaaka eeri oMusengwa iye oKibbumba waiswe.’ ");
INSERT INTO gwr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Neye mmaite kusani ngʼoFalaawo tiyalibaikirirya okwaba, okutoolaku nga kumwazya nʼamaani. ");
INSERT INTO gwr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Nʼolwekyo nalikolesya obwezye bwange ni mbonereza aBamisiri nga nkola ebyewunyo. Owenalimala okukola ntyo, yalibaikirirya ni mwaba. ");
INSERT INTO gwr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Era nalyezyesya aBaisirairi okubba nʼobukoda eeri aBamisiri, olwo awo owemwalibba musimbuka, nandi ni muzwayo nʼengalo enjereere. ");
INSERT INTO gwr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Neye nabuli mukali oMwisirairi, yalyaba egiri omukali oMumisiri omuliranwawe, nʼe giri omukali oMumisiri yenayena ogwasuza, nʼamusaba ebizwalo nʼebintu ebyʼefeeza nʼebyʼezaabbu. Ebintu ebyo mwalibizwalisya abataane baanywe nʼabaala baanywe, mutyo ni mutwala obusuni obwʼaBamisiri.” ");
INSERT INTO gwr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Awo oMusa nʼairamu oMusengwa ati, “Neye tibaliikirirya era tibaliwulisisya ekinalibakoba, olwʼokubba balinkoba bati, ‘Tiyakubonekeire.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Awo oMusengwa nʼamubuulya ati, “Niki ekyo ekyokwaite?” OMusa nʼairamu ati, “Mukoomero.” ");
INSERT INTO gwr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","OMusengwa nʼamukoba ati, “Ogumume ansi.” Era oMusa nʼagumuma ansi, ni gusuuka mpiri, awo oMusa nʼairaku e nyuma okuzwa ompiri e gyali. ");
INSERT INTO gwr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Neye oMusengwa nʼakoba oMusa ati, “Okotame, omukwate omukira.” Kale oMusa nʼakotama, nʼakwata ompiri, era ompiri nʼasuuka mukoomero omu ngaloye. ");
INSERT INTO gwr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","OMusengwa nʼakoba ati, “Wakola ekyo kaisi aBaisirairi baikirirye bati oMusengwa iye oKibbumba wʼabazeiza baabwe, ekikoba kiti, oKibbumba wa Ibbulaimu, nʼoIsaka, nʼoYaakobbo, yakubonekeire.” ");
INSERT INTO gwr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","OMusengwa tete nʼakoba oMusa ati, “Oteeke engalo omu kizibaabokyo.” Kale oMusa nʼateeka engalo omu kizibaabokye. Atyanu oweyagitoiremu, yabbaireku obulwaire obwʼoku lususu ooti bigenge, era nga lweru ooti bbalaafu. ");
INSERT INTO gwr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Awo oMusengwa nʼakoba ati, “Tete okubbye engaloyo omu kizibaabokyo.” Kale oMusa nʼagikanjaamu. Atyanu oweyagitoiremu, yabbaire eirirewo, nga nsa ngʼebitundu ebindi ebyʼomubirigwe. ");
INSERT INTO gwr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Awo oMusengwa nʼakoba ati, “Owebataliikirirya era singa tibalimatira akamanyiciryo kʼekyewunyo akasookere, baliikirirya ako akokubiri. ");
INSERT INTO gwr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Neye singa tibaliikirirya obumanyiciryo bwʼebyewunyo obwo bwombi era singa tibaliwulisisya ebyokoba, walisenaku amaizi gʼomwiga oKiyira nʼogasuka oku lukalu. Amaizi ago galisuuka musaaye oku lukalu.” ");
INSERT INTO gwr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Neye oMusa nʼakoba oMusengwa ati, “Oo Musengwa, timbangaku mutumuli omusa okuzwa eira nʼeira, waire okuzwera owootandiikiire okutumula na nze omuweereryawo. Ekyo kityo olwʼokubba tindi omutumuli omusa, era ndi muguguma.” ");
INSERT INTO gwr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","OMusengwa nʼabuulya oMusa ati, “Naani ayezesya omuntu okutumula? Naani asalawo omuntu okubba obbubbu, ooba omasiipe? Naani ayezesya omuntu okubba abona ooba omwofu? Tininze oMusengwa? ");
INSERT INTO gwr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Aale atyanu oyabe, nalikwezesya okutumula, era nalikuwa ebyokutumula.” ");
INSERT INTO gwr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Neye oMusa nʼamwiramu ati, “Oo Musengwa, nkwegairiire, otume muntu gondi.” ");
INSERT INTO gwr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Awo oMusengwa nʼasunguwalira ino oMusa, nʼakoba ati, “Omugandawo Alooni oMuleevi taliwo? Mmaite ngʼayezya okutumula kusani. Era atyanu aiza okukusangaana, era oweyakubona yasangaala. ");
INSERT INTO gwr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Kale iwe watumulanga naye, nʼomukobera ebiyatumula. Era nabeezesyanga mwembi okutumula, era nabakoberanga ekyokukola. ");
INSERT INTO gwr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Alooni niiye eyakutumuliranga eeri abantu. Era yaabbanga niiye omutumuliwo era wena eeri iye wabbanga ooti Kibbumba, nga niiwe omukobera ekiyatumula. ");
INSERT INTO gwr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Atyanu oyabe nʼomukoomero ogwo, olwʼokubba guwalikolesya obumanyiciryo wʼebyewunyo.” ");
INSERT INTO gwr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Awo oMusa nʼakanga egiri oYesero oiteeye wa mukaliwe, nʼamukoba ati, “Nkwegairiire, oleke nkange eeri abʼeigwanga lyange omu Misiri, mbone embeera egibalimu.” OYesero nʼakoba oMusa ati, “Oyabe mwidembe.” ");
INSERT INTO gwr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Atyanu ngʼekyo kikaali okubbaawo, era ngʼoMusa akaali okuzwa e Midiyaani, oMusengwa yabbaire amukobere ati, “Okange e Misiri, olwʼokubba abantu bonabona ababbaire bataka okukwita, bafiire.” ");
INSERT INTO gwr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Nʼolwekyo oMusa nʼakwata omukaliwe nʼabaanabe, nʼabaniinia oku mpunda, nʼasimbuka nabo okukanga e Misiri, ngʼakwaite omukoomero oKibbumba oguyamukobere okwaba nagwo. ");
INSERT INTO gwr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Atyanu oMusa oweyabbaire ngʼakanga e Misiri, oMusengwa nʼamukoba ati, “Oli nʼokukolera omumaiso ga Falaawo ebyewunyo byonabyona ebinkuwaireku obwezye okukola. Neye nalikakanyalya omwoyo gwa Falaawo, nʼagaana aBaisirairi okwaba. ");
INSERT INTO gwr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Era awo walimukoba oti, oMusengwa akoba ati, ‘OIsirairi niiye omwana wange omubere. ");
INSERT INTO gwr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Nakukobere nti oleke omwana wange ayabe kaisi ayezye okunsinza, neye iwe nʼogaana. Kale atyanu njaba kwita omutaanewo omubere.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Atyanu oMusa nʼabʼomu kisitokye owebabbaire nga baaba e Misiri, era nga bali omu kifo e gibagonere obwire, oMusengwa nʼabonekera oMusa, era nʼataka okumwita. ");
INSERT INTO gwr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Awo oZipola omuka Musa, nʼakwata eibbaale eryogi, nʼakomolera omutaanewe, kaisi nʼakwata ekigode ekyo nʼakibitya oku bigere bya Musa, ngʼakoba ati, “Atyanu dala osuukire ibawange owʼomusaaye!” ");
INSERT INTO gwr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Awo oMusengwa nʼaleka oMusa nʼabba mwomi. Era olwʼomukolo ogwo ogwʼokukomola, niigwo ogwazwereireku oZipola okukoba oMusa ati, “Atyanu dala osuukire ibawange owʼomusaaye!” ");
INSERT INTO gwr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Atyanu oMusengwa nʼakoba Alooni ati, “Oyabe omwidungu osangaane oMusa.” Kale nʼayaba nʼamusangaana oku lusozi lwa Kibbumba, era oweyamusangaanire nʼamugwa omu kifubba. ");
INSERT INTO gwr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Awo oMusa nʼakobera Alooni byonabyona oMusengwa ebiyabbaire amutumire okutumula omu Misiri, era nʼamukobera nʼobumanyiciryo bwʼebyewunyo bwonabwona, obuyamulagiire okukola. ");
INSERT INTO gwr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Kale oMusa nʼAlooni ni baaba e Misiri, ni bakumbaania abeekubbemberi bonabona abʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Alooni nʼabakobera byonabyona oMusengwa ebiyakobere oMusa, era oMusa nʼakola obumanyiciryo bwʼebyewunyo omumaiso gʼabantu. ");
INSERT INTO gwr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Awo abeekubbemberi bʼaBaisirairi ni baikirirya. Era owebawuliire bati oMusengwa aboine okugada kwʼaBaisirairi era abalumirwa, ni bakotamya emitwe gyabwe, ni basinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Awo oluzwanyuma, oMusa nʼAlooni ni baaba eeri oFalaawo, ni bamukoba bati, “OMusengwa iye oKibbumba wʼaBaisirairi akoba ati, ‘Oleke abantu bange baabe omwidungu, kaisi bakolere eeyo omukolo okumpa ekitiisya.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Neye oFalaawo nʼabuulya ati, “OMusengwa oyo niiye onaani, kaisi mmuwulire, era njikirirye aBaisirairi okwaba? Nze timmaite oMusengwa oyo, era tinaleke aBaisirairi okwaba.” ");
INSERT INTO gwr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Awo oMusa nʼAlooni ni bairamu bati, “OKibbumba wʼaBeebbulaniya yatubonekeire. Kale tukusaba, otwikirirye tutambule olugendo lwʼenaku isatu omwidungu, kaisi tuweeyo esadaaka eeri oMusengwa iye oKibbumba waiswe. Singa titwakole ekyo yatuleetaku okawumpuli ooba olutalo ni tufa.” ");
INSERT INTO gwr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","OFalaawo nʼakoba oMusa nʼAlooni ati, “Mutegeeza niki okutaka okulekesyawo abantu emirimo gyabwe? Atyanu mwireyo oku mirimo gyanywe.” ");
INSERT INTO gwr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","OFalaawo era nʼakoba ati, “Muwulisisye, aBaisirairi beeyongeire obungi okukiraku aBamisiri, tete inywe mutaka aBaisirairi bawuumule tibakola emirimo gyabwe!” ");
INSERT INTO gwr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Oku lunaku olunyere olwo, oFalaawo nʼalagira aBamisiri abakolesyanga abagalama nʼabanyampala ba bagalama ati, ");
INSERT INTO gwr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Mulekere awo okuwa abantu eisubi eryʼokukolesya omu kukubba amatafaali. Ibo abananyere bali nʼokwaba ni balyenoonerya. ");
INSERT INTO gwr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Neye mubasalire beeryenge obungi bwʼamatafaali, bunanyere budi ngʼobubakubbanga nenca, tibabukendeeryaku kadi katyayi kati. Ekyo kityo olwʼokubba banafu, kagira basaba bati, ‘Otuleke twabe tuweeyo esadaaka eeri oKibbumba waiswe.’ ");
INSERT INTO gwr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Mwazye abantu abo bakole ino emirimo okukiraku ngʼowebabbaire bakola era basiibe nga bali ku mirimo egyo bakola, kaisi tibasuna ekiseera okuwulisisya ebibono ebyobubbeyi.” ");
INSERT INTO gwr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kale aBamisiri abakolesyanga abagalama nʼabanyampala ba bagalama ni baaba eeri abantu ni babakoba bati, “OFalaawo atulagiire okutairayo okubawa eisubi. ");
INSERT INTO gwr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Inywe abananyere muli nʼokwaba mulyereetere e gimwezya okulyaja. Neye obungi bwʼamatafaali agemukubba, tibwakendeereku kadi katyai kati.” ");
INSERT INTO gwr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Awo abantu ni basalaanikira omu kyalo kyonakyona ekyʼe Misiri okunoonia eisubi. ");
INSERT INTO gwr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ABamisiri abakolesyanga abagalama ni beeyongera okubba nga baazya abantu bati, “Mwerye obungi obwʼamatafaali obwenkanankana nʼago agemukubbanga nenca nga tubawa eisubi.” ");
INSERT INTO gwr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ABamisiri abakolesyanga abagalama ni bakubba abanyampala. Ni bababuulya bati, “Lwaki olweizo nʼolwatyanu timwererye obungi bwʼamatafaali ngʼagemubbaire mukubba nenca?” ");
INSERT INTO gwr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Awo abanyampala ni baaba eeri oFalaawo, ni beezuluguma nga bakoba bati, “Lwaki iswe abaweereryabo otubitya otyo? ");
INSERT INTO gwr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Mpaawo atuwa eisubi, neye ate ni batulagira okukubba amatafaali! Era ni batukubba. Neye ekisobyo kiri ku bantubo.” ");
INSERT INTO gwr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","OFalaawo nʼabairamu ati, “Muli banafu! Kagira musaba muti, ‘Otuleke twabe tuweeyo esadaaka eeri oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kale atyanu mukange mukole. Tibabawe eisubi, neye muli nʼokukubba obungi bwʼamatafaali bunanyere budi ngʼowemukubbanga nenca.” ");
INSERT INTO gwr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Abanyampala ni bategeera nga bali mu kabbikabbi, owebabakobere bati, “Timwakendeeryeku kadi katyai kati oku bungi bwʼamatafaali agemuli nʼokukubba nabuli lunaku.” ");
INSERT INTO gwr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Atyanu owebabbaire bazwa e wa Falaawo, ni basangaana oMusa nʼAlooni ababbaire babakuumiriire. ");
INSERT INTO gwr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ni bakoba oMusa nʼAlooni bati, “OMusengwa aboine ekimukolere, era yababonereza, olwʼokubba mutucaawisirye omumaiso ga Falaawo nʼomumaiso gʼabakungube, ni mubba oti-so mubawaire kibeekwatisya kutwita.” ");
INSERT INTO gwr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Awo oMusa nʼakanga nʼasaba oMusengwa nga yeezuluguma ati, “Oo Musengwa, lwaki oleetere omutawaana oku bantubo? Ekyo niikyo ekyagirire nʼontuma? ");
INSERT INTO gwr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ekyo kityo olwʼokubba kasookeede njaba egiri oFalaawo okumukobera ebiwantumire, abantubo ababitya kubbikubbi. Kaisi iwe mpaawo ekyokolerewo okubanunula!” ");
INSERT INTO gwr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Awo oMusengwa nʼakoba oMusa ati, “Atyanu wabona ekinakola oFalaawo. Njaba okukolesya obwezye bwange mmwazye aleke abantu bange baabe. Era njaba okukolesya obwezye bwange ababbinge-bubbingi okuzwa omu kyalokye.” ");
INSERT INTO gwr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","OKibbumba era nʼatumula nʼoMusa nʼamukoba ati, “Ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nabonekeire oIbbulaimu, nʼoIsaka, nʼoYaakobbo, ngʼoKibbumba oWabwezye Bwonabwona. Neye tinabeemanyikisirye nti ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Era nakolere nabo endagaano yange, ni mbasuubiza okubawa ekyalo kyʼe Kanani, e gibabbaire abasenze. ");
INSERT INTO gwr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Era atyanu mpuliire okukunga kwʼaBaisirairi, ibo aBamisiri abebasuucirye abagalama, ni njebukirya endagaano eginakolere nabo. ");
INSERT INTO gwr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Nʼolwekyo okobere aBaisirairi oti mbakoba nti, ‘Ninze oMusengwa, era nalibanunula ni mbalamya aBamisiri okubagadya, nʼokubba abagalama baabwe. Era nalikolesya obwezye bwange, ni mbonereza ino aBamisiri, ni mbanunula inywe. ");
INSERT INTO gwr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nalibasuuca inywe bantu bange, era ni mba Kibbumba waanywe. Era awo mwalimanya nga Ninze oMusengwa iye oKibbumba waanywe abanunwire okuzwa omu bugalama omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Era nalibaingirya omu kyalo ekinalayiire okuwa oIbbulaimu, nʼoIsaka, nʼoYaakobbo. Nalikibawa inywe ni kibba kyanywe. Ninze oMusengwa.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Kale oMusa nʼakobera aBaisirairi ebintu ebyo oMusengwa ebiyabbaire akobere. Neye tibamuwulisisirye, olwʼokubba babbaire bawoiremu amaani olwʼokubabitya okubbikubbi omu bugalama. ");
INSERT INTO gwr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Okange egiri oFalaawo omukobe aleke aBaisirairi bazwe omu kyalokye.” ");
INSERT INTO gwr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Neye oMusa nʼakoba oMusengwa ati, “Obanga nʼaBaisirairi tibampulisisya, dala oFalaawo niiye eyampulisisya nze atali omutumuli omusa?” ");
INSERT INTO gwr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Neye oMusengwa nʼalagira oMusa nʼAlooni ngʼakoba ati, “Mukobe aBaisirairi nʼoFalaawo muti, oMusengwa atulagiire okutoola aBaisirairi omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Atyanu oLubbeeni omwana omubere owa Yaakobbo, abaanabe babbaire niibo banu: OKanoki, nʼoPalu, nʼoKezirooni, nʼoKalumi. Abo niibo abazeiza bʼabantu bʼebika byʼamaliina gaabwe ago. ");
INSERT INTO gwr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Abaana ba Simyoni babbaire niibo banu: OYemweri, nʼoYamini, nʼOkaadi, nʼoYakini, nʼoZokali, nʼoSyawulo omwana oguyabyaire nʼomukali oMukanani. Abo niibo abazeiza bʼabantu bʼebika byʼamaliina gaabwe ago. ");
INSERT INTO gwr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Atyanu ganu niigo amaliina gʼabaana ba Leevi ngʼowebairanganaku omu kubabyala: OGerusoni, nʼoKokasi, nʼoMerali. Era oLeevi yawangaire emyanka 137. ");
INSERT INTO gwr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Abaana ba Gerusoni babbaire niibo banu: oLibbuni nʼoSemeeyi, era abo niibo abazeiza bʼabantu bʼebika byʼamaliina gaabwe ago. ");
INSERT INTO gwr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Abaana ba Kokasi babbaire niibo banu: Amulaamu, nʼoIzukali, nʼoKebbulooni, nʼoWuziyeeri. Era oKokasi yawangaire emyanka 133. ");
INSERT INTO gwr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Abaana ba Merali babbaire niibo banu: OMakuli nʼoMusyi. Atyanu abo bonabona abʼeibyaire lya Leevi aamo nʼabaizukulu baabwe niibo abazwiremu ebika byʼaBaleevi. ");
INSERT INTO gwr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Atyanu Amulaamu yafumbiirwe oYokebbedi oisengawe, era nʼabyala naye Alooni nʼoMusa. Era Amulaamu yawangaire emyanka 137. ");
INSERT INTO gwr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Abaana ba Izukali babbaire niibo banu: OKoola, nʼoNefegi, nʼoZikiri. ");
INSERT INTO gwr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Abaana ba Wuziyeeri babbaire niibo banu: OMisairi, nʼErizefaani nʼoSitiri. ");
INSERT INTO gwr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Atyanu Alooni yafumbiirwe Eriseebba, omwala wʼAminadabbu era omwonyoko wa Nakusoni, nʼabyala naye oNadabbu, nʼAbbiku, nʼEryezaali, nʼoIsamali. ");
INSERT INTO gwr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Abaana ba Koola babbaire niibo banu: Asira, nʼErukaana, nʼAbbiyasaafu. Abo niibo abazeiza ba bantu abʼebika bya Bakoolakiiti. ");
INSERT INTO gwr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eryezaali omutaane wʼAlooni, yafumbiirwe omoiza oku baala ba Putiyeeri, era nʼabyala naye oFenekansi. Abantu abo bonabona aamo niibo ababbaire abakulu abʼekika kya Leevi mu buli mulyango. ");
INSERT INTO gwr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Atyanu Alooni nʼoMusa, niibo abananyere badi oMusengwa abeyakobere ati, “Mutooleyo ebika byʼaBaisirairi omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Era oMusa nʼAlooni niibo abakobeire oFalaawo ebikwata oku kutoola aBaisirairi omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Atyanu oMusengwa oweyatumuliire nʼoMusa omu kyalo kyʼe Misiri, ");
INSERT INTO gwr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","yakobere oMusa ati, “Ninze oMusengwa. Okobere oFalaawo nabuli ekinkukoba.” ");
INSERT INTO gwr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Neye oMusa nʼairamu oMusengwa ati, “Omaite nga tindi mutumuli omusa, dala oFalaawo yampulisisya?” ");
INSERT INTO gwr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Awo oMusengwa nʼamwiramu ati, “Aale obone, nkusuucirye ngʼoKibbumba eeri oFalaawo, era njaba okuteekawo omugandawo Alooni okubba ngʼonaabbiwo, oguwakobanga okukobera oFalaawo ebyotaka. ");
INSERT INTO gwr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Oli nʼokukobera omugandawo Alooni nabuli ekinkulagira, kaisi iye nʼakobera oFalaawo okuleka aBaisirairi bazwe omu kyalokye. ");
INSERT INTO gwr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Neye nalikakanyalya omwoyo gwa Falaawo, era waire nga nalikola obumanyiciryo wʼebyewunyo nʼebyewunyisya bingi omu kyalo kyʼe Misiri, ");
INSERT INTO gwr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","oFalaawo tiyalibawulisisya. Era nʼalikolesya obwezye bwange ni mbonereza ino aBamisiri, ni nkubbembera ebika byʼabantu bange aBaisirairi ni mbatoola omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Owenalikolesya ntyo obwezye bwange oku Bamisiri, ni ntoolayo aBaisirairi omu Misiri, aBamisiri balimanya nga Ninze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Kale oMusa nʼAlooni ni bakola ngʼoMusengwa oweyabalagiire. ");
INSERT INTO gwr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ekiseera ekibatumuliiremu nʼoFalaawo, oMusa yabbaire wʼemyanka 80, kaisi Alooni nga iye wʼemyanka 83. ");
INSERT INTO gwr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Atyanu oMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“OFalaawo oweyalibakoba ati, ‘Mukolewo ekyamagero,’ iwe Musa walikoba Alooni oti, ‘Okwate omukoomerogwo ogumume ansi omumaiso ga Falaawo’ era gwalisuuka mpiri.” ");
INSERT INTO gwr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kale awo oMusa nʼAlooni ni baaba egiri oFalaawo, ni bakola ngʼoMusengwa oweyabalagiire. Alooni nʼamuma omukoomerogwe ansi omumaiso ga Falaawo nʼabakungube, era ni gusuuka mpiri. ");
INSERT INTO gwr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Awo oFalaawo nʼayeta abasaiza abalogo nʼabafumu aBamisiri, bona ni bakola ekintu ekinyere ekyo nga bakolesya eirogo lyabwe. ");
INSERT INTO gwr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Nabuli moiza nʼamuma omukoomerogwe ansi, ni gusuuka mpiri. Neye omukoomero gwʼAlooni ni gumira egyabwe. ");
INSERT INTO gwr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Waire wona ngʼebyo bityo era oFalaawo omwoyogwe ni gusigala nga mukakanyali, nakimo ngʼoMusengwa oweyabbaire akobeire oMusa, atyo oFalaawo nandi nʼawulisisya oMusa nʼAlooni. ");
INSERT INTO gwr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Awo oMusengwa nʼakoba oMusa ati, “Omwoyo gwa Falaawo mukakanyali, againe okuleka abantu baabe. ");
INSERT INTO gwr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Kale, eizo amakeezi oyabe omusisinkane ngʼawulukire okwaba oku mwiga oKiyira. Oyabe nʼomukoomero ogwasuukiremu ompiri, era waaba nʼomukuumira ku mbale kwʼomwiga ogwo. ");
INSERT INTO gwr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kaisi omukobe oti, ‘OMusengwa iye oKibbumba wʼaBeebbulaniya yantumire egyoli okukukoba nti, oleke abantube baabe bayezye okumusinzira omwidungu. Neye nʼokutuuca olwatyanu towulisisirye. ");
INSERT INTO gwr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Nʼolwekyo oMusengwa akoba ati, ku kinu kuwamanyicirya nga Niiye oMusengwa. Aale obone omukoomero ogunkwaite, njaba okugukubba oku maizi agali omu mwiga gunu, amaizi gasuuke musaaye. ");
INSERT INTO gwr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Enyanyi gyʼomu mwiga gunu gyaba kufa, omwiga gufunye, aBamisiri bazuzuule okunywa amaizi agʼomu mwiga gunu.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Era oMusengwa ni yeeyongera okukoba oMusa ati, “Okobe Alooni oti, ‘Oyabe nʼomukoomerogwo, kaisi ogusiirye e ngulu oku maizi agʼomu kyalo kyʼe Misiri. Ekikoba kiti, oku miiga, nʼoku myala, nʼoku bidiba byʼamaizi, nʼoku maluba gaabwe gonagona, era amaizi gasuuka musaaye. Era amaizi gonagona omu kyalo kyonakyona ekyʼe Misiri gasuuka musaaye, era nʼamaizi ago agali omu matiba nʼomu nsaka egyʼamabbaale.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Kale oMusa nʼAlooni ni bakola ngʼoMusengwa oweyabalagiire. Alooni nʼasiirya omukoomerogwe, nʼagukubba oku maizi agʼomu mwiga oKiyira ngʼoFalaawo nʼabakungube babona, amaizi gonagona agʼomu mwiga ogwo ni gasuuka musaaye. ");
INSERT INTO gwr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Enyanyi gyonagyona egyʼomu mwiga ogwo ni gifa, omwiga ni gufunya. Era aBamisiri nandi ni bayezya okunywa amaizi gaamu. Amaizi omu kyalo kyonakyona ekyʼe Misiri ni gasuuka musaaye. ");
INSERT INTO gwr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Neye era abafumu aBamisiri bona ni basuuca amaizi musaaye nga bakolesya eirogo lyabwe. Kale oFalaawo nʼasigala ngʼomwoyogwe gukaali mukakanyali, nʼatawulisisya oMusa nʼAlooni, atyo nakimo ngʼoMusengwa oweyabbaire akobeire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kale oFalaawo nʼagaluka nʼakanga omu kisitokye, era nʼebyo-so nga tabifiireku naire. ");
INSERT INTO gwr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Awo aBamisiri bonabona ni bakuula ebiina okumpi nʼomwiga, bayezye okusuna amaizi agʼokunywa. Bakolere batyo olwʼokubba babbaire tibayezya okunywa amaizi gʼomu mwiga. ");
INSERT INTO gwr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Era ni wabitawo enaku musanvu, okuzwa ngʼoMusengwa amalire okukubba oku mwiga oKiyira, amaizi ni gasuuka musaaye. ");
INSERT INTO gwr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Tete olundi oMusengwa nʼakoba oMusa ati, “Okange egiri oFalaawo omukobe oti, oMusengwa akoba ati, ‘Oleke abantu bange baabe bayezye okunsinza. ");
INSERT INTO gwr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Neye owewagaana okubaleka okwaba, njaba kubonereza ekyalokyo kyonakyona nga nkisindikamu ebikere. ");
INSERT INTO gwr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Omwiga oKiyira gwaba okwizula ebikere, era byazwa eeyo ni bingira omu lubirirwo, nʼomu kisengekyo ekyogonamu, nʼoku buliribwo, nʼomu nyumba gyʼabakungubo, nʼomu gyʼabantubo, nʼomu bibangebyo, nʼomu matiba agebakandiramu. ");
INSERT INTO gwr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ebikere ebyo byaba okukuniinaku iwe, nʼoku bantubo, era nʼoku bakungubo.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Awo oMusengwa nʼakoba oMusa ati, “Okobe Alooni oti, ‘Okwate omukoomerogwo, ogusiirye oku miiga nʼoku myala, nʼoku bidiba, kaisi ekyo kizwereku ebikere okuzwamu biwoisye oku kyalo kyʼe Misiri kyonakyona.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kale Alooni engaloye ekwaite omukoomero, nʼagisiirya oku maizi gʼomu kyalo kyʼe Misiri, era ebikere ni bizwamu, ni biwoisya omu kyalo ekyo kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Era abafumu abʼe Misiri bona ni bakola ekintu ekinyere ekyo, nga bakolesya eirogo lyabwe era ekyo kyona ni kizweraku ebikere okuzwamu ni biwoisya omu kyalo kyʼe Misiri kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Awo oFalaawo nʼayetesya oMusa nʼAlooni, nʼabakoba ati, “Musabe oMusengwa antoolerewo nze nʼabantu bange ebikere ebyo. Oweyakola atyo, njaba kuleka abantu baanywe baabe baweeyo esadaaka eeri oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","OMusa nʼakoba oFalaawo ati, “Aaso, olonde ekiseera ekimba nkusabiramu iwe, nʼabakungubo, nʼabantubo, okuwunuka ebikere era bizwe nʼomu bisito byanywe, bisigale mu mwiga oKiyira mwonkani.” ");
INSERT INTO gwr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","OFalaawo nʼakoba ati, “Onsabire izo.” OMusa nʼairamu ati, “Kale njaba okukola ngʼowookobere, kaisi omanye nga mpaawo gondi aali ngʼoMusengwa iye oKibbumba waiswe. ");
INSERT INTO gwr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ebikere byakuzwaku, era bizwe nʼomu nyumbagyo, nʼoku bakungubo, era nʼoku bantubo, byaba kusigala mu mwiga oKiyira mwonkani.” ");
INSERT INTO gwr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ebyo owebyawoire oMusa nʼAlooni ni bazwa egiri Falaawo, ni bawuluka omu lubiri. Awo oMusa nʼasaba oMusengwa atoolewo ebikere, ebiyabbaire asindikiire oFalaawo. ");
INSERT INTO gwr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","OMusengwa nʼawulira okusaba kwa Musa, nʼakola ngʼoMusa oweyamusabire. Era ebikere ebyabbaire omu nyumba, nʼoku maluuga, nʼomu misiri gyabwe, ni bifa. ");
INSERT INTO gwr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Awo aBamisiri ni babbiirya ebibbiiryo byʼebikere, ekyalo ni kidukuulika ekivundi. ");
INSERT INTO gwr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Neye oFalaawo oweyaboine ngʼasunire akalembereze, omwoyogwe ni gukakanyala. Era nandi nʼairayo okuwulisisya oMusa nʼAlooni, nʼakolera nakimo ngʼoMusengwa oweyabbaire akobeire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Awo oMusengwa tete nʼakoba oMusa ati, “Okobe Alooni oti, ‘Osiirye omukoomerogwo okubbe okwitakali, enkungu omu kyalo kyonakyona ekyʼe Misiri, gyasuuka nkukuni.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Bona ni bakola batyo, Alooni nʼasiirya omukoomerogwe, nʼagukubba okwitakali, onkungu yenayena owʼomu kyalo ekyʼe Misiri nʼasuuka nkukuni, era ni gigwa oku bantu nʼoku byayo. ");
INSERT INTO gwr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Kale abafumu abʼe Misiri bona ni bagezyaku okukola ekintu ekinyere ekyo, nga bakolesya eirogo lyabwe okuleeta enkukuni, neye ni bakaya. Enkukuni ni giwoisya nabuli wantu oku bantu nʼoku byayo. ");
INSERT INTO gwr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ibo abafumu bʼe Misiri ni bakoba oFalaawo bati, “OKibbumba niiye akolere ekyo omu bwezyebwe.” Neye omwoyo gwa Falaawo ni gukakanyala, era nandi nʼawulisisya oMusa nʼAlooni, era ngʼoMusengwa oweyabbaire akobere. ");
INSERT INTO gwr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Tete era oMusengwa nʼakoba oMusa ati, “Eizo osetuke makeezikeezi, oyabe osangaane oFalaawo, ngʼawulukire okwaba oku mwiga, omukobe oti, oMusengwa akoba ati, ‘Oleke abantu bange baabe bayezye okunsinza. ");
INSERT INTO gwr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Neye singa tiwaleke abantu bange ni baaba, njaba okukusindikira ebiziima byʼenzi, iwe nʼabakungubo nʼabantubo. Era enyumbagyo nʼegyʼaBamisiri gyaba okwizula enzi, nʼeitakali okwemuli, lyaba okwizula ebiziima byʼenzi. ");
INSERT INTO gwr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Neye oku lunaku olunasindikiraku enzi, nakuuma ekitundu ekyʼe Goseni, abantu bange omu batyaime, ebiziima byʼenzi tibyabbeeyo, kaisi olwo omanye oti, Nze oMusengwa, ndi omu kyalo kinu ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Njaba kuteekawo enjawulo aakati wʼabantu bange nʼababo. Akamanyiciryo kʼakyewunyo ako kaaba kubbaawo eizo.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Era oMusengwa nʼakola atyo ngʼoweyabbaire akobere, nʼasindika ebiziima byʼenzi ebinene, ni biiza omu lubiri lwa Falaawo, nʼomu nyumba gyʼabakungube. Ekyalo kyonakyona ekyʼe Misiri ni kibba mu kazigizigi olwʼenzi. ");
INSERT INTO gwr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Awo oFalaawo nʼayeta oMusa nʼAlooni nʼabakoba ati, “Mwabe muweeyo esadaaka eeri oKibbumba waanywe, neye mugiweereyo yaanu mu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Neye oMusa nʼairamu ati, “Tikisa okukola tutyo, olwʼokubba esadaaka egitwaba okuwaayo eeri oMusengwa iye oKibbumba waiswe gyʼomuliko omu Bamisiri. Kale owetwawaayo esadaaka egyʼomuliko egyo ngʼaBamisiri batubona, tibatukubbe amabbaale ni batwita? ");
INSERT INTO gwr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Oleke twabe tutambule olugendo lwʼenaku isatu omwidungu, kaisi tuweeyo esadaaka eeri oMusengwa iye oKibbumba waiswe ngʼowaatulagira.” ");
INSERT INTO gwr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kale oFalaawo nʼakoba ati, “Nze nabaikirirya okwaba omwidungu muweeyo esadaaka eeri oMusengwa iye oKibbumba waanywe, owemubba timwabirire e yala eino. Aale munsabire.” ");
INSERT INTO gwr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Awo oMusa nʼairamu ati, “Aale owulire, owenaazwa aanu nti, njaba kusaba oMusengwa, nti eizo akutooleku ebiziima byʼenzi nʼoku bakungubo, nʼoku bantubo. Wazira, tiwatumula kutubbeya-bubbeyi nʼogaana abantu okwaba okuwaayo esadaaka eeri oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","OMusa nʼazwa aawo omumaiso ga Falaawo, nʼayaba nʼasaba oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Era oMusengwa nʼakola ngʼoMusa oweyasabire. Nʼatoolerawo oFalaawo, nʼabakungube, nʼabantube ebiziima byʼenzi, era nandi ni wasigalawo onzi kadi moiza. ");
INSERT INTO gwr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Neye nʼoku mulundi ogwo, oFalaawo omwoyogwe ni gusigala nga mukakanyali, era nandi nʼaleka abantu okwaba. ");
INSERT INTO gwr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Era oMusengwa tete nʼakoba oMusa ati, “Okange egiri oFalaawo omukobe oti, oMusengwa iye oKibbumba wʼaBeebbulaniya akoba ati, ‘Oleke abantu bange baabe bayezye okunsinza. ");
INSERT INTO gwr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Owewagaana okubaleka okwaba era ni weeyongera okubagaaniraku, ");
INSERT INTO gwr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","nakubonereza nga nkusindikira okawumpuli owʼakabbikabbi eino omu byayobyo. Ekikoba kiti, omu mbalaasigyo, nʼempundagyo, nʼengamiragyo, nʼentegyo, nʼentaamagyo, nʼembuligyo. ");
INSERT INTO gwr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Era njaba okulaga enjawulo omu ngeri eginabityamu ebyayo ebyʼaBaisirairi, nʼebyʼaBamisiri, kaisi tikyafaaku kadi kimo oku byʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nze oMusengwa nteekerewo ekiseera kyʼeizo, nga niiye owenasindikira okawumpuli owʼakabbikabbi oyo omu kyalo kyʼe Misiri.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Awo oku lunaku olwairireku, oMusengwa nʼakola ekyo ekiyakobere, ebyayo byonabyona ebyʼaBamisiri ni bifa. Neye oku byayo byʼaBaisirairi nandi ni kufaaku kadi kimo. ");
INSERT INTO gwr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kale oFalaawo nʼatuma abantu okwaba okwetegereza ekibbairewo, era ni bakanga ni bamukobera bati omu byayo byʼaBaisirairi mpaawo waire kyayo kadi kimo ekifiireku. Neye oFalaawo nʼasigala ngʼomwoyogwe mukakanyali, era nandi nʼaleka aBaisirairi okwaba. ");
INSERT INTO gwr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Era tete olundi oMusengwa nʼakoba oMusa nʼAlooni ati, “Muyoole ebigalo byʼeikoke eryʼomu kyoceryo mwabe nalyo egiri oFalaawo, kaisi oMusa alimwage e ngulu omwibbanga ngʼoFalaawo abona. ");
INSERT INTO gwr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Lyaba okuduumuuka era lisalaanikire omu kyalo kyonakyona ekyʼe Misiri ooti nkungu, era nabuli wantu omu kyalo kyʼe Misiri lyateeka oku bantu nʼoku bisolo ebisumuli, ni bitundukanga ni bisuuka mabbwa.” ");
INSERT INTO gwr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kale ni bayoola eikoke eryʼomu kyoceryo ni baaba nalyo omumaiso ga Falaawo. Awo oMusa nʼamwaga eikoke e ngulu omwibbanga, ni lireeta oku bantu nʼoku bisolo ebisumuli, ni bitundukanga era ni bisuuka mabbwa. ");
INSERT INTO gwr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Era abafumu abʼomu Misiri nandi ni bayezya okubonekaku omumaiso ga Musa, olwʼokubba babbaire bona nga baizwire ebisumuli ngʼaBamisiri abandi bonabona. ");
INSERT INTO gwr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Neye oMusengwa nʼakakanyalya omwoyo gwa Falaawo, era nandi nʼabawulisisya, nʼabbeera nakimo ngʼoMusengwa oweyabbaire akobeire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Awo oluzwanyuma oMusengwa tete nʼakoba oMusa ati, “Osetuke eizo makeezikeezi, oyabe egiri oFalaawo, omukobe oti, oMusengwa iye oKibbumba wʼaBeebbulaniya akoba ati, ‘Oleke abantu bange baabe bayezye okunsinza. ");
INSERT INTO gwr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Owewabagaana okwaba, oku mulundi gunu njaba kumalira ku niiwe obusungu bwange bwonabwona. Nakubonereza ino iwe, nʼabakungubo, nʼabantubo, kaisi omanye nga mpaawo gondi ali nga nze omu kyalo kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Atyanu nandibbaire nkoleserye obwezye bwange ni nkusindikira iwe nʼabantubo obulwaire bwa kawumpuli ni bubajigirica oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Neye nkulekerewo ngʼoli mwomi, kutaka kukulaga bwezye bwange, kaisi ekyo kizwereku abantu okungulumalya omu kyalo kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nʼokutuuca atyanu okaali weekanyangwire okugaana abantu bange okwaba? ");
INSERT INTO gwr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Aale, eizo omu kiseera ooti kiinu, njaba okutoonyesya agabbaale ga ikendi, agatabonekangaku omu Misiri kasookeede ebbaawo. ");
INSERT INTO gwr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nʼolwekyo olagire baingirye ebyayo nʼebintubyo byonabyona ebiri e nza, agabbaale ga ikendi gaaba kukubba era gaite nabuli kyomi ekyabba e nza nga tibakingiirye omu nyumba, nʼoweyaabba muntu ooba kyayo, gaita.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kaisi awo abamo oku bakungu ba Falaawo abatiire ebyo oMusengwa ebiyatumwire, ni bairuca abagalama baabwe nʼebyayo byabwe omu nyumba gyabwe. ");
INSERT INTO gwr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Neye abakungu ba Falaawo abo abanandi ni bafaayo kwebyo oMusengwa ebiyatumwire, ni baleka abagalama baabwe nʼebyayo byabwe e nza. ");
INSERT INTO gwr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Awo oMusengwa nʼakoba oMusa ati, “Osiirye engaloyo eeri eigulu, kaisi agabbaale ga ikendi gagwe omu kyalo kyonakyona ekyʼe Misiri. Ekikoba kiti, oku bantu nʼoku byayo, nʼoku bimera byonabyona ebiri omu misiri gyʼomu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Awo oMusa nʼasiirya omukoomerogwe eeri eigulu. Kaisi oMusengwa nʼasindika eraadu nʼebbwatuka nʼagabbaale ga ikendi ni gagwa, ni wabbaawo nʼokumesya kwa ikendi emirundi nʼemirundi oku kyalo. Era oMusengwa nʼatoonyesya agabbaale ga ikendi omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Agabbaale ga ikendi ni gagwa, nʼokumesya ni kubbaawo emirundi nʼemirundi. Era ebyo byabbaire tibibbangakuuwo omu kyalo kyonakyona ekyʼe Misiri kasookeede kibbaawo ngʼeigwanga. ");
INSERT INTO gwr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Omu kyalo kyonakyona ekyʼe Misiri agabbaale ga ikendi ni gakubba nabuli kintu ekyabbaire e nza. Ekikoba kiti, abantu nʼebisolo, ni gakubba nʼebimera byonabyona omu misiri, era ni gavuna emisaale gyonagyona. ");
INSERT INTO gwr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ekitundu kyʼe Goseni, aBaisirairi omu babbaire, niikyo kyonkani agabbaale ga ikendi e ginandi ni gatuuka. ");
INSERT INTO gwr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Awo oFalaawo nʼalagira ni beeta oMusa nʼAlooni, nʼabakoba ati, “Oku mulundi gunu nkolere ekikole ekibbikibbi, oMusengwa iye mutuuce. Neye nze nʼabantu bange niiswe abasobya. ");
INSERT INTO gwr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Musabe oMusengwa akomye eraadu okubbwatuka etyo era akomye nʼagabbaale ga ikendi gona. Njaba kubaleka mwabe, tikikaali kibeetaagisya okusigala aanu.” ");
INSERT INTO gwr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","OMusa nʼairamu ati, “Owenaazwa omu kibuga nasiirya engalo gyange nga nsaba oMusengwa. Eraadu yakomya okubbwatuka nʼagabbaale ga ikendi gaaba kuwaaku, kaisi omanye ngʼekyalo kya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Neye nze mmaite nti iwe nʼabakungubo mukaali okutya oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Enkokooli nʼekimera ekibeeta bbaale, agabbaale ga ikendi gabivunavunire, olwʼokubba obbaale yabbaire ayengere, nʼenkokooli nga gisowoire. ");
INSERT INTO gwr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Neye mpaawo ngaano egibavulungire, olwʼokubba igyo gyabbaire gikaali okumera. ");
INSERT INTO gwr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kale awo oMusa nʼazwa egiri oFalaawo era nʼawuluka omu kibuga, nʼagolola engalogye okusaba oMusengwa. Eraadu nʼagabbaale ga ikendi ni bikoma, nʼoikendi nʼalekeraawo okutoonya. ");
INSERT INTO gwr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Neye oFalaawo oweyaboine ngʼoikendi nʼagabbaale ga ikendi, nʼeraadu birekeire awo, tete nʼairamu okwonoona. Iye nʼabakungube emyoyo gyabwe ni gibba mikakanyali. ");
INSERT INTO gwr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Era ngʼoMusengwa oweyabbaire atumwire ngʼabitira omu Musa, omwoyo gwa Falaawo ni gubba mukakanyali era nandi nʼaleka aBaisirairi okwaba. ");
INSERT INTO gwr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Awo oluzwanyuma lwʼagabbaale ga ikendi, oMusengwa nʼakoba oMusa ati, “Okange egiri oFalaawo olwʼokubba nkakanyairye omwoyogwe, nʼemyoyo gyʼabakungube, kaisi nkole obumanyiciryo obwʼebyewunyo byange binu omumaiso gaabwe. ");
INSERT INTO gwr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Era kaisi mwezye okukobera abaana nʼabaizukulu baanywe engeri eginsuucirye aBamisiri okuboneka ngʼabasirusiru owenkolere ebyewunyo omumaiso gaabwe. Era kaisi nywenanywena mumanye nga Ninze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kale oMusa nʼAlooni ni baaba eeri oFalaawo, ni bamukoba bati, “OMusengwa iye oKibbumba wʼaBeebbulaniya akoba ati, ‘Walituuca di okugaana okuwulisisya ekinkukoba? Oleke abantu bange baabe bayezye okunsinza. ");
INSERT INTO gwr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Neye owewagaana okuleka abantu bange okwaba, eizo njaba kusindika enzige omu kyalokyo ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Era gyabbuunaku eitakali ni libba nga tiriboneka. Gyaba kulya ebitono ebyasigaireku, agabbaale ga ikendi ebinandi gajigiricirya, nʼemisaale gyonagyona egiri kusewuka omu misiri gyanywe. ");
INSERT INTO gwr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Era gyaba kwizula omu nyumbagyo, nʼomu gyʼabakungubo, nʼomu gyʼaBamisiri bonabona. Enzige egyo gyaba kubba nyingi ino okukiraku egyo abaitewaanywe, nʼabazeiza baanywe egibabbaire baboineku omu biseera byabwe kasookeede batyama omu kyalo kinu nʼokutuuca atyanu.’ ” Awo oMusa nʼagaluka nʼazwa e giri oFalaawo nʼayaba. ");
INSERT INTO gwr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Awo abakungu ba Falaawo ni bamukoba bati, “Omusaiza oyo yalituuca di okututeganya? Oleke abasaiza aBaisirairi baabe basinze oMusengwa iye oKibbumba waabwe. Okaali okumanya ngʼekyalo kyʼe Misiri kibebenyekere?” ");
INSERT INTO gwr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Awo ni bairya oMusa nʼAlooni omumaiso ga Falaawo, nʼabakoba ati, “Kale mwabe musinze oMusengwa iye oKibbumba waanywe. Neye eino eino banaani abaaba?” ");
INSERT INTO gwr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","OMusa nʼamwiramu ati, “Swenaswena twaba. Ekikoba kiti, abaana baiswe abatobato, nʼabantu baiswe abakaire, nʼabaana baiswe abaisuka nʼabaala. Era twaba nʼentaama, nʼembuli, nʼente gyaiswe, olwʼokubba tuli nʼokukola omukolo gwʼokuwa oMusengwa ekitiisya.” ");
INSERT INTO gwr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","OFalaawo nʼabakoba ati, “Ndayira oMusengwa nti tinabaleke okwaba nʼabakali baanywe nʼabaana baanywe. Kiboneka nga muli nʼolukwe olumutegeka. ");
INSERT INTO gwr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mutaka kusinza Musengwa, tiniikyo ekyo? Kale abasaiza nywenkani niinywe mubbe mwabe musinze oMusengwa.” Awo oFalaawo nʼabbinga oMusa nʼAlooni omu lubiri. ");
INSERT INTO gwr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Awo oMusengwa nʼakoba oMusa ati, “Osiirye engaloyo oku kyalo kyʼe Misiri, kaisi awo enzige giize gitaabaale ekyalo kyʼe Misiri, girye nabuli kimera kyonakyona ekyalamire agabbaale ga ikendi.” ");
INSERT INTO gwr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kale oMusa nʼasiirya omukoomerogwe oku kyalo kyʼe Misiri, era oMusengwa nʼasindika ompunga okuzwa e buzwaisana, nʼafuwa oku kyalo oku lunaku olwo lwonalwona, omusana nʼobwire. Atyanu owebwaceire eizo amakeezi, ompunga oyo eyabbaire afuwire yaleetere enzige. ");
INSERT INTO gwr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Enzige ni gitaabaala ekyalo kyonakyona ekyʼe Misiri. Era enzige enyingi egityo gyabbaire tigibonekangaku omu kyalo ekyo era tigyaliirayo okuboneka tete. ");
INSERT INTO gwr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Gyabbuunireku eitakali lyʼe kyalo kyonakyona ekyʼe Misiri, era ni gikiziringania. Ni girya nabuli kimera, nʼebineneka ebyʼoku misaale ebyalamire agabbaale ga ikendi, ni watasigala kikoola kyʼomusaale kadi kimo, waire oku bimera ebindi byonabyona, oku kyalo kyonakyona ekyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Awo oFalaawo nʼalagira mangu ni baleeta oMusa nʼAlooni, kaisi nʼabakoba ati, “Nkolere ekikole ekibbikibbi omumaiso ga Musengwa iye oKibbumba waanywe nʼomumaiso gaanywe. ");
INSERT INTO gwr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Kale atyanu munsoniye ekikole kyange ekibbikibbi omulundi gunu gwonkani, era musabe oMusengwa iye oKibbumba waanywe, antooleku ekibonerezo kinu ekyakabbikabbi.” ");
INSERT INTO gwr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","OMusa nʼazwa e giri oFalaawo, nʼasaba oMusengwa okutoolawo enzige. ");
INSERT INTO gwr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Era oMusengwa nʼacuusa ompunga eyazwire e buzwaisana nʼabba mpunga owʼamaani eino afuwa ngʼazwa e bugwaisana, nʼatwala enzige, nʼagimwaga omu Nyanza Entukuliki. Era omu kyalo kyonakyona ekyʼe Misiri nandi ni musigalamu onzige kadi moiza. ");
INSERT INTO gwr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Neye oMusengwa nʼakakanyalya omwoyo gwa Falaawo, nʼataleka aBaisirairi okwaba. ");
INSERT INTO gwr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Awo oMusengwa tete nʼakoba oMusa ati, “Osiirye engaloyo eeri eigulu, kaisi endikiirya ekwate zigizigi oku kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kale oMusa nʼasiirya engaloye eeri eigulu, era ni wabbaawo endikiirya ekwaite zigizigi omu kyalo kyonakyona ekyʼe Misiri, okumala enaku isatu. ");
INSERT INTO gwr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Era aBamisiri babbaire tibayezya okubonangana, era mpaawo eyazwire e wuwe okumala enaku isatu. Neye aBaisirairi ibo babbaire nʼekitangaala e waabwe egibabbaire batyama. ");
INSERT INTO gwr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Awo oFalaawo nʼalagira ni beeta oMusa kaisi nʼamukoba ati, “Mwabe musinze oMusengwa. Era abakali baanywe nʼabaana baanywe bona mwabe nabo. Neye entaama, nʼembuli, nʼente gyanywe niigyo egibba gisigale.” ");
INSERT INTO gwr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Neye oMusa nʼakoba ati, “Bbe, oteekwa okutwikirirya okwaba nʼebyayo byaiswe ebyabba ngʼesadaaka, era ebindi ngʼesadaaka egibooca yonayona, okubiwaayo eeri oMusengwa iye oKibbumba waiswe. ");
INSERT INTO gwr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Era tuteekwa okwaba nʼebiraalo byaiswe byonabyona. Era mpaawo kyayo kadi kimo ekitwaleka, olwʼokubba tuteekwa okulondamu ebyayo ebitwetaagisya omu kusinza oMusengwa iye oKibbumba waiswe. Era twalimala kutuukayo kaisi ni tumanya ebyayo ebitwetaaga omu kuwaayo esadaaka eeri oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Neye oMusengwa nʼakakanyalya omwoyo gwa Falaawo, nʼatabaleka okwaba. ");
INSERT INTO gwr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","OFalaawo nʼakoba oMusa ati, “Onzwe omumaiso! Weekuume okutairamu okuboneka omumaiso gange omulundi ogundi. Ekyo kityo olwʼokubba oku lunaku oluwalibonekera omumaiso gange, oyaba kufa.” ");
INSERT INTO gwr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","OMusa nʼairamu ati, “Otumwire kusani. Tinaireyo okuboneka omumaisogo.” ");
INSERT INTO gwr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Awo oMusengwa nʼakoba oMusa ati, “Njaba kusindikira oFalaawo nʼabantube ekibonerezo ekindi kimo kyonkani. Era oluzwanyuma lwʼekyo ayaba kubaleka mwabe. Mazima dala ayaba kubabbinga-bubbingi nywenanywena omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kale atyanu oyabe okobe aBaisirairi oti, nabuli musaiza, nabuli mukali, asabe abaliranwabe aBamisiri, bamuwe ebintu ebyʼefeeza nʼebyʼezaabbu.” ");
INSERT INTO gwr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","OMusengwa nʼawa aBaisirairi obukoda eeri aBamisiri. Era dala abakungu ba Falaawo nʼabantu bonabona, ni babona ngʼoMusa mukulu ino omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Atyanu oMusa nʼakoba oFalaawo ati, “OMusengwa akoba ati, ‘Kumpi oti mu kiire aakati, njaba okubita omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Era nabuli mwana omwisuka omubere mu buli kisito kya Mumisiri ayaba kufa, okuzwa oku mutaane wa Falaawo omubere eyalibba omusika, paka oku wʼomugalama asembayo ansi omu kitiisya. Nabuli kyayo ekibere ekisaiza ekyʼaBamisiri kyona kyaba kufa. ");
INSERT INTO gwr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Era waabbaawo okukuukulya omu kyalo kyonakyona ekyʼe Misiri okutabbangawo, era okutaliirayo okubbaawo. ");
INSERT INTO gwr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Neye omu Baisirairi nʼebyayo byabwe waaba okubba wasiriki era nga waliyo idembe nga towuliraku waire mbwa kusama, kaisi inywe aBamisiri mumanye muti Ninze oMusengwa ayawula aBamisiri oku Baisirairi.’ ");
INSERT INTO gwr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","OMusa nʼamalirirya ati, abakungubo banu bonabona baaba okwiza egyendi bankomere amazwi baneegairire bati, ‘Oyabe nʼabantubo bonabona abookubbembera.’ Ebyo nga biwoire, nayaba.” Awo oluzwanyuma lwʼokutumula ebyo oMusa nʼasunguwala, nʼazwa egiri oFalaawo. ");
INSERT INTO gwr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Atyanu oMusengwa yabbaire akobere oMusa ati, “OFalaawo tiyabawulisisye, kaisi nnyongere okukola ebyewunyo omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","OMusa nʼAlooni ni bakola ebyamagero ebyo byonabyona omumaiso ga Falaawo. Neye oMusengwa nʼakakanyalya omwoyo gwa Falaawo, nandi nʼaleka aBaisirairi okuzwa omu kyalokye. ");
INSERT INTO gwr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Atyanu oMusengwa yabbaire okobere oMusa nʼAlooni nga bakaali bali omu kyalo kyʼe Misiri ati, ");
INSERT INTO gwr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Omweri gunu mwagubalanga okubba niigwo ogusooka omu mwanka eeri inywe. ");
INSERT INTO gwr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mukobere ekibbula kyonakyona ekyʼaBaisirairi muti, oku lunaku olweikumi olwʼomweri gunu, nabuli musaiza ali nʼokusunira abʼomu kisitokye ontaama omutomuto. ");
INSERT INTO gwr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Abʼomu kisitokye owebabba batono nga tibaalye ni bamalawo ontaama oyo, bali nʼokwegaita nʼabʼokumulirano ni bagabana ontaama oyo, okusinzirira oku bungi bwʼabantu era nabuli moiza ngʼowaayezya okulya. ");
INSERT INTO gwr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Muli nʼokusuna ntaama omusaiza ooba mbuli ompanya, neye ateekwa okubba wʼomwanka gumo, era ngʼabulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nabuli kisito kikuume ekyayo kyakyo paka oku lunaku olweikumi na ina olwʼomweri gunu. Kaisi oku lunaku olwo aBaisirairi bonabona baite ebyayo ebyo eigulo. ");
INSERT INTO gwr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Oluzwanyuma lwʼekyo, abantu bali nʼokutoolaku omusaaye ni bagusiiga oku myango nʼoku mikiiko gyʼemyango gyʼenyumba omubaaba okuliira entaama entonto. ");
INSERT INTO gwr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Era ekiire ekyo bali nʼokwoca enyama, era bagiriire aamo nʼemigaati egibulamu okazumbulukuca, nʼosyodo owʼebigala omululululu. ");
INSERT INTO gwr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Enyama timwagirya embisi ooba nsumbe, wazira mugirye njoce yonayona ngʼotwaliryemu omutwe, nʼebikokolo, nʼebinamukida. ");
INSERT INTO gwr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Era timwabbaaku nʼegimulekaku nʼegona. Owewabbaawo esigaireku, muli nʼokugikumaku musyo. ");
INSERT INTO gwr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Owemwabba nga mugirya muli nʼokugirya mangu mangu, era nga muzwaire nga mwetegekeire olugendo. Era nga muzwaliire nakimo nʼebirato, era nga mukwatiire nakimo nʼemikoomero. Ogwo niigwo oMukolo ogwʼoKutambukirya kwa Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Era omu kiire ekinanyere ekyo njaba kubita omu kyalo kyʼe Misiri, njite nabuli mwana omwisuka omubere owa Mumisiri aamo nabuli kyayo ekibere ekisaiza ekyʼaBamisiri. Ninze oMusengwa era nabonereza abakibbumba bonabona abʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Neye inywe omusaaye ogumwabba musiigire oku myango, niigwo ogwabba akamanyiciryo akalaga enyumba egimulimu. Era owenabona omusaaye, nabatambukirya inywe nandi ni mbakolaku akabbikabbi, nga mbonereza aBamisiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Muli nʼokwebukiryanga olunaku olwo ni mukola omukolo nabuli mwanka, nʼomu mirembe egyaliirawo okwebukirya Nze oMusengwa ebinkolere. Era eryo iteeka eryʼenkalaakalira.” ");
INSERT INTO gwr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“Atyanu okumala enaku musanvu, muli nʼokulya migaati egibulamu okazumbulukuca. Era oku lunaku olusooka oku naku egyo omusanvu, mwatoolanga okazumbulukuca omu bisito byanywe, olwʼokubba omu naku egyo omusanvu, nabuli eyaalyanga emigaati egirimu okazumbulukuca, baabba tibamubala okubba omoiza oku Baisirairi. ");
INSERT INTO gwr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Oku lunaku olusooka nʼolwomusanvu, muli nʼokukumbaana okunsinza Nze oMusengwa. Era timwakola omulimo gwonagwona oku naku egyo eibiri, okutoolaku okutegeka ebyokulya ebimwalya. ");
INSERT INTO gwr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Mukolenge oMukolo gwʼeMigaati eGibulamu okazumbulukuca, nga niiyo engeri eyʼokwebukiriryangaku olunaku olunatooleire ebika byʼabantu baanywe omu kyalo kyʼe Misiri. Kale mukolenge omukolo ogwo nabuli mwanka nʼomu mirembe egyaliirawo, okwebukirya olunaku olwo. Era eryo lyabbanga iteeka eryʼenkalaakalira eeri inywe. ");
INSERT INTO gwr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Okuzwera akanaigulo akʼolunaku olweikumi na ina olwʼomweri ogusooka, paka omu kanaigulo akʼolunaku lwa 21, muli nʼokulya migaati egibulamu okazumbulukuca. ");
INSERT INTO gwr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Omu naku egyo omusanvu, okazumbulukuca tiyabbanga omu bisito byanywe. Ekyo kityo olwʼokubba nabuli eyaalyanga ekintu ekirimu okazumbulukuca, waire Mwisirairi ooba omunamawanga atyaime mwinywe, baabbanga tibamubala okubba moiza oku Baisirairi. ");
INSERT INTO gwr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Era omu naku egyo timwalyanga emigaati egirimu okazumbulukuca. Omu bisito byanywe, mulyenge migaati egibulamu okazumbulukuca.” ");
INSERT INTO gwr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Awo oMusa nʼatumisya ni beeta abeekubbemberi bonabona abʼaBaisirairi, nʼabakoba ati, “Nabuli musaiza omu kisitokye ali nʼokusuna ontaama omutomuto ooba ombuli omutomuto era amwite abbe wʼoMukolo gwʼoKutambukirya. ");
INSERT INTO gwr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mwakwata omuganda gwʼobusaale obubeeta oyisopu, ni mwinika omu musaaye gwʼekyayo ekyo ekimwabba mwitire oguli omu kibya, ni mugusiiga oku myango nʼoku mikiiko gyʼemyango gyʼenyumba gyanywe. Era tiwaabbaawo kadi moiza kwinywe awuluka omu nyumba, paka makeezi. ");
INSERT INTO gwr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","OMusengwa oweyabita omu kyalo kyʼe Misiri okubonereza aBamisiri, nʼabona omusaaye oku mikiiko gyʼemyango, nʼoku myango, yabita oku nyumba gyanywe. Era tiyaikirirye omalaikawe owʼokufa okwingira omu nyumba gyanywe okubabonereza.” ");
INSERT INTO gwr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Awo oMusa ni yeeyongera ati, “Inywe nʼeibyaire lyanywe muli nʼokweyongera okukolanga omukolo ogwo nabuli mwanka emirembe nʼemirembe. ");
INSERT INTO gwr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Era owemwalibba mutuukire omu kyalo, oMusengwa ekiyasuubizire okubawa, muli nʼokukolanga omukolo ogwo. ");
INSERT INTO gwr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Abaana baanywe owebababuulyanga bati, ‘Omukolo ogwo gutegeeza niki?’ ");
INSERT INTO gwr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mwabairangamu muti, ‘Niiyo esadaaka eyʼoMukolo ogwʼoKutambukirya kwa Musengwa. Ekyo kityo olwʼokubba yatambukiirye enyumba gyʼaBaisirairi omu Misiri, oweyabonerezeire aBamisiri, neye nʼatambukirya ebisito byaiswe.’ ” Awo aBaisirairi ababbaire aawo ni bakotamya emitwe gyabwe ni basinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Era aBaisirairi ni baaba ni bakolera nakimo ngʼoMusengwa oweyalagiire oMusa nʼAlooni. ");
INSERT INTO gwr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Atyanu omu kiire aakati, oMusengwa nʼaita nabuli mwana omwisuka omubere mu buli kisito kya Mumisiri. Yaitire okuzwa oku mutaane wa Falaawo omubere eyabbaire eyaabba omusikawe, paka ku buli mwana omwisuka omubere wa buli musibe eyabbaire omu mabbuusu. Era nʼaita nabuli kyayo ekisaiza ekibere ekyʼaBamisiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Omu kiire ekyo oFalaawo nʼabakungube bonabona era nʼaBamisiri bonabona ni balamuka. Ni wabbaawo okukuukulya omu kyalo kyonakyona ekyʼe Misiri, olwʼokubba mpaawo kisito etikyafiiremu omuntu. ");
INSERT INTO gwr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Omu kiire ekinanyere ekyo oFalaawo nʼalagira ni beeta oMusa nʼAlooni kaisi nʼakoba ati, “Musetukiremu, muzwe omu kyalo kyange, inywe nʼabantu baanywe bonabona, mwabe musinze oMusengwa, ngʼokusaba kwanywe obwekuli. ");
INSERT INTO gwr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Era mwabe nʼentaama, nʼembuli, nʼente gyanywe ngʼowemwasabire. Nʼekindi, munsabire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ABamisiri ni basindikirirya aBaisirairi bayanguwe okuzwa omu kyalo kyʼe Misiri, nga bakoba bati, “Singa timwabe, swenaswena twaba kufa!” ");
INSERT INTO gwr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kale abantu ni baizulya amatiba gaabwe engaano enkande, neye nga mpaamu okazumbulukuca, era amatiba ni bagasiba nga bakolesya engoye gyabwe, era ni bagagingira oku mabega gaabwe. ");
INSERT INTO gwr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","ABaisirairi babbaire bakolere ngʼoMusa oweyabbaire abakobere, nga basabire aBamisiri ebintu ebyʼefeeza, nʼebyʼezaabbu era nʼebizwalo. ");
INSERT INTO gwr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","OMusengwa yabbaire awaire aBaisirairi obukoda eeri aBamisiri, era nga bawaire aBaisirairi ebintu ebibabbaire babasabire. Era omu ngeri eyo aBaisirairi ni batwala ebyobusuni byʼaBamisiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ABaisirairi ni basimbuka okuzwa omu kibuga e Lameseesi okwaba e Sukosi nʼebigere. Babbaire abasaiza ooti 600,000, nga tobaliireku abakali nʼabaana. ");
INSERT INTO gwr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Abantu abandi bangi ino abatali Baisirairi bona ni baaba nabo, nʼebiraalo byʼentaama, nʼebyʼembuli, nʼebyʼente. ");
INSERT INTO gwr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nga bali omu lugendo lwabwe, basumbire emigaati egibulamu okazumbulukuca omu ngaano enkande egibabbaire bazwire nagyo e Misiri. Ekyo kityo olwʼokubba babbaire babagwerenkereire ni bababbinga omu Misiri nga bakaali okutegeka ebyokulya ooba okukanda engaano egirimu okazumbuluca. ");
INSERT INTO gwr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Atyanu aBaisirairi babbaire bamalire emyanka 430 omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Era oku lunaku olwo olunanyerenyeere emyanka egyo 430 olugyawereireku, ebika byonabyona ebyʼabantu ba Musengwa ni bizwa omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Omu kiire ekyo oMusengwa nʼatuukirirya ekisuubizokye nʼatoola abantube omu kyalo kyʼe Misiri. Nʼolwekyo nabuli mwanka, omu kiire kyʼolunaku olwo, aBaisirairi bakolanga oMukolo ogwʼoKutambukirya, nʼomu mirembe egyaliirawo. Omukolo ogwo bagukolanga olwʼokwebukirya oMusengwa oweyabanunuliire okuzwa omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","OMusengwa nʼakoba oMusa nʼAlooni ati, “Ganu niigo amateeka gʼoMukolo gwʼoKutambukirya: “Timwikiriryanga omunamawanga okulya oku nyama yʼomukolo ogwo. ");
INSERT INTO gwr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Neye nabuli mugalama ogumwagulire yagiryangaku, nga mumalire kumukomola. ");
INSERT INTO gwr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Omugeni nʼomupakasi timubaikiriryanga okugiryaku. ");
INSERT INTO gwr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Enyama yʼoMukolo gwʼoKutambukirya bateekwa kugiriira mu nyumba e gibategekeire omukolo ogwo. Era timuwulucanga omu nyumba eeyo enyama eyo, era timuvunanga eigumba kadi limo eryʼekyayo ekimwitire oku mukolo ogwo. ");
INSERT INTO gwr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ABaisirairi bonabona baaba okukolanga omukolo ogwo ni bajaagaana. ");
INSERT INTO gwr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Omunamawanga atyama mwinywe, oweyatakanga okukola oMukolo gwʼoKutambukirya, okugulumalya oMusengwa, nabuli musaiza nabuli mwisuka owʼomu kisitokye, basookanga kumukomola. Olwo kaisi ni bamubitya ngʼoMwisirairi omubyalwa, era ni bamwikirirya okujaguza. Neye atali mukomole, timumwikiriryanga okugiryaku. ");
INSERT INTO gwr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Amateeka ago abagakwatanga baabbanga Baisirairi ababyalwa, nʼabanamawanga abatyama mwinywe.” ");
INSERT INTO gwr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","ABaisirairi bonabona, ni bakolera nakimo ngʼoMusengwa oweyalagiire oMusa nʼAlooni. ");
INSERT INTO gwr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Era oku lunaku olunanyere olwo, oMusengwa nʼatoola aBaisirairi omu kyalo kyʼe Misiri, kika ku kika. ");
INSERT INTO gwr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Muwongenge abaana bonabona abaisuka ababere ni babba bange. Omu Baisirairi nabuli mwana omwisuka omubere omukali ogwabyala abbenge wange, era nʼekyayo ekisaiza ekibere kibbenge kyange.” ");
INSERT INTO gwr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Awo oMusa nʼakoba abantu ati, “Mukolenge omukolo gwʼokwebukirya olunaku olwo olumwazwereire omu kyalo kyʼe Misiri, e gimwabbaire omu bugalama. Ekyo kityo olwʼokubba oMusengwa yabatoire omu kyalo ekyo ngʼakolesya obwezyebwe obwʼamaani. Oku lunaku olwo timulyanga ekyokulya ekirimu okazumbulukuca. ");
INSERT INTO gwr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Olwatyanu omu mweri ogubeeta Abbibbu, muli kwaba. ");
INSERT INTO gwr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","OMusengwa oweyabatuuca omu kyalo ekyo ekyʼaBakanani, nʼaBakiiti, nʼaBamooli, nʼaBakiivi, nʼaBayebbusi, ekyalo ekiyalayiriire abazeiza baanywe ati yalikibawa inywe, ekirimu ebyobusuni era ekiizwire amata nʼomujenene, muli nʼokukolanga omukolo gunu omu mweri ogwo nabuli mwanka. ");
INSERT INTO gwr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Okumala enaku musanvu, mwalyanga kyokulya ekibulamu okazumbulukuca, era oku lunaku olwomusanvu, mwakolanga omukolo gwʼokuwa oMusengwa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Emigaati egibulamu okazumbulukuca niigyo egimwalyanga omu naku egyo omusanvu. Era tiwaabbangawo migaati egirimu okazumbulukuca, waire okubba nʼokazumbulukuca omu kyalo kyanywe kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Oku lunaku olwo, musonzoleranga abaana baanywe muti, ‘Ekyo tukikola olwʼebyo oMusengwa ebiyatukoleire owetwazwereire omu kyalo kyʼe Misiri.’ ");
INSERT INTO gwr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Omukolo ogwo gwabbanga kamanyiciryo akenkalaakalira egimuli akali oti nkozu oku ngalo gyanywe ooba oku mpumi gyanywe, okubeebukirisyanga aMateeka ga Musengwa agemwayegere ni mugabbutulanga bulijo. Ekyo kityo olwʼokubba oMusengwa yatutoire omu kyalo kyʼe Misiri ngʼakolesya obwezyebwe obwʼamaani. ");
INSERT INTO gwr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Nʼolwekyo muli nʼokukolanga omukolo ogwo omu biseera byagwo ebituuce nabuli mwanka.” ");
INSERT INTO gwr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Oluzwanyuma ngʼoMusengwa abatuucirye omu kyalo kyʼaBakanani era ngʼakibawaire ngʼoweyabalayiriire inywe nʼabazeiza baanywe, ");
INSERT INTO gwr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","mwawangayo eeri oMusengwa abaana ababere bonabona. Abaana abaisuka ababere bonabona baabbanga ba Musengwa, era nʼebyayo ebisaiza ebibere, byabbanga bibye. ");
INSERT INTO gwr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Neye ompunda omusaiza omubere, mwamununulanga nga musadaaka ntaama omutomuto. Era ooba nga timumununwire, mwamuvunanga ikoti okumwita. Era mwanunulanga abaana baanywe abaisuka ababere bonabona. ");
INSERT INTO gwr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Era omu biseera ebiiza, abaana baanywe owebababuulyanga bati, ‘Ekyo kitegeeza niki?’ Mwabairangamu muti, ‘OMusengwa yakoleserye obwezyebwe obwʼamaani nʼatutoola omu kyalo kyʼe Misiri, omu twabbaire omu bugalama. ");
INSERT INTO gwr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","OFalaawo oweyakoleire ekyeju, nʼatugaana okuzwa omu kyalo kyʼe Misiri, oMusengwa nʼaita omu kyalo ekyo abaana abaisuka ababere bonabona, nʼebyayo byonabyona ebisaiza ebibere. Kagira tuwaayo esadaaka eeri oMusengwa eya buli kyayo ekisaiza ekibere, era ni tununula abaana baiswe abaisuka ababere bonabona.’ ");
INSERT INTO gwr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Era omukolo ogwo gwabbanga kamanyiciryo akenkalaakalira egimuli akali ooti nkozu oku ngalo gyanywe ooba oku mpumi gyanywe, okubeebukirisyanga ngʼoMusengwa oweyabatoire omu kyalo kyʼe Misiri ngʼakolesya obwezyebwe obwʼamaani.” ");
INSERT INTO gwr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Awo oFalaawo oweyaikiriirye aBaisirairi okuzwa omu kyalo kyʼe Misiri, oKibbumba nandi nʼababitya omu nzira ebitira omu kyalo kyʼaBafirisuuti, newankubbaire nga niiyo eyabbaire eyʼokumpi. Ekyo kityo olwʼokubba oKibbumba yakobere ati, “Demba abantu ni bacuusa ebiseego byabwe, ni bairayo e Misiri, owebalibona nga waliwo ababalumbire okukola olutalo.” ");
INSERT INTO gwr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kagira yabatwaire ni basyomerera mu nzira e yʼomwidungu, oku mbale kwʼeNyanza eNtukuliki. ABaisirairi bazwire omu kyalo kyʼe Misiri nga bali nʼebyokulwanisya. ");
INSERT INTO gwr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Owebabbaire nga baaba, oMusa nʼatwala amagumba ga Yusufu, ngʼoYusufu oweyalayirisirye aBaisirairi ngʼakoba ati, “OKibbumba oweyalibanunula, mutwalanga amagumba gange nga muzwa aanu.” ");
INSERT INTO gwr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ABaisirairi ni bazwa omu Sukosi nga batambula, ni bakomeka eweema gyabwe omwEsamu, oku nsalo nʼeidungu. ");
INSERT INTO gwr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Omusana oMusengwa nʼabakubbemberangamu ngʼali omu kireri ekiterembereri ooti kikondo okubalaga enzira. Era obwire nʼabakubbemberangamu ngʼali omu omusyo omuterembereri ooti kikondo okubawa ekitangaala, kaisi bayezye okutambula omusana nʼobwire. ");
INSERT INTO gwr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ekireri ekiterembereri ooti kikondo omusana, waire omusyo omutererembereri ooti kikondo obwire tibyazwanga omumaiso gʼabantu abo okubeekubbemberamu. ");
INSERT INTO gwr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Okobe aBaisirairi bakange e nyuma, bakomeke eweema gyabwe okumpi nʼekibuga Payi Kakiroosi, aakati wʼekibuga oMigidooli nʼenyanza. Bali nʼokukomeka eweema gyabwe nakimo mumaiso wʼekibuga Bbaali Zefoni. ");
INSERT INTO gwr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","OFalaawo yaseega ati aBaisirairi batambulatambula omu kyalo nga babula gibaaba, eidungu libalobeesereirye okweyongerayo. ");
INSERT INTO gwr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Njaba okukakanyalya omwoyo gwa Falaawo abasengesye, kaisi mmuwangule nʼamajeege gonagona, neesunire ekitiisya. Era aBamisiri balimanya bati Ninze oMusengwa.” Kale aBaisirairi ni bakola batyo. ");
INSERT INTO gwr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","OFalaawo owebamukobeire bati abantu basodokere, iye nʼabakungube ni bacuusa ekiseego, ni bakoba bati, “Niki kinu ekitukolere? Tulekere aBaisirairi okwaba, ni tubafiirwa okubba abagalama baiswe?” ");
INSERT INTO gwr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Awo nʼalagira ni bategeka ekigaalikye omwatambulira era bategeke nʼamajeege. ");
INSERT INTO gwr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Nʼayaba nʼebigaalibye 600 ebikiramu obusa era nʼebindi byonabyona ebyʼomu kyalo kyʼe Misiri. Oku bigaali ebyo byonabyona nga nabuli kimo kiriku omuduumiri. ");
INSERT INTO gwr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","OMusengwa nʼakakanyalya omwoyo gwa Falaawo, kaisi oFalaawo nʼasenjaaku aBaisirairi ababbaire baaba nga bagumu. ");
INSERT INTO gwr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Amaje gʼaBamisiri aamo nʼembalaasi gyonagyona egya Falaawo nʼebigaalibye nʼamaje agʼoku mbalaasi, ni babasenjaaku, ni babaajirya nga basiisiire oku mbale kwʼenyanza, okumpi nʼe Payi Kakiroosi, ekiringiriire e Bbaali Zefoni. ");
INSERT INTO gwr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ABaisirairi owebasiirirye amaiso, ni babona oFalaawo nʼamajeege nga baiza baigereire okubatuukaku, ni batya, ni beekungirira oMusengwa ababbeere. ");
INSERT INTO gwr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ni beezuluguma nga bakoba oMusa bati, “Omu kyalo kyʼe Misiri mwabbaire mpaamu magombe? Niikyo ekyagirire nʼotuleeta okufeera omwidungu? Wagendereire niki okututoola omu kyalo kyʼe Misiri? ");
INSERT INTO gwr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kinu tiniikyo ekitwakukobere nga tukaali tuli omu kyalo kyʼe Misiri tuti otuleke tubbe bagalama bʼaBamisiri? Kasinga tubba bagalama bʼaBamisiri, okukiraku okufeera omwidungu!” ");
INSERT INTO gwr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Awo oMusa nʼakoba aBaisirairi ati, “Timwatya! Mubbe bagumu, olwo mwabona oMusengwa ngʼabanunula olwatyanu. Ekyo kityo olwʼokubba aBamisiri abemubona atyanu, timwaliirayo okubabonaku tete. ");
INSERT INTO gwr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","OMusengwa ayaba okubalwanira inywe. Ekibeetaagisya inywe, kubba baikaikani.” ");
INSERT INTO gwr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Awo oMusengwa nʼakoba oMusa ati, “Lwaki onkungirira okukubbeera? Okobe aBaisirairi basimbuke beeyongereyo omumaiso. ");
INSERT INTO gwr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Era okwate omukoomerogwo, kaisi osiirye engalo oku nyanza, amaizi gagawukemu aakati. Olwo aBaisirairi babite omu nyanza nga nkalu. ");
INSERT INTO gwr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nze njaba okukakanyalya emyoyo gyʼaBamisiri, baabe omu nyanza okubasenjaaku, kaisi mpangule oFalaawo nʼamajeege gonagona, nʼebigaalibye nʼamajeege agʼoku mbalaasi neesunire ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ABamisiri bamanya nga Ninze oMusengwa, owenamala okuwangula oFalaawo nʼebigaalibye nʼamajeege agʼoku mbalaasi.” ");
INSERT INTO gwr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Awo omalaika wa Musengwa eyeekubbemberangamu amaje gʼaBaisirairi, nʼazwayo nʼaira e nyuma waabwe. Nʼekireri ekiterembereri ooti kikondo ni kizwa omumaiso waabwe, ni kyaba e nyuma waabwe, ");
INSERT INTO gwr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","nʼekibba aakati wʼaBamisiri nʼaBaisirairi. Ekireri ekyo ni kireetera aBamisiri endikiirya, neye ni kiwa aBaisirairi ekitangaala, nandi ni baigereranganaku ekiire kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","OMusa nʼasiirya engaloye oku nyanza, oMusengwa nʼasindika oku nyanza ogumpunga ogwʼamaani oguzwa e buzwaisana. Ni gufuwa ekiire kyonakyona, enyanza nʼagisuuca lukalu. Amaizi ni geeyawulamu aakati. ");
INSERT INTO gwr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ABaisirairi ni babita wakalu aakati omu nyanza, amaizi nga gakolere ontuumo ni gabba ooti kitempe oku lubba lwabwe olwʼengalo endiiro nʼolwʼengooda. ");
INSERT INTO gwr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ABamisiri ni babasenjaaku omu nyanza, nga bali nʼembalaasi gyonagyona egya Falaawo, nʼebigaalibye, nʼamajeege agʼoku mbalaasi. ");
INSERT INTO gwr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Awo ekibbambya, oMusengwa ngʼasinzirira omu musyo omuterembereri ooti kikondo nʼekireri ekiterembereri ooti kikondo nʼalola ansi nʼabona amaje gʼaBamisiri, nʼagatabulatabula. ");
INSERT INTO gwr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Nʼagedyaga ebidangadi byʼebigaali byabwe ebyʼamaje, ni kibakaluubirira okubivuga. ABamisiri ni bakoba bati, “Twiruke aBaisirairi, olwʼokubba oMusengwa niiye atulwanisya ngʼabalwanirira!” ");
INSERT INTO gwr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Awo oMusengwa nʼakoba oMusa ati, “Osiirye engaloyo oku nyanza amaizi gairewo, geesuke oku Bamisiri, nʼoku bigaali byabwe, nʼoku maje gʼoku mbalaasi.” ");
INSERT INTO gwr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kale oMusa nʼasiirya engaloye oku nyanza, era amakeezi, enyanza nʼeirawo omu mbeera yaayo eyʼobulijo. ABamisiri ni bagezyaku okugiirukamu, neye oMusengwa nʼabamuma aakati omu nyanza nago. ");
INSERT INTO gwr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Amaizi ni gairawo, ni gabbuunaku ebigaali nʼamajeege agʼoku mbalaasi. Ekikoba kiti, amaje ga Falaawo gonagona agabbaire gasenjerye aBaisirairi omu nyanza, nandi ni walamaku kadi moiza. ");
INSERT INTO gwr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Neye aBaisirairi babbaire batambuliire omu nyanza nga babitire wakalu, ngʼamaizi geeyawirewo ni gakola ontuumo ooti kitempe oku lubba lwabwe olwʼengalo endiiro nʼolwʼengooda. ");
INSERT INTO gwr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ABaisirairi oku lunaku olwo, oMusengwa nʼabalamya aBamisiri. Era aBaisirairi ni babona aBamisiri nga bafiire balangaire oku mbale kwʼenyanza. ");
INSERT INTO gwr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","ABaisirairi owebaboine obwezye obwʼamaani oMusengwa oweyakoleserye okulwanisya aBamisiri, aBaisirairi ni batya oMusengwa. Era ni baikiririrya omu Kibbumba, era nʼomu Musa omuweereryawe. ");
INSERT INTO gwr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Awo oMusa nʼaBaisirairi ni bembera oMusengwa olwembo lunu bati, “Nayemberanga oMusengwa, olwʼokubba awanguliire nakimo ino abalabebe! Embalaasi nʼabagityamaku abidyakire omu nyanza. ");
INSERT INTO gwr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","OMusengwa niiye ampa amaani era niiye olwembo lwange; niiye andamirye abalabe. Niiye oKibbumba wange, era nʼamuwuujanga. Niiye oKibbumba wa bbaabba era nʼamugulumalyanga. ");
INSERT INTO gwr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","OMusengwa niiye omulwani wʼolutalo omuzira, eriinalye niiye oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Adyakire omu nyanza ebigaali bya Falaawo nʼamajeege. Abaisirikale abakugu omu maje ga Falaawo oKibbumba abaitiire omu Nyanza eNtukuliki! ");
INSERT INTO gwr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Olwabi lubamirire, beinikiire nakimo omu lwabi ngʼeibbaale. ");
INSERT INTO gwr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“Oo Musengwa, okoleserye engaloyo endiiro eyʼamaani amabitiriri, era nʼotentena omulabewo. ");
INSERT INTO gwr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Omu buwangulibwo obwʼamaani oyinga abalabebo. Obusungubwo bumeigera, ni bubooca ni baya ooti bisubi. ");
INSERT INTO gwr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ofuwire omwota ogwʼomu nindoyo oku nyanza, amaizi ni gakola ontuumo. Amaizi ni gawolomboga geekomeka ooti kitempe. Amaizi omu lwabi ni geekwata ekibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Omulabewo akobere ati, ‘Njaba kubasenjaaku mmbairyewo. Njaba okugabula ebyobusuni byabwe, neetwalire byonabyona ebintaka. Njaba okukuusayo empiima yange, era mbajigirice.’ ");
INSERT INTO gwr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Neye ofuwire omwotagwo, enyanza nʼebabbuuna. Beinikire ni bagoteramu ooti kyoma ekizito omu maizi agafuuja. ");
INSERT INTO gwr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“Oo Musengwa, omu bakibbumba naani aali ooti niiwe? Naani aali ooti niiwe; owʼekitiisya era omutukulye owentiisya ogubawuuja, era akola ebyewunyo? ");
INSERT INTO gwr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Wagoloire engaloyo endiiro, ekyalo ni kimira abalabe baiswe. ");
INSERT INTO gwr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Omu kisaakyo, okubbembera abantu aboonunula. Omu maanigo obatuuca e gyobba omu kifookyo ekitukulye. ");
INSERT INTO gwr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Amawanga galiwulira era ni gatya, abʼomu Bufirisuuti entiisya nʼebakwata. ");
INSERT INTO gwr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Abakungu bʼEdomu baliwuninkirira, nʼabeekubbemberi bʼe Mowaabbu ensisi nʼebakwata; abatyami bʼomu Kanani ni babbalika olwʼentiisya; ");
INSERT INTO gwr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","baliwaamu omwoyo, nʼentiisya nʼebagwaku olwʼobwezyebwo obwʼamaani. Ni babba nga tibeesagalya ooti mabbaale agali aawo, paka abantubo Musengwa owebakumba ni babitawo. Era paka abantubo aboonunwire, owebabitawo. ");
INSERT INTO gwr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Walibangirya nʼobateeka oku lusozi olulwo oku lulwo, ekifo iwe Musengwa ekiwalondere okubbangamu. EWeema eya Musengwa eyo, Musengwa iwe onanyere egiweeyombekeire. ");
INSERT INTO gwr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Musengwa wafuganga emirembe nʼemirembe.” ");
INSERT INTO gwr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ABaisirairi ni babita omu nyanza nga batambulira wakalu kwitakali. Neye ebigaali bya Falaawo aamo nʼamaje gʼoku mbalaasi, owebaingiire omu nyanza, oMusengwa nʼairyawo amaizi, ni gababbuunaku. ");
INSERT INTO gwr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Awo oMiryamu onaabbi, omwonyoko wʼAlooni, nʼakwata akagoma, abakali bonabona ni bamusengererya nga bakubba obugoma era nga babina. ");
INSERT INTO gwr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","OMiryamu nʼayemba olwembo ati, “Mwembere oMusengwa, olwʼokubba awangwire. Adyakire omu nyanza embalaasi nʼamaje gaaku.” ");
INSERT INTO gwr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Awo oMusa nʼakubbembera aBaisirairi okuzwa oku Nyanza eNtukuliki, ni batuuka omwidungu lyʼe Suuli. Ni batambula enaku isatu omwidungu, nga tibabonaku maizi. ");
INSERT INTO gwr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Era ni batuuka omu kifo ekibeeta bati, Maala, ni batayezya okunywa amaizi gaayo, olwʼokubba gabbaire malulu. Ekifo ekyo kagira bakyeta Maala. ");
INSERT INTO gwr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kale abantu ni beezuluguumira oMusa nga bakoba bati, “Twanywa niki?” ");
INSERT INTO gwr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","OMusa ni yeegairira oMusengwa, era oMusengwa nʼamulaga ekisaale, oMusa nʼakimuma omu maizi ni gasuuka masa. E Mala niiyo oMusengwa e giyabaweereire aMateeka agebasengereryanga, era niiyo e giyabagezeseirye okubona ooba nga bamugonderanga. ");
INSERT INTO gwr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Era oKibbumba yakobere ati, “Owemwawulisisyanga eigono lyange nze oMusengwa iye oKibbumba waanywe nʼokwekeenenya, ni mukola ebituuce omumaiso gange, era owemwakwatanga aMateeka gange, ni mugonderanga nʼebiragiro byange byonabyona, tinalibateekaku endwaire eginateekere oku Bamisiri. Ekyo kityo olwʼokubba Ninze oMusengwa abalamya inywe endwaire.” ");
INSERT INTO gwr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Awo ni batuuka omwErimu, awabbaire ensulo gyʼamaizi eikumi na ibiri, nʼebikolo byʼensansa 70, ni bakomeka aawo eweema gyabwe okumpi nʼensulo egyo. ");
INSERT INTO gwr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Atyanu ekibbula kyonakyona ekyʼaBaisirairi ni kizwa omu kifo ekibeeta Erimu. Era oku lunaku lweikumi na itaanu olwʼomweri ogwokubiri nga wabitirewo omweri gumo okuzwa ngʼowebazwire omu kyalo kyʼe Misiri ni batuuka omwidungu lyʼe Siini, eriri aakati wʼErimu nʼolusozi oSinaayi. ");
INSERT INTO gwr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Era eeyo omwidungu, aBaisirairi bonabona ni beezulugumira oMusa nʼAlooni, ");
INSERT INTO gwr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","nga babakoba bati, “Kadi singa oMusengwa yabbaire atwitiire omu kyalo kyʼe Misiri. Afazaali eeyo twatyamanga ni tulya enyama nʼebyokulya ebindi byonabyona ni twikuta. Neye ni mutuleeta omwidungu linu, okutwitisya nʼenzala!” ");
INSERT INTO gwr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Awo oMusengwa nʼakoba oMusa ati, “Atyanu njaba kubasindikira ekyokulya kigwenge okuzwa omwigulu ngʼoikendi owaatoonya. Era abantu bawulukanga buli lunaku okuyoola ekyokulya ekyabamalanga olunaku olwo. Kaisi omu ngeri eyo, mbe nga mbagezesya okumanya ooba nga bagonderanga ebiragiro byange ooba bbe. ");
INSERT INTO gwr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Oku lunaku olwomukaaga nabuli saabbiiti, bayoolanga ni baingirya ekyokulya kyʼemirundi mibiri kwekyo ekibayoola nabuli lunaku era ni bakitegeka.” ");
INSERT INTO gwr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kale oMusa nʼAlooni ni bakoba aBaisirairi bonabona bati, “Olwatyanu eigulo mwamanya muti, oMusengwa niiye eyabatoire omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Era eizo amakeezi mwabona ekitiisya kya Musengwa, olwʼokubba awuliire owemumwezulugumiire. Aale niiswe abanaani, kaisi mutwezulugumire?” ");
INSERT INTO gwr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Era oMusa nʼakoba ati, “OMusengwa niiye eyabawanga enyama, ni mulyanga nabuli igulo, era nabuli makeezi niiye eyabawanga ekyokulya ni mulya ni mwikuta, olwʼokubba awuliire owemumwezulugumiire. Aale niiswe abanaani? Timwezulugumiire niiswe, wazira mwezulugumiire Musengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Awo oMusa nʼakoba Alooni ati, “Okobe ekibbula kyonakyona ekyʼaBaisirairi oti, ‘Mwigerere omumaiso ga Musengwa, olwʼokubba awuliire okwezuluguma kwanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Atyanu Alooni oweyabbaire ngʼatumula eeri ekibbula kyonakyona ekyʼaBaisirairi, ni kigaluka ni kirola omwidungu, amangu ago ekitiisya kya Musengwa ni kibonekera omu kireri. ");
INSERT INTO gwr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mpuliire okwezuluguma kwʼaBaisirairi. Atyanu obakobe oti, ‘Nabuli igulo mwabbanga nʼenyama egimwalyanga, nabuli makeezi mwabbanga nʼekyokulya ekimwalyanga ni mwikuta. Olwo kaisi mumanye nga Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Eigulo eryo enindu ni giiza, ni gibba buli wantu omu nkambi. Amakeezi, olume ni lukwata okumalaku enkambi. ");
INSERT INTO gwr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Olume owerwawoireku, obuntu obutontono obuwulumba ni bubonekawo okwitakali omwidungu, era nga buboneka ooti mabbaale ga ikendi. ");
INSERT INTO gwr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ABaisirairi owebabuboine, nandi ni babutegeera. Ni beebuulyangana bati, “Niki ekyo?” OMusa nʼabakoba ati, “Ekyo niikyo ekyokulya, oMusengwa ekyabawaire okulya. ");
INSERT INTO gwr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Era oMusengwa alagiire ati, ‘Nabuli moiza kwinywe ayooleku ekyokulya ekyayezya okulya nʼamalawo. Nabuli moiza atwalire abʼomu weemaye, era nga nabuli muntu amutwalira ekiro ooti ibiri.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","ABaisirairi ni bakola ngʼoMusegwa oKibbumba oweyabalagiire. Abamo ni bayoola ekyokulya ekyera, abandi kitono. ");
INSERT INTO gwr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Neye owebapimangamu, eyaabbanga ayoire ekyokulya ekyera, tiyaabbanga nʼekyera eino, nʼeyaabbanga ayoire ekitono, yaabbanga nakyo ekimumala. Nabuli muntu yayoolanga ekimumala. ");
INSERT INTO gwr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Awo oMusa nʼabakoba ati, “Tiwaabbaawo omuntu kadi moiza abisaku ekiyaalya eizo.” ");
INSERT INTO gwr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Neye abamo nandi ni bawulisisya oMusa, ni babisaku ekibaalya eizo. Neye okwaba okuca, kyabbaire kiizwire amagino, era nga kifunya. Kale oMusa nʼabasunguwalira ino. ");
INSERT INTO gwr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Okuzwa kwolwo nabuli makeezi, nabuli muntu yayoolanga ekiyaalya nʼamalawo. Era eisana oweryocanga, ekyabbanga kisigairewo okwitakali, nga kinyeenyeera. ");
INSERT INTO gwr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Atyanu oku lunaku lwomukaaga, ni bayoola ekyokulya kyʼenaku ibiri, ekiro ooti ina egya buli moiza. Era abeekubbemberi bonabona abʼaBaisirairi ni baiza, ni bakobera oMusa ekibbairewo. ");
INSERT INTO gwr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","OMusa nʼabakoba ati, “OMusengwa alagiire ati, eizo lunaku lwa kuwuumuliraku, era Saabbaato, era lunaku lwʼokuwa Musengwa kitiisya. Kale musumbe ebimutaka okusumba, era mutokotye ebimutaka okutokotya. Ekyokulya ekyasigalawo mukikuume, paka izo makeezi.” ");
INSERT INTO gwr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kale ni babisa ekyasigairewo paka eizo waaku, ngʼoMusa oweyabbaire alagiire, era nandi ni kifunya, waire kugwamu amagino. ");
INSERT INTO gwr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","OMusa nʼakoba ati, “Mulye ekyokulya ekyo olwatyanu, olwʼokubba olwatyanu Saabbaato, lwʼokuwa Musengwa kitiisya. Era olwatyanu e nza timwajiryeyo ekyokulya kadi. ");
INSERT INTO gwr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Muli nʼokuyoola ekyokulya omu naku mukaaga nabuli saabbiiti, neye oku lunaku olwomusanvu, oku Saabbaato ekyokulya tikyabbengeyo kadi.” ");
INSERT INTO gwr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Neye era oku lunaku olwomusanvu olwo, abantu abamo baabire okuyoola ekyokulya nago, neye ni batakyajiryayo. ");
INSERT INTO gwr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Awo oMusengwa nʼakoba oMusa ati, “Mwalituuca di okugaana okukwata amateeka gange nʼokutagondera ebiragiro byange? ");
INSERT INTO gwr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Mukimanye muti, Nze oMusengwa, mbawaire eSaabbaato, kagira mbawa oku lunaku lwomukaaga, ekyokulya ekibamalisyaku enaku ibiri. Nabuli muntu oku lunaku lwomusanvu ali nʼokusigala mu kisito egyabba era tazwangawo. ");
INSERT INTO gwr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kale abantu ni bawuumula oku lunaku lwomusanvu.” ");
INSERT INTO gwr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ABaisirairi ni bawa ekyokulya ekyo eriina bati maanu. Yabbaire njeru nga ntontono ooti nsigo wʼekimera ekibeeta kolyanda. Era emaanu eyo ngʼewooma ooti bugaati obubasumbiiremu omujenene. ");
INSERT INTO gwr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","OMusa nʼakoba ati, “OMusengwa alagiire ati, ‘Mulekekuuwo ekiro nga ibiri egya maanu, mugibise gibbe kyokwebukiriryangaku nʼomu mirembe egyaliirawo. Era kaisi abaizukulu baanywe bayezye okubonangaku ekyokulya ekyo ekinabawaire inywe okulyanga omwidungu, owenabatoire omu kyalo kyʼe Misiri.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Awo oMusa nʼakoba Alooni ati, “Osune ekibya, oteekemu ekiro ooti ibiri egya maanu, kaisi ogiteeke omumaiso ga Musengwa, gibbe kyokwebukiriryangaku nʼomu mirembe egyaliirawo.” ");
INSERT INTO gwr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Alooni nʼagiteeka omumaiso gʼeSanduuku eyʼeNdagaano, bagibise, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ABaisirairi ni balya emaanu okumala emyanka 40, paka owebatuukire omu kyalo kyʼe Kanani e gibabbaire bayezya okutyama. ");
INSERT INTO gwr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Atyanu ekipimo ekibakolesyanga, nga kyenkana ekiro ooti moiza. ");
INSERT INTO gwr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Atyanu ekibbula kyonakyona ekyʼaBaisirairi ni kizwa omwidungu lyʼe Siini, ni batambula kifo ku kifo, ngʼoMusengwa oweyabalagiranga. Ni bakomeka eweema gyabwe omu kifo ekibeeta Lefidiimu, neye tiwabbaireyo amaizi abantu abo okunywa. ");
INSERT INTO gwr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kale abantu nago ni bayombesya oMusa, nga bakoba bati, “Otuwe amaizi tunywe!” OMusa nʼabairamu ati, “Lwaki munnyombesya? Era lwaki mugezesya oMusengwa?” ");
INSERT INTO gwr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Neye abantu enyonta nʼebalumira eeyo ino, era ni beezulugumira oMusa, ni bamukoba bati, “Lwaki watutoire e Misiri okutwitisya nʼenyonta, iswe nʼabaana baiswe nʼebyayo byaiswe?” ");
INSERT INTO gwr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Awo oMusa ni yeegairira oMusengwa ngʼakoba ati, “Abantu banu nakola ntya? Batira okunkubba amabbaale banjite!” ");
INSERT INTO gwr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","OMusengwa nʼairamu oMusa ati, “Oyabe nʼabamo oku beekubbemberi bʼaBaisirairi, mwekubbemberemu abantu era oyabe nʼomukoomero oguwakoleserye okukubba oku Mwiga oKiyira. ");
INSERT INTO gwr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Nze njaba okwemerera omumaisogo eeyo okwibbaale, oku Lusozi oKolebbu. Iwe wakubba okwibbaale eryo, era amaizi gaazwamu, abantu ni banywa.” Kale oMusa nʼakola atyo omumaiso gʼabeekubbemberi bʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Era oMusa nʼawa ekifo ekyo eriina ati, Maasa nʼe Meribba, olwʼokubba aBaisirairi bayombere era ni bagezesya oMusengwa nga bakoba bati, “OMusengwa ali na iswe ooba bbe?” ");
INSERT INTO gwr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Atyanu aBamereki ni baaba ni balumba aBaisirairi omu Lefidiimu. ");
INSERT INTO gwr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Awo oMusa nʼakoba oYoswa ati, “Olondemu abamo oku basaiza aBaisirairi, eizo mwabe mulwane nʼaBamereki. Nze nayemerera oku nairungu wʼolusozi, nga nkwaite omukoomero, oKibbumba oguyankobere okukwatanga.” ");
INSERT INTO gwr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kale oYoswa nʼayaba nʼalwana nʼaBamereki ngʼoMusa oweyamulagiire. Omu kiseera ekinanyere ekyo oMusa, nʼAlooni, nʼoKuuli ni baniina oku nairungu wʼolusozi. ");
INSERT INTO gwr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Era eeyo nabuli oMusa oweyasiiryanga engalogye, aBaisirairi nga bawangula. Neye oweyagiicanga, aBamereki nga bawangula. ");
INSERT INTO gwr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Neye engalo gya Musa ni girubirira. Alooni nʼoKuuli ni bamuleetera eibbaale nʼalityamaku. Kaisi ni bamwemereraku omoiza oku lubba olumo, ogondi oku lubba olundi, ni bakwatirira engalogye gisigalira e ngulu paka eisana okugwa. ");
INSERT INTO gwr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Era omu ngeri eyo oYoswa nʼawangula aBamereki, ngʼakolesya empiima. ");
INSERT INTO gwr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Awo oMusengwa nʼakoba oMusa ati, “Owandiike oku buwanguli obwo omu kitabo, kaisi babwebukiryenge. Era obisomeremu oYoswa, olwʼokubba nalijigirica aBamereki oku kyalo.” ");
INSERT INTO gwr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Awo oMusa nʼayombeka ekyoto, nʼakiwa eriina ati, “OMusengwa niiye obuwanguli bwange.” ");
INSERT INTO gwr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Era nʼakoba ati, “Ekyo kityo olwʼokubba oMusengwa yeeyongera okulwanisya aBamereki emirembe nʼemirembe.” ");
INSERT INTO gwr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Atyanu oYesero okabona wʼaBamidiyaani, era oiteeye wa muka Musa, nʼawulira byonabyona oKibbumba ebiyakoleire oMusa nʼabantu ba Kibbumba aBaisirairi. Era oYesero nʼawulira nʼengeri oMusengwa egiyatoire aBaisirairi omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Kale oYesero nʼayaba egiri oMusa ngʼakanjirye oZipola omwalawe e wa Musa oibaaye. OMusa yabbaire asindikire omukaliwe e waabwe, ");
INSERT INTO gwr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","era ngʼamusindikire aamo nʼabaanabe abaisuka ababiri. Eriina lyʼomwana omoiza niiye oGeresomu, olwʼokubba oMusa yakobere ati, “Ndi munamawanga omu kyalo ekitali kyʼe waiswe.” ");
INSERT INTO gwr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Eriina lyʼomwana ogondi niiye Eryeza, olwʼokubba oMusa yakobere ati, “OKibbumba wa bbaabba yambeereire, nʼandamya okabaka wʼe Misiri okunjita.” ");
INSERT INTO gwr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Awo Yesero omuko wa Musa, aamo nʼabataane bombi aba Musa, nʼomukali wa Musa ni baaba egiri oMusa omwidungu, e giyabbaire akomekere eweemaye okumpi nʼolusozi lwa Kibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","OYesero yabbaire aweereirye obukwenda eeri oMusa ati, “Nze oYesero, oiteeye wa mukaliwo, ndi kwiza eeyo nʼomukaliwo nʼabataanebo bombi.” ");
INSERT INTO gwr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kale oYesero oweyatuukireyo, oMusa nʼazwayo nʼamwaniriza, nʼakotamya omutwe okumuwa ekitiisya, nʼamugwa omu kifubba. Ni basugiryangana, era ni baingira omu weema. ");
INSERT INTO gwr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Awo oMusa nʼalonserya oYesero byonabyona oMusengwa ebiyakolere oFalaawo nʼaBamisiri, olwʼokununula aBaisirairi. Era nʼamulonserya ebigosi byonabyona ebyabatuukireku nga bali omu nzira, era nʼengeri oMusengwa egiyabanunwiremu. ");
INSERT INTO gwr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Awo oYesero nʼasangaala oweyawuliire ebintu ebisa byonabyona oMusengwa ebiyakoleire aBaisirairi omu kubanunula omu bufugi bwʼaBamisiri. ");
INSERT INTO gwr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Era nʼakoba ati, “OMusengwa bamuwuujenge, eyabanunwire omu bufugi bwʼaBamisiri nʼobwa Falaawo. Era oMusengwa bamuwuujenge eyanunwire abantube omu bufugi bwʼaBamisiri! ");
INSERT INTO gwr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Atyanu ntegeire ngʼoMusengwa obwali owʼamaani okukiraku abakibbumba abandi bonabona, olwʼokubba yanunwire abantu abo omu bufugi bwʼaBamisiri ababbaire babajolonga.” ");
INSERT INTO gwr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Awo oYesero, oiteeye wa muka Musa, nʼaleeta esadaaka egibooca yonayona nʼesadaaka egindi okugiwaayo eeri oKibbumba. Era Alooni nʼabeekubbemberi bonabona abʼaBaisirairi ni baaba okulya ekiinulo aamo nʼoiteeye wa muka Musa, omumaiso ga Kibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Oku lunaku olwairireku, oMusa nʼatyama okulamula abantu. Abantu ni babba aawo nga beemereire bamweruguuliriirye, okuzwa amakeezi paka igulo nga bakuumiriire okubalamula. ");
INSERT INTO gwr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","OYesero oiteeye wa muka Musa oweyaboine byonabyona oMusa ebiyabbaire akolera abantu, nʼamubuulya ati, “Nkolaki eyo egyoli kukolosyanga omu bantu? Lwaki olamula wenkani, abantu ni babba aawo nga beemereire bakweruguuliriirye okuzwa amakeezi paka igulo?” ");
INSERT INTO gwr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","OMusa nʼamwiramu ati, “Nkola ntyo olwʼokubba abantu baiza egyendi okumanya okulungamya kwa Kibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Owebabba nʼokayaani, baiza egyendi ni mbalamula, era ni mbakobera amateeka ga Kibbumba nʼebiragirobye.” ");
INSERT INTO gwr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Awo oYesero nʼamukoba ati, “Engeri egyoli kukolamu tinsa. ");
INSERT INTO gwr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Iwe nʼabantu abaiza egyoli mwedembya ino. Omulimo gunu munene ino, toyezya okugukola wenkani. ");
INSERT INTO gwr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Atyanu ompulisisye, oleke nkuweeku amalabuki, era nsaba oKibbumba abbe na iwe. Oli nʼokubbanga mukwenda wʼabantu eeri oKibbumba, nʼokutuucanga ensonga gyabwe egyali. ");
INSERT INTO gwr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Oli nʼokubeegesyanga amateeka nʼebiragiro bya Kibbumba, nʼokubeegesyanga engeri egibasaaniire okwebityangamu, nʼebibasaaniire okukolanga. ");
INSERT INTO gwr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Neye oli nʼokulonda abasaiza abʼamalabuki okubba beekubbemberi baabwe. Abasaiza abo bali nʼokubba nga batya oKibbumba, abʼamazima era abacaawa engunzi. Baabba nga beekubbembera abantu lukumi lukumi, nʼabandi kikumi kikumi, nʼabandi ataanu ataanu, kaisi abandi nga beekubbembera ikumi ikumi. ");
INSERT INTO gwr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Abasaiza abo balamulanga abantu ebiseera byonabyona. Ensonga enene niigyo egibabba bakuleeterenge, neye ensonga entontono bagimalenge ibo abananyere. Owebakubbeeraku okukola omulimo, ekyo kyasuuca omulimogwo okubba mwangu. ");
INSERT INTO gwr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Singa wakolera oku malabuki ago, era oKibbumba nʼakulungamya okukola otyo, awo waabba nga tokaluubirirwa, era abantu banu bonabona bakanganga omu bisito byabwe nga basyanirye.” ");
INSERT INTO gwr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Kale oMusa nʼakolera oku malabuki oYesero ageyamuwaire, nʼakola byonabyona ebiyamukobere. ");
INSERT INTO gwr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Era omu Baisirairi bonabona nʼalondamu abasaiza abʼamalabuki nʼabateekawo okukubbembera abantu. Era abamo ni beekubbembera lukumi lukumi, nʼabandi ni beekubbembera kikumi kikumi, nʼabandi ni beekubbembera ataanu ataanu, kaisi abandi ni beekubbembera ikumi ikumi. ");
INSERT INTO gwr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Era ni balamulanga abantu ebiseera byonabyona. Ensonga enene ni bagireeteranga oMusa, neye entontono, ni bagyemaliranga ibo abananyere. ");
INSERT INTO gwr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Awo oMusa nʼaseebula oYesero, era oYesero nʼakanga omu kyalo kyʼe waabwe. ");
INSERT INTO gwr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Atyanu aBaisirairi ni bazwa e Lefidiimu, era oku lunaku olusooka olwʼomweri ogwokusatu okuzwa ngʼowebazwire omu kyalo kyʼe Misiri, ni batuuka omwidungu lyʼe Sinaayi. Era eeyo ni bakomeka eweema gyabwe okumpi nʼoLusozi oSinaayi. ");
INSERT INTO gwr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Awo oMusa nʼaniina oku lusozi okusangaana oKibbumba. OMusengwa nʼayeta oMusa ngʼasinzirira oku nairungu wʼolusozi, nʼamukoba akobe aBaisirairi abaizukulu ba Yaakobbo ati, ");
INSERT INTO gwr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Mwaboine Nze oMusengwa ebinakolere aBamisiri, nʼengeri eginabagingire inywe ni mbaleeta egyendi, ngʼokokomi owaagingira abaanabe oku biyayabye. ");
INSERT INTO gwr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kale atyanu, owemwagonderanga ebiragiro byange, ni mukuumanga endagaano yange, mwabbanga bantu bange abenkira okutaka omu bantu bonabona, newankubbaire ngʼekyalo kyonakyona kyange. ");
INSERT INTO gwr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Mwabbanga bakabona bʼobwakabaka bwange era igwanga eritukulye. Ebyo niibyo ebiwakobera aBaisirairi.” ");
INSERT INTO gwr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kale oMusa nʼaika okuzwa oku lusozi nʼayeta abeekubbemberi bʼaBaisirairi, nʼabakobera ebyo byonabyona oMusengwa ebiyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Abantu bonabona ni baikirirya nga bairamu bati, “Byonabyona oMusengwa ebyakoba twabikolanga.” Kale oMusa nʼakanga nʼakobera oMusengwa ebyo ebibakobere. ");
INSERT INTO gwr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","OMusengwa nʼakoba oMusa ati, “Njaba okwiza egyoli nga ndi omu kireri ekizizi, kaisi abantu bawulire nga ntumula na iwe, awo bayezye okukwikiririryangamu bulijo.” Awo oMusa nʼakobera oMusengwa abantu ebibakobere. ");
INSERT INTO gwr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","OMusengwa nʼamukoba ati, “Oike ansi e giri abantu era obakobe beetukulye olwatyanu nʼolweizo, era booze ebizwalo byabwe. ");
INSERT INTO gwr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Era babbe nga beetegekere oku lunaku olweizuuli, olwʼokubba oku lunaku olwo, njaba kwika oku Lusozi oSinaayi ngʼabantu bonabona babona. ");
INSERT INTO gwr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Oteekerewo abantu ensalo okweruguulirirya olusozi olwo, era obakobe oti, ‘Mwekuume okutaniina oku lusozi, waire okutuuka oku nsalo yaalwo. Nabuli eyatuuka oku lusozi olwo, baaba kumwita. ");
INSERT INTO gwr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Waire yaabba muntu ooba kisolo, baaba kumwita nga bamukubba mabbaale, ooba nga bamukubba bulaso, nga mpaawo muntu amukwaiteku.’ Wazira ekondeere oweyavuga, awo ngʼabantu baigerera oku lusozi.” ");
INSERT INTO gwr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Awo oMusa nʼazwa oku lusozi nʼaika ansi e giri abantu, nʼabatukulya era ni booza nʼebizwalo byabwe. ");
INSERT INTO gwr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Era oMusa nʼabakoba ati, “Mwetegekere olunaku olweizuuli. Era timwegaita nʼabakali.” ");
INSERT INTO gwr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Owebwaceire amakeezi oku lunaku lwokusatu, ni wabbaawo okubbwatuka kwʼeraadu nʼokumesya kwa ikendi. Ekireri ekizizi nga kibbuunireku onairugu wʼolusozi, era ni bawulira okuvuga kwʼekondeere okwʼangulu eino. Era abantu bonabona ababbaire omu nkambi, ni batukuta. ");
INSERT INTO gwr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Awo oMusa nʼatoola abantu omu nkambi, nʼabatwala okusangaana oKibbumba, era ni beemerera ansi wʼolusozi. ");
INSERT INTO gwr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","OLusozi oSinaayi lwonalwona ni luduunya omwosi, olwʼokubba oMusengwa ngʼali omu musyo yabbaire aikire oku lusozi olwo. Era omwosi ni guzwa omu lusozi ni gwaba e ngulu ooti mwosi gwʼetanuulu era olusozi lwonalwona ni lutengeeta ino. ");
INSERT INTO gwr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Okuvuga kwʼekondeere ni kwaba nga kuniina. Awo oMusa nʼatumula, era oKibbumba nʼamwiramu omwigono eryʼangulu ooti kubbwatuka kwʼeraadu. ");
INSERT INTO gwr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","OMusengwa oweyaikire oku Lusozi oSinaayi, yeetere oMusa okuniina oku nairungu wʼolusozi era oMusa nʼaniinayo. ");
INSERT INTO gwr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Awo oMusengwa nʼamukoba ati, “Oike ansi olabule abantu tibatambuka ensalo okwiza okumbona, olwʼokubba owebakola ekyo bangi kwibo baafa. ");
INSERT INTO gwr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Era nʼabakabona abaigerera okumpi na Nze bali nʼokwetukulya, era owebatakole ekyo nababonereza.” ");
INSERT INTO gwr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","OMusa nʼakoba oMusengwa ati, “Abantu tibayinza okuniina oku Lusozi lunu, olwʼokubba iwe onyere watulabwire oti, ‘Muluteekeku ensalo okulweruguulirirya lubbe luwonge.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","OMusengwa nʼamukoba ati, “Oike ansi, era waira aanu nʼAlooni. Neye abakabona nʼabantu tibali nʼokutambuka ensalo okwiza eenu e gyendi kaisi tinababonereza.” ");
INSERT INTO gwr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kale oMusa nʼaika egiri abantu nʼabakobera oMusengwa ebiyabbaire akobere. ");
INSERT INTO gwr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Awo oKibbumba nʼatumula ebibono binu byonabyona ati: ");
INSERT INTO gwr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nze ninze oMusengwa iye oKibbumbawo eyakutoire omu kyalo kyʼe Misiri e giwabbaire omu bugalama.” ");
INSERT INTO gwr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Tiwasinzanga abakibbumba abandi okutoolaku Nze.” ");
INSERT INTO gwr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Tiweekoleranga ekifaananyi ekyʼokusinza ekyʼekintu kyonakyona ekiri angulu omwibbanga ooba ansi okwitakali ooba omu maizi agali ansi wʼeitakali. ");
INSERT INTO gwr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Era tiwakotamyanga omutwe okuwa ekifaananyi ekyo ekyʼekintu kyonakyona ekitiisya ooba okukisinza. Ekyo kityo olwʼokubba Nze oMusengwa iye oKibbumbawo Ndi Kibbumba owʼeibuba. Nabonerezanga abaana olwʼebikole ebibbibibbi ebyʼababyaire baabwe abancaawa, era nabonerezanga paka bʼekiizukulu kyokusatu era paka abʼekiizukulu kyokuna. ");
INSERT INTO gwr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Neye nakwatiranga ekisa enkumi nʼenkumi egyʼabo abantaka era abakwata amateeka gange.” ");
INSERT INTO gwr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Tiwakolesyanga eriina lyange olwʼebigendererwa ebibbibibbi, olwʼokubba Nze oMusengwa iye oKibbumbawo nabonerezanga omuntu yenayena eyakolesyanga eriina lyange olwʼebigendererwa ebibbibibbi.” ");
INSERT INTO gwr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Oyebukirye okukuumanga olunaku lwʼeSaabbaato okubba lutukulye. ");
INSERT INTO gwr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Oli nʼenaku mukaaga okukolerangamu emirimogyo gyonagyona, ");
INSERT INTO gwr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","neye olunaku olwomusanvu niiyo eSaabbaato olwoli nʼokuwaayo nga lwa kumpa kitiisya Nze oMusengwa iye oKibbumbawo. Oku lunaku olwo tiwakolanga omulimo gwonagwona. Ekikoba kiti, waire niiwe, ooba omutaanewo ooba omwalawo, waire omugalamawo omusaiza ooba omukali, waire ebyayobyo, newankubbaire abanamawanga abali omu kyalokyo. ");
INSERT INTO gwr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ekyo kityo olwʼokubba omu naku omukaaga, Nze oMusengwa munabbumbiire ekyalo, nʼeigulu, nʼenyanza era nabuli kintu ekibirimu, neye oku lunaku lwomusanvu ni mpumula. Nʼolwʼensonga eyo, Nze oMusengwa nalwawiire okubba lutukulye.” ");
INSERT INTO gwr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Oiteewo nʼomaawo obawenge ekitiisya, kaisi owangaale ino omu kyalo Nze oMusengwa iye oKibbumbawo ekinkuwa.” ");
INSERT INTO gwr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Tiwaitanga omuntu.” ");
INSERT INTO gwr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Tiwayendanga.” ");
INSERT INTO gwr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Tiwaibbanga.” ");
INSERT INTO gwr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Tiwasibiriryanga oku muntu yenayena.” ");
INSERT INTO gwr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Tiweegombanga enyumba yʼomuntu, newankubbaire omukaliwe, newankubbaire omugalamawe omusaiza ooba omukali, newankubbaire onteewe, ooba ompundawe, newankubbaire ekintukye ekindi kyonakyona ekyali nakyo.” ");
INSERT INTO gwr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Atyanu abantu bonabona owebawuliire ngʼeraadu ebbwatuka, ni bawulira nʼokuvuga kwʼekondeere era ni babona okumesya kwa ikendi, nʼolusozi nga luduunya omwosi, ni batukuta olwʼokutya era ni beemerera yalaku. ");
INSERT INTO gwr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ni bakoba oMusa bati, “Iwe owewatumula na iswe, twawulisisya. Neye tutya tuti oKibbumba oweyatumula na iswe, twaba kufa.” ");
INSERT INTO gwr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Neye oMusa nʼairamu abantu ati, “Timwatya, olwʼokubba oKibbumba aizire kubagezesya kaisi mumutyenge era nga mumugondera, nga timukola ebikole ebibbibibbi.” ");
INSERT INTO gwr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Neye abantu ni basigala nga beemereire yalaku. OMusa iye nʼaigerera okumpi nʼekireri ekizizi, oKibbumba ekiyabbairemu. ");
INSERT INTO gwr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Awo oMusengwa nʼakoba oMusa ati, “Okobe aBaisirairi oti, ‘Mweboneireku, Nze oMusengwa owensinziriire omwigulu ni ntumula na inywe. ");
INSERT INTO gwr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Timwekoleranga ebifaananyi ebyʼokusinza ebyʼefeeza ooba ebyʼezaabbu okubisinza omu kifo kyʼokusinzanga ninze. ");
INSERT INTO gwr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Onnyombekere ekyoto ekyʼeitakali, era kwikyo osadaakireku entaama gyanywe nʼente gyanywe bibbe esadaaka egibooca yonayona, nʼebyayo ebindi bibbe sadaaka eyʼokusyania. Era mu buli kifo ekinabalonderanga okunsinzirangamu, naizanga egyoli, ni nkuwa enkabi. ");
INSERT INTO gwr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Owewannyombekeranga ekyoto kyʼamabbaale, tiwakyombekanga nʼamabbaale agoobaizireku, olwʼokubba ebyoma ebyokolesya okugabaiza, bigasuuca agatasaanira. ");
INSERT INTO gwr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Era tiwayombekanga ekyoto nga kuliku amadaala agatuuka e ngulu oku kyoto ekyo, demba nʼoyemukira oku madaala ngʼoniina.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Awo oMusengwa nʼakoba oMusa ati, “Atyanu ganu niigo amateeka agandi agooli nʼokuwa aBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Owewagulanga omugalama oMwebbulaniya omusaiza, yakukoleranga okumala emyanka mukaaga. Neye omu mwanka ogwomusanvu wamuseebulanga nʼalekeraawo okubba mugalamawo, era nʼayaba nga mpaawo kintu ekyasaswire okwiryawo egyamugulire. ");
INSERT INTO gwr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Omugalama oyo owaabba ngʼowewamuguliire yabbaire timufumbo, owaabba ngʼayaba, tayabanga nʼomukali. Neye owaabba ngʼowewamuguliire yabbaire mufumbo, omuseebulanga aamo nʼomukaliwe. ");
INSERT INTO gwr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Wazira omusengwawe owaabba niiye eyamuwaire omukali, era nʼabyala naye abaana abaisuka ooba abaala, omukali oyo nʼabaanabe baabbanga ba musengwawe, era omusaiza oyo omugalama bali nʼokumuseebula niiye yenkani. ");
INSERT INTO gwr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Neye singa omugalama oyo abbutula omu lwatu ati, ‘Nze ntaka omusengwa wange, nʼomukali wange, nʼabaana bange, mbaire tintaka okunseebula okuzwa omubugalama,’ ");
INSERT INTO gwr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","omusengwawe yamutwalanga e gibasinzira oKibbumba. Eeyo, yamwemereryanga nʼamwigika oku lwigi ooba oku mwango, kaisi nʼamutundulya ekitwi nʼekyoma ekisongolye. Awo yasigazanga omugalamawe oyo enaku gyonagyona. ");
INSERT INTO gwr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Singa omuntu atunda omwalawe okubba mugalama, omugalama oyo tibamuseebulanga okuzwa omu bugalama ngʼowebaseebula abagalama abasaiza. ");
INSERT INTO gwr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Atyanu singa eyagulire omwala oyo yabbaire agenderera kumufumbirwa, owaatamusiimenge, yamulekanga oiteeye nʼamununula ngʼamugula. Era omusaiza eyamugulire tiyaabbenge nʼobwezye okumugulya abanamawanga, olwʼokubba owaakola atyo abba amenyere endagaano egiyakolere ngʼamugula. ");
INSERT INTO gwr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Neye owaagula omugalama omwala okumuwa omutaanewe abbe mukaliwe, oiteeye wamwisuka yabityanga omugalama oyo ngʼowaabitya omwalawe. ");
INSERT INTO gwr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Omusaiza owaagulanga omugalama ogondi okubba mukaliwe owokubiri, ali nʼokweyongera okuwanga omugalama omukaliwe eyasookere ekigera kinanyere ekyo ekyʼebyokulya, nʼebizwalo ebyamuwanga era nʼokutuukiriryanga ensonga gyʼobufumbo nga nenca. ");
INSERT INTO gwr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Singa omusaiza oyo tiyatuukiriryenge obuvunaanyizibwabwe eeri omugalama omukaliwe oyo omu bintu ebyo ebisatu, yaseebulanga omukali oyo nʼayaba bwereere, anambula mukali oyo kuwaayo kintu kyokwenunula.” ");
INSERT INTO gwr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Awo oMusengwa ni yeeyongera okukoba oMusa ati, “Nabuli eyakubbanga omuntu nʼamwita, yena bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Wazira singa yaitanga omuntu nga tagendereire, nga Ninze oKibbumba ntakire ntyo, namuteekerangawo ekifo ekiyairukirangamu nandi ni bamukolaku akabbikabbi. ");
INSERT INTO gwr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Neye singa omuntu yaitanga omuntu omu lukuujukuuju ngʼagendereire, nʼoweyaabbanga airukiire ku kyoto kyange ngʼataka kulama, bamusyomangawo ni bamutwala ni bamwita. ");
INSERT INTO gwr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Nabuli eyakubbanga oiteeye ooba omaaye, bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Nabuli eyagotyangawo omuntu, nʼamutunda, ooba ni bamwajirirya ngʼakaali ali naye, bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Nabuli eyajooganga oiteeye ooba omaaye, yena bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Abantu ababiri owebayombanga, kaisi omoiza nʼakubba omwinaye eibbaale ooba enguumi, kaisi ogubakubbire nandi nʼafa, wazira nʼabba oku buliri nga mulwaire, ");
INSERT INTO gwr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","neye oluzwanyuma nʼasetuka era ngʼawulukaku e nza nʼomukoomero, eyamukubbire tibamubonerezanga. Wazira yamugaitanga olwʼebiseera ebyamufiirizire, era nʼamujanjabya paka owaalama. ");
INSERT INTO gwr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Omuntu oweyakwatanga omwigo, nʼakubba omugalamawe omukali ooba omusaiza, era omukubbe nʼafeerawo, omuntu oyo akubbire bamubonerezanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Neye omugalama oweyamalangawo olunaku olumo ooba eibiri ngʼakaali okufa, kaisi oluzwanyuma nʼafa, omusengwawe tibamubonerezange, olwʼokubba niiye eyaabbanga afiiriirwe omugalamawe. ");
INSERT INTO gwr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Singa abantu baabbanga balwana, kaisi omu kulwana kwabwe ni bakubbiramu omukali aali kida, era ekida ni kizwamu, neye omukali oyo nʼabba tasunire akabbikabbi akandi, amukubbire bamusasulisyanga byonabyona oibaaye wʼomukali oyo ebiyamusaliranga, era ngʼabalamuzi babikakasire. ");
INSERT INTO gwr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Neye singa omukali oyo babba bamutuuciryeku akabbikabbi akandi, olwo omuntu amutuuciryeku ekyo, yena bamuwanga ekibonerezo ekyenkana nʼekyakolere. Ekikoba kiti, owaabba aitire, yena bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Era owaabba amutoiremu liiso yena bamutoolangamu liiso, owaabba amubbongoiremu liino yena bamubbongolangamu liino. Owaabba amutemwire ku ngalo, yena bamutemulanga ku ngalo, owaabba nga ku kigere yena ku kigere. ");
INSERT INTO gwr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Era owaabba amwocerye-bwoci yena bamwocanga, era owaabba amusunisirye ibbwa yena bamusunisyanga ibbwa, owaabba amukunwire yena bamukunulanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Omuntu oweyakubbanga eriiso lyʼomugalamawe omukali ooba omusaiza ni lifaamu, yaseebulanga omugalama oyo nʼayaba nga mpaawo kintu omugalama ekyasaswire okwiryawo egyamugulire. Ekyo kyabbanga kityo lwʼomugaito gwʼeriiso lya mugalama oyo. ");
INSERT INTO gwr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Omuntu oweyakubbanga omugalamawe omusaiza ooba omukali, nʼamuzweraku okubbongokamu eriino, yaseebulanga omugalama oyo nʼayaba nga mpaawo kintu omugalama ekyasaswire okwiryawo egyamugulire. Ekyo kyabbanga kityo lwʼomugaito gwʼeriino lya mugalama oyo.” ");
INSERT INTO gwr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","OMusengwa ni yeeyongera ati, “Singa onte yabbuuŋanga omusaiza ooba omukali nʼafa, bamwitanga nga bamukubba mabbaale, era enyama ya nte oyo tibagiryanga. Neye onanyere onte oyo tibamuvunaanange omusango. ");
INSERT INTO gwr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Neye singa onte abba abbaire nenca abbuuŋanga abantu, era ngʼonanyere onte oyo bamulabwire era nandi ni bamukanyangula okuteeyongera okubbuuŋa, awo singa tete yalibbuuŋa omusaiza ooba omukali nʼafa, onte oyo bamwitanga nga bamukubba mabbaale, nʼonanyere onte oyo yena bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Neye singa onanyere onte bamwikiriryanga okusasula omugaito okununula obwomibwe, yaabbanga nʼokuwaayo byonabyona ebibamusaliire. ");
INSERT INTO gwr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Era singa onte yabbuuŋanga omwana omwisuka ooba omwala nʼafa, onanyere onte oyo bamuvunaananga mu ngeri nanyere eyo. ");
INSERT INTO gwr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Wazira singa onte oweyaabbanga abbuuŋire mugalama omusaiza ooba omukali, onanyere onte oyo yaabbanga nʼokusasula onanyere omugalama oyo onte ogwabbuuŋire esekeri egyʼefeeza 30, era onte oyo bamwitanga nga bamukubba mabbaale. ");
INSERT INTO gwr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Singa omuntu yakuulanga ekiina nandi nʼakisaanikiraku ooba singa yasaanukulanga ekiina, kaisi onte ooba ompunda nʼakigwamu nʼafa, ");
INSERT INTO gwr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","omuntu oyo yaabbanga nʼokusasula onanyere ekyayo ekyo, iye nʼatwala kidi ekifiire. ");
INSERT INTO gwr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Singa onte wa muntu yabbuuŋanga owa gondi nʼamwita, abananyere ente egyo, bombi batundanga onte odi omwomi, ni bagabulamu empiiya egizwiremu. Era nʼenyama ya nte afiire yona bagigawulirangamu aakati. ");
INSERT INTO gwr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Neye owekyamanyikananga ngʼonte abbuuŋire omwinaye, nenca abbaire nʼomuze ogwo, kaisi onanyere nga tamukanyangwire okuteeyongera okubbuuŋa, onanyere onte oyo yaabbanga nʼokumuwaayo okusasula odi afiire, iye nʼatwalamu odi omufu.” ");
INSERT INTO gwr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Awo oMusengwa ni yeeyongera okukoba oMusa ati, “Singa omuntu yaibbanga onte ooba ontaama, era nʼaita ekyayo ekyo, ooba nʼakitundamu, omu nte omoiza bamugaitisyangamu ente itaanu. Era nʼomu ntaama omoiza bamugaitisyangamu entaama ina. ");
INSERT INTO gwr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Era singa bakwatanga omwibbi obwire ngʼayazya okwingira omu nyumba, ni bamwitirawo, amwitire tibamuvunaananga omusango gwʼobwiti. ");
INSERT INTO gwr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Neye singa bamukwatanga musana ni bamwita, amwitire bamuvunaananga omusango ogwobwiti. “Omwibbi ogubakwaite yaabbanga nʼokugaita olwʼobwibbi. Neye singa abba abulaku ekintu kyonakyona ekyokuwaayo okugaita, bamutundangamu niiye onanyere nʼasuuka mugalama okugaita ebyaibbire. ");
INSERT INTO gwr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Singa yaibbanga onte, ooba mpunda, ooba ntaama, ni bamukwata nʼekyayo ekyo nga kyomi, yaabbanga nʼokugaita ebyayo bibiri mu buli kimo ekiyabbanga aibbire. ");
INSERT INTO gwr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Omuntu oweyaabbanga aliisya ebyayobye omu kigona ooba omu musiri gwʼemizabbibbu, kaisi nʼabireka ni byaba ni birya ebirime omu musiri gwʼomuntu ogondi, yaabbanga nʼokugaita ebirime ebyo ngʼatoola ebyʼomu kigona ekikye, ooba ebyʼomu musiri ogugwe ogwʼemizabbibbu. ");
INSERT INTO gwr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Omuntu oweyakwatisyanga omusyo ni gulanda omu kigona, ni gukwata omusiri gwʼomuntu ogondi, ni gwoca engaano egikaali gikula ooba egibakesere ni babbiirya, oyo akwatisirye omusyo ogwo yaabbanga nʼokugaita. ");
INSERT INTO gwr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Omuntu oweyabisisyanga omwinaye empiiya ooba ebintubye, kaisi ni babiibbira omu nyumba yʼoodi ogubabisisirye, owebakwatanga omwibbi, yagaitanga emirundi mibiri mu buli kigera kyʼebyo ebiyaabbanga aibbire. ");
INSERT INTO gwr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Neye singa baabbanga tibakwaite omwibbi, bakwatanga onanyere enyumba ogubabbaire babisisirye ebintu ni bamutwala e gibasinzira oMusengwa nʼalayira ngʼakakasa ati tali kukumpanya ebintu bya mwinaye. ");
INSERT INTO gwr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Abantu ababiri owebakayaaniranga ekintu, nga nabuli muntu akoba ati kikye, waire nte, ooba mpunda, ooba ntaama, ooba bizwalo, ooba ku kintu ekindi kyonakyona ekigotere, bombi abakikayaanira babatwalanga e gibasinzira oMusengwa. Era omuntu oyo oKibbumba oguyasingisyanga omusango, yagaitanga omwinaye ebintu ebikubbisyemu ekyakayaanira emirundi mibiri. ");
INSERT INTO gwr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Omuntu oweyatibikiranga omwinaye ompunda, ooba onte, ooba ontaama, ooba ekyayo ekindi kyonakyona, kaisi ekyayo ekyo ni kifa ooba ni kimenyeka, ooba ni bakiibba, era nga mpaawo muntu yenayena akakasa oku bintu ebyo, ");
INSERT INTO gwr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ogubatibikiire yaabanga omu kifo e gibasinzira oMusengwa nʼalayira ngʼakakasa ati, tali kukumpanya ekyayo kya mwinaye. Awo onanyere ekyayo ekyo yaikiriryanga ebyo oguyatibikiire ebyatumula, era ogubatibikiire tiyagaitenge. ");
INSERT INTO gwr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Neye singa ogubatibikiire owaabba ngʼekyayo ekyo bakiibbiire ku niiye, yagaitanga onanyerekyo. ");
INSERT INTO gwr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Neye singa okisolo wʼomu kigona yaabbanga niiye akiitire, ogubatibikiire yaleetanga ebitundu byʼekyayo okisolo ebyalekereku okukakasa ekyo. Era tiyagaitanga, olwʼokubba okisolo wʼomu kigona niiye aitire ekyayo ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Omuntu oweyeeyazikanga ekyayo kya mwinaye, kaisi ekyayo ekyo ni kisuna akabbikabbi, ooba ni kifa, ngʼonanyerekyo abulawo, eyakyeyazikire yagaitanga. ");
INSERT INTO gwr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Neye singa ekyayo ekyo kisuna obugosi ngʼonanyerekyo aliwo, eyakyeyazikire tiyagaitanga. Era owaabba nga yabbaire apangisirye-bumpangisi, empiiya egiyasaswire okupangisya ekyayo ekyo, gyamalanga.” ");
INSERT INTO gwr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Era oMusengwa ni yeeyongera okukoba oMusa ati, “Omusaiza oweyasendasendanga omwala omuguna, era atasuubizangaku omuntu okumufumbirwa, ni yeegaita naye, yakwanga omwala oyo era nʼabba mukaliwe. ");
INSERT INTO gwr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Neye oiteeye wʼomwala oweyagaaniranga nakimo omwalawe okufumbirwa omusaiza oyo, era omusaiza oyo yagaitanga ebintu ebyenkanankana nʼemaali egibakwa omwala omuguna. ");
INSERT INTO gwr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Omukali akola ebyeirogo bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Nabuli muntu eyeegaitanga nʼokisolo bamwitanga. ");
INSERT INTO gwr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Nabuli muntu eyasadaakiranga abakibbumba abandi nga tasadaakiire Ninze oMusengwa, bamujigiricanga. ");
INSERT INTO gwr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Omunamawanga atyaime mwinywe timumubityanga kubbikubbi, waire okumugadya, olwʼokubba nywena mwabbaire banamawanga omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Timugadyanga onamwandu waire omulekwa. ");
INSERT INTO gwr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Owemwabagadyanga ni baneegairira okubabbeera, tinalekenge okubabbeera. ");
INSERT INTO gwr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Era inywe ni mbasunguwalira ino, ni mbaitira omu lutalo. Nʼabakali baanywe ni basuuka banamwandu, nʼabaana baanywe ni basuuka bamulekwa. ");
INSERT INTO gwr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Owookoopanga omoiza oku bantu bange abadoobi mwinywe empiiya, tiweebityanga ooti bakoopi bʼempiiya owebeebitya, nʼomutoolaku amagoba. ");
INSERT INTO gwr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Omwinawo owaakusingiranga ekizwalokye, okimwiriryanga ngʼeisana likaali okugwa. ");
INSERT INTO gwr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ekyo kityo olwʼokubba ekizwalo ekyo niikyo ekyokwebiika kyonkani ekyali nʼakyo. Aale abba yeebiika niki? Nze nkwatira abantu ekisa, kale oweyaneegairiranga okumubbeera, namubbeeranga. ");
INSERT INTO gwr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Tiwatumulanga okubbikubbi oku Kibbumba, waire kuzumirira mukulu wʼeigwangalyo. ");
INSERT INTO gwr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Tiwagaananga okutoola ekyokuwaayo oku binenekabyo nʼoku nviinyogyo okumpa. Oli nʼokumpa omutaanewo omubere omu bataanebo. ");
INSERT INTO gwr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Era wampanga nʼebibere ebyʼentegyo, nʼebyʼentaamagyo nʼebyʼembuligyo ebigyabyalanga. Ekyayo ekyo ekibere, kyamalanga oku maaye enaku musanvu, oku lunaku olwomunaana nʼokimpa. ");
INSERT INTO gwr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Mwabbanga bantu bange abatukulye. Nʼolwekyo timwalyanga enyama yʼekyayo, okisolo owʼomu kigona ekyaitire. Wazira wagimumiranga mbwa.” ");
INSERT INTO gwr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","OMusengwa ni yeeyongera okutumula ati, “Tiwasasyanga ebibono byʼobubbeyi, era tiwateekerangawo omuntu akabega akolere ekikole ekibbikibbi ngʼowa obujulizi obwʼobubbeyi. ");
INSERT INTO gwr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Toli nʼokukolanga omukumbo nʼekibinja kyʼabantu abacaamu. Oli nʼokutumulanga amazima ngʼowa obujulizi omu kooti, waire ngʼabakira obungi basemba byʼolubba olutatumula amazima, ooba owebawa obujulizi obuliibya ensala yʼomusango eyʼamazima. ");
INSERT INTO gwr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Toli nʼokwekubbiranga ngʼolamula omusango gwʼomudoobi, oti asinge omusango olwʼokubba mudoobi. ");
INSERT INTO gwr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Owooyajiryanga onte ooba ompunda wa mulabewo ngʼatayuuka, omukanjanga egiri onyereyo. ");
INSERT INTO gwr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Owoobonanga ompunda wa muntu eyakucaawire ngʼagwire olwʼobuzito obuyeetiikire, tobitangawo-bubiti, wazira omubbeeranga nʼomusetulisyaku. ");
INSERT INTO gwr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Toli nʼokugaana okusala omusango gwʼomudoobi omu bwenkanya owaabbanga nʼomusango omu kooti. ");
INSERT INTO gwr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Tiwasaliriryanga okusingisya omuntu yenayena omusango, era tiwaitanga omuntu onambulaku omusango. Ekyo kityo olwʼokubba nabuli akola ekibbikibbi ekityo, tinalireka okumusingisya omusango. ");
INSERT INTO gwr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Tiwaikiriryanga okukuwa enguzi, olwʼokubba enguzi eyofuwalya abantu ni batayezya okubona ekituuce, era ni baliibya ebibono byʼabantu abanambulaku omusango. ");
INSERT INTO gwr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Tiwabityanga kubbikubbi omunamawanga. Inywe mumaite ekyekitegeeza okubba omunamawanga, olwʼokubba nywena mwabbaire banamawanga omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Era oMusengwa ni yeeyongera okutumula ati, “Walimanga eitakali okumala emyanka mukaaga, era nga wookungula ebibala. ");
INSERT INTO gwr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Neye omu mwanka ogwomusanvu eitakali walirekanga ni liwuumula nandi nʼolirima, kaisi abadoobi mwinywe balyenge ebikulamu. Era ebibalekerewo, ebisolo ebyʼomu kigona byabiryanga. Otyo wewakolanga nʼomusirigwo ogwʼemizabbibbu, nʼogwʼemizaituuni. ");
INSERT INTO gwr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Wakolanga emirimogyo mu naku mukaaga, neye oku lunaku olwomusanvu, wawuumulanga, kaisi entegyo nʼempundagyo giwuumule era nʼabagalamabo abebabyaliire omu kisitokyo nʼabanamawanga abakukolera bona bawuumule. ");
INSERT INTO gwr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Weegendereze okukolanga byonabyona ebinkukoba. Tosabanga abakibbumba abandi obubbeeri waire okubbutulaku amaliina gaabwe.” ");
INSERT INTO gwr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Era oMusengwa ni yeeyongera ati, “Nabuli mwanka mwakolanga emikolo misatu, okumpa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Omukolo ogusooka, mukolenge oMukolo gwʼeMigaati eGibulamu okazumbulukuca. Okumala enaku musanvu mulyenge migaati egibulamu okazumbulukuca, ngʼowenabalagiire. Mukolenge ekyo omu kiseera ekituuce omu mweri gwʼAbbibbu, olwʼokubba omweri ogwo, niigwo ogumwazwereire omu kyalo kyʼe Misiri. “Tiwaabbangawo kadi moiza aiza okunsinza nʼengalo enjereere. ");
INSERT INTO gwr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Omukolo ogwokubiri, mukolenge oMukolo gwʼaMakungula, nga muwaayo amakungula ameekeereri agʼomu misiri gyanywe. “Omukolo ogwokusatu, mukolenge oMukolo gwʼoKumala oKukungula nga mumalire okukungula omu misiri gyanywe. ");
INSERT INTO gwr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Nabuli mwanka oku mikolo egyo emisatu, abasaiza bonabona mwinywe bali nʼokwizanga okunsiza Nze oMusengwa iye oMukulu. ");
INSERT INTO gwr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Omusaaye gwʼebyayo ebimumpaire ngʼesadaaka, timugumpeerangaku emigaati egirimu okazumbulukuca. Era nʼamasavu gʼebyayo ebimumpaire ngʼesadaaka oku mukolo gwʼokuwaayo egyendi, timugasigalyangawo paka eizo waaku. ");
INSERT INTO gwr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Amakungula ameekeereri era agakira obusa agʼomu misiri gyanywe, mugaleetanga omu nyumba yange Nze oMusengwa iye oKibbumba waanywe. “Timusumbiranga enyama ya mbuli omutomuto omu mata ga maaye.” ");
INSERT INTO gwr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Era oMusengwa ni yeeyongera ati, “Njaba okutuma omalaika akwekubbemberemu, era akukuume omu nzira, akutuuce omu kifo ekinategekere. ");
INSERT INTO gwr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Omuwenge ekitiisya era omugonderenge. Tiwamujeemeranga, olwʼokubba tiyalisoniya obujeemu bwanywe, olwʼokubba Mmuwaire obwezye. ");
INSERT INTO gwr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Neye owewamugonderanga nakusani era nʼokola byonabyona ebinkulagira, Nze nalwanisyanga abalabebo era nayakanisyanga abakwakanisya. ");
INSERT INTO gwr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Omalaika wange yalikwekubbemberamu, nʼakwingirya omu kyalo kyʼaBamooli, nʼaBakiiti, nʼaBaperizi, nʼaBakanani, nʼaBakiivi era nʼaBayebbusi, era amawanga ago naligajigirica. ");
INSERT INTO gwr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tiwakotamyanga omutwe okuwa abakibbumba baabwe ekitiisya, waire okubasinza. Era tiwakoopanga empisa gyʼabantu abo, neye wajigiricanga ebifaananyi byabwe ebyʼokusinza, nʼotentena nʼamabbaale gaabwe agebakoma okusengerangaku. ");
INSERT INTO gwr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Owemwansinzanga Nze oMusengwa iye oKibbumba waanywe, nabawanga enkabi, ni musuna ebyokulya nʼamaizi, era natoolangawo endwaire mwinywe. ");
INSERT INTO gwr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Omu kyalo kyanywe tiwaabbengewo omukali azwamu ekida, ooba eyaabbanga omugumba, era Nze nabawangaalyanga inywe. ");
INSERT INTO gwr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Nateekangawo entiisya yange omumaiso e gimwaba ni ntabulatabula abantu ababalumbanga. Era nazwerangaku abalabe baanywe bonabona ni bacuuka ni babairuka. ");
INSERT INTO gwr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nalisindika ebirumba okukwekubbemberamu, ebyalibbinga aBakiivi, nʼaBakanani, nʼaBakiiti nabuli wantu awewalituukanga. ");
INSERT INTO gwr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Tinalibabbinga bonabona omu mwanka ogumo, kaisi ekyalo tikyalika, era kaisi ebisolo ebyʼomu kigona tibyakubitiriraku obungi. ");
INSERT INTO gwr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Neye abantu abo nalibabbingamu mu mpolampola, paka owemwalibyalagana, ekyalo ekyo kyonakyona ni kibba kyanywe. ");
INSERT INTO gwr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Naliteekawo ensalo gyʼekyalokyo, okuzwa oku Nyanza eNtukuliki okutuuka oku Nyanza oMeditereniani, nʼokuzwa okwidungu okutuuka oku Mwiga Ewufulaate. Nalikuwa obwezye oku batyami bʼomu kyalo ekyo, era walibabbingangawo nabuli wantu awewatuukanga. ");
INSERT INTO gwr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tiwakolanga endagaano nʼabantu abo, waire nʼabakibbumba baabwe. ");
INSERT INTO gwr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Tiwalekanga abantu abo ni babba batyami omu kyalokyo. Owewalikola otyo, balikupapalya omu mutego gwʼokusinza abakibbumba baabwe, omu ngeri eyo nʼobba okolere ekikole ekibbikibbi omumaiso gange.” ");
INSERT INTO gwr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Awo oMusengwa nʼakoba oMusa ati, “Oniine oize eenu oku lusozi egyendi, iwe nʼAlooni nʼoNadabbu, nʼAbbiku, nʼabeekubbemberi 70 abʼaBaisirairi, era munsinze nga mukaali okutuuka e gyendi. ");
INSERT INTO gwr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Neye iwe Musa wenkani, niiwe owaigerera e gyendi, kaisi ibo abandi, tibali nʼokwigerera egyendi. Era aBaisirairi abasigairewo tibaniina na iwe oku lusozi.” ");
INSERT INTO gwr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","OMusa nʼayaba, nʼakobera abantu byonabyona oMusengwa ebyakobere nʼebyalagiire. Abantu bonabona ni bairiramu aamo nga bakoba bati, “Ebyo byonabyona oMusengwa ebyatumwire twaba okubikola.” ");
INSERT INTO gwr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","OMusa nʼawandiika byonabyona oMusengwa ebyatumwire. Awo nʼasetuka eizo amakeezikeezi, nʼayombeka ekyoto ansi wʼolusozi, era nʼakoma nʼamabbaale ikumi na mabiri, nga geemererawo olwʼebika eikumi na bibiri ebya Isirairi. ");
INSERT INTO gwr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Era nʼatuma abavuvuka aBaisirairi, ni bawaayo eeri oMusengwa esadaaka egibooca yonayona era ni basadaaka nʼente ebitobba okubba esadaaka eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","OMusa nʼayawulaku ekitundu ekimo ekyʼomusaaye, nʼagusuka omu matiba, kaisi ekitundu ekindi nʼakiswankira oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Era nʼakwata ekitabo ekyʼeNdagaano ya Kibbumba, nʼakisoma ngʼabantu bawulira. Abantu ni bakoba bati, “Byonabyona oMusengwa ebyatumwire twabigonderanga era twabikolanga.” ");
INSERT INTO gwr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Awo oMusa nʼatoola omusaaye oguli omu matiba, nʼaguswankira oku bantu, kaisi nʼakoba ati, “Gunu niigwo omusaaye ogukakasa endagaano oMusengwa egyakolere na inywe omu bibono byonabyona ebyatumwire.” ");
INSERT INTO gwr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Awo oMusa, nʼAlooni, nʼoNadabbu, nʼAbbiku, nʼabeekubbemberi 70 abʼaBaisirairi ni baniina oku lusozi, ");
INSERT INTO gwr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ni babona oKibbumba wa Isirairi. Ansi wʼebigerebye wabbairewo ekintu ekiri ooti mabbaale amaalirire aga bbululu agʼebbeeyi agebeeta safiro. Amabbaale amaalirire ago gabbaire ga bbululu ooti angulu. ");
INSERT INTO gwr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Era newankubbaire ngʼabeekubbemberi bʼaBaisirairi baboine oKibbumba, tiyabakolere akabbikabbi. Kale baliire era ni banywera aamo omumaiso ga Kibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Awo oMusengwa nʼakoba oMusa tete ati, “Oniine oize eenu oku lusozi e gyendi, era ngʼoli eenu, nakuwa ebipande ebyʼamabbaale, okumpandiikire amateeka nʼebiragiro, ebyokwegesya abantu.” ");
INSERT INTO gwr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Awo oMusa nʼomubbeeriwe oYoswa ni basimbuka, era iye oMusa nʼaniina oku lusozi lwa Kibbumba. ");
INSERT INTO gwr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","OMusa yabbaire akobere abeekubbemberi bʼaBaisirairi ati, “Mutukuumire aanu, paka owetwaira e gimuli. Alooni nʼoKuuli bali aamo na inywe. Nabuli eyaabbanga nʼenkayaana, yayabanga egibali.” ");
INSERT INTO gwr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Awo oMusa oweyaniinire oku Lusozi lwa Kibbumba, ekireri ni kirubiikaku, ");
INSERT INTO gwr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","era ekitiisya kya Musengwa ni kibba oku Lusozi lwa Kibbumba olwo oSinaayi. Ekireri ni kirubiikaku okumala enaku mukaaga kaisi oku lunaku olwomusanvu, oMusengwa ngʼasinzirira omu kireri ekyo aakati nʼayeta oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ekitiisya kya Musengwa ni kifaananira aBaisirairi oku nairungu wʼolusozi, ooti musyo ogwoca ni gujigiricirya nakimo. ");
INSERT INTO gwr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Awo oMusa nʼabita omu kireri ekyo nga weyeeyongerayo okuniina oku olusozi nago. Era nʼamalayo enaku 40 omusana nʼobwire. ");
INSERT INTO gwr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Awo oMusa oweyabbaire oku Lusozi oSinaayi, oMusengwa nʼamukoba ati, ");
INSERT INTO gwr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Okobe aBaisirairi, bandeetere ekyokuwaayo kyabwe. Nabuli moiza yakumpeera ekyokuwaayokye omwoyogwe ekigusiima. ");
INSERT INTO gwr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Binu niibyo ebyokuwaayo ebibakumpeera: Ezaabbu, nʼefeeza, nʼekyoma kya bbulonzi, ");
INSERT INTO gwr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki, nʼegya lineni ensa eino nʼegyʼebyoya byʼembuli. ");
INSERT INTO gwr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Era bakuwanga nʼamadiba gʼentaama agebacuusire erangi nʼofuula omutukuliki, nʼamadiba gʼembiri, nʼembaabo gyʼomuwa omweru. ");
INSERT INTO gwr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Era nʼamafuta agʼemizaituuni, nʼebyakaloosa ebibatabula omu mafuta agebakolesya omu kwawula, nʼobubbaani obwʼakaloosa, ");
INSERT INTO gwr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","nʼamabbaale agʼebbeeyi agebeeta onika, nʼamabbaale agandi agʼebbeeyi agebatungira okwitaawo eryʼobwakabona, nʼoku kizwalo ekyʼomu kifubba, ebya kabona akira obukulu. ");
INSERT INTO gwr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Era abantu abo bannyombekere eWeema, kaisi mbenge mwibo. ");
INSERT INTO gwr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Bannyombekere eWeema eyo era bankolere ebintu byamu byonabyona, omu ngeri enanyerenyeere eginakulaga.” ");
INSERT INTO gwr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Awo oMusengwa ni yeeyongera okukoba oMusa ati, “Okole esanduuku omu mbaabo gyʼomuwa omweru, ebbe obuwanvu esentimita 110, nʼobugalami esentimita 66, nʼobuwanvu okwaba engulu esentimita 66. ");
INSERT INTO gwr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Omunda nʼoku ngulu, ogisiige ezaabbu ennongoole ensaanuuce, era ogiteekeku akagongo kʼezaabbu okugyeruguulirirya. ");
INSERT INTO gwr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ogikolere emikobyo ena egyʼezaabbu, kaisi ogikwatisye oku bigere byayo ebina, emikobyo emibiri gibbe oku lubba olumo, nʼegindi emibiri oku lubba olundi. ");
INSERT INTO gwr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Era okole emirabba emigingiro omu muwa omweru, ogisiigeku ezaabbu ensaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Emirabba emigingiro egyo ogibitye omu mikobyo, oku lubba nʼolubba lwʼeSanduuku eyʼeNdagaano, kaisi bagigingirenge niigyo. ");
INSERT INTO gwr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Emirabba emigingiro egyo giri nʼokusigala mu mikobyo gyʼesanduuku, era tibagitoolangamu. ");
INSERT INTO gwr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Awo kaisi oteeke omu Sanduuku yʼeNdagaano ebipande ebyʼamabbaale ebinakuwa, okumpandiikire amateeka. ");
INSERT INTO gwr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Okwate ezaabbu ennongoole, okolemu ekisaanikiro kyʼeSanduuku iyo entebe ya Kibbumba onanyere okusaasira. Ekisaanikiro ekyo okikole obuwanvu efuuti isatu nʼeinci mwenda, nʼobugalami efuuti ibiri nʼeinci isatu. ");
INSERT INTO gwr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Oyeese omu zaabbu ebifaananyi byʼabakeruubbi, bibbe oku lubba nʼolubba lwʼekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira. ");
INSERT INTO gwr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Ekifaananyi ekimo okiyeese oku lubba olumo, nʼekindi oku lubba olundi. Obiyeese anambula mayungiro nʼekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira. ");
INSERT INTO gwr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ebifaananyi ebyo biringirirangane, ngʼamaiso gaabyo galingiriire ansi ku kisaanikiro iyo entebe ya Kibbumba onanyere okusaasira, nʼebiyaya byabyo bibbe byanzululye engulu era nga bibiikaku ekisaanikiro ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Era ebipande ebyʼamabbaale ebinakuwa, ebimpandiikireku amateeka, wabiteeka mu sanduuku eyʼeNdagaano, kaisi nʼogisaanikaku ekisaanikiro kyayo. ");
INSERT INTO gwr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Era awo aakati wʼebifaananyi byʼabakeruubbi ebyo byombi, oku sanduuku eyʼeNdagaano niiwo eginasisinkaniranga na iwe, era ginasinziriranga, ni nkukobera amateeka gange gonagona nʼogawa aBaisirairi.” ");
INSERT INTO gwr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Era oMusengwa ni yeeyongera okukoba oMusa ati, “Okole emenza omu mbaabo gyʼomuwa omweru, obuwanvu esentimita 88, nʼobugalami esentimita 44, nʼobuwanvu okwaba engulu esentimita 66. ");
INSERT INTO gwr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ogisiigeku ezaabbu ennongoole ensaanuuce, era ogiteekeku akagongo akʼezaabbu ennongoole ensaanuuce, oku mbale mbale oku ngulu wʼemenza okugyeruguulirirya. ");
INSERT INTO gwr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Okubbeku akabaabo obugalami einci isatu okweruguulirirya emenza, nga kasiba olubaabo lwʼoku ngulu nʼebigere. Era engulu oku kabaabo ako oteekeku akagongo akʼezaabbu okweruguulirirya akabaabo nago. ");
INSERT INTO gwr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Okole emikobyo ena egyʼezaabbu, kaisi ogikwatisirye oku nsonda eina awali ebigere byayo. ");
INSERT INTO gwr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Emikobyo egyo giri nʼokubba kumpi nʼakabaabo nago. Era emikobyo egyo niigyo egyakwatiriranga emirabba emigingiro egyʼemenza eyo. ");
INSERT INTO gwr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Okole emirabba emigingiro omu mbaabo gyʼomuwa omweru, kaisi ogisiigeku ezaabbu ensaanuuce, era niigyo egibagingiranga emenza eyo. ");
INSERT INTO gwr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Era okole amasaani, nʼebikopo, nʼejaaga era nʼamabbakuli, ebyokukolesyanga nga bawaayo enviinyo. Ebintu ebyo obikole mu zaabbu ennongoole. ");
INSERT INTO gwr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Wateekanga oku menza eyo eMigaati eMiwonge ni gibbanga omumaiso gange bulijo.” ");
INSERT INTO gwr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Awo oMusengwa ni yeeyongera okukoba oMusa ati, “Oyeese ekikondo kyʼamataala omu zaabbu ennongoole. Era oyeese entyamiro nʼekikondo kyakyo, nga kuliku obukopo obujolije ooti bimuli, era nʼokujolija kwʼebituutwa nʼokwʼobukoola bwʼoku bimuli. Ebintu ebyo byonabyona biri nʼokubba byʼezaabbu enambirira anambula mayungiro. ");
INSERT INTO gwr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kyabba nʼamasaga mukaaga, nga ku buli lubba lwʼekikondo kuliku amasaga masatu. ");
INSERT INTO gwr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Nabuli limo oku masaga omukaaga, kuli nʼokubbaaku obujolije busatu obuli ooti bimuli byʼomusaale ogubeeta alumondi. Era kuli nʼokubbaaku okujolija kwʼebituutwa, nʼokwʼobukoola bwʼoku bimuli. ");
INSERT INTO gwr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Oku kikondo kyʼamataala, kuli nʼokubbaaku obujolije buna obufaanana ooti bituutwa era ooti bukoola bwʼoku bimuli. ");
INSERT INTO gwr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ansi wʼamasaga amabiri agasooka ansi oku kikondo, bajolijeewo ekituutwa ekisooka. Ekituutwa ekyokubiri kibbe ansi wa gadi amabiri agokubiri, kaisi ekituutwa ekyokusatu kibbe ansi wʼamasaga amabiri agokusatu, ago nga niigo amasaga omukaaga. ");
INSERT INTO gwr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ebituutwa ebyo era nʼamasaga nago biri nʼokubba byʼezaabbu enambirira anambula mayungiro nʼekikondo kyʼamataala ekibayeesere omu zaabbu ennongoole enambirira anambula mayungiro. ");
INSERT INTO gwr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Okole amataala musanvu, era ogateeke oku kikondo kyago, kaisi gabbe gamoleka omwibbanga eriri omumaiso gʼekikondo ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Era omu zaabbu ennongoole okolemu nʼemakansi egisala entambi, nʼamasoniya agʼokuteekaku entambi egisiiriire. ");
INSERT INTO gwr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Okolesye ekiro 35 egyʼezaabbu ennongoole okukola ekikondo kyʼamataala nʼebintu byaku byonabyona. ");
INSERT INTO gwr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Era weegendereze, obikole ngʼosengererya enkola egimbikulagiremu aanu oku lusozi.” ");
INSERT INTO gwr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Awo oMusengwa nʼakoba oMusa ati, “Okole eWeema eya Musengwa omu ntimbe ikumi egibakolere omu wuuzi egya lineni omusa eino, era egibasonere nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. Entimbe egyo osune omukugu omu byʼokusona, agisoneremu ebifaananyi byʼabakeruubbi. ");
INSERT INTO gwr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Entimbe gyonagyona giri nʼokubba nga gyenkanankana, omu buwanvu emita ikumi na ibiri, nʼomu bugalami emita ibiri. ");
INSERT INTO gwr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Entimbe eitaanu ogiyungisye gibbe olutimbe lumo, na gidi eitaanu gyona, ogiyungisye gibbe lutimbe lumo. ");
INSERT INTO gwr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Okole obukondo omu lugoye olwa bbululu, kaisi obutungire oku mugo gwa buli lutimbe olwʼoku mbale kwʼentimbe ennyungisye. ");
INSERT INTO gwr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Otungire obukondo 50 oku mugo gwʼolutimbe olwʼoku mbale ku buli ntimbe ennyungisye. Obukondo obwʼoku lubba olumo nga buteebangana nʼobwʼoku lubba olundi. ");
INSERT INTO gwr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Era okole endobo 50 omu zaabbu, okuyungisirya aamo entimbe gyombi. Omu ngeri eyo eWeema eyo yaabba ooti nkole mu lutimbe lumo olulamba.” ");
INSERT INTO gwr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","OMusengwa ni yeeyongera okukoba oMusa ati, “Okole entimbe ikumi na lumo omu lugoye olubakolere omu byoya byʼembuli, gibiike oku Weema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Entimbe egyo gyonagyona giri nʼokubba gyenkanankana nga nabuli lumo, omu buwanvu luli emita ikumi na isatu, kaisi obugalami emita ibiri. ");
INSERT INTO gwr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Entimbe eitaanu ogiyungisye gibbe olutimbe lumo oluwanvu, na gidi omukaaga gyona ogiyungisye gibbe lutimbe lumo. Olutimbe olwomukaaga olulingemu omulundi gumo oku lubba olubiika amulyango gwʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Oku mugo gwʼolutimbe olwʼoku mbale ku buli ntimbe ennyungisye, otungireku obukondo 50. ");
INSERT INTO gwr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Okole endobo 50 omu bbulonzi, kaisi obitye omu bukondo bwʼentimbe okugiyungisya aamo. Omu ngeri eyo eWeema eyo baabba ooti bagibiikire olutimbe lumo. ");
INSERT INTO gwr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ikyo ekitundu ekyasigalawo nga bamalire okulingamu olutimbe, eedi e nduguulo wʼeWeema eya Musengwa, olutimbe lwalereeja-kulereeja. ");
INSERT INTO gwr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ekitundu kyʼemita yʼolutimbe ekibitamu omu buwanvu ku buli lubba, kyalereeja oku lubba nʼolubba okubiika eWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ogikolere ebibiika ebindi bibiri. Ekimo nga kyʼamadiba gʼentaama ensaiza agebacuusire erangi nʼofuula omutukuliki, nʼekindi ekyʼoku ngulu nga kyʼamadiba gʼembiri. ");
INSERT INTO gwr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Era okole efuleemu omu mbaabo gyʼomuwa omweru egiweemererya ngʼebikondo byʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Nabuli moiza oku fuleemu egyo yaabba obuwanvu okwaba engulu emita ina, nʼobugalami esentimita 66. ");
INSERT INTO gwr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Okole efuleemu egyo nga giriku endimi ibiri ibiri, nga gyabirana nʼebiina ebyansi awebayezya okugingirya. Efuleemu gyonagyona egyʼeWeema eyo, otyo bwoli nʼokugikola. ");
INSERT INTO gwr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Okole efuleemu egyo aabiri egyʼolubba olwʼe maserengeta, ");
INSERT INTO gwr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","era nʼebyoma ebyʼefeeza 40 ebyʼokwemereryamu ebigere byʼefuleemu egyo. Ekikoba kiti, ebyoma bibiri bibiri ansi wa buli fuleemu. ");
INSERT INTO gwr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Oku lubba ludi irwo olundi olwʼe mambuka wʼeWeema eyo okole efuleemu egyo aabiri, ");
INSERT INTO gwr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","nʼebyoma ebyʼefeeza 40 ebyʼokwemereryamu ebigere byʼefuleemu egyo. Okole ebyoma bibiri bibiri ansi wa buli fuleemu egyo. ");
INSERT INTO gwr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kaisi e nduguulo wʼeWeema eyo oku lubba lwʼe bugwaisana, okole efuleemu egyo mukaaga, ");
INSERT INTO gwr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","nʼefuleemu egyo egindi ibiri egyʼomu nsonda. ");
INSERT INTO gwr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Efuleemu egyo, egyʼoku nsonda egyʼe maserengeta, nʼegyʼe mambuka, oli nʼokugiyimbya oku nsonda gyagyo okuzwa ansi paka e ngulu okumpi nʼomukobyo ogwʼezaabbu ogusooka ogusiba onaizizi. Efuleemu gyʼoku nsonda gyombi wagikola mu ngeri moiza ");
INSERT INTO gwr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kale gyonagyona aamo gyabba efuleemu munaana, nʼebyoma ebyʼefeeza ikumi na mukaaga, nga biri bibiri bibiri ansi wa buli fuleemu. ");
INSERT INTO gwr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Okole emikiiko ikumi na mitaanu omu mbaabo gyʼomuwa omweru. Emikiiko emitaanu gibbe oku fuleemu egyʼolubba olumo olwʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Nʼegindi emitaanu gibbe oku fuleemu egyʼolubba olundi, nʼemitaanu egindi gibbe oku fuleemu egyʼe nduguulo oku lubba olwʼe bugwaisana. ");
INSERT INTO gwr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Omukiiko ogwʼakati wʼefuleemu egyo oku mba eisatu egyo, gwazwera oku nsonda ni gutuuka oku nsonda. ");
INSERT INTO gwr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Efuleemu egyo ogisiigeku ezaabbu ensaanuuce, era ogikwatisiryeku emikobyo egyʼezaabbu egyʼokukwatirira emikiiko, era emikiiko gyona ogisiigeku ezaabbu ensaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Awo okomeke eWeema eyo mu ngeri eginkulagiremu aanu oku lusozi. ");
INSERT INTO gwr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Okole olutimbe omu wuuzi egya lineni omusa eino, nga lujolijemu nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. Lwabba lutungemu nʼobukugu ebifaananyi byʼabakeruubbi. ");
INSERT INTO gwr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Olutimbe olwo olukwatisye nʼendobo egyʼezaabbu oku bikondo ebina ebibakolere omu mbaabo gyʼomuwa omweru ebibasiigireku ezaabbu ensaanuuce, era ebibeemereirye omu byoma ebina ebyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Okwatisye olutimbe nʼendobo lulereeje, kaisi oteeke omunda wʼolutimbe eSanduuku eyʼeNdagaano. Olutimbe olwo lwawula eKifo eKitukulye, nʼeKifo eKitukulye eIno. ");
INSERT INTO gwr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Oteeke ekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira, oku Sanduuku eyʼeNdagaano, eri omu Kifo eKitukulye eIno. ");
INSERT INTO gwr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Era oteeke emenza e nza wʼolutimbe lwʼomunda, kaisi ekikondo ekyʼamataala okiteeke omumaiso gʼemenza, oku lubba olwʼe mambuka wʼeWeema eyo, ngʼemenza eri e maserengeta. ");
INSERT INTO gwr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Okole olutimbe olwʼomu mulyango ogwingira omu Weema eyo. Olutimbe olwo olukole omu wuuzi egya lineni omusa eino. Era omukugu omu byokusona alujolije nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Olutimbe olwo olukolere ebikondo bitaanu ebibakolere omu mbaabo gyʼomuwa omweru, era obisiigeku ezaabbu ensaanuuce. Endobo gyabyo gibbe gyʼezaabbu, era okole nʼebyoma bitaanu ebya bbulonzi ebyʼokwemereryamu ebikondo ebyo.” ");
INSERT INTO gwr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Awo oMusengwa ni yeeyongera okutumula nʼoMusa ati, “Okole ekyoto omu mbaabo gyʼomuwa omweru. Ekyoto ekyo kiri nʼokubba kyenkanankana oku mba gyonagyona eina. Obuwanvu emita ibiri nʼesentimita aabiri, nʼobugalami emita ibiri nʼesentimita aabiri, nʼobuwanvu okwaba engulu kiri nʼokubba emita moiza nʼesentimita aasatu. ");
INSERT INTO gwr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Okikolereku amaziga ena nga ku buli nsonda kuliku eiziga limo. Amaziga ago, oli nʼokugabaiza ku kyoto kunanyere okwo anambula mayungiro, era okisiigeku obbulonzi omusaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Era okole ebyokukolesya oku kyoto, ekikoba kiti, ebyokuyoolerangamu eikoke, nʼebitiiyo, nʼebibya, nʼebitiiyo ebyʼamaino, nʼobukalaayi. Ebintu ebyo byonabyona obikole mu bbulonzi. ");
INSERT INTO gwr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ekyoto ekyo okikolere akatimba nga ka bbulonzi, era oku nsonda eina egyʼakatimba osibeku nabuli nsonda omukobyo gumo gumo. ");
INSERT INTO gwr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Akatimba ako okateeke omunda wʼekyoto, kabbe nga kakoma aakati okuzwa ansi. ");
INSERT INTO gwr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Okole emirabba emigingiro omu muwa omweru, era ogisiigeku obbulonzi omusaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Emigingiro egyo ogibitye omu mikobyo oku lubba nʼolubba lwʼekyoto, kaisi bakigingirenge niigyo. ");
INSERT INTO gwr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ekyoto ekyo okikole nga kyʼembaabo, era nga kirimu ekiina ooti kyʼekibbookisi. Bali nʼokikola mu ngeri eginkulagiremu aanu oku lusozi.” ");
INSERT INTO gwr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Awo oMusengwa ni yeeyongera okutumula nʼoMusa ati, “Okole oluuga lwʼeWeema eya Musengwa, era wasitaku entimbe entunge omu wuuzi egya lineni omusa eino. Oku lubba olwʼe maserengeta, entimbe gyabba obuwanvu emita 44. ");
INSERT INTO gwr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Entimbe egyo wagikwatisirya oku bikondo aabiri ebya bbulonzi ebibeemererya omu byoma bya bbulonzi aabiri. Wakwatisya entimbe egyo nʼendobo egyʼefeeza, omu mikobyo egyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Era nʼentimbe egyʼoku lubba olwʼe mambuka gyona wagikola obuwanvu nga gyʼemita 44. Wagikwatisya nʼendobo egyʼefeeza omu mikobyo egyʼefeeza, oku bikondo ebibeemererya omu byoma bya bbulonzi aabiri. ");
INSERT INTO gwr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Oku lubba olwʼe bugwaisana, waabbaayo entimbe obuwanvu emita 22, nʼebikondo ikumi, nʼebyoma ikumi ebyʼokwemereryamu ebikondo ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Oku lubba olwʼe buzwaisana olwabbaaku omulyango, oluuga lwabba obugalami emita 22. ");
INSERT INTO gwr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Era oku lubba olumo kwabbaaku olutimbe obuwanvu emita mukaaga nʼesentimita 60 okutuuka oku mulyango. Kwabbaaku nʼebikondo bisatu, nʼebyoma bisatu ebyʼokwemereryamu ebikondo ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Kaisi oku lubba olundi okutuuka oku mulyango kwona kwabbaaku olutimbe obuwanvu emita mukaaga nʼesentimita 60, nʼebikondo bisatu, nʼebyoma byona bisatu okwemereryamu ebikondo ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Imwo omu mulyango ogwingira omu luuga lwʼeWeema eyo, wateekamu olutimbe obuwanvu emita mwenda olubatungire omu wuuzi egya lineni omusa eino. Olutimbe olwo balujolija nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. Era luli nʼokubba nga balukwatisirye oku bikondo bina ebyemererye omu byoma ebina. ");
INSERT INTO gwr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ebikondo byonabyona okweruguulirirya oluuga olwo, biri nʼokubbaaku emikobyo egyʼefeeza, nʼendobo egyʼefeeza, nʼebyoma ebya bbulonzi ebyʼokwemereryamu ebikondo ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Oluuga lwabba obuwanvu emita 44, nʼobugalami emita 22, nʼentimbe gyʼekikomera kyʼeWeema obugalami emita ibiri nʼesentimita aabiri. Entimbe wagitunga omu wuuzi egya lineni omusa eino, nʼebyoma ebyʼokwemereryamu ebikondo byabba bya bbulonzi. ");
INSERT INTO gwr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ebintu byonabyona ebyʼokukolesya omu kuweererya omu Weema eyo, nʼenkondo gyayo gyonagyona, nʼenkondo gyʼoku luuga gyonagyona, gyabba gya bbulonzi.” ");
INSERT INTO gwr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Awo oMusengwa nʼakoba oMusa ati, “Walagira aBaisirairi ni bakuleetera amafuta amakengeize agebakamwire omu muzaituuni, agʼokuteeka omu mataala, kaisi gaakenge bulijo. ");
INSERT INTO gwr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Omu Weema eyʼoKusisinkanirangamu oMusengwa, e nza wʼolutimbe olukingulya eSanduuku eyʼeNdagaano, Alooni nʼabataane bakwatisyanga amataala ni gaakiranga aawo omumaiso gange okuzwa eigulo paka kuca. Eiteeka eryo, aBaisirairi nʼabʼemirembe egyaliirawo balikwatanga.” ");
INSERT INTO gwr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Era oKibbumba nʼakoba oMusa ati, “Otume bakwetere omugandawo Alooni nʼabataane, oNadabbu nʼAbbiku, nʼEryezaali, nʼoIsamali. Niibo abennondere omu Baisirairi okumpeererya ngʼabakabona bange. ");
INSERT INTO gwr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Watungira omugandawo Alooni ebizwalo ebyobutukulye, ebimuweisya ekitiisya era ebimubonekesya kusani. ");
INSERT INTO gwr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Wakoba bonabona abali nʼobukugu, era abenaizwirye omwoyo owʼamalabuki, ni batunga ebizwalo byʼAlooni byʼokumwawula kaisi ampererye omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Binu niibyo ebizwalo ebibali nʼokutunga: Ekyʼomu kifubba, nʼeitaawo eryʼobwakabona, nʼebbeketera, nʼekitambaala kyʼoku mutwe ekyʼobwakabona, nʼomusibiro. Batungira omugandawo Alooni nʼabataanebe ebizwalo ebyobutukulye, ebibazwalanga nga bampeererya omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Abatungi abakugu bakolesya ewuuzi egyʼezaabbu nʼegya lineni omusa eino egya bbululu, nʼentukuliikiriri, nʼentukuliki.” ");
INSERT INTO gwr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","OMusengwa ni yeeyongera ati, “Abatungi batunge eitaawo omu lineni omusa eino omu bukugu nga njolije nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki era nʼewuuzi egyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Era eitaawo eryo liri nʼokubbaaku obusibiro bubiri obubita oku mabega nga bugaita ekitundu ekyʼomumaiso, nʼekyʼe nyuma. ");
INSERT INTO gwr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Omusibiro ogubatungire nʼobukugu omu wuuzi eginyere egyo egyʼeitaawo, gwabba muyungisye omumaiso okwitaawo nga kintu kimo ekiramba. ");
INSERT INTO gwr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Wasuna amabbaale mabiri agebeeta onika, nʼowandiikaku amaliina gʼabataane ba Isirairi. ");
INSERT INTO gwr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Amaliina omukaaga gaabba okwibbaale erimo, nʼagandi omukaaga ni gabba okwibbaale erindi, ngʼowebairanganaku omu kubabyala. ");
INSERT INTO gwr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Wasuna omuyeesi wʼamabbaale omukugu, nʼawandiika oku mabbaale amabiri amaliina gʼabataane ba Isirairi. Amabbaale ago nabuli limo nʼolisiba omu fuleemu egyʼewaaya gyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kaisi nʼogasibira oku busibiro obwʼeitaawo obubita oku mabega, okwebukiriryangaku abaana ba Isirairi. Omu ngeri eyo, Alooni yaabbanga nʼamaliina ago oku mabega, kaisi Nze oMusengwa bulijo ni neebukiryanga abantu bange. ");
INSERT INTO gwr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Era waluka efuleemu egyʼewaaya gyʼezaabbu, ");
INSERT INTO gwr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","nʼokamba nʼobujegere bubiri omu zaabbu ennongoole, nga buli ooti buguwa, kaisi nʼobusiba oku fuleemu egyo.” ");
INSERT INTO gwr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","OMusengwa nʼakoba oMusa ati, “Watunga ekizwalo kyʼomu kifubba, oKabona akira obukulu ekiyazwalanga oweyabbanga ataka okumanya okusalawo kwa Kibbumba. Wakitunga mu nkola moiza eyo ngʼowewatunga eitaawo eryʼobwakabona omu wuuzi egya lineni omusa eino, ekibajolijirye nʼobukugu nʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki era nʼegyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ekizwalo ekyo ekyʼomu kifubba kiri nʼokubba kyenkanankana omu buwanvu nʼomu bugalami, era nga kiringemu lumo. Kiri nʼokubba obuwanvu esentimita 22, nʼobugalami esentimita 22. ");
INSERT INTO gwr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Wakiteekaku enyiriri ina egyʼamabbaale agʼebbeeyi, olunyiriri olusooka lwabba lwʼamabbaale agebeeta osaludiyo, nʼotopazi, nʼokalubbunkulo. ");
INSERT INTO gwr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Olunyiriri olwokubiri lwabba lwʼamabbaale agebeeta emeraludo, nʼosafiro, nʼodayamondi. ");
INSERT INTO gwr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Era olunyiriri olwokusatu lwabba lwʼamabbaale agebeeta oyakinto, nʼagate, nʼametisito. ");
INSERT INTO gwr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Nʼolunyiriri olwokuna lwabba lwʼamabbaale agebeeta obberulo, nʼonika, nʼoyasipa. Bagateeka omu fuleemu egyʼewaaya gyʼezaabbu ngʼowegali macaane omu nyiriri egyo. ");
INSERT INTO gwr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Gonagona gaabba amabbaale ikumi na mabiri, ku buli limo bawandiikaku ngʼowebakola eraama, eriina limo limo. Amaliina ago gaabba gʼabataane ba Isirairi nga geemererawo oku lwʼebika eikumi na bibiri ebya Isirairi. ");
INSERT INTO gwr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ikyo ekizwalo ekyʼomu kifubba, wasibaku obujegere bubiri obwʼezaabbu ennongoole, nga bukambe ooti buguwa. ");
INSERT INTO gwr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Wakola obukobyo bubiri obwʼezaabbu, nʼobutungira oku nsonda gyombi egyʼe ngulu egyʼekizwalo ekyʼomu kifubba. ");
INSERT INTO gwr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Obujegere obubiri obwʼezaabbu, wabusibira omu bukobyo obubiri obuli oku nsonda egyʼekizwalo ekyʼomu kifubba. ");
INSERT INTO gwr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kaisi emba egindi egyʼobujegere obwo, wagisiba oku mba eibiri egyʼefuleemu egyʼewaaya egyʼezaabbu, otyo ekizwalo ekyʼomu kifubba nʼokigaita oku busibiro obwʼeitaawo obwʼomumaiso obubita oku mabega. ");
INSERT INTO gwr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Wakola obukobyo obundi bubiri omu zaabbu, nʼobutungira omunda wʼekizwalo ekyo oku nsonda gyombi e gyʼansi egiguunya okwitaawo. ");
INSERT INTO gwr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Wakola obukobyo tete obundi bubiri omu zaabbu, nʼobutungira ansi ansi wʼobusibiro obwʼeitaawo obwʼomumaiso obubita oku mabega. Era obukobyo obwo wabutungira ngulu ngulu wʼomusibiro omujolije awegwekwatira okwitaawo. ");
INSERT INTO gwr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Obukobyo obwʼoku kizwalo ekyʼomu kifubba, buli nʼokubba busibire oku bukobyo bwʼokwitaawo, nʼakasibiro ka bbululu. Omu ngeri eyo ekizwalo kyʼomu kifubba kibbe nga tikyewuuba okuzwa okwitaawo. ");
INSERT INTO gwr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Kale Alooni oweyaingiranga omu Kifo eKitukulye, yʼazwalanga ekizwalo ekyo ekyʼomu kifubba okuliku amaliina gʼebika bya Isirairi, kaisi Nze oMusengwa ni neebukiryanga bulijo abantu bange. ");
INSERT INTO gwr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Era wateeka ebintu ebibeeta Wulimu nʼebindi ebibeeta Tumimu omu kizwalo ekyʼomu kifubba, Alooni abbenge nabyo ngʼaiza omumaiso gange. Omu biseera ngʼebyo, yazwalanga ekizwalo ekyʼomu kifubba, nʼalangirira eeri aBaisirairi, Nze oMusengwa ebintaka.” ");
INSERT INTO gwr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Awo oMusengwa ni yeeyongera okutumula nʼoMusa ati, “Era wakola eganduula egibazwala kaisi bairyaku eitaawo eryʼobwakabona, nga yonayona ya bbululu. ");
INSERT INTO gwr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Eri nʼokubbaaku ekiwundu omutwe omu gubita. Ekiwundu ekyo, bali nʼokukisoneraku amatundu okukyeruguulirirya, kaisi tiyanyiirika. ");
INSERT INTO gwr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Okweruguulirirya eigemo lyʼeganduula eyo, wajolijaaku ebifaananyi ebyʼebineneka byʼomusaale ogubeeta nkomamawanga nga bitunge omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Era okujolija okwo kuli nʼokubba nga kutabuletabulemu emiyoga gyʼezaabbu, nga giiranganaku nʼebifaananyi bya nkomamawanga okweruguulirirya eigemo lyʼeganduula eyo. ");
INSERT INTO gwr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Alooni oweyabbanga azwaire ebizwalo ebyo nʼaingira omu Kifo eKitukulye okumpererya nze oMusengwa ngʼokabona wange, emiyoga gyasagalanga kaisi nandi ni bamwita. ");
INSERT INTO gwr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Wakola akapande omu zaabbu ennongoole, nʼowandiikaku ekiwandiiko ekiti, ‘MUWONGE EERI OMUSENGWA.’ ");
INSERT INTO gwr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Akapande ako wakasibaku akasibiro aka bbululu, kaisi nʼokasiba omumaiso wʼekitambaala kyʼoku mutwe ekyʼobwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Akapande ako Alooni ali nʼokukazwalanga oku mpumiye, ekyo kyalaganga kiti aikiriirye okwetiika omusango gwʼekikole ekibbikibbi kyonakyona aBaisirairi ekibakolere omu kuwonga ebirabo egyendi Nze oMusengwa. Yaabbanga nʼokukazwalanga bulijo kaisi Nze oMusengwa ni nsiimanga ebirabo ebibabbanga bawongere egyendi. ");
INSERT INTO gwr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Watungira Alooni ebbeketera omu wuuzi egya lineni omusa eino, era nʼekitambaala kyʼoku mutwe ekyʼobwakabona kyona kyabba kyʼewuuzi egya lineni omusa eino. Era watungiraku nʼekisibiro ekijolije omu bukugu. ");
INSERT INTO gwr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Watungira abataane bʼAlooni bona ebbeketera, nʼebisibiro, era nʼebitambaala byʼoku mitwe ebyʼobwakabona, okubaweesyanga ekitiisya nʼokubabonekesyanga nakusani. ");
INSERT INTO gwr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Wazwalisya Alooni omugandawo nʼabataane ebizwalo ebyo. Oluzwanyuma, wabaawula ngʼobasukaku amafuta. Wabawonga kaisi bampeereryenge omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Wabatungira omu lineni epajama okubiikaku omubiri omwere. Gyazwera omu nkende okutuuka omu bisambi. ");
INSERT INTO gwr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Alooni nʼabataane babbanga nʼokugizwala, owebaingiranga omu Weema eyʼoKunsisinkanirangamu nze oMusengwa, ooba owebaigereranga oku kyoto okuweererya omu Kifo eKitukulye, kaisi ni batabbenga omusango ogwʼokwemuka ni kibazweraku okufa. Eiteeka eryo Alooni nʼeibyairerye balikwatanga emirembe nʼemirembe.” ");
INSERT INTO gwr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Awo oMusengwa nʼakoba oMusa ati, “Binu niibyo ebyoli nʼokukola okwAlooni nʼabataane okubawonga kaisi bampeererye omu bwakabona: Wakwata onte moiza okitobba nʼentaama ensaiza ibiri egibulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Era wakwata obusye obwʼengaano obusa, obubulamu okazumbulukuca nʼobusumbamu emigaati, nʼobukeeki obubatabwiremu amafuta gʼomuzaituuni, nʼobugaati obuyeyere obubasiigireku amafuta gʼomuzaituuni. ");
INSERT INTO gwr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Wagiteeka omu kiibo kimo nʼogireetera mwikyo, era nʼoleeta nʼonte okitobba, nʼentaama eibiri ensaiza. ");
INSERT INTO gwr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Waleeta Alooni nʼabataane oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu, kaisi nʼokola omukolo ogwʼokubanaabya nʼamaizi. ");
INSERT INTO gwr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Era wazwalisya Alooni ebizwalo binu: Ebbeketera nʼeganduula egibazwala kaisi ni bairyaku eitaawo, nʼeitaawo eryʼobwakabona, nʼekyʼomu kifubba, nʼomusiba omusibiro ogwʼokwitaawo ogubakolere nʼobukugu. ");
INSERT INTO gwr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Era wamusibanga nʼekitambaala kyʼoku mutwe ekyʼobwakabona, nʼakapande aka wuwonge eeri oKibbumba oku kitambaala kyʼoku mutwe ekyʼobwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Awo wakwata amafuta agebakolesya omu kwawula nʼomusuka oku mutwe. ");
INSERT INTO gwr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Era waleeta abataane nʼobazwalisya ebbeketera, ");
INSERT INTO gwr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","nʼobasiba emisibiro omu nkende, era nʼobasiba nʼebitambaala byʼoku mitwe ebyʼobwakabona. Eyo niiyo engeri egyoyaba okwawula Alooni nʼabataane omu bwakabona. Ibo nʼeibyaire lyabwe bampeereryanga omu bwakabona emirembe gyonagyona ngʼeiteeka obweriri. ");
INSERT INTO gwr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Waleeta onte okitobba omumaiso gʼeWeema eyʼoKunsisinkanirangamu, era Alooni nʼabataane ni bamukwata oku mutwe. ");
INSERT INTO gwr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Onte oyo wamwitira omumaiso gange Nze oMusengwa, oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Watoolaku oku musaaye gwa nte oyo nʼogusiiga oku maziga gʼekyoto ngʼokolesya olunwerwo, kaisi omusaaye gwonagwona ogwabba gusigairewo wagusuka ansi wʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Awo wakwata amasavu gonagona agabiika oku byenda, nʼendimi gyʼamani, nʼempigo gyombi, nʼamasavu agagiriku, byonabyona nʼobyocerya oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Neye enyama yonayona eya nte oyo esigairewo, nʼeidiba, nʼebisisye byʼomu binamukida, wabyocerya nza wʼenkambi. Eyo niiyo esadaaka eyʼokusoniya ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Era watoola omoiza oku ntaama gidi eibiri, Alooni nʼabataane ni bamukwata oku mutwe, ");
INSERT INTO gwr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","nʼomwita, nʼotoola omusaaye, nʼoguswankira oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Wamusansagamu bitundutundu, nʼonaabya ebyenda nʼebikokolo, nʼobiteeka aamo nʼomutwe, nʼebitundu ebindi. ");
INSERT INTO gwr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Nʼoyocerya ontaama oyo omulamba oku kyoto. Eyo niiyo esadaaka egibooca yonayona okugiwaayo ngʼekyokuwaayo ekibooca ni kizwamu oluvululu olusa olunsangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Watoola ontaama owokubiri, Alooni nʼabataane ni bamukwata oku mutwe, ");
INSERT INTO gwr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","kaisi nʼomwita. Awo nʼotoolaku omusaayegwe, nʼolisiiga oku kalege kʼekitwi kyʼAlooni ekyʼoku ndiiro, nʼoku bulege bwʼamatwi gʼabataane agʼoku ndiiro, nʼoku binkumu ebyʼoku ngalo gyabwe endiiro, nʼoku byala ebinene ebyʼoku bigere byabwe. Omusaaye ogusigairewo waguswankira oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Watoolaku omusaaye ogwomansiire oku kyoto, nʼotoolaku nʼamafuta agebakolesya omu kwawula, nʼobiswankira okwAlooni nʼebizwalobye, nʼoku bataane nʼebizwalo byabwe. Awo iye nʼabataane baabba batukulye egyendi aamo nʼebizwalo byabwe. ");
INSERT INTO gwr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Atyanu olwʼokubba oyo ntaama wʼomukolo gwʼokwawula, watoolaku amasavu ga ntaama oyo, nʼomukiragwe omusava, nʼamasavu agabiika oku byenda, nʼendimi gyʼamani, nʼempigo gyombi nʼamasavu agagiriku, nʼekisambi ekyʼoku ndiiro, ");
INSERT INTO gwr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","era watoolaku nʼemigaati egibulamu okazumbuluca, e giri omu kiibo, egibateekere omumaiso gange Nze oMusengwa, nʼotoolaku nʼomugaati gumo, nʼakagaati kamo akatabulemu amafuta, nʼakagaati kamo akayeyere akebasiigireku amafuta, kaisi ");
INSERT INTO gwr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","byonabyona ebyo nʼobikwatisya Alooni nʼabataane, ni babiwaayo egyendi okubba esadaaka eyʼenjabulo egibasiirya ni baica ngʼesadaaka eyʼenjawulo omumaiso gange Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Olwo esadaaka eyo wagibatoolaku, nʼogyocerya oku kyoto, aamo nʼesadaaka egibooca yonayona, ibyo ebyʼokuwaayo ebibooca ni bizwamu oluvululu olusa olunsangalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Watoola obbanda wa ntaama odi owokubiri owʼomukolo ogwʼokwawula Alooni, nʼomusiirya omumaiso gange ngʼesadaaka eyʼenjawulo egibasiirya ni baica, era obbanda oyo yaabba mugabogwo. ");
INSERT INTO gwr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Era owonge obbanda nʼekisambi ebya ntaama owʼomukolo ogwʼokwawula Alooni nʼabataane. Ekikoba kiti, ebibawaireyo egyendi nga babisiirya ni baica okubba esadaaka eyʼenjawulo. ");
INSERT INTO gwr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ABaisirairi owebaawangayo esadaaka gyabwe egyʼokusyania, obbanda nʼekisambi ebyʼekyayo ekyo, byabbanga byʼAlooni nʼabʼolulyolwe enaku gyonagyona. Obbanda nʼekisambi ebyo, aBaisirairi babbanga bawaire Ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Ebizwalo ebyʼAlooni ebyobutukulye, byabbanga byʼomuntu owʼomwibyairerye eyamusikiranga. Ebizwalo ebyo niibyo omuntu oyo ebiyazwalanga kaisi ni bamwawula nga bamusukaku amafuta. ");
INSERT INTO gwr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Omuntu owʼomwibyairerye eyamusikiranga okubba okabona, yazwalanga ebizwalo ebyo okumala enaku musanvu ngʼali omu Weema eyʼoKunsisinkanirangamu ngʼaweererya omu Kifo eKitukulye. ");
INSERT INTO gwr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Wakwata enyama edi eya ntaama owʼomukolo ogwʼokwawula Alooni nʼabataane, nʼogisumbira omu kifo ekiwonge. ");
INSERT INTO gwr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Alooni nʼabataane, bali nʼokuliira enyama eyo nʼemigaati e giri omu kiibo, ku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Baabba nʼokulya ebintu ebyo olwʼokubasoniya ebibbibibbi oku mukolo gwʼokubasuuca okubba balongoole nʼokubaawula. ABakabona bonkani niibo ababiryaku, olwʼokubba bitukulye eeri Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Era oku nyama eyo, ooba oku migaati egyo, owebyabbanga bisigaireku paka eizo waaku, waabbanga nʼokubyoca ni bisiirira. Tibali nʼokubirya, olwʼokubba biwonge eeri Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Eyo niiyo engeri egiwaawula Alooni nʼabataane omu kuweererya kwabwe ngʼowenkulagiire. Omukolo ogwo ogwʼokubaawula, wagukola okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Nabuli lunaku waabbanga nʼokuwaayo onte okitobba okubba esadaaka eyʼokusoniya ekibbikibbi kyabwe nʼokukola omukolo ogwʼokusuuca ekyoto okubba kirongoole. Ekyoto ekyo waabbanga nʼokukisukaku amafuta okukiwonga. ");
INSERT INTO gwr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Wakolanga otyo nabuli lunaku okumala enaku musanvu, okuwonga ekyoto, olwo ekyoto ni kibba kitukulye ino. Era nabuli ekyakiguunyangaku kyakisuucanga kitukulye.” ");
INSERT INTO gwr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Awo oMusengwa nʼakoba oMusa ati, “Kale waabbanga nʼokuwaayo oku kyoto, entaama entonto ibiri egyʼomwanka ogumo nabuli lunaku okutagonerya. ");
INSERT INTO gwr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Era omoiza oku ntaama egyo wamusadaakanga makeezi, nʼogondi igulo. ");
INSERT INTO gwr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Aamo nʼontaama omutomuto omoiza asooka, waawangayo ekiro ooti moiza eyʼobusye obwʼengaano obusa, obubatabwiremu erita moiza eyʼamafuta agʼemizaituuni amakengeize. Era waawangayo nʼerita moiza eyʼenviinyo ngʼekyokunywa ekibawaayo. ");
INSERT INTO gwr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ontaama owokubiri wamusadaakanga igulo, nʼekyokuwaayo ekyʼempeke, nʼekyokuwaayo ekyʼekyokunywa kyaku ngʼowewaabbanga okolere amakeezi. Ebyo byabbanga byokuwaayo ebibooca ni bikola oluvululu, ikyo ekyokulya ekibawaayo eeri Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Omu mirembe egyaliirawo, esadaaka iyo egibooca yonayona, bagiwangayo bulijo omumaiso gange, oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. Aawo niiwo e ginabasisinkaniranga okutumula na inywe. ");
INSERT INTO gwr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Aawo ginasisinkaniranga aBaisirairi, era ekitiisya kyange kyazwerangaku ekifo ekyo okubba kitukulye. ");
INSERT INTO gwr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Kale nalitukulya eWeema eyʼoKunsisinkanirangamu ni ntukulya nʼekyoto. Era ni ntukulya Alooni nʼabataane okumpeereryanga omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Naabbanga omu Baisirairi, era naabbanga Kibbumba waabwe. ");
INSERT INTO gwr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Era balimanya nga Ninze oMusengwa iye oKibbumba waabwe eyabatoire omu kyalo kyʼe Misiri, kaisi mbenge mwibo. Era Ninze oMusengwa iye oKibbumba waabwe.” ");
INSERT INTO gwr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Awo oMusengwa ni yeeyongera okukoba oMusa ati, “Wakola ekyoto ekyʼokuduunyiryangaku obubbaani. Wakikola mu muwa omweru. ");
INSERT INTO gwr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ekyoto ekyo kiri nʼokubba nga kyenkanankana emba gyonagyona. Obuwanvu esentimita 45, nʼobugalami esentimita 45, kaisi obuwanvu okwaba engulu esentimita 90. Amaziga gaakyo oli nʼokubaiza ku kisaale kinanyere ekyo ekyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Wasiiga ezaabbu ennongoole ensaanuuce oku ngulu, nʼoku mba gyakyo eina, nʼoku maziga gaakyo, wakiteekaku akagongo akʼezaabbu okweruguulirirya emba gyakyo eina. ");
INSERT INTO gwr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Wakola emikobyo mibiri egyʼezaabbu, nʼogikwatisirya ansi wʼakagongo, oku mba gyakyo eibiri egiteebangaine, era gyakwatiriranga emirabba emigingiro gyʼekyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Wakola emirabba emigingiro omu muwa omweru, era nʼogisiigaku ezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Wateeka ekyoto ekyo, e nza wʼolutimbe olukingulya eSanduuku eyʼeNdagaano okuli ekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira. Awo oku ntebe yʼokusaasira niiwo e ginasisinkaniranga na iwe. ");
INSERT INTO gwr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Nabuli makeezi Alooni oweyaizanga okulongoola amataala, yaabbanga nʼokuduunyirya oku kyoto ekyo obubbaani obwʼakaloosa. ");
INSERT INTO gwr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Era yaabbanga nʼokubuduunyirya, oweyaabbanga akwatisya amataala eigulo. Obubbaani obwo baabbanga nʼokubuduunyirya bulijo nʼomu mirembe egyaliirawo omumaiso gange Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Oku kyoto ekyo, timuduunyiryangaku obubbaani obubataikirirya, ooba okuweeraku esadaaka egibooca yonayona, waire okuweeraku ekyokuwaayo ekyʼempeke kyonakyona, era timukisukangaku ekyokunywa ekibawaayo. ");
INSERT INTO gwr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Era Alooni yakolanga omukolo gwʼokusuuca ekyoto ekyo okubba kirongoole nabuli mwanka omulundi gumo. Yakikolanga ngʼasiiga oku maziga gaakyo omusaaye gwʼekyayo ekibaitanga okubba esadaaka eyʼokusoniya ekibbikibbi. Ekyo bakikolanga nabuli mwanka nʼomu mirembe egyaliirawo. Ekyo ekyoto ekitukulye eino, kyange Nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Awo oMusengwa tete nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Owewabalanga aBaisirairi okumanya obungi bwabwe, nabuli muntu yaabbangaku nʼekyansasula Nze oMusengwa, okununula obwomibwe, kaisi okawumpuli tiyabaita ngʼoli kubabala. ");
INSERT INTO gwr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Nabuli muntu ogubabalanga, yaawangayo eeri Nze oMusengwa ekitundu kyʼesekeri, esekeri emoiza yenkanankana obuzito obwʼegera aabiri okusinzirira oku kipimo kyayo ekyʼomu Weema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Nabuli muntu ogubabalanga nʼabba ayerya emyanka aabiri ooba okukirawo, yaabbanga nʼokutoola ekyokuwaayo eeri Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Omusuni tiyatoolanga ekikirawo ekitundu kyʼesekeri, nʼomudoobi tiyatoolanga ekitono oku kitundu kyʼesekeri, nga mutoola ekyokuwaayo ekyo eeri Nze oMusengwa okununula obwomi bwanywe. ");
INSERT INTO gwr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Wakumbaanianga empiiya egyo, aBaisirairi egibaabbanga bawaireyo okununula obwomi bwabwe, nʼogikolesya emirimo egyʼomu Weema eyʼoKunsisinkanirangamu. Empiiya egyo, kyabbanga kyokwebukiriryaku eeri aBaisirairi omumaiso gange Nze oMusengwa bati, bagitoire gyʼomukolo gwʼokusuuca bwomi bwabwe kubba bulongoole.” ");
INSERT INTO gwr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Era oMusengwa tete nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Wakola ekalaayi nʼekikondo okwetyama nga bya bbulonzi. Wagiteeka aakati wʼekyoto nʼeWeema eyʼoKunsisinkanirangamu, era nʼogisukamu amaizi. ");
INSERT INTO gwr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Alooni nʼabataane, bali nʼokunaabanga engalo gyabwe nʼebigere byabwe nga bakolesya maizi ago. ");
INSERT INTO gwr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Owebaabbanga baaba okwingira omu Weema eyʼoKunsisinkanirangamu, ooba nga baaba okwigerera oku kyoto okuwaayo eeri Nze oMusengwa ekyʼokuwaayo ekibooca, banaabanga amaizi ago, kaisi nandi ni bafa. ");
INSERT INTO gwr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bali nʼokunaabanga engalo gyabwe nʼebigere byabwe, kaisi nandi ni bafa. Ekyo kyabbanga kiragiro, ibo nʼabaizukulu baabwe ekibakuumanga emirembe gyonagyona.” ");
INSERT INTO gwr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","OMusengwa era nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Wakwata ebyakaloosa ebikira obusa binu: Ekiro mukaaga egyʼamafuta agebeeta miira, nʼekiro isatu egya busye obwʼomusaale ogubeeta kinamooni, nʼekiro isatu egya kaani, ");
INSERT INTO gwr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","nʼekiro mukaaga egyʼebinakabbubbuku ebya kaisiya, omu bipimo ebitongole ebibakolesya omu Weema eya Musengwa. Era wakwata nʼerita ina egyʼamafuta agʼemizaituuni. ");
INSERT INTO gwr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Awo kaisi ebintu ebyo wabikolamu amafuta amawonge agebakolesya omu kwawula, ngʼomukugu atabula ebyakaloosa owaakola. ");
INSERT INTO gwr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Wagasuka oku Weema eyʼoKunsisinkanirangamu nʼoku Sanduuku eyʼeNdagaano, ");
INSERT INTO gwr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","nʼoku menza, nʼoku bintu byaku byonabyona, nʼoku kikondo kyʼamataala, nʼoku bintu byaku, nʼoku kyoto kyʼobubbaani, ");
INSERT INTO gwr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","nʼoku kyoto ekyʼesadaaka egibooca yonayona, nʼoku bintu byaku byonabyona, nʼoku kalaayi nʼekikondo okwetyama. ");
INSERT INTO gwr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ebintu ebyo wabiwonganga ni bibba bituukulye ino, nabuli ekyabyeguunyangaku, kyabbanga kitukulye. ");
INSERT INTO gwr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Era wasuka amafuta okwAlooni nʼabataane nʼobaawula okumpeereryanga omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Wakoba aBaisirairi oti, ‘Amafuta amawonge ago, bali nʼokugakolesyanga omu mirembe gyonagyona egyairangawo. ");
INSERT INTO gwr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tibagasukanga oku bantu ba bulijo, era timuli nʼokukolanga amafuta agandi gonagona omu ngeri yaago agʼobutukulye. Igo gʼobutukulye, era gaabbanga gʼobutukulye eeri inywe. ");
INSERT INTO gwr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nabuli eyakolanga amafuta agandi gonagona agali ooti niigo, ooba nabuli eyasukanga amafuta ago agʼobutukulye oku muntu ogondi yenayena atali kabona, tibamubalenge okubba moiza oku bantu bange.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Awo era oMusengwa nʼakoba oMusa ati, “Wakwata ebyakaloosa akasa ebibeeta ositakite, nʼonika, nʼogalibbanamu, aamo nʼobubbaani obulongoole, byonabyona nga byʼebipimo ebyenkanankana, ");
INSERT INTO gwr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","nʼobikolamu ekyokuduunyirya ekyakaloosa ngʼomukugu atabula ebyakaloosa owaakola. Biri nʼokubbaamu omuunyu gwenza, nga bikuŋunte era nga byʼobutuukirirye. ");
INSERT INTO gwr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Watoolaku ekyokuduunyirya ekyo nʼokisya kusani, kaisi nʼokwata obusye obwo nʼobuteeka omumaiso wʼeSanduuku eyʼeNdagaano eri omu Weema eyʼoKunsisinkanirangamu, e ginakusisinkanira. Ekyokuduunyirya ekyo, kyabbanga kyʼobutukulye ino eeri inywe. ");
INSERT INTO gwr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Era timwekoleranga ekyokuduunyirya ekindi kyonakyona ekibakolere omu ngeri yʼekyo nago ekyobutukulye. Ikyo mukibalenge okubba kyobutukulye eeri Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nabuli eyeekoleranga ekyokuduunyirya ekindi kyonakyona omu ngeri yʼekyo nago ekyobutukulye iye onyere okukikolesya ngʼekyʼakaloosa, tibamubalenge okubba moiza oku bantu bange.” ");
INSERT INTO gwr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Aale obone, Nnondere oBbezaleeri, omutaane wa Wuuli, era omwizukulu wa Kuuli owʼekika kya Yuda. ");
INSERT INTO gwr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Era mmwizwirye omwoyo wange. Mmuwaire obukugu, nʼobusoboli, nʼamalabuki okukolanga ebyemikono ebya buli ngeri. ");
INSERT INTO gwr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Mmuwaire obukugu omu byʼokutetenkanya okukolanga ebintu omu zaabbu, nʼomu feeza, nʼomu bbulonzi. ");
INSERT INTO gwr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Era nʼokuyeesa amabbaale agʼebbeeyi nʼokugasibira omu fuleemu, nʼokukulungula ebisaale, nʼokukola ebyemikono byonabyona ebya buli ngeri. ");
INSERT INTO gwr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ate era nnondere Okolyabbu, omutaane wʼAkisamaaki owʼekika kya Daani, okubbeera oBbezaleeri. Era mpaire nʼabafundi abandi bonabona obukugu obwenjawulo, kaisi babbe nga bayezya okukola byonabyona ebinkulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Omu bintu ebyo mulimu eWeema eyʼoKunsisinkanirangamu, nʼeSanduuku eyʼeNdagaano, nʼekisaanikiro kyaku iyo entebe ya Kibbumba onanyere okusaasira, nʼebintu byonabyona ebyʼomu Weema nago. ");
INSERT INTO gwr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Ebintu nago ebyʼomu Weema eyo nga niimwo omuli emenza nʼebintu byaku, ekikondo kyʼamataala ekyʼezaabbu ennongoole nʼebintu byaku byonabyona, nʼekyoto kyʼobubbaani. ");
INSERT INTO gwr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Era nʼekyoto ekyʼesadaaka egibooca yonayona, era nʼebintu ebyʼoku kyoto byonabyona, nʼekalaayi nʼekikondo okwetyama, ");
INSERT INTO gwr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","era nʼebizwalo ebyʼobwakabona ebibasonere kusani, Alooni nʼabataane ebibazwalanga nga baweererya omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Era nʼamafuta agebakolesya omu kwawula, nʼobubbaani obwʼakaloosa ebyʼomu Kifo eKitukulye, byonabyona ebyo babikola ngʼowenkulagiire.” ");
INSERT INTO gwr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Awo oMusengwa tete nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Wakoba aBaisirairi oti, ‘Muli nʼokukuumanga eSaabbaato, nʼebba lunaku olwʼokuwuumula. Ekyo kityo olwʼokubba niiyo akamanyiciryo aakati wange na inywe omu mirembe gyonagyona egyairangawo, kaisi mumanyice muti Ninze oMusengwa abasuuca okubba abatukulye. ");
INSERT INTO gwr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Muli nʼokukuumanga eSaabbaato, olwʼokubba irwo lunaku lwanywe olutukulye. Nabuli atalukuumenge, nʼalukoleraku emirimo, bamwitanga-bwiti. ");
INSERT INTO gwr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Enaku mukaaga niigyo egimuli nʼokukolerangaku emirimo. Neye olunaku olwomusanvu, lunaku lwa kuwuumula, lwawule, lwange Nze oMusengwa. Nabuli eyakolanga omulimo gwonagwona oku lunaku lwʼeSaabbaato, bamwitanga-bwiti. ");
INSERT INTO gwr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ABaisirairi bali nʼokukuumanga olunaku lwʼeSaabbaato nga balukulya emirembe gyonagyona. Ekyo kyabeebukiryanga endagaano etekoma eginkolere na inywe. ");
INSERT INTO gwr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Niiko akaabbanga akamanyiciryo kʼendagaano etekoma aakati wange nʼaBaisirairi. Ekyo kityo olwʼokubba Ninze oMusengwa eyabbumbire eigulu nʼekyalo omu naku mukaaga, kaisi oku lunaku olwomusanvu ni ntakola era ni mpuumula.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","OMusengwa oweyamalire okutumula nʼoMusa oku Lusozi oSinaayi, nʼawa oMusa ebipande ebibiri ebyʼamabbaale, oMusengwa onanyere ebiyabbaire awandiikireku ebiragiro. ");
INSERT INTO gwr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Awo abantu owebaboine ngʼoMusa alwirewo okwira okuzwa oku lusozi, ni bakumbaanira e giri Alooni, ni bamukoba bati, “Titumaite ekyatuukire oku musaiza onu oMusa eyatutoire omu kyalo kyʼe Misiri. Kale otukolere ebifaananyi ebyʼokusinza ebyʼabakibbumba abatwekubbemberangamu.” ");
INSERT INTO gwr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Awo Alooni nʼabakoba ati, “Mutooleku empeta egyʼezaabbu egiri oku matwi ga bakali baanywe, nʼagʼabaana baanywe abaisuka nʼabaala, mugindeetere.” ");
INSERT INTO gwr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kale abantu bonabona ni batoolaku empeta gyabwe egyʼezaabbu egyabbaire oku matwi gaabwe, ni bagireetera Alooni. ");
INSERT INTO gwr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Era nʼagikwata, nʼagisaanuuca, kaisi nʼabbumbamu ekifaananyi kya nyana. Awo abantu ni bakoba bati, “Isirairi, binu niibyo ebifaananyi ebyʼokusinza ebyʼabakibbumba ababatoire omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Alooni oweyaboine bityo, nʼayombeka ekyoto omumaiso gʼekifaananyi nago, era nʼalangirira ati, “Eizo waabbaawo omukolo gwʼokuwa oMusengwa ekitiisya.” ");
INSERT INTO gwr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Era eizo waaku amakeezikeezi ni basetuka, ni bawaayo ebyayo okubba esadaaka egibooca yonayona, era nʼebyayo ebindi okubba esadaaka eyʼokusyania. Oluzwanyuma abantu ni batyama ni balya era ni banywa, kaisi ni basetuka okubina amabina gʼobwemu. ");
INSERT INTO gwr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Awo oMusengwa nʼakoba oMusa ati, “Oserengete okange, olwʼokubba abantubo abewatoire omu kyalo kyʼe Misiri, boonoonekere. ");
INSERT INTO gwr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Bazwire mangu omu nzira eginabalagiire okutambulirangamu. Beekoleire ekifaananyi ekyʼokusinza, ekya nyana omu zaabbu, ni bakisinza era ni bakiwa esadaaka, ni bakoba bati, ‘Isirairi, banu niibo abakibbumba abatutoire omu kyalo kyʼe Misiri.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Awo oMusengwa nʼakoba oMusa ati, “Abantu abo mbaboine nga bajeemu. ");
INSERT INTO gwr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kale atyanu ondeke mbamalireku obusungu bwange, era mbajigirice. Iwe nʼeibyaireryo, nalibasuuca igwanga erinene.” ");
INSERT INTO gwr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Neye oMusa ni yeegairira oMusengwa iye oKibbumbawe, ngʼakoba ati, “Oo, Musengwa, lwaki omalira obusungubwo oku bantubo abewatoire omu kyalo kyʼe Misiri ngʼokolesya amaani amabitiriri nʼobwezye obwʼamaani? ");
INSERT INTO gwr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Lwaki otaka okukola ekintu ekyazweraku aBamisiri okukoba bati, ‘Yabatoire omu kyalo kyʼe Misiri, ngʼagenderera kubaitira mu nsozi, na kubasaanyirawo nakimo ku kyalo?’ Oleke obusungubwo obubitiriri. Oirye omwoyo, tiwatuuca akabbikabbi ako oku bantubo. ");
INSERT INTO gwr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Oyebukirye abaweereryabo, oIbbulaimu, nʼoIsaka, nʼoYaakobbo, iwe onanyere abewalayiriire oti, ‘Nalibawa abaizukulu bangi ngʼenkota obwegibba angulu, nʼekyalo kinu kyonakyona ekimbasuubiza inywe, nalikiwa abaizukulu baanywe, ni kibba muwuluko gwabwe emirembe gyonagyona!’ ” ");
INSERT INTO gwr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Awo oMusengwa nʼairya omwoyo, nʼatatuuca oku bantube akabbikabbi, akeyabbaire akobere okubatuucaaku. ");
INSERT INTO gwr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","OMusa nʼazwayo, nʼaika ansi okuzwa oku lusozi, ngʼakwaite ebipande byʼamabbaale ebibiri, ebibawandiikireku ebiragiro oku mba gyombi. ");
INSERT INTO gwr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","OKibbumba onyere niiye eyakolere ebipande ebyo, era oKibbumba onanyere niiye eyawandiikire oku bipande ebyo ngʼowebakola eraama. ");
INSERT INTO gwr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","OYoswa oweyawuliire abantu nga bakubba olukero, nʼakoba oMusa ati, “Mpulira abantu omu nkambi nga baceera ooti-so balwana.” ");
INSERT INTO gwr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Neye oMusa nʼamwiramu ati, “Olwo tirukero lwʼobuwanguli, era tirukero lwʼokukuukulya kwʼabantu abebawangwire; irwo lukero lwʼokujaagaana niirwo olumpulira.” ");
INSERT INTO gwr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","OMusa oweyaigereire oku nkambi, nʼabona ekifaananyi kya nyana nʼabantu ababina, nʼasunguwala ino, nʼadyaka ebipande byʼamabbaale ebiyabbaire agingire, ni byatyagukira ansi wʼolusozi. ");
INSERT INTO gwr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Nʼakwata ekifaananyi kya nyana ekibabbaire babbumbire, nʼakisaanuuca nʼomusyo. Awo kaisi nʼasya ezaabbu eyo nʼagisoica ooti busye, nʼagimwaga oku maizi, era nʼayazya aBaisirairi okuginywa. ");
INSERT INTO gwr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Awo oMusa nʼakoba Alooni ati, “Abantu banu bakukolere niki, kaisi nʼobaleetera okukola ekikole ekibbikibbi ekyenkana awo obunene?” ");
INSERT INTO gwr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Alooni nʼairamu ati, “Sengwa tonsunguwalira, omaite ngʼabantu banu bulijo baseega kukola bikole ebibbibibbi. ");
INSERT INTO gwr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bankobere bati, ‘Otukolere ebifaananyi ebyʼokusinza ebyʼabakibbumba abatwekubbemberangamu, olwʼokubba titumaite ekyatuukire oku musaiza onu oMusa eyatutoire omu kyalo kyʼe Misiri.’ ");
INSERT INTO gwr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kale nze ni mbakoba nti, ‘Nabuli ali nʼempeta eyʼezaabbu agireete.’ Era ni bagimpa, ni ngiteeka omu musyo, ni muzwamu ekifaananyi kya nyana kinu.” ");
INSERT INTO gwr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Awo oMusa oweyaboine ngʼAlooni aleeteire abantu okujeema, nʼabalabe baabwe okubasekerera, ");
INSERT INTO gwr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","nʼayemerera omu mulyango gwʼenkambi, nʼakoba ati, “Nabuli ali oku lubba lwa Musengwa aize aanu e gyendi.” Era aBaleevi bonabona ni bakumbaanira e gyali. ");
INSERT INTO gwr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Awo nʼabakoba ati, “OMusengwa iye oKibbumba wa Isirairi akoba ati, ‘Nabuli moiza kwinywe akwate empiimaye, ayabe ngʼabitabita omu nkambi, okuzwa kunu paka kudi, nga aita nabuli moiza, ooba mugandawe, ooba mukaagwawe, ooba muliranwawe.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ABaleevi ni bakola ngʼoMusa oweyabalagiire, era oku lunaku olwo ni baita abantu ooti 3,000. ");
INSERT INTO gwr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","OMusa nʼakoba aBaleevi ati, “Olwatyanu babaawiire okuweererya oMusengwa. Ekyo kityo olwʼokubba mwitire abaana baanywe nʼabaganda baanywe, era oMusengwa abawaire inywe enkabigye.” ");
INSERT INTO gwr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Awo oku lunaku olwairireku oMusa nʼakoba abantu ati, “Mukolere ekikole ekibbikibbi ekinene ino! Atyanu oleke nkange oku lusozi eeri oMusengwa, namwegairire amo nʼabasoniya ekikole ekibbikibbi ekyo.” ");
INSERT INTO gwr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kale oMusa nʼakanga eeri oMusengwa, nʼakoba ati, “Nsaaliirwe nti abantu banu bakolere ekikole ekibbikibbi kinene ino ni beekolera ebifaananyi ebyo ebyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Neye nkwegairira, obasoniye ekikole ekibbikibbi ekibakolere. Neye singa tiwabasoniye, onsangule omu kitabokyo.” ");
INSERT INTO gwr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Iye oMusengwa nʼakoba oMusa ati, “Nabuli akolere ekikole ekibbikibbi omumaiso gange, gunasangula omu kitabo kyange. ");
INSERT INTO gwr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Aale atyanu oyabe, otwale abantu omu kifo ekinakukobeireku, era omalaika wange yakwekubbemberanga. Neye era ekiseera kyatuuka ni mbonereza abantu abo olwʼekikole ekibbikibbi ekibakolere.” ");
INSERT INTO gwr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Era oMusengwa nʼabonereza abantu, olwʼokubba basinzire ekifaananyi kya nyana, Alooni ekiyabbumbire. ");
INSERT INTO gwr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Awo oMusengwa nʼakoba oMusa ati, “Iwe nʼabantu abewatoire e Misiri, muzwe omu kifo kinu, mwabe omu kyalo ekinalayiriire oIbbulaimu, nʼoIsaka, nʼoYaakobbo, nga mbakoba nti, ‘Nalikiwa abaizukulu baanywe.’ ");
INSERT INTO gwr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nalituma omalaika wange okubeekubbemberamu inywe, era omu kyalo ekinalibawa nalikibbingamu aBakanani, nʼaBamooli, nʼaBakiiti, nʼaBaperizi, nʼaBakiivi, nʼaBayebbusi. ");
INSERT INTO gwr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mwabe omu kyalo ekiizwire amata nʼomujenene. Neye nze tinaabirane na inywe, demba ni mbajigiricirya omu nzira, olwʼokubba muli bajeemu.” ");
INSERT INTO gwr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Abantu owebawuliire ebibono ebyo ebinakuwalya ni batandiika okukunga, era nandi ni wabbaawo kadi moiza azwala nʼebyʼamajolobero. ");
INSERT INTO gwr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ekyo kityo olwʼokubba oMusengwa yabbaire akobere oMusa ati, “Okobe aBaisirairi oti, ‘Muli bajeemu. Singa mbaire wʼokwabirana na inywe waire akaseera akatono, nandibajigiricirye. Kale atyanu mweyambulyeku ebyʼamajolobero, kaisi mbone ekinabakolera.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kale okuzwa ngʼaBaisirairi owebazwereire oku Lusozi oKolebbu, tibairiremu okuzwala ebyʼamajolobero. ");
INSERT INTO gwr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Atyanu nabuli aBaisirairi egibatuukanga ni bateekawo enkambi, oMusa yakwatanga eweema nʼayaba nʼagikomeka yalaku e nza wʼenkambi, era nʼagyeta ati, “weema yʼokusisinkanirangamu oMusengwa.” Era nabuli muntu eyatakanga okwebuulyaku eeri oMusengwa, yayabanga omu weema eyo, e nza wʼenkambi. ");
INSERT INTO gwr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Era oMusa nabuli oweyaabbanga awuluka omu nkambi okwaba omu weema nago, abantu bonabona basetukanga, ni beemerera oku miryango gyʼeweema gyabwe, ni balingirira oMusa paka oweyamalanga okwingira omu weema nago. ");
INSERT INTO gwr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","OMusa oweyaingiranga omu weema eyo, ekireri ekiterembereri ooti kikondo kyaikanga, ni kyekomeka oku mulyango gwʼeweema eyo ngʼoMusengwa atumula naye. ");
INSERT INTO gwr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ABaisirairi owebabonanga ekireri ekyo nga kyekomekere oku mulyango gwʼeweema eyo, basetukanga bonabona nabuli muntu oku mulyango gwʼeweemaye, nʼasinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","OMusengwa nʼatumulanga nʼoMusa maiso ku maiso, ngʼomuntu owaatumula nʼomukaagwawe. Oluzwanyuma oMusa yakanganga omu nkambi, neye omuweereryawe, omuvuvuka oYoswa, omutaane wa Nuuni, tiyaazwanga omu weema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Awo oMusa nʼakoba oMusengwa ati, “Kituuce kiti onkoba oti, ‘Otwale aBaisirairi omu kyalo ekinasuubizire okubawa,’ neye tommanyikisirye oguwatuma aamo na nze. Neye ate nga wankobere oti ommaite kusani, era ndi mukoda egyoli. ");
INSERT INTO gwr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kale obwemba nga ndi mukoda egyoli, nkwegairira onkobere entegekagyo, kaisi njezye okukumanya era neeyongere okubba mukoda egyoli. Era oyebukirye oti walondere eigwanga lya Isirairi okubba bantubo.” ");
INSERT INTO gwr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Awo oMusengwa nʼairamu ati, “Nze onyere nayaba na iwe, era nakuwuumulya omwoyo.” ");
INSERT INTO gwr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kaisi oMusa nʼamukoba ati, “Iwe onanyere owoobba nga toyabe na iswe, totusindika okuzwa aanu. ");
INSERT INTO gwr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ekigira ni nkoba ntyo, aale omuntu yamanya atya nga nze nʼabantubo tuli bakoda egyoli, ate nga toyabire na iswe? Era niki ekyalaga kiti nze nʼabantubo tuli bʼenjawulo oku bantu abandi bonabona oku kyalo?” ");
INSERT INTO gwr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Era oMusengwa nʼakoba oMusa ati, “Njaba kukola kiikyo nakimo ekyosabire, olwʼokubba nkumaite kusani, era oli mukoda egyendi.” ");
INSERT INTO gwr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Awo oMusa nʼasaba ati, “Aale atyanu nkwegairira, ondageku ekitiisyakyo.” ");
INSERT INTO gwr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","OMusengwa nʼairamu ati, “Njaba okubita omumaisogo, obone ekitiisya kyange, era njaba okulangirira omumaisogo eriina lyange Nze oMusengwa. Nalikwatira ekisa oyo ogunalibba ntakire okukwatira ekisa, era nalisaasira oyo ogunalibba ntakire okusaasira.” ");
INSERT INTO gwr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Era nʼayongeraku ati, “Neye tinakuganye okumbona omumaiso, olwʼokubba mpaawo muntu ambona omumaiso, nʼasigala nga mwomi.” ");
INSERT INTO gwr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Awo oMusengwa nʼakoba ati, “Neye waliwo ekifo ekiri okumpi aanu na nze, e giwayemerera okwibbaale. ");
INSERT INTO gwr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Awo kaisi owenaabba mbitawo iwe okubona ekitiisya kyange, nʼakuteeka omu njatikira eri omwibbaale eryo, kaisi nkubiikeku nʼekigalabaayo kyange, paka owenabitawo. ");
INSERT INTO gwr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Oluzwanyuma nakutoolaku ekigalabaayo kyange, kaisi nʼobona mabega gange. Neye toli nʼokumbona omumaiso.” ");
INSERT INTO gwr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Awo oMusengwa nʼakoba oMusa ati, “Oyeese ebipande ebyʼamabbaale bibiri, ebiri ooti biidi ebyasookere, era Nze nabiwandiikaku ebibono ebyabbaire oku bipande byʼamabbaale ebyasookere, ebiwaatire. ");
INSERT INTO gwr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Eizo amakeezi, obbe nga weetegekere, oniine oku Lusozi oSinaayi, nakusisinkana eeyo oku nairungu waalwo. ");
INSERT INTO gwr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tiwaabbaawo muntu yenayena aniina na iwe, waire kadi moiza abonekaku awantu wonawona oku lusozi olwo. Era tiwaabbaawo ntaama waire nte egiriisirya okumpi nʼolusozi olwo.” ");
INSERT INTO gwr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kale oMusa nʼayeesa ebipande ebyʼamabbaale bibiri, nga biri ooti biidi ebyasookere. Era eizo waaku amakeezi, nʼakwata ebipande ebyʼamabbaale ebyo nʼaniina oku Lusozi oSinaayi, ngʼoMusengwa oweyabbaire amulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Awo oMusengwa nʼaikira omu kireri, nʼayemerera eeyo nʼoMusa, era nʼalangirira eriinalye iye oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Era nʼabita omumaiso ga Musa ngʼalangirira ati, “Ninze oMusengwa, iye oMusengwa alumirwa era owʼekisa, alwawo okusunguwala, owʼokutaka okutakoma era owʼobwesigwa obutakoma. ");
INSERT INTO gwr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Era Ninze ali nʼokutaka okutakoma eeri abantu enkumi nʼenkumi, era nsoniya okwonoona, nʼobujeemu nʼebikole ebibbibibbi. Neye tindeka okubonereza oyo abbengere, era mbonereza abaana nʼabaizukulu, paka oku kiizukulu kyokusatu nʼoku kyokuna, olwʼebikole ebibbibibbi byʼababyabaire baabwe.” ");
INSERT INTO gwr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Amangu ago oMusa, nʼakotamya omutwe ansi okwitakali, nʼasinza oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","OMusa nʼakoba ati, “Oo Musengwa Kibbumba, obwemba nga ndi mukoda egyoli, nkwegairira oyabe na iswe. Waire abantu banu bajeemu, neye otusoniye okwonoona kwaiswe nʼebibbibibbi byaiswe, era otwikirirye tubbe bantu ababo okububwo.” ");
INSERT INTO gwr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Awo oMusengwa nʼakoba oMusa ati, “Atyanu ndi kukola endagaano nʼaBaisirairi. Omumaiso gaabwe bonabona, nakolanga ebyewunyo ebintakolangaku omu kyalo kyonakyona. Era abantu bonabona ababali okumpi, babonanga ebikulu Nze oMusengwa ebinkola. ");
INSERT INTO gwr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Mugonderenge ebimbalagira olwatyanu. Nalibeekubbemberamu, ni mbingawo aBamooli, nʼaBakanani, nʼaBakiiti, nʼaBaperizi, nʼaBakiivi, nʼaBayebbusi. ");
INSERT INTO gwr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mwekuume okutakolanga endagaano nʼabatyami bʼomu kyalo e gimuli kwaba. Ekyo kityo olwʼokubba owemwalikikola, balibapapalya omu mutego gwʼokusinza abakibbumba baabwe. ");
INSERT INTO gwr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Wazira mwalibba nʼokwatyaga ebyoto byabwe, nʼokutentena amabbaale gaabwe agebakoma okusengerangaku, era nʼokutemyagamu ebikondo bya nkuni waabwe omukali Asera.” ");
INSERT INTO gwr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Timusinzanga okibbumba ogondi, olwʼokubba oMusengwa, iye Kibbumba owʼeibuba.” ");
INSERT INTO gwr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Tiwakolanga endagaano nʼabantu bʼomu kyalo ekyo, olwʼokubba owebalibba basinza abakibbumba baabwe era nga babawa esadaaka, demba ni bakweta okulyaku esadaaka egyo. ");
INSERT INTO gwr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Era demba nʼokwera abataanebo abakali okuzwa omwigwanga eryo, kaisi abakali abo owebabba basinza abakibbumba baabwe ni bazweraku abataanebo bona okusinza abakibbumba abo.” ");
INSERT INTO gwr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Tiweekoleranga ebifaananyi ebyʼokusinza ebyʼabakibbumba omu kyoma ekisaanuuce.” ");
INSERT INTO gwr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Mukolenge oMukolo ogwʼeMigaati eGibulamu oKazumbulukuca. Enaku musanvu omu mweri gwʼAbbibbu omu kiseera ekituuce, mwabbanga nʼokulya migaati egibulamu okazumbuluca, ngʼowenabalagiire. Mukikolenge mutyo olwʼokubba omu mweri ogwo, niiye owemwazwereire omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nabuli mwana omwisuka omubere omukali oguyabyalanga, yaabbanga wange, era nʼomu byayo byanywe, nabuli kisaiza ekibere ooba ntaama ooba nte, yaabbanga wange. ");
INSERT INTO gwr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Neye ompunda omusaiza omubere mwamununulanga nga musadaaka ntaama omutomuto. Era owemwabbanga timumununwire, mwamuvunanga eikoti okumwita. Era mwanunulanga abaana baanywe abaisuka ababere bonabona. “Tiwaabbangawo kadi moiza aiza okunsinza nʼengalo enjereere. ");
INSERT INTO gwr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Oli nʼenaku mukaaga egiwakolerangamu emirimo, neye oku lunaku olwomusanvu tokolerangaku omulimo, nʼowebyabbanga biseera ebyokulima ooba ebyʼamakungula. ");
INSERT INTO gwr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Okolenge oMukolo ogwʼaMakungula ngʼowaayo engaano ejekeereire okwera omu musirigwo, era okolenge oMukolo ogwʼoKumala oKukungula nga mukomenkerezere okukungula. ");
INSERT INTO gwr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Emirundi misatu nabuli mwanka, abasaiza bonabona mwinywe baizanga okunsinza Nze oMusengwa iye oMukulu, oKibbumba wa Isirairi. ");
INSERT INTO gwr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Owenalimala okubeekubbemberamu ni mbingawo amawanga agandi, ni ngalamya ensalo egyʼekyalo kyanywe, tiwaabbengewo kadi moiza agezyaku okuwamba ekyalo kyanywe. Tibakiwambenge singa owemwaizanga ni munsinza Nze oMusengwa iye oKibbumba waanywe, emirundi emisatu nabuli mwanka. ");
INSERT INTO gwr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Omusaaye gwʼebyayo ebimumpaire ngʼesadaaka, timugumpeerangaku emigaati egirimu okazumbulukuca. Era oku sadaaka eyo eyʼoMukolo ogwʼoKutambukirya timusigalyangaku enyama paka eizo waaku. ");
INSERT INTO gwr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ebirime ebyekeereri ebyʼomu misiri gyanywe era ebikira obusa, mubireetanga omu nyumba yange Nze oMusengwa iye oKibbumba waanywe. “Timusumbiranga enyama ya mbuli omutomuto omu mata ga maaye.” ");
INSERT INTO gwr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Awo oMusengwa nʼakoba oMusa ati, “Owandiike ebibono ebyo, olwʼokubba ebibono ebyo niibyo ebinsiziriraku okukola eNdagaano na iwe, era nʼoIsirairi.” ");
INSERT INTO gwr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","OMusa nʼabba eeyo oku Lusozi olwo ngʼali nʼoMusengwa okumala enaku 40 omusana nʼobwire, nga talya era nga tanywa. Era oMusa nʼawandiika oku bipande byʼamabbaale ebibono ebyʼendagaano nago, nga niigo aMateeka eIkumi. ");
INSERT INTO gwr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Atyanu oMusa oweyaikire okuzwa oku Lusozi oSinaayi, ngʼakwaite ebipande ebyʼamabbaale, ebiriku aMateeka eIkumi, tiyamaite ati omumaisoge mwabbaire munekaaneka olwʼokutumula nʼoMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Alooni nʼaBaisirairi bonabona owebalolere oku Musa, ni babona ngʼomumaisoge munekaaneka, ni batya okumwigereraku. ");
INSERT INTO gwr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Neye oMusa nʼabeeta, era Alooni nʼabeekubbemberi bonabona abʼekibbula ekyʼaBaisirairi ni baaba egiri oMusa nʼatumula nabo. ");
INSERT INTO gwr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Oluzwanyuma aBaisirairi bonabona ni baigerera e gyali. Era oMusa nʼabawa amateeka gonagona, oMusengwa ageyamuweereire oku Lusozi oSinaayi. ");
INSERT INTO gwr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Awo oMusa oweyamalire okutumula nabo, ni yeebiika ekitambaala omumaiso. ");
INSERT INTO gwr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Neye nabuli oweyaingiranga omu Weema yʼoKusisinkanirangamu oMusengwa okutumula naye, nga yeebiikula ekitambaala, paka oweyawulukangamu. Era oweyawulukangamu, okukobera aBaisirairi byonabyona oMusengwa ebiyaabbanga amulagiire okutumula, ");
INSERT INTO gwr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","aBaisirairi babonanga omumaisoge nga munekaaneka. Olwo oMusa ni yeebiikanga ekitambaala omumaisoge, paka oweyaingiranga omu Weema yʼoKusisinkanirangamu oMusengwa okutumula naye. ");
INSERT INTO gwr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Atyanu oMusa nʼayeta ekibbula kyonakyona ekyʼaBaisirairi. Ni bakumbaana, kaisi nʼabakoba ati, “Binu niibyo oMusengwa ebyabalagiire inywe okukola. ");
INSERT INTO gwr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","‘Enaku mukaaga niigyo egimuli nʼokukolerangaku emirimo. Neye olunaku olwomusanvu, lunaku lwa kuwuumula, lwawule, lwange Nze oMusengwa. Nabuli eyakolanga omulimo gwonagwona oku lunaku lwʼeSaabbaato, bamwitanga-bwiti. ");
INSERT INTO gwr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Timukumanga waire musyo omu nyumba gyanywe oku lunaku olwʼeSaabbaato.’ ” ");
INSERT INTO gwr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Awo oMusa nʼakoba ekibbula kyonakyona ekyʼaBaisirairi ati, “Kinu niikyo oMusengwa ekyalagiire. ");
INSERT INTO gwr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Muwengeyo ekirabo eeri oMusengwa. Nabuli ali nʼomwoyo omugabi, aleetere oMusengwa ebirabo binu: Ezaabbu, nʼefeeza nʼobbulonzi, ");
INSERT INTO gwr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nʼengoye gya lineni omusa eino egya bbululu, nʼentukuliikiriri, nʼentukuliki, nʼegyʼewuuzi egyʼebyoya byʼembuli. ");
INSERT INTO gwr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Era bakuwanga nʼamadiba gʼentaama agebacuusire erangi nʼofuula omutukuliki, nʼamadiba gʼembiri, nʼembaabo gyʼomuwa omweru. ");
INSERT INTO gwr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Era nʼamafuta agʼemizaituuni, nʼebyakaloosa ebibatabula omu mafuta agebakolesya omu kwawula, nʼobubbaani obwʼakaloosa. ");
INSERT INTO gwr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Era nʼamabbaale agʼebbeeyi agebeeta onika, nʼamabbaale agandi agʼebbeeyi agebatungira okwitaawo eryʼobwakabona nʼoku kizwalo ekyʼomu kifubba, ebya kabona akira obukulu.” ");
INSERT INTO gwr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Nabuli mukoli omukugu mwinywe, aize akole byonabyona oMusengwa ebyalagiire binu: ");
INSERT INTO gwr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","EWeema eya Musengwa, nʼekyʼokugibiikaku, nʼendobo gyaku, nʼefuleemu egiwayemererya ngʼebikondo byayo, nʼemikiiko gyaku, nʼebikondo byayo, nʼebyoma byʼokwemereryamu ebigere byʼefuleemu; ");
INSERT INTO gwr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","nʼeSanduuku eyʼeNdagaano nʼemigingiro gyayo, nʼekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira, era nʼolutimbe olwawula eKifo eKyeru, nʼeKifo eKyeru eIno; ");
INSERT INTO gwr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","nʼemenza nʼemigingiro gyayo, nʼebintu byaku byonabyona, nʼemigaati emiwonge eeri oKibbumba; ");
INSERT INTO gwr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","nʼekikondo kyʼamataala nʼebintu byaku era nʼamataala nʼamafuta gʼokwakisya; ");
INSERT INTO gwr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","nʼekyoto kyʼobubbaani nʼemigingiro gyakyo, nʼamafuta agebakolesya omu kwawula, nʼobubbaani obwʼakaloosa, nʼolutimbe olwʼomu mulyango gwʼeWeema eyo; ");
INSERT INTO gwr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","nʼekyoto kyʼesadaaka egibooca yonayona, era nʼakatimba kaamu aka bbulonzi, nʼemigingiro gyakyo era nʼebintu byaku byonabyona; nʼekalaayi eya bbulonzi nʼekikondo okwetyama; ");
INSERT INTO gwr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","nʼentimbe egyʼekikomera, nʼebikondo byakyo nʼebyoma byʼokwemereryamu ebikondo, nʼolutimbe olwʼomu muzigo gwʼekikomera; ");
INSERT INTO gwr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","nʼenkondo gyʼeWeema eyo, nʼegyʼoluuga, nʼemiguwa gyaku; ");
INSERT INTO gwr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nʼebizwalo ebyʼobwakabona ebibalukire kusani ebyobutukulye, ebyʼAlooni okabona era nʼebyʼabataanebe okuzwalanga nga baweerererya omu bwakabona.” ");
INSERT INTO gwr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Awo ekibbula kyonakyona ekyʼaBaisirairi ni kizwa e giri oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Era nabuli muntu eyabbaire nʼokuyaayaana era ngʼomwoyogwe gumusindiikirirya, nʼayaba nʼaleetera oMusengwa ekirabo, olwʼokukola oku Weema eya Musengwa. Era ekirabo ekyʼokukola oku bintu ebyetaagisya omwo, era nʼekyʼokutungamu ebizwalo byobutukulye. ");
INSERT INTO gwr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Abasaiza nʼabakali bonabona ababbaire nʼokuyaayaana, ni baaba baleeta ebyamajolobero ebyʼezaabbu ebya buli ngeri, nga niibyo binu: Emikobyo, nʼobwoma bwʼoku matwi, nʼempeta gyʼoku ngalo, nʼebizwalo byʼomu mamiro. Era bonabona ni bawaayo ebyamajolobero byabwe ebyʼezaabbu, ngʼekyokuwaayo ekyʼenjabulo ekibasiirya ni baica eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Abantu bonabona ababbaire nʼengoye egya lineni egya bbululu, ooba entukuliikiriri, ooba entukuliki, ooba egibakolere omu byoya byʼembuli, ooba amadiba gʼentaama agebacuusire erangi nʼofuula omutukuliki, ooba amadiba gʼembiri ni babireeta. ");
INSERT INTO gwr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Era abantu bonabona ababbaire bayezya okuwaayo ekirabo ekyʼefeeza ooba ekya bbulonzi, ni batwala ngʼekyokuwaayo eeri oMusengwa. Nʼabantu ababbaire nʼembaabo gyʼomuwa omweru egibayezya okukolesya omu mulimo gwonagwona, ni bagireeta. ");
INSERT INTO gwr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nʼabakali bonabona ababbaire nʼobukugu ni batunga nʼengalo gyabwe engoye egya bbululu, nʼentukuliikiriri, nʼentukuliki egya lineni omusa eino ni bagireeta. ");
INSERT INTO gwr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Era nʼabakali bonabona ababbaire nʼemyoyo egibasindiikirirya okukolesya obukugu bwabwe ni bakamba ewuuzi omu byoya byʼembuli. ");
INSERT INTO gwr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Era abeekubbemberi bʼaBaisirairi ni baleeta amabbaale agʼebbeeyi agebeeta onika nʼagandi gona agebbeeyi agʼokutungira okwitaawo eryʼobwakabona nʼoku kizwalo ekyʼomu kifubba. ");
INSERT INTO gwr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Era ni baleeta amafuta agʼomuzaituuni agʼomu mataala, nʼebyakaloosa ebyʼokutabula omu bubbaani nʼomu mafuta agebakolesya omu kwawula. ");
INSERT INTO gwr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ABaisirairi bonabona abasaiza nʼabakali ababbaire nʼokuyaayaana ni baleeta eeri oMusengwa ebyokuwaayo omu kwetakira olwʼokukolesya omu mulimo gwonagwona oMusengwa oguyabalagiire ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Awo oMusa nʼakoba aBaisirairi ati, “Aale mubone, oMusengwa yeelondeire oBbezaleeri, omutaane wa Wuuli, era omwizukulu wa Kuuli, owʼekika kya Yuda. ");
INSERT INTO gwr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Era oMusengwa amwizwirye oMwoyowe, nʼamuwa nʼobukugu, nʼobusoboli, nʼamalabuki, okukolanga ebyemikono ebya buli ngeri. ");
INSERT INTO gwr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Era amuwaire nʼobukugu omu byokutetenkanya era okukolanga ebintu omu zaabbu, nʼomu feeza, nʼomu bbulonzi. ");
INSERT INTO gwr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Era nʼokuyeesa amabbaale agʼebbeeyi nʼokugasibira omu fuleemu, nʼokukulungula ebisaale, nʼokukola ebyemikono byonabyona ebya buli ngeri. ");
INSERT INTO gwr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","OMusengwa amuwaire iye, nʼOkolyabbu, omutaane wʼAkisamaaki, owʼekika kya Daani, obusoboli okwegesya abandi. ");
INSERT INTO gwr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Abaizwirye obukugu okukola ebyemikono ebya buli ngeri, ngʼebyobuyeesi nʼebyemisono nʼebyʼokujolija engoye egyʼewuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki, egya lineni omusa eino okugitunga nʼobukugu. Bonabona babitiriri omu byemikono nʼomu byʼemisono.” ");
INSERT INTO gwr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Kale oBbezaleeri, nʼOkolyabbu, nʼabafundi abandi bonabona, oMusengwa abaawaire obukugu nʼamalabuki okumanya engeri eyʼokukolamu omulimo gwonagwona omu kwombeka eWeema eya Musengwa, bali nʼokukola byonabyona ngʼoMusengwa oweyalagiire.” ");
INSERT INTO gwr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Awo oMusa nʼayeta oBbezaleeri nʼOkolyabbu, nʼabafundi abandi bonabona abakugu, oMusengwa abeyawaire obusoboli era ababbaire bayaayaana okwiza okukola omulimo ogwo. ");
INSERT INTO gwr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","OMusa nʼabakwatisya ebyokuwaayo byonabyona aBaisirairi ebibaleetere okwombeka eWeema eya Musengwa. Era abantu ni beeyongera okuleeteranga oMusa nabuli makeezi ebyokuwaayo omu kwetakira. ");
INSERT INTO gwr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Awo abakugu bonabona ababbaire oku mulimo gwʼokwombeka eWeema eyo, ni bazwayo, ");
INSERT INTO gwr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ni baaba bakoba oMusa bati, “Abantu baleetere ebintu bingi ebibitamu ebyo ebyetaagisya okumala omulimo oMusengwa eriyalagiire okukola.” ");
INSERT INTO gwr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kale oMusa nʼalagira ni balangirira omu nkambi yonayona bati, “Atyanu abasaiza nʼabakali, balekeraawo okuwaayo ebyʼokukolesya omu kwombeka eWeema eyo.” Era ni baloberya abantu okweyongera okuwaayo ebintu ebyo, ");
INSERT INTO gwr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","olwʼokubba ebibabbaire bawaireyo, byabbaire bingi okukiraku ebyo ebyabbaire byetaagisya okumala omulimo gwonagwona. ");
INSERT INTO gwr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Abafundi ababbaire abakirira nakimo obukugu omu bakoli bonabona ni bombeka eWeema eya Musengwa. Bagyombekere omu ntimbe ikumi egibatungire omu lineni omusa eino omu wuuzi egya bbululu, nʼentukuliikiriri nʼentukuliki. Entimbe egyo, omukugu omu byokusona yabbaire agisoneremu ebifaananyi byʼabakeruubbi. ");
INSERT INTO gwr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Entimbe gyonagyona gyabbaire gyenkanankana, omu buwanvu emita ikumi na ibiri, nʼomu bugalami emita ibiri. ");
INSERT INTO gwr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Entimbe eitaanu bagiyungisirye ni gibba olutimbe lumo, na gidi eitaanu gyona ni bagiyungisya ni gibba olutimbe lumo. ");
INSERT INTO gwr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Awo ni bakola obukondo omu lugoye olwa bbululu kaisi ni babutungira oku mugo gwa buli lutimbe olwʼoku mbale kwʼentimbe ennyungisye. ");
INSERT INTO gwr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Era batungiire obukondo 50 oku mugo gwʼolutimbe olwʼoku mbale ku buli ntimbe ennyungisye. Obukondo obwʼoku lubba olumo nga buteebangana nʼobwʼoku lubba olundi. ");
INSERT INTO gwr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Era bakolere endobo 50 omu zaabbu, egyʼokuyungisirya aamo entimbe gyombi. Omu ngeri eyo eWeema eyo nebba ooti nkole mu lutimbe lumo olulamba. ");
INSERT INTO gwr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Era ni bakola entimbe ikumi na lumo, omu lugoye olubakolere omu byoya byʼembuli, gibiike oku Weema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Entimbe egyo gyonagyona gyabbaire gyenkanankana, nga nabuli lumo omu buwanvu luli emita ikumi na isatu kaisi obugalami emita ibiri. ");
INSERT INTO gwr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Entimbe eitaanu bagiyungisirye ni gibba olutimbe lumo, na gidi omukaaga gyona ni bagiyungisya ni gibba olutimbe lumo. ");
INSERT INTO gwr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Era oku mugo gwʼolutimbe olwʼoku mbale ku buli ntimbe ennyungisye batungiireku obukondo 50. ");
INSERT INTO gwr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Awo ni bakola endobo 50 omu bbulonzi, egyʼokuyungisirya entimbe eibiri egyo ennyungisye. Omu ngeri eyo eWeema eyo nʼebba ooti bagibiikire olutimbe lumo olulamba. ");
INSERT INTO gwr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Era bakolere ebibiika oku Weema eyo ebindi bibiri, ekimo nga kyʼamadiba gʼentaama ensaiza agebacuusire erangi nʼofuula omutukuliki, nʼekindi ekyʼoku ngulu, nga kyʼamadiba gʼembiri. ");
INSERT INTO gwr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Awo ni bakola efuleemu omu mbaabo gyʼomuwa omweru egibayemererya ngʼebikondo byʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Era nabuli moiza oku fuleemu egyo yabbaire obuwanvu okwaba engulu emita ina nʼobugalami esentimita 66, ");
INSERT INTO gwr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","nga giriku endimi ibiri ibiri, nga gyabirana nʼebiina ebyansi awebayezya okugingirya. Efuleemu egyo gyonagyona egyʼeWeema eyo batyo webagikolere. ");
INSERT INTO gwr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ni bakola efuleemu egyo aabiri egyʼolubba olwʼe maserengeta. ");
INSERT INTO gwr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Era ni bakola ebyoma ebyʼefeeza 40 ebyʼokwemereryamu ebigere byʼefuleemu egyo, ekikoba kiti, ebyoma bibiri ansi wa buli fuleemu. ");
INSERT INTO gwr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Oku lubba ludi irwo olundi olwʼe mambuka wʼeWeema eyo ni bakola efuleemu egyo aabiri. ");
INSERT INTO gwr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Era ni bakola nʼebyoma ebyʼefeeza 40 ebyʼokwemereryamu ebigere byʼefuleemu egyo. Ni bakola ebyoma bibiri bibiri ansi wa buli fuleemu egyo. ");
INSERT INTO gwr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Kaisi e nduguulo wʼeWeema eyo oku lubba lwʼe bugwaisana, ni bakola efuleemu egyo mukaaga, ");
INSERT INTO gwr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","nʼefuleemu egyo egindi ibiri egyʼomu nsonda. ");
INSERT INTO gwr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Efuleemu egyo, egyʼoku nsonda egyʼe mambuka nʼegyʼe maserengeta ni bagiyimbya oku nsonda gyagyo okuzwa ansi paka e ngulu okumpi nʼomukobyo ogwʼezaabbu ogusooka ogusiba onaizizi. Efuleemu gyʼoku nsonda gyombi bagikolere mu ngeri moiza. ");
INSERT INTO gwr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kale gyonagyona aamo gyabbaire efuleemu munaana, nʼebyoma ebyʼefeeza ikumi na mukaaga, nga biri bibiri bibiri ansi wa buli fuleemu egyo. ");
INSERT INTO gwr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Era ni bakola emikiiko ikumi na mitaanu omu mbaabo gyʼomuwa omweru, emikiiko emitaanu ni gibba oku fuleemu egyʼolubba olumo olwʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Nʼegindi emitaanu ni gibba oku fuleemu egyʼolubba olundi, nʼemitaanu egindi ni gibba oku fuleemu egyʼe nduguulo oku lubba olwʼe bugwaisana. ");
INSERT INTO gwr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Omukiiko ogwʼakati wʼefuleemu egyo oku mba eisatu egyo ni guzwera oku nsonda ni gutuuka oku nsonda. ");
INSERT INTO gwr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Efuleemu egyo bagisiigireku ezaabbu ensaanuuce era ni bagikwatisiryaku emikobyo egyʼezaabbu egyʼokukwatirira emikiiko, era emikiiko gyona bagisiigireku ezaabbu ensaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Era ni bakola olutimbe omu lineni omusa eino omujolije omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki, ni batungiramu ebifaananyi byʼabakeruubbi. ");
INSERT INTO gwr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ni bakwatisya olutimbe olwo nʼendobo egyʼezaabbu oku bikondo ebina ebibabbaire bakolere omu mbaabo gyʼomuwa omweru, ebibasiigireku ezaabbu ensaanuuce era ebibeemereirye omu byoma ebina ebyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ni bakola olutimbe olwʼomu mulyango ogwingira omu Weema eyo. Olutimbe olwo ni balutunga omu lineni omusa eino omujolije omu bukugu omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Olutimbe olwo ni balukolera ebikondo bitaanu ebibakolere omu mbaabo gyʼomuwa omweru, era ni babisiigaku ezaabbu ensaanuuce. Endobo gyabyo gyabbaire gyʼezaabbu era ebikondo ebyo ni babikolera ebyoma bitaanu ebya bbulonzi ebyʼokwemereryamu ebikondo ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Awo oBbezaleeri nʼakola eSanduuku eyʼeNdagaano omu mbaabo gyʼomuwa omweru. Yagikolere obuwanvu esentimita 110, nʼobugalami esentimita 66, nʼobuwanvu okwaba engulu esentimita 66. ");
INSERT INTO gwr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Omunda nʼoku ngulu nʼagisiiga ezaabbu ennongoole ensaanuuce, nʼagiteekaku akagongo kʼezaabbu okugyeruguulirirya. ");
INSERT INTO gwr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Era nʼagikolera emikobyo ena egyʼezaabbu, kaisi nʼagikwatisirya oku bigere byayo ebina, emikobyo emibiri ni gibba oku lubba olumo nʼemibiri oku lubba olundi. ");
INSERT INTO gwr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Awo nʼakola emirabba emigingiro egyʼomuwa omweru nʼagisiigaku ezaabbu ensaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Emirabba emigingiro egyo nʼagibitya omu mikobyo oku lubba nʼolubba lwʼeSanduuku eyʼeNdagaano kaisi bagigingirenge niigyo. ");
INSERT INTO gwr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Era nʼakwata ezaabbu ennongoole, nʼagikolamu ekisaanikiro kyʼeSanduuku iyo entebe ya Kibbumba onanyere okusaasira. Ekisaanikiro ekyo, yakikolere obuwanvu esentimita 110, nʼobugalami esentimita 66. ");
INSERT INTO gwr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Era nʼayeesa omu zaabbu ebifaananyi ebyʼabakeruubbi, ni bibba oku lubba nʼolubba lwʼekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira. ");
INSERT INTO gwr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ekimo nʼakiyeesa oku lubba olumo, nʼekindi oku lubba olundi. Nʼabiyeesa anambula mayungiro nʼekisaanikiro iyo entebe ya Kibbumba onanyere okusaasira. ");
INSERT INTO gwr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ebifaananyi ebyo byalingirirangaine, ngʼamaiso gaabyo galingiriire ansi ku kisaanikiro iyo entebe ya Kibbumba onanyere okusaasira, nʼebiyaya byabyo nga byanzululye engulu era nga bibiikaku ekisaanikiro ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Awo oBbezaleeri nʼakola emenza omu mbaabo gyʼomuwa omweru, obuwanvu esentimita 88, nʼobugalami esentimita 44, nʼobuwanvu okwaba engulu esentimita 66. ");
INSERT INTO gwr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Era nʼagisiigaku ezaabbu ennongoole ensaanuuce, nʼagiteekaku akagongo akʼezaabbu oku mbale mbale oku ngulu wʼemenza okugyeruguulirirya. ");
INSERT INTO gwr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Nʼagikubbaku akabaabo obugalami emirimita 75 okweruguulirirya emenza, nga kasiba olubaabo lwʼoku ngulu nʼebigere. Era engulu oku kabaabo ako, nʼateekaku akagongo akʼezaabbu okweruguulirirya akabaabo nago. ");
INSERT INTO gwr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Era nʼakola emikobyo ena egyʼezaabbu, kaisi nʼagikwatisirya oku nsonda eina, awali ebigere byayo. ");
INSERT INTO gwr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Emikobyo egyo, nʼagikwatisiirya kumpi nʼakabaabo nago. Era emikobyo egyo niigyo egyakwatiriranga emirabba emigingiro egyʼemenza eyo. ");
INSERT INTO gwr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Nʼakola emirabba emigingiro omu mbaabo gyʼomuwa omweru, kaisi nʼagisiigaku ezaabbu ensaanuuce, era niigyo egibagingiranga emenza eyo. ");
INSERT INTO gwr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Era nʼakola amasaani, nʼebikopo, nʼejaaga, era nʼamabbakuli, ebyokukolesyanga nga bawaayo ebyokuwaayo ebyʼebyokunywa. Ebintu ebyo yabikolere mu zaabbu ennongoole. ");
INSERT INTO gwr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Awo oBbezaleeri nʼayeesa ekikondo kyʼamataala omu zaabbu ennongoole. Era nʼayeesa entyamiro nʼekikondo kyakyo, nga kuliku obukopo obujolije ooti bimuli. Era nga kuliku nʼokujolija okuli ooti bituutwa nʼobukoola bwʼoku bimuli. Byonabyona ebyo byabbaire biyeese mu zaabbu enambirira anambula mayungiro. ");
INSERT INTO gwr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Era kyabbaireku amasaga mukaaga nga ku buli lubba lwʼekikondo kuliku amasaga masatu. ");
INSERT INTO gwr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Nabuli limo oku masaga omukaaga, kwabbaireku obujolije busatu obuli ooti bimuli byʼomusaale ogubeeta alumondi. Era kwabbaireku okujolija kwʼebituutwa nʼokwʼobukoola bwʼoku bimuli. ");
INSERT INTO gwr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Oku kikondo kyʼamataala, kwabbaireku obujolije buna obufaanana ooti bituutwa era ooti bukoola bwʼoku bimuli. ");
INSERT INTO gwr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ansi wʼamasaga amabiri agasooka ansi oku kikondo, bajolijiryewo ekituutwa ekisooka. Ekituutwa ekyokubiri ni kibba ansi wa gadi amabiri agokubiri, kaisi ekituutwa ekyokusatu ni kibba ansi wʼamasaga amabiri agokusatu. Ago nga niigo amasaga omukaaga. ");
INSERT INTO gwr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ebituutwa ebyo era nʼamasaga nago byabbaire byʼezaabbu ennongoole enambirira anambula mayungiro nʼekikondo kyʼamataala ekibayeesere omu zaabbu ennongoole anambula mayungiro. ");
INSERT INTO gwr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Era yakolere amataala musanvu agʼokuteeka oku kikondo kyago, era omu zaabbu ennongoole nʼakolamu nʼemakansi egisala entambi, nʼamasoniya agʼokuteekaku entambi egisiiriire. ");
INSERT INTO gwr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Yakoleserye ekiro 35 egyʼezaabbu ennongoole, okukola ekikondo kyʼamataala nʼebintu byaku byonabyona. ");
INSERT INTO gwr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Awo oBbezaleeri nʼakola ekyoto kyʼokuduunyiryangaku obubbaani, omu muwa omweru. Yakikolere nga kyenkanankana emba gyonagyona. Obuwanvu esentimita 45, nʼobugalami esentimita 45, kaisi obuwanvu okwaba engulu esentimita 90. Amaziga gaakyo yagabaizire ku kisaale kinanyere ekyo ekyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Era nʼasiiga ezaabbu ennongoole ensaanuuce oku ngulu, nʼoku mba gyakyo eina, nʼoku maziga gaakyo, nʼakiteekaku akagongo akʼezaabbu okweruguulirirya emba gyakyo eina. ");
INSERT INTO gwr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Nʼakola emikobyo mibiri egyʼezaabbu nʼagikwatisirya ansi wʼakagongo, oku mba gyakyo eibiri egiteebangaine, era emikobyo egyo nga niigyo egikwatirira emirabba emigingiro gyʼekyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Nʼakola emirabba emigingiro omu muwa omweru, era nʼagisiigaku ezaabbu ensaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Era oBbezaleeri nʼakola amafuta agʼobuwonge agebakolesya omu kwawula, nʼakola nʼobubbaani obwʼakaloosa ngʼomukugu atabula ebyakaloosa owaakola. ");
INSERT INTO gwr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","OBbezaleeri nʼakola ekyoto ekyʼesadaaka egibooca yonayona omu mbaabo gyʼomuwa omweru, ekyabbaire kyenkanankana oku mba gyonagyona eina. Obuwanvu emita ibiri nʼesentimita aabiri, nʼobugalami emita ibiri nʼesentimita aabiri, nʼobuwanvu okwaba engulu kyabbaire emita moiza nʼesentimita 30. ");
INSERT INTO gwr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Era nʼakikoleraku amaziga ena, nga ku buli nsonda kuliku eiziga limo. Amaziga ago yagabaizire ku kyoto kunanyere okwo anambula mayungiro, era nʼagasiigaku obbulonzi omusaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Era nʼakola ebyʼokukolesyanga oku kyoto, ekikoba kiti, ebyokuyoolerangamu eikoke, nʼebitiiyo, nʼebibya, nʼebitiiyo ebyʼamaino, nʼobukalaayi. Ebintu ebyo byonabyona, yabikolere mu bbulonzi. ");
INSERT INTO gwr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Era ekyoto ekyo nʼakikolera akatimba nga ka bbulonzi. Akatimba ako nʼakateeka omunda wʼekyoto, ni kabba nga kakoma aakati okuzwa ansi. ");
INSERT INTO gwr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Era nʼasiba ku buli nsonda omukobyo ogwa bbulonzi gumo gumo egyʼokubityamu emirabba emigingiro. ");
INSERT INTO gwr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Awo nʼakola emirabba emigingiro omu muwa omweru, era nʼagisiigaku obbulonzi omusaanuuce. ");
INSERT INTO gwr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Emigingiro egyo nʼagibitya omu mikobyo oku lubba nʼolubba lwʼekyoto, kaisi bakigingirenge niigyo. Ekyoto ekyo yakikolere nga kyʼembaabo, era nga kirimu ekiina ooti kyʼekibbookisi. ");
INSERT INTO gwr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Awo oBbezaleeri nʼakola omu bbulonzi owʼendabirwamu ekalaayi nʼekikondo okwetyama. Era obbulonzi oyo abakali abaweereryanga oku mulyango gwʼeWeema eya Musengwa niibo ababbaire bamuwaireyo. ");
INSERT INTO gwr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Awo nʼakola oluuga lwʼeWeema eya Musengwa, era nʼalusitaku entimbe gyʼolugoye lwa lineni omusa eino. Oku lubba olwʼe maserengeta, entimbe gyabbaire obuwanvu emita 44. ");
INSERT INTO gwr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Entimbe egyo nʼagikwatisya oku bikondo aabiri ebya bbulonzi, ebibayemereirye omu byoma ebya bbulonzi aabiri, era nʼakwatisya entimbe egyo nʼendobo egyʼefeeza omu mikobyo egyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Era nʼentimbe egyʼoku lubba olwʼe mambuka gyona nʼagikola obuwanvu nga gyʼemita 44, nʼagikwatisirya oku bikondo aabiri ebibeemereirye omu byoma bya bbulonzi aabiri, era nʼakwatisya entimbe egyo nʼendobo egyʼefeeza omu mikobyo egyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Oku lubba olwʼe bugwaisana, ni waabbaayo entimbe obuwanvu emita 22, nʼagikwatisirya oku bikondo ikumi ebibayemereirye omu byoma ikumi ebya bbulonzi era nʼakwatisya entimbe egyo, nʼendobo egyʼefeeza omu bukobyo bwʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Oku lubba olwʼe buzwaisana okuliku omulyango, oluuga lwabbaire obugalami emita aabiri. ");
INSERT INTO gwr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Era oku lubba olumo kwabbaireku olutimbe obuwanvu emita mukaaga, nʼesentimita 60 okutuuka oku mulyango. Ni kubbaaku nʼebikondo bisatu ebibayemereirye omu byoma bisatu. ");
INSERT INTO gwr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Kaisi oku lubba olundi okutuuka oku mulyango kwona ni kubbaaku olutimbe obuwanvu emita mukaaga nʼesentimita mukaaga, nʼebikondo bisatu ebibayemereirye omu byoma bisatu. ");
INSERT INTO gwr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Entimbe egyo gyonagyona okweruguulirirya oluuga bagitungire omu lugoye olwa lineni omusa eino. ");
INSERT INTO gwr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ebyoma ebyʼokwemereryanu ebikondo byʼoluuga, byabbaire bya bbulonzi era endobo nʼemikobyo, byabbaire byʼefeeza, kaisi emitwe gyʼebikondo ebyo ni bagisiigaku efeeza ensaanuuce. Era nʼemikobyo egyʼokukwatisirya entimbe gyona gyabbaire gyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Olutimbe olwʼomu muzigo ogwingira omu luuga lwʼeWeema balukolere omu lugoye olwa lineni omusa eino, era ni balujolija omu wuuzi egya bbululu, nʼentukuliikiriri nʼentukuliki. Olutimbe olwo lwabbaire obuwanvu emita mwenda, nʼobugalami emita ibiri ngʼentimbe gyʼekikomera kyʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Olutimbe olwo yalukwatisirye oku bikondo bina ebibayemereirye omu byoma bina ebya bbulonzi. E ngulu oku bikondo ebyo nʼabisiigaku efeeza ensaanuuce era endobo nʼemikobyo gyaku gyabbaire gyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Enkondo egyʼeWeema eyo, nʼegyʼekikomera gyabbaire gya bbulonzi. ");
INSERT INTO gwr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Lunu niirwo olukalala lwʼebintu ebibakolesyerye omu kwombeka eWeema eya Musengwa, omu bateekere eSanduuku yʼeNdagaano. OMusa niiye eyalagiire aBaleevi okukola olukalala olwo, era ngʼabalungamya niiye oIsamali omutaane wʼAlooni okabona. ");
INSERT INTO gwr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","OBbezaleeri omutaane wa Wuuli, era omwizukulu wa Kuuli, owʼekika kya Yuda, niiye eyakolere ebintu byonabyona, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Era eyamubbeereireku, yabbaire niiye Okolyabbu omutaane wʼAkisamaaki, owʼekika kya Daani. Okolyabbu oyo yabbaire mukugu omu byemikono nʼomu byemisono, nʼomu byokujolija nʼatunga engoye egya lineni omusa eino enjolije omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ezaabbu yonayona egibatoire oku sadaaka eyʼenjawulo egibasiirya olwʼokwombeka eWeema eyo, yabbaire ekiro 1,000, okusinzirira oku bipimo ebitongole ebyʼomu Weema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Kaisi efeeza eyazwire mwabo abebabalire omu kubala kwʼabantu, yabbaire ekiro 3,430 okusinzirira oku bipimo ebitongole ebyʼomu Weema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Abo abebabalire omu kubala kwʼabantu, niibo abo ababbaire abʼemyanka egyʼobukulu aabiri nʼokukirawo. Babbaire abasaiza 603,550. Nabuli moiza yaawangayo obungi obubamugerekere, nga niiyo ebbeka emoiza, iyo nga kibba kitundu kyʼesekeri, okusinzirira omu bipimo ebitongole ebyʼomu Weema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Etalanta 100 egyʼefeeza, niigyo egibakoleserye okukola ebyoma 100 okwemereryamu efuleemu gyʼebikondo byʼeWeema eyo nʼebikondo ebyʼolutimbe olwʼomunda, ekikoba kiti, nabuli kyoma etalanta moiza. ");
INSERT INTO gwr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ekiro 30 egyʼefeeza egyasigairewo, oBbezaleeri nʼagikolamu emikobyo nʼendobo egyʼoku bikondo, era nʼagikolesya nʼokugisiiga e ngulu oku bikondo ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Obbulonzi ogubawairewo eeri oMusengwa ngʼekyokuwaayo ekyʼenjawulo ekibasiirya ni baica, yabbaire kiro 2,425. ");
INSERT INTO gwr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Obbulonzi oyo niiye oguyakoleserye okukola ebyoma ebyʼokwemereryamu ebikondo ebyʼoku mulyango gwʼeWeema eyo, nʼokukola ekyoto, nʼakatimba kaamu aka bbulonzi, nʼebintu byonabyona ebyʼokukolesya oku kyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Era omu bbulonzi onanyere oyo nʼakolamu ebyoma ebyʼokwemereryamu ebikondo ebyʼokukwatisiryaku entimbe gyʼekikomera kyʼeWeema eyo. Era omu bbulonzi oyo nʼakolamu nʼebyoma ebyʼokwemereryamu ebikondo byʼoku muzigo gwʼekikomera kyʼeWeema eyo era nʼakolamu nʼenkondo gyonagyona egyʼeWeema eyo era nʼegyʼekikomera kyayo. ");
INSERT INTO gwr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Awo oBbezaleeri, nʼOkolyabbu nʼabantu abandi abakugu ni bakola ebizwalo ebyobutukulye. Babikolere mu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki, nga byʼAlooni kuzwalanga ngʼaweererya omu Weema eya Musengwa. Era babikolere ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Ni bakola eitaawo eryʼobwakabona omu wuuzi egyʼezaabbu nʼomu lineni omusa eino omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ni babbambamya ezaabbu nʼebba njeyeyere, kaisi ni bagisalamu obuntu ooti buguwa. Awo ni babutungamu nʼobukugu olugoye nʼewuuzi egya lineni omusa eino egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ni bakola obusibiro obwʼeitaawo obubita oku mabega, ni babutungira oku nsonda eibiri egyʼeitaawo eryo okugaita ekitundu kyʼomumaiso nʼekyʼe nyuma. ");
INSERT INTO gwr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Era ni batungira omusibiro nʼobukugu okwitaawo okunanyere okwo omumaiso ni kibba kintu kimo ekiramba, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ni bayeesa amabbaale mabiri agebeeta onika, kaisi ni bagawandiikaku amaliina gʼabataane ba Isirairi era ni bagasiba omu fuleemu egyʼewaaya gyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Era ni bagasibira oku busibiro obwʼeitaawo obubita oku mabega, okwebukirisyanga abaana ba Isirairi, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Awo ni bakola ekizwalo kyʼomu kifubba, omu ngeri enanyere eyo eyʼobukugu ngʼowebakolere eitaawo. Bakikolere omu wuuzi egyʼezaabbu nʼomu lineni omusa eino omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki. ");
INSERT INTO gwr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ekizwalo ekyo, kyabbaire kyenkanankana obuwanvu, nʼobugalami era nga kiringemu lumo, obuwanvu esentimita 22, nʼobugalami esentimita 22. ");
INSERT INTO gwr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Awo ni bakiteekamu enyiriri ina egyʼamabbaale agʼebbeeyi. Olunyiriri olusooka lwabbaire lwʼamabbaale agebeeta osaludiyo, nʼotopazi, nʼokalubbunkulo. ");
INSERT INTO gwr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Olunyiriri olwokubiri lwabbaire lwʼamabbaale agebeeta emeraludo, nʼosafiro, nʼodayamondi. ");
INSERT INTO gwr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Olunyiriri olwokusatu lwabbaire lwʼamabbaale agebeeta oyakinto, nʼagate, nʼametisito. ");
INSERT INTO gwr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Nʼolunyiriri olwokuna lwabbaire lwʼamabbaale agebeeta obberulo, nʼonika, nʼoyasipa, era nga bagasibiire omu fuleemu egyʼewaaya gyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Nabuli limo oku mabbaale ago eikumi na mabiri, ni baliwandiikaku ngʼowebakola eraama, eriina limo limo. Amaliina ago gabbaire gʼabataane ba Isirairi nga geemererawo oku lwʼebika eikumi na bibiri ebya Isirairi. ");
INSERT INTO gwr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Era ni bakola obujegere omu zaabbu ennongoole nga bukambe ooti buguwa, okukwatisirya ekizwalo kyʼomu kifubba nʼeitaawo. ");
INSERT INTO gwr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ni bakola efuleemu ibiri egyʼewaaya gyʼezaabbu, nʼemikobyo mibiri gyona omu zaabbu. Emikobyo egyo emibiri, ni bagikwatisirya oku nsonda gyombi egyʼe ngulu egyʼekizwalo ekyʼomu kifubba. ");
INSERT INTO gwr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Era ni basibira obujegere obwo obwʼezaabbu omu bukobyo obubiri, oku nsonda egyʼekizwalo ekyʼomu kifubba. ");
INSERT INTO gwr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Kaisi emba egindi egyʼobujegere obwo, ni bagisiba oku mba eibiri egyʼefuleemu egyʼewaaya egyʼezaabbu. Batyo ekizwalo ekyʼomu kifubba ni bakigaita oku busibiro obwʼeitaawo eryʼobwakabona obwʼomumaiso obubita oku mabega. ");
INSERT INTO gwr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Awo ni bakola obukobyo obundi bubiri omu zaabbu, ni babutungira omunda wʼekizwalo ekyo oku nsonda gyombi e gyʼansi egiguunya okwitaawo. ");
INSERT INTO gwr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Era ni bakola obukobyo tete obundi bubiri omu zaabbu, ni babutungira ansi ansi wʼobusibiro obwʼeitaawo, obwʼomumaiso obubita oku mabega. Era ni batungira obukobyo obwo e ngulu ngulu wʼomusibiro omujolije awegwekwatira okwitaawo. ");
INSERT INTO gwr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Awo ni basibira obukobyo obwʼoku kizwalo ekyʼomu kifubba, oku bukobyo bwʼokwitaawo nʼakasibiro ka bbululu. Omu ngeri eyo ekizwalo kyʼomu kifubba ni kibba nga tikyewuuba okuzwa okwitaawo. Ebyo byonabyona babikolere ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Awo ni bakola eganduula, egibazwala kaisi bairyaku eitaawo eryʼobwakabona nga yonayona bagirukire mu wuuzi gya bbululu. ");
INSERT INTO gwr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Eganduula eyo, bagiteekereku ekiwundu omutwe omu gubita nga bagizwala. Ni basona amatundu okweruguulirirya ekiwundu ekyo kaisi tiyanyiirika. ");
INSERT INTO gwr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Era okweruguulirirya eigemo lyʼeganduula eyo, ni bajolijaaku ebifaananyi byʼebineneka byʼomusaale ogubeeta nkomamawanga nga bitunge omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki egya lineni omusa eino. ");
INSERT INTO gwr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Era ni bakola emiyoga omu zaabbu ennongoole, kaisi ni bagiteeka aakati wʼebifaananyi byʼebineneka ebyo. ");
INSERT INTO gwr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Era ni bateeka emiyoga egyo nga giiranganaku nʼebifaananyi byʼebineneka ebyo okweruguulirirya eigemo lyʼeganduula eyo egibazwala nga baweererya, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Awo ni batungira Alooni nʼabataane ebbeketera omu lineni omusa eino. ");
INSERT INTO gwr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ni batunga nʼekitambaala kyʼoku mutwe ekyʼobwakabona, nʼenkofiira, omu lineni omusa eino. Era ni batunga nʼepajama omu lineni omusa eino. ");
INSERT INTO gwr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Era batungire nʼemisibiro omu lineni omusa eino omu wuuzi egya bbululu, nʼentukuliikiriri, nʼentukuliki, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Awo omu kumalirirya ni bakola akapande aka buwonge eeri oKibbumba, omu zaabbu ennongoole, ni bawandiikaku ekiwandiiko ekiti, “MUWONGE EERI OMUSENGWA.” ");
INSERT INTO gwr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ni basibira akapande ako oku kitambaala kyʼoku mutwe nago, nʼakasibiro aka bbululu, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Kale omulimo gwonagwona ogwʼeWeema ya Musengwa ni guwa. Era aBaisirairi bakolere nabuli kintu ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Awo ni baleetera oMusa eWeema eya Musengwa. Ekikoba kiti, eWeema eyo era nʼebintu byayo byonabyona, omuli endobo gyayo, nʼefuleemu egyakola ngʼebikondo, nʼemikiiko gyayo era nʼebyoma ebyʼokwemereryamu ebikondo nʼefuleemu gyʼebikondo; ");
INSERT INTO gwr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","nʼebibiika oku Weema eyo, ebyʼamadiba gʼentaama ensaiza agebacuusire erangi nʼofuula omutukuliki, nʼamadiba gʼembiri, nʼolutimbe olukingulya eSanduuku eyʼeNdagaano; ");
INSERT INTO gwr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","nʼeSanduuku yʼeNdagaano nga kuliku nʼemirabba emigingiro era nʼekisaanikiro kyaku iyo entebe ya Kibbumba onanyere okusaasira; ");
INSERT INTO gwr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","nʼemenza nʼebintu byaku byonabyona, era nʼeMigaati eMiwonge eeri oKibbumba; ");
INSERT INTO gwr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","nʼekikondo kyʼamataala ekyʼezaabbu ennongoole, nʼamataala gaaku, nʼebintu byaku byonabyona, era nʼamafuta gʼokwakisya; ");
INSERT INTO gwr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","nʼekyoto ekyʼezaabbu, nʼamafuta agebakolesya omu kwawula, nʼobubbaani obwʼakaloosa, era nʼolutimbe olwʼomu mulyango gwʼeWeema eyo; ");
INSERT INTO gwr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","nʼekyoto ekya bbulonzi, nʼakatimba kaamu aka bbulonzi, nʼemirabba emigingiro gyakyo, era nʼebintu byaku byonabyona, nʼekalaayi eya bbulonzi nʼekikondo okwetyama; ");
INSERT INTO gwr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","nʼentimbe egyʼekikomera nʼebikondo byakyo, nʼebyoma byʼokwemereryamu ebikondo ebyo, nʼolutimbe olwʼomu muzigo gwʼekikomera, nʼemiguwa nʼenkondo gyʼeWeema eyo; nʼebintu byonabyona ebyʼokukolesya omu Weema eyo; ");
INSERT INTO gwr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","era nʼebizwalo ebyʼobwakabona ebibalukire kusani, ebyobutukulye ebyʼAlooni okabona era nʼebyʼabataanebe okuzwalanga nga baweerererya omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","ABaisirairi bakolere omulimo ogwo gwonagwona ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Awo oMusa nʼakebera omulimo gwabwe ogwo gwonagwona, nʼabona nga bagumaliriirye, era nga bagukoleire nakimo ngʼoMusengwa oweyalagiire. Kale oMusa nʼabasabira enkabi. ");
INSERT INTO gwr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Oku lunaku olusooka omu mwanka omuyaaka, walibba nʼokukomeka eWeema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Era waligiteekamu eSanduuku yʼeNdagaano, nʼosibawo olutimbe okugikingulya. ");
INSERT INTO gwr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Era walingirya emenza kaisi nʼogiteekaku ebintu byaku. Era walingirya ekikondo ekyʼamataala kyona, nʼokiteekaku amataala gaakyo. ");
INSERT INTO gwr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Era waliteeka ekyoto ekyʼezaabbu ekyʼokuduunyiryangaku obubbaani omumaiso gʼeSanduuku eyʼeNdagaano, era nʼosiba olutimbe omu mulyango gwʼeWeema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Waliteeka omumaiso gʼomulyango gwʼeWeema eyo ekyoto ekyʼesadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Era waliteeka ekalaayi eyʼokunaabirangamu aakati wʼeWeema eyo nʼekyoto kyʼesadaaka egibawaayo nga bagyoca yonayona, era nʼosuka omu kalaayi eyo amaizi. ");
INSERT INTO gwr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Walisiba entimbe okukola ekikomera okweruguulirirya eWeema eyo nʼoluuga lwayo, era nʼosiba olutimbe omu muzigo gwayo. ");
INSERT INTO gwr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Awo walitoola amafuta egebakolesya omu kwawula, nʼogaswankira oku Weema eya Musengwa okugiwonga, nʼoku bintu byonabyona ebigirimu. Waligiwonga nʼebintu byonabyona ebigirimu era awo yalibba ntukulye. ");
INSERT INTO gwr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Era walisuka amafuta ago oku kyoto ekyʼesadaaka egibooca yonayona, nʼosuka nʼoku bintu byakyo byonabyona okukiwonga. Era awo kyalibba kitukulye ino. ");
INSERT INTO gwr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Era waligasuka oku kalaayi nʼekikondo okwetyama, byona ni bibba bitukulye. ");
INSERT INTO gwr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Kaisi awo nʼoleeta Alooni nʼabataane oku mulyango gwʼeWeema eya Musengwa, nʼobanaabya nʼamaizi. ");
INSERT INTO gwr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Era nʼozwalisya Alooni ebizwalo ebyʼobutukulye, nʼomusukaku amafuta, okumwawula, kaisi ampeereryenge omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Era walireeta abataane nʼobazwalisya ebbeketera. ");
INSERT INTO gwr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Bona nʼobasukaku amafuta ngʼowewalibba okolere okwitewaabwe, kaisi bampeereryenge omu bwakabona. Okubasukaku amafuta okwo, kwalibasuuca ibo nʼeibyaire lyabwe okubba bakabona emirembe nʼemirembe.” ");
INSERT INTO gwr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","OMusa nʼakola byonabyona ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Awo oku lunaku olusooka omu mweri ogusooka omu mwanka ogwokubiri okuzwa ngʼowebazwire e Misiri, ni bakomeka eWeema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Era oMusa oweyakomekere eWeema eyo, nʼateekawo ebyoma ebyʼokwemereryamu efuleemu nʼebikondo, kaisi nʼayemereryamu efuleemu, okwo nʼayungisyaku emikiiko era nʼayemererya nʼebikondo. ");
INSERT INTO gwr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Awo ni balingulula ebyʼokugibiikaku, ni bagibiika era ni bayongeraku nʼebibiika ebindi ebyʼoku ngulu, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Era nʼatoola ebipande ebibiri ebyʼamabbaale, ebyabbaire biwandiikeku amateeka ga Kibbumba, nʼabiteeka omu Sanduuku eyʼeNdagaano. Nʼateeka emirabba emigingiro omu mikobyo gyʼeSanduuku yʼeNdagaano, kaisi oku Sanduuku eyo nʼateekaku ekisaanikiro kyaku iyo entebe ya Kibbumba onanyere okusaasira. ");
INSERT INTO gwr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Awo nʼaingirya eSanduuku yʼeNdagaano omu Weema eyo era nʼasibawo olutimbe okukingulya eSanduuku yʼeNdagaano ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Era nʼateeka emenza omu Weema eyo oku lubba lwʼe mambuka olwʼeWeema eyo e nza wʼolutimbe olwʼomunda. ");
INSERT INTO gwr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Nʼagiteekaku emigaati emiwonge eeri oKibbumba ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Era nʼateeka ekikondo kyʼamataala omu Weema eyo oku lubba lwʼe maserengeta wʼeWeema eyo nga kiringirirangaine nʼemenza. ");
INSERT INTO gwr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Awo nʼakwatisya amataala omumaiso ga Musengwa, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Era nʼateeka ekyoto ekyʼezaabbu omu Weema eyo, omumaiso gʼolutimbe lwʼomunda. ");
INSERT INTO gwr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Oku kyoto ekyo nʼaduunyiryaku obubbaani obwʼakaloosa, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nʼasiba olutimbe omu mulyango gwʼeWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Nʼateeka ekyoto kyʼesadaaka egibooca yonayona okumpi nʼomulyango gwʼeWeema eya Musengwa. Era nʼakiweeraku esadaaka egibooca yonayona, nʼakiweeraku nʼekyokuwaayo ekyʼempeke, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Era nʼateeka ekalaayi aakati wʼeWeema eyo nʼekyoto ekyo, kaisi nʼagisukamu amaizi agʼokunaaba. ");
INSERT INTO gwr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","OMusa, nʼAlooni, nʼabataane bʼAlooni, ni bakolesyanga amaizi ago okunaaba engalo gyabwe nʼebigere byabwe. ");
INSERT INTO gwr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Banaabanga nabuli owebaingiranga omu Weema eyo ooba owebaigereranga oku kyoto, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Awo oMusa nʼasiba entimbe egyʼekikomera kyʼeWeema eyo okweruguulirirya eWeema eyo nʼekyoto, era nʼasiba olutimbe olwʼomu muzigo gwʼekikomera ekyo. OMusa atyo nʼamalirirya omulimo ogwo. ");
INSERT INTO gwr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Awo ekireri ekizizi ni kibiika oku Weema eya Musengwa era nʼeizula ekitiisya kya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Era oMusa nandi nʼayezya okwingira omu Weema eyo olwʼokubba ekireri kyabbaire kigibiikireku era ngʼekitiisya kya Musengwa kiizwire omu Weema eyo. ");
INSERT INTO gwr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Omu lugendo lwabwe lwonalwona nabuli ekireri owekyasetukanga ni kizwa oku Weema eyo, awo ngʼaBaisirairi bona basimbukawo. ");
INSERT INTO gwr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Neye ekireri ekyo owekyabbanga kikaali kiri oku Weema eyo ngʼaBaisirairi bona tibasimbukawo, paka ku lunaku owekisetukiraku. ");
INSERT INTO gwr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kale aBaisirairi omu lugendo lwabwe lwonalwona, bonabona ni babonanga ekireri kya Musengwa. Bakibonanga, nga kiri oku ngulu kwʼeWeema eyo omu biseera ebyʼomusana, kaisi omu biseera ebyʼobwire, omu kireri ekyo ni babonangamu omusyo.");
INSERT INTO gwr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","OMusengwa yayetere oMusa omu Weema eyʼoKusisinkanirangamu oMusengwa, nʼamukoba ati, ");
INSERT INTO gwr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Otumule nʼaBaisirairi ngʼobakoba oti, omuntu yenayena kwinywe oweyaleetanga ekyokuwaayo eeri nze oMusengwa nga kyayo, akireetenge ngʼakitoola mu kiraalokye ooba mu kisibokye ekyʼentaama ooba ekyʼembuli. ");
INSERT INTO gwr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Singa ekyokuwaayokye kyabbanga kyʼesadaaka egibooca yonayona okuzwa omu kiraalokye, yaawangayo onte okitobba abulaku obuleme. Yamuweerangayo ku mulyango gwʼeWeema eyʼoKusisinkanirangamu, kaisi nze oMusengwa ni ngikirirya okubba sadaaka yʼokusoniya ebibbibibbibye. ");
INSERT INTO gwr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Yateekanga engaloye oku mutwe gwʼekyayo ekyʼesadaaka egibooca yonayona, kaisi ni nkiikirirya okubba ekyʼokukolera omukolo ogwʼokumusuuca okubba omulongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Basaliranga onte oyo okitobba omumaiso gange nze oMusengwa, era awo abʼeibyaire lyʼAlooni ibo abakabona, batwalanga omusaaye ni baguswankira oku mba gyonagyona egyʼekyoto ekiri oku mulyango gwʼeWeema eyʼoKusisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Awo yabbaaganga okitobba oyo owʼesadaaka egibooca yonayona, nʼamusalamu ebitundu. ");
INSERT INTO gwr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Abʼeibyaire lyʼAlooni okabona, bakwatisyanga omusyo oku kyoto, ni bagupangaku enkwi. ");
INSERT INTO gwr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Awo abʼeibyairerye bacaananga ebifi byʼenyama, nʼomutwe, nʼamasavu oku nkwi egyo egiri kwaka oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Neye ebinamukida nʼebikokolo babinaabyanga, kaisi okabona nʼabyocerya aamo byonabyona na bidi ebiri oku kyoto. Eyo niiyo esadaaka egibooca yonayona, ikyo ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Singa ekyokuwaayokye ekyʼesadaaka egibooca yonayona, kyabbanga ntaama ooba mbuli, yatoolanga omu kisibokye ntaama omusaiza, ooba mbuli ompanya abulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Bamusaliranga mumaiso gange nze oMusengwa, oku lubba lwʼe mambuka olwʼekyoto, kaisi abʼeibyaire lyʼAlooni ibo abakabona, ni baswankira omusaaye gwʼekyayo ekyo oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Bamutemangamu ebitundu, okabona nʼacaana ebitundu ebyo aamo nʼomutwe nʼamasavu oku nkwi egiri kwaka oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Neye ebinamukida nʼebikokolo babinaabyanga, kaisi okabona nʼabireeta byonabyona nʼabyocerya oku kyoto aamo na bidi. Eyo niiyo esadaaka egibooca yonayona, ikyo ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Singa ekyokuwaayokye ekyʼesadaaka egibooca yonayona, kyabbanga nyonyi, yatoolanga mpuuwu ooba njiiwa omutomuto. ");
INSERT INTO gwr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Okabona yaleetanga onyonyi oyo oku kyoto, nʼamuniola eikoti, nʼakutulaku omutwe, nʼagwocerya oku kyoto, era omusaaye gwa nyonyi oyo nʼagusululya oku mbale kwakyo. ");
INSERT INTO gwr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Yamutoolangamu ekisakiro nʼebikirimu, nʼabidyaka oku lubba lwʼe buzwaisana wʼekyoto ekyo, e gibakumbaanirya eikoke. ");
INSERT INTO gwr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Yakwatanga ebitutu, nʼamunyiiramu, neye nandi nʼamukutulamu, kaisi nʼamwocerya oku nkwi egiri kwaka oku kyoto. Eyo niiyo esadaaka egibooca yonayona, ikyo ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, “Omuntu yenayena oweyaawangayo eeri nze oMusengwa ekyokuwaayo ekyʼempeke, ekyokuwaayokye kyabbanga kyʼobusye obwʼengaano obusa. Yabutabulangamu obwito bwʼemizaituuni, nʼabusiiramu obubbaani obusye, ");
INSERT INTO gwr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","kaisi ekyokuwaayo ekyo nʼakireetera abʼeibyaire lyʼAlooni ibo abakabona. Okabona yayoolangaku ekigalo kyʼobusye obwo obwʼengaano obusa, obubatabwiryemu obwito, aamo nʼobubbaani bwonabwona, nʼabyocerya oku kyoto ngʼakamanyiciryo akalaga kati ebyawaireyo byonabyona byange nze oMusengwa. Era nga niikyo ekyokuwaayo ekibooca ni kizwamu akaloosa akansangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ekisigairewo oku kyokuwaayo ekyʼempeke ekyo, kyabbanga kyʼAlooni nʼabʼeibyairerye. Ikyo kiwonge, olwʼokubba bakitoire ku kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Singa ekyokuwaayo kyabbanga kyʼemigaati egibasumbiire mu kisumbiro kyʼemigaati, gibbenge gibulamu okazumbulukuca, nga gyʼobusye obwʼengaano obusa, obubakandiiremu obwito, ooba kibbenge kyʼobugaati obuyeyere obubulamu okazumbulukuca, era obubasiigireku obwito. ");
INSERT INTO gwr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Era singa ekyokuwaayokyo ekyʼempeke bakisumbiranga ku fulampeni, kiri nʼokubba kyʼobusye obwʼengaano obusa, obubakandiiremu obwito era obubulamu okazumbulukuca. ");
INSERT INTO gwr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Okabona yakimulungulanga, nʼakisukaku obwito, ekyo niikyo ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Era singa yaawangayo ekyokuwaayo ekyʼempeke ekibasumbiire oku fulampeni, kiri nʼokubba kyʼobusye obwʼengaano obusa, obubakandiiremu obwito. ");
INSERT INTO gwr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Omuntu yaleetanga eeri nze oMusengwa ekyokuwaayo ekyʼempeke ekyo ekibasumbire omu busye obwo obubatabwiryemu obwito, nʼakiwa okabona, kaisi okabona nʼakitwala oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Okabona yatoolanga oku kyokuwaayo ekyʼempeke ekyo, ngʼakamanyiciryo akalaga kati ebyawaireyo byonabyona byange nze oMusengwa, nʼakyocerya oku kyoto. Era ni kibba kyokuwaayo ekibooca ni kizwamu akaloosa akansangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ekisigairewo oku kyokuwaayo ekyʼempeke ekyo, kyabbanga kyʼAlooni nʼabʼeibyairerye. Ikyo kiwonge, olwʼokubba bakitoire ku kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Nabuli kyokuwaayo ekyʼempeke ekimwaleetanga okuwaayo eeri nze oMusengwa timwakiteekangamu okazumbulukuca. Ekyo kityo olwʼokubba timili nʼokwoceryanga okazumbulukuca waire omujenene, omu kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Ebyokuwaayo ebyo muyinza okubireeta ngʼebyokuwaayo ebyʼamakungula ameekeereri eeri nze oMusengwa, neye ibyo timwabyoceryanga oku kyoto okuzwamu akaloosa akansangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Ebyokuwaayo byonabyona ebyʼempeke, mwabiteekangamu ocumbi. Timwaganyanga ocumbi okubula omu byokuwaayo byanywe ebyʼempeke, olwʼokubba niiye ali nʼokubeebukirisyanga endagaano aakati waanywe nanze oKibbumbawo waanywe. Kale ebyokuwaayo byonabyona mwabiteekangamu ocumbi. ");
INSERT INTO gwr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Owemwawangayo eeri nze oMusengwa ekyokuwaayo ekyʼempeke ekyʼamakungula ameekeereri, mwawangayo makungula ameekeereri egebankukungula amakone, era nga bagasiikireku kaisi ni basya. ");
INSERT INTO gwr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Mwabutabulyangamu obwito era ni mubusiiramu obubbaani ekyo nga niikyo ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Okabona yayocanga ekiyayoolangaku oku busye obwo obubasyeire oku gimo oku mpeke egibakonere, aamo nʼobumo oku bwito, nʼobubbaani bwonabwona nʼabyoca okubba ngʼakamanyiciryo akalaga kati ebyawaireyo byonabyona byange nze oMusengwa. Era Ikyo kiwonge, olwʼokubba bakitoire ku kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, “Singa omuntu ekyokuwaayokye kyabbanga kyʼesadaaka eyʼokusyania, nʼawaayo onte onumi ooba ompaki ngʼatoola omu kiraalokye, yampanga Nze oMusengwa nte abulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yateekanga engaloye oku mutwe gwʼekyayo ekyʼesadaakaye, ni bakisalira oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu Nze oMusengwa. Awo abʼeibyaire lyʼAlooni ibo abakabona batwalanga omusaaye ni baguswankira oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Era omuntu oyo yaawangayo ebitundu binu oku sadaaka eyo eyʼokusyania egibooca nga bagiwaayo eeri nze oMusengwa: Amasavu agabiika oku binamukida nʼamasavu agali oku byenda, ");
INSERT INTO gwr_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","nʼempigo gyombi nʼamasavu agagiriku okulirana akakunku, nʼendimi gyʼamani nʼagitooleraku aamo nʼempigo. ");
INSERT INTO gwr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Awo abʼeibyaire lyʼAlooni babyoceryanga oku kyoto, aamo nʼesadaaka egibooca yonayona eri oku nkwi egiri kwaka, nʼebba kyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Singa omuntu yaawangayo eeri nze oMusengwa esadaaka eyʼokusyania, yatoolanga mu kisibokye ekyayo ekisaiza ooba ekikali, ekibulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Singa awaayo mwana wa ntaama, yamuweerangayo mumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Yateekanga engaloye oku mutwe gwʼekyokuwaayokye ekyo, ni bakisalira omumaiso gʼeWeema eyʼoKunsisinkanirangamu. Awo abʼeibyaire lyʼAlooni baswankiranga omusaaye gwakyo oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Era oku sadaaka eyʼokusyania yaawangayo ebitundu binu ngʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa: Amasavu, nʼomukira gwonagwona ogubatiiciirye okumpi nʼomugongo, nʼamasavu agabiika oku binamukida nʼamasavu agali oku byenda, ");
INSERT INTO gwr_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","nʼempigo gyombi nʼamasavu gonagona agagiriku okulirana akakunku, nʼendimi gyʼamani nʼagitooleraku aamo nʼempigo. ");
INSERT INTO gwr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Okabona yabyoceryanga oku kyoto ngʼekyokulya, ikyo ekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Singa ekyokuwaayokye yaabbanga mbuli, yakiweerangayo mumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Yateekanga engaloye oku mutwe gwa mbuli oyo, ni bamusalira omumaiso gʼeWeema eyʼoKunsisinkanirangamu. Awo abʼeibyaire lyʼAlooni baswankiranga omusaaye gwayo oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Era oku kyokuwaayokye ekyo yaawangayo ebitundu binu ngʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa: Amasavu agabiika oku binamukida nʼamasavu agali oku byenda, ");
INSERT INTO gwr_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","nʼempigo gyombi nʼamasavu agagiriku okulirana akakunku, era nʼendimi gyʼamani nʼagitooleraku aamo nʼempigo. ");
INSERT INTO gwr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Okabona yabyoceryanga oku kyoto ngʼekyokulya, ikyo ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya nze oMusengwa. Era amasavu gonagona gaabbanga gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Timwalyanga amasavu waire omusaaye. Eryo lyabbanga iteeka eryʼenkalaakalira, erimwakuumanga nabuli e gimwabbanga nʼobutyami, emirembe nʼemirembe.” ");
INSERT INTO gwr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","okukoba aBaisirairi ati, “Nabuli eyakolanga ekikole ekibbikibbi nga tagendereire, nʼakola ekintu kyonakyona kwebyo nze oMusengwa ebinalagiire okutabikolanga, ekikoba kiti:” ");
INSERT INTO gwr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Singa okabona omukulu yakolanga ekikole ekibbikibbi, nʼaleeta oku bantu omusango, yaawangayo eeri nze oMusengwa, onte okitobba abulaku obuleme ngʼesadaaka eyʼokusoniya ekibbikibbi ekyakolere. ");
INSERT INTO gwr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Yaleetanga onte oyo oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa, nʼateeka engaloye oku mutwe gwa nte oyo, ni bamusalira omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Awo okabona omukulu yatoolanga oku musaaye gwa nte oyo okitobba, nʼaguleeta omu Weema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Yatimyanga olunwerwe omu musaaye ogwo, era nʼaswankira omusaaye ogwo emirundi musanvu e nza wʼolutimbe omu Weema ya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Era yatoolanga oku musaaye ogwo, nʼagusiiga oku maziga gʼekyoto ekibooceryaku obubbaani obwʼakaloosa, ekiri omumaiso gange nze oMusengwa omu Weema eyʼoKunsisinkanirangamu. Omusaaye ogusigairewo ogwa nte oyo yagusukanga ansi wʼekyoto ekibaweeraku esadaaka egibooca yonayona, ekiri oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Yatoolangamu amasavu gonagona omu kitobba oyo owʼesadaaka eyʼokusoniya ekibbikibbi, nga niigo amasavu agabiika oku binamukida nʼamasavu agali oku byenda, ");
INSERT INTO gwr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","nʼempigo gyombi nʼamasavu agagiriku okulirana akakunku, nʼendimi gyʼamani nʼagitooleraku aamo nʼempigo, ");
INSERT INTO gwr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ngʼowebabitoola omu nte owʼesadaaka eyʼokusyania. Awo kaisi nʼabyocerya oku kyoto ekibooceryaku esadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Neye eidiba lya kitobba oyo, nʼenyama yonayona, nʼomutwe gwaku, nʼebikokolo aamo nʼebinamukida nga mulimu nʼebyenda, ");
INSERT INTO gwr_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ekikoba kiti, ebitundu bya nte oyo byonabyona ebisigairewo yabitwalanga e nza wʼenkambi, omu kifo ekirongoole omumaiso gange nze Musengwa, e gibasuka eikoke lidi erizwa oku kyoto, era nʼabyocerya byonabyona eeyo oku kibbiiryo kyʼeikoke eryo oku musyo gwʼenkwi. ");
INSERT INTO gwr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Singa aBaisirairi bonabona bakolanga ekibbikibbi nga tibagendereire ni bakola ekimo kwebyo nze oMusengwa ebinalagiire omu mateeka gange okutabikolanga, newankubbaire nga ibo aBaisirairi tibakitegeire bati bakolere ekibbikibbi, baabbanga babbengere. ");
INSERT INTO gwr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Owebeetegeeranga bati bakolere ekikole ekibbikibbi, abantu abo baleetanga onte okitobba ngʼesadaaka eyʼokusoniya ekibbikibbi, era ni bamuweerayo omumaiso gʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Abeekubbemberi bʼabantu abo bonabona bateekanga engalo gyabwe oku mutwe gwa kitobba oyo, nga bali omumaiso gange nze oMusengwa, era ni bamusalira aawo omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Awo okabona omukulu yatwalangaku omusaaye gwa nte oyo omu Weema eyʼoKunsisinkanirangamu, ");
INSERT INTO gwr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","nʼainika olunwerwe omu musaaye ogwo, nʼaswankira omusaaye ogwo emirundi musanvu omunda wʼolutimbe olwawula eKifo eKitukulye nʼeKifo eKitukulye eIno. ");
INSERT INTO gwr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Yatoolanga oku musaaye ogwo nʼagusiiga oku maziga gʼekyoto omumaiso gange nze oMusengwa omu Weema eyʼoKunsisinkanirangamu. Omusaaye ogusigairewo ogwa kitobba oyo yagusukanga ansi wʼekyoto ekibaweeraku esadaaka egibooca yonayona, ekiri oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Yatoolangamu amasavu gonagona omu kitobba oyo, nʼagoocerya oku kyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Era oku kitobba oyo, yakolanga ngʼowaakola oku kitobba odi ogubawaayo olwʼokusoniya ekikole ekibbikibbi. Omu ngeri eyo okabona yaabbanga akolere omukolo gwʼokusuuca abantu okubba abalongoole omumaiso gange, era ni mbasoniya. ");
INSERT INTO gwr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Awo okabona yatwalanga ebisigairewo oku nte oyo e nza wʼenkambi, nʼabyoca ngʼowaayocerye onte odi asookere. Eyo niiyo esadaaka eyʼokusoniya ekibbikibbi kyʼabantu. ");
INSERT INTO gwr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Singa omufugi yakolanga ekikole ekibbikibbi nga tagendereire nʼakola ekimo kwebyo nze oMusengwa iye oKibbumbawe ebinalagiire omu mateeka okutabikolanga, yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Owebamumanyikisyanga ekikole ekibbikibbi ekyakolere, yaleetanga esadaakaye eyo eya mbuli ompanya abulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Yateekanga engaloye oku mutwe gwa mbuli oyo, ni bamusalira omu kifo e gibasalira esadaaka egibooca yonayona omumaiso gange nze oMusengwa. Eyo niiyo esadaaka eyʼokusoniya ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Awo okabona yatimyanga olunwerwe omu musaaye gwʼesadaaka eyʼokusoniya ekibbikibbi nʼagusiiga oku maziga gʼekyoto ekibaweeraku esadaaka egibooca yonayona, kaisi omusaaye ogusigairewo nʼagusuka ansi wʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Amasavu gonagona yagooceryanga oku kyoto, ngʼowaayoca amasavu gʼesadaaka eyʼokusyania. Omu ngeri eyo, okabona yaabbanga akolere omukolo gwʼokusuuca omufugi oyo okubba omulongoole era ni mmusoniya. ");
INSERT INTO gwr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Singa omoiza oku bantu ba bulijo yakolanga ekikole ekibbikibbi nga tagendereire, nʼakola ekimo kwebyo nze oMusengwa ebinalagiire omu mateeka gange okutabikolanga, yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Owebamumanyikisyanga ekikole ekibbikibbi ekyakolere, yaleetanga esadaakaye eyʼokusoniya ekikolekye ekibbikibbi mbuli onduusi abulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Yateekanga engaloye oku mutwe gwa mbuli oyo owʼesadaaka eyʼokusoniya ekibbikibbi, ni bamusalira omu kifo e gibasalira esadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Awo okabona yatimyanga olunwerwe omu musaaye gwa mbuli oyo nʼagusiiga oku maziga gʼekyoto ekibaweeraku esadaaka egibooca yonayona, kaisi omusaaye ogusigairewo nʼagusuka ansi wʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Yatoolangamu amasavu gonagona ngʼowebagatoola omu sadaaka eyʼokusyania, era okabona nʼagoocerya oku kyoto ekyo, ni gazwamu oluvululu olunsangaalya nze oMusengwa. Omu ngeri eyo, okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba omulongoole, era ni mmusoniya. ");
INSERT INTO gwr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Singa omuntu oyo yaleetanga ntaama nga niiyo esadaakaye eyʼokusoniya ekikolekye ekibbikibbi, yaleetanga nduusi abulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Yateekanga engaloye oku mutwe gwa ntaama oyo owʼesadaaka eyʼokusoniya ekikolekye ekibbikibbi, ni bamusalira omu kifo e gibasalira esadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Awo okabona yatimyanga olunwerwe omu musaaye gwʼesadaaka eyʼokusoniya ekikolekye ekibbikibbi nʼagusiiga oku maziga gʼekyoto ekibaweeraku esadaaka egibooca yonayona, kaisi omusaaye ogusigairewo nʼagusuka ansi wʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Yatoolangamu amasavu gonagona ngʼowebagatoola omu ntaama wʼesadaaka eyʼokusyania, okabona nʼagoocerya oku kyoto aamo nʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. Omu ngeri eyo, okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba mulongoole okumutoola omu kikolekye ekibbikibbi, era ni mmusoniya.” ");
INSERT INTO gwr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","OMusengwa ni yeeyongera ati, “Singa omuntu bamwetanga okuwa obujulizi omu kooti nandi nʼatumula kwʼekyo ekiyaboine ooba ekyamaite, yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Nʼekindi, singa omuntu yakwatanga oku kintu kyonakyona ekitali kirongoole, ekikoba kiti, okisolo wʼomu kigona atali mulongoole, era omufu ooba ebibbumbe ebyekuusira okwitakali ebitali birongoole ebifiire waire ngʼabikwaiteku mubutagenderera, yaabbanga asuukire atali mulongoole era yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Nʼekindi, singa omuntu yakwatanga oku kintu kyonakyona ekitali kirongoole, ekikoba kiti, ekizwire e giri omuntu nga tikirongoole, ni kimusuuca okubba atali mulongoole omumaiso ga Musengwa waire nga takitegeire, singa omuntu oyo yakitegeeranga, yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Era singa omuntu yaluuyanga okulayira okukola ekintu kyonakyona, waire kisa ooba kibbikibbi ngʼamalire galayira nga tafiireyo, waire nga takitegeire, omu ngeri yonayona singa yakitegeeranga, yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Omuntu oweyabbenganga omu kintu kyonakyona kwʼebyo, yabbutulanga mulwatu ekibbikibbi ekyakolere. ");
INSERT INTO gwr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Omugaito ogwʼeibbengo eryo, yaleetanga eeri nze oMusengwa ntaama omukali ooba mbuli onduusi ngʼamutoola mu kisibokye, ngʼeyo niiyo esadaaka eyʼokusoniya ekikole ekibbikibbi. Era okabona yaawangayo esadaaka eyo, okukola omukolo gwʼokusuuca omuntu oyo okubba omulongoole okumutoola omu kibbikibbikye. ");
INSERT INTO gwr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Neye singa omuntu yaabbanga mudoobi nga tayezya okusuna ontaama omutomuto, yaleetanga eeri nze oMusengwa empuuwu ibiri ooba enjiiwa entonto ibiri, ngʼomugaito gwʼeibbengolye, ngʼonjiiwa omoiza wʼesadaaka yʼokusoniya ekikolekye ekibbikibbi, nʼogondi wʼesadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Yagireetanga eeri okabona, kaisi okabona nʼasooka kuwaayo yoodi owʼesadaaka eyʼokusoniya ekibbikibbi. Nʼamuniola eikoti, neye nandi nʼakutuliraku nakimo omutwe. ");
INSERT INTO gwr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Nʼaswankira ogumo oku musaaye ogwʼesadaaka eyo eyʼokusoniya ekibbikibbi oku mbale kwʼekyoto, ogusigairewo nʼagusululya ansi wʼekyoto. Eyo niiyo esadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Awo okabona yaawangayo onjiiwa odi ogondi, ngʼesadaaka egibooca yonayona, ngʼebiragiro owebiri. Omu ngeri eyo okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba omulongoole okumutoola omu kibbikibbi ekyakolere, era omuntu oyo ni mmusoniya. ");
INSERT INTO gwr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Neye singa omuntu yaabbanga mudoobi nga tayezya okuleeta empuuwu eibiri ooba enjiiwa eibiri, yaleetanga esadaaka eyʼokusoniya ekikolekye ekibbikibbi ekiro ooti moiza eyʼobusye obwʼengaano obusa, ni bubba sadaaka eyʼokusoniya ekikole ekibbikibbi. Tiyabutabulyengemu obwito ebwʼemizaituuni waire obubbaani, olwʼokubba eyo sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Yabuleetanga eeri okabona, era okabona yabuyoolangaku ekigalo, ngʼakamanyiciryo akalaga kati ebyawaireyo byonabyona byange nze oMusengwa, nʼabyocerya oku kyoto aamo nʼebyokuwaayo ebibooca nga babiwaayo eeri nze oMusengwa. Eyo niiyo esadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Omu ngeri eyo okabona yakolanga omukolo gwʼokusuuca omuntu oyo okubba omulongoole okumutoola omu kibbikibbi kyonakyona ekyabba akolere, ni mmusoniya. Obusye obusigairewo oku sadaaka eyo bwabbanga bwa kabona, ngʼowekiri oku kyokuwaayo ekyʼempeke.” ");
INSERT INTO gwr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Singa omuntu yenayena yabbenganga omu butagenderera, olwʼokutampa nze oMusengwa ebyavunaanyizibwa okumpa, yandeeteranga omugaito ogwa ntaama omusaiza abulaku obuleme ngʼatoola oku ntaamagye. Era ebbeeyi ya ntaama oyo bagibaliriranga mu sekeri gyʼefeeza okusinzirira ku mbalirira entongole eyʼomu Weema yange nze oMusengwa. Eyo nga niiyo esadaaka eyʼokusoniya eibbengo. ");
INSERT INTO gwr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Era yaabbanga nʼokusasula omugaito olwʼekyo ekyabbengere oku bintu ebyo ebyavunaanyizibwa okumpa nze oMusengwa, era yayongerangaku ekitundu kimo kyokutaanu oku mugaito ogwo, nʼabiwa okabona, okabona nʼakola omukolo gwʼokusuuca omuntu oyo okubba omulongoole ngʼawaayo ontaama omusaiza ngʼesadaaka eyʼokusoniya eibbengo, era omuntu oyo ni mmusoniya. ");
INSERT INTO gwr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Singa omuntu yakolanga ekibbikibbi, nʼakola ekintu kyonakyona kwebyo nze oMusengwa ebinalagiire omu mateeka okutabikolanga waire ngʼakolere mu butagenderera, yaabbanga abbengere, era bamuvunaananga. ");
INSERT INTO gwr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yaabbanga nʼokuleeta eeri okabona ontaama omusaiza abulaku obuleme, ogwatoire mu kisibokye era nga wʼebbeeyi etuukana ngʼesadaaka eyʼokusoniya eibbengo. Omu ngeri eyo okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba omulongoole omumaiso gange nze oMusengwa okumutoola omu kikolekye ekibbikibbi nga mu butagenderera, era omuntu oyo ni mmusoniya. ");
INSERT INTO gwr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Eyo niiyo esadaaka eyʼokusoniya eibbengo, olwʼokubba omuntu oyo abba abbengere omumaiso gange.” ");
INSERT INTO gwr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Singa omuntu yenayena yakolanga ekibbikibbi, nandi nʼabba mwesigwa eeri nze oMusengwa olwʼokubbeya omwinaye oku kintu ekiyaabbanga amubisisirye, ooba ekiyaabbanga amukwatisirye ngʼomusingo, ooba nʼamwibbaku ekintu ooba singa yafugiriryanga oku mwinaye ekintu, ");
INSERT INTO gwr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ooba singa omuntu yazuuliranga e wʼomuntu oyo ekyabbanga kimugotereku, neye omuntu oyo nʼabbeyesya era nʼalayira nʼebikwata oku kintu ekyo, era nʼakola ekikole ekibbikibbi kyonakyona ekiri ooti kiikyo, abantu ekibayinza okukola, ");
INSERT INTO gwr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","era singa yaabbanga akolere ekikole ekibbikibbi kaisi nʼamanyica ngʼabbengere era nʼairyawo ebiyaabbanga aibbire ooba ebiyaabbanga afugiriirye oku mwinaye ooba ekibaabbanga bamubisisirye ooba ekiyaabbanga alondere, ");
INSERT INTO gwr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ooba ekintu kyonakyona ekiyalayiriireku ebyobubbeyi, yakiiryangawo kyonakyona era nʼayongeraku ekitundu kimo kyokutaanu kyʼebyo ebyali kwiryawo. Era yabikanjiryanga onanyerebyo oku lunaku oluyamanyiciryangaku ati abbengere. ");
INSERT INTO gwr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Yaleetanga eeri okabona ontaama omusaiza abulaku obuleme ogwatoire mu kisibokye ngʼomugaito olwʼekibbikibbikye nʼamuwaayo eeri nze oMusengwa. Era ontaama oyo yaabbanga nʼokubba atuukana nʼobungi bwʼempiiya egyaba omu sadaaka eyʼokusoniya eibbengo. ");
INSERT INTO gwr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Omu ngeri eyo okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba omulongoole omumaiso gange, era omuntu oyo ni mmusoniya omu kintu kyonakyona ekiyaabbanga abbengere.” ");
INSERT INTO gwr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","OMusengwa ni yeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Owe Alooni nʼabʼeibyairerye amateeka ganu agakwata oku sadaaka egibooca yonayona. Esadaaka egibooca yonayona, bagyoceryanga oku kyoto obwire bwonabwona paka makeezi, era omusyo gwasigalanga nga gwaka oku kyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Awo okabona yazwalanga ekizwalokye ekya lineni, nʼazwaliramu nʼepajama yona eya lineni, nʼayoola eikoke eryʼoku kyoto eryʼesadaaka egibooca yonayona, nʼaliteeka oku mbale kwʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Awo yeeyambulyangamu ebizwalo ebyo nʼazwala ebindi, nʼatwala eikoke e nza wʼenkambi, omu kifo ekirongoole omumaiso gange nze Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Omusyo oguli oku kyoto ekyo guli nʼokusigalanga nga gwaka, anambula kulikira naire. Nabuli makeezi okabona yateekangaku enkwi, nʼateeka oku musyo esadaaka egibooca yonayona, era nʼayoceryaku amasavu agʼesadaaka eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Omusyo guli nʼokusigalanga nga gwaka bulijo oku kyoto ekyo, anambula kulikira naire.” ");
INSERT INTO gwr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","OMusengwa ni yeeyongera tete okukoba oMusa ati, “Ganu niigo amateeka agakwata oku kyokuwaayo ekyʼempeke: Abʼeibyaire lyʼAlooni bakiwangayo eeri nze oMusengwa omumaiso gʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Okabona yayoolanga ekigalo kyʼobusye obwʼengaano obusa, nʼatabulyamu obwito obwʼemizaituuni, aamo nʼobubbaani bwonabwona obuli oku kyokuwaayo ekyʼempeke, era nʼabyocerya oku kyoto ngʼakamanyiciryo akalaga kati ebyawaireyo byonabyona byange nze oMusengwa, ni kizwamu akaloosa akansangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Alooni nʼabʼeibyairerye balyanga ekyokuwaayo ekyo ekisigaireku nga mpaamu okazumbulukuca, era baabbanga nʼokukiriira mu kifo ekitukulye omu luuga lwʼeWeema eyʼoKunsisinkanirangamu nze oMusegwa. ");
INSERT INTO gwr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Tibakisumbirangamu okazumbulukuca; Nze oMusengwa nkiwaire bakabona, ngʼomugabo ogwabwe, oku byokuwaayo ebibooca nga babiwaayo eeri nze. Era ngʼesadaaka eyʼokusoniya ekikole ekibbikibbi, nʼesadaaka eyʼokusoniya eibbengo, era gyabbanga ntukulye ino. ");
INSERT INTO gwr_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Omu mirembe gyonagyona egyairangawo, omusaiza yenayena oku bʼolulyo lwʼAlooni yayinzanga okukiryaku. Era ikyo mugabo gwabwe ogwʼenkalaakalira, oku byokuwaayo ebibooca nga babiwaayo eeri nze oMusengwa. Nabuli ekyakyeguunyangaku, kyabbanga kitukulye.” ");
INSERT INTO gwr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","OMusengwa tete nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Kinu niikyo ekyokuwaayo Alooni nʼabʼeibyairerye nabuli moiza ekiyaabbanga nʼokuwaayo eeri nze oMusengwa, oku lunaku olubamusukiraku amafuta okumwawula. Yaabbanga nʼokuwaayo ekiro ooti moiza eyʼobusye obwʼengaano obusa, nga kyokuwaayo ekya buli lunaku, ekitundu kyabwo amakeezi, nʼekitundu ekindi eigulo. ");
INSERT INTO gwr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Yabukandirangamu obwito, nʼasumbira obugaati oku fulampeni, nʼabumulungula nʼabuwaayo ngʼekyokuwaayo ekyʼempeke era ni bakyoca ni kizwamu akaloosa akansangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Okabona ogubaabbanga basukireku amafuta okusikira Alooni, niiye eyakiwangayo eeri nze oMusengwa ngʼeiteeka oweriragira emirembe gyonagyona. Era yakyocanga kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Nabuli kyokuwaayo ekyʼempeke okabona ekiyaawangayo, bakyocanga kyonakyona; tibakiryengeku.” ");
INSERT INTO gwr_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","OMusengwa tete nʼakoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","akobe Alooni nʼabataane ati, “Ganu niigo amateeka agalungamya oku sadaaka eyʼokusoniya ekikole ekibbikibbi. Esadaaka eyo bali nʼokugisaliranga mumaiso gange nze oMusengwa omu kifo e gibasarira esadaaka egibooca yonayona. Esadaaka eyo ntukulye ino. ");
INSERT INTO gwr_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Okabona eyagiwangayo, niiye eyagiryangaku era yagiriiranga mu kifo ekitukulye, omu luuga lwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Nabuli ekyeguunyanga oku sadaaka eyo, kyabbanga kirongoole. Era singa waabbangakuuwo omusaaye gwaku ogusambukiire oku kizwalo, yakyozeranga mu kifo ekitukulye. ");
INSERT INTO gwr_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ensaka eyʼeitakali egibasuumbiiremu enyama yaakyo, bagyatanga. Neye owebagisuumbiranga mu nsaka ya bbulonzi, ensaka eyo bagikuutanga ni bagigajambulyamu nʼamaizi. ");
INSERT INTO gwr_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Omusaiza yenayena owʼomu lulyo lwʼAlooni, wʼeidembe okugiryaku. Iyo ntukulye ino. ");
INSERT INTO gwr_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Neye singa omusaaye gwʼesadaaka yonayona eyʼokusoniya ekikole ekibbikibbi, baguleetanga omu Weema eyʼoKunsisinkanirangamu olwʼokukola omukolo ogwʼokusuuca omuntu okubba omulongoole, esadaaka eyo tibagiryangaku; bagyocanga-bwoci.” ");
INSERT INTO gwr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Awo oMusengwa tete nʼakoba oMusa ati, “Ganu niigo amateeka agakwata oku sadaaka eyʼokusoniya eibbengo, iyo entukulye eino. ");
INSERT INTO gwr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Esadaaka eyʼokusoniya eibbengo, bagisaliranga mu kifo e gibasalira esadaaka egibooca yonayona, era omusaaye gwayo baguswankiranga oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Amasavu gaayo gonagona bagawangayo. Omukira ogwʼamasavu, nʼamasavu agʼoku byenda, ");
INSERT INTO gwr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nʼempigo gyombi nʼamasavu agagiriku okulirana akakunku, nʼendimi gyʼamani, ebyo baabbanga nʼokubitoolamu aamo nʼempigo. ");
INSERT INTO gwr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Okabona yabyoceryanga oku kyoto, ngʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. Eyo niiyo esadaaka eyʼokusoniya eibbengo. ");
INSERT INTO gwr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Omusaiza yenayena owʼomu lulyo lwʼabakabona, wʼeidembe okugiryaku, neye ngʼagiriira mu kifo ekitukulye omu luuga lwʼeWeema yange nze Musengwa; esadaaka eyo ntukulye ino. ");
INSERT INTO gwr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Eiteeka limo linanyere eryo erikola oku sadaaka eyʼokusoniya ekikole ekibbikibbi nʼesadaaka eyʼokusoniya eibbengo. Enyama eyasigalangaku oku sadaaka egyo yaabbanga ya kabona eyaabbanga akolere omukolo ogwʼokusuuca omuntu oyo okubba omulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Okabona eyaawangayo esadaaka egibooca yonayona eyʼomuntu yenayena, niiye eyatwalanga eidiba lyʼesadaaka eyo. ");
INSERT INTO gwr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nabuli kyokuwaayo ekyʼempeke, ekibasumbiire omu kisumbiro kyʼemigaati, ooba ekibasumbiire oku fulampeni, ooba omu kakalaayi, kya kabona akiwaayo. ");
INSERT INTO gwr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Era nabuli kyokuwaayo ekyʼempeke nga bakitabwiryemu obwito ooba kibulamu obwito, kyabbanga kyʼabʼeibyairye lyʼAlooni, era bakigabananga mu bwenkanya.” ");
INSERT INTO gwr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","OMusengwa ni yeeyongera okukoba oMusa ati, “Ganu niigo amateeka agakwata oku sadaaka eyʼokusyania, omuntu egiyaawangayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Singa omuntu yaawangayo lwʼokwebalya, yakiweerangaku nʼekyokuwaayo ekyʼemigaati egibulamu okazumbulukuca egibakandiiremu obwito, nʼobugaati obuyeyere obubulamu okazumbulukuca era obubasiigireku obwito, nʼemigaati egibasumbire omu busye obwʼengaano obusa, obubakandiiremu obwito. ");
INSERT INTO gwr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Oku sadaakaye eyʼokusyania olwʼokwebalya, yaleeterangaku emigaati egirimu okazumbulukuca. ");
INSERT INTO gwr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ku buli kika kyʼemigaati egyo yatoolangaku omugaati gumo nʼaguwaayo ngʼekyokuwaayo eeri nze oMusengwa. Emigaati egyo gwabanga mugabo gwa kabona eyaswankiranga omusaaye gwʼesadaaka eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Enyama yʼesadaakaye eyʼokusyania eyo, bagiryanga ku lunaku lunanyere olwo olubaweereireku esadaaka eyo, tiwaabbangawo egonawo. ");
INSERT INTO gwr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Neye singa omuntu yaawangayo ekyokuwaayo olwʼokutuukirirya bweyamo, ooba nga kyokuwaayo omu kwetakira, enyama bagiryanga ku lunaku olwo olwakiweereireyo, neye eyasigalangawo bayinzanga okugirya izo waaku. ");
INSERT INTO gwr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Neye iyo esigalawo paka ku lunaku lwokusatu, baabbanga nʼokugyoca nʼesiriira. ");
INSERT INTO gwr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Singa enyama yʼesadaaka eyʼokusyania eyʼomuntu oyo bagiryanga ku lunaku lwokusatu, esadaaka eyo nze oMusengwa tinagiikiriryenge, tiyagasenge nʼoyo agiwaireyo olwʼokubba tindongoole, era nabuli eyagiryangaku, obubbibubbi bwamubbangaku. ");
INSERT INTO gwr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Enyama eyeegunyanga oku kintu ekitali kirongoole, tibagiryenge, bagyocanga-bwoci. Wazira enyama yʼesadaaka eyo eyaabbanga tiyeeguunyire oku kintu ekyo, omuntu yenayena omulongoole, iye yaabbanga wʼeidembe okugiryaku. ");
INSERT INTO gwr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Neye singa omuntu atali mulongoole yaalyangaku enyama yʼesadaaka eyʼokusyania egibampaire eeri nze oMusengwa, omuntu oyo tinamubalenge okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Era singa omuntu yenayena yakwatanga oku kintu ekitali kirongoole, ekikoba kiti, nga kizwire mu muntu ooba ku kisolo ekitali kirongoole, ooba ku kintu ekindi kyonakyona ekitali kirongoole, kaisi nʼalyaku enyama eyʼesadaaka eyo egibampaire nze oMusengwa, omuntu oyo tinamubalenge okubba moiza oku bantu bange.” ");
INSERT INTO gwr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","OMusengwa ni yeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","akobe aBaisirairi ati, “Timwalyanga amasavu ga nte ooba aga ntaama, waire aga mbuli. ");
INSERT INTO gwr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Amasavu ga kisolo afeereireku omutwe, nʼamasavu gʼoyo iye okisolo wʼomu kigona ogwaitire, igo muyinza okugakolesyanga olwʼemigaso egindi, neye timwagalyanga. ");
INSERT INTO gwr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Nabuli eyalyanga amasavu gʼekyayo kyʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa, tinamubalenge okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Era awantu wonawona e gimwabbanga nʼobutyami, timwalyanga omusaaye, aabba gwa nyonyi waire gwa kisolo. ");
INSERT INTO gwr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Singa omuntu yenayena yaalyanga omusaaye, tinamubalenge okubba moiza oku bantu bange.” ");
INSERT INTO gwr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","akobe aBaisirairi ati, “Omuntu yenayena eyaleetanga esadaaka eyʼokusyania eeri nze oMusengwa, yaabbanga nʼokutoola ku sadaakaye eyo egyawaireyo eeri nze, ");
INSERT INTO gwr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","iye onanyere yagireetanga, nʼebba kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. Yaawangayo amasavu nʼobbanda, era obbanda oyo bamusiiryanga ni bamwica omumaiso gange okubba esadaaka eyʼenjabulo egibasiirya ni baica. ");
INSERT INTO gwr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Okabona yayoceryanga amasavu oku kyoto, neye obbanda yaabbanga wʼAlooni nʼabʼeibyairerye. ");
INSERT INTO gwr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Ekisambi kyʼoku ndiiro mwakiwanga kabona, nga niigwo omugabogwe oguzwire oku sadaaka eyʼokusyania eya muntu. ");
INSERT INTO gwr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Oku bʼeibyaire lyʼAlooni eyaawangayo omusaaye nʼamasavu gʼesadaaka, oyo niiye eyasunanga ekisambi kyʼoku ndiiro ngʼomugabogwe. ");
INSERT INTO gwr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Oku sadaaka eyʼokusyania eyʼaBaisirairi, mbatoireku obbanda ogubasiirya ni baica, ni mbatoolaku nʼekisambi, ni mbiwa Alooni okabona nʼabʼeibyairye nga niigwo ogwabbanga omugabo gwabwe ogwazwanga omu Baisirairi emirembe gyonagyona. ");
INSERT INTO gwr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Ogwo niigwo omugabo oguzwa oku byokuwaayo ebibooca nga bakiwaayo eeri nze oMusengwa, ogubawaire Alooni nʼabataane oku lunaku olubabasukiireku amafuta, ni babaawula okumpeereryanga omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Oku lunaku olubabasukiireku amafuta, nalagiire aBaisirairi okubawanga ebyo okubba mugabo gwabwe ogwenkalaakalira emirembe gyonagyona.” ");
INSERT INTO gwr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ago niigo amateeka gʼesadaaka egibooca yonayona, nʼekibawaayo ekyʼempeke, nʼesadaaka eyʼokusoniya ekikole ekibbikibbi, nʼesadaaka eyʼokusoniya eibbengo, nʼesadaaka eyʼokusyania nʼekyokuwaayo ekyʼokwawula. ");
INSERT INTO gwr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Oku lusozi oSinaayi omwidungu, oMusengwa giyaweereire oMusa amateeka ago, oku lunaku oluyalagiire aBaisirairi okuwaayo ebyokuwaayo byabwe eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ondetere Alooni nʼabataane, nʼebizwalo byabwe, nʼamafuta agebakolesya omu kwawula, nʼonte okitobba owʼesadaaka eyʼokusoniya ekikole ekibbikibbi, nʼentaama ensaiza ibiri, nʼekiibo ekirimu emigaati egibulamu okazumbulukuca, ");
INSERT INTO gwr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","kaisi okumbaanie abantu bonabona oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","OMusa nʼakola ngʼoMusengwa oweyamulagiire. Abantu abo ni kikumbaanira oku mulyango gwʼeWeema eyʼoKusisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","OMusa nʼabakoba ati, “Ekyo niikyo oMusengwa ekyalagiire okukola.” ");
INSERT INTO gwr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Awo oMusa nʼakoba Alooni nʼabataane okwiza omumaiso, kaisi nʼakola omukolo ogwʼokubanaabya nʼamaizi. ");
INSERT INTO gwr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Nʼazwalisya Alooni ebbeketera, nʼamusiba omusibiro omu nkende, nʼamuzwalisya eitaawo lyʼobwakabona, nʼamusiba nʼamukalangula nʼomusibiro ogwʼokwitaawo ogubakolere nʼobukugu. ");
INSERT INTO gwr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Nʼamuzwalisya ekizwalo kyʼomu kifubba, era nʼateeka ebintu ebibeeta oWulimu nʼebindi ebibeeta oTumimu omu kizwalo ekyʼomu kifubba. ");
INSERT INTO gwr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Awo nʼamusiba oku mutwe ekitambaala ekyʼobwakabona, era omumaiso oku kizwalo ekyo nʼamuteekaku amajolobero agʼezaabbu, nʼakapande akʼobuwonge eeri oKibbumba, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Awo oMusa nʼakwata amafuta agebakolesya omu kwawula, nʼagaswankira oku Weema eyʼoKusisinkanirangamu oMusengwa, nʼoku bintu byonabyona ebirimu, era omu ngeri eyo nʼabiwonga eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Nʼaswankira agamo oku kyoto emirundi musanvu, nʼawonga ekyoto nʼebintu byaku byonabyona, nʼekalaayi nʼekikondo okwetyama; ebyo byonabyona ni bibba biwonge. ");
INSERT INTO gwr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Nʼasuka agamo oku mafuta ago oku mutwe gwʼAlooni, nʼamwawula era nʼamuwonga. ");
INSERT INTO gwr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Awo oMusa nʼaira oku bataane bʼAlooni, nabuli moiza nʼamuzwalisya ebbeketera, nʼamusiba nʼomusibiro omu nkende, era nʼamusiba nʼekitambaala oku mutwe ekyʼobwakabona, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Awo oMusa nʼaigererya onte okitobba owʼesadaaka eyʼokusoniya ekikole ekibbikibbi, Alooni nʼabataane ni bateeka engalo gyabwe oku mutwe gwa nte oyo. ");
INSERT INTO gwr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","OMusa nʼamusala, nʼatoola oku musaaye ogwo, nʼagusiiga oku maziga gʼekyoto oku mba gyakyo gyonagyona ngʼakolesya olunwerwe okukola omukolo gwʼokukisuuca okubba kirongoole. Omusaaye ogusigairewo, nʼagusuka ansi wʼekyoto. Omu ngeri eyo nʼabba akiwongere era nabba akolere omukolo ogwʼokukisuuca okubba kirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Nʼakwata amasavu gonagona agabiika oku byenda, nʼendimi gyʼamani, nʼempigo gyombi, nʼamasavu agagiriku, nʼabyocerya oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Neye enyama yonayona eya nte oyo esigairewo nʼeidiba lyaku, nʼebinamukida, nʼabyocerya e nza wʼenkambi ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Awo oMusa nʼakwata ontaama omusaiza owʼesadaaka egibooca yonayona era Alooni nʼabataanebe ni bateeka engalo gyabwe oku mutwe gwa ntaama oyo. ");
INSERT INTO gwr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","OMusa nʼamusala, nʼaswankira omusaaye oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Nʼasalamu ontaama oyo bitundutundu, nʼayoca omutwe, nʼebitundu ebyo, nʼamasavu. ");
INSERT INTO gwr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Nʼanaabya ebyenda nʼebikokolo byona nʼabyocerya oku kyoto, nʼabba ayocerye ontaama oyo yenayena ngʼesadaaka egibooca yonayona ngʼoMusengwa oweyamulagiire. Eyo niiyo esadaaka egibooca yonayona ikyo ekyokuwaayo ekibooca nga bakiwaayo eeri oMusengwa, era ni kizwamu oluvululu olusangaalya oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Awo oMusa nʼaigererya ontaama owokubiri, ontaama ogubawaayo ngʼesadaaka eyʼokwawula kaisi Alooni nʼabataanebe ni bateeka engalo gyabwe oku mutwe gwa ntaama oyo. ");
INSERT INTO gwr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","OMusa nʼamusala, nʼatoolaku omusaaye gwa ntaama oyo, nʼagusiiga oku kalege kʼekitwi kyʼAlooni ekyʼoku ndiiro, nʼoku kinkumu kyʼengaloye eyʼoku ndiiro, nʼoku lunwe olunene olwʼekigerekye ekyʼoku ndiiro. ");
INSERT INTO gwr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Nʼaira oku bataane bʼAlooni, nʼabasiiga omusaaye ogwo oku bulege bwʼamatwi gaabwe agʼoku ndiiro, nʼoku binkumu ebyʼoku ndiiro, nʼoku nnwe enene egyʼoku bigere byabwe ebyʼoku ndiiro. Omusaaye ogwasigairewo nʼaguswankira oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Nʼakwata amasavu, nʼomukira omusava, nʼamasavu gonagona agabiika oku byenda, nʼendimi gyʼamani, nʼempigo gyombi nʼamasavu agagiriku, nʼekisambi ekyʼoku ndiiro, ");
INSERT INTO gwr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","awo nʼatoola omugaati gumo omu kiibo kyʼemigaati egibulamu okazumbulukuca, egibateekere omumaiso ga Musengwa, era nʼatoola nʼomugaati gumo ogubakandiiremu obwito, nʼakagaati kamo akayeyere, nʼagiteeka oku masavu nʼoku kisambi ekyʼoku ndiiro. ");
INSERT INTO gwr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Byonabyona ebyo nʼabikwatisya Alooni nʼabataane, ni babisiirya ni babiica ngʼesadaaka eyʼenjabulo egibasiirya ni baica omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Awo oMusa nʼabitoola omu ngalo gyabwe, nʼabyocerya oku kyoto, aamo nʼesadaaka egibooca yonayona, nga niikyo ekyokuwaayo eeri oMusengwa olwʼomukolo ogwʼokwawula, ikyo ekyokuwaayo ekibooca nga bakiwaayo eeri ni kizwamu akaloosa, ikyo ekyokuwaayo ekyʼekyokulya ekibawaayo eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","OMusa nʼakwata obbanda, nʼamusiirya omumaiso ga Musengwa ngʼesadaaka eyʼenjawulo egibasiirya ni baica, era ogwo niigwo ogwabbaire omugabogwe oku ntaama oyo owʼomukolo ogwʼokwawula, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Awo oMusa nʼatoolaku amafuta agebakolesya omu kwawula, nʼatoolaku nʼoku musaaye ogwabbaire oku kyoto, nʼabiswankira okwʼAlooni nʼoku bizwalobye, nʼoku bataane nʼoku bizwalo byabwe. Omu ngeri eyo nʼayawula Alooni nʼabataane, era nʼayawula nʼebizwalo byabwe. ");
INSERT INTO gwr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","OMusa nʼakoba Alooni nʼabataane ati, “Musumbire enyama oku mulyango gwʼeWeema eyʼoKusisinkanirangamu oMusengwa, era mugiriire awo, nʼemigaati egiri omu kiibo ekyʼebyokuwaayo ebyʼomukolo ogwʼokwawula, ngʼoMusengwa oweyalagiire ati Alooni nʼabataane bagiryanga. ");
INSERT INTO gwr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Era ekisigalawo oku nyama eyo nʼoku migaati, mwabyocanga. ");
INSERT INTO gwr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Timuzwanga oku mulyango gwʼeWeema eyʼoKusisinkanirangamu oMusengwa, okumala enaku musanvu, paka enaku egyʼomukolo ogwʼokubaawula owegyaliwaaku, olwʼokubba okubaawula kwanywe kwalimala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","OMusengwa niiye eyatulagiire okukola ebyo ebitukolere olwatyanu, olwʼokubasuuca abalongoole. ");
INSERT INTO gwr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Muteekwa okusigala obwire nʼomusana oku mulyango gwʼeWeema eyʼokumusisinkanirangamu, okumala enaku musanvu, okutuukirirya ekiragiro kya Musengwa kaisi timwafa, olwʼokubba atyo oMusengwa weyandagiire.” ");
INSERT INTO gwr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Kale Alooni nʼabataane ni bakola byonabyona oMusengwa ebiyalagiire ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Oku lunaku olwomunaana, oMusa nʼayeta Alooni nʼabataane nʼabeekubbemberi bʼaBaisirairi, ");
INSERT INTO gwr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","nʼakoba Alooni ati, “Okwate onte okitobba owʼesadaakayo eyʼokusoniya ekikole ekibbikibbi nʼontaama omusaiza owʼesadaaka egibooca yonayona, nga gyombi gibulaku obuleme, ogiweeyo eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Awo okobe aBaisirairi oti, ‘Mukwate ombuli ompanya, owʼesadaaka eyʼokusoniya ekibbikibbi, nʼonte okitobba nʼomwana wa ntaama, nga gyonagyona gyʼomwanka gumo gumo, era ngʼebyayo ebyo byonabyona bibulaku obuleme, bibbe sadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","nʼonte, nʼontaama omusaiza ebyʼesadaaka eyʼokusyania egibawaayo omumaiso ga Musengwa, aamo nʼekyokuwaayo ekyʼempeke, ekibatabwiryemu obwito. Ekyo kityo olwʼokubba olwatyanu, oMusengwa yababonekera.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ebyo oMusa ebiyalagiire, ni babireeta omumaiso gʼeWeema eyʼoKusisinkanirangamu oMusengwa. ABaisirairi bonabona ni basembera, era ni beemerera omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Awo oMusa nʼakoba ati, “OMusengwa abalagiire okukola kinu, kaisi ekitiisyakye kibabonekere.” ");
INSERT INTO gwr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","OMusa nʼakoba Alooni ati, “Oigerere oku kyoto, oweeyo esadaaka eyʼokusoniya ekikole ekibbikibbi, nʼesadaaka egibooca yonayona, era okole omukolo ogukusuuca omulongoole, era oweeyo nʼesadaaka eyʼabantu eyʼokubasuuca abalongoole ngʼoMusengwa oweyalagiire.” ");
INSERT INTO gwr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Awo Alooni nʼaigerera oku kyoto, nʼasala onte okitobba, nga niiyo esadaaka eyʼokusoniya ekikolekye ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Abataane ni bamukwatisya omusaaye, nʼatimyamu olunwerwe, nʼagusiiga oku maziga gʼekyoto, ogwasigairewo nʼagusuka ansi wʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Kaisi amasavu, nʼempigo, nʼendimi gyʼamani, ebyʼesadaaka eyʼokusoniya ekibbikibbi nʼabyocerya oku kyoto, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Neye enyama nʼeidiba, nʼabyocerya e nza wʼenkambi. ");
INSERT INTO gwr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Alooni nʼasala ekyayo ekyʼesadaaka egibooca yonayona. Abataane ni bamukwatisya omusaaye, nʼaguswankira oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ni bamukwatisya ebitundu ebyʼesadaaka egibooca yonayona kimo kimo aamo nʼomutwe, nʼabyocerya oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Nʼanaabya ebinamukida nʼebikokolo, nʼabyocerya oku kyoto, aamo nʼesadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Awo Alooni nʼawaayo esadaaka yʼabantu. Yakwaite ombuli owʼesadaaka eyo eyʼokusoniya abantu ekikole ekibbikibbi, nʼamusala, nʼamuwaayo ngʼesadaaka eyʼokusoniya ekibbikibbi kyabwe, ngʼoweyakolere kwedi eyasookere eyʼokusoniya ekikolekye ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Era nʼakwata esadaaka egibooca yonayona, nʼagiwaayo ngʼekiragiro owekyabbaire. ");
INSERT INTO gwr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Nʼakwata nʼekyokuwaayo ekyʼempeke, nʼayoolaku ekigalo kyʼobusye, nʼakyocerya oku kyoto, ngʼayongera oku sadaaka egibooca yonayona nabuli makeezi. ");
INSERT INTO gwr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Nʼasala onte onumi nʼontaama omusaiza, ngʼesadaaka eyʼokusyania, egiyawaireyo olwʼabantu. Abataane ni bamukwatisya omusaaye, nʼaguswankira oku mba gyonagyona egyʼekyoto. ");
INSERT INTO gwr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Neye ebitundu ebyʼamasavu ebya numi nʼontaama, ekikoba kiti, omukira ogwʼamasavu, nʼago agabiika oku binamukida, nʼempigo, nʼendimi gyʼamani, ");
INSERT INTO gwr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ni babiteeka oku bbanda wʼebyayo ebyo. Alooni nʼayocerya amasavu ago oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Neye obbanda nʼekisambi kyʼoku ndiiro nʼabisiirya omumaiso ga Musengwa, ngʼesadaaka eyʼenjabulo egibasiirya ni baica, ngʼoMusa oweyalagiire. ");
INSERT INTO gwr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Oluzwanyuma lwʼekyo Alooni nʼasiirya engalogye eeri abantu nʼabasabira enkabi. Era ngʼamalire okuwaayo esadaaka eyʼokusoniya ekibbikibbi, nʼesadaaka egibooca yonayona, nʼesadaaka eyʼokusyania, awo nʼaika ansi. ");
INSERT INTO gwr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","OMusa nʼAlooni ni baingira omu Weema eyʼoKusisinkanirangamu oMusengwa. Owebawulukire, ni basabira abantu enkabi, era ekitiisya kya Musengwa ni kibonekera abantu bonabona. ");
INSERT INTO gwr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","OMusengwa nʼasindika omusyo, ni gwoca gumalawo esadaaka egibooca yonayona nʼebitundu ebyʼamasavu ebyabbaire oku kyoto. ABaisirairi bonabona owebaboine ekintu ekyo, ni bakooka olwʼeisangaalo, era ni bafuunama ni baica empumi gyabwe ansi okwitakali okumuwa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Lwabbaire lumo abataane bʼAlooni, oNadabbu nʼAbbiku, ni bakwata ebyokuduunyisiryaku nabuli moiza ekikye, ni babiteekamu omusyo, era ni bateekaku obubbaani, ni babireeta omumaiso ga Musengwa. Neye omusyo ogwo oMusengwa nga tagwikirirya, olwʼokubba tiniiye eyalagiire okuguleeta. ");
INSERT INTO gwr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kale oMusengwa nʼasindika omusyo, ni gubooca, ni bafeera aawo omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Awo oMusa nʼakoba Alooni ati, “Kinu niikyo oMusengwa ekiyatumwireku, oweyakobere ati, ‘Eeri abo abansemberera neeragisyanga ngʼobwendi mutukulye era abantu bonabona bampanga ekitiisya.’ ” Neye Alooni nʼasirika-busiriki. ");
INSERT INTO gwr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Awo oMusa nʼayeta oMisairi nʼErizefaani, abataane ba Wuziyeeri, oiteeye wʼAlooni omuto, nʼabakoba ati, “Mwize aanu muginge emirambo gyʼabaganda baanywe, mugitoole omu Weema eya Musengwa, mugitwale e nza wʼenkambi.” ");
INSERT INTO gwr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Kale ni baaba, ni baginga emirambo egyo nga gikaali giri omu bbeketera gyagyo, ni bagitwala e nza wʼenkambi, ngʼoMusa oweyalagiire. ");
INSERT INTO gwr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","OMusa nʼakoba Alooni nʼabataane bʼAlooni, Eryezaali nʼoIsamali ati, “Timwakankadyaga enziiri gyanywe, waire kunyiira bizwalo byanywe okulaga muti munakuwaire. Owemwakola ekyo, mwaba kufa, era oMusengwa yasunguwalira abantu bonabona abakumbaanire. Neye aBaisirairi abanaanywe bonabona, bayezya okukunga olwʼokufiirwa abo, oMusengwa abaajigiricirye nʼomusyo. ");
INSERT INTO gwr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Timwazwa oku mulyango gwʼeWeema eyʼoKusisinkanirangamu oMusengwa, mudemba ni mufa, olwʼokubba inywe babasukireku amafuta okubaawula.” Kale ni bakola ngʼoMusa oweyakobere. ");
INSERT INTO gwr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","OMusengwa nʼakoba Alooni ati, ");
INSERT INTO gwr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Iwe nʼabataanebo, timwanywanga enviinyo, ooba ekiteemeerya ekindi kyonakyona, owemwabbanga mwaba okwingira omu Weema eyʼoKunsisinkanirangamu nze oMusengwa. Singa mwalikikola, mwalifa. Era eryo lyabbanga iteeka eryʼenkalaakalira eeri inywe nʼabʼemirembe egyaliirawo. ");
INSERT INTO gwr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mwawulengemu ebitukulye nʼebitali bitukulye, ebirongoole, nʼebitali birongoole. ");
INSERT INTO gwr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Era muli nʼokwegesyanga aBaisirairi amateeka gonagona agembawaire nga mbitira omu Musa.” ");
INSERT INTO gwr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Awo oMusa nʼakoba Alooni nʼabataane, Eryezaali nʼoIsamali ibo ababbaire basigairewo ati, “Mukwate ekyokuwaayo ekyʼempeke ekisigairewo oku kyokuwaayo ekibooca nga bakiwaayo eeri oMusengwa, ekibasumbire nga kibulamu okazumbulukuca, mukiriire oku mbale wʼekyoto, olwʼokubba ekyokuwaayo ekyo kitukulye ino. ");
INSERT INTO gwr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Mukiriire mu kifo ekitukulye omu luuga lwʼeWeema eyʼoKusisinkanirangamu oMusengwa, olwʼokubba niigwo omugabogwo iwe, nʼabataanebo, oku byokulya ebyokuwaayo ebibooca nga babiwaayo eeri oMusengwa. Ekyo oMusengwa niikyo ekiyandagiire. ");
INSERT INTO gwr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Neye obbanda ogubawaayo nga basiirya ni baica, nʼekisambi ekibawaayo, iwe nʼabataanebo nʼabaalabo mwabiriiranga omu kifo ekirongoole omumaiso ga Musengwa, olwʼokubba ebyo babiwaire niiwe nʼabaanabo, nga niigwo omugabo ogwanywe abakabona, oku sadaaka eyʼaBaisirairi eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ekisambi ekibawaireyo nʼobbanda ogubasiirya ni baica babireeteranga aamo nʼamasavu agʼoku byokuwaayo ebibooca, nga bali nʼokubisiirya ni babiica omumaiso ga Musengwa ngʼesadaaka eyʼenjabulo egibasiirya ni baica. Era byabbanga mugabogwo iwe nʼabataanebo enaku gyonagyona, ngʼoMusengwa oweyalagiire.” ");
INSERT INTO gwr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Oluzwanyuma oMusa nʼabuulya ebikwata oku mbuli owʼesadaaka eyʼokusoniya ekibbikibbi. Nʼazuula nga bamwocerye ira. Awo nʼasunguwalira Eryezaali nʼoIsamali, abataane bʼAlooni ababbaire basigairewo. Nʼababuulya ati, ");
INSERT INTO gwr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Lwaki esadaaka eyʼokusoniya ekikole ekibbikibbi timugiriiriire mu Weema ya Musengwa? Ekyokuwayo ekyo kitukulye ino, bakibawaire kaisi kitoolewo ekikole ekibbikibbi ekyʼabantu bonabona olwa inywe okukola omukolo gwʼokubasuuca okubba abalongoole omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Ngʼomusaaye gwaku owenandi baguleeta omu Weema ya Musengwa, ombuli oyo mwandibbaire mumuliiriire mu Weema ya Musengwa, ngʼowenalagiire.” ");
INSERT INTO gwr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Awo Alooni nʼairamu oMusa ati, “Olwatyanu abantu bawaireyo eeri oMusengwa esadaaka eyʼokusoniya ebibbibibbi byabwe, nʼesadaaka egibooca yonayona, neye era ebintu nga binu ni bintuukaku. Kale singa olwatyanu ndiire esadaaka eyʼokusoniya ekibbikibbi, oMusengwa yandinsiimire?” ");
INSERT INTO gwr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","OMusa oweyawuliire ebyo, nʼamatira. ");
INSERT INTO gwr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","OMusengwa nʼakoba oMusa nʼAlooni, ");
INSERT INTO gwr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","okukoba aBaisirairi bati, “Oku bisolo byonabyona ebiri oku kyalo, binu niibyo ebimwayinzanga okulya. ");
INSERT INTO gwr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Mwalyanga okisolo yenayena ali nʼekyemero ekyabulemu nga kyeyabuliiremu nakimo era nga airya obwekulumu. ");
INSERT INTO gwr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Waliwo ebisolo ebimo ebiirya bwekulumu kyonkani ooba ebiri nʼebyemero ebyabulemu kyonkani, ibyo timwabiryanga. Ngʼongamira waire ngʼairya obwekulumu ebyemero tibyabulemu nʼolwekyo timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Nʼomuswi waire nga gwirya obwekulumu ebyemero tibyabulemu nʼolwekyo mugubalenge okubba timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Nʼonapowo, waire nga airya obwekulumu, ebyemero tibyabulemu nʼolwekyo mumubalenge okubba timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ate ombiizi, waire ngʼaali nʼekyemero ekyabuliremu nakimo, tairya obwekulumu nʼolwekyo mumubalenge okubba timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Timwalyanga enyama yʼebisolo ebyo, waire okubikwataku nga bifiire. ");
INSERT INTO gwr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Ku buli kyomi ekibba omu maizi agʼomu nyanza nʼagʼomu miiga, mwayinzanga okulya nabuli ekiri nʼamadaadiri nʼebikalakamba. ");
INSERT INTO gwr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Neye nabuli kibbumbe ekibba omu nyanza ooba omu miiga nga kibulaku amadaadiri nʼebikalakamba waire bibbumbe ebyekuusira okwitakali nʼebindi byonabyona ebyomi ebibba omu maizi, byabbanga byʼomuliko egimuli. ");
INSERT INTO gwr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ngʼowebiri ebyʼomuliko egimuli, timwalyanga enyama yaabyo, era nʼemirambo gyabyo gyabbanga gyʼomuliko. ");
INSERT INTO gwr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ekintu kyonakyona ekibba omu maizi neye nga kibula amadaadiri nʼebikalakamba, kyabbanga kyʼomuliko egimuli. ");
INSERT INTO gwr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Enyonyi ginu niigyo egyʼomuliko era timwagiryanga olwʼokubba gyʼomuliko: Okokomi, nʼonsega, nʼosukusuku, ");
INSERT INTO gwr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","nʼokalukubba nʼowungwe nʼegindi egiri ngʼegyo; ");
INSERT INTO gwr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","nabuli kika kya nankololo; ");
INSERT INTO gwr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","nʼomaaya, nʼonaibboto, nʼombaati wʼoku nyanza, nʼegindi egiri ngʼegyo, ");
INSERT INTO gwr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","nʼakawuugulu akatono, nʼekiwuugulu ekinene, nʼomuduwu, ");
INSERT INTO gwr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","nʼotulutu, nʼonsega omwirugazu, nʼonkobyokobyo; ");
INSERT INTO gwr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","nʼekikalooli, nʼosokonolya nʼegindi egiri ngʼegyo, nʼokokoteri, nʼokawugu. ");
INSERT INTO gwr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Ebiwuuka byonabyona ebiguluka, ebitambula nʼebigere ebina byabbanga byʼomuliko egimuli, ");
INSERT INTO gwr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Neye oku biwuuka ebyo ebiguluka, era nga bitambula nʼebigere ebina, mwalyanga ebyo ebiri nʼenyingo oku bigere egibikolesya okujuuka okwitakali. ");
INSERT INTO gwr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Binu byona muyinza okubiryanga: Enzige egya buli ngeri nʼensyenene egya buli ngeri, nʼejeeja egya buli ngeri, nʼamanampalala aga buli ngeri. ");
INSERT INTO gwr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Neye ebiwuuka ebindi byonabyona ebiri nʼebiyaya, nga biri nʼebigere bina, byabbanga byʼomuliko egimuli. ");
INSERT INTO gwr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Ebisolo binu byabasuucanga abatali balongoole. Nabuli eyabikwatangaku nga bifu, yasigalanga timulongoole paka igulo, ");
INSERT INTO gwr_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","era nabuli eyabiginganga nga bifu, yayozanga ebizwalobye, era yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Nabuli kisolo ali nʼekyemero neye nga tikyabuliremu nakimo era nga tairya obwekulumu, yaabbanga wʼomuliko egimuli. Nabuli eyakwatanga oku kisolo yeyena omufu kwebyo, yaabbanga timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Omu bisolo byonabyona ebitambula nʼebigere ebina, ebyo ebitatambulira oku biruutu, tibyabbenge birongoole kwinywe. Nabuli eyabikwatangaku nga bifu, yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Era oyo eyaginganga okisolo oyo nga mufu, yayozanga ebizwalobye, era yasigalanga nga timulongoole paka igulo. Ebisolo ebyo byabbanga tibirongoole kwinywe. ");
INSERT INTO gwr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Era omu bisolo ebitambulira okwitakali nga bisamanta, binu byabbanga tibirongoole kwinywe: Enjuguju, nʼemese, nʼenankibbobbo egyʼebika byonabyona, ");
INSERT INTO gwr_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","nʼekadantaama, nʼengaiza, nʼebikovu, nʼebika byonabyona ebyʼamanankibbobbo, nʼamawalovu. ");
INSERT INTO gwr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ebisolo ebyo kwebyo nago ebitambula nga bisamanta okwitakali byabbanga tibirongoole kwinywe. Nabuli eyabikwatangaku nga bifiire, yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Era ekimo oku bisolo ebyo owekyafanga ni kigwa oku kintu kyonakyona, ekintu ekyo kyasuukanga kitali kirongoole, waire ngʼekintu ekyo bakikolere mu kisaale, ooba mu lugoye, ooba mwidiba, ooba mukotiya. Bakiteekanga omu maizi, era kyasigalanga nga tikirongoole paka igulo, neye oluzwanyuma kyabbanga kirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Singa ekimo oku bisolo ebyo kyagwanga omu nsaka, byonabyona ebigirimu tibyabbenge birongoole, era ensaka eyo bagyatanga. ");
INSERT INTO gwr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Singa ekyokulya kyonakyona ekibabaikirirya okukirya, kyasusukangaku amaizi agazwire omu nsaka eyo, tikyabbenge kirongoole, nʼekyokunywa ekibandinywire okuzwa omu nsaka eyo, tikyabbenge kirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Era ekintu kyonakyona okisolo omufu ekiyagwangaku kyabbanga tikirongoole. Waire liiga lyʼeitakali, ooba nsaka, babitentenanga. Byabbanga tibirongoole, era tibyabbenge birongoole kwinywe. ");
INSERT INTO gwr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Neye eiruba ooba ebiina byʼamaizi, byabbanga birongoole, neye eyakwatanga oku kisolo agwire omu kimo kwebyo nʼafeeramu yaabbanga timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Singa okisolo afiire agwa oku nsigo egibaaba okusiga, ensigo egyo gyabbanga tinnongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Neye singa ensigo baabbanga bagiinikire omu maizi, kaisi okisolo afiire nʼagwaku, gyabbanga tinnongoole kwinywe. ");
INSERT INTO gwr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Singa ekisolo kyonakyona kwebyo ekibaikirirya okulya kifa, omuntu yenayena eyakwatanga oku kisolo ekifiire yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Omuntu yenayena eyaalyangaku enyama ya kisolo afiire, nʼoyo eyaginganga okisolo nago, yayozanga ebizwalobye era yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Nabuli kibbumbe kyonakyona ekitontono ekitambula okwitakali kyabbanga kyomuliko era timukiryanga. ");
INSERT INTO gwr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Timwalyanga ekibbumbe kyonakyona ekyʼekuusira okwitakali, ooba ekitambulya ebigere ebina, ooba ekiri nʼebigere ebingi ekisamanta; kyabbanga kyomuliko. ");
INSERT INTO gwr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Timweyonoonanga olwʼokulya ekibbumbe kyonakyona kwebyo, era timwesuucanga abatali balongoole olwʼokubirya era timwaikiriryanga ebibbumbe ebyo okubasuuca abatali balongoole. ");
INSERT INTO gwr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ninze oMusengwa iye oKibbumba waanywe, mwetukulye mubbe batukulye olwʼokubba Nze ndi mutukulye. Timwesuucanga abatali balongoole olwʼokulya ekibbumbe kyonakyona ekisamanta okwitakali. ");
INSERT INTO gwr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ninze oMusengwa eyabatoire omu kyalo kyʼe Misiri, mbe Kibbumba waanywe. Nʼolwekyo mubbenge batukulye, olwʼokubba nze ndi mutukulye. ");
INSERT INTO gwr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Ago niigo amateeka agakwata oku bisolo nʼoku nyonyi, nabuli kyomi kyonakyona ekibba omu maizi, nabuli kibbumbe ekisamanta okwitakali omu kiziima, ");
INSERT INTO gwr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","muli nʼokwawulangamu ebirongoole nʼebitali birongoole, ebibbumbe ebyomi ebibabaikirirya okulya nʼebibbumbe ebyomi ebibatabaikirirya okulya.” ");
INSERT INTO gwr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Okobe aBaisirairi oti omukali oweyaabbanga ekida nʼabyala omwana omwisuka, tiyaabbenge mulongoole okumala enaku musanvu, ngʼowaatabba mulongoole omumaiso ga Musengwa ngʼali omu nsonga gyʼekikali. ");
INSERT INTO gwr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Oku lunaku lwomunaana, omwana oyo bamukomolanga. ");
INSERT INTO gwr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Awo omukali oyo yakuumanga ni wabitawo enaku 33 kaisi nʼabba mulongoole. Tiyakwatenge oku kintu ekirongoole, waire okwaba omu Weema yange nze oMusengwa, paka ngʼamalireku enakugye egyʼokumusuuca omulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Neye oweyabyalanga omwana omwala, yamalanga enaku ikumi na ina nga timulongoole, ngʼowaabba omu kiseerakye ekyokubba omu nsonga gyʼekikali. Awo omukali oyo yakuumanga ni wabitawo enaku 66 kaisi nʼabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Awo enaku gyʼomukali oyo egyʼokubba omulongoole olwʼokubyala omwana omwisuka ooba omwala owegyawangaku, omukali oyo yaleetanga eeri okabona oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa, ontaama owʼomwanka ogumo, owʼesadaaka egibooca yonayona, nʼonjiiwa, ooba ompuuwu, owʼesadaaka eyʼokusoniya ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Okabona yabiwangayo eeri nze oMusengwa okukola omukolo gwʼokusuuca omukali oyo okubba omulongoole, awo kaisi omukali oyo nʼabba mulongoole olwʼomusaaye ogwamuzwiremu olwʼokubyala. Eryo niiryo eiteeka erifuga omukali abyala omwana omwisuka ooba omwala. ");
INSERT INTO gwr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Singa omukali yaabbanga nga tayezya okuleeta omwana wa ntaama olwʼensunaye entono, yaleetanga empuuwu ibiri, ooba enjiiwa entonto ibiri, omoiza wʼesadaaka egibooca yonayona, nʼogondi wʼesadaaka eyʼokusoniya ekikole ekibbikibbi. Okabona yabiwangayo eeri oMusengwa olwʼokusuuca omukali oyo okubba omulongoole, era omukali oyo nʼabba mulongoole.” ");
INSERT INTO gwr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","OMusengwa ni yeeyongera okukoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Omuntu oweyaabbanga nʼekintu ekibbimbire oku lususu ooba ekimufulukukireku, ooba ekyeyocerye oku lususulwe, nga kiyinza okusuuka bulwaire wʼebigenge, bamuleetanga eeri Alooni okabona, ooba eeri omoiza oku bakabona abʼeibyaire lyʼAlooni. ");
INSERT INTO gwr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Okabona yakeberanga awali obulwaire oku lususu lwʼomuntu oyo. Era singa obwoya obuli awali obulwaire bwabbanga busuukire bweru, nʼobulwaire nga buboneka bwingire omunda wʼolususu, obwo bwabbanga bulwaire bwʼebigenge. Okabona oweyamalanga okumukebera awo yamulangiriranga ati timulongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Neye singa awantu aweeyocerye oku lususu waabbanga weeruukiriire, nga waboneka nandi ni weeyoca okwingira omunda, nʼobwoya obuliwo nga tibusuukire bweru, okabona yasibiranga omuntu oyo omulwaire omu kalantiini, okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Oku lunaku olwomusanvu okabona yairangamu okumukebera. Oweyabonanga ngʼobulwaire busigaire ngʼowebubbaire, era nga nandi ni weeyongera okusaasaana awandi oku lususu, yamusibiranga omu kalantiini okumala enaku egindi musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Oku lunaku lwomusanvu tete okabona yamukeberanga. Obulwaire owebwabbanga bukendeire, era nga nandi ni busaasaanira oku lususu, okabona yamulangiriranga ati mulongoole ali nʼobuntu obumufulukukireku. Awo omuntu oyo yayozanga ebizwalobye era nʼabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Neye obulwaire owebwasaasaaniranga oku lususu, ngʼokabona amalire okumukebera nʼokumulangirira ati mulongoole, yairangayo eeri okabona ni yeeyanjula. ");
INSERT INTO gwr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Okabona yamukeberanga era obulwaire owebwabbanga busaasaaniire oku lususu, yamulangiriranga ati timulongoole; ebyo byabbanga bigenge. ");
INSERT INTO gwr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Omuntu yenayena ebigenge owebyamukwatanga, bamuleetanga eeri okabona. ");
INSERT INTO gwr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Okabona yamukeberanga, owewaabbangawo okubbimba nga kubabukire oku lususu era nga kusuucirye obwoya bwawo okubba bweru, era ngʼomubiri guliku ebipala ebyankweyoca, ");
INSERT INTO gwr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ebyo byabbanga niibyo ebigenge byʼoku lususu ebitalama. Era okabona yamulangiriranga ati timulongoole. Tiyamusibirenge omu kalantiini olwʼokubba, kyabbanga kimalire okutegerekeka kiti timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Neye singa obulwaire bwasaasaaniranga oku lususu lwʼomuntu oyo, okuzwa oku mutwe okutuuka oku bigere, okabona e gyayezya okubona, ");
INSERT INTO gwr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","okabona yamukeberanga. Era obulwaire owebwabbanga busaasaaniire oku mubirigwe gwonagwona era nga asigazire nkozu, yamulangiriranga ati mulongoole. Olwʼokubba omubirigwe gwonagwona gwabbanga gususuukire era nga mweru, oyo yaabbanga mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Neye olususu lwʼomuntu oyo owerwabonekangaku ebipala ebyankweyoca, tiyaabbenge mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Okabona oweyabonanga ebipala ebyo, yamulangiriranga ati timulongoole. Ebipala ebyankweyoca oku lususu bibba biraga biti tirulongoole, olwʼokubba bibba biraga bulwaire bwʼebigenge. ");
INSERT INTO gwr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Neye singa awabbaire ebipala ebyokweyoca walama ni wasusuuka era ni weeruwa, omuntu oyo yaabanga eeri okabona. ");
INSERT INTO gwr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Okabona oweyamukeberanga aawo awabbaire obulwaire obwʼokweyoca nga wasusuukire era nga weeruwire, oyo yaabbanga mulongoole, era okabona yamulangiriranga ati mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Omuntu oweyaabbanga nʼekisumuli oku mubirigwe ni kirama, ");
INSERT INTO gwr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","neye oluzwanyuma awabbaire ekisumuli ni wairamu okubbimba era ni weeruwa, ooba ni weeyoca ni watukuliikirira, omuntu oyo yaabanga eeri okabona. ");
INSERT INTO gwr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Okabona yakeberanga ekyeyocerye ekyo, owekyabonekanga ooti kingira omunda wʼolususu, nʼobwoya bwawo nga busuukire bweru, okabona yamulangiriranga ati timulongoole. Obwo bwabbanga bulwaire bwʼebigenge obuwulukire awabbaire ekisumuli. ");
INSERT INTO gwr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Neye okabona oweyakeberanga aweeyocerye nga mpaawo bwoya obweru, era nga obulwaire nandi ni bwingira omunda wʼolususu, era nga tiwaboneka ino, okabona yasibiranga omuntu oyo omu kalantiini, okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Neye singa obulwaire obwo busaasaanira oku lususu, okabona yamulangiriranga ati timulongoole, olwʼokubba ebyo byabbanga bigenge. ");
INSERT INTO gwr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Neye singa obulwaire obwo bwakomanga aawo nandi busaasaana, oyo yaabbanga nkozu wʼekisumuli, era okabona yamulangiriranga ati mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Singa waabbangawo oku lususu lwʼomuntu awantu omusyo awegwocerye, aawo omusyo awegwocerye ni wabonekawo ekipala ekyankweyoca ekitukuliikiriri ooba ekyerukyeru, ooba okweruwa, ");
INSERT INTO gwr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","okabona yakeberangawo, obwoya wʼawantu aawo owebwabbanga bweru, ni waboneka nga wangiire omunda wʼolususu, ebyo byabbanga bigenge niibyo ebiwulukire omusyo awegwocerye. Okabona yamulangiriranga ati timulongoole, olwʼokubba ebyo byabbanga bigenge. ");
INSERT INTO gwr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Neye okabona oweyakeberanga aawo omusyo awegwocerye nʼabona nga mpaawo bwoya obweru, era nga tiwangiire omunda wʼolususu, era nga tikiboneka ino, okabona yateekanga omuntu oyo omu kalantiini okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Oku lunaku lwomusanvu okabona yamukeberanga, era obulwaire owebwabbanga busaasaaniire oku lususu, okabona yamulangiriranga ati timulongoole, olwʼokubba ebyo byabbanga bigenge. ");
INSERT INTO gwr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Neye singa obulwaire bwasigalanga mu kifo kimo nandi ni busaasaanira oku lususu, era ngʼawali ekipala tiwaboneka ino, ekyo kyabbanga kipala ekyaizirewo nga musyo niigwo ogwoceryewo. Era okabona yamulangiriranga ati mulongoole, olwʼokubba oyo nkozu eyaizirewo ngʼomusyo niigwo ogwoceryewo. ");
INSERT INTO gwr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Singa omusaiza ooba omukali yaabbanga nʼeibbwa oku mutwe ooba oku mulevu, ");
INSERT INTO gwr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","okabona yakeberanga eibbwa eryo. Singa lyabbanga lingiire okubitawo olususu e girukoma, era ngʼenziiri awali eibbwa gyengereire, era ngʼenziiri egyo ntyai giti, okabona yamulangiriranga ati timulongoole. Obwo bwabbanga bulwaire obwʼokweyaga, ngʼobwo bulwaire bwʼebigenge obwʼoku mutwe, ooba obwʼoku mulevu. ");
INSERT INTO gwr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Neye singa okabona yakeberanga eibbwa eryo erisiya, nʼabona nga tiringira okubitawo olususu e girukoma, era nga mpaawo nziiri enjirugazu awali obulwaire, okabona yateekanga omuntu oyo omu kalantiini, okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Oku lunaku olwomusanvu okabona yakeberanga eibbwa eryo, era ngʼobulwaire obwo obwʼokweyaga nandi busaasaana, era ngʼomwibwa eryo mpaamu enziiri egyengereire, era nga tiringira okubitawo olususu e girukoma, ");
INSERT INTO gwr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","omuntu oyo yamwangaku enziiri okutoolaku aawo awalwaire, era okabona yamuteekanga omu kalantiini okumala enaku egindi musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Oku lunaku lwomusanvu okabona yakeberanga obulwaire obwo tete, singa waabbanga tibusaasaaniire oku lususu, era nga tibwingira okubitawo olususu e girukoma, okabona yamulangiriranga ati mulongoole. Era omuntu oyo yayozanga ebizwalobye, nʼabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Neye obulwaire owebwasaasaaniranga oku lususu nga bamalire okumulangirira bati mulongoole, ");
INSERT INTO gwr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","okabona yamukeberanga, obulwaire owebwabbanga busaasaaniire oku lususu, okabona tiyanoonienge enziiri egya namagi awali obulwaire obwo; omuntu oyo dala yaabbanga timulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Neye okabona oweyabonanga ngʼobulwaire nandi bweyongera, era ngʼenziiri enjirugazu gimererewo, olwo obulwaire bwabbanga bulamire. Yaabbanga mulongoole era okabona yamulangiriranga ati mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Omusaiza ooba omukali oweyaabbanga nʼebyeyocerye ebyeru oku lususu, ");
INSERT INTO gwr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","okabona yaabbanga nʼokubikebera, era singa ebyeyocerye ebyo byabbanga byeruukiriire, ekyo kyabbanga kipala ekibula obugosi ekiizire oku lususu; omuntu oyo yaabbanga mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Omusaiza oweyakuunyukanga enziiri oku mutwe, nʼabba nʼempaata, yaabbanga mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Era omusaiza oweyakuunyukanga enziiri egyʼomu kyenyi, era nʼabba nʼempaata yʼomu kyenyi, yaabbanga mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Neye singa yaabbanga nʼeibbwa eritukuliikiriri omu mpaataye ooba omu kyenyikye, obwo bwabbanga bulwaire bwʼebigenge niibwo obumukwaite oku mutwe ooba omu kyenyi. ");
INSERT INTO gwr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Okabona yaabbanga nʼokumukebera, era singa eibbwa eribbimbire oku mutwe ooba omu kyenyi lyabbanga litukuliikiriri ooti kirwaire kyʼebigenge, ");
INSERT INTO gwr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","omuntu oyo yaabbanga ali nʼobulwaire bwʼebigenge era nga timulongoole. Okabona yamulangiriranga ati timulongoole, olwʼeibbwa eryo eriri oku mutwegwe. ");
INSERT INTO gwr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Omuntu eyaabbanga nʼekirwaire ekyʼebigenge ekityo, yaabbanga nʼokuzwala engoye enyiiriki, nʼaleka enziirigye nga tinsanyuluze, nʼabiika oku mulevu, kaisi nʼalangiriranga ati, ‘Tindi mulongoole, tindi mulongoole!’ ");
INSERT INTO gwr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Eibbanga lyonalyona eriyamalanga ngʼakaali ali nʼekirwaire ekyo, yasigalanga timulongoole. Yaabbanga nʼokubba yenkani; yaabbanga nza wʼenkambi. ");
INSERT INTO gwr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Singa ekizwalo kyabbangamu obuwuuka bwʼolukuku, ekikoba kiti, ekizwalo kyʼebyoya bya ntaama, ooba ekya lineni, ");
INSERT INTO gwr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ooba olugoye lwonalwona olwʼebyoya bya ntaama, ooba idiba, ooba kintu ekindi kyonakyona ekibakolere omwidiba, ");
INSERT INTO gwr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","era singa obuwuuka obwo obuli omu kizwalo ekyo, ooba okwidiba ooba oku olugoye ooba ekintu kyonakyona ekibakolere omwidiba bwabbanga bwekiragala ooba butukuliikiriri, olwo lwabbanga lukuku olusaasaana, era balulaganga okabona. ");
INSERT INTO gwr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Okabona yaabbanga nʼokwekeenenya olukuku olwo, nʼateeka ekintu ekyo ekiriku olukuku awantu kyonkani okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Oku lunaku lwomusanvu okabona yaabbanga nʼokukebera ekintu ekyo era singa olukuku lwabbanga lusaasaaniire omu bizwalo ebyo ooba ekintu ekikole ooba ekitunge ooba eidiba eryʼomugaso ogwʼenjabuwulo, lwabbanga lukuku olwonoona ekintu ekyo era ekintu ekyo kyabbanga tikirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Okabona yaabbanga nʼokwoca olugoye olwo ooba ekintu kyonakyona ekyo ekikole ooba ekitunge omu byoya bya ntaama ooba omu lineni ooba ekintu kyonakyona ekyo ekyʼeidiba ekiriku obuwuuka obwʼolukuku olwʼokubba olukuku olwo lwonoona. Era ekintu ekyo baabbanga nʼokukyoca ni kiya. ");
INSERT INTO gwr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Neye singa okabona yakeberanga ekintu nʼabona ngʼolukuku nandi lusaasaanira oku lugoye olwo, waire oku kintu ekyo ekikole ooba ekitunge ooba ekintu kidi ekyʼeidiba, ");
INSERT INTO gwr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","awo yalagiranga ni bayoza ekintu ekyo ekirimu olukuku. Era yaabbanga nʼokuteeka ekintu ekyo awantu kyonkani okumala enaku egindi musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Oluzwanyuma nga bamalire okwoza ekintu ekyo okabona yaabbanga nʼokukikebera, era olukuku owerwabbanga nandi lucuusa emboneka yʼekintu ekyo waire kusaasaanira oku kintu ekyo, kyabbanga tikirongoole. Mwakyocanga na musyo, waire ngʼolukuku lwabbanga ku lubba lumo ooba ku lundi. ");
INSERT INTO gwr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Neye okabona oweyakikeberanga, olukuku ni lubba lukendeire nga tiruboneka ino oluzwanyuma lwʼokwozamu ekintu ekyo, yanyiiranga awali olukuku oku lugoye olwo ooba okwidiba eryo ooba oku kintu ekyo ekikole ooba ekitunge. ");
INSERT INTO gwr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Neye olukuku owerwabonekanga tete oku lugoye olwo ooba oku kintu ekyo ekikole ooba ekitunge ooba oku kintu ekyo ekyʼeidiba, olukuku olwo lwabbanga lusaasaanire. Era nabuli kintu ekiriku olukuku baabbanga nʼokukyoca na musyo. ");
INSERT INTO gwr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Neye olugoye olwo ekintu ekyo ekikole ooba ekitunge ooba ekintu kyonakyona ekyʼeidiba, ekibayozere era ngʼolukuku luwoireku, baabbanga nʼokukyoza tete era ni kibba kirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Ago niigo amateeka agakwata oku lukuku nga luli omu lugoye olwʼebyoya bya ntaama ooba olwa lineni ooba oku kintu ekikole ooba ekitunge, ooba ekintu kyonakyona ekyʼeidiba, okubasinziriranga okubirangirira okubba ebirongoole ooba tibirongoole.” ");
INSERT INTO gwr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Linu niiryo eiteeka erimwasengereryanga okukola oku muntu alamire ebigenge. Oku lunaku lwʼomukolo gwʼokusuuca omuntu oyo okubba omulongoole omumaiso gange, bamutwalanga eeri okabona. ");
INSERT INTO gwr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Okabona yaabbanga nʼokumutoola omu nkambi kaisi nʼamukebera. Omuntu oyo oweyaabbanga alamire ebigenge, ");
INSERT INTO gwr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","okabona yalagiranga ni baleetera oyo ogubaaba okusuuca okubba omulongoole, enyonyi ibiri enjomi era ennongoole, nʼakasaale kʼomuvule, nʼewuuzi entukuliki, nʼakasaga kʼakasaale akebeeta oyisopu. ");
INSERT INTO gwr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Awo okabona yalagiranga ni basalira omoiza oku nyonyi egyo omu kibya ekirimu amaizi agʼomwiruba. ");
INSERT INTO gwr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Awo yakwatanga onyonyi odi omwomi, aamo nʼakasaale kʼomuvule, nʼewuuzi entukuliki, nʼakasaga ka yisopu, nʼabitimya omu musaaye gwa nyonyi ogubasaliire omu kibya ekirimu amaizi agʼomwiruba. ");
INSERT INTO gwr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Yaswankiranga omusaaye ogwo emirundi musanvu oku muntu oyo okumusuuca okubba omulongoole olwʼokulama ebigenge, era okabona nʼamulangirira okubba mulongoole. Awo nʼabba nʼokuteera onyonyi odi omwomi, nʼaguluka nʼayaba. ");
INSERT INTO gwr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Omuntu oyo ogubali kusuuca okubba omulongoole yayozanga ebizwalobye, nʼamwaku enziirigye gyonagyona, nʼanaaba; awo kaisi nʼabbanga amalire omukolo gwʼokumusuuca okubba mulongoole. Ekyo nga kiwoire yayinzanga okukanga omu nkambi, neye yamalanga enaku musanvu ngʼali nza wʼeweemaye. ");
INSERT INTO gwr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Oku lunaku lwomusanvu tete yaabbanga nʼokumwaku enziirigye gyonagyona, ekikoba kiti, egyʼoku mutwegwe, nʼomulevugwe nʼegyʼoku bisigebye, nʼobwoyabwe obundi bwonabwona. Era yaabbanga nʼokwoza ebizwalobye, nʼanaaba kaisi nʼabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Oku lunaku lwomunaana yaabbanga nʼokuleeta entaama ensaiza entonto ibiri, nʼontaama onduusi owʼomwanka ogumo, ngʼebyayo ebyo byonabyona bibulaku obuleme. Nʼaleeteraku nʼekiro isatu egyʼobusye obwʼengaano obusa, era obubatabwiryemu obwito bwʼemizaituuni okubba ekyokuwaayo ekyʼempeke, nʼaleeta nʼekitundu kimo kyokusatu ekyʼerita yʼobwito bwʼemizaituuni. ");
INSERT INTO gwr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Okabona eyamulangiriranga ati mulongoole yamuleetanga aamo nʼebyokuwaayobye ebyo omumaiso gange oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Awo okabona yakwatanga omoiza oku ntaama gidi entonto ensaiza, aamo nʼekitundu ekimo kyokusatu kidi ekyʼerita yʼobwito bwʼemizaituuni, nʼabiwaayo ngʼesadaaka eyʼokusoniya eibbengo, nʼabisiirya nʼabiica omumaiso gange nze oMusengwa, ni bibba sadaaka eyʼenjabulo egibasiirya ni baica. ");
INSERT INTO gwr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Yaabbanga nʼokusalira ontaama oyo omu kifo ekitukulye omu luuga lwʼeWeema yange nze Musengwa e gibasalira esadaaka eyʼokusoniya ekibbikibbi, nʼesadaaka egibooca yonayona. Esadaaka eyʼokusoniya ekibbikibbi yona yaabbanga yʼabakabona era ntukulye ino ooti sadaaka eyʼokusoniya eibbengo. ");
INSERT INTO gwr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Okabona yatoolangaku omusaaye gwʼesadaaka eyʼokusoniya eibbengo, nʼagusiiga oku kalege kʼekitwi ekyʼoku ndiiro ekyʼoyo ogubaaba okusuuca okubba omulongoole, nʼoku kinkumu ekyʼoku ngalo endiiro, nʼoku lunwe olunene olwʼoku kigerekye ekyʼoku ndiiro. ");
INSERT INTO gwr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Okabona yatoolangaku obwito obwʼemizaituuni, nʼabusuka omu kigalabaayo ekikye iye okabona ekyʼoku ngooda, ");
INSERT INTO gwr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","nʼatimya olunwerwe olwʼoku ndiiro omu bwito obuli omu kigalabaayokye ekyʼoku ngooda, nʼaswankira nʼolunwerwe obumo oku bwito obwo emirundi musanvu omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Okabona yatoolangaku obwito obusigairewo omu kigalabaayokye, nʼabusiiga oku kalege kʼekitwi kyʼoku ndiiro kyʼoyo ogubali okusuuca okubba omulongoole, nʼoku kinkumu kyʼengaloye eyʼoku ndiiro, nʼoku lunwe olunene olwʼoku kigerekye ekyʼoku ndiiro, nʼabusiiga e gyasiigire omusaaye gwʼesadaaka eyʼokusoniya eibbengo. ");
INSERT INTO gwr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Obwito obusigairewo omu kigalabaayokye, okabona yabusiiganga oku mutwe gwʼoyo ogubali kusuuca okubba omulongoole. Omu ngeri eyo okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba omulongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Okabona yaawangayo esadaaka eyʼokusoniya ekibbikibbi, nʼakola nʼomukolo ogwʼokusuuca omuntu okubba omulongoole kwʼoyo ogubali kusuuca okubba omulongoole. Oluzwanyuma lwʼekyo okabona yasalanga esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","nʼagiwaayo oku kyoto, aamo nʼekibawaayo ekyʼempeke era nʼakola omukolo gwʼokusuuca omuntu oyo okubba omulongoole, era nʼabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Neye omuntu oyo oweyaabbanga mudoobi nga tayezya okusuna ebyo byonabyona, yaabbanga nʼokuleeta omwana wa ntaama omusaiza okubba esadaaka eyʼokusoniya eibbengo, okugisiirya nʼokugiica okukola omukolo gwʼokusuuca omuntu oyo okubba omulongoole. Yaleeterangaku nʼekiro ooti moiza eyʼobusye obwʼengaano obusa obubatabwiryemu obwito obwʼemizaituuni olwʼekyokuwaayo ekyʼempeke, nʼaleeta nʼekitundu ekimo kyokusatu ekyʼerita yʼobwito. ");
INSERT INTO gwr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Era yaabbanga nʼokuleeta nʼempuuwu ibiri ooba enjiiwa entonto ibiri, kwebyo ekyayezya okusuna; omoiza yaabbanga sadaaka yʼokusoniya ekikole ekibbikibbi, nʼogondi nabba yeedi egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Oku lunaku olwo olwomunaana yaabbanga nʼokuleeta ebintu ebyo eeri okabona oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu olwʼokumusuuca okubba omulongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Okabona yaabbanga nʼokukwata omwana wa ntaama owʼesadaaka eyʼokusoniya eibbengo, nʼekimo kyokusatu ekyʼerita yʼobwito bwʼemizaituuni, nʼabisiirya nʼabiica omumaiso gange nze oMusengwa ngʼesadaaka eyʼenjabulo egibasiirya ni baica. ");
INSERT INTO gwr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Yasalanga omwana wa ntaama owʼesadaaka eyʼokusoniya eibbengo, nʼatoolaku omusaaye gwa ntaama oyo nʼagusiiga oku kalege kʼekitwi ekyʼoku ndiiro kyʼoyo ogubali kusuuca okubba omulongoole, nʼoku kinkumu kyʼoku ndiiro, nʼoku lunwe olunene olwʼoku kigerekye ekyʼoku ndiiro. ");
INSERT INTO gwr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Awo okabona yasukanga obumo oku bwito budi, omu kigalabaayokye, ");
INSERT INTO gwr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","nʼaswankira nʼolunwerwe olwʼoku ndiiro obumo oku bwito obwo obuli omu kigalabaayokye emirundi musanvu omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Era okabona yaabbanga nʼokutoolaku obumo oku bwito obwo obuli omu kigalabaayokye, nʼabusiiga adi e gyasiigire omusaaye gwʼesadaaka eyʼokusoniya eibbengo oku kalege kʼekitwi ekyʼoku ndiiro kyʼoyo ogubali kusuuca okubba omulongoole. Era nʼabusiiga nʼoku kinkumu kyʼoku ndiiro, nʼoku lunwerwe olunene olwʼoku kigerekye ekyʼoku ndiiro. ");
INSERT INTO gwr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Obwito obusigairewo omu kigalabaayo kya kabona, okabona yabusiiganga oku mutwe gwʼoyo ogubali kusuuca okubba omulongoole olwʼokukola omukolo gwʼokumusuuca okubba omulongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Awo nʼasadaaka empuuwu ooba enjiiwa entonto kwebyo omuntu oyo ekiyaabbanga ayezerye okusuna, ");
INSERT INTO gwr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","omoiza oku nyonyi egyo yaabbanga sadaaka eyʼokusoniya ekikole ekibbikibbi, nʼogondi nʼabba yeedi egibooca yonayona nʼateekaku nʼekyokuwaayo ekyʼempeke. Omu ngeri eyo okabona yaabbanga akolere omukolo gwʼokusuuca omuntu oyo okubba omulongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Ago niigo amateeka kwʼoyo yenayena eyaabbanga nʼekirwaire kyʼebigenge, era eyaabbanga tayezya okusuna ebyokuwaayo ebyetaagisya okukola omukolo gwʼokumusuuca okubba omulongoole.” ");
INSERT INTO gwr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","OMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Owemwalituuka omu kyalo kyʼe Kanani, ekimbawa inywe okubba ekyanywe okubwanywe, kaisi ni nsindika obulwaire bwʼolukuku ni lusaasaanira omu kimo oku bisito omu kyalo ekyo, ");
INSERT INTO gwr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","onanyere ekisito ekyo yaabbanga nʼokwaba nʼakobera okabona ati, ‘Ekisito kyange mulimu obulwaire obuli ooti bwʼolukuku.’ ");
INSERT INTO gwr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Okabona yalagiranga ni bawuluca ebintu byonabyona ebiri omu kisito ekyo, ngʼakaali okwingiramu okukebera olukuku olwo, kaisi tiwaabbaawo ekintu kyonakyona ekibalangirira okubba tikirongoole. Oluzwanyuma lwʼekyo okabona yaingiranga okukebera ekisito ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Yakeberanga olukuku oku bitempe, era owebyabbangaku ebivoomo ebyʼekiragala-lagala, ooba bitukuliikiriri ebiboneka okubba bingiraku omunda okuzwa oku ngulu kwʼekitempe ekyo, ");
INSERT INTO gwr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","okabona yaazwanga omu kisito ekyo, nʼakisibaku okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Oku lunaku olwomusanvu okabona yairanga nʼakebera tete ekisito ekyo. Olukuku owerwabbanga lusaasaaniire oku bitempe byʼenyumba gyʼekisito ekyo, ");
INSERT INTO gwr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","awo yalagiranga ni bawumpulamu amabbaale agaliku olukuku, ni bagamuma e nza wʼekibuga omu kifo e gibamuma ebitali birongoole. ");
INSERT INTO gwr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Era yalagiranga ni bakalakata oku bitempe omunda omu nyumba eyo, era ebibakalakatireku ni babimuma e nza wʼekibuga omu kifo e gibamuma ebitali birongoole. ");
INSERT INTO gwr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Awo ni bakwata amabbaale agandi ni bagairyawo omu kifo kya gadi agebatoiremu, era ni bakwata eitakali erindi ni bapuuya enyumba eyo. ");
INSERT INTO gwr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Olukuku owerwairangamu okuboneka omu nyumba eyo oluzwanyuma lwʼokuwumpulamu amabbaale gadi, era ngʼenyumba eyo bagikalakatire ni bagipuuya, ");
INSERT INTO gwr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","okabona yairangayo nʼagikebera. Singa obulwaire bwʼolukuku bwabbanga busaasaaniire omu kisito ekyo, obwo bwabbanga bulwaire bwʼolukuku, era ekisito ekyo kyabbanga tikirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Bakivunangawo, amabbaale gʼenyumba egyo nʼembaabo nʼeitakali eribapuuyireku babitwalanga e nza wʼekibuga omu kifo e gibamuma ebitali birongoole. ");
INSERT INTO gwr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Era nabuli eyaingiranga omu kisito ekyo nga kikaali kisibeku, yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Nabuli eyagonanga omu nyumba eyo ooba eyagiriirangamu, yaabbanga nʼokwoza ebizwalobye. ");
INSERT INTO gwr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Neye okabona oweyaizanga nʼakebera ekisito ekyo kaisi nʼayajirya ngʼobulwaire bwʼolukuku obwo tibusaasaanire oluzwanyuma lwʼokupuuya enyumba gyamu, yakirangiriranga okubba kirongoole, olwʼokubba obulwaire bwabbanga buwoiremu. ");
INSERT INTO gwr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Olwʼomukolo gwʼokusuuca ekisito ekyo okubba kirongoole, okabona yakolesyanga enyonyi ibiri, nʼakasaale kʼomuvule, nʼewuuzi entukuliikiriri, nʼakasaga kʼekisaale ekibeeta oyisopu. ");
INSERT INTO gwr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Yasaliranga omoiza oku nyonyi egyo omu kibya ekirimu amaizi agʼomwiruba. ");
INSERT INTO gwr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Awo yakwatanga akasaale akʼomuvule, nʼakasaga ka yisopu, nʼewuuzi entukulikiiriri nʼonyonyi odi omwomi, nʼabitimya omu musaaye gwa nyonyi odi ogwasalire, nʼomu maizi gadi agʼomwiruba, kaisi nʼaswankira omusaaye ogwo omu nyumba eyo emirundi musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Atyo weyasuucanga enyumba eyo okubba nnongoole ngʼakolesya omusaaye gwa nyonyi ogwasalire, nʼamaizi gadi agʼomwiruba, nʼonyonyi odi omwomi nʼakasaale kadi akʼomuvule, nʼakasaga ka yisopu, nʼewuuzi entukuliikiriri. ");
INSERT INTO gwr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Era awo yateereranga onyonyi oyo omwomi e nza wʼekibuga nʼaguluka nʼayaba. Omu ngeri eyo yaabbanga akolere omukolo gwʼokusuuca ekisito ekyo okubba kirongoole era kyabbanga kirongoole.” ");
INSERT INTO gwr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Ago niigo amateeka agʼokusengereryanga agakwata oku bulwaire bwʼengeri yonayona eyʼebigenge, nʼomubiri ogusiya, ");
INSERT INTO gwr_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","nʼobulwaire bwʼolukuku omu lugoye nʼomu nyumba, ");
INSERT INTO gwr_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","nʼokubbimba, nʼokufulukuka ooba ekyeyokyerye oku lususu, ");
INSERT INTO gwr_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","okutegeera ngʼekintu kirongoole ooba tikirongoole. Ago niigo amateeka agakwata oku bulwaire bwʼebigenge nʼobwʼolukuku. ");
INSERT INTO gwr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","OMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Mutumule nʼaBaisirairi era mubakobe muti omusaiza yenayena oweyaazwangamu amasira olwʼobulwaire bwʼenziku, yaabbanga timulongoole omumaiso gange nze Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Newankubbaire ngʼamasira ago geeyongeranga okumuzwamu ooba gaabbanga galekeiraawo era gamusuucanga okubba timulongoole. Enu niiyo engeri amasira ago agamuzwamu owegaleeta obutali bulongoole: ");
INSERT INTO gwr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Nabuli buliri omusaiza oyo azwamu amasira obuyagonangaku bwabbanga tibulongoole, era nabuli kintu ekiyatyamangaku, kyabbanga tikirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Era nabuli eyakwatanga oku buliri bwʼomusaiza oyo, yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Era omuntu yenayena eyatyamanga oku kintu kyonakyona omusaiza oyo azwamu amasira ekyatyaimeku, yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Era omuntu yenayena eyakwatanga oku musaiza oyo azwamu amasira, yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Omusaiza oyo azwamu amasira oweyayandanga ebitanta oku muntu omulongoole, omuntu oyo omulongoole yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Nabuli kintu omusaiza oyo ekiyatyamangaku ngʼali oku ndogoyi ooba ompunda, kyabbanga tikirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Era omuntu yenayena eyakwatanga oku kintu kyonakyona omusaiza oyo ekyatyaimeku, yaabbanga timulongoole paka igulo. Era nʼoyo eyakiginganga, yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Omuntu yenayena, omusaiza oyo azwamu amasira oguyakwatangaku nga tasookere kunaaba mu ngalo, ogubakwaiteku oyo yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Ensaka omusaiza oyo azwamu amasira egiyakwatangaku, baabbanga nʼokugyata. Era eitiba lyonalyona eriyakwatangaku, baabbanga nʼokulinaabya. ");
INSERT INTO gwr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Omusaiza azwamu amasira oweyalamanga, yamalanga enaku musanvu kaisi ni bakola omukolo gwʼokumusuuca okubba omulongoole. Yaabbanga nʼokwoza engoyegye, nʼanaaba amaizi agʼomwiruba agatukula, kaisi nʼabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Oku lunaku lwomunaana, yaabbanga nʼokusuna empuuwu ibiri, ooba enjiiwa entonto ibiri, nʼayaba omumaiso gange nze oMusengwa oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu, nʼagiwa okabona. ");
INSERT INTO gwr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Okabona yaabbanga nʼokugisadaaka, omoiza nʼabba sadaaka egibawaayo olwʼokusoniya ekibbikibbi, nʼogondi nʼabba sadaaka egibooca yonayona. Omu ngeri eyo niiyo okabona egiyakolangamu omukolo ogwʼokusuuca omusaiza oyo okubba omulongoole omumaiso gange nze oMusengwa, olwʼokuzwamu amasira. ");
INSERT INTO gwr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Omusaiza oweyazwangamu amaizi agʼekisaiza, yaabbanga nʼokunaaba omubiri gwonagwona, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Olugoye lwonalwona ooba ekintu ekyʼeidiba, amaizi agʼekisaiza okugatoonyere, baabbanga nʼokubyoza, ni bisigala nga tibirongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Omusaiza nʼomukali owebeegaitanga omusaiza nʼazwamu amaizi gʼekisaiza, bonabona baabbanga nʼokunaaba, ni basigala nga tibalongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Omukali oweyaabbanga omu nsonga gyʼekikali, yamalanga enaku musanvu nga timulongoole. Era nabuli eyamukwatangaku, yaabbanga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Ekintu kyonakyona ekiyagonangaku ooba ekiyatyamangaku, omu biseerabye ebyʼokubba omu nsonga gyʼekikali, kyabbanga tikirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Nabuli eyakwatanga oku buliri bwʼomukali oyo, yayozanga ebizwalobye, nʼanaaba, era nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nabuli eyakwatanga oku kintu kyonakyona ekyatyaimeku, yayozanga ebizwalobye, nʼanaaba, era nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Waire buliri ooba ekintu kyonakyona ekyabbaire atyaimeku, omuntu yenayena oweyakikwatangaku, yaabbanga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Omusaiza oweyeegaitanga nʼomukali oyo, omusaaye ogumuzwamu ngʼali omu nsonga gyʼekikali ni gutoonya oku musaiza oyo, yaabbanga timulongoole okumala enaku musanvu, era nabuli buliri obuyagonangaku, bwabbanga tibulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Omukali oweyasukanga omusaaye enaku enyingi omu biseera ebitali byʼokubba omu nsonga gyʼekikali, ooba oweyeeyongeranga okusuka omusaaye ngʼenakugye egyo giwoireku, yaabbanga timulongoole eibbanga lyonalyona eriyamalanga ngʼasuka omusaaye, ngʼowaatabba mulongoole omu biseerabye ebyʼokubba omu nsonga gyʼekikali. ");
INSERT INTO gwr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Nabuli buliri obuyagonangaku ngʼakaali asuka omusaaye, bwabbanga tibulongoole, ngʼobuliribwe owebubba ngʼali omu nsongagye egyʼekikali. Era nabuli kintu ekiyatyamangaku kyabbanga tikirongoole, ngʼowekibba ngʼali omu nsongagye egyʼekikali. ");
INSERT INTO gwr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Nabuli eyakwatanga oku bintu ebyo, yaabbanga timulongoole, era yayozanga ebizwalobye, nʼanaaba, nʼasigala nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Omukali oyo oweyalekerangaawo okusuka omusaaye, yakuumanga ni wabitawo enaku musanvu, olwo kaisi nabba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Oku lunaku lwomunaana, yasunanga empuuwu ibiri, ooba enjiiwa entonto ibiri, nʼagireeta eeri okabona oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Okabona yaabbanga nʼokuwaayo omoiza nga wʼesadaaka eyʼokusoniya ekikole ekibbikibbi, nʼogondi nga wʼesadaaka egibooca yonayona. Omu ngeri eyo niiyo okabona egiyakolangamu omukolo gwʼokusuuca omuntu oyo okubba omulongoole omumaiso ga Musengwa, olwʼobutali bulongoole bwʼomukali oyo okusuka omusaaye. ");
INSERT INTO gwr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Mutyo wemuli nʼokulabulanga aBaisirairi okulekanga okusemberera ebintu ebibasuuca okubba abatali balongoole, kaisi tibaafanga olwʼobutali bulongoole waabwe obubazweraku okubebenya eWeema yange nze oMusengwa eeri aakati mwibo.” ");
INSERT INTO gwr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Ago niigo amateeka agakwata oku musaiza azwamu amasira omu bitundubye ebyʼekyama, nʼoyo azwamu amaizi agʼekisaiza, ");
INSERT INTO gwr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","nʼomukali aali omu nsonga gyʼekikali, ooba omukali azwamu omusaaye, nʼomusaiza eyeegaitanga nʼomukali atali mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Awo oMusengwa nʼatumula nʼoMusa, ngʼabataane bʼAlooni ababiri bamalire okufa, owebasembereire oMusengwa omu ngeri etali ntuuce ni bafa. ");
INSERT INTO gwr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","OMusengwa nʼakoba oMusa ati, “Okobe Alooni omugandawo, obutamalanga gaiza nabuli owaatakiire okwingira omunda wʼolutimbe omu Kifo eKitukulye eIno, omumaiso wʼekisaanikiro kyʼeSanduuku iyo entebe ya Kibbumba onanyere okusaasira, nga nandi nʼakola atyo yalifa, olwʼokubba mbonekera omu kireri angulu wʼekisaanikiro ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Alooni yaingiranga omu Kifo eKitukulye nʼonte okitobba owʼesadaaka eyʼokusoniya ekikole ekibbikibbi, nʼontaama omusaiza owʼesadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Yaabbanga nʼokusooka kunaaba kaisi nʼazwala ebbeketera eya lineni, nʼepajama eya lineni; ali nʼokwesiba omusibiro ogwa lineni, ni yeesiba nʼekitambaala ekya lineni ekyʼoku mutwe ekyʼobwakabona. Egyo niigyo engoye gyʼobutukulye. ");
INSERT INTO gwr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Era yaabbanga nʼokwaba nʼembuli empanya ibiri okuzwa omu kibbula kyonakyona ekyʼaBaisirairi, egyʼesadaaka eyʼokusoniya ekibbikibbi, nʼontaama omusaiza owʼesadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Alooni yaawangayo okitobba oodi okubba sadaaka eyʼokusoniya ekikolekye ekibbikibbi, nʼakola omukolo gwʼokumusuuca iye onanyere okubba mulongoole nʼabʼomu nyumbaye. ");
INSERT INTO gwr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Awo yakwatanga embuli gidi eibiri nʼagiwaayo omumaiso gange nze oMusengwa oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Embuli eibiri Alooni yagikubbirangaku akalulu okulondaku eyaabba owange nze oMusengwa, nʼoyo eyaabba owʼAzazeeri. ");
INSERT INTO gwr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Alooni yakwatanga ombuli akalulu ogukagwireku okubba owange nze oMusengwa nʼamuwaayo okubba sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Neye ombuli akalulu ogukagwireku okubba wʼAzazeeri, bamuwangayo mwomi omumaiso ga Musengwa, olwʼokusuuca abantu okubba balongoole, ni bamwereekererya omwidungu eeri Azazeeri. ");
INSERT INTO gwr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Alooni yaleetanga onte odi okitobba nʼamuwaayo okubba esadaaka eyʼokusoniya ekikolekye ekibbikibbi olwʼokumusuuca iye onanyere okubba mulongoole nʼabʼomu nyumbaye. ");
INSERT INTO gwr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Yaabbanga nʼokutwala ekyokuduunyisiryaku obubbaani ekiizwire amakala agaliku omusyo omumaiso gange nze oMusengwa, nʼebigalo bibiri ebyʼobubbaani obusoice obwʼakaloosa, nʼabireeta omunda wʼolutimbe omu Kifo eKitukulye eIno. ");
INSERT INTO gwr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Awo yateekanga obubbaani obwo oku musyo omumaiso ga Musengwa, era omwosi gwʼobubbaani ni gubbuunaku ekisaanikiro kyʼeSanduuku iyo entebe ya Kibbumba onanyere okusaasira tiyakibona, kaisi tiyaafa. ");
INSERT INTO gwr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Yatoolangaku omusaaye gwa nte odi okitobba, nʼaguswankira nʼolunwerwe omumaiso wʼekisaanikiro kyʼeSanduuku iyo entebe ya Kibbumba onanyere okusaasira, kaisi nʼaguswankira era nʼolunwerwe emirundi musanvu ansi omumaiso gʼeSanduuku eyo. ");
INSERT INTO gwr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Era yasalanga ombuli owʼesadaaka eyʼokusoniya ekikole kyʼabantu ekibbikibbi, nʼatwala omusaaye gwa mbuli oyo omunda wʼolutimbe omu Kifo eKitukulye eIno, nʼaguswankira ngʼowaakolere gudi ogwa nte odi okitobba. Yaguswankiranga oku kisaanikiro kyʼeSanduuku iyo entebe ya Kibbumba onanyere okusaasira nʼomumaiso gʼeSanduuku eyo. ");
INSERT INTO gwr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Omu ngeri eyo yaabbanga akolere omukolo gwʼokusuuca eKifo eKitukulye eIno okubba kirongoole, olwʼobutali bulongoole nʼobujeemu bwʼaBaisirairi olwʼebikole ebibbibibbi ebyʼengeri yonayona. Era yaabbanga nʼokukola mu ngeri nanyere eyo nʼoku Weema eyʼoKunsisinkanirangamu, ebba omu mankati gaabwe ibo abatali balongoole. ");
INSERT INTO gwr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Mpaawo muntu eyaabbanga omu Weema eyʼoKunsisinkanirangamu, okuzwera omu kiseera Alooni ekiyangiriranga omu Kifo eKitukulye eIno okukola omukolo ogwʼokulongoola, paka ekiyawulukirangamu ngʼamalire okukola omukolo gwʼokumusuuca okubba omulongoole, nʼabʼenyumbaye, nʼaBaisirairi bonabona. ");
INSERT INTO gwr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Awo yawulukanga nʼayaba oku kyoto omumaiso gange nze oMusengwa, nʼakola omukolo gwʼokukisuuca okubba kirongoole. Yatoolangaku omusaaye gwa nte odi okitobba, nʼogwa mbuli odi, nʼagusiiga oku maziga gonagona agʼekyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Era omusaaye ogwo ogundi yaguswankiranga oku kyoto ekyo ngʼakolesya olunwerwe emirundi musanvu, nʼakola omukolo ogwʼokukisuuca okubba ekirongoole nʼakitoola omu butali bulongoole bwʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Alooni oweyamalanga okukola omukolo gwʼokusuuca eKifo eKitukulye eIno, nʼeWeema yʼoKusisinkanirangamu oMusengwa okubba birongoole, nʼekyoto, yaawangayo ombuli odi omwomi. ");
INSERT INTO gwr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Yateekanga engalogye gyombi oku mutwe gwa mbuli oyo, nʼamubbutuliraku obubbibubbi nʼobujeemu bwʼaBaisirairi, ekikoba kiti, ebikole ebibbibibbi byabwe byonabyona omu ngeri eyo nʼabba abiteekere ku mutwe gwa mbuli oyo. Awo yatumanga omuntu omulonde nʼayereekererya ombuli oyo omwidungu. ");
INSERT INTO gwr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ombuli oyo yatwalanga ebibbibibbi byabwe byonabyona, nʼayaba nabyo omu kifo ekinambulamu bantu. Era omuntu odi ayereekereirye ombuli oyo yamuteereranga omwidungu nʼayaba. ");
INSERT INTO gwr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Awo Alooni yaingiranga omu Weema yʼoKunsisinkanirangamu, ni yeeyambulyamu ebizwalo bya lineni bidi ebiyaabbanga azwaire ngʼagira omu Kifo eKitukulye eIno, nʼabireka omwo. ");
INSERT INTO gwr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Yanaabiranga omu Kifo eKitukulye, nʼazwala ebizwalobye ebya bulijo. Awo nʼawuluka, nʼawaayo esadaaka egibooca yonayona oku lwʼebikolebye ebibbibibbi, nʼesadaaka eyʼokusoniya ekikole kyʼabantu ekibbikibbi olwʼokukola omukolo gwʼokumusuuca iye okubba omulongoole era nʼabantu nago. ");
INSERT INTO gwr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Era yaabbanga nʼokwocerya amasavu gʼesadaaka olwʼokusoniya ekibbikibbi oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Omuntu eyayereekereryanga ombuli omwidungu eeri Azazeeri, yaabbanga nʼokwoza ebizwalobye, nʼanaaba omubiri, olwo kaisi nʼayezya okwingira omu nkambi. ");
INSERT INTO gwr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Onte odi okitobba nʼombuli ebyʼesadaaka eyʼokusoniya ekikole ekibbikibbi, omusaaye gwayo ogubaleetere omu Kifo eKitukulye eIno olwʼokukola omukolo ogwʼokusuuca abantu okubba abalongoole, baabbanga nʼokuwuluca enyama eyo e nza wʼenkambi, nʼamadiba gaayo, nʼenyama nʼebinamukida, ni babyoca. ");
INSERT INTO gwr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Oyo abyoca yayozanga ebizwalobye, nʼanaaba omubiri, olwo kaisi nʼayinza okwira omu nkambi. ");
INSERT INTO gwr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Eiteeka linu mwalikuumanga emirembe gyonagyona. Oku lunaku olweikumi olwʼomweri gwomusanvu, mwebonerezanga era nandi ni mukola omulimo gwonagwona, ekikoba kiti, inywe aBaisirairi ooba abanamawanga abatyama mwinywe. ");
INSERT INTO gwr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ekyo kityo olwʼokubba oku lunaku olwo, waabbangawo omukolo gwʼokubasuuca okubba abalongoole okubatoola omu bikole byanywe ebibbibibbi. Awo kaisi ni mubba balongoole okuzwa omu bikole byanywe ebibbibibbi omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Olunaku olwo yaabbanga Saabbaato nga lwa kuwuumula, era nga muli nʼokwebonereza; Eiteeka eryo lyabbanga lyʼenkalaakalira. ");
INSERT INTO gwr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Okabona ogubasuukireku amafuta ni bamwawula okusikira oiteeye ngʼokabona akira obukulu, niiye eyakolanga omukolo gwʼokusuuca abantu okubba abalongoole. Yazwalanga ebizwalo byobutukulye ebibatungire omu lineni, ");
INSERT INTO gwr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","kaisi nʼakola omukolo gwʼokusuuca eKifo eKitukulye eIno, nʼeWeema eyʼoKunsisinkanirangamu nʼekyoto okubba kirongoole, era nʼokusuuca abakabona, nʼaBaisirairi bonabona okubba abalongoole. ");
INSERT INTO gwr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Ago gaabbanga amateeka agaabbanga agʼenkalaakalira agʼokukolanga omukolo gwʼokusuuca aBaisirairi okubba balongoole ni babasoniya ebikole byabwe ebibbibibbi byonabyona, ogwabbangawo omulundi ogumo nabuli mwanka.” Era Alooni nʼakola ngʼoMusengwa oweyalagiire. ");
INSERT INTO gwr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Otumule nʼAlooni nʼabataane, nʼaBaisirairi bonabona, obakobe oti, ‘Kinu niikyo nze oMusengwa ekyalagiire: ");
INSERT INTO gwr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","OMwisirairi yenayena eyasadaakiranga omu nkambi ooba e nza waayo onte ooba ontaama, ooba ombuli, ");
INSERT INTO gwr_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","omu kifo kyʼokumuleeta ku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa nʼamuwaayo ngʼekyokuwaayo eeri nze oMusengwa omumaiso gʼeWeema yange, omuntu oyo bamuvunaananga omusango gwʼokusuka omusaaye. Yaabbanga asukire omusaaye era tinamubalange okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Ekyo kityo kaisi, aBaisirairi bakomye okusadaakiranga omu nkambi ooba e nza waayo. Neye babbenge nʼokubireeta eeri kabona, kaisi iye nʼabiwaayo eeri nze oMusengwa, oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu, ni bibba sadaaka eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Era okabona yaswankiranga omusaaye ogwʼesadaaka eyo oku kyoto kyange nze oMusengwa, ekiri oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu, era nʼayoca amasavu gaayo, okuzwamu oluvululu olunsangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","ABaisirairi bali nʼokukomya okuwangayo esadaaka yonayona eeri emizimu egibasinza egiri omu kifaananyi kya mbuli, igyo egibasinza. Era eiteeka eryo aBaisirairi balikuumanga emirembe nʼemirembe.’ ");
INSERT INTO gwr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Era obakobe oti, ‘OMwisirairi yenayena, ooba omunamawanga yenayena atyama mwinywe, eyaawangayo esadaaka egibooca yonayona ooba esadaaka eyʼengeri engendi yonayona, ");
INSERT INTO gwr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","nandi nʼagireeta kugiwaayo eeri ninze oMusengwa oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu, tinamubalenge okubba moiza oku bantu bange.’ ");
INSERT INTO gwr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘OMwisirairi yenayena, ooba omunamawanga yenayena atyama mwinywe eyaalyanga omusaaye, ekikoba kiti, omuntu oyo eyaalyanga omusaaye, namukubbiranga mugongo era tinamubalirenge omu bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ekyo kityo olwʼokubba obwomi obwa buli kibbumbe, bubba mu musaaye. Kagira nabaikiriirye mugukolesyenge oku kyoto omu kukola omukolo ogwʼokusuuca abantu okubba balongoole. Omusaaye niigwo ogubakolesya omu mukolo gwʼokusuuca obwomi bwʼomuntu okubba bulongoole omumaiso gange.’ ");
INSERT INTO gwr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nʼolwekyo nkoba aBaisirairi nti, ‘Tiwaabbangawo omuntu mwinywe alya omusaaye, waire munamawanga atyama mwinywe eyaalyanga omusaaye.’ ");
INSERT INTO gwr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Omwisirairi yenayena, ooba omunamawanga atyama omu Baisirairi, eyayiiganga okisolo ooba onyonyi ogubaikirirya okulya, yakenenulangamu omusaaye, nʼaguliikaku eitakali, ");
INSERT INTO gwr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","olwʼokubba obwomi bwa buli kibbumbe, bubba mu musaaye gwakyo. Kagira nkoba aBaisirairi nti, timuli nʼokulyanga omusaaye gwʼekibbumbe kyonakyona, olwʼokubba omusaaye gwa buli kibbumbe niigwo obwomi bwakyo. Omuntu yenayena eyagulyanga, baabbanga tibamubala okubba moiza oku bantu bange.’ ");
INSERT INTO gwr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Omuntu yenayena, ooba mubyalwa, ooba munamawanga, omu Baisirairi, eyalyanga ekintu kyonakyona ekifeereireku omutwe, ooba ebisolo byʼomu kigona ebikiitire, yayozanga ebizwalobye, nʼanaaba, era yasigalanga nga timulongoole omumaiso ga Musengwa paka igulo, neye oluzwanyuma yaabbanga mulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Neye singa tiyayozenge ebizwalobye, era nandi nʼanaaba, yaabbanga abbengere.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Otumule nʼaBaisirairi era obakobe oti, ‘Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Timwebityanga ooti bantu bʼomu kyalo kyʼe Misiri eeyo e gimwabbaire abatyami, era timwebityanga ooti bantu bʼomu kyalo kyʼe Kanani, e kimbatwalamu. Timwasengereryanga obulombolombo bwabwe. ");
INSERT INTO gwr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Muli nʼokukwatanga amateeka gange, nʼokugonderenga ebiragiro byange. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Mugonderenge ebiragiro byange era mukwatenge amateeka gange. Ekyo kityo olwʼokubba nabuli muntu, eyakolanga ekyo yaabbanga mwomi. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Tiwaabbangawo omuntu yenayena mwinywe, eyeegaita nʼomuntu yenayena amuliku oluganda olwʼokumpi. Ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Toyemulanga oiteewo ni weegaita nʼomaawo. Oyo maawo; tiweegaitanga naye. ");
INSERT INTO gwr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Tiweegaitanga nʼomuka iteewo; ekyo kyemula oiteewo. ");
INSERT INTO gwr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Tiweegaitanga nʼomwonyokowo, ooba omwonyokowo okwiteewo, ooba omwonyokowo oku maawo, nʼowebabba bamubyaliire mu kidaala kimo na iwe ooba wandi. ");
INSERT INTO gwr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Tiweegaitanga nʼomwala wʼomutaanewo ooba omwala wʼomwalawo; ekyo kyemula. ");
INSERT INTO gwr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Tiwegaitanga nʼomwala wa muka iteewo, oiteewo oguyabyaire, oyo mwonyokowo. Tiweegaitanga naye. ");
INSERT INTO gwr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Tiweegaitanga nʼomwonyoko wa iteewo olwʼokubba oyo isengawo. ");
INSERT INTO gwr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tiweegaitanga nʼomuganda wa maawo, olwʼokubba oyo maawo omuto. ");
INSERT INTO gwr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Toyemulanga oiteewo omuto ni weegaita nʼomukaliwe. Oyo yena aabba maawo. ");
INSERT INTO gwr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Tiweegaitanga nʼomuka mutaanewo. Olwʼokubba oyo mulyawo, tiweegaitanga naye. ");
INSERT INTO gwr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Tiweegaitanga nʼomuka mugandawo; ekyo kyemula omugandawo. ");
INSERT INTO gwr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tiweegaitanga nʼomukali ni weegaita nʼomwalawe. Tiweegaitanga nʼomwala wʼomutane wʼomukali oyo waire mwala wa mwalawe; olwʼokubba abo bʼomusaaye gumo nʼomukali oyo. Ekyo kibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Tiwafumbirwanga omuganda wʼomukaliwo ni babba baalikwa, ni weegaita naye, ate ngʼomukaliwo akaali mwomi.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Tiweegaitanga nʼomukali ngʼali omu nsonga gyʼekikali, olwʼokubba abba timulongoole omumaiso gange nze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Tiweegaitanga nʼomuka musaiza; ekyo kikusuuca atali mulongoole omumaiso gange nze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Tiwaawangayo omwanawo yenayena okumusadaaka eeri onkuni oMoleki, olwʼokubba toli nʼokuswaza eriina lya Kibbumbawo. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Tiweegaitanga nʼomusaiza omwinawo ngʼoweweegaita nʼomukali; ekyo kyomuliko.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Tiweegaitanga nʼokisolo, olwʼokubba ekyo kikusuuca okubba timulongoole omumaiso gange nze oMusengwa. Omukali tali nʼokwikirirya okwegaita nʼokisolo; ekyo kyomuliko.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Timweretangaku obutali bulongoole obwʼengeri yonayona kwegyo, olwʼokubba amawanga agenabbinga omu kyalo ekimwaingiramu gasuukire agatali malongoole mu ngeri eyo. ");
INSERT INTO gwr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Era nʼekyalo ekyo kyona kyasuukire ekitali kirongoole, kale ni nkibonereza olwʼekikole ekibbikibbi ekyʼabantu baamu abenabbingamu ni mba ooti mbasesemere-busesemi. ");
INSERT INTO gwr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Neye inywe muli nʼokugonderanga ebiragiro byange nʼokukwatanga amateeka gange. Ababyalwa nʼabanamawanga abatyama mwinywe tibali nʼokukolanga ekintu kyonakyona kwebyo ebyʼomuliko. ");
INSERT INTO gwr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ekyo kityo olwʼokubba ebintu ebyo byonabyona, abantu ababasookere inywe okutyama omu kyalo ekyo babikolanga, era ni basuuca ekyalo ekyo okubba ekitali kirongoole. ");
INSERT INTO gwr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Era singa mwalikisuuca okubba ekitali kirongoole, nalikibabbingamu ni mba ooti mbasesemere-busesemi ngʼowenakolere amawanga agabasookere okukityamamu.’ ");
INSERT INTO gwr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Nabuli eyakolanga ekintu kyonakyona kwebyo ebyomuliko, omuntu oyo tinamubalenge okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Kale mukuumenge amateeka gange, era timwasengereryanga akalombolombo konakona akʼebyomuliko ebyo abo ibo ababasookere inywe okutyama omu kyalo ekyo obubasengereryanga. Era inywe timusengereryanga obulombolombo obwo ni bubasuuca abatali balongoole. Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Otumule nʼaBaisirairi bonabona, era obakobe oti, ‘Mubbenge batukulye, olwʼokubba Nze oMusengwa iye oKibbumba waanywe ndi mutukulye. ");
INSERT INTO gwr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Nabuli moiza kwinywe ali nʼokuwanga omaaye nʼoiteeye ekitiisya, era ali nʼokukuumanga eSaabbaato yange. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Timwanzwangaku ni musinza ebifaananyi, ooba timwekoleranga ebifaananyi byʼabakibbumba omu byoma ebibasaanuucirye ni mubisinza. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Owemwawangayo esadaaka yʼokusyania eeri nze oMusengwa, mwagiwangayo mu ngeri esaaniire, kaisi ni ngiikirirya. ");
INSERT INTO gwr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Enyama eyo bagiriiranga ku lunaku olwo olumuweereireyo esadaaka, ooba ku lunaku olwiririraku; neye yonayona eyaabbanga esigaireku okutuuca oku lunaku lwokusatu, bagyocanga nʼesiirira nʼewaawo. ");
INSERT INTO gwr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Singa bagiryangaku oku lunaku lwokusatu, tiyaabbenge nnongoole, era tinaikiriryenge esadaaka eyo. ");
INSERT INTO gwr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Nabuli eyagiryangaku yaabbanga abbengere, olwʼokubebenyesya ekintu ekitukulye ekya Musengwa, era omuntu oyo tinamubalenge okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Owewakungulanga ebirime okwitakaliryo, tiwamalirangayo nakimo ebisembayo oku nsalo yʼomisirigwo, waire kukumbaania ebitontono ebyabbanga bisigairemu ngʼokungula. ");
INSERT INTO gwr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Omusirigwo ogwʼemizabbibbu tiwagumalirangamu nakimo ebineneka, nʼebyo ebyabbanga bisigairemu tiwabikumbaanianga. Obirekerenge abadoobi nʼabanamawanga. Ninze oMusengwa iye oKibbumbawo. ");
INSERT INTO gwr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Tiwaibbanga. “ ‘Tiwabbeyanga. “ ‘Timwabbeyangananga. ");
INSERT INTO gwr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Tiwalairanga omu liina lyange ebyobubbeyi olwʼebigendererwa ebinambulamu, otyo nʼoswaza eriina lyange nze oKibbumbawo. Ninze oMusengwa iye oKibbumbawo. ");
INSERT INTO gwr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Tiwalyakanga omwinawo, waire okumwibbaku ebibye.’ “ ‘Tikwairugalanga era ni kuca ngʼokaali okusasula omupakasi wʼolunaku.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Tiwalaamanga omasiipe, era tiwatigaliranga omwofu, neye ontyenge nze oKibbumbawo. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Tiwabbanga atali mwenkanya; tiwekubbiranga oku mudoobi ooba oku musuni. Neye olamulenge omwinawo mu bwenkanya.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Tiwasasyanga okalebule oku bainawo.’ “ ‘Tiwakolanga ekintu kyonakyona ekireeta akabbikabbi oku bwomi bwʼomwinawo. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Tiwacaawanga omugandawo ni wamwekwatirirya oku mwoyo. Obbutulirenge omwinawo ensobiye, kaisi nandi nʼogwa omu kibbikibbi olwʼensobiye.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Tiwanyaaŋanga waire okubba nʼekiruyi oku muntu yenayena, neye otakenge omwinawo ngʼoweweetaka iwe onanyere. Ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Okwatenge amateeka gange. “ ‘Tiwawakisyanga ebisolobyo oku bitali byʼekika ekimo. “ ‘Tiwasiganga omu musirigwo ensigo egyʼebika ebibiri. “ ‘Tiwazwalanga ekizwalo ekyʼebiwero ebyʼengeri eibiri. ");
INSERT INTO gwr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Singa omusaiza yeegaitanga nʼomugalama omwala, neye ngʼomugalama oyo ali nʼomusaiza amusuubizire okumufumbirwa neye ngʼakaali okusasula ebyokumununula, ooba ngʼakaali okubba muteere, abeegaitire abo baabbanga nʼokusuna ekibonerezo neye nga tikubaita, olwʼokubba omugalama omwala oyo abba akaali okubba muteere. ");
INSERT INTO gwr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Omusaiza oyo yaabbanga nʼokundeetera ontaama omusaiza oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu okubba esadaaka eyʼokusoniya eibbengo. ");
INSERT INTO gwr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Okabona yakolesyanga esadaaka eyo, okukola omukolo gwʼokusuuca omusaiza oyo okubba mulongoole omumaiso gange, olwʼekikolekye ekyo ekibbikibbi, era namusoniyanga ekikolekye ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Owemwalituuka omu kyalo kyʼe Kanani ni mukoma emisaale gyʼebineneka egya buli ngeri, ebineneka byagyo mwabitwalanga okubba tibirongoole okumala emyanka misatu era timwabiryanga. ");
INSERT INTO gwr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Omu mwanka ogwokuna, ebineneka byagyo byonabyona byabbanga bitukulye ni mubiwaayo okubba ekibawaayo eeri nze oMusengwa okumpuuja. ");
INSERT INTO gwr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Neye omu mwanka ogwokutaanu, mwayezyanga okulya oku bineneka byagyo. Owemwalituukirirya ebintu ebyo, amakungula gaanywe galyeyongeranga ni gabba mangi. Ninze oMusengwa iye oKibbumba waanywe.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Timwalyanga enyama yonayona ekaali erimu omusaaye.’ “ ‘Timwakolanga ebyeirogo, waire kulagula.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Timwamwanga ebigooli, waire okukeketa emirevu gyanywe.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Timwasalanga oku mibiri gyanywe nga mukunga abafu, waire ekwewolaku enzola. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Timwaswazanga abaala baanywe ni mubasindika omu bumalaaya, owemwakolanga ekyo kyazwerangaku abantu omu kyalo ekyo okusuuka abalendi, nʼekyalo ekyo ni kiizula obwonoonoki.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Muli nʼokukuumanga eSaabbaato yange, era muwenge eWeema yange ekitiisya. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Timwabanga okwebuulyaku abafumu, waire abalaguli, olwʼokubba babaleetera okwonoonoka. Ninze oMusengwa iye oKibbumba waanywe.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Musetukenge ni mwemerera okuwa abakaire ekitiisya era muntyenge nze oKibbumba waanywe. Ninze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Omunamawanga eyaabbanga nʼobutyami omu kyalo kyanywe, timwamubityanga kubbikubbi. ");
INSERT INTO gwr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Omunamawanga atyama na inywe omu kyalo kyanywe mumubityenge ngʼomubyalwa wʼomu kyalo kyanywe. Mumutakenge ngʼowemwetaka abananyere, olwʼokubba nywena mwabbaire banamawanga omu kyalo kyʼe Misiri. Ninze oMusengwa iye oKibbumba waanywe.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Tiwakolesyanga ebipima ebitali bituuce nga mupima obuwanvu, nʼobuzito ooba obungi bwʼebintu. ");
INSERT INTO gwr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Mukolesyenge minzaani entuuce nʼamabbaale gaaku amatuuce, nʼebipima ebintu ebikalu bibbenge bituuce, era nʼebipima ebintu ebisusuka ooti maizi bibbenge bituuce. Ninze oMusengwa iye oKibbumba waanywe eyabatoire omu kyalo kyʼe Misiri.’ ");
INSERT INTO gwr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Mukwatenge amateeka gange gonagona nʼebiragiro byange byonabyona, era mubituukiriryenge. Ninze oMusengwa.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","akobere aBaisirairi ati, “OMwisirairi yenayena ooba omunamawanga atyama omwIsirairi oweyaawangayo omwanawe okumusadaaka eeri onkuni oMoleki, baabbanga nʼokumwita. Abantu abʼomu kitundu ekyo omwatyama bamukubbanga amabbaale nʼafa. ");
INSERT INTO gwr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Era zena onanyere namukubbiranga omugongo era tinamubalirenge omu bantu bange, olwʼokubba okuwaayo omoiza oku baanabe eeri onkuni oMoleki, yaabbanga asuucirye eWeema yange okubba etali nnongoole, era nʼazumisya eriina lyange eritukulye. ");
INSERT INTO gwr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Neye singa abantu bʼomu kitundu ekyo tibaafengeyo oku musaiza oyo ngʼawaireyo omoiza oku baanabe eeri onkuni oMoleki, nandi ni bamwita, ");
INSERT INTO gwr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Nze nakubbiranga omuntu oyo omugongo nʼabantu abʼomu nyumbaye era tinamubalirenge omu bantu bange. Era nabityanga ntyo nʼabo bonabona abanzwangaku nze oMusengwa ni bamwegaitaku ni basinza onkuni oMoleki. ");
INSERT INTO gwr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“Singa omuntu yaabanga okwebuulyaku abafumu ooba abalaguli era nʼabaikiririryamu, nandi nabba mwesigwa gyendi, namukubbiranga omugongo era tineeyongerenge okumubala okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Nʼolwekyo mweyawulenge era mubbenge batukulye, olwʼokubba ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mukwatenge amateeka gange, era mugatuukiriryenge, olwʼokubba ninze oMusengwa, abasuuca okubba abatukulye. ");
INSERT INTO gwr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Omuntu yenayena eyazumanga oiteeye ooba omaaye, bamwitenge-bwiti. Nʼolwekyo eyazumanga oiteeye ooba omaaye yaabbanga yeitire yenkani. ");
INSERT INTO gwr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Singa omusaiza yayendanga nʼomuka mwinaye, abalendi abo bombi, omusaiza nʼomukali, babaitanga. ");
INSERT INTO gwr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Singa omusaiza yeegaitanga nʼomuka iteeye, yaabbanga ayemwire oiteeye. Bombi omusaiza oyo nʼomukali babaitanga. Niibo abaabbanga beitisirye bonkani. ");
INSERT INTO gwr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Singa omusaiza yeegaitanga nʼomulyawe, bombi babaitanga. Baabbanga bakolere kyomuliko, baabbanga beitisirye bonkani. ");
INSERT INTO gwr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Era singa omusaiza yeegaitanga nʼomusaiza omwinaye, ngʼoweyandyegaitire nʼomukali, baabbanga bakolere kyomuliko. Babaitanga, baabbanga beitisirye bonkani. ");
INSERT INTO gwr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Singa omusaiza yafumbirwanga omukali nʼomaaye wʼomukali oyo, ekyo kyabbanga kyomuliko. Omusaiza oyo, nʼabakali bombi, baboocanga ni bafa, kaisi ekibbikibbi ekyo ni mukyebbingaku. ");
INSERT INTO gwr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Singa omusaiza yeegaitanga nʼokisolo, bamwitanga era okisolo oyo yena mwamwitanga. ");
INSERT INTO gwr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Singa omukali onanyere yeewangayo ni yeegaita nʼokisolo, baitanga omukali oyo ni baita nʼokisolo oyo. Dala baabbanga nʼokwita omukali oyo nʼokisolo oyo, era yaabbanga yeitire yenkani, nʼokisolo yena. ");
INSERT INTO gwr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Singa omusaiza yafumbirwanga omwonyokowe, nga mwala wa iteeye ooba wa maaye, ni beegaita, ekyo kyabbanga kyobwemu. Bababbinganga omu bantu baabwe ni babagaana okukolagana nabo. Omusaiza oyo yaabbanga ayemwire omwonyoko, era bamubonerezanga. ");
INSERT INTO gwr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Singa omusaiza yeegaitanga nʼomukali ngʼali omu nsonga gyʼekikali, yaabbanga ayemwire omusaaye ogwo e gigubitira, era bombi bababbinganga omu kibbula kyʼabantu baabwe. ");
INSERT INTO gwr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Tiweegaitanga nʼomaawo omuto ooba oisengawo, olwʼokubba ekyo kyemula oluganda olwʼokumpi omu lulyo. Inywe mwembi bababonerezanga. ");
INSERT INTO gwr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Singa omusaiza yeegaitanga nʼomuka iteeye omuto, yaabbanga ayemwire oiteeye omuto, era iye nʼomukali oyo bababonerezanga, era balifa nga bawula abaana. ");
INSERT INTO gwr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Singa omusaiza yafumbirwanga omuka mugandawe, ekyo kyabbanga kikole kyʼobutali bulongoole, yaabbanga ayemwire omugandawe. Era balifa nga babula baana. ");
INSERT INTO gwr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Mukwatenge amateeka gange gonagona nʼebiragiro byange byonabyona era mubituukiriryenge, kaisi ekyalo ekimbatwalamu okutyamamu tinakibabbingamu ni mba ooti mbasesemere-busesemi. ");
INSERT INTO gwr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Timwasengereryanga obulombolombo bwʼamawanga agenjaba okubbinga omu kyalo ekyo inywe nga mukingiramu. Olwʼokubba basengereryanga obulombolombo obwo bwonabwona, kagira nabacaawire. ");
INSERT INTO gwr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Neye inywe nabasuubizire nti, mwalitwala ekyalo kyabwe olwʼokubba nalikibawa okubba omuwuluko gwanywe, ekyalo ekirimu ebyobusuni era ekiizwire amata nʼomujenene.” Ninze oMusengwa iye oKibbumba waanywe, eyabaawiire oku mawanga agandi. ");
INSERT INTO gwr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Kale muli nʼokwawulangawo ebisolo ebirongoole nʼebitali birongoole, nʼenyonyi ennongoole nʼegitali nnongoole. Timwasuukanga abatali balongoole olwʼokulya ebisolo nʼenyonyi egyo, waire ekintu ekindi kyonakyona ekitambulira okwitakali, ibyo ebinaawiirewo nti tibirongoole eeri inywe. ");
INSERT INTO gwr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Mwabbanga batukulye eeri Nze, olwʼokubba Nze oMusengwa ndi mutukulye, era nabaawiire oku mawanga agandi, kaisi mubbe bange kubwange. ");
INSERT INTO gwr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Omusaiza ooba omukali omufumu, ooba musamiri mwinywe, oyo baabbanga nʼokumwita. Mwabakubbanga amabbaale ni mubaita; niibo abananyere abaabbanga beitire bonkani.” ");
INSERT INTO gwr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, “Otumule nʼabakabona ibo abataane bʼAlooni, obakobe oti, ‘Tiwaabbangawo eyeeretaku obutali bulongoole olwʼokukwata oku mufu yenayena owʼomu bantube. ");
INSERT INTO gwr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Neye singa yaabbanga amuliku oluganda olwʼokumpi, ngʼomaaye ooba oiteeye, ooba omutaanewe ooba omwalawe, ooba omugandawe, ");
INSERT INTO gwr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ooba omwonyoko akaali okufumbirwa, ogwavunanyizibwa olwʼokubba abula oibaaye, yeesinganga nʼasuuka atali mulongoole olwʼokukwata oku mirambo gyabwe. ");
INSERT INTO gwr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Okabona tiyeeretangaku obutali bulongoole nʼakwata oku bafiire e buko.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Abakabona tibamwangaku enziiri oku mitwe gyabwe, waire okumwaku emirevu gyabwe, era tibasalanga ensalo oku mibiri gyabwe okulaga bati bakunga muntu. ");
INSERT INTO gwr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Bali nʼokubba batukulye eeri nze oKibbumba waabwe, era tibali nʼokuswaza eriina lyange nze oKibbumba waabwe. Ekyo kityo olwʼokubba niibo abawaayo ebyokuwaayo ebibooca nga bakiwaayo eeri nze oMusengwa, ekyokulya kyange nze oKibbumba waabwe, nʼolwekyo bali nʼokubba batukulye. ");
INSERT INTO gwr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Abakabona tibali nʼokufumbirwa abakali abatali balongoole ababbaire abamalaaya, ooba abakali abaibawaabwe abebabbingire, olwʼokubba abakabona ibo batukulye eeri nze oKibbumba waabwe. ");
INSERT INTO gwr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Kale mwababalanga okubba batukulye, olwʼokubba bawaayo eeri nze oKibbumba waanywe ekyokulya. Mwababalanga okubba batukulye, olwʼokubba Nze oMusengwa abatukulya inywe, ndi mutukulye. ");
INSERT INTO gwr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Omwala wa kabona oweyeeretangaku obutali bulongoole olwʼokusuuka omalaaya, yaabbanga ayemwire oiteeye. Baabbanga nʼokumwoca nʼafa. ");
INSERT INTO gwr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Okabona akira obukulu, nga niiye eyekubbembera abagandabe, era nga bamusukireku amafuta oku mutwe, ni bamwawula nʼazwalanga ebizwalo ebyʼobwakabona, tiyaabbenge nʼokuleka enziirigye nga tinsanyuluze, ooba okunyiira ebizwalobye okulaga ati akunga muntu. ");
INSERT INTO gwr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Tali nʼokwigerera e giri omulambo kaisi tikyamuzweraku okubba atali mulongoole, waire ngʼomulambo ogwo gwa iteeye ooba gwa maaye. ");
INSERT INTO gwr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Era eWeema yange nze oKibbumbawe tiyagizwangamu waire okugireetaku obutali bulongoole, olwʼokubba bamwawiire owebamusukireku amafuta gange nze oKibbumbawe. Ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Omukali okabona ogwafumbirwa ali nʼokubba muguna. ");
INSERT INTO gwr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Tali nʼokufumbirwa onamwandu, ooba omukali oibaaye oguyabbingire, ooba omukali atali mulongoole abbaire omalaaya, neye yafumbirwanga mukali akaali omuguna ngʼamutoola mu lulyo lwʼabakabona, ");
INSERT INTO gwr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kaisi tiyaleeta okwibyairerye obutali bulongoole omu bantube. Ninze Musengwa, iye amusuuca okubba omutukulye.” ");
INSERT INTO gwr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","akobere Alooni ati, “Omu mirembe gyonagyona owewaabbangawo omwibyaireryo aliku obuleme, tiyaigereranga okuwaayo ebyokulya eeri nze oKibbumbawe. ");
INSERT INTO gwr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mpaawo muntu aliku obuleme bwonabwona, eyaigereranga egyendi okumpeererya. Ekikoba kiti, omwofu, ooba omuleme, ooba aliku obugosi omu maiso, ooba aliku ekicaamu oku mubiri, ");
INSERT INTO gwr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","waire eyavunikire ekigere ooba engalo, ");
INSERT INTO gwr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ooba owʼeitumba, waire eyafubbire, ooba aliku obuleme bwonabwona oku liiso, ooba aliku obulwaire obwʼolususu, ooba eyatundukire amayeeye. ");
INSERT INTO gwr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Mpaawo wʼeibyaire lyʼAlooni okabona, aliku obuleme eyaigereranga okuwaayo ebyokuwaayo ebibooca nga bakiwaayo eeri nze oMusengwa. Era olwʼokubba aliku obuleme tiyaigereranga okuwaayo ekyokulya eeri nze oKibbumbawe. ");
INSERT INTO gwr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Owʼengeri eyo, ayinza okulya oku kyokulya ekitukulye eino era nʼekyokulya ekitukulye ekibawaayo eeri nze oKibbumbawe. ");
INSERT INTO gwr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Neye olwʼokubba aliku obuleme, tali nʼokwigerera okumpi nʼolutimbe oluli omu Weema yange, ooba okwigerera oku kyoto, olwo kaisi tiyaleetera eWeema eyo obutali bulongoole. Ninze oMusengwa, iye abasuuca okubba abatukulye.” ");
INSERT INTO gwr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Kale oMusa ebintu ebyo byonabyona nʼabikobera Alooni nʼabataane, nʼaBaisirairi bonabona. ");
INSERT INTO gwr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Okobe Alooni nʼabataanebe, bawenge ekitiisya ebyokuwaayo ebitukulye aBaisirairi ebibawonga egyendi, kaisi tibaswazanga eriina lyange eritukulye. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Era obakobe oti, ‘Omu mirembe gyonagyona, omuntu yenayena omwibyaire lyanywe, singa atali mulongoole yaigereranga oku byokuwaayo ebitukulye aBaisirairi ebibawonga egyendi, omuntu oyo baabbanga nʼokumukomya okuwererya omumaiso gange. Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Omuntu yenayena owʼomwibyaire lyʼAlooni alwaire obulwaire bwʼebigenge ooba azwamu amasira olwʼobulwaire bwʼenziku, tiyalyanga oku byokuwaayo ebitukulye, paka nga bakolere omukolo gwʼokumusuuca okubba mulongoole omumaiso gange nze oMusengwa. Era tiyaabbenge mulongoole oweyakwatanga oku kintu kyonakyona ekitali kirongoole ekiguunyire oku mulambo, ooba ngʼazwiremu amaizi agʼekisaiza, ");
INSERT INTO gwr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ooba oweyakwatanga oku kibbumbe kyonakyona ekyekuusira okwitakali ni kimusuuca atali mulongoole, ooba oweyakwatanga oku muntu yenayena amusuuca okubba atali mulongoole, nʼengeri yonayona eyʼobutali bulongoole. ");
INSERT INTO gwr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Iye oyo akwata oku bintu ngʼebyo yasigalanga nga timulongoole paka igulo. Tali nʼokulyanga oku byokuwaayo ebitukulye, okutoolaku ngʼamalire okunaaba omubiri. ");
INSERT INTO gwr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Eisana oweryabbanga ligwire, weyabbeeranga omulongoole, era awo ngʼayinza okulya oku byokuwaayo ebitukulye, olwʼokubba ebyo byokulyabye. ");
INSERT INTO gwr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Tali nʼokulyanga ekintu kyonakyona ekifeereireku omutwe, ooba ebisolo byʼomu kigona ebikiitire, kaisi tikyamusuuca okubba atali mulongoole. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Abakabona bali nʼokukuumanga ebiragiro byange, kaisi tibeereetangaku omusango ni bafa olwʼokutabigondera. Ninze oMusengwa, iye abasuuca abatukulye. ");
INSERT INTO gwr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Omuntu yenayena atali wʼomwibyaire lyʼobwakabona, waire mugeni wa kabona, ooba mupakasiwe tiyaalyanga oku byokuwaayo ebyo ebitukulye. ");
INSERT INTO gwr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Neye singa okabona yagulanga omugalama nʼempiiyagye, ooba singa omugalama bamubyaliranga omu kisito kya kabona, omugalama oyo yaalyanga oku kyokulya kya kabona. ");
INSERT INTO gwr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Singa omwala wa kabona yafumbirwanga omusaiza atali kabona, tiyaalyangaku ebyokuwaayo ebyo ebitukulye. ");
INSERT INTO gwr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Neye singa omwala wa kabona asuuka namwandu ooba oibaaye amubbinga ngʼabula omwana, nʼakanga okutyama omu kisito kya iteeye ngʼoweyabbaire ngʼakaali muvuvuka, yaalyanga oku kyokulya kya iteeye. Neye atali wʼomwibyaire lyʼobwakabona, tiyakiryangaku. ");
INSERT INTO gwr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Singa omuntu yaalyanga ekyokuwaayo ekitukulye nga tamaite ati niikyo, yasasulanga okabona ekyokuwaayo ekyo, nʼayongeraku nʼekimo kyokutaanu ekyʼekyokulya ekyo ekyaliire. ");
INSERT INTO gwr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ebyokuwaayo ebitukulye aBaisirairi ebibawaayo eeri nze oMusengwa, abakabona tibali nʼokubireeteranga okubba ebitali birongoole, ");
INSERT INTO gwr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","olwʼokwikirirya aBaisirairi okulyaku ebyokuwaayo ebyo, ni babaleetera omusango ogwaweesyanga aBaisirairi ekibonerezo. Ninze Musengwa asuuca ebyokuwaayo ebyo okubba ebitukulye.” ");
INSERT INTO gwr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Okobere Alooni nʼabataanebe, nʼaBaisirairi bonabona oti, ‘Singa oMwisirairi yenayena, ooba omunamawanga atyama omu kyalo kyʼe Isirairi, yaleetanga eeri nze oMusengwa esadaaka egibooca yonayona, okutuukirirya obweyamo, ooba ekyokuwaayo omu kwetakira, ");
INSERT INTO gwr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","yaabbanga nʼokuleeta onte onumi, ooba ntaama omusaiza, ooba mbuli ompanya abulaku obuleme kaisi ni njikirirya ekyokuwaayo ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Timwawangayo ekintu kyonakyona ekiriku obuleme, olwʼokubba tinakiikiriryenge. ");
INSERT INTO gwr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Omuntu yenayena oweyaawangayo eeri nze oMusengwa esadaaka eyʼokusyania okutuukirirya obweyamo, ooba ekyokuwaayo omu kwetakira, ngʼatoola ku nteegye ooba ku mbuligye, ekyayo ekyo kyabbanga kiri nʼokubba kibulaku obuleme, kaisi ni nkiikirirya. ");
INSERT INTO gwr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Timwawangayo eeri nze oMusengwa, okisolo omwofu, ooba eyavunikire, ooba omuleme, ooba aliku amabbwa agakulumuka, ooba omulwaire okwidiba. Ebisolo ebyʼengeri eyo timwabiwangayo oku kyoto, okubba ekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Neye muyinza okuwaayo onte ooba ontaama aliku ekitundu ekyalemaire, ooba eyafubbire, ngʼekyokuwaayo omu kwetakira, neye tinamwikiriryenge nga wʼokutuukirirya bweyamo. ");
INSERT INTO gwr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Timuli nʼokuwangayo eeri nze oMusengwa, okisolo ali nʼamayeeye agaliku ebimatulire, ooba agebatugunywire, ooba agaliku ebisimasime ooba okisolo ogubalaawire. Ekyo timuli nʼokukikolanga omu kyalo kyanywe. ");
INSERT INTO gwr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Era timuli nʼokwikiriryanga ebisolo ooti biibyo okuzwa eeri abanamawanga, ni mubiwaayo ngʼesadaaka eyʼekyokulya ekibampa nze oKibbumba waanywe. Tinabiikiriryenge oku lwanywe, olwʼokubba bibba biriku obucaamu era ni bibba byalemaire.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Onyana, ooba ontaama, ooba ombuli, owebamubyalanga, yasigalanga nʼomaaye okumala enaku musanvu. Okuzwa oku lunaku lwomunaana nʼokweyongerayo, namwikiriryanga ngʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Timwasadaakanga onte nʼonyanawe, ooba ontaama nʼomwanawe oku lunaku olunanyere olwo. ");
INSERT INTO gwr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Owemwawangayo eeri nze oMusengwa esadaaka olwʼokuneebalya, mwagiwangayo mu ngeri esaaniire kaisi ni ngiikirirya okulwanywe. ");
INSERT INTO gwr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Mwagiryanga ku lunaku lunanyere olwo. Timwagirekangaku paka eizo waaku. Ninze oMusengwa iye oKibbumba waanywe.” ");
INSERT INTO gwr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Mugonderenge ebiragiro byange, era mubituukiriryenge. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Timwaswazanga eriina lyange eritukulye. Inywe aBaisirairi muli nʼokumpanga ekitiisya ngʼowendi mutukulye. Ninze oMusengwa abasuuca okubba abatukulye, ");
INSERT INTO gwr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","era Ninze eyabatoire omu kyalo kyʼe Misiri, kaisi mbe Kibbumba waanywe. Ninze oMusengwa iye oKibbumba waanywe.” ");
INSERT INTO gwr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","atumule nʼaBaisirairi abakobe ati, “Enaku ginu niigyo enaku enkulu egyange nze oMusengwa, egimwalangiriranga okukumbaanirangaku okunsinza. ");
INSERT INTO gwr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Enaku giri mukaaga egimwakolerangamu emirimo, neye olunaku olwomusanvu, niiyo eSaabbaato irwo olunaku lwa kuwuumula, era olunaku lwʼokukumbaaniraku okunsinza. Timwakolanga omulimo gwonagwona; nabuli e gimwabbanga abatyami, era yaabbanga Saabbaato yʼokumperaku nze oMusengwa kitiisya. ");
INSERT INTO gwr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Ginu niigyo emikolo gyange nze oMusengwa, egimwakumbaanirangaku okunsinza, era e gimwabbanga nʼokulangirira ngʼebiseera byagyo bituukire. ");
INSERT INTO gwr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","OMukolo gwange nze oMusengwa ogwʼoKutambukirya, gwatandiikanga kanaigulo oku lunaku lweikumi naina, olwʼomweri ogusooka nabuli mwanka. ");
INSERT INTO gwr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Igwo oMukolo gwʼeMigaati eGibulamu oKazumbulukuca gwatandiikanga ku lunaku lweikumi nʼaitaanu olwʼomweri ogwo; era okumala enaku musanvu, mwalyanga migaati egibulamu okazumbulukuca. ");
INSERT INTO gwr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Oku lunaku olusooka olwʼemikolo egyo, mwabbanga nʼokuleka emirimo gyanywe gyonagyona ni mukumbaana okunsinza. ");
INSERT INTO gwr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Mwamalanga enaku musanvu nabuli lunaku nga muwaayo ekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. Era oku lunaku olwomusanvu, mwabbanga nʼokuleka emirimo gyanywe gyonagyona ni mukumbaana okunsinza.” ");
INSERT INTO gwr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","atumule nʼaBaisirairi, abakobe ati, “Owemwalituuka omu kyalo nze oMusengwa ekimbawa, ni mukungula ebimulimiremu, mwalitwaliranga okabona emiganda gyʼebirime byanywe ebyʼamakungula ameekeereri. ");
INSERT INTO gwr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Yasiiryanga nʼaica emiganda egyo omumaiso gange nze oMusengwa, kaisi inywe mbasiime; okabona yagisiiryanga oku lunaku olwiririra eSaabbaato eyo. ");
INSERT INTO gwr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Era oku lunaku olumwasiiriryangaku ni mwica emiganda egyo, mwabbanga nʼokuwangayo eeri nze oMusengwa esadaaka egibooca yonayona, eyʼomwana wa ntaama omusaiza, owʼomwanka ogumo abulaku obuleme. ");
INSERT INTO gwr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Era aamo nʼesadaaka eyo, mwawangayo nʼekyokuwaayo ekyʼempeke, ekyʼekiro ibiri egyʼobusye obwʼengaano obusa obubatabwiryemu obwito, nga niikyo ekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa ni kizwamu akaloosa akansangaalya. Era mwakiwangayo nʼekyokuwaayo ekyʼekyokunywa ekyʼerita moiza eyʼenviinyo. ");
INSERT INTO gwr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Timuli nʼokulyanga omugaati gwonagwona, ooba ekyokulya ekyʼempeke ekibasiikire ooba ekitali kisiike, paka ku lunaku olumwaleeterangaku ekyokuwaayo ekyo eeri nze oKibbumba waanywe. Eryo lyabbanga iteeka eryʼenkalaakalira, erimwakuumanga nabuli e gimwabbanga nʼobutyami, emirembe nʼemirembe. ");
INSERT INTO gwr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Mwabalanga esaabbiiti musanvu okuzwa oku lunaku olwiririra eSaabbaato, nga niirwo olunaku olumuleeteraku omuganda gwʼekyokuwaayo ekyʼenjawulo ekibasiirya ni baica kaisi ni muwaayo amakungula. ");
INSERT INTO gwr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Mwabalanga enaku 50 okutuuka oku Saabbaato eyomusanvu, kaisi ni muwaayo eeri nze oMusengwa ekyokuwaayo ekyʼempeke ekyʼamakungula ago. ");
INSERT INTO gwr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Okuzwa yonayona e gimwabbanga nʼobutyami mwaleetanga emigaati mibiri eeri nze oMusengwa, emisumbe omu kiro ibiri egyʼobusye obwʼengaano obusa, obulimu okazumbulukuca, ngʼekyokuwaayo ekyʼamakungula ameekeereri, ekyokuwaayo ekyʼenjabulo ekibasiirya ni baica omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Era aamo nʼemigaati egyo, mwawangayo entaama ensaiza musanvu egyʼomwanka ogumo egibulaku obuleme, nʼonte onumi okitobba moiza, nʼentaama ensaiza enkulu ibiri. Byabbanga sadaaka egibooca yonayona ni bagiwaayo eeri nze oMusengwa, aamo nʼekyokuwaayo ekyʼempeke nʼekyokuwaayo ekyʼekyokunywa; ekyo nga niikyo ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Era mwasadaakanga ombuli ompanya moiza, ngʼesadaaka eyʼokusoniya ekikole ekibbikibbi, nʼentaama entonto ibiri egyʼomwanka ogumo gumo, ngʼesadaaka eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Okabona yasiiryanga nʼaica entaama entonto eibiri egyo omumaiso gange nze oMusengwa, aamo nʼemigaati egibasumbire omu birime ebyekeereri, ni bibba sadaaka eyʼenjawulo egibasiirya ni baica. Esadaaka eyo egibampa nze oMusengwa ntukulye, era okabona niiye eyagitwalanga. ");
INSERT INTO gwr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Oku lunaku olwo mwalangiriranga okubba nʼolukumbaana olwʼokunsinza, era timwalukolerangaku emirimo gyonagyona. Eryo lyabbanga iteeka eryʼenkalaakalira, erimwakuumanga nabuli e gimwatyamanga, emirembe nʼemirembe. ");
INSERT INTO gwr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Owemwakungulanga ebimulimire okwitakali lyanywe, timwabimalirangamu nakimo okutuuka oku nsalo gyʼemisiri gyanywe, waire okulondeekererya ebitontono ebyabbanga bisigairemu nga mukungula. Mubirekerenge abadoobi nʼabanamawanga. Ninze oMusengwa iye oKibbumba waanywe.” ");
INSERT INTO gwr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Okobe aBaisirairi oti, ‘Olunaku olusooka olwʼomweri ogwomusanvu, lwabbanga lunaku lwʼokuwuumula, era waabbangawo olukumbaana olwʼokunsinza, olumwakulyanga ni mufuwa ino amakondeere. ");
INSERT INTO gwr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Timwakolenge omulimo gwonagwona, neye mwawangayo ekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Olunaku olweikumi olwʼomweri ogwomusanvu, Lunaku lwʼoMukolo gwʼokutoolawo oBusungu bwa Musengwa. Mwakolanga olukumbaana olwʼokunsinza, ni mwebonereza era ni muwaayo ekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Oku lunaku olwo, timwakolanga omulimo gwonagwona olwʼokubba lunaku lwʼomukolo gwʼokutoolawo obusungu bwange nze Musengwa, era lunaku lwʼokutoolawo obusungu bwange nze oMusengwa oKibbumba waanywe olwʼokubasoniya ebibbibibbi byanywe. ");
INSERT INTO gwr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Omuntu yenayena etiyeebonerezenge oku lunaku olwo, tinamubalenge okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Era omuntu yenayena eyakolanga omulimo oku lunaku olwo namutoolanga omu bantube aBaisirairi ni mmujigirica. ");
INSERT INTO gwr_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Timwakolanga omulimo gwonagwona naire. Eryo lyabbanga iteeka eryʼenkalaakalira, erimwakuumanga nabuli e gimwabbanga nʼobutyami, emirembe nʼemirembe. ");
INSERT INTO gwr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Yaabbanga Saabbaato nga lunaku inywe olumwawuumulirangaku, era mwabbanga nʼokwebonereza. ESaabbaato mwagitandiikanga okuzwa akanaigulo kʼolunaku lwomwenda omu mweri, okutuuca akanaigulo akʼolunaku olwiririraku.” ");
INSERT INTO gwr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Okobe aBaisirairi oti, ‘Oku lunaku olweikumi nʼaitaanu olwʼomweri ogwomusanvu, oMukolo ogwʼoBusiisira ogwange nze oMusengwa, wegwatandiikiranga era ni gumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Oku lunaku olusooka olwʼenaku egyo, mwakolanga olukumbaana olwʼokunsinza, era timwakolanga omulimo gwonagwona. ");
INSERT INTO gwr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Nabuli lunaku, omu naku egyo omusanvu, mwawangayo ebyokuwaayo ebibooca nga babiwaayo eeri nze oMusengwa, kaisi oku lunaku olwomunaana, ni mukola olukumbaana olwʼokunsinza, ni muwaayo nʼekyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. Olwo lwabbanga lukumbaana olwʼokunsinza olusembayo, era timwakolanga omulimo gwonagwona.’ ");
INSERT INTO gwr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Egyo niigyo emikolo, nze oMusengwa eginabalagiire, egimwalangiriranga ni mubba nʼenkumbaana egyʼokunsinza, ni muleetanga ebyokuwaayo ebibooca nga babiwaayo eeri nze oMusengwa, nʼesadaaka egibooca yonayona, nʼebyokuwaayo ebyʼempeke, nʼesadaaka egindi nʼebyokuwaayo ebyʼebyokunywa, ebyetagisyanga nabuli ku lunaku lwayo olutuuce. ");
INSERT INTO gwr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ebyokuwaayo ebyo byeyongereryanga ku biidi ebyʼeSaabbaato yange nze oMusengwa, era nʼoku birabo byanywe, nʼebyo byonabyona ebimwabbanga mweyamire, nʼebyokuwaayo omu kwetakira byonabyona ebimwampanga nze oMusengwa.’ ");
INSERT INTO gwr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Kale okutandiika nʼolunaku lweikumi nʼaitaanu olwʼomweri gwʼomusanvu, nga mumalire okukungula ebirime okwitakali lyanywe, mwakolanga omukolo gwʼonkumpa nze oMusengwa ekitiisya okumala enaku musanvu; olunaku olusooka lwabbanga lwʼokuwuumula, nʼolunaku lwomunaana lwona lwabbanga lwʼokuwuumula. ");
INSERT INTO gwr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Oku lunaku olusooka mwanokolanga ebineneka byʼemisaale gyanywe ebikira obusa, era mwatemanga ensansa, nʼamasaga gʼemisaale egiriku ebikoola ebingi, nʼobusaga bwʼobusaale bwʼoku mwiga, ni mujaagaanira omumaiso gange nze oMusengwa iye oKibbumba waanywe okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Mujaagaanenge mutyo okumala enaku musanvu nabuli mwanka. Era eryo lyabbanga iteeka eryʼenkalaakalira abʼeibyaire lyanywe bonabona eribakuumanga emirembe nʼemirembe; mwajaguzanga mu mweri gwomusanvu. ");
INSERT INTO gwr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Mwagonanga mu busiisira okumala enaku musanvu: Bonabona ababyalwa bʼomwIsirairi bagonanga mu busiisira. ");
INSERT INTO gwr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ekyo kyamanyikisyanga abʼeibyaire lyanywe kiti, owenatoire aBaisirairi omu kyalo kyʼe Misiri nababbeesyanga mu busiisira. Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kale omu ngeri eyo oMusa nʼakobera aBaisirairi enaku enkulu egya Musengwa egiyateekerewo. ");
INSERT INTO gwr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Olagire aBaisirairi bakuleetere amafuta amasa eino agʼemizaituuni ni bakengeiza nakusani, agʼokwakisyanga kaisi amataala gʼomu Weema yange gaakenge nabuli kiseera nga tigalikira. ");
INSERT INTO gwr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","E nza wʼolutimbe olukingulya eSanduuku eyʼeNdagaano omu Weema eyʼoKunsisinkanirangamu nze oMusengwa, Alooni yakwatisyanga amataala ago ni gaakiranga aawo omumaiso gange okuzwa eigulo paka makeezi. Eiteeka eryo, aBaisirairi nʼabʼemirembe gyonagyona egyaliirawo balikwatanga. ");
INSERT INTO gwr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Alooni yaabbanga nʼokulabiriranga amataala ago oku bikondo byago ebyʼezaabbu ennongoole, gaakenge nga tigalikira omumaiso gange nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Era oMusengwa tete nʼakoba oMusa ati, “Alooni yakwatanga obusye obwʼengaano obusa, nʼasumbamu emigaati ikumi na mibiri, egyʼekiro ibiri ibiri. ");
INSERT INTO gwr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Yagiteekanga omu nyiriri ibiri, nga buli lunyiriri lwʼemigaati mukaaga, oku menza eyʼezaabbu ennongoole omumaiso gange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Era yasengereryanga buli lunyiriri nʼateekanga obubbaani obusa oku mbale kwa buli mugaati, ngʼakamanyiciryo akalaga kati ebyawaireyo byonabyona byange nze oMusengwa, era ni bubba kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Emigaati egyo yagiteekanga omumaiso ga Musengwa nabuli Saabbaato obutagonerya, oku lwʼaBaisirairi. Obwo bwabbanga buvunaanyizibwa bwʼaBaisirairi emirembe nʼemirembe. ");
INSERT INTO gwr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Emigaati egyo egyʼokumenza gyabbanga gyʼAlooni nʼeibyairerye, era bagiriiranga mu kifo ekitukulye omu luuga lwʼeWeema yange, olwʼokubba emigaati egyo niikyo ekitundu ekitukulye eino oku mugabo gwabwe ogubali nʼokusuna oku kyokuwaayo ekibooca nga bakiwaayo eeri nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Lumo wabbairewo omusaiza, ngʼomaaye Mwisirairi, neye ngʼoiteeye Mumisiri. Era omusaiza oyo, yaabire nʼatyama omu Baisirairi, neye ni watanukawo enkaayana aakatiwe nʼoMwisirairi nga bali eyo omu nkambi. ");
INSERT INTO gwr_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Omutaane oyo, owʼomukali oMwisirairi nʼatumula kubbikubbi nʼazumirira eriina lya Musengwa, kale ni bamuleeta eeri oMusa. Omaaye babbaire bamweta Seromisi, omwala wa Dibbuli owʼekika kya Daani. ");
INSERT INTO gwr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ni bamukwata ni bamusiba paka oMusengwa oweyabakobera ekyokukola. ");
INSERT INTO gwr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Awo oMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Oyo omuzumi, mumuwuluce e nza wʼenkambi. Era abo bonabona abamuwulire ngʼazuma, bateeke engalo gyabwe oku mutwegwe okumulumiriza, kaisi ekibbula kyonakyona kimukubbe amabbaale afe. ");
INSERT INTO gwr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Era okobere aBaisirairi oti, ‘Omuntu yenayena eyazumiriranga oKibbumbawe, bamuvunaananga olwʼekibbikibbi ekyo. ");
INSERT INTO gwr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Era oyo eyazumiriranga eriina lya Musengwa baabbanga nʼokumwita. Ekibbula kyonakyona kyamukubbanga amabbaale nʼafa. Nʼoweyaabbanga munamawanga ooba Mwisirairi, oweyazumiriranga eriina lya Musengwa, baabbanga nʼokumwita.’ ");
INSERT INTO gwr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Singa omuntu yenayena yatoolangawo obwomi bwʼomuntu, yena baabbanga nʼokumwita. ");
INSERT INTO gwr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Omuntu yenayena eyatoolangawo obwomi bwa kisolo wʼomuntu, yaabbanga nʼokugaita. Yairyangawo kisolo mwomi omu kifo kyʼogubaitire. ");
INSERT INTO gwr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Singa omuntu yatuucanga oku mwinaye ekisago, yena baabbanga nʼokumukola kiikyo. ");
INSERT INTO gwr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Ekikoba kiti, eyavunanga omwinaye eigumba, yena bamuvunanga igumba, eyatoolangamu omwinaye eriiso, yena bamutoolangamu liiso, nʼeyabbongolangamu omwinaye eriino, yena bamubbongolangamu liino. Ekisago omuntu ekiyatuucanga oku mwinaye, yena kibamutuucangaku. ");
INSERT INTO gwr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Omuntu eyaitanga okisolo yaabbanga nʼokugaita, neye oyo eyaitanga omuntu, baabbanga nʼokumwita. ");
INSERT INTO gwr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Amateeka gananyere ago agafuganga omunamawanga nʼomubyalwa. Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Awo oMusa oweyamalire okukobera aBaisirairi ebintu ebyo, oyo eyazumire ni bamutwala e nza wʼenkambi, ni bamukubba amabbaale nʼafa. Omu ngeri eyo aBaisirairi ni babba bakolere oMusengwa ekiyabbaire alagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","OMusa yabbaire ali oku lusozi oSinaayi, oMusengwa nʼamukoba, ");
INSERT INTO gwr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","akobe aBaisirairi ati, “Owemwalituuka omu kyalo ekimbawa, mwaliwuumulyanga eitakali okutalimaku nabuli mwanka ogwomusanvu, olwʼokumpa nze oMusengwa ekitiisya. ");
INSERT INTO gwr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Okumala emyanka mukaaga emisiri gyanywe mwaligisigangamu ebirime, era omu myanka egyo omukaaga mwalisaliranga emisiri gyanywe egyʼemizabbibbu, era mwalikungulanga ebineneka byagyo. ");
INSERT INTO gwr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Neye omu mwanka ogwomusanvu, mwaliwuumulyanga eitakali okutalimaku, omwanka ogwo ni gubbanga saabbaato yʼokuliwuumulya kumpeeraku nze oMusengwa kitiisya. Timwalisiganga ebirime omu misiri gyanywe, era timwalisaliranga emisiri gyanywe egyʼemizabbibbu. ");
INSERT INTO gwr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Onawaira wʼebirime byanywe timwalimukungulanga, waire kunoga ebineneka oku mizabbibbu gyanywe eginandi musalira. Omwanka ogwo gwalibbanga gwʼeitakali kuwuumula. ");
INSERT INTO gwr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Waire ngʼeitakali tibalirimenge omwanka ogwo gwonagwona, neye lyalibalyanga ebyokulya, ebyalibbanga ebyanywe nʼabagalama baanywe abasaiza, nʼabakali, nʼabapakasi, nʼabanamawanga abatyamanga mwinywe, ");
INSERT INTO gwr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","nʼebyayo byanywe nʼebisolo byʼomu kigona ebyalibbanga omu kyalo kyanywe. Nabuli kyokulya ekyalikuliranga okwitakali eryo, mwalikiryanga.” ");
INSERT INTO gwr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","OMusengwa nʼayongera okumukoba ati, “Mwabalanga emyanka musanvu emirundi musanvu, gyonagyona aamo ni gibba emyanka 49. ");
INSERT INTO gwr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Awo kaisi oku lunaku olweikumi olwʼomweri gwʼomusanvu, oLunaku lwʼomukolo gwʼokutoolawo obusungu bwa Musengwa, mwafuwanga amakondeere omu kyalo kyanywe kyonakyona. ");
INSERT INTO gwr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Omu ngeri eyo mwakulyanga omwanka gwa 50, era ni mulangirira eidembe eeri abatyami bonabona abʼomu kyalo kyanywe. Omu mwanka ogwo, ebintu byonabyona ebibaabbanga batundire babakanjiryanga ababbaire abananyere, era nabuli moiza ogubaabbanga batundire omu bugalama, yakanganga omu bantube. ");
INSERT INTO gwr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Omwanka ogwa 50 gwabbanga mwanka gwʼokujagaaniramu. Omu mwanka ogwo tibasigenge, waire kukungula emizabbibbu eginandi basalira. ");
INSERT INTO gwr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Omwanka ogwo gwonagwona gwabbanga gwʼokujaagaana era nga mutukulye eeri inywe; Mwalyanga biibyo ebikula byonkani omu misiri. ");
INSERT INTO gwr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Omu mwanka ogwo ogwa 50 ebibatundire babikanjiryanga ababbaire abananyere, era nabuli moiza oku bagalama, yakanganga omu bantube. ");
INSERT INTO gwr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Era singa aBaisirairi baabbanga bagulyangana eitakali, tibaseerangananga. ");
INSERT INTO gwr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","OMwisirairi omwinawo wamugulangaku ngʼosinzirira ku myanka egyankubitawo okuzwa oku mwanka ogwa 50. Era yena yakugulyanga kusinzirira ku makungula gʼemyanka egisigaireyo okutuuka oku mwanka gwa 50. ");
INSERT INTO gwr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Emyanka egibulwayo okutuuka oku gwa 50 owegyabbanga mingi, yaniinisyanga ebbeeyi, neye emyanka egibulwayo owegyabbanga mitono, yaicanga ebbeeyi, olwʼokubba obungi wʼebirime ebirimu niibwo obwagula. ");
INSERT INTO gwr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Olwʼokutya nze oKibbumba waanywe, timwaseerangananga. Ninze oMusengwa iye oKibbumba waanywe.” ");
INSERT INTO gwr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“OMusengwa ni yeeyongera okukoba oMusa ati, ‘Mukwatenge amateeka gange, era mugonderenge ebiragiro byange, kaisi mubbenge nʼemirembe omu kyalo kyanywe. ");
INSERT INTO gwr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Awo ekyalo ekyo kyabalanga ebibala byakyo, ni musuna ebimulya ebibamala, era ni mukityamamu mirembe. ");
INSERT INTO gwr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“ ‘Muyinza okwebuulya muti, twalyanga niki omu mwanka ogwomusanvu, nga titusigire era nga mpaawo kitukungwire? ");
INSERT INTO gwr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Omu mwanka ogwomukaaga nabawanga enkabi, ekyalo ni kibala ebyokulya ebyamalanga emyanka misatu. ");
INSERT INTO gwr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Owemwabbanga musiga omu mwanka gwomunaana, mwabbanga mukaali mulya ku birime ebimwakungwire eira, era mwabbanga mukaali mubirya paka amakungula gʼomwanka ogwomwenda owegatuukanga. ");
INSERT INTO gwr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Eitakali tibalitundirenge nakimo lumala nga tikyezeka okulyeirirya, olwʼokubba eitakali lyange nze oMusengwa, era inywe muli bageni era basenze okwitakali eryo. ");
INSERT INTO gwr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Omu kyalo kyonakyona ekimulimu, owemwatundanga eitakali, mwalekangawo omwagaanya ogwʼokulinunula. ");
INSERT INTO gwr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Singa oMwisirairi omunaanywe yadoobanga nʼatundaku eitakalirye, omuntuwe owʼoluganda olwʼokumpi, yaizanga nʼanunula eitakali oMwisirairi omwinaye eriyatundire. ");
INSERT INTO gwr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Neye singa omuntu oyo eyatundire yaabbanga adamba omuntu alimununulira, kaisi oluzwanyuma nʼagaigawala nʼasuna empiiya egirinunula, ");
INSERT INTO gwr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","yabaliiriranga okuzwa ngʼoweyalitundire, nʼasinzirira okwo okubalirira empiiya egiyasasula eyaligulire egiyandibbaire asuna omu kulima eitakali nago omu myanka egisigaireyo okutuuka oku mwanka ogwa 50, olwo kaisi nʼalyeirirya. ");
INSERT INTO gwr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Neye singa yakayanga okusuna engeri eyʼokusasula oodi eyaligulire, eitakali eryo lyasigalanga mu bwezye bwʼoyo eyaligulire, okutuuka oku mwanka ogwa 50. Balimukanjiryanga mu mwanka ogwo, kaisi nʼalyeirirya. ");
INSERT INTO gwr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Singa omuntu yatundanga enyumba eri omu kibuga ekiriku olugaga, yaabbanga nʼobwezye okuginunula omwibbanga lyʼomwanka mulamba okuzwa ngʼoweyagitundire. Omwibbanga eryo eryʼomwanka omulamba, atundire yaabbanga wʼeidembe okuginunula. ");
INSERT INTO gwr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Neye singa tiyaginunulenge omwibbanga eryʼomwanka omulamba, enyumba eyo eri omu kibuga ekiriku olugaga yabbeeranga nakimo yʼoyo eyagigulire nʼeibyairerye. Tibagimwiriryenge omu mwanka ogwa 50. ");
INSERT INTO gwr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Neye amanyumba agʼomu byalo ebibulaku engaga, baabbanga nʼokugakolaku ngʼowebakola oku byʼeitakali. Baganunulanga era bagakanjiryanga abananyerego omu mwanka ogwa 50. ");
INSERT INTO gwr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Wazira aBaleevi ibo, baabbanga nʼeidembe okununula amanyumba gaabwe agali omu bibuga byabwe ebibabawaire. ");
INSERT INTO gwr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","OMuleevi oweyatundanga enyumba eyʼomu kibuga kyonakyona kwʼebyo ebibabawaire, nandi nʼaginunula, bagimukanjiryanga omu mwanka ogwa 50, olwʼokubba amanyumba aBaleevi agebabba nago omu bibuga byabwe, igo gaabwe-kubwabwe omu Baisirairi. ");
INSERT INTO gwr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Neye eitakali eryʼokuliisiryaku eryeruguuliriirye ebibuga byabwe tibalitundenge; olwʼokubba iryo lyabwe lyʼenkalaakalira. ");
INSERT INTO gwr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Singa oMwisirairi omwinawo yadoobanga, nga tayezya okwebbeesyawo, wamubbeeranga ngʼowewandibbeereire omunamawanga ooba omusenze kaisi ni yeeyongera okutyama mwinywe. ");
INSERT INTO gwr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Olwʼokuntya nze oKibbumbawo, tiwamutoolangaku amagoba naire kaisi omwinawo oyo ayezye okusigala ngʼatyama mwinywe. ");
INSERT INTO gwr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Toli nʼokumutoolesya amagoba oku mpiiya egyomukoopa, waire okumugulyanga ebyokulya ngʼoteekereku amagoba. ");
INSERT INTO gwr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ninze oMusengwa iye oKibbumba waanywe eyabatoire omu kyalo kyʼe Misiri, okubawa ekyalo kyʼe Kanani, era mbe Kibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Singa oMwisirairi omwinawo yadoobanga nʼakukoba nʼomugula nʼabba mugalamawo, tiwamukolesyanga emirimo ngʼomugalama. ");
INSERT INTO gwr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Oli nʼokumubityanga ngʼomupakasi ogubasasula empeera, ooba ngʼomusenze atyama mwinywe; yaabbanga nʼokuweereryanga kutuuka ku mwanka gwa 50. ");
INSERT INTO gwr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Awo kaisi iye nʼabaanabe nʼobaleka, ni bakanga omu kika kyabwe, okwitakali lyʼabazeiza baabwe. ");
INSERT INTO gwr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Olwʼokubba aBaisirairi bagalama bange, abenatoire omu kyalo kyʼe Misiri, tibali nʼokubatunda okubba bagalama. ");
INSERT INTO gwr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Olwʼokuntya nze oKibbumba waanywe, timwabafuganga nʼobukambwe. ");
INSERT INTO gwr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Singa mwatakanga abagalama abasaiza nʼabakali, mwabbanga nʼokubagula mu mawanga agabeeruguuliriirye. ");
INSERT INTO gwr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Era muyinza okugulanga abamo oku banamawanga abatyama mwinywe, nʼabantu bʼomu kika kyabwe abebabyaliire omu kyalo kyanywe era ni basuuka baanywe-kubwanywe. ");
INSERT INTO gwr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Era muyinza okukola ekiraamo abaana baanywe ni babasikira, abagalama abo ni babaweererya paka kufa. Neye aBaisirairi abananywe timuli nʼokubafuganga nʼobukambwe. ");
INSERT INTO gwr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Singa omunamawanga ooba omusenze atyama mwinywe yagaigawalanga, neye oMwisirairi omunaanywe nʼadooba, nʼakoba omunamawanga ooba owʼomu kisito kyʼomunamawanga oyo atyama mwinywe nʼamugula nʼabba omugalamawe, ");
INSERT INTO gwr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","yasigalanga nʼeidembe lyʼokumununula nga bamalire okumugula. Era omoiza oku bʼolulyolwe banu ayinza okumununula: ");
INSERT INTO gwr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Oiteeye omuto, ooba omutaane wa iteeye omuto, ooba owʼekikaakye ogondi yenayena ayinza okumununula, ooba iye onanyere oweyagaigawalanga, ayinza okwenunula. ");
INSERT INTO gwr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Iye nʼodi eyamugulire babalagananga okuzwa omu mwanka oguyamuguliireku, okutuuka oku mwanka ogwa 50. Ebbeeyi yʼokumununula yasinziriranga ku mpiiya egibasasula omupakasi okumala emyanka egyo egibabalire. ");
INSERT INTO gwr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Singa emyanka gyabbanga mingi egisigaireyo okutuuka oku gwa 50, eyamugulire bamukanjiryanga kinene okukiraku ekiyatoire okumugula. ");
INSERT INTO gwr_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Neye singa waabbanga wasigaireyo emyanka mitono okutuuka oku mwanka ogwa 50, yabaliriranga kusinzirira kwibbanga erisigaireyo kaisi nʼamusasula olwʼekwenunula. ");
INSERT INTO gwr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Eyamugulire ali nʼokumubityanga ngʼomupakasi ogubapangisya mwanka ku mwanka. Era muli nʼokubona muti eyamugulire tali nʼokumufuganga nʼobukambwe. ");
INSERT INTO gwr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Singa tibamununulenge oku gimo oku ngeri egyo, iye nʼabaanabe babalekanga omu mwanka ogwa 50 nandi ni beeyongera okubba bagalama, ");
INSERT INTO gwr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","olwʼokubba aBaisirairi bagalama bange, abenatoire omu kyalo kyʼe Misiri. Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Omusengwa tete nʼakoba oMusa ati, “Tiweekoleranga ooba okuteekawo ebifaananyi ebibaize ooba ebiyeese, ooba okukoma amabbaale, era timwateekangawo amabbaale amayeese omu kyalo kyanywe okugasinzanga. Ninze oMusengwa iye oKibbumba waanywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Muli nʼokukuumanga eSaabbaato yange, era muwenge eWeema yange ekitiisya. Ninze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Singa mwakwatanga amateeka gange, ni mugonderanga ebiragiro byange nʼokwegendereza, ");
INSERT INTO gwr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","nabawanga oikendi omu biseera ebituuce, eitakali ni libala ebirime, nʼemisaale egyʼomu misiri ni gibala ebineneka byagyo. ");
INSERT INTO gwr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Ebirime byanywe byabalanga ino era mwabbanga mukaali mukona ebyʼempeke ebimukungwire, amakungula gʼemizabbibbu gona ni gatuuka, era mwabbanga mukaali mukungula emizabbibbu ekiseera kyʼokusiga ebyʼempeke kyona ni kituuka. Mwabbanga nʼebyokulya ebibamala, era mwabbanga nʼeidembe omu kyalo kyanywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“Nabawanga emirembe omu kyalo kyanywe, ni mugonanga nga mpaawo ekibatiisya. Era nalimala omu kyalo kyanywe ebisolo ebyʼakabbikabbi, era tikyabbengemu entalo. ");
INSERT INTO gwr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mwalukutyanga abalabe baanywe, ni mubaita nʼempiima. ");
INSERT INTO gwr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Abataanu kwinywe balukutyanga 100, kaisi 100 kwinywe kyalukutyanga 10,000, era abalabe baanywe mwabaitanga nʼempiima. ");
INSERT INTO gwr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“Nabawanga enkabi, ni mbawa abaana bangi, ni mweyongera ni mubba bangi, era nakuumanga endagaano yange eginakolere na inywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mwabbanga mukaali mulya ebimwakungwire omu mwanka ogubitire, nga kibeetagisya kutoolamu ebikaali ebisigairemu okusunira ebiyaaka ekifo. ");
INSERT INTO gwr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Natyamanga mwinywe, era tinalibeesinya. ");
INSERT INTO gwr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Natambulanga na inywe, era naabbanga Kibbumba waanywe, era ni mubbanga bantu bange. ");
INSERT INTO gwr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ninze oMusengwa iye oKibbumba waanywe, eyabatoire omu kyalo kyʼe Misiri, kaisi mulekeraawo okubba bagalama bʼaBamisiri. Namenyerewo amaani gʼobugalama obwo, ni mbayezesya okubba bateere.” ");
INSERT INTO gwr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Neye singa timwampulisisyenge, nandi mugondera ebiragiro byange ebyo byonabyona, ");
INSERT INTO gwr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","era singa mwagaananga okukwata amateeka gange era ni mucaawa okulungamya kwange, era nandi ni mutuukirirya ebiragiro byange byonabyona, ni mumenya endagaano yange eginakolere na inywe, ");
INSERT INTO gwr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","awo nalibakola binu: Nalibakola ebizizi, ekikoba kiti, nalibaleetaku obulwaire obutalama nʼomusuuja ogwaliboofuwalya, ni guleetera obwomi bwanywe okusebengerera. Mwateganiranga bwereere okukoma ebirime, olwʼokubba abalabe baanywe niibo ababiryanga. ");
INSERT INTO gwr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nalibakubbira omugongo, kaisi abalabe baanywe ni babawangula; abo ababacaawa babafuganga, era mwairukanga waire nga mpaawo ababalukutya. ");
INSERT INTO gwr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Singa ebyo byonabyona byabatuukangaku, era nandi ni mungondera, nʼakubbisyangamu ekibonerezo kyanywe emirundi musanvu olwʼebikole byanywe ebibbibibbi. ");
INSERT INTO gwr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Okwekudumbalya kwanywe nalikubamalamu era naligaana oikendi okutoonya era eitakali ni likalanguka ooti kyoma. ");
INSERT INTO gwr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Amaani gabafeeranga bwereere, olwʼokubba eitakali lyanywe tiryabalenge ebibala, nʼemisaale gyʼokwitakali eryo tigyanenekenge. ");
INSERT INTO gwr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Singa mweyongeranga okunjemera era nandi ni mungondera, nʼakubbisyangamu ebibonerezo byanywe emirundi musanvu olwʼebikole byanywe ebibbibibbi. ");
INSERT INTO gwr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nabasindiikiranga ebisolo byʼomu kigona ni bibalumba, ni biita abaana baanywe, ni bijigirica ebyayo byanywe, era ni bikendeerya obungi bwanywe, kaisi enguudo gyanywe ni gisigala njereere. ");
INSERT INTO gwr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Singa ebibonerezo ebyo byonabyona era tibyabazwerengeku okwira egyendi, ni mweyongera kunjeemera, ");
INSERT INTO gwr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nze onanyere nabacaawanga era nʼakubbisyangamu ebibonerezo byanywe emirundi musanvu olwʼebikole byanywe ebibbibibbi. ");
INSERT INTO gwr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Nabaleeteranga entalo olwʼokwesasuza inywe okumenya endagaano yange. Era owemwairukiranga omu bibuga byanywe okwetaasa, nabasindikangamu okawumpuli, ni mbawaayo omu bwezye bwʼabalabe baanywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Owenakenderyangaku obungi wʼebyokulya byanywe, abakali eikumi bayezyanga kukolesya kisumbiro kimo okusumbiramu emigaati gyanywe. Bagigawulanga mu butontono, ni mugirya, era timwaikutenge. ");
INSERT INTO gwr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Era singa ebyo byonabyona tibyabazwerengeku okucuuka, ni mumpulira, ni mweyongera kunjeemeranga, ");
INSERT INTO gwr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","olwo nabacaawanga, era nze onanyere nʼakubbisyangamu ekibonerezo kyanywe nʼobukambwe emirundi musanvu olwʼebikole byanywe ebibbibibbi. ");
INSERT INTO gwr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Enzala yabalumanga ni mutuuka nʼokulya abaana baanywe abaisuka nʼabaala. ");
INSERT INTO gwr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Nalijigirica ebifo byanywe ebyʼoku nsozi ebimusinziramu abakibbumba baanywe, ni nvunawo ebyoto byanywe ebyʼobubbaani, nʼemirambo gyanywe ni ngibbiirya oku bifaananyi byanywe ebyʼokusinza ebinambula bwomi, era ni mbacaawa. ");
INSERT INTO gwr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nalisanyaawo ebibuga byanywe, ni njigirica ebifo ebimusinziramu, era tinasiimenge oluvululu olusangaalya oluzwa omu sadaaka gyanywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ekyalo kyanywe nalikisuuca kifulukwa, kaisi abalabe baanywe abakiwamba ni beewuunya okubona ngʼowekiri. ");
INSERT INTO gwr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Nalibaleetaku entalo era ni mbasaalaanicirya omu mawanga. Ekyalo kyanywe kyalisuuka kifulukwa, nʼebibuga byanywe ni bisigala binameje. ");
INSERT INTO gwr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Awo eitakali lyalisangaalira emyanka gyalyo egyokuwuumula, ekiseera kyonakyona ekiryalimala nga mulirekeswire awo, muli omu buwambe omu kyalo kyʼabalabe baanywe. Awo eitakali eryo lyaliwumula ni lyeyagalira omu kiwuumulo kyalyo. ");
INSERT INTO gwr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Eibbanga eryo lyonalyona eitakali oweryalibbeera nga lisuukire kifulukwa, lyalibba nʼekiwuumulo ekinandi muliwa nga mulityaimeku ate nga mwabbaire muli nʼokuliwanga ekiwumulo. ");
INSERT INTO gwr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Abo kwinywe abalibba basigairewo nga boomi, nalibateekamu obuti omu myoyo gyabwe nga bali omu buwambe omu byalo byʼabalabe baabwe, nga nʼokusagala kwʼekikoola ompunga ekyafuwa, kubairukisya. Bairukanga oti-so bairuka balabe abʼempiima, era ni bagwa nga mpaawo abalukutya. ");
INSERT INTO gwr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Beemanganangaku bonka na bonka, nga bali oti bairuka balabe abʼempiima waire nga mpaawo abalukutya. Kale timwayezyenge okulwanisya abalabe baanywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Mwalifeera omu mawanga ago; eitakali lyʼomu kyalo kyʼabalabe baanywe lyalibalya. ");
INSERT INTO gwr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Olwʼebikole byabwe ebibbibibbi nʼolwʼebya bazeiza baabwe abo abalibba basigairewo nga boomi balifangaku mpola mpola omu byalo byʼabalabe baanywe. ");
INSERT INTO gwr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Neye owebalyenenya ebikole byabwe ebibbibibbi nʼebyʼabazeiza baabwe ababbaire abatali beesigwa era abanjeemeire, ");
INSERT INTO gwr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ni bandeetera okubacaawa, ni mbasindika omu kyalo kyʼabalabe baabwe, singa balyewombeeka, ni baikirirya ekibonerezo kyʼebikole byabwe ebibbibibbi byabwe, ");
INSERT INTO gwr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","awo nalyebukirya endagaano eginakolere nʼoYaakobbo, nʼoIsaka nʼoIbbulaimu, era nalyebukirya nʼekisuubizo ekinakolere ekyokubawa ekyalo kinu. ");
INSERT INTO gwr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Neye eitakali lyʼekyalo ekyo balibba balizwireku, ni lyeyagalira omu kiwuumulo kyalyo ekiseera kyonakyona ekiryalimala nga balirekeswire awo. Balisuna ekibonerezo olwʼebikole byabwe ebibbibibbi, olwʼokubba bajeemeire ebiragiro byange, era ni bagaana okukwata amateeka gange. ");
INSERT INTO gwr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Newankubbaire ngʼebyo byalibba bityo, owebalibba omu kyalo kyʼabalabe baabwe, tinalibalekesula waire okubacaawa okutuuka okubasanyirawo nakimo, nʼokumenyawo endagaano eginakolere nabo. Ninze oMusengwa iye oKibbumba waabwe. ");
INSERT INTO gwr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Neye oku lwabwe nalyebukirya endagaano eginakolere nʼabazeiza baabwe, owenalagire amawanga gonagona obwezye bwange nga mbatoola omu kyalo kyʼe Misiri.” ");
INSERT INTO gwr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ago niigo amateeka, nʼokulungamya, nʼebiragiro oMusengwa ebiyawaire aBaisirairi oku Lusozi oSinaayi, ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","OMusengwa ni yeeyongera okukoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","akobe aBaisirairi ati: “Singa omuntu yakolanga obweyamo obwenjawulo nʼawonga omuntu eeri oMusengwa okumuweererya, neye nga yasasula mpiiya omu kifo kyʼomuntu oyo, ");
INSERT INTO gwr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","kinu niikyo ekipimo okusinzirira kwebyo ebibakolesya omu Weema yange nze oMusengwa ekimwakolesyanga okubalirira empiiya egyaba omu muntu oyo: Oweyaabbanga musaiza wʼemyanka okuzwa okwabiri okutuuka oku 60, gyabbanga esekeri gyʼefeeza 50. ");
INSERT INTO gwr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Neye oweyaabbanga mukali, gyabbanga esekeri gyʼefeeza 30. ");
INSERT INTO gwr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Omuntu oweyaabbanga wʼemyanka mitaanu okutuuka okwabiri, nga mwisuka gyabbanga esekeri gyʼefeeza aabiri, neye oweyaabbanga mwala gyabbanga esekeri gyʼefeeza ikumi. ");
INSERT INTO gwr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Oweyaabbanga mwana wʼomweri gumo okutuuka oku myanka emitaanu, nga mwisuka gyabbanga esekeri gyʼefeeza itaanu, neye oweyaabbanga mwala gyabbanga esekeri gyʼefeeza isatu. ");
INSERT INTO gwr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Omuntu oweyaabbanga wʼemyanka 60 nʼokukirawo, nga musaiza gyabbanga esekeri gyʼefeeza ikumi naitaanu, neye oweyaabbanga mukali gyabbanga esekeri gyʼefeeza ikumi. ");
INSERT INTO gwr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Singa omuntu eyeeyamire yaabbanga mudoobi ino, nga tayezya okusasula empiiya egibamusaliire, awo yatwalanga omuntu ogwali kununula eeri okabona, okabona nʼamusalira empiiya ngʼasinzirira kwʼegyo, oyo eyeeyamire egyayezya okusasula. ");
INSERT INTO gwr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Singa obweyamo bwʼomuntu bwabbanga bwʼokuwaayo kisolo ogubaikirirya okubba ekyokuwaayo eeri oMusengwa, okisolo yenayena oyo oguyaawangayo eeri oMusengwa, yaabbanga asuukire mutukulye. ");
INSERT INTO gwr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Tiyamucuusengemu okuteekawo ogondi, waire okuwanyisyamu omusa omu kifo kyʼomubimubbi, ooba okuwanyisyamu omubbimubbi omu kifo kyʼomusa. Singa yawaanyisyanga okisolo omoiza omu gondi, olwo ebisolo byombi, ogwawaireyo nʼodi ogwawanyisiryemu byabbanga bisuukire bitukulye. ");
INSERT INTO gwr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Neye singa okisolo omuntu oguyaabbanga yeeyamire okuwaayo, yaabbanga timulongoole, nga tibamwikirirya okubba kyokuwaayo eeri oMusengwa, awo yamutwalanga eeri okabona, ");
INSERT INTO gwr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","iye nʼasalawo ebbeeyi okusinzirira oku busa bwa kisolo oyo ooba obubbibubbiwe. Ebbeeyi egiyasalangawo, yaabbanga niiyo eyo. ");
INSERT INTO gwr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Singa aleetere okisolo oyo yatakanga okumununula, yayongerangaku ekitundu kimo ekyokutaanu oku bbeeyi eyo. ");
INSERT INTO gwr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“Singa omuntu yaawangayo enyumbaye ebbe ya Musengwa entukulye, okabona yasalangawo empiiya egyabamu, ngʼasinzirira oku busa ooba obubbibubbi bwayo. Ebbeeyi egiyasalangawo yaabbanga niiyo eyo. ");
INSERT INTO gwr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Singa oyo awaayo enyumbaye yatakanga okuginunula, yayongerangaku ekitundu kimo kyokutaanu, oku bbeeyi yaayo, olwo ni yeirirya enyumba eyo. ");
INSERT INTO gwr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Singa omuntu yaawangayo ekitundu kyʼeitakali kyʼomuwulukogwe eeri oMusengwa, balibalangamu empiiya, nga basinzirira oku bungi bwʼensigo egimala okusiga okwitakali eryo, nga buli kiro aabiri egya bbaale, gigula esekeri 50 egyʼefeeza. ");
INSERT INTO gwr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Singa yaawangayo eitakali mu mwanka gwa 50, awo empiiya egibaabbanga balibaliremu tigyacuukenge. ");
INSERT INTO gwr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Neye singa yaawangayo eitakalirye ngʼomwanka ogwa 50 gubitire, okabona yasalangawo empiiya egyaba omwitakali eryo, ngʼasinzirira oku myanka egisigaireyo okutuuka oku mwanka ogundi ogwa 50, era bakendeeryangaku obungi bwʼempiiya egibaabbanga basalirewo. ");
INSERT INTO gwr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Era singa oyo eyaabbanga awaireyo eitakalirye yatakanga okulinunula, yayongerangaku ekitundu kimo kyokutaanu ekyʼempiiya egibasalirewo egyaba omwitakali eryo, olwo kaisi ni yeirirya eitakali eryo. ");
INSERT INTO gwr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Neye singa tiyalinunulenge, ooba singa yaabbanga aligulirye omuntu ogondi, olwo kyabbanga tikyezeka okulinunula. ");
INSERT INTO gwr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Neye eitakali eryo owebalirekanga nandi ni balinunula paka mu mwanka ogwa 50, lyabbanga lyange nze Musengwa, nga itakali eribawongereyo, era baliwanga bakabona. ");
INSERT INTO gwr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Singa omuntu yaawangayo eeri nze oMusengwa eitakali eriyagulire, nga tikitundu oku muwulukogwe, ");
INSERT INTO gwr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","okabona yasalangawo empiiya egiryabamu, ngʼasinzirira oku myanka egisigaireyo okutuuka oku mwanka gwa 50, aliwaireyo nʼasasula empiiya egyo oku lunaku olwo, empiiya ni gibba gya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Omu mwanka ogwa 50, eitakali balikanjiryanga odi oguyaligulireku, nga niiye oyo eyabbaire onanyere eitakali eryo. ");
INSERT INTO gwr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Nabuli bungi bwʼempiiya babubaliriranga kusinzirira ku kipimo kyʼesekeri ekyʼomu Weema ya Musengwa; esekeri emoiza yenkanankana obuzito bwʼegera aabiri. ");
INSERT INTO gwr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Neye okisolo omubere yaabbanga wa Musengwa. Nʼolwekyo tiwaabbengewo amuwaayo eeri oMusengwa, newankubbaire nte, waire ntaama; oyo yaabbanga wa Musengwa. ");
INSERT INTO gwr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Singa okisolo oyo yaabbanga timulongoole, onanyere okisolo yayinzanga okumununula oku bbeeyi egibabaliriire, nʼayongereku ekitundu kimo kyokutaanu ekyʼebbeeyi eyo. Singa tiyamununulenge, bamutundanga oku bbeeyi egibamubaliriiremu. ");
INSERT INTO gwr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Neye omuntu oweyaawangayo eeri nze oMusengwa, oku bintubye ebyalinabyo, ekikoba kiti, omuntu ooba okisolo ooba omuwulukogwe, ebintu ebyo tibabitundenge waire okubinunula. Nabuli kintu ekibaawangangayo omu ngeri eyo eeri oMusengwa, kyabbanga kitukulye ino eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“Mpaawo muntu ogubaawangayo eeri nze oMusengwa nga wʼokujigirica ogubanunulanga; baabbanga nʼokumwita. ");
INSERT INTO gwr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Nabuli kimo kyʼeikumi ekyʼebibala okuzwa okwitakali lyanywe, ekikoba kiti, oku byokulya ebyʼempeke, ooba oku bineneka byʼemisaale gyanywe, kyabbanga kyange nze oMusengwa, era byabbanga bitukulye eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Singa omuntu yaabbanga ataka okununula ekimo kyʼeikumikye, yasasulanga empiiya egikyabamu, nʼayongeraku nʼekimo kyokutaanu ekyʼempiiya egyo. ");
INSERT INTO gwr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ekimo kyʼeikumi kyonakyona ekyʼekiraalo ekyʼente, nʼekimo kyʼeikumi kyonakyona ekyʼekisibo kyʼentaama, ekikoba kiti, nabuli kisolo oweikumi omuliisya ogwabala, yaabbanga wange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tali nʼokulondangamu kisolo omusa nʼalekawo omubbimubbi, ooba okumuwanyisyamu. Singa yamuwanyisyangamu ebisolo byombi, odi nʼonu ogwawanyisiryemu byabbanga bya Musengwa, era tibabinunulenge.” ");
INSERT INTO gwr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ebyo niibyo ebiragiro, oMusengwa ebiyawaire oMusa oku Lusozi oSinaayi, abikobere aBaisirairi.");
INSERT INTO gwr_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Lumo aBaisirairi owebabbaire nga bazwire omu kyalo kyʼe Misiri, nga bali omwidungu lyʼe Sinaayi; oku lunaku olusooka omu mweri ogwokubiri, omu mwanka ogwokubiri okuzwa owebazwireyo, oMusengwa ngʼali omu Weemaye eyʼoKusisinkanirangamu nʼayeta oMusa nʼamukoba ati, ");
INSERT INTO gwr_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Mubale ekibbula kyonakyona ekyʼaBaisirairi, okusinzirira oku miryango gyabwe nʼebisito byabwe. Muwandiike amaliina gʼabasaiza bonabona moiza ku moiza. ");
INSERT INTO gwr_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Iwe nʼAlooni mwabala abasaiza bonabona omwIsirairi kibinja ku kibinja, abʼemyanka aabiri nʼokukirawo era abeezya okwaba omu lutalo. ");
INSERT INTO gwr_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Mu buli kika mwazwamu omusaiza moiza eyababbeera, era nga niiye akulira abʼomulyango gwabwe.” ");
INSERT INTO gwr_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Era ganu niigo amaliina gʼabasaiza abababbeeraku:” “Omu kika kya Lubbeeni, Erizuuli omutaane wa Sedewuli; ");
INSERT INTO gwr_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","“nʼomu kika kya Simyoni, Syerumiyeeri omutaane wa Zulisyadayi; ");
INSERT INTO gwr_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","“nʼomu kika kya Yuda, Nakusoni omutaane wʼAminadabbu; ");
INSERT INTO gwr_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","“nʼomu kika kya Isakaali, Nasaneeri omutaane wa Zuwali; ");
INSERT INTO gwr_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","“nʼomu kika kya Zebbulooni, Eryabbu omutaane wa Keroni; ");
INSERT INTO gwr_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","“nʼomu baana ba Yusufu, “ekikoba kiti, omu kika kyʼEfulaimu, Erisaama omutaane wʼAmikudi. “Omu kika kya Manase, Gamalyeri omutaane wa Pedakuzuli; ");
INSERT INTO gwr_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","“nʼomu kika kya Bbenyamini, Abbidaani omutaane wa Gidyoni; ");
INSERT INTO gwr_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","“nʼomu kika kya Daani, Akiyezeri omutaane wʼAmisyadayi; ");
INSERT INTO gwr_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","“nʼomu kika kyʼAseri, Pagiyeeri omutaane wʼOkulani; ");
INSERT INTO gwr_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","“nʼomu kika kya Gaadi, Eriyasaafu omutaane wa Deweri; ");
INSERT INTO gwr_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","“nʼomu kika kya Nafutaali, Akira omutaane wʼEnani.” ");
INSERT INTO gwr_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Aabo niibo abasaiza abebalonderemu okuzwa omu kibbula kyonakyona ekyʼaBaisirairi, ibo ababbaire abafugi omu bika byʼabazeiza baabwe, era abeekubbemberi bʼenkumi nʼenkumi abʼomu bika bya Isirairi. ");
INSERT INTO gwr_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Awo oMusa nʼAlooni ni beeta abantu abo abebabbutwire amaliina, ");
INSERT INTO gwr_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","era oku lunaku olusooka omu mweri ogwokubiri ni bakumbaania ekibbula kyonakyona aamo, ni babawandiika moiza ku moiza, abantu abʼemyanka aabiri nʼokukirawo nga basinzirira oku miryango gyabwe nʼebisito byabwe, ");
INSERT INTO gwr_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ngʼoMusengwa oweyalagiire oMusa. Kale oMusa atyo nʼabala abantu nga bali omwidungu lyʼe Sinaayi. ");
INSERT INTO gwr_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Abʼomu kika kya Lubbeeni, omubere wa Isirairi mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo ababbaire beezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza, okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Abʼomu kika kya Lubbeeni, babbaire 46,500. ");
INSERT INTO gwr_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Abʼomu kika kya Simyoni mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo bonabona ababbaire beezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza, okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Abo abebabalire, omu kika kya Simyoni, babbaire 59,300. ");
INSERT INTO gwr_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Abʼomu kika kya Gaadi mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Abo abebabalire omu kika ekyo ekya Gaadi, babbaire 45,650. ");
INSERT INTO gwr_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Abʼomu kika kya Yuda mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Abo abebabalire, omu kika ekyo ekya Yuda, babbaire 74,600. ");
INSERT INTO gwr_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Abʼomu kika kya Isakaali mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Abo abebabalire, omu kika ekyo ekya Isakaali, babbaire 54,400. ");
INSERT INTO gwr_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Abʼomu kika kya Zebbulooni mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Abo abebabalire, omu kika ekyo ekya Zebbulooni, babbaire 57,400. ");
INSERT INTO gwr_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Okuzwa omu mulyango gwa Yusufu: Abʼomu kika kyʼEfulaimu mwabbairemu baanu: Abasaiza bonabona abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Abo abebabalire, omu kika ekyo ekyʼEfulaimu, babbaire 40,500. ");
INSERT INTO gwr_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Abʼomu kika kya Manase mwabbairemu baanu: Abasaiza bonabona ababbaire abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Abo abebabalire, omu kika ekyo ekya Manase, babbaire 32,200. ");
INSERT INTO gwr_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Abʼomu kika kya Bbenyamini mwabbairemu baanu: Abasaiza bonabona ababbaire abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Abo abebabalire, omu kika ekyo ekya Bbenyamini, babbaire 35,400. ");
INSERT INTO gwr_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Abʼomu kika kya Daani mwabbairemu baanu: Abasaiza bonabona ababbaire abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Abo abebabalire, omu kika ekyo ekya Daani, babbaire 62,700. ");
INSERT INTO gwr_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Abʼomu kika kyʼAseri mwabbairemu baanu: Abasaiza bonabona ababbaire abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Abo abebabalire, omu kika ekyo ekyʼAseri, babbaire 41,500. ");
INSERT INTO gwr_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Abʼomu kika kya Nafutaali mwabbairemu baanu: Abasaiza bonabona ababbaire abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo, ni babawandiika amaliina gaabwe, ni bababala moiza ku moiza okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Abo abebabalire omu kika ekyo ekya Nafutaali, babbaire 53,400. ");
INSERT INTO gwr_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Abo niibo abasaiza oMusa nʼAlooni nʼabafugi eikumi na babiri aba Isirairi abebabalire, nabuli moiza ngʼakiikirira omulyango gwabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ABaisirairi bonabona abʼemyanka 20 nʼokukirawo, abeezya okwaba omu lutalo ni bababala okusinzirira oku miryango gyabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Abo bonabona abebabalire babbaire 603,550. ");
INSERT INTO gwr_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Neye ibo aBaleevi, tibababaliire aamo nʼabʼebika ebindi, ");
INSERT INTO gwr_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","olwʼokubba oMusengwa yabbaire akobere oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Abʼekika kya Leevi tiwababala, era obungi bwabwe tiwabugaita oku bwʼaBaisirairi abanaabwe. ");
INSERT INTO gwr_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Wazira aBaleevi obawe mulimo gwʼokulabiriranga Weema ya Musengwa, era nʼokulabiriranga bintu byonabyona ebyamu. Bagisetulanga nʼebintu byayo byonabyona, era niibo abagirabiriranga, era bagyeruguuliriryanga. ");
INSERT INTO gwr_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Nabuli owemwabbanga musengula eWeema eyo, aBaleevi niibo abagisengulanga era niibo abagikomekanga. Atali Muleevi eyagiigererangaku, bamwitanga bwiti. ");
INSERT INTO gwr_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ABaisirairi abandi, bakomekanga eweema egyabwe, nabuli moiza omu nkambiye, ebbendera yaabwe e gyeri. ");
INSERT INTO gwr_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Neye aBaleevi bakomekanga eweema egyabwe okweruguulirirya eWeema eya Musengwa, kaisi obulwa bwange nandi butuuka oku kibbula kyonakyona ekyʼaBaisirairi. Era aBaleevi niibo abaabbanga nʼobuvunaanyizibwa okulabiriranga eWeema eya Musengwa.” ");
INSERT INTO gwr_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Batyo aBaisirairi ni bakola byonabyona ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Awo oMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ABaisirairi owebaabbanga bakola enkambi, nabuli muntu yateekanga eweemaye awali ebbendera eyʼekikaakye, era awali obumanyiciryo bwʼabʼomulyangogwe. Bakolanga enkambi okweruguulirirya eWeema eyʼoKunsisinkanirangamu nze oMusengwa, nga balekakuuwo eibbanga okugituukaku.” ");
INSERT INTO gwr_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Abakolanga enkambi oku lubba olwʼe buzwaisana baabbanga bʼekibinja kya Yuda ngʼebika byabwe obwebiri. Omwekubbemberi wʼekibinja kya Yuda niiye oNakusoni omutaane wʼAminadabbu. ");
INSERT INTO gwr_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ekibinjakye ekyo kirimu abantu 74,600. ");
INSERT INTO gwr_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Abʼekibinja kya Isakaali niibo abakolanga enkambi okulirana abʼekika kya Yuda, era omwekubbemberi waabwe niiye oNasanairi omutaane wa Zuwali. ");
INSERT INTO gwr_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ekibinjakye ekyo kirimu abantu 54,400. ");
INSERT INTO gwr_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Okwo kwairangaku abʼekika kya Zebbulooni, ngʼomwekubbemberi waabwe niiye Eryabbu omutaane wa Keroni. ");
INSERT INTO gwr_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Ekibinjakye ekyo kirimu abantu 57,400. ");
INSERT INTO gwr_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Abasaiza bonabona abebabalire omu nkambi ya Yuda, ngʼebibinja byabwe owebiri, babbaire 186,400. Abo niibo abeekubbemberangamu nga basenguka okwaba omu kifo ekindi. ");
INSERT INTO gwr_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Oku lubba lwʼe maserengeta, niiyo abʼekibinja kya Lubbeeni e gibakolanga enkambi awali ebbendera yʼekibinja kyabwe. Omwekubbemberi wʼekibinja kya Lubbeeni niiye Erizuuli omutaane wa Sedewuli. ");
INSERT INTO gwr_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ekibinjakye ekyo kirimu abantu 46,500. ");
INSERT INTO gwr_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Abʼekika kya Simyoni niibo abakolanga enkambi okulirana abʼekika ekya Lubbeeni. Omwekubbemberi waabwe niiye Syerumiyeeri omutaane wa Zulisyadayi. ");
INSERT INTO gwr_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ekibinjakye ekyo kirimu abantu 59,300. ");
INSERT INTO gwr_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Ni kwiraku abʼekika kya Gaadi, ngʼomwekubbemberi waabwe niiye Eriyasaafu omutaane wa Leweri. ");
INSERT INTO gwr_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ekibinjakye ekyo kirimu abantu 45,650. ");
INSERT INTO gwr_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Abasaiza bonabona abebabalire omu nkambi ya Lubbeeni, ngʼebibinja byabwe owebiri, babbaire 151,450. Abo niibo abaabbanga omu kifo ekyokubiri nga basenguka okwaba omu kifo ekindi. ");
INSERT INTO gwr_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Kaisi awo eWeema eyʼoKunsisinkanirangamu nʼeiraku, aamo nʼenkambi yʼaBaleevi, ngʼeri aakati wʼenkambi egikubbembera nʼegindi egizwaku e nyuma. Basengukanga ngʼowebairanganaku omu nkambi gyabwe, nga basengererya ebbendera gyabwe. ");
INSERT INTO gwr_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Oku lubba olwʼe bugwaisana, niiyo abʼekibinja kyʼEfulaimu e gibakolanga enkambi awali ebbendera yʼekibinja kyabwe. Omwekubbemberi wʼenkambi yʼEfulaimu, niiye Erisaama omutaane wʼAmikudi. ");
INSERT INTO gwr_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Ekibinjakye ekyo kirimu abantu 40,500. ");
INSERT INTO gwr_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Abʼekika kya Manase niibo abakolanga enkambi okulirana eyʼEfulaimu. Omwekubbemberi waabwe niiye oGamalyeri omutaane wa Pedakuzuli. ");
INSERT INTO gwr_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Ekibinjakye ekyo kirimu abantu 32,200. ");
INSERT INTO gwr_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Ni kwiraku abʼekika kya Bbenyamini, omwekubbemberi waabwe niiye Abbidaani omutaane wa Gidyoni. ");
INSERT INTO gwr_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Ekibinjakye ekyo kirimu abantu 35,400. ");
INSERT INTO gwr_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Abasaiza bonabona abebabalire omu nkambi yʼEfulaimu, omu bibinja byabwe babbaire abasaiza 108,100. Abo niibo abaabbanga omu kifo ekyokusatu nga basenguka okwaba omu kifo ekindi. ");
INSERT INTO gwr_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Oku lubba olwʼe mambuka, niiyo abʼekika kya Daani e gibakolanga enkambi yʼekibinja kyabwe awali ebbendera eyʼenkambi yaabwe. Omwekubbemberi wʼenkambi ya Daani, niiye Akiyezeri omutaane wʼAmisyadayi. ");
INSERT INTO gwr_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Ekibinjakye ekyo kirimu abantu 62,700. ");
INSERT INTO gwr_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Abʼekika kyʼAseri niibo abakolanga enkambi okulirana enkambi eya Daani. Omwekubbemberi waabwe nga niiye oPagiyeeri omutaane wʼOkulani. ");
INSERT INTO gwr_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Ekibinjakye ekyo kirimu abantu 41,500. ");
INSERT INTO gwr_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Ni kwiraku abʼekika kya Nafutaali, ngʼomwekubbemberi waabwe niiye Akira omutaane wʼEnani. ");
INSERT INTO gwr_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Ekibinjakye ekyo kirimu abantu 53,400. ");
INSERT INTO gwr_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Abasaiza bonabona abebabalire ababbaire omu nkambi ya Daani, babbaire 157,600. Abo niibo abasembangayo nga basenguka okwaba omu kifo ekindi, nga bagingire ebbendera yʼekibinja kyabwe. ");
INSERT INTO gwr_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Abo niibo aBaisirairi abebabalire okusinzirira oku miryango gyʼabazeiza baabwe. Abasaiza bonabona abebabalire omu nkambi gyonagyona, omu bibinja byabwe, babbaire 603,550. ");
INSERT INTO gwr_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Neye ngʼoMusengwa oweyalagiire oMusa, ibo aBaleevi tibababaliire oku Baisirairi abanaabwe. ");
INSERT INTO gwr_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Batyo aBaisirairi ni batuukirirya byonabyona oMusengwa ebiyalagiire oMusa, ekikoba kiti, ni bakolanga enkambi awali ebbendera gyʼebibinja byabwe, era batyo niiye owebairanganangaku nga basenguka okwaba omu kifo ekindi, okusinzirira oku bika byabwe nʼemiryango gyabwe. ");
INSERT INTO gwr_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Binu niibyo ebikwata okwibyaire lyʼAlooni nʼoMusa, omu kiseera oMusengwa ekiyatumuliiremu nʼoMusa oku Lusozi oSinaayi. ");
INSERT INTO gwr_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ganu niigo amaliina gʼabataane bʼAlooni: ONadabbu omubere, nʼAbbiku, nʼEryezaali, nʼoIsamali. ");
INSERT INTO gwr_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ago niigo amaliina gʼabataane bʼAlooni, abebasukireku amafuta ni babaawula okuweereryanga omu bwakabona. ");
INSERT INTO gwr_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Neye oNadabbu nʼAbbiku bafeereire omumaiso ga Musengwa, owebawaireyo esadaaka omumaisoge nga bakolesya omusyo ogwataikirirya owebabbaire omwidungu lyʼe Sinaayi. Babbaire tibabyalangaku abaana. Kale Eryezaali nʼoIsamali ni baweereryanga omu bwakabona, ebiseera oitewaabwe Alooni oweyabbaire ngʼakaali mwomi. ");
INSERT INTO gwr_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Oyete abʼomu kika kya Leevi, obakwatisye okabona Alooni, bamubbeerenge omu kuweererya. ");
INSERT INTO gwr_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Babbeeranga Alooni nʼekibbula kyonakyona ekyʼaBaisirairi omu omulimo gwʼokuweererya omu Weema eyʼoKunsisinkanirangamu nʼe nza waayo. ");
INSERT INTO gwr_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Balabiriranga ebintu byonabyona ebyʼomu Weema eyo, ni batuukiriryanga obuvunanyizibwa obwandibbaire obwʼaBaisirairi bonabona omu Weema eyo. ");
INSERT INTO gwr_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ABaleevi obaawule oku Baisirairi bonabona obakwatisye Alooni nʼabataane bababbeerenge ebiseera byonabyona. ");
INSERT INTO gwr_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Era wateekawo Alooni nʼabataane, okukolanga omulimo gwabwe ogwʼobwakabona. Omuntu ogondi yenayena eyeebitiriryanga okugukola, bamwitanga-bwiti.” ");
INSERT INTO gwr_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Nze onanyere neeseegeremu ni nnonda aBaleevi omu Baisirairi, omu kifo kyʼokutwala nabuli omubere omu baana abaisuka aBaisirairi. Atyanu aBaleevi basuukire bange, ");
INSERT INTO gwr_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","olwʼokubba nabuli mubere, wange. Okuzwa oku lunaku olunaitiireku ababere bonabona omu kyalo kyʼe Misiri, neeyawuliire nabuli mubere omwIsirairi, owʼabantu nʼowʼebisolo. Yaabbanga wange. Ninze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","OMusa ngʼali omwidungu lyʼe Sinaayi, oMusengwa nʼamukoba ati, ");
INSERT INTO gwr_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Obale aBaleevi ngʼosengererya emiryango nʼebisito byʼabazeiza baabwe. Obale nabuli mwisuka owʼomweri ogumo nʼokukirawo.” ");
INSERT INTO gwr_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Awo oMusa nʼababala ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ganu niigo amaliina agʼabataane ba Leevi: OGerusoni, nʼoKokasi, nʼoMerali. ");
INSERT INTO gwr_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Ganu niigo amaliina agʼabʼomulyango gwa Gerusoni: OLibbuni nʼoSemeeyi. ");
INSERT INTO gwr_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Abʼomulyango gwa Kokasi niibo banu: Amulaamu nʼoIzukali, nʼoKebbulooni nʼoWuziyeeri. ");
INSERT INTO gwr_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Abʼomulyango gwa Merali, niibo banu: OMakuli nʼoMusyi. Abo niibo abʼemiryango gyʼaBaleevi, ngʼebisito byabwe owebyabbaire. ");
INSERT INTO gwr_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Eibyaire lya Gerusoni niiryo eryazwiremu abʼomulyango gwa Libbuni nʼogwa Semeeyi. Abo nga niibo aBagerusoni. ");
INSERT INTO gwr_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Abantu abo bonabona abasaiza nʼabaisuka okuzwera oku wʼomweri ogumo nʼokukirawo, babbaire 7,500. ");
INSERT INTO gwr_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Abʼeibyaire lya Gerusoni niibo abakolanga enkambi e nyuma wʼeWeema ya Musengwa, e bugwaisana. ");
INSERT INTO gwr_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Omwekubbemberi wʼebisito byabwe yabbaire niiye Eriyasaafu omutaane wa Laweri. ");
INSERT INTO gwr_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Omulimo ogwʼeibyaire lya Gerusoni gwabbanga gwʼokulabirira Weema eyʼoKusisinkanirangamu oMusengwa, nʼokulabirira ebigibiikaku, nʼolutimbe olwʼomu mulyango gwayo, ");
INSERT INTO gwr_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","nʼentimbe egisitirira oluuga lwʼeWeema eyo, nʼolutimbe olwʼomu mulyango gwʼoluuga olweruguuliriirye eWeema eyo nʼekyoto, nʼokulabiriranga nʼemiguwa, ekikoba kiti, nabuli kintu ekibakolesya emiguwa egyo. ");
INSERT INTO gwr_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Eibyaire lya Kokasi mwabbairemu abʼomulyango ogwʼAmulaamu, nʼabʼogwa Izukali, nʼabʼogwa Kebbulooni nʼabʼogwa Wuziyeeri. Eryo niiryo eryabbaire eibyaire lya Kokasi. ");
INSERT INTO gwr_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Abantu abo bonabona abasaiza nʼabaisuka okuzwera oku wʼomweri ogumo nʼokukirawo, babbaire 8,600. Abantu abo abʼeibyaire lya Kokasi niibo abalabiriranga eKifo eKitukulye. ");
INSERT INTO gwr_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Abʼeibyaire lya Kokasi ibo bakolanga enkambi ku lubba olwʼe maserengeta gʼeWeema ya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Era ngʼomwekubbemberi wʼabʼemiryango egyo yabbaire niiye Erizefaani omutaane wa Wuziyeeri. ");
INSERT INTO gwr_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Omulimo gwʼabantu abo gwabbanga gwʼokulabirira Sanduuku eyʼeNdagaano, nʼemenza, nʼekikondo kyʼamataala, nʼebyoto, nʼebintu ebyʼomu Weema ya Musengwa abakabona ebibakolesyanga omu kuweererya, nʼokulabiriranga olutimbe lwʼomu mulyango ogwaba omu Kifo eKitukulye eIno, nʼokukolanga emirimo gyonagyona egyetaagisyanga omu bintu ebyo. ");
INSERT INTO gwr_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eryezaali omutaane wʼAlooni okabona, niiye eyabbaire omwekubbemberi wʼaBaleevi. Era niiye ogubalondere okukulira abalabiriranga eWeema eyo. ");
INSERT INTO gwr_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Abʼeibyaire lya Merali mwabbairemu abʼomulyango ogwa Makuli nʼabʼogwa Muusi. Abo niibo ababbaire abʼemiryango gya Merali. ");
INSERT INTO gwr_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Abantu abo bonabona abasaiza nʼabaisuka okuzwera oku wʼomweri ogumo nʼokukirawo, babbaire 6,200. ");
INSERT INTO gwr_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Eyabbaire akulira abʼemiryango gyabwe egyo yabbaire niiye oZuliyeeri omutaane wʼAbbikairi era enkambi yabwe yaabbanga ku lubba olwʼe maserengeta agʼeWeema. ");
INSERT INTO gwr_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ibo abʼeibyaire lya Merali babalondere kulabiriranga fuleemu gyʼeWeema nʼemikiiko gyayo, nʼebikondo byayo, nʼebyoma byʼokwemereryamu ebigere byʼefuleemu, nʼebintu byonabyona ebibakolesya kwiyo. ");
INSERT INTO gwr_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Era ngʼoteekereku nʼokulabiriranga ebikondo byʼekikomera nʼebyoma ebibeemereryamu ebikondo ebyo, nʼenkondo gyaku egyʼebyoma, nʼemiguwa. ");
INSERT INTO gwr_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","OMusa nʼAlooni nʼabataane bʼAlooni, niibo abakolanga enkambi e buzwaisana, omumaiso wʼeWeema eyʼoKusisinkanirangamu oMusengwa. Niibo abalabiriranga eKifo eKitukulye olwʼaBaisirairi. Omuntu ogondi yenayena nga tikabona oba Muleevi oweyaigereranga okumpi nʼekifo ekyo, baabbanga nʼokumwita. ");
INSERT INTO gwr_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ABaleevi bonabona, abasaiza nʼabaisuka okuzwera oku wʼomweri ogumo nʼokukirawo, oMusa nʼAlooni abebabalire okusinzirira oku miryango gyabwe, ngʼoMusengwa oweyalagiire, babbaire 22,000. ");
INSERT INTO gwr_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Awo oMusengwa nʼakoba oMusa ati, “Obale ababere aBaisirairi bonabona, abasaiza nʼabaisuka okuzwera oku wʼomweri ogumo nʼokukirawo, owandiike nʼamaliina gaabwe. ");
INSERT INTO gwr_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Neye omu kifo kyʼababere aBaisirairi bonabona abaisuka, onjawulire aBaleevi babbe bange, Nze oMusengwa. Era onjawulire ebyayo ebyʼaBaleevi bibbe byange, omu kifo kyʼebyayo byonabyona ebibere ebyʼaBaisirairi.” ");
INSERT INTO gwr_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Awo oMusa nʼabala ababere bonabona abaisuka aBaisirairi, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Era ababere bonabona abaisuka, okuzwera oku bʼomweri ogumo nʼokukirawo, abebawandiikire amaliina gaabwe nga bababala, babbaire 22,273. ");
INSERT INTO gwr_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Omu kifo kyʼababere abaisuka aBaisirairi, onjawulire aBaleevi babbe bange, era onjawulire ebyayo byabwe bibbe byange nze oMusengwa, omu kifo kyʼebyayo ebyʼaBaisirairi abandi. ");
INSERT INTO gwr_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Olwʼokununula ababere abaisuka 273 abʼaBaisirairi, ababitamu oku bungi bwʼaBaleevi, ");
INSERT INTO gwr_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","wasolooja esekeri itaanu olwa buli moiza, egyʼekipimo ekitongole ekyʼomu Kifo eKitukulye, esekeri emoiza nga yenkanankana obuzito obwʼegera aabiri. ");
INSERT INTO gwr_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Empiiya egyo wagiwa Alooni nʼabataane, olwʼokununula aBaisirairi abeeyongeiremu.” ");
INSERT INTO gwr_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Atyo oMusa nʼasolooja empiiya kwabo abasigairewo ngʼaBaleevi tibabanunwire. ");
INSERT INTO gwr_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Empiiya egiyasoloojerye oku baisuka ababere abʼaBaisirairi, gyabbaire esekeri 1,365, okusinzirira oku kigera ekitongole ekyʼomu Kifo eKitukulye. ");
INSERT INTO gwr_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Awo oMusa nʼawa Alooni nʼabataane empiiya egyo egyʼokununula, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","OMusengwa tete nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Mubale abasaiza aBaleevi abʼeibyaire lya Kokasi, okusinzirira oku miryango gyabwe nʼebisito byabwe, ");
INSERT INTO gwr_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","okuzwera oku bʼemyanka 30 paka oku bʼemyanka 50, ibo abatuukana okuweererya omu Weema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Omulimo abʼeibyaire lya Kokasi ogubakolanga omu Weema eyo, niigwo ogwʼokulabirira ebintu ebitukulye eino. ");
INSERT INTO gwr_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ekibbula kyonakyona ekyʼaBaisirairi owekyabbanga kisenguka okwaba omu kifo ekindi, Alooni nʼabataane baingiranga omu Weema eyʼoKunsisinkanirangamu, ni baanulayo olutimbe olubatimbire omumaiso wʼeSanduuku eyʼeNdagaano, ni balubiika oku Sanduuku eyo. ");
INSERT INTO gwr_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Awo baabbanga nʼokugiteekaku ekibiikaku ekyʼeidiba lya mbiri, okwo ni baalaku olugoye olwa bbululu ondiko, ni baingirya omu mikobyo gyaku emirabba gyayo emigingiro. ");
INSERT INTO gwr_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Nʼoku menza eyʼemigaati egyokuwaayo eeri oMusengwa, bagyalangaku olugoye olwa bbululu, ni bagiteekaku amasowaani, nʼamabbakuli, nʼamatiba, nʼejaaga egyokukolesyanga nga bawaayo ebyokuwaayo ebyʼebyokunywa. Era bulijo oku menza eyo kwabbangaku emigaati egibawaayo eri oKibbumba. ");
INSERT INTO gwr_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Ebyo babibiikangaku olugoye olutukuliki, ni balubiikaku ekibiika ekyʼeidiba lya mbiri, ni babitya emirabba gyayo emigingiro omu mikobyo gyʼoku menza eyo. ");
INSERT INTO gwr_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Bakwatanga olugoye olwa bbululu ni balubiika oku kikondo eitaala oku lyakira, nʼamataala gaaku, nʼemakansi egisala entambi gyaku nʼamasoniya gaaku, nʼebintu ebibabisamu amafuta agʼomuzaituuni agebakolesya omu mataala ago. ");
INSERT INTO gwr_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ekikondo kyʼeitaala nʼebyabiraku byonabyona babisibanga mu madiba ga mbiri ni babigingira oku mulabba. ");
INSERT INTO gwr_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Nʼoku kyoto ekyʼezaabbu ekyʼokuduunyisiryaku obubbaani, bayalangaku olugoye olwa bbululu, ni bateekaku ekibiikaku ekyʼamadiba ga mbiri, ni babitya emirabba gyakyo emigingiro omu mikobyo gyaku. ");
INSERT INTO gwr_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Bakwatanga ebintu byonabyona ebibakolesya nga baweererya omu Kifo eKitukulye, ni babisiba omu lugoye olwa bbululu, ni babibiikaku eidiba lya mbiri, ni babiteeka oku mulabba. ");
INSERT INTO gwr_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Batoolangamu eikoke omu kyoto kya bbulonzi ekibaweeraku esadaaka egibooca yonayona, kaisi ni bakibiikaku olugoye olutukuliikiriri. ");
INSERT INTO gwr_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Kaisi ni bakiteekaku ebintu byonabyona ebibakolesya nga baweererya oku kyoto aawo, ekikoba kiti, obukalaayi, nʼewuuma egibakwatisya enyama, nʼebitiiyo ebibayoolesya eikoke, nʼekibya ekibakolesya omu kuswankira. Ebintu byʼekyoto ebyo byonabyona babibiikangaku eidiba lya mbiri, ni babitya emirabba gyakyo emigingiro omu mikobyo gyʼoku kyoto ekyo. ");
INSERT INTO gwr_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Awo Alooni nʼabataane owebamaliriryanga okubiika nabuli kintu ekitukulye nʼebindi byonabyona ebikyabiraku, abʼomu nkambi nga batira okutandiika olugendo, aBakokasi baizanga ni babiginga. Neye tibakwatanga oku bintu ebyo ebitukulye, demba ni bafa. Ebyo niibyo ebintu ebyʼomu Weema eyʼoKunsisinkanirangamu, aBakokasi ebibaginganga. ");
INSERT INTO gwr_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eryezaali omutaane wʼAlooni okabona, niiye eyaabbanga nʼomulimo ogwʼokulabiriranga amafuta agʼeitaala, nʼobubbaani obufunya akaloosa, nʼekyokuwayo ekyʼempeke ekya buli lunaku, nʼamafuta agebasuka oku bantu okubaawula nʼagebasuka oku bintu okubiwonga. Era niiye eyalabiriranga eWeema eyo yonayona, nʼebigirimu byonabyona, nʼeKifo eKitukulye nʼebintu byamu byonabyona.” ");
INSERT INTO gwr_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","OMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Muli nʼokubona muti abʼomulyango gwa Kokasi tibaweerawo nakimo omu Baleevi. ");
INSERT INTO gwr_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Neye kinu niikyo ekimubba mubakolerenge kaisi nandi ni bafa, owebasembereranga ebintu ebitukulye eino: Alooni nʼabataane, niibo abaingiranga omu Kifo eKitukulye ni bawa nabuli muntu omulimo ogwʼokukola, nʼekintu ekiyaginga. ");
INSERT INTO gwr_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Neye aBakokasi tibagezyanga okwingira ni balola oku bitukulye waire akaseera akatyayi kati. Owebalikola batyo balifa.” ");
INSERT INTO gwr_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Obale abasaiza abʼeibyaire lya Gerusoni, okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Obale abasaiza bonabona okuzwera oku bʼemyanka 30 okutuuka oku bʼemyanka 50, ibo abatuukana okuweererya omu Weema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gunu niigwo omulimo gwʼabʼeibyaire lya Gerusoni nʼengeri egibagukolangamu: ");
INSERT INTO gwr_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Baginganga entimbe gyʼeWeema yange nze oMusengwa, iyo eWeema eyʼoKunsisinkanirangamu, nʼebigibiikaku, nʼamadiba ga mbiri agagibiika oku ngulu, nʼentimbe egyʼomu mulyango ogwingira omu Weema eyo, ");
INSERT INTO gwr_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","nʼentimbe egisitirira oluuga olweruguuliriirye eWeema yange nʼekyoto, nʼolutimbe olwʼomu mulyango ogwingira omu luuga, nʼemiguwa, nʼebintu byonabyona ebibakolesya oku ntimbe egyo. Bakolanga emirimo gyonagyona egindi egyetaagisya okukola oku bintu ebyo. ");
INSERT INTO gwr_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Alooni nʼabataane, niibo abalungamyanga abʼeibyaire lya Gerusoni omu mirimo gyonagyona egibateekwa okukola, ooba gya kuginga migugu, ooba gya buweererya bundi. Byonabyona ebyʼokuginga ninywe omwababikwatisyanga. ");
INSERT INTO gwr_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Egyo niigyo emirimo abʼeibyaire lya Gerusoni egibakolanga omu Weema eyʼoKunsisinkanirangamu. Bagikolanga ngʼoIsamali omutaane wʼAlooni okabona niiye abalungamya. ");
INSERT INTO gwr_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Abʼeibyaire lya Merali bona wababala okusinzirira oku miryango gyabwe nʼebisito byabwe. ");
INSERT INTO gwr_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Obale abasaiza bonabona okuzwera oku bʼemyanka 30 okutuuka oku bʼemyanka 50, ibo abatuukana okuweererya omu Weema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Omulimo gwabwe omu Weema eyʼoKunsisinkanirangamu, gwabbanga gwa kuginga fuleemu gyʼeWeema eyo, nʼemikiiko gyaku, nʼebikondo byayo, nʼebyoma ebyʼokwemereryamu ebigere byʼefuleemu; ");
INSERT INTO gwr_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","nʼebikondo ebyʼekikomera kyʼoku Weema eyʼoKunsisinkanirangamu, nʼebyoma ebibeemereryamu ebikondo ebyo, nʼenkondo gyʼeweema nʼemiguwa gyayo, nʼebintu byonabyona ebibakolesya oku Weema eyo aamo nʼebindi byonabyona ebibakolesya oku bintu ebyo. Nabuli moiza bamukwatisyanga ebintu ebinanyerenyeere ebyali nʼokuginga. ");
INSERT INTO gwr_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Egyo niigyo emirimo abʼeibyaire lya Merali egibaaba okukolanga, gyonagyona egyo egibakolanga nga baweererya omu Weema eyʼoKunsisinkanirangamu, ngʼoIsamali omutaane wʼAlooni okabona niiye abalungamya.” ");
INSERT INTO gwr_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Awo oMusa nʼAlooni nʼabeekubbemberi abandi abʼaBaisirairi, ni babala abasaiza abʼeibyaire lya Kokasi, okusinzirira oku miryango gyabwe nʼebisito byabwe, ");
INSERT INTO gwr_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","okuzwera oku bʼemyanka 30 okutuuka oku bʼemyanka 50, ibo abatuukana okuweererya omu Weema eyʼoKusisinkanirangamu oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Abo abebabalire okusinzirira oku miryango gyabwe, babbaire 2,750. ");
INSERT INTO gwr_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Abo niibo abʼeibyaire lya Kokasi bonabona, abakolanga omulimo gwʼobuweererya omu Weema eyʼoKusisinkanirangamu, oMusa nʼAlooni abebabalire, ngʼoMusengwa oweyalagiire ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Nʼabasaiza abʼeibyaire lya Gerusoni, abebabalire okusinzirira oku miryango gyabwe nʼebisito byabwe, ");
INSERT INTO gwr_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","okuzwera oku bʼemyanka 30 okutuuka oku bʼemyanka 50, ibo abatuukana okuweereryanga omu Weema eyʼoKusisinkanirangamu, ");
INSERT INTO gwr_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","abo abebabalire okusinzirira oku miryango gyabwe nʼebisito byabwe, babbaire 2,630. ");
INSERT INTO gwr_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Abo niibo abʼeibyaire lya Gerusoni bonabona, abakolanga omulimo gwʼobuweererya omu Weema eyʼoKusisinkanirangamu, oMusa nʼAlooni abebabalire, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Nʼabasaiza abʼomwibyaire lya Merali abebabalire okusinzirira oku miryango gyabwe nʼebisito byabwe, ");
INSERT INTO gwr_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","okuzwera oku bʼemyanka 30, paka oku bʼemyanka 50, ibo abatuukana okuweereryanga omu Weema eyʼoKusisinkanirangamu oMusengwa, ");
INSERT INTO gwr_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","abo abebabalire okusinzirira oku miryango gyabwe, babbaire 3,200. ");
INSERT INTO gwr_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Abo niibo abʼeibyaire lya Merali, oMusa nʼAlooni abebabalire, ngʼoMusengwa oweyalagiire ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Abo niibo aBaleevi bonabona, oMusa nʼAlooni nʼabeekubbemberi abandi abʼaBaisirairi abebabalire, okusinzirira oku miryango gyabwe nʼebisito byabwe, ");
INSERT INTO gwr_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","okuzwera oku bʼemyanka 30, paka oku bʼemyanka 50, ibo abatuukana okuweereryanga nʼokuginganga ebintu omu Weema eyʼoKusisinkanirangamu oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Abo abebabalire babbaire 8,580. ");
INSERT INTO gwr_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","NgʼoMusengwa oweyalagiire ngʼabitira omu Musa, nabuli musaiza bamubalire, ni bamuwa omulimo ogwʼokukolanga, ooba ekintu kyokuginganga. Batyo niiye owebababalire ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Walagiranga aBaisirairi ni batoola omu nkambi nabuli aali nʼendwaire eyʼebigenge, nabuli azwamu amasira olwʼobulwaire, nʼoyo atali omulongoole olwʼokweguunya oku kintu ekifiire. ");
INSERT INTO gwr_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Abasaiza nʼabakali abali batyo, mwabatoolanga omu nkambi ni mubawuluca e nza, kaisi tibazweraku enkambi yaabwe eyo egimbaamu Nze aamo nabo okubba tindongoole.” ");
INSERT INTO gwr_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Batyo aBaisirairi ni bawulucanga e nza wʼenkambi abantu abatyo, ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Okobe aBaisirairi oti, ‘Omusaiza ooba omukali oweyakolanga ekintu ekirumya omu ngeri yonayona, yaabbanga ansunguwairye nze oMusengwa era yaabbanga abbengere. ");
INSERT INTO gwr_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Era omuntu oyo yaabbanga nʼokubbutula ekibbikibbi ekyo ekyakolere. Era yaabbanga nʼokutoola omugaito omu bwizulye olwʼekibbikibbikye, nʼayongeraku nʼekitundu kimo kyokutaanu kyakyo, nʼabiwa oyo ogwalumirye. ");
INSERT INTO gwr_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Neye singa omuntu ogubalumirye yaabbanga afiire neenu ngʼadambaku owʼoluganda olwʼokumpi ogubeezya okuwa omugaito, gwabbanga gwange nze oMusengwa. Era baabbanga nʼokuguwa kabona, ni bagwongeraku nʼontaama omusaiza nabba sadaaka yʼokusoniya ekikole ekibbikibbikye ekiyabbengere. ");
INSERT INTO gwr_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Era nabuli kyokuwaayo kyonakyona ekitukulye aBaisirairi ekibandeeteranga nze oMusengwa, kyabbanga kya kabona ogubakwatisirye ekyokuwaayo ekyo. ");
INSERT INTO gwr_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nabuli kabona ogubakwatisirye ekyokuwaayo ekyo, yaabbanga nʼokukikuuma ni kibba kikye.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Okobe aBaisirairi oti, ‘Singa omuka musaiza yacaamanga nandi nabba mwesigwa okwibaaye, ");
INSERT INTO gwr_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ni yeegaita nʼomusaiza ogondi omu kyama, atyo omukali oyo ni yeebebenyesya, oibaaye nandi nʼamanya, era nga mpaawo mujulizi amulumiriza olwʼokubba tibamwagiriirye, ");
INSERT INTO gwr_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","oibaaye eibuba ni lisetuka nʼasuubiriramu omukaliwe okubba ayendere, ooba nʼamubuusabuusamu, cooka nga tayendanga, ");
INSERT INTO gwr_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","omusaiza oyo yatwalanga omukaliwe oyo e giri okabona. Era yamuweerangayo obusye obwa bbaale ngʼakolesya ekipimo ekyenkana ekiro ooti moiza. Tiyabusukengeku amafuta gʼemizaituuni, waire okubuteekaku obubbaani, olwʼokubba obusye obwo niibwo omusaiza obwawaayo owaabba asuubiriramu omukaliwe okubba yayendere, kaisi awo amazima ni geeraga.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Okabona yayemereryanga omukali oyo omumaiso gʼekyoto kyange nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Awo okabona yakwatanga amaizi agʼomu Weema yange, nʼagasenera omu kibya. Nʼayoola enkungu ansi omu Weema yange eyo, nʼagiteeka omu maizi ago. ");
INSERT INTO gwr_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Kaisi okabona nʼayemererya omukali oyo omumaiso gʼekyoto kyange ekyo nʼasibindula enziiri gya mukali oyo, nʼamukwatisya ekyokuwaayo kidi ekyʼobusye ekibawaireyo olwʼokumusuubiriramu okwenda. Iye okabona nʼakwata amaizi gadi agalimu onkungu amalulu, agaleeta ekiraami.’ ");
INSERT INTO gwr_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Awo okabona yalairisyanga omukali oyo ngʼakoba ati, ‘Singa waabba nga tiwabbangakuuwo omusaiza ogondi eyeegaitire na iwe, era owoobba nga tiwacaamire nʼoyenda ate ngʼoli nʼoibaawo, amaizi ganu amalulu agaleeta ekiraami tigakukolangaku akabbikabbi. ");
INSERT INTO gwr_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Neye singa owoobba nga wacaamire nʼoyenda ate ngʼoli mukali mufumbo, ni weegaita nʼomusaiza ogondi atali ibaawo,’ ");
INSERT INTO gwr_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","olwo awo okabona yaabbanga nʼokulangirira ekiraami oku mukali oyo ati, ‘nsaba nti oMusengwa akusuucanga omuntu abʼolulyolwo ogubaijuluzanga nga balaama, ngʼoMusengwa akusuucirye nanzigaliire, nʼabbimbisya nʼekidaakyo. ");
INSERT INTO gwr_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Oleke amaizi ganu agaleeta ekiraami, gaingire omu kidaakyo gakibbimbye, era gakusuuce nanzigaliire.’ ” “Awo omukali yairangamu ati, ‘Amiina. Oleke kibbe kityo.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Awo okabona yateekanga ebiraami ebyo omu kiwandiiko, kaisi nʼakinaabirya omu maizi gadi amalulu. ");
INSERT INTO gwr_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Era okabona yaabbanga nʼokuwa omukali oyo amaizi amalulu ago agaleeta ekiraami nʼaganywa, ni gaaba omu kida okumuleeteranga obulumi. ");
INSERT INTO gwr_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Awo okabona yatoolanga omu ngalo gyʼomukali oyo ekyokuwaayo ekyʼempeke ekyo ekyʼokumusuubiriramu okwenda, nʼakisiirya nʼakiica omumaiso gange nze oMusengwa kaisi nʼakiteeka oku kyoto. ");
INSERT INTO gwr_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Awo okabona yayoolangaku ekigalo oku kyokuwaayo ekyʼempeke ekyo, nga niiko akamanyiciryo kʼekyokuwaayo ekyo, nʼakyocerya oku kyoto. Olwo kaisi nʼawa omukali amaizi ago nʼaganywa. ");
INSERT INTO gwr_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Omukali oyo singa yaabbanga yayendere nandi nabba mwesigwa okwibaaye, oweyaabbanga anywire amaizi ago agebamuwaire agaleeta ekiraami, gamwabanga omu kida ni gamuleeteranga obulumi obwʼamaani. Ekidaakye kyamubbimbanga, nʼasuuka nanzigaliire, era nʼasuuka kisiraani omu bantube. ");
INSERT INTO gwr_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Neye oweyaabbanga abulaku omusango, tiwaabbengewo kabbikabbi akamutuukaku, era yabyalanga abaana.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Ekyo niikyo ekimwakolanga singa omukali yaabbanga timwesigwa eeri oibaaye nʼayenda, ");
INSERT INTO gwr_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ooba omusaiza eibuba oweryamusetukanga olwʼokusuubiriramu omukaliwe okwenda. Omusaiza oyo yaleetanga omumaiso gange nze oMusengwa, omukaliwe ogwasuubiriramu okubba yayendere, nʼamukwatisya okabona, kaisi okabona nʼakola omukolo ogwo gwonagwona. ");
INSERT INTO gwr_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Omusaiza oyo tiyaabbengeku omusango, wazira omukali bamubonerezanga olwʼekibbikibbikye.” ");
INSERT INTO gwr_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Otumule nʼaBaisirairi obakobe oti, ‘Singa omusaiza ooba omukali yakolanga obweyamo obwʼenjabulo okusuuka omuwonge era ni yeewaayo eeri nze oMusengwa, ");
INSERT INTO gwr_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","yaabbanga nʼokwewalira nakimo omwenge ogwʼemizabbibbu nʼebyokunywa ebindi ebiteemeerya era tiyabbanga nʼokunywaku omwenge ogwʼemizabbibbu omusaasaami waire ekiteemeerya kyonakyona ekindi ekisaasaami. Tiyaabbanga nʼokunywangaku omubisi ogwʼemizabbibbu, waire okulyaku emizabbibbu emibisi waire emikalu. ");
INSERT INTO gwr_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ebiseera byonabyona ebiyamalanga nga muwonge eeri nze oMusengwa, tiyaabbanga nʼokulyaku ekintu kyonakyona ekizwa oku muzabbibbu waire nsigo gyagyo ooba bikuta byaku.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Omu biseerabye byonabyona obyʼobweyamobwe obwʼokwewaayo eeri nze oMusengwa tibamumwengeku enziiri. Yaabbanga nʼokubba mutukulye paka ngʼekiseerakye ekyʼokwewaayo eeri nze oMusengwa kiwoireku; yaabbanga nʼokuleka enziirigye ni gikula. ");
INSERT INTO gwr_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Enaku gyonagyona egiyaabbanga yeewongere eeri nze oMusengwa, tiyaigererenge oku mulambo. ");
INSERT INTO gwr_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Nʼoweyaabbanga afiisirye iteeye, ooba maaye, ooba mugandawe, ooba mwonyoko, tiyaabbenge nʼokumwigereraku okuteesuuca atali mulongoole, olwʼokubba yaabbanga aliku akamanyiciryo akʼenziiri oku mutwegwe akalaga okwewaayokwe eeri oKibbumba. ");
INSERT INTO gwr_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ebiseerabye byonabyona ebyokwewaayokwe yaabbanga muwonge eeri nze oMusengwa.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Era singa omuntu yenayena yaafanga ekibbwatukira ngʼali okumpi nʼomuwonge era omu ngeri eyo omulambo ogwo ni gusuuca enziiri gyʼomuwonge oyo okubba tinnongoole, omuwonge oyo yamalanga enaku musanvu, kaisi nʼamwa omutwegwe, olwo nʼairamu okubba mulongoole. ");
INSERT INTO gwr_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Oku lunaku olwomunaana, yaleetanga empuuwu ibiri ooba enjiiwa entonto ibiri eeri okabona oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Awo okabona yaawangayo omoiza waaku, nʼabba sadaaka eyʼokusoniya ekikole ekibbikibbi, nʼogondi nʼabba sadaaka egibooca yonayona, okukola omukolo gwʼokusuuca omuntu oyo okubba mulongoole olwʼokubba okumpi nʼomulambo. Oku lunaku olunanyere olwo omuntu oyo yairangamu okuwonga omutwegwe egyendi. ");
INSERT INTO gwr_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Era yeewonganga egyendi nze oMusengwa eibbanga erigere eriyamalanga nga yeewaireyo egyendi. Era yaabbanga nʼokuleeta ontaama omusaiza owʼomwanka ogumo, nʼabba sadaaka eyʼokusoniya eibbengo. Neye ebiseerabye ebyʼokwewaayokwe ebyasookere byabbanga bifiire, olwʼokubba yasuukire timulongoole omu kiseerakye ekyʼokwewaayo.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Atyanu linu niiryo eiteeka eryafuganga omuwonge, ebiseerabye ebyʼokubba omuwonge owebyawangaku. Baabbanga nʼokumuleeta oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Awo niiwo egiyaabbanga nʼokuweerawo ebyokuwaayobye binu egyendi: Ontaama omusaiza owʼomwanka ogumo abulaku obuleme nʼabba sadaaka egibooca yonayona, nʼontaama omukali owʼomwanka ogumo abulaku obuleme, nʼabba sadaaka eyʼokusoniya ekikole ekibbikibbi era nʼontaama ogondi omusaiza moiza abulaku obuleme, nʼabba sadaaka eyʼokusyania. ");
INSERT INTO gwr_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Era yaaweerangaku nʼekyokuwaayo ekyʼempeke nʼekyokuwaayo ekyʼebyokunywa nʼekiibo ekyʼemigaati egibulamu okazumbulukuca, egyʼobusye obwʼengaano obusa obubakandiiremu obwito obwʼemizaituuni, nʼobugaati obuyeyere obubasukireku obwito obwʼemizaituuni.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Okabona yaabbanga nʼokuwaayo ebyokuwaayo ebyo egyendi nze oMusengwa, kaisi nʼawaayo nʼesadaaka eyʼokusoniya ekikole ekibbikibbi nʼesadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Yaabbanga nʼokuwaayo ekiibo kidi ekyʼemigaati egibulamu okazumbulukuca era nʼasadaaka nʼontaama odi omusaiza nʼabba sadaaka eyʼokusyania, nʼaweeraku nʼekyokuwaayo ekyʼempeke, nʼekyokuwaayo ekyʼekyokunywa.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Olwo omuwonge oyo yaabbanga nʼokumwera enziirigye oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu, nʼakwata enziiri egyo nga niigyo akamanyiciryo kʼobuwongebwe egyendi, nʼagiteeka omu musyo gwʼekyoto kyʼesadaaka eyʼokusyania na nze.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Omuwonge oyo oweyamalanga okumwaku enziirigye egyʼokwewaayokwe egyendi, okabona yaabbanga nʼokumukwatisya omukono gwa ntaama omusaiza ogubasumbire, nʼamuwaaku nʼomugaati gumo, nʼomugaati omuyeyere gumo, gyonagyona egibulamu okazumbulukuca e giri omu kiibo. ");
INSERT INTO gwr_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Okabona yabiwangayo eeri nze oMusengwa ngʼesadaaka eyʼenjabulo egibasiirya ni baica. Era ebyo byabbanga bitukulye era nga bya kabona, ngʼotwaliireku nʼakafubba akebasiirya ni baica nʼekisambi, ibyo ebibaawiire okubba bya kabona. Ebyo owebyabbanga biwoire, olwo kaisi omuwonge oyo nʼanywa enviinyo.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Eryo niiryo eiteeka eryafuganga omuwonge eyeeyama eeri nze oMusengwa ekiseera ekyamala nga yeewairereyo, era niiryo eryafuganga ekirabo ekindi ekiyaawangayo egyendi. Omuwonge oyo yaabbanga nʼokutuukirirya obweyamobwe ngʼayabira okwiteeka erifuga omuwonge.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Okobe Alooni nʼabataane oti, ‘ABaisirairi mwabasabiranga enkabi muti,’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘OMusengwa abawe enkabi; era abakuumenge; ");
INSERT INTO gwr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","oMusengwa abalolengeku nʼamaiso agʼekisa, era abakwatirenge ekisa; ");
INSERT INTO gwr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","oMusengwa abalolengeku nʼamaiso agʼekisa abawenge eidembe.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Era awo oMusengwa nʼakoba ati, “Singa balangiriranga eriina lyange oku Baisirairi batyo, zena nʼawanga aBaisirairi abo enkabi.” ");
INSERT INTO gwr_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Oku lunaku oMusa oluyamaliire okukomeka eWeema eya Musengwa, yagiswankiireku amafuta okugiwonga eeri oMusengwa, nʼaswankira nʼoku bintu byonabyona ebibakolesya omwo byona okubiwonga. Era nʼamansira nʼoku kyoto nʼoku bintu byonabyona ebibakolesya okwo, okubiwonga eeri oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Awo abeekubbemberi bʼe Isirairi ibo abakulu bʼemiryango gyabwe, nga niibo abakulu bʼebika, ibo ababbeereire omu kubala abantu, ni baleeta ebyokuwaayo. ");
INSERT INTO gwr_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Batwaire ebirabo byabwe binu eeri oMusengwa: Ebigaali mukaaga ebitambulya ebintu nʼenumi ikumi na ibiri. Ekikoba kiti, nga buli beekubbemberi ababiri baleetere ekigaali, era nga buli mwekubbemberi aleetere onumi. Ebintu ebyo ni babireeta omumaiso wʼeWeema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Ojawune ebyokuwaayo byabwe ebyo, aBaleevi babikolesyenge omu mirimo gyʼokuweererya omu Weema eyʼoKunsisinkanirangamu. Era wabibakwatisya, nabuli moiza ngʼebyetaago byʼobuweereryabwe owebuli.” ");
INSERT INTO gwr_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Atyo oMusa nʼakwata ebigaali ebyo nʼenumi, nʼabikwatisya aBaleevi. ");
INSERT INTO gwr_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Nʼakwata ebigaali bibiri nʼenumi ina, nʼabikwatisya abʼeibyaire lya Gerusoni, ngʼebyetaago byʼobuweererya bwabwe owebuli. ");
INSERT INTO gwr_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Nʼakwata nʼebigaali bina nʼenumi munaana nʼabikwatisya abʼeibyaire lya Merali, ngʼebyetaago byʼobuweererya waabwe owebuli. Abʼeibyaire lya Gerusoni nʼabʼerya Merali bonabona bakolanga emirimo egyo ngʼabalungamya niiye oIsamali omutaane wʼAlooni okabona. ");
INSERT INTO gwr_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Neye ibo abʼeibyaire lya Kokasi tiyabawaire, olwʼokubba ebintu ebitukulye ebibabawaire okuginganga, babbaire nʼokubigingiranga ku mabega. ");
INSERT INTO gwr_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Oku lunaku olubakiswankiriire amafuta oku kyoto, abeekubbemberi batwaire ebyokuwaayo ebindi omumaiso waakyo olwʼokukiwonga. ");
INSERT INTO gwr_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Ekyo kyabbaire kityo olwʼokubba oMusengwa yabbaire akobere oMusa ati, “Nabuli lunaku waabbangawo omwekubbemberi moiza eyaleetanga ebyokuwaayobye olwʼokuwonga ekyoto.” ");
INSERT INTO gwr_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Era omwekubbemberi eyatwaire ebyokuwaayobye oku lunaku olusooka yabbaire Nakusoni omutaane wʼAminadabbu owʼomu kika kya Yuda. ");
INSERT INTO gwr_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Ebyokuwaayobye byabbaire, esoniya moiza eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya kimo ekyʼefeeza ekibakolesya omu kuswankira nga kyʼegulaamuzi 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke; ");
INSERT INTO gwr_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","nʼebbakuli moiza eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani; ");
INSERT INTO gwr_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","nʼokitobba moiza, nʼontaama omusaiza moiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nʼawaayo nʼombuli ompanya moiza abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo oNakusoni omutaane wʼAminadabbu ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Oku lunaku olwokubiri, oNasanairi omutaane wa Zuwali era omukulu wʼekika kya Isakaali, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ebyokuwaayobye byabbaire, esoniya moiza eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya kimo ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi ebyo nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Nʼawaayo nʼebbakuli moiza eyʼezaabbu nga yʼegulaamuzi ooti ikumi na ina era ngʼeizwire obubbaani; ");
INSERT INTO gwr_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","nʼokitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Nʼawaayo nʼombuli ompanya moiza abbe sadaaka eyʼokusoniya ekikole ekibbikibbi; ");
INSERT INTO gwr_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo oNasanairi omutaane wa Zuwali ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Oku lunaku lwokusatu, Eryabbu omutaane wa Keroni era omukulu wʼekika kya Zebbulooni, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ebyokuwaayobye byabbaire esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Nʼawaayo nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani; ");
INSERT INTO gwr_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona. ");
INSERT INTO gwr_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Nʼawaayo nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi, ");
INSERT INTO gwr_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Eryabbu omutaane wa Keroni ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Oku lunaku lwokuna, Erizuuli omutaane wa Sedewuli era omukulu wʼekika kya Lubbeeni, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Nʼawaayo nʼebbakuli eyʼezaabbu nga yʼegulaamuzi ooti 110 era ngʼeizwire obubbaani, ");
INSERT INTO gwr_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Erizuuli omutaane wa Sedewuli ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Oku lunaku olwokutaanu, oSyerumiyeeri omutaane wa Zulisyadayi era omukulu wʼekika kya Simyoni, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu, nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Nʼawaayo nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Nʼawaayo nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo oSyerumiyeeri omutaane wa Zulisyadayi ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Oku lunaku lwomukaaga, Eriyasaafu omutaane wa Deweri, era omukulu wʼekika kya Gaadi, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Nʼawaayo nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Nʼawaayo nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Eriyasaafu omutaane wa Deweri ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Oku lunaku olwomusanvu, Erisaama omutaane wʼAmikudi, era omukulu wʼekika kyʼEfulaimu, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke. ");
INSERT INTO gwr_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Nʼawaayo nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Nʼawaayo nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Erisaama omutaane wʼAmikudi ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Oku lunaku olwomunaana, oGamalyeri omutaane wa Pedakuzuli, era omukulu wʼekika kya Manase, nʼawaayo ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke, ");
INSERT INTO gwr_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Nʼawaayo nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo oGamalyeri omutaane wa Pedakuzuli ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Oku lunaku olwomwenda, Abbidaani omutaane wa Gidyoni, era omukulu wʼekika kya Bbenyamini, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke, ");
INSERT INTO gwr_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani, ");
INSERT INTO gwr_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Abbidaani omutaane wa Gidyoni ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Oku lunaku olweikumi, Akiyezeri omutaane wʼAmisyadayi, era omukulu wʼekika kya Daani, nʼatwala ebyokuwaayobye. ");
INSERT INTO gwr_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke, ");
INSERT INTO gwr_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani, ");
INSERT INTO gwr_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Akiyezeri omutaane wʼAmisyadayi ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Oku lunaku olweikumi na lumo, oPagiyeeri omutaane wʼOkulani, era omukulu wʼekika kyʼAseri, nʼatwala ebyokuwaayo. ");
INSERT INTO gwr_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu; nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke, ");
INSERT INTO gwr_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Nʼawaayo nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo oPagiyeeri omutaane wʼOkulani ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Oku lunaku olweikumi na ibiri, Akira omutaane wʼEnani, era omukulu wʼekika kya Nafutaali, nʼatwala ebyokuwaayo. ");
INSERT INTO gwr_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ebyokuwaayobye byabbaire, esoniya eyʼefeeza nga yʼekiro moiza nʼekitundu, nʼekibya ekibakolesya omu kuswankira nga kyʼegulaamuzi ooti 800 okusinzirira oku bipimo byʼomu Kifo eKitukulye, byombi nga biizwire obusye obwʼengaano obusa era obubatabwiremu obwito obwʼemizaituuni, okubba ekyokuwaayo ekyʼempeke, ");
INSERT INTO gwr_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","nʼebbakuli eyʼezaabbu nga yʼegulaamuzi 110 era ngʼeizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Nʼawaayo nʼonte okitobba, nʼontaama omusaiza, nʼontaama omusaiza owʼomwanka ogumo, okubba esadaaka egibooca yonayona, ");
INSERT INTO gwr_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","nʼombuli ompanya abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Nʼawaayo enumi ibiri, nʼentaama ensaiza itaanu, nʼembuli empanya itaanu, nʼentaama ensaiza itaanu egyʼomwanka ogumo gumo; ngʼesadaaka eyʼokusyania. Ebyo niibyo ebyokuwaayo Akira omutaane wʼEnani ebiyawaireyo. ");
INSERT INTO gwr_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Binu niibyo ebyokuwaayo abeekubbemberi ba Isirairi ebibawaireyo oku lunaku olubawongeireku ekyoto, era ebibatabwiremu obwito obwʼemizaituuni; esoniya ikumi na ibiri egyʼefeeza, nʼebibya ikumi na bibiri ebyʼefeeza ebibakolesya omu kuswankira; nʼebbakuli ikumi na ibiri egyʼezaabbu. ");
INSERT INTO gwr_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Nabuli soniya eyʼefeeza yabbaire yʼekiro moiza nʼekitundu, kaisi nabuli kibya ekyʼefeeza nga kyʼegulaamuzi ooti 800. Ebintu byonabyona ebyʼefeeza nga byerya ekiro ooti 28 okusinzirira oku kipimo kyʼomu Kifo eKitukulye. ");
INSERT INTO gwr_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Ebbakuli eikumi na ibiri egyʼezaabbu nga buli moiza yʼegulaamuzi 110 era gyonagyona aamo nga gyerya ekiro ooti moiza nʼekitundu okusinzirira oku kipimo ekyʼomu Kifo eKitukulye. Era gyonagyona gyabbaire giizwire obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ente ebitobba byonabyona ebyʼesadaaka egibooca yonayona, gyabbaire ikumi na ibiri, nʼentaama ensaiza ikumi na ibiri, nʼentaama ensaiza egyʼomwanka ogumo gumo ikumi na ibiri, aamo nʼebyokuwaayo ebyʼempeke, era nʼembuli empanya ikumi na ibiri egyʼesadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ente egyʼesadaaka eyʼokusyania gyabbaire 24, nʼentaama ensaiza 60, nʼembuli empanya 60, nʼentaama ensaiza egyʼomwanka ogumo 60. Ebyo niibyo ebyokuwaayo ebibawaireyo olwʼokuwonga ekyoto nga bamalire okukisukaku amafuta. ");
INSERT INTO gwr_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","OMusa oweyaingiire omu Weema eyʼoKusisinkanirangamu oMusengwa okutumula nʼoMusengwa, nʼawulira eigono lya Musengwa ngʼatumula naye ngʼasinzirira engulu, aakati wʼabakeruubbi ababiri iyo ntebe ya Kibbumba onanyere okusaasira, oku Sanduuku eyʼeNdagaano. Era oMusengwa nʼatumula naye. ");
INSERT INTO gwr_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Okobe Alooni oti, ‘Owewaabbanga oteeka amataala angulu oku kikondo kyago, waabbanga nʼokubona oti amataala ago omusanvu gonagona gamoleka mu kifo ekiri omumaiso wʼekikondo kyago.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Alooni nʼakolanga atyo, nʼateekangawo amataala ni gamolekanga omu kifo ekiri omumaiso wʼekikondo kyago era ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Enu niiyo engeri egibakoleremu ekikondo kyʼamataala ago: Bakiyeesere mu zaabbu, ekikoba kiti, okuzwera oku ntyamiro okutuuka engulu oku kujolija okufaanana ooti bimuli. Ekikondo ekyo bakiyeesere nga kifaananira nakimo ngʼoMusengwa oweyalagire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","OMusengwa ni yeeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Oyawule aBaleevi omu Baisirairi abandi, era okole omukolo gwʼokubasuuca okubba abalongoole. ");
INSERT INTO gwr_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Okukola omukolo ogwo wakola oti, wabaswankiraku amaizi agebakolesya oku mukolo gwʼosuuca abantu okubba balongoole, kaisi nʼobakoba ni beemwa emibiri gyabwe gyonagyona, era ni booza ebizwalo byabwe, awo ni babba beekolereku omukolo gwʼokwesuuca okubba abalongoole. ");
INSERT INTO gwr_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Awo ebyo nga biwoire, batoola onte okitobba aamo nʼekyokuwaayo ekyʼempeke ekyʼobusye obwʼengaano obusa, era obubatabwiremu obwito bwʼemizaituuni. Batoola nʼonte ogondi okitobba, abbe sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Olwo wakumbaania ekibbula kyonakyona ekyʼaBaisirairi, kaisi nʼokoba aBaleevi ni baigerera omumaiso wʼeWeema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Ngʼomalire okukoba aBaleevi okwigerera omumaiso gange, aBaisirairi bateeka engalo oku Baleevi. ");
INSERT INTO gwr_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Alooni yabawonga eeri Nze Musengwa, ngʼesadaaka eyʼenjabulo egibasiirya ni baica, okubaabula oku Baisirairi abandi kaisi ni bayezya okumpeereryanga Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Awo aBaleevi bateeka engalo gyabwe oku mitwe gyʼente gidi egyʼokusadaaka, ni bawaayo onte omoiza eeri Nze oMusengwa nʼabba sadaaka eyʼokusoniya ekikole ekibbikibbi, nʼogondi nʼabba sadaaka egibooca yonayona. Alooni yakolesya ebyokuwaayo ebyo, okukola omukolo ogwʼokusuuca aBaleevi okubba abalongoole. ");
INSERT INTO gwr_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Wayemererya aBaleevi omumaiso gʼAlooni nʼabataane, era nʼobawonga eeri Nze, ngʼesadaaka eyʼenjabulo egibasiirya ni baica. ");
INSERT INTO gwr_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Otyo niiye owewaabula aBaleevi oku Baisirairi abandi, era aBaleevi ni babba bange. ");
INSERT INTO gwr_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Ngʼomalire okubatukulya nʼokubawonga eeri Nze oMusengwa ngʼesadaaka eyʼenjabulo egibasiirya ni baica, aBaleevi baabbanga batuukana okuweereryanga omu Weema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Ekyo kityo olwʼokubba nabeerondeire omu Baisirairi. Nabeetwaliire nakimo ngʼabange omu kifo kyʼabaana ababere abaisuka abʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Abaana ababere abaisuka bonabona omu Baisirairi bange, era nabuli kisolo kyʼaBaisirairi ekibere kyange. Nabeeyawuliire oku lunaku olunaitiireku nabuli kibere kyonakyona omu kyalo kyʼe Misiri. ");
INSERT INTO gwr_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Era atyanu aBaleevi niibo abeneetwaliire omu kifo kyʼababere bonabona abaisuka omwIsirairi. ");
INSERT INTO gwr_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ntoire aBaleevi omu Baisirairi abandi bonabona, ni mbakwatisya Alooni nʼabataane ngʼekirabo, aBaleevi baweereryenge omu Weema eyʼoKunsisinkanirangamu oku lwʼaBaisirairi, era bakolenge nʼomukolo ogwʼokusuuca abantu okubba abalongoole, kaisi okawumpuli tiyalumbanga aBaisirairi owebaigereranga omu Kifo eKitukulye.” ");
INSERT INTO gwr_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ekyo niikyo oMusa nʼAlooni nʼekibbula kyonakyona ekyʼaBaisirairi ekibakolere oku Baleevi, nga nakimo oMusengwa oweyalagiire oMusa ebikwata oku Baleevi. ");
INSERT INTO gwr_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ABaleevi ni bakola omukolo ogwʼokwesuuca okubba abalongoole, ni booza ebizwalo byabwe. Awo Alooni nʼabawonga eeri oMusengwa, ngʼesadaaka eyʼenjabulo egibasiirya ni baica, omu ngeri eyo nabba akolere omukolo ogwʼokubasuuca okubba balongoole. ");
INSERT INTO gwr_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ebyo owebyawoire, aBaleevi ni baaba okukola omulimo gwabwe ogwʼobuweererya omu Weema eyʼoKusisinkanirangamu oMusengwa, ngʼAlooni nʼabataane niibo ababalungamya. Kale aBaisirairi ni bakola byonabyona oku Baleevi ngʼoMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Linu niiryo eiteeka eeri aBaleevi: Abasaiza abʼemyanka 25 nʼokukirawo, niibo abakolanga omulimo ogwʼobuweererya omu Weema eyʼoKunsisinkanirangamu Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Neye owebatuucanga emyanka 50, baabbanga nʼokulekeraawo okuweererya okwo, ni bawuumula. ");
INSERT INTO gwr_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Abantu abo abawuumwire bayinzanga okubbeeraku aBaleevi abanaabwe abaabbanga bavunaanyizibwa, nga babalagirira okutuukirirya omulimo gwabwe ogwʼobuweererya omu Weema eyʼoKunsisinkanirangamu, neye ibo abananyere tibaabbenge nʼokukola omulimo ogwo. Otyo wewategeka aBaleevi okutuukiriryanga omulimo gwabwe.” ");
INSERT INTO gwr_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Omu mweri ogusooka omu mwanka ogwokubiri ngʼaBaisirairi bazwire omu kyalo kyʼe Misiri, oMusengwa yatumwire nʼoMusa omwidungu lyʼe Sinaayi ati, ");
INSERT INTO gwr_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Okobe aBaisirairi bakolenge oMukolo ogwʼoKutambukirya omu biseera byagwo ebituuce. ");
INSERT INTO gwr_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Era bagukolenge igulo oku lunaku olweikumi na ina omu mweri ogusooka. Bagukolenge mu biseera byagwo ebituuce, okusinzirira oku mateeka gaagwo gonagona nʼebiragiro byagwo byonabyona.” ");
INSERT INTO gwr_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kale oMusa nʼakoba aBaisirairi okukolanga oMukolo ogwo ogwʼoKutambukirya. ");
INSERT INTO gwr_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Era ni bagukolera omwidungu lyʼe Sinaayi eigulo, oku lunaku olweikumi na ina olwʼomweri ogusooka. Era aBaisirairi ni bakola byonabyona nga nakimo oMusengwa oweyalagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Neye ni wabbaawo abantu abandi abanandi babba omu kukola oMukolo ogwo ogwʼoKutambukirya olwʼokubba babbaire tibalongoole olwʼokukwata oku mulambo. Kale ni baaba eeri oMusa nʼAlooni oku lunaku olwo olwʼoMukolo, ");
INSERT INTO gwr_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","era ni bakoba oMusa bati, “Tusuukire batali balongoole, olwʼokukwata oku mulambo. Neye ekyo kitugaana kitya iswe okutaweerayo aamo nʼaBaisirairi abanaiswe ekyokuwaayo eeri oMusengwa, omu biseera byakyo ebituuce?” ");
INSERT INTO gwr_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","OMusa nʼabairamu ati, “Mukuumeku nsooke njabe mbuulye oMusengwa ekyakoba oku nsonga yaanywe.” ");
INSERT INTO gwr_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Awo oMusengwa nʼakoba oMusa, ");
INSERT INTO gwr_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","okukoba aBaisirairi ati, “Abamo mwinywe, ooba omu bʼeibyaire lyanywe, owemutaabbenge balongoole olwʼokukwata oku mulambo, ooba owemwabbanga omu lugendo lwʼe yala, mwayinzanga okukola oMukolo gwʼoKutambukirya kwa Musengwa. ");
INSERT INTO gwr_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Mwagukolanga omu mweri ogwiraku, eigulo oku lunaku olweikumi na ina. Mwalyanga ontaama oyo omutomuto omusaiza owʼomukolo ogwo nʼemigaati egibulamu okazumbulukuca, nʼosyodo owʼebigala omululululu. ");
INSERT INTO gwr_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Timwabbangaku nʼekimufiikisyawo ni kibbaawo paka amakeezi, waire okuvuna eigumba lya ntaama oyo kadi limo. Mwabbanga nʼokukuuma amateeka gonagona agʼoMukolo ogwʼoKutambukirya. ");
INSERT INTO gwr_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Neye singa omulongoole nga tali mu lugendo, yakayanga okukola oMukolo ogwʼoKutambukirya, tinamubalenge okubba moiza oku bantu bange, olwʼokubba nandi nʼawaayo eeri nze oMusengwa ekyokuwaayo omu kiseera kyakyo ekituuce. Omuntu oyo bamubonerezanga olwʼekibbikibbikye. ");
INSERT INTO gwr_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“Era omunamawanga atyama mwinywe oweyatakanga okukola oMukolo ogwʼoKutambukirya, yatuukiriryanga eiteeka lyʼomukolo ogwo era nʼobulombolombo bwagwo. Eiteeka eryo niiryo eryakolanga oku munamawanga nʼoku mubyalwa.” ");
INSERT INTO gwr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Oku lunaku olubakomekeireku eWeema eya Musengwa, ekireri kyagibiikireku. Kyagibiikireku okuzwa eigulo paka makeezi nga kiri ooti musyo ogwaka. ");
INSERT INTO gwr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Kityo wekyabbanga bulijo. Ekireri kyagibiikanga omusana, kaisi obwire ekireri ekyo ni kibbanga ooti musyo ogwaka. ");
INSERT INTO gwr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Nabuli ekireri owekyasimbukanga ni kizwa oku Weema eyo, aBaisirairi basengukangawo. Omu kifo awekyayemereranga, aawo aBaisirairi webakolanga enkambi. ");
INSERT INTO gwr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ABaisirairi basimbukanga ngʼoMusengwa amalire kubalagira, era bakolanga enkambi ngʼamalire kubalagira. Ekiseera kyonakyona ekireri owekyabbanga kikaali kiri e ngulu wʼeWeema, aBaisirairi basigalanga mu nkambi. ");
INSERT INTO gwr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Era ekireri owekyamalanga enaku enyingi nga kiri e ngulu wʼeWeema eya Musengwa, aBaisirairi bagonderanga ekiragiro kya Musengwa, nandi ni basimbukawo. ");
INSERT INTO gwr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Olwisi ekireri kyamalanga enaku ntono oku Weema eyo. Era bona bagonderanga ekiragiro kya Musengwa, ni basigala omu nkambi. Oweyabalagiranga okusenguka, nga basengukawo. ");
INSERT INTO gwr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Era olwisi ekireri kyabbangawo okuzwa eigulo paka makeezi. Owekyasimbukanga ni kizwawo, awo nga batambula. Ooba owekyabbangawo omusana nʼobwire, era kyasookanga kuzwawo kaisi ni batambula. ");
INSERT INTO gwr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ekireri nʼowekyamalanga oku Weema eyo enaku eibiri, ooba omweri, ooba okukirawo, aBaisirairi nga basigala omu nkambi eyo, nandi ni basengukawo. Neye owekyasimbukangawo, nga basengukawo. ");
INSERT INTO gwr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Bakolanga enkambi, era basengukanga nga bakolera ku kiragiro kya Musengwa ekiyabawanga ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Oyeese amakondeere mabiri omu feeza, ogakolesyenge okweta ekibbula kyonakyona ekyʼaBaisirairi okukumbaana, era nʼokubalagiranga okusengula enkambi. ");
INSERT INTO gwr_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Owebagafuwanga gombi, ekibbula kyonakyona ekyʼaBaisirairi kyakumbaaniranga e gyoli, oku mulyango gwʼeWeema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Neye owebafuwangaku emoiza, olwo abeekubbemberi, ekikoba kiti, abakulu bʼemiryango gya Isirairi niibo abakumbaaniranga e gyoli. ");
INSERT INTO gwr_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Owebagifuwanga ni bakutula mangu, ebika ebiri omu nkambi e giri e bugwaisana byatandiikanga okusenguka. ");
INSERT INTO gwr_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Owebagifuwanga omulundi ogwokubiri ni bakutula mangu, ebika ebiri omu nkambi e giri e maserengeta byatandiikanga okusenguka. Kale okufuwa ekondeere ni bakutula mangu, kaabbanga kamanyiciryo kʼabantu kutandiika kusenguka. ");
INSERT INTO gwr_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Neye owekwabbanga kweta bantu kukumbaana, bagifuwanga ni balwakuuwo okukutula. ");
INSERT INTO gwr_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Abʼeibyaire lyʼAlooni ibo abakabona, niibo abafuwanga amakondeere ago. Ekiragiro ekyo inywe nʼabʼemirembe gyonagyona egyaliirawo mwakikuumanga. ");
INSERT INTO gwr_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Era omu kyalo kyanywe owemwalwananga olutalo okwetaasa abalabe ababali okubbikubbi, kale mwafuwanga amakondeere ago ni mukutula mangu. Kaisi awo Nze oMusengwa iye oKibbumba waanywe ni mbeebukirya inywe, ni mbalamya abalabe baanywe. ");
INSERT INTO gwr_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Mwafuwanga amakondeere omu biseera byanywe ebyʼeisangaalo, nʼoku mikolo gyanywe egibalagira nabuli mwanka, era nʼoku mikolo egimukola oku ntandiika ya buli mweri. Era mwafuwanga amakondeere nga muwaayo esadaaka egibooca yonayona, nʼesadaaka eyʼokusyania. Olwo Nze oKibbumba waanywe nabeebukiryanga inywe, ni mbabbeera. Ninze oMusengwa oKibbumba waanywe.” ");
INSERT INTO gwr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Oku lunaku olwabiri omweri ogwokubiri omu mwanka ogwokubiri, okuzwa aBaisirairi owebazwire e Misiri, ekireri kyasimbukire ni kizwa e ngulu wʼeWeema eya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Awo aBaisirairi ni basenguka okuzwa omwidungu lyʼe Sinaayi, ni batambula kyalo ku kyalo, paka ekireri owekyemereire omwidungu lyʼe Palani. ");
INSERT INTO gwr_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Basengukire omulundi ogwo ogusooka, ngʼoMusengwa oweyabalagiire ngʼabitira omu Musa. ");
INSERT INTO gwr_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Abʼekika kya Yuda nʼabʼebika ebindi abebabbaire nabo omu nkambi eyo ni baginga ebbendera yaabwe, ni beekubbemberamu okwaba. Omwekubbemberi wʼekika kya Yuda yabbaire niiye oNakusoni omutaane wʼAminadabbu. ");
INSERT INTO gwr_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Iye omwekubbemberi wʼekika kya Isakaali yabbaire niiye oNasanairi omutaane wa Zuwali. ");
INSERT INTO gwr_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Kaisi omwekubbemberi wʼekika kya Zebbulooni nga niiye Eryabbu, omutaane wa Keroni. ");
INSERT INTO gwr_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Olwo eWeema eya Musengwa ni bagiiya. Abʼeibyaire lya Gerusoni nʼerya Mereki ni bagiginga, ni basengukanga nga basenjaaku enkambi eyʼabʼekika kya Yuda nʼebika ebindi abebabbaire nabo. ");
INSERT INTO gwr_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Awo ni kwiraku abʼekika kya Lubbeeni nʼabʼebika ebindi abebabbaire nabo omu nkambi ni baginga ebbendera eyʼenkambi yaabwe. Omwekubbemberi wʼekika kya Lubbeeni, yabbaire Erizuuli omutaane wa Sedewuli. ");
INSERT INTO gwr_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Nʼomwekubbemberi wʼekika kya Simyoni, yabbaire Syerumiyeeri omutaane wa Zulisyadayi. ");
INSERT INTO gwr_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Kaisi iye omwekubbemberi wʼekika kya Gaadi nabba Eriyasaafu omutaane wa Deweri. ");
INSERT INTO gwr_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Awo ni kwiraku aBaleevi abʼekika kya Kokasi nga bagingire ebyʼomu Kifo eKitukulye. Era ibo baabanga okutuuka awaabba enkambi, ngʼeWeema nago bamalire okugikomeka. ");
INSERT INTO gwr_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ni kwiraku abʼekika kyʼEfulaimu nʼabʼebika ebindi abebabbaire nabo omu nkambi nga bagingire ebbendera yaabwe. Omwekubbemberi wʼekibinja kyʼekika kyʼEfulaimu yabbaire Erisaama omutaane wʼAmikudi. ");
INSERT INTO gwr_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Iye omwekubbemberi wʼekibinja kyʼekika kya Manase yabbaire Gamalyeri omutaane wa Pedakuzuli. ");
INSERT INTO gwr_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Kaisi omwekubbemberi wʼekika kya Bbenyamini nabba Abbidaani omutaane wa Gidyoni. ");
INSERT INTO gwr_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ibo abʼekika kya Daani nʼabʼebika ebindi abebabbaire nabo omu nkambi nga bagingire ebbendera yaabwe, niibo ababbaire nʼokukuuma aBaisirairi kale nga bali nʼokubazwaku nyuma. Omwekubbemberi wʼekibinja kyʼekika kya Daani nga niiye Akiyezeri omutaane wʼAmisyadayi. ");
INSERT INTO gwr_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Iye omwekubbemberi wʼekibinja kyʼekika kyʼAseri yabbaire niiye oPagiyeeri omutaane wʼOkulani. ");
INSERT INTO gwr_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Kaisi omwekubbemberi wʼekibinja kyʼekika kya Nafutaali nabba Akira omutaane wʼEnani. ");
INSERT INTO gwr_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Eyo niiyo engeri ebika byʼaBaisirairi egibyecaanangamu nabuli owebaabbanga basenguka. ");
INSERT INTO gwr_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Lumo oMusa yakobere oKobbabbu omwonyoko wa mukaliwe, era omutaane wa Leweri oMumidiyaani oiteeye wa mukali wa Musa ati, “Tuli kutambula twaba omu kifo, oMusengwa ekiyasuubizire okutuwa. Oize twabe, twakubitya kusani olwʼokubba oMusengwa yatusuubizire iswe aBaisirairi ebintu ebisa.” ");
INSERT INTO gwr_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","OKobbabbu nʼamwiramu ati, “Bbe nze tinaabe. Ntaka kukanga mu kyalo kyʼe waiswe omu bantu bʼekika kyange.” ");
INSERT INTO gwr_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Neye era oMusa nʼamukoba ati, “Nkwegairiire tiwatuleka, olwʼokubba niiwe omaite ebifo ebitwezya okukolamu enkambi omwidungu, era niiwe oyezya okutulungamya. ");
INSERT INTO gwr_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Era singa twaba na iwe, ebisa byonabyona oMusengwa ebiyatukoleranga, twabigabaniranga aamo na iwe.” ");
INSERT INTO gwr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Awo ni bazwa oku lusozi olwa Musengwa, ni batambula olugendo lwʼenaku isatu. NgʼeSanduuku eyʼeNdagaano eya Musengwa ebeekubbembeiremu, okunoonia ekifo oMusengwa ekiyabalaga okukolamu enkambi eyʼokuwuumuliramu. ");
INSERT INTO gwr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Owebaabbanga basenguka okuzwa omu nkambi, ekireri kya Musengwa bakibonanga omusana nga kibaliku e ngulu omwibbanga. ");
INSERT INTO gwr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Nabuli owebasetulanga eSanduuku eyʼeNdagaano okutandiika olugendo, oMusa ngʼasaba ati, “Oo Musengwa, osetuke! Oleke abalabebo basalaanike. Oleke abo abakucaawa bakwiruke.” ");
INSERT INTO gwr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Era owebayemereryanga eSanduuku eyʼeNdagaano omu kifo ekibakolamu enkambi, oMusa ngʼasaba ati, “Oo Musengwa, oire omu mitwalo nʼemitwalo gyʼaBaisirairi.” ");
INSERT INTO gwr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Lwabbaire lumo abantu ni batandiika okwezuluguma eeri oMusengwa olwʼebigosi ebyabbaire biri kubatuukangaku. OMusengwa oweyawuliire, nʼasunguwala. Atyo nʼasindika omusyo omu bantu era ni gujigirica e mbalembale wʼenkambi. ");
INSERT INTO gwr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Abantu owebeekungiriire oMusa, yeegairiire oMusengwa, era omusyo ni gwikaikana. ");
INSERT INTO gwr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Nʼolwekyo ekifo ekyo ni bakiwa eriina bati, “Tabbera,” olwʼokubba omusyo gwa Musengwa gwakire mwibo. ");
INSERT INTO gwr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Awo abʼekibbula kyʼabanamawanga ababbaire batambula nʼaBaisirairi, ni bayoya ino okulyaku enyama, nʼaBaisirairi bona ni beeririgana nga bakoba bati, “Naani eyatusunisyaku enyama ni tulyaku? ");
INSERT INTO gwr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Kale tukaali twebukirya enyanyi egitwalyanga egyʼobusa e Misiri, oteekeku ocuukamba nʼomeroni, nʼobutungulu obubalya bikoola, nʼebitungulu nʼokatungulucumu. ");
INSERT INTO gwr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Neye atyanu eireke lyonalyona lyatuwoiremu. Titukaali tuli nʼekyokulya ekindi ekitubonaku, wazira emaanu eenu yonkani!” ");
INSERT INTO gwr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Emaanu yabbaire njeru nga ntontono ooti nsigo wʼekimera ekibeeta kolyanda. ");
INSERT INTO gwr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Abantu baabanga ni bagikumbaania, ni bagisyera oku mengo, ooba ni bagidundira omu bibulo. Era ni bagisumbira omu maseefulya, ooba ni bagisumbamu obugaati. Yawoomanga ooti bugaati obubasiikiire obwito obwʼemizaituuni. ");
INSERT INTO gwr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Olume owerwakwatanga obwire omu nkambi, emaanu yona ngʼegwa. ");
INSERT INTO gwr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","OMusa nʼawulira abantu nga beezuluguma, nga bali nʼabʼomu bisito byabwe oku miryango gyʼeweema gyabwe. OMusengwa nʼasunguwala ino era oMusa nʼanakuwala. ");
INSERT INTO gwr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","OMusa nʼakoba oMusengwa ati, “Lwaki ombitya Nze omuweereryawo okubbikubbi otyo? Lwaki tonsaasira? Lwaki ontiika obuvunaanyizibwa bwʼabantu banu bonabona? ");
INSERT INTO gwr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nze nabbaireku kida ni mbyala abantu banu bonabona, kaisi onkobe oti mbaginge omu kifubba, ngʼomuleri owaaginga omwana ayonka, mbatwale omu kyalo e kiwalayiire okuwa abazeiza baabwe? ");
INSERT INTO gwr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Njaba kutoola yaina enyama eginaawa abantu banu bonabona? Mbanu bankungirira nga bakoba bati, ‘Otuwe enyama tulye.’ ");
INSERT INTO gwr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Timpezya okwetiika obuvunaanyizibwa bwʼabantu banu bonabona zenkani. Obuzito obwo bubitiriri ino ku nze. ");
INSERT INTO gwr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Owoobba oyaba kumbityanga otyo, nkwegairiire wakiri onjite saawa nanyere enu, nkusaba onsaasire tiwandeka okugada ntyo.” ");
INSERT INTO gwr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Awo oMusengwa nʼakoba oMusa ati, “Onsoloojerye abasaiza 70, aboomaite ngʼabeekubbemberi era nga bakungu bʼaBaisirairi, obaleete oku Weema eyʼoKunsisinkanirangamu, beemerere awo aamo na iwe. ");
INSERT INTO gwr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Nze nʼaiza ni ntumula na iwe aawo. Era natoola oMwoyo ngʼaali kwiwe, ni mmuteeka kwibo, bakubbeerengeku obuvunaanyizibwa obwʼokulabiriranga abantu, kaisi tiwaabbanga ku niiwe wenkani.” ");
INSERT INTO gwr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Era okobe abantu abo oti, ‘Mwetukulye okwetegekera olunaku olweizo olumwaliira enyama. Nze oMusengwa mpuliire okwezuluguma kwanywe nga mwebuulya naani eyabawa enyama ni mulya, nga mukoba muti singa muliireku enyama. Kale nze oMusengwa nabawa enyama ni mugirya. ");
INSERT INTO gwr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Timwagirye lunaku lumo ooba ibiri, ooba itaanu ooba ikumi, waire aabiri. ");
INSERT INTO gwr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Neye mwagirya mweri mulamba, paka oweyalibasinya nʼebafunyira wundi. Ekyo kyalibba kityo olwʼokubba muneegaine nze oMusengwa aali mwinywe, ni mwezulugumira omumaiso gange nga mukoba muti, lwaki mwazwire omu kyalo kyʼe Misiri!’ ” ");
INSERT INTO gwr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Neye oMusa nʼakoba ati, “Abantu abendi nabo bali abasaiza 600,000, era nʼokoba oti wabawa enyama egibaalya omweri omulamba! ");
INSERT INTO gwr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Waliwo ebiraalo byʼentaama nʼente ebibeezya okusala ni bibamala? Nʼowebakumbaania enyanyi gyonagyona omu nyanza, gyabamala?” ");
INSERT INTO gwr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","OMusengwa nʼairamu oMusa ati, “Obwezye bwange buliku ekikomo? Atyanu oyaba okubona ooba ngʼekintumula kyatuukirira, ooba nga tikyatuukirire.” ");
INSERT INTO gwr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kale oMusa nʼawuluka, nʼakobera abantu oMusengwa ebyatumwire. Nʼakumbaania abasaiza 70 oku beekubbemberi baabwe, nʼabateekawo ni beemerera okweruguulirirya eWeema eyʼoKusisinkanirangamu oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Awo oMusengwa nʼaika ngʼali omu kireri, nʼatumula nʼoMusa. Nʼatoola oMwoyo ngʼeyabbaire oku Musa, nʼamuteeka oku beekubbemberi 70. OMwoyo oweyabaikireku, ni batandiika okuwa obunaabbi, neye tibairiremu okukikola omulundi ogundi. ");
INSERT INTO gwr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Neye ababiri Eridaadi nʼoMedadi oku beekubbemberi 70, babbaire basigaire mu nkambi, nga tibawulukire okwiza oku Weema eyʼoKusisinkanirangamu oMusengwa. Omwoyo nʼabaikaku bona, era ni batandiika okuwa obunaabbi nga bali eeyo omu nkambi. ");
INSERT INTO gwr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ni wabbaawo omwisuka eyairukire nʼayaba okukobera oMusa ati, “Eridaadi nʼoMedadi bali eedi omu nkambi bawa obunaabbi.” ");
INSERT INTO gwr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Awo oYoswa omutaane wa Nuuni eyabbaire omubbeeri wa Musa okuzwa nga mwisuka, nʼeigono eryʼangulu nʼakoba oMusa ati, “Mukulu, oyabe obaloberye!” ");
INSERT INTO gwr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Neye oMusa nʼamwiramu ati, “Ondumirwa ino? Nze nanditakire abantube bonabona babbe banaabbi, era oMusengwa abaiceeku oMwoyowe, babbe banaabbi.” ");
INSERT INTO gwr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Awo oMusa nʼabeekubbemberi 70 ni bakanga omu nkambi. ");
INSERT INTO gwr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Awo oMusengwa nʼasindika ompunga, nʼaleeta enindu okuzwa oku nyanza, nga giguluka omwibbanga okwaba angulu emita ooti moiza okuzwa okwitakali, ni gigwa okumpi nʼenkambi ni gijeeruguulirirya enkambi, ni giwoisya ekifo ekyo, ni gibba ku buli lubba okwaba ooti kiromita. ");
INSERT INTO gwr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Awo kaisi abantu ni bawuluka ni baaba ni bakumbaania enindu olunaku olwo lwonalwona nʼobwire bwonabwona, nʼolunaku olwairireku lwonalwona ni bakumbaania enindu. Eyakumbaanirye entono yayererye ooti kiro 1,000. Ni bagyanika gyonagyona okweruguulirirya enkambi. ");
INSERT INTO gwr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Neye babbaire bakaali balyaku enyama eyo eyʼenindu, era nga bakaali okugimalawo, oMusengwa nʼabasunguwalira ino, nʼabasindikira okawumpuli owʼamaani. ");
INSERT INTO gwr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Nʼolwʼekyo ekifo ekyo ni bakiwa eriina bati Kibbuloosi Kataava, ekitegeeza aMagombe gʼaBayoya, olwʼokubba niimwo omubaliikire abantu abayoyere enyama. ");
INSERT INTO gwr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ABaisirairi owebazwire omu Kibbuloosi Kataava, ni baaba e Kazeroosi, ni bakolayo enkambi ni babba eeyo. ");
INSERT INTO gwr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Atyanu oMusa yafumbiirwe omukali owʼeigwanga lyʼaBakuusi, oMiryamu nʼAlooni ni beezuluguma olwʼoMusa okufumbirwa omukali oyo. ");
INSERT INTO gwr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ni beebulya bati, “OMusengwa atumula ngʼabitira mu Musa yenkani? Tatumula ngʼabitiraku mwiswe swena?” Neye oMusengwa nʼawulira ekibatumwire. ");
INSERT INTO gwr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Atyanu oMusa yabbaire musaiza muwombeeki ino okukiraku omuntu yenayena oku kyalo. ");
INSERT INTO gwr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Amangu ago oMusengwa nʼakoba oMusa nʼAlooni nʼoMiryamu ati, “Inywe abasatu mwabe oku Weema eyʼoKunsisinkanirangamu nze oMusengwa.” Kale ibo abasatu ni baaba. ");
INSERT INTO gwr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","OMusengwa nʼaika ngʼali omu kireri ekiterembereri ooti kikondo, nʼayemerera oku mulyango gwʼeWeema eyʼoKumusinkanirangamu, nʼayeta Alooni nʼoMiryamu, bombi ni baigerera omumaisoge. ");
INSERT INTO gwr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kaisi oMusengwa nʼabakoba ati, “Muwulisisye ekinkoba.” “Mwinywe singa wabbaawo onaabbi wange nze Musengwa, mmwebiikulira omu kwolesebwa, ntumula naye omu birooto. ");
INSERT INTO gwr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Neye tikiri kityo oku muweererya wange oMusa; omu nyumba yange yonayona, iye muntu omwesigwa. ");
INSERT INTO gwr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Iye ntumula naye maiso ku maiso, era butereeri, nga ti mu ngero; iye ambona nze oMusengwa ngʼowenfaanana. Kale muyinza mutya okutatya okutumula bundi oku muweererya wange oMusa?” ");
INSERT INTO gwr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Awo oMusengwa nʼabasunguwalira ino, era nʼazwawo. ");
INSERT INTO gwr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ekireri ni kizwa oku Weema eyo. Amangu ago oMiryamu nʼalwalirawo endwaire yʼolususu etiisya, nʼabba mweru ca ooti mabbaale ga ikendi. Alooni oweyagalukire nʼalola oku Miryamu, nʼabona ngʼoMiryamu asunire endwaire yʼolususu etiisya. ");
INSERT INTO gwr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Nʼakoba oMusa ati, “Mukulu nkwegairiire otusoniye ekibbikibbi ekyo. Ekitukolere kyobusirusiru, era gutusingire. ");
INSERT INTO gwr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Nkwegairiire, oonu tiwamuleka okubba ooti mwana ogubabyaire nga mufu, nʼomubirigwe nga guvundireku ekitundu.” ");
INSERT INTO gwr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","OMusa ni yeekungirira oMusengwa ati, “Oo Kibbumba, nkwegairiire, omulamye!” ");
INSERT INTO gwr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","OMusengwa nʼakoba oMusa ati, “Singa oiteeye niiye abbaire amwandire ebitanta omu maiso, tiyandibbaireku ekiswalo okumala enaku musanvu? Kale bamwigalire e nza wʼenkambi okumala enaku musanvu, kaisi oluzwanyuma bamwikirirye okukanga omu nkambi.” ");
INSERT INTO gwr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Atyo oMiryamu ni bamwigalira e nza wʼenkambi okumala enaku musanvu. Abantu nandi ni basengula enkambi paka owebamwikiriirye okukanga omu nkambi. ");
INSERT INTO gwr_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Oluzwanyuma lwʼebyo ni basenguka okuzwa e Kazeroosi, ni baaba ni bakola enkambi omwidungu lyʼe Palani. ");
INSERT INTO gwr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Otume abantu baabe bakeete ekyalo kyʼe Kanani ekindi kuwa aBaisirairi. Watuma omuntu moiza okuzwa mu buli kika, era omuntu oyo ali nʼokubba mwekubbemberi wʼekikaakye.” ");
INSERT INTO gwr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kale owebabbaire omwidungu lyʼe Palani, oMusa nʼakola ngʼoMusengwa oweyamulagiire. Nʼatuma abasaiza nga bonabona beekubbemberi bʼebika byʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Era ganu niigo amaliina gaabwe: Omu kika kya Lubbeeni nʼatuma oSyamuwa omutaane wa Zakuli; ");
INSERT INTO gwr_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","nʼomu kika kya Simyoni nʼatuma oSafati omutaane wa Kooli; ");
INSERT INTO gwr_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","nʼomu kika kya Yuda nʼatuma oKalebbu omutaane wa Yefune; ");
INSERT INTO gwr_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","nʼomu kika kya Isakaali nʼatuma oIgali omutaane wa Yusufu; ");
INSERT INTO gwr_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","nʼomu kika kyʼEfulaimu nʼatuma oKoseya omutaane wa Nuuni; ");
INSERT INTO gwr_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","nʼomu kika kya Bbenyamini nʼatuma oPaluti omutaane wa Lafu; ");
INSERT INTO gwr_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","nʼomu kika kya Zebbulooni nʼatuma oGadyeri omutaane wa Sodi; ");
INSERT INTO gwr_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","nʼomu kika kya Yusufu, ikyo ekika kya Manase nʼatuma oGaadi omutaane wa Susi; ");
INSERT INTO gwr_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","nʼomu kika kya Daani nʼatuma Amiyeeri omutaane wa Gemali; ");
INSERT INTO gwr_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","nʼomu kika kyʼAseri nʼatuma oSesuli omutaane wa Mikairi; ");
INSERT INTO gwr_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","nʼomu kika kya Nafutaali nʼatuma oNakubbi omutaane wa Vofusi; ");
INSERT INTO gwr_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","nʼomu kika kya Gaadi nʼatuma oGeweri omutaane wa Maki. ");
INSERT INTO gwr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ago niigo amaliina gʼabantu oMusa abeyatumire okukeeta ekyalo ekyo ekyʼe Kanani. OMusa nʼawa oKoseya omutaane wa Nuuni eriina ati Yoswa. ");
INSERT INTO gwr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","OMusa oweyabbaire ngʼabatuma okwaba okukeeta ekyalo kyʼe Kanani, yabakobere ati, “Muniinaniine, mwabe mubite omwidungu oNegevu, mweyongereyo mwabe omu kyalo kyʼensozisozi. ");
INSERT INTO gwr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mwabe mubone ekyalo ekyo ngʼowekiri, nʼabantu abakirimu ooba nga bʼamaani, ooba banafu, nga bangi ooba batono. ");
INSERT INTO gwr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Era mubone ekyalo ekyo e gibatyama ooba nga kisa ooba kibbikibbi. Mubone ebibuga e gibatyama ooba nga bibulaku engaga ooba biriku engaga. ");
INSERT INTO gwr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Mwabe mukebere ekyalo ekyo mubone ooba nga kijimu ooba kikalukalu, ooba nga mulimu emisaale, ooba gibulamu. Era mwefudeku okuleetaku ebineneka byamu.” Ekiseera ekyo kyabbaire kyʼemizabbibbu emyekeereri. ");
INSERT INTO gwr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Awo abakeeti ni baniinaniina ni baaba okukeeta ekyalo ekyo, okuzwera okwidungu lyʼe Ziini paka e Lekobbu okulungama e Kamasi. ");
INSERT INTO gwr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ni baniinaniina baaba ni babita omu Negevu, ni batuuka omu kibuga e Kebbulooni, aBaakimani, nʼaBasesayi, nʼaBatalumayi abaizukulu bʼAnaki e gibabbaire batyama. Ekibuga oKebbulooni, bakyombekere ni wabitawo emyanka musanvu kaisi ni bombeka ekibuga oZowani ekyʼomu Misiri. ");
INSERT INTO gwr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Owebatuukire omu Kiinamo kyʼe Esukoli, batemereyo eisaga eryabbaireku ekibbubbu kimo ekyʼemizabbibbu. Abantu babiri ni bakigingira oku mulabba ni bakireeta. Ni baleeteraku nʼebineneka ebya nkomamawanga nʼebyʼemitiini. ");
INSERT INTO gwr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Ekifo ekyo ni bakiwa eriina bati Kiinamo kyʼEsukoli, olwʼekibbubbu kyʼemizabbibbu aBaisirairi ekibatemereyo. ");
INSERT INTO gwr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Oluzwanyuma lwʼabakeeti abo okumala enaku 40 nga bakeeta ekyalo ekyo, bazwireyo ni bakanga omu nkambi gyabwe. ");
INSERT INTO gwr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Abakeeti bakangire eeri oMusa nʼAlooni nʼeeri ekibbula kyonakyona ekyʼaBaisirairi e Kadesi omwidungu lyʼe Palani, ni babakobera ebibaboineyo, ni babalagisya ebineneka ebibazwireyo nabyo. ");
INSERT INTO gwr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ni basonzolera oMusa bati, “Twatuukire omu kyalo ekiwatutumiremu. Ekyalo kidi kiizwire amata nʼomujenene, era binu niibyo ebineneka ebikirimu. ");
INSERT INTO gwr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Neye abantu abatyama omu kyalo kidi bʼamaani, nʼebibuga byabwe binene ino era biriku engaga. Nʼekindi, twaboineyo abaizukulu bʼAnaki. ");
INSERT INTO gwr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","ABamereki batyama mu Negevu, aBakiiti nʼaBayebbusi nʼaBamooli, ibo batyama mu kyalo ekyʼensozisozi, kaisi aBakanani ni batyama kumpi nʼogunyanza oMeditereniani, nʼoku mbale mbale kwʼomwiga oYoludaani.” ");
INSERT INTO gwr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Neye oKalebbu nʼasirica abantu ababbaire bakumbaanire omumaiso ga Musa, kaisi nʼakoba ati, “Tusetukiremu tuniinaniine twabe twetwalire ekyalo ekyo, olwʼokubba twezyerya nakimo okukiwangula.” ");
INSERT INTO gwr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Cooka abantu ababbaire baabire eedi okukeeta naye, ni bakoba bati, “Titwezya okulwanisya abantu badi, olwʼokubba batukiraku amaani.” ");
INSERT INTO gwr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Era ni basalaania omu Baisirairi ebibono ebibamalamu amaani, ebifa oku kyalo ekibabbaire baabire okukeeta, nga bakoba bati, “Ekyalo ekitwabiremu okukeeta, tikibala ebyokulya ebimala okubbeesyawo abantu abakityamamu, nʼabantu bonabona abetwaboineyo mbalamba. ");
INSERT INTO gwr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Era twaboineyo embalamba gyʼabantu aBefuleeni, abʼeibyaire lyʼAnaki. Era tweboine ooti tuli batontono ooti masusi, era bona bateekwa okubba batuboine batyo.” ");
INSERT INTO gwr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Atyanu ekibbula kyonakyona ekyʼaBaisirairi owekyamalire okuwulira obukwenda bwʼabakeeti eikumi na babiri abaabire okukeeta ekyalo kyʼe Kanani, ni bakuukulya, era ni bamagalica amaliga obwire bwonabwona. ");
INSERT INTO gwr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ekibbula kyonakyona ekyʼaBaisirairi ni kyezulugumira oMusa nʼAlooni, era ekibbula kyonakyona ni kibakoba kiti, “Singa wakiri twafeereire omu kyalo kyʼe Misiri, ooba omwidungu munu! ");
INSERT INTO gwr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Lwaki oMusengwa atutwala omu kyalo ekyo okutwitisirya eeyo omu lutalo, bawambe abakali baiswe nʼabaana baiswe? Tikyandikirireku obusa ni tukanga e Misiri?” ");
INSERT INTO gwr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Era ni bakobangana bati, “Twelondemu omwekubbemberi, atukanje e Misiri.” ");
INSERT INTO gwr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Awo omukwesisiwala, oMusa nʼAlooni ni bafuunama ni baica empumi gyabwe ansi okwitakali omumaiso gʼekibbula kyonakyona ekyʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Iye oYoswa omutaane wa Nuuni, nʼoKalebbu omutaane wa Yefune, ababbaire abamo kwabo abaabire okukeeta ekyalo nago, ni banyiira ebizwalo byabwe olwʼokunakuwala, ");
INSERT INTO gwr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","era ni bakobera aBaisirairi abo bonabona bati, “Ekyalo ekitwabitiremu ni tukikeeta, kisa ino nakimo. ");
INSERT INTO gwr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Singa twagondera oMusengwa yatusiima, nʼatwekubbembera nʼatwingirya omu kyalo ekyo ekiizwire amata nʼomujenene era nʼakituwa. ");
INSERT INTO gwr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ekikulu, timwajeemera oMusengwa. Era timwatya abantu abali omu kyalo ekyo, mazima twabajigiricirya nakimo era twababitirawo-bubitiri. Ibo obukuumi bwabwe buwoirewo, neye iswe oMusengwa ali na iswe atukuuma. Nʼolwekyo timwabatya.” ");
INSERT INTO gwr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Neye ekibbula kyonakyona ekyʼaBaisirairi ekyabbaire kikumbaanire aawo ni beeteesamu okubakubba mabbaale. Wazira amangu ago, ekitiisya kya Musengwa ni kibonekera aBaisirairi abo bonabona aawo oku Weema eyʼoKusisinkanirangamu oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Era oMusengwa nʼabuulya oMusa ati, “Abantu abo balituuca di okunnyooma? Balituuca di okutaneesiga, waire wona nga njabire nga nkola obumanyiciryo wʼebyewunyo ebyo byonabyona mwibo? ");
INSERT INTO gwr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Njaba okubasindikamu okawumpuli mbajigirice, kaisi okubita omwibyaireryo nkolemu eigwanga erinene era eryʼamaani okukiraku ibo.” ");
INSERT INTO gwr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Neye oMusa nʼakoba oMusengwa ati, “Niiwe owatoire abantu abo e Misiri ngʼokolesya obwezyebwo. Era aBamisiri owebakiwulira ngʼobajigiricirye, ");
INSERT INTO gwr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","bakikobera abantu abatyama omu kyalo kinu. Ate nga bakiwuliire bati iwe Musengwa oli aamo nʼabantubo, era bati obabonekera maiso ku maiso ekirerikyo owekyemerera angulu waabwe. Era bakiwuliire bati wabeekubbembererangamu omusana ngʼoli omu kireri ekiterembereri ooti kikondo, kaisi obwire nʼobeekubbembererangamu ngʼoli omu musyo omuterembereri ooti kikondo. ");
INSERT INTO gwr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Atyanu singa waita abantu banu bonabona nʼobamalawo omulundi ogumo, abʼamawanga agandi abawuliire okwitutumolyo, balikoba bati, ");
INSERT INTO gwr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘OMusengwa yakaire okutuuca abantu abo omu kyalo ekiyalayiire okubawa, kagira abaitiire omwidungu.’ ");
INSERT INTO gwr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Nʼolwekyo nkwegairira Musengwa, olage obwezyebwo obungi, era okole ekiwasuubizire owewakobere oti, ");
INSERT INTO gwr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Ninze oMusengwa, alwawo okusunguwala, owʼokutaka okutakoma era nsoniya ebikole ebibbibibbi nʼobujeemu. Neye tindeka okubonereza oyo abbengere, era mbonereza abaana nʼabaizukulu, paka oku kiizukulu kyokusatu nʼoku kyokuna, olwʼebikole ebibbibibbi byʼababyaire baabwe.’ ");
INSERT INTO gwr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Olwʼokutakakwo okutakoma osoniye ekikole ekibbikibbi kyʼabantubo abo ngʼowobbaire obasoniya okuzwa ngʼowebazwire omu kyalo kyʼe Misiri paka atyanu.” ");
INSERT INTO gwr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Awo oMusengwa nʼairamu ati, “Mbasoniyiire, ngʼowonsabire. ");
INSERT INTO gwr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Neye mazima nze oMusengwa ngʼowendi omwomi, era ngʼekyalo kyonakyona owekiizula ekitiisya kyange, ");
INSERT INTO gwr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","mpaawo oku bantu abo ababoine ekitiisya kyange nʼobumanyiciryo bwʼebyewunyo ebinakolere omu kyalo kyʼe Misiri nʼomwidungu, neye ni banjemera era ni bangezesya emirundi giinu atyanu ikumi, era nandi ni bagondera eigono lyange, ");
INSERT INTO gwr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","mazima kadi moiza eyannyoomere, eyalingira omu kyalo ekinalayiire okuwa abazeiza baabwe. ");
INSERT INTO gwr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Neye omuweererya wange oKalebbu, olwʼokubba iye omwoyo ogugwe gwʼenjawulo, era atambulira omu manzira gange nʼomwoyogwe gwonagwona, iye nalimutuuca omu kyalo ekyo ekiyakeetere, era eibyairerye lyalikisikira. ");
INSERT INTO gwr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ABamereki nʼaBakanani ngʼowebali omu kiinamo kyʼomwiga oYoludaani, eizo mucuuke mutambule nga mulungama omwidungu, omu nzira eyaba oku Nyanza eNtukuliki.” ");
INSERT INTO gwr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Awo oMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Abantu abo ababbibabbi, balituuca di okuneezulugumiranga? Mpuliire okwezuluguma kwabwe. ");
INSERT INTO gwr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Kale mubakobe muti, ‘Mazima Nze oMusengwa ngʼowendi omwomi, njaba kubakolaku ngʼowempuliire ebyo inywe abananyere ebimutumwire. ");
INSERT INTO gwr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Era abantu nywenanywena omwaneezulugumiire era owʼemyanka aabiri nʼokukirawo abebabalire omu kubala abantu okwabbairewo, mwaba kufeera mwidungu munu. ");
INSERT INTO gwr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Mpaawo kadi moiza kwinywe eyalituuka omu kyalo ekinalayiire okubawa okutyamamu, okutoolaku oKalebbu omutaane wa Yefune, nʼoYoswa omutaane wa Nuuni. ");
INSERT INTO gwr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Neye abaana baanywe abemwakobere muti abantu balibawamba, niibo abenalingirya ni beeyagalira omu kyalo ekyo inywe ekimugaine. ");
INSERT INTO gwr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Neye inywe, mwalifeera mwidungu munu. ");
INSERT INTO gwr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Abaana baanywe balibba baliisya omwidungu munu okumala emyanka 40, nga bagada olwʼobutali bwesigwa bwanywe egyendi, paka owemwalifeera omwidungu munu ni muwaawo. ");
INSERT INTO gwr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mwaligada okumala emyanka 40 olwʼekibbikibbi kyanywe. Nabuli lunaku oku naku 40 egimwamalire nga mukeeta ekyalo nago, mwalirusasulangamu okugada kwa mwanka mulamba, kaisi ni mutegeera nga nabazwireku. ");
INSERT INTO gwr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nze oMusengwa ninze ntumwire era mazima njaba okukola ebintu ebyo oku bantu abo ababbibabbi, abekoobaana okunjakanisya. Omwidungu munu mubalikoma; bonabona mubalifeera.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Batyo abantu oMusa abeyatumire okukeeta ekyalo nago era ni baira ni bazweraku ekibbula kyonakyona ekyʼaBaisirairi okwezulugumira oMusengwa, ekikoba kiti, ");
INSERT INTO gwr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","abantu abo abatumwire ebibono ebitali bisa ebikwata oku kyalo nago, okawumpuli yabaitiire omumaiso ga Musengwa. ");
INSERT INTO gwr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Neye oYoswa omutaane wa Nuuni, nʼoKalebbu omutaane wa Yefune, niibo bonkani abasigairewo nga boomi oku bantu abo abaabire okukeeta ekyalo ekyo. ");
INSERT INTO gwr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Atyanu oMusa nʼakobera aBaisirairi ebintu ebyo byonabyona oMusengwa ebiyakobere era abantu ni bakunga ino. ");
INSERT INTO gwr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Eizo waaku, amakeezikeezi ni baniinaniina baaba omu kyalo ekyʼensozisozi, era ni bakoba bati, “Tutegeire nga twakolere ekikole ekibbikibbi. Era twetegekere okuniinaniina okwaba omu kifo oMusengwa ekiyatusuubizire.” ");
INSERT INTO gwr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Neye oMusa nʼabakoba ati, “Lwaki timugondera ekiragiro kya Musengwa? Ekyo ekimutegeka tikyabitemu. ");
INSERT INTO gwr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Timwaba, olwʼokubba oMusengwa tali aamo na inywe, era abalabe baanywe babawangula. ");
INSERT INTO gwr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ekyo kityo olwʼokubba mwasisinkanayo aBamereki nʼaBakanani, era olwʼokubba mukubbiire oMusengwa omugongo ni mumuzwaku, yena yabaleka ni babaita nʼempiima.” ");
INSERT INTO gwr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Neye ibo era ni basalawo kwaba-bwabi, ni baniinaniina okulungama omu kyalo ekyʼensozisozi, newakubbaire ngʼoMusa tiyazwire omu nkambi waire esanduuku yʼendagaano ya Musengwa. ");
INSERT INTO gwr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Awo aBamereki nʼaBakanani ababbaire abatyami abʼomu kyalo ekyo ekyʼensozisozi, ni baserengeta baaba ni babalumba era ni babakubba ni babaserengetya paka mu kibuga e Koluma. ");
INSERT INTO gwr_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Awo oMusengwa ni yeyongera okukoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Okobe aBaisirairi oti, ‘Owemwalituuka omu kyalo ekinjaba okubawa okutyamamu, ");
INSERT INTO gwr_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mwawangayo eeri Nze oMusengwa ebyokuwaayo ebibooca ni bizwamu oluvululu olunsangaalya, nga mubitoola omu biraalo byʼente gyanywe ooba omu byʼentaama nʼembuli gyanywe, ooba sadaaka egibooca yonayona ooba sadaaka egindi gyonagyona okutuukirirya obweyamo, ooba ebyokuwaayo omu kwetakira, ooba ebyʼomukolo ogwʼokuwaayo egyendi. ");
INSERT INTO gwr_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Oyo eyaabbanga aleetere ekyokuwaayo, yaawangayo eeri nze oMusengwa ekyokuwaayo ekyʼempeke ekiro ooti moiza nʼekitundu eyʼobusye obwʼengaano obusa, obubatabwiremu erita yʼobwito obwʼemizaituuni. ");
INSERT INTO gwr_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Eyaawangayo ontaama omutomuto okubba esadaaka egibooca yonayona ooba esadaaka egindi gyonagyona, yaawangayo nʼerita ooti moiza eyʼenviinyo, nga niikyo ekyokuwaayo ekyʼekyokunywa.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“Oweyaawangayo ntaama omusaiza, yaweerangaku ekyokuwaayo ekyʼempeke ekiro oti ibiri egyʼobusye obwʼengaano obusa, nga babutabwiremu erita ooti moiza nʼekitundu eyʼobwito obwʼemizaituuni. ");
INSERT INTO gwr_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Era yabiwangayo aamo nʼerita ooti moiza nʼekitundu eyʼenviinyo, nga niikyo ekyokuwaayo ekyʼekyokunywa, era ebyokuwaayo ebyo ni babyoca bizwamu oluvululu olusa, olunsangalya nze oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“Oweyaawangayo eeri nze oMusengwa nte okitobba okubba esadaaka egibooca yonayona ooba esadaaka egindi gyonagyona, okutuukirirya obweyamo, ooba okubba esadaaka eyʼokusyania, ");
INSERT INTO gwr_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","oku nte oyo, yaweerangaku nʼekyokuwayo ekyʼempeke ekiro ooti isatu egyʼobusye obwʼengaano obusa obubatabwiremu erita ooti ibiri egyʼobwito obwʼemuzaituuni. ");
INSERT INTO gwr_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Era yaawangayo nʼekyokuwaayo ekyʼebyokunywa erita ooti ibiri egyʼenviinyo. Ekyo kyabbanga kyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Eyo niiyo engeri egimwawangayo onte okitoba, ooba ontaama omusaiza, ooba ontaama omutomuto, ooba ombuli omutomuto. ");
INSERT INTO gwr_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Mwasengereryanga endagirira eyo ku buli kyokuwaayo ekimwawangayo.” ");
INSERT INTO gwr_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“Nabuli mubyalwa yenayena yaabbanga nʼokukola ebyo atyo, oweyaabbanga aleetere ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nʼomunamawanga atyama mwinywe ooba omuntu ogondi yenayena aali mwinywe omu mirembe gyanywe gyonagyona egyaliirawo, oweyaabbanga awaayo ekyokuwaayo ekibooca ni kizwamu oluvululu olunsangaalya, yaabbanga nʼokukoleranga nakimo nga inywe owemukola. ");
INSERT INTO gwr_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Ekibbula kyonakyona ekyʼaBaisirairi kyabbaga nʼamateeka gamo agakifuga, nʼabanamawanga abatyama mwinywe, era amateeka ago tigacuukenge emirembe gyonagyona. Inywe, nʼabanamawanga abo, nze oMusengwa nababityanga mu ngeri moiza. ");
INSERT INTO gwr_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Amateeka nʼebiragiro byabbanga binanyere ebyo eeri inywe, nʼabanamawanga abatyama mwinywe.” ");
INSERT INTO gwr_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Okobe aBaisirairi oti, ‘Owemwalituuka omu kyalo ekimbatwalamu, ");
INSERT INTO gwr_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","kaisi ni mulyaku ebyokulya ebimulimire omu kyalo ekyo, mwalyawulangaku ekitundu kyaku, ni kibba kyokuwaayo eeri nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Mwaliwangayo omugaati ogusooka ogubasumbire okuzwa omu busye obwʼamakungula gaanywe, ngʼekyokuwaayo ekyʼempeke okuzwa omu kifo e gibakonera engaano. ");
INSERT INTO gwr_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Omu mirembe gyonagyona egyaliirawo, mwawangayo eeri nze oMusengwa, omugaati ogusooka ogubasumbire okuzwa omu busye obwʼamakungula gaanywe ngʼekyokuwaayo ekyʼempeke okuzwa omu kifo e gibakonera engaano.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Neye singa omuntu omu butali bugenderere, yakayanga okukwata amateeka nze oMusengwa agenawaire oMusa, ");
INSERT INTO gwr_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ekikoba kiti, amateeka gonagona agenabawaire inywe okubitira omu Musa, okuzwera Nze oMusengwa owenabaweereire ekiragiro ekyo era nga kyeyongera paka omu mirembe egyaliirawo, ");
INSERT INTO gwr_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","era singa ekyo kyabbanga kityo nga timubugenderere, nga mpaawo oMwisirairi akimanyiciryeku, aBaisirairi nywenanywena mwawangayo onte okitobba, nʼabba sadaaka egibooca yonayona nʼezwamu oluvululu olunsangaalya Nze oMusengwa, aamo nʼekyokuwayo ekyʼempeke, nʼekyokuwayo ekyʼebyokunywa ekyabiraku ngʼeiteeka oweriragira, era nʼombuli moiza ompanya okubba sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Okabona yaabbanga nʼokukola omukolo gwʼokubasuuca inywe ekibbula kyonakyona ekyʼaBaisirairi okubba kirongoole era ni mbasoniya, olwʼokubba ekisobyo ekyo timwabbenge mukikolere mubugenderere era olwʼokubba mwabbanga muleetere ekyokuwaayo kyanywe ekyʼekyokulya ekibooca ni bakiwaayo eeri Nze oMusengwa nʼesadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Ekibbula kyonakyona ekyʼaBaisirairi nʼabanamawanga abatyama mwinywe mwasunanga ekisoniyo, olwʼokubba nywenanywena mwabbanga mwemigiire omu kisobyo ekyo mubutali bugenderere.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Neye singa yaabbanga muntu moiza niiye akolere ekikole ekibbikibbi omu butali bugenderere, yaabbanga nʼokuleeta ombuli onduusi owʼomwanka ogumo nʼabba sadaaka eyʼokusoniya ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Okabona yakolanga omukolo ogwʼokusuuca omuntu oyo asoberye nʼakola ekikole ekibbikibbi nga tagendereire, okubba omulongoole eeri nze oMusengwa. Era oweyakolanga omukolo ogwʼokusuuca omuntu oyo okubba mulongoole, namusoniyanga. ");
INSERT INTO gwr_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Amateeka gaabbanga gananyere ago agakolanga ku buli eyakolanga ekibbikibbi omu butali bugenderere, ooba Mwisirairi omubyalwa, ooba munamawanga atyama mwinywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Neye buli eyakolanga ekibbikibbi omubugenderere, nʼoweyaabbanga mubyalwa ooba munamawanga, oyo yaabbanga annyoomoire Nze oMusengwa, era tibamubalenge okubba moiza oku bantu bange. ");
INSERT INTO gwr_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Atyanu olwʼokubba yaabbanga anyoomoire ekibono kyange Nze oMusengwa, era ngʼamenyere eiteka lyange, yaabbanga mazima tibakaali bamubala okubba moiza oku bantu bange; iye onanyere yaabbanga yeesingisirye omusango.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Lumo aBaisirairi nga bakaali bali omwidungu, baajiirye omuntu ngʼatyaba enkwi oku lunaku lwʼeSaabbaato. ");
INSERT INTO gwr_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Abo abamwajiirye ni bamutwala eeri oMusa nʼAlooni nʼekibbula kyonakyona ekyʼaBaisirairi, ");
INSERT INTO gwr_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ni kimukuuma nga musibe, olwʼokubba babbaire bakaali okumanya ekyokumukolera. ");
INSERT INTO gwr_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Awo oMusengwa nʼakoba oMusa ati, “Omuntu oyo bali nʼokumwita. Bamuwuluce omu nkambi, abantu bonabona abali aawo babbe nʼokumwita nʼamabbaale.” ");
INSERT INTO gwr_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Kale abantu bonabona ababbaire aawo ni bamuwuluca omu nkambi, ni bamutwala ni bamwita nʼamabbaale ngʼoMusengwa oweyabbaire alagiire oMusa. ");
INSERT INTO gwr_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Okobe aBaisirairi oti, ‘Omu mirembe gyonagyona egyaliirawo, mwatungiranga amajwenjwe oku mansonda gʼebizwalo byanywe era ku buli ijwenjwe, mwateekangaku akaguwa aka bbululu. ");
INSERT INTO gwr_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Amajwenjwe ago mwagalolangaku ni mwebukirya amateeka gange gonagona Nze oMusengwa, kaisi mugakwatenge era ni mubba beesigwa egyendi nandi ni musengereryanga okwegomba kwʼemyoyo gyanywe nʼokwʼamaiso gaanywe. ");
INSERT INTO gwr_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Olwo mwebukiryanga era ni mukwatanga amateeka gange gonagona, era ni mubbanga batukulye eeri nze oKibbumba wanywe. ");
INSERT INTO gwr_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ninze oMusengwa iye oKibbumba waanywe, eyabatoire omu kyalo kyʼe Misiri, kaisi mbenge Kibbumba waanywe. Ninze oMusengwa iye oKibbumba waanywe.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Lumo omusaiza ogubeetanga oKoola era nga mutaane wa Izukali, oIzukali omutaane wa Kokasi, oKokasi omutaane wa Leevi. Ekiseera kyatuukire, oKoola nʼoDasani nʼAbbiraamu abataane bʼEryabbu, nʼOni omutaane wa Peresi, abʼekika kya Lubbeeni ni beekoobaana okwakanisya obukubbemberi bwa Musa. ");
INSERT INTO gwr_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Abasaiza abo ni bazwayo ni bakola ekintu ekyo, era aBaisirairi abandi 250, ababbaire abalonde oku lukiiko olufugi, era ngʼabeekubbemberi abatutumuki ni babeeyimbyaku. ");
INSERT INTO gwr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Beekwaite kibbubbu ni baaba ni baakanisya oMusa nʼAlooni bati, “Mubitiriirye okwewa obwezye. Iswe aBaisirairi swenaswena tuli batukulye, era oMusengwa ali aamo na iswe. Atyanu lwaki inywe mutwegulumaliryaku iswe swenaswena abantu ba Musengwa?” ");
INSERT INTO gwr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","OMusa oweyawuliire ebibono ebyo, ni yeesisiwala, nʼafuunama nʼaica empumi ansi okwitakali. ");
INSERT INTO gwr_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Oluzwanyuma nʼakoba oKoola nʼabainaye ati, “Eizo amakeezi oMusengwa yatulaga owuwe oguyalondere era omutukulye, era yamuganya nʼaigerera e gyali iye oMusengwa. Omuntu oyo iye oMusengwa oguyeerondeire yamwikirirya okwigerera e gyali. ");
INSERT INTO gwr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Iwe Koola, nʼabainawo bonabona, mwakola kiinu: Eizo wakwata ebyokuduunyisiryaku, ");
INSERT INTO gwr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ni mubiteekamu omusyo, ni muteekaku obubbaani era mubuduunyisirya omumaiso ga Musengwa. Olwo oyo oMusengwa oguyalondere, niiye eyaabba omutukulye. Inywe aBaleevi niinywe omubitiriirye okwewa obwezye.” ");
INSERT INTO gwr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","OMusa era nʼakoba oKoola ati, “Atyanu muwulisisye inywe aBaleevi! ");
INSERT INTO gwr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Olwo inywe mukyeta kitono, oKibbumba wʼaBaisirairi okubaawula inywe omu kibbula kyonakyona ekyʼaBaisirairi, nʼabaigererya egyali, okukolanga emirimo omu Weemaye iye oMusengwa, nʼokwemereranga omumaiso gʼaBaisirairi okubaweereryanga? ");
INSERT INTO gwr_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","OMusengwa yakuwaire iwe nʼaBaleevi banu bonabona ekitiisya ekyo, neye era munoonia nʼobwakabona! ");
INSERT INTO gwr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Nʼolwekyo iwe nʼabainabo bonabona, muli kwediimanga ku Musengwa. Aale Alooni niiye naani, inywe kaisi mumwezulugumire?” ");
INSERT INTO gwr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Awo oMusa nʼatumisya oDasani nʼAbbiraamu abataane bʼEryabbu. Neye ibo ni bakoba bati, “Titwaize! ");
INSERT INTO gwr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Tikikumala okubba kiti watutoire omu kyalo ekiizwire amata nʼomujenene, nʼotuleeta okutwitisirya omwidungu linu? Era otaka nʼokutwesuucaaku okubba niiwe atufuga? ");
INSERT INTO gwr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Nʼekindi, okaali okututuuca omu kyalo ekiizwire amata nʼomujenene waire okutuwa emiwuluko egyokulimiramu nʼemisiri egyʼemizabbibbu! Atyanu abantu banu otaka kubazeenyera ku bwongo? Bbe, titwaize!” ");
INSERT INTO gwr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Awo oMusa nʼasunguwala ino, nʼakoba oMusengwa ati, “Tiwaikirirya ekyokuwaayo kyabwe. Timbatoolangaku waire mpunda omoiza, era mpaawo kadi moiza kwibo ogunabbaire nkolereku akabbikabbi.” ");
INSERT INTO gwr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","OMusa nʼakoba oKoola ati, “Iwe nʼabainabo bonabona, eizo mwaiza omumaiso ga Musengwa, nʼAlooni yena yaabbaayo. ");
INSERT INTO gwr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Nabuli moiza kwinywe yakwata ekyokuduunyisiryakukye, nʼakiteekaku obubbaani, era nabuli moiza yakireeta omumaiso ga Musengwa, ebyokuduunyisiryaku ni byera 250. Era iwe Koola nʼAlooni nywena nabuli moiza yaleeta ekyokuduunyisiryakukye.” ");
INSERT INTO gwr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Awo nabuli moiza nʼakwata ekyokuduunyisiryakukye, nʼakiteekaku omusyo, nʼakiteekaku obubbaani, kaisi ni beemerera aamo nʼoMusa nʼAlooni oku mulyango gwʼeWeema eyʼoKusisinkanirangamu oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Awo oKoola nʼakumbaania abawagiribe bonabona abaakanisya oMusa nʼAlooni ni baaba oku mulyango gwʼeWeema eyʼoKusisinkanirangamu. Amangu ago ekitiisya kya Musengwa ni kibonekera abantu bonabona ababbaire aawo. ");
INSERT INTO gwr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Awo oMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Mweyabule muzwe omu bantu abo bonabona, kaisi ibo mbajigirice omulundi gumo!” ");
INSERT INTO gwr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Neye oMusa nʼAlooni ni bafuunama ni baica empumi gyabwe ansi okwitakali ni basaba bati, “Oo Kibbumba, Iwe onanzwa wa bwomi bwonabwona, wasunguwalira abantu bonabona olwʼomuntu omoiza akolere ekibbikibbi?” ");
INSERT INTO gwr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Okobe abantu abo bonabona oti, ‘Timwabba okumpi nʼeweema eya Koola, nʼeya Dasani, nʼeyʼAbbiraamu.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Awo oMusa nʼasetuka nʼabeekubbemberi bʼaBaisirairi nʼayaba oku weema ya Dasani nʼAbbiraamu. ");
INSERT INTO gwr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","OMusa nʼalabula abantu bonabona ati, “Muzwe okumpi nʼeweema gyʼabantu abo ababbibabbi, timwakubbyaku ekintu kyonakyona ekyʼabantu abo, demba oMusengwa nʼabajigirica nywena olwʼebikole byabwe ebibbibibbi.” ");
INSERT INTO gwr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Batyo abantu ni beesenda yalaku nʼeweema ya Koola, nʼeya Dasani, nʼeyʼAbbiraamu oku mba gyonagyona. ODasani nʼAbbiraamu babbaire bawulukire e nza wʼeweema gyabwe, nga beemereire nʼabakali baabwe, nʼabaana baabwe abakulu nʼabatobato oku miryango gyʼeweema gyabwe. ");
INSERT INTO gwr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Awo oMusa nʼakoba aBaisirairi ati, “Ku kinu, niikwo okumwategeerera ngʼoMusengwa niiye eyantumire okukola emirimo ginu gyonagyona egyʼokubeekubbembera, era nga tingikola kulwange. ");
INSERT INTO gwr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Abasaiza abo singa baafa enfa eyabulijo, era singa ekitira okutuuka oku bantu bonabona niikyo ekyabatuukaku, awo oMusengwa yaabba nga tiniiye eyantumire. ");
INSERT INTO gwr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Neye singa oMusengwa yakola ekintu ekitabbeerangakuuwo nakimo, era eitakali ni lyeyatamu ni libamira nʼebyabwe byonabyona, ni baika omu kiina ekitakoma nga boomi, olwo mwategeera ngʼabasaiza abo banyoomoire oMusengwa.” ");
INSERT INTO gwr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Oweyabbaire yankumala okutumula ebibono ebyo byonabyona, eitakali e gibabbaire beemereire ni lyeyatamu, ");
INSERT INTO gwr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","era ni libamira aamo nʼebyʼomu bisito byabwe, nʼabantu bonabona ababbaire bawagira oKoola aamo nʼebyabwe byonabyona. ");
INSERT INTO gwr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Batyo ni baweera omu kiina nga boomi, nʼebintu byabwe byonabyona; eitakali ni libabbuunaku, ni bajigirika era babba bazwire omu bantu abanaabwe. ");
INSERT INTO gwr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","ABaisirairi bonabona ababbaire beeruguuliriirye abantu abo, owebawuliire okukuukulya ni bairuka, nga bakooka bati, “Twirukewo, demba swena eitakali ni litumira!” ");
INSERT INTO gwr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","OMusengwa nʼasindika omusyo, ni gwoca abantu 250 badi ababbaire baduunyisya obubbaani. ");
INSERT INTO gwr_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Okobe Eryezaali omutaane wʼAlooni okabona, omu kyocerye ekyʼabantu badi 250, atoolemu ebyokuduunyisiryaku ebyabbaire ebyʼabantu abo, kaisi igo amakala gʼomusyo agamwage eedi, olwʼokubba ebyokuduunyisiryaku ebyo bitukulye. ");
INSERT INTO gwr_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Ebyokuduunyisiryaku ebyʼabantu abo abakolere ekikole ekibbikibbi era ni kibazweraku okufa, babiyeesemu ebibaati ebyokubiikanga oku kyoto, olwʼokubba ebyokuduunyisiryaku ebyo babbaire babiwaireyo eeri Nze oMusengwa ni bibba bitukulye. Ebibaati ebyo byabbanga kamanyiciryo akalabula aBaisirairi.” ");
INSERT INTO gwr_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Kale Eryezaali okabona nʼasolooja ebyokuduunyisiryaku ebya bbulonzi abantu abo abeboocerye ebibabbaire baleetere, ni babiyeesamu ekibiika oku kyoto, ");
INSERT INTO gwr_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ngʼoMusengwa oweyabbaire alagiire okubitira omu Musa. Omu ngeri eyo okwo ni kubba kulabula eeri aBaisirairi okuti; nabuli muntu atali wʼeibyaire lyʼAlooni, tiyaigereranga omumaiso ga Musengwa okuduunyisya obubbaani, demba bamujigirica ngʼowebakolere oKoola nʼabawagiribe. ");
INSERT INTO gwr_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Oku lunaku olwairireku, ekibbula kyonakyona ekyʼaBaisirairi ni kyezulugumira oMusa nʼAlooni, nga bakoba bati, “Mwaitire abantu ba Musengwa.” ");
INSERT INTO gwr_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Awo aBaisirairi bonabona owebabbaire nga bakumbaanire okwakanisya oMusa nʼAlooni, ni bagaluka ni balingirira eWeema eyʼoKusisinkanirangamu oMusengwa, amangu ago ekireri ni kigibiikaku era ekitiisya kya Musengwa ni kiboneka. ");
INSERT INTO gwr_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Awo oMusa nʼAlooni ni baaba ni beemerera omumaiso wʼeWeema eyʼoKusisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Era oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Muzwe omu bantu banu, kaisi ibo mbajigirice mulundi gumo!” OMusa nʼAlooni ni bafuunama ni baica empumi gyabwe ansi okwitakali ni bamwegairira. ");
INSERT INTO gwr_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Awo kaisi oMusa nʼakoba Alooni ati, “Okwate ekyokuduunyisiryakukyo, otoole oku kyoto amakala gʼomusyo ogateeke omu kyokuduunyisiryakukyo, kaisi oteekeku obubbaani, okitwale mangu omu bantu era okole omukolo ogwʼokubasuuca okubba balongoole, olwʼokubba obulwa bwa Musengwa bubagwireku, era okawumpuli atandiikire.” ");
INSERT INTO gwr_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Kale Alooni nʼakola ngʼoMusa oweyamukobere, nʼairuca ekyokuduunyisiryakukye omu bantu, nʼayajirirya ngʼokawumpuli atandiikire okwita abantu abo. Neye Alooni nʼateeka obubbaani omu kyokuduunyisiryaku, era nʼakola omukolo ogwʼokusuuca abantu abo okubba balongoole. ");
INSERT INTO gwr_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Era nʼasigala ngʼayemereire aakati omu bantu abakaali aboomi nʼabafiire era okawumpuli nʼakoma. ");
INSERT INTO gwr_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ibo abafiire okawumpuli babbaire 14,700, nga tobaliireku abafeereire aamo nʼoKoola omu keediimoke. ");
INSERT INTO gwr_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Okawumpuli oweyawoireku, Alooni nʼakanga eeri oMusa oku mulyango gwʼeWeema eyʼoKusisinkanirangamu oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Okobe aBaisirairi bakuwe emikoomero ikumi na mibiri, gumo okuzwa eeri nabuli mukulu wʼekika, kaisi owandiike eriina lya buli mukulu wʼekika oku mukoomerogwe. ");
INSERT INTO gwr_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Era oku mukoomero gwʼabʼekika kya Leevi owandiikeku eriina lyʼAlooni, olwʼokubba wali nʼokubbaawo omukoomero gumo ogwa buli mukulu wʼekika. ");
INSERT INTO gwr_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Watwala emikoomero egyo omu Weema eyʼoKunsisinkanirangamu nze oMusengwa, nʼogiteeka omumaiso wʼeSanduuku eyʼeNdagaano, awensisinkanira na inywe. ");
INSERT INTO gwr_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Omuntu ogunalonda, omukoomerogwe gwaloka, kaisi mmalewo e gyendi aBaisirairi okukwezulugumiranga.” ");
INSERT INTO gwr_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Atyo oMusa nʼatumula nʼaBaisirairi nʼabakulu baabwe bonabona, ni bamuwa omukoomero gumo gumo okuzwa mu buli kika, gyonagyona ni gibba ikumi na mibiri. Omukoomero ogwʼAlooni gwona nga gumo kwigyo. ");
INSERT INTO gwr_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","OMusa nʼateeka emikoomero egyo omu Weema eyʼoKusisinkanirangamu oMusengwa, omumaiso wʼeSanduuku eyʼeNdagaano. ");
INSERT INTO gwr_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Oku lunaku olwairireku oMusa nʼaingira omu kifo eSanduuku eya Musengwa e gyebba omu Weema eyʼoKusisinkanirangamu oMusengwa, nʼayajirya ngʼomukoomero ogwʼAlooni, ogwʼabʼekika kya Leevi gulokereku obusaga gumulikire, era nga guliku ebineneka byengere. ");
INSERT INTO gwr_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","OMusa nʼatoolayo emikoomero gyonagyona, nʼagiwuluca e nza nʼagiragisya aBaisirairi bonabona, ni bagikebera, era nabuli moiza nʼakanja ogugwe. ");
INSERT INTO gwr_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","OMusengwa nʼakoba oMusa ati, “Okanjeeyo omukoomero ogwʼAlooni omumaiso wʼeSanduuku eyʼeNdagaano, gubbenge aawo ngʼakamanyiciryo akalabula abataka okunjeemera, okukomya okuneezulugumiranga kaisi tibaafa.” ");
INSERT INTO gwr_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","OMusa nʼakola ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Awo aBaisirairi ni bakoba oMusa bati, “Iswe swenaswena twaba kufa! Twaba kuwaawo, twaba kujigirika! ");
INSERT INTO gwr_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Owekibba kiti, nabuli aigerera okumpi, era iye oyo aigerera oku Weema eya Musengwa afa, olwo swenaswena tituli bʼokuwaawo?” ");
INSERT INTO gwr_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Awo oMusengwa nʼakoba Alooni ati, “Iwe nʼabʼeibyaireryo, nʼabʼomu kikaakyo bonabona, niinywe omwavunaanyizibwanga oku byabbanga bisobere omu Kifo eKitukulye. Wazira ebyabbanga bisobere omu bwakabona, iwe nʼabʼeibyaireryo niinywe nywenkani omwavunaanyizibwanga. ");
INSERT INTO gwr_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Waizanga nʼabʼekikaakyo aBaleevi, bakwegaiteku era bakubbeerenge iwe nʼabʼeibyaireryo nga muweererya omu kifo ekitukulye eSanduuku eyʼeNdagaano yange nze Musengwa e gyebba omu Weema eyʼoKunsisinkaniramu. ");
INSERT INTO gwr_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Bakolanga emirimo egiwabalagiranga, nʼemirimo gyonagyona egyʼomu Weema eyo, neye tiwabaikiriryanga okwigereranga oku bintu byʼomu Kifo eKitukulye, waire oku kyoto, demba ibo na inywe ni mufa. ");
INSERT INTO gwr_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Bakoleranga aamo na iwe, ni balabiriranga eWeema eyʼoKunsisinkanirangamu, nga bakola emirimo gyamu gyonagyona. Neye atali Muleevi, tiyaigereranga okumpi na iwe e gyokolera.” ");
INSERT INTO gwr_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Era inywe niinywe omwavunaanyizibwanga okulabiriranga eKifo eKitukulye nʼekyoto, kaisi tete tinasunguwaliranga aBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ninze onanyere eneerondeiremu abaganda baanywe aBaleevi omu Baisirairi ni babba kirabo ekimbawaire inywe, era ibo ni mbaawula, okukolanga emirimo omu Weema eyʼoKunsisinkanirangamu nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Neye iwe nʼabʼeibyaireryo, niinywe nywenkani omwakolanga emirimo gyonagyona egyʼobwakabona egikwatagana nʼekyoto, era nʼebyo ebiri omu Kifo eKitukulye eino. Okuweereryanga omu bwakabona, nkibawaire inywe ngʼekirabo. Atali owʼeibyaireryo eyaigereranga omu Kifo eKitukulye, baabbanga nʼokumwita.” ");
INSERT INTO gwr_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Awo oMusengwa ni yeeyongera okukoba Alooni ati, “Obone, ninze onanyere nkuteekere omu buvunaanyizibwa obwʼebyokuwaayo ebibawaayo eeri nze; ebyokuwaayo ebitukulye byonabyona aBaisirairi ebibawaayo eeri nze, mbikuwaire iwe nʼabʼeibyaireryo ngʼomugabo ogwanywe ogwʼenkalaakalira. ");
INSERT INTO gwr_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Oku bintu ebyo byonabyona ebitukulye eino ebibawaayo eeri nze ebitali byʼesadaaka egibooca yonayona, byabbanga nʼokubba byanywe. Ebyokuwaayo byonabyona, omulimu ekyokuwaayo kyabwe ekyʼempeke, nʼesadaaka eyʼokusoniya ekikole ekibbikibbi nʼesadaaka eyʼokusoniya eibbengo ebibawaayo eeri nze byabbanga bibyo nʼabʼeibyaireryo. ");
INSERT INTO gwr_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Mwabbanga nʼokubitwalanga okubba bitukulye era ni mubba nʼokubiriiranga mu Kifo eKitukulye eIno, era bʼekikula kyʼekisaiza bonkani niibo ababiryangaku. Muli nʼokubitwala okubba bitukulye.” ");
INSERT INTO gwr_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Era nʼebintu binu byona byabbanga byanywe: Ebyokuwaayo byonabyona aBaisirairi ebibaawiire oku byokuwaayo ebyenjabulo ebibasiirya ni baica. Ebyo mbikuwaire iwe nʼabʼeibyaireryo abaisuka nʼabaala gubbenge mugabo gwanywe ogwʼenkalaakalira. Nabuli mulongoole aali omu bisito byanywe, bamwikiriryanga okubiryaku.” ");
INSERT INTO gwr_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Byonabyona ebikiraku obusa, ebyekeereri, oku mafuta gʼemizaituuni, oku mwenge gwʼemizabbibbu, nʼoku ngaano, ebibawaayo eeri Nze oMusengwa, mbawaire. ");
INSERT INTO gwr_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ebineneka byonabyona ebyekeereri omu kyalo kyabwe, ebibawaireyo eeri Nze oMusengwa, byabbanga byanywe. Nabuli mulongoole aali omu bisito byanywe, bamwikiriryanga okubiryaku.” ");
INSERT INTO gwr_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Nabuli kintu omwIsirairi ekibawonganga eeri nze oMusengwa, kyabbanga kikyo. ");
INSERT INTO gwr_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Nabuli ekibere, kibbe muntu ooba kibbe kisolo, ekibawaireyo eeri Nze oMusengwa, kyabbanga kikyo. Neye omwana wʼoMwisirairi omwisuka omubere, waabbanga nʼokutwala mpiiya egibamununulira. Era nʼokisolo atali mulongoole, waabbanga nʼokutwala mpiiya egibamununulira. ");
INSERT INTO gwr_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Abaana babanunulanga nga bʼomweri gumo, oku bbeeyi egibateekerewo eyʼesekeri eitaanu egyʼefeeza okusinzirira oku kipimo ekitongole ekyʼomu Kifo eKitukulye, niigyo egera aabiri buli sekeri.” ");
INSERT INTO gwr_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Neye onte, nʼontaama, nʼombuli, ebibere, tibali nʼokubinunulanga. Ibyo ebyo bitukulye. Babisalanga, omusaaye gwabyo nʼoguswankira oku kyoto, kaisi amasavu gaabyo nʼogooca ngʼesadaaka egibooca nʼezwamu oluvululu olunsangaalya Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Iyo enyama yaabyo, yaabbanga yiyo, ngʼobbanda wʼesadaaka eyʼenjawulo egibasiirya ni baica, nʼekisambi ekyʼoku ndiiro, owebiri bibyo. ");
INSERT INTO gwr_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ebirabo byonabyona ebyʼenjawulo aBaisirairi ebibaawangayo eeri nze, mbikuwaire iwe nʼabʼeibyaireryo abaisuka nʼabaala, ebintu ebyo bibbenge mugabogwo ogwʼenkalaakalira. Eyo niiyo endagaano eyʼenkalaakalira etiyalidiba eginkolere na iwe era nʼabʼeibyaireryo.” ");
INSERT INTO gwr_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","OMusengwa ni yeeyongera okukoba Alooni ati, “Tiwalisuna omuwuluko, waire okukuwa omugabo omu kyalo kyʼaBaisirairi. Oku byange kuwagabananga, era kuwasunanga ebyokukubbeesyawo omu Baisirairi.” ");
INSERT INTO gwr_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","OMusengwa ni yeeyongera ati, “ABaleevi mbawaire ebimo byʼeikumi byonabyona aBaisirairi ebibampanga, bibbenge mugabo gwabwe ngʼempeera eyʼokuweererya omu Weema eyʼoKunsisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Nʼokuzwa atyanu, aBaisirairi abatali Baleevi, tibagezyanga okwigerera oku Weema eyʼoKunsisinkanirangamu, olwʼokutabazweramu okubaita olwʼekikole ekibbikibbi kyabwe ekyo. ");
INSERT INTO gwr_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Neye aBaleevi, niibo abakolanga omulimo ogwʼobuweererya omu Weema eyʼoKunsisinkanirangamu, era niibo abavunaanyiziwanga ebyʼeWeema eyo ebyabbanga bisobere. Eryo lyabbanga iteeka eryʼenkalaakalira, eryakolanga nʼoku bʼemirembe egyaliirawo. Ibo tibabbenge nʼemiwuluko omu Baisirairi abanaabwe. ");
INSERT INTO gwr_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Wazira, ibo aBaleevi ndi kubawa ebimo ebyʼeikumi ebyʼebintu aBaisirairi ebibampanga Nze oMusengwa ngʼebyokuwaayo, kagira mbakoba ibo nti tibabbenge nʼemiwuluko omu Baisirairi.” ");
INSERT INTO gwr_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","OMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Otumule nʼaBaleevi, obakobe oti, ‘Owemwasunanga oku Baisirairi ekimo kyʼeikumi nze oMusengwa ekyembawaire inywe okubba ekyanywe, mwabbanga nʼokutoolaku ekimo kyʼeikumi kwibyo, nywena ni mukiwaayo eeri nze oMusengwa ngʼekyokuwaayo ekitukulye. ");
INSERT INTO gwr_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Era ekyokuwaayo kyanywe ekyo bakikubaliranga ngʼomulimi owebamubalira ekyawaayo ekyʼempeke ekyatoola omu kikonero, nʼekyokuwaayo ekyʼomwenge ogwʼemizabbibbu, ogwatoola omu kikunyiro. ");
INSERT INTO gwr_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Mutyo na inywe mwatoolanga oku bimo ebyʼeikumi aBaisirairi ebibabawanga inywe, ni muwaayo eeri Nze oMusengwa ekyokuwaayo ekyenjawulo. Ekyokuwaayo ekyo ekyenjawulo ekimuwaayo eeri nze oMusengwa, mwabbanga nʼokukiwa Alooni okabona. ");
INSERT INTO gwr_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ekyokuwaayo kyonakyona eeri nze oMusengwa kyabbanga kiidi ekikirira nakimo obusa era ekikirira nakimo obutukulye oku birabo ebibakuwa.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Kale oyongere okukoba aBaisirairi oti, ‘Owemwawangayo ekikirira nakimo obusa, bakibabaliranga ngʼomulimi owebamubalira ebyatoola omu kikonero nʼomu kikunyiro kyʼomwenge ogwʼemizabbibbu nʼabiwaayo. ");
INSERT INTO gwr_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Era ebyasigalangaku, inywe nʼabʼomu bisito byanywe, mwabiriiranga wonawona awemwabbanga mutakire, olwʼokubba yaabbanga niiyo empeera yaanywe eyʼomulimo ogumukola omu Weema eyʼoKusisinkanirangamu. ");
INSERT INTO gwr_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Owemwawangayo ebikirira nakimo obusa kwebyo ebimwasunanga, timwabbengeku omusango omu nsonga eyo; era awo mwabbanga timusuucirye ebitukulye aBaisirairi ebibawaayo, okubba tibilongoole kaisi ni mulama okubaita.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Awo oMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Kinu niikyo ekiragiro ekiri omwiteeka, Nze oMusengwa erinteekawo: Mukobe aBaisirairi babaleeterenge ompaki omutukuliki abulaku obuleme, era ogubatateekangaku oku kijooko. ");
INSERT INTO gwr_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mumuwenge Eryezaali okabona, onte oyo ni bʼamutwala e nza wʼenkambi, ni bamusalira omumaisoge. ");
INSERT INTO gwr_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Awo Eryezaali okabona yatimyanga olunwelwe omu musaaye gwayo, nʼagumansira emirundi musanvu okulungama omumaiso wʼeWeema eyʼoKusisinkanirangamu Nze oMusengwa. ");
INSERT INTO gwr_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Onte oyo yenayena, ekikoba kiti, eidiba, nʼenyama, nʼomusaaye, nʼebyenda byayo, bali nʼokubyoca ngʼokabona oyo abona. ");
INSERT INTO gwr_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Awo okabona oyo yakwatanga akasaale kʼomuvule, nʼakasaga kʼakasaale akebeeta oyisopu, nʼebyoya bya ntaama ebitukuliki, nʼabimuma omu musyo, omuboocerya onte oyo. ");
INSERT INTO gwr_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ebyo nga biwoire okabona oyo yaabbanga nʼokwoza ebizwalobye, nʼanaaba. Awo ngʼayinza okwingira omu nkambi, neye yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Era omuntu eyayocanga onte oyo, yayozanga ebizwalobye, nʼanaaba, neye yena yasigalanga nga timulongoole paka igulo.” ");
INSERT INTO gwr_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Awo omuntu omulongoole yayoolanga eikoke lya mpaki oyo, nʼalisuka e nza wʼenkambi omu kifo ekirongoole. Eeyo niiyo ekibbula kyonakyona ekyʼaBaisirairi e gikyalikuumiranga, era ni balikolesyanga nga bategeka amaizi agebakolesyanga oku mukolo gwʼokusuuca omuntu okubba mulongoole. Omukolo ogwo niigwo ogwʼokutoolawo ekikole ekibbikibbi. ");
INSERT INTO gwr_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Omuntu eyayoolanga eikoke lya mpaki oyo, yayozanga ebizwalobye, neye yena yasigalanga nga timulongoole paka igulo. Eiteeka eryo lyabbanga lyʼenkalaakalira eeri aBaisirairi nʼeeri abanamawanga ababba mwibo.” ");
INSERT INTO gwr_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","OMusengwa ni yeyongera okukoba oMusa nʼAlooni ati, “Nabuli eyakwatanga oku mulambo, yaabbanga timulongoole okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Yaabbanga nʼokunaaba oku lunaku lwokusatu nʼoku lunaku lwomusanvu amaizi agʼokumusuuca okubba mulongoole, olwo kaisi nʼabba mulongoole. Neye singa tiyanaabenge oku lunaku lwokusatu nʼoku lunaku lwomusanvu okumusuuca okubba mulongoole, yasigalanga nga timulongoole. ");
INSERT INTO gwr_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nabuli eyakwatanga oku mulambo gwʼomuntu yenayena kaisi nandi ni yeetukulya, yasuucanga eWeema ya Musengwa okubba tinnongoole, era baabbanga tibamubala okubba mulongoole. Yasigalanga nga timulongoole, olwʼokubba babbanga tibamumansiireku amaizi agʼokumusuuca okubba mulongoole.” ");
INSERT INTO gwr_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","OMusengwa ni yeyongera okubakoba ati, “Linu niiryo eiteeka erimwakwatanga ngʼomuntu afeereire omu weema: Nabuli eyaabbanga omu weema eyo nʼeyagingirangamu, yaabbanga timulongoole okumala enaku musanvu. ");
INSERT INTO gwr_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Nabuli kintu ekyabbanga omu weema eeyo ekyasaamiriri, ekitali kibiikeku ekisaanikiro, kyabbanga tikirongoole.” ");
INSERT INTO gwr_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Singa omuntu yaabbanga e nza wʼenkambi nʼakwata oku mulambo gwʼomuntu ogubaitire ooba afiire olumbe, ooba singa yakwatanga okwigumba lyʼomufu, ooba oku magombe, kyamusuucanga okusigala nga timulongoole okumala enaku musanvu.” ");
INSERT INTO gwr_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Oku lwʼomuntu oyo atali mulongoole, batoolanga okwikoke erya nte oodi omutukuliki owʼekyokuwaayo ekyʼomukolo gwʼokusuuca abantu okubba abalongoole, ni baliteeka omu kibya, ni balisukamu amaizi agʼomwiruba. ");
INSERT INTO gwr_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Awo omuntu omulongoole yakwatanga akasaale ka yisopu, nʼakatimya omu maizi ago, nʼagaswankira oku weema, nʼoku bintu byamu byonabyona, nʼoku bantu abagirimu, na kwoyo eyaabbanga akwaite oku mulambo gwʼomuntu ogubaitiire e nza wʼenkambi ooba afiire olumbe, ooba eyaabbanga akwaite okwigumba lyʼomufu. ");
INSERT INTO gwr_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Oku lunaku lwokusatu nʼoku lunaku olwomusanvu, omuntu omulongoole yaswankiranga amaizi gadi amatawulemu eikoke lidi oku muntu atali mulongoole. Era oku lunaku olwomusanvu, yamusuucanga okubba mulongoole. Olwo omuntu oyo ogubasuucirye okubba omulongoole, yayozanga ebizwalobye nʼanaaba, era yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Neye singa omuntu atali mulongoole, yasigalanga nga takolere omukolo gwʼokumusuuca okubba mulongoole, baabbanga tibamubala okubba moiza oku Baisirairi olwʼokubba yaabbanga asuucirye eWeema ya Musengwa okubba tinnongoole. Olwʼokubba baabbanga tibamuswankiireku amaizi agebakolesya oku mukolo gwʼosuuca abantu okubba balongoole, yasigalanga nga timulongoole. ");
INSERT INTO gwr_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Eiteeka linu mwalikwatanga emirembe gyonagyona.” “Omuntu amansira amaizi agebakolesya oku mukolo gwʼokusuuca abantu okubba balongoole, yena yaabbanga nʼokwoza ebizwalobye, era nabuli eyakwatanga omu maizi ago, yasigalanga nga timulongoole paka igulo. ");
INSERT INTO gwr_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Nabuli kintu omuntu atali mulongoole ekiyakwatangaku kyasuukanga tikirongoole, era nabuli muntu eyakikwatangaku, yasigalanga nga timulongoole paka igulo.” ");
INSERT INTO gwr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Awo ekibbula kyonakyona ekyʼaBaisirairi ni kituuka omwidungu lyʼe Ziini omu mweri ogusooka, era abantu abo ni bakola enkambi e Kadesi. Nga bali eeyo, oMiryamu omwonyoko wa Musa nʼafa, era ni bamuliikayo. ");
INSERT INTO gwr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Atyanu tiwabbaireyo amaizi gʼabantu abo okunywa, era ni beezuluguma nga bakumbaine beeruguulirirye oMusa nʼAlooni. ");
INSERT INTO gwr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kale abantu nago ni bayombesya oMusa, nga bakoba bati, “Singa twafiire abaganda baiswe owebafeereire omumaiso ga Musengwa, nga kyabbaire kisa! ");
INSERT INTO gwr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Lwaki waleetere ekibbula kyonakyona ekya Musengwa omwidungu linu? Watakire iswe nʼebyayo byaiswe tufeere aanu? ");
INSERT INTO gwr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Era lwaki watutoire e Misiri, nʼotuleeta omu kifo kinu ekyakabbikabbi omubulamu empeke yʼengaano, waire emitiini, omubulamu emizabbibbu, waire nkomamawanga, era omubulamu nʼamaizi agʼokunywa?” ");
INSERT INTO gwr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","OMusa nʼAlooni ni bazwa omumaiso gʼabantu aabo, ni baaba oku mulyango gwʼeWeema eyʼoKusisinkanirangamu oMusengwa, ni bafuunama ni baica empumi gyabwe ansi okwitakali okumuwa ekitiisya, ekitiisya kya Musengwa ni kibabonekera. ");
INSERT INTO gwr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Awo oMusengwa nʼakoba oMusa ati, ");
INSERT INTO gwr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Okwate omwigo oguli omumaiso wʼeSanduuku eyʼeNdagaano, era iwe nʼAlooni omugandawo mukumbaanie abantu abo kaisi mulagire eibbaale eryo lizwemu amaizi omumaiso gaabwe aawo nga bonabona babona. Omukukola otyo watoolera abantu aabo amaizi omwibbaale ni banywa nʼebyayo byabwe byona ni binywa.” ");
INSERT INTO gwr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Atyo oMusa nʼatoola omwigo oku Sanduuku eyʼeNdagaano, ngʼoMusengwa oweyamulagiire. ");
INSERT INTO gwr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","OMusa nʼAlooni ni bakumbaanirya ekibbula kyonakyona ekyʼaBaisirairi aamo aawo eibbaale e giriri, kaisi oMusa nʼakoba abantu abo ati, “Bajeemu inywe, muwulisisye! Tuli nʼokubatoolera amaizi omwibbaale linu?” ");
INSERT INTO gwr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Awo oMusa nʼasiirya omwigo nʼagukubba okwibbaale emirundi mibiri, amaizi mangi ni gatiiriika okuzwa omwibbaale. Abantu bonabona ni banywa nʼebyayo byabwe byona ni binywa. ");
INSERT INTO gwr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Neye oMusengwa nʼakoba oMusa nʼAlooni ati, “Atyanu olwʼokubba timwanjikiririiryemu, nandi ni mumpeesya ekitiisya ngʼomutukulye omumaiso gʼaBaisirairi, timwalingirya abantu abo omu kyalo ekinabawaire.” ");
INSERT INTO gwr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ekifo ekinandi bamuweeseryamu ekitiisya kyabbaire ku nsulo gyʼe Meribba, aBaisirairi e gibayombeseirye oMusengwa, nʼabalaga ngʼowaali mutukulye. ");
INSERT INTO gwr_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Owebabbaire nga bakaali bali e Kadesi, oMusa nʼatuma abakwenda eeri okabaka wʼEdomu okumukobera ati, “Abagandabo aBaisirairi bakoba bati, ‘Omaite nakusani ebigosi byonabyona ebyatutuukireku. ");
INSERT INTO gwr_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Abazeiza baiswe baabire omu kyalo kyʼe Misiri, eeyo e gitubbaire okumala emyanka emingi. ABamisiri batugadirye iswe nʼabazeiza baiswe. ");
INSERT INTO gwr_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Neye owetwekungiriire oMusengwa okutubbeera, yawuliire okwekunga kwaiswe, nʼatuma omukwenda nʼatutoola e Misiri.’ ” “ ‘Atyanu tuli yaanu Kadesi, ekibuga ekiri oku nsalo nʼekyalokyo. ");
INSERT INTO gwr_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Tukwegairiire otwikirirye tubiteku omu kyalokyo. Titwabukeku omu musiri kadi gumo, waire ogwʼemizabbibbu, era titwanyweku amaizi agʼomu malubago. Twaba kusenja luguudo olunene lwonkani okabaka olwabitamu, anambula kwabuka okwira oku ndiiro ooba oku ngooda, paka owetwazwa omu kyalokyo.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Neye okabaka wʼEdomu nʼabairamu ati, “Timwabita omu kyalo kyange. Owemwagezyaku okukibitamu, twaba okukwata ebyokulwanisya tubalumbe.” ");
INSERT INTO gwr_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ABaisirairi ni bairamu bati, “Iswe twaba kusenja luguudo olunene olwo lwonkani, era singa iswe ooba ebyayo byaiswe byanywaku amaizi gaanywe, twagasasulira. Tusaba kimo kyonkani, mutwikirirye tubitekuumu-bubiti na bigere.” ");
INSERT INTO gwr_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Era okabaka nʼabairamu ati, “Timwakibitemu.” Era awo nʼasindika amaje agʼamaani ni gabalumba nʼamaani amabitiriri. ");
INSERT INTO gwr_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Olwʼokubba okabaka wʼEdomu yagaine aBaisirairi okubita omu kyalokye, ni kyazya aBaisirairi ni bacuuka ni bakwata nzira gendi. ");
INSERT INTO gwr_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Ekibbula kyonakyona ekyʼaBaisirairi ni kitambula ni kizwa e Kadesi ni kituuka oku Lusozi oKoli. ");
INSERT INTO gwr_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Nga bali eeyo oku lusozi oKoli okumpi nʼensalo yʼEdomu, oMusengwa nʼakoba oMusa nʼAlooni ati, ");
INSERT INTO gwr_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Alooni ayaba okufa asenje abazeizabe. Tiyalingira omu kyalo ekinasuubizire okuwa aBaisirairi, olwʼokubba inywe mwembi mwajeemeire ekiragiro kyange oku nsulo gyʼe Meribba. ");
INSERT INTO gwr_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Okwate Alooni nʼomutaanewe Eryezaali, obatwale oku Lusozi oKoli. ");
INSERT INTO gwr_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Nga muli eeyo wayambulyamu Alooni ebizwalobye ebyʼobwakabona, nʼobizwalisya omutaane Eryezaali olwʼokubba Alooni ayaba okufeera eeyo, asenje abazeizabe.” ");
INSERT INTO gwr_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Atyo oMusa nʼakola ngʼoMusengwa oweyamulagiire ni baniinaniina ni baaba oku Lusozi oKoli, ngʼaBaisirairi bonabona babona. ");
INSERT INTO gwr_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Awo oMusa nʼayambulyamu Alooni ebizwalo ebyʼobwakabona, nʼabizwalisya Eryezaali omutaane wʼAlooni. Era Alooni nʼafeera eeyo oku nairungu wʼolusozi olwo. Kaisi olwo oMusa nʼEryezaali ni baserengeta ni bazwa oku lusozi olwo, ");
INSERT INTO gwr_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","era ekibbula kyonakyona ekyʼaBaisirairi owekyategeire kiti Alooni afiire, eigwanga lyonalyona erya Isirairi ni limala enaku 30 nga limukunga. ");
INSERT INTO gwr_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Atyanu okabaka wʼaBakanani owʼomu kibuga Aladi, eyatyamanga omwidungu oNegevu, oweyawuliire ati aBaisirairi bali kwiza, nga basenja oluguudo olwaba Asalimu, nʼayaba nʼabalumba era nʼawambamu abamo. ");
INSERT INTO gwr_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Awo aBaisirairi ni beeyama eeri oMusengwa bati, “Singa waawaayo abantu aabo omu bwezye bwaiswe, twaba kujigiricirya nakimo ebibuga byabwe.” ");
INSERT INTO gwr_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","OMusengwa nʼaikirirya okwegairira kwʼaBaisirairi okwo, era nʼawaayo aBakanani omu bwezye bwabwe, era aBaisirairi ni bajigiricirya nakimo nʼebibuga byabwe. Kale ekitundu ekyo ni bakiwa eriina bati, Koluma. ");
INSERT INTO gwr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Awo aBaisirairi owebazwire oku Lusozi oKoli bagedereirye nga babita oku mbale mbale kwʼekitundu kyʼEdomu, ni basimba e Maserengeta ni balungama oku Nyanza eNtukuliki. Neye abantu ni beesinya nga bali omu lugendo olwo. ");
INSERT INTO gwr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Kale ni batumula kubbikubbi oku Kibbumba nʼoku Musa bati, “Lwaki mwatutoire e Misiri okutwitisirya omwidungu linu? Mpaamu kyokulya, mpaamu maizi. Nʼokwesinya twesinyire ekyokulya kinu ekinambulamu.” ");
INSERT INTO gwr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Awo oMusengwa nʼabasindikamu empiri egya saagwa, ni gibaluma, era aBaisirairi bangi ni bafa. ");
INSERT INTO gwr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Abantu ni baaba eeri oMusa, ni bamukoba bati, “Twakolere ekikole ekibbikibbi owetwatumwire okubbikubbi oku Kibbumba na kwiwe. Otusabire oMusengwa atutoolerewo empiri.” Atyo oMusa nʼasabira abantu. ");
INSERT INTO gwr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Awo oMusengwa nʼakoba oMusa ati, “Okole ekifaananyi ekiri ooti mpiri owa saagwa, kaisi okyanike oku kikondo. Olwo nabuli ompiri oguyalumanga, yaabanga nʼakirolaku nʼalama.” ");
INSERT INTO gwr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Kale oMusa nʼakola ekifaananyi ekya mpiri omu bbulonzi, nʼakyanika oku kikondo. Olwo nabuli ompiri oguyalumanga, nʼayaba nʼalola oku kifaananyi ekyo, ngʼalama. ");
INSERT INTO gwr_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Awo aBaisirairi ni beeyongerayo, ni baaba bakola enkambi omu kitundu ekibeeta Obbosi. ");
INSERT INTO gwr_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Owebazwire omwObbosi, ni baaba bakola enkambi omu kitundu kyʼe Iye Abbalimu ekiri omwidungu. Ekitundu ekyo kiringiriire ekyalo ekyʼe Mowaabbu, oku lubba olwʼe buzwaisana. ");
INSERT INTO gwr_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Owebazwire eeyo, ni beeyongerayo baaba ni bakola enkambi omu Kiinamo oZeredi. ");
INSERT INTO gwr_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Ni bazwa eeyo, beeyongerayo ni baaba bakola enkambi okwitale kwʼomwiga Alunoni, oguli omwidungu erituuka omwitwale lyʼaBamooli. Omwiga Alunoni niigwo ogwawula ekyalo kyʼaBamowaabbu nʼekyʼaBamooli. ");
INSERT INTO gwr_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Ekyo niikyo ekigira ekitabo ekibeeta eKitabo kyʼeNtalo gya Musengwa kitumula oku, “Wakebbu ekibuga kyʼomu kyalo oSuufa nʼebiinamo nʼomwiga Alunoni, ");
INSERT INTO gwr_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","nʼamantyereremuko gʼebiinamo ebyo, okwabira kimo oku kibuga Ali, oku nsalo nʼekyalo kya Mowaabbu.” ");
INSERT INTO gwr_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Owebazwire eeyo ni beeyongerayo paka oku kibuga oBbeeri. Okumpi aawo wabbairewo eiruba oMusengwa e giyakobeire oMusa ati, “Okumbaanie abantu, njaba kubawa amaizi.” ");
INSERT INTO gwr_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Awo aBaisirairi ni bayemba olwembo lunu bati, “Iwe iruba, oigulye ensulogyo. Mulyembeku, ");
INSERT INTO gwr_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","mwembe okwiruba eryo abeekubbemberi eribakwire, ibo abakungu bʼabantu eribakwire ibo abakungu abʼemikoomero nʼemiigo.” Ni bazwa omwidungu, ni baaba ni bakola enkambi omu kibuga oMataana. ");
INSERT INTO gwr_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Bazwire e Mataana, ni baaba e Nakaliyeeri. Owebazwire e Nakaliyeeri baabire ni batuuka omu kitundu kyʼe Bbamosi. ");
INSERT INTO gwr_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Owebazwire e Bbamosi, baabire omu kiinamo ekiri omu kyalo kyʼaBamowaabbu, onairungu wʼolusozi oPisuga aali engulu omwidungu e gyabonekera. ");
INSERT INTO gwr_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Awo aBaisirairi ni batuma abakwenda eeri oSikoni, okabaka wʼaBamooli, okumukoba bati, ");
INSERT INTO gwr_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Otwikirirye tubiteku omu kyalokyo. Titwawukeku omu musiri gwonagwona, waire ogwʼemizabbibbu, waire okunywaku amaizi omwiruba lyonalyona. Twaba kusenja luguudo olunene lwonkani okabaka olwabitamu, paka owetwalizwa omu kyalokyo.” ");
INSERT INTO gwr_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Neye oSikoni tiyaikiriirye aBaisirairi okubita omu kyalokye. Yategekere majeege gonagona, ni gakumba gaaba mwidungu e Yakazi, okulwanisya aBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Neye aBaisirairi ni baitira abantu abo omu lutalo olwo, ni beetwalira ekyalo ekyo, okuzwera oku Mwiga Alunoni paka ku Mwiga oYabboki, neye ni bakoma ku Baamoni, olwʼokubba ensalo yʼaBaamoni yabbaireku olugaga. ");
INSERT INTO gwr_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Kale aBaisirairi ni bawamba era ni batyama omu bibuga byʼaBamooli byonabyona, omuli nʼoKesyubboni, nʼobubuga bwonabwona obwabbaire bubyeruguuliriirye. ");
INSERT INTO gwr_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","OKesyubboni niikyo ekyabbaire ekibuga ekikulu ekya Sikoni okabaka wʼaBamooli, eyabbaire alwanisirye eyabbaire okabaka wa Mowaabbu, era ngʼamuwambireku ekyalokye kyonakyona, okutuukira nakimo oku Mwiga Alunoni. ");
INSERT INTO gwr_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Ekyo niikyo ekyazwireku abayiiya ebikwate ni bawandiika bati, “Mwize omu Kesyubboni mukyombeke buyaaka; aale ekibuga kyʼe Sikoni, mukiiryewo. ");
INSERT INTO gwr_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Omusyo gwatumbukiire omu Kesyubboni, gwalunkuumiire omu kibuga kyʼe Sikoni. Gwamalirewo ekibuga Ali omu kyalo kyʼe Mowaabbu, ni gujigirica abatyami bʼoku nsozisozi gyʼoku Mwiga Alunoni. ");
INSERT INTO gwr_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Wobe, ala nga mulabire inywe aBamowaabbu! Babajigiricirye inywe abasinza onkuni oKemosi! Alekeswire abataane ni kibazweraku kubba basenze, nʼabaalabe kubba bawambe ba Sikoni okabaka wʼaBamooli. ");
INSERT INTO gwr_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Neye tubawangwire, oKesyubboni tukijigiricirye okutuukira nakimo e Dibboni. Tubasesembwire ni twaba paka mu kibuga e Noofa, ekituuka oku kibuga oMedebba.” ");
INSERT INTO gwr_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Kale aBaisirairi ni basuuka batyami omu kyalo kyʼaBamooli. ");
INSERT INTO gwr_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Oluzwanyuma oMusa ngʼatumire abantu okukeeta ekibuga oYazeri, aBaisirairi ni baaba bakiwamba aamo nʼobubuga obukyeruguuliriirye, ni babbingamu aBamooli ababbaire babityamamu. ");
INSERT INTO gwr_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Awo aBaisirairi ni bacuuka ni bakwata enzira eniinaniina okulungama e Bbasani. Ogi okabaka wʼe Bbasani ni yetoolayo nʼamajeege gonagona okubalwanisirya Edereeyi. ");
INSERT INTO gwr_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Neye oMusengwa nʼakoba oMusa ati, “Tiwamutya, olwʼokubba mmuwaireyo iye nʼabʼamajeege bonabona, nʼekyalokye omu bwezyebwo. Omukole ekintu ekiwakolere oSikoni okabaka wʼaBamooli, eyafugiranga omu Kesyubboni.” ");
INSERT INTO gwr_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Awo aBaisirairi ni baita Ogi nʼabataane, nʼabʼamajeege bonabona, obutalekakuuwo kadi moiza, ni beetwalira ekyalokye. ");
INSERT INTO gwr_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Awo aBaisirairi ni batambula, ni baaba bakola enkambi omu kitantira kyʼe Mowaabbu, oku lubba ludi olwʼoMwiga oYoludaani ekiringiriire ekibuga oYeriko. ");
INSERT INTO gwr_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Atyanu wabbairewo okabaka wʼe Mowaabbu nga bamweta Bbalaki, eyabbaire omutaane wa Zipoli. OBbalaki nʼawulira byonabyona aBaisirairi ebibabbaire bakolere oku Bamooli. ");
INSERT INTO gwr_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Era okabaka nʼaBamowaabbu ni batya ino olwʼokubba aBaisirairi babbaire bangi ino. Era dala ensisi nʼekwata aBamowaabbu olwʼaBaisirairi. ");
INSERT INTO gwr_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Awo aBamowaabbu ni bakoba abeekubbemberi bʼaBamidiyaani bati, “Atyanu oguziima ogwo gwaba okumalawo byonabyona ebitweruguuliriirye, ooti nte akaavuula eisubi omu kigona.” Awo oBbalaki omutaane wa Zipoli, era eyabbaire okabaka wa Mowaabbu omu kiseera ekyo, ");
INSERT INTO gwr_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","nʼatuma abakwenda eeri oBbalamu omutaane wa Bbeyoli owʼe Pesoli, ekiri okumpi nʼoMwiga Ewufulaate, omu kyalo kyʼaBaamoni, okumukoba bati, “Waliwo abantu abazwire e Misiri, bakwalaamire oku kyalo kyaiswe kyonakyona, era bali nʼaanu okulirana nanze. ");
INSERT INTO gwr_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Kale atyanu, nkwegairiire, oize ondaamire abantu abo, olwʼokubba bankira amaani. Amo-so ni mpezya okubawangula, ni mbabbinga omu kyalo kinu. Ekyo kityo olwʼokubba mmaite nga iwe, omuntu ogwosabira enkabi, agisuna, era ogwolaama, ekiraami kimukwata.” ");
INSERT INTO gwr_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Awo abeekubbemberi bʼaBamowaabbu nʼabʼaBamidiyaani ni baaba eeri oBbalamu, nʼempiiya egyʼomusetulo. Owebatuukire e gyali, ni bamukobera ebyo oBbalaki ebiyabbaire abatumire. ");
INSERT INTO gwr_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","OBbalamu nʼabakoba ati, “Mugone aanu ekiire kinu. Eizo nabakobera oMusengwa ekiyaabba ampaire.” Kale abeekubbemberi bʼaBamowaabbu ni bagona e wa Bbalamu. ");
INSERT INTO gwr_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ekiire ekyo oKibbumba nʼaiza nʼabuulya oBbalamu ati, “Banaani abo abooli nabo?” ");
INSERT INTO gwr_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","OBbalamu nʼairamu oKibbumba ati, “Abantu abo okabaka oBbalaki owʼe Mowaabbu, era omutaane wa Zipoli, abatumire nʼobukwenda obuti, ");
INSERT INTO gwr_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Waliwo abantu abazwire e Misiri, bakwalaamire oku kyalo kyaiswe kyonakyona. Atyanu, nkwegairiire, oize ondaamire abantu abo, amo-so ni mpezya okubawangula, ni mbabbinga omu kyalo kinu.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Neye oKibbumba nʼakoba oBbalamu ati, “Tiwaaba nabo, era tiwagezya okulaama aBaisirairi, olwʼokubba aBaisirairi nabawaire enkabi.” ");
INSERT INTO gwr_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Awo eizo amakeezi, oBbalamu nʼakoba abakwenda ba Bbalaki ati, “Mukange omu kyalo kyanywe, olwʼokubba oMusengwa angaine okwaba na inywe.” ");
INSERT INTO gwr_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Awo abeekubbemberi bʼaBamowaabbu ni basetuka ni bakanga eeri oBbalaki, ni bamukoba bati, “OBbalamu againe okwiza.” ");
INSERT INTO gwr_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Tete oBbalaki nʼatuma abeekubbemberi abandi abangi era abʼekitiisya okukiraku badi abasookere. ");
INSERT INTO gwr_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ni baaba eeri oBbalamu, ni bamukoba bati, “OBbalaki omutaane wa Zipoli akobere ati, ‘Nkwegairiire, tiwaabbaawo ekintu kyonakyona ekikugaana okwiza e gyendi, ");
INSERT INTO gwr_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","olwʼokubba njaba kukusasula nakusani ino, era nabuli ekiwankoba nakikola. Kale nkwegairiire, oize ondaamire abantu banu.’ ” ");
INSERT INTO gwr_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Neye oBbalamu nʼabairamu ati, “OBbalaki nʼoweyaabba yampa olubirirwe nga lwizwire efeeza nʼezaabbu, timpezya okukola ekintu kyonakyona ooba kinene ooba kityai nga tikiikyo oMusengwa iye oKibbumba wange ekiyandagira. ");
INSERT INTO gwr_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Kale atyanu nywena mugone aanu ekiire kinu ngʼabanaanywe owebakolere, nsooke mbone ekindi oMusengwa ekiyankoba.” ");
INSERT INTO gwr_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Ekiire ekyo oKibbumba nʼaiza eeri oBbalamu, nʼamukoba ati, “Abantu abo ngʼowebaizire okukusyoma, oyabe nabo. Neye wakola kiikyo kyonkani ekinakulagira.” ");
INSERT INTO gwr_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Eizo amakeezi oBbalamu oweyalamukire, nʼategeka ompundawe, nʼayaba nʼabakungu bʼaBamowaabbu. ");
INSERT INTO gwr_vpl VALUES ("NU