﻿USE sofia;
DROP TABLE IF EXISTS sofia.gwiNT_vpl;
CREATE TABLE gwiNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gwiNT_vpl WRITE;
INSERT INTO gwiNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jii nąįį t'ee, Jesus Christ goots'an deedhaa, Jesus Christ, t'ee yeenii King David ts'an deedhaa, ts'ą' King David chan Abraham ts'an deedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Jii nąįį t'ee Abraham ts'an digeedhaa, ts'ą' izhit gwats'an King David gwats'ą' datthak digeedhaa nąįį t'inchy'aa: Abraham, Isaac, Jacob, Judah ąįįts'ą' vachaa nąįį haa, ąįįtł'ęę Perez ts'ą' Zerah haa (goohan ąįįt'ee, Tamar), Hezron, Ram, Amminadab, Nahshon, Salmon, Boaz, (Boaz ąįįt'ee vahan Rahab), Obed (vahan Ruth), Jesse ąįįt'ee King David viti' nilii. Jii nąįį t'ee King David ts'an digeedhaa, Israel gwich'in nąįį Israel nahkat gwats'an tr'agooriinlii, ts'ą' Babylon kwaiik'it gwachoo gwats'ą' goorahaadlii dąį', t'agwarahnyąą: King David, Solomon. (Solomon, vahan ąįįt'ee Uriah va'at inli' chy'aa t'agahnyąą), ");
INSERT INTO gwiNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Rehoboam, Abijah, Asa, Jehosaphat, Jehoram, Uzziah, Jotham, Ahaz, Hezekiah, Manasseh, Amon, Josiah, ąįįts'ą' Jehoiachin ąįįts'ą' vachaa nąįį haa. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Israel gwich'in nąįį Babylon gwats'an daganahkat gwits'ee neegahoojil gwats'an Jesus vigweheelyaa gwats'ą' datthak digeedhaa nąįį t'ee jii nąįį t'arahnyąą: Jehoiachin, Shealtiel, Zerubbabel, Abiud, Eliakim, Azor, Zadok, Achim, Eliud, Eleazar, Matthan, Jacob, ts'ą' Joseph, jii Joseph, ąįįt'ee Mary oonjik, ts'ą' t'ee Mary, Jesus vahan nilii. Jesus t'ee Christ ąįį oozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ąįįtł'ęę t'ee Abraham gwats'an King David gwats'ą' diiti' 14 nihzhyaaneedijii nąįį goodlit, ąįįts'ą' King David gwats'an, nijin Babylon kwaiik'it gwachoo gwats'ą' Israel gwich'in nąįį gahaadlii dąį' gwats'an chan diiti' 14 nihzhyaaneedijii nąįį goodlit, izhit gwats'an chan Messiah vigweheelyaa gwats'ą' chan diiti' 14 nihzhyaaneedijii nąįį goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jii t'ee nats'ahts'ą' Jesus Christ vagoodlit dąį' deegwiizhik. Vahan Mary ąįįts'ą' Joseph haa nihłarooheendal nihłagaiinyą', Mary tth'aii hee gaa dinjii haa dhichįį kwaa gwiizhik Ch'anky'aa Shroodiinyąą k'iighai' tr'iinin hee'yaa goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph, dinjii khit gwinzii t'ee'ya' nilii, ąįįts'ą' dinjii nąįį tee Mary ts'an oozhii ąhtsii gitr'ii'ee, ts'ą' gweentak hee yuuheendal kwaa gwahałtsyaa yiindhan. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tth'aii hee jyąhts'ą' gininjich'ahthat, gwiizhik naachįį ts'ą' Vit'eegwijyąhchy'aa vizheekat gwich'in gineiinlyaa zhit yats'ą' igwiilkįį, ts'ą' jyaa yahnyąą, “Joseph, King David ts'an dindhaa ts'ą' Mary oohiindal geenjit noonjat shrǫ'! Mary Ch'anky'aa Shroodiinyąą k'iighai' tr'iinin hee'yaa goodlit t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gwidinji' hee'yaa t'inchy'aa, ąįįts'ą' Jesus voozhri' hahtsyaa ts'ą' dinjii vats'an nilii nąįį neehahshii eenjit, ts'ą' gootr'agwaanduu gwats'an neegoohahshii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","K'eegwaadhat, ąįį yeenii Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii Isaiah k'iighai' jyaa nyąą, ąįįt'ee juk łi'deegwidlii haa gwik'it goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Nich'it, ch'ihłok gaa dinjii haa dhichįį kwaa gaa vizhit tr'iinin gweheelyaa ts'ą' tsyaa tsal heelyaa ts'ą' Immanuel varahaanjyaa t'inchy'aa gwinyąą.” (Immanuel it'ee “Vit'eegwijyąhchy'aa diihaa nilii” gwinyąą, t'igwinyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph khakee'ąįį ąįįtł'ęę Mary ts'ą' haazhii ts'ą' nihłagoonjik. Vit'eegwijyąhchy'aa vizheekat gwich'in deeyahnyąą gwik'it t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Gaa nihk'it Mary haa dhichįį kwaa, dahthee tr'iinin gwidinji' gweheelyaa gwats'ą' datthak jyaa dinchy'a', ąįįtł'ęę Joseph, tsyaa tsal vagoodlit dąį' Jesus yuuzhri' iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus, Bethlehem kwaiik'it, aiizhit gwizhit vagoodlit, ąįįt'ee Judea nahkat gwizhit goo'aii. King Herod, izhit dąį' zhat nahkat gwats'ą' k'eedeegwaadhat nilii gwiizhit, dinjii goonzhįį nilii nąįį East gwats'an Jerusalem kwaiik'it gwachoo k'eegiidal. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Są' zhat dha'aii ąįį geenjit ch'agoahkat, “Ąįį tr'iinin tsal, Jews nąįį eenjit King heelyaa goo'aii, vagoodlit adaajii? Nijin East gwats'an khaneech'ii'ak dąį' va-są' tr'ąąh'in ts'ą' vats'a' khadigireheejyaa geenjit dzaa gwats'ą' tr'ahaajil t'igwii'in.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nijin King Herod gwiitth'ak dąį' łyaa vatthąį' iizųų goodlit, Jerusalem gwizhit dinjii nąįį datthak chan gootthąį' iizųų goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod, giinkhih kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį datthak khaihłan niinlii ts'ą' goovahkat, “Nijin gwa'an Messiah vigweheelyaa goo'aii?” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Judea nahkat gwizhit kwaiik'it Bethlehem,” giiyahnyąą. Jii t'ee deenaadąį' gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii dagwaantł'oo t'igwinyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Kwaiik'it Bethlehem, ąįį Judah nahkat gwizhit goo'aii, Judah nahkat gwizhit kwaiik'it gwachoo gwintsii veegoo'aii inlii t'oonchy'aa. Nats'an dinjii khaihkwaii nilii tr'iheehaa ts'ą' shigii Israel gwich'in nąįį ts'ą' k'eedeegwahaadhat t'inchy'aa.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ąįįtł'ęę Herod, dinjii goonzhįį East gwats'an adaa nąįį aanaii ahnyąą ts'ą' gweentak hee goovahkat, nijin dąį' zhit są' gaah'ya' geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ąįįtł'ęę t'ee Bethlehem gwats'ą', gooveehił'e' ts'ą' t'agoovahnyąą, “Bethlehem gwats'ą' hohjyaa ts'ą' zhat tr'iinin tsal gwinzii vankǫǫhtii, ąįįtł'ęę vagoh'ąįį ji' shaaneegoondak, ąįįts'ą' shįį chan vats'a' hihshyaa ts'ą' vats'a' khadigihihjyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ąįįts'ą' t'ee gahaajil, geedaa gwiizhit są' gwehkįį East gaah'in chy'ah chan hee khaneegaa'in, nijin są' gaah'in dąį' łahchy'aa goovaa shroonchy'aa, ts'ą' nijin tr'iinin tsal t'inchy'aa łąą są' dha'aii naanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Zheh nihdeegiinjil ts'ą' nijin Mary ts'ą' tr'iinin tsal haa gaah'in, dąį' k'iizhak nikiigwigwiintthaii ts'ą' khadigigiinjii. K'eiich'i' giiyeenjit khaiinlii, gold, (gwanzhįh tr'ahk'an dąį' gwinzii vagwaatsan) frankincense, ąįįts'ą' gwanzhįh chų' gwinzii vagwaatsan myrrh haa datthak giiyantł'eiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ch'izhii tąįį goo'aii gwats'an, daganahkat gwits'eegahoojil, Vit'eegwijyąhchy'aa gineegiinlyaa k'iighai', Herod vits'eehohjyaa shrǫ' goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Daganahkat gwits'ee gahoojil ąįįtł'ęę Vit'eegwijyąhchy'aa vizheekat gwich'in, Joseph gineiinlyaa zhit vigwiilkįį ts'ą' jyaa yahnyąą, “Herod, it'ee zhit tr'iinin tsal keegwahąąh'yaa t'inchy'aa, yęhdaa tr'igwihee'yaa geenjit, juk zhat khakeena'ąįį ts'ą' nigii, na'at haa datthak Egypt gwats'ą' hohjyaa, dahthee oonaa neekhwajyaa, nakhwahaihjyaa gwats'ą' datthak zhat dook'įį,” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph khakee'ąįį ts'ą' tr'iinin tsal, ts'ą' vahan haa zhat khaa, tǫǫ goo'aii gwiizhit, Egypt gwats'ą' goovahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ąįįts'ą' Egypt gwigwich'įį, dahthee Herod niheedhaa gwats'ą' datthak. Jii t'ee K'eegwaadhat deenyąą ąįį yeenii Vit'eegwijyąhchy'aa Eenjit Ginkhii geegwaandak gwik'it łi'deegwidlii goodlit geenjit jyaa diinyą', “Shigii, Egypt gwats'an tr'ineeheedyaa geenjit aanaii vaihnyąą.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nijin Herod zhit dinjii East gwats'an geedaa nąįį giininjigweelzhii łee gwiky'aanjik dąį' łahchy'aa vik'įį goodlit. Bethlehem gwizhit ts'ą' zhit kwaiik'it geelin goodlii zhit datthak tr'iinin tsyaa tsal 2 years old gwats'ą' zhat nilii datthak ęhdaa tr'igwigwehee'aa geenjit jyaa nyąą. Dinjii goonzhįį nąįį 2 years gwahaadhat dąį' jii są' gaah'ya' giiyaagwildak geh'an t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jyąhts'ą' geh'an Vit'eegwijyąhchy'aa Eenjit Ginkhii Jeremiah deenyąą chy'ah gwik'it łi'deegwidlii goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramah kwaiik'it gwizhit k'eegwiichy'aa t'igwii'in gwigwiitth'ak, gwint'aii tr'igwigwidii ts'ą' tr'itree gwigwiitth'ak, Rachel digii nąįį eenjit gwintł'oo itree, ts'ą' khanarahaayu' geenjit gaa gwiizųų, vigii nąįį ęhdaa tr'igwigwiin'ąįį geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","King Herod niindhat, ąįįtł'ęę K'eegwaadhat vizheekat gwich'in, Joseph giineiinlyaa zhit ts'ą' niinzhii ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","jyaa yahnyąą, “Khakeena'ąįį ts'ą' nanahkat Israel, gwits'eehindii, zhit juu tr'iinin ęhdaa tr'igwihee'aa gwik'eegwandaii chy'aa niindhat t'oonchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ąįįts'ą' t'ee Joseph khakee'ąįį, ts'ą' zhit tr'iinin ts'ą' vahan haa Israel nahkat gwits'ee goovahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dinjii Archeleus, diti' Herod deek'it, Judea nahkat gwats'ą' k'eedeegwaadhat dhidlit, Joseph giky'aanjik dąį' zhat gwits'ee heedyaa geenjit naajat, ąįįts'ą' gineiinlyaa zhit deehee'yaa varahnyąą, ąįį gwik'it t'iizhik, ąįįts'ą' Galilee nahkat ąįį gwats'ą' haazhii, ");
INSERT INTO gwiNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ts'ą' kwaiik'it Nazareth gwizhit gweheechy'aa eenjit gwinzii gwiłtsąįį. Ąįį geh'an zhit Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį deeginyąą gwik'it łi'deegwidlii goodlit. Nazareth gwats'an t'inchy'aa geh'an, “Nazarene oohaazhyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Izhit gwiizhit, John chųų gwats'an ąhtsii zhat Judea nahkat nangwinjir gwa'an jyaa nyąą ts'ą' geech'ǫąąhtan, ");
INSERT INTO gwiNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nakhwatr'agwaanduu gwats'an łihts'eedǫǫ'ee, Zheekat Gweegwinii'ee gwats'ą' nahgwan t'oonchy'aa.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaiah, Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ąįį John eeginkhii dąį' jyaa nyąą, “Nangwinjir gwa'an tr'azhral gwigwiitth'ak ts'ą' jyaa digwinyąą; ‘K'eegwaadhat vits'ii tąįį gwinjik shrigwinlii ts'ą' k'iindaa tąįį k'igwąą'ee heekhaa veenjit nagwiintthaii!’” ");
INSERT INTO gwiNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John, nin Camel, ąįį vaghai' haa gwach'aa iłtsąįį naazhii, ts'ą' ch'adhah haa tthah iłtsąįį dazhrak tł'an giłchaa, ąįįts'ą' chan ch'ahahsak ts'ą' ch'ineendzit soongąįį kwaii shih a'ii, ąįį kwaii a'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jordan han gwinjik gwa'an, ts'ą' Judea nahkat datthak ts'ą' Jerusalem kwaiik'it gwachoo gwizhit gwats'an dinjii lęįį nąįį John giheetth'ak eenjit giits'ą' haajil. Diitr'agwaanduu gwanlii ginyąą ts'ą' t'ee Jordan han gwinjik gwizhit chųų goots'an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chan tr'agwaanduu tr'ineegwahał'yaa kwaa ginyąą ts'ą' Jordan han gwinjik gwizhit goots'an chųų ąhtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nijin John, Pharisee ts'ą' Sadducee lęįį nąįį chųų goots'an tr'ahahtsyaa geenjit giits'ą' adaa gwąąh'in dąį' t'agovahnyąą, “Gyųų ts'an deedhaa nąįį! It'ee niighit kwaa Vit'eegwijyąhchy'aa vats'an khaiinjich'akhwaghit gwideetaa hohdaa nohthan? ");
INSERT INTO gwiNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nats'ąą nakhwatr'agwaanduu ts'an łihts'eedǫǫ'ee geenjit gogoohch'in! ");
INSERT INTO gwiNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","‘Yeenii diilak Abraham ts'an direedhaa, geenjit duuyeh khaiinjich'iriighit!’ nihłohnyą' shrǫ'! Nakhwaagwahaldak, Vit'eegwijyąhchy'aa jii kii kwaii ji' gaa Abraham ts'an deedhaa hahtsyaa t'oonchy'aa gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jidii ts'iivii vakat jak gwinzii nahshii kwaa ąįį vadachan daa'aii haa tr'iheekyaa goo'aii ts'ą' heek'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Shįį ąįį nakhwatr'agwaanduu ts'an łihts'eedahoo'ee geenjit chųų nakhwats'an ałtsii t'ishi'in, gaa juu shatąįį ahaa, ąįį Ch'anky'aa Shroodiinyąą ts'ą' kǫ' haa chųų nakhwats'an hahtsyaa t'oonchy'aa, łyaa shandaa veegoo'aii t'inchy'aa, vakwaiitryaa k'eehalzhik geenjit gaa sheegoo'aii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Juk t'ee tł'ooli' vaa ineech'ariitthak khaltin ąįį haa wheat nizįį kwaii gwitee tr'iheelyaa ts'ą' dadrah zhit nihdeeheelyaa geenjit gaa, zhit tł'ooli' wheat iizųų kwaii kǫ' nikyaa kwaa zhit yiheelyaa ts'ą' khit geenjit heek'an.” ");
INSERT INTO gwiNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aiizhit dąį' Jesus, Galilee nahkat gwats'an, Jordan han gwinjik k'idik, John chųų yats'an hahtsyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gaa John ąįį ch'ijuk t'igweheenjyaa geenjit jyaa nyąą, “Nan, ąįį chųų shats'an hahtsyaa goo'aii gaa, shįį ąįį chųų nats'an hałtsyaa geenjit shats'ą' hoiinzhii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gaa Jesus ąįį jyaa yahnyąą, “Aahą', gaa juk ąįį deeni'in naihnyąą gwik'it t'ini'in, ąįį gwik'iighai' jyaa dini'in t'ee jidii Vit'eegwijyąhchy'aa doo'ya' diinoonyąą ąįį gwik'it t'igwehee'yaa.” yahnyąą. Ąįįtł'ęę John, Jesus deeni'in yahnyąą gwik'it t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ts'ą' nijin Jesus chųų vats'an dhidlit tł'ęę chųų zhit khaneezhii, gwagwahkhan zheekat nihky'aa t'igwiizhik, ts'ą' Ch'anky'aa Shroodiinyąą, chiitsal dove k'it t'inchy'aa vakat needaanąįį yąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ąįįtł'ęę gwideezhuh, zheekat gwats'an jyaa nyąą, “Jii t'ee Shidinji' t'inchy'aa, łi'haa veet'iihthan ts'ą' łyaa shoo shahtsii t'inchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ch'anky'aa Shroodiinyąą ąįį Jesus nangwinjir gwa'an gwats'ą' hiłchįį, Ch'anky'aa Tr'aanduu, Jesus tr'agwaanduu t'ii'in hahtsyaa shrǫǫ ji' geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Drin 40 days ts'ą' tǫǫ haa ch'a'aa kwaa ts'ą' zhat indi', nijin ndaanaahjik dąį' vizhit gwiłts'ik. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gwiizhit Ch'anky'aa Tr'aanduu yats'ą' tr'iinzhii ts'ą' t'iiyahnyąą, “Vit'eegwijyąhchy'aa vidinji' inlii ji' jii kii kwaii łųhchy'aa ąhtsii.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Gaa Jesus ąįį t'iiyahnyąą, “Dęhtły'aa Choo kat gwadanakhwatł'oo, ‘Duuyeh dinjii łųhchy'aa k'iighai' gwizhrįh gwandaii gwinyąą t'oonchy'aa.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ąįįtł'ęę Ch'anky'aa Tr'aanduu, Jerusalem kwaiik'it gwachoo shroodiinyąą gwizhit Kharigidiinjii Zhee Gwachoo gwikiit'ik Jesus nąąhchįį ");
INSERT INTO gwiNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ts'ą' t'iiyahnyąą. “Vit'eegwijyąhchy'aa Vidinji' inlii ji' dzaa k'iizhak neehantłit. Dęhtły'aa Choo kat gwadanakhwatł'oo, ‘Vit'eegwijyąhchy'aa ąįį vats'an zheekat gwich'in nąįį nats'ą' hah'aa ts'ą' nik'eegahąąhtyaa. Daganli' haa ndak nagooheetą' ts'ą' duuyeh gaa kii kat nakwai' ts'iighit gwinyąą.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus t'iiyahnyąą “Dęhtły'aa Choo zhit jyaa deegwinyąą, ‘K'eegwaadhat Nivit'eegwijyąhchy'aa zhyaa shroondaii tsinteerookaii shrǫ'!’” gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ąįįtł'ęę Ch'anky'aa Tr'aanduu ddhah kiit'ik Jesus nąąhchįį ts'ą' nahkat datthak gwinzii giiyiichy'a' yats'ą' gwizhrįh nigwiinlii ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","t'iiyahnyąą, “Jii kwaii datthak nantł'eegwihihłyaa, shats'ą' nikiigwiintthaii ts'ą' shats'ą' khadigiinjii ji'!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ąįįtł'ęę Jesus t'iiyahnyąą, “Satan, shihłeehiindii! Dęhtły'aa Choh kat gwadanakhwatł'oo, ‘K'eegwaadhat Nivit'eegwijyąhchy'aa zhrįh ts'ą' khadigireheejyaa ts'ą' adan zhrįh vik'eegwarahahthat gwizhrįh goo'aii t'oonchy'aa!’” ");
INSERT INTO gwiNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ąįįtł'ęę Ch'anky'aa Tr'aanduu, Jesus ihłeehoozhii, ts'ą' zheekat gwich'in nąįį giits'ą' haajil ts'ą' giik'aahtii. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus, nijin John zhee gwaazhrąįį naraahchįį gwinyąą gwiitth'ak dąį' Galilee nahkat gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jesus, Nazareth gihłeehoozhii ts'ą' Zebulun nahkat ts'ą' Naphtali nahkat Capernaum kwaiik'it Galilee van vee goo'aii gwats'ą' haazhii ts'ą' ch'ihłee zhat indi'. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jii t'ee jyaa t'igwiizhik ąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii Isaiah deenyąą ąįį zhit łi'deegwidlii gweheelyaa geenjit, ");
INSERT INTO gwiNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Galilee van gwats'ą' tąįį gwiin'ee gwinjik t'ee Zebulun nahkat ts'ą' Naphtali nahkat haa goodlii, Jordan han ndųhts'ąįį ts'ą' Galilee nahkat kwaii t'ee Gentiles nąįį goonahkat t'oonchy'aa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Zhit juu dinjii nąįį tǫǫ gwizhit gwigwich'įį nąįį, ch'eegwąhndit gwachoh gwagwahąąh'yaa t'oonchy'aa, zhit juu iłchįį gwanahkat gwich'įį nąįį, ch'eegwąhndit gook'aa haadrii gweheelyaa gwinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aiizhit gwats'an it'ee Jesus Gwandak Nizįį eegwaandak, ts'ą' jyaa nyąą, “Nakhwatr'agwaanduu ts'an łihts'eedǫǫ'ee, Zheekat Gweegwinii'ee gwats'ą' nahgwan t'oonchy'aa!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ąįįts'ą' Jesus, ąįį Galilee vanvee gwa'an neehidik akhai' ch'oondee ts'ą' ch'achaa haa łuk keegii'in łee neeł'in. Łuk keegii'in giinlii, ch'ihłak ąįį Simon (gaa Peter giiyahnyąą) ąįįts'ą' vachaa chan Andrew. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus jyaa gavahnyąą, “Aanaii, shaa hoh'oo, nats'ahts'ą' dinjii nąįį teegahohdal ąįį geenakhwahaałchyaa łuk teegǫhjii gwik'it.” ");
INSERT INTO gwiNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jyaa nyąą googwahkhan digichihvyaa akhagoonyąą ts'ą' giiyaahaa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ąįįtł'ęę k'ii'an teeghaih tth'aii hee ahaa, akhai' James ts'ą' John ts'ą' gooti' haa neeł'in. Digiti' Zebedee haa tr'ihchoo zhit giilk'ii ts'ą' digichihvyaa kwaii shrineegilii gwiizhit Jesus aanaii, gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Izhit gwagwahkhan digitr'ihchoo ts'ą' digiti' haa iłeegahaa'oo ts'ą' giiyaahaa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus, Galilee nahkat gwizhit gwa'an datthak k'eekhwazhii ts'ą' Jews tr'igiinkhii zheh kwaii datthak gwizhit geech'ǫąąhtan, ts'ą' Gwandak Nizįį haa Zheekat Veegwinii'ee eegwaandak ts'ą' juu ts'ik nihłehjuk daazhyaa haa iłts'ik nąįį datthak shrininlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ąįįts'ą' Syria nahkat datthak giiyeegwiitth'ak ts'ą' juu ts'ik nihłehjuk daazhyaa di'įį nąįį datthak giits'ą' haadlii, juu vanah gwint'aii gwiłts'ik ts'ą' juu vizhit ch'anky'aa iizųų haa t'ihee'yaa kwaa gwik'it t'ii'in nąįį ts'ą' juu naandoo nąįį, ts'ą' neehidik kwaa nąįį datthak giits'ą' haadlii ts'ą' goots'ą' tr'iinjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ts'ą' Jordan han ndųhts'ąįį geh'ok gwa'an gwats'an, ts'ą' Judea nahkat, ts'ą' Jerusalem kwaiik'it gwachoo, ts'ą' Decapolis ts'ą' Galilee nahkat kwaii datthak gwats'an dinjii lęįį nąįį Jesus tąįį neegihiidal. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ch'ihłan drin nijin Jesus, dinjii lęįį nąįį yeelin łeeljil gwah'in dąį', taih kat hahdhizhii ts'ą' naadii. Gwiizhit vitsyaa nąįį yeelin niinjil, ");
INSERT INTO gwiNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ts'ą' t'ee geegooviheełchya'. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Zhit juu nakhwatee Vit'eegwijyąhchy'aa t'aahchy'aa ts'ą' neeshreegaahchy'aa gaagiindaii nąįį shoo giinlii, Zheekat Gweegwinii'ee t'ee goots'an gwanlii t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Zhit juu nakhwatee tr'igwidii nąįį shoo gooli', Vit'eegwijyąhchy'aa goovaa gwinzii t'inchy'aa geh'an! ");
INSERT INTO gwiNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Zhit juu nakhwatee datthak khazhak t'iinchy'aa nąįį shoo gooli', Vit'eegwijyąhchy'aa jidii nankat datthak goovintł'eehee'aa gavahnyąą ąįį goohoondal t'igiinchy'aa geh'an! ");
INSERT INTO gwiNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Zhit juu nakhwatee łyaa Vit'eegwijyąhchy'aa doo'ya' yuunyąą ąįį gwik'it t'ii'in nąįį shoo gooli', Vit'eegwijyąhchy'aa ts'an jidii giindhan datthak gihee'yaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Vit'eegwijyąhchy'aa neeshraahchy'aa gavahoonjyaa geh'an, zhit nakhwatee juu neeshraahchy'aa niindhan nąįį shoo gooli'! ");
INSERT INTO gwiNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Zhit juu nakhwatee vidrii zhit Vit'eegwijyąhchy'aa deenyąą ąįį gwik'it gwizhrįh t'ii'in nąįį shoo gooli', Vit'eegwijyąhchy'aa gahąąh'yaa t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Zhit juu nakhwatee tsinehdan geenjit tr'agwah'in nąįį shoo gooli', Vit'eegwijyąhchy'aa shigii gavaahaanjyaa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Zhit juu nakhwatee Vit'eegwijyąhchy'aa deenyąą gwik'it t'ii'in geenjit gwiizųų khaiinch'igiighit nąįį shoo gooli', Zheekat Gweegwinii'ee goots'an nilii t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Shatąįį ohdaa geh'an, juu nakhwatee gwiizųų vats'a' girinkhii ts'ą' khaiinjich'iighit ts'ą' oots'it haa tr'agwaanduu t'iizhit varahnyąą nąįį shoo gooli'. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jyąhts'ą' t'ee yeenii Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį khaiinjich'ahoodhat. Shoo ǫhłįį ts'ą' nakhwaashroonchy'aa, zheekat nakhweenjit gwintsii gwinzii goo'aii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Dzaa nankat dinjii nąįį datthak eenjit lisil k'it t'ohchy'aa ts'ą' nakhwat'injigaahchy'aa t'oonchy'aa. Ąįįts'ą' lisil vagwaandaii kwaa dhidlit ji' duuyeh chan hee vagwaandaii neerahtsii t'inchy'aa ts'ą' duuyeh chan hee vit'ineegwaachy'aa, ts'ą' oo'an tr'ahahtł'aa gwizhrįh, ts'ą' dinjii nąįį gwintł'oo giikat k'eeheedal. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nakhwant'ee jii nankat datthak geenjit aadrii ǫhłįį k'it t'ohchy'aa t'oonchy'aa, kwaiik'it gwachoo taih kat gwiriłtsąįį ji' duuyeh geegoh'ik goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Dinjii nąįį duuyeh khwaiidaak'a' aadrii neegahdrii ts'ą' tyah ghoo choh t'eh nigiiya'ąįį, gaa zheh gwizhit datthak gach'ahaadrii geenjit aadrii daak'a' vakat doo'aii kat nigiihee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ąįį gwik'it adrii ch'aadrii k'it t'ohchy'aa, dinjii nąįį nakhwagąąh'in dąį' ch'ohdit k'it t'akhohchy'aa, ts'ą' nijin Vit'eegwijyąhchy'aa vigwitr'it gwinzii t'akhwa'in nakhwagąąh'in dąį' Zheekat Nakhwati' deegahah'aa t'igiinchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moses va-law ąįįts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii nąįį jidii eech'agwahtan ąįį oo'an gwihihłyaa eenjit dzaa gwats'ą' hoiizhii nǫhkhya' shrǫ'. Jii kwaii eech'agwahchya' ąįį łi'deegwidlii gwahałtsyaa geenjit dzaa gwats'ą' hoiizhii t'ishi'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jidii datthak łi'haa nakhwaagwaldak, deegwąhkhyuk jii nan ts'ą' zheekat haa goodlii, gwiizhit duuyeh zhit Law vili' tsal gaa an ilii t'inchy'aa. Jidii t'igweheenjyaa goo'aii datthak gwik'it t'igwiizhit ąįįtł'ęę t'ohju' hee an heelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ąįįts'ą' t'ee juu Law vili' tsal zhrįh gaa k'eegwahthat kwaa ts'ą' ch'izhii dinjii nąįį chan law k'eegwagwahthat kwaa ąhtsii ji', Zheekat Gweegwinii'ee zhit ch'andaa gwiintsal gwizhrįh veegwehee'aa t'inchy'aa. Gaa juu Law deenyąą gwik'it t'ii'in ts'ą' ch'izhii nąįį chan law k'eegwahthat ąhtsii ji' Zheekat Gweegwinii'ee gwizhit ch'andaa gwiintsii vidivee gwehee'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","It'ee łyaa nakhwaagwaldak t'ihnyąą, juu Law eech'ǫąąhtan nąįį, ts'ą' juu Pharisee nąįį k'it Vit'eegwijyąhchy'aa deeyahnyąą gwik'it t'ii'in nąįį andaa vik'eegohthat ji', gwizhrįh Zheekat Gweegwinii'ee nihdeehohdaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Vit'eegwijyąhchy'aa yeenii nakhwalak nąįį jyaa ahnyąą gohtth'ak, ‘Dinjii ęhdaa tr'agǫh'aa shrǫ' jyaa dakhwazhik ji' t'ee ch'aroahkat zheh nihdeenakhwarahahchyaa t'oonchy'aa.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gaa juk nakhwaagwahaldak, juu dachaa ts'ą' gwik'injigwiighit zhit vik'įį gwanlii ji' ch'aroahkat zheh gwizhit nihdeerahahchyaa. Nachaa zhyaa ‘Geenjit gwakwaa dinjii inlii!’ vaiinyąą ji', Jews gwakhaihkwaii nąįį ts'ą' nihdeenarahahchyaa, ąįįts'ą' chan, nachaa gwik'injigwiighit zhit dinjii ‘Vit'eegwijyąhchy'aa haandaii kwaa ts'ą' k'ii'an tr'agwah'in!’ vaiinyąą ji' khink'an ts'ą' hell gwats'ą' hinkhaa gwahtsii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ąįįts'ą' Vit'eegwijyąhchy'aa ataiinjii tr'ahtsii deek'it gwakat shih vantłeehahtsit gwiizhik nachaa gwik'injiighit gwiizųų vats'a' t'inizhik ganąnjik ji', ");
INSERT INTO gwiNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ąįį shih zhat ataiinjii tr'ahtsii deek'it geeghaih akhoohoinjyaa ts'ą' nachaa zhat gwagwahkhan vats'a' hinkhaa ts'ą' vaagwinzii neegwahahtsyaa, ąįįtł'ęę gǫhju' hee zhat gwits'eehindyaa ts'ą' Vit'eegwijyąhchy'aa vats'a' shih vantł'eehahchaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Juu dinjii ch'ihłak shats'ą' gwiizųų t'inizhik nahnyąą (lawsuit) ji', ch'aroahkat zheh gwats'ą' nahahchyaa gwehkįį vaa gwinzii neegwąhtsii. Jyaa dinizhit kwaa ji', zhit juu noohaahkat ts'ą' nahahchyaa, ąįįtł'ęę juu gwadąįį gwak'ąąhtii (Police) nąįį antł'eenagahahchyaa ts'ą' zheh gwaazhrąįį nanagahahchyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Łyaa naagwaldak, ąįįts'ą' aiizhit gwizhit heendyaa t'oonchy'aa, dahthee datthak laraa neegohoiinkwat gwats'ą' datthak zhat hiindyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Vit'eegwijyąhchy'aa yeenii nakhwalak nąįį jyaa daiinyą' gohtth'ak? ‘Nakąį' akwat na'at nilii kwaa haa oonchį' shrǫ'!’” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gaa juk nakhwaagwaldak, juu nakhwatee dinjii, tr'injaa nah'in ts'ą' vaa oihchį' yuunyąą ji' gaa didrii zhit adultery t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ąįįts'ą' t'ee nishriits'ąįį, nindee tr'agwaanduu t'ini'yaa nihiłtsąįį ji' khaiin'ąįį, ts'ą' oo'an haakhii jyąhts'ą' gwik'iighai' nindee ch'ihłak kwaa ji' ts'ąįį nidiveegweheezyaa t'oonchy'aa. Nananh gwa'an natthąį' lat kwaa, ji' gaa duuyeh natthąį' datthak hell gwizhit nihdeerahchįį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nishriits'ąįį, nanli' tr'agwaanduu t'ini'yaa nihiłtsąįį ji' vik'eech'iint'ii, ts'ą' oo'an haakhii jyąhts'ą' gwik'iighai' nanli' ch'ihłak kwaa ji' ts'ąįį nidiveegweheezyaa t'oonchy'aa. Nananh gwa'an natthąį' lat kwaa, ji' gaa duuyeh natthąį' datthak hell gwizhit nihdeerahchįį t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ąįįts'ą' chan hee Vit'eegwijyąhchy'aa yeenii nakhwalak nąįį jyaa dahnyąą gohtth'ak? ‘Dinjii da'at akhoonyąą ji' gwideheentł'oo ts'ą' da'at antł'eeyahahchal gwizhrįh goo'aii.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gaa juk nakhwaagwaldak, zhit juu dinjii da'at akhoonyąą ji' va'at adultery t'ii'in kwaa gaa nihk'it akhoonyąą, ąįįt'ee da'at adultery t'ii'in ąhtsii, ąįįts'ą' va'at chan hee neeroonjik ji' t'ee, ąįį dinjii neeyuunjik t'ee adultery t'ii'in t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Vit'eegwijyąhchy'aa yeenii nakhwalak nąįį dahnyąą dohtth'ak, ‘Łahchy'aa deegwinyąą ts'ą' deegwehee'yaa gwinyąą gwik'it t'igwehee'yaa gwizhrįh. K'eegwaadhat vats'a' vow’ dhąhtsąįį łahchy'aa gwik'it t'ini'yaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Gaa juk zhat nakhwaagwaldak, nijin jyaa shi'yaa dohnyąą dąį' vows t'oohchy'a' shrǫ', zheekat geh'an jyaa t'ishi'yaa ąįį łyaa gwik'it t'ishi'yaa dohnyą' shrǫ'! Aiizhit Vit'eegwijyąhchy'aa k'eedeegwaadhat ts'ą' yakat doodii deek'it goo'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jii nankat geenjit chan jyaa t'ishi'yaa dohnyą' shrǫ', ji' nankat gwakat t'ee Vit'eegwijyąhchy'aa dakwai' diłdlii t'oonchy'aa. Vit'eegwijyąhchy'aa, k'eedeegwaadhat jiintsii vakwaiik'it t'oonchy'aa, Jerusalem kwaiik'it gwachoo geh'an jyaa t'ishi'yaa dohnyą' shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nikiitth'an haa geenjit gaa jyaa t'ishi'yaa dohnyą' shrǫ', duuyeh gaa nikiighai' azhrąįį akwat daagąįį ąhtsii gwizhit jyaa dihiinjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jii zhrįh gwik'it t'ohnyąą, ‘Aahą'’ akwat ‘Nakwaa’ geeghaih, k'eegwiichy'aa t'ahohjyaa ji' ąįįt'ee Tr'aanduu ts'an t'ahohjyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Vit'eegwijyąhchy'aa yeenii nakhwalak nąįį dahnyąą dohtth'ak? ‘Dinjii ch'ihłee ch'izhii dinjii andee akwat yagho' iinjik ji' ąįį dinjii dandee akwat dagho' haa iinjii ji' heezyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gaa juk nakhwaagwaldak, juu nakhwats'ą' gwiizųų t'ii'in ji' gwit'ii neegohtsyaa shrǫ'! Dinjii ch'ihłak nishriits'ąįį ninin nak'ah naat'an ji' natł'ohts'ąįį chan ninin nak'ah neeniheent'an ąhtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ąįįts'ą' zhit dinjii ch'ihłak, zhak khii ni'ik nits'į' ooheendal geenjit Ch'aroahkat Zheh nihdeenąąhchįį ji' zhak khii ni'ik vantł'ąhtsuu ts'ą' nach'ada'ik chan vantł'ąhtsuu. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Zhit juu Roman niveet'ah'in nilii nąįį, ąįį ch'ihłak sha'ohtsuu, 1 mile sheenjit inghwaa nahnyąą ji' 2 miles veenjit yihiinghwaa yuu. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Dinjii k'eiich'i' ch'ihłak eenjit naahkat ji' vantł'eeyiin'ąįį, ąįįts'ą' nijin dinjii jii k'eiich'i' sheedhah'aii nahnyąą ji' gwik'it t'ini'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Vit'eegwijyąhchy'aa yeenii nakhwalak nąįį dinjii nąįį jyaa dahnyąą gohtth'ak, ‘Nakhwaneh'ok gwich'įį nąįį eet'ohthan, ts'ą' juu nakhwatr'ii'ee nąįį gootr'ooh'ee.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gaa juk nakhwaagwaldak, juu nakhwatr'ii'ee nąįį eet'ohthan, ts'ą' juu khaiinjich'anakhwagahkhit nąįį eenjit khadagohjii. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jyąhts'ą' gwik'iighai' Zheekat Nakhwati' vigii khohłyaa geenjit. Dinjii iizųų akwat dinjii nizįį nąįį datthak kat oodee shree dha'aii haa gooch'ąhdrii ąhtsii t'inchy'aa. Juu gwinzii t'ii'in ts'ą' juu tr'agwaanduu t'ii'in nąįį datthak kat ąhtsin gwahtsii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Juu neet'iindhan zhrįh eet'iindhan ji', jaghaii Vit'eegwijyąhchy'aa geenjit nahah'aa? Juu tax eenjit laraa oonjii nąįį gaa jyaa digii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ąįįts'ą' nijyaa nąįį zhrįh ts'ą' inzii ji', jaghaii Vit'eegwijyąhchy'aa geenjit nahah'aa? Juu Vit'eegwijyąhchy'aa haandaii kwaa nąįį gaa jyaa digii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Zheekat Nakhwati' vit'igwiin'ee kwaa ts'ą' shroodiinyąą nilii ąįį vik'it t'ahohchy'aa gwizhrįh goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Nijin gwik'injuhkhit geenjit k'eegwiichy'aa t'akhwa'in dąį' dinjii gwanlii tee nakhwagahaah'yaa geenjit jyaa dakhwa'ya' shrǫ'! Dinjii gwanlii tee jyaa dakhwa'in ji' Zheekat Nakhwati' duuyeh nakhwan neegǫǫnkwat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nijin dinjii neeshraahchy'aa antł'aanjii dąį' dinjii nąįį nagahah'yaa gwa'an noo'ya' shrǫ'! Dinjii nizįį adaa'įį nąįį goorahah'yaa geenjit Jews tr'igiinkhii zheh akwat tąįį gwinjik gwa'an neeshraahchy'aa nąįį antł'eegaanjii, deegii'in gwigweheechy'aa eenjit antł'eegaanjii diikhoh'e' giindhan geh'an t'igii'in. Łyaa nakhwaagwahaldak, deegii'in ąįį ch'adąį' hee geenjit googwaroonkwat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Gaa, nijin neeshraahchy'aa nąįį ts'ohnyaa dąį', zhit juu łi'haa zhyaa nijyaa nilii ąįį gaa vaagwandak shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Gweentak t'ini'in ji' jyąhts'ą' gwik'iighai' Zheekat Nakhwati' zhrįh gaaheendaii ts'ą' nineegooheekwat t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nijin khadigiinjii dąį' dinjii nizįį adaa'įį nąįį k'it t'anoo'ya' shrǫ', ndak nagadhat ts'ą' tąįį gwinjik dinjii gwanlii gwa'an ts'ą' Jews tr'igiinkhii zheh gwizhit khadigigiinjii, juu nąįį datthak gavaahaa'yaa geenjit jyaa digii'in, łyaa nakhwaagwahaldak ch'adąį' hee datthak geenjit googwaroonkwat t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Gaa nijin khadigiinjii dąį' nizheh gwizhit naraah'in kwaa gwa'an gwats'ą' hinkhaii, Zheekat Nakhwati' tr'ąąh'in kwaa, ąįį vats'a' gweentak khadigiinjii ji' t'ee nineegooheekwat t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Juu ch'ik'itiltsį' kwaii ts'ą' khadigiinjii nąįį k'it khadagohjyaa shrǫ', ginjik deegwinyąą gaagiindaii kwaa haa khagigidiinjii, gook'eegwaadhat gavaheetth'ak giindhan ts'ą' niighyuk khadigigiinjii, ");
INSERT INTO gwiNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","gook'it t'ohchy'a' shrǫ'! Nakhwati' jidii t'oochy'aa oohohkat gwehkįį ch'adąį' hee gaandaii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jyąhts'ą' khadagohjii, ‘Diiti' zheekat gwizhit Noozhri' shroodiinyąą nilii ts'ą' narahoh'e', ");
INSERT INTO gwiNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Niveegwiginiin'ee gwik'it gooli' deeyiindhan dzaa nankat ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","zheekat haa gwik'it gooli'! Drin gwiteegwaanchy'aa shih tr'ihee'aa diits'an ąhtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Diitr'agwaanduu diineejit oo'an gwihinlii, ąįįts'ą' juu diits'ą' tr'agwaanduu t'ee'ya' nąįį chan gwik'it gooveenjit oo'an gwireheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ąįįts'ą' tr'agwaanduu t'agǫǫ'ya' gwiindhan gwits'į' an-diinoaan'ee, ąįį tr'aanduu diits'ą' gwiizųų t'ihee'yaa ąįį gwits'į' diik'aahtii.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Dinjii nakhwats'ą' tr'agwaanduu tr'agwagwah'in nąįį gooveenjit oo'an gwahohłii ji' Zheekat Nakhwati' chan nakhwatr'agwaanduu oo'an gweheelyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gaa ninee'ok dinjii nąįį nakhwats'ą' tr'agwaanduu t'ii'in gooveenjit oo'an gwahohłii kwaa ji', Zheekat Nakhwati' chan duuyeh tr'agwaanduu t'akhwa'in nakhweenjit oo'an gwihilii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nizįį adaa'įį nąįį adach'agaa'aa kwaa ts'ą' khadigigiinjii nąįį k'it t'akhwa'ya' shrǫ'. Nijin dach'agaa'aa kwaa haa khadigigiinjii dąį' goonin tr'igwidii k'it t'inchy'aa ąįį gook'it t'ohchy'a' shrǫ'. Ąįįts'ą' dinjii goohaah'yaa gwa'an goovehdeiingaii k'it t'igii'in ts'ą' neegihiidal goorahah'yaa geenjit ąįį gook'it t'akhwa'ya' shrǫ'. Łi'didlii haa nakhwaagwaldak, ch'adąį' hee datthak googwaroonkwat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nijin khadigiinjii geenjit ch'ihłee ch'in'aa kwaa dąį', ninin gwinzii k'eech'ahąhtryaa ts'ą' nikiighai' chan gwinzii ahshruk. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jyąhts'ą' gwik'iighai', khadigiinjyaa geenjit ch'ihłee ch'in'aa kwaa, ąįį ch'izhii nąįį gaageheendaii kwaa geenjit gaa diikhwan zhrįh tr'aadii dąį' jyaa digwii'in ąįį zheekat Nakhwati' tr'ąąh'in kwaa zhrįh nakhwah'in ąįį nakhwaneegwahookwat t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Dzaa nankat, k'eiich'ii lęįį khaihłan nǫhłyaa shrǫ', jyaa dakhwazhit ji' moths ts'ą' tsuh haa an yahahtsyaa ts'ą' dinjii ch'an'įį nąįį giits'ą' łeegwagwahahnaii ts'ą' neech'igeheen'įį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Gaa zheekat ideenjit khaihłan nigwiinlii, izhit khahthaa tsal (moths) akwat tsuh haa an heelyaa kwaa ts'ą' duuyeh ch'an'įį nąįį yats'ą' łeegwahnaii ts'ą' giiyuunjii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nijin khaihłan nagohłii izhit t'ee nakhwadrii dha'aii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Nakhwandee t'ee nakhwazhin eenjit ch'ahdrii k'it t'inchy'aa. Nakhwandee haa gwinzii gweech'in ji' nakhwazhin datthak adrii k'it t'inchy'aa ts'ą' datthak gwinzii. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gaa nakhwandee haa gwinzii gweech'in kwaa ji' nakhwazhin datthak tǫǫ gwizhit dha'aii t'oonchy'aa. Ąįį nakhwazhit tǫǫ gwanlii ji' t'ee tǫǫ ts'ą' tr'agwaanduu haa heelyaa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Khaihkwaii neekwaii nąįį duuyeh eenjit gwitr'it t'agwah'in t'oonchy'aa. Ch'ihłak eet'ihinghyaa ts'ą' ch'ihłak itr'ihiin'ee. Ch'ihłak ts'ą' łi'didlii hinlyaa gaa ch'ihłak ts'ą' łi'didlii hinlyaa kwaa. Duuyeh Vit'eegwijyąhchy'aa ts'ą' laraa haa nihłaa k'eegwaadhat an'įį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Izhit geh'an jii eenakhwaagwaldak t'ihnyąą, goohǫhndąį' geenjit shih hoh'aa ts'ą' chųų hakhwanjyaa geenjit tr'agohdii shrǫ'. Ąįįts'ą' chan jidii gwach'aa nananzhyaa eenjit chan tr'agohdii shrǫ'. Jidii shih tr'a'aa ts'ą' gwach'aa naraazhii haa jii gwarandaii zhit andaa gwihil'ee kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Zhit dziitsal kwaii nǫh'in, gwanzhįh gąąhshii kwaa, ts'ą' gwanzhįh chan gaahtsii ts'ą' zheh gii'įį ąįį zhit nihdeegiiyilii kwaa, ąįį googaa nihk'it Zheekat Gwiti' gook'ąąhtii ts'ą' gooch'ah'aa t'iginchy'aa. Chiitsal nąįį andaa nakhweegoo'aii t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nakhwatee gwa'an ch'ihłee niighyuk goiihndaii niindhan ts'ą' geenjit tr'igwidii ji', duuyeh gwintsal niighyuk gwandaii adaatsii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ąįįts'ą' jaghaii gwach'aa nahoozhyaa eenjit tr'agohdii? Zhit gwanzhįh gwinzii vigweech'in nahshii nǫh'in. Ideenjit tr'agwagwah'in kwaa ts'ą' ideenjit chan gwach'aa gahtsii kwaa gooh'in? ");
INSERT INTO gwiNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gaa nakhwaagwaldak, King Solomon gaa deegwahtł'oo valaraa gwanlii haa hil'ee gaa gook'it gwach'aa jyaa dahtsu' naazhii kwaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nakhwak'injigwiighit łyaa natsal, t'agwarahnyąą. Jesus gavahnyąą. Vit'eegwijyąhchy'aa jii nankat gwanzhįh gwinzii vigweech'in kwaii nahshii ts'ą' k'ąąhtii, t'oonchy'aa. Jii gwanzhįh kwaii juk drin gwinzii nahshii gaa nihkaa drin vaa vikeech'arahchy'aa zhit tr'ahahk'an t'inchy'aa. Jii kwaii andaa khadhoo'ee t'oonchy'aa ts'ą' gwach'aa nahoozhyaa nakhwantł'eeheelyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nijin gwats'an, shih hoh'aa ts'ą', chųų khwanjyaa ts'ą' nijin gwats'an gwach'aa nahoozhyaa, geenjit tr'agohdii shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Juu Vit'eegwijyąhchy'aa k'injiighit kwaa nąįį t'ee, jii kwaii eenjit tr'igwigwidii ts'ą' eenjit hanagaandaii t'igiinchy'aa, gaa Zheekat Nakhwati' jii kwaii datthak t'ohchy'aa nakhwaandaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Izhit geh'an, jii Vit'eegwijyąhchy'aa Veegwinii'ee ts'ą' deenahnyąą datthak gwik'it t'akhwa'yaa gwizhrįh gininjich'ohthat, ji' jidii t'oohchy'aa kwaii datthak nakhwats'an hahtsyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ąįį geh'an nihkaa drin geenjit tr'agohdii gwat'oohchy'aa kwaa t'oonchy'aa. Juk drin gwinlęįį geenjit tr'agohdii gwanlii t'oonchy'aa, ąįį geeghaih gwinlęįį kwaii vineedohkhan haa tr'igwidii dats'an ohtsii gwat'oohchy'aa kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dinjii neenjit oozųų shrǫ', jyąhts'ą' gwik'iighai' Vit'eegwijyąhchy'aa chan jyaa nooheenjyaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dinjii neenjit iizųų geh'an Vit'eegwijyąhchy'aa inzųų nahoonjyaa t'oonchy'aa ąįįts'ą' nats'ąą dinjii intł'eehaandal googwahtsii chan Vit'eegwijyąhchy'aa nintł'eehaandal t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ąįįts'ą' chan jaghaii, nachaa gwik'injiighit vindee zhit gał tsal dha'aii nah'in eenjit gwintł'oo ninjich'iindhat gwiizhit nindee zhit dachan choh dhihtin ąįį gwadrąįį ninjich'iindhat kwaa? ");
INSERT INTO gwiNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nats'ahts'ą' nandee dachan choh dhitin gwiizhit nachaa gwik'injigwiighit zhit ‘Ąįį gał tsal vindee dha'aii neenjit hoihchyaa!’ vahaiinjyaa? ");
INSERT INTO gwiNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Deegwiłtł'oo dee zhyaa nizįį adaan'įį (hypocrite) t'ini'in! Ąįį nindee dachan choh dhitin ąįį tr'ookit khaniinchįį, ąįįtł'ęę hee gwinzii naa gweheechy'aa ts'ą' gwinzii gwąąh'in k'iighai' nachaa gwik'injiighit vindee gał tsal dha'aii khaiinchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Jidii shroodiinyąą nilii, łąįį antł'ohtsit shrǫ'. Jyaa nizhik ji', nats'ą' łihts'eedagahaa'ee ts'ą' nak'aa gal gahahdaa t'igiinchy'aa. Na-pearls ąįį pigs ideekwaii gwats'ą' hohjyaa shrǫ' dagakwai' haa zhat giiyeeheetal t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Vit'eegwijyąhchy'aa oohkat ji' nakhwantł'eeyehee'aa, ts'ą' vinkeegǫh'in ji' vagwahoh'aa t'inchy'aa ts'ą' vats'ą' ganloonaii ji' nakhweenjit gideerihideenchyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Juu k'eegwiichy'aa ch'oahkat t'ee vintł'eegwahaatth'aa, ts'ą' juu k'eegwiichy'aa gwinkeegwaah'in chan yagwahah'aa, ts'ą' juu yats'ą' ganlaanaii chan veenjit gindeiinvyaa eetr'ooheendal t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nakhwatee ch'iti' nilii ąįį vidinji' łųhchy'aa yahnyąą ji' duuyeh kii (ghoo) yantł'ah'ąįį t'inchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ąįįts'ą' chan łuk yahnyąą ji' gyųų choh yantł'eehahchyaa lee t'inchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Deegwiłtł'oo ohsųų googaa, nakhwagii nąįį jidii k'aiich'ii nizįį nakhwagahnyąą goovantł'ohłii, gwiizhit zheekat Nakhwati' jidii vohnyąą ąįį gwandaa dagwahtł'oo nizįį haa nakhwantł'eehaandal gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Jii t'ee Moses va-law ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį geech'agoahtan zhit t'ee jyaa diginyąą, ‘Zhit ch'izhii dinjii nąįį nats'ahts'ą' nats'ą' dinjii gooli' gavoiinyąą gwik'it nan chan goots'ą' dinjii inlii.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Gindeiinvyaa k'it łyaa gwiints'ik; hell gwats'ą' gindeiinvyaa ąįį łyaa gwiinchyaa ts'ą' gwinjik hohdaa geenjit gwagwantrii kwaa ts'ą' łyaa dinjii lęįį nąįį gwinjik hijyaa t'oonchy'aa ");
INSERT INTO gwiNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gaa gwaandaii tr'iheelyaa geenjit gwats'ą' gindeiinvyaa łahchy'aa gwiints'ik ts'ą' vats'a' gwagwantrii ts'ą' dinjii nitsya' nąįį zhrįh giigwah'at t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Vit'eegwijyąhchy'aa Eenjit Ginkhii adaa'įį nąįį ts'į' adak'ǫǫntii. Divii k'it t'igiheechy'aa ts'ą' nijin nats'ą' geedaa ji' goodrii zhit zhoh iizųų k'it t'igiinchy'aa t'igii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nats'ahts'ą' deegii'in gwik'iighai' gavaakhwandaii t'inchy'aa. Khoh duuyeh jak choh (grapes) vakat nahshii, ąįį gwik'it jak, Figs duuyeh khoh kat nahshii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Dachan vat'an nizįį vakat jak nizįį nahshii, gaa dachan vat'an iizųų ąįį vakat juk iizųų nahshii. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Dachan vat'an nizįį duuyeh jak iizųų vakat nahshii ąįį gwik'it dachan vat'an iizųų duuyeh jak nizįį nahshii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ąįįts'ą' jidii ts'iivii vakat jak nahshii kwaa kwaii kharaheekyaa ts'ą' kǫ' zhit oo'an tr'ahahdaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ąįį gwik'it jidii ts'iivii nats'ahts'ą' vakat gwąąhshii ąįį gwik'it Vit'eegwijyąhchy'aa Eenjit Ginkhii adaa'įį nąįį deegii'in ąįį k'iighai' goovaakhwandaii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Juu shoozhri' oozhrii ts'ą' ‘K'eegwaadhat, K'eegwaadhat!’ Shahnyąą nąįį datthak Zheekat Gweegwinii'ee nihdeeheedaa kwaa t'oonchy'aa. Gaa zhit juu zheekat Shiti' deenyąą gwik'eegwahthat nąįį zhrįh nihdeegiheedaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nijin Ch'aroahkat Drin nagwiindhat ji' lęįį nąįį, ‘K'eegwaadhat, K'eegwaadhat, noozhri' zhit Vit'eegwijyąhchy'aa Vagwandak Nizįį eegwaraandak ts'ą' noozhri' zhit ch'anky'aa iizųų chan dinjii nąįį ts'an tr'iriinlii ts'ą' gwinlęįį chan noozhri' zhit nindal gwaahchy'aa gwigwii'in t'igwiizhit.’ giheenjyaa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ąįįts'ą' jii jyaa goovahaihjyaa, ‘An shihłeekhwajyaa, dinjii iizųų ǫhłįį ts'ą' nakhwaashandaii kwaa!’ t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ąįįts'ą' t'ee juu shiginjik oołk'įį ts'ą' shik'eegwahthat nąįį t'ee zhit juu kii choh kat zheh gwiłtsąįį k'it googwizhi' gwanlii t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gwint'aii ąhtsin ts'ą' han gwinjik chųų gwintł'oo ndak t'iizhik ts'ą' gehk'aa gaa teiinkhaii, gwiizhit zheh gwats'ą' gwint'aii ahtr'aii, googaa nihk'it zheh needagwaakhaii kwaa, kii kat dagoo'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Gaa juu nąįį datthak shiginjik oołk'įį ts'ą' gwik'it t'ii'in kwaa nąįį t'ee zhit juu googwizhi' kwaa haa needdhak kat zheh gwiłtsąįį k'it t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gwint'aii ąhtsin ts'ą' han gwinjik chan chųų gwintł'oo ndak t'iizhit ts'ą' teiinkhaii, gwiizhit chan zheh gwats'ą' gwint'aii ahtr'aii, ąįįts'ą' łahchy'aa gwint'aii needagwaanaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nijin Jesus, geech'ǫąąhtan ndaanaahjik dąį' zhit juu yaa łeeljil nąįį łahchy'aa gooveenjit geegagoolii kwaa t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Law eech'ǫąąhtan nąįį (Scribes) k'it łyaa t'inyąą kwaa, gaa dinjii viginjik nint'aii haa geech'oohtan k'it geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nijin Jesus taih kat gwats'an oozhat neehoozhii dąį' dinjii thousand andaa t'ąąnchy'aa nąįį yaa łeeljil ts'ą' giitąįį haajil. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ąįįtł'ęę dinjii ch'ihłak vatthąį' ahjat (leprosy) haa iłts'ik ąįį yats'ą' haazhii ts'ą' yehzhee nikiigwiintthaii ts'ą' t'iiyahnyąą, “K'eegwaadhat gwik'it t'iindhan ji', khan shrineeshihiinlyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus, danli' haa yakat naanjik ts'ą' t'iiyahnyąą, “Gwik'it t'iihthan t'oonchy'aa, shranąąnjii!” Yahnyąą gwagwahkhan vakat gwiinzii neegahoodlit, ts'ą' shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus t'iiyahnyąą, “Shoodǫǫhk'įį, dinjii ch'ihłak gaa haagwandak shrǫ'! Giinkhih ts'ą' hinkhaii ts'ą' nakat datthak googwah'in, ąįįtł'ęę juu nąįį datthak shrananzhik naagiheendaii geenjit, Moses va-law deenyąą gwik'it Vit'eegwijyąhchy'aa vantł'eegwin'ąįį.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nijin Jesus, Capernaum kwaiik'it nihdeiinzhii dąį' dinjii ch'ihłak Roman niveet'ah'in khaihkwaii ąįį yats'ą' tr'iinzhii ts'ą' shits'iinyąą yahnyąą ts'ą' yich'oodiikwat. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“K'eegwaadhat, shitsyaa iłts'ik ts'ą' khaiinjich'iidhat ts'ą' khyų' gaa needahaandik ts'ą' shizheh deek'it gwakat dohdii t'inchy'aa.” yahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus, ąįį t'iiyahnyąą, “Vats'a' hihshyaa ts'ą' veenjit gwiinzii neegwahałtsyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ąįį Roman niveet'ah'in khaihkwaii ąįį Jesus oozhrii ts'ą' t'ahnyąą. “K'eegwaadhat, shizheh nihiinkhaa geenjit gaa tr'ihkhit nahoł'ee ts'aii, geh'an zhyaa gwik'it t'agǫǫnjyaa diinyąą, ji' gaa t'ee shitsyaa veenjit gwinzii neegweheelyaa ts'ą' shrineehaanjyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Shįį chan, dinjii niveet'ah'in choh shats'ą' k'eedeegwaadhat shi'įį, ąįįts'ą' shįį chan niveet'ah'in lęįį nąįį ts'ą' k'eedeegwaldhat ąįį jyaa goovahnyąą ts'ą' hinkhaii vakhaihjyaa ji' heekhaa t'inchy'aa, ąįįts'ą' aanaii vaihnyąą ji' shats'ą' heekhaa t'inchy'aa, ąįįts'ą' sha-slave sheenjit tr'agwah'in chan jyaa ni'in vaihnyąą ji' gwik'it t'ihee'yaa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nijin Jesus łyaa geegoolii kwaa gwiitth'ak dąį'. Juu yatąįį neehiidal nąįį t'agoovahnyąą, “Łi'haa ch'ihłok gaa Israel gwich'in nąįį jyaa deegwahtł'oo shik'injiriighit gaashandaii kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jii nakhwaagwahaldak, dinjii lęįį nąįį dzaa nankat East, ts'ą' West haa gwats'an adaa nąįį Abraham, Isaac, ts'ą' Jacob nąįį haa ch'aga'aa gwagwahtsii gahahtsyaa ts'ą' Zheekat Gweegwinii'ee zhit goovaa neech'igehee'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Zhit juu Gwigwiniin'ee gwizhit gooveenjit shrigwiinlik, nąįį nihdeegiinjil kwaa gaa oozhak tǫǫ gwaazhrąįį gwanlii ąįį zhit gwizhit t'eegoorahahthal t'igiinchy'aa izhit t'ee gwintł'oo giheetree ts'ą' dagagho' nihts'ą' łagahoon'al haa neegiiyik'ii k'it t'igihee'yaa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ąįįtł'ęę Jesus jyaa yahnyąą, “Jidii eenjit gwik'injiinghit, gwik'it t'igweheenjyaa t'oonchy'aa oo'an nizheh gwits'ee neehindii.” yahnyąą. Jesus jyaa nyąą gwiizhit zhit niveet'ah'in vitsyaa shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nijin Jesus, Peter, vizheh nihdineezhii ts'ą' Peter va'at vahan iłts'ik ts'ą' deek'it gwakat ndaka'ee, gwiizhit vatthąį' nindhaa łee yąąh'in dąį'. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus yanli' kat naanjik ts'ą' vatthąį' nindhaa kwaa neegwaanąįį ts'ą' khakee'ąįį, ts'ą' Jesus ch'ihee'aa eenjit shrigwiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nijin zhat khaa nagwaanąįį dąį', dinjii vizhit ch'anky'aa iizųų gwanlii lęįį nąįį Jesus ts'ą' gahaadlii. Ts'ą' diginjik haa goozhit gwats'an ch'anky'aa iizųų cheeneiinlii ts'ą' juu iłts'ik lęįį nąįį datthak chan shrininlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jii datthak t'iizhik, Vit'eegwijyąhchy'aa Eenjit Ginkhii Isaiah yeenii deiinyą' ąįį łi'deegwidlii haa gwik'it gweheelyaa geenjit, “Adan adakhai' ts'ik kwaii diits'an oonjik ts'ą' jidii ts'ik vaa tr'iłts'ik datthak diiłeehaadlii.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nijin Jesus, dinjii lęįį nąįį veelin neelzhii gwąąh'in dąį', ditsyaa nąįį t'ahnyąą “Oonjik van ndųhts'ąįį gwats'ą' tr'ahoojyaa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dinjii ch'ihłak, Law eech'ǫąąhtan ąįį Jesus ts'ą' haazhii ts'ą' jyaa yahnyąą. “Geech'ǫąąhtan, nijuk inkhaa datthak naa k'eehihdik.” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus t'iiyahnyąą, “Neegǫǫ kwaii ch'a'an gwigwii'įį ts'ą' chiitsal kwaii chan ch'at'oh gwigwii'įį. Gaa shįį ąįį Gwidinji' ihłii ts'ą' hihchyaa gwishi'įį kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ąįįtł'ęę ch'izhii vitsyaa yiinlii ąįį t'iiyahnyąą, “K'eegwaadhat, oo'an neehihdyaa gaa tr'ookit shiti' ąįį vanahałdal ąįįtł'ęę nits'eehihdyaa,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus jyaa yahnyąą, “Zhit juu iłchįį nąįį, ch'ichį' tee gwa'an nihłeegitsii gaa nan ąįį shaa hinkhaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nijin Jesus tr'ihchoh zhiinzhii dąį' vitsyaa nąįį yaa gwizhiinjil, ");
INSERT INTO gwiNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ts'ą' van kat geelaa gwiizhik khan hee van choh kat gwint'aii teiintr'aii, tr'ihchoo tit choh haa vizhit chųų deedahkhii, gwiizhit Jesus dhichįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Vitsyaa nąįį giits'ą' haajil ts'ą' khakigiiyiin'ąįį ts'ą' t'igiiyahnyąą. “K'eegwaadhat, diits'iinyąą, neeraheedhaa k'it t'igwii'in!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","“Jaghaii zhyaa noojat? Deegwiłtł'oo zhyaa nakhwak'injigwiighit natsal!” gavahnyąą. Ndak needhikhin ts'ą' ahtr'aii nint'aii ts'ą' tit choo kwaii haa ts'ą' gwint'aii khaginkhee ts'ą' datthak tsinehdan nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Juu nąįį datthak gwintł'oo gwihil'ee t'iizhik ts'ą' gihilghaa haa jyaa t'inihłagaanyąą, “Jii dinjii juu t'inchy'aa? Ahtr'aii choh, ts'ą' tit choh kwaii gaa yik'eegwahthat!” ");
INSERT INTO gwiNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nijin, Jesus van ndųhts'ąįį, Gadara nahkat teedhizhii dąį', dinjii neekwaii goozhit ch'anky'aa iizųų, ąįį ch'a'an gwizhit tth'an k'it goodlii gwa'an gwats'an khagiin'oo ts'ą' giits'ą' haa'oo tr'ihkhit dinjii iizųų giinlii ts'ąįį zhat tąįį gwinjik dinjii nąįį khyų' gaa geeghaih nigijyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Zhat gwagwahkhan, gwint'aii gazhral ts'ą' Jesus jyaa dagahnyąą, “Vit'eegwijyąhchy'aa Vidinji', deediinahah'yaa t'ini'in? Diidrin gweheelyaa gwehkįį khaiinjidiich'ahahthat eenjit dzaa gwats'ą' hoiinzhii lee t'ini'in?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zhat geeghaih nahgǫǫ gwa'an pig lęįį ch'a'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ąįįts'ą' zhit ch'anky'aa iizųų nąįį Jesus ts'ą' eech'oodigiikwat ts'ą' jyaa diginyąą, “Jii dinjii nąįį zhit tr'eediihinlyaa ji', zhit pig kwaii zhit tr'iheedaa diits'an gwahtsii.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Gwats'ą' hohjyaa!”, Jesus gavahnyąą, ts'ą' dinjii nąįį ts'an tr'ineegiijil ts'ą' pig kwaii zhit digiindhat ts'ą' pig naatł'ii kwaii datthak taihdik gwats'an oodaa van zhit gahaajil ts'ą' teenagahoonii. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Zhit pigs k'ąąhtii nąįį gihłeegalgihiljil ts'ą' zhat kwaiik'it goo'aii gwats'ą' gahaajil ts'ą' deegwiizhik datthak geegwagwaandak. Zhit dinjii nąįį goozhit gwehkįį dąį' ch'anky'aa iizųų dilk'ii nąįį chy'ah deegiizhik geegwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ąįįts'ą', kwaiik'it gwich'in nąįį datthak Jesus ts'ą' gahaajil ts'ą' nijin giiyah'ya' dąį' gwint'aii giiyahkat, ts'ą' diinahkat gihłeehiindii giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus tr'ihchoh zhit neezhįį ts'ą' van ndųhts'ąįį dakwaiik'it gwits'eehoozhii, ");
INSERT INTO gwiNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Izhit zhat dinjii neehidik kwaa, chyah kat ndaka'ee giits'ą' nąąhchįį, nijin Jesus, deegwiłtł'oo gwik'injigwiighit gii'įį gavaah'in dąį' ąįį dinjii neehidik kwaa ąįį jyaa dahnyąą, “Shidinji' nat'aii neegwiilii ts'ą' natr'agwaanduu datthak neenjit oo'an gwahoiilii t'oonchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ąįį gwiizhik, Law eech'ǫąąhtan lat zhat dilk'ii nąįį adats'ą' giginkhii, “Jii dinjii Vit'eegwijyąhchy'aa vinehts'į' ginkhii!” t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Gaa Jesus, nats'ahts'ą' ninjich'agadhat gavaandaii ts'ą' t'agavahnyąą. “Jaghaii zhyaa tr'agwaanduu ninjich'ǫhthat? ");
INSERT INTO gwiNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Jii jidii shrit ts'ąįį t'avarahaanjyaa ąįį ts'ąįį googwantrii kwaa, ‘Natr'agwaanduu neenjit oo'an gwarahaadlii,’ akwat ‘Ndak nineenjii ts'ą' inkhaa?’ ");
INSERT INTO gwiNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jii geenjit gwik'injinakhwahałdaa, Gwidinji' dzaa nankat tr'agwaanduu oo'an gweheelyaa eenjit t'aih di'įį gaahahkhwandaii geenjit.” Ts'ą' dinjii neehidik kwaa jyaa dahnyąą, “Ndak nineenjii, ts'ą' nichyah noiinjii ts'ą' oo'an nizheh gwits'eehindii!” ");
INSERT INTO gwiNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ąįįts'ą' t'ee zhit dinjii ndak needhikhin ts'ą' oo'an dizheh gwits'eehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nijin dinjii nąįį gwagwah'ya' dąį', łahchy'aa gwint'aii gihiłghaa ts'ą' dzaa dinjii nąįį tee dinjii t'aih ts'an ąhtsii geenjit Vit'eegwijyąhchy'aa deegihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus zhat gwats'an gihłeehoozhii ts'ą' k'ii'an ahaa, gwiizhit tax eenjit laraa oonjii nilii Matthew oaazhii, didehk'it gwizhit dhidii neeł'in ts'ą' t'ahnyąą, “Shatąįį hinkhaii!” ts'ą' Matthew ndak niinzhii ts'ą' yaahaazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesus, ditsyaa nąįį haa Matthew vizheh neech'a'aa gwiizhit dinjii tax eenjit laraa oonjii lęįį nąįį ts'ą' zhit gwa'an dinjii vatr'agwaanduu gwanlii googahnyąą nąįį datthak giits'ą' nihdiinjil ts'ą' giiyaaneech'a'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ts'ą' nijin Pharisee nąįį gwagwah'ya' dąį' Jesus vitsyaa nąįį jyaa dagahnyąą, “Zhit nakhwageech'ǫąąhtan, jaghaii dinjii tax eenjit laraa oonjii nąįį ts'ą' dinjii vatr'agwaanduu gwanlii varahnyąą nąįį haa neech'a'aa t'ii'in?” ");
INSERT INTO gwiNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Gaa nijin Jesus gaviitth'ak dąį' t'agavahnyąą, “Juu dinjii gwinzii gwandaii dinjii k'ahaanjii t'aahchy'aa kwaa t'oonchy'aa. Juu iłts'ik nąįį zhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Shihłeekhwajyaa ts'ą' Dęhtły'aa Choh zhit nijin gwadanakhwatł'oo gwinkee gooh'in, ‘Ch'eet'igwiniindhan ąįį nihthan gaa nin ataiinjii tr'ahtsii ąįį nihthan kwaa t'oonchy'aa.’ Dinjii nizįį nąįį eenjit dzaa gwats'ą' hoiizhii kwaa t'oonchy'aa gaa zhit juu vatr'agwaanduu gwanlii nąįį eenjit t'ishi'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ąįįtł'ęę John, chųų gwats'an ąhtsii ąįį vitsyaa nąįį Jesus ts'ą' gahaajil ts'ą' giiyųąhkat, “Diikhwan ts'ą' Pharisee nąįį haa khadigireheejyaa geenjit ch'ihłee adach'ara'aa kwaa, gwiizhit jaghaii nitsyaa nąįį jyaa t'igii'in kwaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus t'agoovahnyąą, “Dinjii, tr'injaa haa nihłeegoorahchįį dąį' juu goovaach'ihee'aa nąįį tr'igwidii t'igiheechy'aa goovohnyąą? Duuyeh jyaa t'igiinchy'aa gaakhwandaii, dinjii goonjik gavaa dhidii gwizhit jyaa digihee'yaa kwaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Dinjii ch'ihłak gaa duuyeh ch'adak ik k'eejit nilii kwaa kat gwach'aa k'eejit k'aahkaii t'oonchy'aa jyaa diizhik ji' zhit gwach'aa k'eełkaii ąįį natsal nahaadhal ts'ą' gwandaa łeeheech'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Duuyeh gaa jak chų' k'eejit ąįį jak tyah ch'aa zhit tr'injyaa t'oonchy'aa jyaa t'igwiizhik ji', jak tyah ch'aa łeeheech'aa ts'ą' jak chų' neheenjaa ts'ą' an heelyaa: gaa jak chų' k'eejit ąįį jak tyah k'eejit zhit reheenjaa gwizhrįh goo'aii. Nihłaa heezyaa ts'ą' niighyuk heekaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus goots'ą' ginkhii gwiizhit, Jews tr'igiinkhii zheh gwats'ą' k'eedeegwaadhat yats'ą' haazhii ts'ą' yats'ą' nikiigwiintthaii ts'ą' t'iiyahnyąą, “Shigii nich'it tsal t'ohju' zhat shaa niindhat, gaa shaa oo'an neehiindii ts'ą' vak'aa naanjii ąįį ji' vineegwahąhdaii geenjit.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ąįįts'ą' Jesus ndak needhikhin ts'ą' ditsyaa nąįį haa giiyaahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tr'injaa ch'ihłak 12 years gahkhyuk dah vats'an an ilii haa khaiinjich'iighit, Jesus ant'ii niinzhii ts'ą' yach'adak ik tsii naanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Vi'ik kat naaljik ji' gwizhrįh sheenjit gwinzii neegweheelyaa!” adaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus yats'ą' nil'ee ts'ą' yah'ya', “Naanjat kwaa shichi', nigwik'iinjigwiighit neenjit gwinzii neegwiłtsąįį t'oonchy'aa!” yahnyąą. Gwagwahkhan ąįį tr'injaa veenjit gwinzii neegahoodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ts'ą' nijin Jesus, k'eedeegwaadhat vizheh k'idik dąį', dinjii gwanlii ts'ą' flute ach'ahłii nąįį nah'in zhat dinjii diłk'ii nąįį datthak tr'igwigwidii haa gwiizųų gwigwił'ąįį gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ts'ą' Jesus jyaa gavahnyąą, “Datthak ts'ą' cheekhwajyaa yaagha' nich'it tsal niindhat kwaa ts'ą' zhyaa dhichįį t'inchy'aa!” Gavahnyąą akhai' datthak giiyeedlaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gaa nijin dinjii nąįį cheehaadlii, gwagwahkhan Jesus nich'it tsal ts'ą' niinzhii ts'ą' yanli' oonjik ts'ą' khakee'ąįį ts'ą' needhikhin.” ");
INSERT INTO gwiNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Aiizhit zhat gwa'an nahkat datthak dinjii nąįį geenjit gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus, zhat gihłeehoozhii ts'ą' k'ii'an tr'ineezhii gwiizhit dinjii vandee kwaa neekwaii nąįį giitąįį adaa ts'ą' gazhral haa jyaa ginyąą, “King David ts'an deedhaa, neeshraahchy'aa diinoiinyaa!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nijin Jesus zheh nihdeiinzhii dąį' dinjii vandee kwaa neekwaii nąįį giits'ą' niin'oo nąįį jyaa dahnyąą, “Shrineenakhwahihłyaa nohthan lee t'akhwa'in?” “Aahą', K'eegwaadhat!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ąįįtł'ęę Jesus gavandee kat naanjik ts'ą' t'agavahnyąą. “Gwik'injukhit geh'an gwik'it gooli'!” nyąą ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","t'ee gwagwahkhan shrineegaazhik. Ąįįts'ą' Jesus gwint'aii goots'ą' khagiinkhee, dinjii ch'ihłak gaa haa goondak shrǫ'!” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Googaa aiizhit nahkat gwa'an datthak giiyeeginkhii ts'ą' juu nąįį datthak Jesus eenjit gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Dinjii vizhit ch'anky'aa iizųų k'iighai' khyų' ginkhii, dinjii lat nąįį Jesus ts'ą' nigiiyahchįį, it'ee łyaa dinjii nąįį cheehiijyaa gwiizhit t'igiizhit. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Gaa zhat gwagwahkhan ch'anky'aa iizųų yats'an chahaadlii ts'ą' ąįį dinjii ginkhii needhidlit, ts'ą' juu nąįį datthak łyaa geegagoolii kwaa t'igwiizhik. “Israel nahkat gwizhit jyaa doonchy'aa gwa'an ch'ihłok gaa gwaraah'in kwaa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gaa Pharisee nąįį jyaa giiyahnyąą, “Ch'anky'aa iizųų nąįį datthak ts'ą' k'eedeegwaadhat Beelzebul oaazhii ąįį vat'aii haa ch'anky'aa iizųų cheehilii t'ii'in,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus, kwaiik'it gwachoo ts'ą' kwaiik'it gwatsal kwaii datthak gwitee neehihdik ts'ą' Jews tr'igiinkhii zheh gwizhit geech'ǫąąhtan ts'ą' Gwandak Nizįį, zhit Gwigwiniin'ee geegwaandak ts'ą' dinjii juu ts'ik nihłehjuk haa iłts'ik nąįį shrineiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Dinjii lęįį łeeljil nąįį nah'in dąį', vidrii zhit gooveenjit tr'igwidii dha'aii naanaii, tr'ihkhit gooveenjit neeshreegaahchy'aa ts'aii idits'igiheenjyaa geenjit gaa goot'aii kwaa, divii nąįį, divii k'ąąhtii gii'įį kwaa k'it t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ąįįts'ą' ditsyaa nąįį t'ahnyąą, “Dinjii nąįį gwanzhįh tr'ąąhshii ts'ą' khaihłan nirilii k'it t'iginchy'aa, gaa dinjii yahahtsyaa lęįį ąįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Datthak ts'ą' Vit'eegwijyąhchy'aa gwanzhįh nahshii gwats'ą' k'eedeegwaadhat vats'a' khagadǫhjii ts'ą' dinjii lęįį nąįį gwanzhįh khaihłan nigiheelyaa geenjit gwats'ą' heelyaa geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus, ditsyaa 12 nąįį khaihłan niinlii ts'ą' t'aih goots'an iłtsąįį, ch'anky'aa iizųų dinjii nąįį ts'an tr'igiheelyaa ts'ą' jidii ts'ik nihłehjuk t'iichy'aa haa giłts'ik nąįį datthak ts'ą' tr'igiheendal geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jii Tr'ihił'e' 12 nąįį t'ee jyąhts'ą' goovoozhri': tr'ookit Simon oozhii gaa Peter neegiiyahnyąą ąįį vachaa Andrew James ts'ą' vachaa John ąįį Zebedee vidinji' giinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip ts'ą' Bartholomew, Thomas ts'ą' Matthew, Matthew t'ee tax eenjit laraa oonjii inli', James t'ee, Alphaeus vidinji' ts'ą' Thaddaeus chan. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon t'ee Zealot nilii (“Dinjii łyaa danahkat geet'indhan nilii” ąįį voozhri' t'ee jyaa gwinyąą t'igwinyąą) ts'ą' Judas Iscariot, jii dinjii t'ee Jesus gwantł'ąhchįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus, Ditsyaa 12 nąįį nihky'aa gooveehił'e' ts'ą' giheedaa gwehkįį deegihee'yaa gavaa gwaandak, “Jews nilii kwaa nąįį goonahkat ts'ą' Samaria kwaiik'it kwaii gwats'ą' hohjyaa shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Gaa, Israel gwizhit dinjii nąįį divii haa tr'igweendaii k'it t'igiinchy'aa nąįį ts'ą' hohdaa yuu! ");
INSERT INTO gwiNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hohjyaa ts'ą' jii jyaa dohnyąą ts'ą' goondak, ‘Zheekat Gweegwinii'ee ąįį gwats'ą' nahgǫǫ t'oonchy'aa!’ ");
INSERT INTO gwiNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Iłts'ik nąįį chan shrineehohłik, dinjii niindhat nąįį ineegoohohdaii, juu gwatthąį' ahjat (leprosy) haa iłts'ik haa khaiinjich'iighit nąįį shrineegavohłik, dinjii vizhit ch'anky'aa iizųų nąįį chan chineegavǫhłii. Nakhwagwarookwat kwaa haa jyaa dakhwa'in geenjit t'aih nakhwats'an dhałtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gold, silver, akwat copper laraa nilii kwaii nakhwatseet'it neehoozhik shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nihky'aa hohdaa geenjit ohtsuu, akwat ch'adak ik neekwaii, kwaiitryah, akwat toh haa neehoozhik shrǫ'! Gwitr'it t'agwah'in nąįį jidii haa gwigweheendaii deegaahchy'aa gavantł'ee tr'iheelyaa goo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Nijin kwaiik'it gwachoo akwat kwaiik'it gwatsal gwa'an neekhwadal dąį' juu shaa gǫǫnch'į' noonyąą nąįį haa gwiinch'įį, dahthee neehiindyaa gwats'ą' datthak vaa gwiinch'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nijin zheh nihdǫhdal dąį' ‘Tsinehdan nakwaa oolį'!’ dohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nijin zheh nihdǫhdal dąį' ąįį juu zhat gwich'įį shagoiinch'i' noonyąą ji', ‘Juu dzaa zheh gwizhit gwich'įį nąįį tsinehdan goovaa oolį'!’ diinyąą, gaa zhat goiinch'į' nagoonyąą kwaa ji', ‘Tsinehdan noohaa oolį' dihnyąą ąįį noohihdal!’ diinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nijin kwaiik'it k'eekhwadal ts'ą' dinjii nideenakhwachįį kwaa ts'ą' nakhwaginjik chan goołk'įį kwaa ji', ąįį zheh akwat kwaiik'it gihłeekhwajyaa gwiizhit nakhwakwai' kat łųh nǫhghat. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Łyaa nakhwaagwaldak t'ihnyąą, datthak ts'ą' shiginjik akhoonyąą geh'an Ch'aroohahkat Drin ji' Vit'eegwijyąhchy'aa nakhwakwaiik'it andaa Sodom, ts'ą' Gomorrah nahkat nąįį neeshraahchy'aa gavahoonjyaa t'oonchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Ch'oodǫǫhk'įį, zhoh naatł'ii nąįį tee divii gwats'ą' nakhwaahihłyaa t'ishi'in. Ąįįts'ą' gyųų choh k'it gwak'ǫǫhtii haa khai'gwidlii gooveelin nihdąhoondik, ts'ą' chiitsal doves k'it gooveezhuu t'ohchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jii dinjii nąįį eenjit gwak'ǫǫhtii, zheegwaazhrąįį gwats'ą' nakhwagahahchyaa ts'ą' ch'aroahkat zheh gwizhit chan nihdeenakhwagahahchyaa ts'ą' viitrii haa chan Jews tr'igiinkhii zheh gwizhit nakhwagahahtrii t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nakhwarahahkat geenjit shįį, shęh'an, Kings jii nahkat gwats'ą' k'eedeegwaadhat nąįį andaa khadhoo'ee ts'ą' Gwandak Nizįį eegwahoondak ąįįts'ą' juu Jews nilii kwaa nąįį chan Gwandak Nizįį eegavaagahoondak gwizhrįh goo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nijin narahaakat, geenjit gwats'ą' neerahiłchįį ji' deehiinjyaa ts'ą' jidii eeginkhii kwaii datthak eenjit tr'agoiindii shrǫ'. Nijin zhat nigwiindhat ji' deehinjyaa datthak nantł'eegwihih'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ginjik haa gihinkhyaa ąįį nats'an t'inchy'aa kwaa. Zheekat Niti' ąįį Vach'anky'aa Shroodiinyąą nizhit t'inchy'aa ąįį vik'iighai' gihiinkhyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Dinjii nąįį dagachaa gaa gwantł'ee gahahchyaa goovęhdaa tr'igwirehee'aa geenjit. Ąįįts'ą' ch'iti' nąįį chan digigii nąįį gwik'it t'agahah'yaa t'oonchy'aa. Ch'iyehghan nąįį gaa googii nąįį gwantł'ee googahahchyaa goovęhdaa tr'agwarahee'aa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","“Shįį, shęh'an juu nąįį datthak nakhwatr'ihee'ee. Gaa juu adootą' ts'ą' akhagohnyąą kwaa ji' t'ee neehohshii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nijin kwaiik'it gwizhit khaiinjich'anakhwagahthat nakhwagahtsii dąį' ch'izhii kwaiik'it gwats'ą' gal hohjyaa. Jii t'ee łyaa nakhwaagwaldak t'ihnyąą, Israel kwaiik'it gwizhit datthak duuyeh tr'agoh'in gęhdaa tr'ohjii t'oonchy'aa, tth'aii hee gwitr'it t'agoh'in gwiizhit Gwidinji' neeheedyaa t'oonchy'aa, ");
INSERT INTO gwiNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Zhit juu geeraahtan ąįį juu geech'ǫąąhtan andaa veegoo'aii kwaa ts'ą' zhit juu slave nilii chan zhit juu yats'ą' k'eedeegwaadhat andaa veegoo'aii kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Juu geeraahtan, ąįį juu geeyųąąhtan k'it t'iheechy'aa geenjit gwitr'it t'agwah'in ji' geenjit shoo oolį'. Ąįįts'ą' juu slave nilii ąįį juu yats'ą' k'eedeegwaadhat k'it t'inchy'aa dhidlit ji' geenjit shoo oolį'. Juu yizhehk'aa gwats'ą' k'eedeegwaadhat Beelzebul (Satan) oozhii ji', ąįį vizhehk'aa nąįį datthak gwandaa gwiizųų goovaagweheelyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ąįįts'ą' jii nankat dinjii nąįį oonjat shrǫ'. Jidii nagogwąąh'įį ąįį kwaii gwizhrįh nigweheedaa ts'ą' jidii geehoh'it gwigwił'ąįį kwaii datthak gwik'igahaandal gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jidii tǫǫ gwizhit nakhwaagwaldak ąįį drin ch'aadrii gwizhit chan hee geegahohkhyaa gwizhrįh. Ąįįts'ą' jidii gweentak nakhwaa gwaraandak chan zheh gwakat gwats'an shraa haa geegahohkhyaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Zhit juu nakhwatthąį' ęhdaa tr'agwa'ak ąįį oonjat shrǫ', duuyeh gwik'it nizhin ęhdaa tr'agwagwa'ąįį t'igiinchy'aa gaa Vit'eegwijyąhchy'aa ąįį nakhwazhin ts'ą' nakhwanky'aa haa an oiłtsyaa niindhan ji' (hell) oozhak gwit'eh goo'aii kwaa gwizhit an yahahtsyaa ąįį voonjat. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Neek'ik neekwaii laraa tsoo tsal ch'ihłak t'įį tr'iheelyaa lee t'oonchy'aa? Ts'ą' Gwiti' gwik'it t'iindhan kwaa ji' ch'ihłak gaa duuyeh nankat neet'aaghyii, t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ąįįts'ą' Vit'eegwijyąhchy'aa nakhwakiighai' daanchy'aa gaa gaandaii t'inchy'aa ");
INSERT INTO gwiNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Neek'ik lęįį andaa ts'ą' khadhoo'ee t'oonchy'aa geh'an noojat shrǫ'.” ");
INSERT INTO gwiNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Juu dinjii gwanlii gwitee shats'an nilii nyąą ji' shįį chan Zheekat Shiti' vandaa nihthat ji' shats'an ǫhłįį vakhaihjyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gaa juu dinjii gwanlii gwitee shitr'ii'ee nyąą ji' shįį chan Zheekat Shiti' vandaa nihthat ji' vitr'iin'ee vakhaihjyaa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tsinehdan haa dzaa nankat gwats'ą' hihshii nohthan? Nakwaa, tsinehdan haa dzaa nankat gwats'ą' hoiizhii t'ishi'in kwaa, gaa dinjii nąįį nihłigiighan hałtsyaa geenjit dzaa gwats'ą' hoiizhii t'ishi'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ch'izhehk'aa nąįį datthak nihts'ą' nits'ich'agahahthat t'oonchy'aa. Jii nąįį t'ee nihts'ą' nits'ich'agahahthat t'igiinchy'aa: ch'iti' ts'ą' didinji' haa, nich'it tsal ts'ą' vahan haa, ąįįts'ą' daughter in law ts'ą' mother in law nąįį haa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nizhehk'aa gwizhit dinjii nąįį nitr'ihee'ee t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Juu shandaa diti' akwat dagahan haa eet'iindhan nąįį shitsyaa giheelyaa, geenjit gaa gaveegoo'aii kwaa ts'ą' zhit juu shandaa digii nąįį eet'iindhan nąįį chan shitsyaa giheelyaa geenjit gaa gaveegoo'aii kwaa t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Juu da-cross ichyaa kwaa ts'ą' shatąįį haazhii t'ee shitsyaa heelyaa geenjit veegoo'aii kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Juu dagwandaii, diyinji' haa intsai' ji' t'ee yaa shrihteegwehee'aa. Gaa juu shęh'an niindhat ąįįt'ee dagwandaii, diyinji' haa neehahshii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Juu dizheh gwizhit shoo haa nihdeenakhwachik t'ee shįį chan shoo haa dizheh nihdeeshahchik ts'ą' juu shoo haa dizheh nihdeeshahchik t'ee Vit'eegwijyąhchy'aa shihił'e' chan shoo haa dizheh nihdąhchik t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Juu Vit'eegwijyąhchy'aa Eenjit Ginkhii dizheh shoo haa nihdąhchik t'ee Vit'eegwijyąhchy'aa jidii nizįį Vit'eegwijyąhchy'aa Eenjit Ginkhii antł'eiin'ąįį ąįį nan chan nantł'eehee'aa t'inchy'aa. Ts'ą' juu dinjii Vit'eegwijyąhchy'aa deenyąą gwik'it dinjii nilii ąįį dizheh shoo haa nihdąhchik ji', Vit'eegwijyąhchy'aa jidii gwinzii ąįį dinjii yik'eegwahthat antł'eehee'aa ąįį nan chan nantł'eehee'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ts'ą' ąįį dinjii shitsyaa nilii geh'an juu, dinjii hil'ee kwaa nilii, chųų k'oh yantl'eiinkaii ji' Vit'eegwijyąhchy'aa łyaa zheekat jidii diineenjit di'įį yantł'eehee'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nijin Jesus, ditsyaa 12 nąįį gǫąąhtan ndaanaahjik, dąį' zhat gihłeehoozhii ts'ą' zhat gwa'an kwaiik'it goodlii gwitee gwa'an geech'ǫąąhtan ts'ą' Gwandak Nizįį eegiinkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nijin John chųų gwats'an ąhtsii, zheegwaazhrąįį dhidii gwiizhit Jesus dee'in datthak eegwiitth'ak dąį', ditsyaa nąįį Jesus ts'ą' hił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Diihaa gwandak, nanlee dinjii oo'ee heekhaa ginyąą lee t'inchy'aa? Akwaa ji' ch'izhii dinjii ąįį keegwarahah'yaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus t'agavahnyąą, “Nijin gwats'ąnh ohdaa gwits'eekhwajyaa ts'ą' jidii nǫh'ya' ts'ą' jidii gootth'ak datthak John vaagoondak. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Dinjii vandee kwaa nąįį gaa goovaagweheechy'aa geenjit shrineegaazhik, juu neehidik kwaa nąįį chan neehidik neekhwadlit. Zhit juu gootthąį' kat gwiizųų (leprosy) haa khaiinjich'iidhat nąįį chan shrineegaazhik ts'ą' gookat gwinzii neegahoodlit. Juu ch'iitth'ak kwaa nąįį gaa ch'igiheetth'ak geenjit shrineegaazhik, juu niindhat gaa chan neegweheendaii, ąįįts'ą' Gwandak Nizįį zhit juu neeshraahchy'aa nąįį haa gwaldak. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Zhit juu khit shik'injiighit nąįį łahchy'aa sheenjit shoo giinlii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","John vitsyaa nąįį neegeheenjyaa, gwiizhit Jesus, zhit juu yaa łeeljil nąįį John eegavaagwaandak, “Nijin John nangwinjir gwa'an vats'a' hadhoojil dąį' jidii hǫǫh'yaa nohthan? Dinjii vat'aii kwaa, tł'oo ts'ik ch'ihłak ahtr'aii tee yihichik k'it t'inchy'aa hǫǫh'yaa nohthan? ");
INSERT INTO gwiNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Zhat gwats'ą' khadhoojil dąį' jidii hǫǫh'yaa nohthan? Dinjii gwach'aa nidiiltsį' nizįį naazhii hǫǫh'yaa nohthan? Dinjii jyąhts'ą' nagwaazhii nąįį zhrįh King vizheh gwachoh gwizhit gwigwich'įį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Shaagoondak, jidii hǫǫh'yaa nohthan ąįį nǫh'ya'? Vit'eegwijyąhchy'aa Eenjit Ginkhii hǫǫh'yaa nohthan? Aahą', łyaa Vit'eegwijyąhchy'aa Eenjit Ginkhii hǫǫh'yaa nohthan akhai' Vit'eegwijyąhchy'aa Eenjit Ginkhii andaa hil'ee nilii ąįį nǫh'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ąįį John t'ee Dęhtły'aa Choo zhit jyąhts'ą' veerigiinkhe', ‘Vit'eegwijyąhchy'aa ąįį yeenjit jyaa diinyą' juu neehał'at nits'ii oo'an hał'aa t'oonchy'aa, neenjit tąįį shrigweheelyaa geenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Łahchy'aa nakhwaa gwaldak, John chųų gwats'an ąhtsii t'ee dinjii gwehkįį gwiindaii nąįį datthak andaa gwiintsii veegoo'aii t'inchy'aa gaa Zheekat Gweegwinii'ee gwizhit juu gwintsal gwizhrįh veegoo'aii ąįįt'ee John andaa veegoo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Nijin John, Gwandak Nizįį eeginkhii dhidlit dąį' gwats'an, Zheekat Gweegwinii'ee gwizhit, dzaa nankat gwidinjii nąįį gwint'aii nihdeech'itsigahthat ts'ą' nihdeegiheedaa gwik'eegwagwandaii ts'ą' Zheekat Gwigwiniin'ee gwizhit khaiinjich'agoorahkhit gooriłtsąįį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","John jyaa diheenjyaa gwats'ą' dąį' Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį datthak, ts'ą' yeenaa Moses va-law gwizhit juk drin gwats'ą' Zheekat Gwigwiniin'ee datthak geegiginkhe' ts'ą' Dęhtły'aa Choo zhit gwadanakhwatł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gwik'it t'iindhan ji', yeenii Moses Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį deegiinyą' gook'injiinghit ji', John t'ee Elijah t'inchy'aa, nijin John dzaa nankat gwats'ą' heekhaa dąį' ch'adąį' hee, dzaa gwats'ą' heekhaa giiyeeginkhe' t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'! ");
INSERT INTO gwiNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Juk gweendaa dzaa nankat gwich'in nąįį jidii k'it t'igiinchy'aa hihjyaa li'? Tr'iinin tsal k'it nijin gwa'an dinjii gwanlii ch'oorookwat deek'it, gwa'an nihłaa nigiilzhii ts'ą' ch'izhii łeeljil nąįį ts'ą' gazhral, ");
INSERT INTO gwiNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nihłeegwarahchįį gwich'ilik nakhweenjit ach'araahłii gaa ch'oodzaa kwaa! Dinjii niindhat gwich'ilik nakhweenjit ach'araahłii gaa ohtree kwaa!’ ");
INSERT INTO gwiNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nijin John dzaa nankat gwats'ą' haazhii dąį' adach'aa'aa kwaa ts'ą' jak chų' (wine) gaa dinįį kwaa ts'ą' juu nąįį datthak jyaa nyąą, ‘Ch'anky'aa iizųų vizhit dhidii!’ giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Nijin shįį Gwidinji' dzaa gwats'ą' hoiizhii dąį', ch'ih'aa ts'ą' jak chų' shinįį, ąįįts'ą' juu nąįį datthak jyaa nyąą, ‘Jii dinjii nǫh'in! Gwintł'oo ch'a'aa ts'ą' jak chų' (wine) chan gwintł'oo dinįį ts'ą' chan tax eenjit laraa oonjii nąįį ts'ą' dinjii vatr'agwaanduu gwanlii googahnyąą nąįį jyaa a'ii.’ giiyahnyąą! Gwidinji' deegii'in k'iighai' Vit'eegwijyąhchy'aa vigwizhi' łi'deegwidlii gwanlii ąįį gwigweech'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nijin kwaiik'it gwizhit, Jesus gwigwee'in gwinlęįį t'iizhik, ąįį dinjii nąįį datr'agwagwaanduu ts'an łihts'eedagaa'ee kwaa ts'ą' ąįį kwaiik'it kwaii tth'aii hee tr'agwaanduu t'igii'in geh'an akǫǫ dagoovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Chorazin kwaiik'it ts'ą' Bethsaida kwaiik'it haa łahchy'aa łyaa nakhwaa gweheezųų t'oonchy'aa! Jii gwigwii'in, Tyre ts'ą' Sidon kwaiik'it gwachoo gwizhit jyaa digwee'ya' ji' t'ee zhat gwich'in nąįį deenaadąį' hee ohtsuu gwach'aa (sack cloth) nagahaazhyaa ts'ą' kikluu dagakat neegeheenjaa t'igiinchy'aa, datr'agwagwaanduu ts'an łihts'eedigiil'ee gwigweheechy'aa geenjit! ");
INSERT INTO gwiNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jii łahchy'aa t'ihnyąą, Ch'aroahkat Drin zhit nigwiindhat ji' Tyre ts'ą' Sidon kwaiik'it gwachoo gwich'in nąįį, Vit'eegwijyąhchy'aa nakhwandaa neeshraahchy'aa gavahoonjyaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ąįįts'ą' kwaiik'it Capernaum goozhii chan zheekat gwats'ą' adahaahoochyaa nohthan? Hell oozhak gwit'eh gwakwaa gwats'ą' t'anakhwarahahthal t'oonchy'aa! Jii gwigwii'in Sodom, gwizhit t'igwiizhit ji', juk tth'aii hee ąįį kwaiik'it dzaa gwehee'aa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nijin Ch'aroahkat drin gwizhit nigwiindhat ji', Vit'eegwijyąhchy'aa Sodom gwich'in nąįį nakhwandaa neeshraahchy'aa ooheenjyaa t'oonchy'aa gaakhwandaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Izhit dąį' Jesus jyaa nyąą, “Shiti', zheekat ts'ą' nankat haa gwats'ą' K'eegwaadhat, mahsį', naihnyąą. Juu gwaroołtin kwaa nąįį ts'ą' nigwizhi' gwizhrįh nigwiin'ąįį geh'an ąįį jidii gwit'eh gooh'ąįį juu dzaa nankat gwats'ąnh vigwizhi' gwanlii ts'ą' geech'ǫąąhtan choo nąįį ts'į' gwit'eh gooh'ąįį geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aahą', Shiti' jii t'ee jyaa dagoonjyaa niindhan, geh'an gwik'it t'igwiizhit ts'ą' shoo inlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Shįį Shiti', jidii datthak shantł'eiinlii t'oonchy'aa, ch'ihłak gaa Gwidinji' haandaii kwaa, gaa Gwiti' zhrįh yaandaii, ts'ą' ch'ihłak gaa Gwiti' haandaii kwaa, gaa Gwidinji' zhrįh yaandaii t'oonchy'aa. Ąįįts'ą' Gwidinji' juu niindhan nąįį chan Gwiti' goots'ą' agwahch'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aanaii, gwintl'oo neech'ohohkhwat gwats'an neenakhwahałshii ts'ą' neehoozhii geenjit datthak shats'ą' hohjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Jii ghwah shak'oh kat doo'aii, ąįį nakwakat deehih'aa ts'ą' shats'an gwagoohoo'ee. Shidrii zhit khazhak t'ihchy'aa ts'ą' khai'gwidlii ch'eezhuu t'ihchy'aa ąįį geh'an shats'an gwinzii neenoozhii gwagoohoh'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ąįį jidii nakhwak'oh kat k'eekhokhwat, ąįį nakhwantł'eehih'aa, duuyeh nidii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ąįįtł'ęę vijuu gwanaa dąį' Neegwaazhii Drin zhit, Jesus ts'ą' ditsyaa nąįį haa gwanzhįh deek'it tł'oo li' (wheat) tee geedaa gwiizhit vitsyaa nąįį goozhit gwiłts'ik ts'ą' tł'oo li' vitsii gwanzhįh tsal dhidlii kwaii gihłeegihiljil ts'ą' giiyaajyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nijin Pharisee nąįį gwagwaah'in dąį' Jesus jyaa dagahnyąą, “Dzaa gwąąh'in, dii-law zhit nitsyaa nąįį Neegwaazhii Drin zhit gwizhit jyaa digihee'yaa kwaa goo'aii!” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus, jyaa gavahnyąą, “Yeenii David ts'ą' juu yaa nilii nąįį haa goozhit gwiłts'ik dąį' deegiizhik ąįį nik'ee Dęhtły'aa Choo kat gooh'in? ");
INSERT INTO gwiNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Vit'eegwijyąhchy'aa vizheh gwadhah zhit nihdeiinzhii ts'ą' adan ts'ą' juu vaa neehiidal nąįį datthak jidii Vit'eegwijyąhchy'aa antł'eetr'ahtsit giin'al, giinkhih nąįį zhrįh ąįį łųhchy'aa hee'aa goo'aii gwinyąą, dii-Law zhit jyaa digwehee'yaa kwaa goo'aii googaa gwik'it t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nik'ee Dęhtły'aa Choh kat Moses va-law gwadanakhwatł'oo ąįį gooh'in? Neegwaazhii Drin gwitee gwagwaanchy'aa datthak giinkhih nąįį Kharigidiinjii zheh gwizhit gwitr'it t'agwah'in k'iighai' Moses va-law łeegahnaii gaa nihk'it Vit'eegwijyąhchy'aa gootr'agwaanduu gwakwaa goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Łyaa nakhwaa gwaldak t'ihnyąą, nakhwatee ch'ihłee dzaa dhidii ąįį łyaa Kharigidiinjii zheh andaa gwiintsii veegoo'aii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Jii t'ee Dęhtły'aa Choo zhit gwadanakhwatł'oo, ‘Ch'eet'igwiniindhan nihłeenjit akhwa'įį ąįįt'ee iindhan t'inyąą, nin ataiinjii tr'ahtsii ąįį nihthan kwaa.’ Jii deegwinyąą t'igwinyąą gaakhwandaii ji' duuyeh dinjii vatr'agwaanduu kwaa, ąįį nąįį nakhwatr'agwaanduu gwanlii ohnyąą t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ąįįt'ee shįį Gwidinji' t'ihchy'aa ts'ą' Neegwaazhii Drin gaa gwats'ą' k'eedeegwaldhat t'oonchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesus, zhat gihłeehoozhii ts'ą' Jews' nąįį gootr'igiinkhii zheh nihdineezhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Izhit gwizhit dinjii vanli' iłchįį zhat dhidii. Izhit zhat dinjii lat dilk'ii nąįį, Jesus gwaahkat, “Dii-law zhit Neegwaazhii Drin zhit, gwizhit dinjii shrineereheelyaa geenjit gwiizųų kwaa lee t'oonchy'aa?” giiyahnyąą. Jyaa diizhik ji' gwiizųų t'ii'in giihaanjyaa geenjit t'igiiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus t'agoovahnyąą, “Nakhwatee dinjii ch'ihłak divii dii'įį akhai' ch'a'an gwachoh gwizhit t'aanaii ji', Neegwaazhii Drin zhit gwanlii ji' gaa k'iizhak gwinzii oohiindal ts'ą' khaneehahchyaa lee t'inchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Dzaa nankat gwidinjii nąįį divii kwaii andaa gihil'ee t'igiinchy'aa. Izhit geh'an dii-law zhit khan Neegwaazhii Drin zhit ch'izhii dinjii nąįį ts'igweheenjyaa gwinyąą t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesus ąįį dinjii vanli' iłchįį dhidlit t'ahnyąą, “Nanleetth'ak kwaii nihky'aa oonjii.” Ąįį dinjii jyaa diizhik ts'ą' vanli' nizįį neekhwadlit, ch'izhii vanli' nizįį ąįį k'it t'inchy'aa needhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ąįįts'ą' t'ee Pharisee nąįį cheegahoojil ts'ą' Jesus nats'ahts'ą' ęhdaa tr'igwigwehee'aa geegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nijin Jesus ęhdaa tr'igwihee'aa geenjit nihłaa nigiinjil dąį' Jesus gwiitth'ak ąįįts'ą' ąįį zhit gwats'an t'ohłii neehoozhii. Dinjii lęįį nąįį yaa łeeljil ąįį nąįį chan giiyaahaajil, gwiizhit juu iłts'ik nąįį datthak shrinilii. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","“Juu t'ihchy'aa geegǫǫndak shrǫ'!” Jesus, ąįį dinjii nąįį, ginjik nint'aii haa jyaa gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jii t'ee jyaa diizhik ts'ą' jyaa dihee'yaa vareiinyą', ąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii Isaiah gwadąąntł'oo, yeenii Vit'eegwijyąhchy'aa deenyą' ąįį deeyahnyąą ąįį łi'deegwidlii gweheelyaa geenjit gwik'it t'igwiizhik: ");
INSERT INTO gwiNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jii dinjii t'ee shitsyaa nilii łyaa veet'iihthan ts'ą' dee'in datthak shoo shahtsii, adan t'ee gwitee tr'ahchįį t'inchy'aa. Jii nankat gwich'in nąįį datthak nats'ahts'ą' neereheezhii goovaagwahandak geenjit Ch'anky'aa Shroodiinyąą vats'an hałtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Duuyeh gwik'it chan azhral ts'ą' ch'izheedaan'ee t'inchy'aa. Akwat chan duuyeh dinjii lęįį nąįį andah gwint'aii azhral ts'ą' ginkhii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gwanzhįh tł'oo k'it t'inchy'aa ąįį ch'iłtsąįį, nilii ji' gaa, duuyeh łeerahnaii. (Lamp) kwaii daak'a' adrii niheekyaa k'it t'ii'in ji' gaa duuyeh neeyahkyaa t'inchy'aa. Ąįįts'ą' dahthee tr'aanduu gaiiyiihahtsyaa gwats'ą' datthak giheendal kwaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ąįįts'ą' dzaa nankat dinjii nąįį datthak neegeheezhii geenjit, giit'injyahchy'aa t'iginchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ąįįtł'ęę dinjii lat nąįį, dinjii vizhit ch'anky'aa iizųų t'inchy'aa geh'an ginkhii kwaa ts'ą' vandee kwaa giits'ą' nąąhchįį ts'ą' ąįį dinjii shrininlik ts'ą' gwąąh'in ts'ą' ginkhii neeyiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jesus, dinjii lęįį vaa łeeljil nąįį gooveenjit nindal gwaahchy'aa t'igwiizhik, ts'ą' jyaa ginyąą, “Jii yeenii King David vidinji' t'inchy'aa shrǫǫ?” Ginyąą ts'ą' ch'agoahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nijin Pharisee nąįį gwigwiitth'ak dąį' jyaa ginyąą, “Ch'anky'aa iizųų nąįį datthak ts'ą' k'eedeegwaadhat Beelzebul oaazhii ąįį vat'aii haa ch'anky'aa iizųų cheehilii t'ii'in,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus, nats'ahts'ą' ninjich'agadhat goovaandaii ts'ą' t'agavahnyąą, “Jidii nahkat nihts'įį nihts'ą' nineegiidal ts'ą' nihłigiighan ji' khants'ą' an gweheelyaa. Zhehk'aa gwizhit akwat kwaiik'it gwizhit chan nihłigiighan ji' t'ee tthak an gweheelyaa gwagwahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ąįį gwik'it Satan vineegoo'ee khaihłak gwanlii kwaa ts'ą' nihtee nihłigiighan ji' duuyeh niighyuk khaihłak gwanlii ts'ą' nihłaa shrahtee gwagwahahtsyaa ts'ą' an gweheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Beelzebul k'iighai' ch'anky'aa iizųų kwaii dinjii ts'an tr'ihłii dohnyąą ji', nakhwatsyaa nąįį juu t'aih goots'an ąhtsii haa jyaa digii'in t'igii'in? Deeshi'in ąįį gwik'it t'igii'in t'igii'in, ąįįts'ą' datthak ts'ą' gwiizųų t'akhwa'in nakhwagahąąnjyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nakwaa, Vit'eegwijyąhchy'aa, Vach'anky'aa Shroodiinyąą vat'aii haa ch'anky'aa iizųų cheehihłii t'ishi'in, ąįįt'ee Vit'eegwijyąhchy'aa nakhweenjit Diveegwinii'ee gagwaach'in t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ąįį gwik'it duuyeh dinjii ch'ihłak gaa dinjii vat'aii niint'aii gwanlii ąįį zheh nadakhaii ts'ą' yik'eiich'į' kwaii teegwąhjii t'inchy'aa, tr'ookit diiyahahchaa ts'ą' naghwaa yihee'aa, ąįįtł'ęę yizheh yik'eiich'į' datthak ooheendal t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Juu shaa nilii kwaa nąįį t'ee shats'ąįį nadhat kwaa, juu shits'inyąą kwaa ts'ą' shaa dinjii khaihłan nilii kwaa t'ee dinjii shrihteehilii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jyąhts'ą' geh'an jii nakhwaa gwaldak t'ihnyąą, dinjii ch'ihłee tr'agwaanduu nihłehjuk vigwitr'it gwanlii ji' gaa, shatr'agwaanduu gwanlii nyąą ts'ą' Vit'eegwijyąhchy'aa sheenjit oo'an gwihinlii ahnyąą ji' yeenjit oo'an gweheelyaa t'oonchy'aa, gaa juu Ch'anky'aa Shroodiinyąą gwiizųų eeginkhii ji', ąįį tr'agwaanduu t'ii'in geh'an ndaagwąą'ąį' kwaa gwats'ą' duuyeh yeenjit oo'an gwihilii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dinjii ch'ihłee Gwidinji' gwiizųų eegiinkhii ji' gaa, shatr'agwaanduu gwanlii nyąą ts'ą' Vit'eegwijyąhchy'aa sheenjit oo'an gwihinlii ahnyąą, ji' yeenjit oo'an gweheelyaa t'inchy'aa, gaa juu, Ch'anky'aa Shroodiinyąą gwiizųų eeginkhii ji', ąįį tr'agwaanduu t'ii'in geh'an juk akwat ndaagwąą'ąį' gwats'ą' datthak duuyeh yeenjit oo'an gwihilii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Jak dachan gwinzii nahshii ni'įį ji' gwizhrįh vakat jak gwinzii hahshii t'inchy'aa, gaa jak dachan gwinzii nahshii kwaa ni'įį ji' vakat jak iizųų hahshii. Dachan nats'ąą vakat jak nahshii k'iighai' vaagwiindaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nakhwan ąįį gyųų choh k'it t'ohnyąą, nats'ahts'ą' tr'ǫǫnduu gwiizhit gwinzii gwanlii geegahohkhyaa? Nakhwaghit haa nats'ahts'ą' gohkhii ąįįt'ee nakhwadrii zhit jyaa doonchy'aa geh'an jyąhts'ą' goohkhii t'ohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dinjii nizįį ąįį vats'an gwinzii tr'igwijyaa, ts'ą' dinjii iizųų ąįį vats'an gwiizųų tr'igwijyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ch'aroahkat Drin, gwizhit nigwiindhat ji' jidii ginjik ginilih kwaa haa gookhe' ąįį datthak geenjit nakhwarahahkat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nakhwaginjik t'ee gwagwahahchy'aa haa t'ee nakhwarahahkat. Ąįį haa t'ee nakhwatr'agwaanduu gwanlii akwat nakhwatr'agwaanduu gwakwaa nakhwarahaanjyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ąįįtł'ęę Law eech'ǫąąhtan lat nąįį ts'ą' Pharisee lat nąįį, giits'ą' khagiinkhee ts'ą' t'iginyąą, “Geech'ǫąąhtan, gwigween'in t'ini'in ąįį tr'agooh'ya' gwiindhan,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Gaa Jesus t'agoovahnyąą, “Juk gweendaa gwidinjii nąįį łyaa tr'ihkhit gwik'injigiighit kwaa ts'ą' tr'agwaanduu gwizhrįh googwitr'it gwanlii! Nakhwan gwigwii'in eenjit ch'oohkat? Nakwaa, duuyeh nakhweenjit gwigwii'in t'ishi'in ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii Jonah, deezhik gwik'it gwizhrįh gwigwii'in gahǫǫh'yaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonah, drin tik ąįįts'ą' tǫǫ tik datthak łuk choh zhit indi', ąįį gwik'it chan Gwidinji', nanzhit drin tik t'iheechy'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ch'aroahkat drin ji' Nineveh kwaiik'it gwachoo gwich'in nąįį ndak nagahaazhyaa ts'ą' tr'agwaanduu t'akhwazhit, nakhwagahąąnjyaa t'oonchy'aa. Ąįįt'ee Jonah geech'ǫąąhtan gwigwiitth'ak dąį' dagatr'agwaanduu akhagagoonyąą. Nakhwaagwahaldak, dzaa juk Jonah andaa ts'ą' veegoo'aii diitee t'inchy'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ch'aroahkat Drin ji' Sheba gwats'an Queen nilii ndak niheehaa ts'ą' juk gweendaa gwidinjii nąįį gootr'agwaanduu gwanlii heenjyaa. Sheba yeenji' danahkat gwats'an k'idik, King Solomon vigwizhi' gwanlii zhit geech'ǫąąhtan oohąąhky'aa eenjit. Nakhwaagwahaldak, dzaa juk Solomon andaa ts'ą' veegoo'aii diitee t'inchy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nijin ch'anky'aa iizųų dinjii ts'ą' tr'ineediidhat dąį', nankat chųų kwaa gwa'an needahaachik ts'ą' gweheechy'aa gwinkeegwaah'in. Khyų' gwagwa'ąįį ji'. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Shizheh gwits'eehihdyaa,’ adaanyąą. Ąįįts'ą' gwits'eehoozhii akhai' ąįį zheh gwizhit datthak cheegwaraadlii, shrineegwaazhit, ts'ą' gwinzii shrineegwirinlik łee gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ąįįtł'ęę t'ohłii haazhii ts'ą' vandaa ch'anky'aa iizųų 7 nąįį oo'ee neiinlii, ts'ą' zhat gwigwich'įį. Nijin ndaanagąąhjik dąį', ąįį dinjii tr'ookit iizųų chy'aa gwandaa t'agwahtł'oo iizųų dhidlit. Juk gweendaa dinjii iizųų nąįį goots'ą' jyaa digweheenjyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus tth'aii hee dinjii nąįį ts'ą' ginkhii gwiizhit, vahan, ts'ą' vachaa nąįį haa k'eegiidal, chiitąįį nigiilzhii gwiizhit zheh giiyeenjit ch'oahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ąįįts'ą' dinjii ch'ihłak ąįį Jesus jyaa dahnyąą, “Nahan, nachaa nąįį haa chiitąįį nigeelzhii, ts'ą' nats'ą' garookhyaa ginyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus gwidiiginkhii, “Juu dee shahan ts'ą' shachaa nąįį nilii?” ");
INSERT INTO gwiNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ąįįtł'ęę ditsyaa nąįį ts'ą' ch'ahaatthaii ts'ą' t'inyąą, “Jii nąįį t'ee shahan ts'ą' shachaa nąįį haa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Juu zheekat gwizhit Shiti' doo'ya' yuunyąą gwik'it t'ii'in t'ee shachaa, shijuu ts'ą' shahan nilii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Zhat drin Jesus zheh gihłeehaazhii ts'ą' van vee gwats'ą' haazhii, izhit geech'oohahchyaa geenjit naadii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dinjii gwanlii haa vaagwiltł'ak ts'ąįį tr'ihchoo zheiinzhii ts'ą' naadii, gwiizhit vanvee dinjii lęįį neelzhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gwinlęįį goovaagwahandak geenjit gwandak ąhtsii zhit geegoovąąhtan ts'ą' jyaa nyąą, “Ch'ihłan dąį' dinjii ch'ihłak gwanzhįh deek'it gwa'an gwats'ą' haazhii, ts'ą' gweheełshii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ąįįts'ą' gwanzhįh gwit'eiinlii gwiizhit valat kwaii tąįį gwinjik gwa'an an-nihłik niinjil ts'ą' chiitsal kwaii datthak giiyiin'al. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Valat kwaii łųh vitee kii gwanlii ąįį gwinzii vitee łųh kwaa izhit niinjil. Łųh gwanlii kwaa geh'an khan hahshii, ");
INSERT INTO gwiNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","gaa nijin shree ndak nee'aa dąį', ąįį gwanzhįh gwintsal hiłshii iłk'in ts'ą' nanzhit nahgwan niłshįį geh'an gwanzhįh navagaii aanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gwanzhįh valak kwaii khoh teiinjil ts'ą' gwitee niłshįį gaa khoh yinghan. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","9","Gaa valak kwaii chan nan nizįį kat niinjil ts'ą' gwinzii niłshįį, valat gaa vakat gwanzhįh 100 niłshįį, ch'izhii chan 60 ts'ą' ch'izhii chan 30. Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'!” ts'ą' Jesus t'agoovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ąįįtł'ęę Jesus vitsyaa nąįį giits'ą' haajil ts'ą' giiyųąhkat, “Nijin dinjii nąįį ts'ą' ginkhii dąį' jaghaii gwandak ąhtsii zhit geech'ǫąąhtan?” Giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus jyaa gavahnyąą, “Zheekat Gweegwinii'ee nagwaan'įį nakhwantł'eegwiriin'ąįį t'oonchy'aa, gaa geedan ąįį nakwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Zhit juu jidii gwii'įį, ąįį gwandaa vantł'ee neegwireheelyaa t'oonchy'aa, jyąhts'ą' gwik'iighai' gwandaa t'ąąnchy'aa hee'yaa ts'ą' vandaa t'agwahaanchy'aa, ąįįts'ą' juu vaa ch'akwaa, akwat, jidii tsal zhrįh gwii'įį ji' gaa, vits'į' neerahoondal t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jii geh'an gwandak vaageech'oorahtan t'aałchy'aa t'ishi'in, nijin goots'ą' giihkhii dąį'. Gwinzii googwąąh'in ji' gaa gwinzii goovaa gweheechy'aa kwaa eenjit ąįįts'ą' chan gwinzii ch'agoołk'įį ji' gaa deegwinyąą t'igwinyąą gaageheendaii kwaa eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ąįį geh'an yeenii Vit'eegwijyąhchy'aa Eenjit Ginkhii, Isaiah deiinyą' ąįįt'ee gooveenjit t'iinyą', ‘Jii dinjii nąįį gwinzii ch'igiheetth'ak gaa deegwinyąą t'igwinyąą gaageheendaii kwaa ts'ą' dagandee haa gwagwah'in gaa gwinzii goovaagweech'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Jii dinjii nąįį łi'deegwidlii gwinzii gaageheendaii geenjit gwik'eegwagwandaii kwaa ts'ą' goodzee gwanlii gaa jidii gwigwiitth'ak deegwinyąą t'igwinyąą gaagiindaii kwaa, jidii łi'deegwidlii gaagoondaii giindhan kwaa geh'an dagandee haa gwagaah'in kwaa k'it chan t'oonchy'aa, jyaa digii'in kwaa ji' gwinzii deeshi'in gaageheendaii ts'ą' shatr'agwaanduu gwanlii ginyąą ji' neegoohałshii t'oonchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Gaa nakhwan ąįį łyaa nakhwats'ą' gwinzii goodlit, nakhwandee haa gooh'in ts'ą' nakhwadzee haa goohtth'ak geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Datthak ts'ą' łi'haa nakhwaa gwaldak, Vit'eegwijyąhchy'aa Eenjit Ginkhii lęįį nąįį ts'ą' Vit'eegwijyąhchy'aa vigii nąįį haa jidii gǫǫh'ya' ąįį datthak ts'ą' gwarooh'ya' giindhan gaa gwagwąąh'ya' kwaa, ts'ą' jidii gohtth'ak chan gwarootth'ak giindhan gaa gwigwiitth'ak kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Dinjii gwanzhįh gwiteiinlii vagwandak ałtsii oodǫǫhk'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Juu Gwandak Nizįį zhit Vit'eegwijyąhchy'aa Veegwinii'ee eegwiitth'ak gaa deegwinyąą t'igwinyąą gaagiindaii kwaa, nąįį t'ee, tąįį gwinjik gwa'an gwanzhįh li' naadhak k'it t'iginchy'aa ts'ą' ch'anky'aa tr'aanduu gwanzhįh li' goodrii zhit gwats'an goots'į' yuundak t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ch'izhii dinjii nąįį chan gwanzhįh kii tee gwa'an niinjil k'it t'igiinchy'aa, Vit'eegwijyąhchy'aa Viginjik giitth'ak gwagwahkhan geenjit łyaa shoo ginlii, ");
INSERT INTO gwiNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","gaa gwint'aii gwagoontą' kwaa, ts'ą' nijin Gwandak Nizįį goovaagogwantrii ts'ą' khaiinjich'agoorahkhit dąį' niighit kwaa gwats'ą' gwizhrįh gwagoontą' ts'ą' akhagagoonjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ch'izhii dinjii nąįį gwanzhįh khoh tee niinjil k'it t'igiinchy'aa. Jii nąįį t'ee Vit'eegwijyąhchy'aa viginjik giitth'ak, gaa dzaa nankat nats'ąą gwigweheendaii geenjit gwizhrįh ninjich'agadhat ts'ą' laraa chan gihił'ee ts'ą' geedan deegoo'ya' giindhan gwizhrįh gwik'it t'igii'in ts'ą' Vit'eegwijyąhchy'aa viginjik eenjit gwitr'it t'agwagwah'in kwaa, ts'ą' gwanzhįh vakat gwąąhshii kwaa k'it t'igiinchy'aa ");
INSERT INTO gwiNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Gaa ch'izhii dinjii nąįį, gwanzhįh łųh nizįį kat niinjil t'ee, Vit'eegwijyąhchy'aa Viginjik, gwiinzii giitth'ak ts'ą' digidrii zhit giiyųųntą' Vit'eegwijyąhchy'aa k'eegwagwahthat geh'an goohaa gwintł'oo nahshii yahtsik. Valat 30, valat 60 ąįįts'ą' valat 100 jii jyaa daanchy'aa yahtsik.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus gwandak ch'izhii vaageech'oorahtan gavaa gwaandak, “Zheekat Gweegwinii'ee t'ee jii k'it t'oonchy'aa. Dinjii gwanzhįh nahshii, gwanzhįh deek'it gwanzhįh nizįį gwit'eiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ch'ihłan tǫǫ juu nąįį tthak iłchųų gwiizhit, dinjii yitr'ii'ee gwanzhįh deek'it gwanzhįh li' iizųų gwit'eiinlii ts'ą' gihłeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nijin gwanzhįh nizįį nahshii dąį' vitsii gwąąhshii gwiizhit chan gwanzhįh iizųų chan khaheełshii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Gwiizhit ąįį dinjii va-slaves nilii nąįį giits'ą' haajil ts'ą' t'igiiyahnyąą, ‘Shik'eedeegwaadhat, gwanzhįh nizįį gwit'ehrinlii, gaa jii gwanzhįh iizųų nats'ahts'ą' gwitee t'iizhik t'inchy'aa?’ ");
INSERT INTO gwiNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Juu shitr'ii'ee t'iizhik t'oonchy'aa.’ goovahnyąą. Ąįįts'ą' t'igiiyahnyąą, ‘Oo'an gwats'ą' tr'ahoojyaa ts'ą' gwanzhįh iizųų kharoolyaa diinoiinyaa?’ giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Nakwaa, zhit gwanzhįh iizųų khohłii ji' duulee gwanzhįh nizįį chan vaa khahoohłyaa t'oonchy'aa!’ gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Jyaa dohthan, gwanzhįh kharilii ji' nihłaa khareheelyaa geenjit, izhit ji' sha-slave nąįį tł'oo iizųų tr'ookit khohłii gavahaihjyaa, ąįįts'ą' datthak nihłaa dohchaa ts'ą' ohk'an ts'ą' zhit tł'oo li' nizįį ąįį shadraa zhit gwizhit nihdǫhłii goovahihjyaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus chan hee ch'izhii gwandak ąhtsii haa geech'ǫąąhtan goovaagwandak, “Zheekat Gweegwinii'ee jii k'it doonchy'aa t'oonchy'aa. Dinjii mustard seed oonjik ts'ą' gwanzhįh deek'it gwit'eeyin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ąįį seed ch'andaa t'ahtsal nilii, gaa nijin khaniłshii dąį' gwanzhįh ch'andaa t'ahtsii nilii ts'ą' ts'iivii nitsii dhidlit. Dachan choo hee dhidlit ts'ąįį, dziitsal kwaii gaa yatthoochan kat t'oh ąhtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus chan hee ch'izhii gwandak ąhtsii haa geech'ǫąąhtan goovaagwaandak: “Zheekat Gweegwinii'ee jyaa doonchy'aa t'oonchy'aa. Tr'injaa tyah choo zhit łųh deedąą'ąį' tee łųh vaaniituu tsal gwiteiinjaa, ąįįtł'ęę ąįį łųh datthak niłshįį.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus, khit ts'ą' jii k'it t'inchy'aa gwandak kwaii vaageech'aroahtan haa gweedhaa datthak juu yaa łinaadal nąįį haa gwaandak, vaa geech'arǫąąhtan gwandak zhrįh haa goots'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Vit'eegwijyąhchy'aa Eenjit Ginkhii yeenii deeginyąą łi'deegwidlii gweheelyaa geenjit jyaa digeenyą', “Nijin goots'ą' giihkhii dąį' gwandak deegwinyąą t'igwinyąą nagwąąh'įį zhit geegoovahałchyaa t'eehałchy'aa. Jii nan goodlit dąį' gwats'an nijin gaagiindaii kwaa geenjit gavaa gwahaldak t'igiinchy'aa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nijin Jesus, zhit dinjii łeeljil nąįį iłeehoozhii ts'ą' zheh nihdeiinzhii dąį' vitsyaa nąįį t'igiiyahnyąą, “Jii gwandak vaageech'oahtan ąįį gwanzhįh tr'ąąhshii deek'it jaghaii tł'oo iizųų chan niłshįį, diihaa gwandak?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus t'agavahnyąą, “Zhit dinjii juu gwanzhįh nizįį gwit'inlii t'ee Gwidinji' t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jii gwanzhįh deek'it ąįįt'ee jii nankat t'agwarahnyąą, ąįįts'ą' zhit gwanzhįh nizįį gwit'eerinlii ąįįt'ee Vit'eegwijyąhchy'aa Veegwinii'ee gwats'an dhidlit t'oonchy'aa. Ąįįts'ą' zhit gwanzhįh deek'it tł'oo iizųų gwit'eh giinlii ąįį nąįį t'ee Ch'anky'aa Tr'aanduu ts'an dhidlit t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Zhit juu nits'į' t'inchy'aa nitr'ii'ee ts'ą' tł'oo iizųų gwiteiinlii ąįįt'ee Ch'anky'aa Tr'aanduu t'inchy'aa. Zhit gwanzhįh kharilii ąįįt'ee nankat ndaagwąą'ąį' drin zhit t'oonchy'aa. Ąįįts'ą' zhit juu gwanzhįh khalii ts'ą' geetr'agwaah'in nąįį t'ee zheekat gwich'in nąįį t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Juk gweendaa jii nankat gwanzhįh tł'oo iizųų khaihłan nigilii ts'ą' kǫ' zhit giiyahk'an k'it nankat ndaagwąą'ąį' drin zhit ji' t'ee jyaa digwehee'yaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ąįįtł'ęę Gwidinji' Diveegwinii'ee gwats'an dizheekat gwich'in nąįį yeenjit juu dinjii nąįį ch'izhii dinjii nąįį tr'agwaanduu t'igii'in ąhtsii ts'ą' dinjii dagakhai' tr'agwaanduu t'ii'in nąįį datthak khaihłan nagoogiheelyaa ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","datthak ts'ą' ch'iitsii zhit gwak'an gwizhit googiheelyaa, gwintł'oo khaiinjich'igiheeghit haa izhit t'ee gwintł'oo giheetree ts'ą' dagagho' nihts'ą' łagahoon'al haa neegiiyik'ii k'it t'igihee'yaa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ąįįtł'ęę t'ee juu Vit'eegwijyąhchy'aa ts'an dhidlit nąįį Zheekat Gooti' Veegwinii'ee zhit shree adrii k'it t'igiheechy'aa. Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'!” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Zheekat Gweegwinii'ee jyaa doonchy'aa t'oonchy'aa. Dinjii ch'ihłak gwanzhįh deek'it treasure agwąh'ąįį ts'ą' it'ee shrit shoodhidlit ts'ąįį, jidii di'įį datthak tr'oonkwat gwiłtsąįį ąįįtł'ęę oo'an neehoozhii ts'ą' ąįį gwanzhįh deek'it goiinkwat.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ąįįts'ą' chan Zheekat Gweegwinii'ee jyaa doonchy'aa t'oonchy'aa. Dinjii ch'ihłak pearl nizįį kwaii kantii, ");
INSERT INTO gwiNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ts'ą' nijin pearl łahchy'aa ch'andaa nizįį agwąh'ąįį dąį', jidii di'įį datthak tr'oonkwat gwiłtsąįį ts'ą' zhit pearl oiinkwat.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ąįįts'ą' chan hee Zheekat Gweegwinii'ee jii k'it doonchy'aa t'oonchy'aa. Dinjii łuk kee'in lat nąįį digichihvyaa, van kat oondaa chagahtsuu ts'ą' łuk nihłehts'į' t'iichy'aa datthak vizhiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nijin chihvyaa zhit łuk deedaan'ąįį goodlit dąį' chihvyaa khaneegahtsuu ts'ą' zhat giilk'ii ts'ą' łuk nihtee tr'igilii, jidii łuk nizįį kwaii tyah lęįį zhit ginlii ts'ą' łuk ginilih kwaa, kwaii oo'an gihiłjil. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nankat ndaagwąą'ąį' drin zhit ji' t'ee jyaa digweheenjyaa t'oonchy'aa. Zheekat gwich'in nąįį dinjii tr'agwaanduu tr'agwah'in nąįį dinjii nizįį nąįį ts'an tee tr'agoogiheelyaa, ts'ą' khaihłan nagoogiheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ts'ą' nijin gooveenjit ch'iitsii choh zhit gwak'an, ąįį zhit gwizhit googiheelyaa ts'ą' gwintł'oo giheetree ts'ą' dagagho' nihts'ą' łagahoon'al haa neegiiyik'ii k'it t'igihee'yaa t'iginchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Jii deihnyąą datthak deihnyąą t'ihnyąą gaakhwandaii?” Jesus gavahnyąą. “Aahą'.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ąįįts'ą' t'ee chan hee t'agavahnyąą, “Zhit juu Jews goo-law eech'ǫąąhtan nąįį datthak Zheekat Gweegwinii'ee zhit gwats'an gaadlit ts'ą' t'ee zhat zheh gwigwii'įį k'it t'oonchy'aa, ts'ą' dadraa zhit gwizhit k'eiich'i' k'eejit ts'ą' yeenii gwats'an k'eiich'i' gwizhit iłdlii kwaii datthak vit'eegwahahchy'aa geenjit tth'aii hee nizįį k'it t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nijin Jesus, gwaandak kwaii haa geech'ǫąąhtan haa ndaanaahjik dąį', zhat gihłeehoozhii, ");
INSERT INTO gwiNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ts'ą' nijin dink'iindhat, gwits'ee hoozhii. Ts'ą' Jews tr'igiinkhii zheh gwizhit geegoovąąhtan, akhai' juu yiitth'ak nąįį gooveenjit łyaa geegwaroolii kwaa t'igwinyąą, “Jii dinjii nijin gwats'an vigwizhi' gwanlii t'inyąą?” giiyahnyąą “Nats'ahts'ą' gwigweech'in t'ii'in t'ii'in?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Dinjii dachan haa gwahtsii nilii ąįį vidinji' lee t'inchy'aa? Vahan Mary oozhii lee t'inchy'aa? Ąįįts'ą' James, Joseph, Simon ts'ą' Judas nąįį haa vachaa nąįį lee t'inchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Vijuu nąįį datthak dzaa gwigwich'įį lee t'iginchy'aa? Nijin gwats'an jii gwigwee'in ts'ą' ginjik jiintsii kwaii datthak oonjik t'ii'in?” giiyahnyąą ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","giits'į' t'inchy'aa, ts'ą' giit'injyah'ee. Ąįįtł'ęę Jesus t'agavahnyąą, “Juu Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii nijuk datthak giiyihił'ee gaa vanahkat ts'ą' vizheh k'ąą nąįį datthak giits'į' t'inchy'aa ts'ą' giiyihił'ee kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gwik'injigiighit kwaa geh'an izhit Nazareth gwizhit gwintł'oo gwigwee'in jiintsii t'ee'ya' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Izhit dąį' k'eedeegwaadhat choh (King) Herod Antipas ąįį Galilee gwats'ą' k'eedeegwaadhat nilii, ts'ą' Jesus eenjit gwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ąįįts'ą' dinjii yeenjit tr'agwah'in nąįį t'ahnyąą, “John chųų gwats'an ąhtsii, ąįį niindhat gwats'an khakee'ąįį! Ąįį geh'an gwigwii'in t'ihee'yaa geenjit t'aih di'įį t'inchy'aa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Izhit gwehkįį dąį' Herod Antipas, John chųų gwats'an ąhtsii oonjik ts'ą' zheh gwaazhrąįį niyąąhchįį ts'ą' ch'iitsii tły'ah haa digiiyiłchaa yeenjit gwiłtsąįį. King Herod dachaa Philip, va'at noonjik geh'an jii jyaa digiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","John chųų gwats'an ąhtsii gweedhaa datthak jii jyaa yahnyąą geh'an, “Herodias noodhinjik ąįį dii-Law łaahnaii t'ini'in t'oonchy'aa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod łyaa yęhdaa tr'agoo'aa yuunyąą, gaa Jews nąįį aanjat. John chųų gwats'an ąhtsii, ąįįt'ee Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii giiyuunyąą geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gaa nijin Herod, vagoodlit drin nagwiindhat dąį', Herodias vigii nich'it juu zhat dilk'ii nąįį eenjit ch'aadzyaa ts'ą' łahchy'aa Herod shoo iłtsąįį, ");
INSERT INTO gwiNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ąįįtł'ęę nich'it t'ahnyąą, “Jidii niindhan datthak nik'ee gwahałthat t'oonchy'aa.” yahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Vahan Herodias, deiinyąą yahnyąą ąįį gwik'it t'iiyahnyąą, “Dzaa, juk zhat, John chųų gwats'an ąhtsii viki' k'ik kat deedhin'ąįį ts'ą' shantł'eiin'ąįį,” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King Herod łyaa tr'igwidii gaa ch'adąį' hee dinjii lęįį łeeljil nąįį tee jidii niindhan ąįį nihk'it shi'yaa yahnyąą chy'ah ąįį diniveet'ah'in nąįį gwik'it t'akhwa'in ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ąįįts'ą' zheegwaazhrąįį dhidii gwiizhit John viki' k'eech'igiint'uu. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ąįįts'ą' t'ee giiki' k'ik kat deedha'aii ts'ą' zhit nich'it antł'eegiiyin'ąįį, ąįį nich'it chan ants'ą' dahan antł'eeyin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John, chųų gwats'an ąhtsii, vitsyaa nąįį giich'ichį' gihłeehiłchįį ts'ą' giinąąhjik, ąįįtł'ęę Jesus ts'ą' gahaajil ts'ą' giiyaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nijin Jesus, John vagwandak goodlii gwiitth'ak dąį', ditsyaa nąįį haa tr'ihchoo haa gihłeegahoojil ts'ą' tthan gwa'an gwats'ą' gahahjil. Dinjii nąįį datthak giiyeegwiitth'ak dąį' dagakwaiik'it gihłeegahaajil ts'ą' nankat deetaa giitąįį haajil. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nijin Jesus, zhat teedhizhii dąį', dinjii lęįį nąįį łeeljil nah'in ąįįts'ą' didrii zhit gooveenjit tr'igwidii ts'ą' gootee juu iłts'ik nąįį shrineiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nijin khaa nagwaanąįį dąį' vitsyaa nąįį yats'ą' haajil ts'ą' t'igiiyahnyąą, “Tr'ihkhit tǫǫ gwilii ts'ą' dzaa łyaa tthan goo'aii. Jii dinjii nąįį oo'an neekhwajyaa gooraihnyąą ts'ą' kwaiik'it gwa'an ideenjit shih ohkwat gooraihnyąą.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus t'agoovahnyąą, “Oo'an neegeheenjyaa gwit'eegaahchy'aa kwaa, nakhwan ąįį giihee'aa goovantł'ohtsit!” ");
INSERT INTO gwiNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","“Łųhchy'aa ch'ihłoanli' (5) ts'ą' łuk dhichy'aa neekwaii zhrįh tr'ii'įį!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Ąįį shantł'ohłii!” Jesus nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Dinjii nąįį tł'oo kat dook'įį goovohnyąą, Ąįįtł'ęę Jesus, zhit łųhchy'aa ch'ihłoanli' (5) ts'ą' łuk neekwaii haa tee gwiłjik ts'ą' zheekat k'iidak gwąąh'in ts'ą' Vit'eegwijyąhchy'aa “Mahsį' choh!” ahnyąą. Ąįįtł'ęę łųhchy'aa kwaii khadinzhuu ts'ą' ditsyaa nąįį antł'eeyinlii, gwitee giiyeeheelyaa eenjit. Łuk kwaii chan gwik'it t'inlik ts'ą' gwitee giiyaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Juu nąįį datthak ch'anahoo'al. Ąįįtł'ęę vitsyaa nąįį tł'ootyah ch'ihłoaatin ants'ą' neekwaii tr'ooniindhat tineegwigwįłjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Tr'injaa ts'ą' tr'iinin nąįį tr'eechyaa kwaa, haa dinjii 5,000 aanchy'aa nąįį ch'iin'al. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ąįįtł'ęę Jesus, ditsyaa nąįį tr'ihchoo zhit inlii ts'ą' giiyehkii van ndųhts'ąįį gwats'ą' gahaajil gooviłtsąįį. Adan tth'aii zhat dhidii gwiizhit dinjii łeeljil nąįį nakhwazheh gwits'ee khwajyaa goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Dinjii nąįį datthak oo'an nakhwazheh gwits'ee khwajyaa ahnyąą ąįįtł'ęę taih kat deedhizhii ts'ą' adan zhrįh khagidiinjii. Nijin tǫǫ nigwiindhat dąį' Jesus adan zhrįh zhat t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ts'ą' zhat dąį' it'ee ąįį tr'ihchoh van tł'an hee dhitin, ts'ą' chųų tit choh haa zhat gwa'an neehiilak, veiintr'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Vanh dąį' 3 AM ts'ą' 6 AM gwideetak gweedhaa gwiizhit Jesus vitsyaa nąįį chųų kat goots'ą' ahaa nigiiyiił'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nijin chųų kat ahaa nigiiyiił'in dąį' łahchy'aa gąąnjat, nagaanaii ts'ą' t'iginyąą, “Ch'anky'aa t'ii'in!” ginyąą gwiizhit gihilghaa ts'ą' gwint'aii gazhral. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesus, zhat gwagwahkhan goots'ą' khagiinkhee, “Shįį t'ishi'in! Noojat kwaa ts'ą' nooht'aii!” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ąįįtł'ęę Peter, khagiinkhee ts'ą' t'iiyahnyąą, “K'eegwaadhat, nan t'inchy'aa ji' chųų kat nats'ą' hihshyaa geenjit akwat jyaa shaiinyąą!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus yats'ą' khagiinkhee ts'ą' “Aanaii!” yahnyąą, ts'ą' t'ee Peter tr'ihchoh zhit gwats'an tr'iinzhii ts'ą' chųų kat Jesus ts'ą' ahaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gaa nijin gwint'aii ahtr'aii gik'aanjik dąį' naajat naanaii ts'ą' chųų zhit teet'aaghyii gwiizhit jyaa nyąą, “K'eegwaadhat shits'iinyąą!” nyąą ts'ą' khatree'iintrat. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Zhat gwagwahkhan Jesus danli' k'iindaa t'inlik ts'ą' neeyahtsit ts'ą' t'inyąą, “Łyaa nigwik'iinjigwiighit natsal, jaghaii zhyaa tr'adashoiinlii?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Nijin tr'ihchoh zhit neegeejil dąį' ahtr'aii neet'aanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ąįįtł'ęę vitsyaa nąįį tr'ihchoh zhit giits'ą' nikiigwiintthaii ts'ą' ginjik nint'aii haa jyaa ginyąą, “Łahchy'aa łi'deegwidlii haa Vit'eegwijyąhchy'aa Vidinji' inlii łee.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Van ndųhts'ąįį neegiinjil ts'ą' Gennesaret kwaiik'it deeginjil, ");
INSERT INTO gwiNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","dąį' zhat gwich'in nąįį Jesus juu t'inchy'aa gaagiindaii. Ąįįts'ą' ąįį dinjii nąįį, geelin nahkat gwats'an iłts'ik nąįį datthak Jesus ts'ą' gahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ąįįtł'ęę iłts'ik nąįį Jesus ts'ą' ch'oodigiikwat, “Ni'ik eelin gaa kat khan narahaandal shrǫ'?” giiyahnyąą. Juu yakat naanjik nąįį datthak shrineegaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ąįįtł'ęę Pharisee, ts'ą' Law eech'ǫąąhtan nąįį lat haa, Jerusalem gwats'an gahaajil ts'ą' Jesus goahkat, ");
INSERT INTO gwiNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Jaghaii nitsyaa nąįį yeenii diitsii nąįį jidii eech'agwaahtan ąįį gwik'it t'igii'in kwaa? Ch'igihee'aa gwehkįį diinanli' geech'arahtryaa, jaghaii gwik'it t'igii'in kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus t'agoovahnyąą, “Jaghaii, Dęhtły'aa Choo zhit Vit'eegwijyąhchy'aa deenakhwahnyąą ąįį gwik'it t'akhwa'in kwaa gwiizhit yeenii nakhwatsįį nąįį jidii geenakhwagǫǫłtin ąįį gwik'it t'akhwa'in? ");
INSERT INTO gwiNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Akwat Vit'eegwijyąhchy'aa jyaa nyąą, ‘Niti' ts'ą' nakhan haa khadhoo'ee!’ ąįįts'ą' chan, ‘Niti' ts'ą' nakhan nąįį ts'ą' gwiizųų gohkhyaa shrǫ', jii gwik'it t'ini'in kwaa ji' t'ee nęhdaa tr'igwirehee'aa goo'aii!’ gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Gaa, nakhwan ąįį jii jyaa dohnyąą ts'ą' geech'oohtan, nakhwati' ts'ą' nakhwakhan haa jidii t'eegąhchy'aa ni'įį ji' gaa datthak Vit'eegwijyąhchy'aa veenjit dohnyąą ąįįtł'ęę, ");
INSERT INTO gwiNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Nakhwati' ts'ą' nakhwahan haa goots'ohnyąą k'iighai' khadhoo'ee gwat'oohchy'aa kwaa, dohnyąą. Jii jyaa dohnyąą haa nakhwan ąįį law ideenjit ohtsii ts'ą' geech'oohtan, jii jyaa dakhwa'in ts'ą' Vit'eegwijyąhchy'aa va-law ąįį zhyaa k'it ǫhjii. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Juu dinjii nizįį adaa'įį nąįį! Yeenii Isaiah ąįį łyaa k'igwąą'ee ts'ą' ginkhii t'inyąą łee, nijin jyąhts'ą' nakhweeginkhii dąį'! ");
INSERT INTO gwiNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Jii nankat gwich'in nąįį digiginjik haa shigihił'ee, Vit'eegwijyąhchy'aa nyąą gaa łahchy'aa tr'ihkhit goodrii zhit shats'ą' niighit dha'aii t'iginyąą, gavahnyąą! ");
INSERT INTO gwiNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Dzaa nankat gwa-law eech'agǫąąhtan, ąįį Sha-law k'it giiyuunjii geh'an. Shats'ą' nikiigwagwah'ee ts'ą' khadigigiinjii gwit'eegaahchy'aa kwaa t'igiinchy'aa.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ąįįtł'ęę Jesus, zhit juu yaałeeljil nąįį aanaii ahnyąą ts'ą' adats'ą' nagoovinlii ts'ą' t'agavahnyąą, “Ch'oodǫǫhk'įį deegwinyąą t'igwinyąą, gahahkhwandaii geenjit! ");
INSERT INTO gwiNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jidii nakhwaghit gwik'ijyaa, ąįįt'ee shroodiinyąą kwaa nakhwahtsii kwaa, gaa jidii nakhwaghit tr'ijyaa ąįįt'ee shroodiinyąą kwaa nakhwahtsii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ąįįtł'ęę t'ee vitsyaa nąįį yats'ą' niinjil ts'ą' t'igiiyahnyąą, “Jii jyaa diinyąą geh'an Pharisee nąįį gootthąį' iizųų dhąhtsąįį nyąą gaanandaii?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus t'agoovahnyąą, “Jidii gwanzhįh datthak Zheekat Shiti' yeelshih kwaa kwaii datthak nan ts'an kharaheelyaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gooveenjit tr'agohdii kwaa, geedan gavandee kwaa ts'ą' juu vandee kwaa nąįį eenjit kįh giilk'ii t'iginchy'aa, ts'ą' nijin dinjii ch'ihłak gwąąh'in kwaa dąį', nihłigeen'aa ts'ą' nihłaa tąįį gwinjik łųh khariindhat (ditch) gwizhit t'eegahaadhal t'igiinchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter, jyaa nyąą, “Jii deiinyąą t'iinyąą diihaa gwandak.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus, t'agavahnyąą, “Nakhwan gaa tth'aii hee gook'it nakhwagwizhi' gwanlii kwaa lee t'ohnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Deihnyąą t'ihnyąą nik'ee gaakhwandaii? Jidii nakhwaghit gwik'ijyaa ąįįt'ee, nakhwatthąį' zhit t'injik ąįįtł'ęę nakhwatthąį' ts'an an ilik. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gaa jidii nakhwaghit gwats'an tr'ijyaa ąįįt'ee nakhwadrii ts'an t'igwii'in, ts'ą' jidii gwiizųų t'ohnyąą kwaii t'ee shroodiinyąą kwaa nakhwahtsii t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Dinjii ęhdaa tr'agǫh'ak, veedhoodii kwaa haa dhoochįį ąįįts'ą' ch'ijuk datthak nakhwatthąį' haa tr'agwaanduu nakhwagwitr'it gwanlii, ts'ą' ch'oh'įį, ts'ą' ohts'it ąįįts'ą' dinjii oozhri' iizųų hohtsyaa geenjit ohts'it, jii kwaii t'ee nakhwadrii zhit gwats'an tr'agwaanduu t'akhwa'ya' nohthan ts'ą' ąįį gwik'it t'akhwa'in, t'akhwa'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ąįį kwaii t'ee shroodiinyąą kwaa nakhwahtsii gaa nats'ahts'ą' nakhwanli' k'eech'ohtryaa nakhwagahnyąą, ąįį gwik'it t'akhwa'in kwaa ts'ą' shih oh'aa kwaii shroodiinyąą kwaa nakhwahtsii kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus zhat gwats'an gihłeehoozhi' ts'ą' Tyre ąįįts'ą' Sidon kwaiik'it gwachoo nahkat gwa'an gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jii tr'injaa, Canaan gwich'in nilii, ąįį zhat nahkat gwa'an gwich'įį, ąįį yats'ą' haazhii, ts'ą' yats'ą' khashraa'iintrat, “Yeenii King David vidinji'! K'eegwaadhat, neeshraahchy'aa shǫįįnyąą, shigii nich'it tsal ch'anky'aa iizųų vizhit t'inchy'aa ts'ą' łahchy'aa vaa gwiizųų ts'ą' yaa khaiinjich'iighit!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Googaa nihk'it Jesus ginjik haa yats'ą' khaginkhee kwaa. Vitsyaa nąįį yats'ą' haajil ts'ą' giich'oodiikwat, “Zhyaa diitąįį neehihdik ts'ą' tr'ihkhit gwintł'oo deegwaahtsai', t'oohłii neehiindii vaiinyąą!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ąįįtł'ęę Jesus ditsyaa nąįį t'ahnyąą, “Israel gwich'in nąįį tee juu divii k'it gavaatr'igweendaii nąįį eenjit gwizhrįh dzaa nankat gwats'ą' shirihił'e' t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jyaa nyąą gwiizhit ąįį tr'injaa yakwai' ehzhee natroogwiintthaii ts'ą' t'iiyahnyąą, “K'eegwaadhat, shits'iinyąą!”, yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus yats'ą' khaginkhee, “Tr'iinin nąįį gooshii łąįį ts'ą' tr'ahaathak ąįį gashragwaahchy'aa kwaa t'oonchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“K'eegwaadhat, łyaa łi'deegwidlii t'iinyąą t'oonchy'aa gaa łąįį nąįį ąįį juu goots'ą' k'eedeegwaadhat ąįį shįį vakaii'aa ts'an nihjyaa kwaii ga'aa t'igii'in.” yahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ąįįtł'ęę Jesus t'iiyahnyąą, “Łyaa tr'injaa vik'injigwiighit jiintsii iinlii, deeyiindhan gwik'it gweheelyaa t'oonchy'aa.” yahnyąą. Zhazhat gwagwahkhan vigii nich'it tsal veenjit gwinzii neegahoodlit ts'ą' shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus zhat gwats'an gihłeehoozhii ts'ą' Galilee vanvee k'ii'an haazhii ts'ą' taih kat k'iidak hadhizhii ts'ą' naadii. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Dinjii lęįį nąįį łigeeljil ts'ą' Jesus ts'ą' nigiinjil, juu neehihdik kwaa, juu vandee kwaa, juu vatthąį' iłchįį nilii nąįį, juu ginkhii kwaa, ąįįts'ą' ch'izhii lęįį nąįį ts'ik nihłehts'į' t'iichy'aa haa iłts'ik nąįį datthak giits'ą' haadlii ts'ą' Jesus, vakwai' ehzhee nagoogiinlii, ts'ą' datthak shrineegooviinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Zhat dinjii nąįį łahchy'aa gooveenjit geegagoolii kwaa t'igwiizhik, nijin juu ginkhii kwaa, nąįį ginkhii needhidlit, ts'ą' juu vatthąį' iłchįį nilii nąįį chan shrininlik ąįįts'ą' juu neehihdik kwaa nąįį chan neehihdik niłtsąįį, ąįįts'ą' juu vandee kwaa nąįį chan gwąąh'in niłtsąįį, zhat gwich'in nąįį jii gwagwaah'in dąį' Israel gwich'in Goovit'eegwijyąhchy'aa nilii ąįįts'ą' datthak deegiiyihiił'ee. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus, ditsyaa nąįį aanaii ahnyąą ts'ą' adats'ą' nagaviinlii, ts'ą' t'agavahnyąą, “Jii dinjii nąįį łyaa gooveenjit tr'igwihdii, juk łyaa drin tik datthak shaa giilk'ii gwiizhit tth'aii hee gaa ch'aga'aa kwaa ts'ą' tr'ihee'aa chan gii'įį kwaa. T'oohłii neegahoojyaa gavoiinyąą kwaa, digizheh gwats'ą' neegeedaa gwiizhit duulee oo'an t'eegahaadhal geh'an t'ihnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“Dzaa nangwinjir gwa'an nijin shih lęįį goorahah'aa tr'ooheendal t'iinyąą?” Vitsyaa nąįį yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Łųhchy'aa daanchy'aa khwa'įį?” Jesus gavahnyąą. “Łųhchy'aa 7 ts'ą' łuk nitsya' chan tr'ii'įį.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ąįįts'ą' Jesus zhit juu łeeljil nąįį nankat dhook'ii ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ąįįtł'ęę łųhchy'aa 7 ts'ą' łuk haa oonjik ts'ą' Vit'eegwijyąhchy'aa mahsį' ahnyąą ąįįtł'ęę nihtr'iyiiłnaii ts'ą' ditsyaa nąįį antł'eeyiinlii ts'ą' vitsyaa nąįį ants'ą' gwitee giiyiłts'ik. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ąįįts'ą' datthak ch'igiin'al ts'ą' goozhit gwiłts'ik kwaa. Gwiizhit vitsyaa nąįį ch'ityah 7 zhit shih deedąą'ąį' tr'ooniindhat tineegwigwįłjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Dinjii 4,000 nąįį ch'in'al, tr'injaa ts'ą' tr'iinin nąįį haa geechyaa kwaa t'iginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ąįįtł'ęę Jesus, zhat dinjii dilk'ii nąįį datthak oo'an nakhwazheh gwits'eekhwajyaa gavahnyąą, ts'ą' tr'ihchoh zhinzhii ts'ą' Magadan nahkat gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisee ts'ą' Sadducee nąįį lat Jesus ts'ą' gahaajil, goodhaii nigiiyahaahthal geenjit gwankee gwagwaah'in, “Zheekat gwats'an gwigwee'in t'igwii'in diits'ą' gwagwaahkįį,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Gaa Jesus, jyaa gavahnyąą, “Nijin zheekat k'iidak gwaatsik gwizhit shree gwiky'aa'at dąį', ‘Hahtr'aii kwaa ts'ą' gweheezyaa,’ dohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nijin zheekat k'iidak gwaatsik ts'ą' tǫǫ goo'aii gwiizhit vanh khach'a'ąįį dąį' hee, ‘Chan hahtsin t'oonchy'aa,’ dohnyąą. Ehjyaa t'oonchy'aa ts'ą' deegweheechy'aa gaakhwandaii, k'iidak zheekat gwats'ą' gooh'in dąį' t'ee ehjyaa deegweheechy'aa gaakhwandaii, gaa jii gwigwii'in t'igwii'in ąįį juk gweendaa tth'aii hee khyų' gwiky'uunjii! ");
INSERT INTO gwiNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Juk gweendaa gwidinjii nąįį łyaa tr'ihkhit gwik'injigiighit kwaa ts'ą' tr'agwaanduu gwizhrįh googwitr'it gwanlii! Nakhwan gwigwii'in eenjit ch'oohkat? Nakwaa, duuyeh nakhweenjit gwigwii'in t'ishi'in ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii Jonah, deezhik gwik'it gwizhrįh gwigwii'in gahǫǫh'yaa t'oonchy'aa.” gavahnyąą, ts'ą' goołeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nijin vitsyaa nąįį van ndųhts'ąįį nigiinjil dąį' łųhchy'aa gahoondal gineegildee łee ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus, t'agavahnyąą, “Pharisee ts'ą' Sadducee nąįį goołuh niituu ts'į' gwinzii adak'ǫǫntii.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ąįįts'ą' nihłihtee jyaa ginyąą, łųh chy'aa tr'oonjik kwaa geh'an t'inyąą giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus, deeginyąą gavaandaii ts'ą' t'agavahnyąą. “Jaghaii zhyaa łųhchy'aa khwa'įį kwaa geenjit nihłaa gookhii? Nakhwak'injigwiighit łahchy'aa nitsii kwaa t'agwarahnyąą! ");
INSERT INTO gwiNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nijin ji' gwik'eehoondal t'oonchy'aa? Nijin dąį' nakhwandah łųh chy'aa 5, dinjii 5,000 nąįį eenjit khadidhiizhuu nik'ee chan ganoondaii? Tyah daanchy'aa zhat dąį' deedąą'ąį' dhohtsąįį?” ");
INSERT INTO gwiNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Dinjii 4000 nąįį łųhchy'aa 7 loaves aanchy'aa goovał'al ąįį yu', zhat dąį' ch'ityah daanchy'aa deedąą'ąį' dhohtsąįį? ");
INSERT INTO gwiNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nats'ahts'ą' chan łųhchy'aa eegiihkhii kwaa t'ihnyąą gaahahkhwandaii? Pharisee ts'ą' Sadducee nąįį goołuh niituu ts'į' adak'ǫǫntii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ąįįtł'ęę gǫhju' hee vitsyaa nąįį deenyąą t'inyąą giiky'aanjik, łųhchy'aa zhit łųh niituu ąįį t'ahnyąą giiyuunyąą, akhai' Pharisee ts'ą' Sadducee ąįį nąįį jidii eech'agwaahtan, ąįį gwits'į' adak'agahaantyaa t'inyąą łee giiky'aanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nijin Jesus, ditsyaa nąįį haa ąįį Caesarea Philippi geeghaih gwa'an kwaiik'it gwachoo goodlii gwats'ą' gahaajil, dąį' ditsyaa nąįį oahkat, “Dinjii nąįį juu Gwidinji' t'inchy'aa ginyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Vitsyaa nąįį t'iiyahnyąą, “Goolat nąįį John chųų gwats'an ąhtsii inlii nagahnyąą, ts'ą' ch'izhii nąįį chan Elijah akwat Jeremiah duulee inlii nagahnyąą, goolat nąįį chan ch'izhii Vit'eegwijyąhchy'aa Eenjit Ginkhii ch'ihłak inlii nagahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Nakhwan ąįį yu'? Juu t'ihchy'aa shoohnyąą?” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter t'iiyahnyąą, “Christ t'ee Messiah nilii t'ee nan t'inchy'aa, ts'ą' Vit'eegwijyąhchy'aa khit gwandaii nilii ąįį Vidinji' inlii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Simon, John vidinji' inlii haa łahchy'aa gwinzii t'iinyąą t'oonchy'aa. Jii łi'deegwidlii t'ee dzaa nankat dinjii nąįį ts'an oodhinjik kwaa, gaa Zheekat Shiti' nats'an yiłtsąįį t'inchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ąįįts'ą' jii naagwaldak Peter, nant'ee kii t'inchy'aa ąįį gwik'it dinjii inlii, ąįį kii kat t'ee shitr'igiinkhii zheh gwahałtsyaa, ąįįts'ą' ch'ichį' gaa duuyeh an yahtsii ts'ą' duuyeh gaiiyiigwagwahtsii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Zheekat Gweegwinii'ee gwats'an lidlįį nantł'eeheelyaa t'oonchy'aa, dzaa nankat gwats'an nakwaa diinyąą ji' zheekat chan nakwaa giheenjyaa t'oonchy'aa. Ąįįts'ą' jii nankat jidii geenjit aahą' diinyąą ji' zheekat chan aahą' giheenjyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesus, ditsyaa nąįį jii jyaa dahnyąą, Christ t'ihchy'aa ch'ihłak gaa haagoondak shrǫ'!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Izhit zhat gwats'an it'ee Jesus, ditsyaa nąįį deerahah'yaa gwinzii haa gwaandak, “Jerusalem gwats'ą' hihshyaa gwizhrįh goo'aii, ąįį zhit gwats'an Israel kįh dilk'ii nąįį ts'ą' giinkhih kįh dilk'ii nąįį ts'ą' Law eech'ǫąąhtan nąįį khaiinjich'ashagahahthat ts'ą' shęhdaa tr'igwigwehee'aa gaa drin tik gwahaadhat ąįįtł'ęę ch'ichį' ts'an neegwihįhdaii t'oonchy'aa.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter ąįį Jesus adan zhrįh nąąhchįį ts'ą' ginjik nint'aii haa yats'ą' ginkhii, “Vit'eegwijyąhchy'aa gwik'it gooli' shrǫ'! K'eegwaadhat, jii duuyeh nats'ą' jyaa digwinjii t'oonchy'aa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus, yats'ą' nil'ee ts'ą' Peter t'ahnyąą, “Satan, shihłeehiindii! Shats'ooghaii nindhat t'oonchy'aa, jii nats'ahts'ą' ninjich'iindhat Vit'eegwijyąhchy'aa vats'an t'oonchy'aa kwaa gaa dinjii ts'an jyaa diinyąą t'iinyąą.” Yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ąįįtł'ęę Jesus, ditsyaa nąįį datthak aanaii ahnyąą ts'ą' t'agoovahnyąą, “Nakhwatee juu shaa hoozhii niindhan ji' adanaandee ts'ą' nihk'ataa'ee (cross) dakat ichyaa ts'ą' shatąįį hahkhaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Juu dagwandaii, diyinji' haa intsai' ji' t'ee yaa shrihteegwehee'aa. Gaa juu shęh'an niindhat ąįįt'ee dagwandaii, diyinji' haa neehahshii. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dinjii jii nankat datthak ideenjit goonjik gaa viyinji' an dhidlit ji' ąįį dinjii nihk'it gaayiich'ahaahtsyaa shrǫǫ? Łyaa duuyeh! Akwat dinjii gweheendaii geenjit jidii gwantł'eehee'aa? ");
INSERT INTO gwiNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Gwiti' vich'eegwąhndit, ts'ą' vizheekat gwich'in nąįį ts'ą' Gwidinji' haa izhit ji' dzaa nankat gwits'eegiheedaa diitee gwagwaanchy'aa ts'ą' diigwitr'it t'agwarah'ya' geenjit diineegoheekwat. ");
INSERT INTO gwiNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Łi'haa t'anakhwaihnyąą, juk nakhwatee nakhwalat nąįį tth'aii gwandaii gwiizhit Gwidinji' Diveegwinii'ee haa needyaa gwahah'yaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Drin nihk'iitik gwahaadhat ąįįtł'ęę Jesus, Peter, John ts'ą' John vachaa James nąįį haa ddhah choh kat tthan goo'aii gwa'an gwats'ą' goovahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Aakin giiyaa'įį gwiizhit Jesus ch'ijuk t'inchy'aa naanaii, gwiizhit vinin shree k'it ch'ąhndit dhidlit, ąįįts'ą' vagwach'aa it'ee shrit daagąįį ts'ąįį vakat gaa ch'ąhndok haadhak. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ąįįtł'ęę vitsyaa tik nąįį deenaadąį' gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii neekwaii, Elijah ts'ą' Moses haa Jesus ts'ą' giginkhii googwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ąįįts'ą' Peter, Jesus t'ahnyąą, “K'eegwaadhat, dzaa tr'iilk'įį geenjit łyaa gwinzii gwik'it t'iindhan ji' dzaa nakhweenjit tr'ał zheh tik gwarahahtsyaa, ch'ihłak ąįį neenjit, ts'ą' ch'ihłak chan Moses veenjit, ts'ą' ch'ihłak chan Elijah veenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peter, tth'aii hee ginkhii gwiizhit zheek'ǫh ch'ąhndit gook'aa t'iizhit ts'ą' zheek'ǫh zhit gwats'an gwideezhuh jyaa nyąą gwigwiitth'ak, “Jii t'ee Shidinji' t'inchy'aa, veet'iihthan ts'ą' łyaa shooshahtsii t'inchy'aa oodǫǫhk'įį!” ");
INSERT INTO gwiNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nijin vitsyaa nąįį zhit gwideezhuh giitth'ak dąį', łahchy'aa gwint'aii gihiłghaa ts'ą' nankat diginin gwagwaa'ee ts'ą' jyąhts'ą' oo'an gahaatł'it. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus goots'ą' haazhii ts'ą' gookat naanjik ts'ą' t'agavahnyąą, “Ndak nineekhwakhin ts'ą' noojat kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ąįįts'ą' t'ee k'iidak gwagwaah'in akhai' Jesus zhrįh nadhat łee gwagwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ddhah kat gwats'an k'iizhak neegeedaa gwiizhit Jesus t'agoovahnyąą. “Nakhwandee ts'ą' gwigweelkįį gǫǫh'ya' łyaa ch'ihłak gaa haa goondak shrǫ', dahthee Gwidinji' ch'ichį' ts'an neegweheendaii gwats'ą'!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ąįįtł'ęę vitsyaa nąįį giiyųąhkat, “Jaghaii Law eech'ǫąąhtan nąįį Elijah tr'ookit k'ineeheedik ginyąą t'iginyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ts'ą' t'agoovahnyąą, “Elijah adan tr'ookit k'ineeheedik ts'ą', adan jidii datthak shrigweheelyaa ts'ą' tr'iilęįį nigwehee'aa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gaa, nakhwaagwahaldak, Elijah ch'adąį' hee k'inidik t'inchy'aa, googaa dzaa nankat gwich'in nąįį juu t'inchy'aa giiyaandaii kwaa ts'ą' dooł'ya' giiyuunyąą gwik'it datthak t'igiiyah'ya'. Ąįį gwik'it chan Gwidinji' khaiinjich'agahahthat t'igiinchy'aa.” Jesus goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ąįįtł'ęę vitsyaa nąįį ąįį John chųų gwats'an ąhtsii eeginkhii t'inyąą łee giiky'aanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nijin zhit dinjii nąįį łeeljil, k'ineegiidal dąį' dinjii ch'ihłak Jesus ts'ą' niinzhii ts'ą' yats'ą' nikiigwiintthaii, ");
INSERT INTO gwiNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ts'ą' t'iiyahnyąą, “K'eegwaadhat, shigii chyaatsal sheenjit neeshraahchy'aa oiinyąą! Epileptic naandoo ts'ą' oo'an t'eehaadhat nilii ts'ą' nijin veenjit gwiizųų nineegwaadhat dąį', chųų akwat kǫ' haa zhit nineet'aadhat. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ąįį geenjit nitsyaa nąįį ts'ą' hoołchįį gaa khyų' shrineegiiyilii.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus ditsyaa nąįį jyaa dahnyąą, “Łyaa gwik'iinjuhkhit kwaa ts'ą' gwiizųų t'oochy'aa łee it'ee nakhwaashandaii goodlit! Deegwąhkhyuk zhyaa nakhwaa t'ihihchy'aa shoohnyąą? Ąįį chyaatsal dzaa shats'ą' hohchįį!” Gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus zhit ch'anky'aa iizųų, gwint'aii ts'ą' khagiinkhee, gwagwahkhan zhit chyaatsal ts'an khaiinzhii, ts'ą' zhat gwagwahkhan chan chyaatsal shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ąįįtł'ęę vitsyaa nąįį dinjii nąįį kwaa gwiizhit giiyųąhkat, “Jaghaii khyų' ąįį ch'anky'aa iizųų kharahchįį t'oonchy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus t'agoovahnyąą, “Nakhwak'injigwiighit natsal geh'an khyų' t'akhwa'in. Jii t'ee łyaa nakhwaagwaldak t'ihnyąą, nakhwak'injigwiighit jii mustard seed natsal ąhtsii ji' jii ddhah dzaa gwats'ą' hinkhaii vaiinyąą ji' gaa gwik'it t'ihee'yaa t'inchy'aa, ąįįts'ą' nakhwak'injigwiighit zhit Vit'eegwijyąhchy'aa vat'aii haa deesho'ya' nohthan datthak gwik'it t'akhwa'yaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jii ch'anky'aa iizųų k'it t'inchy'aa t'ee khadigiriinjii ąįįts'ą' khadigireheejyaa geenjit adach'ara'aa kwaa haa gwizhrįh khahohchyaa t'oonchy'aa,” yąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nijin vitsyaa nąįį Galilee nahkat khaihłan nigiinjil dąį' Jesus jyaa gavahnyąą. “Gwidinji' tr'ahaahkhwaa geenjit dinjii nąįį antł'eeyahahchyaa ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","giiyęhdaa tr'igwihee'aa t'inchy'aa, gaa drin tik ąįįtł'ęę neegweheendaii.” Vitsyaa nąįį łahchy'aa gwiintł'oo tr'igwigwidii nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nijin Jesus ąįįts'ą' ditsyaa nąįį haa Capernaum kwaiik'it k'eegiidal dąį', dinjii Kharigidiinjii zheh geenjit tax laraa oonjii nąįį ąįį Peter ts'ą' gahaajil ts'ą' giiyųąhkat, “Nakhwageech'ǫąąhtan Kharigidiinjii zheh gwats'ą' lee tax ookwat t'inchy'aa?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Jyaa dihee'yaa gwizhrįh t'inchy'aa!” Peter gavahnyąą. Nijin Peter zheh nihdineezhii dąį' Jesus t'iiyahnyąą, “Simon jii geenjit deeyiindhan, juu dzaa nankat kings nąįį ts'ą' tax ookwat t'oonchy'aa? Juu zhat gwich'įį nąįį akwat juu zhat gwich'įį kwaa nąįį?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Juu dzaa gwich'įį kwaa nąįį reh”, Peter yahnyąą. “Akwaa ji' juu dzaa gwich'įį nąįį gooheekwat kwaa goo'aii łee. ");
INSERT INTO gwiNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gaa, dzaa gwich'in nąįį goonehts'į' t'igwehee'yaa gwits'į', oo'an van ts'ą' hiinkhaii, ts'ą' cheehjal dha'aii ts'ą' ąįį jidii łuk tr'ookit khahchįį ąįį vighit gwąąh'in, gwizhit Kharigidiinjii zheh geenjit tax laraa t'aahchy'aa agwahaa'aa t'oonchy'aa, ąįį goovantł'eiinlii, nan, ąįįts'ą' shįį haa diineenjit.” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Izhit dąį' Jesus vitsyaa nąįį giits'ą' haajil ts'ą' giiyųąhkat, “Juu shrit Zheekat Gweegwinii'ee ch'andaa hil'ee t'oonchy'aa?” Giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ąįįts'ą' Jesus tr'iinin tsal aanaii ahnyąą ts'ą' gavandaa nadhat gwiizhit jyaa goovahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Jii t'ee łyaa t'ihnyąą, tr'iinin tsal k'it t'inchy'aa needhoodlit ji' gwizhrįh Zheekat Gweegwinii'ee nihdeehohdaa t'oonchy'aa gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jii łi'haa nakhwaagwaldak t'ihnyąą, Zheekat Gweegwinii'ee, datthak ts'ą' ch'ijuk dinjii needhoodlit ts'ą' tr'iinin k'it nakhweegoo'aii ji' zhat nihdeehohdaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Juu tr'iinin tsal shoozhri' zhit shoo nilii haa oonjik t'ee shįį chan sheenjit shoo nilii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Gaa jii tr'ii'in shik'injiighit ąįį juu tr'agwaanduu t'ii'in yahtsii ji', ąįį juu jyaa dii'in yahtsii vak'ohchan kii choo diriłchaa ts'ą' chųų choh zhit nijin chųų lęįį gwa'an tee t'eeraahnaii ts'ą' teenakhwanii ji' ts'ąįį vidivee gweheezyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Juu ch'izhii nąįį tr'agwaanduu t'ii'in ąhtsii nąįį łyaa goodiveegweheezuu gwiizhit dzaa nankat gwirich'įį ts'ą' tr'agwaanduu t'igii'in gooraah'in dąį' diikhwan chan gwik'it t'agǫǫ'ya' gweheen'yaa, gaa zhit juu gwik'it t'agǫǫ'ya' gwiindhan diinahtsii łyaa, vidivee gweheezųų. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nanli' tr'agwaanduu t'ini'in nahtsii ji' vik'eech'iint'ii ts'ą' oo'an hohkhii! Nanli' ch'ihłak kwaa haa gwandaii ndaanąą'ąį' kwaa gwats'ą' hoiizhii ts'ąįį gwinzii. Izhit kwaa ji' nanli' neekwaii gwanlii haa kǫ' khit geenjit ak'an gwizhit t'anakhwaraheełnaii aiizhit ts'ąįį gwiizųų. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nandee tr'agwaanduu t'ini'yaa nihiłtsąįį ji' khaiin'ąįį, ts'ą' oo'an haakhii! Nandee ch'ihłak haa gwandaii ndaanąą'ąį' kwaa gwats'ą' hoiizhii ts'ąįį gwinzii, nandee neekwaii gwanlii haa hell izhit gwizhit kǫ' zhit t'ee naraahkhii aiizhit ts'ąįį gwiizųų.” ");
INSERT INTO gwiNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Jii tr'iinin tsal nąįį goots'į' t'ohchy'a' shrǫ'! Jii łyaa nakhwaa gwaldak t'ihnyąą, zheekat gwizhit goozheekat gwich'in nąįį, zheekat Shiti' gweedhaa datthak haa giilk'ii t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Gwidinji', ąįį dinjii teehaajil nąįį neehahshii geenjit dzaa nankat gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Jii dinjii divii 100 aanchy'aa dii'įį ts'ą' nijin ch'ihłak haa tr'agwąhdaii dąį' deehee'yaa shrǫǫ ohnyąą? Zhit divii 99 kwaii akhahoonjyaa ts'ą' zhat taih khyųų gwa'an ch'aga'aa gwiizhit t'oołii heekhaa ts'ą' zhat gwa'an ąįį divii ch'ihłak vaatr'igweendaii kaheentyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nakhwaagwahaldak, ąįį divii 100 dii'įį ąįį ch'ihłak ineegwah'ąįį dąį' łahchy'aa gwintł'oo shoh nilii. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Izhit gwik'it, zheekat Gwiti' chan jii tr'iinin ch'ihłak gaa haa tr'agołjii niindhan kwaa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nijin nachaa gwik'injiighit nats'ą' tr'agwaanduu tr'agwah'in dąį' vats'a' hinkhaii ts'ą' nats'ą' deezhik vaagwaandak gaa gweentak ni'in, nan ąįįts'ą' nachaa haa zhrįh t'akhwa'in, noołk'įį ji' nachaa gaiiyiineedhahtsąįį ts'ą' gwinzii neegohtsąįį t'agoonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Gaa noołk'įį kwaa ji' dinjii ch'ihłak akwat neekwaii nąįį dahaa hiinlii, ąįį deegwinyąą ąįį ndak gwagoohoontą' geenjit, jii t'ee Dęhtły'aa Choh zhit jyaa digwinyąą t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ąįį juu adahaa hoiinlii nąįį oołk'įį kwaa ji' tr'igiinkhii zheh gwizhit datthak geegwandak, aiizhit chan ch'oołk'įį kwaa ji' Vit'eegwijyąhchy'aa haagiindaii kwaa nąįį akwat tax eenjit laraa oonjii k'it vineehohdak.” ");
INSERT INTO gwiNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ąįįts'ą' gwik'injiighit nąįį jii nakhwaagwaldak, dzaa nankat gwats'an nakwaa dohnyąą ji', Vit'eegwijyąhchy'aa zheekat gwats'an chan nakwaa heenjyaa t'oonchy'aa ts'ą' dzaa nankat gwizhit jidii geenjit aahą' dohnyąą ji' Vit'eegwijyąhchy'aa zheekat gwats'an chan aahą' heenjyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ąįįts'ą' chan hee nakhwaaneegwaldak, nijin gwik'injiighit neekwaii nąįį jidii giindhan eenjit khadigigiinjii dąį' zheekat Shiti' gwik'it t'ihee'yaa gwizhrįh t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ąįįts'ą' gwik'injiighit neekwaii akwat tik nąįį shoozhri' zhit nihłaa nineegiidal ji' gavaahihłyaa t'oonchy'aa, t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ąįįtł'ęę Peter, Jesus ts'ą' niinzhii ts'ą' yuahkat, “K'eegwaadhat, shachaa shats'ą' tr'agwaanduu t'ii'in ji' deegwaanchy'aa veenjit gineehaaldee t'inchy'aa? Nihk'iitik ants'ą' ch'ihłak gwagwaanchy'aa veenjit gineehaldee lee t'oonchy'aa?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Nakwaa, nihk'iitik ants'ą' ch'ihłak ąįį nakwaa gaa 70 x 7,” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Zheekat Gweegwinii'ee jii jyaa doonchy'aa geh'an jii jyaa dihnyąą t'ihnyąą, ch'ihłan dinjii King nilii ąįį juu yeenjit tr'agwah'in nąįį deegwahtsii giits'ą' gaandaii li' gaageheendaii geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dęhtły'aa kat gweheeł'ya' gwiizhit łąą dinjii slave ch'ihłak laraa million dollars yats'ą' aandaii giits'ą' nihdąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ąįį slave yineegahookwat geenjit laraa gaanchy'aa di'įį kwaa, ąįį geh'an ditsyaa nąįį jidii k'aiich'i' di'įį datthak vits'į' ǫhjii goovahnyąą. Adan ts'ą' vizhehk'aa nąįį haa slaves giheelyaa haa giineegwahohkwat geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ąįį slave, king ehzhee dahgwat kat nat'aanąįį ts'ą' t'iiyahnyąą. ‘Ch'ihłee nagoodhan'in ji' datthak nineegoohihkwat t'oonchy'aa!’ nyąą ts'ą' yats'ą' ch'oodiikwat. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ąįį King neeshraahchy'aa yuunyąą ts'ą' neegohookwat goo'aii datthak yeenjit ginildee ts'ą' oo'an neeyihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ąįįtł'ęę nijin cheehoozhii dąį' ch'izhii slave yats'ą' gwintsal gaandaii chy'aa k'at deedhizhii ts'ą' ąįį dinjii chan t'ee slave nilii t'ah'in, ąįį dinjii ahtsik ts'ą' yigheehaanjik gwiizhit t'iiyahnyąą, ‘Jidii laraa shats'ą' aandaii chy'aa shineegoiinkwat,’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ąįį slave yaa tr'agwah'in, zhazhat oozhat t'ee heełnaii ts'ą' yach'oodiikwat, “Ch'ihłee nagoodhan'in, izhit ji' t'ee datthak nineengoohihkwat!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ąįį googaa nihk'it gitr'ii'ee ts'ą' zheegwaazhrąįį gwizhit nihdeet'eeyaahnaii, dahthee datthak neegoheekwat gwats'an datthak zhat heedyaa yeenjit gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nijin ch'izhii slaves nąįį gwagwaah'in dąį' dagatthąį' zhit gwintl'oo tr'igwigwidii ts'ą' zhit juu king nilii ts'ą' gahaajil ts'ą' deegwiizhik datthak giiyaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ąįįts'ą' ąįį juu slave jyaa diizhik ąįį aanaii ahnyąą ts'ą' t'iiyahnyąą, ‘Łyaa zhyaa slave ginilih kwaa inlii! Jidii shineehahtsyaa goo'aii kwaii datthak nijin gineedhaldee jyaa shaiinyąą geh'an gwizhrįh jyaa shizhit.’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Zhit slave juu naatr'agwaah'in chy'aa neeshraahchy'aa oiinyąą jaghaii, neeshraahchy'aa noihnyąą gwik'it nan chan neeshraahchy'aa oohinjyaa goo'aii t'oonchy'aa.’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","King łyaa zheełts'įį ts'ą' zheegwaazhrąįį niiyahchįį, dahthee laraa haa datthak yineegahookwat gwats'ą' datthak khaiinjich'iheeghit yeenjit gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Nachaa gwik'injiighit nidrii zhit gwats'an veenjit gineedhandee kwaa ji', jii jyąhts'ą' t'ee zheekat Gwiti' k'ineenakhwahahndak t'oonchy'aa.” Jesus jyaa diinyą'. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nijin Jesus jii kwaii datthak t'iinyą', ąįįtł'ęę Galilee nahkat gwats'an, chan hee Jordan han ndųhts'ąįį Judea nahkat goo'aii ąįį zhit gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Dinjii lęįį yaa łeeljil nąįį ts'ą' juu yaa adaa nąįį zhazhat gooveenjit gwinzii neegooviłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Goodhaii nigihadhal gwik'eegwagwandaii geenjit Pharisee lat nąįį giits'ą' haajil ts'ą' jii giiyųąhkat, “Dii-law zhit khan dinjii jidii niindhan geenjit da'at akhooheenjyaa lee t'oonchy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus, ąįį t'agavahnyąą, “Tr'ookit dąį' gwats'an zhit juu Diiniłtsąįį ąįįt'ee dzaa nankat dinjii ts'ą' tr'injaa haa iłtsąįį, ąįį nik'ee Dęhtły'aa Choh kat jyaa digwinyąą gooh'in? ");
INSERT INTO gwiNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Vit'eegwijyąhchy'aa jyaa nyąą, “Jii geh'an t'ee dinjii dahan ąįįts'ą' diti' haa iłeeheehaa ts'ą' da'at haa nihłaa t'igiheechy'aa ts'ą' neekwaii giinlii chy'ah ch'ihłak zhrįh giheelyaa gooviłtsąįį t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Vit'eegwijyąhchy'aa nihłaa neegoovahahchyaa geh'an neekwaii ginlii kwaa ts'ą' juk ch'ihłak zhrįh ginlii t'igiinchy'aa, ch'ihłee gaa ch'akai' ts'ą' ch'a'at haa Vit'eegwijyąhchy'aa nihłeegoovahchįį ąįį nihts'an tr'agoogahahchyaa kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pharisee nąįį jyaa t'igiiyahnyąą, “Akwaa ji' jaghaii Moses dinjii nąįį law antł'eiin'ąįį, ąįį ch'akai' dęhtły'aa da'at antł'eehahchal ts'ą' t'ee va'at t'ohłii neeheedyaa gwahahtsyaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus, t'agavahnyąą, “Datthak ts'ą' geenakhwaraahtan geenjit nakhwakiitth'an dach'at geh'an Moses nakhwa'at akhahoohjyaa gwiłtsąįį t'inchy'aa. Gaa dzaa nankat datthak gwiłtsąįį dąį' jyaa doonchy'aa kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ąįįts'ą' t'ee jii nakhwaagwahaldak, juu dinjii va'at adultery t'ii'in kwaa gaa nihk'it akhoonyąą ts'ą' ch'izhii tr'injaa noonjik ji', ąįį dinjii adultery t'ii'in t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Vitsyaa nąįį t'igiiyahnyąą, “Dinjii ąįįts'ą' da'at haa gooveenjit jyaa doonchy'aa ji' gooroonjii kwaa ts'ąįį gwit'eegwaahchy'aa łee hee.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus t'agavahnyąą, “Jii ginjik juu nąįį datthak eenjit t'inchy'aa kwaa, gaa Vit'eegwijyąhchy'aa ąįį juu gwitee tr'iinlii nąįį zhrįh eenjit t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jii t'ee jaghaii dinjii lat nąįį gogoonjii kwaa. Goolat nąįį tr'iinin gahahtsyaa kwaa jyąhts'ą' googoodlit. Ch'izhii nąįį dinjii nąįį dzaa nankat dinjii nąįį tr'iinin gahahtsyaa kwaa googahtsii ts'ą' ch'izhii dinjii nąįį Zheekat Gweegwinii'ee khit geetr'agwagwahah'yaa geenjit gwagoonjii kwaa. Juu jii geech'oorahtan gwik'it t'ihee'yaa geenjit gadhan ji' gwik'it t'ii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Dinjii nąįį tr'iinin tsal Jesus ts'ą' gahaadlii gook'aa nahaandal ts'ą' gook'aa khadigiheejyaa geenjit, gaa vitsyaa nąįį jii geenjit shruk haa dinjii nąįį ch'ats'ą' t'agahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gaa Jesus ąįį t'agoovahnyąą, “Tr'iinin shats'ą' hijyaa nąįį, zhyaa goovoh'in, jii tr'iinin k'it t'iinchy'aa dinjii nąįį t'ee Zheekat Gweegwinii'ee goots'an nilii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ts'ą' tr'iinin tsal nąįį k'ąą naanjik ąįįtł'ęę gihłeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ch'ihłan dąį' dinjii ch'ihłak, Jesus ts'ą' haazhii ts'ą' yuahkat, “Geech'ǫąąhtan, gwandaii ndaanąą'ąį' kwaa shi'yaa geenjit jidii gwinzii t'ishi'yaa goo'aii?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","“Jaghaii jidii gwinzii ji' geenjit shǫąąhkat? Vit'eegwijyąhchy'aa zhrįh nizįį t'oonchy'aa, gwandaii ndaanąą'ąį' kwaa zhit goiihndaii nindhan ji' Moses va-law kat deegwinyąą gwik'eegwahthat.” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Moses va-law kat jidii shrik eeginkhii t'iinyąą?” dinjii yahnyąą. Jesus, t'iiyahnyąą, “Dinjii ęhdaa tr'agoon'aa shrǫ'! Nakąį' akwat na'at nilii kwaa haa oonchį' shrǫ'! Ch'ooan'įį shrǫ'! Ninee'ok dinjii nąįį eenjit oiints'it shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Nahan ąįįts'ą' niti' haa yinjiikhadhoh'ee! Deegwahtł'oo ideet'ohthan googwahtł'oo nakhwanee'ok dinjii nąįį eenjit ch'eet'igwiniindhan akhwa'įį!” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ąįį dinjii t'iiyahnyąą, “Jii datthak gwik'it t'ishi'ya', ts'ą' geeghaih chan deehishi'yaa goo'aii?” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus t'iiyahnyąą, “Łyaa dinjii nizįį oihłi' niindhan ji', oo'an heehindii ts'ą' nik'eiich'ii datthak laraa t'įį hinlii ts'ą' ąįį laraa neeshraahchy'aa nąįį teiinlii. Jyaa dinizhik ji' zheekat gaayiigwahantsyaa neenjit gwehee'aa. Ąįįtł'ęę shatąįį hinkhaii ts'ą' shitsyaa inlii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nijin zhit dinjii jii gwiitth'ak dąį' valaraa gwanlii geh'an tr'igwidii haa gihłeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus ditsyaa nąįį t'ahnyąą, “Jii t'ee łyaa gwik'it gwanlii t'ihnyąą, dinjii valaraa gwanlii Zheekat Gweegwinii'ee gwizhit nihdeeheehaa geenjit łahchy'aa gwagwantrii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Chan hee nakhwaa neegwaaldak, Camel ąįį tthah tsal tł'i'tsii gwinkee heekhaa, ąįį zhit ts'ąįį gwagwantrii kwaa gaa Vit'eegwijyąhchy'aa Veegwinii'ee izhit dinjii valaraa gwanlii nihdeeheehaa, ąįį ts'ąįį łyaa gwagwantrii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nijin vitsyaa nąįį gwigwiitth'ak dąį' łyaa gwintł'oo gooveenjit nindal deegwidlii, ts'ą' t'iginyąą. “Akwaa ji' juu dee neeheezhii diinyąą t'iinyąą?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus goovah'in ts'ą' t'agoovahnyąą, “Jii t'ee dzaa nankat dinjii nąįį eenjit gach'agwadhan kwaa, gaa Vit'eegwijyąhchy'aa ąįį jidii datthak veenjit gach'agwadhan t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ąįįtł'ęę Peter khagiinkhee, “Dzaa gwąąh'in, jidii datthak akharoonyąą ts'ą' natąįį tr'ahaajil ts'ą' nitsyaa tr'aadlit. Diikhwan ąįį jidii tr'ihee'yaa?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus t'agoovahnyąą, “Łyaa nakhwaagwaldak t'ihnyąą, nijin nan k'eejit neegahoodlit ji' shįį Gwidinji' ihłii ch'eegwąhndit jiintsii k'eedeegwaadhat ts'ą' yakat daraadii kat dihihdyaa t'oonchy'aa, ąįįtł'ęę nakhwan shitsyaa 12 nąįį t'ee k'eedeegwaadhat yakat doodii ąįį ch'ihłoaatin ts'ą' neekwaii (12) aanchy'aa kat shadahohdyaa ts'ą' shaa Israel neezheedijii ch'ihłoaatin ts'ą' neekwaii (12) nąįį ts'ą' k'eedeegwahoodhat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ąįįts'ą' juu nakhwatee, dizheh, akwat dachaa, doondee akwat, dijuu, deejii, akwat diti', akwat dahan, akwat tr'iinin nąįį, akwat nan vakat gwarahshii deek'it kwaii, datthak sheenjit akhoonyąą ji', 100 agwaanchy'aa gwandaa nakhwats'an neegweheelyaa ąįįts'ą' chan gwandaii ndaanąą'ąį' kwaa nakhwantł'eegwirehee'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lęįį nąįį juk tr'ookit nilii ąįį nąįį t'ee ji' khaiinkǫǫ nineegooraheelyaa gaa yeendaa ji' juu lęįį nąįį juk ji' khaiinkǫǫ dilk'ii nąįį tr'ookit nineegooraheelyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Zheekat Gweegwinii'ee ąįįt'ee jii k'it t'oonchy'aa. Ch'ihłan dinjii ch'ihłak jak choh nahshii gwideek'it gwii'įį ąįįts'ą' vanh dąį' hee khakee'ąįį ts'ą' dinjii nąįį lat keegwaah'in, giiyeenjit jak choh tr'ąąhshii gwideek'it gwa'an tr'agwagwahaah'yaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Dinjii lat yeenjit gwitr'it t'agwahah'yaa nąįį agwąh'ąįį. Drin ch'ihłak gwizhit silver laraa ch'ihłak haa googwarahookwat nyąą, izhit gwanaa dąį' drin ch'ihłak dinjii tr'agwah'in dąį' (silver) laraa ch'ihłak haa googwagookwat gwagwah'įį ts'ą' t'ee jak choh nahshii gwa'an gwitr'it t'agwahah'yaa geenjit gwats'ą' gavaahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ąįįtł'ęę 9 o'clock gwandaa chan hee nijin ch'arookwat zheh goodlii gwa'an gwits'eehoozhii akhai' ch'izhii dinjii lat nąįį zhyaa zhik gwa'an nigeelzhii gavaah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Nakhwan chan jak choh tr'ąąhshii deek'it gwa'an sheenjit tr'agoh'in ji' t'ee gwinzii nakhwagohoihkwat t'oonchy'aa,’ gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ąįįts'ą' t'ee tr'agwagwahaah'yaa geenjit oo'an gahaajil. Ąįįts'ą' (12:00 o'clock) drin tł'an nigwiindhat dąį' chan hee dinjii neekwaii, tr'agwagwahaah'yaa geenjit oonjik, ąįįtł'ęę 3 o'clock nagwaanąįį dąį' chan hee gwik'it t'ineezhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ąįįtł'ęę chan hee khaiinjii 5:00 o'clock nagwahaaghyii gwizhit oondaa neehoozhii akhai' ch'izhii dinjii nąįį zhyaa zhat gwa'an nigeelzhii goovah'in ts'ą' t'agavahnyąą, ‘Jaghaii zhyaa drin datthak zhat gwa'an nadhoozhii?’ ");
INSERT INTO gwiNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Ch'ihłee gaa tr'agwah'in diinahnyąą kwaa.’ giiyahnyąą. ‘Akwaa ji' oo'an hohjyaa ts'ą' jak choh nahshii gwideek'it gwa'an sheenjit tr'agoh'in.’ gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nijin khaa nagwaanąįį dąį' zhit juu gwanzhįh deek'it ts'an gwaah'įį. Ąįį dinjii yeenjit gwitr'it t'agwah'in nąįį ts'ą' k'eedeegwaadhat t'ahnyąą. Zhit juu tr'agwah'in nąįį aanaii gooveiinyąą ts'ą' googoiinkwat, zhit juu t'ohju' zhat tr'igwihił'ya' nąįį tr'ookit googoiinkwat. Ąįįts'ą' juu vanh dąį' hee tr'igwihił'ya' nąįį, ji' gwaa'ai' gwitsii gahaaky'aa goovahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ąįįtł'ęę dinjii nąįį 5:00 o'clock gwats'an tr'agwah'in nąįį silver laraa ch'ihłak haa googwaroonkwat. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ąįįts'ą' zhit dinjii nąįį vanh dąį' gwats'an tr'agwah'ya' nąįį chan gwandaa googoorahookwat giindhan, akhai' geedan chan silver laraa ch'ihłak goovantł'eerinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dagalaraa goonjik, ts'ą' zhit juu eenjit tr'agwagwah'ya' ąįįts'ą' zhigaants'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ts'ą' jyaa digiiyahnyąą, ‘Jii dinjii nąįį one hour gwizhrįh tr'agwagwah'ya' gwiizhit diikhwan ąįį drin datthak shree nindhaa zhit tr'agwarah'ya' gwiizhit gook'it diigoinkwat!’ ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ąįį juu eenjit tr'agwagwah'ya' ąįį t'agavahnyąą, ‘Shoodǫǫhk'įį shijyaa nąįį, nakhwaninjigoolzhii kwaa t'oonchy'aa geh'an, silver laraa ch'ihłak drin datthak geenjit gwarookwat t'oonchy'aa ts'ą' ąįį eenjit tr'agwahoh'yaa dohnyąą ijii.’ goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Akǫ' t'ee nakhwalaraa ǫhjii ts'ą' nakhwazheh gwits'eekhwajyaa, jii dinjii gǫhju' zhat tr'igwihił'ya' ąįį chan deegwahtsii nakhwagoiikwat gwagwahtsii vagoohinkwat t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Łyaa shalaraa haa ch'iihshrii ąįį geenjit gatr'oo'ee? Akwat shalaraa dooł'yaa nihthan gwik'it t'ahał'yaa t'oonchy'aa?’” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ąįįts'ą' t'ee Jesus ginkhii ndaanaahjik ts'ą' t'inyąą, “Jyąhts'ą' geh'an juu ji' khaii nilii ąįį tr'ookit heelyaa, ąįįts'ą' juu tr'ookit nilii chan ji'-khaiin nineerahahchyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus Jerusalem, gwats'ą' geedaa gwiizhit ditsyaa 12 nąįį geh'at gwa'an geedan zhrįh nagaviinlii, ts'ą' t'agavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ch'oodǫǫhk'įį! Jerusalem gwats'ą' tr'iheedaa ts'ą' izhit ji' t'ee, giinkhih kįh dilk'ii nąįį ąįįts'ą' Law eech'ǫąąhtan nąįį haa Gwidinji' goovantł'eehahchyaa. Tr'agwaanduu t'ii'in giihaanjyaa ts'ą' giiyęhdaa tr'igwihee'aa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ąįįtł'ęę chan Jews nilii kwaa nąįį antł'eegiiyahahchyaa ts'ą' giiyeheedlaa, ts'ą' giiyahahtrii, ąįįtł'ęę cross kat gigiiyahahtsak, gaa drin tik nagwiindhat ąįįtł'ęę neegweheendaii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ąįįtł'ęę Zebedee va'at Jesus ts'ą' haazhii, vidinji' neekwaii nąįį yaaneehii'oo gwiizhit Jesus ts'ą' nikiigwiintthaii ts'ą' t'iiyahnyąą. “Łyaa k'eegwiichy'aa geenjit noołkat nihthan.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Deeyiindhan,” Jesus yahnyąą. Ch'ahan ąįį jyaa yahnyąą, “Nijin Neegwinii'ee nihdeiinzhii ji', shidinji' neekwaii nąįį neeghaii naa goodi' nihthan, ch'ihłak chan nishriits'ąįį heedyaa ts'ą' ch'izhii chan natł'ohts'ąįį heedyaa, jii łyaa gwik'it t'inihi'yaa gwizhrįh t'ihnyąą.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus ąįį ch'ahan vidinji' neekwaii nąįį t'ahnyąą, “Jidii eenjit ch'oohkat, gaakhwandaii kwaa t'ohnyąą, jii chųų tyah zhit vaa khaiinjich'ashiheeghit dhakaii, ąįį shihihjyaa goo'aii, khan khwanjyaa lee t'oonchy'aa?” Gavahnyąą. “Aahą', khan gwik'it t'igwehee'yaa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Łahchy'aa gwik'it gweheelyaa t'ihnyąą, shichųų tyah ts'an chan chųų khwanjyaa gwizhrįh goo'aii gaa shishriits'ąįį ts'ą' shatł'ohts'ąįį haa juu heedyaa ąįį geenjit jyaa dihihjyaa sheegoo'aii kwaa t'ohnyąą, jii nijin oihdi' dohnyąą, ąįį Shiti' ch'adąį' hee juu zhat hahky'aa shrigwiinlik t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jii ch'achaa ts'ą' ch'oondee haa deeginyąą ąįį vitsyaa 10 nąįį gwigwiitth'ak dąį' goots'ą' shoo gaadlit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ąįįts'ą' Jesus aanaii gavahnyąą ts'ą' khaihłan nagoovinlii ts'ą' t'agavahnyąą, “Dzaa nahkat juu Vit'eegwijyąhchy'aa k'injigiighit kwaa nąįį jidii datthak eenjit kįh giilk'ii ts'ą' k'eedeegwagwaadhat, deegoo'ya' giindhan datthak gwik'it t'agoogah'in gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gaa, nakhwan ąįį jyaa dahohchy'aa goo'aii kwaa geh'an, nakhwatee juu gwiintsii sheegoo'ai' nindhan ji' ch'izhii dinjii nąįį eenjit slave heenlyaa gwizhrįh goo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ąįįts'ą' nakhwatee ch'ihłee juu tr'ookit oihłi' nindhan ji' ch'izhii dinjii nąįį datthak eenjit nakhwa-slave heelyaa gwizhrįh goo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ąįį gwik'it Gwidinji' veenjit slave tr'iheelyaa geenjit dzaa nankat neiinzhii kwaa t'oonchy'aa gaa dinjii nąįį eenjit gwitr'it t'agwahah'yaa ts'ą' dinjii lęįį nąįį veh'an neeheezhii geenjit giiyęhdaa tr'igwihee'aa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ąįįts'ą' Jesus ts'ą' ditsyaa nąįį haa Jericho kwaiik'it gwachoo gihłeegihiijyaa, gwiizhit dinjii lęįį łeeljil nąįį gootąįį geedaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dinjii vandee kwaa, neekwaii nąįį tąįį gwinjik geeghaih gaadii, gwiizhit Jesus, goovehgoo hahkhaii gwigwiitth'ak ts'ą' gazhral, “David vidinji' neeshraahchy'aa diinoiinyaa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Zhit juu Jesus haa adaa nąįį ch'ats'ą' t'agoogahnyąą ts'ą' deegohtsai' kwaa googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus, ndaaniinzhii ts'ą' t'agavahnyąą, “Aanaii, nakhweenjit deesho'yaa nohthan?” ");
INSERT INTO gwiNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“K'eegwaadhat, gwarahaa'yaa geenjit diinantł'eegwiin'ąįį,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus neeshragaahchy'aa goovoonyąą ts'ą' gavandee aahtrat, gwagwahkhan gwagwah'in neegaadlit ts'ą' giitąįį haa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesus ąįįts'ą' ditsyaa nąįį haa Jerusalem kwaiik'it gwachoo gwats'ą' niighit kwaa geedaa gwiizhit Bethphage kwaiik'it, geeghaih Taih Vakat Olives Nahshii goo'aii aiizhit k'eegiidal, aiizhit gwats'an Jesus ditsyaa neekwaii nąįį dits'ii oo'an goovihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jii jyaa khwa'yaa yuu goovahnyąą, “Yeendaa kwaiik'it goo'aii gwats'ą' hoh'oo. Izhit gwizhit donkey gakhwachaa ts'ą' veeghaii chan vigii dhidii, ąįį kwaii danoh'at ts'ą' shats'ą' goovahohchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ąįįts'ą' k'eegwiichy'aa t'anakhwagahnyąą ji', ‘Shik'eegwaadhat yit'eehaahchy'aa ts'ą' yit'aahchy'aa,’ dohnyąą ji' gwagwahkhan gooneegeheendal t'iginchy'aa,” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jii jyaa digwiizhit, ąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii deiinyą' ąįį gwik'it t'igweheenjyaa geenjit, jii jyaa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zhit kwaiik'it gwachoo, Zion gwich'in nąįį jyaa gavahnyąą. Gooh'in! Nakhwa-King khazhak t'iichy'aa donkey gii kat dohdii nakhwats'ą' ahaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ąįįts'ą' t'ee vitsyaa nąįį Jesus deenyąą gwik'it t'igiizhik, ");
INSERT INTO gwiNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Donkey ąįįts'ą' vigii tsal giits'ą' hiłchįį, digi'ik giikat deedhidlii ts'ą' Jesus gwakat daandii. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Dinjii lęįį łeeljil nąįį digi'ik tąįį gwinjik nigilii ts'ą' ts'iivii ah khagit'ii ts'ą' gideekwaii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zhit dinjii yęhdaa łeeljil ts'ą' yeent'ii łeeljil nąįį geedaa gwiizhit gazhral ts'ą' t'igiiyahnyąą.” “Yeenii King David ts'an deedhaa tr'ahoh'e'! Juu K'eegwaadhat voozhri' zhit ahaa ąįį geenjit Vit'eegwijyąhchy'aa gwintł'oo deerahoh'e'! Hosanna zhit jiintsii!” ");
INSERT INTO gwiNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nijin Jesus, Jerusalem nihdeiinzhii dąį' ąįį kwaiik'it gwachoo gwizhit gwich'in nąįį datthak łagalgaadaa gwiizhit deegwii'in gaagiindaii kwaa ts'ą', “Juu t'inchy'aa?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Jii t'įį Vit'eegwijyąhchy'aa Eenjit Ginkhii Jesus, t'inchy'aa Nazareth kwaiik'it, Galilee nahkat gwizhit goo'aii ąįį zhit gwats'an ahaa t'inchy'aa!” zhit dinjii łeeljil nąįį jyaa diginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus Kharigidiinjii Zheh nihdeiinzhii ts'ą' juu ch'ookwat nąįį ts'ą' zhit vach'arookwat nąįį datthak Kharigidiinjii Zheh gwats'an cheehaanzhit. Ch'adanh nahkat gwalaraa ookwat nąįį vakaii'aa, ąįįts'ą' chan vakat daraadii ts'ą' chiitsal pigeons ąįį vizhit dilk'ii kwaii gavarahookwat nilii kwaii datthak khatąąnahjil. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ts'ą' t'agoovahnyąą, “Jii t'ee Dęhtły'aa Choh kat dagwaantł'oo ts'ą' Vit'eegwijyąhchy'aa jyaa nyąą, ‘Shitr'iginkhii zheh ąįįt'ee khadigiriinjii zheh goohaazhyaa t'oonchy'aa.’ Gaa nakhwan ąįį, ch'an'įį nąįį, gwizhit geegoh'ik ch'agąą'įį gwagwaa'įį goo'įį!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kharigidiinjii Zheh gwizhit, zhit juu vandee kwaa nąįį ąįįts'ą' zhit juu neehidik kwaa nilii nąįį datthak giits'ą' haajil ts'ą' shrineegooviinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tr'iinin nąįį Kharigidiinjii Zheh gwizhit, “Yeenii King David vidinji', tr'ahoo'e'!” ginyąą ts'ą' gazhral ts'ą' Jesus Kharigidiinjii Zheh gwizhit gwigwee'in t'ii'in geh'an chan giinkhih kįh dilk'ii nąįį, ąįįts'ą' Law eech'ǫąąhtan nąįį haa gook'įį goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jesus, ąįį jyaa dagahnyąą, “Deeginyąą t'iginyąą nik'ee gaviintth'ak?” giiyahnyąą. Jesus t'agoovahnyąą, “Łahchy'aa gwinzii gaviitth'ak t'igiinchy'aa! Dęhtły'aa Choo zhit nik'ee gooh'in? ‘Nakhwan, ąįį tr'iinin nąįį ts'ą' tr'iinin tsal nąįį haa, gwinzii Vit'eegwijyąhchy'aa deenagahah'aa geenjit geegoovǫǫhtan.’” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesus zhat gihłeehoozhii ts'ą' Bethany kwaiik'it gwizhit naakhaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Vanh dąį' hee Jesus, Jerusalem gwats'ą' needyaa, akhai' vizhit gwiłts'ik nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tąįį gwinjik geeghaih gwa'an dachan vakat Figs nahshii kat gwąąh'in akhai' vakat ch'at'an zhrįh nahshii łee, ąįįts'ą' ąįį dachan t'ahnyąą. “Duuyeh gwik'it chan nahkat neegwąąhshii t'oonchy'aa,” yahnyąą. Gwagwahkhan ąįį dachan navagaii aanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nijin vitsyaa nąįį gwagwąąh'ya' dąį' deegiheenjyaa gaa gaagiindaii kwaa ts'ą' t'igiiyahnyąą, “Zhit Fig vadachan deegwiłkhan chan traa daagąįį naanaii?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus t'agoovahnyąą, “Jii t'ee łyaa t'ihnyąą, gwik'injuhkhit ts'ą' Vit'eegwijyąhchy'aa duuyeh jyaa dii'in gwich'in nohthan kwaa ji', jii dachan Fig deiinlik, nakhwan ji' gaa gwik'it t'ahohjyaa. Gaa jii zhrįh t'akhwa'yaa kwaa t'oonchy'aa. Jii taih oondaa chųų choh zhit gwats'ą' teet'akhanghii vohnyąą ji' gwik'it t'iheenjyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gwik'injuhkhit ji' khadagohjii datthak jidii dohnyąą datthak nakhwak'it t'igweheenjyaa.” t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ąįįtł'ęę Jesus Kharigidiinjii Zheh gwits'ee hoozhii ts'ą' geech'ǫąąhtan, akhai' giinkhih kįh dilk'ii nąįį ts'ą' Israel kįh dilk'ii nąįį haa giits'ą' haajil ts'ą' giiyųąhkat, “Jii jyaa dini'yaa eenjit juu t'aih nantł'eiin'ąįį t'ini'in?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus t'agoovahnyąą, “Jii eenjit ch'ihłak nakhwahałkat, ąįį deihnyąą t'ihnyąą shaagoondak ji' juu vats'an t'aih haa t'ishi'in nakhwaagwahaldak. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John chųų gwats'an hahtsyaa dąį' nijin gwats'an t'aih oonjik t'ii'in? Vit'eegwijyąhchy'aa vats'an akwat dzaa nankat dinjii nąįį ts'an?” Deegiheenjyaa geenjit nihzheedagąąn'ee, “Vit'eegwijyąhchy'aa vats'an t'aih di'įį gwinyąą ji' chan jaghaii John vik'injuhkhit kwaa diinahąąnjyaa t'inchy'aa.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Gaa dzaa nankat dinjii nąįį ts'an gwinyąą ji' dinjii lęįį nąįį John, Vit'eegwijyąhchy'aa Eenjit Ginkhii t'inchy'aa ginyąą ts'ą' gwik'injigiighit geh'an datthak gąąnjat.” ");
INSERT INTO gwiNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ąįįts'ą' Jesus, “Gaagwiindaii kwaa!” agahnyąą. “Shant'ee jii t'aih haa gwitr'it t'agwał'in, nijin gwats'an t'ishi'in nakhwaagwahaaldak kwaa t'oonchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus t'agoovahnyąą, “Juk zhat jii geenjit deenohthan? Ch'ihłan dinjii ch'ihłak vidinji' neekwaii gwanlii. Ch'oodee ąįįts'ą' haazhii ts'ą' t'ahnyąą, ‘Shidinji' juk drin nijin jak choh tr'ąąhshii gwideek'it gwizhit tr'agwah'in.’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Gitr'iih'ee!’ yahnyąą, googaa juk drin tr'agwahaał'yaa niindhan ts'ą' tr'agwahaah'ya' gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ąįįtł'ęę ch'iti', didinji' khaiints'ą' ts'ą' haazhii ts'ą' adan chan gwik'it t'iiyahnyąą, akhai', ‘Aahą' shiti'.’ nyąą gaa gwik'it t'iizhit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Juu shrit viti' deeyahnyąą gwik'it t'iizhit?” gavahnyąą. “Ch'oodee ąįįt'ee gwik'it t'iizhik,” giiyahnyąą. Ąįįts'ą' t'ee Jesus t'agavahnyąą, “Łyaa nakhwaagwaldak t'ihnyąą, Prostitutes ąįįts'ą' tax eenjit laraa oonjii nilii nąįį Vit'eegwijyąhchy'aa Veegwinii'ee gwizhit nakhwehkii nihdeegiheedaa t'igiinchy'aa. “David vidinji' neeshraahchy'aa diinoiinyaa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","John chųų gwats'an ąhtsii dzaa gwats'ą' haazhii, Vit'eegwijyąhchy'aa vik'eegahohthat geenakhwahahchyaa geenjit, googaa vik'injuhkhit kwaa, gaa tax eenjit laraa oonjii nilii ts'ą' protstitutes nąįį giik'injiighit gooh'in googaa nihk'it tr'agwaanduu nakhwagwitr'it gwanlii akhagohnyąą kwaa ts'ą' vik'injuhkhit kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus t'agoovahnyąą, “Chan hee jii gwaandak haa geenookhwahałchyaa, ch'oodǫǫhk'įį, ch'ihłan dinjii jak choo (grapes) deek'it jak choo gwit'eiinlii, tthał chan yeelin needhatthaii. Jak choh teech'ahahdǫǫ ts'ą' jak choo chų' (wine) tr'ahahtsyaa eenjit khagwiindhat ts'ą' zhee ndak goo'aii gwiłtsąįį kat gwats'an khach'oorahaa'yaa geenjit. Dinjii zhat gwik'eehaahtyaa nąįį teegwįłjik, ts'ą' ch'adanh niighit nahkat gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nijin jak choh khaihłan nigiheelyaa nagwiindhat dąį', va-slaves nąįį oo'an gwanzhįh k'ąąhtii nąįį ts'ą' hił'e', ąįį jak choh lat gooheendal geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ąįį gwanzhįh k'ąąhtii nąįį googahtsik, ch'ihłak gaahkhwai' ts'ą' ch'ihłak geełkhwąįį ts'ą' ch'ihłak kii haa khaiinjii geełkhwąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chan ch'izhii da-slaves nąįį oo'an neehił'e', tr'ookit hił'e' nąįį andaa t'ąąnchy'aa nąįį, ts'ą' gwanzhįh k'ąąhtii nąįį chan gwik'it t'agoogiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ndaagwąąn'ąį' didinji' goots'ą' hił'e'. ‘Łyaa shidinji' gahah'aa gwizhrįh goovaashandaii.’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gaa nijin gwanzhįh k'ąąhtii nąįį giidinji' nah'in dąį', jyaa diginyąą. ‘Jii t'ee dinjii gwanzhįh ts'ą' k'eedeegwaadhat vidinji'. Aanaii vats'a' tr'ahoojyaa vęhdaa tr'agwaroo'aa ąįįtł'ęę jii gwanzhįh deek'it diits'an gweheelyaa!’ ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ąįįts'ą' giiyahtsik, ts'ą' jak choh deek'it gwats'an cheet'eegiiheełnaii ts'ą' giiyęhdaa tr'igwiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nijin jak choh deek'it gwats'ą' k'eedeegwaadhat oo'ee neezhįį ji', deehee'yaa shrǫǫ nohthan?” nyąą ts'ą' Jesus goovoahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesus t'agahnyąą, “Ąįį dinjii iizųų nąįį ęhdaa tr'igwihee'aa ts'ą' ch'ihzhii gwanzhįh k'ąąhtii nąįį jak choh khaihłan nigilii ji' valak giits'an hahtsyaa haandaii nąįį giigookwat haa jak choh deek'it gwagwahahshii.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus t'agoovahnyąą, “Nik'ee Dęhtły'aa Choo kat deegwinyąą gooh'in? ‘Kii chyah kat zheh ndak gwehee'aa, ąįį kii dinjii nąįį iizųų giiyahnyąą. Gaa ndaagwąą'ąį' dąį' kii hilee nilii. Jii t'ee K'eegwaadhat t'iizhit. Łyaa gwinzii giiyiichy'a'!’” ");
INSERT INTO gwiNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jesus chan t'inyąą, “Ąįįts'ą' t'ee nakhwaagwaldak, Vit'eegwijyąhchy'aa Veegwinii'ee nakhwałeegwirehee'aa ts'ą' juu dinjii deevarahnyąą ąįį gwik'it t'ii'in antł'eegwirehee'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Juu ąįį kii kat nat'aanąįį t'ee khadigweheent'ii, ts'ą' ąįį juu vakat kii naanaii t'ee yitreegwahaht'an ts'ą' łųh nahaadhal.” ");
INSERT INTO gwiNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Giinkhih kįh dilk'ii nąįį ts'ą' Pharisee nąįį haa Jesus gwandak haa geech'ǫąąhtan gwigwiitth'ak ąįįt'ee gooveeginkhii t'inyąą giiyaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ąįįts'ą' giihoondal gwik'eegogwandaii. Gaa juu Jesus, t'ee Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii yuunyąą nąįį łeeljil ąįį nąįį k'eegwiichy'aa deegoogiheelyaa geenjit googąąnjat. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus, chan hee gwandak ąhtsii zhit geech'ǫąąhtan haa dinjii nąįį ts'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Zheekat Gweegwinii'ee t'ee jyaa doonchy'aa. Ch'ihłan k'eedeegwaadhat choo (King) didinji' goohaanjik geenjit ch'arehee'aa gwahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ditsyaa nąįį ąįį juu ineech'ehił'al nąįį aanaii goovohnyąą nyąą, gaa oo'ee gwarǫh'ya' giindhan kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ąįįts'ą' t'ee ch'izhii ditsyaa haa neech'idiin'ąįį juu ineech'ahah'aa nąįį jyaa dagahaanjyaa geenjit, ‘It'ee ch'arehee'aa: sha-aak'ii ts'ą' aak'ii gii tthąį' nizįį kwaii khadiriint'uu ts'ą' datthak shragwaazhit. Nihłeegwarahchįį ch'arehee'aa, aanaii.’ goovaihnyąą nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Gaa juu ineech'ehił'al nąįį gwats'ą' tr'ahoojyaa giindhan kwaa ts'ą' digwigwitr'it gineegiitii. Ch'ihłak gwanzhįh deek'it gwats'ą' haazhii, ts'ą' ch'izhii chan dach'arookwat zheh gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Gwiizhit ch'izhii nąįį k'eedeegwaadhat choo vitsyaa nąįį ahtsik ts'ą' googahkhwąį' ts'ą' goovęhdaa tr'igwiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","(King) k'eedeegwaadhat choo łyaa zhyants'įį, ąįįts'ą' diniveet'ah'in nąįį oo'an hił'e'. Juu dinjii aghan nąįį ęhdaa tr'igwigwehee'aa ts'ą' goo-kwaiik'it gwachoo neegwagwahahk'an geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ąįįtł'ęę ditsyaa nąįį aanaii ahnyąą ts'ą' jyaa dagoovahnyąą, ‘It'ee nihłeegwarahchįį ch'arehee'aa, gaa ąįį juu ineech'ahał'aa nąįį duuyeh gooneech'ał'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","It'ee oo'at tąįį gwinjik gwinchyaa gwa'an dinjii lęįį nąįį dzaa gwats'ą' hohjyaa ts'ą' ch'oh'aa goovohnyąą.’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ąįįts'ą' t'ee vitsyaa nąįį oo'at tąįį gwinjik gwa'an dinjii lęįį khaihłan nigiinlii, dinjii nizįį ts'ą' dinjii iizųų haa nihk'it ts'ą' nihłeegwarahchįį ch'arehee'aa zheh gwizhit dinjii deedąą'ąį' goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“(King) k'eedeegwaadhat choo oozhat gwizhit juu ineech'ahah'aa nąįį nah'in akhai' dinjii ch'ihłak nihłeegwarahahchyaa geenjit needeegwaazhii kwaa łee nah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Shijyaa, nihłeegwarahchįį geenjit needeegwanzhii kwaa gwiizhit nats'ahts'ą' dzaa nihdeiinzhii?’ yahnyąą ts'ą' (King) k'eedeegwaadhat choo yuahkat. Gaa ąįį dinjii yidii ginkhii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tł'ęę t'ee k'eedeegwaadhat choh (King) ditsyaa nąįį jyaa dahnyąą. ‘Jii dinjii vanli' ts'ą' vakwai' haa dohchyaa ts'ą' chiitąįį tǫǫ gwats'ą' cheet'eehohkhii. Izhit t'ee gwintł'oo heetree ts'ą' dagho' nihts'ą' łǫǫn'al haa neeyik'ii k'it t'ihee'yaa.’” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ts'ą' Jesus ndaanich'igįįnkhee, “Lęįį nąįį aanaii arahnyąą, gaa nitsya' zhrįh gwitee tr'iriinlii t'oonchy'aa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pharisee nąįį gihłeegahoojil ts'ą' nats'ąą Jesus goohahkat haa goodhaii nigiihahthal geenjit geegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tł'ęę t'ee digitsyaa lat nąįį ts'ą' Herod vitsyaa lat nąįį haa giits'ą' hił'e'. Jyaa digiiyahnyąą, “Geech'ǫąąhtan, łi'didlii haa geech'ǫąąhtan naagwiindaii. Dinjii nąįį łi'didlii haa Vit'eegwijyąhchy'aa deegoo'ya' gavoonyąą ąįį gwik'it t'igihee'yaa geenjit geegoovąąhtan. Jidii k'it t'inchy'aa dinjii giinlii ąįį gwiinchyaa kwaa geh'an dinjii nąįį nats'ahts'ą' ninjich'agadhat ąįį geenjit tr'igwiindii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Diihaa gwandak, Caesar, Rome nahkat gwats'ą' k'eedeegwaadhat, vats'a' taxes tr'ookwat ji' dii-law inehts'į' t'igwii'in lee t'igwii'in? Googwarahookwat kwaa akwat googwarahookwat, jidii shrit?” ");
INSERT INTO gwiNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus ąįį giits'ą' gwiizųų t'igihee'yaa gwik'eegogwandaii goovaandaii ts'ą' t'inyąą, “Gwik'injiighit adaa'įį nąįį! Jaghaii gwiizųų t'ihihjyaa ji' geenjit, goodhaii nashahohthal gwik'eegǫhdaii? ");
INSERT INTO gwiNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ąįį laraa ghoo tsal (silver) noił'ya'!” Ąįįts'ą' laraa ghoo tsal giiyantł'eiin'ąįį, ");
INSERT INTO gwiNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ts'ą' goovahkat, “Juu vinin ts'ą' voozhri' haa vakat dha'aii?” ");
INSERT INTO gwiNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Caesar's reh,” ginyąą. Ąįįts'ą' Jesus t'agoovahnyąą, “Akwaa ji' Caesar jidii vats'an nilii haa vagohkwat ts'ą' Vit'eegwijyąhchy'aa jidii vats'an nilii haa vagohkwat.” ");
INSERT INTO gwiNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nijin jii gwigwiitth'ak dąį', deegiheenjyaa gaa gaagiindaii kwaa, ts'ą' akhagiiyuunyąą ts'ą' giihłeehoojil. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Zhat drin Sadducee lat nąįį nineegwaalii kwaa ginyąą ts'ą' Jesus ts'ą' gahaajil ts'ą' giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Geech'ǫąąhtan, Moses jii Law diineenjit diyaantł'oo, dinjii niindhat gwiizhit vigii kwaa gaa va'at gwanlii ji' ąįį vachaa, doondee'at nooheendal ts'ą' tr'iinin gihee'yaa ąįį ch'oondee vigii k'it dink'igiihahthaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ch'ihłan nihchaa 7 nąįį gwanlii; ch'oondee ąįį tr'injaa oonjik ts'ą' vigii kwaa gwiizhit niindhat, dachaa nąįį ts'ą' da'at akhoonyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ąįįtł'ęę vachaa yats'ąįį ya'at noonjik, ts'ą' gwats'ąįį ch'achaa chan gwik'it t'iizhik, ndaagwąą'ąį' dąį' nihchaa 7 nąįį datthak neegiiyuunjik gaa googii kwaa ts'ą' nigiinjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ąįįtł'ęę ąįį tr'injaa chan niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nijin drin niindhat nąįį neegogwandaii neegahoodlit nigwiindhat ji' nihchaa 7 datthak neegiiyuunjik ts'ą' juu zhrįh va'at heelyaa t'inchy'aa,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Gaa Jesus goodii ginkhii, “Dęhtły'aa Choo zhit deegwinyąą akwat Vit'eegwijyąhchy'aa vat'aii jiintsii kwaii gaakhwandaii kwaa geh'an gwinzii dohnyąą kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nigiindhat gwats'an neegwigwiindaii nąįį izhit ji' zheekat Gwich'in k'it t'igiheechy'aa ts'ą' nihłagooheendal kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ts'ą' Dęhtły'aa Choo kat nik'ee nigiindhat gwats'an neegwigwiindaii gwinyąą gooh'in ts'ą' Vit'eegwijyąhchy'aa jii jyaa nyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Shįį t'ee Abraham, Isaac ts'ą' Jacob haa Goovit'eegwijyąhchy'aa ihłii.’ nyąą, niindhat nąįį eenjit Vit'eegwijyąhchy'aa nilii kwaa gaa gwandaii nąįį eenjit gwizhrįh Vit'eegwijyąhchy'aa nilii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesus łyaa gooveenjit geegwaroolii kwaa, geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nijin Jesus, Sadducee nąįį deegiheenjyaa gaagiindaii kwaa gooviłtsąįį dąį', Pharisee nąįį gwigwiitth'ak ts'ą' datthak nihłaa khaihłak gaadlit, ");
INSERT INTO gwiNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ts'ą' gootee ch'ihłak, Law geech'ǫąąhtan nilii ąįį goodhaii niyahahtthal geenjit yuahkat, ");
INSERT INTO gwiNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Geech'ǫąąhtan, jidii Moses va-law zhrįh ch'andaa jiintsii t'oonchy'aa?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus t'iiyahnyąą, “‘K'eegwaadhat Nivit'eegwijyąhchy'aa nidrii datthak, ts'ą' nizhin datthak, ts'ą' niyinji' datthak haa veet'ihiinghyaa goo'aii!’ ");
INSERT INTO gwiNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jii t'ee tr'ookit jyaa digwehee'yaa gwinyąą ąįį jiintsii nilii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Gwats'ąįį chan vik'it t'iiyiinchy'aa, ‘Deegwahtł'oo ideet'iindhan googwahtł'oo ninee'ok dinjii nąįį datthak eet'ihiinghyaa goo'aii.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ąįį gwik'it Moses va-law datthak, ts'ą' Dęhtły'aa Choh zhit Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį jidii eech'agǫąąhtan datthak jii law neekwaii ts'an t'ee gwizhrįh gwit'eegaahchy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nijin Pharisee nąįį nihłaa nineegeejil dąį' Jesus gavaahkat, ");
INSERT INTO gwiNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Christ eenjit deeyųųhthan? Juu ts'an neezheeneedijii t'inchy'aa.” yahnyąą. “Yeenii King David vizhehk'aa gwats'an ahaa t'inchy'aa,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus gavahkat, “Akwaa ji' jaghaii, Ch'anky'aa Shroodiinyąą zhit King David Shik'eegwaadhat yahnyąą?” Dęhtły'aa Choo zhit David jii jyaa nyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘K'eegwaadhat ąįį Shik'eegwaadhat jyaa dahnyąą, dzaa shriits'ąįį sheeghaii dhindii, dahthee juu nits'į' t'inchy'aa nąįį nakwai' t'eh nihihłyaa gwats'ą' datthak.’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","King David, adan gaa Shik'eegwaadhat yahnyąą gwiizhit nats'ahts'ą' Christ ąįį yeenii David ts'an diheedhaa?” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ch'ihłak gaa Jesus deegahaanjyaa gaagiindaii kwaa, ąįį zhit drin gwats'an giiyuuhaahkat gwits'į' adak'agaantii. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ąįįtł'ęę Jesus zhit juu łeeljil nąįį ts'ą' ditsyaa nąįį haa ts'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Law eech'ǫąąhtan nąįį ts'ą' Pharisee nąįį haa Moses va-law deenyąą ąįį łihteech'igiheelyaa geenjit t'aih gii'įį t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ąįį geh'an deenakhwagahnyąą datthak gwik'it t'akhwa'yaa gwizhrįh goo'aii. Gaa zhit gwa'an deegii'in ąįį gwik'it t'akhwa'ya' shrǫ'. Jidii geenjit geech'agoahtan ąįį geedan gwik'it t'igii'in kwaa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dinjii nąįį ant'ii ghwah nidii giheeghwaa dagahchaa k'it t'igii'in gaa goots'ahohjyaa eenjit daganleetth'ak gaa gihichįį kwaa t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dinjii nąįį goohaah'yaa geenjit chan jidii datthak t'igii'in. Gwach'aa ts'ik (Straps) kat chan gwiintsii ts'ą' dęhtły'aa choh ts'an ch'adagantł'oo ts'ą' digigin kat ts'ą' dagants'ak kat nigiiyaazhii, ąįįts'ą' chan digi'ik kat gwi'ił (tassel) ąįį nijyaa gahtsii dagakat nagaazhii googahah'yaa geenjit jyaa digii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ąįįts'ą' chan nijin ch'aga'aa dąį' zhit gwihił'ee gwa'an gaadii gwizhrįh geet'igiindhan, ts'ą' Jews' tr'igiinkhii zheh, gwizhit nijin gwihil'ee ąįį zhit giheedyaa gwizhrįh gooveenjit gwinzii. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nijin ch'arookwat zheh goodlii chan dinjii gwanlii tee gwihil'ee haa gooneerahąhdak gwizhrįh łyaa geet'igiindhan, ts'ą' dinjii nąįį ‘Diigeech'oahtan!’ googahnyąą dąį' łyaa geet'igiindhan. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Gaa nakhwan ąįį geech'ǫąąhtan choh inlii nakhwaroonyą' shrǫ'. Datthak ts'ą' nihchaa ǫhłįį ts'ą' nakhweegeech'oahtan ch'ihłak zhrįh gwanlii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Dzaa nankat dinjii ch'ihłak gaa Gwiti' vohnyą' shrǫ', zheekat Gwiti' ch'ihłak zhrįh gwanlii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","K'eedeegwaadhat kįh dhidii naroonyą' shrǫ', nakhwan tee ch'ihłak zhrįh K'eegwaadhat ts'ą' kįh dhidii t'oonchy'aa ąįįt'ee Messiah oozhii t'inchy'aa ts'ą' ąįį Messiah t'ee Christ t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Juu nakhwatee ch'ihłak ch'andaa sheegoo'aii niindhan t'ee nakhwa-slave heelyaa gwizhrįh goo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Juu ch'andaa gwiintsii sheegoo'ai' niindhan Vit'eegwijyąhchy'aa khazhak t'inchy'aa yahahtsyaa, ąįįts'ą' juu khazhak t'inchy'aa ąįįt'ee Vit'eegwijyąhchy'aa ch'andaa gwiintsii veegoo'aii yahahtsyaa t'inchy'aa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Pharisee nąįį ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa, nakhwadiveegwiizųų nakhweenjit goo'aii! Nizįį adoo'įį geh'an! Zheekat Gweegwinii'ee gwats'ą' dinjii nąįį nihdeegiheedaa geenjit lidlįį goonin ts'ą' łi'didlii haa gindeiinvyaa gehdeech'adǫhtin ts'ą' nakhwan gaa nihdǫhjyaa kwaa gwiizhit zhit juu nihdeegohoojyaa giindhan nąįį gaa nihdǫhłii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Pharisee nąįį ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa, nakhwadiveegwiizųų nakhweenjit goo'aii! Nizįį adoo'įį geh'an! Tr'injaa vakai' niindhat nąįį ts'an jidii nohthan zhyaa ǫhjii ts'ą' goozheh gwats'an ch'oh'įį, ąįįtł'ęę nakhwarahaah'yaa geenjit niighyuk khagadǫhjii. Jyaa dakhwa'in geh'an ch'andaa nakhwagwarahahshii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Pharisee nąįį ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa, nakhwadiveegwiizųų nakhweenjit goo'aii! Nizįį adoo'įį geh'an! Chųų choh deetaa gaa neekhwadal ts'ą' chan nankat deetaa niighit gaa neekhwadal, dinjii ch'ihłak zhrįh gwik'injahohdaa geenjit jyaa dakhwa'in, ts'ą' nijin dinjii ch'ihłak gwik'injiighit ilik dąį' gwehkįį chan gwandaa hell gwats'ą' heekhaa ohtsii. Nakhwant'ee hell gwats'ą' hohdaa adootsii gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Łyaa nakhweenjit googwantrii nakhwaa gweech'in kwaa gwiizhit dinjii nąįį oh'aa ts'ą' jii jyaa dohnyąą, ts'ą' geech'ǫąąhtan, ‘Dinjii Kharigidiinjii zheh eh'an jyaa dishi'yaa nyąą (vow) ąįį jyaa dii'in gwat'aahchy'aa kwaa, gaa zhit juu Kharigidiinjii zheh gwizhit gold k'iighai' jyaa t'ishi'yaa nyąą (vow), ąįįt'ee łyaa gwik'it t'eehee'yaa gwizhrįh goo'aii t'oonchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nakhwaa gweech'in kwaa ts'ą' tr'agǫhjik ky'aa tr'agwah'in, jidii shrit ch'andaa gwihil'ee, gold akwat Kharigidiinjii zheh? Kharigidiinjii zheh t'ee gold izhit shroodiinyąą ąhtsii doonchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Jii chan jyąhts'ą' geech'ǫąąhtan, ‘Zhit juu Kharigidiinjii zheh ataiinjii tr'ahtsii deek'it (Altar) eh'an t'ishi'in nyąą ji', jii deeshi'yaa nyąą gwik'it t'ii'in gwat'aahchy'aa kwaa t'inchy'aa, gaa ataiinjii tr'ahtsii deek'it kat jidii dohdlii eh'an t'ishi'in nyąą ji' t'ee gwik'it t'ihee'yaa gwizhrįh goo'aii t'inchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Deegwahtł'oo zhyaa nakhwaa gweech'in kwaa! Jidii shrit ch'andaa veegoo'aii t'inchy'aa? Zhit jidii ataiinjii tr'ahtsii deek'it kat doodlii Vit'eegwijyąhchy'aa gwantł'eerinlii akwat zhit altar ąįį jidii gwakat doodlii ąįį shroodiinyąą ąhtsii? ");
INSERT INTO gwiNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Izhit geh'an nijin dinjii ch'ihłee ataiinjii tr'ahtsii deek'it ąįį ch'andaa veegoo'aii eh'an t'ishi'in nyąą ji' t'ee ąįį altar ąįį ch'andaa veegoo'aii kat jidii doodlii datthak eh'an t'ihee'yaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ąįįts'ą' Kharigidiinjii zheh eh'an t'ishi'in nyąą ji' t'ee ąįį Vit'eegwijyąhchy'aa zhat gwich'įį chan eh'an t'ii'in t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ąįįts'ą' zheekat geh'an t'ishi'in nyąą ji' t'ee nijin Vit'eegwijyąhchy'aa k'eedeegwaadhat yakat doodii ąįį zhit gwats'ą' jyaa shi'yaa nyąą t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Pharisee ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa nakhwadiveegweheezųų t'oonchy'aa. Nizįį adoo'įį k'it t'akhwa'in! Datthak ts'ą' jidii nǫhshįį ąįį ts'an 1/10th datthak Vit'eegwijyąhchy'aa vantł'oolii, jii kwaii t'ee herbs, mint, dill, ts'ą' cumin kwaii vantł'oolii gaa neeshraahchy'aa nohthan geh'an jii ch'andaa gwihil'ee ąįį gwik'it t'akhwa'in kwaa, ts'ą' chan łi'deegweheedlii goo'aii ts'ą' dinjii nąįį datthak ts'ą' gwinzii t'igwehee'yaa goo'aii. Jii kwaii datthak khit gwik'it t'akhwa'yaa gwizhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nakhwaa gweech'in kwaa gwiizhit dinjii nąįį ineehohdak! Chųų khwanįį zhit ts'an dąįį tsal khohchik, googaa Camel choh ąįį khadhohdak t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Pharisee nąįį ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa nakhwadiveegweheezųų t'oonchy'aa. Nizįį adoo'įį k'it t'akhwa'in! Nakhwachųų tyah ts'ą' nakhwak'ik haa ohts'ąįį gwizhrįh shragoohnyąą gaa nakhwadrii zhit jidii ǫhjii kwaii haa nakhwatr'eegwahgaii ts'ą' gweedhaa datthak nakhwan zhrįh idininjich'ohthat, jii iizųų kwaii datthak haa nakhwadrii zhit deedagwaan'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Pharisee nąįį, nakhwaa gweech'in kwaa! Nakhwachųų tyah ts'ą' nakhwak'ik haa zhit tr'ookit shragoonyąą ąįįtł'ęę t'ee ohts'ąįį shragoonyąą gweheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Pharisee nąįį ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa, nakhwadiveegwiizųų nakhweenjit goo'aii! Nizįį adoo'įį geh'an! Ch'a'an tth'ank'it ąįį gwinzii daagąįį tr'ahtsii k'it t'ohchy'aa, ohts'ąįį gwats'an gwinzii t'akhwa'in k'it nakhwayiichy'a' gaa nakhwazhit tth'an lęįį dhidlii ts'ą' ch'ichį' ahjat kwaii nakhwazhit dhidlii haa deedagwaa'ąį' t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jii jyąhts'ą' gwik'it, juu nąįį datthak ts'ą' ohsįį k'it t'akhwa'in gaa nakhwadrii zhit tr'agwaanduu goo'aii ts'ą' dohnyąą chan gwik'it t'akhwa'in kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Pharisee nąįį ts'ą' Law eech'ǫąąhtan nąįį haa łahchy'aa, nakhwadiveegwiizųų nakhweenjit goo'aii! Nizįį adoo'įį geh'an! Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį ts'ą' juu Vit'eegwijyąhchy'aa vik'eegwahthat nąįį chan gootth'ank'it gwakat kii choh nizįį haa gwinzii nidiiltsį' ts'ą' nǫhłii. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yeenii nakhwalak nąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį giinghan ąįį yeenaa dąį' gwarandaii ji' diikhwan duuyeh gwik'it t'igwii'in dohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Yeenaa nakhwalak nąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį giinghan nąįį goots'an ohdaa ąįįts'ą' łyaa gwik'it t'igiizhit dohnyąą! ");
INSERT INTO gwiNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Juk gweendaa Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį goovęhdaa tr'agǫh'aa jaghaii? ");
INSERT INTO gwiNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gyųų choh ǫhłįį ts'ą' gyųų choh gii chan ǫhłįį ts'ą' nats'ahts'ą' hell nihdeenakhwaraheelyaa, ąįį gehgoo hohdaa nohthan? Duuyeh gwik'it gwanlii! ");
INSERT INTO gwiNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Jii łyaa nakhwaa gwaldak t'ihnyąą, Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį, ts'ą' dinjii vigwizhi' gwanlii nąįį, ts'ą' dinjii geech'ǫąąhtan nąįį datthak nakhwats'ą' nihihłyaa, goolat nąįį chan goovęhdaa tr'agahoh'aa, ts'ą' goolat nąįį chan nihk'ataa'ee (cross) kat gagoovahohtsak, ts'ą' goolat nąįį chan Jews' tr'igiinkhii zheh datthak gwizhit viitrii haa goovahohtrii ts'ą' kwaiik'it kwaii gwiteegwaanchy'aa datthak gwitee gwa'an gootąįį k'eekhwadal ts'ą' dinjii nąįį neeshraahchy'aa hohtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jyąhts'ą' gwik'iighai' juu dinjii vatr'agwaanduu gwakwaa giiłkhwąįį nąįį, ąįį datthak nakhwak'aa deegwahaadhal. Abel gwiizųų t'iizhit kwaa gaa tr'eełkhwąįį, aiizhit dąį' gwats'an ts'ą' Berechiah vidinji' Zechariah tr'eełkhwąįį, ąįįt'ee Kharigidiinjii zheh ts'ą' zhit ataiinjii tr'ahtsii deek'it haa gwideetak giiyeełkhwąįį geenjit khaiinjich'anakhwarahahkhit t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jii łyaa gwik'it t'igwehee'yaa ąįį nakhwaagwaldak t'ihnyąą.” Jesus nyąą. “Jii juu yeenii tr'iinghan nąįį, juk gweendaa dinjii gwandaii nąįį geenjit googwarahaahshii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem, Jerusalem! Nakhwatee juu Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį ohghan ts'ą' juu Vit'eegwijyąhchy'aa nakhwats'ą' hił'e' nąįį chan kii haa dohkhok. Gwinlęįį neegwiidhat gwizhit zhat gwich'in nąįį datthak ts'ą' khaihłan nineegavoihłyaa goovoihnyąą, zhit gwa'an dats'an digii tsal nąįį datthak dit'ee t'eh iłdlii gwik'it gaa khyų' t'akhwa'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ąįįts'ą' Nakhwakharigidiinjii Zheh nakhwats'į' hee gwarooheendal. ");
INSERT INTO gwiNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nakhwaagwaldak, nijin drin jyaa dahohjyaa gwats'ą' shahooh'yaa kwaa, ‘K'ii'ee juu Vit'eegwijyąhchy'aa voozhri' zhit ahaa Vit'eegwijyąhchy'aa yaa shoo oolį'.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nijin Jesus, Kharigidiinjii Zheh gihłeehoozhii ts'ą' gwa'an tr'ineezhii dąį' vitsyaa nąįį giits'ą' haajil ts'ą' jii Kharigidiinjii zheh gwachoh ts'ą' geeghaih gwa'an zheh goodlii haa gwąąh'in giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Gaa Jesus goodii ginkhe', “Aahą', jii kwaii datthak gwinzii nǫh'in. Jii łi'haa nakhwaagwaldak, Yeendaa ji' kii tsal ch'ihłak gaa neekwat dehee'aa kwaa ts'ą' gwideek'it hee'aa kwaa. Datthak an heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus, Taih Vakat Olives Nahshii kat dhidii gwiizhit vitsyaa nąįį gweentak giits'ą' haajil ts'ą' giiyųąhkat, “Zhat nigwiindhat ji', deegwehee'yaa ts'ą' deegweheenjyaa diinaa gwandak. Nijin neiindyaa ts'ą' ndaagwahąąn'ąį' gwats'ą' nahgwan ji' deegwehee'yaa gwarahąąh'yaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus t'agoovahnyąą, “Gwits'į' adak'ǫǫntii! ts'ą' neenakhwaroon'ee shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Dinjii lęįį nąįį nakhwats'ą' giheedaa ts'ą' ‘Shįį t'ee Christ (Messiah) t'ihchy'aa!’ giheenjyaa ts'ą' veenjit gihkhii t'inyąą giheenjyaa ts'ą' dinjii lęįį nąįį neegeheen'ee t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nihłiriighan gwahohtth'ak ts'ą' yeenjik niighit gwa'an nihłiriighan gwinyąą gwahohtth'ak, gaa geenjit nakhwadrii zhit neets'ąįįneegoojyaa shrǫ'! Jyaa dagweheenjyaa goo'aii, gaa ąįį nan ndaanąą'ąį' gweheelyaa t'igwii'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nahkat gwanlii ts'ą' geegwinii'ee gwinlęįį chan nihłigiheeghaa. Nijuk datthak chan nan haatrat, ts'ą' dinjii chan ihdeeheengaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ąįį kwaii datthak t'ee tr'injaa tr'ookit tr'iinin haa tr'iłts'ik k'it t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ąįįtł'ęę nakhwagooheendal ts'ą' khaiinjich'anakhwagahahkhit geenjit gwantł'ee nakhwagahahchyaa ts'ą' nakhwęhdaa tr'igwigwehee'aa. Ts'ą' shęh'an nahkat datthak nakhwatr'igehee'ee. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lęįį nąįį zhat nigwiindhat ji' digwik'injigwiighit akhagagooheenjyaa, gwantł'ee nihłagahaachyaa ts'ą' chan łyaa nihłitr'igihee'ee. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ąįįtł'ęę Vit'eegwijyąhchy'aa Eenjit Ginkhii adaa'įį lęįį nąįį gweheelyaa ts'ą' dinjii lęįį nąįį neegeheen'ee t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Izhit ji', dinjii lęįį nąįį tr'agwaanduu googwitr'it gweheelyaa, ts'ą' lęįį nąįį nihłeenjit ch'eet'igwiniindhan hee'yaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gaa juu ndaagwąą'ąį' gwats'ą' datthak gwik'injigwiighit di'įį t'ee neeheezhii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ts'ą' jii Vit'eegwijyąhchy'aa Veegwinii'ee, Gwandak Nizįį haa nankat datthak geech'agoohahtan, dinjii nąįį datthak shik'injigiheeghit, ąįįtł'ęę nan ndaagwahąąn'ąį' nagwahaadhal.” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ąįį Kharigidiinjii Zheh gwizhit shroodiinyąą goo'aii ąįį, ‘Jidii tr'agwaanduu gwiizųų,’ Vit'eegwijyąhchy'aa vakharigidiinjii zheh shroodiinyąą kwaa gwahtsii zhat gwizhit nin'ąįį. Ąįįt'ee Daniel Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii geenjit gwadąąntł'oo t'inchy'aa.” (Ąįįts'ą' juu jii dęhtły'aa nah'in nąįį t'ee deegwinyąą t'igwinyąą gwinzii gaakhwandaii gwat'oohchy'aa, t'oonchy'aa.) ");
INSERT INTO gwiNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Jyaa digwiizhik gwagwahkhan zhit juu Judea nahkat gwizhit gwich'įį nąįį taih kat gwats'ą' gal gahahdaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Zhit juu dizheh gwakat doodii gwiizhik jyaa digwiizhik ji' dik'eiich'ii neehoondal geenjit dizheh nihdanǫǫzhi' shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Zhit juu gwanzhįh deek'it gwitr'it t'agwah'in gwiizhik jyaa digwiizhik ji' ch'adak ik nooheendal geenjit dizheh gwits'eehoozhi' shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Izhit ji' łyaa tr'injaa vizhit tr'iinin chan ts'ą' juu tr'iinin ach'ahma' nąįį haa eenjit gwigweheetrii t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Vit'eegwijyąhchy'aa vats'a' khagadǫhjii Neegwaazhii Drin akwat khaii gwanlii gwiizhit t'igweheenjyaa kwaa geenjit! ");
INSERT INTO gwiNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Zhat nigwiindhat ji' googwantrii nagwahaadhal, Vit'eegwijyąhchy'aa jii nan iłtsąįį dąį' gwats'an ch'ihłok gaa jyaa dagwahtł'oo googwantrii gwaraah'in kwaa, akwat chan ch'ihłok gaa jyąhts'ą' neegwarahaan'yaa kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gaa K'eegwaadhat, drin gwitee gwagwaanchy'aa nahgǫǫ neegwiłtsąįį kwaa ji' jii nankat dinjii nąįį datthak an heelyaa t'oonchy'aa. Ąįį dinjii gwitee tr'iinlii nąįį jyaa dagwahkhyuk khaiinjich'igiheeghit kwaa eh'an drin gwiteegwagwaanchy'aa nahgǫǫ niłtsąįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ąįįts'ą' chan, ‘Dzaa Christ dhidii nǫh'in!’ akwat ‘Oo'at dhidii t'inchy'aa!’ ąįį dinjii ch'ihłee jii jyaa nahnyąą ji' gaa gwik'injuhkhit shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Christ adagaa'įį ts'ą' Vit'eegwijyąhchy'aa eenjit ginkhii ihłii nyąą nąįį gwigwee'in ts'ą' geegwaroolii kwaa t'igihee'yaa haa Vit'eegwijyąhchy'aa dinjii gwitee tr'iinlii nąįį neegeheen'ee gaa gach'agwadhan ji' gwizhrįh t'igihee'yaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Gwik'it t'igweheenjyaa gwehkįį nakhwaagwaldak t'ihnyąą, geenjit shoodǫǫhk'įį! ");
INSERT INTO gwiNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Akwat dinjii nąįį, ‘Zhit gooh'in nangwinjir gwa'an dhidii t'inchy'aa,’ ginyąą ji' gwats'ą' hohjyaa shrǫ'. Akwat chan ‘Dzaa gooh'in, geegoh'ik ch'an'įį łee!’ ginyąą ji' gaa gook'injuhkhit shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nijin Gwidinji' dzaa gwits'eehidii ji' East gwats'an West gwats'ą' nahtan kǫ' haadhak k'it zheetii datthak ch'eegwąhndit nagwahaadhal t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Jii k'it t'igweheenjyaa t'oonchy'aa, nijin ch'atthąį' iłchįį t'ee zhat gwa'an vultures (deetrya' k'it t'inchy'aa) nąįį łaahaadaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Googwantrii gwiizųų gehgoo goodhat gwagwahkhan shree ch'ahahdrii kwaa nahaadhal ts'ą' tǫǫ oozhrii chan ch'ahahdrii kwaa, ts'ą' są' chan zheekat gwats'an niheedaa. Ts'ą' zheetii gwa'an jidii dhidlii kwaii datthak haatrat. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Gwidinji' nats'ahts'ą' vagwahaakyaa Jesus jyaa nyąą ąįį gwik'it zheetii vagwahaakyaa, ąįįtł'ęę nankat gwich'in nąįį datthak Gwidinji' zheekat, gwats'an zheek'ǫh zhit vat'aih ts'ą' vich'eegwąhndit jiintsii haa k'iidąą needyaa ji', tr'igwidii haa treeyah hee'aa gwiizhit giiyahaah'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Trumpet, vach'arahłii nilii gwint'aii haahchik nagwahaadhal, gwiizhit dizheekat gwich'in nąįį dzaa nankat gwizhit datthak gwats'ą' nagavaheelyaa ts'ą' Vit'eegwijyąhchy'aa juu gwitee tr'iinlii nąįį datthak khaihłan nigiheelyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Zhit ts'iivii Fig vakat nahshii, ąįį vats'an gwagoo'ee. Nijin vatthoochan tth'aii hee datłok ts'ą' vakat ch'at'an tsal khan nahshii dąį', it'ee shin gwats'ą' nahgwan gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Izhit gwik'it deegwehee'yaa diinyą' gwik'it t'igwii'in gooh'in ji' t'ee yee'at tthał nii'ee nihdeegweedii gwats'ą' ahaa vaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Łi'haa nakhwaagwaldak t'ihnyąą! Juk gweendaa gwandaii nąįį datthak niheedhaa kwaa ts'ą' jii kwaii zhit gweheedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zhee, nan haa kwaa gweheelyaa gaa shiginjik ąįį khit łi'didlii heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ch'ihłak gaa nijin drin akwat nijin ji' t'igweheenjyaa gaandaii kwaa, zheekat gwich'in nąįį ts'ą' Gwidinji' haa gaagiindaii kwaa gaa Gwiti' zhrįh gaandaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Gwidinji' k'inidik ji' deenaadąį' Noah vaadeegwiizhit chy'ah ąįį gwik'it t'ineegweheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Zhat drin gwanaa dąį', nankat datthak chųų teehaankhaii nagwahaadhal gwats'ą' dąį' dinjii nąįį ch'aga'aa ts'ą' ch'igiinįį, dinjii ts'ą' nich'it haa nihłagoonjii googwahtsii, dahthee Noah tr'ihchoo zhit heekhaa gwats'ą' datthak jyaa digee'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Googaa aiizhit dąį' deegwii'in gaagiindaii kwaa, gaa deegwii'in gwik'igaanjik dąį' gookat chųų t'iizhit ts'ą' chųų datthak goovoonjik. Nijin Gwidinji' k'inidik ji', jyaa digweheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jyaa digwii'in gwiizhit dinjii neekwaii nąįį gwanzhįh deek'it tr'agwagwah'in, Gwidinji' ch'ihłak ąįį neehoondal ts'ą' ch'ihłak ąįį zhat akhahoonjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tr'injaa neekwaii nąįį, łųhchy'aa vaatr'ahtsii haa tr'agogwah'in, gwiizhit Gwidinji' ch'ihłak neeyahoondal ts'ą' ch'ihłak ąįį zhat akhahoonjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nijin drin K'eegwaadhat neeheedyaa gwak'ǫǫhtii kwaa ji' gaakhwandaii kwaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Gaa jii gaakhwandaii! Ąįį dinjii nijin tǫǫ gwa'an juu ch'an'įį yizheh łeegwahahnaii gaandaii ji' yeenjit nagoohaah'yaa ts'ą' duuyeh yizheh łeegwahnaii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jyąhts'ą' geh'an nakhwan chan oohadhanzhii gwizhrįh goo'aii, Gwidinji' geehoohłii kwaa gwiizhit k'ineeheedik t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Juu yats'ą' k'eedeegwaadhat eenjit yitsyaa nilii t'ee vigwitr'it gwinzii ts'ą' chan goonzhįį? Ąįį t'ee juu yats'ą' k'eedeegwaadhat ch'izhii ditsyaa nąįį k'eehahtyaa yahahtsyaa ts'ą' drin gwiteegwaanchy'aa zhat nineegwiidhak dąį' gooch'ahah'aa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nijin juu yats'ą' k'eedeegwaadhat oo'ee neezhįį ts'ą' jyaa dii'in yah'in ji' łyaa gwintł'oo yashoohahłyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Łyaa, nakhwaagwaaldak! Ąįį juu yats'ą' k'eedeegwaadhat jidii veegoo'aii datthak k'eehahtyaa yahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gaa ch'itsyaa iizųų nilii ji' adats'ą' giheehkhyaa ts'ą' jyaa diheenjyaa, ‘Shats'ą' k'eedeegwaadhat niighyuk oo'ee neeheedyaa kwaa t'oonchy'aa.’ heenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ts'ą' juu yaatr'agwah'in nąįį dahkhwaii ts'ą' ch'anakhwanį' nąįį haa ch'a'aa ts'ą' ch'iinįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Nijin ji' juu yats'ą' k'eedeegwaadhat k'ineeheedik gaandaii kwaa geh'an geeneeyuulii kwaa gwiizhit yarahtee k'ineeheedik. ");
INSERT INTO gwiNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jidii tsal nilii ts'ą' khandiyeheent'ii ts'ą' juu gwik'injiighit adaa'įį nąįį haa niyahahchyaa, izhit t'ee gwintł'oo heetree ts'ą' dagho' nihts'ą' łǫǫn'al haa neeyik'ii k'it t'ihee'yaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Izhit ji', Zheekat Gweegwinii'ee, jii jyaa t'igweheechy'aa t'oonchy'aa. Ch'ihłan nich'it (10) nąįį khwaiidaak'a' kwaii tee gwigwįłjik ts'ą' zhit juu gooheendal goo'aii, ts'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","5 nąįį gwagoonzhii, ts'ą' ch'izhii 5 nąįį chan googwizhi' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nich'it googwizhi' kwaa nąįį khwaiidaak'a' eenjit gah khwaii neegahaazhik kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Gaa nich'it googwizhi' nąįį khwaii gwizhit neegeheenjaa geenjit ch'ityah choh goonjik dahaa neegahaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zhit juu veegwarahahchyaa goo'aii, ąįį eenjit nagogwal'in, akhai' niighyuk nigiiyuul'in, ts'ą' geełchųų. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Khan hee tǫhtł'an gwats'ą' gwaadhal gwiizhit khashraatr'iintrat gwigwiitth'ak, ‘Aanaii, dzaa juu veegwarahahchyaa nąįį vats'a' hohjyaa,’ gwinyąą gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gwiizhit nich'it (10) nąįį khakigaazhii ts'ą' dagakhwaii daak'a' shrineegiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ąįįtł'ęę zhit nich'it vigwizhi' kwaa nąįį zhit nich'it vigwizhi' gwanlii nąįį jyaa dagaanyąą, ‘Diikhwaii daak'a' kwaii nikyaa, nakhwakhwaii lat diinantł'ohjyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Zhit vigwizhi' gwanlii nąįį jyaa googahnyąą, ‘Łyaa nakwaa, datthak diineenjit khwaiidaak'a' gadhan kwaa t'oonchy'aa, ch'arookwat zheh gwats'ą' hohjyaa ts'ą' kwaii daak'a' ohkwat.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ąįįts'ą' t'ee nich'it vigwizhi' kwaa nąįį khwaiidaak'a' goohookwat geenjit ch'ookwat zheh gwats'ą' gahaajil, gihiljii gwiizhit zhit juu veegwarahahchyaa zhat k'idik dąį', zhit nich'it 5 zhat dilk'ii nąįį giiyaach'ihee'aa geenjit giiyaanihdeiinjil, ąįįtł'ęę gindeiinvyaa an ineegahjik. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ąįįtł'ęę nich'it vigwizhi' kwaa 5 nąįį zhat k'ineegiidal ts'ą' gazhral, ‘K'eegwaadhat, K'eegwaadhat! Nihdeediiniinlii,’ giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Gaa goodii ginkhe', ‘Łi'haa nakhwaashandaii kwaa t'oonchy'aa!’” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ąįįts'ą' t'ee Jesus ndaanaahjik ts'ą' t'inyąą, “Nijin ji' t'igwehee'yaa gaakhwandaii kwaa jyąhts'ą' geh'an adak'ǫǫntii ts'ą' gwak'ǫǫhtii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Izhit zhat ji' Zheekat Gweegwinii'ee jii k'it jyaa digweheechy'aa. Ch'ihłan dinjii ch'ihłak khaihtak gwa'an k'eeheedik geenjit dizheh gihłeehaazhii, ditsyaa nąįį aanaii ahnyąą ts'ą' jii jidii shats'an kwaii datthak k'ǫǫhtii goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Gooteegwagwaanchy'aa ts'ą' deegihee'yaa gagadhan ąįį goots'an gwiłtsąįį: ch'ihłak gold laraa ghoo 5,000 yats'an iłtsąįį, ch'izhii chan 2,000 yats'an iłtsąįį, ts'ą' ch'izhii chan 1,000 yats'an iltsąįį. Ąįįtł'ęę khaihtak gwa'an k'eeheedik geenjit gihłeehaazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Vitsyaa, 5,000 laraa ghoo antł'eiinlii ąįį gwagwahkhan gwandaa yaa laraa neehahtsyaa geenjit niyinlii ts'ą' chan 5,000 laraa yaa niłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ąįį gwik'it vitsyaa juu 2,000 laraa ghoo antł'eiinlii chan 2,000 laraa yaa niłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gaa vitsyaa juu 1,000 laraa ghoo ts'an iłtsąįį ąįį oo'at gwa'an nanzhit k'eedeegwaadhat valaraa gwit'eh inlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ąįį k'eedeegwaadhat niighyuk hiljii tł'ęę ditsyaa eek'inidik ts'ą' laraa goovantł'eiinlii dahtsii giłtsąįį li' geenjit goovahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Vitsyaa juu 5,000 laraa ghoo antł'eiinlii chy'aa nideiinzhii ts'ą' gah 5,000 chan yantł'eeneiinlii. ‘K'eedeegwaadhat, Laraa ghoo 5,000 shantł'eiinlii chy'aa gwah'in! Dzaa chan gah 5,000 doltsąįį.’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Łyaa gwinzii t'inizhit, shitsyaa oots'it kwaa haa gwinzii sheenjit gwitr'it t'agwah'in inlii laraa tsal gwinzii k'eenohti' geh'an laraa gwandaa t'ąąnchy'aa k'eehahtyaa nats'an hałtsyaa, nihdeiinkhaii ts'ą' shaa shroonchy'aa gwahtsii.’ k'eedeegwaadhat yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tł'ęę vitsyaa juu 2,000 laraa ghoo antł'eiinlii chan nihdeiinzhii ts'ą' t'iiyahnyąą, ‘Shik'eedeegwaadhat, dzaa gwah'in! Laraa ghoo 2,000 shantł'eiinlii chy'aa ch'izhii 2,000 chan gah vaa dooltsąįį.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Łyaa gwinzii t'inizhit, shitsyaa oots'it kwaa haa gwinzii sheenjit gwitr'it t'agwah'in inlii, laraa tsal gwinzii k'eenohti' geh'an laraa gwandaa t'ąąnchy'aa k'eehahtyaa nats'an hałtsyaa. Nihdeiinkhaii ts'ą' shaa shroonchy'aa gwahtsii,’ k'eedeegwaadhat yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tł'ęę vitsyaa 1,000 laraa ghoo antł'eiinlii nihdeiinzhii ts'ą' t'inyąą. ‘Shik'eedeegwaadhat dinjii vagwantrii inlii naashandaii, nijin gwanzhįh gwit'eh inlii kwaa gwa'an gaa gwanzhįh khaihłan niinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Naljat, geh'an oo'an hoiizhii ts'ą' nalaraa nan t'eh iilii. Gwah'in! Dzaa na-laraa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Yats'ą' k'eedeegwaadhat yahnyąą, ‘Shitsyaa iizųų ts'ą' tr'agoodiinjik inlii! Nijin gwanzhįh li' gwit'eh iilii kwaa gaa gwanzhįh nałshii ts'ą' gwanzhįh li' khałtł'ak kwaa gwa'an gwanzhįh khaihłan nihłii. Ąįį gaanaandaii hee? ");
INSERT INTO gwiNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ąįį ji' t'ee, shalaraa oo'at laraa zheh niinlii ji' gwandaa nilii ts'ą' neekhohdal. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Zhit laraa vits'į' nǫhjii ts'ą' zhit juu 10,000 laraa ghoo di'įį vantł'eeyuhłii. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Dinjii juu jidii datthak k'eegwiichy'aa gwii'įį, ąįį gwandaa vats'an neeheelyaa, ts'ą' yit'eehaahchy'aa geenjit gwandaa hee'yaa, gaa juu k'eegwiichy'aa nitsya' zhrįh gwii'įį, datthak vits'į' neerooheendal. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ąįįts'ą' jii shitsyaa giilį', oo'at tǫǫ k'ii'an hee t'ee hohkhii, izhit t'ee gwintł'oo heetree ts'ą' dagho' nihts'ą' łǫǫn'al haa neeyik'ii k'it t'ihee'yaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nijin Gwidinji', K'eegwaadhat Choo nilii Dich'eegwąhndit zhit gwats'an needyaa ji' dizheekat gwich'in nąįį datthak oodaa dahaa heelyaa, ts'ą' k'eedeegwaadhat ts'ą' vakat daraadii chil'ee ąįį kat diheedyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Gwiizhit nihky'aa nankat gwich'in nąįį datthak khaihłan nigiheedaa ts'ą' giiyęhdaa niheedaa. Nihtee tr'agavaheelyaa ts'ą' divii k'ąąhtii k'it, divii ts'ą' goats haa nihtee tr'ilii ąįį gwik'it t'iheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dinjii Vit'eegwijyąhchy'aa k'eegwahthat nąįį dishriits'ąįį niheelyaa ts'ą' ch'izhii nąįį datł'ohts'ąįį niheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ąįįtł'ęę zhit juu K'eedeegwaadhat choh chil'ee nilii ąįį zhit juu vishriits'ąįį dilk'ii nąįį jyaa dahaanjyaa, ‘Aanaii, nakhwan juu Shiti' nakhwahił'ee nąįį, dzaa Gwigwiniin'ee gwizhit nihdǫhjyaa, jii nan goodlit dąį' gwats'an nakhweenjit tr'iilęįį goo'aii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Shizhit gwiłts'ik dąį' shach'oh'al, chųų dooihłii dąį' chųų shintł'ookąįį, aakin ihłii dąį' chan nakhwazheh nihdeeshohchik. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Shagwach'aa kwaa dąį' chan gwach'aa shinoolii, dhałts'ik dąį' chan shak'oohti', ts'ą' zhee gwaazhrąįį dhiidii dąį' chan, shineenakhwadal.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ts'ą' tee dinjii nąįį juu Vit'eegwijyąhchy'aa k'eegwahthat nąįį jii jyaa digiheenjyaa, ‘K'eegwaadhat nijin dąį' nizhit gwiłts'ik naaraah'ya' ts'ą' nach'arah'al? Akwat nijin dąį' chųų doiinlii gwizhit chųų nantł'eerinkaii? ");
INSERT INTO gwiNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nijin dąį' aakin inlii naraah'ya' ts'ą' diizheh nihdeenaraahchįį, akwat nijin dąį' nagwach'aa kwaa ts'ą' gwach'aa nineeriinlii? ");
INSERT INTO gwiNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nijin dąį' dhąhts'ik naraah'ya' ts'ą' nik'eeraahti'? Ts'ą' chan nijin dąį' zheegwaazhrąįį dhindii gwizhit nineenidik?’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ts'ą' zhit K'eedeegwaadhat choo jyaa diheenjyaa t'inchy'aa, ‘Łyaa nakhwaagwahaldak, zhit juu shatąįį adaa nąįį tee ch'ihłee gwiintsii veegoo'aii kwaa jyaa dinlik ąįįt'ee shįį t'ishinlik t'oonchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ąįįtł'ęę zhit juu vatł'ohts'ąįį dilk'ii nąįį jyaa dahaanjyaa, ‘Shihłeekhwajyaa, Vit'eegwijyąhchy'aa nakhwats'į' t'inchy'aa t'oonchy'aa! Nijin Ch'anky'aa Tr'aanduu ts'ą' vizheekat gwich'in nąįį kǫ' nikyaa kwaa gooveenjit goo'aii ąįį zhit gwats'ą' hohjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Shizhit gwiłts'ik dąį' gaa shach'oh'al kwaa, chųų dooihłii dąį' gaa chųų shantł'ookaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Aakin ihłii dąį' gaa nakhwazheh gwizhit nihdeeshohchįį kwaa, shagwach'aa kwaa dąį' gaa gwach'aa shantł'oolii kwaa, dhałts'ik ts'ą' zheegwaazhrąįį dhidii dąį' shak'oohti' gaa kwaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ąįįtł'ęę jii jyaa digiiyahaanjyaa, ‘K'eegwaadhat nijin dąį' nizhit gwiłts'ik, ts'ą' chųų doiinlii, ts'ą' aakin inlii, ts'ą' nagwach'aa kwaa ts'ą' dhąhts'ik ts'ą' zheegwaazhrąįį dhindii dąį' naraah'ya' kwaa ts'ą' nits'igwiinyą' kwaa?’ giiyahaanjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ts'ą' t'ee K'eedeegwaadhat Choo ąįį jyaa dagavahaanjyaa, ‘Jii łyaa nakhwaagwaldak t'ihnyąą, nijin jii ch'ihłee łyaa gwintsal gwizhrįh veegoo'aii ąįį vits'iinyą' kwaa, dąį' shįį shits'iinyą' kwaa t'oonchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ts'ą' t'ee jii nąįį t'ee khaiinjich'iriighit ndaanąą'ąį' kwaa nihdinakhwaraheelyaa t'oonchy'aa. Gaa juu Vit'eegwijyąhchy'aa k'eegwahthat nilii nąįį gwandaii ndaanąą'ąį' kwaa, nihdeegiheedaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nijin Jesus jii kwaii eenjit geegavąąhtan ndaanaahjik dąį', ditsyaa nąįį t'ahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Juk, drin neekwaii taa gwahaadhat ąįįtł'ęę t'ee Passover ch'aga'aa gwagwahahtsyaa gaakhwandaii ąįį zhit ji' Gwidinji' gwantł'ee giihaahchyaa ts'ą' Cross kat gigiiyahahtsak.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ąįįtł'ęę giinkhih kįh dilk'ii nąįį ts'ą' Israel kįh dilk'ii nąįį haa ndak khii giinkhih choh Caiaphas oozhii ąįį vizheh gwachoh nidigweeltsį' gwizhit khaihłan nigiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ts'ą' gweentak hee Jesus nats'ahts'ą' zheegwaazhrąįį nigiiyahahchyaa ts'ą' giiyęhdaa tr'igwihee'aa, ąįį geegiginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“Passover ch'aga'aa gwagwahtsii gwiizhit tr'ooheendal kwaa nihłagaanyąą jyaa digwiizhit ji' duulee dinjii nąįį datthak diits'ą' nich'itsahahthat.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nijin Bethany kwaiik'it gwizhit Jesus, Simon gwehkįį dąį' gwatthąį' ahjat (leprosy) haa iłts'ik vizheh neech'a'aa dąį', ");
INSERT INTO gwiNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tr'injaa alabaster kii tyah zhit gwanzhįh chų' daatł'oo gwinzii vagwaatsan neeha'ak haa yits'ą' niinzhii, Jesus vakaii'aa ts'oodii gwiizhik yiki' kat neeyaanjaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gaa nijin vitsyaa nąįį gwagwaah'in dąį' gook'įį goodlit, ts'ą' ch'agoahkat, “Jaghaii zhyaa an yahtsii? ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jii gwanzhįh chų' giit'įį laraa lęįį oonjii ts'ą' neeshraahchy'aa nąįį antł'eegiiyuulyaa jaghaii?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesus deeginyąą gavaandaii ts'ą' t'agavahnyąą, “Jii tr'injaa jaghaii vaanagoh'ąįį? Łyaa gwiinzii shats'ą' tr'agwah'in t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dinjii neeshraahchy'aa nąįį gweedhaa datthak nakhwaa gweheendaii, gaa shįį ąįį duuyeh gweedhaa datthak nakhwaa gwįįhdaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jii gwanzhįh chų' gwinzii vagwaatsan shak'aa naanjaa ąįįt'ee tth'ank'it gwizhit sharaheetsii geenjit shatthąį' tr'iilęįį ąhtsii t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Łyaa nakhwaagwaldak t'ihnyąą, jii nankat datthak nijin gwa'an Gwandak Nizįį eeragwaandak gwa'an giiyeegiheekhyaa adan t'ee deezhik khik vineegwahaandaii geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ąįįtł'ęę Jesus, vitsyaa 12 nąįį ch'ihłak Judas Iscariot oozhii, giinkhih kįh dilk'ii nąįį ts'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ts'ą' gavahkat, “Jesus nakhwantł'ałchįį ji', jidii shantł'eehoh'aa?” goovahnyąą. Laraa 30 dollars silver choh k'it t'inchy'aa giiyintł'inlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Izhit gwats'an it'ee Judas, Jesus gavantł'eehahchyaa geetr'agwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tr'ookit drin łųhchy'aa vitee łųh niituu tr'ihee'aa kwaa nigwiindhat dąį', Jesus vitsyaa nąįį giits'ą' haajil ts'ą' giiyųąhkat, “Passover ch'irehee'aa geenjit nijin tr'iilęįį gwarahahtsyaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus goodii ginkhe', “Kwaiik'it gwachoo gwizhit dinjii ch'ihłee vats'a' hohjyaa ts'ą' jyaa vohnyąą, ‘Geech'ǫąąhtan jyaa nyąą, shįį ąįįts'ą' shitsyaa nąįį haa nizheh Passover neerahee'aa juk it'ee zhat nigwiindhat.’ vohnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Vitsyaa nąįį Jesus deenyąą gwik'it t'igiizhit ts'ą' neech'igehee'aa geenjit shrigwigwiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nijin khaa nagwaanąįį dąį' Jesus ts'ą' ditsyaa nąįį haa neech'ihgihee'aa geenjit datthak zhak dagaandii. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ch'aga'aa gwiizhit Jesus, t'agavahnyąą, “Jii nakhwaagwahaldak, nakhwatee ch'ihłak gwantł'ee shahahchyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Vitsyaa nąįį tr'igwigwidii haa datthak giiyahkat, “K'eegwaadhat Łahchy'aa shįį t'ashaiinyąą kwaa gwizhrįh t'oonchy'aa,” gooteegwagwaanchy'aa ts'ą' jyaa giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus t'inyąą, “Ch'ihłee juu shaa k'ik ghoo zhit shaa łųhchy'aa tahtsik ąįįt'ee gwantł'eeshahahchyaa t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gwidinji' niheedhaa gwinyąą, ąįį Dęhtły'aa Choh kat gwadanakhwatł'oo, gaa zhit juu dinjii, Gwidinji' niheedhaa eenjit gwantł'eehahchyaa łyaa veenjit googwantrii gwiizųų ts'ą' vagoodlit kwaa ji' ts'ąįį vidivee gweheezyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, ąįįt'ee Jesus, gwantł'eehahchyaa t'inchy'aa, ąįį yats'ą' khaginkhee. “Geech'ǫąąhtan, łahchy'aa shįį t'ashaiinyąą kwaa hee?” Jesus, t'iiyahnyąą, “Nan jyaa diinyąą t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ch'aga'aa gwiizhit, Jesus łųhchy'aa oonjik ts'ą' mahsį' nyąą haa khadigeedi' ts'ą' khadiyinzhuu ąįįtł'ęę ditsyaa nąįį tee yiłtsit ts'ą' t'inyąą, “Jii łųhchy'aa ǫhjii ts'ą' ch'oh'aa, jii t'ee shatthąį' t'inchy'aa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ąįįtł'ęę chųų tyah oonjik, ts'ą' Vit'eegwijyąhchy'aa ts'ą' mahsį' nyąą ąįįtł'ęę gavantł'eeyiinkaii ts'ą' “Datthak vats'an ch'akhwanįį.” gavahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","“Jii t'ee shadaa, lęįį nąįį atr'agwaanduu oo'an gweheelyaa geenjit gwantł'eerinkaii t'inchy'aa ts'ą' Vit'eegwijyąhchy'aa deehee'yaa nyąą gwik'it t'iizhik gwigweheechy'aa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Łyaa nakhwaagwaldak, dahthee Shiti' Veegwinii'ee gwizhit jak chų' k'eejit nakhwaa shihinjyaa gwats'ą' datthak duuyeh jak chų' neeshinįį t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Vit'eegwijyąhchy'aa deegihił'e' haa ch'igiinli' ąįįtł'ęę Taih Vakat Olives Nahshii gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesus ditsyaa nąįį t'ahnyąą, “Juk khaa datthak ts'ą' akhashahohjyaa ts'ą' shihłeehohgal, Dęhtły'aa Choo zhit jyaa digwinyąą gwik'it, ‘Vit'eegwijyąhchy'aa, divii k'ąąhtii hahkhwaa ts'ą' divii nąįį datthak nihky'aa shrihtee gahaajil.’ ");
INSERT INTO gwiNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gaa nijin gwihįhdaii geenjit nineedhihkhin ąįįtł'ęę nakhwats'įį Galilee gwats'ą' hihshyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter, Jesus jyaa dahnyąą, “Jii nąįį datthak akhanagoonyąą gaa shįį duuyeh nihłeehihshii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus, Peter t'ahnyąą, “Naagwahaaldak, juk khaa rooster hahchik gwehkįį tik agwaanchy'aa shaanandaii kwaa hinjyaa t'oonchy'aa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter yidii ginkhii, “Naa nihihthaa ji' gaa nihk'it duuyeh jyaa dihnyąą t'oonchy'aa!” yahnyąą. Ts'ą' ch'izhii vitsyaa nąįį datthak chan jyaa diginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ąįįtł'ęę Jesus, ditsyaa nąįį haa gwanzhįh deek'it Gethsemane goozhii gwats'ą' goovaahaazhii. “Dzaa dook'įį, gwiizhit yee'at nihihshyaa ts'ą' khadigikhihjyaa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ditsyaa Peter, ąįįts'ą' Zebedee vidinji' neekwaii nąįį giiyaaneehiidal. Gwiizhit Jesus gwintł'oo tr'igwidii gwizhit khaiinjich'iighit. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ąįįts'ą' t'agavahnyąą, “Shidrii zhit tr'igwidii nitsii dha'aii ts'ą' vaa an hihłyaa k'it t'ihchy'aa, dzaa dook'įį ts'ą' sheenjit gwak'ǫǫhtii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Geh'at niighit kwaa gwats'ą' haazhii ts'ą' nikiigwiintthaii ts'ą' dinin nankat gwah'ee ts'ą' khadigiinjii ts'ą' t'inyąą, “Shiti', gwik'it goo'aii ji' jii khaiinjich'iriighit gwichųų tyah shits'į' noiinjii, shįį ąįį deeyiihthan gwik'it ąįį nakwaa, gaa nan ąįį deeyiindhan gwik'it.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ąįįtł'ęę ditsyaa tik nąįį ts'eehoozhii akhai' giłchųų łee ts'ą' Peter ąįį t'ahnyąą, “Hour ch'ihłak gwizhrįh gwik'eehoohtyaa goo'aii gaa geenjit gohthan kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Datthak ts'ą' t'agavahnyąą, “Gwak'ǫǫhtii ts'ą' khadagohjii, jyąhts'ą' gwik'iighai' tr'agwaanduu t'akhwa'yaa hohkhyaa kwaa geenjit. Nakhwayinji' ąįį gwik'it shoo'ya' niindhan gaa nakhwatthąį' ąįį vat'aii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chan hee gihłeehoozhii ts'ą' khadigiinjii ts'ą' t'inyąą, “Shiti' jii khaiinjich'iriighit gwichųų tyah, shihłeehiin'aa kwaa ji', shihinjyaa, ts'ą' deeyiindhan ąįį gwik'it gweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Chan hee ditsyaa nąįį ts'eehoozhii, akhai' khyų' digindee nihky'aa goontą' ts'ą' neegiiłchųų. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Chan hee Jesus, goołeehoozhii ts'ą' juk t'ee tik agwaanchy'aa gwehkįį deenyą' chy'aa chan hee gwik'it t'inyąą ts'ą' khadigiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Juk it'ee tik agwaanchy'aa ditsyaa nąįį ts'eehoozhii ts'ą' t'agavahnyąą, “Tth'aii hee noozhii ts'ą' dhohchųų? Gooh'in! Juk t'ee zhat nigwiindhat Gwidinji' tr'agwaanduu gwitr'it t'agwah'in nąįį antł'eetr'ahahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ndak nǫhjyaa ts'ą' tr'ahoojyaa, gooh'in jii dinjii gwantł'ee shahahchyaa dzaa dhidii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus tth'aii hee ginkhii gwiizhit vitsyaa ch'ihłak Judas oaazhii zhat k'idik. Dinjii lęįį nąįį shrii choo ts'ą' gał choo haa neegahaazhik ts'ą' giinkhih kįh dilk'ii nąįį ts'ą' ch'anjaa nąįį ts'ą' Law eech'ǫąąhtan nąįį goohił'e' giiyaaneehiidal. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ąįį juu gwantł'ee yahahchyaa ąįį dinjii lęįį łeeljil nąįį t'ahnyąą, “Dinjii haaltsu' t'ee adan vohtthan t'inchy'aa, ąįį ǫhjii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas, zhat k'idik gwagwahkhan Jesus ts'ą' haazhii, “Geech'ǫąąhtan, tsinehdan naa gooli'!” yahnyąą ts'ą' yiilts'ų'. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus t'iiyahnyąą, “Shijyaa, jaghaii dzaa dhindii?” Ąįįtł'ęę Jesus goonjik ts'ą' gwiint'aii giiyuutą'. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Dinjii ch'ihłee Jesus haa t'iinchy'aa ąįį shrii choo khaiintin ts'ą' ndak khii giinkhih choh vi-slave anlee yihiilnaii akhai' yidzee gadahtrat. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ąįįtł'ęę Jesus jyaa yahnyąą, “Nishrii choo gwizhit ninchįį, juu nąįį datthak shriichoo khaiintin t'aahchy'aa t'ee yaahahchyaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Zheekat Shiti' shits'iinyąą vaihnyąą ji' gwagwahkhan zheekat gwich'in niveet'ah'in 12,000 andaa t'ąąnchy'aa shats'ą' niheelyaa gaakhwandaii? ");
INSERT INTO gwiNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gaa gwik'iighai', nats'ahts'ą' Dęhtły'aa Choo zhit deegweheenjyaa gwinyąą ąįį gwik'it gweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Zhat dąį' Jesus dinjii gwanlii nąįį ts'ą' ginkhii, “Law łaahnaii iizųų ihłii k'it zhit, shriichoo ąįįts'ą' gał choo haa shohǫhdal geenjit gaa neehoozhik? Drin gwit'eegwaanchy'aa Kharigidiinjii Zheh Gwachoh gwizhit geech'ǫąąhtan gaa shǫhjii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gaa jii kwaii datthak nats'ąą Vit'eegwijyąhchy'aa Eenjit Ginkhii Dęhtły'aa Choo zhit gwadagwaantł'oo ąįį gwik'it gweheelyaa geenjit t'igwiizhit.” Tł'ęę vitsyaa nąįį datthak akhagiiyuunyąą ts'ą' gihłeegalgihiljil. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Zhit juu Jesus oonjik nąįį ndak khii giinkhih choo Caiaphas oozhii vizheh gwats'ą' giihiłchįį, izhit t'ee Law eech'ǫąąhtan nąįį ts'ą' Israel kįh dilk'ii nąįį haa łeeljil. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Gaa Peter ąįį gootąįį niighit ahaa, ndak khii giinkhih choo vizheh gokwantee gwizhit gweedii geelin tthał needhe'ee nihdeiinzhii ts'ą' zhat gwadąįį gwak'ąąhtii nąįį haa naadii deegweheenjyaa li' geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Giinkhih kįh dilk'ii nąįį ts'ą' Israel kįh dilk'ii nąįį haa datthak Jesus ęhdaa tr'igwigwehee'aa geenjit goots'it haa gwiizųų t'iizhik giiyahaanjyaa eenjit gwankeegwagwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Dinjii lęįį nąįį goots'it haa jyaa diizhik giiyahnyąą, gaa gwiizųų t'iizhik giiyeenjit gwagwagwah'ąįį kwaa. Gohch'it dee dinjii neekwaii nąįį khagiinkhee, ");
INSERT INTO gwiNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ts'ą' t'iginyąą, “Jii dinjii t'ee Vit'eegwijyąhchy'aa Vakharigidiinjii zheh shrahtee gwahaałtsyaa ąįįtł'ęę drin tik gwiizhit ndak nineegwihih'aa nyąą t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ndak khii giinkhih choh ndak nigiilzhii ts'ą' Jesus goots'ą' nadhat gwiizhit giiyųąhkat, “Jaghaii jii dinjii nąįį gwiizųų neegigiinkhii gwiizhit jaghaii goodii ginkhii kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Gaa Jesus hahchįį kwaa. Ndak khii giinkhih choo jyaa yahnyąą, “Christ, Vit'eegwijyąhchy'aa Vidinji' inlii lee t'oonchy'aa, Vit'eegwijyąhchy'aa khit gwandaii voozhri' zhit oiints'it kwaa haa diinaa gwaandak giiyahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“Shįį t'ee adan ihłii, Gwidinji' t'ee Vit'eegwijyąhchy'aa jidii datthak geenjit t'aih di'įį vishriits'ąįį dhidii khoh'yaa, k'iidąą zheekat gwats'an zheek'ǫh tee neeheedyaa khooh'yaa t'inchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jyaa nyąą geh'an ndak khii giinkhih choo dagwach'aa dats'an tr'ahch'aa ts'ą' jyaa nyąą, “Vit'eegwijyąhchy'aa vinehts'į' ginkhii! Dinjii nąįį tr'agwaanduu vigwitr'it gwanlii giheenjyaa t'eegwaahchy'aa kwaa! Datthak ts'ą' Vit'eegwijyąhchy'aa vinehts'į' ginkhii dohtth'ak! ");
INSERT INTO gwiNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Deereheelyaa?” goovahnyąą. Ts'ą' giidii ginkhii, “Vęhdaa tr'agǫh'ąįį!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tł'ęę giinin k'ąą gihizhree ts'ą' giiyahgwat ts'ą' goolat nąįį giiyant'an, ");
INSERT INTO gwiNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ts'ą' jyaa ginyąą, “Christ, Vit'eegwijyąhchy'aa Eenjit Ginkhii inlii ji', juu neełgwat diinaa gwaandak!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter kwantee tthał needhe'ee gwiizhit tth'aii hee dhidii dąį' ndak khii giinkhih choo vitsyaa tr'injaa yats'ą' niinzhii ts'ą' t'iiyahnyąą, “Nan chan Jesus Galilee gwats'ąnh nilii vaaneehindik hee?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gaa datthak goovandah gaandaii kwaa adaa'įį. “Jidii eegiinkhii t'iinyąą naashandaii kwaa!” nyąą ts'ą' yidii ginkhii, ");
INSERT INTO gwiNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ts'ą' kwantee tthał needhe'ee chigweedii niinzhii. Ndak khii giinkhih choo ch'izhii vitsyaa tr'injaa yah'in ts'ą' zhat dinjii nąįį jyaa dahnyąą, “Jii t'ee Jesus, Nazareth gwats'an nilii haa neehidik chy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chan hee Peter gaandaii kwaa adaa'įį ts'ą' gwidii ginkhii, “Ąįį dinjii vaashandaii kwaa dihnyąą łyaa t'ihnyąą!” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Gwintsal gwahaadhat ąįįtł'ęę zhat dinjii neelzhii nąįį Peter ts'ą' nigiinjil. “Łyaa nant'ee vitsyaa ch'ihłak inlii!” “Nats'ahts'ą' ginkhii k'iighai' naagwiindaii t'oonchy'aa.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tł'ęę Peter t'inyąą, “Łyaa zhyaa łi'didlii haa gihkhii t'ihnyąą! Oihts'it ji' Vit'eegwijyąhchy'aa shagohshii! Ąįį dinjii vaashandaii kwaa t'inchy'aa.” nyąą gwiizhit rooster hahchik. ");
INSERT INTO gwiNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ts'ą' Jesus deeyaiinyą' chy'aa Peter ganaanjik, “Rooster hahchik gwats'ą' tik agwaanchy'aa shaanandaii kwaa hinjyaa t'oonchy'aa yaiinyą'.” Peter cheehoozhii ts'ą' gwint'aii iintrii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Vanh dąį' gwanlii gwiizhit giinkhih kįh dilk'ii nąįį ts'ą' Israel kįh dilk'ii nąįį haa nats'ahts'ą' Jesus ęhdaa tr'igwigwehee'aa geegiginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ch'iitsii tły'ah haa digiiyiłchaa ts'ą' gihłeegiihiłchįį ts'ą' Pilate, Roman nilii Judea nahkat gwa'an gwats'ą' k'eedeegwaadhat nilii ąįį antłeegiiyahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nijin Judas, Jesus gwantł'ahchįį ąįįtł'ęę giiyęhdaa tr'igwihee'aa łee gwiky'aanjik dąį' gwiizųų t'iizhik t'ii'in łee giky'aanjik ts'ą' 30 silver laraa giiyintł'eelii chy'aa giinkhih kįh dilk'ii ts'ą' Israel kįh dilk'ii nąįį haa antł'ineeyinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ts'ą' t'inyąą, “Tr'agwaanduu shizhit łee, dinjii vatr'agwaanduu gwakwaa ąįį vęhdaa tr'igwirehee'aa eenjit gwantł'ąhchįį łee,” nyąą. “Jaghaii, neenjit ninjich'ireheedhat ąįį nats'an t'oonchy'aa!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Judas, Khadigiriinjii Zheh gwizhit laraa datthak goots'eehiłjil ts'ą' cheehoozhii ąįįtł'ęę t'oohłii neehoozhii ts'ą' diyeech'ilchaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Giinkhih kįh dilk'ii nąįį zhit laraa tineegwigwįłjik ts'ą' t'iginyąą, “Jii t'ee dinjii vadaa laraa t'inchy'aa, ts'ą' Khadigiriinjii Zheh laraa dhidlii zhit duuyeh gwizhit neerilii goo'aii dii-Law zhit jyaa digwinyąą ginyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ąįį laraa deegiheelyaa geegiginkhe' ąįįtł'ęę giiyaa nan deek'it Potter gwideek'it goozhii ąįį giiyaa oiinkwat, ąįį Jerusalem kwaiik'it gwachoo gwizhit juu aakin nadhat nąįį giheetsii geenjit t'igiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ąįį geh'an juk tth'aii hee “Dinjii Vadaa Dehk'it” goaazhii ts'ą' Jii dęhtły'aa digiheentł'oo gwats'ą' jyąhts'ą' gwizhrįh googoozhrii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeremiah, Vit'eegwijyąhchy'aa Eenjit Ginkhii inli' ts'ą' deenyą' gwik'it t'igwiizhik. “Ąįį 30 silver laraa t'ee laraa jyaa daanchy'aa haa Israel gwich'in nąįį giiyeenjit goiinkwat, ");
INSERT INTO gwiNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ąįį laraa haa potter gwideek'it googoiinkwat,’ shįį, Jeremiah ihłii, K'eegwaadhat deiinyąą shahnyąą gwik'it t'iinyą' t'ihnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus, Roman k'eedeegwaadhat ąįį Israel nahkat eenjit kįh dhidii Pilate ąįį andaa nadhat giiyiłtsąįį ts'ą' yuahkat, “Jews nąįį eenjit King inlii?” yahnyąą. “Nan ąįį jyaa dinyąą t'oonchy'aa.” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gaa nijin giinkhih kįh dilk'ii nąįį ts'ą' Israel kįh dilk'ii ąįį nąįį haa gwiizųų giiyeeginkhii dąį' gooveenjit k'eegwiichy'aa gaa t'inyąą kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ts'ą' Pilate t'iiyahnyąą, “Gwiizųų datthak neegigiinkhii, ąįį nik'ee gaviintth'ak?” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Gaa Jesus ginjik ch'ihłak gaa yats'an ąhtsii kwaa, ąįį geh'an Pilate łyaa geegoolii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nijin Passover ch'ara'aa nineegwiidhat dąį' Judea gwats'an Roman k'eedeegwaadhat zhat łigiijil nąįį eenjit juu zheegwaazhrąįį gwats'an chinoozhi' giindhan, ąįį ch'ihłak gooveenjit chineegahchik gwagwaa'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Izhit zhat dąį' dinjii zheegwaazhrąįį dhidii ąįį juu nąįį datthak giiyaandaii ąįįt'ee Barabbas oozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ąįįts'ą' nijin dinjii nąįį khaihłan niinjil dąį' Pilate gavahkat, “Juu shrit chanoołchyaa shohnyąą, Barabbas akwat Jesus Christ oozhii?” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jesus itr'igii'ee, geh'an Jews kįh dilk'ii nąįį gwantł'eegiiyąhchįį ąįį Pilate gaandaii geh'an jyaa dinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ąįįts'ą' t'ee Pilate, ch'aroahkat zheh gwizhit dhidii gwizhit va'at yats'ą' neech'idiin'ąįį ts'ą' t'iiyahnyąą. “Jii dinjii vatr'agwaanduu gwakwaa t'inchy'aa, ts'ą' veenjit k'eegwiichy'aa gwiizųų t'anoo'ya' shrǫ', k'ehdąį' khaa, gineiihłyaa zhit veh'an gwintł'oo khaiinjich'ashahohthat t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Giinkhih kįh dilk'ii nąįį ts'ą' Israel kįh dilk'ii nąįį haa zhit dinjii łeeljil nąįį jyaa dagahnyąą, “Pilate, oohkat ts'ą' Barabbas! chanaahchįį ts'ą' Jesus ąįį vęhdaa tr'agwaroo'aa dohnyąą,” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ąįįts'ą' t'ee Pilate ąįį zhat dinjii nąįį oahkat. “Juu shrit nakhweenjit chanoołchyaa shohnyąą?” Gavahnyąą. Datthak ts'ą' “Barabbas,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Akwaa ji' Jesus, Messiah oozhii ąįį deehihłyaa?” Pilate, gavahnyąą? “Nihk'ataa'ee cross kat gohtsak!” datthak ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Gaa Pilate gavahkat, “Jidii tr'agwaanduu t'iizhik?” nyąą, googaa nihk'it datthak gwint'aii gazhral ts'ą' “Nihk'ataa'ee cross kat gohtsak!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nijin Pilate, nihłi'ch'iheeghaa k'it t'igwii'in gwąąh'in dąį' khyų' gaa k'eegwiichy'aa t'inyąą ts'ą' chųų lat oonjik ts'ą' zhit juu łeeljil nąįį andah danli' k'eech'ąhtryaa, ts'ą' t'inyąą, “Jii dinjii vęhdaa tr'agoo'ąįį ji' shįį ąįį shadraii t'oonchy'aa kwaa ts'ą', nakhwan ąįį gwik'it t'akhwa'yaa t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Juu dinjii łeeljil nąįį datthak jyaa diginyąą, “Tr'iiłkhwąįį ji' ąįį diik'aa gahooghyii ts'ą' diitr'iinin nąįį chan k'ąą gahooghyii!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ąįįtł'ęę Pilate, ąįį Barabbas gooveenjit chanaahchįį ts'ą' Jesus viitrii haa tr'ahahtrii gwiłtsąįį, ąįįtł'ęę gigiihahtsak geenjit gwintł'eeyąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ąįįtł'ęę Pilate viniveet'ah'in nąįį Jesus goonjik ts'ą' k'eedeegwaadhat choo vizheh gwachoo gwats'ą' giihiłchįį, ts'ą' niveet'ah'in nąįį datthak yeelin niinjil. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Giigwach'aa gihłeehaadlii ts'ą' ik daatsik giinaahtsųų. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ąįįtł'ęę khoh haa ts'eh giłtsąįį ąįį giiniin'ąįį, ts'ą' shriits'ąįį vanli' zhit gał ootą' giiyiłtsąįį, tł'ęę giits'ą' nikeegwiitthat ts'ą' giiyeedlaa, “Jews nąįį king niighyuk goondaii!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gał giiyantł'ee oonjik ts'ą' giiki' oahkhaa tł'ęę giik'aa hizhree. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nijin giiyeedlaa ndaanagąąhjik dąį', ik daatsik giiniitr'ahtsuu ts'ą' giigwach'aa giiyeenineiinlii. Tł'ęę oo'an gigiihahtsak gwats'ą' giihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","It'ee ch'ineegiijyaa gwiizhit dinjii Simon oozhii ąįį Cyrene kwaiik'it gwats'an ahaa k'at deegaajil ts'ą' niveet'ah'in nąįį Jesus va-cross ichyaa giits'an gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Taih kat Golgotha goaazhii k'eegiidal, ąįįt'ee “Dinjii kiitth'an deek'it.” gwinyąą t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aiizhit zhat Jesus jak chų' (vinegar) traakaii k'it vagwandaii ąįį chan giiteet'inlik, yaalaii ts'ą' yeenį' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ts'ą' t'ee cross kat gigiiyiłtsak ąįįtł'ęę giigwach'aa datthak nihteegeelzhii ts'ą' (dice) tth'an ghoo tsal gahaanjal haa juu shrit jidii gwach'aa hoondal ji' geenjit giiyaa tsee'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ąįįtł'ęę zhat nankat giilk'ii ts'ą' giik'aahtii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Giiki' ehdee dachan kat jidii eenjit gigiiyiłtsak ąįį dagwagwaantł'oo, “Jii t'ee Jesus t'inchy'aa, Jews nąįį eenjit King nilii.” ginyąą ts'ą' ch'adagąąntł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ąįįtł'ęę t'ee dinjii ch'an'įį neekwaii giiyaagiłtsak. Ch'ihłak vishriits'ąįį ts'ą' ch'ihłak chan vatł'ohts'ąįį jyąhts'ą' gagoogiłtsak. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Dinjii nąįį giiyehgoo khadal dąį', gwiizųų Jesus ts'ą' gigiinkhii ts'ą' gook'įį gwanlii haa digiki' tth'an gaahthak. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Khadigiriinjii Zheh nineegwihiinlyaa ts'ą' drin tik gwagwaanchy'aa gwizhit neegwahałtsyaa diinyąą chy'aa? Vit'eegwijyąhchy'aa Vidinji' inlii ji' cross ts'an ninkhaii ts'ą' gwats'an tr'iineedaanchįį!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ąįį gwik'it giinkhih kįh dilk'ii nąįį ąįįts'ą' Law eech'ǫąąhtan nąįį, ąįįts'ą' Jews kįh dilk'ii nąįį datthak giiyeedlaa ts'ą' t'iginyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ch'izhii dinjii nąįį neeheezhii ąhtsii, gwiizhit gaa adan ąįį needahaazhii veegogwantrii. Israel nąįį eenjit King nilii tr'oonyaa łee? Juk zhat cross ts'an nineezhii ji' t'ee vik'injireheedhaa t'inchy'aa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Vit'eegwijyąhchy'aa t'injyąhchy'aa ts'ą' “Vit'eegwijyąhchy'aa Vidinji' ihłii” nyąą geenjit Vit'eegwijyąhchy'aa gwats'an juk tr'ineeyahahchyaa ji' geenjit nagwaroo'ya' ts'ą' gwarǫh'ya'!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Zhit dinjii ch'an'įį neekwaii nąįį nihts'įį giiyeenjit giłtsak nąįį gaa gwiizųų gook'it giits'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Drintł'an 12:00 nigwiindhat gwiizhit nankat datthak tǫǫ nagwaanąįį, ts'ą' 3 hrs. datthak tǫǫ gwin'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","3:00 gwa'an gweedhaa gwiizhit Jesus, azhral haa gwint'aii khashraa'iintrat, “Eli Eli lema sabachthani?” Ąįįt'ee, “Shivit'eegwijyąhchy'aa, Shivit'eegwijyąhchy'aa jaghaii akhashoiinyąą!”, gwinyąą t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Zhat gwa'an dinjii lat neelzhii nąįį “Elijah oozhrii!” giiyiitth'ak ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Dinjii ch'ihłak yats'ą' hilgik ts'ą' sponge ahtsit ts'ą' jak chų' (wine) daatł'oo kwaa ąįį zhit tee yahtsuu ts'ą' gał tsii niyahtsuu ąįįtł'ęę yiheenjyaa geenjit yats'ą' yuuntą'. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gaa ch'izhii nąįį t'igiiyahnyąą, “Nagoodhan'in, duulee Elijah gwats'an tr'ineeyahahchyaa, ąįį zhit gwarahąąh'yaa geenjit!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus chan hee gwint'aii khashraa'iintrat, ts'ą' neehoozhee ąįįtł'ęę niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ąįįtł'ęę Khadigiriinjii Zheh gwizhit gindeiinvyaa choh gwach'aa dach'at haa iltsąįį teetł'an dakhii gwats'an k'iizhak datthak nihtr'iinch'aa. Gwiizhit nan datthak daatrat ts'ą' kii choh kwaii gaa nitr'aanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tth'ank'it kwaii gaa nihtr'igweelnaii ts'ą' nihky'aa t'igwiizhit ts'ą' Vit'eegwijyąhchy'aa vigii lęįį nąįį niinjik nąįį gaa neegwiindaii neegaadlit, ");
INSERT INTO gwiNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ts'ą' tth'ank'it gwats'an gihłeegahoojil. Jesus niindhat gwats'an needhikhin ąįįtł'ęę, Jerusalem kwaiik'it gwachoo shroodiinyąą gwats'ą' gahaajil, izhit dinjii lęįį nąįį googah'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nijin niveet'ah'in kįh dhidii ąįįts'ą' niveet'ah'in lęįį nąįį datthak Jesus aakin gąą'įį gwiizhit nan daatrat ts'ą' gwilii t'igwii'in datthak gwagwaah'in dąį', łahchy'aa gihilghaa haa t'iginyąą, “Jii dinjii łyaa Vit'eegwijyąhchy'aa Vidinji' nilii łee!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tr'injaa lęįį nąįį niighit gwats'an aakin gwagwaa'įį, ąįį nąįį t'ee Galilee gwats'an Jesus tąįį gahahjil ts'ą' giits'iinya'. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ąįį nąįį gootee Mary Magdalene ts'ą' James ts'ą' Joseph haa goohan Mary ts'ą' Zebedee va'at nąįį nadhat. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nijin khaa nagwaanąįį dąį', dinjii valaraa gwanlii, Joseph oozhii Aramathea kwaiik'it gwachoo gwats'an ahaa ts'ą' Jesus vitsyaa chan nilii zhat k'idik. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilate ts'ą' haazhii ts'ą' Jesus vichį' shantł'eerohchyaa nyąą ts'ą' ch'oahkat. Ąįįts'ą' Pilate vantł'eeyuhchįį nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ts'ą' t'ee Joseph, Jesus vichį' oonjik ts'ą' gwach'aa dril daagąįį k'eejit yaanoołjik, ");
INSERT INTO gwiNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ts'ą' adan ąįį datth'ank'it zhit niyąąhchįį. Kii zhit gweedii goo'aii gwizhit tth'ank'it gwagwaa'įį ąįį zhit gwizhit niyąąhchįį ts'ą' gwadąįį kiichyaa choh, gihdeiin'ąįį ts'ą' gihłeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene ts'ą' ch'izhii Mary haa tth'ank'it gwats'ą' gaahdii. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gęhdaa drin, Neegwaazhii Drin zhit nagwaanąįį gwiizhit giinkhih kįh dilk'ii nąįį ts'ą' Pharisee nąįį haa Pilate gahaa'yaa gwigwiłtsąįį, ");
INSERT INTO gwiNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ts'ą' t'igiiyahnyąą, “K'eedeegwaadhat, zhit dinjii ch'a'oots'it, gwandaii dąį' jii jyaa dinyąą vineegwaandaii. ‘Drin tik, gehgoo gwahaadhat ąįįtł'ęę, neegwihįhdaii.’ nyąą t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Niveet'ah'in nąįį vatth'ank'it drin tik datthak gwinzii gwik'eegahaantyaa geenjit jyaa goovahnyąą. Jyąhts'ą' gwik'iighai' duuyeh vitsyaa nąįį gwats'ą' gihihjyaa ts'ą' giich'ichį' nan'įį ts'ą' dinjii nąįį haa gwagwahaandak ts'ą' needhikhin giiyahaanjyaa gwits'į' t'igwinyąą ginyąą. Needhikhin giihaanjyaa ąįįt'ee tr'ookit dąį' oots'it haa Christ ihłii nyąą andaa gwiizųų t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate t'agavahnyąą, “Niveet'ah'in nąįį teegǫhjii ts'ą' zhit tth'ank'it gaa nigwigwehee'aa kwaa geenjit gwiinzii shragohłii.” ");
INSERT INTO gwiNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ts'ą' t'ee gihłeegahoojil ts'ą' tth'ank'it kii choo gideegii'ąįį ąįį gihłeegihee'aa gwits'į' agwagweelkįį ts'ą' niveet'ah'in nąįį zhat gwik'eegahąąhtyaa geenjit zhat nagoogiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Neegwaazhii Drin ąįįtł'ęę Drinzhit vanh shree khahee'aa gwehkįį, Mary Magdalene ts'ą' ch'izhii Mary, haa tth'ank'it gwagwahąąh'yaa geenjit gwats'ą' gahaa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Khan hee nankat gwint'aii gwaatrat nagwaanąįį, gwiizhit zheekat gwats'an K'eegwaadhat vizheekat gwich'in zhat nadaanaii ts'ą' kii choh gwadąįį dha'aii gihłeehiłdzik ts'ą' yakat doondii. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nahtan needoohaadhak k'it viyiichy'a' ts'ą' vagwach'aa chan zhah k'it daagąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Niveet'ah'in zhat gwak'ąąhtii nąįį it'ee shrit gihilghaa ts'ąįį gwint'aii gaatrat ts'ą' oozhak t'eegiiheełnaii ts'ą' giłchįį k'it t'igiinchy'aa nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Gaa zheekat gwich'in ąįį zhit tr'injaa nąįį t'ahnyąą, “Noojat kwaa, Jesus giriłtsak chy'ah vankeegǫǫh'in nakhwaashandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Dzaa dhidii kwaa, gwandaii neeheelyaa nyąą chy'aa gwik'it t'iizhit t'inchy'aa, aanaii dzaa vich'ichį' nijin t'inchy'aa, chy'aa gooh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Khants'ą' oo'an neekhwajyaa ts'ą' vitsyaa nąįį haa goondak. ‘Ch'ichį' ts'an needhikhin ąįįts'ą' juk zhat Galilee nahkat nakhwehkii gwats'ą' haazhii ts'ą', ąįį zhit ji' hǫǫh'yaa t'inchy'aa.’ Deenakhwaihnyą' gineehoondaii yuu.” ");
INSERT INTO gwiNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ąįįts'ą' tth'ank'it gwats'an gąąnjat gaa goozhit shoo dha'aii haa oo'an vitsyaa nąįį haa gwagwaandak geenjit gihłeegalgihiljil. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Khan hee Jesus goots'ą' tr'iinzhii ts'ą' t'agavahnyąą, “Tsinehdan nakhwaa oolį'!” Giits'ą' haajil ts'ą' zhat giikwai' oonjik ts'ą' giits'ą' nikiigwiintthaii. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Noojat shrǫ', shitsyaa nąįį, shachaa k'it t'igiinchy'aa Galilee nahkat gwats'ą' hohjyaa goovohnyąą ts'ą' ąįį zhit ji' goohaał'yaa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tr'injaa nąįį k'ii'an gihłeegahoojil gwiizhit niveet'ah'in tth'ank'it gwik'eegąąhtii lat nąįį, giinkhih kįh dilk'ii nąįį ts'eegahoojil ts'ą' deegwiizhik datthak gavaa gwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Giinkhih kįh dilk'ii nąįį ts'ą' Jews kįh dilk'ii nąįį haa nihłaa khaihłan nigiinjil ts'ą' deegihee'yaa geegiginkhe' ts'ą' laraa lęįį gavantł'eegiinlii, ");
INSERT INTO gwiNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ts'ą' t'agoogahnyąą, “Zhat tǫǫ tr'iłchųų gwiizhik vitsyaa nąįį zhat gwats'ą' gahaajil ts'ą' giichį' naa'įį łee hohjyaa yuu.” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ąįįts'ą' Governor Pilate gwiitth'ak ji', nakhwan'ąįį gwiizųų t'akhwazhit kwaa varahaanjyaa ts'ą' diik'injiheeghit tr'ahahtsyaa t'inchy'aa, ąįįts'ą' geenjit tr'agohdii gwat'oohchy'aa kwaa googahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Niveet'ah'in nąįį laraa lęįį tee gwigwįłjik ts'ą' deegooreiinyą' chy'aa gwik'it t'igiinyą'. Ts'ą' juk gweendaa googaa nihk'it jyaa diginyąą haa Jews nąįį datthak nihłehjuk geegigiinkhii goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jesus, vitsyaa, 11 nąįį, Galilee nahkat gwizhit taih dha'aii ąįį zhit gwats'ą' hohjyaa gavahnyąą ąįį gwik'it t'igiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Goolat nąįį giik'injiighit kwaa gaa nijin giiyąąh'ya' dąį' giits'ą' khadigeedi'. ");
INSERT INTO gwiNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus goots'ą' nahgǫǫ niinzhii ts'ą' t'agavahnyąą. “Zheekat ts'ą' nankat haa datthak geenjit t'aih shintł'eetr'iin'ąįį t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ąįįts'ą' nankat gwich'in nąįį datthak goots'ą' hohjyaa ts'ą' shitsyaa gavohtsii. Gwiti', Gwidinji' ts'ą' Ch'anky'aa Shroodiinyąą oozhri' zhit chųų goots'an ohtsii, ");
INSERT INTO gwiNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ts'ą' shik'eegwagwahahthat geenjit geegavǫhtan ts'ą' deenakhwaihnyą' datthak geenjit chan gavaa goondak. Ts'ą' nan ndaagwąąn'ąį' gwats'ą' datthak, nakhwaa hihłyaa t'oonchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jii t'ee Vit'eegwijyąhchy'aa Vidinji' Jesus Christ nilii ąįį Vagwandak Nizįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jii t'ee yeenaa dąį' Isaiah Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii tr'ookit John deezhit gwadąąntł'oo: “Jii dinjii t'ee gwaandak shi'įį eegwahaandak t'inchy'aa. K'iindaa nits'ii hał'aa, k'eegwiichy'aa datthak nikįh shrigweheelyaa geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nangwinjir gwa'an tr'azhral gwigwiitth'ak ts'ą' jyaa digwinyąą, “K'eegwaadhat vits'ii tąįį gwinjik shrigwinlii ts'ą' k'iindaa tąįį k'igwąą'ee heekhaa veenjit nagwiintthaii!” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ąįįts'ą' t'ee John chųų gwats'an ąhtsii nilii nangwinjir gwa'an vigwiilkįį ts'ą' chųų gwats'an ąhtsii ts'ą' jyaa nyąą ts'ą' geech'ǫąąhtan, “Nakhwatr'agwaanduu gwats'an łihts'eedǫǫ'ee ts'ą' chųų nakhwats'an ilii, ąįįtł'ęę t'ee Vit'eegwijyąhchy'aa nakhwatr'agwaanduu nakhweenjit oo'an gweheelyaa.” dinjii nąįį jyaa dakhwa'yaa goo'aii ahnyąą ts'ą' gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea nahkat ts'ą' Jerusalem kwaiik'it gwachoo gwizhit gwats'an dinjii lęįį nąįį John giheetth'ak eenjit giits'ą' haajil. Diitr'agwaanduu gwanlii ginyąą ts'ą' t'ee Jordan han gwinjik gwizhit chųų goots'an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John, nin Camel, ąįį vaghai' haa gwach'aa iłtsąįį naazhii, ts'ą' ch'adhah haa tthah iłtsąįį dazhrak tł'an giłchaa, ąįįts'ą' chan ch'ahahsak ts'ą' ch'ineendzit soongąįį kwaii shih a'ii, ąįį kwaii a'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Dinjii nąįį ts'ą' khaginkhee, ts'ą' jyaa nyąą, “Dinjii ch'ihłee shatąįį heekhaa łahchy'aa shandaa veegoo'aii ts'ą' jiintsii t'inchy'aa it'ee shrit jiintsii ts'ąįį. Zhat nikiigwihihtthal ts'ą' vakwaiitryaa, dineehih'at geenjit sheegoo'aii kwaa t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Shįį ąįį chųų haa chųų nakhwats'an ałtsii, gaa adan ąįį Ch'anky'aa Shroodiinyąą haa nakhwats'an chųų hahtsyaa t'inchy'aa,” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ąįįtł'ęę niighyuk gwahaadhat kwaa ts'ą' Jesus, Galilee nahkat gwizhit kwaiik'it Nazareth gwats'ą' haazhii ts'ą' Jordan han gwinjik gwats'ą' haazhii ts'ą' John yats'an chųų iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ts'ą' nijin Jesus chųų ts'an khaneezhii gwagwahkhan zheekat nihky'aa t'igwiizhit ts'ą' Ch'anky'aa Shroodiinyąą, dziitsal dove k'it t'inchy'aa yeedaa gwats'an yak'aa needaanąįį gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ąįįtł'ęę gwideezhuh, zheekat gwats'an jyaa nyąą, “Nan Shidinji', łi'haa neet'iihthan inlii ts'ą' łyaa nashoo ahłįį!” gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Gwagwahkhan łąą nangwinjir gwa'an gwats'ą' Ch'anky'aa Shroodiinyąą haazhii yiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ts'ą' drin 40 gwiteegogwąąnchy'aa datthak zhat nangwinjir t'inchy'aa. Izhit zhat dąį' Satan yik'eegwandaii tr'agwaanduu t'ihee'yaa ji' geenjit. Izhit gwa'an nin iizųų gwanlii tee gwa'an t'inchy'aa gaa zheekat gwich'in nąįį giits'ą' haajil ts'ą' giits'iinya'. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nijin John, zhee gwaazhrąįį nagąąhchįį dąį', ąįįtł'ęę t'ee Jesus, Galilee nahkat gwats'ą' haazhii ts'ą' Vit'eegwijyąhchy'aa Vagwandak Nizįį eech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Juk drin t'ee zhat nigwiindhat! Vit'eegwijyąhchy'aa Veegwinii'ee ąįį gwats'ą' juk nahgwan t'oonchy'aa ts'ą' nakhwatr'agwaanduu ts'į' łihts'eedǫǫ'ee ts'ą' Gwandak Nizįį k'injuhkhit.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus, Galilee van vee gwa'an neehidik gwiizhit Simon ts'ą' dachaa Andrew haa chihvyaa zhit łuk goonjii goovąąh'in. Łuk goonjii haa dagwagwaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ąįįts'ą' Jesus t'agoovahnyąą, “Shaa hoh'oo, nats'ahts'ą' dinjii nąįį tee goohohdal, geenakhwahałchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jyaa nyąą googwahkhan digichihvyaa akhagoonyąą ts'ą' giiyaahaa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ąįįtł'ęę Jesus k'iindaa tth'aii hee teeghaii ahaa akhai' Zebedee vidinji' neekwaii, James ts'ą' vachaa John haa tr'ihchoo zhit digichihvyaa shrigilii goovah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus goovah'in gwagwahkhan goovoozhrii; zhat tr'ihchoo zhit dinjii gooveenjit tr'agwah'in nąįį haa digiti' Zebedee akhagoonyąą ts'ą' Jesus haa gahaa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus, ditsyaa nąįį haa Capernaum kwaiik'it k'eegiidal ts'ą' Neegwaazhii Drin (Saturday) zhit nagwaanąįį dąį' Israel nąįį tr'igiinkhii zheh nihdeiinzhii ts'ą' geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dinjii nąįį giiyiitth'ak dąį' gooveenjit geegwaroolii kwaa gwiky'aa geech'ǫąąhtan. Law eech'ǫąąhtan nąįį (Scribes) k'it łyaa t'inyąą kwaa, dinjii viginjik nint'aii haa geech'oohtan k'it geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Izhit gwizhit dinjii ch'anky'aa iizųų vizhit t'inchy'aa dhidii, ");
INSERT INTO gwiNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ts'ą' azhral ts'ą' jyaa nyąą, “Jesus Nazareth kwaiik'it gwats'an inkhaa, jidii diinanh niindhan? An diihahtsyaa lee t'ini'in? Juu t'iinchy'aa naashandaii! Vit'eegwijyąhchy'aa vats'an Shroodiinyąą t'iinchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesus gwint'aii ch'anky'aa iizųų idiikhagiinkhee, “Deegwahtsai' kwaa ts'ą' ąįį dinjii vizhit tr'iinkhaii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ch'anky'aa iizųų k'iighai', vatthąį' gwint'aii daatrat naanaii ts'ą' gwint'aii azhral, gwiizhit ąįį ch'anky'aa iizųų yats'an khaiinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dinjii nąįį datthak gooveenjit geegwaroolii kwaa t'igwiizhit ts'ą' nihłagwaakat ts'ą' t'iginyąą, “Nats'ahts'ą' yeenjit ginjik di'įį t'inyąą? Geech'arǫąąhtan k'eejit haa geech'ǫąąhtan lee t'ii'in? Jii dinjii łyaa vat'aii gwanlii haa ch'anky'aa iizųų nąįį ts'ą' k'eedeegwaadhat ts'ą' giik'eegwahthat!” jyaa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ąįįts'ą' Jesus deezhit ąįį vagwandak, khants'ą' Galilee nahkat gwa'an datthak gwintł'oo giiyeeginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus vitsyaa nąįį ts'ą' James ts'ą' John nąįį haa Israel tr'igiinkhii zheh gwats'an chineegiijil, gwagwahkhan datthak Simon, ts'ą' Andrew haa goozheh nihdeegiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon va'at ąįį vahan ts'ik nindhaa haa iłts'ik ts'ą' ndaka'ee gwiizhit nihdeegiinjil gwagwahkhan Jesus haa gwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ąįįts'ą' yats'ą' haazhii ts'ą' yanli' oonjik ts'ą' ndak nineeyiłjin, ts'ą' ts'ik nindhaa dii'įį kwaa naanaii, gwagwahkhan gooveegwitr'it t'igwihił'ya' ts'ą' shih goovęhdaa niinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Zhat khaa gwik'ich'a'ąįį gwiizhit, dinjii iłts'ik nąįį ts'ą' juu ch'anky'aa iizųų vizhit nąįį datthak Jesus ts'ą' nihdeegiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Zhat kwaiik'it gwats'an dinjii nąįį datthak, zhit zheh nihdeegweedii gwa'an łigeeljil. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Dinjii lęįį nąįį ts'ik nihłehts'į' t'iichy'aa haa iłts'ik nąįį shrineiinlik, ąįįts'ą' ch'anky'aa iizųų vizhit nąįį chan goots'an tr'ininlii ts'ą' ch'anky'aa iizųų nąįį gigiheehkhyaa geenjit goots'an gwahtsii kwaa, juu t'inchy'aa giiyaandaii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jesus, vanh dąį' tth'aii hee tǫǫ goo'aii gwiizhit khakee'ąįį ts'ą' zheh chyahaazhii ts'ą' oo'ok tthan goo'aii gwa'an gwats'ą' haazhii, zhat khadigiheejyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Gaa Simon ts'ą' juu vaa t'inchy'aa nąįį giiyankeegwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nijin giigwąh'ąįį dąį', “Juu nąįį datthak nankeegwaah'in!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus t'agoovahnyąą, “Dzaa gwa'an kwaiik'it goodlii kwaii datthak gwats'ą' tr'ahoojyaa, izhit gwa'an chan Gwandak Nizįį eegwahaaldak goo'aii, jyąhts'ą' geh'an dzaa gwats'ą' hoiizhii t'ishi'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Zhat gwats'an Galilee nahkat datthak k'eekhwazhii ts'ą' Israel nąįį tr'igiinkhii zheh kwaii gwizhit Gwandak Nizįį eegwaandak ts'ą' ch'anky'aa iizųų nąįį chan dinjii zhit ts'an khaneegoovinzhit. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ts'ą' dinjii ch'ihłak vatthąį' ahjat (leprosy) haa iłts'ik haa khaiinjich'iighit yats'ą' nikiigwiintthaii ts'ą' t'iiyahnyąą, “Gwik'it t'iindhan ji', shatthąį' shrineiinlii!” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus, dinjii, veenjit neeshraahchy'aa ts'ą' danli' haa yakat naanjik ts'ą' t'iiyahnyąą, “Gwik'it t'iihthan t'oonchy'aa, shranąąnjii!” ");
INSERT INTO gwiNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jyaa nyąą gwagwahkhan vakat ts'ik datthak hiljii naanaii ts'ą' shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ąįįtł'ęę Jesus, ginjik nint'aii haa yits'ą' khaginkhee, ts'ą' khan t'ohłii neeyahah'ak. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Giinkhih nahah'yaa geenjit vats'a' hinkhaii. Ąįįtł'ęę jidii Vit'eegwijyąhchy'aa ts'ą' gwantł'ee hin'aa ąįį ginkhii vantł'eiin'ąįį, ąįįt'ee Moses va-law zhit juu ts'ik leprosy ts'an shranaazhik nąįį jyaa dihee'yaa gwinyąą gwik'it.” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Gaa ąįį dinjii yiłeehoozhii dąį', zhat gwagwahkhan deegwiizhit nijuk datthak geegwaandak it'ee łi' gwintł'oo geegwaandak ts'ąįį Jesus zhat kwaiik'it gwa'an k'eeheedik geenjit gaa veegoo'aii kwaa. Geh'an geeghaih tthan gwa'an gwats'ą' haazhii googaa nihk'it, dinjii lęįį nąįį nijuk datthak gwa'an gwats'an giits'eehiidal. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Drin gwintsya' gehgoo goodhat ąįįtł'ęę Jesus, Capernaum kwaiik'it gwits'eehoozhii, ts'ą' dizheh dhidii giiyahnyąą ts'ą' nijuk datthak giiyeeginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ąįįts'ą' dinjii lęįį nąįį giizheh gwizhit łeeljil ts'ąįį khyų' gaa nihdeegijyaa. Jesus Gwandak Nizįį eegoovaagwaandak, ");
INSERT INTO gwiNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","nijin dinjii dǫǫ nąįį zhak k'eegiidal dąį', dinjii neehidik kwaa Jesus ts'ą' nagahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","It'ee shrit dinjii gwanlii ts'ąįį khyų' gindeiinvyaa k'ii'an nihdeegiiyąąhchįį ąįįts'ą' zheh gwakat deegaajil ts'ą' nijin Jesus dhidii ąįį zhit zhat, gwakat yiichy'a' gwigwiłtsąįį k'iizhak chyah kat dinjii nihdeegahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus łyaa gwik'injigwiighit nitsii gii'įį goovah'in ts'ą' ąįį dinjii neehidik kwaa jyaa dahnyąą, “Shidinji', natr'agwaanduu datthak oo'an gwarahaadlii t'oonchy'aa,” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Law eech'ǫąąhtan lat zhat giilk'ii nąįį adagats'ą' ninjich'agadhat ts'ą' jyaa digiindhan, ");
INSERT INTO gwiNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Deenyąą zhyaa Vit'eegwijyąhchy'aa inehts'į' jyąhts'ą' ginkhii t'inyąą? Dinjii ch'ihłee gaa tr'agwaanduu oo'an gwihilii kwaa t'oonchy'aa! Vit'eegwijyąhchy'aa zhrįh jyaa dii'in t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Zhat gwagwahkhan Jesus deegiindhan gavaandaii ts'ą' t'agoovahnyąą, “Jaghaii jyąhts'ą' geenjit ninjich'ǫhthat? ");
INSERT INTO gwiNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Jii dinjii neehidik kwaa, ąįį t'avarahaanjyaa, jidii shrit gwagwantrii kwaa, ‘Natr'agwaanduu neenjit oo'an gwarahaadlii,’ akwat ‘Ndak nininjii, ts'ą' nichyah noiinjii, ts'ą' inkhaa?’ ");
INSERT INTO gwiNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Juk nakhwats'ą' googwahaałkyaa, nats'ąą Gwidinji' ihłii ts'ą' gootr'agwaanduu oo'an gwihihłyaa geenjit.” Ts'ą' dinjii neehidik kwaa jyaa dahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ndak nininjii, ts'ą' nichyah noiinjii ts'ą' oo'an nizheh gwits'eehindii!” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Zhat łąą ąįį dinjii goovandah needhikhin ts'ą' dichyah noonjik, ts'ą' zhat googwahkhan gihłeehoozhii. Łyaa zhyaa datthak ts'ą' goovaa geegwaroolii kwaa t'igwiizhik ts'ą' Vit'eegwijyąhchy'aa deegihił'e' ts'ą' jyaa ginyąą, “Łahchy'aa tth'aii ch'ihłok gaa jyąhts'ą' t'igwii'in gwaraah'in kwaa.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus, Galilee van vee gwa'an chan hee gwits'eehoozhii, dinjii lęįį nąįį giits'ą' haajil ts'ą' zhat geegoovąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Zhat gwa'an neehidik, gwiizhit tax eenjit laraa oonjii nilii, Alphaeus vidinji' Levi didehk'it dhidii ąįį Jesus niyeeł'in ts'ą' t'iiyahnyąą, “Shatąįį hinkhaii!” ąįįts'ą' t'ee ndak niinzhii ts'ą' yaahaazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Zhat khaa Levi, Jesus ts'ą' ditsyaa nąįį haa shaa neech'oh'aa goovahnyąą, zhit juu yah tax eenjit laraa oonjii nąįį ts'ą' dinjii lęįį nąįį tr'agwaanduu googwitr'it gwanlii googahnyąą nąįį chan goovaa neech'aga'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","“Law eech'ǫąąhtan nąįį, ts'ą' Pharisee chan ginlii nąįį, nijin Jesus, tax eenjit laraa oonjii nąįį ts'ą' dinjii tr'agwaanduu googwitr'it gwanlii googahnyąą nąįį haa neech'a'aa googwah'in dąį', giitsyaa nąįį oahkat, “Jaghaii tax eenjit laraa oonjii nąįį ts'ą' dinjii vatr'agwaanduu gwanlii varahnyąą nąįį haa neech'a'aa t'ii'in?” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ts'ą' nijin Jesus gooviitth'ak dąį' jyaa dagoovahnyąą, “Dinjii juu iłts'ik kwaa, nąįį dinjii iłts'ik shrinilik, t'eegaahchy'aa kwaa, gaa dinjii iłts'ik nąįį zhrįh iłts'ik dinjii shrinilik t'eegaahchy'aa t'oonchy'aa. Dinjii nizįį nąįį gootr'agwaanduu gweheelyaa gwits'į' geenjit dzaa gwats'ą' hoiizhii t'ishi'in kwaa gaa zhit juu vatr'agwaanduu gwanlii haakhwandaii nąįį eenjit t'ishi'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ch'ihłan gęhdaa gwandaa John chųų gwats'an ąhtsii vitsyaa nąįį ts'ą' Pharisee gootsyaa nąįį haa khadigiheejyaa geenjit ch'ihłee adach'agaa'aa kwaa. Dinjii lat nąįį Jesus gwaahkat, “Jaghaii John vitsyaa nąįį ts'ą' Pharisee gootsyaa nąįį adach'agaa'aa kwaa gwagwahtsii gwiizhit nitsyaa nąįį jyaa digii'in kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus t'agoovahnyąą, “Dinjii, tr'injaa haa nihłeegoorahchįį dąį' juu goovaach'ihee'aa nąįį shih ehdan t'igiheechy'aa goovohnyąą? Duuyeh jyaa t'igiinchy'aa gaakhwandaii, dinjii goonjik gavaa dhidii gwiizhit jyaa t'igihee'yaa kwaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gaa, nijin drin dinjii goonjik goołeerehiłchįį ji' t'ee adach'agaa'aa kwaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Dinjii ch'ihłak gaa duuyeh ch'adak ik k'eejit nilii kwaa kat gwach'aa k'eejit k'aahkaii t'oonchy'aa jyaa diizhik ji' zhit gwach'aa k'eełkaii ąįį natsal nahaadhal ts'ą' gwandaa łeeheech'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Duuyeh gwik'it ch'ihłee gaa, jak chų' k'eejit nilii ąįį ch'adhah tyah k'eejit nilii kwaa zhinjyaa t'oonchy'aa, jyaa diizhit ji' t'ee jak chų' ch'adhah tyah gwintł'oo łeehahch'aa ts'ą' zhit jak chų' an heelyaa ąįį geh'an jak chų' k'eejit nilii ch'adhah tyah k'eejit nilii zhit khohjaa gwizhrįh goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ch'ihłan Neegwaazhii Drin gwiizhit Jesus ditsyaa nąįį haa gwanzhįh dehk'it tł'oo li' (wheat) tee geedaa gwiizhit vitsyaa nąįį tł'oo li' ąįį vitsii gwanzhįh tsal dhidlii kwaii gihłeegihilii ts'ą' giiyaajyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ąįįtł'ęę Pharisee nąįį Jesus jyaa dagahnyąą, “Dzaa gwąąh'in! Dii-law kat jyaa digwehee'yaa kwaa goo'aii gwinyąą ąįį gwiizhit nitsyaa nąįį Neegwaazhii Drin zhit jyaa digii'in ginyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus, t'agoovahnyąą, “Yeenii King David deezhik varahnyąą gwadanakhwatł'oo ąįį nik'ee gooh'in t'ohnyąą? Adan ts'ą' diniveet'ah'in nąįį haa goozhit gwiłts'ik ts'ą' ch'aroo'aa giindhan dąį'? ");
INSERT INTO gwiNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Vit'eegwijyąhchy'aa vizheh gwadhah gwizhit nihdeiinzhii ts'ą' łųhchy'aa Vit'eegwijyąhchy'aa vats'ą' ataiinjii giłtsąįį iin'al, ąįįtł'ęę viniveet'ah'in nąįį gaa giiyiin'al. Abiathar, ndak khii giinkhih choh nilii dąį' t'igiizhik. Dii-law kat jyaa gwinyąą, giinkhih zhrįh ąįį łųhchy'aa hee'aa gwinyąą gaanoondaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ts'ą' tth'aii jyaa nyąą, “Neegwaazhii Drin zhit t'ee nankat dinjii yaa gwinzii t'ihee'yaa eenjit iltsąįį, ąįį nankat dinjii nąįį Neegwaazhii Drin eenjit giltsąįį kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ąįįt'ee shįį Gwidinji' t'ihchy'aa ts'ą' Neegwaazhii Drin gaa gwats'ą' k'eegwaldhat t'oonchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nijin Jesus chan hee Israel nąįį tr'igiinkhii zheh nihdineezhii dąį', izhit gwizhit dinjii vanli' iłchįį goodlit zhat dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Izhit gwizhit dinjii lat nąįį dilk'ii Jesus k'eegahtii, ąįį dinjii vanli' shrineeheelyaa ji' geenjit. Jyaa diizhik ji' Neegwaazhii Drin zhit gwiizųų t'ii'in giihaanjyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ts'ą' ąįį dinjii vanli' iłchįį dhidlit t'ahnyąą “Aanaii dzaa dinjii nąįį andah shats'ą' hinkhaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ąįįtł'ęę Jesus dinjii nąįį oahkat, “Dii-law Neegwaazhii Drin zhit deegwehee'yaa goo'aii gwinyąą? Dinjii ts'igweheenjyaa akwat dinjii ts'arahahthaa, dinjii viheekwaa gwits'į' vits'igweheenjyaa akwat dinjii ęhdaa tr'igwirehee'aa?” Gaa k'eegwiichy'aa t'iginyąą kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus, vik'įį gwanlii ts'ą' gootee datthak gwąąh'in gaa nihk'it gooveenjit tr'igwidii, gwiizųų tr'ihkhit ninjich'agadhat ts'ą' gooki' tth'an dach'at geh'an. Ąįįtł'ęę zhit dinjii jyaa dahnyąą, “Nanleetth'ak kwaii nihky'aa oonjii.” Ąįį dinjii jyaa diizhik ts'ą' vanli' nizįį neekhwadlit. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ąįįts'ą' Pharisee nąįį Jews tr'igiinkhii zheh cheegahoojil, gwagwahkhan King Herod vijyaa nąįį haa łigiiljil ts'ą' Jesus nats'ahts'ą' ęhdaa tr'igwigwehee'aa geegiginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus ts'ą' ditsyaa nąįį haa Galilee van vee gwats'ą' gahaajil. Galilee nahkat, ts'ą' Judea nahkat gwats'an dinjii lęįį nąįį yatąįį neehiidal, ");
INSERT INTO gwiNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ąįįts'ą' Jerusalem kwaiik'it gwachoo, Idumea nahkat gwa'an, Jordan han ndųhts'ąįį gwats'an gwa'an ąįįts'ą' Tyre ts'ą' Sidon kwaiik'it gwachoo geelin gwa'an datthak gwats'an lęįį nąįį dee'in datthak giiyeenjit gwiitth'ak geh'an Jesus tąįį gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tr'ihkhit dinjii gwanlii ts'ąįį ditsyaa nąįį t'ahnyąą, tr'ihchoh dzaa sheenjit nǫhłit, jii dinjii lęįį nąįį giiyeelin datthak giiyaa gwiłtł'at geh'an t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Dinjii lęįį nąįį shrininlik googaa nihk'it dinjii iłts'ik lęįį nąįį giits'ą' handak, giikat nahaandal eenjit gwizhrįh t'igiiyah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ąįįts'ą' nijin dinjii ch'anky'aa iizųų goozhit t'inchy'aa nąįį giiyąąh'in dąį' giiyęhdaa nit'eegaadhak ts'ą' giiyahshral, “Nan, Vit'eegwijyąhchy'aa Vidinji' inlii!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","“Juu t'ihchy'aa geegǫǫndak shrǫ'!” Jesus, ch'anky'aa iizųų nąįį, ginjik nint'aii haa jyaa gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus, ąįįtł'ęę taih kat gwa'an hadhizhii ts'ą' juu dinjii niindhan nąįį aanaii ahnyąą, ąįįts'ą' giits'ą' haajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","Ąįįts'ą' dinjii twelve nąįį gwiteetr'iinlii ts'ą' juk gwats'an nakhoozhri', “Tr'ihił'e',” oohaazhyaa ąįįts'ą' “Shaahohłyaa geenjit gwiteetr'inakhwinlii t'oonchy'aa. Ąįįts'ą' chan nihky'aa k'eekhwadal ts'ą' Vit'eegwijyąhchy'aa eegwahoondak, ąįįts'ą' ch'anky'aa iizųų dinjii nąįį ts'an tr'ahohłyaa geenjit t'aih akhwa'yaa t'oonchy'aa.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jii dinjii nąįį gwitee tr'agoovinlii Tr'ihił'e' giheelyaa geenjit: Simon (ąįį Jesus, Peter yoozhri' niłtsąįį), ");
INSERT INTO gwiNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee vigii James ts'ą' vachaa John haa (Jesus, gavoozhri' ch'ijuk niłtsąįį, ts'ą' Boanerges neegoovaanyąą, ąįįt'ee “Dinjii nąįį nahtan haadhak k'it giint'aii.” gwinyąą t'igwinyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, Alphaeus vidinji' James, Thaddaeus, ąįįts'ą' Simon t'ee Zealot nilii (Zealot t'ee, “Dinjii łyaa danahkat geet'indhan nilii,” gwinyąą t'igwinyąą). ");
INSERT INTO gwiNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ts'ą' Judas Iscariot, ąįįt'ee Jesus tr'ahaahkhwaa geenjit gwantł'ąhchįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ąįįtł'ęę Jesus dizheh gwits'ee hoozhii, ts'ą' ditsyaa nąįį haa chan hee ch'igihee'aa gaa it'ee shri' goovaa dinjii gwanlii ts'ąįį gooveenjit nigwiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nijin Jesus vizheh k'ąą nąįį gwigwiitth'ak dąį' giik'eehahtyaa geenjit giiyinkeegwaah'in, ts'ą' gihłeegiihiłchįį dinjii nąįį, “Vagwandaii iizųų dhidlit.” gaa giiyahnyąą geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem gwats'an Law eech'ǫąąhtan nilii nąįį jyaa ginyąą, “Ch'anky'aa iizųų nąįį datthak ts'ą' k'eedeegwaadhat Beelzebul oaazhii vizhit dhidii ąįį vat'aii haa ch'anky'aa iizųų cheehilii t'ii'in.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ąįįts'ą' t'ee Jesus dinjii zhat łeeljil nąįį, aanaii gavahnyąą ts'ą' gwandak haa geegoovąąhtan, “Nats'ahts'ą' Satan dinjii nąįį goozhit gwats'an Satan ch'anky'aa iizųų nąįį cheehahchyaa? ");
INSERT INTO gwiNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jidii nahkat nihts'įį nihts'ą' nineegiidal ts'ą' nihłigiighan ji' khants'ą' an gweheelyaa gwagwahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Zhehk'aa gwizhit chan nihłigiighan ji' t'ee tthak an gweheelyaa gwagwahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ąįį gwik'it Satan vineegoo'ee khaihłak gwanlii kwaa ts'ą' nihtee nihłigiighan ji' duuyeh niighyuk khaihłak gwanlii ts'ą' nihłaa shrahtee gwagwahahtsyaa ts'ą' an gweheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Dinjii ch'ihłee gaa duuyeh zhyaa dinjii vagwahtł'oo vizheh zhyaa nihdąhkhaii ts'ą' yagwadal oonjii t'inchy'aa. Diyiłchaa ts'ą' naghwaayiin'ąįį ji' gwizhrįh yagwadal ooheendal t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Łi'haa nakhwaagwaldak t'inyąą, dinjii ch'ihłee tr'agwaanduu nihłehjuk vigwitr'it gwanlii ji' gaa, shatr'agwaanduu gwanlii nyąą ts'ą' Vit'eegwijyąhchy'aa sheenjit oo'an gwihinlii ahnyąą ji' khan gooveenjit oo'an gweheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gaa juu Ch'anky'aa Shroodiinyąą gwiizųų eeginkhii ji', ąįį tr'agwaanduu t'ii'in geh'an ndaagwąą'ąį' gwats'ą' datthak duuyeh veenjit vatr'agwaanduu oo'an gwirihilii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Ch'anky'aa iizųų vizhit t'inchy'aa!”, giiyahnyąą geh'an Jesus jyaa gavahnyąą t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Izhit zhat chiitąįį vahan, ts'ą' vachaa nąįį haa k'eedal, chiitąįį nigiilzhii gwiizhit zheh giiyeenjit ch'oahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dinjii lęįį nąįį Jesus eelin giilk'ii gwiizhit jyaa digiiyahnyąą, “Nahan, ts'ą' nachaa nąįį haa, chiitąįį nigiilzhii, ts'ą' nooł'ya' nagahnyąą.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ts'ą' t'agoovahnyąą, “Juu dee shahan ts'ą' shachaa nąįį haa nilii?” ");
INSERT INTO gwiNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ąįįts'ą', t'ee Jesus ąįį juu yeelin dilk'ii nąįį tee gwąąh'in ts'ą' jyaa goovahnyąą, “Jii nąįį t'ee shahan ts'ą' shachaa nąįį haa t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Juu Vit'eegwijyąhchy'aa doo'ya' gavoonyąą nąįį gwik'it t'igii'in nąįį t'ee shahan, shachaa, ts'ą' shijuu nąįį haa nilii t'oonchy'aa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Galilee van vee gwa'an, chan hee Jesus geech'ooheełchya', gaa tr'ihkhit veelin dinjii gwanlii ts'ąįį tr'ihchoh zhinzhii ts'ą' naadii. Van vee gwats'ą' niighit kwaa tr'ihchoh dhitin, gwiizhit dinjii nąįį teeghaii nigeelzhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gwinlęįį goovaagwahandak geenjit gwandak ąhtsii zhit geegoovąąhtan ts'ą' jyaa nyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ch'oodǫǫhk'įį! Ch'ihłan dąį' dinjii ch'ihłak gwanzhįh dehk'it gwa'an gwats'ą' haazhii, ts'ą' gweheełshii. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ąįįts'ą' gwanzhįh gwit'eiinlii gwizhit valat kwaii tąįį gwinjik gwa'an an-nihłik niinjil ts'ą' chiitsal kwaii datthak giiyiin'al.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Valat kwaii łųh vitee kii gwanlii ąįį gwinzii vitee łųh kwaa izhit niinjil. Łųh gwanlii kwaa geh'an khan hahshii, ");
INSERT INTO gwiNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","gaa nijin shree ndak nee'aa dąį', ąįį gwanzhįh gwintsal hiłshii iłk'in ts'ą' nanzhit nahgwan niłshįį geh'an gwanzhįh navagaii aanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gwanzhįh lat kwaii chan khoh nahshii tee niinjil, ts'ą' khoh gwandaa niłshįį ts'ą' khoh yiiłkhwaii, ąįįts'ą' vats'an tr'ihee'aa niłshįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gaa gwanzhįh valat kwaii nankat łųh nizįį kat niinjil ts'ą' gwanzhįh gwinzii niłshįį ts'ą' vats'an tr'ihee'aa lęįį kwaii niłshįį. Valak kwaii ants'ą' tik daatin (30) niłshįį, ants'ą' chan nihk'iitik daatin (60) ąįįts'ą' valat ch'ihłoaatin daatin (100), jyaa dagwahtł'oo gwiłshii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ąįįtł'ęę Jesus, t'agoovahnyąą, “Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'!” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nijin Jesus adan zhrįh dhidii dąį', gwehkįį juu gwaandak giiyiitth'ak lat nąįį, ts'ą' vitsyaa 12 Tr'ihił'e' nąįį haa giits'ą' haajil ts'ą' jidii eech'ǫąąhtan eenjit giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","“Vit'eegwijyąhchy'aa Veegwinii'ee ąįį nagwaan'įį nakhwantł'eegwirin'ąįį. Gaa ch'izhii dinjii nąįį datthak gwandak ałtsii haa geech'ǫąąłtan k'iighai' deihnyąą gwigweheetth'ak, t'oonchy'aa.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jii Dęhtły'aa Choh zhit deegwinyąą ąįį gwik'it t'igweheenjyaa geenjit jii jyaa nyąą, “Gwinzii googwąąh'in gaa gwinzii goovaa gweheechy'aa kwaa ts'ą' chan gwinzii ch'agoołk'įį gaa deegwinyąą t'igwinyąą gaagiindaii kwaa, jii kwaii datthak gaagiindaii ji', Vit'eegwijyąhchy'aa ts'ą' łihts'eedagahaa'ee ąįįts'ą' t'ee gootr'agwaanduu datthak gooveenjit oo'an gweheelyaa t'inchy'aa,” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ąįįtł'ęę Jesus, goovaahkat, “Jii gwandak ałtsii haa geech'ǫąąłtan deegwinyąą t'igwinyąą gaakhwandaii? Nakwaa, ji' nats'ahts'ą' gwandak ałtsii eegwaldak kwaii deihnyąą t'ihnyąą gaahahkhwandaii? ");
INSERT INTO gwiNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Zhit juu, dinjii gwanzhįh nahshii, ąįįt'ee Vit'eegwijyąhchy'aa Viginjik, Gwandak Nizįį nilii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dinjii lat nąįį gwanzhįh tąįį gwinjik gwa'an niłshįį k'it t'igiinchy'aa, Vit'eegwijyąhchy'aa Viginjik giitth'ak gwagwahkhan Satan zhat goots'ą' khakhat ts'ą' goots'į' yuundak. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ch'izhii dinjii nąįį, gwanzhįh kii tee gwa'an niinjil k'it t'igiinchy'aa, Vit'eegwijyąhchy'aa Viginjik giitth'ak gwagwahkhan geenjit łyaa shoo ginlii, ");
INSERT INTO gwiNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","gaa gwint'aii Vit'eegwijyąhchy'aa Viginjik goontą' kwaa, ąįįts'ą' googwik'injigwiighit geh'an goovaagogwantrii ts'ą' khaiinjich'igiighit dąį' niighit kwaa gwats'ą' gwizhrįh gwagoontą' ts'ą' akhagagoonjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ch'izhii dinjii nąįį gwanzhįh khoh tee niinjil k'it t'igiinchy'aa. Jii nąįį t'ee Vit'eegwijyąhchy'aa Viginjik giitth'ak, ");
INSERT INTO gwiNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","gaa dzaa nankat nats'ąą gwigweheendaii geenjit gwizhrįh ninjich'agadhat ts'ą' laraa chan gihił'ee ts'ą' geedan deegoo'ya' giindhan gwizhrįh gwik'it t'igii'in ts'ą' Vit'eegwijyąhchy'aa eenjit gwitr'it t'agwagwah'in kwaa, ts'ą' gwanzhįh vakat gwąąhshii kwaa k'it t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Gaa ch'izhii dinjii nąįį, gwanzhįh łųh nizįį kat niinjil t'ee, Vit'eegwijyąhchy'aa Viginjik, gwiinzii giitth'ak ts'ą' digidrii zhit giiyųųntą' Vit'eegwijyąhchy'aa k'eegwagwahthat geh'an goohaa nahshii gwintł'oo yahtsik. Valat 30, valat 60 ąįįts'ą' valat 100 jii jyaa daanchy'aa yahtsik.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus, tth'aii hee goots'ą' ginkhii ts'ą' jyaa nyąą, “Dinjii ch'ihłee khan aadrii daak'a' ąįį tyah tł'oo haa iltsąįį t'eh akwat dehk'it gwit'eh nihee'aa lee t'oonchy'aa? Vats'anh ch'ahaadrii kwaa geenjit. Nakwaa! Vats'anh ch'ahaadrii geenjit aadrii daak'a' vakat doo'aii kat deeyahee'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jidii nagwarah'įį ts'ą' geegoh'it goodlii kwaii datthak aadrii zhit gwizhrįh nigweheedaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'!” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ąįįtł'ęę chan hee jyaa goovahnyąą; “Jidii dohtth'ak geenjit tseenjyaa ch'oodǫǫhk'įį! Nats'ahts'ą' ch'izhii dinjii nakhweenjit dinjii nilii ąįį gwik'it Vit'eegwijyąhchy'aa, jyąhts'ą' dinjii ǫhłįį nakhwahaanjyaa ts'ą' gwandaa gwiizųų gwak'oonakhwahahchy'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Zhit juu jidii gwii'įį, ąįį gwandaa vantł'ee neegwireheelyaa ąįįts'ą' juu vaach'akwaa, akwat, jidii tsal zhrįh gwii'įį ji' gaa, vits'į' neerahoondal t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus, tth'aii hee ginkhii ts'ą' jyaa goovahnyąą, “Vit'eegwijyąhchy'aa Veegwinii'ee, jii k'it t'oonchy'aa. Dinjii ch'ihłak dagwanzhih, gwanzhįh deek'it gwit'eiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ąįįts'ą' tǫǫ gwitee gwagwaanchy'aa dhichįį, ąįįts'ą' vanh dąį' hee khakii'ak, ts'ą' drin datthak deehee'yaa goo'aii datthak gwik'it t'ii'in, gwiizhit vagwanzhih datthak haahshii ts'ą' nahshii, gaa nats'ahts'ą' nahshii t'ii'in yaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nankat łųh t'ee gwanzhįh nahshii ąhtsii ąįį t'ee gwanzhįh gwinzii vakat datthak nahshii. Gwanzhįh nahshii dąį', vatthoochan tr'ookit agwaakit, ąįį gwats'an t'ee vikiitth'an k'it t'inchy'aa vakat nadal ąįįtł'ęę t'ee vakat datthak lęįį ilik. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nijin gwanzhįh kharaheelyaa eenjit gwinzii nagwaadhat dąį', zhit dinjii, jidii vaa gwanzhįh kharaht'ii haa khayaht'ii, it'ee gwanzhįh kharaheelyaa nigwiindhat geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus ch'oahkat, “Vit'eegwijyąhchy'aa Veegwinii'ee jidii k'it t'oonchy'aa t'agwarahnyąą gweheenjyaa? Jidii gwandak tr'ahtsii haa geegwarahaandak li'? ");
INSERT INTO gwiNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jii k'it t'oonchy'aa, “Dinjii ąįį mustard seed tsal oonjik ts'ą' nijin nankat gwit'eh yiin'ąįį (mustard seed ąįį ch'andaa t'ahtsal nilii), ");
INSERT INTO gwiNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ąįįtł'ęę nahshii dąį', gwanzhįh vach'ahtsii kwaa dhidlit. It'ee shrit vatthoochan nitsii dhidlit ts'ąįį dziitsal nąįį giikat t'oh ąhtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus, jii k'it t'inchy'aa haa gwandak ąhtsii haa dinjii nąįį Vagwandak Nizįį ts'ą' geech'ǫąąhtan, deegwahtł'oo gaagweheendaii gwagwahtł'oo gwizhrįh goots'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Dinjii gwanlii tee gwa'an gwandak ąhtsii haa zhrįh geech'ǫąąhtan, gaa nijin ditsyaa nąįį haa tthan dhidii dąį' gwandak ąhtsii zhit deenyąą t'inyąą gavaa gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Zhat drin khaa nigwiindhat dąį', Jesus ditsyaa nąįį t'ahnyąą, “Oonjik van ndųhts'ąįį gwats'ą' tr'ahoojyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ts'ą' dinjii lęįį tr'ihchoo eeghaii łagaajil nąįį ihłeegahoojil, Jesus dahaa gihiłchįį. Ts'ą' ch'izhii dinjii nąįį tr'ihchoh kwaii goiinjik ts'ą' goovaa gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ts'ą' khan hee gwint'aii teiintr'aii nagwaanąįį, gwiizhit chųų lęįį tr'ihchoh zhit t'iinjii, tr'ihchoh zhit tit choh kwaii haa chųų deedąą'ąį' gwilii. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Gaa jyaa digwii'in gwiizhit, Jesus, tr'ihchoh tł'i' zhit, tsuh kat diki' dił'aii ts'ą' gwinzii dhichįį. Ts'ą' vitsyaa nąįį khakigiiyiin'ąįį ts'ą' t'igiiyahnyąą. “Geech'ǫąąhtan, it'ee tr'ahahchyaa nagwaanąįį nik'ee diineenjit tr'igwiindii?” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ts'ą' Jesus khakee'ąįį ts'ą' ahtr'aii choo niint'aii ts'ą' van kat tit ginjik niint'aii haa goots'ą' khaginkhee, “Ahtr'aii, khaihłan jyaa dohchy'aa! Tit choh kwaii, tsinehdan gooli'!” nyąą gwiizhit ahtr'aii nint'aii neet'aanąįį ts'ą' datthak tsinehdan nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ąįįtł'ęę Jesus ditsyaa nąįį t'ahnyąą, “Nakhwagwik'injigwiighit kwaa geh'an noojat t'akhwa'in?” ");
INSERT INTO gwiNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ts'ą' gwintł'oo gwihil'ee t'iizhik ts'ą' gihilghaa haa jyaa dinihłagaanyąą, “Jii juu dinjii t'inchy'aa? Ahtr'aii choh, ts'ą' tit choh kwaii gaa giik'eegwahthat!” ");
INSERT INTO gwiNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ąįįtł'ęę van ndųhts'ąįį Gerasa nahkat ąįį zhit k'eegiidal. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nijin Jesus, tr'ihchoh zhit gwats'an deiinzhii dąį' dinjii vizhit ch'anky'aa iizųų ąįį, kii ch'a'an zhit tth'an k'it goodlii gwats'an khaiinzhii ts'ą' yats'ą' tr'iinzhii, ");
INSERT INTO gwiNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ąįį tth'an k'it gwa'an gwitee gwich'įį ts'ą' juu nąįį datthak ch'iitsii tły'ah haa dineegiiyahchaa googaa khyų' giiyųųntą'. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Deegwahtł'oo giiyanli', ts'ą' giikwai' haa ch'iitsii tły'ah haa dineegiiyahchal, googaa nihk'it ch'iitsii tły'ah łahnaii gwats'an tr'inidik. It'ee shrit nint'aii ts'ąįį k'iizhak giiyahoontą' geenjit gaa gwagwantrii. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tǫǫ ts'ą' drin haa tth'ank'it gwitee, ts'ą' taih tee haa gwa'an neehihdik ts'ą' azhral ts'ą' kii haa datthąį' khadant'ii. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nijin shriit'ąhthee ahaa gwiizhit, Jesus neeł'in dąį' yats'ą' hilgik ts'ą' yats'ą' nikiigwiintthaii, ");
INSERT INTO gwiNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ts'ą' gwint'aii azhral ts'ą' jyaa nyąą, “Jesus, Vit'eegwijyąhchy'aa Jiintsii, Vidinji' inlii, deeshahah'yaa eenjit t'ini'in? Vit'eegwijyąhchy'aa vik'iighai' nadach'ooshakwat t'inyąą khaiinjich'ashǫhthat shrǫ'!” ");
INSERT INTO gwiNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ąįį jyaa nyąą geh'an Jesus jii jyaa nyąą, “Ch'anky'aa iizųų, jii dinjii vizhit gwats'an khaiinkhaii.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus yuahkat, “Noozhri' doozhii?” Ąįį dinjii yidii ginkhe', “Shoozhri' Legion (niveet'ah'in lęįį) oaazhii, it'ee shrit tr'iinlęįį ts'ąįį jyąhts'ą' diinoozhri' t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ąįį dinjii vizhit ch'anky'aa iizųų kwaii, Jesus ts'ą' gwintł'oo ch'oodigiikwat, “Dzaa nahkat gwats'an gihłeediihoiinlyaa shrǫ'!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Izhik geeghaih gwa'an taih khyųų pig lęįį kwaii ch'a'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ąįįts'ą' zhit ch'anky'aa iizųų nąįį Jesus eech'oodigiikwat ts'ą' t'iginyąą, “Pig kwaii ts'ą' tr'iheedaa ts'ą' goozhit direheedhaa.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ąįį gwik'it t'igiizhik goots'an gwiłtsąįį, ąįį dinjii ts'an tr'ineegiijil ts'ą' pig kwaii zhit digiindhat. Ąįį pigs naatł'ii 2,000 aanchy'aa kwaii datthak taihdik gwats'an van zhit oondaa gahaajil ts'ą' teenagahoonii. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ąįį pigs k'ąąhtii nąįį datthak gihłeegalgihiljil ts'ą' zhat kwaiik'it gwatsal gwitee gwich'įį nąįį ts'ą' zhat gwa'an juu gwanzhįh nahshii gwich'įį nąįį datthak haa gwagwaandak, ts'ą' dinjii nąįį deegwiizhik t'igwinyąą li' geenjit gwagwahąąh'yaa gwats'an gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Zhat gwa'an dinjii nąįį datthak Jesus ts'ą' gahaajil, ąįį dinjii vizhit ch'anky'aa iizųų lęįį yizhit t'inchy'aa chy'ah, giiyąąh'in, akhai' veenjit gwinzii ts'ą' gwinzii chan niinjich'adhat ts'ą' zhat dhidii, ts'ą' gwach'aa naazhii. Dinjii nąįį datthak gwagwah'in dąį' gąąnjat nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dinjii datthak gwehkįį deegwiizhik gwagwąąh'ya' nąįį, dinjii zhat nijyaa nąįį datthak zhit dinjii ts'ą' pigs haa deegiizhik goovaagwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ąįįts'ą' zhat dinjii nąįį datthak Jesus diinahkat gihłeehindii agahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","It'ee Jesus tr'ihchoh zhit neehidii gwiizhit, ąįį dinjii vizhit ch'anky'aa iizųų tr'iniinlii chy'ah yach'adookwat ts'ą' jyaa nyąą, “Naa neeshozhi'” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Gaa Jesus jyaa yahnyąą, “Nakwaa! Nizheh gwits'ee hindii ts'ą' nizheh k'ąą nąįį K'eegwaadhat deegwahtł'oo neeshraahchy'aa noonyąą ts'ą' neenjit deezhik datthak goovaagwandak.” ");
INSERT INTO gwiNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ąįįts'ą', ąįį dinjii Decapolis nahkat gwitee haazhii ts'ą' Jesus yeenjit deezhik datthak geegwaandak. Juu yiitth'ak nąįį datthak łahchy'aa gooveenjit geegagoolii kwaa t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nijin Jesus, van ndųhts'ąįį gwits'ee hoozhii dąį' aiizhit van vee gwa'an, dinjii lęįį nąįį yeelin łeeljil. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ąįįtł'ęę nijin Jews' tr'igiinkhii zheh gwizhit gwats'ą' k'eedeegwaadhat ch'ihłee Jairus oozhii zhat k'idik dąį', Jesus neeł'in gwagwahkhan, yakwai' eeghaii nikiigwiintthaii ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jesus ts'ą' ch'oodiikwat haa yuahkat, “Shigii nich'it tsal gwint'aii iłts'ik, Ąįį vakat nahaandal ts'ą' veenjit gwinzii neegwahahtsyaa geenjit shaa hinkhaii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ąįįts'ą' Jesus yaa haazhii, dinjii lęįį vaa adaa ts'ąįį nihłehjuk datthak an giiyahtrak. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Gootee tr'injaa ch'ihłak niighyuk (12 years) datthak gwintł'oo, dah vats'an an ilii haa khaiinjich'iighit. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dinjii iłts'ik shrinilik nilii nąįį ts'ą' łyaa dalaraa datthak an iłtsąįį, gaa giiyeenjit gwinzii neegwąhtsii kwaa, ąįįts'ą' gwandaa veenjit gwiizųų gwilii. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesus, eenjit gwiitth'ak ts'ą' dinjii lęįį łeeljil tee gwats'an yant'ii niinzhii, ");
INSERT INTO gwiNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Vagwach'aa kat naaljik ji' gaa sheenjit gwinzii neegweheelyaa gwizhrįh.” adaa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ąįįts'ą' yi'ik kat naanjik, gwagwahkhan vadaa an ilii kwaa nagwaanąįį, veenjit gwinzii neegahoodlit łee dizhit gwats'an idiky'aanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Gwagwahkhan dinjii gwanlii tee Jesus vat'aii kwaa nagwaanąįį. Giky'aanjik gwagwahkhan łihts'eediil'ee ts'ą' ch'oahkat, “Juu shagwach'aa kat naanjik?” ");
INSERT INTO gwiNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","“Dinjii neelin gwanlii gwiizhit jaghaii juu nakat naanjik, diinyąą ts'ą' ch'oahkat?” vitsyaa nąįį giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Googaa nihk'it Jesus juu t'iizhik li' geenjit gootee gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nijin tr'injaa vats'a' deegwiizhit gwiky'aanjik dąį', najat haa daatrat gwiizhit gaa Jesus eeninzhii ts'ą', yikwaiichan nikiigwiintthaii ts'ą' łi'deegwidlii haa deegwiizhii datthak yaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","“Shichi', nigwik'iinjigwiighit k'iighai' neenjit gwinzii neegahoodlit ąįįts'ą' nidivee gwiizųų datthak gwinzii neegahoodlit, shigii tsinehdan haa oo'an neehiindii,” Jesus, yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tth'aii hee ginkhii gwiizhit, Jairus vizheh gwats'ąnh dinjii lat nąįį k'eegiidal ts'ą' Jairus jyaa agahnyąą, “Nigii nich'it tsal ch'adąį' hee niindhat t'oonchy'aa. Jaghaii ąįį geech'ǫąąhtan vaandeegwiin'ąįį?” ");
INSERT INTO gwiNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gaa Jesus, deeginyąą zhyaa gwiitth'ak ts'ą' Jairus ąįį t'ahnyąą, “Nanjat kwaa ts'ą' gwik'injiinghit gwizhrįh t'inchy'aa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ąįįtł'ęę, Peter, James ts'ą' vachaa John nąįį zhrįh giiyaaheedaa gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nijin Jairus vizheh k'eegiidal dąį' zhat dinjii nąįį gitree, ts'ą' tree'yaa dha'aii gwiizhit gwinzii goovaa goo'aii kwaa, Jesus goovah'in, ");
INSERT INTO gwiNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ąįįts'ą' nijin nihdeiinzhii dąį' t'agavahnyąą, “Jaghaii nakhwaa gwinzii goo'aii kwaa, ts'ą' ohtree? Jii nich'it tsal niindhat kwaa gąą zhyaa dhichįį t'inchy'aa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ąįįts'ą', ąįį zhit zhat, Jesus deenyąą eenjit giiyeedlaa. Ąįįts'ą' datthak cheegoovahaadlii, ts'ą' zhit nich'it tsal, viti' ts'ą' vahan, ts'ą' ditsyaa tik nąįį zhrįh dahaa nihdeiinlii. Ąįįts'ą' nijin nich'it tsal gilt'aii gwats'ą' haazhii ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","yanli' oonjik ts'ą' t'iiyahnyąą, “Talitha Koum!” (Jii t'ee “Nich'it tsal khakeena'ąįį naihnyąą!” gwinyąą t'igwinyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Zhat gwagwahkhan ndak needhijin ts'ą' zhat gwa'an neehidik. (12 years old nilii jyaa digwiizhit dąį'.) Zhat łyaa datthak goovaa nindal gwaazhit. ");
INSERT INTO gwiNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Gaa Jesus t'agavahnyąą, “Łyaa zhyaa ch'ihłak gaa haa goondak shrǫ'! Shih yihee'aa, ji' vantł'ohtsit,” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus, ąįį zhit gihłeehoozhii ts'ą' dakwaiik'it gwits'eehoozhii, ts'ą' vitsyaa nąįį yaahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nijin Neeraazhii Drin zhit nigwiindhat dąį', Jews tr'igiinkhii zheh gwizhit geech'ǫąąhtan. Dinjii lęįį nąįį giiyiitth'ak dąį', gooveenjit łyaa geegwaroolii kwaa t'igwinyąą ts'ą' t'iginyąą, “Nijin gwats'an jii kwaii datthak goonjik t'inyąą? Jidii gwizhįh dee vantł'eetr'in'ąįį t'inyąą? Nats'ahts'ą' gwigweech'in t'ii'in t'ii'in? ");
INSERT INTO gwiNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dinjii dachan haa gwahtsii nilii ts'ą' Mary vidinji' nilii lee t'inchy'aa? Ąįįts'ą' James, Joseph, Judas, ts'ą' Simon, nąįį haa datthak oondee nilii lee t'inchy'aa? Vijuu nąįį chan dzaa gwa'an gwigwich'įį?” giiyahnyąą. Jyaa ginyąą ts'ą' giit'injyah'ee ts'ą' giits'į' t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesus t'agoovahnyąą, “Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii nąįį t'ee nijuk datthak giiyihił'ee gaa danahkat gwizhit valak nilii nąįį, ts'ą' goozhehk'aa nilii nąįį giihił'e' kwaa, gaa ch'adanh gwa'an datthak giihił'ee t'igiinchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ąįį kwaiik'it gwizhit dinjii nitsya' nąįį zhrįh kat naanjik ts'ą' gooveenjit gwinzii neegahoodlit, gaa giik'injiighit kwaa geh'an gwigwee'in gwinlęįį gootee t'ee'ya' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesus łyaa geegoolii kwaa veenjit t'oonchy'aa, gwik'injigwiighit gii'įį kwaa geh'an. Ąįįtł'ęę Jesus, zhat gwa'an kwaiik'it gwatsal gwitee haazhii ts'ą' Gwandak Nizįį geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesus ditsyaa 12 nąįį khaihłan niinlii ts'ą' neekwaii ginlii ts'ą' nihky'aa goovihił'e' ts'ą' juu vizhit ch'anky'aa iizųų nąįį ts'ą' tr'igiheendal geenjit t'aih goots'an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jii łyaa gwik'it t'akhwa'yaa t'anakhwaihnyąą goovahnyąą, “Nihky'aa hohdaa geenjit, t'oh, ohtsuu, shih, ts'ą' laraa dhah zhit laraa ch'ihłak neehoozhik shrǫ', ");
INSERT INTO gwiNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","gaa kwaiitryah ts'ą' gweezhak ik noozhii ąįį zhrįh haa hohdaa yuu.” ");
INSERT INTO gwiNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ąįįts'ą' chan t'agoovahnyąą, “Nijin zheh gohch'įį gwizhit gwizhrįh gohch'įį, dahthee gihłeekhwadaa gwats'ą' datthak. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nijin kwaiik'it k'eekhwadal ji' ąįį dinjii nąįį nakhweenjit shoo ginlii kwaa ts'ą' nakhwagoołk'įį kwaa ji' gihłeekhwajyaa ts'ą' nakhwakwai' kat łųh nǫhghat, jyąhts'ą' gwik'iighai' zhit dinjii nąįį gwiizųų t'igiizhit łee gaageheendaii eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ąįįts'ą' t'ee vitsyaa nąįį gahaajil ts'ą' Gwandak Nizįį eech'agǫąąhtan ts'ą' nakhwatr'agwaanduu gwats'an łihts'eedǫǫ'ee googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ch'anky'aa iizųų nilii lęįį nąįį dinjii zhit gwats'an chagahaadlii, ts'ą' iłts'ik lęįį nąįį gaa kat olive ghwai' haa googahtłee, ąįį gwik'iighai' gooveenjit gwinzii neegahoodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Izhit zhat dąį' k'eedeegwaadhat choh (King) Herod Antipas, jii kwaii eenjit datthak gwiitth'ak, Jesus vagwandak, ąįįts'ą' nats'ahts'ą' dee'ya' datthak, nijuk datthak giiyeeginkhii geh'an. Dinjii lat nąįį, “John, chųų gwats'an ąhtsii, niindhat gwats'an khakee'ąįį geh'an gwigwee'in geenjit vat'aii gwanlii t'ii'in.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Goolat nąįį chan googaa nihk'it Elijah Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii t'inchy'aa, ąįįts'ą' ch'izhii nąįį chan yeenaa dąį' gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ch'ihłak, t'inchy'aa.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nijin Herod gwiitth'ak dąį' jyaa nyąą, “John chųų gwats'an ąhtsii, viki' k'eech'iit'uu gaa neegwiindaii lee t'inchy'aa!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod, dachaa Philip, ąįį va'at Herodias noonjik ąįį jyaa yahnyąą, ąįį geh'an John digiłchaa ts'ą' zheegwaazhrąįį nigiiyąąhchįį gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John, chųų gwats'an ąhtsii, ąįį Herod łyaa gwintł'oo khandeegwii'ąįį, “Nachaa, va'at noodhinjik, ąįį dii-Law łaahnaii t'ini'in!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ąįį geh'an, Herodias yits'į' t'inchy'aa ts'ą' yęhdaa tr'agoo'aa gwizhrįh yiindhan gaa, khyų' gwik'it t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod, łyaa John gwiizųų vats'a' t'igweheenjyaa gwits'į' vak'ąąhtii, dinjii nizįį ts'ą' shroodiinyąą nilii yaandaii ts'ą' łahchy'aa yaanjat. Ts'ą' nijin yiitth'ak dąį' łyaa deehee'yaa gaandaii kwaa gaa yuułk'įį geet'indhan. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodias, John ęhdaa tr'igwihee'aa eenjit vaa gwik'it nagwaanąįį. Herod vagoodlit drin nigwiindhat, ts'ą' vitsyaa kįh dilk'ii nąįį, ts'ą' niveet'ah'in kįh dilk'ii nąįį ts'ą' Galilee nahkat gwats'an kįh giilk'ii nąįį datthak haa ch'ara'aa gwahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias vigii nich'it nihdeiinzhii ts'ą' gooveenjit ch'ildzyaa. Herod ąįįts'ą' zhit juu gooveenjit ch'a'aa gwahtsii, datthak łyaa gwintł'oo shoo iłtsąįį, ts'ąįį King ąįį nich'it t'ahnyąą, “Jidii shi'įį datthak tee jidii niindhan? Jidii nindhan datthak nats'an hałtsyaa! ");
INSERT INTO gwiNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Łahchy'aa łi'deegwidlii zhit jidii indhan, nats'an hałtsyaa t'ihnyąą, jidii datthak ts'ą' k'eedeegwaldhat, ąįį teetł'an ji' gaa nats'an hałtsyaa t'ihnyąą!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ąįįts'ą' t'ee nich'it cheehoozhii ts'ą' dahan oahkat, “Jidii geenjit ch'oohałkat?” dahan ahnyąą. “Juk zhat John chųų gwats'an ąhtsii ąįį viki', nihthan diinyąą!” vahan yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ąįį nich'it, zhat gwagwahkhan oo'an neehoozhii ts'ą' King, t'ahnyąą. “Dzaa, juk zhat, John chųų gwats'an ąhtsii, viki' k'ik kat deedhin'ąįį ts'ą' shantł'eiin'ąįį!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jii deeyahnyąą, King łyaa, geenjit gwintł'oo tr'igwidii, gaa juu nąįį yaa (potlatch) ch'a'aa ąhtsii, nąįį andah diginjik gwintł'eiin'ąįį ts'ą' duuyeh deenyąą diginjik akhoonyąą gaandaii, ");
INSERT INTO gwiNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ts'ą' niveet'ah'in jyaa dahnyąą, juk zhat oo'an hiinkhaii ts'ą' John, viki' oo'ee niin'ąįį. Ąįįts'ą' t'ee niveet'ah'in, zheh gwaazhrąįį gwats'ą' haazhii ts'ą' John viki' k'eech'iint'uu. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ąįįtł'ęę k'ik kat deeyaa'aii ts'ą' nich'it antł'eeyin'ąįį, ts'ą' adan chan dahan antł'eeyiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nijin John vitsyaa gwigwiitth'ak dąį', gwats'ą' gahaajil ts'ą' giich'ichį' goonjik ts'ą' gihłeegahoojil ts'ą' giinąąhjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ąįį Tr'ihił'e' nąįį oo'ee neegeejil dąį' nats'ahts'ą' geech'ǫąąhtan, ts'ą' deegee'ya' datthak Jesus haa googwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Zhat łyaa tr'ihkhit dinjii nąįį gwanlii ts'ą' dinjii nąįį lęįį zhat nineedal ts'ą' Jesus, ditsyaa haa ch'igihee'aa geenjit gaa gooveenjit nagwaaghyii kwaa geh'an Jesus jyaa gavahnyąą “Neehoozhii geenjit, t'ohłii gwa'an tthan goo'aii diikhwan zhrįh gwats'ą' tr'ahoojyaa,” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ąįįts'ą' tr'ihchoh zhit geedan zhrįh gwizhit giinjil ts'ą' t'ohłii tthan goo'aii gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Gaa dinjii, lęįį nąįį, t'ohłii neegehiinjyaa googah'ya', ts'ą' zhat gwagwahkhan juu t'igiinchy'aa gavaagiindaii, ąįį zhit kwaiik'it gwa'an gwats'an, dinjii nąįį datthak, zhit nankat goodivee galgihiłjil ts'ą' nijin Jesus ts'ą' ditsyaa nąįį haa gwats'ą' geedaa izhit goovehkii k'eegiidal. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nijin Jesus, zhat teedhizhii dąį', dinjii nąįį lęįį łeeljil nah'in ąįįts'ą' didrii zhit gooveenjit tr'igwidii ts'ą' divii nąįį divii k'ąąhtii gii'įį kwaa k'it gaveegoo'aii k'it t'igiinchy'aa geh'an, ąįįts'ą' gwandak nihłehjuk t'iichy'aa haa geegoovąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nijin drin zhat neech'ee'aa dąį' vitsyaa nąįį giits'ą' haajil ts'ą' jyaa giiyahnyąą, “Dzaa gwa'an łyaa tr'ihkhit tthan goo'aii, ts'ą' it'ee khaa tǫǫ gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jii dinjii nąįį dzaa geeghaih gwa'an juu gwanzhįh nahshii gwich'įį nąįį ts'ą' zhit juu kwaiik'it gwatsal gwich'įį nąįį ts'ą' hohjyaa ts'ą' goots'an shih ideenjit ohkwat goovaihnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","“Nakhwan nakhwakhai' jidii gihee'aa gavantł'ohtsit,” Jesus, gavaiinyąą. “Laraa 200 denarius agwahtsii łųhchy'aa tr'ooheekwat ts'ą' gooch'arahah'aa?” vitsyaa nąįį yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","“Łųhchy'aa daanchy'aa khwa'įį? Zhik gwa'an gooh'in.” Jesus gavahnyąą. “Łųhchy'aa ch'ihłoanli' ts'ą' łuk dhichy'aa neekwaii haa tr'ii'įį.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ąįįtł'ęę Jesus, ditsyaa nąįį t'ahnyąą, “Jii dinjii nąįį datthak an-nihłik gwa'an tł'oo chyah nahshii kat nihłaa gahaaky'aa goovohtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ąįįts'ą', dinjii nąįį 100 akwat 50 agaanchy'aa ts'ą' an-nihłik gwa'an nihłaa giilk'ii. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ąįįtł'ęę Jesus, zhit łųhchy'aa ch'ihłoanli' (5) ts'ą' łuk neekwaii haa tee gwiłjik ąįįts'ą' zheekat k'iidak gwąąh'in ts'ą' Vit'eegwijyąhchy'aa “Mahsį' choh!” ahnyąą. Ąįįtł'ęę łųhchy'aa kwaii khadinzhuu ts'ą' ditsyaa nąįį antł'eeyinlii, gwitee giiyeeheelyaa eenjit. Łuk kwaii chan gwik'it t'inlik ts'ą' gwitee giiyiłtsit. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Juu nąįį datthak ch'anahoo'al. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ąįįtł'ęę, vitsyaa nąįį tł'oo tyah choh zhit 12 aanchy'aa tr'ooniindhat tineegwigwįłjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Izhit dąį', dinjii 5000 aanchy'aa nąįį ach'ah'al. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ąįįtł'ęę gwagwahkhan Jesus, ditsyaa nąįį tr'ihchoo zhit inlii ts'ą' giiyehkii van ndųhts'ąįį Bethsaida kwaiik'it gwats'ą' gahahjil gooviłtsąįį. Adan zhat dhidii gwiizhit dinjii łeeljil nąįį nakhwazheh gwits'ee khwajyaa goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ąįįtł'ęę dinjii nąįį datthak neenahal'yaa ahnyąą ts'ą' goołeehoozhii ąįįtł'ęę taih kat gwats'ą' haazhii, ideenjit khagideedi'. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nijin zhat khaa nagwaanąįį dąį' tr'ihchoh tth'aii hee vantł'an dhitin, gwiizhit Jesus tth'aii hee adan zhrįh nankat dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ahtr'aii niint'aii haa goodahtr'aii geh'an, ditsyaa nąįį tr'ihchoh zhit gwint'aii tąą'ąįį haa chųų kat geekwaa goovąąh'in. Zhyaa gootak tr'iheehaa indhan. Vanh dąį' hee 3 AM ts'ą' 6 AM gwideetak gweedhaa gwiizhit Jesus ditsyaa nąįį chųų kat goots'ą' ahaa nigiiyiił'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Gaa nijin chųų kat ahaa nigiiyiił'in dąį', ch'anky'aa t'ii'in giindhan ts'ą' khashraagiintrat, ");
INSERT INTO gwiNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gąąnjat nagaanaii geh'an. Jesus zhat gwagwahkhan goots'ą' khagiinkhee, “Shįį t'ihchy'aa! Nakhwat'aii gwanlii haa noojat shrǫ'!” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ts'ą' tr'ihchoh zhiinzhii ts'ą' ahtr'aii kwaa nagwaanąįį. Vitsyaa nąįį geegagoolii kwaa gooveenjit t'igwiizhik, ");
INSERT INTO gwiNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesus, dinjii 5,000 nąįį achah'al dąį' deegwii'in t'igwii'in gaagiindaii kwaa geh'an. Gooyinji' zhit deegwii'in t'igwii'in khyų' gogoonjii. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Van deetaa neegiinjil ts'ą' Gennesaret kwaiik'it k'eegiidal ts'ą' tr'ihchoh digiłchaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ąįįts'ą' it'ee tr'ihchoh ihłeegihiijyaa gwiizhit dinjii nąįį Jesus juu t'inchy'aa giiky'anjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ts'ą' zhat gwa'an kwaiik'it goodlii datthak gwitee gahaajil ts'ą' dinjii iłts'ik nąįį dehk'it chyah nilii kat deegoogiinlii ts'ą' nijin dhidii gwinyąą gwigwiitth'ak ąįį gwats'ą' googahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ts'ą' Jesus zhat gwa'an, kwaiik'it gwatsal, akwat kwaiik'it gwachoo, ąįįts'ą' nijin dinjii nąįį gwanzhįh gąąhshii, kwaii datthak gwitee neehidik. Dinjii nąįį kwaiik'it gwatł'an dinjii iłts'ik nąįį nigiinlii, ąįįts'ą' giich'oodiikwat, “Ni'ik eelin kat ji' gaa narahaandal shrǫǫ!” giiyahnyąą. Dinjii juu yakat naanjik nąįį datthak shrineegaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ąįį Pharisee lat nąįį ts'ą' Law eech'ǫąąhtan lat nąįį haa Jerusalem gwats'an k'eegiidal ts'ą' Jesus, eelin łigeeljil. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Izhit dąį', Jesus vitsyaa lat nąįį daganli' k'eech'agahtryaa kwaa ts'ą' ch'aga'aa gwagwah'in, ąįį Pharisee nąįį nats'ahts'ą' diinanli' k'eech'arahahtryaa gwik'it daganli' k'eech'agahtryaa kwaa geh'an t'agoogahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pharisee nąįį ts'ą', ch'izhii Jews nąįį haa yeenii gootsii nąįį deegee'ya' ąįį gwik'it t'igii'in t'agoogahnyąą. Daganli' gwinzii k'eech'agahtryaa ąįįtł'ęę gwizhrįh ch'aga'aa t'igii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ąįįts'ą' chan ch'arookwat zheh gwats'an shih gookwat dąį' ąįį giik'eech'ahtryaa ąįįtł'ęę t'ohju' hee giiya'aa. Chųų tyah, tyah vizhit gwik'eech'arahchy'aa, (copper) k'ik ghoo vizhit ch'ara'aa, ąįįts'ą' dehk'it vakat tr'iłchųų, jii kwaii datthak, nats'ahts'ą' giik'eech'ahahtryaa goo'aii gwik'it t'igii'in ąįįtł'ęę gwizhrįh giit'aahchy'aa, jyąhts'ą' geh'an deegihee'yaa goo'aii gwinlęįį gwigwii'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","“Jaghaii nitsyaa nąįį, diitsii nąįį geech'agoahchya', ąįį gwik'it t'igii'in kwaa daganli' shroodiinyąą gahahtsyaa geenjit k'eech'agahtryaa kwaa?” Pharisee, ąįįts'ą' Law eech'ǫąąhtan nąįį haa Jesus goahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus goodii khaginkhee, “Isaiah Vit'eegwijyąhchy'aa Eenjit Ginkhii, deekhwa'yaa nakhwahnyąą łi'deegwidlii haa ch'adąąntł'oo łee. Gwik'injiighit adaa'įį nąįį! Isaiah jii jyaa nyąą, ‘Jii dinjii nąįį digiginjik, haa deeshigihił'ee, gaa goodrii łahchy'aa shats'ą' niighit dha'aii t'iginchy'aa.’ Vit'eegwijyąhchy'aa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ąįįts'ą' shats'ą' khagidiinjii kwaa ji' ts'ąįį gweheezyaa, dzaa nankat dinjii deenyąą ky'aa gwizhrįh geech'agoahtan geh'an. Ąįį shįį sha-law t'inchy'aa k'it gagoonjii.’” ");
INSERT INTO gwiNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ts'ą' Jesus, t'agavahnyąą, “Datthak ts'ą' Vit'eegwijyąhchy'aa va-law k'eegohthat kwaa gaa dzaa nankat dinjii geech'ǫąąhtan ąįį zhit ts'ąįį gwik'eegǫhthat.” ");
INSERT INTO gwiNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus tth'aii hee goots'ą' ginkhii, “Ninjigwaazhii haa Vit'eegwijyąhchy'aa va-law deenyąą ąįį gwik'eegǫhthat kwaa gaa law veech'oohtan, ąįį nakhwakhai' ohtsii t'ohnyąą goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses, va-law kat jyaa digwinyąą, ‘Nakhwati', ts'ą' nakhwahan haa, yinjiihkhadhoh'ee!’ gwinyąą, gaa nahan ts'ą' niti' haa ts'ą' gwiizųų ginkhii ji' nakhwęhdaa tr'igwigwehee'aa goo'aii.’ ");
INSERT INTO gwiNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Gaa nakhwan geech'oohtan dąį', dinjii, dahan ąįįts'ą' diti' ts'iheenjyaa eenjit k'eegwiichy'aa gwii'įį ji' gaa jii ‘Corban t'inchy'aa.’ nyąą ji', (Corban, t'ee jii Vit'eegwijyąhchy'aa vats'an t'inchy'aa gwinyąą t'igwinyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Gaa nakhwan ąįį nakhwahan ąįįts'ą' nakhwati' haa ts'ohnyaa gwat'oohchy'aa kwaa dohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jii jyaa dohnyąą haa geech'oohtan ts'ą' ch'izhii dinjii nąįį datthak jyąhts'ą' geegavǫhtan, ąįįts'ą' ch'izhii dinjii nąįį Vit'eegwijyąhchy'aa viginjik zhyaa k'it t'agoonyąą haa goonjii goovohtsii. Jii k'it t'inchy'aa lęįį haa zhyaa nihteegoozhii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ąįįtł'ęę Jesus, chan hee ąįį juu łeeljil nąįį aanaii ahnyąą ts'ą' datthak ts'ą', “Shoodǫǫhk'įį, deegwinyąą t'igwinyąą gahahkhwandaii geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Dinjii jidii vizhit t'injik ąįį shroodiinyąą yahtsii kwaa t'inchy'aa, gaa jidii vizhit gwats'an haadhak, ąįįt'ee shroodiinyąą kwaa yahtsii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'!” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nijin dinjii łeeljil, nąįį iłeehoozhii ts'ą' zheh nihdineezhii dąį' vitsyaa nąįį jidii eegwandak eenjit giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesus t'agoovahnyąą, “Nakhwan gaa zhit ch'izhii dinjii nąįį k'it nakhwagwizhi' kwaa łee? Jii eegiihkhii t'ihnyąą gaakhwandaii? Jidii nakhwazhit t'injik ąįį duuyeh shroodiinyąą kwaa nakhwahtsii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ąįį jidii nakhwazhit t'injik, ąįį nakhwadrii ts'ą' t'injik kwaa gaa nakhwazhrak ts'ą' t'injik ąįįtł'ęę nakhwatthąį' ts'an an ilik.” (Jesus shih tr'a'aa, kwaii datthak tr'ihee'aa eenjit nizįį, nyąą t'inyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","“Jidii nakhwaghit gwats'an haadhak t'ee shroodiinyąą kwaa nakhwahtsii,” tth'aii hee goots'ą' ginkhii ts'ą' Jesus jyaa gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","“Ąįį jidii nakhwats'an tr'aadhak, ąįįt'ee nakhwadrii zhit gwats'an t'igwii'in, ąįį zhit gwats'an tr'agwaanduu zhrįh t'asho'ya' nohthan haa gwiizųų nihłaanagǫh'ąįį ts'ą' ch'oo'įį, chan dinjii ęhdaa tr'agǫh'aa nohthan, ");
INSERT INTO gwiNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","gooveedhidii kwaa haa gaachįį, yee'an dinjii jidii di'įį ąįį chan giindhan ts'ą' jidii tr'agwaanduu datthak googwitr'it gwanlii, dinjii nąįį ts'ą' goots'it, gwiizųų t'igii'in gaa gwadrąįį ninjich'agadhat kwaa, dinjii gwintsii t'ii'in dąį' gitr'igii'ee, dinjii nąįį chan oozhri' iizųų gahtsii, chan khaiinjigihil'ee ts'ą' chan gwahkhii gwitr'it t'agwagwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jii tr'agwaanduu t'akhwa'in datthak nakhwazhit gwats'an tr'ijyaa, ąįįt'ee shroodiinyąą kwaa nakhwahtsii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ąįįtł'ęę Jesus, gihłeehoozhii ts'ą' Tyre kwaiik'it gwachoo geeghaih gwa'an nahkat gwats'ą' haazhii, ąįįts'ą' zheh gwizhit nihdeiinzhii. Zhat dhidii ąįį dinjii nąįį gaandaii gitr'ii'ee. Googaa geegoh'ik heedyaa ąįį veenjit gwakwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tr'injaa ch'ihłak vigii nich'it ąįį vizhit ch'anky'aa iizųų t'inchy'aa łee ts'ą' ąįį tr'injaa, Jesus, zhat dhidii gwiitth'ak gwagwahkhan yats'ą' haazhii ts'ą' yats'ą' nikiigwiintthaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jii tr'injaa, Jews nilii kwaa, nahkat gwachoo Syria gwizhit nahkat gwatsal goo'aii Phoenicia goozhii gwizhit vagoodlit. Ąįį Jesus ts'ą' ch'oodiikwat, “Shigii nich'it vizhit ch'anky'aa iizųų dhidii cheehahchįį,” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Gaa Jesus, jyaa yahnyąą, “Tr'ookit tr'iinin nąįį ach'aroh'aa. Tr'iinin nąįį gooshii łąįį ts'ą' tr'ahaathak ąįį jyaa digwii'in kwaa t'oonchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“K'eegwaadhat! Łąįį nąįį vakat ch'ara'aa t'eh gwats'an tr'iinin nąįį shih neegahjyaa ga'aa t'oonchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ts'ą' Jesus jyaa yahnyąą, “Shik'injiighit ts'ą' jyaa diinyąą geh'an nizheh gwits'ee hindii, nigii nich'it vizhit ch'anky'aa iizųų vats'an tr'iinzhii agwahah'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ąįįts'ą' oo'an neehoozhii, ts'ą' vigii nich'it dehk'it gwakat ndaka'ee, ts'ą' vizhit ch'anky'aa iizųų tr'idiindhat łee ineegwah'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ąįįtł'ęę Jesus, Tyre kwaiik'it gwachoo gwa'an gwats'an gihłeehoozhii tł'ęę Sidon kwaiik'it gwachoo gwatł'an k'iinji' neezhįį Galilee van dha'aii gwats'ą' haazhii, gaa Decapolis nahkat zhit gwa'an łihts'eedhizhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Dinjii lat nąįį, dinjii ch'iitth'ak kwaa ts'ą' viginjik kwaa, giits'ą' nąąhchįį ts'ą' giich'oodiikwat, Jesus vakat naanjii, agahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ąįįts'ą' dinjii gwanlii nąįį tee tr'igiiyąąhchįį ts'ą' geh'at tthan, gwa'an niyąąhchįį ts'ą' dinleetth'ak nihts'įį yidzee zhit gwik'iintthaii, ąįįts'ą' chan haazhree ts'ą' yikyaa kat naanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ąįįtł'ęę zheekat k'iidak gwąąh'in ts'ą' gwint'aii hahchik ts'ą' dinjii t'ahnyąą “Ephphatha,” (T'ee nihky'aa t'agǫǫnjii! Gwinyąą t'igwinyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jyaa nyąą gwagwahkhan vidzee nihky'aa t'igwiizhik ts'ą' ch'iitth'ak ts'ą' gwinzii chan ginkhii neehoodlit. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ąįįtł'ęę, Jesus ch'ihłee gaa geegoohkhyaa shrǫ' dinjii nąįį ahnyąą, gaa deegwahtł'oo jyaa dohnyąą shrǫ' goovahnyąą, gwagwahtł'oo łąą geegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Juu gwiitth'ak nąįį gooveenjit gwintł'oo geegwagoolii kwaa t'igwiizhik, “K'eegwiichy'aa datthak gwinzii t'ii'in giiyahnyąą,” gwint'aii giginkhii haa! “Dinjii ch'iitth'ak kwaa gaa ch'iitth'ak nahtsii ts'ą' dinjii viginjik kwaa, gaa ginjik di'įį nahtsii,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Izhit gwats'an niighyuk gwahaadhat kwaa ts'ą' chan hee dinjii nąįį łineeljil. Izhik dąį' dinjii nąįį, shih giihee'aa gii'įį kwaa nagwaanąįį, ts'ą' Jesus ditsyaa, nąįį aanaii ahnyąą ts'ą' jyaa gavahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Jii dinjii nąįį, łyaa giveenjit tr'igwihdii, juk t'ee drin tik shaa t'igiinchy'aa, ts'ą' gihee'aa gii'įį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Goolat nąįį łyaa niighit gwats'an geedaa ts'ą' nakhwazheh gwits'ee khwajyaa gavaihnyąą ji' ch'aga'aa kwaa geh'an k'ii'an neegeedaa gwizhit duulee oo'an t'ee gahaadhal.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Vitsyaa nąįį giiyųąhkat, “Dzaa nangwinjir gwa'an nijin gwats'an shih tr'ooheendal ts'ą' jii dinjii lęįį nąįį gooch'arahah'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Łųhchy'aa daanchy'aa akhwa'įį?” nyąą ts'ą' Jesus gavahkat. “Łųhchy'aa 7 tr'ii'įį.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nankat gwa'an dook'įį dinjii łeeljil, nąįį ahnyąą. Ąįįtł'ęę łųhchy'aa 7 oonjik ts'ą' Vit'eegwijyąhchy'aa mahsį' yeenjit nyąą, tł'ęę nihtr'ayaazhuu ts'ą' ditsyaa nąįį antł'eeyiinlii, ants'ą' dinjii nąįį tee giiyaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ąįįts'ą' chan łuk chy'ah tsal lat chan gii'įį. Jesus Vit'eegwijyąhchy'aa mahsį' yeenjit nyąą ts'ą' ditsyaa nąįį jii chan goovantł'ohtsit gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Dinjii 4,000 nąįį deegwahtł'oo ch'aroo'aa giindhan gwik'it ch'igin'al. Ąįįtł'ęę vitsyaa nąįį, 7 tł'ootyah, zhit deedaan'ąįį tr'ooniindhat tineegwigwįłjik. Ąįįtł'ęę Jesus, dinjii nąįį oo'an nakhwazheh gwits'eekhwajyaa goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ąįįtł'ęę gwagwahkhan, ditsyaa nąįį haa tr'ihchoh zhit neezhįį ts'ą' Dalmanutha, nahkat gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee nąįį giits'ą' haajil ts'ą' giizheedaa'ee, “Zheekat gwats'an gwigwii'in diits'ą' gwagwaakįį,” goodhaiinarookhii giiyuunyąą eenjit jyaa giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Gaa Jesus, veenjit gitr'igwii'ee, haa gwint'aii khaazhee ts'ą' jyaa nyąą, “Jaghaii zhyaa juk gweendaa dinjii ǫhłįį ts'ą' gwigwee'in gach'oohkat? Nakhwaagwaldak, duuyeh jii dinjii ǫhłįį ts'ą' jyaa doonchy'aa nakhwats'ą' gwagwaałkįį t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Goołeehoozhii ts'ą' tr'ihchoh zhit neezhįį ąįįtł'ęę van ndųhts'ąįį ditsyaa nąįį haa gwits'eehidii. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Vitsyaa nąįį łųhchy'aa giit'ahaachy'aa aanchy'aa goohoondal gineegildee, ąįįts'ą' łųhchy'aa ch'ihłak zhrįh gii'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus goots'ą' nich'idiin'ąįį, “Dak'oontii, Pharisee nąįį, ąįįts'ą' Herod Antipas nąįį haa goots'į' adak'ǫǫntii, łųhchy'aa zhit łųh niituu k'it t'igiinchy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nihłihtee giginkhii, ts'ą' vitsyaa nąįį jyaa nihłagaanyąą. “Łųhchy'aa tr'ii'įį kwaa geh'an jyaa nyąą t'inyąą,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesus, deeginyąą gavaandaii ts'ą' gavaahkat, “Jaghaii zhyaa łųhchy'aa tr'ii'įį kwaa eenjit nihłihtee gookhii? Nik'ee juk deegwinyąą gaakhwandaii? Zhyaa deegwahtł'oo nakhwayinji' neeshraahchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nik'ee chan ganoondaii? Nakhwandee gwanlii ji' nik'ee gooh'in? Nakhwadzee gwanlii ji' nik'ee chan ch'ootth'ok?” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","“Nijin łųhchy'aa 5 khandidhiizhuu dąį' dinjii 5,000 nąįį eenjit t'ishizhik łųhchy'aa tł'ootyah zhit daanchy'aa tr'ooniindhat?” “Tł'ootyah 12.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ąįįts'ą' chan łųhchy'aa 7, dinjii 4,000 eenjit khandidhiizhuu dąį', tł'ootyah zhit daanchy'aa tr'ooniindhat?” Jesus gavahnyąą. “Tł'ootyah 7.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Gwiizhit tth'aii hee deegwinyąą t'igwinyąą gaakhwandaii kwaa?” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Bethsaida kwaiik'it, k'eegiidal dąį', dinjii vandee kwaa Jesus ts'ą' giihiłchįį ts'ą' vakat naanjii giiyahnyąą, haa giits'ą' ch'oodiikwat. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus, ąįį dinjii vandee kwaa anli' oonjik ts'ą' kwaiik'it geh'at gwa'an gwats'ą' yihiłchįį. Yindee kat haa zhrik ąįįtł'ęę Jesus danli' haa yindee kat naanjik. “Nik'ee k'eegwiichy'aa gwąąh'in?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ąįį dinjii oodak yąąh'in ts'ą' t'iiyahnyąą, “Aahą', dinjii nąįį nał'in, gaa ts'iivii zhit gwa'an neehiidal k'it t'igii'in.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesus, chan hee dinjii andee kat nanaanjik, akhai' gwint'aii aakin gwaa'įį naanaii ts'ą' gwandaa gwinzii gwąąh'in needhidlit ts'ą' nijuk datthak gwinzii vaagweech'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ąįįtł'ęę Jesus, yizheh gwits'ee yihił'e' ts'ą', “Zhit kwaiik'it gwits'ee noozhi' shrǫ'!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ąįįtł'ęę Jesus, ts'ą' ditsyaa nąįį haa Caesarea Philippi kwaiik'it gwachoo gwa'an kwaiik'it gwatsal goodlii gwats'ą' gahaajil. Gwats'ą' geedaa gwiizhit gavahkat, “Dinjii nąįį juu ihłii shagahnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Vitsyaa nąįį t'iiyahnyąą, “Goolat nąįį, John chųų gwats'an ąhtsii, nagahnyąą. Ch'izhii nąįį chan Elijah inlii, nagahnyąą. Ąįįts'ą' ch'izhii nąįį chan Vit'eegwijyąhchy'aa Eenjit Ginkhii ch'ihłak inlii, nagahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Nakhwan ąįį yu'? Juu ihłii shoonyąą?” nyąą, ts'ą' gavahkat. “Christ inlii!” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","“Ch'ihłak gaa juu t'ihchy'aa haa goondak shrǫ'!” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ąįįtł'ęę zhazhat Jesus, ditsyaa nąįį geehiiłchya', “Zhit Israel kįh dilk'ii nąįį, giinkhih kįh dilk'ii nąįį, ąįįts'ą' chan juu Law eech'ǫąąhtan nąįį jii nąįį shįį Gwidinji' ihłii gwik'injigeheeghit kwaa ts'ą' khaiinjich'ishagahahthat ts'ą' shagahaahkhwaa, ąįįtł'ęę googaa, drin tik gwahaadhat ąįįtł'ęę neegwihiindaii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Gwinzii deegwinyąą gwigweheetth'ak gwiky'aa goovaagwandak. Googaa, Peter tthan niyąąhchįį ts'ą' gwagwahkhan ginjik nint'aii haa yits'ą' ginkhii, “Jyąhts'ą' ginkhii kwaa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Gaa Jesus łihts'eediil'ee ts'ą' ditsyaa nąįį nah'in, gwiizhit Peter ts'ą' gwint'aii khaginkhee, “Satan, shihł'eehindii! Nats'ahts'ą' ninjich'indhat Vit'eegwijyąhchy'aa vats'an t'oonchy'aa kwaa gaa dinjii ts'an t'oonchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ąįįts'ą' Jesus, dinjii zhat łeeljil nąįį ts'ą' ditsyaa nąįį haa aanaii ahnyąą ts'ą' t'agoovahnyąą, “Nakhwatee gwa'an juu shaa hoozhii niindhan ji' adanaandee ts'ą' nihk'ataa'ee (cross) nakat inchyaa ts'ą' shatąįį hinkhaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Juu gwandaii gwizhit gwizhrįh geenjit ideenjit tr'agwah'in ji' an dahaatsyaa t'inchy'aa. Gaa juu sheenjit ts'ą' Gwandak Nizįį haa gwandaii gwizhit geetr'agwaah'in ji' neeheezhii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dinjii nankat datthak ideenjit goonjik gaa viyinji' an dhidlit ji' ąįį dinjii nihk'it gwats'an gaayiigwahaahtsyaa shrǫǫ? Łyaa duuyeh! ");
INSERT INTO gwiNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Łyaa zhyaa, neegwihiindaii geenjit jidii datthak gwats'an ąhtsii ji' gaa duuyeh gwik'it neegwiindaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Juk gweendaa dinjii nąįį ǫhłįį ts'ą' veedhoodii kwaa haa dhohchųų ts'ą' gootr'agwaanduu gwanlii, shįį ts'ą' shiginjik haa sha'oozhii ǫhłįį t'ee nijin Shiti' vich'eegwąhndit ts'ą' zheekat gwich'in shroodiinyąą nąįį gooveech'eegwąhndit zhit shįį Gwidinji' ihłii ts'ą' oo'ee neeshizhii ji' nakhwa'oozhii hahłyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ts'ą' chan t'agoovahnyąą, “Łi'haa nakhwaagwaldak t'ihnyąą, juk nakhwatee nakhwalat nąįį nigiheedhaa gwats'ą' Vit'eegwijyąhchy'aa vat'aii jiintsii haa Veegwinii'ee zhit needyaa gwagwahah'yaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Drin nihk'iitik (6) gwahaadhat tł'ęę, Jesus, Peter, James, ts'ą' John nąįį haa ddhah choo kat tthan goo'aii gwa'an gwats'ą' gavahaadlii. Aakin giiyah'įį gwizhit Jesus gavandah ch'ijuk vigweech'in naanaii, ");
INSERT INTO gwiNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ts'ą' vagwach'aa łyaa ch'ąhndit ts'ą' daagąįį dhidlit. Jii nakat dinjii ch'ihłak gaa deegwahtł'oo yik'eech'ahtryaa ji' gaa duuyeh gwandaa daagąįį yahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ąįįtł'ęę vitsyaa tik nąįį deenaadąį' gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii neekwaii, Elijah ts'ą' Moses haa Jesus ts'ą' giginkhii googwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter, Jesus jyaa dahnyąą, “Shigeech'ǫąąhtan, dzaa tr'iilk'įį łyaa gwinzii t'igwinchy'aa łee. Trał haa zheh tik gwarahahtsyaa ch'ihłak ąįį neenjit, ch'ihłak chan Moses ąįįts'ą' ch'ihłak chan Elijah.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter ts'ą' ch'izhii nąįį gąąnjat nagaanaii ts'ąįį deeheenjyaa gaa gaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ts'ą' zheek'ǫh goodlii ts'ą' vagwank'oh gookat t'iizhit, gwiizhit gwideezhuh zheek'ǫh gwats'an jyaa nyąą. “Jii t'ee Shidinji' t'inchy'aa, łyaa veet'iihthan t'inchy'aa, oodǫǫhk'įį!” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Gwagwahkhan geelin gwa'an datthak gaa ch'ihłak gaa gaah'in kwaa, gaa Jesus, zhrįh gaah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ąįįtł'ęę ddhah kat gwats'an k'iidąą neegeedaa gwiizhit Jesus jyaa dakhwa'in goovahnyąą, “Dzaa deegwiizhit gǫǫh'ya' ch'ihłak gaa haagoondak shrǫ', Gwidinji' ch'ichį' ts'an neegweheendaii gwats'ą' geegǫǫndak shrǫ'.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Gaa nihłihts'ą' geegiginkhii, ts'ą' nihłigwaakat, “Ch'ichį' gaa neegwiindaii nyąą deenyąą t'inyąą?” Ąįįts'ą' deegavahnyąą gwik'it t'igiinchy'aa ts'ą' giik'eegwahthat. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ąįįtł'ęę vitsyaa nąįį giiyųąhkat, “Jaghaii Law eech'ǫąąhtan nąįį Elijah tr'ookit k'ineeheedik ginyąą t'iginyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jyaa gavahnyąą, “Elijah adan tr'ookit neeheedyaa t'oonchy'aa, datthak shrigweheelyaa ts'ą' tr'iilęįį nigwehee'aa t'inchy'aa. Jaghaii Dęhtły'aa Choh zhit Gwidinji' gwintł'oo khaiinjich'iheedhat ts'ą' giits'į' t'iheechy'aa ts'ą' gwadanakhwatł'oo gwinyąą? ");
INSERT INTO gwiNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nakhwaagwahaldak, łi'haa Elijah ch'adąį' hee k'inidik, ts'ą' dinjii nąįį dooł'ya' giiyuunyąą datthak gwik'it t'igiiyah'ya'. Dęhtły'aa Choh zhit nats'ahts'ą' gwadanakhwatł'oo datthak gwik'it t'igiiyah'ya' t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nijin ch'izhii vitsyaa nąįį dilk'ii gwits'ee gahoojil dąį', dinjii lęįį nąįį, ąįįts'ą' Law eech'ǫąąhtan lat nąįį haa vitsyaa eelin łigeeljil googwąąh'in, ts'ą' nihzheedagąąn'ee łee. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nijin dinjii nąįį Jesus gaah'in dąį', tr'ahaah'yaa łyaa giiyuunyąą kwaa ts'ą' shoo ginlii haa giits'ą' galhiłjil. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Jidii eenjit nihzheedǫǫ'ee?” Jesus gavahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dinjii łeeljil gwitee gwats'an dinjii ch'ihłak jyaa nyąą, “Geech'ǫąąhtan, shidinji' vizhit ch'anky'aa iizųų t'inchy'aa, ts'ą' ginkhii kwaa ąįį veenjit gwinzii neegwahahtsyaa geenjit nats'ą' hoołchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nijin ch'anky'aa iizųų neeyuundak dąį' nankat gwats'ą' t'eehaadhak, ąįįts'ą' viyik gwats'an goghoh tr'aatuu, ts'ą' dagho' chan nihts'ą' oon'al ts'ą' naghwa'aadhak. Nitsyaa nąįį ch'anky'aa iizųų vizhit gwats'ąnh gihłeehohchįį gavaihnyąą gaa khyų' t'igii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus ditsyaa nąįį jyaa dahnyąą, “Łyaa nakhwagwik'injigwiighit kwaa łee shakhwandaii nahoihnyąą! Deegwąhkhyuk zhyaa nakhwaa t'ihihchy'aa shoohnyąą? Ąįį chyaatsal dzaa shats'ą' hohchįį!” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jesus ts'ą' nigiiyąąhchįį, ch'anky'aa iizųų Jesus niił'in gwagwahkhan tsyaa tsal gwint'aii daatrat iłtsąįį ts'ą' nankat nat'aanąįį ts'ą' neekhiital gwiizhit goghoh viyik gwats'an tr'aatuu. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","“Deegwąhkhyuk jyaa dinchy'aa?” Jesus yiti' oahkat. “Tr'iinin tsal, nilii dąį' gwats'an jyaa dinchy'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yęhdaa tr'igwihee'aa eenjit ch'anky'aa iizųų gwinlęįį kǫ' ts'ą' chųų zhit t'eeyahahthal gwik'eegwandaii. Khan gwik'it ni'yaa ji' neeshraahchy'aa diinoiinyaa ts'ą' diits'inyaa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Aahą', nakhwan gaa nakhweenjit gach'agwadhan t'oonchy'aa! Dinjii gwik'injiighit dąį', jidii datthak veenjit gach'agwadhan t'oonchy'aa.” Jesus nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Viti' zhat gwagwahkhan khashraa'iintrat, “Gwik'injihkhit, gaa jyaa dagwahtł'oo gwik'injihkhit kwaa t'oonchy'aa, gwandaa gwik'injihihkhit eenjit shits'iinyąą!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ts'ą' nijin Jesus dinjii lęįį łeeljil nąįį zhat gooveelin nijyaa nigweeł'in dąį' ch'anky'aa iizųų ts'ą' gwint'aii khaginkhee, “Ch'anky'aa ch'iitth'ak kwaa ts'ą' viginjik kwaa inlii, jii tsyaa tsal vizhit tr'iinkhaii ts'ą' chan ch'ihłok gaa vizhit neenoozhit shrǫ'!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ch'anky'aa iizųų, gwat'aii azhral ts'ą' tsyaa tsal gwilęįį neet'eehaadhak ts'ą' daatrat yiłtsąįį ąįįtł'ęę yats'an khaiinzhii. Ąįį tsyaa tsal niindhat k'it viyiichy'aa, ts'ą' “Niindhat t'inchy'aa!” datthak giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Googaa, Jesus, tsyaa tsal anli' oonjik ts'ą' ndak ninęęyiłkhin ąįįts'ą' ndak nadhat yiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ąįįtł'ęę nijin Jesus zheh nihdeiinzhii dąį', ąįį zhit gwizhit tthan goo'aii vitsyaa nąįį giiyųąhkat, “Jaghaii diikhwan khyų' ch'anky'aa iizųų, kharahchįį?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ts'ą' t'agoovahnyąą, “Geeghaih nakwaa, ts'ą' jii ch'anky'aa iizųų k'it t'inchy'aa t'ee khadigiriinjii haa gwizhrįh kharahchik t'inchy'aa.” Jesus nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesus ts'ą' ditsyaa nąįį haa zhat gwats'an gihłeegahoojil ts'ą' Galilee gwideetaa nigiinjil. Jesus nijin dhidii dinjii nąįį yaandaii geet'iindhan kwaa, ");
INSERT INTO gwiNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ditsyaa nąįį gǫąąhtan geh'an jyaa goovahnyąą, “Gwidinji' tr'ahaahkhwaa geenjit dinjii nąįį antł'eegiihahchyaa ts'ą' drin tik gwahaadhat ąįįtł'ęę neegweheendaii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gaa jii geech'ǫąąhtan deegwinyąą t'igwinyąą gaagiindaii kwaa, ąįįts'ą' chan giiyuuhaahkat eenjit gatr'agogwaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum kwaiik'it k'eegiidal, ts'ą' zheh nihdeegiinjil tł'ęę Jesus, ditsyaa nąįį oahkat, “Nijin k'ii'ee tąįį gwinjik tr'eedaa dąį', jidii eegoohkhii t'oohnyąą?” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Gaa giidii ginkhe' kwaa geh'an nijin k'ii'ee tąįį gwinjik geedaa dąį' nihzheedagąąn'ee ts'ą' “Juu ch'andaa hil'ee?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus naadii ts'ą' ditsyaa 12 nąįį aanaii t'ahnyąą, “Juu adan tr'ookit oihłi' yiindhan ji' dinjii tee datthak khazhak nadahaachyaa tł'ęę ji' gwizhrįh tr'ookit heelyaa, ąįįts'ą' juu nąįį datthak eenjit gwitr'it t'agwahah'yaa gwizhrįh ąįįtł'ęę tr'ookit veegwehee'aa t'oonchy'aa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Tr'iinin tsal oonjik ts'ą' goots'ą' nąąhchįį, ts'ą' goots'ą' nadhat gwiizhit danli' haa yeelin needhanjik ts'ą' t'agavahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Juu tr'iinin tsal shoozhri' zhit shoo nilii haa oonjik t'ee shįį chan sheenjit shoo nilii t'oonchy'aa. Juu sheenjit shoo nilii t'ee shįį zhrįh sheenjit shoo nilii kwaa gaa zhit juu dzaa gwats'ą' shihił'e' chan eenjit shoo nilii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John, jyaa yahnyąą, “Geech'ǫąąhtan, dinjii ch'ihłak noozhri' zhit ch'anky'aa iizųų dinjii ts'an gihłeehiłchįį tr'ąąh'ya' ts'ą' jyaa ni'in kwaa varahnyąą, diitee gwats'an nilii kwaa geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Gaa Jesus t'iiyahnyąą, “Jyaa dakhwa'in kwaa, vohnyą' shrǫ', juu shoozhri' zhit gwigwee'in t'agwah'in zhat gwagwahkhan duuyeh k'eegwiichy'aa tr'agwaanduu shats'ą' t'ii'in t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Juu diits'ą' nich'itsahthat kwaa, ąįįt'ee diineenjit nadhat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jii t'ee łyaa nakhwaagwaldak t'ihnyąą, juu Christ vats'an ǫhłįį geh'an chųų nakhwantł'eiinkaii, jidii tsal gaiiyiigwigwiłtsąįį łyaa goots'an heelyaa.” Jesus goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Jii tr'iinin k'it t'inchy'aa shik'injiighit ąįį juu tr'agwaanduu t'ii'in yahtsii ji', ąįį juu jyaa dii'in yahtsii vak'oh chan kii choo diriłchaa ts'ą' chųų choh kat oondaa t'eerihiiłnaii ji' ts'ąįį gwandaa vidivee gweheezyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ąįįts'ą' nanli' tr'agwaanduu t'ini'in nahtsii ji' vik'eech'iint'ii! Nanli' ch'ihłak kwaa haa gwandaii ndaanąą'ąį' kwaa gwats'ą' hoiizhii ts'ąįį gwinzii. Izhit kwaa ji' nanli' neekwaii gwanlii haa hell gwizhit kǫ' nikyaa kwaa zhit hinkhaii ąįį zhit ts'ąįį gwiizųų. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Izhit gwizhit gyųų khit ninghit kwaa ts'ą' gwatthąį' a'aa, ts'ą' kǫ' ak'an ts'ą' nikyaa kwaa!) ");
INSERT INTO gwiNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ąįįts'ą' nakwai' tr'agwaanduu t'ini'in nahtsii ji' vik'eech'iint'ii! Nakwai' ch'ihłak kwaa haa gwandaii ndaanąą'ąį' kwaa gwats'ą' hoiizhii ts'ąįį gwinzii. Izhit kwaa ji' nakwai' neekwaii gwanlii haa hell gwizhit t'ee naraahkhii aiizhit ts'ąįį gwiizųų. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Izhit gwizhit gyųų khit ninghit kwaa ts'ą' gwatthąį' a'aa, ts'ą' kǫ' ak'an ts'ą' nikyaa kwaa!) ");
INSERT INTO gwiNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ąįįts'ą' t'ee nandee tr'agwaanduu t'ini'in nahtsii ji' khaiin'ąįį ts'ą' oo'an haahkhii! Nandee ch'ihłak haa Vit'eegwijyąhchy'aa Veegwinii'ee nihdeiinkhaii ts'ąįį gwinzii, nandee neekwaii gwanlii haa hell gwizhit t'ee naraahkhii aiizhit ts'ąįį gwiizųų. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","(Izhit gwizhit gyųų khit ninghit kwaa ts'ą' gwatthąį' a'aa, ts'ą' kǫ' ak'an ts'ą' nikyaa kwaa!) ");
INSERT INTO gwiNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Juu nąįį datthak kǫ' haa shroodiinyąą heelyaa, nilii iizųų heelyaa gwits'į' vakat lisil deeranjal ąįį gwik'it Vit'eegwijyąhchy'aa vats'a' ataiinjiirahtsii k'it t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lisil, shih kat deeranjal dąį' gwinzii vagwandaii gwik'it nakhwant'ee nakhwanee'ok dinjii nąįį ts'ą' ohtsii ts'ą' tsinehdan zhit nihłaa gǫhdaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ąįįtł'ęę zhat gwats'an gihłeehoozhii ts'ą' Judea nahkat gwats'ą' haazhii, ts'ą' Jordan han ndųhts'ąįį niinzhii. Chan hee dinjii lęįį vaa łineeljil ts'ą' gweedhaa datthak geegoovąąhtan gwik'it chan hee geegoovąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee lat nąįį giits'ą' haajil ts'ą' goodhaii nigiihaahthal geenjit giiyųąhkat, “Diihaa gwandak, jii dii-law zhit dinjii khan da'at akhooheenjyaa lee t'oonchy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","“Moses va-law nakhwantł'eiin'ąįį zhit deekhwa'yaa nakhwarahnyąą?” nyąą ts'ą' Jesus gavaahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Dinjii, da'at akhahoonjyaa geenjit dęhtły'aa diheentł'oo ąįįtł'ęę da'at antł'eeyahahchal, Moses va-law kat jyaa digwinyąą t'oonchy'aa.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","“Geenakhwaraahtan geenjit nakhwaa googwantrii ts'ą' nakhwakiitth'an dach'at geh'an Moses jii law nakhweenjit daantł'oo.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gaa tr'ookit dąį' Vit'eegwijyąhchy'aa jii nan datthak iltsąįį dąį' Dęhtły'aa Choh zhit jyaa digwinyąą, ‘Vit'eegwijyąhchy'aa dinjii ts'ą' tr'injaa haa iłtsąįį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jyąhts'ą' geh'an zhit dinjii, dahan ts'ą' diti' haa ihłeeheehaa ts'ą' da'at haa t'iheechy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ąįįts'ą' jii neekwaii nąįį ch'ihłak giheelyaa.’ Juk gwats'an neekwaii giheelyaa kwaa gaa ch'ihłak zhrįh giheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Vit'eegwijyąhchy'aa nihłaa nagoovahchįį geh'an dinjii ch'ihłak gaa nihts'an tr'agoogahahchyaa kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nijin zheh nihdineegeejil dąį' jii Jesus deihnyą' eenjit vitsyaa nąįį giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ąįįts'ą' jyaa gavahnyąą, “Juu dinjii, da'at akhoonyąą ts'ą' ch'izhii tr'injaa noonjik ji' ąįį dinjii, da'at ts'ą' adultery t'ii'in t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ąįį gwik'it, juu tr'injaa, dakai' akhoonyąą ts'ą' ch'izhii dinjii neeyuunjik ji' ąįį tr'injaa, dakai' ts'ą' adultery t'ii'in t'ii'in.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Dinjii lat tr'iinin tsal nąįį Jesus ts'ą' gahaadlii, gook'aa nahaandal geenjit, gaa vitsyaa nąįį jyaa dakhwa'in kwaa googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gaa nijin jyaa gii'in, Jesus gwąąh'in dąį' vik'įį goodlit ts'ą' ditsyaa nąįį t'ahnyąą, “Tr'iinin shats'ą' hijyaa nąįį, zhyaa goovoh'in, juu tr'iinin k'it t'inchy'aa nąįį t'ee Vit'eegwijyąhchy'aa Veegwinii'ee goots'an nilii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Łyaa nakhwaagwahaldak t'inyąą, juu Vit'eegwijyąhchy'aa Veegwinii'ee, tr'iinin tsal k'it goonjii kwaa ji' duuyeh nihdąhkhaii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ąįįtł'ęę digin haa tr'iinin tsal nąįį eelin nooljik ts'ą' goots'iheenjyaa geenjit gook'aa naanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus gihłeehidii gwiizhik dinjii ch'ihłak yats'ą' naangik ts'ą' yats'ą' nikiigwiintthaii, ąįįtł'ęę yuahkat, “Geech'ǫąąhtan nizįį inlii, gwandaii ndaanąą'ąį' kwaa shi'yaa geenjit deeshi'yaa goo'aii?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","“Jaghaii nizįį shaiinyąą?” Jesus yuahkat. “Ch'ihłak gaa nizįį kwaa gaa Vit'eegwijyąhchy'aa zhrįh nizįį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Moses va-law kat jyaa digwinyąą gaakhwandaii, ‘Dinjii ęhdaa tr'agoiin'aa shrǫ'! Nakąį' akwat na'at nilii kwaa haa oiinchį' shrǫ'! Ch'ǫįį'įį shrǫ'! Ch'izhii dinjii eenjit oonts'it shrǫ'! Ninjigoonzhii shrǫ'! Niti' ts'ą' nahan haa yinjiihooh'ee.’” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Geech'ǫąąhtan, tsyaa tsal ihłii dąį' gwats'an jii datthak gwik'it t'ishi'ya'!” jii dinjii yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesus ch'eet'igwiniindhan haa yindee ts'ą' gwinzii yah'in ts'ą' t'iiyahnyąą, “Jii k'eegwiichy'aa ch'ihłak t'ini'in gwat'aahchy'aa, oo'an nizheh gwits'eehindii ts'ą' nik'eiich'ii datthak laraa t'įį gwantł'eiinlii ąįįtł'ęę, ąįį laraa juu neeshraahchy'aa nąįį antł'eiinlii, jyaa dinizhit ji' zheekat gaiiyiigwahahtsyaa neenjit gwehee'aa. Ąįįtł'ęę shatąįį hinkhaii ts'ą' shitsyaa inlii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nijin ąįį dinjii jii gwiitth'ak dąį', vinin ch'ijuk t'iizhik ts'ą' łyaa valaraa gwanlii geh'an tr'igwidii haa gihłeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ąįįtł'ęę Jesus ditsyaa nąįį tee gwąąh'in ts'ą' jyaa gavahnyąą, “Deegwahtł'oo gwagwantrii li', dinjii valaraa gwanlii Vit'eegwijyąhchy'aa Veegwinii'ee nihdeeheehaa geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Vitsyaa nąįį łyaa geegwagoolii kwaa gooveenjit t'inyąą, gaa Jesus chan hee t'agoovahnyąą, “Shigii nąįį, Vit'eegwijyąhchy'aa Veegwinii'ee nihdeereheedaa geenjit łyaa gwagwantrii t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camel ąįį tthah tsal tł'i'tsii gwinkee heekhaa, ąįį zhit ts'ąįį gwagwantrii kwaa gaa Vit'eegwijyąhchy'aa Veegwinii'ee izhit dinjii valaraa gwanlii nihdeeheehaa, ąįį ts'ąįį łyaa gwagwantrii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jyaa nyąą dąį' vitsyaa nąįį gwandaa gooveenjit geegwagoolii kwaa t'iinyąą, ąįįts'ą' t'inihłagaanyąą, “Akwaa ji' juu dee neeheezhii?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus goovah'in ts'ą' t'agoovahnyąą, “Jii nankat dinjii nąįį eenjit gach'agwadhan kwaa gaa Vit'eegwijyąhchy'aa ąįį jidii datthak veenjit gach'agwadhan t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ąįįtł'ęę, Peter khagiinkhee, “Dzaa gwąąh'in, diikhwan jidii datthak akharoonyąą ts'ą' naa tr'ahaajil ts'ą' nitsyaa tr'aadlit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus t'agavahnyąą, “Aahą', jii datthak geenjit nakhwaagwahaldak, juu dizheh, akwat dachaa akwat dijuu akwat diti' akwat dahan, akwat digii, akwat dagwanzhih dehk'it, kwaii datthak sheenjit, ąįįts'ą' Gwandak Nizįį eenjit datthak akhagoonyąą ji', ");
INSERT INTO gwiNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","juk drin gweedhaa gwizhit gwandaa neegooheendal t'oonchy'aa. 100 gwandaa t'ąąnchy'aa: zheh, dachaa, dijuu, dahan, digii, dagwanzhih dehk'it jii kwaii datthak gwandaa t'agwaanchy'aa neegooheendal ts'ą' chan gwintł'oo sheenjit khaiinjich'igiheeghit gaa ąįįtł'ęę yeendaa ji' gwandaii ndaanąą'ąį' kwaa hee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lęįį nąįį juk tr'ookit nilii ąįį nąįį t'ee ji' khaiinkǫǫ nineegoorahahchyaa gaa yeendaa ji' juu lęįį nąįį juk ji' khaiinkǫǫ dilk'ii nąįį tr'ookit nineegooraheelyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus, ts'ą' ditsyaa nąįį haa taih kat k'iidak Jerusalem gwats'ą' geedaa gwiizhit, Jesus ditsyaa nąįį ts'ii ahaa, ąįįts'ą' vitsyaa nąįį nijuk gwats'ą' geedaa gaagiindaii geh'an gąąnjat, ts'ą' zhit juu gootąįį adaa nąįį chan gąąnjat. Jesus tąįį gwinjik geeghaih gwa'an ditsyaa 12 nąįį khaihłan niinlii ts'ą' chan hee deegiiheelyaa datthak gavaa gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesus t'agoovahnyąą, “Ch'oodǫǫhk'įį, yeedee Jerusalem gwats'ą' tr'iheedaa, izhit t'ee giinkhih kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį haa Gwidinji' gavantł'eehahchyaa. Tr'agwaanduu t'ii'in giihaanjyaa ts'ą' giiyęhdaa tr'igwihee'aa ts'ąįį gwinzii ts'ą' Jews nilii kwaa nąįį giiyęhdaa tr'igwiheedaa geenjit antł'eegiihahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Izhit zhat giiyeeheedlaa, ts'ą' gik'aa gaa heezhree ts'ą' viitrii k'it t'inchy'aa haa giiyahahtrii ąįįtł'ęę giiyęhdaa tr'igwihee'aa. Gaa drin tik gwahaadhat tł'ęę neegweheendaii t'inchy'aa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ąįįtł'ęę, Zebedee vidinji' James ts'ą' John haa Jesus ts'ą' gahaa'oo ts'ą' t'igiiyahnyąą, “Geech'ǫąąhtan, k'eegwiichy'aa geenjit naroohkat gwiindhan.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Nakhweenjit deesho'ya' shohnyąą?” Jesus gavahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ts'ą' t'iginyąą, “Nijin Neegwinii'ee Ch'eegwąhndit nihdeiinzhii ji' k'eedeegwaadhat yakat doodii kat doiindii gwiizhit nishriits'ąįį ts'ą' natł'ohts'ąįį haa tr'oodi'.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus, t'agavahnyąą, “Jidii geenjit ch'oohkat t'ohnyąą gaakhwandaii kwaa. Khaiinjich'ireheeghit gwichųų tyah ts'an chųų shihinjyaa khan akhwanjyaa lee t'oonchy'aa? Nats'ahts'ą' chųų shats'an tr'ahahtsyaa gwik'it khan chųų nakhwats'an tr'ahahtsyaa lee t'oonchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Khan gwik'it t'igwehee'yaa t'oonchy'aa.” giiyahnyąą. Jesus, jyaa gavahnyąą, “Łahchy'aa gwik'it gweheelyaa, jidii chųų tyah zhit chųų shihinjyaa nakhwan chan khahoonjyaa gwizhrįh goo'aii. Ąįįts'ą' chan nats'ahts'ą' khaiinjich'ireheeghit chųų shats'an tr'iłtsąįį gwik'it nakhwan chan chųų nakhwats'an tr'ahahtsyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gaa shishriits'ąįį ts'ą' shatł'ohts'ąįį haa hohdyaa ąįį nakhwantł'eegwihih'aa eenjit gwik'it sheegoo'aii kwaa. Jii t'ee Vit'eegwijyąhchy'aa thok dinjii vats'an heelyaa neekwaii eenjit ch'adąį' hee gwiłtsąįį, ąįį Vit'eegwijyąhchy'aa adan zhrįh gavantł'eegwehee'aa goo'aii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nijin vitsyaa 10 nąįį gwigwiitth'ak dąį', James ts'ą' John haa ts'ą' zhigaants'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ąįįts'ą' Jesus dats'a' nagoovinlii ts'ą' jyaa gavahnyąą, “Zhit juu gwik'injiighit kwaa nąįį t'ee goots'ą' k'eedeegwagwaadhat ts'ą' juu goots'ą' k'eedeegwaadhat nilii t'ee shruk haa goots'ą' k'eedeegwaadhat gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jii jyąhts'ą' t'igii'in, ąįį nakhwan t'ee jyaa dakhwa'yaa kwaa t'oonchy'aa, nakhwatee ch'ihłee khaihkwaii oihłi' yindhan ji', nijin geenjit khaihkwaii nilii geenjit slave heelyaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ąįįts'ą' nakhwatee ch'ihłee, adan tr'ookit oihłi' yindhan ji' gooveenjit datthak slave khohłyaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Gwidinji' gaa dinjii nąįį yeenjit slave heelyaa geenjit dzaa nankat gwats'ą' haazhii kwaa. Gooveenjit gwitr'it t'agwahaah'yaa ts'ą' dinjii lęįį nąįį neeheezhii geenjit giihaahkhwaa.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericho kwaiik'it gwachoo k'eegiidal ts'ą' Jesus, ditsyaa ts'ą' dinjii lęįį nąįį łeeljil haa gihłeehidii, gwiizhit dinjii vandee kwaa Timaeus vidinji', Bartimaeus oozhii laraa eenjit ch'oodiikwat nilii, tąįį gwinjik geeghaih dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nijin Jesus, Nazareth gwats'an t'ii'in gwiitth'ak dąį', azhral, “Jesus, yeenii David vidinji', neeshraahchy'aa shǫįįnyąą!” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Dinjii lęįį nąįį shruk haa “Deegwahtsai' kwaa!” giiyahnyąą. Gaa nihk'it gwint'aii azhral ts'ą' jyaa nyąą, “David vidinji' neeshraahchy'aa shǫįįnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus, ndaaniinzhii ts'ą' jyaa nyąą, “Aanaii vohnyąą.” goovahnyąą. Ąįįts'ą' dinjii vandee kwaa aanaii agahnyąą ts'ą', “Ndak ninkhaii ts'ą' shoo iinlii, aanaii nahnyąą t'inchy'aa.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Dach'adak ik neetr'aanąįį tł'ęę ndak niltłee ts'ą' Jesus ts'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“Neenjit deesho'ya' shǫįįnyąą?” Jesus, yahnyąą “Geech'ǫąąhtan, chan hee gwał'in neeshooli' nihthan.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Oo'an neehindii, nigwik'iinjigwiighit neenjit gwinzii neegwiłtsąįį t'oonchy'aa.” Jesus yahnyąą. Gwagwahkhan gwąąh'in neekhwadlit ts'ą' tąįį gwinjik Jesus tąįį haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nijin Jerusalem gwats'ą' niighit kwaa geedaa gwiizhit Bethphage kwaiik'it ts'ą' Bethany kwaiik'it geeghaih Taih Vakat Olives Nahshii ąįį zhit k'eegiidal ąįį zhit gwats'an Jesus, ditsyaa neekwaii nąįį oo'an dits'ii goovihił'e', ");
INSERT INTO gwiNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ts'ą' t'agoovahnyąą, “Zhit kwaiik'it goo'aii gwats'ą' ho'oo. Izhit nihdǫǫ'oo gwagwahkhan donkey gii tsal zhat dakhwachaa hǫǫh'yaa. Ąįįt'ee gwehkįį neegiihahchik kwaa. Gwats'an tr'oochįį ts'ą' dzaa gwats'ą' hohchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","‘Jaghaii jii jyaa dakhwa'in?’ Nakhwarahnyąą ji', ‘K'eegwaadhat yat'ąąhchy'aa ts'ą' yat'ąąhchy'a' gwagwahkhan gwantł'ee neeyahahchyaa t'oonchy'aa.’ vohnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ąįįts'ą' gwats'ą' gahaajil ts'ą' donkey gii tsal gindeiinvyaa k'it tąįį gwinjik geeghaih dakhwachaa agwagwąh'ąįį ts'ą' gwats'an deeneegiiyin'at gwiizhit, ");
INSERT INTO gwiNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","zhat gwa'an dinjii neiilzhii nąįį t'agoogahnyąą. “Ąįį donkey gii tsal jaghaii danoh'at t'akhwa'in?” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesus, dohnyąą gavahnyąą, gwik'it t'agoogahnyąą, ts'ą' zhyaa gihłeegahoo'oo ts'ą' zhyaa googah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ąįį donkey gii tsal Jesus ts'ą' giihiłchįį ts'ą' digi'ik giikat deedhidlii ts'ą' Jesus yakat daandii. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dinjii lęįį nąįį digi'ik tąįį gwinjik gideekwaii nilii ts'ą' ch'izhii nąįį chan tąįį geeghaih ah ch'at'an choo nilii ąįį khagit'ii tąįį gwinjik gideekwaii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Juu yits'ii haajil ts'ą' juu yatąįį adaa haa gazhral ts'ą' jyaa ginyąą, “Vit'eegwijyąhchy'aa jiintsii deerahoh'ee! Juu K'eegwaadhat voozhri' zhit ahaa ąįį Vit'eegwijyąhchy'aa vaa oolį'! ");
INSERT INTO gwiNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Vit'eegwijyąhchy'aa deerahoh'e'! Diitsii yeenii King David veegwinii'ee ts'an ahaa Vit'eegwijyąhchy'aa vaa oolį'.” ");
INSERT INTO gwiNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nijin Jesus Jerusalem kwaiik'it gwachoo nihdeiinzhii dąį' Kharigidiinjii Zheh nihdeiinzhii, ts'ą' gwizhit datthak gwąąh'in, Gaa ch'adąį' hee drin tł'an gehtł'ee goodhat geh'an, Bethany kwaiik'it gwats'ą' ditsyaa 12 nąįį haa gwits'eehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Gęhdaa drin gwandaa, Bethany gwats'an neegeedaa gwiizhit Jesus vizhit gwiłts'ik, ");
INSERT INTO gwiNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ts'ą' niighit gwats'an Fig dachan vakat ch'at'an gwanlii neeł'in ąįįts'ą' yats'ą' haazhii vakat Figs shrǫǫ yuunyąą eenjit, gaa yakat ch'at'an zhrįh agwąh'ąįį, tth'aii hee Figs hahshii nagwaaghyii kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesus, Fig dachan ts'ą' khaginkhee, “Chan ch'ihłok gaa nats'an Figs neerahee'aa kwaa t'oonchy'aa!” ąįį jyaa nyąą vitsyaa nąįį giiyiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nijin Jerusalem k'eegiidal dąį' Jesus, juu vaa adaa nąįį haa Kharigidiinjii Zheh nihdeiinzhii ts'ą' juu ch'ookwat nąįį ts'ą' zhit vach'arookwat nąįį datthak Kharigidiinjii Zheh gwats'an cheehaanzhit. Ch'adanh nahkat gwalaraa ookwat nąįį vakaii'aa khatąąnahjil, ts'ą' chan vakat daraadii ts'ą' chiitsal pigeons ąįį vizhit dilk'ii kwaii gavarahookwat nilii kwaii datthak khatąąnahjil. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ts'ą' ch'ihłee gaa Kharigidiinjii Zheh gwizhit k'eiich'ii nihdeegiheelyaa goots'ą' t'agwahthan kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ąįįtł'ęę dinjii nąįį gwąąhtan, ts'ą' jyaa nyąą, “Jii t'ee Dęhtły'aa Choh kat dagwanakhwatł'oo ts'ą' Vit'eegwijyąhchy'aa jyaa nyąą, ‘Shizheh t'ee jii nankat dinjii nihłehjuk t'iichy'aa nąįį datthak eenjit khadigireheejyaa zheh gwarahaanjyaa t'oonchy'aa.’ Gaa nakhwan ąįį juu ch'an'įį nąįį gwizhit geegoh'ik ch'agahaan'yaa ąįį geenjit zheh nagoo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jii giinkhih kįh dilk'ii ts'ą' Law eech'ǫąąhtan nąįį haa nijin deezhik giiyeegwiitth'ak dąį', gwagwahkhan giiyęhdaa tr'igwihee'yaa giiyeenjit gwankagantii. Gaa dinjii lęįį łeeljil nąįį datthak geegwaroolii kwaa gooveenjit geech'oorahtan geh'an Jesus agąąnjat. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Zhat khaa nagwaanąįį dąį', Jesus ts'ą' ditsyaa nąįį haa kwaiik'it gwachoo gihłeegahoojil. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gęhdaa vanh dąį' hee tąįį gwinjik geedaa gwiizhit ts'iivii vakat Figs nahshii gah'in ąįį dachan vaghat gwats'ą' datthak dahkyaa łee gwagwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter ąįį gwehkįį dąį' deegwiizhik ganaandaii ts'ą' Jesus, t'ahnyąą, “Geech'ǫąąhtan, dzaa gwąąh'in, yagha' Fig dachan chan ch'ihłok gaa vakat neegwahaanzhii kwaa vaiinyąą chy'aa chan an dhidlit łee!” ");
INSERT INTO gwiNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesus ąįį jyaa goovahnyąą, “Vit'eegwijyąhchy'aa deehee'yaa datthak gwik'it t'ihee'yaa vik'injuhkhit. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Łyaa nakhwaagwahaldak, juu nijin ch'ihłee didrii zhit gwik'injihkhit ts'ą' jii ddhah ndak ninkhaii ts'ą' chųų choh zhit oodaa hinkhaii vaihnyąą ji' gwik'injiighit geh'an gwik'it t'igweheenjyaa ts'ą' gwik'it gwehee'yaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jii geenjit nakhwaagwaldak t'ihnyąą, nijin khagadǫhjii dąį' gwik'injigwiighit haa k'eegwiichy'aa eenjit ch'oohkat ji' nakhwantł'eegwirehee'aa gwik'injohkhit ji' jidii ach'oohkat datthak nakhwantł'eegwireheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ąįįts'ą' nijin, ndak nohthat haa khagadǫhjii dąį' nakhwanee'ok dinjii ch'ihłee haa nakhwaa gwit'igwiin'ee ji' datthak geenjit oo'an gwahohłii, jyąhts'ą' gwik'iighai' Zheekat Nakhwati' nakhwatr'agwaanduu datthak nakhweenjit oo'an gweheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gaa nakhwanee'ok dinjii nąįį nakhwats'ą' tr'agwaanduu t'ii'in gooveenjit oo'an gwahoolii kwaa ji', Zheekat Nakhwati' chan duuyeh nakhwatr'agwaanduu nakhweenjit oo'an gwihihlii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Chan hee Jerusalem k'ineegiidal. Ąįįtł'ęę Jesus Kharigidiinjii Zheh nihdeiinzhii ts'ą' zhit gwa'an neehidik gwiizhit, giinkhih kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį, ts'ą' Israel kįh dilk'ii nąįį haa Jesus ts'ą' nigiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ąįįts'ą' giiyųąhkat, “Jii jyaa deeni'yaa geenjit juu t'aih nantł'eiin'ąįį t'ini'in?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus t'agoovahnyąą, “Jii ch'ihłak eenjit nakhwahałkat, ąįį deihnyąą t'ihnyąą shaagoondak ji' juu vats'an t'aih haa t'ishi'in nakhwaagwahaldak. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jii shaagoondak, nijin gwats'an John t'aih oonjik t'ii'in chųų gwats'an hahtsyaa geenjit. Vit'eegwijyąhchy'aa vats'an akwat dzaa nankat dinjii nąįį ts'an?” ");
INSERT INTO gwiNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Deegiheenjyaa li' geenjit nihzheedagąąn'ee, “Vit'eegwijyąhchy'aa vats'an gwinyąą ji' chan jaghaii John vik'injuhkhit kwaa? Diinahąąnjyaa t'inchy'aa.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Gaa jii nankat dinjii nąįį ts'an gwinyąą ji'…” (Zhat dinjii nąįį datthak John, Vit'eegwijyąhchy'aa Eenjit Ginkhii t'inchy'aa ginyąą ts'ą' gwik'injigiighit geh'an. Zhat dinjii nąįį agąąnjat.). ");
INSERT INTO gwiNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ąįįts'ą' Jesus “Gaagwiindaii kwaa.” agahnyąą. Ąįįtł'ęę Jesus t'agoovahnyąą, “Shant'ee jii t'aih haa gwitr'it t'agwał'in, nijin gwats'an t'ishi'in nakhwaagwahaaldak kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ąįįtł'ęę Jesus gwandak ąhtsii zhit geegoovąąhtan, haa goots'ą' ginkhii, “Ch'ihłan dinjii jak choo (grapes) deek'it jak choo gwit'eiinlii, tthał chan yeelin needhatthaii. Jak choh teech'ahahdǫǫ ts'ą' jak choh chų' (wine) hahtsyaa geenjit khagwiindhat ts'ą' khach'oohaan'ya' geenjit zheetii gwakat gwiłtsąįį. Dinjii zhat gwik'eehaahtyaa nąįį teegwįłjik, ts'ą' ch'adanh niighit nahkat gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nijin jak choo (grapes) dinįįzhrįh khaihłan nireheelyaa nigwiindhat dąį', jak choh lat ooheendal geenjit (vi-slave) yeenjit tr'agwah'in nilii ch'ihłak goots'ą' hił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nijin zhat k'idik dąį' giiyąhtsit ts'ą' gwint'aii giiyąąhkhwąįį, gwihiljii ts'ą' k'iinjik neegiihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ąįįtł'ęę chan hee ch'izhii da-slave goots'ą' hił'e', gaa dachan haa giiki' iłkhaa ts'ą' oozhii gwaa'in giits'ą' t'ee'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Googaa chan hee ch'izhii vi-slave goots'ą' hił'e' ąįį chan giiyiiłkhwąįį, ts'ą' da-slave lęįį nąįį oo'an neeha'ak gaa juu goots'ą' hah'ak nąįį datthak ęhdaa tr'igwigwii'ak, ts'ą' goolat nąįį chan gwint'aii gahkhwaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Vidinji' zhrįh vaat'inchy'aa, ąįį chan łyaa eet'iindhan, googaa goots'ą' yihił'e', ‘Łyaa shidinji' gahah'aa gwizhrįh gavaashandaii.’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gaa ąįį juu gwanzhįh deek'it gwak'ąąhtii nąįį jyaa nihłagaanyąą, ‘Jii nan ts'ą' k'eedeegwaadhat vidinji' t'inchy'aa, aanaii vats'a' tr'ahoojyaa ts'ą' vęhdaa tr'agwaroo'aa, ąįį ji' jii vanan diits'an heelyaa.’ ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ąįįts'ą' giiyąhtsit ts'ą' giiyęhdaa tr'igwiin'ąįį. Ąįįtł'ęę jak choo dehk'it gwats'an giichį' cheet'eegiiheełnaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ąįįtł'ęę gwanzhįh deek'it vats'an nilii ąįį deehee'yaa shrǫǫ nohthan?” Jesus gavahkat. “K'iinaa heekhaa ts'ą' datthak goovęhdaa tr'igwihee'aa ts'ą' ch'izhii dinjii nąįį zhat nineeheelyaa t'oonchy'aa.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jesus t'agoovahnyąą, “Nik'ee Dęhtły'aa Choh kat deegwinyąą gooh'in? ‘Jii kii chyah kat zheh ndak gwehee'aa, ąįį dinjii zheh gwahtsii nąįį kii nizįį nilii kwaa k'it t'inchy'aa ginyąą. Gaa ndaagwąą'ąį' dąį' kii hilee nilii łee giiky'aanjik. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jii t'ee K'eegwaadhat jyaa diizhik. Łyaa gwinzii giiyiichy'a'!’” ");
INSERT INTO gwiNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jews kįh dilk'ii nąįį, Jesus zhee gwaazhrąįį nagahahchyaa gwik'eegogwandaii. Zhit gwandak eegwandak ąįį gooveenjit t'igwinyąą. Ąįį gaagiindaii geh'an giiyuuheendal gaa zhit dinjii lęįį łeeljil nąįį agąąnjat geh'an giihłeehoojil ts'ą' neegahoojil. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pharisee nąįį ąįįts'ą' Herod vitsyaa nąįį lat Jesus ts'ą' gihił'e' giiyuuhaahkat geenjit, deenyąą k'iighai' goodhaii nideegiihaahtthal gwik'eegwagwandaii geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Giits'ą' niinjil ts'ą' jyaa giiyahnyąą, “Geech'ǫąąhtan, nan łyaa łi'deegwidlii haa ginkhii gaagwiindaii. Nats'ahts'ą' dinjii nąįį nininjich'adhat geenjit tr'igwiindii kwaa. Dinjii nats'ahts'ą' dinjii nilii ąįį chan gwiinchyaa kwaa, gaa Vit'eegwijyąhchy'aa zhit dinjii nąįį doo'ya' yiindhan gwizhrįh geech'ǫąąhtan. Diihaa gwandak, Caesar, Rome nahkat gwats'ą' k'eedeegwaadhat, vats'a' taxes tr'ookwat ji' dii-law inehts'į' t'igwii'in lee t'igwii'in? Googwarahookwat kwaa akwat googwarahookwat, jidii shrit?” ");
INSERT INTO gwiNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Gaa Jesus goodhaii nideegiihaahkhii eenjit t'iginyąą goovaandaii ts'ą' t'agoovahnyąą, “Jaghaii goodhaii nashoohohthal gwik'eegǫhdaii? Laraa ghoo tsal shantł'oh'ąįį ts'ą' hooł'yaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ąįįts'ą' laraa ghoo giiyintł'eiin'ąįį, ts'ą' gavahkat, “Juu vinin ts'ą' voozhri' haa vakat dha'aii?” “Caesar vats'an t'inchy'aa,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ąįįts'ą' Jesus t'agoovahnyąą, “Akwaa ji' jidii Caesar vats'an nilii ąįį vantł'eenohłii ts'ą' jidii Vit'eegwijyąhchy'aa vats'an nilii ąįį vantł'eenohłii.” Jesus łyaa gooveenjit geegwaroolii kwaa, t'iinyą' ");
INSERT INTO gwiNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ąįįtł'ęę Sadducee lat nąįį nineegwaalii gwanlii kwaa ginyąą nąįį Jesus ts'ą' gahaajil ts'ą' giiyųąhkat, ");
INSERT INTO gwiNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Geech'ǫąąhtan, Moses jii law diineenjit daantł'oo, ‘Dinjii voondee veeraadii, ąįį ch'oondee vigii kwaa ts'ą' niindhat, ąįį vachaa doondee'at neehoondal gwizhrįh, tr'iinin gihee'yaa geenjit. Ąįį tr'iinin gii'įį ji' zhit ch'oondee niindhat ąįį vigii k'it giiyeehoondal.’ ");
INSERT INTO gwiNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ch'ihłan dąį', nihchaa 7 nąįį gwanlii, ch'oondee tr'injaa oonjik, gaa vigii kwaa ts'ą' niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ąįįts'ą' chan vats'ąįį vachaa ya'at noonjik, adan chan vigii kwaa ts'ą' niindhat. Ąįįtł'ęę chan ąįį ch'achaa third dhidii ąįį chan gook'it t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ąįįtł'ęę ants'ą' goochaa nąįį datthak gookcg'it t'iizhik. Nihchaa giilįį ts'ą' datthak neegiiyuunjik, gaa datthak tr'iinin gee'į' kwaa ts'ą' datthak nigiinjik, ąįįtł'ęę zhit tr'injaa chan niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nihchaa 7 nąįį datthak eendi' ts'ą' nijin drin zhit niindhat dąį' neegogwandaii neegahoodlit ji', juu va'at heelyaa t'inchy'aa?” ginyąą ts'ą' giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus jyaa goovahnyąą, “Łyaa gwinzii t'ohnyąą kwaa t'oonchy'aa. Ąįįts'ą' jaghaii gaakhwandaii? Dęhtły'aa Choh zhit deegwinyąą ąįįts'ą' Vit'eegwijyąhchy'aa vat'aii jiintsii ąįį gaakhwandaii kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nijin nigiindhat gwats'an neegwigweheendaii drin nigwiindhat ji' zheekat gwich'in k'it t'igiheechy'aa ts'ą' nihłagooheendal kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ts'ą' Dęhtły'aa Choh nik'ee niindhat nąįį neegwiindaii gwinyąą gooh'in tr'ał ak'an ts'an Vit'eegwijyąhchy'aa, Moses ts'ą' ginkhii jyaa dinyąą, ‘Shįį t'ee Abraham, Isaac, ts'ą' Jacob haa Goovit'eegwijyąhchy'aa ihłii.’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Niindhat nąįį eenjit Vit'eegwijyąhchy'aa nilii kwaa gaa gwandaii nąįį zhrįh, łyaa gwinzii t'ohnyąą kwaa t'oonchy'aa.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jews Law eech'ǫąąhtan ch'ihłak zhat dhidii deegwinyąą gwiitth'ak. Jesus, Sadducee nąįį gwinzii goodii ginkhe', gwah'in ts'ą' Jesus ts'ą' haazhii ts'ą' yuahkat, “Dii-law tee jidii ch'andaa jiintsii t'oonchy'aa?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus, t'iiyahnyąą, “Jii t'ee ch'andaa jiintsii t'inchy'aa. ‘Israel nąįį, datthak ch'oodǫǫhk'įį, K'eegwaadhat Diivit'eegwijyąhchy'aa t'ee adan zhrįh K'eegwaadhat nilii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","K'eegwaadhat Nivit'eegwijyąhchy'aa, nidrii datthak haa veenjit ch'eet'igwiniindhan ni'įį, nizhin zhit, niyinji' zhit, ąįįts'ą' nat'aii datthak haa veenjit ch'eet'igwiniindhan ni'įį.’ ");
INSERT INTO gwiNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gwats'ąįį chan jii, ‘Deegwahtł'oo ideet'iindhan googwahtł'oo ninee'ok dinjii nąįį datthak eet'ihiinghyaa goo'aii.’ Jii neekwaii andaa deegwehee'yaa gwinyąą gwanlii kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Law eech'ǫąąhtan ąįį Jesus t'ahnyąą, “Geech'ǫąąhtan, łyaa gwinzii t'iinyąą, Vit'eegwijyąhchy'aa adan zhrįh K'eegwaadhat nilii, ts'ą' Vit'eegwijyąhchy'aa veeghaii K'eegwaadhat gwanlii kwaa, łi'deegwidlii haa ginkhii t'iinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ts'ą' nidrii datthak, niyinji' datthak, nat'aii datthak haa veenjit ch'eet'igwiniindhan ni'įį, ts'ą' deegwahtł'oo ideet'iindhan googwahtł'oo ninee'ok dinjii nąįį datthak eet'iindhan. Jii deegwehee'yaa gwinyąą neekwaii k'eegwarahthat ąįį Vit'eegwijyąhchy'aa vats'a' nin ataiinjii tr'ahtsii andaa ts'ą' gwihil'ee.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesus łyaa gwizhįh haa gwidiiginkhe' yaandaii ts'ą' t'iiyahnyąą, “Łyaa Vit'eegwijyąhchy'aa Veegwinii'ee gwats'ą' nahgwan t'inchy'aa t'oonchy'aa.” Jii ąįįtł'ęę ch'ihłee gaa yuuhahkat gatr'agwaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus Kharigidiinjii Zheh gwizhit geech'ǫąąhtan gwiizhit ch'oahkat, “Law eech'ǫąąhtan nąįį, yeenii King David vizheh k'ąą gwats'an Christ tr'iheehaa ginyąą deeginyąą t'iginyąą? ");
INSERT INTO gwiNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ch'anky'aa Shroodiinyąą zhit ąįį King David jii jyaa diheenjyaa yiłtsąįį. ‘K'eegwaadhat ąįį Shik'eegwaadhat jyaa dahnyąą, dzaa shriits'ąįį sheeghaii dhindii, dahthee juu nits'į' t'inchy'aa nąįį nakwai' t'eh nihihłyaa gwats'ą' datthak?’ ");
INSERT INTO gwiNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","King David adan gaa Shik'eegwaadhat yahnyąą, gwiizhit nats'ahts'ą' Christ ąįį yeenii David ts'an diheedhaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Geegavąąhtan gwiizhit jyaa nyąą, “Law eech'ǫąąhtan nąįį ts'į' dak'oontii ts'ą' gooveenjit gwak'ǫǫhtii. Ik ninjyaa nagaazhii haa oo'ok neegihiidal geet'igiindhan. Nijin dinjii nąįį kwaiik'it gwachoo gwitee dinjii nąįį ch'oohookwat geenjit khit łeenagaadal gwa'an Law eech'ǫąąhtan nąįį jyaa gii'in, gwihil'ee gooneerahąhdak ts'ą' gooveech'igi'in geet'igiindhan geh'an, ");
INSERT INTO gwiNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ąįį nąįį Jews gootr'igiinkhii zheh gwizhit, nijin juu kįh dilk'ii nąįį gwidehk'it giilk'ii, gwa'an giilk'ii chan geet'igiindhan. Nijin ch'ara'aa gwagwahtsii dąį' dinjii tr'ihił'ee nąįį tee giilk'ii geet'igiindhan. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tr'injaa vakai' niindhat nąįį goozheh goots'į' gohdak ts'ą' shroondaii chan niighyuk khadigigiinjii. Łyaa gwandaa gwiizųų googwarahaahshii gooveenjit goo'aii!” ");
INSERT INTO gwiNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus nijin Kharigidiinjii Zheh gwizhit dinjii nąįį laraa gwizhit gilii gwideek'it geeghaih naadii, ts'ą' dinjii nąįį laraa gwizhit gilii gwah'in, dinjii valaraa gwanlii nąįį, laraa lęįį gwizhit gilii goovah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tr'injaa neeshraahchy'aa vakai' niindhat gwiizhit zhat niizhii ts'ą' laraa ghoo tsal neekwaii $ .01 aanchy'aa gwizhinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ąįįts'ą' ditsyaa nąįį aanaii ahnyąą ts'ą' t'agoovahnyąą, “Łyaa nakhwaagwaldak, jii tr'injaa vakai' niindhat neeshraahchy'aa gaa ch'andaa laraa gwizhiinlii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Juu datthak laraa tr'ooniindhat giit'aahchy'aa kwaa geh'an gwizhit gilii, gaa zhit tr'injaa neeshraahchy'aa laraa di'įį yaa gweheendaii datthak gwizhiinlii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus Kharigidiinjii Zheh chineezhii gwiizhit vitsyaa ch'ihłee jyaa yahnyąą, “Geech'ǫąąhtan zhik gwah'in! Zhik Kharigidiinjii Zheh ts'ą' veelin zheh goodlii haa kii nidiiltsį' nindal aahchy'aa haa iłtsąįį nah'in!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus ąįį t'iiyahnyąą, “Aahą', jii zheh gwachoo kwaii, gwinzii nǫh'in. Yeendaa ji' kii tsal ch'ihłak gaa neekwat dehee'aa kwaa ts'ą' gwideek'it hee'aa kwaa. Datthak an heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus, Kharigidiinjii zheh gwachoo gwits'ii Taih Vakat Olives Nahshii dha'aii kat doodii gwiizhit Peter, James, John ts'ą' Andrew nąįį haa tthan dhidii giits'ą' haajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Zhat nigwiindhat ji', deegwehee'yaa ts'ą' deegweheenjyaa diinaa gwandak. Nijin ji' jii kwaii datthak gwik'it gweheelyaa gwarahąąh'yaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus t'agavahnyąą, “Gwak'ǫǫhtii, ch'ihłee gaa neenakhwahoon'ee shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Dinjii lęįį nąįį nakhwats'ą' giheedaa ts'ą' sheenjit giginkhii giheenjyaa ts'ą' ‘Gwidinji' adan t'ihchy'aa!’ giheenjyaa ts'ą' dinjii lęįį nąįį neegeheen'ee t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ts'ą' nijin nihłariighan gwinyąą gootth'ak ji' noojat shrǫ', ąįįt'ee deegweheenjyaa ąįį gwik'it t'igweheenjyaa, gaa nan ndaanąą'ąį' eenjit t'igwii'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nahkat datthak geegwinii'ee chan nihłigiheeghaa. Nijuk datthak chan nan haatrat, ts'ą' shih agwantrii nagwahaadhal dinjii nąįį ihdeeheengaii. Jii t'ee tr'injaa tr'ookit tr'iinin haa hiłts'ik k'it t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ideenjit gwak'ǫǫhtii datthak ts'ą'! Gwintł'ee nakhwareheelyaa ts'ą' nakhwarahahkat. Israel tr'igiinkhii zheh gwizhit nakhwagwarahahshii. Shęh'an Gwandak Nizįį eegahoondak geenjit khaihkwaii kįh dilk'ii nąįį ts'ą' k'eedeegwaadhat choh nąįį ts'ą' nanakhwaraheelyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Gaa jii nan datthak ndaahaan'aa gwehkįį tr'ookit Gwandak Nizįį jii nankat dinjii nąįį datthak eegwarahaandak gwizhrįh goo'aii ąįįtł'ęę deegweheenjyaa gwinyąą gwik'it t'igweheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nijin nakhwagooheendal ts'ą' ch'aroahkat zheh nakhwagoohahkat geenjit gwats'ą' nakhwageelyaa dąį' deehohjyaa geenjit gwehkįį tr'agohdii shrǫ'. Zhat nagwiindhat ji', deehohjyaa ąįį gwik'it t'ahohjyaa nakhwaginjik t'inchy'aa kwaa, Ch'anky'aa Shroodiinyąą k'iighai' gahohkhyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dinjii nąįį dagachaa, ąįįts'ą' dagagoondee nąįį gwintł'ee gahahchyaa, goovęhdaa tr'igwirehee'aa geenjit. Ch'iti' nąįį gaa digigii nąįį gwantł'ee heelyaa. Tr'iinin nąįį digiyehghan ts'į' t'igiheechy'aa ts'ą' goovęhdaa tr'igwirehee'aa geenjit gwintł'ee googahahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Shats'an ǫhłįį geh'an dinjii nąįį datthak nakhwatr'igehee'ee, gaa juu ndaagwąą'ąį' gwats'ą' datthak shik'injiighit t'ee neeheezhii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Zhit nijin jidii tr'aanduu gwiizųų hee'aa kwaa goo'aii ąįį zhit niriin'ąįį łee nǫh'in ji' Judea nahkat gwich'in nąįį oodak taih kat gwats'ą' gal hohdaa yuu. (Juu jii dęhtły'aa nah'in nąįį deegwinyąą t'igwinyąą gaakhwandaii gwat'oohchy'aa t'oonchy'aa.) ");
INSERT INTO gwiNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Zhit juu dizheh gwakat doodii neenoozhi' ts'ą' dik'eiich'ii neehoondal eenjit dizheh nihdanǫǫzhi' shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Zhit juu gwanzhįh deek'it gwitr'it t'agwah'in ch'adak ik nooheendal geenjit dizheh gwits'eehoozhi' shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Izhit ji' łyaa tr'injaa vizhit tr'iinin chants'ą' juu tr'iinin ach'ahma' nąįį haa eenjit gwigweheetrii! ");
INSERT INTO gwiNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Vit'eegwijyąhchy'aa vats'a' khagadǫhjii jii khaii gwanlii gwiizhit t'igweheenjyaa kwaa geenjit! ");
INSERT INTO gwiNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Izhit drin nigwiindhat ji' tr'igwidii googwantrii gweheelyaa, jii nankat gwehkįį jyaa dagwahtł'oo gwiizųų gwaraah'in kwaa, Vit'eegwijyąhchy'aa jii nan iłtsąįį dąį' gwats'an juk gwats'ą' datthak chan ch'ihłok gaa jyaa dineegweheenjyaa kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Gaa K'eegwaadhat, drin gwitee gwagwaanchy'aa nahgǫǫ neegwiłtsąįį kwaa ji' jii nankat dinjii nąįį datthak an heelyaa t'oonchy'aa. Ąįį dinjii gwitee tr'iinlii nąįį niighyuk khaiinjich'igiheeghit geenjit drin khaiinjich'ireheeghit kwaii nahgǫǫ niłtsąįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ąįįts'ą' chan dinjii ch'ihłee jyaa nahnyąą ji', ‘Dzaa Christ dhidii nǫh'in!’, akwat ‘Oo'at dhidii t'inchy'aa!’ nahnyąą ji' gaa gwik'injuhkhit shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Christ adagaa'įį ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii ihłii nyąą nąįį gwigwee'in ts'ą' geegwaroolii kwaa t'igihee'yaa haa Vit'eegwijyąhchy'aa dinjii gwitee tr'iinlii nąįį gach'agwadhan ji' gwizhrįh neegeheen'ee. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Łyaa gwinzii dak'oontii, jii datthak gaakhwandaii geenjit gwehkįį nakhwaagwaldak t'ihnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Googwantrii gwiizųų gehgoo goodhat tł'ęę shree ch'ahahdrii kwaa, ts'ą' tǫǫ oozhrii chan ch'ahahdrii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Zheekat gwats'an chan są' kwaii niheedaa. Zhee zhit, jidii gwat'aii haa goodlii, ąįį nijin goodlii kwaii ch'ijuk t'iheenjyaa ts'ą' zheekat ch'ijuk goodlii nagwahaadhal. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ąįįtł'ęę Gwidinji' vat'aii jiintsii, ts'ą' ch'eegwąhndit jiintsii haa k'iidąą zheek'ǫh zhit needyaa tr'ahah'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Vit'eegwijyąhchy'aa dizheekat gwich'in nąįį oodaa hah'aa. Zheekat gwich'in nąįį chan juu Vit'eegwijyąhchy'aa dinjii gwitee tr'ilii nąįį datthak nan ndaanąą'ąį' zheekat gwats'an ndaanąą'ąį' gwats'ą' łachan gooveheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Zhit ts'iivii vakat Figs nahshii ts'an gwagoo'ee. Nijin vatthoochan tth'aii hee dadlok ts'ą' vakat ch'at'an tsal khan nahshii dąį', it'ee shin gwats'ą' nahgwan gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Izhit gwik'it deegwehee'yaa diinyą' gwik'it t'igwii'in gooh'in ji' t'ee yee'at tthał nii'ee nihdeegweedii zhat dhidii vaahahkhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Łi'haa nakhwats'ą' ginkhii t'ihnyąą! Juk gweendaa gwandaii nąįį tthak niinjik kwaa tł'ęę jii kwaii zhit gweheedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zhee, nan haa kwaa gweheelyaa gaa shiginjik ąįį khit łi'didlii heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nijin drin akwat nijin ji' t'igweheenjyaa ch'ihłak gaa gaandaii kwaa, zheekat gwizhit zheekat gwich'in nąįį ts'ą' Vidinji' haa gaagiindaii kwaa. Gaa Gwiti' zhrįh gaandaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Nijin ji' t'igweheenjyaa gaakhwandaii kwaa geh'an gwak'ǫǫhtii, ts'ą' geenjit khach'oo'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Gwidinji' needyaa ji' jyaa digweheenjyaa t'oonchy'aa, ch'ihłan dinjii dizheh gwats'an khaihtak haazhii ts'ą' ditsyaa nąįį dizheh gwak'ąąhtii iłtsąįį ts'ą' datthak gwitr'it ch'ihłak t'igihee'yaa gwigwii'įį goovantł'eegwin'ąįį. Ąįįtł'ęę dinjii gindeiinvyaa k'ąąhtii khit ts'ą' khach'oan'ya' yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Gwak'ǫǫhtii, nijin ji' zheh gwats'ą' k'eedeegwaadhat k'ineeheedik vaakhwandaii kwaa, duulee khaa gwiizhit, akwat, tǫhtł'an, akwat neeyahkaa gwats'ą' akwat vanh k'ineech'aha'ąįį gwiizhit. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nakhwarahtee hee khan k'inihdik ji' dhohchųų gwiizhit k'inoodik shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jii t'ee datthak ts'ą' t'anakhwaihnyąą, ąįį dinjii nąįį datthak chan t'aihnyąą, gwik'eehoohtyaa geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Passover ch'aga'aa gwagwahtsii ts'ą' łųhchy'aa vitee łųh vaaniituu kwaa gihee'aa nigweheedhaa gwats'ą' drin neekwaii, gweedhaa gwiizhit giinkhih kįh dilk'ii nąįį ts'ą' Law eech'ǫąąhtan nilii nąįį haa nagwąą'įį zhit Jesus gooheendal ts'ą' giiyęhdaa tr'igwihee'aa gwik'eegogwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","“Passover ch'aga'aa gwagwahtsii gwiizhit tr'ooheendal kwaa nihłagaanyąą jyaa digwiizhit ji' duulee dinjii nąįį datthak diits'ą' nich'itsahahthat.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nijin Bethany kwaiik'it gwizhit Simon, gwehkįį vatthąį' ahjat (leprosy) haa iłts'ik dąį' ąįį Jesus yizheh gwizhit neech'a'aa gwiizhit tr'injaa alabaster tyah zhit gwanzhįh chų' daatł'oo gwinzii vagwaatsan neeha'ak. Ąįį alabaster tyah łeełnaii ts'ą' Jesus kį' kat neeyaanjaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Dinjii zhat dilk'ii nąįį lat shoh iłtsąįį kwaa ts'ą' t'inihłagaanyąą, “Jaghaii jii gwanzhįh chų' gwinzii vagwaatsan zhyaa an ąhtsii? ");
INSERT INTO gwiNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Khan $300 denarii gwandaa ji' gaa giiyeehǫǫkwat t'inchy'aa, ąįįtł'ęę neeshraahchy'aa nąįį ts'an tr'ahahtsyaa.” ginyąą ts'ą' geenjit ch'ats'ą' t'igiiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Gaa Jesus jyaa nyąą, “Vandeegoh'ąįį kwaa! Łyaa gwinzii shats'ą' t'iizhik geenjit jaghaii vandeegoh'ąįį? ");
INSERT INTO gwiNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gweedhaa datthak neeshraahchy'aa nąįį nakhwaat'eheechy'aa nijin goots'ohnyąą goovohnyąą ji' goots'ahohjyaa t'oonchy'aa, gaa shįį ąįį duuyeh gweedhaa datthak nakhwaa t'inchy'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jidii t'ihee'yaa gadhan gwik'it t'iizhik t'ii'in, jii gwanzhįh chų' gwinzii vagwaatsan shakat naanjaa ąįįt'ee gęhdaa gwandaa shanarahahdal geenjit shrigwilik t'ini'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Łyaa nakhwaagwaldak t'ihnyąą, jii nankat datthak nijin gwa'an Gwandak Nizįį eeragwaandak gwa'an giiyeegiheekhyaa, adan deezhik khik vineegwahaandaii geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ąįįtł'ęę Judas Iscariot, Jesus vitsyaa 12 ch'ihłak nilii, Jesus gwintł'eehahchyaa geenjit giinkhih kįh dilk'ii nąįį ts'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nijin deenyąą giiyiitth'ak dąį' łyaa shoh giinlii, ts'ą' laraa giiyantł'eeheelyaa geenjit giiyaa gwinzii gwiłtsąįį. Ąįįtł'ęę Judas nats'ahts'ą' gwintł'ee yahahchyaa gininjich'ahthat. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tr'ookit drin łųhchy'aa vitee łųh niituu kwaa nigwiindhat dąį', Jesus vitsyaa nąįį giits'ą' haajil ts'ą' giiyųąhkat, “Passover ch'arehee'aa geenjit nijin tr'iilęįį gwarahahtsyaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesus ditsyaa neekwaii nąįį jyaa dahnyąą: “Kwaiik'it gwachoo gwats'ą' hoh'oo, izhit dinjii tyah zhit chųų neehakat nakhwats'ą' tr'iheehaa t'oonchy'aa, ąįįts'ą' vatąįį hoh'oo. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jidii zheh gwizhit nihdeiinzhii, ąįį zhit gwizhit juu zheh gwats'ą' k'eedeegwaadhat ąįį jyaa vohnyąą. ‘Geech'ǫąąhtan, jii jyaa dohnyąą diinahnyąą gwik'it t'anarahnyąą t'igwinyąą, ąįį nijin shitsyaa ąįįts'ą' shįį haa Passover ch'ara'aa gwarahahtsyaa deegwaajii?’ ");
INSERT INTO gwiNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ąįįtł'ęę, yeedak zheh dagoo'aii gwik'eenakhwahaahtyaa, izhit vakaii'aa vakat ch'arehee'aa dha'aii, ąįį zhit jidii t'ahohchy'aa datthak geenjit shragahohłyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Vitsyaa neekwaii nąįį kwaiik'it gwachoo gwats'ą' gahaa'oo, Jesus deegoovahnyąą datthak gwik'it t'oonchy'aa ts'ą' Passover ch'agehee'aa gwagwahahtsyaa eenjit shrii nigwigwiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nijin khaa nagwaanąįį dąį', Jesus ts'ą' ditsyaa nąįį haa zhat gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nijin ch'aga'aa giilk'ii gwiizhit Jesus jyaa gavahnyąą, “Łyaa nakhwaagwahaldak, dzaa nakhwatee ch'ihłee juu shaaneech'a'aa gwintł'ee shahahchyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vitsyaa nąįį datthak ideenjit tr'igwigwidii ts'ą' gootee gwagwaanchy'aa ts'ą' giiyahkat, “Shįį adan ihłii kwaa, hee?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus, jyaa goovahnyąą, “Nakhwatee 12 ǫhłįį ts'ą' ch'ihłee, juu k'ik ghoo zhit shaa łųhchy'aa tahtsik ąįįt'ee adan nilii. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Dęhtły'aa Choh kat Gwidinji' niheedhaa gwinyąą gwadanakhwatł'oo, gaa zhit juu dinjii, Gwidinji' niheedhaa eenjit gwantł'eehahchyaa łyaa veenjit googwantrii gwiizųų ts'ą' vagoodlit kwaa ji' ts'ąįį vidivee gweheezyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ch'aga'aa gwiizhik Jesus łųhchy'aa oonjik ts'ą' mahsį' nyąą haa khagideedi' ąįįtł'ęę datthak khadeeyeenzhuu ts'ą' ditsyaa nąįį teeyiłtsik “Jii łųhchy'aa ǫhjii ts'ą' ch'oh'aa, jii t'ee shatthąį' t'inchy'aa.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ąįįtł'ęę chųų tyah oonjik, Vit'eegwijyąhchy'aa ts'ą' khagideedi' ts'ą' mahsį' nyąą, ąįįtł'ęę goovantł'eeyinkaii ts'ą' datthak giits'an ch'eenį'. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesus jyaa nyąą, “Jii t'ee shadaa, lęįį nąįį atr'agwaanduu oo'an gweheelyaa geenjit gwantł'eerinkaii t'inchy'aa ts'ą' Vit'eegwijyąhchy'aa deehee'yaa nyąą gwik'it t'iizhik gwigweheechy'aa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Łyaa nakhwaagwahaldak, dahthee Vit'eegwijyąhchy'aa Veegwinii'ee gwats'ą' hihshyaa ts'ą' jak chų' k'eejit shininjyaa gwats'ą' jii jak chų' duuyeh neeshinįį t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ąįįtł'ęę Vit'eegwijyąhchy'aa deegihił'e' haa ch'igiinli' ts'ą' Taih Vakat Olives Nahshii ts'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus, ditsyaa nąįį t'ahnyąą, “Datthak ts'ą' shihłeegalhohdaa ts'ą' akhashoohohjyaa t'oonchy'aa, Dęhtły'aa Choh zhit jyaa digwinyąą gwik'it, ‘Vit'eegwijyąhchy'aa divii k'ąąhtii hahkhwaa ts'ą' zhit divii nąįį datthak shrihtee gahaajil.’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gaa gwihįhdaii geenjit nineedhiikhin ąįįtł'ęę nakhwats'įį Galilee gwats'ą' hihshyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter ąįį jyaa yahnyąą, “Datthak nihłeegalgihiłjil ji' gaa shįį, duuyeh akhanoihnyąą t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus Peter jyaa dahnyąą, “Naagwaldak, juk khaa rooster neekwat hahchik gwehkįį tik agwaanchy'aa shaanandaii kwaa hiinjyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter gwint'aii yizheediin'ee ts'ą' t'iiyahnyąą, “Naa nihihthaa ji' gaa nihk'it duuyeh jyaa dihnyąą t'oonchy'aa!” yahnyąą. Ąįįts'ą' ants'ą' vitsyaa nąįį datthak chan jyaa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Gethsemane geek'iidal, ts'ą' Jesus ditsyaa nąįį t'ahnyąą, “Dzaa dook'įį khadigiihihjyaa gwiizhit.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ts'ą' Peter, James, ts'ą' John haa dahaa haadlii, gwintł'oo tr'igwidii gwizhit khaiinjich'iighit. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ąįįts'ą' t'agavahnyąą, “Shidrii zhit tr'igwidii nitsii dha'aii ts'ą' vaa an hihłyaa k'it t'ihchy'aa, dzaa t'ohchy'aa ts'ą' sheenjit gwak'ǫǫhtii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Geh'at niighit kwaa gwats'ą' haazhii ts'ą' nikiigwiintthaii ts'ą' dinin nankat gwah'ee ts'ą' khagidiinjii, ts'ą' jyaa nyąą, “Shiti' gwik'it goo'aii ji' geenjit jii khaiinjich'isheheeghit kwaa geenjit gwideetaa shahahchįį.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Shiti'!” nyąą ts'ą' khagidiinjii, “Jidii datthak neenjit gach'agwadhan gaashandaii, jii khaiinjich'igwiidhat chųų tyah shats'an neegoiinjii, gaa jidii nihthan eenjit kwaa, gaa nan'ąįį jidii niindhan eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Oo'an ditsyaa tik akhoonyąą nąįį giłchųų łee googwąh'ąįį. Peter ąįį jyaa dahnyąą, “Simon, dhinchįį? Hour ch'ihłak gwats'ą' gwizhrįh khach'oohaan'ya' gaa gwats'ą' giindhan kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Datthak ts'ą' t'agavahnyąą, “Gwak'ǫǫhtii ts'ą' khagadǫhjii, jyąhts'ą' gwik'iighai' tr'agwaanduu t'akhwa'yaa hohkhyaa kwaa geenjit. Nakhwayinji' ąįį gwik'it t'asho'ya' niindhan gaa zhit nakhwatthąį' ąįį vat'aii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Chan gihłeehoozhii ts'ą' khagidiinjii, gwehkįį deenyą' chy'aa gwik'it t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ąįįts'ą' chan hee ditsyaa tik nąįį ts'eehoozhii, akhai' giłchųų łee gooneegwah'ąįį. Khyų' digindee nihky'aa gootą' ąįįts'ą' deegiiyahaanjyaa, gaa giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Juk it'ee tik, aanchy'aa goots'ą' nineezhii ts'ą' t'agoovahnyąą, “Tth'aii hee noozhii ts'ą' dhohchųų? It'ee jyaa dagwahtsii gwizhrįh t'ahoo'yaa! Gooh'in! Juk t'ee zhat nigwiindhat Gwidinji' tr'agwaanduu gwitr'it t'agwah'in nąįį antł'eetr'ahahchyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ndak nǫhjyaa ts'ą' tr'ahoojyaa, jii dinjii gwantł'ee shahahchyaa dzaa zhat t'inchy'aa nǫh'in.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ts'ą' gwagwahkhan Jesus tth'aii hee ginkhii gwiizhit Judas, vitsyaa 12 nąįį ch'ihłak nilii k'idik, dinjii lęįį nąįį shrii choo ts'ą' gał haa teegwagwahtą' yaa neehiidal, giinkhih kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį, ts'ą' Israel kįh dilk'ii nąįį haa googihił'e' t'igii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ąįį juu gwantł'ee yahahchyaa ąįį dinjii lęįį łeeljil nąįį t'ahnyąą, “Dinjii haaltsu' t'ee adan vohtthan t'inchy'aa. Ǫhjii ts'ą' gihłeehohchįį, gwiizhit gwint'aii ohtą'.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas zhat k'idik gwagwahkhan Jesus ts'ą' haazhii, “Shigeech'ǫąąhtan!” yahnyąą ts'ą' yiilts'ų'. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ąįįtł'ęę Jesus goonjik ts'ą' gwinzii giik'aahtii ts'ą' gwint'aii giiyųųntą'. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Gaa juu zhat neelzhii ch'ihłak shriichoo khaiintin ts'ą' ndak khii giinkhih choh vi-slave dzee gadahtrat. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ąįįtł'ęę Jesus jyaa goovahnyąą, “Law łaahnaii iizųų ihłii k'it, shriichoo ąįįts'ą' gał choo haa shahohndal geenjit neehoozhik? ");
INSERT INTO gwiNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Drin gwiteegwagwaanchy'aa Kharigidiinjii Zheh gwizhit nakhwaa t'ihchy'aa ts'ą' geenakhwaałtan googaa shǫhjii kwaa, gaa Dęhtły'aa Choh zhit nakhweenjit gwadanakhwatł'oo gwik'it t'igweheenjyaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ąįįtł'ęę vitsyaa nąįį datthak gihłeegalgihiljil ts'ą' akhagiiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tsyaa ch'ihłak, Jesus tąįį neehihdik, zhat khaii ik daagąįį zhrįh naatsuu, giiyahoondal gwik'eegwagwandaii, ts'ą' giiyąhtsit, ");
INSERT INTO gwiNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","gaa vagwach'aa kwaa ts'ą' t'ohłii neehilgit ts'ą' zhat di'ik akhoonyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ąįįtł'ęę Jesus, ndak khii giinkhih choh vizheh gwats'ą' giiyihiłchįį, izhit it'ee ginkhii kįh dilk'ii nąįį, Israel kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį łagaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Gwiizhit Peter niighit gwats'an gootąįį ahaa ts'ą' ndak khii giinkhih choh vizheh tthał gwineedhi'ęę gwizhit nihdeiinzhii, ąįį zhit niveet'ah'in nąįį haa dhidii ts'ą' gwaak'a' gwats'ą' needaaghwaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Giinkhih kįh dilk'ii nąįį, ts'ą' Israel kįh dilk'ii nąįį haa datthak zhat giilk'ii ts'ą' juu oots'it haa Jesus gwiizųų t'iizhit heenjyaa keegwagwąh'in, ąįį gwik'iighai' giiyęhdaa tr'igwigwehee'aa geenjit gaa dinjii agwagwąh'ąįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Dinjii, lęįį nąįį oots'it haa giiyeeginkhii gaa googwandak kwaii nihk'it t'iichy'aa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tł'ęę dinjii lat nąįį ndak nagakhin ts'ą' goots'it haa Jesus eegiginkhii, ");
INSERT INTO gwiNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Jii jyaa nyąą tr'iitth'ak giiyahnyąą, ‘Jii Kharigidiinjii Zheh dinjii gwiłtsąįį shrahtee gwahaałtsyaa gaa drin tik gwizhit jidii dinjii gwiłtsąįį kwaa nineegwihihthal nyąą.’” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jyaa ginyąą, googaa nihk'it geedan gaa googwandak nihk'it t'iichy'aa kwaa googwagwah'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ndak khii giinkhih choh ndak nigiilzhii ts'ą' Jesus goots'ą' nadhat gwiizhit giiyųąhkat, “Jaghaii jii dinjii nąįį gwiizųų neegigiinkhii gwiizhit goodii ginkhii kwaa?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Gaa nihk'it Jesus hahchįį kwaa ts'ą' goodii ginkhii kwaa. Ąįįtł'ęę googaa zhit ndak khii giinkhih choh jyaa neeyaanyąą, “Nan lee Christ inlii, Vit'eegwijyąhchy'aa gwintł'oo deerihił'e' Vidinji' inlii lee t'inchy'aa.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“Shįį t'ee adan ihłii, Gwidinji' t'ee Vit'eegwijyąhchy'aa datthak geenjit t'aih di'įį vishriits'ąįį dhidii khoh'yaa, k'iidąą zheekat gwats'an zheek'ǫh tee neeheedyaa khooh'yaa t'inchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ndak khii giinkhih choo vik'įį gwanlii haa dagwach'aa adak'ach'iłch'aa, ts'ą' jyaa nyąą. “Dinjii nąįį nats'ąą tr'agwaanduu t'ii'in yaandaii giiyeeginkhii gwit'eegwaahchy'aa kwaa! ");
INSERT INTO gwiNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Vit'eegwijyąhchy'aa vinehts'į' ginkhii dohtth'ak? Datthak ts'ą' geenjit deehohjyaa?” nyąą. Zhat dilk'ii nąįį datthak vęhdaa tr'agwaroo'aa giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Goolat nąįį Jesus k'ąą gihizhree ts'ą' giiyindee tł'an dich'iłchaa ąįįtł'ęę giiyahgwat ts'ą' t'igiiyahnyąą, “Juu neełgwat diihaa gwandak!” giiyahnyąą, gwiizhit niveet'ah'in nąįį giiyuaahjik ts'ą' giiyaant'an. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter, chiitąįį tthał niin'ee zhit tth'aii hee dhidii, nijin tr'injaa ndak khii giinkhih choo eenjit gwitr'it t'agwah'in zhat yehgoo hahkhaii dąį', ");
INSERT INTO gwiNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ąįį tr'injaa, Peter kǫ' ts'ą' needaaghwaii nah'in dąį' gwinzii yąąh'in ts'ą' t'iiyahnyąą, “Nan chan Jesus, Nazareth gwats'an ahaa vaa inlii.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Gaa Peter nakwaa yahnyąą, “Deiinyąą t'iinyąą gaashandaii kwaa, jidii eeginkhii t'iinyąą naashandaii kwaa,” yahnyąą. Ts'ą' chigweedii k'ii'an cheehoozhii, gwiizhit łąą rooster hahchik. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ąįį tr'injaa Giinkhih Choo eenjit gwitr'it t'agwah'in nilii izhit yąąh'in ts'ą' dinjii zhat gwa'an neelzhii nąįį t'ahnyąą, “Jii dinjii adan t'ee ch'ihłee nilii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Gaa Peter chan hee gaashandaii kwaa nyąą, ąįįtł'ęę niighit kwaa chan hee ch'izhii dinjii nąįį jyaa giiyahnyąą, “Nan t'ee Galilee gwats'an inkhaa geh'an goovaa ihłii kwaa diinyąą t'oonchy'aa!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","“Łi'deegwidlii haagwaldak kwaa ji', Vit'eegwijyąhchy'aa shagohshii! Łi'deegwidlii haa nakhwaa gwaldak t'inyąą! Ąįį dinjii veegohkhii vaashandaii kwaa t'ohnyąą.” Peter t'agoovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jyaa nyąą gwiizhit Rooster neekwat gwitee gwąąnchy'aa hahchik. Nijin rooster diitth'ak dąį' Jesus deeyaiinyą' chy'aa ganaanjik, rooster neekwat hahchik gwehkįį tik gwagwaanchy'aa naashandaii kwaa, shakhaiinjyaa t'oonchy'aa, Jesus yaiinyą' ganaanjik, ts'ą' neetreeyahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Vanh dąį' gwagwahkhan hee, giinkhih kįh dilk'ii nąįį, ts'ą' Israel kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį, ts'ą' izhit kįh dilk'ii nąįį haa datthak deegihee'yaa nihłaa geegigiinkhii. Ąįįtł'ęę Jesus ch'iitsii tły'ah haa digiiyiłchaa ts'ą' gihłeegiihiłchįį ts'ą' Pilate ts'ą' nigiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate yuahkat, “Jews nąįį goo-king inlii?” Jesus jyaa yahnyąą, “Nan jyaa diinyąą t'iinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Giinkhih kįh dilk'ii nąįį, “Łyaa gwinlęįį gwiizųų gwitr'it t'agwah'ya' t'inchy'aa.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ąįį geh'an Pilate, chan hee neeyuahkat, “Nik'ee gwidii giihinkhyaa? Łyaa gwinlęįį ninehts'į' giginkhii gwiintth'ak!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Chan hee Jesus, k'eegwiichy'aa t'inyąą kwaa, ts'ą' Pilate łyaa geegoolii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gweedhaa datthak nijin Passover ch'aga'aa gwagwahtsii dąį', Pilate, ąįį juu giindhan ch'ihłak gooveenjit zheh gwaazhrąįį chanahchik. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Zhat dąį' dinjii Barabbas zheh gwaazhrąįį dhidii zhit juu k'eedeegwaadhat nąįį ts'ą' nich'itsagahthat nąįį tee dhidii ts'ą', nich'itsagahthat gwiizhit gwitee dinjii ęhdaa tr'igwigwiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dinjii lęįį nąįį łagaajil ts'ą' ąįį zheh gwaazhrąįį gwats'an dinjii ch'ihłak chineehahchyaa ji' eenjit, Pilate goahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","“Jews nąįį eenjit King nilii, ąįį nakhweenjit chinoołchyaa shohnyąą?” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ginkhih k'įh dilk'ii nąįį Jesus itr'igii'ee geh'an Pilate antł'eegiiyahchįį goovaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Giinkhih kįh dilk'ii nąįį, zhit dinjii nąįį datthak Barabbas, Pilate chineeyahahchyaa eenjit jyaa dohnyąą googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ts'ą' Pilate dinjii nąįį chan hee ts'ą' jyaa nyąą, “Ąįį ji' yagha' Jews eenjit King nilii vohnyąą ąįį deehihłyaa?” ");
INSERT INTO gwiNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ąįį dinjii nąįį gazhral ts'ą' t'igiiyahnyąą, “Cross kat gohtsak!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Jidii tr'agwaanduu tr'agwah'ya'?” nyąą ts'ą' Pilate gavahkat. Googaa nihk'it gwandaa gazhral ts'ą', “Cross kat garahahtsak ąhtsii!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate zhat dinjii lęįį nąįį ts'ą' gwiinzii t'asho'ya' yiindhan geh'an Barabbas zhee gwaazhrąįį gwats'an chanaahchįį ąįįtł'ęę Jesus viitrii haa gahtrii gwiłtsąįį, ts'ą' cross kat garahahtsak eenjit gwantł'eeyahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pilate viniveet'ah'in nąįį vizheh gweelin tthał needhe'ee ąįį zhit gwizhit nihdeegiiyąąhchįį ts'ą' niveet'ah'in nąįį datthak zhat khaihłan nigiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ch'adak ik daatsik k'it t'inchy'aa giinaahtsųų, ąįįts'ą' chan khoh giiłtły'aa ąįį łihts'eenaat'aii tseh giiyiłtsąįį ts'ą' giiki' kat nigiiyin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“Jews nąįį goo-King niighyuk goondaii.” Ginyąą ts'ą' giiyeedlaa gwiizhit deegiihił'e' adagaa'įį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Giiki' gał haa oahkhaa gwiizhit giikaahizhree ts'ą' giits'ą' nikiigwiitthak ts'ą' deegiiyihiił'e' k'it gwagwahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nijin giiyeedlaa tł'ęę ąįį ik giinaahtsųų chy'aa, giineetr'aatsuu ts'ą' giigwach'aa ąįį giinineenlii ts'ą' cross kat gigiihahtsak gwats'ą' giiyeehiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","K'iidak geedaa gwiizhit, Simon goodaazhii akhai' niveet'ah'in nąįį, Jesus va-cross ichyaa giits'an gwiłtsąįį. (Simon, kwaiik'it Cyrene gwats'an ahaa ąįįts'ą' Alexander ts'ą' Rufus nąįį gooti' nilii.) ");
INSERT INTO gwiNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Golgotha goozhii ąįįt'ee “Dinjii kiitth'an deek'it.” gwinyąą t'igwinyąą, ąįį zhit gwats'ą' Jesus gihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Jak chų' vitee gwanzhįh chų' Myrrh giiyantł'eehahkaii gaa Jesus yeenii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ąįįtł'ęę cross kat gigiiyiłtsak ts'ą' giigwach'aa datthak, nihteegeelzhii, ts'ą' tth'an ghoo gahaanjal haa juu shrit jidii gwach'aa hoondal li' geenjit tseegii'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Vanh 9:00 nigwiindhat gwiizhit gigiiyiłtsak. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Vehdee dachan kat jidii eenjit gigiiyiłtsak ąįį dagwagwaantł'oo, “Jews nąįį goo-King nilii.” ");
INSERT INTO gwiNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dinjii ch'an'įį neekwaii nąįį giiyaagiłtsak, dinjii ch'ihłak vishriits'ąįį, ts'ą' ch'izhii chan vatł'ohts'ąįį, jyąhts'ą' gaagoogiiłtsak. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Yeenaa dąį' Dęhtły'aa Choh zhit jyaa digweheenjyaa gwinyąą ts'ą' gwadanakhwatł'oo, ąįį łi'didlii haa gwik'it t'igwiizhik. “Dinjii Law łahnaii nąįį haa narąhchįį” gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dinjii gehgoohijyaa nąįį digiki' gaathat gwiizhit Jesus ts'ą' gwiizųų giginkhii. “Aahą'! Kharigidiinjii Zheh shrahtee gwahaałtsyaa ts'ą' drin tik gwiizhit ndak nineegwihihtthal diinyąą ijii? ");
INSERT INTO gwiNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","It'ee nihindhaa gwits'į' cross ts'an neenindii,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jyaa ts'ą' gwik'it chan giinkhih kįh dilk'ii nąįį ts'ą' Law eech'ǫąąhtan nąįį haa jyaa nihłagaanyąą, giiyeedlaa ts'ą' t'iginyąą, “Ch'izhii dinjii nąįį neeheezhii ąhtsii, gwiizhit adan ąįį vęhdaa tr'igwirehee'aa gwits'į' gwats'an tr'eedahaachyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Christ ts'ą' Israel gwich'in nąįį goo-king inlii ji', cross ts'an nineedaanchįį ąįįtł'ęę nik'injireheedhaa!” giiyahnyąą. Ąįį juu neekwaii giiyaagiłtsak nąįį gaa gwiizųų giits'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Drintł'an 12:00 nigwiindhat gwiizhit nankat datthak tǫǫ nagwaanąįį, ts'ą' 3 hrs. datthak tǫǫ gwin'e'. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3:00 gwa'an gweedhaa gwiizhit, Jesus gwint'aii khashraa'iintrat, “Eloi, Eloi, lama shabachthani!” ąįįt'ee, “Shivit'eegwijyąhchy'aa, Shivit'eegwijyąhchy'aa, jaghaii akhashoiinyąą?” gwinyąą t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dinjii nąįį lat giiyiitth'ak ts'ą' jyaa ginyąą, “Ch'oodǫǫhk'įį Elijah keeginkhii t'inyąą!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Dinjii ch'ihłak yats'ą' hilgik ts'ą' sponge ahtsit ts'ą' jak chų' (wine) daatł'oo kwaa ąįį zhit tee yahtsuu ąįį gał tsii niyahtsuu ts'ą' yiheenjyaa geenjit yats'ą' yuuntą'. Gwiizhit dinjii nąįį ts'ą' jyaa nyąą, “Jyaa dohthan, nagwaroo'ya', Elijah neeheedyaa ts'ą' cross ts'an tr'ineeyahahchyaa ji' geenjit tr'agwahaah'yaa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus, gwintł'oo khashraa'iintrat, tł'ęę niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ąįįtł'ęę Khadigiriinjii Zheh gwizhit gindeiinvyaa choh gwach'aa dach'at haa iltsąįį teetł'an dakhii gwats'an k'iizhak datthak nihtr'iinch'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nijin ąįį niveet'ah'in kįh dhidii, Cross ehzhee Jesus ts'ą' nadhat dąį' vandah Jesus niindhat nah'ya' jyaa nyąą, “Jii dinjii łyaa Vit'eegwijyąhchy'aa Vidinji' nilii łee!” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tr'injaa lat nąįį niighit nigiilzhii gwats'an aakin gwagwaa'įį, Mary Magdalene, ts'ą' tsyaa James ts'ą' Joseph haa goohan Mary, ts'ą' tr'injaa Salome chan gootee nigiilzhii. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesus, Galilee t'inchy'aa dąį' haa neegihiidal, ts'ą' giits'inya' tr'injaa lęįį nąįį Jerusalem gwats'ą' giiyahaajil nąįį chan zhat goovaa t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Khaa nigwiindhat ts'ą', Neegwaazhii Drin gwats'ą' drin gwanlii geh'an, Joseph, Aramathea kwaiik'it gwachoo gwats'an ahaa ts'ą' dinjii hil'ee nilii ts'ą' Jews k'eedeegwaadhat nąįį tee dhidii, ts'ą' adan t'ee Vit'eegwijyąhchy'aa Veegwinii'ee geenjit nagool'in nilii ts'ą' naajat kwaa haa Pilate ts'ą' haazhii ts'ą' Jesus vichį' shantł'eerohchyaa nyąą ts'ą' ch'oahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nijin Jesus ch'adąį' hee niindhat giiyahnyąą dąį' Pilate łyaa geegwaroolii kwaa veenjit t'igwiizhit. Niveet'ah'in k'įh dhidii ch'ihłak aanaii ahnyąą ts'ą', Jesus juk niighyuk iłchįį ji' eenjit oahkat. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nijin niveet'ah'in k'įh dhidii yaagwildak tł'ęę Pilate, Joseph t'ahnyąą, “Jesus vichį' oiinjii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ąįįtł'ęę Joseph, gwach'aa dril daagąįį oiinkwat ts'ą' Jesus vichį' cross ts'an nąhchįį ts'ą' gwach'aa dril zhit yahchįį. Kii zhit gweedii goo'aii gwizhit tth'ank'it gwagwaa'įį ąįį zhit gwizhit niyąąhchįį ts'ą' gwadąįį kiichyaa choh, gihdeiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene, ąįįts'ą' Joseph vahan Mary haa nijin giinąąhjik gwagwaah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ts'ą' nijin Neegwaazhii Drin gęhdaa tr'igwiindhat dąį' Mary Magdalene (Magdalene t'ee kwaiik'it Magdela gwats'an ahaa gwinyąą t'iginyąą), ts'ą' James vahan Mary ts'ą' tr'injaa Salome nąįį haa jidii gwanzhįh chų' gwinzii vagwaatsan goiinkwat, Jesus vichį' kat t'igiiyeheelyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Drin zhit vanh dąį' gach'ahaa'ąįį gwiizhit tth'ank'it gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","Geedaa gwiizhit jyaa nihłagaanyąą, “Juu tth'ank'it gwadąįį kii choh gindeiin'ąįį, diineenjit gihłeehee'aa t'oonchy'aa?” (Łyaa kii nitsii t'agahnyąą) Gwiizhit zhazhat k'iidak gwagwaah'in akhai' kii choh ch'adąį' hee gihłeerahaa'ąįį łee gwagwaah'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ąįįts'ą' gwizhit nihdeegiinjil, akhai' tsyaa, gwach'aa daagąįį naazhii, shriits'ąįį dhidii gaah'in ts'ą' gihilghaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ts'ą' t'agoovahnyąą, “Noojat kwaa Nazareth gwats'an Jesus gigiiyiłtsak vinkeegǫh'in gaashandaii. Dzaa dhidii kwaa ts'ą' needhikhin t'inchy'aa. Dzaa nigiiyąąhchįį gwideek'it gooh'in. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Gaa oo'an neekhwajyaa ts'ą' vitsyaa nąįį ts'ą' Peter haa goondak, deenakhwahnyąą gwik'it, ‘Galilee gwats'ą', nakhwehkii hihshyaa. Nyąą chy'aa gwik'it t'iizhik ąįį zhit gwizhit hǫǫh'yaa t'inchy'aa gavahnyąą.’” ");
INSERT INTO gwiNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Goozhit naajat dha'aii, ts'ą' gihiłghaa haa gwats'an tr'ineegaangit ts'ą' dinjii ch'ihłak gaa haa gwagwaandak kwaa it'ee shrit gąąnjat ts'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ąįįtł'ęę Jesus, ch'ichį' ts'an ninilkhin, Drinzhit vanh dąį' hee t'iizhik, ts'ą' Mary Magdalene ts'ą' vigwiilkįį, gwehkįį dąį' jii tr'injaa ts'an ch'anky'aa iizųų 7 yits'an tr'iinlii chy'aa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Ąįįtł'ęę vitsyaa nąįį ts'ą' haazhii ts'ą' tr'igwigwidii gwiizhit gitree. Ąįįts'ą' nijin Jesus neegwiindaii nał'ya' nyąą ts'ą' goovaagwandak dąį' giik'injiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ąįįtł'ęę Jesus ditsyaa neekwaii nąįį kwaii k'it geh'at tr'ał tee gwa'an gee'al gwiizhit goots'ą' ch'ijuk vigweech'in ts'ą' idigweelkįį. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Oo'ee neegii'oo dąį', vitsyaa ch'izhii nąįį datthak haa gwagwaandak, gaa gook'injigiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ndaagwąąn'ąį' ąįįtł'ęę Jesus ditsyaa 11 nąįį ts'ą' vigwiilkįį ch'aga'aa gwiizhit ch'ats'ą' t'agoovahnyąą. Gwik'injigwiighit gii'įį kwaa ts'ą' gooki' dach'at geh'an juu yah'ya' nąįį k'injigiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jii jyaa goovahnyąą, “Jii nankat datthak neekhwadal ts'ą' jii Gwandak Nizįį dinjii nąįį datthak haa goondak. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Juu gwik'injiighit ts'ą' chųų vats'an tr'iłtsąįį t'ee neeheezhii, gaa juu gwik'injiighit kwaa t'ee vatr'agwaanduu datthak vaa t'iheechy'aa ts'ą' Vit'eegwijyąhchy'aa an yahahtsyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Juu gwik'injiighit nąįį t'aih goovantł'eeraheelyaa ts'ą' gwinlęįį gwide' t'igihee'yaa t'oonchy'aa. Shoozhri' zhit ch'anky'aa iizųų lęįį dinjii nąįį ts'an tr'igiheelyaa. Ch'anky'aa Shroodiinyąą zhit ch'izhii ginjik ky'aa gigiheehkhyaa. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ąįįts'ą' gyųų choh neegahahchik akwat ch'oondaih iizųų (poison) geenį' ji' gaa nihk'it duuyeh k'eegwiichy'aa t'iginjii t'oonchy'aa. Juu iłts'ik nąįį gaa kat nagahaandal ts'ą' gavaanjik gwinzii neegweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","K'eegwaadhat Jesus goots'ą' ginkhe' ąįįtł'ęę Vit'eegwijyąhchy'aa zheekat gwits'ee gihiłchįį ts'ą' Vit'eegwijyąhchy'aa vishriits'ąįį zhat naadii. ");
INSERT INTO gwiNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jesus vitsyaa nąįį nijuk datthak neegihiidal ts'ą' Gwandak Nizįį eegwagwaandak ts'ą' K'eegwaadhat goovaatr'agwah'in ts'ą' geegwaroolii kwaa t'igihee'yaa geenjit t'aih goots'an iłtsąįį, ąįį gwik'iighai' jidii eegwagwaandak, dinjii nąįį gwahah'yaa ts'ą' łi'deegwidlii gaageheendaii geenjit. Mark 16:9-10 Tł'ęę deekwa'yaa goorahnyąą ąįį datthak Peter ts'ą' dijyaa nąįį haa gwagwaandak. Ąįįtł'ęę Jesus, aadah East gwats'ą' West gwats'ą' goohił'e'. Jii gwaandak neereezhii k'iighai' gwaandaii ndaanąą'ąį' kwaa tr'ihee'yaa ąįį shroodiinyąą ts'ą' khit łi'deegwidlii haa nats'ąą neereheezhii geegwagwahaandak geenjit.");
INSERT INTO gwiNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Shijyaa Theophilus, Diitee gwik'iinjiighit lęįį nąįį gwinzii yeenii deegwiizhik datthak gwik'it tee ch'adagąąntł'oo t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Juu tr'ookit dąį' googwąąh'ya' nąįį t'ee K'eegwaadhat Viginjik eech'ǫąąhtan nąįį gaadlit, ąįį nąįį t'ee diits'ą' nideech'iriin'ąįį geediinaagogwaandak. Jii kwaii dagogwąąntł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ąįįts'ą' t'ee shijyaa, yeenii niighit tr'ookit dąį' gwats'an jii kwaii datthak geenjit gwinzii adagool'ee tł'ęę neenjit datthak gwinzii gwik'it tee ch'adanoihtł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jii kwaii tthak geenjit ginigwirił'e' ąįį łyaa łi'didlii t'inchy'aa gaanahandaii eenjit t'iilik. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea nahkat gwa'an Herod ąįį King nilii dąį', Giinkhih ch'ihłak Zechariah oaazhii, ąįį yeenii Giinkhih Abijah ts'an deedhaa. Zechariah va'at chan Elizabeth oaazhii, ąįį chan yeenii Giinkhih Aaron ts'an deedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vit'eegwijyąhchy'aa vandee ts'ą' gwinzii googwandaii ts'ą' K'eegwaadhat Vidęhtły'aa Choh deegwehee'yaa goo'aii datthak gwik'eegogwahthat. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Googii kwaa Elizabeth tr'iinin vee'agwantrii geh'an ąįįts'ą' adan chan ts'ą' Zechariah haa łyaa googhaii lęįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ch'ihłan drin Zechariah Giinkhih gwitr'it geegwitr'it t'agwah'in. Zhat drin adan t'ihee'yaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Izhit dąį' gwanaa Giinkhih nąįį geegwitr'it t'agogwahah'yaa eenjit nihłitineegogwaha'ak ts'ą' nihłoozhri' khagilii ąįįts'ą' t'ee zhat drin adan vakaa'aa kat incense haahky'aa goo'aii. Ąįįts'ą' t'ee Kharigidiinjii Zhee Gwachoo nihdeiinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Izhit gwiizhit dinjii lęįį nąįį incense daak'a' dąį' chiitąįį khadigiinjii chy'aa gwik'it t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Vit'eegwijyąhchy'aa zheekat gwich'in yats'ą' igwiilkįį, ąįį incense vakaii'aa chil'ee kat daak'a' ąįį shriits'ąįį nadhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nijin Zechariah niyiił'in dąį' hilghaa ts'ą' naajat. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gaa ąįį zheekat gwich'in jyaa yahnyąą “Nanjat kwaa, Zechariah! Vit'eegwijyąhchy'aa khadigiinji' dąį' niitth'ak, ąįįts'ą' na'at Elizabeth nigii chyaatsal hee'yaa t'oonchy'aa. Voozhri' John hąhtsyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Łyaa tsee'in hinlyaa ts'ą' chan łyaa shoohiinlyaa, ąįįts'ą' nijin vagoodlit ji' lęįį nąįį geenjit shoo heelyaa! ");
INSERT INTO gwiNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","K'eegwaadhat vandee ts'ą' dinjii gwintsii veegoo'aii heelyaa. Kwanchų' nint'aii akwat jak chų' haa heenjyaa kwaa goo'aii. Vagoodlit gwats'an Ch'anky'aa Shroodiinyąą hee'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel gwich'in lęįį nąįį Vit'eegwijyąhchy'aa Gook'eegwaadhat ts'ą' gwik'iinjiighit neegoovahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","K'eegwaadhat ts'ii heekhaa ts'ą' yeenii Elijah Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ąįį k'it vanky'aa heent'aii. Ch'iti', digigii nąįį haa nihłaa gwinzii nineegwehee'aa. Ąįįts'ą' chan juu K'eegwaadhat gwik'eegogwahthat kwaa nąįį gwik'eegwahthat neehahtsyaa ts'ą' dinjii nąįį K'eegwaadhat eenjit goodivee shrigweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah ąįį zheekat gwich'in jyaa ahnyąą, “Łyaa t'igwinyąą ji' nats'ąą gaashahandaii? Shaghaii lęįį ts'ą' chan sha'at chan vaghaii lęįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Zheekat gwich'in jyaa yahnyąą. “Shįį Gabriel t'ihchy'aa, ąįįts'ą' K'eegwaadhat vandah nihthat ts'ą' nats'ą' gihihkhyaa eenjit nats'ą' shihił'e', jii gwandak nizįį eenaagwahaldak eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Gaa jii deenaihnyąą shik'iinjinghit kwaa t'ee nijin gwik'it nagwaanąįį ji' gwik'it t'igweheenjyaa. Deenainyą' gwik'it t'igwiizhik gwats'ą' niighit hee kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Izhit gwiizhit dinjii nąįį Zechariah nagwal'in. Jaghaii Kharigidiinjii Zhee Gwachoo gwizhit niighyuk gwats'ą' hiljii li' giiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nijin chineezhii dąį' vighit kwaa ts'ą' k'eegwiichy'aa gwąąh'ya' ts'ą' giiyaandaii vighit kwaa ts'ą' goots'ą' danli' haa ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nijin ąįį Kharigidiinjii Zhee Gwachoo gwizhit deehee'yaa goo'aii chy'aa gwik'it t'iizhik dąį', Zechariah oo'an dizheh gwits'eehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ąįįtł'ęę niighit kwaa gwahaadhat tł'ęę t'ee va'at Elizabeth vizhit tr'iinin dhidlit, ts'ą' shreenanh ch'ihłoanli' gwizhit datthak dizheh gwizhit khaihłan indi'. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Gohch'it dee K'eegwaadhat jyąhts'ą' shits'iinyą',” Elizabeth nyąą. “Ideenjit oozhii ihłii chy'aa shihłeegwahaa'ąįį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elizabeth it'ee shreenanh nihk'iitik tr'iinin vats'an nilii haa niinzhii gwiizhit Vit'eegwijyąhchy'aa zheekat gwich'in Gabriel oaazhii, Nazareth kwaiik'it Galilee nahkat gwats'ą' hił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Izhit gwiizhit nich'it Mary oaazhii ąįį dinjii Joseph ooheendal goo'aii, ąįį Joseph t'ee yeenii King David ts'an tr'idiindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ąįį zheekat gwich'in Mary ts'ą' idigweelkįį ts'ą' jyaa dahnyąą, “Tsinehdan naa nilii! K'eegwaadhat naa nilii t'oonchy'aa ts'ą' k'eegwiichy'aa gwinzii neenjit t'iheenjyaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary łyaa zheekat gwich'in deenyąą t'inyąą gwinzii gaandaii kwaa ts'ą' gwintł'oo gininjich'ahthat. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ąįį Zheekat gwich'in jyaa yahnyąą, “Nanjat kwaa Mary, Vit'eegwijyąhchy'aa neenjit łyaa ch'eegoonzhrįį gwii'įį! ");
INSERT INTO gwiNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tr'iinin nats'an heelyaa ts'ą' tsyaa tsal ni'yaa ąįį Jesus voozhri' hąhtsyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Łyaa gwintsii veegwehee'aa ts'ą' Vit'eegwijyąhchy'aa Ndak Khii Vidinji' giihaanjyaa. K'eegwaadhat dalak David k'it gwi-King heelyaa yahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Khit yeendaa ndaagwąą'ąį' kwaa gwats'ą' datthak geenjit Jacob ts'an deedhaa nąįį eenjit King heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary, zheekat gwich'in jyaa ahnyąą, “Dinjii gaa haa dhiichįį kwaa gwiizhit nats'ahts'ą' t'agwaiinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gabriel t'iiyahnyąą, “Ch'anky'aa Shroodiinyąą nak'aa t'iheenjyaa ts'ą' Vit'eegwijyąhchy'aa vat'aii naa heelyaa. Jii kwaii geh'an ąįį tr'iinin Shroodiinyąą nilii ts'ą' Vit'eegwijyąhchy'aa Vidinji' oohaazhyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nalak Elizabeth vanandaii. Tr'iinin vee'agwantrii varahnyąą, googaa juk shreenanh nihk'iitik tr'iinin vats'an nilii, vaghaii lęįį gaa nihk'it. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Vit'eegwijyąhchy'aa łyaa t'ihee'yaa kwaa veegwakwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary jyaa yahnyąą, “K'eegwaadhat vitsyaa ihłii, deeshaiinyąą gwik'it gooli'!” Ąįįts'ą' it'ee zheekat gwich'in yihłeedahoodhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Izhit ąįįtł'ęę gwats'an niighit kwaa t'ee Mary heekhaa eenjit shrigwiinlik ts'ą' Judea taih tee nahkat gwa'an kwaiik'it khalchį' haa gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zechariah vizheh nihdeiinzhii ts'ą' Elizabeth ts'ą' niinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Nijin Elizabeth ąįį Mary yats'ą' shoo haa niinzhii gwiitth'ak dąį' vizhit tr'iinin iihaanii. Elizabeth khan hee Ch'anky'aa Shroodiinyąą vaa nilii naanaii. Ts'ą' gwint'aii Mary ts'ą' khaginkhee, “Nan zhrįh tr'injaa tee gwinzii neegirinkhii ąįįts'ą' chan nigii gweheelyaa gwinzii geegirinkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Jaghaii jii shats'ą' gwinzii t'igwiizhik, Shik'eegwaadhat vahan sheenihee t'igwii'in? ");
INSERT INTO gwiNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Shoo haa shats'ą' niinzhii niitth'ak Googwahkhan shizhit tr'iinin shoo haa iihaanii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","K'eegwaadhat naadeegweheenjyaa nahnyąą chy'aa gwik'it t'igweheenjyaa ąįį gwik'iinjinghit geh'an łyaa naashroonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary ąįį jyaanyąą, ts'ą' ch'iilii, “Shidrii K'eegwaadhat deehiił'e' ");
INSERT INTO gwiNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ts'ą' shizhin shoo nilii, Vit'eegwijyąhchy'aa neeshahshii geh'an, ");
INSERT INTO gwiNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ąįįts'ą' chan vitsyaa ihłii ts'ą' neeshraałchy'aa geh'an shanaandaii! Juk gwats'an juu nąįį datthak vaashroonchy'aa shagahaanjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Vit'eegwijyąhchy'aa vat'aii haa sheenjit gwintł'oo łyaa Shroodiinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Juu yaanjat nąįį neeshraahchy'aa oonyąą, ąįįt'ee yeenii nihzhyaaneedijii nąįį reh. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Digin haa gwiintsii t'ii'in ts'ą' juu khaiinjihil'ee nąįį jyaa deegwehee'yaa giindhan nąįį shrihteedhidlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Gwats'ą' k'eedeegwaadhat nąįį zhat gihiłchįį, ts'ą' chan neeshraahchy'aa nąįį ndak gihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Juu vizhit gwiłts'ik nąįį gwinzii ach'ąh'al ts'ą' chan valaraa gwanlii nąįį intł'eech'ahtsit kwaa, t'oołii neegoohił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Yeenii diilak Abraham neeshraahchy'aa ooheenjyaa ganaandaii, jyąhts'ą' t'ee khit diikhwan Israel vitsyaa ts'iinyą' tr'iinlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary shreenanh tik gwizhit datthak Elizabeth haa gwinch'į' tł'ęę dizheh gwits'eehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","It'ee Elizabeth tr'iinin haa iłts'ik naanaii, ts'ą' tsyaa tsal di'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ąįį juu yeeghaii gwich'įį chan ts'ą' valak nąįį haa łyaa K'eegwaadhat yeenjit shroonchy'aa t'iizhik łee googwaak'įį, ts'ą' giiyaa shoo nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tr'iinin tsal vagoodlit tł'ęę nihk'iidǫǫ gwahaadhat ts'ą' giidhah gihłeehaht'al eenjit ts'ą', diti' k'it voozhri' Zechariah oohaazhyaa giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Akhai' vahan ąįį, “Nakwaa!” nyąą. “John ąįį oohaazhyaa” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jyaa giiyahnyąą, “Gaa nalak nąįį tee ch'ihłak gaa jyąhts'ą' voozhri' kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ąįįtł'ęę viti' ąįį daganli' haa giiyųąhkat, “Nats'ąą ąįį tsyaa tsal vooheezhri' eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah dęhtły'aa shantł'ohtsuu goovahnyąą ąįį kat jii daantł'oo “Voozhri' John oaazhii t'inchy'aa.” Geegagoolii kwaa t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Izhit zhat Zechariah vighit neegahoodlit ts'ą' t'ee Vit'eegwijyąhchy'aa deehiił'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Judea taih tee gwich'įį nąįį gwiitth'ak dąį' datthak gihilghaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Juu gwiitth'ak nąįį datthak gininjich'agahthat ąįįtł'ęę ch'agoahkat, “Jii tr'iinin jidii heelyaa t'inchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John viti' Zechariah it'ee Ch'anky'aa Shroodiinyąą vaanilii ts'ą' jii Vit'eegwijyąhchy'aa viginjik kwaii teech'iginkhii, ");
INSERT INTO gwiNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israel gwizhit Vit'eegwijyąhchy'aa, Diik'eegwaadhat deerahoh'ee. Israel nąįį ts'iinyą' ts'ą' gooneiinjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Neediinahshii ts'ą' t'aih nitsii di'įį ąįį chan diinantł'ahchįį, ąįįt'ee yeenii ditsyaa David ts'an deedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Niighit dąį' gwanaa gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii, Shroodiinyąą nąįį k'iighai' jii jyaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","diitr'ii'ee nąįį ts'an neediihahshii nyąą chan gwik'it t'iizhik, ąįįts'ą' juu diitr'ii'ee nąįį goot'aii ts'an chan neediihahshii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yeenii diilak nąįį neeshraahchy'aa ooheenjyaa nyąą ts'ą' nakhweenjit deeshi'yaa nyąą chy'aa gwik'it t'ii'in ąįį gineehaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Yeenii diilak Abraham łi'haa neenjit deehishi'yaa ąįįnyą' gwik'it t'iizhik ąįįts'ą' chan juu diitr'ii'ee nąįį ts'an neediihahshii nyąą chan gwik'it t'iizhik. Gwarandaii gwizhit datthak shroodiinyąą zhit gwinzii diigwitr'it gweheelyaa ts'ą' vaanarahaazhyaa geenjit tr'ahąąnjat kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Shigii łyaa ndak khii Vit'eegwijyąhchy'aa Eenjit Ginkhii hinlyaa, ąįį eenjit jyąhts'ą' nooheezhri' t'oonchy'aa. K'eegwaadhat ts'ii hinkhaa vidivee shrigwihiinlyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gootr'agwaanduu gooveenjit oo'an gwihiinlyaa, jyąhts'ą' t'ee vidinjii nąįį neehahshii eenjit goovaagwahandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Vit'eegwijyąhchy'aa didrii haa datthak diineenjit neeshraahchy'aa dinooheenjyaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Juu ch'ichį' agwank'oh akwat tǫǫ zhit dilk'ii gwik'it ąįįts'ą' zheekat gwach'aadrii intł'eegwehee'aa ts'ą' tsinehdan tr'ihee'yaa eenjit diihaa gwats'ą' diihahchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ąįį tr'iinin dink'indhat ts'ą' vizhin, vanky'aa haa diink'iindhat. Nangwinjir gwa'an gwinch'į' ąįįtł'ęę Israel gwich'in nąįį gwizhrįh niinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Izhit zhat dąį' k'eedeegwaadhat ch'andaa veegoo'aii Caesar Augustus oaazhii, Rome nahkat datthak gwats'ą' k'eedeegwaadhat. Izhit gwizhit dinjii datthak ts'ą' ginkhe'. Datthak gooteegwagwaanchy'aa ts'ą' goovoozhri' tr'ihideentł'oo, dinjii tr'iheechyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ch'adanh nahkat Rome gwats'ą' k'eegwaadhat Syria goaazhii dinjii Quirinius oaazhii kįh k'eegwaadhat nilii dąį', tr'ookit dinjii tr'eechyaa gwaląįį gwiindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Goovoozhri' tr'ihideentł'oo eenjit dinjii nąįį tthak daganahkat gwits'eegahoojil. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph, Galilee nahkat gwizhit kwaiik'it Nazareth gwats'an Judea nahkat gwizhit Bethlehem kwaiik'it gwats'ą' haazhii. Bethlehem ąįį yeenii King David vakwaiik'it googwahnyąą. Joseph, King David ts'an deedhaa, geh'an Bethlehem gwits'ee hoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joseph, Mary haa goovoozhri' tr'ihideentł'oo eenjit zhat gwats'ą' gahaa'oo. “Nihłarooheendal,” nihłagaiinyą'. Mary nahgwan tr'iinin hee'yaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bethlehem gaadii gwiizhit vitr'iinin gweheelyaa nigwiindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chyaatsal nilii vagoodlit, gwehkįį tth'aii tr'iinin di'įį kwaa. Gwach'aa ninjyaa yinǫǫłjik. Ąįįts'ą' aak'ii ch'a'aa dehk'it gwizhit heechyaa eenjit niyąąhchįį. Zheh gwirich'įį datthak gwizhit dinjii gwanlii ts'ą' giveenjit dehk'it gwakwaa, ąįį geh'an aak'ii zheh gwizhit gwigwich'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Zhat khaa divii k'ąąhtii nąįį geeghaih gwa'an digidivii k'eegąąhtii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Khan hee Vit'eegwijyąhchy'aa zheekat gwich'in goots'ą' nadhat. Ąįįts'ą' K'eegwaadhat vich'eegwąhndit haa giveelin datthak ch'aadrii. Łyaa datthak gihilghaa, ");
INSERT INTO gwiNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Gaa zheekat gwich'in goots'ą' khaginkhee. “Noojat kwaa. Gwandak nizįį nakhwaa gwahaaldak eenjit shi'in. Shroonchy'aa dinjii datthak eenjit gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Juk khaa David vakwaiik'it dinjii nakhwatr'agwaanduu gwats'an neenakhwahahshii vagoodlit, K'eegwaadhat Christ nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Aak'ii ch'a'aa dehk'it gwizhit dhichįį, gwach'aa ninjyaa vanoanjik ts'ą' jii kwaii k'iighai' vaakhwandaii.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jyaa dinyąą gwiizhit khan hee zheekat gwich'in lęįį veeghaii niilzhii nagwaanąįį. Ch'ilik haa Vit'eegwijyąhchy'aa deegihiił'ee, ");
INSERT INTO gwiNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Vit'eegwijyąhchy'aa zheekat gwizhit tr'ihił'ee ts'ą' mahsį'! Nankat gwizhit dinjii shoo yahtsii nąįį tee tsinehdan gweheelyaa!” ginyąą ch'igidlii haa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ąįįtł'ęę zheekat gwich'in nąįį datthak zheekat gwits'eegahoojil. Divii k'ąąhtii nąįį zheekat gwich'in goołeehoojil tł'ęę nihłaa giginkhii. “Jii t'igwiizhik K'eegwaadhat deegwiizhik diihaa gwaandak t'igwiizhik, Bethlehem gwats'ą' tr'ahoojyaa ts'ą' deegwiizhik t'igwinyąą gwarǫh'ya',” nihłagaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Khan zhat gwats'ą' gahaajil, tr'iinin kagantii ąįįts'ą' giigwąh'ąįį. Aak'ii ch'a'aa dehk'it gwizhit dhichįį. Mary Joseph haa yeeghaii dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nijin divii k'ąąhtii nąįį tr'iinin tsal gąąh'in dąį' Mary, Joseph haa zheekat gwich'in tr'iinin tsal eenjit goohaagwaandak geegwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Juu giviitth'ak nąįį datthak łyaa jyaa t'igweheenjyaa giindhan kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Jii datthak Mary ganaandaii ąįįts'ą' khit gwintł'oo gininjich'ahthat. Ąįįtł'ęę chan dinjii lęįį nąįį haa googwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ąįįtł'ęę divii k'ąąhtii nąįį nijin gwats'an gahaajil gwits'eegahoojil. Jidii goots'ą' t'igwiizhik ąįį geenjit K'eegwaadhat deegihiił'ee, ch'ilik haa neegeedaa. Nats'ahts'ą' zheekat gwich'in deegweheenjyaa goovahnyąą datthak gwik'it t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Drin nihk'iidǫǫ zhit gwiindhat dąį' it'ee tr'iinin (tsyaa tsal) vadhah gihłeegahaht'al nigwiindhat. Jesus giiyuuzhri' iłtsąįį, ąįįt'ee dahan zhit heedyaa gwats'ą' dąį' hee zheekat gwich'in yuuzhri' iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Niighyuk Shroodiinyąą drin gwiinli' ąįį ęhdaa tr'igwiindhat dąį' Dęhtły'aa Choh kat Moses va-law zhit deegwehee'yaa goo'aii gwinyąą, izhit geenjit Mary, Joseph haa oodak Jerusalem gwats'ą' Jesus gihiłchįį, K'eegwaadhat intł'eegiihahchyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Izhit t'ee K'eegwaadhat va-law zhit geenjit gwadanakhwatł'oo, “Tsyaa tsal tr'ookit vigwilik t'ee K'eegwaadhat ts'ą' narahahchyaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ąįįts'ą' chan dove akwat pigeon dziitsal neekwaii haa gwintł'eegaanjik, ąįįt'ee K'eegwaadhat va-law zhit jyaa deegwehee'yaa goo'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Zhat dąį' Jerusalem gwizhit dinjii ch'ihłak voozhri' Simeon oaazhii, zhat gwich'įį. Łyaa dinjii nizįį nilii ts'ą' chan gweedhaa datthak Vit'eegwijyąhchy'aa yihil'ee. Israel gwich'in nąįį ts'ą' neeheezhii eenjit nagwal'in. Ąįįts'ą' Ch'anky'aa Shroodiinyąą yaa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ąįįts'ą' chan Ch'anky'aa Shroodiinyąą, Diik'eegwaadhat Christ hąąh'yaa gwats'ą' niheedhaa kwaa yeenjit gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Simeon Ch'anky'aa Shroodiinyąą yaa nilii haa Kharigidiinjii Zhee Gwachoo gwizhit nihdeeyąąhchįį. Viyehghan nąįį digigii tr'iinin Jesus k'iindak gwintł'eegahahchyaa goo'aii, t'ee jyąhts'ą' K'eegwaadhat va-law zhit geenjit goo'aii, ąįį jyaa dagahaalik eenjit nihdeegiiyąąhchįį dąį', ");
INSERT INTO gwiNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon dantł'ee deeyiłchįį ts'ą' Vit'eegwijyąhchy'aa deehiił'ee ts'ą' jii jyaanyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Shik'eegwaadhat, it'ee khit deeshi'yaa diinyą' chy'aa khit gwik'it t'iinchy'aa, ąįįts'ą' juk jii nitsyaa tsinehdan gwizhit niheedhaa eenjit gwantł'ahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Łi'haa shandee haa dinjii neeheezhii gwąhtsii naał'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ąįįt'ee dinjii nąįį datthak gwahąąh'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Neeheezhii khwa'įį t'ee ch'ahdrii ąįį Israel gwich'in nilii kwaa nąįį k'ąą ch'ahahdrii ts'ą' Israel gwich'in nąįį veh'an gwihil'ee gweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nijin Simeon ąįį tr'iinin eenjit jyaa diinyą' dąį' ąįį viyehghan nąįį geenjit deegiheenjyaa gaa gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon ąįį Vit'eegwijyąhchy'aa gook'aa nahaandal ts'ą', goovaa heelyaa eenjit oahkat ąįįtł'ęę yahan Mary ąįį t'ahnyąą. “Jii tr'iinin K'eegwaadhat gwitee tr'iiyąąhchįį, ąįįt'ee Israel gwich'in lęįį nąįį ndak gahahchyaa ts'ą' chan lęįį nąįį chan zhak gahahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","K'eegwaadhat goots'ą' yihił'e', ąįį eenjit lęįį nąįį giinehts'į' giheehkhyaa jyąhts'ą' t'ee nats'ąą niinjich'agadhat gwigweheechy'aa. Ąįįts'ą' tr'igwindii akwat khaiinjich'inadhat t'ee shrii haa nidrii tr'it'ii haa nihk'it t'igweheechy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Izhit zhat dąį' Asher Gwich'in, Phanuel oaazhii, ąįį vichi' tr'injaa Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ąįį Anna oaazhii. Shyaaghan nilii, ts'ą' 7 years gwizhrįh veerindi'. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ąįįts'ą' ąįį gwats'an chan 84 years neeroonjii kwaa. Khit Kharigidiinjii Zhee Gwachoo gihłeehahkhaii kwaa, drin, tǫǫ haa zhat ninidik ts'ą' K'eegwaadhat ts'ą' nikiigwąh'ee. Jyąhts'ą' t'ee geetee hee ch'ihłee adach'aa'aa kwaa ts'ą', chan khadigiinjii ts'ą' gwizhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Izhit zhat Anna nihdeiinzhii ts'ą' Vit'eegwijyąhchy'aa ts'ą' mahsį' nyąą ts'ą' khadigiinjii. Ąįįts'ą' K'eegwaadhat Jerusalem gwats'ą' tr'iheendal eenjit nagwal'in nąįį eenjit ts'ą' ąįį tr'iinin eeginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nijin K'eegwaadhat va-law deenyąą gwik'it t'iizhik dąį' tł'ęę Galilee nahkat dagakwaiik'it Nazareth gwits'eegahoo'oo. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jii tr'iinin dink'indhat ts'ą' chan nint'aii, gwiizhit vigwizhi' chan gwanlii, Vit'eegwijyąhchy'aa vich'eegoonzhrii vaa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Shreenyaa zhat neegwiidhak hee Jesus viyehghan nąįį Jerusalem, Passover googwahahtsyaa eenjit, gwits'eegihiidal. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ch'ihłan Jesus tr'iinin vaghaii ch'ihłoaatin ts'ą' neekwaii nilii dąį' chan izhit nagaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ąįį Passover shriit'agwahkhyuk gwahaadhat ąįįtł'ęę t'ee Mary, Joseph haa Nazareth gwits'eegahoo'oo gaa Jesus ąįį Jerusalem dhidii. Viyehghan nąįį izhit dhidii giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Juu nąįį haa geedaa, haa dhidii giiyuunyąą ts'ą' drin datthak giinjil ąįįtł'ęę dagalak ts'ą' vijyaa nąįį tee neegogwąą'in ");
INSERT INTO gwiNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","akhai' hiljii. Ts'ą' t'ee giiyinkeegwahaah'yaa eenjit Jerusalem gwits'eegahoo'oo. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Drin tik gwiindhat ąįįtł'ęę Kharigidiinjii Zhee Gwachoo gwizhit, Dęhtły'aa Choh Gǫąąhtan nąįį haa dhidii ts'ą' gwinzii goovołk'įį gwizhit goovahkat, giineegwah'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ąįį yuułk'įį nąįį gwintł'oo ch'iitth'ak ts'ą' gwinzii gwidii ginkhii eenjit łyaa goovandaa t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Viyehghan nąįį nijin Dęhtły'aa Choh Gǫąąhtan nąįį haa giiyąh'in dąį' łyaa geegagoolii kwaa goots'an goodlit. Vahan t'iiyahnyąą, “Shizhuu, deeni'in t'ini'in? Niti' haa khyų' nankarantii dąį' łyaa tsineeroolii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Akhai' t'agoovahnyąą, “Jaghaii shinkeegoh'in? Shiti' vizheh hihdyaa gaakhwandaii shrǫǫ nihthan?” ");
INSERT INTO gwiNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Gaa deenyąą t'inyąą giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jesus ts'ą' goovaa Nazareth gwits'eehoozhii ts'ą' izhit gook'eegwiłthat. Vahan, Jesus dee'ya' ts'ą' deiinyą' datthak didrii zhit gwił'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus dink'indhat ts'ą' gwandaa goonzhįį dhidlit. ąįįts'ą' t'ee Jesus Vit'eegwijyąhchy'aa ts'ą' dinjii nąįį haa łyaa shoo ąhtsii. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberias Caesar, Roman gwakhaihkwaii choh, ąįį izhit zhat gwa'an nihky'aa nankat gwintsii goodlii datthak łąą 15 years gwizhit k'eegwaadhat nilii. Pontius Pilate chan izhit dąį' Judea nahkat gwats'ą' k'eedeegwaadhat. Herod Antipas chan izhit dąį' Galilee nahkat gwats'ą' k'eegwaadhat. Ąįį vachaa Philip chan Iturea nahkat, Trachonitus nahkat haa geenjit k'eegwaadhat nilii. Lysanias chan Abilene nahkat gwats'ą' k'eegwaadhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Dinjii Annas chan ts'ą' Caiaphas haa chan ndak khii giinkhih choh ginlii. Zechariah vigii John zhat dąį' Vit'eegwijyąhchy'aa viginjik haa yits'ą' nideech'iin'ąįį, oo'ok nangwinjir gwa'an hee. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ąįįts'ą' t'ee John zhit Jordan han gwinjik geeghaih gwa'an nahkat datthak łąą k'eekhwazhii. “Nakhwatr'agwaanduu gwats'an łihts'eedǫǫ'ee ts'ą' geenjit nakhwats'an chųų ilii, ąįįtł'ęę t'ee Vit'eegwijyąhchy'aa nakhwatr'agwaanduu nakhweenjit oo'an gweheelyaa,” jyaa nyąą ts'ą' geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ąįįt'ee Isaiah Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii jii kwaii dęhtły'aa zhit geenjit gwadanakhwatł'oo, “Nangwinjir gwa'an tr'azhral gwigwiitth'ak ts'ą' jyaa digwinyąą; ‘K'eegwaadhat vits'ii tąįį gwinjik shrigwinlii ts'ą' k'iindaa tąįį k'igwąą'ee heekhaa veenjit nagwiintthaii! Nangwinjir gwa'an shraa haa tr'azhral goohtth'ak: K'eegwaadhat vidivee tąįį eenjit shragohłii! Geh'ok chan kwaa ts'ą' k'iindaa k'igwąą'ee veenjit nagoh'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nakhwadeekwaii zhak neegohdii gwachoh goo'aii ji' k'igwąą'ee neegohtsii! Taih akwat ddhah choh kwaii datthak k'igwąą'ee nohtsii! Tąįį k'igwąą'ee gwanlii kwaa kwaii k'igwąą'ee neegohtsii! Nideekwaii gwiizųų kwaii gwinzii neegohtsii! ");
INSERT INTO gwiNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jii nankat gwidinjii datthak K'eegwaadhat vineegweezhii gwahąąh'yaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Lęįį nąįį chųų goots'an gweheelyaa eenjit John ts'ą' gahaajil jyaa goovahnyąą, “Gyųų choh ts'an deedhaa nąįį! It'ee niighit kwaa Vit'eegwijyąhchy'aa vats'an khaiinjich'akhwaghit gwideetaa hohdaa nohthan? ");
INSERT INTO gwiNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nats'ąą nakhwatr'agwaanduu ts'an łihts'eedǫǫ'ee geenjit gogoohch'in! ‘Yeenii diilak Abraham ts'an deedhaa,’ jyaa nihłohnyą' shrǫ'! Nakhwaagwahaldak! K'eegwaadhat jii kii kwaii ji' gaa Abraham ts'an deedhaa hahtsyaa t'oonchy'aa gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jidii ts'iivii vakat jak gwinzii nahshii kwaa ąįį vadachan daa'aii haa tr'iheekyaa goo'aii ts'ą' heek'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dinjii nąįį giiyųąhkat, “Akwaa ji', deegwehee'yaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","“Juu ik neekwaii di'įį, ąįį di'ik ch'ihłak zhit dinjii ch'ihłee vi'ik kwaa ąįį antł'eeyahahchal, ąįįts'ą' juu vishii gwanlii chan oo'ok gwantł'eeyahahchaa,” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tax eenjit laraa oonjii nąįį chan chųų goots'an heelyaa eenjit giits'ą' haajil, ts'ą' giiyųąhkat, “Geech'ǫąąhtan, deegwehee'yaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Laraa daanchy'aa hohtsyaa goo'aii gwandaa t'ąąnchy'aa ǫhjii shrǫ',” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Niveet'ah'in lat nąįį chan giiyųąhkat, “Diikhwan ąįį yu', deegwehee'yaa t'oonchy'aa?” giiyahnyąą. “Zhyaa dinjii ts'an laraa tr'ohłyaa shrǫ', ąįįts'ą' geenjit kwaa zhyaa dinjii iizųų dohnyą' shrǫ'! Jidii laraa ohtsii haa shoo ǫhłįį,” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Izhit dąį' dinjii lęįį nąįį Christ goots'ą' tr'ahah'aa googwahąąh'yaa eenjit nagogwal'in ts'ą' John ąįį adan t'inchy'aa shrǫǫ giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John t'agoovahnyąą, “Chųų nakhwats'an ałtsii, gaa shandaa t'ahtsii ąįį ahaa t'oonchy'aa, vakwaiitryaa dineehih'at gaa geenjit ihsįį kwaa. Adan ąįį Ch'anky'aa Shroodiinyąą ts'ą' kǫ' haa nakhwats'an chųų hahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tł'ooli' vaa ineech'ariitthak khaltin ąįį haa wheat nizįį kwaii gwitee tr'iheelyaa ts'ą' dadrah zhit nihdeeheelyaa geenjit gaa, zhit tł'ooli' wheat iizųų kwaii kǫ' nikyaa kwaa zhit yiheelyaa ts'ą' khit geenjit heek'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","John nihłehjuk gwinlęįį dinjii nąįį K'eegwaadhat Vagwandak Nizįį haa gwaandak haa geegoovołtin. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gaa John ąįį Herod Governor khit ch'ats'ą' t'ahnyąą, doondee'at Herodias noonjik ts'ą' chan gwinlęįį gwiizųų tr'agwah'ya' geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ąįįtł'ęę Herod, John zhee gwaazhrąįį naachįį dąį' gwandaa gwiizųų t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Dinjii nąįį datthak chųų goots'an dhidlit ts'ą', Jesus chan chųų vats'an dhidlit. Khagidiinjii gwiizhit zheezhit nihky'aa t'igwiizhik gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ąįįts'ą' Ch'anky'aa Shroodiinyąą, dziitsal dove k'it t'inchy'aa vakat needaanąįį. Ąįįtł'ęę gwideezhuh zheekat gwats'an jyaa nyąą, “Shidinji', łi'haa neet'iihthan ts'ą' łyaa nashoo ahłįį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nijin Jesus 30 years nilii gwanaa dąį' t'ee tr'ookit geech'ǫąąhtan, dinjii nąįį datthak Joseph vigii t'inchy'aa gwich'in giiyuunyąą. Jii nąįį t'ee ts'an deedhaa: Joseph t'ee Heli vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli chan Matthat vidinji' nilii, Matthat chan Levi vidinji' nilii, Levi chan Melchi vidinji' nilii, Melchi chan Jannai vidinji' nilii, Jannai chan Joseph vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph chan Mattathias vidinji' nilii, Mattathias chan Amos vidinji' nilii, Amos chan Nahum vidinji' nilii, Nahum chan Esli vidinji' nilii, Esli chan Naggai vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai chan Maath vidinji' nilii, Maath chan Mattathias vidinji' nilii, Mattathias chan Semein vidinji' nilii, Semein chan Josech vidinji' nilii, Josech chan Joda vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda chan Joanan vidinji' nilii, Joanan chan Rhesa vidinji' nilii, Rhesa chan Zerubbabel vidinji' nilii, Zerubbabel chan Shealtiel vidinji' nilii, Shealtiel chan Neri vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri chan Melchi vidinji' nilii, Melchi chan Addi vidinji' nilii, Addi chan Cosam vidinji' nilii, Cosam chan Elmadam vidinji' nilii, Elmadam chan Er vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er chan Joshua vidinji' nilii, Joshua chan Eliezer vidinji' nilii, Eliezer chan Jorim vidinji' nilii, Jorim chan Matthat vidinji' nilii, Matthat chan Levi vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi chan Simeon vidinji' nilii, Simeon chan Judah vidinji' nilii, Judah chan Joseph vidinji' nilii, Joseph chan Jonam vidinji' nilii, Jonam chan Eliakim vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim chan Melea vidinji' nilii, Melea chan Menna vidinji' nilii, Menna chan Mattatha vidinji' nilii, Mattatha chan Nathan vidinji' nilii, Nathan chan David vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David chan Jesse vidinji' nilii, Jesse chan Obed vidinji' nilii, Obed chan Boaz vidinji' nilii, Boaz chan Salmon vidinji' nilii, Salmon chan Nahshon vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon chan Amminadab vidinji' nilii, Amminadab chan Admin vidinji' nilii, Admin chan Arni vidinji' nilii, Arni chan Hezron vidinji' nilii, Hezron chan Perez vidinji' nilii, Perez chan Judah vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah chan Jacob vidinji' nilii, Jacob chan Isaac vidinji' nilii, Isaac chan Abraham vidinji' nilii, Abraham chan Terah vidinji' nilii, Terah chan Nahor vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor chan Serug, vidinji' nilii, Serug chan Reu vidinji' nilii, Reu chan Peleg vidinji' nilii, Peleg chan Eber vidinji' nilii, Eber chan Shelah vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah chan Cainan vidinji' nilii, Cainan chan Arphaxad vidinji' nilii, Arphaxad chan Shem vidinji' nilii, Shem chan Noah vidinji' nilii, Noah chan Lamech vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech chan Methuselah vidinji' nilii, Methuselah chan Enoch vidinji' nilii, Enoch chan Jared vidinji' nilii, Jared chan Mahalaleel vidinji' nilii, Mahalaleel chan Cainan vidinji' nilii, ");
INSERT INTO gwiNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainan chan Enos vidinji' nilii, Enos chan Seth vidinji' nilii, Seth chan Adam vidinji' nilii, Adam chan Vit'eegwijyąhchy'aa vidinji' nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus Ch'anky'aa Shroodiinyąą vizhit deedąą'ąį' ts'ą' Jordan gwats'an k'inidik ts'ą' Ch'anky'aa k'iighai' nangwinjir gwa'an gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Izhit zhat Ch'anky'aa Tr'aanduu drin 40 gwizhit datthak yik'eegwandaii. Gaakhyuk datthak ch'in'al kwaa ts'ą' ndaagwąą'ąį' dąį' vizhit gwiłts'ik. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ch'anky'aa Tr'aanduu t'iiyahnyąą, “Vit'eegwijyąhchy'aa Vidinji' inlii ji', jii kii, łųhchy'aa ąhtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","“Dęhtły'aa Choh kat gwadanakhwatł'oo, ‘Duuyeh dinjii łųhchy'aa k'iighai' gwizhrįh gwandaii gwinyąą t'oonchy'aa,’” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ąįįtł'ęę Ch'anky'aa Tr'aanduu ddhah kiit'ik niiyąąhchįį ts'ą' nahkat datthak yits'ą' gwizhrįh nigwiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Jii nahkat datthak gwats'ą' k'eegwahandhat ts'ą' gwintsii nigwihin'aa. Jii datthak shantł'eegwiriin'ąįį ts'ą' juu nihthan antł'eegwihih'aa ji' gaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Shats'ą' khagidiinjii ji', jii datthak ts'an gwahan'yaa,” Ch'anky'aa Tr'aanduu yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus t'iiyahnyąą, “Dęhtły'aa Choh kat gwadanakhwatł'oo, ‘Vit'eegwijyąhchy'aa Nik'eegwaadhat ąįį zhrįh veenjit gwitr'it tr'agwah'in ts'ą' vats'ą' khadigiinjii!’” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ąįįtł'ęę Ch'anky'aa Tr'aanduu, Jerusalem gwizhit Kharigidiinjii Zhee Gwachoo gwikiit'ik Jesus nąąhchįį ts'ą' t'iiyahnyąą. “Vit'eegwijyąhchy'aa Vidinji' inlii ji' dzaa k'iizhak neehantłit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“Dęhtły'aa Choh kat gwadanakhwatł'oo, ‘Vit'eegwijyąhchy'aa ąįį vats'an zheekat gwich'in nąįį nats'ą' hah'aa ts'ą' nik'eegahąąhtyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Daganli' haa ndak nagooheetą' ts'ą' duuyeh gaa kii kat nakwai' ts'iighit gwinyąą,’” Ch'anky'aa Tr'aanduu yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesus t'iiyahnyąą “Dęhtły'aa Choh zhit jyaa deegwinyąą, ‘Vit'eegwijyąhchy'aa Nik'eegwaadhat zhyaa shroondaii tsinteerookaii shrǫ'!’” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nijin Ch'anky'aa Tr'aanduu nats'ahts'ą' datthak Jesus shroondaii tsinteehąąhkaa gwik'eegoonjik ąįįtł'ęę ch'ihłee yiłeehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ąįįtł'ęę Jesus ąįį Galilee gwats'ą' gwa'an neehoozhii. Ch'anky'aa Shroodiinyąą vat'aii vaa nilii ts'ą' izhit nahkat gwa'an datthak vagwandak goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Israel nąįį tr'igiinkhii zheh kwaii gwizhit geech'ǫąąhtan eenjit juu nąįį datthak dinjii nizįį giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ąįįtł'ęę Jesus Nazareth gwats'ą' haazhii, izhit t'ee dink'iindhat. Neegwaazhii Drin gwiizhit Israel nąįį tr'igiinkhii zheh gwits'eehooniindik, chy'aa gwats'ą' chan hee neehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dęhtły'aa Choh kat giheehkhyaa eenjit ndak niinzhii ąįįts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii Isaiah oaazhii Vidęhtły'aa giiyintł'eiin'ąįį. Ąįį dęhtły'aa zhit nijin jii gwadanakhwatł'oo googwąh'ąįį, ");
INSERT INTO gwiNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“Vit'eegwijyąhchy'aa ts'an vanky'aa shaanilii, neeshraahchy'aa nąįį ts'ą' Gwandak Nizįį hih'aa eenjit gwitee tr'ashąąhchįį geh'an juu viteegwirįłjik nąįį geenjit kwaa chineereheelyaa eenjit nakhwats'ą' shirihił'e'. Ąįįts'ą' chan vandee kwaa nąįį gwąąh'in neehałtsyaa. Juu tr'eeroaadhan nąįį ineehihdal ts'ą' chan zhat nigwiindhat ji' zhit juu Vit'eegwijyąhchy'aa neeyahshii nąįį jyaa davahaihjyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus dęhtły'aa nihts'ą' noonjik ts'ą' zhit juu gwats'ą' k'eegwaadhat nilii nąįį intł'ineeyin'ąįį ąįįtł'ęę naadii. Israel nąįį tr'igiinkhii zheh gwizhit dinjii nąįį datthak aakin giiyaa'įį gwizhrįh t'igiiyahthan. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ąįįts'ą' jyaa goovahnyąą. “Jii Dęhtły'aa Choh kat nakhwats'ą' geegwaldak goohtth'ak ąįįt'ee deegweheenjyaa gwinyąą t'ee juk gwik'it t'igwii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Łyaa geegagoolii kwaa, dinjii nizįį giiyahnyąą ts'ą' gwinzii ginkhe' eenjit giiyeenjit jyaa ginyąą. “Jii lee Joseph vigii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ąįįts'ą' jyaa goovahnyąą, “Jii t'ee jyaa shahǫǫhjyaa gaashandaii. ‘Iłts'ik shrinilii inlii, ąįį geenjit adats'ą' tr'iinjii lee.’ Capernaum gwizhit deegwiizhik t'igwinyąą chan dzaa shakwaiik'it gwizhit jyaa diinjii shahǫǫhjyaa gaashandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jii jyaa nakhwahaihjyaa.” Jesus nyąą, “Zhit juu Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį khit dagakwaiik'it gwizhit gihil'ee kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Shoodǫǫhk'įį! Elijah gwandaii gwanaa dąį' Israel nahkat gwizhit tr'injaa vakai' niindhat nąįį gwanlii łyaa t'igwinyąą, izhit dąį' 3½ years datthak ąhtsin kwaa ts'ą' chan lęįį nąįį nankat ihdeengaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Googaa Israel gwats'ą' ch'ihłak eenjit gaa hił'e' kwaa gaa tr'injaa vakai' niindhat ąįį Zarephath gwich'įį, izhit geeghaih kwaiik'it Sidon nahkat izhit gwizhrįh gwats'ą' Elijah hił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Elisha t'ee Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii gwandaii gwanaa dąį' zhit juu Israel gwich'įį lęįį nąįį gwatthąį' ahjat (leprosy) haa iłts'ik haa khaiinjich'igiighit, gootee ch'ihłak gaa shranąąnjii kwaa, gaa dinjii Naaman oaazhii, Syria nahkat gwats'an ahaa zhrįh shranaazhik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nijin Israel nąįį tr'igiinkhii zheh gwizhit dinjii nąįį jii gwigwiitth'ak dąį' gook'įį goodlit ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ndak nagaakhin ts'ą' Jesus kwaiik'it cheegihiłchįį ts'ą' taih kat gwats'ą' giiyihiłchįį, izhit t'ee kwaiik'it nigwigwiin'ąįį. Tł'eedik gwats'an drihdit'eerookhii giiyuunyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","gaa dinjii gwanlii gwats'an gootee tr'ineezhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ąįįtł'ęę Jesus ts'ą' Galilee nahkat gwizhit kwaiik'it Capernaum k'idik. Zhat Neegwaazhii Drin dąį' Israel nąįį tr'igiinkhii zheh gwizhit dinjii nąįį gǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Geegagoolii kwaa gwik'it geech'ǫąąhtan, viginjik nint'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Izhit gwizhit dinjii ch'ihłee ch'anky'aa iizųų vizhit, ąįį Jesus ts'ą' khashraa'iintrat, ");
INSERT INTO gwiNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus Nazareth kwaiik'it gwats'an inkhaa, jidii diinanh niindhan? An diihahtsyaa lee t'ini'in? Juu t'iinchy'aa naashandaii! Vit'eegwijyąhchy'aa vats'an Shroodiinyąą t'iinchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus t'iiyahnyąą, “Didhiinyąą ts'ą' ąįį dinjii vats'an tr'inidii!” ąįį dinjii ch'anky'aa iizųų neet'eeyahnąįį ts'ą' yats'an tr'ineezhii gaa ts'idiiyahthat kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Datthak gihilghaa ts'ą' t'inihłagaanyąą, “Nats'ahts'ą' yeenjit ginjik di'įį t'inyąą? Ch'anky'aa iizųų nąįį, gaa yik'eegwahthat!” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Izhit geendih datthak Jesus deezhik gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus Israel nąįį tr'igiinkhii zheh gwats'an Simon vizheh gwats'ą' haazhii. Simon vach'ootr'į' iłts'ik ts'ą' łyaa vatthąį' nindhaa, ąįįts'ą' Jesus giiyeenjit akǫǫ t'ahnyą'. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yits'ą' haazhii ts'ą' yidehk'it gwik'eevee yits'ą' niinzhii, ts'ą' ts'ik akǫǫ t'ahnyąą, ąįįtł'ęę ts'ik akhayuunyąą. Ąįįtł'ęę zhat ninehjin ts'ą' zhat gooveegwitr'it t'igwihił'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gwik'ich'iin'ąįį ąįį tł'ęę, juu dinjii ts'ik nihłehts'į' daazhyaa di'įį, Jesus ts'ą' nagoogiinlii. Datthak ts'ą' danli' haa gookat naanjik, ts'ą' gooveenjit gwinzii neegwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ch'anky'aa iizųų nąįį gaa gwich'in lęįį nąįį ts'an tr'iinjil, ts'ą' ch'anky'aa iizųų nąįį zhral haa, “K'eegwaadhat Vidinji' t'inchy'aa! Geegiheehkhyaa kwaa geenjit Jesus akǫǫ t'agoovahnyąą, ts'ą' Jesus gahahchįį kwaa goovąh'įį, Christ nilii giiyaandaii geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Neeyahkaa gwizhit Jesus kwaiik'it gihłeehaazhii, ts'ą' t'oołii tthan gwats'ą' haazhii. Gwich'in nąįį giiyųųkeegwah'in, ąįįtł'ęę nijin giigwąh'ąįį dąį', neeheedyaa gwits'į' zhak giiyųųntą' gwik'eegwigoonjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gaa t'agoovahnyąą, “Ch'adanh kwaiik'it gwa'an K'eegwaadhat Veegwinii'ee gwizhit gwandak nizįį eegwahaaldak gwat'aałchy'aa geenjit, K'eegwaadhat gwats'ą' shihił'e'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ąįįtł'ęę Judea nahkat gwizhit Israel nąįį tr'igiinkhii zheh datthak gwizhit gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","2","Ch'ihłan Jesus Gennesaret Van khyųų nadhat ts'ą' dinjii lęįį nąįį Vit'eegwijyąhchy'aa viginjik eegoovaagwaandak, gaa łyaa vaa gwiłtł'at gwiizhit tr'ihchoo neekwaii teedhidlit. Łuk kee'in nąįį teegaajil ts'ą' digichihvyaa k'eech'agahtryaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Izhit gwiizhit Jesus, Simon haa vitr'ihchoo eeniinzhii ts'ą' Jesus t'iiyahnyąą, “Nitr'ihchoo gwiintsal ndaavąąhtrit. “Ts'ą' tr'ihchoo zhiinzhii ts'ą' geedan Simon vijyaa chan giihaa gwizhiinjil ts'ą' ndaagiich'iinthaii. Oondaa shrii t'agwahthee tr'ihchoo nagaahłit, gwats'an ąįį dinjii nąįį ts'ą' ginkhii. It'ee iltł'at kwaa ts'ą' ginkhii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Giinkhe' ąįįtł'ęę Simon ts'ą', nil'ee ts'ą', t'iiyahnyąą “Chan oondaa hohkwaii ts'ą' chihvyaa chuhłii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Akhai' Simon t'iiyahnyąą, “Shigeech'ǫąąhtan, tǫǫ datthak gwiintł'oo łuk keeree'ya' googaa łuk tr'oonjik kwaa. Jyaa diinyąą geh'an, chan chihvyaa chineereheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Oondaa chan tr'ihchoo neegehiłit digichihvyaa chineegiinlįį. Niighyuk gwahaadhat kwaa ts'ą', ch'ihłak zhit łuk goodlit, ts'ą' chihvyaa khaiinjii łahchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ąįįts'ą' gee'at digitsyaa nąįį aanaii agahnyąą ts'ą' tr'ihchoo neekwaii zhit łuk deedigiinlii. Tr'ihchoo nihłaa ts'ą' it'ee shri' nidii ts'ą' khaiinjii gaa chiinlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Simon deegwii'in t'igwii'in gwiky'aanjik dąį' Jesus ts'ą' nikiigwiintthaii t'ee t'iiyahnyąą, “Łyaa K'eegwaadhat inlii, dinjii nizįį ihłii kwaa gwiizhit jaghaii naa hihłyaa t'iinyąą gaashandaii kwaa! “Łuk lęįį goonjik geenjit James, John, gooti' Zebedee chan ts'ą' digijyaa nąįį haa łyaa geegagoolii kwaa giveenjit t'igwiizhik.” Akhai' Jesus, Simon Peter t'ahnyąą, “Nanjat kwaa, juk gwats'an dinjii nąįį teegwahąhdal t'oonchy'aa, łuk teegǫhjii gwik'it.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Teegaajil dąį' jidii datthak akhagoonyąą ts'ą' Jesus tąįį gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ch'ihłok Jesus ąįį kwaiik'it dhidii izhit dinjii ch'ihłak ąįį vatthąį' ahjat (leprosy) haa iłts'ik. Nijin Jesus niił'in dąį', dinin haa yats'ą' nikiigwiintthaii ts'ą' jyaa diyahnyąą. “Shik'eegwaadhat, geet'iindhan ji' shats'ą' tr'iinjii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus yakak naanjik ts'ą' t'inyąą. “Jyaa dihthan t'oonchy'aa ąįįts'ą' juk it'ee nakat gweheezyaa! “Zhat łąą vakat gwinzii neegahoodlit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus jyaa diyahnyąą, “Ch'ihłak gaa haagwandak shrǫ' gaa giinkhih ts'ą' hinkhaii ts'ą' nakat gwinzii neegahoodlit vats'ą' googwąąhch'in. Ąįįts'ą' Dęhtły'aa Choh zhit Moses deegweheenjyaa goo'aii nyąą gwik'it t'ini'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gaa Jesus deezhik vagwandak goodlit ts'ą' dinjii lęįį giiyuuhaaky'aa ts'ą' goots'ą' tr'iheendal eenjit giits'ą' hijyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gaa adan ąįį t'oohłii dinjii kwaa gwa'an gwits'eehidik ts'ą' khagidiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ch'ihłan drin Jesus geech'ǫąąhtan gwiizhit, Galilee chan ts'ą' Judea nahkat chan ts'ą' Jerusalem gwats'an kwaiik'it gwatsal datthak gwats'an Pharisee chan ts'ą' Law eech'ǫąąhtan nąįį datthak zhat giilk'ii. Jesus ąįį Vit'eegwijyąhchy'aa vat'aii vaa-nilii, iłts'ik nąįį yaa shrineeheelyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Izhit gwiizhit dinjii lat nąįį dinjii ch'ihłak k'ęhdik dhidlit ąįį dehk'it doodii gwiizhit neegahahchik, ąįįts'ą' Jesus eeghaii nigiihiłchįį gaa tr'ihkhit zheh gwizhit dinjii gwanlii ts'ą' khyų' gindeiinvyaa k'it k'ii'an nihdeegiiyąąhchįį. Ąįįts'ą' zheh gwakat deegiiyiłchįį gwats'an k'iidąą geeyeechy'a' k'iizhak dinjii tee Jesus eeghaii neegiiyąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nijin Jesus deegwahtł'oo giik'injiighit gwiky'aanjik dąį' ąįį dinjii jyaa ahnyąą, “Shijyaa, natr'agwaanduu oo'an gwahaadlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jii kwaii datthak geh'an ąįį Pharisee chan ts'ą' Law eech'ǫąąhtan nąįį haa jyaa dinihłagaanyąą, “Jii juu dinjii nilii Vit'eegwijyąhchy'aa jyąhts'ą' hił'ee kwaa t'inyąą? Dinjii ch'ihłak gaa duuyeh gwik'it t'ii'in gaa Vit'eegwijyąhchy'aa ji' gwizhrįh diitr'agwaanduu diineenjit oo'an gweheelyaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus jyaa deegiindhan goovandaii ts'ą' jyaa goovahnyąą, “Jaghaii jyąhts'ą' geenjit ninjich'ǫhthat? ");
INSERT INTO gwiNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Jidii shrit t'igwehee'yaa ąįį gogwantrii kwaa? Dinjii atr'agwaanduu oo'an gwireheelyaa akwat dinjii k'ęhdik dhidlit shrineereheelyaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Juk nakhwats'ą' googwahaałkyaa, nats'ąą Gwidinji' ihłii ts'ą' gwatr'agwaanduu oo'an gwihihłyaa geenjit.” Ąįįts'ą' ąįį dinjii k'ęhdik nilii ąįį t'ahnyąą, “Ndak nineenjii ts'ą' nidęhk'it oo'an nizheh gwits'eegwihiin'ąįį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Zhat łąą ąįį dinjii goovandah ndak ninehjin ts'ą' didehk'it oo'an dizheh gwits'eehaa'ąįį. Vit'eegwijyąhchy'aa deehiił'e' ts'ą'. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Łyaa geegagoolii kwaa gooveenjit t'igwiizhik! Datthak naajat haa Vit'eegwijyąhchy'aa deegihiił'ee ts'ą' jyaa diginyąą, “Łyaa geegwaroolii kwaa. Juk drin diinandah t'igwiizhik!” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jii ąįįtł'ęę, Jesus kwaiik'it gihłeehoozhii akhai' tax eenjit laraa oonjii nilii Levi oaazhii zhat gwa'an dhidii nah'in ts'ą' jyaa diyahnyąą, “Shatąįį hinkhaii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi ndak niinzhii ts'ą' zhat jidii datthak akhoonyąą ts'ą' yaahaazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ąįįtł'ęę Levi ąįį Jesus eenjit gwintł'oo ch'arehee'aa gwiłtsąįį, zhat chan tax eenjit laraa oonjii lęįį nąįį ąįįts'ą' ch'izhii dinjii lęįį nąįį chan zhat goovaa neech'aga'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ąįį Pharisee chan ts'ą' Law eech'ǫąąhtan nąįį Jesus vitsyaa nąįį ts'ą' gitr'igii'ee haa googaahkat, “Jaghaii nakhwan chan ts'ą' Jesus haa tax eenjit laraa oonjii nąįį ts'ą' zhit gwa'an dinjii vatr'agwaanduu gwanlii nąįį haa neech'oh'aa t'akhwa'in?” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Akhai' Jesus jyaa goovahnyąą, “Juu dinjii gwinzii gwandaii dinjii k'ahaanjii t'aahchy'aa kwaa t'oonchy'aa. Juu iłts'ik nąįį zhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Dinjii nizįį nąįį gootr'agwaanduu gweheelyaa gwits'į' eenjit dzaa gwats'ą' hoiizhii kwaa t'oonchy'aa gaa zhit juu vatr'agwaanduu gwanlii nąįį eenjit t'ishi'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jesus t'agahnyąą “Zhit John gweedhaa datthak vitsyaa chan ts'ą' Pharisee gootsyaa nąįį haa adach'agaa'aa kwaa ts'ą' khadigigiinjii gaa nan nitsyaa nąįį adach'agaa'aa gwiizhit jak chų' chan giinįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus t'agoovahnyąą, “Zhit juu goohaanjik zhat dhidii gwiizhit zhat vijyaa nąįį gooch'arahah'aa kwaa shrǫǫ niindhan? Łyaa duuyeh! ");
INSERT INTO gwiNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gaa nijin drin dinjii goohaanjik gihłeerihiłchįį ji' t'ee duuyeh ch'aga'aa gooveenjit goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus jii gwandak zhit haa geegoovąąhtan, “Dinjii ch'ihłak gaa duuyeh ik k'eejit łahchy'aa ts'ą' ik ch'aa kat k'anaahkaii t'oonchy'aa. Jyaa diizhik ji' zhit ik k'eejit ąįį iizųų hahtsyaa ts'ą' zhit ik ch'aa kat gwinzii vigweheechy'aa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ąįį gwik'it chan dinjii ch'ihłak gaa duuyeh jak chų' nizįį ąįį jak tyah ch'aa zhit yinjaa t'oonchy'aa, jyaa diizhik ji', zhit jak chų' nizįį ąįį jak tyah ch'aa łeehahch'aa ts'ą' jak chų' an heelyaa gwiizhit jak tyah iizųų hahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ąįį geh'an jak chų' nizįį ąįį jak tyah k'eejit zhit gwizhrįh tr'iheenjaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ąįįts'ą' chan ch'ihłak gaa duuyeh jak chų' jat eenį' tł'ęę jak chų' k'eejit dinįį t'oonchy'aa. ‘Jak chų' jat ąįį gwandaa nizįį!’ jyaa yahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ch'ihłan Neegwaazhii Drin Jesus, vitsyaa nąįį haa gwanzhįh tł'oo li' nahshii gwa'an geedaa. Gwiizhit vitsyaa nąįį dagantł'ee tł'oo li' nahshii tee giitee gihłeegwigwihilii ąįįtł'ęę giiyaajyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jesus vitsyaa nąįį gwanzhįh tł'oo li' gaajyaa. Pharisee nąįį googwąąh'in ts'ą' t'agoogahnyąą, “Jaghaii juk drin tr'agoh'in? Jyąhts'ą' gwik'injiriighit kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus t'agoovahnyąą, “Yeenii David chan ts'ą' juu yaa nilii nąįį haa goozhit gwiłts'ik dąį' deegiizhik ąįį Dęhtły'aa Choh zhit geenjit deegwinyąą ganoondaii? ");
INSERT INTO gwiNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David ąįį zheh gwadhah vizhit kharigidiinjii dehk'it goo'aii izhit nihdeiinzhii ts'ą' łųhchy'aa Shroodiinyąą iin'al ąįįtł'ęę yalat chan yaa nilii nąįį goovantł'ahtsit. Jyaa digwehee'yaa kwaa goo'aii ts'ą' giinkhih nąįį zhrįh ya'aa gaandaii googaa gwik'it t'iizhik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“Shįį Gwidinji' t'ihchy'aa ąįį geh'an dinjii nąįį Neegwaazhii Drin deegoo'ya' goovoihnyąą gwik'it t'igihee'yaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ch'adanh Neegwaazhii Drin gwiizhit Jesus Israel nąįį tr'igiinkhii zheh nihdineezhii, ts'ą' geech'ǫąąhtan akhai' izhit gwizhit dinjii shriits'ąįį vanli' iłchįį dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Pharisee chan ts'ą' Law eech'ǫąąhtan nąįį (Scribes) haa chan zhat giilk'ii ts'ą' giik'aahtii, Neegwaazhii Drin zhit dinjii vanli' shrineeheelyaa ji' geenjit, jyaa diizhik ji' gwiizųų t'ii'in giihaanjyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gaa ąįį Jesus deegiindhan goovandaii ts'ą' ąįį dinjii vanli' iłchįį dhidlit t'ahnyąą “Aanaii dzaa gwatł'an shats'ą' hinkhaii.” Ąįį dinjii yeeghaii niinzhii tł'ęę dinjii nąįį oahkat, ");
INSERT INTO gwiNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","“Dęhtły'aa Choh zhit gwa'an nik'ee Neegwaazhii Drin gwizhit gwits'eediireen'yaa nik'ee geenjit gwadanakhwatł'oo? Jidii shrit t'igwehee'yaa, dinjii ts'ireheenjyaa akwat ts'arahaatthaa? Dinjii viheekwaa gwits'į' gadarahahchyaa akwat dinjii ęhdaa tr'igwirehee'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus dinjii nąįį datthak tee gwąąh'in ts'ą' ąįį dinjii vanli' iłchįį dhidlit t'ahnyąą, “Nanleetth'ak kwaii nihky'aa oonjii.” Ąįį dinjii jyaa diizhik ts'ą' vanli' nizįį neekhwadlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pharisee nąįį łyaa gook'įį gwanlii ts'ą' Jesus deegahah'yaa geegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Izhit zhat dąį' Jesus ąįį khadigiheejyaa eenjit taih kat gwats'ą' haazhii, ąįįts'ą' tǫǫ datthak K'eegwaadhat ts'ą' khagideedi'. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","16","Gineech'ahoo'ąįį tł'ęę ditsyaa nąįį aanaii ahnyąą, ts'ą' 12 nąįį gootee gwats'an tr'iinlii. Jii nąįį t'ee Jesus Tr'ihił'e' nąįį goovahnyąą: Simon vachaa Andrew; James, John, Philip, Bartholomew, Matthew, Thomas; Alphaeus vigii James chan; ch'izhii Simon ąįį Zealot nilii chan; Judas vigii James chan; Judas Iscariot t'ee Jesus gwintł'eehahchyaa ąįį chan. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus taih kat k'iidąą goovaaneehoozhii ts'ą' ditsyaa lęįį nąįį haa gwaląįį kat nadhat. Jerusalem, Judea nahkat gwats'an dinjii lęįį nąįį chan zhat dilk'ii, Chųų choh vee gwats'an kwaiik'it Tyre ąįįts'ą' Sidon gwats'an chan. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Giiyuuhaaky'aa ts'ą' chan goots'ą' tr'iheendal eenjit chan. Zhit juu vizhit ch'anky'aa iizųų t'inchy'aa nąįį chan ts'ą' tr'iinjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Juu nąįį datthak giikat nahaandal geetr'agogwah'in, vat'aii łyaa nint'aii ts'ąįį shrineegaanjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus ditsyaa nąįį nah'in ts'ą' t'inyąą, “Nakhwatee juu neeshraahchy'aa nąįį shoo ǫhłįį, ąįį K'eegwaadhat Veegwinii'ee vats'an ǫhłįį! ");
INSERT INTO gwiNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Juk juu nakhwatee vizhit gwiłts'ik nąįį shoo ǫhłįį, nakhwantł'eech'ahaachaa t'oonchy'aa! “Juk juu nakhwatee itree nąįį shoo giheelyaa, hohdlaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Dinjii nakhwatr'ii'ee, nakhwadraii ch'aha'ąįį kwaa ts'ą' gwiizųų nakhwats'ą' ginkhii ts'ą' ohsųų nakhwahnyąą gaa shoo ǫhłįį; Gwidinji' ihłii, shik'injuhkhit geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jyąhts'ą' nats'ą' t'igwii'in dąį', shoh haa ch'oodzaa, zheekat gwizhit nakhweenjit gwinzii gwiintsii goo'aii! Yeenii goolak nąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį ts'ą' jyaa digee'ya' geh'an! ");
INSERT INTO gwiNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Nakhwatee juu valaraa gwanlii nąįį nakhweenjit gwigweheetrii, shroonchy'aa gwizhit gwizhrįh gǫhdaii chy'aa ndaagwąą'ąį'! ");
INSERT INTO gwiNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Nakhwatee juu gwintł'oo ch'a'aa nąįį nakhweenjit gwigweheetrii, Nakhwazhit gwahahts'ik. “Juk juu dlok haa azhral nąįį nakhweenjit gwigweheetrii, tr'agohohdii ts'ą' chan hohtree t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Nakhweenjit gwigweheetrii, nijin dinjii nąįį datthak gwinzii nakhweeginkhii ji', yeenii goolak nąįį jyąhts'ą' t'ee Vit'eegwijyąhchy'aa Eenjit Ginkhii adaa'įį nąįį jyaa dagąįįnyą'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Gaa juu nakhwatee shįįtth'ak nąįį, nakhwats'ą' giihkhii shoodǫǫhk'įį. Juu nakhwats'ą' gwił'ąįį nąįį eet'ohthan, ts'ą' juu nakhwatr'ii'ee nąįį ts'ą' ohsįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Juu nakhwadiveegwiizųų ji' niindhan nąįį nihk'it gooveenjit gwinzii ninjich'ǫhthat ąįįts'ą' juu ts'anakhwaahthat nąįį eenjit khagadǫhjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ch'ihłee ninin nak'ah naat'an ji', ch'angwąhts'ąįį chan neenat'an. Ch'ihłee nach'ada'ik oonjik ji', zhak khii ni'ik chan vantł'ąhtsuu. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ch'ihłee nats'an k'aiich'ii yiindhan ji', vintł'eeyiin'ąįį; ch'ihłee nats'an k'aiich'ii oonjik ji', shintł'ineeroo'aa doiinyą' shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ch'ihłee nats'ahts'ą' nats'ą' dinjii oolį' oiinyąą gwik'it vats'ą' dinjii inlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Zhit juu dinjii neet'iindhan nąįį zhrįh eet'iindhan ji', jaghaii geenjit narahah'aa? Juu tr'agwaanduu tr'agwah'in nąįį gaa jyaa diginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ąįįts'ą' juu nats'ą' nizįį nąįį zhrįh ts'ą' inzii ji', jaghaii geenjit narahah'aa? Juu tr'agwaanduu tr'agwah'in nąįį gaa jyaa diginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ąįįts'ą' juu shineegwahahtsyaa oiinyąą nąįį zhrįh eech'idiintł'oo ji', jaghaii geenjit narahah'aa? Juu tr'agwaanduu tr'agwah'in nąįį gaa ch'izhii tr'agwaanduu tr'agwah'in nąįį eech'adagantł'oo dąį', daanchy'aa gooveedagaantł'oo aanchy'aa shintł'ineeroo'aa giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nakwaa! Juu nats'ą' gwił'ąįį nąįį eet'ohthan ts'ą' goots'ą' ohsįį. Gooveech'idiintł'oo ts'ą' noihjii yuunyą' shrǫ'! Zheekat gwizhit gaayiigootsąįį neenjit gwehee'aa, ts'ą' dakhii Vit'eegwijyąhchy'aa choh Vidinji' hohłyaa. Ąįįt'ee zhit juu iizųų ąįįts'ą' juu mahsį' niindhan kwaa nąįį ts'ą' nizįį t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dinjii neeshraahchy'aa ohnyąą, zheekat Nakhwati' neeshraahchy'aa niindhan di'įį gwik'it.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Dinjii nakhweenjit oozųų shrǫ', ąįį ji' t'ee Vit'eegwijyąhchy'aa chan jyaa nakhooheenjyaa kwaa; dinjii gwiizųų gwats'ą' gwantł'eedǫhchyaa shrǫ', ąįį ji' Vit'eegwijyąhchy'aa chan gwik'it jyaa danakhwahah'yaa kwaa; dinjii nakhwats'ą' iizųų gaa nihk'it veenjit oo'an gahohłii, ąįį gwik'it Vit'eegwijyąhchy'aa chan nakhwatr'agwaanduu nakhweenjit oo'an gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vit'eegwijyąhchy'aa nakhwantł'eegwilii gwik'it nakhwant'ee gwantł'eegohłii. Łyaa gwintsii nantł'eech'ahahchaa ts'ą' gaa nandaa t'agwahaanchy'aa dinjii intł'eehaandal googwahtsii chan Vit'eegwijyąhchy'aa nintł'eehaandal.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ąįįts'ą' Jesus jii gwandak zhit geegoovąąhtan, “Dinjii vandee kwaa duuyeh ch'izhii dinjii vandee kwaa nee'aa t'oonchy'aa. Jyaa diizhik ji' nihłaa ts'ą' nanzhit gweedii t'eegahaadhal t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Juu geerǫąąhtan ąįį duuyeh ąįį juu geeyųąąhtan andaa gaandaii t'oonchy'aa, gaa juu geerǫąąhtan, ąįį gǫąąhtan ndaanaahjik ji' ąįį geech'ǫąąntan k'it t'iheechy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Jaghaii nachaa vandee zhit gał nah'in, gwiizhit nandee ąįį zhit traa eenjit k'eegwiichy'aa t'ini'in kwaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nats'ąą nachaa jyaa vahaiinjyaa, ‘Shachaa, nandee zhit gałgihłeehoihchyaa,’ diinyąą gwiizhit nandee zhit traa ąįį nah'in kwaa. Dinjii nizįį adaa'įį nąįį! Nan tr'ookit nandee zhit traa gihłeehinchįį ąįįtł'ęę gwinzii naa gweech'in tł'ęę nachaa vandee zhit gałkhaneiinchįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Jak t'an nizįį duuyeh jak iizųų vakat nahshii t'oonchy'aa, ąįį gwik'it jak t'an iizųų duuyeh vakat jak nizįį nahshii. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Jidii gwanzhįh vakat gwąąhshii tthak nats'ahts'ą' jidii jak vakat nahshii vaagwiindaii. Duuyeh khoh dachan kat Figs tr'ąąhtsii, ąįį gwik'it duuyeh khoh dachan kat jak choh (grapes) tr'ąąhtsii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Dinjii nizįį ąįį vidrii zhit gwats'an gwinzii tr'igwijyaa. Dinjii iizųų ąįį chan vidrii zhit gwats'an gwiizųų tr'igwijyaa. Dinjii vidrii zhit doonchy'aa k'iighai' ginkhii t'igwinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Jaghaii zhyaa, ‘Shik'eegwaadhat, Shik'eegwaadhat,’ shohnyąą gwiizhit deenakhwaihnyąą gwik'it t'akhwa'in kwaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Juu shats'ą' haazhii, ts'ą' shiginjik oołk'įį ts'ą' shik'eegwahthat, ąįįt'ee jidii dinjii nilii nakhwaagwahaldak. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Dinjii zheh gwiłtsąįį k'it t'inchy'aa. Nanzhit niighit khagwiindhat izhit kii kat zheh nigwiin'ąįį. Chųų ndak t'iizhik ts'ą' chųų viniitthak gaa needagwaanaii kwaa. Gwinzii gwakat deegwaa'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Gaa juu shiginjik oołk'įį ts'ą' gwik'it t'ii'in kwaa, ąįįt'ee dinjii zhyaa nankat k'ii'an zheh gwiłtsąįį k'it veegoo'aii. Nijin chųų gwakat t'iizhik dąį' khan needagwaanaii. Łyaa gwint'aii needagwaanaii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nijin Jesus deeheenjyaa goo'aii datthak gwik'it t'iinyą' ąįįtł'ęę kwaiik'it Capernaum kwaiik'it gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","3","Izhit kwaiik'it gwizhit Roman niveet'ah'in kheihkwaii, nijin Jesus eegwiitth'ak dąį', Israel kįh dilk'ii nąįį yits'ą' hił'e', ts'ą' Roman niveet'ah'in kheihkwaii vitsyaa łyaa gwint'aii iłts'ik ts'ą' vats'ą' hinkhaii ts'ą' veenjit gwinzii neegwąhtsii giihaanjyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Jesus ts'ą' gahaajil ts'ą' giits'ą' tr'igwidii haa giiyųąhkat, “Ąįį łyaa Israel Gwich'in nąįį datthak eet'iindhan ts'ą' tr'igiinkhii zheh gaa diineenjit gwiłtsąįį t'iinchy'aa. Izhit kwaii geh'an vats'ą' tr'ihiindal geenjit nat'aahchy'aa t'iinchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ąįįts'ą' Jesus goovaahaazhii. Roman niveet'ah'in vizheh gwats'ą' nahgwan geedaa gwizhik Roman niveet'ah'in vijyaa nąįį yits'ą' chiinjil ts'ą' t'iiyahnyąą. “Shalak, gwahkwaa zhyaa nihdeiinkhaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","8","Tr'ihkhit nahoł'ee ts'ąįį shizheh nihdeehinhaa gaa gitr'ih'ee ąįįts'ą' shįį chan nats'ą' hihshyaa eenjit dinjii nizįį ihłii kwaa. Dinjii shats'ą' k'eegwaadhat gwanlii ts'ą' shįį chan dinjii vats'ą' k'eegwaldhat nąįį gwanlii t'oonchy'aa. Jii niveet'ah'in dinjii ch'ihłak jyaa vakhaihjyaa, ‘T'ohłii neehindii!’ ts'ą' t'ohłii neeheedyaa. Ch'izhii niveet'ah'in dinjii chan jyaa vakhaihjyaa, ‘Aanaii!’, ąįįts'ą' shats'ą' heekhaa. Zhit juu khit shitsyaa sheetr'agwąh'in chan jyaa vakhaihjyaa, jyaa deeni'in ąįįts'ą' jyaa deeni'in vaihnyąą gwik'it t'ihee'yaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus łyaa geegoolii kwaa nijin gwiitth'ak dąį'. Juu vatąįį adaa nąįį ts'ą' neediil'ee ts'ą' t'agoovahnyąą, “Łi' haa ch'ihłok gaa jyaa deegwahtł'oo shik'injiriighit gaashandaii kwaa, Israel gwich'in nąįį gaa reh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Roman niveet'ah'in vijyaa nąįį oo'an neegahoojil dąį' ąįį Roman niveet'ah'in vitsyaa veenjit gwinzii neegahoodlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ąįįtł'ęę niighit kwaa Jesus oodak kwaiik'it Nain gwats'ą' haazhii, dinjii lęįį nąįį chan ts'ą' Vitsyaa nąįį haa chan giiyaahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","It'ee łąą kwaiik'it nihdeegihijyaa gwiizhit tsyaa niindhat ąįį giheetsii eenjit chagahahchįį. Ąįį tr'injaa vakai' chan gwehkįį niindhat ts'ą' chan jii tsyaa niindhat chan it'ee zhrįh vigii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nijin K'eegwaadhat Jesus yąąh'in dąį' łyaa gwantł'oo neeshraahchy'aa yuunyąą ts'ą' t'iiyahnyąą, “Intree kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ąįįts'ą' yits'ą' haazhii ts'ą' yidachantyąą kat naanjik, ąįį juu yidachantyąą gee'aa nąįį khaihłan nigiilzhii nagaanaii. Jesus t'iiyahnyąą, “Shalak, ndak dhindii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ąįį tsyaa niindhat khakee'ąįį ts'ą' khaginkhee. Jesus yahan intł'ineeyahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Juu nąįį datthak gihilghaa ąįįts'ą' K'eegwaadhat hil'ee agahnyąą. “Jii dinjii łi'haa hil'ee ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii t'inchy'aa! Diik'eegwaadhat dinjii nąįį neehahshii eenjit diits'ą' haazhii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jii Jesus deezhik Judea nahkat nihky'aa nankat datthak vagwandak goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John vitsyaa nąįį Jesus dee'in datthak eenjit giiyaagwaandak ąįįtł'ęę gootee neekwaii nąįį aanaii ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ąįį nąįį Diik'eegwaadhat Jesus ts'ą' goovihił'e' jii giiyuuhaahkat eenjit, “Nan lee John k'eehindik nahnyąą chy'aa lee t'inchy'aa? Akwat ch'izhii dinjii lee t'arahnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nijin Jesus ts'ą' tr'igin'oo dąį' jii giiyųąhkat, “John chųų gwats'an ąhtsii nilii nats'ą' diihił'e', naroohaahkat eenjit ‘Nan lee k'eehindik nahnyąą chy'aa lee t'inchy'aa? Akwat ch'izhii dinjii geerooheelyaa lee t'agwarahnyąą?’” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Izhit zhat gwiizhit Jesus, dinjii ts'ik daazhyaa haa iłts'ik nąįį, ąįįts'ą' juu vizhit ch'anky'aa iizųų nąįį datthak shrinilii. Zhit juu vandee kwaa nąįį chan haa gweech'in neegwąhtsii. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus, John vitsyaa nąįį t'ahnyąą “Oo'an neegahoo'oo ts'ą' jii jidii gǫǫh'ya' ts'ą' jidii dohtth'ak geegǫǫndak. Juu vandee kwaa nąįį chan gwah'in niłtsąįį. Juu neehidik kwaa nąįį chan juk neehiidal. Juu vatthąį' ahjat (leprosy) haa iłts'ik nąįį chan gookat ch'akwaa. Juu vidzii gwakwaa nąįį chan juk ch'iitth'ak. Juu niindhat nąįį chan neegogwandaii. Ąįįts'ą' Gwandak Nizįį chan neeshraahchy'aa nąįį ts'ą' geerǫąąhtan ");
INSERT INTO gwiNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Juu łyaa shik'injiighit duuyeh shihłeehidii nąįį haa shrigweheechy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John vitsyaa nąįį neegahoo'oo ąįįtł'ęę Jesus dinjii lęįį nąįį ts'ą' nadhat ts'ą' John eegoovaagwaandak, “Nijin oo'ok nangwinjir John vats'ą' noojil dąį', jidii hǫǫh'yaa gwich'in nohthan? Tł'oo ts'ik tsal ahtr'aii yichik hǫǫh'yaa nohthan? ");
INSERT INTO gwiNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Jidii hǫǫh'yaa eenjit t'akhwa'in? Dinjii gwach'aa zų' naazhii hąąh'yaa eenjit lee? Łyaa juu jyąhts'ą' nagwaazhii nąįį t'ee zhee gwachoo gwihil'ee gwizhit gwizhrįh gooraah'in t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Shaagwandak, jidii hąąh'yaa eenjit t'ini'in? Dinjii Vit'eegwijyąhchy'aa Eenjit Ginkhii hąąh'yaa eenjit lee? Aahą', nakhwaagwahaldak, ąįį k'it t'inchy'aa dinjii andaa veegoo'aii nǫh'ya' t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ąįį John t'ee Dęhtły'aa Choh zhit jyąhts'ą' veerigiinkhe', ‘Sheenjit tr'ihił'e' nilii, Vit'eegwijyąhchy'aa nyąą, nakhwadeets'ii nahałchyaa, nakhweenjit shrigweheelyaa eenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nakhwaagwahaldak,” Jesus nyąą, “Dinjii gwandaii ch'ihłak gaa yandaa ts'ą' veegoo'aii kwaa, gaa juu K'eegwaadhat Veegwinii'ee gwizhit jyaa dagwahtł'oo veegoo'aii kwaa nąįį giiyandaa ts'ą' gooveegoo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Zhit dinjii datthak ąįįts'ą' dinjii tax eenjit laraa oonjii nilii nąįį giiyiitth'ak, geedan it'ee Vit'eegwijyąhchy'aa k'eegwigwiłthat geh'an John goots'an chųų iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gaa zhit Pharisee nąįį chan ts'ą' Law eech'ǫąąhtan nąįį Vit'eegwijyąhchy'aa doo'ya' goovoonyąą ąįį gwits'į' t'iginchy'aa ts'ą' John goots'an chųų ąhtsii gitr'igii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Juk gweendaa gwidinjii nąįį nats'ąą gook'it teech'igihihkhyaa? Jidii k'it t'inchy'aa dinjii ginlii? ");
INSERT INTO gwiNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Zhit gwa'an gwadal tr'ookwat dehk'it goo'aii gwa'an tr'iinin dilk'ii k'it t'iginchy'aa. Oo'an nihts'ą' gazhral ts'ą' jyaa nihłagaanyąą, ‘Nihłeegwarahchįį gwich'ilik nakhweenjit ach'araahłii gaa ch'oodzaa kwaa. Dinjii anarahjii gwich'ilik nakhweenjit ach'araahłii gaa ohtree kwaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nijin John chųų gwats'an ąhtsii nilii ąįį k'idik dąį' adach'agaa'aa kwaa ts'ą' jak chų' chan dinįį kwaa gwiizhit jyaa davohnyąą, ‘Zhit vizhit ch'anky'aa iizųų dhidii!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gwidinji' k'idik ts'ą' ch'in'al ts'ą' ch'eenį' ąįįtł'ęę jyaa vaiinyą', ‘Jii dinjii nǫh'in! Gwintł'oo chan ch'a'aa ts'ą' chan gwintł'oo chan ch'iinįį. Dinjii tax eenjit laraa oonjii nąįį chan ts'ą' tr'aanduu nąįį jyaa nilii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gaa juu gwizhit gwandaii ts'ą' gwik'it t'igii'in nąįį t'ee Vit'eegwijyąhchy'aa vigwizhi' łi'didlii gahtsik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee dinjii ch'ihłak ąįį Jesus yaaneech'ihee'aa eenjit aanaii ahnyąą. Jesus ąįį yizheh gwats'ą' haazhii ts'ą' ch'ihee'aa eenjit gat'ąąnchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tr'injaa ch'ihłak vatr'agwaanduu gwanlii ąįį Jesus t'ee Pharisee vizheh neech'a'aa gwinyąą gwiitth'ak ąįįts'ą' zhat gwats'ą' haazhii, Alabaster tyah zhit gwanzhįh chų' gwinzii vagwaatsan chan neeha'ak. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesus gat'ąąnchįį gwiizhit yakwai' ant'ii niinzhii ts'ą' itree. Vitree chų' Jesus vakwai' kat daa'il ąįįts'ą' dikiighai' haa yach'ahjii ts'ą' yakwai' naats'ų' ąįįtł'ęę ąįį gwanzhįh chų' yakat t'inlik. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nijin ąįį Pharisee gwąąh'in dąį', adats'ą' niinjich'adhat, “Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii, gaa jii tr'injaa iizųų nilii yaandaii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus khaginkhee ts'ą' t'iiyahnyąą, “Simon, jii naagwahaaldak.” “Aahą', shigeech'ǫąąhtan shaagwandak.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Jii gwandak eenaagwahaldak, Dinjii neekwaii nąįį laraa geedantł'oo nilii ąįį laraa gooveedaantł'oo. Ch'ihłak $500 denarius eedąąntł'oo. Ąįįts'ą' ch'ihłak chan $50 denarius. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nihłaa ts'ą' laraa gii'įį kwaa geh'an khyų' giineegookwat, ąįįts'ą' ąįį laraa gooveedaantł'oo shineegohkwat gwat'oohchy'aa kwaa goovahnyąą. Juu shrit ch'andaa ąįį dinjii laraa gooveedaantł'oo eet'igehęęnghyaa li'?” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Akhai' Simon t'inyąą, “Duulee ąįį juu ch'andaa gwats'ą' gaandaii reh.” “Łyaa t'iinyąą!” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ąįįtł'ęę ąįį tr'injaa ts'ą' neediil'ee ts'ą' Simon t'ahnyąą. “Jii tr'injaa nah'in? Nizheh nihdeiinzhii dąį' shakwai' eenjit chųų shintł'eiinkaii kwaa gaa jii tr'injaa ąįį ditree chų' haa shakwai' k'eech'ąhtryaa ts'ą' dikiighai' haa yach'ąhjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Łyaa ch'eeshroonchy'aa haa nihdeeshąąhchįį kwaa gaa jii tr'injaa ąįį nihdeiinzhii dąį' gwats'an shakwai' naats'ų'. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Shiki' eenjit olive ghwai' shintł'in'ąįį kwaa gaa jii tr'injaa ąįį gwanzhįh chų' gwinzii vagwaatsan shakwai' kat t'inlik. ");
INSERT INTO gwiNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Naagwahaaldak, vatr'agwaanduu oo'an gweheedaa, ąįį geh'an łyaa gwantł'oo sheet'iindhan. Juu vatr'agwaanduu gwanlii veenjit oo'an gwirihilii dąį' gwandaa ch'eet'igwiniindhan di'įį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ąįįtł'ęę Jesus tr'injaa t'ahnyąą, “Natr'agwaanduu neenjit oo'an gahoilii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ąįį juu dinjii zhat ch'a'aa nąįį adats'ą' niinjich'agadhat, “Dinjii atr'agwaanduu gaa oo'an gwihilii! Jii juu dinjii t'inchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Gaa Jesus ąįį tr'injaa t'ahnyąą, “Nigwik'iinjigwiighit eh'an neehįįnzhii, tsinehdan naa oolį'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ąįįtł'ęę gehjuu gwanaa Jesus kwaiik'it gwinlęįį gwitee neehidik ts'ą' Vit'eegwijyąhchy'aa Veegwinii'ee eenjit Gwandak Nizįį eegoovaagwaandak. Vitsyaa 12 nąįį chan giiyaahaajil, ");
INSERT INTO gwiNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ąįįts'ą' chan zhit juu tr'injaa shranaazhik ts'ą' zhit juu ch'anky'aa iizųų goots'an tr'idiindhat nąįį chan Jesus haa gahaajil: Mary Magdalene (gwehkįį dąį' Jesus ch'anky'aa iizųų 7 yats'an tr'iinlii) ");
INSERT INTO gwiNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joanna (Chuza va'at juu Herod vizheh gook'ąąhtii) Susanna, chan ts'ą' tr'injaa lęįį nąįį dagalaraa haa, jidii datthak eenjit Jesus chan ts'ą' Vitsyaa nąįį haa ts'igiinyą' nąįį chan goovaa gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dinjii lęįį nąįį nihky'aa kwaiik'it gwinlęįį gwats'an Jesus eenineegiidal ąįįts'ą' nijin lęįį nąįį khaihłan niinjil dąį' Jesus gwandak ąhtsii zhit geegoovąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ch'ihłan dinjii gwa'an cheiinzhii ts'ą' gwihiiłshii. Ąįįts'ą' gwanzhįh gwit'ilii gwiizhit valat kwaii an-nihłik nan kat tąįį nijyaa, ąįį kwaii kat neegihiidal ts'ą' chan chiitsal nąįį giiyiin'al. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Valat kwaii chan łųh vitee kii gwanlii teiinjil ts'ą' nijin khan naahshii dąį' chųų kwaa geh'an agąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Valat kwaii chan khoh teiinjil ts'ą' gwitee niłshįį gaa khoh ąįį yiiłkhwąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Valat chan nan nizįį kat niinjil ts'ą' gwinzii vakat gwiiłshįį, ch'ihłak gaa vakat gwanzhįh 100 vakat niłshįį.” Jesus t'agoovahnyąą, “Jii deihnyąą gwinzii ch'oodǫǫhk'įį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Vitsyaa nąįį jii gwandak iłtsąįį zhit geech'ǫąąhtan ąįį deegwinyąą t'igwinyąą gaagoondaii giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ąįįts'ą' Jesus jyaa goovahnyąą, “Gwik'irahaandal eenjit gogwantrii gaa nihk'it K'eegwaadhat Veegwinii'ee eenjit gaagweheendaii nakhwiłtsąįį gaa ch'izhii nąįį gwandak zhit gwizhrįh gwats'an gogogwahaa'ee. Gwinzii googwąąh'in ji' gaa gwinzii goovaa gweheechy'aa kwaa eenjit ąįįts'ą' chan gwinzii ch'agoołk'įį ji' gaa deegwinyąą t'igwinyąą gaageheendaii kwaa eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jii gwandak t'ee jyaanyąą t'inyąą, “Ąįį gwanzhįh tsal gwit'ilii kwaii t'ee Vit'eegwijyąhchy'aa viginjik t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Zhit gwanzhįh an-nihłik tąįį gwiinjik naadhak t'ee zhit juu ch'oołk'įį gaa Ch'anky'aa Tr'aanduu jidii Vit'eegwijyąhchy'aa Viginjik gaak'įį ąįį goodrii ts'an noonjik. Gwik'iinjigeheeghit kwaa ts'ą' neegeheezhii kwaa geenjit, ąįį nąįį t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Zhit gwanzhįh łųh vitee kii teiinjil ąįį chan juu ch'oołk'įį ts'ą' shoh haa Vit'eegwijyąhchy'aa Viginjik goontą'. Gaa Viginjik goozhit nahshii kwaa, ts'ą' ch'ihłee gwizhrįh gwik'iinjigiighit ąįįtł'ęę nijin goovaagogwantrii nagwaanąįį dąį' gook'injigwiighit akhooheenjyaa nąįį t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Zhit gwanzhįh khoh teiinjil chan juu gwinzii ch'oołk'įį gaa geetee hee goovaagogwantrii ts'ą' chan łyaa gwinzii googwandaii, ąįįts'ą' chan łyaa gwiizųų gwizhit shroonchy'aa googwahtsii. Jii datthak goovaa nihteegwadal ts'ą' K'eegwaadhat eenjit gwitr'it googwah'in kwaa t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Zhit gwanzhįh nan nizįį kat naadhak kwaii chan zhit juu gwinzii ch'oołk'įį ts'ą', łi'didlii haa digidrii zhit deegwinyąą t'igwinyąą gaagiindaii ts'ą' chan gwik'eegogwahahtthat ts'ą' chan K'eegwaadhat eenjit gwitr'it gwinzii t'igihee'yaa ąįį kwaii t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ch'ihłee gaa duuyeh khwaiidaak'a' dahk'ii ąįįtł'ęę k'ik yideekat dichįį akwat chan duuyeh dehk'it gwit'eh yakaii gaa vakaii'aa kat deeyeheekaa. Jyąhts'ą' gwik'iighai' juu nihdąhkhat nąįį ch'aadrii googwahąąh'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Gwit'eegwirił'ąįį eenjit gogwantrii akwat gwit'eegwirił'ąįį ts'ą' ch'ihłak gaa gaaheendaii kwaa ts'ą' gwizhrįh nagwahaadhal chan gogwantrii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Gwinzii ch'oodǫǫhk'įį ts'ą' nakhwadrii zhit gooh'ąįį, juu gwinzii ch'oołk'įį ts'ą' didrii zhit gwin'ąįį t'ee gwats'an gwandaa tł'eegwahaadhaa, juu gwinzii ch'oołk'įį kwaa ts'ą' gwintsal gwizhrįh gaandaii t'ee datthak vits'į' neerooheendal.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus zheh gwizhit dinjii lęįį nąįį haa dhidii gwiizhit vahan chan ts'ą' vachaa nąįį haa giiyahaah'yaa eenjit giits'ą' haa'oo. Nihdeegaha'oo gaa tr'ihkhit goots'ooghaii dinjii gwanlii, ");
INSERT INTO gwiNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ąįįts'ą' dinjii ch'ihłak ąįį Jesus jyaa dahnyąą, “Nahan, nachaa haa chiitąįį nagadhat, łyaa narooh'ya' nagoonyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Datthak ts'ą' Jesus jyaa goovahnyąą, “Juu Vit'eegwijyąhchy'aa viginjik oołk'įį ts'ą' gwik'it dinjii nilii ąįįt'ee shahan, shachaa nąįį haa k'it t'igiinchy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ch'ihłan gwanaa Jesus, ditsyaa nąįį haa tr'ihchoh zhiinzhii ts'ą' t'agoovahnyąą, “Oonjik van ndųhts'ąįį gwats'ą' tr'ahoojyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ąįįts'ą' k'iinji' geekwaa gwiizhit Jesus naachįį. Khan hee gwiint'aii van kat teiintr'ąįį ts'ą' tr'ihchoh zhit chųų deedahkhii. Tr'ihchoo goovaachilit. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesus vitsyaa nąįį Jesus khakigiiyiin'ąįį ts'ą' t'igiiyahnyąą “Jesus, Jesus! Tr'ahahchyaa ji' gaa neenjit k'eegwiichy'aa t'igweheechy'aa kwaa?” Jesus khakee'ąįį ts'ą' ahtr'aii nint'aii ts'ą' tit choh kwaii haa ts'ą' khaginkhee ts'ą' datthak tsinehdan nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ąįįtł'ęę ditsyaa nąįį t'ahnyąą, “Shit'injuhchy'a' jaghaii?” Jesus goovandaa gwihil'ee t'iizhik ts'ą' łyaa gihilghaa. “Jii juu t'iinchy'aa,” nihłagaanyąą? “Ahtr'aii ts'ą' tit kwaii haa ts'ą' khaginkhee ts'ą' giik'eegwahthat!” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilee van ndųhts'ąįį gwats'an Jesus ditsyaa nąįį haa yaagha' Gerasa nahkat gwats'ą' neeginkwaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus teedhizhii gwiizhit kwaiik'it gwats'an dinjii vizhit ch'anky'aa iizųų yeeniinzhii. Łyaa niighyuk gwach'aa ehdan dhidii ts'ą' dizheh chan duuyeh dhidii, gaa kii zhit tth'ank'it goodlii izhit gwizhrįh idiildii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nijin Jesus niił'in dąį' gwint'aii khaiintrii ts'ą' yakwai' ehzhee oo'an teehiilnaii ts'ą' azhral ts'ą' jyaa nyąą, “Jesus, Vit'eegwijyąhchy'aa Choh Vidinji'! Jaghaii shaanagwiin'ąįį t'ini'in? Khaiinjich'ashǫhthat shrǫ'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yizhit ch'anky'aa iizųų gihłeehahchįį geh'an jyaa nyąą. Gwehkįį gwinlęįį yaa oo'an neet'eehaadhak ts'ą' yaa khaiinjich'ohoodhat, ch'iitsii tły'ah haa vanli', vakwai' haa dach'akhwachaa gaa łeeyaahnaii ts'ą' ąįį vizhit ch'anky'aa iizųų oo'at nangwinjir k'ii'an yahah'ak. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus yuahkat, “Nats'ąą noozhri'?” “Diinoozhri' Legion oaazhii,” nyąą-gwehkįį ch'anky'aa iizųų lęįį nąįį chan vizhit diindhat geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ąįį ch'anky'aa iizųų nąįį oozhak gwit'eh goo'aii kwaa gwats'ą' Jesus goovahahchyaa kwaa eenjit giits'ą' gwinzii ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Geeghaih gwa'an taihkhyuu pig lęįį ch'a'aa. Ąįįts'ą' pig kwaii zhit digiheedhaa gwats'ą' t'agoohahkhyaa eenjit Jesus goahkat, ąįįts'ą' gwats'ą' t'agoovahthan. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ąįį dinjii ts'an tr'ineegiijil ts'ą' pig kwaii zhit deegiindhat. Ąįį pig t'ąąnchy'aa datthak taihdik vanzhit oondaa gahaajil ts'ą' teenagahoonii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ąįį juu pig k'ąąhtii nąįį tthak googwąąh'ya', ts'ą' gihłeegalgihiljil ts'ą' zhat gwa'an gogwąąhshii dehk'it goodlii gwich'įį nąįį chan ts'ą' kwaiik'it haa gwa'an geegoogwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Dinjii nąįį zhat googwahąąh'yaa eenjit zhat gwats'ą' gahaajil, ąįįts'ą' nijin Jesus ts'ą' tr'igiinjil dąį', ąįį dinjii vizhit ch'anky'aa iizųų tr'iinjil ąįį Jesus vakwai' ehzhee dhidii agogwąh'ąįį, gwach'aa chan naazhii ts'ą' gwinzii chan niinjich'adhat łee, ąįįts'ą' datthak giiyaanjat. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ąįįts'ą' dinjii gwah'ya' nąįį nats'ahts'ą' yats'ą' tr'iinjik geegoovaagogwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ąįįts'ą' izhit nahkat gwich'in nąįį datthak Jesus gihłeehindii agahnyąą, goozhit ch'andaii in'ąįį geh'an. Ąįįts'ą' t'ee Jesus tr'ihchoo zhineezhii ts'ą' neehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ąįį dinjii vizhit ch'anky'aa iizųų tr'ineiinlii chy'aa Jesus oahkat, “Naaneehooshizhi'.” Gaa Jesus nakwaa nyąą, ts'ą' jyaa yahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nizheh gwits'eehindii ts'ą' Vit'eegwijyąhchy'aa neenjit deezhik geegwandak.” Ąįį dinjii ąįį kwaiik'it datthak gwits'eehoozhii ts'ą' Jesus yeenjit deezhik geegwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nijin Jesus van ndųhts'ąįį gwats'an k'iinaa neehoozhii dąį' dinjii lęįį niiyul'in nąįį giiyeenjit shoo dhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Dinjii lat nąįį Jesus ts'ą' giginkhii gwizhik dinjii Jairus oozhii k'idik. Israel nąįį tee gwa'an tr'igiinkhii zheh gwizhit gwats'ą' k'eegwaadhat nilii. Jesus vakwai' eeghaii zhak gwiint'aii nikiigwiintthaii ts'ą', “Shizheh gwats'ą' shaahinkhaii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","“Shigii nich'it tsal veenjit gwinzii neegwąhtsii, ąįį zhrįh shigii t'iinchy'aa,” yahnyąą. Ąįįts'ą' Jesus yaahaazhii. Jesus gwa'an ahaa veelin datthak dinjii gwanlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Gootee tr'injaa ch'ihłak łyaa niighyuk ąįį dah vats'an an ilii haa khaiinjich'iighit. Dah gwiintł'oo vats'an an ilii haa, łyaa dalaraa di'įį datthak chan iłts'ik shrinilii ts'ą' an yiłtsąįį gaa giiyeenjit gwinzii neegwąhtsii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesus ant'ii niinzhii ts'ą' yi'ik kat yeentak naanjik ts'ą' veenjit gwinzii nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus ch'oahkat, “Juu shakat naanjik?” Datthak ts'ą' shįį shizhit kwaa ginyąą. Peter ąįį t'iiyahnyąą, “Dinjii neelin gwanlii, ts'ą' juu t'iizhik gaagwiindaii kwaa t'iinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gaa Jesus ąįį t'iiyahnyąą, “Sharąąhjik dąį' shat'aii lat shats'an t'iizhik gwiky'aljik t'ihnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nijin zhit tr'injaa vik'igwaanjik gwiky'aanjik dąį' naajat googaa Jesus ts'ą' haazhii, ts'ą' yehzhee nikiigwiintthaii. Juu nąįį tthak andah t'iiyahnyąą, “Shįį nakat naaljik ts'ą' sheenjit gwinzii neegwaanąįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus ąįį t'iiyahnyąą, “Shik'injiinghit geh'an neenjit gwinzii neegahoodlit, tsinehdan haa oo'an neehiindii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus jyaanyąą gwiizhit, dinjii ch'ihłak Jairus vizheh gwats'an oo'ee haazhii, ts'ą' Jairus t'ahnyąą, “Nigii nich'it tsal ch'adąį' niindhat. Jesus gwahkwaa ni'in vaiinyąą ch'adąį' hee nigii niindhat t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesus deegwinyąą gwaak'įį ts'ą' t'agoovahnyąą, “Nanjat kwaa, shik'injinghit ji' neegweheendaii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nijin Jesus Jairus vizheh nihdeegiinjil dąį' Peter, John, James, nich'it tsal vahan ts'ą' viti' nąįį haa giiyaa nihdeiinjil ąįįts'ą' ch'izhii dinjii nąįį vaanihdijyaa gitr'ii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Juu chiitąįį itree nąįį datthak tr'iinin niindhat eenjit gitree. “Ohtree kwaa ahnyąą tr'iinin niindhat kwaa zhyaa dhichįį t'inchy'aa,” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ąįį juu chiitąįį dilk'ii nąįį nich'it tsal niindhat gaagiindaii ts'ą' Jesus deenyąą eegeedlaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus nich'it tsal anli' oonjii ts'ą' “Nich'it tsal, ndak nineenjii!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Khan hee nich'it tsal vizhin yizhit needeedhat gwandaii neekhwadlit ts'ą' ndak niinzhii. Yihee'aa ji' vantł'ohtsit, goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Viiyehghan nąįį łyaa goovandaa t'igwiizhik gaa Jesus “Jii deegwiizhik geegǫǫndak shrǫ',” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus ditsyaa ch'ihłoaatin ts'ą' neekwaii nąįį khaihłan nilii ts'ą' t'aih goots'an iltsąįį. Juu ch'anky'aa iizųų vizhit ts'ą' iłts'ik nąįį ts'ą' tr'igiheendal geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ąįįtł'ęę K'eegwaadhat Veegwinii'ee geegoogwahahchyaa ts'ą' iłts'ik nąįį shrineegiheelyaa eenjit nihky'aa goovihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ąįįts'ą' t'agoovahnyąą “K'eiich'ii ch'ihłak gaa neehoh'at shrǫ', t'oh, ohtsii zhit shih, laraa ąįįts'ą' gwach'aa ch'ihłak gaa kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nijin zheh gwinch'įį, izhit gwizhit, dahthee gihłeehiindyaa gwats'ą' gwiinch'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nijin dinjii nihdeenąąhchįį kwaa ji', izhit kwaiik'it gihłeehiindii, nakwai' kat łųh ninghat ts'ą', jyąhts'ą' gwik'iighai' zhit dinjii nąįį gwiizųų t'igiizhit łee gaageheendaii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jesus vitsyaa nąįį gahaajil ts'ą' kwaiik'it gwit'eh datthak neegihiidal ts'ą' nijuk datthak Gwandak Nizįį geegǫąąhtan, ts'ą' iłts'ik nąįį shrineegilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nijin Herod, Galilee gwanahkat gwats'ą' k'eegwaadhat. Jii deegwii'in datthak gwiitth'ak dąį' deegwii'in t'igwinyąą gaandaii kwaa. Dinjii lat nąįį “John chųų gwats'an ąhtsii niindhat gwats'an khakee'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Niighit dąį' gwanaa gwats'an Elijah, Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį niindhat gwats'an khakee'ąįį,” gaa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod t'inyąą, “John vikiitth'an k'eech'iikil, akǫǫ jii dinjii ąįį juu t'agahnyąą?” Ąįįts'ą' Jesus hah'yaa gwik'eegwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tr'ihił'e' nąįį oo'ee neegiijil ts'ą' deegiizhik datthak Jesus haa gwagwaandak. Ąįįtł'ęę Bethsaida kwaiik'it gwats'ą' goovaahaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nijin juu nąįį datthak giiyeegwiitth'ak dąį' giitąįį haajil. Goovąąh'in geenjit shoo nilii, ts'ą' Vit'eegwijyąhchy'aa vanahkat eegoovaagwaandak ts'ą' chan gootee juu iłts'ik nąįį chan shrineiilik. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Drintł'an gwandaa Tr'ihił'e' nąįį giits'ą' haajil ts'ą' t'igiiyahnyąą. “Dzaa łyaa tthan goo'aii, ts'ą' jii dinjii nąįį kwaiik'it akwat gwanzhįh nahshii gwa'an shih gooheendal ts'ą' nijin gahahchųų eenjit gwats'ą' goovah'ee.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Gaa Jesus t'agoovahnyąą “Nakhwan ąįį giihee'aa goovantł'ohtsit.” Akhai' jyaa ginyąą “Łųhchy'aa ch'ihłoanli' ts'ą' łuk neekwaii zhrįh tr'ii'įį. Juu nąįį datthak eenjit shih tr'oankwat ji' gwizhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Zhat dąį' dinjii 5000 aanchy'aa zhat dilk'ii.) Jesus t'agoovahnyąą, “Dinjii 50 aanchy'aa ts'ą' nihłeh'an dook'įį goovohnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","16","Vitsyaa nąįį jyaa deegiizhik ts'ą' juu nąįį datthak zhak giilk'ii ąįįtł'ęę Jesus ąįį łųhchy'aa ch'ihłoanli' ts'ą' łuk neekwaii teegwįłjik ts'ą' zheekat k'iidak gwąąh'in ts'ą' Vit'eegwijyąhchy'aa mahsį' ahnyąą tł'ęę ditsyaa nąįį datthak iteeyiłtsik, dinjii ąįį datthak iteegiihahchaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Juu nąįį datthak ch'anahoo'al gaa nihk'it tyah ch'ihłoaatin ants'ą' neekwaii aanchy'aa łąą tr'ooniindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ch'ihłan Jesus tthan gwa'an adąhzhrįh khadigiinjii gwiizhit vitsyaa nąįį yeenineejil, ts'ą' t'agoovahnyąą, “Dinjii nąįį juu ihłii shagahnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Goolat nąįį John chųų gwats'an ąhtsii t'inchy'aa nagahnyąą, ginyąą ch'izhii nąįį chan Elijah nagahnyąą, goolat nąįį chan yeenaa dąį' gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii ąįį neegwiindaii t'ii'in nagahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Nakhwan ąįį yu', juu t'ihchy'aa shohnyąą?” goovahnyąą. Peter jyaa yahnyąą, “Dinjii neehahshii eenjit Vit'eegwijyąhchy'aa nihił'e' inlii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","“Vit'eegwijyąhchy'aa shihił'e' ihłii łyaa dinjii ch'ihłak gaa haagoondak shrǫ',” Jesus goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ąįįts'ą' chan jyaa nyąą, “Gwidinji' ihłii ts'ą' gwilęįį khaiinjich'ashahadhat sheenjit goo'aii ąįįts'ą' Israel kįh dilk'ii nąįį, giinkhih kįh dilk'ii nąįį, ts'ą' Law eech'ǫąąhtan nąįį shitr'igihee'ee. Shęhdaa tr'igwigwehee'aa ąįįtł'ęę drin tik gweheedhaa ts'ą' neegwihįhdaii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ąįįts'ą' datthak jyaa goovahnyąą, “Juu shatąįį hoozhi' niindhan ji', adanaandee, ts'ą' drin gwiteegogwąąnchy'aa na-cross inchyaa, ts'ą' shatąįį hinkhaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Juu dagwandaii, diyinji' haa intsai' ji' t'ee yaa shrihteegwehee'aa. Gaa juu shęh'an niindhat ąįįt'ee dagwandaii, diyinji' haa neehahshii. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dinjii nankat datthak ideenjit goonjik gaa viyinji' an dhidlit ji' ąįį dinjii nihk'it gwats'an gaayiigwahaahtsyaa shrǫǫ? Łyaa duuyeh! ");
INSERT INTO gwiNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dinjii sha'oozhii ahłįį, ts'ą' geech'ǫąąłtan eenjit sha'oozhii ahłįį t'ee shįį Gwidinji' ihłii ts'ą' va'oozhii hahłyaa nijin shach'agwąhdrii akwat Shiti' vich'eegwahdrii akwat zheekat Gwich'in Shroodiinyąą nąįį vich'eegwahdrii zhit oo'ee neeshizhii ji'. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Łi'haa juk nakhwatee nakhwalat nąįį niheedhaa gwats'ą' K'eegwaadhat Veegwinii'ee gwahąąh'yaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jii kwaii geenjit jyaa diinyą' gwats'an drin nihk'iidǫǫ gwahaadhat gwiizhit Jesus ąįį Peter, John haa taih kat khadigigeheejyaa eenjit gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Khagidiinjii gwiizhit vinin ch'ijuk vigweech'in naanaii ts'ą' vagwach'aa chan daagąįį haa vakat adrii haadhak. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Khan hee dinjii neekwaii nąįį yaa ginkhii. Moses chan ts'ą' Elijah haa. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Vit'eegwijyąhchy'aa vich'eegwahdrii gwizhit k'ii'ee googweelkįį ts'ą' Jesus haa giginkhii, Vit'eegwijyąhchy'aa jaghaii geenjit t'iiyahah'yaa eenjit Jerusalem gwizhit vidrin gweheelyaa geegiiyaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter chan ts'ą' juu yaa dilk'ii nąįį haa giłchųų gaa khakigilzhii ts'ą' Jesus vich'eegwahdrii chan ts'ą' ąįį dinjii neekwaii giiyaanadhat nigiił'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses, Elijah haa Jesus iłeegihii'oo gwiizhit Peter Jesus jyaa dahnyąą, “Shigeech'ǫąąhtan, dzaa tr'iilk'įį łyaa gwinzii t'igwinchy'aa łee. Trał haa zheh tik gwarahahtsyaa ch'ihłak ąįį neenjit, ch'ihłak chan Moses ąįįts'ą' ch'ihłak chan Elijah.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tth'aii ginkhii gwiizhit zheek'ǫh goodlit ąįį gwank'oo t'eh giilk'ii ąįįts'ą' łyaa gąąnjat nijin zheek'ǫh gookat t'iizhik dąį'. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Zheek'ǫh zhit gwats'an goots'ą' khagiriinkhee “Jii t'ee Shidinji' t'inchy'aa, gwitee tr'ałchįį t'inchy'aa, oodǫǫhk'įį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nijin ginkhii k'ideegwaanaii dąį', Jesus zhrįh zhat nadhat. Vitsyaa nąįį geegiginkhii kwaa ts'ą' izhit dąį' jidii googwąąh'ya' eenjit ch'ihłak gaa haa gwaandak kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Gęhdaa drin Jesus ditsyaa tik nąįį haa taih kat k'iizhak gahaajil, izhit dinjii lęįį nąįį yats'ą' tr'iinjil. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Dinjii tee gwa'an gwats'an dinjii ch'ihłak yineeshraadiitrak, “Geech'ǫąąhtan! Jii it'ee zhrįh shidinji' nah'in! Neeshraahchy'aa shǫįįnyąą ts'ą' veenjit shits'iinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ch'anky'aa iizųų yizhit diindhat ts'ą' ąįį ts'an azhral ts'ą' zhit gwa'an datthak neehiitaa ts'ą' vigwiinjii ąįį ts'an chan vighit gaa goghoh. Nijin neechiindee dąį' gwizhrįh yats'an tr'ineediidhak. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nitsyaa nąįį giizhit gihłeegiihahchyaa eenjit jyaa goovaihnyąą gaa khyų' t'igiiyah'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus ditsyaa nąįį jyaa dahnyąą, “Łyaa gwik'iinjuhkhit kwaa ts'ą' gwiizųų t'oonchy'aa łee it'ee nakhwaashandaii goodlit! Deegwąhkhyuk zhyaa nakhwaa t'ihihchy'aa shoohnyąą?” Ąįįtł'ęę ąįį dinjii jyaa ahnyąą, “Nidinji' dzaa gwats'ą' hahchįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ąįį chyaatsal yits'ą' ahaa gwiizhit ąįį vizhit ch'anky'aa iizųų ts'an oo'an neet'eehaadhak ts'ą' zhit gwa'an datthak neehiitaa. Ąįįts'ą' Jesus ąįį ch'anky'aa iizųų ineegiinkhee ts'ą' ąįį chyaatsal ts'ą' tr'iinjik ąįįtł'ęę yiti' intł'ineeyahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Zhat dinjii gwanlii nąįį datthak łyaa geegagoolii kwaa t'igwiizhik ts'ą' Vit'eegwijyąhchy'aa vat'aih nitsii łee gwik'igaanjik. Juu nąįį datthak Jesus goovandah deezhik googwąąh'ya' eenjit łyaa gininjich'agahthat ts'ą' dee'in t'ii'in giiyaandaii kwaa gwiizhit ditsyaa nąįį jyaa ahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Juk deenakhwahaihjyaa eenjit gwinzii ch'oodǫǫhk'įį! Gwidinji' tr'ahaahkhwaa eenjit dinjii nąįį antł'eeyahahchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gaa deenyąą t'inyąą giiyaandaii kwaa. Deegwinyąą t'igwinyąą gaageheendaii kwaa eenjit goots'ą' gwit'eh goo'aii, ąįįts'ą' giiyuuhaahkat eenjit gatr'agogwaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Juu gwitee ch'andaa hil'ee eenjit vitsyaa nąįį nihzheedagąąn'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus nats'ąą niinjich'agadhat goovandaii ts'ą' tr'iinin ideeghaih naachįį ");
INSERT INTO gwiNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ts'ą' jyaa goovahnyąą, “Juu jii tr'iinin shoozhri' zhit shoo haa anli' ooheendal ts'ą' nihdeehahchyaa ąįįt'ee shįį chan gwik'it t'ishiheelyaa ąįįts'ą' juu dzaa gwats'ą' shihił'e' chan gwik'it t'iheelyaa. Ąįį eenjit t'ee nakhwatee juu ch'andaa gwintsal veegoo'aii, ąįįt'ee ch'andaa hil'ee.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John ąįį Jesus t'ahnyąą, “Shigeech'ǫąąhtan, dinjii ch'ihłak ąįį ch'izhii dinjii zhit ch'anky'aa iizųų noozhri' zhit gihłeehiłchįį tr'ąąh'ya', diitee gwats'an nilii kwaa ts'ą' ąįį geh'an jyaa dii'in akhagoiinyąą varaiinyą'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus t'iiyahnyąą, “Chan jyaa dii'in akhagoiinyąą vohnyą' shrǫ', juu nitr'ii'ee kwaa ąįįt'ee nats'ąįį nadhat t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus zheekat neerooheendal eenjit zhat nigwiighit ts'ą' t'ee gininjich'iłthat ts'ą' Jerusalem gwats'ą' hihshyaa nindhan ts'ą' gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Neeyahah'ak nąįį idits'įį Samaria gookwaiik'it gwats'ą' niinlii, giiyeenjit shrigweheelyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gaa Jerusalem gwats'ą' hahkhaii giiyaandaii ts'ą' izhit geh'an nihdeegiiyąąhchįį gitr'igii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nijin vitsyaa James chan ts'ą' John haa jii nigwigwiił'in dąį' jyaa ginyąą “Shik'eegwaadhat, zheekat gwats'an kǫ' haa an goorohtsyaa diinoiinyaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus neediil'ee ts'ą' t'agoovahnyąą, “Jyaa dohnyąą kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ąįįts'ą' ch'adanh kwaiik'it gwats'ą' giiyaahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jesus ditsyaa nąįį haa tąįį geedaa gwiizhit dinjii ch'ihłak Jesus t'ahnyąą, “Nijuk inkhaa datthak naa k'eehihdik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus t'iiyahnyąą, “Neegǫǫ kwaii chan ch'a'an gwigwii'įį chiitsal kwaii chan ch'at'oh gwigwii'įį. Gaa shįį ąįį Gwidinji' ihłii ts'ą' gwihihchy'aa gwishi'įį kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ch'izhii dinjii chan t'ahnyąą “Shaa hinkhaii!” Gaa ąįį dinjii t'iiyahnyąą, “Shik'eegwaadhat, gwik'it t'ishi'yaa gaa oo'an shizheh nineehihdyaa ts'ą' shiti' vanahałdal.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Gaa Jesus t'iiyahnyąą, “Juu dinjii iłchįį ky'aa veegoo'aii gwik'iinjiighit kwaa nąįį nihłanagąąnjii. Hinkhaii ts'ą' K'eegwaadhat Veegwinii'ee eech'ǫąąhtan.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ch'izhii dinjii chan jyaanyąą, “Shik'eegwaadhat, natąįį hihshyaa gaa shalak nąįį naahihshyaa goovaahihjyaa gwats'ą' t'ashahthan.” ");
INSERT INTO gwiNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus t'iiyahnyąą, “Juu gwanzhįh deek'it shrigwilii gaa gwintł'oo k'iinji' neegwaa'ik, ji', dagwanzhih iizųų hahtsyaa ąįį gwik'it juu gwintł'oo k'iinji' neegwaa'ik t'ee K'eegwaadhat Veegwinii'ee geenjit iizųų.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ąįįtł'ęę Diik'eegwaadhat ch'izhii dinjii 72 nąįį gwitee tr'iinlii. Ąįį gooteegwagwaanchy'aa ts'ą' neekwaii ginlii, nijin kwaiik'it gwa'an k'eeheedik datthak idits'įį goohił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ąįįts'ą' t'agoovahnyąą, “Dinjii nąįį gwanzhįh tr'ąąhshii k'it t'iginchy'aa, gaa lęįį ch'ahąąhtsyaa nąįį kwaa. Ąįį gwanzhįh deek'it gwats'ą' K'eegwaadhat vats'ą' khadagohjii, lęįį nąįį yeenjit ch'ahąąhtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Juk zhat hohjyaa! Divii gii zhoh tee gwats'ą' hał'aa k'it t'anakhwahihłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Laraa dhah, khwah, akwat kwaiitryah gaa adahaa hohłyaa shrǫ'! Tąįį gwinjik dinjii nǫh'in ji', vats'ą' gohkhyaa shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Zheh nihdǫh'oo dąį', tr'ookit jyaa dohnyąą, ‘Jii zheh gwizhit gwich'įį nąįį tsinehdan nakhwaa oolį'.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Dinjii tsinehdan eenjit ch'eet'igwiniindhan, tsinehdan haa di'įį zhat gwich'įį ji', tsinehdan khwa'įį ąįį zhat akhoohnyąą, ąįį akwaa ji', tsinehdan vits'į' nǫhjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ąįį zheh gwizhrįh gohch'įį ts'ą' jidii hoh'aa, akhwahanjyaa haa nakhwantł'eerahchak zhrįh ǫhjii, juu gwitr'it t'agwah'ya' agwarooheekwat gwizhrįh geenjit goo'aii geh'an. Zheh gwiteegogwąąnchy'aa datthak gohch'į' shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nijin kwaiik'it nihdǫhdal ts'ą' nakhweenjit shoo gilik ts'ą' jidii nakhwęhdaa narahchak, ąįį oh'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ąįį kwaiik'it gwizhit iłts'ik nąįį shranohłik. Zhat dinjii nąįį jyaa ohnyąą, ‘K'eegwaadhat Veegwinii'ee nahgwan nakhweenjit dha'aii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gaa nijin kwaiik'it nihdeenakhwarahchįį kwaa ts'ą' nakhwatr'igii'ee ji', tąįį gwinjik gwats'ą' hohdal ts'ą' jyaa dohnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Jii nakhwakwaiik'it gwiłuu' gaa diikwai' kat gwats'an nakhwats'į' ach'arahjii. Gaa jii ganoondaii, Vit'eegwijyąhchy'aa Veegwinii'ee nahgwan nakhweenjit dha'aii!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ch'aroahkat Drin ji' Vit'eegwijyąhchy'aa jii nakhwakwaiik'it andaa ts'ą' Sodom ąįį neeshraahchy'aa heenghyaa googwahaahchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Bethsaida kwaiik'it chan ts'ą' Chorazin kwaiik'it gwachoo haa, nakhwadiveegweheezųų t'oonchy'aa! Vit'eegwijyąhchy'aa vat'aii zhit tr'agwał'ya' datthak gwąąh'ya' ts'ą' Tyre chan ts'ą', Sidon, kwaiik'it haa chan googwąąh'ya' ji' niighit dąį' hee datr'agogwaanduu akhagagooheenjyaa goovaagweheendaii eenjit ohtsuu dhah (sackcloth) gwach'aa nagahaazhyaa ts'ą' dagakat kikluu t'igiheelyaa! ");
INSERT INTO gwiNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ch'aroahkat Drin nigwiindhat ji', Vit'eegwijyąhchy'aa nandaa ts'ą' Tyre, Sodom haa neeshraahchy'aa ooheenjyaa googwahaahchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum kwaiik'it, zheekat gwats'ą' hoihshi' nohthan? Hell oozhak gwit'eh gwakwaa gwats'ą' t'anakhwarahahthal t'oonchy'aa! Jesus gwahkwaa ni'in vaiinyąą ch'adąį' hee nigii niindhat t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesus ditsyaa nąįį jyaa ahnyąą, “Juu nakhoołk'įį, ąįįt'ee shoołk'įį. Juu akhanoonyąą, t'ee shįį chan akhashoonyąą. Juu akhashoonyąą, t'ee juu dzaa gwats'ą' shihił'e' chan akhoonyąą t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Vitsyaa 72 nąįį shoo haa k'ineegiidal. “Shik'eegwaadhat, Noozhri' zhit ch'anky'aa iizųų nąįį gaa diik'eegogwahthat!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus t'agoovahnyąą, “Satan nahtan kǫ' haadhak (lightning) k'it shandah zheekat gwats'an neet'aanąįį nał'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ch'oodǫǫhk'įį! T'aih nitsii nakhwantł'eiin'ąįį, ąįį haa gyųų choh akwat Scorpion gwideedrii ha'al kwaii kat k'eekhwadal eenjit. Ąįįts'ą' ch'anky'aa iizųų vat'aii andaa t'aih khwa'yaa ts'ą' duuyeh k'eegwiichy'aa t'ohjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gaa ch'anky'aa iizųų nąįį nakhwak'eegwahthat eenjit shoo ǫhłį' shrǫ'! Yeedak zheekat nakhoozhri' danahootł'oo geenjit shoo ǫhłįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Izhit zhat dąį' Jesus Ch'anky'aa Shroodiinyąą haa vizhit shoh dha'aii ts'ą' jyaa nyąą, “Shiti', nankat, zheekat haa datthak gwats'ą' K'eegwaadhat. Ąįį jidii goonzhįį nąįį ts'į' nagwąą'įį ąįį kwaii gaandaii kwaa nąįį ts'ą' gwizhrįh nigwiin'ąįį geenjit mahsį' noihnyąą. Aahą', Shiti', jyąhts'ą' gwik'it gooli' niindhan chy'aa gwik'it t'inizhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Shiti', jii kwaii tthak shintł'eegwinlii. Ch'ihłak gaa juu Gwidinji' t'arahnyąą gaandaii kwaa, Gwiti' zhrįh gaandaii. Ąįįts'ą' chan ch'ihłak gaa juu Gwiti' t'arahnyąą gaandaii kwaa, Gwidinji' zhrįh gaandaii. Ąįįts'ą' chan juu Gwidinji' Gwiti' eenjit gǫąąhtan nąįį zhrįh Gwiti' haaheendaii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ąįįtł'ęę Jesus neediil'ee ts'ą' ditsyaa nąįį zhrįh t'ahnyąą “Jii datthak gǫǫh'ya' geenjit shoo ǫhłįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Vit'eegwijyąhchy'aa Eenjit Ginkhii chan ts'ą' King lęįį nąįį haa datthak jii jidii gǫǫh'ya' datthak gwarǫh'ya' ts'ą' garoothh'ak giindhan gaa khyų' t'igee'ya'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Law eech'ǫąąhtan nąįį ch'ihłak ndak needhihkhin ts'ą' Jesus tsinteehąąhkaii gwik'eegwandaii. “Geech'ǫąąhtan, gwandaii ndaanąą'ąį' kwaa shi'yaa eenjit deeshi'yaa goo'aii?” jyaa yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus t'iiyahnyąą, “Dęhtły'aa Choh zhit Law kat deegwinyąą gǫ'? Nik'ee deenyąą t'inyąą vaanandaii?” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ąįį dinjii t'iiyahnyąą, “K'eegwaadhat Nivit'eegwijyąhchy'aa nidrii datthak haa veet'ihiinghyaa goo'aii, akwat nakhweegoo'aii ąįįts'ą' nakhwayinji' datthak ts'ą' nakhwat'aii datthak haa chan. Ąįįts'ą' chan deegwahtł'oo ideet'iindhan googwahtł'oo chan dinjii nineh'ok gwich'įį nąįį datthak eet'ihiinghyaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus t'iiyahnyąą, “Jii deiinyą' datthak łi'didlii haa ginkhe', akwat gwik'it t'ini'in. Ąįį ji' t'ee gwandaii ndaanąą'ąį' kwaa hini'yaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Gaa ąįį Law eech'ǫąąhtan ąįį łyaa łi'didlii adoodiinyąą ts'ą' Jesus oahkat, “Ąįį Gwidinji', ąįį juu t'inchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesus t'iiyahnyąą, “Ch'ihłan dinjii Jerusalem gwats'an ootthan Jericho kwaiik'it gwachoo gwits'eehaa. Gwiizhit ch'an'įį nąįį giiyąąhkhwąį' ts'ą' giigwach'aa chan ts'ą' jidii di'įį datthak giits'an oonjik. Khaiinjii giiyuułkhwąįį ts'ą' akhagiiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Gwiizhit ginkhii zhat gwa'an k'ii'an ahaa. Yąąh'in, gaa zhyaa yeh'ok hee yehgoo dhizhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Izhit gwik'it Levite gwiginkhii chan yeeniinzhii ts'ą' yąąh'in, tł'ęę yehgoo dhizhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Gaa Samaria gwich'in ch'ihłak yak'adeedhizhii ts'ą' niyiił'in dąį', didrii zhit yeenjit tr'igwidii. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yats'ą' haazhii ts'ą' yakat datthak Olive-ghwai', jak chų' haa dadhanjaa, tł'ęę yakat dich'iłchaa. Dilik choh kat deeyiłchįį ts'ą' gwirich'įį zheh nihdeeyąąhchįį. Izhit hee yik'eełtii. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ąįįtł'ęę gęhdaa drin ąįį juu zhat vizheh gwanlii ąįį laraa ghoo neekwaii yeenjit intł'eiin'ąįį ts'ą' t'iiyahnyąą, ‘Vak'ąąhtii. Dzaa gweekyaa neihdyaa ji', jidii laraa vats'ą' an dhąhtsąįį datthak geenjit nineegoohihkwat,’ ąįį vizheh gwanlii ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Jii dinjii khaiinjii tr'oołkhwąįį ąįį jii dinjii tik nąįį tee gwats'an juu shrit vinee'ok gwich'įį k'it t'ii'in?” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Law eech'ǫąąhtan t'inyąą, “Ąįį juu yats'ą' nizįį ts'ą' yats'ą' tr'iinjik reh.” Jesus t'iiyahnyąą, “Nan chan oo'an neehindii ts'ą' gwik'it t'ini'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus ditsyaa nąįį haa izhit gwats'an tr'ineegiijil ts'ą' ch'adanh kwaiik'it k'eegiidal. Izhit tr'injaa, Martha oaazhii, “Ąįį shizheh gwinch'įį,” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Vijuu, Mary oaazhii, ąįį yakwai' eeghaii dhidii ts'ą' geech'ǫąąhtan yuułk'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha ąįį tr'ihkhit vigwitr'it gwanlii, eenjit vik'įį goodlit ts'ą' Jesus ts'ą' niinzhii ts'ą' jyaa nyąą, “Shik'eegwaadhat, shigwitr'it gwanlii, gwiizhit shijuu zhyaa shits'inyąą kwaa, gwąąh'in? ‘Shits'iinyąą,’ vaiinyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Diik'eegwaadhat jyaa diyahnyąą, “Martha, Martha! Gwinlęįį t'ini'yaa goo'aii, eenjit nik'įį goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gaa ch'ihłak zhrįh t'eegwaahchy'aa. Mary shoołk'įį, ąįį gwinzii t'ii'in ts'ą' adan vats'an t'oonchy'aa, ąįį duuyeh vihłeegwaraha'ąįį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ch'ihłok Jesus zhit gwa'an khadigiinjii. Ndaanaahjik dąį', vitsyaa ch'ihłak t'iiyahnyąą, “Shik'eegwaadhat, khadigiriinjii gidiigwąh'ee, John nats'ąą ditsyaa nąįį googwah'ee gwik'it.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus jyaa goovahnyąą, “Jyąhts'ą' khagadǫhjii, ‘Diiti', Noozhri' Shroodiinyąą tr'ahoh'e'. Nijin drin jii nankat gwidinji' datthak nik'injahahdaa geenjit khadigiriinjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Drin gwiteegwaanchy'aa shih tr'ihee'aa diits'an ąh'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Diitr'agwaanduu diineenjit oo'an gwihinlii, Diikhwan chan juu diits'ą' gwiizųų tr'agwah'in gooveenjit oo'an gwirihilii. Ąįį gwizhit tr'agwaanduu gwiindhan gwits'į' an-diinoaan'ee.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ąįįts'ą' Jesus ditsyaa nąįį jyaa ahnyąą, “Nakhwatee ch'ihłak jyaa diizhik ji' yu'? Tǫhtł'an nijyaa veeninkhee ts'ą' jyaa vahaiinjyaa, ‘Shijyaa, łųhchy'aa tik sheedįįntł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Shijyaa zhit gwa'an neehidik, akhai' shizheh sheek'idik, gaa veenjit shih shi'įį kwaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Akhai' nijyaa zheh gwizhit gwats'an jyaa nahnyąą ji' yu', ‘Shaa nigwiin'ąįį kwaa! Duuyeh neenjit geech'idįhchįį. Shįį, shigii nąįį haa tr'ihįįłchųų. Duuyeh khakisha'ąįį ts'ą' nantł'eech'ałtsit t'oonchy'aa!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ąįįtł'ęę yu', deehee'yaa shrǫǫ yuuhthan? Nakhwaa gwahaldak. Nijyaa nilii, gaa ąįį geenjit khakihee'aa ts'ą' nantł'eech'ahahchaa kwaa. Gaa nihk'it k'ii'ee ch'oahkat ji', nijyaa nilii eenjit gwizhrįh kwaa, gaa jidii t'aahchy'aa datthak nintł'eeheelyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ąįįts'ą' jyaa nakhwahaihjyaa, Vit'eegwijyąhchy'aa oohkat ji', nakhwantł'eegwehee'aa t'inchy'aa. Gwank'oohtii ji', vagahoh'aa t'inchy'aa. Ganloonaii ji', nakhweenjit gidirideenchyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Juu ch'oahkat t'ee vintł'eegwahaatth'aa, ts'ą' juu gwinkeegwaah'in chan yagwahah'aa, ts'ą' juu ganlaanaii chan veenjit gindeiinvyaa eetr'ooheendal t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nakhwatee nik'ee ch'iti' vigii ‘łuk,’ yahnyąą, gwiizhit gyųų choh yintł'eehahchyaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Akwat ch'aghoo ach'oohkat, gwiizhit gwideedrii Scorpion ha'al iizųų yintł'eehahchyaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Deegwahtł'oo ohsųų. Googaa nakhwagii k'aiich'ii nizįį antł'ohłii gaakhwandaii. Izhit gwandaa ts'ą' zheekat Diiti' juu yuahkat, ąįį Ch'anky'aa Shroodiinyąą antł'eehee'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus ąįį dinjii vizhit ch'anky'aa iizųų viginjik kwaa nilii ąįį chyahahchįį, yizhit tr'idiindhat dąį', ąįį dinjii vighit neegahoodlit. Zhat dinjii dilk'ii nąįį datthak goovandaa t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gaa goolat nąįį jyaa diginyąą “Ch'anky'aa iizųų nąįį datthak ts'ą' k'eedeegwaadhat Beelzebul oaazhii ąįį vat'aii haa ch'anky'aa iizųų cheehilii t'ii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Goolat nąįį chan goodhaiinarookhii giiyuunyąą eenjit, “Vit'eegwijyąhchy'aa vat'aii ni'įį ji' ąįį haa diits'ą' nagwąhtsį',” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gaa Jesus deegiindhan goovaandaii ts'ą' jyaa goovahnyąą, “Jidii nahkat nihts'įį nihts'ą' nineegiidal ts'ą' nihłigiighan ji' khants'ą' an gweheelyaa. Zhehk'aa gwizhit chan nihłigiighan ji' t'ee tthak an gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ąįįts'ą' Satan vitsyaa nąįį geedan chan nihłigiighan ji', nats'ahts'ą' ndaagiheedaa? Beelzebul vat'aii eh'an ch'anky'aa iizųų cheehihłii shohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jyąhts'ą' ch'anky'aa iizųų cheehihłii ji', nitsyaa nąįį juu t'aih goots'an ąhtsii haa ch'anky'aa iizųų cheegihilii gǫ'? ");
INSERT INTO gwiNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nakwaa, Vit'eegwijyąhchy'aa vat'aii haa ch'anky'aa iizųų cheehihłii t'ishi'in, ąįįt'ee Vit'eegwijyąhchy'aa nakhweenjit K'eegwaadhat Veegwinii'ee nilii izhit gagwaach'in t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Nijin dinjii nint'aii jidii vaa dinjii tr'aghan datthak haa dik'eiich'i' dizheh gwak'aa nich'itsahthat ji' duuyeh vak'aiich'ii tr'an'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Gaa dinjii gwandaa t'ąąht'aii yats'ą' niinzhii ts'ą' gaayiiyiłtsąįį tł'ęę vaa dinjii tr'aghan yit'injyahchy'aa di'įį datthak yits'į' oonjik ts'ą' gihłeehoozhii tł'ęę dijyaa nąįį teeyaadlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Juu shaa nilii kwaa nąįį t'ee shats'ąįį nadhat kwaa, juu shits'inyąą kwaa ts'ą' shaa khaihłan nigwilii kwaa t'ee shrihtee gwilii t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nijin ąįį ch'anky'aa iizųų dinjii ts'an tr'idiindhat dąį' tthan gwa'an gwizhrįh needahaachik ts'ą' gweheechy'aa gwinkeegwaah'in. Khyų' gogwah'ąįį ts'ą' adats'ą' jyaa nyąą, ‘Ąįį juu vizhit diidhat chy'aa vits'eehihdyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yits'eehoozhii akhai' ąįį dinjii vizhit shragwaazhik łee. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ąįįtł'ęę t'oołii haazhii ts'ą' vandaa ch'anky'aa iizųų 7 nąįį oo'ee neiinlii ąįį nąįį haa giizhit diindhat. Nijin ndaanagąąhjik dąį' ąįį dinjii tr'ookit iizųų chy'aa gwandaa t'agwahtł'oo iizųų dhidlit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nijin Jesus jyaa nyąą dąį', dinjii tee gwa'an gwats'an tr'injaa khaginkhee ts'ą' jyaa yahnyąą, “Ąįį tr'injaa vats'an nagoodlit ts'ą' dink'inahthat łyaa gashoo'ahłi'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gaa Jesus jyaa yahnyąą, “Juu Vit'eegwijyąhchy'aa Viginjik oołk'įį ts'ą' gwik'it t'ii'in ąįį nąįį t'ee ch'andaa ts'ą' łyaa gashoo'ahłi'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Dinjii lęįį nąįį Jesus eelin giilk'ii gwiizhit jyaa goovahnyąą, “Juk gweendaa gwidinjii nąįį łyaa iizųų! Geegwaroolii kwaa goots'ą' goovandaa t'agǫǫ'ya' giindhan gaa ch'ihłak gaa googwahąąh'yaa kwaa, Jonah deezhik izhit gwizhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonah t'ee kwaiik'it gwachoo Nineveh gwich'in nąįį eenjit gwigweelkįį nilii, ąįįt'ee Gwidinji' juk gweendaa dinjii nąįį ts'ą' gwigweelkįį heelyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ch'aroahkat Drin ji' Sheba gwats'an Queen nilii ndak niheehaa ts'ą' juk gweendaa gwidinjii nąįį k'ąą ndaagwahąąddhal ts'ą' gootr'agwaanduu gwanlii heenjyaa. Sheba yeenji' danahkat gwats'an k'idik, King Solomon vigwizhi' gwanlii zhit geech'ǫąąhtan oohąąhky'aa eenjit. Nakhwaagwahaldak, dzaa juk Solomon andaa ts'ą' veegoo'aii diitee t'inchy'aa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ch'aroahkat drin ji' Nineveh kwaiik'it gwachoo gwich'in nąįį ndak niheehaa ts'ą' nakhwak'aa ndaagwahąąddhal. Ąįįt'ee Jonah geech'ǫąąhtan gwigwiitth'ak dąį' dagatr'agwaanduu akhagagoonyąą. Nakhwaagwahaldak, dzaa juk Jonah andaa ts'ą' veegoo'aii diitee t'inchy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Dinjii ch'ihłak duuyeh neech'aahdrii ts'ą' k'ik t'ee gwit'eh yakaii, gaa dinjii nąįį nihdeegijyaa gwiizhit ch'aadrii googwahąąh'yaa eenjit vakaii'aa kat deeyehee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nakhwandee t'ee nakhwazhin eenjit ch'ahdrii k'it t'inchy'aa. Nakhwandee haa gwinzii gweech'in dąį' nakhwazhin datthak adrii gaa nakhwandee haa gwinzii gweech'in kwaa ji' nakhwazhin datthak tǫǫ gwizhit hee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tǫǫ ąįį nakwaa gaa khit Vit'eegwijyąhchy'aa va'aadrii zhit gwizhrįh adadhoodii. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nakhwazhin datthak va'aadrii ts'ą' tǫǫ gwahąąh'yaa kwaa ts'ą' datthak haadrii, adrii nakhwak'aa ch'ahahdrii gwik'it.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nijin Jesus ginkhii ndaanaahjik dąį' Pharisee ch'ihłak yaa ch'ihee'aa eenjit aanaii yahnyąą, ąįįts'ą' yats'ą' nihdeiinzhii ts'ą' naadii ts'ą' ch'ahaa'al. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ąįį Pharisee łyaa gwik'iinjigiighit kwaa nijin Jesus danli' k'eech'ąhtryaa kwaa ts'ą' ch'ahaa'al dąį'. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Akhai' Diik'eegwaadhat jyaa diyahnyąą, “Juk nakhwachųų tyah, nakhwak'ik haa ǫhtsąįį gwizhrįh gwik'eech'ohtryaa gaa nakhwazhit ąįį gwiizųų gwizhrįh haa deegwadąą'ai'. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Łyaa nakhwakiitth'an zhit gwihiljii! Vit'eegwijyąhchy'aa ǫhtsąįį gwiłtsąįį ji' gwizhit chan gwahahtsyaa gwizhrįh goo'aii hee? ");
INSERT INTO gwiNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gaa nakhwak'ik, nakhwachųų tyah zhit k'ii'an neeshraahchy'aa nąįį intł'eech'ohchak, ąįį ji' t'ee jidii datthak nakhweenjit shriitr'eegwahaatth'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Pharisee nąįį, tr'igwidii nakhweenjit goo'aii! Gwanzhįh Mint, Rue vaa vikeech'arahchy'aa ch'ihłoaatin ts'an ch'ihłak Vit'eegwijyąhchy'aa intł'ohtsit gaa ch'izhii nąįį ts'ą' gwinzii t'akhwa'in kwaa ts'ą' Vit'eegwijyąhchy'aa veenjit ch'eet'igwiniindhan khwa'įį kwaa. Jii kwaii jyaa diinchy'aa kwaii akhagoiinyąą ts'ą' nihk'it Vit'eegwijyąhchy'aa vintł'eegohłii. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Pharisee nąįį, tr'igwidii nakhweenjit goo'aii! Israel nąįį tr'igiinkhii zheh kwaii gwizhit hohdyaa nakhweenjit khit tr'iilęįį goo'aii ts'ą' ch'arookwat deek'it gwa'an chan khit ts'ą' gwihil'ee haa nakhwaneerahahdak. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tr'igwidii nakhweenjit goo'aii! Tth'ank'it gwigweech'in kwaa ts'ą' gwakat neegihiidal k'it nakhweegoo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Law eech'ǫąąhtan ch'ihłak jyaa yahnyąą, “Geech'ǫąąhtan, jii jyaa diinaiinyąą t'ee nan chan gwiizųų diits'ą' ginkhii t'iinyąą t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus t'iiyahnyąą, “Law eech'ǫąąhtan nąįį, nakhwan chan tr'igwidii nakhweenjit goo'aii! Dinjii nąįį ant'ii nidii giheeghwaa eenjit ninoh'ak gaa goots'ahohjyaa eenjit nakhwanleetth'ak gaa hohchįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Tr'igwidii nakhweenjit goo'aii! Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį eenjit tth'ank'it gwihil'ee nagoo'aii, dąį' t'ee yeenii nakhwalak nąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį giinghan izhit nakhweenjit gwinzii t'igwiizhik geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Nakhwandah t'igwiizhik ts'ą' chan yeenii nakhwalak deezhik ąįį nakhweechįį t'igiizhik; ąįįt'ee Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį ęhdaa tr'igwigwiin'ąįį ąįįtł'ęę nakhwan ąįį gootth'ank'it gohtsii. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ąįį eenjit t'ee Vit'eegwijyąhchy'aa vigwizhi' jyaa nyąą, ‘Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį chan ts'ą' Tr'ihił'e' nąįį haa goots'ą' nihihłyaa goolat nąįį chan ęhdaa tr'igwigwehee'aa ts'ą' giiyuuheendal gwik'eegogwandaii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ąįįt'ee jii nan goodlit dąį' gwanaa gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį giinghan eenjit juk gweendaa gwidinjii nąįį agwarahahshįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel tr'oołkhwąįį gwats'an oondaa nijin Zechariah ataiinjii tr'ahtsii deek'it chan ts'ą' Kharigidiinjii Zhee Gwachoo haa gwiteetł'an tr'iiłkhwąįį gwats'ą'. Aahą', naagwaldak, juk gweendaa gwidinjii nąįį ąįį kwaii geenjit googwarahaahshii. ");
INSERT INTO gwiNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Law eech'ǫąąhtan nąįį, tr'igwidii nakhweenjit goo'aii, gwik'eegwahaandal eenjit zheh goo'aii ąįį gwadąįį lidlįį gwits'į' ohtą'. Nakhwan googaa nihdeedoochįį kwaa ts'ą' juu nihdeeheehaa geetr'agwah'in nąįį datthak chan zhak ohdak!” ");
INSERT INTO gwiNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nijin Jesus zhat chineezhii dąį' Law eech'ǫąąhtan chan ts'ą' Pharisee nąįį haa łyaa gook'įį gwanlii ts'ą' gwinlęįį gigiiyuahkat, ");
INSERT INTO gwiNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","goodhaii nihdeegiihaathal ts'ą' ch'ijuk khagiheekhyaa ji' eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Izhit zhat dinjii thousands nąįį khaihłan niinjil ts'ąįį gaa nihkat deegaa'aa, Jesus ditsyaa nąįį tr'ookit jyaa ahnyąą, “Pharisee nąįį łųh vaaniituu gwik'it t'ii'in ąįį goots'į' adak'ǫǫntii, zhit gwik'iinjiighit adaa'įį nąįį t'agwaihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jidii nagogwąąh'įį ąįį kwaii gwizhrįh nigweheedaa ts'ą' datthak gwik'igahaandal gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ąįįts'ą' t'ee tǫǫ gwizhit deiinyą' ąįį drin gwizhit nireheetth'ak, zheh gwizhit dinjii haa dandzit ąįį chan zheh gwikiit'ik k'iidak shraa haa t'ihiinjyaa gwireheetth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Shijyaa nąįį, nakhwaagwaldak, dinjii oonjat shrǫ', dinjii ch'izhii dinjii vizhin haahkhwaa gaa jyąhts'ą' t'ee łyaa yats'ą' gwiizųų tr'agwahaah'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Juu vahaanjat naagwahaaldak: Vit'eegwijyąhchy'aa veech'andaii ǫhłįį, dinjii ęhdaa tr'igwiin'ąįį ąįįtł'ęę t'ee adan zhrįh hell nanakhwahahchyaa. Aahą', naagwaldak, veech'andaii ǫhłįį! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Neek'ik ch'ihłoanli' laraa tsoo tsal neekwaii t'įį tr'iheelyaa lee t'oonchy'aa? Ąįį googaa ch'ihłak gaa Vit'eegwijyąhchy'aa yinildee kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nakhwakiighai' daanchy'aa gaa, Vit'eegwaahchy'aa gaandaii t'inchy'aa. Ąįį geh'an noojat shrǫ', neek'ik daanchy'aa ji' gaa ąįį andaa ts'ą' khadhoo'ee t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nakhwaagwaldak, juu gwandah shaa nilii nyąą, Gwidinji' chan yeenjit Vit'eegwijyąhchy'aa vats'an zheekat gwich'in nąįį andah shaa nilii vaahaihjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gaa juu gwandah shaa nilii kwaa nyąą, Gwidinji' chan yeenjit Vit'eegwijyąhchy'aa vats'an zheekat gwich'in nąįį andah shaa nilii kwaa vaahaihjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Juu Gwidinji' ts'ą' gwinehts'į' khaginkhee ąįį veenjit oo'an gweheedaa; gaa juu Ch'anky'aa Shroodiinyąą inehts'į' khaginkhee ąįį duuyeh veenjit oo'an gwihijyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Israel nąįį tr'igiinkhii zheh akwat gwats'ą' k'eegwaadhat choh nąįį, Governor nąįį ts'ą' nanakhwarąąhchįį ji' gaa nats'ąą cheedahanchyaa akwat deehiinjyaa eenjit tr'agoiindii shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Izhit nigwiindhat ji' Ch'anky'aa Shroodiinyąą deehiinjyaa nahahtsyaa geenoohąąhchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Dinjii tee gwa'an gwats'an dinjii jyaa yahnyąą, “Geech'ǫąąhtan, zhit shiti' veegoo'aii datthak shoondee haa diineenjit akhoonyąą. Ąįį shoondee teetł'an nih'an tr'ooheendal goo'aii vaiinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus jyaa yahnyąą, “Dzaa gwąąh'in! Juu ch'aroahkat zheh gwizhit noohaałkat akwat niti' veegoo'aii, noondee haa teetł'an ǫhjii nakhwahaihjyaa eenjit sheenjit gwiłtsąįį?” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ąįįts'ą' datthak chan jyaa goovahnyąą, “Gwak'ǫǫhtii, k'aiich'i' eenjit dinjikhwaghit shrǫ'! Dinjii hil'ee k'iighai' gwandaii di'įį kwaa t'oonchy'aa,” jyaa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ąįįtł'ęę Jesus gwandak eegoovaagwaandak, “Ch'ihłan dinjii gwintsii veegoo'aii. Nan nitsii di'įį. Kat gwanzhįh nizįį niłshįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Idizhit niinjich'adhat ts'ą' jyaa diindhan, ‘Gwanzhįh noołshįį kwaii nijin nihihłyaa? Videek'it gwishi'įį kwaa. Deehishi'yaa li'?’ ");
INSERT INTO gwiNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Adahaa niinjich'adhat, ‘Shadraa kwaii khadigwihįhłyaa ts'ą' gwintsii neegwahałtsyaa, ts'ą' shagwanzhįh, shishii kwaii nihdeehihłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","It'ee łyaa shidivee gwinzii. Shih niighyuk vit'eehaałchy'aa shi'įį. Zhyaa hihdyaa. Ąįįts'ą' ch'ihih'aa. Hihchyaa. Deeshi'yaa gwik'it t'ihishi'yaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Vit'eegwijyąhchy'aa jyaa yahnyąą, ‘Tr'igwiinjik kwaa! Juk khaa gwats'ą' gwizhrįh gwihiindaii. Ąįįtł'ęę juu nats'an kwaii ts'ą' k'eegwahaadhat?’” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nijin Jesus gwandak eegwaandak ndaanaahjik dąį', jyaa nyąą, “Jyąhts'ą' t'ee juu adan zhrįh ideenjit k'aiich'i' tthak di'įį, haa gwintsii veegoo'aii, gaa Vit'eegwijyąhchy'aa ąįį gwintsii veegoo'aii k'it yąąh'in kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ąįįtł'ęę Jesus ditsyaa nąįį jyaa dahnyąą, “Izhit geenjit goohǫhdaii eenjit shih eenjit ninjich'ǫhthat kwaa akwat chan gwach'aa nohoozhyaa chan gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Gwarandaii ąįį shih andaa ts'ą' gwihil'ee, ąįįts'ą' diizhin chan gwach'aa andaa hil'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Zhit deetrya' kwaii nǫh'in, gogwąąhshii khagiiyilii kwaa t'inchy'aa, dagogwanzhii gahahdlyaa gwakwaa, Vit'eegwijyąhchy'aa yach'ah'aa t'inchy'aa! Chiitsal nąįį andaa ts'ą' nakhweegoo'aii! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Duuyeh ch'ihłak gaa geenjit tr'igwidii ts'ą' nahgwan neegwiindaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jii gwarandaii zhit jidii gwatsal khyų' t'agwah'in gwiizhit jaghaii ch'andaa gwa'an geenjit tr'igwindii. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Zhit gwa'an nankat gwanzhįh gwinzii vigweech'in nahshii nǫh'in. Ąįį tr'agogwah'in kwaa ts'ą' gwach'aa ideenjit gahtsii kwaa t'inchy'aa. Gaa naagwaldak, King Solomon łyaa valaraa gwanlii gaa jyaa dagwahtł'oo ąįį gwanzhįh gwinzii vigweech'in andaa ts'ą' vagwach'aa nizįį kwaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Vit'eegwijyąhchy'aa ąįįt'ee zhit gwa'an gwanzhįh anagwąąhshii t'inchy'aa juk drin gwanzhįh nilii tł'ęę nihkaa an heelyaa, ch'iitsii zhit heek'an. Ąįįts'ą' łyaa gwach'aa nanahąąhshyaa t'inchy'aa. Gwik'iinjiighit natsal ni'įį! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Jii ch'ihin'aa, chųų nihinjyaa kwaii eenjit tr'igwindii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ąįį juu jii nankat Vit'eegwijyąhchy'aa eenjit gwik'iinjiighit di'įį kwaa nąįį t'ee jii kwaii datthak geenjit tr'igwigwidii. Zheekat Nakhwati' jii kwaii t'ohchy'aa nakhwaandaii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","K'eegwaadhat Veegwinii'ee gwats'ą' hoh'al eenjit tr'agoh'in ąįįts'ą' jii kwaii nakhwats'an hahtsyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Divii tsya' tsal nąįį, noojat shrǫ'! Ąįįt'ee Zheekat Nakhwati' nijin drin jii nankat dinjii datthak idik'iinjyahjik ts'ą' vaahohłyaa nakhweenjit gwiłtsąįį ąįį nakhwantł'eehee'aa geenjit shoo nilii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nakhwagwadal kwaii laraa t'įį hohłii ts'ą' ąįį laraa chan neeshraahchy'aa nąįį tohłii. Khahthaa tsal iizųų heelyaa kwaa ideenjit shrohłii ąįįts'ą' zheekat ideenjit khaihłan nagohłii, izhit t'ee duuyeh nitsya' ilii, ch'an'įį nąįį chan duuyeh yeenakhaii ts'ą' duuyeh chan moths ya'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nijin khaihłan nagoolii izhit t'ee nakhwadrii dha'aii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Naatreegwideheetal eenjit łyaa oohadhanzhii, ni'ik nats'ooghaih hąhtsųų kwaa geenjit gwint'aii nazhrak tł'an dąhchaa ts'ą' zhit adrii chan dǫǫk'a'. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Zhit juu goots'ą' k'eedeegwaadhat ts'ą' giiyeetr'agwah'in nilii nąįį dąhthee nihłeegwarahchįį gwats'an oo'ee neeheedyaa nigiiyuul'in gwik'it t'ohchy'aa. Nijin oo'ee neezhįį ts'ą' ganlaanaii ji', zhazhat giiyeenjit gidiheechyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nijin ąįį goots'ą' k'eedeegwaadhat nilii oo'ee neezhįį ts'ą' vitsyaa nąįį tth'aii gagaandaii łee ts'ą' nigwigwil'in łee ji' łyaa geenjit adashoogahahłyaa gwachoh! Naagwaldak, adan ąįį di'ik dazhrak tł'an dahahchaa ts'ą' goohąąhdyaa ts'ą' shih goovehzhee nitł'eeheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tǫhtł'an gęhdaa giiyeenjit nagogwal'in tł'ęę goots'ą' nihdineezhii ji' łi'haa adashoogahahłyaa gwachoh! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ąįįts'ą' jii ganoondaii! Dinjii ch'ihłak nijin ji' ch'an'įį nąįį yizheh łeegwahahnaii gaandaii ji' duuyeh gwik'it t'igwinjii gwah'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ąįįts'ą' nakhwan chan, oohadhanzhii, nijin geegoiinlii kwaa gwiizhit t'ee Gwidinji' k'ineeheedik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter jyaa nyąą, “Shik'eegwaadhat, jii gwandak zhit geediinǫąąhtan, diikhwan zhrįh lee t'idiinaiinyąą? Akwat juu nąįį datthak chan lee?” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","K'eegwaadhat yidii khaginkhee, “Juu k'eegwaadhat vitsyaa nilii nąįį tee gwinzii gwitr'it t'agwah'in ts'ą' chan goozhii, ąįį dinjii jidii k'it t'inchy'aa dinjii t'arahnyąą? Adan ąįįt'ee zhit juu yats'ą' k'eegwaadhat gwats'ą' k'eegwaadhat yahahtsyaa. Zheh gwizhit chan gwats'ą' k'eegwahaadhat ts'ą' zhit juu yaatr'agwah'in nąįį chan drin gwiteegwaanchy'aa zhat nineegwiidhak hee ach'ahah'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nijin zhit juu yats'ą' k'eegwaadhat oo'ee neezhįį ts'ą' jyaa dii'in ji' łyaa adashoohahłyaa gwachoh! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Naagwaldak! Ąįį juu yats'ą' k'eegwaadhat zhit veegoo'aii datthak geenjit k'eegwaadhat yahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gaa ąįį dinjii jyaa adaanyąą, ‘Shats'ą' k'eegwaadhat oo'ee neeheedyaa eenjit niighyuk gwahthaa,’ nyąą ts'ą' zhit dinjii akwat tr'injaa juu yaatr'agwah'in nąįį dahkhwaii ts'ą' ch'a'aa tł'ęę neech'iniinjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Nijin drin geeneeyuulii kwaa gwiizhit zhit juu yats'ą' k'eegwaadhat yazhrahtee k'ineeheedik, gwint'aii yagwahąąhshii ąįįts'ą' gwik'iinjiighit kwaa nąįį tee yahahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ąįį juu ch'itsyaa nilii zhit yats'ą' k'eegwaadhat ts'ą' adan chan deehee'yaa gaandaii googaa oohilzhin kwaa ts'ą' chan yats'ą' k'eegwaadhat doo'ya' yuunyąą gwik'it t'ii'in kwaa ąįįt'ee gwintł'oo yahahtrii. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gaa juu ch'itsyaa nilii ts'ą' yats'ą' k'eegwaadhat jidii doo'ya' yuunyąą ąįį gaandaii kwaa ts'ą' dee'ya' k'iighai' geenjit gwintsal tr'ahahtrii. Vit'eegwijyąhchy'aa ąįį juu dinjii gwintł'oo vidivee gwinzii ts'ą' intł'eegwa'ak ąįįt'ee yats'an gwandaa ts'ą' geeneegoolii. Juu dinjii yit'injyaahchy'aa nilii ąįįt'ee gwandaa ts'ą' dinjii lęįį nąįį yats'an geeneegooheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Jii nan kǫ' vihihtthal eenjit dzaa gwats'ą' hoiizhii. Ch'adąį' daak'a' ji', oihnyąą gwiizhit! ");
INSERT INTO gwiNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Khaiinjich'asharahthat sheenjit goo'aii izhit gęhdaa tr'ihihshyaa gwats'ą' gwintł'oo shiyinji' haa nigwii'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nankat tsinehdan gwintł'eehih'aa eenjit dzaa gwats'ą' hoiizhii shrǫǫ niindhan? Nakhwaagwahaldak! Tsinehdan, ąįį nakwaa, gaa nihts'įį nanakhwahihłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Juk gwats'an zhehk'aa gwizhit juu ch'ihłoanli' gwich'įį nąįį nihts'an tr'igiheedaa tik nąįį, neekwaii ts'ą' nich'itsigahahthat, neekwaii nąįį chan tik nąįį ts'ą' nich'itsigahahthat. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ch'iti' nąįį chan digigii tsyaa nąįį ts'ą' nich'itsigahahthat. Googii tsyaa nąįį chan digiti' ts'ą' nich'itsigahahthat. Ch'ahan nąįį chan digigii nich'it ts'ą' nich'itsigahahthat, ts'ą' googii nich'it chan dagahan ts'ą' nich'itsigahahthat. Gavootr'i' nąįį chan gootseii nąįį ts'ą' nich'itsigahahthat, ts'ą' gootseii nąįį chan dagootr'i' nąįį ts'ą' nich'itsigahahthat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus dinjii nąįį chan jyaa ahnyąą, “Nijin yeenaa zheek'ǫh alaa nǫh'in dąį', zhazhat ‘Hahtsin t'oonchy'aa,’ dohnyąą ts'ą' it'ee ąhtsin. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ąįįts'ą' nijin yeenii nakhwaneiintr'aii dąį' ‘Gweheendhaa t'oonchy'aa,’ dohnyąą ts'ą' it'ee gwiindhaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gwik'iinjiighit adaa'įį nąįį! Zhit zhee, nan haa nǫh'in gwik'iighai' deehee'yaa gaakhwandaii, gaa jaghaii jii gweedhaa, ąįį gaakhwandaii kwaa t'ohchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Jaghaii jidii gweheezyaa ts'ąįį ideenjit gaakhwandaii kwaa t'ohchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dinjii gwiizųų t'inizhik nahnyąą ts'ą' ch'aroahkat zheh nihdeenąąhchįį ji'. Ch'aroahkat zheh gwats'ą' vaa inkhaa gwiizhit vaa gwinzii nineegwin'ąįį gwik'eegwiindaii, ąįį ji' ąįį juu vandaa diiroahkat ts'ą' nanahahchyaa kwaa eenjit, ąįį chan gwak'ąąhtii nąįį ts'ą' nanahahchyaa ts'ą' ąįį chan zhee gwaazhrąįį nanahahchyaa t'oonchy'aa, ");
INSERT INTO gwiNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","naagwahaaldak izhit duuyeh chineiindii, dahthee nalaraa tsal datthak haa goiinkwat gwats'ą' datthak.” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Izhit zhat dąį' dinjii lat nąįį Jesus Galilee gwich'in nąįį eegiiyaagwaandak, ąįįt'ee zhit juu gootee Vit'eegwijyąhchy'aa ts'ą' gwintł'eegąhjii gwiizhit Pilate gooviinghan nąįį reh. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus jyaa goovahnyąą, “Ąįį juu gooriinghan nąįį ch'izhii Galilee gwich'in nąįį andaa ts'ą' gootr'agwaanduu gwanlii geh'an t'agooriinlik shrǫǫ goovohnyąą? ");
INSERT INTO gwiNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nakwaa! Nakhwaagwahaldak, nakhwatr'agwaanduu akhagohnyąą kwaa ji', nakhwan t'ee gook'it nahohthaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Zhit Siloam gwich'in 18 juu zhit zheh gwachoo gook'aa neegwadąąnąįį ts'ą' giłchįį nąįį yu'? Ch'izhii Jerusalem gwich'in nąįį andaa datthak ts'ą' gootr'agwaanduu gwanlii geh'an lee t'igiizhik? ");
INSERT INTO gwiNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nakwaa! Nakhwaagwahaldak, nakhwatr'agwaanduu akhagohnyąą kwaa ji', nakhwan t'ee gook'it nahohthaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ąįįtł'ęę Jesus gwandak eegoovaagwaandak, “Dinjii dagwanzhih tee Fig dachan nahshii. Ąįį dinjii zhit Figs dachan kat gwąąh'in, akhai' yakat Figs agwąh'ąįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ąįįts'ą' gwanzhįh k'ąąhtii ąįį t'ahnyąą, ‘Gwąąh'in, neegwadadhat tik gwahaadhat tthak dzaa nineihdik ts'ą' jii Fig dachan kat Figs keegwaał'in gaa Figs agwał'ąįį kwaa. Gihłeekhwanchyaa jaghaii? Jaghaii zhyaa gwanzhįh dehk'it gwinii'ee?’ ");
INSERT INTO gwiNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Gwanzhįh k'ąąhtii t'iiyahnyąą, ‘Jii neegwadadhat ch'ihłak zhit jyaa dąhthan, ąįįts'ą' veelin khaneegwihihthaa ts'ą' shrineehihłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ąįįtł'ęę Figs vakat neełshįį ji', gweheezyaa, ąįį akwaa ji' gihłeereheechyaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ch'ihłan Neegwaazhii Drin gwiizhit Jesus ąįį Israel nąįį tr'igiinkhii zheh gwizhit geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Izhit gwizhit tr'injaa dhidii ąįį 18 years łąą vizhit ch'anky'aa iizųų dhidii, ąįį ts'an gwintł'oo iłts'ik, vanan ch'iłtsąįį ts'ą' khyų' k'igwąą'ee nadhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nijin Jesus niyiił'in dąį' aanaii yahnyąą ts'ą' t'iiyahnyąą, “Tr'injaa, juk gwats'an t'ee ch'anky'aa iizųų ts'an neehants'ik kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yakat naanjik ts'ą' zhat łyaa k'igwąą'ee nadhat naanaii ts'ą' izhit zhat Vit'eegwijyąhchy'aa geenjit deehiił'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Israel nąįį tr'igiinkhii zheh gwizhit gwats'ą' k'eegwaadhat nilii łyaa Neegwaazhii Drin dinjii shrininlik eenjit vik'įį gwanlii, ąįįts'ą' dinjii nąįį ts'ą' khaginkhee. “Nihk'iitik drin gwizhrįh tr'agwarahah'yaa geenjit goo'aii, izhit drin gwizhrįh nakhwats'ą' tr'ireheendal eenjit oo'ee neekhwadal. Neegwaazhii Drin t'agwaihnyąą kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Diik'eegwaadhat t'iiyahnyąą, “Gwik'iinjiighit adaa'įį ǫhłįį! Neegwaazhii Drin nakhwąnin kwaii dineegoovahoh'at ts'ą' chųų goovahohjyaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gwiizhit jii tr'injaa yeenii Abraham ts'an deedhaa 18 years łyaa Ch'anky'aa Tr'aanduu (Satan) yits'ą' k'eegwildhat, ąįį lee Neegwaazhii Drin Ch'anky'aa Tr'aanduu ts'an gadarahahchyaa kwaa goo'aii?” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jii deenyąą eenjit zhit juu yitr'ii'ee nąįį ideenjit oozhii gaadlit, gwiizhit ch'izhii dinjii nąįį andah geegaroolii kwaa t'iizhik datthak geenjit łyaa shoo ginlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus ch'oahkat, “K'eegwaadhat Veegwinii'ee doonchy'aa t'agwarahnyąą? Jidii geeghaih gwik'it t'oonchy'aa haa nihłaa geegihihkhyaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jii k'it t'oonchy'aa, dinjii ąįį mustard seed tsal oonjik ts'ą' gwanzhįh dehk'it gwit'eiin'ąįį ąįį niłshįį ts'ą' ts'iivii nitsii dhidlit, ąįįts'ą' chiitsal kwaii yakat t'oh ąhtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Chan hee Jesus ch'oahkat, “K'eegwaadhat Veegwinii'ee jidii geeghaih gwik'it t'oonchy'aa haa nihłaa geegihihkhyaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jii k'it t'oonchy'aa, tr'injaa tyah choh zhit łųh deedąą'ąį' tee łųh vaanahshii gwiteiinjaa, ąįį łųh datthak vaa hąąhshii gwats'ą' datthak.” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus ąįį Jerusalem gwats'ą' ahaa gwiizhit zhit gwa'an kwaiik'it gwatsal, kwaiik'it gwachoo gwitee ahaa ts'ą' geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Dinjii ch'ihłak yuahkat, “K'eegwaadhat, dinjii nitsya' nąįį zhrįh neeheezhii lee t'oonchy'aa?” Jesus jyaa diyahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Gindeiinvyaa k'it łyaa gwiints'ik gaa nihdeehinhaa geetr'agwah'in; dinjii lęįį nąįį nihdeegiheedaa geetr'agogwahah'yaa gaa khyų' t'igihee'yaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ąįį zheh gwats'ą' k'eegwaadhat khakihee'aa ts'ą' angineehąhdal. Ąįįtł'ęę chiitąįį niindhat ts'ą' ganlaanaii ts'ą' jyaa deehiinjyaa, ‘K'eegwaadhat! Sheenjit gihdiinchįį!’ Oozhaa jyaa nahaanjyaa, ‘Juu inlii? Nijin gwats'an inkhaa naashandaii kwaa!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ąįįtł'ęę jyaa vahaiinjyaa, ‘Naa neech'irin'al ts'ą' chan naa ch'ireenį' ts'ą' diikwaiik'it gwizhit chan geech'ǫąąhchya'!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Chan hee jyaa nahaanjyaa, ‘Nijin gwats'an inkhaa naashandaii kwaa. Dinjii tr'aanduu gwahtsii nąįį, shihłeekhwajyaa!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham, Isaac, Jacob chan ts'ą' ch'izhii Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį datthak nah'in ji' gwintł'oo hintree ts'ą' nagho' nihts'ą' łǫǫn'al haa neiink'ii k'it t'ini'yaa, nijin chit'eenirahaahkhii gwiizhit ji'! ");
INSERT INTO gwiNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jii nihky'aa nankat gwats'an dinjii nąįį K'eegwaadhat Veegwinii'ee gwizhit vakat ch'ara'aa ts'ą' gahaaky'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Zhat ji' juk juu yeenii nilii nąįį goolat tr'ookit giheelyaa, ąįįts'ą' juk juu tr'ookit nilii nąįį yeenii heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Izhit gwiizhit chan Pharisee lat nąįį Jesus ts'ą' gahaajil ts'ą' jyaa giiyahnyąą, “Herod nęhdaa tr'agoih'aa noonyąą t'inchy'aa. Cheehindii ts'ą' t'oołii gwa'an gwats'ą' hinkhaii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesus t'agoovahnyąą, “Ąįį neegǫǫ jyaa vohnyąą, ‘Juk drin, nihkaa haa dinjii ts'an ch'anky'aa iizųų tr'ihłii ts'ą' iłts'ik nąįį chan shrineihłii, drin tik ęhdaa tr'igwiighit gwiizhit ndaanahałdal.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Juk drin, nihkaa, nihkaa gęhdaa kwaii haa datthak jyaa dishihi'yaa eenjit gwats'ą' ihshyaa t'ishi'in Jerusalem geh'ok Vit'eegwijyąhchy'aa Eenjit Ginkhii ęhdaa tr'igwirehee'aa kwaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem! Nakhwatee juu Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį aghan ts'ą' juu Vit'eegwijyąhchy'aa nakhwats'ą' hił'e' nąįį chan kii haa dohkhok. Gwilin neegweedhat gwizhit zhat gwich'in nąįį datthak ts'ą' khaihłan nineegavoihłyaa goovoihnyąą, zhit gwa'an dats'an digii tsal nąįį datthak dit'ee t'eh iłdlii gwik'it gaa khyų' t'anaihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nizheh nits'į' gwarooheendal. Naagwaldak, shahąąh'yaa kwaa nijin drin jyaa deehiinjyaa gwats'ą', ‘K'ii'ee juu ahaa Vit'eegwijyąhchy'aa voozhri' zhit Vit'eegwijyąhchy'aa yaa shoo oolį'.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ch'ihłan Neegwaazhii Drin gwiizhit Jesus ąįį Pharisee kheihkwaii nąįį ch'ihłak zheh yaaneech'ahaa'al. Zhat dinjii nąįį łyaa Jesus deehee'yaa ji' eenjit gwinzii k'eek'aahtii. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Zhat vęhdaa łąą dinjii vatth'an, vigin haa ilzhal dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ąįįts'ą' Jesus, Pharisee chan ts'ą' Law eech'ǫąąhtan nąįį ts'ą' khaginkhee ts'ą' goovahkat, “Dii-Law zhit gwa'an nik'ee Neegwaazhii Drin gwizhit dinjii shrineereheelyaa akwat nakwaa haa ch'ihłak nik'ee gwinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gaa reh giidii ginkhe' kwaa. Ąįįts'ą' Jesus ąįį dinjii oonjik ts'ą' yats'ą' tr'iinjik ąįįtł'ęę t'oołii neeyihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ąįįtł'ęę t'agoovahnyąą “Nakhwagii akwat nakhwa-Ox ąįį Neegwaazhii Drin gwizhit chųųk'it gwizhit t'aanaii ji', Neegwaazhii Drin gwizhit geh'an khaneehohchyaa kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Gaa deegiihaanjyaa gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nijin ąįį juu ch'igihee'aa eenjit zhat dilk'ii nąįį gwinzii gahaaky'aa gwideek'it gwankagantii Jesus gooky'anjik dąį', jii gwandak zhit geegavoąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nijin nihłeegwarahchįį ch'ara'aa gwarahtsii eenjit aanaii nakhwarahnyąą dąį', gwinzii hooky'aa gwinkeehoh'ik kwaa. Duulee nakhwandaa t'agwahtsii veegoo'aii chan zhat aanaii varahnyąą ji', gaanandaii kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ąįį juu nihłaa aanaii nakhwahnyąą ąįį nakhwats'ą' niheehaa ts'ą' jyaa nahaanjyaa, ‘Dzaa heedyaa eenjit vintł'eegwiin'ąįį!’ Ąįįts'ą' gwintł'oo geegoo'aii kwaa. Ąįį hindyaa ts'ą' ada'oozhii hahłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Izhit gwits'į' aanaii narahnyąą dąį', gwintł'oo geegoo'aii kwaa gwideek'it ts'ąįį dhindii. Ąįį ji', ąįį juu aanaii nahnyąą nats'ą' heekhaa ts'ą' jyaa nahaanjyaa, ‘Aanaii shijyaa, dzaa gehdee gwinzii hee dhindii.’ Jyaa naraiinyą' ji', t'ee zhat dilk'ii nąįį tthak łyaa hoon'ee łee googwahąąh'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Juu gwintsii veegoo'aii adoonyąą, t'ee zhak gineerahahchyaa. Gaa juu gwintsii veegoo'aii kwaa adoonyąą, ąįįt'ee łyaa gwintsii veegoo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ąįįtł'ęę Jesus ąįį juu haa neech'ahaa'al jyaa ahnyąą, “Zhit gwa'an nijyaa, nachaa, nalak akwat valaraa gwanlii neh'at gwich'įį nąįį gooch'ahah'aa aanaii goovoiinyą' shrǫ' jyaa nizhik ji', geedan chan ch'ihin'aa eenjit aanaii nagahaanjyaa, ts'ą' deeni'ya' eenjit nineegwarookwat k'it nihk'it t'igwiichy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gach'ahąh'aa ji', juu neeshraahchy'aa, veegogwantrii, neehidik kwaa ts'ą' vandee kwaa nąįį, ach'ąh'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nineegogooheekwat gagadhan kwaa gaa Vit'eegwijyąhchy'aa nashoohahłyaa ts'ą' nineegwahahtsyaa, nijin drin dinjii łi'didlii nąįį neegwiindaii ji'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nijin ąįį dinjii ch'ihłak vakaa'aa ts'ą' dhidii gwaak'įį dąį' Jesus jyaa dahnyąą, “Juu K'eegwaadhat Veegwinii'ee gwizhit k'iindaa vakaa'aa ts'ą' giilk'ii shoo giheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus t'iiyahnyąą, “Dinjii ch'ihłak gwintł'oo vikeech'iłchy'aa ts'ą' lęįį nąįį ch'ihee'aa eenjit aanaii ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nijin it'ee datthak shrigwiinlik dąį' ditsyaa ąįį juu ineech'ehił'al nąįį jyaa varoonyą' nyąą, ‘Aanaii, nanakhwadhal'in!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Gaa gootee googwąąnchy'aa ts'ą' gwats'ą' gihijyaa gitr'igii'ee ts'ą' ch'ihłak jyaa nyąą, ‘Gwanzhįh deek'it goiihkwat ts'ą' zhat nihihshyaa goo'aii; łyaa duuyeh ch'ara'aa nihshee,’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ch'izhii chan jyaa nyąą, ‘Aak'ii ch'ihłoaatin oiikwat ts'ą' gwinzii gwitr'it googwahah'yaa ji' eenjit goovahał'yaa łyaa duuyeh ch'ara'aa nihshee,’ nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ch'izhii chan jyaa nyąą, niighit kwaa dąį' goodhiijik ts'ą' ąįį geh'an duuyeh ch'arehee'aa nihshii. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ąįį goots'ą' k'eedeegwaadhat vitsyaa oo'an neehoozhii ts'ą' deeginyąą datthak yaagwaandak. Ąįį zheh gwizhit gwats'ą' k'eedeegwaadhat nilii zhiilts'įį ts'ą' ąįį ditsyaa jyaa dahnyąą, ‘Khan oo'ok tąįį gwinjik gwa'an gwats'an neeshraahchy'aa chan ts'ą' veegogwantrii chan ts'ą' vandee kwaa chan ts'ą' neehidik kwaa nąįį haa oo'ee neegoovinlii,’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ąįįts'ą' t'ee vitsyaa jyaa nyąą, ‘K'eedeegwaadhat, deegoo'ya' diinyąą chy'aa gwik'it t'igwiizhik gaa tth'aii hee lęįį nąįį ch'ihee'aa eenjit vakaa'aa dhidlii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ts'ą' t'ee gwats'ą' k'eedeegwaadhat ąįį ditsyaa jyaa ahnyąą, ‘Oo'ok nanhtee gwa'an tąįį gwinjik, ts'ą' tr'ał tee niighit gwats'an dinjii oo'ee neiinlii, ąįį ji' shizheh dinjii deedahąą'ąį'. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nakhwaagwahaldak, zhit dinjii datthak juu ch'ihee'aa geenjit aanaii goovaihnyąą ch'ihłak gaa duuyeh ach'ał'aa t'oonchy'aa,’ nyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Dinjii lęįį nąįį Jesus haa adaa. Goots'ii ahaa ts'ą' goots'ą' neediil'ee ts'ą' t'agoovahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Juu shats'ą' hoozhi' niindhan, duuyeh shitsyaa nilii, akwat dahan, diti', da'at, digii, dachaa, dijuu, adan nąįį haa shandaa eet'iindhan ji'. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Juu da-cross ichyaa kwaa ts'ą' shatąįį haazhii, ąįį duuyeh shitsyaa nilii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nakhwatee ch'ihłak zheh gwintsii gwahahtsyaa ji', tr'ookit heedyaa ts'ą' deegwahtsii gweheelyaa, akwat zheh gwintsii geenjit laraa di'įį ji', eenjit shrigweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Jyaa diizhik kwaa ji', zheh gwitł'ee gwizhrįh nigwehee'aa ts'ą' ndak ts'ą' duuyeh shrigwilii. Ąįįts'ą' juu andah t'iizhik nąįį datthak giiyeheedlaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Jii dinjii gwihiłtsąįį, gaa khyų' shrigwilii,’ jyaa digiheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","King ch'ihłak viniveet'ah'in 10,000 di'įį ts'ą' ch'izhii King ąįį chan 20,000 nąįį di'įį, ąįį nąįį haaghan ji', heedyaa ts'ą' gwinzii gininjich'ahahthat, ch'izhii King andaa t'ąąht'aii ji' eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gwandaa t'ąąht'aii kwaa ji', ch'izhii King niighit gwa'an dhidii gwiizhit yats'ą' nideech'ihee'aa, nihłigiheeghaa kwaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesus ndaanich'igįįnkhee, “Izhit gwik'it, nakhwatee ch'ihłee gaa duuyeh shitsyaa nilii, jidii di'įį, datthak akhagoonyąą ji' gwizhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Lisil nizįį, gaa vagwaandaii kwaa dhidlit ji' chan duuyeh lisil k'it vagwaandaii neerahtsii ąįį lisil iizųų. ");
INSERT INTO gwiNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nankat akwat nin trin kwaii eenjit gaa iizųų; ts'ą' oo'an tr'ahahtł'aa. Ch'oodǫǫhk'įį, nakhwadzee gwanlii ji'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ch'ihłan drin zhit gwa'an tax eenjit laraa oonjii nąįį, dinjii vatr'agwaanduu nąįį haa Jesus goohaahky'aa eenjit ts'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pharisee chan ts'ą' Law eech'ǫąąhtan nąįį haa łyaa gitr'igii'ee ts'ą' jyaa ginyąą, “Jii dinjii vatr'agwaanduu gwanlii nąįį hił'ee ts'ą' goovaa gaa ch'a'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ąįį eenjit jii gwandak kwaii gwizhit geegavoąąhtan, ");
INSERT INTO gwiNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nakhwatee ch'ihłak divii 100 di'įį, akhai' ch'ihłak haa tr'igweendaii ji', deehee'yaa t'inchy'aa? Divii 99 kwaii tthan gwa'an akhooheenjyaa ts'ą' divii ch'ihłak ineegwahah'aa gwats'ą' datthak niheentyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nijin yineegwąh'ąįį dąį', it'ee łi' shoo nilii ts'ąįį daghwahk'at diyahahdyaa, ");
INSERT INTO gwiNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ts'ą' dizheh gwits'eeyeheeghwaa. Ąįįtł'ęę yeeghaii gwich'įį nąįį khaihłan niheelyaa ts'ą' vijyaa nąįį jyaa goohaanjyaa, ‘Divii vaa tr'igweendaii ineegwał'ąįį łyaa shoo ihłii. Shroonchy'aa gwarohtsyaa!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Izhit gwik'it, naagwaldak, dinjii vatr'agwaanduu gwanlii, ąįį datr'agwaanduu akhagoonyąą eenjit zheekat veetsee'in tr'iheelyaa, ch'izhii dinjii nizįį 99 nąįį andaa ts'ą'.” Jesus nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Tr'injaa ąįį laraa ghoo tsal ch'ihłoaatin ts'an ch'ihłak haa tr'agwąhdaii ji', deehee'yaa t'inchy'aa? Adrii neehaahky'aa ts'ą' gihłeech'iheelii ts'ą' nijuk datthak yinkeegwahąąh'yaa yineegwahah'aa gwats'ą'. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nijin yineegwąh'ąįį ji', dijyaa chan ts'ą' yeeghaii gwich'įį nąįį khaihłan niheelyaa ts'ą' jyaa goohaanjyaa, ‘Shalaraa haa tr'agwąłdaii ineegwał'ąįį łyaa shoo ihłii. Shroonchy'aa gwarohtsyaa!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Izhit gwik'it, naagwaldak, Vit'eegwijyąhchy'aa vats'an zheekat gwich'in nąįį dinjii ch'ihłak datr'agwaanduu akhagoonyąą eenjit shoo ginlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jii t'ee Jesus chan hee gwandak ch'ihłak eeginkhii, “Ch'ihłan reh dinjii ch'ihłee vigii neekwaii gwanlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Vigii khaii ts'ą' ąįį yits'ą' haazhii. ‘Shiti', jii nan ni'įį ąįį nih'an teetł'an diits'an ąhtsii’. Ts'ą' t'ee ąįį dinjii digii tsyaa neekwaii nąįį ts'ą' danan nih'an intł'eiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ąįįtł'ęę niighyuk gwahaadhat kwaa ts'ą' tsyaa khaii ts'ą' ąįį jidii di'įį kwaii haa ch'adanh nahkat gwats'ą' haazhii. Dalaraa zhyaa an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Gwiizhit ąįį ch'adanh nahkat shih kwaa nagwaanąįį ts'ą' adan t'ee vaach'akwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Izhit gwats'an dinjii danan ts'eeyihiłchįį ts'ą' pig yeenjit k'ąąhtii. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ch'ihłee gaa yintł'eech'ahtsit kwaa, ts'ą' pig shįį gaa oih'aa yiindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nijin vaaneegwaakįį k'it t'iizhik dąį', idizhit niinjich'adhat, ‘Shiti' vitsyaa nąįį datthak juk shandaa gwinzii ch'aga'aa, gwizhit shihdeehaagaii! ");
INSERT INTO gwiNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","19","Oo'an neehihdyaa ts'ą', “Shiti', K'eegwaadhat nan haa nakhwats'ą' gwiizųų tr'agwał'ya'. Shiti', neenjit tr'agwał'ya' nihthan vaahaihjyaa. Nigii ąįį hihłyaa kwaa, gaa neenjit gwitr'it t'agwahał'yaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ts'ą' t'ee diti' ts'eehoozhii. Tth'aii hee dizheh gwats'ą' niighit needyaa gwizhit viti' niyiił'in ts'ą' neeshraahchy'aa yuunyąą ts'ą' yits'ą' hilgit ts'ą' yąhtsit ts'ą' yik'ohkhinil'ąįį ts'ą' yiilts'ų'. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Shiti', K'eegwaadhat nan haa nakhwats'ą' gwiizųų tr'agwał'ya'. Nigii ihłii geenjit giihthan kwaa,’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ch'iti' ditsyaa nąįį t'ahnyąą, ‘Khan t'akhwa'in ts'ą', shizheh gwats'an gwach'aa nizįį, kwaiitryah ts'ą' nileetth'ak haa, shigii veenjit ǫhjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ąįįtł'ęę aak'ii zhuu ch'ihłak dohkhwąįį. Ąįįtł'ęę gwintł'oo ch'arehee'aa gohtsii. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Shigii teehaazhii ts'ą' juk sheek'inidik. Shigii niindhat ts'ą' neegwiindaii k'it shaa t'oonchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Jyaa digwii'in gwiizhit ch'oondee ąįį oo'at gwanzhįh deek'it tr'agwah'in. Drin gwigwitr'it haa ndaanaahjik, dizheh gwats'ą' niighit kwaa needyaa akhai' ch'ilik ąįįts'ą' ch'araadzaa gwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","‘Deegwii'in?’ nyąą ditsyaa oahkat. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Nachaa veenjit gwinzii ts'ą' k'inidik, geh'an niti' aak'ii zhuu ak'ii diłkhwąįį,’ vitsyaa yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Akhai' voondee vik'įį gwihiilnaii ts'ą' dizheh nihdinidii gitr'ii'ee. Izhit geh'an, viti' yits'ą' cheiinzhii, ts'ą' t'iiyahnyąą, ‘Oozhee ch'ara'aa, nihdeiinkhaii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","30","Diti' ąįį t'ahnyąą, ‘Nitsyaa chan ihłii ts'ą' deeshaiinyąą tthak chan nik'eegwałthat, gwiizhit duuyeh gaa divii tsal shijyaa nąįį haa vaa ch'ara'aa hałtsyaa eenjit shantł'ahchįį, gwizhit jaghaii nigii ąįį nalaraa ąįį yit'ii tr'injaa haa dhichįį gwiizhit veenjit ch'ara'aa gwąhtsii?’ ");
INSERT INTO gwiNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“‘Shidinji', khit shaa t'inchy'aa. Jidii shi'įį datthak nats'an nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gaa gwintł'oo ch'aroo'aa ts'ą' shoo tr'oolį', nachaa niindhat ts'ą' neegwiindaii k'it t'oonchy'aa geh'an. Vaatr'igweendaii gaa vineegwarah'ąįį,’ viti' yahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus ditsyaa nąįį jyaa ahnyąą, “Ch'ihłan dinjii valaraa gwanlii. Ąįį dinjii yalaraa k'ąąhtii nilii di'įį. Ąįį laraa k'ąąhtii nilii ąįį yalaraa zhyaa an ąhtsii eenjit giiyaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Adats'ą' nihdeeyąąhchįį ts'ą' jyaa yahnyąą, ‘Deeni'in t'anarahnyąą neegwiitth'ak? It'ee duuyeh sheenjit laraa k'ąąhtii neenilįį. Dęhtły'aa kat laraa dąh'in ąįį gwidęhtły'aa shintł'ineiinlii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ąįį dinjii jyaa adaanyąą, ‘It'ee deeshi'yaa? Shats'ą' k'eegwaadhat shigwitr'it shits'į' neegǫǫnjik. Łųh khaihihthaa eenjit shat'aii kwaa. Ąįįts'ą' chan ch'adooshakwat eenjit hihłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","It'ee deeshi'yaa gaashandaii! Gwitr'it gwishi'įį kwaa ts'ą' gwihihchy'aa gwakwaa ji', shijyaa nąįį gweheelyaa ts'ą' digizheh nihdeeshagahahchik.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ąįįts'ą' ąįį juu yats'ą' k'eedeegwaadhat ts'ą' agaandaii nąįį gooteegwagwaanchy'aa ts'ą' nihdeegoovahchik. Dinjii ch'ihłak jyaa ahnyąą, ‘Shats'ą' k'eegwaadhat deegwahtsii vats'ą' andaii?’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Olive ghwai' ch'ityah 100,’ yahnyąą. ‘Dzaa nidęhtły'aa iłtsuu,’ ąįį laraa k'ąąhtii nyąą, ‘Khan dhindii ts'ą' 50 ąįį vakat neediintł'oo.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ch'izhii dinjii chan jyaa ahnyąą, ‘Nan ąįį yu'? Deegwąhtsii gwats'ą' andaii?’ ‘Tł'oo li' ch'ityah 1000,’ jyaa nyąą. ‘Dzaa nidęhtły'aa iłtsuu,’ ąįį laraa k'ąąhtii nyąą. ‘Khan vakat 800 diintł'oo.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jyaa dii'in eenjit ąįį yats'ą' k'eegwaadhat ąįį jii laraa k'ąąhtii nilii łyaa vigwizhi' gwanlii eenjit yeeyinjihił'ee. Juk gweendaa nankat gwidinjii nąįį ideenjit deegii'in, izhit łyaa juu dinjii ch'eegwąhndit gwats'an nilii nąįį andaa ts'ą' googwizhi' gwanlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ąįįts'ą' Jesus tth'aii ginkhii, “Ąįįts'ą' nakhwaagwaldak. Dzaa nankat gwizhrįh niinjigwaazhii laraa haa jyaa dahtsii. Nijin nalaraa kwaa goodlit ji', zheekat gwandaii ndaanąą'ąį' kwaa nihdeenarahahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Juu gwintsii kwaa gwizhit gwik'eegwahthat, ąįįt'ee gwandaa gwintsii gwizhit gwik'eegwahahthat. Ąįįts'ą' juu gwintsii kwaa gwizhit niinjigwaazhii, ąįįt'ee gwandaa gwintsii gwizhit niinjigwahaazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Gwik'eegwahthat kwaa ts'ą' jyaa t'inchy'aa ji', duuyeh nankat gwik'eiich'i' ts'ą' t'anarahtthan. Nats'ahts'ą' zheekat łi'didlii ąįį gwats'ą' t'anarahąhkhyaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ch'izhii dinjii ts'an k'ąąhtii kwaa ji', duuyeh ch'ihłak gaa nats'an nilii nantł'ana'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ch'itsyaa nilii ąįį duuyeh ch'ats'ą' k'eegwaadhat nilii neekwaii nąįį eetr'agwah'in. Ch'ihłak itr'ihee'ee ts'ą' ch'ihłak chan eet'ihęęnghyaa. Ch'ihłak ts'ą' heezyaa ts'ą' ch'ihłak chan ts'ą' iiheezųų. Duuyeh Vit'eegwijyąhchy'aa chan ts'ą' laraa haa nihłaa k'eegwaadhat an'įį.” ");
INSERT INTO gwiNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pharisee nąįį ąįį kwaii tthak gwigiitth'ak ts'ą' Jesus eegeedlaa, laraa gihił'ee geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus t'agoovahnyąą, “Nakhwan ąįįt'ee dinjii nąįį andah nizįį adoo'įį, gaa Vit'eegwijyąhchy'aa nakhwadrii zhit nats'ąą ninjich'ǫhthat nakhwaandaii. Dzaa nankat jidii ch'andaa t'aroonyąą ąįį Vit'eegwijyąhchy'aa vandee ts'ą' giilį' k'it t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“John chųų gwats'an ąhtsii geech'oohąąhchyaa gwats'ą' t'ee Moses va-law chan ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį haa geech'agwąąhtan. Izhit dąį' gwats'an juk tth'aii hee K'eegwaadhat Veegwinii'ee eenjit geech'oorahtan zhit gwiindhat. Juu nąįį tthak nihdeech'itsigahthat k'it t'igii'in, ts'ą' nihdeega'oo. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Jii nan chan ts'ą' zheekat haa haajyaa nahaadhal ąįį gogwantrii kwaa gaa zhit Moses va-law zhit ch'andaa t'agwahtsal ąįį oo'an tr'ahaahthal ąįį gogwantrii. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Juu dinjii da'at akhoonyąą ts'ą' ch'izhii tr'injaa noonjik ąįįt'ee adultery t'iizhik ąįįts'ą' juu tr'injaa dakai' akhoonyąą ąįį ch'izhii dinjii neeyuunjik ąįįt'ee adultery t'iizhik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ch'ihłan dinjii gwintsii veegoo'aii zheh gwachoo gwizhit gwich'įį. Khit chan gwach'aa daatł'oo naazhii ts'ą', jidii iindhan datthak chan di'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Dinjii neeshraahchy'aa valaraa kwaa, Lazarus oaazhii, chan ąįį dinjii gwintsii veegoo'aii vizheh geeghaih tthałkhyųų k'at'aanhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ąįį dinjii chan vakat datthak łit gwanlii. Ąįį dinjii gwintsii veegoo'aii shih tsal chiyahahthal ji', gaa hih'aa niindhan. Łąįį nąįį gaa giikat łit aht'ok, tr'iits'ahts'ą' t'agoovilii vat'aii kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Niighyuk gwahaadhat kwaa ts'ą' ąįį dinjii neeshraahchy'aa niindhat. Ąįįtł'ęę zheekat gwich'in nąįį giizhin oonjik. Zheekat Abraham drihtsįį dhidii ts'ą' vaashroonchy'aa. Ąįįtł'ęę ąįį dinjii gwintsii veegoo'aii chan niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Giinąąhjik ts'ą' vizhin khit geenjit heek'an gwats'ą' haazhii. Izhit łyaa khaiinjich'iidhat. Izhit gwats'an niighit gwąąh'in, akhai' Abraham, Lazarus yit'aahchįį gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ąįįts'ą' yats'ą' khashraa'iintrat, ‘Shiti' Abraham, neeshraahchy'aa shǫįįnyąą. Jii kǫ' zhit łyaa khaiinjich'ashadhat. Lazarus chųų zhit danleetth'ak tee heetthal ts'ą' shikyaa kat giiyeheetthal ts'ą' neehinishik'į' geenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham ąįįts'ą' jyaa yahnyąą, ‘Shidinji', gwiindaii dąį' jidii datthak chan ini'įį ts'ą' chan gwinzii gwiindaii gwizhik Lazarus ąįį gii'įį kwaa. Izhit geh'an, juk shaa dhidii ts'ą' vaashroonchy'aa t'iinchy'aa, gwizhik nan ąįį khaiinjich'inadhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Gwizhit chan diitł'an oozhak niighit diiteetak goo'aii t'oonchy'aa. Izhit geh'an, juu gwats'an izhit gwats'ą' hoihshi' yiindhan ji', gaa duuyeh. Ąįįts'ą' chan izhit gwats'an dzaa gwats'ą' hoihshi' yiindhan ji', gaa duuyeh t'oonchy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Dinjii gwintsii veegoo'aii yats'ą' khaneegeedi', ‘Ąįį ji' shiti', shachaa ch'ihłoanli' gwanlii shiti' vizheh gwigwich'įį. Izhit gwats'ą' Lazarus goots'ą' nanąąhchįį goots'ą' giheehkhyaa ts'ą' shik'it dzaa gwats'ą' giheedaa ts'ą' khaiinjich'igiheedhat kwaa eenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham t'iiyahnyąą, ‘Nachaa nąįį Dęhtły'aa Choh zhit Moses ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį k'injigooghit jaghaii? Akwaa ji', it'ee K'eegwaadhat nats'ahts'ą' dinjii gooli' goovahnyąą gaageheendaii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Zhat dinjii gwintsii veegoo'aii t'iiyahnyąą, ‘Shiti', Abraham, ąįį gaa tth'aii hee gwintsal, ts'ą' dinjii ch'ihłee niindhat khakee'ąįį ji', ts'ą' shachaa nąįį ts'ą' haazhii ji', it'ee datr'agwaanduu akhagooheenjyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Akhai' Abraham t'iiyahnyąą, ‘Dęhtły'aa Choh zhit gwadanakhwatł'oo k'injigiighit kwaa ji', jaghaii dinjii niindhat gwats'an khakihee'aa k'injigiheedhaa?’” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus ditsyaa nąįį jyaa ahnyąą, “Dinjii jidii gwizhit dee'in haa vatr'agwaanduu gwilik, gaa ąįį juu vats'an t'igwii'in łyaa veenjit tr'igwidii dha'aii! ");
INSERT INTO gwiNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kii nitsii vak'oh chan diriłchaa ts'ą' chųų choh kat oondaa t'eeriheełnaii ji' gwandaa vidivee gweheezyaa, juu gwintł'oo gwik'iinjiighit kwaa nąįį yeh'an datr'agwaanduu gwahahtsyaa gwits'į'. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Adak'ǫǫntii! Nakhwalak datr'agwaanduu gwahtsii ji', jyaa deehee'yaa kwaa eenjit veiinyąą, ąįįts'ą' datr'agwaanduu akhagoonyąą ji', veenjit oo'an gwihiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nihk'it drin ch'ihłak gwizhit nats'ą' gwinlęįį vatr'agwaanduu gwanlii ji' gaa nihk'it nits'eehidik ts'ą' jyaa nahaanjyaa ‘Shatr'agwaanduu akhagoihnyąą,’ ąįį ji' veenjit oo'an gwihiinlyaa gwizhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tr'ihił'e' nąįį K'eegwaadhat jyaa agahnyąą, “Gwandaa gwik'iinjigwiighit nitsii Vit'eegwijyąhchy'aa veenjit tr'ihee'yaa eenjit diits'iinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Diik'eegwaadhat jyaa goovahnyąą, “Mustard seed tsal agwahtł'oo gwik'iinjigwiighit khwa'įį ji', ‘Jii Mulberry ts'iivii nitsii ji', gaa, Nanzhit khadaanchįį ts'ą' chųų choh zhit nindhat!’ vaiinyąą ts'ą' ąįį ts'iivii nik'eegwahahthat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Nakhwatee ch'ihłak ch'itsyaa di'įį. Ąįį gwanzhįh deek'it geetr'agwah'in, akwat divii k'ąąhtii nilii ji'. Nijin gwanzhįh deek'it gwats'an oo'ee neezhįį dąį', nik'ee jyaa vaiinyąą, ‘Dzaa dhindii, ts'ą' neech'in'aa?’ ");
INSERT INTO gwiNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Łyaa duuyeh gwich'in! Gaa jii ąįį jyaa vaiinyąą, ‘Hih'aa sheenjit shrinlii. Gwach'aa tł'andirilchaa nakat nąąhtsuu ts'ą' hih'aa ts'ą' hishinjyaa haa sheenjit shriinlii. Ąįįtł'ęę neech'in'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ąįį ch'itsyaa deehee'yaa goo'aii ąįį gwik'eegwahthat eenjit mahsį' varahnyąą gwat'aahchy'aa kwaa shrǫǫ oiinyąą? ");
INSERT INTO gwiNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Izhit gwik'it jyąhts'ą' naagoo'aii, nijin deeni'yaa goo'aii datthak gwik'it t'ini'in tł'ęę, jyaa nyąą, ‘Ch'itsyaa zhrįh tr'iinlii. Deegwehee'yaa goo'aii, izhit gwizhrįh diigwitr'it.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus ąįį Jerusalem gwats'ą' ahaa, Samaria chan ts'ą' Galilee haa gwiteetł'an gwa'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jesus kwaiik'it gwats'ą' ahaa. Ąįį gwizhit dinjii ch'ihłoaatin nąįį yidaajil. Ąįį dinjii gwatthąį' ahjat (leprosy) haa iłts'ik nąįį. Niighit geh'at gwa'an nigiilzhii gwats'an ");
INSERT INTO gwiNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","giineeshraadiitrak. “Jesus! Diik'eegwaadhat! Neeshraahchy'aa diinoiinyaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus nagaviił'in ts'ą' t'agoovahnyąą, “Oo'at giinkhih nąįį goots'ą' hohjyaa ts'ą' nakhwakat gahaanjii.” Giinkhih nąįį ts'ą' geedaa, ąįį gwiizhit shrineegaanjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nijin gootee ch'ihłee shranaazhik nagwiił'in dąį', Jesus ts'ą' khan neehoozhii. Ąįįts'ą', “Vit'eegwijyąhchy'aa łyaa tr'ahah'aa,” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesus kwaiichan khatroogwiintthaii ts'ą' “Mahsį',” ahnyąą. Jii dinjii aakin nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus juu dinjii nąįį yaa nilii nąįį t'ahnyąą, “Dinjii ch'ihłoaatin nąįį ashranǫąhjik. Zhit juu dinjii vaa shranoaazhik nąįį dagaajii? ");
INSERT INTO gwiNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Jaghaii jii aakin zhrįh nihkhaneezhii ts'ą' Vit'eegwijyąhchy'aa mahsį', ahnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesus jii dinjii t'ahnyąą, “Ndak nininjii ts'ą' oo'an neehindii. Gwik'iinjinghit geh'an t'ee natthąį' shranoaanjik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee lat nąįį Jesus goahkat, nijin ji' nankat datthak Vit'eegwijyąhchy'aa dinjii idik'iinjyahahdaa? Akhai' jyaa dagoovahnyąą, “Nankat datthak Vit'eegwijyąhchy'aa, dinjii idik'iinjyahahdaa ji' diinandee ts'ą' t'igwehee'yaa t'igwinyąą kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Duuyeh ch'ihłak gaa jyaa nyąą, ‘Gooh'in, jii t'arahnyąą, Gooh'in, zhit t'agwarahnyąą!’ Zhit Vit'eegwijyąhchy'aa dinjii idik'iinjyahahdaa gwinyąą ąįįt'ee nakhwadrii zhit t'igweheenjyaa dagwarahnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ąįįtł'ęę ditsyaa nąįį jyaa ahnyąą “Gwidinji', dinjii idik'iinjyahjik nigwiindhat gwandaa nǫh'ya' yuuhthan nagwahaadhal, gaa duuyeh nǫh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Goolat nąįį chan jyaa diinahąąnjyaa, ‘Gooh'in, zhit goo'aii! Akwat, Gooh'in, dzaa hee!’ Gaa juu jyaanyąą tąįį hǫǫnzhi' shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nahtan kǫ' haadhak (lightning) ts'ą' datthak gach'ahdrii gwaraah'in gwik'it Gwidinji' needyaa ji' gwizhrįh t'igwehee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gaa tr'ookit khaiinjich'iheedhat ts'ą' chan juk gweendaa gwidinjii nąįį giik'iinjiheedhaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Noah gwandaii gwanaa gwik'it ąįįts'ą' chan Gwidinji' k'ineeheedik gwats'ą'. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Juu nąįį datthak nihk'it ch'aga'aa ts'ą' ch'igiinįį, dinjii, ts'ą' tr'injaa nąįį chan nihłiteegogwahjii, nijin drin Noah tr'ihchoo zhiinzhii gwats'ą', ąįįtł'ęę t'ee chųų ndak t'iizhik ts'ą' datthak an gaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot gwandaii dąį' chan jyaa deegwiizhik. Juu nąįį datthak ch'aga'aa, ch'igiinįį; ch'agookwat, k'aiich'ii laraa t'įį gihilii, gogwąąhshii akwat zheh gogwaghan gwizhrįh gagąhjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Nijin drin Lot ąįį Sodom gihłeehaazhii dąį' kǫ' chan ts'ą' sulfur haa zheekat gwats'an haa ąhtsin ts'ą' datthak gooviinghan. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Izhit gwik'it chan nijin drin Gwidinji' Vineegwiilkįį ji' t'ee jyaa dineegweheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Izhit drin ji' juu dizheh gwakat doodii neenoozhi' ts'ą' dizheh gwizhit dik'eiich'i' noonjii shrǫ'! Izhit gwik'it juu dinjii gwanzhįh deek'it gwitr'it t'agwah'in chan dizheh gwits'eehoozhi' shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot va'at deezhik ganoondaii! ");
INSERT INTO gwiNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Juu gweheendaii geetr'agwah'in t'ee vaa an heelyaa. Juu an dhidlit chan neegweheendaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Izhit zhat khaa ji', naagwaldak, dinjii neekwaii nąįį dehk'it ch'ihłak kat digiheechyaa, ch'ihłak gihłeerahahchyaa, ch'ihłak chan zhat akharooheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tr'injaa neekwaii nąįį neech'agandlat: ch'ihłak gihłeerahahchyaa, ch'ihłak chan zhat akharooheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dinjii neekwaii nąįį gwanzhįh deek'it gwitr'it t'agoogwah'in ch'ihłak gihłeerahahchyaa, ch'ihłak chan zhat akharooheenjyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Vitsyaa nąįį yuahkat, “Ąįį nijin t'agwaiinyąą, K'eegwaadhat?” Jesus t'agoovahnyąą, “Nijin ch'atthąį' iłchįį t'ee zhat gwa'an vultures, (deetrya' k'it t'inchy'aa) nąįį łaahaadaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ąįįtł'ęę Jesus jii gwandak zhit geegoovąąhtan, jidii geenjit khadigigiinjii akhagagooheenjyaa kwaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Zhit gwa'an kwaiik'it goo'aii gwizhit dinjii ch'aroahkat zheh gwizhit ch'oahkat nilii. Ąįį Vit'eegwijyąhchy'aa aanjat kwaa ts'ą' dinjii chan hił'ee kwaa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ąįįts'ą' chan tr'injaa vakai' niindhat chan zhat kwaiik'it gwich'įį. Ąįį gwintł'oo yeeninidik ts'ą' deeyiindhan gwik'it t'igwehee'yaa geenjit yaandeegwii'ąįį. ‘Juu shats'ą' iizųų nąįį eenjit shits'iinyąą.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Łyaa niighyuk yik'eegwahthat kwaa, gaa gohch'it jyaa adaanyąą, ‘Vit'eegwijyąhchy'aa chan aaljat kwaa ts'ą' dinjii chan hooł'e' kwaa gaa, ");
INSERT INTO gwiNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jii tr'injaa vakai' niindhat tr'ihkhit shik'eegoodhat niindhan geenjit shaandeegwii'ąįį akwat vik'eegwahałthat. Ąįį akwaa ji', gwintł'oo geenjit shaandeegwehee'aa ts'ą' chishahąhndaa!’” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ąįįts'ą' t'ee Diik'eegwaadhat t'agoovahnyąą, “Jii dinjii ch'aroahkat zheh gwizhit ch'oahkat tsinteech'ąąhkaii dohtth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ąįį eenjit, Vit'eegwijyąhchy'aa ąįį dinjii tǫǫ drin haa, ‘Shits'iinyąą,’ yahnyąą nąįį nihteetr'anaazhik lee t'inchy'aa? Jidii eenjit, ‘Shits'iinyąą,’ giiyahnyąą, ąįį eenjit khan goots'iheenjyaa lee t'inchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nakhwaagwahaldak, zhit deegiindhan gook'eegwahahthat t'inchy'aa gaa nijin Gwidinji' nankat k'idik ji' gwik'iinjigwiighit agwahah'aa shrǫǫ?” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus jii gwandak ąįį juu dinjii ihsįį indhan ts'ą' juu datthak gooveenjit iizųų nąįį haa gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Dinjii neekwaii nąįį Kharigidiinjii Zhee Gwachoo gwats'ą' gahaa'oo, khagigeheejyaa geenjit. Ch'ihłee Pharisee nilii ts'ą' ch'ihłee chan tax eenjit laraa oonjii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jii Pharisee adąhzhrįh nadhat ts'ą' jyąhts'ą' khagidiinjii, ‘Vit'eegwijyąhchy'aa mahsį', juu nąįį datthak k'it shahzhrįh idininjich'aldhat kwaa, niinjigwalzhii kwaa, ts'ą' tr'injaa veedhiidii kwaa ąįį haa dhiichįį kwaa, mahsį'! Jii tax eenjit laraa oonjii vik'it t'ihchy'aa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Drin ch'ats'ateets'įį neekwaii gwizhit drin neekwaii ch'ih'aa kwaa, ts'ą' jidii oihjii datthak ts'an ch'ihłoaatin kwaii (1/10) Vit'eegwijyąhchy'aa vats'an ałtsii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gaa zhit tax eenjit laraa oonjii ąįį geh'at gwa'an adąhzhrįh nadhat, gaa zheezhit k'iidak gaa gwąąh'in kwaa, gwiizhit didrihtsii gwahgwat ts'ą' t'inyąą, ‘Vit'eegwijyąhchy'aa, neeshraahchy'aa shǫįįnyąą, tr'agwaanduu tr'agwał'ya'!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jii tax eenjit laraa oonjii t'ee Vit'eegwijyąhchy'aa haa vaa gwinzii goodlit ts'ą' dizheh gwits'eehoozhii dąį'. Gaa Pharisee ąįį Vit'eegwijyąhchy'aa haa vaa gwinzii kwaa. Ąįį geh'an juu ch'andaa adoodiinyąą, t'ee heetsal, ts'ą' juu ch'andaa adoodiinyąą kwaa t'ee heetsii,” Jesus nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Dinjii lat nąįį digitr'iinin tsal Jesus gook'aa nahaandal eenjit giits'ą' haadlii. Vitsyaa nąįį googwąąh'in dąį' geenjit ch'ats'ą' t'agoogahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gaa Jesus ąįį tr'iinin nąįį aanaii ahnyąą ts'ą' jyaa nyąą, “Tr'iinin shats'ą' hijyaa nąįį, zhyaa goovoh'in, K'eegwaadhat Veegwinii'ee t'ee dinjii tr'iinin k'it veegoo'aii nąįį gaa ts'an t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jii ganoondaii! Juu K'eegwaadhat Veegwinii'ee oonjii kwaa t'ee tr'iinin tsal k'it veegoo'aii ts'ą' duuyeh zhat gwats'an ilii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Israel kįh nilii ąįį Jesus oahkat, “Geech'ǫąąhtan nizįį, khit gwarandaii shi'yaa ji' geenjit deeshi'yaa goo'aii?” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","“Jaghaii dinjii nizįį shaiinyąą?” Jesus yuahkat. Vit'eegwijyąhchy'aa zhrįh nizįį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Moses va-law kat jyaa deegwinyąą gaakhwandaii. ‘Nakąį' akwat na'at nilii kwaa haa oonchį' shrǫ'! Dinjii ęhdaa tr'agoon'aa shrǫ'! Ch'ooan'įį shrǫ'! Oonts'it ts'ą' dinjii ts'ą' gadǫǫhtrit shrǫ'! Nahan, niti' haa gook'eegwąhthat!’” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ąįį dinjii jyaa nyąą, “Tr'iinin ihłii dąį' gwats'an Moses va-Law kwaii k'eegwałthat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nijin jyaa nyąą Jesus yiitth'ak dąį' t'iiyahnyąą, “Jii kwaii tth'aii t'ini'yaa goo'aii, nizheh gwits'eehindii ts'ą' nik'eiich'ii datthak laraa t'įį hinlii ts'ą' ąįį laraa neeshraahchy'aa nąįį teiinlii. Jyaa dinizhik ji' zheekat gaayiigwahantsyaa neenjit gwehee'aa. Ąįįtł'ęę shits'eehindii ts'ą' shitsyaa inlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gaa nijin ąįį dinjii jii gwiitth'ak dąį', łyaa tr'igwidii yiłtsąįį, valaraa gwanlii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus tr'igwidii dhidlit yąąh'in ts'ą' jyaa yahnyąą, “Dinjii valaraa gwanlii K'eegwaadhat Veegwinii'ee ts'an heelyaa eenjit gogwantrii t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nin nitsii Camel ąįį tahtsal keeheehaa ąįį gogwantrii kwaa gaa dinjii valaraa gwanlii K'eegwaadhat Veegwinii'ee nihdeeheehaa eenjit veegogwantrii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Juu zhat dilk'ii yiitth'ak nąįį giiyųąhkat, “Juu neeheezhii gǫ'?” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus jyaa goovahnyąą, “Dinjii khyų' t'ii'in ąįį Vit'eegwijyąhchy'aa eenjit gogwantrii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter jyaa nyąą, “Gwąąh'in! Natąįį tr'iheedaa eenjit diizheh gihłeerahaajil.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesus jyaa goovahnyąą, “Aahą'! Łi'haa nakhwaagwahaldak! Juu K'eegwaadhat Veegwinii'ee eenjit dizheh, akwat da'at, dachaa, doondee, diyehghan ts'ą' digii haa iłeehaazhii ąįįt'ee juk gweendaa ts'ą' khit gwarandaii haa andaa ts'ą' Vit'eegwijyąhchy'aa ts'an heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus ditsyaa 12 nąįį khaihłan niinlii ts'ą' jyaa goovahnyąą, “Ch'oodǫǫhk'įį! Jerusalem gwats'ą' tr'iheedaa, izhit t'ee Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį Gwidinji' eenjit deegiinyą' ts'ą' gwadagaantł'oo chy'aa gwik'it gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Israel gwich'in nilii kwaa nąįį intł'eehaachyaa, ąįį nąįį t'ee giiyeeheedlaa ts'ą' giich'itsyaahaa'ee ts'ą' giik'aa heezhree. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Giihaahtrii ts'ą' giiyęhdaa tr'igwihee'aa, gaa drin tik nigiindhat giizhit neegweheendaii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Gaa vitsyaa nąįį deegwinyąą t'igwinyąą gaagiindaii kwaa. Deenyąą t'inyąą ąįį khyų' gwiky'aanjii, ts'ą' jidii eeginkhii t'inyąą giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","It'ee łąą Jesus khaiinjii Jericho k'idik gwiizhit tąįį gwikhyųų dinjii vandee kwaa dhidii ts'ą' ch'oodiikwat. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lęįį nąįį yehgoo hijyaa diitth'ak dąį' ch'oahkat, “Deegwii'in t'igwinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Nazareth gwats'an Jesus oaazhii gehgoo hahkhaii t'igwinyąą,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ąįį dinjii zhral haa jyaanyąą, “Jesus, David vidinji'! Neeshraahchy'aa shǫįįnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ąįį dinjii yits'ii dilk'ii nąįį jyąhts'ą' t'igiiyahnyąą ts'ą' didhiinyąą giiyahnyąą. Gaa gwandaa azhral haa jyaanyąą, “David vigii Jesus, neeshraahchy'aa shǫįįnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ąįįts'ą' Jesus ndaaniinzhii ts'ą' ąįį dinjii vandee kwaa, “Shats'ą' narohchyaa,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Jesus jyaa yahnyąą, “Neenjit dooshi'yaa shǫįįnyąą?” “Shik'eegwaadhat, shaagoochy'a' nihthan,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus jyaa yahnyąą, “Nandee noiinjii, nigwik'iinjigwiighit neenjit gwinzii neegwiłtsąįį t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Zhazhat łąą vaagweech'in neegwaanąįį ts'ą' Jesus tąįį haazhii ts'ą' Vit'eegwijyąhchy'aa mahsį' ahnyąą. Nijin dinjii nąįį datthak googwąąh'ya' dąį' Vit'eegwijyąhchy'aa deegihiił'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus, Jericho kwaiik'it hee k'idik ts'ą' gehgoo hahaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Izhit hee Zacchaeus ndak khii tax eenjit laraa oonjii nilii dhidii, łyaa valaraa gwanlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesus hąąh'yaa gwik'eegwandaii gaa dinjii natsal nilii ts'ą' khyų' dinjii tee yąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nijuk Jesus ahaa izhit gwits'ii hee aagal ts'ą' yahąąh'yaa eenjit ts'iivii Sycamore kat deedhizhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nijin Jesus ts'iivii ehzhee niinzhii dąį' k'iidak Zacchaeus nah'in ts'ą' jyaa yahnyąą, “Zacchaeus, juk zhat neenindii, juk drin nizheh hihdyaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus khan neeneezhii ts'ą' shoh haa dizheh gwits'eeyihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Juu nąįį datthak Jesus yizheh nihdąhkhaii yąąh'in dąį' datthak giiyeeginkhii ts'ą' jyaa ginyąą, “Jii dinjii vatr'agwaanduu gwanlii vizheh heedyaa eenjit nihdeiinzhii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zacchaeus ndak niinzhii ts'ą' Diik'eegwaadhat jyaa ahnyąą, “Juk zhat, shik'eiich'ii teetł'an kwaii neeshraahchy'aa nąįį intł'eehihłyaa. Ąįįts'ą' juu vininjigoolzhii nąįį chan dǫǫ gwiteegogwąąnchy'aa gooneegoohihkwat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus t'iiyahnyąą, “Juk drin jii zhehk'aa gwizhit gwich'įį nąįį neeheezhii. Yeenii diilak Abraham vats'an inkhaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Gwidinji' ihłii ts'ą' ąįį dinjii teehaajil nąįį neehałshii eenjit keegwaał'in, jyąhts'ą' khit geegoo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dinjii nąįį ch'agoołk'įį gwiizhit Jesus nihk'it gwaandak ts'ą' gwandak zhit geegoovąąhtan. It'ee khaiinjii Jerusalem k'idik, ąįįts'ą' K'eegwaadhat Veegwinii'ee vineegwahaakyaa goo'aii gwich'in giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ąįįts'ą' jyaa nyąą, “Ch'ihłan dinjii King nilii nąįį ts'an deedhaa nahkat niighit gwa'an King heelyaa eenjit gwats'ą' heekhaa ąįįtł'ęę k'ineeheedik. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Heekhaa gwehkįį, ditsyaa ch'ihłoaatin nąįį teegogwaanchy'aa gold laraa ch'ihłak gooteedhidlii ts'ą' jyaa goovahnyąą, ‘Hadhaljii gwiizhit jii haa laraa dootsii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Gaa vanahkat gwich'in nąįį yitr'ii'ee ts'ą' jyaa giihaanjyaa eenjit giitąįį dinjii nąįį hił'e', ‘Jii dinjii dii-King nilii gitr'igwii'ee.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Nijin ąįį dinjii gwintsii veegoo'aii King dhidlit ąįįtł'ęę k'inidik googwahkhan ditsyaa juu laraa intł'inlii nąįį aanaii ahnyąą, Laraa dahtsii giłtsąįį gaashoondaii niindhan eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Zhit tr'ookit ahaa ąįį jyaa yahnyąą, ‘Shik'eegwaadhat, ąįį gold laraa ch'ihłak shintł'in'ąįį haa ch'ihłoaatin gaayiidoołtsąįį.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“‘Ąįįt'ee łyaa gwinzii',’ yahnyąą, ‘łyaa shitsyaa nizįį inlii! Juk it'ee łyaa gwitr'it gwatsal eenjit inzii łee niky'aaljik. Kwaiik'it gwachoo ch'ihłoaatin gwats'ą' k'eegwahandhat nahałtsyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Zhit gwats'ąįį ahaa chan jyaa yahnyąą ‘Shik'eegwaadhat, ąįį gold laraa ch'ihłak shintł'in'ąįį haa ch'ihłoanli' gaayiidoołtsąįį.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Jii ąįį jyaa dahnyąą, ‘Nan ąįį kwaii k'it gwachoo ch'ihłoanli' gwats'ą' k'eegwahandhat.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ch'izhii vitsyaa chan oo'ee haazhii ts'ą' jyaa nyąą, ‘Shik'eegwaadhat, dzaa nalaraa, k'ǫǫneent'ąįį zhit gwit'ii'ał'ai', ");
INSERT INTO gwiNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","dinjii neeshraahchy'aa oiinyąą kwaa ts'ą' naaljat. Nats'an t'inchy'aa kwaa chan oihdak ts'ą' nagwanzhih t'inchy'aa kwaa chan zhyaa oihdak.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Akhai' jyaa diyahnyąą, ‘Shitsyaa iizųų inlii! Deeshaiinyą' gwik'it eenjit nagwahaałshii! Dinjii neeshraahchy'aa oihnyąą kwaa ts'ą' shaanandaii shats'an t'inchy'aa kwaa chan oihdak ts'ą' shagwanzhįh t'inchy'aa kwaa chan oihdak gaanandaii ji'. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jaghaii shalaraa nitsii dhąhtsąįį kwaa gǫ'? Nijin k'inidik ji' nitsii dhidlit ji' noohihdal reh.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ąįįtł'ęę t'ee zhat niilzhii nąįį jyaa ahnyąą, ‘Zhit laraa vits'į' nǫhjii ts'ą' zhit juu laraa ch'ihłoaatin gaayiidiltsąįį ąįį vintł'eeyuhłii.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Jyaa giiyahnyąą, ‘K'eegwaadhat, ch'adąį' hee gold laraa ch'ihłoaatin di'įį t'inchy'aa!’ ");
INSERT INTO gwiNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Naagwaldak, nyąą, ‘Juu laraa di'įį ts'an gwintsii gwiłtsąįį ąįįt'ee gwandaa laraa neehoondal gaa juu gwintsii gwiłtsąįį kwaa gaa ąįį laraa tth'aii zhat dha'aii ji' vits'į' neerooheendal. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ąįį juu shitr'ii'ee nąįį goo-King ihłii gitr'ii'ee nąįį, dzaa gwats'ą' goovahohłii ts'ą' shandah goovohkhan.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesus jyaa diinyą', ąįįtł'ęę oodak Jerusalem gwats'ą' goots'iin haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bethphage, Bethany kwaiik'it haa gwats'ą' niighit kwaa nijin Taih Vakat Olives Nahshii goo'aii gwats'ą' niighit kwaa ahaa, ditsyaa neekwaii nąįį jyaa ahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Zhit nakhwats'įį kwaiik'it goo'aii gwats'ą' hoh'oo. Izhit nihdǫh'oo gwiizhit donkey tsal zhat dakhwachaa hǫǫh'yaa, ąįįt'ee gwehkįį neegiihahchik kwaa. Gwats'an tr'oohchįį ts'ą' dzaa gwats'ą' hohchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","‘Jaghaii gwats'an tr'oohchįį t'oh'in?’ nakhwarahnyąą ji', jyaa vohnyąą, ‘K'eegwaadhat yat'ąąhchy'aa.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Izhit gwats'ą' gahaajil ts'ą' Jesus jidii agahoh'aa goovahnyąą chy'aa agogwąh'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Donkey tsal gwats'an tr'agąąhchįį gwiizhit ąįį vats'an yinlii t'agoovahnyąą, “Jaghaii gwats'an tr'ohchįį t'oh'in?” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“K'eegwaadhat yat'ąąhchy'aa,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ąįįtł'ęę ąįį donkey tsal Jesus ts'ą' gihiłchįį. Ąįįtł'ęę ik giikat diłtsuu tł'ęę Jesus giikat diłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Donkey tsal yahchyaa gwiizhit dinjii nąįį giideekwaii digi'ik nigilii. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jerusalem gwats'ą' niighit kwaa ahaa izhit gwats'an t'ee k'iizhak tąįį goo'aii, Taih Vakat Olives Nahshii gwats'an. Vitsyaa lęįį nąįį gwint'aii giginkhii ts'ą' gwintsii t'ee'ya' giiyąąh'ya' eenjit Vit'eegwijyąhchy'aa, “Mahsį',” agahnyąą ts'ą' deegiiyihiił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Ąįį King k'ii'ee K'eegwaadhat voozhri' zhit ahaa Vit'eegwijyąhchy'aa yaa nilii! Zheekat gwizhit tsinehdan goo'aii. Ąįįts'ą' Vit'eegwijyąhchy'aa deerihiił'e'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Akhai' dinjii tee gwats'an Pharisee nąįį Jesus jyaa dagahnyąą. “Geech'ǫąąhtan, nitsyaa nąįį dadhohnyąą,” goovaiinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","“Gahaahchįį kwaa ji', nakhwaagwahaldak zhit gwa'an kii nąįį gaa giheezhral,” Jesus goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalem gwats'ą' niighit kwaa niinzhii ts'ą' nigwiił'in dąį' jyaa nyąą ts'ą' gwak'aa itree. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Nats'ąą tsinehdan gwini'yaa ąįį geenjit juk drin gaanandaii ji' noihnyąą! Gaa juk neenjit gwigweech'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Yeendaa ji' zhit juu nats'ą' nich'itsahthat nąįį neelin nigiheedaa, duuyeh chan dinjii chyahahkhaii, duuyeh chan dinjii nihdąhkhaii, nihts'ahts'ą' datthak nak'aa giheedaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","An nagahahtsyaa ts'ą' dinjii datthak chan giheeghaa. Kii tsal ch'ihłak gaa nihdak hee'aa kwaa nagahahtsyaa, ąįįt'ee Vit'eegwijyąhchy'aa neenahahshii eenjit neenoozhii gaa gwiky'aanjik kwaa geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus Kharigidiinjii Zhee Gwachoo nihdeiinzhii ts'ą' zhit juu laraa t'įį gwihilii nąįį datthak cheehaanzhit, ");
INSERT INTO gwiNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","jyaa goovahnyąą, “Dęhtły'aa Choh zhit Vit'eegwijyąhchy'aa jyaa nyąą, ‘Shizheh t'ee Kharigidiinjii Zhee Gwachoo t'inchy'aa!’ Gaa nakhwan ąįį ch'an'įį nąįį gwizhit geegoh'it dhohdlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Drin gwiteegwaanchy'aa Kharigidiinjii Zhee Gwachoo gwizhit Jesus geech'ǫąąhtan. Zhit giinkhih k'įh dilk'ii nąįį, Law eech'ǫąąhtan nąįį chan ts'ą' Israel kįh dilk'ii nąįį haa datthak giihaahkhwaa gwik'eegogwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Zhat khit dinjii nąįį gwanlii ts'ą' deenyąą datthak giiyuułk'įį ts'ą' khyų' giihaahkhwaa giiyeenjit gogwah'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ch'ihłok drin Jesus Kharigidiinjii Zhee Gwachoo gwizhit dinjii nąįį ts'ą' Gwandak Nizįį eegoovaahtan, gwiizhit giinkhih k'įh dilk'ii nąįį, Law eech'ǫąąhtan nąįį chan ts'ą' Israel k'įh dilk'ii nąįį haa giits'ą' haajil ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","jyaa giiyahnyąą, “Jidii t'aih ni'įį t'ini'in? Juu jyaa deeni'in nahnyąą, diinaa gwandak lee?” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Jesus jyaa goovahnyąą, “Shįį ąįį nakhoohałkat, John chųų gwats'an ąhtsii dąį', juu vat'aii haa t'ii'in? Vit'eegwijyąhchy'aa akwat dinjii nąįį ts'an? Izhit shaagoondak lee?” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Izhit geenjit nihłitee ts'ą' nihzheedagąąn'ee ts'ą' jyaa ginyąą, “Deegweheenjyaa? Vit'eegwijyąhchy'aa vats'an gwinyąą ji', jyaa diinahąąnjyaa, jaghaii John vik'injuhkhit kwaa gǫ'? ");
INSERT INTO gwiNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Dinjii ts'an’ gwinyąą ji' chan dzaa juu dilk'ii nąįį datthak kii haa diiheeghaa. John Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ąįį łyaa gaagiindaii geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ąįįts'ą' jyaa giiyahnyąą, “Dee', łyaa nijuk gwats'an t'ii'in vaagwiindaii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ąįįts'ą' Jesus jyaa goovahnyąą, “Jidii t'aih haa t'ishi'in izhit duuyeh geenakhwaagwaldak t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ąįįtł'ęę Jesus dinjii nąįį gwandak eegoovaagwaandak, “Dinjii danan kat jak choh hiiłshii gaa ch'adanh nahkat gwats'ą' hoihshi' yiindhan, ch'ihłee, ‘Sheenjit vak'ǫǫhtii,’ gwanzhįh k'ąąhtii nąįį ahnyąą, ‘Ąįįtł'ęę valat nakhwats'an hałtsyaa,’ goovahnyąą. Niighyuk hiljii ts'ą', ");
INSERT INTO gwiNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nijin jak choh gahąąhtsyaa nigwiindhat dąį', ąįį dinjii ditsyaa ch'ihłak oo'an gwanzhįh k'ąąhtii nąįį ts'ą' yihił'e' ts'ą' jyaa diinyąą yahnyąą, ‘Ąįį jak choh valak hoihdal eenjit t'ishi'in.’ Gaa ąįį gwanzhįh k'ąąhtii nąįį giiyąąhkhwąį' ts'ą' giiyintł'eech'ahtsit kwaa ts'ą' oo'an neegiihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ts'ą' chan hee ditsyaa ch'izhii chan oo'an neehił'e', gaa ąįį gwanzhįh k'ąąhtii nąįį tr'ookit dinjii oo'ee noozhii, ąįį k'it giiyąąhkhwąį'. Giiyeedlaa ts'ą' chan giiyintł'ineech'ahtsit kwaa ts'ą' chan oo'ee neegiihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ąįįtł'ęę chan hee ditsyaa ch'ihłak oo'an neehił'e', gaa gwanzhįh k'ąąhtii nąįį giiyiinjik, ąįį juu k'iidąą hił'e' nąįį andaa ts'ą' gwanzhįh deek'it gihłeet'ee giihiłnaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ąįįtł'ęę ąįį dinjii gwanzhįh ts'ą' k'eegwaadhat adats'ą' niinjich'adhat, ‘Deeshi'yaa? Shidinji' gęhdaa kwaa veet'iihthan, ąįį oo'an nahał'aa. Giiyeenjit hił'e' ji', łyaa gweheezyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nijin gwanzhįh k'ąąhtii nąįį giiyąąh'ya' dąį', t'iginyąą. ‘Jii dinjii t'ee jii nan ts'ą' k'eegwaadhat vidinji' t'inchy'aa. Tr'ookhwaa. Ąįįtł'ęę jii gwanzhįh dehk'it diits'an gweheelyaa!’” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ts'ą' t'ee gwanzhįh dehk'it gihłeegiihaaluu. Ąįįtł'ęę giiyiiłkhwąįį. Ąįįts'ą' Jesus dinjii nąįį t'ahnyąą. “Jii dinjii gwanzhįh ts'ą' k'eegwaadhat deehee'yaa li'? ");
INSERT INTO gwiNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Goots'ą' heekhaa ts'ą' goovęhdaa tr'igwihee'aa, tł'ęę ch'izhii nąįį intł'eegwehee'aa.” Dinjii nąįį jii gwigwiitth'ak dąį', jyaa diginyąą, “Akwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus goovąąh'in ts'ą' gavoahkat, “Akwaa ji', jii Dęhtły'aa Choh zhit deegwinyąą t'igwinyąą shrǫǫ yuuhthan, ‘Kii vaa zheh ndak gwehee'aa, ąįį kii nizįį nilii kwaa k'it t'inchy'aa. Gaa ndaagwąą'ąį' dąį', kii hil'ee dhidlit.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ąįį juu ąįį kii kat nat'aanąįį t'ee yakat khadigweheent'ii. Ąįįts'ą' kii vakat naanaii ji', chan łųh nahaadhal.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Izhit zhat Law eech'ǫąąhtan nąįį, chan ts'ą' giinkhih kįh dilk'ii nąįį haa zhazhat Jesus tr'oonjii giindhan, geedan gwandak zhit gooveeginkhii t'inyąą ts'ą' gaagiindaii, gaa zhat juu dilk'ii nąįį agąąnjat geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Goodhaii nihdeegiihaathal eenjit nagogwal'in. Dinjii agogookwat ts'ą' dinjii nizįį łi'didlii adagaa'įį ts'ą' Jesus goohaahkat ts'ą' goodhaiinideegiihaahtthal eenjit giits'ą' hił'e', ąįį ji' t'ee Roman nahkat gwats'ą' k'eegwaadhat intł'eegiihahchyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jii juu giits'ą' hił'e' nąįį Jesus jyaa agahnyąą, “Geech'ǫąąhtan, jidii gǫąąhtan chan ts'ą' deiinyąą datthak łi'didlii haa t'iinyąą naagwiindaii. Dinjii chan nihteetr'ananzhik kwaa ts'ą' łi'didlii haa Vit'eegwijyąhchy'aa vagwandak eech'ǫąąhtan naagwiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Zhit Caesar, Rome nahkat gwats'ą' k'eegwaadhat laraa vintł'ineeraazhik ąįį jyaa deegwehee'yaa goo'aii lee t'igwii'in? Akwat jyaa deegwehee'yaa kwaa goo'aii? Jidii shrit? Ąįį diinaa gwandak.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Gaa Jesus ąįį goodhaii nideegiihaahkhii t'iginyąą goovaandaii, ");
INSERT INTO gwiNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Laraa ghoo tsal nooł'ya'. Juu vinin chan ts'ą' voozhri' haa vakat dha'aii?” “Caesar reh,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesus t'agoovahnyąą, “Akwaa ji', Caesar, ąįį jidii vats'an heelyaa goo'aii ąįį eenjit vagohkwat ts'ą' Vit'eegwijyąhchy'aa jidii haa vagoohohkwat goo'aii gaakhwandaii ąįį haa vagohkwat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Dinjii nąįį andah, khyų' goodhaii nideegiiyaahkhii ts'ą' zhyaa deegiheenjyaa gaa gaagiindaii kwaa, ts'ą' gahahchįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadducee gwiginkhii nąįį, ąįį dinjii nadhak ąįįtł'ęę neegwiindaii gwinyąą gwik'iinjigiighit kwaa. Ąįį nąįį Jesus ts'ą' gahaajil ts'ą' giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Geech'ǫąąhtan, jii Law t'ee Moses diineenjit diiyaantł'oo, ‘Dinjii niindhat gwiizhit va'at gwanlii gaa vigii kwaa ji', ąįį dinjii niindhat, ąįį vachaa ya'at nooheendal goo'aii, tr'iinin gihee'yaa eenjit, gaa ąįį dinjii niindhat ąįį vigii k'it goorooheendal eenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ch'ihłan dinjii 7 nąįį nihchaa giilįį. Ch'oondee ąįį goonjik ts'ą' tth'aii vigii kwaa gwiizhit niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Vats'ąįį vachaa yiinlii ąįį tr'injaa noonjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ąįįtł'ęę gwats'ąįį vachaa chan neeyuunjik. Gooteegwagwaanchy'aa ts'ą' datthak ąįį tr'injaa eegaak'į', datthak ts'ą' googii kwaa ts'ą' nigiinjik. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ąįįtł'ęę ndaagwąą'ąį' dąį', ąįį tr'injaa chan niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nihchaa 7 nąįį datthak neegiiyuunjik ts'ą' nijin drin zhit niindhat nąįį neegogwandaii neegahoodlit ji', juu va'at heelyaa t'inchy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus jyaa goovahnyąą, “Juk gweendaa dinjii akwat tr'injaa haa nihteegogwaanjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Izhit zhat ji' ąįį juu Vit'eegwijyąhchy'aa gwinzii yąąh'in nąįį zhrįh neegweheendaii gaayiihahtsyaa ts'ą' duuyeh dinjii tr'injaa nąįį haa neegogoonjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Zheekat gwich'in k'it t'igiheechy'aa ts'ą' duuyeh nigiighit. Vit'eegwijyąhchy'aa vidinji' giheelyaa, nigiindhat ąįįtł'ęę neegwigwiindaii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses chan dinjii nadhak tł'ęę neegwiindaii łyaa t'igwinyąą ts'ą' geenjit gwadąąntł'oo, ąįį nijin tr'ał kǫ' yąhtsit gaa dhik'in kwaa gwinyąą dąį', zhat dąį' t'ee Vit'eegwijyąhchy'aa ąįįt'ee Abraham, Isaac, Jacob nąįį haa Goovit'eegwijyąhchy'aa nilii nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Gwandaii nąįį tthak eenjit Vit'eegwijyąhchy'aa nilii, gaa niindhat nąįį nakwaa, niindhat akwat gwandaii nąįį haa tthak gwandaii oonyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Law eech'ǫąąhtan lat nąįį khagiginkhee “Geech'ǫąąhtan, łyaa gwinzii goodii ginkhe'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ąįįtł'ęę t'ee ch'ihłak gaa Jesus noohaahkat gatr'agwaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus jyaa goovahnyąą, “Nats'ąą Christ ąįį yeenii David ts'an deedhaa ginyąą t'iginyąą? ");
INSERT INTO gwiNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","David, Psalms dęhtły'aa zhit jyaa nyąą, ‘K'eegwaadhat ąįį Shik'eegwaadhat jyaa ahnyąą, dzaa shriits'ąįį sheeghaii dhindii, nitr'ii'ee nąįį nandah oozhii hałtsyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David ąįį ‘Shik'eegwaadhat.’ yahnyąą gwiizhit nats'ąą Christ ąįį yeenii David ts'an diheedhaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Dinjii nąįį datthak giiyuułk'įį gwiizhit Jesus ąįį ditsyaa nąįį jyaa ahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Law eech'ǫąąhtan nąįį ts'į' adak'ǫǫntii, digi'ik zų' haa zhit gwa'an ch'eet'igwiniindhan haa sharahoh'e' zhrįh giindhan. Israel nąįį tr'igiinkhii zheh gwizhit gwinzii gwizhrįh tr'oodi' giindhan ts'ą' chan ch'ara'aa dąį' chan gwinzii gwizhrįh tr'oodi' giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tr'injaa vakai' niindhat nąįį goozheh goots'į' gohdak ts'ą' shroondaii chan niighyuk khadigigiinjii. Łyaa gwandaa gwiizųų googwarahaahshii gooveenjit goo'aii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus Kharigidiinjii Zhee Gwachoo gwizhit dhidii gwiizhit dinjii gwintsii veegoodlii nąįį dagalaraa k'ik zhit gilii gwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ąįįts'ą' chan tr'injaa neeshraahchy'aa vakai' niindhat dalaraa tsal datthak gwizhilii chan nah'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ąįįts'ą' jyaanyąą, “Jii tr'injaa neeshraahchy'aa vakai' kwaa ch'andaa gwizhinlii. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gaa ch'izhii nąįį dagalaraa lat zhrįh gwizhit ginlii. Jii tr'injaa neeshraahchy'aa ąįį jidii yaadagwahaandaii goo'aii datthak gwizhinlii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vitsyaa lat nąįį Kharigidiinjii Zhee Gwachoo geegiginkhii. Łyaa gwinzii giiyiichy'a'. Kii daatł'oo nizįį chan ts'ą' k'aiich'ii nizįį kwaii Vit'eegwijyąhchy'aa eenjit gwizhit gwanlii ginyąą. Jesus jyaa goovahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Jii kwaii juk nǫh'in. Yeendaa ji' kii tsal ch'ihłak gaa gwideek'it hee'aa kwaa. Datthak an heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","“Geech'ǫąąhtan,” ginyąą, “Ąįį nijin ji'? Nijin jyaa deegweheenjyaa ji', nats'ąą googwahaakyaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus jyaa nyąą, “Gwak'ǫǫhtii! Neenakhwaroon'ee shrǫ'! Jyąhts'ą' t'ee lęįį nąįį shoozhri' t'eehaahchy'aa ts'ą' nakhwats'ą' niheehaa ts'ą' jyaa giheenjyaa, ‘Shįį t'ee, eedan t'ihchy'aa!’ ts'ą', ‘It'ee zhat nigwiindhat!’ Gaa gootąįį hohjyaa shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nihłiriighan chan ts'ą' gogwantrii kwaii haa gwanlii gwinyąą dąį', noojat shrǫ'! Ąįį kwaii t'ee tr'ookit jyaa deegwehee'yaa, gaa nan ndaanąą'ąį' eenjit t'igwii'in kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ąįįts'ą' chan jyaa nyąą, “Nahkat datthak chan nihłigiheeghaa, ");
INSERT INTO gwiNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nan chan gwint'aii haatrat. Dinjii chan ihdeeheengaii. Nijuk datthak chan ts'ik iizųų gweheelyaa. Gwiizųų datthak teegweheedhat ts'ą' zheetii gwa'an chan gwilii t'igwehee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jii kwaii datthak t'igweheenjyaa gwats'ą' chan nakhwagooheendal ts'ą' Israel nąįį tr'igiinkhii zheh nihdeenakhwarahahchyaa. Ch'aroahkat zheh gwizhit nakhwaroohaahkat eenjit gwintł'ee narahahchyaa. Ąįįtł'ęę zhee gwaazhrąįį chan nihdeenakhwarahahchyaa. Shęh'an nahkat gwats'ą' k'eedeegwaadhat choh (King) nąįį ts'ą' nakhwarahahchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Zhat ji', t'ee Dęhtły'aa Choh kat Gwandak Nizįį eegahohkhyaa nakhweenjit gwinzii nagwahaadhal. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nakhwaroohaahkat gwats'ą', nats'ąą deehohjyaa geenjit tr'agohdii shrǫ', ");
INSERT INTO gwiNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nats'ąą deehǫǫhjyaa ts'ą' nakhwagwizhi' t'eehoohchy'aa datthak nakhwaa hihłyaa, jyąhts'ą' t'ee juu nakhwatr'ii'ee nąįį goodhaii nideegoohoohthal. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Nakhwayehghan, nakhwachaa, nakhwalak, nakhwajyaa nąįį haa gwintł'ee nakhwahahchyaa. Nakhwalat nąįį gaa tr'iheeghaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lęįį nąįį shęh'an nakhwatr'ihee'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nakhwakiighai' ch'ihłak gaa duuyeh haa tr'igwiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Akhagohnyą' shrǫ'! Gwandaii nizįį gaayiihootsyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nijin niveet'ah'in nąįį Jerusalem geelin nigiinjil gooh'in ji' t'ee ąįį kwaiik'it an gweheelyaa ts'ą' gaakhwahandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Juu Judea nahkat dilk'ii nąįį oodak taih tee gwats'ą' galgahohjyaa gwizhrįh, juu Jerusalem kwaiik'it gwachoo gwizhit dilk'ii nąįį chan gihłeegiheedaa gwizhrįh, juu oo'ok tr'ałtee tthan dilk'ii nąįį chan kwaiik'it gwats'ą' gohoojyaa shrǫ'! ");
INSERT INTO gwiNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ąįį kwaii t'ee zhit ji' jyąhts'ą' t'ee dinjii agwahaanzhii, Dęhtły'aa Choh zhit jyaa deegwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Izhit ji' łyaa tr'injaa vizhit tr'iinin chants'ą' juu tr'iinin ach'ahma' nąįį haa eenjit gwigweheetrii! Jii nahkat gwich'in nąįį ts'ą' gwiizųų teegwahaadhal, ąįįts'ą' Vit'eegwijyąhchy'aa googwahąhshii. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Goolat nąįį shrii choh haa googiheeghaa ts'ą' nahkat datthak gwitee googwąąnchy'aa ts'ą' zhee gwaazhrąįį nagoogiheelyaa ts'ą' dahkhyuk gooveegoo'aii gwats'ą' ch'adanh gwich'in nąįį Jerusalem gwats'ą' k'eegogwahaadhat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Shree, tǫǫ oozhrii, są' kwaii ts'an gwilii t'igwehee'yaa. Nankat datthak dinjii lęįį nąįį zhit tr'igwidii hee'aa, nijin chųų choh kat chųų dohtth'ak ji', deegweheentsai' ts'ą' chųų zheet'atł'ak haa gwintsii an gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jii nankat datthak dinjii nąįį tth'aii goots'ą' deegwehee'yaa gaagiindaii kwaa ąįį eenjit nagogwal'in gwiizhit naajat haa oo'an t'eegahaadhal. Zheetii jidii dhidlii datthak haatrat. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ąįįtł'ęę t'ee Gwidinji' ineegwahaakyaa, zheek'ǫh zhit vich'eegwąhndit ts'ą' t'aih nitsii haa t'ihee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nijin jii kwaii jyaa dagwahah'ya' ji', k'igwąą'ee nohthat ts'ą' nakhwakiitth'an ndak dhoh'ąįį, it'ee niighit kwaa neenakhwarahahshii geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ąįįtł'ęę t'ee Jesus jii gwandak zhit geegavoąąhtan, “Zhit vakat Figs nahshii ąįįts'ą' ts'iivii kwaii datthak nǫh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nijin vakat ch'at'an nahshii nǫh'in dąį' t'ee niighit kwaa shin gweheelyaa gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Izhit gwik'it deegwehee'yaa diinyą' gwik'it t'igwii'in gooh'in ji' t'ee K'eegwaadhat Veegwinii'ee eenineegwiighit t'igwii'in gaakhwahandaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Łi'haa nakhwats'ą' ginkhii t'ihnyąą! Juk gweendaa gwandaii nąįį datthak niinjik kwaa tł'ęę jii kwaii zhit gweheedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zhee, nan haa kwaa gweheelyaa gaa shiginjik ąįį khit łi'didlii heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Adak'ǫǫntii! Ch'akhwanįį ts'ą' shraa haa khaihłan nineekhwadal kwaa ts'ą' chan jidii datthak goohǫhdaii eenjit gwizhrįh geetr'agoh'in kwaa, ąįį drin t'ee nakhwarahtee nagwahaadhal. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jii nankat gwidinji' nąįį datthak ts'ą' khanhee vineegwahaakyaa t'inchy'aa, nin khyąh zhiinzhii ts'ą' dhadroo gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Gweedhaa datthak gwak'ǫǫhtii ts'ą' jii gwinzii gwideetaa hinkhaa ts'ą' geenjit t'aih hini'yaa eenjit khit khadagohjii, ąįįts'ą' chan Gwidinji' vats'ą' nihiinkhaa giindhan ji' eenjit chan.” ");
INSERT INTO gwiNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesus Kharigidiinjii Zhee Gwachoo gwizhit drin gwitee gwąąnchy'aa datthak, geech'ǫąąhtan, khaa neegwiilik hee heechyaa eenjit Taih Vakat Olives Nahshii ts'eehidik. ");
INSERT INTO gwiNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Vanh dąį' hee juu nąįį datthak Kharigidiinjii. Zhee Gwachoo gwits'eegihiidal ts'ą' giiyuułk'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Drin gwiteegogwąąnchy'aa łųhchy'aa vitee łųh vaaniituu kwaa tr'ihee'aa khaiinjii nigwiindhat, ąįįt'ee Passover gagahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Giinkhih kįh dilk'ii nąįį chan ts'ą' Law eech'ǫąąhtan nąįį haa dinjii nąįį agąąnjat ts'ą', nats'ahts'ą' gwik'iighai' Jesus gahaahkhwaa gwankagantii geetr'agogwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jesus vitsyaa 12 nąįį ch'ihłak Judas Iscariot oaazhii ąįį Ch'anky'aa Tr'aanduu yizhit diindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ąįįts'ą' t'ee Judas ąįį giinkhih kįh dilk'ii nąįį chan ts'ą' Kharigidiinjii Zhee Gwachoo gwats'ą' k'eegwaadhat nąįį haa ginkhii, nats'ahts'ą' Jesus goontł'eehahchyaa geegiginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Deegiinyą' ąįį geenjit shoo ginlii ts'ą' laraa haa giigoinkwat. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas aahą' nyąą ts'ą' t'ee dinjii nąįį gwiky'aahaandal kwaa eenjit nats'ahts'ą' gwintł'eeyahahchyaa gwankantii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","It'ee Passover nigwiindhat ts'ą' łųhchy'aa vitee łųh vaaniituu kwaa tr'ihee'aa nigwiindhat ts'ą' divii tsal kwaii ąįį geenjit gahaahkhwaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesus ąįį Peter chan ts'ą' James haa jyaa ahnyąą, “It'ee hoh'oo ts'ą' Passover geenjit ch'arehee'aa diineenjit gohtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Ąįį nijin ch'arehee'aa gwarohtsyaa diinoiinyaa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jyaa goovahnyąą, “Ch'oodǫǫhk'įį! Nijin kwaiik'it gwachoo nihdǫǫ'oo gwiizhit dinjii chųų tyah zhit chųų haa nakhwats'ą' tr'iheehaa t'oonchy'aa. Nijin zheh nihdeiinzhii ąįį vaa nihdǫh'oo, ");
INSERT INTO gwiNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ts'ą' ąįį juu zhat zheh gwats'ą' k'eegwaadhat jyaa vohnyąą: ‘Geech'ǫąąhtan jyaa nahnyąą, nizheh gwizhit nijin shitsyaa nąįį haa Passover drin neech'irehee'aa?’ ");
INSERT INTO gwiNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Zheh gwił'ąįį gwakat chan zheh dagoo'aii nats'ą' googwahaahchy'aa, izhit gwizhit datthak shragahohłyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jerusalem kwaiik'it gwats'ą' gahaa'oo ts'ą' t'ee Jesus deegoovahnyąą chy'aa datthak gogogwąh'ąįį ts'ą' t'ee Passover drin eenjit ch'arehee'aa shrigwigwiinlik. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nijin zhat nigwiindhat dąį', Jesus vakaii'aa ts'ą' Tr'ihił'e' nąįį haa naadii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ąįį t'agoovahnyąą, “Khaiinjich'isheheeghit gwehkįį jii Passover nakhwaa noih'aa nihthan. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nakhwaa gwaldak. Jii Passover, chan duuyeh nakhwaa neih'aa, dahthee K'eegwaadhat Veegwinii'ee zhit gwik'it gweheelyaa gwats'ą'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nijin Jesus chųų tyah oonjik dąį', Vit'eegwijyąhchy'aa ts'ą' “Mahsį',” nyąą. Ąįįtł'ęę givintł'eeyiinkaii. “Jii jak chų' nakhwatee googwąąnchy'aa ts'ą' akhwanįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nakhwaa gwaldak duuyeh vats'an ishinįį dahthee K'eegwaadhat Veegwinii'ee nineegweheedhaa gwats'ą'.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ąįįtł'ęę łųhchy'aa oonjik ts'ą' Vit'eegwijyąhchy'aa ts'ą', “Mahsį',” nyąą. Ąįįtł'ęę łeeyiiłnaii ts'ą' givintł'eeyąhtsit ts'ą' t'inyąą, “Jii t'ee shatthąį', nakhweenjit Vit'eegwijyąhchy'aa antł'eehałchaa. Jii shineehoondaii eenjit jyaa dakhwa'in.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ąįį chųų tyah chan gwik'it t'inlik. Ch'igiin'al tł'ęę chųų tyah oonjik ts'ą' t'inyąą, “Jii jak chų' t'ee Vit'eegwijyąhchy'aa deehee'yaa nyąą gwik'it t'iizhik shadaa nakhweenjit gwats'an hahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Gooh'in! Jii juu gwintł'eeshahahchyaa, juk dzaa vakaii'aa ts'ą' shaa dhidii! ");
INSERT INTO gwiNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Vit'eegwijyąhchy'aa jyaa nyąą geh'an Gwidinji' niheedhaa, gaa zhit juu gwintł'eeyąhchįį łyaa veenjit gitr'iih'ee!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ąįįtł'ęę nihłagoahkat, diitee juu t'ahnyąą? ");
INSERT INTO gwiNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Juu gootee ch'andaa hil'ee eenjit vitsyaa nąįį nihzheedagąąn'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus jyaa goovahnyąą, “Jii nankat gwi-King nąįį datthak nankat gwidinjii datthak eenjit t'aih gii'įį, ąįįts'ą' zhit gwats'ą' k'eegwaadhat nąįį, Dinjii nąįį ‘Jyaa',’ jyąhts'ą' goovoozhri'. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gaa nakhwaa jyaa deegweheechy'aa kwaa goo'aii. Nakhwatee juu ch'andaa hil'ee ąįį zhit khaiints'ą' k'it t'iheechy'aa goo'aii. Ąįįts'ą' juu kįh dhidii chan ch'itsyaa heelyaa k'it t'iheechy'aa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Juu shrit ch'andaa hil'ee, zhit juu ch'ihee'aa eenjit dhidii akwat zhit juu ch'itsyaa nilii? Zhit juu dhidii reh. Gaa shįį ąįįt'ee nakhwatee ch'itsyaa ihłii gwik'it t'ishi'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Shaa gogwantrii dąį', datthak shaa t'oochy'a'. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ąįįts'ą' Zheekat Shiti' t'aih shats'an ąhtsii gwiłtsąįį, izhit gwik'it shant'ee jyaa danakhwahihłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Gwats'ą' k'eegwaldhat gwizhit vakat ch'ara'aa kat ch'ahoh'aa ts'ą' ch'akhwanjyaa. Ąįįts'ą' Israel nahkat neezheedijii ch'ihłoaatin ts'ą' neekwaii (12) nąįį gwich'įį eenjit k'eegwahaadhat.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon! Ch'oodǫǫhk'įį! Satan nakhwatee gwąąnchy'aa nakhwaa tr'agwahaah'ya', nizįį nąįį iizųų nąįį ts'an tr'iheelyaa, dinjii gwąąhshii dagwanzhih tee tr'igwilii gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gaa neenjit khadigiidi' t'oonchy'aa Simon, nigwik'iinjigwiighit akhagoohiinjyaa kwaa geenjit. Nijin shits'eenoozhii tł'ęę, nachaa nąįį gook'injigwiighit t'aih neehahtsyaa gwizhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter jyaa yahnyąą, “Shik'eegwaadhat, it'ee zhee gwaazhrąįį naa gwats'ą' hihshyaa ts'ą' naanihihthaa eenjit nanoodhal'in!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Naagwahaaldak Peter, tik agwaanchy'aa shaanandaii kwaa hinjyaa gwats'ą' datthak juk khaa rooster hahchyaa kwaa t'oonchy'aa,” jyaa yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ąįįtł'ęę Jesus jyaa goovahnyąą, “Nijin laraa dhah, khwah chan ts'ą' dachan kwaiitryah haa ehdan nakhwahooł'e' dąį' nik'ee k'aiich'i' t'oohchy'a'?” “K'eiich'i' t'eegwaahchy'aa kwaa,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Gaa juk, juu laraa dhah akwat khwah haa di'įį ji' adahaayehee'aa gwizhrįh. Ąįįts'ą' juu vishrii choo kwaa chan di'ik laraa t'įį hahchal ts'ą' shrii choh ooheekwat gwizhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Jii geenjit nakhwaagwahaldak, Dęhtły'aa Choh kat gwa'an jyaa deegwinyąą, ‘Law łaahnaii k'it giits'ą' tr'agwah'in.’ Ąįįt'ee łyaa sheenjit gwik'it gweheelyaa gwizhrįh goo'aii. Ąįį sheenjit gwadanakhwatł'oo gwik'it gweheelyaa geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Shik'eegwaadhat,” giiyahnyąą, “Juk dzaa shrii choh neekwaii dhitin.” Akhai' jyaa goovahnyąą, “Jyaa dohnyąą kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ąįįtł'ęę Taih Vakat Olives Nahshii chan hee Jesus ditsyaa nąįį haa gwits'eehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nijin zhat k'eegiidal dąį', jyaa goovahnyąą, “Neenakhwareheen'ee gwizhit gwiizųų tr'agahoh'yaa kwaa geenjit khadagohjii.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ąįįtł'ęę t'ee goołeehaazhii, kii nireheetthaa gąhthee gwa'an nikiigwiintthaii ts'ą' khadigiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Shiti', Gwik'it t'ini'yaa ji', jii chųų tyah shats'an tr'iin'ąįį. Shįį deeyiihthan ąįį gwik'it nǫh'ya' shrǫ', gaa nan deenoo'ya' niindhan ąįį gwik'it t'ini'in.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ąįįtł'ęę zheekat gwats'an Zheekat Gwich'in t'aih yintł'eehee'aa eenjit vats'ą' igwiilkįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ąįįtł'ęę gwint'aii khadigiinjii ts'ąįį gaa viniteiinjat ts'ą' gwintł'oo tr'igwidii ts'ą' dah k'it t'inchy'aa vats'an nankat daa'il. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nijin khadigiinjii gwats'an ndak ninehjin dąį', Vitsyaa Nąįį tr'igwidii haa giłchųų chy'aa ts'eehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","“Jaghaii dhohchųų?” goovahnyąą. “Khakyuuzhii ts'ą' neenakhwariheen'ee gwizhit gwiizųų tr'agahoh'yaa kwaa geenjit khadagohjii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus tth'aii hee ginkhii gwiizhit lęįį nąįį zhat k'eedal vitsyaa ch'ihłak, Judas oaazhii, ąįį goots'ii ahaa ąįį Jesus ts'ą' niinzhii ts'ą' yiilts'ų'. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Gaa Jesus ąįį jyaa yahnyąą, “Judas, shįį t'ee Gwidinji', gwintł'eeshąhchįį, ąįį ts'ų' haa lee t'ini'in?” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesus vitsyaa nąįį deegweheenjyaa t'igwinyąą gwik'igaanjik dąį', jyaa ginyąą, “Diizhrii haa gooroogha' jaghaii, K'eegwaadhat?” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Gootee ch'ihłee zhit ndak khii giinkhih choh vi-slave ch'ihłak iłkhaa ts'ą' shriits'ąįį yidzee gadąąhtrit. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Gaa Jesus ąįį jyaa nyąą, “Jyaa dineekhwa'yaa kwaa t'oonchy'aa!” Ąįįtł'ęę ąįį dinjii vidzee kat naanjik ts'ą' shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Zhat giinkhih k'įh dilk'ii nąįį chan ts'ą' Kharigidiinjii Zhee Gwachoo gwak'ąąhtii chan ts'ą' Israel k'įh dilk'ii nąįį yuuhaanjik nąįį jyaa ahnyąą, “Law łaahnaii iizųų ihłii k'it zhit shrii choh, gałkhwąįį haa sheenjit t'oohchy'aa gwat'oohchy'aa lee t'akhwa'in? ");
INSERT INTO gwiNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Drin gwiteegwaanchy'aa Kharigidiinjii Zhee Gwachoo gwizhit nakhwaadhiidii gaa shǫhjii gwik'eegǫhdaii kwaa. Juk zhat t'ee deekhwa'yaa goo'aii chy'aa gwik'it t'akhwa'in. Khaa hee tr'aanduu digwitr'it t'agwah'in gwiizhit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesus goonjik ts'ą' ndak khii giinkhih choh vizheh gwats'ą' giihiłchįį. Peter ąįį gootąįį niighit ahaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ndak khii giinkhih choh zheh gokwantee gwigwiiłk'a' ts'ą' Peter zhat juu kǫ' eelin dilk'ii nąįį teiinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nijin gootee nich'it tsal giveetr'agwah'in nilii, ąįį Peter kǫ' ts'ą' dhidii niił'in dąį', yąąh'in ts'ą' jyaa nyąą, “Jii dinjii Jesus haa neehidik t'inchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Gaa Peter, “Ąįį nakwaa!” nyąą. “Tr'injaa, ąįį vaashandaii kwaa t'inchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ąįįtł'ęę ch'izhii dinjii chan niyiił'in ts'ą' jyaa nyąą, “Nan chan gootee gwats'an inlii łee!” Gaa Peter ąįį jyaa nyąą, “Shįį t'ihchy'aa kwaa, naihnyą'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ąįįtł'ęę niighit gwahaadhat kwaa tł'ęę dinjii ch'ihłak jyaa nyąą, “Jii dinjii t'ee łyaa vaa yaał'ya' t'inchy'aa, Galilee gwats'an ahaa geh'an reh!” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Gaa Peter t'iiyahnyąą, “Dinjii, jidii eeginkhii t'iinyąą gaashandaii kwaa!” Zhazhat tth'aii ginkhii gwiizhit rooster haahchik. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Diik'eegwaadhat Jesus neediil'ee ts'ą' Peter nah'in. Ąįįts'ą' Peter Diik'eegwaadhat deiinyą' chy'aa yiginjik anaanjik, jii jyaa diyaiinyą', “Juk drin rooster haahchyaa gwats'ą' tik agwaanchy'aa shaanandaii kwaa hinjyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter chyahaazhii ts'ą' gwint'aii iintrii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ąįį juu dinjii Jesus k'ąąhtii nąįį giiyeedlaa ts'ą' giiyąąhkhwąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Giiyandee tł'an dineech'ahchal ts'ą' giiyųąhkat, “Juu nilgwat? Diinaa gwandak lee?” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ants'ą' gwinlęįį geenjit zhideegiiyąąhts'įį. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Drin neegahoodlit dąį', Israel kįh dilk'ii nąįį, giinkhih kįh dilk'ii nąįį chan ts'ą' Law eech'ǫąąhtan nąįį khaihłan nigiinjil ts'ą' nigiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Diinaa gwandak,” giiyahnyąą, “Nan lee Christ Diik'eegwaadhat t'inchy'aa?” Jyaa goovahnyąą, “Nakhwaagwaldak ji', duuyeh shik'iinjuhkhit, ");
INSERT INTO gwiNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ąįįts'ą' shįį chan nakhwaałkat ji', duuyeh shidiineegoohjii. ");
INSERT INTO gwiNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gaa juk gwats'an Zheekat Gwidinji' ąįį Vit'eegwijyąhchy'aa datthak geenjit t'aih di'įį veeghaii shriits'ąįį heedyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Datthak jyaa ginyąą, “Akwaa ji', nan lee Vit'eegwijyąhchy'aa Vidinji' t'inchy'aa?” Jyaa goovahnyąą, “Nakhwan, ąįįt'ee jyaa dashohnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ąįįts'ą' jyaa nihłagaanyąą, “Juk t'ee dinjii yeediinaagwahaandak veenjit t'eegwaahchy'aa kwaa! Diinandah deiinyą' gwizhrįh, gaa gwinzii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Izhit Israel gwakhaihkwaii nąįį datthak ndak nigiinjil ts'ą' Pilate ts'ą' Jesus nagąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Izhit t'ee jyąhts'ą' giiyeeginkhii, “Jii dinjii t'ee dinjii nąįį teehilii, ‘Caesar ts'ą' tax ohkwat shrǫ',’ goovahnyąą ts'ą' chan King akwat Christ chan adaanyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate yuahkat, “Nan lee Jews nąįį goo-King inlii?” Jesus jyaa diyahnyąą, “Nan reh jyaa diinyąą t'oonchy'aa reh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ąįįtł'ęę Pilate ąįį giinkhih kįh dilk'ii nąįį chan ts'ą' zhat dinjii dilk'ii nąįį jyaa ahnyąą, “Jii dinjii jaghaii tr'ahaahkhwaa veegwaał'in kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gaa łyaa gwint'aii giginkhii ts'ą' jyaa ginyąą, “Judea nahkat gwizhit geech'ǫąąhtan ts'ą' veh'an dinjii nąįį nihłiighan. Galilee hee hiłjik ts'ą' juk chan dzaa k'idik.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nijin Pilate jii gwiitth'ak dąį', jyaa goovahnyąą, “Jii dinjii Galilee gwats'an ahaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nijin nahkat Herod gwats'ą' k'eegwaadhat gwats'an Jesus ahaa gwiky'aanjik dąį'. (Izhit dąį' Herod Jerusalem dhidii.) Izhit gwats'ą' Jesus yats'ą' nąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod, Jesus niił'in dąį', łyaa shoo nilii. Dee'in yeegwiitth'ak ts'ą' khit nooł'ya' yuunyąą. Jesus shandah nagohts'į' niindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod, Jesus gwintł'oo oahkat, gaa yidii ginkhii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Giinkhih kįh dilk'ii nąįį Law eech'ǫąąhtan nąįį haa k'iindaa nigiinjil ts'ą' gwiizųų datthak Jesus eegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod viniveet'ah'in nąįį haa giiyeedlaa ts'ą' giiyuuzhri' iizųų ąhtsii. Ik łyaa nizįį Jesus anagąhtsuu. Ąįįtł'ęę Pilate ts'ą' nineegiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Izhit drin gwats'an t'ee Herod chan ts'ą' Pilate haa nihjyaa gaadlit. Gwehkįį dąį' nihłitr'igii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate ąįį giinkhih kįh dilk'ii nąįį, Israel kįh dilk'ii nąįį, dinjii nąįį haa khaihłan niinlii, ");
INSERT INTO gwiNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ts'ą' jyaa goovahnyąą, “Jii dinjii shats'ą' noohchįį. ‘Dinjii nąįį teehilii,’ vohnyąą. Juk nakhwandah gwizhrįh naałchįį, gaa dee'ya' vohnyąą, ąįį ch'ihłak gaa gwik'it t'ee'ya' veegwaał'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod chan diits'eeyihił'e' akwat adan chan gwik'it t'iiyahthan. K'eegwiichy'aa t'ee'ya' nakwaa akwat duuyeh tr'ąąhkhwąįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tr'ahahtrii veenjit gwahałtsyaa. Ąįįtł'ęę vineereheendal.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Passover gwigwiłtsąįį nineegwiidhak hee Pilate zhee gwaazhrąįį gwats'an dinjii ch'ihłak chineehahchik goo'aii.) ");
INSERT INTO gwiNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Juu zhat dilk'ii nąįį datthak jyaa ginyąą ts'ą' gazhral, “Vęhdaa tr'agǫh'ąįį! Barabbas diineenjit chinoohchįį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas t'ee dinjii ęhdaa tr'igwiin'ąįį ts'ą' chan veh'an dinjii nąįį nihłeegha' geh'an zhee gwaazhrąįį dhidii). ");
INSERT INTO gwiNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate ąįį Jesus vineeroonjii niindhan ts'ą' chan hee dinjii nąįį oahkat. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gaa gazhral ts'ą' jyaa ginyąą, “Cross kat gohtsak! Cross kat gohtsak!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Neekwat gwehkįį gavoahkat ts'ą' chan hee t'agoovahnyąą. “Jidii gwiizųų tr'agwah'ya' eenjit t'avohnyąą? Dee'ya' vohnyąą ąįį ch'ihłak gaa gwik'it t'ee'ya' veegwaał'in kwaa. Jaghaii tr'ahaahkhwaa vaashandaii kwaa. Tr'ahahtrii veenjit gwahałtsyaa. Ąįįtł'ęę vineereheendal.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Googaa nihk'it dinjii nąįį ąįįts'ą' giinkhih kįh dilk'ii nąįį gwint'aii gazhral ts'ą', “Jesus garohtsak!” ginyąą, ts'ą' t'ee gaayiideech'igiiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ąįįts'ą' t'ee Pilate deeginyąą, “Gwik'it Jesus t'ireheelyaa,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ąįį juu dinjii zhee gwaazhrąįį chineerohchyaa giindhan, ąįį chinąąhchįį, ąįįt'ee yaagha' juu veh'an nihłich'eegha' ts'ą' dinjii diłkhwąįį reh. Ąįįts'ą' t'ee Jesus goovantł'ąhchįį, deegiiyuh'ya' giindhan gwik'it t'igiihah'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesus gihłeegihiłchįį. Gihłeegihiijyaa gwiizhit Cyrene gwats'an dinjii, Simon oaazhii, kwaiik'it gwachoo ąįį oo'ok gwats'an k'idik łee ąįį adagaajil. Giiyąhtsit ts'ą' Jesus tąįį cross ichyaa giiyiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Dinjii lęįį nąįį yatąįį adaa. Gootee gwa'an tr'injaa lat nąįį gwint'aii giiyeenjit itree. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus goots'ą' neediil'ee ts'ą' jyaa goovahnyąą, “Jerusalem gwitr'injaa nąįį! Sheenjit ohtree kwaa. Nakhwagii chan ts'ą' ideenjit haa ts'ąįį ohtree. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Niighit kwaa dinjii nąįį jyaa deeheenjyaa geenjit goo'aii, juu tr'injaa vigii kwaa ts'ą' digii ich'iłma' kwaa geenjit shoo oolį'! ");
INSERT INTO gwiNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Izhit nigwiindhat ji' t'ee dinjii nąįį, ‘Ddhah diik'aa nooghyii ts'ą' taih chan geegoh'it diinohdli',’ giheenghyaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ts'iivii tth'aii diłtraa gwiizhit t'ee jyaa deegwehee'yaa, nijin ąįį ts'iivii traa dhidlit ji', gwandaa gwiizųų nagwahaatth'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Dinjii neekwaii gwiizųų tr'agogwąh'ya'. Ąįį nąįį chan Jesus haa gigihiłtsak. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nijin taih, “Dinjii kiitth'an (Skull)” oaazhii, k'eegiidal dąį', Jesus chan ts'ą' ąįį dinjii iizųų neekwaii haa gagoogiłtsak. Ch'ihłak chan Jesus veeghaih shriits'ąįį dhidii ts'ą' ch'izhii chan tł'ohts'ąįį dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus jyaa nyąą, “Shiti', giveenjit oo'an gwihiinlii! Deegii'in t'igii'in gaagiindaii kwaa t'igii'in.” Kii tsal gahahtł'ak haa juu yagwach'aa ts'an hąąh'yaa eenjit tseegii'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Dinjii nąįį tthak aakin gogwaa'įį gwiizhit Israel kįh dilk'ii nąįį giiyeedlaa. “Christ nilii ts'ą' Vit'eegwijyąhchy'aa gwitee tr'iiyąąhchįį t'inchy'aa ji', ch'izhii nąįį nahshii, akwat adan chan needoozhii jaghaii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Niveet'ah'in nąįį chan giiyeedlaa. Giits'ą' nineedal ts'ą' jak chų' daatł'oo kwaa giits'ą' ootą', ");
INSERT INTO gwiNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ts'ą' jyaa ginyąą, “Jews nąįį goo-King inlii ji', needaanzhii!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Vehdee jii danahootł'oo, “Jii t'ee Jews nąįį eenjit King t'inchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ąįį juu veeghaii dinjii ch'ihłak giltsak ąįį shraa haa t'iiyahnyąą, “Christ inlii t'oonchy'aa, akwat gwats'an tr'eedaanchįį ts'ą' diikhwan chan gwats'an tr'eediinąąhchįį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ch'izhii dinjii chan ch'ats'ą' t'iiyahnyąą ts'ą' jyaa yahnyąą, “Vit'eegwijyąhchy'aa viyinjiihooh'ee? Datthak ts'ą' diirahaaghan. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Diikhwan, ąįį łi'didlii haa t'idiirah'in, gwiizųų tr'agwarah'ya' ąįį geenjit diineegwarookwat izhit geh'an, gaa adan ąįį gwiizųų tr'agwah'ya' kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ąįįts'ą' Jesus jyaa ahnyąą, “Shanandaii, Jesus, King dhindlit tł'ęę!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus t'iiyahnyąą, “Łi'didlii haa zhit juk drin zheekat shroonchy'aa goo'aii gwizhit shaa t'ahohchy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Drin tł'an gwats'an gishreen'ąįį kwaa goodlit ts'ą' 3 o'clock gwats'ą' zhat nahkat datthak tǫǫ gwiinli'. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kharigidiinjii Zhee Gwachoo gwizhit gihdeiinvyaa gaa teetł'an nihtr'iinch'aa. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus shraa haa khashraa'iintrat, “Shiti'! Shanky'aa nanli' zhit gwihih'aa!” Jyaa nyąą ts'ą' niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Niveet'ah'in nąįį ts'ą' Diik'eegwaadhat deegwiizhik gwąąh'in dąį', Vit'eegwijyąhchy'aa deehiił'ee ts'ą' jyaa nyąą. “Jii łyaa dinjii nizįį t'inchy'aa łee!” ");
INSERT INTO gwiNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nijin zhat dinjii dilk'ii nąįį deegwiizhik googwąąh'ya' dąį', oo'an digizheh tr'igwidii haa gwits'eegahoojil. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gootee juu gwinzii Jesus haandaii nąįį, zhit juu tr'injaa Galilee gwats'an yatąįį adaa nąįį shriit'ąhthee gwa'an gwats'an tr'igwidii haa gwik'eegąąhtii. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Judea nahkat gwizhit kwaiik'it gwachoo Arimathea goozhii gwats'an dinjii Joseph oaazhii. Dinjii nizįį akwat viyinjirihił'ee nilii. K'eegwaadhat Veegwinii'ee giheelyaa geenjit nagwal'in. Ąįį kįh dilk'ii nąįį tee dhidii, gaa Jesus deeroolyaa giinyą' dąį', adan ąįį goovaa gitr'ii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilate ts'ą' niinzhii ts'ą', “Jesus vichį' shintł'eerohchyaa,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yichi' neenąhchįį ts'ą' ts'at dril zhit yahchįį. Ąįįtł'ęę kii zhit gweedii goo'aii gwizhit yahchįį. Ąįį tth'ank'it gwehkįį dinjii gitsii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Drints'ą' drin gweedhaa, ąįįts'ą' t'ee Neegwaazhii Drin nigwiighit. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ąįį tr'injaa juu Galilee gwats'an Jesus tąįį haajil nąįį Joseph haa gahaajil ts'ą' nijin Jesus vichį' vanaanjik googwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ąįįtł'ęę digizheh gwits'eegahoojil ts'ą' gwinzii vagwaatsan giiyeenjit shrinlik. Law zhit deegwinyąą gwik'it Neegwaazhii Drin tr'agogwąh'ya' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Drin zhit vanh dąį' hee tr'injaa nąįį ąįį jidii gwinzii vagwaatsan shriginlik haa Jesus vatth'ank'it gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Vatth'ank'it gwadąįį kii gihłeehiltth'at łee googwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ąįįts'ą' nihdeeginjil, gaa Diik'eegwaadhat Jesus vichį' gąąh'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Zhat nigiilzhii ts'ą' deegwiizhik t'igwii'in gaagiindaii kwaa, gwiizhit khan hee dinjii neekwaii vagwach'aa ch'ahdrii giveeghaii nadhat nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Gwint'aii gąąnjat ts'ą' nankat nikiigogwąh'ee gwiizhit ąįį zheekat gwich'in neekwaii jyaa goovahnyąą, “Dinjii gwandaii gwiizhit jaghaii tth'ank'it gwizhit vinkeegǫh'in? ");
INSERT INTO gwiNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Dzaa dhidii kwaa t'inchy'aa, gwandaii needhidlit. Galilee dhidii dąį', deenakhwahnyąą ganoondaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Gwidinji' dinjii iizųų nąįį antł'eehahchyaa ts'ą' gigiihahtsak. Ąįįtł'ęę drin tik gwiindhat tł'ęę neegweheendaii.’” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ąįįtł'ęę tr'injaa nąįį giiginjik anaanjik, ");
INSERT INTO gwiNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Tth'ank'it gwats'an oo'ee neegiijil ts'ą' jii datthak giitsyaa 11 chan ts'ą' ch'izhii nąįį haa googwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ąįį tr'injaa t'ee Mary Magdalene, Joanna, James vahan Mary, nąįį haa, Jesus vitsyaa nąįį ts'ą' goovandah deegwiizhik goovaagogwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gaa vitsyaa nąįį ąįį tr'injaa deeginyąą zhyaa t'igwinyąą giindhan ts'ą' gwik'iinjigiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Gaa Peter ąįį ndak ninehjin ts'ą' tth'ank'it gwats'ą' hilgik, gwizhit gwąąh'in, gaa yagwach'aa zhrįh nah'in, gaa ch'akwaa. Ąįįtł'ęę dizheh gwits'eehoozhii, deegwiizhik t'igwinyąą li' niindhan. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Izhit drin gootee dinjii neekwaii nąįį Jerusalem gwats'an 7 mile Emmaus kwaiik'it gwats'ą' gee'al. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Deegwiizhik datthak geenjit nihłaa geegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Geegoogwaandak ts'ą' geegiginkhii gwiizhit Jesus gooveeghaih niinzhii ts'ą' goovaa ahaa, ");
INSERT INTO gwiNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","giiyąąh'in gaa adan t'inchy'aa giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus t'agoovahnyąą, “Oh'al gwiizhit jidii eegoohkhii?” Khaihłan nagadhat ts'ą' goonin kat tr'igwidii dha'aii. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ch'ihłak dinjii Cleopas oaazhii ąįį yuahkat, “Nan zhrįh Jerusalem gwizhit aakin inlii juk k'ehdąį' gwanaa gwats'an deegwiizhik gaanandaii kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Jaghaii, deegwiizhik?” goovahnyąą. “Jesus, Nazareth gwats'an deeginlik reh,” ginyąą. “Ąįį dinjii t'ee łyaa Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii, dee'ya' chan ts'ą' deiinyą' datthak geenjit t'ee Vit'eegwijyąhchy'aa chan ts'ą' dinjii datthak haa giishoo'ąhłii. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Giinkhih kįh dilk'ii nąįį chan ts'ą' Israel kįh dilk'ii nąįį tr'ahaahkhwaa eenjit gwintł'eegiiyahchįį tł'ęę t'ee gigiiyiłtsak. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ąįįts'ą' Israel gwich'in nąįį neehahshii ji', tr'oonyaa eenjit veenjit niinjich'aradhat! Izhit gwizhrįh nakwaa, juk t'ee k'ehdąį' gehnaa hee t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Diitee gwats'an tr'injaa lat łyaa geegwaroolii kwaa diineenjit t'igiizhik. Vanh gineech'ihii'aii gwiizhit, tth'ank'it gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Gaa khyų' giichį' kantii. Oo'ee neegiijil ts'ą' zheekat gwich'in diits'ą' igwiilkįį ts'ą' tth'aii hee Jesus gwandaii diigahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Diilak nąįį zhat nagaajil akhai' ąįį tr'injaa deegiinyą' chy'aa tth'aii nihk'it t'oonchy'aa googwąąh'ya', gaa adan ąįį giiyąąh'ya' kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tł'ęę Jesus jyaa goovahnyąą, “Łyaa tr'agǫhjik, deegwahtł'oo zhyaa Vit'eegwijyąhchy'aa Eenjit Ginkhii deegiinyą' gaa gwik'iinjuhkhit kwaa! ");
INSERT INTO gwiNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Christ Diik'eegwaadhat jyaa ts'ą' t'ee khaiinjich'ohoodhat, ąįįtł'ęę geh'an t'ee zheekat gwizhit vich'eegwąhndit.” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ąįįts'ą' Jesus Dęhtły'aa Choh zhit deevaraiinyą' datthak eegoovaagwaandak, oondaa nijin Moses vidęhtły'aa chan ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį dagogwąąntł'oo izhit gwats'an hee. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nijin kwaiik'it gwats'ą' geedaa geenigiinjil dąį' Jesus ąįį gehgoo heekhaa k'it t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Gaa zhak giiyuunjik ts'ą' jyaa giiyahnyąą, “Diinaa niinkhaa. It'ee niighit kwaa tǫǫ gweheelyaa.” Ąįįts'ą' t'ee goovaanihdineezhii ts'ą' naahaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Vakat ch'ara'aa ts'ą' goovaanaadii, łųhchy'aa oonjik ts'ą' “Vit'eegwijyąhchy'aa mahsį',” nyąą. Ąįįtł'ęę łeeyiiłnaii ts'ą' goovantł'eeyahtsit. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jesus t'inchy'aa łee giiky'aanjik, gaa goovandah hiljii naanaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jyaa nihłagaanyąą, “Nijin dzaa gwats'ą' tr'eedaa dąį', Dęhtły'aa Choh kat geediinaagwaandak gwiizhit łyaa shoo diizhit dha'aii k'it t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","It'ee zhat nineegehjin ts'ą' Jerusalem gwits'eegahoo'oo, izhit t'ee gah vitsyaa 11 nąįį chan ts'ą' ch'izhii nąįį łigiiljil ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","jyaa ginyąą, “Diik'eegwaadhat neegwiindaii t'oonchy'aa. Simon Peter ts'ą' vigwiilkįį!” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ąįįts'ą' t'ee ąįį dinjii neekwaii nąįį gee'al gwiizhit goots'ą' deegwiizhik chan ts'ą' Diik'eegwaadhat łųhchy'aa nihtr'aahnaii jyąhts'ą' juu nilii giiky'aanjik geegoovaagogwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ąįį dinjii neekwaii nąįį jii kwaii geegoovaagwaandak gwiizhit khanhee Diik'eegwaadhat gootee nadhat naanaii ts'ą' jyaa goovahnyąą, “Tsinehdan nakhwaa oolį'!” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Łyaa gihilghaa ts'ą' gąąnjat, ch'anky'aa t'inchy'aa giiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Gaa jyaa goovahnyąą, “Jaghaii noojat ts'ą' jidii datthak geenjit gwik'iinjuhkhit kwaa? ");
INSERT INTO gwiNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Shakwai', shanli' haa nǫh'in ąįįtł'ęę shįį t'ihchy'aa shaakhwahandaii. Tth'an, shatthąį' haa shakat noonjii ji' t'ee gwahǫǫh'yaa, duuyeh ch'anky'aa jyaa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jyaa nyąą ts'ą' danli', dakwai' haa goots'ą' agwaahch'in. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Googaa tth'aii gwik'iinjigiighit kwaa, gaa łi'didlii giiyaandaii haa goozhit shoh dha'aii, ąįįts'ą' Jesus goovahkat, “Dzaa nik'ee tr'ihee'aa khwa'įį?” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Łuk dhichy'aa giiyantł'ahtsit, ");
INSERT INTO gwiNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ts'ą' goovandah iin'al. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ąįįtł'ęę jyaa goovahnyąą, “Tth'aii nakhwaa dhiidii dąį' jii kwaii t'ee geenakhwaagwahaldak, Moses vidęhtły'aa, Vit'eegwijyąhchy'aa Eenjit Ginkhii goodęhtły'aa chan ts'ą' Psalms gwakat deesharaiinyą' datthak gwik'it gweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Dęhtły'aa Choh kat gwigweheetth'ak eenjit t'aih goots'an iłtsąįį, ");
INSERT INTO gwiNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","tł'ęę jyaa goovahnyąą, “Jii t'ee gwadanakhwatł'oo: Christ khaiinjich'iheedhat, ąįįtł'ęę drin tik gweheedhaa ts'ą' neegweheendaii. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Dęhtły'aa Choh kat vitsyaa nąįį giiginjik eech'oohąąhchyaa gwinyąą. Nakhwatr'agwaanduu akhagoiinyąą tł'ęę Vit'eegwijyąhchy'aa neenjit oo'an gweheelyaa. Jerusalem gwizhit tr'ookit jii gwandak gwintł'eegihee'aa ąįįtł'ęę dohju' hee jii nankat dinjii datthak chan. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jidii gǫǫh'ya' łyaa geegohoondak yuu. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ch'anky'aa Shroodiinyąą nakhwats'an hahtsyaa Shiti' diginjik shats'an iłtsąįį haa. Gaa ąįį t'aih yeendaa gwats'an nakhwats'an heelyaa gwats'ą' Jerusalem nagahoo'yaa gwizhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kwaiik'it gwachoo goovaacheehoozhii ts'ą' Bethany kwaiik'it hee goovaanoozhii. Izhit hee ndak nąąhjik ts'ą' gook'aa ginkhe' goovaagweheezyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Gook'aa ginkhii gwiizhit, zheekat gwats'ą' goołeedahoodhat. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Giits'ą' khadigiinjii. Ąįįtł'ęę Jerusalem gwats'ą' shoh goozhit dha'aii ts'ą' geedaa. ");
INSERT INTO gwiNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Izhit hee niighyuk Kharigidiinjii Zhee Gwachoo gwizhit Vit'eegwijyąhchy'aa deegihiił'ee, agahnyąą.");
INSERT INTO gwiNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tr'ookit dąį' gwats'an, Ginjik ch'adąį' hee gwandaii, Vit'eegwijyąhchy'aa haa nilii ts'ą' Vit'eegwijyąhchy'aa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tr'ookit dąį' gwats'an Ginjik, Vit'eegwijyąhchy'aa haa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ginjik k'iighai' Vit'eegwijyąhchy'aa jidii datthak iłtsąįį, ch'ihłak gaa veentak tr'iłtsąįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jidii gwandaii dhidlit kwaii datthak vagwandaii ts'an t'igwiizhik, ąįį vagwandaii t'ee juu nąįį datthak eenjit ch'ahdrii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ąįį vagwandaii t'ee dinjii nąįį eenjit ch'ahdrii nilii, tǫǫ chan duuyeh yąąhkyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Vit'eegwijyąhchy'aa ąįį dinjii John oaazhii jii nankat gwats'ą' hił'e', ");
INSERT INTO gwiNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ąįį dinjii nąįį ts'ą' ąįį Aadrii eegwahaandak eenjit. Juu nąįį datthak jii gaageheendaii ts'ą' gwik'iinjigeheeghit eenjit Ch'aadrii eegavaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Adan ąįį Aadrii t'arahnyąą kwaa; Aadrii eegwahaandak eenjit gwizhrįh ginkhe' t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ąįį Aadrii t'ee łyaa łi'didlii t'arahnyąą, dząą nankat gwats'ą' haazhii ts'ą' juu nąįį datthak ach'ahdrii. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ąįį Ginjik vik'iighai' Vit'eegwijyąhchy'aa nan iłtsąįį, gaa dząą nankat dhidii dąį' dinjii nąįį giiyaandaii kwaa k'it t'iginchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Danahkat gwats'ą' haazhii gaa zhat dinjii nąįį giitr'ii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Goolat nąįį zhrįh eechįį t'ii'in ts'ą' giik'iinjiighit; Vit'eegwijyąhchy'aa vigii giheelyaa eenjit t'aih goots'an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jii dinjii nąįį łyaa giik'iinjiighit, ts'ą' izhit geh'an chan gooneegahoodlit, dagahan akwat digiti' ts'an nakwaa gaa Vit'eegwijyąhchy'aa ts'an gooneegahoodlit ts'ą' Gooti' nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ginjik ąįį dinjii dhidlit ts'ą' diitee gwinch'į', vich'eegwahdrii gwarąąh'ya', ąįįt'ee ch'eet'igwiniindhan ąįįts'ą' łi'didlii haa vizhit deedąą'ąį' nilii. Adan zhrįh Gwiti', Vidinji' nilii geh'an ts'ą' jii ch'eegwahdrii shroodiinyąą vats'an dhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John chųų gwats'an ąhtsii yeeginkhe'. Jyaa yahnyąą, “Jii dinjii eegiihkhii t'ihnyąą, nijin jii jyaa nakhwaiinyą' dąį', ‘Shatąįį k'eeheedik gaa shandaa hil'ee shigweheelyaa gwats'ą' dąį' gwats'an gwandaii geh'an.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Vich'eet'igwiniidhan haa gweedhaa datthak diitee googwąąnchy'aa diits'ą' nizįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Vit'eegwijyąhchy'aa yeenii Moses k'iighai' diineenjit Law intł'eiin'ąįį gaa Jesus Christ ch'eet'igwiniindhan chan ts'ą' łi'didlii haa diitł'eiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dinjii ch'ihłak gaa Vit'eegwijyąhchy'aa dandee haa nah'in kwaa gaa Vidinji' Jesus Christ zhrįh yaa nilii ts'ą' yeediinaagwildak. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jews khaihkwaii nąįį, digigiinkhii chan ts'ą' Levite nąįį haa John ts'ą' googihił'e', jii giiyųąhkat eenjit “Juu inlii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Zhazhat John nagwąąh'įį kwaa ts'ą' gwinzii gavaagwildak, “Christ t'ihchy'aa kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Juu inlii gǫ', Elijah inlii?” giiyahnyąą. “Nakwaa, ąįį t'ihchy'aa kwaa.” John nyąą. “Vit'eegwijyąhchy'aa Eenjit Ginkhii inlii?” giiyahnyąą “Nakwaa,” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Juu inlii diinaa gwandak, juu naroohaahkat eenjit diihił'e' nąįį gavaa gwarahaandak eenjit. Juu inlii?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John jyaa gavahnyąą, “Jidii ihłii nakhwaa gwahaldak: ‘Shįį t'ee oo'at nangwinjir gwa'an ihshral ts'ą' jyaa diinyą' Diik'eegwaadhat tąįį gwinjik veenjit k'igwąą'ee nagoh'ąįį!’” (Jii t'ee Isaiah, Vit'eegwijyąhchy'aa Eenjit Ginkhii yadaantł'oo) ");
INSERT INTO gwiNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Pharisee nąįį juu gihił'e' nąįį John goahkat, “Christ inlii kwaa akwat Elijah chan inlii kwaa, akwat Vit'eegwijyąhchy'aa Eenjit Ginkhii inlii kwaa. Gwiizhit jaghaii chųų gwats'an ąhtsii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John jyaa gavahnyąą “Chųų gwats'an ałtsii; gaa nakhwatee dinjii vaakhwandaii kwaa nadhat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Shatąįį k'eeheedik, gaa vakwaiitryaa dineehałchaa eenjit gaa hool'ee kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jii t'igwiizhik t'ee Bethany kwaiik'it gwizhit t'igwiizhik Jordan han gwinjik ndųhts'ąįį, nijin John chųų gwats'an ąhtsii izhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Gęhdaa drin John ąįį Jesus yats'ą' ahaa niił'in ts'ą' jyaa nyąą, “Jii t'ee Vit'eegwijyąhchy'aa Vidivii Gii tsal t'inchy'aa. Jii nankat gwatr'agwaanduu oo'an gwihilii t'inchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jii dinjii eegiihkhii t'ihnyąą, nijin jii nakhwaagwaldak dąį', ‘Dinjii shatąįį k'eeheedik gaa shandaa hil'ee, shigweheelyaa gwats'ą' dąį' gwats'an gwandaii geh'an.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Shįį gaa juu t'inchy'aa vaashandaii kwaa, gaa Israel gwich'in nąįį yaaheendaii eenjit vats'an chųų dhałtsąįį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jii t'ee John jyaa diinyą': “Dove chiitsal daagąįį zheekat gwats'an yakat needaanąįį gwik'it Ch'anky'aa Shroodiinyąą yakat needaanąįį ts'ą' yaa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tth'aii nihk'it vaashandaii kwaa, gaa Vit'eegwijyąhchy'aa chųų gwats'an hałtsyaa eenjit shihił'e' ąįį jyaa shaiinyą', ‘Ch'anky'aa Shroodiinyąą dinjii kat needahąądhal; ąįįts'ą' ąįį dinjii t'ee Ch'anky'aa Shroodiinyąą haa chųų gwats'an hahtsyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jii gwał'ya' t'ihnyąą,” John gavahnyąą, “Jii dinjii łi'haa Vit'eegwijyąhchy'aa Vidinji' t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Gęhdaa drin chan hee zhat John, ditsyaa neekwaii haa zhat nigiilzhii, ");
INSERT INTO gwiNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nijin Jesus gehgoo ahaa nah'in dąį', “Jii t'ee Vit'eegwijyąhchy'aa Vidivii Giitsal t'inchy'aa!” John goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ąįį vitsyaa neekwaii jyaa nyąą giiyiitth'ak ts'ą' Jesus haa gahaa'oo. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus neediil'ee ts'ą' giitąįį adaa gwąąh'in ts'ą' gavaahkat, “Jidii keegǫh'in t'akhwa'in?” “Geech'ǫąąhtan, nijin gwinch'įį?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Aanaii, gahǫǫh'yaa,” gavahnyąą. Ąįįts'ą' t'ee giiyaahaa'oo ts'ą' nijin gwich'įį googwąąh'ya' ts'ą' giiyaaniihaa (khaa gwilii geh'an). ");
INSERT INTO gwiNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrew, John deiinyą' gwiitth'ak ąįįtł'ęę Jesus haa haazhii. (Simon Peter voondee nilii.) ");
INSERT INTO gwiNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrew łyaa khan doondee Simon kantii ts'ą' yagwąh'ąįį Googwahkhan jyaa yahnyąą, “Messiah vagwarąh'ąįį!” (Greek ginjik t'ee Christ t'agahnyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ąįįts'ą' t'ee Simon ąįį Jesus ts'ą' hiłchįį. Jesus yąąh'in ts'ą' jyaa yahnyąą, “Simon, nan John vidinji', noozhri' Cephas oohaazhyaa.” (Peter gwinyąą t'igwinyąą, “kii” chan ginyąą t'igwinyąą). ");
INSERT INTO gwiNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Gęhdaa drin Jesus Galilee nahkat gwats'ą' heekhaa nigwiin'ąįį. Philip agwąh'ąįį ts'ą' jyaa yahnyąą, “Shaa hinkhaii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip t'ee Bethsaida kwaiik'it gwats'an ahaa, nijin Andrew chan ts'ą' Peter haa gwigwich'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip ąįį Nathaniel agwąh'ąįį ts'ą' jyaa yahnyąą, “Moses va-law dęhtły'aa kat yeeginkhe' akwat Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį dęhtły'aa kat jyąhts'ą' gwadagaantł'oo. Jesus t'inchy'aa, Nazareth gwats'an Joseph ąįį vigii nilii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","“Nazareth nijin ji' gweheezyaa li'?” Nathaniel nyąą “Aanaii ts'ą' gwąąh'in,” Philip yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nijin Jesus ąįį Nathaniel yats'ą' ahaa gwąąh'in dąį', jyaa yahnyąą, “Jii t'ee łyaa Israel gwich'in nilii, dinjii łi'didlii nilii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathaniel yuahkat, “Nats'ąą shaanandaii?” Jesus jyaa yahnyąą, “Philip nagwahah'aa gwats'ą' dąį' ts'iivii vakat Figs nahshii t'eh dhindii naał'ya'!” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Geech'ǫąąhtan, Vit'eegwijyąhchy'aa Vidinji' t'iinchy'aa łee Israel gwi-King t'iinchy'aa łee!” Nathaniel yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus jyaa yahnyąą, “Ts'iivii vakat Figs nahshii t'eh dhindii naał'ya' naiinyą' geh'an gwizhrįh gwik'iinjinghit? Jii kwaii andaa ts'ą' gwihil'ee t'igwii'in gwahąąh'yaa t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ąįįts'ą' jyaa gavahnyąą, “Jii t'ee łi'didlii haa nakhwaa gwahaldak: zheekat nihky'aa t'igweheenjyaa gahǫǫh'yaa ts'ą' Vit'eegwijyąhchy'aa zheekat gwich'in nąįį k'iidak, k'iidąą haa Gwidinji' ts'ą' nigiheedaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Galilee nahkat gwizhit Cana kwaiik'it goo'aii, zhat Jesus vahan dhidii, izhit drin tik gwiindhat ąįįtł'ęę zhat nihłeegwirihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ąįįts'ą' Jesus chan ts'ą' ditsyaa nąįį haa geedan chan zhat nihłeegwirihiłchįį aanaii googahnyąą ts'ą' gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nijin jak chų' datthak geenį' dąį', Jesus vahan t'iiyahnyąą, “Jak chų' gavaanaanįį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","“Ni'ęę, jyaa dini'in shahaiinjyaa kwaa goo'aii t'oonchy'aa. Zhat tth'aii shaa nigwiighit kwaa.” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesus vahan ąįį juu zhat yeenjit tr'agwah'in nąįį jyaa ahnyąą, “Deenakhwahnyąą gwik'it t'akhwa'in.” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Izhit geeghaih chųų eenjit kii tyah choh nihk'iitik dhidlii, (ch'ihłak gaa 20 akwat 30 gallon ootą'). Jews nąįį shragoodiinyąą neegeheelyaa eenjit dik'eech'agahtryaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus ąįį juu zhat gwitr'it t'agwah'in nąįį t'ahnyąą, “Jii tyah kwaii chųų vizhit deedoohjyaa.” Chųų vizhit deedąą'ąį' giiyiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ąįįtł'ęę jyaa gavahnyąą, “Et'ee valat khanohjyaa ts'ą' zhit juu gach'ah'aa ąįį vats'ą' hohkaii.” Giits'ą' yahaakaii, ");
INSERT INTO gwiNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ts'ą' yaalaii, ąįį chųų t'ee jak chų' dhidlit. Ąįį jak chų' nijin gwats'an t'inchy'aa yaandaii kwaa gaa zhit juu yeetr'agwah'in nąįį gaagiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ąįį juu veegwarąhchįį jyaa ahnyąą, “Lęįį nąįį jak chų' ch'andaa nizįį tr'ookit gagahnįį ąįį datthak giinjik ąįįtł'ęę jak chų' daatł'oo kwaa gagahnįį. Gaa nan ąįį ndaagwąą'ąį' dohju' hee jak chų' nizįį juk gąhnįį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus jii tr'ookit gwitr'it gwihil'ee t'iizhik Cana kwaiik'it, Galilee nahkat gwizhit. Izhit t'ee dich'eegwahdrii gwizhrįh nigwiin'ąįį, ts'ą' vitsyaa nąįį giik'iinjiighit. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jii jyaa digwiizhik ąįįtł'ęę Jesus, dahan ditsyaa dachaa nąįį haa Capernaum kwaiik'it gwats'ą' gahaajil ts'ą' zhat drin nitsya' gaak'į'. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","It'ee khaiinjii Jews nąįį eenjit Passover nigwiindhat ąįįts'ą' Jesus Jerusalem gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Kharigidiinjii zheh gwachoh gookwantee nihdeegweedii gwizhit dinjii nąįį aak'ii, divii chan ts'ą' chiitsal kwaii t'įį laraa gihilii gwąąh'in, ąįįts'ą' zhit juu ch'adanh gwalaraa ookwat nąįį chan vakaii'aa, ts'ą' dilk'ii nah'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ąįįts'ą' zhat gwa'an tły'ah haa viitrii iłtsąįį haa Kharigidiinjii Zheh Gwachoh gwizhit gwats'an divii, aak'ii haa cheehaanzhit; ąįį ch'adanh gwalaraa ookwat nąįį vakaii'aa ts'ą' giilk'ii izhit vakaii'aa khatąąnahjil ts'ą' goolaraa datthak neiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ąįį juu dziitsal dove laraa t'įį hilii nąįį jyaa ahnyąą, “Juk zhat cheegavahohłii! Jii Shiti' vizheh ch'ookwat zheh goo'įį kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Vitsyaa nąįį Dęhtły'aa Choh kat jii, jyaa digwinyąą gineegaandaii, “Nizheh gwachoh łyaa tr'ihkhit geenjit yinjiihooł'ee ts'ą' ąįį geenjit shrii tr'igwirehee'aa!” gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Izhit zhat Jews kįh dilk'ii nąįį jii giiyųąhkat, “Vit'eegwijyąhchy'aa vats'an ni'in ji', diinandah geegwaroolii kwaa t'ini'in lee.” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus jyaa gavahnyąą, “Jii kharigidiinjii zheh an goodlit ji' drin tik ts'ą' ndak nineegwahałtsyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Drin tik ąįįtł'ęę ndak nineegwahahtsyaa? Jii Kharigidiinjii Zheh Gwachoh łyaa 46 years gwahaadhat ąįįtł'ęę dohju' hee gęhdaa tr'igiinjik t'oonchy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gaa Jesus ąįį zhit kharigidiinjii zheh geeginkhii dąį' adan ideeginkhii t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nijin niindhat ąįįtł'ęę vineegwiindaii dąį' vitsyaa nąįį jii deenyąą chy'aa giinaandaii. Jesus deiinyą' akwat Dęhtły'aa Choh kat deegwinyąą datthak gwik'iinjigiighit gaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Passover ch'ara'aa gwizhit (Jesus Jerusalem dhidii) gweedhaa dąį', geegwaroolii kwaa gwinlęįį t'iizhik giiyąąh'ya' ts'ą' giik'iinjiighit. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gaa Jesus gootr'oahnyąą, dinjii datthak goovaandaii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Dinjii eevaaragwaandak gwat'aahchy'aa kwaa ch'adąį' hee goodrii zhit t'oonchy'aa gavaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Izhit dąį' Jews khaihkwaii tee gwa'an dinjii Nicodemus oaazhii dhidii, Pharisees chan nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ch'ihłan khaa Jesus eenihkhee ts'ą' yuahkat, “Geech'ǫąąhtan, Vit'eegwijyąhchy'aa eenjit geech'ǫąąhtan eenjit nihił'e' naagwiindaii. Ch'ihłak gaa duuyeh Vit'eegwijyąhchy'aa vehdan geegwaroolii kwaa t'ii'in vaagwiindaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus jyaa yahnyąą, “Łi'didlii haa naagwahaaldak, dinjii chan vineegahoodlit ji' gwizhrįh K'eegwaadhat Veegwinii'ee gwahąąh'yaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus jyaa yahnyąą, “Dinjii vaghaii lęįį gwiizhit nats'ąą vineegweheelyaa t'iinyąą? Duuyeh dahan zhit nidii ts'ą' chan vineegwiilii t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus jyaa yahnyąą, “Łi'didlii haa naagwahaaldak, dinjii chųų akwat Ch'anky'aa Shroodiinyąą haa vagoodlit ji' gwizhrįh K'eegwaadhat Veegwinii'ee nihdeeheehaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Dinjii ąįį dinjii ts'an vigwilik, gaa dinjii Ch'anky'aa Shroodiinyąą chan vigwilik, Vit'eegwijyąhchy'aa ts'an nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","‘Chan nineegweheelyaa,’ nakhwaihnyąą ąįį łyaa t'igwinyąą eenjit gwik'iinjuhkhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ahtr'aii dąį' nijuk ohtr'aii niindhan datthak gwik'it ahtr'aii dohtth'ak gaa nijin gwats'an akwat nijin gwats'ą' t'inyąą vaanandaii kwaa. Ąįį juu Ch'anky'aa Shroodiinyąą haa vigwilik gwik'it t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“Jii nats'ąą t'agwaiinyąą,” Nicodemus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus jyaa yahnyąą, “Israel gwizhit łyaa geech'ǫąąhtan hil'ee inlii gwiizhit jii geenjit gaanandaii kwaa? ");
INSERT INTO gwiNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Łi'didlii haa naagwahaaldak, jidii gaagwiindaii gwizhrįh geegirinkhii, jidii gwarąąh'ya' gwizhrįh chan geegirinkhii googaa nakhwatee ch'ihłak gaa shik'iinjiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Dząą nijin nankat t'igwii'in geenaagwaldak dąį' shik'iinjiinghit kwaa; akwat zheekat geenaagwaldak ji' izhit chan shik'iinjihįįnghit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ąįįts'ą' ch'ihłak gaa zheekat gwats'ą' haazhii ts'ą' oodaa nidii kwaa, Gwidinji' zhrįh jyaa diizhik.” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Deenaadąį' Moses nangwinjir gwa'an gwandah gyųų choh dachan kat diłchaa, izhit gwik'it Gwidinji' cross kat ndak tr'ihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Juu gik'iinjiighit nąįį khit gwigweheendaii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Vit'eegwijyąhchy'aa łyaa dinjii datthak eet'iindhan geenjit it'ee zhrįh Didinji' gwantł'ąhchįį, ąįįts'ą' juu yik'injiighit nąįį nigiheedhaa kwaa ts'ą' khit gwigweheendaii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Vit'eegwijyąhchy'aa Didinji' nankat dinjii an hahtsyaa eenjit gwats'ą' hił'e' kwaa gaa dinjii neehahshii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Juu Gwidinji' k'injiighit duuyeh an ilii; gaa juu gwik'iinjiighit kwaa ąįįt'ee ch'adąį' an dhidlit, Vit'eegwijyąhchy'aa et'ee zhrįh Vidinji' k'injiighit kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jii t'ee jyąhts'ą' dinjii an heelyaa t'agwarahnyąą: Jii nankat datthak k'ąą adrii gwilii, gaa dinjii nąįį tǫǫ ąįį geet'igiindhan, ąįį googwitr'it gwiizųų geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ąįį juu vigwitr'it gwiizųų nąįį ch'aadrii itr'igii'ee ts'ą' duuyeh ch'aadrii zhit ga'oo, vigwitr'it gwiizųų ąįį gwizhrįh nagwa'aii gitr'ii'ee geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gaa zhit juu vigwitr'it gwinzii nąįį shoo haa ch'aadrii zhit ga'oo, dee'in ąįį Vit'eegwijyąhchy'aa k'iighai' t'ii'in gwigweheechy'aa eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jii ąįįtł'ęę, Jesus ditsyaa nąįį haa Judea nahkat gwats'ą' gahaajil. Zhat ch'ihłee gwizhrįh gavaa iindi' ts'ą' lęįį nąįį chųų ts'an dhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aenon gwizhit John chųų gwats'an ąhtsii, Aenon t'ee Salim geeghaih goo'aii ts'ą' zhat gwizhrįh chųų gwanlii. Lęįį nąįį chųų goots'an tr'ahahtsyaa eenjit yeenineedal. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Zhat dąį' John tth'aii zheegwaazhrąįį nigiiyąąhchįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jews nąįį tee gwats'an dinjii ch'ihłak ąįį John vitsyaa nąįį haa gwantł'oo shroogogoonyąą eenjit giiyaa nihzheedagąąn'ee. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","John ts'ą' nigiinjil ts'ą' jyaa giiyahnyąą, “Geech'ǫąąhtan, dinjii Jordan han gwinjik ndųhts'ąįį, naa indi' ts'ą' veeginkhe', vanandaii? Juk chųų gwats'an ąhtsii ts'ą' juu nąįį datthak yats'ą' hijyaa t'arahnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John jyaa gavahnyąą, “Zheekat gwats'an jidii gwitr'it diinantł'eegwariin'ąįį zhrįh eenjit gwitr'it gwarahąąh'yaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nakhwandah jii jyaa diinyą' ganoondaii, ‘Christ t'ihchy'aa kwaa gaa shįį tr'ookit vits'ii shirihił'e'.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Zhit juu veegwarąhchįį t'ee da'at ts'anyahaa'yaa. Ąįį juu veegwarąhchįį vijyaa veeghaii nadhat ts'ą' yinkeech'oołk'įį, yideezhuh diitth'ak dąį' shoh ilik. Jyąhts'ą' t'ee shįį chan shoo'ihłik, gwitr'it shintł'eegwiriin'ąįį gęhdaa tr'iinjik geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Adan nitsii heelyaa, shįį ąįį jyaa deegwahtł'oo sheegwehee'aa kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Zheekat gwats'an ahaa ts'ą' juu nąįį datthak andaa hil'ee. Juu nankat gwats'an ahaa chan nankat gwats'an nilii ts'ą' nankat gwiky'aa gwizhrįh ginkhii. Juu zheekat gwats'an ahaa t'ee juu nąįį datthak ęhdak dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jidii gwaak'įį akwat gwąąh'ya' haa eegwaandak. Ch'ihłak gaa yiginjik k'injiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Dinjii yiginjik k'eegwahthat t'ee łi'didlii nilii giiky'aandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Juu hił'e' t'ee Vit'eegwijyąhchy'aa viginjik eegwaandak t'oonchy'aa, Vit'eegwijyąhchy'aa ąįį deegwahtł'oo Ch'anky'aa Shroodiinyąą hahtsyaa gwik'it yats'an iłtsąįį geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gwiti' łyaa Didinji' eet'iindhan ts'ą' jidii datthak yantł'eegwiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Juu Gwidinji' k'injiighit t'ee khit gweheendaii. Juu Gwidinji' viginjik k'it t'ii'in kwaa t'ee duuyeh khit gwandaii, gaa khit geenjit Vit'eegwijyąhchy'aa yagwahąąhshii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Zhat dąį' Jesus ąįį John andaa ts'ą' vitsyaa nąįį gwilii ts'ą' datthak chųų goots'an ąhtsii gwinyąą ąįį Pharisee nąįį gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesus ąįį chųų gwats'an ąhtsii kwaa gaa vitsyaa nąįį t'ii'in ąįį t'agoogwahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jesus nijin jyaa digwinyąą gwiitth'ak dąį', Judea nahkat gihłeehoozhii ts'ą' Galilee nahkat gwits'eehoozhii, ");
INSERT INTO gwiNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria nahkat t'ee, Galilee gwats'ą' hee goo'aii ts'ą' zhat gehgoo haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jesus Samaria nahkat gwizhit kwaiik'it Sychar goozhii k'idik. Deenaadąį' izhit geeghaih t'ee Jacob didinji' Joseph nan intł'eiin'ąįį goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Izhit t'ee Jacob vichųų deek'it goo'aii ąįįts'ą' Jesus niighyuk niinzhii ts'ą' cheendak ts'ą' zhat chųų tr'oonjii deek'it eeghaii naadii. Drin tł'an gweedhaa gwiizhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria gwats'an tr'injaa zhat chųų hoondal eenjit k'idik ts'ą' Jesus jyaa yahnyąą, “Chųų shintł'eiinkaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Vitsyaa nąįį kwaiik'it shih gooheekwat eenjit nigijyaa gwiizhit.) ");
INSERT INTO gwiNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ąįį tr'injaa jyaa yahnyąą, “Jews nąįį tee gwats'an iinlii, shįį ąįį Samaria gwats'an ihłii, jaghaii chųų shaiinyąą t'iinyąą?” (Jews nąįį duuyeh gaa Samaria gwich'in nąįį k'it zhit ch'aga'aa). ");
INSERT INTO gwiNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus jyaa yahnyąą, “Vit'eegwijyąhchy'aa jidii neenjit di'įį gaanandaii akwat juu ihłii shaanandaii ji', oohaahkat ts'ą' chųų gwandaii nintł'eeheekaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ąįį tr'injaa jyaa yahnyąą, “Tyah ni'įį kwaa, nanzhit k'iizhak chųų ts'ą' niighit. Nijin chųų gwandaii oohiindal t'iinyąą? ");
INSERT INTO gwiNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Yeenii diilak Jacob jii chųų deek'it diinantł'eegwiin'ąįį; adan, didinji', dinin nąįį haa datthak gwats'an chųų geenį'. Jacob vandaa neegoo'aii yiindhan lee t'iinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus jyaa yahnyąą, “Juu dząą chųų eenį' t'ee chan hee chųų haał'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gaa juu chųų vintł'eiinkaii duuyeh chan chųų dahłįį neelii. Ąįį chųų vintł'eehihkaa ąįį vizhit han gwinjik chųų ninlaii k'it t'inchy'aa ts'ą' khit yaa gweheendaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ąįį tr'injaa jyaa nyąą, “Jii chųų t'avaiinyąą shintł'eiinkaii! Ąįį ji' chan chųų haał'yaa kwaa, akwat chan dząą chųų kaneehihdyaa kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus jyaa yahnyąą, “Oo'an neehindii ts'ą' nakąį', oo'ee nąąhchįį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ąįį tr'injaa jyaa yahnyąą, “Shakąį' kwaa t'oonchy'aa.” Jesus jyaa nyąą, “Nakąį' kwaa diinyąą dąį' łyaa t'iinyąą łee. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Nakąį' ch'ihłoanli' gwiinli', juk ąįį dinjii vaagwinch'įį nakąį' t'inchy'aa kwaa. Łi'didlii haa shaagwadhandak.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ąįį tr'injaa jyaa yahnyąą, “Vit'eegwijyąhchy'aa Eenjit Ginkhii inlii łee. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Yeenii diilak nąįį jii ddhah kat Vit'eegwijyąhchy'aa deegihiił'e' gaa nakhwan Jews ąįį Jerusalem gwizhit Vit'eegwijyąhchy'aa deerahǫh'e' diinoohnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus jyaa yahnyąą, “Jii ddhah kat akwat Jerusalem gwizhit dinjii nąįį Vit'eegwijyąhchy'aa deegahah'aa kwaa nigweheedhaa ąįį łyaa t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria gwich'in ǫhłįį ts'ą' juu vats'ą' khadagohjii gaakhwandaii kwaa. Diikhwan Jews gwich'in tr'iinlii ts'ą' juu vats'ą' khadigariinjii gaagwiindaii, Israel gwich'in nąįį k'iighai' neehohshii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Gaa it'ee zhat nigwiighit, juk t'ee łyaa gwik'iinjiighit nąįį digiyinji' zhit łi'didlii haa Gwiti' ts'ą' khadigigiinjii. Ąįį gik'iinjiighit k'it t'inchy'aa t'ee Gwiti' keehi'ik t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Vit'eegwijyąhchy'aa t'ee Ch'anky'aa nilii, ts'ą' juu yats'ą' khadigiinjii t'ee digiyinji' zhit łi'didlii haa giits'ą' khadigiheejyaa goo'aii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ąįį tr'injaa jyaa yahnyąą, “Messiah ąįį Christ oozhii ahaa ts'ą' gaashandaii nijin k'idik ji' jidii datthak eediinaagwahaandak vaashandaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus jyaa yahnyąą, “Shįį nats'ą' ginkhii t'ee adan t'ihchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Izhit gwiizhit Jesus vitsyaa nąįį oo'ee neegiijil; tr'injaa ts'ą' ginkhii giiky'aanjik dąį' deegiheenjyaa gaa gaagiindaii kwaa. Gootee ch'ihłak gaa ąįį tr'injaa jyaa ahnyąą kwaa, “Jidii yiindhan?” akwat Jesus chan jii agaahkat kwaa, “Jaghaii jii tr'injaa vats'ą' ginkhii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ąįįtł'ęę ąįį tr'injaa zhat dityaa akhoonyąą ts'ą' kwaiik'it gwits'eehoozhii ts'ą' zhat nąįį jyaa ahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Aanaii ts'ą' jii dinjii yeenii deeshi'yaa datthak geeneeshaagwaandak nǫh'in. Jii dinjii lee Christ t'inchy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ąįįts'ą' t'ee zhat datthak ąįį kwaiik'it chagahaajil ts'ą' Jesus ts'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Izhit gwiizhit vitsyaa nąįį yaandeegwii'ąįį ts'ą' jyaa giiyahnyąą, “Geech'ǫąąhtan, gwintsal ch'in'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gaa jyaa gavahnyąą, “Shih shi'įį ąįį vaakhwandaii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ąįįts'ą' vitsyaa nąįį jyaa nihłagaanyąą, “Juu shih yats'ą' hiłtsit t'inyąą li'?” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus gavahnyąą, “Ąįį juu shihił'e' vik'it t'ooshi'ya' shoonyąą ąįį vigwitr'it t'agwahał'ya' gwizhrįh goo'aii ąįįt'ee shishii k'it t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jii jyaa dohnyąą chy'aa ganoondaii, ‘Shree drin dǫǫ ts'ą' gwanzhįh khareheelyaa.’ Nakhwaagwahaldak, gwanzhįh deek'it gwinzii gooh'in; gwanzhįh khareheelyaa eenjit et'ee nizįį! ");
INSERT INTO gwiNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ąįį juu gwanzhįh dehk'it gwitr'it t'agwah'in t'ee vagwarookwat, ąįįts'ą' zhit gwanzhįh khaihłan nilii t'ee khit gwarandaii eenjit khaihłan niyilii t'ii'in. Ąįįts'ą' zhit juu gwiiłshįį ts'ą' juu khaihłan niyilii haa nihłaa shoo geelyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jii t'ee łyaa t'igwinyąą, ‘Dinjii ch'ihłak gwąąhshii, dinjii ch'ihłak gwanzhįh khaihłan nilii.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Gwanzhįh deek'it gwehkįį tr'agoh'in kwaa izhit gwanzhįh khaihłan nohohłyaa eenjit gwats'ą' nakhwahooł'e'. Ch'izhii nąįį zhat tr'agwah'ya' gaa nakhwan ąįį gwanzhįh nakhwats'an dhidlit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Izhit kwaiik'it gwizhit, Samaria gwich'in lęįį nąįį Jesus k'iinjigiighit, ąįį tr'injaa jii jyaa nyąą geh'an, “Yeenii deeshi'ya' datthak geeneeshaagwaandak.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ąįįts'ą' nijin Samaria gwich'in nąįį giits'ą' haajil dąį' diinaa dhiindii giiyahnyąą, ąįįts'ą' t'ee Jesus zhat drin neekwaii gavaa iindi'. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Deegavaiinyą' eenjit lęįį nąįį giik'iinjiighit dhidlit ");
INSERT INTO gwiNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ts'ą' ąįį tr'injaa jyaa agahnyąą, “Juk et'ee vik'injiriindhat, deediinaiinyą' eenjit kwaa gaa diikhwan chan diits'ą' ginkhe', ts'ą' jii nankat datthak dinjii neehahshii nilii et'ee vaagwiindaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Drin neekwaii zhat naakhaa ąįįtł'ęę Jesus neehoozhii ts'ą' Galilee gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jii t'ee Jesus gwehkįį jyaa diinyą'. “Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį daganahkat gwa'an gooveenjit yinjigihił'ee kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nijin Galilee k'idik dąį', giiyeenjit shoo dhidlit, Jerusalem gwizhit Passover gwiinli' dąį' ch'aga'aa gwiizhit deezhik datthak giiyąąh'ya' geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ąįįts'ą' Jesus Galilee nahkat gwizhit Cana kwaiik'it gwits'eehoozhii, izhit t'ee chųų ąįį jak chų' iłtsąįį. Izhit gwats'ą' k'eegwaadhat vidinji' Capernaum kwaiik'it gwizhit iłts'ik. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nijin ąįį dinjii Jesus Judea nahkat gwats'an Galilee gwats'ą' haazhii gwinyąą gwiitth'ak dąį', yats'ą' haazhii ts'ą' Capernaum gwats'ą' shaa hinkhaii, shidinji' veenjit gwinzii neegwąhtsii yahnyąą, ąįį vidinji' t'ee niheedhaa nigwiindhat. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus jyaa yahnyąą, “Gwitr'it geegwaroolii kwaa nakhwandah t'igwiizhik kwaa ji', nakhwatee ch'ihłak gaa duuyeh gwik'iinjiighit ilii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ąįį nahkat gwats'ą' k'eegwaadhat jyaa yahnyąą, “Shigii niheedhaa gwehkįį shaa hinkhaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus jyaa yahnyąą, “Oo'an neehindii, nidinji' gweheendaii t'inchy'aa!” Ąįį dinjii Jesus viginjik k'iinjindhat ts'ą' oo'an neehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Dizheh gwats'ą' needyaa gwiizhit zhit juu yeetr'agwah'in nąįį gwandak haa giidąąjil, “Nichyaatsal gweheendaii t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nijin nigwiindhat dąį' vidinji' veenjit gwinzii neegahoodlit eenjit gavoahkat, ts'ą' jyaa giiyahnyąą, “K'ehdąį' drintł'an ęhdaa tr'igwiindhat dąį' ts'ik niindhaa di'įį kwaa dhidlit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Izhit nigwiindhat dąį' Jesus jii jyaa yahnyąą chy'aa ganaanjik, “Nidinji' gweheendaii t'inchy'aa.” Ąįį dinjii dizhehk'ąą haa datthak gwik'iinjigiighit gaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus Judea gwats'an Galilee gwats'ą' haazhii dąį' jii gwitr'it gwihil'ee t'iizhik t'ee neekwat gwizhrįh t'iizhik t'avarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jii ąįįtł'ęę Jerusalem gwizhit Israel nąįį ch'ara'aa googwahtsii izhit Jesus gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Izhit divii deek'it goo'aii geeghaih chųų dhakaii goo'aii, ąįį eelin zheh gwatsal ch'ihłoanli' goodlii; Hebrew ginjik zhit Bethzatha goozhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ąįį zheh gwadąįį gwizhit iłts'ik lęįį nąįį k'igilt'aii, vandee kwaa, neehidik kwaa akwat vatthąį' iłchįį nąįį. (Chųų hee tł'ak eenjit nagogwal'in; ");
INSERT INTO gwiNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","neegwiidhak hee K'eegwaadhat vizheekat gwich'in chųų zhit neediidhak ts'ą' chųų atł'ak gwahtsii. Juu tr'ookit iłts'ik chųų atł'ak zhit gwizhyahkhat t'ee veenjit gwinzii neegwiilik.). ");
INSERT INTO gwiNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Izhit dinjii ch'ihłak dhidii, 38 years łąą iłts'ik. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus zhat k'ilt'aii niyiił'in ts'ą' niighyuk iłts'ik yaandaii; ts'ą' jyaa yahnyąą, “Sheenjit gwinzii neegooli' niindhan?” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ąįį dinjii jyaa nyąą, “Juu chųų zhit shahahchyaa gaashandaii kwaa; chųų atł'ak dąį' gwizhit hihshyaa gwik'eegwihdaii gwiizhit sharahtee dinjii gwizhyahkhat geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus jyaa yahnyąą, “Ndak niindhat, nichyah oiinjii ts'ą' inkhaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Izhit zhat ąįį dinjii veenjit gwinzii neekhwadlit gwagwahkhan dichyah oonjik ts'ą' ahaa (tr'iinzhii). Izhit Neegwaazhii Drin goo'aii, ");
INSERT INTO gwiNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ts'ą' Israel kįh dilk'ii nąįį ąįį dinjii shranaazhik jyaa agahnyąą, “Juk Neegwaazhii Drin t'oonchy'aa, dii-law zhit nichyah k'eehin'ak kwaa goo'aii gwinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jyaa gavahnyąą, “Ąįį dinjii sheenjit gwinzii neegwiłtsąįį jyaa shaiinyą', ‘Nichyah oiinjii ts'ą' inkhaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jii giiyųąhkat, “Jii dinjii nichyah oiinjii ts'ą' inkhaa nahnyąą ąįį juu t'inchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Gaa ąįį dinjii shranaazhik ąįį juu t'inchy'aa yaandaii kwaa, tr'ihkhit dinjii gwanlii tee gwa'an gwiteiinzhii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ąįįtł'ęę gwandaa Jesus ąįį Kharigidiinjii Zheh Gwachoh gookwantee gwizhit yats'ą' tr'ineezhii ts'ą' jyaa yahnyąą, “Et'ee neenjit gwinzii akwat natr'agwaanduu akhagoiinyąą, ąįį akwaa ji' gwandaa nidivee gwiizųų gweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ąįį dinjii ąįį Jews kįh dilk'ii nąįį ts'ą' haazhii ts'ą' Jesus oozhii ąįį yats'ą' tr'iinjik gavaa gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Izhit gwats'an t'ee Jews kįh dilk'ii nąįį Jesus tr'ookhwaa giindhan, Neegwaazhii Drin dinjii shrineiinlik geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesus jyaa gavahnyąą, “Shiti' khit gwitr'it t'agwah'in, ąįįts'ą' shįį chan gwitr'it t'agwał'in gwat'aałchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jii jyaa diinyą' gwats'an t'ee łyaa geenjit tr'ookhwaa giiyuunyąą. Neegwaazhii Drin gwa-law łeełnaii gwizhrįh geenjit nakwaa gaa Vit'eegwijyąhchy'aa Shiti' nyąą ts'ą' jyąhts'ą' Vit'eegwijyąhchy'aa vagwahtsii veegoo'aii k'it t'inchy'aa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ąįįts'ą' Jesus jyaa gavahnyąą: “Łi'didlii haa nakhwaa gwahaldak, Gwidinji' duuyeh adakhai' k'eegwiichy'aa t'ii'in, Viti' dee'in gwąąh'in izhit gwizhrįh gwik'it t'ii'in. Gwiti' dee'in, Gwidinji' chan gwik'it t'ii'in t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Gwiti', Didinji' eet'iindhan ts'ą' dee'in datthak yats'ą' googwaahch'in. Jii dinjii shrineiinlik ąįį gwandaa yats'ą' googwahahchy'aa t'avarahnyąą ts'ą' geegwaroolii kwaa lęįį nakhwandaa t'ihee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Gwiti', dinjii niindhat nąįį ineegwahdaii. Izhit gwik'it Gwidinji' chan juu niindhan nąįį gwandaii intł'ineehee'aa t'avarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Gwiti' adan zhrįh dinjii eenjit k'eegwaadhat kwaa t'inchy'aa. Gaa Didinji' chan dinjii datthak eenjit k'eegwaadhat eenjit gwiłtsąįį, ");
INSERT INTO gwiNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Gwiti' deegwiłtł'oo tr'ihił'ee gwik'it Gwidinji' chan tr'ahah'aa eenjit. Juu Gwidinji' hił'ee kwaa t'ee Gwiti' yihił'e' ąįį chan hił'ee kwaa t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Jii t'ee łi'didlii nakhwaa gwahaldak: Juu shiginjik diitth'ak ts'ą' juu shihił'e' k'injiighit ąįįt'ee gwandaii ndaanąą'ąį' kwaa hee'yaa. Ch'adąį' hee niindhat gwats'an neegwiindaii geh'an Ch'aroahkat Drin zhit ji' duuyeh an ilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jii t'ee łi'didlii nakhwaa gwahaldak: khaiinjii zhat nigwiindhat, ch'adąį' hee zhat nigwiindhat, zhit juu niindhat nąįį Vit'eegwijyąhchy'aa Vidinji' giheetth'ak ts'ą' juu yiitth'ak gweheendaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Gwiti' dinjii ineegwahdaii eenjit t'aih dii'įį, izhit gwik'it Vidinji' chan dinjii ineegwahahdaii eenjit t'aih intł'eiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ąįįts'ą' Vidinji' ąįį dinjii ts'ą' k'eegwahaadhat eenjit t'aih yintł'eiin'ąįį, Gwidinji' nilii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jii nakhwarahtee t'agǫǫnjyaa shrǫ'; zhat nigwiighit juu tth'ank'it gwizhit niindhat nąįį datthak nijin giiyeheetth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nijin giiyiitth'ak ji' t'ee tth'ank'it khagiheedaa zhit juu gwinzii t'ee'ya' khaneegiheedaa ts'ą' neegwigweheendaii, zhit juu vigwitr'it gwiizųų nąįį chan, khaneegiheedaa ts'ą' goorahahkat.” ");
INSERT INTO gwiNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Duuyeh shakhai' k'eegwiichy'aa t'ishi'in; Vit'eegwijyąhchy'aa jyaa shahnyąą ji' gwizhrįh dinjii ts'ą' k'eegwahaldhat, shįį deegoochy'a' nihthan gwizhrįh gwik'it goo'aii kwaa gaa Shiti' shihił'e' ąįį deegoochy'a' niindhan izhit gwik'it goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nijin ideenjit giihkhii dąį' zhit deihnyąą ąįį shats'an gwizhrįh t'igwinyąą kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gaa zhit juu sheenjit ginkhii ts'ą' deeshahnyąą ąįį łi'didlii nilii gaashandaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ąįį yihił'e' nąįį John ts'ą' nanoozhik ąįįts'ą' łi'didlii haa gavaa ginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Dinjii andah t'iinyą' hįhjyaa gwat'aałchy'aa kwaa; neekhwazhii ji' eenjit gwizhrįh jyaa dihnyąą t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John adrii ts'ą' gach'ahdrii k'it t'inchy'aa, ch'ihłee gwizhrįh va'aadrii eet'oonghya'. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Gaa jii diihnyąą datthak John deiinyą' andaa gwihil'ee t'ihnyąą. Jidii gwitr'it t'agwał'in t'ee Shiti' geegwitr'it t'agoh'ya' shoonyąą shi'in, izhit deeshi'in gǫǫh'ya'! Gwik'iighai' t'ee Gwiti' shihił'e' gwigweheechy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ąįįts'ą' Gwiti' shihił'e', ąįį nakhwandaa sheeginkhe'. Gwehkįį dohtth'ak kwaa, vinin gaa nǫh'in kwaa, ");
INSERT INTO gwiNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nakhwadrii zhit viginjik dhoh'ąįį chan kwaa, juu hił'e' ąįį k'injuhkhit kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Dęhtły'aa Choh kat aakin gǫǫ'įį, gwandaii ndaanąą'ąį' kwaa gaayiitr'ahaatsyaa nohthan geenjit. Ąįįt'ee vizhit shįį sheegirinkhii t'igwinyąą! ");
INSERT INTO gwiNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ąįį googaa gwandaii khwa'yaa eenjit shįį shats'ą' hohjyaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Dinjii shihił'ee akwat shihił'ee kwaa nąįį adan goots'an t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gaa shįį łyaa nakhwaashandaii; nakhwadrii zhit Vit'eegwijyąhchy'aa veenjit ch'eet'igwiniindhan khwa'įį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Shiti' voozhri' zhit dząą gwats'ą' hoiizhii gaa shik'iinjuhkhit kwaa; gaa ch'izhii dinjii doozhri' zhit nakhwats'ą' neiinzhii ąįį vik'injahohkhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nihłeenjit khadhoo'ee łyaa geet'ohthan, gaa Vit'eegwijyąhchy'aa ch'ihłak zhrįh nilii ąįį hil'ee di'įį ąįį geenjit ninjich'ǫhthat kwaa. Jii kwaii jyaa dohchy'aa gwiizhit nats'ąą gwik'iinjuhohkhit? ");
INSERT INTO gwiNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Gwiti' vandah gwiizųų t'ahǫǫ'ya' nakhwahaihjyaa nohthan kwaa. Moses, vit'injyaahchy'aa ąįį jyaa t'ihee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses łyaa vik'injuhkhit ji', shįį chan shik'iinjuhkhit haa nihk'it t'oonchy'aa, deenyąą t'ee shįį sheeginkhii t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gaa deenaadąį' Moses deenyąą ts'ą' gwadąąntł'oo ąįį gwik'iinjuhkhit kwaa akwat gwiizhit nats'ąą shiginjik k'injihohkhit?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jii ąįįtł'ęę, Jesus Galilee van ndųhts'ąįį neiinzhii (Tiberias van chan oozhii) ");
INSERT INTO gwiNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Gwitr'it geegwaroolii kwaa haa iłts'ik lęįį nąįį shrineiinlik giiyąąh'ya' geh'an lęįį nąįį giitąįį adaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus taih kat ditsyaa nąįį haa naadii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","It'ee niighit kwaa Jews Passover ch'arehee'aa geenigwiighit. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus zhit gwa'an gwąąh'in akhai' lęįį nąįį yats'ą' adaa nigwiił'in ts'ą' Philip jyaa ahnyąą, “Jii dinjii lęįį nąįį nijin shih gavaanchy'aa tr'ooheekwat?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Philip deeheenjyaa ji' niindhan eenjit t'inyąą; adan ch'adąį' hee deehee'yaa gaandaii.) ");
INSERT INTO gwiNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip jyaa yahnyąą, “Jii dinjii nąįį nitsya' giin'al ji' gaa łųhchy'aa $200 gwandaa heelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Vitsyaa ch'ihłak ąįį Simon Peter vachaa Andrew oozhii ąįį t'iiyahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yaagha' gwitee gwa'an tsyaa tsal dhidii ąįį łųhchy'aa barley ch'ihłoanli' ts'ą' łuk neekwaii haa di'įį. Gaa jii kwaii duuyeh jii dinjii nąįį datthak eenjit tr'oonadhat!” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus t'iiyahnyąą, “Dinjii nąįį dook'įį gavahtsii,” (Zhat tł'oo kat goo'aii.) Ąįįts'ą' t'ee dinjii nąįį gaandii; dinjii 5000 andaa t'ąąnchy'aa zhat dilk'ii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus łųhchy'aa oonjik, Vit'eegwijyąhchy'aa mahsį' ahnyąą ts'ą' zhat dinjii dilk'ii nąįį teeyiłtsit. Łuk chan gwik'it t'inlik. Daanchy'aa tr'oo'aa giindhan gwik'it ch'igin'al. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Datthak gwintł'oo ch'igiin'al, ąįįtł'ęę ditsyaa nąįį jyaa ahnyąą, “Zhit jidii giiyeech'aa'al kwaii vit'ineegohjii, ch'ihłok gaa zhyaa an oolį' shrǫ'!” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ąįįts'ą' t'ee giitineegwįłjik ts'ą', tyah ch'ihłoaatin ants'ą' neekwaii zhit deedigiiyiinlii, ąįįt'ee zhit łųhchy'aa ch'ihłoanli' ts'an reh. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ąįį juu zhat dinjii dilk'ii ąįį Jesus gwitr'it gwintsii gwąąh'ya' nąįį jyaa ginyąą, “Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ts'ą' jii nankat gwats'ą' haazhii ąįį t'inchy'aa łee!” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesus et'ee gitr'ii'ee ji' gaa King giihahtsyaa eenjit giiyuuheendal ts'ą' gaandaii. Izhit geenjit neehoozhii ts'ą' adan zhrįh taih tee gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Khaa nigwiighit gwiizhit vitsyaa nąįį ootthan van ts'ą' gahaajil ");
INSERT INTO gwiNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ts'ą' tr'ihchoo zhit giinjil ts'ą' van ndųhts'ąįį Capernaum kwaiik'it goo'aii gwats'ą' neegahoojil. Tǫǫ goodlit gaa tth'aii Jesus oo'ee nidii kwaa, ");
INSERT INTO gwiNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","gwiizhit t'ee gwint'aii hiłtr'aii ts'ą' tit nitsii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Vitsyaa nąįį tik akwat dǫǫ mile aanchy'aa niighit oondaa geekwaa gwiizhit Jesus chųų kat ahaa nigwigwiił'in, tr'ihchoo ts'ą' niighit kwaa niinzhii, łyaa datthak gihilghaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","“Noojat kwaa, shįį t'ihchy'aa!” Jesus gavahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jyaa diinyą' geh'an it'ee tr'ihchoo zhit giihaahchįį gwiizhit nijin gwats'ą' geedaa chy'aa zhat teeghaih nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gęhdaa drin ąįį juu oonin Jesus vitsyaa nąįį haa haajil kwaa nąįį tr'ihchoo ch'ihłak tth'aii zhat dhitin łee gwik'igaanjik. Jesus ditsyaa nąįį haa haazhii kwaa gaagiindaii gaa ąįį tr'ihchoo zhat dhitin geh'an giiyehdan haajil łee gwik'igaanjik. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Gwiizhit Tiberias kwaiik'it gwachoo gwats'an tr'ihchoo lat zhat teedhidlit, geeghaih gwa'an Jesus łųhchy'aa eenjit K'eegwaadhat mahsį' ąįįnyą' ąįįtł'ęę gach'ąh'al izhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nijin Jesus akwat vitsyaa nąįį haa zhat gwąąh'ya' kwaa dąį', tr'ihchoo zhit giinjil ts'ą' oonin Capernaum gwats'ą' giiyinkeegwahaah'yaa eenjit gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nijin ąįį dinjii nąįį van ndųhts'ąįį Jesus agogwąh'ąįį dąį' jyaa giiyahnyąą, “Geech'ǫąąhtan, nijin dąį' dząą k'eiindik?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus t'agavahnyąą, “Łi'didlii haa nakhwaa gwahaldak: Deenohthan gwik'it łųhchy'aa oo'al ąįį geh'an shinkeegoh'in gaa t'aih haa gwitr'it t'agwał'ya' gǫǫh'ya' geh'an nakwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Shih khan iizųų ilii ąįį eenjit gwitr'it t'agoh'ya' shrǫ', shih khit vaa gwireheendaii ąįį gwandaa nizįį. Jii shih t'ee Gwidinji' nintł'eeyahahchaa. Gwiti' ąįį Gwidinji' deegwahtł'oo t'aih yintł'eiin'ąįį gwagwaakįį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ąįįtł'ęę jii giiyųąhkat, “Jidii k'it t'inchy'aa Vit'eegwijyąhchy'aa vigwitr'it t'igwehee'yaa t'agwaiinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“Jii gwitr'it t'ee Vit'eegwijyąhchy'aa t'akhwa'ya' nakhoonyaa, Juu hił'e' ąįį vik'injuhkhit.” Jesus jyaa gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jyaa giiyahnyąą, “Gwarahąąh'yaa ts'ą' gik'iinjireheeghit eenjit jidii t'aih diinandah t'ini'yaa? Deehini'yaa? ");
INSERT INTO gwiNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yeenii diilak nąįį nangwinjir gwa'an łųhchy'aa giin'al, jii Dęhtły'aa Choh zhit geenjit jyaa digwinyąą: ‘Zheekat gwats'an ch'igihee'aa eenjit łųhchy'aa goots'ą' nahtsit.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","“Łi'didlii haa nakhwaa gwahaldak!” Jesus gavahnyąą. “Jidii Moses nakhwantł'in'ąįį t'ee zheekat gwats'an łųhchy'aa t'inchy'aa kwaa. Shiti' ąįįt'ee łųhchy'aa zheekat gwats'an nakhwantł'in'ąįį t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Vit'eegwijyąhchy'aa jidii łųhchy'aa gwantł'ahchak ąįį t'ee zheekat gwats'an nilii ts'ą' jii nankat gwandaii gwats'an ąhtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","“K'eegwaadhat, jii łųhchy'aa khit geenjit diinantł'ahtsit.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","“Ąįį łųhchy'aa vik'iighai' gwarandaii, ąįįt'ee shįį t'ihchy'aa,” Jesus gavahnyąą. “Juu shaa nilii nąįį duuyeh goozhit gwiłts'ik. Juu shik'iinjiighit nąįį duuyeh chųų dahłįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Shǫǫh'ya', nakhwaiinyą' gaa reh nihk'it gwik'iinjuhkhit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Shiti' juu shantł'ahchįį ąįį nąįį shats'ą' heedaa. Juu shaa nilii nąįį duuyeh an gavaal'ee. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Zheekat gwats'an tr'iizhii ts'ą' jidii shi'yaa goo'aii sharahnyąą ąįį gwik'it t'ishi'yaa, shįį shakhai' t'ishi'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Juu shihił'e' t'ee jii kwaii t'ooshi'ya' shoonyąą: juu shantł'eegoovinlii nąįį gaatr'agwałjii shrǫ' shoonyąą, gaa Khaiinkǫǫ Drinzhit ndaanąą'ąį' ji', datthak gwandaii neegoohałtsyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Shiti' jii kwaii gwinkeet'iindhan: Juu Gwidinji' k'injiighit ts'ą' giik'iinjiighit nąįį khit gwarandaii goots'an hałtsyaa. Khaiinkǫǫ Drin ndaanąą'ąį' ji' gwandaii neegoohałtsyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Israel gwich'in nąįį giiyeenjit vik'įį gwanlii, jii jyaa nyąą geh'an, “Ąįį łųhchy'aa vik'iighai' gwarandaii, ąįįt'ee shįį t'ihchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Izhit geh'an jyaa ginyąą, “Joseph vidinji' Jesus lee t'inchy'aa? Vahan, viti' haa gwiindaii t'inchy'aa adan t'inchy'aa ji', nats'ąą zheekat gwats'an ihshyaa nyąą t'inyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus jyaa gavahnyąą, “Zhyaa gookhii kwaa! ");
INSERT INTO gwiNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Juu Shiti' shats'ą' yihił'ee nąįį ji' gwizhrįh shats'ą' heedaa; ts'ą' Khaiinkǫǫ Drin zhit ndaanąą'ąį' ji' gwandaii vats'an neehałtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Yeenii Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį jii dagogwąąntł'oo, ‘Dinjii datthak Vit'eegwijyąhchy'aa googwahah'e'.’ Juu Shiti' diitth'ak ts'ą' yats'an googwaa'ee t'ee shaa nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Gwiti' nah'ya' gwinyąą t'igwinyąą kwaa; juu Vit'eegwijyąhchy'aa ts'an ahaa zhrįh Gwiti' nah'ya' t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Łi'didlii haa nakhwaa gwahaldak, juu gwik'iinjiighit di'įį t'ee khit gwarandaii hee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Łųhchy'aa vik'iighai' gwarandaii t'ihchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Yeenii nakhwalak nąįį nangwinjir gwa'an manna giin'al, gaa nigiindhat. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gaa juu zheekat gwats'an łųhchy'aa a'aa t'ee khit gweheendaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Zheekat gwats'an łųhchy'aa gwandaii ąįį t'ihchy'aa. Juu yiin'al t'ee khit geenjit gweheendaii. Ąįį łųhchy'aa antł'eehałchaa t'ee shatthąį' t'inchy'aa. Jii nankat datthak gwantł'eehałchaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","“Jii gwigwiitth'ak dąį' geenjit Jews nąįį nihzheedagąąn'ee. Jii dinjii nats'ąą datthąį' diihah'aa t'inyąą?” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesus jyaa gwahnyąą: “Łi'didlii haa nakhwaa gwahaldak: Gwidinji' vatthąį' in'aa kwaa ts'ą' vadaa ninįį kwaa ji' duuyeh gwarandaii ni'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Juu shatthąį' a'aa ts'ą' shadaa dinįį t'ee khit gwarandaii hee'yaa, ąįįts'ą' Khaiinkǫǫ Drin zhit ndaanąą'ąį' ji' vineegwahałdaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Shatthąį' t'ee łyaa shih t'inchy'aa, shadaa t'ee łi'haa tr'iheenjyaa eenjit t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Juu shatthąį' a'aa ts'ą' shadaa dinįį t'ee shizhit gwandaii ts'ą' shįį chan vizhit gwįįhdaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Gwiti' gwandaii ąįįt'ee shihił'e' ąįįts'ą' veh'an gwįįhdaii. Izhit gwik'it, juu sha'aa t'ee shęh'an gweheendaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Izhit geh'an t'ee jii łųhchy'aa zheekat gwats'an t'inchy'aa; yeenii nakhwalak łųhchy'aa giin'al ts'ą' nigiindhat ąįį łųhchy'aa k'it t'inchy'aa t'arahnyąą kwaa. Jii łųhchy'aa ąįį juu yiin'al ji' khit gweheendaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum kwaiik'it gwizhit Israel tr'igiinkhii zheh gwizhit Jesus jii eenjit geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Vitsyaa lęįį nąįį jii datthak eenjit gwigwiitth'ak dąį' jyaa ginyąą, “Jii jidii eech'ǫąąhtan łyaa vagwantrii. Juu yuuhaahky'aa ts'ą' gwik'it t'ihee'yaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus deeginyąą giiyaagwaandak kwaa gaa jidii eenjit nihzheedagąąn'ee gavaandaii ts'ą' ąįį eenjit jyaa gavahnyąą, “Jii jyaa diinyą' eenjit akhagohnyą' nohthan? ");
INSERT INTO gwiNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ąįį ji', Gwidinji' gwehkįį nijin gwats'an tr'iinzhii gwits'eehoozhii nǫh'ya' ji' yu'? ");
INSERT INTO gwiNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Vit'eegwijyąhchy'aa vanky'aa t'ee gwandaii gwats'an ąhtsii; gwatthąį' ąįį jyaa dagwąhtsii veegoo'aii kwaa. Jii ginjih eenakhwaagwaldak ąįįt'ee łyaa shroodiinyąą ts'ą' gwandaii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Googaa nakhwalat nąįį jii deiinyą' gwik'iinjiighit kwaa.” (Tr'ookit dąį' gwats'an Jesus juu gootee gwik'iinjiighit kwaa ts'ą' juu gwintł'eeyahahchyaa.) ");
INSERT INTO gwiNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jii chan jyaanyąą, “Jii geh'an gwizhrįh jyaa nakhwaiinyą' duuyeh ch'ihłak gaa shats'ą' hahaii, Gwiti' jyąhts'ą' yeenjit gwiłtsąįį ji' gwizhrįh!” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jii kwaii geh'an, vitsyaa lęįį nąįį akhagiiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ąįįts'ą' Jesus ditsyaa 12 nąįį t'ahnyąą, “Nakhwan chan gavaahohjyaa nohthan?” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter jyaa yahnyąą, “Shik'eegwaadhat, juu vats'ą' tr'iheedaa gǫ'? Gwandaii ndaanąą'ąį' kwaa gweheelyaa eenjit nan zhrįh ginjik ni'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ąįįts'ą' juk Vit'eegwijyąhchy'aa vats'an Shroodiinyąą inlii naagwiindaii ts'ą' gwik'injiriighit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus jyaa gavahnyąą, “12 ǫhłįį ts'ą' gwitee tr'anakhwiilii, gaa nakhwatee ch'ihłak Ch'anky'aa Tr'aanduu nilii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Simon Iscariot vigii eeginkhii t'inyąą. Judas t'ee Vitsyaa 12 nąįį tee dhidii gaa gwintł'eeyahahchyaa.) ");
INSERT INTO gwiNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jii ąįįtł'ęę, Jesus Galilee nahkat datthak neehidik; Judea nahkat ąįį gwats'ą' neehidik gitr'ii'ee, Jews kįh dilk'ii nąįį giiyuukhwaa giindhan geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Dinjii chan hee khaihłan niheedaa ts'ą' ąįį eenjit niighit kwaa Israel nąįį tr'ał zheh googwahahtsyaa nineegweedhat (Tabernacles googahnyąą). ");
INSERT INTO gwiNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ąįįts'ą' t'ee Jesus vachaa nąįį jyaa yahnyąą, “Dzaa gihłeehinkhaii ts'ą' Judea nahkat gwats'ą' hinkhaii, zhit deeni'in kwaii nitsyaa nąįį googwahąąh'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ch'ihłak gwinzii shaagoondaii niindhan gwiizhit duuyeh dee'in nagwąąh'įį. Jyaa dini'in akwat jii nankat datthak naagweheendaii gwahtsii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(vachaa nąįį gaa giik'iinjiighit kwaa). ");
INSERT INTO gwiNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus jyaa goovahnyąą, “Tth'aii gwats'ą' hihshyaa eenjit gwinzii zhat shaa nigwiighit kwaa. Nakhwan ąįį nijin ji' hohjyaa gaa gwinzii. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jii nankat nąįį juu datthak sheet'iindhan kwaa gaa gootr'agwaanduu gwanlii goovaihnyąą geh'an, nakhwan ąįį jyaa nakhwagahthan kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nijin dinjii khaihłan niinjil gwats'ą' hohjyaa ts'ą' ch'oh'aa. Shįį ąįį zhat nihihshyaa kwaa. Gwats'ą' hihshyaa eenjit tth'aii gwinzii zhat shaa nigwiighit kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jyaa diinyą' ąįįtł'ęę t'ee adan ąįį Galilee dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Vachaa nąįį dinjii khaihłan niinjil gwats'ą' gahaajil ąįįtł'ęę Jesus gweentak gootąįį haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jews kįh dilk'ii nąįį dinjii khaihłan niinjil tee giiyinkeegwaah'in, “Adaajii t'inchy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Datthak dinjii khaihłan niinjil tee dagaadzit ts'ą' giiyeeginkhii. Goolat nąįį, “Dinjii nizįį t'inchy'aa giiyahnyąą!” Goolat nąįį, “Akwaa, dinjii nan'ee t'inchy'aa!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gaa ch'ihłak gaa gwandah giiyeeginkhii kwaa, Jews kįh dilk'ii nąįį agąąnjat geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Drin dǫǫ gwizhit datthak ch'aga'aa ndaanagąąhjik gwiizhit Jesus Kharigidiinjii Zhee Gwachoh gwizhit nihdeiinzhii ts'ą' geech'ǫąąhtan. (Drin nihk'iidǫǫ gwizhit datthak dinjii ch'aga'aa) ");
INSERT INTO gwiNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jews kįh dilk'ii nąįį eenjit geegagoolii kwaa t'inyąą ts'ą' jyaa ginyąą, “Jii dinjii gooltin kwaa gwiizhit deegwiłtsii gwandaii t'inyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus jyaa goovahnyąą, “Jidii eech'oaałtan shats'an t'igwinyąą kwaa gaa Vit'eegwijyąhchy'aa shihił'e' vats'an t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Juu Vit'eegwijyąhchy'aa doo'ya' yuunyąą gwik'it t'inchy'aa ąįį t'ee jidii eech'oaałtan ąįį Vit'eegwijyąhchy'aa vats'an t'igwii'in akwat shats'an t'igwii'in ji' eenjit gaaheendaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Juu deeyiindhan zhrįh gwik'it geech'ǫąąhtan t'ee zhyaa sharahoh'e' niindhan, juu yihił'e' ąįį eenjit hil'ee niindhan ąįįt'ee łi'didlii nilii ts'ą' oots'it t'inyąą kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Deenaadąį' Moses va-law nakhwantł'in'ąįį, t'oonchy'aa. Nakhwatee ch'ihłak gaa Law k'eegwahthat kwaa. Jaghaii geenjit shęhdaa tr'agǫh'aa geetr'agoh'in?” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Izhit zhat dinjii lęįį nąįį jyaa ginyąą, “Nizhit ch'anky'aa iizųų dhidii! Juu nęhdaa tr'igwihee'aa gwik'eegwandaii t'igwii'in?” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus jyaa goovahnyąą. “Gwitr'it gwinzii ch'ihłak t'agwał'ya' ts'ą' datthak nakhwandaa t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses nakhwagii chyaatsal vadhah gihłeehoht'ii nakhwaihnyąą geh'an Neegwaazhii Drin chyaatsal vadhah gihłeehoht'ii, (Moses ąįį nakwaa gaa yeenii nakhwalak nąįį tr'ookit khagwigwiin'ąįį.) ");
INSERT INTO gwiNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses va-law łeehaanaii kwaa eenjit chyaatsal Neegwaazhii Drin vadhah gihłeerahaht'ii goo'aii ji' jaghaii Neegwaazhii Drin dinjii ts'ą' tr'iinjik eenjit shats'ą' nakhwak'įį gwanlii? ");
INSERT INTO gwiNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Dinjii gwiizųų t'ii'in dohnyą' shrǫ', nijin gwinzii t'ii'in dąį', K'eegwaadhat jyaa dagoo'ya' shrǫ' diinoohnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalem gwich'in lat nąįį jyaa diginyąą, “Jii dinjii lee giihaahkhwaa geegwitr'it t'agoogwah'in chy'aa? ");
INSERT INTO gwiNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Dzaa gooh'in! Juu nąįį datthak andah ginkhii googaa ch'ihłak gaa k'eegwiichy'aa t'inyąą kwaa. Kįh dilk'ii nąįį Christ t'inchy'aa giiyaandaii t'igii'in gwich'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Gaa Christ nijin vigwiilkįį ji' izhit ch'ihłak gaa nijin gwats'an t'inchy'aa giiyaaheendaii kwaa. Ąįįts'ą' diikhwan ąįį nijin gwats'an t'inchy'aa vaagwiindaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus Kharigidiinjii Zhee Gwachoh gwizhit gwint'aii ginkhii ts'ą' jyaanyąą, “Shaakhwandaii ts'ą' nijin gwats'an ihshyaa gaakhwandaii? Gaa shakhai' dząą gwats'ą' hoiizhii kwaa, juu dząą gwats'ą' shihił'e' t'ee łi'didlii nilii. Nan ąįį vaanandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Gaa shįį ąįį vaashandaii, vats'an tr'iizhii ts'ą' shihił'e'.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ąįįts'ą' zheegwaazhrąįį nihdeegiihahchįį gwik'eegogwandaii, gaa ch'ihłak yakat naanjik kwaa, tth'aii vidrin nigwiighit kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gaa zhat lęįį nąįį giik'iinjiighit ts'ą' jyaa ginyąą. “Nijin Christ vineegwiilkįį ji', jii dinjii dee'ya' ąįį andaa ts'ą' gwitr'it geegwaroolii kwaa t'ihee'yaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisee khaihkwaii nąįį dinjii tee gwa'an dagaadzit Jesus ts'ą' eegiginkhii googiitth'ak, ąįįts'ą' geedan chan ts'ą' giinkhih kįh dilk'ii nąįį haa zheegwaazhrąįį nigiihahchyaa eenjit, gwak'ąąhtii nąįį giiyinkeehił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesus jyaa nyąą, “Tth'aii gwintsal gwizhrįh nakwaa t'ihihchy'aa, ąįįtł'ęę juu nakhwats'ą' shihił'e' ąįį vats'ą' neehihdyaa, ");
INSERT INTO gwiNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Shįį shinkeegoh'in gaa duuyeh shagoh'ąįį, nijuk neehidyaa duuyeh gwats'ą' hohjyaa geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jews kįh dilk'ii nąįį jyaa nihłagaanyąą, “Nijuk gwats'ą' heekhaa ts'ą' khyų' vagwarahah'aa t'inyąą? Greek kwaiik'it Jews nąįį tee gwats'ą' hahaii ts'ą' geech'oohąąhchyaa lee t'inyąą? ");
INSERT INTO gwiNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Jyaa goovahnyąą, ‘Shikeegohǫǫh'yaa gaa duuyeh shagoh'ąįį, ts'ą' nijuk hihdyaa duuyeh gooh'in.’ Deiinyąą t'inyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ąįį ch'ara'aa drin ndaanąą'ąį' łyaa ch'andaa gwihil'ee. Izhit drin Jesus ndak nidhikhin ts'ą' gwint'aii jyaanyąą. “Juu chųų dahłįį shats'ą' hahaii ts'ą' chųų dinįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Dęhtły'aa Choh kat jyaa digwinyąą, ‘Juu shik'iinjiighit, vidrii zhit gwats'an chųų gwandaii t'iheenjyaa.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Juu yik'injiighit nąįį eenjit Ch'anky'aa Shroodiinyąą ts'an gahaa'yaa eenjit Jesus geeginkhii t'inyąą. Izhit zhat dąį' ąįį Ch'anky'aa Shroodiinyąą tth'aii goontł'eerah'ąįį kwaa, Jesus tth'aii hee niighit kwaa ts'ą' ch'eegwąhndit ilii kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Dinjii tee lęįį nąįį jii jyaa nyąą giiyiitth'ak dąį' jyaa ginyąą, “Jii dinjii Vit'eegwijyąhchy'aa Eenjit Ginkhii t'inchy'aa łee!” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ch'izhii nąįį jyaa ginyąą, “Christ t'inchy'aa oo'ee?” Gaa ch'izhii nąįį chan jyaa nyąą, “Christ duuyeh Galilee gwats'an ahaa t'inchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Dęhtły'aa Choh kat, dinjii yeenii King David ts'an deedhaa ts'ą' Bethlehem gwizhit vigweheelyaa ąįįt'ee Christ, dinjii neehahshii heelyaa gwinyąą, ąįį kwaiik'it t'ee David gwiinch'į'. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Nihłitee giiyeenjit nihzheedagąąn'ee. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Goolat nąįį zheegwaazhrąįį narohchyaa giiyuunyąą, ch'ihłak gaa giikat naanjik kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ąįį gwiky'aahtii nąįį, giinkhih kįh dilk'ii nąįį chan ts'ą' Pharisee khaihkwaii nąįį haa ts'eegahoojil, ąįį nąįį googaahkat, “Jaghaii adahaa oo'ee noohchįį kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ąįį gwiky'aahtii nąįį jyaa ginyąą, “Jii dinjii łyaa vik'it t'igwinyąą kwaa t'arahnyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","“Nakhwan chan neenakhwaiin'ak lee t'ohnyąą,” Pharisee khaihkwaii nąįį jii googaahkat. ");
INSERT INTO gwiNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“Diitee gwa'an nik'ee diikhaihkwaii akwat Pharisee khaihkwaii ch'ihłak yik'injiighit haakhwandaii? ");
INSERT INTO gwiNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Juk dząą dinjii nąįį Moses va-law haagiindaii kwaa, ąįį geh'an t'ee Vit'eegwijyąhchy'aa doo'ya' gavoonyąą gwik'it t'iginchy'aa kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus t'ee Pharisee ch'ihłak nilii, ąįįt'ee gwehkįį dąį' Jesus eenoozhii ts'ą' nah'ya'. Nicodemus jyaa gavahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Dii-law zhit duuyeh dinjii tr'ahaahkhwaa gwats'ą' dee'ya' eenjit vęhdaa tr'agwara'aii goo'aii gwinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ąįį jyaa ginyąą, “Nan chan Galilee gwats'an inkhaa? Dęhtły'aa Choh kat vagwan'ee ąįį ji' t'ee Galilee gwats'an Vit'eegwijyąhchy'aa Eenjit Ginkhii ahaa kwaa gwiky'aahaandal.” ");
INSERT INTO gwiNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ąįįtł'ęę t'ee juu nąįį datthak digizheh gwits'eegahoojil. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Gaa Jesus ąįį Taih Vakat Olives Nahshii ts'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gęhdaa vanh dąį' hee Kharigidiinjii Zhee Gwachoh gwits'eehoozhii. Lęįį nąįį yeelin niinjil ts'ą' dhidii ts'ą' geegoovąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Law eech'ǫąąhtan nąįį chan ts'ą' Pharisee nąįį haa dinjii va'at ch'izhii dinjii haa dhichįį ik'igaanjik ąįį nihdeegąąhchįį ts'ą' juu nąįį datthak ts'ą' nigiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“Geech'ǫąąhtan,” Jesus agahnyąą, “Jii tr'injaa dinjii va'at ch'izhii dinjii haa dhichįį vik'igwaanjik. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moses dii-law zhit tr'injaa jyaa dii'in t'ee kii haa tr'ahaahkhwaa goo'aii nyąą. Akwat, geenjit deehiinjyaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Goodhaii nideegiihaatthal eenjit jyaa giiyahnyąą t'iginyąą, gwik'it t'iizhik giiyahaanjyaa eenjit. Gaa Jesus ąįį khatroogwiintthaii ts'ą' nankat danleetth'ak haa ch'adąąntł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Zhat nigiilzhii ts'ą' gwintł'oo giiyųąhkat, ndak ninehjin ts'ą' jyaa goovahnyąą, “Nakhwatee juu vatr'agwaanduu gwakwaa, ąįį jii tr'injaa adan tr'ookit kii haa yatthat.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Chan hee khatroogwiintthaii ts'ą' nankat ch'adąąntł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nijin jii gwigwiitth'ak dąį', gootee googwąąnchy'aa ts'ą' gihłeegihii'oo, juu vaghaii lęįį nąįį tr'ookit. Jesus zhrįh zhat dhidii, ąįį tr'injaa chan zhat nadhat. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ndak ninehjin ts'ą' jyaa nyąą, “Tr'injaa nijin neegahoojil? Nik'ee gwintł'ee nahahchyaa ch'ihłak dząą dhidii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Shik'eegwaadhat datthak gihłeegahoojil,” ąįį tr'injaa nyąą. “Akwat, shįį chan duuyeh narahaahkhwaa geenjit gwintł'ee nahałchįį t'oonchy'aa, oo'an neehiindii ts'ą' chan natr'agwaanduu neegooli' shrǫ'.” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nijin chan hee Jesus goots'ą' neegeedi', “Jii nankat gwach'aadrii ihłii. Juu shaa ahaa t'ee gwandaii aadrii hee'yaa ts'ą' chan duuyeh tǫǫ gwizhit ahaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ąįį Pharisee khaihkwaii nąįį jyaa giiyahnyąą, “Et'ee nahzhrįį ideenjit ginkhii akwat deiinyąą datthak zhyaa t'iinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","“Nakwaa!” Jesus gavahnyąą, “Shahzhrįh ideenjit giihkhii ji' gaa deihnyąą datthak łi'didlii nilii t'inchy'aa, nijin gwats'an ihshyaa akwat nijin gwits'eehihdyaa gaashandaii geh'an. Nakhwan ąįį nijin gwats'an tr'iizhii akwat nijin neehihdyaa gaakhwandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Dinjii vidrii zhit t'oonchy'aa gaakhwandaii kwaa gwiizhit jyaanchy'aa dohnyąą, shįį ąįį duuyeh dinjii agwarahahshįį eenjit gwantł'ałchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gaa jyaa dihiinjyaa ji', łi'didlii haa t'ihihjyaa, shįį zhrįh jyąhts'ą' sheegoo'aii kwaa, Gwiti' shihił'e' chan shaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nakhwa-law zhit gwadanakhwatł'oo, nijin vandah t'igwiizhik neekwaii nąįį łi'didlii t'igwinyąą ginyąą dąį' gwizhrįh łi'didlii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ideenjit giihkhii ąįįts'ą' Shiti' shihił'e' chan sheenjit ginkhii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","“Niti' adaajii?” giiyahnyąą. “Shaakhwandaii kwaa ts'ą' Shiti' chan vaakhwandaii kwaa, shaakhwandaii ji' Shiti' chan vaakhwahandaii goo'aii t'oonchy'aa.” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kharigidiinjii Zhee Gwachoh gwizhit jii kwaii jyaa nyąą, ąįį nijin gwizhit gwintł'eegaandak goo'aii gwizhit. Ąįįts'ą' t'ee ch'ihłak gaa zheegwaazhrąįį niyąąhchįį kwaa, tth'aii zhat veegoo'aii kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus chan hee jyaa dagoovahnyąą, “Hihshyaa t'oonchy'aa; shikeegohǫǫh'yaa gaa nakhwatr'agwaanduu zhit nahohthaa nijuk hihshyaa izhit duuyeh gwats'ą' hohjyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ąįįts'ą' t'ee Israel gwakhaihkwaii nąįį jyaa ginyąą, “Nijin gwats'ą' hihshyaa ąįį duuyeh gwats'ą' hohjyaa nyąą akwat adahaaghwaa lee t'inyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus jyaa gavahnyąą, “Yeezhak gwats'an ohdaa gaa shįį ąįį yeedak gwats'an ihshyaa. Dzaa nankat gwats'an tr'oojil gaa shįį ąįį nankat gwats'an ihshyaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ąįį geh'an t'ee nakhwatr'agwaanduu zhit nahohthaa nakhwaihnyąą. ‘Juu Ihłii Ąįį Ihłii.’ Gwik'injuhkhit kwaa ji' t'ee ąįį geh'an nakhwatr'agwaanduu zhit nahohthaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Juu inlii?” giiyahnyąą? Jesus jyaa gavahnyąą, “Juu ihłii tr'ookit dąį' gwats'an nakhwaihnyąą ąįį ihłii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Deekhwa'ya' eenjit gwintł'ee nakhwahałchyaa, gaa juu shihił'e' ąįį Łi'didlii nilii, ąįįts'ą' jidii vats'an gwiihtth'ak ąįį zhrįh jii nankat eegwahaaldak t'ihnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Gwiti' eeginkhii t'inyąą giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ts'ą' t'ee Jesus jyaa gavahnyąą, “Nijin Gwidinji' ndak gahoohchįį t'ee ‘Juu Ihłii Ąįį Ihłii!’ gaakhwahandaii, izhit t'ee shakhai' t'ihnyąą kwaa ts'ą' Gwiti' jidii geeshoołtin ąįį gwaałtan t'ihnyąą gaakhwahandaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Juu shihił'e' ąįį shaa nilii, akhashoonyąą kwaa, doo'ya' shoonyąą gwik'it t'ishi'in geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Lęįį nąįį Jesus deiinyą' giik'injiighit. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ąįįts'ą' t'ee juu gootee giik'iinjiighit nąįį jyaa ahnyąą, “Jii geenakhwaałtan kwaii gwik'eegǫhthat ji', łyaa shitsyaa ǫhłįį, ");
INSERT INTO gwiNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","łi'didlii haakhwahandaii, ts'ą' gadanakhwahahchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","“Abraham vats'an direedhaa, ąįįts'ą' ch'ihłak gaa ts'an tr'iinli' kwaa. Deiinyąą t'iinyąą, ‘Gadanakhwahałchyaa.’ diinyąą dąį'?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus jyaa gavahnyąą, “Łi'didlii eenakhwaagwahaldak: juu datr'agwaanduu gwahtsii t'ee tr'aanduu goots'ą' k'eegwaadhat k'it t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ąįį juu slave nilii nąįį digizheh k'ąą gwizhit dagalak nąįį tee gwats'an giheelyaa kwaa gaa Gwidinji' ąįį khit zhat gwats'an heelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gwidinji' gadanakhwaahchįį ji', t'ee łyaa khit geenjit gadahohdaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham ts'an dohthaa gaashandaii, ąįį googaa shęhdaa tr'agahoh'aa geetr'agoh'in, jidii geenakhwaałtan gwik'iinjuhkhit kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jidii Shiti' shats'ą' gwigweełch'in ąįį geenakhwaagwaldak, gaa nakhwan ąįį nakhwati' deenakhwahnyąą ąįį gwizhrįh gwik'eegǫhthat.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“Diilak t'ee Abraham t'inchy'aa,” giiyahnyąą. “Abraham vats'an dohthaa ji', nakhwan chan vigwitr'it t'agahoh'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Vit'eegwijyąhchy'aa vats'an łi'didlii diitth'ak ąįį geenakhwaagwaldak gwizhrįh t'ishi'ya'. Ąįį googaa shęhdaa tr'agahoh'aa geetr'agoh'in. Abraham jyaa dee'ya' kwaa t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nakhwati' dee'ya' ąįį vik'it t'akhwa'in,” Jesus gavahnyąą. “Kwaiitak-gii tr'inlii kwaa, Vit'eegwijyąhchy'aa zhrįh diiti', diikhwan zhrįh vidinji' łi'didlii tr'iinlii,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus jyaa gavahnyąą, “Vit'eegwijyąhchy'aa nakhwati' nilii ji', sheet'ahoohkhyaa, Vit'eegwijyąhchy'aa vats'an ihshyaa ts'ą' juk dząą dhidii geh'an. Shakhai' dząą gwats'ą' hoiizhii kwaa gaa dząą gwats'ą' shihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Jaghaii deiinyąą t'iihnyąą datthak gaakhwandaii kwaa? Deiinyąą t'ihnyąą ąįį goohtth'ak nohthan kwaa geh'an t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nakhwati' Ch'anky'aa Tr'aanduu vigii ǫhłįį ts'ą' nakhwati' nilii ts'ą' doo'ya' nakhoonyaa gwik'it t'akhwa'in. Tr'ookit dąį' gwats'an dinjii aghan nilii. Ch'ihłok gaa łi'didlii nilii kwaa, łi'didlii vizhit kwaa geh'an. Oots'it zhrįh gwizhit nilii geh'an tr'oots'it gwiti' nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Łi'didlii eegiihkhii geh'an shik'injuhkhit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nakhwatee ch'ihłak nik'ee vandah shatr'agwaanduu gwałtsii shąąh'ya'? Łi'didlii eegiihkhii t'ihnyąą ji' jaghaii shik'injuhkhit kwaa? ");
INSERT INTO gwiNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Juu Vit'eegwijyąhchy'aa ts'an ahaa t'ee Vit'eegwijyąhchy'aa viginjik oołk'įį. Nakhwan ąįį Vit'eegwijyąhchy'aa vats'an ohdaa kwaa, ąįį geh'an ch'oodǫǫhk'įį kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Israel nąįį Jesus jyaa gahnyąą, “Samaria gwich'in inlii ts'ą' nizhit ch'anky'aa iizųų dhidii ąįį łyaa lee t'igwinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Shizhit ch'anky'aa iizųų kwaa t'oonchy'aa,” Jesus gavahnyąą, “Shiti' hooł'e', gaa nakhwan ąįį shahooh'ee kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sharahoh'e' yiihthan kwaa, gaa ch'ihłak zhrįh sharahoh'e' yiindhan, ts'ą' adan ąįį jidii gwiizųų akwat gwinzii haa heenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jii t'ee łyaa łi'didlii. Juu shik'eegwahthat t'ee duuyeh niighit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Israel nąįį jyaa giiyahnyąą, “Et'ee nizhit ch'anky'aa iizųų dhidii naagwiindaii! Abraham chan niindhat, yeenii Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį chan niinjik, googaa gwiizhit jyaa diinyąą, ‘Juu shik'eegwahthat t'ee duuyeh niighit.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Diilak Abraham chan ts'ą' Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį niinjik. Abraham vandaa t'agwahtsii sheegoo'aii diinyąą lee t'iinyąą? Jidii ihłii niindhan?” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus jyaa gavahnyąą, “Ideenjit zhrįh yinjiihooh'ee ji', ąįį yeenjihooh'ee giilį' nilii. Shiti' sheeyinjihił'ee. Ąįįt'ee nakhwan chan Vit'eegwijyąhchy'aa vohnyąą reh. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ch'ihłok gaa vaakhwandaii kwaa gaa shįį ąįį gwinzii vaashandaii. Vaashandaii kwaa dihnyąą ji' t'ee nakhwak'it oohihts'it. Gaa vaashandaii ts'ą' viginjik k'eegwałthat. ");
INSERT INTO gwiNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nakhwalak Abraham nijin drin shahąąh'yaa ji' geenjit shoo nilii, ch'adąį' gwąąh'ya' ts'ą' shoo dhidlit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jews nąįį jyaa giiyahnyąą, “Tth'aii googaa 50 years old inlii kwaa gwiizhit Abraham nah'ya'?” ");
INSERT INTO gwiNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","“Łi'didlii haa giihkhii! Abraham vehkii dąį' gwats'an Shįį Ihłii!” Jesus gavahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kii giiyeenjit teegwįłjik gaa Jesus gweentak Kharigidiinjii Zhee Gwachoh cheehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus ahaa gwiizhit dinjii vandee kwaa ts'ą' vagoodlit niił'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Vitsyaa nąįį yuahkat, “Geech'ǫąąhtan, vandee kwaa ts'ą' vagoodlit ąįį juu vatr'agwaanduu t'oonchy'aa? Adan vats'an akwat viyehghan nąįį?” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus jyaa gavahnyąą, “Vandee kwaa ąįį adan vatr'agwaanduu akwat viiyehghan gootr'agwaanduu gwadrąįį t'oonchy'aa kwaa. Gaa jii dinjii vandee kwaa ąįį, Vit'eegwijyąhchy'aa vat'aii gwizhrįh eegweheechy'aa eenjit vaagweech'in neegahoodlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tth'aii drin gwanlii gwiizhit juu shihił'e' ąįį nihk'it vigwitr'it t'agwarahah'yaa gwizhrįh goo'aii. Et'ee tǫǫ gweheelyaa ts'ą' duuyeh tǫǫ gwitr'it t'agwarah'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Dzaa nankat dhiidii gwiizhit, jii nankat eenjit aadrii ihłii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jii jyaa diinyą' ąįįtł'ęę, Jesus nankat haazhree ts'ą' łųh niłtraa ąįį dinjii vaagweech'in kwaa andee kat giinjik ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","jyaa yahnyąą, “Oo'an Siloam teełtin gwats'ą' hinkhaii zhat chųų haa neech'aanjii.” Ąįįts'ą' ąįį dinjii zhat gwats'ą' haazhii ts'ą' neech'aanjik ts'ą' vaagweech'in ts'ą' k'inidik. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ąįį yeeghaii gwich'įį nąįį chan ts'ą' juu khit ch'oodiikwat yąąh'in nąįį ch'agoahkat, “Jii dinjii lee dhidii ts'ą' ch'oodiikwat chy'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Goolat nąįį jyaa ginyąą, “Adan t'inchy'aa,” goolat nąįį chan jyaa ginyąą “Adan t'inchy'aa kwaa, gaa yigwich'in.” Ąįį dinjii jyaa gavahnyąą “Ąįį dinjii t'ee shįį t'ihchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","“Nats'ąą naagweech'in needhindlit?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","“Dinjii Jesus oaazhii ąįį nankat haazhree ts'ą' łųh niłtraa ąįį shandee kat giinjik ts'ą' jyaa shahnyąą, ‘Oo'an Siloam teełtin gwats'ą' hinkhaii zhat chųų haa neech'aanjii.’ Zhat gwats'ą' hoiizhii neech'aaljik ts'ą' shaa gweech'in needhiidlit,” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“Adaajii?” giiyahnyąą. “Adaajii vaashandaii kwaa,” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ąįįtł'ęę t'ee ąįį dinjii vandee kwaa iinli' chy'aa Pharisee nąįį ts'ą' giihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nijin ąįį Jesus dinjii andee łųh t'iinlik dąį' vaagweech'in neeyiłtsąįį drin Neegwaazhii Drin gwanlii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pharisee nąįį ąįį dinjii nats'ąą vaagweech'in neekhwadlit eenjit giiyųąhkat. Goovaagwaandak, “Shandee łųh t'inlik ąįįtł'ęę neech'aaljik ts'ą' juk shaagweech'in,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pharisee lat nąįį jyaa ginyąą, “Jii dinjii juu t'iizhik Vit'eegwijyąhchy'aa ts'an t'inchy'aa kwaa, Neegwaazhii Drin jyaa dihee'yaa kwaa goo'aii ąįį gwik'eegwahthat kwaa geh'an.” Goolat nąįį jyaa ginyąą, “Nats'ąą dinjii vatr'agwaanduu gwanlii ąįį gwitr'it geegwaroolii kwaa t'ihee'yaa?” ąįįts'ą' t'ee datthak geenjit nihzheedagąąn'ee. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ąįįts'ą' t'ee Pharisee nąįį chan hee giiyųąhkat, “Naagweech'in neegwiłtsąįį akwat veenjit deehiinjyaa?” “Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii t'inchy'aa,” jyaa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Israel kįh dilk'ii nąįį ąįį dinjii vandee kwaa iinli' ąįįtł'ęę vaagweech'in neekhwadlit ąįį gwik'iinjigiighit gitr'igii'ee, ąįįts'ą' t'ee giiyehghan nąįį jii oahkat, “Jii lee nigii tsyaa? Vandee kwaa ts'ą' vagoodlit vohnyąą gwiizhit jaghaii juk vaagweech'in gǫ'?” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ąįį viyehghan jyaa ginyąą, “Diigii t'inchy'aa ts'ą' vandee kwaa ts'ą' vagoodlit vaagwiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gaa jaghaii juk vaagweech'in neekhwadlit akwat juu vaagweech'in neeyiłtsąįį vaagwiindaii kwaa. Oohkat, vaghaii lęįį t'inchy'aa ts'ą' adakhai' nakhwaagwaandak!” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ąįį viyehghan nąįį Israel kįh dilk'ii nąįį agąąnjat geh'an jyaa diginyąą t'iginyąą, ąįį juu Jesus ąįį Christ t'inchy'aa nyąą t'ee Israel tr'igiinkhii zheh cheerahahchyaa ch'adąį' ginyą' geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Izhit geh'an t'ee “Vaghaii lęįį t'inchy'aa ts'ą' oohkat!” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Chan hee ąįį dinjii vandee kwaa iinli' chy'aa aanaii giiyahnyąą ts'ą' jyaa giiyahnyąą “Vit'eegwijyąhchy'aa vandah łi'didlii haa geegwandak! Jii dinjii vatr'agwaanduu gwanlii ts'ą' vaagwiindaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","“Vatr'agwaanduu gwanlii akwat vatr'agwaanduu gwakwaa ji' gaa vaashandaii kwaa t'inchy'aa,” ąįį dinjii nyąą. “Ch'ihłak gwizhrįh gaashandaii, shandee kwaa gwiili' gaa juk shaagweech'in neegakhwadlit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","“Deeniinlik? Nats'ąą naagweech'in neegwiłtsąįį?” giiyųąhkat. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","“Ch'adąį' nakhwaagwaldak t'oonchy'aa, gaa khų' ch'oodǫǫhk'įį. Jaghaii chan hee geenakhwaagwaldak yuuhthan? Nakhwan chan vitsyaa ǫhłį' nohthan?” gavahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ąįįts'ą' shruk haa giits'ą' khaginkhee, “Ąįį dinjii vitsyaa iinlii; diikhwan ąįį vitsyaa tr'iinlii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Vit'eegwijyąhchy'aa, Moses ts'ą' giinkhe' gaagwiindaii; ąįį dinjii t'avaiinyąą, nijin gwats'an tr'iinzhii gaa vaagwiindaii kwaa t'inchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ąįį dinjii jyaa gavahnyąą, “Łyaa shandaa t'ohnyąą, nijin gwats'an tr'iinzhii vaakhwandaii kwaa gaa shaa gweech'in neegwiłtsąįį! ");
INSERT INTO gwiNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Vit'eegwijyąhchy'aa vatr'agwaanduu gwanlii nąįį oołk'įį kwaa vaagwiindaii. Dinjii nikiigwah'ee ts'ą' doo'ya' gavoonyąą gwik'it t'inchy'aa nąįį oołk'įį vaagwiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jii nan goodlit dąį' gwats'an dinjii ch'izhii dinjii haagweech'in neegwiłtsąįį gwinyąą gwiriitth'ak kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Jii dinjii Vit'eegwijyąhchy'aa vats'an t'inchy'aa kwaa ji' duuyeh k'eegwiichy'aa t'ii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jyaa giiyahnyąą, “Tr'agwaanduu gwitr'it gwizhit nagoodlit ts'ą' gwizhit diink'iindhat. Geediinǫąąhtan gwik'eegwiindaii lee t'iinyąą?” Ąįįts'ą' Israel tr'igiinkhii zheh gwizhit cheet'eegiiheełnaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ąįį dinjii cheet'eeheełnaii gwinyąą ąįį Jesus gwiitth'ak. Yagwąh'ąįį ts'ą' jyaa yahnyąą, “Gwidinji' k'injiinghit?” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ąįį dinjii jyaa nyąą, “Juu t'inchy'aa veeshaagwandak vik'injihihthaa eenjit!” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus jyaa yahnyąą, “Ch'adąį' nah'ya' t'inchy'aa, ąįį juu t'avaiinyąą et'ee juk zhat nats'ą' giihkhii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“K'eegwaadhat iinlii it'ee nik'iinjihkhit!” Ąįį dinjii yahnyąą ts'ą' yats'ą' nikiigwiintthaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus jyaa nyąą, “Dinjii oohaałkat eenjit dząą nankat gwats'ą' hoiizhii t'ishi'in. Vaagweech'in kwaa nąįį haagweech'in neegwahałtsyaa ts'ą' juu vaagweech'in adoodiinyąą nąįį chan haagweech'in kwaa neehałtsyaa eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pharisee lat juu zhat yaadilk'ii nąįį jyaa nyąą giiyiitth'ak dąį' jii giiyųąhkat, “Diikhwan chan diinaagweech'in kwaa diinyąą lee t'inyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus jyaa gavahnyąą, “Nakhwaa gweech'in kwaa ji', duuyeh nakhwatr'agwaanduu gwilii gaa ‘Diinaagweech'in,’ dohnyąą gwiizųų t'ohnyąą gaakhwandaii gaa jyaa dohnyąą t'ohnyąą ąįį ji' tth'aii nakhwatr'agwaanduu gwanlii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Łi'didlii eenaagwagwahaldak! Juu divii dehk'it goo'aii ąįį gindeiinvyaa k'it k'ii'ee nihdeiinzhii kwaa ts'ą' ch'adanh k'ii'ee gwats'ą' haazhii t'ee ch'an'įį ts'ą' dinjii łi'didlii nilii kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gaa divii k'ąąhtii nąįį gindeiinvyaa k'it gwizhrįh nihdeegadal. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Gindeiinvyaa k'ąąhtii nąįį nihdeegiiyahchik; didivii tee ch'oaazhri' gwizhrįh giiyiitth'ak ts'ą' giits'ą' chagahdal ts'ą' jyąhts'ą' cheegavahaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Datthak cheegoovaahchik dąį' goots'įį ahaa ts'ą' giitąįį adaa, giideezhuh diitth'ak ts'ą' giiyaandaii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ch'izhii dinjii ąįį duuyeh tąįį geedaa; t'oohłii galgahahdaa, giideezhuh haa heendaii kwaa geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus jii gwandak gwah'įį gwizhit geegavaagwaandak gaa deegavahnyąą ąįį deegwinyąą t'igwinyąą gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ąįįts'ą' Jesus chan hee jyaa nyąą, “Łi'didlii eenakhwaagwahaldak: Shįį t'ee divii nąįį eenjit gindeiinvyaa ihłii. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Juu shehkii nihdeiinjil nąįį t'ee ch'an'įį giinlii ts'ą' łi'didlii giinlii kwaa; gaa divii nąįį googoołk'įį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Shįį t'ee gindeiinvyaa t'ihchy'aa juu shik'iighai' gindeiinvyaa k'it nihdeiinzhii t'ee neegoorahahshii, nihdineeheedik ts'ą' chineeheedik ts'ą' tł'oo chyah nizįį hee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ch'an'įį nąįį ch'igiheen'įį, dinjii ęhdaa tr'agwa'ak akwat an googwahahtsyaa eenjit gwizhrįh nihdeegadal. Shįį ąįį gwinzii gogweheendaii ji' eenjit dząą nankat gwats'ą' hoiizhii t'ishi'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Divii k'ąąhtii nizįį ihłii. Divii k'ąąhtii nizįį didivii eenjit naheedhaa ji' gaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Divii k'ąąhtii nilii kwaa ąįį laraa t'įį divii k'ąąhtii ts'ą' divii di'įį kwaa ąįį zhoh niił'in dąį' divii akhoonyąą ts'ą' zhoh goolat teegwįłjik ts'ą' shrihteegaajil. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ąįį divii laraa t'įį k'ąąhtii ąįį t'oohłii divii ts'į' neehilgit, zhyaa laraa t'įį tr'agwah'in geh'an divii eenjit niinjich'adhat kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Divii k'ąąhtii nizįį ihłii. Gwiti' shaandaii ts'ą' shįį chan vaashandaii, izhit gwik'it shidivii nąįį haashandaii ts'ą' geedan chan shaagiindaii. Gooveenjit ji' gaa nihihthaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Goolat nąįį ch'adanh giilk'ii. Oo'ee neegoohihłyaa, goots'ą' giihkhii dąį' shigiitth'ak ts'ą' nihteeneegiheedaa ts'ą' ch'ihłak giheelyaa ts'ą' divii k'ąąhtii ch'ihłak zhrįh gook'eehąąhtyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Gwiti' sheet'iindhan geh'an nihihthaa galjat kwaa, ąįįtł'ęę neegwihįhdaii chan sheenjit gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ch'ihłak gaa gwįhdaii shihłeegwehee'aa kwaa, shakhai' gwintł'eehih'aa. Shakhai' gwintł'eehih'aa ts'ą' shakhai' chan noohihdal. Jii t'ee Shiti' jyąhts'ą' sheenjit gwiłtsąįį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jii ginjik kwaii eh'an chan hee nihzheedagąąn'ee ");
INSERT INTO gwiNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Gootee lęįį nąįį jyaa ginyąą, “Vizhit ch'anky'aa iizųų dhidii! Vagwandaii iizųų! Jaghaii oodǫǫhk'įį t'ohchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Gaa ch'izhii nąįį jyaa ginyąą, “Dinjii vizhit ch'anky'aa iizųų gwiizhit jyąhts'ą' ginkhii kwaa t'oonchy'aa! Nats'ąą ch'anky'aa iizųų dinjii vandee kwaa haagweech'in neegwahahtsyaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Et'ee khaii gwanlii Jerusalem gwizhit Hanukkah khaihłan nineegiidal nineegwiidhat; ");
INSERT INTO gwiNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus ąįį Kharigidiinjii Zheh Gwachoh gwizhit Solomon's Porch t'agahnyąą gwizhit gwa'an neehidik. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nijin ąįį Jews nąįį Jesus eelin nigiilzhii ts'ą' jyaa ginyąą dąį', “Deegwiłkhyuk diits'ą' gwit'eegwaha'aa t'inchy'aa? Łi'didlii haa diinaa gwandak nan lee Christ inlii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus jyaa gavahnyąą, “Ch'adąį' hee nakhwaagwadhaldak gaa shik'iinjuhkhit kwaa; nakhwandah Shiti' voozhri' zhit t'ishi'in gooh'in t'ee juu ihłii gwigweech'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Gaa shik'iinjuhkhit kwaa geh'an shidivii hohłyaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Shidivii nąįį shiginjik haandaii, shįį chan goovaashandaii ts'ą' shatąįį geedaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Khit geenjit gwigweheendaii nigwii'ąįį, ts'ą' duuyeh gahchįį; ch'ihłak gaa duuyeh shats'an yan'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Shiti' shintł'eegoovinlii ts'ą' ch'andaa t'aht'aii, ts'ą' duuyeh gaa Shiti' vats'an gooroonjii. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Gwiti', shįį haa ch'ihłak tr'iinlii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ąįįts'ą' Jews nąįį chan hee Jesus eenjit kii tee gwigwįłjik. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus jyaa gavahnyąą, “Nakhwandah gwitr'it gwinzii gwinlęįį t'ishizhik, ąįįt'ee Gwiti' shintł'eegwiin'ąįį; ąįį gwitee jidii shrit t'ishizhik eenjit kii haa shohohkhwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Israel nąįį jyaa ginyąą, “Ąįį gwitr'it gwinzii kwaii eenjit kii haa narahaahkhwaa t'igwii'in kwaa gaa Vit'eegwijyąhchy'aa vinehts'į' ginkhii ąįį eenjit. Dinjii zhrįh iinlii, gaa Vit'eegwijyąhchy'aa hinlyaa gwik'eegwiindaii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus jyaa gavahnyąą, “Nakhwa-law Dęhtły'aa Choh kat jii deegwinyąą khit ts'ą' łyaa łi'didlii ąįį gaagwiindaii; ‘Vit'eegwijyąhchy'aa ǫhłįį,’ nyąą, ");
INSERT INTO gwiNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","zhit juu Vit'eegwijyąhchy'aa Viginjik antł'inlii nąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Shįį ąįį, Gwiti' gwiteetr'ashąhchįį ts'ą' nankat gwats'ą' shihił'e'. Nats'ąą Vit'eegwijyąhchy'aa Vidinji' ihłii dihnyąą eenjit vinehts'į' giihkhii shohnyąą t'ohnyąą? ");
INSERT INTO gwiNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Shiti' vigwitr'it t'agwał'in shi'in kwaa ji' shik'iinjuhkhit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gaa nihk'it t'ishi'in ts'ą', shik'iinjuhkhit kwaa ji' gaa Shiti' vigwitr'it t'ishi'in ąįį geenjit shik'iinjuhkhit. Ąįį ji' t'ee Gwiti' shizhit t'inchy'aa akwat chan Gwiti' shizhit t'inchy'aa shaakhwandaii eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Chan hee zheegwaazhrąįį nigiihahchyaa gwik'igogwandaii, gaa goovantł'ee tr'ineezhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesus chan hee Jordan han gwinjik nineezhii ts'ą' nijin John tr'ookit vats'an chųų dhidlit izhit dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Lęįį nąįį yats'ą' haajil ts'ą' jyaa ginyąą, “John jyaa deegwahtł'oo gwitr'it geegwaroolii kwaa t'iizhik, gaa jii dinjii daiinyą' datthak łi'didlii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ąįįts'ą' zhat dinjii gwanlii lęįį nąįį giik'iinjinghit. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Dinjii Lazarus oaazhii Bethany kwaiik'it gwizhit gwich'įį ąįį iłts'ik naanaii. Bethany gwizhit t'ee Mary chan ts'ą' veejii Elizabeth haa gwigwich'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Jii Mary t'ee gwehkįį K'eegwaadhat vakwai' kat gwanzhįh chų' gwinzii vagwaatsan t'inlik ts'ą' dikiighai' haa yach'ąhjik ąįį voondee Lazarus ąįį iłts'ik.) ");
INSERT INTO gwiNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ąįį tr'injaa neekwaii t'ee Jesus ts'ą' nideech'igiin'ąįį, “K'eegwaadhat, nijyaa gwilęįį iłts'ik,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nijin Jesus jyaa ginyąą gaviitth'ak dąį' jyaa nyąą, “Jii ts'ik haa niheedhaa kwaa t'inchy'aa, gaa Vit'eegwijyąhchy'aa vich'eegwahdrii gwizhrįh nagwahaatth'aa ąįįts'ą' gwik'iighai' shįį Vit'eegwijyąhchy'aa Vidinji' shich'eegwahahdrii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus ąįį Martha chan ts'ą' vijuu Mary, Lazarus nąįį haa eet'iindhan. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Nijin Jesus Lazarus iłts'ik gwinyąą gwiitth'ak dąį', drin neekwaii gwahaadhat gaa nihk'it zhat dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ąįįtł'ęę ditsyaa nąįį jyaa ahnyąą, “Judea gwits'eerahoojyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Geech'ǫąąhtan,” vitsyaa nąįį yahnyąą, “Niighit kwaa gwanaa dąį' Judea nąįį kii haa narookhwaa nagoonyąą; chan hee zhat gwits'eehindyaa lee t'iinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus jyaa nyąą, “12 hr. gwizhrįh drin goo'aii, izhit gwizhrįh dinjii vaagweech'in ts'ą' duuyeh gat'aadhak. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Gaa tǫǫ gwiizhit zhit gwa'an neehidik ji' git'eehaadhak, ąįį dinjii vizhit tǫǫ gwanlii geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesus jyaa nyąą, “Diijyaa Lazarus naachįį, gaa vats'ą' hihshyaa ts'ą' khakihih'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Vitsyaa nąįį t'igiiyahnyąą, “K'eegwaadhat, dhichįį t'inchy'aa ji', veenjit gwinzii neegweheelyaa t'inchy'aa.” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Gaa Jesus ąįį Lazarus niindhat nyąą t'inyąą, zhyaa dhichįį yahnyąą t'inyąą giiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ąįįts'ą' łyaa gwinzii gavaa gwaandak, “Lazarus niindhat t'inchy'aa, ");
INSERT INTO gwiNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","gaa nakhweh'an vaa iidi' kwaa eenjit shoo ihłii shik'injahohkhit eenjit. It'ee vats'ą' tr'ahoojyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas (Twin chan oozhii) ąįį ch'izhii Jesus vitsyaa nąįį jyaa ahnyąą, “Geech'ǫąąhtan datthak vaa tr'ahoojyaa, nireheedhaa eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nijin Jesus k'idik dąį', drin dǫǫ gwanaa dąį' hee giiyaahtsii łee. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany kwaiik'it t'ee Jerusalem gwats'ą' mile neekwaii goo'aii, ");
INSERT INTO gwiNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ts'ą' Israel lęįį nąįį Mary, Martha, haa goochaa niindhat geenjit gavaatr'igwigwidii ");
INSERT INTO gwiNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nijin Martha ąįį Jesus ahaa gwiintth'ak dąį' dizheh gwats'an yats'ą' chiinzhii, gaa Mary ąįį zhat gwizhit dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha ąįį Jesus jyaa dahnyąą, “Shik'eegwaadhat, dząą iindi' ji' duuyeh diichaa niighit! ");
INSERT INTO gwiNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Juk zhat Vit'eegwijyąhchy'aa oahkat ji' nik'eegwahahthat gaashandaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","“Nachaa neegweheendaii t'inchy'aa,” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“Drin ndaagwąą'ąį' ji' neegweheendaii ąįį gaashandaii,” Martha yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus jyaa yahnyąą, “Shįį t'ee niindhat nąįį khakihlii tł'ęę neegogwandaii neegoovałtsii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Juu shik'iinjiighit nąįį t'ee nigiindhat ji' gaa neegwigweheendaii giheelyaa. Shik'iinjiighit eenjit khit gweheendaii ts'ą' duuyeh niighit jii nik'ee gwik'iinjinghit?” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Aahą' K'eegwaadhat, Christ, Vit'eegwijyąhchy'aa Vidinji' inlii ts'ą' dząą nankat gwats'ą' hinkhaa naashandaii,” Martha yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ąįįtł'ęę t'ee Martha dizheh nihdineezhii ts'ą' gweentak dijuu Mary oozhrii, “Geech'ǫąąhtan dząą dhidii, ts'ą' nǫh'ya' noonyąą,” jyaa yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nijin Mary gwaak'įį dąį' khan yats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Jesus ąįį kwaiik'it gwats'ą' niighit kwaa nijin Martha yąąh'ya' chy'aa tth'aii hee dhidii.) ");
INSERT INTO gwiNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Nijin ąįį Israel gwich'in yaatr'igwidii nąįį khan chiinzhii giiyąąh'in dąį' giitąįį haajil, tth'ank'it gwats'ą' heekhaa ts'ą' tr'igwiheedii t'ii'in giiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nijin Mary ąįį Jesus ts'ą' tr'iinzhii ts'ą' niyiił'in dąį' yakwai' eeghaii nikiigwiintthaii. “K'eegwaadhat, dząą iindi' ji' duuyeh shachaa niighit!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nijin Jesus, Mary chan ts'ą' tr'igwidii nąįį gwąąh'in ts'ą' adan chan haa tr'igwigwidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Nijin vanǫǫhjik?” goovahnyąą. “Aanaii ts'ą' gwąąh'in!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus iintrii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ts'ą' Israel gwich'in nąįį jyaa ginyąą, “Deegwahtł'oo yeet'iindhan nǫh'in!” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gaa goolat nąįį jyaa ginyąą, “Dinjii vandee kwaa gaa haagweech'in neegwiłtsąįį! Lazarus niheedhaa gwits'į' yits'iheenjyaa shrǫǫ?” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Chan hee gwintł'oo gitr'ii'ee ts'ą' Jesus yatth'ank'it gwats'ą' haazhii, ąįį tth'ank'it kii zhit gweedii ąįį gwadąįį kii dha'aii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Gwadąįį kii gihłeehoh'ąįį!” Jesus gavahnyąą. Lazarus niindhat ąįį veejii Martha jyaa nyąą, “Juk t'ee drin dǫǫ okhwatsii t'inchy'aa, K'eegwaadhat, vatthąį' tr'ahaatsan.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus jyaa yahnyąą, “Gwik'iinjuhkhit ji' Vit'eegwijyąhchy'aa vich'eegwąhndit hǫǫh'yaa nakhwaihnyąą gaanoondaii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gwadąįį kii gihłeegahaa'aii. Jesus yeedak gwąąh'in ts'ą' jyaa nyąą, “Shoodǫǫhk'įį geenjit mahsį', Shiti'. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Khit ts'ą' shoodǫǫhk'įį gaashandaii, gaa jii dinjii nąįį dząą giilk'ii geh'an t'ihnyąą, shohǫǫh'e' ąįį shaagiheendaii eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ąįį jyaa diinyą' tł'ęę gwint'aii khashraa'iintrat ts'ą' jyaa nyąą, “Lazarus, cheehinkhaii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ąįį dinjii niindhat chy'aa chiinzhii, vanli', vakwai' haa gwach'aa vanooljik, vinin kat chan gwach'aa t'inchy'aa. “Gwach'aa vakat gihłeehohłii ts'ą' vanoohjii,” Jesus jyaa gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Israel gwich'in lęįį nąįį Mary haa neegihiidal nąįį Jesus deezhik googwąąh'ya', ts'ą' giik'iinjihkhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gaa goolat nąįį Pharisee nąįį ts'ą' neegahoojil ts'ą' Jesus deezhik geegoovaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ąįįts'ą' t'ee jii Pharisee chan ts'ą' giinkhih kįh dilk'ii nąįį haa Israel gwakhaihkwai' nąįį ts'ą' giginkhe' ąįįtł'ęę jyaa ginyąą. “Deereheelyaa? Gwitr'it geegwaroolii kwaa lęįį t'ii'in! ");
INSERT INTO gwiNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jyąhts'ą' datthak zhyaa tr'ąąh'in ji' juu nąįį datthak giik'iinjiheeghit, ts'ą' Roman gwakhaihkwaii nąįį dząą gwats'ą' giheedaa ts'ą' Kharigidiinjii Zheh Gwachoh chan ts'ą' jii nahkat datthak an googwahahtsyaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gootee dinjii ch'ihłak, Caiaphas, oaazhii ąįį zhat dąį' ndak khii giinkhih choh nilii ąįį jyaa nyąą, “Gaa deegwii'in gaakhwandaii kwaa t'ohnyąą! ");
INSERT INTO gwiNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jii nahkat datthak an gweheelyaa gwits'į' dinjii nąįį eenjit gwizhrįh dinjii ch'ihłak ąįį tr'iiłkhwąįį ji' ts'ąįį gweheezyaa nik'ee gaakhwandaii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Zhyaa t'inyąą kwaa gaandaii gaa zhat dąį' ndak khii giinkhih choh ts'ą' Israel gwich'in nąįį eenjit niheedhaa yaandaii t'iiyahnyąą, ąįį ");
INSERT INTO gwiNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","nąįį zhrįh eenjit kwaa gaa Vit'eegwijyąhchy'aa vigii nąįį, an-nihłik gwa'an gwigwich'įį nąįį ch'ihłak neehahtsyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Izhit drin gwats'an t'ee Israel gwakhaihkwaii nąįį Jesus nats'ąą gahaahkhwaa geegiginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ąįįts'ą' t'ee Jesus gaandaii ts'ą' Judea nahkat gwandah neehidik kwaa, gaa neehoozhii ts'ą' nangwinjir gwa'an kwaiik'it Ephraim gwats'ą' haazhii ts'ą' ditsyaa nąįį haa dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Israel gwich'in nąįį Passover it'ee khaiinjii geenigwiindhat, ts'ą' dinjii lęįį nihky'aa nanhtee gwats'an Jerusalem gwats'ą' gahaajil, Passover gwats'ą' Vit'eegwijyąhchy'aa eenjit shriitr'eedagahaachyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Datthak Jesus keegihi'ik, Kharigidiinjii Zheh Gwachoh gwizhit khaihłan nigiinjil ts'ą' nihłaagwaakat, “Veenjit deeyųųhthan? Łyaa duuyeh dząą gwats'ą' hahaii gwich'in, shrǫǫ ohnyąą?” nihłagaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Pharisee chan ts'ą' giinkhih kįh dilk'ii nąįį haa juu Jesus nah'ya' ji' geegǫǫndak ginyąą, zheegwaazhrąįį nigiihahchyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Passover gwats'ą' drin nihk'iitik gwiizhit Jesus, Bethany kwaiik'it gwats'ą' haazhii, izhit Jesus Lazarus niindhat dąį' ineegwahdaii ąįį zhat gwich'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Izhit giiyeenjit vikeech'iłchy'aa, ts'ą' Martha yeenach'aahtsit, izhit zhat Lazarus vakat ch'ara'aa ts'ą' yaa dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ąįįts'ą' Mary ąįį gwanzhįh gwinzii vagwaatsan chų' oonjik ts'ą' Jesus vakwai' kat t'inlik ąįįtł'ęę dikiighai' haa yach'ahjii ąįį yihił'ee geh'an t'iiyah'in. Ąįį vichų' zheh gwizhit datthak neech'iinthaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jesus vitsyaa ch'ihłak, Judas Iscariot oaazhii ąįįt'ee gwintł'eeyahahchyaa ąįį jyaa nyąą, ");
INSERT INTO gwiNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Jaghaii jii gwanzhįh chų' $300. Denarius vit'ii hohłii kwaa ts'ą' neeshraahchy'aa nąįį antł'ohłii kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Neeshraahchy'aa nąįį eenjit niinjich'adhat kwaa gaa ch'an'įį nilii t'inyąą. Laraa dhah neeha'ak ts'ą' yats'an ch'an'įį t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Gaa Jesus jyaa nyąą, “Mary vihłeehiindii! Shireheetsii drin ji' eenjit yit'eehaahchy'aa t'iiyah'in vaanigwiin'ąįį kwaa! ");
INSERT INTO gwiNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gweedhaa datthak neeshraahchy'aa nąįį gweheelyaa, gaa shįį ąįį khit geenjit nakhwaa hihdyaa kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jews lęįį nąįį Jesus Bethany dhidii gwinyąą gwigwiitth'ak ts'ą' zhat gwats'ą' gahaajil. Jesus eenjit gwizhrįh kwaa gaa Lazarus chan, ąįįt'ee Jesus yineegwahdaii reh. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ąįįts'ą' giinkhih kįh dilk'ii nąįį Lazarus chan gahaahkhwaa eenjit gwigwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Deezhik veh'an Jews kįh dilk'ii nąįį akhagoonyąą ts'ą' dinjii lęįį nąįį teehaajil geh'an Jesus k'injigiighit. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ąįįtł'ęę gęhdaa drin dinjii lęįį nąįį Jesus Jerusalem gwats'ą' ahaa gwinyąą gwigwiitth'ak eenjit zhat Passover giilk'ii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ąįįts'ą' t'ee ts'iivii Palm ąįį vachan kwaii goonjik ts'ą' giidivee haajil, gazhral ts'ą' jyaa ginyąą “Hosanna! Juu K'eegwaadhat voozhri' zhit ahaa ąįį Vit'eegwijyąhchy'aa vaa oolį'! Israel gwi-King Vit'eegwijyąhchy'aa vaa oolį'!” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus łąįį choh tsal (Donkey) agwąh'ąįį kat daandii, Dęhtły'aa Choh zhit jyaa deegwiinyą' gwik'it: ");
INSERT INTO gwiNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Zion kwaiik'it gwachoo gwich'in nąįį, noojat shrǫ'! Et'ee nakhwa-King nakhwats'ą' ahaa, łąįį choh tsal (Donkey) kat doodii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Vitsyaa nąįį deegwinyąą t'igwinyąą gaagiindaii kwaa. Gaa nijin Jesus neegwiindaii dąį' Vit'eegwijyąhchy'aa vich'eegwąhndit yintł'eiin'ąįį Dęhtły'aa Choh kat jyaa deegwinyąą, ąįįts'ą' giiyeenjit jyaa diizhik gineegaanjik. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lazarus tth'ank'it gwizhit gwats'an Jesus yineegwahdaii dąį' juu andah t'iizhik nąįį deezhik geegoogwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ąįį geenjit t'ee giits'ą' haajil gwitr'it geegwaroolii kwaa t'iizhik giiyeegwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ąįįts'ą' t'ee Pharisee nąįį jyaa nihłagaanyąą, “Gooh'in, łyaa gaayiich'arahtsii kwaa! Gooh'in, jii nahkat datthak giitąįį hijyaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Juu Jerusalem gwizhit Passover gwats'ą' haajil ts'ą' khadigigeheejyaa eenjit nąįį tee gwa'an Greek nąįį dilk'ii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Philip ts'ą' (Bethsaida kwaiik'it Galilee nahkat gwats'an ahaa) nigiinjil ts'ą' jyaa giiyahnyąą, “Jesus tr'ǫǫh'ya' tr'oonyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip ąįį Andrew ts'ą' haazhii, ts'ą' nihłaa Jesus ts'ą' gahaa'oo ts'ą' Jesus haa googwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus jyaa goovahnyąą, “Et'ee juk Gwidinji' vich'eegwąhndit vintł'eerehee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Łi'didlii haa nakhwaagwahaldak! Tł'ooli' tsal naadhak ts'ą' nan zhyaadhak ąįįtł'ęę an ilik gwik'it neet'eehaldhak ts'ą' nihihthaa, an dhidlit ji', tł'ooli' lęįį vats'an haahshii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Juu dagwandaii zhrįh hił'ee ji', an heelyaa. Juu dagwandaii hił'ee kwaa ji' khit geenjit gwandaii hee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Juu sheenjit gwitr'it t'agoh'ya' niindhan ji' shatąįį heekhaa gwizhrįh, shitsyaa heelyaa ts'ą' nijin dhidii shaa heedyaa eenjit. Shiti', juu shaa t'inchy'aa hił'ee t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Et'ee łyaa shidrii zhit tr'igwidii dha'aii gaa reh deehihjyaa gǫ'? ‘Shiti', jii kwaii shats'ą' t'agǫǫ'ya' shrǫ'!’ Gaa ąįį geenjit dząą gwats'ą' hoiizhii, khaiinjich'ashahadhat gwahaał'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Shiti', Noozhri' hil'ee ąhtsii!” Ąįįtł'ęę zheekat gwats'an khagiriinkhee, “Hil'ee dhałtsąįį ts'ą' chan jyaa dineehihłyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ąįį zhat dilk'ii nąįį zheekat gwats'an girinkhii gwigwiitth'ak ts'ą' jyaa ginyąą, “Nagoahtan lee t'igwinyąą? Ch'izhii nąįį chan zheekat gwich'in yats'ą' ginkhii t'inyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Gaa Jesus jyaa gavahnyąą, “Jii girinkhii goohtth'ak sheenjit t'igwinyąą kwaa gaa nakhwan ąįį nakhweenjit t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Et'ee juk jii nankat Ch'aroohahkat Drin nigwiindhat Ch'anky'aa Tr'aanduu kįh dhidii ąįį charahahchyaa gwik'it t'ishi'in shi'in. It'ee neerahoojyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nijin nankat gwats'an deeshiriłchįį ts'ą' sharoołkhwąįį ji' juu nąįį tthak shats'ą' giheedaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Nats'ąą khaiinjich'iheedhaa ts'ą' niheedhaa ąįį geegwaandak t'inyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Zhat dilk'ii nąįį jyaa ginyąą: “Dęhtły'aa Choh zhit Christ khit geenjit gweheendaii gwinyąą. Nats'ąą Gwidinji' ndak deerahahchyaa deenyąą t'iinyąą? Gwidinji' ąįį juu t'arahnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus jyaa gavahnyąą “Tth'aii gwintsal gwizhrįh nakhwaa ch'ahałdrii t'oonchy'aa. Tǫǫ gweheelyaa gwehkįį deekhwa'yaa goo'aii gwik'it t'akhwa'in. Nakhwaa tǫǫ nagwahaadhal gwits'į'. Juu tǫǫ gwizhit dinjii nilii t'ee nijuk ahaa gaaheendaii kwaa geh'an ");
INSERT INTO gwiNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tth'aii drin gwanlii dąį' vat'oohchy'aa. Khit naa ch'ahaadrii eenjit.” Jesus jyaa diinyą' ąįįtł'ęę t'oołii neehoozhii ts'ą' goh'it idiildii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gwitr'it geegwaroolii kwaa lęįį gavandah t'iizhik googaa giik'iinjiighit kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isaiah, Vit'eegwijyąhchy'aa Eenjit Ginkhii nilii ąįį jii kwaii łi'didlii heelyaa nyąą: “K'eegwaadhat, juu yik'injiheeghit? Juu yat'aii nah'ya'?” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Khyų' giik'iinjiighit geh'an Isaiah jii jyaa diinyą': ");
INSERT INTO gwiNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Vit'eegwijyąhchy'aa goovaagweech'in kwaa gwiłtsąįį, niinjich'agadhat kwaa gooviłtsąįį, goovaagweheechy'aa kwaa eenjit, googwandaii ninjich'iheedhat kwaa, Duuyeh goots'ą' tr'ihihdal eenjit shats'ą' gihijyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah, Jesus vich'eegwąhndit gwąąh'ya' geh'an jyąhts'ą' yeeginkhii t'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Zhit dąį' Israel kįh dilk'ii lęįį nąįį giik'iinjiindhat gaadlit gaa Pharisee nąįį anagogwaah'įį, Israel nąįį tr'igiinkhii zheh chagoorahahchyaa, kwaa gwits'į'. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Dinjii deenyąą ąįį gwik'it geedaa ts'ą' Vit'eegwijyąhchy'aa deenyąą ąįį gwik'it geedaa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus gwint'aii khaginkhee ts'ą' jyaa nyąą, “Juu shik'injiighit t'ee shįį zhrįh shik'injiighit kwaa gaa juu shihił'e' chan k'injiighit t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Juu shąąh'in t'ee juu shihił'e' chan nah'in t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jii nankat gava aadrii ihłii ts'ą' gwats'ą' hoiizhii, ąįįts'ą' juu shik'injiighit ji' duuyeh tǫǫ dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Juu shiginjik diitth'ak gaa gwik'eegwahthat kwaa ji', duuyeh an ałtsii eenjit gwantł'ałchįį. Dinjii an hałtsyaa eenjit nankat gwats'ą' hoiizhii kwaa, gaa dinjii neehałshii eenjit gwizhrįh. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Juu shaa t'inchy'aa kwaa ts'ą' shiginjik diitth'ak kwaa ąįįt'ee an yahahtsyaa veenjit dhidii. Khaiinkǫǫ Drin ndaanąą'ąį' ji' deihnyą' t'ee an yahahtsyaa! ");
INSERT INTO gwiNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aahą', jii deihnyą' ąįį shįį zhrįh shats'an t'igwinyąą kwaa gaa Gwiti' shihił'e' ąįį deiinyąą shahnyąą gwik'it giihkhii t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Viginjik k'iighai' t'ee khit gwireheendaii. Deihnyą' datthak t'ee Gwiti' deiinyąą shahnyąą gwik'it giihkhii t'ihnyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","It'ee Passover ch'arehee'aa gwats'ą' drin nigwiindhat. It'ee Jesus vidrin eenigwiindhat ts'ą' jii nankat gihłeeheekhaa ts'ą' Gwiti' ts'ą' heekhaa gaandaii. Dzaa nankat juu yaa t'iinchy'a' nąįį eet'iinghya' ts'ą' ndaagwąą'ąį' gwats'ą' gooveet'iindhan. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesus ditsyaa nąįį haa khaa neech'aga'aa. Ch'anky'aa Tr'aanduu ąįį Simon Iscariot vidinji' Judas ąįį ch'adąį' hee Jesus gwintł'eehahchyaa gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus ąįį Gwiti' t'aih datthak yintł'eiin'ąįį gaandaii; Vit'eegwijyąhchy'aa ts'an tr'iinzhii ts'ą' Vit'eegwijyąhchy'aa ts'ą' heekhaa gaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ąįįts'ą' Jesus vakaii'aa ts'an ndak nidhikhin, ts'ą' ankhii dagwach'aa gihłeehaalii, ts'ą' dohshroo dazhrak tł'an diłchaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ąįįtł'ęę vizhit neech'araanjii zhit chųų gwizhinjaa ts'ą' ditsyaa nąįį kwai' k'eech'ąhtryaa ąįįtł'ęę ąįį dazhrak tł'an dohshroo haa gooch'ahjii. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Peter ts'ą' niinzhii, ąįį t'iiyahnyąą, “Shik'eegwaadhat, shakwai' k'eech'ahąhtryaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus t'iiyahnyąą, “Juk deeshi'in gaakhwandaii kwaa, gaa nahgwan gaakhwahandaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter t'iiyahnyąą, “Duuyeh, ch'ihłok, gaa shakwai' k'eech'ąhtryaa t'oonchy'aa!” Jesus t'iiyahnyąą, “Nakwai' k'eech'ałtryaa kwaa ji', shitsyaa neenilyaa kwaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter t'iiyahnyąą, “Shik'eegwaadhat, shakwai' zhrįh k'eech'ohtryaa shrǫ'! Akwat, shanli' chan ts'ą' shiki' haa chan k'eech'ąhtryaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus t'inyąą, “Juu gwinzii dik'eech'aahtryaa t'ee vakat shrąįh kwaa ts'ą' dik'ineech'aatryaa t'ee vakat shrąįh kwaa ts'ą' dik'ineehaatryaa gwat'aahchy'aa kwaa, vakwai' zhrįh. Datthak nakhwakat shrąįh kwaa nakhwatee ch'ihłak zhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus ch'adąį' hee gootee juu gwintł'eeyahahchyaa gaandaii, ąįį geh'an jyaa nyąą, “Datthak nakhwakat shrąįh kwaa gaa ch'ihłak zhrįh.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Datthak gookwai' k'eech'ąhtryaa tł'ęę Jesus ankhii dagwach'aa neenaazhii ts'ą' vakaii'aa ts'ą' neenakhwadii. “At'ohju' deenakhwiilik deeshi'in nik'ee gaakhwandaii?” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Shigeech'ǫąąhtan chan ts'ą' Shik'eegwaadhat shohnyąą, ąįįt'ee gwinzii t'oohnyąą, ąįį adan t'ihchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nakhwak'eegwaadhat, nakhwageech'ǫąąhtan ihłii, ts'ą' at'ohju' nakhwakwai' k'eech'ałtryaa. Nakhwan chan, nihłakwai' k'eech'ohtryaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Shik'it t'akhwa'yaa eenjit t'ishi'in, nakhweenjit deeshizhik gwik'it t'akhwa'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Łi'didlii haa nakhwaagwahaldak, slaves ąįį dinjii yits'ą' k'eegwaadhat ąįį andaa hil'ee kwaa; dinjii hil'e' ąįį juu yihił'e' andaa veegoo'aii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","It'ee łi'didlii haa khwandaii: izhit gwik'it t'akhwa'in ji' gwintł'oo shoohohłyaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Datthak nakhweegihkhii t'ihnyąą kwaa; ąįį juu nąįį teegǫǫłjik nąįį haashandaii. Gaa jii Dęhtły'aa Choh zhit deegwiinyą' gwik'it t'igiheenjyaa eenjit, ‘Dinjii juu shishii in'al t'ee shits'į' t'iheechy'aa.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jii gwik'it t'igweheenjyaa gwehkįį juk nakhwaagwaldak t'ihnyąą, ąįįts'ą' nijin gwik'it t'igwiizhik ‘Juu Ihłii Ąįį Ihłii!’ gwik'iinjuhohkhit geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jii t'ee łi'didlii: juu vats'ą' ch'ahooł'e' ąįį k'injiighit ąįįt'ee shik'iinjiighit, ąįį juu shik'iinjiighit, t'ee juu shihił'e' ąįį k'injiighit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus jyaa diinyą', ąįįtł'ęę łyaa tr'igwidii, ts'ą' gwinzii akǫǫ t'agoovahnyąą: “Łi'didlii haa nakhwaagwaldak: nakhwatee ch'ihłak gwintł'eeshahahchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Datthak nihłitee googwąąh'in ts'ą' juu t'ahnyąą ąįį gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Vitsyaa nąįį tee juu Jesus yeet'iindhan ąįį yeeghaii dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ąįį dinjii ąįį Simon Peter t'iiyahnyąą, “Juu t'ahnyąą ąįį geenjit oahkat lee?” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ąįį dinjii Jesus eeghaii naadii ts'ą' yuahkat, “Shik'eegwaadhat, juu t'aiinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus t'iiyahnyąą, “Łųhchy'aa teehałchaa ts'ą' vintł'eehałchaa, ąįį dinjii t'aihnyąą.” Ąįįts'ą' t'ee łųhchy'aa oonjik ts'ą' teeyahtsit ts'ą' Simon Iscariot viinji' Judas intł'eeyahtsit ");
INSERT INTO gwiNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas łųhchy'aa oonjik googwahkhan Satan vizhit diindhat. Jesus jyaa yahnyąą, “Khan deehini'yaa goo'aii gwik'it t'ini'in!” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ąįį vakaii'aa ts'ą' yaadilk'ii nąįį ch'ihłak gaa Judas jaghaii t'inyąą giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ąįį laraa k'ąąhtii nilii ts'ą' Jesus vitsyaa lat nąįį ch'ara'aa drin eenjit ch'oiinkwat yahnyąą giiyuunyąą, ąįį akwaa ji' neeshraahchy'aa nąįį ts'iinyąą yahnyąą giiyuunyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Khaa gwanlii ts'ą' Judas łųhchy'aa oonjik tł'ęę zhat cheehoozhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cheehoozhii ąįįtł'ęę, Jesus jyaa nyąą, “It'ee Gwidinji' vich'eegwahdrii gwizhrįh nagwaatth'at. It'ee Gwidinji' vik'iighai' Vit'eegwijyąhchy'aa vich'eegwahdrii gwizhrįh nagwaatth'at. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ąįįts'ą' vik'iighai' Vit'eegwijyąhchy'aa vich'eegwahdrii gwizhrįh nagwaatth'at ji', zhazhat Vit'eegwijyąhchy'aa adakhai' Gwidinji' vich'eegwahdrii gwizhrįh nigwehee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Shigii nąįį, it'ee niighit kwaa gwizhrįh nakhwaa t'ihihchy'aa. Shinkeegahoo'yaa gaa Jews nąįį deegavaiinyą' juk nakhwaagwaldak, ‘Nijuk hihshyaa duuyeh gwats'ą' hohjyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jii t'ee juk gwizhrįh nakhwaa gwahaldak jyaa khwa'in nakhwaihnyąą, nakhwatee googwąąnchy'aa ts'ą' nihłeenjit ch'eet'igwiniindhan khwa'įį. Nakhweenjit ch'eet'igwiniindhan shi'įį, ts'ą' nakhwan chan nihłeenjit ch'eet'igwiniindhan khwa'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ch'eet'igwiniindhan nihłeenjit khwa'įį ji', juu nąįį datthak shitsyaa ǫhłįį nakhwaaheendaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","“K'eegwaadhat, nijin gwats'ą' hiinkhaii?”, Simon Peter yahnyąą. “Nijin gwats'ą' hihshyaa duuyeh gwats'ą' hinkhaii t'oonchy'aa,” Jesus yahnyąą, “Gaa nahgwan ji' hee shatąįį hinkhaa t'oonchy'aa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","“K'eegwaadhat, jaghaii juk naahihshyaa kwaa gǫ'?” Peter nyąą. “Neenjit nihihthaa ji' gaa,” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus t'iiyahnyąą, “Łyaa sheenjit nihiindhaa ji' gaa lee t'iinyąą? Łi'didlii haa nakhwaagwahaldak: vanh rooster khakeehee'aa gwehkįį tik łąą shaanandaii kwaa hinjyaa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nakhwadrii zhit tr'agohdii ts'ą' nakhweenjit goozųų shrǫ'!” Jesus gavahnyąą. “Vit'eegwijyąhchy'aa vik'injuhkhit, ts'ą' shįį chan shik'iinjuhkhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Shiti' vizheh gwizhit gwintsii, ts'ą' izhit nakhweenjit shrigwihihłyaa. Jyąhts'ą' nakhwadivee goo'aii kwaa ji' duuyeh jyaa nakhwaihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ąįįts'ą' hoiizhii ąįįtł'ęę izhit nakhweenjit shrigwiilik ąįįtł'ęę, oo'ee neehihdyaa ts'ą' adahaa nakhwahaalchyaa, nijin t'ihchy'aa izhit shaa t'ahohchy'aa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Nijin gwats'ą' hihshyaa ąįį nats'ąą gwats'ą' hohdaa gaakhwandaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas jyaa yahnyąą, “K'eegwaadhat, nijin gwats'ą' hinkhaa t'iinyąą, gaagwiindaii kwaa. Nats'ąą gaagweheendaii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus t'iiyahnyąą, “Shik'iighai' shatąįį gwats'ą' hohdaa t'igwinyąą, łi'didlii ihłii, gwandaii ihłii; shik'iighai' gwizhrįh dinjii Gwiti' ts'ą' niheehaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","It'ee shaakhwandaii akwat Shiti' chan vaakhwahandaii ts'ą' juk gwats'an vaakhwandaii hohłyaa, nǫh'ya' t'inchy'aa.” Jesus gavahnyąą ");
INSERT INTO gwiNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip jyaa yahnyąą, “K'eegwaadhat, Gwiti' diits'ą' agwąąhkįį; ąįį gwizhrįh gwit'eegwaahchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus jyaa nyąą, “Łyaa niighyuk nakhwaa t'ihchy'aa gwiizhit tth'aii shaakhwandaii kwaa Philip? Juu shaa'ya' t'ee gwiti' chan nah'ya' t'oonchy'aa. Jaghaii gwiizhit ‘Gwiti' diits'ą' agwahch'in!’ diinyąą? ");
INSERT INTO gwiNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Gwiti' vizhit t'ihchy'aa ts'ą' Gwiti' shizhit t'inchy'aa ąįį nik'ee gwik'iinjinghit Philip? Jidii ginjik nakhwats'an dhałtsąįį t'ee shats'an t'igwinyąą kwaa. Gwiti' shizhit t'inchy'aa ąįį digwitr'it t'agwah'in t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Gwiti' vizhit t'ihchy'aa ts'ą' Gwiti' shizhit t'inchy'aa ąįį gwik'iinjuhkhit. Akwaa ji', gwitr'it geegwaroolii kwaa t'agwał'in gǫǫh'ya' gwik'iighai' gwik'iinjuhkhit. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Łi'didlii haa nakhwaagwahaldak, juu shik'iinjiighit ąįį chan jidii gwitr'it t'agwał'ya' gwik'it t'ihee'yaa. Aahą', shandaa gaa gwitr'it t'agwahah'yaa. Shįį ąįį Gwiti' vats'ą' hihshyaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ąįįts'ą' jidii shoozhri' zhit ach'oohkat datthak gwik'it gweheelyaa gwahałtsyaa. Gwidinji' vik'iighai' Gwiti' vich'eegwahdrii gwigweheechy'aa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Shoozhri' zhit jidii ach'oohkat, nakhwak'it shi'yaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Sheenjit ch'eet'igwiniindhan khwa'įį ji', Vit'eegwijyąhchy'aa shiginjik k'eegohohthat t'akhwa'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Gwiti' nakhweenjit oohaałkat ts'ą' nakhwats'eheenjyaa nakhwats'ą' niheehaa, ąįįt'ee Ch'anky'aa Shroodiinyąą łi'didlii t'arahnyąą. Ąįį khit ts'ą' nakhwaaheelyaa. Jii nankat dinjii nąįį an-giihaa'aa, giiyąąh'in kwaa ts'ą' giiyaandaii kwaa geh'an. Gaa nakhwan'ąįį vaakhwandaii. Juk nakhwaa t'inchy'aa ts'ą' nakhwazhit t'iheechy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Duuyeh akhanahoihnyąą; nakhwats'ą' neehihdyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","It'ee niighit kwaa jii nankat gihłeehihshyaa gaa khit nakhwaahihłyaa, ts'ą' chan neegwihįhdaii ts'ą' nakhwan chan neegohǫhdaii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Izhit drin ji' Gwiti' vizhit t'ihchy'aa ts'ą' nakhwan chan shizhit t'ohchy'aa, ts'ą' nakhwazhit t'ihchy'aa gwik'eehoondal t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Juu ch'iitth'ak ts'ą' shik'eegwahthat, ąįįt'ee sheenjit ch'eet'igwiniindhan di'įį. Juu sheenjit ch'eet'igwiniindhan di'įį t'ee Shiti' chan yeenjit ch'eet'igwiniindhan di'įį. Shįį chan veenjit ch'eet'igwiniindhan shi'yaa ts'ą' vats'ą' adagwahaalkyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas Iscariot ąįį kwaa gaa ch'izhii Judas ąįį jyaa yahnyąą, “K'eegwaadhat, jaghaii diits'ą' adagwahaankyaa gwiizhit jii nankat ąįį kwaa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus t'iiyahnyąą, “Juu sheenjit ch'eet'igwiniindhan di'įį t'ee shiginjik k'eegwahahthat. Shiti' chan yeenjit ch'eet'igwiniindhan hee'yaa, ts'ą' Shiti', shįį haa vats'ą' nirehee'al ts'ą' vizhit t'igweheechy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Juu sheenjit ch'eet'igwiniindhan di'įį kwaa t'ee duuyeh shiginjik k'eegwahthat. Jii jyaa danakhwaihnyąą t'ee shats'an t'inchy'aa kwaa gaa Gwiti' shihił'e' vats'an t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Tth'aii nakhwaa dhiidii dąį' jii kwaii nakhwaagwaldak t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ch'anky'aa Shroodiinyąą gwits'inyaa nilii ts'ą' shoozhri' zhit Gwiti' yahah'aa ąįį jidii datthak geegavąąhtan ts'ą' deenakhwaiinyą' datthak gineehoondaii nakhwahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tsinehdan nakhwaa akhoohįįhjyaa; shats'an tsinehdan nakhwantł'eehihłyaa. Ąįį tsinehdan jii nankat duuyeh gwintł'eeyah'ąįį t'arahnyąą gaa shįį ąįį ts'anhan'yaa eenjit nintł'eehih'aa. Tr'agohdii ts'ą' nakhwayinji' zhit goozųų shrǫ', noojat shrǫ'. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jii jyaa nakhwaiinyą' shoodǫǫhk'į', ‘Neehihdyaa gaa nakhwats'eehihdyaa.’ Sheet'ǫhthan ji', Gwiti' vits'eehihdyaa geenjit shoohohłyaa, shandaa veegoo'aii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jii deegweheenjyaa diinyą' ąįį gwik'it gweheelyaa gwats'ą' nakhwaagwaldak t'ihnyąą, gwik'it goodlit ji' gwik'iinjuhohkhit geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","It'ee nahgwan gwizhrįh nakhwaa neegihihjyaa. Jii nankat gwizhrįh gwakhaihkwaii choh ahaa. Shandaa t'aih di'įį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Gaa jii nankat dinjii nąįį datthak Gwiti' veet'iihthan gaageheendaii gwizhrįh; ąįį geh'an jidii doo'ya' shoonyąą datthak gwik'it t'ishi'in shi'in. “It'ee neerahoojyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Shįį t'ee łyaa gwanzhįh vakat gwąąhshii t'ihchy'aa, ąįįts'ą' Shiti' chan gwanzhįh nahshii nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jidii shakat gwanzhįh dachan gwinzii nahshii kwaa t'ee gihłeehaht'aa, jidii shakat gwinzii vakat gwąąhshii t'ee gwinzii k'ąąhtii ts'ą' shriiyuunyąą ąįįt'ee vakat gwanzhįh lęįį neehaanzhii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Gwandak nizįį eenakhwaagwadhaldak ąįį haa ch'adąį' hee shroodiinyąą dhoodlit t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Khit shaa ǫhłįį ts'ą' shįį chan khit nakhwaa hihłyaa, gwanzhįh dachan ch'ihłak duuyeh adakhai' gwąąhshii. Vakat gwanzhįh nahshii, vadachan lęįį khaihłok nahshii ji' gwizhrįh. Izhit gwik'it shaa ǫhłįį ji' gwizhrįh nakhwats'an gwahąąhshįį k'it t'igwehee'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Jak vakat nahshii ihłii, nakhwan chan jak t'an ǫhłįį. Juu shaa nilii t'ee vaa ihłii ts'ą' vats'an gwąąhshii; shehdan ji' duuyeh. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Juu shaa nilii kwaa t'ee charahahchyaa, jak dachan akharoonyąą ts'ą' dhagaii gwik'it; ąįį k'it t'inchy'aa jak dachan t'ee khaihłan nirilii ts'ą' kǫ' zhit tr'ahk'an t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Shiginjik ohtą' ts'ą' shaa ǫhłįį ji', jidii ach'oohkat datthak nakhwats'an hałtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jyąhts'ą' t'ee Shiti' vich'eegwahdrii gwigweech'in t'agwarahnyąą, gwintł'oo nakhwats'an gwąąhshii, jyąhts'ą' t'ee shitsyaa hohłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Shiti' sheet'iindhan gwik'it shįį chan nakhweenjit ch'eet'igwiniindhan shi'įį. Shich'eet'igwiniindhan zhit gǫhdaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Shiginjik k'eegohthat ji', shich'eet'igwiniindhan zhit t'ahohchy'aa. Shiti' viginjik k'eegwałthat ts'ą' vee ch'eet'igwiniindhan zhit t'ihchy'aa gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Sheeshroonchy'aa nakhwazhit t'iheechy'aa ts'ą' nakhwazhit ch'eeshroonchy'aa deedahaan'ai' eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Shiginjik zhit jyaa digwinyąą gwik'it t'ohchy'aa, nihłeet'oohthan, nakhweet'iindhan gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Dinjii dijyaa, nąįį haa eenjit oo'an dahaachyaa t'ee łyaa vee ch'eet'igwiniindhan nitsii t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Shiginjik k'it ohdaa ji' shijyaa hohłyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Et'ee chan duuyeh dinjii vitsyaa yeetr'agwah'in neehanzhok k'it t'anakhwahał'yaa kwaa, ąįį ch'itsyaa dee'in t'ii'in yaaheendaii kwaa eh'an. Shijyaa ąįį nakhwahaihjyaa, jidii Shiti' vats'an gwiitth'ak datthak geenakhwaagwaldak geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Shįį ąįį gwitee tr'ashǫǫhchįį kwaa gaa shįį ąįį gwitee tr'anakhwaałchįį ts'ą' nakhwats'an gwanzhįh haahshii. Ąįį gwanzhįh khit ts'ą' gweheendaii. Ąįįts'ą' shoozhri' zhit jidii ach'oohkat Gwiti' nats'an yahahtsyaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Izhit geenjit jii jyaa danakhwahihjyaa, nihłeenjit ch'eet'igwiniindhan khwa'įį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Juu nan dha'aii ąįį nitr'ii'ee ji', shįį tr'ookit sheet'igiinghya' kwaa jyaa gineehandaii yuu. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jii nankat ts'an inlii ji', vats'an iinlii ts'ą' geh'an neet'iheenghyaa. Gaa shįį ąįį jii nankat gwats'an gwitee tr'anąąłchįį ts'ą' jii nankat gwats'an iinlii kwaa. Ąįį geh'an jii nankat nitr'ii'ee t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jii deenakhwaiinyą' gineehoondaii yuu, ‘Dinjii vitsyaa yeetr'agwah'in ts'ą' neeyahanzhok ąįį yandaa ts'ą' veegoo'aii kwaa t'oonchy'aa.’ Khaiinjich'ishiriłthat ji', nakhwan chan gwik'it t'ahoh'yaa. Shiginjik k'eegwigwiłthat ji', nakhwaginjik chan k'eegogwahahthat t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Gaa shats'an ǫhłįį geh'an jyaa nakhwagahah'yaa; juu shihił'e' ąįį gaagiindaii kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Dząą gwats'ą' hoiizhii ts'ą' goots'ą' giihkhe'. Akwaa ji' duuyeh datr'agogwaanduu gwizhrįh nagogwa'aii, ąįį geh'an datr'agogwaanduu eenjit deegiheenjyaa gaa gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Juu sheet'iindhan kwaa chan Shiti' eet'iindhan kwaa t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Gooteegwitr'it t'agwał'ya' kwaa ji' duuyeh datr'agogwaanduu oo'an gwigwihilii, izhit duuyeh gaa t'igwee'ya' kwaa t'oonchy'aa izhit geh'an deeshi'ya' googwąąh'ya' ts'ą' Shiti' shįį haa diitr'igii'ee. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gaa jii łyaa gwik'it t'igweheenjyaa goo'aii, goo-law zhit deegwinyąą gwik'it gweheelyaa eenjit, ‘geenjit gwakwaa shitr'ii'ee,’ ");
INSERT INTO gwiNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Gwits'inyaa k'eeheedik, ąįįt'ee Gwiti' vats'an Ch'anky'aa łi'didlii nilii. Gwiti' vats'an nakhwats'ą' nihih'aa ts'ą' sheegwahaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ąįįts'ą' nakhwan chan, sheegohoondak tr'ookit dąį' gwats'an shaa ǫhłįį geh'an.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Teehohdaa gwits'į' jii kwaii naagwaldak t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Israel gwich'in nąįį ditr'igiinkhii zheh gwats'an kwaii cheenagahahchyaa. Ąįįts'ą' juu nęhdaa tr'igwiin'ąįį chan Vit'eegwijyąhchy'aa vaa ihłii shi'in heenghyaa ąįį chan gwats'ą' gweedhaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Shįį akwat Gwiti' haagiindaii kwaa geh'an jii kwaii jyaa danagahah'yaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Gaa nijin jii kwaii jyaa danahah'yaa nigwiindhat ji' gaanahandaii ts'ą' naagwaldak chy'aa gineehandaii eenjit. Tr'ookit naa iidi' dąį' jii kwaii geenaagwaldak kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Juk juu shihił'e' ąįį vits'eehihdyaa; gaa nakhwatee ch'ihłak gaa jii shǫąąhkat kwaa, ‘Nijin gwats'ą' hinkhaa?’ ");
INSERT INTO gwiNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","It'ee nakhwaagwaldak, ts'ą' nakhwadrii zhit tr'igwidii dha'aii. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gaa jii t'ee łi'didlii haa nakhwaagwaldak: hoiizhii ji' gwizhrįh nakhwadiveegweheezyaa. hoiizhii kwaa ji', Ch'anky'aa Shroodiinyąą gwits'inyaa duuyeh nakhwats'ą' hahaii. Gaa shįį hoiizhii ji' t'ee nakhwats'ą' nahałchyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ąįįts'ą' nijin k'idik ji', jii nankat gwidinjii nąįį gootr'agwaanduu gwiizųų t'igii'in gaagavahąhdaii, ąįįts'ą' nats'ąą gootr'agwaanduu gweheezyaa chan gaagavahąhdaii, nats'ąą neegeheezhii akwat goorahahkat drin nigweheedhaa chan eenjit gaagavahąhdaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Shik'iinjigiighit kwaa geh'an gootr'agwaanduu gwanlii ąįį giizųų, ts'ą' ");
INSERT INTO gwiNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","jidii gwinzii ginyąą chan zhyaa t'iginyąą, Gwiti' vats'ą' hihshyaa ts'ą' neeshahǫǫ'yaa kwaa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ts'ą' Ch'aroohahkat Drin geenjit chan, jii nankat Ch'anky'aa Tr'aanduu gwats'ą' k'eegwaadhat, ch'adąį' hee gwizhrįh narąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Łyaa tth'aii gwinlęįį eenjit nakhwaagwahaldak gaa tr'ihkhit lęįį ts'ą' gineehoondaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gaa nijin Ch'anky'aa Shroodiinyąą łi'didlii nilii k'idik ji' łi'didlii zhit gwizhrįh t'ahohchy'aa. Adan zhrįh vats'an t'igwinyąą kwaa gaa jidii gwehkįį gwiitth'ak akwat yeendaa deegweheenjyaa kwaii geegwahaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Deenakhwaiinyą' datthak geenakhwaaneegwahaandak jyąhts'ą' t'ee ch'agwąhdit shintł'eegwehee'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jidii Shiti' vats'an nilii jii datthak chan shats'an; ąįį geh'an t'ee Ch'anky'aa Shroodiinyąą jidii vintł'eegwiriin'ąįį datthak geenakhwaaneegwahaandak t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“It'ee nahgwan chan neeshahǫǫ'yaa kwaa; ąįįtł'ęę gwats'an nahgwan chan neeshahǫǫ'yaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Vitsyaa lat nąįį jyaa nihłagaanyąą, “Deiinyąą t'inyąą li'? Jyaa diinahnyąą, ‘It'ee nahgwan chan neeshahǫǫ'yaa kwaa ts'ą' ąįįtł'ęę gwats'an nahgwan chan neeshahǫǫ'yaa.’ Jii chan jyaa nyąą, ‘Gwiti' vats'ą' hihshyaa geh'an.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“‘Jii nahgwan it'ee,’ nyąą ąįį deenyąą t'inyąą?” Nihłagaanyąą, “Jidii eeginkhii t'inyąą vaagwiindaii kwaa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesus ąįį giiyuuhkat giindhan gavaandaii ts'ą' jyaa gavahnyąą, “Jyaa nakhwaiinyą', ‘It'ee nahgwan chan neeshahǫǫ'yaa kwaa ąįįtł'ęę gwats'an nahgwan chan neeshahǫǫ'yaa.’ Jii geenjit nihłookat lee t'ohnyąą? ");
INSERT INTO gwiNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jii t'ee łi'didlii haa nakhwaagwahaldak, hohtree ts'ą' tr'agohohdii, gaa jii nankat gwich'in nąįį shik'injiighit kwaa nąįį geenjit shoo heelyaa, tr'agohohdii gaa shoo ąįį neeheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nijin tr'injaa tr'iinin haa iłts'ik dąį' khaiinjich'iighit ts'ą' vaa shroonchy'aa kwaa. Gaa nijin tr'iinin igwilik ąįįtł'ęę khaiinjich'iighit chy'aa ganaandee, vigii nankat niinzhii eenjit shoo nilii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ąįį geh'an juk tr'agohdii ts'ą' nakhwaa shroonchy'aa kwaa t'oonchy'aa, gaa chan neenakhwahaal'yaa ts'ą' nakhwadrii zhit shoo neehee'aa, ąįį shoo t'ee duuyeh nakhwałeeraha'aii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Izhit zhat drin nigwiindhat ji' shahohkat kwaa. Łi'didlii haa nakhwaagwahaldak, shoozhri' zhit Gwiti' jidii eenjit oohkat nakhwats'an hahtsyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Gwehkįį shoozhri' zhit tth'aii ch'oohkat kwaa akwat: jidii ach'oohkat ąįį nik'eegwahaadhat t'oonchy'aa, shoh nakhwazhit deedahaa'aii t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Jii kwaii t'ee gwandak zhit geenakhwaagwaldak t'ihnyąą. Gaa zhat nigwiindhat ji' duuyeh gwandak zhit nakhwaagwaldak, gaa juk Gwiti' gwinzii nakhwąnin ts'ą' veegihihkhyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Izhit drin nigwiindhat ji' shoozhri' zhit oohohkat; nakhweenjit oohaałkat t'ihnyąą kwaa, ");
INSERT INTO gwiNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Gwiti' nakhweet'iindhan geh'an. Sheet'ǫhthan akwat Vit'eegwijyąhchy'aa vats'an ihshyaa ąįį gwik'iinjuhkhit geh'an nakhweet'iindhan. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gwiti' vats'an ihshyaa ts'ą' nankat gwats'ą' hoiizhii; ąįįts'ą' it'ee nankat gihłeehihdyaa ts'ą' Gwiti' vits'eehihdyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ąįįts'ą' vitsyaa nąįį jyaa giiyahnyąą, “Gwąąh'in, gwandak zhit nakwaa gaa gwinzii diinin ts'ą' diinaa goondak. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Juk it'ee jidii datthak gaanandaii gwik'igwaanjik; ts'ą' naroahkat gaa gwit'eegwaahchy'aa kwaa łee. Jii geh'an Vit'eegwijyąhchy'aa ts'an tr'iinzhii gwik'injiriighit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus jyaa gavahnyąą: “It'ee shik'iinjuhkhit? ");
INSERT INTO gwiNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ch'adąį' hee zhat nigwiindhat, shrihtee hohdaa ts'ą' nakhwazheh gwits'eehohdaa ts'ą' shįį zhrįh hihdyaa. Gaa shahzhrįh hihdyaa kwaa ts'ą' Gwiti' shaa t'inchy'aa geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Shaa tsinehdan hohłyaa geh'an nakhwaagwaldak t'ihnyąą. Jii nankat gogwantrii datthak gahǫǫh'yaa. Gaa nihk'it nakhwaa shroonchy'aa! Jii nankat gaayiidhałtsąįį!” ");
INSERT INTO gwiNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus jyaa diinyą' ąįįtł'ęę zheekat k'iidak gwąąh'in ts'ą' jyaa nyąą, “Shiti', it'ee zhat nigwiindhat. Nidinji' nich'eegwahdrii vintł'eiin'ąįį, ąįįts'ą' Gwidinji' nich'eegwahdrii nintł'ineehee'aa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Dinjii datthak teegwahąhdal eenjit t'aih vintł'eiin'ąįį, ts'ą' juu yaanilii nąįį gwandaii ndaanąą'ąį' kwaa teeheelyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jii jyąhts'ą' t'ee gwandaii ndaanąą'ąį' kwaa khwa'įį: Vit'eegwijyąhchy'aa łi'didlii ch'ihłak zhrįh inlii, ts'ą' Jesus Christ, khadhoo'ee ąįį juu nąįį datthak goovaaheendaii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Gwitr'it shintł'eegwin'ąįį datthak gęhdaa tr'aałjik ts'ą' jyąhts'ą' t'ee nich'eegwahdrii nankat neenjit googwahaałkyaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Gwiti' neeghaih ch'eegwahdrii shintł'eegwiin'ąįį, jii nan goodlit gwats'ą' ch'eegwahdrii nan, shįį haa tr'ii'įį ąįį reh. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Dinjii nankat gwats'an oodhiinjik ts'ą' shintł'eegoovinlii, ąįį nąįį ts'ą' neegiihkhe'. Nats'an giinlii, ts'ą' shintł'eegaviinlii. Niginjik k'eegwigwiłthat, ");
INSERT INTO gwiNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ąįįts'ą' juk jidii shintł'eegwiinlii datthak nats'an t'inchy'aa gaagiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Jidii niginjik shintł'eiin'ąįį datthak goovintł'eiilii, ts'ą' giik'iinjiighit nats'an tr'iizhii ąįį łi'deegwidlii gaagiindaii, ts'ą' shahooh'e' gwik'iinjigiighit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Gooveenjit khagidihjii, juu nits'į' t'inchy'aa nąįį eenjit khagidihjii kwaa, gaa juu shintł'eiinlii nąįį eenjit khagidihjii, nats'an giinlii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Juu shats'an nilii nąįį nats'an giinlii, ts'ą' juu nats'an nilii nąįį shats'an giinlii. Ąįįts'ą' gooveh'an ch'eegwahdrii shats'an goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ąįįts'ą' t'ee nats'ą' hihshyaa, it'ee nankat gihłeehihdyaa, gaa geedan ąįį nankat gahaaky'aa. Gwiti' Shroodiinyąą Noozhri' zhit t'aih ni'įį haa gavoiintą', ąįį Noozhri' shintł'eiin'ąįį reh, nan shįį haa ch'ihłak tr'iinlii gwik'it ch'ihłak giheelyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Gavaa iindi' dąį', Noozhri' zhit t'aih haa gook'aałti', ąįį noozhri' shintł'eiin'ąįį reh. Gook'aałti', ts'ą' teegahaajil kwaa, dinjii ch'ihłak zhrįh teehaazhii. Ąįįt'ee Dęhtły'aa zhit deegweheenjyaa goo'aii ąįį gwik'it t'igweheenjyaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ąįįts'ą' t'ee nats'ą' hihshyaa, gaa jii nankat tth'aii dhiindii gwiizhit jyaa dihnyąą t'ihnyąą, goodrii zhit shoh deedahaan'ai' eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niginjik nankat gavintł'eiinlii ts'ą' lęįį nąįį gaveet'iindhan kwaa ji', nahkat gwats'an giinlii kwaa geh'an, shįį chan nankat gwats'an ihłii kwaa gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nankat gihłeegavahiinlyaa eenjit t'ihnyąą kwaa, gaa Ch'anky'aa Tr'aanduu ts'į' gook'ąąhtii. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nankat gwats'an ihłii kwaa ts'ą' geedan chan nankat gwats'an giinlii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Niginjik łi'didlii zhit shroodiinyąą gavahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nankat gwats'ą' shahooh'ya' gwik'it nankat gwats'ą' goohooł'e'. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gooveenjit nantł'eedahaalchyaa, geedan chan łi'haa nantł'eedagahaachyaa ji' eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Geedan zhrįh gooveenjit khadigihjii kwaa, gaa juu shik'injiheeghit nąįį chan shitsyaa nąįį shiginjik eegoogwaandak geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Datthak ch'ihłak giheelyaa eenjit gooveenjit khadigihjii. Shiti', shaa inlii gwik'it geedan chan diinaa gooli' ts'ą' shįį chan naa ihłii gwik'it. Ch'ihłak giheelyaa, juu nąįį datthak shahooh'e' gaageheendaii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nich'eegwahdrii shintł'eiin'ąįį ąįį goovantł'eiin'ąįį, ch'ihłak giheelyaa eenjit, nan shįį haa ch'ihłak tr'iinlii gwik'it. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Gavaa ihłii ts'ą' nan shaa inlii ts'ą' łyaa ch'ihłak giheelyaa eenjit, shahooh'e' ts'ą' sheet'iindhan gwik'it gaveet'iindhan gaageheendaii eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Gwiti', shintł'eegaviinlii ts'ą' nijin t'ihchy'aa shaa t'agoochy'a' goovoihnyąą ts'ą' nich'eegwahdrii shintł'eiin'ąįį gahąąh'yaa geenjit. Nan gweheelyaa gwehkįį sheet'iinghya' geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Gwiti' Łi'didlii Choh! Nankat naagwiindaii kwaa, gaa shįį ąįį naashandaii, ts'ą' shahooh'e' chan gaagiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Juu inlii neegiihkhe' ts'ą' naagiindaii ts'ą' khit jyaa shi'yaa, ts'ą' ch'eet'igwiniindhan sheenjit ni'įį goozhit t'oonchy'aa ts'ą' shįį chan ch'eet'igwiniindhan shi'įį goozhit t'oochy'a'.” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jyąhts'ą' khadigeedi' ąįįtł'ęę Jesus k'ǫǫ Kidron deetaa ditsyaa nąįį haa neiinzhii. Izhit gwanzhįh deek'it goo'aii, izhit Jesus ditsyaa nąįį haa gwiteiinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, Jesus gwantł'ąhchįį ąįį gwanzhįh deek'it nijin goo'aii gaandaii ąįį gwehkįį zhat khit ditsyaa nąįį ninidik yaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas ąįį gwanzhįh deek'it gwats'ą' ąįį Kharigidiinjii Zheh Gwachoh gwak'ąąhtii nąįį akwat Roman niveet'ah'in lęįį nąįį haadlii, ąįįt'ee giinkhih kįh dilk'ii nąįį chan ts'ą' Pharisee nąįį goohił'e': datthak kheeghan akwat chųų daak'a' tyah akwat gał vakat gwaak'a' neegahaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus deereheelyaa datthak ch'adąį' hee gaandaii; ąįįts'ą' goots'ą' niinzhii ts'ą' jyaa gavahnyąą: “Juu vinkeegǫh'in t'akhwa'in?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","“Jesus Nazareth gwats'an,” giiyahnyąą. “Shįį t'ee t'ihchy'aa,” gavahnyąą. Judas, Jesus gwantł'ahchįį chan zhat nadhat. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nijin Jesus jyaa gavahnyąą dąį', “Shįį t'ee t'ihchy'aa,” an gagahaajil ts'ą' nan kat oo'an gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus chan hee gavaahkat, “Juu vinkeegǫh'in t'akhwa'in?” “Jesus Nazareth gwats'an,” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Shįį t'ee t'ihchy'aa, ch'adąį' nakhwaiinyą'. Shįį shinkeegoh'in t'akhwa'in ji', jii ch'izhii nąįį gavaanagoh'aa shrǫ'!” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(Deiinyą' chy'aa łi'didlii gweheelyaa ji' eenjit jyaa nyąą t'inyąą: “Ch'ihłak gaa haa tr'igweendaii kwaa, Shiti', juu shintł'eiinlii nąįį tee gwats'an”). ");
INSERT INTO gwiNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Peter ąįį kheeghan shrii choh di'įį, khąhnaii ts'ą' ndak khii giinkhih choh vi-slave Malchus oaazhii ąįį shriits'ąįį dzee' gadąąhtrit. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus Peter jyaa ahnyąą, “Nizhrii choh gwizhit nąhchįį! Shiti' chųų tyah vizhit khaiinjich'iidhat shintł'eiin'ąįį zhit ch'ishinjyaa kwaa shǫįįnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Niveet'ah'in ts'ą' dagakhaihkwai' chan ts'ą' gwak'ąąhtii nąįį haa Jesus goonjik ts'ą' giikat dich'iłchaa, ");
INSERT INTO gwiNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ąįįts'ą' Annas tr'ookit ts'ą' giihiłchįį. Caiaphas t'ee vichį' eedhidii ts'ą' zhat dąį' Caiaphas ndak khii giinkhih choh nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas t'ee dinjii ch'ihłak zhrįh dinjii tee gwats'an juu nąįį datthak niindhat eenjit ji' gweheezyaa Jews nąįį ąįįnyą'. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Peter, ch'izhii ch'itsyaa haa Jesus tąįį gahaa'oo. Ąįį ch'izhii ch'itsyaa t'ee ndak khii giinkhih choh gwinzii yaandaii ąįįts'ą' Jesus zhit giinkhih choh vizheh gokwantee yaa gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter ąįį oo'at chiitąįį ohts'ąįį dhidii. Ąįį ch'izhii ch'itsyaa gwinzii giinkhih choh yaandaii chineezhii ts'ą' oo'at chiitąįį nich'it tsal haa giinkhe' ąįįtł'ęę Peter nihdaahchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ąįį oo'at chiitąįį ohts'ąįį nich'it tsal ąįį Peter jyaa ahnyąą, “Zhit dinjii vitsyaa ch'ihłak inlii?” “Nakwaa, vitsyaa ihłii kwaa!” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chiitąįį gwiink'oo, ts'ą' ąįį ndak khii giinkhih choh vitsyaa chan ts'ą' geech'agwaa'ya' nąįį haa gwigwiilk'in ąįį eelin giheendhaa eenjit nigiilzhii. Peter chan heendhaa eenjit gootee nadhat. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ąįį ndak khii giinkhih choh ąįį Jesus, vitsyaa nąįį akwat geech'ǫąąhtan kwaii eenjit yuahkat. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus jyaa yahnyąą: “Lęįį nąįį ts'ą' gwandah geech'ǫąąłchya', Israel nąįį tr'igiinkhii zheh kwaii akwat Kharigidiinjii Zheh Gwachoh gwizhrįh gwizhit geech'ǫąąłchya', izhit t'ee Jews nąįį khaihłan nineedal reh. Ch'ihłok gaa nagwąą'įį gwizhit giihkhe' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Jaghaii geenjit shoohkat t'ohnyąą gǫ'? Ąįį juu gwaałchy'a' oohkat. Deegavaiinyą' ąįį geenjit gavoohkat, deihnyą' shaagiindaii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nijin Jesus jyaa nyąą dąį', zhat gwak'ąąhtii ch'ihłak dhidii ąįį yaant'an ts'ą' jyaa yahnyąą. “Nats'ąą ndak khii giinkhih choh ts'ą' ginkhii t'iinyąą!” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus t'iiyahnyąą, “Yee'at k'ii'an t'iinyą' ji', juk dząą gavaagwandak. Gaa deiinyą' eenjit oiints'it kwaa ji', jaghaii shįįt'an ni'in?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ts'ą' t'ee Annas, ąįį Jesus tth'aii vakat ch'adookhwachaa gwizhit ndak khii giinkhih choh Caiaphas ts'ą' niyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Gwiizhit Peter ąįį tth'aii hee gwaak'a' gwats'ą' heendhaa eenjit nadhat. Ąįįts'ą' zhat dilk'ii nąįį jyaa giiyahnyąą. “Nan lee zhit dinjii vitsyaa ch'ihłak lee t'iinchy'aa?” Gaa Peter ąįį zhyaa t'igwinyąą gavahnyąą ts'ą' jyaa nyąą, “Nakwaa, vitsyaa ihłii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ąįį ndak khii giinkhih choh vi-slave ch'ihłak ąįį zhit juu Peter yidzee gihłeehiłtr'it valak yąąh'ya' ąįį Peter jyaa ahnyąą, “Nanlee gwanzhįh deek'it vaa naał'ya' lee t'iinchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Chan hee Peter “Nakwaa” nyąą gwiizhit rooster khashraa'iintrat. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesus ąįį Caiaphas vizheh cheegiihiłchįį ts'ą' oo'at Roman khaihkwaii choh vizheh nihdeegiiyąąhchįį. Vanh dąį' gineech'ahoo'aii hee. Jews nąįį Passover ch'igihee'aa eenjit shroodigidiinyąą geh'an khaihkwaii choh vizheh nihdeegijyaa gitr'igii'ee, nihdeegiinjil ji' duuyeh Passover ch'a'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ąįįts'ą' ąįį Roman khaihkwaii choh (Pilate) yats'ą' ch'izhii ts'ą' yuahkat, “Jii dinjii jidii eenjit gwiizųų tr'agwah'ya'?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jyaa diginyąą, “Gwiizųų tr'agwah'ya' kwaa ji' duuyeh nats'ą' narąhchįį t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate jyaa gavahnyąą, “Ts'an oo'įį ts'ą' nakhwa-law zhit deehohłyaa gwik'it t'ohłii.” Jews nąįį jyaa ginyąą “Dinjii drin gwarahahtsyaa geenjit goo'aii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Jesus nats'ą' vidrin tr'ahahtsyaa diinyą' chy'aa ąįį gwik'it gweheelyaa eenjit t'igwiizhik) ");
INSERT INTO gwiNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate dizheh nihdineezhii ts'ą' Jesus oahkat, “Nanlee Jews nąįį eenjit King inlii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus jyaa yahnyąą, “Nan shǫąąhkat akwat ch'izhii nąįį ts'an sheegwiintth'ak lee t'iinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate jyaa yahnyąą, “Jew ihłii shaiinyąą? Naa gwich'in nąįį akwat ąįį googiinkhii choh nąįį haa shintł'eenagąhchįį t'oonchy'aa. Nigwitr'it deezhik t'igwinyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus jyaa yahnyąą, “Shanahkat dząą nankat gwats'an nilii kwaa: shanahkat dząą nankat gwats'an nilii ji', shitsyaa nąįį Jews nąįį intł'eesharahahchyaa gwits'į' nich'itsigahahthat. Nakwaa, shanahkat dząą nahkat gwats'ą' nilii kwaa t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ąįįts'ą' Pilate yuahkat, “King inlii diinyąą lee t'iinyąą?” Jesus jyaa yahnyąą, “Nan reh King inlii. Shaiinyąą. Ch'ihłak eenjit gwizhrįh shagoodlit ts'ą' nankat gwats'ą' hoiizhii t'ishi'in, łi'didlii eegihihkhyaa eenjit. Juu łi'didlii ts'an nilii ąįįt'ee shoołk'įį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Ąįį łi'didlii ąįį jidii t'aiinyąą?” Pilate yuahkat. Ąįįtł'ęę Pilate cheehoozhii ts'ą' Jews nąįį jyaa ahnyąą: “Jaghaii tr'ahaahkhwaa veegwaał'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Passover nineegwiidhak dąį' dinjii ch'ihłak zheegwaazhrąįį nakhweenjit chinałchik, ąįįt'ee khit jyąhts'ą' nakhweenjit gwik'it goo'aii geh'an. Jews nąįį nakhwa-King nakhweenjit chinoałchyaa shoohnyąą?” ");
INSERT INTO gwiNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Datthak gazhral ts'ą' jyaa ginyąą, “Nakwaa, adan nakwaa! Barabbas ąįį gwiindhan.” (Barabbas t'ee Roman nahkat gookat deeheehaa gwik'eegoonjik inli' t'arahnyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ąįįtł'ęę Pilate ąįį Jesus oohjik ts'ą' tr'ąhtrii yeenjit gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Niveet'ah'in nąįį khoh haa giiyeenjit ts'eh iłtsąįį ąįį giiniin'ąįį, ik Purple ąįį chan giinaahtsųų, ");
INSERT INTO gwiNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","giits'ą' niinjil ts'ą' shroondaii jyaa giiyahnyąą, “Jews nąįį King niighyuk goondaii!” Ąįįts'ą' giits'ą' nineedal ts'ą' giiyant'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate chan hee chineezhii ts'ą' dinjii nąįį jyaa ahnyąą, “Gooh'in, jaghaii tr'ahaahkhwaa veegwaał'in kwaa ąįį gahǫǫh'yaa eenjit nakhwats'ą' chahałchyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ąįįts'ą' t'ee Jesus chiinzhii, khoh ts'eh naa'aii ts'ą' ik Purple chan naazhii. Pilate dinjii nąįį jyaa ahnyąą, “Gooh'in, jii dinjii nǫh'in!” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nijin zhit gwak'ąąhtii chan ts'ą' giinkhih kįh dilk'ii nąįį nigiiyiił'in dąį' gazhral ts'ą' jyaa ginyąą, “Gohtsak! Gohtsak!” Gaa Pilate ąįį jyaa gavahnyąą. “Nakhwan ąįį ǫhjii ts'ą' gohtsak, shįį ąįį jaghaii geenjit tr'ahaahkhwaa veegwaał'in kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jews nąįį jyaa ginyąą, “Vit'eegwijyąhchy'aa Vidinji' ihłii nyąą geh'an dii-law zhit tr'ahaahkhwaa goo'aii gwinyąą.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nijin Pilate jii gwiitth'ak dąį', gwandaa naajat dhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Dizheh gwachoh nihdineezhii ts'ą' Jesus jyaa ahnyąą, “Nijin gwats'an inkhaa?” Gaa Jesus yidii ginkhii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate jyaa yahnyąą, “Shats'ą' gihinkhyaa kwaa? Jii ganandaii, nineehįhdal ji' gaa geenjit t'aih shi'įį, ganarahahtsak ji' gaa geenjit t'aih shi'įį.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus jyaa yahnyąą, “Vit'eegwijyąhchy'aa t'aih nintł'eiin'ąįį haa sheenjit t'aih nilii t'oonchy'aa. Ąįįts'ą' zhit juu nintł'eeshąhchįį ąįį gwandaa vatr'agwaanduu gweheelyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nijin Pilate jii gwiitth'ak dąį' vineeroonjii yuunyąą. Gaa Jews nąįį gazhral ts'ą' jyaa ginyąą, “Jii dinjii vineiinjik ji' t'ee, Rome nahkat gwats'ą' k'eegwaadhat Caesar duuyeh nijyaa nilii! Juu King ihłii nyąą t'ee Caesar vijyaa t'inchy'aa kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nijin Pilate jii gwiitth'ak dąį', Jesus chyąąhchįį ts'ą' oo'at ch'aroahkat deek'it naadii. (Jii t'ee Hebrew ginjik zhit “Gabbatha” t'arahnyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Izhit t'ee Passover gwats'ą' drintł'an khaiinjii nigwiindhat. Pilate ąįį Jews nąįį shroondaii jyaa ahnyąą, “Dząą nakhwa-King!” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gazhral ts'ą' jyaa giiyahnyąą, “Vęhdaa tr'agǫh'ąįį! Vęhdaa tr'agǫh'ąįį! Cross kat gohtsak!” Pilate gavoahkat, “Nakhwaa-King gwałtsak shoohnyąą?” Giinkhih kįh dilk'ii nąįį jyaa ginyąą, “Caesar zhrįh dii-King nilii t'oonchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ąįįts'ą' t'ee Pilate ąįį Jesus gagahahtsak eenjit gavantł'ahchįį. Ąįįts'ą' t'ee niveet'ah'in nąįį Jesus goonjik. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Da-cross ichyaa giiyiłtsąįį ts'ą' oodee taih “Dinjii kiitth'an k'itiltsį',” googwahnyąą gwats'ą' ahaa. (Hebrew ginjik zhit Golgotha goozhii) ");
INSERT INTO gwiNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Izhit t'ee cross kat gigiiyiłtsak veeghaih nihts'įį chan dinjii neekwaii gigiłtsak. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate dęhtły'aa kat gwadąąntł'oo ts'ą' ya-cross kat giłtsak “Jesus Nazareth gwats'an ahaa, Jews nąįį datthak eenjit King Nilii,” vakat gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jews lęįį nąįį giikat aakin gwaa'įį, ąįį nijin Jesus giltsak ąįį kwaiik'it gwachoo gwats'ą' nahgǫǫ geh'an. Lęįį nąįį vakat deegwinyąą gaageheendaii eenjit Hebrew, Latin, chan ts'ą' Greek ginjik zhit danohootł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Giinkhih kįh dilk'ii nąįį Pilate jyaa agahnyąą, “‘Jews nąįį datthak eenjit King nilii.’ ąįį doiintł'oo shrǫ' gaa jii ąįį diintł'oo, ‘Jii dinjii jyaa nyąą, Jews nąįį datthak eenjit King ihłii.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate jyaa gavahnyąą, “Jidii danoihtł'oo ąįį jyaa deheechy'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Niveet'ah'in nąįį Jesus cross kat gigiłtsak ąįįtł'ęę giigwach'aa niveet'ah'in dǫǫ nąįį nihteegiyilzhii. Zhak khii ik chan oonjik, gwach'aa k'eelkai' nilii kwaa ts'ą' ch'ihłak zhrį' nilii. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Niveet'ah'in nąįį jyaa nihłagaanyąą, “Gwahkwaa łeerahch'aa; juu yuuheendal ji' eenjit, veenjit tseeroo'ya'.” Dęhtły'aa Choh kat deegwinyąą ąįį łi'didlii heelyaa eenjit jyąhts'ą' teegoodhat t'igwinyąą: “Shagwach'aa nihteegilzhii, shi'ik eenjit tseegee'ya'.” Niveet'ah'in nąįį izhit gwik'it t'igiizhik t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Va-cross gwats'ą' niighit kwaa vahan nadhat, vahan vijuu, Clopas va'at Mary chan, Mary Magdalene chan. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesus dahan chan ts'ą' ditsyaa eet'iindhan ąįį zhat nigiilzhii nagooviił'in; ąįįts'ą' dahan łyaa jyaa ahnyąą, “Ni'ęę, dząą t'ee nigii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ąįįtł'ęę ditsyaa jyaa ahnyąą, “Dząą nahan.” Izhit gwats'an ąįį vitsyaa dizheh yaagweheechy'aa eenjit gwits'eeyihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesus et'ee jidii datthak gwik'it t'igwiizhik gaandaii ąįįts'ą' Dęhtły'aa Choh kat deegwinyąą ąįį łi'didlii eenjit jyaa nyąą, “Chųų doiihłii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hyssop gał ts'iivii k'it t'inchy'aa tsii gwach'aa nagahtsuu ąįį k'ik tyah ghoo zhit jak chų' daatł'oo kwaa dhakaii; ąįį giizhit teegąhtsuu ts'ą' oodak giits'ą' ootą'. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesus juk chų' eenį' ąįįtł'ęę jyaa nyąą, “It'ee ndaagwąą'ąį'!” Ąįįtł'ęę zhak diki' niin'ąįį ts'ą' niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ąįįtł'ęę Jews kįh dilk'ii nąįį ąįį dinjii juu gagooriłtsak nąįį gootth'an łeegahahnaii ąįįtł'ęę cross ts'an nineegeheelyaa eenjit Pilate goahkat. Neegwaazhii Drin łyaa shroodiinyąą ts'ą' gwigwihił'ee drin nigwiighit geh'an zhat drin cross kat goochį' dhidlii gitr'igii'ee. Drin ts'ą' gwats'ą' drin gweedhaa geh'an jyaa digiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Niveet'ah'in nąįį ąįį dinjii neekwaii Jesus haa gagoogiłtsak nąįį tth'an łeegiiłnaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Gaa nijin Jesus inigwigwiin'ąįį dąį', ch'adąį' hee niindhat łee ts'ą' giitth'an łeelnaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Niveet'ah'in ch'ihłak googaa kheeghan ch'ok haa Jesus tseech'iingit, Googwahkhan chųų, dah haa khaatil. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Shįį t'ee jyaa digwiizhik gwąął'ya' ts'ą' geegihkhe' łi'didlii t'ihnyąą gaashandaii ąįįts'ą' nan chan gwik'iinjihinghit ji' geenjit.) ");
INSERT INTO gwiNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Dęhtły'aa Choh kat jyaa digwinyąą. Ąįį łi'didlii heelyaa eenjit, “Vatth'an ch'ihłak gaa łeehaahnaii kwaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Dęhtły'aa Choh kat ch'adanh chan jyaa digwinyąą, “Dinjii giiyaahgwat aakin giiyaa'įį!” ");
INSERT INTO gwiNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jii ąįįtł'ęę Arimathea kwaiik'it gwachoo gwats'an dinjii Joseph oaazhii ąįį Jesus vichį' ooheendal ji' eenjit Pilate oahkat. (Joseph ąįį Jesus vitsyaa nilii gaa nagwąąh'įį, Jews khaihkwaii nąįį aanjat geh'an.) Pilate ąįį gwik'it t'ini'in yahnyąą ts'ą' t'ee yichi' oonjik ts'ą' oo'an neeyihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus tr'ookit dąį' khaa Jesus nah'ya' chy'aa ąįį Joseph haa haazhii, myrrh, ts'ą' aloes chan gwanzhįh chų' gwinzii vagwaatsan 100 lb. adahaa haadlii. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ąįį dinjii neekwaii nąįį Jesus vichį' neegąhchįį ts'ą' gwach'aa ts'ik jyah giinooandoo, ąįį gwanzhįh gwinzii vagwaatsan haa. Jyąhts'ą' t'ee Jews nąįį dinjii anagahąhdal dąį' t'igii'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ąįį nijin Jesus goołkhwąįį geeghaih nahgwan gwanzhįh deek'it goo'aii izhit gwizhit gwa'an kii zhit gweedii goo'aii gwehkįį dinjii gitsii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Et'ee Jews nąįį Neegwaazhii Drin gwats'ą' drin nigwiindhat ąįįts'ą' ąįį kii zhit gweedii goo'aii ąįį geeghaih niighit kwaa goo'aii. Geh'an zhat Jesus vichį' nagąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Drin Zhit vanh dąį' tth'aii tǫǫ gwanlii gwiizhit Mary Magdalene ąįį kii zhit gweedii gwats'ą' haazhii akhai' gwadąįį kii gihłeerahaa'aii łee gwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Gihłeehilgik ts'ą' Simon Peter chan ts'ą' ch'izhii vitsyaa Jesus gooveet'iinghya' nąįį ts'ą' niinzhii ts'ą' jyaa gavahnyąą, “Kiizhit gwats'an K'eegwaadhat goonjik ts'ą' nijin nigiiyąąhchįį kwaa gaagwiindaii kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ąįįtł'ęę Peter chan ts'ą' ch'izhii Jesus vitsyaa haa ąįį kiizhit vatth'ank'it gwats'ą' gahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nihłaagaagal, gaa ch'ihłak ąįį Peter iłeehilgik ts'ą' adan tr'ookit tth'ank'it k'aagak. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nihdeekiintthaii ts'ą' gwach'aa ts'ik njyah kwaii nah'in, gaa nihdeiinzhii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Vatąįį Simon Peter k'idik ts'ą' zhazhat kiizhit tth'ank'it nihdeiinzhii. Ąįį gwach'aa ts'ik jyah, ");
INSERT INTO gwiNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ąįįts'ą' Jesus viki' kat gwach'aa kwaii niił'in. Ch'izhii gwach'aa ts'ik jyah eeghaii dhidlii kwaa gaa thok tr'aandoo łee. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ąįį ch'izhii ch'itsyaa ąįį kiizhit tth'ank'it tr'ookit k'idik chy'aa, adan chan nihdeiinzhii; gwąąh'ya' ąįįtł'ęę gwik'it t'igwiizhik ts'ą' gaandaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Dęhtły'aa Choh kat niindhat ąįįtł'ęę nineeheenjyaa goo'aii varahnyąą ąįį deegwinyąą t'igwinyąą gaagiindaii kwaa.) ");
INSERT INTO gwiNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ąįįtł'ęę vitsyaa nąįį digizheh gwits'eegahoojil. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ąįį kii tth'ank'it gokwantee Mary itree ts'ą' nadhat. Tth'aii itree gwiizhit nihdeekiintthaii ts'ą' oozhak gwąąh'in, ");
INSERT INTO gwiNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ts'ą' zheekat gwich'in neekwaii nah'in, daagąįį nagaatsuu ts'ą' Jesus nijuk iindi' izhit dagaadii, viki' eeghaii ch'ihłak dhidii, vakwai' ts'ąįį chan ch'ihłak dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","“Tr'injaa, jaghaii iintree?” giiyahnyąą. Jyaa gavahnyąą, “Shik'eegwaadhat gihłeegihiłchįį ts'ą' nijuk nigiiyąąhchįį gaashandaii kwaa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nijin jyaa nyąą dąį', neediil'ee akhai' Jesus zhat nadhat nigwiił'in; gaa Jesus t'inchy'aa ts'ą' yaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","“Tr'injaa, jaghaii intree? Juu vinkeegwąh'in t'ini'in?” Jesus yuahkat. Gwanzhįh eetr'agwah'in t'inchy'aa yuunyąą, ts'ą' Mary jyaa yahnyąą, “Oodhiinjik t'inchy'aa ji' nijuk nąąhchįį shaagwandak, vats'ą' hihshyaa ts'ą' noohihdal eenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus jyaa yahnyąą, “Mary!” Yats'ą' neediil'ee ts'ą' Hebrew ginjik zhit jyaa nyąą, “Rabboni!” (Jii t'ee “Geech'ǫąąhtan” ginyąą t'igwinyąą.) ");
INSERT INTO gwiNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","“Shakat noonjii shrǫ',” Jesus yahnyąą, “Tth'aii Shiti' vits'eehihdii kwaa geh'an. Gaa shachaa nąįį goots'eehindii' ts'ą' jii sheenjit gavaa gwandak, ‘Oodak Shiti' vats'ą' hihshyaa, nakhwan chan Nakhwati' Shivit'eegwijyąhchy'aa nilii, nakhwan chan nakhwa-Vit'eegwijyąhchy'aa nilii.’” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ąįįts'ą' t'ee Mary Magdalene yitsyaa nąįį ts'ą' K'eegwaadhat nah'ya' ts'ą' jii jyaa diiyaiinyą' eenjit geevaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Drinzhit khaiinjii tǫhtł'an gwa'an zheh gwizhit vitsyaa nąįį gindeiinvyaa gehdeech'igiintin, Jews kįh dilk'ii nąįį agąąnjat geh'an. Ąįįtł'ęę Jesus gootł'an nadhat nagwaanąįį. “Tsinehdan nakhwaa oolį', Shiti' shihił'ee gwik'it shįį chan nakhwahał'ee,” Jesus gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jii jyaa diinyą' ąįįtł'ęę, danli', ditsęh k'ąą haa goots'ą' agwahch'in. K'eegwaadhat gąąh'in eenjit gwintł'oo shoo giinlii. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ąįįtł'ęę chan hee Jesus jyaa gavahnyąą, “Tsinehdan nakhwaa oolį', Shiti' shihił'e' gwik'it shįį chan nakhwayinjihooł'ee!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jii jyaa diinyą', ąįįtł'ęę datthak gookat haazhee ts'ą' jyaa gavahnyąą, “Ch'anky'aa Shroodiinyąą ts'an oo'įį. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dinjii nąįį atr'agwaanduu gooveenjit oo'an gahohłii ji', gooveenjit oo'an gweheedaa; gooveenjit oo'an gahohłii kwaa ji', duuyeh gooveenjit oo'an gwihijyaa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jesus goots'ą' nadhat naanaii dąį' vitsyaa ch'ihłak Thomas (Didymus chan oozhii) ąįį zhat dhidii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ąįįts'ą' vitsyaa nąįį Thomas jyaa agahnyąą, “K'eegwaadhat tr'ąąh'ya'!” Thomas jyaa nyąą, “Vanli' kat gwatsak deek'it shat dha'aii akwat gwatsak deek'it naaljik akwat vitsęh k'ąą naaljik kwaa ji' duuyeh adan t'inchy'aa gwik'iinjihkhit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ąįįtł'ęę gęhdaa drin deetik vitsyaa nąįį zheh gwizhit khaihłan nineegiijil ts'ą' Thomas zhat goovaadhidii gindeiinvyaa ihdeech'agąąhtin gaa Jesus zhat gaveeghaii nadhat naanaii ts'ą' jyaa gavahnyąą, “Tsinehdan nakhwaa oolį'!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ąįįtł'ęę Thomas jyaa ahnyąą, “Dząą nanleetth'ak niinchįį, ts'ą' shanli' nah'in; ąįįtł'ęę nanli' nihky'aa noiinjii ts'ą' dząą shitsęhk'aa naanjii. Gwik'iinjiighit ni'įį kwaa ąįį akhagoiinyąą ts'ą' gwik'iinjinghit!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas jyaa yahnyąą, “Shik'eegwaadhat, Shivit'eegwijyąhchy'aa!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus jyaa yahnyąą, “Shąąh'ya' geh'an gwizhrįh shik'iinjinghit? Juu shąąh'in kwaa gaa shik'iinjiighit nąįį shoo nakhwaa oolį'!” ");
INSERT INTO gwiNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus ditsyaa nąįį andah gwinlęįį gwitr'it geegwaroolii kwaa t'iizhik gaa jii dęhtły'aa zhit valak zhrįh danahootł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jii t'ee gwadanakhwatł'oo Jesus t'ee Vit'eegwijyąhchy'aa Vidinji' nilii ts'ą' Christ chan nilii, gwik'iinjihinghit ji' ąįį nigwik'iinjigwiighit haa voozhri' zhit gwihiindaii geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jii ąįįtł'ęę, Jesus ch'ihłok gwizhrįh van Tiberias khyųų ditsyaa nąįį ts'ą' idineegwiilkįį. Jyąhts'ą' t'igwiizhik t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, Thomas, Nathaniel (Galilee nahkat gwizhit Cana goozhii goo'aii gwats'an ahaa), Zebedee vidinjii neekwaii ts'ą' Jesus ch'izhii vitsyaa neekwaii nąįį haa nihłaagiilk'ii. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter jyaa gavahnyąą, “Łuk keeshi'yaa.” “Naa k'eereheedal,” giiyahnyąą. Ąįįts'ą' t'ee giiyaahaajil ts'ą' tr'ihchoo zhit giinjil; gaa zhat tǫǫ datthak łuk ch'ihłak gaa goonjik kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Vanh geeneech'ihii'aii gwiizhit Jesus van khyųų nadhat, gaa vitsyaa nąįį Jesus t'inchy'aa giiyaandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ąįįtł'ęę jyaa gavahshral ts'ą' jyaa nyąą, “Tsyaa nąįį, nik'ee łuk oodhoonjik?” “Ch'ihłak gaa kwaa,” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesus jyaa gavahshral ts'ą' jyaa nyąą, “Nakhwachihvyaa tr'ihchoo eeghaii shriits'ąįį chųhtsuu, izhit łuk oohohdal t'oonchy'aa.” Ąįįts'ą' t'ee izhit chigiiyąąhtsuu akhai' khyų' khaneegiiyahtsuu, łyaa vizhit łuk lęįį geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Zhit vitsyaa Jesus yeet'iindhan ąįį Peter t'ahnyąą, “Diik'eegwaadhat t'inchy'aa łee!” Nijin Simon Peter Diik'eegwaadhat t'inchy'aa gwinyąą gwiitth'ak dąį', ankhii dagwach'aa nanaatsuu gwats'ą' dąį' (gihłeeyihiltsuu dhidii) ts'ą' chųų zhit oondaa hiltłee. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Teeghaii gwats'ą' niighit kwaa neegeekwaii. Ch'izhii vitsyaa nąįį tr'ihchoo haa teeneegohojil (Chihvyaa vizhit łuk deedąą'ąį' haa). ");
INSERT INTO gwiNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Teeneegohojil dąį' zhat gwaak'a' kǫ' zhit łuk chan ts'ą' łųhchy'aa haa ichy'aa googwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus t'agavahnyąą, “Ąįį łuk dohju' gwidiinlii lat dząą nohtsit.” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter ąįį tr'ihchoo zhineezhii ts'ą' chihvyaa vizhit łuk choh deedąą'ąį' ąįį teedhiluu, (153 aanchy'aa) łyaa vizhit łuk lęįį gaa chihvyaa łeedhach'aa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus jyaa gavahnyąą, “Aanaii ts'ą' dząą ch'oh'aa.” “Juu inlii?” giiyahaanjyaa eenjit giideetr'oaanyąą. Gook'eegwaadhat t'inchy'aa giiyaandaii geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ąįįts'ą' Jesus gaveeniinzhii ts'ą' łųhchy'aa oonjik ts'ą' gavantł'eech'ąhtsit, łuk chan gwik'it t'inlik. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus niindhat ts'ą' ninehjin ąįįtł'ęę jii zhat dąį' t'ee ditsyaa nąįį ts'ą' tik agwaanchy'aa idigweelkįį t'agwarahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ch'igiin'al ąįįtł'ęę, Jesus ąįį Simon Peter jyaa yahnyąą “John vidinji', Simon, jii nąįį andaa ts'ą' łyaa sheet'iindhan?” “Shik'eegwaadhat, aahą' neet'iihthan ts'ą' gaanandaii.” Peter yahnyąą. Jesus t'iiyahnyąą, “Shidivii tsal nąįį gooch'ah'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Chan hee Jesus ąįį Peter jyaa yahnyąą, “John vidinji', Simon, łyaa sheet'iindhan?” “Shik'eegwaadhat, aahą' neet'iihthan ts'ą' gaanandaii.” Peter yahnyąą. Jesus t'iiyahnyąą, “Shidivii nąįį k'ąąhtii.” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tik agwaanchy'aa chan Jesus ąįį jyaa yahnyąą, “John vidinji', Simon, sheet'iindhan?” Peter tr'igwidii dhidlit Jesus tik agwaanchy'aa “Sheet'iindhan?” yahnyąą eenjit. “Shik'eegwaadhat, łyaa jidii datthak eenjit gaanandaii; neet'iihthan gaanandaii t'oonchy'aa.” Peter yahnyąą. Jesus jyaa yahnyąą “Shidivii nąįį gooch'ah'aa. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Łi'didlii haa nakhwaagwahaldak, k'eejit inlii dąį' neenitł'uu ts'ą' deenoo'ya' yiindhan datthak gwik'it t'ini'in, nijin gwats'ą' hoihshi' niindhan chan gwik'it t'ini'in; gaa naghaii lęįį ji' neenigiheetł'uu ts'ą' nijin gwats'ą' hoihshi' niindhan kwaa gaa nihk'it gwats'ą' nigehęę'aa t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jii Jesus jyaa nyąą t'ee nats'ąą Peter niheedhaa ts'ą' Vit'eegwijyąhchy'aa vich'eegwahdrii gwahąąh'yaa t'agwarahnyąą.) Ąįįts'ą' chan yahnyąą, “Shatąįį inkhaii!” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter neediil'ee akhai' ąįį juu Jesus ditsyaa nąįį tee ch'andaa yeet'iindhan niił'in, nijin neech'aga'aa dąį' Jesus eeghaii niighit kwaa dhidii chy'aa ąįį niił'in ts'ą' Jesus oahkat. “Diik'eegwaadhat, juu diitee gwintł'ee nahahchyaa t'oonchy'aa?” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nijin Peter ąįį dinjii niił'in dąį', Jesus oahkat, “Shik'eegwaadhat, jii dinjii aiiyu'?” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","“K'ineehihdik gwats'ą' goondaii oihnyąą ji', jaghaii geenjit tr'igwiindii? Aanaii, shatąįį hinkhaii!” Jesus yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Vitsyaa nąįį ąįį gootee dinjii ch'ihłak niheedhaa kwaa łee ginyąą ts'ą' geenihłagogwaandak. Gaa Jesus ąįį dinjii niheedhaa kwaa nyąą t'inyąą kwaa jii ąįį jyaa nyąą t'inyąą; “K'ineehihdik gwats'ą' gwandaii oihnyąą ji', jaghaii geenjit tr'igwiindii?” ");
INSERT INTO gwiNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jii deegwee'ya' gwinyąą t'ee John gwąąh'ya' ts'ą' gwadąąntł'oo; ąįįts'ą' deiinyą' datthak łi'didlii nilii ts'ą' geenjit gaagwiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus łyaa ants'ą' gwinlęįį vagwandak gwanlii ts'ą' gaa datthak vik'iteech'adarantl'oo ji', tr'ihkhit dęhtły'aa lęįį heelyaa ts'ą' jii nankat duuyeh yuutą'!");
INSERT INTO gwiNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Shalak Theophilus, shidęhtły'aa zhit nats'ą' ch'adanǫįįtł'oo dąį', nijin Jesus, tr'ookit digwitr'it t'agwah'ya' dąį' dee'ya' ts'ą' jidii eech'oaałtan kwaii vakat danoiitł'oo, ");
INSERT INTO gwiNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","dahthee zheekat gwits'ee heedyaa gwats'ą'. Ch'anky'aa Shroodiinyąą k'iighai' yeedak neerahoondal gwehkįį dąį', tr'ihił'ee nąįį deegihee'yaa geenjit gwitee tr'agoovinlii goovaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nijin tr'iiłkhwąįį tł'ęę drin 40 gąhkhyuk shriit'agwąąnchy'aa, yihił'e' nąįį ts'ą' idigweelkįį. Łyaa neegwiindaii geenjit gwinlęįį gwizhit goots'ą' idigweelkįį ts'ą' giiyąąh'ya' ts'ą' Vit'eegwijyąhchy'aa Veegwinii'ee eenjit gavaa ginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nijin khaihłan nigiinjil dąį' Jesus jyaa gavahnyąą, “Dzaa Jerusalem kwaiik'it gwachoh gihłeehohjyaa shrǫ', gaa jidii nakhwantł'eerehee'aa nakhwaagwaldak ąįį Shiti' nakhwantł'eeyehee'aa nyąą chy'aa gwats'ą' nagoodhoo'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","John chųų haa chųų nakhwats'an iłtsąįį, gąą ninghit kwaa t'ee Ch'anky'aa Shroodiinyąą nakhwats'an tr'ahahtsyaa t'oonchy'aa,” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nijin zhat, Yihił'e' nąįį łineegiljil dąį' Jesus goahkat, “K'eegwaadhat, Israel gwich'in tr'iinlii ts'ą' adats'ą' k'eeneegwarahaadhat ji' geenjit juk nik'ee duulee diits'iinyąą?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus t'agoovahnyąą, “Nijin Shiti' deegwii'in gwik'it t'igwehee'yaa, niindhan ąįį adah zhrįh gaandaii ąįįts'ą' gwats'ą' k'eegwaadhat t'inchy'aa. Nijin ji' zhat nigweheedhaa, ąįį gaakhwandaii gwat'oohchy'aa kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gaa nijin Ch'anky'aa Shroodiinyąą nakhwak'aa t'iizhik ji' t'aih oohohdal, ąįį haa sheegohoondak ts'ą', Jerusalem kwaiik'it gwizhit, Judea nankak datthak, Samaria nahkat gwizhit ąįįts'ą' nihky'aa nankak datthak sheegohoondak t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jii kwaii datthak gwik'it t'iinyą'. Ąįįtł'ęę giiyąąh'in gwiizhik zheekat k'iidak tr'ineediindhat. Zheek'ǫh zhit gwats'ą' hiljii dhidlit. Izhik gwats'an neegiiyąąn'ya' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Izhik k'iidak tth'aii gwagwah'in gwiizhik khan hee dinjii neekwąįį gwach'aa daagąįį nagaazhii giveeghaii nagadhat nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Galilee gwich'in nąįį, jaghaii k'iidak zhee zhit gwizhrįh aakin gǫǫ'įį? Jesus nakhwałeehoozhii ts'ą' zheekat gwats'ą' neeroonjik t'inchy'aa. Nats'ahts'ą' k'iidak tr'ineediindhat gwik'it t'inchy'aa ts'ą' k'ineeheedik t'inchy'aa.” ąįį dinjii neekwąįį nąįį jyaa googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ąįįtł'ęę Taih Vakat Olives Nahshii, gwats'an yihił'e' nąįį Jerusalem gwits'ee gahoojil. Kwaiik'it gwachoh geeghaih (½) mile gąhthee goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ąįįtł'ęę Jerusalem gwizhit nijin zheh gwigwich'įį chy'ąą k'ineegiidal dąį', ch'iyeedak zheh deegaajil. Jii nąįį t'ee goolat zhat dilk'ii, Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, Alphaeus vidinji' James, Simon Zealot nilįį, James vidinji' Judas, jii nąįį giinlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ąįį nąįį datthak, Jesus vahan Mary ts'ą', Jesus vachaa nąįį ts'ą' tr'injaa lat nąįį haa nigiilzhii ts'ą' datthak khaihłak geenjit gwintł'oo khadigigiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Dinjii gwik'injiighit 120 aanchy'aa nąįį khaihłan łineegiljil. Ąįį gootee Peter needhikhin ts'ą' goots'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Shijyaa nąįį, jii yeenaa dąį' yeenii King David nats'ąą deegweheenjyaa datthak geeginkhe', Ch'anky'aa Shroodiinyąą yaagwaandak gwik'iighai', Dęhtły'aa Choh zhit gwadanakhwatł'oo gwik'it t'igwiizhik. ‘Judas, Jesus gooheendal eenjit gwats'ą' goovahaadlii,’ gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas diitee ch'ihłak inli'. Adan chan jii gwitr'it t'agwarah'in vats'an dhidlit.” Peter gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Tr'agwaanduu gwitr'it t'agwah'ya' gwit'įį larąą oonjik. Ąįį haa nan oiinkwat. Ąįįtł'ęę kheech'ilchaa ts'ą' niindhat. Izhik zhak diki' kat neet'aanąįį, vazhrak łeedhach'aa ąįįts'ą' vits'ik datthak khaiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalem gwich'in nąįį datthak giiyeenjit gwiitth'ak. Ąįįts'ą' ąįį nan Akeldama giiyahnyąą. Digiginjik ky'aa, “Dah deek'it.” ginyąą t'iginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“Psalms dęhtły'aa kat gwadanakhwatł'oo, ‘Dinjii ch'ihłak gaa nijin gwich'įį ąįį tr'igwiheechy'aa kwaa gwizhrįh.’ Jii chan gwadanakhwatł'oo. ‘Dinjii ch'ihłak yideek'it gwitr'it neegooheendal gwizhrįh.’” ");
INSERT INTO gwiNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Jii geenjit diitee ch'ihłak yideek'it neegooheendal goo'aii. Dinjii khit diihaa t'inchy'aa nąįį tee gwats'an ch'ihłak Jesus zhik gwa'an diinaa k'eekhwazhii gaandaii nąįį t'ireheelyaa, John chųų yats'an iłtsąįį tr'ąąh'ya' gwats'an yeedak zheekat gwats'ą' neeroonjik gwats'ą' datthak. Diikhwan diitee gwagwaanchy'aa gwats'an ch'ihłak Jesus neegwiindaii geegwahaandak gadhan ji', ąįį t'ireheelyaa.” Peter gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Dinjii neekwąįį nąįį igwigweełkįį. Gavoozhri' Joseph ts'ą' Matthias haa goozhii. Joseph voozhri' chan Barsabbas ts'ą' Justus haa oozhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ąįįtł'ęę khagideedi', “K'eegwaadhat, dinjii teegwagwaanchy'aa ts'ą' jidii yiindhan ąįįts'ą' ninjich'aradhat datthak gaanandaii. Jii geh'an dząą neekwąįį nąįį nadhat, ąįį ch'ihłak diineenjit agwąąhkįį. Judas nijin gwats'ą' heekhaa goo'aii izhik gwats'ą' haazhii. Gąą jii ch'ihłak yideek'it gooheendal. Ąįįts'ą' Tr'ihił'e' nąįį tee ch'ihłak heelyaa ts'ą' diihaa gwitr'it t'agwahah'yaa. Ąįį geenjit diiteetr'ąąhchįį.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ąįįtł'ęę gavoozhri' gwizhit giinlii. Ąįį ts'an ch'ihłak khagąhtsuu. Akhai' Matthias voozhri' khagąhtsuu. Ąįįt'ee Tr'ihił'e' 11 nąįį haa niinzhii ts'ą' 12 neegaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nijin Jews nąįį ch'ara'aa gwagwahtsii dąį', Pentecost Drin goozhii, gavaa ąįį gwizhit nigwiindhat dąį', juu gwik'injiighit nąįį datthak łigeeljil. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Khants'ą' zheekat gwats'an gwihiilk'įį, ahtr'aii choh nint'aii haa ahtr'aii nagwaanąįį. Zheh gwizhit juu dilk'ii nąįį datthak gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ąįįtł'ęę kwankyaa k'it t'inchy'aa nigiił'in. Ąįįts'ą' lęįį dhidlit. Ąįį ts'an kwankyaa tsal k'it t'inchy'aa gooteegwagwaanchy'aa ts'ą' gooki' k'ąą t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ąįįtł'ęę Ch'anky'aa Shroodiinyąą gook'aa t'iizhik gwik'iighai', nihła'adan nankak gwich'in nąįį ginjik ky'aa giginkhii nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Izhik dąį' Jews lęįį nąįį Jerusalem gwizhit gwigwich'įį, Vit'eegwijyąhchy'aa eeroołtin giinlii ts'ą' nihła'adan nahkat datthak gwats'an geedaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nijin deegwiintsai' gwigwiitth'ak dąį', Jews ch'adanh nahkat lęįį nąįį nijin t'igwiizhik, izhik łigeeljil. Izhik dąį' dinjii lęįį nąįį juu gwik'injiighit nąįį googinjik ky'aa giginkhii googiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Łyaa geegaroolii kwaa t'igwiizhik ts'ą' jyaa diginyąą, “Jii dinjii diiginjik ky'aa ginkhii nąįį datthak Galilee gwich'in nąįį ginlii t'iginyąą! ");
INSERT INTO gwiNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nats'ahts'ą' nijin diigoodlit gwa'an diiginjik ky'aa diits'ą' giginkhii lee t'iginyąą ginyąą? ");
INSERT INTO gwiNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Parthia, Media, Elam, Mesopotamia, Judea, Cappadocia, Pontus, Asia, Phrygia, Pamphylia, Egypt, Libya nahkat Cyrene geeghaih gwats'an, ąįįts'ą' Rome diilat lęįį nąįį nihła'adan nahkat gwats'an tr'inlii t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Diilat lęįį nąįį Jews nilįį. Ąįįts'ą' diilat nąįį chan Jews gwich'in nilįį kwaa gaa Jews nąįį k'it gwik'injiighit ąįį geenjit dzaa gwats'ą' nirįįnjil. Diilat nąįį Crete njuu goo'aii gwats'an ąįįts'ą' diilat nąįį Arabia nahkat tr'iinlii. Googaa datthak diiginjik ky'aa gwigwee'in Vit'eegwijyąhchy'aa dee'ya' gwinlęįį geegiginkhii. Akhai' diiginjik ky'aa giginkhii gwinzii gooriitth'ak.” datthak jyaa nihłagaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jii deegwii'in t'igwii'in gaagiindaii kwaa. Ąįįts'ą' geegaroolii kwaa t'igwiizhik, “Jidii eenjit t'igwii'in li'?” gwinlęįį jyaa diginyąą ts'ą' nihłagwaakat. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gąą goolat nąįį gooveegeedlaa, “Gwintł'oo jak chų' giinįį ts'ą' ch'aganakhwanį'!” t'iginyąą googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ąįįtł'ęę Peter Tr'ihił'e' 11 nąįį haa nidhikhin dąį' gwint'aii ginkhii haa dinjii lęįį nąįį ts'ą' ginkhii, “Shalak Jews nąįį, ąįįts'ą' Jerusalem gwich'in nąįį haa, jii t'igwiizhik geenjit nakhwats'ą' gihihkhyaa gwinzii shoodǫǫhk'įį. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ch'iriinįį diinohnyąą gąą ch'iriinįį t'igwii'in kwaa. Dinjii nąįį vanh 9 o'clock gwehkįį ch'igiheenjyaa geenjit tr'ihkhit vanh dąį' gwanlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gaa jii t'igwiizhik gohtth'ak ąįįts'ą' gooh'in geenjit, Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį Joel oozhii, ąįį deenaadąį' ch'adąąntł'oo. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Khaiinkǫǫ Drin zhit gweedhaa ji', jii kwaii t'ihishi'yaa Vit'eegwijyąhchy'aa nyąą. Shanky'aa Shroodiinyąą dinjii nąįį datthak k'ąą t'ihihłyaa. Nidinji', ts'ą' nichį' nąįį haa sheenjit gigiheehkhyaa giheelyaa. Tsyaa k'eejit nąįį shats'an k'eegwiichy'aa gagwahąh'yaa, gineegiinlyaa k'it t'inchy'aa haa. ch'anjaa nąįį gineegiinlyaa zhit goots'ą' gwagwahaałkyaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aahą', shitsyaa sheenjit gwitr'it t'agwah'in nąįį dinjii, akwat tr'injaa nąįį haa jii zhit drin ji' Shanky'aa shroodiinyąą gook'aa t'ihihłyaa. Geedan t'ee sheenjit gigiheehkhyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Zheetii gwa'an gwidii'in t'ishi'yaa ts'ą' dzaa nankak chan nindal gwaahchy'aa haa gwigwee'in t'ishi'yaa. Izhit zhat nagwaanąįį ji' dah, kǫ', ts'ą' gwintł'oo łat haa gweheelyaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Shree haa ch'ahaadrii kwaa. Tǫǫ'oozhrii chan dah k'it daatsik heelyaa. Ąįįtł'ęę t'ee, K'eegwaadhat vijiintsii choh ts'ą' vich'eegwąhndit haa nineeheedyaa gwehkįį t'igweheenjyaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Zhat nagwaanąįį ji' juu K'eegwaadhat nyąą ts'ą' oozhrii nąįį neegeheezhii t'oonchy'aa.’” ");
INSERT INTO gwiNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peter tth'aii hee goots'ą' ginkhii, “Israel gwich'in nąįį, shoodǫǫhk'įį. Jesus, Nazareth gwats'an ahaa eenjit nakhwats'ą' giihkhii t'ihnyąą. Vit'eegwijyąhchy'aa yits'iinyą' ts'ą' łyaa niindal gwaa'in gwitr'it t'agwah'in ąįį gwigwee'in k'iighai' t'ii'in, ąįį łyaa nakhwan gaakhwandaii geenjit t'ihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Deenaa dąį' gwanaa Vit'eegwijyąhchy'aa deehishi'yaa, yiindhan. Ąįį gwizhit ‘Jesus nakhwantł'eerahahchyaa.’ yiinghya'. Ąįį dinjii tr'agwaanduu tr'agwah'in nąįį nakhwak'iighai' cross kat gigiiyiłtsak. Ąįįts'ą' dǫǫhkhwąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Gąą Vit'eegwijyąhchy'aa k'iighai' neegwiindaii. Niindhat gaa ch'ichį' heelyaa gwits'į' gwats'an tr'ineeyahchįį. Ąįįts'ą' khit ch'ichį' heelyaa veenjit goo'aii kwaa. Łyaa ch'ichį' ndaat'ąąht'aii t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Deenaa dąį' jii King David, Jesus eenjit gwadąąntł'oo, ‘Khit Shik'eegwaadhat shaa nilįį, gaashandaii. Shits'iheenjyaa eenjit shaa nilįį. Jii geh'an k'eegwiichy'aa datthak gaaljat kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ąįįts'ą' shoh gwanlii haa gihkhii, dinjii niinjik nąįį k'it nihihthaa. Gaa nijin niidhat ji', Vit'eegwijyąhchy'aa chan neegwihįhdaii neeshahahtsyaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Shik'eegwaadhat, shanky'aa tth'ank'it zhit akhoohiinjyaa kwaa, gaashandaii. Shįį, Nitsyaa Shroodiinyąą ihłii ąįįts'ą' tth'ank'it gwizhit shatthąį' an heelyaa gwats'ą' t'ahąhkhyaa kwaa gaashandaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","K'eegwiichy'aa t'eehishi'yaa sheenjit goo'aii gwandaii ndaanąą'ąį' kwaa hishi'yaa geenjit, jii gaahashandaii sheenjit gǫǫhtsąįį. Nijin naa t'ihchy'aa ji' łyaa shoo hihłyaa naa t'ihchy'aa geenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Shalak nąįį, łyaa gwigweech'in ts'ą' nakhwats'ą' gihihkhyaa, diitsii King David eenjit. Deenaa dąį' niindhat ts'ą' vanarąąhjik. Googaa juk drin tth'aii hee vatth'ank'it diihaa goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David łyaa Vit'eegwijyąhchy'aa Eenjit Ginkhii inli'. Vit'eegwijyąhchy'aa deehishi'yaa nyąą gwik'it t'ihee'yaa nyąą t'inyąą yits'ą' neech'idiin'ąįį, vizhyaaneedijii nąįį ch'ihłee nats'ąą king inli' gwik'it king heelyaa eenjit David haagwandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Yeendaa ji' Vit'eegwijyąhchy'aa deehee'yaa David ts'ą' gwigweelkįį, ąįįts'ą' Christ neegwiindaii ąįį chan geeginkhe', ‘Vizhin ts'ą' Vatthąį' haa tth'ank'it gwizhit an giheelyaa geenjit gwats'ą' t'ahąhkhyaa kwaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jii t'ee Jesus nilįį. Niindhat tł'ęę Vit'eegwijyąhchy'aa gwandaii neeyiłtsąįį. Datthak tr'agwah'ya' ąįį eenjit łi'didlii haa nakhwaa gwaraandak t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Vit'eegwijyąhchy'aa nijin t'inchy'aa gwats'ą' neeyuunjik. Juk izhit k'eedeegwaadhat ts'ą' yakat doodii ąįį zheekat nijin gihil'ee izhit Vit'eegwijyąhchy'aa vishriits'ąįį dhidii ąįįts'ą' Gwiti' deehee'yaa nyąą ąįį gwik'it t'iizhit ts'ą' Ch'anky'aa Shroodiinyąą diik'aa t'iheelyaa geenjit yats'an iłtsąįį, ąįįt'ee juk drin gǫǫh'in ts'ą' goohtth'ak t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","David yeedak zheekat ndak hahkhaii kwaa gaa jii jyaa nyąą, “Vit'eegwijyąhchy'aa ts'ą' ąįį Shik'eegwaadhat jyaa dahnyąą. ‘Dząą dakhii shishriits'ąįį dhindii, juu nats'ą' gwił'ąįį ts'ą' nitr'ii'ee nąįį nakwai' t'eh nagooveheelyaa gwats'ą' datthak zhat dhindii k'eedeegwaadhat nahałtsyaa geenjit.’ ");
INSERT INTO gwiNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Israel gwich'in nąįį datthak, Jesus, jii adan nilįį. Cross kat gadhohtsak t'inchy'aa. Vit'eegwijyąhchy'aa, K'eegwaadhat heelyaa yiłtsąįį ts'ą' dinjii nąįį neehahshii geenjit yigweełkįį t'inchy'aa. Ąįį gaahahkhwandaii gwizhrįh.” Peter goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jii datthak gwigwiitth'ak dąį', gwintł'oo tr'igwigwidii, “Shalak nąįį, juk nats'ahts'ą' deehishi'yaa?” jyaa Peter ąįįts'ą' gah Tr'ihił'e' nąįį jyaa dagahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","“Nakhwateegwagwąąnchy'aa ts'ą' nakhwatr'agwaanduu gwats'an K'eegwaadhat ts'ą' łihts'eedǫǫ'ee. Ąįįts'ą' tr'agwaanduu t'akhwa'in gwinzii t'igwii'in yųhkhya' shrǫ'! Ąįį tr'agwaanduu t'inchy'aa. Ąįįtł'ęę nakhwateegwagwaanchy'aa ts'ą' Jesus Christ voozhri' zhit chųų nakhwats'an tr'ahtsii. Ąįįtł'ęę Vit'eegwijyąhchy'aa nakhwatr'agwaanduu nakhweenjit oo'an gweheelyaa. Ąįįts'ą' Ch'anky'aa Shroodiinyąą nakhwats'an hahtsyaa nakhwaa t'iheechy'aa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nakhwan, ts'ą' nakhwagii nąįį haa nihky'aa ninghit gwich'in nąįį datthak gooteegwagwaanchy'aa ts'ą' K'eegwaadhat Nakhwavit'eegwijyąhchy'aa yigwiiłkįį nąįį, Ch'anky'aa Shroodiinyąą goots'an hahtsyaa, gavaa t'iheechy'aa eenjit. Jii gwehkįį ‘deehishi'yaa,’ jiinyą' gwik'it t'ihee'yaa eenjit.” jii chan Peter jyaa dagavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ąįįts'ą' łyaa ninghyuk Peter gwintł'oo goots'ą' ginkhii, “Juk gweendaa dinjii tr'agwaanduu tr'agwah'in nąįį khaiinjich'iheedhat gwats'ą' gweedhaa t'oonchy'aa ąįį gwats'an tr'ineekhwadaa geetr'agoh'in neehohshii geenjit.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Lęįį nąįį jidii geenjit goots'ą' ginkhe' gwik'injigiinjik. Ąįįts'ą' datthak chųų goots'an tr'iłtsąįį. Ąįį drin zhit dinjii 3,000 aanchy'aa nąįį K'eegwaadhat Jesus k'injigiighit gaadlit ts'ą' juu gwik'injiighit nąįį teegiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ąįįtł'ęę Tr'ihił'e' nąįį khit geegoogąąhtan, ąįįts'ą' datthak gavaa łineegaadal ts'ą' goovaashroonchy'aa gwizhit neech'aga'aa haa ninjigwadhat gahtsii zhit K'eegwaadhat ineegaandaii. Ąįįts'ą' datthak gavaa khagigidiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tr'ihił'e' nąįį zhit gwinlęįį gwigwee'in ts'ą' nindal gwaahchy'aa t'igii'in. Dinjii nąįį gwagwaah'in haa jii datthak giveenjit geegaroolii kwaa t'igwii'in, ąįįts'ą' gihilghaa ts'ą' gwigwihił'ee. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Gąą juu gwik'injiighit nąįį datthak lak nizįį nihłagaa'įį ts'ą' nihłaa t'iginchy'aa. Nihłak'aiich'ii datthak nihłaa t'agąhchy'aa googwahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Daganan' ąįįts'ą' digik'eiich'i' kwaii datthak gwintł'eegilii. Ąįį t'įį larąą goonjii khaihłan nigiinlii, ąįį ts'an juu gii'įį kwaa ts'iginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Drin gwiteegwagwaanchy'aa Kharigidiinjii Zheh gwizhit łineegaadal. Ąįįts'ą' an-nihłik zheh gwizhit nihłaa ch'aga'aa. Ąįįts'ą' goodrii zhit gavaa łi'haa shroonchy'aa ts'ą' nihłaa datthak ts'ą' khazhak t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Khit ts'ą' Vit'eegwijyąhchy'aa ts'ą' khagigidiinjii. Ąįįts'ą' deegiihiił'ee. Jerusalem gwizhit dinjii nąįį datthak gwinzii giveegigiinkhii. Drin gwiteegwagwaanchy'aa dinjii nąįį Vit'eegwijyąhchy'aa gootr'agwaanduu ts'an neegoorahshii nąįį chan gootijyaa. Ąįįts'ą' drin gwiteegwagwaanchy'aa lęįį gilii. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ch'ihłan drin drintł'an 3 o'clock gwandaa gweedhaa dąį', Peter, John haa Kharigidiinjii Zheh gwats'ą' gahaa'oo. Jews nąįį drin gwiteegwagwaanchy'aa zhat nagwadhat dąį' gwizhit khagigidiinjii gwideek'it gogwaa'įį geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kharigidiinjii Zheh izhik gindeiinvyaa choh gwinzii viyiichy'a', ąįį giiyoozhri' ąh'įį. Drin gwiteegwagwaanchy'aa jii gindeiinvyaa choh geeghaih dinjii vagoodlit dąį' gwats'an neehidik kwaa zhat nineegahchik, ts'ą' dinjii nąįį ts'an laraa oodiheekwat geenjit zhat dhidii. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Peter, ts'ą' John haa nihdeegaa'oo, goovah'in dąį', k'aiich'ii giiyintł'eehee'aa ji' eenjit goots'ą' ch'oodiikwat. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Gwinzii giiyąąh'in tł'ęę “Diinąąh'in!” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ąįįts'ą' gwinzii gavąąh'in, laraa giits'an hahtsyaa ji' geenjit niindhan haa. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","“Larąą shi'įį kwaa. Gąą k'eegwiichy'aa neenjit t'ihishi'yaa, Jesus Christ Nazareth kwaiik'it gwats'an ahaa voozhri' k'iighai'. K'iidak ninkhee ts'ą' neehindik.” Peter jyaa yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Shriits'ąįį yanli' oonjik ts'ą' ndak niheedhat geenjit yits'inyąą. Googwahkhan vakweechan ts'ą', vakwai' ts'an t'aih neegahoodlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","K'iidak nidhikhin ts'ą' zhat nadhat. Ąįįtł'ęę neehidik shoh ts'ą' naatłak. Kharigidiinjii Zheh gwizhit gavaa nihdeiinzhii. Neehidik ts'ą' naatłak gwizhit Vit'eegwijyąhchy'aa deehiił'ee. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Zhat dinjii nąįį datthak neehidik ts'ą' Vit'eegwijyąhchy'aa deehiił'ee giiyąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Jii dinjii Kharigidiinjii Zheh gindeiinvyaa choh, ndaat'inchy'aa, geeghaih khit dhidii ts'ą' ch'oodiikwat chy'ąą t'inchy'aa łee, łyaa geegagoolii kwaa gooveenjit t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Zhat Kharigidiinjii Zheh gwizhit gwadąįį Solomon charantąįį goozhii, izhik Peter, ts'ą' John haa nagadhat. Gavoontą', gooviłeehidii gitr'ii'ee. Zhat gwizhit dinjii nąįį datthak geegaroolii kwaa gooveenjit t'igwiizhik. Ąįįts'ą' dinjii nąįį datthak goots'ą' gal gihiłjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nijin Peter dinjii nąįį datthak zhat niinjil, gwąąh'in dąį', goots'ą' khaginkhee, “Israel gwich'in shalak nąįį ǫhłii, jaghaii jii t'igwiizhik łyaa geegohłii kwaa t'igwiizhik, geenjit aakin diinoo'įį? Jii t'igwiizhik, diit'aii akwat Vit'eegwijyąhchy'aa vik'iighai' tr'iinzii geh'an ąįį dinjii neehidik neeriłtsąįį t'igwii'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yeenii diitsii Abraham, Isaac, Jacob, haa Goovit'eegwijyąhchy'aa, ditsyaa Jesus ch'eegwąhndit gwintł'oo gwihil'ee yantł'eegwiin'ąįį, gaa ąįį gwidinjii k'eedeegwaadhat nąįį ts'ą' gwantł'ohchįį. Pilate vineeroonjii yuunyąą gaa nakhwan ąįį vanoohjii gatr'ǫǫh'ee. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Łyaa shroodiinyąą nilįį ts'ą' Vit'eegwijyąhchy'aa vik'eegwahthat, gąą nakhwan vatr'ǫǫh'ee. Ąįįts'ą' ch'izhii dinjii diłkhwąįį ąįį yideek'it chanoozhi' vohnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jii geh'an Jesus t'ee dinjii nąįį gwandaii ts'an ąhtsii heelyaa, ąįį dhookhwąįį. Gąą Vit'eegwijyąhchy'aa niinjik nąįį tee gwats'an gwandaii neeyiłtsąįį. Jii datthak gwarąąh'ya', ąįį geenjit nakhwaagwaraandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jii dinjii shranaanzhik neeriłtsąįį jidii gooh'in ts'ą' gaakhwandaii t'ee Vigwik'injigwiighit ts'ą' Jesus vat'aii haa gwinzii neehidik neekhwadlit t'inchy'aa. Nakhwan datthak juk nǫh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Shalak nąįį, nijin tr'iiłkhwąįį dhohtsąįį dąį', deekhwa'in t'akhwa'in, gaakhwandaii kwaa. Izhit gaashandaii. Nakhwak'eedeegwaadhat nąįį chan gwik'it t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Deenaadąį' Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį nąįį k'iighai', “Va-Christ khaiinjich'iheedhat!” ginyąą. Jii k'iighai' Vit'eegwijyąhchy'aa nats'ąą ginkhe' datthak łi'deegwidlii goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nakhwateegwagwąąnchy'aa ts'ą' nakhwatr'agwaanduu gwats'an K'eegwaadhat ts'ą' łihts'eedǫǫ'ee. Ąįį ji', tr'agwaanduu t'akhwa'ya' datthak nakhweenjit oo'an gweheelyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","K'eegwaadhat vats'an t'aih shroodiinyąą tr'ihee'yaa, ts'ą' Jesus, t'ee Messiah nilįį gwiteetr'ahchįį ąįį nakhwats'ą' nahahchyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Deenaa dąį' Vit'eegwijyąhchy'aa Eenjit Ginkhii shroodiinyąą nilįį nąįį k'iighai' jyaa diginyąą, “K'eegwiichy'aa datthak k'eejit neegwahahtsyaa gwats'ą' datthak Jesus zheekat t'iheechy'aa.” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yeenaa dąį' Moses jyaa nyąą, ‘Nakhwak'eegwaadhat Vit'eegwijyąhchy'aa ch'ihłak yeenjit ginkhii nakhwats'ą' nahahchyaa t'inchy'aa, shįį chan shihił'e' gwik'it t'iheenjyaa t'inchy'aa. Nakhwatee gwats'an dinjii ch'ihłee heelyaa. Nats'ąą deenakhwahnyąą datthak oohoohky'aa gwizhrįh goo'aii, ąįįts'ą' deenyąą datthak gwik'it t'akhwa'yaa gwizhrįh goo'aii. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Juu ch'oołk'įį kwaa ąįįts'ą' yik'eegwahthat kwaa nąįį gwanlii ji', ąįįt'ee Vit'eegwijyąhchy'aa vigii nilįį nąįį ts'an thok nagooveheelyaa. Ąįįts'ą' an giheelyaa.’ Jyaa Moses nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel vats'an gweedhaa ts'ą' juk drin zhit gwats'ą' datthak Vit'eegwijyąhchy'aa Eenjit Ginkhii nąįį datthak jyaa digiinyą' ts'ą' geegwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Vit'eegwijyąhchy'aa, Yeenjit Ginkhii Nąįį k'iighai' deehee'yaa nyąą ąįį gwik'it t'ihee'yaa t'ee nakhweenjit t'oonchy'aa, ts'ą' Vit'eegwijyąhchy'aa, nakhwatsįį nąįį eenjit deehee'yaa nyąą ąįį gwik'it t'ihee'yaa, ąįį gwitee t'ohchy'aa. Vit'eegwijyąhchy'aa Abraham jyaa dahnyąą, ‘Nihzheeneedijii nąįį k'iighai' nankak gwich'in nąįį datthak Vit'eegwijyąhchy'aa goots'ą' gwinzii t'ihee'yaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Vit'eegwijyąhchy'aa Didinji' igweełkįį ąįį nakhwan tr'ookit nakhwats'ą' niyąąhchįį, jyąhts'ą' gwik'iighai' nakhwats'iheenjyaa ts'ą' nakhwatr'agwaanduu akhagahohjyaa geenjit.” ");
INSERT INTO gwiNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Peter, ts'ą' John haa tth'aii hee dinjii nąįį ts'ą' giginkhii gwiizhik, giinkhih kįh dilk'ii nąįį lat, ąįįts'ą' dinjii Kharigidiinjii Zheh gwats'ą' k'eedeegwaadhat nilįį nąįį, ąįįts'ą' Sadducee lat nąįį, goots'ą' nigiinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Dinjii geegǫąąhtan dąį', niindhat nąįį nineegweheendaii ginyąą, Jesus niindhat ts'an neegwiindaii ginyąą geenjit gitr'igii'ee ts'ą' łyaa shoo ginlii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jii geh'an gooteegwigwįłjik ts'ą' zhee gwaazhrąįį nagoogiinlii. Tr'ihkhit tǫǫ gwanlii, geh'an gęhdaa drin gwats'ą' zhee gwaazhrąįį giheedyaa gooveenjit gwigwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jesus, eegwagwaandak ts'ą' dinjii lęįį gavoołk'įį nąįį gwik'injigiighit gaadlit ts'ą' 5000 aanchy'aa nąįį gwik'injiinjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Gęhdaa drin Jerusalem gwizhit Jews kįh dilk'ii nąįį, ch'anjaa kįh dilk'ii nąįį ts'ą', Law eech'ǫąąhtan nilįį nąįį haa datthak łigiiljil. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Dinjii Annas gwehkįį dąį' ndak khii ginkhih choh iinli', ąįį videhk'it Caiaphas ndak khii ginkhih choh nilįį, John, ts'ą' Alexander, ąįį Annas valak nąįį datthak haa łigiiljil. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ąįįtł'ęę Peter ts'ą' John haa dagats'ą' nagąąhchįį, ts'ą' googahkat, “Juu voozhri' zhit gwats'an t'aih khwa'įį geenjit t'akhwa'in?” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ąįįtł'ęę Peter, Ch'anky'aa Shroodiinyąą vizhit t'inchy'aa k'iighai', goots'ą' khaginkhee, ts'ą' jyaa gavahnyąą, “Jews kįh dilk'ii, ąįįts'ą' ch'anjaa nilįį nąįį, ");
INSERT INTO gwiNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","juk drin dinjii neehidik kwaa vits'iriinyą' eenjit diinoohkat, neehidik kwaa gwats'an neehidik neehoodlit eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jii geh'an datthak ts'ą' diinoodoohk'įį ji', nakhwan ąįįts'ą' Israel gwich'in nąįį datthak ǫhłįį ts'ą' gaakhwandaii, gwat'oohchy'aa. Jesus Christ Nazareth kwaiik'it gwats'an ahaa ąįį vat'aii k'iighai' jii dinjii shranaazhik juk dząą nakhwandaa nadhat, ts'ą' nǫh'in. Jesus Cross kat gadhohtsak ts'ą' dǫǫhkhwąįį. Gąą Vit'eegwijyąhchy'aa niinjik nąįį tee gwats'an gwandaii neeyiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jii t'ee Jesus veenjit jyąhts'ą' gwadanakhwatł'oo, ‘Zheh gwahtsii nąįį datthak, kii vaa zheh ndak gwehee'aa, ąįį kii nizįį nilįį kwaa k'it t'inchy'aa. Gaa ndaagwąą'ąį' dąį', kii hil'ee dhidlit.’ gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Dzaa nankak Jesus voozhri' zhit gwizhrįh neediirahahshii goo'aii. Vit'eegwijyąhchy'aa, nihky'aa nankak datthak gwizhit dinjii ch'ihłak gaa neediihahshii gwiłtsąįį kwaa.” Peter jyaa goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Peter, John haa łyaa geegavoltin kwaa gąą nihk'it gąąnjat kwaa haa ginkhii. Kwaiik'it k'eedeegwaadhat ts'an nilįį nąįį eenjit łyaa geegagoolii kwaa gwik'it gininjich'agahthat. Akhai' łyaa Jesus haa t'iginchy'a' gavaagiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Dinjii shrineegiinlik goovaanadhat gąąh'in, geenjit deegiheenjyaa gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jii geh'an, “Jii zheh gwats'an cheekhwajyaa!” dzaa kwaiik'it gwats'ą' k'eedeegwaadhat nilįį nąįį googahnyąą. Ąįįtł'ęę nihłihtee ts'ą' gwintł'oo geenjit nihłaa giginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Jii dinjii nąįį deegooreheelyaa? Łyaa gwigwee'in gwintsii t'igii'in, akwat nats'ahts'ą' goodirihęę'aa. Jerusalem gwizhit gwich'įį nąįį datthak jii ch'adąį' hee gaagiindaii, ts'ą' duuyeh jyaa digiizhik kwaa gwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Zhyąą goorǫhjat ts'ą' chan ch'ihłok Jesus eenjit dinjii haa googwahaandak kwaa goorohtsyaa. Ąįįts'ą' ch'adanh gwich'in nąįį giiyeenjit neegweheetth'ak kwaa eenjit.” jyaa dinihłagaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ąįįtł'ęę Peter, John haa nihdineegogąhchįį, “Dinjii ch'ihłak gąą juk gwats'an Jesus eeneech'ahohchyaa ts'ą' veegwahoondak kwaa!” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peter, John haa jyaa googahnyąą, “Juk dząą Vit'eegwijyąhchy'aa vandah, Vit'eegwijyąhchy'aa deediinahnyąą gwik'eegwarahahthat akwat nakhwan deediinohnyąą, ąįį gwik'eegwarahahthat? Ąįį nakhwakhai' giky'uunjii. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gąą diikhwan, jidii tr'agwah'ya' akwat tr'igwiitth'ak, ąįį geegwaraandak duuyeh akharagoonyąą t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ąįįtł'ęę chan gwintł'oo goozhit najat neegiin'ąįį ts'ą' gooneegiinjik. Dinjii neehidik kwaa ąįį neehidik neegiłtsąįį geenjit googwarahąąhshii giveenjit gogogwąh'ąįį kwaa. Dinjii nąįį datthak Vit'eegwijyąhchy'aa deegihił'ee geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jii dinjii Vit'eegwijyąhchy'aa t'aih k'iighai' nihidik neehoodlit t'ee 40 years gwandaa nilįį t'agahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nijin gooneegiinjik dąį', khants'ą' gwik'injiighit nąįį ts'eegoohoojil. Ch'anjaa kįh dilk'ii ąįįts'ą' giinkhih kįh dilk'ii nąįį nats'ąą deegavahnyąą datthak gavaa gwagwaandak ");
INSERT INTO gwiNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nijin gwik'injiighit nąįį datthak geenjit gwigwiitth'ak dąį', datthak khaihłok geenjit Vit'eegwijyąhchy'aa ts'ą' khagigideedi', ts'ą' jyaa diginyąą, “K'eegwiichy'aa datthak geenjit Vit'eegwijyąhchy'aa inlii. Zhee kat, nankak, chųų choh haa datthak gwizhit goodlii iłtsąįį inlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Diitsii David nakhwatsyaa nilįį ąįį Ch'anky'aa Shroodiinyąą k'iighai' nakhweenjit ginkhe' dąį' jii jyaa dinyąą, ‘Jaghaii dee aakin nąįį geenjit gwint'aii zhagąąnts'įį? Jaghaii dee gwik'it gweheelyaa kwaa gaagiindaii gwizhit geenjit ninjich'agadhat? ");
INSERT INTO gwiNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jii nankak k'eedeegwaadhat choh nąįį nich'itsagahahthat geenjit shrigwigwinlik ąįįts'ą' k'eedeegwaadhat nąįį K'eegwaadhat, ts'ą' Va-Christ haa nehts'į' nihłaa łigeeljil.’ ");
INSERT INTO gwiNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Jii łyaa gwik'it t'igwiizhik, gaagwiindaii. Ąįįts'ą' Nidinji' shroodiinyąą Jesus, dinjii neehahshii heelyaa geenjit thok videegwadǫǫhkii. Jii kwaiik'it gwachoh gwizhit Herod Antipas, ts'ą' Pontius Pilate, Jews gwich'in nąįį, Jews nilįį kwaa nąįį haa łigiiljil, “Tr'ahahkhwaa!” giiyahnyąą eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Deenaa dąį' nats'ahts'ą' deegwehee'yaa gavaiinyąą chy'ąą. Ąįį łąą gwik'it t'igee'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","K'eegwaadhat, juk diigahąąhjat eenjit jyaa diigahnyąą, ąįį gavoodǫǫhk'įį. Nitsyaa nąįį tr'inlii geh'an diits'iinyąą gwiizhik tr'ahąąnjat kwaa ts'ą' niginjik eegwarahaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nidinji' shroodiinyąą Jesus vat'aii k'iighai' iłts'ik nąįį nizįį neeheelyaa ąįįts'ą' gwigwii'in ts'ą' geegagoolii kwaa gwitr'it t'agwahaa'yaa.” Peter khadigeedi' ts'ą' jyaa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Khagigidiinjii gigiinjik tł'ęę zhat giilk'ii gwiizhit khan hee zheh datthak gwaatrat nagwaanąįį. Ąįįts'ą' Ch'anky'aa Shroodiinyąą datthak goozhit t'iizhik k'iighai', gąąnjat kwaa haa Vit'eegwijyąhchy'aa viginjik eegwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Dinjii juu gwik'injiighit nąįį datthak nihk'it ninjich'agadhat ts'ą' digidrii zhit deegwehee'yaa giindhan, ąįį łyaa gwik'it t'igii'in. Ch'ihłak gąą gootee adan zhrįh dak'aiich'ii t'aahchy'aa kwaa. Jidii gii'įį datthak khaihłok t'eegaahchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nijin Tr'ihił'e' nąįį, “Diik'eegwaadhat Jesus neegwiindaii!” ginyąą ts'ą' t'aih nint'aii haa gwagwąąh'ya' ts'ą' geegwagwaandak. Vit'eegwijyąhchy'aa vich'eegoonzhrii haa gwintsii goots'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Gootee gwats'an dinjii ch'ihłak gąą k'aiich'ii t'aahchy'aa gwanlii kwaa. Juu zheh, akwat nan haa dii'įį nąįį datthak tr'oohookwat googwahtsii ąįį giit'įį larąą goonjii, Tr'ihił'e' nąįį antł'eegilii. Nijin gootee ch'ihłak gwat'aahchy'aa gwanlii dąį' jii ts'an larąą goots'an gahtsii. Ąįį haa deegwąhtsii gwit'eegaahchy'aa gwik'it goots'iginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ąįįts'ą' Cyprus nahkat gwats'an dinjii ch'ihłak, Joseph oozhii, giinkhih Levite nąįį ts'an deedhaa nilįį. Tr'ihił'e' nąįį, giiyoozhri' niłtsąįį Barnabas giiyahnyąą. (Dinjii tr'igwidii k'it t'inchy'aa nąįį shoo nilįį ąhtsii gwinyąą t'igwinyąą). ");
INSERT INTO gwiNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Adan t'ee gook'it gwanzhįh deehk'it gwii'įį gwintł'inlii ąįį t'įį larąą oonjik ts'ą' Tr'ihił'e' nąįį antł'eeyinlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Dinjii ch'ihłak Ananias oozhii. Ąįįts'ą' va'at Sapphira oozhii. Daganan' tr'oiinkwat giłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ąįį gwalaraa lat Tr'ihił'e' nąįį antł'eegiinlii, gaa datthak gwintł'eegiiyinlii adagaa'įį. Larąą lat idigeenjit k'eegąąhtii. Va'at dee'in datthak yaandaii ts'ą' adan t'ee veechįį t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter gwint'aii jyaa diiyahnyąą, “Ananias, jidii t'ihini'yaa kwaa ąįį t'inizhik, Satan jyaa nahnyąą k'iighai'. Ch'anky'aa Shroodiinyąą ts'ą' oonts'it. ‘Nanan tr'oiinkwat, ąįį gwalaraa datthak gwantł'eiinlii,’ diinyąą gąą gwik'it t'inizhik kwaa. Valat tth'aii hee khadhanzhii. Ąįį haa Ch'anky'aa Shroodiinyąą tsinteehąąhkaii gwik'eegwiindaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nan gwitł'eehinlyaa gwehkįį dąį' gwats'an, nanan nilįį t'inchy'aa. Ąįįtł'ęę gwit'įį larąą oodhiinjik, ąįįt'ee nalaraa t'inchy'aa. Nats'ahts'ą' vat'oołchy'a' oiinyąą gwik'it vit'eehąąhchy'aa goo'aii. Jaghaii jyaa dooshi'ya', yiindhan? Dinjii zhrįh ts'ą' oonts'it kwaa, gąą Vit'eegwijyąhchy'aa chan ts'ą' oonts'it gwizhit vininjigwanzhii t'ini'in.” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nijin Ananias gwiintth'ak dąį', khants'ą' niindhat. Dinjii nąįį niindhat gwigwiitth'ak dąį', łyaa datthak gąąnjat nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ąįįtł'ęę tsyaa zhat dilk'ii nąįį gwach'aa giinǫǫłjik. Ąįįts'ą' cheegiihiłchįį tł'ęę giinąąhjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Shriit'ahkhyuk gwahaadhat tł'ęę va'at chan zhat nihdeiinzhii. Vakai' niindhat geenjit tth'aii hee gwiitth'ak kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter jyaa yahnyąą, “Nijin nakhwanan gwantł'oolii dąį', jii larąą zhrįh lee gwit'įį oodhoojik?” “Aahą', jii zhrįh tr'oonjik.” Sapphira yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","“Jaghaii nan ts'ą' nakai' haa K'eegwaadhat Vach'anky'aa Shroodiinyąą tsinteehookaii gwik'eegǫhdaii? Yee'at chiitąįį tsyaa nąįį nakąį' anagąąhjik juk dilk'ii ts'ą' nan chan dząą gwats'an chineenagahahchyaa t'oonchy'aa.” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sapphira yats'ą' nadhat gwiizhik zhat googwahkhan adan t'ee niindhat. Ąįįtł'ęę tsyaa nąįį nihdeegiinjil, niindhat giiyąąh'in. Adan t'ee cheegiiyihiłchįį, ts'ą' giikąį' eeghaii giinąąhjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jii t'igwiizhik geh'an juu Jesus k'injiighit nąįį datthak, gwiitth'ak dąį' gwintł'oo gihilghaa ts'ą' gąąnjat nagaanaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tr'ihił'e' nąįį dinjii tee gwinlęįį gwigwee'in ts'ą' nindal gwaahchy'aa gwitr'it t'agwagwah'in. Kharigidiinjii Zheh gwizhit gwadąįį charantąįį Solomon goozhii, izhik Jesus k'injiighit nąįį nihłaa łineegaadal. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Dinjii nąįį datthak goodigihił'e' gaa gooteegiheedaa geenjit łyaa gagąąnjat. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Googaa dinjii, ts'ą' tr'injaa haa lęįį nąįį K'eegwaadhat k'injigiindhat ts'ą' ąįį nąįį K'eegwaadhat k'injiighit tee giinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tr'ihił'e' nąįį gwigwee'in gwinlęįį t'igii'in gwigwiitth'ak k'iighai' iłts'ik nąįį tąįį gwinjik gwats'ą' gahaadlii eechehk'it, ts'at haa kat deegoogiinlii. Jii t'igii'in, Peter zhat tąįį gwinjik heekhaa goo'aii, vagwank'oh gookat t'iheenjyaa ji' geenjit, ąįį haa gooveenjit gwinzii neegweheelyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Geeghaih gwa'an kwaiik'it gwatsal goodlii gwats'an dinjii lęįį nąįį Jerusalem k'eedal. Dagalak iłts'ik nąįį ąįįts'ą' dinjii ch'anky'aa iizųų di'įį nąįį haa adahaa k'eegilik. Datthak Tr'ihił'e' Nąįį goots'ą' tr'iinjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndak khii ginkhih choh, vaa kįh dilk'ii nąįį ts'ą' Sadducee ts'an nilįį nąįį haa Tr'ihił'e' nąįį ts'ą' gwintł'oo shooginlii kwaa. Gooveenjit k'eegwiichy'aa t'igwehee'yaa gwizhrįh giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Tr'ihił'e' Nąįį teegwigwįłjik ts'ą' zhee gwaazhrąįį nagoogiinlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Izhik tǫǫ K'eegwaadhat vizheekat gwich'in ch'ihłak zhee gwaazhrąįį gindeiinvyaa giveenjit gihdįįntin ts'ą' cheegaviinlii. Ts'ą' jyaa gavahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kharigidiinjii Zheh gwizhit nihdǫhjyaa. Izhik gwizhit nohthat ts'ą' gwandaii k'eejit eenjit dinjii nąįį haa goondak.” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Vanh dąį', Tr'ihił'e' nąįį Kharigidiinjii Zheh gwats'ą' gahaajil ts'ą' eech'agǫąąhtan. Izhik gwiizhik chan ch'adanh gwa'an ndak khii giinkhih choh, dalak nąįį haa Jews ch'anjaa nilįį nąįį, Israel nahkat gwats'ą' k'eedeegwaadhat nąįį haa łigiiljil. Izhik gwiizhik niveet'ah'in nąįį zhee gwaazhrąįį gwats'ą' gihił'e', Tr'ihił'e' nąįį oo'ee neegeheelyaa ts'ą' googahaahkat eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Gąą niveet'ah'in nąįį zhee gwaazhrąįį k'eegiidal dąį', googwagwah'ąįį kwaa ts'ą' zhyąą oo'ee neegeejil ts'ą' jyaa diginyąą, ");
INSERT INTO gwiNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Zhee gwaazhrąįį k'eeriidal dąį', gindeiinvyaa łyaa gwinzii gihdįįntin. Ąįįts'ą' gwak'ąąhtii nąįį chan zhat gwadąįį nigiilzhii, tr'agwah'in. Gąą nijin nihdeeriinjil dąį', dinjii ch'ihłak gaa gwizhit dhidii kwaa!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nijin niveet'ah'in kįh dhidii Kharigidiinjii Zheh gwizhit gwak'ąąhtii nąįį ąįįts'ą' giinkhih kįh dilk'ii nąįį haa gwigwiitth'ak dąį', Tr'ihił'e' nąįį deegiizhik li' gaagoondaii giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Gwiizhit dinjii ch'ihłak nihdeiinzhii ts'ą' gootee khaginkhee, “Shoodǫǫhk'įį! Dinjii zhee gwaazhrąįį noolii chy'ąą, juk Kharigidiinjii Zheh gwizhit nigeelzhii ts'ą' Jesus eech'agǫąąhtan!” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ąįįtł'ęę niveet'ah'in kįh dhidii ditsyaa nąįį haa Kharigidiinjii Zheh gwats'ą' gahaajil, datthak gootee neegwigwiłjik ts'ą' oo'ee neegoogahaadlii. Gwint'aii gook'eegahąąndak ąįį zhit gagąąnjat, jyaa digii'in ji', dinjii nąįį kii haa diigooheekit giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tr'ihił'e' nąįį nihdeegoogiinlii dąį', k'eedeegwaadhat nąįį (Council) ts'ą' nigiilzhii googiłtsąįį. Ąįįtł'ęę ndak khii giinkhih choh googahkat, ");
INSERT INTO gwiNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Dinjii, Jesus oozhii, eech'oohǫhchyaa kwaa gwintł'oo nakhwaraiinyą'. Deenakhwaraiinyą' gaakhwandaii, googaa nihk'it t'akhwa'in. Jerusalem gwizhit gwich'in nąįį datthak jii geech'ǫąąhtan gwigwiitth'ak. Jesus dǫǫhkhwąįį, diinohnyąą ts'ą' diineegǫǫhkhii diits'ą' gideehohtrat gwik'eegǫhdaii!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter ąįįts'ą' ch'izhii Tr'ihił'e' nąįį haa jyaa googahnyąą, “Vit'eegwijyąhchy'aa, deeni'in diinahnyąą gwizhrįh gwik'it t'igwehee'yaa goo'aii! ts'ą' dinjii nąįį, ch'ijuk t'akhwa'in diinahnyąą, duuyeh gwik'it t'igwii'in t'oonchy'aa! ");
INSERT INTO gwiNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jesus cross kat gadhohtsak ts'ą' dǫǫhkhwąįį. Ąįįtł'ęę diitsii nąįį, Goovit'eegwijyąhchy'aa, digii Jesus neegwiindaii niłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ąįįtł'ęę ndak deeyihiłchįį ts'ą' dishriits'ąįį niyąąhchįį. Vit'eegwijyąhchy'aa, Diik'eegwaadhat yiłtsąįį, diitr'agwaanduu gwats'an neediihahshii heelyaa geenjit. Israel gwich'in nąįį, tr'agwaanduu t'igii'in gwats'an łihts'eedigiheedaa ts'ą' gootr'agwaanduu oo'an gweheelyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Vit'eegwijyąhchy'aa dinjii yik'eegwahthat nąįį Ch'anky'aa Shroodiinyąą ts'an iłtsąįį, diikhwan Ch'anky'aa Shroodiinyąą k'iighai' łi'deegwidlii haa deegwiizhik gwarąąh'yą' geegwaraandak.” t'igwinyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jii k'eedeegwaadhat nąįį deegwinyąą gwigwiintth'ak dąį', gwint'aii gook'įį goodlit ts'ą' Tr'ihił'e' nąįį ęhdaa tr'agaroo'aa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gąą goots'an dinjii ch'ihłak Pharisee nąįį ts'an nilįį, Gamaliel oozhii. Jews nąįį eenjit Law eech'ǫąąhtan nilįį. Dinjii datthak giihił'ee. K'eedeegwaadhat nąįį tee nidhikhin ts'ą' goots'ą' khaginkhee, “Ch'ihłee chineegavǫhłii!” goovahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ąįįts'ą' chineegoogiinlii tł'ęę k'eedeegwaadhat nąįį ts'ą' ginkhii, “Shalak Israel nąįį, jii dinjii nąįį goots'ą' deekhwa'yaa izhik gwak'ǫǫhtii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ninghit kwaa gwanaa dąį' dinjii, Theudas oozhii, gwiindaii dąį', ‘łyaa dinjii nitsii ihłii.’ adaanyąą. Ąįįts'ą' dinjii 400 nąįį giiyaa niinjil. Ąįįtł'ęę tr'eełkhwąįį. Vitsyaa nąįį datthak shrihteegaajil. Jidii t'ee'ya' datthak ndaagwąąn'ąį', ąįį zhit ganoondaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ąįįtł'ęę Rome nahkat dinjii tr'eechyaa gwanaa dąį', Galilee nahkat gwats'an dinjii k'ii'an tr'agwah'in Judas oozhii, ąįį chan dinjii lęįį yaa haajil. Jii dinjii chan tr'iiłkhwąįį. Ąįįts'ą' vitsyaa nąįį datthak chan shrihteegaajil. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jii geh'an jii dinjii nąįį gwik'it t'igihee'yaa kwaa gavohtsii ji' gwiizųų. Dagakhai' dagat'aii haa t'igii'in ji', geedan t'ee shrihteegiheedaa t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Gąą Vit'eegwijyąhchy'aa vat'aii k'iighai' t'igii'in łee ji', duuyeh gwik'it t'igii'in kwaa goorahtsii t'igiinchy'aa. Vit'eegwijyąhchy'aa ts'ą' nich'itsarahthat t'igwii'in łee gwik'eegahaandal t'oonchy'aa.” jyaa gavahnyąą. Ąįįtł'ęę deenyąą giihaa gwik'it t'iindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ąįįtł'ęę Tr'ihił'e' nąįį nihdineegiinlii. Viitrii haa goorahahtrii goots'an gwigwiłtsąįį. “Chan Jesus voozhri' eeneegohkhyaa shrǫ'!” łyaa gwint'aii googahnyąą, ts'ą' gooneegiinjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nijin k'eedeegwaadhat nąįį łeeljil gwats'an tr'ineegiijil dąį', Jesus voozhri' zhit khaiinjich'agooriłthat geenjit shoo giinlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ąįįtł'ęę drin gwiteegogwąąnchy'aa ąįį Kharigidiinjii Zheh ąįįts'ą' nihłi'adan zheh gwizhit Jesus adan t'ee dinjii neehahshii t'inchy'aa ginyąą ts'ą' eech'agǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ąįįtł'ęę juu Jesus k'injigiighit nąįį łyaa giinlęįį gilii. Gąą gootee gwats'an Jews Greek-ky'aa ginkhii nilįį nąįį łyaa ch'ats'ą' t'iginyąą, “Jews-ky'aa ginkhii nąįį łyaa gwinzii t'igii'in kwaa ts'ą' drin gwiteegwagwaanchy'aa tr'injaa vakai' niinjik nąįį larąą ts'an gahtsii dąį', jii tr'injaa vakai' niinjik nąįį, gwintsal ts'an gwagwahtsii gogoonjii.” Jews Greek-ky'aa ginkhii nąįį jyaa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jii geh'an Tr'ihił'e' 12 nąįį, juu Jesus ik'injigiighit nąįį datthak haa nihłaa łigiiljil, “Dząą diitee larąą khit ik'eeneerahahdak ji'. Jyaa gwizhrįh t'igwii'in ji', Vit'eegwijyąhchy'aa viginjik eegwarahaandak geenjit gwik'it gweheelyaa, ąįį łyaa gwiizųų. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Shalak gwik'injiighit nąįį, nakhwatee gwats'an dinjii 7 goonzhįį juu khit Ch'anky'aa Shroodiinyąą doo'ya' yuunyąą gwik'it t'ii'in, ąįį nąįį ǫhjii. Shih ts'ą' laraa haa ik'eegahaandak geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Gwiizhik diikhwan ąįį khit khagareheejyaa ts'ą' Vit'eegwijyąhchy'aa viginjik eech'aroohąąhchyaa.” googahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Dinjii datthak Tr'ihiłe' deeginyąą gwigwiitth'ak dąį' łyaa geenjit shoo ginlįį. Ąįįtł'ęę Stephen eegwigweełkįį. Vit'eegwijyąhchy'aa khit k'injiighit. Ąįįts'ą' Ch'anky'aa Shroodiinyąą deeyahnyąą khit gwik'it t'ii'in. Ąįį vaa' dinjii 6 nąįį chan eegwigweełkįį. Philip, Prochorus, Nicanor, Timon, Parmenas, Nicolaus oozhii ąįį, (Nicolaus Antioch kwaiik'it gwachoh gwats'an nilįį. Jews gwich'in nilįį kwaa. Gąą Jews nąįį ky'aa gwik'injiighit dhidlit, ąįįtł'ęę Jesus k'injiighit needhidlit.) ");
INSERT INTO gwiNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Tr'ihił'e' nąįį ts'ą' googahaadlii. Izhik dąį' daganli' haa gook'aa nagaanjik. Ąįįts'ą' gooveenjit khadigigeedi'. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ąįįts'ą' chan dinjii gwandaa t'ąąnchy'aa nąįį Vit'eegwijyąhchy'aa viginjik k'injiighit gwilii. Jerusalem gwizhit juu gwik'injiighit nąįį gwandaa lęįį gilii. Giinkhih lęįį nąįį gąą chan Jesus k'injigiighit gilii. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stephen łyaa Vit'eegwijyąhchy'aa vat'aii zhit gwinlęįį t'ee'ya'. Dinjii tee nindal gwaahchy'aa ts'ą' gwigwee'in gwintsii gwitr'it t'agwah'ya'. Vit'eegwijyąhchy'aa yits'inyąą geh'an Vit'eegwijyąhchy'aa vat'aii ts'ą' vich'eegoonzhrii di'įį. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Gaa zhat dąį' slaves nilįį kwaa nąįį eenjit Jews tr'igiinkhii zheh goo'aii, goolat nąįį kwaiik'it Cyrene ts'ą' Alexandria gwats'an giinlii, geedan ts'ą' Cilicia nahkat ts'ą' Asia nahkat haa gwats'an Jews nąįį Stephen haa tr'inehłeegoiidlii ts'ą' ch'ats'ą' t'igiiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Stephen Ch'anky'aa Shroodiinyąą k'iighai', gwizhįh nitsii di'įį. Ąįį geh'an khų' gaiiyiideegiiyahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jii geh'an dinjii yeenjit ooheets'it agogoįįnkwat, “Vit'eegwijyąhchy'aa, ts'ą' Moses haa gwiizųų eeginkhii, tr'iitth'ak!” goots'it haa jyaa giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jyaa dinjii lęįį nąįį, ch'anjaa kįh dilk'ii, ts'ą' Jews goo-law eech'ǫąąhtan nilįį nąįį agahnyąą, jii gwigwiitth'ak dąį' gwint'aii gook'įį goodlit haa Stephen gąhtsit ts'ą' k'eedeegwaadhat nąįį łigiiljil ęhdaa nigiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ąįįtł'ęę dinjii lat nąįį yeenjit ooheets'it nąįį nihdeegiinlii. “Jii dinjii khit ts'ą' Moses va-law zhit deekhwa'in diinahnyąą ąįįts'ą' Diikharigidiinjii Zheh shroodiinyąą goo'aii geenjit gwiizųų ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","‘Jii Jesus Nazareth nahkat gwats'an ahaa Diikharigidiinjii Zheh neegwadahąąłthal ts'ą' an gwahałtsyaa nyąą, ts'ą' Moses deediinahnyąą gwinehts'į' neegweheelyaa chan,’ nyąą tr'iitth'ak!” ");
INSERT INTO gwiNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Zhat k'eedeegwaadhat nąįį datthak Stephen vinin aakin gąą'įį, akhai' zheekat gwich'in vinin k'it t'inchy'aa łee, datthak giiyąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","“Et'ee łyaa łi'didlii haa neegwagwaandak lee t'iginyąą?” jyaa ndak khii giinkhih choh Stephen ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen datthak jyaa goovahnyąą, “Gwiti' nąįį ts'ą' shalak nąįį haa, shoodǫǫhk'įį! Yeenaa dąį' diiti', Abraham tth'aii hee Mesopotamia nahkat gwich'įį gwiizhit, Vit'eegwijyąhchy'aa dich'eegwąhndit yits'ą' igweelkįį. Haran kwaiik'it tth'aii gweheechy'aa geenjit gwats'ą' hahkhaii kwaa dąį'. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ąįįts'ą' Vit'eegwijyąhchy'aa yits'ą' ginkhii, ‘Nanahkat ts'ą' nalak nąįį datthak haa ihłeehinkhaii. Ąįįtł'ęę nijin gwats'ą' hinkhaa gwik'eenahaałtyaa,’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ąįįts'ą' danahkat Chaldea gihłeehaazhii ts'ą' Haran kwaiik'it gweheechy'aa geenjit gwats'ą' haazhii. Abraham viti' niindhat ąįįtł'ęę dzaa juk gweheechy'aa geenjit Vit'eegwijyąhchy'aa gwats'ą' haazhii yiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Izhik zhat dąį', nan hee'yaa eenjit tth'aii hee yintł'eeya'ąįį kwaa. Nantsal yakat niheedhat googaa di'įį kwaa. Gąą ‘nan nintł'eehih'aa, nanan heelyaa eenjit,’ yahnyąą. Niindhat tł'ęę, vigii nąįį nihzhyaaneedijii nan yahąą'yaa eenjit. Izhik zhat dąį', ‘nan nintł'eehih'aa.’ yaiinyą' dąį', tr'iinin tth'aii di'įį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Vit'eegwijyąhchy'aa jii jyaa yaiinyą', ‘Nihzhyaaneedijii nąįį aakin nahkat gwa'an gwigweheechy'aa ts'ą' 400 (years) gąhkhyuk datthak slaves giheelyaa gwiizhit gwiizųų khaiinjich'agoogahahthat. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gaa ąįį dinjii nąįį nigii nihzhyaaneedijii nąįį slaves nilįį giłtsąįį ąįį nąįį googwahąąłshii. Ąįįtł'ęę ąįį nahkat gwats'an cheegiheedaa. Dząą gwits'eegiheedaa. Ąįįts'ą' shats'ą' khadigigeheejyaa.’ jyaa Vit'eegwijyąhchy'aa Abraham ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Jyąhts'ą' t'ee Vit'eegwijyąhchy'aa ts'ą' Abraham haa nihłaa gwinzii deegwigwiiłtsąįį. Nigii tsyaa tsal nąįį datthak gootthąį' kat khangwahaht'ii ts'ą' googwahahkyaa. Nats'ahts'ą' nan, shįį haa gwinzii nihłaa deegwariiłtsąįį gineehoondaii geenjit Vit'eegwijyąhchy'aa yahnyąą. Drin 8 gwahaadhat ąįįtł'ęę Abraham didinji' Isaac kat khagwąht'uu. Ąįį gwik'it Isaac chan didinji' Jacob jyaa dinlik. Ąįį gwik'it Jacob chan didinji' 12 nąįį kat khagwałt'uu. Jii nihchaa 12 nąįį deenaadąį' diitsii gwinzii vaagwiindaii nąįį t'arahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ąįį nąįį goochaa, Joseph oozhii, k'eegwiichy'aa datthak eenjit giitr'ii'ee. Yee'an dinjii ts'ą' gwintł'eegiiyahchįį. Ąįį nąįį giiyoiinkwat, ts'ą' Egypt nahkat gwats'ą' giihiłchįį. Izhik t'inchy'aa datthak Vit'eegwijyąhchy'aa yaa nilįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Nijin khaiinjich'iidhat dąį', K'eegwaadhat yits'iinyą'. Egypt nahkat gwizhit k'eedeegwaadhat choh kįh dhidii, Pharaoh oozhii, ąįį ęhdaa nadhat dąį', Vit'eegwijyąhchy'aa k'iighai' dinjii nizįį nilįį ts'ą' gwizhįh chan di'įį ts'ą' łyaa yeenjit shoo nilįį. Ąįįtł'ęę Pharaoh danahkat gwizhit ts'ą' dizheh gwizhit dinjii gwich'įį nąįį eenjit k'eedeegwaadhat yiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ąįįtł'ęę Egypt ąįįts'ą' Canaan nahkat gwizhit shih kwaa goodlit. Ąįį geh'an dinjii lęįį nąįį khaiinjich'igiidhat. Izhik zhat dąį' diitsii nąįį khyų' shih gooheendal agwagwąh'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Gooti' Jacob, “Egypt nahkat shih lęįį k'eerahtii,” gwinyąą gwiitth'ak dąį', izhik zhat shih gooheekwat geenjit didinji' nąįį gwats'ą' goohił'e'. Jii t'ee tr'ookit zhat gwats'ą' gahaajil dąį'. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jii tł'ęę chan zhat nineegiijyaa dąį', ‘Shįį t'ee, nakhwachaa ihłii chy'aa t'ihchy'aa.’ Joseph gavahnyąą. Ąįįtł'ęę Pharaoh, Joseph valak nąįį gwanlii eenjit gwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ąįįts'ą' Joseph diti' Jacob ts'ą' nideech'iin'ąįį. ‘Nalak nąįį datthak haa dząą Egypt gwats'ą' hinkhaii.’ yahnyąą. Datthak khaihłok dinjii 75 nąįį ginlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Nijin Jacob gwiitth'ak dąį', Egypt gwats'ą' haazhii. Izhik zhat ninghyuk gwahaadhat ąįįtł'ęę, adan ąįįts'ą' vidinji' nąįį ts'ą' diitsii ginlii nąįį haa, datthak nigiinjik. Izhik dąį' Joseph adan t'ee niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nigiinjik tł'ęę, dząą Shechem kwaiik'it gwits'eegoogahaadlii. Izhik kii ch'a'an Abraham, Hamor vidinji' ts'an goiinkwat chy'ąą. Izhik gwizhit goonagąąhjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Gwehkįį ninghit dąį' gwanaa Vit'eegwijyąhchy'aa Abraham ts'ą' ginkhe', Egypt gwats'an cheenakhwahihłyaa nyąą chy'ah, ąįįt'ee juk nagwiindhat. Zhat Egypt gwizhit diitsii nąįį t'inchy'aa nihzhyaaneedijii gwandaa lęįį gilii. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ąįįtł'ęę Egypt gwizhit k'eedeegwaadhat choh k'eejit Pharaoh deek'it nineezhii, Joseph haandaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Diitsii nąįį ininjigwaazhii ąįįts'ą' gwiizųų goots'ą' t'ii'in. Nijin googii tr'iinin tsal gwilik dąį', digizheh gwats'an cheegoogahahchik oo'ok zhyąą nigiheedhaa geenjit, googahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ąįį jyaa gwii'in gwizhit, Moses adan t'ee vagoodlit. Łyaa tr'iinin tsal gwinzii viyiichy'a' nilįį ts'ą' Vit'eegwijyąhchy'aa yeenjit shoo nilįį. Shree nan tik gwizhit gwizhrįh viyehghan nąįį nehshrit giik'aahtį'. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ąįįtł'ęę adan t'ee oo'ok zhyąą niheedhaa eenjit cheegiiyąhchįį. Izhik dąį' Pharaoh vichi' yagwąh'ąįį. Yuunjik ts'ą' dizheh gwits'ee yihiłchįį. Akhai' digii tsyaa dinky'ahkhit k'it dink'iyahthat. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egypt gwizhit dinjii goonzhįį nąįį googwizhi' datthak eeroołtin. Gwizhįh haa ginkhii ts'ą' k'eegwiichy'aa gwinlęįį gwinzii gwitr'it t'agwah'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nijin 40 years dhidlit dąį', valak Jews nilįį nąįį nats'ąą gook'aantii li' geenjit gooveenihihshyaa, yiindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Izhik zhat valak ch'ihłak Egypt dinjii khaiinjich'iiyahthat, nah'in. Nijin yąąh'in dąį', yits'inyąą ts'ą' ąįį Egypt dinjii diłkhwąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Shalak nąįį gaageheendaii Vit'eegwijyąhchy'aa goots'ą' shihił'e' goots'ihįhjyaa ts'ą' Egypt gwats'an tr'ineegoohihłyaa eenjit, yiindhan. Gąą geedan jyąhts'ą' ninjich'agadhat kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Gęhdaa drin chan valak neekwąįį nihłaaghwąįį, gwąąh'in. ‘Nihłagahaaghwaa kwaa gavoołtsyaa, nihlak nąįį ǫhłįį, jaghaii nihłooghwaii?’ gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Dinjii ch'ihłee gaiich'ahtsii, ąįį Moses an yąąhtrat. ‘Juu diineenjit k'eedeegwaadhat ts'ą' ch'oohahkat choh hinlyaa geenjit niłtsąįį?’ yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘K'ehdąį' Egypt dinjii dǫǫhkhwąįį gwik'it shįį chan shookhwaa niindhan lee t'iinyąą?’ Moses ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nijin Moses jyaa dinyąą yiitth'ak dąį', jii geenjit Egypt gihłeehilghaa. Midian nahkat gwats'ą' haazhii, ts'ą' zhat gwich'įį. Izhik zhat gwats'an tr'injaa oonjik ts'ą' vidinji' neekwąįį nąįį goodlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Zhat dąį' 40 years gitł'eegoodhat, tł'ęę gwats'an tr'ineezhii. Ąįįtł'ęę Ddhah Sinai geeghaih gwa'an nangwinjir gwa'an tr'ał daak'a', nah'in. Izhit zheekat gwich'in vats'ą' agweelkįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Łyaa geegoolii kwaa veenjit t'igwiizhik, jyąhts'ą' gwahąąh'yaa łyaa, yiindhan kwaa. Gwats'ą' ninghyuk kwaa niinzhii, gwinzii gwahąąh'yaa eenjit. Izhik zhat gwats'an K'eegwaadhat yits'ą' ginkhii gwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Shįį t'ee deenaa dąį' niti' nąįį Goovit'eegwijyąhchy'aa ihłįį. Abraham, Isaac, Jacob nąįį haa Goovit'eegwijyąhchy'aa ihłįį,” K'eegwaadhat yahnyąą. Moses naajat ts'ą' daatrat naanaii, ąįį tr'ał daak'a' nooł'ya', niindhan kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","‘Nakwaiitryaa zhit tr'iin'yaa, shahǫǫh'ęę gwik'eech'ahąhtyaa eenjit. Ąįį nan juk vakat nindhat, shroodiinyąą nilįį t'inchy'aa. Shįį dząą gwakat t'ihchy'aa, Vit'eegwijyąhchy'aa ihłįį geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nats'ahts'ą' shigii nąįį datthak Egypt gwizhit khaiinjich'igiijii, ąįį gwąął'in. Khagiitree chan giviihtth'ak ts'ą' khaiinjich'igiighit gwats'an tr'ineegoohihłyaa geenjit dzaa gwats'ą' hoiizhii. Juk aanaii, Egypt gwats'ą' nahał'aa eenjit.’ K'eegwaadhat yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses t'ee Israel dinjii nąįį gwehkįį dąį', an-giiyąąhtrat. ‘Juu k'eegwaadhat hinlyaa eenjit diineenjit niłtsąįį,’ giiyaiinyą' chy'ąh. Ąįįtł'ęę tr'ał daak'a' zhit zheekat gwich'in nah'ya', gwats'an k'eedeegwaadhat heelyaa geenjit Vit'eegwijyąhchy'aa goots'ą' neeyihił'e'. Gwehkįį dąį' giiyeet'iindhan kwaa googaa chan goots'eeyihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Egypt gwizhit Chųų Choh Daatsik oozhii deetaa neegiinjil ąįįts'ą' nijin nangwinjir gwa'an neegihiidal dąį', jii kwaii gwizhit łyaa gwigwee'in gwintsii gwitr'it t'agwah'ya'. 40 (years) neegwiidhat gąhkhyuk gwilii giinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","‘Dinjii ch'ihłak nakhwatee gwats'an shik'it t'inchy'aa Vit'eegwijyąhchy'aa Eenjit Ginkhii heelyaa yeendaa ji', nakhwats'ą' nahahchyaa.’ Moses, Israel gwich'in nąįį jyaa ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nijin nangwinjir gwa'an datthak nihłaałigiiljil dąį', izhik zhat Moses zhrįh gavaa t'inchy'aa. Nijin zheekat gwich'in Sinai-Ddhah kat ginkhii dąį', Moses zhrįh ts'ą' ginkhe'. Izhik dąį' Moses diitsii nąįį haa t'inchy'aa. Izhik Vit'eegwijyąhchy'aa viginjik nats'ahts'ą' gwigweheendaii geenjit jyaa danakhwahnyąą. Ąįį Moses nakhweenjit vintł'eerinlii chy'ah. Ąįį juk tr'ii'įį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Gąą diitsii nąįį dahnyąą gwik'it t'igii'in kwaa. Moses goots'ą' k'eedeegwaadhat giiyeet'iindhan kwaa. Egypt gwits'ee tr'ahoojyaa, ąįį gwizhrįh datthak giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nijin Moses Sinai-Ddhah kiit'ik dhidii gwiizhik Aaron ts'ą' giginkhii, ‘Adan ataiinjii ąhtsii nilįį eenjit. Moses, Egypt gwats'an dząą gwats'ą' nakhwats'įį niinzhii, ąįį juk deezhik vaagwiindaii kwaa ginyąą. Ch'ik'itiltsį' kwaii diivit'eegwijyąhchy'aa heelyaa ts'ą' tąįį gwinjik diits'ii giheehaa geenjit ąhtsii!’ jyaa Aaron agahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Izhik zhat dąį' larąą daatsik (gold) haa aak'ii viji' gwanlii giik'itiltsį' vit'eegwijyąhchy'aa gahaa'yaa gooveenjit iłtsąįį. Aak'ii ts'ą' divii k'it t'inchy'aa ąįį kwaii giiłkhwąįį. Ąįį giiyandah niinlii, ataiinjii heelyaa eenjit. Ąįįtł'ęę jii ch'ik'itiltsį' geedąhkhai' giiyiłtsąįį eenjit łyaa shoo ginlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jii geh'an Vit'eegwijyąhchy'aa goots'į' an-nil'ee ts'ą' zheekat są' dhidlii kwaii ts'ą' khadigiheejyaa geenjit gwintł'ee goovinlii. Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį nąįį gwehkįį ninghit dąį' hee geenjit ch'adagąąntł'oo: ‘Israel gwich'in nąįį, nijin 40 years gahkhyuk datthak nangwinjir gwa'an neehakhwadal dąį' nin dohkhwąįį ąįį ataiinjii ohtsii ąįį shįį sheenjit t'akhwa'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nakhwazheh gwadhah zhit nakhwavit'eegwijyąhchy'aa voozhri' Moloch oozhii vik'iteeyiltsį' neehoozhik, ts'ą' ch'ik'itiltsį' Rephan (są' k'it t'inchy'aa) dhohtsąįį ts'ą' khagadǫhjii, ąįįts'ą' t'ee Babylon kwaiik'it gwachoh gehji' gwa'an gwats'ą' nanahkhwahihłyaa.’ ");
INSERT INTO gwiNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Diitsii nąįį nangwinjir neegihiidal dąį' zhee gwadhah adahaa neegahaazhik, ąįį zhit Moses va-law khagilzhii. Vit'eegwijyąhchy'aa deegihee'yaa ts'ą' deegihee'yaa kwaa gavahnyąą ąįį zhee gwadhah zhit chan ts'ą' khadigigiinjii. Jii zhee gwadhah Moses, Vit'eegwijyąhchy'aa nats'ahts'ą' yats'ą' gwigweelkįį gwik'it hohtsyaa gavahnyąą, k'it giiyiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Niighyuk gwahaadhat ąįįtł'ęę nijin Jews nilįį kwaa nahkat gwats'ą' nich'itsigahthat ąįį gwits'ii Joshua ahaa dąį', Vit'eegwijyąhchy'aa jii nan ts'ą' gihłeegoohaanzhit, zheh gwadhah zhit khagigidiinjii eenjit t'eegaahchy'aa ąįį dahaa ch'adanh nahkat gwats'ą' giihiłtsuu. Ts'ą' dahthee King David niheehaa gwats'ą' datthak giit'aahchy'a'. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Vit'eegwijyąhchy'aa łyaa David eet'iinghya', ‘Shik'eegwaadhat, deenaa dąį' Jacob Vivit'eegwijyąhchy'aa ąįį inlii. Łyaa zheh gwintsii neenjit gwołtsyaa yiihthan, Kharigidiinjii Zheh gweheelyaa eenjit.’ David Vit'eegwijyąhchy'aa ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Vit'eegwijyąhchy'aa gwahahtsyaa gwats'ą' geenjit t'iiyahthan kwaa. Gąą vidinji' Solomon oozhii, ąįį zheh gwintsii Vit'eegwijyąhchy'aa eenjit gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Gaa Vit'eegwijyąhchy'aa jiintsii ąįį zheh dinjii gwiłtsąįį gwizhit gwich'įį kwaa; Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį ąįį ch'ihłak gwadąąntł'oo, ");
INSERT INTO gwiNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Zheekat, izhik gwats'an t'ee k'eegwaaldhat. Jii nan datthak eenjit K'eegwaadhat ihłįį. Ts'ą' nankat t'ee vakat shakwai' doołdlii. Jidii k'it t'inchy'aa zheh sheenjit gwahohtsyaa? Neehalzhii gwideek'it deegwaajii? ");
INSERT INTO gwiNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Shįį k'eegwiichy'aa datthak goołtsąįį t'oonchy'aa.’ Vit'eegwijyąhchy'aa nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Datthak ts'ą' łyaa nakhwaki' tth'an dach'at. Vit'eegwijyąhchy'aa deenakhwa'in, nakhwahnyąą gwik'it t'akhwa'in geet'ohthan kwaa. Ąįįts'ą' chan łyaa gwik'injohjii kwaa. Yeenii Nakhwati' nąįį łąą k'it t'ohchy'aa. Ch'anky'aa Shroodiinyąą deekhwa'in, nakhwahnyąą khit gwik'it t'akhwa'in geet'ohthan kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Yeenii nakhwatsįį nąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį nąįį khaiinjich'igiłthat, ts'ą' Christ neeheedyaa ginyąą geenjit googiiłkhwąįį. Christ t'ee khit Vit'eegwijyąhchy'aa k'eegwahthat, ts'ą' niighit kwaa dąį' juu yitr'ii'ee nąįį antł'ohchįį ts'ą' giiyiiłkhwąįį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Vit'eegwijyąhchy'aa zheekat gwich'in k'iighai' Moses va-law yeenii nakhwats'įį nąįį ts'an iłtsąįį. Ąįį juk t'ee datthak vakhwa'įį. Gąą vik'injuhkhit kwaa ts'ą' datthak vik'eegohthat kwaa.” jii datthak Stephen k'eedeegwaadhat kįh dilk'ii nąįį ąįįnyą' ts'ą' ndaanich'igįįnkhee. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nijin k'eedeegwaadhat nąįį deenyąą giiyiitth'ak dąį', gwintł'oo geenjit gook'įį gwanlii. It'ee shrit gook'įį gwanlii ts'ąįį googho' gąą igweech'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Gąą Stephen, Ch'anky'aa Shroodiinyąą gwintł'oo vizhit deehee'yaa haa, zheekat k'iidak gwizhrįh gwąąh'in. Izhik Vit'eegwijyąhchy'aa ch'eegwąhndit nah'in ts'ą' Jesus, Vit'eegwijyąhchy'aa vishriits'ąįį nadhat ts'ą' yaa K'eegwaadhat nilįį ąįį gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“K'iidak gooh'in! Zheekat nihky'aa t'igwiizhik, ts'ą' Gwidinji' ąįį Vit'eegwijyąhchy'aa vishriits'ąįį nadhat, yaa K'eegwaadhat nilįį gwąął'in.” Stephen gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Shraa haa daganli' digidzii gihdangahtrat. Datthak khaihłok gwintł'oo gazhral ts'ą' gaagal haa giik'aahaajil. Giiyiitth'ak geet'igiindhan kwaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ąįįtł'ęę gwagwahkhan giiyuunjik ts'ą' kwaiik'it gwachoh gwats'an geh'at gwa'an nigiiyąąhchįį. Ąįįtł'ęę ndakhąįį digi'ik nineegilzhii. Ąįį tsyaa, Saul oozhii, yik'eehąąhtyąą eenjit antł'eegiiyinlii, ąįį gwiizhik Stephen gwint'aii kii haa gookit, jyąhts'ą' giihaahkhwaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kii haa giiyuukit gwiizhik K'eegwaadhat ts'ą' khagidiinjii, “K'eegwaadhat Jesus shanky'aa oiinjii!” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ąįįtł'ęę nikiigwiintthaii ts'ą', “K'eegwaadhat, jii tr'agwaanduu t'igii'in geenjit googǫǫhshii shrǫ'!” gwintł'oo azhral ts'ą' jyaa nyąą, tł'ęę niindhat. Saul łyaa Stephen tr'iiłkhwąįį geenjit shoo nilįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saul łyaa Stephen tr'iiłkhwąįį geenjit shoo nilįį. Izhik zhat drin dąį' Jerusalem gwizhit Jesus k'injigiighit nąįį khaiinjich'agoogahkhit ts'ą' zhat Judea nihkhy'aa nahkat ts'ą' Samaria gwats'ą' gihłeegihihjyaa. Tr'ihił'e' nąįį zhrįh gihłeegahaajil kwaa ts'ą' nihłaa t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Dinjii lat nąįį łyaa Vit'eegwijyąhchy'aa k'injigiighit gwintł'oo gazhral ts'ą' gitree, gwizhit Stephen anagąąhjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Gaa Saul nihk'it tth'aii hee Jesus ts'ą' tr'igiinkhii zheh nineegiidal nąįį kanitįį. Zheh gwitee neehidik ts'ą' goovinkeegwąąh'in. Nijin goolat agwah'ak dąį', gavoondak ts'ą' chiitąįį gwats'ą' cheegoovihiluu. Ąįįtł'ęę zhee gwaazhrąįį nagoovilik. Dinjii ts'ą' tr'injaa haa nihk'it jyaa dąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jesus k'injigiighit nąįį nihłe'edan nankak datthak gwats'ą' gahaajil ts'ą' Gwandak Nizįį eegwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Philip chan Samaria nahkat gwizhit kwaiik'it gwachoh ch'andaa t'agwahtsii gwats'ą' haazhii. Izhik dinjii nąįį Jesus t'ee Christ t'inchy'aa nyąą ts'ą' geech'ǫąąhtan. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Izhik zhat dinjii lęįį nąįį Philip jyaa dagavahnyąą gwinzii googoołk'įį. Juu yuułk'įį nąįį tthak łyaa gwigwee'in t'ii'in giiyąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Dinjii lęįį nąįį, goozhit ch'anky'aa iizųų t'inchy'aa nąįį, gwintł'oo gazhral gwiizhik goots'an cheehahchik. Ąįį gąą ts'ik ahchįį haa neehidik kwaa nąįį lęįį shranaazhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Zhat kwaiik'it gwachoh gwizhit dinjii lęįį nąįį geenjit łyaa shoo ginlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Izhik kwaiik'it dinjii, Simon oozhii, gwich'įį. Juu gwehkįį dąį' gwats'an dinjii dazhan nilįį. Dinjii Samaria nahkat gwizhit gwich'įį nąįį datthak nagwahde' haa neegoovan'ee. “Łyaa dinjii gwintsii veegoo'aii ihłįį!” adaanyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ąįį kwaiik'it gwachoh gwizhit dinjii gwintsii deegihił'ee nilįį ts'ą' dinjii deegihił'ee nilįį kwaa nąįį gwinzii giiyołk'ii. “Jii dinjii t'ee Vit'eegwijyąhchy'aa ts'an t'aih nitsii di'įį!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Łyaa ninghyuk nagwahde' haa neegoovan'ee. Ąįį geh'an łyaa deenyąą giik'injijii. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Gąą nijin Philip Gwandak Nizįį Jesus voozhri' zhit Vit'eegwijyąhchy'aa Veegwinii'ee eeginkhii giiyiitth'ak dąį' gwik'injigiighit ts'ą' dinjii ts'ą' tr'injaa haa lęįį nąįį chųų goots'an dhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ąįį dinjii dazhan Simon oozhii googaa gwik'injindhat ts'ą' chųų vats'an tr'iłtsąįį. Ąįįtł'ęę gweedhaa datthak Philip haa t'inchy'aa. Philip geegagoolii kwaa ts'ą' gwigwee'in gwintsii gwitr'it t'agwah'in, Simon gwąąh'in dąį' hilghaa. Ąįį łąą gwik'it t'igweheenjyaa yiindhan kwaa gwik'it t'igwiizhik geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria gwizhit dinjii lęįį nąįį Vit'eegwijyąhchy'aa viginjik k'injiginjik. Nijin Jerusalem gwizhit Tr'ihił'e' nąįį gwigwiitth'ak dąį', Peter, ts'ą' John haa goots'ą' gihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nijin zhat k'eegii'oo dąį', lęįį nąįį juu Jesus k'injigiighit nąįį datthak eenjit khagigideedi', Ch'anky'aa Shroodiinyąą goohideendal ji' geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Gwehkįį dąį' gwats'an, ch'ihłak gąą Ch'anky'aa Shroodiinyąą gook'aa t'iinjii kwaa. K'eegwaadhat Jesus voozhri' zhit gwizhrįh chųų goots'an tr'iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ąįįtł'ęę Peter, John haa gooki' k'ąą nagaanjik. Ąįįtł'ęę Ch'anky'aa Shroodiinyąą geenjit gook'aa t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dząą t'ee Ch'anky'aa Shroodiinyąą goots'an tr'iłtsąįį Tr'ihił'e' nąįį gooki' k'ąą nagaanjik dąį', Simon adan t'ee gwąąh'in. Jii geenjit Peter, John haa larąą haa googoihkwat yiindhan, adan t'ee gook'it t'ihee'yaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Shįį chan, jii t'aih shats'an ohtsii, juu viki' k'ąą naaljik nąįį Ch'anky'aa Shroodiinyąą ooheendal eenjit.” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Gąą Peter łyaa gwint'aii yits'ą' ginkhii, “Jidii Vit'eegwijyąhchy'aa gwit'ii gwakwaa dinjii antł'eeyinlii, ąįį oohihkwat, niindhan geenjit nan ts'ą' nalaraa haa nijin hohk'an (hell) ąįį gwats'ą' hohjyaa! ");
INSERT INTO gwiNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nidrii zhit Vit'eegwijyąhchy'aa doo'ya' noonyąą, ąįį gwik'it t'ini'in geet'iindhan kwaa geh'an, diigwitr'it zhit k'eegwiichy'aa duuyeh diinaa gwini'įį t'oonchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Natr'agwaanduu gwats'an łihts'eedaa'ee. Vit'eegwijyąhchy'aa natr'agwaanduu oo'an gweheelyaa geenjit, vats'ą' khadigiinjii nats'ahts'ą' ninjich'indhat, ąįį gwik'it t'ini'yaa kwaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nidrii zhit gwats'an ch'izhii dinjii jidii di'įį łyaa viyiindhan ts'ą' natr'agwaanduu chan noontą' k'it t'oonchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","“Nakhwan ąįį K'eegwaadhat sheenjit vats'ą' khagadǫhjii, nats'ąą shats'ą' deegweheenjyaa shohnyąą, gwik'it t'igweheenjyaa kwaa eenjit.” Simon, Peter, ts'ą' John haa ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nijin Peter, ts'ą' John haa K'eegwaadhat ginjik eenjit dinjii haa gwagwaandak, tł'ęę k'iinjik Jerusalem gwits'ee gahoo'oo. K'iinjik neegee'al gwiizhit Samaria nahkat gwa'an an-nihłik kwaiik'it goodlii gehgoo gogoh'oo dąį', izhik Gwandak Nizįį eenjit dinjii nąįį haa gwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ąįįtł'ęę K'eegwaadhat zheekat gwich'in ch'ihłak Philip ts'ą' ginkhii, “Shreedaanjii tł'ęę, Jerusalem gwats'an Gaza kwaiik'it gwats'ą' tąįį gwin'ee gwats'ą' hinkhaii.” yahnyąą. (Ąįį tąįį nangwinjir gwatł'an k'ii'an gwi'ęę.) ");
INSERT INTO gwiNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ąįįtł'ęę Philip shriidąązhik ts'ą' ąįį tąįį gwinjik haazhii. Ethiopia gwats'an dinjii eunuch nilįį ąįį Ethiopia nahkat gwats'ą' tr'injaa k'eedeegwaadhat choh va'at nilįį Queen Candace oozhii eenjit laraa k'ąąhtii nilįį ąįį Eunuch, khał vitł'ee neekwąįį łits'eedaadhal dhidlii zhit łąįį choh (horses) yeelil gwiizhik Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį Isaiah vidęhtły'aa kat ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ch'anky'aa Shroodiinyąą Philip dahnyąą, “Oo'ak khał ts'ą' niinkhaii ts'ą' veeghaii nahgǫǫ inkhaa.” ");
INSERT INTO gwiNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ąįįtł'ęę gwagwahkhan Philip gwats'ą' hilgit ts'ą' gwizhit dinjii dhidii ąįį Vit'eegwijyąhchy'aa Eenjit Ginkhii Isaiah oozhii gwadąąntł'oo kat ginkhii gwiitth'ak. Philip yuahkat, “Jidii kat ginkhii deegwinyąą lee goonandaii?” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","“Ch'ihłee deegwinyąą t'igwinyąą shaa gwaandak kwaa gwiizhik, nats'ahts'ą' deegwinyąą t'igwinyąą gaahashandaii? Dząą, deedhinkhaii ts'ą' sheeghaii dhindii.” Philip ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Dęhtły'aa Choh kat ginkhii ts'ą' jyaa nyąą, “Divii tr'oonjik, tr'ahaahkhwaa geenjit, ąįį k'it gihłeetr'ihiłchįį dąį' hahchįį kwaa. Divii vaghai' kharit'ii dąį' ąįį k'it hahchįį kwaa. Jii dinjii jyaa dinchy'aa, deegwahtsii gwiizųų giits'ą' t'ii'in, googaa k'eegwiichy'aa t'iinyą' kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Dinjii iizųų nilįį k'it giits'ą' t'ee'ya', gąą łyaa dinjii nizįį inli'. Tr'agwaanduu t'ee'ya' kwaa. Juu vineezhyaadijii nąįį eegwahaandak? Ninghyuk kwaa gwizhrįh jii nankak gweheendaii, ąįį geh'an.” jyaa gwiinyą'. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","“Jii vakat giihkhii, nik'ee duulee geeshaagwaandak? Jii juu dinjii dee Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį Vit'eegwijyąhchy'aa deenyąą geeginkhii? Ideeginkhii? Gąą yee'an dinjii eenjit ginkhii lee t'inyąą?” jyaa Philip ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ąįįtł'ęę Philip jidii Vit'eegwijyąhchy'aa viginjik kat ginkhii eenjit geeyaagwihelndak, Ąįįtł'ęę Gwandak Nizįį Jesus eenjit yaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tąįį gwinjik łąįį choh gavahchyaa gwa'an, chųų gąąh'in. “Zhik chųų nah'in, nik'ee duulee chųų shats'an ąhtsii?” Philip ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“Aahą', gwintł'oo gwik'injinghit ji', chųų nats'an hałtsyaa.” Philip yahnyąą. “Łyaa gwik'injihkhit! Jesus Christ Vit'eegwijyąhchy'aa Vidinji' nilįį gwik'injihkhit!” ąįį dinjii Philip ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ąįįtł'ęę ąįį dinjii, łąįį choh khał neehahkhal ąįį ‘Akǫ' t'ee!’ ahnyąą. Ąįįtł'ęę ąįį dinjii ts'ą' Philip haa chųų zhit teegin'oo ts'ą' Philip chųų yats'an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nijin chųų ts'an teeneegee'oo dąį', Ch'anky'aa Shroodiinyąą k'iighai' khants'ą' Philip k'igwaanaii. Izhik gwats'an Philip naan'yą' kwaa, ts'ą' gwintł'oo vizhit shoo dha'aii haa danahkat gwats'ą' needyaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Googwahkhan Philip Azotus kwaiik'it vigwiilkįį. Izhik gwats'an Caesarea kwaiik'it k'eeheedik gwats'ą', zhit kwaiik'it goodlii datthak gwitee haazhii, ts'ą' Vit'eegwijyąhchy'aa Vagwandak Nizįį eegwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Izhik zhat dąį' Saul dinjii lęįį juu K'eegwaadhat Jesus k'injiighit ts'ą' tąįį adaa nąįį ts'ą' gwiizųų t'ii'in nyąą ts'ą' łyaa, datthak gavoihkha' yiindhan. Jii geh'an ndak khii giinkhih choh ts'ą' haazhii, ");
INSERT INTO gwiNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ąįį dęhtły'aa yeenjit hideentł'oo eenjit oahkat ts'ą' t'aih haa yats'an hahtsyaa. Ąįį haa Damascus kwaiik'it gwachoh gwizhit Jews nąįį tr'igiinkhii zheh gwahąąh'yaa geenjit, izhik gwa'an Jesus k'it gwandaii nąįį agwahah'aa ji' eenjit. Ąįį nąįį agwąh'ąįį ji', dinjii, ts'ą' tr'injaa haa giinlii ji', googaa nihk'it goovooheendal. Ąįįtł'ęę Jerusalem gwits'ee gooheelyaa, ts'ą' zhee gwaazhrąįį nagooreheelyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nijin Damascus gwats'ą' ninghit kwaa ahaa dąį', khan hee zheekat gwats'an vak'aa ts'ą' vindiih datthak ch'eegwąhndit nagwaanąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Gwagwahkhan nankak neet'aanąįį. “Saul, Saul, jaghaii dee shagwahąąhshii eenjit shatąįį neehindik?” gwideezhuh yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Juu inlii, K'eegwaadhat?” Saul yahnyąą. “Jesus, vagwahąąhshii eenjit vatąįį neehindik, ąįį ihłįį.” gwideezhuh yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","“Gaa nininjii tł'ęę, Damascus gwizhit nihdeiinkhaii. Zhat dinjii ch'ihłee deehini'yaa datthak geenjit naa gwahaandak.” jyaa gwideezhuh yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Dinjii yaa adaa nąįį datthak chan khų' gaa giginkhii ts'ą' k'eegwiichy'aa t'iginyąą kwaa. Gwideezhuh giitth'ak gaa k'eegwiichy'aa gwagwaah'in kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul nankak gwats'an ninehjin. Ąįįtł'ęę dandee nihky'aa t'igwinlik, gąą k'eegwiichy'aa gwąąh'in kwaa, vindee kwaa nagwaanąįį geh'an. Giiyanli' ootą' ts'ą' Damascus gwizhit nihdeegiiniin'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ąįįtł'ęę drin tik gąhkhyuk datthak gwąąh'in kwaa. Ąįį gąhkhyuk datthak ch'a'aa kwaa ts'ą' chųų chan dinįį kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascus gwizhit dinjii gwik'injiighit ch'ihłak Ananias oozhii, ąįį K'eegwaadhat k'iighai' gineiinlyaa k'it t'inchy'aa zhit, gineiinlyaa gwizhit K'eegwaadhat yits'ą' niinzhii, nah'in ts'ą' yuuzhrii, “Ananias!” yahnyąą. “Dzaa dhiidii, K'eegwaadhat!” Ananias yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","“Cheehinkhaii ts'ą', Tąįį K'igwąą'ee goozhii, gwats'ą' hinkhaii. Izhik zhat Judas vizheh gwizhit Tarsus kwaiik'it gwachoh gwats'an ahaa Saul, juk khagidiinjii, ąįį vach'oahkat, ");
INSERT INTO gwiNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ts'ą' gineiinlyaa k'it t'inchy'aa zhit nan Ananias nihdeiinkhaii ts'ą' viki' kat naanjik, nah'in łee gwąąh'in vaa gweech'in neegweheelyaa geenjit.” K'eegwaadhat Ananias ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","“Gąą K'eegwaadhat, jii dinjii łyaa Jerusalem gwizhit gwik'injiighit nąįį lęįį ts'ą' gwiizųų gwitr'it t'agwah'in, gwiihtth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Juk dząą Damascus kwaiik'it gwats'ą' haazhii giinkhii kįh dilk'ii t'aih giits'an iłtsąįį. Juu noozhri' oozhii nąįį tee gwahąhdal eenjit.” Ananias yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","K'eegwaadhat Ananias jyaa dahnyąą, “Vats'ą' hinkhaii. Sheenjit gwitr'it t'agwahah'yaa eenjit vagwadoołkįį t'inchy'aa. Israel gwich'in nilįį kwaa nąįį, k'eedeegwaadhat choh nąįį, Israel gwich'in nąįį sheenjit goohąąhchyaa t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ts'ą' shęh'an gwintł'oo khaiinjich'iheedhat vats'ą' gwagwahaałkyaa t'inchy'aa.” ");
INSERT INTO gwiNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","K'eegwaadhat jyaa diiyahnyąą, geh'an ąįį zheh gwats'ą' haazhii. Gwizhit nihdeiinzhii tł'ęę danli' haa Saul ki' k'ąą naanjik, “Shachaa Saul, K'eegwaadhat nats'ą' shihił'e'. Jesus adan nilįį, nah'ya' dząą gwats'ą' tąįį gwin'ee gwinjik inkhaa dąį'. Ąįį nats'ą' shihił'e' gwahąąh'yaa ts'ą' Ch'anky'aa Shroodiinyąą ‘nats'ą' doo'ya'.’ noonyąą gwik'it t'inihi'yaa geenjit.” Ananias, Saul ahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Googwahkhan łuk gyuu' k'it t'inchy'aa vindee zhit gwats'an khaiinjil ts'ą' gwąąh'in needhidlit, tł'ęę ninehjin. Ąįįtł'ęę chųų yats'an iłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ąįįts'ą' ch'in'al tł'ęę vat'aii neegahoodlit. Ąįįtł'ęę drin gwinlęįį kwaa gwizhit Damascus zhit Jesus k'injiighit nąįį haa indi'. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ąįįtł'ęę khants'ą' Jews nąįį tr'igiinkhii zheh kwaii gwats'ą' haazhii. Izhik Jesus eegwaandak, “Jesus t'ee Vit'eegwijyąhchy'aa Vidinji' nilįį!” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Juu yiitth'ak nąįį datthak eenjit łyaa geegagoolii kwaa t'inyąą, “Jii dinjii Jerusalem gwizhit Jesus k'injigiighit nąįį datthak agwąąhshii, ąįį lee t'inchy'aa? Dząą gwats'ą' haazhii Jesus k'injigiighit nąįį ooheendal, ąįį eenjit gwizhrįh. Ąįįtł'ęę giinkhih kįh dilk'ii nąįį ts'eegooheelyaa, googwarahąąhshii eenjit, ąįį lee t'ohnyąą?” juu yuułk'įį nąįį jyaa ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saul, Jesus vagwandak Nizįį gǫąąhtan gwandaa gwinzii t'inyąą ilii, “Jesus adan Christ nilįį, ąįįt'ee narool'in chy'ąą t'inchy'aa.” nyąą. Jii jyaa nyąą dąį', łyaa gwinzii gwik'it teech'igiinkhee. Jews nąįį Damascus kwaiik'it gwizhit t'inchy'aa, ąįį nąįį nats'ahts'ą' giidii giheehkhyaa gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ąįįtł'ęę niighyuk gwahaadhat tł'ęę Jews nąįį nihłaa łigiiljil, nats'ahts'ą' Saul gahaahkhwaa, googwahahtsyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Gąą deeginyąą datthak giveenjit gwiitth'ak. Gweedhaa datthak drin, tǫǫ haa kwaiik'it gwachoh kii gwineedhi'ęę nju' charantąįį giiyeenjit gwak'ąąhtii, giiyuuheendal ts'ą' giihaahkhwaa eenjit. Gąą jii datthak chan gwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Saul, vijyaa gwik'injiighit nąįį tǫǫ gwizhit tł'oo tyah choh k'it t'inchy'aa zhit giiyąhchįį ts'ą' kwaiik'it kii gwineedhi'ęę ohts'ąįį tły'ah haa k'iizhak neegivyaagiiyiin'ąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ąįįtł'ęę Saul Jerusalem gwats'ą' haazhii. Izhik zhat Jesus k'injigiighit nąįį tee khwaihshi' yiindhan, “Shįį, Jesus vitsyaa juk ihłįį,” nyąą, gąą chan giik'injiighit kwaa. Ąįįts'ą' chan giiyąąnjat. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ąįįtł'ęę Barnabas yuunjik ts'ą' Tr'ihił'e' nąįį ts'ą' yihełchįį. “Saul Damascus gwits'eehaa gwiizhik K'eegwaadhat yits'ą' ginkhii, nah'ya'. Ąįįtł'ęę Damascus gwizhit łyaa naajat kwaa haa Jesus eegwaandak.” Barnabas gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ąįįtł'ęę gavaa t'inchy'aa. Gwiizhit Jerusalem gwizhit datthak naajat kwaa ts'ą' K'eegwaadhat Jesus eegoovaagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Zhat Jews Greek-ky'aa ginkhii nilįį nąįį haa ginkhii gaa tr'agavoiidlii. Gąą giiyęhdaa tr'igwihee'aa gwik'eegoogoonjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nijin gwik'injiighit nąįį geenjit gwigwiitth'ak dąį', Saul goonjik ts'ą' Caesarea kwaiik'it gwats'ą' giihiłchįį. Ąįįtł'ęę izhik gwats'an łyaa ninghit Tarsus kwaiik'it gwachoh goo'aii gwats'ą' nineegiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ąįįtł'ęę Judea, Galilee, ts'ą' Samaria nahkat gwa'an datthak Jesus k'injiighit nąįį haa gwintsal goovaa tsinehdan gwanlii. Ch'anky'aa Shroodiinyąą k'iighai' goot'aii gwanlii ts'ą' ginlęįį gaadlit. K'eegwaadhat Jesus deegihił'ee ts'ą' doo'yaa gavoonyąą gwik'it t'igii'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter nijuk datthak neehidik. Ch'ihłan Lydda kwaiik'it gwats'ą' haazhii, Jesus k'injigiighit nąįį zhat t'inchy'aa, hąąh'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Izhik zhat dinjii, Aeneas oozhii, nah'in. 8 (years) neegwiidhat gąhkhyuk datthak ichehk'it nakhaii kwaa, ts'ik ahchįį haa iłts'ik geh'an. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","“Aeneas, juk dząą Jesus Christ shrineeninlik. Ndak ninkhaii ts'ą' nats'at shrininlii.” Peter yahnyąą. Googwahkhan gwik'it t'iizhik ts'ą' ndak niinzhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nijin dinjii datthak Lydda kwaiik'it ts'ą' Sharon goozhii gwichyah gwa'an chųų choh geeghaih goo'aii, gwats'an lęįį nąįį nizįį neehoodlit, giiyąąh'in dąį', ąįį nąįį datthak K'eegwaadhat k'injigiighit gaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa kwaiik'it gwizhit tr'injaa, Tabitha oozhii, ąįį chan Jesus k'injiighit nąįį ch'ihłak nilįį. (Greek ginjik ky'aa Dorcas oozhii. Ąįį (Deer) vadzaih tsal k'it t'inchy'aa, gwinyąą t'igwinyąą.) Gweedhaa datthak gwinzii gwitr'it t'agwah'in ąįįts'ą' dinjii neeshraahchy'aa nąįį khit k'ąąhtii ts'ą' ts'inyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Izhit dąį' iłts'ik naanaii ts'ą' niindhat. Ąįįts'ą' giichį' k'eech'ąhtryaa ts'ą' ch'iyeedak zheh gwizhit nigiiyąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Joppa kwaiik'it ąįį Lydda kwaiik'it geeghaih ninghit kwaa goo'aii. Ąįįts'ą' juu Joppa gwizhit Jesus k'injigiighit nilįį nąįį, “Peter, Lydda kwaiik'it gwizhit t'inchy'aa.” gwinyąą gwigwiitth'ak dąį', dinjii neekwąįį nąįį giits'ą' hił'e'. “Khants'ą' diikwaiik'it gwizhik diits'ą' hinkhaii.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jii geenjit Peter shriidąązhik ts'ą' gavaa haazhii. Izhik zhat zheh ch'ihłak gwizhit nihdeiinzhii dąį', ch'iyeedak zheh deegiiyiłchįį. Tr'injaa ch'adąį' vakai' niinjik nąįį datthak giiyeelin neelzhii, Dorcas jidii gwach'aa ąįįts'ą' ik haa inghąn, ąįį kwaii giits'ą' k'eech'ąąhtii gwiizhik datthak gitree. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ąįįtł'ęę datthak cheegǫǫhaadlii. Ąįįts'ą' yeeghaii nikiigwiintthaii ts'ą' khagidiinjii. Ąįįtł'ęę yichi' ts'ą' nil'ee ts'ą' yąąh'in gwiizhit, “Tabitha, k'iidak ninkhee!” yahnyąą. Ąįįtł'ęę gwizhit dandee nihky'aa t'igwinlik. Nijin Peter nah'in dąį', k'iidak naadii. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ąįįtł'ęę yinli' oonjik yits'inyąą ts'ą' k'iidak niyiłkhin. Ąįįtł'ęę juu Jesus k'injigiighit nąįį ąįįts'ą' juu vakai' niinjik nąįį haa, “Nihdineekhwajyaa!” ahnyąą. Ąįįtł'ęę ąįį tr'injaa niindhat chy'ąą, neegwiindaii goots'ą' gwik'eech'eełtii. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Joppa gwizhit dinjii lęįį nąįį datthak geenjit gwigwiitth'ak. Ąįįtł'ęę izhik zhat dinjii lęįį nąįį chan K'eegwaadhat Jesus giinjik deenyąą k'injiginjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ąįįtł'ęę drin gwinlęįį gwizhit Peter, Joppa kwaiik'it gwizhit indi'. Dinjii Simon oozhii, haa gwinch'į'. Simon ch'adhah ahkhii nilįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Izhik Caesarea gwizhit niveet'ah'in kįh dhidii Cornelius oozhii, niveet'ah'in 100 nąįį, gavoozhri', “Italy Nankak Gwats'an.” goorahnyąą, ąįį eenjit k'eedeegwaadhat nilįį. Rome dinjii nąįį ts'an niveet'ah'in nilįį nąįį tee gwats'an ginlii. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelius łyaa dinjii nizįį nilįį. Adan ąįįts'ą' dinjii juu vizheh gwich'įį nąįį datthak drin gwiteegwagwaanchy'aa khit Vit'eegwijyąhchy'aa ts'ą' khagigidiinjii. Jews neeshraahchy'aa lęįį nąįį ts'iginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ch'ihłan drin drintł'an 3 o'clock gwandaa gweedhaa gwiizhik gineiinlyaa k'it t'inchy'aa haa gineiinlyaa. Izhit Vit'eegwijyąhchy'aa zheekat gwich'in yits'ą' niinzhii, łyaa gwinzii nah'in dąį', “Cornelius!” yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Łyaa gwiint'aii zheekat gwich'in yąąh'in, gwiizhik łyaa gwintł'oo naajat. “Shik'eegwaadhat, jidii dee?” yahnyąą. “Nijin khagidiinjii dąį', Vit'eegwijyąhchy'aa khit niitth'ak. Nats'ahts'ą' khit neeshraahchy'aa nąįį ts'iinyąą, ąįį datthak gwąąh'in ts'ą' nashoo ahłįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Juk Joppa kwaiik'it gwizhit dinjii, Simon Peter oozhii, nats'ą' heekhaa eenjit vakanch'ąh'ee. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Izhik zhat chųų choh vee gwa'an dinjii, Simon oozhii, ch'adhah ahkhii nilįį, ąįį haa gwich'įį t'inchy'aa.” zheekat gwich'in yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ąįįtł'ęę gihłeedahoodhat. Ąįįtł'ęę Cornelius ditsyaa neekwąįį nąįį ąįįts'ą' diniveet'ah'in ch'ihłak ąįį haa, “Aanaii!” ahnyąą. Ąįį niveet'ah'in khit yeenjit gwitr'it t'agwah'in nilįį. Ąįįt'ee łyaa dinjii Vit'eegwijyąhchy'aa k'injiighit nilįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelius deegwiizhik datthak gavaa gwaandak. Ąįįtł'ęę Joppa gwats'ą' goovihił'e'. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Gęhdaa drin tł'an tth'aii hee Joppa gwats'ą' geedaa. It'ee łyaa Joppa gwats'ą' ninghit kwaa nigijyaa. Ąįį gwiizhik Joppa gwizhit Peter zheh gwakat deedhizhii, khagiheejyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Izhik zhat t'inchy'aa gwiizhik łyaa vizhit gwiłts'ik ts'ą' ch'oih'aa, yiindhan. Gąą tth'aii hee vikeech'arahchy'aa gwiizhit gineiinlyaa k'it t'inchy'aa haa gineiinlyaa gwiizhik k'eegwiichy'aa gwąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ąįįts'ą' zheekat nihky'aa t'igwiizhik gwąąh'in. Ąįį gwats'an ts'at daagąįį k'it t'inchy'aa k'iidąą tr'iindak. Dǫǫ gwagwaanchy'aa ąįį ts'at danch'ahochaa ts'ą' nankak neevyaatth'at. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ąįį vizhit nin dzaa nankak gwats'an nihłehts'į' t'iichy'aa vizhit dilk'ii. Gyųų k'it t'inchy'aa kwaii ąįįts'ą' dziitsal kwaii yizhit nah'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","“Peter, k'iidak nindhat nin inghąn ts'ą' en'aa!” gwideezhuh yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","“Gąą Shik'eegwaadhat, łyaa duuyeh gwik'it t'ishi'in. Tth'aii ch'ihłok łąą k'aiich'ii shroodiinyąą nilįį kwaa ih'aa kwaa. Dii-law zhit jii nin kwaii datthak diineenjit shroodiinyąą nilįį kwaa. Ąįį k'it t'inch'ii łyaa duuyeh ih'aa.” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","“Chan shih shroodiinyąą nilįį kwaa doiinyą' shrǫ'! Vit'eegwijyąhchy'aa jidii ts'ą' ginkhe' datthak shroodiinyąą nilįį t'oonchy'aa.” gwideezhuh yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Gwideezhuh tik gwagwaanchy'aa nihk'it t'iiyaiinyą'. Ąįįtł'ęę ts'at daagąįį k'it t'inchy'aa zhit nin dilk'ii kwaii zheekat gwats'ą' neeroonjik. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nijin Simon Peter gineiinlyaa k'it t'inchy'aa zhit gwąąh'ya' dąį', gininjich'ahthat ts'ą' jidii eenjit t'igwii'in li', yiindhan. Ąįį gwiizhik dinjii Cornelius, Simon Peter ts'ą' yihił'e', ąįį nąįį giikwantee niinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“Dinjii Simon Peter oozhii, ąįį lee dząą gwich'įį?” gazhral ts'ą' ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ąįį gwiizhik tth'aii hee Peter gwintł'oo gininjich'ahthat, jidii gwąąh'ya' deegwinyąą t'igwinyąą li' yiindhan. Ch'anky'aa Shroodiinyąą jyaa yahnyąą, “Juk dinjii tik nąįį ninkeegwagwąąh'in ts'ą' nakwaiitee nigiilzhii t'igiinchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nineendii ts'ą' goovaahinkhaii. Geenjit tr'agoiindii shrǫ'! Shįį dząą nankagoovał'ęę t'igii'in.” ");
INSERT INTO gwiNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jii geh'an vakwantee dinjii niilzhii nąįį ts'ą' nineezhii, “Shįį t'ee dinjii vankeegǫǫh'in chy'ąą t'ihchy'aa. Jidii nohthan?” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Dinjii niveet'ah'in kįh Cornelius oozhii nats'ą' diinah'ęę t'igwii'in. Łyaa dinjii nizįį nilįį ts'ą' Vit'eegwijyąhchy'aa ts'ą' khit khagidiinjii. Jews nąįį łyaa giihił'ee. Vit'eegwijyąhchy'aa vizheekat gwich'in ch'ihłee yits'ą' ginkhe'. Vizheh veenihinkhaa ąįįts'ą' deiinyąą datthak noohaaky'aa geenjit.” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","“Nihdǫhjyaa ts'ą' shaa nohshaa.” gavahnyąą. Gęhdaa drin zhit nijin idishriinąąnjik dąį', k'iinjik gavaa neehoozhii. Joppa kwaiik'it gwats'an Jesus k'injigiighit lat nąįį chan giiyaahaajil. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ąįįtł'ęę gęhdaa drin Caesarea kwaiik'it k'idik. Izhik Cornelius niyuul'in. Vijyaa ts'ą' valak yinlii nąįį zhat gwats'ą' givinkeeginkhe'. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter nihdeehahkhaii gwiizhit Cornelius yits'ą' chiinzhii ts'ą' yakwai' chan neet'aanąįį ts'ą' nikiigwiintthaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Gąą “Ndak nininjii, ts'ą' k'iidak nindhat. Shęhdaa nikiigwąh'ee gishrigwąąhchy'aa kwaa t'oonchy'aa. Shant'ee dinjii nik'it t'inchy'aa inlįį t'ihchy'aa.” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter, Cornelius vizheh gwizhit nihdeegiin'oo gwiizhik, ąįį datthak Peter yaa ginkhii. Gwizhit dinjii lęįį nąįį nihłaa łigiiljil łee. Peter gavąąh'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ąįįtł'ęę goots'ą' ginkhii. Jyaa dinyąą, “Diikhwan Jews gwich'in nąįį tr'inlii ts'ą' dii-law zhit, Israel gwich'in nilįį kwaa eenarehee'al ąįįts'ą' goozheh gwizhit nihdeerehee'al. Ąįį łyaa tr'agwaanduu, gwiindhan. Jii nakhwan t'ee łyaa gaakhwandaii. ‘Israel gwich'in nilįį kwaa nąįį łyaa ginzįį kwaa ąįįts'ą' shroodiinyąą ginlii kwaa.’ Gąą shįį, Vit'eegwijyąhchy'aa datthak jyąhts'ą' ininjich'ałthat kwaa giveet'ihįįhkhyaa eenjit, datthak gwik'eesh'eełtii. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Jii geh'an nijin shoonkach'ąh'ee dąį', łyaa nagwal'ya' kwaa ts'ą' dzaa khan nats'ą' hoiizhii. Jaghaii shankach'ah'e'?” Peter yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius jyaa nyąą, “Drin tł'an gęhdaa 3 o'clock gwandaa juk nats'ąą nagwiindhat gwik'it gweedhaa gwiizhik, dząą shizheh gwizhit khagidihjii ts'ą' adach'al'aa kwaa. Gwiizhik gineiinlyaa k'it t'inchy'aa zhit khan hee dinjii ik ch'ąhndit naazhii, shandaa nadhat, nał'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘Cornelius, nijin khagidiinjii dąį', Vit'eegwijyąhchy'aa khit niitth'ak t'oonchy'aa. Nats'ahts'ą' neeshraahchy'aa nąįį ts'iinyąą. Ąįį datthak chan nah'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Dinjii Joppa kwaiik'it gwats'ą' hah'ee, dinjii Simon Peter oozhii, “dząą gwats'ą' hinkhaii,” ahaanjyaa eenjit. Chųų choh vee dinjii, Simon oozhii, ch'adhah ahkhii nilįį. Ąįį haa gwich'įį t'inchy'aa.’ jyaa, dinjii ik ch'ąhndit naazhii shahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ąįįtł'ęę khants'ą' dinjii ch'ihłee nonkadhał'e'. Juk dząą k'indik, geenjit łyaa shoo ihłįį. Juk K'eegwaadhat andah datthak łiriiljil. Izhik Vit'eegwijyąhchy'aa nats'ąą deenaiinyą' datthak geenjit naroohaahky'aa.” Cornelius yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ąįįtł'ęę Peter goots'ą' gahaakhe'. Jyaa dinyąą, “Vit'eegwijyąhchy'aa dinjii nąįį datthak ts'ą' łyaa nihk'it t'ii'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Juu datthak nijin gwats'an ahaa ji', googaa yits'ą' khagidiinjii nąįį ts'ą' gwinzii t'ii'in, Vit'eegwijyąhchy'aa łyaa giveenjit shoo nilįį. Ąįį łyaa juk łi'deegwidlii gwanlii gaashandaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Israel gwich'in nąįį eenjit Gwandak Nizįį ąįį łyaa gohtth'ak gwizhrįh gaakhwandaii, Jesus Christ k'iighai' Vit'eegwijyąhchy'aa vats'an tsinehdan gwanlii, dinjii nąįį datthak eenjit K'eegwaadhat nilįį t'inchy'aa. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Jii datthak gaakhwandaii, tr'ookit John chųų gwats'an ąhtsii ąįį dinjii nąįį ts'ą' ginkhe' ts'ą' chųų goots'an iłtsąįį. Ąįįtł'ęę Jesus, Galilee nahkat ts'ą' Judea nahkat gwizhit datthak gwintsii t'ee'ya'. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nats'ahts'ą' Jesus Nazareth gwats'an Vit'eegwijyąhchy'aa yigwiiłkįį ts'ą' Ch'anky'aa Shroodiinyąą yats'an iłtsąįį. Jyąhts'ą' dat'aii yats'an iłtsąįį. Ąįį datthak gaakhwandaii. Nijuk datthak neehidik ts'ą' dinjii ts'ą' gwinzii t'ii'in. Juu dinjii Ch'anky'aa Tr'aanduu vizhit nąįį goozhit cheehahchik ąįįts'ą' nizįį neegoovahtsik. Jyaa dii'in, Vit'eegwijyąhchy'aa khit yaa nilįį geh'an. Ąįį datthak gaakhwandaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Israel nahkat ąįįts'ą' Jerusalem kwaiik'it gwizhit gwa'an datthak jidii t'ee'ya', gwarąąh'ya'. Ąįį datthak dinjii ts'ą' geegwaandak. Giiyuunjik ts'ą' Cross kat gigiiyiłtsak ts'ą' giiyiiłkhwąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Gąą drin tik gwiindhat ąįįtł'ęę Vit'eegwijyąhchy'aa ch'ichį' ts'an ninęęyiłkhin. Ąįįtł'ęę Vit'eegwijyąhchy'aa k'iighai' diits'ą' vigwiilkįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Dinjii datthak yąąh'ya' kwaa gąą diikhwan zhrįh tr'ąąh'ya'. Ąįį gwehkįį dąį', Jesus veegwarahaandak eenjit diigwiiłkįį. Vit'eegwijyąhchy'aa ch'ichį' ts'an ninęęyiłkhin ts'ą' vaa ch'irin'al ts'ą' vaa chųų tr'eenį'. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jii Gwandak Nizįį dinjii haa gwarahaandak eenjit gwats'ą' diihił'e'. Jyaa dagoorahaanjyaa, “Adan łyaa Vit'eegwijyąhchy'aa yigwiiłkįį nilįį t'inchy'aa!” Dinjii ch'adąį' niinjik nąįį ąįįts'ą' juu gwandaii nąįį oohaahkat heelyaa eenjit t'iiyah'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Juu deenaa dąį' Vit'eegwijyąhchy'aa Eenjit Ginkhii inli' nąįį datthak giiyeeginkhe'. Jesus voozhri' zhit juu deenyąą yik'injiighit nąįį datthak gootr'agwaanduu gooveenjit oo'an gweheelyaa, zhit Vit'eegwijyąhchy'aa Eenjit Ginkhii inli' nąįį datthak jyaa giiyeeginkhe'.” Peter gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter tth'aii hee goots'ą' ginkhii gwiizhik datthak Ch'anky'aa Shroodiinyąą juu yuułk'įį nąįį k'ąą t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jews nąįį Jesus k'injigiighit nilįį nąįį Joppa kwaiik'it gwats'an giiyaak'eedal ąįį nąįį Israel gwich'in nilįį kwaa nąįį googaa Ch'anky'aa Shroodiinyąą oonjii, łyaa geegagoolii kwaa giveenjit t'igwii'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ch'anky'aa Shroodiinyąą gwikyaa zhit giginkhii geh'an. Vit'eegwijyąhchy'aa jiintsii deegihiił'ee gooviitth'ak geh'an. Peter jyaa goovahnyąą, ");
INSERT INTO gwiNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Jii dinjii nąįį geedan t'ee diik'it Ch'anky'aa Shroodiinyąą goonjik. Khan chųų goots'an tr'ahtsii kwaa gwarahahtsyaa lee t'oonchy'aa?” nyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","“Nakhwan t'ee Jesus Christ voozhri' zhit chųų nakhwats'an tr'ahtsii.” jyaa Israel nilįį kwaa nąįį ahnyąą. “Ąįį ji', dząą drin shriit'agwąąnchy'aa tth'aii hee diihaa dhindii?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Israel gwich'in nilįį kwaa nąįį googaa Vit'eegwijyąhchy'aa viginjik k'injigiighit. Tr'ihił'e' nąįį ąįįts'ą' gwik'injiighit nąįį Judea nahkat gwizhit datthak gwigwiitth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nijin Peter Jerusalem k'idik dąį', izhik zhat Jews nąįį Jesus k'injigiighit nąįį gwiizųų giiyeeginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Israel gwich'in nilįį kwaa nąįį gootthąį' kat khangwaraht'ii kwaa ts'ą' googwaraakii kwaa, ąįį nąįį jaghaii goozheh gwizhit gavaa gwinch'įį ąįįts'ą' gavaa ch'in'aa?” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ąįįts'ą' t'ee Peter nats'ahts'ą' tr'ookit gwats'an deegwiizhik datthak gavaa gwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Joppa kwaiik'it gwachoh gwizhit khadigihjii gwiizhik gineiinlyaa k'it t'inchy'aa shats'ą' gwagwaakįį haa. Izhit ts'at choh daagąįį k'it t'inchy'aa zheekat gwats'an neevyaatth'at, nał'in. Dǫǫ gwagwaanchy'aa ąįį ts'at dakhwachaa ts'ą' dząą sheeghaii neevyaatth'at. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nijin vizhit gwąął'in dąį', nin vatth'an dǫǫ gwanlii, nin iizųų, gyųų k'it t'inchy'aa ąįįts'ą' dziitsal nihłinehts'į' t'iichy'aa, ąįį kwaii vizhit nał'in. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ąįįtł'ęę gwideezhuh shats'ą' ginkhii. ‘Peter ndak ninkhaii. Inghąn ts'ą' en'aa!’ gwinyąą gwiihtth'ak. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","‘Gąą Shik'eegwaadhat, łyaa duuyeh gwik'it t'ishi'in. Tth'aii ch'ihłok łąą shih shroodiinyąą nilįį kwaa łąą ih'aa kwaa. Jii nin kwaii datthak shroodiinyąą nilįį kwaa, gwinyąą. Ąįį k'it t'inch'ii łyaa duuyeh ih'aa,’ vaihnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ąįįtł'ęę zheekat gwats'an chan hee gwideezhuh, jyaa shahnyąą. ‘Jidii K'eegwaadhat shroodiinyąą yahnyąą, ąįį kwaii shroodiinyąą nilįį kwaa doiinyą' shrǫ'!’ Gwideezhuh shahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Gwideezhuh tik gwagwaanchy'aa nihk'it t'ashaiinyą'. Ąįįtł'ęę datthak zheekat gwats'ą' t'ineezhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Izhik gwiizhik Caesarea kwaiik'it gwats'an dinjii tik nąįį shats'ą' tr'ihił'e', nijin t'ihchy'aa kwaiitee nigiinjil łee. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","‘Nagoodhan'in kwaa ts'ą' goovaahinkhaii,’ Ch'anky'aa Shroodiinyąą shahnyąą. Gwik'injiighit 6 nąįį chan Caesarea gwats'ą' shaahaajil. Izhik Cornelius vizheh gwizhit datthak nihdeeriinjil. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Izhik zhat, zheekat gwich'in shizheh gwizhit nadhat ts'ą' shats'ą' ginkhii, nał'yą', Cornelius shahnyąą.’ “Joppa kwaiik'it gwats'ą' dinjii hah'ee izhik dinjii Simon Peter oozhii, haa gwagwahaandak ts'ą', dząą gwats'ą' heekhaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Deehini'yaa goo'aii gwik'iighai' neehįįnzhii geenjit naagwahaandak. Ąįį haa nan ąįįts'ą' nizheh gwizhit gwich'įį nąįį datthak neegeheezhii.” zheekat gwich'in jyaa dashahnyąą.’ Cornelius shahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ąįįtł'ęę nijin goots'ą' goohoihkhe' dąį' Ch'anky'aa Shroodiinyąą gwehkįį diik'aa t'iizhik, ąįį gwik'it gook'aa t'iizhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","‘John, dinjii chųų haa gwats'an iłtsąįį, gąą nakhwan łyaa Ch'anky'aa Shroodiinyąą nakhwats'an tr'ahahtsyaa.’ K'eegwaadhat gwehkįį dąį', jyaa dinyąą chy'ąh, ąįį ganaldaii. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nijin diikhwan t'ee K'eegwaadhat Jesus Christ vik'injiriighit dąį', Ch'anky'aa Shroodiinyąą diits'an iłtsąįį. Israel gwich'in nilįį kwaa nąįį chan googaa Ch'anky'aa Shroodiinyąą ts'an iłtsąįį. Vit'eegwijyąhchy'aa Ch'anky'aa Shroodiinyąą goots'an hahtsyaa, ąįį gwik'it t'ihee'yaa kwaa gwahaałtsyaa? Ąįį sheenjit gashragwąhchy'aa kwaa.” Peter gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jyaa dinyąą giiyiitth'ak dąį' gwiizųų giiyeeneegiinjii kwaa ts'ą' Vit'eegwijyąhchy'aa deegihiił'ee, “Israel gwich'in nilįį kwaa nąįį gąą, juk łihts'eegihidęędaa ts'ą' k'iinjik neegeheedaa giveenjit goodlit, khit gwandaii gihee'yaa eenjit, Vit'eegwijyąhchy'aa jyąhts'ą' diindhan gwik'it t'iizhik!” ginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nijin Stephen tr'iiłkhwąįį dąį', juu Jesus k'injigiighit nąįį datthak shrihteegaajil, khaiinjich'agoorahthat geh'an. Goolat nąįį ninghit Phoenicia nahkat, ąįįts'ą' Cyprus njuu kat, ąįįts'ą' Antioch kwaiik'it gwachoh gwitee gwats'ą' gahaajil. Izhik gwa'an Jews nilįį nąįį zhrįh, Gwandak Nizįį eenjit gavaa gwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Gąą goolat nąįį Jesus k'injigiighit nąįį Cyprus njuu kat ts'ą' Cyrene kwaiik'it gwats'an, ąįį nąįį Antioch kwaiik'it gwats'ą' gahaajil. Izhik Israel gwich'in nilįį kwaa nąįį K'eegwaadhat Jesus Vagwandak Nizįį chan gavaa gwagwagwaandak. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Vit'eegwijyąhchy'aa vat'aih gii'įį, ąįį haa goots'ą' giginkhii. Ąįį geh'an dinjii lęįį nąįį K'eegwaadhat ts'ą' łihts'eedigeel'ee ts'ą' Jesus k'injigiighit gaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalem gwizhit Jesus k'injigiighit nąįį geenjit gwigwiitth'ak. Ąįįtł'ęę dinjii Barnabas oozhii Antioch gwats'ą' nagąąhchįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Izhik k'idik tł'ęę, nats'ahts'ą' Vit'eegwijyąhchy'aa vich'eegoonzhrii gwintł'oo dinjii nąįį ts'iinyąą, ąįį gwąąh'in, eenjit shoo nilįį, “Datthak ts'ą' khit K'eegwaadhat vik'injuhkhit nakhwahnyąą ąįį datthak gwik'it t'akhwa'in.” Barnabas gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas łyaa dinjii nizįį nilįį. Khit K'eegwaadhat k'injiighit. Ąįįts'ą' Ch'anky'aa Shroodiinyąą, “Deeni'in!” yahnyąą, ąįį datthak gwik'it t'ii'in. Dinjii lęįį nąįį yik'iighai' K'eegwaadhat k'injigiighit gaadlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ąįįtł'ęę Barnabas, Tarsus kwaiik'it gwachoh gwats'ą' haazhii, Saul oo'an keegwahąąh'yaa eenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nijin yagwąh'ąįį dąį', Antioch gwits'ee yihełchįį. Shree drin ch'ihłak gwahaadhat gąhkhyuk nihłaa Jesus k'injigiighit lęįį nąįį haa łineegaadal. Ąįįts'ą' geech'agoahtan. Antioch kwaiik'it gwizhit Christ k'injigiighit nąįį, izhik dąį' tr'ookit “Christian” goorahnyąą ts'ą' goovoozhri' dhidlit. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Izhik zhat dąį' Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį nąįį goolat Jerusalem gwats'an Antioch kwaiik'it k'eegiidal. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ąįį dinjii ch'ihłak, Agabus oozhii, nidhikhin, giheehkhyaa eenjit. Ąįįtł'ęę Ch'anky'aa Shroodiinyąą t'aih k'iighai' ginkhe', “Nankak datthak ninghit kwaa gwandaa ji', shih agwantrii nagahahdal gweheelyaa!” nyąą. (Nijin dinjii Claudius oozhii, Rome gwizhit k'eedeegwaadhat nilįį dąį', t'igwiizhik.) ");
INSERT INTO gwiNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Juu zhat Jesus k'injigiighit nilįį nąįį, larąą goots'an tr'ahahtsyaa, ąįį haa gwachaa nąįį Judea nahkat gwizhit gwich'įį nąįį ts'ą' neereheelyaa, goots'ireheenjyaa eenjit, giindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gwik'it t'igiizhik, Barnabas ts'ą' Saul haa laraa antł'eegiinlii, Judea tr'igiinkhii zheh ch'anjaa gwik'injiighit kįh dilk'ii nąįį antł'eegiiheelyaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Izhik zhat dąį', k'eedeegwaadhat choh (King) Herod Agrippa, Jesus k'injigiighit lat nąįį khaiinjich'igiighit gwahtsii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Shriichoo haa John voondee James oozhii, tr'iiłkhwąįį gwiłtsąįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jyaa diizhik dąį', Jews nąįį eechįį t'ii'in gwiky'aanjik dąį', gwandaa t'ii'in dhidlit, ts'ą' Peter chan oonjik. (Drin shroodiinyąą, zhit łųhchy'aa vaa naatuu kwaa tr'a'aa dąį' t'igwiizhik.) ");
INSERT INTO gwiNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ąįįtł'ęę Peter zhee gwaazhrąįį nagąąhchįį. Ąįįtł'ęę niveet'ah'in dinjii 16 nąįį giik'aahtii. Dǫǫ nąįį ginlii ts'ą' nihjįįkhaii neegeedaa. Passover gwideetaa gwahaadhat tł'ęę dinjii lęįį nąįį andaa nahałchyaa Vit'eegwijyąhchy'aa tr'oohahkat Herod jyaa diindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Deegwąhkhyuk Peter zhee gwaazhrąįį giłdii datthak tr'igiinkhii zheh nąįį giiyeenjit Vit'eegwijyąhchy'aa ts'ą' gwint'aii khadigigiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Herod, dinjii lęįį nąįį ndaaniyahahchyaa gwats'ą' khaa dąį', Peter, niveet'ah'in neekwąįį yik'aahtii nąįį deetak dhichįį ch'iitsii tły'ah neekwąįį haa gakhwachaa niveet'ah'in nąįį chan gindeiinvyaa gwadąįį gwik'eegahtii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Khan hee K'eegwaadhat vizheekat gwich'in zhat nadhat nagwaanąįį, ts'ą' zheh gwaazhrąįį gwizhit ch'eegwąhndit nagwaanąįį. Zheekat gwich'in, Peter vahk'at gahtrat haa tr'ineeyaahthat, “Khan, k'iidak ninkhee!” yahnyąą, gwiizhit ch'iitsii tły'ah vanli' ts'an dineetraa. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","“Tthah nazhrak tł'an gaanahchaa ts'ą' nakwaiitryaa zheeni'yaa!” yahnyąą. Peter gwik'it t'iizhik. “Ch'iyeedak ik nanantsuu ts'ą' shaa hinkhaii.” zheekat gwich'in yahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ąįįtł'ęę zhee gwaazhrąįį gwats'an Peter yaa haazhii. Gąą jii deegwii'in t'igwii'in łyaa gaandaii kwaa, gineiihłyaa t'igwii'in, yiindhan. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ąįįts'ą' gęhdaa niveet'ah'in tr'ookit gook'ąąhtii deek'it, kwaii ehgoo gahaa'oo. Ąįįtł'ęę khaiinkǫǫ zhee gwaazhrąįį gwats'an kwaiik'it gwachoh gwats'ą' chigweedii. Izhik ch'iitsii gindeiinvyaa dhitin, geeghaih k'eegii'oo. Gwiizhik gindeiinvyaa adakhai' gideenghaa. Ąįįtł'ęę chigiin'oo ts'ą' kwaiik'it gwitee'an tr'antąįį, izhik k'ii'an gee'al gwiizhik zheekat gwich'in Peter ihłee dahoodhat. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter nats'ahts'ą' vats'ą' deegwiizhik giky'aanjik ts'ą' jyaa nyąą, “King Herod ąįįts'ą' Jews nąįį haa nats'ahts'ą' vats'ą' deerehee'yaa, shagoonyąą. Ąįį gwats'an K'eegwaadhat neeshahahshii eenjit dizheekat gwich'in shats'ą' hił'e'. Ąįį juk łyaa łi'deegwidlii gwanlii gaashandaii.” ");
INSERT INTO gwiNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Jii t'igwiizhik giky'aanjik Googwahkhan John Mark oozhii vahan, Mary, vizheh gwats'ą' haazhii. Izhik lęįį nąįį nihłaa łigiiljil ts'ą' khagigidiinjii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ąįį gwiizhik Peter izhik zhat tthał zheh gwineedhi'ęę gindeiinvyaa kat ganlaanaii. Ch'itsyaa nilįį nich'it, Rhoda oozhii, gwats'ą' haazhii, juu zhat ganlaanaii, gwahąąh'yaa geenjit. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nijin Rhoda, Peter deezhuh diitth'ak dąį', yinaanjik. Łyaa yeenjit shoo dhidlit, zhat k'idik geenjit. Khants'ą' zheh gwizhit nihdanaagik, zhat k'idik yeegwahaandak eenjit. Gąą nihdeeyąąhchįį kwaa. Ąįįts'ą' tth'aii hee kwaiitee nadhat. “Peter chiitąįį nadhat!” gavahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Łyaa nahkhii t'iinyąą!” giiyahnyąą. “Gąą łyaa chiitąįį nadhat, t'aihnyąą!” gavahnyąą. “Peter t'inchy'aa kwaa, Vit'eegwijyąhchy'aa vizheekat gwich'in ąįį Peter haa nilįį t'inchy'aa!” giiyahnyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ąįį gwiizhik Peter tth'aii nihk'it ganlaanaii. Gohch'it dee ch'ihłee gootee gich'idiintin. Gąą nijin nigiiyiił'in dąį', łyaa geegagoolii kwaa giveenjit t'igwiizhik. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Googwahkhan danli' haa gooneehąhdak deegohtsai' kwaa ts'ą' sh'oodoohk'įį goovahnyąą. Ąįįtł'ęę nats'ahts'ą' K'eegwaadhat zhee gwaazhrąįį cheeyąąhchįį eenjit gavaa gwaandak. “James ąįįts'ą' gah gwik'injiighit nąįį datthak geenjit gavaagoondak.” gavahnyąą. Ąįįtł'ęę goovihłęęhoozhii ts'ą' ch'adanh gwa'an gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nijin vanh gach'ahaa'ąįį dąį', niveet'ah'in zhee gwaazhrąįį gwadąįį gwak'ąąhtii nąįį gwizhit łyaa deegwiizhik gaagiindaii kwaa, ts'ą' Peter deezhik gaagiindaii kwaa. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod, giiyankaheentyaa geenjit goohił'e' gaa giigwąh'ąįį kwaa. Zhee gwaazhrąįį gwadąįį gwak'ąąhtii nąįį deegwiizhik lee eenjit goovahkat gaa gaagiindaii kwaa ts'ą' ąįį geh'an, “Gavohkhan!” Herod gavahnyąą. Ąįįtł'ęę Herod Judea nahkat gihłeehoozhii ts'ą' Caesarea kwaiik'it gweheechy'aa geenjit gwats'ą' haazhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod łyaa Tyre ts'ą' Sidon kwaiik'it gwachoh gwich'in nąįį ts'ą' zhyaants'įį. Jii geh'an Tyre, ts'ą' Sidon gwich'in nąįį nihłaa łigiiljil gahah'yaa geenjit. Dinjii Blastus oozhii, t'ee Herod vizheh gwizhit gwats'ą' k'eedeegwaadhat nilįį, ąįį lak giltsąįį, goots'iheenyaa geenjit, ąįįtł'ęę Herod ts'ą' gahaajil, tsinehdan gweheelyaa geenjit. K'eedeegwaadhat Herod vanahkat gwats'an shih neegoiindak geh'an t'iginyąą. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ch'ihłan drin ik chil'ee yaa k'eedeegwaadhat eenjit nilįį nanaazhii ts'ą' vakat k'eedeegwaraadhat ts'ą' daraadii, ąįį kat naadii. Ąįįtł'ęę datthak giiyaa łeeljil. Izhik datthak goots'ą' ginkhii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","“Jii łąą dinjii t'inchy'aa kwaa, gąą vit'eegwijyąhchy'aa nąįį ch'ihłee nilįį.” ginyąą ts'ą' gazhral. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Vit'eegwijyąhchy'aa ts'ą' deehił'e' kwaa geh'an, Googwahkhan K'eegwaadhat vizheekat gwich'in ch'ihłee Herod hahts'įk eenjit yats'an gwiłtsąįį. Gyųų yin'al ts'ą' niindhat. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Gwiizhik dinjii lęįį nąįį Vit'eegwijyąhchy'aa viginjik giintth'ak, ąįįts'ą' Jesus k'injigiighit nąįį gwandaa lęįį gilii. ");
INSERT INTO gwiNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nijin Barnabas, ts'ą' Saul haa Jerusalem kwaiik'it gwizhit digwigwitr'it gigiinjik dąį', Antioch kwaiik'it gwits'ee gahoo'oo. John Mark gavaa tr'agwahaah'ya' eenjit dahaa neegiihiłchįį. ");
INSERT INTO gwiNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioch kwaiik'it gwachoh gwizhit Jesus k'injigiighit nąįį tee gwats'an goolat Vit'eegwijyąhchy'aa Eenjit Ginkhii nilįį ąįįts'ą' geech'ǫąąhtan nąįį ginlii. Gavoozhri' Barnabas, ts'ą' Saul, haa ąįįts'ą' Simeon (“Ąįį Dinjii Zhrąįį,” giiyahnyąą), Lucius (Cyrene kwaiik'it gwats'an), Manaen (k'eedeegwaadhat Herod Antipas haa nihłaa dink'igiindhat), ąįį nąįį haa. ");
INSERT INTO gwiNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2"