﻿USE sofia;
DROP TABLE IF EXISTS sofia.gvs_vpl;
CREATE TABLE gvs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gvs_vpl WRITE;
INSERT INTO gvs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Aba vatowo goi tutayana Yaubada yábana igimiwodugudi be poyapoya igimiwodugu, ");
INSERT INTO gvs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","(Ego poyapoyayana ame geya ana katubayasinamo be nakae daakakaina. Go madabokina bwae dimówana ilatao. Dimowanayana yatanaina goi kokonótuya gagaina ikaaiyaka nakae Yaubada Balomaina itaakavata.), ");
INSERT INTO gvs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","e sopana goi imadágina idigo kana, ‘¡Mavada kusowōduwo!’ E mavadayana isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mavadayana igite dedevina, e iuyaone. Imadagi ikavava, mavada be kokonótuya ikiwotaidi, e mavada ituli, kokonótuya ituli. ");
INSERT INTO gvs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","E mavadayana ivayou maliyalina go, kokonotuyayana ivayou sabamgo. ");
INSERT INTO gvs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","E Yaubada sopana goi imadágina idigo kana, ‘Sekulapeya kusowōduwo go, bwae kuwotāi.’ ");
INSERT INTO gvs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","E tauna nakae isowóduwo. Sekulapeyayana isowóduwo, e bwaeyana iwotai. Bwae diligaema ituli, bwae ditonema ituli. ");
INSERT INTO gvs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Sekulapeyayana ivayoko yábana. ");
INSERT INTO gvs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","E Yaubada sopana goi imadágina idigo kana, ‘¡Bwae ditonema, kōna dadava tayamo goi kolamgōgana bei dadava tayamo sayasayaina isowóduwo!’ E tauna nakae isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Imadagi ikavava, dadavayana sayasayaina ivayoko poyapoya go, bwaeyana ivayoko négwasa. Igitedi dedevidi, e iuyaonedi. ");
INSERT INTO gvs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Aiyuwoina Yaubada idigo kana, ‘Poyapoya, kom goi náuna sisūsuwo go, limou sidīdi be nakae kokowoika keuwoidi sikéuwo, taudi nakae ma kutukutudi.’ E tauna nakae isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Poyapoya goi náuna madabokidi nakae sisúsuwo. Yaubada igitedi dedevidi, e iuyaonedi. ");
INSERT INTO gvs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Lavilavi ima namliyeta nobuyana ima. ");
INSERT INTO gvs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","E Yaubada sopana goi imadágina idigo kana, ‘¡Aba mavada yábana osasaina goi kosowōduwo, bei maliyalina nakae sabamgo kowotaidi! Aba mavadayami moe aba kinana maliyalina, tukówana be nakae tala tamo tamo manudi. ");
INSERT INTO gvs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Komi aba mavada yábana osasaina goi konininīma bei poyapoya koomavade.’ E tauna nakae sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Aba mavadayadi aiyuwo gagaidi iwodugudi, tayamo gagaina toina moe maliyalina iloovinae go, tayamo tupwana giyaina moe sabamgo iloovinae. Go utuna nakae taiyao iwodugudi. ");
INSERT INTO gvs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Iwodugudi ikavava, yábana osasaina goi iyatoidi bei sininínima poyapoya siimavade ");
INSERT INTO gvs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","be maliyalina sabamgo siloviinaedi be nakae mavada kokonótuya siwootaidi. Yaubada igitedi dedevidi, e iuyaonedi. ");
INSERT INTO gvs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Lavilavi ima namliyeta nobuyana ima. ");
INSERT INTO gvs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","E Yaubada sopana goi imadágina idigo kana, ‘¡Négwasa iyaiyanimi badabadaimi kosowōduwo! ¡Nakae mánuwo kosowōduwo, e poyapoya yábana osasaidi goi koyovayōva!’ ");
INSERT INTO gvs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tauna Yaubada íyana gagaidi be kaga liliuna maa yawoidi be nakae mánuwo liliudi iwodugudi, taudi idi sinapu nakae. Yaubada igitedi dedevidi, e iuyaonedi. ");
INSERT INTO gvs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","E ikaipakuyedi idigo kana, ‘Négwasa iyaiyanimi kosusāila gagaina, e negwasayana kovakayaodēi. Mánuwo nakae, poyapoya goi kosusāila.’ ");
INSERT INTO gvs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Lavilavi ima namliyeta nobuyana ima. ");
INSERT INTO gvs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","E Yaubada sopana goi imadágina idigo kana, ‘Poyapoya, kom goi kaga liliuna maa yawoidi sisowōduwo, maisidi taudi nakae, yoguyogu daladalaidi, bolitavanu be woiwoi, gagaidi be giyaidi.’ E tauna nakae sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kaga liliuna maa yawoidi, bolitavanu be woiwoi be nakae yoguyogu daladalaidi iwodugudi go, igitedi dedevidi, e iuyaonedi. ");
INSERT INTO gvs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","E Yaubada sopana goi imadágina idigo kana, ‘Tomota taodugūdi ada tapata, tauyadi kita nakae, e bei íyana, mánuwo, bolitavanu, yoguyogu daladalaidi be nakae kaga liliuna maa yawoidi poyapoya ame goi sikaaiyaka sikalibubudi.’ ");
INSERT INTO gvs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tomota iwodugudi Tauyana toinina ana tapata. ");
INSERT INTO gvs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Iwodugudi ikavava, ikaipakuyedi idigo kana, ‘Kosusāila be poyapoya kovakayaodēi, e poyapoyayana koepaisēwe ami dedevina manuna. Nakae íyana, mánuwo be nakae kaga liliuna maa yawoidi poyapoya goi sidaladala kokaliibubūdi.’ ");
INSERT INTO gvs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kana, ‘¡Konōve! Náuna kutukutudi liliudi be nakae kokowoika keuwoidi liliudi bogina avinimi moe avami. ");
INSERT INTO gvs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Woiwoi liliudi gagaidi be giyaidi, mánuwo liliudi, kaga liliuna poyapoya goi sidaladala nakae maa yawoidi, e náuna liliudi avinidi, moe avadi.’ E tauna nakae isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kaga liliuna Yaubada bogina iwoodugudi igitedi madabokina moe dedevidi, e iuyaonedi gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Moeko goi yábana be poyapoya be nakae kaga liliuna adi madágina bogina ikavava. ");
INSERT INTO gvs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tuwo maliyalina ainima tayamoina goi Yaubada ina paisewa ilukavavedi go, maliyalina ainima aiyuwoina ina paisewa madabokina goi iwaiwasi. ");
INSERT INTO gvs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ago maliyalinayana ikaipakuye sowona be nakae ikimasabe toinina umana unana ina paisewa madabokina bogina ikavava, e maliyalinayana goi iwaiwasi. Tauna ikaipakuye be ikimasabe. ");
INSERT INTO gvs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ame kaga liliuna sisowóduwo yábana be poyapoya goi tetelidi boi tutayana Yauwe Yaubada iwodugudi. ");
INSERT INTO gvs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","E Yauwe Yaubada kúwana nava geya ietuneyeta poyapoya goi be nakae geya tayaamo avatau ikaaiyaka bei ibágula, tauna náuna poyapoyayana goi nava geya sisowoduwoita nakae geya kada tayaamo kutukutu itabo geya. ");
INSERT INTO gvs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kúwana geya go, bwae doelu goi ituko imamaima bei poyapoya ana madabokina ivakaanapoive. ");
INSERT INTO gvs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","E amo tutayana Yauwe Yaubada poyapoya kaukauna ikabi, koroto imolului. Imolului ikavava, kubuna goi yawoina isalauwe, e korotoyana maa yawoina. ");
INSERT INTO gvs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","E Yauwe Yaubada alova tanuina tayamo Ideni goi ikatubayasi, moe bomatu dadavina. Amoko goi korotoyana bogina iiwodugu iyato. ");
INSERT INTO gvs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Iyato go, alova liliudi neta adi kaigigita dedevidi be nakae keuwoidi adi káika dedevidi ilovinaedi poyapoya goi sitabo. Ego tanuwoyana nauyayanaina goi alova aiyuwo sikaaiyaka, tayamo moe yawana vata unana alovaina. Ago tayamo moe dedevina be goyo adi kabitam alovaina. ");
INSERT INTO gvs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","E sákala tayamo Ideni goi idaudau tanuwoyana ivakaanapoive. Sakalayana Ideni goi isowóduwo iwotai, e sákala aivasi sidau. ");
INSERT INTO gvs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Sákala tayamo yoina Paisoni idau ina asa Abila idaunibisi go, amoko goi goura ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Amo asayana ana goura moe dedevina toina. Pútuma dedevina toina yoina bidelium be nakae gurewa maisana gagaina yoina anikisi nakae sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Sákala aiyuwoina yoina Gikoni. Ame sakalayana asa Kosa idaunibisi. ");
INSERT INTO gvs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sákala aitonina yoina Tigirisi. Ame sakalayana asa Asiriya bomatu dadavina goi idau. Sákala aivasina yoina Yuparetisi. ");
INSERT INTO gvs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","E korotoyana kina Yauwe Yaubada ikabi, tánuwo Ideni goi iyato bei ipaaisewa Yaubada umana be nakae tanuwoyana imataakavate. ");
INSERT INTO gvs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Iyato ikavava, ina lovina ivini idigo kana, ‘Alova keuwoidi madabokidi tánuwo goi atagonem kukanidi ");
INSERT INTO gvs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","go, dedevina be goyo adi kabitam alovaina taabu kukanikāni. Neta kukani, e moitamo toina bei kukámasa. Tauna taabu kukanikāni.’ ");
INSERT INTO gvs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","E Yauwe Yaubada idigo kana, ‘Geya idedevineta neta korotoyana anetava ikaaiyaka. Tuwo tayamo tovaita aodugu bei koroto sowona.’ ");
INSERT INTO gvs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","E tuwo poyapoya ikabi, yoguyogu be mánuwo liliudi iwodugudi. Iwodugudi ikavava, imedi korotoyana yaina. Latuwona iyagoi korotoyana manakaena bei tamo tamo ivayoudi. Neta ava you iivinidi, e moe yoidi. ");
INSERT INTO gvs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Tuwo moitamo korotoyana yoguyogu be mánuwo be woiwoi liliudi ivayoudi go, geya kada tayaamo yoguyogu itoboine bei tauyana ina tovaita geya. ");
INSERT INTO gvs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tauna korotoyana matamasimasisi gagaina kina Yauwe Yaubada ivini ikanamatáiya. Ikanaamatáiya go, korotoyana silalumina tayamo ikabi, íwaya iyato, silaluminayana kiyauna ivasumapu. ");
INSERT INTO gvs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ivasumapu ikavava, silaluminayana ikabi, vavina iwodugu. Iwodugu ikavava, ikabi ime korotoyana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tuwo korotoyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","E tauna moe pasina koroto tamana be sinana yaidi itumasaba go, monena taiyao situyuwo, tauna adi taiyuwokova wowodi tayamo. ");
INSERT INTO gvs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Korotoyana ma monena adi taiyuwo sipawaku go, geya siomaemaeta. ");
INSERT INTO gvs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","E moteta tonuwosinapu gagaina. Nakae woiwoi madabokidi Yauwe Yaubada iwoodugudi ikalisavedi. Tauyana ima vavina ilatuwoko idigo kana, ‘¡Iyaa! ¿Moitamo Yaubada idigodigo bego alova keuwoidi madabokiidi tánuwo sinaena taabu kookanīdi, ae?’ ");
INSERT INTO gvs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Go kina vavinayana idigo kana, ‘¡Geya! Tánuwo alovaidi keuwoidi mama tagona kakanidi. ");
INSERT INTO gvs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Alova tayamo tánuwo nauyayanaina goi ikaaiyaka manuna Yaubada idigo kana, “Taabu keuwoina kokanikāni be taabu kobiisikōne, govila bei kokámasa.”’ ");
INSERT INTO gvs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Go kina motetayana idigo kana, ‘¡Geya kokamaseta. Geya toina! ");
INSERT INTO gvs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Moitamo. Yaubada iyagoi tutayana keuwoinayana kokani, nukotomi bei ikipolaledi, e komi basaleliuyao nakae, dedevina be goyo koyagoidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tuwo vavinayana ikandolaga alova keuwoina igite ana kaigigita dedevina. Aiyuwoina ana káika dedevina be ana kaikayana goi itoboine nuwopolala ikabi, tauna iyale. Tuwo moitamo keuwoina tayamo iguwe, e ikani. Ikavava, monena nakae tayamo ivini ikani. ");
INSERT INTO gvs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Sikani ikavava, mainao adi taiyuwokova nukotodi ikipolaledi, tauna siyagoi sipawaku. Tuwo lao vagana siguledi, sigilumidi adi tabodaboda. ");
INSERT INTO gvs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Sigíluma ikavava, lavilavi Yauwe Yaubada aena butukáona sinove tánuwo goi ivaabebeo. Tuwo kidi alova nauyayanaidi goi sivatamtamumuye. ");
INSERT INTO gvs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ago Yauwe Yaubada korotoyana itumadade idigo kana, ‘¿Kom nakoim?’ ");
INSERT INTO gvs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","‘Tánuwo goi aem butukáona anove go, apawaku, tauna amatoita, tuwo avatamtamumuyem’, korotoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Go Yaubada idigo kana, ‘¿Avatau ilatuwokoim bego kom kupawaku? ¿Manakae? ¿Alovayana keuwoina asanaabodem bogina kukani?’ ");
INSERT INTO gvs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","‘Vavinayana boi kuuvinigu, alova keuwoina ivinigu akani’, korotoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tuwo Yauwe Yaubada vavinayana ilatuwoko idigo kana, ‘¡Iyaa! ¿Kaga unana moe nakae kuguinuwe?’ ‘Moteta ikatubaugu, akani’, vavinayana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tuwo Yauwe Yaubada itáoya, motetayana ilatuwoko idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Go vakaleya kom be vavinayana nauyayanaimi goi bei ayato. ");
INSERT INTO gvs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","E vavinayana ilatuwoko idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","E Adama ilatuwoko idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Go náuna nakae taliboibo poyapoyayana goi ");
INSERT INTO gvs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mam mosali bei kupaaisewa gagaina ");
INSERT INTO gvs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","E korotoyana monena tomota liliudi unadi, tauna ivayou Ivi. ");
INSERT INTO gvs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","E Yauwe Yaubada yoguyogu sakavaidi ikabidi, Adama ma monena adi kwama imadagidi, ivalosidi. ");
INSERT INTO gvs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","E Yauwe Yaubada idigo kana, ‘¡Iyaa! ¡Tomotayadi bego kita nakae, dedevina be goyo siyagoidi! ¡Tuwo tasanabodēdi bei geya itoboinedita yawana vata alovaina keuwoina sikabi, govila bei sikani sikaiyako vata!’ ");
INSERT INTO gvs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","E tuwo moitamo tánuwo Ideni goi ivalilivedi sina go, Adama poyapoya goi bei ibágula. ¡Ego amo poyapoyayana goi boi Yauwe koroto iwodugu! ");
INSERT INTO gvs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Tuwo ivatapiyedi ikavava, e tanuwoyana Ideni ana kaba siu goi moe bomatu dadavina yábana ana tomatakavatayao iyatoidi. Tayamo sisi yeu sabeninimina iyato go, sisiyana ikaivivilo bego aba siu itubode. Moe dogoiyadi iyatoidi bego geya vatau tayaamo bei tanuwoyana goi isiu ina yawana vata alovaina keuwoina ikabi, ikani. ");
INSERT INTO gvs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","E kina go Adama monena Ivi taiyao simasisi, ikéuwama go, niga ivenátuna, natuna koroto. Tuwo idigo kana, ‘Yauwe ina vaita goi natugu bogina ababane.’ Tauna natunayana ivayou Keni. ");
INSERT INTO gvs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Niga aiyuwoina ivenátuna, natuna koroto moe Keni siyana yoina Ebeli. Sikaiyaka, gogómana sibíbina gagaidi. E kina go Ebeliyana yoguyogu sipi ana tomatakavata go, kina Keniyana tobágula. ");
INSERT INTO gvs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","E niga go dibayoya ana tuta goi Keni ina dibayoya keuwoina maniyedi ikabidi ina vininabeso go, imedi Yauwe yaina ikasaledi. ");
INSERT INTO gvs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","E kina go Ebeliyana nakae ina vininabeso moe sipi bonatudiyao botomoya be saabalidi, e ikaumatedi. Ikavava, imedi Yauwe yaina ikasaledi. Yauwe igitedi, e Ebeli be ina vininabesoyadi iuyaonedi ");
INSERT INTO gvs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","go, Keniyana be ina vininabesoyadi geya iuyaonedita. Tuwo Keni gamona igoyo toina, e kubuna ipulu. ");
INSERT INTO gvs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","E Yauwe idigo kana, ‘¿Keni, kaga unana gamom igoyo? ¿Kaga unana kubum ipulu? ");
INSERT INTO gvs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","¿Neta im guinuwa dedevina, bei mam uyáwana ae? Go neta im guinuwa geya idedevineta, e bágala yoguyogu sasasaina nakae totom goi iyokabúbuna; latuwona kom ilovinaem go, ina togaga kulovināe.’ ");
INSERT INTO gvs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","E tuta tayamo Keni siyana Ebeli ilatuwoko idigo kana, ‘Tāna yoyowo.’ Tuwo moitamo sina yoyowo goi go, tutayana amoko goi sikaaiyaka, e Keniyana itáoya, siyana Ebeli ikaumate. ");
INSERT INTO gvs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","E Yauwe Keni ilatuwoko idigo kana, ‘¿Siyam Ebeli nako?’ ‘Seki, geya ayagoiyeta. ¿Manakae? ¿Yau siyagu ana tomatakavata?’ Keniyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Go kina Yauwe idigo kana, ‘¡Moe kaga kuguinuwe! ¡Kunōve! Siyam ikaikaina tomota nakae poyapoya goi itaiyaduduwo Yau yaigu. Latuwona im kaumata pasina Yau akatumapum. ");
INSERT INTO gvs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","E tauna ame tuta im guinuwa pasina akatubolatem. Poyapoya goi avalilivem, tauna geya tuwaina bei itoboinem poyapoya goi kubágula. Ame poyapoyayana siyam ikaikaina inim tutayana kwaumate. ");
INSERT INTO gvs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Bego poyapoyayana goi kubágula go, kom manum poyapoya ilogoyo. Tauna poyapoya ame goi kom bei kuketoiya beso; geya im kasamo.’ ");
INSERT INTO gvs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Go kina Keniyana idigo kana, ‘¡Iyaa! ¡Guna liuna moumou ivakaigaga yaigu! Geya itoboineguta atogaga. ");
INSERT INTO gvs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","¡Gwa! Ame bei poyapoya ame goi kuvatapiyegu, tauna matam goi geya itoboineguta akaaiyaka. Tuwo bei poyapoya ame goi avabebeo beso unana geya guna kasamo. Tauna avatau neta ibabanegu, bei ikaumategu.’ ");
INSERT INTO gvs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tuwo kina Yauwe idigo kana, ‘Moe nakae geya. Ame nakae bei aguinuwe: Avatau neta ikaumatem, tauyana ana katumapu moe aliune gagaina toina.’ E tuwo tayamo aba kinana Keni goi iyato, govila bei avatauwa neta tauyana sibabane sikaumate. ");
INSERT INTO gvs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","E Keni itáoya Yauwe matana goi isowóduwo ina asa yoina Nodi; moe Ideni bomatu dadavina. ");
INSERT INTO gvs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","E Keni monena taiyao simasisi, e ikéuwama. Niga ivenátuna, natuna Enoki. Ego amo tutayana Keni ilokasa, tauna asayana ivayou Enoki, nakae natuna yoina. ");
INSERT INTO gvs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ago Enokiyana natuna koroto Iradi. Iradi natuna koroto Mekuyaeli. Mekuyaeli natuna Metusaeli go, Metusaeli natuna Lemeki. ");
INSERT INTO gvs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Kina Lemekiyana vevina adi taiyuwo inaidi, tayamo yoina Eda, tayamo yoina Sila. ");
INSERT INTO gvs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Edayana ivenátuna, natuna koroto yoina Yabali. Tauyana yoyou parai goi igimimasisi go, yoguyogu sipi be bulumakau imatakaavatedi. Ago tubunao giyaidi nakae siguinuwe, situliya asa tamo tamo. ");
INSERT INTO gvs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabaliyana siyana yoina Yubali. Tauyana api ana láuwo be kokopi ana uwa unadi. ");
INSERT INTO gvs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","E kina Silayana nakae ivenátuna, natuna koroto yoina Tubali Keni, tauyana kainum be kopwa goi turu iwodúguna. Tauyana niuna yoina Nama. ");
INSERT INTO gvs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","E tuta tayamo Lemeki mana gágasa monenao adi taiyuwo ilatuwokoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Neta Keni ana kámasa ana katumapu ");
INSERT INTO gvs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","E Adama monena taiyao aiyuwoina simasisimna, e ikéuwama, ivenátuna natuna koroto. Monenayana idigo kana, ‘Yaubada natugu ivinigu Ebeli ana katumapu unana Keni ikaumate.’ Tauna natuna ivayou Seti. ");
INSERT INTO gvs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Niga Seti ibíbina gagaina ivenátuna, natuna koroto yoina Enosi. E amo tutayana goi tomota sivatowo Yauwe yaina sisakululu. ");
INSERT INTO gvs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","E buki ame moe Adamayana ana liliu bukina: Tutayana Yaubada tomota iwodugu, toinina ana tapata nakae iwodugu. ");
INSERT INTO gvs_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Tomotayadi koroto be vavina iwodugudi. Ikavava, ikaipakuyedi go, ivayokoidi tomota tutayana iwodugudi. ");
INSERT INTO gvs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","E Adama ana tala ana badabada 130 tutayana natuna koroto ibíbina. Gomanayana tamana Adama ana tapata, e Adamayana nakae. E ivayou Seti. ");
INSERT INTO gvs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seti ana bíbina mlina, Adamayana ikaaiyaka tala ana badabada 800 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tauyana yawoina ana madabokina moe tala ana badabada 930, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","E Setiyana ana tala ana badabada 105 tutayana natuna koroto yoina Enosi ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosi ana bíbina mlina Setiyana ikaaiyaka tala ana badabada 807 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tauyana yawoina ana madabokina moe tala ana badabada 912, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","E Enosiyana ana tala ana badabada 90 tutayana natuna koroto yoina Kenani ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenani ana bíbina mlina, Enosiyana ikaaiyaka tala ana badabada 815 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tauyana ana tala madabokina moe 905, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","E Kenaniyana ana tala ana badabada 70 tutayana natuna koroto yoina Malaleli ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Malaleli ana bíbina mlina, Kenaniyana ikaaiyaka tala ana badabada 840 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tauyana yawoina ana madabokina moe tala ana badabada 910, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","E Malaleliyana ana tala ana badabada 65 tutayana natuna koroto yoina Yeredi ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yeredi ana bíbina mlina, Malaleliyana ikaaiyaka tala ana badabada 830 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tauyana yawoina ana madabokina moe tala ana badabada 895, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","E Yerediyana ana tala ana badabada 162 tutayana natuna koroto yoina Enoki ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enoki ana bíbina mlina, Yerediyana ikaaiyaka tala ana badabada 800 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tauyana yawoina ana madabokina moe tala ana badabada 962, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","E Enokiyana ana tala ana badabada 65 tutayana natuna koroto yoina Metusela ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metusela ana bíbina mlina, Enokiyana iiketoiya nakae Yaubada iuyaone tala ana badabada 300. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tauyana yawoina ana madabokina moe tala ana badabada 365. ");
INSERT INTO gvs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ego talayadi goi iiketoiya nakae Yaubada iuyaone namliyeta baige ikabiyamo, tauna geya maisinamo. ");
INSERT INTO gvs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","E Metuselayana ana tala ana badabada 187 tutayana natuna koroto yoina Lemeki ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemeki ana bíbina mlina, Metuselayana ikaaiyaka tala ana badabada 782 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tauyana yawoina ana madabokina moe tala ana badabada 969, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","E Lemekiyana ana tala ana badabada 182 tutayana natuna koroto ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Tuwo idigo kana, ‘Nakona ame gomanayana ibíbina gagaina baige isawoilaveda ida paisewa moumouna goi; paisewayana moe poyapoya Yauwe boi ikatubolate pasina.’ Tauna natuna ivayou Nowa. ");
INSERT INTO gvs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","E Nowa ana bíbina mlina Lemekiyana ikaaiyaka tala ana badabada 595 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tauyana yawoina ana madabokina moe tala ana badabada 777, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","E Nowayana ana tala ana badabada 500 mlina natunao koroto Semi, Em be Diyepeta sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","E tomota poyapoya ana madabokina goi bogina sisusáila go, yaidi goi natudiyao vevina sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Amo tutayana Yaubada natunao koroto vevinayadi sigitedi gumaboidi, e ava vevinava latuwodi, e sikinavedi bei sinaidi. ");
INSERT INTO gvs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tuwo Yauwe idigo kana, ‘Geya atagoneta guna togaga maa yawoina ikaiyako vata tomota yaidi unana tauyadi sakava kaka. Tauna adi tala bei akatuyaivi 120 baige sikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","E amo tutayana be nakae tuta mlina Nepilim poyapoya goi sikaaiyaka. Ego boi tutayana vevina Yaubada natunao taiyao ō simasisi, e vevinayadi sikéuwama, sivenátuna, natudiyao moe kidi Nepilimyadi. E tauyadi tokaalikaidi be nakae valedi gagaidi. ");
INSERT INTO gvs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","E Yauwe ikandosobu tomota idi goyo igitedi sivakaigaga be nakae tuta liliuna idi nuwogau liliudi nuwodi goi sigoyo. ");
INSERT INTO gvs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Igitedi, mana nuwomou ina madágina manuna nuwona ikatuvilavila, e pasina mana kategeda gagaina gamona igoyo. ");
INSERT INTO gvs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tuwo idigo kana, ‘Ategu igeda guna madágina pasina. ¡Neta boi geya aodugudita! Tauna tauyadi boi aodugudi ame bei asamatedi, tomota, yoguyogu, dogoi daladalaidi be nakae mánuwo. Geya kada tayaamo poyapoya goi bei ikaaiyaka geya.’ ");
INSERT INTO gvs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","E kina go Nowa ituli, Yauwe isosale. ");
INSERT INTO gvs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","E ame moe kina Nowayana tetelina. Tetalayana ame nakae: Nowa tokibóbwata tayamo o kada tomota liliudi yaidi goi tauyana anetava geya ana pikwanamo. Tauyana iiketoiya Yaubada taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowayana natunao koroto adi taito: Semi be, Em be nakae Diyepeta. ");
INSERT INTO gvs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","E da poyapoya bogina sigoyo Yaubada matana goi nakae poyapoya aigoyo goi ikayaoda. ");
INSERT INTO gvs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tuwo da poyapoyayadi kina Yaubada igitedi, e moitamo bogina sigoyo toina unana poyapoyayana goi kaga liliuna maa yawoidi idi sinapu bogina sikaigoyaidi. ");
INSERT INTO gvs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tuwo Yaubada Nowa ilatuwoko idigo kana, ‘Bogina alovina bego kaga liliuna maa yawoidi bei amtulidi unana tauyadi pasidi poyapoya aigoyo goi ikayaoda, tauna kunōve. Tauyadi poyapoya taiyao bei abugoyaidi. ");
INSERT INTO gvs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Kom kūna alova dedevidi kutalāidi, kumēdi, dedeoga tayamo gagaina kuyōwo kom manum. Kuyowo ikavava, sinaena kuvabodāupe go, sinaena be nakae toluye kubwadēdi. ");
INSERT INTO gvs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ego dedeogayana ana yówana ame nakae: Ana mamanao ova ana badabada 90. Ana papaeva ovayawou ovanima. Go ana tukotuko ovanima ovavasi. ");
INSERT INTO gvs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Go lupa ana tukotuko aba katugúyala. Niga ina kátava kukāu. Kukau ikavava, kikina goi ana niboda kuyāto. Go ana bósima aito, tayamo ditonema, tayamo diligaema be nakae tayamo nauyayana. ");
INSERT INTO gvs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kunōve. Yau mluwa bei aetune iwo poyapoya goi kaga liliuna neta maa yawoidi asamatedi. Tauna kaga liliuna poyapoya yatana bei sikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Go sem kom bei akanasiukoim. Kom ma monem be natumiyao monediyao taiyao dedeogayana goi bei kosowoya go, ayavemi. ");
INSERT INTO gvs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ame nakae kuguinūwe: Kaga liliuna neta maa yawoidi tamo tamo ituli ituli aiyuwo aiyuwo, bolamo tayamo, bovavina tayamo dedeogayana goi kudodōidi bei kuyavedi maa yawoidi sikaaiyaka kom taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mánuwo tamo tamo ituli ituli aiyuwo aiyuwo, bolamo tayamo be bovavina tayamo. Yoguyogu tamo tamo ituli ituli aiyuwo aiyuwo, bolamo tayamo be bovavina tayamo. Dogoiyadi sidaladala tamo tamo ituli ituli aiyuwo aiyuwo, bolamo tayamo be bovavina tayamo. Aiyuwo aiyuwo bei sima yaim kuyavedi. ");
INSERT INTO gvs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Go kom sem kūna awoinu tamo tamo maniyedi kukabīdi kumēdi dedeogayana goi kudodōidi. Moe kom mam bodao avami be nakae yoguyogu be mánuwo avadi.’ ");
INSERT INTO gvs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","E tuwo moitamo moe nakae iguinuwe. Kaga liliuna Yauwe iidigedi Nowa nakae iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","E Yauwe idigo kana, ‘Nowa, kom bogina agitem, tomota liliudi yaidi goi kom amta nuwogu ana tokibóbwata, tauna kom mam bodao dedeoga goi kosowōya. ");
INSERT INTO gvs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Yoguyogu taagonaidi ituli ituli tamo tamo bolamo ainima aiyuwo be bovavina ainima aiyuwo dedeogayana goi kudodōidi. Yoguyogu vaatabudi ituli ituli tamo tamo bolamo tayamo be bovavina tayamo dedeogayana goi kudodōidi. ");
INSERT INTO gvs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Mánuwo tamo tamo nakae, yaidi goi bolamo ainima aiyuwo bovavina ainima aiyuwo kukabīdi kudodōidi bei poyapoya goi kuyavedi, e bei poyapoyayana ana madabokina goi sisusailamna. ");
INSERT INTO gvs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Moe nakae kuguinūwe unana maliyalina ainima aiyuwo mlidi kúwana bei aetune isou iwo maliyalina poti be nakae sabamgo poti. Kaga liliuna ma yawoidi poyapoya goi boi aoodugudi bei asamatedi. Tauna yoguyogu be mánuwo kudodōidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tuwo kaga liliuna Yauwe iidigedi Nowa iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","E kina go Nowayana ana tala bogina 600 tutayana mluwa isowóduwo be poyapoya ilatao. ");
INSERT INTO gvs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tuwo moitamo kidi Nowa ma natunao be monena be nakae natunao monediyao taiyao dedeogayana goi sisowoya mluwa pasina. ");
INSERT INTO gvs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Yoguyogu tamo tamo ituli ituli, taagonaidi be vaatabudi, mánuwo tamo tamo ituli ituli be nakae kaga liliuna poyapoya goi sidaladala tamo tamo ituli ituli, ");
INSERT INTO gvs_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","aiyuwo aiyuwo, bolamo be bovavina, sima dedeoga goi sisiu sima Nowa yaina nakae Yaubada ilovina. ");
INSERT INTO gvs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tuwo maliyalina ainima aiyuwo bogina sikavava, e mluwa ima. ");
INSERT INTO gvs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","E Nowa ana tala 600 goi be tukówana aiyuwoina be maliyalina 17 goi moe isowóduwo. Amo maliyalinayana goi doelu liliudi iuwoosidi bwae gagaina poyapoya sinaena goi sikaubobóbwala be nakae yábana ikatupáeva, ");
INSERT INTO gvs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","e lótuwo isou ima poyapoya goi maliyalina 40 be nakae sabamgo 40. ");
INSERT INTO gvs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Amo maliyalinayana goi Nowa mana bodao dedeoga gagaina goi sisowoya. Moe tauyana ma monena natunao Semi, Em be Diyepeta be monediyao adi taito taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Woiwoi tamo tamo, yoguyogu tamo tamo, kaga liliuna poyapoya goi sidaladala, mánuwo tamo tamo be nakae manumánuwo tamo tamo nakae taiyao sisowoya. ");
INSERT INTO gvs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Kaga liliuna neta maa yawoidi, e aiyuwo aiyuwo sima dedeogayana goi sisowoya sima Nowa yaina. ");
INSERT INTO gvs_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Tosowoyayadi moe bolamo be bovavina nakae Yaubada bogina Nowa ilovinae. E sisowoya ikavava, dedeogayana ana totom Yauwe ikatunibode. ");
INSERT INTO gvs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","E mluwa idaudau maliyalina 40, e bwae ituko gagaina, ikaniku nakae dedeogayana iluwoi. ");
INSERT INTO gvs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Bwae ivakaigaga nakae poyapoya ana madabokina ilatao go, dedeogayana bwae yatana goi idoidoiye. ");
INSERT INTO gvs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tuwaina bwaeyana itukotuko ana kadókana koya gagaidi liliudi poyapoya ana madabokina goi nakae ilataoidi. ");
INSERT INTO gvs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bwaeyana ituko ina nakae ana tukotuko moe ovavasi koyayadi ilataoidi. ");
INSERT INTO gvs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tuwo kaga liliuna maa yawoidi poyapoya goi sikamasa kówasa. Mánuwo, yoguyogu, woiwoi, manumánuwo be tomota liliudi nakae sikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kaga liliuuna poyapoya goi sikaaiyaka maa yawoidi, e sikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tauna nakae kaga liliuna maa yawoidi poyapoya goi kina Yauwe isamatedi. Madabokidi, tomota, yoguyogu, kaga liliuna sidaladala be mánuwo isamatedi. Geya kada tayaamo ikesa geya, go sem Nowa mana bodao aditava dedeoga goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","E bwae poyapoya iilatao maliyalina ana badabada 150. ");
INSERT INTO gvs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","E Yaubada Nowa, woiwoi liliudi be yoguyogu liliudi inuwaisidi kidi dedeoga gagaina goi sikaaiyaka. Tuwo yágira ietune itowo, tauna bwae iyápasa, e isousou. ");
INSERT INTO gvs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Yaubada doelu ikaubodedi, tauna adi dau sisayata. Kúwana yábana goi nakae ikaubode, tauna kuwanayana idoideo. ");
INSERT INTO gvs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tuwo bwaeyana poyapoya goi isousou, e maliyalina 150 mlidi bwae bogina isou gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tuwo tukówana ainima aiyuwoina go, maliyalina 17 goi, e dedeogayana Ararata koyaina tayamo goi itomava. ");
INSERT INTO gvs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bwaeyana nava isousou ana kadókana tukówana yawouna go, maliyalina tayamo, e koyayadi dabadi sipóiya. ");
INSERT INTO gvs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","E maliyalina ana badabada 40 mlidi Nowa dedeogayana ana windo ikatupáeve, ");
INSERT INTO gvs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","boyoboyo tayamo ikabi, ietune ina. Tuwo boyoboyoyana iyova ina go, geya ikaluvileta, go sem iyovayova ana kadókana bwaeyana madabokina poyapoya goi iyápasa. ");
INSERT INTO gvs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","E bunabuna tayamo ikabi, windo goi ikaiyovae ina bei iyagoi bwae poyapoya goi bogina iyápasa gea geya. ");
INSERT INTO gvs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","E bunabunayana iyovayova go, bwae nava poyapoya ana madabokina iilatao, tauna geya itoboineyeta itowo. Tuwo ikaluvilamna ima dedeoga goi Nowa nimana iyosale bei bunabunayana itowo. Itowo go, Nowa ivaisiu dedeoga sinaena. ");
INSERT INTO gvs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Tuwo tauyana maliyalina ainima aiyuwo goi ituyáwata baige bunabunayana ikaiyovaemnei ina. ");
INSERT INTO gvs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ina go, lavilavi ikaluvilamna ima dedeoga goi go, oribe vagana iikatupe. E vaganayana Nowa igite, bogina iyagoi bwae bogina isou gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tuwo aiyuwoina maliyalina ainima aiyuwo goi ituyáwata baige bunabunayana ikaiyovaemnei ina go, geya ikaluvileta. ");
INSERT INTO gvs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","E Nowa ana tala ana badabada 601 go, tukówana vakuumgoina maliyalina vakuumgoina goi, e bwae poyapoya goi bogina iyápasa. E tauyana dedeoga ana kátava ikatubale, e imatavilavila, igite bwae madabokina poyapoya yatana bogina iyápasa. ");
INSERT INTO gvs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Niga tukówana aiyuwoina maliyalina 27 goi poyapoya ana madabokina bogina isayasaya. ");
INSERT INTO gvs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","E Yaubada Nowa ilatuwoko, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","‘Nowa, kom ma natumowo, monem be natumowo monediyao dedeoga gagaina goi kosōu. ");
INSERT INTO gvs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","E kaga liliuna maa yawoidi kovakedēdi sisou. Moe mánuwo liliudi, yoguyogu liliudi be kaga liliuna sidaladala. Madabokidi sisou sina poyapoya ana madabokina goi sisusáila gagaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tuwo moitamo Nowa, natunao, monena be nakae natunao monediyao dedeogayana goi sisou. ");
INSERT INTO gvs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Kaga liliuna maa yawoidi, nakae kaga liliuna sidaladala, mánuwo liliudi nakae sisou. Idi souyana goi moe yoguyogu ituli ituli. ");
INSERT INTO gvs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","E Nowa dídiya ikaudakodako, aba kasala iwodugu Yauwe ana wowoina manuna. Iwodugu ikavava, yoguyogu taagonaidi ituli ituli be mánuwo taagonaidi ituli ituli maniyedi ikabidi, aba kasalayana yatana goi ikailagasidi igabudi ivakasavedi. Moe ina vininabeso ikasale Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","E yoguyogu aiigabudi mainidi dedevina ituko ina Yauwe yaina, e maininayana inove dedevina toina, ivauyaone go, toinina inuwonúwana kana, ‘Tomota idi yalagau nuwodi goi sigoyo adi bíbina kunu goi go, tuwo tomotayadi idi guinuwa pasidi geya tuwaina bei poyapoya abugoyai. Nakae geya tuwaina bei kaga liliuna maa yawoidi amtulidi nakae ame bogina aguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Poyapoya ame ina kaiyaka madabokina goi ");
INSERT INTO gvs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","E Yaubada Nowa ma natunao ikaipakuyedi idigo kana, ‘Komi kosusāila gagaina bei tubumiyao taiyao poyapoya kovakayaodei. ");
INSERT INTO gvs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Kaga liliuna maa yawoidi poyapoya ame goi, mánuwo liliudi, kaga liliuna sidaladala poyapoya goi be iyaíyana liliudi négwasa goi bei simatoitemi gagaina go, nimami goi ayatoidi komi imi kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kaga liliuna maa yawoidi avinimi avami. Nakae boi pai avinimi avami, e nakae ame tuta kaga liliuna avinimi avami. ");
INSERT INTO gvs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","¡Go íwaya ma ikaikaidi taabu kookanīdi! Ikaikayana moe yáwana unana. ");
INSERT INTO gvs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Avatau neta tomota tayamo yawoina ikupo, Yau moitamo bei akatumapu. Yoguyogu nakae, neta tomota yawoina ikupo, bei akatumapu. Tokaumata tamo tamo bei akatumapudi. ");
INSERT INTO gvs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tomota aodugudi Yau Yaubada guna tapata, ");
INSERT INTO gvs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","E komi sem kosusāila gagaina bei tubumiyao taiyao poyapoya ana madabokina kovakayaodei.’ ");
INSERT INTO gvs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Tuwaina Yaubada kana, ");
INSERT INTO gvs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","‘Konōve. Yau komi be tubumiyao be nakae kaga liliuna maa yawoidi akanasiukoimi. ");
INSERT INTO gvs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Moe mánuwo liliudi, yoguyogu liliudi poyapoya goi sikaaiyaka be nakae dedeoga goi komi taiyao kosou. ");
INSERT INTO gvs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Akanasiukoimi ame nakae: Mluwa goi kaga liliuna maa yawoidi geya asamatemneidita. Nakae mluwa goi poyapoya geya abugoyaimneiyeta.’ ");
INSERT INTO gvs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Tuwaina Yaubada kana, ‘Guna kanasiunayana bei ikaiyako vata komi be tubumiyao be nakae kaga liliuna maa yawoidi yaimi go, ana kaba kinana avinimi. ");
INSERT INTO gvs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Aba kinanayana ame nakae: Guna kíyala gaota goi bogina ayato. Moe aba kinana komi be kaga liliuna maa yawoidi poyapoya goi bogina akanasiukoimi. ");
INSERT INTO gvs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tuta tamo tamo gaota yábana goi akaiwoduwedi go, kiyalayana nakae gaota goi isowóduwo, ");
INSERT INTO gvs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","e guna kanasíuna komi be nakae kaga liliuna maa yawoidi yaimi goi bei anuwokavate. Tauna geya tayaamo tuta tuwaina bei mluwa gagaina idau be nakae mluwa goi kaga liliuna maa yawoidi asamatedi. ");
INSERT INTO gvs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tauna tutayana kíyala gaota goi isowóduwo, bei agite, e ida kanasíuna vaatayaina anuwokavate Yau Yaubada, komi be kaga liliuna maa yawoidi yaida.’ Tuwaina Yaubada kana, ");
INSERT INTO gvs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","‘Ame aba kinanayana goi tayagoi komi be kaga liliuna maa yawoidi poyapoya ana madabokina goi Yau taiyao bogina takanasíuna.’ ");
INSERT INTO gvs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","E Nowa natunao koroto dedeoga goi sisou moe Semi, Em, Diyepeta. Em natuna koroto yoina Kenani. ");
INSERT INTO gvs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ame tauyadi adi taito moe Nowa natunaoyadi go, tauyadi yaidi nava tomota liliudi bei sisowóduwo, e poyapoya ana madabokina goi sisapa. ");
INSERT INTO gvs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","E Nowa tobágula tayamo go, oine buyalina igimibaguli. Niga oine keuwoina sisina ikabi, oine bwaena iwodugu. ");
INSERT INTO gvs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","E tuta tayamo oineyana inim ginagina, iyaluwo. Go ina yaluwoyana goi ana kwama ivalilivi, e ma paawakuna ina yoyou parai goi imasisi. ");
INSERT INTO gvs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Niga Kenani tamana Em ima yoyouyana goi isiu tamana igite ma paawakuna go, geya ivatanigoeta, go sem isowóduwo ina moetala goi senao ilatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ago kidi Semi be Diyepeta tanigo sikabi, sina yoyouyana goi sisiu go, sidumasiyasiya, unana tamadi ma pawakuna. Geya vavagidi tamadiyana sigite. E tanigoyana valavadi goi siyoisi, e mlidi goi sivamnamnae tamadi sivatum. ");
INSERT INTO gvs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Tutayana Nowa itáoya natuna Em ina guinuwa inove, tuwo gamona igoyo. ");
INSERT INTO gvs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Tauna Em natuna Kenani ikatubolate, e Yaubada yaina ikawanoi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Aiyuwoina kana, ");
INSERT INTO gvs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Diyepeta ina poyapoya Kom Yaubada kukidedēde ");
INSERT INTO gvs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","E mluwa mlina goi Nowa tala ana badabada 350 tuwaina ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tauna tauyana yawoina ana madabokina moe tala ana badabada 950, e ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ame Nowa natunao koroto Semi, Em be nakae Diyepeta adi liliu. E mluwa mlina goi tauyadi sisusáila go, natudiyao be tubudiyao ame nakae: ");
INSERT INTO gvs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Diyepeta natunao koroto ame nakae: Gomeri, Megogi, Madai, Yavani, Tubali, Mise be Tirasi. ");
INSERT INTO gvs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomeriyana tubunao koroto ame nakae: Asikenasi, Ripata be Togarama. ");
INSERT INTO gvs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavaniyana natunao koroto ame nakae: Elisa, Tasisi, da Kitim be nakae da Dodanim. ");
INSERT INTO gvs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ame tauyadi goi boda sisusáila go, négwasa kikina be nakae simla situgidagidalidi, e silokasa. Idi lokasayana goi niyadi ituli ituli, adi dala ituli ituli be nakae idi kaba lovina ituli ituli. ");
INSERT INTO gvs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Em natunao koroto ame nakae: Kosa, Itipita, Puta be Kenani. ");
INSERT INTO gvs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kosayana natunao koroto ame nakae: Seba, Abila, Sabita, Reyama be Sabataka. Reyamayana natunao koroto ame nakae: Seva be Dedani. ");
INSERT INTO gvs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E kina Kosayana tubuna koroto tayamo yoina Nimrodi. Nimrodiyana tokaalikaina tayamo poyapoya ame goi. ");
INSERT INTO gvs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yauwe matana goi Nimrodiyana tovakauko tokaalikaina. Tauna tauyana tomota adi kaba katutúkwana. Avatau neta nakae iguuinuwe tomota siyapaliye kadi, ‘Tauyana Nimrodi nakae; tauyana tovakauko tokaalikaina Yauwe matana goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","E mainao Nimrodiyana ina kaba lovina asa yoidi ame nakae: Babeli, Ereka, Akadi be nakae Kalane moe Sinari sinaena. ");
INSERT INTO gvs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Amo asayana goi ina Asiriya. Amoko goi asa yoidi Ninivei, Rekobota Ira be Kela ilokasa. ");
INSERT INTO gvs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Asa Reseni nakae ilokasa. Moe asayana gagaina go, Ninivei be Kela nauyayanaidi goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kina Itipita tubunao ame nakae: Da Luda, da Anam, da Leyaba, da Napatui, ");
INSERT INTO gvs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","da Paterusi, da Kasilue (niga ame tauyadi goi da Palisiti sisowóduwo) be da Kapatori. ");
INSERT INTO gvs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kina Kenani natunao koroto ame nakae: Saidoni botomoya be nakae siyana Eta. Niga go tubudiyao sisowóduwo idi bodao yoidi nakae. ");
INSERT INTO gvs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenani tubunao boda tamo tamo yoidi ame nakae: Da Iyebusi, da Emori, da Giragasi, ");
INSERT INTO gvs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","da Ivai, da Araki, da Sini, ");
INSERT INTO gvs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","da Aravada, da Samari be da Emati. Niga go Kenani tubunao dala tamo tamo sisapa. ");
INSERT INTO gvs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tuwo Kenani tubunaoyadi adi túwana ivatowo Saidoni goi ina Garara, moe Gasa goi. Ana papaeva nakae Sodoma, Gamora, Adima be Siboim goi ina asa Lasi goi. ");
INSERT INTO gvs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amo tauyadi Em natunao be nakae tubunao. Dala tamo tamo toinidi idi kasa sikaaiyaka, idi kaba lovina ituli ituli be nakae tamo tamo niyadi ituli ituli. ");
INSERT INTO gvs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Semi, tauyana ana gómana Diyepeta, nakae isusáila, natunao badabadaidi go, tauyana tubuna tayamo yoina Iberi. Tauyana tubunao badabadaidi. ");
INSERT INTO gvs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Semiyana natunao koroto ame nakae: Elam, Asuri, Arepakadi, Luda be Aram. ");
INSERT INTO gvs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aramyana natunao koroto ame nakae: Uso, Uli, Geteri be Mise. ");
INSERT INTO gvs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arepakadiyana natuna koroto moe Selaka. Selakayana natuna koroto moe Iberi. ");
INSERT INTO gvs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Iberiyana natunao koroto adi taiyuwo. Tayamo yoina Pelega unana amo tutayana tomota da poyapoya madabokidi sisapa, tauna yoina Pelega. Natuna aiyuwoina yoina Iyokitani. ");
INSERT INTO gvs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Iyokitaniyana natunao koroto ame nakae: Alimodadi, Selepa, Asamavete, Yaraka, ");
INSERT INTO gvs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Usali, Dikila, ");
INSERT INTO gvs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obali, Abimaeli, Seva, ");
INSERT INTO gvs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opira, Abila be Iyobabi. Ame tauyadi Iyokitani natunao koroto. ");
INSERT INTO gvs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tauyadi idi kasa Mesa ina Separi, moe bomatu dadavina. ");
INSERT INTO gvs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","E moe tauyadi Semi natunao be nakae tubunao, adi dala ituli ituli, niyadi ituli ituli, idi kaba lovina ituli ituli nakae idi kasa ituli ituli. ");
INSERT INTO gvs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","E moe tauyadi madabokidi Nowa natunao be nakae tubunao adi liliu ituli ituli goi. Boi mluwa mlina sisapa sina poyapoya ana madabokina goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","E mainao tomota liliudi da poyapoya niyadi tayamo be nakae idi bóbwara tayamo. ");
INSERT INTO gvs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","E tutayana tomota situliya sina bomatu dadavina, dúmiya gagaina Sinari goi sibabane. Tuwo amoko goi silokasa. ");
INSERT INTO gvs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Silokasa, sidigo kadi, ‘Tawou, vaega taodugudi paaevaidi be kalabadaabadaidi. Ikavava, tagabudi sikasa.’ Tuwo moitamo nakae siguinuwe. ¡Kidi amo dadavayana goi gurewa paaevaidi geya, tauna adi vaboda moe vaega aiigabudi! ¡Kidi simenti geya, tauna adi bwada moe taa! ");
INSERT INTO gvs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Vaega aiigabudi siwodugudi ikavava, sidigo kadi, ‘Tawou, vaega aigabudiyadi takabīdi, tavapopōidi ida vada taodugūdi asa vau manuna go, vada tayamo maanawena taodūgu ituko ina be ana saku moe yábana goi, e bei yoida gagaina. Nakae taguinūwe, govila bei tasapa.’ ");
INSERT INTO gvs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","E Yauwe isou ima asayana be nakae vadayana maanawena tomota siiwodugu igitedi. ");
INSERT INTO gvs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Igitedi, idigo kana, ‘¡Iyaa! ¿Kaga tuwaina bei siguinuwe? Tauyadi boda tayamo be nakae niyadi tayamo. Tauna neta ame vadayana silukavave, e kaga neta latuwodi, itoboinedi siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tawou, tasōu niyadi takinigonigōe; tamo tamo niyadi ituli ituli, e bei geya itoboinedita sediyao niyadi siyagoi.’ ");
INSERT INTO gvs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tuwo moitamo Yauwe ikausapesapedi poyapoya liliuna goi, e idi vada be idi kasa geya silukavavedita. ");
INSERT INTO gvs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","E amoko goi tomota liliudi niyadi kina Yauwe ikinigonigoe nakae tomota liliudi ikausapesapedi, tauna moe pasina amo asayana sivayou Babeli. ");
INSERT INTO gvs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ame Semi tubunao adi liliu. Tala ana badabada aiyuwo mluwa mlina, tutayana Semi ana tala ana badabada 100 natuna koroto Arepakadi ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arepakadi ana bíbina mlina, Semiyana ikaaiyaka tala ana badabada 500 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","E Arepakadiyana ana tala ana badabada 35 tutayana natuna koroto Selaka ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selaka ana bíbina mlina, Arepakadiyana ikaaiyaka tala ana badabada 403 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","E Selakayana ana tala ana badabada 30 tutayana natuna koroto Iberi ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Iberi ana bíbina mlina, Selakayana ikaaiyaka tala ana badabada 403 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","E Iberiyana ana tala ana badabada 34 tutayana natuna koroto Pelega ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelega ana bíbina mlina, Iberiyana ikaaiyaka tala ana badabada 430 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","E Pelegayana ana tala ana badabada 30 tutayana natuna koroto Reu ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu ana bíbina mlina, Pelegayana ikaaiyaka tala ana badabada 209 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","E Reuyana ana tala ana badabada 32 tutayana natuna koroto Seruga ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruga ana bíbina mlina, Reuyana ikaaiyaka tala ana badabada 207 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","E Serugayana ana tala ana badabada 30 tutayana natuna koroto Nakori ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nakori ana bíbina mlina, Serugayana ikaaiyaka tala ana badabada 200 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","E Nakoriyana ana tala ana badabada 29 tutayana natuna koroto Tera ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Tera ana bíbina mlina, Nakoriyana ikaaiyaka tala ana badabada 119 tuwaina. Ego amo talayadi goi natunao koroto be vevina liliudi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","E Terayana ana tala ana badabada 70 tutayana natunao koroto Eberam, Nakori be Arani sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","E ame Tera tubunao tetelidi. Tetalayana ame nakae: E kina go Terayana natunao yoidi Eberam, Nakori, Arani. E kina go Arani natuna yoina Loti. ");
INSERT INTO gvs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Araniyana ina kasa yoina Ura moe Babiloniya dadavina. Amoko goi tamana Tera nava maa yawoina go, Araniyana ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","E kina Eberam inai, monena yoina Serai. Nakori inai monena yoina Milika, tauyana Arani natuna. Ego Arani natuna aitonina yoina Isika. ");
INSERT INTO gvs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ago kina Serai ikágala, tauna Eberam be Serai geya natudimo. ");
INSERT INTO gvs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tuwo Tera itáoya, natuna Eberam be tubuna Loti (moe Arani natuna) be nakae yaona Serai ikabidi idi kasa Ura Babiloniya sinaena sikalave, bego taiyao sina Kenani go, tutayana sinonoina, sina asa Karani goi silokasa, e geya sinoita Kenani goi. ");
INSERT INTO gvs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","E Tera yawoina ana madabokina moe tala ana badabada 205, e asa Karani goi ikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","E boi Eberam nava Ura goi ikaaiyaka go, Yauwe iduduwe idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Bei akisailim, ");
INSERT INTO gvs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Avatauwa neta sikaipakuyem, ");
INSERT INTO gvs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","E tauna tutayana Eberam ana tala 75, e ina nakae Yauwe boi bogina ilatuwoko. Monena Serai be ana gómana natuna Loti be nakae konana liliudi be ina pakonayao asa Karani goi bogina ikabidi, e taiyao sitáoya, Karaniyana sikalave go, sina asa Kenani. Tutayana sisowóduwo Kenani dadavina goi, ");
INSERT INTO gvs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","e Eberam kidi sisiu sina asa Sekem goi. Amoko goi More alovaina gagaina goi situnagu. Amo tutayana da Kenani asa amo goi nava sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","E amoko goi Yauwe isowóduwo Eberam yaina idigo kana, ‘Eberam, ame asayana bei im boda avinidi.’ Tuwo dídiya ikabidi, ikaudakodako, aba kasala imadagi Yauwe ana kaba wowoina manuna. ");
INSERT INTO gvs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Niga Eberam kidi sitáoya, sina koya tayamo goi idi yoyou parai siyowo situnagu. Koyayana koiboga dadavina goi asa Beteli ikaaiyaka go, bomatu dadavina goi asa Ai ikaaiyaka. E amoko goi aiyuwoina Eberam dídiya ikaudakodako, aba kasala imadagi Yauwe ana kaba wowoina manuna, e Tauyana yaina isaakululu. ");
INSERT INTO gvs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","E niga sitáoya situliya sina Negevi, moe Kenani sinaena go, youya dadavina. ");
INSERT INTO gvs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Sikaiyaka aaa, e Kenani goi loga isowóduwo. Logayana gagaina, tauna Eberam kidi sitáoya sina Itipita goi bego sisuvadavada; loga ana kaba lukavava situyaosi. ");
INSERT INTO gvs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ego tutayana Itipita goi sivakakana, e monena ilatuwoko idigo kana, ‘Serai, kunōve. Kom vavina gumaboim. ");
INSERT INTO gvs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tutayana Itipita korotoidi sigitem, bei sinuwonúwana kadi, “Ame vavinayana Eberam monena.” Tuwo bei sikaumategu go, kom sem maa yawoim sikabim. ");
INSERT INTO gvs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tuwo monegu, akawanoi yaim kulatuwokōidi bego yau nium, e bei kom pasim kaga liliuna idedevina yaigu, tauna sitagonegu maa yawoigu akaaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","E tuwo moitamo tutayana Itipita goi sisiu, Itipita korotoidi sikandobala Serai sigite idi nuwonúwana kadi, ‘Amo vavinayana gumaboina toina.’ ");
INSERT INTO gvs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","E Pero ina topaisewayao adi tovakumgoyao maniyedi sikandobala Serai sigite, tuwo sina Pero silatuwoko sidigo kadi, ‘Ima tomoya, vavina tayamo kagite, tauyana gumaboina toina.’ Tuwo Pero ina lovina goi sina Serai sikabi sime Pero ina vada goi. Idi nuwonúwana bego Serai moe Eberam niuna. ");
INSERT INTO gvs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","E Serai pasina Eberamyana ana dedevina ibabane. Sipi, bulumakau, ase bolamo, paakonidi koroto be vevina, ase bovavina, be nakae kameri ikabidi, madabokidi Pero ivini. ");
INSERT INTO gvs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","E kina Yauwe igitedi, tuwo Pero mana bodayáuwo vísiya gagaidi ivinidi Eberam monena Serai pasina. ");
INSERT INTO gvs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","E Peroyana inuwonúwana kana, ‘¡Ame vavinayana geya Eberam niuna geya, go sem monena!’ Tuwo Eberam iduduwe ima idigo kana, ‘¡Eberam, ame kaga kuguinuwe yau yaigu! ¡Kaga unana geya kulatuwokoiguta bego Serai monem! ");
INSERT INTO gvs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","¡Kaga unana kam, “Serai niugu”! ¡Kaga unana kutagona vavinayana akabi bego monegu! Tuwo. ¡Monem kwābi kunāve!’ ");
INSERT INTO gvs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","E Peroyana ina topaisewayao ilatuwokoidi idigo kana, ‘Eberam kidi konavēdi kovalilivēdi bei Itipita sikalave.’ Tuwo Eberam ma monena be nakae ma konana madabokidi asa sikalave. ");
INSERT INTO gvs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","E Eberam ma monena, ina bodao liliudi be Loti taiyao sitáoya, Itipita sikalave go, sikaluvilamna sina Negevi dadavina. ");
INSERT INTO gvs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ego Eberam bogina iguyau; ina esaesa moe yoguyogu bulumakau, sipi, goti, siriba be goura. ");
INSERT INTO gvs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","E tauyadi sina Negevi go, geya sikaiyaketa, go sem situliya sinonoina bego Beteli. Sina Beteli goi go, sina asayana boi Beteli be Ai nauyayanaidi goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Amo asayana goi Eberam boi mainao dídiya igimikaudakodako aba kasala imadagi. E amoko goi Yauwe yaina isakululu. ");
INSERT INTO gvs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","E tutayana Loti Eberam taiyao siituliya go, Lotiyana nakae ina sipiyao, ina gotiyao, ina bulumakauyao be ina yoyou parai badabadaidi. ");
INSERT INTO gvs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Tuwo poyapoya geya itoboineyeta Eberam be Loti idi yoguyoguyao taiyao sikaaiyaka unana idi yoguyoguyao badabada sisaki, tauna tauyadi geya itoboinedita taiyao sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Tuwo Loti be Eberam idi yoguyoguyao adi tomatakavatayao taiyao sikaumakimaki. (Amo tutayana da Kenani be nakae da Perisi asayana goi nava sikaaiyaka.) ");
INSERT INTO gvs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","E idi sipi adi tomatakavatayao taiyao sikaumakimaki, tuwo Eberam Loti ilatuwoko idigo kana, ‘Loti, kom yau boda tayamo, tauna kom be yau geya itoboinedeta takaumakimaki, nakae kom im topaisewayao be yau guna topaisewayao geya itoboinedita sikaumakimaki. ");
INSERT INTO gvs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tuwo kom yau tatumasāba. Poyapoya ana madabokina matam goi ikaaiyaka. Kom toinim kulovīna. Neta kom latuwom bomatu dadavina, yau ana koiboga dadavina go, neta kom latuwom koiboga dadavina, e yau ana bomatu dadavina.’ ");
INSERT INTO gvs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tuwo Lotiyana imatavilavila Iyoridani butumina madabokina igite poyapoya dedevina, nuugusina. (Amo tutayana Yauwe Sodoma be Gamora nava geya imtulidita.) Poyapoyayana ana kaigigita Yauwe ina tánuwo o nakae Itipita ina Sowa poyapoyaidi nakae. ");
INSERT INTO gvs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","E Lotiyana imatavilavila go, idigo kana, ‘Latuwogu bomatu dadavina, moe Iyoridani butumina.’ Tuwo moitamo itáoya ina bomatu dadavina. Moeko goi Eberam be Loti situmasaba. ");
INSERT INTO gvs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","E kina go Eberamyana Kenani goi ilokasa go, kina Lotiyana ina asa Iyoridani butumina goi Sodoma kikina ilokasa. ");
INSERT INTO gvs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ego kidi da Sodomayadi totapepeko toidi Yauwe matana goi. ");
INSERT INTO gvs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","E kina go Yauweyana Loti be Eberam idi tumasaba mlina Eberam ilatuwoko idigo kana, ‘Eberam, moeko goi kuutāoya kumatavilavīla. Yawéyana, youya, bomatu be koiboga goi poyapoya ana madabokina kugīte. ");
INSERT INTO gvs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Guna nuwonúwana bego ava poyapoyava itoboinem kugite, madabokina kom be nakae im boda bei avinimi be ikaiyako vata yaimi. ");
INSERT INTO gvs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","¡Im boda bei akisailidi badabadaaidi! Nakae geya vatau tayaamo itoboine ikatuyaividi. ");
INSERT INTO gvs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Poyapoyayana bei avinim. Tauna kutāoya kūna madabokina goi kuvabebēo.’ ");
INSERT INTO gvs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","E tuwo Eberam itáoya, ina yoyou parai ikabidi, ina Ebironi goi go, Mamre ina kalova gagaidi kikina goi ilokasa. Amoko goi dídiya ikaudakodako aba kasala imadagi bego Yauwe yaina isakululu. ");
INSERT INTO gvs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","E tutayana da Sinari adi tolovina Amrapeli, da Elasa adi tolovina Ariyoki, da Elam adi tolovina Kedolaomera be da Goim adi tolovina Tidali siilovina, e tolovinayadi adi taivasi madi tovayaviyayao silamgógana yaviya manuna. ");
INSERT INTO gvs_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Silamgógana, sideli sina bego sivayaviya tolovina adi tainima taiyao. Tauyadi moe da Sodoma adi tolovina Bera, da Gamora adi tolovina Bisa, da Adima adi tolovina Sinabi, da Siboim adi tolovina Semibera be nakae da Bela adi tolovina. Belayana youyuwoina Sowa. ");
INSERT INTO gvs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ame tolovinayadi adi tainima sima Sidim butumina goi taiyao sispwagógana yaviya manuna. (Ego niga baige butumayana goi otoku yoina Négwasa Negonegosina isowóduwo.) ");
INSERT INTO gvs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ego idi yaviyayana unana ame: Tala ana badabada yawou aiyuwo goi Kedolaomera tolovina adi tainima ilovinaedi go, ina lovina yaidi igoyo. Tuwo ina lovinayana kidi tolovina adi tainima bogina ilausidi. Tauna tala yawou aitonina goi sitáoya bego ina lovina sikapipilave. ");
INSERT INTO gvs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","E tala yawou aivasina goi, kidi Kedolaomera tolovina adi taivasi taiyao silamgógana go, idi kasa sikalavedi sinonoina Sidim butumina. Sinonoina, e asa Asatarota Karanaim goi sisowóduwo, e todukeketayao sikaumatedi. Ikavava, sina asa Em goi Susim tubunao sikaumatedi. Ikavava, sina asa Sava Kirayataim goi Emim tubunao sikaumatedi. ");
INSERT INTO gvs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Niga sina Koya Seira goi Kori tubunao sikaumatedi. Ikavava, sina Eli Parani yoyowo goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Niga sina Eni Misipata goi moe youyuwoina Kadesi, e Amaleki tubunao sikaumatedi. Ikavava, sina Esasoni Temari goi Emori tubunao sikaumatedi. ");
INSERT INTO gvs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","E amo tutayana kidi tolovinayadi adi tainima bogina silamgógana go, madi tovayaviyayao sideli sima Sidim butumina goi sitáoya bego sivayaviya ");
INSERT INTO gvs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kidi Kedolaomera taiyao. Tauna tolovina adi taivasi madi tovayaviyayao go, adi kaleyayao tolovina adi tainima madi tovayaviyayao. ");
INSERT INTO gvs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","E kidi Kedolaomera sitogaga, tauna kidi da Sodoma be da Gamora bego sisiya. Ego Sidim butumina goi bobosiu sikaaiyaka go, sépwala potapotaina ilataoidi. Tauna tutayana da Sodoma be da Gamora idi tovayaviyayao sisiya, koroto maniyedi sisou bobosiuyadi sinaedi goi go, maniyedi sisiya sina koya goi. ");
INSERT INTO gvs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sisiya go, kidi Kedolaomera sitogaga, tuwo sina da Sodoma be da Gamora idi kasa goi konadi be avadi madabokidi sivainaoidi. ");
INSERT INTO gvs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","E Eberam ana gómana natuna Loti nakae siyoisi bego ma konana sinavedi idi kasa goi. Bogina kuyagoi. Tauyana nava Sodoma goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Sinavedi go, koroto tayamo isiya ima Eberam, tauyana Iberiu, ilatuwoko idigo kana, ‘Eberam, Kedolaomera ma senao sina Sodoma tomota silauidi go, am gómana natuna Loti siyoisi, sinave.’ Ego amo tutayana Eberam ikaaiyaka koroto tayamo yoina Mamre ina kalova gagaidi goi. Mamreyana Emori tubuna go, senao Esikoli be Aneri. Ago adi taito Eberam taiyao silamgógana; latuwodi Kedolaomera ma senao idi tovayaviyayao sivatapiyedi. ");
INSERT INTO gvs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","E livalayana Eberam inove, ina koroto adi badabada 318 iduduwedi sima. Tauyadi tovayaviya katubaayasidi go, moe Eberam ina tunagu goi sibíbina, tauna inumisedi. E iduduwedi sima, taiyao sina asa yoina Dani goi bego Loti ana toyoitayao sivatapiyedi. ");
INSERT INTO gvs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Sina Dani goi go, sabamgo goi Eberam ina tovayaviyayaoyadi, moe ina pakonayao, iwotaidi sina Kedolaomera ma senao idi tovayaviyayao silauidi, sivatapiyedi. Tuwo kidi Kedolaomera sisiya sina yawéyana Damasiko goi siseivata sina asa yoina Koba. ");
INSERT INTO gvs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Tauna kaga liliuna tauyadi siyoisidi, e kidi Eberam sikabimneidi. E nakae ana gómana natuna Loti ma konana be nakae tomota liliudi sikabimneidi. ");
INSERT INTO gvs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","E Eberam Kedolaomera ina tovayaviyayao be senao idi tovayaviyayao ilauidi ikavava, ikaluvila ina ina kasa. Inonoina, Sava Butumina goi Sodoma adi tolovina ima ivalobode. Savayana ana yagoina moe Tokalibúbuna Butumina. ");
INSERT INTO gvs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","E kina go da Salema adi tokalibúbuna yoina Melikisedeki ima go, beredi be oine bwaena imedi. Tauyana Yaubada Tokanayatanatoina ana Tonúwala. ");
INSERT INTO gvs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tauyana ima Eberam ikaipakuye idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","¡Yaubadayana aba yapali! Am kaleyayao goi iyavem be nimam goi iyatoidi.’ E tuwo Eberam ana kaleyayao konadi liliudi bogina ikabidi iwotaidi kiwota yawou go, Melikisedeki yawóuna ivini. ");
INSERT INTO gvs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ivini ikavava, e da Sodoma adi tolovina idigo kana, ‘Eberam, kónana kom toinim kwabīdi go, tomota boi siyooisidi yau kuvinīgu.’ ");
INSERT INTO gvs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","E kina Eberamyana idigo kana, ‘Akatótula Yauwe Yaubada Tokanayatanatoina matana goi, Tauyana yábana be poyapoya adi tomadágina. ");
INSERT INTO gvs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Guna katotulayana ame nakae: Geya kada tayaamo konam bei akabi geya. Neta gagaina o giyaina, geya akabiyeta, govila kom kam, “Yau pasigu Eberam iguyau.” ");
INSERT INTO gvs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tauna konam geya akabidita, go sem kaga liliuna guna tovayaviyayao bogina sikáika, moe bogina. Ago tauyadi Aneri, Esikoli be Mamre yaviya goi sivaitegu, tauna kutagonēdi adi kaiguyau sikabidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","E amo dogoiyadi sikavava, Eberam ikalayáusa go, ina kalayausayana goi Yauwe ina livala ima idigo kana, ‘Eberam, taabu kuumatōita. Yau am lowo bei amatakavatem be nakae am tovaiwówana, e am vaiwówana gagaina toina bei avinim.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Go kina Eberamyana idigo kana, ‘¡Yauwe guna Tomoya, yau bei geya natugumo akámasa go! ¿Tauna kaga ana dedevina neta kónana kuvinigu? Yau guna katumapu moe guna pákwana Eliyesa guma Damasiko.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Tuwaina Eberamyana kana, ‘Yau geya tayaamo boda kuvinigu, tauna kunōve. Tutayana akámasa, guna katumapuyana moe koroto guna pákwana, e amo tauyana konagu madabokidi bei ikabidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","E moeko goi kina Yauweyana ina livala aiyuwoina ina Eberam yaina idigo kana, ‘Amo tauyana bei geya im katumapu geya, go sem kom natum toinim wowom goi bei isowóduwo, e moe tauyana bei im katumapu.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","E tuwo Eberam ikabi ivakede sisowóduwo moetala goi, idigo kana, ‘Eberam, kwandolāga yábana kugīte be utuna kwatuyaivīdi. ¡Aa, neta itoboinem kwatuyaividi!’ Tuwo ikatótula idigo kana, ‘E im boda adi badabada bei nakae.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eberam inumisa Yauwe yaina, e ina numisayana Yauwe igite, ikamoitamoe bego kina Eberamyana moe tokibóbwata. ");
INSERT INTO gvs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","E aiyuwoina Yauwe idigo kana, ‘Yau Yauwe, boi im kasa Ura Babiloniya sinaena akabim amem go, poyapoya ame bei avinim im kaba lovina.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Go kina Eberam idigo kana, ‘¿Go Yauwe guna Tomoya, manakaegu bei ayagoi poyapoya ame moitamo yau toinigu guna poyapoya?’ ");
INSERT INTO gvs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","E Yauwe idigo kana, ‘Kūna bulumakau bovavina tayamo, goti bovavina tayamo, sipi bolamo tayamo, tamo tamo adi tala aito, bolitutu be nakae bunabuna manuwoyaula kwabīdi kumēdi.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tuwo moitamo ina yoguyoguyadi ikabidi imedi Yauwe yaina go, ikaumatedi. Ikaumatedi ikavava, iboboyuwedi, dadava dadava iyatoidi. Ago mánuwo geya iboboidita. ");
INSERT INTO gvs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Iyatoidi ikavava, mánuwo gagaidi sisou sima bego yoguyoguyadi sakavaidi sikabidi sikanidi go, kina Eberam ivatapiyedi. ");
INSERT INTO gvs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","E níyala isousou go, Eberam wowona ikamou imasisi, ikanamatáiya. E kokonótuya gagaina isowóduwo ivatum, tauna imatoita gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","E Yauwe ikatuwoini idigo kana, ‘Eberam, ame kuyagoidōko: Tubumowo bei ituli ta boda idi poyapoya goi simalatonikasa. Ago niga kidi toni kasa bei tubumowoyadi sipakoidi, e tala ana badabada 400 goi siyogedeegededi. ");
INSERT INTO gvs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ago amo bodayadi siipakoidi bei atakinoidi liuna manuna. Atakinoidi ikavava, tubumowoyadi bei sisowóduwo go, tutayana asayana sikalave, kónana badabadaidi bei sikabidi sinavedi. ");
INSERT INTO gvs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","E kom go bei kwaitomoya toina namliyeta baige kukámasa, e kuna tamam be tubumowo yaidi goi go, mam tuboina kukámasa, e tomota sivaliwogem. ");
INSERT INTO gvs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","E kidi go im bodaoyadi, e tala 400 sikavava, bei sikaluvilamna sima ameko goi go, mainao sieogaoga ituli ta kasa goi. Moitamo. Kidi Emori tubunao ameko goi sikaaiyaka ana kadókana idi goyo nakae itoboinedi adi liuna sibabane namliyeta bei avatapiyedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","E níyala isaliu, e bogina ikamamaníwana go, Eberam ikandobala igite vaega tayamo isowóduwo. Vaegayana tobuna goi aubowo itukotuko be nakae dúgala ininínima, e yoguyogu boboyuwoidi talaidi nauyayanaidi goi sinonoina. ");
INSERT INTO gvs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","E amo maliyalinayana goi Yauwe ikanasíuna Eberam yaina idigo kana, ‘Eberam, akatótula bego im boda poyapoya ame bei avinidi. Poyapoyayana ana túwana ame nakae: Itipita ina sákala gagaina Yuparetisi. ");
INSERT INTO gvs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keini tubunao idi poyapoya, Kenisi tubunao idi poyapoya, Kadamoni tubunao idi poyapoya, ");
INSERT INTO gvs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Eta tubunao idi poyapoya, Perisi tubunao idi poyapoya, todukeketayao idi poyapoya, ");
INSERT INTO gvs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Emori tubunao idi poyapoya, Kenani tubunao idi poyapoya, Giragasi tubunao idi poyapoya be nakae Iyebusi tubunao idi poyapoya.’ ");
INSERT INTO gvs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","E kina go Eberam monena Serai nava geya ivenatuneta go, tauyana mana pákwana tayamo Itipita vavinaina yoina Ega. ");
INSERT INTO gvs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tuwo ina Eberam ilatuwoko idigo kana, ‘Monegu, Yauwe guna venátuna ivagagale, tauna guna pákwana kwābi, taiyao komasīsi. Nakona tauyana manugu bei ivenátuna, e natuna yau natugu.’ Tuwo moitamo Eberam iguinuwe nakae Serai idige. ");
INSERT INTO gvs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Eberam bogina tala ana badabada yawou Kenani goi ikaaiyaka, e Serai ina pákwana Ega guma Itipita ikabi, Eberam ivamonene. ");
INSERT INTO gvs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","E Eberam Ega taiyao simasisi, e ikéuwama. Ago tutayana ina kéuwama ilotowo, e ina towosi Serai ivasobusobuye. ");
INSERT INTO gvs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Tuwo Seraiyana ina Eberam ilatuwoko idigo kana, ‘Monegu, kom im puwoya, tauna agu mou ababane. Yau guna pákwana avinim go, tutayana iyagoi bego ikéuwama, ivasobusobuyegu. ¡Neta Yauwe itakinōida! ¿Avatau ibágala, kom geya yau?’ ");
INSERT INTO gvs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Go kina Eberamyana idigo kana, ‘Gwa. Kom im pakwanayana nimam goi ayato. Kaga latuwom, nakae kuguinūwe yaina.’ Tuwo Serai ina pákwana Ega iyogedegede, tauna isiya ina yoyowo goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Isiya ina doelu tayamo asa Sura kenaoina goi ikaaiyaka. Go Yauwe ina anerose tayamo ima amoko goi Egayana ibabane. ");
INSERT INTO gvs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ibabane, e idigo kana, ‘¿Ega, Serai ina pákwana, nako kuma? ¿Bei nako kuna?’ ‘Guna towosi Serai matana goi asiya’, Egayana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yauwe ina aneroseyana idigo kana, ‘Kwaluvīla kūna am towosi goi kukasalēm tauyana yaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Tuwaina aneroseyana kana, ‘Bei tubumowo akisailidi, e adi badabada geya itoboinemta kwatuyaividi.’ ");
INSERT INTO gvs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tuwaina idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tauyana bei ikaaiyaka woiwoi nakae. ");
INSERT INTO gvs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tuwo Egayana idigo kana, ‘¡Iyaa! Yauwe bogina agite go, geya akamaseta.’ Tuwo Yauwe ivayoko Yaubada Togita. ");
INSERT INTO gvs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Moe pasina doeluyana asa Kadesi be Bereda nauyayanaidi goi tomota sivayou Bera Lakai Roi. ");
INSERT INTO gvs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","E tuwo Ega ivenátuna, natuna koroto. Moe Eberam natuna, e ivayou Isimaeli. ");
INSERT INTO gvs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","E kina go Eberamyana ana tala ana badabada 86 tutayana Ega natudi Isimaeli ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tuwo Eberam ikaiyaka aaa, ana tala 99 ibabane, e Yauwe isowóduwo yaina, idigo kana, ‘Yau Yaubada Tokalika. Im ketoiya madabokina goi kwabikaonēgu go, tuta liliuna im guinuwa goi geya am pikwanāmo. ");
INSERT INTO gvs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Bei akanasiukoim be nakae akisailim gagaina, tubumowo badabadaidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Tuwo Eberamyana ivatugúyala ikanakabobo go, Yaubada idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","‘Kunōve. Yau guna kanasiunayana yaim ame nakae: Akatótula bego kom bei boda badabadaidi tubudi. ");
INSERT INTO gvs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Tauna geya tuwaina yoim Eberam, go sem bogina avayokoim kom bei boda badabadaidi tubudi, tauna yoim vau moe Eberamo. ");
INSERT INTO gvs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Bei akisailim gagaina, e bei kom goi boda badabadaidi sisowóduwo nakae kom tubumowo goi tokalibúbuna maniyedi bei sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Guna kanasiunayana akamoitamoe bego ikaiyako vata kom ma natumowo nakae tubumowo be yau yaida. Yau Yaubada yaimi go, nava bei Yau Yaubada tubumowo nakae yaidi. ");
INSERT INTO gvs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kenani goi kom tuta ame kueogaoga go, nava bei poyapoya ana madabokina Kenani goi kom nakae tubumowo avinimi, e bei ikaiyako vata yaimi. Yau bei tubumowo idi Yaubada.’ ");
INSERT INTO gvs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Aiyuwoina Yaubada idigo kana, ‘Kom sem guna kanasiunayana kumatakavāte. Tubumowo mlim goi simamaima nakae simataakavāte. ");
INSERT INTO gvs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Guna kanasíuna ana kaba kinana ame bei komatakavāte: Kom be nakae koroto madabokimi yaimi sakavaimi kokupōidi. Nava tubumowo koroto nakae latuwogu sakavaidi sikupoidi. ");
INSERT INTO gvs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Sakava ana kupwanayana moe aba kinana kom be Yau yaida bego bogina akanasiukoim. ");
INSERT INTO gvs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","E ame tuta nakae tuta simamaima ava gómana koroto ibíbina yaim goi, neta ana maliyalina ainima aito bogina ibabanedi, e sakavaina kukūpo. Nakona im vada goi ibíbina o tauyana paakonina ogaoga goi kugimone, tauyana sakavaina kukūpo. Ame aba kinana yaida bego akanasiukovataem. ");
INSERT INTO gvs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ago ava koroto neta sakavaina geya ikupoeta, tauyana geya guna boda, tauna yaimi goi kulivisīye be kuvatapīye. Tauyana guna kanasíuna ana lovina bogina ikapipilave.’ ");
INSERT INTO gvs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","E tuwaina Yaubada idigo kana, ‘Eberamo, geya tuwaina monem kududūwe Serai, go sem kududūwe Sera. ");
INSERT INTO gvs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Bei akaipakuye, e bei tauyana goi natum koroto avinim. Aiyuwoina akaipakuye bei tubunao goi boda badabadaidi sisowóduwo go, bodayadi tubudi moe tauyana. Ago tubunao goi tokalibúbuna maniyedi bei sisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Tuwo Eberamo aena ivatugúyala ikanakabobo go, ivanama; ina nuwonúwana kana, ‘Yau guna tala 100 go, Sera ana tala 99. ¿Manakae? ¿Itoboinema kavenátuna?’ ");
INSERT INTO gvs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Go tauyana Yaubada ilatuwoko idigo kana, ‘¡Neta im kaipaku isowóduwo natugu Isimaeli goi! Sera ikágala, tauna kaga liliuna kukaatotule yau yaigu, nakona natugu Isimaeli yaina kuguinuwe.’ ");
INSERT INTO gvs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Go kina Yaubada idigo kana, ‘Tauyana geya, go sem monem Sera bei ivenátuna, natuna koroto go, bei kuvayou Aisake. Tauyana be nakae tubunao bei akanasiukoidi go, anasiunayana bei ikaiyako vata yaidi. ");
INSERT INTO gvs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","E kina go Isimaeli manuna, im kawanoi bogina anove, tauna kunōve. Moitamo tauyana nakae bei akaipakuye. Bei akisaili gagaina, e natunao badabadaidi. Nakae natunao be tubunao akisailidi, e badabadaidi sisowóduwo. Tauyana natunao koroto adi badabada yawou aiyuwo go, tauyadi tokalibúbuna. Niga be tubunao moe boda tayamo gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Go tala tayamo ikavava, Sera bei ivenátuna, natumi Aisake go, niga bei Aisakeyana akanasiuko.’ ");
INSERT INTO gvs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","E Yaubada ibóbwara ikavava, Eberamo ikalave go, ituko. ");
INSERT INTO gvs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","E tuwo Eberamo itáoya ina natuna Isimaeli be koroto madabokidi neta ina vada goi sibíbina be nakae ina pakonayao boi ina mani goi igiimonedi ikabidi, e ame maliyalinayana goi madabokidi sakavaidi ikupoidi nakae Yaubada idige. ");
INSERT INTO gvs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ego Eberamo ana tala ana badabada 99 tutayana sakavaina ana kúpwana ibabane. ");
INSERT INTO gvs_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Natuna Isimaeli ana tala ana badabada 13 tutayana sakavaina ana kúpwana ibabane. ");
INSERT INTO gvs_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ame maliyalinayana goi Eberamo be natuna Isimaeli sakavaidi sikupoidi. ");
INSERT INTO gvs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Koroto madabokidi ina vada goi, nakona ina vada goi sibíbina o nakona ogaoga goi paakonidi igimonedi, madabokidi nakae sakavaidi adi kúpwana sibabane. ");
INSERT INTO gvs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","E tuwo Eberamo nava asa Mamre alovaina gagaidi goi ikaaiyaka. Go tuta tayamo dine goi ituwodo ina yoyou parai totomna goi itusobu ikaaiyaka. Ikaaiyaka, e Yauwe isowóduwo tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","E Eberamoyana ikandobala koroto adi taito igitedi sitatáoya. Igitedi, ina yoyou parai totomna goi isowóduwo, woilina ibala ina ikauyagu yaidi goi, e ivatugúyala, ikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Tuwo idigo kana, ‘Guna tomoya, neta kuusosale, geya kunoita, go sem yau im pákwana taiyao takaiyāka. ");
INSERT INTO gvs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Kutagōna bego guna pákwana ina bwae itege ime aemi adi níkina manuna. Ikavava, ameko alova unana goi kowaiwasi ");
INSERT INTO gvs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","go, avami giyaina akabi, avinimi kokáika bei togaga kobabane imi koidádana manuna. Komi bogina kowowoinegu unana koma yau imi pákwana guna vada, tauna latuwogu bego avaitemi.’ E kidi sitagona kadi, ‘Uyama. Moe dedevina; nakae kuguinūwe.’ ");
INSERT INTO gvs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tuwo Eberamo woilina ina ina yoyou parai goi isiu, Sera ilatuwoko idigo kana, ‘Sera, woilīm kūna im parawa dedevina kukābi kūme beredi kugābu.’ ");
INSERT INTO gvs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ilatuwoko ikavava, Eberamo ilokoina ina tayamo bulumakau bonatuna dedevina ikabi, ikaumate. Ikaumate ikavava, ina pákwana ivini. Tauyana ikabi ina ivaipolu. ");
INSERT INTO gvs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ivaipolu ikavava, Eberamo itáoya, bonatunayana ikabi, koroto adi taito ivinidi. Nakae bulumakau nununa itege ivinidi sinim be nakae nununayana maniyena ikule ivinidi. Tauyadi sikakáika go, Eberamoyana kikidi alova unana goi itatáoya. ");
INSERT INTO gvs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","E kidi korotoyadi sidigo kadi, ‘¿Go monem Sera nakoina?’ ‘Amoni yoyou sinaena’, Eberamo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tuwo sinaedi goi tayamo idigo kana, ‘Tukówana ainima aivasi nakae sikavava, moitamo bei akaluvila go, kunōve. Monem Serayana bogina bei ivenátuna, natuna koroto.’ E kina go Serayana yoyou ana niboda mlina goi ikaaiyaka itaaiyakeka. ");
INSERT INTO gvs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ego kina Eberamo bogina ikaitomoya; kina Sera nakae bogina ikainamoya. Tauna geya itoboineyeta ivenátuna unana bogina itobuvavina. ");
INSERT INTO gvs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","E tuwo Yauwe ina livala inove, tauna ivanama; ina nuwonúwana kana, ‘¡Ii, yau bogina akainamoya go! ¿Monegu nakae ikaitomoya go, manakae? ¿Masisi ana uyáwana bei alotowomnei?’ ");
INSERT INTO gvs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Go kina Yauwe idigo kana, ‘¿Kaga unana Sera ivanama? ¿Kaga unana idigo kana, “Yau bogina akainamoya, bei moitamo avenátuna”? ");
INSERT INTO gvs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Geya kada kaga tayaamo imou Yau Yauwe yaigu. Moitamo guna upa bogina ayato bei akaluvila moe tukówana ainima aivasi sikavava nakae go, Sera bogina bei ivenátuna, natuna koroto.’ ");
INSERT INTO gvs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","E Serayana imatoita, tauna ilawoiwoi kana, ‘Yau geya avanameta.’ Go kina Yauweyana idigo kana, ‘Geya. Moitamo, kuvanama; bogina anovem.’ ");
INSERT INTO gvs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","E korotoyadi sitáoya ivatabaledi go, sikandosobu Sodoma sigite. Eberamo nakae taiyao ivatabaledi ivaduduwedi. ");
INSERT INTO gvs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Sigitegite go, Yauwe inuwonúwana kana, ‘¿Manakae? ¿Eberamo alatuwoko manakaegu bei aguinuwe Sodoma yaina gea geya? ");
INSERT INTO gvs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tauyana ina boda nava bei boda gagaina be nakae toogagaina. Boda liliudi poyapoya goi bei siyagoi tauyana goi akaipakuyedi. ");
INSERT INTO gvs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Guna nuwonúwana geya avamouyeta. Tauyana bogina akatuveko bei natunao nakae tubunao ilovinaedi kana, “Kina Yauwe ina kenao goi taaketōiya ame nakae: Nuwona takiboobosīdi be nakae takínona vavasa taguuinūwe. Neta nakae taguuinuwe, e Kina Yauwe ina katótula bei isowóduwo komi be yau yaida.”’ ");
INSERT INTO gvs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","E tuwo Eberamo ilatuwoko idigo kana, ‘Eberamo, da Sodoma be da Gamora valedi bogina anove, idi bágala ivakaigaga toina. ");
INSERT INTO gvs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tauna ame tutayana bei asou ana agite neta livalayana moitamo gea geya. Neta livalayana geya moitamo, bei ayagoi.’ ");
INSERT INTO gvs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","E koroto adi taiyuwo sisou sina Sodoma go, kina Eberamoyana nava Yauwe matana goi itatáoya. ");
INSERT INTO gvs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","E ivalabelabena Yauwe yaina idigo kana, ‘¿Tomoya, manakae? ¿Tokibóbwata toogoyoidi taiyao bei moitamo kumtulidi? ");
INSERT INTO gvs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Neta tokibobwatayadi adi badabada 50 asa goi sikaaiyaka, bei da Sodoma madabokidi kumtulidi gea tokibobwatayadi pasidi toogoyoidi kunuwotaoidi? ");
INSERT INTO gvs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Go moe geya nakae im sinapu geya. ¡Iyaa! Neta toogoyoidi tokibóbwata taiyao kumtulidi, moe ana kaigigita tauyadi matam goi sivavasa. ¿Ago kom kai da poyapoya ama totakínona; itoboinem kutakinona vavasa ae?’ ");
INSERT INTO gvs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","E Yauweyana idigo kana, ‘Neta tokibóbwata adi badabada 50 Sodoma goi ababanedi, e kidi pasidi madabokidi bei anuwotaoidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","E Eberamo idigo kana, ‘¿Guna Tomoya, yau kaga? Tomota tayamo poyapoya kaukauna tauna. Go tuwo bokoyo magu katepatu avadigoim go, guna digopopóita kunuwotao. ");
INSERT INTO gvs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","¿Neta tokibóbwata adi badabada 45 taudi Sodoma goi sikaaiyaka, manakae? ¿Bei toni kasa liliudi kumtulidi?’ ‘Neta tokibóbwata adi badabada 45 ababanedi, e toni kasayadi madabokidi geya amtulidita’, Yauwe kaena. ");
INSERT INTO gvs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","E Eberamo ibobwaramna idigo kana, ‘¿Go neta tokibóbwata adi badabada 40 taudi amoko goi kubabanedi?’ ‘Tokibóbwata adi badabada 40 pasidi toni kasayadi geya amtulidita’, Yauwe kaena. ");
INSERT INTO gvs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eberamo idigo kana, ‘Guna Tomoya, geya kuegamogamoguta, go sem kutagōna abóbwara. ¿Neta tokibóbwata adi badabada 30 kubabanedi, bei manakaem?’ ‘Neta tokibóbwata adi badabada 30 ababanedi, toni kasayadi madabokidi bei geya amtulidita’, Yauwe kaena. ");
INSERT INTO gvs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eberamo idigo kana, ‘Guna Tomoya, magu katepatu avadigoim go, guna digopopóita kunuwotao. ¿Neta tokibóbwata adi badabada 20 kubabanedi, bei manakaem?’ ‘Tokibóbwata adi badabada 20 pasidi toni kasayadi madabokidi bei geya amtulidita’, Yauwe kaena. ");
INSERT INTO gvs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Tuwo Eberamo idigo kana, ‘Guna Tomoya, geya kuegamogamoguta go, sivatayamo tuwaina bei abóbwara. ¿Neta tokibóbwata adi badabada yawou kubabanedi, bei manakaem?’ ‘Tokibóbwata adi badabada yawou pasidi toni kasayadi madabokidi bei geya amtulidita’, Yauwe kaena. ");
INSERT INTO gvs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E Yauwe ibóbwara ikavava, ina go, Eberamo ikaluvila ina ina kasa. ");
INSERT INTO gvs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","E bogina lavilavi go, anerose adi taiyuwo bogina sisou sina Sodoma. Kina go Loti asa ana kaba siu goi iitusobu. Iitusobu, ikandobala aneroseyadi igitedi simamaima. Tuwo itáoya ina ivalobodedi ikauyagu yaidi go, ivatugúyala ikanakabobo, ");
INSERT INTO gvs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","e idigo kana, ‘Guna tomoyamoya, konōve. Kōma tāna yau imi pákwana guna vada sabamgo ame goi aemi konikīdi, kokaiyāka komasīsi. E vanuwo itomo nobuyana giyaina kotāoya, e kōna.’ ‘Tuwo. Bareki goi bei kamasisi’, kidi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ago kina Lotiyana ilumakikinedi gagaina, tuwo sitagona, e taiyao sina ina vada goi sisiu. Sisiu, beredi pokaka igabu be nakae áika dedevina iwodugu. Iwodugu ikavava, ivaideda sikáika. ");
INSERT INTO gvs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Sikáika ikavava, bego simasisi go, Sodoma korotoidi madabokidi, tubuwau be nakae tomoyamoya, sima vadayana sitaoyakobu. ");
INSERT INTO gvs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Sitaooyakobu go, Lotiyana siduduwe sidigo kadi, ‘¡Loti e! ¿Koroto maine lavilavi im vada goi sisiusiu nakoidi? ¡Kwaiwoduwēdi bei kamasisiyedi!’ ");
INSERT INTO gvs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tuwo Lotiyana isowóduwo go, totom ikatunibode, ");
INSERT INTO gvs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","e ilatuwokoidi idigo kana, ‘¡Segowo, akawanoi yaimi bego moe dogoiyana goyogoyoina toina taabu koguuinūwe! ");
INSERT INTO gvs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Konōve. Yau natugowo vevina adi taiyuwo amedi go, koroto taiyao geya simasisita. Neta kotagona, akabidi amedi avinimi go, kaga latuwomi koguinuwe yaidi toinimi kolovina, go sem ame korotoyadi taabu kobisiikonēdi unana tauyadi guna vada goi sikaiyaka, tauna itoboine avabodebodedi. ¡Tauna taabu kobisiikonēdi!’ ");
INSERT INTO gvs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Go kidi korotoyadi sidigo kadi, ‘¡Geya! ¡Kusiyāmo!’ Go taudiva kadi, ‘¡Iyaa! ¿Ame tauyana tomalatonikasa go, manakae? ¿Bego itakinoida?’ Tuwo Loti silatuwoko kadi, ‘Ima guinuwa yaim bei igoyo toina.’ Tuwo Lotiyana sivatubibi nakae niboda sivalabelabene; latuwodi bego sikaugaegae, e sisiu. ");
INSERT INTO gvs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ago korotoyadi vada sinaena nimadi siyosale, Loti siyoisi, sibiu vada sinaena sibuvaisiu go, totom sikatunibode. ");
INSERT INTO gvs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ikavava, korotoyadi totom goi sikaaiyaka madabokiidi matadi siguinuwedi sikebo, tauna totom sikamyayai go, geya sibabaneyeta, go sem ana lusala ilausidi. ");
INSERT INTO gvs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Tuwo koroto adi taiyuwo vada sinaena sidigo kadi, ‘Loti, giyakainava bei ame asayana madabokina kamtulidi. Yauwe matana goi idi goyo bogina ivakaigaga, tauna ietunema kama bego kamtulidi. ¿Tauna aivina im bodao amedi Sodoma sinaena? Neta natumowo o yaomowo o avakavamowo sikaaiyaka, e asa goi kwabīdi go, kosīya.’ ");
INSERT INTO gvs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","E Loti vada goi isowóduwo ina natunao adi kamatakwanayao ibabanedi, e ilatuwokoidi idigo kana, ‘¡Kotāoya! Giyakainava bei Yauwe asa ame madabokina imtulidi. ¡Tauna woilīmi kosīya!’ Go korotoyadi sinuwonúwana kadi, ‘Loti nakona ivaponuponu.’ ");
INSERT INTO gvs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","E tomo ikaupesapesagi, aneroseyadi Loti sisatubetube sidigo kadi, ‘¡Woilīm! ¡Monem be natumowo kwabīdi, kosīya, govila bei kokámasa tutayana asa ame ana liuna ibabane!’ ");
INSERT INTO gvs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ago Lotiyana isabilibili go, Yauwe inuwokapisiye. Tuwo aneroseyadi Loti mana bodao nimadi siyoisidi sivakededi asayana sikalave. ");
INSERT INTO gvs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Sivakededi asa goi siisowóduwo go, anerose tayamo idigo kana, ‘¡Kosīya bei yawoimi koyavedi go, taabu kokaandovīla! ¡Kolokōina kōna koya goi, govila bei kokámasa!’ ");
INSERT INTO gvs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Go kina Lotiyana idigo kana, ‘¡Guna Tomoya, moe nakae geya! ");
INSERT INTO gvs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Kunōve. Neta yau im pákwana kusoosalegu be nakae kulookategu, e tutayana Sodoma aná mtula goi, yawoigu kuyāve. Go kai geya itoboinemeta kasiya kana amo koyayana goi. Aduwanau isaki. Tauna taabu kueetunēma kana maeko goi, govila bei ame vailaiyana ibabanema, e kakámasa. ");
INSERT INTO gvs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kunōve. Asa amo dobala kugite giyaina. Asayana yomana nakae itoboinema kasiya kana amoko goi. Kutagōna kasiya kana amoko goi bei ama yava kababane.’ ");
INSERT INTO gvs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","E kina idigo kana, ‘Kunōve. Im kawanoi nakae atagone. Amo asayana kudigedige geya amtulidita. ");
INSERT INTO gvs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Go woilīmi kosīya kōna amoko goi. Geya tayamo kaga itoboinegu aguinuwe ana kadókana kosowóduwo asayana goi.’ Moe pasina asayana yoina Sowa. ");
INSERT INTO gvs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","E tuwo níyala bogina ituko, e Loti isowóduwo Sowa goi. ");
INSERT INTO gvs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","E kina go Yauweyana yeu mana poiseni mokauna ibisilave yábana goi isou ina Sodoma be Gamora yaidi. ");
INSERT INTO gvs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tuwo asayadi be nakae Iyoridani butumina naunina be nakae tomotaidi madabokidi imtulidi. ");
INSERT INTO gvs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Go Lotiyana mlina goi monena inonoina ikandovila, e imalagurewa go, gurewayana moe soroti. ");
INSERT INTO gvs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","E nobuyana giyaina Eberamo itáoya ina boi Yauwe taiyao sikaaiyaka kiyaudi. ");
INSERT INTO gvs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ikandosobu Sodoma be Gamora be nakae Iyoridani butumina madabokina igitedi, aubowoidi situkotuko limou aubowoina nakae. ");
INSERT INTO gvs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","E tutayana asayadi dadava amo goi Yauwe imtulidi, Eberamo inuwaisi, tauna itagona bego Lotiyana ina kasa goi isiya. ");
INSERT INTO gvs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","E Loti ma natunao adi taiyuwo Sowa goi sisowóduwo sina koya goi. Imatoita bego Sowa goi ikaiyaka, tuwo situko sina tukubu sinaena goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","E sikaaiyaka, tuta tayamo natunao adi taiyuwo aditava sibobóbwara go, botomoya idigo kana, ‘Guna gómana, kita geya natudamo go, geya tayaamo koroto ikaaiyaka ameko bego tanai, taiyao tamasisi, e kidi goi takéuwama, tavenátuna nakae poyapoya ame sinapuna. Tamada ikaaiyaka go, giyakainava bei ikaitomoya, geya itoboineyeta ivanátuna. ");
INSERT INTO gvs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tauna ame taguinūwe: Tamadayana oine tavini inim ginagina iyaluwo. Niga baige tasiu tauyana tamasisiye, e kina goi takéuwama tavenátuna bei ida boda geya ikavaveta.’ ");
INSERT INTO gvs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tuwo moitamo sabamgo goi tamadiyana oine sivini inim ginagina, e iyaluwo go, botomoya igimisiu tamana imasisiye. Ego tamadiyana geya iyagoiyeta ava tuta natuna isiu imasisiye be nakae ava tuta isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Niga go vanuwo itomo botomoya ana gómana ilatuwoko idigo kana, ‘Guna gómana kunōve. Nuwobuna tamada amasisiye. E sabamgo ame aiyuwoina oine tavini inim ginagina iyaluwo gobe kom kusīu tauyana kumasisīye, e bei tamada goi ida boda ikaiyako vata.’ ");
INSERT INTO gvs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tuwo moitamo amo sabamgoyana goi tamadiyana oine sivini inim ginagina iyaluwo namliyeta baige bogomane isiu tamana imasisiye. Ego tamadiyana geya iyagoiyeta ava tuta natuna isiu imasisiye be nakae ava tuta isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","E tauna natunao adi taiyuwokova tamadi Loti goi sikéuwama. ");
INSERT INTO gvs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Sikéuwama, e botomoya ivenátuna, natuna koroto ivayou Moabe. Niga tauyana tubunao yoidi Moabe go, ame tutayana nava sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","E kina go bogomane nakae ivenátuna, natuna koroto ivayou Beni Ammi. Niga tauyana tubunao yoidi Ammoni, tauyadi ame tutayana nava sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","E tuwo Eberamo ma monena asa Mamre sikalave go, situliya sina Negevi dadavina moe Kenani sinaena go, youya dadavina. Amoko goi asa Kadesi be Sura nauyayanaidi sikaaiyaka. Niga sina asa Garara goi tuta kaakupina sisuvadavada. ");
INSERT INTO gvs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Amoko goi sikaaiyaka go, koroto maniyedi sima Eberamo monena sigite kadi, ‘¿Eberamo, moe ava vavina?’ Eberamoyana imatoita, tauna ipoledi idigo kana, ‘Tauyana niugu. Yoina Sera.’ E da Garara adi tolovina yoina Abimeleka ikaaiyaka go, inove Sera moe Eberamo niuna; latuwona ikabi bego monena. Tauna ina pakonayao ilatuwokoidi idigo kana, ‘Kōna Sera kokābi kōme.’ ");
INSERT INTO gvs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Tuwo moitamo sina sikabi sime bego tauyana monena. Niga sabamgo tayamo Abimeleka ina vada goi iimasisi go, ikanamimi, e Yaubada ima Abimelekayana ikatuwoini idigo kana, ‘¡Abimeleka, kunōve! ¡Kom tokámasa! Vavinayana kukabikabi moe nainaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","E kina go Abimelekayana idigo kana, ‘Guna Tomoya, tauyana geya abisikoneyeta. Yau koroto kiboobosigu be nakae guna bodao dedevidi. ¿Go manakae? ¿Kwaumatema? ");
INSERT INTO gvs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Boi Eberamo ikatubaugu kana, “Ame niugu.” E vavinayana nakae ipola kana, “Tauyana niugu.” Tauna yau guna guinuwa goi nukotogu geya isabutukoeta nakae wowogu geya libigumo.’ ");
INSERT INTO gvs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","E aiyuwoina anamimi goi Yaubada idigo kana, ‘Moe bogina ayagoi kom nukotom geya isabutukoeta nakae wowom geya libimmo. E moe pasina asanabodem bei goyo geya kuguinuweyeta yau yaigu. Tauna geya atagonemta bego tauyana kubisikone be kugoyo. ");
INSERT INTO gvs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","¡Go tuwo! Eberamo Yau guna tokabivalavala, tauna vavinayana kwābi, Eberamo kuvinimnēi bei ikawanoi manum, e bei geya kukamaseta. Go sem neta geya kuviniyeta, moitamo kom be nakae im bodao bei akaumatemi.’ ");
INSERT INTO gvs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Tuwo vanuwo itomo nobuyana giyaina Abimelekayana itáoya, e ina pakonayao madabokidi iduduwedi sima. Sima go, ilatuwokoidi manakaena ikanamimi. Tuwo tauyadi simatoita gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","E Abimelekayana Eberamo iduduwe ima, idigo kana, ‘¡Eberamo, ame kaga kuguinuwe yaima! ¡Ava goyo aguinuwe yaimi, tauna ame nakae kuguinūwe Yau be guna bodao yaidi goi! Moe im guinuwa igoyo toina yaigu. ");
INSERT INTO gvs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Go kaga unana ame dogoiyana kuguinuwe yaigu?’ ");
INSERT INTO gvs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eberamoyana idigo kana, ‘Unana anuwonúwana bego ameko goi Yaubada geya kowowoineyeta, tauna amatoita koroto tayamo bei ikaumategu bego Serayana ikabi. ");
INSERT INTO gvs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Go tauyana moitamo yau niugu. Tamama tayamo go, sinamao ituli. Niga go, kanai. ");
INSERT INTO gvs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","E Yaubada boi ilatuwokoigu bego guna kasa akalave. Tuwo amo tutayana Sera alatuwoko adigo kagu, “Sera, kom monegu, tauna kulokatēgu ame nakae: Asa tamo tamo goi takaaiyaka tomota liliudi kulatuwokōidi kam, ‘Eberamo niugu.’”’ ");
INSERT INTO gvs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","E Abimeleka sipi be bulumakau be nakae paakonidi koroto be vevina ikabidi, Eberamo ivini. E nakae Sera ivinimnei. ");
INSERT INTO gvs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Go idigo kana, ‘Eberamo kunōve. Kumatavilavīla guna poyapoya kugīte. Nako latuwom kwaiyaka, bogina atagona.’ ");
INSERT INTO gvs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Go Serayana ilatuwoko kana, ‘Kunōve. Nium siriba ana badabada 1,000 moe guna takona bogina avini, e bei im bodao liliudi siyagoi bego kom geya kada tayaamo goyo kuguinuwe. Tomota liliudi matadi goi kom geya im pikwanamo.’ ");
INSERT INTO gvs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ego boi Eberamo monena Sera pasina Yauwe iguinuwa bego vevina madabokidi Abimeleka ina vada goi sikaaiyaka sikágala. Tuwo Eberamo ikawanoi Yaubada yaina, e Abimeleka be monena be nakae ina pakonayao vevina madabokidi ikidedevinedi. Tauna itoboinedi sikéuwama. ");
INSERT INTO gvs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Tuwo sikaaiyaka, sikaaiyaka, Yauwe ina Sera yaina goi iguinuwe nakae boi ikatotule, tauna Serayana boi ikágala go, bogina itoboine ikéuwama. ");
INSERT INTO gvs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tuwo ikéuwama go, Eberamo bogina ikaitomoya, e natuna koroto kina Sera ivenatuni. Ago natudiyana ina bíbina ana tuta nakae Yaubada boi ikatotule. ");
INSERT INTO gvs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Natudiyana kina Sera iveenatuni, e Eberamo ivayou Aisake. ");
INSERT INTO gvs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Niga Aisakeyana ana maliyalina ainima aitonina ibabane, e kina Eberamoyana natuna ikabi, sakavaina ikupo nakae Yaubada boi ilovina. ");
INSERT INTO gvs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ego Eberamoyana bogina ikaitomoya nakae ana tala 100 tutayana natuna Aisake ibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","E gomanayana ina bíbina mlina Sera idigo kana, ‘Yaubada gómana ivinigu, tauna auyáwana be avanama. Avatauwa neta livala ame sinove, e nakae bei sivanama yau taiyao.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kana, ‘Geya vatau tayaamo inuwonúwana bego itoboinegu Eberamo natuna avenatuni. Tauyana bogina ikaitomoya go, tuwo natuna avenatuni.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","E gomanayana ibíbina gagaina, sinana ikatusase. Tuwo amo tutayana Eberamo áika gagaina iguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ago Sera ikandobala Ega guma Itipita natuna Isimaeli igite Aisakeyana ikaiwotete. Tuwo Serayana gamona igoyo, ");
INSERT INTO gvs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","e ina Eberamo ilatuwoko idigo kana, ‘Amo pakoninayana maa natuna kuvatapiyēdi sina. Pakoninayana natuna konam bei geya ikabidita tutayana kukámasa, go sem konamyadi madabokidi natugu Aisake anetava bei ikabidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Go livalayana Eberamo inove, atena igeda unana Isimaeli nakae natuna. ");
INSERT INTO gvs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","13","Go kina Yaubada idigo kana, ‘Eberamo, atem taabu igedagēda natum be im pákwana pasidi. Guna katótula tubumowo manudi Aisake goi bei imalatomota. Aiyuwoina kina Isimaeliyana natum, tauna bei akisaili, e bei tubunao boda tayamo gagaina. Tauna kaga liliuna Sera ilatuwokoim kuguinuwēdi, e sopana kwabikaōne be kuguinuwēdi.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","E tuwo vanuwo itomo nobuyana giyaina Eberamo itáoya, bwae giyaina itege be nakae awoinu ikabi, Ega ivini ivabe. E natuna taiyao ivaduduwedi kana, ‘E kōna ae.’ Tuwo tauyadi sina Bera Siva yoyowoina goi siketoiya beso. ");
INSERT INTO gvs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","E siiketoiya go, bwae sinimnim, sinimsave. Sinimsave, gómana maena isayasaya, itáiya. Tuwo sinana ikabi, alova nugonina goi iyato, iwaiwasi. ");
INSERT INTO gvs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ago kina sinanayana ibala ina masigava tupwana aduwanau itusobu, nakae itaitáiya. Ina nuwonúwana kana, ‘Bwae ikavava, tauna natugu bei ikámasa. Geya latuwogu gómana matagu goi go, ivailai.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ago gomanayana ina táiya Yaubada inove, tuwo ina anerose yábana goi itumasobu idigo kana, ‘¿Ega, kaga kutaiyae? Taabu kuumatōita. Gomanayana amoko goi iitusobu ina táiya Yaubada bogina inove. ");
INSERT INTO gvs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","¡Kutāoya! Kūna gomanayana kuvatāoe be kukipaiwōle. Tauyana bei akisaili tubunao boda tayamo gagaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Yaubada ibóbwara ikavava, vavinayana nuwona isanayato, e ikandobala doelu igite. Tuwo ibala ina bwae itege, gomanayana ivanim. ");
INSERT INTO gvs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","E tuwo gomanayana ibibíbina go, kina Yaubada ivakitau. Parani yoyowoina goi ikaaiyaka, e tauyana sau ana togipalu. ");
INSERT INTO gvs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Yoyowoyana goi sikaaiyaka, sinana inuwonúwana kana, ‘Vavina tayamo guma Itipita akabi, natugu monena.’ Tuwo vavina tayamo ikabi ime, natunayana monena. ");
INSERT INTO gvs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","E amo tutayana da Garara adi tolovina Abimeleka ina tovayaviyayao adi tovakumgo yoina Pikoli taiyao sina Eberamo silatuwoko sidigo kadi, ‘Eberamo, im guinuwa liliudi goi Yaubada ivakitaum bogina kagite. ");
INSERT INTO gvs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tauna ame tuta Yaubada matana goi kukatōtula yaima bego geya kuguinuwa goyogoyo yaima, yau be nakae natugowo be tubugowo, go sem kom ogaoga ameko goi go, nakonakae bogina alokatem, e nakae guna lokateyana kulolāse yau yaigu be nakae ida kanasíuna kuyoisikavāte.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eberamoyana idigo kana, ‘Yaubada matana goi bogina akatótula. Kaga liliuna kuudigedi nakae bei aguinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Eberamoyana itagona go, Abimeleka ikamatanako kana, ‘Go im pakonayao guna doelu situugagale. ¿Go bei kaga kuguinuwe?’ ");
INSERT INTO gvs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Go kina Abimelekayana idigo kana, ‘Geya ayagoiyeta avatauwa nakae siguinuwe. Go boi geya kulatuwokoiguta. Moe livalayana makaitaga anove.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Tuwo Eberamo ina sipi be ina bulumakau ikabidi, Abimelekayana ivini, e adi taiyuwo sikanasíuna. ");
INSERT INTO gvs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ego Eberamoyana lami bovavina ana badabada ainima aiyuwo ikabidi, Abimeleka matana goi iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Go Abimelekayana idigo kana, ‘¿Ame kaga ana lami kuyatoidi?’ ");
INSERT INTO gvs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eberamoyana idigo kana, ‘Ame lamiyadi kukabīdi, e moe ada kiyakiyaya bego doeluyana yau atavi, tauna yau guna kaba lovina.’ ");
INSERT INTO gvs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ame pasina asayana ivayou Bera Siva unana amoko goi adi taiyuwo sikatótula, tauna yoina Berasiva. ");
INSERT INTO gvs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","E Bera Siva goi sikanasíuna ikavava, Abimelekayana be nakae ina tokalikumatana Pikoli sitáoya, sikaluvila sina da Palisiti idi kasa. ");
INSERT INTO gvs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ago kina Eberamoyana Bera Siva goi alova tayamo ibaguli, alovayana yoina tamarisika. E amoko goi Yauwe Yaubada aiyako vaatayaina yaina Eberamo isaakululu. ");
INSERT INTO gvs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","E Eberamoyana tuta maanawena da Palisiti idi kasa goi isuvadavada. ");
INSERT INTO gvs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","E Eberamo ikaaiyaka go, Yaubada inuwonúwana kana, ‘¿Moitamo Eberamo bei sopagu ikabikaone gea geya? Tuwo bei avakakone, agite.’ E idigo kana, ‘¡Eberamo!’ ‘U, amegu’, Eberamoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","‘Natum Aisake, tauyana natum kaakesaina kumataakoiye, e kwābi kunāve asa Moriya goi. Koya tayamo bei avatulukoim, e maeko goi natum kukasāle yau yaigu ame nakae: Tauyana kwaumāte go, wowona kugābu kuvakasāve Yau yaigu’, Yaubada kaena. ");
INSERT INTO gvs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tuwo moitamo vanuwo itomo nobuyana giyaina Eberamo itáoya, ina, e ina vininabeso ana kalova igesi. Igesi ikavava, sékula ikabi, ina ase toluna goi isekuli go, alovayana ikailagasi. Ikavava, natuna Aisake be nakae ina pakonayao adi taiyuwo ikabidi, taiyao siketoiya sina asayana Yaubada bogina ilaatuwoko manuna. ");
INSERT INTO gvs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","E siiketoiya go, maliyalina aitonina goi Eberamo ikandobala asayana igite tupwana yomana. ");
INSERT INTO gvs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tuwo ina pakonayaoyadi ilatuwokoidi idigo kana, ‘Komi ami taiyuwo ameko kokaaiyāka ase koruugwāusi go, yau ma natugu kana amoko bei kavatugúyala kakanakabobo Yaubada yaina. Kavatugúyala ikavava, bei kakaluvilamna kama.’ ");
INSERT INTO gvs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ilatuwokoidi ikavava, vininabeso ana kalovayana ikabi, natuna Aisake ivakavale. Ivakavale ikavava, naipi yeu ikabidi, e adi taiyuwo siketoiya. Siketoiya, siketoiya go, kenao goi ");
INSERT INTO gvs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisake idigo kana, ‘Tamagu.’ ‘¿U, manakae natugu?’ Tamana kaena. E Aisakeyana idigo kana, ‘¿Ida yeu be ida kalova goamedi go, ida lami vininabeso aigábuna manuna nako?’ ");
INSERT INTO gvs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","E Eberamoyana idigo kana, ‘Natugu, Yaubada Tokaiguyau toinina bei tayamo ivinida ida vininabeso.’ Adi taiyuwo siiketoiya. ");
INSERT INTO gvs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Siketoiya sima koyayana boi Yaubada ilatuwoko goi, e Eberamo dídiya ikaudakodako aba kasala manuna. Ikaudakodako ikavava, alova ikabi, aba kasalayana yatana goi italiyeliye. Italiyeliye ikavava, natuna Aisake nimana be aena iyowóidi, alova yatana goi ikailagasi. ");
INSERT INTO gvs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ikailagasi ikavava, ina naipi ikabi, ikatulagasi bego natuna ikalimate ");
INSERT INTO gvs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","go, Yauwe ina anerose yábana goi itumasobu kana, ‘¡Eberamo! ¡Eberamo!’ ‘U, amegu’, Eberamoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Aneroseyana idigo kana, ‘¡Taabu natum kukaalimāte be taabu kuyogeedegēde! Ame bogina ayagoi kom kutaimaminegu be nakae kwabikaonegu unana natum kaakesaina go, tuwo geya kuvagagalakoiguta.’ ");
INSERT INTO gvs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ibóbwara ikavava, Eberamo imatavilavila, e mlina goi sipi bolamo igite ina dágula taliboibo ikatupaipaimidi. Igite, ibala ina iyoisi ime, natuna Aisake ana katumapu. E tuwo sipiyana ikaumate go, ikailagasi aba kasala yatana. Ikailagasi ikavava, yeu idimili, sipiyana igabu ivakasave, Yaubada yaina ikasale go, kina Aisakeyana idedevina. ");
INSERT INTO gvs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ame pasina asayana Eberamo ivayou Yauwe Tokaiguyau. Ame tutayana goi nakae tomota liliudi kadi, ‘Yauwe ina koya goi ikaiguyau.’ ");
INSERT INTO gvs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","E aiyuwoina Yauwe ina aneroseyana yábana goi itumasobu Eberamo yaina idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","‘Toinigu yoigu goi akatótula yaim unana natum kaakesaina geya kuvagagalakoiguta, go sem kutagone.’ Moe Yauwe ina bobwarakubo. Tuwaina kana, ");
INSERT INTO gvs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","‘E tauna guna katotulayana ame nakae: Moitamo bei akaipakuyem bei im boda akisailidoko, e adi badabada utuna yábana nakae goi o mamaya loulouna nakae. Niga bei im boda ana kaleyayao itogagasavedi. ");
INSERT INTO gvs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","E sopagu bogina kwabikaone, tauna nava boda liliudi poyapoya ame bei siyagoi im bodayana goi akaipakuyedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ibóbwara ikavava, Eberamo ma natuna sikaluvila sina ina pakonayao yaidi, e taiyao siketoiya sina Bera Siva. Amoko goi Eberamo ilokasa ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ame dogoiyadi sikavava, e tomota tayamo ina Eberamo ilatuwoko kana, ‘Am gómana Nakori monena Milika nakae bogina ivenátuna. ");
INSERT INTO gvs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Botomoya yoina Uso, bonauyayana yoidi Busi be Kamweli, tauyana Aram tamana, ");
INSERT INTO gvs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesedi, Aso, Pilidasi be Idilapi go, bogomane moe Betuweli.’ ");
INSERT INTO gvs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Kina Betuweliyana natuna moe Ribeka. E Eberamo ivana Milika natunao adi badabada ainima aito ivenatunidi. ");
INSERT INTO gvs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nakoriyana moneyuwoina yoina Reuma. E Reumayana nakae ivenátuna, natunao adi taivasi moe Teba, Gakam, Teyasi be Meyaka. ");
INSERT INTO gvs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","E Sera ana tala 127 bogina ibabane, ");
INSERT INTO gvs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Asa Ariba Kenani sinaena goi ikaaiyaka ikámasa. (Aribayana youyuwoina moe Ebironi.) Tuwo Eberamo ina Sera ina yoyou goi itáiya tauyana manuna. ");
INSERT INTO gvs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Itáiya ikavava, mana nuwomou inuwonúwana kana, ‘¿Nako goi bei avaliwoge?’ Inuwonúwana geya, tuwo itáoya ina Eta tubunao ilatuwokoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","‘Yau tomalatonikasa yaimi goi akaaiyaka, tauna geya guna poyapoyamo. E geya itoboineguta bei guna tomata avaliwoge. Tuwo akawanoi yaimi bego valiwoga tukubu agimone bei tomatayana avaliwoge.’ ");
INSERT INTO gvs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Go kidi Eta tubunao sidigo kadi, ");
INSERT INTO gvs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","‘Tomoya, kunovēma. Kom tomoya toolagaim yaima goi. Ava valiwoga tukubu dedevina toina, e moeko goi im tomata kuvaliwoge. Madabokima bogina katagona. Geya vatau tayaamo bei ivagagalakoim o isanabodem im tomata kuvaliwoge.’ ");
INSERT INTO gvs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tuwo Eberamoyana itáoya, Eta tubunaoyadi matadi goi ivatugúyala ikanakabobo ");
INSERT INTO gvs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","go, idigo kana, ‘Neta moitamo imi nuwonúwana bego ameko goi guna tomata avaliwoge, e konovēgu. Sokara natuna Epironi yaina goi kokawanōi manugu ");
INSERT INTO gvs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","bei ina tukubu Makipela goi itagone agimone. Tukubuyana ikaaiyaka Epironi ina poyapoya dadava tayamo goi. E amoko goi guna tomata avaliwoge. Tauyana kolatuwōko latuwogu agimone go, neta aivina ana maisa, madabokina komi matami goi bei aemaisi.’ ");
INSERT INTO gvs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","E kina go Epironiyana ina bodao nauyayanaidi iitusobu asa ana kaba siu goi moe idi kaba tugúguna. Tuwo senao liliudi matadi goi itáoya, Eberamoyana ilatuwoko idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","‘Guna tomoya, moe nakae geya. Kunovēgu. Poyapoyayana be nakae tukubuyana guna bodao matadi goi avinim. Kūna im tomata kuvaliwōge.’ ");
INSERT INTO gvs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Eberamo itáoya go, aiyuwoina ivatuguyalamna ikanakabobo tomotayadi matadi goi ");
INSERT INTO gvs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","idigo kana, ‘Moe dedevina go, kunovēgu. Neta kutagona, e poyapoyayana madabokina ana maisa toina goi aemaisi. Am mani kwābi go, ana amoko goi guna tomata avaliwoge.’ ");
INSERT INTO gvs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Go kina Epironiyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","‘Guna tomoya, kunovēgu. ¿Poyapoyayana ana maisa siriba ana badabada 400 go, moe dogoi besobeso yaida ae? Poyapoyayana avinim. Tuwo kūna im tomata kuvaliwōge.’ ");
INSERT INTO gvs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eberamo poyapoya ana maisa inove, idigo kana, ‘Nakae dedevina. Atagona; bei aemaisi.’ Tuwo Eta tubunao matadi goi ina mani ikatuyaivi nakae Epironi idige. Ikatuyaivi ikavava, ivini. ");
INSERT INTO gvs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","19","Tuwo Eta tubunao matadi goi poyapoyayana, tukubuyana be nakae alovaidi adi lovina isaidámana ina Eberamo yaina. Poyapoyayana ikaaiyaka Makipela goi. Moe asayana Mamre go, bomatu dadavina goi ikaaiyaka. Mamreyana Ebironi asaina Kenani sinaena. E niga go Eberamo ina Makipela goi tukubuyana sinaena Sera ivaliwoge. ");
INSERT INTO gvs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tauna nakae Eta tubunao poyapoyayana be nakae tukubuyana adi lovina Eberamo ikabi aba valiwoga manuna. ");
INSERT INTO gvs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","E kina go Eberamoyana bogina ikaitomoya go, kaga liliuna goi kina Yauwe ikaipakuye. ");
INSERT INTO gvs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Go tauyana imatoita inuwonúwana kana, ‘Bei akámasa go, natugu inai beso Kenani goi.’ Tuwo ina pákwana vakuumgoina iduduwe ima. Eberamo konana madabokidi tauyana irugwaausidi. Ima, e Eberamo idigo kana, ‘Nimam kuvaisīu dibuwatugu kuyōisi go, ");
INSERT INTO gvs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Yauwe Yaubada, Tauyana totobukukui yábana goi nakae poyapoya goi, matana goi kukatōtula ameko Kenani vavinaina tayamo bei geya kukabiyeta natugu monena. ");
INSERT INTO gvs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Go sem bei kūna toinigu guna kasa Karani goi guna bodao yaidi vavina tayamo kukābi natugu Aisake monena.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Go ina pakwanayana idigo kana, ‘¿Go neta vavina tayamo ababane go, geya latuwona bego ima ameko, bei manakaegu? ¿Bei natum akabi anave im kasa goi gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Go kina Eberamoyana idigo kana, ‘Natugu taabu kunavenāve guna kasa goi. ");
INSERT INTO gvs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yauwe Yaubada, Tauyana totobukukui yábana goi, boi tamagu be nakae guna bodao idi kasa goi iikabigu, e ame Tauyana toinina yoina goi ikatótula yaigu idigo kana, “Poyapoya ame natumowo be tubumowo bei avinidi.” Tauyana ina anerose bei ietune iwo ivakumgoiyem, e bei amoko goi ivatulukoim ava vavina kwabi kume natugu monena. ");
INSERT INTO gvs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Go neta vavinayana geya latuwona ima ameko, e moe tuwo; atotulayana ana talígava bogina kubabane. Go dogoi gagaina moe natugu taabu kunavenāve guna kasa amoko goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tuwo pakoninayana ibisibala nimana ivaisiu ina tomoya Eberamo dibuwatuna iyoisi, e ikatótula idigo kana, ‘Yaubada matana goi akatótula, kaga liliuna kuudigedi, nakae bei aguinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ikatótula ikavava, ina ina tomoya Eberamo ina kameri ana badabada yawou ikabidi, ikatubayasidi. Ikatubayasi ikavava, búwana dedevidi badabadaidi ikabidi, idodoidi. Idodoidi ikavava, senao taiyao sina Aram Naraim isiu ina Nakori ina kasa. ");
INSERT INTO gvs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Siketoiya, siketoiya, sisowóduwo asayana ina doelu goi, e kameri silovinaedi bego sivatugúyala siwaiwasi. Moe bogina lavilavi, e vevina adi tuta bwae sitegatega. ");
INSERT INTO gvs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kameri silovinaedi ikavava, pakoninayana ikawanoi Yaubada yaina idigo kana, ‘Yauwe e, kom guna tomoya Eberamo ina Yaubada, akawanoiyem; latuwogu bego tauyana kulokate, e bei ame tuta ana dedevina ababane. ");
INSERT INTO gvs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Gwa, doelu ame kikina goi atatáoya go, asa vevinaidi simamaima bei sitega. ");
INSERT INTO gvs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ago ava vavina yaina neta akawanoi kagu, “Am botori kwaisobūye bei am bwae giyaina anim” go, vavinayana ikatumapu kana, “Kunīm go, im kameri nakae bei avanimdi”, e moe tauyana kuvayōko Aisake im pákwana monena. Moeko goi bei ayagoi guna tomoya bogina kulokate.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","¡Go kugīta! ¡Pakoninayana nava ikaawanoi go, Ribeka botori ivabe isowóduwo ima! Tauyana Betuweli natuna go, tubuna Milika. Milikayana monena yoina Nakori, tauyana Eberamo ana gómana. ");
INSERT INTO gvs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ribekayana vavina gumaboina toina. Tauyana geya tayaamo koroto ikanaaotai. E ima isou ina doeluyana goi bwae itega. Itega ikavava, ituko bego ikaluvila go, ");
INSERT INTO gvs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","pakoninayana woilina ina vavina yaina ikawanoi idigo kana, ‘¿Kutagona bei bwae giyaina im botori goi anim?’ ");
INSERT INTO gvs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","‘Guna tomoya, kunīm’, vavinayana kaena. Tuwo ina botori ikaisobuye, bwae itege, pakoninayana ivini, giyaina inim. ");
INSERT INTO gvs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Inim ikavava, vavinayana idigo kana, ‘Bwae atege im kameri nakae avanimdi ana kadókana sinim, gamodi.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tuwo woilina yoguyogu idi kaba nim goi bwae isiwoi. Ikavava, woilina ina doelu goi bwae tuwaina itege. E nakae iguuinuwe ana kadókana kameri madabokidi sinim gamodi. ");
INSERT INTO gvs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","E kina go korotoyana geya iboboreta, go sem vavinayana idumakavaateyamo; latuwona iyagoi nakona Yauwe bogina ina guinuwa goi ina koidádana imalatomota. ");
INSERT INTO gvs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tutayana kameri sinim ikavava, korotoyana mawuwu goura ikabi, Ribeka kubuna goi ivaisiu. Nípuna goura aiyuwo nakae ikabidi, Ribekayana nimana goi ivalilividi. ");
INSERT INTO gvs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ivalilividi ikavava, idigo kana, ‘¿Tamam avatau? Kulatuwokōigu. ¿Nakae aivina vabodaupa sikaaiyaka itoboinema yau segowo taiyao ina vada goi kamasisi?’ ");
INSERT INTO gvs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","‘Tamagu Betuweli, tauyana Milika be Nakori natudi. ");
INSERT INTO gvs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ima vada goi limou sékula ikaaiyaka, kameri itoboinedi simasisi. Aiyuwoina kameri avadi amodi. E komi itoboinemi koma komasisi’, vavinayana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tuwo korotoyana ivatugúyala ikanakabobo Yauwe yaina goi, ");
INSERT INTO gvs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","idigo kana, ‘Yauwe, guna tomoya Eberamo ina Yaubada, itoboinegu ayapaliyem. Im lokate Eberamoyana yaina goi geya kukalaveyeta be kom nava núwana bayatoina tauyana yaina. Bogina kuvakedegu ama guna tomoya osenao yaidi goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","E vavinayana ilokoina ina ina bodao sinana ina vada goi sikaaiyaka, e kaga liliuna korotoyana iidigedi ilatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ego Ribekayana niuna tayamo yoina Lebani. Tauyana ikaaiyaka tutayana Ribeka iivatétala. E Ribekayana ina livala inove nakae mawuwu be nípuna igitedi, to ilokoinamo. Ilokoina ina doeluyana goi go, korotoyana igite iitáoya kameri kikidi. ");
INSERT INTO gvs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","E idigo kana, ‘Siyagu, kom Yauwe bogina ikaipakuyem, e kūma. ¿Kaga unana ameko goi kuutáoya? Vada bogina akatubayasi, e nakae kameri kebadi bogina akatubayasidi. ¡Tauna kūma tāna guna vada!’ ");
INSERT INTO gvs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tuwo pakoninayana senao taiyao sina Lebani ina vada goi go, konadi kameri yatadi goi Lebaniyana ina pakonayao maniyedi sisivamauidi. Sisivamauidi ikavava, sivavanidi. Niga bwae sitege, korotoyana ma senao sivinidi aedi sinikidi. ");
INSERT INTO gvs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Sivinidi ikavava, awoinu sime korotoyadi matadi goi siyato go, kina korotoyana idigo kana, ‘Geya akaiketa geya ana kadókana alatuwokoimi kaga unana ama ameko.’ ‘O dedevina, kulatuwokōima’, Lebani kaena. ");
INSERT INTO gvs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","E pakoninayana idigo kana, ‘Yau Eberamo ina pákwana. ");
INSERT INTO gvs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Tauyana kina Yauwe ikaipakuye gagaina, tauna bogina ietoolagaina, tuwo ina esaesa gagaina nakae ina sipi be ina bulumakau, ina siriba be ina goura, ina pakonayao koroto be vevina, ina kameri be ina ase badabadaidi Yauwe bogina ivini. ");
INSERT INTO gvs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Guna tomoya monena Sera bogina ikainamoya go, ivenátuna, natuna koroto. Guna tomoya konana liliudi natuna bogina ivini. ");
INSERT INTO gvs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Guna tomoyayana boi ilatuwokoigu kana, “Ame nakae kukatōtula: Taabu Kenani vavinaina ameko goi kukabikābi natugu monena. ");
INSERT INTO gvs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Go sem kūna tamagu ina kasa goi nakae guna dala goi vavina tayamo kukābi natugu monena.” ");
INSERT INTO gvs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Go yau kagu, “¿Go neta vavina tayamo ababane go, geya latuwona bego ima ameko, bei manakaegu?” ");
INSERT INTO gvs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Guna tomoyayana idigo kana, “Yauwe, Tauyana tuta liliuna akabiikaone, ina anerose bei ietune iwo ikitaum be nakae ivaitem bei im koidádana imalatomota, e bei itoboinem vavina tayamo guna dala yaina goi kubabane natugu monena. ");
INSERT INTO gvs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Moeko goi im katótula ana talígava bei kubabane. Go neta vavina tayamo guna dala goi kubabane go, sivagagale, e nakae atotulayana ana talígava bogina kubabane.” ");
INSERT INTO gvs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","E maine ama doelu amo goi akawanoi Yauwe yaina kagu, “Yauwe, guna tomoya Eberamo ina Yaubada, kutagōna guna koidádana imalatomota. ");
INSERT INTO gvs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Gwa, yau doelu ame kikina goi atatáoya. Ava woiyai neta ima ana bwae itega go, neta alatuwoko kagu, ‘¿Manakae? ¿Kutagona bwae giyaina im botori goi anim?’ ");
INSERT INTO gvs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Go neta tauyana kana, ‘Kunīm go, im kameri nakae bei avanimdi’, e moe vavinayana kuvayōko kina im kinava guna tomoya natuna monena.” ");
INSERT INTO gvs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Go yau nava nuwogu goi akaawanoi, e Ribeka ina botori ikavale ima. Tuwo isou ina doelu goi ina bwae itege go, yau alatuwoko kagu, “¿Manakae? ¿Kutagona bwae giyaina im botori goi anim?” ");
INSERT INTO gvs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","E mainao tauyana ina botori ikaisobuye go, idigo kana, “Kunīm go, im kameri nakae bei avanimdi.” E tuwo anim go, tauyana guna kameri adi bwae itege ivanimdi. ");
INSERT INTO gvs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kagu, “¿Tamam avatau?” “Tamagu Betuweli, Nakori be Milika natudi”, tauyana kaena. E tuwo mawuwu akabi, kubuna goi avaisiu be nakae nimana goi nípuna avalilividi go, ");
INSERT INTO gvs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","avatugúyala akanakabobo Yauwe yaina. Tauyana guna tomoya Eberamo ina Yaubada. Enao aba numisa goi bogina ivakedegu ama guna tomoya ana gómana tubuna yaina bego akabi anave natuna monena. ");
INSERT INTO gvs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","E komi Eberamo boda tayamo. ¿Tauna manakae? Neta guna tomoya Eberamo bei kolokate be nakae imi guinuwa goi komi bei núwana bayatoina tauyana yaina, e kolatuwokōigu, e vavinayana akabi anave. Go geya, kolatuwokōigu bei imi nuwonúwana ayagoi, e bei ana alusala aivina kenao sikaaiyaka Aisake monena.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","E Betuweli ma natuna Lebani taiyao sidigo kadi, ‘Ame Yauwe ina guinuwa, tauna kai ima nuwonúwana dogoi besobeso. ");
INSERT INTO gvs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ribeka goame. Kwābi kunāve, e bei tauyana im tomoya natuna monena nakae Yauwe bogina ilatuwokoim.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tutayana Eberamo ina pakwanayana idi livala inove, ivatugúyala ikanakabobo Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ikavava, goura be siriba pasapasa be nakae kwama ikabidi Ribeka ivini. E nakae búwana maisadi gagaidi Ribeka niuna be sinana ivinidi. ");
INSERT INTO gvs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ivinidi ikavava, senao taiyao sikáika. Sikáika ikavava, simasisi. Simasisi vanuwo itomo, sitáoya, pakoninayana idigo kana, ‘Ame tuta kotagōna Ribeka akabi taiyao kana guna tomoya yaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Go kidi sinana be niuna sidigo kadi, ‘Geya, latuwoma bego kom be Ribeka maliyalina yawou nakae takaaiyaka namliyeta baige kona.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Go kina pakoninayana idigo kana, ‘Taabu kovagaagalēgu. Yauwe ina guinuwa goi guna koidádana imalatomota, tauna kotagōna mainao kana guna tomoya yaina goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kidi kadi, ‘Tauyana taduduwe ima go, talumadade bei ina nuwonúwana tayagoi.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Tuwo moitamo vavinayana siduduwe ima go, silumadade kadi, ‘¿Manakae? ¿Vavagim ame tuta ame tauyana taiyao kona gea nava takaaiyaka?’ Kina vavinayana idigo kana, ‘Vavagigu ame tuta kana.’ ");
INSERT INTO gvs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","E tuwo Ribeka mana pákwana vavina, Eberamo ina pákwana mana korotoyao taiyao sivaduduwedi. ");
INSERT INTO gvs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","61","E Ribeka sikaipakuye kadi, ‘Niuma, Im kaiyaka bei dedevina be nakae kususāila, e tubumowo badabadaaidi, nakae adi kaleyayao sitogagasavedi.’ Tuwo Ribeka mana pákwana sitáoya idi kameri goi situlaga. Ikavava, Eberamo ina pákwana sisabokuliye go, ivakededi sina. ");
INSERT INTO gvs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","E kina go Aisakeyana asa Bera Lakai Roi ikalave go, ina Negevi goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lavilavi tayamo iiketoiya yoyowo goi inuwonúwana go, ikandobala kameri igitedi simamaima. ");
INSERT INTO gvs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribeka nakae ikandobala Aisake igite imamaima. Tuwo ina kameri goi isou ");
INSERT INTO gvs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Eberamo ina pakwanayana ilatuwoko idigo kana, ‘¿Amo ava koroto imamaima bei ivalobodeda?’ ‘Amo tauyana guna tomoya’, pakoninayana kaena. Tuwo Ribeka ana kwama ikabi, maisina itabode go, imatakipola nakae idi sinapu nai manuna. ");
INSERT INTO gvs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tuwo Aisake ivalobodedi, e pakoninayana ivatétala ana kaibako. ");
INSERT INTO gvs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","E Aisake ina Ribeka ikabi, inave sinana vada lulubena yoyou parai sinaena goi. Moeko goi Ribeka bogina inai monena, e imatakoiye. Tuwo boi Aisake nuwona imou sinana ina kámasa pasina go, ame tutayana bogina iuyáwana. ");
INSERT INTO gvs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","E Eberamo inaimna, monena yoina Ketura. ");
INSERT INTO gvs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Keturayana goi Eberamo natunao koroto ame nakae: Simirani, Iyokisani, Medani, Midiyani, Isibaki be Suwaka. ");
INSERT INTO gvs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Iyokisaniyana natunao koroto adi taiyuwo, tayamo yoina Seva, tayamo yoina Dedani. Dedaniyana tubunao adi bodao yoidi ame nakae: Asuri, Letusi be nakae Leuma. ");
INSERT INTO gvs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiyaniyana natunao koroto Epa, Eperi, Enoki, Abida be Elideya. Ame tauna Ketura natunao be tubunao. ");
INSERT INTO gvs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","E Eberamo ina lotówana ilotowo, e konana madabokina natuna Aisake ivini. ");
INSERT INTO gvs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ego Eberamo moneyuwoinao natudiyao nakae konadi ivinidi go, ivalilivedi sina aduwanau bomatu dadavina. Geya latuwona Aisake taiyao sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","E Eberamo yawoina ana madabokina moe tala ana badabada tayamo andedi seventipaibi (175). ");
INSERT INTO gvs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Tauyana bogina ikaitomoya toina, e yawoina ikavava, namliyeta ina tamana be tubunao yaidi goi. Yawoina maanawena be nakae ina kaiyaka madabokina dedevina. ");
INSERT INTO gvs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yawoina ikavava, tuwo natunao adi taiyuwo, moe Aisake be Isimaeli, tamadi wowona sikabi, sinave Makipela goi go, valiwoga tukubu sinaena goi sivaliwoge. Makipelayana ikaaiyaka asa Mamre go, bomatu dadavina goi boi Epironi ina poyapoya sinaena. Epironiyana tamana Sokara, tauyana tubuna moe Eta. ");
INSERT INTO gvs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Eta tubunaoyadi yaidi goi boi poyapoya Eberamo igimone. Amoko goi monena Sera ivaliwoge go, Eberamo nakae sivaliwoge. ");
INSERT INTO gvs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","E ina kámasa mlina, natuna Aisake Bera Lakai Roi goi ilokasa ikaaiyaka go, ina kaiyakayana goi kina Yaubada ikaipakuye. ");
INSERT INTO gvs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ame Eberamo natuna Isimaeli mana bodao adi liliu: Sera ina pákwana Ega guma Itipita go, kina Egayana Eberamo natuna Isimaeli ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimaeliyana natunao koroto adi bíbina goi ame nakae: Botomoya yoina Nibayote. Bonauyayana yoidi Kedari, Adebaeli, Mibisam, ");
INSERT INTO gvs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misema, Duma, Mase, ");
INSERT INTO gvs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Kadadi, Tema, Yetura be Napisi. Bogomane yoina Kedema. ");
INSERT INTO gvs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ame taudi Isimaeli natunao yawou aiyuwo sietolovina idi bodao yaidi goi. Ame yoidiyadi moe idi bodaoyadi tamo tamo adi dala yawou aiyuwo yoidi nakae. Aiyuwoina tubudiyao idi kasa yoidi nakae. ");
INSERT INTO gvs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimaeli yawoina ana madabokina moe tala ana badabada 137 ibabane, e yawoina ikavava namliyeta ina tamana be tubunao yaidi goi. ");
INSERT INTO gvs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","E tauyadi natunao be tubunao silokasa Abila be Sura nauyayanaidi goi, moe Itipita idi túwana kikina neta kunonoina bego Asiriya. Ago Isimaeli natunao Aisake natunao sivakaleyedi. ");
INSERT INTO gvs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","E ame Eberamo natuna Aisake mana bodao tetelidi. ");
INSERT INTO gvs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","E tutayana Aisake ana tala poti, Ribeka inai. Ribekayana tamana yoina Betuweli guma Aram, ina kasa Padani Aram. Niuna yoina Lebani. ");
INSERT INTO gvs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","E Ribeka ikágala, tauna Aisake ikawanoi Yauwe yaina bego natuna ivini. Tuwo Yauwe inove, e Ribekayana ikéuwama. ");
INSERT INTO gvs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ikéuwama go, gamona goi gogómana lalavi sivadidídina, tuwo Ribekayana ina nuwonúwana kana, ‘¿Kaga unana ame isowóduwo yau yaigu?’ Tuwo Yauwe inoko vaita manuna; latuwona bego iyagoi. ");
INSERT INTO gvs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","E Yauweyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tuwo moitamo Ribeka ina tuta ibabane, e gamona goi lalavi koroto sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ina venatunayana goi gómana igimibíbina okayakaya go, wowona unuunu kaka, tauna sivayou Iso. ");
INSERT INTO gvs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ego tutayana Iso isowóduwo, siyana ivámliya ibisibala tuwowona aegedugeduna iyoisi, tauna sivayou Yakobo. E Aisake ana tala siksti (60) tutayana Ribeka natunao ivenatunidi. ");
INSERT INTO gvs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","E gogomanayadi bogina sibíbina gagaidi. Iso togivakauko; aitowo nuwona ikabi. E kina go Yakobo ituli; tauyana koroto sakuululuna nakae tuwowoonuwaina, tauna tuta liliuna yoyou parai goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisake yoguyogu woiwoi ana tokáika, tauna natuna Iso imatakoiye. E kina go Ribeka natuna Yakobo imatakoiye. ");
INSERT INTO gvs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","E sikaaiyaka, tuta tayamo Yakobo bini kayakayaidi ivaaipoludi go, tuwowona Iso vakauko goi ima, e loga ikámasa toina. ");
INSERT INTO gvs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Siyana Yakobo igite ivaaipolu, tuwo ilatuwoko idigo kana, ‘¡Loga akámasa! Tauna siyagu, am bini kayakayaidi giyaina kuvinīgu akáika.’ Moe pasina Iso youyuwoina moe Idom. ");
INSERT INTO gvs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Go kina Yakoboyana idigo kana, ‘Tatalamāpu. Mainao kom botomoya im lovina kuvinīgu namliyeta biniyadi avinim.’ ");
INSERT INTO gvs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Isoyana idigo kana, ‘¡Loga akámasa go! ¿Guna lovina kaga ana dedevina neta yau akámasa?’ ");
INSERT INTO gvs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Go Yakoboyana idigo kana, ‘Ame tuta Yaubada matana goi kukatōtula bei im lovina kuvinigu.’ Tauna Iso ikatótula idigo kana, ‘Yaubada matana goi kom botomoya nakae mam lovina.’ ");
INSERT INTO gvs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ikatótula ikavava, Yakobo beredi be nakae bini ikabidi, tuwowona ivini. Tuwo Isoyana ikáika be inim. Ikáika ikavava, itáoya ina. Tauna Iso ina lovina áika goi italamapuye. Tuwo lovinayana dogoi besobeso tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","E Bera Lakai Roi goi loga isowóduwo nakae boi Aisake tamana ana tuta. Tuwo Aisake itáoya, ina asa Garara goi da Palisiti adi tolovina Abimeleka igite ikawanoi tuta kaakupina ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","E Aisakeyana ina nuwonúwana bego ina Itipita go, Yauwe toinina isowóduwo tauyana yaina idigo kana, ‘Aisake, taabu kunonōina Itipita, go sem asa bei avatulukoim, moeko goi kwaiyāka. ");
INSERT INTO gvs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Go ame tuta ameko goi kusuvadavada. Yau bei avakitaum be akaipakuyem. Moitamo. Kom be nakae tubumowo poyapoya ame madabokina bei avinimi. Boi tamam Eberamo yaina akatótula go, ame bei atotulayana akamoitamoe kom yaim. ");
INSERT INTO gvs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Im boda bei akisailidi, adi badabada nakae utuna yábana goi go, poyapoya ame madabokina bei avinidi. Nava boda liliudi poyapoya ame bei siyagoi im boda goi akaipakuyedi ");
INSERT INTO gvs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","unana Eberamo sopagu ikabikaone; guna lovina, guna vatulúkwana, guna liwola be nakae guna livala ikabikaonedi. Tauna boda liliudi bei siyagoi yau akaipakuyedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tuwo moitamo Aisake Garara goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Amoko goi koroto maniyedi sikandobala Ribeka sigite vavina gumaboina, e Aisake silumadade kadi, ‘Ribeka avakavam?’ Aisakeyana idigo kana, ‘Tauyana niugu.’ Bogina kuyagoi. Tauyana imatoita bego ilatuwokoidi kana, ‘Ribeka monegu’, govila bei Ribekayana pasina sikaumate. ");
INSERT INTO gvs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","E Aisakeyana bogina tuta maanawena amoko goi ikaaiyaka, e tuta tayamo ma monena Ribeka siituyuwo. Siituyuwo go, Aisake ibisibala Ribeka wowona ikatumoyasu. Adi taiyuwokova sinuwonúwana kadi, ‘Nakona adetava.’ Kom go avatau? Abimeleka, tauyana da Palisiti adi tolovina, ina vada goi ikaaiyaka, windo goi ikandosobu igitedi. ");
INSERT INTO gvs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tuwo Aisake iduduwe ima ilatuwoko idigo kana, ‘Aisake, amo vavinayana moitamo monem ae? Kaga unana kupola kam, “Tauyana niugu”?’ Aisakeyana idigo kana, ‘Unana amatoita. Guna nuwonúwana kagu, “Vavinayana pasina bei sikaumategu.” Tauna kagu, “Tauyana niugu.”’ ");
INSERT INTO gvs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Go Abimelekayana idigo kana, ‘Moe kaga kuguinuwe yaima! Neta koroto tayamo monem imasisiye, e moe goyoyana pasina kai vailai kababane!’ ");
INSERT INTO gvs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","E tuwo tauyana lovina tomota liliudi ivinidi idigo kana, ‘Avatau neta koroto ame o monena ibisikone, bei ana kaumata ibabane.’ ");
INSERT INTO gvs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","E Yauwe Aisake ikaipakuye. Amo asayana goi Aisake ibágula go, niga dibayoya ana tuta goi ina dibayoya gagaina toina ibabane. ");
INSERT INTO gvs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tauna Aisake bogina iguyau go, ina esaesa tuta liliuna ivaituwe ana kadókana iguyau gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ina sipi, ina bulumakau be nakae ina pakonayao vevina be koroto badabadaidi sikaaiyaka, e tauna da Palisiti sigite sivakipikipiye. ");
INSERT INTO gvs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tuwo sina doeluyadi tamo tamo Aisake tamana Eberamo ina pakonayao boi siitavidi poyapoya goi sikaubodedi. ");
INSERT INTO gvs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","E Abimeleka ina Aisake ilatuwoko idigo kana, ‘Aisake, kom bogina kutogagasavema, tauna ima kasa kwalāve.’ ");
INSERT INTO gvs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tuwo moitamo Aisake itáoya, asayana ikalave go, ina Garara butumina goi itunagu. ");
INSERT INTO gvs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Amo asayana goi boi nimatu Eberamo ina pakonayao doelu sitavidi go, tutayana ina kámasa mlina, e da Palisiti poyapoya sikabi sikaubodemneidi. Tuwo Aisake itavimneidi, e sidau. Doeluyadi ivayoudi nakae boi tamana ivaayoudi. ");
INSERT INTO gvs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","E tuta tayamo Aisake ina pakonayao doelu vau sitavi, e bwae dedevina ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ago doeluyana pasina da Garara idi sipiyao maniyedi adi torugwautayao Aisake ina pakonayaoyadi taiyao sikaumakimaki. Torugwautayadi sidigo kadi, ‘Ame kai ama bwae!’ Tuwo doeluyana Aisake ivayou Eseki idi kaumakimaki pasina. ");
INSERT INTO gvs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","E Aisake ina pakonayaoyadi doelu aiyuwoina sitavi, e amo doeluyana pasina nakae torugwáuta sima taiyao sikaumakimaki, tauna doeluyana Aisake ivayou Sitina. ");
INSERT INTO gvs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","E Aisake ina ituli ta poyapoya goi ina pakonayaoyadi doelu aitonina sitavi go, geya vatau tayaamo ima ikaumakimaki, tauna doeluyana ivayou Rekobota go, idigo kana, ‘Yauwe abatau bogina ivinida yoiyada, tauna itoboineda takaiyaka, e tasusáila.’ ");
INSERT INTO gvs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","E niga amo asayana Aisake ikalave go, ina Bera Siva goi itunagu. ");
INSERT INTO gvs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Amo sabamgo goi Yauwe isowóduwo Aisakeyana yaina idigo kana, ‘Aisake, yau tamam Eberamo ina Yaubada. Taabu kuumatōita. Yau avakiitaum. Bei akaipakuyem be nakae guna pákwana Eberamo pasina im boda akisailidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Tuwo amoko goi dídiya ikaudakodako, aba kasala imadagi. Ikaudakodako ikavava, Yauwe yaina isakululu. E amoko goi ina yoyou parai iyowo be nakae ina pakonayao ina doelu sitavi. ");
INSERT INTO gvs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","E kidi go Abimeleka ina tovaita Ausati be nakae ina tovayaviyayao adi tovakumgo yoina Pikoli asa Garara goi sima bego Aisake sigite. ");
INSERT INTO gvs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Sima go, Aisakeyana ilumadádana kana, ‘Kaga latuwomi koma? Boi kokaolilivegu be nakae kovalilivegu, tauna kaga unana koma?’ ");
INSERT INTO gvs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kidi kadi, ‘Kama unana kayagoi Yauwe ivakiitaum. Tauna Yaubada matana goi komi be kai takatōtula nakae takanasīuna. ");
INSERT INTO gvs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ame nakae: Kom kukatōtula bego taabu kuyogedegedēma nakae kai boi geya kayogedegedemta, go sem ima sinapu tuta liliuna dedevina yaim be nakae mam tuboina kavalilivemmo. E ame tutayana kayagoi Yauwe ikaipakuyem.’ ");
INSERT INTO gvs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tuwo Aisake itagona, tauna áika iwodugu, ivinidi sikáika sinim. Áika ikavava, simasisi. ");
INSERT INTO gvs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Simasisi vanuwo itomo nobuyana giyaina goi sitáoya, e Abimeleka be Aisake Yaubada matana goi sikatótula. Sikatótula ikavava, Aisake ivaduduwedi tauyadi madi tuboina sina. ");
INSERT INTO gvs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","E amo maliyalinayana goi Aisake ina pakonayao sima silatuwoko sidigo kadi, ‘Aisake, tayamo doelu katavi go, bwae bogina kababane!’ ");
INSERT INTO gvs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tuwo doeluyana ivayou Suva. Tauna ame tuta nakae, asayana yoina Bera Siva. ");
INSERT INTO gvs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","E Iso ana tala poti ibabanedi go, Diyudeti inai. Diyudetiyana tamana yoina Beri go, tubuna Eta. Vavina aiyuwoina yoina Basemate Iso taiyao sinai. Basemateyana tamana yoina Eloni go, tubuna Eta. ");
INSERT INTO gvs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Vevinayadi imedi go, idi sinapu pasina Aisake be Ribeka atedi igeda. ");
INSERT INTO gvs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","E Aisake ikaaiyaka, e bogina ikaitomoya, nakae matana ikau, tuwo geya itoboineyeta igita dókana. E tuta tayamo ina botomoya Iso iduduwe idigo kana, ‘Natugu, kūma!’ ‘Tamagu, manakae?’ Isoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aisakeyana idigo kana, ‘Natugu, kunōve. Yau bogina akaitomoya. Guna tuta geya ayagoiyeta ava tuta bei akámasa. ");
INSERT INTO gvs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tauna im kaipíyama, im sau be im gita, kwabīdi, e kūna yoyowo goi yau guna woiwoi kuvakāuko. ");
INSERT INTO gvs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kuvakauko ikavava, kūma awoinu dedevina kuwodūgu nakae yau nuwogu ikabi, e kūme akáika. Akáika ikavava, yau nava maa yawoigu itoboinegu akaipakuyem.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","E kina go Ribeka itaaiyakeka tutayana Aisake ma natuna Iso sibobóbwara. Tutayana Isoyana itáoya ina yoyowo goi ivakauko, ");
INSERT INTO gvs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","e kina go Ribekayana ina natuna Yakobo ilatuwoko idigo kana, ‘Natugu kunōve. Maine tamam anove tuwowom Iso ilatuwoko ");
INSERT INTO gvs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","idigo kana, “Woiwoi dedevina kuvakaukōe, kūme awoinu dedevina kuwodūgu. Kuwodugu ikavava, kūme akáika, e yau nava maa yawoigu itoboinegu Yauwe matana goi akaipakuyem.” ");
INSERT INTO gvs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tauna natugu, ame tuta kunovēgu. Kaga nakae alatuuwokoim, kom nakae kuguinūwe. ");
INSERT INTO gvs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Natugu, ame tuta kūna goti bonatuna aiyuwo dedevidi kulauīdi kumēdi, e awoinu dedevina bei aodugu nakae tamam nuwona ikabi. ");
INSERT INTO gvs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Aodugu ikavava, kūna tamamyana kuvīni ikáika, e bei itoboine igimikaipakuyem namliyeta ikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Go kina Yakoboyana idigo kana, ‘Tauna go tuwowogu Iso wowona unuununa go, yau wowogu imomoyasu. ");
INSERT INTO gvs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nakona bei tamagu sakavaigu ibisikone, bei ikinanegu kana, “Ame Yakobo ikatubaugu.” E tauna bei geya ikaipakuyeguta, go sem bei ikatubolategu.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Go sinanayana idigo kana, ‘Natugu, neta ikatubolatem, yau atagona bego atubolatayana ima yaigu, go kom sem niyagu konōve. Ame tuta kūna gotiyadi kulauīdi kumēdi.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tuwo moitamo itáoya ina gotiyadi ikaumatedi. Ikaumatedi ikavava, imedi sinana ivini, awoinu dedevina iwodugu nakae tamana nuwona ikabi. ");
INSERT INTO gvs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ivaipolu ikavava, isiu ina vada goi ina botomoya Iso ana kwama dedevidi ikabidi, Yakobo ivini ilosidi. ");
INSERT INTO gvs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ilosidi ikavava, goti bonatunayadi sakavaidi Ribeka ikabidi, Yakobo nimana be nukotona momooyasuna goi isikoidi. ");
INSERT INTO gvs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Isikoidi ikavava, awoinuyana be beredi bogina ikatubaayasidi natuna Yakobo ivini. Yakobo berediyana be awoinuyana ikabidi, ");
INSERT INTO gvs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","e ina tamana goi idigo kana, ‘Tamagu.’ ‘U. Go kom ava natugu?’, tamana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakoboyana ipola idigo kana, ‘Tamagu, yau im botomoya Iso. Kaga nakae kulatuuwokoigu bogina nakae aguinuwe. Tauna kutusobu dōkana, kwāika. Ikavava, kwaipakuyēgu.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Go kina Aisakeyana idigo kana, ‘Go natugu, manakaem mainao kuma?’ ‘Unana Yauwe im Yaubada ivaitegu’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tuwo Aisakeyana idigo kana, ‘Natugu, kūma kikigu goi abisikonem, e bei ayagoim nakona kom moitamo natugu Iso gea geya.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","E tuwo Yakoboyana ibala ina tamana Aisake kikina goi go, tamanayana ibisibala Yakobo ibisikone, idigo kana, ‘Niyam Yakobo niyana nakae go, nimam Iso nimana nakae.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","E amoko goi Aisake natuna Yakobo geya ikinaneyeta unana nimana ma unuununa Iso nimana nakae. Tauna geya ikinaneyeta. Tuwo latuwona bego ikaipakuye go, nava inanayuwo, ");
INSERT INTO gvs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","tuwo idigo kana, ‘Kom moitamo natugu Iso?’ ‘U, nakae’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tuwo Aisakeyana idigo kana, ‘Natugu, woiwoi bogina kuvaaipolu kūme bei akáika, gobe akaipakuyem.’ Tuwo moitamo Aisake ivini ikáika nakae oine ivini inim. ");
INSERT INTO gvs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ikavava, Aisake idigo kana, ‘Natugu, kūma kuyowoiīgu.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tuwo Yakobo ina tamana iyowoi go, Yakobo ana kwama mainina Aisake inove, e idigo kana, ‘Aa natugu mainina nakae yoyowo mainina; yoyowoyana Yauwe ikaipakuye.’ Tuwo ikaipakuye idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","‘Yaubada ina nuwonúwana goi númla sigugumina ");
INSERT INTO gvs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Aiyuwoina Yaubada ina nuwonúwana goi ");
INSERT INTO gvs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","E Aisake ina kaipakuyana ikavava, Yakobo itáoya, tamana ikalave ina go, kina Iso ina vakauko goi isowóduwo ima. ");
INSERT INTO gvs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ima, e nakae awoinu dedevina iwodugu. Iwodugu ikavava, isiu ina tamana ivini idigo kana, ‘Tamagu, kutusobu dōkana go, ame anina bogina avaipolu kwáika gobe kwaipakuyēgu.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Go kina Aisakeyana nukotona iwówana, idigo kana, ‘Go kom vatau?’ ‘Yau Iso, im botomoya’, Isoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tuwo Aisakeyana wowona itátava gagaina toina, e idigo kana, ‘Go maine vatau ima? Tauyana awoinu dedevina iwodugu ime ivinigu akáika. Makaitaga akáika ikavava, e kom kuma. Go tauyana bogina akaipakuye, tauna aipakuyana ikaiyako vata yaina, geya itoboineguta akuliuye.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","E tutayana kina Isoyana tamana ina livala inove, mana táiya itaiyaduduwo gagaina idigo kana, ‘Oiyoi, tamagu! Yau nakae kwaipakuyēgu!’ ");
INSERT INTO gvs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Go kina tamana kana, ‘Geya. Am gómana mana pola ima am kaipaku bogina isonane.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tuwo Isoyana idigo kana, ‘Tauyana sivayoudoko Yakobo ae? Bogina sivayuwo ikatubaukoigu. Boi guna tapavívila goi tauyana ivaobugu, e tauna tauyana imalabotomoya mana lovina go, ame tuta guna kaipaku isonane.’ Tuwaina kana, ‘Go tamagu, manakae? Itoboinem yau nakae kwaipakuyegu gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Go kina Aisakeyana idigo kana, ‘Kunōve! Guna kaipaku goi tauyana kom osemowo taiyao bei ilovinaemi nakae komi ina pakonayao. Ina oine nakae ina kawoinu bei siiloboina. Tauna natugu, geya tayaamo aipaku dedevina ikaaiyaka bei kom avinim.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Go kina Isoyana idigo kana, ‘Go manakae? Sivatayamo tauna itoboinem kwaipaku ae? Tamagu! Yau nakae kwaipakuyēgu!’ Tuwo Iso itáiya gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","E tamana Aisake idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Im kaiyaka manuna bei kuvalauláuwo ");
INSERT INTO gvs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","E tuwo Iso gamona igoyo unana tamana ina kaipaku ana gómana Yakobo ivini go, kina geya, tauna Yakoboyana ikaolilive. Inuwonúwana kana, ‘Tamagu ina kámasa mlina go, táiya ana tuta ikavava, tauyana bei akaumate.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ago Ribeka vala inove bego Iso latuwona Yakobo ikaumate. Tuwo ina bogomane Yakobo iduduwe ima idigo kana, ‘Natugu, kunōve. Iso toinina ikipaiwole ame nakae: Iyupuyupu bego im goyo ikatumapu, e ikaumatem. ");
INSERT INTO gvs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tauna natugu, niyagu kunōve. Ame tutayana kutāoya, woilīm kusīya kūna Karani goi, e niugu Lebani yaina goi kwaiyāka. ");
INSERT INTO gvs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Amoko goi tuta giyaina kwaiyāka, nakae ana kadókana tuwowom ina egamogamogu ikavava. ");
INSERT INTO gvs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tutayana ina egamogamoguyana ikavava be nakae im guinuwa ame inuwotao, e livala bei aetune iwo yaim bego kom itoboinem kwaluvila. Moe nakae kuguinūwe, govila bei ameko goi kwaiyaka, Iso ikaumatem go, tomota bei Iso ina guinuwa pasina sikaumate. Geya latuwogu natugowo ami taiyuwokova kokámasa maliyalina tayamo sinaena.’ ");
INSERT INTO gvs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","E Ribeka ina monena Aisake ilatuwoko idigo kana, ‘Amo Eta tubunao vevina adi taiyuwo Iso iinaidi bogina ogu ikai taiyao kakaiyaka. Neta Yakobo nakae Eta tubuna vavina tayamo inai, e dedevina yaigu neta akámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tuwo livalayana Aisake inove, Yakobo iduduwe ima, ikaipakuye. Ikaipakuye ikavava, idigo kana, ‘Natugu, taabu Kenani vavinaina kunaināi. ");
INSERT INTO gvs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Go sem kūna asa Padani Aram. Amoko goi kūna sinam tamana Betuweli ina vada goi. Vavina tayamo doiyam Lebani natunao yaidi goi kukābi kunāi. ");
INSERT INTO gvs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yaubada Tokalika im nai bei ikaipakuye, e bei ina guinuwa goi kususáila, tubumowo badabadaaidi. Tauna kom boda badabadaidi tubudi. ");
INSERT INTO gvs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Aiyuwoina ina kaipaku Eberamo yaina bei ivadamane iwo kom ma tubumowo yaimi, e nava ame poyapoyayana goi kueeogaoga bei kokabi imi kaba lovina. Ame poyapoyayana boi Yaubada ikatotule Eberamo yaina bego tubunao ivinidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aisake ibóbwara ikavava, Yakobo ietune ina Padani Aram. Padani Aramyana moe Yakobo be Iso doiyadi Lebani ina kasa; Lebaniyana tamana Betuweli guma Aram. ");
INSERT INTO gvs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","E Iso livala inove bego tutayana tamana Aisake Yakobo ikaipakuye, isanabode kana, ‘Taabu Kenani vavinaina kunaināi’ go, ivaduduwe ietune ina Padani Aram bego vavina tayamo inai. ");
INSERT INTO gvs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Aiyuwoina inove bego Yakobo tamadi be sinadi sopadi bogina ikabikaone, tauna bogina ina Padani Aram. ");
INSERT INTO gvs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","E moeko goi bogina iyagoi boi Kenani vevinaidi inaidi, tamana Aisake ikataedi. ");
INSERT INTO gvs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tuwo Iso latuwona vavina tayamo tuwaina inai, e ina tamana siyana Isimaeli igite bei tauyana natuna yoina Malate inai. Malateyana siyana Nibayote. Moeko goi Iso ivakeyáuwo, Malateyana moe monena aitonina. ");
INSERT INTO gvs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","E Yakobo itáoya, asa Bera Siva ikalave go, iketoiya ina asa Karani. ");
INSERT INTO gvs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Inonoina go, ima tayamo asa ibabane, e amoko goi ikanaliya. Bogina kuyagoi. Níyala bogina isaliu. E mainao asayana goi dídiya tayamo ikabi, iyato ilogédava, e amoko goi imasisi. ");
INSERT INTO gvs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Go ina masisiyana goi ikanamimi. Ina kanamimiyana ame nakae: Aitámana tayamo igite poyapoya goi iitáoya go, sipona ituko ina yábana. Go Yaubada ina aneroseyao situkotuko nakae sisousou. ");
INSERT INTO gvs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Aitamanayana kikina Yauwe itatáoya idigo kana, ‘Yau Yauwe, tubum Eberamo be tamam Aisake idi Yaubada. Moe poyapoyayana goi kuumasisi, kom mam bodao bei avinimi. ");
INSERT INTO gvs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Im boda adi badabada bei ivakaigaga! Tuwo im bodayana bei poyapoya ame madabokina situgidagidali, tauna sina bomatu dadavina, youya dadavina, koiboga dadavina be nakae yawéyana dadavina. Boda liliudi poyapoya goi bei siyagoi kom be im boda pasidi akaipakuyedi. ");
INSERT INTO gvs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kunōve. Yau avakiitaum, tuwo nako goi kuna Yau bei avabodebodem gobe akaluvilemneim amem poyapoya ame goi. Moitamo. Geya akalavemta. Bei avakiitaum ana kadókana aguinuwe nakae bogina akatotule yaim.’ ");
INSERT INTO gvs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","E Yakobo masisi goi itáoya go, inuwonúwana kana, ‘Moitamo Yauwe ameni asa ame goi go, mainao geya ayagoiyeta.’ ");
INSERT INTO gvs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Go tauyana atena iyova gagaina toina, idigo kana, ‘Iyaa! Ame poyapoyayana moitamo aba kateyova gagaina toina! Ame moitamo Yaubada ina vada; nakona yábana ana kaba siu!’ ");
INSERT INTO gvs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tuwo vanuwo itomo nobuyana giyaina goi Yakobo itáoya go, didiyayana iloogedoi ikabi, ivatáoe. Didiyayana aba kinana bego poyapoya amo kimaasabaina Yaubada umana. Ivatáoe ikavava, didiyayana ikimasabe Yaubada umana ame nakae: Didiyayana goi oribe putumina isiwoi. ");
INSERT INTO gvs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ikavava, asayana boi yoina Lusi go, ivayou Beteli. ");
INSERT INTO gvs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","E Yakobo ikatótula Yauwe yaina idigo kana, ‘Yaubada, neta moitamo kom kuvakiitaugu be guna ketoiya goi kuvabodeebodegu, neta avagu be guna kwama kuvinigu ");
INSERT INTO gvs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ana kadókana akaluvila ana tamagu yaina magu dedevina, e Yauwe kom bei avayokoim yau guna Yaubada. ");
INSERT INTO gvs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","E ame didiyayana bogina aavatáoe bei akimasabe, moe Yaubada im vada, bei ameko goi kai tomota kasakululu yaim. Kaga liliuna kuuvinigu bei akaiguyauye aiguyau ana badabada yawou, e tayamo avinim.’ ");
INSERT INTO gvs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Tuwo Yakobo ibóbwara ikavava, itáoya, e aiyuwoina iketoiya. Iketoiya ima isowóduwo boda bomatu dadavina idi kasa goi. ");
INSERT INTO gvs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Go ikandobala náuna moteoina goi doelu igite. Doeluyana kikina goi sipi yáuwo aito sikaaiyaka madi tomatakavatayao. Bogina kuyagoi. Doeluyana moe sipi adi bwae. E doeluyana tobuna aubodaina moe gurewa gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Neta sipi madabokidi bogina silamgogoidi doeluyana goi, e adi tomatakavatayao sima gurewayana siliu sikaibale masigava goi siyato go, sipi sivanimdi. Sipi sinim ikavava, e gurewayana sikabi, tobuna sikaubodemnei. ");
INSERT INTO gvs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","E tuwo Yakobo ibala ina tomatakavatayadi ilumadadedi idigo kana, ‘Segowo, komi nako korotoimi?’ ‘Kai Karani korotoima’, tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakobo idigo kana, ‘Go Nakori tubuna Lebani kooyagoi o geya?’ ‘U, kaayagoi’, tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tuwo Yakoboyana idigo kana, ‘Manakae? Tauyana dedevina gea geya?’ ‘U, dedevina. Kudobāla natuna Reitiyeli goamo. Tamana Lebani ina sipi imemedi’, tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","E Yakoboyana idigo kana, ‘Kaga unana sipi komedi? Ame dine, níyala ivakaigaga go! Ame geya idi tuta kolamgogoidi sabamgo manuna. Tuwo kovanīmdi baige kokaluvilemnēidi konavēdi limou sikáika.’ ");
INSERT INTO gvs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","‘Geya. Nava kaatuyáwata ana kadókana sipi madabokidi kalamgogoidi, namliyeta baige gurewa kaliu kakaibale, e sipi kavanimdi’, tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","E nava sibobóbwara, Reitiyeli isowóduwo ima tamana ina sipi imedi. Bogina kuyagoi. Tauyana sipi ana tomatakavata. ");
INSERT INTO gvs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","E tutayana Yakobo ikandobala Reitiyeliyana igite doiyana ina sipi imemedi, Yakobo anetava go, gurewa iliu ikaibale, sipiyadi ivanimdi. ");
INSERT INTO gvs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ivanimdi ikavava, ibala ina Reitiyeli iyowoi go, mana uyáwana itáiya. ");
INSERT INTO gvs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","E idigo kana, ‘Yau Yakobo, tamam osiyana, Ribeka natuna.’ Tuwo livalayana Reitiyeli inove, ilokoina ina tamana ilatuwoko. ");
INSERT INTO gvs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","E tutayana Lebani vala inove bego doiyana Yakobo ima, e ilokoina ina ivalobode. Ivalobode, ivayavau nakae iyowoi. Ikavava, ime ina vada goi. Amoko goi Yakobo ivatétala, ana kaibako ivateteli. ");
INSERT INTO gvs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Tuwo Lebaniyana idigo kana, ‘Moitamo, kita boda tayamo, ikaikaida tayamo.’ Tuwo tukówana tayamo goi Yakobo doiyana taiyao sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Sikaiyaka aaa, tuta tayamo Lebani doiyana ilatuwoko, idigo kana, ‘Moitamo kom osiyagu, tauna neta kom kupaisewa yau manugu, latuwogu aemaisim. Kulatuwokoigu aivina goi aemaisim?’ ");
INSERT INTO gvs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ego Lebani natunao vevina adi taiyuwo sikaaiyaka, botomoya yoina Reya, e bogomane yoina Reitiyeli. ");
INSERT INTO gvs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Reyayana vavina kubuunuwaina go, ana gómana Reitiyeli vavina gumaboina toina. ");
INSERT INTO gvs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","E Yakobo Reitiyeli igite nuwona ikabi toina, tauna Lebani ilatuwoko idigo kana, ‘Bei apaaisewa tala ainima aiyuwo goi go, kom am bogomane Reitiyeli kutagone anai.’ ");
INSERT INTO gvs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","E Lebaniyana idigo kana, ‘Dedevina. Bei avinim, govila ituli ta koroto ima ikabi inai. Tuwo yaigu goi kwaiyāka kupaaisēwa gobe avinim.’ ");
INSERT INTO gvs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tuwo moitamo tala ainima aiyuwo goi ipaaisewa bego Reitiyeli ikabi inai go, ina matakoi Reitiyeli yaina pasina ina nuwonúwana paisewayana moe tuta giyaina. ");
INSERT INTO gvs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Sikaaiyaka, sikaaiyaka, tala ainima aiyuwoyadi sikavava, e Yakobo doiyana Lebani ilatuwoko, idigo kana, ‘Natum kuvinīgu monegu bei taiyao katuyuwo. Guna tuta bogina alukavave.’ ");
INSERT INTO gvs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tuwo Lebani idi nai aikanina gagaina iwodugu go, toni kasa liliudi iduduwedi sima taiyao sikáika. ");
INSERT INTO gvs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Sikáika ikavava, vanuwo bogina isabamgo, Lebani natuna Reya ikabi inave Yakobo yaina goi bego taiyao simasisi, e moe bogina bei sinai. Kina go Yakobo ina nuwonúwana kana, ‘Reitiyeli bogina anai.’ Go Reitiyeli geya, go sem Reya taiyao simasisi, sinai! ");
INSERT INTO gvs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ego Lebani ina pákwana vavina yoina Silipa ikabi, Reya ivini bego kina ina pákwana. ");
INSERT INTO gvs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","E Yakobo ma monena simasisi vanuwo itomo, Yakobo itáoya ikandobala Reitiyeli geya, go sem Reya igitebabane. Tuwo ina doiyana Lebani ilatuwoko idigo kana, ‘Ame kaga kuguinuwe yau yaigu? Manakae? Yau im paisewa apaisewe Reitiyeli manuna gea geya? Moitamo Reitiyeli manuna ae? Go kom kaga unana kwatubaugu?’ ");
INSERT INTO gvs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Go kina Lebaniyana idigo kana, ‘Moe geya kai ima sinapu geya. Geya itoboineyeta bogomane igiminai. ");
INSERT INTO gvs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Go tuwo, om inuwa. Nai aikanina ame tauyana manuna taguinūwe wiki ame goi. Ikavava, bogomane avinim kunai go, kom tala ainima aiyuwo tuwaina kupaaisēwa manugu.’ ");
INSERT INTO gvs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Tuwo moitamo nakae Yakobo itagona. E aikayana silukavave, Lebani natuna Reitiyeli ikabi, Yakobo ivini monena. ");
INSERT INTO gvs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ego Lebani ina pákwana yoina Bila ikabi, Reitiyeli ivini ina pákwana. ");
INSERT INTO gvs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Tuwo Yakobo Reitiyeli taiyao simasisi sinai. E Reitiyeli imatakoiye gagaina namliyeta Reya. Tala ainima aiyuwo tuwaina ipaaisewa Lebani manuna. ");
INSERT INTO gvs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","E tuwo sikaaiyaka, Yauwe ikandosobu Reya igite ana matakoi giyaina, tuwo ina guinuwa goi Reya itoboine ikéuwama, go sem Reitiyeli ikágala. ");
INSERT INTO gvs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Tuwo moitamo Reya ikéuwama ivenátuna, natuna koroto. Tuwo idigo kana, ‘Yauwe guna kaiyakomou bogina igite. Nakona ame tutayana monegu bei imatakoiyegu.’ Moe pasina tauna natuna ivayou Rubeni. ");
INSERT INTO gvs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Aiyuwoina ikéuwama, ivenátuna, natuna koroto, kana, ‘Yauwe itagona aavenátuna unana inove bego Yakobo geya imatakoiyeguta.’ Tuwo natuna ivayou Simioni. ");
INSERT INTO gvs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Sivatonina ikéuwama ivenátuna, natuna koroto, kana, ‘Nakona ame tutayana monegu bei ilokategu. Natunao adi taito bogina avini.’ Tuwo natuna ivayou Livai. ");
INSERT INTO gvs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Sivavasina ikeuwamako ivenátuna, natuna koroto, kana, ‘Ame tutayana Yauwe ayapaliye.’ Tuwo natuna ivayou Yuda. Go Reyayana ivenatunaupa. ");
INSERT INTO gvs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","E Reitiyeli tuwowona igite bogina ivenátuna, natunao adi badabada adi taivasi go, kina geya tayaamo ivenatuni Yakobo manuna. Tauna tuwowona ivakipikipiye. Tuwo Yakobo ilatuwoko idigo kana, ‘Yakobo, gogómana kuvinīgu go, neta geya, bei akámasa!’ ");
INSERT INTO gvs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tuwo Yakobo gamona igoyo ibolagu, idigo kana, ‘Manakae? Yau Yaubada nakae? Moe Yaubada ina guinuwa goi kom kukágala, yau geya!’ ");
INSERT INTO gvs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","E kina Reitiyeli idigo kana, ‘Gwa, guna pákwana Bila kwābi, taiyao komasīsi, e ikéuwama, ivenátuna yau manugu. E ina venatunayana goi yau nakae bei ma natugu.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tuwo moitamo Reitiyeli ina pakwanayana Bila ikabi, Yakobo ivamonene. Moe monena aiyuwoina nakae go, taiyao simasisi, e ikéuwama. ");
INSERT INTO gvs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Ikéuwama, ivenátuna, moe Yakobo natuna koroto ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","E Reitiyeli idigo kana, ‘Yaubada itakinoigu yau todedevigu. Guna kawanoi inove, e natugu koroto ivinigu.’ Moe pasina natuna ivayou Dani. ");
INSERT INTO gvs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Niga aiyuwoina simasisi, e Bila ikéuwama. Ikéuwama, ivenátuna, moe Yakobo natuna koroto aiyuwoina ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","E Reitiyeli idigo kana, ‘Yau tuwowogu taiyao bogina kapoikíkina Yaubada ina uyáwana manuna go, yau atogaga.’ Tuwo natuna ivayou Napatali. ");
INSERT INTO gvs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","E kina Reya iyagoi bogina ivenatunaupa, tuwo ina pákwana vavina Silipa ikabi, Yakobo ivamonene, e tauyana monena aiyuwoina nakae. ");
INSERT INTO gvs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ivamonene, taiyao simasisi, Silipa nakae ikéuwama. Ikéuwama, ivenátuna, moe Yakobo natuna koroto ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Tuwo kina Reyayana mana uyáwana idigo kana, ‘Guna dedevina bogina ababane!’ Tuwo natuna ivayou Gadai. ");
INSERT INTO gvs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Reya ina pakwanayana aiyuwoina ikéuwama, e ivenátuna, moe Yakobo natuna koroto ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Tuwo Reyayana idigo kana, ‘Nakona vevina liliudi bei sivayokoigu uyaaonigu. Tauna auyáwana gagaina!’ Tuwo natuna ivayou Aseri. ");
INSERT INTO gvs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Sikaiyaka, sikaiyaka, witi ana dibayoya ana tuta Rubeni ina tánuwo goi go, náuna mandareki ibabane bogina ikéuwo, tuwo keuwoina maniyedi iguwedi. Iguwedi ikavava, imedi sinana Reya ivini. Ago Reitiyeli keuwoinayadi igitedi, inuwonúwana kana, ‘Neta akanidi, bei akéuwama.’ Tuwo idigo kana, ‘Tuwowogu, natum ana mandareki keuwoina maniyedi kuvinīgu akáika.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Go kina Reyayana ivagágala, idigo kana, ‘Kom manakae? Moe igoyo boi monegu kuneboigu. Go manakae? Ame tutayana latuwom natugu ana mandareki keuwoina nakae kuneboigu ae? Geya!’ Tuwo Reitiyeliyana idigo kana, ‘Neta keuwoinayadi kuvinigu, atagona sabamgo ame goi Yakobo kom taiyao komasisi.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tuwo moitamo lavilavi goi Yakobo tánuwo goi ima go, Reya ina ivalobode, ilatuwoko idigo kana, ‘Monegu, sabamgo ame goi itoboine yau taiyao tamasisi. Natugu ana mandareki keuwoina goi agimonem.’ Tuwo sabamgo amo goi taiyao simasisi. ");
INSERT INTO gvs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","E Reya ina kawanoi Yaubada bogina inove, tuwo ina guinuwa goi Reya itoboine ikeuwamamna. Ikéuwama, ivenátuna moe Yakobo natuna koroto ainimaina ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ago Reyayana idigo kana, ‘Guna pákwana monegu avini bego monena nakae, tauna ame guna vaiwówana Yaubada ivinigu.’ Tuwo natuna ivayou Isakara. ");
INSERT INTO gvs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","E Reya aiyuwoina ivenátuna, moe Yakobo natuna koroto ainima tayamoina ivenatuni. ");
INSERT INTO gvs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","E Reyayana idigo kana, ‘Yaubada yabobona dedevina toina bogina ivinigu. Nakona ame tutayana Yakobo bei iwowoinegu unana natunao ainima tayamo bogina avenatunidi.’ Tuwo natuna ivayou Sebuloni. ");
INSERT INTO gvs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Niga go ivenátuna, natuna vavina, e ivayou Daina. ");
INSERT INTO gvs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","E amo tutayana Yaubada Reitiyeli inuwaisi nakae ina kawanoi inove, tuwo ina guinuwa goi Reitiyeli ina kágala ikavava. ");
INSERT INTO gvs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tuwo Yakobo taiyao simasisi, e ikéuwama. Ikéuwama, ivenátuna, natuna koroto, e idigo kana, ‘Guna omayamaya Yaubada bogina ikabi, inave.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kana, ‘Guna kawanoi bego Yauwe natugu aiyuwoina ivinigu.’ Tuwo natuna ivayou Iyosepa. ");
INSERT INTO gvs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","E Iyosepa ana bíbina mlina, Yakobo ina doiyana Lebani ilatuwoko, idigo kana, ‘Doiyagu, monegowo be natugowo kuvinīgu bei kana guna kasa. Guna paisewa tauyadi manudi bogina ikavava. Kom bogina kuyagoi guna paisewayana madabokina dedevina yaim. Ame tutayana kutagōna monegowo be natugowo akabidi, kana guna kasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Go kina Lebaniyana idigo kana, ‘Doiyagu, neta kusoosalegu, e kwaiyāka yau taiyao. Bogina kuyagoi, guna kokósala goi ayagoi kom pasim Yauwe ikaipakuyegu. ");
INSERT INTO gvs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tuwo kwaiyāka ameko be kupaaisēwa manugu. Am maisa kulatuwokōigu bei aemaisim.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Go kina Yakoboyana idigo kana, ‘Kom kuyagoi magu salau apaaisewa manum nakae guna matakavata goi im sipi sisusáila badabadaidi. ");
INSERT INTO gvs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Kunuwaisi, boi mainao ama kom im sipi geya sibadebadeta go, ame bogina sisusáila gagaina. E kaga aguinuwe im sipiyadi manudi, e guinuwayadi pasidi Yauwe ikaipakuyem. Go manakae? Ava tuta goi bei kutagonegu bego apaisewa yau guna bodao manudi?’ ");
INSERT INTO gvs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Tuwo kina Lebaniyana idigo kana, ‘Kaga latuwom avinim?’ E Yakoboyana idigo kana, ‘Geya tayaamo kaga latuwogu kuvinigu, go sem neta dogoi tayamo bei alatuwokoim kuguinuwe, bei akaaiyaka im sipi amatakavatedi. ");
INSERT INTO gvs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Dogoiyana ame nakae: Ame bei im yoguyoguyao akiwotaidi gúguna aiyuwo. Gúguna tayamo sipi be goti wowodi kaupolapolaidi be nakae lami wowodi kalaakovidi kaka. Go gúguna tayamo sipi wowodi poowoudi kaka be nakae goti wowodi kalaakovidi kaka. E niga tutayana sivenátuna, ava yoguyoguva wowodi kaupolapolaidi, e moe yau guna yoguyoguyao. ");
INSERT INTO gvs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Nava bei itoboinem guna yoguyoguyao kugitedi, e bei kuyagoi yau guna guinuwa yaim moe akibobosidoko gea geya. Neta guna yoguyoguyao yaidi lami tayamo o goti tayamo kubabane wowona poowouna kaka, bei kuyagoi yoguyoguyana avainao kom yaim.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lebaniyana kana, ‘Dedevina! Kaga liliuna kuudigedi bei taguinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Go amo maliyalinayana goi Lebani doiyana Yakobo geya inumiseyeta, tauna ame nakae iguinuwe: Tauyana ina gotiyao bolamo wowodi neta sabasabaidi o kaupolapolaidi be ina gotiyao bovavina liliudi neta wowodi sabasabaidi o kaupolapolaidi go, poowoudi be nakae ina lamiyao kalaakovidi ikabidi, natunao ivinidi simatakavatedi. ");
INSERT INTO gvs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","E ilatuwokoidi sikabidi maliyalina aito nakae sinavedi. Go Lebani ina sipiyao wowodi poowoudi kaka be ina gotiyao wowodi kalaakovidi kaka Yakobo imatakavatedi. ");
INSERT INTO gvs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","E sipiyadi be gotiyadi Yakobo igitedi, bogina iyagoi. Tauna itáoya ina alova aito laonidi badabadaidi italaidi. Italaidi, imedi iseselitaotaoidi. Ina sesalayana ame nakae: Sakava maniyena iseselidi go, maniyena geya. Tauna alovayadi sabasabaidi. ");
INSERT INTO gvs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Iseselidi ikavava, laonidiyadi ikabidi, yoguyogu idi kaba nim goi ivataoedi. Ego tutayana yoguyoguyadi sima bwae sinim, siiváunuwo. ");
INSERT INTO gvs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Tuwo nakae iguuinuwe. Yoguyoguyadi sima bwae goi, e laonidiyadi sigitedi sikatonoidi, e siváunuwo. Niga sivenátuna natudiyao wowodi kaupolapolaidi o sabasabaidi. ");
INSERT INTO gvs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","E tutayana sivenátuna, natudiyao ikiwotaidi gúguna ituli. Yoguyogu gagaidi ikabidi, imedi yoguyogu kaupolapolaidi matadi goi sikaaiyaka. Tutayana siváunuwo yoguyogu kaupolapolaidi kaka sigitedi sikatonoidi, e bei sivenátuna, natudiyao kaupolapolaidi. E tauna ame nakae kenaoyana goi Yakobo ina yoguyoguyao ivaituwedi sibadabada go, Lebani geya. ");
INSERT INTO gvs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","E ava yoguyoguva neta bobíbina siváunuwo, e laonidiyadi Yakobo ivataoedi idi kaba nim goi bego sigitedi sikatonoidi. ");
INSERT INTO gvs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Go ava yoguyoguva neta bagabagaidi siváunuwo, e laonidiyadi geya ivataoedita. Tauna Lebani ina yoguyoguyao bagabagaidi go, Yakobo ina yoguyoguyao bobíbina. ");
INSERT INTO gvs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Moe nakae tauna Yakobo iguyau gagaina. Ina sipiyao be nakae ina gotiyao badabadaaidi. Aiyuwoina ina pakonayao koroto be vevina be nakae ina kameriyao be ina ase badabadaaidi. ");
INSERT INTO gvs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","E Yakobo vala inove bego Lebani natunao koroto sikúluwo sidigo kadi, ‘Tamada konana madabokidi Yakobo isonanedi. Yakobo ina esaesa madabokina moe tamada ina esaesa isonane.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Aiyuwoina Yakobo igite Lebani maisina, e bogina iyagoi Lebaniyana ina sinapu ituli. Boi Yakobo ikabivekovekoe go, ame tutayana geya. ");
INSERT INTO gvs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","E Yauwe Yakobo ilatuwoko, idigo kana, ‘Yakobo, kwaluvīla kūna tamam be nakae osemowo idi kasa goi. Yau bei avakitaum.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","E tuwo Yakobo yoguyogu imatakaavatedi, e livala ietune ina Reitiyeli be Reya yaidi idigo kana, ‘Ame tutayana yoguyogu amatakaavatedi go, ami taiyuwo kōma alatuwokoimi.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Tuwo sima Yakobo ilatuwokoidi idigo kana, ‘Bogina agite tamami ina kabivekoveko yau yaigu geya nakae boi mainao. Go tuwo tamagu ina Yaubada ivakiitaugu. ");
INSERT INTO gvs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Komi bogina koyagoi bego magu salau apaaisewa tamami manuna. ");
INSERT INTO gvs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","E kina go tamamiyana ivaobugu nakae tuta tuta guna maisa ikaisobuye go, Yaubada geya itagoneyeta bego iyogedegedegu. ");
INSERT INTO gvs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Neta tamami idigo kana, “Sipi kaupolapolaidi moe kom im yoguyoguyao”, e sivenátuna natudiyao madabokidi kaupolapolaidi. Go neta kana, “Sipi sabasabaidi moe kom im yoguyoguyao”, e sivenátuna, natudiyao liliudi sabasabaidi. ");
INSERT INTO gvs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Tuwo tamami ina yoguyoguyao madabokidi Yaubada inebo go, ivinigu. ");
INSERT INTO gvs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Boi yoguyogu idi váunuwo ana tuta goi sabamgo tayamo akanamimi. Guna kanamimiyana goi akandolaga goti bolamo agitedi liliudi sabasabaidi o kaupolapolaidi siiváunuwo bovavina taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","E Yaubada ina anerose ilatuwokoigu idigo kana, “Yakobo!” “U, amegu”, kaegu. ");
INSERT INTO gvs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Aneroseyana idigo kana, “Kwandolāga goti bolamo liliudi kugitēdi sabasabaidi o kaupolapolaidi bovavina taiyao yau guna lovina goi siváunuwo. Lebani ina guinuwa liliuna yaim goi bogina agite. ");
INSERT INTO gvs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Yau Yaubada boi asa Beteli goi toinigu asowóduwo yaim. Amoko goi boi dídiya tayamo kwabi, kuvatáoe. Ikavava oribe putumina kwabi didiyayana goi kusiwoi. Moeko goi didiyayana bogina kiinavaina Yau umagu. Ikavava, kukatótula yaigu. Tauna ame tutayana kutāoya, ame poyapoyayana kwalāve go, kwaluvīla kūna im kasa toina.”’ ");
INSERT INTO gvs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tuwo Reitiyeli be Reya sidigo kadi, ‘Tamama konana liliudi sikavava, tauna geya tayaamo kaga ikaaiyaka ima dalowo manuna. ");
INSERT INTO gvs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aiyuwoina ina guinuwa yaima nakae neta kai ituli ta boda. Moitamo. Tauyana ikaigimonema konana ikabi go, bogina isikolakolave. ");
INSERT INTO gvs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tamama ina esaesa Yaubada ikabi, kom ivinim moe kai be nakae natumao ima esaesa nakae. Tauna kuguinūwe nakae Yaubada bogina ilatuwokoim.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","20","E tuwo tuta tayamo Lebani guma Aram ina ina sipi unuunudi ikupoidi. Iikupoidi go, kina Yakobo konana liliudi Padani Aram goi iikabidi ikatubayasidi bego ina bodao taiyao sisiya. Ego Lebani isalupapaiye, geya ilatuwokoeta bei sina. Yakobo ikatuubayasi go, kina Reitiyeli ina tamana ina vada goi isiu ina tamana ina tokwalu ivainaoidi. E Yakobo ikatubayasi ikavava, ina kameri ikabidi, natunao be monenao toludi goi ikailagasidi. Ago ina yoguyoguyao sivakumgo, ilobutudi silokoina. E tuwo tauyadi sisiya bego sina Yakobo tamana Aisake ina kasa Kenani goi. ");
INSERT INTO gvs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Madabokidi sisiya sina sákala Yuparetisi sivadamane go, matadi goi Giliyadi koyaidi sikaaiyaka, e bego sina maeko. ");
INSERT INTO gvs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Go maliyalina aito sikavava, e Lebani livala inove bego kidi Yakobo sisiya. ");
INSERT INTO gvs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tuwo osenao ikabidi, e sina kidi Yakobo sivatapiyedi. Maliyalina ainima aiyuwo goi sivataapiyedi, e sima Giliyadi koyaidi butumidi goi tauyadi sivakakana. ");
INSERT INTO gvs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ego sabamgo tayamo goi Lebaniyana ikanamimi. Ina kanamimiyana goi Yaubada isowóduwo Lebani guma Aram yaina idigo kana, ‘Lebani, am dodōkana. Taabu Yakobo kuubōve.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Vanuwo itomo, Lebani kidi sinonoina go, tutayana Yakobo mana bodao goi sivakakana, e tauyadi idi yoyou parai Giliyadi koyaidi goi bogina siyowo. Tuwo kidi Lebani nakae idi yoyou parai siyowo. ");
INSERT INTO gvs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","E Lebaniyana ina Yakobo ilatuwoko idigo kana, ‘Yakobo, ame kaga kuyaniyani? Kom kusalupapaiyegu. Kaga unana natugowo kwabidi kunavedi nakae neta yaviya goi kuyoisidi? ");
INSERT INTO gvs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kaga unana kosiyagau nakae kusalupapaiyegu? Latuwogu bego avaduduwedokoimi uyáwana be vesi goi be nakae girada goi be api goi. ");
INSERT INTO gvs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kom geya kutagoneguta bego natugowo be tubugowo ayowoiidi. Im guinuwa goi dabam itapavívila! ");
INSERT INTO gvs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Yau magu togaga itoboinegu bei ayogedegedem go, nuwobuna tamam ina Yaubada ima ikatuwoinigu idigo kana, “Taabu Yakobo kuubōve.” ");
INSERT INTO gvs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","E ayagoi kom latuwom toina kwaluvila kuna tamam yaina, tauna kukalavema go, kaga unana guna tokwalu kuvainaoidi?’ ");
INSERT INTO gvs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Go kina Yakoboyana idigo kana, ‘Kasiya unana amatoita. Guna nuwonúwana kagu, “Asiya govila bei Lebani natunao be tubunao ineboigu.” ");
INSERT INTO gvs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Go im tokwalu sem, sedao matadi goi kulusalēdi. Neta ameko goi kubabanedi, e avatau ivainaoidi takaumate. Ava konam kubabane, e kwābi.’ E Yakobo inuwonúwana Lebani ina tokwaluyadi manudi ibágala, tauna moe nakae ibóbwara. Kom go vatau? Tokwaluyadi Reitiyeli ivainaoidi! ");
INSERT INTO gvs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tuwo Lebani ina Yakobo ina yoyou parai isiu, ilusala, geya. Ikavava, ina Reya ina yoyou parai goi isiu ilusala, geya. Ikavava, ina Reya ina pakonayao vevina adi taiyuwo idi yoyou parai goi isiu ilusala, geya. Tuwo ina Reitiyeli ina yoyou parai goi isiu ilusala. ");
INSERT INTO gvs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ego tokwaluyadi Reitiyeli bogina ivamoudi ina wasare kameri toluna goi sikaaiyaka go, wasareyadi yatadi goi itulagalaga. E yoyouyana madabokina goi Lebani ilusala, geya ibabanedita. ");
INSERT INTO gvs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Tuwo isowóduwo ibala ina Reitiyeli kikina goi go, Reitiyeliyana ipola idigo kana, ‘Tomoya, geya kuegamogamoguyeguta go, matam goi geya itoboineguta atáoya unana gamogu igeda.’ Tuwo Lebaniyana ina tokwalu ilusaledokoidi go, geya ibabanedita. ");
INSERT INTO gvs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","E Yakobo bogina gamona igoyo, e Lebaniyana iboove, idigo kana, ‘Kaga guna kadoinana yaim? Kaga guna bágala bego kuma kuvatapiyegu? ");
INSERT INTO gvs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Konagu liliudi goi bogina kulusala go, ava konam kubabane? Konamyana kwaiwodūwe kom semowo be nakae yau segowo yaidi, e bei sitakinoida. Tagite avatau ibágala, kom gea yau. ");
INSERT INTO gvs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tala ana badabada 20 bogina akaaiyaka yaim. Im sipiyao bovavina be im gotiyao bovavina sivenatuna dókana. Geya tayaamo tuta im sipi bolamo akani. ");
INSERT INTO gvs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Neta woiwoi sima sipi sikaumatedi, toinigu akatumapum. Neta sabamgo o maliyalina goi koroto sima sipi sivainaoidi, kom kam, “Am puwoya, kwatumapugu.” ");
INSERT INTO gvs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Guna kaiyaka ame nakae: Maliyalina goi níyala ivakaigaga dabagu ivayavisi go, sabamgo goi gogou akámasa, tauna geya amasiisi dókana. ");
INSERT INTO gvs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Moe nakae akaaiyaka yaim tala ana badabada 20. Tala yawou aivasi goi natumowo manudi apaaisewa. Tala ainima tayamo goi im yoguyoguyao manudi apaaisewa go, tuta tuta guna maisa kwaisobuye. ");
INSERT INTO gvs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Neta tamagu Aisake ina Yaubada, Tauyana tokatumatoita be nakae tubugu Eberamo ina Yaubada, geya ivakitauguta, e moitamo kom nakona kuvalilivegu nima kaka. Ago Yaubada guna mou be guna salau bogina igitedi, tauna nuwobuna ibowoim!’ ");
INSERT INTO gvs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","E Lebaniyana idigo kana, ‘Go ame vevinayadi yau natugowo! Ame gogomanayadi yau tubugowo! Ame yoguyoguyadi yau guna sipiyao! Kaga liliuna kugite moe yau konagu! Go geya kada tayaamo kaga itoboinegu aguinuwe bego sikaiyaka yaigu. ");
INSERT INTO gvs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Go tuwo bokoyo kom be yau takanasíuna. Go ida kanasiuna ana kaba kinana taodugu bei anasiunayana tanuwokavate.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tuwo Yakobo dídiya tayamo ikabi, ivatáoe adi katótula ana kaba kinana manuna. ");
INSERT INTO gvs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ikavava, senao ilatuwokoidi idigo kana, ‘Kōna gurewa kokabīdi, komēdi.’ Tuwo sina gurewa sikabidi, simedi go, sivagugunidi. Sivagugunidi ikavava, gugunayana kikina goi Lebani be Yakobo taiyao sikáika. ");
INSERT INTO gvs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ego gugunayana Lebani ivayou Iyegara Seyaduta go, kina Yakobo ivayou Galeyedi. ");
INSERT INTO gvs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","E Lebani idigo kana, ‘Ame gugunayana ida kaba kinana yaida.’ E moe pasina ivayou Galeyedi. ");
INSERT INTO gvs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ego youyuwoina ivayou Mispa unana idigo kana, ‘Yauwe bei iyauseda tutayana kom yau taiyao geya takaiyaketa, e bei ida katótula takabikaone. ");
INSERT INTO gvs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Neta im guinuwa igoyo natugowo yaidi o neta vevina tuwaina kwabidi monemowo, nakona geya vatau tayaamo bei igitem, go sem Yaubada bei igitem, tauna iyagoi.’ ");
INSERT INTO gvs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","E Lebani Yakobo ilatuwoko idigo kana, ‘Gwa! Ame gugunayana bogina avaguguni be nakae ame didiyayana bogina avatáoe sikaaiyaka kom be yau nauyayanaida. ");
INSERT INTO gvs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ame gugunayana be nakae ame didiyayana kiyakiyaya tayamo. Kiyakiyayayana ame nakae: Yau geya asaidamaneyeta bego ayogedegedem. Kom nakae geya kusaidamaneyeta bego kuyogedegedegu. ");
INSERT INTO gvs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Bei Eberamo ina Yaubada be Nakori ina basaleliu, moe tamadi idi basaleliuyao siliuneda neta yau ayogedegedem o kom kuyogedegedegu.’ Tuwo Yakobo tamana Aisake ina Yaubada tokatumatoita goi ikatótula. ");
INSERT INTO gvs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ikatótula ikavava, koya goi yoguyogu ikabi, ikaumate, igabu, e Yaubada yaina ikasale. Igabu ikavava, osenao iduduwedi sima taiyao sikáika. Sikáika ikavava, simasisi. ");
INSERT INTO gvs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Simasisi vanuwo itomo, sitáoya go, Lebani tubunao be natunao ivayavaudi be ikaipakuyedi. Ikaipakuyedi ikavava, ikalavedi go, ikaluvila ina ina kasa. ");
INSERT INTO gvs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","E kina go Yakobo mana bodao nakae sitáoya Lebani sikalave go, siketoiya. Siketoiya sinonoina go, Yaubada ina aneroseyao sima Yakobo sivalobode. ");
INSERT INTO gvs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","E Yakobo igitedi idigo kana, ‘Ame Yaubada ina tovayaviyayao!’ Tuwo amo asayana ivayou Makanaim. ");
INSERT INTO gvs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","E Yakobo ina lobutu adi tolokoinayao ietunedi sivakumgo sina tuwowona Iso yaina, tauyana ikaaiyaka Seira goi, moe Idom dadavina. ");
INSERT INTO gvs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ego mainao tolokoinayadi ilatuwokoidi kana, ‘Kōna tuwowogu Iso kolatuwōko kami, “Guna tomoya, yau Yakobo im pákwana boi asuvaadavada Lebani taiyao go, ame bogina akaluvilamna. ");
INSERT INTO gvs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Guna bulumakau, guna ase, guna sipiyao, guna gotiyao be guna pakonayao vevina be koroto amedi. E tauna tomoya, ame livalayana aetune iwo yaim bego kusosalegu.”’ ");
INSERT INTO gvs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tuwo moitamo tolokoinayadi silokoina sina Iso silatuwoko. Silatuwoko ikavava, sikaluvila sima Yakobo silatuwoko kadi, ‘Tuwowom Iso bogina kalatuwoko. Tauyana imamaima bego ivalobodem go, koroto adi badabada 400 taiyao simamaima.’ ");
INSERT INTO gvs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","E livalayana Yakobo inove, imatoita be nakae atena iyova. Tuwo ina bodao ikiwotaidi boda aiyuwo. Aiyuwoina ina yoguyoguyao, moe ina sipi, ina bulumakau be ina kameri ikiwotaiyuwedi. ");
INSERT INTO gvs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ina nuwonúwana kana, ‘Neta Iso ima boda tayamo ilauidi, imaiko go, boda tayamo itoboinedi sisiya dedevidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","E ikiwotaidi ikavava, ikawanoi Yaubada yaina, idigo kana, ‘Tubugu Eberamo be tamagu Aisake idi Yaubada, kunovēgu. Yauwe, boi kom kulatuwokoigu kam, “Kwaluvīla kūna im kasa be nakae osemowo yaidi, e bei ayabobonem.” ");
INSERT INTO gvs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Yau im pákwana nakae, yau giyaigu go, tuwo bogina kulokategu be nakae im guinuwa goi kom aba numisa yau yaigu tuta liliuna. Moe moitamo. Boi nimatu kulatuwokoigu ana Lebani goi akaaiyaka go, sákala Iyoridani ame boi asaidamane, guna kaituko kaka akavale. Go sem ame tutayana bogina aguyau be nakae asusáila, boda aiyuwo sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ame tuta tuwowogu Iso yaina kuyavēgu. Amatoita tauyana bei ima vevina ma natudiyao be yau ilauima. ");
INSERT INTO gvs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kunuwaisi boi kom bogina kulatuwokoigu kam, “Bei ayabobonem be nakae akisailim, im boda adi badabada nakae ediédila mamaya goi, geya itoboinemta kwatuyaividi.”’ ");
INSERT INTO gvs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","E tuwo amoko goi ikaaiyaka imasisi. Ego ina yoguyoguyao maniyedi ikabidi, bei tuwowona Iso ivini, ina yabobona. ");
INSERT INTO gvs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yoguyoguyadi ame nakae: Yoguyogu Badabada Goti bovavina 200 Goti bolamo 20 Sipi bovavina 200 Sipi bolamo 20 ");
INSERT INTO gvs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kameri bovavina ma bonatudiyao 30 Bulumakau bovavina 40 Bulumakau bolamo 10 Ase bovavina 20 Ase bolamo 10 ");
INSERT INTO gvs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ago yoguyoguyadi ikiwotaidi yáuwo ituli ituli. Ikiwotaidi ikavava, e ina pakonayao ilatuwokoidi idigo kana, ‘Koroto tamo tamo yáuwo tamo tamo imatakavate. E kovakūmgo go, taabu koolamgōgana, go sem imi ketoiya kovaamasāba.’ ");
INSERT INTO gvs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","E yáuwo vakuumgoina ana tomatakavata ilatuwoko idigo kana, ‘Tuwowogu Iso bei ivalobodem be ilumadadem kana, “Im tomoya avatau? Nako kunonoina? Ame avatau ina yoguyoguyao?” ");
INSERT INTO gvs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tutayana nakae ilumadadem, kom kam, “Ame im pákwana Yakobo ina yoguyoguyao. Ame ietunegu amedi avinim, ame nakae ina yabobona kom guna tomoya yaim. Ago tauyana mligu goi imamaima.”’ ");
INSERT INTO gvs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","E yáuwo adi tomatakavatayao tamo tamo nakae ilatuwokoidi, idigo kana, ‘Tutayana Iso kobabane, nakae bei kolatuwoko. ");
INSERT INTO gvs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ego konuwookavāte kami, “Im pákwana Yakobo mlima imamaima.”’ Yakobo ina nuwonúwana kana, ‘Ame yoguyoguyadi moe guna yabobona sivakumgo go, yoguyoguyadi goi anúwala tauyana yaina bei guna goyo inuwotao go, agu gogo yaina bei dedevina.’ ");
INSERT INTO gvs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tuwo ina yoguyoguyadi sivakumgo sina go, Yakoboyana ina yoyou parai goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","E vanuwo bogina isabamgo, Yakobo itáoya monenao adi taiyuwo, ina pakonayao adi taiyuwo be natunao koroto yawou tayamo ietunedi sivakumgo sina sákala Yaboka sisaidamane. ");
INSERT INTO gvs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","E ina pakonayao nakae ilatuwokoidi kónana sikavaledi mlidi sisaidamanedi. ");
INSERT INTO gvs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","E kina anetava ikaaiyaka. Ikaaiyaka go, koroto tayamo isowóduwo ima Yakobo iyoisi taiyao sivadidídina ana kadókana botomotomo. ");
INSERT INTO gvs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","E korotoyana igite bego geya itoboineyeta Yakobo ikalisave, tuwo Yakoboyana sokisokina luluna ikikapusi, e dibuwatuna itakapusi. ");
INSERT INTO gvs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","E korotoyana idigo kana, ‘Kwalavēgu! Bogina botomotomo.’ ‘Geya akalavemta ana kadókana kukaipakuyegu’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","E korotoyana idigo kana, ‘Yoim manakoyoina?’ ‘Yoigu Yakobo’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","E korotoyana idigo kana, ‘Bogina kuvayaviya Yaubada be koroto yaidi goi go, kom kukalisavedi. Tauna geya tuwaina yoim Yakobo, go sem kom yoim Isileli.’ ");
INSERT INTO gvs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","E Yakoboyana idigo kana, ‘Siyagu, kom yoim manakoyoina?’ Go korotoyana idigo kana, ‘Kaga kulumadadanae yoigu manuna?’ Go amoko goi Yakoboyana ikaipakuye. ");
INSERT INTO gvs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","E Yakobo idigo kana, ‘Yaubada maisina agite go, geya availaita.’ Tauna moe pasina asayana ivayou Paniyeli. ");
INSERT INTO gvs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","E níyala itukotuko go, Yakobo itáoya Panuweli ikalave. Ego sokisokina itakapusi, tauna isakau. ");
INSERT INTO gvs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tauna Isileli tubunao ame tutayana yoguyogu sokisokina luluna goi woliwoli poowouna geya sikanikani unana Yaubada boi Yakobo sokisokina luluna ikikapusi, tauna woliwoliyana geya sikanikani. ");
INSERT INTO gvs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","E tuwo Yakobo Paniyeli ikalave iketoiya go, ikandobala Iso igite imamaima ina korotoyao poa andedi (400) taiyao. Tuwo natunao ikiwotaidi Reya, Reitiyeli be nakae ina pakonayao adi taiyuwo yaidi. ");
INSERT INTO gvs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ina pakonayaoyadi ma natudiyao ilatuwokoidi sivakumgo. Mlidi Reya ma natunao. Reitiyeli ma natuna Iyosepa sivámliya. ");
INSERT INTO gvs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","E Yakoboyana ivakumgo ina tuwowona matana goi sivanima sivayuwo ivatuguyalako ikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Go Iso ilokoina ina Yakobo ivayavau nukotona goi iyoisi, iyowoi. Tuwo adi taiyuwokova sitáiya. ");
INSERT INTO gvs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Sitáiya ikavava, Iso imatavilavila vevina be gogómana igitedi, e idigo kana, ‘Ame tauyadi avatauwa?’ ‘Yau im pákwana, Yaubada ikanuwoiyegu, e ame natugowo ivinigu’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","E Yakobo ina pakonayaoyadi ma natudiyao sima sivatugúyala sikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Reya nakae ma natunao sima sivatugúyala sikanakabobo. Tauyadi mlidi Iyosepa be Reitiyeli sivámliya sima sivatugúyala sikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","E Isoyana idigo kana, ‘Go maine boda madi yoguyogu ababanedi. Moe kaga yoguyoguna?’ ‘Guna tomoya, bego kusosalegu’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","E Iso idigo kana, ‘Guna gómana, tuwo. Yau guna yoguyoguyao badabadaidi. Moe kom im yoguyoguyao.’ ");
INSERT INTO gvs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Go kina Yakoboyana idigo kana, ‘Geya. Neta kusoosalegu, e guna yabobona kuuyaone. Unana maisim agite moe nakae Yaubada maisina agite go, geya akamaseta, go sem mam nuwotao kuuyaonegu. ");
INSERT INTO gvs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Tuwowogu, guna yabobona aavinim kwābi unana Yaubada ikanuwoiyegu, e yau guna yoguyoguyao badabadaaidi, tauna bogina yoiyagu.’ Tuwo Yakobo ilumakikine ana kadókana Iso itagona, e yoguyoguyadi ikabidi. ");
INSERT INTO gvs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","E Iso idigo kana, ‘Tao. Yau avakedemi.’ ");
INSERT INTO gvs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Go kina Yakoboyana idigo kana, ‘Guna tomoya, bogina kuyagoi gogómana sineneta be nakae yoguyogu maniyedi ma natudiyao. Tauna geya itoboinedita maliyalina ana madabokina goi siiketoiya, govila bei sikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tuwo guna tomoya, kom kuvakūmgo go, kai im pakonayao manukaima kavámliya kao Seira goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","E Isoyana idigo kana, ‘Siyagu, neta moe nakae, guna topaisewa maniyedi sikaiyaka be sivaitem.’ Go Yakobo idigo kana, ‘Moe tuwo. Guna tomoya, bogina kusosalegu. Ame tauna.’ ");
INSERT INTO gvs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","E tuwo Iso ina Seira goi. ");
INSERT INTO gvs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","E kina go Yakoboyana geya inoita Seira, go sem ina asa Sukota goi yoyou parai iyowóidi toinina manuna be nakae ina yoguyoguyao manudi. Moe pasina asayana yoina Sukota. ");
INSERT INTO gvs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","E boi Padani Aram ikalave, e mana dedevina isowóduwo asa Sekem goi; moe Kenani sinaena. Asayana kikina goi ina yoyou parai iyowóidi, e itunagu. ");
INSERT INTO gvs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ina yoyouyadi Emori natunao koroto idi poyapoya goi sikaaiyaka. Emoriyana natuna tayamo yoina Sekem. Tuwo Yakobo poyapoyayana igimone siriba ana badabada tayamo andedi (100) goi. ");
INSERT INTO gvs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Amoko goi dídiya ikabi, ikaudakodako, aba kasala imadagi Yaubada yaina go, aba kasalayana ivayou El Eloe Isileli. ");
INSERT INTO gvs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","E Yakobo mana bodao asa Sekem goi sikaaiyaka go, tuta tayamo Reya be Yakobo natudi Daina iketoiya ina bego vevina asa goi ivadadedi. ");
INSERT INTO gvs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ego koroto tayamo yoina Sekem ikaaiyaka, tauyana Emori natuna; ina bodao yoidi Ivai. Emoriyana asa Sekem ana tolovina. E kina Daina isiu asayana goi Sekemyana ikandobala Daina igite, tuwo ina ivinayoisi imasisiye, e igieomaemae. ");
INSERT INTO gvs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ikavava, Dainayana maisina ivakone. Tuwo Sekemyana nuwona ikabi toina; latuwona inai. Tuwo ilumakikine bego itagona taiyao sinai. ");
INSERT INTO gvs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","E ina tamana Emori ilatuwoko idigo kana, ‘Tamagu, kom kūna amo vavinayana kwābi yau monegu.’ ");
INSERT INTO gvs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","E Yakobo vala inove bego natuna Daina kina Sekem igieomaemae. Yakobo natunao koroto nava sikaaiyaka náuna moteoina goi yoguyogu simatakaavatedi. Tuwo imaigau ana kadókana sikaluvila. ");
INSERT INTO gvs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","E Sekem tamana Emori ina Yakobo igite bego Daina manuna ibóbwara. ");
INSERT INTO gvs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","E kidi go tutayana Yakobo natunao náuna moteoina goi sima, livalayana sinove, e tauyadi gamodi igoyo be nakae nuwodi imou sidigo kadi, ‘Moe sinapuyana aba omayamaya gagaina yaima.’ (Moitamo Isileli goi geya itoboineyeta.) ");
INSERT INTO gvs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Go kina Emoriyana Yakobo ilatuwoko idigo kana, ‘Go natugu Sekem natum nukotona ikabi toina. Tauna natugu kuvīni bego monena. ");
INSERT INTO gvs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kutagōna bei ida bodao taiyao sinai. Kai ima tubuwau imi wowoiyai sikabidi monediyao go, kai nakae ima wowoiyai imi tubuwau sikabidi monediyao. ");
INSERT INTO gvs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ameko goi kokaiyāka. Ava poyapoya latuwomi, kokābi go, kopaisēwa be nakae poyapoya kogimōna.’ ");
INSERT INTO gvs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","E Sekemyana nakae ibóbwara, Daina tamana be niunao ilatuwokoidi idigo kana, ‘Neta itoboinegu im kanuwóiya ababane, e kaga latuwomi bei avinimi. ");
INSERT INTO gvs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Komi toinimi kolovina Daina buwona. Kolatuwokoigu, bei avinimi. Neta gagaina, tuwo bei avinimi. Ago Daina kovinīgu monegu.’ ");
INSERT INTO gvs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Go boi kidi Yakobo natunao gamodi igoyo, tuwo sipola unana niudi Sekem igieomaemae. Tauna sipola ");
INSERT INTO gvs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","sidigo kadi, ‘Geya itoboinemeta niuma kavinim. Kom sakavaim geya kukupoeta. Neta kavinim, moe aba omayamaya gagaina yaima. ");
INSERT INTO gvs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Go sem tayamo dogoi koguinuweyāmo. Ame nakae: Neta komi koroto madabokimi asa goi sakavaimi kokupoidi, bei komi kai nakae. ");
INSERT INTO gvs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Kokupoidi ikavava, natumao vevina kavinimi go, natumiyao vevina kakabidi. E kai ameko bei kalokasa, nakae kita taeboda tayamo. ");
INSERT INTO gvs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Go neta sakavaimi geya kokupoidita, e niuma kakabi, taiyao kana.’ ");
INSERT INTO gvs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","E idi livalayadi Emori ma natuna Sekem sinove, tuwo sidigo kadi, ‘Dedevina, katagona.’ ");
INSERT INTO gvs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekem, tauyana koroto gagaina Emori ina bodao yaidi, woilina ina nakae iguinuwe. Bogina kuyagoi. Sekemyana Daina nuwona ikabi toina. ");
INSERT INTO gvs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","E moitamo Emori ma natuna Sekem sina idi kasa ana kaba siu goi sediyao silatuwokoidi kadi, ");
INSERT INTO gvs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","‘Tawou, amo korotoyadi dedevidi, tauyadi sikabivekovekoema. Tauna tatagōna sikaaiyaka ida poyapoya goi sipaaisewa. Ego konōve. Natudiyao vevina tanaidi go, natudao vevina sikabidi sinaidi. ");
INSERT INTO gvs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Go tayamo dogoi sikawanoiye yaida. Tauyadi bei sitagona sikaaiyaka yaida, neta kita sakavaida takupoidi kidi nakae. ");
INSERT INTO gvs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Go kogita. Idi yoguyoguyao be nakae idi poyapoya ana madabokina takabidi ae? Tauna kotagōna sakavaimi kokupoidi go, sikaaiyaka yaida.’ ");
INSERT INTO gvs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tuwo koroto liliudi asa ana kaba siu goi Emori ma natuna Sekem idi livala sinovedi, e sikabikaonedi. Tauna koroto madabokidi sakavaidi sikupoidi. ");
INSERT INTO gvs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","E maliyalina aito sikavava, korotoyadi sakavaidi adi kúpwana ana gedageda nava siilotowo go, idi lotówana kidi dedevidi. Ago Yakobo natunao, Simioni be Livai, tauyadi Daina niunao, idi sisi sikabidi, sina asayana goi koroto liliudi sivaopedi sikaumatedi. ");
INSERT INTO gvs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Emori ma natuna Sekem nakae sikaumatedi. Sikaumatedi ikavava, niudi Daina Sekem ina vada goi sikabi sinave. ");
INSERT INTO gvs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","E kidi go Yakobo natunaoyadi liliudi asa sinaena sivabebeo kónana sivaináwana tokámasa yaidi. Moe niudi ana omayamaya ana katumapu. ");
INSERT INTO gvs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tokámasa idi yoguyoguyao sikabidi, moe sipi, goti, bulumakau be nakae ase. Konadi liliudi idi vada sinaedi be nakae idi kasa goi nakae sikabidi. ");
INSERT INTO gvs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ego idi esaesa madabokina, vevina be gogómana liliudi sikoyoinidi sinavedi. ");
INSERT INTO gvs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","E kina Yakoboyana natunao idi guinuwa igite natunao adi taiyuwo ilatuwokoidi idigo kana, ‘Simioni be Livai, ami taiyuwo imi guinuwa goi yau guna mou koyato. Ame tutayana da Kenani be nakae da Perisi bei sikaolilivegu go, tauyadi toni kasa! Kita geya tabadebadeta. Tauna neta silamgógana sima silauida, e kita be ida bodao liliudi bei tavailai!’ ");
INSERT INTO gvs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Go kidi Simioni be Livai sidigo kadi, ‘Manakae? Dedevina katagona bego niuma siyatako kina tomatagogoli nakae?’ ");
INSERT INTO gvs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","E tuta tayamo Yaubada Yakobo ilatuwoko idigo kana, ‘Yakobo, kutāoya, kugāla kūna Beteli goi kulokāsa go, dídiya kukaudakodāko, aba kasala kumadāgi Yau yaigu. Boi amo asayana goi tuwowom Iso yaina kusiya be nakae Yau toinigu asowóduwo yaim.’ ");
INSERT INTO gvs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ibóbwara ikavava, e Yakobo osenao ilatuwokoidi idigo kana, ‘Osegowo, neta tokwalu sikaaiyaka yaimi, kokalavēdi. Ikavava, kokimavadēmi ame nakae: Ami kwama kokalavēdi go, kwama vau kolosīdi. ");
INSERT INTO gvs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kokimavademi ikavava, e kōma tatūko tāna Beteli. Maeko goi dídiya bei akaudakodako, aba kasala amadagi Yaubada yaina. Tauyana boi guna kategeda goi inovegu be nakae ivaitegu. Amo tutayana go, ima ame tuta, Tauyana ivakiitaugu.’ ");
INSERT INTO gvs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tuwo moitamo idi tokwaluyao sikabidi be nakae idi gipolu sikabidi, Yakobo sivini. Sivini inavedi taniya Sekem kikina, e taniyayana unana goi itavi. Itavi ikavava, dogoiyadi idodoidi, ivakumdi. ");
INSERT INTO gvs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ivakumdi ikavava, asayana sikalave siketoiya. Siketoiya go, amoko goi Yaubada toni kasa liliudi diboyadi ikayovaedi, e Yakobo ma natunao simatoitedi, tauna geya sivatapiyedita. ");
INSERT INTO gvs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","E kidi Yakobo sima Lusi. Lusiyana youyuwoina Beteli moe Kenani sinaena. ");
INSERT INTO gvs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Amoko goi dídiya ikaudakodako, aba kasala imadagi Yaubada yaina. E asayana ivayou El Beteli. Neta kunuwaisi amoko goi Yaubada toinina ikaiwoduwe Yakobo yaina tutayana boi isiyasiya. ");
INSERT INTO gvs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","E niga Ribeka ina pákwana yoina Debora ikámasa go, alova gagaina asa Beteli kikina goi iitáoya, e unana goi sivaliwoge, tauna alovayana sivayou Aloni Bakuta. ");
INSERT INTO gvs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","E Yakobo Padani Aram bogina ikalave go, ima Beteli. Amoko goi aiyuwoina Yaubada toinina isowóduwo tauyana yaina go, ikaipakuye, ");
INSERT INTO gvs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","e idigo kana, ‘Ame tutayana yoim Yakobo. Go geya tuwaina bei tomota sivayoum Yakobo. Go sem sivayoum Isileli.’ Tauna amo tutayana Yakobo sivayou Isileli. ");
INSERT INTO gvs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","E Yaubada aiyuwoina Yakobo ilatuwoko idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Poyapoyayana boi Eberamo be Aisake aavinidi, ");
INSERT INTO gvs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","E ibóbwara ikavava, Yakobo ikalave go, ituko ina. ");
INSERT INTO gvs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ago amo asayana goi Yakobo dídiya tayamo ivatáoe namliyeta ikaipakuye Yaubada yaina, tauna didiyayana yatana oine bwaena be nakae oribe putumina isiwoidi. ");
INSERT INTO gvs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ikavava, asayana ivayou Beteli unana amoko goi Yaubada ivadigo. ");
INSERT INTO gvs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","E Beteli sikalave go, asa Eparati nava aduwanau, e kenao goi Reitiyeli ina venátuna ana tuta ibabane. Ago moumou isaki yaina. ");
INSERT INTO gvs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","E tutayana iivenátuna, ana tovaita idigo kana, ‘Kwatepātu! Natum ame nakae koroto.’ ");
INSERT INTO gvs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","E Reitiyeli bogina ikamakámasa go, idigo kana, ‘Natugu avayou Benoni.’ Kina go Yakobo ivayou Beniyamina. ");
INSERT INTO gvs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","E Reitiyeli ikámasa. Ina kamasayana mlina Eparati kenaoina goi sivaliwoge. Eparatiyana youyuwoina moe Bedeliyema. ");
INSERT INTO gvs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Sivaliwoge ikavava, Yakobo dídiya tayamo ikabi, e Reitiyeliyana ina valiwoga goi ivatáoe, moe valiwoga ana kaba kinana. Didiyayana ame tuta nava ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","E kidi Isileli siketoiya sina asa Migadali Ederi goi sisiu sina dadavina sisowóduwo. E amoko goi idi yoyou parai siyowóidi. ");
INSERT INTO gvs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","E tutayana amoko goi sikaaiyaka, Rubeni ina Bila imasisiye. Bilayana moe Reitiyeli ina pákwana go, Isileli moneyuwoina. Imasisiye go, valena Isileliyana inove, tuwo gamona igoyo. E Yakobo natunao adi badabada yawou aiyuwo. Tauyadi adi bíbina ame nakae: ");
INSERT INTO gvs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Reya natunao koroto ame nakae: Rubeni kina Yakobo ina botomoya, Simioni, Livai, Yuda, Isakara be Sebuloni. ");
INSERT INTO gvs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Reitiyeli natunao koroto ame nakae: Iyosepa be Beniyamina. ");
INSERT INTO gvs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Reitiyeli ina pákwana Bila natunao koroto ame nakae: Dani be Napatali. ");
INSERT INTO gvs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Reya ina pákwana Silipa natunao koroto ame nakae: Gadai be Aseri. E ame tauna Yakobo natunao koroto, tauyadi Padani Aram goi sibíbina. ");
INSERT INTO gvs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","E Yakobo ikaluvila ina tamana Aisake ina kasa Mamre, moe Asa Ariba kikina. Asayana youyuwoina moe Ebironi. Ego asa Mamre goi Eberamo be Aisake boi sisuvaadavada. ");
INSERT INTO gvs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","E Aisake ana tala 180 bogina ibabane, ");
INSERT INTO gvs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","e tauyana ikaitomoya, yawoina maanawena. Tuwo yawoina ikavava go, ina tamana be tubunao yaidi. Ikámasa ikavava, natunao Iso be Yakobo sivaliwoge. ");
INSERT INTO gvs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ame Iso mana bodao adi liliu, tauyana youyuwoina Idom. Liliuyana ame nakae: ");
INSERT INTO gvs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso Kenani vevinaidi adi taiyuwo inaidi, tayamo yoina Eda, tauyana tamana Eloni go, ana dala moe yoina Eta. E monena aiyuwoina yoina Olivama. Tauyana tamana Ena go, tubuna Sibiyoni go, ana dala yoina Ivai. ");
INSERT INTO gvs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Monena aitonina yoina Basemate, tamana yoina Isimaeli go, niuna yoina Nibayote. ");
INSERT INTO gvs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","5","Iso natunao koroto Kenani goi sibíbina ame nakae: Eda ivenátuna, natuna koroto yoina Elipasi. Basemate ivenátuna, natuna koroto yoina Reuweli. Olivama ivenátuna, natunao koroto adi taito, tayamo yoina Yeusi, tayamo yoina Yalam, tayamo yoina Kora. ");
INSERT INTO gvs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","E Iso Yakobo madi bodao taiyao Kenani goi sikaaiyaka go, idi yoguyoguyao badabada sisaki, tauna geya itoboinedita amoko adi dedevina sibabane. Tuwo Iso latuwona ina ituli ta kasa. E monenao, natunao, ina bodao, konadi be nakae ina yoguyoguyao Kenani goi ikabidi inavedi asa yoina Seira goi. ");
INSERT INTO gvs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tuwo Koya Seirayana goi kidi Iso silokasa. Isoyana youyuwoina moe Idom. ");
INSERT INTO gvs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","E Iso tubunao adi liliu ame nakae: Tubunaoyadi yoidi Idom go, asa Koya Seira goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso natunao koroto ame nakae: Tayamo yoina Elipasi, tauyana sinana yoina Eda. E tayamo yoina Reuweli, tauyana sinana yoina Basemate. ");
INSERT INTO gvs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","E Elipasiyana natunao koroto ame nakae: Temani, Omari, Sepo, Gatam be Kenasi. ");
INSERT INTO gvs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","E vavina paakonina yoina Timna moe Elipasiyana moneyuwoina. Tauyana ivenátuna, natuna koroto yoina Amaleki. Ame tauna Iso monena Eda tubunao. ");
INSERT INTO gvs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","E Reuweliyana natunao koroto ame nakae: Nakate, Serako, Sama, Misa. Ame tauna Iso monena Basemate tubunao. ");
INSERT INTO gvs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","E Iso monena Olivama, tauyana tamana Ena, tubuna Sibiyoni. E ivenátuna, natunao koroto adi taito ame nakae: Yeusi, Yalam be Kora. ");
INSERT INTO gvs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","E nunu aivaudi Iso goi sisowóduwo be nakae idi tovakumgoyao ame nakae: Nunuyadi Iso natuna Elipasi goi sisowóduwo yoidi ame nakae: Temani, Omari, Sepo, Kenasi, ");
INSERT INTO gvs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam be Amaleki. Ame bodayadi asa Idom goi sikaaiyaka go, ame bodayadi moe Eda tubunao be nakae Elipasi tubunao adi tovakumgoyao taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nunuyadi Iso natuna Reuweli goi sisowóduwo yoidi ame nakae: Nakate, Serako, Sama be Misa. Ame bodayadi tubudi moe Iso monena Basemate. ");
INSERT INTO gvs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Nunuyadi Iso monena Olivama goi sisowóduwo yoidi ame nakae: Yeusi, Yalam be Kora. Ame bodayadi tubudi Iso monena Olivama, tauyana tamana Ena. ");
INSERT INTO gvs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ame bodayadi madabokidi Iso tubunao. Iso youyuwoina moe Idom. ");
INSERT INTO gvs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","E tutayana Iso mana bodao nava geya sinoita asa Idom goi, e Seira tubunao (adi dala yoina Kori) amoko goi nava sikaaiyaka. Seira natunao koroto nunu vau unadi ame nakae: Lotani, Sobali, Sibiyoni, Ena, ");
INSERT INTO gvs_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Daisoni, Eseri be Daisani. Ame bodayadi Seira tubunao Idom goi sikaaiyaka. Tauyadi dala Kori adi tovakumgoyao. ");
INSERT INTO gvs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotaniyana natunao koroto adi taiyuwo, tayamo yoina Kori, tayamo yoina Emam. Lotani niuna yoina Timna. ");
INSERT INTO gvs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobali natunao koroto ame nakae: Alivani, Manekata, Ebali, Sepo be Onam. ");
INSERT INTO gvs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibiyoni natunao koroto adi taiyuwo ame nakae: Tayamo yoina Aiyaki, tayamo yoina Ena. Enayana boi bwae yaviyavi igitebabane náuna moteoina goi tutayana tamana ina ase imatakaavatedi. ");
INSERT INTO gvs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Enayana natuna koroto yoina Daisoni go, natuna vavina yoina Olivama. ");
INSERT INTO gvs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Daisaniyana natunao koroto ame nakae: Kemidani, Esibani, Itelani be Kerani. ");
INSERT INTO gvs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eseriyana natunao koroto ame nakae. Bilani, Seyavani be Akana. ");
INSERT INTO gvs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Daisani natunao koroto adi taiyuwo: Uso be Erani. ");
INSERT INTO gvs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Dala Kori sinaena nunu vau yoidi ame nakae: Lotani, Sobali, Sibiyoni, Ena, ");
INSERT INTO gvs_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Daisoni, Eseri be Daisani. Ame tauyadi dala Kori ina nunu Seira goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Boi nimatu tutayana Isileli tubunao nava geya adi tolovinamo, e asa Idom ana tolovinao ame nakae: ");
INSERT INTO gvs_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beora natuna Bela Idom ina kasa Dinaba goi ilovina. ");
INSERT INTO gvs_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tutayana Belayana ikámasa, ana katumapu Serako guma Bosira natuna Iyobabi ietolovina. ");
INSERT INTO gvs_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tutayana Iyobabiyana ikámasa, ana katumapu Usam guma Temani itáoya, ilovina. ");
INSERT INTO gvs_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tutayana Usamyana ikámasa, ana katumapu Bedadi natuna Kadadi ina kasa Avita goi ietolovina. Kadadiyana boi Moabe goi da Midiyani ivasobusobuyedi. ");
INSERT INTO gvs_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tutayana Kadadiyana ikámasa, ana katumapu Samla guma Masireka ietolovina. ");
INSERT INTO gvs_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tutayana Samlayana ikámasa, ana katumapu Saulo guma Rekobota ietolovina. Asa Rekobotayana sákala Yuparetisi kikina goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Tutayana Sauloyana ikámasa, ana katumapu Akibori natuna Baala Kanani ietolovina. ");
INSERT INTO gvs_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tutayana Baala Kananiyana ikámasa, ana katumapu Akibori asa Pau goi ietolovina. Tauyana monena yoina Metabeli. Metabeliyana sinana Matiredi go, tubuna Meseyabi. ");
INSERT INTO gvs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","E tuwo Iso tubunao nunu vau yoidi liliudi ame nakae: Timna, Aliva, Yeteta, Olivama, Ila, Pinoni, Kenasi, Temani, Mibisari, Magidiyeli be Iram. Ame dala Idom ana nunu vau yoidi go, yoidiyadi moe idi kasa tamo tamo yoidi nakae. ");
INSERT INTO gvs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","E Yakobo ikaaiyaka asayana goi boi tamana ituliye, moe asayana Kenani. ");
INSERT INTO gvs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","E ame Yakobo ina bodao tetelidi. Tetelinayana ame nakae: E Iyosepa tubuwau ana tala 17 go, senao taiyao sipi be goti simatakaavatedi. Senaoyadi moe Yakobo monenao Silipa be Bila natudiyao. E senao taiyao sikaaiyaka go, Iyosepayana ina tamana goi tuwowonao iboboredi idigo kana, ‘Tamagu, natumowo idi sinapu igoyo.’ ");
INSERT INTO gvs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","E kina go Isileli ina kakaya moe natuna Iyosepa unana Isileli bogina ikaitomoya tutayana Iyosepayana ibíbina. Tauna imatakoiye gagaina namliyeta natunao madabokidi. Tuwo kwama tayamo igilumi. Kwamayana kaulomoloomonina go, maanawena nakae isou ina aekituna be nakae isou ina nimana. Igilumi ikavava, e natuna Iyosepa ivini, ilosi. ");
INSERT INTO gvs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","E tuwowonao siyagoi tamadi ana kakaya moe Iyosepa. E tauna gamodi igoyo, e Iyosepayana sikaoolilive, nakae sikaaoseve. ");
INSERT INTO gvs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","E tuta tayamo Iyosepa ikanamimi. Niga ina kanamimiyana manuna tuwowonao ilatuwokoidi idigo kana, ‘Tuwowogowo, guna kanamimi konōve. Anamimiyana ame nakae: Witi tolobodi tánuwo goi tapaatumidi go, yau guna pátuma mainao toinina itáoya. Itatáoya go, komi imi pátuma toinidi sitáoya, sideli sima yau guna pátuma sitaoyakobu go, sivatugúyala sikanakabobo.’ E tutayana tuwowonao sinove, idi kaoliliwo ivaituwaiko tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","E tuwo sibolagu, sidigo kadi, ‘Manakae? Bego kom kulovinaema ae? Manakae? Kom bego kuetokalibúbuna yaima ae?’ Tuwo tuwowonao sikaolilive gagaina toina ina kanamimi be nakae ina bóbwara pasidi. ");
INSERT INTO gvs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","E niga Iyosepayana imasisi, aiyuwoina ikanamimimna. Tuwo tuwowonao ilatuwokoidi, idigo kana, ‘Tuwowogowo, akanamimimna, e guna kanamimiyana konōve. Guna kanamimiyana ame nakae: Níyala, tukówana be nakae utuna adi badabada yawou tayamo sivatugúyala yau yaigu.’ ");
INSERT INTO gvs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","E nakae ina kanamimiyana tamana ilatuwoko go, tamanayana ibolagu kana, ‘Moe kaga kukanamimiye! Manakae? Kunuwonúwana bego sinam, tuwowomowo nakae yau bei aema kavatugúyala kom yaim goi?’ ");
INSERT INTO gvs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","E tuwo tuwowonao bogina sivakipikipiye go, kina tamadi anamimiyana inuwokavate, e manuna inuwonúwana. ");
INSERT INTO gvs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","E tuwo tuta tayamo Iyosepa tuwowonao sina asa Sekem goi tamadi ina sipiyao simatakavatedi. ");
INSERT INTO gvs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Sikaaiyaka tuta maanawena, tuwo Isileli Iyosepa ilatuwoko idigo kana, ‘Iyosepa, tuwowomowo tuta maanawena bogina sikaaiyaka Sekem goi guna sipiyao simatakaavatedi. Tauna bei aetunem kuna kuvadadedi.’ ‘O dedevina’, Iyosepa kaena. ");
INSERT INTO gvs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","E Yakobo idigo kana, ‘Ame tuta kūna kuvadadēdi. Neta kidi be nakae yoguyogu dedevidi, e kūma kulatuwokōigu.’ Tuwo Isileli Ebironi butumina goi ikaaiyaka go, Iyosepayana ietune ina asa Sekem. ");
INSERT INTO gvs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Tutayana ina Sekem goi, tuwowonao ilusaledi go, geya ibabanedita. Tuwo náuna moteoina goi iketoiya beso iluusaledi. Ina lusalayana goi koroto tayamo ivalobode. E korotoyana ilumadádana, idigo kana, ‘Kom kaga kuulusale?’ ");
INSERT INTO gvs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","‘Tuwowogowo aluusaledi. Neta kuyagoidi nako dadavina sina sipi simatakaavatedi, e kulatuwokoigu ana agitedi’, Iyosepa kaena. ");
INSERT INTO gvs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","E korotoyana idigo kana, ‘U. Boi kwalae sima ameko go, bogina sina. Tauyadi anovedi sidigo kadi, “Yoguyogu tanavēdi Dotani dadavina goi.”’ Tuwo Iyosepayana ina Dotani goi ilusaledi, e amoko goi igitedi. ");
INSERT INTO gvs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","E nava aduwanau goi iiketoiya go, kidi tuwowonao sikandobala tauyana sigite imamaima. Tuwo nuwonúwana situlu manakaedi bego tauyana sikaumate. ");
INSERT INTO gvs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","E sidigo kadi, ‘Kodobāla tokanamimiyana imamaima. ");
INSERT INTO gvs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tawou, tauyana takaumāte go, wowona talāve isou doelu daakakaina goi, e bei tagite neta ina kanamimi moitamo sisowóduwo gea geya. Ago tapōla kada, “Tauyana woiwoi sikani.”’ ");
INSERT INTO gvs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","E Rubeni idi livala inove, tauna latuwona bego ana gómana iyave. Tuwo idigo kana, ‘Taabu yawoina takupokūpo. ");
INSERT INTO gvs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Taabu takaaumāte, go sem talaveyāmo isou ame doeluyana goi. Go taabu yawoina tabiisikōne.’ Ina nuwonúwana bego namliyeta bei ina ana gómana iyave idi losinapu goi, e ikaluvilemnei inave tamadi yaina goi. ");
INSERT INTO gvs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","E tuwo moitamo Rubeni sopana sikabikaone, tauna tutayana Iyosepa isowóduwo, siyoisi. Siyoisi go, ana kwamayana dedevina tamana ivinivini sikayaise sikabi. ");
INSERT INTO gvs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ago tauyana silave isou doeluyana goi. Doeluyana daakakaina unana bwae geya. ");
INSERT INTO gvs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Silave ikavava, ivatabaledi sina tupwana aduwanau goi situsobu bego sikáika go, sikandobala Isimaeli tubunao sigitedi Giliyadi dadavina goi simamaima. Ego tauyadi idi kameri pútuma, be alovamamaina sisina dedevidi sivakavaledi; latuwodi sina Itipita goi idi putumayadi sikaigimonedi. ");
INSERT INTO gvs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","E tuwo Yuda idigo kana, ‘Segowo, kaga ana dedevina neta ada gómana takaumate go, namliyeta ana kaumata tatalamoumouye? ");
INSERT INTO gvs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tauyana ada gómana, ikaikaida tayamo, tauna taabu takaaumāte. Go sem takaigimōne Isimaeli tubunao yaidi.’ Tuwo madabokidi Yuda sopana sikabikaone. ");
INSERT INTO gvs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tutayana Midiyani tubunao togimona sima doeluyana goi, Iyosepayana tuwowonao sina Iyosepayana sibulagasi. Sibulagasi ikavava, siriba 20 goi sikaigimone togimonayadi yaidi. Tuwo tauyana sikabi sinave Itipita goi. ");
INSERT INTO gvs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","E niga go Rubeni ikaluvila ina doeluyana goi bego Iyosepa ikailagasi go, doeluyana goi ikandosobu, tauyana geya maisinamo, idigo kana, ‘Oiyoi guna gómana!’ Tuwo ana kwama iyoisi, ina nuwomou pasina ikiise. ");
INSERT INTO gvs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ago ikaluvila ina ana gomanao yaidi goi idigo kana, ‘Gogómana, ada gómana doelu goi geya maisinamo! Bei manakaegu?’ ");
INSERT INTO gvs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","E tuwo tauyadi goti tayamo siyoisi sikaumate. Sikaumate ikavava, ikaikaina sikabi, Iyosepayana ana kwama simigi. ");
INSERT INTO gvs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Simigi ikavava, kwamayana sikabi, sinave tamadi sivatuluko. Sidigo kadi, ‘Tamama, ame kwamayana kababane. Kugitedōko nakona ame natum ana kwama gea geya.’ ");
INSERT INTO gvs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tuwo Yakoboyana igitegite, e ikinane idigo kana, ‘Moitamo. Moe natugu ana kwama! Oiyoi natugu Iyosepa, woiwoi sikayapesapesagi!’ ");
INSERT INTO gvs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","E tuwo Yakoboyana ana kwama ikiise ikalave go, ana kwama salisalina ilosi. Atena igeda natuna pasina. E tuta maanawena goi inuwomou natuna ina kámasa manuna. ");
INSERT INTO gvs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","E natunao liliudi sima bego tamadi sikipaiwole go, idi kipaiwalayana ikatae, idigo kana, ‘Tuwo, natugu ana kobu. Alapasaisai ana kadókana akámasa asou Saola goi, e natugu agite baige guna nuwomou ikavava.’ Tuwo itáiya natuna manuna. ");
INSERT INTO gvs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","E kidi go Midiyani tubunao bogina Itipita goi sisiu go, Iyosepayana sikaigimone Potipari yaina; tauyana Pero ina tovakumgo tayamo go, ina deri ana toyausayao adi tokalikumatana. ");
INSERT INTO gvs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","E amo tutayana goi Yuda senao ikalavedi go, isou ina koroto tayamo guma Adulam yoina Ira, e taiyao sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","E amoko goi Kenani vavinaina tayamo ivalobode, vavinayana tamana yoina Suwa guma Kenani. Tuwo sinai, taiyao simasisi ");
INSERT INTO gvs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","namliyeta Yuda monena ikéuwama. Ikéuwama, ivenátuna, natuna koroto ivayou Era. ");
INSERT INTO gvs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sivayuwoina Yuda monena ikeuwamamna, ivenátuna, natuna koroto. Natunayana ivayou Onani. ");
INSERT INTO gvs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Niga Yuda mana bodao sina asa Kesiba goi sikaiyaka. Amoko goi monena sivatonina ikeuwamako, ivenátuna, natuna koroto. Natunayana ivayou Seile. ");
INSERT INTO gvs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Tuwo sikaaiyaka, sikaaiyaka, e Yuda ina botomoya Era bogina ikaitubuwaumatuwo. Tuwo Yuda itáoya, ina tayamo vavina ikabi bego Erayana monena. Vavinayana yoina Temari. ");
INSERT INTO gvs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","E Erayana ina sinapu igoyo Yauwe matana goi, tuwo kina Yauwe ikaumate. ");
INSERT INTO gvs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","E Yuda natuna bonauyayana yoina Onani iduduwe ima. Ima Yudayana idigo kana, ‘Onani, tuwowom bogina ikámasa go, geya natunamo. Tauna ida sinapu goi kūna kobuina taiyao konāi, taiyao komasīsi bei ikéuwama. Ikéuwama, ivenátuna, natuna tuwowom ana katumapu.’ ");
INSERT INTO gvs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","E Onaniyana bogina iyagoi neta nakae iguinuwe, gomanayana moe geya tauyana natuna geya. Tuwo tuta tamo tamo tuwowona kobuina imasisiye, elueluna poyapoya goi idau besobeso. Tauna vavinayana geya itoboineyeta ikéuwama ivenátuna tuwowona manuna. ");
INSERT INTO gvs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","E ame iguuinuwe Yauwe matana goi igoyo, tauna tauyana nakae kina Yauwe ikaumate. ");
INSERT INTO gvs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","E tuwo Yuda yaona Temari iduduwe ima ilatuwoko ipola idigo kana, ‘Temari, kwaluvīla kūna tamam ina vada goi kwaiyāka maa kobuim ana kadókana natugu Seile ikaitubuwaumatuwo, e bei itoboinemi konai.’ Tauyana ina nuwonúwana kana, ‘Geya latuwogu natugu Seile amo vavinayana inai, govila bei ikámasa tuwowonao nakae.’ Tuwo moitamo Temari ikaluvila ina tamana ina vada goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","E sikaaiyaka, sikaaiyaka aaa, Yuda monena, moe Suwa natuna, ikámasa. Tuwo nuwona imou. Ina nuwomou ikavava, e siyana Ira guma Adulam taiyao sina asa yoina Timna. Amoko goi ina topaisewayao sipaaisewa, ina sipiyao unuunudi siikupoidi. ");
INSERT INTO gvs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ago tomota sina Temari silatuwoko kadi, ‘Temari, yaom inonoina Timna bego ina sipi unuunudi ikupoidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tuwo livalayana inove, kóbuya adi kwama ivalilivi iyato go, ituli ta kwama ilosi. Tayamo kwama ikabi maisina ivamou go, imatakipola. Ivamou ikavava, ina tayamo asa yoina Enaim. Moe Timna kenaoina goi ikaaiyaka. E ina Enaim ana kaba siu goi itusobu Yuda ituuyaosi. Ina nuwonúwana kana, ‘Yaogu ikatubaugu. Natuna Seile bogina ikaitubuwaumatuwo go, geya itagoneta kanai.’ ");
INSERT INTO gvs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","E iitusobu go, Yuda ima ikandobala vavinayana igite inuwonúwana kana, ‘Nakona vavina tomatagogoli.’ Bogina kuyagoi. Vavinayana maisina ivamou. ");
INSERT INTO gvs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","E Yuda ivatabale ina vavinayana kikina goi idigo kana, ‘Kūma kumasisiyēgu.’ Geya iyagoiyeta bego vavinayana moe yaona Temari. ‘Gobe kaga kuvinigu?’ Temariyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","‘Goti bonatuna tayamo bei aetune iwo’, Yuda kaena. ‘Konam tayamo ame tuta kuvinīgu. Niga goti kuetūne ima konamyana kutatete’, tauyana kaena. ");
INSERT INTO gvs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","‘Ava konagu bei avinim?’ Yuda kaena. ‘Im rini mana maka be im kaituko kuvinīgu’, tauyana kaena. E tuwo moitamo konanayadi ivini. Ikavava, taiyao sina, e imasisiye, ikéuwama. ");
INSERT INTO gvs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Simasisi ikavava, Temari ikaluvila ina tamana ina vada goi. Amoko goi ana kwama ivalilivi go, kóbuya adi kwama ilosimneidi. ");
INSERT INTO gvs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","E niga Yuda ina goti bonatuna tayamo ikabi, siyana Ira ivini. Ivini, ilatuwoko idigo kana, ‘Ira, ame gotiyana kwābi kunāve vavinayana kuvīni go, konaguyadi kutatetēdi.’ Tuwo ikabi ina vavinayana ilusale, geya. ");
INSERT INTO gvs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Toni kasa koroto maniyedi sikaaiyaka iigitedi ilumadadedi, kana, ‘Vavina tomatagogoli boile koneiyuwe Enaim ina kenao goi ikaaiyaka, tauyana nako ina?’ ‘Geya tayaamo tomatagogoli ameni’, korotoyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tuwo Irayana ikaluvila ina Yuda ilatuwoko, idigo kana, ‘Vavinayana alusale, geya. Toni kasa koroto amodi sikaaiyaka alumadadedi, tauyadi kadi, “Geya tayaamo tomatagogoli ameni.”’ ");
INSERT INTO gvs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","E Yudayana idigo kana, ‘Tuwo kwalāve. Konaguyadi sikaaiyaka tauyana yaina, govila bei tomota sivaponuponuyeda. Goti bonatunayana boi akaatotule yaina bogina aetune ina go, vavinayana geya itoboinemta kubabane.’ ");
INSERT INTO gvs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","E tuwo tukówana aito mlidi, tomota sima Yuda silatuwoko sidigo kadi, ‘Yuda, yaom Temari ana ketoiya tomatagogoli nakae, koroto taiyao simasisi. Go kunōve. Masisi goyogoyoinayana goi bogina ikéuwama.’ E Yudayana idigo kana, ‘Kōna tauyana koyōisi, kōme be kogābu ikámasa!’ ");
INSERT INTO gvs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","E sina siyoisi go, Yuda ina rini be ina kaituko tomota tayamo ivini ilatuwoko kana, ‘Ame kwabīdi go, kūna Yuda kuvīni kam, “Korotoyana boi imasiisiyegu akéuwama konana goamedi. Kom kugīte nakona itoboinem kukinane rini ame be aituko ame avatau konana?”’ ");
INSERT INTO gvs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","E moitamo ina Yuda ivini go, tutayana konanayadi igitedi, ikinanedi. Tuwo idigo kana, ‘Tauyana nai ana lovina ana tokibóbwata go, yau geya unana natugu Seile avagagale tauyana yaina. Tauna tauyana lovina ana tokibóbwata.’ Tuwo Temariyana geya sigabuyeta. Ego Yuda Temari taiyao geya tuwaina simasisimna. ");
INSERT INTO gvs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","E niga Temari ina tuta venátuna isowóduwo go, natunao gamona goi lalavi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","E iivenátuna go, mainao gómana tayamo nimana isowóduwo. E tovaita búyala kayakayaina ikabi, gomanayana nimakituna goi isiko. Isiko ikavava, idigo kana, ‘Ame tauyana igimisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ego gomanayana nimana ivaisiumnei go, siyana isowóduwo. E tovaitayana idigo kana, ‘Siyam kuvatupuwe bego kom kugimisowóduwo?’ Tuwo gomanayana sivayou Peresi. ");
INSERT INTO gvs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Peresi isowóduwo ikavava, ana gómana, tauyana nimana goi búyala kayakayaina ikaaiyaka isowóduwo go, tauyana sivayou Serako. ");
INSERT INTO gvs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","E kina go Iyosepayana Isimaeli tubunao nimadi goi ikaaiyaka. Tuwo tauyana sinave Itipita goi go, Pero ina tovakumgo tayamo yoina Potipari guma Itipita igimone. Potipariyana moe Pero ina deri ana toyausayao adi tokalikumatana. ");
INSERT INTO gvs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Go kina Yauwe ivaakitau, tauna ina vaita goi Iyosepa ina paisewayana madabokina kikiboda. Tuwo ina tomoya Potipari ina vada goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ikaaiyaka go, ina tomoyayana bogina igite bego Yauwe ivaakitau, tauna ina vaita goi kaga liliuna Iyosepa nimana goi kina Potipari iyatoyato, madabokina ikibode. ");
INSERT INTO gvs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tuwo Potipari ina kanuwóiya ibabane. Tauyana idigo kana, ‘Iyosepa, tuta ame goi avayokoim kom tomatakavata. Guna vada be nakae konagu liliudi kumatakavatēdi unana anumisem.’ ");
INSERT INTO gvs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","E tutayana ivayoko kina Iyosepa moe ina vada be konana liliudi adi tomatakavata, e tauyana pasina Yauwe Potipari guma Itipita ikaipakuye. Tauna ana dedevina ibabane. ");
INSERT INTO gvs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tuwo Potipari konana liliudi be ina vada ana rugwáuta Iyosepa nimana goi iyatoidi. Tauna dogoiyadi manudi geya inuuwonúwana geya. Go kina tauna, áika tayamo toito. E Iyosepa koroto gumaboina nakae ana bíbina dedevina. ");
INSERT INTO gvs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Tauyana ipaaisewa ina tomoya Potipari ina vada goi go, Potipariyana monena ikandobala Iyosepayana igite koroto gumaboina, tauna ivakone. E tuta tayamo ina ilatuwoko idigo kana, ‘Iyosepa, kūma kumasisiyēgu.’ ");
INSERT INTO gvs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Go kina Iyosepayana ikatae, idigo kana, ‘Geya. Kunōve. Yau pasigu guna tomoya geya inuuwonúwana geya kaga liliuna ina vada sinaena manudi. Konana liliudi nimagu goi iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Yau aguta vada ame goi toolagaigu. Geya vatau tayaamo ikalisavegu. Guna tomoyayana geya kada tayaamo konana ivagagalakoigu geya, go sem kom monena amta ivagagalem yau yaigu. Tauna geya itoboineguta moe dogoiyana goyogoyoina aguinuwe guna tomoya yaina. Moe nakae goyo aguinuwe Yaubada matana goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ego maliyalina tamo tamo Iyosepayana ilumaakikine kana, ‘Iyosepa, kūma kumasisiyēgu.’ Go kina Iyosepayana ikatae, tuwo geya itagoneta bei imasisi tauyana taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","E tuta tayamo Iyosepa isiu Potipari ina vada goi bego ipaisewa go, vadayana sinaena geya tayaamo vada ana topaisewa ikaaiyaka geya. ");
INSERT INTO gvs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tuwo vavinayana ima ibisibala Iyosepayana ana kwama iyoisi, idigo kana, ‘Kūma kumasisiyēgu!’ Go Iyosepayana ana kwama ikalave, vadayana goi ilokoinaodo, isiya. ");
INSERT INTO gvs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Go kina vavinayana ikandosobu nimana goi kwamayana igite, ");
INSERT INTO gvs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tuwo ina pakonayao iduduwedi sima, ipola kana, ‘Kogīte! Ame Iberiuyana monegu ime bego ida vada imatakavate go, ikaiwotetegu. Maine isiu ima iyoisigu latuwona bego imasisiyegu go, apodeda. ");
INSERT INTO gvs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Go tutayana guna podedayana inove imatoita, e ana kwama kikigu goi ikalave go, ilokoinaodo isiya.’ ");
INSERT INTO gvs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tuwo kwamayana kikina goi iyato irugwausi ana kadókana Iyosepa ana tomoya ikaluvila. ");
INSERT INTO gvs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tutayana tauyana ikaluvila ima, e kina vavinayana ilatuwoko idigo kana, ‘Amo im pákwana guma Iberiu boi kumememe yaima goi maine isiu ima iyoisigu bego imasisiyegu. ");
INSERT INTO gvs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Go tutayana apodeda, e ana kwama kikigu goi ikalave go, ilokoinaodo isiya. ");
INSERT INTO gvs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","E ame nakae im pákwana iguinuwe yaigu.’ E tutayana Potipari monena idigo kana, ‘Ame nakae im pákwana iguinuwe yaigu’, Iyosepa ina tomoya inove, gamona igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tauna deri ana torugwautayao ilatuwokoidi kana, ‘Kōna Iyosepa koyōisi, deri goi kovaisīu.’ Tuwo nakae siguinuwe. Ego deriyana moe Pero, da Itipita adi tolovina, ina deri moe toogoyoidi manudi neta Peroyana yaina siguinuwa goyogoyo. Tuwo Iyosepayana deri goi ikaaiyaka go, ");
INSERT INTO gvs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Yauwe ivaakitau be nakae iilokate. Nakae Yauwe ina guinuwa pasina deri ana tolovina nakae Iyosepa ikanuuwoiye. ");
INSERT INTO gvs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","E tuwo tolovinayana idigo kana, ‘Iyosepa, avayokoim kom deri ana tokaiyakoyao adi tovakumgo. E nakae guinuwa liliudi deri goi kom kumatakavatedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tuwo kaga liliuna Iyosepa nimana goi sikaaiyaka nakae imatakaavatedi, e manudi tolovinayana geya inuwonuwoneta. Bogina kuyagoi. Yauwe Iyosepa ivaakitau, tauna Yauwe pasina Iyosepayana ina paisewa madabokina kikiboda. ");
INSERT INTO gvs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","E Iyosepa deri goi ikaaiyaka go, tuta tayamo da Itipita idi tolovina ina vedi ana tomatakavatayao adi tovakumgo be nakae ana beredi ina tokaigabunayao adi tovakumgo tolovinayana sibagali. ");
INSERT INTO gvs_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tauna tovakumgo adi taiyuwokova yaidi goi Pero gamona igoyo. ");
INSERT INTO gvs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Tuwo ina deri ana toyausayao adi tokalikumatana ilatuwoko idigo kana, ‘Kūna adi taiyuwo kuyoisīdi, e deri goi kuvaisīudi.’ Tuwo moitamo ina nakae iguinuwe; adi taiyuwokova ikabidi deri goi ivaisiudi sikaaiyaka. Ego amo deriyana goi Iyosepa nakae nava ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","E tokalikumatanayana Iyosepa ivayoko deri ana tokaiyakoyao adi tovaita, e imatakaavatedi. E tuta maanawena deri goi sikaaiyaka go, ");
INSERT INTO gvs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","sabamgo tayamo goi vedi ana tomatakavatayana be beredi ana tokaigabunayana adi taiyuwokova sikanamimi. Ago adi kanamimiyadi tamo tamo madi yagoina. ");
INSERT INTO gvs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","E simasisi vanuwo itomo, Iyosepa ina igitedi tauyadi madi nuwomou sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Tuwo ilumadadedi, idigo kana, ‘Kaga unana maisimi siiwówana?’ ");
INSERT INTO gvs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","‘Nuwobuna ama taiyuwo kakanamimi go, geya vatau tayaamo itoboine anamimiyadi italigeidi’, kidi kaedi. E Iyosepayana idigo kana, ‘Anamimi adi yagoina Yaubada anetava itoboine ivaiteda ae? Tauna imi kanamimi kolatuwokoigu go, nakona Yaubada ivatulukoigu adi yagoina.’ ");
INSERT INTO gvs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tuwo vedi ana tomatakavata igimibóbwara, idigo kana, ‘Guna kanamimi goi tayamo oine buyalina matagu goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","E buyalayana itabolalavi aito go, mainao situpo, silala, niga sikéuwo, e keuwoidi sibólika. ");
INSERT INTO gvs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pero ina vedi nimagu goi aakavale. Tuwo keuwoinayadi aguwedi, vediyana tobuna goi abibidi. Abibidi ikavava, vediyana Pero avini.’ ");
INSERT INTO gvs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Iyosepa idigo kana, ‘Im kanamimi ana talígava ame nakae: Tabolalavina aito moe maliyalina aito. ");
INSERT INTO gvs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tauna maliyalina aito mlidi Pero bei ikilagasim be nakae kebam ivinimneim be ina vedi kuvini nakae boi tutayana kom tauyana ina vedi ana tomatakavata. ");
INSERT INTO gvs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Go tutayana am dedevina kubabane, kunuwaisīgu ae? Siyagu, yau guna lokata kulolāse, e Pero kulatuwōko italigeigu. ");
INSERT INTO gvs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bogina kuyagoi. Boi kidi Iberiu idi kasa goi geya guna goyomo akaaiyaka go, tuwo koroto maniyedi sima siyoisigu, simegu ameko. Ameko nakae geya tayaamo goyo aguinuwe bego itoboine ame deriyana goi sivaisiugu.’ ");
INSERT INTO gvs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","E kina tokaigabunayana inove bego anamimiyana ana talígava dedevina, tuwo Iyosepa ilatuwoko idigo kana, ‘Yau nakae akanamimi. Gwa. Guna kanamimiyana ame nakae: Beredi ma bayaoidi aito aavabedi go, ");
INSERT INTO gvs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","bayaoyana kanayaatanaina goi, e beredi ituli ituli Pero manuna sikaaiyaka. Sikaaiyaka go, mánuwo sima sikani.’ ");
INSERT INTO gvs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","E kina Iyosepayana idigo kana, ‘Im kanamimi ana talígava ame nakae: Bayaoyadi aito moe maliyalina aito. ");
INSERT INTO gvs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tauna maliyalina aito mlidi Pero bei ikailagasim. Nukotom bei ibobo go, sakavaim isiko alova goi ivakosainem, e mánuwo bei sima sakavaimyana sikanikani.’ ");
INSERT INTO gvs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","E tuwo moitamo maliyalina aito mlidi moe Pero ina bíbina ana maliyalina. Tuwo áika gagaina iwodugu go, ina tovakumgoyao paakonidi iduduwedi sima taiyao sikáika. Aikayana goi ina vedi ana tomatakavata be nakae ana beredi ana tokaigábuna nakae iduduwedi sima tovakumgoyadi matadi goi ikailagasidi. ");
INSERT INTO gvs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Vedi ana tomatakavata ikailagasi ame nakae: Kebana ivinimnei, tauna Pero ina vedi imatakavate. ");
INSERT INTO gvs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Go tokaigabunayana ikailagasi, wowona alova goi ivakosaine ikaumate nakae Iyosepa idige tutayana idi kanamimi italigeidi. ");
INSERT INTO gvs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","E kina go vedi ana tomatakavatayana ana dedevina ibabane go, Iyosepa ina livala geya inuwokavateyeta, go sem inuwoilave. ");
INSERT INTO gvs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","E tala aiyuwo sikavava, Pero ikanamimi. Ina kanamimiyana ame nakae: Sákala yoina Nairi kikina goi iitáoya ");
INSERT INTO gvs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","go, sakalayana goi bulumakau dedevidi nakae saabalidi adi badabada ainima aiyuwo sisinalaga. Sisinalaga, limou sikakáika. ");
INSERT INTO gvs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","E niga ituli ta bulumakau adi badabada ainima aiyuwo sisinalaga, bulumakauyadi sigoyo nakae sibagabaga. Sisinalaga, mamaya goi bulumakau dedevidi kikidi sitáoya. ");
INSERT INTO gvs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Bulumakau goyogoyoidi sitáoya, bulumakau dedevidi sitonoidi. Ameko ina kanamimiyana ikavava, e Pero matana ilala. ");
INSERT INTO gvs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Tauyana imasisimna, e aiyuwoina ikanamimimna. Ina kanamimiyana ame nakae: Witi tolobo tayamo goi didi ainima aiyuwo sitabo go, witi kutukutuna gagaidi be nakae dedevidi. ");
INSERT INTO gvs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","E niga ituli ta witi itabo go, tolobona goi didi ainima aiyuwo sitabo. Sitabo go, witi kutukutuna giyaidi nakae meemalidi yágira bomatu yaviyavina pasina. ");
INSERT INTO gvs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kidi didi goyogoyoidi sitáoya, didi dedevidi sitonoidi. E amoko goi Peroyana ikaliwoisa, itáoya idigo kana, ‘O moitamo akanamimi!’ ");
INSERT INTO gvs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","E vanuwo itomo, Peroyana mana kateyova inuwonúwana kana, ‘Guna kanamimi kaga adi yagoina?’ Tuwo tomeméyava liliudi be nakae tonuwopolala liliudi Itipita goi iduduwedi sima, e ina kanamimiyadi ilatuwokoidi. Ilatuwokoidi ikavava, idigo kana, ‘Guna kanamimiyadi kaga adi yagoina?’ Go geya kada tayaamo yaidi goi itoboine anamimiyadi italigeidi. ");
INSERT INTO gvs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ago vedi ana tomatakavatayao adi tovakumgo Iyosepa inuwaisi, tuwo ina Pero ilatuwoko idigo kana, ‘Guna tomoya, guna bágala alatuwokoim. Tayamo dogoi anuwoilave alatuwokoim. ");
INSERT INTO gvs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Boi tokaigábuna be yau im pakonayao kuegamogamoguyema, e im deri ana toyausayao adi tokalikumatana Potipari kulovinae deri goi ivaisiuma. ");
INSERT INTO gvs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Amoko goi sabamgo tayamo ama taiyuwokova kakanamimi go, anamimiyadi tamo tamo madi yagoina. ");
INSERT INTO gvs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ego koroto tayamo, tauyana Iberiu, kai taiyao deriyana goi kakaaiyaka. Korotoyana moe tokalikumatana ina pákwana. Tuwo, tauyana ima kanamimi kalatuwoko, e anamimi tamo tamo adi yagoina italigeidi. ");
INSERT INTO gvs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","E nakonakae anamimiyadi italigeidi, nakae simalatomota. Yau kebagu bogina kuvinimneigu go, kina tokaigabunayana wowona kusiko, e alova goi kuvakosaine ikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","E tuwo Pero ina topaisewayao ilatuwokoidi, idigo kana, ‘Kōna Iyosepa kokābi kōme.’ Tuwo woilidi sina Iyosepayana deri goi sikabi, sime. Ego mainao ana gábula itéui be nakae kwama dedevidi ilosidi. Ilosidi ikavava, ima Pero matana goi itáoya. ");
INSERT INTO gvs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","E Peroyana idigo kana, ‘Iyosepa, akanamimi go, geya vatau tayaamo itoboine italigei. Go yau livala anove bego kom anamimi adi talígava kuuyagoi.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","E Iyosepayana idigo kana, ‘Guna tomoya, anamimi adi talígava moe yau toinigu geya itoboineguta. Go sem Yaubada itoboine. Moitamo im kanamimi ana talígava bei ilatuwokoigu namliyeta baige alatuwokoim go, ana taligavayana bei am dedevina manuna.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","E Peroyana idigo kana, ‘Kunōve go, guna kanamimi alatuwokoim. Anamimiyana ame nakae: Sákala Nairi goi aatáoya go, ");
INSERT INTO gvs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","sakalayana goi bulumakau ainima aiyuwo dedevidi nakae saabalidi sisinalaga, e limou sikakáika. ");
INSERT INTO gvs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Sikakáika go, ituli ta bulumakau ainima aiyuwo sisinalaga. Bulumakauyadi sigoyo nakae sibagabaga. Adi kaigigita igoyo. Geya tayaamo tuta Itipita goi bulumakau agite ame tauyadi nakae; sigoyo toina. ");
INSERT INTO gvs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ame bulumakau bagabagaidiyadi sitáoya, bulumakau saabalidi sitonoidi. ");
INSERT INTO gvs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sitonoidi go, bulumakauyadi adi kaigigita neta geya sitonoidita. Moitamo. Nava adi bíbina sibaagabaga nakae boi mainao sibagabaga. E ameko goi matagu ilala. ");
INSERT INTO gvs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","E aiyuwoina guna kanamimi goi agite witi tolobo tayamo goi didi ainima aiyuwo sitabo go, kutukutuna gagaidi be dedevidi. ");
INSERT INTO gvs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Niga ituli ta witi tolobona tayamo goi didi ainima aiyuwo sitabo. Ago kutukutuna kasakasaidi, giyaidi be nakae meemalidi yágira bomatu yaviyavina pasina. ");
INSERT INTO gvs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kutukutu giyaidiyadi sitáoya, kutukutu dedevidi sitonoidi. Ame tauna guna kanamimi. E tomeméyava alatuwokoidi go, geya kada tayaamo vatau yaidi goi itoboine guna kanamimiyadi italigeidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Iyosepayana idigo kana, ‘Im kanamimiyadi aiyuwo adi yagoina tayamo. Yaubada bogina ivatulukoim manakaena bei giyakainava iguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Anamimiyadi adi yagoina ame nakae: Bulumakauyadi ainima aiyuwo dedevidi be witi didina ainima aiyuwo dedevidi moe tala ainima aiyuwo nakae. Im kanamimiyadi adi yagoina tayamo. Talayadi moe tala ainima aiyuwo dedevidi. ");
INSERT INTO gvs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Kidi go bulumakau bagabagaidiyadi be goyogoyoidi sisinalaga be nakae witi didina ainima aiyuwo meemalidi yágira bomatu yaviyavina pasina moe tala ainima aiyuwo nakae go, talayadi moe loga. ");
INSERT INTO gvs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Tauna nakae bogina alatuwokoim. Yaubada bogina ivatulukoim manakaena bei giyakainava iguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Gwa! Bei ame nakae iguinuwe: Tala ana badabada ainima aiyuwo goi asa Itipita ana madabokina bei imáliya gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Go amo talayadi mlidi tala ana badabada ainima aiyuwo goi loga gagaina bei isowóduwo Itipita sinaena, e asayana bei ibugoyai. ");
INSERT INTO gvs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Talayadi dedevidi bei konuwoilavedi loga pasina. Bogina kuyagoi; logayana bei igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","E kom boi sivayuwo kukanamimiko moe ana yagoina Yaubada bogina ilovina bego dogoiyana isowóduwo. Tuwo giyakainava bei anamimiyadi simalatomota. ");
INSERT INTO gvs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","E tauna koroto tayamo kukināve, korotoyana mana dovatusi be mana nuwopolala. Tauyana kuvayōko kina sobuyekoim go, Itipita ana madabokina ilovinae. ");
INSERT INTO gvs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Aiyuwoina gávana kukinavēdi go, kuvayokōidi kidi asa tamo tamo adi tomatakavatayao. Tala tamo tamo asa imáliya, e tala dedevidi goi tomota idi witi ana dibayoya sikaiguyauye gúguna ainima ainima. ");
INSERT INTO gvs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E gúguna aivasi tomota sikanidi go, im lovina goi gavanayadi gúguna tayamo boda tamo tamo goi sikabidi simedi sánala gagaidi goi sidodoidi loga ana tala manudi. ");
INSERT INTO gvs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Moe witiyana ikaaiyaka loga ana tala ainima aiyuwo manudi, e bei tutayana loga isowóduwo Itipita goi, tomota loga geya sikamaseta, go sem witiyana bei ivaitedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","E Pero be nakae ina tovakumgoyao paakonidi Iyosepa ina nuwonúwana sikaodedevine. ");
INSERT INTO gvs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tuwo Pero ilatuwokoidi idigo kana, ‘Manakae? Itoboineda koroto tayamo tababane Iyosepa nakae? Nakona geya. Ame tauyana yaina Yaubada Balomaina ikaaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tuwo Pero Iyosepa ilatuwoko idigo kana, ‘Iyosepa, geya vatau tayaamo mana dovatusi be mana nanamsa nakae kom unana Yaubada ivatulukoim kaga liliuna bei isowóduwo. Tauna im nuwopolala tomota liliudi idi nuwopolala ikalisavedi. ");
INSERT INTO gvs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kom bei avayokoim guna katumapu, guna vada be nakae da Itipita madabokidi nimam goi ayatoidi bei kuloviinaedi go, tomotayadi bei sopam sikabikaone. Yau aguta ataoyakukuim.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","E Pero idigomna kana, ‘Iyosepa, bogina kunove? Ame tutayana avayokoim kom guna katumapu, asa Itipita ana madabokina nimam goi ayato bei kuloovinae.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tuwo Pero ina rini mana kaba kinana ivalilivi go, Iyosepa nimaseliselina goi ivalilivi. Ikavava, kwama dedevina ikabi, Iyosepayana ivini ilosi. Ikavava, búyala goura ikabi, nukotona goi isiko. ");
INSERT INTO gvs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ego Pero ina sariyota aiyuwo, tayamo moe toinina manuna go, tayamo moe ana tosavaiyuwo manuna. Tuwo Iyosepa ilatuwoko idigo kana, ‘Iyosepa, guna sariyota tayamo avinim, e sariyotayana goi kusowōya.’ Tuwo isowoya go, koroto maniyedi sivakumgo sidigo kadi, ‘Toolagaina imamaima; aemi kovatugūyala!’ Ame nakae Iyosepa ivayoko kina ana katumapu bei Itipita ana madabokina iloovinae. ");
INSERT INTO gvs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","E aiyuwoina Pero Iyosepa ilatuwoko idigo kana, ‘Iyosepa, yau Pero, Itipita ana tolovina go, kom guna katumapu. Tauna lovina avinim bego Itipita goi tomota geya tayaamo kaga itoboinedi siguinuwe neta kom geya kutagoneta.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ibóbwara ikavava, Iyosepa ivayou Sapanadi Paneka go, vavina tayamo ikabi, Iyosepa ivini inai. Vavinayana yoina Asenati go, tamana yoina Potipera, tauyana da Oni idi tonúwala. Tauna nakae Iyosepa ietolovina Itipita ana madabokina goi. ");
INSERT INTO gvs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ego kina Iyosepayana ana tala 30 bogina ibabane, e ina paisewa Pero da Itipita adi tolovina manuna ivatowo. E itáoya ina asa tamo tamo Itipita sinaena ivadadedi. ");
INSERT INTO gvs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tala ainima aiyuwo goi asa imáliya gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tuwo Iyosepayana ina lovina goi ina topaisewayao sivaníbita tánuwo liliudi Itipita goi witi kutukutuna silamgogo go, asa tamo tamo adi sánala gagaidi goi sivadodoidi, moe tala ainima aiyuwo goyogoyoidi manudi. ");
INSERT INTO gvs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Witiyana gagaina sánala goi sidodoidi, nakae witi ma baikidi adi badabada nakae ediédila. Siidodoidi ana kadókana witiyana ivakaigaga, e geya tuwaina ana badabada buki goi siginidi. Bogina kuyagoi. Badabada sisaki, tauna geya itoboineyeta ikatuyaividi. ");
INSERT INTO gvs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","E kina go Iyosepayana nava loga geya isowoduwoita, e monena Asenati ivenátuna, natunao koroto adi taiyuwo. ");
INSERT INTO gvs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","E ina botomoya ivayou Manase kana, ‘Unana Yaubada tauna guna nuwomou anuwoilave be nakae osegowo anuwoilavedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","E natuna aiyuwoina ivayou Eparaim kana, ‘Unana Yaubada tauna guna kaiyakomou goi keuwoigu dedevina ababane.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","E tala ainima aiyuwo dedevidi Itipita goi sikavava ");
INSERT INTO gvs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","go, logayana ana tala ainima aiyuwo ivatowo nakae Iyosepa boi idigedige. Logayana isowóduwo asa liliudi goi go, Itipita ana madabokina goi tomota madi witi. ");
INSERT INTO gvs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Go niga Itipita goi nakae logayana silotowo. Tuwo tomota sima Peroyana yaina sitaiyaduduwo witi manuna. Go Peroyana idigo kana, ‘Kōna Iyosepa kogīte go, kaga ilatuwokoimi nakae koguinūwe.’ ");
INSERT INTO gvs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","E tutayana logayana gagaina isowóduwo Itipita ana madabokina goi, Iyosepa witi sanalidi ikatupaevedi go, witiyadi ikaigimonedi da Itipita yaidi. Logayana bogina gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ago ituli ta kasa liliudi goi tomota sima Itipita bego witi sigimona Iyosepa yaina. Bogina kuyagoi; logayana gagaina poyapoya ana madabokina goi. ");
INSERT INTO gvs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","E Yakobo vala inove bego Itipita goi witi ikaaiyaka, tuwo natunao iduduwedi sima ilatuwokoidi idigo kana, ‘Komi kaga kokaiyakoe? ");
INSERT INTO gvs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Konōve. Vala anove Itipita goi witi ikaaiyaka. Tauna komi kosōu kōna ada witi kogimōna, govila bei loga takámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","E tuwo moitamo Iyosepa tuwowonao yawou sina Itipita goi bei witi sigimona. ");
INSERT INTO gvs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","E kina go Iyosepa ana gómana Beniyamina ikaaiyaka; Yakobo geya ietuneyeta senao taiyao. Imatoita; ina nuwonúwana kana, ‘Nakona bei vailai ibabane.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","E tuwo Isileli natunao be Kenani tomotaidi taiyao sina Itipita goi bego adi witi sigimona. Bogina kuyagoi; Kenani asaina tomota loga sikámasa. ");
INSERT INTO gvs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ego kina Iyosepayana da Itipita adi tolovina. Ame tauyana tomota liliudi adi witi ana tokaigimona. E tuwowonao sima tauyana matana goi aedi sivatugúyala sikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","E Iyosepa igitedi, ikinanedi go, geya ilatuwokoidita, go sem ikatubaudi. Ina sinapu nakae bego geya iyagoidita. Tauna mana kubukasa ilatuwokoidi idigo kana, ‘Komi nako goi koma?’ ‘Kenani goi kama latuwoma ama witi kagimona’, kidi kaedi. ");
INSERT INTO gvs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Ego Iyosepa tuwowonao ikinanedi go, tauyana kidi geya sikinaneyeta. ");
INSERT INTO gvs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tutayana tuwowonao aedi sivatugúyala, ina kanamimi aiyuwo boi ikanamiimiyedi inuwokavatedi, tuwo tuwowonao geya ilatuwokoidita kina adi gómana, go sem iwowokoidi idigo kana, ‘Kopola! Komi toyáusa. Koma ima kasa kogite nako goi ineneta.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Go kidi sidigo kadi, ‘Ima tomoya, moe nakae geya! Kai im pakonayao kama latuwoma bego ama witi kagimona. ");
INSERT INTO gvs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kai madabokima koroto tayamo natunao. Kai toyáusa geya. Kai im pakonayao koroto todedevima.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Go kina Iyosepayana idigo kana, ‘Geya, kopola! Komi koma latuwomi ima kasa kogite nako goi ineneta.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Go kidi sidigo kadi, ‘Ima tomoya, kai im pakonayao boi kai ama badabada yawou aiyuwo, tamama tayamo. Kenani goi kakaiyaka. Go bogomane nava tamama taiyao Kenani goi sikaaiyaka go, ama gómana tayamo bogina ikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Go kina Iyosepayana idigo kana, ‘Nakae bogina alatuwokoimi, komi toyáusa! ");
INSERT INTO gvs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Go tuwo. Bei avakakonemi ame nakae: Pero yoina goi akatótula ame asayana geya kokalaveyeta ana kadókana tamami ana bogomane ima ameko. ");
INSERT INTO gvs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Koroto tayamo yaimi koetūne ina ami gómana ikabi ime go, madabokimi ameko deri goi kokaaiyāka, e bei ayagoi nakona komi aba numisa gea geya. Neta siyami geya ikaluvileta, bei ayagoidoko komi moitamo toyáusa!’ ");
INSERT INTO gvs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tuwo deri goi ivaisiudi maliyalina aito goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Go maliyalina aitonina goi Iyosepa ina topaisewayao ilatuwokoidi sina tuwowonao deri goi sikabidi simedi. Sina sikabidi simedi, Iyosepa ilatuwokoidi, idigo kana, ‘Neta guna nuwonúwana bei alatuwokoimi koguinuwe, e ma yawoimi kokaaiyaka. Bogina koyagoi; Yau Yaubada ataaimamine. ");
INSERT INTO gvs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Guna nuwonuwanayana ame nakae: Neta komi koroto todedevimi, koroto tayamo yaimi ameko deri goi ikaaiyaka go, madabokimi semiyao tokodaloga adi witi kokabīdi konavēdi imi kasa goi kovinīdi avadi. ");
INSERT INTO gvs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Go ami gómana kōme yaigu bei itoboinegu imi livala akamoitamoe. Neta nakae koguinuwe, e ma yawoimi kokaaiyaka.’ Tuwo moitamo sitagona nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ago kidi tuwowonaoyadi taudiva toinidi niyadi goi sibóbwara sidigo kadi, ‘Boi ada gómana ina kategeda tagite tutayana ina kawanoi makimaki nuwokapisi manuna kita geya tanoveyeta. Tauna moitamo kita mada goyo ada gómana pasina. Ame pasina ame ida nuwotukalayana bogina tababane.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","E Rubeni idigo kana, ‘Manakae? Boi alatuwokoimi gomanayana taabu koyogeedegēde gea geya? Moitamo alatuwokoimi go, geya konoveguta! Tauna ame ina kámasa ana katumapu bogina tababane.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ego kidi Iyosepa tuwowonao sinuwonúwana bego niyadi geya iyagoiyeta. Tokaigavila niyadi ikaigavile Iyosepa ilatuwoko. Go Iyosepayana niyana kidi niyadi tayamo! ");
INSERT INTO gvs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","E tauyana inovedi, tuwo inuwokapisiyedi, e isiboila ina itáiya. Itáiya ikavava, mataiuna isekuku, e isowóduwo ima ina topaisewayao ilatuwokoidi idigo kana, ‘Ame tauyana koyōisi, nimana koyowōidi.’ Tuwo moitamo sina tuwowonao matadi goi Simioni siyoisi, nimana siyowóidi. ");
INSERT INTO gvs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","E Iyosepa ina topaisewayao ilatuwokoidi idigo kana, ‘Ame korotoyadi idi baiki goi adi witi kovadodōidi go, idi mani ma saisailidi kokabīdi, idi baiki goi kododōidi. Ago taabu kolatuuwokōidi. Tuwaina adi kinare kovinīdi adi kenao manuna.’ Tuwo moitamo sina nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ame ikavava, Iyosepa tuwowonao sina adi witi ma baikidi ase goi sikailagasidi. ");
INSERT INTO gvs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Sikatubayasi ikavava, e siketoiya go, vanuwo isabamgo tunagu tayamo sigite, tuwo amoko goi siwaiwasi. Siwaiwasi go, koroto tayamo yaidi goi ina baiki ikatupáeve bei witi ikabi, ina ase ivavani go, ikandosobu ina mani ma saisairina baiki tobuna goi igitebabane. ");
INSERT INTO gvs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Igitebabane, senao ilatuwokoidi idigo kana, ‘Iyaa! Segowo, guna mani witi manuna guna baiki goi sidodoimnei. Goame baikiyana tobuna goi. Kōma kogīte!’ Tuwo madabokidi sima sigite, e atedi siyova gagaina nakae wowodi sitátava go, sidigo kadi, ‘Ame kaga Yaubada iguinuwe yaida!’ ");
INSERT INTO gvs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","E siketoiya sina Kenani goi sisiu sina tamadi Yakobo ina vada goi go, tauyana yaina sivatétala adi kaibako, sidigo kadi, ");
INSERT INTO gvs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","‘Tamama, Itipita korotoina, tauyana da Itipita adi tolovina, ibowoima be nakae iwowokoima kana, “Komi toyáusa.” ");
INSERT INTO gvs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ago kai kalawoiwoi kama, “Kai toyáusa geya. Kai koroto todedevima. ");
INSERT INTO gvs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Boi kai koroto ama badabada yawou aiyuwo, tamama tayamo. Ama gómana tayamo bogina ikámasa go, bogomane nava tamama taiyao Kenani goi sikaaiyaka.” ");
INSERT INTO gvs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ago kina korotoyana, moe tolovina, idigo kana, “Tuwo ame nakae aguinuwe bei ayagoi neta komi koroto todedevimi: Koroto tayamo yaimi goi ameko yau taiyao kakaiyaka go, madabokimi semiyao tokodaloga adi witi kokābi avadi. Kokabi ikavava, kōna imi kasa. ");
INSERT INTO gvs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kōna go, ami gómana kokābi kōme yaigu, e bei ayagoi bego komi geya toyáusa geya, go sem koroto todedevimi. Gomanayana agite, e siyami bei ataligei go, atagona ami witi kogimona.”’ ");
INSERT INTO gvs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","E sibóbwara ikavava, koroto tamo tamo idi baiki sikaliulagidi go, tamo tamo idi mani ma saisairidi sigitebabanedi adi witi taiyao! Tuwo tauyadi tamadi taiyao maniyadi sigitedi, atedi siyova. ");
INSERT INTO gvs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","E tamadi Yakobo gamona igoyo idigo kana, ‘Komi pasimi natugowo sitagau! Iyosepa bogina itagau. Simioni nakae itagau go, bego ame tutayana latuwomi Beniyamina kokabi konave? Neta konave, yau guna nuwomou koyatoyato!’ ");
INSERT INTO gvs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Go kina Rubeni idigo kana, ‘Natum Beniyamina bei akaluvilemnei, go neta geya, e natugowo adi taiyuwo atagonedi kukaumatedi. Tamagu, kunumisēgu. Gomanayana nimagu goi kuyāto, niga bei akaluvilemnei.’ ");
INSERT INTO gvs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Go kina Yakoboyana idigo kana, ‘Yau natugu bei geya iwoita komi taiyao! Siyana bogina ikámasa go, tauyana anetava ikaaiyaka. Tauna bei geya iwoita! Neta konavenave kenao goi ivailai, e komi guna nuwomou koyato, tauna yau magu nuwomou ana kadókana akámasa asou Saola goi.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","E logayana Kenani goi nava gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","E tuwo tutayana Yakobo ma natunao idi witi boi sigiimonedi Itipita goi bogina sikanisavedi, e tamadi idigo kana, ‘Kokaluvilāmna kōna ada witi tuwaina kogimōna, e kōma.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Go kina Yuda idigo kana, ‘Go tamagu, korotoyana boi ikatumatalidokoima idigo kana, “Neta ami gómana kome yau yaigu, e bei atagona ami witi kogimona, go geya, e geya kogiteguta.” ");
INSERT INTO gvs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tuwo neta kutagona bego ama gómana kanave, e kana ada witi kagimona. ");
INSERT INTO gvs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Go neta gomanayana geya kutagoneyeta, e kai geya kanoita. Bogina kuyagoi; korotoyana idigo kana, “Neta ami gómana kome yau yaigu, e bei atagona ami witi kogimona, go geya, e geya kogiteguta.”’ ");
INSERT INTO gvs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Go kina tamadiyana idigo kana, ‘Kaga unana korotoyana kolatuwoko kami, “Ama gómana tayamo amoni?” Kogite? Guna mou bogina koyato!’ Tauyadi kadi, ");
INSERT INTO gvs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","‘Korotoyana ilumadádana ima boda manuna. Tauyana idigo kana, “Tamami nava ikaaiyaka? Ami gómana tayamo amoni?” Tuwo kai katalavaitamo. Ago tauyana idigo kana, “Ami gómana kokābi, kōme.” Ego neta kayagoi tauyana ina nuwonúwana nakae, geya katalavaiteta.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","E Yuda idigo kana, ‘Tamagu, kutagōna bego gomanayana kakabi kanave, e bei mainao kana kama bego kita be natudao taiyao loga geya takamaseta. ");
INSERT INTO gvs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","E yau akatótula toinigu gomanayana bei arugwausi. Tauyana yau guna puwoya. Neta ama gómana geya akaluvileyeta nakae matam goi geya ayatoeta, e yawoigu ana madabokina goi kuwowokōigu. ");
INSERT INTO gvs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kai bogina kakaimúmuna unana gomanayana kuvagagale. Moitamo. Neta boi mainao kutagona, e kai neta bogina sivayuwo kaketoiyako.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","E Isileli idigo kana, ‘Neta moe nakae, ame nakae koguinūwe. Dogoi dedevidi kita ida kasa goi sikaaiyaka nakae mokava, pútuma, alovamamaina sisina be taniya kokabīdi, imi baiki goi kododōidi, e konavēdi tolovinayana kovīni. Moe ida yabobona korotoyana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Go imi mani tuwaina kokabīdi be nakae maniyadi boi koonavedi nakae kokabīdi taiyao konavēdi. Konuwāisi boi imi mani sivadodoimneidi imi baiki sinaena. Nakona tauyadi sibágala. ");
INSERT INTO gvs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ami gómana nakae kokābi, e woilīmi konāve korotoyana yaina! ");
INSERT INTO gvs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Bei Yaubada Tokalika inuwokapisiyemi korotoyana matana goi, e bei tauyana latuwona Simioni be Beniyamina italigeidi taiyao kokaluvilamna koma. Go yau sem neta natugowo ivagagaledi, bogina sitagau, e nuwogu imou.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","E tuwo idi yabobona be idi mani gagaina sikabidi nakae Beniyamina sikabi, e woilidi sina Itipita. Itipita goi sisiu sina Iyosepa matana goi sitáoya. ");
INSERT INTO gvs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","E Iyosepa ikandobala Beniyamina igite kidi taiyao. Tuwo ina vada ana tovakumgo ilatuwoko idigo kana, ‘Ame korotoyadi kukabīdi, kumēdi yau guna vada goi. Kumedi ikavava, kūna tayamo yoguyogu kwaumāte kuvaipōlu. Ikavava, e dine goi taiyao kakáika.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","E tuwo tovakumgoyana ina kaga Iyosepa ilaatuwoko, e nakae iguinuwe. Korotoyadi ikabidi, imedi Iyosepa ina vada goi. ");
INSERT INTO gvs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","E ame pasina tauna simatoita gagaina. Tuwo sidigo kadi, ‘Ida mani boi ida baiki goi sivadodoimneidi pasina simeda vada goi. Tauyana latuwona iyoisida, ilauida, e bei kita ina pakonayao go, ida ase ikabidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tuwo tauyadi sina vadayana totomna goi Iyosepa ina vada ana tovakumgo silatuwoko sidigo kadi, ");
INSERT INTO gvs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","‘Tomoya e, boi kama ameko avama kagimona. ");
INSERT INTO gvs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ego tutayana kanonoina ima kasa manuna, e tunagu tayamo goi kawaiwasi, e ima baiki kakatupaevedi go, kai tamo tamo ima mani ma saisailidi madabokidi kagitebabanedi! Tauna maniyadi kamedi; latuwoma bego kavinimneim. ");
INSERT INTO gvs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Go mani tuwaina kamedi latuwoma bego ama witi tuwaina kagimona. Ago geya kayagoiyeta avatau ima mani ima baiki goi idodoimneidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","E tovakumgoyana idigo kana, ‘Mani manuna taabu konuuwonūwana be nakae taabu koomatōita. Imi Yaubada, Tauyana tamami ina Yaubada, nakona imi esaesa ivinimi; imi baiki goi idodoidi. Boi mainao imi mani komedi bogina akabidi.’ Ibóbwara ikavava, ina Simioni ikabi, ime kidi yaidi. ");
INSERT INTO gvs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ikavava, Iyosepa ina vada ikatupáeve korotoyadi sisiu go, bwae ivinidi bei aedi sinikidi. Ivinidi ikavava, ina idi ase ivavanidi. ");
INSERT INTO gvs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","E korotoyadi idi yabobona Iyosepa ina sowóduwo dine manuna sikatubayasi. Bogina kuyagoi, livala sinove bego taiyao sikáika. ");
INSERT INTO gvs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","E Iyosepa ima, idi yabobonayadi maine simemedi sivini go, tauyana matana goi aedi sivatugúyala. ");
INSERT INTO gvs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","E idigo kana, ‘Manakae? Dedevimi? Go tamami, tauyana dedevina? Nava ikaaiyaka ae?’ ");
INSERT INTO gvs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","‘Tamama, tauyana im pákwana, nava ikaaiyaka dedevina’, tauyadi kaedi. Sibóbwara ikavava, aiyuwoina madi wowoina aedi sivatugúyala tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","E tauyana imatavilavila go, ana gómana Beniyamina igite, tauyana toinina sinana natuna, tuwo idigo kana, ‘Ame tauyana ami gómana ae? Boi kovateteli ae?’ Ego Beniyamina ilatuwoko kana, ‘Natugu, Yaubada bei ikanuwoiyem.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","E woilina vada goi isowóduwo. Tutayana Beniyamina igite, e ina lotówana ana gómana manuna ivakaigaga, latuwona bego itáiya, tuwo isiu ina vabodaupa tayamo goi itáiya. ");
INSERT INTO gvs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Itáiya ikavava, mataiuna iniki. Ina lotówana itoto go, ina pakonayao ilatuwokoidi idigo kana, ‘Avama kovaidēde.’ ");
INSERT INTO gvs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tuwo awoinu sivaidede go, Iyosepa aneta ikaaiyaka, senao nakae aditava. Maniyedi da Itipita sikaaiyaka go, kidi nakae aditava. Bogina kuyagoi; kidi da Itipita geya itoboinedita kidi Iberiu taiyao sikáika. Moitamo. Moe sinuwomoláita. ");
INSERT INTO gvs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","E Iyosepa matana goi tuwowonao siitusobu go, ilovina bego idi tusobuyana moe adi bíbina goi. Botomoya isou ina bogomane. Siitusobu go, kidi simatavilavila nukotodi iwówana kadi, ‘Manakaena iyagoida ada bíbina?’ ");
INSERT INTO gvs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","E Iyosepa toinina avana dedevina ikinavedi, ina pakonayao ilatuwokoidi sikabidi, korotoyadi sivinidi. Tuwo koroto tamo tamo noko tayamo go, awoinu gagaina Beniyamina ivini, nakae ana noko ainima. E tuwo sikáika, sinim siuyáwana Iyosepa taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Tuwo sikáika ikavava, e Iyosepa ina vada ana tovakumgo ilatuwoko idigo kana, ‘Ame tauyadi idi baiki witi goi kuvakayaodēidi nakonakae idi ase itoboinedi sikavaledi. Ikavava, koroto tamo tamo idi mani nakae idi baiki tobudi goi kuvadodoimnēidi. ");
INSERT INTO gvs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Moe ikavava, guna vedi kukābi. Vediyana moe siriba kukābi go, bogomane ina baiki goi kudodōi ina mani taiyao.’ Tuwo iguinuwe nakae Iyosepa idige. ");
INSERT INTO gvs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Simasisi vanuwo itomo, konadi idi ase goi sikailagasidi, e sivaduduwedi sina. ");
INSERT INTO gvs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","E kidi asa goi sisowóduwo siiketoiya ivatabaledi go, kina Iyosepa itáoya ina vada ana tovakumgo ilatuwoko kana, ‘Woilīm kutāoya, kūna amo korotoyadi kosabokuliyēdi. Tutayana kusakavatedi, kulatuwokōidi kam, “Manakae? Bego ima guinuwa dedevina goyo goi kokatumapu? ");
INSERT INTO gvs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kaga unana guna tomoya ina vedi kovainao? Vediyana moe aba kinana, tauna moe vediyana goi itoboine ikokósala. Moe imi guinuwayana, guinuwa goyogoyoina toina.”’ ");
INSERT INTO gvs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","E tuwo tovakumgoyana itáoya, woilina ina. Tutayana isakavatedi, e ilatuwokoidi nakae ina tomoya idige. ");
INSERT INTO gvs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Go kidi silawoiwoi sidigo kadi, ‘Ima tomoya, kaga unana nakae kudige? Iyagoida! Kai im pakonayao nakae geya kaguinuweyeta. ");
INSERT INTO gvs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kunōve! Boi Kenani goi maniyadi kagitebaabanedi ima baiki sinaedi goi bogina kakaluvilemneidi. Tauna manakae? Bego im tomoya ina goura o ina siriba kavainaoidi? Geya! ");
INSERT INTO gvs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ava koroto yaima goi neta im tomoya ina vedi ivainao, e itoboine ikámasa go, madabokima im pakonayao nakae.’ ");
INSERT INTO gvs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Go kina tovakumgoyana kana, ‘Kobóbwara moitamo. Tovaináwana itoboine ina liuna ibabane go, ina liunayana ame nakae: Avatau vediyana ivainao, tauyana anetava bei yau guna pákwana go, madabokimi tutubeso, e itoboinemi kona.’ ");
INSERT INTO gvs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tuwo koroto tamo tamo idi baiki sikaisobuyedi, sikatupaevedi. ");
INSERT INTO gvs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","E tovakumgoyana baiki tamo tamo goi ilusala go, ina lusalayana adi bíbina goi ame nakae: Botomoya ina baiki goi ivatowo go, bonauyayana tamo tamo idi baiki goi ilusala. Ame ikavava, bogomane ina baiki goi ilusala. Ilusala, moitamo vediyana Beniyamina ina baiki goi ibabane. ");
INSERT INTO gvs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Tuwo vediyana sigite, nuwodi imou gagaina, tuwo adi kwama giyaina sikiisedi. Sikiisedi ikavava, madabokidi konadi sikatubayasidi, idi ase yatana goi sikailagasidi, e sikaluvilamna sina Iyosepa ina kasa goi. ");
INSERT INTO gvs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","E tutayana Yuda ma senao sima Iyosepa ina vada, tauyana nava ikaaiyaka vada sinaena. Tuwo sisiu Iyosepayana matana goi aedi sivatugúyala. ");
INSERT INTO gvs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","E tauyana idigo kana, ‘Ame kaga koguinuwe yaigu! Manakae? Geya koyagoiyeta bego yau itoboinegu akokósala, tauna itoboinegu akinane vediyana nako ina?’ ");
INSERT INTO gvs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","E kina Yuda idigo kana, ‘Ima tomoya, manakaema kabóbwara? Manakaema kavatulukoim bego kai geya tayaamo goyo kaguinuwe? Geya ae? Ima goyo Yaubada bogina ikaiwoduwe. Ame tutayana kai im pakonayao nakae, madabokima nakae korotoyana im vedi ivainao.’ ");
INSERT INTO gvs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Go kina Iyosepayana idigo kana, ‘Moe nakae geya! Tovaináwana anetava bei guna pákwana. Komi madabokimi sem mami dedevina kokaluvīla kōna tamami yaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Go kina Yuda idigo kana, ‘Guna tomoya, yau im pákwana kutagonēgu giyaina abóbwara. Kom Pero kovavasa nakae go, tuwo taabu kuegamogamooguyēgu. ");
INSERT INTO gvs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Guna tomoya, boi kai im pakonayao kulumadadema kam, “Komi ma tamami be nakae mami gómana?” ");
INSERT INTO gvs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Tuwo kai kama, “U, tamama ikaaiyaka, bogina ikaitomoya go, ama gómana tayamo amoni tamama taiyao sikaaiyaka. Ago gomanayana tuwowona toina bogina ikámasa, tauna sinana natuna tayamo toito ikaaiyaka go, gomanayana tamama ina kakaya.” ");
INSERT INTO gvs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","E kom kam, “Kotūko kōna gomanayana kokābi kosōuye kōme agite.” ");
INSERT INTO gvs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Go kai kama, “Gomanayana geya itoboineyeta tamama ikalave, govila bei tamama mana nuwomou ikámasa.” ");
INSERT INTO gvs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Go kom kudigo kam, “Neta gomanayana geya kosouye komeyeta, e geya tuwaina bei kogitegu bego ami witi kogimona.” ");
INSERT INTO gvs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tuwo kai kakaluvila kana tamama goi kaga liliuna kulatuuwokoima tamama kalatuwoko. ");
INSERT INTO gvs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","E niga tamama idigo kana, “Natugowo, kokaluvīla kōna ada witi tuwaina kogimōna, e kōma.” ");
INSERT INTO gvs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Go kai kadigo kama, “Geya itoboinemeta kasou kana, go sem neta kutagona bego ama gómana taiyao kana, bei kasou kana. Neta gomanayana taiyao geya, korotoyana bei geya igitemeta bego ada witi kagimona.” ");
INSERT INTO gvs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","E tuwo tamagu im pákwana idigo kana, “Komi bogina koyagoi bego monegu natugowo adi taiyuwo ivenatunidi. ");
INSERT INTO gvs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Tayamo bogina ikalavegu, kagu, ‘Moitamo nakona woiwoi sikayapesapesagii.’ Tuwo geya tuwaina bei maisina agite. ");
INSERT INTO gvs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tauna neta natugu konavenave kenao goi ivailai, e komi guna nuwomou koyato, tauna magu nuwomou ana kadókana akámasa asou Saola goi.” ");
INSERT INTO gvs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","E tauna neta gomanayana ameko kakalave go, ametava kakaluvila kana tamama yaina, e tutayana igite natuna geya kai taiyao geya, bei ikámasa. Bogina kuyagoi. Gomanayana moe ana kakaya. Moeko goi ina nuwomou bogina kayato, tauna bei mana nuwomou ana kadókana ikámasa isou Saola goi. ");
INSERT INTO gvs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Moe moitamo. Boi tamagu yaina akatótula bei gomanayana arugwausi. Tauyana alatuwoko kagu, “Neta ama gomanayana geya akaluvileyeta, moe bei yau guna puwoya yawoigu ana madabokina goi.” ");
INSERT INTO gvs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","E tauna guna tomoya, kutagōna bego yau akaaiyaka im pákwana nakae go, guna gomanayana ikaluvilamna tuwowonao taiyao. ");
INSERT INTO gvs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Moitamo. Manakaegu bei akaluvila ana tamagu yaina neta gomanayana geya taiyao? Geya. Yau geya anoita, govila bei tamagu ina kategeda agite.’ ");
INSERT INTO gvs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tuwo livalayana Iyosepa inove, geya itoboineyeta ina nuwomou itoto ina topaisewayao madabokidi matadi goi, tuwo ilatuwokoidi kana, ‘Madabokimi kosowōduwo!’ Tuwo topaisewayadi sisowóduwo go, kina tuwowonao taiyao sikaaiyaka tutayana Iyosepa toinina italavaite tuwowonao yaidi. ");
INSERT INTO gvs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tauyana itáiya gagaina nakae da Itipita moetala goi sikaaiyaka sinove be nakae kidi Pero ina vada goi sinove. ");
INSERT INTO gvs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","E tuwowonao ilatuwokoidi idigo kana, ‘Segowo, yau Iyosepa ami gómana! Manakae? Tamada dedevina?’ Go kidi tuwowonao geya itoboinedita mainao sibóbwara. Atedi iyova gagaina Iyosepa maa yawoina pasina. ");
INSERT INTO gvs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","E Iyosepa aiyuwoina ibobwaramna kana, ‘Segowo, kōbala kōma kikigu.’ Tuwo moitamo sibala sima kikina goi sitáoya go, tauyana idigo kana, ‘Yau ami gómana Iyosepa. Boi kokaigimonegu da Itipita yaidi! ");
INSERT INTO gvs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Go ame taabu kokaateyōva be nakae taabu toinimi koobowōimi amo imi guinuwayana pasina. Yaubada ietunegu ama ameko bego avakumgoiyemi, e bei kita tomota ayaveda. Tauna taabu komatooitēgu. ");
INSERT INTO gvs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Moitamo. Ame logayana poyapoya ame goi tala aiyuwo bogina ikaaiyaka go, tala ana badabada ainima tuwaina bei sikaaiyaka. Tauna bágula be dibayoya geya. ");
INSERT INTO gvs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Yaubada ietunegu avakumgoiyemi bei itoboinegu ayavemi, e bei tubudao poyapoya ame goi sikaiyaka dedevidi. ");
INSERT INTO gvs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","E tauna komi geya koetuneguta, go sem Yaubada ietunegu. Ina nuwonúwana goi yau Pero ivayokoigu yau ina vada ana tolovina be nakae da Itipita madabokidi adi tolovina. ");
INSERT INTO gvs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tauna ame tutayana woilīmi kōna tamada kolatuwōko kami, “Natum Iyosepa idigo kana, ‘Yaubada ina nuwonúwana goi yau Itipita ana madabokina alovinae. Woilīm kusōu kūma yaigu. ");
INSERT INTO gvs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kom bei Goseni dadavina goi kwaiyaka, moe Itipita sinaena. Kom be natumowo be tubumowo, im yoguyoguyao be konam madabokidi. ");
INSERT INTO gvs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Amoko goi bei amatakaavatem. Bogina kuyagoi. Tala ainima nava bei loga ikaaiyaka. Tauna kūma, govila bei kom be osemowo loga kokámasa.’” ");
INSERT INTO gvs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","E komi Beniyamina taiyao bogina kogitegu bei koyagoi bego moitamo yau Iyosepa siyami avaadigoimi. ");
INSERT INTO gvs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tauna kaga liliuna Itipita sinaena bogina kogite, e kōna tamada kolatuwōko, nakae yau da Itipita liliudi siwowoinegu. Tamada kolatuwōko yau koroto toogagaigu Itipita goi. Ago woilīmi kotūko kōna tamadayana kokābi kosōuye kōme.’ ");
INSERT INTO gvs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ibóbwara ikavava, Beniyamina ivayavau nukotona goi iyoisi, iyowoi, e taiyao sitáiya. ");
INSERT INTO gvs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ikavava, Iyosepa mana táiya tuwowonao iyowoiidi. Iyowoiidi ikavava, taiyao sivatétala. ");
INSERT INTO gvs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","E niga Pero livala inove bego Iyosepa senao bogina sima, e livalayana pasina Pero mana tovakumgoyao taiyao siuyáwana. ");
INSERT INTO gvs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","E tuwo Iyosepayana iduduwe ima idigo kana, ‘Iyosepa, semowo kulatuwokōidi konadi ase goi sivadodoidi. Sivadodoidi ikavava, sikaluvila sina Kenani goi. ");
INSERT INTO gvs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Amoko goi tamam be osemiyao sikabidi, taiyao sikaluvila sima go, poyapoya dedevina Itipita sinaena avinidi, e bei awoinu dedevidi sikáika. ");
INSERT INTO gvs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Aiyuwoina kulatuwokōidi kam, “Ame nakae koguinuwe: Dedeoga ma kaena bulumakau sibiubiu Itipita goi kokabīdi, e bei monemiyao be natumiyao itoboinedi sisowoya. Aiyuwoina tamami kokābi kōme. ");
INSERT INTO gvs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Go geya konuwonuwoneta konami manudi. Bogina koyagoi. Konami dedevidi ameko Itipita goi bei kobabanedi.”’ ");
INSERT INTO gvs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","E tuwo Isileli natunao nakae siguinuwe. Iyosepa dedeoga ma kaena ivinidi nakae Pero ilovina. Nakae adi kinare idi kenao manuna ivinidi. ");
INSERT INTO gvs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Koroto tamo tamo adi kwama tayamo tayamo ivinidi go, Beniyamina siriba ana badabada 300 be nakae kwama ainima ivini. ");
INSERT INTO gvs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ago tamana manuna ase yawou ietunedi sina go, aseyadi goi Itipita konanidi dedevidi ikailagasidi. Aiyuwoina ase bovavina yawou toludi goi witi gagaina be nakae tamana ana kinare ina ketoiya manuna ikailagasidi. ");
INSERT INTO gvs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","E sikatubayasi ikavava, senao ivaduduwedi siketoiya go, Iyosepa idigo kana, ‘Enao goi taabu kokaumaakimāki!’ ");
INSERT INTO gvs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tuwo Itipita sikalave situko sina Kenani goi sisiu sina tamadi Yakobo ");
INSERT INTO gvs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","silatuwoko sidigo kadi, ‘Tamama, Iyosepa amoni, maa yawoina! Tauyana da Itipita adi tolovina.’ Kidi idi livalayana Yakobo inove go, nukotona iwówana. Ina nuwonúwana kana, ‘Tauyadi sikatubaugu.’ ");
INSERT INTO gvs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Go tutayana kaga liliuna Iyosepa iidigedi tamadi silatuwoko be nakae dedeogayadi Iyosepa ieetunedi igitedi, e iuyáwana. ");
INSERT INTO gvs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","E Isileli idigo kana, ‘O moitamo, imi bóbwara bogina itamyabigu. Natugu Iyosepa woi amoni ma yawoina ikaaiyaka. Bei ana agite, govila bei geya agiteyeta go, akámasa.’ ");
INSERT INTO gvs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","E tuwo Isileli itáoya konana ikatubayasidi. Ikatubayasidi ikavava, e ina bodao taiyao siketoiya sina asa Bera Siva goi. Amoko goi yoguyogu ikabidi, ikaumatedi ikailagasidi aba kasala goi igabudi, ikasaledi Yaubada yaina. Ame Yaubadayana yaina tamana Aisake nakae boi isaakululu. ");
INSERT INTO gvs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","E sabamgo goi Yaubada ina Isileli ikatuwoini idigo kana, ‘Yakobo! Yakobo!’ ‘U, yau amegu’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","E Yaubada idigo kana, ‘Yau Yaubada. Yau yaigu tamam boi isaakululu. Taabu kuumatōita bego kusou kuna Itipita goi. Moitamo. Amoko goi bei akisailim, e bei tubumowo boda tayamo gagaina. ");
INSERT INTO gvs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Yau bei avakitaum tutayana kusou kuna Itipita goi. Go niga bei tubumowo akaluvilemneidi poyapoya ame goi sikaiyaka. E kina go natum Iyosepa im tuta ámasa goi bei ikaaiyaka yaim, e bei itoboine matam itapopoli.’ ");
INSERT INTO gvs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","E tuwo Yakobo imasisi. Imasisi vanuwo itomo, itáoya, dedeogayadi boi Pero ieetunedi goi isowoya itulaga tubunao be natunao monediyao taiyao. Sisowoya ikavava, Bera Siva sikalave. ");
INSERT INTO gvs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Idi yoguyoguyao be konadi liliudi Kenani goi sibaabanedi, sikabidi, e sinavedi Itipita goi. ");
INSERT INTO gvs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yakobo natunao be tubunao liliudi inavedi Itipita goi. ");
INSERT INTO gvs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","E ame Isileli natunao be tubunao koroto madi bodayáuwo sina Itipita. Yoidi ame nakae: Rubeni moe Yakobo ina botomoya. ");
INSERT INTO gvs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","E Rubeni natunao koroto yoidi ame nakae: Enoki, Palu, Esironi be Karami. ");
INSERT INTO gvs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","E Simioni natunao koroto yoidi ame nakae: Yemweli, Yamini, Owadi, Yakini, Sokara be Saulo. Sauloyana sinana Kenani vavinaina. ");
INSERT INTO gvs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","E Livai natunao koroto yoidi ame nakae: Gerasoni, Kowate be Merari. ");
INSERT INTO gvs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","E Yuda natunao koroto yoidi ame nakae: Era, Onani, Seile, Peresi be Serako. Ego Era be Onani Kenani goi sikámasa. Peresi natunao koroto ame nakae: Esironi be Emla. ");
INSERT INTO gvs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","E Isakara natunao koroto yoidi ame nakae: Toli, Puva, Yobi be Simroni. ");
INSERT INTO gvs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","E Sebuloni natunao koroto yoidi ame nakae: Seredi, Eloni be Yaliyela. ");
INSERT INTO gvs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Amo Yakobo natunao koroto nakae natuna vavina Daina Padani Aram goi Reya ivenatunidi. Natunao be tubunao liliudi Reya goi adi badabada 33. ");
INSERT INTO gvs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","E Gadai natunao koroto yoidi ame nakae: Sipiyoni, Agi, Suni, Esiboni, Eri, Arodi be Areli. ");
INSERT INTO gvs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","E Aseri natunao koroto yoidi ame nakae: Imna, Isiva, Isivi, Bariya. Ego niudi yoina Seraka. Bariyayana natunao koroto yoidi ame nakae: Keveri be Malikiyeli. ");
INSERT INTO gvs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Amo Yakobo natunao koroto Silipa ivenatunidi. Boi Silipayana Lebani ina pákwana go, natuna Reya ivini. Yakobo natunao be tubunao liliudi Silipayana goi adi badabada yawou ainima tayamo. ");
INSERT INTO gvs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","E Yakobo monena Reitiyeli natunao koroto adi taiyuwo ivenaatunidi yoidi Iyosepa be Beniyamina. ");
INSERT INTO gvs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","E Itipita goi Iyosepa monena Asenati ivenátuna, natunao koroto adi taiyuwo, Manase be Eparaim. Asenati tamana Potipera, tauyana Tonúwala asa Oni goi. ");
INSERT INTO gvs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","E Beniyamina natunao koroto yoidi ame nakae: Bela, Bekeri, Asibela, Gera, Namani, Ei, Rose, Mopima, Kupim be Aridi. ");
INSERT INTO gvs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Amo Yakobo natunao koroto Reitiyeli ivenatunidi. Yakobo natunao be tubunao madabokidi Reitiyeli goi adi badabada yawou aivasi. ");
INSERT INTO gvs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","E Dani natuna koroto yoina Kosim. ");
INSERT INTO gvs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","E Napatali natunao koroto yoidi ame nakae: Yasiyela, Guni, Yeseri be Silem. ");
INSERT INTO gvs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Amo Yakobo natunao koroto Bila ivenatunidi. Boi Bilayana Lebani ina pákwana go, Reitiyeli ivini. Yakobo natunao be tubunao liliudi Bila goi adi badabada ainima aiyuwo. ");
INSERT INTO gvs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","E Yakobo natunao be tubunao liliudi taiyao sina Itipita goi adi badabada 66. Go natunao monediyao geya sikatuyaividita. ");
INSERT INTO gvs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ego Iyosepa natunao adi taiyuwo Itipita goi sibíbina. Neta kidi taiyao Yakobo ina bodao liliudi sina Itipita goi adi badabada 70. ");
INSERT INTO gvs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","E Yakobo natuna Yuda ietune ina Iyosepa goi bego tauyana Goseni ina kenao ikatukede. Tuwo nakae iguinuwe. Ikavava, ikaluvila ima, e madabokidi taiyao sisowóduwo Goseni dadavina goi, moe Itipita sinaena. ");
INSERT INTO gvs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Tutayana sisowóduwo, Iyosepayana ina pakonayao ina sariyota sikatubayasi. Ikavava, e ituko ina Goseni dadavina bego tamana ivalobode. E isowóduwo Goseni dadavina goi ikandobala tamana igite, isou ina tamanayana ivayavau nukotona iyoisi, iyowoi go, itáiya tuta maanawena. ");
INSERT INTO gvs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Go Isileli natuna Iyosepa ilatuwoko idigo kana, ‘O natugu! Ame tuta itoboinegu magu tuboina akámasa. Toinigu matagu goi bogina agitem kom maa yawoim, tauna auyáwana gagaina.’ ");
INSERT INTO gvs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","E Iyosepa tamana be senao ilatuwokoidi idigo kana, ‘Tamagu be segowo, ame tutayana ana Pero alatuwoko kagu, “Segowo boi Kenani goi sikaaiyaka bogina sima. ");
INSERT INTO gvs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Tauyadi sipi adi tomatakavata. Idi paisewayana goi yoguyogu liliudi simatakaavatedi. Idi yoguyoguyao madabokidi, idi sipi, idi goti be idi bulumakau nakae konadi liliudi bogina simedi.” ");
INSERT INTO gvs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","E tauna tutayana Peroyana iduduwemi, e kōna bei ilumadademi kana, “Kaga imi paisewa?” ");
INSERT INTO gvs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","E komi kodīgo kami, “Kai im pakonayao yoguyogu adi tomatakavata boi nimatu tubumao nakae ima ame tuta.” Neta nakae kobóbwara, bei itagonemi Goseni goi kokaiyaka. Bogina koyagoi. Da Itipita yoguyogu adi tomatakavatayao sinuwomolaitedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","E tuwo Iyosepa tuwowonao adi tainima ikinavedi taiyao sina Pero yaina go, Iyosepayana igimisiu ina Pero ilatuwoko idigo kana, ‘Guna tomoya, tamagu be segowo Kenani goi bogina sima. Idi yoguyoguyao be konadi liliudi nakae simedi. Ame tuta Goseni dadavina goi sikaaiyaka.’ Ibóbwara ikavava, isowóduwo senaoyadi adi tainima ikabidi imedi Pero matana goi ivagitakoidi. ");
INSERT INTO gvs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tuwo Peroyana idigo kana, ‘Komi kaga imi paisewa?’ ‘Ima tomoya, kai ima paisewa sipi adi tomatakavatayao nakae tubumao boi nimatu’, kidi kaedi. Kadi, ");
INSERT INTO gvs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","‘Kama ameko goi bego kasuvadavada. Ima poyapoya bogina ilogoyo, tauna ima yoguyoguyao geya avadimo. Bogina kuyagoi. Kenani goi loga gagaina. Go ima tomoya manakae? Kutagona bego Goseni goi kakaiyaka gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","E Pero idigo kana, ‘Iyosepa, tamam be semowo bogina simekoim. ");
INSERT INTO gvs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Bogina atagona. Ava poyapoya Itipita goi kugite dedevina yaidi, e toinim kulovina. Neta latuwom bego Goseni goi sikaaiyaka, dedevina. Ago neta yaidi goi maniyedi madi katanaki yoguyogu matakavata manuna, e kuvayokōidi kidi yau guna yoguyoguyao adi tomatakavatayao.’ ");
INSERT INTO gvs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","E Iyosepa ina tamana Yakobo ikabi ime Pero matana goi ivagitako go, kina Yakobo Pero ikaipakuye. ");
INSERT INTO gvs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","E Pero idigo kana, ‘Aivina am tala?’ ");
INSERT INTO gvs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","‘Poyapoya ame goi atuliyaliya tala ana badabada 130. Guna talayadi geya sibadebadeta go, talayadi goi mou badabadaidi ababanedi. Yau guna tala geya tubugowo nakae geya. Kidi adi tala maanawedi’, Yakobo kaena. ");
INSERT INTO gvs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tuwo Yakobo aiyuwoina Pero ikaipakuye. Ikavava, Pero ikalave go, isowóduwo ina. ");
INSERT INTO gvs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","E Iyosepa iguinuwe nakae Pero idige. Poyapoya dedevina toina Itipita goi tamana be senao ivinidi. Poyapoyayana moe Ramasesi goi. Ramasesiyana youyuwoina moe Goseni. ");
INSERT INTO gvs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ivinidi ikavava, tamana, senao be idi bodao ivaitedi. Adi boda ana badabada nakae, e avadi nakae ivinidi. ");
INSERT INTO gvs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","E Itipita goi be nakae Kenani goi awoinu geya, geya toina. Logayana ivakaigaga toina, tauna Itipita be Kenani goi tomota bogina sineneta logayana pasina. ");
INSERT INTO gvs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","E tuwo Iyosepa witi ikaigimona da Itipita yaidi be nakae da Kenani yaidi. Ago idi mani ikabidi, ietunedi sina Pero ina vada goi. ");
INSERT INTO gvs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Tutayana da Itipita be nakae da Kenani idi mani ikavava, e da Itipita liliudi sideli sima Iyosepa silatuwoko sidigo kadi, ‘Iyosepa, avama kuvinima. Manakae? Bego matam goi kakámasa? Kai ima mani bogina ikavava!’ ");
INSERT INTO gvs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","E Iyosepayana idigo kana, ‘Neta imi mani ikavava, e imi yoguyoguyao komēdi bei tatalamapu. Imi yoguyoguyao kovinīgu go, yau awoinu avinimi.’ ");
INSERT INTO gvs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","E tuwo moitamo, idi yoguyoguyao sikabidi: Idi osi, idi sipi, idi goti, idi bulumakau be nakae idi ase. E sikabidi, simedi, Iyosepa sivini go, awoinu ivinidi. Tuwo amo talayana goi idi yoguyoguyao liliudi sitalamapuyedi avadi manuna. ");
INSERT INTO gvs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","E tutayana amo talayana ikavava, da Itipita sikaluvila sima Iyosepa silatuwoko sidigo kadi, ‘Ama tomoya, ima mou geya kavamouyeta kom yaim. Ima mani bogina ikavava, ima yoguyoguyao liliudi bogina kwabidi. Tauna konama liliudi sikavava, go sem ima poyapoya ikaaiyaka be nakae kai amema kakaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Manakae? Latuwom bego matam goi kakámasa be nakae ima poyapoya ilogoyo? Kai kugimonēma bei kai Pero ina pakonayao. Ima poyapoya nakae kugimonēdi. Ago awoinu kuvinīma kakáika be nakae witi kutukutuna kuvinīma kana kabágula kom manum, e bei kai ma yawoima be nakae poyapoya geya ilogoyoita.’ ");
INSERT INTO gvs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tuwo poyapoya ana madabokina Itipita goi Iyosepa igimonedi Pero ina poyapoya. Da Itipita liliudi idi poyapoya sikaigimonedi. Bogina kuyagoi. Logayana ivakaigaga toina. Tauna poyapoyayana ana madabokina moe Pero ina kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ago tomota liliudi Itipita goi, e Iyosepa ikabidi kidi Pero ina pakonayao. ");
INSERT INTO gvs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ego kidi Tonúwala idi poyapoya geya sikaigimonedita. Moitamo. Tala tamo tamo Pero witi ikaiguyau yaidi goi. E kidi idi kaiguyauyana bogina yoiyadi, tauna loga geya sikamaseta. Ame pasina idi poyapoya geya sikaigimonedita. ");
INSERT INTO gvs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","E da Itipitayadi kina Iyosepa ilatuwokoidi idigo kana, ‘Konōve. Ame bogina imi poyapoya agimonedi be nakae agimonemi komi Pero ina pakonayao. Gwa, imi witi kutukutudi avinimi kōna kobāgula Pero manuna. ");
INSERT INTO gvs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Go tutayana kodibayoya, dibayoyayana kokaiguyāuye gúguna ainima ainima go, gúguna tayamo Pero kovīni. Ago gúguna aivasi moe komi imi kutukutu be nakae avami, komi be nakae natumiyao.’ ");
INSERT INTO gvs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kidi sidigo kadi, ‘Bogina kuyavema! Bogina kukanuwoiyema. Go ima tomoya, kai bei Pero ina pákwana.’ ");
INSERT INTO gvs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tuwo amo tutayana Iyosepa lovina tayamo Itipita goi iyato. Lovinayana ame nakae: Tutayana tomota sidibayoya, dibayoyayana sikaiguyauye gúguna ainima ainima go, gúguna aivasi toinidi manudi, tayamo moe Pero manuna. Lovinayana nava ame tuta ikaaiyaka. Tonúwala idi poyapoya kaka Pero geya ikabiyeta. Tauna lovinayana geya sikabikaoneyeta. ");
INSERT INTO gvs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","E Isileli ina bodao Itipita goi silokasa go, moe asa Goseni dadavina goi. Amoko goi poyapoya sivinidi, e sisusáila, bogina sibadabada. ");
INSERT INTO gvs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","E Yakobo Itipita goi ikaaiyaka tala ana badabada 17 go, ana tala ana badabada madabokina bogina 147. ");
INSERT INTO gvs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","E kina ina lotówana ilotowo bego tuta giyaina bei ikámasa. Tuwo natuna Iyosepa iduduwe ima ilatuwoko idigo kana, ‘Iyosepa, neta itoboinegu im kanuwóiya ababane, e nimam kuvaisīu dibuwatugu kuyōisi go, Yauwe matana goi kukatōtula bego kulokategu be nakae kom aba numisa yau yaigu. Guna kawanoi bego taabu Itipita goi kuvaliiwogēgu, ");
INSERT INTO gvs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","go sem tutayana akámasa ana tamagowo yaidi, e wowogu kunāve tauyadi adi valiwoga goi kuvaliwogēgu. Adi valiwogayadi Kenani goi sikaaiyaka.’ ‘Nakae bei aguinuwe’, Iyosepa kaena. ");
INSERT INTO gvs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","E Isileliyana idigo kana, ‘Kukatótula yaigu bego nakae bei kuguinuwe.’ Tuwo Iyosepa ikatótula. Ikatótula ikavava, e Yakobo nukotona iuyáwana, ina kaba masisi goi ivatugúyala ikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","E sikaaiyaka, sikaaiyaka, aaa, tomota maniyedi sima Iyosepa silatuwoko sidigo kadi, ‘Iyosepa, tamam ikatówana.’ Tuwo natunao Manase be Eparaim ikabidi, taiyao sina tamana sigite. ");
INSERT INTO gvs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tuwo sina sisowóduwo, e tomota sisiu Yakobo ina vada goi silatuwoko sidigo kadi, ‘Yakobo, natum Iyosepa bogina ima.’ Tuwo livalayana inove, e ina togaga igidigidi, ina kaba masisi goi itusobu. ");
INSERT INTO gvs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ikavava, Iyosepa isiu go, tamana idigo kana, ‘Iyosepa, boi nimatu asa Lusi goi Kenani sinaena, Tokavavágana Tokalika toinina isowóduwo yaigu, e ikaipakuyegu, ");
INSERT INTO gvs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","idigo kana, “Kunōve. Bei akisailim, e bei tubumowo badabadaidi. Tauyadi goi boda ituli ituli bei sisowóduwo. Ame poyapoyayana tubumowo bei avinidi; ikaiyako vata yaidi.”’ ");
INSERT INTO gvs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakobo tuwaina kana, ‘Iyosepa, tutayana nava geya amaita ameko, kom natumowo Manase be Eparaim Itipita goi sibíbina, e adi taiyuwo ame tuta avanatunedi, tauna tauyadi natugowo nakae Rubeni be Simioni. ");
INSERT INTO gvs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","E ava gogomanava tuwaina sibíbina yaim, e kidi kom natumowo. Amo natumowoyadi tubudiyao adi kaiguyau poyapoya moe Manase be Eparaim idi poyapoya goi sikabidi. ");
INSERT INTO gvs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","E ame nakae aguinuwe sinam ina kámasa pasina. Boi asa Padani akalave ama Kenani asiu. Ego Eparati kenaoina goi sinam Reitiyeli ikámasa. Tuwo amoko goi tauyana avaliwoge. Ego nuwogu imou gagaina, tauna ame pasina natumowo akabidi.’ (Ego niga Eparatiyana sivayou Bedeliyema.) ");
INSERT INTO gvs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","E tutayana Isileli ikandobala, Iyosepa natunao igitedi idigo kana, ‘Ame ava gogomanava?’ ");
INSERT INTO gvs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","‘Ame natugowo Yaubada ivinigu’, Iyosepa kaena. Isileli idigo kana, ‘Kumēdi matagu goi bei akaipakuyedi.’ ");
INSERT INTO gvs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ego Isileli matana bogina sikau unana bogina ikaitomoya, tauna giyaina igita. Tuwo Iyosepa natunao imedi tamana matana goi sitáoya. E Yakobo iyowoiidi be ivayavaudi. ");
INSERT INTO gvs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isileliyana idigo kana, ‘Iyosepa, boi anuwonúwana geya tuwaina bei agitem go, Yaubada bogina itagona bego kom ma natumowo agitemi.’ ");
INSERT INTO gvs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","E tuwo Iyosepa natunao ikabimneidi ikaibaledi go, kina aena ivatugúyala, ikanakabobo tamana yaina. ");
INSERT INTO gvs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ikanakabobo ikavava, natuna Eparaim ikaibale Isileli kekelina goi itáoya go, Manase ikaibale Isileli kakataina goi itáoya. Moe unana Manase botomoya. ");
INSERT INTO gvs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","E Isileli nimakakataina iyosale, e Eparaim dabana iyoisi go, Eparaimyana bogomane. E nimana kekelina iyosale Manase dabana iyoisi go, Manaseyana botomoya. ");
INSERT INTO gvs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ikavava, Iyosepayana ikaipakuye, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","boi aneroseyana vailai goi iyavegu; ");
INSERT INTO gvs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","E Iyosepa ikandobala tamana igite ibágala unana nimakakataina goi Eparaim dabana iyoisi. Tuwo ona ikai, e nimanayana iyoisi, ikigagi bego ikaidamane Manase dabana goi, ");
INSERT INTO gvs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","e idigo kana, ‘Tamagu, moe nakae geya. Ame Manase botomoya. Itoboine nimakakataim goi dabana kuyoisi.’ ");
INSERT INTO gvs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Go kina tamanayana ikatae idigo kana, ‘Natugu, bogina ayagoi. Tauyana nakae bei isusáila boda tayamo gagaina nakae ina lovina bei itogaga. Go sem kina bogomane bei ivakaigagasave be nakae tauyana yaina goi boda badabadaidi bei sisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tuwo ikaipakuyedi, idigo kana, ‘Neta tubugowo sikaipaku, yoimi goi bei sikaipaku kadi, “Yaubada bei ivaitem nakae boi Eparaim be Manase ivaitedi.”’ Tauna moe nakae Eparaim siyana Manase ivakumgoiye. ");
INSERT INTO gvs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","E Isileli Iyosepa ilatuwoko idigo kana, ‘Iyosepa kunōve. Giyakainava bei akámasa go, Yaubada bei ivakitaum. Tubumowo bei ikaluvilemneidi sina tubudao idi kasa goi. ");
INSERT INTO gvs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","E amoko goi poyapoya yoina Sekem semowoyadi geya avinidita, go sem moe kom avinim. Asayana boi yaviya goi akabi Emori tubunao yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","E Yakobo natunao iduduwedi sima idigo kana, ‘Kōma kotunibisīgu bei alatuwokoimi kaga bei isowóduwo yaimi. ");
INSERT INTO gvs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Natugowo, ");
INSERT INTO gvs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubeni, ");
INSERT INTO gvs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kom sákala gagaina nakae idaudau go, ");
INSERT INTO gvs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simioni be Livai, ");
INSERT INTO gvs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Boi imi egamogamogu goi koroto kokaumatedi ");
INSERT INTO gvs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Imi egamogamogu ivakaigaga ");
INSERT INTO gvs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","O Yuda, ");
INSERT INTO gvs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Kom laiyoni bonatuna nakae. ");
INSERT INTO gvs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Kom mam lovina go, ");
INSERT INTO gvs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Tauyana bei toesaesa, ");
INSERT INTO gvs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Tauyana koroto gumaboina ame nakae: ");
INSERT INTO gvs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebuloni, ");
INSERT INTO gvs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakara, ");
INSERT INTO gvs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kom aba waiwasiyana ");
INSERT INTO gvs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dani, ");
INSERT INTO gvs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Kom bei moteta nakae. ");
INSERT INTO gvs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","E Yakobo ikawanoi idigo kana, ‘Yauwe, im yava atuuyaosi!’ ");
INSERT INTO gvs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","E tuwaina natunao ilatuwokoidi idigo kana, ‘Gadai, ");
INSERT INTO gvs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aseri, ");
INSERT INTO gvs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napatali, ");
INSERT INTO gvs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iyosepa, ");
INSERT INTO gvs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Am kaleyayao gamodi sigoyo, ");
INSERT INTO gvs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Go kom bei kutaoyakavata ");
INSERT INTO gvs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","nakae yau guna Tokavavágana. ");
INSERT INTO gvs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Nakonakae Yaubada bei ikaipakuyem, ");
INSERT INTO gvs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniyamina, ");
INSERT INTO gvs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","E ame taudi dala yawou aiyuwo Isileli goi sisowóduwo. Ame nakae Yakobo natunao ikaipakuyedi. Boi kidi idi sinapu igitedi, e tauna nakae ikaipakuyedi. ");
INSERT INTO gvs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yakobo ikaipakuyedi ikavava, idigo kana, ‘Natugowo, giyakainava bei akámasa ana tamagu be tubugowo yaidi. Tutayana akámasa ikavava, wowogu kokābi konāve tamagu be tubugowo taiyao kovaliwōge. Tauyadi adi valiwoga moe tukubu sinaena Eta tubuna Epironi ina poyapoya goi. ");
INSERT INTO gvs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Epironi ina poyapoyayana moe Kenani sinaena tayamo asa giyaina yoina Makipela. Makipelayana moe Mamre kikina. Boi nimatu tukubuyana be nakae poyapoyayana Eta tubuna Epironi yaina Eberamo igimonedi. ");
INSERT INTO gvs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Amoko goi Eberamo ma monena Sera adi valiwoga be nakae Aisake ma monena Ribeka adi valiwoga sikaaiyaka. E tukubuyana goi boi Reya nakae avaliwoge. ");
INSERT INTO gvs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ego poyapoya be tukubu Eta tubunao goi Eberamo igimonedi. Tauna amoko goi kovaliwogēgu.’ ");
INSERT INTO gvs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","E Yakobo natunao ilatuwokoidi ikavava, imasisimna go, yawoina ikavava, e ina tamana be tubunao yaidi goi. ");
INSERT INTO gvs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tuwo Iyosepa isou tamana ivayavau, manuna itáiya be iyowoi. ");
INSERT INTO gvs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Itáiya ikavava, itáoya ina pakonayao sakava ana tokatubayasi ilatuwokoidi idigo kana, ‘Kōna pútuma kokābi, kōme tamagu wowona kokatubayāsi ina valiwoga manuna.’ Tuwo moitamo tauyadi sima tamana Isileli wowona sikabi, sikatubayasi ina valiwoga manuna. ");
INSERT INTO gvs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Maliyalina ana badabada 40 goi sipaaisewa, wowonayana sikatubayasi. Bogina kuyagoi. Kidi da Itipita idi sinapu moe maliyalina ana badabada 40 goi wówana ana katubayasi siguuinuwe. Da Itipita madi nuwomou maliyalina ana badabada 70 goi Yakobo manuna sitaiyakuwokúwala. ");
INSERT INTO gvs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","E tutayana idi taiyakuwokúwala ikavava, Iyosepa ina Pero ina tovaitayao ilatuwokoidi idigo kana, ‘Neta itoboinegu imi kanuwóiya ababane, latuwogu bego kona guna livala konave Pero goi. Livalayana kolatuwōko kami, ");
INSERT INTO gvs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","“Boi tutayana tamagu giyakainava bei ikámasa, latuwona akatótula bego Kenani goi avaliwoge. Valiwogayana toinina bogina ikatubayasi. Tauna kutagonēgu ana tamagu avaliwoge. Avaliwoge ikavava, bei akaluvila.”’ ");
INSERT INTO gvs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Tuwo moitamo sina Pero livalayana sivini, e tauyana idigo kana, ‘Kōna Iyosepa kolatuwōko kami, “Dedevina, kūna tamam kuvaliwōge nakae boi im katótula.”’ ");
INSERT INTO gvs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tuwo Iyosepa ina tamana ivaliwoge. Pero ina tovakumgoyao paakonidi liliudi be koroto gagaidi be nakae da Itipita adi guyaguyauwo taiyao sina. ");
INSERT INTO gvs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Iyosepa ina bodao liliudi, nakae senao madi bodayáuwo be nakae tamana ina bodayáuwo go, natudiyao be idi yoguyoguyao taudiva Goseni goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","E koroto maniyedi sariyota goi sisowoya be nakae maniyedi osi goi situlaga taiyao sina. Tauna boda gagaina sina Kenani. ");
INSERT INTO gvs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","E madabokidi siketoiya. E sina asa Etada goi, moe Iyoridani kikina. Amoko goi witi ana kaba kausapisápina ikaaiyaka. Tuwo sisowóduwo, madabokidi niyadi gagaina goi sitaiyakuwokúwala. Maliyalina ainima aiyuwo kina Iyosepa ilibu tamana manuna. ");
INSERT INTO gvs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Go da Kenani sikandobala tomota idi táiya Etada goi sigite sidigo kadi, ‘Kogīta! Da Itipita sitaiyakuwokúwala.’ Tuwo moe pasina asayana yoina Ebeli Misaraim. Moe Iyoridani koiboga dadavina. ");
INSERT INTO gvs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","E tuwo Yakobo natunao siguinuwe nakae tamadi idige. ");
INSERT INTO gvs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wowona sikavale sinave Kenani goi sivaliwoge tukubu sinaena. Tukubuyana ikaaiyaka Makipela goi, moe Mamre kikina. Tukubuyana be poyapoyayana Eberamo igimonedi Eta tubuna Epironi yaina. ");
INSERT INTO gvs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","E Iyosepa kidi tamadi sivaliwoge ikavava, boda taiyao sikaluvilamna sina Itipita goi. ");
INSERT INTO gvs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","E Yakobo ina kámasa mlina, Iyosepa senao sinuwokubukubu, e sidigo kadi, ‘Nakona Iyosepa nava gamona igoyogoyo, e bei ikaoliliveda boi ida guinuwa pasina, tuwo ame tutayana bei ida goyo yaina ikatumapu. Bei manakaeda?’ ");
INSERT INTO gvs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tuwo livala sietune ina Iyosepa yaina sidigo kadi, ‘Boi tamam nava maa yawoina lovina tayamo ivinima. ");
INSERT INTO gvs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Tauyana idigodigo bego kalatuwokoim itoboine kai tuwowomowo ima kadoinana yaim kunuwotao. E tuwo kakawanoi kai tamam ina Yaubada ina pakonayao ima bágala yaim kunuwotao.’ Go livalayana Iyosepa inove, nuwona imou gagaina, itáiya. ");
INSERT INTO gvs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","E senao sima aedi sivatugúyala tauyana matana goi go, sidigo kadi, ‘Kai im pakonayao.’ ");
INSERT INTO gvs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Go kina Iyosepayana idigo kana, ‘Geya komatoiteguta geya. Manakae? Yau Yaubada? Geya! ");
INSERT INTO gvs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Komi boi bego goyo koguinuwe yau yaigu go, Yaubada ina nuwonúwana bego dogoi dedevina isowóduwo. Dogoiyana moe tomota badabadaaidi ayavedi nakae bogina kogite. ");
INSERT INTO gvs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","E tauna geya komatoiteguta geya. Komi ma natumiyao bei amatakavatemi.’ Tuwo nakae ikipaiwoledi be nakae atedi ivapatupatudi. ");
INSERT INTO gvs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","E Iyosepa Itipita goi ikaaiyaka senao taiyao. Tutayana ikámasa ana tala 110. ");
INSERT INTO gvs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ego nava maa yawoina natuna Eparaim natunao be tubunao igitedi. Aiyuwoina natuna Manase natuna koroto Makiri natunao igitedi. Tutayana Makiri natunao sibíbina, Iyosepa sivini ivanatunedi. ");
INSERT INTO gvs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","E Iyosepa senao ilatuwokoidi kana, ‘Giyakainava bei akámasa go, Yaubada bei iwo ivaitemi. Tubumiyao bei ikabidi, inavedi poyapoyayana boi ikaatotule Eberamo, Aisake be Yakobo yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Iyosepa ibobwaramna idigo kana, ‘Moitamo Yaubada bei iwo ivaitemi go, ame tuta kokatótula yaigu bego tutayana Yaubada ikabimi, e lulugu kokabīdi konavēdi Kenani goi kovaliwogēdi.’ Senaoyadi moitamo sikatótula. ");
INSERT INTO gvs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tuwo Iyosepa ikámasa go, ana tala bogina 110. Ina kámasa mlina, wowona sikatubayasi. Ikavava, siyato dedeoga sinaena go, Itipita goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Boi Isileli natunao koroto madi bodayáuwo taiyao sima Itipita goi sikaaiyaka. Natunaoyadi yoidi ame nakae: ");
INSERT INTO gvs_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, Simioni, Livai, Yuda, ");
INSERT INTO gvs_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakara, Sebuloni, Beniyamina, ");
INSERT INTO gvs_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dani, Napatali, Gadai be Aseri. ");
INSERT INTO gvs_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","E Yakobo mana bodayáuwo liliudi adi badabada 70 taiyao sina. E kina go natuna Iyosepa bogina Itipita goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","E sikaiyaka aaa, Iyosepayana ma senao be nakae amo malamalagatayana sikamasa kówasa. ");
INSERT INTO gvs_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","E kidi go Isileli tubudiyao sisusáila gagaina toina nakae sibadabada be nakae sitogaga toina, tauna asayana Itipita kidi sivakayaodei. ");
INSERT INTO gvs_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","E sikaaiyaka go, da Itipita adi tolovina vau itáoya go, Iyosepa ina guinuwa geya ikamoitamoeyeta. ");
INSERT INTO gvs_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","E ina bodao da Itipita ilatuwokoidi idigo kana, ‘Bogina kogite? Isileli tubunao bogina sisusáila gagaina nakae adi badabada sikalisaveda be sitogagasaveda! ");
INSERT INTO gvs_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mada nuwopolala tasikogigīdi, govila bei tuwaina sisusáila, e niga neta yaviya isowóduwo, kidi bei sina ada kaleyayao taiyao sisiukoidi sima silauida, namliyeta asa sikalave.’ ");
INSERT INTO gvs_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tuwo da Itipita ame nakae siguinuwe: Itipita korotoidi sikinavedi sivayokoidi kidi Isileli tubunao adi tolovinao, e paisewa moumouna goi sikinenetedi. Paisewayana ame nakae: Asa aiyuwo Pitom be Ramasesi siyowóidi, e bei asayadi sinaedi goi Pero ina sánala sikaaiyaka be nakae kónana adi vada siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","E tuta tamo tamo paisewa moumouna tuwaina sivinidi, e kidi Isileli tubunao tuwaina siisusáila nakae tuwaina asa situgidagidali. Tuwo kidi da Itipitayadi sigitedi odi isilali. ");
INSERT INTO gvs_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","E tuwo geya idi nuwokapisimo Isileli tubunao sipakoidi sikogúyala gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Paisewa moumouna sivinidi, tauna sikaiyako mou. Idi kaiyakomouyana ame nakae: Vaega be limou taiyao sipopolidi sigabudi simalagurewa nakae, e idi vada siyowóidi be nakae idi tánuwo goi sipaisewa. Paisewa liliunakova goi da Itipita geya idi nuwokapisimo Isileli tubunao sipakoidi sikogúyala gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","E amo tutayana vevina Iberiu idi tovenatunavaita adi taiyuwo sikaaiyaka, tayamo yoina Sipira, tayamo yoina Puwa. Tuta tayamo da Itipita adi tolovina ilatuwokoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","‘Tutayana vevina Iberiu sivenátuna, kovaitēdi go, natudiyao kogitēdi. Neta koroto, e kokaumatēdi go, neta vevina, e koyatōidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","E kidi vevinayadi Yaubada siwowoine, tauna da Itipita adi tolovina ina lovina sikapipilave, go sem gogómana liliudi, koroto be vevina, siyatoidi maa yawoidi. ");
INSERT INTO gvs_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Go tolovinayana livala inove bego vevinayadi ina lovina sikapipilave. Tuwo vala ietune ina iduduwedi sima ilatuwokoidi idigo kana, ‘Komi kaga unana guna lovina geya koguinuweyeta, e gogomanayadi koroto kaga koyatokoidi maa yawoidi?’ ");
INSERT INTO gvs_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","E kidi vevinayadi sidigo kadi, ‘Unana kidi Iberiu idi venátuna ituli, e da Itipita nakae ituli. Kidi vevina Iberiu idi venátuna goi sitogaga, tauna toinidi sivenátuna. Bego kana kavaitedi go, kawoiko, bogina sivenátuna!’ ");
INSERT INTO gvs_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","E vevina tovaita adi taiyuwokova kina Yaubada iyabobonedi, tuwo Isileli tubunao tuwaina sisusáila be nakae sitogaga gagaina. ");
INSERT INTO gvs_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Vevinayadi Yaubada siwowoine, tauna ikitogagedi, e itoboinedi sikéuwama. ");
INSERT INTO gvs_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","E tuwo Pero ina bodao da Itipita liliudi ilovinaedi idigo kana, ‘Ava Iberiuva natudiyao koroto sibíbina, e liliudi kokabīdi, konavēdi sákala Nairi goi kolavēdi sisou sikámasa, go neta natudiyao vevina, e tuwo koyatōidi maa yawoidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","E tamagu ana dala Livai go, vavina tayamo, moe sinagu, ikabi inai. Sinaguyana nakae ana dala Livai. ");
INSERT INTO gvs_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Sikaaiyaka aaa, sinaguyana ikéuwama. Ikéuwama niga ivenátuna, natuna yau. Ago sinaguyana igitegu bego yau gómana dedevigu, tuwo ikabigu, vada sinaena goi ivamougu ana kadókana tukówana aito. ");
INSERT INTO gvs_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tutayana tukówana aito sikavava, yau bogina abíbina tupwana, e sinagu geya itoboineyeta ivamougu. Tuwo bayao mana katukábwala iwoi. Ikavava, taa ikabi, ibwade. Ibwade ikavava, ikabigu, idodoigu inavegu sákala Nairi kikina kalavaitou sinaedi goi iyatoigu. ");
INSERT INTO gvs_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Niugu giyakainava masigava goi itáoya iigitegu; latuwona bego iyagoi kaga bei isowóduwo yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","E Pero natuna vavina mana pakonayao wowoiyai taiyao siiwo sina sakalayana goi. Sákala kikina goi ana wowoiyaiyadi siiketoiya go, Pero natunayana isou iiwo ina bego iisiwo go, ikandobala bayao igite kalavaitou sinaedi ikaaiyaka. Tuwo woiyai tayamo ilatuwoko kana, ‘Kūna amo bayaoyana kwābi kūme!’ ");
INSERT INTO gvs_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","E tuwo iiwo ina bayaoyana iyoyoi ime, Pero natuna ivini. Ivini, vavinayana ikatupáeve, yau igitegu ataitáiya. Tuwo vavinayana inuwokapisiye, idigo kana, ‘Iyaa! Ame nakona kidi Iberiu natudi tayamo.’ ");
INSERT INTO gvs_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","E niugu ibala ima Pero natuna ilatuwoko idigo kana, ‘Latuwom bego ana vavina Iberiu alatuwoko ima gomanayana ikabi ivanunu manum?’ ");
INSERT INTO gvs_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","‘Dedevina, kūna’, Pero natuna kaena. Tuwo niugu ina sinama ilatuwoko ima. ");
INSERT INTO gvs_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","E tuwo sinamayana ima go, Pero natuna idigo kana, ‘Gómana ame kwābi kuvanūnu manugu gobe yau aemaisim.’ E moitamo sinagu ikabigu, ivaanunugu. ");
INSERT INTO gvs_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","E tutayana bogina abíbina, sinagu ikabigu inavegu Pero natuna ivini bego yau natuna. E vavinayana idigo kana, ‘Gomanayana bwae goi ayoyoi, tauna avayou Mosese.’ ");
INSERT INTO gvs_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","E tutayana bogina akaitubuwau, tuta tayamo atáoya ana osegowo Iberiu avadadedi go, agitedi idi kogúyala moumou isaki. Aiyuwoina guma Itipita agite ivalauláuwo Iberiu tayamo iiláui. Tauyana moe osiyagu tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","E amatavilavila, geya tayaamo tomota agite, tuwo siyagu avaite, e guma Itipitayana aláui, akaumate. Akaumate ikavava, wowona akabi avamou, ediédila goi avakum. Avakum ikavava, akaluvila ana guna vada amasisi. ");
INSERT INTO gvs_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Amasisi vanuwo itomo, aiyuwoina akaluvilamna ana osegowo avadadedi go, anonoina Iberiu adi taiyuwo agitedi sivalauláuwo. Tuwo togiyosásala alatuwoko adigo kagu, ‘Kaga unana siyada kuuláui?’ ");
INSERT INTO gvs_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Go kina togiyosasalayana ibolagu idigo kana, ‘Kom avatau ivayokoim bego kai ama tolovina o ama totakínona? Manakae? Bego kwaumategu nakae boile guma Itipita kwaumate ae?’ E yau bogina amatoita; guna nuwonúwana kagu, ‘O guna guinuwa bogina siyagoi.’ ");
INSERT INTO gvs_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","E tutayana guna guinuwayana valena Pero inove, ina tovayaviyayao ilatuwokoidi sima bego sikaumategu go, yau Pero ina kaba lovina goi asiya ana Midiyani dadavina goi atunagu. Amoko goi doelu tayamo ikaaiyaka, e kikina goi atunagu. ");
INSERT INTO gvs_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","E kina go da Midiyani adi Tonúwala yoina Reuweli amoko goi ikaaiyaka. Tauyana natunao vevina adi badabada ainima aiyuwo. E natunaoyadi sima doelu goi bwae sitegatega, yoguyogu adi kaba nim goi sisiwoi, idi yoguyoguyao adi bwae. ");
INSERT INTO gvs_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Sisiwoi go, ituli ta yoguyogu adi tomatakavatayao koroto sima vevinayadi sivatapiyedi. Latuwodi toinidi idi yoguyoguyao sivanimdi. Sivatapiyedi go, agitedi, tuwo atáoya vevinayadi ayavedi. Ayavedi ikavava, idi yoguyoguyao avanimdi. ");
INSERT INTO gvs_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","E vevinayadi sikaluvila sina tamadi Reuweli goi go, tamadiyana igitedi, nukotona iwówana idigo kana, ‘Ii! Kaga unana tauna ame mainao koma?’ ");
INSERT INTO gvs_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","‘Koroto tayamo guma Itipita doelu goi ikaaiyaka iyavema yoguyogu adi tomatakavatayao yaidi goi. Tauyana nakae bwae itege manuma nakae im yoguyoguyao ivanimdi!’ natunaoyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","‘Go korotoyana nako? Kaga unana kokalave? Kōna kolatuwōko ima ikáika’, tamadi kaena. E tuwo moitamo sima silatuwokoigu ana. ");
INSERT INTO gvs_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","E ana kidi taiyao kakáika. E Reuweli latuwona akaiyaka kidi taiyao. Atagona, e niga korotoyana natuna yoina Sipora ivinigu monegu. ");
INSERT INTO gvs_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kakaaiyaka, e Siporayana ikéuwama, niga ivenátuna, natuma koroto. Tauyadi alatuwokoidi adigo kagu, ‘Yau amalatonikasa ituli ta kasa goi.’ Tauna gomanayana avayou Gerasom. ");
INSERT INTO gvs_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","E tala maanawena Midiyani goi akaaiyaka go, amo talayadi mlidi da Itipita adi tolovina ikámasa go, tuwo segowo Isileli tubunao idi kogúyala moumouna pasina sikalayawoi be nakae sitaiyaduduwo vaita manuna. Idi taiyaduduwoyana ituko ina Yaubada yaina goi, ");
INSERT INTO gvs_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","e Tauyana inove. Ina kanasiunayana boi Eberamo, Aisake be nakae Yakobo yaidi goi inuwokavate. ");
INSERT INTO gvs_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Isileli tubunao idi kaiyakomou igite, manudi inuwonúwana gagaina. ");
INSERT INTO gvs_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","E yau go yaogu da Midiyani adi Tonúwala Iyetoro ina yoguyoguyao amatakaavatedi. Amatakaavatedi go, akabidi, yoyowo goi avadamanedi, anavedi koiboga dadavina koya yoina Korevi goi. Koyayana moe Yaubada ina koya. ");
INSERT INTO gvs_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","E amoko goi Yauwe ina anerose yeu sabeninimina nakae isowóduwo yaigu. Yeuyana taliboibo sinaena ininínima. Go taliboiboyana agite, akaliwoisa unana geya igabuyeta geya. ");
INSERT INTO gvs_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Tuwo anuwonúwana kagu, ‘Iyaa! Kaga unana taliboibo geya igabuyeta? Amo nakona aba kainaopa tayamo gagaina. Tuwo abala ana agitedoko.’ ");
INSERT INTO gvs_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","E Yauwe igitegu bego abala ana taliboibo agite, tuwo taliboiboyana sinaena goi iduduwegu idigo kana, ‘Mosese, Mosese!’ ‘U. Amegu’, kaegu. ");
INSERT INTO gvs_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Tauyana idigo kana, ‘Taabu kumamāima kikigu! Im sendoro kukitakīdi, kuyatōidi. Moe poyapoyayana goi kuutáoya poyapoya kimaasabaina yau umagu.’ ");
INSERT INTO gvs_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Kana, ‘Yau tamam ina Yaubada be nakae tubumowo Eberamo, Aisake be Yakobo idi Yaubada boi yaigu sisaakululu.’ E tuwo magu matoita maisigu avamou, govila bei Yaubada agite, akámasa. ");
INSERT INTO gvs_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","E Yauwe idigo kana, ‘Guna bodao Itipita goi idi kaiyakomou moitamo bogina agitedoko be idi taiyaduduwo adi tolovinayao pasidi bogina anovedoko. Adi gedageda bogina alotowo. ");
INSERT INTO gvs_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tauna asou ama bei da Itipita nimadi goi ayavedi. Itipita goi bei akabidi atukoedi anavedi poyapoya tayamo goi silokasa. Amo poyapoyayana dedevina be buutumina gagaina, maaliina be lobooinina. Poyapoyayana moe Kenani tubunao, Eta tubunao, Emori tubunao, Perisi tubunao, Ivai tubunao be Iyebusi tubunao idi kasa. ");
INSERT INTO gvs_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Gwa! Kunovēgu. Semowo Isileli tubunao idi taiyaduduwo bogina ima yaigu, e bogina anove be nakae bogina agite da Itipita manakaedi siyogedegededi gagaina. ");
INSERT INTO gvs_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tauna tuta ame goi aetunem kuna Pero yaina kukawanoi guna bodao Isileli tubunao italigeidi bei Itipita goi kukabidi kumedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Go yau adigo kagu, ‘Go yau avatau bego ana Pero matana goi akawanoi? O yau avatau bego sopagu ikabikaone go, Isileli tubunao italigeidi, e Itipita goi akabidi amedi? Geya!’ ");
INSERT INTO gvs_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Go kina Yaubada idigo kana, ‘Yau Tauyagu bei avakitaum go! Aba kinana avinim bei kuyagoi bego moitamo Yau aetunem. Aba kinanayana ame nakae: Tutayana semowo Isileli tubunao Itipita goi kumedi, e ame koyayana goi bei kosakululu Yau imi Yaubada yaigu.’ ");
INSERT INTO gvs_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Go yau adigo kagu, ‘Go neta ana osegowo alatuwokoidi kagu, “Tubudao idi Yaubada ietunegu ama yaimi” go, neta kidi kadi, “Go Tauyana yoina manakoyoina?” e yau bei manakaegu akatumapu?’ ");
INSERT INTO gvs_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Yaubada idigo kana, ‘Yau Tauyagu Aiiyakoigu. E tomotayadi ame nakae kulatuwokōidi kam, “Tauyana toinina ivayou kana, ‘Yau Tauyagu’, e amo Tauyana ietunegu ama yaimi.”’ ");
INSERT INTO gvs_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Tuwaina Yaubada idigo kana, ‘Isileli tubunao kulatuwokōidi ame nakae: Kam, “Yauwe, Tauyana tubudao Eberamo, Aisake be Yakobo idi Yaubada, ietunegu ama yaimi.” E ame yoiguyana ikaiyako vata. Nakae ame youyana goi malamalágata tamo tamo bei sinuwokavategu. ");
INSERT INTO gvs_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Tauna kūna Itipita goi go, Isileli tubunao idi tomoyamoya kududuwēdi sima kulatuwokōidi kam, “Kina Yauwe tubudao idi Yaubada, moe Eberamo, Aisake be Yakobo idi Yaubada isowóduwo yaigu idigo kana, ‘Bogina avadademi, tuwo bogina ayagoi kaga isowóduwo yaimi Itipita goi, tauna bei aguinuwa. ");
INSERT INTO gvs_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Tauna akatótula bei da Itipita idi yogedageda goi akabimi go, anavemi poyapoya maaliina be lobooinina goi. Poyapoyayana moe kidi Kenani tubunao, Eta tubunao, Emori tubunao, Perisi tubunao, Ivai tubunao be Iyebusi tubunao idi kasa.’” ");
INSERT INTO gvs_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Isileli tubunao sopam bei sikabikaone. E tuwo idi tomoyamoya taiyao kōna da Itipita adi tolovina kolatuwōko kami, “Yauwe, kai Iberiu ima Yaubada bogina ivalobodema. Tauna ame kama kakawanoi yaim bego kutagonema kana yoyowo goi maliyalina aito kaketoiya bei amoko goi ima yoguyoguyao kagabudi kakasaledi Yauwe ima Yaubada yaina.” ");
INSERT INTO gvs_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Go Yau bogina ayagoi bego da Itipita adi tolovina bei itagonemi kosowóduwo neta guna togaga goi to abuneneteyamo. ");
INSERT INTO gvs_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tuwo Yau nimagu bei abisisobu, guna guinuwa aba kainaopa liliudi aguuinuwedi da Itipita toinidi idi kasa goi go, aba kainaopayadi goi bei asapidi. Asapidi ikavava, tauyana bei italigeimi kosowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Anuwóiya goi da Itipita nukotodi bei asanayatoidi. Moeko goi idi kanuwóiya bei kobabane. E tutayana bego kosowóduwo kona, geya kada nima kaka geya, ");
INSERT INTO gvs_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","go sem imi vevina tamo tamo bei sina da Itipita idi vada goi vevina liliudi yaidi sikawanoi siriba be goura be nakae kwama dedevidi manudi. Sivinimi ikavava, kokabīdi natumiyao kovalosīdi. Tauna da Itipita konadi liliudi bei kotalagogodedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Go yau adigo kagu, ‘Go kunōve! Manakae neta geya sinumiseguta be sopagu geya sikabikaoneyeta? Nakae bei sidigo kadi, “Moe Yauwe geya isowoduwoita yaim.” Neta nakae, bei manakaegu?’ ");
INSERT INTO gvs_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","E tuwo Yauwe idigo kana, ‘Moe kaga nimam goi?’ ‘Aituko’, kaegu. ");
INSERT INTO gvs_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yauwe idigo kana, ‘Kwalisobūye isou poyapoya goi.’ Tuwo moitamo akalisobuye isou poyapoya goi imalamoteta! Agite, asiya. ");
INSERT INTO gvs_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Go Yauwe idigo kana, ‘Nimam kubisisōbu yuyuna kuyōisi.’ Tuwo moitamo abisisobu yuyuna ayoisi, ayoisikavate, e nimagu goi imalakaituko. ");
INSERT INTO gvs_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yauwe idigo kana, ‘Moe nakae kuguinūwe bei sinumisa bego Yau Yauwe, tubumiyao Eberamo, Aisake be Yakobo idi Yaubada bogina asowóduwo yaim.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","E aiyuwoina Yauwe ibobwaramna idigo kana, ‘Nimam kubasisīu am kwama sinaena goi kasikasim kubasikōne.’ Tuwo moitamo nimagu guna kwama sinaena goi abasisiu, kasikasigu abasikone. Go nimagu abuyagi, agite. Iyaa! Nimaguyana sakavaina mana vísiya, e itapopoina! ");
INSERT INTO gvs_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yauwe idigo kana, ‘Nimamyana kubasisīumna am kwama sinaena goi kasikasim kubasikonemnēi.’ Tuwo moitamo nimaguyana abasisiumna guna kwama sinaena goi kasikasigu abasikonemnei. Go nimagu abuyagi, agite. Iyaa! Sakavaiguyana bogina idedevinamna sakavaigu madabokina nakae! ");
INSERT INTO gvs_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yauwe nava ibobóbwara idigo kana, ‘Neta moitamo Isileli tubunao geya sinumisemta be nakae aba kinana vakuumgoina geya sikamoitamoeta, nakona moe aba kinana aiyuwoinayana kuguuinuwe bei sikamoitamoe. ");
INSERT INTO gvs_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Go neta aba kinanayadi aiyuwo geya sikamoitamoedita be nakae sopam geya sikabikaoneyeta, e kūna sákala Nairi goi bwae kutēge. Ikavava, kūna poyapoya sayasayaina goi kwaliulāgi bei poyapoyayana goi imalaikaika.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Go yau adigo kagu, ‘Tomoya, yau koroto geya bóbwara ana tokatanaki geya. Geya tayaamo tuta nakae itoboinegu. Boi nimatu geya; nakae ame tuta geya. Yau im pákwana kuvaadigoigu go, moe nakae geya itoboineguta. Yau sopagu maegu simoumou.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Go kina Yauwe idigo kana, ‘Go nakona avatau tomota sopadi imadagidi? Avatau tomota geya sibobóbwara imadagidi o avatau kidi taiyadi patupatudi o ma matadi be matadi kebokeboidi imadagidi? Moe Yau Yauwe ae? ");
INSERT INTO gvs_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tauna ame tuta kom tuwo kutaoyāmo kūna go, Yau toinigu sopam bei avaite be nakae avatulukoim manakaem kubóbwara.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Go yau adigo kagu, ‘Go Tomoya, akawanoi yaim bego ituli ta tomota kuetune ina.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","E Yauwe bogina iegamogamogu yaigu goi, tuwo idigo kana, ‘Go manakae siyam Eroni guma Livai? Bogina ayagoi kina bóbwara ana tokatanaki. Ame tuta tauyana bogina imamaima bei ivalobodem. Tutayana igitem, bei iuyáwana. ");
INSERT INTO gvs_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tauyana kulatuwōko manakaena ibóbwara go, Yau toinigu sopana be sopam bei avaitedi be nakae ami taiyuwokova avatulukoimi kaga latuwogu koguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Go tauyana bei im tobóbwara tomota yaidi ame nakae: Kina bei sopam nakae go, kom kueyaubada nakae tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Moe aitukoyana nimam goi kuyoisiikavate kunāve be aba kinanayadi kuguinuwēdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","E atáoya akaluvila ana yaogu Iyetoro alatuwoko adigo kagu, ‘Yaogu, kutagonēgu ana Itipita goi bei osegowo agitedi, nakona nava maa yawoidi o geya.’ Iyetoro kana, ‘Mam tuboina kūna.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","E Midiyani goi Yauwe ilatuwokoigu idigo kana, ‘Kutāoya kwaluvīla kūna Itipita. Korotoyadi boi bego sikauumatem bogina sikamasa kówasa.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","E tuwo moitamo monegu be natugowo akibodebodedi ase goi situlaga. Ikavava, kakaluvila kana Itipita goi. E nimagu goi Yauwe ina kaituko akavale. ");
INSERT INTO gvs_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","E Yauwe ilatuwokoigu, idigo kana, ‘Tutayana kusowóduwo Itipita goi, kunuwookavāte guinuwa aba kainaopa liliudi Pero matana goi kuguuinuwedi. Guinuwayadi manudi togaga bogina avinim. Go yau bei Pero ina dabakasa avaituwe, e tomotayadi geya itagonedita. ");
INSERT INTO gvs_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","E Pero kulatuwōko kam, “Yauwe idigo kana, ‘Natugu, guna botomoya, moe kidi Isileli tubunao. ");
INSERT INTO gvs_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Bogina alatuwokoim natuguyana kutaligēi bei ima isakululu Yau yaigu. Go neta geya kutaligeiyeta, e am dodōkana! Kom natum, am botomoya bei akaumate.’”’ ");
INSERT INTO gvs_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","E kai kanonoina Itipita manuna go, kama tunagu tayamo goi Yauwe ivalobodema, e ipoikíkina bego ikaumategu. ");
INSERT INTO gvs_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Go Sipora memetu ikabi, natuma sakavaina ikupo. Ikavava, sakavayana ikabi, aegu ibisikone idigo kana, ‘Bego kom yau ikaika goi tanai dókana.’ ");
INSERT INTO gvs_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Tuwo Yauwe igite, e iyatoigu. Ego tutayana Sipora kana, ‘Ikaika goi tanai dókana’, ame sakava ana kúpwana idigedige. ");
INSERT INTO gvs_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","E boi Yauwe Eroni bogina ilatuwoko idigo kana, ‘Kutāoya kūna yoyowo goi Mosese kuvalobōde.’ Tuwo moitamo Eroni ima Yaubada ina koya goi ivalobodegu, e iyowoiigu. ");
INSERT INTO gvs_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Iyowoiigu ikavava, e alatuwoko Yauwe ina livala liliudi manudi be nakae aba kinana liliudi boi bogina ilatuuwokoigu aguinuwedi manudi. ");
INSERT INTO gvs_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Alatuwoko ikavava, ama taiyuwo kana Itipita goi Isileli tubunao idi tomoyamoya kaduduwedi sima. ");
INSERT INTO gvs_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Sima, kaga liliuna Yauwe boi bogina ilatuuwokoigu Eroni ilatuwokoidi go, aba kinanayadi tomota matadi goi aguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Isileli tubunaoyadi sikabikáwana. Tutayana sinove bego Yauwe bogina ivadadedi nakae idi kaiyakomou bogina igite, e aedi sivatugúyala Tauyana yaina sisakululu. ");
INSERT INTO gvs_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moe mlina yau be Eroni kana Pero kalatuwoko, kadigo kama, ‘Yauwe, Tauyana kai Isileli tubunao ima Yaubada, ibóbwara ame nakae kana, “Guna bodao kutaligēidi bei sima yoyowo goi uyáwana aikanina siwodugu Yau yaigu.”’ ");
INSERT INTO gvs_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Go kina Peroyana idigo kana, ‘Yauwe avatau bego niyana anove, tauna komi Isileli tubunao ataligeimi? Yauwe geya ayagoiyeta geya. Go komi Isileli tubunao geya ataligeimita, geya toina!’ ");
INSERT INTO gvs_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Tuwo kai kadigo kama, ‘Kai Iberiu ima Yaubada bogina ivalobodema. Tuwo kutaligēima bei maliyalina aito goi kaketoiya kana yoyowo goi ima yoguyoguyao kagabudi kakasaledi Yauwe ima Yaubada yaina, govila bei vísiya goi o yaviya goi isapima.’ ");
INSERT INTO gvs_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Go da Itipita adi tolovinayana ibowoima idigo kana, ‘Mosese be Eroni, manakae tomota idi paisewa go, matadi koobanidi? Kokaluvīla kōna imi paisewa moumouna goi. Woilīmi!’ ");
INSERT INTO gvs_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tauyana tuwaina kana, ‘Konōve! Bodayadi bogina sibadabada go, komi latuwomi idi kogúyala sikalave!’ ");
INSERT INTO gvs_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","E Pero maliyalina amo goi lovina tayamo ietune ina ina pakonayao adi tolovinao be nakae Isileli tubunao toinidi adi tovakumgoyao ilatuwokoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","‘Geya tuwaina Isileli tubunao limou kovinīdi idi vaega ana pópwala vaboda manudi nakae boi, go sem kolovinaēdi kidi sina toinidi limou silusala limou poyapoya ana kailómwana. ");
INSERT INTO gvs_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Boi nakae simadagidi adi badabada nakae ame tuta go, taabu kokupokūpo, tuwo nakae. Moitamo. Kidi suumoyaidi, tauna moe pasina sitaiyaduduwo kadi, “Kutagonēma kana ima yoguyoguyao kagabudi kakasale ima Yaubada yaina.” ");
INSERT INTO gvs_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","E tuwo paisewa moumouna koroto kovinīdi sikogúyala bei geya itoboinedita livala polapola sitaiyakeke.’ ");
INSERT INTO gvs_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","E tuwo moitamo paakonidi adi tolovinaoyadi be nakae Isileli tubunao toinidi adi tovakumgoyaoyadi sina tomota silatuwokoidi sidigo kadi, ‘Pero ibóbwara ame nakae kana, “Yau geya tuwaina bei limou aavinimi. ");
INSERT INTO gvs_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Go komi sem kōna toinimi imi limou kolusāla nako goi itoboinemi kobabane. Imi kogúyala bei geya akupoeta, nakae geya giyaiina geya.”’ ");
INSERT INTO gvs_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Tuwo moitamo tomotayadi sisapa sina Itipita liliuna goi idi limou silusala sisinúkula. ");
INSERT INTO gvs_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","E kidi go pakonidiyadi adi tolovinao sisatubetubedi sidigo kadi, ‘Imi katuyáiva ame maliyalinayana kolukavavēdi! Itomo aiyuwoina nakae. Kolukavavēdi boi nakae limou kaavinimi kopaisewa!’ ");
INSERT INTO gvs_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","E paakonidi adi tolovinaoyadi sina Isileli tubunao idi paisewa ana tovakumgoyao boi sikiinavedi silauidi, sidigo kadi, ‘Kaga unana imi paisewa boile niga ame geya kolukavavedita? Kaga unana vaega be limou adi pópwala be nakae adi kaigábuna adi badabada geya kolukavavedita nakae boi nimatu?’ ");
INSERT INTO gvs_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","E Isileli tubunao adi tovakumgoyao sitáoya sina sitaiyaduduwo Pero yaina sidigo kadi, ‘Kom manakae im sinapu nakae kai im pakonayao yaima? ");
INSERT INTO gvs_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Limou geya sivinimeta geya, go sem ama tolovinao sibowoima kadi, “Vaega be limou kopopolīdi, e kogabūdi simalagurewa!” Go kunōve! Kai im pakonayao silauima unana vaega be limou kamadagidi simalagurewa go, geya sibadebadeta boi nakae go, ame kom be nakae im bodao taiyao imi puwoya!’ ");
INSERT INTO gvs_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Go kina Peroyana ipodeda idigo kana, ‘Komi suumoyaimi! Moitamo toina komi suumoyaimi! Moe pasina boi kami, “Kutagonēma kana ima yoguyoguyao kagabudi kakasaledi Yauwe yaina.” ");
INSERT INTO gvs_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Tauna ame tuta kōna kopaisēwa! Woilīmi! Go limouyana, geya kavinimita, go sem vaega be limou simalagurewa adi badabada boi komaadagidi, e ame tuta nakae komadagīdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","E Isileli tubunao adi tovakumgoyao bogina siyagoi mou gagaina bei sibabane tutayana silatuwokoidi kadi, ‘Maliyalina tamo tamo poyapoya be limou komaadagidi simalagurewa adi badabada taabu kokupokūpo. Geya kada maliyalina tayamo goi geya.’ ");
INSERT INTO gvs_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","E tovakumgoyadi Pero sikalave go, sima Eroni be yau ama taiyuwo moetala kaatuyáwata sikamatanakoima. ");
INSERT INTO gvs_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Sikatubolatema sidigo kadi, ‘Yauwe bei igitemi itakinoimi komi toogoyoimi! Komi pasimi Pero be nakae ina pakonayao taiyao sigiteda sikalagiwoleda. Imi guinuwayana sisi nakae bogina kovini bei sisiyana goi sikaumateda.’ ");
INSERT INTO gvs_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","E akaluvilamna ana Yauwe alatuwoko adigo kagu, ‘Tomoya, kaga unana amo tomotayadi kuyogedegededi? Kaga unana kuetunegu tauyadi yaidi? ");
INSERT INTO gvs_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tutayana boi agimiima im livala Pero alatuwoko go, ima ame tuta amo tomotayadi iyogedeegededi go, kadago giyaina kuyaveedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Go kina Yauweyana ilatuwokoigu idigo kana, ‘Ame tuta bei kugite manakaegu aguinuwa Pero yaina. Moitamo. Nimagu toogagaina goi bei komi Isileli tubunao ivalilivemi kona. Ina kaba lovina goi bei ivatapiyemi!’ ");
INSERT INTO gvs_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","E tuwaina idigo kana, ‘Yau Yauwe. ");
INSERT INTO gvs_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Tutayana boi toinigu akaiwoduwegu Eberamo be Aisake be Yakobo yaidi goi, alatuwokoidi Yau Tokavavágana Tokalika go, yoigu Yauwe, moe geya avatulukoidita. ");
INSERT INTO gvs_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nakae boi akanasiukoidi go, akatótula bego da Kenani idi poyapoya bei avinidi. Boi poyapoyayana goi situliya nakae sieogaoga. ");
INSERT INTO gvs_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Yau bogina Isileli tubunao idi kalayawoi anove. Idi kalayawoiyana unana da Itipita sipakoidi, tauna kidi da Itipita idi pakonayao. Idi lida anove, e guna kanasíuna yaidi goi anuwokavate. ");
INSERT INTO gvs_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Tauna semowo Isileli tubunao kulatuwokōidi kam, “Yau Yauwe. Da Itipita idi kogúyala moumouna goi bei ayavemi. Ami pákwana goi bei ataligeimi be nimagu yoosalaina goi bei guna liuna gagaidi avinidi go, komi bei atatetemi. ");
INSERT INTO gvs_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Bei akinavemi komi guna bodao go, Yau imi Yaubada. Bei koyagoigu Yau Yauwe imi Yaubada, da Itipita idi kogúyala moumoudi goi bei ayavemi ");
INSERT INTO gvs_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","go, avakedemi koma poyapoyayana goi boi nimagu akatuulagasi akatótula bego Eberamo, Aisake be Yakobo avinidi. Ame poyapoyayana bei komi imi poyapoya. Yau Yauwe.”’ ");
INSERT INTO gvs_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","E tuwo atáoya, ana Isileli tubunao nakae alatuwokoidi go, wowodi sikaliwoya be adi kogúyala ivakaigaga, tauna sopagu geya sikabikaoneyeta. ");
INSERT INTO gvs_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","‘Kutāoya kūna Pero da Itipita adi tolovina kulatuwōko Isileli tubunao ina kaba lovina goi italigeimi.’ ");
INSERT INTO gvs_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Go yau adigo kagu, ‘Kunōve! Segowo Isileli tubunao sopagu geya sikabikaoneyeta go, Pero masa bei sopagu ikabikaone. Yau maegu imoumou!’ ");
INSERT INTO gvs_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","E Yauwe ibóbwara Eroni be yau yaima, e ima lovina semao Isileli tubunao manudi be nakae Pero da Itipita adi tolovina manuna ivinima, idigo kana, ‘Isileli tubunao Itipita goi kokabīdi konavēdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ame Isileli tubunao adi dala yawou aiyuwo adi nunu adi tovakumgoyao: Isileli ina botomoya Rubeni natunao koroto ame nakae: Enoki be Palu, Esironi be Karami. Ame tauna dala yoina Rubeni ana nunu adi tovakumgoyao. ");
INSERT INTO gvs_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ame Simioni natunao koroto: Yemweli, Yamini, Owadi, Yakini, Sokara be Saulo. Sauloyana sinana guma Kenani. Ame tauna dala yoina Simioni ana nunu adi tovakumgoyao. ");
INSERT INTO gvs_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ame Livai natunao koroto adi bíbina goi: Gerasoni, Kowate be Merari. Kina Livai ana tala ana badabada 137 tutayana ikámasa. ");
INSERT INTO gvs_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerasoni natunao koroto adi bíbina goi ame nakae: Livani be Simei go, niga moe tubudiyao adi nunu yoidi nakae. ");
INSERT INTO gvs_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kowate natunao koroto ame nakae: Amram, Isari, Ebironi be Useyeli. Kowate ana tala ana badabada 133 tutayana ikámasa. ");
INSERT INTO gvs_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari natunao koroto ame nakae: Makili be Mse. Ame tauna dala yoina Livai ana nunu adi tovakumgoyao adi bíbina goi. ");
INSERT INTO gvs_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","E Amram inai tamana niuna yoina Yokebedi. Niga go Yokebediyana natunao koroto Eroni be yau ivenatunima. Amramyana ana tala ana badabada 137 tutayana ikámasa. ");
INSERT INTO gvs_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Isari natunao koroto ame nakae: Kora, Nepegi be Sikiri. ");
INSERT INTO gvs_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Useyeli natunao koroto ame nakae: Misaeli, Elisapani, Siteli. ");
INSERT INTO gvs_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","E Eroni inai Aminadabi natuna yoina Eliseba go, Eliseba siyana yoina Nakasoni. Elisebayana ivenátuna, natunao koroto ame nakae: Nadabi be Abaiu, Eliyasa be Itamari. ");
INSERT INTO gvs_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","E Kora natunao koroto ame nakae: Asira, Elikana be Aviyasapi. Ame nunu tamo tamo Kora ina bodao goi. ");
INSERT INTO gvs_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","E kina go Eroniyana natuna Eliyasa inai Putiyeli natuna go, ivenátuna, natuna koroto yoina Pinikasi. Ame tauna dala yoina Livai ana nunu adi tovakumgoyao. ");
INSERT INTO gvs_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","E ame Eroniyana be yau Mosese boi Yauwe ilatuwokoima kana, ‘Kōna semiyao Isileli tubunao Itipita goi kokabīdi konavēdi go, kidi badabadaaidi dala dala nakae goi sisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Moe kai ama taiyuwo, e kana Pero da Itipita adi tolovina kalatuwoko kai Isileli tubunao itagonema Itipita goi kasowóduwo. Ame Eroniyana be yau Mosese. ");
INSERT INTO gvs_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","E tutayana Itipita goi Yauwe ilatuwokoigu, ");
INSERT INTO gvs_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","idigo kana, ‘Yau Yauwe. Kūna Pero da Itipita adi tolovina kulatuwōko kaga liliuna bogina alatuwokoim.’ ");
INSERT INTO gvs_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Go yau adigo kagu, ‘Kunōve. Yau maegu imoumou. Masa bei Pero sopagu ikabikaone.’ ");
INSERT INTO gvs_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","E Yauwe ilatuwokoigu idigo kana, ‘Kunovēgu. Bogina avayokoim kom bei kueyaubada Pero yaina goi go, kina siyam Eroni bei im tokabivalavala. ");
INSERT INTO gvs_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","E kom sem kaga liliuna bogina alatuuwokoim siyam Eroni kulatuwōko nakae. E kina go Eroni bei ina Pero ilatuwoko komi Isileli tubunao Itipita goi italigeimi bei ina kaba lovina goi kosowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","E Yau sem Pero ina dabakasa bei avaituwe. Guna kaba kinana be nakae guna guinuwa aba kainaopa badabadaidi nava bei Itipita goi aguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Go Pero bei geya inovemta. Tuwo nimagu toogagaina bei abisisobu mou gagaidi ayatoidi da Itipita yaidi, nakae guna guinuwa aba takínona aguinuwedi yaidi, namliyeta baige komi guna bodao Isileli tubunao badabadaaimi Itipita goi akabimi anavemi go, dala dala nakae goi kosowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Da Itipita bei siyagoidokoigu Yau Yauwe tutayana nimagu toogagaina ayosale alauidi be nakae yaidi goi komi Isileli tubunao akabimi anavemi.’ ");
INSERT INTO gvs_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","E tuwo moitamo Eroni be yau kaga madabokina Yauwe ilatuuwokoima, nakae madabokiina kaguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ego tutayana yau guna tala ana badabada bogina 80 go, Eroni ana tala ana badabada 83, e kana Pero yaina kabóbwara. ");
INSERT INTO gvs_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","E Yauwe Eroni be yau ilatuwokoima idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","‘Pero bei ilatuwokoimi kana, “Guinuwa aba kainaopa koguinūwe.” Tutayana nakae ilatuwokoimi, e Mosese, siyam Eroni kulatuwōko kam, “Im kaituko kwalisobūye Pero matana goi.” E tutayana ikalisobuye, bei imalamoteta.’ ");
INSERT INTO gvs_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","E tuwo moitamo Eroni be yau katáoya kana Pero goi kaga nakae Yauwe bogina ilatuuwokoima kaguinuwe. Eroni ina kaituko ikalisobuye Pero mana pakonayao matadi goi, e imalamoteta. ");
INSERT INTO gvs_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","E kina Pero ina tonuwopolalayao be ina tomemeyavayao iduduwedi sima. Sima, kidi nakae itoboinedi idi méyava goi nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Koroto tamo tamo idi kaituko sikalisobuyedi simalamoteta go, Eroni ina kaituko itáoya, kidi idi kaitukoyadi ilotonoidi. ");
INSERT INTO gvs_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Go kina Pero dabana ikasa toina, tauna geya inovemeta, nakae Yauwe boi bogina idige. ");
INSERT INTO gvs_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","E Yauwe ilatuwokoigu idigo kana, ‘Pero dabana ikasa, tuwo tomotayadi geya italigeidita bei sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Go tauyana itomo nobuyana bei itáoya ina sákala Nairi goi go, kom mainao im kaituko boi imalaamoteta kukavāle kunāve Nairi kikina goi kuutāoya, tauyana kutuuyaōsi. Tutayana iwowoiwo sakalayana manuna, ");
INSERT INTO gvs_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","e kulatuwōko kudīgo kam, “Yauwe kai Iberiu ima Yaubada ietunegu ama yaim. Tauyana idigo kana, ‘Guna bodao kutaligēidi bei sima yoyowo goi sisakululu yau yaigu.’ Go Kunōve. Ame lovinayana nava geya kukabikaoneyeta. ");
INSERT INTO gvs_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tuwo Yauwe ibóbwara ame nakae, kana, ‘Guna guinuwa ame goi bei kuyagoigu bego Yau Yauwe.’ Kunōve. Aitukoyana nimagu goi sákala Nairi bwaena bei asapi imalaikaika. ");
INSERT INTO gvs_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Go íyana madabokidi Nairi goi sikaaiyaka bei sikámasa. Tuwo Nairi bwaena bei ibówana. Nakae komi da Itipita geya itoboinemita bwaenayana konim.”’ ");
INSERT INTO gvs_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","E aiyuwoina idigo kana, ‘Eroni kulatuwōko kudīgo kam, “Im kaituko kukābi kuyosāle Itipita bwaena liliudi yatanaidi goi, nakae sákala liliudi, oveya liliudi, otoku liliudi be dorom liliudi goi bei simalaikaika. Tuwo bwae Itipita madabokina goi imalaikaika. Idi kontena alova o gurewa nakae, bwae simalaikaika.”’ ");
INSERT INTO gvs_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tuwo Eroni be yau kana kaguinuwe nakae Yauwe ilatuwokoima. Aitukoyana Eroni ikatulagasi Pero mana pakonayao matadi goi go, Nairi bwaena isapi, e bwae liliuna Nairi goi simalaikaika. ");
INSERT INTO gvs_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Go Nairi iyaiyanidi sikaaiyaka madabokidi sikámasa, tauna Nairi bwae ibówana, e da Itipita geya itoboinedita sinim. Itipita goi madabokiina bwae simalaikaika. ");
INSERT INTO gvs_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","E da Itipita idi tomemeyavayao idi méyava goi nakae siguinuwe. Tuwo Pero nava idaabakasa, e Eroni be yau geya inovemeta nakae Yauwe boi bogina idige. ");
INSERT INTO gvs_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","E Pero itugavilema ikaluvila ina ina vada goi isiu go, ame manuna nakae geya inuwonuwoneta. ");
INSERT INTO gvs_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","E da Itipita madabokidi sina Nairi kikina goi siélina adi bwae silusala. Bogina kuyagoi. Geya itoboinedita bwae sákala Nairi goi sinim. ");
INSERT INTO gvs_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","E Yauwe Nairi bwaena isapi mlina maliyalina ana badabada ainima aiyuwo sikavava. ");
INSERT INTO gvs_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","E Yauwe ilatuwokoigu idigo kana, ‘Kūna Pero kulatuwōko kudīgo kam, “Yauwe ibóbwara ame nakae, idigo kana, ‘Guna bodao kutaligēidi bei sima sisakululu yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Go neta kuvagagaledi, e am dodōkana. Bei kwekwe aetunedi siwo im kasa madabokina goi bei aliunemi. ");
INSERT INTO gvs_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nakae kwekwe Nairi goi bei sibadabada, e bei sisinalaga sima im vada goi sisiu, im kaba masisi vabodaupaina goi be nakae kebam goi. Aiyuwoina bei im pakonayao be nakae da Itipita idi vada goi sisiu. Nakae imi kaba vaipolu goi sisiu be imi noko goi sisowoya. ");
INSERT INTO gvs_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kwekweyadi bei sipela kom, im tomota be nakae im pakonayao yatami goi sitowo!’”’ ");
INSERT INTO gvs_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","E tuwo Eroni be yau kana Peroyana kalatuwoko. Ikavava, e Yauwe ilatuwokoigu idigo kana, ‘Eroni kulatuwōko aitukoyana iyosale sákala be oveya be nakae otoku yatanaidi goi, e bei kwekwe sisinalaga Itipita goi.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tuwo moitamo Eroni alituwoko ikavava, nimana ikatulagasi Itipita bwaedi ivasakikinakoidi, e kwekwe sisinalaga Itipita sivatum. ");
INSERT INTO gvs_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","E kidi tomeméyava idi méyava goi nakae siguinuwe, e kwekwe sivaituwedi da Itipita idi kasa goi sisinalaga. ");
INSERT INTO gvs_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tuwo Pero inuwonúwana, geya, Eroni be yau iduduwema kana ilatuwokoima idigo kana, ‘Yauwe yaina kokawanōi bei kwekwe ikabidi da Itipita be nakae yau yaima goi go, tomotayadi bei ataligeidi sina idi yoguyoguyao sigabudi sikasaledi Yauwe yaina.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","E adigo kagu, ‘Dedevina. Kom toinim kulovina ava tuta latuwom akawanoi kom be im pakonayao be da Itipita liliudi manumi bei kwekwe sikavava komi be nakae imi vada goi go, Nairi kaka goi bei sikaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","‘Itomo’, Peroyana kaena. Tuwo adigo kagu, ‘Nakae kudige bei isowóduwo, e bei kuyagoidoko bego geya vatau tayaamo ikaaiyaka nakae Yauwe ima Yaubada. ");
INSERT INTO gvs_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kwekweyadi bei sikalavemi kom be im vada be im pakonayao be nakae da Itipita. Nairi kaka goi bei sikaaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","E Eroni be yau katáoya Pero kakalave go, kasowóduwo. Kasowóduwo, ataiyaduduwo Yauwe yaina kwekwe boi iiyatoidi Pero yaina manudi. ");
INSERT INTO gvs_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","E moitamo Yauwe iguinuwe nakae guna livala. Tuwo kwekweyadi da Itipita idi vada, idi kasa be nakae idi tánuwo goi sikamasa kówasa. ");
INSERT INTO gvs_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ikavava, sakavaidi sivagugunidi gúguna badabadaaidi goi, tuwo asa ibówana. ");
INSERT INTO gvs_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","E tutayana Pero igite kwekwe bogina sikavava, mainao aiyuwoina idabakasamna, tuwo Eroni be yau geya inovemeta nakae Yauwe boi bogina idige. ");
INSERT INTO gvs_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","E Yauwe ilatuwokoigu idigo kana, ‘Eroni kulatuwōko kudīgo kam, “Im kaituko kuyosāle, poyapoya kaukauna kusāpi bei kaukauyana Itipita ana madabokina goi imaladimokíkila.”’ ");
INSERT INTO gvs_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","E tuwo moitamo nakae kaguinuwe. Aitukoyana Eroni iyosale, poyapoya kaukauna isapi. Ikavava, dimokíkila badabadaaidi sisowóduwo tomota be nakae yoguyogu goi. Poyapoya kaukauna madabokina Itipita ana madabokina goi imaladimokíkila. ");
INSERT INTO gvs_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","E tomemeyavayadi madi méyava sipoikíkina poyapoya kaukauna goi dimokíkila sikaiwoduwedi go, geya itoboinedita. Tuwo dimokikilayadi tomota be yoguyogu yaidi goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","E tomemeyavayadi Pero silatuwoko sidigo kadi, ‘Ame Yaubada ina togaga.’ Go kina Peroyana nava idaabakasa, tuwo geya inovemeta nakae Yauwe boi bogina idige. ");
INSERT INTO gvs_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","E Yauwe ilatuwokoigu idigo kana, ‘Itomo nobuyana giyaina kutāoya, kusōu kuīwo sákala Nairi goi Pero kutuuyaōsi. Kunōve. Tauyana itomo nobuyana bei isou iiwo ina Nairi goi. Tutayana iwowoiwo bwae manuna kūna kulatuwōko kudīgo kam, “Yauwe ibóbwara ame nakae, idigo kana, ‘Guna bodao kutaligēidi bei sima sisakululu yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Go nakae bogina adige, neta guna bodao geya kutaligeidita, e am dodōkana. Nenéola badabadaidi bei aetunedi siwo kom, im pakonayao be da Itipita yaimi goi be nakae imi vada goi. Tuwo komi da Itipita imi vada be nakae poyapoya goi kootáoya nenéola bei sivatum. ");
INSERT INTO gvs_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ago amo maliyalinayana goi guna bodao idi kasa Goseni bei atavileiyedi, e amoko goi nenéola geya sikaiyaketa. Moeko goi bei kuyagoidokoigu bego Yau Yauwe im kasa Itipita goi akaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Yau guna bodao be kom im bodao go, nauyayanaidi goi túwana bei ayato. Itomo ame aba kinanayana bei isowóduwo.’”’ ");
INSERT INTO gvs_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","E tuwo Yauwe iguinuwe nakae ilatuwokoigu go, Pero geya inoveguta. Tuwo nenéola badabadaidi sina Pero be nakae ina pakonayao idi vada goi sisiu. Neneolayadi da Itipita idi kasa madabokina sikaaigoyai. ");
INSERT INTO gvs_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","E tuwo Pero inuwonúwana geya, Eroni be yau iduduwema kama ilatuwokoima idigo kana, ‘Kōna imi yoguyoguyao kogabūdi kokasalēdi imi Yaubada yaina go, ameko Itipita sinaena goi nakae koguinūwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Go yau adigo kagu, ‘Moe geya itoboinemeta ameko Itipita sinaena goi nakae kaguinuwe. Kai bei yoguyogu kagabudi kakasaledi Yauwe ima Yaubada yaina go, kaga kagabugabu moe aba kalagíwala komi da Itipita matami goi. Nakona nakae kakasaledi go, kogitema, e giya gurewa goi bei kokaumatema. ");
INSERT INTO gvs_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Itoboine maliyalina aito goi kaketoiya kana yoyowo goi ima yoguyoguyao kagabudi kakasaledi Yauwe ima Yaubada yaina nakae boi bogina ilatuwokoima.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Tuwo Pero idigo kana, ‘Bei ataligeimi kona yoyowo goi imi yoguyoguyao kogabudi kokasaledi Yauwe imi Yaubada yaina go, taabu kononōina aduwanau, go sem tupwana yomana goi. Go kokawanōi manugu.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","E adigo kagu, ‘Gwa! Ame bei akalavem go, ana akawanoi Yauwe yaina gobe itomo, nenéola sivagisiyasiya kom, im pakonayao be nakae da Itipita yaimi. Go kom sem, taabu aiyuwoina kupolapōla boi nakae im pola, e geya kutaligeimeta bego kana ima yoguyoguyao kagabudi kakasaledi Yauwe yaina.’ ");
INSERT INTO gvs_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","E tuwo atáoya Pero akalave go, asowóduwo ana akawanoi Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","E Yauwe iguinuwe nakae akawanoi. Nenéola Pero, ina pakonayao be da Itipita liliudi yaidi goi ikabidi ikalavedi. Ikavava, geya kada tayaamo nenéola ikaaiyaka geya. ");
INSERT INTO gvs_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Go kina Peroyana nava idaabakasa boi nakae, tuwo tomotayadi geya italigeidita. ");
INSERT INTO gvs_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","E Yauwe ilatuwokoigu idigo kana, ‘Kūna Pero kulatuwōko kudīgo kam, “Yauwe kai Iberiu ima Yaubada ibóbwara ame nakae idigo kana, ‘Guna bodao kutaligēidi bei sima sisakululu Yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Go neta kom kwatae go, kuvagagaledi, ");
INSERT INTO gvs_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","e am dodōkana. Yau Yauwe imi yoguyoguyao ali sinaena bei amtulidi vísiya toogagaina toina goi. Yoguyoguyadi ame nakae: Imi osiyao, imi aseyao, imi kameriyao, imi bulumakauyao be imi sipiyao. ");
INSERT INTO gvs_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ago Yau Yauwe guna guinuwa goi Isileli tubunao idi yoguyoguyao akimasabedi ituli, da Itipita idi yoguyoguyao ituli, e bei kidi Isileli tubunaoyadi goi geya kada tayaamo yoguyogu bei itagau geya.’”’ ");
INSERT INTO gvs_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","E visiyayana ana tuta Yauwe iupe idigo kana, ‘Itomo Yau Yauwe ame visiyayana Itipita goi bei aguinuwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","E tuwo moitamo vanuwo itomo Yauweyana nakae iguinuwe. Da Itipita idi yoguyoguyao badabadaidi imtulidi sikámasa go, kai Isileli tubunao ima yoguyoguyao goi geya kada tayaamo ikámasa geya. ");
INSERT INTO gvs_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","E Pero ina topaisewayao ietunedi sina Isileli tubunao ima yoguyoguyaoyadi sigitedi nakona sikámasa o geya. Go sinonoina, sigite, geya kada tayaamo ikámasa geya. Sigite ikavava, sikaluvilamna sina Pero silatuwoko go, Pero nava idaabakasa, tuwo tomotayadi geya italigeimeta. ");
INSERT INTO gvs_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","E Yauwe Eroni be yau ilatuwokoima idigo kana, ‘Kōna nimami goi silekau kotavayāili. Ikavava, kōna Pero matana goi, e kom, Mosese, kwalalagāsi ituko ina yábana dadavina. ");
INSERT INTO gvs_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Silekauyana bei imalakaukau, e Itipita ana madabokina ivatum. Ivatum, rarawa bei sisowóduwo tomota be yoguyogu yaidi goi simalapotu.’ ");
INSERT INTO gvs_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Tuwo moitamo kana silekau nimama goi katavayaili. Ikavava, kana Pero matana goi katáoya go, silekauyana akalalagasi itasapasapa, e rarawa sisowóduwo tomota be yoguyogu yaidi goi simalapotu. ");
INSERT INTO gvs_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","E da Itipita idi tomemeyavayadi adi rarawa pasidi geya itoboinedita matagu goi sitáoya. Bogina kuyagoi. Kidi nakae da Itipita madabokidi madi rarawa go, sikawoiva. ");
INSERT INTO gvs_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","E Yauwe Pero dabana ikaukase, e geya inovemeta nakae Yauwe boi bogina ilatuwokoigu. ");
INSERT INTO gvs_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","E Yauwe ilatuwokoigu idigo kana, ‘Nobuyana giyaina kutāoya kūna Pero matana goi kulatuwōko kudīgo kam, “Yauwe kai Iberiu ima Yaubada ibóbwara ame nakae, idigo kana, ‘Guna bodao kutaligēidi bei sima sisakululu Yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ame tutayana goi guna liuna liliudi bei aetunedi siwo kom, im pakonayao be nakae da Itipita madabokimi yaimi, e bei koyagoi bego geya kada vatau tayaamo poyapoya ana madabokina goi Yau nakae. ");
INSERT INTO gvs_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Boi nimatu ima ame tuta itoboinegu bego nimagu abisisobu kom be nakae im bodao vísiya goi asapimi bei madabokimi poyapoya ame goi atauwemi. ");
INSERT INTO gvs_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Go ame pasina atagonem maa yawoim: Latuwogu guna togaga avatulukoim go, aiyuwoina bei valegu inúnuwo ina poyapoya ana madabokina goi. ");
INSERT INTO gvs_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Go mam kamanamana guna bodao nava geya kutaligeidita. ");
INSERT INTO gvs_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Go am dodōkana! Itomo ame niyalayana nakae kúwana kasakasaidi guregurewa igoyo toina nakae bei aetune iwo. Ame kuwanayana geya tayaamo tuta tomota Itipita goi sigite boi Itipita igimisowóduwo go, ima ame tuta geya. ");
INSERT INTO gvs_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Tauna ame tuta vala kuetūne im bodao liliudi yaidi bego idi yoguyoguyao simedi idi vada goi sikaiyaka, e bei dedevidi. Tomota liliudi be nakae yoguyogu liliudi neta moetala goi sikaaiyaka, bei kuwanayana isou isamatedi sikámasa.’”’ ");
INSERT INTO gvs_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","E kidi go Pero ina pakonayao yaidi goi avatauwa neta Yauwe ina livala sitaaimamine, e idi topaisewayao be nakae idi yoguyoguyao sisiyaedi sinavedi vada goi sikaiyaka dedevidi. ");
INSERT INTO gvs_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Go avatauwa neta Yauwe ina livala geya sinoveyeta, e idi pakonayao be nakae idi yoguyoguyao sikalavedi moetala goi sikaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","E Yauwe ilatuwokoigu idigo kana, ‘Nimam kuyosāle yábana kuvasakikināko bei kúwana kasakasaidi sisou sima kaga liliuna Itipita ana madabokina goi sibugoyaidi. Nakae tomota, yoguyogu be tánuwo.’ ");
INSERT INTO gvs_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","E tuwo moitamo guna kaituko ayosale yábana avasakikinako. E kina go Yauwe kúwana kasakasaidi ma palapalaidi be nakae ma kavilidi ietunedi sisou sina Itipita goi. ");
INSERT INTO gvs_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","E kúwana kasakasaidi be nakae ma kavilina sisousou, e igoyo toina nakae geya tayaamo tuta tomota Itipita goi sigite. Boi Itipita igimisowóduwo ima ame tuta nakae geya. ");
INSERT INTO gvs_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","E kuwanayadi sisou kaga liliuna Itipita ana madabokina goi sisamatedi, tomota be nakae yoguyogu. Nakae kaga liliuna tánuwo goi be nakae alova liliudi, madabokina sisamatematedi. ");
INSERT INTO gvs_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Go asa Goseni goi kai Isileli tubunao kakaaiyaka go, ame asayana kúwana kasakasaidi geya sisouta geya. ");
INSERT INTO gvs_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","E tuwo Pero vala ietune ima Eroni be yau iduduwema kana. Kana, ilatuwokoima idigo kana, ‘Ame tuta bogina agoyo. Kina Yauwe tokibóbwata go, yau be nakae da Itipita liliuma toogoyoima. ");
INSERT INTO gvs_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Tauna kokawanōi Yauwe yaina. Ina palapala be ina kúwana kasakasaidi bogina tuwo, oma ikai. Bei ataligeimi kona. Moitamo toina. Geya tuwaina ameko goi kokaiyāka.’ ");
INSERT INTO gvs_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","E adigo kagu, ‘Tutayana im kasa ame goi asowóduwo, nimagu bei akatulagasidi akawanoi Yauwe yaina. Palapala mainao bei sisayata be kúwana kasakasaidi geya tuwaina sisou, e bei kuyagoi bego poyapoya ana madabokina moe Yauwe ina kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Go kom mam pakonayao, e bogina ayagoimi bego nava Yauwe Yaubada geya komatoiteyeta.’ ");
INSERT INTO gvs_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ego ebulu saleoina bogina ididi, bali bogina sikéuwo go, kuwanayana isou isamaumauidi, tauna sigoyo bogina. ");
INSERT INTO gvs_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Go witi nava geya sididita, tauna geya isamaumauidita. ");
INSERT INTO gvs_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","E tuwo atáoya, Pero akalave, ina kasa goi asowóduwo, abala ana nimagu akatulagasidi Yauwe yaina akawanoi. Tuwo palapala be kúwana kasakasaidi sisayata, nakae kúwana geya tuwaina isou poyapoya goi. ");
INSERT INTO gvs_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","E tutayana Pero igite bego kúwana, kúwana kasakasaidi be palapala sisayata, aiyuwoina igoyomna, e kina mana pakonayao taiyao dabadi sikasa. ");
INSERT INTO gvs_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Tuwo Pero dabana ikasa, kai Isileli tubunao geya italigeimeta bei kasowóduwo nakae boi Yauwe bogina ilatuwokoigu bei siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","E Yauwe ilatuwokoigu idigo kana, ‘Aiyuwoina kūna Pero goi kukawanōi guna bodao manudi. Tauyana mana pakonayao dabadi bogina akaukasedi. Ame nakae aguinuwe bei ameko goi Yau guna kaba kinana kidi yaidi aguinuwedi ");
INSERT INTO gvs_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","be nakae kovatétala natumiyao be tubumiyao yaidi manakaegu da Itipita akaiwotetedi be nakae guna kaba kinanayadi yaidi goi aguinuwedi. Moeko goi koyagoigu bego Yau Yauwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","E tuwo moitamo Eroni be yau kana Pero kalatuwoko kadigo kama, ‘Yauwe kai Iberiu ima Yaubada ibóbwara ame nakae, idigo kana, “Kom sivavina nakae nava kuukatae bego kwatetagonem Yau yaigu? Guna bodao kutaligēidi bei sima sisakululu Yau yaigu! ");
INSERT INTO gvs_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Go neta kwatae, am dodōkana. Yau itomo bei tatabole amedi im kaba lovina goi. ");
INSERT INTO gvs_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Tataboleyadi poyapoya ana madabokina bei sivatum, nakae bei geya itoboinemita poyapoya kogite. Kaga liliuna boi kúwana kasakasaidi geya sisamaumauidita be nakae alova liliudi sidugo, e tataboleyadi bei silokanidi. ");
INSERT INTO gvs_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Kom be im pakonayao nakae da Itipita liliumi imi vada bei sivakayaodeidi. Ame dogoiyana geya kada tayaamo tuta tamamiyao be tubumiyao yaidi isowóduwo geya, adi bíbina kunu goi ima ame tutayana goi geya.”’ Abóbwara ikavava, ama taiyuwo katugavila Pero goi kasowóduwo kana. ");
INSERT INTO gvs_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Tuwo Pero ina pakonayao silatuwoko sidigo kadi, ‘Sivavina nakae bei amo tauyana kutagone mou goi iyowóida? Tomota kutaligēidi bei sina sisakululu Yauwe idi Yaubada yaina. Manakae? Nava geya kuyagoiyeta bego Itipita ana madabokina bogina sibugoyai?’ ");
INSERT INTO gvs_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Sibóbwara ikavava, Pero ietunedi sima Eroni be yau sikabima kakaluvilamna kana. Kana ilatuwokoima idigo kana, ‘Kōna kosakulūlu Yauwe imi Yaubada yaina. Ego avatau avatau bei taiyao kona?’ ");
INSERT INTO gvs_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Adigo kagu, ‘Liliuma, tubuwau be woiyai, tomoyamoya be namoyamoya, natumao koroto be vevina, e nakae ima yoguyoguyao, sipi be bulumakau taiyao kanavedi. Bogina kuyagoi. Uyáwana aikanina itoboine kaodugu Yauwe yaina.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Go kina Peroyana idigopopóita kana, ‘Moitamo, kadago Yauwe imi Yaubada bei ivakiitaumi nakae kom mam bodao kadago bei ataligeimi. Kunōve. Ayagoi komi konuwotulu. ");
INSERT INTO gvs_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Tauna geya. Kaga kom kudige moe geya. Kōna. Komi koroto amitava kōna kosakulūlu Yauwe yaina. Moe nakae bogina kokawanoiye.’ Pero ibóbwara ikavava, e matana goi Eroni be yau sivatapiyema. ");
INSERT INTO gvs_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","E tuwo Yauwe ilatuwokoigu idigo kana, ‘Nimam kuyosāle Itipita yatanaina goi bei tatabole sima Itipita alovaina be naunina liliudi silokanidi, nakae kaga liliuna boi kúwana kasakasaidi geya sisamaumauidita sikanidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Tuwo moitamo guna kaituko ayosale Itipita yatanaina goi. E kina go Yauwe yágira bomatu ietune ima Itipita goi go, ame maliyalina ana madabokina be sabamgo ana madabokina goi itowotowo. E vanuwo itomo tatabole bogina iyawoisavedi sima Itipita. ");
INSERT INTO gvs_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","E tataboleyadi sina Itipita ana madabokiina sivatum. Tauyadi badabada sisaki, nakae boi nimatu nakae geya go, bei tuta simamaima nakae geya. ");
INSERT INTO gvs_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Poyapoya ana madabokina sivatum, tuwo poyapoyayana ikalakoiwo. Náuna be alova keuwoidi, nakae kaga liliuna kúwana kasakasaidi geya sisamaumauidita madabokina silokanidi. Silokanidi ikavava, geya kada kaga tayaamo vakalakalaoina Itipita sinaena ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","E tuwo Pero woilina vala ietune ima Eroni be yau iduduwema kana. Kana ilatuwokoima idigo kana, ‘Bogina agoyo Yauwe imi Yaubada yaina be nakae komi yaimi. ");
INSERT INTO gvs_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tauna guna bágala sivatayamo konuwotāo be nakae kokawanōi Yauwe imi Yaubada yaina bei nakona ámasa ame ikabi inave.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","E tuwo yau ma siyagu katáoya Pero goi kasowóduwo kabala kana go, akawanoi Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","E tuwo Yauwe yágira toogagaina koiboga ietune ima, e tataboleyadi iyawoisavedi sina Négwasa Kayakayaina goi sisalili. Tauna geya kada tayaamo tatabole Itipita sinaena ikaiyaka geya. ");
INSERT INTO gvs_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ago Yauwe Pero dabana ikaukase, e kai Isileli tubunao geya italigeimeta. ");
INSERT INTO gvs_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","E tuwo Yauwe ilatuwokoigu idigo kana, ‘Nimam kuyosāle yábana kuvasakikināko bei Itipita ana madabokina goi kokonótuya isowóduwo. Nakae kokonotuyayana itoboinedi silotowo.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","E tuwo moitamo guna kaituko ayosale yábana avasakikinako, e Itipita ana madabokina goi kokonótuya isowóduwo go, kokonotuyayana maliyalina aito goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tomota geya itoboinedita sediyao sigitedi be nakae kebadi goi geya sitaoeta maliyalina aito sinaedi. Kai go Isileli tubunao ima kasa goi imavada. ");
INSERT INTO gvs_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Tuwo Pero vala ietune ima iduduwegu ana ilatuwokoigu idigo kana, ‘Kōna kosakulūlu Yauwe yaina. Gogómana nakae itoboinedi taiyao kona go, imi yoguyoguyao, nakae imi bulumakauyao be imi sipiyao, tuwo sikaiyaka ameko.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","E yau sem adigo kagu, ‘Geya. Kom kutagonēma ima yoguyoguyao vininabeso manuna nakae kanavedi bei maniyedi kagabudi, maniyedi kavakasavedi go, kakasaledi Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ima yoguyoguyao nakae kanavedi. Geya tayaamo bei ikaiyaka geya. Bogina kuyagoi. Ima yoguyoguyadi yaidi goi maniyedi bei kagabudi kasakululu Yauwe ima Yaubada yaina. Go kai geya kayagoiyeta ava yoguyoguva ana kadókana kana amoko goi kasakululu Yauwe yaina, e bei kayagoi.’ ");
INSERT INTO gvs_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","E kina Yauwe Pero dabana ikaukase, e Peroyana geya italigeimeta. ");
INSERT INTO gvs_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","E tuwo idigo kana, ‘Ame tuta kwalavēgu! Am dodōkana. Taabu kumamāima! Neta kuma maisigu kugite, bei kukāmasa!’ ");
INSERT INTO gvs_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","E yau sem adigo kagu, ‘Moe kubóbwara moitamo! Maisim bei geya agitemneiyeta geya.’ ");
INSERT INTO gvs_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","E Yauwe ilatuwokoigu kana, ‘Tayamo vísiya tuwaina bei Pero nakae da Itipita liliudi avinidi namliyeta baige italigeimi bei ameko goi kosowóduwo. Tutayana italigeimi, moitamo toina bei ivatapiyekowosimi. ");
INSERT INTO gvs_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Amo tutayana tomota kulatuwokōidi tamo tamo sina da Itipita yaidi kónana siriba be goura sikawanoiyedi go, bei sivinidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","E Yauwe anuwóiya goi da Itipita nuwodi igudalidi, e ina bodao anuwóiya sibabane da Itipita yaidi. Yau nakae. Pero ina pakonayao be da Itipita liliudi matadi goi yau koroto gagaigu. ");
INSERT INTO gvs_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","E tuwo ana Pero alituwoko adigo kagu, ‘Yauwe ibóbwara ame nakae, idigo kana, “Nabunatoina goi komi da Itipita bei awokoimi. ");
INSERT INTO gvs_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Imi botomoyayao koroto liliudi Itipita goi bei sikámasa. Kom Pero toolagaim im botomoya bei ikámasa be nakae im pákwana vavina, tauyana toosobuna, ina botomoya bei ikámasa. Imi yoguyoguyao adi botomoyayao bolamo nakae bei sikámasa. ");
INSERT INTO gvs_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tuwo Itipita ana madabokiina goi vataitáiya gagaina bei konove. Geya kada tayaamo tuta taiyayana ame nakae geya. Boi nimatu nakae geya, e tuta simamaima bei nakae geya. ");
INSERT INTO gvs_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Kidi go Isileli tubunao goi mge geya toina, nakae geya tayaamo weiniya bei igou tomota be yoguyogu yaidi. Moeko goi bei koyagoigu Yau Yauwe Isileli tubunao akimasabedi ituli, e komi da Itipita ituli.” ");
INSERT INTO gvs_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Tuwaina Yauwe idigo kana, “Im pakonayao liliudi bei sima aedi sivatugúyala Yau yaigu kadi, ‘Komi kosīya! Kom be nakae tomota liliudi sisabookuliyem kotāoya kosīya!’ Moe mlina bei Itipita akalave.” Tauna nakae Yauwe ibóbwara.’ Abóbwara ikavava, e magu egamogamogu gagaina Pero goi asowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","E Yauwe ilatuwokoigu idigo kana, ‘Pero geya inovemta bei yau itoboinegu guna guinuwa aba kainaopa avaituwedi da Itipita yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","E kina go Eroni be yau guinuwa aba kainaopayadi liliudi Pero matana goi kaguinuwedi go, Yauwe Pero dabana ikaukase, e ina kasa Itipita goi kai Isileli tubunao geya italigeimeta. ");
INSERT INTO gvs_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","E Yauwe Eroni be yau Itipita goi ilatuwokoima idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","‘Tukówana ame moe tukówana liliudi adi kaba vatowo komi manumi, nakae ame tukowanayana moe imi tala ana kaba vatowo. ");
INSERT INTO gvs_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Kōna semiyao Isileli tubunao liliudi kolatuwokōidi kodīgo kami, “Ame tukowanayana sinaena maliyalina yawou goi bodayáuwo adi tolovinayao tamo tamo kōna lami moe sipi bonatuna tamo tamo koyoisīdi; tauna lami tayamo bodayáuwo tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Go neta bodayáuwo ana tolovina tayamo ina boda geya sibadebadeta, e siyana ina vada kikina taiyao silamgógana bei sivakalo. Sivakalo itobu bei tauyadi sina lami siyóita. Siyóita, sikáika bei yoiyadi. ");
INSERT INTO gvs_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ami lamiyadi kokinavēdi ame nakae: Bolamo geya situbugoyogoyoita nakae adi tala tayamo. Komi imi yóita toinimi kolovina imi sipiyao yaidi o imi gotiyao yaidi. ");
INSERT INTO gvs_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Koyoisidi ikavava, komēdi imi vada goi komatakavatēdi ana kadókana ame tukowanayana maliyalina yawou aivasi goi. Amo maliyalinayana lavilavi goi komi Isileli tubunao liliumi imi lami bei kokaumatēdi. ");
INSERT INTO gvs_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kokaumatedi ikavava, lamiyadi ikaikaidi kokabīdi, e vadayadi goi kokakáika totomdi dadavina dadavina be nakae diligaemaina komigīdi, e moe ami kaba kinana. ");
INSERT INTO gvs_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ikavava, lami iwoidi kogabūdi, e amo sabamgoyana goi kokāika go, beredi pokaka be pai tamatamaina taiyao kogōbe. ");
INSERT INTO gvs_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Taabu iwoidiyadi maamaidi kokakāika o taabu kovaaipolūdi, go sem kogabūdi; bulubuluna be aena be kaga liliuna posinae sinaena taiyao kogabūdi. ");
INSERT INTO gvs_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Vanuwo itomo taabu tayamo talaina ikesakēsa. Neta talaina tayamo ikesa, tuwo kogābu bei kovakasave. ");
INSERT INTO gvs_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","E kokāika ame nakae: Ami kwama bogina kolosīdi imi koidádana manuna, imi sendoro nakae bogina kovalilivīdi, imi kaituko nimami goi, e woilīmi kokaika wowōila imi siya manuna. Ame aikayana moe Basitáwana Aikanina Yau Yauwe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Amo sabamgoyana goi bei asiu Itipita ana madabokina avanibisi go, botomoya koroto liliudi asayana goi bei alauidi, tomota be yoguyogu. Da Itipita idi basaleliuyao liliudi bei aliunedi. Yau Yauwe. ");
INSERT INTO gvs_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Lamiyadi ikaikaidi moe komi ami kaba kinana vadayadi goi kokaaiyaka. Tutayana ikaikayana agite, bei abasitaoimi, tuwo komi geya kada tayaamo vísiya bei iwo ilauimi geya, tutayana da Itipita alauidi. ");
INSERT INTO gvs_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ame maliyalinayana moe aba nuwokavata yaimi. Tala tamo tamo maliyalinayana goi uyáwana aikanina koowodūgu Yau yaigu bei konuwookavate kaga Yau Yauwe aguinuwe manumi. Ame malamalagatayana be nakae malamalágata simamaima kowodūgu. Ame lovinayana ikaiyako vāta yaimi. ");
INSERT INTO gvs_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Maliyalina ana badabada ainima aiyuwo goi beredi pokaka kokakāika. E maliyalina vakuumgoina goi isti imi vada sinaedi kokabīdi kokalavēdi. Avatau neta beredi mana isti ikakáika amo maliyalina ainima aiyuwo goi, e tauyana komi Isileli tubunao yaimi goi kolivisīye. ");
INSERT INTO gvs_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Maliyalina vakuumgoina be nakae maliyalina ainima aiyuwoina goi kotugūguna tugúguna kimaasabaina manuna. Amo maliyalinayadi aiyuwo goi paisewa liliudi geya, go sem tayamo paisewa tauna itoboine moe kovaipolūmo. ");
INSERT INTO gvs_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Beredi Pokaka Aikanina koowodūgu. Bogina koyagoi. Ame maliyalinayana komi badabadaaimi dala dala goi akabimi Itipita goi anavemi. Ame lovinayana ikaiyako vata yaimi, tauna malamalágata tamo tamo simamaima bei siiwodugu. ");
INSERT INTO gvs_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Aikaniyana kokāika ame nakae: Tukówana vakuumgoina ana maliyalina yawou aivasi lavilavina goi beredi pokaka kokakāika ana kadókana maliyalina ainima aiyuwo lavilavina goi. ");
INSERT INTO gvs_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Maliyalinayadi ainima aiyuwo goi isti taabu ikaaiyāka imi vada sinaedi. Avatau neta beredi mana isti ikáika, e tauyana komi Isileli tubunao liliumi yaimi goi kolivisīye. Nakae koguinūwe neta tauyana tomalatonikasa yaimi o neta ibíbina yaimi. ");
INSERT INTO gvs_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Geya kada kaga tayaamo mana isti imi kaba kaiyaka liliudi goi kokāika geya, go sem beredi pokaka kokakāika.” Tauna nakae semiyao Isileli tubunao kolatuwokōidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","E Yauwe ibóbwara ikavava, yau ana Isileli tubunao adi tomoyamoya aduduwedi sima alatuwokoidi adigo kagu, ‘Tāna ida lamiyao o ida gotiyao takinavēdi, e tayoisīdi ida bodayáuwo manudi. Ikavava, lamiyadi takaumatedi Basitáwana Aikanina manuna. ");
INSERT INTO gvs_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Takaumatedi ikavava, lamiyadi ikaikaidi noko goi tasaligogōidi. Ikavava, náuna tayamo yoina isopi ma patumidi takabīdi, nokoyana goi tasavakutuīdi. Ikavava, ida vada totomdi dadavina dadavina be nakae diligaemaina tamigīdi. Geya vatau tayaamo kita yaida ina vada goi isowōduwo, go sem madabokida ida vada sinaedi goi takaiyāka ana kadókana vanuwo itomo. ");
INSERT INTO gvs_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Yauwe Itipita goi bei isiu ivaníbita, e da Itipita ilauidi. Go tutayana ikaikayana ida vada totomdi dadavina dadavina be diligaemaina goi igite, e vadayadi bei ibasitaoidi go, ina tómtula geya itagoneyeta isiu ilauida. ");
INSERT INTO gvs_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Moe sinapuyana taguinūwe ada lovina nakae. Lovinayana ikaiyako vata kita, natudao be nakae tubudao yaida. ");
INSERT INTO gvs_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","E tutayana tasiu poyapoya Yauwe bei iivinida nakae boi ikatotule, tapwaroro ame ana sinapu taguinūwe. ");
INSERT INTO gvs_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Tutayana natudao silumadádana kadi, “Kaga unana tapwaroro ame ana sinapu taguinuwe?” ");
INSERT INTO gvs_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","e kita bei kada, “Yoguyogu ame takauumatedi moe Yauwe ina Basitáwana ana vininabeso manuna. Vininabesoyana goi Yauwe tanuwookavāte manakaena kita Isileli tubunao ida vada Itipita goi ibasitaoidi tutayana da Itipita ilauidi go, kita iyaveda.”’ Abóbwara ikavava, e tomota liliudi aedi sivatugúyala sisakululu Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Sisakululu ikavava, sisáwala sina siguinuwe nakae Yauwe boi Eroni be yau ilatuwokoima. ");
INSERT INTO gvs_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","E nabunatoina goi Yauwe ina da Itipita idi botomoyayao liliudi ilauidi. Pero tauyana toolagaina ina botomoya iláui nakae deri ana tokaiyaka, tauyana toosobuna ina botomoya iláui, nakae idi yoguyoguyao idi botomoyayao bolamo ilauidi. ");
INSERT INTO gvs_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Amo sabamgoyana goi Pero be ina pakonayao be nakae da Itipita liliudi sitáoya, sivataitáiya gagaina. Bogina koyagoi. Vada tamo tamo Itipita sinaena ámasa. Geya kada tayaamo vada geya. ");
INSERT INTO gvs_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Tuwo sabamgoyana goi Pero vala ietune ima Eroni be yau iduduwema kana. Kana ilatuwokoima, idigo kana, ‘Kotāoya, kōna! Kōna! Komi ami taiyuwokova semiyao Isileli tubunao liliudi taiyao kōna! Yau guna bodao taiyao kokalavēma go, kōna kosakulūlu Yauwe yaina nakae boi kokawanoi makimaki. ");
INSERT INTO gvs_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Imi yoguyoguyao liliudi nakae konavēdi nakae boi kokawanoi makimaki. E woilīmi kotaoyāmo kōna! Go mainao Yaubada yoina goi yau nakae kokaipakuyēgu.’ ");
INSERT INTO gvs_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Da Itipita sivatuwowonema kadi, ‘Woilīmi! Ima kasa kokalāve, kosowōduwo kōna!’ Idi nuwonúwana kadi, ‘Neta ame tomotayadi sikaaiyaka yaida, kita kaamasida!’ ");
INSERT INTO gvs_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","E tuwo moitamo kai Isileli tubunaoyama mainao ama parawa ma nokoidi kakabidi go, parawayana ma kanaapoivina nava isti geya, unana woilima kana, tauna parawayana geya ibibineta. Parawa ma nokoidiyadi areko sinaena goi kautubedi kakavaledi kanavedi. ");
INSERT INTO gvs_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ego tauyadi siguinuwe nakae boi alatuwokoidi. Tuwo sina da Itipita yaidi siriba, goura be nakae kwama manudi sitalagogoda. ");
INSERT INTO gvs_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","E kina go Yauwe anuwóiya goi da Itipita nuwodi igudalidi, e yaidi goi ina tomotayadi anuwóiya sibabane, tuwo da Itipita konadi liliudi sitalagogodedi. ");
INSERT INTO gvs_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","E kai Isileli tubunao katáoya, asa Ramasesi goi kasowóduwo, kaketoiya kana asa Sukota. Koroto ama badabada moe 600,000 go, vevina be nakae gogómana geya adi katuyaivamo. ");
INSERT INTO gvs_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ego maniyedi ituli ta bodao nakae sisakurikuriyema taiyao kana. Yoguyogu badabadaidi kanavedi: Bulumakau, sipi be goti. ");
INSERT INTO gvs_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ego ima ketoiya goi parawayana Itipita goi kaanavedi kakabidi kagabudi moe ima beredi pokaka kaodugudi. Boi parawayana geya ana isitimo. Bogina kuyagoi. Da Itipita sivatapiyema kana, tauna geya itoboinemeta kakaimúmuna bego isti ima parawa goi kapopoli be nakae ama kinare ima ketoiya manuna kakatubayasidoko. ");
INSERT INTO gvs_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","E kai Isileli tubunao ima tuta Itipita goi bogina kakaiyaka moe tala ana badabada 430. ");
INSERT INTO gvs_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Tala 430 ana maliyalina ana kaba lukavava goi Yauwe ina bodao madabokiima Itipita goi kasowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ego amo sabamgoyana goi Yauwe imatakaavatema, e Itipita goi imema, tauna liliuma itoboinema sabamgoyana tala tamo tamo goi kakimasabe Yauwe umana be kanuwokavate manakaena imatakavatema malamalágata ame be nakae malamalágata simamaima yaidi nakae. ");
INSERT INTO gvs_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","E Yauwe Eroni be yau ilatuwokoima idigo kana, ‘Ame Basitáwana Aikanina ana lovina: Kidi ogaoga liliudi Aikayana taabu sikakāika. ");
INSERT INTO gvs_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Go imi pakonayao boi kogimonedi komedi, neta sakavaidi sikupoidi, e itoboinedi sikáika. ");
INSERT INTO gvs_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tomalatonikasa yaimi sikaaiyaka be nakae topaisewa koeemaisidi, taabu sikakāika. ");
INSERT INTO gvs_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Vada tayamo sinaena goi Basitáwana Aikanina ana yoguyogu tayamo kovaipōlu kokāika. Yoguyoguyana iwoina taabu kokavalaaoduwēdi moetala goi. Luluna taabu kokiguuyalīdi, govila bei tomota sakavaina geya ana kupwanamo íwaya ibabane ikáika. ");
INSERT INTO gvs_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Go Isileli ina bodao madabokiimi lovinayana kokabiikaōne. ");
INSERT INTO gvs_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Neta tomalatonikasa mana bodao simalatonikasa yaimi go, latuwodi Basitáwana Aikanina sikáika Yau Yauwe umagu, e mainao koroto liliudi yaidi goi sakavaidi sikupōidi namliyeta baige sisiukōimi bei sikáika. Moeko goi adi kaigigita sibíbina komi Isileli tubunao nakae. Go avatau neta sakavaina geya ikupoeta, e taabu ikakāika. ");
INSERT INTO gvs_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Lovina tayamo ikaaiyaka komi Isileli tubunao manumi be nakae tomalatonikasa yaimi goi manudi. Lovinayana ame nakae: Avatau neta sakavaina geya ana kupwanamo, geya ikaiketa.’ ");
INSERT INTO gvs_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tauna nakae Yauwe ilatuwokoima. Tuwo moitamo Isileli tubunao liliudi siguinuwe nakae kaga liliuna bogina Eroni be yau ilatuwokoima. ");
INSERT INTO gvs_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Amo maliyalinayana goi Yauwe ikabima, Itipita goi imema, badabadaaima dala dala goi kaketoiya. ");
INSERT INTO gvs_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","‘Botomoya koroto liliudi kukimasabēdi yau umagu. Tomota idi botomoyayao liliudi be yoguyogu idi botomoyayao liliudi moe yau guna kaba lovina.’ ");
INSERT INTO gvs_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","E ana tomotayadi alatuwokoidi adigo kagu, ‘Maliyalina ame tanuwokavāte. Ame Itipita goi tasowóduwo. Boi komi da Itipita idi pakonayao go, ame ataligeimi. Moitamo. Yauwe ina togaga goi ikabida Itipita goi imeda. Ame maliyalinayana goi beredi mana isti taabu takakāika. ");
INSERT INTO gvs_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ame tuta tukówana Abib goi Itipita bei takalave. ");
INSERT INTO gvs_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","E Yauwe bei inaveda kidi Kenani tubunao, Eta tubunao, Emori tubunao, Ivai tubunao be nakae Iyebusi tubunao idi poyapoya goi. Boi tubudao yaidi Yauwe ikatotule bego ivinidi. Poyapoyayana maaliina be lobooinina. E tutayana inaveda tana poyapoyayana goi, tala tamo tamo tukówana ame Abib goi ame tapwaroro ana sinapuyana taguuinūwe. ");
INSERT INTO gvs_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sinapuyana ame nakae: Maliyalina ana badabada ainima aiyuwo goi beredi pokaka takakāika go, maliyalina ainima aiyuwoina goi uyáwana aikanina taodūgu Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Beredi pokaka maliyalina ainima aiyuwo goi takakāika. Taabu beredi mana isti yaida goi ikaaiyāka, e nakae ida kaba lovina goi isti geya. ");
INSERT INTO gvs_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Amo tutayana natudao koroto talatuwokoidi kada, “Ame sinapuyana takabikaone unana boi Yauwe ina vaita goi kai Itipita goi kasowóduwo.” ");
INSERT INTO gvs_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ame sinapuyana aba kinana tayamo o aba nuwokavata tayamo yaida nimada goi o dabada goi tasiko bego Yauwe ina Katukeda sopada goi ikaaiyaka. Aba nuwokavatayana pasina Yauwe nimana toogagaina goi ikabida be Itipita goi imeda bei konuwokavāte. ");
INSERT INTO gvs_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tauna tala tamo tamo ame lovinayana takabikaonevatāe. ");
INSERT INTO gvs_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","E Yauwe bei inaveda Kenani tubunao idi poyapoya goi nakae boi ikatótula kita be nakae tubudao yaida. Tutayana poyapoyayana ivinida, ");
INSERT INTO gvs_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ida botomoyayao koroto liliudi be nakae ida yoguyoguyao idi botomoyayao bolamo liliudi bei takimasabēdi Yauwe umana. Botomoyayadi moe Yauwe ina kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","E ida ase adi botomoyayao bolamo lami ana kasala goi tatatetēdi go, neta geya tatatetedita, e nukotodi takiguyalīdi. Go ida botomoyayao koroto, e liliudi tatatetēdi. ");
INSERT INTO gvs_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","E tutayana natudao silumadadeda kadi, “Moe sinapuyana kaga ana yagoina?” e kita kada, “Boi Itipita goi kai da Itipita idi pakonayao go, Yauwe ina togaga gagaina goi ikabima, Itipita goi imema. ");
INSERT INTO gvs_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","E boi Itipita goi Pero dabana ikasa, tauna geya italigeimeta bei kasowóduwo, tauna Yauwe ima da Itipita idi botomoyayao koroto be yoguyogu bolamo ikaumatedi. Moe pasina kita ida yoguyoguyao bolamo liliudi takasaledi Yauwe yaina go, ida botomoyayao koroto tatatetedi.” ");
INSERT INTO gvs_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ame aba kinana yaida nimada o dabada goi tasikosiko bego tanuwokavate Yauwe manakaena nimana toogagaina goi ikabida, Itipita goi imeda.’ ");
INSERT INTO gvs_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","E tutayana tomotayama kina Pero italigeima, e Yaubada ivakedema kana go, geya da Palisiti idi kenao goi geya. Ame yomana go, ina nuwonúwana kana, ‘Govila bei yaviya sibabane, e simatoita. Novala bei nuwodi sikatuvilavila go, sikaluvila sina Itipita.’ ");
INSERT INTO gvs_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tuwo ivakedema kana enao yoyowo goi kavanibisi kana Négwasa Kayakayaina goi. E mama katubayasi yaviya manuna Itipita goi kasowóduwo katukotuko. ");
INSERT INTO gvs_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","E yau ana Iyosepa luluna akabi anave. Boi Iyosepa Isileli natunao ilatuwokoidi kana, ‘Moitamo Yaubada bei iwo ivaitemi go, ame tuta kokatōtula yaigu bego tutayana Yaubada ikabimi, e lulugu kokabidi konavedi Kenani goi kovaliwogedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","E tuwo Sukota goi katáoya, kana Etam goi katunagu. Moe yoyowo kikina. ");
INSERT INTO gvs_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","E kina go Yauweyana ivakumgooiyema enao ivakedema. Maliyalina goi Tauyana gaota taaoyaina sinaena ivakedema. Go sabamgo goi Tauyana yeu sabeninimina taaoyaina sinaena ivakedema bei imavadema, e bei itoboinema maliyalina be sabamgo kaaketoiya. ");
INSERT INTO gvs_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Gaota taoyainayana maliyalina goi, e yeu taoyainayana sabamgo goi, aiyuwokova geya sikalavemeta. ");
INSERT INTO gvs_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","‘Kūna Isileli tubunao kulatuwokōidi sikaluvila sina Pi Akirota kikina goi situnagu. Moe asa Migadoli be Négwasa Kayakayaina nauyayanaidi go, asa Baala Saponi kikina. E Negwasayana kikina kotunāgu. ");
INSERT INTO gvs_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Latuwogu Pero igitemi, bei inuwonúwana kana, “Nakona kidi Isileli tubunao nukotodi siwówana, tuwo enao sivasulaigi, e yoyowo goi siketoiya besobeso unana aba siya geya siyagoiyeta, tauna yoyowo ikalibodedi nakae.” ");
INSERT INTO gvs_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Pero dabana bei akaukase. Tuwo tauyana mana tovayaviyayao bei sivatapiyemi bego siyoisimi. Moeko goi tauyadi goi guna togaga ana káeyana bei avagitakoe, e da Itipita bei siyagoidokoigu Yau Yauwe.’ Tuwo moitamo ana alatuwokoidi, e nakae kaguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","E da Itipita adi tolovina inove bego tomotayadi bogina sisiya. Tuwo mana topaisewayao nuwodi sikatuvilavila tomotayadi manudi, e sidigo kadi, ‘Ame kaga taguinuwe? Bego ida pakonayao Isileli tubunao tataligeidi sisiya!’ ");
INSERT INTO gvs_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tuwo ina sariyota ikatubayasi. Ikatubayasi ikavava, ina tovayaviyayao ikabidi ");
INSERT INTO gvs_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","be nakae ina sariyota liliudi madi tovakumgoyao Itipita goi ikabidi go, sariyota maniyedi lokooinidi adi badabada nakae 600. ");
INSERT INTO gvs_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","E Yauwe Pero, tauyana da Itipita adi tolovina, dabana ikaukase. Tuwo tauyana mana tovayaviyayao sima kai Isileli tubunao sivatapiyema bego siyoisima. E kai go Isileli tubunao mama katepatu Itipita goi kasowóduwo kanonoina. ");
INSERT INTO gvs_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Sivatapiyema, Pero ina osiyao madi tokabikunuwoyao be ina sariyota madi tokabikunuwoyao be nakae ina tovayaviyayao taiyao sima, e ima tunagu goi sivalabelabena. Tunaguyadi moe Négwasa Kayakayaina kikina be nakae asa Pi Akirota be Baala Saponi kikidi. ");
INSERT INTO gvs_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","E kina go Pero mana bodao sima kai Isileli tubunao ima tunagu goi. Bogina sivakakana sima go, Isileli tubunaoyadi sikandobala da Itipita sigitedi simamaima kadi, ‘Oiyoi! Da Itipita simamaima bei siyoisida!’ Simatoita gagaina, tuwo Yauwe situmadade. ");
INSERT INTO gvs_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Go yau silatuwokoigu sidigo kadi, ‘Manakae? Nakona Itipita goi valiwoga tabee geya ae? Tauna kumema ameko yoyowo goi bego kakámasa sivaliwogema ae? Kaga unana Itipita goi kwabima kumema! ");
INSERT INTO gvs_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Boi Itipita goi nakae kalatuwokoim kadigo kama, “Kwalavēma ameko goi bei kai da Itipita idi pakonayao kapaisewa manudi.” Neta kai tauyadi idi pakonayao moe dedevina yaima namliyeta ameko yoyowo goi kakamasa beso!’ ");
INSERT INTO gvs_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","E yau adigo kagu, ‘Taabu koomatōita! Kotaoyakavāta bei ame Yauwe ina yava kogite iguinuwe manuda. Moitamo. Da Itipita ame tuta koogitedi geya tuwaina bei kogitemneidi. ");
INSERT INTO gvs_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","E kina Yauwe bei ivayaviya manuda go, komi omi inuwāmo.’ ");
INSERT INTO gvs_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","E Yauwe ilatuwokoigu idigo kana, ‘Kaga kutumadadekoigu? Isileli tubunao kulatuwokōidi to siketoiyamo sina. ");
INSERT INTO gvs_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Go kom im kaituko kuyosāle Négwasa Kayakayaina yatanaina goi gobe negwasayana kukiwotāi aiyuwo, e bei kom nakae Isileli tubunao itoboinemi poyapoya sayasayaina goi kovadamane kona. ");
INSERT INTO gvs_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Go Yau sem da Itipita idi dabakasa bei avaituwe, e bei mlimi goi siiwo bego sivatapiyemi. Go Pero mana tovayaviyayao, ina sariyota madi tokabikunuwoyao be ina tovayaviyayao ma osidi adi sou goi yau guna togaga ana káeyana bei avagitakoe. ");
INSERT INTO gvs_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tutayana Yau guna kaeyanayana avagitakoe, e da Itipita bei siyagoidokoigu bego Yau Yauwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","E Yaubada ina anerose kai Isileli tubunao ima tunagu goi ivakumgooiyema itáoya iyava ina mlima goi iitáoya. E gaota taaoyaina ivakumgooiyema itáoya nakae iyava ina mlima goi iitáoya. ");
INSERT INTO gvs_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Tuwo gaotayana ikaaiyaka da Itipita be kai Isileli tubunao ima tunagu nauyayanaima goi. Tauna da Itipita adi dadava mamaníwana ikaaiyaka. Go kai Isileli tubunao ama dadava mavada itapasigima. Gaotayana tauna ima mavada. E bodayama aiyuwo sabamgo ana madabokina goi geya kavalobodeta unana gaota itabodema, tauna da Itipita geya itoboinedita kai Isileli tubunao siyoisima. ");
INSERT INTO gvs_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","E tuwo nimagu ayosale Négwasa Kayakayaina yatanaina goi go, Yauwe yágira bomatu tamadiidinina ietune ina negwasayana iyawoisave. Yagirayana sabamgo ana madabokina goi itowotowo, tauna negwasayana iwotai aiyuwo, e poyapoya sayasayaina isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Tuwo kai Isileli tubunao poyapoya sayasayaina goi kavadámana go, negwasayana vaboda gagaina nakae kekelima be nakae kakataima goi. ");
INSERT INTO gvs_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ago kidi da Itipita sitáoya kai Isileli tubunao sivatapiyema bego siyoisima. Sivataapiyema, e Pero ina osiyao, ina sariyota madi tokabikunuwoyao be ina osiyao adi totulagayao liliudi taiyao negwasayana goi sisiu mlima. ");
INSERT INTO gvs_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","E tomo ana sipasipa iliyabale, Yauwe yeuyana taaoyaina be nakae gaotayana taaoyaina goi ikandosobu da Itipita adi tovayaviyayao igitedi, nuwodi ikiwowonidi. ");
INSERT INTO gvs_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ikavava, ina guinuwa goi da Itipita idi sariyota aedi sivabaulidi sikasa, tauna geya itoboinedita sikaivivilo dókana. Tuwo da Itipita sigite, simatoita kadi, ‘Isileli tubunao yaidi goi tasiyamo! Tauyadi manudi kina Yauwe ivayaviyeda.’ ");
INSERT INTO gvs_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","E Yauwe ilatuwokoigu idigo kana, ‘Nimam kuyosāle Négwasa Kayakayaina yatanaina goi bei negwasayana ikaluvilamna ina da Itipita, idi sariyota madi tokabikunuwoyao be ina osiyao adi totulagayao ikautumdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tuwo moitamo nimagu ayosale Négwasa Kayakayaina yatanaina goi, e negwasayana ivatowo ikaluvilamna inonoina boi nakae. E kidi go da Itipitayadi sigite, tuwo sipoikíkina bego negwasayana goi sisiya go, Yauwe ikabidi ilavedi sisou negwasayana goi ikautumdi. E tutayana vanuwo bogina itomo dókana, negwasayana bogina boi nakae. ");
INSERT INTO gvs_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tauna nakae negwasayana ikaluvilamna ina da Itipita idi sariyota madi tokabikunuwoyao, idi osiyao adi totulagayao be nakae Pero ina tovayaviyayao liliudi ikautumdi. Geya kada tayaamo ma yawoina geya. ");
INSERT INTO gvs_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","E kai go Isileli tubunao poyapoya sayasayaina goi bogina kavadámana go, négwasa moe vaboda nakae kekelima be kakataima goi. ");
INSERT INTO gvs_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","E ame maliyalinayana goi Yauwe kai Isileli tubunao iyavema da Itipita nimadi goi. E kakandoiwo da Itipita kaamasidi kagitedi labutabuta ilavadevadedi. ");
INSERT INTO gvs_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","E kagite Yauwe manakaena ina togaga gagaina iguuinuwe da Itipita yaidi goi. Tuwo tomotayadi Yauwe simatoite go, yau Mosese Yauwe ina pákwana, Tauyana be yau sinumisema. ");
INSERT INTO gvs_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","E ame tutayana yau Isileli tubunao taiyao vesi ame kavesiye Yauwe yaina kama, ");
INSERT INTO gvs_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yauwe kina guna Tokitogaga; ");
INSERT INTO gvs_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yauwe kina tovayaviya tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Pero ina sariyota be nakae ina tovayaviyayao liliudi, ");
INSERT INTO gvs_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Négwasa dimowonina ilataoidi. ");
INSERT INTO gvs_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yauwe, ");
INSERT INTO gvs_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Im togaga ana kakainaki goi am kaleyayao kutogooisavedi. ");
INSERT INTO gvs_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kubum ipulu yawoim kusalauwe, ");
INSERT INTO gvs_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ada kaleyayao sigagágasa kadi, ");
INSERT INTO gvs_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Go Yauwe, ");
INSERT INTO gvs_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yauwe, ");
INSERT INTO gvs_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tutayana nimakakataim kuyosale, ");
INSERT INTO gvs_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Im lokata goi ");
INSERT INTO gvs_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ituli ta boda valem sinove, ");
INSERT INTO gvs_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Amo tutayana da Idom adi tolovinao ");
INSERT INTO gvs_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ame tauyadi matoita gagaina toina bei iyoisidi. Yauwe, ");
INSERT INTO gvs_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nava kai im bodao bei kumema kama toinim im koya goi kuyatoima kalokasa. Yauwe, Ame koyayana kukinave im kaba kaiyaka manuna. Tomoya, ");
INSERT INTO gvs_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Yauwe bei ikalibubuna vata!’ ");
INSERT INTO gvs_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ame vesiyana unana Pero ina osiyao nakae ina sariyota madi tokabikunuwoyao be ina tovayaviyayao sipoikíkina bego négwasa nauyayanaina goi sivadámana, e negwasayana Yauwe ikaluvilemnei da Itipita ikautumdi. E kai go Isileli tubunao kaketoiya poyapoya sayasayaina négwasa nauyayanaina goi. ");
INSERT INTO gvs_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","E Eroni be yau niuma Miriyam, tauyana Yaubada ina tokabivalavala tayamo, girada ikabi ilauláuwo go, vevina liliudi mlina goi madi girada silauláusa. ");
INSERT INTO gvs_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E Miriyamyana vesi ame ivesiye yaidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","E Isileli tubunao alatuwokoidi katáoya Négwasa Kayakayaina kakalave kana Sura yoyowoina goi. Amoko goi kaaketoiya nakae maliyalina aito go, geya tayaamo bwae kababane. ");
INSERT INTO gvs_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Tuwo kaketoiya kama asa Mara goi bwae kababane go, geya itoboinemeta kanim. Bwaeyana itamatama. Moe pasina asayana kaduduwe Mara. ");
INSERT INTO gvs_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tuwo tomota liliudi sikaukulukúluwo yau yaigu sidigo kadi, ‘Bei kaga kanim?’ ");
INSERT INTO gvs_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Sikaukulukúluwo go, atumadádana Yauwe yaina vaita manuna. Tuwo alova tayamo ivatulukoigu kana, ‘Alova gomoe kwalisobūye bwaeyana goi.’ Tuwo alovayana akabi, alave bwae goi, e bwaeyana isadibidibi. E tuwo ameko goi Yauwe vatulúkwana be lovina ivinima yawoima manuna go, ivakakonema, ");
INSERT INTO gvs_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","idigo kana, ‘Yau Yauwe imi Yaubada, ami tokidedevina. Tauna neta konovedokoigu go, kaga dedevina matagu goi koguinuwe be nakae guna lovina konovedi be guna katukeda liliudi kokabikaonedi, e vísiya liliudi boi da Itipita aavinidi geya avinimita.’ ");
INSERT INTO gvs_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ibóbwara ikavava, katáoya, Mara kakalave kana asa Elim goi. Amoko goi doelu ana badabada yawou aiyuwo be nakae deiti alovaidi 70 sikaaiyaka. Tuwo amoko bwae kikina goi katunagu. ");
INSERT INTO gvs_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","E kai Isileli tubunao madabokima katáoya, Elim kakalave, kana Sini Yoyowoina. Siniyana ikaaiyaka Elim be Sainai go, nauyayanaidi. Ame bogina tukówana tayamo ikavava be nakae maliyalina yawou ainima bogina sikavava ima sowóduwo Itipita goi mlina. ");
INSERT INTO gvs_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","E Sini yoyowoina goi kakaaiyaka go, aiyuwoina Isileli tubunao madabokidi sikaukulukuluwomna Eroni be yau yaima awoinu pasina, ");
INSERT INTO gvs_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","sidigo kadi, ‘Neta boi Itipita goi Yauwe nimana goi kakámasa! Amo tutayana ima kaiyaka goi anina be beredi gagaidi kakakáika gamoma! Neta amoko goi kakámasa dedevina. Moitamo. Komi komema yoyowo goi bego ame bodayama madabokima loga goi kokimatema.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","E Yauwe ilatuwokoigu idigo kana, ‘Kunōve. Yau yábana goi ami beredi bei aetunedi sisou kúwana nakae go, maliyalina tamo tamo tomotayadi sisowóduwo sina berediyadi siseoseo amo maliyalina tayamo manuna bei avakakonedi. Bei guna katukeda sikabikaone o geya? ");
INSERT INTO gvs_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Maliyalina ainima tayamoina goi tutayana sisowóduwo sina siseo, e siseo maliyalina aiyuwo manudi. Itomo moe maliyalina aba waiwasi.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","E tuwo Eroni be yau kana Isileli tubunao kalatuwokoidi kadigo kama, ‘Lavilavi goi bei koyagoi bego Yauwe kina Itipita goi ikabimi be imemi. ");
INSERT INTO gvs_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","E imi kaukulukúluwo Yauwe yaina bogina inove, tauna itomo nobuyana ana káeyana bei kogite. Bogina koyagoi. Kai bego avatauwa kokaukulukúluwo yaima? Geya!’ ");
INSERT INTO gvs_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kagu, ‘Ame bei koyagoi tutayana Yauwe lavilavi goi bei ada kanina ivinida nakae nobuyana goi ada beredi ivinida, takáika bogina gamoda. Ivinida unana imi kaukulukúluwo Tauyana yaina bogina inove. Kai bego avatauwa kokaukulukúluwo yaima? Geya! Moe bego Yauwe yaina kokaukulukúluwo.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Tuwo yau siyagu Eroni alatuwoko adigo kagu, ‘Isileli tubunao madabokiidi kulatuwokōidi kam, “Kōma Yauwe matana goi. Imi kaukulukúluwo bogina inove.”’ ");
INSERT INTO gvs_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","E tuwo moitamo Eroni ina Isileli tubunao madabokidi ilatuuwokoidi go, tauyadi sikandobala yoyowo goi Yauwe ana káeyana tomoéyala nakae sigite gaota sinaena goi isowóduwo, e sigite sikaliwoisa kadi, ‘Iyaa!’ ");
INSERT INTO gvs_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","‘Isileli tubunao idi kaukulukúluwo bogina anove. Tuwo kulatuwokōidi kudīgo kam, “Lavilavi goi anina bei kokakāika go, nobuyana goi beredi kokakāika gamomi. Moeko goi bei koyagoidokoigu bego Yau Yauwe imi Yaubada.”’ ");
INSERT INTO gvs_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","E asa bogina lavilavi, koroita siyova sima ima tunagu sivakayaodei, e kakabidi avama. Go asa itomo, númla sigugumina ikaiyaka ima tunagu ana madabokina goi. ");
INSERT INTO gvs_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tutayana sigugumayana iyápasa, poyapoya yatana tayamo dogoi yatana katuvaapopoina be kakaaraiina toina ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","E Isileli tubunao sigite, sediyao silatuwokoidi sidigo kadi, ‘Amo kaga?’ Bogina koyagoi. Dogoiyana geya siyagoiyeta. Tuwo yau alatuwokoidi adigo kagu, ‘Amo ada beredi Yauwe ivinida. ");
INSERT INTO gvs_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ame nakae Yauwe ilovina, idigo kana, “Tomota tamo tamo kōna kosēo nakae itoboinemi kokáika go, paseku tamo tamo kododōidi, avami nakae imi bodao imi yoyou goi avadi.”’ ");
INSERT INTO gvs_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","E moitamo nakae kaguinuwe. Maniyedi kidi siseo tupwana ibadabada go, maniyedi sivakakayuwomo. ");
INSERT INTO gvs_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","E sima idi paseku goi sivadodoidi sigitedi. Avatau neta iseo badabada, ikanisave, geya tayaamo ikesa. Go avatau neta ivakakayuwomo, e nakae ikáika gamona. Tauna tomota liliudi siseo nakae yoiyadi sikáika. ");
INSERT INTO gvs_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","E alatuwokoidi adigo kagu, ‘Geya vatau tayaamo maniyedi iyatōidi itomo manuna.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Go kidi sopagu geya sikabikaoneyeta. Maniyedi siyatoidi bego itomo manuna go, niga itomo nobuyana berediyadi goi motemoteta sisowóduwo be nakae sibówana. Tuwo agitedi, gamogu igoyo. ");
INSERT INTO gvs_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Nobuyana tamo tamo kana kaseoseo yoiyama nakae kaga itoboinema kakáika. Go níyala ituko, berediyadi ivaedi, e poyapoya goi sisewaya kówasa. ");
INSERT INTO gvs_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","E maliyalina ainima tayamoina goi tomota tamo tamo sina sivayuwo siseoko maliyalina aiyuwo manudi, idi paseku tamo tamo goi sivadodoidi. Ikavava, Isileli tubunao adi tomoyamoya liliudi sigite sitainasi, e maniyedi madi kaukulukúluwo sima yaigu sitalavaita tomota idi seo maliyalina aiyuwo manudi. ");
INSERT INTO gvs_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Go yau kagu, ‘Geya. Yauwe ilatuwokoida ame nakae: Itomo moe maliyalina aba waiwasi go, aba waiwasiyana moe kimaasabaina Yauwe umana. Kaga latuwomi kokaigabu, ame kokaigābu. Kaga latuwomi kovaipolu, ame kovaipōlu, e kokāika go, kaga ikesa koyāto avami itomo manuna.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Tuwo sikáika gamodi go, kaga sikesa, siyatoidi itomo manuna nakae alatuwokoidi. Go vanuwo itomo, berediyadi sigitedi, geya sibowoneta be nakae sinaena motemoteta geya sisowoduwoita. ");
INSERT INTO gvs_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","E tuwo alatuwokoidi adigo kagu, ‘Ame tuta imi kuleya kokāika. Maliyalina ame moe maliyalina aba waiwasi Yauwe umana. Ame neta kōna moteo goi bego latuwomi beredi koseo, e geya kada tayaamo bei kobabane geya. ");
INSERT INTO gvs_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Maliyalina ana badabada ainima tayamo goi kōna imi beredi koseosēo go, maliyalina ainima aiyuwoina moe aba waiwasi, beredi geya.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","E maliyalina ainima aiyuwoina goi tomota maniyedi sina bego siseo go, sinonoina geya kada tayaamo sibabane geya. ");
INSERT INTO gvs_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","E Yauwe ilatuwokoigu idigo kana, ‘Tomotayadi kulatuwokōidi kudīgo kam, “Sivavina Yauwe ina lovina nakae ina vatulúkwana bei kokapipilavekoidi? ");
INSERT INTO gvs_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Konuwāisi bego maliyalina aba waiwasi Yauwe ivinimi. Ame pasina maliyalina ainima tayamoina goi ami beredi iivinimi moe maliyalina aiyuwo manudi. Tuwo maliyalina ainima aiyuwoina goi omi inuwa. Geya vatau tayaamo ina yoyou goi isowóduwo ina iseo.”’ ");
INSERT INTO gvs_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tuwo maliyalina ainima aiyuwoinayana idi paisewa goi siwaiwasi. ");
INSERT INTO gvs_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","E berediyadi kidi Isileli tubunao sivayou yoina mana. Manayana kutukutu giyaidi nakae go, poowouna. Beredi kakaaraiina nakae go, ana káika mokava nakae. ");
INSERT INTO gvs_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","E yau alatuwokoidi adigo kagu, ‘Ame Yauwe ilovina, idigo kana, “Beredi kosēo paseku tayamo goi kovadodōi, koyāto ikaiyaka, e bei nava tubumiyao itoboinedi sigite ava beredi goi boi avakanimi yoyowo sinaena tutayana Itipita goi akabimi, amemi.”’ ");
INSERT INTO gvs_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Tuwo siyagu Eroni alatuwoko adigo kagu, ‘Mana ma pasekuna kwābi, manayana botori goi kuvadodōi. Ikavava, Yauwe matana goi kuyāto, e bei ikaiyaka tubudao manudi.’ ");
INSERT INTO gvs_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Tuwo moitamo Eroni ina mana ma pasekuna ikabi, botori goi ivadodoi. E niga tutayana aba vatulúkwana siwodugu ikavava, sinaena goi botoriyana idodoi nakae Yauwe ilatuwokoigu. ");
INSERT INTO gvs_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","E kidi go Isileli tubunao tala ana badabada 40 mana sikakáika. Sikakáika ana kadókana sina poyapoya dedevina, moe asa Kenani ana túwana. ");
INSERT INTO gvs_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Paseku yawou moe nakae bayao tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","E kai Isileli tubunao liliuma katáoya Sini Yoyowoina kakalave, kaketoiya nakae Yauwe ilatuwokoima. Kakanaliya kana asa Rapidim goi katunagu. Ego amoko goi bwae geya. ");
INSERT INTO gvs_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tuwo tomotayadi sikaumakimaki yaigu, sidigo kadi, ‘Bwae kuvanīmma!’ Go yau adigo kagu, ‘Kaga unana kokaumakimaki yau yaigu? Kaga unana Yauwe kovakakone? Nakona Yauwe geya konumiseyeta!’ ");
INSERT INTO gvs_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Go kidi maedi siyápasa toina, e sikaukulukúluwo yaigu sidigo kadi, ‘Ame manakae Itipita goi kumema? Bego natumao be ima yoguyoguyao taiyao maema adi yápasa goi kukimatema?’ ");
INSERT INTO gvs_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","E atumadádana Yauwe yaina adigo kagu, ‘Ame tomotayadi bei manakaegu avekoidi? Giyakainava bei gurewa goi sikaumategu.’ ");
INSERT INTO gvs_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yauwe idigo kana, ‘Im kaituko boi sákala Nairi kusapisapi kwābi, e nakae tomoyamoya Isileli tubunao yaidi goi kukinavēdi kwabīdi taiyao kōna tomota liliudi matadi goi. ");
INSERT INTO gvs_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kunōve. Yau bei matam goi aatáoya, amoko gurewa yatana Koya Korevi goi. E gurewayana kulāui, e bwae bei idau go, tomotayadi itoboinedi sinim.’ Tuwo nakae aguinuwe. Tomoyamoyayadi matadi goi atáoya, gurewayana aláui, e bwae idau. ");
INSERT INTO gvs_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Tuwo asayana avayou Mesa be Meriba unana boi Isileli tubunao sikaumakimaki be nakae Yauwe sivakakone tutayana kadi, ‘Seki Yauwe ikaaiyaka yaida o geya?’ Tauna you aiyuwo avini. ");
INSERT INTO gvs_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","E Amaleki tubunao sima Rapidim goi Isileli tubunao taiyao sivayaviya. ");
INSERT INTO gvs_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","E tuwo Iyosuwa alatuwoko adigo kagu, ‘Kūna koroto kukinavēdi yaviya manuna. Ikavava, itomo taiyao kōna Amaleki tubunao taiyao kovayavīya. Yau bei koya yatana goi aatáoya go, Yaubada ina kaituko nimagu goi ayoyoisi.’ ");
INSERT INTO gvs_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tuwo Iyosuwa iguinuwa kaga nakae bogina adige. Korotoyadi taiyao sina sivayaviya Amaleki tubunao yaidi. Kai go Eroni, Ure be yau katuko kana koya yatana. ");
INSERT INTO gvs_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Tutayana nimagu akatulagasidi, e Isileli tubunao sitogaga go, neta nimagu akatusobuyedi, e kidi Amaleki tubunao sitogaga. ");
INSERT INTO gvs_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","E nimagu bogina sineneta, tuwo Eroni be Ure sina gurewa gagaina sipuli sime siyato guna kaba tusobu. Tuwo yatana atusobu go, tauyadi nimagu sikatulagasidi sikalipaiwolidi, tayamo dadavina, tayamo dadavina. Tauna nimagu sikasa ana kadókana níyala isaliu. ");
INSERT INTO gvs_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tuwo Iyosuwa mana tovayaviyayao sitogaga, e Amaleki tubunao sisi goi sivasobusobuyedi. ");
INSERT INTO gvs_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","E yaviya ikavava, Yauwe ilatuwokoigu idigo kana, ‘Buki goi livala ame kugīni namliyeta kwatuyāivi bei Iyosuwa inove. Livalayana ame nakae: Amaleki tubunao valedi bei poyapoya ame goi atauwedoko.’ ");
INSERT INTO gvs_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Tuwo dídiya akaudakodako aba kasala manuna go, aba kasalayana avayou Yauwe Guna Bísala. ");
INSERT INTO gvs_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Adigo kagu, ‘Yauwe ina bísala takatulagāsi! Tauyana bei ivayaviya vata Amaleki tubunao yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","E yaogu Iyetoro, tauyana da Midiyani adi Tonúwala, Yaubada valena inove. Valayana ame nakae: Kaga liliuna Yauwe Yaubada iguinuwe kai ina bodao, yau be nakae Isileli tubunao liliuma manuma tutayana Isileli tubunao Itipita goi ikabima imema. ");
INSERT INTO gvs_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Yau boi monegu Sipora ma natunao aetuneviledi sina Midiyani bego yaogu Iyetoro taiyao sikaiyaka. E Iyetoroyana itáoya, monegu nakae natumao adi taiyuwo ikabidi, ");
INSERT INTO gvs_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","taiyao sima yaigu goi. Natugu tayamo yoina Gerasom. Boi kagu, ‘Yau tomalatonikasa ituli ta kasa goi.’ Tauna yoina avayou Gerasom. ");
INSERT INTO gvs_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Natugu aiyuwoina yoina Eliyesa. Boi kagu, ‘Tamagu ina Yaubada guna tovaita. Pero nimana goi bogina iyavegu.’ Tauna gomanayana avayou Eliyesa. ");
INSERT INTO gvs_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","6","Yau guna tunagu Yaubada ina koya kikina yoyowo goi akaaiyaka go, yaogu Iyetoro livala ietune ima kana, ‘Yau yaom Iyetoro monem ma natunao taiyao bei kao kavadadem.’ E tutayana sima, ");
INSERT INTO gvs_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","yau ana yaoguyana avalobode. Asowóduwo tauyana yaina avatugúyala akanakabobo yaina namliyeta atáoya ayowoi. Ikavava, kagu, ‘Manakae? Dedevim?’ ‘Dedevigu. Go kom?’ tauyana kaena. ‘Yau nakae dedevigu’, kaegu. E kakauyagu ikavava, kana guna yoyou goi kasiu. ");
INSERT INTO gvs_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Yaogu alituwoko kaga liliuna boi Yauwe bogina iguinuwedi Pero be nakae da Itipita yaidi Isileli tubunao manudi. Nakae alatuwoko Isileli tubunao mou liliuna idi ketoiya goi sibabanedi go, Yauwe manakaena iyavedi. ");
INSERT INTO gvs_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","E yaogu Iyetoro iuyáwana tutayana inove kaga liliuna dedevina Yauwe iguinuwe kai Isileli tubunao manuma. Nakae manakaena da Itipita nimadi goi iyavema. ");
INSERT INTO gvs_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Tuwo idigo kana, ‘Yauwe tayapalīye! Tauyana da Itipita nimadi be nakae Pero nimana goi iyavemi. ");
INSERT INTO gvs_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ame tuta bogina ayagoi bego Yauwe kina basaleliuyao liliudi itogagasavedi. Moe moitamo. Dogoiyadi liliudi manudi sigagágasa Yauwe itogagasavedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","E tuwo yaogu yoguyogu ikabi igabu ivakasave go, ikasale Yaubada yaina. Aiyuwoina yoguyogu maniyedi vininabeso manuna ikasaledi Yauwe yaina. Ikavava, áika siguinuwe go, Eroni be nakae Isileli tubunao idi tomoyamoya liliudi taiyao sima, e Iyetoroyana taiyao Yaubada matana goi kakáika. ");
INSERT INTO gvs_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","E vanuwo itomo ana atusobu tomota idi wowókana atakínona. E tomotayadi nobuyana ina lavilavi goi simamaima yau yaigu takínona manuna. ");
INSERT INTO gvs_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Go Iyetoro kaga liliuna aguuinuwe tomota manudi igitegite, tuwo idigo kana, ‘Ame kaga kuguuinuwe tomota manudi? Kaga unana kom amta kutakínona go, tomota adi takínona manuna situyáwata nobuyana go, ina lavilavi?’ ");
INSERT INTO gvs_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Tuwo adigo kagu, ‘Unana go tomota toinidi sima yau yaigu bei Yaubada ina nuwonúwana siyagoi. ");
INSERT INTO gvs_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Neta tayamo mou isowóduwo, bei sima yaigu, e yau atakínona avatau moitamo be nakae Yauwe ina lovina be ina katukeda avatulukoidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Go yaoguyana idigo kana, ‘Moe sinapuyana kuguuinuwe geya idedevineta. ");
INSERT INTO gvs_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tuta giyaina moe paisewayana bei ilausim be nakae tomotayadi ilausidi. Bogina kuyagoi. Paisewayana moumou isaki yaim. Kom amta geya itoboinemta. ");
INSERT INTO gvs_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tauna kunovēgu go, alatuwokoim kaga bei kuguinuwe. Neta sopagu kukabikaone, e Yaubada bei ivakitaum nakae ivaitem. Kom bei tomota adi katumapu nakae Yaubada yaina, tauna adi mou kumēdi Yaubada matana goi. ");
INSERT INTO gvs_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Yaubada ina lovina be ina katukeda kuvatulukodokōidi. Kuvatulukōidi nako enao dedevina be kaga nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Go kom sem tomota liliudi yaidi goi koroto idi sinapu dedevina kukinavedokōidi ame nakae: Neta Yaubada sitaaimamine be nakae kidi aba numisa, nakae taabu siitagōna toogoyoidi idi goyo manuna sitakonedi, e moe tauyadi kuvayokōidi kidi totakínona nakae koroto 1,000 adi totakínona, tayamo koroto 100 adi totakínona, tayamo koroto 50 adi totakínona, e koroto tayamo yawou adi totakínona. ");
INSERT INTO gvs_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Tauyadi kutagonēdi tuta liliuna tomota adi mou sitakinoidi go, mou gagaidi neta sisowóduwo, e madabokidi sivinim bei kom kutakínona. Go mou giyaidi, tuwo liliudi toinidi sitakinoidi, e bei yaim ikakapu nakae paisewayana goi sivaitem. ");
INSERT INTO gvs_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Neta moe nakae kuguinuwe be nakae Yaubada ilatuwokoim kuguinuwe, bei itoboinem kutogaga go, ame tomotayadi liliudi itoboinedi madi tuboina sikaluvila sina idi yoyou.’ ");
INSERT INTO gvs_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","E tuwo moitamo yaogu sopana akabikaone, e kaga liliuna ilatuuwokoigu nakae aguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Isileli tubunao liliudi yaidi goi koroto idi sinapu dedevidi akinavedi go, avayokoidi kidi tomota adi totakínona, 1,000 be 100 be 50 be nakae yawou yaidi. ");
INSERT INTO gvs_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Tuta liliuna amo tauyadi tomota adi mou sitakinoidi. Neta mou gagaidi sisowóduwo, simedi yau atakinoidi go, mou giyaidi toinidi sitakinoidi. ");
INSERT INTO gvs_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","E yaogu avaduduwe. Ikavava, tauyana ikaluvila ina toinina ina kasa. ");
INSERT INTO gvs_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","E kai Isileli tubunao katáoya, asa Rapidim kakalave kana Sainai yoyowoina. Kasiu kana Yaubada ina koya goi, e koyayana kikina katunagu. Moe bogina tukówana aito ima sowóduwo Itipita goi mlina. ");
INSERT INTO gvs_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","E koyayana atuko ana Yauwe Yaubada yaina. Tauyana koya yatana goi itumasobu yaigu idigo kana, ‘Yakobo ina bodao, moe Isileli tubunao, kulatuwokōidi ame nakae, ");
INSERT INTO gvs_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","kudīgo kam, “Boi toinimi matami goi bogina kogitegu kaga liliuna aguinuwedi da Itipita yaidi nakae manakaegu akavalemi amemi yaigu nakae bóibo panepanena goi natunao ikavaledi. ");
INSERT INTO gvs_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ame tuta neta moitamo niyagu konove be nakae guna kanasíuna yaimi bei aguuinuwe koyoisikavate, e komi moitamo toinigu guna kitomyao boda liliudi yaidi. Poyapoya ana madabokina moe guna kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","E komi sem akinavemi koeboda tayamo bei komi guna togudalayao be nakae boda kimaasabaimi umagu.” Tauna nakae Isileli tubunao kulatuwokōidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","E tuwo asou ana Isileli tubunao adi tomoyamoya aduduwedi sima kaga liliuna Yauwe bogina ilatuwokoigu, e alatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","E tomota liliudi taiyao sidigo kadi, ‘Kaga liliuna Yauwe iidigedi nakae bei kaguinuwedi.’ E tuwo akalavedi go, ana koyayana goi atuko ana Yauwe yaina idi livala atalavaitedi. ");
INSERT INTO gvs_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","E Tauyana idigo kana, ‘Kunōve. Yau bei gaota kalaabadaina sinaena goi ao, e bei tomotayadi itoboinedi sinovegu tutayana avadigoim go, kom bei sinumisevataem.’ Tuwo asou ana tomotayadi kaga liliuna Yauwe ilatuuwokoigu, nakae alatuwokoidi. Tomotayadi kadi, ‘Kaga liliuna Yauwe iidigedi nakae bei kaguinuwedi.’ Tuwo akalavedi atukomna ana Yauwe yaina tomotayadi idi livala atalavaitedi. ");
INSERT INTO gvs_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","E Yauwe idigo kana, ‘Kusōu kūna tomotayadi ame be itomo kukimasabēdi guna sowóduwo manuna go, adi kwama nakae sinikīdi. ");
INSERT INTO gvs_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Maliyalina aitonina goi bogina sikatubayāsi bego Yau Yauwe asou Koya Sainai tomota liliudi matadi goi. ");
INSERT INTO gvs_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tomota adi túwana koya unana madabokina goi kuyāto ivaníbita go, kukatumatalīdi kudīgo kam, “Ami dodōkana! Taabu koyayana kotukotūko be nakae taabu tuwanayana kobiisikōne. Avatau neta ibisikone, tauyana kokaumāte. ");
INSERT INTO gvs_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Taabu kobiisikōne. Avatau neta ibisikone, tauyana gurewa goi kokaumāte o sau goi koginubāsi. Neta yoguyogu o tomota, bei ikámasa.” Nakae kulatuwokōidi go, tutayana síula niyana maanawena sinove, bei sima koyayana goi.’ ");
INSERT INTO gvs_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","E tuwo koya goi asou ana tomotayadi akimasabedi, e adi kwama sinikidi. ");
INSERT INTO gvs_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ikavava, alatuwokoidi adigo kagu, ‘Kokatubayasīmi maliyalina aitonina manuna. Komi koroto, taabu vevina kobisiikonēdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","E maliyalina aitonina bogina ima go, nobuyana koya goi palapala idududu be nakae ávila ikavikávila, nakae gaota kalaabadaina ikaaiyaka. Síula niyana gagaina itáiya, e tomota liliudi idi tunagu goi sinove, tuwo madi matoita wowodi sitátava. ");
INSERT INTO gvs_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Tuwo tomotayadi idi tunagu goi amedi koya goi bego Yaubada sivalobode. Koyayana unana sitaooyakobu. ");
INSERT INTO gvs_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","E Yauwe yeu goi isou ima Koya Sainai yatana goi. Koyayana aubowo gagaina iumai ina kaiyaka pasina go, aubowoyana ituko ina nakae neta vaega siigabudi. Koyayana madabokina itátava gagaina. ");
INSERT INTO gvs_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","E síula niyana bogina ivakakana ima, e ivakaigaga toina. Yauwe aavadigo go, Tauyana niyana gagaina goi ikatumapugu; niyanayana ana taiyakeka palapala nakae. ");
INSERT INTO gvs_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","E tutayana Yauwe isou ima Koya Sainai yatana goi, iduduwegu idigo kana, ‘Kutūko kūma koya yatana.’ Tuwo atuko. ");
INSERT INTO gvs_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Atuko, e Tauyana ilatuwokoigu idigo kana, ‘Kusōu kūna tomotayadi kukatumatalīdi taabu túwana sivaadamāne, govila bei sisiu sima bego Yau Yauwe sigitegu, e badabadaidi sivailai. ");
INSERT INTO gvs_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kidi go Tonúwala nakae. Neta Yau Yauwe simekoigu, kulatuwokōidi toinidi sikimasabedi umagu, govila bei Yau Yauwe geya mgoninamo aliunedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Go yau adigo kagu, ‘Tomotayadi geya itoboinedita situko. Kom toinim bogina kukatumatalidi kam, “Túwana kuyatōidi Koya Sainai unana goi namliyeta koyayana kukimasābe umagu.” Tuwanayadi bogina ayatoidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","E Yauwe idigo kana, ‘Kusōu kūna Eroni kwābi, e taiyao kokaluvīla kōma go, tonuwalayadi be tomotayadi taabu kutaagonēdi sivadámana bego simekoigu, govila bei sisiu, e geya mgoninamo aliunedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Tuwo moitamo asou ana tomotayadi alatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","E tomotayadi Yaubada ilatuwokoidi ame nakae, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","‘Yau Yauwe imi Yaubada da Itipita idi kasa goi akalaoduwemi. Boi komi da Itipita idi pakonayao go, Yau ataligeimi. ");
INSERT INTO gvs_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tauna taabu basaleliuyao goi kokaatuvēkwana matagu goi. ");
INSERT INTO gvs_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Taabu tokwalu koomadāgi bego dogoi tayamo yábana goi o poyapoya yatana goi o négwasa sinaena goi ana tapata nakae bego imi basaleliu. ");
INSERT INTO gvs_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Basaleliuyaoyadi yaidi taabu kovaatugūyala kokanakabobo be taabu kosaakulūlu yaidi. Yau Yauwe imi Yaubada moe Tokavavágana vakookoligu. Avatau neta nakae iguinuwe moe ikaolilivegu, tauna bei aliune go, niga neta natunao be tubunao ina tapepeko sivatotowone, tauyadi nakae bei aliunedi. ");
INSERT INTO gvs_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Go avatauwa neta simatakooiyegu be nakae guna lovina sikabikaaonedi, e amo tauyadi be nakae mlidi idi bodao badabadaidi simamaima yaidi goi alokatedi. ");
INSERT INTO gvs_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Taabu Yau Yauwe imi Yaubada yoigu kokaigoyāi. Avatau neta yoigu ikaigoyai, amo tauyana bei aliune. ");
INSERT INTO gvs_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Maliyalina aba waiwasi konuwookavāte kokimasābe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Maliyalina ainima tayamo goi koopaisēwa be imi paisewa madabokidi koguuinuwēdi. ");
INSERT INTO gvs_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Go maliyalina ainima aiyuwoina moe aba waiwasi Yau Yauwe imi Yaubada umagu. Amo maliyalinayana goi taabu koopaisēwa; komi, natumiyao, imi pakonayao koroto be vevina, imi bulumakauyao be nakae tomalatonikasa yaimi sikaaiyaka, paisewa geya. ");
INSERT INTO gvs_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Maliyalina ainima tayamo goi Yau Yauwe yábana be poyapoya be négwasa be nakae kaga liliuna sinaedi amadagidi go, maliyalina ainima aiyuwoina goi awaiwasi. Tauna maliyalina ainima aiyuwoina aba waiwasi Yau Yauwe bogina akaipakuye be nakae akimasabe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Tamamiyao be sinamiyao kowowooinēdi, e bei yawoimi simamanao poyapoya Yau Yauwe imi Yaubada bei aavinimi goi. ");
INSERT INTO gvs_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Taabu kokaaumāta. ");
INSERT INTO gvs_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Taabu korooerāta. ");
INSERT INTO gvs_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Taabu kovaaināwana. ");
INSERT INTO gvs_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Taabu kotalavaita poolapōla semiyao yaidi. ");
INSERT INTO gvs_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Semiyao idi vada be monediyao be idi pakonayao koroto o vevina be idi bulumakauyao o idi aseyao o ava kónana tayamo taabu koyaalagāudi.’ ");
INSERT INTO gvs_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","E kidi go tomotayadi palapala sinovenove be ávila sigitegite, nakae síula sinovenove be aubowo sigitegite, tuwo wowodi sitatátava go, sibala sina masigava goi siitáoya. ");
INSERT INTO gvs_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Tuwo silatuwokoigu sidigo kadi, ‘Kom toinim kuvadigōima bei kanovem. Go taabu Yaubada ivaadigōima, govila bei kakámasa.’ ");
INSERT INTO gvs_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Go yau adigo kagu, ‘Taabu koomatōita! Yaubada ima bego Tauyana koyagoidoko, e bei kowowoinevatae be nakae goyo geya koguinuweyeta.’ ");
INSERT INTO gvs_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Tuwo tomotayadi masigava goi siitáoya go, yau ana gaota kalaabadaina kikina goi atáoya. Gaotayana sinaena moe Yaubada ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","E Yauwe ilatuwokoigu idigo kana, ‘Ame nakae Isileli tubunao kulatuwokōidi, kudīgo kam, “Komi toinimi bogina konove bego yábana goi avadigoimi. Geya kogiteguta, go sem konovegumo. ");
INSERT INTO gvs_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Tauna geya tayaamo basaleliu ana tokwalu siriba goi o goura goi koomadāgi bego dogoiyana be Yau taiyao kavavasa, e yaima kosakululu geya. ");
INSERT INTO gvs_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Go sem guna kaba kasala poyapoya goi komadāgi. Aba kasalayana goi imi yoguyoguyao moe imi sipiyao nakae imi bulumakauyao kokasalēdi yaigu. Yoguyoguyadi maniyedi bei kovakasavēdi go, maniyedi abivekoveko manuna kogabudīmo kokāika. Ava kasava goi neta atagona komi kosakululu yaigu, e amo asayadi liliudi goi bei awokoimi, e akaipakuyemi. ");
INSERT INTO gvs_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Go aba kasala gurewa goi neta kokaudakodako, taabu gurewayadi kokauvisivisīdi. Neta turu goi kokauvisivisidi, e gurewayadi bogina kokibaibailidi sakululu yaigu manuna. ");
INSERT INTO gvs_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Taabu aba kasalayana manuna aitámana koomadāgi, govila bei komwera, e bisosoimi sobuyekoidi moe aba kasalayana ikaaiyaka, e bei sikibaibāili.”’ ");
INSERT INTO gvs_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","E Yauwe tuwaina kana, ‘Lovina ame Isileli tubunao kuvinīdi: ");
INSERT INTO gvs_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Neta Iberiu kogimonedi bego imi pakonayao, manumi bei sipaisēwa tala ana badabada ainima tayamo taudi. Go tala ainima aiyuwoina paisewa goi kotaligēidi go, geya adi rowagamo. ");
INSERT INTO gvs_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Neta imi pakonayao aditava kogimonedi, niga bei tala ainima tayamo sikavava, e kotaligēidi aditava sisowóduwo. Go neta ma monediyao kogimonedi, e adi taiyuwokova sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Imi pakonayao neta vevina kovinidi bego monediyao go, sivenátuna, e vevinayadi ma natudiyao moe komi imi pakonayao. E korotoyadi aditava kotaligēidi sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ego neta imi pakonayao sidigo kadi, “Geya. Guna tomoya, monegu be nakae natugowo amatakoiyedi, tauna geya latuwogu kutaligeigu aguta ana”, ");
INSERT INTO gvs_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","e imi pakonayao kokabīdi komēdi Yau Yaubada guna Kaba Kaiyaka goi idi nuwonúwana sitalavaitedi. Ikavava, komēdi totom goi go, gita goi taiyadi kokariporēdi. Ikavava, ina gipolu kuyāto. Moe aba kinana bego manumi sipaisewa vata. ");
INSERT INTO gvs_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","E, neta natumiyao vevina kokaigimonedi bego tauyadi ituli ta tomota idi pakonayao, e adi talígava paisewa goi ituli, koroto nakae geya. Kidi moe adi tomoyayao moneyuwoinao. ");
INSERT INTO gvs_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Neta imi pakonayao vevina kogimonedi bego moneyuwoimi go, niga vevinayadi matami goi geya sidedevineta, e kotagonēdi toinidi idi bodao sitatetedi. Taabu kokaigiimonēdi ituli ta bodava yaidi unana moe nakae imi katótula tamadiyao yaidi goi kokapipilave. ");
INSERT INTO gvs_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","E, neta imi pakonayao vevina kokinavedi bego natumiyao koroto sivamonenedi, e imi pakonayaoyadi kovanatunēdi. ");
INSERT INTO gvs_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Neta toinimi imi pakonayao vevina kovamonenedi go, niga vevina paakonidi ituli kovamonenedi, e imi pakonayao vakuumgoidi avadi be adi kwama o masisi taabu kovagagaalakōidi. ");
INSERT INTO gvs_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Neta moe dogoiyadi aito geya koguinuwedita imi pakonayao yaidi, e tauyadi adi talígava paisewa goi sibabane go, adi taligavayana manuna geya siemaiseta.’ ");
INSERT INTO gvs_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","E Yauwe tuwaina kana, ‘E avatau neta tomota iláui ikámasa, tolauwoyana kokaumāte. ");
INSERT INTO gvs_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ego tolauwoyana neta ina sinapu geya ituluyeta bego ikaumate, go sem bego ilauiyamo, e tauyana itoboine isiya ina asa tayamo bei akinave manumi. Amoko goi guna kaba kasala iyoisi bei ana yava ibabane. ");
INSERT INTO gvs_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Go neta mana egamogamogu ina sinapu igimitulu bego siyana ikaumate, e nakae iguinuwe, neta tokaumata guna kaba kasala iyoisi, tuwo koyōisi kokaumāte. ");
INSERT INTO gvs_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","E avatau neta tamana o sinana ilauidi, e to kokaumateyāmo. ");
INSERT INTO gvs_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","E avatau neta tomota tayamo ivainao, neta tomotayana ikaigimone o neta tomotayana moe toinina ina pákwana, e to amo tovainawanayana kokaumateyāmo. ");
INSERT INTO gvs_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","E avatau neta tamana o sinana igieomaemae, e to kokaumateyāmo. ");
INSERT INTO gvs_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Neta tomota adi taiyuwo sikaumakimaki go, tayamo gurewa goi o nimana goi siyana iláui go, siyanayana geya ikamaseta, go sem ivailaimo, tauna kebana goi ikanabalabala ");
INSERT INTO gvs_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","go, neta tovailaiyana itáoya ina kaituko goi iketoiya moetala, e tolauwoyana ina liuna goi ámasa geya ibabaneyeta, go sem itoboine siyana iemaisi ina tuta paisewa manuna be nakae imatakavate ana kadókana iboboina. ");
INSERT INTO gvs_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","E avatau neta ina pákwana koroto o vavina aipíyama goi iláui go, mainao ikámasa, e amo tauyana kokatumāpu. Pakwanayana ina tomoya ana liuna moe ámasa. ");
INSERT INTO gvs_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Go neta maliyalina tayamo o aiyuwo mlidi pakoninayana, itáoya ma yawoina, e ina tomoya geya kokatumapuyeta. Tomoyayana toinina ina esaesa itagau, tauna ana liuna bogina tuwo. ");
INSERT INTO gvs_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","E, neta koroto adi taiyuwo sivalauláuwo go, vavina sumasumaina gamona siláui ikogúyala go, geya kada vailai tuwaina isowóduwo, e toláuwo moitamo bei iemáisa nakae vavinayana monena kaga idige nakae kotu goi totakínona ikamoitamoe. ");
INSERT INTO gvs_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Go neta vavinayana tuwaina ivailai, e ina vailaiyana ana katumapu ame nakae: Neta vavinayana ikámasa, e tokaumatayana kokaumāte. ");
INSERT INTO gvs_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Neta matana ikaigoyai, e tobugoyoyana matana kokaigoyāi. Neta salana, e salana. Neta nimana, e nimana. Neta aena, e aena. ");
INSERT INTO gvs_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Neta igabu, e tokaigabunayana kogābu. Neta italai, e totalayana kotalāi. Neta ikaumotui, e tokaumotuiyana kokaumotūi. ");
INSERT INTO gvs_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","E avatau neta ina pákwana koroto o vavina matana iláui go, matanayana ikaigoyai, e ina pakwanayana ina paisewa goi italigēi matana ina vailai ana katumapu manuna. ");
INSERT INTO gvs_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Avatau neta ina pákwana salana ikauwuwu, e pakoninayana ina paisewa goi italigēi salana ina tawuwu ana katumapu manuna.’ ");
INSERT INTO gvs_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","E Yauwe tuwaina kana, ‘E, neta bulumakau ina sakusaku goi tomota iginubasi ikámasa, e to amo bulumakauyana gurewa goi kokaumateyāmo go, iwoina taabu kokanikāni. Ego toni bulumakau tutubeso, taabu kooliūne. ");
INSERT INTO gvs_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Go neta bulumakauyana egamogamoguna go, toni bulumakau bogina kokatusinapu go, tuwo bulumakauyana geya ikaliyeta. Niga neta tomota iginubasi ikámasa, e bulumakauyana gurewa goi kokaumāte go, toni bulumakauyana nakae kokaumāte. ");
INSERT INTO gvs_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Go neta tokámasa osenao latuwodi mani, e toni bulumakauyana osenao siyadi yawoina sitatēte. Ana maisa moe kaga kotu ana totakínona siyato. ");
INSERT INTO gvs_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Neta bulumakau tomota natuna iginubasi ikámasa, e moe lovinayana nakae ibabane. ");
INSERT INTO gvs_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Neta bulumakau tomota paakonina iginubasi, e toni bulumakau bei siriba 30 iemāisi pakoninayana ina tomoya yaina. ");
INSERT INTO gvs_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","E avatau neta ina bobosiu ikatupáeve o neta bobosiu tayamo ieli go, geya ikaubodeyeta go, bulumakau o ase ikapusi isou sinaena ikámasa, ");
INSERT INTO gvs_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","e toni bobosiu bei ikatumāpu. Toni yoguyoguyana mani ivīni go, yoguyogu kaamasina kina toni bobosiu ikābi. ");
INSERT INTO gvs_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","E, neta koroto tayamo ina bulumakau ina ituli ta koroto ina bulumakau ikamate, e bulumakauyana ma yawoina sikaigimōne go, mani sikābi siwotāi. E bulumakau kaamasina nakae, siboboyūwe siwotāi. ");
INSERT INTO gvs_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Go korotoyana neta bogina iyagoi bego ina bulumakauyana egamogamoguna go, geya ikaliyeta, e ina bulumakauyana ma yawoina ikābi siyana ivīni go, bulumakau kaamasina kina ikābi.’ ");
INSERT INTO gvs_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","E Yauwe tuwaina kana, ‘E avatau neta bulumakau tayamo o sipi tayamo ivainao go, ikaumate talaina ikaigimone, e bulumakauyana ana katumapu moe bulumakau ainima toni yoguyogu ivini. Go sipiyana ana katumapu moe sipi aivasi toni yoguyogu ivini. ");
INSERT INTO gvs_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","4","Go neta yoguyoguyana iivainao nava maa yawoina nimana goi ikaaiyaka, nakona bulumakau o ase o sipi, e yoguyoguyana ana katumapu moe aiyuwo toni yoguyogu ivini. E tovaináwana neta sabamgo goi imi vada isiu bego ivaináwana go, kogitebabane go, koláui ikámasa, e moe aumata geya, tuwo geya ami goyomo. Go neta níyala bogina ituko go, tovainawanayana isiu, koláui ikámasa, moe aumata, e bogina kogoyo. E tovaináwana, neta koyoisi, itoboine toni kónana ikatumapu go, neta tauyana geya konanamo, tuwo koyōisi kokaigimōne bei tauyana paakonina go, manina toni kónana kovini.’ ");
INSERT INTO gvs_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","E Yauwe tuwaina kana, ‘E avatau neta ina yoguyogu toinina ina limou tanuina goi o ina oine tanuina goi ikakáika go, yoguyoguyana itagone ina siyana ina tánuwo goi ikáika, e toni yoguyogu ina dibayoya dedevina toina bei ikatumapu, siyana ivini. ");
INSERT INTO gvs_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","E avatau neta yeu idimili go, yeuyana taliboibo inínima ina siyana ina tánuwo witi gugunidi igabudi o neta witi nava geya sitalaidita go, igabudi, e moitamo amo tauyana bei ikatumapu. ");
INSERT INTO gvs_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","E avatau neta ana mani o konana tayamo siyana ivini bego irugwausi go, tovaináwana ina ivainao, neta tovainawanayana koyoisi, e ana katumapu aiyuwo toni kónana ivini. ");
INSERT INTO gvs_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Go neta tovainawanayana geya koyoisiyeta, e torugwáuta kokābi kōme Yaubada yaina go, ilovina nakona tauyana toinina ivainao o geya. ");
INSERT INTO gvs_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Vaináwana liliudi goi nakona bulumakau o ase o sipi o kwama o ava kónana itagau, neta manudi toni kónana siyana konana igite toinina konana maisiyana, tuwo idigo kana, “Moe konagu”, e adi taiyuwo bei sina Yaubada matana goi. Avatau neta Yaubada itakino tovaináwana, e tovainawanayana bei ana katumapu moe kónana aiyuwo siyana ivini. ");
INSERT INTO gvs_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","E avatau neta ina ase o ina bulumakau o ina sipi o ava yoguyogu siyana ivini bego irugwausi go, yoguyoguyana ikámasa o ivailai o itagau go, tomota geya sigiteyeta, ");
INSERT INTO gvs_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","e adi taiyuwo bei sitáoya Yau Yauwe matagu goi go, torugwáuta ikanatamada kana, “Yau yoguyoguyana geya abisikoneyeta.” Tauna torugwautayana geya ikatumapuyeta, e nakae toni yoguyogu geya tuwaina iboboreta. ");
INSERT INTO gvs_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Go neta moitamo tomota ivainao, e torugwautayana bei ikatumapu toni yoguyoguyana yaina. ");
INSERT INTO gvs_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Go neta woiwoi sima yoguyoguyana sikayapesapesagi, e torugwáuta yoguyoguyana kaamasina ikabi ime aba kinana manuna, tauna torugwautayana geya ikatumapuyeta. ");
INSERT INTO gvs_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","E avatau neta siyana ina yoguyogu ikatoguye go, yoguyoguyana ikámasa o ivailai go, toni yoguyogu geya ikaiyaketa, e moitamo tokatoguyana itoboine bei toni yoguyoguyana iemaisi. ");
INSERT INTO gvs_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Go neta yoguyoguyana ikámasa o ivailai toni yoguyogu matana goi, e tokatoguyana geya ikatumapuyeta. Go neta siyana ina yoguyogu ina paisewa manuna iemaisi go, yoguyoguyana ikámasa o ivailai, e torugwáuta bogina iemaisi, tuwaina tuwo.’ ");
INSERT INTO gvs_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","E Yauwe tuwaina kana, ‘Neta vavina tayamo geya ana kanaotamo be nakae geya ana kamatakonamo go, koroto tayamo ina vavinayana iloidibi bego taiyao simasisi, e vavinayana osenao bei iemaisidi go, itoboine koroto be vavina sinai. ");
INSERT INTO gvs_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Go neta vavinayana tamana geya itagoneyeta sinai, e korotoyana bei iemáisa vavina buwona.’ ");
INSERT INTO gvs_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","E Yauwe tuwaina kana, ‘Ava vavina iibowou, e amo tauyana taabu kootagōna maa yawoina ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Avatau neta yoguyogu taiyao simasisi goyogoyo, e amo tauyana kokaumateyāmo. ");
INSERT INTO gvs_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Avatau neta ina vininabeso ikasale basaleliu yaina go, Yau Yauwe agutava yaigu geya, e amo tauyana asala vaatayaina umagu aná mtula manuna. ");
INSERT INTO gvs_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Tomalatonikasa taabu kobaagalīdi be nakae taabu koyogedeegedēdi. Neta konuwaisi, boi komi nakae komalatonikasa Itipita goi. ");
INSERT INTO gvs_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kóbuya be gumalau liliudi taabu kokitaaitaiyēdi. ");
INSERT INTO gvs_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Neta kovaobudi go, situmadadegu, moitamo bei anovedi, ");
INSERT INTO gvs_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","e magu egamogamogu ami kaleyayao nimadi goi bei akaumatemi, e bei monemiyao sikóbuya nakae natumiyao siegumalau. ");
INSERT INTO gvs_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","E, neta kotagona bego tookaina tayamo komi guna bodao yaimi mani ikatoguye, e komi nakae rowaga ana totagona tokainayana yaina, e ina rowaga tuwaina yatana taabu koyatoyato. ");
INSERT INTO gvs_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Neta siyami konami ikatoguye yaimi go, siyamiyana ina tanigo kokabi go, niga mainao igimitatete baige ikabimnei, e namliyeta níyala isaliu, e kōna ina tanigo kovinimnēi. ");
INSERT INTO gvs_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Bogina koyagoi. Moe nakona ina tanigo tayamo toito. Tauna manakaena bei imasisi? Neta itumadadegu, bei anove. Yau tonuwokapisi. ");
INSERT INTO gvs_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Yau Yaubada taabu kotagiiwoīgu be nakae taabu imi tolovinao kokatuboolatēdi. ");
INSERT INTO gvs_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Taabu kokaaimūmuna imi dibayoya witi be oine keuwokumgoidi adi vininabeso kokasaledi yaigu. Imi botomoyayao koroto bei kovinīgu. ");
INSERT INTO gvs_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","E nakae imi bulumakauyao be imi sipiyao yaidi idi botomoyayao bolamo bei kovinīgu. Tutayana yoguyoguyadi sibíbina, maliyalina ainima aiyuwo goi bei sikaaiyaka sinadiyao taiyao. Go maliyalina ainima aitonina goi, kovinīgu. ");
INSERT INTO gvs_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Komi kimaasabaimi umagu, tauna neta woiwoi yoyowo goi yoguyogu tayamo sikamate sikalave, e taabu kokanikāni, go sem kokalāve. Moe weiniya avadi.’ ");
INSERT INTO gvs_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","E Yauwe tuwaina kana, ‘Taabu talavaita polapola kosaanunūi. Taabu toogoyoina ina pola goi koovavāite bei kotalavaita polapola. ");
INSERT INTO gvs_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Taabu boda gagaina idi guinuwa goyogoyoidi goi kosiiukōidi. Neta kotu goi boda sipola latuwodi kotuyana sibugoyai, e taabu kotalavaita polapōla bego kovaitedi. ");
INSERT INTO gvs_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Neta tookaina siekotuye go, tokainayana kogite nukotomi igoyo, taabu tokainayana pola goi koovavāite ina kaiyakomou pasina. ");
INSERT INTO gvs_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Neta ami kaleya ina bulumakau o ina ase ina kali goi isowóduwo iketoiya besobeso go, kobabane, e kokābi kokaluvilemnēi toni yoguyogu yaina goi. ");
INSERT INTO gvs_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Neta ami kaleya ina ase ikapusi kónana moumoudi ikaavaledi pasina, e taabu aseyana kookalāve, go sem ami kaleya kovāite, e aseyana kobutāoe. ");
INSERT INTO gvs_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","E tookaidi yaimi goi mami kivavasa adi kotu goi kotakīnona. ");
INSERT INTO gvs_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","E taabu kotalavaita polapōla. Tomota tutubeso be nakae tokibóbwata imi kotu goi taabu kotaagonēdi sikamakámasa. Moitamo. Avatauwa komi yaimi nakae koguinuwe, geya anuwotaoimita. ");
INSERT INTO gvs_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Kotu goi neta tomota tayamo mani ivinimi bego kopola, maniyana taabu kokabikābi. Maniyana pasina geya itoboinemita kogitedoko nako bóbwara moitamo go, nako pola. Aiyuwoina moe sinapuyana goi tokibóbwata ina talavaita mooitamoina kobugoyai. ");
INSERT INTO gvs_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Tomalatonikasa taabu koyogeedegēde. Komi bogina koyagoi tomalatonikasa adi lotówana nakonakae. Moitamo. Boi komi tomalatonikasa nakae Itipita goi.’ ");
INSERT INTO gvs_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","E Yauwe tuwaina kana, ‘Tala ainima tayamo sinaedi imi poyapoya goi kobāgula be nakae kodibayōya. ");
INSERT INTO gvs_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Go tala ainima aiyuwoina goi, e poyapoyayana iwaiwasi, taabu koobagūli. Niga neta amo poyapoyayana goi awoinu itabo, tookaidi yaimi goi kotagonēdi sina sikabi, avadi. Go kaga tokaidiyadi geya sikabiyeta, e woiwoi kotagonēdi sina sikani. Ame nakae koguinūwe imi oine tanuidi manudi be nakae imi kalova oribe tanuidi manudi. ");
INSERT INTO gvs_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Maliyalina ainima tayamo goi koopaisēwa go, maliyalina ainima aiyuwoina goi kowaiwāsi bei imi bulumakauyao be imi aseyao itoboinedi siwaiwasi, nakae imi pakonayao sibíbina yaimi be nakae tomalatonikasa itoboinedi siwaiwasi. ");
INSERT INTO gvs_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","E kaga liliuna bogina alatuwokoimi, e konōve. Go basaleliuyao yoidi taabu koduuduwēdi. Nakae taabu tauyadi yoidi sopami goi sisowōduwo.’ ");
INSERT INTO gvs_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","E Yauwe tuwaina kana, ‘E tala tayamo sinaena uyáwana aikanidi gagaidi yaigu bei sivato kowodugukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Aikayana vakuumgoina moe Beredi Pokaka Aikanina kowodūgu. Maliyalina ainima aiyuwo beredi pokaka kokakāika tukówana Abib goi nakae bogina alatuwokoimi. Amo tukowanayana sinaena Itipita goi kosowóduwo. Go taabu nima kaka komamāima matagu goi, go sem mami vininabeso kōma kosakulūlu yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Keuwokumgo Aikanina kowodūgu. Amo aikaniyana goi dibayoya keuwokumgoina kokāsale yaigu. Aikayana sivatonina moe Lolágata Aikanina kowodūgu tala ana kaba lukavava goi tutayana távina ikavava. ");
INSERT INTO gvs_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Sivato tala tayamo goi komi koroto kōma kosowōduwo Yau Yauwe imi Tomoya matagu goi. ");
INSERT INTO gvs_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","E, neta yoguyogu kokaumate, kogabu bego kokasale yaigu, e taabu yoguyoguyana ikaikaina beredi mana isti taiyao kokaasalēdi. Neta yoguyogu tayamo bego kogabu kokasale yaigu, sabalina taabu koyatoyāto bego itomo kokasale. ");
INSERT INTO gvs_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Imi dibayoya keuwokumgoina dedevina toina imi poyapoya goi komēdi Yau Yauwe imi Yaubada guna Kaba Kaiyaka goi. Neta goti bonatuna kovaipolu, taabu sinana nununa bwaena goi kovaaipōlu.’ ");
INSERT INTO gvs_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","E Yauwe tuwaina kana, ‘Konōve. Yau guna anerose bei aetune iwo ivakumgoiyemi bego imi ketoiya goi irugwausimi be nakae imemi asa tayamo goi bogina akatuubayasi manumi. ");
INSERT INTO gvs_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Mami dodókana Tauyana niyana konōve. Taabu sopana kokapiipilāve. Bogina koyagoi. Imi kapipilovayana bei geya inuwotaoidita. Yau akaaiyaka tauyana yaina, tauna tauyana guna katumapu nakae. ");
INSERT INTO gvs_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Neta guna aneroseyana sopana kokabikaonedoko be koguinuwe nakae bogina alatuwokoimi, e komi ami kaleyayao Yau nakae guna kaleyayao. Avatau bego ivayaviya komi yaimi, e Yau nakae avayaviya tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Moitamo. Guna aneroseyana bei ivakedemi kona kidi Emori tubunao, Eta tubunao, Perisi tubunao, Kenani tubunao, Ivai tubunao be nakae Iyebusi tubunao idi poyapoya goi. Amo tauyadi bei amtulidi. ");
INSERT INTO gvs_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Taabu kovaatugūyala kokanakabobo be taabu kokatetaagonēmi idi basaleliuyao yaidi goi. Taabu idi sinapu kovatotoowonēdi. Go sem kovasobusobuyedokōidi be nakae idi dídiya aba sakululu kokauvisivisīdi. ");
INSERT INTO gvs_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Kosakulūlu Yau Yauwe imi Yaubada yaigu go, avami be ami bwae bei avamamailidi go, imi katówana bei akabidi akalavedi. ");
INSERT INTO gvs_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Vevina yaimi goi geya tayaamo bei ikogúyala o ikágala geya. Yawoimi bei akimamanavedi. ");
INSERT INTO gvs_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Yau bei avakumgoiyemi ami kaleyayao akatumatoisidi gagaina. Tutayana kovalobodedi, bei nuwodi akiwowonidi, e bei sisiyaemi. ");
INSERT INTO gvs_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Bwanou bei aetunedi sivakumgoiyemi sina bei Ivai tubunao, Kenani tubunao be nakae Eta tubunao sivatapiyedi sisiya. ");
INSERT INTO gvs_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Go tala tayamo goi geya avatapiyedita, govila bei poyapoya ikágala be nakae woiwoi sisusáila badabada sisaki, e sikanimi. ");
INSERT INTO gvs_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Giyaina be giyaina avatapiyedi ana kadókana komi kosusáila nakae itoboinemi poyapoyayana kokabi imi kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Imi poyapoyayana ana túwana bei ayatoidi ame nakae: Négwasa Kayakayaina ina da Palisiti idi négwasa. Aiyuwoina yoyowo goi ina sákala Yuparetisi goi. Toni kasa bei nimami goi ayatoidi bego itoboinemi kotogagasavedi. ");
INSERT INTO gvs_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Go taabu toni kasayadi be idi basaleliuyao kokanasiiukōidi. ");
INSERT INTO gvs_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Taabu kotaagonēdi poyapoyayana goi sikaaiyaka, govila bei kidi pasidi kogoyo yaigu. Neta idi basaleliuyao yaidi kokatetagonemi, moe nakae ami síkwana kowodugu yaimi.’ ");
INSERT INTO gvs_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yauwe ina lovina ilatuwokoima ikavava, ilatuwokoigu idigo kana, ‘Kom be Eroni, Nadabi be Abaiu e nakae Isileli tubunao adi tomoyamoya 70 taiyao kotūko kōma Yau Yauwe yaigu. Go masigava goi kovatugūyala kokanakabobo Yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mosese, kom amtava kūma Yau Yauwe kikigu goi. Go kidi Eroni taabu simamāima kikigu. Tomotayadi nakae, taabu situkotūko kom taiyao.’ ");
INSERT INTO gvs_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","E tuwo yau asou ana tomotayadi Yauwe ina livala be nakae ina lovina alatuwokoidi. Madabokidi niyadi tayamo goi sikatuvavase sidigo kadi, ‘Kaga liliuna Yauwe iidigedi nakae bei kaguinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tuwo kaga liliuna Yauwe bogina ilatuwookoigu agini. Ikavava, amasisi vanuwo itomo, nobuyana giyaina atáoya, ana koyayana unana goi aba kasala akaudakodako. Ikavava, dídiya yawou aiyuwo avataoedi. Didiyayadi moe Isileli tubunao adi dala yawou aiyuwo manudi. ");
INSERT INTO gvs_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Akaudakodako ikavava, tubuwau Isileli tubunao yaidi goi aetunedi sina idi yoguyoguyao vininabeso maniyedi sikabidi, sigabudi, sivakasavedi go, sikasaledi Yauwe yaina. Go bulumakau maniyedi sigabudi go, sikasaledi Yauwe yaina abivekoveko manuna. ");
INSERT INTO gvs_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ego yoguyoguyadi ikaikaidi akabidi awotaiyuwedi nakiyana nakiyana. Nakiyana noko goi asaligogo go, nakiyana goi aba kasalayana aseuli. ");
INSERT INTO gvs_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ikavava, Yauwe Ina Kanasíuna Bukina akabi, niyagu gagaina goi akatuyaivi tomota yaidi. Ikavava, liliudi sidigo kadi, ‘Kaga liliuna Yauwe iidigedi nakae bei kaguinuwedi be kakabikaonedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","E tuwo ikaikayana noko goi akabi tomota aseulidi go, adigo kagu, ‘Konōve! Ame ikaikayana goi Yauwe bogina ikanasiukoida. Anasiunayana unana moe ina livala liliudi bogina ivinida, e takatótula takabikaonedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Abóbwara ikavava, e Eroni, Nadabi, Abaiu, Isileli tubunao idi tomoyamoya 70, yau taiyao koyayana goi katuko. ");
INSERT INTO gvs_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Katuko, e kai Isileli tubunao ima Yaubada kagite. Aena ogalaoina goi gurewa tayamo kaausaraina yoina sapaire nakae ikaaiyaka go, maisina yábana buruu nakae. ");
INSERT INTO gvs_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Kidi go Isileli tubunao idi tomoyamoya, e Yauwe nimana geya iyosaleyeta adi láuwo manuna. Tauyana sigite go, sikáika be sinim. Ikavava, madabokima koyayana goi kasou. ");
INSERT INTO gvs_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","E Yauwe ilatuwokoigu idigo kana, ‘Kutūko kūma yaigu koya yatana goi kwaiyāka, gurewa paaevaidi bei avinim. Gurewayadi goi guna Katukeda be guna lovina bogina aginidi. Kom kwabīdi tomota kuvatulukōidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Tuwo guna tovaita Iyosuwa akabi go, mainao tomoyamoyayadi alatuwokoidi adigo kagu, ‘Ameko goi kotuyaosīma ana kadókana kakaluvilamna kama. Go konōve. Eroni be Ure sikaaiyaka komi taiyao. Neta tomota sikaumakimaki, e sinokoidi bei idi kaumakimakiyadi sikitototoidi.’ Alatuwokoidi ikavava, atáoya Iyosuwa taiyao kana Yaubada ina koya goi katuko. Giyaina katukokova, e Iyosuwa akalave go, yau aguta atuko. ");
INSERT INTO gvs_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Atukotuko go, gaota koya iumai. ");
INSERT INTO gvs_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yauwe ana káeyana isou koyayana yatana ikaaiyaka. E gaotayana iumai maliyalina ana badabada ainima tayamo. Go Yauwe gaotayana sinaena maliyalina ainima aiyuwoina goi iduduwegu. ");
INSERT INTO gvs_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ego Yauweyana ana káeyana Isileli tubunao kagite ana kaigigita yeu sabeninimina nakae koya yatana goi. ");
INSERT INTO gvs_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Yau atukotuko, e gaotayana goi asiu. Maeko goi maliyalina 40 be nakae sabamgo 40 akaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","‘Isileli tubunao kulatuwokōidi latuwogu idi vagidi sikabidi simedi sikasaledi yaigu. Avatau neta ina vininabeso itagone, e kukābi. ");
INSERT INTO gvs_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Vagidiyadi bei kwabidi ame nakae: Goura, siriba be nakae kopwa, ");
INSERT INTO gvs_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","búyala noyanoyaidi buruu, kalaakovidi toidi be nakae kayakayaidi. Nakae areko dedevidi toidi, goti unuunudi, ");
INSERT INTO gvs_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","sipi bolamo sakavaidi go, sakavayadi bogina sikaredi kayakayaidi. E nakae yoguyogu sakavaidi, gaigíyala, ");
INSERT INTO gvs_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","oribe mumuna rampa manuna, alova sakavaidi dedevidi, pútuma aba kaipaku manuna be nakae insensi ma mainina dedevina. ");
INSERT INTO gvs_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","E gurewa esaaesaidi yoidi anikisi be nakae gurewa dedevidi Tonúwala ana kwama manuna. Kwamayadi aiyuwo, tayamo tolobona ana kwama manuna, e tayamo kasikasina ana saisaira manuna. ");
INSERT INTO gvs_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","E kulatuwokōidi latuwogu guna kaba kimasaba siyowo, e bei yaimi goi akaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Nakonakae guna Kaba Kaiyaka yoyou ma konanina liliudi makayaudi bei avatulukoim, e tauna nakae kutapatēdi go, Isileli tubunao kuvatulukōidi simadagidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu gaigíyala taalaidi sikabidi, dedeoga tayamo bei simadagi. Ana mamanao panetayataya aba katugúyala go, ana papaeva panetayataya go, ana tukotuko panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ikavava, goura maavadaina sikabi sikaupapaeve, e dedeogayana goi bei sikaupatuko, tauna dedeogayana toluyena be sinaena goura. Ikavava, ana papa kinababaina goi goura bei sikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ikavava, rini goura aivasi bei simadagidi, matakubuna aivasi goi siyatoidi, dadava aiyuwo, dadava aiyuwo. ");
INSERT INTO gvs_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ikavava, aitakeo aiyuwo gaigíyala bei sibobóidi go, goura paaevaidi sikabidi aitakeoyadi goi sikaupatukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ikavava, riniyadi goi sivaisiudi bei itoboinedi dedeogayana sikaitakeve. ");
INSERT INTO gvs_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Aitakeoyadi bei sikaiyako vata dedeoga ana rini goi. Taabu sibuuyagīdi. ");
INSERT INTO gvs_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Aba vatulúkwana moe gurewa aiyuwo goi aaginidi bei avinim, e dedeogayana sinaena goi kudodōidi sikaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","E tomota kulatuwokōidi latuwogu goura maavadaina sikabi, dedeogayana ana katukábwala simadagi. Atukabwalayana moe aba núwala. Aba nuwalayana ana kakainaki ame nakae: Ana mamanao panetayataya aba katugúyala go, ana papaeva panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Ikavava, goura bei situtu, yábana ana tomatakavatayao aiyuwo simadagidi tokwalu nakae. Simadagidi ikavava, bei aba núwala yatana goi siyatoidi, ");
INSERT INTO gvs_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","tayamo matakubuna, tayamo matakubuna goi sipakitaoidi. Tauna aba núwala yatana goi tayamo dadavina, tayamo dadavina. ");
INSERT INTO gvs_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Yábana ana tomatakavatayaoyadi ma panepanedi bei simadagidi go, panepanediyadi siyosaledi, e aba nuwalayana bei sitakabobo bei simataakavate. Adi taiyuwo matana matana sikaaiyaka go, sikandosobu aba núwala sigitegite. ");
INSERT INTO gvs_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Simadagidi ikavava, aba vatulúkwana moe lovina yawou gurewa goi aaginidi bei avinim go, kom kudodōidi dedeoga sinaena goi sikaaiyaka. Ikavava, aba núwala bei sikabi, dedeoga yatana sikailagasi. ");
INSERT INTO gvs_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Aba nuwalayana yatanaina goi yábana ana tomatakavatayao adi taiyuwo nauyayanaidi bei avalobodem. Amoko goi bei alatuwokoim guna lovina liliudi Isileli tubunao manudi.’ ");
INSERT INTO gvs_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu gaigíyala taalaidi bei sikabidi, teboro tayamo simadagi. Teboroyana ana kakainaki ame nakae: Ana mamanao panetayataya kasikasi go, ana papaeva aba katugúyala go, ana tukotuko panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Go teboroyana goi goura maavadaina go, paaevaidi sikaupatukoidi. Ikavava, kinababaina goi ana papa goura bei sikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Sikaupatuko ikavava, teboroyana yatana goi tupaota goura siyatoidi ivaníbita. Tupaotayadi adi tukotuko nimakulemwasi tayamo. Go tupaotayadi goi ana papa goura sikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Ikavava, rini aivasi goura maavadaina simadagidi, teboro matakubuna aivasi goi siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Tupaota kikina go, sobuyekoina riniyadi sikaaiyaka bei aitakeo goi teboroyana sikaitakeve. ");
INSERT INTO gvs_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Rini siyatoidi ikavava, e aitakeoyadi gaigíyala aiyuwo sibobóidi, goura paaevaidi goi sipaimidi go, gourayadi sikaupatukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ikavava, e goura maavadaina sikabi, teboroyana ana noko, insensi ana pereiti, teboroyana ana botori be ana borodisi simadagidi. Botoriyana be borodisiyana moe imi oine vininabeso manuna. ");
INSERT INTO gvs_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Latuwogu tuta liliuna teboroyana yatana beredi kimaasabaidi umagu matagu goi siiyatoidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu goura maavadaina sikabi situtu, e rampa adi kaba yata bei simadagi. Aba yatayana alova maisiyana, tauna sipona, tolobona, unana, gadona be nakae senina vagana simadagidi go, madabokina ana lamgógana goura tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Go laonina nakae ainima tayamo tolobona goi simadagidi situko, dadavina aito, dadavina aito. ");
INSERT INTO gvs_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Senina vagana ma gadona aito laoninayadi tamo tamo goi bei sikaaiyaka. Seninayadi taniya maisiyana. ");
INSERT INTO gvs_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Go rampa adi kaba yata tolobona goi senina vagana ma gadona aivasi bei sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Nako goi laonina sisowóduwo tolobona goi, e senina vagana ma gadona bei sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Go senina gadonayana be laoninayana goura maavadaina situtudi go, ana lamgógana goura tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Rampa adi kaba yatayana manuna rampa giyaidi ainima aiyuwo bei simadagidi. Ikavava, rampa adi kaba yata sipona yatadi goi siyatoidi, e bei rampa adi kaba yata matana goi imavada. ");
INSERT INTO gvs_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Go ina wiki ana kaba kalikaina be nakae ana noko moe goura maavadaina goi bei simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Go goura mavadainayana ana moumou nakae kilo ana badabada 30 bei sikabi rampa adi kaba yata be nakae konanina adi madágina manuna. ");
INSERT INTO gvs_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Go am dodōkana bei dogoiyadi boi mainao koya goi bogina avatulukoim, e tauna nakae kutapatēdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu guna Kaba Kaiyaka yoyou simadagi ame nakae: Areko dedevidi toidi adi badabada yawou be nakae búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi, e simadagi. Arekoyadi goi yábana ana tomatakavatayao makauyadi sigilumidi. Gilumayana ana kaigigita gíluma ana tokatanaki idi paisewa. ");
INSERT INTO gvs_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Go areko tamo tamo adi mamanao ovanima ovato go, adi papaeva ovatayamo. Areko liliudi adi kakainaki nakae. ");
INSERT INTO gvs_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","E areko ainima adi mamanao goi sisavikoidi. Niga areko ainima sikabidi, adi mamanao goi sisavikoidi. ");
INSERT INTO gvs_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Go areko buruu sikabidi, látuma siyatakoidi go, latumayadi matakubudi aba vatumna areko tayamo ana mamanao goi sigilumipatukoidi. Aba vatumna areko aiyuwoina ana mamanao goi, nakae bei siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Aba vatumna areko tayamo ana mamanao goi ana látuma adi badabada 50 sigilumipatukoidi. E nakae aba vatumna areko aiyuwoina ana mamanao goi siguinuwe. Go latumayadi sivatuyuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ikavava, aba talagegeta goura adi badabada 50 simadagidi, e aba talagegetayadi goi aba vatumna areko aiyuwokova sisavidi, e bei guna Kaba Kaiyakayana ana kaba vatumna ana kaigigita areko tayamo toito. ");
INSERT INTO gvs_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","E tomota kulatuwokōidi latuwogu goti unuunudi sikabidi, areko yawou tayamo simadagidi. Arekoyadi guna Kaba Kaiyaka ana kaba vatumna siyatakoidi. ");
INSERT INTO gvs_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Arekoyadi tamo tamo adi mamanao ovanima ovato aba katugúyala. Go adi papaeva ovatayamo. Arekoyadi madabokidi adi kakainaki nakae. ");
INSERT INTO gvs_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Go arekoyadi ainima sikabidi, adi mamanao goi sisavikoidi. Niga arekoyadi ainima tayamo sikabidi, adi mamanao goi sisavikoidi. Go ame arekoyana goi guna Kaba Kaiyaka sivatum go, kaga ikesa, moe areko ainima tayamoina, e ana kaba siu goi siguyali. ");
INSERT INTO gvs_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Látuma areko ana badabada 50 sikabidi, matakubudi sigilumipatukoidi aba vatumna ana mamanao goi. Nakae siguinuwe aba vatumna aiyuwoina goi. ");
INSERT INTO gvs_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ikavava, aba talagegeta kopwa ana badabada 50 simadagidi go, aba vatumna areko aiyuwokova adi látuma goi sivaisiudi sisavidi. Tauna aba vatumna areko tayamo maanawena. ");
INSERT INTO gvs_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Arekoyana panetayataya kasikasi ikesa Tukunu goi moe sikayabale ina sikayapatuko. ");
INSERT INTO gvs_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Go guna Kaba Kaiyaka salavavaina arekoyana ikesa aba katugúyala goi sikayabale ina sikayapatuko, e guna Kaba Kaiyaka ivatum. ");
INSERT INTO gvs_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Ikavava, aba vatumna aiyuwo tuwaina sigilumidi guna Kaba Kaiyakayana manuna. Tayamo sipi bolamo sakavaidi sikabidi aba vatumna tayamo sigilumi. Sakavaidiyadi sikaredi kayakayaidi. Go aiyuwoina yoguyogu sakavaidi sikabidi aba vatumna aiyuwoina sigilumi.’ ");
INSERT INTO gvs_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu gaigíyala taalaidi sikabidi, guna Kaba Kaiyakayana ana vabodakalova simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ana vabodakalova tamo tamo gidigidina ana tukotuko ovato go, adi mamanao panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Vabodakalovayadi adi madágina ame nakae: Alova aiyuwo sivataoedi go, alova sikanabaledi alovayadi aiyuwo nauyayanaidi goi. Vabodakalova liliudi Aba Kaiyakayana goi simadagidi nakae. ");
INSERT INTO gvs_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Vabodakalova adi badabada 20 simadagidi Aba Kaiyakayana youya dadavina manuna. ");
INSERT INTO gvs_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Go vabodakalovayadi adi kaba táoya siriba adi badabada 40 simadagidi. Tauna aba táoya aiyuwo moe vabodakalova tayamo manuna. Nakae bei siguinuwe vabodakalova liliudi goi. ");
INSERT INTO gvs_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Go guna Kaba Kaiyakayana yawéyana dadavina goi nakae bei siguinuwe. Vabodakalova adi badabada 20 simadagidi ");
INSERT INTO gvs_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","go, adi kaba táoya siriba adi badabada 40 simadagidi. Tauna aba táoya aiyuwo vabodakalova tayamo manuna. ");
INSERT INTO gvs_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Go Tukunu ana vaboda goi, moe koiboga dadavina, guna Kaba Kaiyakayana ana vabodakalova adi badabada ainima tayamo simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Go guna Kaba Kaiyakayana matakubuna aiyuwo goi vabodakalova aiyuwo tuwaina simadagidi, sikalipaiwolidi. Moe yawéyana be koiboga adi valoboda goi be nakae youya be koiboga adi valoboda goi. ");
INSERT INTO gvs_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Sikalipaiwolidi, tauna ditonema unadi goi vabodakalova aiyuwo go, diligaema rini goura goi vabodakalovayadi sikopatukoidi. Tukunu ana vaboda matakubuna aiyuwo goi siguinuwe nakae. ");
INSERT INTO gvs_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Tuwo vabodakalova adi badabada ainima aito koiboga dadavina go, adi kaba táoya adi badabada yawou ainima tayamo. Moe aba táoya aiyuwo vabodakalova tayamo manuna. ");
INSERT INTO gvs_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Vabodakalovayadi simadagidi ikavava, latuwogu logógana gaigíyala ainima sibobóidi, e vabodakalova toluyedi youya dadavina goi sikanabaledi. ");
INSERT INTO gvs_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Ikavava, ainima tuwaina sibobóidi, e yawéyana dadavina sikanabaledi. Nakae ainima sibobóidi Tukunu koiboga dadavina nakae sikanabaledi. ");
INSERT INTO gvs_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Go rini goura siyatoidi vabodayadi toluyedi goi, e vaboda tamo tamo nauyayana logógana tayamo riniyadi goi sivaisiu ikanabalabala go, adi mamanao vaboda naveyadi. ");
INSERT INTO gvs_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Vabodakalovayadi liliudi goi goura paaevaidi bei sikaupatukoidi. Aiyuwoina logoganayadi goura paaevaidi goi sipaimidi go, gourayadi sikaupatukoidi. Ikavava, rini goura simadagidi, vabodakalova toluyena goi siyatoidi, e logoganayadi sivaisiudi. ");
INSERT INTO gvs_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","E guna Kaba Kaiyakayana simadāgi nakae makayauna koyayana goi bogina avatulukoim kutapate.’ ");
INSERT INTO gvs_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi be nakae areko dedevidi sikabidi, e gíluma ana tokatanaki sivini, vabodaupa kaarekoina tayamo igilumi. Arekoyana goi yábana ana tomatakavatayao makayaudi igilumidi. ");
INSERT INTO gvs_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Igilumidi ikavava, tomota kulatuwokōidi latuwogu kówala gaigíyala aivasi sibobóidi go, goura paaevaidi sikabidi, kowalayadi sipaimidi. Sipaimidi ikavava, adi kaba táoya siriba goi sivataoedi guna Kaba Kaiyakayana sinaena. Go aba talagegeta goura kowalayadi sipodi goi siyatoidi. Amoko goi arekoyana sivakosaine. ");
INSERT INTO gvs_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Latumayadi boi aba vatumna areko sisaavikoidi sobuyekoidi goi arekoyana sivakosaine. Sivakosaine ikavava, e aba vatulúkwana dedeogaina sikabi, sivaisiu vabodaupa kaarekoina sinaena siyato. Vabodaupayana Bateta Kimaasabaina be Tukunu Kimaasabaina Toina sivabodaupedi. ");
INSERT INTO gvs_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Dedeoga siyato ikavava, e aba núwala sikabi, Tukunu Kimaasabaina Toina goi sivaisiu aba vatulúkwana dedeogaina yatana goi sikailagasi. ");
INSERT INTO gvs_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ikavava, teboroyana sikabi, sikaitakeve sinave guna Kaba Kaiyaka goi sivaisiu go, yawéyana dadavina vabodaupa kaarekoina toluyena goi siyato. Go rampa adi kaba yata sikabi, guna Kaba Kaiyaka goi sivaisiu go, youya dadavina vabodaupa kaarekoina toluyena goi siyato. ");
INSERT INTO gvs_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","E guna Kaba Kaiyaka ana kaba siu moe bomatu dadavina goi bei ikaaiyaka. Aba siuyana kaarekoina ana gíluma ame nakae: Búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi sikabidi, e gíluma ana tokatanaki bei sivini, igilumi. ");
INSERT INTO gvs_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Igilumi ikavava, tomota kulatuwokōidi latuwogu kówala gaigíyala ainima sibobóidi, e goura paaevaidi sikabidi, kowalayadi sipaimidi. Sipaimidi ikavava, adi kaba táoya kopwa simadagidi. Ikavava, goura sikabi aba siu karekoinayana adi kaba talagegeta simadagidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu gaigíyala taalaidi sikabidi, aba kasala simadagi. Ana mamanao be nakae ana papaeva moe ovatayamo panetayataya go, ana tukotuko moe ovatayamo. ");
INSERT INTO gvs_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Simadagi ikavava, e ana sakusaku aivasi simadagidi matakubuna aivasi goi siyatoidi go, sakusakuyadi be aba kasala alova tayamo goi simadagidi. Siyatoidi ikavava, kopwa paaevaidi sikabidi, aba kasalayana goi sikaupatukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ikavava, e kopwa tuwaina sikabidi, aba kasala konanina simadagidi. Konaninayadi ame nakae: Silekau ana kaba vadoda, ana sabwero, ana borodisi, ana sisiwo be nakae pokova ana kaba vadoda simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ikavava, e kopwa tuwaina sikabi, ana vátala simadagi yeu ana kaba dímila manuna. Go vatalayana matakubuna aivasi goi rini kopwa sikaupatukoidi go, sisowóduwo aba kasalayana toluyena goi. ");
INSERT INTO gvs_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ikavava, e aba kasala sinaena nauyayanaina goi sidodoi. ");
INSERT INTO gvs_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ikavava, aba kasala ana kaitakeo gaigíyala aiyuwo sibobóidi. Niga kopwa paaevaidi goi bei sipaimidi. ");
INSERT INTO gvs_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Ikavava, aitakeoyadi sivaisiudi riniyadi aba kasala toluyena goi, dadavina tayamo, dadavina tayamo, e bei itoboinedi aba kasalayana sikaaitakeve. ");
INSERT INTO gvs_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Aba kasalayana timba paaevaidi goi bei simadagi. Go sinaena daakakaina be nakae dibuna geya ana kaubodamo. Latuwogu simadagi nakae makayauna boi koyayana goi bogina avatulukoim.’ ");
INSERT INTO gvs_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi latuwogu guna Kaba Kaiyakayana sikali. E areko dedevidi sikabidi, guna Kaba Kaiyakayana ana kali simadagi. Aliyana youya dadavina ana mamanao moe ova 30. ");
INSERT INTO gvs_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Kówala ana badabada 20 adi kaba táoya kopwa goi sivataoedi. Kowalayadi adi takudukudu goi rini be aba talagegeta siriba siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Yawéyana dadavina goi nakae. Ana mamanao moe ova 30 go, kówala ana badabada 20 madi kaba táoya kopwa goi. Kowalayadi adi takudukudu goi rini be aba talagegeta siriba siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","E aliyana koiboga dadavina ana mamanao moe ovayawou ovanima go, kówala ana badabada yawou adi kaba táoya kopwa goi sivataoedi. Go sipodi goi rini be aba talagegeta siriba siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","E aliyana ana kaba siu goi moe bomatu dadavina, ana mamanao nakae ovayawou ovanima. ");
INSERT INTO gvs_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Aba siu dadavina ana mamanao ovavasi panetayataya, dadavina ovavasi panetayataya. Go ana kówala dadavina aito, dadavina aito adi kaba táoya goi sivataoedi. E kowalayadi goi arekoyadi sivakosainedi. ");
INSERT INTO gvs_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","E búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi sikabidi, gíluma ana tokatanaki sivini, ali ana kaba siu ana taboda kaarekoina igilumi. Go tabodayana ana mamanao moe ovanima ovayuwo. E kówala aivasi adi kaba táoya goi sivataoedi go, kowalayadi goi tabodayana sivakosaine. ");
INSERT INTO gvs_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kówala liliudi ali goi madi rini siriba be nakae madi kaba talagegeta siriba. Go kowalayadi adi kaba táoya moe kopwa. ");
INSERT INTO gvs_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ali ana mamanao moe ova 30 go, ana papaeva moe ovayawou ovanima. Go aliyana ana tukotuko moe ovatayamo panetayataya. Aliyana moe areko dedevidi go, kówala adi kaba táoya moe kopwa. ");
INSERT INTO gvs_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Guna Kaba Kaiyakayana ana turu liliudi kopwa. E nakae ana kaba kokavata be nakae ali ana kaba kokavata liliudi moe kopwa.’ ");
INSERT INTO gvs_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","E Yauwe tuwaina kana, ‘Isileli tubunao kulatuwokōidi latuwogu sina oribe mumuna pokaka sikabi rampa manuna, e bei rampayadi lavilavi tamo tamo silotuvaninimidi sininínima. ");
INSERT INTO gvs_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Guna Kaba Valoboda sinaena go, vabodaupa kaarekoina toluyena, e rampa adi kaba yata bei ikaaiyaka. Latuwogu rampayadi Eroni ma natunao sirugwausidi sininínima lavilavi ina nobuyana. Ame lovinayana ikaiyako vata Isileli tubunao yaimi.’ ");
INSERT INTO gvs_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","E Yauwe tuwaina kana, ‘Isileli tubunao yaidi goi siyam Eroni ma natunao Nadabi, Abaiu, Eliyasa be Itamari kom kududuwēdi sima kuvagitakōidi yaigu bei kidi guna tonuwalayao sipaaisewa umagu. ");
INSERT INTO gvs_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tomota kulatuwokōidi latuwogu Eroniyana ana kwama sigilumidi kimaasabaidi ina paisewa ana kilágata manuna be ana wowoina manuna. ");
INSERT INTO gvs_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","E ava korotova madi nuwopolala neta nuwopolala bogina aavinidi kulatuwokōidi Eroni ana kwama sigilumidi bei kwamayadi pasidi tauyana kimaasabaina, e kina guna Tonúwala nakae ipaaisewa manugu. ");
INSERT INTO gvs_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ame kwamayadi bei sigilumidi: Kasikasina ana saisaira, tolobona ana kwama, kwama maanawena, saidibuna maanawena, dábana aba vatúmna be gigipáiwala. Tauna nakae Eroni ma natunao adi kwama sigilumidi kimaasabaidi guna paisewa manuna, e tauyadi itoboinedi guna Tonuwalayao nakae sipaaisewa manugu. ");
INSERT INTO gvs_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Tauyadi tokatanaki búyala goura siwodugudi be búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi sikabidi, Tonúwala ana kwama ana gíluma manuna.’ ");
INSERT INTO gvs_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","E Yauwe tuwaina kana, ‘Gíluma ana tokatanaki kulatuwōko latuwogu búyala goura be búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi ikabidi, Tonúwala tolobona ana kwama igilumi ame nakae: ");
INSERT INTO gvs_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Aba latuba aiyuwo sigilumidi, e kwamayadi aiyuwo matakubudi goi igilumipatukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ikavava, kwamayana ana gigipáiwala igilumidoko, ana kaigigita dedevina toina. Go gigipaiwalayana kwama goi igilumipatuko. Ana búyala be ana kareko moe kwamayana nakae. ");
INSERT INTO gvs_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Gurewa esaaesaidi anikisi aiyuwo ikabidi, e yatadi goi Isileli natunao yawou aiyuwo yoidi iginidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Youyadi ainima tayamo gurewa tayamo goi, e ainima tayamo moe gurewa aiyuwoina goi go, adi bíbina goi iginidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","13","Gínina ana tokatanaki yoidiyadi iginidi. Iginidi ikavava, e goura goi gurewayadi adi kaba yata imadagidi maisidi dedevidi. Ikavava, gurewayadi adi kaba yata goi ikauvapotedi go, tolobona ana kwama ana kaba latubayadi yatadi goi ikauvapotedi. Gurewayadi moe aba nuwokavata bego tauyana imi katumapu. E tuta tamo tamo Eroni isiu ima Yau Yauwe matagu goi, tauyana Isileli natunao yoidi ikavaledi aba nuwokavata manuna. ");
INSERT INTO gvs_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","E ikauvapotedi ikavava, goura maavadaina goi seni nakae aiyuwo inoedi. Inoedi ikavava, gurewayadi adi kaba yata goi ikauvapotedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","E Yauwe tuwaina kana, ‘Gíluma ana tokatanaki kulatuwōko latuwogu kasikasina ana saisaira sigilumi. Kasikasina ana saisairayana goi itoboinemi guna nuwonúwana koyagoi. Ana gíluma nakae tolobona ana kwama ana gíluma. Moe búyala noyanoyaidi goura, buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi ikabidi, tabodayana igilumi. ");
INSERT INTO gvs_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Tabodayana bei inunumi, ana mamanao be nakae ana papaeva sivavasa, moe nimakulemwasi aito. ");
INSERT INTO gvs_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tabodayana goi gurewa esaaesaidi túwana aivasi goi ikauvapotedi. Túwana vakuumgoina goi gurewayadi yoidi rubi, topasi be beleli iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Túwana aiyuwoina goi gurewayadi yoidi turakoisi, sapaire be emeradi iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Túwana aitonina goi gurewayadi yoidi diyasinta, ágeta be ametísta iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Túwana aivasina goi gurewayadi yoidi kwatisi, anikisi be diyáspa iyatoidi. Ame gurewayadi adi kaba yata moe goura goi bei ikauvapotedi. ");
INSERT INTO gvs_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Gurewayadi tamo tamo goi Isileli natunao yawou aiyuwo yoidi tamo tamo iginidi. Tauna gurewa tayamo, you tayamo, gurewa tayamo, you tayamo. Youyadi Isileli tubunao adi dala yoidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tuwaina gíluma ana tokatanaki kulatuwōko goura maavadaina bei ikabi, kasikasina ana saisaira ana seni nakae inoedi. ");
INSERT INTO gvs_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kasikasina ana saisaira matakubuna aiyuwo diligaemaina goi rini goura aiyuwo ikauvapotedi. ");
INSERT INTO gvs_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ikavava, seniyadi goura tayamo dadavina isikoidi riniyadi goi ");
INSERT INTO gvs_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","go, tayamo dadavina gurewa adi kaba yata aiyuwo goi isikoidi. Aba yatayadi sikaiyaka tolobona ana kwama ana kaba latuba aiyuwo goi. ");
INSERT INTO gvs_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Niga rini goura aiyuwo imadagidi, e kasikasina ana saisaira ogalaoina goi iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ikavava, rini goura aiyuwo tuwaina imadagidi, tolobona ana kwama ana sinapatúkwana goi iyatoidi. Go moe gigipáiwala dedevina diligaemaina goi be nakae kwamayana kukuna goi. ");
INSERT INTO gvs_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ikavava, búyala buruu aiyuwo ikabidi, tayamo dadavina isikoidi rini aiyuwo kasikasina ana saisaira ogalaoina goi go, tayamo dadavina isikoidi rini aiyuwo tolobona ana kwama goi. Tauna kasikasina ana saisairayana ikaaiyaka gigipáiwala dedevina diligaemaina, e geya itoboineyeta italigalígava tolobona ana kwama goi. ");
INSERT INTO gvs_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","E tutayana Eroni isiu ima Bateta Kimaasabaina goi, e Isileli tubunao yoidi moe kasikasina ana saisaira goi ikaavaledi, tauna tuta liliuna moe aba nuwokavata matagu goi. ");
INSERT INTO gvs_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tabodayana sinaena goi aba yagoina aiyuwo yoidi Urim be Tumim kudodōidi sikaaiyaka. E tutayana Eroniyana isiu ima Yau Yauwe matagu goi kasikasina ana saisaira ilosi, e bei sinaena aba yagoinayadi ikavaledi. Go aba yagoinayadi goi bei iyagoi guna lovina nakonakae Isileli tubunao manumi.’ ");
INSERT INTO gvs_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","E Yauwe tuwaina kana, ‘Kwama tayamo maanawena ikaaiyaka tolobona ana kwama sinaena. Tomota kulatuwokōidi kwamayana sigilumi madabokina buruu kaka. ");
INSERT INTO gvs_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","E kwamayana goi tapora tayamo Tonúwala nukotona manuna siwodugu. Taporayana kikina sikunupedoko, tauna kwamayana geya itoboineyeta itaisa. ");
INSERT INTO gvs_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sigilumi ikavava, búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi, mogolu keuwoina maisiyana sigilumidi, e kwamayana kikina ditonema dadavina goi sisikoidi. E nakae goura maavadaina sikabi, bere giyaidi simadagidi. Ikavava, kwamayana kikina ditonema dadavina goi sisikoidi mogolu nauyayanaidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Tauna bere tayamo mogolu tayamo, bere tayamo mogolu tayamo kwamayana kikina madabokina ivaníbita nakae. ");
INSERT INTO gvs_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Moe kwamayana Eroni bei ilosi tutayana Tonúwala ana paisewa iguinuwedi umagu. Go bereyadi sitaitáiya tutayana Bateta Kimaasabaina goi isiu ima Yau Yauwe matagu goi o isowoduwomna. E imaiko go, adi táiya bogina anove, govila bei ikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi goura maavadaina sikabi dabayogigi simadagi senina maisiyana, e yatana goi sigini kadi, “Ame Tauyana Kimaasabaina Yauwe Umana.” ");
INSERT INTO gvs_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ikavava, búyala buruu sikabi, peperuyana dabana goi dabayogigi sisiko. ");
INSERT INTO gvs_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","E dabayogigiyana Eroni dabana goi ikaaiyaka, e bei Isileli tubunao idi goyo ikabidi inavedi. Goyoyadi unana nakona madi goyo idi vininabeso sikimasabedi Yau Yauwe umagu. Tauna dabayogigiyana ikaiyaka dabana goi tutayana isiu ima matagu goi, e bei Yau Yauwe agite go, idi vininabesoyadi auyaonedi. ");
INSERT INTO gvs_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tomota kulatuwokōidi areko dedevina sikabi, gíluma ana tokatanaki sivini kwama tayamo saidibuna maanawena, dábana aba vatúmna be nakae gigipáiwala igilumidi. ");
INSERT INTO gvs_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Tomota kulatuwokōidi Eroni natunao koroto nakae adi kwama maanawedi, adi gigipáiwala be adi peperu sigilumidi idi paisewa ana kilágata manuna be ana wowoina manuna. ");
INSERT INTO gvs_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Kwamayadi Eroni ma natunao kuvalosīdi. Ikavava, pútuma kwābi, kuputumīdi. Kuputumidi ikavava, kukaipakuyēdi bei paisewayana nimadi goi kuyāto be nakae kukimasabēdi umagu, e bei itoboinedi Tonúwala nakae sipaisewa umagu. ");
INSERT INTO gvs_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Gíluma ana tokatanakiyao kulatuwokōidi tarausisi aba saidibuna Eroni ma natunao manudi sigilumidi, e talaidi sivatumdi. Tarausisiyadi adi mamanao tolobodi goi sisou sina dibuwatudi goi ikaluvila. ");
INSERT INTO gvs_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Eroni ma natunao bei silosidi tutayana guna Kaba Valoboda goi sisiu o neta Bateta Kimaasabaina goi sisiu sima aba kasala goi bego sipaisewa yaigu, govila bei idi tapepeko adi kiyaya sibabane, moe ámasa. Moe lovinayana ikaiyako vata tauyana be natunao be tubunao yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","E Yauwe tuwaina kana, ‘E ame kuguinūwe tutayana Eroni ma natunao kukimasabedi umagu, e bei guna Tonuwalayao nakae sipaisewa manugu: Bulumakau natuna bolamo tayamo be nakae sipi bolamo dedevidi aiyuwo kwabīdi. ");
INSERT INTO gvs_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ikavava, parawa dedevina kwābi, beredi pokaka taiyao kugabūdi. Go berediyadi maniyedi pokaka, oribe mumuna tuwo. Maniyedi oribe mumuna taiyao kupopolīdi. E nakae maniyedi kakaaraiidi go, oribe mumuna kokikilīdi. ");
INSERT INTO gvs_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ikavava, berediyadi bayao tayamo goi kudodōidi, e bayaoyana kūme guna Kaba Valoboda totomna goi tutayana bulumakauyana be sipiyadi bolamo aiyuwo bego kukasaledi yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Go Eroni ma natunao, e adi kasala manuna kumēdi guna Kaba Valobodayana totomna goi kuvaisivēdi. ");
INSERT INTO gvs_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kuvaisivedi ikavava, baige Tonúwala ana kwama kwabīdi, e Eroni kuvalōsi ame nakae: Mainao kwama saidibuna maanawena, namliyeta kwama maanawena buruu kuvalōsi. Ikavava, e tolobona ana kwama kuvalōsi baige kasikasina ana saisaira kuvalōsi. Madabokina ikavava, e gigipáiwala dedevina kusīko. ");
INSERT INTO gvs_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kusiko ikavava, e dábana aba vatúmna kukailagāsi. Niga dabayogigi kimaasabaina peperu goi kusīko. ");
INSERT INTO gvs_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ikavava, pútuma aba kaipaku kwābi, Eroni dabana kuputūmi bei tauyana kiinavaina umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Go Eroni natunao kumēdi, kwama saidibuna maanawedi kuvalosīdi. ");
INSERT INTO gvs_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Nakae adi gigipáiwala kusikōidi, adi peperu dabadi goi kwailagasīdi. Moeko goi itoboinedi sietonúwala go, paisewayana guna lovina goi ikaiyako vata kidi ma natudiyao be tubudiyao yaidi. Tauna nakae paisewayana Eroni ma natunao nimadi goi kuyāto. ");
INSERT INTO gvs_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","E bulumakauyana kūme guna Kaba Valoboda totomna goi go, Eroni ma natunao kulatuwokōidi bulumakauyana dabana goi nimadi siyatōidi. ");
INSERT INTO gvs_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Niga bulumakauyana matagu goi kukaumāte go, ikaikaina idau ina noko goi kusaligōgo. ");
INSERT INTO gvs_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kukaumate ikavava, ikaikaina goi nimam kusavakutūi, e aba kasala ana sakusaku goi kumigīdi go, aba kasalayana unana goi ikaikayana madabokina kusiwōi. ");
INSERT INTO gvs_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ikavava, posinaena be diyauwouwosina be nakae vivina aiyuwo ma sabalidi kukabīdi, aba kasala goi kugabūdi, e bei aubowoidi situko sima. Moe idi vininabeso yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Go bulumakauyana iwoina, sakavaina be nakae taena, e kwabīdi, kunavēdi imi tunagu moetala goi kugabusavēdi. Moe bágala adi vininabeso. ");
INSERT INTO gvs_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","E sipi bolamo tayamo kukābi, e dabana goi Eroni ma natunao nimadi siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Ikavava, sipiyana kukaumāte go, ikaikaina kwābi, yoguyogu ana kaba kasala kuseulinibīsi. ");
INSERT INTO gvs_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Go sipiyana moe kupilūmi. Ikavava, talainao liliudi be kaga liliuna posinae sinaena be nakae aena kunikīdi. Ikavava, talainao be bulubuluna yatadi goi kuyatōidi. ");
INSERT INTO gvs_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Kuyatoidi ikavava, sipi talainaoyadi kugabūdi be kuvakasavēdi Yau Yauwe yaigu. Moe yabobona awoinuna aubowoina ituko ima mainina dedevina ivauyaonegu. ");
INSERT INTO gvs_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","E sipi bolamo aiyuwoina kukābi, e dabana goi Eroni ma natunao nimadi siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ikavava, sipiyana kukaumāte go, ikaikaina noko goi kusaligōgo. Ikavava, Eroni ma natunao taiyadi be nimatubutubudi be nakae aetubutubudi kakataidi kumigīdi. Ikavava, ikaikayana madabokina kwābi, aba kasala kuseulinibīsi. ");
INSERT INTO gvs_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Go ikaikayana maniyena aba kasala goi be nakae pútuma aba kaipaku kwabīdi, Eroni ma natunao madi kwama kuseulīdi. Moe nakae kidi madi kwama kukimasabedi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","E sipiyana sabalina, yuyuna sabalina, posinaena, diyauwouwosina, vivina aiyuwo ma sabalidi be nakae dibuwatuna kakataina kwabīdi. Ame sipiyana moe tauyadi adi kimasaba umagu manuna. ");
INSERT INTO gvs_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","E moe dogoiyadi kwabīdi be nakae beredi geya adi istimo ma bayaoina Yau Yauwe matagu goi ikaaiyaka, e beredi aito kwabīdi, tayamo pokaka, tayamo oribe mumuna taiyao be tayamo oribe mumuna kukikīli. ");
INSERT INTO gvs_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","E kwabīdi, Eroni ma natunao nimadi goi kuyatōidi go, nimadi sikatulagasidi, dogoiyadi sikasaledi Yau Yauwe yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ikavava, dogoiyadi kwabimnēidi, sipi bolamo vakuumgoina aba kasala goi kukailagasīdi, kuvakasavēdi. E aubowoina ituko ima, Yau Yauwe mainina dedevina ivauyaonegu. Moe yabobona awoinuna yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","E sipiyana bolamo aiyuwoina Eroni ana kimasaba manuna, e kukuna kwābi, kwatulagāsi kukasāle Yau Yauwe yaigu. Moe talainayana kom im kaiguyau. ");
INSERT INTO gvs_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tutayana koroto kukimasabe Tonúwala umagu, mainao sipi bolamo guna Tonuwalayao adi kimasaba manuna, e kukuna kailaagasina be nakae dibuwatuna vagidi ana vininabeso goi kukabīdi kukimasabēdi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","E ame tutayana be nakae tuta simamaima lovina ame ikaiyako vata: Neta tomota tuboina ana vininabeso yoguyoguna sikasaledi yaigu, e yoguyoguyadi kukudi be dibuwatudi moe Eroni mana bodao Tonúwala adi kaiguyau. Moe idi vagidi ana vininabeso Yau Yauwe yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","E Eroni ina kámasa mlina, ina obáila kimaasabaidi natunao bei sikabidi, e bei Eroni ana katumapu tayamo ilosidi. Ikavava, pútuma aba kaipaku kwābi, kukaipakūye be paisewayana nimadi goi kuyāto. ");
INSERT INTO gvs_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Go ava natuna bei itáoya Tonúwala, e tutayana igimiima guna Kaba Valoboda goi isiu ima Bateta Kimaasabaina goi núwala ana paisewa iguinuwedi yaigu, kwamayadi iilosidi maliyalina ana badabada ainima aiyuwo. ");
INSERT INTO gvs_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","E sipi bolamo Eroni ana kimasaba manuna go, iwoina kwābi, kūme guna Kaba Valoboda ana moteo kimaasabaina goi kuvaipolūye. ");
INSERT INTO gvs_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ikavava, Eroni ma natunao bei sima guna Kaba Valoboda totomna goi sipi bolamo iwoinayana be berediyadi ma bayaoidi sikáika. ");
INSERT INTO gvs_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Amo nakae vininabesoyadi bei sikáika. Vininabesoyadi goi idi goyo sinuwolidi boi tutayana Eroni ma natunao nimadi goi paisewayana kuyato be nakae kukimasabedi umagu. Tauna nakae bei sikáika go, tomota besobeso taabu sikanikāni. Iwayayana be nakae berediyadi moe kimaasabaidi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Go neta vanuwo itomo iwoinayana be nakae berediyadi Tonúwala adi kimasaba manuna kesakesaidi, e kukabīdi, kugabusavēdi. Taabu tomota siikanīdi. Iwoinayana be nakae berediyadi moe kimaasabaidi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","E tauna nakae kuguinūwe Eroni ma natunao yaidi nakae kaga liliuna bogina alatuwokoim. Maliyalina ana badabada ainima aiyuwo goi moe guinuwayadi kuguuinuwēdi tutayana paisewayana nimadi goi kuyato. ");
INSERT INTO gvs_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Go bulumakau tomota idi bágala adi núwala manuna maliyalina tamo tamo goi kukaumāte kugabusāve. E nakae aba kasalayana kukimavāde. Ikavava, pútuma aba kaipaku kwābi kuputūmi bei kukimasabe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","E maliyalina ainima aiyuwo goi nakae kuguuinūwe, e bei aba kasalayana kimaasabaina toina umagu. Kaga neta ibisikone, itoboine dogoiyana bogina kimaasabaina umagu.’ ");
INSERT INTO gvs_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","E Yauwe tuwaina kana, ‘Guna Tonuwalayao kulatuwokōidi aba kasala goi ame sigabusavedi sikasaledi maliyalina tamo tamo yaigu: Lami aiyuwo, tamo tamo adi tala tayamo bogina sibabane. ");
INSERT INTO gvs_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Lami tayamo nobuyana goi sikasale yaigu go, lami aiyuwoina lavilavi. ");
INSERT INTO gvs_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Go lami vakuumgoina ana kasala manuna parawa dedevina ma nokoina giyaina be oribe mumuna dedevina toina lita tayamo taiyao sikabidi, sipopolidi. Ikavava, siyato lamiyana taiyao. E nakae oine lita tayamo sikabi, sisiwoi aba kasala goi lamiyana taiyao sikasaledi yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Go lamiyana aiyuwoina moe lavilavi goi sikasale Yau Yauwe yaigu. Ago imi vininabeso kutukutu be nakae oine kokasalēdi nobuyana nakae. Tauna tutayana sivaakasave, aubowoina ituko ima, e mainina dedevina ivauyaonegu. Moe yabobona awoinuna yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ame tuta be nakae tuta simamaima guna Tonuwalayao bei sima guna Kaba Valoboda totomna goi yoguyogu sigabudi sivakasavedi go, sikasaledi Yau Yauwe yaigu. Guna Kaba Valobodayana goi bei avalobodemi be avadigoimi. ");
INSERT INTO gvs_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Komi Isileli tubunao amoko goi bei avalobodemi go, guna togaga ana káeyana bei isiu guna Kaba Kaiyaka ikimasabe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Moitamo. Guna Kaba Valobodayana be nakae aba kasalayana bei akimasabedi umagu. Aiyuwoina Eroni ma natunao akimasabedi umagu, e bei tauyadi itoboinedi guna Tonuwalayao nakae sipaisewa yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Bei akaaiyaka Isileli tubunao yaimi. Yau bei imi Yaubada. ");
INSERT INTO gvs_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Komi bei koyagoigu Yau Yauwe imi Yaubada boi Itipita goi akabimi amemi, e bei itoboinegu akaaiyaka yaimi. Yau Yauwe imi Yaubada.’ ");
INSERT INTO gvs_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","E Yauwe tuwaina kana, ‘Tomota kulatuwokōidi gaigíyala taalaidi sikabidi, insensi ana kaba kasala simadagi bei yatana insensi sigabugabu. ");
INSERT INTO gvs_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Aba kasalayana ana mamanao be nakae ana papaeva moe aba katugúyala go, ana tukotuko panetayataya kasikasi. Go ana sakusaku aivasi matakubuna goi siyatoidi. Go sakusakuyadi be aba kasala alova tayamo goi simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Simadagi ikavava, goura maavadaina go, paaevaidi sikabidi, aba kasalayana goi sikaupatukoidi. Tauna madabokina goura. Sikaupatukoidi ikavava, e kinababaina goi ana papa goura sikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Ikavava, e rini aiyuwo goura simadagidi, ana papa kikina go, sobuyekoina goi sikaupatukoidi, dadavina tayamo, dadavina tayamo. Riniyadi moe aitakeo manudi. ");
INSERT INTO gvs_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Sikaupatukoidi ikavava, e aba kasalayana ana kaitakeo aiyuwo gaigíyala sibobóidi, goura paaevaidi goi sipaimidi. ");
INSERT INTO gvs_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","E aba kasalayana vabodaupa kaarekoina toluyena goi siyatogamogamone. Vabodaupayana aba vatulúkwana dedeogaina mana kaba núwala itabode. Amoko goi bei avalobodem. ");
INSERT INTO gvs_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Nobuyana tamo tamo goi Eroni bei isiusiu ima rampa ivadadedi bei insensi mainina dedevina iiyatoidi aba kasalayana yatana goi igabudi sivakaubowo. ");
INSERT INTO gvs_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Tutayana Eroni isiu lavilavi tamo tamo goi bego rampayadi ikatubayasidi, e aba kasala yatana goi insensi bei igabu. Nakae bei iguuinuwe tuta ame be nakae tuta simamaima, e bei insensiyana ivakaaubowo Yau Yauwe yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Go aba kasalayana goi taabu insensi besobeso igabugābu. Aiyuwoina yoguyogu vininabeso manuna taabu yatana goi igaabusāve. Nakae kutukutu vininabeso manuna taabu yatana goi igabugābu. Oine vininabeso manuna nakae taabu yatana goi iisiwōi. ");
INSERT INTO gvs_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Go tala tamo tamo goi sivatayamo aba kasalayana bei ikimavade ame nakae: E tomota idi bágala adi núwala manuna yoguyogu ikaumate go, ikaikaina ikabi, insensi ana kaba kasalayana ana sakusaku imigidi. Tauna nakae bei iguuinuwe tala tamo tamo ame tutayana be nakae tuta simamaima. Ame aba kasalayana moe kimaasabaina toina Yau Yauwe umagu.’ ");
INSERT INTO gvs_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","‘Tutayana Isileli tubunao kwatuyaividi yaviya manuna, e koroto tamo tamo yawoidi sitatetēdi Yau Yauwe yaigu, govila bei sivailai tutayana kwatuyaividi. ");
INSERT INTO gvs_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ava koroto neta kwatuyaivi, siriba tayamo moe idi vagidi Yau Yauwe yaigu. Siribayana siisikere Yau guna Kaba Kaiyaka Kimaasabaina ana lovina goi sisikere. ");
INSERT INTO gvs_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Kidi adi tala 20 nakae ituko, neta kwatuyaividi, e idi vagidi bei sikasale Yau Yauwe yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","E kidi go toesaesa taabu idi vininabeso sivaaitūwe. Kidi go tookaidi taabu idi vininabeso sikupokūpo. Go sem liliudi nakae siriba tayamo moe idi vagidi Yau Yauwe yaigu adi núwala manuna. ");
INSERT INTO gvs_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Núwala ana vininabeso mani Isileli tubunao yaidi goi kwabīdi. Vininabesoyadi moe guna Kaba Valoboda ana rugwáuta manuna. Ame vininabesoyadi moe Isileli tubunao idi kaba nuwokavata Yau Yauwe matagu goi adi núwala manuna.’ ");
INSERT INTO gvs_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","‘Tomotayadi kulatuwokōidi nokobaba ma kaena kopwa simadagi. Nokobabayana moe aba níkina. Simadagi ikavava, guna Kaba Valobodayana be aba kasala kopwa go, nauyayanaidi goi siyato. Go nokobabayana goi bwae sisiwoi. ");
INSERT INTO gvs_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","E bwaeyana goi Eroni ma natunao nimadi be aedi sinikidi. ");
INSERT INTO gvs_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Tutayana guna Kaba Valobodayana goi bego sisiu o tutayana sivalabelabena aba kasala kopwa goi bei yabobona awoinuna Yau Yauwe yaigu sivakasave, e itoboinedi mainao bwae goi sisiwo, govila bei sikámasa. ");
INSERT INTO gvs_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Itoboinedi nimadi be aedi sinikidi, govila bei sikámasa. Ame lovinayana ikaiyako vata Eroni ma natunao be nakae tubunao yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","‘Tomotayadi kulatuwokōidi latuwogu alova maniyedi sakavaidi be náuna lamna maa mainidi dedevidi sikabidi, sikelidi pauda nakae. Alovayadi be naunayana ame nakae: Alovamamaina sisina kilo ana badabada ainima tayamo, alova sinamoni kilo aito, alova kalamasi kilo ana badabada aito, ");
INSERT INTO gvs_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","e alova kesiya kilo ana badabada ainima tayamo sikabidi. Liliudi adi moumou sisiikeredi nakae guna Kaba Kaiyaka Kimaasabaina ana lovina goi sisikeredi. Alovayadi sikabidi ikavava, oribe mumuna lita aivasi sikabidi ");
INSERT INTO gvs_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","go, avatau neta pútuma ana tokatanaki sivini, e pútuma aba kaipaku imadagi namliyeta ikimasabe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","E putumayana kukābi, kónana liliudi kuputumīdi bei konaniyadi kiinavaidi paisewa umagu. Konaniyadi ame nakae: Guna Kaba Valoboda yoyou be aba vatulúkwana dedeogaina, ");
INSERT INTO gvs_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","teboro ma konanina, rampa adi kaba yata ma konanina, insensi ana kaba kasala ma konanina, ");
INSERT INTO gvs_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","aba kasala vininabeso ana kaigabu manuna ma konanina be nakae nokobaba ma kaena kopa, e ame konaninayadi liliudi kwaipakuyēdi. ");
INSERT INTO gvs_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ikavava, kukimasabēdi umagu bei liliudi kimaasabaidi toina. Tauna avatau neta ibisikonedi, e itoboine tauyana bogina kimaasabaina Yau umagu. Neta ava kónana ibisikonedi, e itoboine konaniyana nakae bogina kimaasabaina Yau umagu. ");
INSERT INTO gvs_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","E pútuma kwābi, Eroni ma natunao goi kusiwōidi be kukimasabēdi umagu bei kidi Tonúwala nakae sipaaisewa manugu. ");
INSERT INTO gvs_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","E Isileli tubunao kulatuwokōidi kam, “Pútuma aba kaipaku ame moe kimaasabaina umagu, tauna guna paisewa manuna ame tuta be nakae tuta simamaima. ");
INSERT INTO gvs_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Taabu tomota besobeso goi koosiwōidi. Taabu putumayana ana pópwala kovatootowōne bei pútuma tayamo nakae komadagi. Putumayana kimaasabaina umagu, tauna kowowōine. ");
INSERT INTO gvs_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Avatau neta putumayana ivatotowone bego tayamo pútuma imadagi o avatau neta putumayana ikabi, tomota besobeso goi isiwoi, e amo tauyana geya guna boda geya, tauna yaimi goi kolivisīye go, kovatapīye.”’ ");
INSERT INTO gvs_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","E Yauwe tuwaina ilatuwokoigu idigo kana, ‘Tomotayadi kulatuwokōidi latuwogu sina náuna sitakite sisina, kapikapiwo valakikidi sikabidi, situtudi be nakae náuna galabanum bwaena be aidekoko sisina pokaka sikabidi. Tamo tamo adi moumou nakae. ");
INSERT INTO gvs_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","E sikabidi, insensi ana tomadágina, tauyana tokatanaki, sivini insensi imadagi. Ikavava, soroti isiwoi. E insensiyana maavadaina be nakae kimaasabaina umagu, tauna guna paisewa manuna. ");
INSERT INTO gvs_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Insensi sikabi, situtu pauda nakae. Ikavava, e maniyena sikabi, sime guna Kaba Valoboda goi sisiu, e aba vatulúkwana dedeogaina matana goi siyato. Amoko goi bei avalobodem. Go ame insensiyana moe kokimasabe bei kimaasabaina toina yaimi. ");
INSERT INTO gvs_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ame insensiyana bei siimadagi, tomota taabu siimadāgi nakae toinidi manudi. Ame insensiyana kimaasabaina Yau Yauwe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Avatau neta insensiyana imadagi toinina ina pútuma manuna, e tauyana geya guna boda geya, tauna yaimi goi kolivisīye go, kovatapīye.’ ");
INSERT INTO gvs_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","‘Kunōve. Ure, ma Yuda, natuna moe Uri, e tubuna moe Besaleli. Ame tauyana bogina akinave. ");
INSERT INTO gvs_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Tauyana bogina avakayaodei Yau Yaubada Balomaigu goi, tauna mana nanamsa be mana yagoina be mana kabitam nakae ana kaipata paisewa liliudi dedevidi iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Tauyana ana katanaki goura be siriba be nakae kopwa adi paisewa goi. ");
INSERT INTO gvs_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Nakae gurewa esaaesaidi adi paisewa be nakae alova ana dayágina bogina ana kaipata iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","E kunovēgu. Akisamaki ma Dani natuna yoina Oliyavi bogina akinave bei ipaisewa Besaleli taiyao. Guna nuwopolala topaisewa liliudi bogina avinidi bei tauyadi adi kaipata kaga liliuna alatuuwokoim simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Dogoiyadi ame nakae: Guna Kaba Valoboda, aba vatulúkwana dedeogaina, aba núwala dedeogayana yatana, guna Kaba Valobodayana konanina liliudi. ");
INSERT INTO gvs_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Konaninayadi ame nakae: Teboro ma konanina, rampa adi kaba yata goura maavadaina ma konanina, insensi ana kaba kasala, ");
INSERT INTO gvs_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","aba kasala vininabeso ana kaigabu manuna ma konanina, nokobaba ma kaena kopa, ");
INSERT INTO gvs_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Tonúwala Eroni ma natunao adi kwama dedevidi be kimaasabaidi adi paisewa manuna, ");
INSERT INTO gvs_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","pútuma aba kaipaku be nakae insensi mainina dedevina Bateta Kimaasabaina manuna. Moe dogoiyadi bei simadagidi nakae bogina alovinaem.’ ");
INSERT INTO gvs_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","E Yauwe tuwaina ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","‘E kom Isileli tubunao kulatuwokōidi kudīgo kam, “Yauwe ilovinaeda kana, ‘Yau guna maliyalina aba waiwasi ana lovina kokabiikaōne. Maliyalinayana aba kinana komi be Yau Yauwe yaida ame tuta be nakae tuta simamaima bei koyagoi bego Yau Yauwe bogina akimasabemi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Maliyalina aba waiwasiyana komatakavāte. Ame maliyalinayana kimaasabaina yaimi. Avatau neta ikibaibaili, tauyana kokaumāte. Avatau neta amo maliyalinayana goi paisewa tayamo toito iguinuwe, tauyana geya guna boda geya, tauna yaimi goi kolivisīye go, kovatapīye. ");
INSERT INTO gvs_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Maliyalina ana badabada ainima tayamo goi imi paisewa koguuinuwēdi go, maliyalinayana ainima aiyuwoina moe aba waiwasi, paisewa goi kosayāta; moe kimaasabaina Yau Yauwe umagu. Avatau neta amo maliyalinayana goi ipaisewa, kokaumateyāmo. ");
INSERT INTO gvs_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Komi Isileli tubunao maliyalina aba waiwasi ana lovina kokabiikaōne tuta liliuna. Maliyalinayana moe guna kanasíuna ikaiyako vata yaimi goi. Tauna malamalágata tamo tamo simamaima bei sikabiikaone. ");
INSERT INTO gvs_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ame aba kinanayana ikaiyako vata komi be Yau Yauwe yaida. Yau nakae. Maliyalina ainima tayamo goi yábana be poyapoya amadagidi go, maliyalina ainima aiyuwoina goi paisewa asayata bei awaiwasi.’”’ ");
INSERT INTO gvs_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","E Koya Sainai yatana goi Yauwe ibóbwara ikavava, e gurewa aiyuwo paaevaidi ivinigu. Gurewayadi yatadi Yaubada toinina nimana goi ina kanasíuna ana kaba vatulúkwana bogina iginidi. ");
INSERT INTO gvs_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","E tomotayadi bogina sigite yau koya goi nava geya asouta, go sem tuta maanawena akaaiyaka. Tuwo sima sigúguna go, Eroni yaina sidigo kadi, ‘Kutāoya ida basaleliuyao adi tokwaluyao kumadagīdi bei sivakededa. Amo Moseseyana, tauyana Itipita goi iikabida imemeda, geya tayagoiyeta kaga nakona iisowóduwo yaina, tauna ikaimúmuna.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Tuwo Eroni idigo kana, ‘Monemiyao, natumiyao idi gipolu goura kokitakīdi komēdi kovinīgu.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tuwo moitamo tomotayadi idi gipolu goura sikitakidi simedi Eroniyana sivini. ");
INSERT INTO gvs_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Gipoluyadi ikabidi, ikaupapaevedi. Ikaupapaevedi ikavava, bulumakau bonatuna maisiyana imadagi. Ikavava, e tomotayadi sidigo kadi, ‘Kita Isileli tubunao, ame ida basaleliu boi Itipita goi ikalaoduweda!’ ");
INSERT INTO gvs_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Eroni igite kaga siguinuwe, e bulumakauyana matana goi aba kasala tayamo ikaudakodako. Ikavava, idigo kana, ‘Itomo uyáwana aikanina taodūgu Yauwe yaina.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Tuwo vanuwo itomo nobuyana giyaina sitáoya sina idi yoguyoguyao vininabeso manuna sikaumatedi. Maniyedi sigabudi sivakasavedi go, sikasaledi Yauwe yaina. Go maniyedi sigabudimo idi kabivekoveko vininabeso manuna. Sigabudi ikavava, e situsobu sikáika, oine sinim, siuyawana besobeso be taiyao simasisi goyogoyo. ");
INSERT INTO gvs_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","E Yauwe ilatuwokoigu idigo kana, ‘Woilīm kusōu kūna! Im bodao, tauyadi boi Itipita goi kwabidi kumemedi bogina toinidi sikaigoyaidi. ");
INSERT INTO gvs_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Enaoyana alatuuwokoidi sisabookuliye bogina sivasulaigi. Bulumakau bonatuna goura simadagi, yaina goi sivatugúyala sikanakabobo be nakae yoguyogu vininabeso manuna bogina sigabudi sivakasavedi go sikasaledi bulumakauyana yaina. Sidigo kadi, “Isileli tubunao, ame ida basaleliu Itipita goi ikalaoduweda.”’ ");
INSERT INTO gvs_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yauwe tuwaina kana, ‘Amo tomotayadi bogina agitedi, ayagoidokoidi. Kidi taiyadi tuntunidi. ");
INSERT INTO gvs_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Tauna ame taabu kusanaabodēgu, e bei magu egamogamogu toina yaidi amtulidi. Go kom amta bei akisailim, tubumowo boda tayamo gagaina.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Go yau akawanoi makimaki Yauwe guna Yaubada yaina adigo kagu, ‘O Yauwe, manakae kuegamogamogu im bodao yaidi? Amo tauyadi Itipita goi boi kukabidi, im togaga gagaina goi kumedi. ");
INSERT INTO gvs_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Manakae? Bego da Itipita sitagiwoim kadi, “Yauwe guinuwa goyogoyoina pasina ina bodao, kidi Isileli tubunao, Itipita goi ikabidi, imedi koya goi ikaumatedi, e bei geya maisidimo poyapoya ame goi”? ¡Neta taabu kuegamoogamōgu go, guinuwa goyogoyoina ame manuna kutugavīla! ");
INSERT INTO gvs_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Neta im pakonayao Eberamo, Aisake, be Isileli kunuwokavatēdi. Boi toinim yoim goi kukatótula yaidi kulatuwokoidi kam, “Tubumiyao bei akisailidi adi badabada nakae utuna yábana goi go, poyapoya ame ana madabokina boi adigedige tubumiyao bei avinidi, e kidi sikabi idi kaba lovina.”’ ");
INSERT INTO gvs_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","E tuwo moitamo Yauwe ina egamogamogu manuna itavívila, tauna boi vailai idigedige ina bodao geya ivinidita. ");
INSERT INTO gvs_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","E koyayana goi asou ana guna tovaita Iyosuwa taiyao go, gurewa aiyuwo paaevaidi nimagu goi akaavaledi. Gurewayadi yatadi Yaubada toinina nimana goi ina kanasíuna ana kaba vatulúkwana iginidi. Dadava yuwoyuwo goi iginidi. ");
INSERT INTO gvs_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Gurewayadi moe Yaubada ina guinuwa, e nakae gininayadi gurewa aiyuwo goi moe Yaubada toinina iginidi. ");
INSERT INTO gvs_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","E Iyosuwa itaaiyakeka go, tomota inovedi sitalamgemge, e ilatuwokoigu kana, ‘Ida tunagu goi ana taiyakeka nakae yaviya butukáona!’ ");
INSERT INTO gvs_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Go yau adigo kagu, ‘Ana taiyakeka geya yaviya ana tovakumgoyao idi duduwo geya. Nakae ana taiyakeka geya yaviya ana toneneta idi táiya geya. Go sem yau anove ana taiyakeka nakae tomota sivesivesi!’ ");
INSERT INTO gvs_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Tuwo kasou kana go, tutayana ima tunagu goi kavakakana, e akandobala bulumakau bonatunayana goura agite be nakae tomota silauláusa agitedi. Tuwo aegamogamogu toina, e gurewayadi aiyuwo alavedi sisou koya unana goi sitavisi. ");
INSERT INTO gvs_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Alavedi ikavava, abala ana bulumakauyana boi siimadagi akabi, yeu goi agabu iséwaya. Ikule ikavava, akauvetevete ana kadókana poyapoya kaukauna nakae, e bwae taiyao apopolidi go, Isileli tubunao alovinaedi sinim. ");
INSERT INTO gvs_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","E Eroni alatuwoko adigo kagu, ‘Ava goyo amo tomotayadi siguinuwe yaim bei kom im katumapu goi kuvakededi, e goyo gagaina siguinuwe?’ ");
INSERT INTO gvs_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Eroniyana idigo kana, ‘Guna tomoya, taabu kuegamoogamōgu yaigu. Amo tomotayadi kom bogina kuyagoidokoidi; kidi sinapu goyo nukotodi ikabi. ");
INSERT INTO gvs_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Silatuwokoigu kadi, “Ida basaleliu ana tokwalu manuda kumadāgi bei ivakededa. Amo korotoyana Mosese, tauyana Itipita goi ikalaoduweda, geya tayagoiyeta kaga nakona isowóduwo yaina, tauna ikaimúmuna.” ");
INSERT INTO gvs_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Tuwo alatuwokoidi kagu, “Avatau neta mana goura, e ikābi ivinīgu.” Tuwo sivinigu, gourayadi alavedi yeu sinaena goi. Go akandobala, e yeuyana goi ame bulumakau bonatunayana toinina isowóduwo!’ ");
INSERT INTO gvs_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Go akandobala tomotayadi agitedi siguinuwa owáowana unana Eroni itagonedi, tauna ama kaleyayao itoboinedi sikaiwotetema. ");
INSERT INTO gvs_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tuwo idi tunagu ana kaba siu goi atáoya, niyagu gagaina adigo kagu, ‘Avatauwa komi neta Yauwe ina bodao, kōma yaigu!’ E tuwo Livai tubunao liliudi sideli sima sigúguna yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Tuwo alatuwokoidi adigo kagu, ‘Yauwe kita Isileli tubunao ida Yaubada ibóbwara ame nakae, idigo kana, “Madabokimi imi sisi kokabīdi, e tunagu madabokidi goi koketōiya go, tuwowomiyao, ami gomanao, imi bodao be nakae semiyao kokaumatematēdi.”’ ");
INSERT INTO gvs_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","E tuwo moitamo Livai tubunao sitáoya, sina siguinuwe nakae alatuwokoidi. Tauna koroto adi badabada 3,000 ame maliyalinayana goi sikámasa. ");
INSERT INTO gvs_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","E Livai tubunao alatuwokoidi, adigo kagu, ‘Ame tuta Yauwe ikimasabemi toinina ina topaisewayao. Imi kabikáwana goi madabokimi bogina kotagona bego semiyao kokaumatedi, tauna Yauwe bei ikaipakuyemi.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","E vanuwo itomo ana tomotayadi alatuwokoidi adigo kagu, ‘Komi kobágala go, bagalayana gagaina. Ame bei atuko ana Yauwe yaina. Nakona itoboinegu imi bagalayana anuwoli.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tuwo moitamo atukomna ana Yauwe yaina, e adigo kagu, ‘Amo tomotayadi goyo gagaina bogina siguinuwe. Goura simadagi bego toinidi idi basaleliu. ");
INSERT INTO gvs_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Go Yauwe, akawanoi yaim bego ame tuta, neta im nuwonúwana nakae, idi bágala kunuwotao. Go neta geya, akawanoi yaim, im buki goi yoigu boi kuginigini, e kutaūwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Go kina Yauweyana idigo kana, ‘Avatauwa neta sitapepeko yaigu, e amo tauyadi yoidi bei guna buki goi atauwedi. ");
INSERT INTO gvs_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tuwo ame tuta kūna tomotayadi kuvakedēdi nako goi bogina alatuwokoim. Go kunōve. Guna anerose bei ivakumgoiyem. Go liuna ana maliyalina goi bei idi bágala pasina aliunedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tuwo Yauwe vísiya ietune ina tomotayadi yaidi goi unana Eroni silovinae bego bulumakau goura imadagi manudi. Tauna idi goyo pasidi vísiya sibabane. ");
INSERT INTO gvs_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","E nakae Yauwe ilatuwokoigu idigo kana, ‘Kutāoya, kom be nakae tomotayadi Itipita goi kukabidi kumemedi, taiyao kōna poyapoyayana boi Eberamo be Aisake be Yakobo yaidi akatotule kagu, “Tubumiyao poyapoya bei avinidi.” ");
INSERT INTO gvs_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Anerose tayamo bei aetune iwo ivakumgoiyemi. Go kidi toni poyapoya bei avatapiyedi sina. Tauyadi moe Kenani tubunao, Emori tubunao, Eta tubunao, Perisi tubunao, Ivai tubunao be nakae Iyebusi tubunao. ");
INSERT INTO gvs_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Poyapoyayana maaliina be lobooinina, tuwo komi kōna amoko goi go, maisigu bei avamoukoimi kutoto taiyami tuntunidi. Tauna geya awoita, govila bei enao goi akaumatematemi. Moe pasina guna aneroseyana bei ivakumgoiyemi.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","E tutayana ame livalayana moumouna sinove, nuwodi simou gagaina sitáiya, nakae liliudi sivabúbula. ");
INSERT INTO gvs_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Kutoto Yauwe bogina ilatuwokoigu kana, ‘Isileli tubunao kulatuwokōidi kam, “Komi moitamo taiyami tuntuniidi! Neta tuta kaakupina goi akaiyaka yaimi, bei amtulimi. Ame tuta imi pasapasa kovalilivīdi koyatōidi. Bei alovina manakaegu aguinuwe yaimi.”’ ");
INSERT INTO gvs_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","E tuwo moitamo Koya Korevi goi idi pasapasa sivalilividi, siyatoidi go, idi tuta Koya Koreviyana goi go, nakae tuta simamaima goi geya idi pasapasamo sinonoina. ");
INSERT INTO gvs_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","E yau go parai tayamo akabi, tunagu moetala goi tupwana masigava yoyou ayowo. Go paraiyana aduduwe parai ana kaba valoboda. Avatau neta latuwona Yauwe ina nuwonúwana iyagoi, itoboine ina yoyouyana parai tunagu moetala goi ikawanoi Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Tuta tamo tamo neta ana yoyouyana goi, e tomota liliudi idi parai totomdi goi siitáoya, siipotegu ana kadókana asiu. ");
INSERT INTO gvs_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Tutayana asiu, gaota taaoyaina isou ima yoyouyana totomna goi iitáoya go, gaotayana sinaena goi Yauwe ivaadigoigu. ");
INSERT INTO gvs_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","E tomota liliudi sikandobala gaotayana taaoyaina sigitegite yoyou totomna goi iitáoya, e toinidi idi parai totomdi goi sivatugúyala sikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","E Yauwe ivaadigoigu, matana matagu, nakae koroto neta siyana ivadigo. Ivadigoigu ikavava, akaluvila ana guna tunagu goi go, tubuwau tayamo moe guna tovaita Nuni natuna Iyosuwa, e yoyouyana sinaena ikaaiyaka imataakavate. ");
INSERT INTO gvs_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","E Yauwe alatuwoko, adigo kagu, ‘Neta kunove. Bogina kulatuwokoigu kam, “Ame tomotayadi kuvakedēdi.” Go kom nava geya kulatuwokoiguta avatau bei kuetune ima taiyao kavakededi. Go kom kam, “Bogina ayagoidokoim be akanuwoiyem.” ");
INSERT INTO gvs_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Tauna akawanoi yaim, neta moitamo im kanuwóiya bogina ababane, tauna neta im sinapu kuvatulukoigu bei ayagoim, e bei ayagoi nava woi kukanuuwoiyegu. Go neta kunuwokavate bego amo tomotayadi kom im bodao.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Tuwo Yauwe idigo kana, ‘Yau toinigu bei avakitaum, e aba waiwasi avinim.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Go yau kagu, ‘Neta toinim geya kuvakitaumeta, e taabu kulatuuwokōima ame asayana kakalave. ");
INSERT INTO gvs_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Yau be nakae im bodao liliuma manakaema bei kayagoi woi im kanuwóiya bogina kababane? Tauna neta toinim kuvakitauma bei tomota poyapoya ana madabokina goi siyagoi kai boda taviileima unana kai im bodao liliuma kuvakitauma.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","E Yauwe idigo kana, ‘Moe dogoiyana kudigedige nakae bei aguinuwe kutoto moitamo woi akanuwoiyem be nakae ayagoidokoim.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","E adigo kagu, ‘Akawanoi yaim, neta am káeyana tomoeeyalina kuvatulukoigu agite.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","E kina Yauwe idigo kana, ‘Yau guna sinapu dedevina madabokina bei matam goi ivaatabale. Ago Yau yoigu Yauwe bei avatoi. Avatau neta latuwogu akanuwoiye, bei akanuwoiye. Avatau neta latuwogu anuwokapisiye, bei anuwokapisiye.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Tuwaina kana, ‘Geya itoboinemta maisigu kugite. Geya kada tayaamo tomota itoboine igitegu geya, govila bei ikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kana, ‘Gwa, kébana tayamo gurewa kikigu goi ikaaiyaka, e yatana goi kutāoya. ");
INSERT INTO gvs_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","E tutayana guna káeyana tomoeeyalina ivaatabale, e tukubu goi bei ayatoim go, nimagu goi matam atabode ana kadókana bogina ana. ");
INSERT INTO gvs_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ivatabalegu ikavava, nimagu bei akabimnei go, tolugu kugiteyamo. Go geya itoboineyeta maisigu kugite.’ ");
INSERT INTO gvs_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","E Yauwe ilatuwokoigu idigo kana, ‘Gurewa aiyuwo kwabīdi, kumadagīdi paaevaidi nakae boi avinim go, kukauvisivisidi, e bei yatadi goi guna livalayadi aginidi. ");
INSERT INTO gvs_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Go kwatubayāsi bei itomo nobuyana Sainai Koyaina goi kutūko kūma bei koyayana yatana goi kuvalobodegu. ");
INSERT INTO gvs_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Go geya vatau tayaamo taiyao kotūko komamāima. Nakae geya vatau tayaamo kutagōne koyayana goi ikaaiyaka. Yoguyogu nakae. Taabu koyayana unana goi sikaaiyāka sikakāika.’ ");
INSERT INTO gvs_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Tuwo moitamo, ana gurewa aiyuwo akabidi amadagidi paaevaidi boi gurewayadi nakae. Ikavava, vanuwo itomo nobuyana giyaina atáoya, e gurewayadi aiyuwo nimagu goi akavaledi Koya Sainai goi atuko nakae Yauwe bogina ilatuwokoigu. ");
INSERT INTO gvs_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","E Yauwe gaota sinaena goi isou ima kikigu itáoya go, toinina yoina italavaite kana, ‘Yau Yauwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","E Yauwe ivatabale matagu goi italavaita idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Guna lokatayana tomota yaidi ikaiyako vata. ");
INSERT INTO gvs_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","E woiligu aegu avatugúyala, asakululu Yauwe yaina go, ");
INSERT INTO gvs_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","adigo kagu, ‘Guna Tomoya, moitamo im kanuwóiya bogina ababane, tauna akawanoi yaim, kuvakitāuma. Moitamo. Kidi taiyadi tuntunidi go, idi bágala be idi tapepeko kunuwotaōidi be kukabīma kai im kaba lovina.’ ");
INSERT INTO gvs_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","E Yauwe idigo kana, ‘Kunōve. Kom mam bodao bei akanasiukoimi. Im bodao Isileli tubunao liliudi matadi goi bei guna kaba kainaopa aguinuwedi. Aba kainaopayadi geya vatau tayaamo ame poyapoya ana madabokina goi iguinuwedi. Boda liliudi yaim goi sikaaiyaka bei sigite guna guinuwa, e sopadi akaupatudi. Dogoiyana Yau aguuinuwe yaimi moe dogoi gagaina. ");
INSERT INTO gvs_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Kom be Isileli tubunao liliudi, kaga liliuna ame Yau alatuuwokoimi kokabiikaōne. Kunōve. Kidi Emori tubunao, Kenani tubunao, Eta tubunao, Perisi tubunao, Ivai tubunao be nakae Iyebusi tubunao yaimi goi bei avatapiyedi sisiya. ");
INSERT INTO gvs_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ami dodōkana. Taabu amo toni kasayadi kokanasiiukōidi, govila bei kidi ami síkwana nakae. ");
INSERT INTO gvs_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Idi kaba kasala koligēidi be idi dídiya kimaasabaidi kokauvisivisīdi be nakae Asera ana kówala aba sakululu kotalāidi. ");
INSERT INTO gvs_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","U, taabu kovaatugūyala kokanakabobo basaleliu yaina. Moe moitamo. Yau Yauwe yoigu Tovakókala; Yau Tokavavágana vakookoligu. ");
INSERT INTO gvs_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ami dodōkana. Taabu toni kasa kokanasiiukōidi. Kidi tomatagogoli nakae idi basaleliuyao yaidi sisaakululu be yoguyogu sikaumatedi sigabudi go, sikasaledi basaleliuyaoyadi yaidi. Go neta siduduwemi, taabu kononōina. Neta kona, bei kidi taiyao idi yoguyoguyaoyadi kaasalaidi kokáika. ");
INSERT INTO gvs_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Aiyuwoina natudiyao vevina bei kokabidi natumiyao monediyao, e vevinayadi pasidi komi natumiyao koroto tomatagogoli nakae bei sisakululu idi basaleliuyaoyadi yaidi. ");
INSERT INTO gvs_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Yaubadayadi kainum taabu komaadagīdi bego yaidi kosaakululu. ");
INSERT INTO gvs_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Beredi Pokaka Aikanina bei kowodūgu. Aikaninayana ame nakae: Maliyalina ainima aiyuwo goi beredi pokaka kokakāika tukówana Abib nakae bogina alatuwokoimi. Moe tukowanayana sinaena Itipita goi kosowóduwo. ");
INSERT INTO gvs_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Botomoya liliudi, tomota imi botomoyayao be nakae yoguyogu idi botomoyayao, neta bulumakau o sipi o goti, idi botomoyayao liliudi guna kaba lovina. ");
INSERT INTO gvs_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Imi aseyao adi botomoyayao bolamo lami goi kotatetēdi. Lamiyadi kokaumatēdi kokasalēdi yaigu. Go neta geya kotatetedita, e nukotodi kokiguyalīdi. Imi botomoyayao koroto liliudi lami goi kotatetēdi. Taabu nima kaka komamāima matagu goi, go sem mami vininabeso kōma yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Maliyalina ainima tayamo goi kopaisēwa go, maliyalina ainima aiyuwoina goi kowaiwāsi. Bágula ana tuta be dibayoya ana tuta nakae, maliyalina ainima aiyuwoina goi kowaiwāsi. ");
INSERT INTO gvs_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Wiki Aikanina koowodūgu. Ame youyuwoina Keuwokumgo Aikanina. Ame Aikaninayana goi dibayoya keuwokumgoina bei kokasāle yaigu. Aiyuwoina Lolágata Aikanina koowodūgu tala ana kaba lukavava goi tutayana távina ikavava. ");
INSERT INTO gvs_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Sivato tala tayamo goi komi koroto kōma kosowōduwo Yau Yauwe imi Tomoya, komi Isileli tubunao imi Yaubada, matagu goi. ");
INSERT INTO gvs_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Bei avakumgoiyemi go, boda liliudi avatapiyedi bei sisiya. Nakae imi túwana bei avatudedededi. E kidi geya sipoikikineta bei imi poyapoya sikabimnei tutayana sivato tala tayamo goi koma kosowóduwo Yau Yauwe imi Yaubada matagu goi. ");
INSERT INTO gvs_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Neta yoguyogu bego kokasale yaigu, e yoguyoguyana ikaikaina taabu beredi mana isti taiyao kokaasalēdi yaigu. Nakae yoguyogu Basitáwana Aikanina manuna taabu talainao maniyedi sikesakēsa vanuwo itomo goi. ");
INSERT INTO gvs_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Keuwokumgo dedevina toina imi poyapoya goi bei komēdi Yau Yauwe imi Yaubada yaigu. Neta goti bonatuna iwoina kovaipoluye, taabu sinana nununa bwaena goi kovaaipōlu.’ ");
INSERT INTO gvs_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","E tuwaina Yauwe idigo kana, ‘Ame livalayadi kuginīdi. Livalayadi goi bogina akanasiukoimi, kom be nakae Isileli tubunao liliumi.’ ");
INSERT INTO gvs_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","E tuwo maliyalina 40 be nakae sabamgo 40 goi akaaiyaka Yauwe taiyao go, áika be nakae bwae nim geya. Ago gurewayadi aiyuwo goi Yauwe ina kanasíuna ana livala aginidi moe ina lovina yawou. ");
INSERT INTO gvs_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","E aginidi ikavava Koya Sainai goi gurewayadi aiyuwo asouyedi, gurewayadi goi Yaubada ina kaba vatulúkwana ikaaiyaka. Go tutayana asouyedi, sakavaigu maisigu goi itoomoéyala unana Yauwe taiyao kabobóbwara. Go geya ayagoiyeta bego itomoéyala. ");
INSERT INTO gvs_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","E Eroni be nakae Isileli tubunao liliudi sigitegu, maisigu itomoéyala go, simatoita bego simekoigu. ");
INSERT INTO gvs_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Tuwo aduduwedi, e Eroni be nakae Isileli tubunao adi tomoyamoya liliudi sima alatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Alatuwokoidi ikavava, Isileli tubunao liliudi sima go, lovinayadi liliudi boi Yauwe Koya Sainai goi iivinigu, e tomotayadi alatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Tutayana alatuwokoidi ikavava, areko tayamo akabi, maisigu atabode. ");
INSERT INTO gvs_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Go tuta tamo tamo asiu ana Yauwe matana goi avadigo, e arekoyana avayoini. Nakae ikaaiyaka ana kadókana asowóduwo. Tutayana asowóduwo, ana Isileli tubunao alatuwokoidi kaga nakae Yauwe bogina ilatuwokoigu. ");
INSERT INTO gvs_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Go tutayana sigite bego sakavaigu maisigu goi itomoéyala, e arekoyana akabi, maisiguyana atabodemnei ana kadókana akaluvila ana Yauwe avadigo. ");
INSERT INTO gvs_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","E Isileli tubunao madabokidi ataligogoidi alatuwokoidi adigo kagu, ‘Ame sinapuyadi Yauwe iilovina taguuinuwedi: ");
INSERT INTO gvs_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Maliyalina ana badabada ainima tayamo goi ida paisewa taguinūwe go, maliyalina ainima aiyuwoina moe aba waiwasi, e paisewa goi tasayāta. Amo maliyalinayana kimaasabaina Yauwe umana. Avatau neta amo maliyalinayana goi ipaisewa, takaumāte. ");
INSERT INTO gvs_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","E nakae maliyalina aba waiwasi ana tuta taabu ida yoyou sinaedi goi yeu tadiimilīdi.’ ");
INSERT INTO gvs_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","E tuwaina Isileli tubunao liliudi alatuwokoidi adigo kagu, ‘Ame dogoiyana Yauwe ilovina koguinuwe: ");
INSERT INTO gvs_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","E imi vagidi Yauwe manuna kolamgogōidi. Avatauwa neta atedi sitagona, e idi vagidi sikabīdi simēdi Yauwe yaina sikasalēdi. Vagidiyadi ame nakae: Goura, siriba be nakae kopwa, ");
INSERT INTO gvs_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi. Nakae areko dedevidi toidi, goti unuunudi, ");
INSERT INTO gvs_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","sipi bolamo sakavaidi go, sakavayadi bogina sikaredi kayakayaidi. Ikavava ituli ta yoguyoguva sakavaidi, gaigíyala, ");
INSERT INTO gvs_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","oribe mumuna rampa manuna, alova sakavaidi pútuma aba kaipaku manuna be nakae insensi. ");
INSERT INTO gvs_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Gurewa esaaesaidi anikisi be nakae gurewa dedevidi Tonúwala ana kwama manudi. Kwamayadi aiyuwo, tayamo tolobona ana kwama, e tayamo kasikasina ana saisaira. ");
INSERT INTO gvs_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Komi tonuwopolala, liliumi kōma kaga liliuna bogina Yauwe ilovina komadagīdi. ");
INSERT INTO gvs_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Dogoiyadi ame nakae: Yauwe ina Kaba Kaiyaka, ana kaba vatumna areko, ana kaba vatumna yoguyogu sakavaidi, ana rini, ana vabodakalova, ana logógana be ana kówala madi kaba táoya. ");
INSERT INTO gvs_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Dedeoga mana kaitakeo, aba núwala, vabodaupa kaarekoina, ");
INSERT INTO gvs_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","teboro ma konanina, ana kaitakeo be nakae beredi kimaasabaidi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Rampa adi kaba yata ma konanina be nakae rampa giyaidi be oribe mumuna rampayadi manudi. ");
INSERT INTO gvs_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Insensi ana kaba kasala mana kaitakeo, pútuma aba kaipaku, insensi mainina dedevina be nakae ina Kaba Kaiyaka ana kaba siu kaarekoina. ");
INSERT INTO gvs_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Aba kasala ma vatalina kopwa vininabeso ana kaigabu manuna, ana kaitakeo, konanina, nokobaba ma kaena, ");
INSERT INTO gvs_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ali ana taboda areko, ina kówala, ina kaba táoya be nakae ina kaba siu ana taboda kaarekoina, ");
INSERT INTO gvs_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","nakae ina Kaba Kaiyaka ana kaba kokavata nakae ina kali ana kaba kokavata kowodugūdi be nakae adi búyala kowodugūdi. ");
INSERT INTO gvs_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Kwama dedevidi paisewa Bateta Kimaasabaina sinaena manuna kowodugūdi. Kwamayadi moe Eroni tauyana Tonúwala ana kwama kimaasabaina ina paisewa manuna be nakae natunao adi kwama, e bei Tonúwala ana paisewa siguinuwe.’ ");
INSERT INTO gvs_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","E abóbwara ikavava, Isileli tubunao liliudi sikalavegu go, sisáwala sina. ");
INSERT INTO gvs_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Avatauwa neta atedi sitagona, e idi vagidi simedi. Vagidiyadi moe Yauwe ina Kaba Valoboda manuna nakae ina paisewa liliudi manudi be nakae Tonúwala ana kwama kimaasabaidi manudi. ");
INSERT INTO gvs_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Koroto nakae vevina, avatauwa neta atedi sitagona, e idi vininabeso goura simedi Yauwe yaina. Vininabesoyadi ame nakae: Mawuwu, gipolu, rini, nimatuwetuwe be nakae kónana goura liliudi. Tauna nakae tomota tamo tamo idi vininabeso goura simedi sikasaledi Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Avatauwa neta madi búyala buruu, kalaakovidi toidi be kayakayaidi, o neta madi kareko dedevidi toidi o neta madi goti unuunudi o sipi bolamo sakavaidi siikaredi kayakayaidi o ituli ta yoguyoguva sakavaidi, e madabokidi simedi sikasaledi Yauwe yaina. ");
INSERT INTO gvs_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Avatauwa neta itoboinedi idi vagidi siriba be kopwa sikabidi, e simedi sikasaledi Yauwe yaina. Avatauwa neta madi gaigíyala paisewayana manuna, e nakae simedi. ");
INSERT INTO gvs_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ava vevinava neta tonuwopolala, e búyala buruu, kalaakovidi toidi be kayakayaidi sinoedi be nakae areko dedevidi toidi sigilumidi simedi. ");
INSERT INTO gvs_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ava vevinava neta atedi sitagona be nakae madi katanaki, goti unuunudi sigíluma. ");
INSERT INTO gvs_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","E kidi go tomoyamoya gurewa esaaesaidi anikisi be nakae ituli ta gurewa esaaesaidi simedi tonúwala tolobona ana kwama be nakae kasikasina ana saisaira manudi. ");
INSERT INTO gvs_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Tuwaina alova sisina be oribe mumuna rampa manudi be alova sakavaidi pútuma aba kaipaku manuna be nakae pútuma insensi manuna simedi. ");
INSERT INTO gvs_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isileli tubunao liliudi, koroto be nakae vevina, neta atedi sitagona, e idi vininabeso simedi sikasaledi Yauwe yaina. Vininabesoyadi moe Yauwe ina paisewa manuna nakae boi sopagu goi bogina ilovina siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","E simedi ikavava, alatuwokoidi adigo kagu, ‘Gwa! Ure, ma Yuda, natuna moe Uri, e tubuna moe Besaleli. Ame tauyana Yauwe bogina ikinave. ");
INSERT INTO gvs_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Balomaina goi Besaleliyana bogina ivakayaodei, tauna mana nuwopolala be mana nanamsa be mana kabitam nakae ana kaipata paisewa liliudi dedevidi iyagoidi be iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Tauyana ana kabitam goura be siriba be nakae kopwa adi paisewa goi. ");
INSERT INTO gvs_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Nakae gurewa esaaesaidi adi paisewa be nakae alova ana dayágina bogina ana kaipata iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Go Yauwe Akisamaki ma Dani natuna Oliyavi be nakae Besaleli nukotodi goi bogina iyato, tauna itoboinedi adi paisewa sivatulúkwana. ");
INSERT INTO gvs_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Paisewa liliudi adi nuwopolala bogina ivinidi, tauna itoboinedi gurewa ana gínina be nuwonúwana paisewa manuna, búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi goi be nakae areko dedevidi adi gíluma be wóina dedevina ana paisewa siguinuwedi. Kidi paisewa liliudi siyagoidi be siguinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","‘E Besaleli be Oliyavi be tonuwopolala liliudi taiyao bei sipaisewa nakae kaga liliuna boi Yauwe bogina iidigedi. Ame tauyadi madi nuwopolala be madi nanamsa unana Yauwe bogina ivinidi, e bei ina Kaba Kaiyaka Kimaasabaina siyowodoko.’ ");
INSERT INTO gvs_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","E abóbwara ikavava, Besaleli, Oliyavi be tonuwopolala liliudi Yauwe ina kaiguyau nuwodi goi bogina iyato nakae bogina sikatetagona sipaisewa, e liliudi aduduwedi sima. ");
INSERT INTO gvs_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Sima, tomota idi vagidi liliudi bogina simemedi bogina yoiyana Yauwe ina Kaba Kaiyaka Kimaasabaina ana yówana manuna. Tuwo akabidi, Besaleli senao taiyao avinidi. Avinidi yoiyadi go, tuwo tomota nobuyana tamo tamo idi vagidi tuwaina simemedi sivinigu. ");
INSERT INTO gvs_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","E tonuwopolala liliudi idi paisewa Yauwe ina Kaba Kaiyaka Kimaasabaina goi sikalave sima ");
INSERT INTO gvs_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","silatuwokoigu sidigo kadi, ‘Tomota idi vininabeso simemedi paisewayana boi Yauwe ilatuwokoima manuna bogina yoiyana.’ ");
INSERT INTO gvs_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","E tuwo vala aetune ina tunagu tamo tamo goi tomota liliudi alatuwokoidi adigo kagu, ‘Taabu imi vagidi tuwaina komemēdi Yauwe ina Kaba Kaiyaka Kimaasabaina ana yówana manuna.’ E tuwo tauyadi geya tuwaina idi vagidi simemedi yaigu. ");
INSERT INTO gvs_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Idi vagidiyadi liliudi simemedi, bogina yoiyana paisewayana manuna go, maniyena sikesa. ");
INSERT INTO gvs_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","E topaisewa madi katanaki Yauwe ina Kaba Kaiyaka yoyou simadagi. Go ana madágina ame nakae: Areko dedevidi toidi adi badabada yawou be nakae búyala noyanoyaidi buruu, kalaakovidi toidi be nakae kayakayaidi sikabidi, e simadagi. Ikavava, arekoyadi goi yábana ana tomatakavatayao makayaudi sigilumidi. Gilumayana ana kaigigita nakae gíluma ana tokatanaki idi paisewa. ");
INSERT INTO gvs_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","E areko tamo tamo adi mamanao ovanima ovato go, adi papaeva ovatayamo. Areko liliudi adi kakainaki nakae. ");
INSERT INTO gvs_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Areko ainima adi mamanao goi sisavikoidi. Niga areko ainima sikesa sikabidi, adi mamanao goi sisavikoidi. ");
INSERT INTO gvs_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Areko buruu sikabidi, látuma siyatakoidi go, latumayadi matakubudi aba vatumna areko tayamo ana mamanao goi sigilumipatukoidi. Aba vatumna areko aiyuwoina ana mamanao goi nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Aba vatumna areko tayamo ana mamanao goi ana látuma adi badabada 50 sigilumipatukoidi. E nakae aba vatumna areko aiyuwoina ana mamanao goi látuma ana badabada 50 sigilumipatukoidi. Ikavava, aba vatumna areko aiyuwo sivatuyuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Sivatuyuwedi ikavava, aba talagegeta goura adi badabada 50 simadagidi. E aba talagegetayadi goi aba vatumna areko aiyuwokova sisavidi, e bei Yauwe ina Kaba Kaiyakayana ana kaba vatumna ana kaigigita nakae areko tayamo toito. ");
INSERT INTO gvs_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","E goti unuunudi sikabidi, areko yawou tayamo simadagidi. Arekoyadi Yauwe ina Kaba Kaiyaka ana kaba vatumna aiyuwoina siyatakoidi. ");
INSERT INTO gvs_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Arekoyadi tamo tamo adi mamanao ovanima ovato aba katugúyala. Go adi papaeva ovatayamo. Arekoyadi madabokidi adi kakainaki nakae. ");
INSERT INTO gvs_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Arekoyadi ainima sikabidi, adi mamanao goi sisavikoidi. Niga arekoyadi ainima tayamo sikesa sikabidi, adi mamanao goi sisavikoidi. ");
INSERT INTO gvs_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Látuma areko ana badabada 50 sikabidi, matakubudi sigilumipatukoidi aba vatumna tayamo ana mamanao goi. E nakae siguinuwe aba vatumna aiyuwoina goi. ");
INSERT INTO gvs_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ikavava, aba talagegeta kopwa ana badabada 50 simadagidi, e aba vatumna aiyuwokova sisavidi. Tauna aba vatumna tayamo maanawena. ");
INSERT INTO gvs_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","E aba vatumna aiyuwo tuwaina sigilumidi Yauwe ina Kaba Kaiyakayana manuna. Tayamo sipi bolamo sakavaidi goi sigilumi. Sakavaidiyadi bogina sikaredi kayakayaidi. Go aiyuwoina ituli ta yoguyoguva sakavaidi goi sigilumi. ");
INSERT INTO gvs_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","E gaigíyala taalaidi sikabidi, Yauwe ina Kaba Kaiyakayana ana vabodakalova manudi. ");
INSERT INTO gvs_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ana vabodakalova tamo tamo gidigidina ana tukotuko ovato go, ana papaeva panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Vabodakalovayadi adi madágina ame nakae: Alova aiyuwo sivataoedi go, alova sikanabaledi alovayadi aiyuwo nauyayanaidi goi. Vabodakalova liliudi Aba Kaiyakayana goi simadagidi nakae. ");
INSERT INTO gvs_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","E adi badabada 20 simadagidi youya dadavina manuna. ");
INSERT INTO gvs_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Go adi kaba táoya siriba, e adi badabada 40 simadagidi. Tauna aba táoya aiyuwo moe vabodakalova tayamo manuna. Nakae siguinuwe vabodakalova liliudi goi. ");
INSERT INTO gvs_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Go Yauwe ina Kaba Kaiyakayana yawéyana dadavina goi nakae siguinuwe. Vabodakalova adi badabada 20 simadagidi ");
INSERT INTO gvs_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","go, adi kaba táoya siriba adi badabada 40 simadagidi. Tauna aba táoya aiyuwo moe vabodakalova tayamo manuna. ");
INSERT INTO gvs_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Go Tukunu ana vaboda goi, moe koiboga dadavina, Yauwe ina Kaba Kaiyakayana ana vabodakalova adi badabada ainima tayamo simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","E Yauwe ina Kaba Kaiyakayana matakubuna aiyuwo goi vabodakalova aiyuwo tuwaina simadagidi, sikalipaiwolidi. Moe yawéyana be koiboga adi valoboda goi be nakae youya be koiboga adi valoboda goi. ");
INSERT INTO gvs_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Sikalipaiwolidi, tauna ditonema unadi goi vabodakalova aiyuwo go, diligaema rini goura goi vabodakalovayadi sikopatukoidi. E Tukunu ana vaboda matakubuna aiyuwo goi siguinuwedi nakae. ");
INSERT INTO gvs_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Tauna vabodakalova adi badabada ainima aito koiboga dadavina go, adi kaba táoya siriba adi badabada yawou ainima tayamo. Moe aba táoya aiyuwo vabodakalova tayamo manuna. ");
INSERT INTO gvs_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","E vabodakalova simadagidi ikavava, logógana gaigíyala ainima sibobóidi, e vabodakalova toluyedi youya dadavina goi sikanabaledi. ");
INSERT INTO gvs_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Ikavava, ainima tuwaina sibobóidi, e yawéyana dadavina aiyuwoina sikanabaledi. E ainima sibobóidi Tukunu koiboga dadavina nakae sikanabaledi. ");
INSERT INTO gvs_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Ego logoganayadi vaboda tamo tamo nauyayanaidi goi adi mamanao vaboda naveyadi. ");
INSERT INTO gvs_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Goura paaevaidi sikabidi, vabodakalovayadi liliudi be nakae logoganayadi goi sikaupatukoidi. Ikavava, rini goura simadagidi, vabodakalova toluyena goi siyatoidi, e logoganayadi sivaisiudi sikanabalabala. ");
INSERT INTO gvs_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","E búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi be nakae areko dedevidi sikabidi, e gíluma ana tokatanaki sivini, vabodaupa kaarekoina tayamo igilumi. Arekoyana goi yábana ana tomatakavatayao makayaudi igilumidi. ");
INSERT INTO gvs_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Igilumidi ikavava, kówala gaigíyala aivasi sibobóidi. Go goura paaevaidi sikabidi, kowalayadi goi sipaimidi namliyeta sikaupatukoidi. Ikavava, adi kaba táoya siriba goi sivataoedi go, Yauwe ina Kaba Kaiyakayana sinaena goi siyato. Aba talagegeta goura kowalayadi sipodi goi siyatoidi. E amoko goi arekoyana sivakosaine. ");
INSERT INTO gvs_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","E Yauwe ina Kaba Kaiyakayana ana kaba siu bomatu dadavina ikaaiyaka. Ana kaba siuyana ana taboda kaarekoina ana gíluma ame nakae: Búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi sikabidi, gíluma ana tokatanaki sivini, aba siuyana ana taboda kaarekoina igilumi. ");
INSERT INTO gvs_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Igilumi ikavava, kówala ainima simadagidi, e kowalayadi adi takudukudu goi goura paaevaidi sikaupatukoidi. Ikavava, adi kaba táoya kopwa simadagidi. Ego goura sikabi, aba siu karekoinayana adi rini simadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","E Besaleli gaigíyala taalaidi ikabidi, dedeoga imadagi. Ana mamanao panetayataya aba katugúyala go, ana papaeva panetayataya go, ana tukotuko panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ikavava, e dedeogayana toluyena be sinaena goi goura maavadaina go, paaevaidi ikaupatukoidi. Ikavava, kinababaina goi ana papa goura ikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","E rini goura aivasi imadagidi, aena aivasi goi iyatoidi, dadava aiyuwo, dadava aiyuwo. ");
INSERT INTO gvs_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ikavava, aitakeo aiyuwo gaigíyala ibobóidi go, goura paaevaidi ikabidi, aitakeoyadi ipaimidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ikavava, riniyadi goi ivaisiudi, e bei dedeogayana sikaitakeve. ");
INSERT INTO gvs_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Imadagi ikavava, e goura maavadaina ikabi, ana katukábwala goura imadagi. Ana katukabwalayana moe aba núwala go, ana kakainaki ame nakae: Ana mamanao panetayataya aba katugúyala go, ana papaeva panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ikavava, goura itutu, yábana ana tomatakavatayao aiyuwo imadagidi tokwalu nakae. Imadagidi ikavava, aba núwala yatana goi iyatoidi, ");
INSERT INTO gvs_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","tayamo matakubuna, tayamo matakubuna goi ikaupakiyedi. ");
INSERT INTO gvs_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ego yábana ana tomatakavatayaoyadi ma panepanedi imadagidi go, panepanediyadi siyosaledi, e aba núwala sitakabobo be simatakavate. Adi taiyuwokova matana matana sikaaiyaka go, sikandosobu aba nuwalayana sigitegite. ");
INSERT INTO gvs_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","E Besaleliyana gaigíyala taalaidi ikabidi, teboro tayamo imadagi. Teboroyana ana kakainaki ame nakae: Ana mamanao panetayataya kasikasi go, ana papaeva aba katugúyala go, ana tukotuko panetayataya. ");
INSERT INTO gvs_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Imadagi ikavava, teboroyana goi goura maavadaina be paaevaina ikaupatuko. Ikavava, kinababaina goi ana papa goura ikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Ikaupatuko ikavava, teboroyana yatana goi tupaota goura iyatoidi sivaníbita. Tupaotayadi adi tukotuko nimakulemwasi tayamo. Go tupaotayana goi ana papa goura ikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Ikavava, e rini aivasi goura maavadaina imadagidi, teboro matakubuna aivasi goi iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Sikaaiyaka tupaotayana kikina go, sobuyekoina goi, e bei teboroyana aitakeo goi sikaiitakeve. ");
INSERT INTO gvs_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Rini iyatoidi ikavava, aitakeo gaigíyala aiyuwo ibobóidi, e aitakeoyadi goi goura paaevaina ikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ikaupatuko ikavava, e goura maavadaina ikabi, teboroyana ana noko, ana pereiti, ana botori be ana borodisi imadagidi. Botoriyana be borodisiyana moe idi vininabeso oine manuna. ");
INSERT INTO gvs_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","E Besaleli goura maavadaina ikabi, itutu, e rampa adi kaba yata imadagi. Aba yatayana alova maisiyana, tauna unana, tolobona, gadona be nakae senina vagana imadagidi go, madabokina ana lamgógana goura tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","E tolobona goi laonina nakae ainima tayamo imadagidi situko, dadavina aito, dadavina aito. ");
INSERT INTO gvs_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Laoninayadi tamo tamo goi senina vagana ma gadona aito sikaaiyaka. Seninayadi taniya maisiyana. ");
INSERT INTO gvs_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Go tolobonayana goi senina vagana ma gadona aivasi imadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Nako goi laonina sisowóduwo tolobona goi, e senina vagana ma gadona sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","E senina gadona be laonina goura maavadaina situtudi go, ana lamgógana goura tayamo. ");
INSERT INTO gvs_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ikavava, e goura maavadaina ikabi, rampa giyaidi ainima aiyuwo be wiki ana kaba kalikaina be nakae ana noko imadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","E goura mavadainayana ana moumou nakae kilo ana badabada 30 ikabi rampa adi kaba yata be nakae konanina adi madágina manudi. ");
INSERT INTO gvs_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","E Besaleli gaigíyala taalaidi ikabidi, insensi ana kaba kasala imadagi. Aba kasalayana ana mamanao be nakae ana papaeva moe aba katugúyala go, ana tukotuko panetayataya kasikasi. Ikavava, ana sakusaku aivasi matakubuna goi iyatoidi. Go sakusakuyadi be aba kasala alova tayamo goi imadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Imadagi ikavava, goura maavadaina be paaevaina ikabi, aba kasalayana goi ikaupatuko. Tauna madabokina goura. Ikaupatuko ikavava, e kinababaina goi ana papa goura ikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ikavava, e rini aiyuwo goura imadagidi, ana papa kikina go, sobuyekoina goi ikaupatukoidi, dadavina tayamo, dadavina tayamo. Riniyadi moe aitakeo manudi. ");
INSERT INTO gvs_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Ikaupatukoidi ikavava, e aba kasalayana ana kaitakeo aiyuwo gaigíyala ibobóidi, goura paaevaidi goi ipaimidi. ");
INSERT INTO gvs_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","E Besaleli pútuma aba kaipaku imadagi namliyeta ikimasabe Yauwe umana. Ikavava, alova sisina be nakae náuna lamna ikabidi, insensi maavadaina be nakae mainina dedevina imadagi. Go putumayana be insensiyana adi madágina nakae tauyadi pútuma be insensi adi tokatanaki idi paisewa nakae. ");
INSERT INTO gvs_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","E Besaleli gaigíyala taalaidi ikabidi, ana kaba kasala vininabeso ana kaigabu manuna imadagi. Ana mamanao be nakae ana papaeva moe ovatayamo panetayataya go, ana tukotuko moe ovatayamo. ");
INSERT INTO gvs_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Imadagi ikavava, e ana sakusaku aivasi imadagidi matakubuna aivasi goi iyatoidi go, sakusakuyadi be aba kasala alova tayamo goi imadagidi. Iyatoidi ikavava, aba kasalayana goi kopwa paaevaina ikaupatuko. ");
INSERT INTO gvs_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ikavava, kopwa ikabi, aba kasala konanina imadagidi. Konaninayadi ame nakae: Silekau ana kaba vadoda, ana sabwero, ana borodisi, ana sisiwo be nakae pokova ana kaba vadoda imadagidi. ");
INSERT INTO gvs_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ikavava, e kopwa tuwaina ikabi, ana vátala imadagi, iyatako yeu ana kaba dímila. Ikavava, e vatalayana aba kasala sinaena nauyayanaina goi sidodoi. ");
INSERT INTO gvs_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","E rini aivasi imadagidi, vatalayana matakubuna aivasi goi ikaupatukoidi go, sisowóduwo aba kasalayana toluyena goi aitakeo manudi. ");
INSERT INTO gvs_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ikavava, e aba kasala ana kaitakeo gaigíyala aiyuwo ibobóidi. Ikavava, kopwa paaevaina goi ipaimidi. ");
INSERT INTO gvs_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Ikavava, aitakeoyadi ivaisiudi riniyadi aba kasala toluyena goi, dadavina tayamo, dadavina tayamo, e bei sikaaitakeve. Ego aba kasalayana timba paaevaidi goi imadagi. Go sinaena daakakaina be nakae dibuna goi geya ana kaubodamo. ");
INSERT INTO gvs_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","E tovaita vevina maniyedi Yauwe ina Kaba Valoboda ana kaba siu goi sipaaisewa. Tauyadi idi saribu kopwa simedi Besaleli sivini. E saribuyadi ikabidi, nokobaba maa kaena kopwa imadagidi. Nokobabayana moe aba níkina. ");
INSERT INTO gvs_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","E Yauwe ina Kaba Kaiyaka Besaleli ikali. Areko dedevidi ikabidi, Aba Kaiyaka ana kali imadagi. Aliyana youya dadavina ana mamanao moe ova 30. ");
INSERT INTO gvs_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","E kówala ana badabada 20 adi kaba táoya kopwa goi ivataoedi. E sipodi goi rini be aba talagegeta siriba iyatoidi, arekoyadi ivakosainedi. ");
INSERT INTO gvs_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","E yawéyana dadavina goi nakae iguinuwe. Aliyana ana mamanao moe ova 30 go, kówala ana badabada 20 adi kaba táoya kopwa goi ivataoedi go, sipodi goi rini be aba talagegeta siriba iyatoidi, arekoyadi ivakosainedi. ");
INSERT INTO gvs_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","E aliyana koiboga dadavina ana mamanao moe ovayawou ovanima go, kówala ana badabada yawou adi kaba táoya kopwa goi ivataoedi. ");
INSERT INTO gvs_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","E aliyana ana kaba siu goi, moe bomatu dadavina, ana mamanao nakae ovayawou ovanima. ");
INSERT INTO gvs_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","E aba siu dadavina ana mamanao ovavasi panetayataya, dadavina ovavasi panetayataya. Go ana kówala dadavina aito, dadavina aito adi kaba táoya goi ivataoedi. E kowalayadi goi arekoyadi ivakosainedi. ");
INSERT INTO gvs_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Areko liliudi aliyadi manudi moe dedevidi toidi. ");
INSERT INTO gvs_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","E kowalayadi adi kaba táoya moe kopwa go, adi takudukudu goi siriba paaevaina ikaupatuko. Nakae adi rini liliudi be adi kaba talagegeta moe siriba. ");
INSERT INTO gvs_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","E gíluma ana tokatanaki búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi ikabidi, ali ana kaba siu ana taboda kaarekoina igilumi. Go tabodayana ana mamanao moe ovanima ovatayamo go, ana tukotuko ovatayamo aba katugúyala. ");
INSERT INTO gvs_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Go tabodayana ana kówala madi kaba táoya moe kopwa go, adi kaba talagegeta moe siriba. Nakae kowalayadi sipodi yatadi moe siriba. ");
INSERT INTO gvs_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","E Yauwe ina Kaba Kaiyaka ana kaba kokavata be nakae ali ana kaba kokavata liliudi moe kopwa. ");
INSERT INTO gvs_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","E ame kainum ana kakainaki sikabi Yauwe ina Kaba Kaiyaka yoyou ana madágina manuna. Ina Kaba Kaiyakayana goi aba vatulúkwana ikaaiyaka. E Livai tubunao alatuwokoidi kainumyadi sikatuyaividi siginidi. Kidi Livai tubunao adi tovakumgo ame paisewayana manuna moe Itamari, tauyana Tonúwala Eroni natuna. ");
INSERT INTO gvs_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","E Ure, ma Yuda, natuna moe Uri, e tubuna moe Besaleli. Ame tauyana alatuwoko iguinuwe kaga liliuna nakae boi Yauwe ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Go Besaleliyana ana tovaita moe Akisamaki natuna Oliyavi ma Dani. Go tauyana kainum ana tokatanaki nakae ana tokabitam. Aiyuwoina tauyana gíluma ana tokatanaki moe areko dedevidi be nakae búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi goi. ");
INSERT INTO gvs_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","E vininabeso goura madabokina ana kakainaki Yauwe ina Kaba Kaiyaka Kimaasabaina manuna moe kilo ana badabada eita andedi 830. Ego gourayana sisikere Yauwe ina Kaba Kaiyaka Kimaasabaina ana lovina goi sisikere. ");
INSERT INTO gvs_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","E vininabeso siriba ana moumou boi koroto adi katuyáiva goi moe kilo ana badabada 2,819. Siribayana siisikere Yauwe ina Kaba Kaiyaka Kimaasabaina ana lovina goi sisikere. ");
INSERT INTO gvs_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Boi koroto tamo tamo neta adi tala 20 nakae ituko, neta sikatuyaividi, e idi vininabeso siriba goi giyaina Yauwe sivinibeso. Siribayana siisikere Yauwe ina Kaba Kaiyaka Kimaasabaina ana lovina goi sisikere. Korotoyadi adi badabada moe 603,550. ");
INSERT INTO gvs_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Siribayana ana moumou kilo ana badabada 2,800 ikabidi, Yauwe ina Kaba Kaiyaka Kimasabainayana ana vabodakalova adi kaba táoya be nakae vabodaupa kaarekoina ana kówala adi kaba táoya imadagidi. Aba taoyayadi adi badabada moe 100, tauna adi kaba táoya tamo tamo siriba ana moumou kilo ana badabada tuwenti 28. ");
INSERT INTO gvs_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ago siribayana ikesa moe kilo ana badabada 19, e ikabidi, kówala ana kaba talagegeta be ana rini imadagidi be nakae kowalayadi sipodi goi siribayana paaevaina ikaupatukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","E vininabeso kopwa ana moumou moe kilo ana badabada 2,425. ");
INSERT INTO gvs_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Kopayana ikabi, ame dogoiyadi imadagidi: Yauwe ina Kaba Valoboda totomna ana kówala, aba kasala kopwa ma vatalina be nakae konanina, ");
INSERT INTO gvs_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ali ana kówala adi kaba táoya, Yauwe ina Kaba Kaiyakayana ana kaba kokavata be nakae aliyana ana kaba kokavata. ");
INSERT INTO gvs_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","E Besaleli, Oliyavi be tokatanaki liliudi búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi, kwama kaausaraidi sigilumidi. Kwamayadi moe Yauwe ina Tonuwalayao adi kwama silosidi neta ina Kaba Kaiyaka Kimaasabaina goi sipaaisewa. E nakae Eroni ana kwama sigilumidi. Ame kwamayadi sikimasabedi Yauwe ina paisewa manuna. Siguinuwa nakae Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","3","E tauyadi goura sikabi, sikaupapaeve ina aaa ikakaráiya. Ikavava, gourayana sitaseseli, e búyala simadagi. Ikavava, búyala buruu, kalaakovidi toidi be kayakayaidi sikabidi, búyala goura taiyao sinoepatukoidi. Ikavava, buyalayana be areko dedevina sikabidi, tolobo ana kwama sigilumi go, gilumayana ana kaigigita nakae gíluma ana tokatanaki idi paisewa. ");
INSERT INTO gvs_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Ikavava, aba latuba aiyuwo sigilumidi, e kwamayadi aiyuwo matakubudi goi sigilumipatukoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ikavava, kwamayana ana gigipáiwala sigilumidoko, ana kaigigita dedevina toina. Go gigipaiwalayana kwama goi sigilumipatuko. Ana búyala be ana kareko moe kwamayana nakae. Tauna sigilumi nakae sopagu goi Yauwe bogina ilovina siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","E gurewa esaaesaidi anikisi madi kaba yata goura sikabidi, e gurewayadi goi Isileli natunao yoidi siginidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ikavava, tolobona ana kwama ana kaba latuba goi siyatoidi. Gurewayadi moe Isileli tubunao adi kaba kinana bego Yauwe inuwokavatedi. Tauna siguinuwe nakae Yauwe boi bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","E Tonúwala kasikasina ana saisaira sigilumi nakae tolobona ana kwama ana gíluma. Moe búyala noyanoyaidi goura, buruu, kalaakovidi toidi be kayakayaidi be nakae areko dedevidi sikabidi, sigilumi. Tauyadi idi paisewayana nakae gíluma ana tokatanaki idi paisewa. ");
INSERT INTO gvs_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","E tabodayana sinunumi, ana mamanao be ana papaeva sivavasa, moe nimakulemwasi aito. ");
INSERT INTO gvs_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ikavava, saisairayana goi gurewa esaaesaidi túwana aivasi goi sikauvapotedi ame nakae: Túwana vakuumgoina goi gurewa yoidi rubi, topasi be beleli siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Túwana aiyuwoina goi gurewa yoidi turakoisi, sapaire be emeradi siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Túwana aitonina goi gurewa yoidi diyasinta, ágeta be ametísta siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Túwana aivasina goi gurewa yoidi kwatisi, anikisi be diyáspa siyatoidi. Ame gurewayadi adi kaba yata moe goura goi sikauvapotedi. ");
INSERT INTO gvs_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Gurewayadi tamo tamo goi Isileli natunao yawou aiyuwo yoidi tamo tamo siginidi. Tauna gurewa tayamo, you tayamo, gurewa tayamo, you tayamo. Youyadi Isileli tubunao adi dala yoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","E goura maavadaina sikabi, kasikasina ana saisaira ana seni nakae sinoedi. ");
INSERT INTO gvs_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Ikavava, rini madi kaba yata aiyuwo goura goi simadagidi. E kasikasina ana saisaira matakubuna aiyuwo diligaema goi sikauvapotedi. ");
INSERT INTO gvs_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ikavava, seniyadi goura tayamo dadavina riniyadi goi sisikoidi ");
INSERT INTO gvs_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","go, tayamo dadavina gurewa adi kaba yata aiyuwo goi sisikoidi. Aba yatayadi sikaiyaka tolobona ana kwama ana kaba latuba aiyuwo goi. ");
INSERT INTO gvs_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Ikavava, rini goura aiyuwo simadagidi, e kasikasina ana saisaira ogalaoina goi siyatoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ikavava, rini goura aiyuwo tuwaina simadagidi go, tolobona ana kwama ana sinapatúkwana goi siyatoidi. Go moe gigipáiwala dedevina diligaemaina goi be nakae kwamayana kukuna goi. ");
INSERT INTO gvs_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ikavava, búyala buruu aiyuwo sikabidi, tayamo dadavina rini aiyuwo kasikasina ana saisaira ogalaoina goi sisikoidi go, tayamo dadavina rini aiyuwo tolobona ana kwama goi sisikoidi. Tauna kasikasina ana saisairayana ikaiyaka gigipáiwala dedevina diligaemaina, e geya itoboineyeta tolobona ana kwama goi italigalígava. E siguinuwa nakae Yauwe boi bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","E kwama tayamo maanawena sigilumi. Kwamayana madabokina buruu go, ikaiyaka tolobona ana kwama sinaena. Idi paisewa nakae togíluma dedevidi idi paisewa. ");
INSERT INTO gvs_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","E kwamayana goi tapora tayamo Tonúwala nukotona manuna siwodugu. Taporayana kikina sikunupedoko, tauna geya itoboineyeta bei itaisa. ");
INSERT INTO gvs_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","E búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi, mogolu keuwoina maisiyana sigilumidi, e kwamayana kikina ditonema dadavina goi sisikoidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","E goura maavadaina sikabi, bere giyaidi simadagidi. Ikavava, kwamayana kikina ditonema dadavina goi sisikoidi mogolu nauyayanaidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Tauna bere tayamo mogolu tayamo, bere tayamo mogolu tayamo kwamayana kikina madabokina ivaníbita nakae. E siguinuwa nakae Yauwe boi bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","E areko dedevidi toidi sikabidi, Eroni ma natunao adi kwama maanawedi sigilumidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Ikavava, e areko dedevidi tuwaina sikabidi, dábana aba vatúmna be ana pasapasa be nakae tarausisi aba saidibuna sigilumidi. ");
INSERT INTO gvs_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ikavava, areko dedevidi be nakae búyala noyanoyaidi buruu, kalaakovidi toidi be kayakayaidi sikabidi, gigipáiwala sigilumi nakae Yauwe boi bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","E goura maavadaina sikabi, dabayogigi simadagi senina maisiyana namliyeta sikimasabe Yauwe umana. E dabayogigiyana yatana goi sigini kadi, ‘Tauyana Kimaasabaina Yauwe Umana.’ ");
INSERT INTO gvs_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Niga búyala buruu sikabi, dabayogigiyana sisiko dábana aba vatúmna nakae Yauwe boi bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","E Yauwe ina Kaba Kaiyaka, o tadigo kada, ‘Ina Kaba Valoboda’, madabokina ana madágina bogina ikavava. Isileli tubunao kaga liliuna simadagidi nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","E Yauwe ina Kaba Kaiyakayana konanina liliudi sikabidi, simedi yaigu. Konaninayadi ame nakae: Ana rini, ana vabodakalova, ana logógana, ana kówala madi kaba táoya. ");
INSERT INTO gvs_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ana kaba vatumna sipi bolamo sakavaidi bogina kayakayaidi goi sikaredi, ana kaba vatumna ituli ta yoguyoguva sakavaidi be nakae ana vabodaupa kaarekoina. ");
INSERT INTO gvs_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Aba vatulúkwana dedeogaina mana kaitakeo be nakae aba núwala. ");
INSERT INTO gvs_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Teboroyana ma konanina be nakae beredi kimaasabaidi Yauwe umana. ");
INSERT INTO gvs_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","E nakae ame konaninayadi simedi: Rampa adi kaba yata goura maavadaina mana rampa, konanina be nakae oribe mumuna rampa manudi. ");
INSERT INTO gvs_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Aba kasala goura, pútuma aba kaipaku, insensi mainina dedevina be nakae Yauwe ina Kaba Kaiyaka ana kaba siu ana taboda kaarekoina. ");
INSERT INTO gvs_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Aba kasala kopwa ma vatalina, ana kaitakeo, konanina be nakae nokobaba kopwa ma kaena. ");
INSERT INTO gvs_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ali ana kareko, ana kówala, adi kaba táoya be nakae ali ana kaba siu ana taboda kaarekoina mana búyala be nakae ana kaba kokavata be nakae kónana liliudi aba paisewa Yauwe ina Kaba Kaiyakayana sinaena manuna. Aba Kaiyakoyana moe ina Kaba Valoboda. ");
INSERT INTO gvs_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","E nakae kwama dedevidi paisewa Bateta Kimaasabaina sinaena manuna simedi. Kwamayadi moe Eroni tauyana Tonúwala ana kwama Yauwe ina paisewa manuna be nakae natunao adi kwama, e bei tauyadi itoboinedi Tonúwala nakae sipaisewa. ");
INSERT INTO gvs_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","E Isileli tubunao paisewa liliudi siguinuwedi nakae kaga liliuna Yauwe boi bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","E kónana liliudi adovatusidi, e agitedi moitamo siguinuwedi nakae Yauwe iidigedi. Tuwo tomotayadi akaipakuyedi. ");
INSERT INTO gvs_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","E Yauwe ilatuwokoigu idigo kana, ");
INSERT INTO gvs_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","‘Tukówana vakuumgoina ana maliyalina vakuumgoina goi guna Kaba Kaiyaka, o kada, “Guna Kaba Valoboda”, bei kovatāoe. ");
INSERT INTO gvs_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Kovatáoe ikavava, sinaena aba vatulúkwana dedeogaina Tukunu goi koyatogamogamōne namliyeta baige vabodaupa kaarekoina kovakosāine dedeogayana kotabōde. ");
INSERT INTO gvs_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ikavava, teboro kokābi, kovaisīu, e yatana konanina kokatubayasīdi. Ikavava, rampa adi kaba yata kovaisīu be ina rampa koyatōidi. ");
INSERT INTO gvs_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ikavava, insensi ana kaba kasala goura aba vatulúkwana matana goi go, vabodaupa kaarekoina toluyena goi koyatogamogamōne. Ikavava, Aba Kaiyakayana ana kaba siu ana taboda kaarekoina kovakosāine. ");
INSERT INTO gvs_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Ikavava, aba kasala vininabeso ana kaigabu manuna guna Kaba Kaiyakayana ana kaba siu toluyena goi kovatumasābe. ");
INSERT INTO gvs_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ikavava, nokobaba kopwa guna Kaba Kaiyakayana be aba kasalayana go, nauyayanaidi goi koyāto namliyeta baige bwae kosiwōi. ");
INSERT INTO gvs_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ikavava, guna Kaba Kaiyakayana kokāli go, aliyana ana kaba siu ana taboda kaarekoina kovakosāine. ");
INSERT INTO gvs_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Ikavava, pútuma aba kaipaku kokābi, guna Kaba Kaiyakayana be nakae kaga liliuna sinaena kosiwōi be kokimasabēdi umagu, e bei guna Kaba Kaiyakayana ma konanina kimaasabaidi umagu. ");
INSERT INTO gvs_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ikavava, pútuma aba kaipaku kokābi, aba kasala vininabeso ana kaigabu manuna ma konanina koputumīdi be kokimasabēdi umagu, e bei aba kasalayana kimaasabaina toina. ");
INSERT INTO gvs_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ikavava, pútuma aba kaipaku kokābi, nokobaba ma kaena koputūmi, e kokimasābe umagu. ");
INSERT INTO gvs_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","E Eroni ma natunao komēdi guna Kaba Valoboda ana kaba siu goi kovaisivēdi. ");
INSERT INTO gvs_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ikavava, kwama kimaasabaidi kokabīdi, Eroni kovalōsi. Niga pútuma aba kaipaku kokābi, tauyana koputūmi be kokimasābe umagu, e bei tauyana Tonúwala nakae ipaaisewa umagu. ");
INSERT INTO gvs_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ikavava, Eroni natunao komēdi, kwama maanawedi goi kovalosīdi. ");
INSERT INTO gvs_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ikavava, pútuma aba kaipaku kokābi, tauyadi koputumīdi tamadi nakae, e bei tauyadi Tonúwala nakae sipaaisewa manugu. Go moe nakae Eroni ma natunao be nakae tubunao liliudi kokimasabēdi umagu, e bei kidi nakae Tonúwala nakae sipaaisewa manugu ame tuta be nakae tuta simamaima yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","E kaga liliuna Yauwe ilovinaegu aguinuwedi, nakae aguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","E tuwo tukówana vakuumgoina ana maliyalina vakuumgoina goi Yauwe ina Kaba Kaiyaka kavatáoe. Moe bogina tala tayamo ikavava ima sowóduwo Itipita mlina goi. ");
INSERT INTO gvs_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","E Livai tubunao alatuwokoidi adigo kagu, ‘Aba Kaiyakayana kovatāoe.’ E ame nakae siguinuwe: Vabodakalova adi kaba táoya siyatoidi, e vabodakalovayadi simosidi. Niga logógana sivaisiudi rini goi be nakae kówala sivataoedi. ");
INSERT INTO gvs_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Sivataoedi ikavava, aba vatumna areko sikabi, Aba Kaiyakayana madabokina sivatum. Ikavava, aba vatumna aito sikabidi, aba vatumnayana areko sivapopo nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","E aba vatulúkwana sikabidi, dedeoga sinaena sidodoidi. Niga aitakeo aiyuwo sikabidi, dedeogayana ana rini goura goi sivaisiudi. Ikavava, aba núwala sikabi, dedeogayana yatana goi sikailagasi. ");
INSERT INTO gvs_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Sikailagasi ikavava, sikaitakeve sinave Tukunu goi sivaisiu namliyeta baige vabodaupa kaarekoina sikabi, sivakosaine aba vatulúkwana dedeogaina sitabode nakae sopagu goi Yauwe bogina ilovina siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","E teboro sikabi, sikaitakeve sinave Aba Valobodayana goi sivaisiu go, yawéyana dadavina vabodaupa kaarekoina toluyena goi siyato. ");
INSERT INTO gvs_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ikavava, beredi sikabidi, teboroyana yatana goi sikailagasidi go, Yauwe matana goi sikatubayasidi nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","E rampa adi kaba yata sikabi, Aba Valoboda goi sivaisiu go, youya dadavina vabodaupa kaarekoina toluyena goi siyato. ");
INSERT INTO gvs_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ikavava, Yauwe matana goi rampayadi silotuvaninimidi sininínima nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","E aba kasala goura sikabi, ina Kaba Valoboda goi sivaisiu go, vabodaupa kaarekoina toluyena goi siyatogamogamone. ");
INSERT INTO gvs_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","E yatana goi insensi mainina dedevina siyato, e sigabu nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","E ina Kaba Kaiyaka ana kaba siu ana taboda kaarekoina sikabi, sivakosaine. ");
INSERT INTO gvs_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ikavava, aba kasala vininabeso ana kaigabu manuna sikabi aba siu toluyena goi sivatumasabe. Ikavava, yatana yoguyogu vininabeso manuna sikailagasi sigabusave, e kutukutu vininabeso manuna sikailagasidi, sigabudi nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","E nokobaba kopwa sikabi, ina Kaba Valoboda be aba kasala kopwa go, nauyayanaidi goi siyato. Ikavava, bwae sitege nokobabayana goi sisiwoi moe adi kaba níkina. ");
INSERT INTO gvs_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","E amoko goi Eroni ma natunao be yau nimama be aema bei kaanikidi. ");
INSERT INTO gvs_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Tutayana Yauwe ina Kaba Valoboda goi kasiu o kavalabelabena aba kasala goi, e mainao nimama be aema kanikidi. Ikavava baige kasiu nakae boi Yauwe bogina ilovinaegu. ");
INSERT INTO gvs_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","E Yauwe ina Kaba Kaiyaka be aba kasala sikalidi. Ikavava, aliyana ana kaba siu ana taboda kaarekoina sivakosaine. E ameko goi paisewayana madabokina alukavave. ");
INSERT INTO gvs_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","E gaota isou Yauwe ina Kaba Valoboda iumai go, Yauweyana ana káeyana tomoeeyalina isiu ina Kaba Kaiyaka madabokina itapasigi. ");
INSERT INTO gvs_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","E gaotayana Aba Valoboda iumai be nakae Yauwe ina kaeyanayana tomoeeyalina ivakayaodei, tauna geya itoboineguta bei Aba Valoboda goi asiu. ");
INSERT INTO gvs_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Go tutayana gaotayana Yauwe ilukake, e kai Isileli tubunao kakatubayasi bei katáoya kaketoiya go, gaotayana kasabookuliye. Nako goi isou, amoko goi kakaaiyaka. Moe nakae kaguuinuwe ima ketoiya ana madabokina goi. ");
INSERT INTO gvs_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Go gaotayana neta Yauwe geya ilukakeyeta, e kai Isileli tubunao geya kaketoiyeta, go sem kakaaiyaka ana kadókana ituko ina. ");
INSERT INTO gvs_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Moitamo. Yauwe ina gaota Aba Kaiyaka yatana goi ikaaiyaka maliyalina. Go sabamgo yeu sabeninimina gaotayana sinaena goi ikaaiyaka. Ame nakae kai Isileli tubunao madabokima ima ketoiya ana madabokina goi. ");
INSERT INTO gvs_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","E koroto tayamo yoina Elimaleka go, monena Naomi taiyao Bedeliyema goi sikaaiyaka. Bedeliyemayana moe Yuda dadavina sinaena. Ma natuudiyao koroto adi taiyuwo; tayamo yoina Maloni, tayamo yoina Kiliyoni go, adi nunu yoina Eparati. E tutayana Isileli idi totaligavayao siilovina, Isileli sinaena loga gagaina isowóduwo losiye pasina. Tuwo Elimaleka monena natunao adi taiyuwo taiyao sitáoya, sina asa Moabe goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Sikaaiyaka aaa, Naomi monena Elimalekayana ikámasa. Tuwo Naomi natunao adi taiyuwo taiyao aditava sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Sikaaiyaka, natunaoyadi Moabe vevinaidi sinaidi, tayamo yoina Opa, tayamo yoina Ruti. Amoko goi sikaaiyaka tala ana badabada yawou ");
INSERT INTO gvs_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","go, Maloni be Kiliyoni adi taiyuwokova nakae sikámasa. Tuwo Naomi monena be natunao bogina sikámasa, tauna anetava ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","E Naomi livala tayamo inove bego Yauwe ina bodao Yuda goi ivaaitedi; adi máliya bogina ivinidi. Tauna yaonao adi taiyuwo taiyao sitáoya, sikatubayasi bego Moabe sikalave go, sikaluvila sina Yuda. ");
INSERT INTO gvs_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Sikatubayasi ikavava, asayana sikaaiyaka goi sikalave go, siketoiya bego sina Yuda. ");
INSERT INTO gvs_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Sinonoina go, Naomi idigo kana, ‘Yaogowo, kokaluvilāmna kōna sinamiyao taiyao kokaaiyāka. Guna kawanoi bego Yauwe ilokatemi nakae komi bogina kolokategu be nakae boi natugowo kolokatedi. ");
INSERT INTO gvs_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Aiyuwoina, guna kawanoi bego Yauwe itagona konaimna bei monemiyao taiyao kokaaiyaka imi vada.’ Tuwo, tauyana iyowoiidi go, kidi sitáiya. ");
INSERT INTO gvs_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Sitáiya, sidigo kadi, ‘Yaoma, geya latuwoma kakalavem. Latuwoma bego kakitaum bei taiyao tana im bodayao yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","E kina go Naomiyana idigo kana, ‘Yaogowo, kokaluvilāmna kōna imi kasa. ¿Kaga pasina latuwomi kokitaugu? Yau geya itoboineguta bei avaitemi. Nakae geya itoboineguta bei natugowo koroto avenatunidi bei monemiyao. ");
INSERT INTO gvs_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Tuwo, kokaluvīla kōna imi kasa. Yau bogina akainamoya, tauna geya itoboineguta anaimna. ¿Go neta sabamgo ame yau koroto tayamo bei anai, taiyao kamasisi akéuwama be natugowo koroto avenatunidi, ");
INSERT INTO gvs_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","manakae? ¿Bei kotuyaosidi, e sibíbina gagaidi baige konaidi? ¿Bei nai kototo? Geya, yaogowo, geya itoboinemita. Yaubada bogina itugavilegu, tauna moumou ivakaigaga yaigu namliyeta komi. Bogina koyagoi. Komi itoboinemi konaimna go, yau geya.’ ");
INSERT INTO gvs_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","E tuwo ina livala sinove, sitaiyamna. E Opa yaona iyowoi ikavava, ikaluvila ina ina kasa go, kina Ruti yaona imatakanikaniye, e ivalabilabine. ");
INSERT INTO gvs_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","E tuwo, Naomi idigo kana, ‘Kunōve. Tuwowom ikaluvilamna ina ina bodao be ina basaleliuyao yaidi. E kom taiyao kokaluvīla.’ ");
INSERT INTO gvs_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Go kina Rutiyana idigo kana, ‘Taabu kukaawanōi yau yaigu bego akalavem, go sem neta kutagonegu bei akitaum. ");
INSERT INTO gvs_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Nako goi kukámasa, ");
INSERT INTO gvs_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","E Ruti ibóbwara ikavava, Naomi bogina iyagoi bego Ruti latuwona toina taiyao sina. Tauna itugau. ");
INSERT INTO gvs_vpl VALUES ("RT1_19a","009_1_19a","RUT","1","19a","19a","E tuwo adi taiyuwokova siketoiya sinonoina Bedeliyema manuna. ");
INSERT INTO gvs_vpl VALUES ("RT1_19b","009_1_19b","RUT","1","19b","19b","Tutayana sisowóduwo Bedeliyema goi sisiu, asa butukaona iyata, e vevina liliudi sima adi taiyuwokova sigitedi, sidigo kadi, ‘¡Iyaa! ¿Amo Naomi ae?’ ");
INSERT INTO gvs_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Go kina Naomiyana idigo kana, ‘Tokalika ikitaitaiyegu, tauna taabu koduuduwēgu Naomi, go sem koduduwēgu Mara. ");
INSERT INTO gvs_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Boi akalavemi maa konagu go, ame tutayana Yauwe ikaluvilemneigu nima kaka. ¿Kaga ana dedevina koduduwegu Naomi? Geya. Yauwe Tokalika itugavilegu be nakae ikitaitaiyegu.’ ");
INSERT INTO gvs_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Tauna nakae Naomi Moabe goi itáoya yaona Ruti guma Moabe taiyao sina Bedeliyema. Ego tutayana sisowóduwo Bedeliyema goi, moe bali ana tuta dibayoya ana kaba vatowo. ");
INSERT INTO gvs_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Bedeliyema goi Naomi yaona tayamo ikaaiyaka. Tauyana toesaesa be nakae koroto gagaina, e yoina Boasa. Boasayana be Elimaleka adi nunu tayamo. ");
INSERT INTO gvs_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","E Ruti guma Moabe Naomi ilatuwoko idigo kana, ‘Yaogu, neta kutagonegu bei yau ana tánuwo tayamo goi bali kutukutuna ana totaupa sitamaumaauidi aseo. Ego ava totaupa ikanuuwoiyegu mlina goi bei aseo.’ Naomiyana kana, ‘Yaogu, kūna nakae kuguinūwe.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Tuwo tauyana ina bali tanuina tayamo goi bali ana totaupaupayao isabokuuliyedi bali kutukutuna vaalutudi iseoseo. Ego tanuwoyana moe Boasa ina tánuwo. ¡Boasayana be Elimaleka adi nunu tayamo! ");
INSERT INTO gvs_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","E Boasayana makaitaga Bedeliyema goi isowóduwo ima, e ina ina todibayoyayao yaidi ikaipakuyedi, idigo kana, ‘¡Yauwe bei ivakitaumi!’ ‘¡Yauwe bei ikaipakuyem!’ tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","E Boasayana ikandobala, Ruti igite, tuwo ilumadádana ina todibayoyayao adi tovakumgo yaina, idigo kana, ‘¿Woiyai amo avatau osiyana?’ ");
INSERT INTO gvs_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","E tovakumgoyana idigo kana, ‘Tauyana ogaoga, guma Moabe. Naomi taiyao Moabe goi sima. ");
INSERT INTO gvs_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Maine vavinayana ima ikawanoi yaigu idigo kana, “¿Neta kutagōna bego bali ana todibayoyayao asabokuuliyedi go, idi bali patumidi kikidi goi kutukutudi vaalutudi aseo?” Atagona, tuwo tauyana tánuwo goi ipaaisewa gagaina nobuyana go, ima ame tuta. Ego tuta giyaina tauna iwaiwasi.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","E tuwo Boasa ina Ruti ilatuwoko idigo kana, ‘Vavina, kunovēgu. Taabu kunonōina ituli ta tánuwo goi kuseoseo, go sem guna topaisewayao vevina kikidi kuvalaabilābina, e taiyao koseosēo. ");
INSERT INTO gvs_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ago koroto kugitēdi nako goi sipaaisewa go, sitamaumáuwo. Amoko goi kūna vevinayadi taiyao koseosēo. Korotoyadi bei alatuwokoidi geya sikitaitaiyemta. Neta maem isayasaya, kūna nako goi tauyadi bwae sitege siyatoyato, moe kwābi kunīm.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","E tuwo, Rutiyana ivatugúyala ikanakabobo go, idigo kana, ‘¿Yau ogaoga go, kaga unana kukanuwoiyegu be yau manugu kunuwonúwana?’ ");
INSERT INTO gvs_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","E Boasayana idigo kana, ‘Vatetelim madabokina tomota bogina sivateteli anove. Nakae kaga liliuna kuguuinuwedi yaom manuna tutayana monem ikámasa. Ayagoi tamam be sinam kwalavedi be nakae im kasa kwalave, e kuma ameko bego kwaiyako vata go, boi boda ame geya kuyagoiyeta. ");
INSERT INTO gvs_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Bei Yauwe, kai Isileli tubunao ima Yaubada, am vaiwówana ivinim im guinuwa pasina. Bogina kuma Tauyana panepanena goi bego ivainugonem.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","‘Guna tomoya, matam goi anuwóiya bogina ababane. Moitamo. Yau im pákwana bogina kukipaiwolegu be nakae atepatu kuvinigu go, yau im pákwana vevina im pakonayao sobuyekoidi nakae’, Ruti kaena. ");
INSERT INTO gvs_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","E niga áika ana tuta goi Boasa idigo kana, ‘Ruti, kubāla kūma ameko. Ame avam. Oine bwaena yuyuyuna goi kuvaigāde, e kwāika.’ Tuwo moitamo Ruti ibala ina tauyana ina todibayoyayao kikidi itusobu ivaigade, e ikáika. Ago Boasa bali kutukutuna aiigabudi nakae ivini ikáika. Ikakáika, bogina gamona go, kutukutuyadi maniyena sikesa. ");
INSERT INTO gvs_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","E Ruti bogina itáoya, ikaluvilamna ina ana bali iseoseo go, Boasa ina pakonayao koroto ilovinaedi idigo kana, ‘¡Kotagōna tauyana bali patumidi kikidi goi iseoseo go, taabu koobōve! ");
INSERT INTO gvs_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Nakae maniyena kobuyagīdi kokaisobuyēdi kokalavēdi, e Ruti itoboine isevedi go, taabu koobōve.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","E tuwo Ruti bali ana tánuwo goi iseoseo ana kadókana lavilavi. Tutayana bali ikausapisapidi ikavava, bayao tayamo nakae ikayaoda. ");
INSERT INTO gvs_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ikausapisapi ikavava, e ina bali ma bayaoina ikabi, ikaluvilamna ina ina kasa goi baliyana yaona ivatuluko kaga bogina isevedi. Ago kutukutuyadi ikaabogedi yaona ivini ikáika. ");
INSERT INTO gvs_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","E Naomi ikandosobu kutukutuyadi igitedi, yaona yaina ilumadádana idigo kana, ‘¿Yaogu, ame nako goi bali kuseoseo? ¿Avatau ina tánuwo goi? Guna kawanoi bego korotoyana ikanuuwoiyem Yauwe bei ikaipakuye.’ Tuwo Rutiyana ina paisewa manuna ivatétala, idigo kana, ‘Korotoyana ina tánuwo goi aseoseo moe yoina Boasa.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomiyana mana uyáwana idigo kana, ‘¡Yaogu, latuwogu Yauwe ikaipakuye! ¡Yauweyana ilokateda, kita maa yawoida be kidi tokámasa!’ Naomi tuwaina kana, ‘¡Amo korotoyana monegu osiyana, ada totateta! Tauna kai Isileli tubunao ima sinapu goi tauyana itoboine imatakavateda.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","E Rutiyana guma Moabe idigo kana, ‘Tuwaina korotoyana ilatuwokoigu idigo kana, “Tuwaina kuseosēo guna pakonayao taiyao ana kadókana guna dibayoya madabokina silukavave.”’ ");
INSERT INTO gvs_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi idigo kana, ‘Natugu, moe dedevina kuna Boasa ina tánuwo goi kuseo ina pakonayao vevina taiyao. Neta kuna ituli ta tánuwo goi kuseo, govila todibayoya koroto sikitaitaiyem.’ ");
INSERT INTO gvs_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","E tuwo Rutiyana Boasa ina topaisewayao vevina kikidi ivalaabilábina, e witi be bali iseoseo tauyadi taiyao ana kadókana dibayoya ana kaba lukavava. Ikavava, Ruti yaona taiyao sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","E Naomi inuwonúwana Ruti manuna, tuwo ilatuwoko idigo kana, ‘Natugu, dedevina koroto tayamo alusale monem, bei im kaiyaka dedevina. ");
INSERT INTO gvs_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","¿Boasa kunuwokavate? Tauyana ina pakonayao vevina taiyao boi koseoseo. Amo korotoyana monegu osiyana. Kunōve. Sabamgo ame aba kausapisápina goi bei bali itakino. ");
INSERT INTO gvs_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","E kom kūna kuisīwo. Ikavava, kupūtuma be nakae am kwama dedevina toina kulōsi go, kusōu kūna nako tauyana iitakínona goi. Ego tauyana taabu iigitēm ana kadókana ikáika ikavava, imasisi. ");
INSERT INTO gvs_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ago kom kūna tauyana kugīte nako goi iimasisi. Bogina iimasisi, e ina tanigo kunīsi go, aena kikina goi kumasīsi. Moe nakae matakavata kukawanoiye. Namliyeta baige bei ilatuwokoim kaga bei kuguinuwe.’ ");
INSERT INTO gvs_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","E Rutiyana idigo kana, ‘Kaga liliuna kuudigedi bei aguinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Tuwo moitamo tauyana ina aba kausapisápina goi kaga yaona iidigedi nakae iguinuwedi. ");
INSERT INTO gvs_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","E Boasayana ikáika ikavava, ina lotówana dedevina, tuwo ina bali gugunina kikina goi imasisi. Niga go Rutiyana ivasinamo ina tauyana ina tanigo inisi, e aena kikina goi imasisi. ");
INSERT INTO gvs_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","E nobunatoina goi Boasa ikaliwoisa ikanagavila, e vavinayana igitebabane aena kikina goi imasisi ikanamatáiya. ");
INSERT INTO gvs_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","E idigo kana, ‘¡Iyaa! ¿Kom avatau?’ ‘Yau Ruti, im pákwana. Kom yaogu kaamasina osiyana guna totateta. Tauna, kwabīgu be kumatakavatēgu’, Ruti kaena. ");
INSERT INTO gvs_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boasayana idigo kana, ‘¡O vavina! ¡Yauwe ikaipakuyem! Boi im lokata gagaina yaom yaina goi go, ame tutayana im lokata gagaina toina yaigu. Boi tubuwau geya kulusaleta bego kunai, toesaesa o tokai. ");
INSERT INTO gvs_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ago vavina, geya kumatoiteta geya. Kaga liliuna kukawaanoiye bei aguinuwe. Moitamo. Tomota liliudi asa goi siyagoi kom guma Moabe; vavina dedevim. ");
INSERT INTO gvs_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ego moe moitamo yau yaom kaamasina osiyana ina totateta be nakae itoboinegu amatakavatem go, koroto tayamo ikaaiyaka, tauyana totubukumgo. Tauna tauyana mana lovina itoboine imatakavatem. ");
INSERT INTO gvs_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ameko goi kuumasīsi vanuwo itomo. Itomo nobuyana ana tauyana agite. ¡Neta itagona bego imatakavatem, e dedevina, go geya, Yauwe yoina goi akatótula, yau bei amatakavatem! Ago ame tutayana kuumasīsi ana kadókana itomo.’ ");
INSERT INTO gvs_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","E tuwo Boasa aena kikina goi Rutiyana imasisi ana kadókana botomotomo itáoya. Boasa ina nuwonúwana kana, ‘Geya latuwogu tomota siyagoi bego vavina tayamo ima aba kausapisápina goi imasisi.’ ");
INSERT INTO gvs_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Tutayana Ruti itáoya, Boasa idigo kana, ‘Am tanigo kunīsi kuvinīgu go, dadavina kuyoisikavāte.’ Tuwo ivini, e Boasayana bali kutukutuna nakae bayao tayamo ikabi, Ruti ana tanigo goi isiwoi. Ikavava, e Rutiyana ivavabe. Ikavava, Boasa itáoya ina asa. ");
INSERT INTO gvs_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Go Ruti ikaluvilamna ina ina kasa goi baliyana yaona ivini. Yaonayana ilumadádana idigo kana, ‘¿Natugu, im ketoiya manakae?’ Tuwo kaga liliuna Boasa bogina iguinuwe, e manuna Rutiyana ivatétala, ");
INSERT INTO gvs_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","idigo kana, ‘Boasa ilatuwokoigu idigo kana, “Geya itoboinemta nima kaka kwaluvila kuna yaom yaina.” Tauna bali kutukutuna gagaina ivinigu.’ ");
INSERT INTO gvs_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi idigo kana, ‘Ruti, om inūwa. Nava bei tagite kaga isowóduwo yaim. Moitamo. Boasa ame bei iguinuwa manum.’ ");
INSERT INTO gvs_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","E kina go Boasayana ituko ina asa ana kaba siu goi itusobu. Aba siuyana moe idi kaba tugúguna. Iitusobu go, totateta manuna boi Ruti bogina ilaatuwoko, e igite iiketoiya imamaima. Tuwo iduduwe idigo kana, ‘Toi, kūma ameko goi kutusōbu.’ Tuwo tauyana ima itusobu. ");
INSERT INTO gvs_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","E Boasa asa ana tolovinayao ana badabada yawou iduduwedi sima ilatuwokoidi situsobu, bei idi tugúguna sitaiyakeke. ");
INSERT INTO gvs_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","E Boasa totatetayana ilatuwoko idigo kana, ‘Naomi bogina Moabe goi ikaluvilamna ima go, tauyana latuwona osiyada kaamasina Elimaleka ina poyapoya ana tagona ibisilave. ");
INSERT INTO gvs_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Yau anuwonúwana dedevina kom kuyagoi. Neta poyapoyayana latuwom kutatete, e tolovina ame matadi goi kutatēte. Ago geya, kulatuwokoigu bei ayagoi. Geya kada tayaamo koroto mana lovina geya; kom tauna amta kuulovina. Yau sobuyekoim.’ ‘Bei atatete’, toi kaena. ");
INSERT INTO gvs_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Go kina Boasayana idigo kana, ‘Tutayana poyapoyayana ana tagona kukabi Naomi yaina, e Ruti, tauyana kóbuya guma Moabe, nakae bei kukabi kunai, e bei tokámasa yoina ikaaiyaka be nakae ina kaiguyauyana ikaaiyaka ina nunu sinaena.’ ");
INSERT INTO gvs_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Go kina totatetayana idigo kana, ‘Neta moe nakae, guna lovina akaidamane yaim. Yau geya itoboineguta Ruti anai, govila bei natugowo idi dalowo giyaina. Tauna kom toinim kutatēte go, yau geya latuwogu.’ ");
INSERT INTO gvs_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Ego boi nimatu Isileli tubunao idi katótula ana sinapu osenao adi tateta be kónana adi talamapu manudi ame nakae: Koroto tayamo ana sendoro ivalilivi go, siyana ivini. Moe nakae poyapoya ana kaidámana o lovina ana kaidámana bogina sikatotule. ");
INSERT INTO gvs_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Tuwo tutayana totatetayana idigo kana, ‘Kom toinim kutatēte’, e ana sendoro ivalilivi go, Boasa ivini. ");
INSERT INTO gvs_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","E Boasayana koroto gagaidi be tomota madabokidi matadi goi idigo kana, ‘Ame komi toinimi matami goi bogina kogite bego yau Elimaleka, Maloni be Kiliyoni konadi madabokidi Naomi yaina goi akabidi. ");
INSERT INTO gvs_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Aiyuwoina Ruti guma Moabe, tauyana Maloni kobuina, anai. Moe bego tokamasayana ina kaiguyau ikaaiyaka ina nunu sinaena. Nakae ana katumapu bei ibíbina, e yoina geya itagauta. ¿Ame komi bogina kogite?’ ");
INSERT INTO gvs_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Koroto gagaidi be tomota liliudi aba siuyana goi sikaaiyaka kadi, ‘U, bogina kagite.’ E tuwo sikaodedevine sidigo kadi, ‘Ame vavinayana giyakainava bei kunai, bei kina Yauwe ivaite bego ivenátuna nakae Reitiyeli be Reya sivenátuna; tauyadi natudiyao badabadaidi kai Isileli tubunao manuma. Bei esaesa kubabane im nunu Eparati sinaena. E nakae bei Bedeliyema goi tomota liliudi yoim siiyagoi. ");
INSERT INTO gvs_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Bei Yauwe natumowo ivinim vavinayana yaina, e bei im nunu gagaina nakae Peresi ina nunu gagaina, tauyana Yuda be Temari natudi.’ ");
INSERT INTO gvs_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Tuwo moitamo Boasa Ruti sinai go, Yauwe ina vaita goi ikéuwama, namliyeta ivenátuna, natuna koroto. ");
INSERT INTO gvs_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Vevina sidigo kadi, ‘¡Yauwe tayapalīye! Tauyana tubum ivinim am totateta bei imatakavatem. Bei Yauwe ina guinuwa goi gomanayana yoina gagaina Isileli sinaena. ");
INSERT INTO gvs_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Yaom imatakoiyem be nakae ivaitem gagaina. Neta kom natumowo koroto ainima aiyuwo, geya adi kaipatamo sivaitem nakae yaom ivaitem. E ame tutayana tubum ivinim; tauyana bei yawoim ilisi tutayana kwainamoya.’ ");
INSERT INTO gvs_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Tuwo Naomi ibala ina gomanayana ikabi, ivayavau, e imatakavate. ");
INSERT INTO gvs_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Vevina tomota liliudi yaidi sidigo kadi, ‘Ame tutayana Naomi ma tubuna.’ Ago gomanayana sivayou Obedi; tauyana nava bei natuna Diyesi. Nava bei Diyesi natuna Devida. ");
INSERT INTO gvs_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Tuwo Peresiyana ina nunu ame nakae: Peresi natuna moe Esironi. ");
INSERT INTO gvs_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Esironi natuna moe Ram. Ram natuna moe Aminadabi. ");
INSERT INTO gvs_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadabi natuna moe Nakasoni. Nakasoni natuna moe Salimoni. ");
INSERT INTO gvs_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salimoni natuna moe Boasa. Boasa natuna moe Obedi. ");
INSERT INTO gvs_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obedi natuna moe Diyesi. Diyesi natuna moe Devida. ");
INSERT INTO gvs_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Tétala ame Amitai natuna Iyona tetelina. E tuta tayamo Yauwe ina livala ina Iyonayana yaina idigo kana, ");
INSERT INTO gvs_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","‘Iyona, Ninivei asa gagaina go, da Ninivei idi goyo yau matagu goi ivakaigaga toina, tauna kutāoya, woilīm kūna asayana goi kuliwolēdi.’ ");
INSERT INTO gvs_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Go kina Iyonayana itáoya bego Yauwe yaina goi isiya ina Tasisi. Mainao isou iiwo ina Yopa goi oga tayamo ibabane bei ikailova ina Tasisi. Tuwo iemáisa ikavava, isowoya taiyao bei sina amoko goi isou Yauweyana yaina isiya. ");
INSERT INTO gvs_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","E isowoya ikavava, sikailova sinonoina. E kina go Yauweyana yágira gagaina ibisilave isou ina oga isanabode. Tuwo yailúwasa itowo nakae aivaya sisowóduwo, e ana kaigigita bei oga sikauvisivisi. ");
INSERT INTO gvs_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Tuwo gelugelu simatoita gagaina, e tamo tamo sipodeda toinidi idi basaleliuyao yaidi, sidigo kadi, ‘¡Oiyoi, kovaitēma!’ Siipodeda, geya, tuwo kónana sisavedi sisou négwasa goi bego oga ikakapu. Ego kina Iyonayana bogina isou ina oga sinaena goi iimasisi, ikanamatáiya toina. ");
INSERT INTO gvs_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Tuwo kapiteni isou ima Iyonayana iwoini, idigo kana, ‘¡Iyaa! ¿Kom kaga kumasisiye? ¡Kutāoya! ¡Kupodēda im basaleliu yaina! Nakona moe basaleliuyana bei inoveda, e geya tavailaita.’ ");
INSERT INTO gvs_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","E gelugeluyadi aditava sibobóbwara, sidigo kadi, ‘Aba yagoina taodūgu bei taayagoi avatau ina puwoya, tauna vailai ame tababane.’ Tuwo moitamo, aba yagoinayana siiwodugu moe tomota sikatuyaividi. Idi katuyaivayana goi Iyona yoina isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Tuwo tauyana silumadade sidigo kadi, ‘¿Kulatuwokōima avatau ina puwoya, tauna vailai ame tababane? ¿Im paisewa kaga goi kwaaiyaka? ¿Kom nako korotoim? ¿Im bodao avatauwa?’ ");
INSERT INTO gvs_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","‘Yau Iberiu. Yauwe, Tauyana Yaubada totobukukui yábana goi négwasa be poyapoya imadagidi; moe Tauyana ataaimamine’, Iyonayana kaena. ");
INSERT INTO gvs_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Tuwaina tauyana kana, ‘Ame Yauweyana yaina goi asiya.’ Tuwo tauyadi simatoita gagaina, tauna sidigo kadi, ‘¿Go kom kaga kuguinuwe bego kusiya?’ ");
INSERT INTO gvs_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Iyonayana bego ikatumapu go, aivaya ivaituwe gagaina, tuwo kidi sidigo kadi, ‘¿Kaga kaguinuwe yaim bego ikadaúmwara?’ ");
INSERT INTO gvs_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Tauyana idigo kana, ‘Bogina aayagoi bego yau guna puwoya vailai ame tababane. Tauna kokabīgu go, kolavēgu asou négwasa goi bei ikadaúmwara.’ ");
INSERT INTO gvs_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","E kidi gelugeluyadi geya sikabiyeta, go sem oga sibeusikone; latuwodi bego siyava sina mamaya go, aivaya ivaituwe gagaina toina, tauna geya adi kaipatamo. ");
INSERT INTO gvs_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Tuwo kidi sipodeda Yauwe yaina, sidigo kadi, ‘O Yauwe, kakawanoiyem, ame korotoyana bei kakaumate go, ina kámasa pasina taabu kutaagonēma kavaailai. Nakae taabu kam, “Komi imi puwoya koroto dedevina ame ikámasa.” Kom, Yauwe, moe im guinuwa toinim kuguinuwe nakae latuwom.’ ");
INSERT INTO gvs_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","E Iyonayana sikabi, silave isou ina négwasa goi, e yailuwasayana mainao ikadaúmwara. ");
INSERT INTO gvs_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Tuwo Yauwe simatoite gagaina toina, tuwo sikatótula be nakae yoguyogu sikasaledokoidi Yauwe yaina, e sivakasavedi. ");
INSERT INTO gvs_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","E Iyonayana isou ina négwasa goi go, Yauwe íyana tayamo gagaina ietune ina tauyana itono. Tuwo iyanayana sinaena goi ikaaiyaka maliyalina aito be sabamgo aito. ");
INSERT INTO gvs_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","E tuwo Iyonayana íyana sinaena goi ikawanoi Yauwe ina Yaubada yaina ");
INSERT INTO gvs_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","idigo kana, ");
INSERT INTO gvs_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Boi kulavegu asou ana dimówana tututu goi, ");
INSERT INTO gvs_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Tuwo yau guna nuwonúwana kagu, ");
INSERT INTO gvs_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Asou négwasa ituko ima nukotogu goi, ");
INSERT INTO gvs_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Asou ana niku unana toina goi. ");
INSERT INTO gvs_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","E guna lotówana alotowo bego akámasa go, ");
INSERT INTO gvs_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Avatauwa neta siinumisa tokwalu ");
INSERT INTO gvs_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Go yau sem magu vesi kaauyaguna ");
INSERT INTO gvs_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","E iyanayana kina Yauwe ilovinae Iyona ilagobe. Tuwo moitamo ilagobe ina mamaya goi itowo. ");
INSERT INTO gvs_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","E sivayuwoina Yauwe ina livala ina Iyona yaina ");
INSERT INTO gvs_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","idigo kana, ‘Iyona, kutāoya, woilīm kūna asa gagaina Ninivei goi guna livala bei alatuwokoim kutalavāite da Niniveiyadi yaidi.’ ");
INSERT INTO gvs_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","E tuwo moitamo Iyonayana itáoya mainao ina Ninivei nakae Yauwe idige. ¡Niniveiyana asa gagaina nakae ana papaeva maliyalina aito nakae neta taaketoiya! ");
INSERT INTO gvs_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","E Iyona ina Ninivei goi isiu ina maliyalina tayamo goi iiketoiya go, iiliwola da Ninivei yaidi idigo kana, ‘“Maliyalina 40 sikavava, Ninivei bei atusaoli”, Yauwe kaena.’ ");
INSERT INTO gvs_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","E tuwo livalayana da Ninivei sinove, Yaubada sinumise. Tuwo toinidi silovina kadi, ‘¡Liliuda tadiyakīmwana!’ Tuwo moitamo tomota liliudi gagaidi be giyaidi sidiyakímwana be nakae kwama salisalidi silosidi. Moe nakae aba kinana bego bogina situgavila. ");
INSERT INTO gvs_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","E tutayana livalayana da Ninivei adi tolovina inove, e kebana esaaesaina goi itáoya, isou ina tanigo dedevina inisi go, kwama salisalina ilosi, e silekauna goi itusobu. Moe nakae aba kinana bego bogina itugavila. ");
INSERT INTO gvs_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Da Ninivei idi lovina ivinidi idigo kana, ‘Lovina ame yau imi tolovina be nakae imi tomoyamoya goi iwo yaimi. Lovinayana ame nakae: Kita tomota be nakae yoguyogu gagaidi be giyaidi taabu takakâika be nakae taabu tanimnîm, ");
INSERT INTO gvs_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","go sem liliuda kwama salisalidi talosîdi be areko salisalidi takabídi yoguyogu toludi tavatûmdi. E liliuda takawanoi makimâki Yaubada yaina. Ida sinapu goyogoyoidi manudi be nimada ana gasisi manuna tatugavila. ");
INSERT INTO gvs_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Seki, geya tayagoiyeta, nakona Tauyana nukotona igoyo bei itavívila, tauna ina egamogamogu gagaina itugavile, e bei geya tavailaita.’ ");
INSERT INTO gvs_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","E idi guinuwayadi Yaubada igitedi bego idi sinapu goyogoyoidi goi bogina situgavila, tuwo itavívila, e boi vailai idigedige bego iivinidi geya iguinuweyeta geya. ");
INSERT INTO gvs_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","E Yauwe ina guinuwayana moe igoyo, igoyo toina kina Iyona ina nuwonúwana goi, tauna gamona igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Tuwo ikawanoi Yauwe yaina idigo kana, ‘¡Iyaa! ¿Yauwe, manakae? ¿Boi guna kasa goi nakae adige bei isowóduwo ae? Moe pasina woiligu asiya bego ana Tasisi unana bogina ayaagoim bego Kom Tokavavágana kanuuwoiim be nuwokaapisim, mesayaaganim, im lokata ivakaigaga be nakae im vailai goyogoyoina manuna kutavívila. Tauna woiligu asiya. ");
INSERT INTO gvs_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","E tauna Yauwe, yawoigu kukabiyāmo unana ámasa dedevina yaigu go, ma yawoigu yaigu geya idedevineta. Tauna yawoigu kukābi.’ ");
INSERT INTO gvs_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Go kina Yauweyana idigo kana, ‘¿Manakae? ¿Itoboine gamom igoyo toina gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","E Iyonayana itáoya, asa ikalave go, ina panabomatu goi yoyou tayamo iyowo. Iyowo ikavava, yoyouyana nugonina goi itusobu iituyáwata. Latuwona bego igite kaga bei isowóduwo asayana goi. ");
INSERT INTO gvs_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","E Yauwe Yaubada aba kinana tayamo iguinuwe. Ilovina bego yaguyaguma tayamo itabo, ibíbina ina Iyona yatanaina ivainugone, e bei tauyana ina kaiyaka goyogoyoina goi ivaite. E yaguyagumayana manuna iuyáwana gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","E tomo ana sipasipa iliiyabale go, Yaubada motemoteta ietune ina yaguyagumayana isiu ikani. Ikani, e yaguyagumayana imémala. ");
INSERT INTO gvs_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Niga go níyala ituko, Yaubada yágira bomatu yaviyavina ietune ina Iyona yaina goi. Tuwo níyala Iyonayana dabana ivayavisi gagaina, e imataginigini nakae latuwona ikámasa. Tuwo tauyana mana egamogamogu idigo kana, ‘Ámasa dedevina yaigu go, ma yawoigu yaigu geya idedevineta.’ ");
INSERT INTO gvs_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Go kina Yaubada idigo kana, ‘¿Manakae? ¿Itoboinem gamom igoyo yaguyaguma giyaina ana kámasa pasina?’ Iyonayana idigo kana, ‘¡Itoboinegu gamogu igoyo toina!’ ");
INSERT INTO gvs_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","E tuwo kina Yauwe idigo kana, ‘¿Kom yaguyagumayana giyaina manuna nukotom igoyo ae? Go yaguyagumayana manuna geya kupaiseweta nakae geya tayaamo kaga kuguinuwe bego ibíbina. Ego sabamgo tayamo goi itabo go, sabamgo aiyuwoina goi ikámasa. Manuna nukotom igoyo go, moe dogoi besobeso. ");
INSERT INTO gvs_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Ninivei moe asa gagaina nakae tomota adi badabada 120,000 be nakae yoguyogu badabadaidi sikaaiyaka go, tomotayadi sitamoogemoge. ¿Manakae? ¿Itoboinegu amo asayana gagaina anuwokapisiyedi namliyeta yaguyagumayana gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Buki ame moe Yeisu Guyau ana liliu bukina. Tauyana tubuna moe tokalibúbuna Devida go, tubuna gagaina moe Eberamo. ");
INSERT INTO gvs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Liliuyana ame nakae: Eberamoyana natuna Aisake. Aisakeyana natuna Yakobo. Yakoboyana natunao moe Yuda senao taiyao. ");
INSERT INTO gvs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudayana natunao moe Peresi be Serako go, sinadi moe Temari; tauyana Totuyoyowo tayamo. Peresiyana natuna Esironi. Esironiyana natuna Eram. ");
INSERT INTO gvs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Eramyana natuna Aminadabi. Aminadabiyana natuna Nakasoni. Nakasoniyana natuna Salimoni. ");
INSERT INTO gvs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimoniyana natuna Boasa go, Boasayana sinana moe Reyabi; tauyana Totuyoyowo tayamo. Boasa natuna Obedi go, Obediyana sinana moe Ruti; tauyana Totuyoyowo tayamo. Obedi natuna Diyesi. ");
INSERT INTO gvs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Diyesiyana natuna moe tokalibúbuna Devida. Devidayana natuna moe Solomoni. Solomoniyana sinana moe Uriya kobuina. Kobuinayana Totuyoyowo tayamo. ");
INSERT INTO gvs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomoniyana natuna Reyoboam. Reyoboamyana natuna Abiya. Abiyayana natuna Asepi. ");
INSERT INTO gvs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asepiyana natuna Iyosepata. Iyosepatayana natuna Yoram. Yoramyana natuna Usayau. ");
INSERT INTO gvs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usayauyana natuna Yotam. Yotamyana natuna Eyasi. Eyasiyana natuna Kisakiyau. ");
INSERT INTO gvs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Kisakiyauyana natuna Manase. Manaseyana natuna Emosi. Emosiyana natuna Yosiyau. ");
INSERT INTO gvs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiyauyana natunao moe Yekonaya senao taiyao. Amo tutayana da Babiloni sima Isileli tubunao sikabidi, sinavedi Babiloni goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","E sinavedi Babiloni goi mlina: Yekonayayana natuna Salatiyeli ibíbina. Salatiyeliyana natuna Serubabela. ");
INSERT INTO gvs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabelayana natuna Ebiuda. Ebiudayana natuna Eliyakim. Eliyakimyana natuna Asora. ");
INSERT INTO gvs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorayana natuna Sadoki. Sadokiyana natuna moe Ekim. Ekimyana natuna moe Eliuda. ");
INSERT INTO gvs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudayana natuna Eliyasa. Eliyasayana natuna Madani. Madaniyana natuna Yakobo. ");
INSERT INTO gvs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakoboyana natuna moe Iyosepa, Meri monena. Meriyana goi Yeisu ibíbina go, Yeisuyana tomota sivayoko kina Guyau. ");
INSERT INTO gvs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tauna Yeisu tubunao adi badabada ame nakae: Eberamo goi go, ima Devida goi moe malamalágata ana badabada yawou aivasi. Devida goi go, ima Isileli tubunao idi tuta sina Babiloni goi moe malamalágata ana badabada yawou aivasi. Idi tuta Babiloni goi go, ima Guyau ina tuta moe nakae malamalágata ana badabada yawou aivasi. ");
INSERT INTO gvs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","E Yeisu Guyau ina bíbina ame nakae: Sinana Meri Iyosepa ana kamatákwana taiyao geya situyuwoita go, Baloma Kimaasabaina ana kaiguyau goi Meri bogina gómana ibabane. ");
INSERT INTO gvs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","E Meri monena Iyosepayana koroto tokibóbwata. Tuwo geya latuwona Meriyana igieomaemae, tauna ina nuwonúwana bego ivaisobuyegau. ");
INSERT INTO gvs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Moe manuna inuuwonúwana go, matana imasisi, e imasisi ikanamatáiya. Ina masisiyana goi ikanamimi. E ina kanamimiyana goi Yauwe ina anerose matabuwona isowóduwo ikatuwoini, idigo kana, ‘Iyosepa, Devida tubuna, taabu kuumatōita bei Meri kukabi monem. Gamona sinaena gomanayana ibibíbina moe Baloma Kimaasabaina ina kaiguyau goi ima. ");
INSERT INTO gvs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","E gómana koroto bei ivenatuni go, gomanayana kuvayou Yeisu. Ina bodao idi goyo goi bei iyavedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","E moe dogoiyadi liliudi sisowóduwo bego itoboine Yaubada ina tokabivalavala ina talavaita imalatomotamna. Talavaitayana moe Yauwe ina vala boi italavaitedi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Kunōve! Woiyai geya ana kanaotamo bei ikéuwama, niga natuna koroto bei ivenatuni. Go yoina bei sivayou Imanuweli.’ Aiseya 7:14 Youyana ana kaigavila moe Yaubada kita taiyao. ");
INSERT INTO gvs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","E tuwo Iyosepa masisi goi itáoya, kaga Yauwe ina aneroseyana bogina ilaatuwoko nakae iguinuwe. Tuwo vavinayana ikabi monena ");
INSERT INTO gvs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","go, sakavaina geya ibisikoneyeta ana kadókana natuna ivenatuni. Ivenatuni ikavava, e Iyosepa ivayou Yeisu. ");
INSERT INTO gvs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","E Yeisu Bedeliyema goi ibíbina, moe Yudiya sinaena. Amo tutayana tolovina Erodi nava iilovina. Yeisu ina bíbina mlina utuna adi tonanamsa ma matabuwodi bomatu goi sima Yerusalema. ");
INSERT INTO gvs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Sima, silumadádana kadi, ‘Komi Diyuu imi Tokalibúbuna bogina ibíbina go, Tauyana nako? Ina utuna kagite ituko, e kasabokuliye kama bei Tauyana yaina kasakululu. Tauna kulatuwokōima Tokalibubunayana nako ikaaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","E lumadadanayana tolovina Erodi inove, toinina ina lovina manuna ikateyova go, kidi da Yerusalema liliudi atedi siyova unana nakona bei kaga iguinuwe yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tuwo Diyuu adi Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao madabokidi ikaunokunokudi sima ilumadadedi idigo kana, ‘Guyau, Yaubada ana Vadámana, nako bei ibíbina?’ ");
INSERT INTO gvs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","E tauyadi kadi, ‘Yudiya asaina Bedeliyema goi. Moe nakae Yaubada ina tokabivalavala igini kana, ");
INSERT INTO gvs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Bedeliyema e, ");
INSERT INTO gvs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","E tuwo kina go Erodiyana inuwonúwana, geya, tonanamsayadi iduduwegaudi sima, e ilumadadedi utunayana manuna bego iyagoidoko ava tuta igimisowóduwo sigite. ");
INSERT INTO gvs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Silatuwoko ikavava, Erodiyana idigo kana, ‘Kōna gomanayana kolusaledōko. E tutayana kobabane, kōma kolatuwokōigu bei yau nakae ana asakululu Tauyana yaina.’ Ilatuwokoidi ikavava, ietunedi sina Bedeliyema. ");
INSERT INTO gvs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","E tolovina Erodi ina livalayana sinove, sisowóduwo go, sikainaopa unana utunayana boi sigite itukotuko matabuwona aiyuwoina isowoduwomna! Tuwo ivakededi sina go, vada tayamo yatanaina goi isayata. Vadayana sinaena gómana ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","E utunayana sigite, siuyáwana, to siuyáwana gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tuwo sina vadayana goi sisiu, gomanayana sigite sinana Meri taiyao. Sigite, aedi sivatugúyala, sisakululu gomanayana yaina. Sisakululu ikavava, idi esaesa dedeogaidi sikatupaevedi go, idi yabobona sikabidi, sikasaledi gomanayana yaina. Yabobonayadi moe goura, aidekoko sisina be alovamamaina sisina. ");
INSERT INTO gvs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Niga idi tuta aluvila, sikanamimi go, idi kanamimiyadi goi Yaubada ilatuwokoidi idigo kana, ‘Taabu kokaaluvīla kononōina Erodi yaina.’ Tuwo sitáoya, ituli ta kenao goi sikaluvila sina idi kasa. ");
INSERT INTO gvs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","E tonanamsayadi sikaaluvila go, Iyosepa imasisi, ikanamimi. Ina kanamimiyana goi Yauwe ina anerose matabuwona isowóduwo Iyosepa ikatuwoini idigo kana, ‘Iyosepa, kutāoya! Gómana ma sinana kwabīdi go, kosīya kōna Itipita goi. Amoko goi kokaaiyāka ana kadókana alatuwokoim. Erodi ina tovayaviyayao bei ilatuwokoidi sina gomanayana silusale bego sikaumate.’ ");
INSERT INTO gvs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","E tuwo moitamo nava sabamgo tauyana ikabitaotáoya gomanayana ma sinana ikabidi, taiyao sina Itipita. ");
INSERT INTO gvs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Amoko goi sikaaiyaka ana kadókana Erodi ikámasa. Moeko goi kaga Yauwe ina tokabivalavala goi itaalavaite itoboine imalatomotamna. Livalayana kana, ");
INSERT INTO gvs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","E niga kina Erodi livala inove bego tonanamsayadi sikatubau, tuwo gamona igoyo toina. E ina tovayaviyayao ietunedi sina Bedeliyema be nakae asa giyaidi liliudi kikina goi gogómana koroto adi tala aiyuwo nakae kana isou ina liliudi sikaumatedi. Moe unana boi tonanamsayadi Erodi silatuwoko ava tuta utunayana sigimigite go, moe tala aiyuwo sikavava bogina. ");
INSERT INTO gvs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Amoko goi tokabivalavala Yeremaya ina livala imalatomotamna, tauyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Níyana tayamo Rama goi sinove, ");
INSERT INTO gvs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","E Erodi ina kámasa mlina Iyosepa nava Itipita goi ikaaiyaka go, tuta tayamo imasisi, ikanamimi. Ina kanamimiyana goi Yauwe ina anerose matabuwona isowóduwo ikatuwoini ");
INSERT INTO gvs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","idigo kana, ‘Kutāoya! Gómana ma sinana kwabīdi, kokaluvīla kōna Isileli goi. Tauyadi boi sipooikíkina bego gomanayana sikaaumate bogina sikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","E tuwo moitamo tauyana itáoya, gómana ma sinana ikabidi, sikaluvilamna sina Isileli goi. ");
INSERT INTO gvs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","E sima go, Iyosepayana vala inove bego Erodi ana katumapu moe natuna Arekeleo Yudiya goi iilovina. Tuwo imatoita; geya latuwona sina amoko. E sabamgo tayamo imasisi, ikanamimi go, ina kanamimiyana goi Yaubada isowóduwo ilatuwoko idigo kana, ‘Taabu kunonōina Yudiya goi.’ Tuwo Iyosepa itáoya, gómana ma sinana ikabidi, sina Galili dadavina. ");
INSERT INTO gvs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Dadavayana goi sina asa tayamo yoina Nasareta; amoko goi silokasa. Moeko goi itoboine tokabivalavala idi livala boi sitalavaaitedi simalatomota. Sidigodigo bego Tauyana siduduwe guma Nasareta. ");
INSERT INTO gvs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","E sikaaiyaka aaa, gomanayana bogina ikaitubuwaumatuwo. E amo tutayana Iyoni tosayóyova ina Yudiya yoyowoina goi tomota yaidi itaalavaita ");
INSERT INTO gvs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","idigo kana, ‘Kotugavīla! Yaubada ina kalibúbuna bogina imaiyaba bei itoboinemi kosiu.’ ");
INSERT INTO gvs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ame tauyana manuna tokabivalavala Aiseya boi nimatu bogina igini idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","E kina go Iyoniyana ana kwama moe Yaubada ina tokabivalavala ana kwama nakae tuta liliuna ilosilosi. Ana kwamayadi kameri unuununa goi siwodugudi. Ana gadíwana tolobona goi moe yoguyogu sakavaina. Ago avana moe tatabole be mokava. ");
INSERT INTO gvs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","E tuwo Iyoni itaalavaita go, da Yerusalema be tomota madabokidi Yudiya dadavina goi be nakae tomota asa liliudi sákala Iyoridani kikina goi sima tauyana sitaiyakeke ");
INSERT INTO gvs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","be nakae idi goyo sitalavaitedi namliyeta bwae Iyoridani goi isayoyoidi. ");
INSERT INTO gvs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","E Iyoniyana ikandobala Parisi be Sadusi badabadaidi igitedi simamaima; latuwodi adi sayóyova go, ilatuwokoidi idigo kana, ‘Komi siyasiyaimi moteta nakae! Manakae? Konuwonúwana bego sayóyova kaka goi itoboinemi Yaubada ina egamogamogu imamaima yaina kosiya ae? Sayóyova kaka geya ivaitemita! Mainao imi goyo goi kotugavīla! ");
INSERT INTO gvs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tauna neta sayóyova vavagimi koma bego Yaubada ina egamogamoguyana yaina kosiya, e mainao imi tugavilayana goi keuwoimi dedevidi koguinuwēdi. ");
INSERT INTO gvs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ago taabu taumiva kodigoopopōita kami, “Kai tuwo unana kai Eberamo tubunao, tauna liuna bei geya kababaneyeta.” Nakae geya go, ame alatuuwokoimi konōve: Eberamo tubunaoyadi kaga? Yaubada itoboine gurewa ame ikabidi, e Eberamo tubunao imadagidi. Tauna neta komi Eberamo tubunao, moe geya ivaitemita. ");
INSERT INTO gvs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","E Yaubada ina egamogamoguyana kíyama nakae. Kiyamayana bogina alova lamdi goi iyokaabubune, tauna ava kalovava neta sikéuwo goyogoyo, bei itaunanedi go, ikabidi ilavedi yeu goi igabudi. Tauna nakae ina egamogamogu giyakainava isowóduwo yaimi neta geya kotugavileta. ");
INSERT INTO gvs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yau bwae goi asaayoyoimi. Moe imi tugavila ana kaba kinana. Go koroto tayamo mligu goi imamaima itobukukuyuigu; nakae geya itoboineguta bei ana sendoro akavaledi unana yau sobuyekoina. Tauyana Baloma Kimaasabaina be yeu sabeninimina goi bei isayoyoimi. ");
INSERT INTO gvs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tauyana ina kaba takínona bogina iyokaabubune; giyakainava bei witi kutukutuna be mosamosaina itakinodokoidi. Ikavava, ana kutukutu bei ikabidi, ina sánala goi idodoidi go, mosamosayana, bei ikabidi yeu aiyako vaatayaina goi igabudi.’ ");
INSERT INTO gvs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Amo lavayana Yeisu itáoya Galili goi ina sákala Iyoridani bei Iyoni goi isayóyova. ");
INSERT INTO gvs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","E kina go Iyoniyana ipoikíkina Yeisu isanabode kana, ‘Itoboine yau kusayoyoigu go, kom kuma bego asayoyoim?’ ");
INSERT INTO gvs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","E tuwo kina Yeisuyana idigo kana, ‘Ame tuta kutagōna kusayoyoigu. Moe nakae Yaubada ina nuwonúwana madabokina ina yava ana kenao manuna bei takibobosidoko.’ Tuwo moitamo itagona. ");
INSERT INTO gvs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","E Yeisu ana sayóyova mlina mainao bwae goi isinalaga go, Yaubada matabuwona yábana ikatupáeve. Yeisu ikandolaga, Yaubada Balomaina igite, ana kaigigita bunabuna nakae isou imamaima Tauyana goi itowo. ");
INSERT INTO gvs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Níyana tayamo matabuwona yábana goi itumasobu idigo kana, ‘Moe natugu guna kakaya. Tauyana auyaonedoko.’ ");
INSERT INTO gvs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","E tuwo Baloma Kimaasabaina Yeisu ivakede sina yoyowo goi bei Totagíwaya ima ivakakone. ");
INSERT INTO gvs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sina yoyowo goi, Yeisu maliyalina 40 be sabamgo 40 idiiyakímwana go, maliyalinayadi mlidi loga bogina ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ma logaaina go, kina Tovakakonayana ima idigo kana, ‘Kom moitamo Yaubada Natuna ae? Tauna gurewa ame kulovinaēdi bego simalakawoinu.’ ");
INSERT INTO gvs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Go kina Yeisu idigo kana, ‘Geya! Gínina Kimaasabaina goi idigo kana, “Awoinu kaka moe komi yawoimi unadi geya, go sem Yaubada ina livala liliudikova moe yawoimi unadi.”’ ");
INSERT INTO gvs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E tuwo Totagiwayayana itáoya, Yeisu ikabi itukoe inave asa kimaasabaina goi. Asayana moe Yerusalema. E Yerusalema goi inave Yaubada ina Vada Kimaasabaina goi imwerae, e Vadayana yatana toina goi iyato. ");
INSERT INTO gvs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Maeko goi idigo kana, ‘Bego kom moitamo Yaubada Natuna ae? Tauna ameko goi kupēla kusōu go, geya kuvailaita. Moe moitamo. Gínina Kimaasabaina idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Go kina Yeisu idigo kana, ‘Go aiyuwoina Gínina Kimasabainayana idigo kana, “Yauwe imi Yaubada taabu kovaakakōne.”’ ");
INSERT INTO gvs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aiyuwoina Totagiwayayana itáoya, Yeisu ikabimnei, itukoe koya maanawena yatana goi go, aba lovina liliuna poyapoya goi madi esaesa adi káeyana ivatuluko. ");
INSERT INTO gvs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tuwo idigo kana, ‘Neta aem kuvatugúyala be kusakululu yau yaigu, e aba lovina ame liliudikova bei avinim.’ ");
INSERT INTO gvs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Go kina Yeisuyana idigo kana, ‘Kaleya, kom kusīya! Gínina Kimaasabaina idigo kana, “Moe Yauwe ida Yaubada yaina tasaakulūlu be anetava yaina tataaimāmina.”’ ");
INSERT INTO gvs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","E tuwo Totagiwayayana itáoya, Yeisu ikalave go, anerose sima Yeisu simataakavate. ");
INSERT INTO gvs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","E Yeisu vala inove bego Iyoni bogina siyoisi deri goi sivaisiu, tuwo itáoya Yudiya ikalave go, ikaluvilamna ina Galili dadavina. Amoko goi mainao ina Nasareta. ");
INSERT INTO gvs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Go Nasaretayana goi geya ikaiyakoita, go sem ina Kapaneumi goi ilokasa. Kapaneumiyana moe Galili Bwaena kikina go, Sebuloni tubunao be nakae Napatali tubunao idi kaba lovina sinaedi. ");
INSERT INTO gvs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yeisu ina lokasayana goi tokabivalavala Aiseya ina livala imalatomotamna nakae boi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Sebuloni tubunao be nakae Napatali tubunao ");
INSERT INTO gvs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tomotayadi kokonótuya goi sikaaiyaka ");
INSERT INTO gvs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","E tuwo Yeisu ina talavaita ivatowo idigo kana, ‘Kotugavīla! Yaubada ina kalibúbuna bogina imaiyaba bei itoboinemi kosiu.’ ");
INSERT INTO gvs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","E Yeisu Galili Bwaena labutabutaina goi iivayali go, koroto maa siyana igitedi; tayamo yoina Saimoni go, youyuwoina moe Pita, e siyana yoina Anduru. Adi taiyuwokova idi úwata bwae goi silavelave. Bogina koyagoi. Tauyadi toúwata. ");
INSERT INTO gvs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","E igitedi, ilatuwokoidi idigo kana, ‘Kōma kosabokuliyēgu bei avayokoimi tomota adi touwatayao.’ ");
INSERT INTO gvs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","E tuwo moitamo kidi mainao sitáoya, idi úwata sikalave go, Yeisu sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tauyadi sivayalikova go, Yeisu ikandobala ituli ta korotova adi taiyuwo igitedi, koroto tayamo maa siyana. Moe Sebedi natunao Yemesa be Iyoni. Tauyadi tamadi taiyao oga goi idi úwata siyaanumedi. Yeisu igitedi, iduduwedi idigo kana, ‘Komi kōma kosiukōigu!’ ");
INSERT INTO gvs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","E moitamo kidi mainao sitáoya, idi oga be nakae tamadi sikalavedi go, Yeisu sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Galili ana madabokina goi Yeisu ivanibiníbita go, Diyuu idi kaba tugúguna tamo tamo goi ivaatulúkwana be nakae Yaubada ina kalibúbuna Valena Dedevina itaalavaite. Tauyadi neta ituli ta visiyava siyooisidi be nakae tokatówana liliudi ikidedeevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tauna Tauyana valena inúnuwo Siriya ana madabokina goi. Boda sinove, tuwo idi togogolatayao, idi yaluwoyao be nakae kidi naagovaidi liliudi simedi Tauyana yaina. Togogolatayaoyadi ame nakae: Maniyedi madi vísiya, maniyedi madi gedageda, maniyedi madi pem. Madabokiidi simedi Tauyana ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Boda gagaina sima sisabokuliye. Bodayadi da Galili, da Dekapoli, da Yerusalema nakae Yudiya ana madabokina be kidi Iyoridani go, bomatu dadavina asaina madabokidi goi sima. ");
INSERT INTO gvs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","E bodayadi Yeisu igitedi, tuwo ituko ina koya goi itusobu go, ina tovatotowanayao mlina goi sima. ");
INSERT INTO gvs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Sima, ivatowo ivatulukoidi, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘Avatauwa komi balomaimi goi kootokai, ");
INSERT INTO gvs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Avatauwa komi mami kategeda, ");
INSERT INTO gvs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Avatauwa komi sakuululumi, ");
INSERT INTO gvs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Avatauwa komi balomaimi siikaloga ");
INSERT INTO gvs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Avatauwa komi neta tonuwokapisi, ");
INSERT INTO gvs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Avatauwa komi neta nuwomi maavadaidi, ");
INSERT INTO gvs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Avatauwa komi neta tomota adi tovagudagúdala, ");
INSERT INTO gvs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Avatauwa komi neta tomota sivakaleyemi ");
INSERT INTO gvs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tutayana tomota sikaogoyoemi, siyogedegedemi, o idi pola goi siwowokoimi imi numisa yau yaigu pasina, e ami dedevina bogina koobabane. ");
INSERT INTO gvs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tutayana nakae siguuinuwe yaimi, komi ami vaiwówana yábana goi bei gagaina. Tubumiyao boi nimatu idi sinapu nakae. Yaubada ina tokabivalavala siyogedegededi go, kidi tokabivalavalayadi adi vaiwówana dedevina sibabane. E komi nakae bei koobabane. Tauna kouyāwana gagaina.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tuwaina Yeisu kana, ‘Komi da poyapoya adi soroti nakae. Go neta sorotiyana ina togaga bogina ikavava, manakaena idedevinamna? Geya ae? Geya basabasainamo dogoi liliudi manudi. Tuwo kolaveyāmo moetala goi tomota sivakavate. ");
INSERT INTO gvs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Komi da poyapoya adi mavada nakae, tauna tomota itoboinedi sigitemi. Asa tayamo koya yatana goi ikaaiyaka nakae. Geya itoboinemita bei asayana kovamou. ");
INSERT INTO gvs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nakae geya vatau tayaamo ina rampa igabu go, bayao goi ivatum, go sem ikabi rampa ana kaba yata yatana iyato, e bei vada sinaena itapasigi tomota liliudi adi mavada. ");
INSERT INTO gvs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Komi nakae. Imi mavada kokaiwoduwēdi sininínima tomota matadi goi bei imi guinuwa dedevidi sigitedi, e Tamada guma yábana ina togaga ana káeyana bei sikamoitamoe.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tuwaina Yeisu kana, ‘Taabu konuwonūwana bego yau ama Yaubada ina Katukeda o Yaubada ina tokabivalavalayao idi vatulúkwana atauwedi. Geya kada ama bego atauwedi geya, go sem yau ama bei kaga liliuna boi sitalavaaitedi yaimi, yau goi simalatomota. ");
INSERT INTO gvs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","U ame pasina ama go, ame alatuuwokoimi konōve: Yaubada ina Katukedayana goi geya tayaamo kaga giyaina bei itagau ana kadókana yábana be poyapoya sitagau be nakae ana kadókana kaga liliuna Atukedayana goi simalatomota dókana. ");
INSERT INTO gvs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tauna avatau neta lovina tayamo giyaina Yaubada ina Katukeda goi ikapipilave be nakae tomota ivatulukoidi nakae siguuinuwe, e Yaubada ina kalibúbuna goi bei ivayoko tauyana toosobuna. Go avatau neta lovinayadi Yaubada ina Katukeda goi be tokabivalavala idi gínina goi ikabikaonedi be nakae tomota ivatulukoidi sikabikaonedi, Yaubada ina kalibúbuna goi bei ivayoko tauyana toolagaina. ");
INSERT INTO gvs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moitamo. Ame alatuuwokoimi konōve: Itoboine imi kibóbwata Yaubada ina Katukeda ana tovatulukwanayao be nakae Parisi idi kibóbwata ikalisave. Go geya, e Yaubada ina bodayáuwo geya kosiiukoidi bego ikalibubumi.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tuwaina Yeisu kana, ‘Komi bogina koyagoi bego tubudao adi lovina Yaubada ivinidi kana, “Taabu kokaaumāta.” Tateta 20:13; Atukeda 5:17 Tuwo avatau neta ikaumata, Yaubada ina liuna bei ibabane. ");
INSERT INTO gvs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Go ame yau alatuuwokoimi konōve: Lovinayana ana yagoina toina ame nakae: Avatau neta siyana iegamogamoguye, e Yaubada ina liuna bei ibabane. Avatau neta siyana ilatuwoko kana, “Dabam ipatu”, kotu bei ibabane. Avatau neta siyana ilatuwoko kana, “Kom kuyaluwo”, asagabugabu bei ibabane. ");
INSERT INTO gvs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","E tauna neta imi vininabeso komedi aba kasala goi bego kokasaledi Yaubada yaina go, siyami ina egamogamogu yaimi goi konuwopeye, ");
INSERT INTO gvs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","e amoko aba kasalayana goi imi vininabeso koyatōidi go, kōna konūwala siyami yaina namliyeta baige kokaluvīla kōma imi vininabesoyadi kokasalēdi Yaubada yaina. ");
INSERT INTO gvs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tutayana ami kaleya taiyao kononoina kotu ana totakínona manuna, woilīmi imi bágala kokitotomōi, govila bei tauyana inavemi kotu ana totakínona yaina. Ago totakinonayana bei ina tovaita ilatuwoko ikabimi, deri goi ivaisiumi. ");
INSERT INTO gvs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","U, moe bei isowóduwo go, ame alatuuwokoimi konōve: Amoko goi geya koosowóduwo ana kadókana imi rowaga madabokiina koyotuli.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Tuwaina Yeisu kana, ‘Lovina tayamo bogina koyagoi kana, “Taabu korooerāta.” ");
INSERT INTO gvs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Go ame yau alatuuwokoimi konōve: Lovinayana ana yagoina toina ame nakae: Avatau neta vavina imatakililiyeyamo, bogina nuwona goi iroerata. ");
INSERT INTO gvs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","E ava mátana ami píkwana ana toyomátula, nakona matakakataimi, e kokipōsi, kokalāve. Neta talaimi tayamo itagau, moe dedevina go, neta matami aiyuwo adi goyo pasidi wowomi madabokina silave asagabugabu goi sikaiyako vata, e moe igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ava nímana ami píkwana ana toyomátula, nakona nimakakataimi, e kokūpo kokalāve. Neta nimami tayamo itagau, moe dedevina go, neta nimami aiyuwo adi goyo pasidi wowomi ana madabokina silave asagabugabu goi sikaiyako vata, moe igoyo toina.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tuwaina Yeisu kana, ‘E lovina tayamo bogina koyagoi kana, “Ava koroto neta monena ivaisobuye, pwepwa goi ana katae italavāite monenayana yaina.” ");
INSERT INTO gvs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","o ame yau alatuuwokoimi konōve: Lovinayana ana yagoina toina ame nakae: Ava koroto neta monena geya iroerateta go, ivaisobuyebeso, e ina vaisobubesoyana pasina monena iroerata. Ava koroto neta vavina vaaisobuna inai, bogina iroerata.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tuwaina Yeisu kana, ‘Aiyuwoina tubudao idi lovina boi Yaubada ivinidi bogina koyagoi, kana, “Taabu nimami kokatulagata polapōla, go sem imi katótula Yauwe yaina koguinuwēdi.” ");
INSERT INTO gvs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Go ame yau alatuuwokoimi konōve: Lovinayana ana yagoina toina ame nakae: Nimami taabu kokatulaagasīdi. Geya kada tayaamo kaga itoboinemi kovatoi bego imi livala ana kamoitamo manuna unana kaga liliuna Yaubada ina kaba lovina. Neta yábana kovatoi, geya itoboineyeta unana moe Yaubada kebana esaaesaina. ");
INSERT INTO gvs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Neta poyapoya kovatoi, geya itoboineyeta unana ame Yaubada aena ana kaba yata. Neta Yerusalema kovatoi, geya itoboineyeta unana amo Tokalibúbuna Toolagaina ina kasa. ");
INSERT INTO gvs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Neta toinimi dabami kovatoi, geya itoboineyeta unana moe Yaubada ina kaba lovina. Komi geya kolovineta neta kokawou o kunumi sikalakoiwo. ");
INSERT INTO gvs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E kobōbwara moitamo tuta liliuna. Imi bobwarayana goi kami, “Moitamo.” O kami, “Geya.” Ame tauna. Go neta tuwaina, e moe Togoyoinayana goi ima.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tuwaina Yeisu kana, ‘Lovina tayamo bogina koyagoi, kana, “Avatau neta siyana matana ikaigoyai, e tobugoyoyana matana kokaigoyāi. Neta salana, e salana.” ");
INSERT INTO gvs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Go ame yau alatuuwokoimi konōve: Lovinayana ana yagoina toina ame nakae: Toogoyoidi taabu kokatuumapūdi, go sem avatauwa neta padipadimi kakataimi sikailavako, e padipadimi kekelimi kotagōne nakae sikailavako. ");
INSERT INTO gvs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Avatauwa neta siekotuyemi bei ami kwama sikabidi, kovinīdi go, ami tanigo nakae kotagōne taiyao sikabidi. ");
INSERT INTO gvs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ava tovayaviya neta ilovinaemi konana kokavale kona asa tayamo goi, e nakae koguinūwe go, kotagōna kokavale kona asa aiyuwoina goi. ");
INSERT INTO gvs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Avatauwa neta sikawanoiyemi, e kovinīdi. Nakae avatauwa neta latuwodi bego konami sikatoguye, taabu kovaagagāle.’ ");
INSERT INTO gvs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tuwaina Yeisu kana, ‘Lovina tayamo bogina kooyagoi, lovinayana kana, “Siyami komataakoīye” go, ami kaleya kokaolilīve. ");
INSERT INTO gvs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Go ame yau alatuuwokoimi konōve: Lovinayana ana yagoina toina ame nakae: Ami kaleyayao siyogedeegedemi komatakoiyēdi be nakae manudi kokawanōi ");
INSERT INTO gvs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bego komi Tamada guma yábana natunao, e imi sinapu nakae Tauyana ina sinapu. Yaubada tomota liliuda imatakoiyeda. Nakae iilovina níyala ituko bei toogoyoidi be nakae todedevidi itapasigidi. Aiyuwoina kúwana iietune ima tokibóbwata be nakae tokapipilova manudi. Tauna komi nakae ami kaleyayao komatakoiyēdi. ");
INSERT INTO gvs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Neta tomota simatakooiyemi go, tomotayadi aditava komatakooiyedi, ava vaiwówana bei kobabane? Geya. Moe sinapuyana kidi takisi adi togogo idi sinapu nakae ae? ");
INSERT INTO gvs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nakae neta semiyao aditava kokaodedevinedi kami, “Yaubada komi taiyao”, e komi imi sinapu tomota liliudi nakae. Moe kidi Totuyoyowo idi sinapu nakae! ");
INSERT INTO gvs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tauna komi bei imi sinapu madabokina goi komatūwo, Tamada guma yábana nakae.’ ");
INSERT INTO gvs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tuwaina Yeisu kana, ‘Tutayana Yaubada ina Katukeda ana kibóbwata koguuinuwedi, tomota matadi goi taabu koguuinuwēdi bego siyapaliyemi, govila bei ami vaiwówana Tamada guma yábana goi geya kobabaneyeta. ");
INSERT INTO gvs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tauna tutayana kovininabeso tookaidi yaidi, taabu kokimaamaētala. Moe nakae kidi todedevidi polapola idi sinapu ida kaba tugúguna goi be nakae enao goi siguuinuwe bego tomota sigitedi, e yoidi sikilagasidi. U, moe nakae siguuinuwe go, ame alatuuwokoimi konōve: Kidi adi vaiwówana bogina sibabanevatae. ");
INSERT INTO gvs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","E komi sem neta kovininabeso tookaidi yaidi, kokimomōu kovinīdi ");
INSERT INTO gvs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","bei imi vininagauyana Tamada anetava igite, ivaiwowoimi. ");
INSERT INTO gvs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tutayana kokawanoi, taabu todedevidi polapola kovatotoowonēdi unana kidi nuwodi ikabi aba tugúguna goi be nakae kedalalavi goi siitáoya sikawanoi Yaubada yaina bego tomota sigitedi. U, moe nakae siguuinuwe go, ame alatuuwokoimi konōve: Kidi adi vaiwówana bogina sibabanevatae. Tauna taabu kovatotoowonēdi. ");
INSERT INTO gvs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","E komi sem tutayana kokawanoi, imi vada goi kosīu totom kokatunibōde. Ikavava, kokawanoi gāuna Tamada yaina goi go, Tauyana anetava iigitemi bei ivaiwowoimi. ");
INSERT INTO gvs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","E imi kawanoiyana goi taabu kokautaotāwana nakae kidi Totuyoyowo idi sinapu nakae. Idi nuwonúwana neta idi kawanoi goi sikimamanao, e idi basaleliuyao bei sinovedi. ");
INSERT INTO gvs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tauna komi taabu kovatotoowonēdi. Tamada bogina nuwomi igimiyagoi namliyeta baige kokawanoi. ");
INSERT INTO gvs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tauna kokawanōi ame nakae kami, ");
INSERT INTO gvs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kūma kukalibubūma ");
INSERT INTO gvs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ama máliya ame manuna neta kuvinīma. ");
INSERT INTO gvs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ima goyo neta kunuwotaōidi ");
INSERT INTO gvs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Neta taabu kutaagonēma bei vakakona goi kaakapusi, ");
INSERT INTO gvs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Neta tomota idi bágala konuwotaoidi, komi nakae imi bágala Tamada guma yábana bei inuwotaoidi. ");
INSERT INTO gvs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Go neta geya konuwotaoidita, e Tamada nakae, komi imi bágala geya inuwotaoidita. ");
INSERT INTO gvs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","E tutayana kodiiyakímwana, maisimi taabu kobuwoowonīdi kidi todedevidi polapola idi sinapu nakae. Maisidi sibuwowonidi bego tomota siyagoidi tauyadi todiyakímwana. U, moe nakae siguuinuwe go, ame alatuuwokoimi konōve: Kidi adi vaiwówana bogina sibabanevatae. Tauna taabu kovatotoowonēdi. ");
INSERT INTO gvs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","E komi kodiiyakímwana go, kunumi koputumīdi be nakae maisimi konikīdi, ");
INSERT INTO gvs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","e bei imi diyakimwanayana tomota geya siyagoiyeta, go sem Tamada anetava ada toyagoina bei igitemi ivaiwowoimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tuwaina Yeisu kana, ‘Poyapoya esaesaina taabu kokanuukulīdi. Esaesayana manumánuwo be dáura sikaigoyaidi be nakae tovaináwana sisiu sivainaoidi. ");
INSERT INTO gvs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Go sem yábana esaesaina kokanuukulīdi. Esaesayana ituli. Manumánuwo be dáura geya sikaigoyaidita be nakae tovaináwana geya sivainaoidita. Tauna yábana esaesaina kokanuukulīdi. ");
INSERT INTO gvs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Moitamo. Nako goi imi esaesa ikaaiyaka, moeko goi atemi nakae ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Matami moe wowomi ana rampa nakae. Tauna neta matami sidedevina, moe nakae komi tokaiguyau, e itoboinemi tomota idi mou kogitedokoidi bego kovaitedi. Neta nakae, e wowomiyadi madabokina mavada bei ivakayaodeidi. ");
INSERT INTO gvs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Go neta matami sigoyo, moe nakae komi tomatakónana, e geya itoboinemita kogita dókana. Neta nakae, e wowomiyadi madabokina kokonótuya ivakayaodeidi. Tauna neta matamiyadi geya sipaisewadokoneta, e moe kokonótuya ivakaigaga toina. ");
INSERT INTO gvs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Geya vatau tayaamo itoboine bei ina tomoyayao adi taiyuwo manudi ipaisewa yuwoyuwo. Bogina koyagoi. Tayamo bei ikaolilive be nakae ikubuyeve go, tayamo imatakoiye be nakae yaina toinina ikasale. Tauna geya itoboinemita Yaubada be esaesa manudi kopaisewa yuwoyuwo.’ ");
INSERT INTO gvs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tuwaina Yeisu kana, ‘Moe pasina tauna ame alatuuwokoimi konōve: Yawoimi manudi taabu konuwokuubukūbu kami, “Kaga bei kakáika?” O nakae kami, “Kaga bei kanim?” O wowomi manudi kami, “Kaga bei kalosi?” Yawoida moe dogoi gagaina namliyeta awoinu ae? Nakae wowoda dogoi gagaina namliyeta kwama ae? ");
INSERT INTO gvs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mánuwo kogitēdi go, konuwoleleuyēdi. Kidi geya sibagubágula. Geya sidiibayoya. Geya adi sanalamo go, Tamada guma yábana ivaakanidi. Go komi kónana gagaimi Yaubada yaina namliyeta manuwoyadi. Tauna neta Yaubada imatakaavatedi, manakae? Bei komi nakae imatakavatemi? Nakae. ");
INSERT INTO gvs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Avatau yaimi goi itoboine ina nuwokubukubu goi yawoina ikimamanave? Geya ae? ");
INSERT INTO gvs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kaga ana dedevina ami kwama manuna konuwokubukubu? Senina ana tabo manuna konuwonūwana. Sitabo go, geya sipooisógana, nakae adi kwama geya sigilugíluma. ");
INSERT INTO gvs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Go ame alatuuwokoimi konōve: Seninayadi kaausaraidi toidi namliyeta Solomoni ina esaesa ana káeyana madabokina, nakae ana kwama be ana pasapasa madabokidi iilosidi. ");
INSERT INTO gvs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","E náuna dogoi giyaidi. Ame sididi go, itomo tomota silabudi sigabudi. Naunayadi dogoi giyaidi go, Yaubada ivaapasedi ae? Tauna neta naunayadi ivaapasedi, manakae? Komi kónana gagaimi, ami kwama bei ivinimi gea geya? Bei ivinimi! Komi to moitamo geya konumisedokoiguta ae? ");
INSERT INTO gvs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tauna taabu konuwokuubukūbu yawoimi idi kaiyaka manuna kami, “Kaga bei kakani?” O kami, “Kaga bei kanim?” O kami, “Kaga bei kalosi?” ");
INSERT INTO gvs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Moitamo. Ame dogoiyadi liliudi goi kidi Totuyoyowo yawoidi madabokina sitaagonedi go, tauyadi Yaubada sitamogemogeye. Aiyuwoina Tamada guma yábana bogina iyagoimi. Neta kaga nakae kokiseeyeseye, bei ivinimi. ");
INSERT INTO gvs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E yawoimi madabokina kotagonēdi Yaubada ina kalibúbuna be nakae ina kivavasa yaidi goi, bei moe dogoiyadi liliudi ivinimi. ");
INSERT INTO gvs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","E tauna taabu konuwokuubukūbu itomo manuna ava mou nakae bei sisowóduwo. Ada mou maliyalina ame goi bogina yoiyada go, itomo ana mou moe itomo manuna.’ ");
INSERT INTO gvs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tuwaina Yeisu kana, ‘Taabu semiyao kotaakinōidi kidi toogoyoidi, govila bei Yaubada itakinoimi komi toogoyoimi. ");
INSERT INTO gvs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Moe moitamo. Nakonakae tomota kotakinoidi kidi toogoyoidi, e Yaubada nakae bei itakinoimi komi toogoyoimi. O kada, “Nakonakae imi guinuwa tomota yaidi, e Yaubada nakae bei iguinuwe yaimi.” ");
INSERT INTO gvs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","E manakae? Semiyao idi goyo giyaidi mosamosa giyaina nakae matadi goi koogitedi go, komi imi goyo gagaidi alovagabugabu nakae toinimi matami goi ikaaiyaka geya kogiteyeta ae? ");
INSERT INTO gvs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Komi manakae semiyaoyadi kolatuwokoidi kami, “Kutagonēgu mosamosa giyaina matam goi akabi”? Go alovagabugabuyana toinimi matami goi nava ikaaiyaka! ");
INSERT INTO gvs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Komi todedevimi polapola! Mainao alovagabugabuyana matami goi kokābi bei itoboinemi kogita dókana namliyeta baige mosamosayana giyaiina semiyao matadi goi kokābi. Moe nakae semiyao kokamamaetalidi. ");
INSERT INTO gvs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kaga kimaasabaina Yaubada umana taabu weiniya koovinīdi, govila bei situgavila sikanimi. Imi esaesa taabu koolavēdi bao matadi goi, govila bei sivabaibailidi. Tomota Yaubada valena sikatae nakae; taabu kovatuulukōidi, govila bei valayana sitagiwoi o sibugoyaimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tuwaina Yeisu kana, ‘Kokawanōi Yaubada yaina, e bei ivinimi. Kaga kokiseeyeseye Yaubada yaina goi koolusāle, e bei kobabane. Kokaukeeyakēya, e Yaubada komi yaimi totom bei ikatupáeve. ");
INSERT INTO gvs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Moitamo. Tokawanoi liliudi yaidi Yaubada ikaiguyau. Tolusala liliudi bei sibabane. Tokaukeyakeya liliudi yaidi Yaubada totom bei ikatupáeve. ");
INSERT INTO gvs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Avatauwa komi yaimi goi ma natuumiyao go, neta awoinu sikawanoiye, manakae? Gurewa bei kovinidi? Geya ae? ");
INSERT INTO gvs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O nakona íyana sikawanoiye go, manakae? Moteta bei kovinidi? Geya ae? ");
INSERT INTO gvs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tauna komi toogoyoimi go, koyagoi manakaemi yabobona dedevidi natumiyao kovinidi ae? Go Tamada guma yábana todedevina, tauna neta kokawanoi Tauyana yaina, yabobona dedevidi moitamo bei ivinimi. ");
INSERT INTO gvs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","E tauna nakonakae latuwomi bego tomota siguinuwe yaimi, e komi nakae tauyadi yaidi kogimiguinūwe. Ame Yaubada ina Katukeda be nakae ina tokabivalavala adi vatulúkwana adi masi.’ ");
INSERT INTO gvs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Tuwaina Yeisu kana, ‘Kedawowotu totomna paaevaina. Tuwo ana siu be ana ketoiya sikakapu go, kedawowotuyana goi aba vailai kobabane. Totomyana goi boda badabadaidi bei sisiu. Tauna komi kedavapola totomna giyaina goi Yaubada ina kalibúbuna kosīu. ");
INSERT INTO gvs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Yawana vata ana kenao kedavapola nakae totomna giyaiina. Tuwo ana siu be ana ketoiya moumoudi go, kedavapolayana goi yawana vata bei kobabane. Ago totomyana goi taudi adi taiyuwomo bei sisiu.’ ");
INSERT INTO gvs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tuwaina Yeisu kana, ‘Ami dodōkana! Tokabivalavala polapola bei sima; adi kaigigita sipi kaitoowosidi nakae. Kom go vatau? Kidi sinaedi weiniya woliwoli nakae latuwodi sikanimi! ");
INSERT INTO gvs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Tauyadi keuwoidi goi bei kokinanedi. Manakae? Itoboinemi taliboibo goi kilekile koguwe? O goitagoita goi lao koguwe? Geya ae? ");
INSERT INTO gvs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","E alova nakae. Alova tamo tamo dedevidi, keuwoidi dedevidi sikeuwoedi go, alova goyogoyoina keuwoina goyogoyoina ikeuwoe. ");
INSERT INTO gvs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Alova dedevina geya itoboineyeta keuwoina goyogoyoina ikeuwoe. E alova goyogoyoina nakae, geya itoboineyeta keuwoina dedevina ikeuwoe. ");
INSERT INTO gvs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Neta ava kalova geya ikeuwodokoneta, alovayana tatalai talave yeu goi tagabu. ");
INSERT INTO gvs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tauna tauyadi keuwoidi goi itoboinemi kokinanedi nakae alova keuwoidi goi takinanedi. ");
INSERT INTO gvs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tomota maniyedi sikatomooyaegumo Yaubada ina bodayáuwo geya sisiukoidita bego ikalibubudi unana ina nuwonúwana geya siguinuweyeta. Go sem avatauwa neta Tamagu guma yábana ina nuwonúwana siguuinuwe, bei sisiu. ");
INSERT INTO gvs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Amo maliyalinayana goi maniyena tomota bei silatuwokoigu kadi, “Ima Tomoya, kai yoim goi Vala Dedevina kakabivalevale tomota yaidi, nakae dimoni kavataapiyedi be nakae guinuwa toogagaidi badabadaidi kaguuinuwedi.” ");
INSERT INTO gvs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Amo tutayana tauyadi bei alatuwokodokoidi kagu, “Yau geya ayagoimita; komi geya yau guna bodao geya. Komi tokapipilova, kosīya!”’ ");
INSERT INTO gvs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tuwaina Yeisu kana, ‘Tauna avatauwa neta yau guna livalayadi sinovedi be nakae sisabokuuliyedi, e tauyadi koroto tonanamsa nakae. Korotoyana ina vada gurewa yatana goi iyowo. ");
INSERT INTO gvs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Niga kúwana ikúwana, e mluwa idau, nakae yágira itowo vadayana goi ikona go, geya iyaobasiyeta. Bogina koyagoi. Gurewa yatana goi iyowo. ");
INSERT INTO gvs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Avatauwa neta yau guna livalayadi ame sitaiyakekedi go, geya sisabokuliyedita, e tauyadi koroto yaaluwoina nakae. Korotoyana ina vada ediédila yatana goi iyowo. ");
INSERT INTO gvs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Niga kúwana ikúwana, e mluwa idau be nakae yágira itowo vadayana goi ikona, tuwo vadayana iyaobasi isou, ivatuligeligei toina.’ ");
INSERT INTO gvs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tutayana Yeisu ina bóbwara ilukavavedi, e ina vatulukwanayana pasina boda sikainaopa, ");
INSERT INTO gvs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","kadi, ‘Tauyana ina vatulúkwana geya kada kidi Yaubada ina Katukeda ana tovatulukwanayao nakae geya, go sem mana lovina ivaatulúkwana.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","E Yeisu koya goi isou ima go, boda gagaina sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Isou ima go, tolepero tayamo ima Yeisuyana matana goi aena ivaatugúyala idigo kana, ‘Tomoya, neta im nuwonúwana nakae, itoboinem kukidedevinegu bei sakavaigu imavada.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tuwo Yeisu nimana iyosale, toleperoyana ibisikone idigo kana, ‘Guna nuwonúwana nakae. Kumavāda!’ Tuwo mainao korotoyana sakavaina ina lepero ikavava, e sakavainayana imavada. ");
INSERT INTO gvs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ago Yeisu idigo kana, ‘Kunōve. Am kimavadayana manuna geya vatau tayaamo kulaatuwōko, go sem kūna Tonúwala yaina goi kuvagitakōim, igitem bei ivayokoim kom bogina kumavada. Ikavava, im vininabeso yoguyogu kukasāle Yaubada yaina ada lovina boi Mosese iivinida tolepero adi kimavada manuna nakae. Moe aba kinana tomota yaidi sakavaim bogina imavada, e bei siuyaonemneim.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","E Yeisu ina Kapaneumi goi isiu go, da Roma idi tovayaviyayao adi tovakumgo tayamo ima Yeisu yaina ikawanoi makimaki ");
INSERT INTO gvs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","idigo kana, ‘Tomoya, guna pákwana pempemna mana gedageda gagaina guna vada goi iimasisi.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tuwo Yeisu idigo kana, ‘Manakae? Bego yau ao akidedevine?’ ");
INSERT INTO gvs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ago kina tovakumgoyana idigo kana, ‘Geya, Tomoya. Yau toosobugu; geya itoboineguta bego guna vada goi kusiu, go sem kom mam lovina kubobwarāmo, bei guna pakwanayana iboboina. ");
INSERT INTO gvs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yau nakae lovina ayagoi. Yau magu tolovinao be nakae tovayaviya maniyedi sobuyekoigu. Neta tayamo alatuwoko kagu, “Kūna!” bei ina. Neta tayamo alatuwoko kagu, “Kūma!” bei ima. Neta guna pákwana tayamo alatuwoko kagu, “Ame kuguinūwe!” bei iguinuwe.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","E ina livalayana Yeisu inove, ikainaopa. Tuwo tauyadi sisabookuliye ilatuwokoidi idigo kana, ‘Iyaa! Ame tauyana moitamo! Ame alatuuwokoimi konōve: Isileli tubunao yaidi goi geya vatau tayaamo ababane ina numisa gagaina ame Totuyoyowoyana nakae. ");
INSERT INTO gvs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","E ame alatuuwokoimi konōve: Totuyoyowo badabadaidi poyapoya ana madabokina goi, bomatu be koiboga goi, bei sima Yaubada ina kaba kalibúbuna goi sisiu sikaaiyaka go, Eberamo, Aisake be Yakobo taiyao situsobu áika manuna. ");
INSERT INTO gvs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ego komi Diyuu bego Yaubada ina kinavayao ina kalibúbuna goi geya imi numisamo, tauna bei ilavemi kona moetala mamaníwana goi kokaaiyaka. Amoko goi bei kotaiya vata, nakae salami kokakaavatedi komatamaimaita.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Go Yeisu ibóbwara ikavava, tovakumgoyana ilatuwoko, idigo kana, ‘Kwaluvīla kūna im kasa. Im numisa pasina im pákwana bogina iboboina.’ Tuwo moitamo, tuta amo goi tauyana iboboina. ");
INSERT INTO gvs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yeisu itáoya ina Pita ina vada goi isiu, ikandobala Pitayana yaona (moe monena sinana) igite manaa katówana kebana goi iimasisi. ");
INSERT INTO gvs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tuwo ibala ina vavinayana nimana ibisikone, e ina katowanayana ikalave. Ikavava, vavinayana itáoya ina Yeisu avana ivaidede. ");
INSERT INTO gvs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","E asa bogina lavilavi, toni kasa sediyao naagovaidi badabadaidi simedi Yeisu yaina. Tuwo Yeisu ibobwaramo, e dimoni sisiya. Nakae tokatówana liliudi simemedi ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tauna ina guinuwayadi goi Yaubada ina tokabivalavala Aiseya ina livala imalatomotamna nakae boi idigedige kana, ");
INSERT INTO gvs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","E Yeisu boda igitedi sitaooyakobu, tuwo ina tosabokuliyao ilovinaedi idigo kana, ‘Tasowōya, Galili Bwaena tatadamāne tāna ta dadava.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bogina bego sisowoya go, Yaubada ina Katukeda ana tovatulúkwana tayamo ima Yeisu yaina idigo kana, ‘Tovatulúkwana, neta ava kasa goi kunonoina, bei asabokuuliyem.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ago kina Yeisu idigo kana, ‘Weiniya woliwoli madi bobosiu, mánuwo madi vátala go, Tomalatomota geya ana kaba masisimo. Tauna neta kusabokuuliyegu, e kom bei yau nakae.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E Yeisu ina tovatotówana aiyuwoina idigo kana, ‘Tomoya, kutagonēgu mainao ana tamagu amatakavate ana kadókana ikámasa avaliwoge baige ama asabokuliyem.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","E kina go Yeisu idigo kana, ‘Kūma kusabokuliyēgu go, tokámasa kwalavēdi bei toinidi idi tokamasayao sivaliiwogedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yeisu oga goi isowoya go, ina tovatotowanayao sisabookuliye, e nakae sisowoya bego Galili Bwaena sitadamane. ");
INSERT INTO gvs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Sisowoya ikavava, sikailova sinonoina go, yágira gagaina ikalisou Bwaeyana goi itowo. Tuwo aivaya siseulalágata, e ogayana giyakainava sivakayaaodei. E kina go Yeisu imasisi ikanaamatáiya. ");
INSERT INTO gvs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ago ina tovatotowanayao sima siwoini sidigo kadi, ‘Tomooya, kutāoya kuyavēda! Giyakainava bei tavailai!’ ");
INSERT INTO gvs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Go kina ibowoidi idigo kana, ‘Kaga komatoitae? Komi geya konumisedokoiguta!’ E tuwo itáoya, e yágira be aivaya ilovinaedi sisayata. Sisayata, e yagirayana ilakapuwe nakae Bwaeyana ikadaúmwara gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","E kidi go korotoyadi sikainaopa kadi, ‘Iyaa! Ame ava koroto? Yágira be aivaya niyana sikabiikaone?’ ");
INSERT INTO gvs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yeisu kidi bogina sima da Gadara idi kaolao goi sivaiu. E sisou go, koroto adi taiyuwo naagovaidi valiwoga tukubu goi sisowóduwo sima Yeisu sivalobode. Korotoyadi aba silali toina, tauna geya vatau tayaamo itoboine bei amo enaoyana goi iiketoiya. E korotoyadi sima Yeisu sivalobode. ");
INSERT INTO gvs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Sivalobode, e Yeisu yaina sipodeda sidigo kadi, ‘Kom Yaubada Natuna, kwalavēma! Kai ima polava moe geya kom im polava geya. Manakae? Lovina ana lava nava go, kom kuma bego kuyogedegedema ae?’ ");
INSERT INTO gvs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ego bao badabadaidi sikaaiyaka tupwana yomana goi sidumdumla. ");
INSERT INTO gvs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","E kidi go dimoniyadi sikandobala bao sigitedi, tuwo sikawanoi makimaki Yeisu yaina sidigo kadi, ‘Neta kuvatapiyema, e kuetunēma kāna bao amo sinaedi goi kasiu.’ ");
INSERT INTO gvs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tuwo Yeisu idigo kana, ‘Kosowōduwo kōna!’ E dimoniyadi sitáoya, korotoyadi sikalavedi sina bao sinaedi goi sisiu. Go baoyadi matabuwodi madabokidi sisaloku, silokoina sina koya tagatagagina goi sipela sisou Galili Bwaena goi sisalili. ");
INSERT INTO gvs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","E kidi go baoyadi adi tomatakavatayao sisiya sina asa goi, e kaga liliuna sigite sitalavaite. Nakae kaga siisowóduwo boi korotoyadi naagovaidi yaidi goi nakae sitalavaitedi. ");
INSERT INTO gvs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tuwo toni kasayadi madabokiidi sima; latuwodi Yeisu sivalobode go, tutayana sigite, sikawanoi makimaki kadi, ‘Ima kasa kwalāve!’ ");
INSERT INTO gvs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tuwo Yeisu mana tovatotowanayao oga goi sisowoyamna sisaidámana sina toinina ina kasa goi sivaiu sisou. ");
INSERT INTO gvs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Go topem tayamo liyaliyaka goi iimasisi, e boda sikavale sime Yeisu yaina. Sime go, Yeisu idi numisa igite, tuwo topemyana ilatuwoko idigo kana, ‘Natugu, kwatepātu. Yau adigo kom im goyo adi nuwotao bogina kubabane.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Go Yaubada ina Katukeda ana tovatulukwanayao maniyedi sikaaiyaka taudiva sibobóbwara kadi, ‘Iyaa! Amo korotoyana idigopopóita. Tauyana bego ieyaubada!’ ");
INSERT INTO gvs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Go idi nuwonuwanayana kina Yeisu bogina iyagoi, tuwo idigo kana, ‘Kaga unana nuwomi goi nuwonúwana goyogoyoidi koonuwedi bego geya itoboineguta goyo anuwotao? ");
INSERT INTO gvs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Moitamo. Gobe ava livala ikakapu ame tauyana alatuwoko? Kagu, “Kom im goyo ana nuwotao bogina kubabane”, gea kagu, “Kutāoya, kuketōiya”? Nako ikakapu? ");
INSERT INTO gvs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","E itoboine koyagoi Tomalatomota mana lovina poyapoya goi tomota idi goyo inuwootaoidi.’ Yeisu itugavila topemyana ilatuwoko idigo kana, ‘Kutāoya, im baseko kwābi, kwaluvīla kūna im kasa!’ ");
INSERT INTO gvs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tuwo moitamo itáoya, ina ina kasa. ");
INSERT INTO gvs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","E amo guinuwayana boda sigite, madi matoita wowooinina Yaubada ina togaga ana káeyana sikamoitamoe unana tomota togaga iivinidi. ");
INSERT INTO gvs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yeisu amo dadavayana ikalave, iketoiya inonoina go, yau Madiu da Roma adi takisi ana togogo igitegu, takisi ana kaba gogo goi aatusobu apaaisewa. Tuwo Yeisu ilatuwokoigu idigo kana, ‘Madiu, kūma, kusabokuliyēgu.’ Tuwo moitamo atáoya Tauyana asabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Niga Yeisu mana tovatotowanayao taiyao sima guna vada goi áika manuna. Amoko goi takisi ana togogoyao be ituli ta toogoyoidi badabadaidi sima Tauyana mana tovatotowanayao yau taiyao kakáika. ");
INSERT INTO gvs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","E kakakáika go, kidi Parisi amoko goi sikaaiyaka kai ina tovatotowanayao sigitema silatuwokoima sidigo kadi, ‘Kaga unana imi tovatulúkwana go, takisi ana togogoyao be ituli ta toogoyoidi taiyao sikakáika?’ ");
INSERT INTO gvs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Go Tauyana inovedi, e idigo kana, ‘Gwa. Tauyadi madi deedevina geya latuwodi doketa, go sem kidi tokatówana latuwodi doketa. ");
INSERT INTO gvs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","E Yaubada ina livala ame kogitedōko bei koyagoi kaga ana yagoina. Livalayana kana, “Latuwogu yoguyogu kokasaledi yau yaigu, go sem latuwogu toina moe konuwokapisi.” Oseya 6:6 Moe moitamo. Yau ama geya tauyadi toinidi sinuwonúwana bego kidi tokibóbwata aduduwedi geya, go sem ama toogoyoidi aduduwedi bei situgavila.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","E Iyoni ina tovatotowanayao sima Yeisu silumadade sidigo kadi, ‘Kai be nakae kidi Parisi kadiiyakímwana Yaubada manuna go, kom im tovatotowanayao manakae geya sidiyakimoneta?’ ");
INSERT INTO gvs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Go kina Yeisu idigo kana, ‘Neta nai ana káika goi tonai koroto nava yaimi ikaaiyaka, manakae? Nai ana toyokoyao itoboinedi bei madi diyakímwana sinuwomou? Geya ae? Go sem itoboinedi madi uyáwana sikakáika ae? E diyakímwana ana tuta nava imamaima. Amo tutayana tonaiyana bei siyoisi sinave namliyeta baige tauyadi madi nuwomou sidiyakímwana. ");
INSERT INTO gvs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","E livalakaibala tayamo vatulukwana bogo be vatulukwana vau manudi avatulukoimi bei koyagoi. Ame nakae: Geya vatau tayaamo boboda vau ikabi, ana kwama bogo taaporaina goi igilumipatuko. Ame moitamo. Bobodayana bei ikatumásina, e kwama bogoyana itaisa go, ina taisayana bei gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aiyuwoina geya itoboinedeta oine vau takabi, opo bogo goi tasaligogo, govila bei oine vauyana ana togaga pasina opo itapao, e oineyana idau besobeso be nakae opoyana igoyo. Go sem oine vau takabi, opo vau goi tasiwoi, e bei oine maa opoina dedevidi.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nava amo livalayadi ilatuuwokoidi go, tayamo Diyuu idi kaba tugúguna ana tolovina ima Yeisu matana goi aena ivatugúyala idigo kana, ‘Tomoya, natugu vavina makaitaga ikámasa go, neta kūma gomanayana dabana goi nimam kuyāto, bei ma yawoina itaoyamna.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tuwo moitamo Yeisu itáoya kai ina tovatotowanayao taiyao tolovinayana kasabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kanonoina go, tayamo vavina ima. Vavinayana tala yawou aiyuwo goi ikaikaina idaudau go, nava idaudau. E tauyana ivalabelabena Yeisu mlina goi ibisibala ana kwama kikina ibisikone. ");
INSERT INTO gvs_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ina nuwonúwana kana, ‘Neta ana kwama abisikoneyamo, bei aboboina.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","E kina go Yeisuyana itugavila, vavinayana igite, idigo kana, ‘Natugu, kwatepātu! Im numisa bogina ikidedevinem.’ Tuwo moitamo lava amo goi vavinayana iboboina. ");
INSERT INTO gvs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yeisu ivataoduwe tolovinayana ina vada goi isiu tomota igitedi kokopi siiuwedi be nakae boda simgemge sitaitáiya, ");
INSERT INTO gvs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","tuwo idigo kana, ‘Kosowōduwo kōna! Gómana geya ikamaseta, go sem ikanaamatáiya.’ Tuwo kidi tomotayadi sivaanamae go, Yeisu ivalilivedi. ");
INSERT INTO gvs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","E tutayana ivalilivedi ikavava, isiu ina vabodaupa goi gomanayana nimana iyoisi, e ikaitáoe. ");
INSERT INTO gvs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tuwo ame valayana boda sisanunui ina amo dadavayana ana madabokina goi tomota sinove. ");
INSERT INTO gvs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yeisu itáoya, amo dadavayana ikalave inonoina go, tokebo adi taiyuwo sima Yeisu sisakurikuriye. Idi sakurikuriyana goi siiduduwo kadi, ‘Devida tubuna, kunuwokapisiyēma!’ ");
INSERT INTO gvs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","E Yeisu vada goi isiu go, tokeboyadi nakae sisiu sima Tauyana yaina. Tuwo ilatuwokoidi idigo kana, ‘Manakae? Konumisa bego itoboinegu moe nakae aguinuwe?’ ‘U, Tomoya’, tokeboyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","E tuwo matadi ibisikonedi go, idigo kana, ‘Imi numisa pasina nakae, e matami sidedevīna!’ ");
INSERT INTO gvs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tuwo matadi sikatupailala go, Yeisu ikatumatalidokoidi idigo kana, ‘Konovēgu. Geya vatau tayaamo kolatuwōko moe dogoiyana manuna.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","E kidi korotoyadi sisowóduwo go, Yeisu ina livala geya sikabikaoneyeta, go sem sina amo dadavayana ana madabokina goi valena sisanunui. ");
INSERT INTO gvs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","E Yeisu kai taiyao bego kasowóduwo kana go, tomota maniyedi matabuwodi koroto tayamo maena dimoni ikiigavile sime Tauyana yaina. Sime, Yeisu igite, dimoniyana ivatapiye isiya. ");
INSERT INTO gvs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E ivatapiye ikavava, korotoyana itoboine ibobwara dókana. Ago boda sigite, sikainaopa kadi, ‘Geya tayaamo kaga nakae Isileli sinaena tagitegite!’ ");
INSERT INTO gvs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","E kidi go Parisiyadi sikaaiyaka sidigo kadi, ‘Moe dimoni idi tolovina ina togaga goi dimoni ivataapiyedi siisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yeisu kai taiyao katáoya, asa liliudi giyaidi be gagaidi goi kavanibiníbita. Kavanibiníbita go, Tauyana Diyuu idi kaba tugúguna tamo tamo goi ivaatulúkwana be nakae Yaubada ina kalibúbuna Valena Dedevina itaalavaite bego tomota itoboinedi sisiu. Aiyuwoina tomota ituli ta vísiya siyooisidi be nakae tokatówana liliudi ikidedeevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ego boda iigitedi, geya adi tovaitamo sinuwokubukubu; tauyadi sipi geya adi tomatakavatamo nakae, tauna inuwokapisiyedi. ");
INSERT INTO gvs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","E tuwo kai ina tovatotowanayao yaima goi idigo kana, ‘Tánuwo bogina iloboina go, todibayoya geya sibadebadeta. ");
INSERT INTO gvs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tauna toni tánuwo yaina goi kokawanōi bego topaisewa ietunedi sima sidibayoya.’ ");
INSERT INTO gvs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Amo ikavava, Yeisu kai ina tovatotowanayao yawou aiyuwo iduduwema kama. Kama, lovina ivinima bei itoboinema dimoni kavatapiyedi be nakae tauyadi ituli ta vísiya siyooisidi be tokatówana liliudi kakidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","E kai yawou aiyuwo Yeisu ina vamoleyanayao yoima ame nakae: Mainao Saimoni, tauyana youyuwoina moe Pita, ma siyana Anduru, Sebedi natunao Yemesa ma siyana Iyoni, ");
INSERT INTO gvs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipo, Batolomiu, Tomasi, yau Madiu takisi ana togogo, Alipiyo natuna Yemesa, Tadiyasi, ");
INSERT INTO gvs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimoni (boi tauyana Isileli tubunao idi kaba lovina ana tokokóila), Yudasa guma Keriota, tauyana nava Yeisu bei inuwotuluye. ");
INSERT INTO gvs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ame kai yawou aiyuwo Yeisu ietunema kana asa tamo tamo goi go, mainao ilatuwokoima idigo kana, ‘Taabu kononōina kidi Totuyoyowo yaidi be nakae kidi da Samériya idi kasa goi, ");
INSERT INTO gvs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","go sem kōna sedao Isileli tubunao yaidi. Tauyadi sipi sulaaigidi nakae. ");
INSERT INTO gvs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","E kōna kotalavāita yaidi kami, “Yaubada ina kalibúbuna bogina imaiyaba.” ");
INSERT INTO gvs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tokatówana kokidedevinēdi, tokámasa kokaitaoēdi, vísiya liliuna sakavaidi goi kokimavadēdi, yaidi goi dimoni kovatapiyēdi. Yaubada ina vaita ivinibesoimi, e komi nakae tomota kovinibesōidi. ");
INSERT INTO gvs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Imi vanibitayana goi nima kaka kōna. Esaesa ma saisairina taabu kokabikābi. ");
INSERT INTO gvs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Wasare geya, kwama aiyuwoina geya, sendoro aiyuwoina geya, aituko geya. Bogina koyagoi. Topaisewa itoboinedi idi vavápula sikáika. Tauna imi vaníbita goi nima kaka kōna. ");
INSERT INTO gvs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ava kasa, gagaina o giyaina goi, neta kosiu, kolusala dōkana avatau neta iuyaonemi go, tauyana ina vada goi kokaaiyāka ana kadókana kotáoya asayana kokalave. ");
INSERT INTO gvs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","E vadayana goi kosiusiu mainao toni vada mana bodao yaidi kokauyāgu. ");
INSERT INTO gvs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Neta toni vadayana moitamo iuyaonemi, e kokaodedevinēdi kami, “Tuboina ikaaiyaka yaimi.” Go neta toni vadayana geya iuyaonemita, e imi kaodedevinayana ikaluvilamna yaimi. ");
INSERT INTO gvs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Avatauwa neta geya siuyaonemita o imi livala geya sinovedita, e vada amo o asa amo kokalāve go, tutayana kosowóduwo, e asayana kaukauna aemi goi kokatumaumāui. Moe imi katumátala tauyadi yaidi bego Yaubada itavileiyedi. ");
INSERT INTO gvs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","U, moe nakae koguinūwe go, ame alatuuwokoimi konōve: Takínona ana tuta tomota amo asayana goi adi liuna gagaina bei sibabane namliyeta kidi da Sodoma be nakae da Gamora.’ ");
INSERT INTO gvs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Tuwaina Yeisu kana, ‘Konovēgu. Komi sipi nakae aetunemi kona guna kaleyayao yaidi goi; tauyadi weiniya woliwoli sasasaidi nakae. Tauna mami nuwosinapu moteta nakae go, imi sinapu maavadaidi bunabuna nakae. ");
INSERT INTO gvs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","E ami dodōkana ami kaleyayao goi. Maniyemi bei siyoisimi, siekotuyemi be nakae idi kaba tugúguna goi bei sidabimi. ");
INSERT INTO gvs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Go maniyemi bei sinavemi adi gavanayao be adi tolovinayao matadi goi siekotuyemi imi numisa yau yaigu pasina, bei tauyadi yaidi be nakae Totuyoyowo yaidi Vala Dedevina kotalavaite. ");
INSERT INTO gvs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ego tutayana siyoisimi bei siekotuyemi, taabu konuwokuubukūbu manakaemi bei kobóbwara o kaga kobobore. Moitamo. Kaga Yaubada latuwona kotalavaite, e moe tutayana Balomaina bei nukotomi isanayatoidi manakaemi kobóbwara. ");
INSERT INTO gvs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Moitamo. Moe geya komi imi livala geya, go sem kina Tamada Balomaina sopami goi ibobóbwara. ");
INSERT INTO gvs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","E tomota maniyedi geya sinumiseguta toinidi sediyao tonumisa bei sinuwotuluyedi tolovina yaidi bego sikaumatedi. Tamadiyao nakae bei siguinuwe natudiyao yaidi. Gogómana nakae bei siguinuwe tamadiyao be sinadiyao yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tomota liliudi bei sikaolilivemi unana yau yoigu ikaaiyaka yaimi. Go avatauwa neta sitaoyakavata ana kadókana tuta ana kaba lukavava goi, e adi yava bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","E imi vanibitayana goi tutayana asa tayamo toni kasa siyogedegedemi imi talavaita pasina, e kosīya kōna ituli ta kasa goi kotalavāita. U, moe nakae koguinūwe go, ame alatuuwokoimi konōve: Asa liliuna Isileli sinaena geya kolukavavedita gobe Tomalatomota ikaluvilamna ima. ");
INSERT INTO gvs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tovatotówana ina tovatulúkwana geya itobusaveyeta. Aiyuwoina tomota paakonina ina tomoya geya itobusaveyeta. ");
INSERT INTO gvs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Neta tovatotowanayana ina sinapu be tovatulúkwana ina sinapu sivavasa o tomota paakonina ina tomoya taiyao idi sinapu sivavasa, e tuwo dedevina. Tauna kita nakae bego tavavasa. Neta yau toni vada sitagiwoigu kadi, “Kom Beyelisebuli”, e komi yau guna bodao nakae bei sitagiwoimi gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tauna tomotayadi taabu komatooitēdi. Moitamo. Kaga vamoounina, nava Yaubada bei ikaiwoduwe, e tomota liliudi sigite. Kaga tomota sikamomouye, nava bei Yaubada italavaite, e tomota liliudi sinove. ");
INSERT INTO gvs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kaga mamaníwana goi akanasiinamoe, e mavada goi kotalavāite tomota yaidi. Aiyuwoina kaga nakae aakului yaimi goi, e vada yatadi goi kotalavāite, bei tomota liliudi sinove. ");
INSERT INTO gvs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ago imi talavaitayana goi tauyadi itoboinedi wowomi sikauumatedi taabu komatooitēdi. Nakona wowomi sikaumatedi go, geya itoboinedita balomaimi sibisikone. Tauna taabu komatooitēdi. Go sem avatau neta itoboine wowomi be balomaimi taiyao asagabugabu goi imtulidi, e amo Tauyana koomatōite. ");
INSERT INTO gvs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Aba gita tamo aguinuwe bei koyagoi itoboinemi geya komatoitedita. Sine aiyuwo maisadi giyaina ae? Go Yaubada iiyagoi neta tayamo ikámasa isou poyapoya goi. ");
INSERT INTO gvs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","E komi nakae iyagoimi. Nakae kunumi liliuna dabami goi adi badabada bogina iyagoidi. ");
INSERT INTO gvs_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tauna taabu koomatōita. Komi Yaubada konana nakae gagaina namliyeta sine. ");
INSERT INTO gvs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Tauna avatauwa neta tomota matadi goi sikamoitamoegu, yau nakae Tamada guma yábana matana goi bei akamoitamoedi. ");
INSERT INTO gvs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Go avatauwa neta tomota matadi goi silawoiwoiyegu, e yau nakae Tamada guma yábana matana goi bei alawoiwoiyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Tuwaina Yeisu kana, ‘Taabu konuuwonūwana bego ama poyapoya ame goi bei tuboina ame. Geya. Ama tuboina geya ameyeta geya, go sem yaviya ame. ");
INSERT INTO gvs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Moitamo. Yau pasigu livisi isowóduwo boda tayamo goi unana maniyedi tomota sinumisegu go, maniyedi geya. Tauna yau pasigu koroto tamana ivakaleye, vavina sinana ivakaleye be nakae vavina yaona vavina ivakaleye. ");
INSERT INTO gvs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tauna koroto ana kaleyayao moe toinina ina bodao. ");
INSERT INTO gvs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Avatauwa neta idi matakoi tamadiyao o sinadiyao o natudiyao yaidi ivakaigaga namliyeta yau yaigu, geya itoboinedita bego yau guna bodao. ");
INSERT INTO gvs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Avatauwa neta geya sitagoneta bei toinidi idi kerose siikavale be nakae sisabokuuliyegu, geya itoboinedita bei yau guna bodao. ");
INSERT INTO gvs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Avatauwa neta sipoikiki bego yawoidi sibabane, e nava yawoidi vata bei sitagau. Go avatauwa neta yau pasigu yawoidi sitagau, e nava yawoidi vau bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Avatauwa neta siuyaaonemi, e yau nakae siuyaaonegu. Go avatauwa neta yau siuyaaonegu, agu toetuna nakae siiuyaone. ");
INSERT INTO gvs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Avatauwa neta Yaubada ina tokabivalavala siiuyaone unana tauyana moitamo Yaubada ina tokabivalavala, e nava bei tokabivalavala ana vaiwówana kidi nakae sibabane. Aiyuwoina avatauwa neta tokibóbwata siiuyaone unana tauyana moitamo tokibóbwata, e nava bei tokibobwata ana vaiwówana kidi nakae sibabane. ");
INSERT INTO gvs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Avatauwa neta you tovatotówana ikaaiyaka yaidi, e bwae tuulaina toosobuna tayamo sivanim go, neta ame tauna siguinuwe, ame alatuuwokoimi konōve: Adi vaiwówana bei sibabane.’ ");
INSERT INTO gvs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yeisu kai ina tovatotowanayao yawou aiyuwo ivatulukoima ikavava, kai kana go, Tauyana asa amo ikalave ina Diyuu idi kasa tamo tamo goi iivaníbita. Ina vanibitayana goi ivaatulúkwana be nakae Yaubada Valena itaalavaite tomota yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","E kina go Iyoni deri goi ikaaiyaka go, Guyau ina guinuwa valena inove, tuwo ina tovatotowanayao ietunedi sima Yeisu yaina ");
INSERT INTO gvs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","silumadádana sidigo kadi, ‘Manakae? Kom Guyau Tauyam boi Yaubada ina tokabivalavalayao sikatotulem katuyaosim gea, ituli ta koroto nava katuuyaosi?’ ");
INSERT INTO gvs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","5","Tuwo Yeisu idigo kana, ‘Segowo, kaga atalavaaitedi bogina konovedi be kaga aguuinuwedi bogina kogitedi. Guinuwayadi ame nakae: Tokebo sigita dókana, topem siketoiyamna, vísiya liliuna tomota sakavaidi sikavava, tauyadi taiyadi patupatudi sitaiyakeka dókana, tokámasa sitaoyamna, tookaidi Vala Dedevina sinove. Kōna moe dogoiyadi madabokidi kotalavaitēdi Iyoni yaina bei iyagoi. ");
INSERT INTO gvs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aiyuwoina Iyoni kolatuwōko avatauwa neta geya sinanayuwoita yau manugu, bei adi dedevina sibabane.’ ");
INSERT INTO gvs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","E korotoyadi sitáoya sinonoina go, Iyoniyana manuna kina Yeisu ivatowo boda ilatuwokoidi idigo kana, ‘Boi kona yoyowo goi latuwomi bego avatau kogite? Gea, komi latuwomi bego koroto taameyaina kogite ina sinapu nakae dumodumo neta yágira itowo, iyaoegeege? ");
INSERT INTO gvs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nakae geya, go sem kona bego avatau kogite? Gea, komi latuwomi bego koroto tayamo mana kwama dedevina kogite? Geya ae? Konōve. Tauyadi madi kwama dedevidi tolovina idi vada dedevidi goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Tauna kona geya bego nakae kogite, go sem kona bego avatau kogite? Bego Yaubada ina tokabivalavala tayamo kogite? U, moitamo. Go ame alatuuwokoimi konōve: Tauyana tokabivalavala tayamo go, tokabivalavala kaka geya, go sem tauyana toosakina. ");
INSERT INTO gvs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Amo tauyana manuna Yaubada ina tokabivalavala igini idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ame Iyoni iguinuwe go, ame alatuuwokoimi konōve: Tomota liliudi bogina sibíbina, yaidi goi geya vatau tayaamo itoboine Iyoni tosayóyova ikalisave. Go avatauwa neta toosobudi Yaubada ina kalibúbuna sinaena goi, e tauyadi Iyoni sikalisave. ");
INSERT INTO gvs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","E Iyoni tosayóyova ina paisewa ana kaba vatowo goi go, ima ame tuta Yaubada ina bodayáuwo ikaliibubudi vakaleya gagaina toina siibabane. Ago adi tovakaleyayaoyadi sipoikíkina bego ina bodayauwoyadi siyoisidi siyogedegededi. ");
INSERT INTO gvs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Moitamo. Boi nimatu Yaubada ina tokabivalavalayao liliudi idi buki be nakae Mosese Yaubada ina Katukeda madabokina goi sitalavaita bego Guyau bei ima. Nakae sitaalavaite ana kadókana Iyoni ima Guyau ina sowóduwo italavaite. ");
INSERT INTO gvs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ago kidi tokabivalavalayadi sitalavaite bego koroto tayamo Eliyau nakae bei ima. Abóbwara moitamo, tauyana sidigedige moe Iyoniyana. Go manakae? Itoboinemi ame nuwonuwanayana konumise gea geya? ");
INSERT INTO gvs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Avatauwa komi neta ma taaiyami, guna livala konoovedōko. ");
INSERT INTO gvs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","E tomota amo tauyadi nakae kaga goi akatutukoidi? Kidi gogómana nakae neta aba maketi goi siitusobu sipapápala sediyao yaidi sikúluwo kadi, ");
INSERT INTO gvs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ima kokopi nai manuna kauweuwe go, komi geya kolauseta. Valiwoga goi kataiyakuwokúwala go, komi geya kotaiyeta.” Komi nakae. ");
INSERT INTO gvs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kogita? Nakonakae kaguinuwe o kavatulúkwana, e komi kokataema. Iyoni ima go, awoinu toina geya ikakáika, nakae oine geya inimnim. Nakae go, komi kodigo kami, “Dimoni tauyana sinaena goi ikaaiyaka!” ");
INSERT INTO gvs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tomalatomota ima ikakáika be inimnim go, kodigo kami, “Tauyana kogite? Aikanina be nakae inim ginagina iiyaluwo. Tauyana takisi ana togogo be ituli ta toogoyoidi siyadi!” Yaubada ina nanamsa Iyoni be yau kavatulúkwana go, nanamsayana ipaaisewa tomota yawoidi goi, e guinuwayadi goi tomota siyagoi Yaubada ina nanamsa moe moitamo.’ ");
INSERT INTO gvs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","E niga Yeisu ivatowo tomota asa maniyedi goi ibowoidi. Asayadi goi guinuwa toogagaidi bogina iguinuwedi. Guinuwayadi toni kasa sigitedi go, geya situgavileta, tauna ibowoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","‘Komi da Korasini be komi da Betesaida konovēgu! Da Taya be da Saidoni tomota goyogoyoidi. Neta guna guinuwa toogagaidi boi komi bogina koogitedi kidi nakae sigitedi, boi nimatu e, bogina situgavila go, idi tugavilayana ana kaba kinana siguinuwe moe kwama salisalina silosidi be selekau dabadi goi siyatoidi. Komi boi itoboinemi nakae kotugavila go, geya koguinuweyeta. O komi da Korasini be da Betesaida ami toovalugo! ");
INSERT INTO gvs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Go ame alatuuwokoimi konōve: Komi da Korasini be da Betesaida takínona ana tuta goi ami liuna gagaina toina bei kobabane namliyeta kidi da Taya be da Saidoni. ");
INSERT INTO gvs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Komi da Kapaneumi nakae. Manakae? Konuwonúwana Yaubada bei ikilagasimi yábana goi? Moe geya, go sem bei ilavemi kosou kona asagabugabu goi! Moitamo. Kidi da Sodoma toogoyoidi toidi go, neta boi nimatu guna guinuwa toogagaidi sigitedi nakae guinuwa toogagaidi boi komi kogitedi, e tauyadi nakona situgavila, tauna Yaubada geya imtulidita, go sem nakona ame tuta asayana nava ikaaiyaka. Ago komi geya. ");
INSERT INTO gvs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Go ame alatuuwokoimi konōve: Takínona ana tuta goi komi da Kapaneumi bei ami liuna gagaina namliyeta da Sodoma.’ ");
INSERT INTO gvs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tuta amo goi Yeisu ikawanoi idigo kana, ‘Tamagu, kom yábana be poyapoya idi Tomoya. Guna guinuwayadi adi yagoina bogina kuvamoudi kidi madi nanamsa be madi yagoina yaidi goi go, kidi gogómana nakae yaidi goi guna guinuwa adi yagoina bogina kukaiwoduwedi. Tauna ayapaliyem. ");
INSERT INTO gvs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Moitamo Tamagu, moe im guinuwayana im nuwonúwana goi ivauyaonem.’ ");
INSERT INTO gvs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ikawanoi ikavava, tomota yaidi goi idigo kana, ‘Kaga liliuna Tamagu nimagu goi bogina iyatoidi. Tamaguyana anetava yau Natuna iyagoidokoigu. Yau agutava Tamagu ayagoidoko go, avatauwa neta akinavedi bei Tamagu avatulukoidi, e bei siyagoidoko. ");
INSERT INTO gvs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Avatauwa komi topoisógana o mou adi tokavala, komekōigu bei waiwasi avinimi. ");
INSERT INTO gvs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yau sakuululugu be nakae nuwotookaigu, tauna guna kaitakeo kokavalavaitēgu be nakae guna vatulúkwana kovatotowōne. Neta nakae koguinuwe, e imi waiwasi bei kobabane. ");
INSERT INTO gvs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Moe moitamo. Yau guna kaitakeoyana be nakae guna vatulukwanayana sikakapu. Tauna ameko goi imi waiwasi bei kobabane.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tuta amo Yeisu kai ina tovatotowanayao taiyao tánuwo sinaena kaaketoiya Sabati goi. Kaaketoiya go, kai tovatotowanayama loga kakámasa. Tuwo kavatowo witi keuwoidi kaguwedi kakakáika. ");
INSERT INTO gvs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","E kidi go Parisi sigitema, tuwo Yeisu silatuwoko sidigo kadi, ‘Iyaa! Im tovatotowanayao manakae siguuinuwa kaga Sabati ana lovina geya itagonedeta taguinuwe?’ ");
INSERT INTO gvs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E kina Yeisuyana kana, ‘Manakae? Kaga Devida boi iguuinuwe tetelina geya kokatuyaiviyeta ae? Boi tutayana ma senao loga sikámasa go, geya avadimo. ");
INSERT INTO gvs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tuwo kina Devidayana Yaubada ina Vada goi isiu, Tonúwala yaina ikawanoi awoinu manuna. Tuwo Tonuwalayana beredi kaasalaidi ikabidi, Devida ivini ikáika. Ikáika ikavava, senao nakae ivinidi sikáika go, kidi Devida ma senao geya adi tagonamo berediyadi sikáika. Moe kidi Tonúwala taudiva madi tagona sikáika. ");
INSERT INTO gvs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Aiyuwoina Tonúwala Vada Kimaasabaina goi sisiusiu Sabati goi sipaaisewa. Moe nakae Sabati ana lovina sikapipilave go, kidi geya adi pikwanamo. Manakae? Yaubada ina Katukeda goi ame geya kokatuyaiviyeta ae? ");
INSERT INTO gvs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","E ame alatuuwokoimi konōve: Tayamo tomota ameni gagaina namliyeta Vada Kimaasabaina. ");
INSERT INTO gvs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","E Gínina Kimaasabaina goi Yaubada idigo kana, “Latuwogu yoguyogu kokasaledi yau yaigu, go sem latuwogu toina moe konuwokapisi.” Oseya 6:6 Neta ame talavaitayana ana yagoina koyagoi, e tauyadi geya adi pikwanamo geya kotakinoidita kidi toogoyoidi. ");
INSERT INTO gvs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Moitamo. Tomalatomota moe Sabati ana Tomoya, e ilovina kaga itoboine Sabati goi tomota siguinuwe, tauna guna tovatotowanayao geya adi pikwanamo.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yeisu itáoya, tanuwoyana ikalave go, ina Diyuu idi kaba tugúguna goi isiu. ");
INSERT INTO gvs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Koroto tayamo amoko goi ikaaiyaka, nimana napanapaina go, kaamasina. Kidi Parisi nakae sikaaiyaka; latuwodi bego Yeisu sikamamaetali Sabati ana lovina ana tokapipilova, tuwo silumadade sidigo kadi, ‘Manakae? Yaubada ina Katukeda itagoneda Sabati goi tomota takidedevinedi gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Go kina Yeisuyana idigo kana, ‘Neta Sabati go, komi vatauwa neta imi sipi tayamo bobosiu goi isouye, manakae? Bei kobulagasi, gea geya? Geya, bei kobulagasi. ");
INSERT INTO gvs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Go sipi kaga? Dogoi giyaina ae? Go tomota kónana gagaina. Tauna neta itoboineda Sabati goi sipi tavaite, e itoboineda Sabati goi tomota nakae tavaitedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tuwo itugavila korotoyana ilatuwoko idigo kana, ‘Siyagu, nimam kuyosāle!’ Tuwo moitamo nimana iyosale go, bogina idedevina, nimana aiyuwoina nakae. ");
INSERT INTO gvs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","E kidi Parisiyadi sitáoya, aba tugugunayana goi sisowóduwo sina taudiva silosinapu manakaedi bei Yeisu sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","E kina go Yeisuyana bogina iyagoi kaga amo tauyadi sinuwonuwone, tuwo ikabima amo dadavayana kakalave. Ago boda gagaina Yeisu sisabokuliye. Tomotayadi yaidi goi maniyedi sikatówana go, madabokidi ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ikavava, ilovinaedi idigo kana, ‘Taabu kotaalavāita bego yau avatau.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Moeko goi kaga boi nimatu Yaubada ina tokabivalavala Aiseya idigedige, imalatomotamna. Tauyana Yaubada ina livala italavaite idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Konōve! Guna kitom goame. ");
INSERT INTO gvs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tauyana geya ikaumakimaki. ");
INSERT INTO gvs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Geya vatau tayaamo neenetaina ");
INSERT INTO gvs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ago kidi Totuyoyowo bei Tauyana silotutae.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","E niga koroto tayamo tomota sime Yeisu yaina. Korotoyana naagovaina go, matana kebokeboina be nakae maena moumouna. E sime go, Yeisu ikidedevine, tauna korotoyana itoboine ibóbwara be nakae igita. ");
INSERT INTO gvs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ago tomota sikaaiyaka Yeisu ina guinuwa sigite, madabokidi nukotodi siwówana nakae sidigo kadi, ‘Manakae? Amo tauyana nakona Devida tubuna gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","E kidi go Parisiyadi nakae sikaaiyaka, tomota idi livala sinovedi, sidigo kadi, ‘Ame tauyana dimoni ivataapiyedi go, moe dimoni idi tolovina Beyelisebuli ina togaga kaka goi ivataapiyedi siisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Go tauyadi idi nuwonúwana Yeisu bogina iyagoidi, tuwo ilatuwokoidi idigo kana, ‘Aba lovina liliudi neta sinaedi tomota siilivisi, aba lovinayadi bei sisou. Asa o bodayáuwo liliudi nakae. Neta sinaedi tomota siilivisi, tomotayadi geya sitaoyakavateta, go sem bei sisapa. ");
INSERT INTO gvs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ida Kaleya nakae. Neta toinina ina bodao ivatapiyedi, moe nakae ilivisidi. Go moe kaga ana dedevina? Ina lovinayana manakaena bei itogaga? Geya! Neta toinina ina bodao ilivisidi, ina lovinayana bei ikavava. ");
INSERT INTO gvs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yau nakae. Neta yau Beyelisebuli ina togaga goi dimoni avataapiyedi, e komi toinimi imi bodao nakae, tauyana ina togaga goi dimoni sivataapiyedi. Go moe nakae geya ae? Moe pasina nava bei toinimi imi bodao sitakinoimi komi tobágala. ");
INSERT INTO gvs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Go Yau Yaubada Balomaina ina togaga goi dimoni avataapiyedi, tauna ina kalibúbuna bogina imaiyaba yaimi. ");
INSERT INTO gvs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yau dimoni avataapiyedi go, geya kada tauyana ina togaga goi avataapiyedi. Aba gita tayamo aguinuwe bei koyagoi Yaubada Balomaina goi dimoni avataapiyedi. Ida Kaleya koroto toogilúluna nakae. Avatau itoboine togilulunayana ina vada goi isiumo go, konana ivainaoidi? Geya ae? Go koroto tayamo neta togilulunayana ina vada goi isiu go, mainao ivasobusobuye namliyeta baige nimana aena iyowóidi, e itoboine bei konana ivainaoidi. E yau nakae. Ida Kaleya bogina avasobusobuye, tauna itoboinegu ina dimoni avatapiyedi. ");
INSERT INTO gvs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Geya konanayuwoita yau manugu. Avatau neta yau taiyao geya kaspwagogoneta, tauyana guna kaleya. Avatau neta tomota geya italigogoidita yau taiyao, e tomotayadi ikausapesapedi. ");
INSERT INTO gvs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tauna imi wowokanayana pasina ame alatuuwokoimi konōve: Tomota idi goyo liliudi be idi tagíwaya liliudi sivaatoidi, adi nuwotao bei sibabane, go sem avatauwa neta Baloma Kimaasabaina sitagiwoi, e adi nuwotao geya sibabaneyeta ame tuta be nakae tuta simamaima. ");
INSERT INTO gvs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Avatauwa neta Tomalatomota sitagiwoi, e adi nuwotao bei sibabane. Go avatauwa neta Baloma Kimaasabaina sitagiwoi, e adi nuwotao geya sibabaneyeta, ame tuta be nakae tuta imamaima. ");
INSERT INTO gvs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Komi kodovatusidokōigu. Neta alova tayamo dedevina, e keuwoina nakae dedevina. Neta alova tayamo igoyo, e keuwoina nakae igoyo. Moitamo. Alova keuwoidi goi takinanedi, nakona dedevidi o sigoyo. Tauna yau nakonakae? ");
INSERT INTO gvs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Komi moteta nakae! Manakae? Komi toogoyoimi itoboinemi bóbwara dedevidi kovatoidi gea geya? Geya! Bogina koyagoi. Kaga neta nuwoda ivakayaodei, e sopada nakae sivatoi. ");
INSERT INTO gvs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tomota nuwodi goi idi esaesa sikanukulidi. Tuwo tomota dedevina ina esaesayadi dedevidi goi dogoi dedevidi ikaiwoduwedi. Ago tomota goyogoyoina ina esaesa goyogoyoidi goi dogoi goyogoyoidi ikaiwoduwedi. ");
INSERT INTO gvs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","E ame alatuuwokoimi konōve: Takínona ana maliyalina goi tomota idi livala besobeso liliudi sivaatoidi bei Yaubada yaina sitalaseyanedi. ");
INSERT INTO gvs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Moe moitamo. Imi livala pasidi Yaubada bei ivayokoimi komi kiboobosimi, e nakae imi livala pasidi Yaubada bei itakinoimi komi toogoyoimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tuwo Yaubada ina Katukeda ana tovatulukwanayao maniyedi be nakae Parisi maniyedi Yeisu ina vatulúkwana sinove, sidigo kadi, ‘Tovatulúkwana, latuwoma aba kinana tayamo kuvatulukoima kagite bei kayagoi kom moitamo Yaubada goi kuma.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Go kina Yeisuyana idigo kana, ‘Tomota neta goyo sinadi be nakae Yaubada situgavile, e aba kinana siiyaledi. Ago Yaubada aba kinana tayamo toito bei ivinidi go, tuwaina geya. Aba kinanayana moe tokabivalavala Iyona. ");
INSERT INTO gvs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Moitamo. Iyona íyana sinaena goi ikaaiyaka maliyalina aito be sabamgo aito, e nakae Tomalatomota poyapoya sinaena goi bei ikaiyaka maliyalina aito be nakae sabamgo aito. ");
INSERT INTO gvs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Boi Iyonayana ina talavaita da Ninivei sinove, e situgavila. Go konōve. Tomota tayamo toolagaina ameni namliyeta Iyona go, ame togoyoidiyadi nava geya situgavileta. Tauna takínona ana tuta goi da Ninivei bei sitáoya, ame togoyoidiyadi idi goyo bei sitalaledi. ");
INSERT INTO gvs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Aiyuwoina giyovila tayamo Totuyoyowo go, ina kaba lovina moe Siba youya dadavina goi. Tauyana boi aduwanau goi ima Solomoni ina nanamsa inove. Go konōve. Tomota tayamo toolagaina ameni namliyeta baige Solomoni. Go ame togoyoidiyadi nanamsa gagaina bogina sinove go, nava geya situgavileta. Tauna takínona ana tuta goi giyovilayana bei itáoya kidi taiyao go, idi goyo bei italaledi. ");
INSERT INTO gvs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","E nakona dimoni tomota tayamo ikinagove go, tutayana dimoniyana sivatapiye bogina isowóduwo, e ina asa yoyowo goi aba waiwasi iilusala. Iilusala go, geya tayaamo ibabane. ");
INSERT INTO gvs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tuwo idigo kana, “Bei akaluvilamna ana vadayana boi aakalave goi.” Ago ima, tomotayana ibabane vada nakae bogina daakakaina be kaidiiyoyaina be nakae katubaayasina. ");
INSERT INTO gvs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","E tuwo dimoniyana ina ituli ta dimoni adi badabada ainima aiyuwo ikabidi imedi. Tauyadi goyogoyoidi toina, nakae dimoniyana ina goyo sikaalisave. Ikabidi, imedi vadayana sisiu sikaaiyaka. Amo korotoyana ina kaiyaka boi tupwana igoyo go, ame igoyo toina. Tauna nakae bei isowóduwo togoyoimiyami yaimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yeisu nava boda ilatuuwokoidi go, sinana be senao sima moetala goi siitáoya; latuwodi bego Tauyana silatuwoko. ");
INSERT INTO gvs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","E tomota tayamo idigo kana, ‘Gwa! Sinam be semowo moetala goi siitáoya; latuwodi kom kunovedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Go kina Yeisu idigo kana, ‘Sinagu avatau? Segowo avatauwa?’ ");
INSERT INTO gvs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nimana kai ina tovatotowanayao ivasakikinakoima, idigo kana, ‘Sinagu be segowo goamedi! ");
INSERT INTO gvs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Moitamo. Avatauwa neta Tamagu guma yábana ina nuwonúwana siguuinuwe, e moe tauyadi segowo nakae niugowo nakae sinagowo.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Maliyalina amo goi Yeisu itáoya kai taiyao vada goi kasowóduwo go, Yeisuyana iiwo ina Galili labutabutaina goi itusobu. ");
INSERT INTO gvs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iitusobu go, boda gagaina sitaligógana sima Tauyana yaina. Tauna itáoya iiwo ina oga goi isowoya, itusobu go, bodayadi labutabuta goi siitáoya. ");
INSERT INTO gvs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iitusobu, vatulúkwana badabadaidi livalakaibala goi ivatuulukoidi idigo kana, ‘Ame konōve: Tobágula tayamo ina ina tánuwo goi witi kutukutuna isivagaegaedi. ");
INSERT INTO gvs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Isivagaaegaedi, e maniyedi sisou enao goi. Tuwo mánuwo sisou sima sikanidi. ");
INSERT INTO gvs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","E kutukutuyadi maniyedi sisou manamanáiyala goi go, mainao sitabo unana poyapoya giyaina. ");
INSERT INTO gvs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","E níyala ituko, iidimoidi simémala unana lamdi sitetalamo. ");
INSERT INTO gvs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Go kutukutuyadi maniyedi sisou taliboibo goi, e taiyao sitabo, sibíbina go, taliboiboyadi sididimatedi. ");
INSERT INTO gvs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","E kutukutuyadi maniyedi sisou poyapoya dedevina goi sitabo sikéuwo. E dibayoya ana tuta maniyena 100, maniyena 60, maniyena 30. ");
INSERT INTO gvs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Avatauwa komi neta ma taaiyami, guna livala konoovedōko!’ ");
INSERT INTO gvs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Yeisu ibóbwara ikavava, kai ina tovatotowanayao kama kalumadade kadigo kama, ‘Kaga unana livalakaibala goi boda kulatuuwokoidi?’ ");
INSERT INTO gvs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E Tauyana idigo kana, ‘Yaubada nanamsa bogina ivinimi bei itoboinemi ina nuwogau ina kalibúbuna manuna koyagoi. Go bodayadi geya ivinidita bego siyagoi. ");
INSERT INTO gvs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Avatauwa neta guna livala sinoovedoko, nanamsa tuwaina Yaubada bei ivinidi. Ago avatauwa neta guna livalayana sinooveyamo, ava nanamsa ikaaiyaka tauyadi yaidi, Yaubada bei ikuliuye. ");
INSERT INTO gvs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ame pasina livalakaibala goi alatuwokoidi bego sigitagita go, geya sigitadokoneta. Sitaaiyakeka go, geya sinoveyeta be nakae geya siyagoiyeta. ");
INSERT INTO gvs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kidi goi Aiseya ina talavaita imalatomotamna. Tauyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Moitamo. Amo tomotayadi dabadi sikasa, ");
INSERT INTO gvs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","E komi sem matami goi kogita be nakae taiyami goi konowo, tauna ami dedevina bogina kobabane. ");
INSERT INTO gvs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","U, moe nakae ami dedevina bogina kobabane go, ame alatuuwokoimi konōve: Boi nimatu Yaubada ina tokabivalavala badabadaidi be nakae tokibóbwata latuwodi bego sigite kaga koogitegu aguuinuwe go, geya sigitedita. Latuwodi bego sinove kaga kaga koonovedi avatulúkwana go, geya sinovedita. ");
INSERT INTO gvs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tauna komi konōve tobágula ana livalakaibala ana talígava. ");
INSERT INTO gvs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Avatauwa neta Yaubada ina kalibúbuna valena sinove go, geya siyagoiyeta, e tauyadi poyapoya enao goi nakae. Poyapoyayana goi kutukutu sisou go, kina Togoyoinayana ima kaga boi tobágula iibaguli tauyadi nuwodi goi, e ineboidi. ");
INSERT INTO gvs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","E tomota maniyedi amo manamanaiyalayana nakae tutayana kutukutu sisou sitabo. Ame tauyadi Yaubada ina kalibúbuna valena sinove go, mainao madi uyáwana siuuyaone. ");
INSERT INTO gvs_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Valayana siuuyaone go, nuwodi goi geya ikaseta nakae poyapoya kakaaraiina goi lam geya ikaseta. Tuwo tuta kaakupina tauna ikaaiyaka. E tutayana valayana pasina mou be yogedageda sibabanedi, mainao sikapusi. ");
INSERT INTO gvs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","E tomota maniyedi amo poyapoyayana talibooibina nakae tutayana kutukutu sisou sitabo. Ame tauyadi Yaubada ina kalibúbuna valena sinove go, niga idi kaiyaka ana nuwokubukubu be nakae esaesa ina tubanibani sisowóduwo, e taliboibo nakae valayana sididimate, tauna geya sikeuwoita. ");
INSERT INTO gvs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","E tomota maniyedi amo poyapoyayana dedevina nakae tutayana kutukutu sisou sitabo. Ame tauyadi moitamo Yaubada ina kalibúbuna valena sinove, siyagoi be nakae keuwoidi dedevidi sikeeuwoedi; maniyena 100, maniyena 60, maniyena 30.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yeisu livalakaibala aiyuwoina ivinima idigo kana, ‘Yaubada ina kalibúbuna ana kaiyaka ame livalakaibalayana nakae: Koroto tayamo witi kutukutudi dedevidi ikabidi, ina ina tánuwo goi isivagaegaedi. ");
INSERT INTO gvs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Isivagaegaedi ikavava, ina go, niga tauyana mana bodao simasisi. Tutayana siimasisi go, korotoyana ana kaleya tayamo ima tanuwoyana goi sisinétala kutukutudi isivagaegaedi. Ikavava, ina. ");
INSERT INTO gvs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tutayana witi sitabo, sikéuwo, e namliyeta baige sisinetalayadi nakae sitabo. ");
INSERT INTO gvs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","E toni tánuwo ina pakonayao sima silatuwoko sidigo kadi, “Ima tomoya, kom boi im tánuwo goi kutukutu dedevidi kusivagaegaedi ae? Go sisinétala nako goi sima?” ");
INSERT INTO gvs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Moe guna kaleya ina guinuwa”, korotoyana kaena. E ina pakonayaoyadi kadi, “Go manakae? Latuwom kana sisinetalayadi kalabudi gea tuwo?” ");
INSERT INTO gvs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","E kina kana, “Geya tuwo, govila bei sisinetalayadi kolabudi, e witi taiyao kolabupatukoidi. ");
INSERT INTO gvs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kokalavēdi, taiyao sibíbina ana kadókana dibayoya. E dibayoya ana tuta guna todibayoyayao bei alatuwokoidi mainao sisinétala silabudi, niga sipatumidi bei sigabudi go, witiyadi silamgogoidi guna sánala goi siyatoidi.”’ ");
INSERT INTO gvs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeisu livalakaibala tuwaina ivinima idigo kana, ‘Yaubada ina kalibúbuna sinaena goi ina bodayáuwo adi vaituwo ana kaigigita alova tayamo kutukutuna giyaina nakae. Kutukutuyana koroto tayamo ikabi, ina ina tánuwo goi ibaguli. ");
INSERT INTO gvs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kutukutuyana giyaina toina, nakae kutukutu liliudi goi geya tayaamo alova kutukutuna giyaina nakae. Go tutayana alovayana ibíbina imatuwo, e alova gagaina, nakae alova liliudi itabosavedi. Tauna mánuwo sima laonina goi idi vátala siyowóidi.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeisu livalakaibala tuwaina ivinima, idigo kana, ‘Yaubada ina kalibúbuna sinaena goi ina bodayáuwo adi vaituwo ana kaigigita isti nakae. Vavina tayamo ana isti ikabi, ana parawa gagaina toina goi ipopoli. Ipopoli ikavava, iyato ana kadókana istiyana isiu parawa madabokina goi ipaisewa, tauna ibíbina gagaina.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yeisu ina vatulúkwana ame madabokina moe livalakaibala kaka goi tomota ilatuuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Tauna Yaubada ina tokabivalavala ina talavaita imalatomotamna. Boi tokabivalavalayana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","E tuwo Yeisu boda ikalavedi go, ina boi vadayana iikalave goi isiu. Isiu go, kai ina tovatotowanayao kama kadigo kama, ‘Tomoya, livalakaibala sisinétala tánuwo goi kulumavivīsi kanove.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E kina Yeisu idigo kana, ‘Korotoyana kutukutu dedevidi isivagaegaedi moe Tomalatomota. ");
INSERT INTO gvs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","E tanuwoyana moe poyapoya ana madabokina. E kidi go kutukutu dedevidi moe Yaubada ina bodayáuwo ina kalibúbuna sinaena goi sikaaiyaka. E kidi go sisinétala moe Togoyoinayana ina bodao. ");
INSERT INTO gvs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","E kina go kaleyayana boi sisinétala isivagaegaedi moe Totagíwaya. E dibayoyayana moe tuta ana kaba lukavava. E kidi go todibayoyayadi moe anerose. ");
INSERT INTO gvs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tauna nakonakae sisinétala silamgogoidi, yeu sikabi sigabudi, e nakae tuta ana kaba lukavava goi bei isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kina Tomalatomota ina aneroseyao bei ietunedi sina ina kaba kalibúbuna sinaena goi goyo adi totalewúwuna liliudi be nakae lovina adi tokapipilova liliudi silabudi. Ikavava silamgogoidi, ");
INSERT INTO gvs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","silavedi yeu goi sigabudi. Amoko goi tomota sitáiya be nakae saladi sikakavatedi simatamaimaita. ");
INSERT INTO gvs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","E tuwo tokibóbwata bei sinínima níyala nakae Tamadi ina kalibúbuna sinaena. Avatauwa komi neta ma taaiyami, guna livala konoovedōko.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tuwaina Yeisu kana, ‘Yaubada ina kalibúbuna ana siu ana yala ana kaigigita ame livalakaibalayana nakae: Esaesa vamoounina poyapoya sinaena goi ikaaiyaka go, koroto tayamo ima esaesayana ibabane. Esaesayana pasina tauyana iuyáwana. Tauna ivamoumnei go, ina konana liliudi ikabidi ikaigimonedi. Ikavava, ana maisa ikabi, ina poyapoya igimone bei esaesayana ikabi. ");
INSERT INTO gvs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tuwaina Yaubada ina kalibúbuna ana siu ana yala ana kaigigita ame livalakaibalayana nakae: Paku ana tolusala tayamo paku dedevidi iilusala. ");
INSERT INTO gvs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iilusala, e tayamo ibabane ana maisa gagaina toina. Tuwo ina konana liliudi ikabidi, ina ikaigimonedi. Ikavava, ana maisa ikabi, ikaluvilamna ina pakuyana igimone.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tuwaina Yeisu kana, ‘Tuwaina, Yaubada ina kalibúbuna sinaena goi takínona ana kaigigita ame livalakaibalayana nakae: Koroto idi úwata silave négwasa goi, e íyana ituli ituli sikonedi. ");
INSERT INTO gvs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tutayana úwata ikayaoda, sibiu ima mamaya goi. Ikavava, situsobu iyanayadi sitakinoidi. Íyana dedevidi sikabidi nokobaba goi sidodoidi go, íyana goyogoyoidi sikalavedi. ");
INSERT INTO gvs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tauna nakae tuta ana kaba lukavava goi. Anerose bei sina tokibóbwata nauyayanaidi goi toogoyoidi sivatumasabedi, ");
INSERT INTO gvs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","silavedi yeu goi sigabudi. Amoko goi bei sitáiya be nakae saladi sikakavatedi, simatamaimaita. ");
INSERT INTO gvs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Kaga liliuna alatuuwokoimi bogina koyagoidi gea geya?’ ‘U, kayagoidi’, kaema. ");
INSERT INTO gvs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","E Yeisu kana, ‘Dedevina. Imi yagoinayana pasina Yaubada ina Katukeda ana tovatulúkwana tamo tamo neta Tokalibúbuna sisabokuliye, e tauyadi toni vada tayamo nakae; ina esaesa bogo be ina esaesa vau ikaiwoduwedi unana itoboinedi vatulukwana bogo be vatulukwana vau sivatulúkwana.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tutayana Yeisu ina livalakaibala ilukavavedi, e itáoya kai taiyao amo dadavayana kakalave ");
INSERT INTO gvs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","go, kana Yeisu toinina ina kasa. Sabati goi Tauyana ina Diyuu idi kaba tugúguna goi isiu ivatowo ivaatulúkwana. Ina vatulukwanayana itogaga, tauna tomota sikainaopa sidigo kadi, ‘Amo Tauyana ina nanamsa be ina togaga guinuwa toogagaidi manudi nako ikabidi? ");
INSERT INTO gvs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iyaa! Amo Tauyana vada ana toyówana natuna tauna. Sinana tayagoi; tauyana Meri. Senao moe Yemesa, Iyosepa, Saimoni be Yuda. ");
INSERT INTO gvs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Niunao liliudi ameko sikaaiyaka tayaagoidi. Tauyana kita nakae. Tauna ina nanamsa be nakae ina togaga nako ikabidi?’ ");
INSERT INTO gvs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tuwo gamodi igoyo, e Tauyana sikatae. E kina go Yeisuyana idigo kana, ‘Yaubada ina tokabivalavala ana wowoina ibabane asa liliudi goi go, toinina ina kasa goi be nakae toinina ina bodayáuwo goi geya ana wowoinamo.’ ");
INSERT INTO gvs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amoko goi guinuwa toogagaidi iguinuwedi go, geya sibadebadeta unana tomota geya sinumiseta. ");
INSERT INTO gvs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Amo tutayana da Galili adi tolovina Erodi Yeisu ina guinuwa valena inove. ");
INSERT INTO gvs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tuwo ina pakonayao yaidi goi Yeisu manuna idigo kana, ‘Amo korotoyana moe Iyoni tosayóyova. Tokámasa yaidi goi Yaubada bogina ikaitáoe. Ame pasina tauyana itoboine guinuwa toogagaidi iguuinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Kina go Erodiyana ina nuwonúwana nakae Iyoni ina kámasa pasina. Iyoniyana ina kámasa ame nakae: Boi Erodiyana ina lovina goi ina tovayaviyayao sina Iyoni siyoisi, nimana aena siyowóidi, e deri goi sivaisiu siyana Pilipo monena Erodiyasi manuna. ");
INSERT INTO gvs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Boi mainao Erodiyasiyana moe Pilipo monena go, kina Erodiyana siyana monena tubitubina igagi. Go kina Iyoni tuta liliuna Erodi ilaatuwoko kana, ‘Erodi, kom geya am tagonamo bei amo vavinayana kunai!’ Kina Erodiyasiyana inove, gamona igoyo, tuwo Erodi ilovina bego Iyoni deri goi sivaisiu. ");
INSERT INTO gvs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erodiyana latuwona bego Iyoni ikaumate go, boda sinuwonúwana Iyoni moe Yaubada ina tokabivalavala tayamo, tauna bodayadi imatoitedi. ");
INSERT INTO gvs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","E tuwo ina bíbina ana maliyalina isowóduwo, e boda sima áika manuna. Aikayana goi Erodiyasi natuna vavina isiu ima boda matadi goi iláusa go, ina lausayana Erodi ivauyaone. ");
INSERT INTO gvs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tauna woiyaiyana yaina ikatótula idigo kana, ‘Iyagoida! Kaga kukawanoiye yaigu, bei avinim.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","E woiyaiyana ina sinana ilumadade ikavava, ikaluvila ina Erodi ilatuwoko idigo kana, ‘Iyoni tosayóyova bulubuluna noko goi kudodōi kuvinīgu.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Livalayana tolovina Erodi inove, nuwona imou go, ina katótula pasina be nakae ina ogaoga pasidi, tauna ilovina ina topaisewayao sina nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tuwo ina topaisewayao ietunedi sina deri goi Iyoni nukotona sibobo. ");
INSERT INTO gvs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Sibobo ikavava, bulubuluna sikabi, nokoyana tobuna goi sidodoi sime woiyaiyana sivini. Tuwo ikabi inave sinana ivini. Moe pasina tauna Erodiyana itainasi inuwonúwana Yeisu moe Iyoni go, bogina itaoyamna. ");
INSERT INTO gvs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ikavava, Iyoni ina tovatotowanayao sina wowona sikabi sinave valiwoga tukubu goi siyato. Siyato ikavava, sina Yeisu silatuwoko. ");
INSERT INTO gvs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","E Iyoni ina tovatotowanayao idi livalayana Yeisu inove, ikabima amo dadavayana kakalave go, oga goi ametava kasowoya kakailova kasaidámana kana yoyowo tayamo goi. Go boda livala sinove bego Yeisu isaidámana, tuwo idi kasa sikalavedi aedi goi siketoiya sina Tauyana sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Go kai kama kavaiu, Yeisu isou, boda gagaina igitedi inuwokapisiyedi, tuwo idi tokatowanayao ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","E bogina lavilavi toina kai Yeisu ina tovatotowanayao kama Tauyana kalatuwoko kadigo kama, ‘Ame yoyowo go! Aiyuwoina níyala giyakainava bei isaliu. Neta boda kuvalilivēdi bego sina asa goi avadi sigimona.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","E kina go Yeisuyana idigo kana, ‘Tuwo, ameko sikaaiyaka. Komi kovakanīdi.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","‘Manakaema? Ama beredi ainima be ama íyana aiyuwo, taudi go!’ kai kaema. ");
INSERT INTO gvs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","‘Kokabīdi komēdi’, Tauyana kaena. ");
INSERT INTO gvs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tuwo moitamo kana kakabidi go, Yeisu boda ilovinaedi náuna goi situsobu. Ikavava, berediyadi ainima be iyanayadi aiyuwo Yeisu kai ina tovatotowanayao kavini. Tuwo ikabidi, ikandolaga yábana goi, manudi ikauyagu Yaubada yaina. Ikavava, ikivisidi, ivinima go, kai kakabidi kana kakaiguyauyedi bodayadi yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tuwo tomota madabokidi sikáika gamodi. Sikáika ikavava, kai ina tovatotowanayaoyama valala kakatunokunokudi go, moe bayao yawou aiyuwo sikayaoda. ");
INSERT INTO gvs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","E kidi go tokaikayadi yaidi goi vevina be gogómana geya kakatuyaividita, go sem koroto kaka kakatuyaividi; adi badabada moe ainima tausani (5,000). ");
INSERT INTO gvs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Amo ikavava, mainao kai Yeisu ina tovatotowanayao ilatuwokoima idigo kana, ‘Oga goi kosowōya, kovakūmgo kotavīla kōna ta dadava go, yau boda bei alatuwokoidi sisáwala sina idi kasa.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ivalavema ikavava, bodayadi ilatuwokoidi sisáwala. Ikavava, ituko koya goi anetava ikawanoi. E níyala bogina isaliu, Tauyana anetava ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","E kai ina tovatotowanayaoyama oga goi kasowoya, kabéuta. Kabeubéuta go, bogina kana aduwanau, e aivaya oga sikaugavigavile. Bogina kuyagoi. Yágira matama goi. ");
INSERT INTO gvs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","E botomotomo goi Yeisu bwae yatana goi iketoiya imamaima. ");
INSERT INTO gvs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E kai go ina tovatotowanayaoyama kakandobala Tauyana kagite bwae yatana iketoiya imamaima, tuwo kamatoita kadigo kama, ‘Baloma goamo!’ Ima matoitayana goi kapodeda. ");
INSERT INTO gvs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","E mainao Yeisu idigo kana, ‘Kokatepātu! Yau Tauyagu. Taabu koomatōita!’ ");
INSERT INTO gvs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E kina Pita idigo kana, ‘Tomoya, neta moitamo kom, e kulatuwokōigu bwae yatana goi awokoim.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","‘Kūma!’ Yeisu kaena. Tuwo Pitayana oga goi isou go, bwae yatana goi iketoiya inonoina Yeisu yaina. ");
INSERT INTO gvs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","E inonoina go, yagirayana igite, imatoita, tuwo ivatowo isalili. Tutayana iisalili, iduduwo kana, ‘Tomoya, kuyavēgu!’ ");
INSERT INTO gvs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","E kina Yeisuyana mainao nimana ibisisobu, tauyana iyoisi idigo kana, ‘Kom to moitamo geya kunumisedokoiguta ae? Kaga unana kunanayuwo?’ ");
INSERT INTO gvs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ibóbwara ikavava, oga goi sisowoya go, yagirayana idaúmwara. ");
INSERT INTO gvs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","E kai oga ana tokaiyakoyao kasakululu Tauyana yaina kadigo kama, ‘Kom moitamo Yaubada Natuna.’ ");
INSERT INTO gvs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bogina kasaidámana kana Genesareta dadavina goi kavaiu. ");
INSERT INTO gvs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kavaiu, kasou go, toni kasa sikandoiwo Yeisu sikinane, e livala sietune ina asa liliudi amo dadavayana goi bego idi tokatowanayao liliudi simedi Yeisu yaina goi. ");
INSERT INTO gvs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Go sikawanoi makimaki Tauyana yaina kadi, ‘Kutagonema am kwama kikina kaka kabisikone?’ Tuwo moitamo itagonedi go, avatauwa neta sibisikone, e siboboina. ");
INSERT INTO gvs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","E tuta amo Parisi be nakae Yaubada ina Katukeda ana tovatulukwanayao Yerusalema goi sima Yeisu silumadade sidigo kadi, ");
INSERT INTO gvs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","‘Kaga unana im tovatotowanayao tubudao idi gulagula sikapipilavedi? Tutayana bego sikáika go, nimadi geya siinikidi. Kaga unana nakae siguuinuwe?’ ");
INSERT INTO gvs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Go kina Yeisu idigo kana, ‘Go komi nakae. Kaga unana Yaubada ina lovina kokapipilave toinimi imi gulagula ana sabokuli pasina? ");
INSERT INTO gvs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Apipilovayana manuna boi Yaubada Mosese ilatuwoko idigo kana, “Tamamiyao be sinamiyao kowowooinēdi.” Tateta 20:12; Atukeda 5:16 Aiyuwoina kana, “Avatau neta tamana o sinana igieomaemae, e to kokaumateyāmo.” ");
INSERT INTO gvs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Go komi kotagona tomota tamana o sinana ilatuwoko kana, “Yabobona ame bego avinim go, geya itoboineguta avaitem unana bogina akasale Yaubada yaina.” ");
INSERT INTO gvs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tuwo tamana o sinana geya itoboineyeta iwowoine. Tauna yabobonayana geya ivinidita unana yabobonayana bogina kaasalaina. Moeko goi toinimi imi gulagula dogoi gagaina go, Yaubada ina livala dogoi besobeso. ");
INSERT INTO gvs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Komi todedevimi polapola! Boi nimatu tutayana Aiseya Yaubada ina livala itaalavaite, e italavaitedokoimi, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ame tomotayadi sopadi goi siwowooinegu go, ");
INSERT INTO gvs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Idi vatulúkwana moe tomota idi nuwonúwana, ");
INSERT INTO gvs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yeisu ibóbwara ikavava, boda iduduwedi sima ilatuwokoidi idigo kana, ‘Konovēgu go, kopoikīki guna livala koyagoi! ");
INSERT INTO gvs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kaga tobuda goi isiu, geya ikibaibailideta, go sem kaga tobuda goi isowóduwo, e moe ikibaibailida.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E tuwo kai Yeisu ina tovatotowanayao kama Tauyana yaina kama, ‘Tomoya, kidi Parisi im livala sinove, gamodi igoyo.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Go kina Yeisuyana idigo kana, ‘Náuna liliudi neta Tamagu guma yábana geya ibagulidita bei ilabudi. ");
INSERT INTO gvs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Amo tauyadi kokalavēdi. Tauyadi tovakeda tokebo nakae. Neta tokebo ipoikíkina bego kebosiyana ivakede, e adi taiyuwokova bobosiu goi isouyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","E Pita idigo kana, ‘Livalakaibalayana kulumavivīsi bei kayagoi.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","E Yeisu kana, ‘Komi nakae nava nukotomi geya itaporeta? ");
INSERT INTO gvs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Manakae? Moe geya koyagoiyeta ae? Kaga liliuna tobuda goi sisiu, sisou sina gamoda goi namliyeta sisowóduwo sina mosamosa. ");
INSERT INTO gvs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Go kaga tobuda goi siisowóduwo moe nuwoda goi sima, e moe dogoiyadi sikibaibaailida. ");
INSERT INTO gvs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tomota nuwodi goi nuwogau goyogoyoidi, aumata, roerata, masisi goyogoyoina, vaináwana, totalavaita polapola be nakae tagíwaya sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ame dogoiyadi sikibaibailidi. Go neta takáika go, nimada geya tanikidita, e moe geya ikibaibailideta.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yeisu itáoya kai taiyao dadavayana kakalave go, kana Taya be Saidoni adi dadava goi. ");
INSERT INTO gvs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ago amo dadavayana goi Totuyoyowo tayamo Kenani vavinaina ima Yeisu yaina iduduwo idigo kana, ‘Tomoya Devida tubuna, natugu vavina ikinagova gagaina! Kunuwokapisiyēgu!’ ");
INSERT INTO gvs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Go Yeisu geya ikatumapuyeta. Tuwo kai ina tovatotowanayao kama kakawanoi kadigo kama, ‘Tomoya, vavinayana mlida goi iiduduwo, tauna kuvalilīve ina.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","E Yeisu itugavila vavinayana ilatuwoko idigo kana, ‘Tamagu ietunegu ama komi Isileli tubunao amitava yaimi goi; komi tauyami sipi sulaaigidi nakae.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","E vavinayana ibala ima Yeisu matana goi aena ivatugúyala idigo kana, ‘Tomoya, kuvaitēgu.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Go kina Yeisuyana idigo kana, ‘Geya itoboineguta gogómana avadi bei akuliuye go, alave komi weiniya yaimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","‘U, moe moitamo, Tomoya go, weiniyayadi adi towosiyao idi teboro ogalaoina goi gogomanayadi avadi mgumguna sikasámdala’, vavinayana kaena. ");
INSERT INTO gvs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tuwo Yeisu idigo kana, ‘Vavina, im numisa gagaina, tauna nakae latuwom bogina isowóduwo.’ Tuwo moitamo natunayana mainao idedevina. ");
INSERT INTO gvs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","E Yeisu kai ina tovatotowanayao taiyao katáoya dadavayana kakalave go, kaiwo kana Galili Bwaena labutabutaina goi kavayali. Niga Yeisu ituko ina koya goi itusobu. ");
INSERT INTO gvs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iitusobu go, boda sima Tauyana yaina. Bodayadi moe topem, togoyogoyo, tokebo, maedi moumoudi be nakae tokatówana simedi Tauyana matana goi siyatoidi, e ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tauna tutayana bodayadi sigite kidi maedi moumoudi sibóbwara, togoyogoyo sidedevina, topem siketoiya be nakae tokebo sigita, e sikainaopa go, kai Isileli tubunao ima Yaubada ina togaga ana káeyana sikamoitamoe. ");
INSERT INTO gvs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E kina go Yeisu kai ina tovatotowanayao iduduwema kama ilatuwokoima idigo kana, ‘Ame bodayadi bogina maliyalina aito sikaaiyaka go, geya avadimo. Geya latuwogu madi loga alatuwokoidi sisáwala, govila bei enao goi simataginigini. Tauna anuwokapisiyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ago kai ina tovatotowanayao kadigo kama, ‘Ame yoyowo go! Nako goi beredi takabidi nakae bei itoboineda boda gagaina ame tavakanidi sikáika gamodi?’ ");
INSERT INTO gvs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Go kina Yeisu idigo kana, ‘Aivina imi beredi moedi?’ ‘Geya, ainima aiyuwo go, nakae íyana giyaidi maniyedi amedi sikaaiyaka’, kai kaema. ");
INSERT INTO gvs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tuwo bodayadi ilatuwokoidi poyapoya goi situsobu. ");
INSERT INTO gvs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Situsobu ikavava, berediyadi ainima aiyuwo be nakae iyanayadi ikabidi, manudi ikauyagu Yaubada yaina. Ikavava, ikivisidi, ivinima. E kai kakabidi kanavedi kakaiguyauyedi bodayadi yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tuwo boda sikabidi, sikáika gamodi. Sikáika ikavava, valala kakatunokunokudi, bayao gagaidi ainima aiyuwo sikayaoda. ");
INSERT INTO gvs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","E kidi go tokaikayadi yaidi goi vevina be gogómana geya kakatuyaividita, go sem koroto kaka kakatuyaividi, adi badabada moe 4,000. ");
INSERT INTO gvs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Boda sikáika ikavava, Yeisu itáoya, ilatuwokoidi sisáwala go, oga kasowoya, kakailova kana Magadani ana dadava. ");
INSERT INTO gvs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yeisu kai taiyao kama kavaiu kasou go, kidi Parisi be Sadusi maniyedi sima Yeisu sivakakone sidigo kadi, ‘Aba kinana tayamo kuvatulukōima bei kayagoi kom moitamo Yaubada goi kuma.’ ");
INSERT INTO gvs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","E Yeisuyana idigo kana, ‘Lavilavi tutayana níyala isaliu neta yábana isabenínima, komi kami, “Itomo bei kelavaboina.” ");
INSERT INTO gvs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Go nobuyana neta gaota isabenínima, e bou itáoya, komi kami, “Ame bei kelavagoyo.” E yábana ana kaigigita itoboinemi kodovatusidi bei ana yagoina koyagoi go, kaga kaga sisowóduwo tuta ame goi Yaubada iguuinuwedi adi kaigigita geya itoboinemita kodovatusidi bei adi yagoina koyagoidi! ");
INSERT INTO gvs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tomota neta goyo sinadi be nakae Yaubada situgavile, e aba kinana siiyaledi. Ago Yaubada aba kinana tayamo toito bei ivinidi go, tuwaina geya. Aba kinanayana moe Iyona.’ Ibóbwara ikavava, itáoya ikalavedi. ");
INSERT INTO gvs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yeisu kai ina tovatotowanayao kasaidámana ituli ta dadava goi kavaiu. Kavaiu, kasou go, kagite beredi kanuwoilave bego kakabi. ");
INSERT INTO gvs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","E kina go Yeisuyana idigo kana, ‘Ami dodōkana kidi Parisi be Sadusi idi isti goi.’ ");
INSERT INTO gvs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Go Yeisu ina livala katainasiye, e taumava kabobóbwara kama, ‘Nakona amo nakae ilatuwokoida unana kita beredi tanuwoilave.’ ");
INSERT INTO gvs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","E kina Yeisuyana bogina iyagoi manakaema kanuwonúwana, tuwo idigo kana, ‘Komi to moitamo, geya konumisedokoiguta! Kaga pasina amitava kobobóbwara bego geya ami beredimo? ");
INSERT INTO gvs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nava geya koyagoiyeta ae? Manakae? Boi beredi ainima goi tomota 5,000 avakanidi, moe bogina konuwoilave ae? Nakae valala bayao goi kododoidi, bogina konuwoilave aivina sikesa ae? ");
INSERT INTO gvs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aiyuwoina boi beredi ainima aiyuwo goi tomota 4,000 avakanidi, moe bogina konuwoilave ae? Nakae valala bayao gagaidi goi kododoidi, bogina konuwoilave aivina sikesa ae? ");
INSERT INTO gvs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Komi manakae geya koyagoiyeta bego beredi manuna geya abobwareta, go sem kagu, “Ami dodōkana Parisi be Sadusi idi isti goi.”’ ");
INSERT INTO gvs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Amoko goi bogina kayagoi geya beredi toina manuna Yeisu idigodigo geya, go sem latuwona Parisi be Sadusi idi vatulúkwana kavakilisidi. ");
INSERT INTO gvs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","E Yeisu kai ina tovatotowanayao taiyao kana Sesariya Pilipai ana dadava. Amoko goi Yeisu ilumadadema idigo kana, ‘Tomota sibobóbwara koonovedi manakaedi sinuuwonúwana Tomalatomota manuna?’ ");
INSERT INTO gvs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","‘Tomota maniyedi sidigodigo bego Tauyana Iyoni tosayóyova. Go maniyedi sidigodigo bego Tauyana Eliyau. Go maniyedi sidigodigo bego Tauyana Yeremaya o Yaubada ina tokabivalavala tayamo’, kai kaema. ");
INSERT INTO gvs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Go Yeisu idigo kana, ‘Go komi manakaemi konuwonúwana yau manugu?’ ");
INSERT INTO gvs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","E Saimoni Pita idigo kana, ‘Kom Guyau, Yaubada maa yawoina Natuna!’ ");
INSERT INTO gvs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","E kina Yeisu idigo kana, ‘Saimoni, Iyona natuna, moe tomota geya sivatulukoimta, go sem Tamagu guma yábana ivatulukoim. Tauna am dedevina bogina kubabane. ");
INSERT INTO gvs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","E ame yau alatuuwokoim kunōve: Kom Pita o kada, “Lasáuna.” Go moe lasaunayana yatana goi bei yau guna totugugunayao alamgogoidi ayatoidi nakae lasáuna neta yatana vada tayowo ikasa. Ago ámasa geya itoboineyeta guna totugugunayaoyadi itogagasavedi. ");
INSERT INTO gvs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ame tuta lovina avadamane kom goi bego Yaubada ina kalibúbuna goi kom mam lovina. Tauna kaga poyapoya goi kusaanabode Yaubada yábana goi nakae isanabode. Aiyuwoina kaga poyapoya goi kuutagone Yaubada yábana goi nakae itagone.’ ");
INSERT INTO gvs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E tuwo kai tovatotowanayama ikatumatalima idigo kana, ‘Geya vatau tayaamo kolaatuwōko bego yau Guyau.’ ");
INSERT INTO gvs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tuta amo goi Yeisu ivatowo kai ina tovatotowanayao ivatulukoima ina kámasa manuna, idigo kana, ‘Itoboine ana Yerusalema goi tomoyamoya be Tonúwala Gagaidi be nakae Yaubada ina Katukeda ana tovatulukwanayao bei siyogedegedegu gagaina be nakae sikaumategu go, maliyalina aitonina goi Yaubada bei ikaitaoegu.’ ");
INSERT INTO gvs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ago Pita itáoya Yeisu ikabi, adi taiyuwo sibala sina masigava goi, e Pita ivatowo Yeisu ibove idigo kana, ‘Iyaa! Guna Tomoya, moe kwalāve! Moe nakae geya iisowóduwo yaim!’ ");
INSERT INTO gvs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Go Yeisu itugavila, Pita matana goi idigo kana, ‘Kom im guinuwa Kaleya nakae! Kūna mligu goi kusabokuliyēgu! Kom geya kunuwonuwoneta Yaubada ina nuwonúwana manuna, go sem tomota idi nuwonúwana manuna kunuwonúwana. Tauna kom im nuwonúwana goi kupooikíkina kumatabodeebodegu!’ ");
INSERT INTO gvs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tuwo kai Yeisu ina tovatotowanayao yaima goi idigo kana, ‘Avatauwa komi neta latuwomi bego kosabokuuliyegu, toinimi yawoimi kokaasalēdi be nakae toinimi imi kerose kokaavalēdi namliyeta baige kōma kosabokuliyēgu. ");
INSERT INTO gvs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Moitamo. Avatauwa bego yawoidi sivagagaledi, e nava yawoidi vau bei sitagau. Go avatauwa neta yau pasigu yawoidi sitagau, e nava yawoidi vata bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Guna nuwonúwana ataligei. Yawoimi moe dogoi gagaina. Nakae neta poyapoya esaesaina gagaina madabokina kokabi go, yawoimi sitagau vata, e bei kaga ana dedevina? Geya. Neta yawoimi sitagau vata, geya tayaamo kaga ikaaiyaka itoboine bei yawoimiyadi kotalamapuyedi. ");
INSERT INTO gvs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Moitamo. Tomalatomota Tamana ana káeyana tomoeeyalina goi bei ima ina aneroseyao taiyao, e bei tomota tamo tamo idi guinuwa goi ikatumapudi. ");
INSERT INTO gvs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","U, moe nakae bei isowóduwo go, ame alatuuwokoimi konōve: Tutayana Tomalatomota ima, bei ina bodao ikaliibubudi, e komi maniyemi ameko kootáoya nava bei maa yawoimi kogite.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Maliyalina ainima tayamo mlidi Yeisu itáoya, Pita, Yemesa ma siyana Iyoni ikabidi, aditava sina koya maanawena goi situko. ");
INSERT INTO gvs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Maeko goi Tauyana ana kaigigita ikanagavila, nakae maisina inínima níyala nakae go, ana kwama sivapopowou, poowoudi toina mavada tayamo nakae. ");
INSERT INTO gvs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Go geya mgoninamo Mosese be Eliyau sisowóduwo tauyadi yaidi goi go, Yeisu taiyao sibobóbwara. ");
INSERT INTO gvs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","E kina Pita iigitedi, tuwo ikaubesobeso idigo kana, ‘Guna Tomoya, ame dedevina kita ameko takaaiyaka. Manakae? Yoyou aito ayowóidi? Tayamo kom im yoyou, tayamo Mosese ina yoyou, tayamo Eliyau ina yoyou.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita nava ibobóbwara go, gaota maavadaina iumaidi. Ago gaotayana goi níyana tayamo sinove idigo kana, ‘Ame Natugu, guna kakaya, auyaonedoko. Tauyana konōve!’ ");
INSERT INTO gvs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Niyanayana ina tovatotowanayao sinove, madi matoita sikanakabobo. ");
INSERT INTO gvs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tuwo Yeisu ibala ina tauyadi ibisikonedi idigo kana, ‘Kotāoya. Taabu koomatōita.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E sitáoya, sikandobala, koroto adi taiyuwo geya sigitedita, go sem Yeisu anetava sigite ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ikavava, koya goi sisousou go, Yeisu ilovinaedi idigo kana, ‘Kaga koogitedi taabu kotalaavaitēdi ana kadókana Yaubada Tomalatomota tokámasa yaidi goi ikaitáoe.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Go Eliyau ina sowóduwo pasina ina tovatotowanayaoyadi adi taito silumadade sidigo kadi, ‘Go kom kam, “Guyau bei ikámasa.” Moe ana taiyakeka Guyau itoboine igimiima. Tauna kaga unana Yaubada ina Katukeda ana tovatulukwanayao sidigodigo bego Eliyau igimiima namliyeta Guyau bei ima?’ ");
INSERT INTO gvs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","E kina Yeisuyana idigo kana, ‘Moe moitamo. Eliyau bei ima kaga liliuna iyolimedi. ");
INSERT INTO gvs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Go ame alatuuwokoimi konōve: Eliyauyana bogina ima go, tomota geya sikinaneyeta, go sem kaga nakae latuwodi siguinuwe tauyana yaina, e nakae siguinuwe. Tomalatomota nakae, bei siyogedegede.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tuta amo goi ina tovatotowanayaoyadi adi taito bogina siyagoi moe Iyoni tosayóyova manuna ibobóbwara. ");
INSERT INTO gvs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tuwo Pita, Yemesa be Iyoni Yeisu taiyao koya goi sisou sima boda yaidi go, koroto tayamo ima Yeisu matana goi aena ivatugúyala ");
INSERT INTO gvs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","16","idigo kana, ‘Tomoya, natugu koroto ina vísiya goi ma taatavina, tauna visiyayana ibunenete. Nakae tuta maniyena ikapusi isou yeu goi go, tuta maniyena ikapusi isou bwae goi. Aiyuwoina maine bogina ame im tovatotowanayao yaidi goi bego sivaite go, geya itoboinedita sikidedevine. Tauna tauyana kunuwokapisīye.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Go kina Yeisuyana idigo kana, ‘Komi tomota manakae? Manakae? Komi numisa geya be nakae dabami sikasa ae? Tuta maanawena taiyao bogina takaaiyaka go, ava tuta bei konumisedokoigu? Tuta maanawena imi dabakasa bogina aatogage, tauna ava tuta bei konovegu? Tuwo, gomanayana kōme!’ ");
INSERT INTO gvs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tuwo gomanayana sikabi sime Tauyana yaina goi go, dimoni ikaaiyaka gomanayana sinaena ilovinae idigo kana, ‘Dimoni, kusowōduwo!’ Moitamo isowóduwo go, gomanayana mainao idedevina. ");
INSERT INTO gvs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Niga kai ina tovatotowanayaoyama ametava kama Yeisu yaina goi kadigo kama, ‘Kaga unana geya itoboinemeta amo dimoniyana kavatapiye isiya?’ ");
INSERT INTO gvs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E Yeisu kana, ‘Unana geya konumisadokoneta. U, moe pasina go, ame alatuuwokoimi konōve: Neta imi numisa beno kutukutuna nakiyana, itoboinemi ame koyayana kolatuwoko kami, “Kubāla kūna amoko goi”, bei ibala ina amoko goi. Aiyuwoina neta imi numisa beno kutukutunayana nakiyana, e geya kada tayaamo kaga bei imoumou yaimi. ");
INSERT INTO gvs_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ego dimoni amo nakae bóbwara kaka goi geya isiyeta, go sem awanoi goi be diyakímwana goi bei isowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","E kataligógana Galili goi go, Yeisu ilatuwokoima idigo kana, ‘Segowo, tomota tayamo giyakainava bei itáoya, Tomalatomota inuwotuluye tomota nimadi goi. ");
INSERT INTO gvs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ikavava, bei sikabi sikaumate go, maliyalina aitonina goi Yaubada bei ikaitáoe.’ Ame kai kanove, nuwoma imou gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","E kai kama Kapaneumi goi go, Vada Kimaasabaina ana takisi ana togogoyao sima Pita yaina sidigo kadi, ‘Imi tovatulúkwana Vada Kimaasabaina ana takisi itakisi gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","‘U’, Pita kaena. Go isiu vada goi, Yeisu mainao idigo kana, ‘Saimoni, manakaem kunuwonúwana? Poyapoya ana tolovinao nako goi idi takisi sikabidi, toinidi natudiyao gea ituli ta boda yaidi goi?’ ");
INSERT INTO gvs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","E Pitayana idigo kana, ‘Ituli ta boda goi.’ Tuwo Yeisu idigo kana, ‘Tauna natudiyao geya sitakisita. Kita nakae tokalibúbuna natunao, tauna geya tatakisita. ");
INSERT INTO gvs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Go tuwo, kuīwo kūna bwae goi im bani kulāve. Ava íyana mainao kugimibiu, e kukābi, tobuna kukikatanāi, bei mani tayamo kubabane. Maniyana kwābi kunāve Vada Kimaasabaina ana takisi ana togogoyaoyadi kuvinīdi kom be yau ida takisi manuna, govila bei tagiegamogamoguyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tuta amo goi kai ina tovatotowanayao kama Yeisu yaina kadigo kama, ‘Yaubada ina bodayáuwo liliudi ina kalibúbuna sinaena goi sikaaiyaka go, yaidi goi avatau toolagaina?’ ");
INSERT INTO gvs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tuwo Yeisu gómana tayamo iduduwe ima, e matama goi ivatáoe, ");
INSERT INTO gvs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","idigo kana, ‘Ame gómana tayamo go, ame alatuuwokoimi konōve: Imi sinapu kokaigavilēdi bei komalagogómana. Go geya, e geya itoboinemita Yaubada ina kalibúbuna sinaena goi kosiu. ");
INSERT INTO gvs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tauna avatauwa neta sinuwotokai ame gomanayana nakae, e tauyadi toolagaidi Yaubada ina kalibúbuna sinaena goi. ");
INSERT INTO gvs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Avatauwa neta toosobudi gómana ame nakae yau yoigu goi siiuyaone, e yau nakae siuyaaonegu. ");
INSERT INTO gvs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Go avatauwa neta tayamo toosobuna guna tonumisayao yaidi goi sivakapusiye, e liuna gagaina toina bei sibabane. Neta gurewa gagaidi sikabidi, nukotodi goi sisikoidi go, tauyadi silavedi sisou sina négwasa dimówana goi sisou sisalili, moe liuna giiyaina, go sem Yaubada ina liuna bei gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","O komi da poyapoya ami toovalugo unana imi kaba kapusi badabadaidi sikaaiyaka. Moitamo aba kapusi bei sisowóduwo yaimi go, avatauwa neta tovakapusi, adi toovalugo toina unana idi liuna gagaina toina bei sibabane! ");
INSERT INTO gvs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","E, ava nímana o ava káena ami píkwana ana toyomátula, e kokūpo kokalāve. Neta ma nimakuuponimi o nakae ma kaekuuponimi go, yawoimi vata kobabane, e moe dedevina, go sem neta ma nimayuwoyuwoimi o ma kaeyuwoyuwoimi silavemi kosou yeu aiyako vaatayaina goi, e moe igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Matami nakae. Ava mátana ami píkwana ana toyomátula, e kokipōsi kokalāve. Neta mata tayataya go, yawoimi vata kobabane, e moe dedevina, go sem neta mata yuwoyuwo sikabimi silavemi kosou asagabugabu sabeninimina goi, e moe igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Ami dodōkana. Guna tonumisayao nuwotookaidi taabu kokubuuyevēdi. Ame alatuuwokoimi konōve: Guna tonumisayao nuwotookaidi idi aneroseyao tuta liliuna Tamagu guma yábana matana goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Moitamo. Tomalatomota ima bego tauyadi tosuláiga iyavedi. ");
INSERT INTO gvs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Manakaemi konuwonúwana? Neta koroto tayamo mana sipi adi badabada 100 go, tayamo itagau, bei kaga iguinuwe? Ina sipi 99 deedevidi koya goi bei ikalavedi sikaaiyaka go, ina ina sipi taagáuna ilusale ae? ");
INSERT INTO gvs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ame alatuuwokoimi konōve: Neta sipiyana ibabane, sipiyana manuna bei iuyáwana gagaina toina namliyeta sipiyadi 99 deedevidi manudi. ");
INSERT INTO gvs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tauna nakae Tamada guma yábana geya latuwona bego kidi nuwotokaidiyadi yaidi goi tayamo itagau.’ ");
INSERT INTO gvs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tuwaina Yeisu kana, ‘E, neta siyami goyo iguinuwe yaimi, tauyana kokābi amitava, e kokamamaetāli. Neta inovemi, e moe dedevina. Siyami bogina kobuvile ima Yaubada ina bodayáuwo goi. ");
INSERT INTO gvs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Go neta geya inovemita, e tonumisa tayamo o adi taiyuwo kokabīdi kōna tauyana kogīte bego tauyadi itoboinedi imi wowókana sikamoitamoe. Moeko goi Yaubada ina Katukeda bogina kokabikaone. Atukedayana kana, “Totalavaita adi taiyuwo o adi taito goi itoboine tomota ina wowókana takamoitamoedi.” ");
INSERT INTO gvs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Go neta tobagalayana geya inovemita, e Yaubada ana totugugunayao kolatuwokōidi tauyana manuna. Go neta Yaubada ana totugugunayao nakae geya inovedita, e tauyana kovayōko kina Totuyoyowo o takisi ana togogo nakae. ");
INSERT INTO gvs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","U, moe nakae koguinūwe go, ame alatuuwokoimi konōve: Kaga poyapoya goi kosanabode, e Yaubada yábana goi nakae isanabode. Aiyuwoina kaga poyapoya goi kotagone, e Yaubada yábana goi nakae itagone. ");
INSERT INTO gvs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","U, moe nakae go, ame alatuuwokoimi konōve: Neta ami taiyuwo poyapoya goi imi nuwonúwana tayamo kokawanoi dogoi tayamo manuna, e Tamagu guma yábana nakae bei iguinuwe komi manumi. ");
INSERT INTO gvs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Moitamo. Neta ami taiyuwo o ami taito yoigu goi kootugúguna bei kokaawanoi, yaimi goi bei akaaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","E tuwo Pita ima Yeisu ilumadade idigo kana, ‘Tomoya, neta siyagu tuta liliuna goyo iguuinuwe yau yaigu, e sivavina itoboinegu ina goyo anuwotaoidi? Neta ana badabada sivanima sivayuwo moe itoboine gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Go kina Yeisu idigo kana, ‘Sivanima sivayuwo geya, go sem kunuwotaovāta. ");
INSERT INTO gvs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nuwotao ame nakae Yaubada ina bodayáuwo itoboinedi ina kalibúbuna sinaena goi. Ame tolovina tayamo tetelina nakae. Tolovinayana latuwona bego ina pakonayao toolagaidi idi rowaga tauyana yaina goi igogo. ");
INSERT INTO gvs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","E ivatowo go, tolovina ina tovayaviyayao ina pákwana toolagaina tayamo sime ina rowaga ivakaigaga toina, nakona aivina miliyoni nakae. ");
INSERT INTO gvs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Go geya itoboineyeta ina rowaga iyotuli, tauna ina tomoyayana ilovina bego ina tovayaviyayao sina tauyana ma monena be natudiyao be nakae konadiyao liliudi sikaigimonedi, kidi ituli ta tomota idi pakonayao go, maisadi sikabi sime tomoyayana sivini. Moe bego kina ina pakwanayana ina rowaga ana yótula. ");
INSERT INTO gvs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tuwo ina pakwanayana inove, tauna ikanakabobo ikawanoi ina tomoyayana yaina goi idigo kana, “Guna tomoya, kutuyāwata go, kaga liliuna nava bei ayotuli!” ");
INSERT INTO gvs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","E tomoya ina pakwanayana igite, tuwo inuwokapisiye, tauna tauyana ana mou goi italigei be nakae ina rowaga goi inuwotao. ");
INSERT INTO gvs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","E amo pakoninayana isowóduwo ina go, ina tosavaiyuwo tayamo ibabane. Tosavaiyuwoyana ina rowaga paakonina yaina moe tupwana, nakae 100. E ina tosavaiyuwo ibabane, nukotona iyoisi, imelu go, idigo kana, “Im rowaga yau yaigu ame tuta kuyotūli!” ");
INSERT INTO gvs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tuwo tosavaiyuwoyana ikanakabobo ikawanoi makimaki pakoninayana yaina goi idigo kana, “Siyagu, kumesayágana go, kaga liliuna nava bei ayotuli.” ");
INSERT INTO gvs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Go pakoninayana tuyáwata ikatae, go sem itáoya ina tovayaviyayao yaidi goi ina tosavaiyuwoyana italavaite. Tuwo sima siyoisi sibiusalesale sinave deri goi silave isiu go, ikaiyaka ana kadókana itoboine ina rowaga iyotuli. ");
INSERT INTO gvs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tauna pakoninayana ina tosavaiyuwo maniyedi sikaaiyaka, siyadi ina guinuwa liliuna sigite. Tauna sikategeda gagaina. Tuwo sina idi tomoya yaina goi kaga liliuna iisowóduwo sigite sitalavaite. ");
INSERT INTO gvs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","E tuwo idi talavaitayana inove, pakoninayana iduduwe ima ibove idigo kana, “Kom guna pákwana goyogoyoim! Boi im rowaga madabokina goi anuwotaoim unana kom kukawanoi makimaki yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Manakae? Itoboine im tosavaiyuwo paakonina kunuwokapisiye nakae boi yau nakae anuwokapisiyem?” ");
INSERT INTO gvs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tuwo tomoyayana mana egamogamogu ina deri ana tomatakavatayao iduduwedi sima ilatuwokoidi idigo kana, “Ame pakoninayana koyōisi, konāve deri goi kovaisīu koliūne. Amoko goi bei ikaaiyaka ana kadókana ina rowaga madabokina iyotuli.” ");
INSERT INTO gvs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tauna nakae neta komi tamo tamo atemi goi semiyao geya konuwotaoidita, e liunayana nakae Tamagu guma yábana bei iguinuwe komi yaimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tutayana Yeisu ina bóbwara ilukavavedi, itáoya kai taiyao Galili kakalave go, kana sákala Iyoridani goi kasaidámana kana bomatu dadavina, e kanonoina Yudiya ana dadava manuna. ");
INSERT INTO gvs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Go boda gagaina sima Tauyana sisabokuliye. Amoko goi idi tokatowanayao ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ago Parisi maniyedi sima bego Yeisu sikatutao, sidigo kadi, ‘Manakae? Ida lovina goi neta koroto tayamo nakonakae latuwona, mana tagona monena ivaisobuyebeso gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Go kina Yeisu idigo kana, ‘Iyaa! Ana kaigigita nakona ida buki goi geya kokatuyaiviyeta bego tuta ana kaba vatowo goi tomolúluwo tomota iwodugudi, kana, “Tomotayadi koroto be vavina iwodugudi.” ");
INSERT INTO gvs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Moe pasina Yaubada idigo kana, “E tauna moe pasina koroto tamana be sinana yaidi itumasaba go, monena taiyao situyuwo, tauna adi taiyuwokova wowodi tayamo.” ");
INSERT INTO gvs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tauna geya tuwaina kada tauyadi tomota adi taiyuwo, go sem ame tuta tauyadi wowodi tayamo. Tauna avatauwa neta Yaubada nai goi ivatuyuwedi, e tomota taabu sivatumaasabēdi.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Go kidi Parisiyadi sidigo kadi, ‘Go kaga unana tauna Mosese lovina tayamo tubudao ivinidi bego koroto tayamo neta latuwona monena ivaisobuye, e ana katae igini. Ikavava, monenayana ivini, ivaisobuye?’ ");
INSERT INTO gvs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Go kina Yeisu idigo kana, ‘Imi dabakasa pasina Mosese itagonemi monemiyao kovaisobuyedi. Go boi nimatu tuta ana kaba vatowo goi, e moe nakae geya. ");
INSERT INTO gvs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","E ame alatuuwokoimi konōve: Ava koroto neta monena geya iroerateta go, ivaisobuyebeso bego inaidámana ituli ta vavina yaina, e bogina iroerata.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Go kai tovatotówana kadigo kama, ‘Tomoya, neta nai ana lovina nakae, e itoboine koroto vavina bei taabu sinaināi.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Go Yeisu kana, ‘Moe nuwonuwanayana nai manuna tomota liliudi geya itoboinedita siuyaone bei siguinuwe, go sem avatauwa neta Yaubada ina togaga ivinidi, e tauyadi aditava itoboinedi nuwonuwanayana siuyaone bei siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Koroto maniyedi adi bíbina kunu goi geya kutukutudimo, tauna nai odi ikai. Aiyuwoina koroto maniyedi kutukutudi tomota sikabidi, tauna nai odi ikai. Ago koroto maniyedi latuwodi bego Yaubada ina kalibúbuna manuna sipaisewa, tauna toinidi nai sitoto. Avatauwa itobooinedi, e ame livalayana siuyaōne bei siguinuwe.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","E tuwo tomota maniyedi natudiyao giyaidi simedi Yeisu yaina goi bego dabadi iyoisidi be manudi ikawanoi Yaubada yaina. E kai go ina tovatotowanayao katáoya tomotayadi kabowoidi kama, ‘Taabu kononōina Yeisu yaina.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Go kina Yeisu kana, ‘Gogomanayadi taabu kosanaabodēdi, go sem kotagonēdi sima yaigu. Tomota nuwotookaidi ame tauyadi nakae Yaubada ina kalibúbuna sinaena goi bei sisiu.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tuwo gogomanayadi dabadi iyoisidi ikawanoi Yaubada yaina bego ikaipakuyedi. Ikavava, itáoya ikabima amo dadavayana kakalave kana. ");
INSERT INTO gvs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kai kaaketoiya go, koroto tayamo ima Yeisu yaina goi idigo kana, ‘Tovatulúkwana, ava guinuwa dedevina aguuinuwe bei yawoigu vata ababane?’ ");
INSERT INTO gvs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","‘Kaga unana kulumadadegu kaga dedevina manuna? Todedevina anetava. Go neta latuwom yawoim vata kubabane, e Tauyana ina lovina kukabikaonēdi’, Yeisu kaena. ");
INSERT INTO gvs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tuwo korotoyana idigo kana, ‘Ava lovinava?’ E kina Yeisu idigo kana, ‘Ame lovinayadi Yaubada ilatuwokoida takabikaonedi, kana, “Taabu kokaaumāta. Taabu korooerāta. Taabu kovaaināwana. Taabu kotalavaita polapōla. ");
INSERT INTO gvs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tamamiyao be sinamiyao kowowooinēdi.” Tateta 20:12-16; Atukeda 5:16-20 Aiyuwoina kana, “Siyami komataakoīye nakae toinimi komatakooiyemi.”’ ");
INSERT INTO gvs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tuwo tubuwauyana idigo kana, ‘Moe lovinayadi madabokiidi bogina akabikaaonedi go, kaga nava akiseyeseye?’ ");
INSERT INTO gvs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeisuyana idigo kana, ‘Neta latuwom Yaubada matana goi kumatuwo, e kūna konam liliudi kwaigimonēdi go, maisadi kwabīdi, kūna tookaidi yaidi goi kwaiguyauyēdi, e yábana goi bei kom mam esaesa. Kwaiguyauyedi ikavava, kūma kusabokuuliyēgu.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","E kina tubuwauyana Yeisu ina livala inove, mana nuuwomou ina. Bogina kuyagoi. Tauyana konana badabadaidi go, nukotona iyoi. ");
INSERT INTO gvs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","E kina go Yeisu kai ina tovatotowanayao ilatuwokoima idigo kana, ‘U, amo tauyana nuwona imou go, ame alatuuwokoimi konōve: Kidi toesaesa idi siu Yaubada ina kalibúbuna goi moumou isaki. ");
INSERT INTO gvs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","E aiyuwoina ame alatuuwokoimi konōve: Kameri yoguyogu gagaina, tauna geya itoboineyeta siláluma taporaina goi isiu ae? Ago toesaesa nakae. Bego Yaubada ina kalibúbuna sinaena goi toinidi sisiu go, geya itoboinedita, geya toina.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","E Yeisu ina livalayadi kanovedi, pasidi nukotoma siwówana gagaina toina, tauna kadigo kama, ‘Iyaa! Neta toesaesa geya itoboinedita yábana goi sisiu, avatau itoboine ana yava ibabane?’ ");
INSERT INTO gvs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","E Yeisu iipotema go, idigo kana, ‘Tomota yaidi goi moe geya itoboineyeta, go sem Yaubada yaina goi kaga liliuna sikakapu.’ ");
INSERT INTO gvs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","E tuwo kina Pita idigo kana, ‘Go kai bei manakaema? Kai kaga liliuna yaima bogina kakalavedi go, kama kasabokuuliyem, tauna kai bei kaga kababane?’ ");
INSERT INTO gvs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E kina go Yeisuyana idigo kana, ‘Moitamo konami liliudi bogina kokalavedi go, ame alatuuwokoimi konōve: Nava bei Yaubada kaga liliuna iyolimedi. Amo tutayana Tomalatomota kebana esaaesaina aba taimámina goi bei itusobu ina bodayáuwo ikalibubudi. Ago komi nakae kébana esaaesaidi yawou aiyuwo goi bei kotusobu, Isileli tubunao adi dala yawou aiyuwo bei kokalibubudi. ");
INSERT INTO gvs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ago avatau neta ina vada o senao o niunao o tamanao o sinanao o natunao o ina kaba lovina ikalavedi yau yoigu pasina, e ana katumapu ivakaigaga toina bei ibabane be nakae yawoina vata bei ibabane. ");
INSERT INTO gvs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","E badabadaidi ame tuta toolagaidi go, nava bei tauyadi toosobudi. Badabadaidi ame tuta toosobudi go, nava bei tauyadi toolagaidi.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Tuwaina Yeisu kana, ‘Moe moitamo. Vaiwówana ana kaiguyau ituli aiyako Yaubada ina kalibúbuna sinaena goi. Aiyakoyana tétala ame nakae: Koroto tayamo ikaaiyaka, tauyana toni poyapoya. E nobuyana nava matagougouna itáoya ina asa goi topaisewa ilusala bei ina oine tanuina goi sipaisewa. ");
INSERT INTO gvs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","E maniyedi ibabanedi ilatuwokoidi idigo kana, “Neta ame kopaisewa, mani tayamo goi bei aemaisimi.” E kidi sitagona, tuwo ietunedi sina ina tanuwoyana goi sipaisewa. ");
INSERT INTO gvs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Níyala tupwana ituko, aiyuwoina tauyana itáoya ina asa goi bego topaisewa tuwaina ilusala. Ima ikandobala, tomota maniyedi igitedi moteo goi sikaiyako beso. ");
INSERT INTO gvs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tuwo amo tauyadi ilatuwokoidi idigo kana, “Komi nakae kōna guna tánuwo kopaisēwa go, ava maisa itoboine, bei avinimi.” E moitamo sitagona, tuwo sina ina tánuwo goi sipaisewa. ");
INSERT INTO gvs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E dine goi be nakae lavilavi goi nakae. Korotoyana itáoya ina asa goi nakae iguinuwe. ");
INSERT INTO gvs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","E lavilavi toina goi tauyana itáoya, ina asa goi topaisewa tuwaina ilusala. Ilusala, maniyedi ibabanedi sikaiyako beso. Tuwo ilatuwokoidi kana, “Kaga unana maliyalina ana madabokina komi ameko goi kokaiyako beso?” ");
INSERT INTO gvs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tauyadi sidigo kadi, “Geya, unana geya vatau tayaamo ilatuwokoima kapaisewa.” Korotoyana idigo kana, “Komi nakae kotāoya kōna guna tánuwo goi kopaisēwa.” Tuwo moitamo sina sipaisewa. ");
INSERT INTO gvs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","E níyala giyakainava isaliu, toni tánuwo ina paisewa ana tovakumgo iduduwe ima ilatuwoko idigo kana, “Topaisewa kududuwēdi sima kuemaisīdi go, im emáisa továmliya goi kuvatōwo ina tovakumgo goi kulukavāve.” ");
INSERT INTO gvs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tuwo moitamo topaisewayadi iduduwedi sima go, tovamliyayadi iemaisidi, mani tayamo. ");
INSERT INTO gvs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ago tutayana tovakumgoyadi sima, sinuwonúwana bego tuwaina bei sikabi go, geya; adi maisa tauna nakae. Tamo tamo mani tayamo sikabi. ");
INSERT INTO gvs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Go tutayana adi maisa sikabi, e sikaukulukúluwo toni poyapoyayana yaina ");
INSERT INTO gvs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","sidigo kadi, “Kai maliyalina ana madabokina goi paisewa gagaina kaguuinuwe be nakae níyala gagaina goi kapaaisewa go, kidi továmliya awa tayamo toito goi sipaisewa. Ago kom im guinuwa yaima goi madabokima kavavasa.” ");
INSERT INTO gvs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","E kina toni poyapoyayana tokaukulukúluwo tayamo ilatuwoko kana, “Siyagu, geya abagalimta geya. Kom toinim kutagona mani tayamo manuna kupaisewa ae? ");
INSERT INTO gvs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Im mani moe kwābi, kūna. Go yau latuwogu bego továmliya tamo tamo adi mani avinidi nakae bogina avinimi. ");
INSERT INTO gvs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Manakae? Itoboinegu toinigu konagu manuna alovina, gea geya? O nakona yau tokaiguyau, tauna kuvakipikipi unana kom topiki?” ");
INSERT INTO gvs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tauna nakae kidi ame tuta toosobudi, e nava bei toolagaidi go, kidi ame tuta toolagaidi, e nava bei toosobudi.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yeisu kai ina tovatotowanayao yawou aiyuwo ikabima, katuko kanonoina Yerusalema manuna go, enao goi ametava ilatuwokoima, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","‘Konovēgu. Ame tuta tatukotuko Yerusalema manuna go, maeko goi tomota tayamo bei itáoya Tomalatomota inuwotuluye Tonúwala Gagaidi be nakae Yaubada ina Katukeda ana tovatulukwanayao nimadi goi, gobe Tauyana sitakino ámasa goi. ");
INSERT INTO gvs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Sitakino ikavava, bei sikabi, Totuyoyowo nimadi goi siyato. Ago kidi Totuyoyowoyadi bei sivaponuponuye, sidabi be nakae kerose goi situpatuko ikámasa. Ikámasa go, maliyalina aitonina goi Yaubada ikaitáoe.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","E tuwo Sebedi monena ma natunao sima Yeisu yaina go, vavinayana aena ivatugúyala; latuwona ikawanoi tayamo dogoi manuna. ");
INSERT INTO gvs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","‘Kaga latuwom?’ Yeisu kaena. Vavinayana idigo kana, ‘Tutayana im tuta alibúbuna, kom kulovīna bego yau natugowo adi taiyuwo situsobu kébana dedevidi kikim, tayamo kakataim go, tayamo kekelim.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Go natunao adi taiyuwo kina Yeisu ilatuwokoidi idigo kana, ‘Imi kawanoi ana yagoina komi geya koyagoiyeta. Gedageda keigaina goi bei anim go, manakae? Komi nakae itoboinemi konim gea geya?’ Kidi sidigo kadi, ‘Itoboinema kanim.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeisu idigo kana, ‘Moitamo, yau guna keiga goi bei konim. Go yau geya agu lovinamo alovina bego avatau kakataigu o kekeligu goi itusobu, go sem aba tusobuyadi Tamagu bogina ikatubayasidi tauyadi kiinavaidi manudi.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ago tutayana kai tovatotówana yawou kanove kaga semao sikawaanoiye, e kaegamogamoguyedi. ");
INSERT INTO gvs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","E kina go Yeisuyana itáoya, kai yawou aiyuwo iduduwema kama, idigo kana, ‘Bogina koyagoi bego Totuyoyowo adi tolovinayao siilovina makimaki Totuyoyowoyadi yaidi goi. Nakae toolagaidi idi lovina toogagaina siguuinuwe makimaki tomota yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ago komi yaimi moe nakae geya, go sem avatauwa yaimi goi bego toolagaidi, tauyadi itoboinedi komi ami tovaitayao nakae silovina. ");
INSERT INTO gvs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nakae avatauwa yaimi goi bego toosakidi, tauyadi itoboinedi idi lovina goi komi yaimi imi pakonayao nakae. ");
INSERT INTO gvs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tomalatomota nakae, tauna komi nakae itoboinemi. Tauyana ima geya kada bego tomota sivaite geya, go sem ima bego tomota ivaitedi. Yawoina moe tomota adi kaba tateta go, yawoinayana toinina ikasale ámasa goi, tomota liliudi adi katumapu.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Niga Yeisu kai ina tovatotowanayao taiyao katáoya, Yeriko kakalave kanonoina go, boda gagaina Yeisu sisabookuliye. ");
INSERT INTO gvs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ago tokebo adi taiyuwo enao kikina goi siitusobu go, vala sinove bego Yeisu iketoiya ivaatabale. Tuwo siiduduwo sidigo kadi, ‘Tomoya Devida tubuna, kunuwokapisiyēma!’ ");
INSERT INTO gvs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Go kidi bodayadi siibowoidi kadi, ‘Komi komaigāu!’ Go kidi tokeboyadi tuwaina siiduduwo kadi, ‘Tomoya Devida tubuna, kunuwokapisiyēma!’ ");
INSERT INTO gvs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tuwo Yeisu itáoya, adi taiyuwokova iduduwedi sima idigo kana, ‘Kaga go bei avekoimi?’ ");
INSERT INTO gvs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tuwo tauyadi sidigo kadi, ‘Tomoya, bego matama sidedevina.’ ");
INSERT INTO gvs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","E tuwo Yeisu mana nuwokapisi ibisibala adi taiyuwokova matadi ibisikonedi go, mainao sigita dókana, e sitáoya sivatowo Yeisu sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","E tutayana bogina kama Yerusalema goi kavakakana, e kama asa Betapegi Oribe Koyaina papanaina goi. Go kai Yeisu ina tovatotowanayao yaima goi adi taiyuwo ivamoleyedi sina asa goi. ");
INSERT INTO gvs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Go mainao ilatuwokoidi idigo kana, ‘Kōna asa amo matada goi kosīu go, mainao ase bovavina ma boonatuna siikonidi bei kobabanedi. Aseyana ma bonatuna kotaligēidi komēdi yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Avatau neta ilumadademi, komi kodīgo kami, “Tomoya latuwona iepaisewedi.” E mainao bei ietunedi sima.’ E moitamo adi taiyuwokova sina. ");
INSERT INTO gvs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","E ame dogoiyana isowóduwo bego Yaubada ina tokabivalavala ina talavaita bei imalatomotamna. Tokabivalavalayana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Natugu Saiyoni kolatuwōko kami, ");
INSERT INTO gvs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","E adi taiyuwokova sina siguinuwe nakae Yeisu bogina ilatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Sina aseyana ma boonatuna sikabidi simedi go, adi tanigo sivalilividi aseyadi toludi goi sisekulidi. Ikavava, Yeisu ase bonatunayana goi itulaga. ");
INSERT INTO gvs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","E kidi go boda gagaina sima adi tanigo sivalilividi enao goi sieveidi go, maniyedi sina alova gigidi siutudi simedi enao goi sieveidi. ");
INSERT INTO gvs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","E kidi go bodayadi sima Yeisu sivaakitau, maniyedi matana goi, maniyedi mlina goi. Sivaakitau go, siiduduwo kadi, ");
INSERT INTO gvs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yeisu ima Yerusalema goi isiu, e asa madabokina itátava go, boda sidigo kadi, ‘Amo Tauyana vatau?’ ");
INSERT INTO gvs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E kidi go bodayadi kadi, ‘Amo Yeisu; Tauyana tokabivalavala tayamo guma Nasareta Galili sinaena.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yeisu ina Vada Kimaasabaina ina kali goi isiu tokaigimona be togimona madabokidi ivatapiyedi sisiya. Ago mani ana totalamapuyao idi teboro be bunabuna adi tokaigimonayao idi kaba tusobu nakae ikausepaledi. ");
INSERT INTO gvs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikavava, ilatuwokoidi idigo kana, ‘Gínina Kimaasabaina Yaubada manuna italavaita, idigo kana, “Guna vada moe vada aba kawanoi.” Aiseya 56:7 Go komi koyatako tovaináwana idi kaba tamumu.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ibóbwara ikavava, tokebo be topem maniyedi sima Vada Kimaasabaina ana kali goi, e Yeisu ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","E kidi Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao maniyedi sikaaiyaka Yeisu aba kainaopa iguuinuwedi sigitedi. Nakae gogómana Vada Kimaasabaina ana kali goi idi duduwo sinovedi kadi, ‘Devida Tubuna takilagāsi!’ Tuwo gamodi igoyo, ");
INSERT INTO gvs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yeisu silatuwoko, sidigo kadi, ‘Amo tauyadi kunovedi kaga sidigedige manum gea geya? Kusanabodēdi!’ E kina go Yeisuyana idigo kana, ‘U, bogina anovedi! Go manakae? Ame tomwanayana manugu bogina konuwoilave ae? Tomwanayana kana, ");
INSERT INTO gvs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yeisu ibóbwara ikavava, ikalavedi go, kai ina tovatotowanayao taiyao asayana goi kasowóduwo kana asa Betani goi kamasisi. ");
INSERT INTO gvs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","E vanuwo itomo, kaluwoboi kakaluvilamna kana Yerusalema go, kanonoina Yeisu loga ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tuwo ikandobala enao kikina goi lao tayamo igite, ibala ina ikandolaga go, geya ikeuwoita, go sem vaga kaka sikaaiyaka. Tuwo ikatubolate idigo kana, ‘Geya tuwaina bei kukeuwōmna, ame tuta be nakae tuta simamaima!’ Tuwo mainao alovayana ivadiwówana. ");
INSERT INTO gvs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Go ina vadiwowanayana kai ina tovatotowanayao kagite, nuwoma iwówana kama, ‘Iyaa! Laoyana manakae mainao ivadiwówana?’ ");
INSERT INTO gvs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","E kina Yeisuyana idigo kana, ‘U, nakae isowóduwo go, ame alatuuwokoimi konōve: Neta mami numisa go, geya konanayuwoita, e kaga bogina aguinuwe laoyana yaina goi, itoboinemi nakae koguinuwe. Go tuwaina bei itoboinemi koya ame kolatuwoko kami, “Yaubada ikabim ilavem kusōu négwasa goi.” E nakae bei isowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tuwo kaga liliuna kokawaanoiye Yaubada yaina, bei kobabane neta konumisa.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E kaketoiya kama Vada Kimaasabaina ana kali goi kasiu go, Yeisu ivatowo ivatulúkwana. Ivaatulúkwana go, kidi Tonúwala Gagaidi be tomota idi tomoyamoya sima Tauyana silumadade sidigo kadi, ‘Avatau ina lovina goi moe guinuwayadi kuguuinuwedi? Nakae avatau itaagonem kuguuinuwedi?’ ");
INSERT INTO gvs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Go kina Yeisu idigo kana, ‘Yau nakae lumadádana tayamo alumadademi. Neta kokatumapu, e yau nakae bei alatuwokoimi avatau ina lovina goi ame guinuwayadi aguuinuwedi. ");
INSERT INTO gvs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Guna lumadadanayana ame nakae: Iyoni ina sayóyova moe Yaubada ina lovina goi gea tomota idi lovina goi?’ E kidi aditava sibobóbwara sidigo kadi, ‘Bei manakaeda? Neta kada, “Yaubada goi”, e Tauyana bei kana, “Moe moitamo! Tauna kaga unana geya konumiseyeta?” ");
INSERT INTO gvs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Go neta kada, “Tomota goi”, e ame bodayadi tamatooitedi seki kaga bei sivekoida. Boda liliudi sinuwonúwana Iyoni tokabivalavala tayamo.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tuwo Yeisu silatuwoko sidigo kadi, ‘Geya kayagoiyeta avatau ina lovina goi.’ Go kina Yeisu nakae idigo kana, ‘Yau nakae geya alatuwokoimita avatau ina lovina goi ame guinuwayadi aguuinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","E aiyuwoina Yeisu ibobwaramna idigo kana, ‘E tétala ame konōve go, manuna konuwolelēu: Koroto tayamo natunao koroto adi taiyuwo go, ina ina botomoya ilatuwoko idigo kana, “Natugu, kutāoya, ame tuta kūna oine tanuina goi kupaisēwa.” ");
INSERT INTO gvs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ogu ikai”, botomoyayana kaena. E niga go nukotona ikatuvilavila, tuwo moitamo ina ipaisewa. ");
INSERT INTO gvs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","E korotoyana ina bogomane nakae ilatuwoko. “Tamagu, dedevina. Bei ana”, bogomaneyana kaena. Niga go geya ina ipaiseweta. ");
INSERT INTO gvs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Adi taiyuwokova yaidi goi avatau tamana ina nuwonúwana iguinuwe?’ Kidi sidigo kadi, ‘Kina botomoya.’ Tuwo Yeisu idigo kana, ‘U, moe kina botomoya go, ame alatuuwokoimi konōve: Toogoyoidi, moe kidi takisi adi togogo be nakae tomatagogoli, Yaubada ina kalibúbuna sinaena goi bei sisiu go, komi masa bei kosiu. ");
INSERT INTO gvs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Moe moitamo. Iyoni iwo yaimi goi anasíuna ana kibóbwata italavaite go, komi geya konumiseyeta. Go kidi takisi adi togogo be nakae tomatagogoli sinumise. E komi matami goi amo kogite go, tuwo niga komi geya kotugavileta be tauyana konumise.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yeisu livalakaibala aiyuwoina ivinidi idigo kana, ‘Livalakaibala aiyuwoina konōve. Toni tánuwo tayamo ikaaiyaka. Ina tanuwoyana goi oine kaka ibaguli. Ibaguli ikavava, gurewa ikabidi tanuwoyana ana kali ikaudakodako. Ikavava, bobosiu ieli. Amoko goi oine ana kaba vavetaveta iwodugu. Iwodugu ikavava, tanuwoyana sinaena vada aba yáusa tayamo maanawena iyowo ituko ina. Iyowo ikavava, koroto maniyedi itagonedi tanuwoyana sikatoguye go, niga dibayoya ana tuta oine keuwoina maniyena bei toni tánuwo siemaisi. Tuwo kidi tokatoguyadi sikaaiyaka tánuwo sipaaisewa go, kina toni tanuwoyana itáoya ina ituli ta dadava. ");
INSERT INTO gvs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","E tutayana dibayoya ana tuta isowóduwo, toni tanuwoyana ina pakonayao ietunedi sina tánuwo ana tokatoguyao yaidi goi bego tánuwo ana takona oine sikabidi simedi. ");
INSERT INTO gvs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Simamaima go, kidi tokatoguyadi sitáoya, ina pakonayaoyadi siyoisidi, tayamo sidabiyamo, aiyuwoina sikaumate, aitonidi gurewa goi sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Aiyuwoina tuwaina ina pakonayao tupwana badabadaidi ietunedi sina go, kidi tokatoguyadi sitáoya, e nakae liliudikova sikaumatedi. ");
INSERT INTO gvs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Aba lukavava goi toni tanuwoyana inuwonúwana kana, “Tuwo bokoyo natugu bei aetune ina. Nakona bei tauyana sigite odi imayamaya.” Tuwo moitamo natunayana ietune ina. ");
INSERT INTO gvs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","E kidi go tokatoguyadi sikandobala tauyana sigite imamaima. Tuwo aditava sibobóbwara kadi, “Amo toni tánuwo natuna imamaima. Tauyana tamana ana katumapu. Tuwo ima, tayōisi takaumāte bei tanuwoyana kita ida kaba lovina.” ");
INSERT INTO gvs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tuwo moitamo tauyana ima kikidi, e siyoisi silave ina takiki goi sikaumate.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Livalakaibala ilukavave, Tonúwala Gagaidiyadi ilumadadedi idigo kana, ‘Tauna tutayana tomoyayana, moe toni tánuwo, bei ima, kaga bei iguinuwe amo tokatoguyadi yaidi goi?’ ");
INSERT INTO gvs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tonúwala Gagaidi be nakae Diyuu idi tomoyamoya sidigo kadi, ‘Amo togoyoidiyadi bei ilokaumatematedi go, ituli ta tokatogu dedevidi bei itagonedi tanuwoyana simatakavate. Amo tokatoguyadi dibayoya ana tuta bei sitakona.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kina Yeisu idigo kana, ‘Moe moitamo go, manakae? Ame tomwanayana Gínina Kimaasabaina goi konuuwaisi gea geya? Tomwanayana Guyau manuna idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Komi nakae. Yaubada Natuna kokatae. Tauna ame alatuuwokoimi konōve: Yaubada ina kalibúbuna bei ikuliuye yaimi go, ituli ta boda bei ikalibubudi, bodayadi moe Totuyoyowo. Tauyadi bei kéuwo dedevina goi sikéuwo. ");
INSERT INTO gvs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Avatau neta isou ame gurewayana goi, bei ivatuguguyali. Avatau neta yatana goi gurewayana isou, bei ikauvetevete.’ ");
INSERT INTO gvs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tuwo ina livalakaibalayadi kidi Tonúwala Gagaidi be nakae Parisi sinovedi, bogina siiyagoi bego tauyadi iidigedi. ");
INSERT INTO gvs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tuwo enao siilusala bei Yeisu siyoisi go, boda simatoitedi unana sinuwonúwana Tauyana Yaubada ina tokabivalavala tayamo, tauna nakona kaga bei sivekoidi. ");
INSERT INTO gvs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kina Yeisu aiyuwoina ilivalakaibalamna Tonúwala Gagaidi be tomoyamoya yaidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‘Yaubada ina kalibúbuna moe tétala ame nakae: Tokalibúbuna tayamo ikaaiyaka, natuna koroto bego inai, tauna ina naiyana aikanina iguinuwe. ");
INSERT INTO gvs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tomota maniyedi boi mainao bogina ilatuwokoidi aikayana manuna bego sima. Niga tutayana bogina ikatubayasi ina pakonayao ietunedi sina tomotayadi siduduwedi sima aikayana manuna. Sina tomotayadi silatuwokoidi go, kidi odi ikai. ");
INSERT INTO gvs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Aiyuwoina ina pakonayao maniyedi ietunedi sina go, mainao ilatuwokoidi kana, “Kōna tauyadi boi akawanooiyedi kolatuwokōidi kami, ‘Konōve! Tomoya ana káika bogina iguinuwe, nakae bulumakau be nakae bulumakau bonatudi bobíbina ikaumatedi ivaipoludi. Kaga liliuna bogina ikatubayasi, tauna kōma kokāika.’” ");
INSERT INTO gvs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","E moitamo sina tomotayadi silatuwokoidi go, sikawoilova geya sinoita, go sem tayamo ina ina tánuwo goi, tayamo ina ina bisinis goi. ");
INSERT INTO gvs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","E tomota maniyedi nava sikaaiyaka ina pakonayaoyadi siyoisidi sigieomaemaedi baige sikaumatedi. ");
INSERT INTO gvs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","E kina go tokalibubunayana inove bego ina pakonayao sikaumatedi, tuwo gamona igoyo toina, e ina tovayaviyayao ietunedi sina amo tokaumatayadi sikaumatedi be nakae idi kasa sigabu. ");
INSERT INTO gvs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","E tuwo tokalibúbuna ina pakonayaoyadi ilatuwokoidi idigo kana, “Aikayana bogina akatubayasi go, tauyadi boi mainao bogina aduuduwedi geya itoboinedita sima unana sikatae. ");
INSERT INTO gvs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tauna komi kōna asa sinaena goi kovanibinībita. Avatauwa neta kobabanedi, koduduwēdi sima sikáika.” ");
INSERT INTO gvs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tuwo moitamo amo pakonidiyadi sitáoya sina asa sinaena goi sivanibiníbita. Neta toogoyoidi o todedevidi sibabanedi, liliudikova sitaligogoidi sima, e aikayana ana vada sivakayaodei. ");
INSERT INTO gvs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","E tokalibubunayana ima vada goi isiu bego ogaoga igitedi go, koroto tayamo igite nai ana kwama geya ilosiyeta. ");
INSERT INTO gvs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tuwo ilatuwoko idigo kana, “Naveya, kom nai ana kwama geya kulosiyeta go, to kusiu kuma ae?” Go korotoyana itugau; geya itoboineyeta ikatumapu. ");
INSERT INTO gvs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","E tuwo kina go tokalibubunayana ina tovaitayao ilatuwokoidi idigo kana, “Kōma ame tauyana koyōisi, aena be nimana koyowōidi. Ikavava, kokābi kolāve ina moetala mamaníwana goi ikaaiyaka. Amoko goi tomota bei sitaiya vata be nakae saladi sikakaavatedi simatamaimaita.” ");
INSERT INTO gvs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","E tauna tomota madabokidi Yaubada iduduwedi go, maniyedi taudi kiinavaidi.’ ");
INSERT INTO gvs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","E tuwo kidi Parisiyadi sina silosinapu manakaedi bei Yeisu ina livala goi sikatutao. ");
INSERT INTO gvs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tuwo tauyadi idi tovatotowanayao be nakae Erodi ina bodao sietunedi sima Yeisu yaina sidigo kadi, ‘Tovatulúkwana, bogina kayagoim bego kom moitamo be nakae Yaubada ina kenao kuvatulukwana dókana. Kom tomota geya kutagonedita nuwom sikobale. Moitamo. Tomota kuwowooinedi geya adi kaigigita goi geya; nakae madabokidi sivavasa yaim. ");
INSERT INTO gvs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tauna kom im nuwonúwana takisi manuna kulatuwokōima. Manakae? Itoboine kita tatakisi Sisa yaina gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Go kina Yeisu idi nuwonúwana goyogoyoina bogina iiyagoi, tauna idigo kana, ‘Komi todedevimi polapola, manakae bego kokatutaoigu? ");
INSERT INTO gvs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takisiyana manina tayamo kovatulukōigu.’ E tuwo tauyadi sina mani tayamo sikabi sime Yeisu sivini. ");
INSERT INTO gvs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tuwo maniyana ikabi, idigo kana, ‘Mani ame goi avatau makayauna be nakae yoina?’ ");
INSERT INTO gvs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","‘Sisa!’ Tauyadi kaedi. Tuwo Yeisu idigo kana, ‘Moe moitamo. Tauna kaga neta Sisa konana, e Sisayana tavīni go, kaga neta Yaubada konana, e Yaubadayana tavīni.’ ");
INSERT INTO gvs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tuwo tauyadi ina livala sinove, sikainaopa. Geya itoboinedita sikatutao, tuwo sitáoya, Yeisu sikalave sina. ");
INSERT INTO gvs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Amo maliyalinayana goi Sadusi maniyedi sima Yeisu yaina. Tauyadi sidigodigo tokámasa geya sitaoyamneta. E sima bego Yeisu sikatutao sidigo kadi, ");
INSERT INTO gvs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","‘Tovatulúkwana, boi nimatu Mosese idigo kana, “Koroto nainaina neta geya natunamo go, ikámasa, e aena vavilaina itoboine kobuina inai. Niga neta vavinayana ivenátuna, natunao moe tokámasa ana katumapu.” ");
INSERT INTO gvs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","E tayamo aba gita ame nakae: Koroto adi badabada adi tainima adi taiyuwo sinadi tayamo boi yaima goi sikaaiyaka. Botomoya igiminai go, geya natunamo ikámasa. Tuwo aena vavilaina itáoya tuwowona kobuina ikabi inai. ");
INSERT INTO gvs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Go geya natunamo ikámasa. Tauna nakae korotoyadi senao tamo tamo. Kobuyayana sinai go, geya natudimo tamo tamo sikámasa. ");
INSERT INTO gvs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","E korotoyadi liliudikova sikamasa kówasa, namliyeta baige vavinayana nakae ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tauna neta moitamo tomota ámasa goi sitaoyamna, e amo tutayana goi korotoyadi adi tainima adi taiyuwo yaidi ava koroto moe vavina monena mooitamoina? Bogina koyagoi. Korotoyadi boi mainao nava maa yawoidi go, vavinayana liliudi sinai.’ ");
INSERT INTO gvs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Go kina Yeisuyana idigo kana, ‘Ke, moe komi imi bágala unana Gínina Kimaasabaina geya koyagoiyeta be nakae Yaubada ina togaga taoyamna manuna geya koyagoiyeta. ");
INSERT INTO gvs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Moitamo. Taoyamna ana tuta goi koroto be vevina nai geya, go sem idi kaiyaka anerose yábana goi nakae; tauyadi nai geya. ");
INSERT INTO gvs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ego tokámasa idi taoyamna manuna, Yaubada ina Gínina Kimaasabaina goi bogina ilatuwokoimi go, manakae? Geya kokatuyaiviyeta ae? Manakae kobagabágala? Tauyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yau tubumowo Eberamo, Aisake be Yakobo idi Yaubada.” Tateta 3:6 Yaubada kina geya kada tokámasa idi Yaubada geya, go sem tauyadi maa yawoidi idi Yaubada. Moeko goi taayagoi bego tokámasa sitaoyamna.’ ");
INSERT INTO gvs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tuwo boda sikaaiyaka Yeisu sinove, ina vatulúkwana pasina nukotodi siwowówana gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","E kidi go Parisi livala sinove bego Yeisu Sadusi ikausagugudi, situgúguna silosinapu manakaedi bei Yeisu sikatutao. Silosinapu ikavava, sima Tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Sima go, Yaubada ina Katukeda ana tolumavívita tayamo yaidi goi ibala ima Yeisu yaina; latuwona bego ikatutao. Tuwo ilumadade idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‘Tovatulúkwana, ava lovina Yaubada ina Katukeda goi lovina gagaina?’ ");
INSERT INTO gvs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","E Yeisu kana, ‘Gínina Kimaasabaina idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ame lovinayana moe lovina gagaina, nakae lovina liliudi ivakumgoiyedi. ");
INSERT INTO gvs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","E lovina aiyuwoina ikaaiyaka moe lovinayana vakuumgoina nakae. Lovinayana ame nakae kana, “Siyami komataakoīye nakae toinimi komatakooiyemi.” ");
INSERT INTO gvs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yaubada ina Katukeda madabokina be nakae tokabivalavala idi gínina madabokidi unadi moe ame lovinayadi aiyuwo.’ ");
INSERT INTO gvs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","E Parisiyadi nava sikaaiyaka go, Yeisu ilumadadedi ");
INSERT INTO gvs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","idigo kana, ‘Komi manakaemi konuwonúwana Guyau manuna? Tauyana avatau tubuna?’ ‘Devida tubuna’, kidi kaedi. ");
INSERT INTO gvs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Go kina Yeisu kana, ‘Neta moe moitamo, kaga unana kina Devida Guyau ikatomoyae? Boi nimatu Baloma Kimaasabaina Devida nukotona isanayato, tuwo idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Yauwe ibóbwara guna Tomoya ilatuwoko kana, ");
INSERT INTO gvs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tauna Devida igimibíbina namliyeta Guyau go, Devidayana Guyau ikatoomoyae ae? Tauna tayagoi Guyauyana moe Devida tubuna go, tuwaina, Tauyana Tomoya, e Devida itobusave!’ ");
INSERT INTO gvs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ago geya tayamo Parisi itoboine Yeisu ina lumadádana ikatumapu. Aiyuwoina amo tutayana mlina goi geya vatau tayaamo tuwaina mana katepatu bego Yeisu ilumadade. ");
INSERT INTO gvs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","E tuwo kina Yeisu boda be nakae kai ina tovatotowanayao ilatuwokoima idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‘Kidi Yaubada ina Katukeda ana tovatulukwanayao be nakae Parisi madi lovina Atukedayana silumavivisi. ");
INSERT INTO gvs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tauna kaga liliuna sivatulukoimi, nakae koguuinūwe be kokabiikaōne go, idi guinuwa taabu kovatotoowonēdi. Bogina koyagoi. Tauyadi kaga sidigedige geya siguinuweyeta. ");
INSERT INTO gvs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","E lovina badabadaidi tomota sivinidi go, lovinayadi moe kónana moumoudi nakae itomatedi. Tomota sivavabedi bego sikavaledi go, geya kada tayaamo vaita sivinidi geya. ");
INSERT INTO gvs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","E kaga liliuna siguuinuwedi moe bego tomota sigitedi bei siyapaliyedi. Nakae Gínina Kimaasabaina idi tomwana dedeogaidi siwodugudi gagaidi, dabadi goi o nimadi goi sisikoidi. Adi kwama adi kura sikimanavedi bego tomota siyapaliyedi. ");
INSERT INTO gvs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","7","E tuwaina áika gagaidi goi sisiu wowoina basekoina goi siitusobu. Tapwaroro ana kaba tugúguna sinaena wowoina basekoina goi siitusobu bei tomota siyapaliyedi. Aba maketi goi tomota sima sikatoomoyaedi be nakae siduduwedi kadi, “Tovatulúkwana Toolagaim.” Ame guinuwayadi kidi nuwodi ikabi. ");
INSERT INTO gvs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","E komi go taabu tomota kotaagonēdi siduduwemi tovatulúkwana toolagaimi. Imi tovatulúkwana tayamo toito. Nakae komi madabokimi boda tayamo, kovavasa. ");
INSERT INTO gvs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Geya vatau tayaamo poyapoya ame goi kodudūwe tamami. Komi Tamami tayamo; Tauyana yábana goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Taabu tomota sikatoomoyaēmi. Komi imi Tomoya tayamo toito; Tauyana moe Guyau. ");
INSERT INTO gvs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","E toolagaidi komi yaimi goi moe bei tauyadi imi tovaitayao. ");
INSERT INTO gvs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Go avatauwa neta toinidi sikilagalagasidi, e niga Yaubada bei ikisobuyedi. Go avatauwa neta toinidi sikisobusobuyedi, e niga Yaubada bei ikilagasidi. ");
INSERT INTO gvs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","E komi Yaubada ina Katukeda ana tovatulukwanayao be nakae Parisi, imi vatulúkwana goi tomota kosanaabodedi, e Yaubada ina kalibúbuna goi geya sisiuta. Moitamo. Komi geya latuwomi kosiu go, avatauwa neta latuwodi sisiu, komi kosanabodedi. Tauna komi tokibobwata polapola! Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Komi Yaubada ina Katukeda ana tovatulukwanayao be Parisi, kóbuya idi vada be konadi kovaaobudi namliyeta kokawanoi tuta maanawena bego tomota sigitemi. Tauna imi liuna gagaina toina bei kobabane. Komi tokibobwata polapola! Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Komi Yaubada ina Katukeda ana tovatulukwanayao be nakae Parisi, dadava liliudi goi kovanibiníbita bego tomota tayamo kotamyabi ietosaidámana bei inumisa komi nakae. Go tutayana neta tayamo ietosaidámana, e imi guinuwa pasina tauna komi itoboinemi kona asagabugabu goi go, tauyana itoboinedoko. Tauna komi tokibobwata polapola. Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Komi tovakeda kebokeboimi kodigo kami, “Avatau neta nimana ikatulágata be Vada Kimaasabaina yoina goi ikatótula, moe atotula besobeso. Go avatau neta nimana ikatulágata go, goura Vada Kimaasabaina sinaena sikaaiyaka yoidi goi ikatótula, e tauyana mana tasíkwana ina katotulayana iguinuwe.” Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Komi yaaluwoimi be tokebo! Gourayadi kimaasabaidi unana Vada Kimaasabaina pasina. Tauna nako dogoi gagaina, gourayadi gea Vada Kimaasabaina? Vadayana ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Aiyuwoina komi kovatulúkwana kami, “Avatau neta nimana ikatulágata be Yaubada ina kaba kasala yoina goi ikatótula, moe dogoi besobeso. Go avatau neta nimana ikatulágata be vininabeso aba kasalayana yatana yoina goi ikatótula, e tauyana mana tasíkwana ina katotulayana iguinuwe.” ");
INSERT INTO gvs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Komi tokebo! Vininabesoyana kimaasabaina unana aba kasala pasina. Tauna nako dogoi gagaina, vininabesoyana gea aba kasala? Aba kasalayana ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tauna avatau neta nimana ikatulágata be Yaubada ina kaba kasala yoina goi ikatótula, moe nakae aba kasala yoina be nakae kaga liliuna sikaaiyaka aba kasalayana yatana yoidi goi ikatótula. ");
INSERT INTO gvs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Aiyuwoina avatau neta nimana ikatulágata be Vada Kimaasabaina yoina goi ikatótula, moe nakae Vada yoina be nakae ana Tokaiyaka yoina goi ikatótula. ");
INSERT INTO gvs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nakae avatau neta nimana ikatulágata be yábana yoina goi ikatótula, moe nakae Yaubada kebana esaaesaina yoina be nakae ana Totulaga yoina goi ikatótula. ");
INSERT INTO gvs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Komi Yaubada ina Katukeda ana tovatulukwanayao be Parisi, Atukedayana bogina komatakavaatedoko. Nakae imi yawóuna pai, minta be dira be nakae kumina bogina Yaubada koviinibeso go, moe guinuwa giyaiina. Go guinuwa gagaidi Yaubada ina Katukedayana goi bogina kokalavedi. Guinuwa gagaidiyadi moe kivavasa, nuwokapisi be aba numisa. E itoboine guinuwayadi gagaidi be giyaidi madabokina koguinuwedi. Tauna komi todedevimi polapola! Oo komi Parisi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Komi tovakeda kebokeboimi. Komi manumánuwo ami bwenata goi kokabi, kokalave go, kameri kotono. ");
INSERT INTO gvs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Komi Yaubada ina Katukeda ana tovatulukwanayao be Parisi, komi keiga be noko nakae. Toluyedi koonikidi go, sinaedi, báila ivakayaodeidi, bailayana moe matakónana be piki. Tauna komi tokibobwata polapola! Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Komi Parisi matami kebokeboidi. Mainao keiga be noko sinaedi konikīdi bego toluyedi nakae simavada. ");
INSERT INTO gvs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","Komi Yaubada ina Katukeda ana tovatulukwanayao be Parisi, komi valiwoga ana kaba kinana nakae. Tomota sipentedi poowoudi bei toluyedi adi kaigigita kaausaraidi go, sinaedi tokámasa luludi be nakae kaga kaga baailidi sikayaoda. Komi nakae. Ami kaigigita koroto tokibóbwata go, sinaemi moe pola be apipilova sikayaoda. Tauna komi Parisi tokibobwata polapola! Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Komi Yaubada ina Katukeda ana tovatulukwanayao be Parisi moe tokibobwata polapola! Latuwomi tomota siyapaliyemi bego komi todedevimi, tauna Yaubada ina tokabivalavala adi valiwoga adi kaba kinana polapola kowoodugudi. Aiyuwoina tauyadi tokibóbwata adi valiwoga adi kaba kinana kovaapasedi bei tokamasayadi kowowoinedi. Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kodigo kami, “Neta kai boi nimatu tubumao idi tuta goi kakaaiyaka, e tubumao geya kasiukoidita bego tokabivalavalayadi kakaumatedi.” Tauna komi tokibobwata polapola! Oo komi ami toovalugo ae? ");
INSERT INTO gvs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tauna imi guinuwayadi goi toinimi kotalavaitemi bego Yaubada ina tokabivalavalayao adi tokaumatayao moe komi tubumiyao adi gulagula, tauna komi nakae. ");
INSERT INTO gvs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tuwo moe dedevina. Kaga tubumiyao siikaboge, komi kolukavāve! ");
INSERT INTO gvs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Komi moteta nakae! Moitamo siyasiyaimi! Komi manakaemi bei ami liuna asagabugabu goi kosiya? Geya! ");
INSERT INTO gvs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ame pasina tauna tokabivalavala be tonanamsa be nakae Yaubada ina Katukeda ana tovatulukwanayao mooitamoidi bei aetunedi siwo yaimi. Maniyedi bei kokaumatedi, maniyedi bei kerose goi kotupatukoidi go, maniyedi imi kaba tugúguna goi bei kodabidi. Ago maniyedi asa tamo tamo goi sikaaiyako bei koyogedegededi. ");
INSERT INTO gvs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tauna tokibobwatayao liliudi ikaikaidi adi dau poyapoya ame goi moe komi imi puwoya. Tauna adi katumapu bei kobabane. Amo tokibóbwata Ebeli ina kámasa ima Berekiya natuna Sakarayau ina kámasa. Sakarayauyana boi nimatu Vada Kimaasabaina be aba kasala go, nauyayanaidi goi tubumiyao sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","U, moe nakae siguuinuwe go, ame alatuuwokoimi konōve: Moe goyoyadi liliudi adi katumapu komi be nakae toogoyoidi komi nakae bei kobabane. ");
INSERT INTO gvs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Oiyoi komi da Yerusalema e! Boi Yaubada ina tokabivalavala kokaumatedi, nakae ina lobutu ana tolokoina ietunedi siwo yaimi goi go, komi gurewa goi kokaumatedi. Tuta liliuna latuwogu bego natumiyao alamgogoidi nakae kamkam bovavina natunao panepanena goi ilamgogoidi go, komi kokatae. ");
INSERT INTO gvs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Konovēgu. Imi vada Yaubada ikalave itugavile bei ana toovalugo. ");
INSERT INTO gvs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Moe moitamo go, ame alatuuwokoimi konōve: Geya tuwaina bei kogitemneigu ana kadókana kodigo kami, ");
INSERT INTO gvs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yeisu ibóbwara ikavava, itáoya, kai ina tovatotowanayao taiyao Vada Kimaasabaina ana kali sinaena goi kasowóduwo go, kai tovatotowanayama kabala kana Yeisu kikina goi kadigo kama, ‘Vada Kimaasabaina ana vada adi kaigigita kugitēdi, dedevidi toidi!’ ");
INSERT INTO gvs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","E kina go Yeisu idigo kana, ‘Ame vadayadi kogitedi ae? Adi kaigigita dedevidi toidi ae? U, moe nakae go, ame alatuuwokoimi konōve: Nava bei geya tayaamo gurewa vaapopoina ikaaiyaka, go sem madabokina sitagaegaekowosidi.’ ");
INSERT INTO gvs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","E ibóbwara ikavava, ituko ina Oribe Koyaina goi itusobu go, kai ina tovatotowanayao ametava kabala kama Tauyana yaina goi kadigo kama, ‘Kulatuwokōima ava tuta bei moe dogoiyadi sisowóduwo. Aiyuwoina im kaluvilamna be nakae tuta ana kaba lukavava kaga bei adi kaba kinana?’ ");
INSERT INTO gvs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tuwo Yeisu idigo kana, ‘Komi ami dodōkana, govila bei tomota sivasulaigimi. ");
INSERT INTO gvs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Moitamo. Topola badabadaidi bei sima yoigu sivatoi kadi, “Yau Guyau.” E idi polayana goi boda gagaina bei sivasulaigidi. ");
INSERT INTO gvs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","E yaviya valedi bei konovedi yomana be aduwanau go, taabu kokaateyōva. Itoboine ame dogoiyadi sisowóduwo go, poyapoya ana kaba lukavava moe nava. ");
INSERT INTO gvs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ame moitamo. Nava bei ta boda ta boda sitáoya taiyao sivayaviya. Nakae ta kaba lovina ta kaba lovina bei sitáoya taiyao sivayaviya. Asa liliuna goi loga bei sisowóduwo be nakae nikuniku sitátava. ");
INSERT INTO gvs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","E ame dogoiyadi liliudi moe tuta moumoudi adi kaba vatowo; vevina neta idi tuta venátuna ana geda ana kaba vatowo nakae. ");
INSERT INTO gvs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Niga ami kaleyayao bei maniyemi siyoisimi be siyogedegedemi go, maniyemi bei sikaumatemi. Ago boda liliuna bei sikaolilivemi unana yau yoigu ikaaiyaka yaimi. ");
INSERT INTO gvs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ago amo tutayana tonumisa badabadaidi idi numisa goi bei sikapusi. Sediyao bei sinuwotuluyedi nakae sikaolilivedi. ");
INSERT INTO gvs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tokabivalavala polapola badabadaidi bei sitáoya, tomota badabadaidi sivasulaigidi. ");
INSERT INTO gvs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Boda badabadaidi idi matakoi bei isáwala unana apipilova isáila. ");
INSERT INTO gvs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Go avatauwa neta sitaoyakavata ana kadókana poyapoya ana kaba lukavava, e adi yava bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ago guna tonumisayao bei sina poyapoya ana madabokina goi sitalavaita Yaubada ina kalibúbuna valena dedevina manuna bei Totuyoyowo liliudi sinove. Amo tutayana goi tuta ana kaba lukavava bei ima. ");
INSERT INTO gvs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","E aba silali tayamo Yaubada yaina bei Vada Kimaasabaina goi iitáoya, Vadayana ikibaibaili. Moe boi nimatu tokabivalavala Daniyela itaalavaite.’ Kom tokatuyáiva ame ana yagoina kuyagoidokōidi! Yeisu tuwaina kana, ‘Tutayana aba silaliyana kogite Vada Kimaasabaina goi iitáoya, ");
INSERT INTO gvs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","e tuta amo goi avatauwa Yudiya dadavina goi sikaaiyaka, sisīya sina koya goi. ");
INSERT INTO gvs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Avatauwa vada yatana goi sikaaiyaka, taabu sisousōu bego konadi vada sinaena goi sikabidi, go sem sisiyāmo. ");
INSERT INTO gvs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Avatauwa tánuwo goi sikaaiyaka, taabu sikaaluvīla sīna idi kasa bego adi tanigo sikabidi, go sem sisiyāmo. ");
INSERT INTO gvs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","O tokéuwama be tovanunu! Amo tutayana moumou isaki yaidi bego sisiya. ");
INSERT INTO gvs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","E kokawanōi Yaubada yaina bego mouyana geya isowoduwoita nunutula ana tuta goi o Sabati goi, govila bei imi siya goi kokaimúmuna. ");
INSERT INTO gvs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Moitamo. Mou ivakaigaga bei isowóduwo. Nakae poyapoya ina sowóduwo kunu goi go, ima ame tuta geya tayaamo mou nakae. Aiyuwoina mou amo nakae geya tuwaina bei iisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Neta maliyalinayadi Yaubada geya ikatukakupidita, e geya vatau tayaamo ana yava bei ibabane. Go ina kinavayao pasidi moitamo ikatukakupidi. ");
INSERT INTO gvs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","E tuwo avatauwa neta sidigo kadi, “Guyau goame!” o kadi, “Guyau goamo!” e taabu konuumisēdi. ");
INSERT INTO gvs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Moitamo. Guyau polapola be nakae tokabivalavala polapola bei sisowóduwo, aba kinana kainaaopaidi gagaidi siguuinuwedi bei tomota sivasulaaigidi. Go bei sipoikíkina bego Yaubada ina kinavayao nakae sivasulaigidi. ");
INSERT INTO gvs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Konōve. Bogina agimikatumatalimi. ");
INSERT INTO gvs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tauna neta tomota maniyedi silatuwokoimi kadi, “Guyau tautaulu goi ikaaiyaka”, e moe pola, tuwo taabu kononōina. O neta kadi, “Guyau tukunu goi ikaaiyaka”, e moe pola, taabu konuumisēdi. ");
INSERT INTO gvs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Guyauyana ina sowóduwo moe nakae geya. Moitamo. Ávila bogina tayagoi. Ina kávila bomatu ina koiboga ana madabokina itapasigi, e tomota liliudi sigite. E Tomalatomota ina sowóduwo tauna nakae; tomota liliudi bei sigite. ");
INSERT INTO gvs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nakae neta boyoboyo kogitedi sitaligógana, e bogina koyagoi tomata ikaaiyaka. E nakae tutayana aba kinanayadi kogitedi, bei koyagoi giyakainava Tomalatomota ikaluvilamna. ");
INSERT INTO gvs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","E mouyadi adi maliyalina mlidi goi geya mgoninamo ame nakae bei isowóduwo: ");
INSERT INTO gvs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Amo tutayana bei Tomalatomota ina kaluvilamna ana kaba kinana yábana osasaina goi isowóduwo. Go amo tutayana bei boda liliudi poyapoya ame goi madi nuwomou sitáiya. Ago Tomalatomotayana bei sigite yábana geleoina goi imamaima ina togaga be nakae ina tomoéyala gagaina ana káeyana bei ivagitaakoedi. ");
INSERT INTO gvs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Síula bei iuwe, e ina aneroseyao bei ietunedi sina poyapoya ana madabokina goi ina kinavayao sitaligogoidi. ");
INSERT INTO gvs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","E latuwogu livalakaibala ame taniya manuna aba gita tayamo avatulukoimi bei koyagoi. Tutayana taniya laonina bogina silabosúsuwo be vaga vau idugo, e bogina koyagoi kúwana ana tuta bogina ivaakikina. ");
INSERT INTO gvs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Moe tauna komi nakae. Tutayana amo mouyadi liliudi koogitedi, e koyagōi Tauyana totom goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","U, moe bei kooyagoi go, ame alatuuwokoimi konōve: Tomota komi nakae nava bei maa yawoidi tutayana ame dogoiyadi bei sisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yábana be poyapoya bei sitagau go, yau guna livala sikaiyako vata. ");
INSERT INTO gvs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","E Tomalatomota ina kaluvilamna ana tuta manuna konovēgu. Geya vatau tayaamo iyagoi ava maliyalina goi o ava níyala goi bei ima. Kidi anerose da yábana geya siyagoiyeta, e Yaubada Natuna nakae geya iyagoiyeta, go sem Yaubada Tamada anetava iiyagoi. ");
INSERT INTO gvs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Moitamo. Nakonakae boi Nowa ina tuta goi mluwa ina sowóduwo, e Tomalatomotayana ina kaluvilamna moe nakae. ");
INSERT INTO gvs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nowa ana tuta goi nava mluwa geya imaita tomota idi guinuwa siguuinuwedi. Nakae sikakáika be sinimnim be nakae sinainai ana kadókana Nowa mana bodayáuwo sitáoya dedeoga gagaina goi sisowoya ");
INSERT INTO gvs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","go, tomotayadi geya siyagoiyeta mluwa giyakainava bei ima. Tuwo idi sinapu tauna nakae ana kadókana mluwayana bogina ima isamatedi. Tomalatomotayana ina kaluvilamna bei nakae. ");
INSERT INTO gvs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nakae koroto adi taiyuwo tánuwo goi sipaaisewa; tayamo Yaubada ikabi inave go, tayamo ikalave ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vevina adi taiyuwo witi sikauveyetaveta, tayamo Yaubada ikabi inave go, tayamo ikalave ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Tauna koyauyāusa! Geya koyagoiyeta ava maliyalina imi Tomoya bei ikaluvilamna. ");
INSERT INTO gvs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","E ame konuwookavāte: Neta toni vada bogina iyagoi ava tuta sabamgo goi tovaináwana bei ima bego ina vada isiu, e iyauyáusa tovainawanayana isanabode bei ina vada goi geya isiuta. ");
INSERT INTO gvs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ame pasina komi nakae mami katuubayasi koyokabūbuna unana Tomalatomota bei ivatoopemi. Tauna bogina go, mami katubayasi kokaiyāka. ");
INSERT INTO gvs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","E tauna itoboine bei komi tomota paakonina tayamo nakae. Pakoninayana aba numisa be nakae tonanamsa. Tuwo ina tomoya bei ivayoko kina ina pakonayao adi tovakumgo, bei maliyalina tamo tamo tuta ana toboine goi avadi iivinidi sikakáika. Ikavava, tomoyayana ina. ");
INSERT INTO gvs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Niga bei ikaluvilamna ima go, neta amo pakoninayana ibabane iguuinuwe nakae boi bogina ilatuwoko, e ana dedevina bei ibabane. ");
INSERT INTO gvs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","U, ana dedevina bei ibabane go, ame alatuuwokoimi konōve: Tomoyayana ina pákwana bei ivayoko kina konana liliuna adi tomatakavata. ");
INSERT INTO gvs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Go nakona amo pakoninayana goyogoyoina. Bei nuwona goi inuwonúwana kana, “Guna tomoya ikaimúmuna.” ");
INSERT INTO gvs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tuwo ivatowo ina tosavaiyuwo paakonidi nakae iilauidi go, kina ikakáika be inim ginagina oine ana toyaluwoyao taiyao. ");
INSERT INTO gvs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Go pakoninayana ina tomoya ina kaluvilamna geya iyagoiyeta, ava maliyalina o ava tuta bei ima. Tauna bei ivatoope. ");
INSERT INTO gvs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ago tutayana ima, ina pakwanayana bei iboboyuwe go, tauyadi tonumisa polapola adi dadava goi iyato ikaaiyaka. Amoko goi sitaiya vata be nakae saladi sikakaavatedi simatamaimaita.’ ");
INSERT INTO gvs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yeisu tuwaina idigo kana, ‘E tuwo Tomalatomota ina kaluvilamna goi Yaubada ina kalibúbuna ina sowóduwo bei tétala ame nakae: Wowoiyai adi badabada yawou sikaaiyaka. Idi rampa sikabidi, sisowóduwo sina bego tonai koroto sivalobode. ");
INSERT INTO gvs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E wowoiyaiyadi yawou yaidi goi adi tainima yaaluwoidi go, adi tainima tonanamsa. ");
INSERT INTO gvs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Adi tainima yaaluwoidi idi rampa sikabidi go, rampa ana pútuma tuwaina geya sikabiyeta. ");
INSERT INTO gvs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","E kidi go ituli ta woiyai adi tainima tutayana idi rampa sikabidi, e pútuma ma bootoridi taiyao sikabidi simedi. Tauna kidi tonanamsa. ");
INSERT INTO gvs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","E sima tonaiyana situuyaosi go, tauyana ikaimúmuna, tauna simatadududu, e simasisi. ");
INSERT INTO gvs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","E bunatoina goi níyana gagaina sinove iduduwo kana, “Tonai koroto goame! Kosowōduwo kōma tauyana kovalobōde.” ");
INSERT INTO gvs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","E tuwo amo wowoiyaiyadi liliudi sitáoya idi rampa sikatubayasidi. ");
INSERT INTO gvs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","E kidi yaluwoidiyadi geya idi putumamo. Tauna tonanamsa silatuwokoidi sidigo kadi, “Ima rampa sikamakámasa, tauna imi pútuma giyaina kovinīma.” ");
INSERT INTO gvs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Go kidi tonanamsayadi sidigo kadi, “Kai ima pútuma giyaina bogina yoiyama, tauna geya itoboinemeta kavinimi, go sem kōna tokaigimona yaidi toinimi imi pútuma kogimōna.” ");
INSERT INTO gvs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","E tuwo moitamo yaluwoidiyadi sitáoya sina bego idi pútuma sigimona. Sinonoina go, tonaiyana koroto ima, e wowoiyaiyadi bogina sikatuubayasi tonai taiyao sina nai aikanina goi sisiu. Sisiu ikavava, totom sikatunibode. ");
INSERT INTO gvs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","E niga wowoiyai yaluwoidiyadi nakae sima totom goi sidigo kadi, “Tomoya, Tomoya, totom kwatupāeve kasiu!” ");
INSERT INTO gvs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Go kina tonaiyana kana, “Moe latuwomi go, ame alatuuwokoimi konōve: Komi geya ayagoimita.” ");
INSERT INTO gvs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","E tauna matami silala koyauyāusa. Moitamo. Komi geya koyagoiyeta ava maliyalina o ava níyala Tomalatomota bei ima.’ ");
INSERT INTO gvs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Tuwaina Yeisu kana, ‘Moitamo koyāusa. Imi yausayana goi imi sinapu itoboine ame livalakaibalayana nakae: Koroto tayamo latuwona ina ituli ta kasa. Tuwo ina pakonayao iduduwedi sima ina esaesa ivinidi sirugwausidi. ");
INSERT INTO gvs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Sima go, tamo tamo idi toboine goi ina esaesa ikaiguyauyedi bei siepaisewedi. Tayamo moe mani 5,000 ivini. E aiyuwoina moe mani 2,000 ivini. E aitonina moe mani 1,000 ivini. Ikaiguyau ikavava, itáoya ina ituli ta kasa. ");
INSERT INTO gvs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pakoninayana boi mani 5,000 ivinivini ikabidi ina ivaituwedi. Ina vaituwoyana goi mani 5,000 tuwaina ibabanedi. ");
INSERT INTO gvs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pakoninayana boi mani 2,000 ivinivini nakae. Maniyadi ikabidi ina ivaituwedi. Ina vaituwoyana goi mani 2,000 tuwaina ibabanedi. ");
INSERT INTO gvs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","E kina go pakoninayana boi mani 1,000 ivinivini, ikabidi ina poyapoya ieli, e ina tomoya ina maniyadi ivamoudi. ");
INSERT INTO gvs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","E tuta maanawena mlina pakonidiyadi idi tomoya ikaluvilamna ima go, iduduwedi sima ilumadadedi idigo kana, “Guna mani nakonakae kovaituwedi?” ");
INSERT INTO gvs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tuwo pakoninayana boi mani 5,000 iikabidi ibala ima maniyadi 5,000 go, 5,000 tuwaina ivini kana, “Tomoya, boi mainao 5,000 kuvinigu go, kugīte, avaituwedi. Guna vaituwoyana moe 5,000 tuwaina.” ");
INSERT INTO gvs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ina tomoyayana idigo kana, “Dedevina! Kom guna pákwana dedevim be nakae aba numisa. Bogina kuvatulukoigu itoboinegu konagu maniyedi giyaidi goi anumisem. Tauna bei avayokoim kom konagu maniyedi gagaidi adi tomatakavata. Kūma guna kaba uyáwana kusīuko.” ");
INSERT INTO gvs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","E pakoninayana aiyuwoina boi mani 2,000 iikabidi ibala ima idigo kana, “Tomoya, boi mani 2,000 kuvinigu go, kugīte, avaituwedi. Guna vaituwoyana moe 2,000 tuwaina.” ");
INSERT INTO gvs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ina tomoyayana idigo kana, “Dedevina! Kom guna pákwana dedevim be nakae aba numisa. Bogina kuvatulukoigu itoboinegu konagu maniyedi giyaidi goi anumisem. Tauna bei avayokoim kom konagu maniyedi gagaidi adi tomatakavata. Kūma guna kaba uyáwana kusīuko.” ");
INSERT INTO gvs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","E pakoninayana aitonina boi mani 1,000 bogina iikabidi nakae ibala ima idigo kana, “Tomoya, bogina ayagoim bego kom koroto kasakasaim im guinuwa goi. Nakae ituli ta koroto ibágula go, ina dibayoya kom kukabi. Tauna ituli ta tomota idi paisewa goi kom im esaesa kubabane. ");
INSERT INTO gvs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tuwo amatoita im mani bei avatagauye, tuwo ana poyapoya goi im mani avamoudi. Kugīte, im mani goame; avinimneim.” ");
INSERT INTO gvs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Go ina tomoyayana idigo kana, “Kom guna pákwana goyogoyoim be suumoyaim! Kom bogina kuyagoigu bego ituli ta koroto ibágula go, ina dibayoya yau akabi. Tauna ituli ta tomota idi paisewa goi guna esaesa ababane. ");
INSERT INTO gvs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tauna neta boi mainao guna mani kukabi kuna tovaituwo maniyedi kuvinidi, e itoboinedi sivaituwedi. Niga akaluvila ama itoboinegu toinigu guna maniyana be ana vaituwo akabi.” ");
INSERT INTO gvs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","E tomoyayana ina pakonayao maniyedi ilatuwokoidi idigo kana, “Mani 1,000 boi ame tauyana avinivini, e kokabīdi go, guna pakwanayana maana mani 5,000 kovīni. ");
INSERT INTO gvs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Avatauwa neta adi kaiguyau siepaaisewe, e tuwaina bei avinidi. Go avatauwa neta adi kaiguyau geya siepaiseweyeta, e moitamo aiguyauyana bei akuliuye. ");
INSERT INTO gvs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tuwo pakoninayana suumoyaina kokābi kolāve ina moetala mamaníwana goi ikaaiyaka. Amoko goi bei sitaiya vata be nakae saladi sikakaavatedi simatamaimaita.”’ ");
INSERT INTO gvs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tuwaina Yeisu kana, ‘E tutayana Tomalatomota ikaluvilamna ima anerose liliudi taiyao, e ana káeyana tomoeeyalina bei ivagitakoe go, kebana esaaesaina aba taimámina goi bei itusobu ikalibúbuna. ");
INSERT INTO gvs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ago boda liliuna bei ilamgogoidi matana goi itakinoidi boda aiyuwo nakae sipi ana tomatakavata neta sipi be goti itakinoidi boda aiyuwo. ");
INSERT INTO gvs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipiyadi moe wowoina basekoina kakataina goi iyatoidi go, gotiyadi moe kekelina goi iyatoidi. ");
INSERT INTO gvs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","E tuwo tauyadi Tokalibúbuna kakataina goi bei ilatuwokoidi kana, “Komi Tamagu bogina ikaipaakuyemi kōma ina kalibúbuna sinaena goi dogoi dedevidi boi ikatootuledi bei ivinimi. Dogoiyadi boi poyapoya ana kaba vatowo goi bogina ikatubayasidi manumi. ");
INSERT INTO gvs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ame moitamo. Boi loga akámasa go, kovakanigu. Maegu iyápasa go, kovanimgu. Yau ogaoga go, kouyaonegu. ");
INSERT INTO gvs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Apawaku go, kwama kovalosigu. Akatówana go, komatakavategu. Deri goi akaaiyaka go, koma kovadadegu. Tauna komi kōma ina kalibúbuna goi kosīu.” ");
INSERT INTO gvs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","E tuwo kidi tokibóbwata bei sidigo kadi, “Tomoya, ava tuta kagitem loga kwámasa go, kavakanim o maem iyápasa go, kavanimm? ");
INSERT INTO gvs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","E ava tuta kagitem kom ogaoga go, kauyaonem o kupawaku go, kwama kavalosim? ");
INSERT INTO gvs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","E ava tuta kagitem kom kukatówana o deri sinaena goi kwaaiyaka go, kao kavadadem?” ");
INSERT INTO gvs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Go tokalibubunayana bei idigo kana, “U, moe moitamo go, ame alatuuwokoimi konōve: Tutayana moe guinuwayadi koguuinuwedi siyagu tayamo yaina, nakona tauyana nuwotookaina, e moe nakae yau yaigu koguuinuwedi.” ");
INSERT INTO gvs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","E toogoyoidi kekelina goi iiyatoidi bei ilatuwokoidi kana, “Komi Yaubada bogina itakinoimi toogoyoimi. Tauna kosiyaēgu kōna yeu aiyako vaatayaina! Yeuyana Yaubada bogina ikatubayasi Totagíwaya mana aneroseyao manudi. ");
INSERT INTO gvs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Boi loga akámasa go, geya kovakaniguta. Maegu iyápasa go, geya kovanimguta. ");
INSERT INTO gvs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Yau ogaoga go, geya kouyaoneguta. Apawaku go, kwama geya kovalosiguta. Akatówana be nakae deri goi akaaiyaka go, geya komatakavateguta. Tauna kosiyaēgu.” ");
INSERT INTO gvs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Go kidi togoyoidiyadi nakae bei sidigo kadi, “Go Tomoya, ava tuta kagitem loga kwámasa o maem iyápasa o kom ogaoga o kupawaku o kukatówana o deri goi kwaaiyaka go, geya kavaitemta?” ");
INSERT INTO gvs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","E tuwo kina bei idigo kana, “U, moe moitamo go, ame alatuuwokoimi konōve: Tutayana amo guinuwayadi geya koguinuwedita kidi nuwotookaidi yaidi, e moe nakae yau yaigu geya koguinuwedita.” ");
INSERT INTO gvs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Tuwo amo tauyadi bei sina aba liuna vaatayaina goi. Ego kidi tokibobwatayao bei sina yawoidi vaatayaina sibabane.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tutayana Yeisu ina bóbwara madabokina ilukavavedi, kai ina tovatotowanayao ilatuwokoima idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‘Komi bogina koyagoi maliyalina aiyuwo mlidi moe Basitáwana Aikanina ana tuta. Amo tutayana tomota tayamo bei itáoya, Tomalatomota inuwotuluye ana kaleyayao yaidi goi bei kerose goi situpatuko.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E tuwo kidi Tonúwala Gagaidi be nakae Diyuu idi tomoyamoya sima Tonúwala Toolagaina yoina Kaiyapasi ina vada esaaesaina goi situgúguna ");
INSERT INTO gvs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","go, silosinapu bego idi pola goi Yeisu siyoisigau be nakae sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","E sidigo kadi, ‘Go Basitáwana Aikanina sinaena geya tayoisiyeta, govila bei tomota madi egamogamogu sivakaleyeda.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","E kina go Yeisuyana Saimoni ina vada Betani goi ikaaiyaka. Saimoniyana boi tolepero tayamo. ");
INSERT INTO gvs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","E Yeisu ikaaiyaka ikakáika go, vavina tayamo ima pútuma ana maisa gagaina ma bootorina dedevina toina iikavale. Ikavale ima Yeisu dabana goi isiwoi. ");
INSERT INTO gvs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","E kai Yeisu ina tovatotowanayao kakaaiyaka go, vavinayana ina guinuwa kagite, tuwo kaegamogamogu, ametava kama, ‘Manakae pútuma ikavaavaluge! ");
INSERT INTO gvs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Neta putumayana ikaigimone, itoboine maisana gagaina toina ikabi; nakae neta tala tayamo ana paisewa ana maisa. Ikaigimone ikavava, maisana ikabi, tookaidi ivinidi! Go kaga unana tauna nakae geya iguinuweyeta?’ ");
INSERT INTO gvs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Go kina Yeisuyana bogina iyagoi kaga kadigedige, e tuwo idigo kana, ‘Kaga unana vavinayana mou kovinivini? Kokalāve. Ina guinuwa yau yaigu moe guinuwa dedevina toina unana iwowoinegu. ");
INSERT INTO gvs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Kidi tookaidi tuta liliuna sikaaiyaka yaimi itoboinemi kovaitedi. Go yau sem tuta kaakupina bei akaaiyaka yaimi. ");
INSERT INTO gvs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ame moitamo. Vavinayana pútuma ame dabagu goi iisiwoi mana wowoina wowogu ikatubayasi guna valiwoga manuna. ");
INSERT INTO gvs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","U, moe nakae iguinuwe go, ame alatuuwokoimi konōve: Poyapoya ana madabokina goi nako Vala Dedevina ame sitaalavaite, e ina guinuwayana tetelina nakae bei sivateteli go, tauyana sinuwokavate.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E tuwo kai yawou aiyuwo yaima goi tayamo yoina Yudasa guma Keriota go, tuwo itáoya ina Tonúwala Gagaidi yaidi goi ");
INSERT INTO gvs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","idigo kana, ‘Kaga kotagone kovinigu bei Yeisu anuwotuluye yaimi?’ ‘Mani siriba ana badabada 30’, kidi kaedi. Tuwo moitamo Yudasayana itagona, e siribayadi sivini ikabidi. ");
INSERT INTO gvs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tuwo tuta amo goi Yudasa tuta ana toboine iilusale bei Yeisu inuwotuluye. ");
INSERT INTO gvs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E Beredi Pokaka Aikanina ana maliyalina vakuumgoina goi kai tovatotówana kama Yeisu kalumadade kadigo kama, ‘Nako goi latuwom Basitáwana Aikanina kakatubayasi bei takáika?’ ");
INSERT INTO gvs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","‘Kōna Yerusalema goi tayamo koroto bogina alaatuwoko kobabane kolatuwōko kami, “Tovatulúkwana idigo kana, ‘Guna tuta giyakainava bei isowóduwo. Latuwogu im vada goi guna tovatotowanayao taiyao Basitáwana Aikanina kakáika’”’, Yeisu kaena. ");
INSERT INTO gvs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tuwo moitamo kai tovatotówana katáoya kana kaguinuwe nakae Tauyana bogina ilatuwokoima. Ikavava, ama Basitáwana Aikanina kakatubayasi. Kakatubayasi ikavava, kakaluvila kama Tauyana yaina goi. ");
INSERT INTO gvs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","E bogina kenanatau, Yeisu kai yawou aiyuwo taiyao bogina kama katugúguna kakáika. ");
INSERT INTO gvs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Kakakáika go, Tauyana idigo kana, ‘Ame dedevina taiyao takakáika go, ame alatuuwokoimi konōve: Koroto tayamo yaimi goi nava bei inuwotuluyegu.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tuwo kai tamo tamo mama kategeda kabibilágata kadigo kama, ‘Tomoya, nakona yau?’ ");
INSERT INTO gvs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Go Tauyana idigo kana, ‘Kita mada kabivekoveko noko tayamo goi ida beredi tavakuutuidi go, koroto tayamo yaimi goi moe yau agu tonuwotulu. ");
INSERT INTO gvs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tomalatomota bogina inonoina nakae Gínina Kimaasabaina boi bogina igimitalavaite Tauyana manuna. Ego ana tonuwotuluyana ana toovalugo! Neta boi sinana geya ivenatuniyeta!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","E kina go Yudasa, tauyana bei Yeisu inuwotuluye, idigo kana, ‘Tovatulúkwana Toolagaim, geya, nakona yau?’ Tuwo Yeisu idigo kana, ‘Kom bogina kudigoyabe.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","E kakakáika go, Yeisu beredi ikabi, manuna ikauyagu Yaubada yaina. Ikavava, ikivisi, kai ina tovatotowanayao ivinima idigo kana, ‘Moe wowogu nakae. Kokābi kokāni.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tuwo kakabi kakáika. Ikavava, oine ma keeigaina ikabi, manuna ikauyagu Yaubada yaina. Ikavava, keigayana ivinima idigo kana, ‘Oine moe madabokimi konīm. ");
INSERT INTO gvs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Moe ikaikaigu nakae. Ikaikaiguyana bei idaudau komi manumi be nakae tomota liliudi manudi, e bei imi goyo adi nuwotao kobabane. Ikaikaiguyana ina dau goi Yaubada ikanasiukoimi. ");
INSERT INTO gvs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","E ame alatuuwokoimi konōve: Oine ame geya tuwaina bei animnim ana kadókana tutayana Tamagu itagonegu akalibúbuna namliyeta baige komi taiyao oine vau bei tanim.’ Tuwo kakabi kanim. ");
INSERT INTO gvs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kakáika ikavava, Same vesina maniyedi kavesiyedi Yaubada yaina. Kavesi ikavava, kasowóduwo kana Oribe Koyaina goi katuko. ");
INSERT INTO gvs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E tuta amo goi Yeisu ilatuwokoima idigo kana, ‘Komi madabokiimi sabamgo ame imi numisa goi bei kokapusi yau pasigu. Moitamo. Gínina Kimaasabaina goi Yaubada kana, ");
INSERT INTO gvs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Go ámasa goi Yaubada ikaitaoemneigu mlina bei avakumgo ana Galili.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Go kina Pita idigo kana, ‘Nakona madabokidi bei sikapusi kom pasim go, yau geya aakapusi.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Go kina Yeisuyana idigo kana, ‘Moe dedevina neta moitamo go, ame alatuuwokoim kunōve: Ame sabamgoyana goi kom bogina bei sivato kulawoiwoiyekoigu namliyeta kamkam bei itáiya!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Go kina Pitayana idigo kana, ‘Neta akámasa kom taiyao, tuwo akámasa go, geya alawoiwooiyem.’ Ame nakae tovatotówana liliuma kadige. ");
INSERT INTO gvs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","E tuwo Yeisu kai ina tovatotowanayao taiyao kama asa yoina Gedesemane goi go, maniyema ilatuwokoima, idigo kana, ‘Ameko kotusōbu kokaaiyāka go, kai kana dobala, e yau bei akawanoi Yaubada yaina.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Tuwo moitamo katusobu go, Pita be Sebedi natunao adi taiyuwo ikabidi taiyao sina. Sinonoina go, Yeisu nuwona imou be nakae atena igeda. ");
INSERT INTO gvs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","E tuwo adi taito ilatuwokoidi idigo kana, ‘Nuwogu taitáiya iuyoi, nakae bei akámasa. Komi ameko goi kokaaiyāka go, koyauyāusa yau taiyao.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ibóbwara ikavava, ivayavakova ikanakabobo go, ikawanoi Yaubada yaina kana, ‘Tamagu, manakae? Itoboine bego gedageda keigaina ame geya ababaneyeta? Go yau geya guna nuwonúwana geya, go sem kom im nuwonúwana kuguinūwe.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ikawanoi ikavava, ikaluvila ima ina tovatotowanayaoyadi ibabanedi sikanaamatáiya, tuwo iwoinidi. Iwoinidi, e Pita ilatuwoko idigo kana, ‘Manakae? Geya itoboinemta tuta giiyaina goi kuyauyáusa yau taiyao ae?’ ");
INSERT INTO gvs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ago adi taito ilatuwokoidi idigo kana, ‘Koyauyāusa nakae kokaawanōi bego aba vakakona goi geya kokapusita. Balomaimi latuwodi toina go, wowomi sineneta.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sivayuwoina ivayavamna ina ikawanoi idigo kana, ‘Tamagu, neta geya tayaamo enao ikaiyaka bego gedageda keigaina ame akalave, e bokoyo go tuwo im nuwonúwana bei aguinuwe; keigayana anim.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tauyana sivayuwoina ikaluvilamna ima ina tovatotowanayaoyadi ibabanedi sikanaamatáiya. Bogina kuyagoi. Matadi inosedi gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tuwo itáoya ikalavedi, sivatonina ivayava ina ikawanoi nakae maine bogina ikawanoi. ");
INSERT INTO gvs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ikawanoi ikavava, ikaluvila ima ina tovatotowanayaoyadi adi taito ibabanedi sikanaamatáiya. Tuwo iwoinidi go, idigo kana, ‘Manakae? Nava koomasisi be kowaaiwasi ae? Konōve. Tomalatomota ina tuta bogina ima. Ana tonuwotulu bei toogoyoidi nimadi goi iyato. ");
INSERT INTO gvs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Kotāoya tāna. Gwa! Guna tonuwotuluyana bogina imamaima.’ Tuwo moitamo sitáoya go, kai ina tovatotowanayao ainima aito nakae iduduwema kama. ");
INSERT INTO gvs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeisu nava ibobóbwara go, Yudasa isowóduwo ima. Tauyana tovatotówana tayamo kai yawou aiyuwo yaima goi. Isowóduwo go, boda gagaina madi sisi be madi kepati taiyao sima. Bodayadi kidi Tonúwala Gagaidi be Diyuu idi tomoyamoya sietunedi sima. ");
INSERT INTO gvs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ego Yeisu ina tonuwotuluyana aba kinana tayamo bogina ivinidi bei siiyagoi ava koroto moe Yeisu, kana, ‘Avatau neta ayowoi, e amo Tauyana koyōisi.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","E tuwo tauyadi sima go, Yudasayana mainao iseivata ima Yeisu goi idigo kana, ‘Tovatulúkwana Toolagaim, uyagu!’ Ikavava, iyowoi. ");
INSERT INTO gvs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","E kina go Yeisu idigo kana, ‘Naveya, moe pasina kuma ae?’ Tuwo bodayadi sibala sima Tauyana siyoisi. ");
INSERT INTO gvs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ago koroto tayamo kai Yeisu ina bodao yaima goi ina sisi ibuyagi, ibala ina Tonúwala Toolagaina ina pákwana taiyana ivakanáupe. ");
INSERT INTO gvs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tuwo Yeisu ibóbwara, korotoyana ilatuwoko idigo kana, ‘Im sisi kebana goi kuvaisiumnēi! Avatauwa neta giya sisi goi sivalauláuwo, e sisiyana goi bei sivailai. ");
INSERT INTO gvs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Manakae? Geya kuyagoiyeta neta latuwogu, itoboinegu Tamagu yaina goi akawanoi makimaki bei mainao aivina tausani anerose ietunedi sima sivaitegu? ");
INSERT INTO gvs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Neta nakae aguinuwe, e Gínina Kimaasabaidi adi talavaita manugu manakaedi simalatomota? Geya. Tauna nakae geya aguinuweyeta.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Go tuta amo goi bodayadi Yeisu ilatuwokoidi idigo kana, ‘Manakae? Yau bego tokapipilova tayamo, tauna komi mami sisi be mami kepati koma koyoisigu? Maliyalina tamo tamo Vada Kimaasabaina goi atusobu avaatulúkwana go, geya koyoisiguta. ");
INSERT INTO gvs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Go ame dogoiyadi madabokidi sisowóduwo bego Yaubada ina tokabivalavalayao idi Gínina Kimaasabaidi simalatomotamna.’ E tuwo kai Yeisu ina tovatotowanayao liliuma Tauyana kakalave go, kasiya. ");
INSERT INTO gvs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","E kidi go bodayadi Yeisu siyoisi, sinave Tonúwala Toolagaina Kaiyapasi ina vada goi. Amoko goi Yaubada ina Katukeda ana tovatulukwanayao be nakae Diyuu idi tomoyamoya bogina sigugúguna. ");
INSERT INTO gvs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","E kina go Pita tupwana masigava goi Yeisu isabookuliye, e ina Tonúwala Tolagainayana ina vada ana kali goi isiu itusobu Vada Kimaasabaina ana polisi taiyao bego igite kaga iisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","E kidi go Tonúwala Gagaidi be nakae Diyuu adi kotu ana tolovinao liliudi vadayana sinaena sikaaiyaka Yeisu ana totalavaita polapola siluusaledi bego sitakino kina toogoyoina bei sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Totalavaita polapola badabadaidi moitamo sima sitalavaita polapola go, idi talavaitayadi goi geya tayaamo itoboine bei Yeisu sikaumate. Nakae nakae siguuinuwe, e totalavaita polapola adi taiyuwo sima ");
INSERT INTO gvs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","sidigo kadi, ‘Ame Tauyana kanove idigo kana, “Itoboinegu Yaubada ina Vada Kimaasabaina atauwe go, maliyalina aito mlidi goi ayowomnei.”’ ");
INSERT INTO gvs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sitalavaita ikavava go, kina Tonúwala Toolagaina itáoya Yeisu ilatuwoko idigo kana, ‘Manakae kom im katumapu? Ame kaga manuna tauyadi sitalavaaitem?’ ");
INSERT INTO gvs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","E kina go Yeisuyana iitugau. Kina go Tonúwala Tolagainayana idigo kana, ‘Yaubada maa yawoina yoina goi alovinaem: Kubōbwara moitamo. Neta kom moitamo Guyau, Yaubada Natuna, kulatuwokōima!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Kina Yeisuyana idigo kana, ‘Kom bogina kudigoyabe. Go ame alatuuwokoimi konōve: Tuta imamaima Tomalatomota bei kogite mana lovina wowoina basekoina Tokalika kakataina goi iitusobu be nakae yábana geleoina yatadi goi imamaima.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","E tuwo kina go Tonúwala Tolagainayana ana kwama ikiise giyaina go, idigo kana, ‘Tauyana idigopopóita! Kaga ana dedevina totalavaita tuwaina taalusala? Geya! Ame tuta ina digopopoitayana toinimi bogina konove! ");
INSERT INTO gvs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Komi manakaemi koolovina?’ E tauyadi sidigo kadi, ‘Moitamo Tauyana ibágala. Itoboine ikámasa!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E tuwo matana sisikobode go, maisina sigiwoli be nakae sipwaiki. E maniyedi maisina sisapi ");
INSERT INTO gvs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","go, sidigo kadi, ‘Yo Guyau! Kom bego Yaubada ina tokabivalavala, tuwo kulatuwokōima avatau iilauim!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","E kina go Pitayana Tonúwala Toolagaina ina vada ana kali sinaena goi iitusobu go, Tonúwala Toolagainayana ina pákwana woiyaina tayamo ima Pitayana igite, idigo kana, ‘Kom woi Yeisu guma Galili ina tosabokuli tayamo.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","E kina go Pita ilawoiwoi idigo kana, ‘Moe kaga kudigedige yau geya ayagoiyeta!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","E ibala ina aliyana ana kaba siu goi ikaaiyaka. Ikaaiyaka go, ituli ta vavina paakonina ikandobala Pita igite, tomota amoko goi sikaaiyaka ilatuwokoidi idigo kana, ‘Ame tauyana Yeisu guma Nasareta ina tosabokuli tayamo.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita sivayuwoina ilawoiwoimna go, ikanatamada idigo kana, ‘Iyagoida! Korotoyana geya ayagoiyeta geya!’ ");
INSERT INTO gvs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","E tuta giyaina toyoko sibala sima Pita silatuwoko sidigo kadi, ‘Kom woi Yeisu ina tosabokuli tayamo. Moitamo. Niyam ana taiyakeka kakinane. Kom guma Galili.’ ");
INSERT INTO gvs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E tuwo Pita ibibilágata ikanatamada idigo kana, ‘Iyagoida! Neta apola, Yaubada itoboine ilauigu. Amo korotoyana kodigedige yau geya ayagoiyeta geya!’ E mainao kamkam itáiya. ");
INSERT INTO gvs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tuwo Pitayana Yeisu ina livala inuwopeye boi idigo kana, ‘Namliyeta kamkam itáiya, e kom bogina bei sivato kulawoiwoiyekoigu.’ Tuwo vadayana ina kali goi isowóduwo ina moetala goi itáiya gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","E nobuyana nava matagougouna kidi Tonúwala Gagaidi be nakae Diyuu idi tomoyamoya liliudi situgúguna go, silosinapu bei Yeisu sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Silosinapu ikavava, Yeisu nimana siyowóidi, sinave gávana Pailato nimana goi siyato. ");
INSERT INTO gvs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","E tuta amo goi Yeisu ana tonuwotulu Yudasa inove Yeisu bogina sitakino bego ikámasa, e itugavila ivakúwana, tuwo siribayadi 30 ikabidi, ina Tonúwala Gagaidi be Diyuu idi tomoyamoya yaidi goi bego ivinimneidi ");
INSERT INTO gvs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","idigo kana, ‘Koroto tutubeso anuwotuluye, tauna bogina agoyo.’ E kidi kadi, ‘Im goyo moe geya kai ima puwoya geya. Moe kom im polava.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tuwo siribayadi ilavedi Vada Kimaasabaina ina kali sinaena. Ikavava, isowóduwo ina yowoyówana ikabi, ina alova laonina goi isiko. Ikavava, nukotona goi isiko ilosuyae ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","E kidi go Tonúwala Gagaidi siribayadi sikabidi go, sidigo kadi, ‘Ame ámasa maisana, tauna geya itoboineyeta vininabeso dedeogaina goi tadodoidi.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","E silosinapu ikavava, silovina bei siribayadi goi vaega ana tomolúluwo ina poyapoya sigimone bego ogaoga adi valiwoga. ");
INSERT INTO gvs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tauna amo poyapoyayana tomota sivayou ikaika poyapoyaina, e ame tuta nakae. ");
INSERT INTO gvs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Tuwo Yaubada ina tokabivalavala Yeremaya ina livala moeko goi imalatomota. Tauyana idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ago moe maniyadi sikabidi, ");
INSERT INTO gvs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","E Yeisu sime gávana Pailato matana goi sivatáoe go, gavanayana Yeisu ilumadade idigo kana, ‘Kom moitamo Diyuu adi tokalibúbuna?’ ‘Kom bogina kudigoyabe’, Yeisu kaena. ");
INSERT INTO gvs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tonúwala Gagaidi be nakae tomoyamoya siiwowoko go, geya ikatumapudita. ");
INSERT INTO gvs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","E Pailato idigo kana, ‘Manakae? Idi wowókana badabadaidi kunovedi gea geya? Kaga unana kuutugau?’ ");
INSERT INTO gvs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ago kina geya kada tayaamo idi wowókana ikatumapu geya, tauna gavanayana ikainaopa gagaina. ");
INSERT INTO gvs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ego Basitáwana Aikanina ana tuta gavanayana ina sinapu ame nakae: Neta koroto tayamo deri ana tokaiyaka go, tomota latuwodi, e Pailato italigei ivinidi. ");
INSERT INTO gvs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E amo tutayana yoowonina tayamo valena gagaina deri goi ikaaiyaka yoina Yeisu Barabasi. ");
INSERT INTO gvs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","E moe Pailato ina sinapu, tuwo tutayana boda sima bogina situgúguna, Pailato ilatuwokoidi idigo kana, ‘Avatau latuwomi ataligei manumi? Yeisu Barabasi gea Yeisu, Tauyana tomota siivayou Guyau?’ ");
INSERT INTO gvs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailatoyana bogina iyagoi kidi Tonúwala Gagaidi Yeisu sime nimana goi siyato kotu manuna unana Tauyana sivakipikipiye. ");
INSERT INTO gvs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","E Pailato aba takínona ana kaba tusobu goi iitusobu go, monena livala tayamo ietune ima idigo kana, ‘Moe korotoyana tokibóbwata, e kwalāve. Geya tayaamo kaga kuguinūwe yaina. Nuwobuna Tauyana akanamimiye go, guna kanamimiyana aba matoita gagaina yaigu.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","E kidi go Tonúwala Gagaidiyadi be nakae tomoyamoyayadi boda sisiukoidi, nuwodi sitalaidi kadi, ‘Kokawanōi bego Barabasi italigei go, Yeisu ikaumate.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","E kina gavanayana ilatuwokoidi idigo kana, ‘Ame adi taiyuwo yaidi goi ava koroto latuwomi ataligei manumi?’ ‘Barabasi!’ tomota kaedi. ");
INSERT INTO gvs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Go kina Pailatoyana idigo kana, ‘Neta nakae, e Yeisu, Tauyana tomota siivayou Guyau, bei kaga avaiko?’ Madabokidi sidigo kadi, ‘Kerose goi kutupatūko!’ ");
INSERT INTO gvs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","‘Ava goyo iguinuwe bei itoboine ikámasa?’ tauyana kaena. ‘Kerose goi kutupatūko!’ bodayadi tuwaina kaedi. ");
INSERT INTO gvs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","E Pailato bogina igite geya itoboineyeta ikaugeogéona Yeisu ina talígava manuna, go sem bodayadi giyakainava bei sivalauláuwo. Tuwo bwae ikabi bodayadi matadi goi nimana inikidi idigo kana, ‘Ame Tauyana ikaikaina moe yau geya guna puwoya geya. Yau nimagu bogina anikidi. Tauna Tauyana yawoina moe komi imi polava.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tuwo boda madabokidi sidigo kadi, ‘Tauyana ikaikaina kai nimama goi be nakae natumao nimadi goi bei ikaaiyaka.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E tuwo kina Pailato ina tovayaviyayao ilovinaedi Barabasi sitaligei bodayadi sivinidi. Ikavava, ina tovayaviyayao maniyedi ilatuwokoidi idigo kana, ‘Yeisu kokābi, kodābi. Ikavava, konāve bei kerose goi kotupatūko.’ Tuwo moitamo Tauyana sikabi sidabi. ");
INSERT INTO gvs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Amo tutayana gávana Pailato ina tovayaviyayao sina Yeisu sikabi sinave Erodi ina vada esaaesaina ana kali goi sisiuye. Amoko goi sediyao tovayaviya liliudi siduduwedi sima Tauyana sitaoyakobu. ");
INSERT INTO gvs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sitaoyakobu, ana kwama sivalilivi. Ikavava, tolovina ana kwama dedevina go, kayakayaina sikabi sivalosi. ");
INSERT INTO gvs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sivalosi ikavava, tolovina ana pasapasa polapola sivapase ame nakae: Taliboibo sikabi dabayogigi polapola simete, dabana goi sikailagasi. Aiyuwoina duriduri tayamo sikabi ina kaituko nimakakataina goi siyato go, aedi sivatugúyala matana goi madi kaiwoteta sidigo kadi, ‘Diyuu adi tokalibúbuna takiilagāsi!’ ");
INSERT INTO gvs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ikavava, maisina sigiwoli. Sigiwoli ikavava, duriduriyana sikabi, dabana siláui. ");
INSERT INTO gvs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Sikaiwotete ikavava, kwamayana sivalilivi go, toinina ana kwama sivalosimnei, sinave bei kerose goi situpatuko. ");
INSERT INTO gvs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","E sinavenave go, enao goi koroto tayamo guma Sairini sibabane yoina Saimoni. Moe tauyana silovinae bego Yeisu ina kerose ikavale. ");
INSERT INTO gvs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ikavale, sima asa tayamo yoina Gorigota (moe ana yagoina Bulubulu ina Kasa). ");
INSERT INTO gvs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Amoko goi oine be alova tamatamaina sipopolidi Yeisu sivanim geda manuna go, inimkone, ikatae. ");
INSERT INTO gvs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","E Tauyana ana kwama sivalilivi ikavava, kerose goi situpatuko namliyeta baige keroseyana sivatáoe. Ikavava ana kwama, ana sendoro, ana gadíwana sikabidi, pápala tayamo siguinuwe bei sigite avatauwa sikabidi. ");
INSERT INTO gvs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ikavava, situsobu go, Tauyana simataakavate. ");
INSERT INTO gvs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Go ana píkwana aisika paaevaina tayamo goi sigini, dabana diligaemaina goi situpatuko. Ana pikwanayana kana, ‘Ame Yeisu, Diyuu adi Tokalibúbuna.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Amo tutayana tokapipilova adi taiyuwo Yeisu taiyao nakae adi kerose goi situpatukoidi, tayamo kakataina go, tayamo kekelina. ");
INSERT INTO gvs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","E kidi go tomota maniyedi enao goi siiketoiya Tauyana sitagiwoi. Nakae dabadi sikatugegéwana be nakae sikaoseve ");
INSERT INTO gvs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","sidigo kadi, ‘Kom Tauyam bego Vada Kimaasabaina kutauwe go, maliyalina aito mlidi kuyowomnei, neta kom Yaubada Natuna, e kerose goi kusōu kūma toinim kuyavēm.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao be nakae Diyuu idi tomoyamoya nakae sikaoseve ");
INSERT INTO gvs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","sidigo kadi, ‘Bego ituli ta tomota iyavedi go, geya itoboineyeta toinina iyave. Tauyana bego kita Isileli tubunao ida Tokalibúbuna, tuwo ame tuta kerose goi isōu īma bei tanumise. ");
INSERT INTO gvs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tauyana bego inumisa Yaubada yaina, tuwo neta Yaubada moitamo iuyaone, e ame tuta iyave. Moitamo. Boi idigodigo bego kina Yaubada Natuna.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tokapipilovayadi bogina tupaatukoidi Yeisu taiyao nakae sikaaoseve. ");
INSERT INTO gvs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","E bogina dine, asa madabokina ikamamaníwana go, amamaniwanayana ikaaiyaka ana kadókana lavilavi. ");
INSERT INTO gvs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","E asa lavilavi nakae, Yeisu niyana gagaina goi iduduwo idigo kana, ‘Eli Eli lama sabakatani?’ Moe ana yagoina kada, ‘Guna Yaubada, guna Yaubada, kaga unana kwalavegu?’ ");
INSERT INTO gvs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","E toyoko maniyedi amoko goi sinove go, sitainasi, tuwo sidigo kadi, ‘Mae Tauyana Eliyau iiduduwe.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tuwo mainao koroto tayamo itáoya ilokoina ina toutou ikabi, e oine bwaena yuyuyuna goi isavaibute. Ikavava, duriduri ikabi, isisiwo go, ikailagasi bego Yeisu ivanim. ");
INSERT INTO gvs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","E korotoyana senao sidigo kadi, ‘Tauyana takalāve go, tagitegīte. Nakona Eliyau bei ima iyave.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","E kina go Yeisu niyana gagaina goi aiyuwoina iduduwomna, e yawoina ikavava. ");
INSERT INTO gvs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ago geya mgoninamo Tukunu Kimaasabaina Toina ana vabodaupa kaarekoina ikiiseyuwe, dolagaema isou ina ditonema. Aiyuwoina poyapoya iiku be nakae gurewa itavisidi. ");
INSERT INTO gvs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Go valiwoga tukubu ikatupaevedi be nakae kidi Yaubada ina kimasabayao badabadaidi boi bogina sikámasa, e ikaitaoedi. ");
INSERT INTO gvs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ago Yeisu ina taoyamna mlina tukubuyadi goi sisowóduwo sina asa kimaasabaina goi sisiu, e sivagitakoedi tomota badabadaidi yaidi. ");
INSERT INTO gvs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","E kina go tovayaviya adi tovakumgo taiyao sikaaiyaka Yeisu simataakavate go, nikuniku be nakae kaga liliuna sisowóduwo sigitedi, tuwo sikainaopa gagaina kadi, ‘Moitamo, ame Tauyana Yaubada Natuna.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Ego boi vevina badabadaidi Galili goi Yeisu sisabookuliye be nakae sivavaite. Vevinayadi moe Meri guma Magidara be ana ebígana moe Yemesa be Iyosepa sinadi be nakae Sebedi natunao sinadi. E ame vevinayadi kerose go, tupwana masigava goi siitáoya sigite kaga liliuna siisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","E bogina lavilavi toina go, koroto tayamo toesaesa guma Arimateya yoina Iyosepa ima. Tauyana nakae Yeisu ina tovatotówana tayamo. ");
INSERT INTO gvs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Moe tauyana ina Pailato yaina ikawanoi idigo kana, ‘Manakae? Kutagona Yeisu wowona akabi avaliwoge gea geya?’ Tuwo moitamo Pailato itagona go, ina tovayaviyayao ilovinaedi idigo kana, ‘Kōna Tauyana wowona kokābi go, ame korotoyana kovīni.’ Tuwo sina Yeisu wowonayana sikabi sime Iyosepayana sivini. ");
INSERT INTO gvs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Sivini, e Iyosepayana ma senao sikabi go, areko maavadaina sikabi, siutube. ");
INSERT INTO gvs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Siutube ikavava, sinave Iyosepa ina valiwoga tukubu vau goi sisiu siyato. Tukubuyana boi gurewa itavi. E Yeisu wowonayana siyato ikavava, sisowóduwo go, gurewa gagaina gumogumoina sipuli tukubuyana tobuna sikaubode. Ikavava, sitáoya sina. ");
INSERT INTO gvs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ego amoko goi Meri guma Magidara mana ebígana tukubuyana tubalakoina goi siitusobu Iyosepa sigitegite. ");
INSERT INTO gvs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Amo maliyalinayana moe Basitáwana Aikanina ana katubayásina ana maliyalina. E vanuwo itomo kidi Tonúwala Gagaidi be nakae Parisi sina Pailato taiyao situgúguna ");
INSERT INTO gvs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","sidigo kadi, ‘Tomoya, kai kanuwopeye boi amo topolayana nava maa yawoina idigo kana, “Maliyalina aito sikavava, e ámasa goi Yaubada bei ikaitaoegu.” ");
INSERT INTO gvs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tauna im tovayaviyayao kulovinaēdi sina Tauyana ina valiwoga tukubu sivabodebode be nakae simatakavatedoko ana kadókana maliyalina aitonina goi, govila bei ina tovatotowanayao sina wowona sivainao, e tomota silatuwokoidi kadi, “Yaubada tokámasa yaidi goi bogina ikaitáoe.” Moeko goi pola vakuumgoina igoyo go, ame polayana vaamliyaina igoyo toina.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Kina Pailatoyana idigo kana, ‘Tovayaviya bei avinimi. Kokabīdi kōna go, nakonakae itoboinemi, e tukubuyana kovabodebōde.’ ");
INSERT INTO gvs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","E tuwo moitamo sina tukubuyana sivabodebode go, idi vabodabodayana ame nakae: Mainao gurewa tukubu tobuna goi giyaina sibwade, e bei siyagoi neta tomota tayamo ikatupáeve. Aiyuwoina tukubuyana tovayaviya sikaaiyaka simatakavatedoko. ");
INSERT INTO gvs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","E Sabati mlina wiki ana maliyalina vakuumgoina goi nobuyana nava matagougouna go, Meri guma Magidara mana ebígana sitáoya sina bego Yeisu ana valiwoga tukubu sivadade. ");
INSERT INTO gvs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Sima go, matabuwona nikuniku gagaina itátava. Bogina kuyagoi. Yauwe ina anerose yábana goi bogina isou ina tukubuyana ana kauboda gurewa ipuli. Ikavava, gurewayana yatana goi itulaga, ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ego aneroseyana ana kaigigita inamanámala ávila nakae go, ana kwama poowouna toina. ");
INSERT INTO gvs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","E tukubu ana tomatakavatayao sikaaiyaka aneroseyana sigite, tuwo simatoita. Idi matoitayana pasina simalitatátava go, matadi siginigini isouyedi poyapoya goi tokámasa nakae. ");
INSERT INTO gvs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","E vevinayadi adi taiyuwo sina tukubu goi, e aneroseyana ilatuwokoidi idigo kana, ‘Taabu koomatōita! Bogina ayagoi Yeisu tupaatukoina koolusale. ");
INSERT INTO gvs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tauyana ameko geya. Moitamo. Yaubada ámasa goi bogina ikaitáoe nakae boi Yeisuyana idige. Kōma tukubu goi kosīu ina kaba yata kogīte daakakaina. ");
INSERT INTO gvs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Kogite ikavava, woilīmi kōna ina tovatotowanayao kolatuwokōidi kami, “Yaubada Yeisu tokámasa yaidi goi bogina ikaitáoe. Go konōve! Tauyana bei ivakumgo ina Galili namliyeta baige komi kōna amoko goi bei kogite.” Konōve, bogina alatuwokoimi.’ ");
INSERT INTO gvs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Tuwo moitamo Yeisu ana kaba yata sigite ikavava, tukubu goi woilidi silokoináoduwo, madi matoita be madi uyáwana gagaina sima kai Yeisu ina tovatotowanayao yaima goi sitalavaita. ");
INSERT INTO gvs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Simamaima go, Yeisu ivalobodedi kana, ‘Yaubada ina tuboina yaimi!’ E sibala sima sivatugúyala aena siyoisidi go, yaina goi sisakululu. ");
INSERT INTO gvs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","E tuwo Tauyana idigo kana, ‘Taabu koomatōita. Kotāoya kōna segowo kolatuwokōidi bego sina Galili goi. Amoko goi bei sigitegu.’ ");
INSERT INTO gvs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","E tauyadi simamaima go, kidi tukubuyana ana tomatakavatayao maniyedi sina Yerusalema goi. Kaga liliuna siisowóduwo, e Tonúwala Gagaidi yaidi goi sitalavaitedi. ");
INSERT INTO gvs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ago Tonuwalayadi sinove, tuwo Diyuu idi tomoyamoya siduduwedi situgúguna taiyao silosinapu. Ikavava, mani siriba gagaina sikabidi tomatakavatayadi sivinidi ");
INSERT INTO gvs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","silatuwokoidi sidigo kadi, ‘Kotalavāita kami, “Sabamgo goi kaamasisi go, Tauyana ina tovatotowanayao sima tukubu goi wowona sivainao.” ");
INSERT INTO gvs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ago ame valayana neta gávana inove, kai bei nukotona katalai, e bei tauyana ina liuna geya kobabaneyeta.’ ");
INSERT INTO gvs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","E tuwo moitamo siribayadi sikabidi, sina siguinuwe nakae Tonuwalayadi sidige. Ame tetalayana inúnuwo Diyuu yaidi goi go, ame tuta nakae. ");
INSERT INTO gvs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","E vevinayadi bogina sima, kai tovatotowanayama yawou tayamo Yeisu ina livala silatuwokoima. Ikavava, katáoya kana Galili goi. Amoko goi koya tayamo katuko nakae boi Yeisu ilatuuwokoima. ");
INSERT INTO gvs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Katuko kana koyayana goi, e Yeisu kagite, tuwo kasakululu Tauyana yaina go, maniyema kananayuwo. ");
INSERT INTO gvs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ago Yeisu ibala ima ilatuwokoima idigo kana, ‘Lovina madabokina yábana goi be nakae poyapoya goi Yaubada Tamada bogina ivadamane yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tauna kotāoya kōna asa liliudi goi tomota kotakutūdi simalatovatotówana namliyeta baige Tamada be Natuna be nakae Baloma Kimaasabaina yoina goi kosayoyōidi. ");
INSERT INTO gvs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Lovina liliuna bogina avinimi kovatulukōidi sikabikaonedi. Go konōve. Yau komi taiyao tuta liliuna, ame tuta go, nakae tuta ana kaba lukavava.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Vala Dedevina ame Yeisu Guyau, Tauyana Yaubada Natuna, valena ana kaba vatowo. Ana kaba vatowoyana ame nakae: ");
INSERT INTO gvs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Boi nimatu Yaubada ina tokabivalavala Aiseya ina buki igini, e Tauyana ina livala Guyau manuna italavaite, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Toduduwo niyana gagaina yoyowo goi iiduduwo kana, ");
INSERT INTO gvs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nakae Aiseya ina talavaitayana, e Iyoni tosayóyova ina yoyowo goi tomota yaidi itaalavaita idigo kana, ‘Imi goyo goi kotugavīla namliyeta bei asayoyoimi, e bei Yaubada imi goyo inuwotaoidi.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Itaalavaita go, boda gagaina Yudiya ana dadava madabokina goi be nakae da Yerusalema madabokidi sima tauyana sitaiyakeke go, idi goyo sitalavaitedi namliyeta bwae sákala Iyoridani goi isayoyoidi. ");
INSERT INTO gvs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iyoniyana ana kwama moe Yaubada ina tokabivalavala ana kwama nakae tuta liliuna ilosilosi. Ana kwamayadi kameri unuununa goi siwodugudi. Ana gadíwana tolobona goi moe yoguyogu sakavaina. Ago tatabole be mokava ikakáika. ");
INSERT INTO gvs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E tauyana itaalavaita, idigo kana, ‘Tauyana mligu goi imamaima itobukukuyuigu; nakae geya itoboineguta bei asakululu ana sendoro ana búyala ataligei unana yau sobuyekoina. ");
INSERT INTO gvs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yau bwae goi bogina asayoyoimi go, Tauyana Baloma Kimaasabaina goi bei isayoyoimi.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Moe nakae Iyoni ina katubayásina Yeisu ina sowóduwo manuna. Amo lavayana Yeisu itáoya Galili asaina Nasareta goi ina sákala Iyoridani goi. Iyoniyana nava tomota isaayoyoidi, tuwo Yeisu isayoyoi. ");
INSERT INTO gvs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Isayoyoi ikavava, bwae goi isinalaga, e mainao ikandolaga igite yábana sekulapeyaina Yaubada ikiise go, Baloma Kimaasabaina bunabuna nakae isou imamaima Yeisuyana yaina goi. ");
INSERT INTO gvs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ago aníyana tayamo yábana goi itumasobu kana, ‘Kom Natugu guna kakaya, auyaonedokoim.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","E Baloma Kimaasabaina Yeisu ietune ina yoyowo goi. ");
INSERT INTO gvs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Amoko goi maliyalina 40 ikaaiyaka. Amo tutayana kina Kaleya ima Yeisu ivakakone. Ego Yeisu ikaaiyaka yoguyogu sasasaidi taiyao go, anerose sima simataakavate. ");
INSERT INTO gvs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","E gávana Erodi ilovina Iyoni siyoisi deri goi sivaisiu. Iyoni ana yoitayana mlina kina Yeisu itáoya ina Galili ana dadava goi Yaubada Valena Dedevina itaalavaite, ");
INSERT INTO gvs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","idigo kana, ‘Tuta Yaubada boi iupeupe bogina isowóduwo, e ina kalibúbuna bogina imaiyaba bei itoboinemi kosiu. Kotugavīla be Vala Dedevina konumīse.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yeisu Galili Bwaena labutabutaina goi iivayali go, Saimoni maa siyana Anduru igitedi idi úwata bwae goi silavelave. Bogina kuyagoi. Adi taiyuwokova tóuwata. ");
INSERT INTO gvs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","E igitedi, ilatuwokoidi idigo kana, ‘Kōma kosabokuliyēgu bei avayokoimi tomota adi touwatayao.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","E tuwo moitamo kidi mainao sitáoya, idi úwata sikalave go, Yeisu sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tauyadi giyaina sivayalikova go, Yeisu ikandobala Sebedi ma natunao Yemesa be Iyoni igitedi, oga goi sikaaiyaka idi úwata siyaanumedi. ");
INSERT INTO gvs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E igitedi, iduduwedi idigo kana, ‘Komi kōma kosiukōigu.’ Tuwo moitamo kidi mainao sitáoya, tamadi Sebedi mana topaisewayao kiveko oga goi sikalavedi go, sima Tauyana sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yeisu mana tovatotowanayao siketoiya sina Kapaneumi goi sisiu sikaaiyaka. E Sabati sina Diyuu idi kaba tugúguna goi sisiu go, Yeisu ivaatulúkwana. ");
INSERT INTO gvs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ina vatulukwanayana pasina boda sikainaopa, kadi, ‘Tauyana ina vatulúkwana geya kada kidi Yaubada ina Katukeda ana tovatulukwanayao nakae geya, go sem mana lovina ivaatulúkwana.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","E idi kaba tugugunayana goi koroto tayamo naagovaina ikaaiyaka. Korotoyana iduduwo idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","‘Yeisu guma Nasareta, yau guna polava moe geya kom im polava. Manakae? Kuma bei kai kumtulima ae? Kom taum bogina ayagoim. Kom Totumasaba, Yaubada goi kuma.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Go kina Yeisuyana ibove, idigo kana, ‘Tuwo! Kumaigāumo go, koroto yaina goi kusowōduwo!’ ");
INSERT INTO gvs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tuwo dimoniyana koroto ikinagove itátava go, mana podeda gagaina korotoyana yaina goi isowóduwo ina. ");
INSERT INTO gvs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tomota madabokidi sikainaopa, tauna taudiva silumadadedi, sidigo kadi, ‘Iyaa, ame manakae? Vatulukwana vau mana lovina! Dimoni nakae ilovinaedi go, Tauyana sopana sikabiikaone!’ ");
INSERT INTO gvs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tuwo Tauyana valena isagayako ina asa liliudi Galili ana dadava goi. ");
INSERT INTO gvs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","E Yeisu itáoya aba tugugunayana goi isowóduwo go, Yemesa be Iyoni taiyao sina Saimoni be Anduru idi vada goi sisiu. ");
INSERT INTO gvs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ego Saimoniyana yaona (moe monena sinana) manaa katówana iimasisi. E vavinayana manuna Yeisu silatuwoko. ");
INSERT INTO gvs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Tuwo ibala ina vavinayana nimana iyoisi ibutáoe. Ibutáoe, ina katowanayana ikalave. Ikavava, itáoya ina avadi ivaideda. ");
INSERT INTO gvs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","E asa bogina lavilavi, tutayana níyala iisaliu, toni kasa idi tokatówana be nakae tomota naagovaidi, e liliudi simedi Yeisu yaina. ");
INSERT INTO gvs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tuwo asa ana tokaiyakayao madabokiidi sima vadayana totomna goi siitáoya. ");
INSERT INTO gvs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tokatówana badabadaidi be tauyadi naagovaidi badabadaidi Yeisu ikidedevinedi. Ago dimoniyadi Yeisu bogina siyagoi, tauna geya itagonedita sibóbwara. ");
INSERT INTO gvs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","E botomotomo toina Yeisu itáoya vada goi isowóduwo go, aneta ina yoyowo goi ikaawanoi Yaubada yaina. ");
INSERT INTO gvs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ikaawanoi go, Saimoni senao taiyao sina Tauyana silusale makimaki. ");
INSERT INTO gvs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Silusale, sibabane, silatuwoko sidigo kadi, ‘Iyaa! Tomota madabokidi siluusalem, latuwodi kom.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Go Yeisuyana idigo kana, ‘Tāna asa maniyena bego amoko goi nakae Vala Dedevina atalavaite tomota yaidi. Moe pasina tauna ama.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tuwo moitamo ina Galili ana madabokina goi ivanibiníbita go, Valayana Diyuu idi kaba tugúguna tamo tamo goi itaalavaite be nakae dimoni ivataapiyedi. ");
INSERT INTO gvs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tuta tayamo tolepero tayamo ima Yeisu yaina goi aena ivatugúyala, ikawanoi makimaki idigo kana, ‘Neta im nuwonúwana nakae, itoboinem kukidedevinegu bei sakavaigu imavada.’ ");
INSERT INTO gvs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tuwo mana nuwokapisi nimana iyosale toleperoyana ibisikone idigo kana, ‘Guna nuwonúwana nakae. Kumavāda!’ ");
INSERT INTO gvs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tuwo mainao korotoyana sakavaina ina lepero ikavava, e sakavainayana imavada. ");
INSERT INTO gvs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","E korotoyana ikatumatali makimaki idigo kana, ‘Kunōve! Am kimavadayana manuna geya vatau tayaamo kulaatuwōko, go sem kūna Tonúwala yaina goi kuvagitakōim igitem bei ivayokoim kom bogina kumavada. Ikavava, im vininabeso yoguyogu kukasāle Yaubada yaina ada lovina boi Mosese iivinida tolepero adi kimavada manuna nakae. Moe aba kinana tomota yaidi sakavaim bogina imavada, e bei siuyaonemneim.’ Ikatumatali ikavava, ilatuwoko ina. ");
INSERT INTO gvs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","E kina go korotoyana ina Tonúwala yaina iguinuwe nakae Yeisu ilatuwoko go, Yeisu ina sanaboda geya ikabikaoneyeta, go sem ina tomota yaidi ivatowo Yeisu ina guinuwa tetelina italavaite. Tuwo Tauyana valena isagayako. Tauna geya tuwaina itoboine asayadi sinaedi goi ivamaamaétala, go sem ina yoyowo goi ikaaiyaka. Go asa liliudi goi tomota simamaima Tauyana yaina. ");
INSERT INTO gvs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Niga Yeisu ikaluvilamna ina Kapaneumi goi go, maliyalina maniyedi sikavava, toni kasa sinove bego Tauyana bogina ima vada goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tuwo tomota badabadaidi sima vadayana goi situgúguna, tauna sinaena ikayaoda, e totom kikina nakae ikayaoda. Tomota sikaaiyaka go, Tauyana Yaubada ina vala ivatuulukoidi. ");
INSERT INTO gvs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ivaatulúkwana go, koroto adi taivasi topem ma liyaliyakaina sime. ");
INSERT INTO gvs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Latuwodi sisiuye sime Yeisu yaina goi go, boda isaki pasina geya itoboinedita. Tauna aitámana toluye goi simwerae sinave vada yatana goi átava giyaina sikibale. Ikavava, topemyana ma liyaliyakaina sisoilave isou Yeisu matana goi siyato. ");
INSERT INTO gvs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Siyato go, Tauyana idi numisa igite, tuwo topemyana ilatuwoko idigo kana, ‘Natugu, yau adigo kom im goyo adi nuwotao bogina kubabane.’ ");
INSERT INTO gvs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","E kidi go Yaubada ina Katukeda ana tovatulukwanayao maniyedi amoko goi siitusobu taudiva nuwodi goi sinuwonúwana kadi, ");
INSERT INTO gvs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Iyaa! Amo korotoyana manakae! Idigopopóita! Tauyana bego ieyaubada! Geya vatau tayaamo itoboine bei tomota idi goyo inuwotaoidi. Moe Yaubada anetava itoboine.’ ");
INSERT INTO gvs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","E Yeisu balomaina goi iyagoi manakaedi sinuwonúwana, tuwo ilatuwokoidi idigo kana, ‘Komi kaga unana nuwomi goi moe nakae konuwonuwone? ");
INSERT INTO gvs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Gobe ava livala ikakapu topemyana alatuwoko? Kagu, “Kom im goyo ana nuwotao bogina kubabane”? Gea kagu, “Kutāoya be im sita kukavāle, e kuketōiya”? Nako ikakapu? ");
INSERT INTO gvs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","E itoboine koyagoi Tomalatomota mana lovina poyapoya goi tomota idi goyo inuwootaoidi.’ Yeisu itugavila topemyana ilatuwoko idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘Alatuwokoim kutāoya, im baseko kwābi, kwaluvīla kūna im kasa!’ ");
INSERT INTO gvs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tuwo topemyana itáoya, e mainao ina baseko ikabi, boda liliudi matadi goi iketoiya vadayana goi isowóduwo ina! Tauna boda madabokidi sikainaopa nakae Yaubada ina togaga ana káeyana sikamoitamoe kadi, ‘Guinuwa amo nakae boi geya tayaamo tuta tagite!’ ");
INSERT INTO gvs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Niga Yeisu ina Galili labutabutaina goi, tuwo boda gagaina simamaima Tauyana yaina go, ivatuulukoidi. ");
INSERT INTO gvs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ikavava, iketoiya inonoina go, Alipiyo natuna Livai igite, takisi ana kaba gogo goi iitusobu ipaaisewa. Tuwo Yeisu ilatuwoko idigo kana, ‘Livai, kūma kusabokuliyēgu!’ Tuwo moitamo itáoya, Yeisu isabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Niga Yeisu mana tovatotowanayao taiyao sina Livai ina vada goi áika manuna. Amoko goi takisi ana togogoyao be ituli ta toogoyoidi badabadaidi sikaaiyaka Yeisu mana tovatotowanayao taiyao sikakáika. Bogina kuyagoi. Booda Yeisu sisabookuliye. ");
INSERT INTO gvs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","E sikakáika go, kidi Parisi amoko goi sikaaiyaka, tauyadi Yaubada ina Katukeda ana tovatulukwanayao. E Yeisu sigite ikakáika takisi ana togogoyao be ituli ta togoyoidiyadi taiyao. Tuwo ina tovatotowanayao silatuwokoidi sidigo kadi, ‘Kaga unana ami tovatulúkwana takisi ana togogoyao be ituli ta toogoyoidi taiyao sikakáika?’ ");
INSERT INTO gvs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Go kina Yeisu inovedi, ilatuwokoidi idigo kana, ‘Gwa. Tauyadi madi deedevina geya latuwodi doketa, go sem kidi tokatówana latuwodi doketa. Yau ama geya tauyadi toinidi sinuwonúwana bego kidi tokibóbwata aduduwedi geya, go sem ama toogoyoidi aduduwedi bei situgavila.’ ");
INSERT INTO gvs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","E Iyoni ina tovatotowanayao be nakae kidi Parisi sidiiyakímwana Yaubada manuna. Tuwo tomota maniyedi sima Yeisu silumadade sidigo kadi, ‘Iyoni ina tovatotowanayao be nakae Parisi idi tovatotowanayao sidiiyakímwana go, kom im tovatotowanayao manakae geya sidiyakimoneta?’ ");
INSERT INTO gvs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Go kina Yeisu idigo kana, ‘Neta nai ana káika goi tonai koroto nava yaimi ikaaiyaka, manakae? Nai ana toyokoyao itoboinedi bei madi nuwomou sidiyakímwana? Geya itoboinedita sidiyakímwana neta tonai koroto nava yaidi goi ikaaiyaka ae? Go sem itoboinedi madi uyáwana sikakáika ae? ");
INSERT INTO gvs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","E diyakímwana ana tuta nava imamaima. Amo tutayana tonaiyana bei siyoisi sinave, e tuta amo goi baige tauyadi sidiyakímwana. ");
INSERT INTO gvs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","E livalakaibala tayamo vatulukwana bogo be vatulukwana vau manudi avatulukoimi bei koyagoi. Geya vatau tayaamo boboda vau ikabi, ana kwama bogo taaporaina goi igilumipatuko, govila bei bobodayana ikatumásina, e kwama bogoyana itaisa go, ina taisayana bei gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aiyuwoina geya vatau tayaamo oine vau ikabi, opo bogo goi isaligogo, govila bei oine vauyana ana togaga pasina opo itapao, e oineyana idau besobeso go, opoyana bei igoyo. Go sem oine vau takabi, opo vau goi tasiwoi.’ ");
INSERT INTO gvs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","E Sabati tayamo goi Yeisu mana tovatotowanayao tánuwo sinaena siiketoiya. Ago ina tovatotowanayaoyadi idi ketoiya goi witi keuwoina siiguwedi sikakáika. ");
INSERT INTO gvs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Kidi go Parisi sikaaiyaka Yeisu silatuwoko sidigo kadi, ‘Iyaa! Amo tauyadi manakae siguuinuwa kaga Sabati ana lovina geya itagonedeta taguinuwe?’ ");
INSERT INTO gvs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Go kina Yeisu idigo kana, ‘Manakae? Kaga Devida boi iguuinuwe tetelina geya kokatuyaiviyeta ae? Boi tutayana ma senao loga sikámasa go, geya avadimo. ");
INSERT INTO gvs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tuwo tutayana Tonúwala Toolagaina Abiyatari ina tuta goi kina Devidayana ina Yaubada ina Vada isiu, Tonuwalayana yaina ikawanoi awoinu manuna. Tuwo Tonuwalayana beredi kaasalaidi ikabidi, Devida ivini ikáika. Ikáika ikavava, senao nakae ivinidi sikáika. Go geya vatau tayaamo mana tagona berediyadi ikáika. Moe kidi Tonúwala taudiva madi tagona sikáika.’ ");
INSERT INTO gvs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tuwaina Yeisu idigo kana, ‘Yaubada Sabati ivinida ada dedevina manuna go, geya kada imadagida Sabati manuna geya. ");
INSERT INTO gvs_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tauna Tomalatomota moe Sabati nakae ana Tomoya, e ilovina kaga itoboine Sabati goi tomota siguinuwe, tauna guna tovatotowanayao geya adi pikwanamo.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Aiyuwoina Yeisu ikaluvilamna ina Diyuu idi kaba tugúguna goi isiumna. Koroto tayamo amoko goi ikaaiyaka, nimana napanapaina go, kaamasina. ");
INSERT INTO gvs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kidi Parisi nakae sikaaiyaka, Yeisu sidumaakavate; latuwodi sigite neta Sabati goi korotoyana bei ikidedevine. Idi dumakavatayana bego itoboinedi Yeisuyana sikamamaetali Sabati ana lovina ana tokapipilova. ");
INSERT INTO gvs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tuwo ikandobala korotoyana igite, ilatuwoko idigo kana, ‘Kom nimam kaamasina, tomota nauyayanaidi goi kutāoya!’ Tuwo moitamo tomota nauyayanaidi goi itáoya ");
INSERT INTO gvs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","go, Yeisu itugavila, Parisiyadi ilatuwokoidi idigo kana, ‘Manakae? Itoboineda Sabati goi tavaita gea tayogedageda? Tomota yawoina tayave gea takaumate?’ Kidi go Parisiyadi situgau. ");
INSERT INTO gvs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tuwo Yeisu mana egamogamogu imatavilavila go, nuwona imou gagaina idi dabakasa pasina. Tuwo itugavila korotoyana ilatuwoko idigo kana, ‘Nimam kuyosāle!’ Tuwo moitamo nimana iyosale go, bogina idedevina. ");
INSERT INTO gvs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kidi Parisiyadi sitáoya, aba tugugunayana goi sisowóduwo sina Erodi ina bodao taiyao silosinapu manakaedi bei Yeisu sikaumate. ");
INSERT INTO gvs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Yeisu ina tovatotowanayao ikabidi, amo asayana sikalave, siiwo sina Galili labutabutaina goi. Go boda gagaina sinove kaga liliuna Yeisu bogina iguinuwedi, tuwo sima Tauyana sisabokuliye. Bodayadi Galili goi, Yudiya goi, Yerusalema goi, Idumeya ana dadava goi be nakae kidi Iyoridani go, bomatu dadavina asaina madabokidi goi sima. Aiyuwoina maniyedi Taya be Saidoni kikidi goi sima. ");
INSERT INTO gvs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tuwo Yeisu ina tovatotowanayao ilatuwokoidi idigo kana, ‘Kewou kokābi kōme bei itoboinegu asowoya boda pasidi, govila bei bodayadi sivatuvagivagígina yau yaigu.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Moitamo boda gagaina. Tokatówana badabadaidi bogina ikidedevinedi, tauna tokatówana liliuudi siketoiya vagivagígina sima latuwodi Yeisu sibisikone. ");
INSERT INTO gvs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Go ava dimoniva neta tomota yaidi goi sikaaiyaka go, Yeisu sigite, e tomotayadi sikinagovedi, e Yeisu matana goi aedi sivatugúyala go, sipodeda, sidigo kadi, ‘Kom Yaubada Natuna!’ ");
INSERT INTO gvs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Go kina Yeisu ilovinaedi idigo kana, ‘Taabu kotaalavāita bego yau avatau.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Niga ituko ina koya goi go, ava tomotava bogina ikinavedi iduduwedi sima yaina. ");
INSERT INTO gvs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ago koroto yawou aiyuwo ikawoidi be nakae ivayokoidi kidi ina vamoleyanayao. Nakae iguinuwe bego Tauyana sivakitau go, ivamoleyedi sina asa maniyedi goi Vala Dedevina sitalavaite ");
INSERT INTO gvs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","be nakae madi lovina dimoni sivatapiyedi. ");
INSERT INTO gvs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","E yawou aiyuwo iikawoidi yoidi ame nakae: Saimoni (tauyana youyuwoina moe Pita), ");
INSERT INTO gvs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi natunao Yemesa ma siyana Iyoni go, Yeisu ivayokoidi Bowanega. (Bowanegayana ana kaigavila moe kidi palapala nakae.) ");
INSERT INTO gvs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tuwaina Anduru, Pilipo, Batolomiu, Madiu, Tomasi, Alipiyo natuna Yemesa, Tadiyasi be nakae ituli ta Saimoni (boi tauyana Isileli tubunao idi kaba lovina ana tokokóila). ");
INSERT INTO gvs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tuwaina Yudasa guma Keriota; tauyana nava bei Yeisu inuwotuluye. ");
INSERT INTO gvs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Niga Yeisu ikaluvila ina ina vada Kapaneumi goi go, aiyuwoina boda gagaina sitaligógana simamaima yaina. Tauna Yeisu mana tovatotowanayao geya itoboinedita siwaiwasi be sikáika. ");
INSERT INTO gvs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Go tutayana ina bodao valena sinove, sima bego siyoisi sinave; idi nuwonúwana kadi, ‘Nakona iyaluwo.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Kidi go Yaubada ina Katukeda ana tovatulukwanayao maniyedi Yerusalema goi sisou sima latuwodi bego Yeisu ina paisewa sigite. Tauyadi sidigo kadi, ‘Beyelisebuli moe dimoni idi tolovina, e Yeisu ikiinagove. Tauyana dimoni ivataapiyedi go, moe Beyelisebuliyana ina togaga kaka goi ivataapiyedi siisowóduwo.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Go Yeisu iduduwedi sima livalakaibala goi ivatulukoidi idigo kana, ‘Manakae? Kaleya bego toinina ina bodao ivatapiyedi? Neta nakae iguuinuwe, bei ineneta. ");
INSERT INTO gvs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ava kaba lovina neta sinaena tomota siilivisi, moe aba lovinayana bei isou. ");
INSERT INTO gvs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Bodayáuwo nakae. Neta sinaedi tomota siilivisi, tomotayadi geya itoboinedita taiyao sitaoyakavata, go sem bei sisapa. ");
INSERT INTO gvs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ada Kaleya nakae. Neta toinina ina bodao ivakaleyedi, bei silivisi. Go moe kaga ana dedevina? Geya itoboineyeta itaoyakavata, go sem nava bei ikavava. ");
INSERT INTO gvs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yau dimoni avataapiyedi go, geya kada tauyana ina togaga goi avataapiyedi. Aba gita tayamo aguinuwe bei koyagoi Yaubada Balomaina goi dimoni avataapiyedi. Ada Kaleya koroto toogilúluna nakae. Geya vatau tayaamo itoboine togilulunayana ina vada goi isiumo bei konana ivainaoidi. Go koroto tayamo neta togilulunayana ina vada goi isiu go, mainao ivasobusobuye namliyeta baige nimana aena iyowóidi, e itoboine bei konana ivainaoidi. E yau nakae. Ada Kaleya bogina avasobusobuye, tauna itoboinegu ina dimoni avatapiyedi. ");
INSERT INTO gvs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Moe pasina itoboinegu dimoni avatapiyedi go, ame alatuuwokoimi konōve: Tomota idi goyo liliudi be idi tagíwaya liliudi sivaatoidi adi nuwotao bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Go avatauwa neta Baloma Kimaasabaina sitagiwoi, e adi nuwotao geya sibabaneyeta, go sem idi goyoyana ikaiyako vata yaidi goi.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yeisu ina bóbwara amo nakae unana kidi sidigodigo bego dimoni Tauyana ikiinagove. Tauna nakae ilatuwokoidi. ");
INSERT INTO gvs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","E Yeisu sinana be senao bogina sima moetala goi siitáoya, tuwo livala sietune ina Yeisu bego isowóduwo ima. ");
INSERT INTO gvs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tuwo boda Yeisu situsoobukobu silatuwoko sidigo kadi, ‘Gwa! Sinam be semowo moetala goi siitáoya; latuwodi kom kunovedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Go kina Yeisu idigo kana, ‘Sinagu avatau? Segowo avatauwa?’ ");
INSERT INTO gvs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Imatavilavila tauyadi situsoobukobu igitedi idigo kana, ‘Sinagu be segowo goamedi. ");
INSERT INTO gvs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Moitamo. Avatauwa neta Yaubada ina nuwonúwana siguuinuwe, e moe tauyadi segowo nakae niugowo nakae sinagowo.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aiyuwoina Yeisu ikaluvilamna ina Galili labutabutaina goi ivatowo ivatulúkwana. Ivaatulúkwana go, boda gagaina sitaligógana simamaima Tauyana yaina. Tauna itáoya iiwo ina oga tayamo idoidoiye goi isowoya, itusobu go, bodayadi liliudi labutabuta goi sikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tauyana vatulúkwana badabadaidi ivatuulukoidi go, madabokina moe livalakaibala goi. Ina vatulukwanayana goi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‘Ame konōve: Tobágula tayamo ina ina tánuwo goi witi kutukutuna isivagaegaedi. ");
INSERT INTO gvs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Isivagaaegaedi, e maniyedi sisou enao goi. Tuwo mánuwo sisou sima sikanidi. ");
INSERT INTO gvs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ago kutukutuyadi maniyedi sisou manamanáiyala goi go, mainao sitabo unana poyapoya giyaina. ");
INSERT INTO gvs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tutayana níyala ituko, iidimoidi simémala unana lamdi sitetalamo. ");
INSERT INTO gvs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Go kutukutuyadi maniyedi sisou taliboibo goi taiyao sitabo, sibíbina go, taliboiboyadi sididimatedi, tauna geya sikeuwoita. ");
INSERT INTO gvs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Go kutukutuyadi maniyedi sisou poyapoya dedevina goi sitabo, sibíbina, sikéuwo gagaina. Kutukutu badabadaiidi! Niga dibayoya ana tuta maniyena 30, maniyena 60, maniyena 100.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Tauyana kana, ‘Avatauwa komi neta ma taaiyami, e guna livala konoovedōko.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tutayana Yeisu ina bóbwara isayata go, anetava ikaaiyaka, e ina tovakitaunayao be kidi yawou aiyuwoyadi taiyao sima Tauyana yaina goi ina livalakaibala manudi silumadádana. ");
INSERT INTO gvs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Tauyana idigo kana, ‘Yaubada nanamsa bogina ivinimi bei itoboinemi ina nuwogau ina kalibúbuna manuna koyagoi. Go avatauwa neta nava Yaubada ina kalibúbuna goi geya sisiuta, e kaga liliuna livalakaibala goi sinovedimo, tauna geya siyagoiyeta. ");
INSERT INTO gvs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Moe bego tokabivalavala tayamo ina livala imalatomota, kana, ");
INSERT INTO gvs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tuwaina idigo kana, ‘Manakae? Guna livalakaibala ame geya koyagoiyeta ae? Gobe manakaemi bei livalakaibala liliudi koyagoidi? ");
INSERT INTO gvs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Livalakaibalayana ana talígava ame nakae: Kutukutuyadi tobágula isivagaaegaedi moe nakae Yaubada ina livala. ");
INSERT INTO gvs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","E tomota maniyedi amo poyapoyayana enao goi nakae tutayana kutukutu sisou. Amoko goi tobágula livalayana isivagaegae. Tutayana livalayana sinove, mainao Kaleya ima livalayana boi tobágula iibaguli tomota yaidi goi, e ikabi inave. ");
INSERT INTO gvs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tomota maniyedi amo manamanaiyalayana nakae tutayana kutukutu sisou sitabo. Tutayana ame tauyadi Yaubada ina livala sinove, mainao madi uyáwana siuuyaone. ");
INSERT INTO gvs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Livalayana siuuyaone go, nuwodi goi geya ikaseta nakae poyapoya kakaaraiina goi lam geya ikaseta. Tuwo tuta kaakupina tauna ikaaiyaka. E tutayana livalayana pasina mou be yogedageda sibabanedi, mainao sikapusi. ");
INSERT INTO gvs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tomota maniyedi amo poyapoyayana talibooibina nakae tutayana kutukutu sisou sitabo. Ame tauyadi Yaubada ina livala sinove go, ");
INSERT INTO gvs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","niga idi kaiyaka ana nuwokubukubu, esaesa ina tubanibani be nakae kónana adi yala atedi goi sisiu, e taliboibo nakae livalayana sididimate, tauna geya sikeuwoita. ");
INSERT INTO gvs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tomota maniyedi amo poyapoyayana dedevina nakae tutayana kutukutu sisou sitabo. Ame tauyadi Yaubada ina livala sinove, e siuyaone be nakae keuwoidi dedevidi sikeeuwoedi; maniyena 30, maniyena 60, maniyena 100.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tuwaina Yeisu kana, ‘Manakae? Rampa niinimina takabi vada goi tasiuye bego bayao goi tavatum o baseko ogalaoina goi tavaisiu, gea geya? Geya, go sem rampa ana kaba yata yatana goi tayato ae? ");
INSERT INTO gvs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Moitamo. Moe nakae yau guna sinapu livalakaibala goi. Kaga nakona vamoounina livalakaibala goi bei avagitakoe. Kaga nakona nuuwogauna livalakaibala goi bei akaiwoduwe bego koyagoi. ");
INSERT INTO gvs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Avatauwa komi neta ma taaiyami, e guna livala konoovedōko.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","E tuwaina Yeisu kana, ‘Korugwausīmi kaga konove yau yaigu bego kokabikaone. Nakonakae guna vatulúkwana konovedoko, e nakae Yaubada nanamsa tuwaina ivinimi go, nanamsayana bei ivaituwe yaimi. ");
INSERT INTO gvs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Avatauwa neta guna livala sinoovedoko, nanamsa tuwaina Yaubada bei ivinidi. Ago avatauwa neta livalayana sinooveyamo, ava nanamsa ikaaiyaka tauyadi yaidi, Yaubada bei ikuliuye.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tuwaina Yeisu kana, ‘Yaubada ina kalibúbuna tomota yaidi moe nakae vévana koroto ina tánuwo goi ibagulidi. ");
INSERT INTO gvs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sabamgo be maliyalina, ina masisi be ina táoya goi geya inuwonuwoneta vevanayadi manudi geya. Toinidi sitabotabo go, adi tabo be adi bíbina geya iyagoidita. ");
INSERT INTO gvs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Poyapoya ilovina adi tabo be adi bíbina be adi kéuwo manudi. ");
INSERT INTO gvs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","E namliyeta keuwoina imatuwo, tobagulayana ivatowo bei idibayoya.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Tuwaina Yeisu kana, ‘Yaubada ina kalibúbuna sinaena goi ina bodayáuwo adi vaituwo kaga goi bei akatutuko? Ava livalakaibala itoboine bei alivalakaibalae, e bei imavada yaimi? ");
INSERT INTO gvs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ana kaigigita alova tayamo kutukutuna giyaina toina nakae. Kutukutu liliudi poyapoya ame goi geya tayaamo alova kutukutuna giyaina nakae. ");
INSERT INTO gvs_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Go tutayana tabaguli, bei itabo ibíbina, e alova liliudi itabosavedi; nakae laonina gagaidi iyatoidi. Tauna laoninayadi goi mánuwo itoboinedi idi vátala siyowóidi.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","E livalakaibala badabadaidi amo nakae tutayana Yaubada ina kalibúbuna valena tomota ilatuuwokoidi. Go nakonakae tomota itoboinedi sinove, e nakae ilivalaakaibale. ");
INSERT INTO gvs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Lava liliuna livalakaibala kaka goi boda ivatuulukoidi, go sem ina tovatotowanayao aditava yaidi livalakaibalayadi itaaligeidi. ");
INSERT INTO gvs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","E amo maliyalinayana goi asa bogina ikalavilavi go, Yeisu ina bóbwara ilukavave. Ilukavave, Tauyana oga goi ikaaiyaka ina tovatotowanayao ilatuwokoidi idigo kana, ‘Kōma kosowōya, Galili Bwaena tayaodamāne tāna ta dadava.’ ");
INSERT INTO gvs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tuwo boda labutabuta goi sikalavedi go, oga goi sisowoya, sikailova oga maniyedi taiyao. ");
INSERT INTO gvs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Sikailova sinonoina go, ulibomatu gagaina ikalisou Bwaeyana goi itowo. Tuwo aivaya siseulalágata, e ogayana bogina sivakayaaodei. ");
INSERT INTO gvs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kina go Yeisu oga valemli goi ikaaiyaka, dabana logédava goi iyato bogina ikanaamatáiya. Tuwo ina tovatotowanayao sima siwoini sidigo kadi, ‘Tovatulúkwana! Manakae? Geya kunuwonuwoneta bego tavailai?’ ");
INSERT INTO gvs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tuwo itáoya yágira be aivaya ilovinaedi idigo kana, ‘Tuwo! Kudaūmwara!’ Tuwo yagirayana ilakapuwe nakae Bwaeyana ikadaúmwara gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Go ina tovatotowanayao ilatuwokoidi idigo kana, ‘Kaga komatoitae? Manakae? Nava geya konumisedokoiguta ae?’ ");
INSERT INTO gvs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tauyadi simatoita gagaina go, taudiva sibobóbwara kadi, ‘Iyaa! Ame ava koroto? Yágira be aivaya niyana sikabiikaone?’ ");
INSERT INTO gvs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yeisu kidi bogina sitadámana sina da Gerasine idi kaolao goi sivaiu. ");
INSERT INTO gvs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yeisu oga goi isou go, mainao koroto tayamo naagovaina valiwoga tukubu goi isowóduwo ima Yeisu ivalobode. ");
INSERT INTO gvs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tukubuyadi moe ina kaba kaiyaka. Boi mainao tomota itoboinedi tauyana siyoisi nimana be aena seni goi siiyowóidi go, ame tuta geya tuwaina itoboinedi. ");
INSERT INTO gvs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Unana tuta liliuna neta seni goi tauyana nimana be aena siiyowóidi, e seniyadi ikiguuyalidi. Tauna geya tayaamo avatau ana kaipata bei tauyana iyoisi nimana aena iyowóidi. ");
INSERT INTO gvs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tuta liliuna, sabamgo be maliyalina, tukubu goi be koya goi isupoola beso be nakae ipodeeda beso. Aiyuwoina gurewa ikabi, toinina iitalai, ikaika idau. ");
INSERT INTO gvs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","E Yeisu oga goi bogina isou go, korotoyana nava aduwanau goi ikandoiwo Yeisu igite, tauna ilokoina ima Yeisu matana goi aena ivatugúyala. ");
INSERT INTO gvs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ivaatugúyala go, kina Yeisu ilatuwoko idigo kana, ‘Kom dimoni, koroto ame goi kusowōduwo!’ Nakae ibobóbwara go, dimoniyana niyana gagaina goi ipodeda, idigo kana, ‘Yeisu, kom Yaubada Tokanayatanatoina Natuna, yau guna polava moe geya kom im polava geya. Tuwo! Yaubada yoina goi akawanoi yaim bego geya kuyogedegedeguta!’ ");
INSERT INTO gvs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Go Yeisu idigo kana, ‘Kom yoim manakoyoina?’ Tauyana idigo kana, ‘Mama boda koroto ame sinaena goi kakaaiyaka. Tauna yoigu Uwouwo.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Tauyadi sikawanoi makimaki sidigo kadi, ‘Taabu ame dadavayana goi kuvataapiyēma!’ ");
INSERT INTO gvs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ego doyava koya goi bao badabadaidi sidumdumla. Dimoniyadi sikandobala bao sigitedi, ");
INSERT INTO gvs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","tuwo sikawanoi makimaki Yeisu yaina sidigo kadi, ‘Neta kuetunēma kāna dobala bao amo sinaedi goi bego kasiu.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tuwo moitamo itagonedi. E dimoniyadi sitáoya, koroto goi sisowóduwo sina bao sinaedi goi sisiu. Sisiu, baoyadi madabokidi sisaloku, silokoina sina koya tagatagagina goi sipela sisou sina Galili Bwaena goi sisalili. Baoyadi adi badabada moe 2,000. ");
INSERT INTO gvs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kidi go baoyadi adi tomatakavatayao sisiya sina asa gagaidi be giyaidi goi kaga kaga siisowóduwo sitalavaitedi. Tuwo toni kasa sima latuwodi sigite kaga iisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Toni kasayadi sima Yeisu yaina go, korotoyana boi naagovaina sigite mana kwama nakae nuwona imavada iitusobu. Tuwo simatoita. ");
INSERT INTO gvs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ago tomota boi mainao sigite kaga isowóduwo, sivateteli tomota yaidi korotoyana boi naagovaina manakaena idedevina be nakae bao manakaedi sivailai. ");
INSERT INTO gvs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tuwo toni kasayadi sinove, sikawanoi makimaki Yeisu yaina sidigo kadi, ‘Ima kasa kwalāve.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tuwo Tauyana iiwo ina oga goi iisowoya bego ikalavedi go, korotoyana boi naagovaina ima Yeisu yaina ikawanoi makimaki idigo kana, ‘Tomoya, manakae? Kutagona asabokuuliyem?’ ");
INSERT INTO gvs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ago Yeisu geya itagoneyeta, go sem korotoyana ilatuwoko idigo kana, ‘Kwaluvīla kūna im kasa, e im bodao kulatuwokōidi Tomoya manakaena guinuwa toogagaidi iguinuwedi yaim be nakae manakaena inuwokapisiyem.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tuwo moitamo korotoyana itáoya ina Dekapoli goi Yeisu ina guinuwa toogagaidi tauyana yaina iguuinuwedi italavaaitedi. Ago tomota madabokidi neta livalayana sinove, nukotodi siwówana. ");
INSERT INTO gvs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tuwo Yeisu mana tovatotowanayao ogayana sisowoya, sisaidamanamna sina ituli ta dadava goi sisou, e boda sitaligógana sima Tauyana yaina go, kina labutabuta goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ikaaiyaka go, Diyuu idi kaba tugúguna ana tolovina tayamo yoina Yairo ima Yeisu igite, matana goi aena ivatugúyala ");
INSERT INTO gvs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ikawanoi makimaki idigo kana, ‘Natugu vavina gómana giyaina giyakainava bei ikámasa. Neta kūma gomanayana dabana goi nimam kuyatōidi, kukidedevīne, e bei ma yawoina.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tuwo moitamo Yeisu taiyao sina. Ego sinonoina, enao goi boda gagaina mlidi goi sivatuvagivagígina. ");
INSERT INTO gvs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sivatuvagivagigi go, bodayadi sinaedi vavina tayamo ima. Vavinayana tala yawou aiyuwo goi ikaikaina idaudau go, nava idaudau. ");
INSERT INTO gvs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ego boi nimatu inonoina doketa liliudi yaidi ina mani madabokina ilukavave go, doketayadi idi guinuwa pasina gedageda ilotowo. Ago idi guinuwa goi geya iboboineta, go sem ina vísiya ibibíbina. ");
INSERT INTO gvs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Niga Yeisu valena inove, ima ivalabelabena Tauyana mlina goi ibisibala ana kwama ibisikone. ");
INSERT INTO gvs_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ina nuwonúwana kana, ‘Neta Tauyana ana kwama kaka abisikoneyamo, bei aboboina.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tuwo ibisikone, e ikaikainayana ina dau mainao isayata. Tauyana wowona sinaena inamkone bego ina visiyayana goi bogina iboboina. ");
INSERT INTO gvs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","E kina Yeisu bogina inamkone bego togaga toinina yaina goi isowóduwo, tuwo itugavila boda yaidi goi idigo kana, ‘Avatau agu kwama ibisikone?’ ");
INSERT INTO gvs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ago kidi ina tovatotowanayao sidigo kadi, ‘Tomoya, boda gagaina kugitedi sitaoyaakobum be sivatuvagivaagigim, tauna kaga unana kulumadádana kam, “Avatau ibisikonegu?”’ ");
INSERT INTO gvs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Go Tauyana imatavilavila; latuwona igite avatau ana kwama ibisikone. ");
INSERT INTO gvs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","E kina go vavinayana bogina iyagoi ana boboina maine ibabane, tauna mana matoita be mana tátava ima Yeisu matana goi aena ivatugúyala, e dogoiyana madabokina italavaitedokoidi. ");
INSERT INTO gvs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","E Yeisuyana kana, ‘Natugu, im numisa bogina ikidedevinem. Kutāoya be mam tuboina kūna. Im vísiya madabokina bogina ikavava.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nava Yeisu ibobóbwara go, tomota maniyedi tolovinayana ina vada goi sima Yairo silatuwoko sidigo kadi, ‘Natum bogina ikámasa, tauna kaga ana dedevina nava tovatulúkwana kuuyobose?’ ");
INSERT INTO gvs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","E kina go Yeisu bogina inowoyabedi kaga sidigedige, e aba tugúguna ana tolovinayana ilatuwoko idigo kana, ‘Taabu kuumatōita. Kunumisegūmo.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ago boda liliuna isanabodedi geya sisabokuliyeta, go sem Pita be Yemesa ma tuwowona Iyoni aditava itagonedi taiyao sisiu. ");
INSERT INTO gvs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ivataoduwedi tolovinayana ina vada goi sinove taodi be táiya gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tuwo Yeisu isiu ina ilatuwokoidi idigo kana, ‘Kaga unana kovamgemge be kotaitáiya? Gómana moe geya ikamaseta, go sem ikanaamatáiya.’ ");
INSERT INTO gvs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","E Tauyana sinove, sivaanamae go, kina ivalilivedi sisowóduwo moetala goi. Ago gómana tamana be sinana nakae Yeisu mana tovatotowanayao adi taito sina gomanayana ina kaba masisi goi sisiu. ");
INSERT INTO gvs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Sinaena goi Yeisu ibala ina gomanayana nimana iyoisi, idigo kana, ‘Talita kumi!’ Moe ana kaigavila kada, ‘Gómana alatuwokoim kutāoya!’ ");
INSERT INTO gvs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Gomanayana ana tala yawou aiyuwo bogina ibabanedi, tauna etoiya bogina yoiyana. Tuwo to mainao itáoya iketoiya. E tauyadi sikaaiyaka sikainaopa gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Go Yeisu isanabodedi idigo kana, ‘Geya vatau tayaamo yaina kotaalavāita guna guinuwa ame manuna, go sem gómana avana kovīni ikáika.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yeisu itáoya amo dadavayana ikalave go, ikaluvila ina toinina ina kasa, e ina tovatotowanayao sisabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabati goi Tauyana ina Diyuu idi kaba tugúguna goi isiu ivatowo ivaatulúkwana. Ago tomota badabadaidi vadayana goi ina vatulúkwana sinovenove sikainaopa sidigo kadi, ‘Amo Tauyana ina nanamsa nako goi ikabi? Nakae ina guinuwa toogagaidi nimana goi iguuinuwedi manakaena iguinuwedi? ");
INSERT INTO gvs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iyaa! Amo Tauyana vada ana toyówana! Sinana Meri, senao moe Yemesa, Iyosese, Saimoni be Yuda. Niunao ameko sikaaiyaka tayaagoidi. Tauyana kita nakae.’ Tuwo gamodi igoyo, e Tauyana sikatae. ");
INSERT INTO gvs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Go kina Yeisu idigo kana, ‘Yaubada ina tokabivalavala ana wowoina asa liliudi goi iibabane go, toinina ina kasa goi be toinina ina bodao goi be nakae toinina ina bodayáuwo goi geya ana wowoinamo.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Amoko goi tomota geya sinumiseta, tauna Yeisu geya itoboineyeta guinuwa toogagaidi badabadaidi iguinuwedi, go sem tokatówana adi taiyuwomo sima dabadi ibisikonedi ikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ago nuwona iwówana unana geya idi numisamo. Tuwo ina ivanibiníbita asa tamo tamo goi ivaatulúkwana. ");
INSERT INTO gvs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yeisu ina tovatotowanayao yawou aiyuwo iduduwedi sima. Sima, lovina ivinidi bei itoboinedi dimoni sivatapiyedi. Ikavava, adi taiyuwo adi taiyuwo ivamoleyedi sina asa tamo tamo goi. ");
INSERT INTO gvs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Go latuwona Yaubada sinumise, tauna mainao ilovinaedi idigo kana, ‘Imi vaníbita goi nima kaka kōna. Imi kaituko kaka kokabīdi, ame tauna; tuwaina geya. Ami kinare geya, wasare geya, esaesa ma saisairina geya, ");
INSERT INTO gvs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","go sem ami sendoro kovalilivīdi, ami kwama tayamo kolōsi go, kwama aiyuwoina taabu kokabikābi.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tuwaina kana, ‘Ava vada goi neta kosiu, moeko goi kokaaiyāka ana kadókana kotáoya asayana kokalave. ");
INSERT INTO gvs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Go ava kasa goi kosiu, neta toni kasa geya siuyaonemita o imi livala geya sinovedita, e asa amo kokalāve go, tutayana kosowóduwo, e asayana kaukauna aemi goi kokatumaumāui. Moe imi katumátala tauyadi yaidi bego Yaubada itavileiyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Tuwo ina tovatotowanayaoyadi sitáoya sina asa liliudi goi sivanibiníbita, e tomota yaidi sitalavaita bego situgavila. ");
INSERT INTO gvs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ago dimoni tomota yaidi sivatapiyedi be nakae tokatówana liliudi pútuma goi sikatukoisidi, e sikidedevinedi. ");
INSERT INTO gvs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E tolovina Erodi Yeisu ina guinuwa valena inove. Bogina kuyagoi. Yeisu yoina bogina gagaina, tomota liliudi sivaateteli. Tauyana manuna tomota maniyedi sidigo kadi, ‘Moe Iyoni tosayóyova. Tokámasa yaidi goi Yaubada bogina ikaitáoe. Ame pasina Tauyana itoboine guinuwa toogagaidi iguuinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Go tomota maniyedi sidigo kadi, ‘Yeisu moe Eliyau.’ Go maniyedi kadi, ‘Tauyana tokabivalavala nakae boi Yaubada ina tokabivalavalayao.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","E tutayana livalayadi Erodi inovedi, idigo kana, ‘Nakona Tauyana Iyoni tosayóyova! Boi yau guna lovina goi nukotona sibobo ikámasa go, tokámasa yaidi goi Yaubada bogina ikaitáoe.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erodiyana ina nuwonúwana unana ame: Boi tauyana ina lovina goi ina tovayaviyayao sina Iyoni siyoisi, nimana siyowóidi, e deri goi sivaisiu siyana Pilipo monena Erodiyasi manuna. Boi mainao Erodiyasiyana moe Pilipo monena go, kina Erodiyana siyana monena tubitubina igagi. ");
INSERT INTO gvs_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Iyoniyana ana yóita unana tuta liliuna Erodi ilaatuwoko kana, ‘Erodi, kom geya am tagonamo bei siyam monena kunai!’ Tauna deri goi Iyoni sivaisiu. ");
INSERT INTO gvs_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","E kina go Erodiyasiyana iegamogamogu Iyoni ina livala pasidi, tauna latuwona tauyana sikaumate go, enao geya. ");
INSERT INTO gvs_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Kina go Erodi mana wowoina Iyoni imatoite, tuwo imatakavate unana iyagoi tauyana tokibóbwata be nakae kimaasabaina Yaubada umana. Erodiyana neta Iyoni ina livala inovedi, pasidi nukotona iwówana gagaina go, mana uyáwana tauyana itaiiyakeke. Tauna Erodiyasiyana enao geya ibabaneyeta bego Iyoni ikaumate. ");
INSERT INTO gvs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","E Erodiyana ina bíbina ana maliyalina isowóduwo. Moeko goi Erodiyasi bogina enao inuwobabane Iyoni ana kaumata manuna. Amo maliyalinayana goi Erodi áika iguinuwe go, ogaoga maniyedi iduduwedi sima. Ogaogayadi moe koroto gagaidi, tovayaviya adi tokalikumatanayao be nakae da Galili idi tomoyamoya. ");
INSERT INTO gvs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aikayana goi Erodiyasi natuna vavina isiu ina boda matadi goi iláusa go, ina lausayana Erodi mana ogaoga ivauyaonedi. Tuwo Erodi woiyaiyana ilatuwoko idigo kana, ‘Kaga latuwom, kukawanoiyēgu, bei avinim.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Go ikatótula nakae ilapasaisai idigo kana, ‘Kaga kukawanoiye yaigu, bei avinim. Neta guna kaba lovina, bei awotai dadava tayamo avinim.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tuwo woiyaiyana isowóduwo ina sinana yaina goi ilumadádana idigo kana, ‘Sinagu, kaga bei akawanoiye tomoya yaina?’ ‘Latuwogu Iyoni tosayóyova bulubuluna’, sinanayana kaena. ");
INSERT INTO gvs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","E woiyaiyana woilina ikaluvila ima tolovina ilatuwoko idigo kana, ‘Latuwogu bego ame tutayana Iyoni tosayóyova bulubuluna noko goi kudodōi kuvinīgu.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ame livalayana tolovina inove, nuwona imou gagaina go, ina katótula pasina be nakae ina ogaoga pasidi geya latuwona woiyaiyana ina kawanoi ikatae. ");
INSERT INTO gvs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E tolovinayana ina tovayaviya tayamo ilatuwoko idigo kana, ‘Kūna deri goi Iyoni nukotona kubōbo. Ikavava, bulubuluna kūme.’ Tuwo moitamo tovayaviyayana itáoya ina deri goi Iyoniyana nukotona ibobo. ");
INSERT INTO gvs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ibobo ikavava, bulubuluna ikabi, nokoyana tobuna goi idodoi ime woiyaiyana ivini. Tuwo ikabi inave sinana ivini. Moe pasina tauna Erodiyana itainasi inuwonúwana Yeisu moe Iyoni go, bogina itaoyamna. ");
INSERT INTO gvs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Niga Iyoni ina tovatotowanayao ina vailai valena sinove, sima wowona sikabi, sinave valiwoga tukubu goi siyato. ");
INSERT INTO gvs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yeisu ina vamoleyanayao sikaluvilamna sima Tauyana yaina goi sigúguna go, kaga liliuna idi vaníbita goi siguuinuwedi be sivaatulúkwana sivatétala adi kaibako. ");
INSERT INTO gvs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tauyana ilatuwokoidi idigo kana, ‘Dadava ame takalāve, tāna yoyowo goi giyaina amitava kowaiwāsi.’ Moitamo, kidi waiwasi geya. Boda gagaina sivaviilavila, tuwo ina tovatotowanayao geya itoboinedita siwaiwasi o sikáika nakae. ");
INSERT INTO gvs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tuwo, taudiva oga tayamo goi sisowoya sikailova bego sisaidámana sina yoyowo tayamo goi. ");
INSERT INTO gvs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Go boda maniyedi sikandoiwo sigitedi sinonoina go, sikinanedi. Tuwo, bodayadi be nakae asa liliuna ana tokaiyakayao madabokidi taiyao silokoinakumgo sina dadavayana goi sigimisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","E Yeisu mana tovatotowanayao bogina sima sivaiu, Tauyana isou labutabuta goi go, boda gagaina igitedi tauyadi sipi geya adi tomatakavatamo nakae. Tauna inuwokapisiyedi go, ibibilágata vatulúkwana badabadaidi ivatulukoidi. ");
INSERT INTO gvs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bogina lavilavi toina Yeisu ina tovatotowanayao sima silatuwoko sidigo kadi, ‘Ame yoyowo go! Aiyuwoina níyala giyakainava bei isaliu. ");
INSERT INTO gvs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Neta boda kuvalilivēdi bego sina asa maniyedi kikida goi avadi sigimona.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Go kina idigo kana, ‘Komi kovakanīdi.’ Go kidi sidigo kadi, ‘Manakaema? Manakae kana boda ame go, giyaina kaeda avadi kagimona? Beredi boda ame manuna moe ana maisa ivakaigaga nakae tukówana ainima aito ima paisewa ana maisa! Kai geya itoboinemeta kavakanidi.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","‘Komi aivina ami beredi? Kōna kogīte’, Tauyana kaena. Tuwo sina sigite ikavava, sikabidi sikaluvila sidigo kadi, ‘Beredi ainima, íyana aiyuwo.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tuwo Yeisu idigo kana, ‘Kōna boda kokiwotāidi, e gúguna tamo tamo limou goi situsobu.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tuwo moitamo sina bodayadi sikiwotaidi go, gúguna tamo tamo situsobu, maniyedi 100, maniyedi 50 nakae. ");
INSERT INTO gvs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ago berediyadi ainima be iyanayadi aiyuwo Yeisu sivini. Tuwo ikabidi, ikandolaga yábana goi, manudi ikauyagu Yaubada yaina. Ikavava, berediyadi ikivisidi, ina tovatotowanayao ivinidi bego sina sikaiguyauyedi bodayadi yaidi. Ikavava, iyanayadi nakae ikivisidi ivinidi sikaiguyauyedi. ");
INSERT INTO gvs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tuwo tomota madabokidi sikáika gamodi. ");
INSERT INTO gvs_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sikáika ikavava, ina tovatotowanayaoyadi beredi be íyana valalaidi sikatunokunokudi go, moe bayao yawou aiyuwo sikayaoda. ");
INSERT INTO gvs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Tokáika koroto kaka adi badabada moe 5,000. ");
INSERT INTO gvs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","E Yeisu ina tovatotowanayao ilatuwokoidi idigo kana, ‘Oga goi kosowōya, kovakūmgo kotavīla kōna Betesaida ta dadava go, yau boda bei alatuwokoidi sisáwala sina idi kasa.’ ");
INSERT INTO gvs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tuwo ina tovatotowanayao ivalavedi go, bodayadi ilatuwokoidi sisáwala. Ikavava, ituko koya goi ikawanoi. ");
INSERT INTO gvs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Níyala bogina isaliu go, ina tovatotowanayaoyadi Galili Bwaena nauyayanaina goi sibeubéuta. Sibeubéuta go, Tauyana anetava koyayana goi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ago ikandoiwo ina tovatotowanayaoyadi igitedi sibeubéuta go, sikúyuwo. Bogina kuyagoi, yágira matadi goi. Iigitedi, tuwo botomotomo bwae yatana goi iketoiya imamaima. Bego isaivata ");
INSERT INTO gvs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","go, ina tovatotowanayao sikandobala Tauyana sigite bwae yatana goi iketoiya imamaima, tauna sipodeda sidigo kadi, ‘Baloma goamo!’ ");
INSERT INTO gvs_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Moitamo. Madabokidi sigite, atedi siyova, tauna sipodeda. E Yeisu mainao ilatuwokoidi kana, ‘Kokatepātu! Yau Tauyagu. Taabu koomatōita!’ ");
INSERT INTO gvs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ibóbwara ikavava, oga goi isowoya tauyadi taiyao, e yagirayana idaúmwara go, kidi nukotodi iwówana gagaina toina. ");
INSERT INTO gvs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Moitamo. Boi beredi adi vaituwo ana yagoina sigite go, nava geya siyagoiyeta Yeisu mana togaga, go sem dabadi sikasa. ");
INSERT INTO gvs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Yeisu mana tovatotowanayao bogina sisaidámana sina Genesareta dadavina goi sivaiu, idi oga sivailowo. ");
INSERT INTO gvs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sivailówana ikavava, oga goi sisou go, toni kasa sikandoiwo Yeisu sikinane. ");
INSERT INTO gvs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tuwo tomotayadi silokoina sina asa liliudi amo dadavayana goi idi tokatowanayao sikabidi, sivaliyaliyakedi go, nako goi sinove Yeisu ikaaiyaka, e sinavedi amoko goi. ");
INSERT INTO gvs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Neta Tauyana asa giyaidi o gagaidi goi isiu, tomota liliudi idi tokatowanayao sikabidi simedi aba maketi goi siyatoidi go, sikawanoi makimaki Tauyana yaina kadi, ‘Kutagonema am kwama kikina kaka kabisikone?’ Tuwo moitamo itagonedi go, avatauwa neta sibiisikone, e siboboina. ");
INSERT INTO gvs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","E Parisi be nakae Yaubada ina Katukeda ana tovatulukwanayao maniyedi taiyao Yerusalema goi sima sitaligógana Yeisu yaina. ");
INSERT INTO gvs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","4","Parisi be nakae Diyuu liliudi tubudiyao idi gulagula sikabikaaonedi ame nakae: Neta nimadi geya sinikidokoidita, e geya sikaiketa. Neta aba maketi goi sima, neta geya siisiwoita, e geya sikaiketa. Tubudiyao idi gulagula tuwaina sikabikaaonedi. Nakae idi keiga, idi kontena be nakae idi keteri sinikidi bego Yaubada iuyaonedi. E kidi Parisi be nakae Yaubada ina Katukeda ana tovatulukwanayao sima Yeisu ina tovatotowanayao sigitedi nimadi geya kimasabaidimo Yaubada umana, o tadigo kada, ‘Nimadi geya sinikidita’ go, tuwo sikakáika. ");
INSERT INTO gvs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tauna Parisi be Yaubada ina Katukeda ana tovatulukwanayao Yeisu silumadade sidigo kadi, ‘Kom im tovatotowanayao manakae idi sinapu goi tubudao idi gulagula geya siguinuweta, go sem nimadi geya kimasabaidimo sikakáika?’ ");
INSERT INTO gvs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Go kina Yeisu kana, ‘Komi todedevimi polapola! Boi nimatu tutayana Aiseya Yaubada ina livala itaalavaite, e italavaitedokoimi, idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Idi vatulúkwana moe tomota idi nuwonúwana, ");
INSERT INTO gvs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Komi nakae. Yaubada ina lovina kokalavedi go, tomota idi gulagula kokabikaaonedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Aiyuwoina idigo kana, ‘Komi koyagoidoko manakaemi Yaubada ina lovina kokataedi bego toinimi imi gulagula kokailagasidi ae? ");
INSERT INTO gvs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Guna masi ame nakae: Boi Mosese Yaubada ina lovina italavaite, idigo kana, “Tamamiyao be sinamiyao kowowooinēdi!” Tateta 20:12; Atukeda 5:16 Aiyuwoina kana, “Avatau neta tamana o sinana igieomaemae, e to kokaumateyāmo.” ");
INSERT INTO gvs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Go komi kotagona tomota tamana o sinana ilaatuwoko kana, “Yabobona bego avinim go, yabobonayana bogina korabani.”’ Korabaniyana ana yagoina moe ana vaséyana Yaubada yaina. Yeisu tuwaina kana, ");
INSERT INTO gvs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","‘Moe nakae imi sinapu goi tauyana kosanabode bego tamana o sinana ivaitedi. ");
INSERT INTO gvs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Moeko goi imi gulagulayadi tomota kovatuulukoidi sikabikaaonedi pasidi Yaubada ina livala kovayoko dogoi besobeso. Ago guinuwa badabadaidi moe nakae koguuinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E Yeisu ibóbwara ikavava, aiyuwoina boda iduduwemneidi sima ilatuwokoidi idigo kana, ‘Madabokimi konovēgu go, kopoikīki guna livala koyagoi! ");
INSERT INTO gvs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Geya kada kaga tayamo takani bei ikibaibailida geya, go sem kaga sinaeda goi sisowóduwo, e moe sikibaibailida. ");
INSERT INTO gvs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Avatauwa komi neta ma taaiyami, guna livala konoovedōko!’ ");
INSERT INTO gvs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tutayana Yeisu mana tovatotowanayao boda sikalavedi sina vada tayamo goi sisiu go, ina tovatotowanayao silumadade sidigo kadi, ‘Im livalakaibala kaga ana yagoina?’ ");
INSERT INTO gvs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Go kina Yeisu ilatuwokoidi kana, ‘Komi nakae bodayadi, nava nuwomi geya itaporeta? Manakae? Ame geya koyagoiyeta ae? Kaga liliuna taakanidi, geya sinoita nuwoda goi, go sem sisou sina gamoda goi namliyeta sisowóduwo sina mosamosa. Tauna moe dogoiyadi geya itoboinedita sikibaibailida.’ Yeisu ina livalayadi ame goi awoinu liliudi ivayokoidi awoinu taagonaidi. ");
INSERT INTO gvs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","E aiyuwoina Yeisu idigomna kana, ‘Kaga tomota nuwoda goi siisowóduwo, e moe dogoiyadi sikibaibaailida. ");
INSERT INTO gvs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tomota nuwodi goi nuwogau goyogoyoidi siisowóduwo. Nuwogauyadi pasidi ame sisowóduwo: Masisi goyogoyoina, vaináwana, aumata, ");
INSERT INTO gvs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","roerata, matakónana, guinuwa goyogoyoidi, pola, sakava ana vikaiya owáowana, piki, tagíwaya, nuwatue be nakae guinuwa owáowana. ");
INSERT INTO gvs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ame dogoiyadi goyogoyoidi liliudi tomota nuwoda goi siisowóduwo sikibaibaailida.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","E Yeisu itáoya ina tovatotowanayao taiyao amo dadavayana sikalave go, sina Taya ana dadava goi. Amoko goi vada tayamo ibabane ana toboine ikaiyaka. Tuwo isiu go, geya latuwona bego tomota siyagoi vadayana goi ikaaiyaka. Go geya itoboineyeta bei isiugau, ");
INSERT INTO gvs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","go sem vavina tayamo vala inove Yeisu ikaaiyaka, tuwo mainao ima ivatugúyala Yeisuyana aena goi ikawanoi natuna vavina naagovaina manuna. ");
INSERT INTO gvs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ego vavinayana Totuyoyowo tayamo, tauyana Poinike vavinaina. E ima ikawanoi Yeisu yaina idigo kana, ‘Dimoni tayamo natugu ikiinagove go, akawanoi yaim bego dimoniyana kuvatapiye isiya.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Go kina Yeisu idigo kana, ‘Mainao gogómana sigimikáika, gamodi. Geya itoboineyeta bei gogomanayadi avadi akuliuyedi go, alavedi weiniya goi.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","‘Go Tomoya, weiniyayadi woi teboro ogalaoina goi sikaaiyaka gogómana avadi mgumguna siikasámdala’, vavinayana kaena. ");
INSERT INTO gvs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeisu idigo kana, ‘Moe livala mooitamoina! Livalayana pasina kutāoya, kwaluvīla kūna im vada. Dimoniyana boi natum ikiinagove bogina isowóduwo ina.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tuwo moitamo, vavinayana itáoya ina ina vada, e natuna igite kebana goi iimasisi go, dimoniyana bogina isowóduwo ina. ");
INSERT INTO gvs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeisu itáoya aiyuwoina Taya ana dadava ikalave go, ina Saidoni ana dadava iseivata ina Dekapoli dadavina goi isiu ina asa Galili Bwaena kikina goi. ");
INSERT INTO gvs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Amoko goi koroto tayamo ikaaiyaka taiyana patupatuna be nakae maena imoumou. Tuwo senao sime Yeisu yaina goi sikawanoi makimaki sidigo kadi, ‘Tomoya, neta siyama kubisikōne bei idedevina.’ ");
INSERT INTO gvs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tuwo moitamo ibala ina korotoyana ikabi, boda sikalavedi go, aditava sina masigava sitáoya. Sitáoya, Yeisu nimadidina ivaisiudi korotoyana taiyana sinaena. Ikavava, toinina nimadidina igiwoli, korotoyana maena ibisikone. ");
INSERT INTO gvs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ikavava, ikandolaga yábana goi mana nuwokapisi ikalayawoi go, idigo kana, ‘Epapāta!’ Moe ana kaigavila kada, ‘Kutapōra!’ ");
INSERT INTO gvs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","E korotoyana taiyana sitapora nakae maena idedevina, tauna ibobwara dókana. ");
INSERT INTO gvs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ago Yeisu boda isanabodedi idigo kana, ‘Geya vatau tayaamo yaina moe kotaalavāite!’ Tuta badabadaina nakae ilatuuwokoidi go, tuwo tuwaina sitaalavaite tomota yaidi. ");
INSERT INTO gvs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Go tomota ina guinuwa sigite, sikainaopa gagaina sidigo kadi, ‘Iyaa! Ina guinuwa madabokina dedevina! Tauyadi taiyadi patupatudi ikidedeevinedi bei sinowo, nakae tauyadi maedi simoumou ikidedeevinedi bei sibobwara dókana.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Amo tutayana aiyuwoina boda gagaina sikaaiyaka Yeisu taiyao go, geya avadimo. Tuwo ina tovatotowanayao iduduwedi sima, ilatuwokoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‘Ame bodayadi bogina maliyalina aito sikaaiyaka go, geya avadimo, tauna anuwokapisiyedi. ");
INSERT INTO gvs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Maniyedi aduwanau goi sima. Neta alatuwokoidi madi loga sisáwala, e nakona maniyedi enao goi bei simataginigini. Tauna anuwokapisiyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Go kidi ina tovatotowanayaoyadi sidigo kadi, ‘Ame yoyowo go! Manakaeda beredi takabidi nakae bei itoboineda ame tomotayadi tavakanidi sikáika gamodi? Geya vatau tayaamo itoboine!’ ");
INSERT INTO gvs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Go kina idigo kana, ‘Aivina imi beredi moedi?’ ‘Geya, ainima aiyuwo’, kidi kaedi. ");
INSERT INTO gvs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tuwo bodayadi ilatuwokoidi poyapoya goi situsobu. Ikavava, berediyadi ainima aiyuwo ikabidi, ikauyagu Yaubada yaina. Ikavava, ikivisidi, ina tovatotowanayao ivinidi bego sikaiguyauyedi. Tuwo moitamo sikabidi sina sikaiguyauyedi tomota yaidi. ");
INSERT INTO gvs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Íyana maniyedi giyaidi nakae sibabanedi, tuwo Yeisu ikabidi, manudi ikauyagu Yaubada yaina namliyeta ina tovatotowanayao ilatuwokoidi iyanayadi nakae sikaiguyauyedi. Tuwo nakae siguinuwe. ");
INSERT INTO gvs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sikaiguyauyedi, boda sikabidi, sikáika gamodi. Sikáika ikavava, valala sikatunokunokudi, bayao gagaidi ainima aiyuwo sikayaoda. ");
INSERT INTO gvs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ego bodayadi adi badabada moe 4,000 nakae. Sikáika ikavava, Yeisu ilatuwokoidi sisáwala. ");
INSERT INTO gvs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E bodayadi sisáwala go, kina mana tovatotowanayao oga sisowoya, sikailova sina Dalimanuta ana dadava. ");
INSERT INTO gvs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Yeisu mana tovatotowanayao sima sivaiu, sisou go, kidi Parisi maniyedi sima Yeisu sikaumakimakiye; latuwodi sivakakone, tuwo sidigo kadi, ‘Aba kinana tayamo kuvatulukōima bei kayagoi kom moitamo Yaubada goi kuma.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Go Yeisu mana kategeda ikalayawoi idigo kana, ‘Tomota ame tomotayadi nakae manakae aba kinana siilusale? Moe sinapu igoyo go, ame alatuuwokoimi konōve: Yaubada geya tayaamo aba kinana bei ivinidi!’ ");
INSERT INTO gvs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ibóbwara ikavava, itáoya, ikalavedi go, iiwo ina oga goi aiyuwoina isowoyamna mana tovatotowanayao sikailova silokoina sina ituli ta dadava. ");
INSERT INTO gvs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sinonoina go, ina tovatotowanayaoyadi sigite beredi sinuwoilave bego sikabi. Beredi tayamo toito oga goi ikaaiyaka, ame tauna. ");
INSERT INTO gvs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Go Yeisu livalakaibala goi ikatumatalidi idigo kana, ‘Ami dodōkana kidi Erodi be Parisi idi isti goi.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ago ina livalayana kidi sitainasiye, tuwo taudiva sibobóbwara kadi, ‘Nakona amo nakae ilatuwokoida unana kita beredi tanuwoilave.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ago Tauyana bogina iyagoi manakaedi sinuwonúwana, tuwo idigo kana, ‘Kaga pasina amitava kobobóbwara bego geya ami beredimo? Nava geya koyagoidokoeta ae? Manakae? Nava dabami sikasa? ");
INSERT INTO gvs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Manakae? Maa matami go, geya kogitegite? Ma taaiyami go, geya konovenove? Geya konuwaisiyeta boi kaga iisowóduwo? ");
INSERT INTO gvs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Boi tutayana beredi ainima goi tomota 5,000 avakanidi go, aivina valala ma bayaoidi kokatunokunoku?’ Tauyadi sidigo kadi, ‘Yawou aiyuwo.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","‘Aiyuwoina boi tutayana beredi ainima aiyuwo goi tomota adi badabada 4,000 avakanidi, aivina valala ma bayaoidi kokatunokunoku?’ Yeisu kaena. Sidigo kadi, ‘Ainima aiyuwo.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ago Tauyana idigo kana, ‘Manakae? Nava ame guinuwayadi adi yagoina geya koyagoidita ae?’ ");
INSERT INTO gvs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E Yeisu mana tovatotowanayao bogina sina Betesaida goi sivaiu, sisou. Sisou go, boda maniyedi tayamo tokebo koroto sime Yeisu yaina goi sikawanoi makimaki sidigo kadi, ‘Tomoya, siyama kubisikōne bei idedevina.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tuwo itáoya tokeboyana nimana ibisikedekede inave asayana goi sisowóduwo go, Yeisu igíwala tokeboyana matana goi namliyeta baige matana ibisikone. Ikavava, ilumadade kana, ‘Kaga itoboinem kugite?’ ");
INSERT INTO gvs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tokeboyana idigo kana, ‘Tomota agitedi. Nakae agitedi sivaabebeo go, adi kaigigita alova nakae.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tuwo aiyuwoina Yeisu ibisibala korotoyana matana ibisikonemneidi, e matanayadi sikatupailala be nakae sidedevina, tauna itoboine kaga liliuna igitedokoidi. ");
INSERT INTO gvs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ago Yeisu idigo kana, ‘Kuseivāta kūna im kasa go, taabu kwaaluvīla asayana goi.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tuwo Yeisu mana tovatotowanayao sitáoya sina Sesariya Pilipai asainao. Sinonoina go, enao goi Yeisu ilumadadedi idigo kana, ‘Tomota sibobóbwara koonovedi manakaedi sinuuwonúwana yau manugu?’ ");
INSERT INTO gvs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","‘Tomota maniyedi sidigodigo bego kom Iyoni tosayóyova. Go maniyedi sidigodigo bego kom Eliyau. Go maniyedi sidigodigo bego kom Yaubada ina tokabivalavala tayamo’, tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Go Yeisu idigo kana, ‘Go komi manakaemi konuwonúwana yau manugu?’ Pita idigo kana, ‘Kom Guyau!’ ");
INSERT INTO gvs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yeisu ikatumatalidi idigo kana, ‘Moe geya vatau tayaamo kolaatuwōko.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tuwo ivatowo ivatulukoidi idigo kana, ‘Tomalatomota gedageda badabadaidi bei ibabanedi. Aiyuwoina tomoyamoya be Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao bei sikatae namliyeta sikaumate go, maliyalina aitonina goi bei itaoyamna.’ ");
INSERT INTO gvs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Moe Yeisu toinina italavaitedoko, tauna Pita itáoya Yeisu ikabi, adi taiyuwo sibala sina masigava goi, e Pita ivatowo Yeisu ibove. ");
INSERT INTO gvs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Go kina Yeisu itugavila ina tovatotowanayao igitedi go, Pita ibove, idigo kana, ‘Kom nuwom geya kuyatoeta Yaubada ina nuwonúwana goi, go sem nuwom kuyato tomota idi nuwonúwana goi. Tauna kom im guinuwa Kaleya nakae. Kūna mligu goi kusabokuliyēgu!’ ");
INSERT INTO gvs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yeisu boda madabokidi ina tovatotowanayao taiyao iduduwedi sima ilatuwokoidi idigo kana, ‘Avatauwa komi neta latuwomi kosabokuuliyegu, toinimi yawoimi kokaasalēdi be nakae toinimi imi kerose kokaavalēdi namliyeta baige kōma kosabokuuliyēgu. ");
INSERT INTO gvs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ame moitamo. Avatauwa bego yawoidi sivagagale, e nava yawoidi vau bei sitagau. Go avatauwa neta yau pasigu be nakae Vala Dedevina pasina yawoidi sitagau, e nava yawoidi vau bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Guna nuwonúwana ataligei. Yawoimi moe dogoi gagaina. Nakae neta poyapoya esaesaina gagaina madabokina kokabi go, yawoimi sitagau vata, e bei kaga ana dedevina? Geya. ");
INSERT INTO gvs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ame moitamo. Neta yawoimi sitagau vata, geya tayaamo kaga ikaaiyaka itoboine bei yawoimiyadi kotalamapuyedi. ");
INSERT INTO gvs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Moitamo. Ame tuta boda Yaubada situgavile be nakae kidi goyo sinadi go, avatauwa neta omayamaya pasina yau silawoiwoiyegu be nakae guna livala silawoiwoiyedi, nava tutayana Tomalatomota Tamana ana káeyana tomoeeyalina ivagiitakoe goi bei ima anerose kimaasabaidi taiyao, e nakae bei ilawoiwoiyedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tuwaina Yeisu idigo kana, ‘U, moe nakae bei isowóduwo go, ame alatuuwokoimi konōve: Tutayana Yaubada ina kalibúbuna mana togaga ima ina bodao ikaliibubudi, e komi maniyemi ameko kootáoya, nava bei maa yawoimi kogite.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Maliyalina ainima tayamo mlidi Yeisu itáoya, Pita, Yemesa be Iyoni ikabidi, aditava sina koya maanawena goi situko. Maeko goi sigite Tauyana ana kaigigita ikanagavila, ");
INSERT INTO gvs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","nakae ana kwama sitomoéyala nakae sivapopowou toina go, ana kaigigita geya vatau tayaamo poyapoya goi itoboine bei kwama ikimavade ana popowou nakae. ");
INSERT INTO gvs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ago Eliyau be Mosese sisowóduwo tauyadi yaidi goi go, Yeisu taiyao sibobóbwara. ");
INSERT INTO gvs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Go Pita iigitedi, tuwo ikaubesobeso idigo kana, ‘Tovatulúkwana Toolagaim, ame dedevina kita ameko takaaiyaka. Manakae? Yoyou aito kayowóidi? Tayamo kom im yoyou, tayamo Mosese ina yoyou, tayamo Eliyau ina yoyou.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitayana geya iyagoiyeta manakaena ibobóbwara. Bogina kuyagoi. Adi taito atedi iyova gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Niga gaota isowóduwo iumaidi go, gaotayana goi níyana tayamo sinove, idigo kana, ‘Ame Natugu, guna kakaya. Tauyana konōve!’ ");
INSERT INTO gvs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Livalayana sinove go, matabuwodi simatavilavila, tauyadi geya sigitedita, go sem Yeisu anetava sigite ikaaiyaka kidi taiyao. ");
INSERT INTO gvs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ikavava, koya goi sisousou go, Yeisu ilovinaedi idigo kana, ‘Kaga koogitedi taabu kotalaavaitēdi ana kadókana Tomalatomota tokámasa yaidi goi itaoyamna.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tuwo ina livala sikabikaone go, taudiva sibobóbwara kadi, ‘Ina taoyamna tokámasa yaidi goi kaga ana yagoina?’ ");
INSERT INTO gvs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Go Eliyau ina sowóduwo pasina tauyadi silumadade sidigo kadi, ‘Kaga unana Yaubada ina Katukeda ana tovatulukwanayao sidigodigo bego Eliyau igimiima namliyeta Guyau bei ima?’ ");
INSERT INTO gvs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yeisu kana, ‘Moe moitamo. Eliyau igimiima bei kaga liliuna iyolimedi Guyau ina sowóduwo manuna. Go Guyauyana manuna manakae Gínina Kimaasabaidi sitalavaita bego Tomalatomota geda badabadaidi bei ibabanedi be nakae tomota bei sikaolilive? ");
INSERT INTO gvs_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Moitamo Eliyauyana igimiima go, ame alatuuwokoimi konōve: Bogina ima go, kaga nakae latuwodi siguinuwe tauyana yaina, e nakae siguinuwe. Moe nakae Gínina Kimaasabaidi sitalavaita tauyana manuna.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pita, Yemesa be Iyoni Yeisu taiyao sisou sina sediyao tovatotówana yaidi go, sikandobala boda gagaina sigitedi ina tovatotowanayaoyadi sitaoyakobudi go, Yaubada ina Katukeda ana tovatulukwanayao tovatotówana taiyao sikaumaakimaki. ");
INSERT INTO gvs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","E sisowóduwo, boda madabokina sikandobala Yeisu sigite, sikainaopa gagaina, tuwo silokoina sima siuyaone. ");
INSERT INTO gvs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ago ilumadadedi idigo kana, ‘Kaga kokaumakiimakiye ame tauyadi taiyao?’ ");
INSERT INTO gvs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Ago koroto tayamo bodayadi sinaedi goi idigo kana, ‘Tovatulúkwana, idi kaumakimaki unana ame: Dimoni boi isiu ikaaiyaka natugu sinaena, tauna maena imoumou. Neta dimoniyana ikiinagove, e ilave isou poyapoya goi be nakae tobuna goi polu iisowóduwo. Aiyuwoina iikagúguta be nakae wowona ikaalitola. Tauna maine tauyana ame bego kuvaite. Go ama, kom geya, tuwo im tovatotowanayao akawanoiyedi bego dimoniyana sivatapiye go, geya itoboinedita.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Go Yeisu idigo kana, ‘Komi tomota manakae? Moitamo numisa geya ae? Tuta maanawena taiyao bogina takaaiyaka go, ava tuta bei konumisedokoigu? Tuta maanawena imi dabakasa aatogage, tauna ava tuta bei konovegu? Tuwo gomanayana kōme!’ ");
INSERT INTO gvs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","E tuwo gomanayana sime go, dimoniyana ikandobala Yeisu igite, e mainao gomanayana ikinagove. Tuwo gomanayana ikapusi isou poyapoya goi ikanasipusípula be nakae tobuna goi polu iisowóduwo. ");
INSERT INTO gvs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Go kina Yeisu ilumadádana gomanayana tamana yaina idigo kana, ‘Aivina tala natum ina sinapu moe nakae?’ ‘Ina tuta gómana goi go, ima ame tuta. ");
INSERT INTO gvs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tuta liliuna kina dimoniyana natugu ilave isou yeu goi o bwae goi bego ikaumate. Tauna, neta ikakapu yaim, e mam nuwokapisi kuvaitema’, tamanayana kaena. ");
INSERT INTO gvs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","E kina go Yeisu kana, ‘Im nanayuwo goi kom kam, “Neta ikakapu yaim.” Iyaa! Kaga liliuna ikakapu tonumisa yaina.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tuwo mainao korotoyana iduduwo kana, ‘Moitamo anumisa go, geya anumisadokoneta. Go neta guna numisa kuvāite!’ ");
INSERT INTO gvs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","E Yeisu boda igitedi silokoina simamaima, tauna dimoniyana ilovinae idigo kana, ‘Kom pasim gómana maena imoumou nakae taiyana patupatuna, tauna alovinaem kukalavevatāe, e geya tuwaina kusiusīu!’ ");
INSERT INTO gvs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tuwo moitamo dimoniyana mana podeda gómana ikinagove, tauna itatátava gagaina go, gomanayana yaina goi isowóduwo ina. Ago gomanayana ana kaigigita tokámasa nakae, tauna boda sigite, sitainasi kadi, ‘Gomanayana bogina ikámasa.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","E kina go Yeisu gomanayana nimana iyoisi, ikaitáoe. E gómana itáoya, bogina idedevina. ");
INSERT INTO gvs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yeisu mana tovatotowanayao sina vada tayamo goi sisiu go, ina tovatotowanayaoyadi taudiva Yeisu silumadade sidigo kadi, ‘Kaga unana geya itoboinemeta amo dimoniyana kavatapiye isiya?’ ");
INSERT INTO gvs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Tauyana idigo kana, ‘Geya tayaamo kaga goi itoboineda dimoni moe nakae tavatapiye go, enao tayamo toito tauna, moe awanoi Yaubada yaina.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Amoko goi Yeisu mana tovatotowanayao sitáoya amo asayana sikalave go, sina Galili parovinsi goi sisiu siketoiya sinonoina Kapaneumi manuna. Go geya latuwona toni kasa siyagoi ikaaiyaka ina vatulúkwana pasina. ");
INSERT INTO gvs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Moitamo. Sinonoina enao goi ina tovatotowanayao ivatuulukoidi kana, ‘Nava bei tomota tayamo itáoya, Tomalatomota inuwotuluye tomota nimadi goi. Ikavava, bei sikabi sikaumate go, ina kaumatayana mlina maliyalina aitonina goi bei itaoyamna.’ Nakae ivatuulukoidi go, boda liliudi nakona bei sitainasi, tauna geya latuwona siyagoi ikaaiyaka. ");
INSERT INTO gvs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Go ina livalayana ina tovatotowanayao geya siyagoiyeta. Ago simatoita bego ina livalayadi manudi silumadade. ");
INSERT INTO gvs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Niga bogina sina Kapaneumi goi go, vada goi sikaaiyaka, Yeisu ina tovatotowanayaoyadi ilumadadedi idigo kana, ‘Kenao goi kaga kokaumakimakiye?’ ");
INSERT INTO gvs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Go tauyadi madi omayamaya situgau. Bogina kuyagoi. Enao goi sikaumakimaki bego avatau yaidi goi toolagaina. ");
INSERT INTO gvs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tuwo Yeisu itusobu, ina tovatotowanayao yawou aiyuwo iduduwedi sima ilatuwokoidi idigo kana, ‘Avatauwa yaimi goi bego toosakidi, tauyadi itoboinedi bei toosobudi tomota liliudi yaidi goi be nakae tomota liliudi adi tovaita.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gómana tayamo ikabi, matadi goi ivatáoe. Ikavava, ivaayavau go, ina tovatotowanayaoyadi ilatuwokoidi idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‘Avatauwa neta toosobudi gómana ame nakae yau yoigu goi siiuyaone, e yau nakae siuyaaonegu. Go avatauwa neta siuyaaonegu, agu toetuna nakae siiuyaone.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Go Iyoni idigo kana, ‘Tovatulúkwana, koroto tayamo kagite kom yoim goi dimoni ivataapiyedi go, tauyana kita taiyao geya, tauna kapoikiki bego kasanabode.’ ");
INSERT INTO gvs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","E kina go Yeisuyana idigo kana, ‘Taabu kosaanabōde. Geya vatau tayaamo mainao yoigu goi guinuwa toogagaidi iguinuwedi go, namliyeta itagiwoigu. ");
INSERT INTO gvs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Moe moitamo. Avatau neta geya ivakaleyedeta, e tauyana ivaiteda. ");
INSERT INTO gvs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kogita. Avatauwa neta bwae sivanimmi unana komi yoimi Guyau ina bodao go, neta ame tauna siguinuwe, e ame alatuuwokoimi konōve: Adi vaiwówana nava bei sibabane. ");
INSERT INTO gvs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Avatauwa neta tayamo toosobuna guna tonumisayao yaidi goi sivakapusiye, e liuna gagaina toina bei sibabane. Neta gurewa gagaidi sikabidi, nukotodi goi sisikoidi go, tauyadi silavedi sisou sina négwasa goi sisalili, moe liuna giiyaina, go sem Yaubada ina liuna bei gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Go ava nímana ami píkwana ana toyomátula, e kokūpo kokalāve. Neta ma nimakuuponimi go, yawoimi vata kobabane, e moe dedevina, go sem neta ma nimayuwoyuwoimi silavemi kosou asagabugabu ana yeu sabenínima vaatayaina goi, e moe igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Ava káena ami píkwana ana toyomátula, e kokūpo kokalāve. Neta ma kaekuuponimi go, yawoimi vata kobabane, e moe dedevina, go sem neta ma kaeyuwoyuwoimi silavemi kosou asagabugabu goi, e moe igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Matami nakae. Ava mátana ami píkwana ana toyomátula, e kokipōsi kokalāve. Neta mata tayataya go, Yaubada ina kalibúbuna kosiu, e moe dedevina, go sem neta mata yuwoyuwo sikabimi silavemi kosou asagabugabu goi, moe igoyo toina. ");
INSERT INTO gvs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Amoko goi Yaubada ina liuna ikaiyako vata. Nakae motemoteta tomata yaidi goi geya sikamaseta be nakae yeu geya ikamaseta. ");
INSERT INTO gvs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yaubada yeu bei isiwoi soroti nakae tomota liliudi yaidi goi, adi kimavada manuna o adi vailai manuna. ");
INSERT INTO gvs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Soroti dedevina go, neta ina togaga ikavava, manakaemi koguinuwe bei idedevinamna? Geya ae? Komi nakae. Kotagōna soroti ikaiyako vata yaimi, o tadigo kada, “Bei taiyao kotuboina.”’ ");
INSERT INTO gvs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E amoko goi Yeisu itáoya, mana tovatotowanayao amo asayana sikalave go, sina sákala Iyoridani goi sisaidámana sina bomatu dadavina, e sinonoina Yudiya ana dadava manuna. Go boda gagaina aiyuwoina sitaligógana simamaima Tauyana yaina. Tuwo, nakae ina sinapu aiyuwoina ivatuulukoidi. ");
INSERT INTO gvs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ivatuulukoidi go, kidi Parisi sima bego Yeisu sikatutao, sidigo kadi, ‘Manakae? Ida lovina goi koroto mana tagona monena ivaisobuye gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E Yeisu idigo kana, ‘Mosese ava lovina boi tubudao ivinidi vaisobu manuna?’ ");
INSERT INTO gvs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","‘Mosese itagona neta koroto latuwona monena ivaisobuye, e ana katae igini. Ikavava, monenayana ivini, ivaisobuye’, Parisi kaedi. ");
INSERT INTO gvs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","E kina go Yeisu idigo kana, ‘Imi dabakasa pasina moe lovinayana Mosese iginigini manumi. ");
INSERT INTO gvs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Go boi nimatu tuta ana kaba vatowo goi, e moe nakae geya. Gínina Kimaasabaina kana, “Yaubada tomota iwodugudi; tomotayadi koroto be vavina iwodugudi. ");
INSERT INTO gvs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E tauna moe pasina koroto tamana be sinana yaidi itumasaba go, monena taiyao situyuwo ");
INSERT INTO gvs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tauna adi taiyuwokova wowodi tayamo.” Aba Vatowo 2:24 Tauna geya tuwaina kada tauyadi tomota adi taiyuwo, go sem ame tuta tauyadi wowodi tayamo. ");
INSERT INTO gvs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tauna avatauwa neta Yaubada nai goi ivatuyuwedi, e tomota taabu sivatumaasabēdi.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Niga vada goi Yeisu mana tovatotowanayao sikaaiyaka, e ina tovatotowanayao silumadádana ina bóbwara vaisobu manuna. ");
INSERT INTO gvs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tauyana idigo kana, ‘Ava koroto neta monena ivaisobuyebeso bego inaidámana ituli ta vavina yaina, e bogina iroerata. ");
INSERT INTO gvs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ago vavina neta monena ivaisobuyebeso bego inaidámana ituli ta koroto yaina, e bogina iroerata.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Niga tomota maniyedi natudiyao giyaidi siimemedi Yeisu yaina goi bego ibisikonedi ikaipakuyedi. Go kidi ina tovatotowanayaoyadi sitáoya sibowoidi kadi, ‘Taabu kononōina Yeisu yaina.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Go kina Yeisu igitedi, gamona igoyo, idigo kana, ‘Gogomanayadi taabu kosanaabodēdi, go sem kotagonēdi sima yaigu. Tomota nuwotookaidi ame tauyadi nakae Yaubada ina kalibúbuna sinaena goi bei sisiu. ");
INSERT INTO gvs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ame moitamo, tauna ame alatuuwokoimi konōve: Avatauwa komi neta Yaubada ina kalibúbuna kouuyaone gogómana nakae, e itoboinemi alibubunayana sinaena goi kosiu.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tuwo gogomanayadi ivayavaudi go, dabadi iyoisidi, e ikaipakuyedi. ");
INSERT INTO gvs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Niga Yeisu itáoya bego ina go, koroto tayamo ilokoina ima Yeisu matana goi aena ivatugúyala, idigo kana, ‘Tovatulúkwana, kom todedevim. Ava guinuwa aguuinuwe bei yawoigu vata ababane?’ ");
INSERT INTO gvs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","E kina go Yeisuyana idigo kana, ‘Kaga unana bego kuvayokoigu yau todedevigu? Tayamo anetava todedevina go, moe Yaubada. ");
INSERT INTO gvs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yaubada ina lovina bogina kuyaagoidi ae? Idigo kana, “Taabu kokaaumāta; taabu korooerāta; taabu kovaaināwana; taabu kotalavaita polapōla; taabu koovāobuna; tamamiyao be sinamiyao kowowooinēdi.”’ ");
INSERT INTO gvs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","‘Tovatulúkwana, moe lovinayadi madabokiidi lavayana yau boi gómana go, ima ame tuta, bogina akabikaaonedi’, korotoyana kaena. ");
INSERT INTO gvs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E kina go Yeisu idobala korotoyana idumaakavate go, imatakoiye, e idigo kana, ‘Go tayamo guinuwa kukiseeyeseye. Kūna konam liliudi kwaigimonēdi go, maisadi kwabīdi, kūna tookaidi yaidi goi kwaiguyauyēdi, e yábana goi bei kom mam esaesa. Kwaiguyauyedi ikavava, kūma kusabokuuliyēgu.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","E kina go korotoyana nukotona taitáiya iuyoi Yeisu ina livala pasina, tuwo mana nuwomou ina. Bogina kuyagoi. Tauyana konana badabadaidi go, nukotona iyoi. ");
INSERT INTO gvs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","E Yeisu imatavilavila go, ina tovatotowanayao ilatuwokoidi idigo kana, ‘Kidi madi esaesa idi siu Yaubada ina kalibúbuna goi moumou isaki.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","E kidi go ina tovatotowanayaoyadi ina livala pasidi nukotodi siwowówana. E Yeisu aiyuwoina ilatuwokoidi idigo kana, ‘Natugowo, Yaubada ina kalibúbuna ana siu moumou isaki. ");
INSERT INTO gvs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kameri yoguyogu gagaina, tauna geya itoboineyeta siláluma taporaina goi isiu ae? Ago toesaesa nakae. Bego Yaubada ina kalibúbuna sinaena goi sisiu go, geya itoboinedita, geya toina.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","E tauyadi nukotodi siwówana gagaina toina ina livala pasidi, tauna taudiva sibobóbwara kadi, ‘Iyaa! Neta toesaesa geya itoboinedita yábana goi sisiu, avatau itoboine ana yava ibabane?’ ");
INSERT INTO gvs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeisu iipotedi go, idigo kana, ‘Tomota yaidi goi moe geya itoboineyeta, go sem Yaubada yaina goi itoboine. Moitamo. Yaubada yaina goi kaga liliuna sikakapu.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Go kina Pita idigo kana, ‘Go kai bei manakaema? Kai kaga liliuna yaima bogina kakalavedi go, kama kasabokuuliyem.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yeisu idigo kana, ‘Moitamo kaga liliuna bogina kokalavedi go, ame alatuuwokoimi konōve: Avatau neta ina vada o senao o niunao o sinana o tamana o natunao o ina kaba lovina ikalavedi yau pasigu be nakae Vala Dedevina pasina, ");
INSERT INTO gvs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","e ame tuta goi ana katumapu ivakaigaga toina bei ibabane. Nakae vada, senao, niunao, sinanao, natunao be aba lovina go, moe mou taiyao bei ibabanedi. Ago tuta imamaima yawoina vata bei ibabane. ");
INSERT INTO gvs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","E badabadaidi ame tuta toolagaidi go, nava bei tauyadi toosobudi. Badabadaidi ame tuta toosobudi go, nava bei tauyadi toolagaidi.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","E Yeisu mana tovatotowanayao situko sinonoina Yerusalema manuna go, enao goi Yeisu ivakumgo inonoina. Kidi ina tovatotowanayaoyadi siyagoi Yeisu latuwona ina Yerusalema, tauna nukotodi siwówana. Ego boda Yeisu mlina sisabookuliye simatoita. E enao goi sinonoina go, Yeisu ina tovatotowanayao yawou aiyuwo aiyuwoina aditava iduduwedi sima, ilatuwokoidi kaga kaga bei siisowóduwo yaina. ");
INSERT INTO gvs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Idigo kana, ‘Konovēgu. Ame tuta tatukotuko Yerusalema manuna go, maeko goi tomota tayamo bei itáoya Tomalatomota inuwotuluye Tonúwala Gagaidi be nakae Yaubada ina Katukeda ana tovatulukwanayao nimadi goi, gobe Tauyana sitakino ámasa goi. Sitakino ikavava, Tauyana bei sikabi, Totuyoyowo nimadi goi siyato. ");
INSERT INTO gvs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ago kidi Totuyoyowoyadi bei sivaponuponuye, sigiwoli, sidabi be nakae sikaumate go, maliyalina aitonina goi bei itaoyamna.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","E Sebedi natunao, Yemesa be Iyoni, sima Yeisu yaina sidigo kadi, ‘Tovatulúkwana, latuwoma bego kaga kakawanoiye yaim, e kom kuguinuwe manuma.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","‘Kaga latuwomi aguinuwe manumi?’ Yeisu kaena. ");
INSERT INTO gvs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","E tauyadi kadi, ‘Neta kutagonēma bego tutayana im kalibúbuna goi am káeyana kuvagitakoe, latuwoma kai katusobu kébana dedevidi kikim, tayamo kakataim go, tayamo kekelim.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","E kina go Yeisu idigo kana, ‘Imi kawanoi ana yagoina komi geya koyagoiyeta. Gedageda keigaina goi bei anim go, manakae? Komi itoboinemi nakae konim, gea geya? Nakae gedageda ivakaigaga bei alotowo go, manakae? Komi itoboinemi nakae kolotowo, gea geya?’ ");
INSERT INTO gvs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","‘Itoboinema’, kaedi. E kina go Yeisu idigo kana, ‘Moitamo. Keigayana goi bei anim komi bei konim. Aiyuwoina gedagedayana bei alotowo, komi bei kolotowo. ");
INSERT INTO gvs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Go yau geya agu lovinamo alovina bego avatau kakataigu o kekeligu goi itusobu, go sem aba tusobuyadi Yaubada bogina ikatubayasidi tauyadi kiinavaidi manudi.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ago tutayana ina tovatotowanayao yawou sinove kaga sediyao Yemesa be Iyoni sikawaanoiye, e siegamogamoguyedi. ");
INSERT INTO gvs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tuwo yawou aiyuwo Yeisu iduduwedi sima ilatuwokoidi idigo kana, ‘Bogina koyagoi tauyadi tomota sikiinanedi Totuyoyowo adi tolovinayao siilovina makimaki Totuyoyowoyadi yaidi goi. Nakae toolagaidi idi lovina toogagaina siguuinuwe makimaki tomota yaidi. ");
INSERT INTO gvs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ago komi yaimi moe nakae geya, go sem avatauwa yaimi goi bego toolagaidi, tauyadi itoboinedi komi ami tovaitayao nakae silovina. ");
INSERT INTO gvs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nakae avatauwa yaimi goi bego toosakidi, tauyadi itoboinedi idi lovina goi komi liliumi yaimi imi pakonayao nakae. ");
INSERT INTO gvs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tomalatomota nakae, tauna komi nakae itoboinemi. Tauyana ima geya kada bego tomota sivaite geya, go sem Tauyana ima bego tomota ivaitedi. Yawoina moe tomota adi kaba tateta go, yawoinayana toinina ikasale ámasa goi, tomota liliudi adi katumapu.’ ");
INSERT INTO gvs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Niga Yeisu mana tovatotowanayao sima Yeriko. Tutayana Yeriko sikalave, boda gagaina taiyao sinonoina go, tokawanoi tayamo ma matakebokeboina enao kikina goi iitusobu iiduduwo; tauyana Timiyo natuna yoina Batimiyo. ");
INSERT INTO gvs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tauyana vala inove bego Yeisu guma Nasareta ikaaiyaka. Tuwo iduduwo idigo kana, ‘Yeisu, Devida tubuna, kunuwokapisiyēgu!’ ");
INSERT INTO gvs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Go tomota maniyedi sikaaiyaka tokeboyana siboove kadi, ‘Kom kumaigāu!’ Go kina tokeboyana tuwaina iiduduwo kana, ‘Devida tubuna, kunuwokapisiyēgu!’ ");
INSERT INTO gvs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tuwo Yeisu itáoya idigo kana, ‘Tauyana kodudūwe ima.’ Tuwo moitamo sina tokeboyana siduduwe sidigo kadi, ‘Tauyana iduuduwem. Tauna kwatepātu go, kutāoya!’ ");
INSERT INTO gvs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","E moitamo ana tanigo inisi ikalave go, ikabitaotáoya ima Yeisu yaina goi. ");
INSERT INTO gvs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ima, Yeisuyana idigo kana, ‘Kaga go bei avekoim?’ ‘Tovatulúkwana toolagaim, bego agita dókana’, tokeboyana kaena. ");
INSERT INTO gvs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yeisu idigo kana, ‘Kūna im kasa. Im numisa pasina bogina matam sidedevina.’ Tuwo mainao igita dókana, e ivatowo enao goi Yeisu isabokuliye. ");
INSERT INTO gvs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","E tutayana bogina Yerusalema goi sivakakana, e sina asa Betapegi be Betani Oribe Koyaina papanaina goi. Go Yeisu ina tovatotowanayao adi taiyuwo ivamoleyedi sina asa goi. ");
INSERT INTO gvs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Go mainao ilatuwokoidi idigo kana, ‘Kōna asa amo matada goi go, tutayana kosiu, ase bonatuna siikonina bei kobabane. Bonatunayana goi geya vatau tayaamo itulagakone. E kobabane, kotaligēi kōme yau yaigu. ");
INSERT INTO gvs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Go avatau neta ilatuwokoimi idigo kana, “Kaga unana moe koguuinuwe?” Komi kodīgo kami, “Tomoya latuwona iepaisewe, e mainao bei ietunemnei ima.”’ ");
INSERT INTO gvs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tuwo adi taiyuwokova sina asayana goi sisiu, ase bonatuna tayamo sibabane enao goi iitáoya, siikonina vada ana kali ana kaba siu goi. ");
INSERT INTO gvs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Sitaaligei go, tomota maniyedi amoko goi sikaaiyaka sidobala ina tovatotowanayaoyadi sigitedi, tuwo sidigo kadi, ‘Kaga unana ase bonatuna kotaaligei?’ ");
INSERT INTO gvs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Adi taiyuwokova silatuwokoidi nakae Yeisu idige. Tuwo tokaiyako sitagona aseyana sikabi. ");
INSERT INTO gvs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Sikabi, sime Yeisu yaina goi go, adi tanigo sivalilividi aseyana toluna goi sisekulidi. Ikavava, Yeisu itulaga. ");
INSERT INTO gvs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Boda maniyedi sima adi tanigo sivalilividi enao goi sieveidi. Go maniyedi magimagi gigidi bogina siiutudi simedi, e enao goi sieveidi. ");
INSERT INTO gvs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Go boda Yeisu sivaakitau, maniyedi matana goi, maniyedi mlina goi. Sivaakitau go, siiduduwo kadi, ");
INSERT INTO gvs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tauyana ina kalibúbuna tubuda Devida nakae ");
INSERT INTO gvs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yeisu boda taiyao siketoiya sina Yerusalema goi sisiu. Sisiu, Yeisu ina Vada Kimaasabaina ana kali sinaena goi isiu, imatavilavila. Ikavava, isowóduwo go, asa bogina lavilavi, tauna mana tovatotowanayao yawou aiyuwo asayana goi sisowóduwo sikaluvila sina Betani. ");
INSERT INTO gvs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Niga vanuwo itomo, sitáoya Betani sikalave siiketoiya go, Yeisu loga ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ikandobala tupwana aduwanau goi lao tayamo igite bogina idugo. Tuwo ibala ina igite nakona ikéuwo gea geya. Go ima, ikandolaga igite geya keuwoinamo, go sem vaga kaka. Bogina kuyagoi. Amo tutayana moe geya lao ana tuta geya. ");
INSERT INTO gvs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tuwo ikatubolate idigo kana, ‘Kom bei geya kuukēuwo!’ Go ina livalayana kidi ina tovatotowanayao bogina sinove. ");
INSERT INTO gvs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kidi Yeisu sima Yerusalema goi sisiu. Sisiu sina Vada Kimaasabaina ina kali goi sisiu go, Yeisuyana ivatowo tokaigimona be togimona ivatapiyedi sisiya. Ago mani ana totalamapuyao idi teboro be bunabuna adi tokaigimonayao idi kaba tusobu nakae ikausepaledi. ");
INSERT INTO gvs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Geya tayaamo tomota itagone bego konana tayamo iikavale Vada ana kaliyana goi iivaupa. ");
INSERT INTO gvs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","E ikausepaledi ikavava, ivatowo ivatulukoidi idigo kana, ‘Komi bogina koyagoi Gínina Kimaasabaina Yaubada manuna italavaita idigo kana, “Guna vada moe boda liliudi adi kaba kawanoi.” Aiseya 56:7 Go komi koyatako tovaináwana idi kaba tamumu.’ ");
INSERT INTO gvs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ago kidi Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao sinove Yeisu manakaena ibóbwara, tuwo enao siilusala bei manakaedi Tauyana sikaumate. Bogina kuyagoi. Tauyana simaatoite unana boda gagaina nukotodi sikabi. Moitamo. Ina vatulukwanayana pasina kidi boda madabokidi nukotodi siwowówana gagaina. ");
INSERT INTO gvs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Go maliyalina tamo tamo goi neta bogina lavilavi toina, e Yeisu mana tovatotowanayao asa Yerusalema siikalave. ");
INSERT INTO gvs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Itomo nobuyana nava matagougouna tauyadi sitáoya, siketoiya sinonoina bego Yerusalema go, laoyana sigite lamna goi ituko ina sipona goi bogina ivadiwówana. ");
INSERT INTO gvs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tuwo kina Pita Yeisu ina katubolatayana inuwopeye, tauna Yeisu ilatuwoko idigo kana, ‘Tovatulúkwana Toolagaim, laoyana boile kukatuubolate kugīte, bogina ivadiwówana.’ ");
INSERT INTO gvs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Go kina Yeisu idigo kana, ‘Yaubada koonumīse. ");
INSERT INTO gvs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Moitamo toina! Ame alatuuwokoimi konōve: Avatau neta koya ame ilatuwoko kana, “Yaubada ikabim ilavem kusōu négwasa goi” go, nuwona goi geya inanayuwoita, go sem iinumisa bego kaga iivatoi moitamo bei isowóduwo, e nakae bei isowóduwo tauyana manuna. ");
INSERT INTO gvs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Moe pasina tauna ame alatuuwokoimi konōve: Kaga liliuna kokawaanoiye Yaubada yaina, konumīsa bego dogoiyana bei kobabane, e moitamo bei kobabane. ");
INSERT INTO gvs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ago tutayana kotáoya bei kokawanoi, neta tomota idi bágala yaimi goi sikaaiyaka, e bagalayadi konuwotaōidi bego Tamada guma yábana nakae bei imi bágala inuwotaoidi.’ ");
INSERT INTO gvs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aiyuwoina sima Yerusalema goi sisiumna go, sina Vada Kimaasabaina ana kali goi sisiu. Sisiu, sinaena Tauyana ivaabebeo go, kidi Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao be Diyuu idi tomoyamoya sima ");
INSERT INTO gvs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tauyana silumadade sidigo kadi, ‘Avatau ina lovina goi moe guinuwayadi kuguuinuwedi? Nakae avatau itaagonem kuguuinuwedi?’ ");
INSERT INTO gvs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","E kina go Yeisuyana idigo kana, ‘Yau nakae lumadádana tayamo alumadademi. Kokatumāpu, bei alatuwokoimi avatau ina lovina goi ame guinuwayadi aguuinuwedi. ");
INSERT INTO gvs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Guna lumadadanayana ame nakae: Iyoni ina sayóyova moe Yaubada ina lovina goi gea tomota idi lovina goi? Kokatumāpu.’ ");
INSERT INTO gvs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tuwo kidi aditava sibobóbwara kadi, ‘Bei manakaeda? Neta kada, “Yaubada goi”, e Tauyana bei kana, “Moe moitamo! Tauna kaga unana geya konumiseyeta?” ");
INSERT INTO gvs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Go sem neta kada, “Tomota goi”, e boda bei manakaedi?’ Ame tauyadi boda simatooitedi seki kaga bei sivekoidi. Bogina kuyagoi. Boda liliudi sinuwonúwana Iyoni moitamo toina tokabivalavala tayamo. ");
INSERT INTO gvs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tuwo Yeisu silatuwoko sidigo kadi, ‘Geya kayagoiyeta avatau ina lovina goi.’ Go kina Yeisu idigo kana, ‘Yau nakae, geya alatuwokoimita avatau ina lovina goi ame guinuwayadi aguuinuwedi.’ ");
INSERT INTO gvs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","E Yeisu ivatowo livalakaibala goi Diyuu idi tolovinayao ivatulukoidi idigo kana, ‘Koroto tayamo ina tánuwo goi oine kaka ibaguli. Ibaguli ikavava, gurewa ikabidi tanuwoyana ana kali ikaudakodako. Ikavava, oine ana kaba vavetaveta ogalaoina goi bobosiu ieli oine ana kaba saligógana manuna. Ikavava, tanuwoyana sinaena vada aba yáusa tayamo maanawena iyowo ituko ina. Iyowo ikavava, koroto maniyedi itagonedi tanuwoyana sikatoguye go, niga dibayoya ana tuta oine keuwoina maniyena bei toni tánuwo siemaisi. Tuwo tokatoguyadi sikaaiyaka tánuwo sipaaisewa go, kina toni tanuwoyana itáoya ina ituli ta dadava. ");
INSERT INTO gvs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Go ina pákwana tayamo dibayoya ana tuta goi ietune ina ina tánuwo ana tokatoguyao yaidi goi bego tánuwo ana takona oine maniyena ikabidi imedi. ");
INSERT INTO gvs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ago imamaima, kidi tokatoguyadi siyoisi, siláui. Siláui ikavava, nima kaka sietunemnei ina toni tánuwo yaina goi. ");
INSERT INTO gvs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tuwo toni tanuwoyana ina pákwana aiyuwoina ietune ina tokatoguyao yaidi goi go, siyoisi, dabana siláui be nakae sigieomaemae. ");
INSERT INTO gvs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tuwo ina pákwana aitonina ietune ina go, sikaumate. Tauna nakae iisowóduwo toni tánuwo ina pakonayao koroto badabadaidi yaidi; maniyedi silauidimo, maniyedi sikauumatedi. ");
INSERT INTO gvs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Go tayamo toito nava ikaaiyaka, toni tánuwo natuna, ana kakaya. Inuwonúwana kana, “Tuwo bokoyo natugu bei aetune ina. Nakona bei tauyana sigite odi imayamaya.” Tuwo moitamo natunayana moe aba lukavava ietune ina. ");
INSERT INTO gvs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","E ina go, amo tokatoguyadi aditava sibóbwara kadi, “Amo toni tánuwo natuna imamaima. Tauyana tamana ana katumapu. Tuwo ima, tayōisi takaumāte bei tanuwoyana kita ida kaba lovina.” ");
INSERT INTO gvs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tuwo moitamo tauyana ima kikidi, e siyoisi sikaumate. Ikavava, silave ina takiki goi. ");
INSERT INTO gvs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tauna tomoyayana, moe toni tánuwo, bei kaga iguinuwe tokatogu yaidi goi? Bei ina ikaumatedi go, ituli ta tokatogu dedevidi bei itagonedi tanuwoyana simatakavate. ");
INSERT INTO gvs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Go manakae? Ame tomwanayana Gínina Kimaasabaina goi konuuwaisi gea geya? Tomwanayana Guyau manuna idigo kana, ");
INSERT INTO gvs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ame Yauwe ina guinuwa go, ");
INSERT INTO gvs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Go kidi Tonúwala Gagaidi be Yaubada ina Katukeda ana tovatulukwanayao be Diyuu idi tomoyamoya enao siilusala bei Yeisu siyoisi go, boda simatoitedi. Moitamo. Tonuwalayadi, tovatulukwanayadi be tomoyamoyayadi bogina siiyagoi bego Yeisu ina livalakaibala goi iidigedi, e boda nakae bogina sinove, tauna nakona kaga bei sivekoidi. Go enao geya, tuwo Tauyana sikalave sina. ");
INSERT INTO gvs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","E tuwo Diyuu adi tolovinao Parisi maniyedi be nakae Erodi ina bodao sietunedi sima Yeisu bego ina livala goi sikatutao. ");
INSERT INTO gvs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","E sima Yeisu silatuwoko sidigo kadi, ‘Tovatulúkwana, bogina kayagoim bego kom moitamo be nakae kom tomota geya kutagonedita nuwom siikobale. Moitamo. Tomota kuwowooinedi geya adi kaigigita goi geya, tauna geya kunuwonuwoneta tomota manakaedi sinuwonúwana im vatulúkwana manuna geya, go sem Yaubada ina kenao kuvatulukwana dókana. Tauna manakae? Itoboine kita tatakisi Sisa yaina gea geya? Manakaem kunuwonúwana, takisi tavini gea tuwo?’ ");
INSERT INTO gvs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","E idi pola bogina iiyagoi, tauna idigo kana, ‘Komi manakae bego kokatutaoigu! Mani tayamo kokābi kōme agite.’ ");
INSERT INTO gvs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","E tayamo sikabi sime go, Yeisu idigo kana, ‘Mani ame goi avatau makayauna be nakae yoina?’ ‘Sisa’, tauyadi kaedi. ");
INSERT INTO gvs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","E kina go Yeisuyana idigo kana, ‘Moe moitamo. Tauna kaga neta Sisa konana, e Sisayana tavīni go, kaga neta Yaubada konana, e Yaubadayana tavīni.’ Tauyadi sikainaopa ina katumapu pasina. ");
INSERT INTO gvs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","E Sadusi maniyedi sima Yeisu yaina. Tauyadi sidigodigo tokámasa geya sitaoyamneta. E sima bego Yeisu sikatutao sidigo kadi, ");
INSERT INTO gvs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","‘Tovatulúkwana, boi nimatu ida lovina Mosese igini idigo kana, “Koroto nainaina neta geya natunamo go, ikámasa, e aena vavilaina itoboine kobuina inai. Niga neta vavinayana ivenátuna, natunao moe tokámasa ana katumapu.” ");
INSERT INTO gvs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tayamo aba gita ame nakae: Koroto adi badabada adi tainima adi taiyuwo sinadi tayamo sikaaiyaka. Botomoya igiminai go, geya natunamo ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tuwo aena vavilaina itáoya, tuwowona kobuina ikabi inai go, niga geya natunamo ikámasa. Niga amo tauyana aena vavilaina itáoya, tuwowona kobuina ikabi inai go, nakae geya natunamo ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tauna nakae korotoyadi adi tainima adi taiyuwo. Vavinayana sinai go, geya natudimo sikámasa. Korotoyadi liliudikova sikamasa kówasa, namliyeta baige vavinayana nakae ikámasa. ");
INSERT INTO gvs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tauna neta moitamo tomota ámasa goi sitaoyamna, e amo tutayana goi tauyadi nakae bei sitaoyamna go, korotoyadi yaidi ava koroto moe vavina monena mooitamoina? Bogina kuyagoi. Korotoyadi adi tainima adi taiyuwo boi mainao nava maa yawoidi go, vavinayana liliudi sinai.’ ");
INSERT INTO gvs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Go kina Yeisuyana idigo kana, ‘Ame pasina komi kobágala: Gínina Kimaasabaidi geya koyagoidita be nakae Yaubada ina togaga geya koyagoiyeta! ");
INSERT INTO gvs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tutayana tokámasa sitaoyamna, koroto be vevina nai geya, go sem idi kaiyaka anerose yábana goi nakae; tauyadi nai geya. ");
INSERT INTO gvs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ego tokámasa adi kaitáoya manuna, Mosese ina buki goi tauyana tetelina ikaaiyaka go, manakae? Geya kokatuyaiviyeta ae? Boi ikaaiyaka go, yeu taliboibo sinaena Yaubada isowóduwo Mosese ilatuwoko idigo kana, “Yau tubumowo Eberamo, Aisake be Yakobo idi Yaubada.” ");
INSERT INTO gvs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Moeko goi taayagoi tauyadi maa yawoidi yábana goi Yaubada yaina sikaaiyaka. Tauna Yaubada kina geya kada tokámasa idi Yaubada geya, go sem tauyadi maa yawoidi idi Yaubada. Moitamo. Komi kobágala gagaina. Tokámasa moitamo bei sitaoyamna.’ ");
INSERT INTO gvs_vpl VALUES