﻿USE sofia;
DROP TABLE IF EXISTS sofia.gvr_vpl;
CREATE TABLE gvr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gvr_vpl WRITE;
INSERT INTO gvr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ताँन् भन्दा ओंसों परमेश्‍वरजी मु नेरो पृथ्बी बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","पृथ्‍बी छाबन् मुँ बिब था आसेल धै तोइ आरेल। मा ङ्युँइए फिर मिछु खैरिमल। धै परमेश्‍वरए प्ल्ह क्‍युए फिर स्‍युररिमल। ");
INSERT INTO gvr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","झाइले परमेश्‍वरजी “मि म्रोंयाँरिगे” बिमा मि म्रोंयाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","धै परमेश्‍वजी मि म्रोंबलाइ ङ्‍ह्‍योमा च छ्याँब मुँल। खीजी मि म्रोंब नेरो आम्रोंब स्‍यो-स्‍यो लइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","परमेश्‍वरजी मि म्रोंबने “त्‍हिंइ” बिइ, धै मिछु खैबने “म्‍हुँइसा” बिइ। ङेसा तइ धै न्‍हाँग तइ, च ओंसोंबै त्हिंइ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","झाइले परमेश्‍वरजी बिइ, “क्‍युए म्‍हाँजोर क्ल्‍ह्‍यो घ्रि तरिगे, धै चइ क्‍यु ङ्हिंबाँ लरिगे,” बिमा ");
INSERT INTO gvr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","परमेश्‍वरजी बनेसि च क्ल्‍ह्‍योए न्‍होंर्बै नेरो फिर्बै क्यु स्‍यो-स्‍यो लमिंमा छान् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","परमेश्‍वरजी च फिर्बै क्ल्‍ह्‍योने “मु” बिइ। ङेसा तइ धै न्‍हाँग तइ, च ङ्हिरोबै त्हिंइ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","झाइले परमेश्‍‍वरजी बिइ, “मुए न्‍होंर्बै क्यु क्ल्‍ह्‍यो घ्रिर खागु तयाद् धै ओबानो क्ल्‍ह्‍यो म्रोंयाद्!” बिमा छान् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","परमेश्‍वरजी ओबानो क्ल्‍ह्‍योने “पृथ्‍बी” बिइ, धै खागु तबै क्‍युने “मा ङ्युँइ” बिइ। धै परमेश्‍वरजी ङ्ह्‍योमा च छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","झाइले परमेश्‍वरजी बिइ, “सइ ट्हा-ट्हुमैं, प्‍लु तबै रो-रोबै धुँमैं नेरो खें-खेंमैंन् पाह्रसि प्लु तबै सिंधुँमैं म्‍लोरिगे,” बिमा छान् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","सइ ट्हा-ट्हुमैं, प्‍लु तबै धुँमैं नेरो खें-खेंमैंन् पाह्रबै ल्हें खालर्बै प्लु तबै सिंधुँमैं म्‍लोमिंइ। धै परमेश्‍वरजी ङ्ह्‍योमा च छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ङेसा तइ धै न्‍हाँग तइ, च सोंरोबै त्हिंइ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","परमेश्‍वरजी धबै बिइ, “मुर त्‍हिंइ नेरो म्‍हुँइस फेलबर चारबै सैमैं तरिगे। चमैंइ चाडमैं, त्हिंइमैं, बर्षमैं फेलबै केमैं लरिगे, ");
INSERT INTO gvr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","धै पृथ्बीर मि म्रोंल् लमिंबर च सैमैं मुर तरिगे,” बिमा छान् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","झाइले परमेश्‍वरजी बेल्‍ले थेबै चारबै सै ङ्हिं बनेइ। थेबै चारबै सै त्हिंइर प्रेबै ल्हागिर नेरो च्‍योंबै चारबै सै म्हुँइँसर प्रेबर बनेइ। धै खीजी मुसारमैं या बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","झाइले पृथ्बीर मि म्रोंन् लमिंबर, ");
INSERT INTO gvr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","त्हिंइ नेरो म्‍हुँइँसए फिर क्‍ल्‍हे तबर, धै मि म्रोंब नेरो मिछु खैब स्यो-स्यो लबर परमेश्‍वरजी च चारबै सैमैं मुर थेंमिंइ। खीजी ङ्ह्‍योमा च छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ङेसा तइ धै न्‍हाँग तइ, च प्लिरोबै त्हिंइ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","परमेश्‍वरजी बिइ, “क्‍युर सो प्ह्‍याबै सैमैंइ प्‍लिंरिगे धै नमेंमैं मुर प्‍हुररिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","छतसि मा ङ्युँइर थे-थेबै क्युर टिबै सैमैंइ प्लिंइ धै सर प्रबै स्यो-स्योबै सो प्ह्‍याबै ताँन् सैमैं नेरो प्ह्‍या प्‍ह्‍याबै नमेमैं या परमेश्‍वरजी बनेइ। झाइले परमेश्‍वरजी ङ्ह्‍योमा चमैं छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","झाइले परमेश्‍वरजी चमैंने “प्हारदै रोदै ल्हें तदै मा ङ्युँइर प्‍लिंदै ह्‍याद्। छलेन नमेंमैं या पृथ्बीर ल्हें तदै ह्‍यारिगे,” बिसि आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ङेसा तइ धै न्‍हाँग तइ, च ङ्‍हरोबै त्हिंइ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","परमेश्‍वरजी बिइ, “पृथ्‍बीइ स्यो-स्योबै धिंर न्‍हबै खेदोमैं, सर फोइ क्ल्याँसि प्रबै प्हँलाँ-प्हुँलुँमैं नेरो क्ह्‍योंर्बै खेदोमैं या लरिगे,” बिमा छान् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","परमेश्‍वरजी स्यो-स्योबै क्ह्‍योंर्बै खेदोमैं, स्यो-स्योबै धिंर न्‍हबै खेदोमैं नेरो स्यो-स्योबै फोइ क्ल्याँसि सर प्रबै प्हलाँ-प्हुलुँमैं बनेइ। धै परमेश्‍वरजी ङ्ह्‍योमा च छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","धबै परमेश्‍वरजी बिइ, “तारे म्‍हि ङ्यो धोंन् तब ङ्यो धोंन् ब्योंब बनेले। चमैंइ मा ङ्युँइर्बै ताँगमैं, मुर्बै नमेंमैं, धिंर न्‍हबै खेदोमैं, क्ह्‍योंर्बै खेदोमैं नेरो सर प्रबै ताँन् सैमैं फिर क्‍ल्‍हे लरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","छतसि परमेश्‍वरजी म्हिलाइ ह्रोंस् धोंन् तब बनेइ, खीजी चमैं ह्रोंस धोंन् ब्योंब बनेइ। छले मुँयुँ नेरो च्हमिरि ङ्हिंना-ङ्हिंन् खीजी बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","परमेश्‍वरजी चमैंने आशिक पिंसि बिइ, “प्हारदै रोदै ल्हें तदै ह्‍याद्। पृथ्बीर प्लिंदै चए फिर क्‍ल्‍हे लदै ह्‍याद्। मा ङ्युँर्बै ताँगमैं, मुर्बै नमेमैं नेरो ह्‍युलर्बै ताँन् सो प्ह्‍याबै सैमैं फिर्बै क्ल्हे तद्।” ");
INSERT INTO gvr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","झाइले परमेश्‍वरजी बिइ, “ङ्‍ह्‍योद्! क्हेमैंए चबै सै तरिगे बिसि पृथ्‍बीर्बै ताँन् प्‍लु पिंबै धुँमैं नेरो रोर्न प्‍लु तबै ताँन् सिंधुँमैं ङइ पिंम्। ");
INSERT INTO gvr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","पृथ्‍बीर्बै ताँन् खेदोमैं, मुर्बै ताँन् नमेमैं नेरो सर प्रबै ताँन् सो प्ह्‍याबै सैमैंइ चबै ल्हागिर ङइ प्याँ पिंमैं पिंम्,” बिमा छान् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ह्रोंसजी बनेबै तोन्दोंरि सै परमेश्‍वरजी ङ्ह्‍योमा बेल्‍ले छ्याँब मुँल। ङेसा तइ धै न्‍हाँग तइ, च टुरोबै त्हिंइ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","छले मु नेरो पृथ्बी चर मुँबै तोन्दोंरि सै बनेल् खाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ह्रोंसजी लबै के परमेश्‍वरजी टुरोर खाँइ। धै ह्रोंसजी लबै ताँन् केउँइँले खीजी ङिरोर भों न्हइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","झाइले परमेश्‍वरजी ङिरोबै त्हिंइलाइ आशिक पिंसि च त्हिंइ पबित्र लमिंइ। तलेबिस्याँ ह्रोंसजी लबै ताँन् केउँइँले ङिरोर भों न्हइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","मु नेरो पृथ्बी बनेबै ताँमैं चुन् ग। याहवेह परमेश्‍वरजी मु नेरो पृथ्बी बनेबै त्हेर ");
INSERT INTO gvr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","सर प्याँ पिंमैं घ्रि या आरेल, धै छिमैं तोइ आम्‍लोल। तलेबिस्याँ याहवेह परमेश्‍वरजी पृथ्बीर नाँ आकुलल। धै स ताब क्योब लबै म्हि या खाबै आरेल। ");
INSERT INTO gvr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","दिलेया पृथ्बीउँइँले स्योंमैं त्‍होंसि ताँन् स प्हाँमिंमल। ");
INSERT INTO gvr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","झाइले याहवेह परमेश्‍वरजी सउँइँले म्हि बनेसि चए नखुँरि सो फुइमिंमा म्हि सोगों तइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","परमेश्‍वरजी स्यारउँइँ अदन बिबै क्ल्ह्‍योरि बगैंचा घ्रि बनेसि खीजी बनेबै म्हि चर थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","झाइले ङ्ह्‍योबर छ्याँब, चबर लिंबै रो रोबै ल्‍हें सिंधुँमैं याहवेह परमेश्‍वरजी सउँइँले म्‍लोमिंइ। धै बगैंचाए म्हाँजोर खोंयोंइ आखाँबै छ्‍ह योंबै सिधुँ नेरो छ्याँब आछ्याँब फेलल् खाँबै ज्ञान पिंबै सिंधुँ या रुँइँइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","बगैंचा प्हाँबर अदनउँइँले स्‍यों घ्रि त्‍होंल, च फ्रेसि स्‍यों प्लि तल। ");
INSERT INTO gvr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","स्‍यों घ्रिए मिं पिशोन ग। चु स्‍यों हबीलाए ताँन् ह्‍युलर बग्दिम्। चर मारा योंम्। ");
INSERT INTO gvr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(च ह्‍युलर्बै मारा छ्याँब तम्। चर बेल्‍ले लिंबै थाँ खबै गोकुल बिबै सिंधुँमैं नेरो छ्याँब तुथु प्ह्‍युरुमैं या योंम्।) ");
INSERT INTO gvr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","झाइले अर्को स्‍योंए मिं गीहोन ग। कूशए ह्‍युलजरे बग्दिबै स्‍यों चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","झाइले अर्को स्‍योंए मिं टाइग्रिस ग। चु स्‍यों अश्‍शुरए स्यारउँइँ बग्दिम्। धै अर्को स्‍योंए मिं यूफ्रेटिस ग। ");
INSERT INTO gvr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","याहवेह परमेश्‍वरजी अदनए बगैंचा ङ्ह्‍योबर नेरो ताब स्युइब लबै ल्हागिर म्हि चर बोसि थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","झाइले खीजी म्हिने बिइ, “बगैंचार्बै ताँन् सिंधुँर्बै रो क्हिइ तोइ आमैंन्ले चस्याँ तम्। ");
INSERT INTO gvr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","दिलेया छ्याँब नेरो आछ्याँब सेल् लमिंबै ज्ञान पिंबै रो बिस्याँ क्हिइ आचद्। तलेबिस्याँ च रो चबै तोदोंन् क्हि सियाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","याहवेह परमेश्‍वरजी बिइ, “म्हि घ्रिन् टिब छ्याँब आरे। छतसि ङइ चए ल्हागिर चने ङ्‍हेंब चलाइ ल्होब थु घ्रि बनेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","याहवेह परमेश्‍वरजी सउँइँले क्ह्‍योंर्बै ताँन् खेदो नेरो मुर प्हुरर्बै ताँन् नमेमैं बनेसि म्हिइ चमैंए मिं तोतो थेंमन बिसि था सेबर च ङाँर पखइ। धै म्हिइ सो प्ह्‍याबै सैमैंल तो तो मिं पिंइ चमैंए मिं चन् तइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","छले म्हिइ न्‍हबै खेदोमैं, मुर प्हुरबै नमेमैं नेरो ताँन् क्ह्‍योंर्बै खेदोमैंए मिं थेंइ। दिलेया आदमए ल्हागिर ङ्‍हेंब नेरो ल्होब खाबै आयोंल। ");
INSERT INTO gvr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","छतसि याहवेह परमेश्‍वरजी म्हिलाइ थेबै न्हरु च्हुइमिंसि चए रेसिं घ्रि ट्हुइसि चर सेइ प्लिंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","याहवेह परमेश्‍वरजी म्हिउँइँले ट्हुइबै रेसिंउँइँले च्हमिरि घ्रि बनेसि म्हि ङाँर पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","च च्हमिरि म्रोंसि म्हिइ बिइ, “चुम् ङए ह्रुइबए ह्रुइब, नेरो ङए सेए सेन् ग! चुने च्हमिरि बिब्मुँ, तलेबिस्याँ चु मुँयुँउँइँले ट्हुइब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","छतसि मुँयुँइ ह्रोंसए आबा-आमालाइ पिसि ह्रोंसए प्ह्रेंस्योने क्ह्रिरिमुँ। धै चमैंए ज्यु घ्रिन् तमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","मुँयुँ नेरो चए प्ह्रेंस्यो ङ्हिंना-ङ्हिंन् क्लुँनन् मुँल। दिलेया फा आपिमल। ");
INSERT INTO gvr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","याहवेह परमेश्‍वरजी बनेबै क्ह्‍योंर्बै सो प्ह्‍याबै सैमैं न्होंरि प्हुरि ताँन् भन्दा स्योर्गु मुँल। चइ च्हमिरिने “परमेश्‍वरजी क्हेमैंने बगैंचार्बै सिंधुँर्बै रो खाबै या आचद् बिइमुँ वा?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","च्हमिरिइ प्‍हुरिने बिइ, “बगैंचार्बै सिंधुँर्बै रो ङिइ चल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","दिलेया ‘बगैंचाए म्हाँजोर मुँबै सिंधुँर्बै रो बिस्याँ क्हेमैंइ आचद्, आछुइद्। आस्‍याँ क्हेमैं सियाब्मुँ,’ बिसि परमेश्‍वरजी ङिने बिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","प्‍हुरिइ च्हमिरिने बिइ, “क्हेमैं आसि। ");
INSERT INTO gvr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","क्हेमैंइ च रो चबै त्हिंइर्न क्हेमैंए सैं न्होंर्बै मि थोंब्मुँ, धै छ्याँब आछ्याँब सेल् खाँबै ज्ञान योंसि क्हेमैं या परमेश्‍वर धोंन् तब्मुँ बिसि परमेश्‍वरजी सेइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","झाइले च सिंधुँर्बै रो चबर लिंब, ङ्ह्‍योमा छ्याँब नेरो बुद्धि योंबै ल्हागिर च सिंधुँए रो चल् त्हुमन बिसि च्हमिरिइ मैंइ। छतसि चइ च सिंधुँए रो टोंसि चवाइ, ह्रोंसए प्युँलाज्यै पिंइ, धै प्युँज्यै या चइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","च रो चबै तोंदोंन् चमैं ङ्हिंना ङ्हिंनए मि थोंयाँइ, झाइले खेंमैं क्लुँनन् मुँन बिसि चमैंइ सेइ। छतसि तुँबुए लमैं थुसि ह्रोंसए ल्हागिर क्‍वें टुसि खिइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","झाइले ङेसा छजाँ याहवेह परमेश्‍वर बगैंचार स्‍युररिमा चमैंइ खीए कै थेइ, धै बगैंचार्बै सिंधुँमैंए म्हाँजोरि याहवेह परमेश्‍वरउँइँले लोयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","दिलेया याहवेह परमेश्‍वरजी “क्हि खनिर मुँ?” बिसि म्हिलाइ हुइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","चइ बिइ, “ङइ बगैंचार क्हिए कै थेइ धै ङ ङ्हिंसि लोयाइ, तलेबिस्याँ ङ क्लुँनन् मुँल।” ");
INSERT INTO gvr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“क्हि क्लुँनन् मुँ बिसि खाबइ बिइ? ङइ आचद् बिबै सिंधुँर्बै रो क्हिइ चवाल् वा?” बिसि परमेश्‍वरजी ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","म्हिइ बिइ, “ङने टिरिगे बिसि क्हिइ पिंबै च्हमिरिइ च सिंधुँर्बै रो ङ पिंइ। धै ङइ चइ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","छतमा याहवेह परमेश्‍वरजी च्हमिरिने “क्हिइ तले छ लल?” बिमा च्हमिरिइ बिइ, “प्हुरिइ ङने ‘तोइ आत! च रो चलेन् तम्’ बिसि स्योर तेइ। छतसि ङइ चइ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","झाइले याहवेह परमेश्‍वरजी प्‍हुरिने बिइ, “क्हिइ स्योर तेबइले क्हि धिंर न्‍हबै खेदोमैं नेरो ताँन् क्ह्‍योंर टिबै खेदोमैं न्होंरि क्हिइ ल्हें सराप योंब्‍मुँ। क्हि फोइ क्ल्याँसि प्रल् त्हुब्मुँ धै क्हिए छ्ह तिगोंन् स चब्‍मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","क्हि नेरो च्हमिरिए म्हाँजोरि धै क्हिए सन्तानमैं नेरो च्हमिरिए सन्तानए म्हाँजोरि ङइ प्होंब्-नेब् लमिंम्। च्हमिरिए सन्तानइ क्हिए क्र प्‍लेब्मुँ धै क्हिइ चए प्‍हले तिंजुर चोब्‍मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","झाइले खीजी च्हमिरिने बिइ, “क्हिए प्हसे फिबै त्हेर्बै बेथा ङइ बेल्‍ले बडिमिंब्‍मुँ। क्हिइ दुःखले प्हसे फिब्‍मुँ। क्हिए सैं प्युँ ङाँइँन तरिब्‍मुँ, छतसि चइ क्हिए फिर क्‍ल्हे लब्‍मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","च लिउँइँ खीजी आदमने बिइ, “क्हिइ प्ह्रेंस्योए ताँ थेसि ङइ आचद् बिबै सिंधुँर्बै रो चबइले क्हिइ लमा सइ सराप योंइमुँ। क्हिए छ्ह तिगोंन् दुःखले के लसि चल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","सइ क्हिए ल्हागिर पुजु नेरो क्‍ह्रुमैं म्‍लोमिंब्‍मुँ धै क्हिइ म्रोंर्बै प्याँ पिंमैं चब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","क्हि सर आकोंन् समा क्हिए ङ्‍होर्बै छैब प्ह्‍युरसि दुःखले कमैंबै कमैं चल् त्हुब्मुँ। क्हि सउँइँलेन् बनेल, क्हि सन् ग, क्हि सिसि सर्न कोंयाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","आदमइ ह्रोंसए प्‍ह्रेंस्‍योए मिं हब्बा थेंइ, तलेबिस्याँ च ताँन् सोगोंमैंए आमा ग। ");
INSERT INTO gvr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","याहवेह परमेश्‍वरजी आदम नेरो चए प्‍ह्रेंस्‍योए ल्हागिर ट्हुबिए क्‍वें बनेसि खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","धै याहवेह परमेश्‍वरजी बिइ, “ङ्यो धोंलेन् म्हि छ्याँब-आछ्याँब सेल् खाँब् तइमुँ। तारे चइ खोंयोंइ सोल् योंबै सिंधुँर्बै रो टोंसि चल् आयोंरिगे। आस्याँ च खोंयोंन् बिलै सोरिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","छतसि “सउँइँलेन् च बनेल, च सर्न के लरिगे” बिसि याहवेह‍ परमेश्‍वरजी अदनए बगैंचाउँइँले चलाइ तेवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","खीजी म्हिलाइ तेवाबै लिउँइँ खोंयोंन् बिलै सोल् योंबै सिंधुँर फेनेबै घ्याँर खाबै या आखरिगे बिसि रुँबै ल्हागिरि अदनए बगैंचार्बै स्यारउँइँले करूबमैं नेरो कारग्युले स्युररिबै मिइ लुँरिबै सेलाँ (तरवार) थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","आदम ह्रोंसए प्ह्रेंस्योने बालु तइ, धै हब्बाइ प्हसे नोसि कयिन फिइ, धै बिइ, “याहवेहजी ल्होमिंसि ङइ च्ह घ्रि फिइ।” ");
INSERT INTO gvr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","चइ धबै कयिनए अलि हाबिल फिइ। हाबिल क्‍यु छैं तइ, कयिन बिस्याँ म्रोंर के लब तइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","दे त्हे लिउँइँ कयिनइ म्रोंर रोबै सैमैंउँइँले च्हौदे भेटि याहवेहए ङाँर पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","दिलेया हाबिलइ ह्रोंसए क्युए बगालउँइँले ओंसों फिबै छोबै क्यु भेटि पखइ। छतमा याहवेह हाबिल नेरो चए भेटि म्रोंसि सैं तोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","दिलेया कयिन नेरो चए भेटि म्रोंसि सैं आतों। छतमा कयिन बेल्‍ले ह्रिस खसि ङ्‍हो छु लइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","छतमा याहवेहजी कयिनने बिइ, “क्हि तले ह्रिस खल? क्हिए ङ्‍हो तले छु लल? ");
INSERT INTO gvr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","क्हिइ छ्याँबै भेटि पखस्‍याँ ङ क्हि म्रोंसि सैं आतोंमल् वा? क्हिइ छ्याँब के आलस्याँ पाप क्हिए म्रार्न क्हुइ टिरिम्। चइ क्हिए फिर क्ल्हे तल् म्हैम्, दिलेया क्हि चए फिर क्‍ल्‍हे तल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","कयिनइ ह्रोंसए अलि हाबिलने “खो, ङ्यो बैरु म्रोंर ह्‍याले,” बिइ। झाइले चमैं म्रोंर ह्‍यामा कयिनइ ह्रोंसए अलि हाबिल सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","छतमा याहवेहजी कयिनने “क्हिए अलि हाबिल खनिर मुँ?” बिसि ङ्योएमा चइ बिइ, “तुसि! ङइ आसे। ङ ङए अलिए प्ह्रोंछैं वा?” ");
INSERT INTO gvr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","याहवेहजी बिइ, “क्हिइ छाबै आछ्याँबै के तले लल? क्हिए अलिए कोइ सउँइँले ङने ग्वार ह्रिरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","क्हिइ सराप योंइमुँ। तारे क्हिइ सर खेति लल् योंरिब आरे। क्हिइ अलि सैवामा सइ सुँ फैइ। क्हिए अलिए कोइ स प्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","तारेसेरो क्हिइ सर खेति लमा सइ क्हिए ल्हागिर रोमैं तोइ पिंरिब आरे। क्हि पृथ्‍बीर खोंयोंन् बिलै छिं ङ्हाँन् आयोंन्ले स्‍युररिल् त्हुब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","कयिनइ याहवेहने बिइ, “ङइ सैदिल् आखाँबै दण्ड ङलाइ तइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","तिंयाँ क्‍हिजी चु क्ल्ह्‍योउँइँले ङलाइ तेवासिन् मुँ, धै ङ क्हिउँइँले लोल् त्हुब्मुँ। ङ पृथ्बीरि छिं ङ्हाँन् आयोंन्‍ले स्‍युररिल् त्हुब्मुँ, छतसि ङलाइ स्याब्मैंइ ङ सैवाब्‍मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","छबिमा याहवेहजी चने बिइ, “छ आङिं! खाबइ कयिन सैमुँ चने बालु ङि गुणा खी किंब्मुँ।” छतसि कयिन स्याब्मैं खाबज्यै आसैरिगे बिसि याहवेहजी चए ज्युर चिनु घ्रि लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","झाइले कयिन याहवेहउँइँले त्‍होंसि अदनए स्यारउँइँ मुँबै नोद बिबै ह्‍युलर टिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","कयिन ह्रोंसए प्ह्रेंस्योने बालु तसि चए प्ह्रेंस्योइ प्‍हसे नोइ, धै हनोक बिबै च्ह फिइ। कयिनइ सहर घ्रि बनेसि ह्रोंसए च्‍हए मिं हनोक च सहरए मिंर्न थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","झाइले हनोकउँइँले ईराद बिबै च्ह योंइ। ईरादउँइँले महूयाएल बिबै च्ह योंइ। महूयाएलउँइँले मतूशाएल बिबै च्ह योंइ। मतूशाएलउँइँले लेमेख बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","लेमेखइ प्ह्रेंस्यो ङ्हिं पखइ। थेब्स्योए मिं आदा, च्योंब्स्योए मिं सिल्‍ला मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","आदाइ याबाल बिबै च्ह फिइ। तम्‍बुर टिब्‍मैंए नेरो खेदो न्हब्‍मैंए खे च मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","चए अलिए मिं यूबाल मुँल। च बिस्याँ बीणा नेरो मुरलि ह्राब्‍मैंए खे मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","सिल्‍ला बिबै च्योंब्स्योइ तूबलकयिन बिबै च्ह फिइ। चइ ताँन् खालर्बै काँस नेरो पैए हातियारमैं बनेमल। तूबलकयिनए अङाँ नामा बिब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","लेमेखइ ह्रोंसए प्ह्रेंस्योमैंने बिइ, “ओ आदा नेरो सिल्‍ला, ङए ताँ थेद्। ओ लेमेखए प्ह्रेंस्योमैं, ङइ बिबै ताँमैं छेनाले थेद्। तलेबिस्याँ ङलाइ नल् लबै म्हि ङइ सैवाइमुँ, ङलाइ प्रिंसि आधाकल्सो लबै फ्रेंसि या ङइ सैवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","कयिनलाइ सैब्मैंल म्हि ङि सिल् त्हुब्मुँ बिस्याँ, लेमेखलाइ सैब्मैंल झन् ङिच्‍युसे ङि म्हि सिल् त्हुब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","धबै आदम ह्रोंसए प्ह्रेंस्योने बालु तसि चए प्ह्रेंस्योइ च्‍ह फिइ। “कयिनइ सैवाबै हाबिलए साटोरि परमेश्‍वरजी ङलाइ कोलो घ्रि पिंइमुँ।” बिसि हब्बाइ चए मिं शेत थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","शेतलै या च्‍ह घ्रि तइ, चए मिं एनोश थेंमिंइ। च त्‍हेउँइँले म्‍हिमैंइ याहवेहए मिं किंबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","आदमए बंशमैं चुमैंन् ग। परमेश्‍वरजी म्हि बनेमा खीजी ह्रोंस धोंबन् बनेइ। खीजी मुयुँ नेरो च्हमिरि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","खीजी चमैंलाइ बनेसि आशिक पिंसि “म्हि” बिबै मिं थेंइ। आदम बिबै ओंसोंबै म्हिए प्हसेमैंए ताँ चुर प्ह्रिथेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","आदम प्रसे सोंच्‍यु बर्ष तमा चइ च्‍ह घ्रि योंइ। चए मिं शेत थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","शेत फिबै लिउँइँ आदम प्रेब्ब्रा बर्ष सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","आदम कुब्ब्रासे सोंच्‍यु बर्ष तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","शेत प्रसे ङ्‍हदिं तमा एनोश बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","एनोश फिबै लिउँइँ शेत प्रेब्ब्रासे ङिदिं सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","शेत कुब्ब्रासे च्‍युसे ङ्हिंदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","एनोश कुच्‍यु बर्ष तमा केनान बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","केनान फिबै लिउँइँ एनोश प्रेब्ब्रासे च्‍युसे ङ्‍हदिं सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","एनोश कुब्ब्रासे ङ्‍हदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","केनान ङिच्‍यु बर्ष तमा चइ महलालेल बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","महलालेल फिबै लिउँइँ केनान प्रेब्ब्रासे प्‍लिच्‍यु बर्ष सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","केनान कुब्ब्रासे च्‍युदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","महलालेल टुच्‍युसे ङ्‍हदिं तमा येरेद बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","येरेद फिबै लिउँइँ महलालेल प्रेब्ब्रासे सोंच्‍यु बर्ष सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","महलालेल प्रेब्ब्रासे कुच्युसे ङ्‍हदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","येरेद प्रसे टुच्‍युसे ङ्हिंदिं तमा चइ हनोक बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","हनोक फिबै लिउँइँ येरेद प्रेब्ब्रा बर्ष सोसि अरू च्‍ह-च्हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","येरेद कुब्ब्रासे टुच्‍युसे ङ्हिंदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","हनोक टुच्‍युसे ङ्‍हदिं तमा चइ मतूशेलह बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","मतूशेलह फिबै लिउँइँ हनोक सोंब्ब्रा बर्ष समा परमेश्‍वरने बा-बालुन् प्ररिइ। धै अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","च त्हेर हनोक सोंब्ब्रासे टुच्‍युसे ङ्‍हदिंर्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","हनोक परमेश्‍वरने बा-बालुन् प्रमल। छले प्रना-प्रन् चलाइ खाबज्यै आम्रों, तलेबिस्याँ परमेश्‍वरजी चलाइ क्‍वे बोवाल। ");
INSERT INTO gvr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","मतूशेलह प्रसे प्रेच्‍युसे ङिदिं तमा लेमेख बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","लेमेख फिबै लिउँइँ मतूशेलह ङिब्ब्रासे प्रेच्‍युसे ङ्हिंदि सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","मतूशेलह कुब्ब्रासे टुच्युसे कुदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","लेमेख प्रसे प्रेच्‍युसे ङ्हिंदिं तमा च्ह घ्रि योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","चइ ह्रोंसए च्हए मिं नोआ थेंसि बिइ, “याहवेहजी सलाइ सराप पिंल। दिलेया च सउँइँलेन् ङ्योइ लबै केउँइँले चु कोलोइ भों न्हल् पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","नोआ फिबै लिउँइँ लेमेख ङ्‍हब्ब्रासे कुच्‍युसे ङ्‍हदिं सोसि अरू च्‍ह-च्‍हमिमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","लेमेख ङिब्ब्रासे ङिच्‍युसे ङ्हिंदिं तसि सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","नोआ ङ्हब्ब्रा बर्ष तमा शेम, हाम नेरो येपेत योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","लिउँइँ ह्‍युलर म्हिमैं ल्हें तदै ह्‍यामा चमैंल च्‍हमिमैं फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","झाइले परमेश्‍वरए च्हमैंइ म्हिमैंए च्‍हमिमैं छ्याँब् म्रोंसि ह्रों-ह्रोंसइ खोबै प्ह्रेंस्योमैं पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","छतमा याहवेहजी बिइ, “ङइ म्हिमैंलाइ खोंयोंन् बिलै सोल् पिंरिब् आरे, तलेबिस्याँ म्हि सिल् त्हुब्मुँ। तारेसेरो चमैं प्रसे ङ्हिस्यु बर्ष मत्‍त्रे सोब्‍मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","च त्‍हेर नेरो लिउँज्यै या पृथ्बीरि नेफिलिममैं मुँल। परमेश्‍वरए च्हमैं म्हिमैंए च्‍हमिमैं ङाँर ह्‍याब्रें लसि प्‍हसेमैं फिइ। चमैंन् स्योंम्बै भोंब्मैं-खाँब्मैं नेरो मिं कालिदिब्मैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","पृथ्बीरि म्हिमैंइ ल्हें आछ्याँबै केमैं लब्रें लइ। धै खोंयोंन् बिलै चमैंइ आछ्याँबै ताँमैं मत्‍त्रे मैंरिब याहवेहजी म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","छतमा “ङइ तले म्हिमैं बनेसि पृथ्बीर थेंगे?” बिसि याहवेहजी पछुत लसि बेल्‍ले सैं नइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","छतसि याहवेहजी बिइ, “ङइ बनेबै म्हिमैं, सर क्ल्याँसि प्रबै प्हँलाँ-प्हुँलुमैं, क्ह्‍योंर टिबै खेदोमैं नेरो मुर्बै नमेमैं ताँन् पृथ्‍बीउँइँले नास लवाब्मुँ। तलेबिस्याँ चुमैं बनेबइले ङए सैं नइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","दिलेया नोआलाइ बिस्याँ याहवेहजी छ्याँब म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","नोआए ताँमैं चुन् ग। चए पलोर नोआ मत्‍त्रे छ्याँबै के लबै म्हि मुँल। च परमेश्‍वरने बा-बालुन् प्रमल। ");
INSERT INTO gvr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","नोआइ शेम, हाम नेरो येपेत बिबै च्‍ह सौंलो योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","दिलेया पृथ्‍बीर खन्तोंदोंन् सैब् म्‍लोब् लब नेरो आछ्याँबै सैइ प्लिंब परमेश्‍वरजी म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","छले पृथ्‍बीर्बै म्हिमैं सैब् म्‍लोब् नेरो आछ्याँबै के लब परमेश्‍वरजी म्रोंइ। तलेबिस्याँ पृथ्‍बीर्बै ताँन् म्हिमैंए सैं दुष्‍ट तल् खाँल। ");
INSERT INTO gvr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","छतसि परमेश्‍वरजी नोआने बिइ, “ङइ ताँन् म्हिमैं नास लवाबै सैं लल् खाँइमुँ। तलेबिस्याँ चमैंइ लबै आछ्याँबै केमैंइ पृथ्बी प्‍लिंइमुँ। छतसि ङइ चमैंलाइ पृथ्‍बीउँइँले नास लवाम्। ");
INSERT INTO gvr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","छतसि क्हिइ गोपेर बिबै सिंए क्यु झाज घ्रि बनेद्। झाजर कोठा-कोठा लसि च न्‍होंर नेरो फिर अलकत्राइ स्‍यालद्। ");
INSERT INTO gvr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","क्हिइ च झाज छले बनेदु: झाज प्रसे प्लिच्‍यु मिटर ह्रिंब, ङ्हिस्युसे सों मिटर प्‍ल्‍हाब नेरो च्‍युसे ङ्हिं मिटर नुब लद्। ");
INSERT INTO gvr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","झाजर मि म्रोंरिगे बिसि तिउरु वाथेंसि स्युद्। झाज तल सोंबै बनेद्। चए रेर म्रा घ्रि थेंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“मु न्‍होंर्बै ताँन् सो प्ह्‍याबै सैमैं नास लवाबर ङइ पृथ्‍बीर नाँ बाडि कुलब्मुँ, धै पृथ्‍बीर मुँबै ताँन् सो प्ह्‍याबै सैमैं सियाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","दिलेया ङइ क्हिने बाछा फैब्‍मुँ। क्हि, क्हिए प्ह्रेंस्यो नेरो क्हिए च्ह-चोंमैं ताँन् क्यु झाज न्‍‍होंर होंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","“झाइले सो प्ह्‍याबै ताँन् खालर्बै त्होब नेरो मोंमा क्हिने बालुन् सोरिगे बिसि तिजोर-तिजोर क्यु झाजए न्होंर पखो। ");
INSERT INTO gvr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ताँन् खालर्बै नमेमैं, खेदोमैं नेरो सर क्‍ल्याँसि प्रबै ताँन् प्हँलाँ-प्हुँलुँमैं तिजोर-तिजोर क्हिने बालुन् सोरिगे बिसि झाजर न्होंर पखो। ");
INSERT INTO gvr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ह्रोंसए ल्हागिर नेरो ताँन् खालर्बै सो प्ह्‍याबै सैमैंइ चबै ल्हागिर ताँन् खालर्बै चबै सै पसि क्हिने बालु थेंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","परमेश्‍वरजी बिब् धोंले नोआइ ताँन् लइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","झाइले याहवेहजी नोआने बिइ, “क्हि नेरो क्हिए परवा क्यु झाज न्‍होंर ह्‍याद्। तलेबिस्याँ ङइ चु पृथ्‍बीर छ्याँबै के लबै म्हि क्हि मत्‍त्रे म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","झाइले ताँन् खालर्बै चल् तबै खेदोमैं न्होंर्बै त्होब नेरो मोंमा ङिजोर धै चल् आतबै खालर्बै खेदोमैं त्होब नेरो मोंमा तिजोर क्यु झाजर पखो। ");
INSERT INTO gvr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","झाइले पृथ्‍बी तिगोंन् नमेमैंए प्लु आथुँयारिगे बिसि नमेमैं या भाले नेरो योंम लसि ङिजोर क्हिने बालुन् पखो। ");
INSERT INTO gvr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","तारेबै ङिरोर ङइ पृथ्‍बीर प्लिच्यु त्हिंइ प्लिच्यु म्‍हुँइस नाँ कुलब्मुँ। धै ङइ बनेबै सो प्ह्‍याबै सैमैं ताँनन् पृथ्‍बीउँइँले नास लवाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","झाइले याहवेहजी लद् बिबै के ताँनन् नोआइ लइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","पृथ्‍बीर नाँ बाडि तमा नोआ टुब्ब्रा बर्षर्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","नाँ बाडिउँइँले सोरिगे बिसि नोआ, चए प्ह्रेंस्यो, च्ह-चोंमैं क्यु झाज न्होंर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","परमेश्‍वरजी बिब् धोंले चल् तब नेरो चल् आतबै खेदोमैं, नमेंमैं नेरो सर क्‍ल्याँसि प्रबै ताँन् सो प्ह्‍याबै सैमैं ");
INSERT INTO gvr_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","भाले नेरो योंम तिजोर-तिजोर नोआने बालु क्यु झाजर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","झाइले ङिरो लिउँइँ पृथ्‍बीर नाँ बाडि तबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","नोआ टुब्ब्रा बर्ष तबै सालर्बै म्हैंन ङ्हिंर्बै च्युसे ङिगैं तमा मुउँइँले नाँ युबै युबन् तइ। धै पृथ्बी न्होंर्बै थे-थेबै क्युए मुल्मैं ताँन् त्होंयाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","छले पृथ्‍बीर प्लिच्यु त्हिंइ प्लिच्यु म्हुँइँस नाँ युबै युबन् तइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","च त्हिंइर्न नोआ, चए प्ह्रेंस्यो, च्हमैं शेम, हाम, येपेत नेरो चमैंए प्ह्रेंस्योमैं सौंलो क्यु झाज न्होंर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","चमैंने बालु ताँन् खालर्बै क्ह्‍योंर्बै खेदोमैं, धिंर न्हबै खेदोमैं, सर क्ल्याँसि प्रबै प्हँलाँ-प्हुँलुँमैं नेरो नमेंमैं या क्यु झाज न्होंर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","परमेश्‍वरजी नोआने बिब् धोंले सो प्ह्‍याबै ताँन् खालर्बै भाले नेरो योंम नोआने बालु क्यु झाज न्होंर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","च लिउँइँ याहवेहजी झाजए म्रा तोरमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","पृथ्बीरि प्लिच्यु त्हिंइ समा नाँ बाडि तरिमा पृथ्‍बीर क्यु ल्हें तसि क्यु झाज क्यु फि-फि क्वेसि सउँइँले कैंडो ह्‍याबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","नाँ युबै युब् तरिमा पृथ्‍बीर क्यु बेल्‍ले ल्हें तसि क्यु झाज क्यु फि-फि क्वेबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","पृथ्‍बीर नाँ युबै युबन् तमा क्यु बेल्‍ले ल्हें तसि नुब नुबै कोंमैं ताँन् प्ल्हुँयाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","नुबै कोंमैं या मिटर ङि समा प्ल्हुँ‍वाल। ");
INSERT INTO gvr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","पृथ्‍बीर प्रब् टिब् लबै ताँन् सो प्ह्‍याबै सैमैं नमेंमैं, न्हबै खेदोमैं, क्ह्‍योंर्बै खेदोमैं, सर क्ल्याँसि प्रबै प्हँलाँ-प्हुँलुँमैं, म्हिमैं ताँन् सियाइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","छले पृथ्‍बीर मुँबै सो प्ह्‍याबै सैमैं ताँन् सियाइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","पृथ्‍बीर मुँबै ताँन् सो प्ह्‍याबै सैमैं म्हि, खेदो, क्ल्याँइ प्रबै प्हँलाँ-प्हुँलुँ, नमेंमैं ताँन् पृथ्‍बीउँइँले याहवेहजी नास लवाइ। नोआने बालु झाजर मुँब्मैं मत्‍त्रे सोइ। ");
INSERT INTO gvr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","पृथ्बीर प्रसे ङ्‍हच्यु त्हिंइ समा क्यु चैरिइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","दिलेया परमेश्‍वरजी नोआ नेरो चने बालु क्यु झाजर मुँबै ताँन् धिंर न्हबै खेदोमैं नेरो क्ह्‍योंर्बै खेदोमैं मैंसि पृथ्‍बीर खैं कुल्मिंइ। धै क्यु ङ्हारबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","स न्होंर्बै थे थेबै क्युए मुल्मैं ङ्हारयाइ धै मुउँइँले नाँ युब टियाइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","झाइले पृथ्‍बीर क्यु ङ्हा-ङ्हारै ह्‍यासि प्रसे ङ्‍हच्यु त्हिंइ लिउँइँ क्यु ङ्हारयाइ ");
INSERT INTO gvr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","च सालर्बै म्हैंन ङिलाए च्युसे ङिगैंर क्यु झाज आरारातए कोंर टियाइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","क्यु ङ्हारदै ह्‍यामा म्हैंन च्युर्बै ओंसोंबै त्हिंइरि कोंमैंए च्होमैं म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","प्लिच्यु त्हिंइ लिउँइँ ह्रोंसइ बनेबै क्यु झाजए च्योंने म्रा नोआइ थोंसि ");
INSERT INTO gvr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","कग घ्रि प्हुरवामा सर्बै क्यु आङ्हारन् समा च कग छाइ-छुइ प्हुररिइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","च लिउँइँ “सर क्यु ङ्हारइ उ” बिसि ङ्ह्‍योबर नोआइ तोंगु (ढुकुर) घ्रि या प्हुरमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","दिलेया पृथ्बीरि क्यु आङ्हारल। छतसि च तोंगु प्हले न्हेबै क्ल्ह्‍यो आयोंसि च ङाँर्न झाजर एखइ। छतसि नोआइ ह्रोंसए यो स्योंसि च तोंगु क्यु झाज न्होंर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","झाइले ङिगैं लिउँइँ नोआइ धबै च तोंगु झाजउँइँले प्हुरमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","च तोंगु ङेसर च ङाँर एखमा चए सुँर भर्खर टोंबै जैतुनए प्हो घ्रि मुँल। छतमा सर क्यु ङ्हारयान बिब नोआइ सेइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ङिगैं लिउँइँ चइ धबै च तोंगु प्हुरमिंइ, दिलेया च लार बिस्याँ च तोंगु च ङाँर आएखा। ");
INSERT INTO gvr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","नोआ टुब्ब्रासे तिदिं तबै सालर्बै ओंसोंबै म्हैंनर्बै ओंसोंबै त्हिंइर पृथ्‍बीर क्यु ङ्हारयाइ। धै नोआइ झाजए म्रा थोंसि ङ्ह्‍योमा सर क्यु ङ्हारयाल। ");
INSERT INTO gvr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","म्हैंन ङ्हिलर्बै ङ्हिस्युसे ङिगैंर स ताँन् कारयाल। ");
INSERT INTO gvr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","छतसि परमेश्‍वरजी नोआने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“क्हि, क्हिए प्ह्रेंस्यो, च्ह-चोंमैं ताँन् झाजउँइँले त्होंन्। ");
INSERT INTO gvr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","क्हिने बालु मुँबै ताँन् सो प्ह्‍याबै सैमैं खेदोमैं, नमेंमैं, क्ल्याँसि प्रबै प्हँलाँ-प्हुँलुँ बैरु तेद्। चमैं पृथ्‍बीर ल्हें तदै ह्‍युलर प्लिंदै ह्‍यारिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","झाइले नोआ, चए प्ह्रेंस्यो नेरो च्ह-चोंमैं झाजउँइँले त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","खेदोमैं ताँन्, क्ल्‍याँसि प्रबै प्हँलाँ-प्हुँलुँ, नमेंमैं पृथ्‍बीर प्रब् टिब् लबै सो प्ह्‍याबै सैमैं या चमैंए ह्रें-ह्रें पार्ले क्यु झाजउँइँले त्होंखइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","झाइले नोआइ याहवेहए ल्हागिर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि चल् तबै खेदोमैं नेरो नमेंमैं घ्रि-घ्रि किंसि परमेश्‍वरए मिंर ख्रो पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","याहवेहजी ख्रोए लिंबै थाँ किंबै लिउँइँ ह्रोंसए सैंर बिइ, “म्हिए सैंर्बै ताँमैं कोलो ओंनोंन् आछ्याँब तलेया म्हिइ लबै केउँइँले तारे ङइ खोंयोंइ पृथ्बीलाइ सराप पिंरिब् आरे। तोगो ङइ नास लब् धोंले सो प्ह्‍याबै ताँन् सैमैं धबै ङ नास लरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“चु पृथ्बी मुरिब्दे, प्लु प्लुब नेरो रो खुबै त्हे, खुँब नेरो ख्वालब सर्ख नेरो बर्ख, त्हिंइ नेरो म्हुँइँस म्हरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","च लिउँइँ परमेश्‍वरजी नोआ नेरो चए च्हमैं आशिक पिंसि “प्हारदै रोदै, सन्तानमैं ल्हें तदै पृथ्‍बीर प्लिंदै ह्‍याद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","पृथ्‍बीर्बै ताँन् खेदोमैं मुर्बै ताँन् नमेंमैं सर क्ल्याँसि प्रबै ताँन् प्हलाँ-प्हुँलुँ मा ङ्युँइर्बै ताँन् ताँगमैं या क्हेमैं म्रोंसि ङ्हिंब्मुँ। चमैं ताँन् ङइ क्हेमैंए योर्न पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","चु ताँन् सो प्ह्‍याबै सैमैं क्हेमैंए चबै सै तब्मुँ। ङइ ओंसों प्याँ पिंमैं पिंब् धोंले चु ताँन् सो प्ह्‍याबै सैमैं या क्हेमैंलाइ पिंम्। ");
INSERT INTO gvr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“छतसि क्हेमैंइ तोइ सैलेया से चलेन् तमुँ दिलेया को बिस्याँ आचद् तलेबिस्याँ कोर सो मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","खाबज्यै म्हिलाइ सैस्याँ चइ सजैं योंम्। खेदोमैंलाज्यै या ङइ खि किंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","परमेश्‍वरजी म्हिलाइ ह्रोंस धोंबन् बनेइमुँ। छतसि खाबइ म्हिलाइ सैमुँ, चलाज्यै या म्हिइ सैब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","क्हेमैं प्हारदै रोदै प्हसेमैं ल्हें फिदै ह्‍युलर प्लिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","धबै परमेश्‍वरजी नोआ नेरो चए च्हमैंने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“क्हेमैं नेरो क्हेमैंए क्वें-क्वेंमिमैंने ");
INSERT INTO gvr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","छलेन क्यु झाजउँइँले क्हेमैंने बालु त्होंखबै ताँन् सो प्ह्‍याबै सैमैं नमेंमैं, न्हबै खेदोमैं, क्ह्‍योंर्बै खेदोमैं क्हेमैंने बालु मुँबै ह्‍युलर्बै सो प्ह्‍याबै ताँन् सैमैंने ङइ बाछा फैम्। ");
INSERT INTO gvr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","तारे सो प्ह्‍याबै ताँन् सैमैं नाँ बाडिए क्युइ खोंयोंइ सिरिब् आरे, धै पृथ्बी नास लबर नाँ बाडि खोंयोंइ तरिब् आरे बिसि ङइ क्हेमैंने बाछा फैम्।” ");
INSERT INTO gvr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","परमेश्‍वरजी बिइ, “चु बाछा ङ नेरो क्हेमैं धै क्हेमैंने बालु मुँबै ताँन् सो प्ह्‍याबै सैमैंए म्हाँजोरि ताँन् पुस्तए ल्हागिर ङइ लमिंइमुँ चए चिनु चु तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ङइ न्हाँम्स्योर ह्‍यार्गों थेंब्मुँ, झाइले ङ नेरो पृथ्‍बीए म्हाँजोरि च ह्‍यार्गों बाछाए चिनु तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ङइ पृथ्‍बीर न्हाँम्स्यो कुलमा न्हाँम्स्योर ह्‍यार्गों म्रोंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ङ नेरो क्हेमैं धै सो प्ह्‍याबै ताँन् सैमैंए म्हाँजोरि फैबै बाछा ङइ मैंब्मुँ। धै नाँ बाडिइ धबै सो प्ह्‍याबै सैमैं खोंयोंइ सैरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","न्हाँम्स्योर ह्‍यार्गों म्रोंमा ङइ च ङ्ह्‍योसि चु खोंयोंन् बिलै तरिबै बाछा मैंब्मुँ। चु बाछा परमेश्‍वर नेरो ह्‍युलर्बै सो प्ह्‍याबै ताँन् सैमैंने फैइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ङइ पृथ्‍बीर्बै सो प्ह्‍याबै ताँन् सैमैं, ङ नेरो क्हेमैंए म्हाँजोरि फैबै बाछाए चिनु चुन् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","झाजउँइँले बैरु त्होंसि खबै नोआए च्हमैं शेम, हाम नेरो येपेत ग। हाम कनानए आबा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","नोआए च्हमैं चु सौंलो मुँल। चुमैंउँइँलेन् ताँन् पृथ्‍बी प्लिंयाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","म्रोंर के लबै नोआइ अँगुरए धुँमैं रुँइँइ। ");
INSERT INTO gvr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","तिगें नोआ अँगुरए प्हाइ म्हेरसि क्लुँनन् ह्रोंसए तम्बु न्होंर रोरिल। ");
INSERT INTO gvr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","कनानए आबा हामइ ह्रोंसए आबा क्लुँनन् रोरिब् म्रोंइ। धै बैरु त्होंसि ह्रोंसए आघेंमैं ङ्हिंने था पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","झाइले शेम नेरो येपेतइ क्वें घ्रि किंसि चमैं ङ्हिंइ काँदार थेंइ। धै लिग्याँइ सर्दिदै ह्‍यासि चमैंइ आबाए फिर हुमिंइ। चमैंए लि लिग्याँइ तोबइले चमैंइ खेंमैंए आबा क्लुँनन् मुँबाआम्रों। ");
INSERT INTO gvr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","नोआ प्हाए न्हरुउँइँले छोरबै लिउँइँ चए च्ह च्योंबइ लबै के था योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","झाइले चइ बिइ, “कनानइ सराप योंरिगे। च ह्रोंसए आघेंमैंए केब्छैंमैंए केब्छैं तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","चइ शेमए ल्हागिर बिइ, “शेमइ म्हाँदिबै याहवेह थेब तरिगे! कनान शेमए केब्छैं तरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","परमेश्‍वरजी येपेतए क्ल्ह्‍यो-न्हें ल्हें लमिंरिगे! धै च शेमने क्ह्रिसि बालुन् टिरिगे! कनान बिस्याँ शेमए केब्छैं तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","नाँ बाडि तबै लिउँइँ नोआ सोंब्‍ब्रासे ङ्‍हच्यु बर्ष समा सोइ। ");
INSERT INTO gvr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","झाइले नोआ कुब्‍ब्रासे ङ्‍हच्यु बर्ष तसि सियाइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","नोआए च्हमैं शेम, हाम नेरो येपेतए ताँमैं चुन् ग। नाँ बाडि तबै लिउँइँ चमैंलैया च्हमैं फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","येपेतए च्हमैं: गोमेर, मागोग, मादे, यावान, तूबल, मेशेक नेरो तीरास मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","गोमेरए च्हमैं: अशकनज, रीपत नेरो तोगर्मा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","यावानए च्हमैं: एलीशाह, तर्शीश, कित्तीम नेरो रोदानीम मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","चुमैंउँइँलेन् मा ङ्युँइए छ्योगोर टिब्मैंए ह्‍युलर ताँनल ह्रोंसए क्युइर नेरो ह्रोंसए ह्रें-ह्रेंर ख्याँयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","हामए च्हमैं: ‍कुश, मिश्रइम‌‍‌, पूत नेरो कनान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","कूशए च्हमैं: सेबा, हवीला, सब्ता, रामाह नेरो सब्तका मुँल। धै रामाहए च्हमैं: सेबा नेरो ददान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","कूशइ निम्रोद बिबै च्ह योंइ। चुन् ओंसोंबै ह्‍युल-ह्‍युललाइ ट्होल् खाँबै म्हि तइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","निम्रोद याहवेहए उँइँर बेल्‍ले छेनाले शिकार क्ल्योंल् ह्रमल। छतसि “चु म्हि निम्रोद धोंले बेल्‍ले छेन्ले शिकार क्ल्योंल् ह्रबै म्हि मुँन!” बिसि अहान् चल्दिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ओंसों निम्रोदए ग्याल्सर बाबेल, एरेक, अक्‍कद नेरो कल्नेह बिबै सहरमैं मुँल। चु सहरमैं शिनार बिबै ह्‍युलर मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","च ह्‍युलउँइँले च अश्शूर ह्‍युलर ह्‍यासि निनबे, रहोबोत-इर नेरो कालह सहरमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","झाइले निनबे नेरो कालहए म्हाँजोर रेसेन सहर बनेइ। रेसन बिस्याँ थेबै सहर ग। ");
INSERT INTO gvr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","मिश्रइम लूदि, अनामी, लहाबी, नप्‍तूही, ");
INSERT INTO gvr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","पत्रुसी, कस्लूही चुमैंउँइँले पलिश्तिमैं तखइ। चुमैं कप्‍तोरीमैंए खे मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","कनानइ ह्रोंसए च्ह थेब सिदोन नेरो हेत योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","झाइले कनानउँइँले हित्ती, यबूसी, एमोरी, गिर्गाशी, ");
INSERT INTO gvr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","हिव्वी, अरकी, सिनी, ");
INSERT INTO gvr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","अर्वादी, सेमारी नेरो हमातीमैं तखइ। च लिउँइँ कनानए सन्तानमैं खन्तोंदोंन् ख्याँयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","छतसि कनान ह्‍युलए साँदा सिदोनउँइँले न्हुउँइँ (दक्षिणउँइँ) गरार ह्‍याबै घ्याँउँइँ गाजा समा धै सदोम, गमोरा, अदमा नेरो सबोयिम ह्‍याबै घ्याँउँइँ तसि लाशा समा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","हामए च्हमैंए खेमैं, चमैंए क्युइमैं, ह्‍युल नेरो ह्रेंमैं चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","येपेतए अलि शेमलैया च्हमैं फिइ। शेम एबेरए सन्तानमैंए खे मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","शेमए च्हमैं: एलाम, अश्शूर, अर्पक्षद, लूद नेरो अराम मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","आरामए च्हमैं: ऊज, हुल, गेतेर नेरो मेशेक मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","अर्पक्षदइ शेलह योंइ। शेलहइ एबेर योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","एबेरइ च्ह ङ्हिं योंइ। घ्रिए मिं पेलेग मुँल। तलेबिस्याँ चए पलोर्न पृथ्‍बीर्बै म्हिमैं स्यो-स्योबै क्ल्ह्‍योर टिनेइ। पेलेगए अलिए मिं योक्‍तान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","योक्‍तानए च्हमैं: अल्मोदद, शेलेप, हसर्मविद, येरह, ");
INSERT INTO gvr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","हदोरम, ऊजाल, दिक्ला, ");
INSERT INTO gvr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ओबाल, अबमाएल, शेबा, ");
INSERT INTO gvr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ओपीर, हवीला नेरो योबाब मुँल। चु ताँन् योक्‍तानए च्हमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","चमैं टिबै क्ल्ह्‍यो मेशाउँइँले स्यारउँइँबै (पुर्बाउँइबै) सपारा ह्‍याबै घ्याँ समा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","शेमए च्हमैं, चमैंए खेमैं, ह्रेंमैं, क्युइ नेरो चए ह्‍युल चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","नोआए च्हमैंए खेमैं चमैंए ह्रों-ह्रोंसए ह्रेंमैं चुमैंन् ग। नाँ बाडि तबै लिउँइँ चुमैंउँइँलेन् पृथ्बीरि ह्रें-ह्रें स्यो-स्यो तसि खन्तोंदोंन् ख्याँयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","च त्हेर पृथ्बीरि ताँन् म्हिमैंइ क्युइ घ्रिन् पोंमल। ");
INSERT INTO gvr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","म्हिमैं स्यारउँइँ सर्दिदै ह्‍यामा शिनार बिबै ह्‍युलर च्येप्ला तबै क्ल्ह्‍यो स्यासि चर्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","चमैंइ खेंमैंए न्होंर “ल्हु, ङ्योइ इँट बनेसि ख्रोंले।” बिसि चमैंइ युँमाए क्ल्ह्‍योरि इँट नेरो सए क्ह्‍लोरि अलकत्रा ओलेइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","झाइले चमैंइ बिइ, “ल्हु, ङ्यो ह्रोंसए ल्हागिर सहर घ्रि नेरो स्वर्ग समा फेनेबै नुबै धररा घ्रि बनेसि। ह्रोंसए मिं थेंले। धै ङ्यो पृथ्बीर खनिरै आप्हुँले।” ");
INSERT INTO gvr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","झाइले म्हिमैंइ बनेबै सहर नेरो धरर ङ्ह्‍यो‍बर याहवेह क्युरु युइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","याहवेहजी बिइ, “चुमैं क्युइ घ्रिन् पोंबै ह्रेंमैं तइ बिस्याँ तारे चुमैंइ लल् म्हैब तोइ मुँलेया लल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","छतसि खो, ङ्यो क्युरु ह्‍यासि चमैंइ घ्रिइ पोंबै क्युइ घ्रिइ आक्हिरिगे बिसि चमैंए क्युइ खलबल लवाले।” ");
INSERT INTO gvr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","छले याहवेहजी च क्ल्ह्‍योउँइँले चमैं ह्‍युल तिगोंन् प्हुँमिंइ। छ लवामा चमैंइ च सहर बनेब पिवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","छतसि च क्ल्ह्‍योए मिं बाबेल थेंमिंइ। तलेबिस्याँ याहवेहजी चर्न ताँन् पृथ्‍बीर्बै क्युइ खलबल लवाल। च क्ल्ह्‍योउँइँलेन् चमैं पृथ्‍‍बि तिंगोंन् प्हुँमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","शेमए च्ह-क्वेंमैंए ताँमैं चुन् ग। नाँ बाडि तबै ङ्हिंदिं लिउँइँ शेम प्र बर्षर्बै तमा अर्पक्षद बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","अर्पक्षद फिबै लिउँइँ शेम ङ्‍हब्ब्रा बर्ष समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","अर्पक्षद सोंच्युसे ङ्‍हदिं तमा शेलह बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","शेलह फिबै लिउँइँ अर्पक्षद प्लिब्ब्रासे सोंदिं समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","शेलह सोंच्यु बर्षर्बै तमा एबेर बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","एबेर फिबै लिउँइँ शेलह प्लिब्ब्रासे सोंदिं समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","एबेर सोंच्युसे प्लिदिं तमा पेलेग बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","पेलेग फिबै लिउँइँ एबेर प्लिब्ब्रासे सोंदिं समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","पेलेग सोंच्यु बर्षर्बै तमा चइ रऊ बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","रऊ फिबै लिउँइँ पेलेग ङ्हिंब्ब्रासे कुदिं समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","रऊ सोंच्युसे ङ्हिंदि तमा सरूग बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","सरूग फिबै लिउँइँ रऊ ङ्हिंब्ब्रासे ङिदिं समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","सरूग सोंच्यु बर्षर्बै तमा चइ नाहोर बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","नाहोर फिबै लिउँइँ सरूग ङ्हिंब्ब्रा बर्ष समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","नाहोर ङ्हिस्युसे कुदिं तमा तेरह बिबै च्ह योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","तेरह फिबै लिउँइँ नाहोर प्रसे च्युसे कुदिं समा सोसि अरू च्ह-च्हमिमैं या योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","तेरह ङिच्यु बर्षर्बै तमा अब्राहम, नाहोर नेरो हरान बिबै च्हमैं योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","तेरहए ताँमैं चुन् ग। अब्राहम, नाहोर नेरो हरानए आबा तेरह मुँल। धै हरानए च्ह लोत मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","हरान कल्दिमैंए ऊर बिबै क्ल्ह्‍योर फिल। चए आबा तेरह सोगों मुँमन् हरान च ह्‍युलर सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","अब्राहम नेरो नाहोरइ ब्ह्‍या लसि प्ह्रेंस्यो पखइ। अब्राहमए प्ह्रेंस्योए मिं साराई नेरो नाहोरए प्ह्रेंस्योए मिं मिल्का मुँल। मिल्का हरानए च्हमि मुँल। मिल्का नेरो यिस्काए आबा हरान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","साराई थरि मुँल चल च्ह-च्हमि तोइ आरेल। ");
INSERT INTO gvr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","तेरहइ ह्रोंसए च्ह अब्राहम हरानए च्ह ह्रोंसए क्वें लोत नेरो अब्राहमए प्ह्रेंस्यो ह्रोंसए चों साराई किंसि कल्दिमैंए ऊर बिबै क्ल्‍योंउँइँले कनान ह्‍युलर ह्‍याब् बिसि चमैं बालुन् त्होंइ। दिलेया हरान बिबै क्ल्ह्‍योर फेनेसि चर्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","तेरह ङ्हिंब्ब्रासे ङ्‍हदिं सोसि हरानर सिइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","याहवेहजी अब्रामने बिइ, “क्हिए ह्‍युल, क्हिए ङ्‍हेब्-ट्हु नेरो क्हिए आबाए धिंउँइँले त्होंसि ङइ तेंबै ह्‍युलर ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","ङइ क्हिउँइँले थेबै ह्रें लमिंब्मुँ, धै क्हिलाइ आशिक पिंसि। क्हिए मिं कालिदिब् लमिंब्मुँ, झाइले क्हि आशिकए मुल तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","क्हिए फिर आशिक पिंब्मैंलाइ ङइ आशिक पिंब्मुँ, क्हिए फिर सराप पिंब्मैंलाइ ङइ सराप पिंब्मुँ। क्हिउँइँलेन् पृथ्‍बीर्बै ताँन् म्हिमैंइ आशिक योंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","छतसि याहवेहजी बिब् धोंलेन् अब्राम च क्ल्ह्‍योउँइँले त्होंइ। धै चए अलिए च्ह लोतै या चने बालु ह्‍याइ। हरानउँइँले त्होंह्‍यामा अब्राम ङिच्युसे ङ्‍हदिंर्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","अब्राम ह्रोंसए प्ह्रेंस्यो साराई, ह्रोंसए अलिए च्ह लोत नेरो खेंमैंइ हरानर खागु लबै सै न्होर नेरो केब्-केब्स्योमैं किंसि कनान ह्‍युलउँइँ ह्‍याइ धै चमैं कनानर फेनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","अब्राम च ह्‍युलर फेसि च ह्‍युलजरे प्र-प्रइ ह्‍यामा शकेमर मुँबै मोरेए चोखो सिंधुँ मुँबै क्ल्ह्‍योर फेइ। च त्हेर च क्ल्ह्‍योर कनानीमैं टिमल। ");
INSERT INTO gvr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","च लिउँइँ याहवेह अब्राम ङाँर म्रोंयुसि चने बिइ, “ङइ क्हिए सन्तानमैं चु ह्‍युल पिंब्मुँ।” छ बिबै लिउँइँ याहवेहए ल्हागिर चइ ख्रो पिंबै क्ल्ह्‍यो घ्रि चर बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","च क्ल्ह्‍योउँइँले ह्‍यासि च बेथेलए स्यारउँइँ मुँबै कोंर टिइ। धै बेथेललाइ पश्‍चिमउँइँ नेरो ऐ सहरलाइ स्यारउँइँ लसि ह्रोंसए तम्बु टौंदिइ। चर चइ याहवेहए ल्हागिर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि याहवेहए मिं किंइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","झाइले अब्राम अझै प्र-प्रइ नेगेब बिबै न्हुउँइँ ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","झाइले च कनान ह्‍युलर थेबै अँङ्गल तसि अब्राम मिश्र ह्‍युलर टिबर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","च मिश्र ह्‍युलर फेबि छेमा अब्रहामइ ह्रोंसए प्ह्रेंस्यो साराईने बिइ, “क्हि ङ्ह्‍योबर बेल्‍ले छ्याँब मुँ बिसि ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","तारे मिश्रीमैंइ क्हिलाइ म्रोंसि ‘चुम् चए प्ह्रेंस्यो मुँन,’ बिब्मुँ। धै चमैंइ ङलाइ सैवासि क्हि सोगों थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","छतसि क्हिइ ‘ङ चए अङाँ ग’ बिमिंन्। क्हिइ छ बिमिंस्याँ ङ सोल् योंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","झाइले अब्राम मिश्र ह्‍युलर फेनेमा चर्बै म्हिमैंइ च च्हमिरि बेल्‍ले छ्याँब म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","झाइले फारो म्रुँए सिपाइमैंइ च च्हमिरिलाइ म्रोंमा “च बेल्‍ले छ्याँब मुँ!” बिसि फारो ङाँर बिनेइ। छतसि चमैंइ साराईलाइ म्रुँए दरबारर बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","साराई बेल्‍ले छ्याँब म्रोंसि फारो म्रुँइ अब्रामलाइ छेन् लसि र-क्युमैं, म्येमैं, केब्-केब्स्योमैं, गधामैं नेरो सलुमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","दिलेया म्रुँइ अब्रामए प्ह्रेंस्यो साराई बोबइले याहवेहजी फारो नेरो चए परवारए फिर ङ्हिंन्-ङ्हाँबै दुःखमैं कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","छतमा फारो म्रुँइ अब्रामलाइ हुँइसि बिइ, “क्हिइ ङने चु तो लल? चु च्हमिरि क्हिए प्ह्रेंस्यो ग बिसि क्हिइ ङने तले आबिल? ");
INSERT INTO gvr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","‘चु ङए अङाँ ग’ बिसि क्हिइ तले बिल? छतसि ङए प्ह्रेंस्यो लबर चलाइ ङइ बोल। ङ्‍ह्‍योद्! क्हिए प्ह्रेंस्यो चुर्न मुँ बोइ ह्‍याद्!” ");
INSERT INTO gvr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","च लिउँइँ फारो म्रुँइ ह्रोंसए म्हिमैंने अब्रामलाइ ह्‍याल् पिंन् बिइ। धै अब्राम, चए प्ह्रेंस्यो नेरो चने मुँबै तोन्दोंरि सैमैं बोसि मिश्र ह्‍युलउँइँले कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","झाइले अब्रामइ ह्रोंसए प्ह्रेंस्यो, ह्रोंसने मुँबै तोन्दोंरि सैमैं नेरो ह्रोंसए अलिए च्ह लोतै या किंसि मिश्र ह्‍युलउँइँले कैंडो क्रेखसि नेगेब बिबै ह्‍युलर फेखइ। ");
INSERT INTO gvr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","अब्राम बेल्‍ले प्लबै म्हि मुँल तलेबिस्याँ चने खेदोमैं मारा-चाँदिमैं ल्हें मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","च नेगेबउँइँले प्रदै ओंसों चइ बेथेल नेरो ऐए म्हाँजोर तम्बु टौंदिबै क्ल्ह्‍‍योर फेखइ। ");
INSERT INTO gvr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","चइ चर ओंसों ख्रो पिंबै क्ल्ह्‍यो बनेसि याहवेहए मिं किंल। ");
INSERT INTO gvr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","अब्रामने बालु ह्‍याबै लोतलै या र-क्युमैं, खेदोमैं नेरो तम्बुमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","चमैंए र-क्युमैं नेरो खेदोमैं ल्हें तसि चमैं ङ्हिंए खेदोमैंए ल्हागिरि च ह्‍युलर्बै छिइ आयो। छतसि चमैं बालु टिल् आखाँब् तइ। ");
INSERT INTO gvr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","छतमा अब्राम नेरो लोतए खेदो छब्मैंए न्होंरि प्होंगि तइ। च त्हेर कनानीमैं नेरो परिज्जीमैं या च ह्‍युलर टिमल। ");
INSERT INTO gvr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","छतमा अब्रामइ लोतने बिइ, “ङ्यो ह्रोंसए म्हिमैं ग। छतसि ङ्यो नेरो ङ्योए प्ह्रोंछैंमैं न्होंरि प्होंगि आतबै ल्हागिर ");
INSERT INTO gvr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ङ्यो फ्रेयाल् त्हुम्। ङ्‍ह्‍योद्, ताँन् ह्‍युल क्हिए ओंसों मुँ। क्हि त्हर्ग्योउँइँ ह्‍यास्याँ ङ क्योलोउँइँ ह्‍यामुँ क्हि क्योलोउँइँ ह्‍यास्याँ ङ त्हर्ग्योउँइँ ह्‍याम्।” ");
INSERT INTO gvr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","लोतइ खन्तोंदोंन् ङ्ह्‍योमा क्यु ल्हें मुँबै यर्दन स्योंए ब्याँसि सोअर समा फेनब् म्रोंइ। च क्ल्ह्‍योर याहवेहजी बनेबै अदनए बगैंचा धोंन् तब नेरो मिश्र ह्‍युलर धोंले क्यु ल्हें मुँल। (चु ताँ याहवेहजी सदोम नेरो गमोरा बिबै सहर नास लब् भन्दा ओंसोंबै ताँ ग।) ");
INSERT INTO gvr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","छतमा लोतइ यर्दनर्बै ताँन् ब्याँसि त्हाँसि स्यारउँइँ ह्‍याइ। छले चमैं ङ्हिं फ्रेयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","अब्राम कनान ह्‍युलर्न टिइ। लोत बिस्याँ ब्याँसिर्बै सहरजरे टिनेइ। चइ सदोम बिबै सहर समा ह्रोंसए तम्बु टौंउँदिसि टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","सदोमर्बै म्हिमैं दुष्‍टमैं मुँल। चमैंइ याहवेहजी आखोबै पाप केमैं लमल। ");
INSERT INTO gvr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","लोत अब्रामने फ्रेयाबै लिउँइँ याहवेहजी अब्रामने बिइ, “तारे क्हि मुँबै क्ल्ह्‍योउँइँले ताइ (उत्तर) माइ (दक्षिण) स्यार (पूर्व) नेरो छ्यो न्हु (पश्‍चिम) खन्तोंदोंन् ङ्‍ह्‍योद्। ");
INSERT INTO gvr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","क्हिइ म्रोंबै ताँन् क्ल्ह्‍यो क्हि नेरो क्हिए सन्तानलाइ ङइ खोंयोंन् बिलै क्ल्हे तबर पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","ङइ क्हिए प्हसेमैं पृथ्‍बीर्बै त्हुल् धोंलेन् ल्हें लमिंब्मुँ। खाबज्यै त्हुल् च्योल् आखाँ! त्हुल् च्योल् खाँम् बिस्याँ क्हिए प्हसेमैं या च्योल् खाँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","रेद्! ह्‍युलए खन्तोंदोंन् ह्‍याद्। तलेबिस्याँ ङइ चु ताँन् क्ल्ह्‍यो क्हिलाइ पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","झाइले अब्रामइ ह्रोंसए तम्बु सार्दिसि हेब्रोनर मुँबै मम्रेए फलाँटए सिंधुमैं ङाँर खसि चर्न टिइ। चइ चर याहवेहए ल्हागिर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","च त्हेर ल्हडें घ्रि तमा पूर्व ह्‍युलर्बै म्रुँमैं प्लिइ कनान ह्‍युलर्बै म्रुँमैं ङ्‍हने नेइ। छलेन शिनारर्बै अम्रापेल म्रुँ, एल्‍लासार्बै अर्योक म्रुँ, एलामर्बै कदोर्लाओमेर म्रुँ नेरो गोयिमर्बै तिदाल म्रुँ नेबर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","धै चमैं सदोमर्बै बेरा म्रुँ, गमोरार्बै बिर्शा म्रुँ, अदमार्बै शिनाब म्रुँ, सबोयिमर्बै शेमेबेर म्रुँ नेरो बेलार्बै (अथवा सोअरर्बै) म्रुँए बिरोधर नेइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","चमैं ताँन् सिद्दिमए ब्याँसिर (अथवा चज मा ङ्युँइर) खागु तइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","चमैं च्युसे ङ्हिंदिं समा कदोर्लाओमेरए न्होंर टिसि के लरिल। दिलेया च्युसे सोंदिं तमा चमैं चए न्होंर टिल् आङिंसि चए बिरोध लइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","छतसि च्युसे प्लिदिं तमा कदोर्लाओमेर नेरो चने क्ह्रिबै म्रुँमैं खसि अस्तेरोत-कर्णेमर रपाइमैं, हामर जूजीमैं, शावेकिर्यातैमर एमिमैं, ");
INSERT INTO gvr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","नेरो सेइर कोंर्बै ह्‍युल खागुबै होरीमैं ट्होवासि चर्बै म्हि आटिबै क्ल्ह्‍यो एलपरान समन् चमैंइ क्ल्हे लसि खेंमैंए न्होंर पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","च लिउँइँ चमैं एखसि एन मिशपातर (अथवा कादेशर) खसि अमालेकीमैंए ताँन् ह्‍युल नेरो हासेसोन-तामारर टिबै एमोरीमैं या ट्होवासि चमैंलाज्यै या खेंमैंए न्होंर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","च लिउँइँ सदोम, गमोरा, अदमा, साबोयिम नेरो बेलार्बै (अथवा सोअरर्बै) म्रुँमैं खागु तसि सिद्दिमए ब्याँसिर चमैंने नेबर तयार तइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","धै च म्रुँ ङ्‍ह म्रुँ प्लिने नेबर खइ। अथवा एलामर्बै कदोर्लाओमेर म्रुँ, गोयिमर्बै तिदाल म्रुँ, शिनारर्बै अम्रापेल म्रुँ नेरो एल्‍लासारर्बै अर्योक म्रुँने नेबर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","सिद्दिमए ब्याँसिर अलकत्रइ प्लिंरिबै होंल्दोंमैं मुँल। कदोर्लाओमेर म्रुँइ ट्होमा सदोम नेरो गमोराए म्रुँमैं नेबै क्ल्ह्‍योउँइँले भौदिमा चमैंए को-कोइ म्हिमैं च होंल्दोंजरे पायाइ। दिलेया अरू म्रुँमैं सों कोंउँइँ भौदिइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","च म्रुँ प्लि सदोम नेरो गमोरार्बै ताँन् सैमैं किंसि खेंमैंए घ्याँ क्हासि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","चमैंइ सदोमर टिबै अब्रामए अलिए च्ह लोत नेरो चए तोन्दोंरि सैमैं या बोयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","दिलेया भौदिह्‍याबै म्हि घ्रिइ हिब्रू ह्रेंर्बै अब्रामने चु ताँ बिइ। अब्राम एश्कोल नेरो आनेरए अलि एमोरी मम्रेए ङ्‍ह् सिं धुँए खागु टिमल। चुमैं अब्रामने क्ह्रिब्मैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","झाइले अब्रामइ ह्रोंसए अलिए च्हलाइ फैसि बोबै ताँ थेसि ह्रोंसए धिंर फिसि तालिम योंबै सोंब्ब्रासे च्युसे प्रे केब्छैंमैं किंसि चमैं दान बिबै क्ल्ह्‍यो समा ल्हाबोइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","अब्रामइ ह्रोंसए म्हिमैं टोलि-टोलि लसि फेलइ धै म्हुँइँसर शत्तुरमैंए फिर ह्‍वानेमा चमैंलाइ ट्होवाइ। धै दमस्कसए उत्तरउँइँबै होबा समा चमैं ल्हाबोइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","झाइले चइ ह्रोंसए अलिए च्ह लोत, चए ताँन् सै न्होर, च्हमिरिमैं, म्हिमैं नेरो चमैंने मुँबै तोन्दोंरि सैमैं या एपखइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","छले कदोर्लाओमेर नेरो चने क्ह्रिबै म्रुँमैंए फिर ट्होसि एखमा शावेए ब्याँसिर (अथवा म्रुँए ब्याँसिर) सदोमर्बै म्रुँ चने त्होबर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","च लिउँइँ शालेमर्बै मल्कीसेदेक म्रुँ या क्हें नेरो अँगुरए प्हा किंसि अब्राम ङाँर खइ। च ताँन् भन्दा थेबै परमेश्‍वरए खेगि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","“स्वर्ग नेरो पृथ्बी बनेबै ताँन् भन्दा थेबै परमेश्‍वरउँइँले अब्रामइ आशिक योंरिगे! ");
INSERT INTO gvr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","क्हिलाइ शत्तुरमैंए फिर ट्होल् पिंबै ताँन् भन्दा थेबै परमेश्‍वरए मिं थेब तरिगे!” बिसि चइ अब्रामए फिर आशिक पिंइ। धै अब्रामइ ह्रोंसइ ट्होइ पखबै तोन्दोंरि सैए च्युबाँर्बै तिंबाँ मल्कीसेदेकलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","छले पिंमा सदोमर्बै म्रुँइ अब्रामने बिइ, “क्हिइ ट्होसि पखबै तोन्दोंरि सैमैं क्हिनेन् थेंन्। ङए म्हिमैं मत्‍त्रे ङलाइ पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","दिलेया अब्रामइ सदोमर्बै म्रुँने बिइ, “स्वर्ग नेरो पृथ्बी बनेबै याहवेह ताँन् भन्दा थेबै परमेश्‍वरए उँइँरि ङइ छले कसम चइमुँ: ");
INSERT INTO gvr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ङ क्हिए रु घ्रि या जुत्ताए तनि घ्रि या किंरिब् आरे। आस्याँ ‘ङइ लमा अब्राम प्लब् तइ’ बिसि क्हिइ बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ङ ह्रोंसए ल्हागिर तोइ सै आकिं। ङने मुँबै म्हिमैंइ कति चइ च नेरो चमैंए भाउ मत्‍त्रे किंब्मुँ। दिलेया आनेर, एश्कोल नेरो मम्रेइ बिस्याँ ह्रों-ह्रोंसए भाउ किंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","च लिउँइँ याहवेह अब्राम ङाँर म्रोंयुसि चने बिइ, “अब्राम, क्हि आङ्हिंन्, क्हिए ढाल ङन् ग; ङइ क्हिलाइ बेल्‍ले थेबै इनाम पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","दिलेया अब्रामइ बिइ, “ओ याहवेह परमेश्‍वर, क्हिजी ङ तो पिंइमुँ रो? तलेबिस्याँ ङल प्हसे घ्रि या आरे, तारे ङए धिंर्बै क्ल्हे दमस्कसर्बै एलीएजर तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","क्हिजी ङलाइ प्हसेमैं आपिंइमुँ। छतसि ङए धिंर फिबै केब्छैंन् ङए धिंर्बै क्ल्हे तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","दिलेया “च एलीएजर बिबै केब्छैं क्हिए धिंर्बै क्ल्हे तरिब आरे, तलेबिस्याँ क्हिए च्हन् क्हिए धिंर्बै क्ल्हे तब्मुँ,” बिसि याहवेहजी बिबै ताँ धबै अब्रामइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","खीजी चलाइ बैरु बोसि बिइ, “मुउँइँ ङ्योद्! मुर्बै मुसारमैं च्योल् खाँम् उ आखाँ? क्हिए प्हसेमैं या मुसारा धोंलेन् ल्हें तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","छबिमा अब्रामइ याहवेहजी बिबै ताँ क्वेंइ। चइ खीजी बिबै ताँ क्वेंबइले याहवेहजी चलाइ ठिक ठर्दिइ। ");
INSERT INTO gvr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","खीजी धबै चने बिइ, “चु ह्‍युल क्हिलाइ पिंबर कल्दिमैंए ऊरउँइँले क्हि पखबै याहवेह ङन् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","दिलेया अब्रामइ खीने “ओ याहवेह परमेश्‍वर, ङ चु ह्‍युलए क्ल्हे तल् योंम् बिसि ङइ खैले सेल् खाँम्?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","खीजी चने बिइ, “ङए ल्हागिर सोंदिंर्बै म्ये घ्रि, सोंदिंर्बै र, सोंदिंर्बै क्यु, तोंगु घ्रि नेरो परेवाए प्हसे घ्रि पखो।” ");
INSERT INTO gvr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","अब्रामइ च ताँन् सैमैं खी ङाँर पसि थोइ। धै म्हाँजोर ङ्हिंबाँ लसि ओंसों थेंमिंइ नमेंमैं बिस्याँ ङ्हिंबाँ आल। ");
INSERT INTO gvr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","छले थेंमा च सियाबै खेदो नेरो नमेंमैं फिर क्व्रेमैं ह्‍वाखमा अब्रामइ चमैं ल्हाइ। ");
INSERT INTO gvr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","त्हिंयाँ लियामा अब्राम बेल्‍ले न्हरु च्हुइरिल। छले न्हरु च्हुइरिमा ङ्हिंन् ङ्हाँबै मिछु खैबइ च हुवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","च लिउँइँ याहवेहजी अब्रामने बिइ, “क्हिए प्हसेमैं आगुए ह्‍युलर बसैं ह्‍यासि टिब्मुँ, च ह्‍युलर्बै म्हिमैंए केब्छैंमैं तब्मुँ, छले प्लिब्ब्रा बर्ष समा चमैंइ ल्हें दुःख योंल् त्हुब्मुँ बिसि खैलसेया मैंथेंन्। ");
INSERT INTO gvr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","दिलेया क्हिए प्हसेमैं खाब् ह्रेंमैंए केब्छैं तब्मुँ, च ह्रेंर्बै म्हिमैंलैया ङइ निसाफ लब्मुँ। लिउँइँ चमैं त्होंखमा ल्हें मारा-मुइ किंसि खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","क्हि बिस्याँ खेब् तन् समा शान्तिले सोसि सिब्मुँ धै पाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","पुस्ता प्लि लिउँइँ क्हिए प्हसेमैं चुर्न एखब्मुँ, तलेबिस्याँ एमोरीमैंए आछ्याँबै के तोगो समा आखाँइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","त्हिंयाँ लियाबै लिउँइँ म्हुँइँस तमा मिखु त्होंबै मिए पु घ्रि नेरो लुँरिबै मिए प्हैं घ्रि सेए चौटामैंए म्हाँजोउँइँले त्होंयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","च त्हिंइर्न याहवेहजी अब्रामने छ बिसि बाछा फैइ, “मिश्र ह्‍युलर्बै स्योंउँइँले यूफ्रेटिस बिबै थेबै स्यों समार्बै चु ताँन् ह्‍युलै या ङइ क्हिए प्हसेमैंलाइ पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","केनि, कनज्जी, कदमोनि, ");
INSERT INTO gvr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","हित्ती, परिज्जी, रपाइ, ");
INSERT INTO gvr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","एमोरी, कनानी, गिर्गाशी नेरो यबूसीमैंए ह्‍युलमैं ताँन् ङइ क्हिए प्हसेमैंलाइ पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","अब्रामए प्ह्रेंस्यो साराईउँइँले अब्रामल प्हसे आतल। साराईल हागार बिबै मिश्री केब्स्यो घ्रि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","तिगैं साराई अब्रामने बिइ, “याहवेहजी ङलाइ प्हसे तल् आपिं। छतसि क्हि ङए केब्स्यो ङाँर ह्‍याद्। खनिज्यै च ङाँइले ङए ल्हागिर प्हसे तल् खाँम् उ?” छबिमा अब्रामइ साराईए ताँ ङिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","अब्राम कनानर टिबै च्युदिं लिउँइँ ह्रोंसए प्ह्रेंस्यो साराई ह्रोंसए केब्स्यो मिश्रीथेंस्यो हागार अब्रामए प्ह्रेंस्यो तबर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","झाइले अब्राम हागार ङाँर ह्‍यामा हागारइ प्हसे नोइ। चइ प्हसे नोब् सेसि ह्रोंसए नेब्स्योलाइ म्हि आच्हिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","छतमा साराई अब्रामने बिइ, “ङए फिर खबै अनिया क्हिए फिर खरिगे। ङइ ह्रोंसए केब्स्यो क्हिने बालु तबर पिंब् ग, च प्हसे नोबै तोदोंन् ङलाइ म्हि आच्हिबर होंइ। छतसि याहवेहजी क्हि नेरो ङए म्हाँजोरि निसाफ लमिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","छबिमा अब्रामइ साराईने बिइ, “क्हिए केब्स्यो क्हिए योर्न मुँ। चने खै लदा ङ्हाँमुँ छान् लद्।” छबिमा साराई चए फिर बेल्‍ले दुःख पिंबर होंइ। ल्हें दुःख योंमा हागार साराईउँइँले भौदिह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","याहवेहए स्वर्गदूतइ शूर सहर ह्‍याबै घ्याँर म्हि आटिबै क्ल्ह्‍योर क्युए मुल ङाँर हागारलाइ त्होइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","झाइले स्वर्गदूतइ बिइ, “ओ साराईए केब्स्यो हागार, खनिउँइँले खल? खनिर ह्‍याबर होंल?” चइ बिइ, “ङए नेब्स्यो साराईउँइँले भौदिरिलो।” ");
INSERT INTO gvr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","याहवेहए स्वर्गदूतजी चने बिइ, “क्हिए नेब्स्यो ङाँर एसि ह्‍याद्, धै चए न्होंर टिद्।” ");
INSERT INTO gvr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","याहवेहए दूतइ धबै चने बिइ, “ङइ क्हिलाइ ल्हें प्हसेमैं पिंब्मुँ। चमैं खाबज्यै च्योल् खाँरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","याहवेहए दूतइ चने बिइ, “क्हिइ प्हसे नोइमुँ क्हिइ च्ह घ्रि फिब्मुँ। चए मिं इश्माएल थेंनु, तलेबिस्याँ याहवेहजी क्हिए दुःख म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","क्हिए च्ह क्ह्‍योंर्बै गदा धों तब्मुँ। चए यो ताँन् म्हिमैंने नेबर रेब्मुँ, ताँन् म्हिमैंए यो चने नेबर रेब्मुँ। ह्रोंसए ताँन् ह्रजे-म्हजेमैंने ख्रे लसि टिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","हागारइ बिइ, “क्ह्रोंसेंन ङइ परमेश्‍वर म्रोंसेया ङ सोगोंन् मुँ।” छतसि ह्रोंसने बालु ताँ लबै याहवेहलाइ चइ “ङलाइ म्रोंबै परमेश्‍वर” बिसि मिं थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","छतसि च क्यु खादुँए मिं “ङलाइ म्रोंबै सोगों परमेशवरए क्यु खादुँ” ग। च क्ल्ह्‍यो कादेश नेरो बेरेदए म्हाँजोर मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","छले हागारइ अब्रामल च्ह घ्रि फिइ। च च्हए मिं अब्रामइ इश्माएल थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","हागारइ इश्‍माएल फिबै त्हेर अब्राम प्रेच्युसे ट्हुदिंर्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","अब्राम कुच्युसे कुदिं तमा याहवेह अब्राम ङाँर युसि चने बिइ, “तोन्दोंरि सै लल् खाँबै परमेश्‍वर ङ ग। छतसि छ्याँबै केमैं लसि ङए उँइँर प्रद्। ");
INSERT INTO gvr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ङइ क्हिलाइ ल्हें सन्तानमैं पिंब्मुँ बिसि ङ नेरो क्हिए म्हाँजोरि बाछा फैब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","झाइले अब्राम पत्खु तमा परमेश्‍वरजी धबै चने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“थेद्! ङइ फैबै बाछा क्हिने बालुन् मुँ। क्हि ल्हें ह्रेंमैंए खे तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","छतसि तारे क्हिए मिं अब्राम आङिं, अब्राहाम तब्मुँ। तलेबिस्याँ ङइ क्हिलाइ ल्हें ह्रेंमैंए खे लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","ङइ क्हिलाइ ल्हें सन्तानमैं पिंब्मुँ धै क्हिउँइँलेन् ल्हें ह्रेंमैं तब्मुँ। क्हिउँइँलेन् म्रुँमैं त्होंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“क्हि नेरो क्हिए सन्तानए परमेश्‍वर तबर, धै क्हिए लिउँइँ खबै सन्तानमैंने ङए बाछा खोंयोंइ बिलै तरिबै ल्हागिर फैब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","क्हि तोगो टिबै चु कनान ह्‍युल क्हि नेरो क्हिए लिउँइँ खबै सन्तानलाइ खोंयोंइ बिलै क्ल्हे तबर पिंब्मुँ, धै ङ चमैंए परमेश्‍वर तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","परमेश्‍वरजी अब्राहामने धबै बिइ, “क्हिइ ङए बाछा ङिंल् त्हुब्मुँ। क्हि नेरो क्हिए लिउँइँ खबै सन्तानमैं चमैंए लिउँइँ खबै पुस्ताज्यै ङिंल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","क्हि नेरो क्हिए लिउँइँ खबै ताँन् सन्तानमैंज्यै या ङिंल् त्हुबै ताँ चुन् ग: क्हेमैंए न्होंर्बै ताँन् मुँयुँमैंइ ज्युर्बै ट्हुबि क्ह्‍याँसि चिनु लल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","क्हेमैंए च्हमैं प्रेरोर च चिनु लल् त्हुब्मुँ, ङ नेरो क्हेमैंए म्हाँजोर्बै बाछाए चिनु चुन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","क्हेमैंए पुस्ता-पुस्ता समा च्हमैं फिमा ताँन् मुँयुँमैंइ प्रेरोर्न चमैंए ज्युर चिनु लल् त्हुब्मुँ। क्हिए धिंर फिब् मुँले, आगुए ह्‍युलउँइँले खलै, किंइ पखबै केब्छैं मुँलेया चमैं ताँन् मुँयुँमैंए ज्युर चिनु लल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","छलमा ङए बाछा क्हेमैंए ट्हुबिर खोंयोंइ बिलै तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ज्युर चिनु आलबै मुँयुँमैं ह्रोंसए ह्रेंउँइँले स्यो लवाब्मुँ तलेबिस्याँ ङइ फैबै बाछा चइ आङिं।” ");
INSERT INTO gvr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","परमेश्‍वरजी धबै अब्राहामने बिइ, “क्हिए प्ह्रेंस्योने साराई बिसि आहुइद्, तारे चए मिं सारा तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ङइ चलाइ आशिक पिंब्मुँ धै च ङाँइले क्हिलाइ च्ह घ्रि पिंब्मुँ। ङइ चलाइ आशिक पिंबइले च ल्हें ह्रेंमैंए आमा तब्मुँ। धै ह्रें-ह्रेंमैंए म्रुँमैं या च ङाँइले तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","छबिमा अब्राहाम पत्खु तसि सैं न्हों-न्हों निस्योसि बिइ, “प्र बर्ष तयाबै म्हिलैया प्हसे तम् रो वा? धै कुच्यु बर्ष तयाबै साराई प्हसे फिलै रो वा? ");
INSERT INTO gvr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","ङ सिबै लिउँइँ इश्माएलाइन ङए च्हइ योंबै हक योंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","दिलेया परमेश्‍वरजी आब्रहामने बिइ, “आङिं! क्हिए प्ह्रेंस्यो साराईन क्हिए ल्हागिर च्ह घ्रि फिब्मुँ। क्हिइ चए मिं इसहाक थेंब्मुँ। च नेरो चए लिउँइँबै सन्तानने ङइ ङए बाछा फैब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","क्हिइ इश्माएलए ल्हागिर यो छ्युँ लब ङइ थेइ। छतसि ङइ चलाइ आशिक पिंब्मुँ धै प्हसेमैं ल्हें लमिंब्मुँ। च च्युसे ङ्हिं म्रुँमैंए आबा तब्मुँ, ङइ च ङाँइले थेबै ह्रेंमैं लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","दिलेया ङए बाछा इसहाकनेन् फैब्मुँ। क्हुरिंम्बै चु त्हेजरे साराई क्हिउँलेन् च्ह फिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","चने बालु ताँ लल् खाँबै लिउँइँ परमेश्‍वर अब्राहामउँइँले ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","च त्हिंइर्न अब्राहामइ ह्रोंसए च्ह इश्‍माएल नेरो ह्रोंसए धिंर फिबै केब्छैंमैं नेरो ह्रोंसए धिंर्बै ताँन् मुँयुँमैंल परमेश्‍वरजी बिब् धोंले ज्युर चिनु लइ। ");
INSERT INTO gvr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","ज्युर चिनु लमा अब्राहाम कुच्युसे कुदिं तल। ");
INSERT INTO gvr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","चए च्ह इश्माएलए ज्युर चिनु लमा च च्युसे सोंदिंर्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","च त्हिंइर्न अब्राहाम नेरो चए च्ह इश्माएलए ज्युर चिनु लल। ");
INSERT INTO gvr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","चने बा-बालुन् चए धिंर फिब नेरो अरू ह्‍युलउँइँले किंइ पखबै ताँन् मुँयुँमैंए ज्युर चिनु लल। ");
INSERT INTO gvr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","तिगें त्हिंइर्बै ख्वालबै त्हेर अब्राहाम मम्रे बिबै क्ल्ह्‍योर ङ्‍हसिं धुँए ङाँर्बै ह्रोंसए तम्बुए म्रार टिरिमा याहवेह च ङाँर म्रोंयुइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","चइ ङ्‍ह्‍योमा ह्रोंसए ओंसों मुँयुँमैं सों रारिब् म्रोंइ। चमैं म्रोंसि चए तम्बुए म्राउँइँले त्होंसि न्हे‍ह्‍याइ धै पत्खु तसि चमैंलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","धै चइ बिइ, “ओ चिब्मैं, ङए फिर क्हेमैंए म्हाँया मुँस्याँ क्हिए केब्छैंए तम्बु न्होंर आहोंनले छलेन् आह्‍यामिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","क्हेमैंए प्हले ख्रुबै ल्हागिर ङ क्यु पखमुँ। क्हेमैं चु सिंधुँ न्होंर्न भों न्हद्। ");
INSERT INTO gvr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","क्हेमैं ह्रोंसए केब्छैं ङाँर युइ छतसि ङ क्हेमैंए ल्हागिर चबै सै पखमुँ च चदु धै भों न्हसि ह्‍याल् खाँमुँ। क्हेमैं ङए तम्बुर खसेरो ङइ मान लल् पिंन्।” चमैंइ बिइ, “तम् तम्, ह्‍याद्। क्हिइ बिब् धोंन् लद्।” ");
INSERT INTO gvr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","झाइले अब्राहाम च तोदोंन् तम्बुर सारा ङाँर ह्‍यासि “युन्ले प्रो ङ्‍हब्यों चेंसि क्हें झोंन्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","अब्राहाम बिस्याँ प्ह्रोंर ह्‍यासि ह्रोंसए खेदोमैंए बगलउँइँले क्ल्या भार घ्रि किंसि चए केब्छैंने सैबर पिंइ। धै सैबै तोंदोंन् चइ ह्‍योइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","झाइले चइ दै, ङ्‍हे नेरो ह्‍योबै से बोसि चमैंए उँइँर थेंमिंइ। चमैंइ आचन् समा च चमैं ङाँर्न रारिइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","चमैंइ चने “क्हिए प्ह्रेंस्यो सारा खनिर मुँ?” बिसि ङ्योएमा चइ “चम् तम्बुर मुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","झाइले याहवेहजी बिइ, “क्हुरिंम्बै चु त्हेजरे ङ क्हि ङाँर एयुब्मुँ। च्हमा क्हिए प्ह्रेंस्यो साराई च्ह घ्रि फिब्मुँ।” साराई चु ताँ चए लिउँइँ तम्बुए म्राउँइँले थेरिल। ");
INSERT INTO gvr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","अब्राहाम नेरो सारा खेब्-माँब् तसि चमैंए छ्ह ल्हें तयाल् खाँल। साराए क्होर्बै या टियाल् खाँल। ");
INSERT INTO gvr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","छतसि सारा सैं न्हों-न्हों “ङ माँब् तयाल् खाँइमुँ ङए प्युँ या खेब् तयाल् खाँइमुँ छाबै त्हेरै या ङ सैं तोंल् योंम् रो वा?” बिसि निस्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","“‘माँब् तयालेया ङइ च्ह-च्हमि योंम् रो वा?’ बिसि सारा तले निस्योइ? बिसि याहवेहजी अब्राहामने ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","याहवेहजी लल् आखाँबै सै तोइ मुँ वा? क्हुरिंम्बै ङ युम् बिबै त्हेर ङ क्हि ङाँर एयुब्मुँ। च्हमा साराल च्ह घ्रि तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","दिलेया साराई ङ्हिंदै “ङम् निआस्यो बिइ।” चइ बिइ, “आङिं! क्हि निस्योल।” ");
INSERT INTO gvr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","झाइले च मुँयुँमैंइ छाइले सदोमउँइँ ङ्ह्‍योबर होंइ। छतसि अब्राहाम चमैंने बालु दे क्याइ समा घ्याँ तेंबर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","याहवेहजी बिइ, “ङइ लबर होंबै के अब्राहामउँइँले लोइ थेंले वा? ");
INSERT INTO gvr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","अब्राहामउँइँले घ्रि थेब नेरो भोंबै ह्रें तब्मुँ। च ङाँइलेन् पृथ्‍बीर्बै ताँन् ह्रेंमैंइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","तलेबिस्याँ चइ ह्रोंसए च्ह-च्हमिमैं नेरो परवामैं ‘छेनाले लोदा-सैंदा लसि याहवेहजी बिब् धोंले प्रबर ल्हैदिरिगे’ बिसि ङइ च त्हाँइमुँ। चमैंइ छ लस्याँ याहवेहजी अब्राहामने फैबै बाछा पूरा लमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","धबै याहवेहजी बिइ, “सदोम नेरो गमोराए बिरोधर ल्हें ताँ रेइमुँ। तलेबिस्याँ चमैंइ ल्हें पाप लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","तारे ङइ थेबै ताँ अनुसार चमैंइ लबै केमैं क्ह्रोंसेंन् ङिंब् उ आङिं बिसि ङ्ह्‍योबर ङ क्युरु ह्‍याब्मुँ। आङिंस्याँ ङइ सेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","छतसि च मुँयुँमैं ङ्हिं छाइले तसि सदोमउँइँ ह्‍याइ। अब्राहाम बिस्याँ याहवेहए उँइँर्न रारिइ। ");
INSERT INTO gvr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","झाइले अब्राहाम याहवेह ङाँर ह्‍यासि बिइ, “दुष्‍टमैंने बालु ठिक के लब्मैं या क्हिजी सैवाम्मा? ");
INSERT INTO gvr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","च क्ल्ह्‍योर ठिक के लब्मैं ङ्‍हच्यु मुँस्याँ च ङ्‍हच्यु म्हि आजोगेल्‍ले च क्ल्ह्‍यो नास लवाम्मा? ");
INSERT INTO gvr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","दुष्‍ट म्हिमैंने बालु ठिक के लब्मैं सैबै के क्हिउँइँले खोंयोंइ आतरिगे। क्हिउँइँले छ्याँबै के लब्मैं नेरो आछ्याँबै के लब्मैंए नों खोंयोंन् बिलै घ्रिन् आतरिगे। पृथ्‍बीर्बै नियाधिशइ क्ह्रोंसेंन्बै निसाफ आल रो वा?” ");
INSERT INTO gvr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","याहवेहजी बिइ, “सदोम सहर न्होंर ठिक के लब्मैं ङ्‍हच्यु मुँस्याँ चमैं सोरिगे बिसि ङइ ताँन् म्हिमैं जोगेमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","अब्राहामइ बिइ, “ओ याहवेह, ङ स नेरो मेब्रो धों तलेया क्हिने बालु ताँ सेबै आँट लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","चर म्हि ङ्‍ह आयोल्‍ले ठिक के लब्मैं प्लिच्युसे ङ्‍ह मत्‍त्रे मुँलेया क्हिजी ताँन् सैवाम्मा?” खीजी बिइ, “चर ठिक के लब्मैं प्लिच्युसे ङ्‍ह मत्‍त्रे मुँस्याँ ङइ ताँन् सैरिब् आरे।” अब्राहामइ धबै बिइ, “ठिक के लब्मैं प्लिच्यु मत्‍त्रे मुँस्याँ खै लम्दि?” ");
INSERT INTO gvr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","खीजी बिइ, “ठिक के लबै प्लिच्यु म्हिमैं सोरिगे बिसि ङइ च सहर नास लरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","अब्राहामइ बिइ, “ओ याहवेह, क्हि ह्रिस आखस्याँ ङ धबै ताँ घ्रि ङ्योएम् ओ। चर ठिक के लब्मैं सोंच्यु मत्‍त्रे मुँस्याँ खै लम्दि?” खीजी बिइ, “चर ठिक के लब्मैं सोंच्यु मत्‍त्रे मुँलेया ङइ च सहर नास लरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","अब्राहामइ बिइ, “ओ याहवेह, ङ क्हिने ताँ सेबै आँट लरिइमुँ गार आम्हाँदिद् ओ। चर ठिक के लब्मैं ङ्हिस्यु मुँस्याँ खै लम्दि?” खीजी बिइ, “ठिक के लबै ङ्हिस्यु म्हि सोरिगे बिसि ङइ च सहर नास लरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","झाइले अब्राहामइ बिइ, “ओ याहवेह, क्हि ह्रिस आखस्याँ ङ धबै ताँ घ्रि ङ्योएम् ओ। चर ठिक के लब्मैं च्यु मत्‍त्रे मुँस्याँ खै लम्दि?” खीजी बिइ, “ठिक के लबै म्हि च्यु सोरिगे बिसि ङइ च सहर नास लरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","छले याहवेह अब्राहामने ताँ सेल् खाँबै लिउँइँ छाइले ह्‍याइ। अब्राहाम बिस्याँ ह्रोंसए तम्बुर एखइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","च स्वर्गदूतमैं ङ्हिं ङेसर सदोमर युइ। च त्हेर लोत सदोमए मुल म्रार क्हुँरिल। चमैं म्रोंसि लोत चमैंने त्होबर रेइ, धै कुरसि चमैंलाइ फ्योसि बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“ओ चिब्मैं, गार आम्हाँदिल्‍ले ह्रोंसए केब्छैंए धिंर खसि क्हेमैंए प्हले ख्रुसि चुर्न म्हुँइँस थोदु। धै न्हाँगर युनन् रेसि ह्‍याद्।” दिलेया चमैंइ बिइ, “मुँरिगे, ङि चु बैरुबै चोकर्न रोम्।” ");
INSERT INTO gvr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","दिलेया लोतइ चमैंने बेल्‍ले कर ल्हैदिमा चमैं चने बालु धिंर ह्‍याइ। धै लोतइ प्लेढा आझोंबै क्हें झोंसि चमैंए उँइँर थेंमिंमा चमैंइ चइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","चमैं रोब् भन्दा ओंसों सदोमर्बै फ्रेंसिमैं नेरो खेब्मैं घ्रि या आचैल्‍ले ताँन् म्हिमैं खसि लोतए धिंर कारग्यु लइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","चमैंइ लोतलाइ हुइसि बिइ, “ङेसर क्हि ङाँर खबै म्हिमैं खनिर मुँ? चमैं बैरु ङि ङाँर पुयु ङि चमैंने रोम्।” ");
INSERT INTO gvr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","चमैंइ छबिमा लोत म्राए बैरु चमैं ङाँर ह्‍यासि लिउँइँले म्रा तोरवासि ");
INSERT INTO gvr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","चमैंने बिइ, “ओ थुमैं, गार आम्हाँदिल्‍ले छाबै आछ्याँबै के आलमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","बरु ङए च्हमिमैं ङ्हिं कन्येन् मुँ। ङइ चमैं क्हेमैं ङाँर पुइमिंम्। क्हेमैंइ चमैंने तो लदा ङ्हाँमुँ लद्। चु म्हिमैं तोइ आलमिंन् तलेबिस्याँ चुमैं ङए प्ह्रेंमैं ग। चमैं ङए धिंर खसेरो ङइ चुमैं जोगेल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","दिलेया चमैंइ बिइ, “क्हि ङि ङाँर टिखबै म्हि मत्‍त्रे ग, क्हिइ ङिए फिर निसाफ लल् म्हैइमुँ! ङिए घ्याँ स्योद्! आस्याँ ङिइ च म्हिमैंने भन्दा क्हिने आछ्याँबै के लब्मुँ।” छ बिसि लोतलाइ कैवासि म्रा फोर्दिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","दिलेया धिं न्होंर्बै म्हि ङ्हिंइ लोतलाइ चैंसि धिं न्होंर झोंसि म्रा तोरवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","झाइले चमैंइ म्रा बैरु मुँबै ताँन् म्हिमैंए मि आम्रोंब् लवाइ। धै च म्हिमैंइ म्रा स्याल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","झाइले च म्हि ङ्हिंइ लोतने बिइ, “क्हिने बालु चुर अरू खाबै मुँ वा? म्हो, च्ह-च्हमिमैं, चु क्ल्ह्‍योर क्हिने खाबै मुँ बिस्याँ चमैं किंसि चु क्ल्ह्‍योउँइँले त्होंइ ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","तलेबिस्याँ ङइ चु क्ल्ह्‍यो नास लवाम्। चु क्ल्ह्‍योर्बै म्हिमैंए आछ्याँबै ताँमैं स्वर्गर याहवेह ङाँर फेनेइमुँ। छतसि चु क्ल्ह्‍यो नास लवाबर खीजी ङि कुल्मिंब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","च म्हिमैंए ताँ थेसि लोतइ ह्रोंसए च्हमिमैं ब्ह्‍या लब् बिसि ह्रिथेंबै म्होमैं ङाँर ह्‍यासि बिइ, “रेद्, चु क्ल्ह्‍योउँइँले ह्‍याले। तलेबिस्याँ याहवेहजी चु क्ल्ह्‍यो नास लवाबर होंइमुँ।” दिलेया म्होमैंइ लोतइ स्योर तेइ ङ्हाँसि आक्वें। ");
INSERT INTO gvr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","मि म्रोबि छेमा च स्वर्गदूतमैंइ लोतने “रेद्, क्हिए प्ह्रेंस्यो नेरो चुर मुँबै क्हिए च्हमि ङ्हिं किंसि ह्‍याद्। आह्‍यास्याँ चु क्ल्ह्‍योर्बै म्हिमैंइ योंबै सजैंर क्हेमैं या नास तयाब्मुँ बिदै युनन् ह्‍याबर कर ल्हैदिइ।” ");
INSERT INTO gvr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","दिलेया लोतइ क्हैल् लरिमा याहवेहजी चमैंए फिर ल्हयो खसि स्वर्गदूतमैंइ लोत, चए प्ह्रेंस्यो नेरो च्हमि ङ्हिंए यो क्हासि च क्ल्ह्‍योउँइँले बैरु पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","चमैं बैरु पखबै लिउँइँ स्वर्गदूत घ्रिइ बिइ, “क्हेमैंए ज्यु जोगेबर न्हेह्‍याद्, लिग्याँ तोसि आङ्ह्‍योद्, धै ब्याँसिर खनिरै आराद्। क्हेमैं आसिरिगे बिसि कोंउँइँ न्हे‍ह्‍याद्।” ");
INSERT INTO gvr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","दिलेया लोतइ चमैंने बिइ, “ओ चिब्मैं, छाबै दुःख ङि फिर आतरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","क्हेमैंइ ङए फिर ल्हयो खसि ङए ज्यु जोगेमिंइ। दिलेया ङ कोंउँइँ भौदिल् आखाँ, आस्याँ चु क्ल्ह्‍यो नास लवामा ङै या सियाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ङ्ह्‍योत्ति, च च्योंबै नाँस चेंदोन् मुँ। ङ चर्न ह्‍याल् पिंन्, च नाँस च्योंब मुँ, आङिं वा? चर ह्‍यास्याँ ङ सोलै।” ");
INSERT INTO gvr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","च म्हिइ चने बिइ, “तम्-तम्। क्हिइ बिबै ताँ ङइ ङिंम्। क्हिइ बिबै नाँस ङइ नास लरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","क्हि युन चर न्हे‍ह्‍याद्, तलेबिस्याँ क्हि चर आफेन् समा ङइ तोइ लल् आखाँ।” (छतसि च नाँसए मिं सोअर थेंइ।) ");
INSERT INTO gvr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","लोत सोअर बिबै नाँसर फेनेमा त्हिंयाँ फ्योयाल् खाँल। ");
INSERT INTO gvr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","झाइले याहवेहजी सदोम नेरो गमोराए फिर मुउँइँले मि नेरो बारुद कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","छले याहवेहजी चर्बै नाँसमैं नेरो ब्याँसि धै चर टिबै ताँन् म्हिमैं नेरो सर म्‍लोबै तोन्दोंरि सैमैं नास लवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","दिलेया लोतए प्ह्रेंस्योइ लिउँइँ तोसि सदोमउँइँ ङ्ह्‍योमा च चजए त्हो तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","प्हँन्हाँग्धों न्हाँगर्न रेसि अब्राहाम ओंसोंन् याहवेहने त्होसि ताँ लबै क्ल्ह्‍योर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","चर ह्‍यासि माइ ङ्ह्‍योमा सदोम, गमोरा नेरो ब्याँसिर्बै ताँन् क्ल्ह्‍योमैं म्रोंइ। च क्ल्ह्‍योउँइँले भट्टिर्बै मिखु धोंब कैंडो खरिब् म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","छले ब्याँसिर्बै नाँसमैं नास लवामा परमेश्‍वरजी अब्राहामलाइ मैंइ। लोत टिबै क्ल्ह्‍यो नास लवामा च क्ल्ह्‍योउँइँले खीजी लोत जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","लोत सोअर नाँसर टिब ङ्हिंसि ह्रोंसए च्हमि ङ्हिं किंसि कोंर ह्‍यासि चर्बै उ घ्रिर टिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","तिगें च्हमि थेब्स्योइ च्योंब्स्योने बिइ, “ङ्योए आबा खेब् तयाइ। चु ह्‍युलर ङ्योने ब्ह्‍या लबर खब्मैं खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","छतसि ङ्योइ तारे ङ्योए आबा प्हाइ म्हेरन् लसि चने रोले, धै आबाउँइँले ङ्योइ प्हसेमैं योंले।” ");
INSERT INTO gvr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","च म्हुँइँसर चमैंइ खेंमैंए आबालाइ अँगुरए प्हा थुँल् पिंइ, धै च्हमि थेब्स्यो ह्रोंसए आबाने रोइ। च्हमि खसि रोसि रेसि ह्‍याबै या लोतइ आसे। ");
INSERT INTO gvr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","प्हँन्हाँग्धों च्हमि थेब्स्योइ च्योंब्स्योने बिइ, “तल् म्हुँइँसर ङ आबाने रोइ। तिंयाँ म्हुँइँसर धबै ङ्योइ चलाइ प्हा थुँल् पिंले। धै क्हि ह्‍यासि आबाने रोद्। छले ङ्योइ आबाउँइँले प्हसेमैं योंले।” ");
INSERT INTO gvr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","झाइले चमैंइ च म्हुँइँसरै या खेंमैंए आबालाइ प्हा थुँल् पिंसि च्योंब्स्यो आबाने रोनेइ। च्योंब्स्यो खसि रोसि रेसि ह्‍याबै या लोतइ आसे। ");
INSERT INTO gvr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","छले लोतए च्हमि ङ्हिंइ खेंमैंए आबाउँइँलेन् प्हसे नोइ। ");
INSERT INTO gvr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","च्हमि थेब्स्योइ च्ह घ्रि फिसि चए मिं मोआब थेंइ। तिंजरोबै मोआबीमैंए खे चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","च्योंब्स्योज्यै च्ह घ्रि फिसि चए मिं बेन-अमि थेंइ। तिंजरोबै अम्मोनिमैंए खे चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","च क्ल्ह्‍योउँइँले अब्राहाम नेगेब बिबै क्ल्ह्‍योउँइँ ह्‍याइ, धै कादेश नेरो शूरए म्हाँजोर्बै गरार बिबै ह्‍युलर टिइ। गरार ह्‍युलर टिमा चर्बै म्हिमैंने ");
INSERT INTO gvr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","अब्राहामइ ह्रोंसए प्ह्रेंस्यो सारालाइ “चम् ङए अङाँ ग,” बिइ। छबिमा गरारर्बै अबीमेलेक म्रुँइ सारालाइ ह्रोंस ङाँर पखबर ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","दिलेया म्हुँइँसर परमेश्‍वर अबीमेलेक ङाँर म्होंडर युसि बिइ, “थेद्, च च्हमिरि आगुए प्ह्रेंस्यो ग! छतसि क्हिइ चलाइ पखस्याँ क्हि सियाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","अबीमेलेक च त्हे समा सारा ङाँर आह्‍याल। छतसि चइ बिइ, “ओ प्रभु, ङइ आछ्याँबै के तोइ आलइमुँ! ङइ तोइ न्होह्रों आललैया क्हिजी ङि सैवाम्मा? ");
INSERT INTO gvr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘च ङए अङाँ ग’ बिसि च म्हि ह्रोंसइन् ङने बिब आङिं रो वा? धै च च्हमिरिज्यै या ‘च ङए आघें ग’ बिसि बिब आङिं रो वा? ङइ चु के छ्याँबै सैंइ लब् ग। ङइ तोइ आछ्याँबै के आलइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","झाइले परमेश्‍वरजी अबीमेलेकने म्होंडर बिइ, “अँ, क्हिए छ्याँबै सैंउँलेन् चु के लब् ग बिसि ङइ सेइमुँ। ङए उँइँर क्हिइ आछ्याँबै के आलरिगे बिसि क्हि जोगेमिंब ङन् ग। छतसि ङइ च च्हमिरि क्हिइ छुइल् आपिंल। ");
INSERT INTO gvr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","तारे अब्राहामए प्ह्रेंस्यो एवाद्, तलेबिस्याँ च अगमबक्‍ता ग। चइ क्हिए ल्हागिर प्राथना लमिंब्मुँ, धै क्हि सोब्मुँ। दिलेया क्हिइ च च्हमिरि आएमिंस्याँ क्हि नेरो क्हिए ताँन् म्हिमैं खैलेबिलेया सियाब्मुँ बिसि सैंर मैंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","अबीमेलेक न्हाँगर्न रेसि ह्रोंसए ताँन् सिपाइमैं हुइसि चु ताँन् ताँमैं बिइ। च ताँ थेसि चर्बै म्हिमैं बेल्‍ले ङ्हिंयाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","छतमा अबीमेलेकइ अब्राहाम हुइसि बिइ, “क्हिइ ङिने तो लल् म्हैल? ङइ क्हिल तो न्होह्रों लवाइ? क्हिइ ङ नेरो ङए ह्‍युलए फिर च्हौ थेबै छ्याब खबै के तले तल् पिंल? क्हिइ ङने लल् आतबै के लइ! ");
INSERT INTO gvr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","तो मैंसि क्हिइ ङने बालु छाबै के लल?” ");
INSERT INTO gvr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","अब्राहामइ बिइ, “तलेबिस्याँ चु क्ल्ह्‍योर परमेश्‍वरने ङ्हिंब खाबै आरे। छतसि म्हिमैंइ ङए प्ह्रेंस्यो छ्याँब् म्रोंसि ङलाइ सैवासि चलाइ बोवाम् उ? बिसि ङइ मैंल। ");
INSERT INTO gvr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","छतसि ङइ चने ‘ङए अङाँ ग’ बिसि बिब् ग। च ताँ क्ह्रोंसेंन ग, तलेबिस्याँ चु ङए आबाए च्हमि ग, दिलेया आमा स्यो-स्योन् ग। धै चु ङए प्ह्रेंस्यो तइ। ");
INSERT INTO gvr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","परमेश्‍वरजी ङलाइ ङए आबाए धिं पिसि आगुए ह्‍युलर क्याइ-माइ स्युरइ प्रब लमिंइ। छतसि ङइ साराने ‘गार् आम्हाँदिल्‍ले क्हिइ म्हिमैंने बालु चु ङए आघें ग बिद् ओ’ बिसि ङइ बिल।” ");
INSERT INTO gvr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","छ बिबै लिउँइँ अबीमेलेकइ र-क्युमैं, क्ल्या-मेमैं, केब्-केब्स्योमैं पखसि अब्राहामलाइ पिंइ, धै चए प्ह्रेंस्यो सारा या एमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","झाइले अबीमेलेकइ बिइ, “ङ्‍ह्‍योद्, ङए ह्‍युल क्हिए ओंसोंन् मुँ। क्हि खनिर टिदा ङ्हाँइमुँ चर्न टिद्।” ");
INSERT INTO gvr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","अबीमेलेकइ साराने बिइ, “क्हिए आघेंलाइ ङइ चाँदिए हजार घ्रि पिंइमुँ। क्हिने बालु मुँबै म्हिमैंए उँइँर क्हिल तोइ छ्याब् आरे बिब चु मुइ प्रमाण तब्मुँ। तारे खाबज्यै या क्हिए फिर आछ्याँब मैंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","छतसि अब्राहामइ परमेश्‍वरने प्राथना लइ, धै परमेश्‍वरजी अबीमेलेक नेरो चए प्ह्रेंस्यो धै चए केब्स्योमैंइ धबै प्हसे योंल् खाँरिगे बिसि चमैं सल् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","तलेबिस्याँ अब्राहामए प्ह्रेंस्यो साराई लमा याहवेहजी अबीमेलेकए धिंर मुँबै ताँन् च्हमिरिमैंए कोख म्रुवाल। ");
INSERT INTO gvr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","याहवेहजी अब्राहामने बाछा फैब् धोंले साराए फिर ल्हयो खइ। धै खीजी बिब्‌ धोंलेन् लमिंसि ");
INSERT INTO gvr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","साराई प्हसे नोइ, धै परमेश्‍वरजी चने बिब् धोंले अब्राहाम खेब् तबै त्हेर साराई च्ह घ्रि योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","साराई फिबै चए च्हए मिं अब्राहामइ इसहाक थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","चए च्ह प्रेरो तमा अब्राहामइ परमेश्‍वरजी बिब्‌ धोंलेन् ज्युर चिनु लइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","चए च्ह इसहाक फिमा अब्राहाम प्र बर्ष तल् खाँल। ");
INSERT INTO gvr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","छले च्ह योंमा साराई बिइ, “परमेश्‍वरजी ङए सैं तोंन् लमिंसि ङ निस्योल् पिंइमुँ। चु ताँ थेब्मैं ताँन् ङने बालु निस्योब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","धबै साराई बिइ, “‘साराई प्हसेलाइ ङ्‍हे तिंल् योंम्’ बिसि खाबज्यै अब्राहामने आबिमल। दिलेया च खेब् तबै त्हेरै या ङ ङाँइले चल च्ह घ्रि फिइ।” ");
INSERT INTO gvr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","कोलो इसहाक थेब् ततै ह्‍यामा चइ ङ्‍हे थुँब पिवाबै त्हिंइर अब्राहामइ थेबै भत्तेर लइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","तिगें मिश्रीथेंस्यो हागारइ अब्राहामउँइँले फिबै च्ह इश्माएलइ ह्रोंसए च्ह इसहाकलाइ गिजेरिब् साराई म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","छतसि साराई अब्राहामने बिइ, “चु केब्स्यो नेरो चए च्ह छुइले तेवाद्। तलेबिस्याँ चु केब्छैंए च्ह ङए च्ह इसहाकने बालु क्हिए सै न्होरए क्ल्हे तल् योंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","इश्माएलै या ह्रोंसए च्हन् तबइले च ताँ थेसि अब्राहामए सैं आतों। ");
INSERT INTO gvr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","दिलेया परमेश्‍वरजी अब्राहामने बिइ, “च कोलो नेरो क्हिए केब्स्यो हागारए ल्हागिरि क्हिइ न्हुँ आलद्। ङइ क्हिने बाछा फैब् धोंले क्हिए सन्तान इसहाकउँइँलेन् तब्मुँ। छतसि साराई क्हिने खै बिमुँ छान् लद्। ");
INSERT INTO gvr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","च केब्स्योए च्हउँइँले या ल्हें सन्तानमैं तब्मुँ। ङइ चउँइँले या ह्रें घ्रि लमिंब्मुँ। तलेबिस्याँ इश्माएलै या क्हिए च्हन् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","छ बिबै प्हँन्हाँगधों अब्राहाम न्हाँकर्न रेसि क्हें नेरो क्युए छकला (मशक) घ्रि हागारए प्हैंदार थेंमिंइ, धै च नेरो कोलो ङ्हिंना-ङ्हिंन् कुल्मिंइ। झाइले हागार बेर्शेबा बिबै तोइ आरेबै क्ल्ह्‍योजरे स्युर प्रइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","छले प्र-प्रमा छकलार्बै क्यु थुँल् खाँबै लिउँइँ चइ कोलो ल्हों न्होंर वाथेंसि ");
INSERT INTO gvr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","प्र मिटरदे क्याइ ह्‍यासि टिइ, तलेबिस्याँ “च कोलो सिब ङइ म्रोंल् आत्हुरिगे” बिसि चइ सैं न्हों-न्हों मैंइ। झाइले हागार चर टिसि बेल्‍ले क्रोबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","दिलेया परमेश्‍वरजी कोलो क्रोब थेइ। धै परमेश्‍वरए दूतजी स्वर्गउँइँले हागारने बिइ, “ओ हागार, क्हिए फिर तो दुःख तइ? क्हि आङ्हिंन्, तलेबिस्याँ कोलो क्रोब परमेश्‍वरजी थेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","रेद्, कोलो ङाँर ह्‍यासि चलाइ रेमिंन्, धै चए सैं क्होल् लमिंन्। ङइ च ङाँइले थेबै ह्रें घ्रि लमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","छबिसि परमेश्‍वरजी हागारए मि थोंमिंमा चइ क्यु खाँदु घ्रि म्रोंइ। धै ह्‍यासि छकालर क्यु खाइ पखसि कोलो थुँमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","च कोलोए फिर परमेश्‍वरजी म्हाँया लबइले च थेब ततै ह्‍याइ, धै पारान बिबै तोइ आकेबै क्ल्ह्‍योर टिसि मे त्हँले ल्हिल् ह्रबै म्हि तइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","धै चए आमाइ चए ल्हागिर मिश्र ह्‍युलउँइँले प्ह्रेंस्यो घ्रि पखमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","च त्हेर अबीमेलेक म्रुँ नेरो चए सेनापति पिकोलइ अब्राहामने बिइ, “क्हिइ लबै तोन्दोंरि केर परमेश्‍वरजी आशिक पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","छतसि ङ नेरो ङए च्ह-च्हमि, ङए क्वें-क्वेंमिंमैंने बालु क्हिइ स्योर तेबै केमैं खोंयोंइ लरिब् आरे बिसि ङने बालु चुर परमेश्‍वरए उँइँर बाछा फैद्। धै क्हिए फिर ङइ छ्याँब लब् धोंलेन् क्हिज्यै या ङए फिर छ्याँबै केमैं लम् बिसि ङने बाछा फैद्, धै क्हि टिबै चु ह्‍युलए ल्हागिरै या क्हिइ छ्याँबै केमैं लम् बिसि ङने बाछा फैद्।” ");
INSERT INTO gvr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","अब्राहामइ बिइ, “तम्, तम्, ङ छाबन् बाछा फैम्।” ");
INSERT INTO gvr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","दिलेया अबीमेलेक म्रुँए केब्छैंमैंइ खैच्हिजी लसि प्हेंवाबै क्यु खाँदुए बारेर अब्राहामइ अबीमेलेकने ताँ लइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","अबीमेलेकइ बिइ, “छाबै के खाबइ लगे, च ङइ था आसे। क्हिइ ङने तोगो समा तोइ आबि। तिंयाँ मत्‍त्रे ङइ चु ताँ थेइ।” ");
INSERT INTO gvr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","च ताँ तबै लिउँइँ अब्राहामइ क्युमैं-मेमैं पसि अबीमेलेकलाइ पिंइ। धै चमैं ङ्हिंइ बाछा फैइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","अब्राहामइ क्युए बगालउँइँले म्हदो ङि स्योले थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","अबीमेलेकइ अब्राहामने “क्हिइ चु म्हदो ङि तले स्योले थेंल?” बिसि ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","अब्राहामइ बिइ, “चु क्यु खाँदु ङइ ताब् ग बिसि ग्वाइ तबै ल्हागिर चु क्यु म्हदो ङि क्हि किंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","झाइले चर चमैं ङ्हिंन-ङ्हिंनइ बाछा फैबइले च क्ल्ह्‍योए मिं बेर्शेबा थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","झाइले चमैंइ बेर्शेबा बिबै क्ल्ह्‍योर खेंमैं न्होंर बाछा फैबै लिउँइँ अबीमेलेक नेरो चए सेनापति पिकोल पलिश्ती बिबै ह्‍युलर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","अब्राहामइ बेर्शेबार झ्याउए सिंधुँ घ्रि रुँइँसि खोंयोंन् बिलै तरिबै याहवेह परमेश्‍वरलाइ सेवा लइ। ");
INSERT INTO gvr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","च लिउँइँ अब्राहाम पलिश्तीमैंए ह्‍युलर ल्हें त्हिंइ समा टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","तिस्याँदे लिउँइँ परमेश्‍वरजी अब्राहामए थेबै जाँच लसि चने बिइ, “ओ अब्राहाम।” चइ बिइ, “होइ, ङ चुर्न मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","झाइले परमेश्‍वरजी बिइ, “क्हिइ बेल्‍ले खोबै क्हिए घ्रिदे मुँबै च्ह इसहाक किंसि ङइ तेंबै क्ल्ह्‍यो मोरियाह ह्‍युलर्बै कोंर ह्‍यासि च कोलो ख्रो पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","छबिमा अब्राहाम न्हाँकर्न रेसि ख्रो पिंबै सिं क्लेसि गधाए फिर तेमैं फैइ। धै चए केब्छैं ङ्हिं नेरो च्ह इसहाक किंसि परमेश्‍वरजी चने बिबै क्ल्ह्‍योउँइँ ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","छले ह्‍यारिमा सोंरोर अब्राहामइ च क्ल्ह्‍यो ह्रेंगोर म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","धै अब्राहामइ चए केब्छैंमैंने बिइ, “क्हेमैं चुर गधा ङाँर टिरिद्। ङ नेरो चु कोलो ताइ ह्‍यासि ख्रो पिंसि क्हेमैं ङाँर्न एयुम्।” ");
INSERT INTO gvr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","अब्राहामइ ख्रो पिंबै सिं ह्रोंसए च्ह इसहाकलाइ नोमिंइ, झाइले मि नेरो छुरि चए योर किंसि चमैं ङ्हिंना-ङ्हिंन् ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","छले ह्‍यारिमा इसहाकइ ह्रोंसए आबाने बिइ, “ओ आबा।” आबाइ बिइ, “तो बिल, च्हेज्यों?” चइ बिइ, “ङ्योने मि नेरो सिंमैं मुँ, दिलेया ख्रो पिंबै क्यु झज खोइ?” ");
INSERT INTO gvr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","अब्राहामइ बिइ, “च्हेज्यों, ख्रो पिंबै क्यु झज परमेश्‍वरजीन् जुरेमिंम्,” बिसि चमैं ङ्हिं बालुन् ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","धै परमेश्‍वरजी चने तेंबै क्ल्ह्‍योर फेबै लिउँइँ अब्राहामइ चर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि सिं थेंइ। धै ह्रोंसए च्ह इसहाक फैसि सिंए फिर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","झाइले अब्राहामइ ह्रोंसए च्ह ख्रो पिंब् बिसि छुरि क्वेइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","दिलेया याहवेहए दूत घ्रिइ स्वर्गउँइँले चलाइ कै तेसि बिइ, “ओ अब्राहाम, अब्राहाम!” चइ बिइ, “होइ, ङ चुर्न मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","दूतजी बिइ, “क्हिइ च कोलोए फिर यो आरेद्, चलाइ तोइ आलद्। तारे क्हि परमेश्‍वरने ङ्हिंमना बिसि ङइ सेइ, तलेबिस्याँ क्हिए च्ह घ्रि, क्हिए घ्रिदे मुँबै च्है या क्हिइ ङ ङाँइले लोइ आथें।” ");
INSERT INTO gvr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","झाइले अब्राहामइ कोंउँइँ ङ्‍ह्‍योमा क्यु साँढे घ्रि झ्याडिर रु क्होरिब् म्रोंइ। धै अब्राहाम ह्‍यासि च क्यु साँढे पखसि ह्रोंसए च्हए क्ल्ह्‍योरि च क्युए ख्रो पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","छतसि अब्राहामइ च क्ल्ह्‍योए मिं “याहवेहजी जुरेमिंब्मुँ” थेंइ। “याहवेहए कोंर खीजी जुरेमिंब्मुँ” बिसि तिंजरो या म्हिमैंइ बिरिम्। ");
INSERT INTO gvr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","याहवेहए दूतजी धबै स्वर्गउँइँले कै तेसि अब्राहामने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“ङ याहवेहजी बिइमुँ, ङइ ह्रोंसए मिंर बाछा फैइमुँ, क्हिए घ्रिदे मुँबै च्है या ङए मिंर ख्रो पिंबै सैं लइ। क्हिइ चु के लबइले ङइ क्हिलाइ आशिक पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","क्हिए प्हसेमैं बडिसि मुर्बै सारमैं नेरो मा ङ्युँइर्बै बालुवा धोंलेन् ल्हें लमिंब्मुँ। क्हिए सन्तानइ खेंमैंए शत्तुरमैंए सहरमैं क्ल्हे लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ङए ताँ क्हिइ ङिंइ। छतसि क्हिए सन्तानउँइँले ह्‍युलर्बै ताँन् ह्रेंमैंइ आशिक योंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","च लिउँइँ अब्राहाम ह्रोंसए केब्छैंमैं ङाँर एखइ, झाइले चमैं ताँन् बेर्शेबा समा बा-बालुन् एखइ। धै अब्राहाम बेर्शेबार्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","चए दे त्हे लिउँइँ “मिल्काज्यै क्हिए अलि नाहोरउँइँले च्ह प्रेउँलो फिइमुँ” बिबै ताँ अब्राहामइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","थेब ऊज, चए अलि बूज नेरो आरामए आबा कमूएल, ");
INSERT INTO gvr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","धै केसेद, हजो, पिलदाश, यिदलाप नेरो बतूएल। ");
INSERT INTO gvr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","बतूएल रिबेकाए आबा तइ। चु प्रेउँलो च्हमैं अब्राहामए अलि नाहोरउँइँले मिल्काइ फिब् ग। ");
INSERT INTO gvr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","चइ ब्ह्‍या लसि पखबै रुमा मिं लबै प्ह्रेंस्योज्यै तेबह, गहम, तहस नेरो माका फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","सारा प्रसे ङ्हिस्युसे ङिदिं सोइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","सारा कनान ह्‍युलर्बै किर्यत-अर्बा अथवा हेब्रोन बिबै सहरर सिइ। सारा सियाबइले अब्राहाम बेल्‍ले शोक तसि सिनु थेंबै क्ल्ह्‍योर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","अब्राहाम साराए सिनु मुँबै क्ल्ह्‍योउँइँले रेसि हित्तीमैंने छ बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“ङ अरू ह्‍युलउँइँले खसि क्हेमैंए म्हाँजोर टिइमुँ। ङए प्ह्रेंस्यो सियाइ। छतसि सिनु पाबै छगोंए ल्हागिर क्ल्ह्‍यो घ्रि ङने चुँन् ओ।” ");
INSERT INTO gvr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","हित्तीमैंइ अब्राहामने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ओ चिब, ङिए ताँ थेद्! ङिए म्हाँजोर क्हि ह्रब् सेब् नेरो चिब ग। छतसि ङिए छगोंमैं न्होंर ताँन् भन्दा छ्याँबै छगों त्हाँसि क्हिए प्ह्रेंस्योए सिनु पाद्। क्हिए प्ह्रेंस्योए सिनु पाबै क्ल्ह्‍यो आपिं बिसि ङिइ बिरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","चमैंइ छ बिब् थेसि अब्राहाम हित्तीमैं ओंसों कुरसि चमैंलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","धै चइ चमैंने छ बिइ, “ङए प्ह्रेंस्योए सिनु क्हेमैंए क्ल्ह्‍योर पाल् पिंम् बिस्याँ ङए ताँ घ्रि थेमिंन्। धै सोहोरए च्ह एप्रोनने ङए ताँ बिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","चइ ह्रोंसए म्रों ङाँर मुँबै मक्पेला बिबै उ ङने चुँरिगे। क्हेमैं ताँनए उँइँर च उए सै किंरिगे धै च उए क्ल्हे ङ तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","च त्हेर अब्राहामइ चु ताँ बिरिमा एप्रोन बिबै चिब या हित्तीमैंए च्हों धिंर सहरर्बै थेबै म्रार्न टिरिल। छतसि चर्बै ताँन् म्हिमैंइ थेल्‍ले एप्रोनइ अब्राहामने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ओ चिब, ङए ताँ थेद्! ङए म्रों नेरो म्रों ङाँर मुँबै उ क्हिलाइ पिंस्यो। ङए म्हिमैंए उँइँर्न ङइ च उ क्हिलाइ पिंस्यो। क्हिए प्ह्रेंस्योए सिनु चर्न पाद्।” ");
INSERT INTO gvr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","एप्रोनइ छबिमा अब्राहामइ धबै च ह्‍युलर्बै म्हिमैंलाइ मान लसि फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","झाइले चइ चर्बै ताँन् म्हिमैंइ थेल्‍ले एप्रोनने बिइ, “गार आम्हाँदिल्‍ले ङए ताँ थेद् ओ। ङइ च क्ल्ह्‍योए सै क्हिलाइ पिंस्यो। च मुइ क्हिइ किंनु धै चर ङए प्ह्रेंस्योए सिनु पाल् योंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","छबिमा एप्रोनइ अब्राहामने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ओ चिब, ङए ताँ थेद्! क्ल्ह्‍योए सै चाँदिए मुइ प्लिब्ब्र ग। दिलेया क्हि नेरो ङए न्होंर च तोइ आङिं! क्हिए प्ह्रेंस्योए सिनु चर्न पाद्।” ");
INSERT INTO gvr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","छबिमा अब्राहामइ एप्रोनए ताँ ङिंइ। छतसि चइ हित्तीमैंए उँइँर एप्रोनइ बिब् धों प्रेन् चाँदिए मुइ प्लिब्ब्र च त्हेर चल्दिबै पारइ क्वेसि पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","छले मम्रेए स्यार हारबै मक्पेलार मुँबै एप्रोनए म्रों नेरो चर मुँबै उ, सिधुँमैं ताँन् ");
INSERT INTO gvr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","एप्रोनइ च म्हि च्होंर खबै ताँन् म्हिमैं नेरो हित्तीमैंए उँइँर अब्राहामए मिंर लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","च लिउँइँ अब्राहामइ ह्रोंसए प्ह्रेंस्यो सारा कनान ह्‍युलर हेब्रोनए चेंदो मुँबै मम्रे ङाँर्बै मक्पेलार्बै म्रों ङाँर्बै उर पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","छले च म्रों नेरो चर मुँबै उ हित्तीमैंउँइँले छगोंए ल्हागिर अब्राहामए मिंर दर्ता तइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","अब्राहामए छ्ह ल्हें तसि खेब् तयाल् खाँल। याहवेहजी अब्राहामए तोन्दोंरि सैर आशिक पिंल। ");
INSERT INTO gvr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","तिगें अब्राहामइ ह्रोंसए धिंर्बै ताँन् सैमैं छेनाले ङ्ह्‍योबै केब्छैं चिबने बिइ, “क्हिए यो ङए प्हाँ न्होंर थेंन्। ");
INSERT INTO gvr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","स्वर्ग नेरो पृथ्‍बीर्बै याहवेह परमेश्‍वरए उँइँर ङइ क्हिने कसम चबर ल्हैदिम्। क्हिइ ङए च्हए ल्हागिर तोगो ङ टिबै कनान ह्‍युलर्बै च्हमिरिमैं खाबै ब्ह्‍या लसि खैलसया आपखमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","बरु ङए ह्‍युलर ङए ङेंमैं ङाँर ह्‍यासि ङए च्ह इसहाकल प्ह्रेंस्यो घ्रि पखमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","छबिमा च केब्छैंइ अब्राहामने बिइ, “च च्हमिरि चु ह्‍युलर ङने बालु खल् आङिंइ बिस्याँ, खाब् ह्‍युलउँइँले क्हि खल चर्न क्हिए च्हलाइ ङइ एबोब् वा?” ");
INSERT INTO gvr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","अब्राहामइ चने बिइ, “क्हिइ ङए च्ह चर खैलसे एसि आबोद्। ");
INSERT INTO gvr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ङए आबाए धिं नेरो ङए ह्‍युलउँइँले ङलाइ पखबै स्वर्ग नेरो पृथ्‍बीर्बै याहवेह परमेश्‍वरजी कसम चसि ‘ङइ क्हिए सन्तानलाइ चु ह्‍युल पिंब्मुँ,’ बिसि ङने बाछा फैइमुँ। छतसि ङए च्हए ल्हागिर क्हिइ च क्ल्ह्‍योउँइँले प्ह्रेंस्यो घ्रि पखल खाँरिगे बिसि खीजीन् ह्रोंसए स्वर्गदूत क्हिए ओंसों ओंसों कुलब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","दिलेया च च्हमिरि क्हिने बालु खबै सैं आलस्याँ ङए चु कसम क्हिए फिर ल्हैदिरिब् आरे। क्हिइ ङए च्हलाइ खैलसे चर एसि आबोद्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","झाइले च केब्छैंइ ह्रोंसए क्ल्हे अब्राहामए प्हाँ न्होंर यो थेंसि चु ताँर चने बालु कसम चइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","च लिउँइँ च केब्छैं ह्रोंसए क्ल्हेए च्युउँलो सलु नेरो ताँन् खालर्बै छ्याँ-छ्याँबै सैमैं किंसि अराम-नाहारैमउँइँले तसि नाहोरए ह्‍युलर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","चर फेनेसि सहरए बैरु क्यु खादु ङाँर चइ सलुमैं च्युइँथेंइ। ङेसा छझँ च्हमिरिमैं क्यु खाबर चर खमल। ");
INSERT INTO gvr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","झाइले चइ सैं न्हों-न्हों प्राथना लइ। “ओ ङए क्ल्हेए याहवेह परमेश्‍वर, ङए फिर ल्हयो खसि तिंयाँ ङए के छ्याँब् लमिंन्। झाइले ङए क्ल्हे अब्राहामए फिरै या ल्हयो खमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ङ चु क्यु खादु ङाँर रारिइमुँ, सहरर्बै म्हिमैंए च्हमिमैं क्यु खाबर खसिन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","खाब् च्हमिरिने ङइ ‘क्हिए गौरिउँइँले ङ क्यु थुँल् पिंन्’ बिमुँ, धै चइ ङने ‘अँ अँ थुँन्! ङइ क्हिए सलुमैं या क्यु खासि थुँल् पिंम्,’ बिमुँ, च च्हमिरिन् क्हिए केब्छैं इसहाकए ल्हागिर क्हिजी त्हाँबै प्ह्रेंस्यो तरिगे। छलस्याँ ङए क्ल्हेए फिर क्हिजी ल्हयो खना बिसि ङइ सेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","चइ प्राथना लल् आखाँबै त्हेर्न अब्राहामए अलि नाहोर नेरो मिल्काए च्ह बतूएलए च्हमि रिबेका प्हैंदार गौरि तेंसि खइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","च बेल्‍ले छ्याँब नेरो खाब् मुँयुँमैंने या आरोब मुँल। क्यु खादुर तसि चइ गौरिर क्यु खासि कैंडो क्रेखइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","च लिउँइँ च केब्छैं चने त्होबर न्हेह्‍यासि बिइ, “गार आम्हाँदिल्‍ले क्हिए गौरिउँइँले ङलाइ च्युगुदे क्यु थुँबर पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","चइ “तम्, थुँन्” बिसि आतुरल्‍ले गौरि ह्रोंसए योर थेंसि चलाइ क्यु थुँल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","चलाइ क्यु पिंल् खाँबै लिउँइँ चइ बिइ, “ङइ क्यु खासि क्हिए सलुमैं या म्रेंनाले थुल् पिंम्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","छ बिसि चइ ह्रोंसए गौरिर्बै क्यु डुँडर युसि धबै क्यु खाबर क्यु खादुउँइँ न्हेह्‍याइ। झाइले चए ताँन् सलुमैं या क्यु खासि पिंनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","च म्हि बिस्याँ याहवेहजी ह्रोंसए केमैं छ्याँब लमिंब ङिंब् उ आङिंगे बिसि था सेबर आपोंनले च ङाँइ ङ्ह्‍योरिइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","सलुमैंइ क्यु थुँल् खाँबै लिउँइँ च म्हिइ आधा तोलाए माराए फुलि नेरो तोला च्युए माराए रयाँ ङ्हिं ट्हुइसि रिबेकाने ");
INSERT INTO gvr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“क्हि खाबै च्हमि जा? क्हिए आबाए धिंर ङि टिबै क्ल्ह्‍यो मुँ वा?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","रिबेकाइ चने बिइ, “ङ नाहोरउँइँले मिल्काइ फिबै बतूएलए च्हमि ग।” ");
INSERT INTO gvr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","रिबेकाइ धबै चने बिइ, “ङिने छि नेरो पराल ल्हें मुँ। टिबै क्ल्ह्‍यो या मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","छबिमा च म्हिइ ह्रोंसए क्र कुरसि बेल्‍ले मान्ले यो छ्युँ लसि याहवेहलाइ फ्योसि बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“ङए क्ल्हे अब्राहामए याहवेह परमेश्‍वर बेल्‍ले थेब मुँ। खीजी ङए क्ल्हेने फैबै बाछा पूरा लमिंइ। तलेबिस्याँ याहवेहजी ङलाइ घ्याँर डोरेसि ङए क्ल्हेए ङेंमैंए धिंर पखमिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","च लिउँइँ च च्हमिरि ह्‍यासि ह्रोंसए आमाए परवाने ताँन् ताँमैं बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","रिबेकाल लाबान मिं लबै आघें घ्रि मुँल। च ताँ थेसि लाबन क्यु खादुउँइँ च म्हि मुँबै क्ल्ह्‍योउँइँ न्हेह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","तलेबिस्याँ लाबानइ ह्रोंसए अङाँए नखुँर नथ नेरो योर रयाँ खिब म्रोंल। धै च म्हिइ ङने छ बिल बिबै ताँ चए अङाँउँइँले ओंसोंन् थेल। छतसि लाबान च म्हि ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","छले ह्‍यामा क्यु खादुए रेर च म्हि रारिब् म्रोंसि लाबानइ बिइ, “ओ याहवेहए आशिक योंबै म्हि, धिं न्होंर खो। तले बैरु रारिल? ङइ क्हिए टिबै क्ल्ह्‍यो नेरो सलुमैंए क्ल्ह्‍यो लथेंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","छबिमा च म्हि लाबानने बालु धिंर ह्‍याइ। झाइले लाबानइ सलुमैंए तिमैं सर थेंसि चमैंलाइ पराल नेरो छिमैं पिंइ। धै चइ अब्राहामए केब्छैं नेरो चने मुँबै म्हिमैं प्हले ख्रुबै क्यु पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","झाइले केब्छैंए उँइँर चबै सैमैं या थेंमिंइ। दिलेया चइ बिइ, “ओंसों ङए ताँ क्हेमैंने आबिन् समा ङ तोइ आच।” लाबानइ “क्हिए ताँ तो मुँ? ल्हु, बिद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","झाइले चइ बिइ, “ङ अब्राहामए केब्छैं घ्रि ग। ");
INSERT INTO gvr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","याहवेहजी ङए क्ल्हेए फिर ल्हें आशिक पिंबइले च बेल्‍ले थेबै म्हि तइमुँ। याहवेहजी चलाइ ल्हें र-क्युमैं, मेमैं क्लामैं, मारा, चाँदि, केब्छैं, केब्स्योमैं, सलुमैं नेरो गधामैं पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ङए क्ल्हेए प्ह्रेंस्यो साराई माँब् तबै त्हेरै या चल च्ह घ्रि फिइमुँ। धै चइ ह्रोंसने मुँबै तोन्दोंरि सै चलाइन पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","‘ङए च्हए ल्हागिर क्हिइ तोगो ङ टिबै चु कनान ह्‍युलर्बै कनानीमैंए च्हमिमैं खाबै ब्ह्‍या लसि आपखो!’ बिसि ङए क्ल्हेइ ङने कसम चबर लैदिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","‘बरु ङए ङेंमैं नेरो ङए आबाए धिंर ह्‍यासि ङए च्हए ल्हागिरि प्ह्रेंस्यो घ्रि पखमिंन्।’ ");
INSERT INTO gvr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“‘खनिज्यै च च्हमिरि ङने बालु खल् आङिंस्याँ तो लब्दि?’ बिसि ङइ ङए क्ल्हेने ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","चइ ङने बिइ, ‘ङ याहवेहए सेवा लबै म्हि ग। छतसि खीजीन् ह्रोंसए स्वर्गदूत क्हिने बालु कुलब्मुँ, छले कुलमा क्हिए के छ्याँब तब्मुँ। धै ङए ङेंमैं नेरो ङए आबाए धिंउँइँले ङए च्हए ल्हागिरि क्हिइ प्ह्रेंस्यो घ्रि पखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","क्हि ङए ङेंमैं ङाँर ह्‍यासेया चमैंइ च च्हमि आपिंस्याँ ङइ चबै चु कसम क्हिलाइ ल्हैदिरिब् आरे।’ ");
INSERT INTO gvr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“तिंयाँ क्यु खादुर फेखसि ङइ छ बिसि प्राथना लइ, ‘ओ याहवेह, ङए क्ल्हे अब्राहामए परमेश्‍वर, क्हिए सैं मुँस्याँ क्हिजी ङए केमैं छ्याँब लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ङ्‍ह्‍योद्, ङ इनारर रारिइमुँ। क्यु खाबर खबै च्हमिरि घ्रिने ङइ “क्हिए गौरिउँइँले ङलाइ च्युगुदे क्यु थुँल् पिंन्” बिमा ");
INSERT INTO gvr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","चइ ङने “थुँन्, थुँन् बिदै ङ क्यु थुँल् पिंसि क्हिए सलुमैंलाज्यै या ङइ क्यु ख्योमिंब्मुँ,” बिमुँ, च च्हमिरिन् ङए क्ल्हेए च्हए ल्हागिरि क्हिजी त्हाँबै प्ह्रेंस्यो तरिगे।’ ");
INSERT INTO gvr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ङइ छले सैं न्हों-न्हों प्राथना लल् खाँब् भन्दा ओंसोंन् रिबेका प्हैंदर गौरि थेंसि खइ, धै इनारर तसि क्यु ख्योइ। ङइ चने ‘गार आम्हाँदिल्‍ले ङलाइ क्यु थुँल् पिंन्,’ बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“छ बिबै तोदोंन् चइ ह्रोंसए प्हैंदउँइँले गौरि तसि क्यु थुँन् बिइ। धै क्हिए सलुमैंलाज्यै ङइ क्यु थुँल् पिंब्मुँ बिमा ङइ क्यु थुँइ। च लिउँइँ ङए सलुमैंलाज्यै या चइ क्यु थुँल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“झाइले ङइ ‘क्हि खाबए च्हमि जा?’ बिसि चने ङ्योएमा चइ ‘नाहोर नेरो मिल्काए च्ह बतूएलए च्हमि ग’ बिइ। छबिमा चए नखुँर ङइ फुलि नेरो योर रयाँमैं खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","झाइले ङइ ह्रोंसए क्र कुरसि मान लसि याहवेहलाइ फ्योइ, धै ङए क्ल्हे अब्राहामए याहवेह परमेश्‍वरलाइ धन्यबाद पिंइ। तलेबिस्याँ ङए क्ल्हेए अलिए क्वेंमि चए च्हए ल्हागिर पिंबर ङ फेनल् त्हुबै घ्याँर खीजी डोरेसि पखमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","तारे क्हेमैंइ ङए क्ल्हेए फिर ल्हयो खसि क्ह्रोंसेंन्ले चु के लमिंम् बिस्याँ ङने बिद्। छ आललैया ङने बिद्, झाइले ङ क्योलो त्हेब्रे खनइ तले ह्‍यालै।” ");
INSERT INTO gvr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","च लिउँइँ लाबान नेरो बतूएलइ बिइ, “चु ताँ याहवेहउँइँलेन् तब् ग। छतसि ङि क्हिने छ्याँब आछ्याँब तोइ बिल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ङ्‍ह्‍योद्! रिबेका क्हिए उँइँर्न मुँ। याहवेहजी बिब् धोंले च क्हिए क्ल्हेए च्हए प्ह्रेंस्यो तरिगे। छतसि चलाइ बोसि ह्‍याद्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","अब्राहामए केब्छैंइ चमैंए ताँ थेबै लिउँइँ सर कुरसि मान लसि याहवेहलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","च लिउँइँ चइ मारा नेरो चाँदिए घाँनामैं नेरो क्वेंमैं पखसि रिबेकालाइ पिंइ। चए आघें नेरो आमालाज्यै या सै ल्हें फेबै ह्रोमै-क्होल्सैमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","झाइले च नेरो चने मुँबै म्हिमैंइ चसि थुँसि च म्हुँइँस चर्न थोइ। न्हाँगर रेसि चइ बिइ, “ङए क्ल्हे ङाँर तारे ङ ह्‍याल् पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","दिलेया रिबेकाए आघें नेरो आमाइ बिइ, “ङिए च्हमि कुरो-च्युरोदे चुर ङिनेन् टिल् पिंन्। च लिउँइँ च ह्‍यास्याँ तम्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","छबिमा चइ बिइ, “ङ क्हैल् आलमिंन्। तलेबिस्याँ ङ फेनल् त्हुबै क्ल्ह्‍योर याहवेहजी डोरेमिंइमुँ। छतसि ङ ङए क्ल्हे ङाँर ह्‍याम्। ङलाइ ह्‍याल् पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","चमैंइ बिइ, “छबिस्याँ च्हमि हुइसि चइ तो बिमुँ ङि चए सुँउँइँलेन् थेम्।” ");
INSERT INTO gvr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","झाइले चमैंइ रिबेका हुइसि “क्हि चु म्हिने बालु ह्‍याम्मा?” बिसि ङ्योएमा चइ “अँ, ङ ह्‍याम्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","छतसि चमैंइ ह्रोंसए रिं रिबेका नेरो चए केब्स्यो, अब्राहामए केब्छैं नेरो चने खबै म्हिमैंने कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","चमैंइ रिबेकाए फिर आशिक पिंसि बिइ, “ओ ङिए रिं, क्हिल ल्हें ल्हें प्हसेमैं तरिगे धै क्हि ल्हें सन्तानए आमा तरिगे, झाइले क्हिए सन्तानइ खेंमैंने ख्रे लब्मैंए सहरमैं ट्होरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","च लिउँइँ रिबेका नेरो चए केब्स्योमैं सलुर क्रेसि च म्हिए लिलि ह्‍याइ। छले रिबेका बोसि च केब्छैं चए घ्याँ क्हाइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","चमैं फेनेबै त्हेर इसहाक बेअर-लहैरोइउँइँले खल। तलेबिस्याँ च नेगेव बिबै ह्‍युलर टिमल। ");
INSERT INTO gvr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","इसहाक ङेसा छझँ स्युरबर बैरु त्होंयाल। चइ ङ्ह्‍योमा सलुमैं खरिब् म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","रिबेकाज्यै या इसहाकलाइ म्रोंइ। झाइले सलुउँइँले तसि ");
INSERT INTO gvr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“ङ्योने त्होबर खरिबै म्हि खाब् जा?” बिसि ङ्योएमा केब्छैंइ बिइ, “च ङए क्ल्हे ग।” छबिमा रिबेकाइ क्रमुँइ ह्रोंसए लि हुइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","च लिउँइँ च केब्छैंइ ह्रोंसइ लबै ताँन् केमैं इसहाकने बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","झाइले इसहाकइ रिबेका ह्रोंसए आमा साराए तम्बुर बोसि ब्ह्‍या लइ। छले रिबेका इसहाकए प्ह्रेंस्यो तइ। धै चइ रिबेकालाइ म्हाँया लइ। छले ह्रोंसए आमा सियाबै लिउँज्यै या इसहाकइ भों योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","अब्राहामइ धबै ब्ह्‍या लइ। चए मिं कतूरा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","कतूराइ अब्राहामउँइँले जिम्रान, योक्षान, मदान, मिद्यान, यिशबाक नेरो शूह बिबै च्हमैं फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","योक्षानइ शेबा नेरो ददान बिबै च्हमैं योंइ। ददानए प्हसेमैं अश्शूरी, लतूशी नेरो लऊम्मीमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","मिद्यानए च्हमैं एपा, एपेर, हानोक, अबिदा नेरो एल्दा मुँल। चु ताँन् कतूराए सन्‍तानमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","दिलेया अब्राहामइ ह्रोंसने मुँबै तोन्दोंरि सै इसहाकलाइन पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","च सोगों मुँमन् चइ पखबै प्ह्रेंस्योए च्हमैंलाइ चइ पिंदा ङ्हाँबै सैमैं पिसि ह्रोंसए च्ह इसहाकउँइँले फ्रेवासि चमैं स्यारउँइँ कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","अब्राहाम प्रसे ङिच्युसे ङ्‍हदिं (१७५) समा सोइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","अब्राहाम ल्हें समा सोसि खेब् तसि सिइ। धै चए सियाबै खेमैंने त्होनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","झाइले चए च्हमैं इसहाक नेरो इश्माएलइ हित्ती सोहोरए च्ह एप्रोनए म्रोंर मुँबै मम्रे ङाँर्बै मक्पेलाए उ न्होंर चलाइ पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","च म्रों ङाँर्बै उ अब्राहामइ हित्तीमैंउँइँले किंल। अब्राहाम नेरो चए प्ह्रेंस्यो सारा चर्न पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","अब्राहाम सिबै लिउँइँ चए च्ह इसहाकए फिर परमेश्‍वरजी आशिक पिंइ। च त्हेर इसहाक बेअर-लहै-रोइ ङाँर टिमल। ");
INSERT INTO gvr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","साराए केब्स्यो मिश्रीस्यो हागारउँइँले फिबै अब्राहामए च्ह इश्माएलए प्हसेमैंए ताँ चुन् ग: ");
INSERT INTO gvr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","इश्माएलए च्हमैंए मिं चुमैं ग: इश्माएलए च्ह थेब नबायोत मुँल च लिउँइँ केदार, अदबेल, मिब्साम, ");
INSERT INTO gvr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","मिश्मा, दुमा, मस्सा, ");
INSERT INTO gvr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","हदद, तेमा, यतूर, नापीश नेरो केदमा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","इश्माएलए च्हमैंए मिं चुमैंन् ग: चमैं च्युसे ङ्हिं कुलए खेमैं मुँल। छले चमैंए मिं खेंमैं टिबै ह्‍युल नेरो क्ल्ह्‍योमैंने क्ह्रिल्‍ले थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","इश्माएल प्रसे सोंच्युसे ङिदिं तमा सियाइ, धै ह्रोंसए खेमैंने त्होनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","इश्माएलए प्हसेमैं शुरउँइँले हवीलाए म्हाँजोर्बै क्ल्ह्‍योर टिमल। च क्ल्ह्‍यो मिश्रर्बै स्यारउँइँ पूर्वउँइँ अश्शूर ह्‍याबै घ्याँर मुँल। चमैं खेंमैंए आघें-अलिमैंने आक्ह्रिसि ह्रेंगो टिनेल। ");
INSERT INTO gvr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","अब्राहामए च्ह इसहाकए ताँ छले मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","इसहाक प्लिच्यु बर्षर्बै तमा पद्दन-आरामथें अरामी बिबै बतूएलए च्हमि रिबेकाने ब्ह्‍या लइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","रिबेका थरि तबइले इसहाकइ ह्रोंसए प्ह्रेंस्योए ल्हागिर याहवेहने प्राथना लइ। चए प्राथना याहवेहजी थेसि रिबेकाइ प्हसे नोइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","फो न्होंर्बै कोलोमैं फो न्होंर्न खें-खेंमैंन् नेबर होंइ। छतमा चइ याहवेहने “ङए फो न्होंर तले छ तइमुँ?” बिसि ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","याहवेहजी चने बिइ, “क्हिए फोर ह्रें ङ्हिं मुँ, क्हिए फोउँइँलेन् चमैं ह्रें ङ्हिं तसि स्यो-स्योले फिब्मुँ। आघें भन्दा अलि भोंब तब्मुँ। धै थेबइ च्योंबए सेवा लब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","झाइले चइ प्हसे फिबै त्हे तमा। चए फोर जौंले प्हसेमैं मुँन। ");
INSERT INTO gvr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","थेब ज्यु तिगोंन् ओ-ओल् ब्योंबै मुइए क्वें खिब् धों ब्योंब फिइ। छतसि चए मिं एसाव थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","च लिउँइँ याकूब चए अलि एसावए प्हले तिंजा योइ क्हासि त्होंइ। छतसि चए मिं याकूब थेंइ। रिबेकाइ चमैं फिबै त्हेर इसहाक टुच्यु बर्षर्बै तल। ");
INSERT INTO gvr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","चमैं थेब् तसि आघें एसाव बेल्‍ले छेनाले मेत्हँले ल्हिल् ह्रब तइ। धै याकूब बिस्याँ धिर्न च्याँले टिरिब तइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","एसाव हेर ह्‍यासि मेत्हँले ल्हिसि फोमैं-एमैं सै पुइसि ह्रोंसए आबालाइ से चल् पिंमल। छतसि इसहाकइ च्ह थेबलाइ म्हाँया लमल। दिलेया रिबेकाइ बिस्याँ च्योंब च्ह याकूब म्हाँया लमल। ");
INSERT INTO gvr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","तिगें याकूबइ मस्याँ ट्हा तेरिबै त्हेर एसाव हेउँइँले युइ। च बेल्‍ले फो ख्रेंरिल। ");
INSERT INTO gvr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","छतमा एसावइ याकूबने “ङ बेल्‍ले फो ख्रेंइमुँ, च मस्याँ खु च्हौदे थुँल् पिंन्,” बिइ। (छतसि चने एदोम बिम्।) ");
INSERT INTO gvr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","छबिमा याकूबइ बिइ, “ओंसों च्ह थेबइ योंल् त्हुबै हग ङ पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","एसावइ बिइ, “ङम् सिबर्न होंइ। तारे ङइ योंबै हगल तो के?” ");
INSERT INTO gvr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","याकूबइ बिइ, “क्हिइ योंबै च्ह थेबै हग ङने पिंम् बिसि ओंसों बाछा फैद्।” छबिमा एसावइ बाछा फैइ। झाइले चइ योंबै हग याकूबलाइ पिंवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","च लिउँइँ याकूबइ एसावलाइ क्हें नेरो मस्याँ ट्हा पिंइ। चब-थुँब् लसि एसाव ह्रोंसए घ्याँ क्हाइ। छले एसावइ ह्रोंसइ योंबै हग तो धोंइ आङ्हाँल्‍ले पिवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ओंसों अब्राहामए पलोर तब् धों तबै अँङ्गल् धबै इसाहकए पलोरै या तइ। छतसि इसाहक पलिश्‍तिमैंए अबीमेलेक म्रुँ ङाँर गरार ह्‍युलर ह्‍याइ ");
INSERT INTO gvr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","तलेबिस्याँ याहवेहजी इसहाक ङाँर युसि बिइ, “क्हि मिश्र ह्‍युलर आह्‍याद्! ङइ क्हिने टिद् बिबै ह्‍युलर्न टिद्। ");
INSERT INTO gvr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ङ क्हिने बालु तब्मुँ, धै क्हिए फिर आशिक पिंब्मुँ। चु ताँन् ह्‍युल क्हि नेरो क्हिए सन्तानमैं पिंब्मुँ। क्हिए आबा अब्राहामने बालु फैबै बाछा ङइ पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","मुर्बै सारमैं धोंले क्हिए सन्तानमैं ल्हें लमिंब्मुँ। धै चु ताँन् ह्‍युल चमैंलाइ पिंब्मुँ। क्हिए सन्तानमैंउँइँलेन् ह्‍युलर्बै ताँन् ह्रेंमैंइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","तलेबिस्याँ अब्राहामइ ङइ बिबै ताँमैं ङिंइ, धै ङइ लद् बिबै केमैं या लइ।” ");
INSERT INTO gvr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","छतसि इसहाक गरार ह्‍युलर्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","च क्ल्ह्‍योर्बै म्हिमैंइ इसहाकाए प्ह्रेंस्योए बारेर ङ्योएमा चइ “च ङए अङाँ ग” बिइ। तलेबिस्याँ रिबेका बेल्‍ले छ्याँब मुँल, छतसि “चर्बै म्हिमैंइ ङलाइ सैवासि ङए प्ह्रेंस्यो बोवाम् उ?” ङ्हाँसि च ङ्हिंइ। छतसि रिबेकालाइ ह्रोंसए प्ह्रेंस्यो बिल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","इसहाक चर ल्हें त्हिंइ टिबै लिउँइँ पलिश्तीमैंए अबीमेलेक म्रुँइ झ्यालउँइँले ङ्ह्‍योमा इसहाक ह्रोंसए प्ह्रेंस्योने बालु म्हाँया लरिब् म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","छतब् म्रोंमा अबीमेलेकइ इसहाक हुइसि बिइ, “चम् क्हिए प्ह्रेंस्योन् मुँनदि। तले क्हिइ ‘ङए अङाँ ग’ बिसि ङिने स्योर तेल?” इसाकइ चने बिइ, “च ङए प्ह्रेंस्यो ग बिस्याँ चुर्बै म्हिमैंइ ङलाइ सैवाम् उ बिसि ङइ मैंल।” ");
INSERT INTO gvr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","अबीमेलेकइ बिइ, “क्हिइ ङिने चु तो लल? म्हिमैंइ क्हिए प्ह्रेंस्योने आछ्याँबै के लस्याँ ङिए फिर क्हिइ छ्याब् ल्हैदिमल।” ");
INSERT INTO gvr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","झाइले अबीमेलेकइ “चु म्हि नेरो चुए प्ह्रेंस्योलाइ खाबज्यै तोइ आलद्। खाबज्यै या चुमैंलाइ तोइ लस्याँ च खैलसे सिल् त्हुब्मुँ” बिसि ताँन् म्हिमैंलाइ लोदा सैंदा लइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","चर टिमा इसहाकइ खेति ल्हैदिइ। झाइले याहवेह परमेश्‍वरजी चए फिर आशिक पिंसि च बर्षर चइ ल्हें ल्हें रा-रोमैं खुइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","छले च प्लब ततै ह्‍यासि झन् बेल्‍ले प्लबै म्हि तइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","चल ल्हें र-क्युमैं, मे-क्ल्हामैं नेरो केब्छैं-केब्स्योमैं तब् म्रोंसि पलिश्तीमैंइ चए फिर ह्रिस लबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","छतसि ओंसोंन् अब्राहामए केब्छैंमैंइ ताबै ताँन् क्यु खादुमैं पलिश्तीमैंइ युँमा नेरो स झोंसि म्रुवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","इसहाक बेल्‍ले प्लब् म्रोंसि अबीमेलेकइ चने बिइ, “तारे ङिए ह्‍युलउँइँले क्हि ह्‍याद्, तलेबिस्याँ तिंजरो ङि भन्दा क्हि बेल्‍ले भोंब तइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","छबिमा इसहाक च क्ल्ह्‍योउँइँले त्होंह्‍यासि गरारए ब्याँसिर तम्बु टौंदिसि चर्न टिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","झाइले ओंसोंन् ह्रोंसए आबाए पलोर ताथेंबै क्यु खादुमैं धबै ताबर होंइ। तलेबिस्याँ अब्राहाम सिबै लिउँइँ पलिश्तीमैंइ च क्यु खादुमैं म्रुवाल। धै चइ च इनारए मिं ह्रोंसए आबाइ ओंसों थेंबै मिंन् थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","झाइले इसहाकए केब्छैंमैंइ ब्याँसिर क्यु खादु तामा क्युए मुल स्याइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","दिलेया गरारर्बै प्ह्रोंछैंमैंइ “चु क्यु ङिल् ग” बिसि इसहाकए प्ह्रोंछैंमैंने प्होंबर होंइ। छतसि इसहाकइ च क्यु खादुए मिं “एसेक” बिब् थेंइ। तलेबिस्याँ चमैं प्होंरिल। ");
INSERT INTO gvr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","धबै चमैंइ अर्को क्यु खादु तामा चरै या छलेन् प्होंगि तइ। छतसि इसहाकइ चए मिं “सित्ना” थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","च क्ल्ह्‍योउँइँले अर्को क्ल्ह्‍योर ह्‍यासि चइ धबै इनार ताइ। चर बिस्याँ खाबज्यै या प्होंगि लबर आख। छतसि चइ च इनारए मिं रहोबोत बिसि थेंइ। “तारेम् याहवेह परमेश्‍वरजी ङ्योलाइ टिबै क्ल्ह्‍यो पिंइमुँ। छतसि ङ्यो चु क्ल्ह्‍योर आशिक योंसि ल्हें ततै ह्‍याब्मुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","च लिउँइँ इसहाक च क्ल्ह्‍यो वाथेंसि बेर्शेबा बिबै क्ल्ह्‍योर ‍टिनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","याहवेह च म्हुँइँसर्न इसहाक ङाँर युसि बिइ, “ङ क्हिए आबा अब्राहामए परमेश्‍वर ग। आङ्हिंन्! तलेबिस्याँ ङ क्हिने बालुन् मुँ। ङइ क्हिए फिर आशिक पिंब्मुँ, ङए सेवा लबै अब्राहामने बालु ङइ बाछा फैब् धोंले क्हिए सन्तानमैं ङइ ल्हें लमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","झाइले इसहाकइ चर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि याहवेहए मिं क्वेइ। धै ह्रोंसए तम्बु चर्न टौंदिइ। चरै या चए केब्छैंमैंइ अर्को क्यु खादु घ्रि ताइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","तिगें अबीमेलेक ह्रोंसए सल्‍ला पिंबै अहुज्जत नेरो ह्रोंसए फौजर्बै सेनापति पिकोललाइ किंसि गरारउँइँले इसहाक ङाँर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","इसहाकइ चमैंने बिइ, “ओंसों क्हेमैंइ ह्रिस लसि ङलाइ ल्हावाइ। तोगो क्हेमैं चुर तो लबर खल?” ");
INSERT INTO gvr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","चमैंइ बिइ, “याहवेह क्हिने बालु मुँ बिसि ङिइ सेइ। छतसि ङ्योए न्होंर तोइ आछ्याँबै केमैं आतरिगे बिसि बाछा घ्रि फैले बिसि ङि खब् ग। ");
INSERT INTO gvr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","छ लस्याँ ङिए फिर क्हिइ आछ्याँब लरिब् आरे। ङिज्यै या ङिए ह्‍युलउँइँले क्हिलाइ तोइ आलल्‍ले छेनालेन् कुल्मिंल। क्हि याहवेहए आशिक योंबै म्हि मुँन।” ");
INSERT INTO gvr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","छबिमा इसहाक सैं तोंसि चमैंलाइ चब् थुँब् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","च प्हँन्हाँग्धों न्हाँगर्न रेसि खेंमैं बाछा फैसि क्ह्रिइ। च लिउँइँ इसहाकइ चमैं ह्‍याल् पिंइ। छले चमैं क्ह्रिसि छेनाले फ्रेयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","च त्हिंइर्न इसहाकए केब्छैंमैंइ खेंमैंइ ताबै इनारए बारेर इसहाकने बिइ, “ङिइ ताबै क्ल्ह्‍योर क्यु त्होंइ।” ");
INSERT INTO gvr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","छबिमा इसहाकइ च क्यु खादुए मिं “शिबा” थेंइ। छतसि च सहरए मिं तिंजरो या बेर्शेबा बिम्। ");
INSERT INTO gvr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","एसाव प्लिच्यु बर्षर्बै तमा हित्ती च्हमिरिमैं ङ्हिं ब्ह्‍या लइ। प्ह्रेंस्यो घ्रिए मिं यहूदीत मुँल। चए आबा हित्ती बेरी बिब् मुँल। अर्को प्ह्रेंस्योए मिं बासमत मुँल। चए आबाए मिं हित्ती एलोन मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","च च्हमिरिमैं ङ्हिंइ खेंमैंए कें-स्युइमि इसहाक नेरो रिबेकालाइ ककाँ क्युँ-क्युँ ङ्हाँल् लइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","इसहाक खेब् तयाल। छतसि चइ मि छेनाले म्रोंल् आखाँमल। तिगें इसहाकइ ह्रोंसए च्ह थेब एसाव हुइसि बिइ, “ओ ङए च्ह।” चइ बिइ, “होइ आबा! क्हिए ल्हागिर ङइ तो लदु?” ");
INSERT INTO gvr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","इसाहकइ बिइ, “ङ खेब् तयाइमुँ। ङ खोंयों सिम् बिसि ङइ आसे। ");
INSERT INTO gvr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","छतसि क्हि हेर ह्‍यासि फो सैसि पुइ यु। ");
INSERT INTO gvr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","धै चए ट्हा लिंन्ले ह्‍योसि ङ ङाँर पखो, ङ सिब् भन्दा ओंसों च ट्हा चसि क्हिलाइ आशिक पिंम्।” ");
INSERT INTO gvr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","इसहाकइ एसावने चु ताँमैं बिरिमा चए प्ह्रेंस्यो रिबेकाइ थेरिल। झाइले एसाव हेर फो सैबर ह्‍यामा ");
INSERT INTO gvr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","रिबेकाइ ह्रोंसए च्ह च्योंब याकूबने बिइ, “क्हिए आबाइ क्हिए आघें एसावने ");
INSERT INTO gvr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘हेर ह्‍यासि फो सै पखसि चए ट्हा लिंन्ले ह्‍योसि पखो। च ट्हा चसि ङ सिब् भन्दा ओंसों याहवेहए उँइँर ङइ क्हिए फिर आशिक पिंब्मुँ,’ बिसि ताँ सेरिब ङइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","छतसि च्हेज्यों, ङइ बिबै ताँ ङिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","प्ह्रोंर ह्‍यासि छ्याँ-छ्याँबै र म्होदो ङ्हिं सैसि पखो। झाइले क्हिए आबाइ खोबै ट्हा ङइ ह्‍योमिंस्यो। ");
INSERT INTO gvr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","च ट्हा किंसि क्हि आबा ङाँर ह्‍याद्। झाइले च चसि च सिब् भन्दा ओंसों क्हिलाइ आशिक पिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","याकूबइ ह्रोंसए आमा रेबेकाने बिइ, “आमा, ङए आघें एसाव मुइ ल्हें मुँबै म्हि ग। ङल मुइ आरे। ");
INSERT INTO gvr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","आबाइ ङलाइ छुइ बिस्याँ ङ स्योर्गु ग बिसि आबाइ था सेब्मुँ। छतसि आशिक आङिंन ङए फिर सराप ग खब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","आमाइ चने बिइ, “च्हेज्यों, क्हिए फिर पिंबै सराप ङए फिर्न खरिगे! ङइ बिब् धों लद्। ह्‍यासि च रमैं सैसि पखो।” ");
INSERT INTO gvr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","आमाइ छबिमा च ह्‍यासि र-म्होदोंमैं सै पखसि आमाने पिंइ। झाइले याकूबए आबा इसाहकइ खोबै ट्हा चइ ह्‍योमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","झाइले ह्रोंसए च्ह थेब एसावए छ्याँ-छ्याँबै क्वेंमैं ट्हुइसि रिबेकाइ च्ह च्योंब याकूब खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","झाइले रए ट्हुबिमैं याकूबए यो नेरो खरिर खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","च लिउँइँ चइ ह्‍योबै लिंबै ट्हा नेरो क्हें ह्रोंसए च्ह याकूबए योर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ट्हा किंसि याकूब ह्रोंसए आबा ङाँर ह्‍यासि “ओ आबा!” बिमा इसहाकइ बिइ, “होइ, क्हि खाब् जा? ठागु उ आच्यों जा?” ");
INSERT INTO gvr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","याकूबइ आबाने बिइ, “ङ क्हिए च्ह थेब एसाव ग। क्हिइ बिब् धोंले ङइ लइमुँ। तारे रेसि क्हुँन्, ङइ सैसि पखबै से ट्हा चदु, धै ङलाइ आशिक पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","इसहाकइ ह्रोंसए च्हने “ओ ठागु, क्हिइ च्हौ युनन् खैले फो स्यासि सैइ?” बिसि ङ्योएमा चइ बिइ, “याहवेह क्हिए परमेश्‍वरजी ल्होमिंबइले ङइ चु योंल् खाँइ।” ");
INSERT INTO gvr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","छबिमा इसहाकइ याकूबने बिइ, “ठागु, ङ ङाँर खोदि, क्हि ङए च्ह थेब एसाव ङिंब् उ आङिं बिसि ङो सेबर ङइ क्हि छुइम्।” ");
INSERT INTO gvr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","याकूब ह्रोंसए आबाए ङाँर ह्‍याइ। झाइले इसहाकइ चलाइ छुइसि बिइ, “कैम् याकूबल् ग, योमैं बिस्याँ एसावल् धोंन् तब मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","चए योमैं चए आघें एसावल् धोंन् तब मुइ-मुइ मुँल। छतसि इसहाकइ छ्योंलों फेल् आखाँ। छान् तलेया इसहाकइ याकूबए फिर आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","इसहाकइ चने “क्हि क्ह्रोंसेंन ङए च्ह एसावन् वा?” बिसि ङ्योएमा याकूबइ बिइ, “अँ ङ एसावन् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","च लिउँइँ इसहाकइ बिइ, “क्हिइ सैसि पखबै से ट्हा चुर पखो। च चसि क्हिलाइ आशिक पिंस्यो।” आबाइ छबिमा याकूबइ से ट्हा पखसि आबालाइ पिंमा खिइ चै। झाइले याकूबइ अँगुरए प्हा या आबालाइ पिंनेइ धै आबाइ थुँइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","च लिउँइँ इसहाकइ चने बिइ, “ठागु, ङ ङाँर खसि ङ म्वें लद्।” ");
INSERT INTO gvr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","याकूब आबा ङाँर ह्‍यासि म्वें लमा इसहाकइ चए क्वेंमैंए थाँ किंसि “ङए च्हए थाँ याहवेहजी आशिक पिंबै म्रोंर्बै थाँ धोंबन् मुँ बिसि चए फिर आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","परमेश्‍वरजी मुउँइँले शीतमैं कुल्मिंरिगे धै क्हिए म्रोंर ल्हें रा-रोमैं रोरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ह्रें-ह्रेंर्बै म्हिमैं क्हिए केब्छैंमैं तरिगे, चमैंइ क्हि फ्योरिगे। क्हिए आघेंमैं-अलिमैंए फिर क्हि क्ल्हे तरिगे, झाइले क्हिए आमाउँइँले योंबै सन्तानमैं क्हिए ओंसों कुररिगे। क्हिए फिर सराप झोंब्मैं ताँनइ सराप योंरिगे, झाइले क्हिए फिर आशिक पिंब्मैं ताँनइ आशिक योंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","इसहाकइ याकूब आशिक पिंल् खाँबै लिउँइँ याकूब ह्रोंसए आबाउँइँले ह्‍याबै तोदोंन् चए आघें एसाव हेउँइँले फो सैसि युइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","चज्यै बेल्‍ले लिंबै से ट्हा तेसि ह्रोंसए आबा ङाँर पखसि बिइ, “आबा, रेसि क्हुँन्। ङइ पखबै से ट्हा चसि ङए फिर आशिक पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","इसहाकइ चने “क्हि खाब् जा?” बिसि ङ्योएमा चइ बिइ, “ङ क्हिए च्ह थेब एसाव ग।” ");
INSERT INTO gvr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","इसहाक बेल्‍ले त्हारदै बिइ, “फो सैसि ङ ङाँर ओंसों से ट्हा पखबै म्हि खाब् जा? क्हि खब् भन्दा ओंसोंन् ङइ चसि चए फिर आशिक पिंल् खाँइ! छतसि तारे च आशिक योंबै म्हि तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","चु ताँ थेसि एसाव बेल्‍ले सैं नसि थेबै कैले क्रोदै “ओ आबा, ङलाज्यै या आशिक पिंन्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","दिलेया इसहाकइ बिइ, “क्हिए अलि स्योर तेसि खइ, धै क्हिइ योंल् त्हुबै आशिक चइ बोल् खाँइ।” ");
INSERT INTO gvr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","छबिमा एसावइ बिइ, “चए मिं याकूब थेंब ठिकन् मुँन! च बेल्‍ले स्योर तेबै म्हि ग। तोगो चइ ङने ङ्हिब्ले स्योर तेल् खाँइ। ओंसों चइ ‘च्ह थेबइ योंबै हग’ ङउँइँले किंवाँइ। तोगो या ङइ योंल् त्हुबै आशिक स्योर तेसि बोयान। ओ आबा, ङए ल्हागिर क्हिइ आशिक घ्रि या आथेंइमुँ वा?” ");
INSERT INTO gvr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","इसहाकइ एसावने बिइ, “ओ ठागु, च क्हिए फिर्बै चिब ङइ लमिंल् खाँइ। धै चए ताँन् आघें-अलिमैं या ङइ चए केब्छैंमैं लवाइ। म्रोंर्बै रा-रोमैं नेरो अँगुरए प्हा या ङइ चन् पिंवाँइ। तारे क्हिए ल्हागिर ङइ तोइ आशिक पिंल् आखाँ!” ");
INSERT INTO gvr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","एसावइ आबाने धबै बिइ, “ओ आबा, क्हिने बालु आशिक च्हग मत्‍त्रे मुँ रो वा? ङलाज्यै या आशिक पिंन् बिसि” एसाव थेबै कै तेसि क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","झाइले चए आबा इसहाकइ बिइ, “क्हिए ल्हागिर मुउँइँले शीत आयु। क्हिए म्रोंर्बै स या छ्याँब् तरिब आरे। ");
INSERT INTO gvr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","क्हि सेलाँए भरर सोब्मुँ, धै क्हि अलिए केब्छैं तब्मुँ। दिलेया ङ ‘क्हिए केब्छैं आङिं, क्हिए न्होंर ङ आटि’ बिसि चए न्होंरउँइँले क्हि स्योब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","आबाइ याकूबलाइ आशिक पिंबइले एसाव ह्रोंसए अलि याकूबने ख्रे लबर होंइ। छतमा “ङए आबा सिबै त्हे तखइ। च सिबै लिउँइँ ङइ याकूब सैवाब्मुँ” बिसि एसावइ सैं न्हों-न्हों मैंइ। ");
INSERT INTO gvr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","दिलेया एसावइ लल् म्हैबै ताँ रिबेकाइ थेसि च्ह च्योंब याकूब हुइसि बिइ, “थेद्, क्हिए आघें एसावइ क्हि सैब् बिसि दाउ लरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","छतसि ओ च्हेज्यों, ङइ बिबै ताँ ङिंन्। क्हि हरान ह्‍युलर क्हिए मामा लाबान ङाँर भौदिह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","क्हिए आघेंए ह्रिस आम्हन् समा मामानेन् टिद्। ");
INSERT INTO gvr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","आघेंने बालु क्हिइ लबै केमैं चइ म्‍लेसि क्हिने ह्रिस खब म्हबै लिउँइँ ङइ क्हि किंबर म्हिमैं कुल्मिंब्मुँ। क्हेमैं ङ्हिं तिंगेंर्न ङउँइँले फ्रेयाब ङइ सैदिल् आखाँ!” ");
INSERT INTO gvr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","च लिउँइँ रिबेकाइ इसहाकने बिइ, “एसावइ ब्ह्‍या लबै चु हित्तीस्योमैंइ ङलाइ ककाँ क्युँ-क्युँ ङ्हाँन् लइ। याकूबज्यै चु ह्‍युलर्बै छाबै हित्तीस्योन् ब्ह्‍या लस्याँ ङ तले सोरिब? सिलेन् तम्!” ");
INSERT INTO gvr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","झाइले इसहाकइ याकूब हुइसि आशिक पिंसि बिइ, “ओ च्हेज्यों, क्हिइ कनानी च्हमिरिमैं खाबै या ब्ह्‍या आलद्। ");
INSERT INTO gvr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","पद्दन-आराम बिबै ह्‍युलर ङए कें क्हिए बाज्यु बतूएलए धिंर ह्‍यासि क्हिए मामा लाबानए च्हमि घ्रि ब्ह्‍या लद्। ");
INSERT INTO gvr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","तोन्दोंरि सै लल् खाँबै परमेश्‍वरजी क्हिए फिर आशिक पिंरिगे, धै क्हिइ प्हसेमैं ल्हें योंसि क्हिए सन्तान बेल्‍ले ल्हें तरिगे। धै क्हि ल्हें ह्रेंमैंए खे तरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","क्हि तोगो चुर आगुए ह्‍युलर टिरिइमुँ, दिलेया परमेश्‍वरजी चु ह्‍युल अब्राहामलाइ पिंब् ग। क्हि चु ह्‍युलर्बै क्ल्हे तरिगे बिसि परमेश्‍वरजी अब्राहामए फिर पिंबै आशिक क्हि नेरो क्हिए प्हसेंमैंलाज्यै या पिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","छबिसि इसहाकइ याकूब कुलइ। धै पद्दन-आराम बिबै ह्‍युलर एसाव नेरो याकूबए आमा रिबेकाए आघें अरामथें बतूएलए च्ह लाबान ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","इसहाकइ याकूबए फिर आशिक पिंसि प्ह्रेंस्यो पखबर पद्दन-आरामर कुलब नेरो “क्हिइ कनानी च्हमिरिमैं खाबै या ब्ह्‍या लसि आपखो,” बिबै ताँ एसावइ सेइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","धै आबा-आमाए ताँ ङिंसि याकूब पद्दन-आराम ह्‍युलइ ह्‍यान बिबै ताँ या एसावइ सेइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","झाइले “ङए आबाइ कनानी च्हमिरिमैं आखोमन बिबै या एसावइ क्होइ।” ");
INSERT INTO gvr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","छतसि एसाव इश्माएल ङाँर ह्‍यासि चए च्हमि महलत ब्ह्‍या लसि पखइ। महलत नबायोतए अङाँ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","याकूब बेर्शेबा नाँस वाथेंसि हारान बिबै ह्‍युलउँइँ ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","क्ल्ह्‍यो घ्रिर फेबै लिउँइँ म्हुँइँस तयाबइले च चर्न टिइ। धै च क्ल्ह्‍योर्बै युँमा घ्रि किंसि ह्रोंसए क्रेगुँ लसि रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","छले रोरिमा चइ छाबै म्होंड म्रोंइ: सउँइँले मु समा ह्‍याबै लि घ्रि मुँन, चए च्हो मुर्न फेनेब् मुँन। धै परमेश्‍वरए दूतमैं चर क्रेब माइ तब लमन। ");
INSERT INTO gvr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","याहवेह चए रेर रासि याकूबने बिइ, “ङ याहवेह, क्हिए बाज्यु अब्राहामए परमेश्‍वर नेरो क्हिए आबा इसहाकए परमेश्‍वर ग। क्हि तोगो रोरिबै क्ल्ह्‍यो क्हि नेरो क्हिए सन्तानमैं ङइ पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","क्हिए सन्तानमैं ह्‍युलर्बै स त्हुल् धोंलेन् ल्हें तब्मुँ। क्हिए सन्तान स्यार (पूर्व) छ्यो-न्हुँ (पश्‍चिम) च्योंबो (उत्तर) नेरो छ्यो ल्हुइ (दक्षिणाइ) खन्तोंदोंन् ल्हें तदै ह्‍याब्मुँ। क्हि नेरो क्हिए सन्तानउँइँले ह्‍युलर्बै ताँन् म्हिमैंइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ङ क्हिने बालु तब्मुँ। क्हि खनिर ह्‍यालेया ङइ जोगेमिंब्मुँ। धै क्हिलाइ चु ह्‍युलर एपखब्मुँ। ङइ क्हिने बिबै बाछा पूरा आलन् समा ङइ क्हि पिरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","झाइले याकूब न्हरुउँइँले छोरसि बिइ, “क्ह्रोंसेंन चु क्ल्ह्‍योर परमेश्‍वर मुँन छाबै ताँ ङइ आसेल।” ");
INSERT INTO gvr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","च बेल्‍ले ङ्हिंसि “चु बेल्‍ले पबित्र क्ल्ह्‍यो मुँन! चु परेमेश्‍वरए धिं मुँन! चु क्ल्ह्‍यो स्वर्गए म्रा ग मुँन,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","याकूब न्हाँकर्न रेसि चइ क्रेगुँ लबै युँमा किंसि त्हो धोंले क्योइ, धै चए च्होर छ्युगु युमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","छलसि चइ च क्ल्ह्‍योए मिं बेथेल थेंइ। ओंसों च क्ल्ह्‍योए मिं लूज मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","च लिउँइँ याकूबइ परमेश्‍वरने छले भकल लइ, “ओ परमेश्‍वर ङने बालु क्हि तइ बिस्याँ, प्रबै घ्याँर ङ जोगेमिंइ बिस्याँ, धै ङ चबै क्हें नेरो खिबै क्वें पिंइ बिस्याँ, ");
INSERT INTO gvr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ङ छेनाले आबाए धिंर एखल् योंइ बिस्याँ, ङए परमेश्‍वर क्हि तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","झाइले ङइ त्हो धोंले क्योथेंबै चु युँमा परमेश्‍वरए धिं तब्मुँ। धै क्हिजी ङलाइ पिंबै तोन्दोंरि सैमैंउँइँले च्युबाँर्बै तिबाँ ङइ खैलेबिलेन् क्हिए मिंर पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","च लिउँइँ याकूब रेसि ह्रोंसए घ्याँ क्हाइ, धै स्यारइ टिबै म्हिमैंए ह्‍युलर फेनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","छले ह्‍यारिमा चइ म्रोंए म्हाँजोर क्यु खादु म्रोंइ। चए कारग्युले क्युए बगाल सों मुँल। च क्यु खादुउँइँले म्हिमैंइ क्यु बगालमैं क्यु थुँल् पिंमल। क्यु खादुए सुँ हुथेंबै थेबै युँमा घ्रि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ताँन् बगालमैं चर बालु तबै त्हेर प्ह्रोंछैंमैंइ क्यु खादुए सुँर्बै युँमा स्योवासि क्युमैं क्यु थुँल् पिंमल। क्यु थुल् पिंल् खाँबै लिउँइँ धबै चमैंइ क्यु खादुए सुँ च युँमाइन हुथेंमल। ");
INSERT INTO gvr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","याकूबइ चमैंने “ओ अलिमैं, क्हेमैं खनिर्बै जा?” बिसि ङ्योएमा चमैंइ बिइ, “ङि हरानथेंमैं ग।” ");
INSERT INTO gvr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","चइ बिइ, “क्हेमैंइ नाहोरए क्वें लाबान बिब ङो सेम्मा।” चमैंइ बिइ, “अँ, ङिइ ङो सेम्।” ");
INSERT INTO gvr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","याकूबइ चमैंने “च सबन् मुँ वा?” बिसि ङ्योएमा चमैंइ बिइ, “च सबन् मुँ। ङ्ह्‍योत्ति, चए च्हमि राहेल क्युमैं पखसि खसिन् मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","याकूबइ चमैंने बिइ, “ङेस आतइमुँ। र-क्युमैं खुबै त्हे आतइमुँ। छतसि र-क्युमैं क्यु थुँल् पिंसि धबै छबर बोद्।” ");
INSERT INTO gvr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","चमैंइ बिइ, “ताँन् बगालमैं खागु आतन् समा धै क्यु खादुए सुँउँइँले युँमा आस्योन् समा ङिंइ र-क्युमैं क्यु थुँल् पिंल् आखाँ। युँमा स्योबै लिउँइँ ङिइ र-क्युमैं क्यु थुँल् पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","याकूब चमैंने छले ताँ सेरिमा राहेल ह्रोंसए आबाए क्युमैं पखसि चर फेखइ, तलेबिस्याँ चइ क्यु छब्ब्रें लमल। ");
INSERT INTO gvr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","याकूबइ ह्रोंसए मामा लाबानए च्हमि राहेल नेरो मामाए क्युमैं म्रोंसि क्यु खादुए सुँर्बै युँमा स्योमिंइ, धै चइ मामाए क्युमैं क्यु थुँल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","च लिउँइँ याकूबइ राहेल म्वें लसि क्रोबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","याकूबइ चने बिइ, “ङ क्हिए ङोंलो ग, क्हिए आबाए अङाँ रिबेकाए च्ह ग।” छबिमा राहेल धिंर न्हेह्‍यासि ह्रोंसए आबाने चु ताँ बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ह्रोंसए भान्जा याकूब खबै ताँ था सेसि लाबान चने त्होबर न्हेखइ। धै चने अँखलो ख्वेसि म्वें लसि ह्रोंसए धिंर पखइ। च लिउँइँ याकूबइ लाबानने ताँन् ताँ बिबै लिउँइँ ");
INSERT INTO gvr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","लाबानइ चने बिइ, “क्ह्रोंसेंन क्हि ङए ह्रुइब नेरो से ग।” याकूब चने बालु म्हैंन घ्रि टिबै लिउँइँ। ");
INSERT INTO gvr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","लाबानइ याकूबने बिइ, “ङ्यो ह्रोंसए नातो न्होंर्बै तबर्न क्हिइ छलेन् ङए के लब् आ? क्हिए नों सै कति तल् त्हुमुँ ङने बिद्।” ");
INSERT INTO gvr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","लाबानल च्हमि ङ्हिं मुँल। थेब्स्योए मिं लेआ धै च्योंब्स्योए मिं राहेल मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","लेआए मि दे क्ह्रिस्यु मुँल। दिलेया राहेल बिस्याँ ज्यु क्ह्रिब नेरो छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","याकूबइ राहेल खोइ। छतसि चइ मामाने बिइ, “क्हिए च्हमि च्योंब्स्यो राहेल ब्ह्‍या लबै ल्हागिर ङ ङिदिं समा क्हिए के लब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","लाबानइ बिइ, “चलाइ अरूमैंने बालु ब्ह्‍या लमिंब् भन्दा क्हिने पिंब छ्याँब तम् छतसि ङने बालुन् टिद्।” ");
INSERT INTO gvr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","झाइले याकूबइ राहेल योंबै ल्हागिर ङिदिं समा के लइ। चइ राहेल बेल्‍ले खोमल छतसि ङिदिं या चइ च्युगुदे धोंन् ङ्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","च लिउँइँ याकूबइ लाबानने बिइ, “ङइ क्हिए के लल् खाँइ। तारे ङए प्ह्रेंस्यो तबर राहेल ङलाइ पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","छबिमा लाबानइ च क्ल्ह्‍योर्बै ताँन् म्हिमैं हुइसि भत्येर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","दिलेया म्हुँइँसर चए च्हमि थेब्स्यो लेआ याकूब ङाँर पखमिंइ, धै याकूब चने बालु तइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(लाबानइ ह्रोंसए केब्स्यो जिल्पा बिब ह्रोंसए च्हमि लेआए केब्स्यो तबर पिंइ।) ");
INSERT INTO gvr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","याकूबइ न्हाँगर ङ्ह्‍योमा लेआ ग मुँन। छतमा चइ लाबानने बिइ, “क्हिइ ङने तले छ लल? ङइ राहेल ब्ह्‍या लबर क्हिए के लब आङिं वा? क्हिइ तले ङने छले स्योर तेल?” ");
INSERT INTO gvr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","लाबानइ बिइ, “ङिए ह्‍युलर थेब्स्योए ब्ह्‍या आलमन् च्योंब्स्योए ब्ह्‍या लल् आत। ");
INSERT INTO gvr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","छतसि लेआने बालु ब्ह्‍या लसि ङिरो टिद्। धै क्हिइ धबै ङिदिं ङए के लइ बिस्याँ ङइ च्योंब्स्यो च्हमि या क्हिलाइ पिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","याकूबइ छान् लइ। लेआने सद् घ्रि टिबै लिउँइँ लाबानइ ह्रोंसए च्हमि च्योंब्स्यो राहेलै या याकूबए प्ह्रेंस्यो तबर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(लाबानइ ह्रोंसए केब्स्यो बिल्हा बिब ह्रोंसए च्हमि राहेलए केब्स्यो तबर पिंइ।) ");
INSERT INTO gvr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","याकूब राहेलने बालु तइ। लेआ नेरो राहेलए न्होंरि चइ राहेलने ल्हें म्हाँया लमल। छले याकूबइ धबै ङिदिं लाबानए के लइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","याकूबइ लेआ आखोब् म्रोंसि याहवेहजी चए कोख थोंमिंइ। दिलेया राहेल थरि तइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","लेआइ प्हसे नोसि च्ह घ्रि फिइ। “क्ह्रोंसेंन याहवेहजी ङए दुःख म्रोंइमुँ। तारे ङए प्युँज्यै ङने म्हाँया लब्मुँ।” छ बिसि चइ च च्हए मिं रूबेन थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","चइ धबै प्हसे नोसि म्हैल च्ह फिइ। “‘ङलाइ आखोइमुँ’ बिब याहवेहजी सेसि खीजी ङलाइ चु च्है या पिंइमुँ।” बिसि चइ बिइ। छतसि चइ म्हैल च्हए मिं शिमियोन थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","च धबै प्हसे नोसि सैंला च्ह फिसि बिइ, “तारे ङए प्युँइ ङलाइ म्हाँया लब्मुँ। तलेबिस्याँ ङइ चल च्ह सों फिल् खाँइ।” छतसि चए मिं लेबी थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","च धबै प्हसे नोसि च्ह च्योंब फिइ। “चु लार ङ याहवेहए मिं क्वेब्मुँ बिइ।” छतसि चए मिं यहूदा थेंइ। च लिउँइँ चइ प्हसे आफि। ");
INSERT INTO gvr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","राहेल ङाँइँले याकूबए प्हसेमैं आत। छतसि राहेलइ ह्रोंसए आनने ह्रिस लबर होंइ। चइ याकूबने “ङलाज्यै प्हसेमैं पिंन्! आपिंस्याँ ङ सियाब्मुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","छबिमा याकूबइ राहेलने ह्रिस खसि बिइ, “ङ परमेश्‍वर वा? क्हिए कोख म्रुवाबम् परमेश्‍वरजी ग।” ");
INSERT INTO gvr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","राहेलइ बिइ, “ङए केब्स्यो बिल्हा चुर्न मुँ। चुने बालु तदु धै ङए ल्हागिर चइ प्हसे योंमिंरिगे। छले च ङाँइले ङै या आमा तल् खाँम्।” ");
INSERT INTO gvr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","छबिसि राहेलइ चए केब्स्यो बिल्हा याकूबए प्ह्रेंस्यो तबर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","झाइले बिल्हा प्हसे नोसि याकूब ङाँइँले च्ह घ्रि फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","छतमा राहेलइ बिइ, “परमेश्‍वरजी ङ ठिक म्रोंइ, धै ङए ताँ थेमिंसि ङलाइ च्ह घ्रि पिंइ।” छतसि चइ चए मिं दान थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","राहेलए केब्स्यो बिल्हाइ धबै प्हसे नोसि चइ याकूबल म्हैला च्ह फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","छतमा राहेलइ बिइ, “ङइ बेल्‍ले नेसि ङए आनलाइ ट्होइ।” छतसि चइ च च्हए मिं नप्‍ताली थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ह्रोंसइ प्हसे आफिब् सेसि लेआइ ह्रोंसए केब्स्यो जिल्पा बोसि याकूबए प्ह्रेंस्यो तबर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","झाइले लेआए केब्स्यो जिल्पाइ याकूबल च्ह घ्रि फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","छतमा लेआइ “ङ्‍हो सब् तइमुँ!” बिइ। छतसि चइ चए मिं गाद थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","जिल्पाइ याकूब ङाँइले धबै च्ह घ्रि फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","छतमा “ङ ङ्‍हो सब्स्यो मुँन! तारे ताँन् च्हमिरिमैंइ ङने ङ्‍हो सब्स्यो बिब्मुँ,” बिसि लेआइ बिइ। छतसि चइ चए मिं आशेर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","गहुँ खैंबै त्हे तमा लेआए च्ह थेब रूबेन म्रोंर ह्‍याइ, चर चइ तेमै धों तबै ङ्‍हे युबै ट्हा बिशाखमूल योंसि ह्रोंसए आमा लेआ ङाँर पखइ। धै च तेमैं धों तबै सै राहेलइ म्रोंमा “गार आम्हाँदिल्‍ले क्हिए च्हइ पखबै तेमैं ङलाज्यै च्युगुदे पिंन्दि,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","दिलेया लेआइ चने बिइ, “ङए प्युँ ङ ङाँइले प्हेंवाब च्योंरि ताँ वा? च्हगै आतन तोगो ङए च्हइ पखबै तेमैं या क्हिइ किंल् म्हैल् वा?” राहेलइ बिइ, “छ बिस्याँ क्हिए च्हइ पखबै तेमैं ङलाइ पिंस्याँ चए साटोर ङइ कोंने म्हुँइँसर ङए प्युँ याकूब क्हि ङाँर कुल्मिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ङेसर याकूब म्रोंउँइँले खमा लेआ चने त्होबर ह्‍यासि बिइ, “ङए च्हइ पखबै बिशाखमूल तेमैं राहेललाइ पिंसि चए खिर ङइ क्हिलाइ किंइमुँ। छतसि क्हि कोंने म्हुँइँसर ङ ङाँर खल् त्हुम्।” छबिमा च म्हुँइँसर याकूब चने रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","परमेश्‍वरजी लेआए प्राथना थेइ। धै चइ धबै प्हसे नोसि याकूब ङाँइले च्ह फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","लेआइ बिइ, “ङए केब्स्यो ङए प्युँने बालु तबर ङइ पिंबइले परमेश्‍वरजी ङलाइ इनाम पिंइ।” छतसि चइ च च्हए मिं इस्साखार थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","लेआ धबै प्हसे नोसि याकूब ङाँइले च्ह फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","लेआइ बिइ, “परमेश्‍वरजी ङलाइ बेल्‍ले थेबै सै पिंइमुँ। तारे ङए प्युँउँइँले ङइ म्हाँया योंब्मुँ। तलेबिस्याँ ङइ चल च्ह ट्हु फिल् खाँइ।” छतसि चइ च्ह च्योंबए मिं जबूलून थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","च लिउँइँ चइ च्हमि घ्रि फिसि चए मिं दीना थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","च लिउँइँ परमेश्‍वरजी राहेललाइ मैंसि चए प्राथना थेइ, धै खीजी चए कोख थोंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","झाइले च प्हसे नोसि च्ह घ्रि फिइ। “परमेश्‍वरजी ङए फिर्बै ‘आछ्याँबै च्येमैं-मिंमैं’ स्योमिंइ,” बिसि चइ बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","छतसि चइ कोलोए मिं योसेफ थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","राहेलइ योसेफ फिबै लिउँइँ याकूबइ मामा लाबानने बिइ, “तारे ङ ह्रोंसए ह्‍युल नेरो धिंर ह्‍याल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ङइ क्हिए के लसि योंबै ङए प्ह्रेंस्योमैं नेरो प्हसेमैं बोल् पिंन्। तलेबिस्याँ ङइ लबै छ्याँबै केमैं क्हिइ सेल् खाँइमुँ। छतसि ङ ह्‍याल् पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","दिलेया लाबानइ चने बिइ, “याहवेहजी क्हिउँइँले ङए फिर आशिक पिंइमुँ बिब ङइ सेइमुँ। छतसि ङए फिर दयाम्हाँया मुँस्याँ अझै टिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","क्हिए नों सै कति किंमुँ ङने बिद्, क्हिइ कति बिमुँ, ङइ च्हगन् पिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","याकूबइ लाबानने बिइ, “ङइ क्हिला खैबै केमैं लइमुँ, धै क्हिए खेदोमैं ङने बालु खैले ल्हें ततै ह्‍याइमुँ च क्हिइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ङ खब् भन्दा ओंसों क्हिने बालु सै न्होर च्युगुदे मत्‍त्रे मुँल तोगो ल्हें तइमुँ। ङइ खनिर यो झोंलेया क्हिए फिर याहवेहजी आशिक पिंइमुँ। तारे ह्रोंसए धिं-नाँए ल्हागिर ङइ खोंयों तौदु लब?” ");
INSERT INTO gvr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“ङइ क्हिलाइ तो पिंले दि?” बिसि लाबानइ बिमा याकूबइ बिइ, “क्हिइ ङलाइ तोइ पिंलै आत्हु। ङए ताँ ङिंम् बिस्याँ ङ क्हिए खेदोमैं अझै छरिस्यो। ");
INSERT INTO gvr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","तिंयाँ क्हिए ताँन् बगालउँइँले थोप्ले नेरो पेटारे रमैं, धै म्‍लोंग्या क्यु म्होंदोमैं ताँन् फ्रेसि स्यो-स्यो लल् पिंन्। चमैंन् ङए नों सै तरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","छलमा ङ भर लल् खाँब मुँ उ आरे बिसि क्हिइ लिउँइँ क्ह्रोंसेंन था सेब्मुँ। ङए रमैं न्होंर थोप्ले पेटारे नेरो क्यु म्होदोमैं न्होंर म्‍लोंग्या आङिंब्मैं क्हिइ स्यास्याँ क्हिए उँइँर ङ ह्‍यो ठर्दिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","लाबानइ “तम् तम्, क्हिइ बिब् धोंलेन् लद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","दिलेया च त्हिंइर लाबानइ पेटारे, थोप्ले र बुग्या-म्होदोमैं नेरो तार्ग्या दाग मुँबै र म्होदोमैं नेरो ताँन् म्‍लोंग्या क्यु म्होदोमैं स्यो लसि ह्रोंसए च्हमैं पिंवाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","च लिउँइँ लाबानइ च खेदोमैं किंसि याकूबउँइँले सोंरोबै घ्याँ ह्‍याइ। धै याकूबइ चर लाबानए चैबै बगालमैं छबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","झाइले याकूबइ ङडा, खोंलों नेरो प्हुगिए हाँगमैं पखसि तार्ग्या-तार्ग्या धर्का बनेबर चए फि छाइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","झाइले बगालमैंइ क्यु थुँबै डोंडए ओंसों चइ च हाँगमैं थेंमिंइ। क्यु थुँबर खमा चमैं चर कोंयामल। ");
INSERT INTO gvr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","च बगालमैं च हाँगमैं ओंसों कोंयाबइले चमैंज्यै या प्हसेमैं छाबन् छिर्केमिर्के, पेटारे नेरो थोप्ले फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","धै याकूबइ च प्हसेमैं स्यो लसि चैबै बगालमैं लाबानए छिर्के-मिर्के नेरो म्‍लोंग्य क्युमैं ङाँइ कुलइ। छले याकूबइ ह्रोंसए बगालमैं लाबानए बगालने आकोंल्‍ले स्योले थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","भों-भोंबै र-क्युमैं कोंबै त्हेर च हाँगमैंए उँइँर कोंयारिगे बिसि बगालइ क्यु थुँबै डोंडए ओंसों याकूबइ च हाँगमैं थेंमिंमल। ");
INSERT INTO gvr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","दिलेया भों आरेबै बगालमैंए ल्हागिर चइ च हाँगमैं आथेंमल। छतसि भों आरेब्मैं लाबानल तइ, भों मुँब्मैं याकूबल तइ। ");
INSERT INTO gvr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","छले याकूब बेल्‍ले प्लब तइ। चल र-क्युमैं, सलु, गधामैं या ल्हें तइ केब्छैं-केब्स्योमैं या ल्हें तइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","“ङ्योए आबाए तोन्दोंरि सै याकूबइ बोल् खाँइ, धै ङ्योए आबाए ताँन् सैमैंउँइँलेन् चइ च्हौ ल्हें सैमैं योंइमुँ,” बिसि लाबनए च्हमैंइ बिरिब याकूबइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","झाइले चए फिर लाबनइ ओंसोंबै धोंले छेन् आलब याकूबइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","च लिउँइँ याहवेहजी याकूबने बिइ, “क्हिए खेमैं नेरो क्हिए ङ्‍हेब्-ट्हुब् ङाँर एह्‍याद्। ङ क्हिने तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","छतसि राहेल नेरो लेआ ह्रोंसए र-क्युए बगाल मुँबै खर्कर याकूबइ त्होबर हुइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","त्होसि चमैंने बिइ, “क्हेमैंए आबाए सैं ङने ओंसोंबै धों तब ङइ आम्रोंइमुँ। दिलेया ङए आबाए परमेश्‍वर ङने बालु मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","ङए भोंइ खाँन् समा ङइ क्हेमैंए आबाए सेवा लब क्हेमैंइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","दिलेया क्हेमैंए आबाइ ङ लुइमुँ, ङए नों सै च्युखे फेर्दिइमुँ। दिलेया परमेश्‍वरजी चइ ङए न्होह्रों लल् आपिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","लाबनइ ‘थोप्लेमैं ताँन् क्हिए केए नों सै तरिगे’ बिमा ताँन् बगालमैंइ थोप्लेमैंन् फिइ। धै ‘पेटारेमैं ताँन् क्हिए केए नों सै तरिगे’ बिमा ताँन् बगालमैंइ पेटारेमैंन् फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","छले परमेश्‍वरजी क्हेमैंए आबाए र-क्युए बगालमैं चउँइँले किंसि ङलाइ पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“बगाल कोंबै त्हेर म्होदोए फिर क्रेबै बुग्यमैं पेटारे, थोप्ले नेरो छिर्केमिर्के तब ङइ म्होंडर म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","च त्हेर परमेश्‍वरए स्वर्गदूतइ म्होंडर ङने ‘ओ याकूब!’ बिमा ङइ ‘होइ, ङ चुर्न मुँ,’ बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“धै खीजी बिइ, ‘ङ्ह्‍योत्ति! बगलाए फिर क्रेबै ताँन् बुग्यामैं पेटारे, थोप्ले नेरो छिर्केमिर्के मुँ। तलेबिस्याँ लाबानइ क्हिए फिर लबै के म्रोंसि ङइ छ लब् ग। ");
INSERT INTO gvr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","क्हिइ युँमा क्योसि छ्युगु युसि भकल लबै क्ल्ह्‍यो बेथलर्बै परमेश्‍वर ङन् ग। तारे रेद्, चु क्ल्ह्‍योउँइँले क्हि फिबै क्ल्ह्‍योर एह्‍याद्।’” ");
INSERT INTO gvr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","च लिउँइँ राहेल नेरो लेआइ चने बिइ, “ङिए आबाए धिंर ङिए हगर्बै ङिइ योंल् त्हुबै सै तोइ मुँ रो वा? चइ ङिलाइ आगुए ह्‍युलर्बै म्हिमैं धोंन् मैंइमुँ आङिं वा? ");
INSERT INTO gvr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","चइ ङि चुँवाँइमुँ ङिलाइ पिंबै मुइ या चइन नुवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ङिए आबा ङाँइले परमेश्‍वरजी बोयाबै ताँन् सै न्होर ङि नेरो ङिए प्हसेमैंल् तइमुँ। छतसि तारे परमेश्‍वरजी क्हिने तो-तो लद् बिइमुँ छान् लद्।” ");
INSERT INTO gvr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","च लिउँइँ याकूब रेसि ह्रोंसए च्हमैं नेरो प्ह्रेंस्योमैं सलुमैंए फिर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","झाइले पद्दन-आरामर टिमा ह्रोंसइ योंबै ताँन् सै न्होर नेरो ह्रोंसए खेदोमैं ताँन् किंसि ह्रोंसए आबा इसहाक ङाँर कनान ह्‍युलउँइँ ह्‍याबर त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","च त्हेर लाबान ह्रोंसए क्युए पै प्ह्रेबर ह्‍याल। आबा धिंर आरेबै मौका च्ह्‍यासि राहेलइ ह्रोंसए आबाए धिंर्बै देवतामैं ह्‍योसि बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","च फिरै या मामा लाबानने याकूबइ स्योर तेइ, तलेबिस्याँ भौदिल् म्हैबै ताँ लाबानलाइ आबिल। ");
INSERT INTO gvr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","छले ह्रोंसने मुँबै तोन्दोंरि सै किंसि याकूब भौदिसि यूफ्रेटिस बिबै थेबै स्यों तर्दिसि गिलाद बिबै कोंउँइँ ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","सोंरोर याकूब भौदिह्‍यान बिबै ताँ लाबानइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","छतसि ह्रोंसए आघें-अलिमैं किंसि ङिरो समा याकूबलाइ ल्हाबोमा गिलाद बिबै कोंर चलाइ स्याइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","दिलेया च म्हुँइँसर आरामि लाबान ङाँर परमेश्‍वर म्होंडर म्रोंयुसि चने बिइ, “न्ह क्रों मि क्रों तद्। क्हिइ याकूबने छ्याँब आछ्याँब तोइ आबिद्।” ");
INSERT INTO gvr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","लाबानइ याकूबलाइ स्यामा याकूबइ ह्रोंसए तम्बु गिलादए कोंर टौंदिल। छलेन लाबानज्यै ह्रोंसए आघें-अलिमैंने बालु तम्बु च क्ल्ह्‍योर्न टौंदिइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","झाइले लाबानइ याकूबने बिइ, “क्हिइ ङ छल्दिसि ङए च्हमिमैं ल्हडेंउँइँले क्हा पखब्मैं धोंले पखब तले जा छ लब? ");
INSERT INTO gvr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","ङने तोइ आबिल्‍ले था आयोंन्ले भौदिसि क्हिइ तले ङ धोका पिंल? ङइ बीणा नेरो छिनछिन ह्रासि सैं तोंल्‍ले क्हि कुलमल। ");
INSERT INTO gvr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","ङए क्वें-क्वेंमिमैं नेरो च्हमिमैं कुलबै त्हेर तले म्वें लल् आपिंल? क्हिइ चु आछ्याँब के लइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","क्हिए न्होह्रों लबै भों ङने मुँ। दिलेया क्हिए आबाए परमेश्‍वरजी तल् म्हुँइँसर ङने बिइ, ‘क्हि न्ह क्रों मि क्रों तद्। क्हिइ याकूबने छ्याँब आछ्याँब तोइ आबिद्।’ ");
INSERT INTO gvr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","छतसि तारे क्हिए आबाए धिंर ह्‍याबै सैं लसि क्हि प्रइमुँ ङइ क्होइ। दिलेया ङए धिंर्बै देवतामैं तले ह्‍योल?” ");
INSERT INTO gvr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","याकूबइ लाबानने बिइ, “क्हिए च्हमिमैं ङ ङाँइले क्हिइ प्हेंवाम् उ ङ्हाँसि ङ ङ्हिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","दिलेया क्हिए देवतामैं खाब्ने बालु स्यामुँ च म्हि सिल् त्हुब्मुँ। छतसि ङने बालु क्हिए सै तो-तो मुँ च ङ्योए ङें-ट्हुब्मैंए ओंसों म्हैदु, धै योंस्याँ किंन्।” राहेलइ च देवतामैं ह्‍योब याकूबइ आसेल। ");
INSERT INTO gvr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","छबिमा लाबान याकूबए तम्बु न्होंर नेरो लेआए केब्स्यो ङ्हिंए तम्बु न्होंर होंइ। दिलेया च देवतामैं स्याल् आखाँ। धै लेआए तम्बुउँइँले त्होंसि राहेलए तम्बु न्होंर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","राहेल बिस्याँ आबाए धिं-देवतामैं किंसि ह्रोंसए सलुए काँठि न्होंर्बै बोरर झोंसि चए फिर टिरिल। लाबानइ तम्बुर खन्तोंदोंन् म्हैइ दिलेया च योंल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","राहेलइ ह्रोंसए आबाने बिइ, “आबा, क्हि ङने ह्रिस आखद् ओ। ङ क्होर्बै तइमुँ छतसि क्हिए ओंसों रेल् आखाँ।” छले चइ म्हैबम् म्हैइ दिलेया धिंर्बै देवतामैं ‍योंल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","छतमा याकूब ह्रिस खसि लाबानलाइ हौदिसि बिइ, “ङइ क्हिला तो न्होह्रों लवाइ छले ङलाइ ल्हा प्रब? ");
INSERT INTO gvr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ङए ताँन् सैमैं क्हिइ ङ्‍ह्‍योल् खाँइ। क्हिए धिंर्बै सैमैं तो योंइ खोइ? क्हि नेरो ङए ङे-ट्हुब्मैंए ओंसों चु ताँ थेंन्। चमैंइन ङ्योए न्होंर निसाफ लमिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“ङ्हिस्यु बर्ष ङ क्हिने बालुन् टिइ। च्हौ त्हे समा क्हिए र-क्युमैंए प्हसे खोंयोंइ आप्युल। क्हिए बगालर्बै क्युमैं ङइ आचल। ");
INSERT INTO gvr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","क्ह्‍योंर्बै चें भलुमैंइ र-क्यु सैवालै या चए सै ङइन नोसि चए साटोर अरू खेदोमैं ङइ पिंमल। त्हिंयाँर मुँले म्हुँइँसर मुँले म्हिमैंइ क्हिए खेदोमैं ह्‍योवास्याँ चए साटो या क्हिइ ङ ङाँइलेन् किंमल। ");
INSERT INTO gvr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","त्हिंइर्बै ख्वालबइ नेरो म्हुँइँसर्बै ङ्युँबइ ङलाइ बेल्‍ले दुःख तमल ङइ कति दुःख योंइ। ङ तिफुँइ न्हरु च्हुइल् आयोंमल। ");
INSERT INTO gvr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","क्हिए च्हमि ङ्हिंए ल्हागिर ङइ च्युसे प्लिदिं क्हिए के लइ। धै ट्हुदिं समा क्हिए बगालमैं छैं लइ। चु ङ्हिस्यु बर्ष समा छ लसिन् ङ क्हिए धिंर टिइ। दिलेया क्हिइ ङए नों सै आबडिमिं झन च्युखे फेर्दिइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ङए आबाए परमेश्‍वर, ङए बाज्यु अब्राहाम नेरो इसहाकए परमेश्‍वर ङने बालु आरेस्याँ क्ह्रोंसेंन क्हिइ ङए यो क्होत्तेन् कुल्मिंमल। दिलेया ङइ योंबै दुःख नेरो ङइ लबै के खीजी म्रोंइ। छतसि खीजी तल् म्हुँइँसर क्हिलाइ हौदिब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","लाबानइ याकूबने बिइ, “चु च्हमिमैं ङए च्हमिमैंन् ग। चु कोलोमैं या ङए क्वेंमैं ग। चु बगालमैं या ङए बगालमैंन् ग। चुर क्हिइ म्रोंबै तोन्दोंरि सै ङलन् ग। दिलेया चु ङए च्हमिमैं नेरो चमैंइ फिबै च्ह-च्हमिमैंए फिर ङइ तो लल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","छतसि तारे खो, क्हि नेरो ङए न्होंर बाछा घ्रि फैले। छले ङ्योइ फैबै बाछा क्हि नेरो ङए म्हाँजोर साक्षि तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","झाइले याकूबइ युँमा घ्रि पखसि त्हो धोंले क्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","धै याकूबइ ह्रोंसए ङे-टहुमैंने “क्हेमैंज्यै युँमामैं पखो बिमा” चमैंइ युँमामैं पखसि थुप्रो लइ। धै च युँमाए थुप्रो ङाँर चमैंइ चब् थुँब् लइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","लाबानइ च युँमाए थुप्रोए मिं “यगर-सहदूता” थेंइ। दिलेया याकूबइ चने “गलेद” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","लाबानइ याकूबने बिइ, “क्हि नेरो ङए म्हाँजोर बाछाए साक्षि तसि ङ्योए सैंर चु बाछा मैंल् लबर तिंयाँ चु युँमाए थुप्रो क्योइमुँ।” छतसि चए मिं गलेद थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","धबै लाबानइ चु ताँ या बिइ, “ङ्यो स्यो-स्यो तयालेया क्हि नेरो ङलाइ याहवेहजी ङ्ह्‍योरिगे।” छतसि च थुप्रोए मिं मिस्पा या मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","लाबानइ याकूबने धबै बिइ, “खनिज्यै ङए च्हमिमैंए फिर क्हिइ आछ्याँब लइबिस्याँ धै चमैंए फिर अरू प्ह्रेंस्योमैं पखइबिस्याँ, ङने था आसेलेया, परमेश्‍वरजी क्हि नेरो ङलाइ ङ्ह्‍योरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","क्हि नेरो ङए म्हाँजोर ङइ क्योथेंबै चु युँमाए थुप्रो नेरो त्हो ङ्‍ह्‍योद्। ");
INSERT INTO gvr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","चु थुप्रो नेरो त्हो साक्षि तरिगे। तारे चु थुप्रो ङ्वैसि क्हि ङाँर ङ न्होह्रों लबर क्योंजा खरिब् आरे। छलेन चु थुप्रो नेरो त्हो ङ्वैसि क्हि या ङ ङाँर तोइ न्होह्रों लबर चोंजा आखो। ");
INSERT INTO gvr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","क्हिए बाज्यु अब्राहाम नेरो ङए बाज्यु नाहोर नेरो चमैंए आबा तेराहए परमेश्‍वरजी ङ्योए म्हाँजोर निसाफ लरिगे।” छतसि याकूबइ ह्रोंसए आबा इसहाकए परमेश्‍वर साक्षि थेंसि कसम चइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","झाइले याकूबइ कोंर क्यु सैसि ख्रो पिंइ, धै ह्रोंसए ङें-ट्हुब्मैं हुइसि चब्-थुँब् पिंइ। चमैंइ चब्-थुँब लसि च क्ल्ह्‍योर्न म्हुँइँस थोइ। ");
INSERT INTO gvr_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","लाबान न्हाँगर्न रेसि ह्रोंसए क्वें-क्वेंमिमैं नेरो च्हमिमैं म्वें लसि आशिक पिंसि धिंर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","याकूब या ह्रोंसए घ्याँ क्हासि ह्‍यामा परमेश्‍वरए दूतमैं चने बालु त्होइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","याकूबइ चमैं म्रोंसि “चु परमेश्‍वरए स्वर्गदूतमैं टिबै क्ल्ह्‍यो ग मुँन बिसि।” चइ च क्ल्ह्‍योए मिं महनोम थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","याकूबइ एदोम ह्‍युलर्बै सेइरर ह्रोंसए आघें एसाव ङाँर त्होबर ह्रोंस भन्दा ओंसों स्यार्बोमैं कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","“‘ङ तोगो समा लाबानने बालु टिइमुँ। छतसि तोगो समा आखब् ग, बिसि क्हिए केब्छैं याकूबइ बिइमुँ’ बिसि ङए क्ल्हे एसावने बिमिंन्,” बिसि याकूबइ चमैंने बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","“‘ङने बालु म्ये-क्ल्या, गधा, र-क्यु नेरो केब्छैं-केब्स्योमैं या ल्हें मुँ। छतसि क्हिउँइँले ल्हयो योंब्मुँ बिसि तोगो क्हि ङाँर यो छ्युँ लबर ङइ चु म्हिमैं कुलइमुँ,’ बिसि ङए क्ल्हे एसावने बिमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","च स्यार्बोमैं याकूब ङाँर एखसि बिइ, “ङि क्हिए आघें एसाव ङाँर ह्‍यासि खइ। च क्हिने त्होबर म्हि प्लिब्ब्रा किंसि खसिन् मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","छ बिब् थेसि याकूब बेल्‍ले ङ्हिंसि त्हारइ। धै ह्रोंसने मुँबै म्हिमैं, र-क्युमैं, म्ये-क्ल्यामैं नेरो सलुमैंए बगाल भाग ङ्हिंर चुइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","तलेबिस्याँ एसाव खसि बगाल घ्रि सैवालेया अर्को बगाल सोब्मुँ बिसि चइ मैंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","धै याकूबइ छले प्राथना लइ, “ओ ङए बाज्यु अब्राहाम, ङए आबा इसहाकए परमेश्‍वर, ओ याहवेह, क्हिजी ङने ‘क्हि क्हिए ह्‍युलर क्हिए ङे-ट्हुमैं ङाँर ह्‍याद्। ङइ क्हिए तोन्दोंरि सै छ्याँब लमिंस्यो’ बिल। ");
INSERT INTO gvr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","क्हिजी ह्रोंसए केब्छैंए फिर कति ल्हें म्हाँया लसि उँइँमिंइमुँ दिलेया च म्हाँया योंबै लायकर्बै ङ आरे। तलेबिस्याँ ङ प्हरे घ्रि मत्‍त्रे छेसि यर्दन स्यों तर्दिसि ह्‍याल। तोगो ङल बगाल ङ्हिं तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ङ क्हिने यो छ्युँ लमुँ ङए आघें एसावए योउँइँले ङ जोगेमिंन्। तलेबिस्याँ ङ नेरो ङए म्रिं प्हसेमैंने नेखम् उ बिसि ङ ङ्हिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","दिलेया क्हिजी ‘क्ह्रोंसेंन ङइ क्हिए तोन्दोंरि सै छ्याँब लमिंब्मुँ, धै क्हिए प्हसेमैं मा ङ्युँइर्बै बलुवा धोंले च्योलै आखाँल्‍ले ल्हें लमिंब्मुँ,’ बिल।” ");
INSERT INTO gvr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","च म्हुँइँसर याकूब चर्न टिइ। धै ह्रोंसए आघें एसावलाइ पिंबै ल्हागिर ह्रोंसने मुँबै खेदोमैं फ्रेसि थेंइ: ");
INSERT INTO gvr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","ङ्हिब्ब्रा र-म्होदो, र-बुग्या ङ्हिस्यु, क्यु आमा ङ्हिब्ब्रा, क्यु साँडे ङ्हिस्यु, ");
INSERT INTO gvr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ङ्‍हे ङ्‍हेबै सलु सोंच्यु नेरो चमैंए प्हसेमैं, म्ये प्लिच्यु क्ल्या भारा च्यु, गधा आमा ङ्हिस्यु धै गधा त्होब च्यु। ");
INSERT INTO gvr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","छले ताँन् बगालमैं फ्रेसि ह्रोंसए केब्छैंमैंने जिम्‍मा पिंसि बिइ, “क्हेमैं ङ भन्दा ओंसों ह्‍याद् धै बगालमैंए म्हाँजोर च्युगुदे खालि क्ल्ह्‍यो थेंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","चइ ताँन् भन्दा ओंसों ह्‍याबै म्हिने बिइ, “ङए आघें एसावइ क्हिने त्होसि ‘क्हि खाबै म्हि जा? क्हि खनिर ह्‍याब् जा? क्हिए ओंसों-ओंसों ह्‍याबै चु खेदोमैं खाबल् जा?’ बिसि ङ्योएस्याँ, ");
INSERT INTO gvr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‘चु क्हिए केब्छैं याकूबल ग। चु ताँन् चए क्ल्हे एसावए ल्हागिरि क्होल्सै बिसि कुल्मिंब् ग। च ङिए लिलि खसिन् मुँ,’ बिसि बिद्।” ");
INSERT INTO gvr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","छलेन याकूबइ बगालए लिलि प्रब्मैं ताँनने बिइ, “एसावने त्होमा क्हेमैंइ छ बिद्, ");
INSERT INTO gvr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘क्हिए केब्छैं याकूब ङिए लिलि खसिन्मुँ।’” तलेबिस्याँ “ङए ओंसों-ओंसों कुलबै क्होल्सैमैं म्रोंसि चए ह्रिस म्हह्‍यालै धै चए उँइँर ङ ह्‍यामा चइ ङ खल् पिंब्मुँ,” बिब याकूबए सैंर मैंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","छतसि च क्होल्सैमैं ओंसों कुल्मिंइ, च बिस्याँ च म्हुँइँसर ह्रोंसए तम्बुर्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","च म्हुँइँसर याकूब रेसि ह्रोंसए प्ह्रेंस्योमैं ङ्हिं, केब्स्यो ङ्हिं नेरो च्हमैं च्युसे घ्रि किंसि यब्बोक बिबै स्यों तर्दिइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","च्हमैं स्यों क्योंजा कुल्मिंबै लिउँइँ ह्रोंसने बालु मुँबै तोन्दोंरि सैमैं या कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","छले याकूब घ्रिन् मुँमा म्हुँइँसर म्हि घ्रि नाँ आन्होंन् समा चने नेइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","च स्वर्गदूतइ याकूब ट्होल् आखाँब् सेसि याकूबए क्रेर्बै खोक्रोर छुइ, धै खीने नेन-नेन् याकूबए क्रेर्बै जोर्ने प्ल्ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","झाइले च स्वर्गदूतइ बिइ, “मि म्रोंबि छेइ, ङ ह्‍याल् पिंन्।” दिलेया याकूबइ बिइ, “ङए फिर आशिक आपिंन् समा ङइ क्हि ह्‍याल् आपिं।” ");
INSERT INTO gvr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","च स्वर्गदूतइ याकूबने “क्हिए मिं तो जा?” बिसि ङ्योएमा चइ “ङए मिं याकूब ग,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","च स्वर्गदूतइ बिइ, “क्हिइ परमेश्‍वर नेरो म्हिमैंने नेसि ट्होल् खाँइ। छतसि तारे क्हिए मिं याकूब आङिं, इस्रायल तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","झाइले याकूबज्यै यो छ्युँ लसि चने “क्हिए मिं तो जा? ङने बिद्,” बिसि ङ्योएइ। “ङए मिं क्हिइ तो लबर ङ्योएल?” बिदै खीजी याकूबलाइ आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","“परमेश्‍वर ङए ओंसोंन् म्रोंसेया ङ सोइ,” बिसि याकूबइ च क्ल्ह्‍योए मिं पनीएल थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","चए क्रे नबै लमा च खोचें-खोचेंले प्रसि पनीएल ङ्वेल् खाँमा त्हिंयाँ प्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","याकूबए क्रेर्बै च स्वर्गदूतइ छुइबइले तिंजरो या इस्राएलीमैंइ क्रेर्बै च आच। ");
INSERT INTO gvr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","याकूबइ ङ्ह्‍योमा एसाव नेरो चने बालु प्लिब्ब्रा म्हिमैं खरिब् म्रोंइ। छतमा चइ ह्रोंसए च्ह-च्हमिमैंलाइ लेआ, राहेल नेरो केब्स्योमैं ङ्हिंए जिम्मार पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","चइ केब्स्योमैं नेरो चमैंए च्हमैं ताँन् भन्दा ओंसों थेंमिंइ, च लिउँइँ लेआ नेरो चए च्ह च्हमिमैं, धै राहेल नेरो चए च्ह योसेफ बिस्याँ ताँन् भन्दा लिउँइँ थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","याकूब ह्रोंसए आघें ङाँर आफेन् समा ङिखे समा सर फ्योदै ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","दिलेया एसाव न्हेखसि याकूबलाइ अँखलो ख्वेसि म्वें लइ। धै चमैं ङ्हिं बेल्‍ले क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","एसावइ च्हमिरिमैं नेरो कोलोमैं म्रोंसि “क्हिने बालु मुँब्मैं खाब्मैं जा?” बिमा याकूबइ “परमेश्‍वरजी क्हिए केब्छैंए फिर दयाम्हाँया लसि पिंबै ङए च्ह-च्हमिमैं ग,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","च लिउँइँ केब्स्योमैं नेरो चए प्हसेमैं खसि एसावलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","लेआ नेरो चए प्हसेमैं या खसि फ्योइ। ताँनइ फ्योल् खाँबै लिउँइँ योसेफ नेरो राहेल खसि फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“ङइ त्होबै चु बगालए अर्थ तो जा?” बिसि एसावइ याकूबने ङ्योएमा याकूबइ बिइ, “ङए फिर क्हिइ ल्हयो खरिगे बिसि ङइ चु बगालमैं कुल्मिंब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","दिलेया एसावइ बिइ, “आच्यों, ङने बालु ल्हें मुँ। छतसि क्हिने बालु मुँबै सैमैं क्हिनेन् मुँरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","याकूबइ बिइ, “आङिं, क्हिए म्हाँया ङए फिर मुँस्याँ गार आम्हाँदिल्‍ले ङए योर्बै क्होल्सैमैं किंमिंन्। तलेबिस्याँ ङए फिर च्हौ थेबै म्हाँया उँइँसि क्हिइ ङलाइ मान लइ। क्ह्रोंसेंन क्हिने त्होल् योंमा परमेश्‍वर म्रोंब् धोंन् ङ्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","क्हिए ल्हागिर्न पखबै चु क्होल्सैमैं गार आम्हाँदिल्‍ले किंन्, तलेबिस्याँ ङए फिर परमेश्‍वरए आशिक मुँबइले ङने ल्हेंन् मुँ।” छले याकूबइ किंलन् त्हुम् बिसि कर लमा एसावइ च क्होल्सैमैं किंइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","झाइले एसावइ बिइ, “तारे ङ्यो ह्‍याले! क्हिए ओंसों ओंसों ङ प्रब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","दिलेया याकूबइ एसावने बिइ, “चु कोलोमैं च्योंबन् मुँ बिब क्हिइ सेइमुँ, धै ङ्‍हे ङ्‍हेल् त्हुबै खेदोमैं या मुँ। चु बगालमैं तिगेंर्न ल्हें प्रमिंइ बिस्याँ ताँन् सियाम् उ बिसि ङ न्हुँ खइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","छतसि ङ क्हिने यो छ्युँ लमुँ, ङ भन्दा ओंसों क्हि ह्‍यादु। ङ बिस्याँ ओंसों ह्‍याबै खेदोमैं नेरो प्हसेमैंए प्रबै त्होंर प्रसि क्हि ङाँर सेइरर आफेखन् समा नुजीले प्रसि खब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","एसावइ बिइ, “छ बिस्याँ ङने बालु मुँबै च्युगुदे म्हिमैं क्हि ङाँर वाथेंम्।” दिलेया याकूबइ बिइ, “च म्हिमैं चैदिलै रो वा? क्हिए दयाम्हाँया ङए फिर मुँसेरो तम्।” ");
INSERT INTO gvr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","छबिमा एसाव च त्हिंइर्न सेइरर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","याकूब बिस्याँ सुक्‍कोतउँइँ ह्‍यासि ह्रोंसए टिबै क्ल्ह्‍‍यो नेरो खेदोमैंए प्ह्रो बनेइ। छतसि च क्ल्ह्‍योए मिं सुक्‍कोत थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","याकूब पद्दन-आरामउँइँले ह्‍याबै लिउँइँ कनान ह्‍युलर्बै शकेम बिबै सहरर छेनाले फेखइ, धै च सहरए ओंसों तम्बु टौंदिसि टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","चइ चाँदिए मुइ प्र झोंसि च क्ल्ह्‍यो शकेमए आबा हमोरए च्हमैंने किंइ। ");
INSERT INTO gvr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","चर चइ ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि चए मिं एल-एलोह-इस्राएल थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","तिगें याकूब ङाँइले लेआइ फिबै च्हमि दीना कनान ह्‍‍युलर्बै च्हमिरिमैंने त्होबर ह्‍यामा। ");
INSERT INTO gvr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","च क्ल्ह्‍योर्बै क्रथे हिव्‍वि हमोरए च्ह शकेमइ चलाइ म्रोंइ। धै चलाइ तिराइ बोसि चने रोसि चए आब्रु वाइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","शकेमइ दीनालाइ खोमल। छतसि चइ दिनाने म्हाँया लसि छ्याँ-छ्याँबै ताँमैं लइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","छतमा शकेमइ ह्रोंसए आबा हमोरने बिइ, “ङए प्ह्रेंस्यो लबर च च्हमिरि ङलाइ पखमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","शकेमइ ह्रोंसए च्हमि दीना न्होंवाबै ताँ याकूबइ थेइ। दिलेया चए च्हमैं खेदोमैं छबर ह्‍याल। छतसि चमैं आखन् समा च तोइ आबिल्‍ले टिरिइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","च त्हेर्न शकेमए आबा हमोर ताँ लबर याकूब ङाँर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","शकेमइ दीनालाइ न्होंवाबै ताँ याकूबए च्हमैंइ थेइ। छतसि चमैं खेदोमैं छबै क्ल्ह्‍योउँइँले खल। चमैं बेल्‍ले ह्रिस खसि सैदिल् आखाँन् तइ, तलेबिस्याँ याकूबए च्हमि न्होंवासि शकेमइ इस्राएलर्बै म्हिमैंए आब्रु वाल। छाबै के लब छ्याँब ताँ आङिंल। ");
INSERT INTO gvr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","दिलेया हमोरइ चमैंने बालु छ बिसि ताँ लइ, “ङए च्ह शकेमइ क्हिए च्हमि दीना बेल्‍ले खोइमुँ। छतसि गार आम्हाँदिल्‍ले क्हिए च्हमिने बालु ङए च्ह ब्ह्‍या लल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","क्हेमैं ङिने बालु ङे-च्याद्। क्हेमैंए च्हमिमैं ङिलाइ पिंन्, ङिए च्हमिमैं क्हेमैंइ किंन्। ");
INSERT INTO gvr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","क्हेमैं ङिने बालुन् टिद्। चु क्ल्ह्‍यो क्हेमैंए ल्हागिर खुला मुँ। चुर्न टिसि छों लदु धै सै न्होर तोद्।” ");
INSERT INTO gvr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","शकेमज्यै या दीनाए आबा नेरो आघें-अलिमैंने बिइ, “ङए फिर क्हेमैंइ ल्हयो खमिंन्। क्हेमैंइ तो ह्रिलेया ङइ पिंस्यो। ");
INSERT INTO gvr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","गर्दुवा ह्रोंमैं क्होल्सै क्हेमैंइ कति ह्रिलेया ङइ पिंस्यो। चु च्हमिरिने ङ ब्ह्‍या लल् पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","शकेमइ चमैंए रिं दीना न्होंवाबइले याकूबए च्हमैंइ शकेम नेरो चए आबा हमोरए फिर आछ्याँबै सैंले स्योर तेसि बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“ज्युर चिनु आलब्मैंने ङिए रिं पिंबै के ङिउँइँले तल् आखाँ। छले पिंस्याँ ङिए आब्रु ह्‍याम्। ");
INSERT INTO gvr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","छतसि ङिइ बिब् धोंले क्हेमैंइ लस्याँ क्हेमैंइ बिबै ताँ या ङि ङिंम्। क्हेमैंज्यै या ङिइ धोंलेन् ताँन् मुँयुँमैंल ज्युर चिनु लद्। छलस्याँ मत्‍त्रै ङिए च्हमिमैं क्हेमैंने पिंस्यो। ");
INSERT INTO gvr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","धै ङिज्यै या क्हेमैंए च्हमिमैं किंस्यो। झाइले ङि क्हेमैंने ह्रें घ्रिन् तसि टिस्यो। ");
INSERT INTO gvr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ङिए ताँ थेसेया क्हेमैंइ ज्युर चिनु लल् आङिंस्याँ ङिए च्हमि बोसि ङि चु क्ल्ह्‍योउँइँले छ्युडिह्‍याब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","हमोर नेरो चए च्ह शकेमइ चमैंइ बिबै ताँ छ्याँब ङ्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","छतसि च फ्रेंसिइ चु के तिफुँइ क्हैल् आल। तलेबिस्याँ याकूबए च्हमि चइ बेल्‍ले खोल। ह्रोंसए परवार चलाइ ताँनइ म्हाँया लमल। ");
INSERT INTO gvr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","झाइले हमोर नेरो चए च्ह शकेम सहरर्बै मुल म्रार खसि सहरथेंमैं ताँनने बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“चु म्हिमैं ङ्योने क्ह्रिल् खाँब्मैं मुँन। छतसि चुमैं टिबै ल्हागिर क्ल्ह्‍यो या ल्हें मुँ। चुमैं चु ह्‍युलर्न टिसि छों लरिगे। ");
INSERT INTO gvr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ङ्यो नेरो चमैंए म्हाँजोर ब्ह्‍या तरिगे। छतसि चमैं ङ्योने बालु ह्रें घ्रिन् तसि टिबै ल्हागिर चमैंइ धोंले ङ्योए ताँन् मुँयुँमैंल ज्युर चिनु लल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","छलस्याँ चमैंए खेदोमैं नेरो तोन्दोंरि सैमैं ङ्योलन् आत रो वा? छतसि चमैंए ताँ ङ्योइ ङिंले। चमैंए ताँ ङ्योइ ङिंस्याँ चमैं ङ्योने बालुन् टिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","छबिमा सहरर्बै मुल म्रार्बै म्हिमैं ताँनइ हमोर नेरो चए च्ह शकेमए ताँ ङिंइ, धै चमैं ताँनइ ज्युर चिनु लइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ज्युर चिनु लबै सोंरोर चमैं बेल्‍ले नसि टिरिमा याकूबए च्ह ङ्हिं दीनाए आघेंमैं शिमियोन नेरो लेबी ह्रों-ह्रोंसए सेलाँमैं किंसि खाबज्यै आसेल्‍ले सहरर होंसि मुँयुँमैं ताँन् सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","हमोर नेरो चए च्ह शकेमै या चमैंइ सेलाँइ ल्हिसि सैवाइ। धै शकेमए धिंउँइँले दीना किंसि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","च लिउँइँ याकूबए च्हमैं म्हि सिबै क्ल्ह्‍योर ह्‍यासि च सहर लुडिइ, तलेबिस्याँ हामोरए च्हइ चमैंए रिं न्होंवाल। ");
INSERT INTO gvr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","चमैंइ च सहरर्बै ताँन् र-क्युमैं, गधामैं नेरो म्रोंर मुँबै तोन्दोंरि सैमैं या बोयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","सहरर्बै मुइ योंबै ताँन् सैमैं, च्हमिरिमैं, कोलोमैं नेरो धिंर्बै ताँन् सैमैं या चमैंइ लुडिइ। ");
INSERT INTO gvr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","झाइले याकूबइ शिमियोन नेरो लेबीने बिइ, “कनानी नेरो परिज्जीथेंमैंए उँइँर क्हेमैंइ ङ खाबज्यै आखोब नेरो आक्वेंब लमिंसि दुःख योंल् लमिंइ। ङए म्हिमैं च्युगुदे मुँ। खनिज्यै चुर्बै म्हिमैं ताँन् त्हुँसि ङने नेखस्याँ ङ नेरो ङए परवामैं ताँन् सैवाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","दिलेया चमैंइ बिइ, “ङिए रिं चइ फ्यालुस्यो धों लल् योंम्मा?” ");
INSERT INTO gvr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","च लिउँइँ परमेश्‍वरजी याकूबने बिइ, “रेसि बेथेलर ह्‍यादु धै चर्न टिद्। क्हिए आघें एसावउँइँले क्हि भौदिरिबै त्हेर क्हि ङाँर म्रोंयुबै परमेश्‍वरए मिंर ख्रो पिंबै ल्हागिर ख्रो पिंबै क्ल्ह्‍यो घ्रि चर बनेद्।” ");
INSERT INTO gvr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","छबिमा याकूबइ ह्रोंसए परवा नेरो ह्रोंसने मुँबै ताँन् म्हिमैंने बिइ, “क्हेमैंने मुँबै आगुए देवतामैं ताँन् भ्योंवान् धै क्हेमैं चोखो तसि क्वें फेर्दिद्। ");
INSERT INTO gvr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","झाइले ङ्यो बेथेलर ह्‍याले। ङए फिर दुःख तबै त्हेर ङए ताँ थेमिंब नेरो ङ खनिर ह्‍यालेया ङने बालु तमिंबै परमेश्‍वरए ल्हागिर चर ङइ ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","याकूबए ताँ थेसि चमैंइ ह्रों-ह्रोंसने बालु मुँबै आगुए ह्‍युलर्बै देवतामैं नेरो ह्रोंसए न्हर खिबै कुण्डलमैं याकूबलाइ पिंइ धै चइ शकेम ङाँर्बै फलाँटए सिंधुँ न्होंर च सैमैं पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","छाइले चमैं ह्‍यामा च खागुबै ह्‍युलर्बै म्हिमैंइ “चुमैं परमेश्‍वरए म्हिमैं ग,” बिब् सेसि ङ्हिंइ, छतमा खाबज्यै चमैंलाइ आल्ह। ");
INSERT INTO gvr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","याकूब ह्रोंसए ताँन् म्हिमैंने कनान ह्‍युलर्बै लूज सहर, अथवा बेथेलर, फेखइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","झाइले चइ चर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि च क्ल्ह्‍योए मिं एल-बेथेल थेंइ, तलेबिस्याँ च ह्रोंसए आघें एसावउँइँले भौदिह्‍याबै त्हेर परमेश्‍वरजी च क्ल्ह्‍योर्न खी म्रोंल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","चर रिबेकाए केब्स्यो दबोरा सिइ, धै च बेथेल ङाँर्बै फलाँटए सिधुँ न्होंर चमैंइ पाइ। छतसि च क्ल्ह्‍योए मिं अल्‍लोन-बकुत थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","याकूब पद्दन-आरामउँइँले एखबै लिउँइँ परमेश्‍वर धबै च ङाँर म्रोंयुसि चलाइ आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","परमेश्‍वरजी चने बिइ, “क्हिए मिं याकूब ग। दिलेया तारे क्हिलाइ याकूब बिरिब् आरे, क्हिए मिं इस्राएल तब्मुँ।” छले चए मिं इस्राएल तइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","परमेश्‍वरजी चने धबै बिइ, “ङ तोन्दोंरि सै लल् खाँबै परमेश्‍वर ग। क्हिए सन्तानमैं ल्हें तब्मुँ। क्हिउँइँलेन् ल्हें ह्रेंमैं तखब्मुँ। धै क्हि म्रुँमैंए खे तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","अब्राहाम नेरो इसहाकलाइ पिंबै ह्‍युल ङइ क्हिलाइ पिंब्मुँ। धै क्हिए लिउँइँ खबै सन्तानलाइ ङइ च ह्‍युल पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","झाइले चने ताँ सेबै क्ल्ह्‍योउँइँले परमेश्‍वर कैंडो क्रेयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","चने बालु परमेश्‍वर ताँ सेबै क्ल्ह्‍योर याकूबइ युँमा घ्रि क्योइ। च लिउँइँ चइ चए फिर अँगुरए खुगु नेरो छ्युगु युमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","परमेश्‍वरजी चने ताँ सेबै क्ल्ह्‍योए मिं याकूबइ बेथेल थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","चमैं धबै बेथेलउँइँले ह्‍यामा एप्रात फेखबि छेमा राहेल सुत्केरि बेथा ल्हैदिसि बेल्‍ले नइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","च सैदिलै आखाँन्ले नमा सुसार लबै च्हमिरिइ चने बिइ, “आङ्हिंन्! क्हिल धबै च्ह घ्रि फिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","दिलेया राहेलइ सो पिबै त्हेर चइ च प्हसेए मिं बेन-ओनि थेंइ। दिलेया याकूबइ बिस्याँ च कोलोए मिं बेन्यामीन थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","छले राहेल सिइ, धै एप्रात अथवा बेथलेहेम ह्‍याबै घ्याँर चमैंइ पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","याकूबइ चए छगोंए फिर त्हो घ्रि क्योइ। चु राहेलए छगोंर्बै त्हो ग। चु तोगो समा मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","झाइले याकूब ह्‍यासि मिग्दल-एदेरए क्योंजा ह्रोंसए तम्बु टौंदिइ। ");
INSERT INTO gvr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","याकूब (इस्राएल) च ह्‍युलर टिमा चए च्ह थेब रूबेन चए आबाए केब्स्यो बिल्‍हाने बालु रोइ। चु ताँ याकूबइ थेसि मि धोंलेन् लुँबै ह्रिस खइ। याकूबल च्युसे ङ्हिं च्हमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","लेआउँइँले च्ह थेब रूबेन, च न्होंर्बै शिमियोन, लेबी, यहूदा, इस्साखार नेरो जबूलून मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","राहेलए च्हमैं योसेफ नेरो बेन्यामीन मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","राहेलए केब्स्यो बिल्हाउँइँले च्हमैं दान नेरो नप्‍ताली मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","लेआए केब्स्यो जिल्पाउँइँले च्हमैं: गाद नेरो आशेर मुँल। चु ताँन् पद्दन-आरामर फिबै याकूबए च्हमैं ग। ");
INSERT INTO gvr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","याकूब चए आबा इसहाक ङाँर मम्रे बिबै क्ल्ह्‍योर खइ। (चु क्ल्ह्‍यो किर्यत-अर्बा नेरो हेब्रोन बिब् ग।) चर अब्राहाम नेरो इसहाक ओंसों टिल। ");
INSERT INTO gvr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","इसहाकए छ्ह प्रसे प्रेच्यु बर्ष तल। ");
INSERT INTO gvr_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","छले इसहाकए छ्ह ल्हें तसि सिइ। धै ह्रोंसए खेमैं-मामैंने त्होनेइ। धै चए च्हमैं एसाव नेरो याकूबइ चलाइ पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","एसाव अथवा एदोमए ताँमैं चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","एसावइ कनानी च्हमिरिमैं ङ्हिं ब्ह्‍या लइ चमैं हित्ती एलोनए च्हमि आदा नेरो हिव्वी सिबोनए क्वेंमिं धै अनाए च्हमि ओहोलीबामा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","झाइले इश्माएलए च्हमि नेरो नबायोतए अङाँ बासमत मुँल ");
INSERT INTO gvr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","एसावउँइँले आदाइ एलीपज फिइ, धै बासमतइ रूएल फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","छलेन ओहोलीबामाइ येऊश, यालाम नेरो कोरह फिइ। कनान ह्‍युलर फिबै एसावए च्हमैं चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","एसावइ ह्रोंसए प्ह्रेंस्योमैं, च्ह-च्हमिमैं, चए धिंर्बै ताँन् म्हिमैं, ह्रोंसने मुँबै ताँन् खेदोमैं नेरो कनान ह्‍युलर खागु लबै ताँन् सै न्होर बोसि ह्रोंसए अलि याकूबने फ्रेसि अर्को ह्‍युलर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","चमैंल ल्हें सै न्होर मुँल, छतसि चमैं बालुन् टिल् आखाँ। चमैंए खेदोमैंइ लमा चमैं टिबै क्ल्ह्‍योर निर्बा तल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","छतसि एसाव (अथवा एदोम) सेइर ह्‍युलर टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","सेइर बिबै ह्‍युलए कोंजरे टिबै एदोमिमैंए खेमैं एसावए ताँ छले मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","एसावए च्हमैंए मिं चुमैंन् ग: एसावए प्ह्रेंस्यो आदाए च्ह एलीपज मुँल। धै बासमतए च्ह रूएल मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","एलीपजए च्हमैं: तेमान, ओमार, सपो, गाताम नेरो कनज मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","एसावए च्ह एलीपजल तीम्न मिं मुँबै प्ह्रेंस्यो घ्रि मुँल। एलीपजउँइँले चइ अमालेक फिइ। एसावए प्ह्रेंस्यो आदाए क्वेंमैं चमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","रूएलए च्हमैं: नहत, जेरह, शम्मा नेरो मिज्जा मुँल। एसावए प्ह्रेंस्यो बासमतए क्वेंमैं चमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","एसावए प्ह्रेंस्यो ओहोलीबामा सिबोनए क्वेंमिं नेरो अनाए च्हमि मुँल। एसावउँइँले चइ च्हमैं येऊश, यालाम नेरो कोरह फिइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","एसावए प्हसेमैं न्होंर्बै चिब्मैं चुमैंन् ग। चए च्ह थेब एलीपजए चिब च्हमैं तेमान, ओमार, सपो, कनज, ");
INSERT INTO gvr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","कोरह, गाताम नेरो अमालेक। एदोम ह्‍युलर एलीपजउँइँले तबै चिब्मैं चुमैंन् ग। चुमैं आदाए क्वेंमैं ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","एसावए च्ह रूएलए च्हमैं: नहत, जेरह, शम्मा नेरो मिज्जा मुँल। चमैं एदोम ह्‍युलर रूएलउँइँले तबै चिब्मैं चुमैंन् ग। एसावए प्ह्रेंस्यो बासमतए क्वेंमैं चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","एसाबए प्ह्रेंस्यो ओहोलीबामाए चिब च्हमैं: येऊश, यालाम नेरो कोरह मुँल। अनाए च्हमि एसावए प्ह्रेंस्यो ओहोलीबामाइ फिबै चिब्मैं चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","एसाव अथवा एदोमए च्हमैं न्होंर्बै चिब्मैं चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","च ह्‍युलर टिबै एदोमथें होरी सेइरए च्हमैं लोतान, शोबाल, सिबोन, अना ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","दीशोन, एसेर नेरो दीशान। एदोम ह्‍युलर सेइरए च्हमैं होरीमैंए चिब्मैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","लोतानए च्हमैं: होरी नेरो हेमान ग। तीम्न लोतानए अङाँ मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","शोबालए च्हमैं: अल्बान, मानहत, एबाल, शपो नेरो ओनाम मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","सिबोनए च्हमैं: अय्या नेरो अना मुँल। अनाइ ह्रोंसए आबा सिबोनए गधामैं छरिमा क्यु आयोंबै ह्‍युलरि लल क्युए मुल स्याब चु अना ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","अनाए च्ह-च्हमिमैं: दीशोन नेरो चए च्हमि ओहोलीबामा ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","दीशोनए च्हमैं: हेमदान, एश्बान, यित्रान नेरो करान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","एसेरए च्हमैं: बिल्हान, जावान नेरो अकान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","दीशानए च्हमैं: ऊज नेरो आरान मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","होरीमैंए चिब्मैं लोतान, शोबाल, सिबोन, अना, ");
INSERT INTO gvr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","दीशोन, एसेर नेरो दीशान ग। सेइर ह्‍युलर चमैंए खलकर्बै होरीमैंए चिब्मैं चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","इस्राएलर्बै अरू म्रुँमैंइ ग्याल्स लब् भन्दा ओंसों एदोम ह्‍युलर ग्याल्स लबै म्रुँमैं चुमैंन् ग: ");
INSERT INTO gvr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","बओरए च्ह बेलाइ एदोमर ग्याल्स लमल। चए राजधानीए मिं दिन्हाबा मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","बेला सिबै लिउँइँ बोज्रार टिबै जेरहए च्ह योबाबइ चए क्ल्ह्‍योर ग्याल्स लइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","योबाब सिबै लिउँइँ तेमानीमैंए ह्‍युलर्बै हूशामइ चए क्ल्ह्‍योर ग्याल्स लइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","हूशाम सिबै लिउँइँ मोआब ह्‍युलर मिद्यानलाइ ट्होबै बददए च्ह हददइ चए क्ल्ह्‍योर ग्याल्स लइ। चए राजधानीए मिं अवीत मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","हदद सिबै लिउँइँ मास्रेकार टिबै सम्‍लाइ चए क्ल्ह्‍योर ग्याल्स लइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","सम्‍ला सिबै लिउँइँ स्योंए रेर्बै रहोबोत सहरर्बै शौलइ चए क्ल्ह्‍योर ग्याल्स लइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","शौल सिबै लिउँइँ अक्बोरए च्ह बाल-हानानइ चए क्ल्ह्‍योर ग्याल्स लइ। ");
INSERT INTO gvr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","अक्बोरए च्ह बाल-हनान सिबै लिउँइँ हददइ चए क्ल्ह्‍योर ग्याल्स लइ। चए राजधानीए मिं पाऊ मुँल। चए प्ह्रेंस्योए मिं महेतबेल मुँल। च मत्रेदए च्हमि नेरो मे-जाहाबए क्वेंमिं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","एसावउँइँले तबै चिब्मैंए मिं, चमैं टिबै क्ल्ह्‍यो नेरो बंशमै चुमैंन् ग: तीम्न, अल्वा, यतेत, ");
INSERT INTO gvr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ओहोलीबामा, एलाह, पीनोन, ");
INSERT INTO gvr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","कनज, तेमान, मिब्सार, ");
INSERT INTO gvr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","मग्दीएल नेरो ईराम। चमैंइ क्ल्हे लबै ह्‍युलर टिबै क्ल्ह्‍योर्बै चिब्मैं चुमैंन् ग। एदोमिमैंए खे नेरो एसावए ताँ चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","याकूब ह्रोंसए आबा टिबै कनान ह्‍युलर टिमल। ");
INSERT INTO gvr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","चए सन्तानए ताँ चुन् ग। चए च्ह योसेफ च्युसे ङिदिं तमा चए आघेंमैंने बालु र-क्युमैंए बगाल छमल। चमैं याकूबए केब्स्योमैं बिल्हा नेरो जिल्पाए च्हमैं मुँल। तिंगें योसेफइ ह्रोंसए आघेंमैंइ लबै आछ्याँबै केमैं आबा ङाँर बिखइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","याकूब (इस्राएल) खेब् तबै त्हेर योसेफ फिबइले चइ अरू च्हमैं भन्दा योसेफलाइ ल्हें म्हाँया लमल। छतसि चइ योसेफए ल्हागिर छ्याँब बुट्टा झोंबै ह्रिंबै बखु टुमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","छले आबाइ अरू च्हमैं भन्दा चए फिर ल्हें म्हाँया लब् म्रोंसि चए आघेंमैं चने बालु ख्रे लबर होंइ। धै चने बालु छेनाले आपोंमल। ");
INSERT INTO gvr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","तिगें योसेफइ म्होंड म्रोंइ। चइ च म्होंड आघेंमैंने सेमा चमैं झन चने बालु ल्हें ख्रे लबर होंइ, ");
INSERT INTO gvr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","तलेबिस्याँ चइ चमैंने बिइ, “ङइ म्रोंबै म्होंड थेद् ओ। ");
INSERT INTO gvr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ङ्यो ताँन् म्रोंर गउँए प्हैं फैरिल। ङए प्हैं राइ, धै क्हेमैंए प्हैंमैंइ कारग्युले ङए प्हैं फ्योइ।” ");
INSERT INTO gvr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","छबिमा चए आघेंमैंइ चने बिइ, “ङिए फिर क्हिइ ग्याल्स लल् म्हैल् वा? ङिए फिर क्हि क्ल्हे तल् म्हैल् वा?” छतमा चइ म्रोंबै म्होंडए ताँमैंइ लमा आघेंमैं चने बालु बेल्‍ले ख्रे लबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","च लिउँइँ चइ धबै म्होंड म्रोंसि आघेंमैंने बिइ, “ङइ धबै म्होंड म्रोंइ। त्हिंयाँ, लयाँ नेरो च्युसे घ्रि मुसारमैंइ ङलाइ फ्योरिल।” ");
INSERT INTO gvr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","छले चइ ह्रोंसए आबा नेरो आघेंमैंने चु म्होंड सेमा चए आबाइ चलाइ हौदिसि बिइ, “क्हिइ म्रोंबै चु म्होंड खैबै म्होंड जा? ङ, क्हिए आमा नेरो क्हिए आघेंमैं खसि क्हिलाइ कुरसि फ्योले वा?” ");
INSERT INTO gvr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","छतमा चए आघेंमैंइ चने ह्रिस लबर होंइ। दिलेया आबाइ बिस्याँ च ताँ सैं न्होंर्न थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","तिगें योसेफए आघेंमैंइ आबाए र-क्युमैं छबर शकेम बिबै क्ल्ह्‍योर ह्‍याल। ");
INSERT INTO gvr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","छतमा याकूबइ (इस्राएलइ) योसेफने बिइ, “क्हिए आघेंमैं शकेमर र-क्युमैं छसिन् मुँ। छतसि खो! ङइ क्हि चमैं ङाँर कुलब्मुँ।” योसेफइ “तम्, ङ ह्‍याबर तयार मुँ, आबा,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","याकूबइ चने बिइ, “क्हिए आघेंमैं नेरो र-क्युमैं छ्याँबन् मुँ उ आरे ह्‍यासि ङ्‍ह्‍योद्। झाइले च ताँमै ङ ङाँर बिखो।” छबिसि चइ योसेफलाइ हेब्रोनए ब्याँसिउँइँले शकेमर कुलइ। योसेफ शकेमर फेनेमा ");
INSERT INTO gvr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","म्हि घ्रिइ च म्रोंर स्युररिब स्यासि चने “क्हिइ खाबलाइ म्हैल?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“ङ ङए आघेंमैं म्हैरिलो। चमैंइ र-क्युमैं खनिर छरिइमुँ? गार आम्हाँदिल्‍ले ङने बिमिंन् बिसि चइ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","धै च म्हिइ बिइ, “चमैं छुइले ह्‍याइ। चमैंइ ‘ङ्यो दोतानइ ह्‍‍याले’ बिरिब ङइ थेल।” छबिमा योसेफ ह्रोंसए आघेंमैं म्हैदै ह्‍यामा चमैंलाइ दोतानर स्याइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","आघेंमैंइ ह्रेंगोउँइँले योसेफ खरिब् म्रोंसि च खेंमैं ङाँर फेखब् ओंसोंन् चलाइ सैबै मत लइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","चमैंइ खेंमैंए न्होंर बिइ, “च म्होंड म्रोंबै म्हि खसिन् मुँ। तारे चलाइ सैसि होंल्दों घ्रिर भ्योंवाले। ");
INSERT INTO gvr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","झाइले ‘क्ह्‍योंर्बै खेदोमैंइ चलाइ चवान’ बिसि ङ्योइ आबाने बिले। धै चए म्होंडमैं तो तमना ङ्ह्‍योले।” ");
INSERT INTO gvr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","चु ताँ थेसि आघें रूबेनइ “ङ्योइ चलाइ सैल् आत,” बिसि चमैंए योउँइँले योसेफ जोगेल् म्हैइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","“चलाइ आसैले, बरु चुर तोइ आरेबै क्ल्ह्‍योर्बै चु होंल्दोंर भ्योंवाले। दिलेया चए फिर यो आझोंले।” चमैंए योउँइँले जोगेसि योसेफ ह्रोंसए आबा ङाँर कुल्मिंबै सैं मैंसि रूबेनइ छ बिल। ");
INSERT INTO gvr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","झाइले योसेफ ह्रोंसए आघेंमैं ङाँर फेखमा चइ खिबै छ्याँबै बुट्टा झोंबै बख्खु चमैंइ प्लिसि प्हेंवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","च लिउँइँ चमैंइ चलाइ क्हासि क्यु आरेबै थेबै होंल्दोंर भ्योंवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","च लिउँइँ चमैं चब् चबर टिमा क्होवाँइ ङ्ह्‍योमा गिलादउँइँले छों लबर खबै इश्माएलीमैं म्रोंइ। चमैंइ लिंबै थाँ खबै मसल, लेप नेरो मूर्र सलुमैंए फिर थेंसि मिश्रउँइँ ह्‍यारिल। ");
INSERT INTO gvr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","छतमा यहूदाइ ह्रोंसए आघें-अलिमैंने बिइ, “ङ्योइ ह्रोंसए अलि सैसि चए को लोस्याँ तो फाइदा तमुँ? ");
INSERT INTO gvr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","छतसि चए फिर ङ्योइ यो आझोंले, बरु चलाइ इश्माएलीमैंए योर चुँवाले। तलेबिस्याँ च ङ्योए अलि ग, ङ्योए से-को घ्रि ग।” छबिमा चए आघें-अलिमैंइ चइ बिबै ताँ ङिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","लिउँइँ छों लबै मिद्यानिथेंमैं च घ्याँउँइँले खमा योसेफए आघेंमैंइ चलाइ होंल्दोंउँइँले चैंपसि इश्माएलीमैंए योर चाँदिए मुइ ङ्हिस्युर चुँवाइ। छले चमैंइ योसेफ मिश्र बिबै ह्‍युलर बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","च लिउँइँ रूबेन होंल्दोंर एखमा योसेफलाइ चर आम्रोंमा सैं नसि ह्रोंसए क्वें ट्होवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","झाइले अलिमैं ङाँर ह्‍यासि बिइ, “च फ्रेंसिम् चर आरेन! तारे ङ खनिर ह्‍याब?” ");
INSERT INTO gvr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","झाइले चमैंइ र घ्रि सैसि योसेफए बख्खु कोर प्ल्हुँमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","झाइले च छ्याँबै बुट्टा झोंबै बख्खु चमैंइ खेंमैंए आबा ङाँर पखसि बिइ, “ओ आबा! चु बख्खु ङिइ योंइ। ङ्ह्‍योत्ति, चु क्हिए च्हल् ङिंब् उ आङिं?” ");
INSERT INTO gvr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","याकूबइ च क्वें सेसि बिइ, “चु ङए च्हए बख्खु ग। क्ह्‍योंर्बै खेदोमैंइ चलाइ चवालै! क्ह्रोंसेंन ङए च्ह च्यता-चिति लवालै।” ");
INSERT INTO gvr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","छतमा चइ ह्रोंसए क्वें ट्होवाइ, धै ह्रेंगा खिसि ह्रोंसए च्हए ल्हागिर ल्हें त्हे समा शोक लइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","चए च्ह-च्हमिमैं ताँनइ आबाए सैं क्होमिंल् म्हैइ। दिलेया आबाए सैं क्होल् आङिं। छतसि आबाइ योसेफए ल्हागिर शोक लसि “ङ शोक लसिन् ङए च्ह ङाँर क्रोंर ह्‍याम्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","योसेफ बिस्याँ मिश्र ह्‍युलर फेनेमा मिद्यानिमैंइ चलाइ फारो म्रुँए दरबार रुँब्मैं न्होंर्बै पोतीफर बिबै कप्‍तानने चुँवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","च त्हेर यहूदा ह्रोंसए आघें-अलिमैं वाथेंसि हिरा मिं मुँबै अदुल्‍लामथें ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","चर यहूदाइ शूआ मिं लबै कनानीए च्हमि म्रोंसि चलाइ ब्ह्‍या लसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","चइ प्हसे नोसि च्ह घ्रि फिइ। चए मिं एर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","च धबै प्हसे नोसि च्ह फिसि चए मिं ओनान थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","धबै चइ च्ह घ्रि फिसि चए मिं शेलह थेंइ। चइ च फिबै त्हेर यहूदा कजीब बिबै क्ल्ह्‍योर टिरिल। ");
INSERT INTO gvr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","यहूदाइ ह्रोंसए च्ह थेब एरए ल्हागिर तामार मिं मुँबै प्ह्रेंस्यो पखमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","दिलेया यहूदए च्ह थेब एरइ याहवेहए उँइँर आछ्याँबै के लमल छतसि याहवेहजी च सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","छतसि यहूदाइ म्हैला च्ह ओनानने बिइ, “क्हिए चों ङाँर ह्‍यासि क्हिए आघेंए ल्हागिर प्हसेमैं योंमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","दिलेया च्होंउँइँले खबै प्हसे ह्रोंसल आतब् सेसि चों ङाँर ह्‍यामा ओनानइ आघेंलै या प्हसे आतरिगे बिसि प्लु सर भ्योंवामल। ");
INSERT INTO gvr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","चइ छले आछ्याँबै सैंले चु के लब् म्रोंसि याहवेहजी चलाज्यै या सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","छतमा यहूदाइ ह्रोंसए च्हों तामारने बिइ, “ङए च्ह शेलह थेब् आतन् समा म्हरेस्योन् तसि क्हिए आबाए धिंर टिद्।” तलेबिस्याँ शेलह या चए आघेंमैं धोंलेन् सियाम् उ बिसि च ङ्हिंल। छतसि तामार ह्रोंसए आबाए धिंर ह्‍यासि टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","चर टिदै लमा तिगें यहूदाए प्ह्रेंस्यो शूआए च्हमि सियाइ। प्ह्रेंस्योए शोक लबै त्हे खाँबै लिउँइँ यहूदा चए थु अदुल्‍लामथें हिरालाइ किंसि तिम्नार क्युए पै प्ह्रेब्मैं ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","क्युए पै प्ह्रेबर ह्रोंसए कें तिम्नार ह्‍यासिन् मुँ बिब तामारइ था सेइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","छतसि म्हिमैंइ च ङो आसेरिगे बिसि म्हरेस्योए क्वें प्लिसि लि हुसि। तिम्नार्बै घ्याँर मुँबै एनैम सहरर्बै म्रार टिइ। तलेबिस्याँ शेलह थेब् तसेया शेलहए प्ह्रेंस्यो तल् आयोंब चइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","चइ लि हुब् म्रोंसि यहूदाइ चलाइ फ्रें क्ल्योंबै च्हमिरि मुँन ङ्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","घ्याँए रेर ह्‍यासि चइ चने बिइ, “ङ क्हि ङाँर खल् पिंन्।” तलेबिस्याँ चइ ह्रोंसए चों ग बिसि ङो आसेल। “क्हि ङ ङाँर खम् बिस्याँ ङलाइ तो पिंम् दि?” बिसि चइ ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","चइ बिइ, “बगालउँइँले ङइ र म्होदो घ्रि पिंस्यो।” चइ बिइ, “क्हिइ च र-म्होदो ङ ङाँर आकुलन् समा क्हिए तो मुँले सै ङने थेंम् उ?” ");
INSERT INTO gvr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","यहूदाइ बिइ, “ङइ तो सै थेंलेदि?” चइ बिइ, “क्हिए छाप नेरो चए छो धै क्हिए योर्बै चु प्हरे थेंस्याँ तम्।” छबिमा यहूदाइ चने च सैमैं पिंसि चने बालु तइ। च लिउँइँ चउँइँले चइ प्हसे नोइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","च रेसि धिंर ह्‍याइ धै लि हुबै क्वें प्लिवासि म्हरेस्योमैंइ खिबै क्वें खिइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","यहूदाइ च च्हमिरिने थेंबै सैमैं च ङाँइले पबै ल्हागिर चए थु अदुल्‍लामथेंने र-म्होदो घ्रि कुलइ। दिलेया चइ च च्हमिरि आत्हो। ");
INSERT INTO gvr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","छतसि चइ च क्ल्ह्‍योर्बै म्हिमैंने ङ्योएइ, “एनैमर घ्याँए रेर टिबै फ्रें क्ल्‍योंबै च्हमिरि खनिर मुँ?” बिमा चमैंइ चने बिइ, “चुर छाबै फ्रें क्ल्योंबै च्हमिरि आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","छतसि च म्हि यहूदा ङाँर एखसि “ङइ च च्हमिरि आत्हो बिइ, धै च क्ल्ह्‍योर्बै म्हिमैंज्यै या ‘चुर छाबै च्हमिरि आरे बिइ।’” ");
INSERT INTO gvr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","यहूदाइ बिइ, “च सैमैं चनेन् थेंरिगे, आस्याँ ङ्यो फा फिल् त्हुब्मुँ। ङइ चु र-म्होदो कुलल्दो आत्होसेरो तो लब्दि।” ");
INSERT INTO gvr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","म्हैंन सोंल् लिउँइँ म्हि घ्रिइ यहूदाने बिइ, “क्हिए चों तामारइ फ्रें क्ल्योंसि प्हसे नोइमुँ।” छबिमा यहूदाइ बिइ, “चलाइ चुर पखसि ख्रोंवाँन्।” ");
INSERT INTO gvr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","छले तामार पखसि खरिमा चइ ह्रोंसए कें ङाँर छ बिसि सउँसर पिंमिंइ, “चु सैमैं खाबल् जा, चउँइँलेन् ङइ प्हसे नोब् ग। ङ्‍ह्‍योद्, चु छाप चु छो नेरो चु प्हरे खाबल् जा?” ");
INSERT INTO gvr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","छबिमा यहूदाइ बिइ, “चु सैमैं ङल् ग! चम् ङ भन्दा धर्मि मुँन। तलेबिस्याँ ङइ ङए च्ह च्योंब शेलह चए प्युँ तबर आपिंल।” च लिउँइँ च धबै चने बालु आप्र। ");
INSERT INTO gvr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","प्हसे फिबै त्हेर तामारए फोर जौंले मुँन बिब था योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","च प्हसे फिबै बेथा खमा प्हसे घ्रिइ यो बैरु तेइ धै सुसर लबै च्हमिरिइ चए योर ओल्ग्या रु घ्रिइ फैसि बिइ, “ओंसों फिब चुन् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","दिलेया चइ ह्रोंसए यो न्होंर बोबै लिउँइँ चए अलि ग फिइ। छतमा च सुसर लबै च्हमिरिइ बिइ, “तो जा क्हिम् छले खैचिजीले त्होंयुब!” छतसि चए मिं फारेस थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","लिउँइँ योर ओल्ग्या रुइ फैब फिइ। चए मिं जेरह थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","इश्‍माएलीमैंइ योसेफ किंसि मिश्र ह्‍युलर बोइ। धै फारो म्रुँए दरबार रुँब्मैं न्होंर्बै कप्‍तान पोतीफर बिबै म्हिए योर चुँवाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","दिलेया याहवेह परमेश्‍वर योसेफने बालु मुँल। छतसि चर च प्लब् ततै ह्‍याइ। च ह्रोंसए क्ल्हे मिश्रीथेंए धिंर टिमल। ");
INSERT INTO gvr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","“याहवेह चने बालु मुँब नेरो चइ लबै ताँन् केमैं याहवेहजी छ्याँब लमिंम्” बिसि चए क्ल्हे पोतीफरइ म्रोंसि ");
INSERT INTO gvr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","सैं तोंइ, धै ह्रोंसए धिंर के लब्मैंए न्होंर्बै चिब लमिंइ। ह्रोंसने मुँबै तोन्दोंरि सैए जिम्मा योसेफलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","चइ ह्रोंसए धिंर्बै नेरो ह्रोंसने मुँबै तोन्दोंरि सैए जिम्मा योसेफलाइ पिंबै त्हेसेरो योसेफ चर मुँबइले याहवेहजी च मिश्रीथेंए धिंर आशिक पिंसि चए धिं-नाँ नेरो म्रोंर रोबै ताँन् सैमैंए फिर आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","छतमा ह्रोंसने मुँबै तोन्दोंरि सैमैं योसेफए जिम्मार पिवाइ। ह्रोंसइ चबै सै बाहेक ह्रोंसने मुँबै तोइ सैलेया चइ वास्ता आलमल। योसेफ ङ्ह्‍योबर बेल्‍ले छ्याँब मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","छतमा दे त्हे लिउँइँ चए क्ल्हेए प्ह्रेंस्योइ योसेफउँइँ ङ्ह्‍योसि “ङने बालु रोद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","दिलेया योसेफइ आङिंसि चने बिइ, “ङ चु धिंर मुँबइले ङए क्ल्हेइ चु धिंर मुँबै तोइ सैलेया न्हुँ आल। चने मुँबै तोन्दोंरि सैमैं या चइ ङए जिम्मार पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","चु धिंर ङ भन्दा थेब खाबै आरे। क्हि बाहेक अरू तोन्दोंरि सै चइ ङए जिम्मर्न पिंइमुँ, तलेबिस्याँ क्हि चए प्ह्रेंस्यो ग। छतसि चु आछ्याँबै के ङइ खैले लब, धै परमेश्‍वरए बिरोधर ङइ खैले पाप लल् खाँमुँ?” ");
INSERT INTO gvr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","च च्हमिरिइ त्हिंइ ह्रोंसे योसेफने ताँ ललेया चने बालु रोब टिब लबर योसेफ आङिंमल। ");
INSERT INTO gvr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","तिगें योसेफ के लबर धिं न्होंर ह्‍यामा धिंर अरू के लब्मैं खाबै आरेल। ");
INSERT INTO gvr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","छतमा च च्हमिरिइ योसेफए क्वें क्हासि “ङने बालु रोद्,” बिइ। दिलेया योसेफइ ह्रोंसए क्वें चए योर्न वाथेंसि न्हेह्‍याइ, धै धिं न्होंउँइँले बैरु त्होंह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","योसेफइ ह्रोंसए क्वें चए योर्न वाथेंसि धिं न्होंउँइँले त्होंह्‍याब् म्रोंसि, ");
INSERT INTO gvr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","च च्हमिरिइ ह्रोंसए केब्छैंमैं हुइसि बिइ, “ङ्ह्‍योत्ति! ङिए मिं वाबर ङए प्युँइ चु हिब्रू म्हि चुर पखन। च म्हि ङने बालु रोबर धिं न्होंर खइ। दिलेया ङ थेबै कैले ओरइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","छले ङ ओरब् थेसि चइ ह्रोंसए क्वें ङ ङाँर वाथेंसि धिं न्होंउँइँले बैरु न्हेह्‍याइ।” ");
INSERT INTO gvr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","चए प्युँ धिंर आखन् समा चइ च क्वें ह्रोंसनेन् थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","लिउँइँ चए प्युँ खमा चु ताँ बिइ, “ङ्यो ङाँर क्हिइ पखबै च हिब्रू केब्छैं ङए मिं वाबर धिं न्होंर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","दिलेया ङ ओरबै तोदोंन् चइ ह्रोंसए क्वें ङ ङाँर्न वाथेंसि धिं न्होंउँइँले भौदिह्‍याइ।” ");
INSERT INTO gvr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","प्ह्रेंस्योइ बिबै ताँ थेमा पोतीफर मि धोंलेन् लुँबै ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","झाइले चइ योसेफलाइ म्रुँए कैदिमैं च्युथेंबै झेलर च्युवाइ। छले योसेफ झेलर टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","दिलेया याहवेह योसेफने बालु मुँल। खीजी चए फिर ल्हयो खइ, छतसि योसेफ झेलर्बै चिबइ खोबै म्हि तल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","छतसि झेलर्बै चिबइ च झेलर च्युथेंब्मैंए फिर्बै चिब योसेफ लमिंइ। चर लल् त्हुबै केमैं तो मुँलेया योसेफइ ल्हैदिसेरो तयामल। ");
INSERT INTO gvr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","योसेफए जिम्मार पिंबै तोइ सैलेया झेलर्बै चिबइ न्हुँ लल् आत्हुमल। तलेबिस्याँ याहवेह योसेफने बालु मुँल। योसेफइ लबै तोन्दोंरि के याहवेह परमेश्‍वरजी बेल्‍ले छ्याँब लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","दे त्हे लिउँइँ मिश्रर्बै म्रुँए थुँबै सैमैं पिंखबै चिब नेरो चबै सैमैं ह्‍योमिंबै चिबइ म्रुँए बिरोधर अपराध लइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","छतमा फारो ह्रोंसए थुँबै सैमैं पिंखबै चिब नेरो चबै सैमैं ह्‍योमिंबै चिबने ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","झाइले चइ चमैंलाइ दरबार रुँब्मैंए न्होंर्बै कप्‍तानने झेलर च्युबर पिंवाइ। च झेलर योसेफै या च्युथेंल। ");
INSERT INTO gvr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","च कप्‍तानइ चमैं योसेफए जिम्मार थेंमिंइ। चर योसेफइ चमैंलाइ ङ्ह्‍योबै केमैं लमल। दे त्हे समा चमैं झेलर्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","झेलर फेबै मिश्रर्बै म्रुँए थुँबै सैमैं पिंनेबै चिब नेरो चबै सैमैं ह्‍योमिंबै चिब ङ्हिंइन तिंगें स्यो-स्योबै म्होंड म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","योसेफ न्हाँगर चमैं ङाँर खमा चमैं न्हुँ लसि टिरिब् म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","छतमा योसेफइ चमैंने “तिंयाँ क्हेमैं तले आतोंन्ले टिरिल?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","चमैंइ चने बिइ, “ङिइ म्होंड म्होंइ। दिलेया म्होंडए अर्थ बिमिंबै म्हि चुर खाबै आयों।” योसेफइ चमैंने बिइ, “म्होंडए अर्थ परमेश्‍वरजी मत्‍त्रे सेल् खाँम्। क्हेमैंए म्होंडमैं ङने सेद्।” ");
INSERT INTO gvr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","योसेफइ छबिमा म्रुँए थुँबै सैमैं पिंनेबै चिबज्यै या ह्रोंसए म्होंड सेइ। “ङए म्होंडर ङए उँइँर अँगुरए धुँ घ्रि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","अँगुरए धुँर हाँग सों मुँल। चर च्योंरि हाँगमैं म्‍लोखसि टमैं या बेल्‍ले छेन्ले प्हारइ, धै अँगुरए झुप्पामैं पाँ-पाँले अँगुर रोसि मिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","फारोए प्हेल ङए योर मुँल। धै ङइ अँगुर च्ह्‍योरसि फारोए प्हेलर झोंसि च प्हेल फारोए योर थेंमिंइ।” ");
INSERT INTO gvr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","योसेफइ चने बिइ, “चुए अर्थ चुन् ग: हाँग सों बिब सोंरो ग। ");
INSERT INTO gvr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","सोंरो न्होंर फारो म्रुँइ क्हि झेलउँइँले तेमिंब्मुँ, धै क्हिलाइ धबै ओंसोंबै केन् पिंब्मुँ। ओंसों क्हिइ फारोलाइ थुँबै सैमैं पिंनेब् धोंलेन् धबै क्हिइ थुँबै सैमैं चए योर थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","दिलेया क्हिए बिब् धों तमा ङलाज्यै या मैंन् ओ। गार आम्हाँदिल्‍ले फारोने ङए ताँ लसि चु झेलउँइँले ङ तेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","तलेबिस्याँ क्ह्रोंसेंन म्हिमैंइ ङलाइ हिब्रूमैंए ह्‍युलउँइँले क्हासि पखब् ग। धै चुरै या झेलर टिल् त्हुबै के ङइ तोइ आलल।” ");
INSERT INTO gvr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","च म्होंडए अर्थ छ्याँब तब् म्रोंसि चबै सैमैं ह्‍योमिंबै चिबज्यै या योसेफने बिइ, “ङज्यै या छाबै म्होंड घ्रि म्होंइ। ङए क्रर क्हेंए ट्हलो सों मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ताँन् भन्दा फिर्बै ट्हलोरि फारोए ल्हागिर ह्‍योमिंबै ल्हें खालर्बै चबै सैमैं मुँल। दिलेया ङए क्रर मुँबै ट्हलोउँइँले नमेंमैंइ चो-चोसि चरिल।” ");
INSERT INTO gvr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","योसेफइ बिइ, “चु म्होंडए अर्थ चुन् ग: ट्हलो सों बिब सोंरो ग। ");
INSERT INTO gvr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","सोंरो न्होंर फारो म्रुँइ क्हिलाइ या झेलउँइँले तेसि, क्हिए क्र थोवाब्मुँ, धै क्हि सिंधुँर च्योवाब्मुँ। धै नमेंमैंइ क्हिए से चो-चोसि चब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","सोंरो लिउँइँ फारो फिबै त्हिंइ मुँल। छतमा फारो म्रुँइ च त्हिंर ह्रोंसए ताँन् चिबनाँब्मैं चब्-थुँब् लबर हुइल। धै चए थुँबै सैमैं पिंब नेरो चबै सैमैं ह्‍योबै चिब्मैं या झेलउँइँले तेपखसि चमैं ङाँर राल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","चइ ह्रोंसए थुँबै सैमैं पिंखबै चिबलाइ धबै ओंसोंबै ह्रोंसए केन् लल् पिंइ, धै चइ फारोए प्हेल फारोए योर पिंब्रें लइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","झाइले योसेफइ चमैंए म्होंडए अर्थ बिमिंब् धोंले चबै सैमैं ह्‍योबै चिब बिस्याँ फारो म्रुँइ च्योवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","दिलेया फारोए थुँबै सैमैं पिंनेबै चिबइ योसेफलाइ आमैं, चइ योसेफलाइ म्‍लेयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ङ्हिदिं योबै लिउँइँ फारो म्रुँइ म्होंड घ्रि म्रोंइ। म्होंडर च नील स्योंए छ्योगोर रारिल। ");
INSERT INTO gvr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","नील स्योंउँइँले ख्युँइँ-ख्युँइँ ब्योंबै छो-छोबै म्येमैं ङिउँलो त्होंखसि काँसाए घारिर रेंबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","च लिउँइँ ह्रुइब नेरो ट्हुबि मत्‍त्रे मुँबै प्ल्याँडु म्येमैं ङिउँलो नील स्योंउँइँलेन् त्होंसि ओंसोंबै म्येमैंने बालु राइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","च ह्रुइब् नेरो ट्हुबि मत्‍त्रे मुँबै प्ल्याँडु म्येमैंइ च ख्युँइँ-ख्युँइँ ब्योंबै छो-छोबै म्येमैं ङिउँलो चवाइ। च त्हेर्न फारो छोरयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","च लिउँइँ च धबै न्हरु च्हुयाइ‍, झाइले अर्को म्होंड म्रोंइ। म्रेब नेरो मिंबै रोए नाँमैं डाँठ घ्रिर्न ङिउँलो म्‍लोरिल। ");
INSERT INTO gvr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","च लिउँइँ आम्रेब नेरो स्यारउँइँले (पुर्बउँइँले) खबै लल खैंइ ङ्योंलोंवाबै रोए नाँ ङिउँलो त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","झाइले च आम्रेबै नाँमैंइ च ङिउँलो छ्याँब नेरो म्रेबै नाँमैं क्ल्ह्‍योंवाइ। धै फारो छोरमा “च म्होंड मुँन!” बिब् सेइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","न्हाँगर चए सैंर बेल्‍ले न्हुँ तसि चइ मिश्र ह्‍युलर्बै ताँन् जादु लब्मैं नेरो ह्रब-सेब्मैं हुइसि चमैंने चइ म्रोंबै म्होंडमैं सेइ। दिलेया फारोए म्होंडए अर्थ बिमिंब चर खाबै आत्हों। ");
INSERT INTO gvr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","च त्हेर च फारोए थुँबै सैमैं पिंनेबै चिबइ फारोने बिइ, “ङइ म्‍लेयाबै ताँ तिंयाँ चिइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","क्हिइ ह्रोंसए केब्छैंमैंने ह्रिस खसि चबै सैमैं ह्‍योबै चिब, तोन्दोंरि सैमैं रुँबै कप्‍तान नेरो ङ पोतीफरए झेलर च्युवामा ");
INSERT INTO gvr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","म्हुँइँस तिरोर्न च नेरो ङइ स्यो-स्योबै अर्थ मुँबै म्होंडमैं म्रोंल। ");
INSERT INTO gvr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","च झेल न्होंर कप्‍तान पोतीफरए हिब्रू केब्छैं फ्रेंसि घ्रि ङिने बालु मुँल। चने ङिए म्होंडमैं सेमा चइ ङि ङ्हिंए म्होंडए अर्थ ङिने बिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","ङिए म्होंडए अर्थर चइ खै बिल छान् तइ। ङ ह्रोंसए केर धबै एखइ, दिलेया च ह्‍योब्-तेब् लबै चिब बिस्याँ क्हिइ च्योवाइ।” ");
INSERT INTO gvr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","चु ताँ थेसि फारो म्रुँइ योसेफ हुइबर कुलइ, धै चमैंइ चलाइ झेलउँइँले पखइ। च दाह्रि मुरा नेरो क्र प्ह्रेसि छारा क्वें खिसि फारो ङाँर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","फारो म्रुँइ योसेफने बिइ, “ङइ म्होंड घ्रि म्रोंइ। दिलेया च म्होंडए अर्थ चुर खाबज्यै या बिल् आखाँ। क्हिइ म्होंडए ताँमैं थेबै लिउँइँ अर्थमैं बिल् खाँम् रो बिब ङइ थेइ।” ");
INSERT INTO gvr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","योसेफइ फारोने बिइ, “छाबै ह्रबम् ङ आरे। दिलेया परमेश्‍वरजी क्हिए म्होंडए अर्थ बिमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","फारो म्रुँइ योसेफने बिइ, “ङए म्होंडर ङ नील स्योंए छ्योगोर रारिल। ");
INSERT INTO gvr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","च त्हेर बेल्‍ले ख्युँइँ-ख्युँइँ ब्योंबै छो-छोबै म्येमैं ङिउँलो नील स्योंउँइँले त्होंसि काँसाए घारिर रेंबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","च लिउँइँ ङिउँलो रालै आखाँन् ब्योंब ह्रुइब् नेरो ट्हुबि मत्‍त्रे मुँबै प्ल्याँडु म्येमैं त्होंखइ। ङइ मिश्रर खोंयोंइ आम्रोंबै म्येमैं चमैंए लिलि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","च ह्रुइब् नेरो ट्‍हुबि मत्‍त्रे मुँबै प्ल्याँडु म्येमैंइ ओंसोंबै ख्युँइँ-ख्युँइँ ब्योंबै छो-छोबै म्येमैं ङिउँलो चवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","दिलेया चमैंइ च छोबै म्येमैं ङिउँलो चवाइ बिसि खाँबज्यै बिल् आखाँमल, तलेबिस्याँ चमैं अझै ओंसोंबै धोंबन् आछोबै प्ल्याँडु मुँल। झाइले ङ छोरयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ङइ धबै म्होंडर चु या म्रोंइ। डाँठ घ्रिर्न ङिउँलो म्रेब नेरो मिंबै नाँ त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","च लिउँइँ ङ्योंलोंयाब नेरो पुर्बउँइँले खबै लल खैंइ ल्हिवाबै आम्रेबै ङिउँलो नाँमैं त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","च आम्रेबै नाँमैंइ च म्रेब नेरो मिंबै ङिउँलो नाँमैं क्ल्ह्‍योंवाइ। ङइ ह्रब्-सेब्मैंने चु म्होंड सेइ, दिलेया खाबज्यै या ङलाइ चुए अर्थ बिमिंल् आखाँ।” ");
INSERT INTO gvr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","लिउँइँ योसेफइ फारोने बिइ, “क्हिए म्होंडमैं ङ्हिंना-ङ्हिंनए अर्थ घ्रिन् ग। परमेश्‍वरजी तो लल् म्हैइमुँ च क्हिने उँइँमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","च ख्युँइँ-ख्युँइँ ब्योंबै छो-छोबै म्येमैं ङिउँलो ङिदिं ग, धै च छ्याँबै नाँ ङिउँलो या ङिदिंन् ग। म्होंड घ्रिन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","चमैंए लिउँइँ खबै ह्रुइब् नेरो ट्हुबि मत्‍त्रे मुँबै प्ल्याँडु म्येमैं ङिदिंन् ग। धै च खैंइ पोंवाबै आम्रेबै रोए नाँ ङिउँलो या अँङ्गल् ङिदिं समन् तम् बिब् ग। ");
INSERT INTO gvr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","परमेश्‍वरजी खीजी लल् म्हैबै के क्हिलाइ उँइमिंब् ग। चु ङइ क्हिने बिब् धोंलेन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","मिश्र ह्‍युलर खन्तोंदोंन् ङिदिं समा बेल्‍ले सागल तब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","दिलेया च लिउँइँ ङिदिं समा बेल्‍ले अँङ्गल तब्मुँ, धै मिश्र ह्‍युल तिगोंन् च सागलए त्हे म्‍लेयाब्मु, धै अंङ्गलइ ह्‍युल नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","च लिउँइँ खबै अंङ्गलइ लमा ह्‍युलर तबै सागल मैंरिब् आरे। तलेबिस्याँ च अँङ्गल् बेल्‍ले ङ्हिंन् ङ्हाँब् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","क्हिइ ङ्हिखे समा क्हेसि म्रोंबै म्होंडए अर्थ चुन् ग, चु क्ह्रोंसेंन लब् बिसि परमेश्‍वरजी मैंल् खाँइमुँ, धै परमेश्‍वरजी युनन् चु के लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“छतसि तारे क्हिइ मिश्र ह्‍युलर ग्याल्स लबै ल्हागिर ह्रब्-सेब नेरो बुद्धि मुँबै म्हि त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","झाइले सागलाए ङिदिं समा मिश्र ह्‍युलर्बै म्ल्ह-नारिए ङ्‍हबाँ खुबर क्हिइ चाँजो लब्मैं त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","चमैंइ तारे खबै सागलए बर्षर्बै ताँन् म्ल्ह-नारिमैं खुरिगे। नाँस-नाँसर चबै ल्हागिर म्ल्ह-नारिमैं फारोए धनसारमैंर साँथेंरिगे, छतसि रुँबै म्हिमैं या त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","अंङ्गलइ ह्‍युल नास आतरिगे बिसि मिश्रर खबै ङिदिंबै अंङ्गलए ल्हागिर च म्ल्ह-नारिमैं छेनाले थेंमिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","चु छ्याँबै ताँ फारो नेरो चए ताँन् चिब्मैंइ खोइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","झाइले फारो म्रुँइ चमैंने बिइ, “चु धों तबै परमेश्‍वरए प्ल्ह मुँबै म्हि ङ्योइ अरू योंल् खाँम्मा?” ");
INSERT INTO gvr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","छबिमा फारो म्रुँइ योसेफने बिइ, “परमेश्‍वरजी क्हिने ताँन् सैमैं उँइँमिंइमुँ। धै क्हि धों तबै ह्रब्-सेबै म्हि अरू खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","छतसि ङए ह्‍युलए फिर क्ल्हे क्हिन् तइ। क्हिइ बिब् धोंले ङए ताँन् म्हिमैं प्रब्मुँ। चु राजगद्दिए ल्हागिर मत्‍त्रे क्हि भन्दा ङ थेब् तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","धबै फारो म्रुँइ योसेफने बिइ, “लु थेद्, क्हिलाइ मिश्र ह्‍युल तिगोंन् ङइ क्ल्हे तल् पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","छबिसि फारो म्रुँइ छाप मुँबै ह्रोंसए च्या योउँइँले प्लिसि योसेफए योर खिमिंइ। धै छ्याँबै मलमलाए क्वेंइ पैरेमिंसि चए खरिर माराए सिग्रि खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","झाइले योसेफलाइ फारोइ ह्रोंसए न्होंर्बै चिब धोंले रथर क्रेसि स्युरइ। छतमा योसेफए ओंसों-ओंसों “च्हि तुँसि फ्योद्!” बिदै म्हिमैं ओरप्रइ। छले फारो म्रुँइ योसेफलाइ मिश्र ह्‍युल तिगोंन् क्ल्हे तल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","फारो म्रुँइ धबै योसेफने बिइ, “ङ फारो म्रुँ ग, दिलेया क्हिजी तम् तम् लद् आबिन् समा चु मिश्र ह्‍युलर खाबज्यै या तोइ लल् योंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","फारो म्रुँइ योसेफए मिं सापनत-पानेह थेंइ। धै चइ चलाइ ओन बिबै देवताए खेगि पोतिपेराए च्हमि आसनतने बालु ब्ह्‍या लमिंइ। च लिउँइँ योसेफ मिश्र ह्‍युलर खन्तोंदोंन् प्रबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","मिश्रर्बै फारो म्रुँए के लबै त्हेर योसेफ सोंच्यु बर्षर्बै मुँल। च त्हेसेरो योसेफ फारो ङाँइले त्होंसि मिश्र ह्‍युल तिगोंन् प्रबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","सागलाए ङिदिं समा म्रोंउँइँले बेल्‍ले ल्हें रा-रोमैं खइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","छतमा चइ मिश्रर्बै म्रोंर्बै ताँन् रा-रोमैं सागलए ङिदिं समा खागु लसि नाँ-नाँसर ङ्‍हेरेथेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","मा ङ्युँइर्बै बालुवा खुब् धोंलेन् योसेफइ ल्हें-ल्हें रा-रोमैं खुइ। रा-रोमैं ल्हें तबइले चइ हिसाब थेंबै या पिवाइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","अँङ्गल तब् भन्दा ओंसोंन् ओन् बिबै देवताए खेगि पोतिपेराए च्हमि आसनत ङाँइले योसेफल च्हमैं ङ्हिं योंल् खाँल। ");
INSERT INTO gvr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","“परमेश्‍वरजी ङए ताँन् दुःख नेरो ङए आबाए धिंर्बै ताँमैं ङलाइ म्‍लेल् पिंइमुँ,” बिसि योसेफइ च्ह थेबए मिं मनश्शे थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","“ङइ दुःख योंबै ह्‍युलरै या परमेश्‍वरजी ङलाइ च्हमैं पिंइमुँ,” बिसि चइ च्ह च्योंबए मिं एफ्राइम थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","मिश्र ह्‍युलर ङिदिंबै सागलए त्हे नुयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","झाइले योसेफइ बिब् धोंलेन् ङिदिंबै अँङ्गल खबर होंइ। ताँन् ह्‍युलर अँङ्गल् तइ। दिलेया मिश्र ह्‍युलर बिस्याँ रा-रोमैं ल्हें मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","मिश्र ह्‍युल तिंगोंन् अँङ्गल तसि तो म्हैसे तोइ आयोंमा चर्बै म्हिमैंइ फारो म्रुँने बालु “रा-रोमैं पिंन्” बिसि यो छ्युँ लइ। छलमा फारो म्रुँइ ताँन् मिश्रीमैंने “योसेफ ङाँर ह्‍याद्। चइ क्हेमैंने तो लद् बिमुँ छान् लद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","मिश्र ह्‍युल तिंगोंन् अँङ्गल तइ, झाइले योसेफइ ताँन् धनसारमैं थोंसि मिश्रीमैंने रा-रोमैं चुँबर होंइ। तलेबिस्याँ मिश्र ह्‍युल तिंगोंन् बेल्‍ले थेबै अँङ्गल् तल। ");
INSERT INTO gvr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","पृथ्‍बी तिंगोंन् थेबै अँङ्गल् तल। छतसि ताँन् ह्‍युलर्बै म्हिमैं मिश्रर योसेफ ङाँर रा-रोमैं किंबर खइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","मिश्रर म्ल्ह-नारिमैं मुँ बिब् सेसि याकूबइ ह्रोंसए च्हमैंने बिइ, “क्हेमैं तले घ्रिइ घ्रिए लिर ङ्ह्‍योसि टिरिमुँ? ");
INSERT INTO gvr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","मिश्रर म्ल्ह-नारिमैं मुँ रो बिब ङइ थेइमुँ। ङ्यो सोब् गो बिस्याँ चर ह्‍यासि ङ्योए ल्हागिर म्‍ल्ह-नारिमैं किंइ पखो।” ");
INSERT INTO gvr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","आबाइ छबिमा योसेफए आघेंमैं च्युउँलो मिश्रर म्‍ल्ह-नारिमैं किंबर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","दिलेया याकूबइ योसेफए अलि बेन्यामीन आघेंमैंने बालु आकुल। तलेबिस्याँ चलाइ तोइ तयाम् उ ङ्हाँसि याकूब ङ्हिंल। ");
INSERT INTO gvr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","छले याकूबए च्हमैं अरू म्हिमैंने बालु म्‍ल्ह-नारिमैं किंबर ह्‍याइ। तलेबिस्याँ कनान ह्‍युलरै या अँङ्गल् तल। ");
INSERT INTO gvr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","च त्हेर योसेफ मिश्रर्बै क्रथे मुँल। ह्‍युलर्बै ताँन् म्हिमैंने म्‍ल्ह नारिमैं चुँब या चन् मुँल। छतसि योसेफए आघेंमैं खसि क्र कुरदै चलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","योसेफइ ह्रोंसए आघेंमैं म्रोंसि ङो सेइ। दिलेया चइ चमैंने बालु ङो आसेब् धोंले “क्हेमैं खनिउँइँले खल?” बिसि थेबै कैले ङ्योएइ। चमैंइ बिइ, “ङि कनान ह्‍युलउँइँले म्‍ल्ह-नारिमैं किंबर खब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","योसेफइ ह्रोंसए आघेंमैं ङो सेलेया चमैंइ बिस्याँ चलाइ ङो आसेल। ");
INSERT INTO gvr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","छतमा चमैंए बारेर ओंसोंन् चइ म्रोंबै म्होंड मैंसि योसेफइ चमैंने बिइ, “क्हेमैं छैं लबर खब्मैं ग। चु ह्‍युलर तो-तो मुँगे बिसि क्होबर क्हेमैं खब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","चमैंइ योसेफने बिइ, “ओ चिब, छ आङिं। ङि क्हिए केब्छैंमैं म्‍ल्ह-नारिमैं किंबर खब् ग। ङि ताँन् म्हि घ्रिए च्हमैं ग। ");
INSERT INTO gvr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ङि सोजो म्हिमैं ग, ङि क्हिए केब्छैंमैं ग, छैं लबर खब्मैं आङिं।” ");
INSERT INTO gvr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","चइ चमैंने बिइ, “आङिं, क्हेमैं चु ह्‍युलर तो-तो तरिगे बिसि क्होबर खब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","छबिमा चमैंइ बिइ, “क्हिए केब्छैंल ङि च्युसे ङ्हिं आघें-अलिमैं मुँल। ङि कनान ह्‍युलर्बै म्हि घ्रिए च्हमैं ग। च्योंब तोगो आबाने मुँ। अलि घ्रि बिस्याँ ङिने आरे।” ");
INSERT INTO gvr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","योसेफइ चमैंने बिइ, “ङइ बिब् धोंलेन् क्हेमैं क्ह्रोंसेंन्ले छैं लबर खब्मैंन् मुँन। ");
INSERT INTO gvr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","तारे ङइ क्हेमैंए जाँच छले लब्मुँ। फारो म्रुँए मिंर कसम चसि ङ बिमुँ, क्हेमैंए च्योंब अलि आखन् समा चु क्ल्ह्‍योउँइँले क्हेमैं ह्‍याल् योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","छतसि क्हेमैंए न्होंर घ्रि क्हेमैंए अलि किंबर कुलद्। च आखन् समा क्हेमैं झेलर टिल् त्हुम्। छले क्हेमैंए ताँ क्ह्रोंसेंन्बै ङिंब उ आङिं बिसि ङइ ङ्ह्‍योब्मुँ। क्ह्रोंसेंन्बै आङिंस्याँ फारो म्रुँए मिंर कसम चसि ङ बिमुँ क्हेमैं छैं लब्मैंन् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","झाइले योसेफइ चमैं ताँन् सोंरो समा झेल घ्रिर्न च्युथेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","सोंरो लिउँइँ योसेफइ चमैंने बिइ, “ङ परमेश्‍वरने ङ्हिंबै म्हि ग। छतसि क्हेमैंइ चु के लस्याँ क्हेमैं सोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","क्ह्रोंसेंन्लेन् क्हेमैं सोजो म्हिमैं ग बिस्याँ क्हेमैंए न्होंर घ्रि चु झेलर्न टिद्। धै अरूमैं क्हेमैंए फोदें परवामैं चल् पिंबै ल्हागिर म्‍ल्ह-नारिमैं बोसि ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","धै क्हेमैंए च्योंबै अलि ङ ङाँर पइ खो। छ लस्याँ मत्‍त्रे ङइ क्हेमैंए ताँ क्ह्रोंसेंन्बै मुँन बिसि सेब्मुँ। धै क्हेमैं सिरिब् आरे। छबिमा चमैंइ छान् लइ।” ");
INSERT INTO gvr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","चमैंइ खें-खेंमैंए न्होंर बिइ, “क्ह्रोंसेंन ङ्योइ ह्रोंसए अलिलाइ दुःख पिंबइले तोगो ङ्योइ चु नों योंइमुँ। तलेबिस्याँ चइ ङ्योने यो छ्युँ लसि क्रोसेया ङ्योइ चए ताँ आथे। छतसि चु छाबै दुःख ङ्योए फिर खब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","रूबेनइ चमैंने बिइ, “ङइ च कोलो तोइ आलद् बिसि क्हेमैंने बिब् आङिं वा? क्हेमैंइ थेबै न्ह आल। तारे चलाइ सैवाबै नों ङ्योइ नोल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","योसेफ नेरो ह्रोंसए आघेंमैं स्यो-स्योबै क्युइ पोंमल। छतसि चमैंइ पोंबै ताँमैं योसेफइ क्होम् उ बिसि चमैंइ आसेल। ");
INSERT INTO gvr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","योसेफ चमैंउँइँले तिराइ तोसि क्रोइ। तिस्यादे लिउँइँ चमैं ङाँइ तोसि चमैंने ताँ सेइ। च लिउँइँ चइ चमैंउँइँले शिमियोन किंसि चमैंए मिए ओंसोंन् चलाइ फैइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","योसेफइ के लब्मैंने बिइ, “चमैंए नेंदोंजरे म्‍ल्ह-नारिमैं झोंमिंन्, धै चमैंइ पखबै चाँदिए मुइ या चमैंए नेंदोंर्न झोंमिंन्। धै चमैंए ल्हागिर घ्याँर चबै सैमैं या पिंन्।” बिमा चमैंइ छान् लइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","झाइले ह्रोंसए गधामैं फिर म्‍ल्ह-नारिमैं थेंसि चमैं छाइले प्रइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","घ्याँर बास टिबै क्ल्ह्‍योर चमैं न्होंर्बै म्हि घ्रिइ ह्रोंसए गधा दाना पिंब् बिसि नेंदों फैमा नेंदोंए सुँर खेंमैंए चाँदिए मुइ या म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","चइ आघें-अलिमैंने बिइ, “ङए चाँदिए मुइम् एमिंन उ तो जा? ङ्ह्‍योत्ति, चुर ङए नेंदोंए सुँर्न मुँ।” छ बिब् थेमा चमैंए सैंइ क्ल्ह्‍यो पिवाइ। चमैं ङ्हिंसि त्हारदै खें-खेंमैं न्होंर “परमेश्‍वरजी ङ्योने चु तो लगे?” बिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","झाइले चमैं कनान ह्‍युलर ह्रोंसए आबा याकूब ङाँर फेनेसि खेंमैंए फिर तबै ताँमैं ताँन् आबाने बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“च ह्‍युलर्बै क्ल्हेइ ङिने थेबै कैले पोंइ। चइ ङिने च ह्‍युलर्बै छैं लबर खब्मैं बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","दिलेया ‘ङिम् सोजो म्हिमैं ग। ङि छैं लबर खब्मैं आङिं,’ बिसि ङिइ बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","‘ङि ताँन् आबा घ्रिए च्हमैं ग। ङिए त्येमैं च्युसे ङ्हिं मुँल, च्योंब तोगो कनान ह्‍युलर आबाने बालु मुँ, अलि घ्रि आरे।’ ");
INSERT INTO gvr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“छबिमा च ह्‍युलर्बै क्ल्हेइ ङिने बिइ, ‘चु ताँउँइँले क्हेमैं सोजो म्हिमैं मुँन बिसि ङइ सेब्मुँ। क्हेमैंए आघें-अलिमैं न्होंर घ्रि चुर ङने वाथेंन्। अरू अंङ्गलर क्हेमैंए परवा फोदें आतरिगे बिसि म्‍ल्ह-नारिमैं किंसि ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","धै क्हेमैंए च्योंबै अलि चुर ङ ङाँर पखो। छ लस्याँ क्हेमैं छैं लबर खब्मैं आङिंन, सोजो म्हिमैं मुँन बिसि ङइ सेब्मुँ। धै ङइ क्हेमैंए अलि क्हेमैंए योर पिंस्यो। झाइले क्हेमैं चु ह्‍युलर छों लल् योंब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","छबिसि चमैंइ खेंमैंए नेंदोंमैं स्वालमा नेंदोंए सुँर चमैं ताँनए चाँदिए मुइ मुँन! छले नेंदोंर चाँदिए मुइ म्रोंसि चमैं नेरो चमैंए आबा ङ्हिंयाँइ। ");
INSERT INTO gvr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","चमैंए आबा याकूबइ चमैंने बिइ, “क्हेमैंइ ङए च्हमैं ङ ङाँइले प्हेंसि ङ बेल्‍ले न्हुँ खन् लइमुँ। योसेफ आरे, शिमियोन चर वाथेंइ तारे बेन्यामीन या बोल् म्हैइमुँ। छले ताँन् दुःखमैं ङए फिर्न तखइमुँ!” ");
INSERT INTO gvr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","दिलेया रूबेनइ ह्रोंसए आबाने बिइ, “बेन्यामीन ङए जिम्मार पिंन् ङइ च क्हि ङाँर्न एपखब्मुँ। बेन्यामीन क्हि ङाँर आपखस्याँ ङए च्ह ङ्हिं क्हिइ सैवाद्।” ");
INSERT INTO gvr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","दिलेया याकूबइ बिइ, “ङए च्ह क्हेमैंने ह्‍यारिब् आरे! तलेबिस्याँ चए आघें सियाइ तारे चु घ्रि चैमुँ। छतसि क्हेमैंइ बोम् बिबै क्ल्ह्‍योर चए फिर तोइ आछ्याँब तखइ बिस्याँ ङ खेब् तसि क्र सारयाबै त्हेर शोकने बालु क्रोंर सथेंनेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","कनान ह्‍युलर ङ्हिंन् ङ्हाँबै अँङ्गल् तल। ");
INSERT INTO gvr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","मिश्रउँइँले पखबै म्‍ल्ह-नारिमैं चमैंइ चल् खाँल छतमा चमैंए आबाइ चमैंने “ङ्योए ल्हागिरि च्हौदे म्‍ल्ह-नारिमैं किंबर धबै ह्‍याद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","आबाइ छबिमा योसेफए आघें यहूदाइ चने बिइ, “‘क्हेमैंए अलि क्हेमैंने बालु आपखस्याँ ङए उँइँर खल् योंरिब् आरे!’ बिसि च म्हिइ ङिने बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","छतसि ङिए अलि ङिने बालु क्हिइ कुलस्याँ ङि ह्‍यासि क्हिए ल्हागिर म्‍ल्ह-नारिमैं किंसि पखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","चलाइ आकुलस्याँ ङि या आह्‍या। तलेबिस्याँ ‘क्हेमैंए अलि क्हेमैंने बालु आपखस्याँ क्हेमैं ङए ङाँर खल् योंरिब् आरे,’ बिसि च म्हिइ बिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","छबिमा याकूबइ (इस्राएलइ) बिइ, “क्हेमैंल अर्को अलि या मुँ बिसि च म्हिने बिइरि ङए फिर क्हेमैंइ तले छाबै न्हुँ तल् पिंल?” ");
INSERT INTO gvr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","चमैंइ बिइ, “च म्हिइ ङ्योए परवाए बारेर ङ्योएब्-च्वेब् लसि ‘क्हेमैंए आबा सोगोंन् मुँ वा? क्हेमैंल अरू अलि या मुँ वा?’ बिसि ङ्योएइ। छले ङ्योएमा ‘अँ, ङिल अलि घ्रि मुँ,’ बिसि ङिइ बिल् त्हुइ। चइ ‘क्हेमैंए अलि चुर पखो’ बिब्मुँ बिसि ङिइ खैले सेब्दि?” ");
INSERT INTO gvr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","झाइले यहूदाइ आबाने बिइ, “बेन्यामीन ङने बालु कुलमिंन् क्हिइ च ङिने बालु कुलस्याँ ङि ह्‍याब्मुँ। धै ङ्यो नेरो ङ्योए प्हसेमैं चल् आयोंसि सिल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","चुए जिम्मा ङ तइ। ङइ च खैले बिलै क्हि ङाँर एपखस्यो। ङइ चु एसि क्हिए ओंसों आथेंस्याँ ङ खोंयोंन् बिलै या क्हिए उँइँर छ्याब् मुँबन् ठर्दिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ङ्योइ क्हैल् आलस्याँ ङ्यो ङ्हिखे समा ह्‍याब-खब लल् खाँमल।” ");
INSERT INTO gvr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","झाइले चमैंए आबाइ चमैंने बिइ, “छ आलै आत बिस्याँ छ लद्: चु ह्‍युलर्बै छ्याँ-छ्याँबै सैमैं, लिंबै थाँ खबै फोबै छ्युगु, च्हौदे, क्वे खुदु, छ्याँबै मसला, मुर्रा, पेस्ता नेरो बदाम च म्हिए ल्हागिरि क्हेमैंए नेंदोंर झोंसि बोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","क्हेमैंइ चाँदिए मुइ या दोब्बर बोसि ह्‍याद्। तलेबिस्याँ ओंसोंबै मुइ या क्हेमैंए नेंदोंए सुँर फेखल। म्‍लेयासि क्हेमैंए नेंदोंर फेखलै। च मुइ एवाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ह्रोंसए अलि या किंसि धबै च म्हि ङाँर ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","क्हेमैंए अर्को अलि नेरो बेन्यामीन फ्रेपखबै ल्हागिर च म्हिए उँइँरि तोन्दोंरि सै लल् खाँबै परमेश्‍वरजी क्हेमैंए फिर ल्हयो खरिगे। ङ प्हसे आरेब् तयाम् बिलेन तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","झाइले चमैंइ ह्रोंमैं-क्होल्सै, दोब्बर चाँदिए मुइ नेरो बेन्यामीन किंसि मिश्रउँइँ ह्‍याइ, धै योसेफए ओंसों राइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","योसेफइ चमैंने बालु बेन्यामीन म्रोंसि ह्रोंसए धिंर्बै के लब्मैंए चिबने बिइ, “चु म्हिमैं ङए धिंर बोदु, धै क्यु साँडे घ्रि सैसि कैं-ट्हा ह्‍योद्। चु म्हिमैं तिंयाँ त्हिंयाँर ङने बालुन् चब् चब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","योसेफइ लद् बिब् धोंलेन् च चिबइ लइ। धै च म्हिमैं योसेफए धिंर पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","छले योसेफए धिंर पखमा योसेफए आघेंमैं ङ्हिंसि खें-खेंमैंन् बिइ, “ओंसोंबै लार ङ्योए नेंदोंर एमिंबै चाँदिए मुइइ लमा ङ्यो चुर खल् त्हुब् ग। तारे चइ ङ्योने निउँ म्हैसि ङ्यो ह्रोंसए केब्छैं लवाब्मुँ। धै ङ्योए गधामैं या प्हेंसि किंवाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","छतसि चमैंइ योसेफए धिंर्बै के लबै चिबने म्रार ह्‍यासि बिइ, ");
INSERT INTO gvr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“ओ चिब, ओंसों या ङि म्‍ल्ह-नारिमैं किंबर खल। ");
INSERT INTO gvr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","धिंर एह्‍यामा बास टिबै क्ल्ह्‍योर फेसि ङिए नेंदों प्ल्हमा ङिइ नेंदोंमैंए सुँर ङिए चाँदिए मुइ म्रोंइ। दिलेया ङिइ चु मुइ एपखइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ङिए नेंदोंर ङिए चाँदिए मुइ खाबइ झोंमिंइ च ङिइ आसे। तोगो म्‍ल्ह-नारिमैं किंबर अर्को मुइ या ङिइ पखइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","चिबइ बिइ, “क्हेमैं न्हुँ आलद्, आङ्हिंन्। क्हेमैंए परमेश्‍वर, क्हेमैंए आबाए परमेश्‍वरजीन् च मुइ क्हेमैंए नेंदोंर थेंमिंलै। क्हेमैंइ बोबै म्‍ल्ह-नारिए सैम् ङइ योंल।” च्हौ बिसि चइ शिमियोन झेलउँइँले चमैं ङाँर पखइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","च म्हिइ चमैं योसेफए धिं न्होंर बोसि खेंमैंए प्हले ख्रुबर क्यु पिंइ, धै चमैंए गधामैं या चबै सैमैं नेरो क्यु पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","झाइले त्हिंइ आधार योसेफने त्होनेब् बिसि खेंमैंइ पखबै क्होल्सैमैं छेइ, तलेबिस्याँ चिबइ कैं चर्न चब्मुँ बिसि चमैंने बिल। ");
INSERT INTO gvr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","योसेफ धिंर खबै लिउँइँ चमैंइ खेंमैंइ पखबै क्होल्सैमैं योसेफलाइ पिंसि यो छ्युँ लसि फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","योसेफइ चमैंने ताँमैं ङ्योलु-च्युलु लदै “क्हेमैंए खेब् तयाबै आबा सबन् मुँ वा? च तोगो सोगोंन् मुँ वा?” बिसि ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","चमैंइ बिइ, “क्हिए केब्छैं, ङिए आबा सबन् मुँ, तिंयाँ समा सोरिइमुँ,” बिदै कुरसि चलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","योसेफइ ङ्ह्‍योमा ह्रोंसए अलि ह्रोंसए आमाइ फिबै च्ह बेन्यामीन म्रोंसि बिइ, “क्हेमैंइ ङने बालु ताँ लबै क्हेमैंए च्योंबै अलि चुन् वा?” धै योसेफइ चने बिइ, “ओ आच्यों, परमेश्‍वरए दयाम्हाँया क्हिए फिर तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ह्रोंसए अलि म्रोंमा चए सैंर बेल्‍ले म्हाँया खसि क्रोदा ङ्हाँसि योसेफइ युन्ले क्रोबै क्ल्ह्‍यो म्हैइ। धै च रोबै क्ल्ह्‍योर ह्‍यासि क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","तिस्याँदे लिउँइँ लि ख्रुसि आक्रोब्धों ब्योंन्ले बैरु युसि चब् लब्मैंने बिइ, “तारे चब् पखो।” ");
INSERT INTO gvr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","झाइले चब् लब्मैंइ योसेफए ल्हागिर स्योले, आघें-अलिमैंए ल्हागिर स्योले धै चने बालु चबै अरू मिश्रीमैंए ल्हागिर स्योले कैं थेंइ, तलेबिस्याँ मिश्रीमैंइ हिब्रूमैंने बालु क्हुँसि चब् चब आतमल। छ लस्याँ मिश्रीमैंल मिं ह्‍यामल। ");
INSERT INTO gvr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","थेबउँइँले च्योंब समा ह्रों-ह्रोंसए उमेर अनुसार योसेफइ चमैं क्हुँल् पिंल। छले क्हुँमिंब् म्रोंसि चमैं प्लेटोयासि घ्रिइ घ्रिलाइ ङ्ह्‍योबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","चमैंए भाउ योसेफए टेबलउँइँले ट्हुइसि बोल। दिलेया बेन्यामीनए भाउ चमैं ताँनल् भन्दा ङ्‍हबाँ ल्हें मुँल। छले चमैंइ योसेफने बालु चब् थुँब् लसि सैं तोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","च लिउँइँ योसेफइ ह्रोंसए धिंर्बै के लबै चिबने बिइ, “चमैंइ बोल् खाँबै म्‍ल्ह-नारिमैं चमैंए नेंदोंर झोंमिंन् धै चमैंए चाँदिए मुइ या चमैंए नेंदोंए सुँर थेंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","झाइले ङए चाँदिए प्ह्‍येल नेरो म्‍ल्ह-नारिमैं किंब् बिसि चमैंइ पखबै चाँदि बालु लसि च्योंबए नेंदोंए सुँर झोंमिंन्।” छबिमा योसेफइ बिब् धोंलेन् चइ लइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","प्हँन्हाँग्धों न्हाँगर्न योसेफइ ह्रोंसए आघें अलिमैं खेंमैंए गदामैंने बालुन् कुलमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","चमैं सहरउँइँले दे क्याइ फेनेबै लिउँइँ योसेफइ केब्छैंमैं न्होंर्बै चिबने बिइ, “क्हि युन्ले च म्हिमैंए लिलि ह्‍यादु, धै चमैंने त्होसि ‘ङिइ छेन् लना लन् क्हेमैंइ ङिए न्होह्रों तले लल? बिद्। ");
INSERT INTO gvr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ङए क्ल्हेए चाँदिए प्ह्‍येल तले पखल? चु प्ह्‍येलर्न ङए क्ल्हेइ थुँबै सैमैं थुँम्, धै च प्ह्‍येलउँइँलेन् चइ छ्याँब्-आछ्याँब फेलम् चु क्हेमैंइ बेल्‍ले आछ्याँबै के लइ।’” ");
INSERT INTO gvr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","च के लबै चिबइ चमैंने त्होबै लिउँइँ क्ल्हेइ खै बिल छान् बिमा ");
INSERT INTO gvr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","चमैंइ के लबै चिबने बिइ, “ओ चिब, तले छाबै ताँ लल? छाबै के क्हिए केब्छैंमैंइ खोंयोंइ आल। ");
INSERT INTO gvr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ङिए नेंदोंमैंए सुँर ओंसों योंबै चाँदि ङिइ कनान ह्‍युलउँइँले एसि चुर पखइ, आङिं वा? ङिइ खैले क्हिए क्ल्हेए धिंउँइँले चाँदि नेरो मारा ह्‍योमल? ");
INSERT INTO gvr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","क्हिए केब्छैंमैंए न्होंर खाब्ने च प्ह्‍येल स्यामुँ च सैवाद्। धै ङि या क्हिए केब्छैंमैं तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","च चिबइ बिइ, “तम्, क्हेमैंइ बिब् धोंन् तरिगे। दिलेया खाब्ने बालु च प्ह्‍येल स्यामुँ च ङए केब्छैं तब्मुँ। अरूमैं बिस्याँ छ्याब् मुँब तरिब् आरे, चमैं ह्‍याल् खाँम्।” ");
INSERT INTO gvr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","छबिमा ताँनइ युन्ले ह्रों-ह्रोंसए नेंदों सर थेंसि प्ल्हइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","झाइले च चिबइ थेब्मैंए नेंदोंउँइँले म्हैबै तों लमा च प्हेल बेन्यामीनए नेंदोंर योंइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","छतमा चमैं सैं नसि ह्रोंसए क्वें ट्होइ। धै गदामैं फिर ति थेंसि सहरउँइँ एखइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","यहूदा नेरो चए आघें-अलिमैं योसेफए धिंर फेखमा च चर्न मुँल। धै चमैंइ चए ओंसों खसि फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","योसेफइ चमैंने बिइ, “क्हेमैंइ छाबै के तले लल? आसेल्‍ले लबै के ङ धों तबै म्हिइ सेम् बिसि क्हेमैंइ आसेल् वा?” ");
INSERT INTO gvr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","यहूदाइ बिइ, “ङिइ क्हिने तो बिब, चु ताँर ङिइ खैले आङिं बिल् खाँमुँ? क्हिए केब्छैंमैंए आछ्याँबै केमैं परमेश्‍वरजी उँइँमिंइमुँ। तारे नेंदोंर च प्ह्‍येल स्याबै म्हि मत्‍त्रे आङिं, ङि ताँन् क्हिए केब्छैंमैं तइ।” ");
INSERT INTO gvr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","दिलेया योसेफइ बिइ, “ङ ङाँइले छाबै के खोंयोंइ तरिब् आरे। नेंदोंर च प्ह्‍येल स्याबै म्हि मत्‍त्रे ङए केब्छैं तब्मुँ। छतसि क्हेमैं छिं ङ्हाँन्ले ह्रोंसए आबा ङाँर सैं तोंदै ह्‍याद्।” ");
INSERT INTO gvr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","दिलेया यहूदा योसेफए उँइँर ह्‍यासि बिइ, “ओ ङए प्रभु, ङ यो छ्युँ लमुँ क्हिए केब्छैंइ ताँ घ्रि बिल् पिंन्। क्हि म्रुँ धों तबै थेबै म्हि ग दिलेया क्हिए केब्छैंने बालु ह्रिस आखमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","क्हिइ ह्रोंसए केब्छैंमैंने ‘क्हेमैंल आबा नेरो अरू अलि या मुँ वा?’ बिसि ङ्योएल ");
INSERT INTO gvr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","छतसि ङिइ क्हिने बिइ, ‘ङिए आबा खेब् तयाइमुँ। च खेब् तयाबै त्हेर्बै कोलो ङिल अलि च्योंब घ्रि मुँ। चए आघें सियाल् खाँइ। चए आमाउँइँले फिब तारे च घ्रि मत्‍त्रे मुँ। छतसि आबाइ चलाइ बेल्‍ले खोम्।’ ");
INSERT INTO gvr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“छबिमा क्हिइ ह्रोंसए केब्छैंमैंने ‘च चुर ङ ङाँर पखो, ङइ ङ्ह्‍योम्,’ बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","‘च कोलोइ ह्रोंसए आबा वाथेंल् आखाँ। चइ ह्रोंसए आबा वाथेंइ बिस्याँ चए आबा सियाब्मुँ,’ बिसि ङिइ क्हिने बिल। ");
INSERT INTO gvr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","दिलेया क्हिइ ङिने बिइ, ‘क्हेमैंए च्योंबै अलि क्हेमैंने बालु आपखस्याँ क्हेमैं धबै ङए ओंसों राल् योंरिब् आरे।’ ");
INSERT INTO gvr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“छतसि ङि ङिए आबा ङाँर ह्‍यासि क्हिइ बिबै ताँमैं चने बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","छबिमा ङिए आबाइ बिइ, ‘धबै ह्‍यासि च्युगुदे म्‍ल्ह-नारिमैं किंइ पखो।’ ");
INSERT INTO gvr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","छबिमा ‘ङि ह्‍याल् आखाँ। ङिए च्योंबै अलि ङिने बालु कुलस्याँ ङि ह्‍याब्मुँ। ङिए च्योंबै अलि ङिने बालु आकुलस्याँ ङि च म्हिए उँइँर ह्‍याल् योंरिब् आरे,’ बिसि ङिइ चने बिल। ");
INSERT INTO gvr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“छबिमा ङिए आबाइ ङिने बिइ, ‘ङए प्ह्रेंस्यो राहेलउँइँले च्ह ङ्हिं तब क्हेमैंइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","चमैं न्होंरि च्ह घ्रिइ ङलाइ वाथेंइ। च त्हेसेरो ङइ चलाइ आम्रोंइमुँ, धै क्ह्रोंसेंन्लेन् क्ह्‍योंर्बै सिंहमैंइ चलाइ चवासि ङए च्ह च्यता-चिति लवालै। ");
INSERT INTO gvr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","चु च्योंबै या क्हेमैंइ ङ ङाँइले बोसि चए फिर तोइ तयास्याँ ङए चु सारयाबै क्र शोकने बालुन् क्रोंर सथेंनेब्मुँ।’ ");
INSERT INTO gvr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“छतसि ङि ङिए आबा ङाँर फेनेमा ङिने बालु चु कोलो आम्रोंसि आत। तलेबिस्याँ चु कोलो ङ्ह्‍योसिन् च सोरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","छतसि ङिने बालु चु कोलो आम्रोंबै तोदोंन् च सियाब्मुँ। ङि क्हिए केब्छैंमैंइ क्र सारयाबै ङिए आबा शोकने बालुन् क्रोंर सनेल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","च्हौ मत्‍त्रै आङिं! क्हिए च्ह ङए अलि खैलसे या क्हि ङाँर एपखस्यो बिसि ङइ आबाने बिथेंइमुँ। ‘ङइ चु कोलो क्हि ङाँर एइ आपखस्याँ ङए छ्ह तिगोंन् ङ क्हिए ओंसों छ्याब् मुँबन् तरिब्मुँ।’ ");
INSERT INTO gvr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“छतसि चिब, ङ क्हिने यो छ्युँ लमुँ चु कोलोए क्ल्ह्‍योर ङ क्हिए केब्छैं तल् पिंन्। धै चु कोलो चए आघेंमैंने बालु धिंर एह्‍याल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","तलेबिस्याँ चु कोलो ङने बालु आबोल्‍ले ङए आबा ङाँर ङ खैले ह्‍याब? ङए आबाए फिर दुःख तब ङइ ङ्ह्‍योल् आखाँ।” ");
INSERT INTO gvr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","छबिमा ह्रोंसए ङाँर रारिबै ताँन् केब्छैंमैंए ओंसों सैं फैल् आखाँसि योसेफइ ओरसि “ताँन् म्हिमैं छुइले बैरु कुलमिंन् बिइ।” छबिमा चर मुँबै म्हिमैं ताँन् बैरु ह्‍याइ। छतमा योसेफइ ह्रोंसए आघें-अलिमैंने ह्रोंसलाइ ङो सेमिंमा चर अरू खाबै आरेल। ");
INSERT INTO gvr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","छतसि च थेबै कैले क्रोइ, धै च क्रोब मिश्रीमैंइ थेइ। धै फारोए परवाज्यै या चु ताँ सेइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","योसेफइ ह्रोंसए आघें-अलिमैंने बिइ, “ङ योसेफ ग। ङए आबा अझै सोगोंन् मुँ वा?” छबिमा आघेंमैं चने ङ्हिंसि तोइ बिल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","छतसि योसेफइ ह्रोंसए आघें-अलिमैंने “गार आम्हाँदिल्‍ले ङ ङाँर खो!” बिइ। चमैं च ङाँर खबै लिउँइँ चइ बिइ, “क्हेमैंइ मिश्रर चुँवाबै क्हेमैंए अलि ङन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","क्हेमैंइ ङलाइ चुँवाबै ताँर क्हेमैं न्हुँ आलद्। ह्रोंसए फिरै या ह्रिस आलद्। तलेबिस्याँ म्हिमैं जोगेमिंबै ल्हागिर परमेश्‍वरजी क्हेमैं भन्दा ङ ओंसों चुर कुलब् ग। ");
INSERT INTO gvr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ह्‍युलर अँङ्गल् तब तोगो ङ्हिदिं तइ। अझै ङ्‍हदिं समा खनिरै ताब-क्ह्‍योब् तरिब् आरे, म्‍ल्ह-नारिमैं या खुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","दिलेया क्हेमैंए ल्हागिर भाग घ्रि पृथ्‍बीर जोगेसि थेंबर नेरो क्हेमैंए न्होंर्बै ल्हें म्हि जोगेमिंरिगे बिसि परमेश्‍वरजी क्हेमैं भन्दा ओंसों ङलाइ चुर कुलब् ग। ");
INSERT INTO gvr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","छतसि ङलाइ चुर कुलब क्हेमैंइ आङिं, परमेश्‍वरजीन् ग। खीजी फारोए क्ल्ह्‍योर ङ थेंमिंइमुँ धै चए परवार्बै चिब लमिंसि मिश्र ह्‍युलर्बै चिब लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","तारे युनन् ङए आबा ङाँर ह्‍यासि ‘परमेश्‍वरजी ङलाइ मिश्र ह्‍युल तिगोंर्बै क्ल्हे लमिंइमुँ, बिसि क्हिए च्ह योसेफइ बिइमुँ। छतसि क्हैल् आलल्‍ले ङ ङाँर खो! ");
INSERT INTO gvr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","क्हि गोशेन ह्‍युलर टिब्मुँ। क्हि नेरो क्हिए प्हसेमैं, क्हिए क्वें-क्वेंमिमैं, क्हिए खेदोमैं नेरो क्हिने मुँबै तोन्दोंरि सै ङए ङाँर्न तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","चर क्हिए चब-थुँब ङइ ङ्ह्‍योब्मुँ। तलेबिस्याँ अँङ्गल् अझै ङ्‍हदिं चैमुँ। आस्याँ क्हि, क्हिए परवार नेरो क्हिने बालु मुँब्मैं ताँन् फोदेन् तयाब्मुँ,’ बिसि ङए आबाने बिद। ");
INSERT INTO gvr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“क्हेमैंने बालु पोंब ङ योसेफन् ग बिसि क्हेमैं नेरो ङए अलि बेन्यामीनज्यै या म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","मिश्र ह्‍युलर ङइ कति थेबै मिं योंइमुँ क्हेमैंइ तो तो म्रोंइमुँ च ताँन् ताँ ङए आबाने खैलसेया बिद्, धै युनन् ङए आबा चुर पइ खो।” ");
INSERT INTO gvr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ह्रोंसए अलि बेन्यामीनए खरिर अँगालो झोंसि च बेल्‍ले क्रोइ, छलेन बेन्यामीन या चलाइ क्हासि क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","चइ ह्रोंसए ताँन् आघेंमैं या म्वें लसि चमैंने बालु क्रोइ। च लिउँइँ ह्रोंसए आघेंमैं खीने बालु ताँमैं सेबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","योसेफए आघें-अलिमैं खइमुँ बिबै ताँ फारो नेरो चए चिब्मैंज्यै थेइ, धै चमैं या बेल्‍ले सैं तोंइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","फारो म्रुँइ योसेफने बिइ, “‘क्हेमैं ह्रोंसए गधामैं ति नोमिंसि कनान ह्‍युलर ह्‍याद्,’ बिसि क्हिए आघें-अलिमैंने बिद्। ");
INSERT INTO gvr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","‘धै क्हेमैंए आबा नेरो क्हेमैंए परवार्बै ताँन् म्हिमैं किंसि ङ ङाँर खोरिगे। मिश्रर्बै ताँन् भन्दा छ्याँबै क्ल्ह्‍यो ङइ क्हेमैंलाइ पिंब्मुँ, धै क्हेमैंइ चु ह्‍युलर्बै ताँन् भन्दा छ्याँबै रा-रोमैं चब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","क्हेमैंए म्रिं-प्हसेमैंए ल्हागिरि मिश्रउँइँले गाडामैं बोयाद्। धै क्हेमैंए आबा किंसि खो!’ बिसेया चमैंने बिद्। ");
INSERT INTO gvr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","‘मिश्रर्बै ताँन् छ्याँ-छ्याँबै सैमैं क्हेमैंलन् ग। छतसि क्हेमैंए समनमैंए न्हुँ आलद्।’” ");
INSERT INTO gvr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","याकूबए (इस्राएलए) च्हमैंइ छान् लइ। फारोइ बिब् धोंलेन् योसेफइ चमैंलाइ गाडामैं नेरो घ्याँर चैदिबै सैमैं ताँन् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","चइ चमैं ताँनलाइ खिबै छारा क्वेंमैं पिंइ। दिलेया बेन्यामीनलाइ बिस्याँ चाँदिए मुइ सोंब्ब्र नेरो खिबै छारा क्वें ङ्‍हजोर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","ह्रोंसए आबाए ल्हागिरि चइ मिश्रर्बै छ्याँ-छ्याँबै सैमैं ति च्युउँलो लसि गधामैंए फिर तेंमिंइ, धै ह्रोंसए आबाए ल्हागिर घ्याँर चबै सैमैं, क्हें नेरो म्‍ल्ह-नारिमैं ति च्युउँलो लसि गदा आमाए फिर तेंमिंसि चमैं कुलइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","छले चइ ह्रोंसए आघें-अलिमैं कुलमा “क्हेमैं घ्याँर प्होंब नेब आलद् ओ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","छले चमैं मिश्रउँइँले कैंडो कनान ह्‍युलर खेंमैंए आबा याकूब ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","धै आबाने बिइ, “योसेफ तोगो समा सोगोंन् मुँन, मिश्र ह्‍युलर्बै थेबै म्हि या चन् मुँन।” च ताँ थेसि याकूब प्लेटोयासि चमैंए ताँ आक्वें। ");
INSERT INTO gvr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","दिलेया योसेफइ चमैंने बिमिंबै ताँमैं थेबै लिउँइँ धै ह्रोंसलाइ किंबर योसेफइ कुल्मिंबै गाडामैं म्रोंबै लिउँइँ याकूबए सैं चिइ धै चमैंए ताँ क्वेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","झाइले याकूबइ बिइ, “ङए च्ह योसेफ तोगो समा सोगोंन् मुँन। च्हौ तसेरो ङलाइ तइ। ङ ह्‍याब्मुँ धै ङ सिब् भन्दा ओंसों चलाइ ङ्ह्‍योब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","याकूब (इस्राएल) ह्रोंसने मुँबै तोन्दोंरि सै किंसि प्रइ, धै बेर्शेबार खसि ह्रोंसए आबा इसहाकए परमेश्‍वरए मिंर ख्रो पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","च म्हुँइँसर परमेश्‍वर याकूबने दर्शनर पोंसि “याकूब, याकूब” बिसि चलाइ हुइइ। धै याकूबइ “ङ चुर्न मुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","खीजी बिइ, “ङ परमेश्‍वर क्हिए आबाए परमेश्‍वर ग। मिश्र ह्‍याबर आङ्हिंन् चर ङइ क्हिउँइँले थेबै ह्रें घ्रि बनेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","क्हिने बालु ङ मिश्रर ह्‍याब्मुँ, धै क्हिलाइ खैले बिलेन ङइ धबै एसि पखब्मुँ। धै क्हि सिमा योसेफए योइ क्हिए मि हुमिंब्मुँ। धै ह्रोंसए यो क्हिए मिर थेंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","च लिउँइँ याकूब बेर्शेबाउँइँले ह्‍याइ। फारो म्रुँइ चलाइ पखबर गाडामैं कुल्मिंमा याकूबए च्हमैंइ ह्रोंसए आबा, प्हसेमैं नेरो परवामैं च गाडामैंर झोंसि बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ह्रोंसए खेदोमैं नेरो कनान ह्‍युलर खागु लबै सैमैं किंसि याकूब नेरो चए ताँन् परवा मिश्रर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","याकूबइ ह्रोंसने बालु ह्रोंसए च्हमैं-च्हमिमैं क्वें क्वेंमिमैं ताँन् मिश्रर बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","मिश्रर ह्‍याबै याकूबए च्हमैंए मिंमैं चुन् ग: याकूबए च्ह थेब रूबेन मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","रूबेनए च्हमैं, हानोक, पल्‍लु, हेस्रोन नेरो कर्मि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","शिमियोनए च्हमैं: यमूएल, यामिन, ओहद, याकिन, सोहोर नेरो कनानी प्ह्रेंस्योउँइँबै च्ह सों मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","लेबीए च्हमैं: गेर्शोन, कहात नेरो मरारि। ");
INSERT INTO gvr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","यहूदाए च्हमैं: एर, ओनान, शेलह, फारेस नेरो जेरह मुँल, दिलेया एर नेरो ओनान कनान ह्‍युलर्न सियाल। फारेसए च्हमैं हेस्रोन नेरो हामूल मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","इस्साखारए च्हमैं: तोला, पुवा, याशूब नेरो शिम्रोन मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","जबूलूनए च्हमैं: सेरेद, एलोन नेरो यहलेल मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","चुमैं याकूबउँइँले लेआइ पद्दन-आरामर फिबै च्हमैं नेरो चए च्हमि दीना या मुँल। लेआउँइँले याकूबए सन्तानमैं ताँन् लसि सोंच्युसे सों मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","गादए च्हमैं: सेफोन, हाग्‍यि, शूनि, यसबोन, एरि, अरोदि नेरो अरेलि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","‍आशेरए च्हमैं यिम्ना, यिश्‍वा, यिश्‍वि नेरो बरिआ नेरो चमैंए अङाँ सेरह मुँल। बरिआए च्हमैं हेबेर नेरो मल्कीएल मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","लाबानइ ह्रोंसए च्हमि लेआने पिंबै केब्स्यो जिल्पाइ फिबै याकूबए सन्तानमैं चुमैं मुँल। चुमैं ताँन् लसि च्युसे ट्हु म्हिमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","याकूबए प्ह्रेंस्यो राहेलए च्हमैं: योसेफ नेरो बेन्यामीन मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","योसेफए च्हमैं मनश्शे नेरो एफ्राइम ओनए खेगि पोतिपेराए च्हमि आसनतउँइँले मिश्रर फिल। ");
INSERT INTO gvr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","बेन्यामीनए च्हमैं बेला, बेकेर, अश्बेल, गेरा, नामान, एहि, रोश, मुप्पिम, हुप्पिम नेरो आर्द मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","चुमैं राहेलउँइँले फिबै याकूबए सन्तानमैं मुँल। चुमैं ताँन् लसि च्युसे प्लि म्हिमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","दानए च्ह: हुशिम मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","नप्‍तालीए च्हमैं: यहसेल, गुनि, येसेर, नेरो शिल्‍लेम मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","लाबानइ ह्रोंसए च्हमि राहेललाइ पिंबै केब्स्यो बिल्‍हाइ याकूबउँइँले फिबै सन्तानमैं चुमैंन् मुँल। चुमैं ताँन् लसि म्हि ङि मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","चए चोंमैं आच्योल्‍ले याकूबने बालु मिश्रर ह्‍याबै चए ताँन् सन्तानमैं ट्हुच्युसे ट्हु मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","मिश्रर फिबै योसेफए च्हमैं ङ्हिं मुँल। मिश्रर खबै याकूबए धिंर्बै परवार ताँन् लसि म्हि ङिच्यु मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","“गोशेन ह्‍याबै घ्याँ उँइँमिंन्” बिसि याकूबइ यहूदालाइ योसेफ ङाँर ओंसों कुलइ। धै चमैं गोशेनर फेनेमा ");
INSERT INTO gvr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","योसेफइ के लब्मैंने ह्रोंसए रथ तेबर ल्हैदिइ। धै गोशेन समा ह्रोंसए आबा याकूबने त्होबर ह्‍याइ। धै आबालाइ म्रोंबै तोदोंन् योसेफ आबाने अँखलो ख्वेसि क्रोबै क्रोबन् तइ। ");
INSERT INTO gvr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","याकूबइ योसेफने बिइ, “क्हिए लि म्रोंल् योंसि क्हि सोगों मुँब ङइ सेइ। छतसि तारे ङ सन्तोकले सिल् खाँब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","योसेफइ ह्रोंसए आघें-अलिमैं नेरो ह्रोंसए आबाए परवाने बिइ, “‘कनान ह्‍युलर्बै ङए आघें-अलिमैं नेरो ङए आबाए परवामैं ङ ङाँर खइमुँ बिसि तारे ङ ह्‍यासि फारोने बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","चमैं ताँन् खेदोमैं न्हबै प्ह्रोंछैंमैं ग। छतसि चमैंइ ह्रोंसए ताँन् बगालमैं नेरो चमैंने मुँबै तोन्दोंरि सै किंसि खइमुँ।’ ");
INSERT INTO gvr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","धै फारो म्रुँइ क्हेमैं हुइसि ‘क्हेमैंइ तो के लमुँ?’ बिसि ङ्योएब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","छले ङ्योएमा ‘क्हिए केब्छैंमैं ङि आबा-च्हमैं ताँन् कोलोउँइँले तोगो समा खेदोमैं न्हब्मैं ग,’ बिद्। छ बिस्याँ क्हेमैं गोशेनर टिल् योंब्मुँ। तलेबिस्याँ मिश्रीमैं ताँनइ प्ह्रोंछैंमैंलाइ हेल् लम्।” ");
INSERT INTO gvr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","झाइले योसेफ फारो ङाँर ह्‍यासि बिइ, “ङए आबा नेरो आघें-अलिमैं चमैंए र-क्युमैं, म्येमैं नेरो चमैंए तोन्दोंरि सै किंसि कनान ह्‍युलउँइँले खइमुँ। चमैं तोगो गोशेन ह्‍युलर मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","छ बिसि योसेफइ ह्रोंसए आघेंमैं न्होंउँइँले म्हि ङ्‍ह किंसि फारो ङाँर त्होबर बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","योसेफए आघेंमैंने “क्हेमैंइ तो केमैं लमुँ?” बिसि फारोइ ङ्योएइ। चमैंइ फारोने बिइ, “ङि क्हिए केब्छैंमैं ङिए खेमैं-मामैं ओंनोंन् प्ह्रोंछैंमैं ग। ");
INSERT INTO gvr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","कनान ह्‍युलर बेल्‍ले थेबै अँङ्गल् तबइले क्हिए केब्छैंमैंइ र-क्यु छबै क्ल्ह्‍यो आयों। छतसि ङि चु ह्‍युलर्न टिबर खइमुँ। यो छ्युँ लमुँ ङि क्हिए केब्छैंमैंइ गोशेन ह्‍युलर टिल् योंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","झाइले फारोइ योसेफने बिइ, “क्हिए आबा नेरो आघें-अलिमैं क्हि ङाँर खना। ");
INSERT INTO gvr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","मिश्र ह्‍युल क्हिए योर्न मुँ। चु ह्‍युलर्बै ताँन् भन्दा छ्याँबै क्ल्ह्‍योर क्हिए आबा नेरो आघें-अलिमैं टिल् पिंन्। चमैं गोशेन ह्‍युलर्न टिल् पिंन्। धै चमैं न्होंर सिपालु म्हिमैं मुँस्याँ चमैंए जिम्मार ङए खेदोमैं या कुल्मिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","च लिउँइँ योसेफइ ह्रोंसए आबा याकूबलाज्यै या फारोने त्होबर बोइ। छले त्होमा याकूबइ फारोए फिर आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","फारोइ याकूबने “क्हि कति बर्ष तइ?” बिसि ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","याकूबइ बिइ, “ङइ तोगो समा थोबै छ्ह प्रसे सोंच्यु तइ। ङए छ्ह रिन्ठि नेरो दुःखर थोरिइमुँ। ङए खेमैं ल्हें सोल चमैं सोब्द प्रे छ्ह तोगो ङल आयोइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","याकूबइ धबै फारोलाइ आशिक पिंसि फारोउँइँले त्होंसि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","झाइले फारोइ बिब् धोंलेन् योसेफइ ह्रोंसए आबा नेरो आघें-अलिमैंलाइ मिश्रर्बै ताँन् भन्दा छ्याँब रामसेस बिबै ह्‍युलर चमैं क्ल्हे तबर क्ल्ह्‍योमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","योसेफइ ह्रोंसए आबा आघें-अलिमैं नेरो ह्रोंसए आबाए परवा ताँनलाइ चमैंए प्हसेमैं कति मुँ च ङ्‍ह्‍योसि चबै सैमैं या पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","बेल्‍ले थेबै अँङ्गल् तबइले ह्‍युलर चबै सैमैं तोइ आरेल। अंङ्गलइ लमा मिश्र नेरो कनान ह्‍युल ङ्हिंर्बै म्हिमैं चल् आयोंल। ");
INSERT INTO gvr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","मिश्र नेरो कनान ह्‍युलर्बै म्हिमैंने म्‍ल्ह-नारिमैं चुँसि योंबै मुइ ताँन् योसेफइ खागु लसि फारोए दरबारर थेंल। ");
INSERT INTO gvr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","च त्हेर मिश्र नेरो कनान ह्‍युलर्बै म्हिमैंए मुइ ताँन् म्‍ल्ह-नारिमैं किंसि खाँयाल। छतसि मिश्रीमैं ताँन् योसेफ ङाँर खसि बिइ, “ङिलाइ धबै म्‍ल्ह-नारिमैं पिंन्। क्हि मुँन-मुँन् क्हिए उँइँर्न ङि खैले सिब? ङिने मुँबै मुइ ताँन् खाँयाइ।” ");
INSERT INTO gvr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","योसेफइ चमैंने बिइ, “क्हेमैंए मुइ खाँयास्याँ खेदोमैं पखो। क्हेमैंए खेदोमैंए साटोर ङइ म्‍ल्ह-नारिमैं पिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","योसेफइ बिब् धोंलेन् चमैंइ खेंमैंए खेदोमैं योसेफ ङाँर पखइ। धै योसेफइ चमैंए घोडा, क्यु, म्ये, गधामैंए साटोर चमैंलाइ म्‍ल्ह-नारिमैं पिंसि ल्होइ। च सालर चइ खेदोमैंए साटोर चमैंलाइ म्‍ल्ह-नारिमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","च बर्ष खाँसि क्हुरिंम्बै सालरै या धबै चमैं खसि योसेफने बिइ, “ङिए मुइ ताँन् खाँयाबै ताँ क्हिइ सेइमुँ। खेदोमैंए बगालमैं या ताँन् क्हिलन् तल् खाँइमुँ। तारे क्हिलाइ पिंबर ङिए ज्यु नेरो क्ल्ह्‍यो बाहेक ङिने बालु तोइ आरे। ");
INSERT INTO gvr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ङि सिल् आपिंन्। ङिए क्ल्ह्‍यो या बाँजो तल् आपिंन्। ङिलाइ म्‍ल्ह-नारिमैं पिंसि ङि नेरो ङिए क्ल्ह्‍यो-न्हेंमैं या किंन्। धै ङि ह्रोंसए क्ल्ह्‍यो-न्हेने बालुन् म्रुँए केब्छैं-केब्स्योमैं तब्मुँ। बरु ङिए क्ल्ह्‍यो-न्हें या बाँझ आतरिगे ङि या सोल् योंरिगे,” बिसि ङिलाइ प्लु पिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","छले योसेफइ मिश्रर्बै ताँन् क्ल्ह्‍यो फारोए ल्हागिर किंइ। चर थेबै अँङ्गल् तबइले मिश्रीमैंइ ह्रोंसए ताँन् क्ल्ह्‍यो-न्हें या चुँइ, धै चमैंए क्ल्ह्‍योमैं फारो म्रुँल् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","मिश्रर्बै छेउ घ्रिइले अर्को छेउ समार्बै ताँन् म्हिमैं चइ केब्छैंमैं तइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","दिलेया खेगिमैंए क्ल्ह्‍यो बिस्याँ चइ आकिं, तलेबिस्याँ खेगिमैंए ल्हागिर फारोउँइँले म्‍ल्ह-नारिए भाउ स्यो लल। धै फारोइ पिंबै भागउँइँले चमैंइ चमल। छतसि चमैंइ खेंमैंए क्ल्ह्‍यो-न्हें चुँल् आत्हु। ");
INSERT INTO gvr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","योसेफइ मिश्रीमैंने बिइ, “ङ्‍ह्‍योद्, तिंयाँ ङइ फारोए ल्हागिर क्हेमैं नेरो क्हेमैंए क्ल्ह्‍यो न्हेंमैं किंइमुँ। तारे क्हेमैंए ल्हागिर प्लु चुर मुँ म्रोंर प्लु प्लुद्। ");
INSERT INTO gvr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","दिलेया रोमैं मिंबै त्हेर चए ङ्‍हबाँ क्हेमैंइ फारो म्रुँलाइ पिंल् त्हुम्। धै प्लिबाँ बिस्याँ प्लुए ल्हागिर नेरो क्हेमैंए परवा, प्हसेमैं चबर क्हेमैंल तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","चमैंइ बिइ, “ङिए सो क्हिइ जोगेमिंइमुँ। छलेन क्हिए म्हाँया ङि फिर तरिगे। ङि फारोए केब्छैंमैं तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","छतसि मिश्र ह्‍युलर्बै क्ल्ह्‍यो-न्हेंउँइँले खबै रोमैंए ङ्‍हबाँ फारोल तब्मुँ बिसि योसेफइ ठिम घ्रि बनेइ। च ठिम तिंयाँ समन् मुँ। खेगिमैंए क्ल्ह्‍यो मत्‍त्रे फारोल आत। ");
INSERT INTO gvr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","इस्राएलीमैं मिश्रर्बै गोशेन ह्‍युलर टिसि चर्बै क्ल्ह्‍योमैं ह्रोंसइ क्ल्हे लइ। चर चमैंल बिब् धों मैंब् धों तइ, धै चमैंए सन्तानमैं या ल्हें ततै ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","छले याकूब मिश्रर च्युसे ङिदिं टिइ, च प्रसे प्लिच्युसे ङिदिं सोइ। ");
INSERT INTO gvr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","याकूब सिबै त्हे तमा चइ ह्रोंसए च्ह योसेफ हुइसि बिइ, “क्ह्रोंसेंन ङइ बिबै ताँ ङिंम् बिस्याँ क्हिए यो ङए प्हाँ न्होंर थेंसि ङलाइ मिश्रर पारिब् आरे बिसि ङने कसम चद्। ");
INSERT INTO gvr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ङए खेमैं-माँमैं मुँबै क्ल्ह्‍योर्न ङए छगों तरिगे। छतसि ङ सियामा मिश्रउँइँले बोसि ङए खेमैं पाबै क्ल्ह्‍योर्न ङ पाद्।” योसेफइ आबाने बिइ, “क्हिइ बिब् धोंलेन् ङइ लस्यो आबा।” ");
INSERT INTO gvr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","धबै याकूबइ योसेफने बिइ, “छ बिस्याँ ङइ बिब् धोंलेन् लम्,” बिसि ङने कसम चद् बिमा योसेफइ कसम चइ। झाइले याकूब ह्रोंस रोबै क्ल्ह्‍योर्बै क्रेगुँर पद्खु तइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","दे त्हे लिउँइँ आबा नइमुँ बिसि योसेफइ म्हिमैंउँइँले था योंइ। छतसि मनश्शे नेरो एफ्राइम बिबै च्हमैं किंसि योसेफ याकूब ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","क्हिए च्ह योसेफ खइमुँ बिब् थेसि याकूब बेल्‍ले भों लसि रेइ धै खाटर क्हुँइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","याकूबइ योसेफने बिइ, “कनान ह्‍युलर्बै लूजरि तोन्दोंरि सै लल् खाँबै परमेश्‍वर ङ ङाँर म्रोंयुइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‘थेद्, ङइ क्हिलाइ छ्याँब् लमिंसि क्हिए सन्तानमैं ल्हें लमिंब्मुँ। क्हिउँइँलेन् ल्हें ह्रेंमैं लमिंब्मुँ, धै क्हिए च्ह क्वेंमैंन् चु ह्‍युलए फिर खोंयोंन् बिलैया क्ल्हे तल् पिंब्मुँ,’ बिसि खीजी ङलाइ आशिक पिंइ।” ");
INSERT INTO gvr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","याकूबइ धबै बिइ, “ङ मिश्रर खब् भन्दा ओंसों मिश्रर फिबै क्हिए च्हमैं ङ्हिं ङलन् ग। रूबेन नेरो शिमियोन धोंले एफ्राइम नेरो मनश्शे या ङलन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","क्हिल धबै अरू प्हसेमैं तइ बिस्याँ चमैं क्हिल तब्मुँ। चमैंइ एफ्राइम नेरो मनश्शेउँइँले हक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ङ पद्दन-आरामउँइँले खमा एप्रातर आफेबर्न कनान ह्‍युलर राहेल सियाइ। धै एप्रात अथवा बेथलेहेमर ह्‍याबै घ्याँए रेर ङइ चलाइ पाइ।” ");
INSERT INTO gvr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","योसेफए च्हमैं म्रोंसि याकूबइ “चु कोलोमैं खाब्मैं जा?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","योसेफइ ह्रोंसए आबाने बिइ, “परमेश्‍वरजी मिश्र ह्‍युलर पिंबै ङए च्हमैं ग।” छबिमा याकूबइ बिइ, “चमैं ङ ङाँर पखोदि, चमैंए फिर ङइ आशिक पिंम्।” ");
INSERT INTO gvr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","च त्हेर याकूबए छ्ह ल्हें तबइले चइ मि छेनाले म्रोंल् आखाँमल। छतसि योसेफइ ह्रोंसए च्हमैं याकूब ङाँर बोमिंइ धै याकूबइ चमैं अँखलो ख्वेसि म्वें लइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","धै याकूबइ योसेफने बिइ, “ङइ धबै क्हिलाइ म्रोंल् योंब्मुँ बिसि आमैंल। दिलेया क्हिए प्हसेमैं या परमेश्‍वरजी म्रोंल् पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","झाइले योसेफइ याकूबए क्ह्‍वेंउँइँले प्हसेमैं स्योवाइ, धै कुरसि आबालाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","योसेफइ च्हमैं ङ्हिं किंसि एफ्राइमलाइ याकूबए क्योलोउँइँ थेंइ धै मनश्शेलाइ याकूबए त्हेब्रेउँइँ थेंमिंइ। छले ह्रोंसए त्हेब्रेउँइँ नेरो याकूबए (इस्राएलए) क्योलोउँइँ लसि ह्रोंसए प्हसेमैं एस्राएलए चेंदो बोइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","दिलेया मनश्शे ठागु मुँलेया याकूबइ क्योलो यो स्योंसि च्योंब एफ्राइमए क्रर थेंइ, धै त्हेब्रे यो ठागु मनश्शेए क्रर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","झाइले चइ योसेफने छले आशिक पिंसि बिइ, “ङए बाज्यु अब्राहाम नेरो आबा इसहाक खेंमैंइ म्हाँदिबै परमेश्‍वरए उँइँर प्रमल। च परमेश्‍वरजीन् ङए छ्ह तिगोंन् तिंयाँ समा ङ डोरेइमुँ, ");
INSERT INTO gvr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ङलाइ ताँन् दुःखउँइँले फ्रेमिंबै स्वर्गदूतइ चुमैंए फिर आशिक पिंरिगे! चु कोलोमैंने ङए बाज्यु अब्राहाम, ङए आबा इसहाक नेरो ङए मिं आम्हरिगे। पृथ्‍बीर चुमैंल ल्हें-ल्हें सन्तानमैं तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","छले आबाइ ह्रोंसए क्योलो यो एफ्राइमए क्रर थेंब् म्रोंसि योसेफए सैं आक्हो, छतसि आबाए यो एफ्राइमए क्रउँइँले स्योसि मनश्शेए क्रर थेंमिंबै ल्हागिर आबाए यो क्हासि। ");
INSERT INTO gvr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","योसेफइ आबाने बिइ, “छले आङिं आबा, चु ठागु ग। चुए क्रर क्हिए क्योलो यो थेंमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","बिमा याकूबइ बिइ, “ङइ सेइमुँ, च्ह, ङइ सेइमुँ। मनश्शेलै या थेबै कुल तब्मुँ। दिलेया चए अलि च भन्दा थेब तब्मुँ। चए अलिए सन्तानमैं बेल्‍ले थेबै ह्रेंमैं तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","च त्हिंइर याकूबइ चमैं फिर छ बिसि आशिक पिंइ, “इस्राएलीमैंइ आशिक पिंमा क्हेमैंए मिं किंब्मुँ: ‘परमेश्‍वरजी क्हेमैं या एफ्राइम नेरो मनश्शे धोंन् लमिंरिगे बिसि।’” छले याकूबइ मनश्शे भन्दा एफ्राइम ओंसों थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","झाइले याकूबइ योसेफने बिइ, “तारे ङ सिबै त्हे तइमुँ, दिलेया परमेश्‍वर क्हेमैंने बालु तरिब्मुँ, धै क्हेमैंए खेमैं-मामैंए ह्‍युलर धबै क्हेमैंलाइ एबोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","शकेम क्हिए आघेंमैं आपिंल्‍ले ङइ क्हिलाइ पिंइमुँ। च क्ल्ह्‍यो ङइ सेलाँ नेरो मेत्हलेइ नेसि एमोरीमैंउँइँले ट्होसि किंब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","झाइले याकूबइ ह्रोंसए च्हमैं हुइसि बिइ, “क्हेमैं चुर खागु तद्। तारे पिरु क्हेमैंए फिर तो तखब्मुँ च ङइ बिमिंस्यो। ");
INSERT INTO gvr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ओ याकूबए च्हमैं खागु तसि क्हेमैंए आबा इस्राएलइ बिब थेद्। ");
INSERT INTO gvr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“रूबेन क्हि ङए च्ह थब ग, ङए भों मुँबै त्हेर्बै ओंसोंबै शक्‍ति नेरो भोंए रो ग। मान नेरो शक्‍तिर ताँन् भन्दा क्हि थेब ग। ");
INSERT INTO gvr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","दिलेया क्युए भेल धोंले छाइ माइ तब क्हि। तलेबिस्याँ क्हिए आबाए खाडर क्हि क्रेसि ङए खाडए आब्रु वाइ। ङए क्ल्ह्‍योर क्हि क्रेइ! छतसि क्हिए आब्रु टिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“शिमियोन नेरो लेबी आघें अलि ग, चमैंइ सेलाँ ओलेम्। ");
INSERT INTO gvr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ओ ङए सो, चमैंए म्हि च्होंर आखो, चमैंने प्रब टिब आलद्, तलेबिस्याँ चमैं ह्रिस खसि म्हिमैं सैवाइमुँ, चमैंइ तो लदा ङ्हाँमुँ चन् लसि क्ल्यामैंए मुल च थोवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","चमैंए ह्रिस फिर सराप खरिगे, तलेबिस्याँ चने दयाम्हाँया आरे। ङइ चमैंलाइ इस्राएल तिगोंन् प्हुँवाब्मुँ, धै चमैंलाइ सग्याँ प्हुग्याँ लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ओ यहूदा, क्हिए आघें-अलिमैंइ क्हिए मान लब्मुँ। क्हिए योइ क्हिए शत्तुरमैं ट्होसि चमैंए खरि क्हाब्मुँ। छतसि क्हिए आबाए च्हमैं क्हिए ओंसों कुरब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ओ यहूदा क्हि भोंबै सिंह धों तब् ग। ओ ङए च्ह हेउँइँले फो सैसि क्हि युइमुँ, क्हि कुरमुँ धै सिंह धोंलेन् रोरिमुँ। सिंह आमालाइ धोंले खाबज्यै क्हिलाइ रेबै आँट लरिब् आरे? ");
INSERT INTO gvr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","यहूदाए योउँइँले म्रुँए प्हरे स्योरिब् आरे, चए क्ल्हे आखन् समा, ग्याल्स ओलेबै प्हरे चए प्हलेए प्हाँइले स्योरिब् आरे। छतमा ह्रेंमैंइ चइ बिबै ताँ ङिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","चए गधा अँगुरए धुँर च्युँइँब्मुँ, धै गधाए प्हसेलाइ बेल्‍ले छ्याँबै हाँगर च्युँइँब्मुँ। चइ ह्रोंसए क्वेंमैं अँगुरए प्हार ख्रुब्मुँ धै खिबै क्वेंमैं अँगुरए खुगुर ख्रुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","चए मि अँगुरए प्हा भन्दा ओल्ग्या, धै चए स ङ्‍‍हे भन्दा तार्ग्या तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“जबूलूनए टिबै क्ल्ह्‍यो मा ङ्युँइए रेर तब्मुँ, च क्यु झाजमैं टिबै क्ल्ह्‍यो तब्मुँ। धै चए साँदा सिदोन समा तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“इस्साखार भोंबै गधा ग, च ति ङ्हिंए पोर रोरिम्। ");
INSERT INTO gvr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ह्रोंसए भों न्हबै क्ल्ह्‍यो छ्याँब मुँन, धै ताँ बिमिंबर ह्रोंसए ह्‍युल सैं तोंब मुँन बिब् सेसि चइ ति नोबर ह्रोंसए प्हैंद तोब्मुँ। धै केब्छैंइ धोंलेन् के लल् ङिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“इस्राएलर्बै कुलमैं घ्रि तसि दानइ ह्रोंसए म्हिमैंए निसाफ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","दान बिस्याँ घ्याँर्बै प्हुरि घ्रि अथवा घ्याँर्बै बिष मुँबै प्हुरि तब्मुँ। चइ गोडाए प्हले तिंजा चोब्मुँ धै घोडाए फिर क्रेबै म्हि चए लिलि क्हुरिह्‍याम्। ");
INSERT INTO gvr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“ओ याहवेह, क्हिजी जोगेमिंम् बिसि ङ पैंरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“गाधए फिर टोलि घ्रिइ ह्‍वाखब्मुँ, दिलेया चइ चमैंलाइ ल्हावाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“आशेर ह्‍युलर रोबै म्‍ल्ह-नारिमैं छ्याँब तब्मुँ। छतसि चइ म्रुँमैंए ल्हागिर लिं-लिंबै चबै सैमैं चुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“नप्‍ताली पिवाबै फो ग, चइ छ्याँ-छ्याँबै प्हसेमैं फिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“योसेफ बेल्‍ले रो-रोबै झ्याल् घ्रि ग, क्यु मुल ङाँर्बै रो रोबै झ्याल् ग। चए हाँगमैं गाराए फिफि ख्ल्याँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","मेत्हँले प्रिंब्मैंइ चलाइ बेल्‍ले दुःख पिंब्मुँ। चए फिर मेत्हँलेइ प्रिंसि चलाइ ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","दिलेया इस्राएल जोगेमिंबै पारा नेरो प्ह्रोंछैंउँइँले याकूबइ म्हाँदिबै भोंबै परमेश्‍वरए योउँइँले योसेफए त्हँले आकुरा, धै चए यो भोंब तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","क्हिए आबाए परमेश्‍वरजीन् क्हि ल्होमिंम्। तोन्दोंरि सै लल् खाँबै परमेश्‍वरजी क्हिए फिर आशिक पिंम् ताइ स्वर्गर्बै आशिकमैं, माइ क्रों न्होंर्बै आशिकमैं, ल्हें ल्हें सन्तानमैं तबै आशिकमैं पिंम्। ");
INSERT INTO gvr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","क्हिए आबाइ योंबै आशिक स्योंम्बै कोंमैंइ पिंबै आशिक भन्दा भोंब मुँ। च ताँन् आशिक योसेफए क्र फिर तरिगे। चए आघें-अलिमैं न्होंरि च चिब तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“बेन्यामीन रुएबै प्याँगु घ्रि ग। न्हाँगर सैसि पखबै से चइ चम्, धै ङेसर चइ लुडिबै सै चुम्।” ");
INSERT INTO gvr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","चुमैं ताँन् एस्राएलए च्युसे ङ्हिं कुलमैं ग। चमैंए आबाइ चमैं ताँनइ योंल् त्हुबै आशिक पिंसि बिबै ताँमैं चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","झाइले याकूबइ चमैंने बिइ, “ङ ङए म्हिमैं ङाँर ह्‍याबर होंइमुँ। हिति एप्रोंनए म्रोंर्बै उर ङए खेमैंने बालु ङलाइ पाद्। ");
INSERT INTO gvr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","च कनान ह्‍युलर मम्रे ङाँर्बै मक्पेलार्बै म्रोंर मुँबै उर ङ पाद्। च उ म्रोंने बालुन् अब्राहामइ हित्ती एप्रोनउँइँले छगोंए ल्हागिर किंल। ");
INSERT INTO gvr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","चर्न चमैंइ अब्राहाम नेरो चए प्ह्रेंस्यो सारा पाल। धै इसहाक नेरो चए प्ह्रेंस्यो रिबेका या चर्न पाल। ङज्यै या लेआ चर्न पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","च म्रों नेरो चर्बै उ हित्तीमैंउँइँले किंब् ग।” ");
INSERT INTO gvr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","च्हमैंने चु ताँ बिल् खाँबै लिउँइँ याकूबइ ह्रोंसए प्हले क्ल्ह्‍योर स्योंसि सो पिंइ, धै ह्रोंसए खेमैंने त्होनेइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","छतमा योसेफ ह्रोंसए आबाए फिर पद्खु तसि क्रोदै चलाइ म्वें लइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","झाइले योसेफइ ह्रोंसए के लबै बैद्यमैंने ह्रोंसए आबाए सिनुर लिंबै थाँ खबै मसला फोबर ल्हैदिमा च बैद्यमैंइ याकूबए सिनुर लिंबै थाँ खबै मसला फोमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","चु के लबर प्लिच्यु त्हिंइ छ्युल तलेबिस्याँ लिंबै थाँ खबै मसला फोबर च्हगन् छ्युमल। च सिमा मिश्रीमैंइ ङिच्यु त्हिंइ समा शोक लइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","शोक लबै त्हे खाँबै लिउँइँ योसेफइ फारोए के लबै चिब्मैंने छ बिसि ताँ लइ, “क्हेमैंए म्हाँया ङए फिर मुँस्याँ गार आम्हाँदिल्‍ले चु ङए ताँ फारोने बिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘ङए आबाइ ङने “ङ सिबर होंइमुँ। छतसि कनान ह्‍युलर बोसि ङइ तासि बनेबै ङए छगोंर्न ङ पाद् बिसि ङने कसम चबर ल्हैदिल।” छतसि ङ ह्‍यासि ङए आबालाइ चर पासि एखल् पिंन्।’” ");
INSERT INTO gvr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","फारोइ बिइ, “क्हिने चइ कसम चबर ल्हैदिब् धोंलेन् ह्‍यासि क्हिए आबालाइ पाद्।” ");
INSERT INTO gvr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","छबिमा योसेफ ह्रोंसए आबालाइ पाबर ह्‍याइ। चने बालु फारोए ताँन् चिब्मैं, के लबै म्हिमैं नेरो मिश्रर्बै ताँन् थेबै म्हिमैं ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","छलेन योसेफए परवार्बै ताँन् म्हिमैं, चए आघें-अलिमैं नेरो चए आबाए परवार्बै ताँन् म्हिमैं चने ह्‍याइ। दिलेया खेंमैंए प्हसेमैं नेरो खेदोमैंए बगालमैं गोशेन ह्‍युलर्न वाथेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","चमैंने बालु रथर क्रेब्मैं नेरो घोडाए फिर क्रेब्मैं या ह्‍याइ। छतमा म्हलामिमैं ल्हें मुँल। ");
INSERT INTO gvr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","छले चमैं यर्दन ङाँर्बै आतादए खलर फेनेसि चर बेल्‍ले शोक लसि क्रोइ। योसेफइ चर ङिरो समा ह्रोंसए आबाए ल्हागिर शोक लइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","छतमा कनानीथेंमैंइ आतादए खलर शोक लब् म्रोंसि “चु मिश्रीथेंमैंइ थेबै शोक लरिइमुँ बिइ।” छतसि च यर्दन ङाँर्बै क्ल्ह्‍योए मिं हाबिल-मिश्रइम थेंइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","छले याकूबइ चमैंने बिब् धोंले चए च्हमैंइ लइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","चए च्हमैंइ चए सिनु कनानर बोसि अब्रामइ हित्ती एप्रोनने किंबै मम्रें ङाँर्बै मकपेलार्बै उर पाइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ह्रोंसए आबा पाबै लिउँइँ ह्रोंसए आघें-अलिमैं नेरो आबा पाबर चने बालु ह्‍याबै म्हिमैंने योसेफ मिश्रर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","खेंमैंए आबा सियाब् म्रोंसि योसेफए आघें-अलिमैंइ खेंमैं न्होंर बिइ, “तारे योसेफ ङ्योने बालु ख्रे लसि ङ्योइ चने लबै ताँन् आछ्याँबै केए खी किंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","छतसि चमैंइ योसेफ ङाँर छ बिसि सँउँसर कुलइ, “क्हिए आबाइ सिब् भन्दा ओंसों छाबै ताँ बिल: ");
INSERT INTO gvr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘क्हेमैंइ योसेफने गार आम्हाँदिल्‍ले ङिइ क्हिने लबै आछ्याँबै केए ल्हागिर क्हिए आघेंमैं क्षमा लद्।’ तारे यो छ्युँ लमुँ, गार आम्हाँदिल्‍ले ङि क्हिए आबाए परमेश्‍वरए केब्छैंमैंए आछ्याँबै के क्षमा लमिंन् बिद्।” चु ताँ थेसि योसेफ क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","चए आघेंमैं या खसि चए ओंसों पद्खु तसि “थेद्, ङि क्हिए केब्छैंमैं ग,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","दिलेया योसेफइ चमैंने बिइ, “आङ्हिंन्! ङ परमेश्‍वरए क्ल्ह्‍योर मुँ रो वा? ");
INSERT INTO gvr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","ङए फिर क्हेमैंइ न्होह्रों लबै सैं लल दिलेया परमेश्‍वरजी च केउँइँले छ्याँब लमिंबै सैं मैंइ। च के तिंयाँ ङ्यो ताँनए फिर तरिइमुँ छतमा ल्हें म्हि सोरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","छतसि आङ्हिंन्! क्हेमैं नेरो क्हेमैंए प्हसेमैं या ङइ न्हब्मुँ।” छले चइ चमैंए सैं भोंब् लमिंसि चमैंए सैं क्होमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","योसेफ नेरो चए आबाए परवामैं ताँन् मिश्रर्न टिइ। धै योसेफ प्रसे च्युदिं समा सोसि ");
INSERT INTO gvr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","एफ्राइमए क्वें-क्वेंमिंमैं या म्रोंइ। मनश्शेए च्ह माकिरए प्हसेमैं या योसेफए प्हलेर थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","झाइले योसेफइ ह्रोंसए आघें-अलिमैंने बिइ, “ङ सिबै त्हे तइ। परमेश्‍वरजी क्ह्रोंसेंन्लेन् क्हेमैंलाइ वास्ता लब्मुँ। खीजी अब्राहाम, इसहाक नेरो याकूबने बाछा फैसि पिंम् बिबै ह्‍युलर चु ह्‍युलउँइँले क्हेमैं बोमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","झाइले याकूबए प्हसेमैंने कसम चबर ल्हैदिसि योसेफइ बिइ, “परमेश्‍वरजी क्हेमैंलाइ छेनाले ङ्‍ह्‍योब्मुँ। परमेश्‍वरजी क्हेमैंलाइ बोह्‍याम् बिबै क्ल्ह्‍योर क्हेमैं ह्‍यामा ङए ह्रुइबमैं या बोयाद्।” ");
INSERT INTO gvr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","छले योसेफ प्रसे च्युदिं तसि सिइ। धै चमैंइ याकूबए सिनुर बेल्‍ले लिंबै थाँ खबै मसला नेरो आक्राँन् लबै मैं फोसि बकासर झोंसि मिश्र ह्‍युलर्न थेंइ।");
INSERT INTO gvr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","याकूब मिश्र ह्‍युलर ह्‍यामा चए च्हमैं या ह्रों-ह्रोंसए परवा किंसि चने बालुन ह्‍याइ। च च्हमैंए मिं चुमैंन् ग: ");
INSERT INTO gvr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","रूबेन, शिमियोन, लेबी, यहूदा, ");
INSERT INTO gvr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","इस्साखार, जबूलून्, बेन्यामीन, ");
INSERT INTO gvr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","दान, नप्‍ताली, गाद, नेरो आशेर। ");
INSERT INTO gvr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","याकूबए सन्तानमैं ताँन् लसि ङिच्यु मुँल। योसेफ बिस्याँ ओंसों ओंनोंन् मिश्रर मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","चर टिमा योसेफ नेरो चए ताँन् आघें-अलिमैं धै च पुस्तार्बै ताँन् म्हिमैं सियाइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","दिलेया इस्राएलए सन्तानमैं बिस्याँ बेल्‍ले ल्हें ततै ह्‍यासि मिश्र ह्‍युल तिगोंन् चमैंइ प्लिंयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","झाइले मिश्रर योसेफलाइ ङो आसेबै म्रुँ घ्रिइ शासन लबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","चइ ह्रोंसए म्हिमैंने बिइ, “ङ्‍ह्‍योद्, इस्राएलीमैं ङ्यो भन्दा ल्हें ततै ह्‍यासि बेल्‍ले भोंब तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","चमैं ल्हें ततै ह्‍याब्मुँ, धै खनिज्यै प्होंब-नेब तस्याँ चमैं ङ्योए शत्तुरमैंने क्ह्रिसि ङ्योए बिरोधर प्होंब-नेब लब्मुँ धै चु ह्‍युल पिसि ह्‍याब्मुँ। छतसि तारे ङ्योइ च्हैंसि मैंसि चमैंने बालु के लल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","छतसि मिश्रीमैंइ इस्राएलीमैंलाइ बेल्‍ले गारो के ल्हैदिबै चिब्मैं त्हाँइ। धै चमैंइ फारोए ल्हागिर पिताम नेरो रामसेस बिबै म्ल्ह नारिमै खुथेंबै सहरमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","दिलेया मिश्रीमैंइ इस्राएलीमैंए फिर कति दुःख पिंलेना चमैं च ह्‍युलर ल्हें तसि प्लिंदै ह्‍याइ। छतमा मिश्रीमैं चमैंने ङ्हिंबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","छतमा मिश्रीमैंइ इस्राएलीमैंलाइ खैच्हिजिले के लबर ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","मसला नेरो इटा बनेब धै म्रोर्बै ताँन् खालर्बै केब्छैंमैंइ लबै केमैं लबर ल्हैदिसि चमैंए छ्ह ककाँ क्युँक्युँ ङ्हाँन् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","झाइले मिश्रर्बै म्रुँइ शिप्रा नेरो पूआ मिं लबै हिब्रू सुँडेनिमैं हुइसि बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“हिब्रूस्योमैंइ प्हसे फिसि चमैंए सुसर लमा च्ह फिस्याँ सैवाद्, च्हमिं फिस्याँ आसैद्।” ");
INSERT INTO gvr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","दिलेया च सुँडेनिमैं परमेश्‍वरने ङ्हिंमल। छतसि मिश्रर्बै म्रुँइ बिब् धोंले चमैंइ आल, चमैंइ च्हमैं या सोगोंन् थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","छतमा मिश्रर्बै म्रुँइ च सुँडेनिमैं हुइसि “क्हेमैंइ च्हमैंलाइ तले आसैल? तले छ लल?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","सुँडेनिमैंइ फारोने बिइ, “हिब्रूस्योमैं मिश्रीस्योमैं धों तब आरे। चमैं भोंभों धुँधुँ तब मुँ। ङि फेनेब् भन्दा ओंसोंन् चमैंइ प्हसे फिम्।” ");
INSERT INTO gvr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","छले परमेश्‍वजी सुँडेनिमैंए फिर ल्हयो खइ, धै इस्राएलीमैं ल्हें त-तै ह्‍यासि भोंब तइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","छले सुँडेनिमैंइ परमेश्‍वरने ङ्हिंबै लमा खीजी चमैंलाइ प्हसेमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","छतमा फारो म्रुँइ ह्रोंसए ताँन् म्हिमैंने “हिब्रूमैंला च्हमैं कति फिलेया चमैं ताँन् नील स्योंर भ्योंवाँन्, च्हमिंमैं बिस्याँ सोगोंन् थेंन्,” बिसि ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","च त्हेर लेबीए कुलर्बै म्हि घ्रिइ खेमैंए कुलर्बन च्हमिरि घ्रिने ब्ह्‍या लइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","च च्हमिरिइ प्हसे नोसि च्ह घ्रि फिइ। च कोलो बेल्‍ले छ्याँब म्रोंसि चइ म्हैंन सौंल् समा लोथेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","झाइले च कोलो अझै लोल् आखाँबइले च कोलोए ल्हागिर कूशए टोक्रि घ्रि पखसि चलाइ तारपिन नेरो अलकत्राइ स्यालइ। धै कोलो टोक्रि न्होंर थेंसि चइ नील स्योंए रेर काँसए घारिर थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","च कोलोए आना बिस्याँ चलाइ खै तब् ङ्‍हे बिसि ह्रेंगोर रासि ङ्‍ह्‍योरिल। ");
INSERT INTO gvr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","च त्हेर्न फारो म्रुँए च्हमि नील स्योंर ख्रुबर खल। चए केब्स्योमैं च स्योंए तिरर स्युररिल। छतमा चइ काँसए घारिर च टोक्रि म्रोंसि ह्रोंसए केब्स्योलाइ टोक्रि किंबर कुलइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","धै चइ टोक्रि फैमा क्रोरिबै कोलो म्रोंइ। चइ ल्हयो खसि कोलोलाइ ङ्‍ह्‍योसि बिइ, “चुम् हिब्रूमैंए कोलो घ्रि मुँन!” ");
INSERT INTO gvr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","धै च कोलोए आनाइ फारो म्रुँए च्हमिने बिइ, “चु कोलोलाइ ङ्‍हे थुँमिंबर ङइ खाब् मुँले हिब्रूस्यो घ्रि हुइ पखले वा?” ");
INSERT INTO gvr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","छबिमा फारोए च्हमिइ चने “तम् तम् ह्‍याद्।” बिमा च च्हमिरि ह्‍यासि कोलोए आमा हुइसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","झाइले फारोए च्हमिइ चने बिइ, “चु कोलो बोसि ङ्‍हे थुँमिंब्रें लद्। ङइ क्हिए नों सै पिंब्मुँ।” छबिमा च च्हमिरिइ कोलो बोसि ङ्‍हे थुँमिंब्रें लइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","कोलो थेब् तबै लिउँइँ कोलोए आमाइ च कोलो फारोए च्हमि ङाँर बोइ। धै चइ च कोलोलाइ च्ह धोंलेन् न्हरिमा “चुलाइ ङइ क्युउँइँले तेब् ग। छतसि ङइ चुए मिं मोशा थेंम्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","मोशा फ्रेंसि तबै लिउँइँ ह्रोंसए म्हिमैं हिब्रूमैं ङाँर ह्‍याइ। चर चमैंइ ल्हें ल्हें दुःख योंरिब् म्रोंइ। च्हमन ह्रोंसए हिब्रू म्हि घ्रिलाइ मिश्रीइ धोंरिबै या चइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","झाइले चइ छाइ-छुइ ङ्‍ह्‍योमा चर खाबै आम्रोंमा च मिश्री सैसि बलुवार पाइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","धबै प्हँन्हाँग्धों मोशा चर ह्‍यामा हिब्रूमैं ङ्हिं नेरिब म्रोंइ। धै चइ खैच्हिजी लबै म्हिने “क्हिइ ह्रोंसए म्हिलाइ तले प्रिंल?” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","छबिमा चइ बिइ, “क्हि ङिए क्रथे नेरो निसाफ लबै म्हि खाबइ लमिंइ? च मिश्रीने सैब् धोंले ङलाज्यै या सैल् म्हैल् वा?” छबिमा मोशाइ सैं न्हों-न्हों ङ्हिंसि बिइ, “क्ह्रोंसेंन चु ताँ खन्तोंदोंन् थेबर होंना।” ");
INSERT INTO gvr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","फारोइ चु ताँ था सेसि मोशालाइ सैबै सैं लइ। दिलेया मोशा फारो ङाँइले भौदिसि मिद्यान ह्‍युलर ह्‍यासि टिइ। तिगैं च क्यु खादुँ ङाँर टिरिमा ");
INSERT INTO gvr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","मिद्यानर्बै खेगिला (पुजारिला) च्हमि ङिग्लो ह्रोंसए आबाए र-क्युमैं क्यु थुँमिंबै ल्हागिर क्यु खासि डुँडर झोंबर होंल। ");
INSERT INTO gvr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","च त्हेर्न कोइ प्ह्रोंछैंमैं खसि च च्हमिरिमैं ल्हाबर होंइ। दिलेया मोशा रेसि चमैंलाइ ल्होमिंसि चमैंए र-क्युमैं क्यु थुँल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","झाइले चमैं ह्रोंसए आबा रूएल ङाँर खमा चमैंए आबाइ “क्हेमैं तिंयाँ तले च्हौ युनन् खल?” बिसि ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","चमैंइ बिइ, “मिश्री घ्रिइ ङिलाइ प्ह्रोंछैंमैंए योउँइँले जोगेमिंइ। च्हौ मत्‍त्रे आङिंना, चइ ङिए ल्हागिर क्यु खासि ङिए र-क्युमैं थुँल् पिंइ।” ");
INSERT INTO gvr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","छबिमा चइ ह्रोंसए च्हमिमैंने बिइ, “च खनिर मुँ? क्हेमैंइ च म्हिलाइ तले वाथेंसि खल? ह्‍याद्, ङ्योने बालु चब् चबर हुइ पखो।” ");
INSERT INTO gvr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","हुइ पखमा मोशा च म्हिने बालु टिल् ङिंइ। धै चइ ह्रोंसए च्हमि सिप्पोरा मोशाने ब्ह्‍या लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","सिप्पोराइ च्ह घ्रि फिइ, धै मोशाइ बिइ, “चु ह्‍युलर ङ टिल् योंसेरो ङइ चु च्हए मिं गेर्शोम थेंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","ल्हें त्हिंइ लिउँइँ मिश्रर्बै म्रुँ सियाइ। इस्राएलीथेंमैं केब्छैं तसि टिल् त्हुबइले प्ल्हाबै सो हेंसि ल्होमिन् बिसि प्राथना लइ। चमैंइ लबै प्राथना परमेश्‍वर ङाँर फेनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","परमेश्‍वरजी चमैंए प्ल्हाबै सो हेंबै प्राथना थेइ, धै अब्राहाम, इसहाक नेरो याकूबने ह्रोंसइ फैबै बाछा मैंइ। ");
INSERT INTO gvr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","छतसि परमेश्‍वरजी इस्राएलीमैं फिर ङ्ह्‍योइ धै चमैंए फिर न्हुँ लइ। ");
INSERT INTO gvr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","मोशाइ ह्रोंसए क्यें मिद्यानर्बै खेगि यित्रोए र-क्युमैं छरिल। छले छरिमा क्यु आयोंबै क्ल्ह्‍योए क्योंजा परमेश्‍वरए कों होरेब बिबै क्ल्ह्‍यो समन् चइ र-क्युमैं छदै बोइ। ");
INSERT INTO gvr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","चर लुँरिबै झ्याडि घ्रिर याहवेहए दूत च ङाँर म्रोंयुइ। धै मोशाइ झ्‍याडिर ङ्ह्‍योमा चर मि लुँरिल दिलेया झ्याडि बिस्याँ आख्रोंल। ");
INSERT INTO gvr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","दमोशाइ बिइ, “च झ्याडिर लुँरिबै मि तले आसिगे? ङ चए रेर ह्‍यासि च औदिबै सै ङ्‍ह्‍योम्।” ");
INSERT INTO gvr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","मोशा च ङ्ह्‍‍योबर छाइ ह्‍यारिब याहवेहजी म्रोंइ। धै झ्‍याडिए म्हाँजोउँइँले “ओ मोशा, मोशा” बिसि परमेश्‍वरजी हुइइ। मोशाइ “ङ चुर्न मुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","झाइले परमेश्‍वरजी बिइ, “छुइ चेंदो आखो। क्हिए प्हलेर्बै जुत्ता प्लिद् तलेबिस्याँ क्हि राबै क्ल्ह्‍यो पबित्र क्ल्ह्‍यो ग।” ");
INSERT INTO gvr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","खीजी धबै बिइ, “ङ क्हिए खेमैं माँमैं अब्राहाम, इसहाक नेरो याकूबए परमेश्‍वर ग।” छबिमा मोशाइ परमेश्‍वरलाइ ङ्‍ह्‍योब ङ्हिंसि ह्रोंसए लि हुइ। ");
INSERT INTO gvr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","झाइले याहवेहजी बिइ, “मिश्रर मुँबै ङए म्हिमैंइ योंबै दुःख ङइ म्रोंइमुँ। धै के ल्हैदिबै चिब्मैंइ दुःख पिंमा चमैंइ ग्वार ह्रिबै या ङइ थेइमुँ। चमैंइ दुःख योंब ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","छतसि चमैं मिश्रीमैंए योउँइँले फ्रेसि च ह्‍युलउँइँले छ्याँब नेरो थेबै ह्‍युलर, अथवा ङ्‍हे नेरो खुदु ल्हें योंबै ह्‍युलर पखबर ङ तयुइमुँ। च ह्‍युलर कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी नेरो यबूसीमैं टिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","तोगो इस्राएलीमैंइ ग्वार ह्रिब ङइ थेइमुँ। मिश्रीमैंइ चमैंलाइ ह्रुगुदिसि दुःख पिंब ङइ म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","छतसि तारे क्हि ह्‍यासि ङए इस्राएली म्हिमैं मिश्रउँइँले तेसि पखबर ङइ क्हि फारो म्रुँ ङाँर कुलसिन् मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","दिलेया मोशाइ परमेश्‍वरने बिइ, “फारो म्रुँ ङाँर ह्‍यासि मिश्रउँइँले इस्राएलीमैं पखल् खाँब ङ खाब् जा?” ");
INSERT INTO gvr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","छबिमा परमेश्‍वरजी धबै बिइ, “ङ क्हिने बालु तब्मुँ। ङइ क्हिलाइ कुलब् ग बिबै चिनु चु तब्मुँ: क्हिइ च म्हिमैं मिश्रउँइँले तेइ पखमा क्हेमैंइ चु कोंर ङए सेवा लब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","मोशाइ परमेश्‍वरने बिइ, “ङ इस्राएलीमैं ङाँर ह्‍यासि चमैंने छले बिमा, ‘क्हेमैंए खेमैंए परमेश्‍वरजी ङ क्हेमैं ङाँर कुलब् ग।’ बिसि, चमैंइ ‘खीए मिं तो जा?’ बिसि ङ्योएस्याँ ङइ चमैंने तो बिब?” ");
INSERT INTO gvr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","छबिमा परमेश्‍वरजी मोशाने बिइ, “ङ ग, च ङन् ग।” धबै खीजी बिइ, “इस्राएलीमैंने क्हिइ छ बिद्, ‘ङ ग’ बिबजी क्हेमैं ङाँर ङ कुलब् ग।” ");
INSERT INTO gvr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","परमेश्‍व‍रजी मोशाने चु ताँ या बिइ, “इस्राएलीमैंने बिद्, ‘याहवेह, क्हेमैंए खेमैं माँमैंए परमेश्‍वर अथवा अब्राहाम, इसहाक नेरो याकूबए परमेश्‍वरजी ङ क्हेमैं ङाँर कुलब् ग।’ ङए मिं खोंयोंन् बिलै याहवेह (अथवा ङ ङन् ग) बिब् तरिब्मुँ, धै ताँन् पुस्ता समा ङए मिंन् छले मैंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“छतसि ह्‍याद्। ह्‍यासि इस्राएलर्बै चिबनाँबमैं खागु लसि चमैंने बिद्, ‘याहवेह, क्हेमैंए खेमैं माँमैंए परमेश्‍वर, अब्राहाम, इसहाक नेरो याकूबए परमेश्‍वर, ङ ङाँर म्रोंयुसि बिइ: ङइ क्हेमैं ङ्‍ह्‍योब-च्योब लइमुँ धै मिश्रर क्हेमैंइ योंबै दुःख ङइ म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ङइ क्हेमैंलाइ मिश्रर्बै दुःखउँइँले ‍तेसि छ्याँब नेरो थेबै ह्‍युलर अथवा ङ्‍हे नेरो खुदु ल्हेंयाबै ह्‍युलर पखबर ङइ बाछा लइमुँ। च ह्‍युलर कनानी, हित्ती, एमोरी, परिज्जी, हिव्वी नेरो यबूसीमैं टिब्मुँ।’ ");
INSERT INTO gvr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“इस्राएलर्बै चिबनाँबमैंइ क्हिए ताँ थेब्मुँ, धै क्हि नेरो चिबनाँबमैं मिश्रर्बै म्रुँ ङाँर ह्‍यासि क्हेमैंइ चने छ बिद्, ‘हिब्रूमैंए याहवेह परमेश्‍वरजी ङिने त्होइमुँ। छतसि तारे ङि क्हिने बिन्ति लमुँ, ङिए याहवेह परमेश्‍वरए ल्हागिर क्यु आयोंबै क्ल्ह्‍योर ख्रो पिंबर सोंरोबै घ्याँर ङि ह्‍याल् पिंन्।’ ");
INSERT INTO gvr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","दिलेया मिश्रर्बै म्रुँइ क्हेमैं आकुलै आतबै त्हे आखन् समा ह्‍याल् पिंब आरे बिब ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","छतसि ङ चमैंए म्हाँजोर ङए यो क्वेसि औदिबै केमैंउँइँले मिश्रीमैंए फिर ल्हिब्मुँ। च लिउँइँ च म्रुँइ क्हेमैंलाइ ह्‍याल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“ङइ क्हेमैंए फिर मिश्रीमैंइ ल्हयो खल् लमिंब्मुँ, धै क्हेमैं ह्‍यामा यो क्होते ह्‍यारिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","क्हेमैंए च्हमिरिमैं ताँनइ ह्रोंसए मिश्री ङ्‍हेब् ट्हुब् नेरो चए धिंर टिबै मिश्री च्हमिरिने मारा चाँदिए घाँनामैं नेरो क्वेंजग ह्रिब्मुँ। धै क्हेमैंइ च सैमैं ह्रों-ह्रोंसए च्ह च्हमिमैं खिमिंब्मुँ। छले क्हेमैंइ मिश्रीमैंए सैमैं किंसि ह्‍याब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","मोशाइ बिइ, “खनिज्यै चमैंइ ङलाइ आक्वेंसि ङए ताँ आथेल्‍ले ‘याहवेह क्हि ङाँर म्रोंयुब आङिं,’ बिइ बिस्याँ तो लब?” ");
INSERT INTO gvr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","छबिमा याहवेहजी मोशाने “क्हिए योर तो मुँ?” बिमा चइ “प्हरे” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","याहवेहजी “च प्हरे सर भ्योंवान्” बिइ। मोशाइ प्हरे सर भ्योंवामा प्हरे प्हुरि तयाइ, छतमा मोशा च प्हुरि म्रोंसि ङ्हिंसि भौदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","झाइले परमेश्‍वरजी मोशाने बिइ, “क्हिए यो स्योंसि प्हुरिए मिर क्हाद्,” बिमा मोशाइ यो स्योंसि क्हामा प्हुरि चए योर धबै प्हरेन् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","धै याहवेहजी बिइ, “ङ याहवेह, चमैंए खेमैं अब्राहाम, इसहाक नेरो याकूबए परमेश्‍वर, क्हि ङाँर म्रोंयुब् मुँन बिसि इस्राएलीमैंइ चुन् केउँइँले क्वेंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","झाइले याहवेहजी चने धबै बिइ, “क्हि यो ह्रोंसए बखु न्होंर झोंन्,” बिमा चइ ह्रोंसए यो बखु न्होंर झोंइ, धै लिउँइँ बखु न्होंउँइँले यो ट्हुइमा च कोर खसि क्लिं धोंले तारग्या तयाना। ");
INSERT INTO gvr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","धै खीजी चने “क्हिए यो धबै बखु न्होंर झोंन्,” बिमा चइ बखु न्होंर यो झोंइ। धै लिउँइँ बैरु तेमा च यो ह्रोंसए ज्युर्बै अरू सेमैं धोंन् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","झाइले परमेश्‍व‍रजी बिइ, “चमैंइ क्हिए ताँ आक्‍वेंसि च ओंसोंबै चिनु वास्ता आलस्याँ चमैंइ लिउँइँबै चिनु म्रोंसि क्‍वेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","चमैंइ चु चिनुमैं ङ्हिं म्रोंसेया आक्‍वेंसि, क्हिए ताँ या आथेस्याँ, नील स्योंर्बै च्युगुदे क्यु किंसि कारा क्ल्ह्‍योर ङेमिंन्। क्हिइ नील स्योंउँइँले पखबै क्यु सर को तयाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","दिलेया मोशाइ याहवेहने बिइ, “प्रभु, ङ छेनाले पोंबै म्हि आङिं। ओंसों या पोंल् आह्रबन् मुँल, तोगो क्हि पोंबै लिउँज्यै या पोंल् आह्रबन् मुँ, तलेबिस्याँ ङ क्हुदिसि पोंबर क्हैइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","छबिमा याहवेहजी चने बिइ, “म्हिए सुँ खाबइ बनेइ? म्हिलाइ लडा, न्ह आथेब, मि म्रोंब, आम्रोंब खाबइ लमिंम्? ङ याहवेहजीन् आङिं वा? ");
INSERT INTO gvr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","छतसि ह्‍याद्! क्हि पोंबर ङइ ल्होमिंब्मुँ, क्हिइ तो तो पोंल् त्हुम् चै या ङइ लोमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","दिलेया मोशाइ बिइ, “ओ प्रभु, ङ यो छ्युँ लमुँ, अरू म्हिलाइन चु केर कुल्मिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","छबिमा याहवेह मोशाए फिर ह्रिस खसि बिइ, “लेबी कुलर्बै हारून क्हिए आघें आरे वा? ङइ सेइमुँ च छेनाले पोंल् खाँम्। च क्हिलाइ त्होबर खसिन्मुँ, क्हिलाइ म्रोंसि च सैं तोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","क्हिइ चने बालु ताँ लसि चइ बिल् त्हुबै ताँ चने बिद्। क्हेमैं ङ्हिंने बालु ङ तब्मुँ धै क्हेमैंइ तो लल् त्हुम् च ङ लोमिंस्यो। ");
INSERT INTO gvr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","क्हिए ल्हागिर च क्हिए सुँ धों तसि म्हिमैंने पोंमिंब्मुँ, धै क्हि चए ल्हागिर परमेश्‍वर धोंन् तसि तो बिल् त्हुम् बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","दिलेया चु प्हरे क्हिइन बोयाद्। चु प्हरेउँइँले क्हिइ औदिबै केमैं लब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","च लिउँइँ मोशा ह्रोंसए क्यें यित्रो ङाँर एखसि चने बिइ, “यो छ्युँ लम्, मिश्रर मुँबै ङए आघें-अलिमैं सोगों मुँ उ आरे बिसि ङ्‍ह्‍योबर ह्‍याल् पिंन्,” बिमा यित्रोइ मोशाने “तम्, सैं क्होसि ह्‍याद्!” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","मोशा मिधानर ठिमा याहवेहजी चने बिल, “मिश्रर एह्‍याद्, तलेबिस्याँ क्हिलाइ सैल म्हैब्मैं ताँन् सिल् खाँइ।” ");
INSERT INTO gvr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","छतसि मोशा ह्रोंसए प्ह्रेंस्यो नेरो च्हमैं गदार क्रेमिंसि परमेश्‍वरजी छेद् बिबै प्हरे योर किंसि मिश्रर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","याहवेहजी धबै मोशाने बिइ, “क्हि मिश्रर एह्‍यामा ङइ क्हिए योर थेंमिबै भोंउँइँले औदिबै केमैं फारो म्रुँए उँइँर लद्। दिलेया ङइ चए सैं सारो लब्मुँ। छतसि चइ ङए म्हिमैंलाइ ह्‍याल् पिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","च त्हेर क्हिइ फारो म्रुँने छले बिद्, ‘याहवेहजी बिइमुँ, इस्राएल ङए च्ह थेब ग। ");
INSERT INTO gvr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","चइ ङए सेवा लबर ङए च्ह ह्‍याल् पिंन् बिसि ङइ क्हिने बिइ, दिलेया क्हिइ चलाइ ह्‍याल् आपिं। छतसि ङइ क्हिए च्ह थेब सैवाब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","झाइले घ्याँर बास टिबै क्ल्ह्‍योर याहवेहजी मोशाने त्होसि चलाइ सैल् म्हैइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","दिलेया चए म्रिं‍‍ सिप्पोराइ छ्यारबै कर्द किंसि ह्रोंसए च्हए ज्युर चिनु लसि मोशाए प्हलेर छुइमिंसि “क्हि ङए ल्हागिर कोए प्युँ ग!” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","छलमा याहवेहजी चलाइ पिमिंइ। (धै ज्युर चिनु लबइले सिप्पोराइ “क्हि कोए प्युँ ग” बिल।) ");
INSERT INTO gvr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","याहवेहजी हारूनने “मोशाने त्होबर क्यु आयोंबै क्ल्ह्‍योर ह्‍याद्,” बिइ। छबिमा च परमेश्‍वरए कोंर मोशाने त्होबर ह्‍याइ, धै मोशाने त्होसि म्वें लइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","झाइले याहवेहजी मोशालाइ मिश्रर ह्‍याद् बिसि तोन्दोंरि बिल त्हुबै ताँमैं नेरो लल् त्हुबै औदिबै केमैंए बारेर मोशाइ हारूनने बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","छ बिबै लिउँइँ मोशा नेरो हारून मिश्रर ह्‍यासि इस्राएलीमैंए चिबनाँबमैं ताँन् खागु लइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","झाइले परमेश्‍वरजी मोशाने बिबै ताँन् ताँमैं हारूनइ चमैंने बिइ। धै मोशाइ इस्राएलीमैंए उँइँर औदिबै केमैं लसि उँइँइ। ");
INSERT INTO gvr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","छले उँइँमा हारूनइ बिबै ताँ म्हिमैंइ क्वेंइ। धै याहवेहजी इस्राएलीमैंए न्हुँ लमना धै चमैंए दुःख या म्रोंइमुँ बिसि चमैंइ थेमा चमैंइ क्र कुरसि याहवेहलाइ फ्योसि खीए मिं क्वेइ। ");
INSERT INTO gvr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","च लिउँइँ मोशा नेरो हारून फारो म्रुँ ङाँर ह्‍यासि बिइ, “‘क्यु आयोंबै क्ल्ह्‍योर ङए ल्हागिर चाड म्हाँदिबर ङए म्हिमैं ह्‍याल् पिंन्,’ बिसि इस्राएलीमैंए याहवेह परमेश्‍वरजी बिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","दिलेया फारोइ बिइ, “याहवेह बिब खाब् रो? ङइ तले चए ताँ ङिंसि इस्राएलीमैं ह्‍याल् पिंब? याहवेह ङइ ङो आसे, छतसि इस्राएलीमैं ङइ ह्‍याल् आपिं।” ");
INSERT INTO gvr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","झाइले चमैंइ बिइ, “हिब्रूमैंए परमेश्‍वर ङिने त्होइमुँ। यो छ्युँ लमुँ, क्यु आयोंबै क्ल्ह्‍योर सोंरोबै घ्याँर ह्‍यासि ङिए परमेश्‍वरए ल्हागिर ख्रो पिंबर ङि ह्‍याल् पिंन्। आस्याँ खीजी ङिलाइ नब छब लसि, सेलाँइ (तरवारइ) ल्हिसि सैब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","छबिमा मिश्रर्बै म्रुँइ चमैंने बिइ, “ओ मोशा नेरो हारून, म्हिमैंइ लबै केर क्हेमैंइ तले न्होह्रों लमुँ? लल् त्हुबै केमैं लद्!” ");
INSERT INTO gvr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","फारोइ धबै बिइ, “ङ्‍ह्‍योद्, तारे ह्‍युलर क्हेमैंए म्हिमैं ल्हें तइमुँ। क्हेमैंइ चमैंलाइ के लल् आपिंदा ङ्हाँइमुँ!” ");
INSERT INTO gvr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","च त्हिंइर फारोइ मिश्री के ल्हैदिबै चिब्मैं नेरो इस्राएली नाइकेमैंने छ बिबर ल्हैदिइ: ");
INSERT INTO gvr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“तारे इँट बनेबर चमैंलाइ पराल आपिंन्। चमैं ह्रोंसन् ह्‍यासि ह्रोंसए ल्हागिर पराल खुरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","दिलेया इँट बिस्याँ चमैंइ तोगो समा कति बनेदै खइमुँ च्हगन् बनेबर ल्हैदिद्। इँट घ्रि या ताइ माइ आतरिगे तलेबिस्याँ चमैं प्ल्हेउ तइमुँ। छतसि ‘ङिए परमेश्‍वरए मिंर ख्रो पिंबर ह्‍याल् पिंन्,’ बिसि चमैं ओरइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","चमैंइ केमैं लरिरिगे, धै स्योलिबै ताँर सैं आह्‍यारिगे बिसि चु म्हिमैंलाइ ल्हें केमैं लबर ल्हैदिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","छबिमा मिश्री के ल्हैदिबै चिब्मैं नेरो इस्राएली नाइकेमैं ह्‍यासि म्हिमैंने बिइ, “‘तारे ङइ क्हेमैंलाइ पराल आपिं,’ बिसि फारो म्रुँइ बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","‘क्हेमैं ह्रोंसन् ह्‍यासि पराल खनिर योंमुँ छाइलेन् म्हैसि पखो। दिलेया क्हेमैंइ ओंसों इँट कति बनेल च्हगन् बनेल् त्हम्।’” ");
INSERT INTO gvr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","छतसि म्हिमैं मिश्र तिगोंन् पराल खुबर खन्तोंदोंन् ख्याँयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","च के ल्हैदिबै चिब्मैंइ म्हिमैंने छ बिसि अत्तु चुइ, “पराल पिंमा त्हिंइर कति के लमल, पराल आपिंमै या च्हगन् लल् त्हुम्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","झाइले इस्राएली नाइकेमैंलाइ फारोए के ल्हैदिबै चिब्मैंइ धोंइ, धै “ओंसों धोंले तिंजोरै या इँट बनेसि ह्रोंसए के तले पूरा आलल?” बिसि ङ्योइ। ");
INSERT INTO gvr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","झाइले इस्राएली नाइकेमैं फारो ङाँर ह्‍यासि यो छ्युँ लसि बिइ, “क्हिए केब्छैंमैं फिर क्हिइ तले छाबै आछ्याँबै के लल? ");
INSERT INTO gvr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","क्हिए केब्छैंमैंलाइ ‘परालै या आपिं, दिलेया चमैंइ ङिने इँट या बनेद्’ बिम्। च्हगै आतन चमैंइ ङिलाइ धोंरिइमुँ दिलेया कसूर क्हिए म्हिमैंलन् मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","छबिले या फारोइ बिइ, “क्हेमैं प्ल्हेउ मुँ, के लदा आङ्हाँ। छतसि ‘ङि याहवेह ल्हागिर ख्रों पिंबर ह्‍याल् पिंन् बिसि क्हेमैंइ बिमुँ।’ ");
INSERT INTO gvr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","तारे ह्‍यासि के लद्। पराल बिस्याँ क्हमैंलाइ पिंरिब् आरे, दिलेया तोक्दिबै इँट क्हेमैंइ बनेलन् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","ओंसों इँट कति बनेल च्हगन् त्हिंइ ह्रोंसे बनेब् त्हुम् बिबै ताँ थेसि इस्राएली नाइकेमैंइ खेंमैंए फिर दुःख खब सेइ। ");
INSERT INTO gvr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","झाइले च नाइकेमैं फारो ङाँइँले त्होंखमा मोशा नेरो हारूनलाइ घ्याँर पैंरिब स्याइ। ");
INSERT INTO gvr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","झाइले चमैंइ बिइ, “क्हेमैंइ तो तो लइमुँ? याहवेहजी म्रोंसि क्हेमैंए निसाफ लरिगे, तलेबिस्याँ क्हेमैंइ फारो नेरो चए के लबै चिब्मैंइ ङिलाइ आखोब्मैं लमिंइमुँ। छतसि ङिलाइ सैबर क्हेमैइ चमैंए योर सेलाँ पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","झाइले मोशा याहवेह ङाँर एह्‍यासि बिइ, “ओ याहवेह, क्हिजी चु म्हिमैंए फिर तले दुःख तल् पिंल? छान् तरिगे बिसि ङलाइ कुलल् वा? ");
INSERT INTO gvr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ङ क्हिए मिंर पोंबर फारो ङाँर ह्‍याबै त्हेसेरो चइ चु म्हिमैंए फिर झन् दुःख पिंइमुँ। दिलेया क्हिजी ह्रोंसए म्हिमैंलाइ च दुःखउँइँले आफ्रेमिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","च त्हेर याहवेहजी मोशाने बिइ, “ङइ फारोलाइ तो लब्मुँ बिसि तारे क्हिइ म्रोंब्मुँ। ङए भोंबै योइ लमा चइ क्हेमैं ह्‍याल् पिंब्मुँ। ङए भोंबै योइ लमा चइ ह्रोंसए ह्‍युलउँइँले चमैंलाइ ल्हावाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","झाइले परमेश्‍वरजी मोशाने धबै बिइ, “ङ याहवेह ग! ");
INSERT INTO gvr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","अब्राहाम, इसहाक नेरो याकूब ङाँर ङ तोन्दोंरि सै लल् खाँबै परमेश्‍वरए क्हो किंसि म्रोंयुइ। दिलेया याहवेह बिबै ङए मिंउँइँले चमैं ङाँर आम्रोंयु। ");
INSERT INTO gvr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","चमैं आगुए ह्‍युलर ह्‍यासि टिबै कनान बिबै ह्‍युल ङइ चमैंलाइ पिंम् बिसि चमैंने बाछा फैइ। ");
INSERT INTO gvr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","मिश्रीमैंइ केब्छैं लसि थेंबै इस्राएलीमैंइ दुःखए सो हेंब ङइ थेइमुँ। धै ङइ चमैंने फैबै बाछा ङइ मैंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“छतसि ‘ङ याहवेह ग’ बिसि इस्राएलीमैंने बिद्। ‘ङइ क्हेमैंलाइ मिश्रीमैंइ पिंबै दुःखउँइँले फ्रेमिंब्मुँ, धै चमैंए केब्छैं तसि टिल् त्हुबइले तेइ पखब्मुँ। ङए भों मुँबै यो रेसि चमैंए फिर ङ्हिंन् ङ्हाँबै दुःख पिंसि क्हेमैंलाइ जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","ङइ क्हेमैंलाइ ङए म्हिमैं तल् पिंब्मुँ, धै ङ क्हेमैंए परमेश्‍वर तब्मुँ। मिश्रीमैंए कब्छैं तसि टिल् त्हुबइले क्हेमैंलाइ तेइ पखबै ङ याहवेह क्हेमैंए परमेश्‍वर ग बिसि क्हेमैंइ सेब्मुँ ");
INSERT INTO gvr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","धै ङइ अब्राहाम, इसहाक नेरो याकूबने बाछा फैसि पिंम् बिबै ह्‍युलर क्हेमैंलाइ पखब्मुँ, धै च ह्‍युल क्हेमैंलाइ क्ल्हे तबर पिंब्मुँ। ङन् याहवेह ग।’ बिसि चमैंलाइ बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","मोशाइ इस्राएलीमैंने छान् बिसि बिमिंइ, दिलेया चमैं आगुए केब्छैं तसि टिल् त्हुबइले चमैंए सैं सियाल। छतसि चमैंइ मोशाए ताँ थेल् आङिं। ");
INSERT INTO gvr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","छतमा याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ह्‍याद्, मिश्रर्बै फारो म्रुँने ‘इस्राएलीमैं क्हिए ह्‍युलउँइँले ह्‍याल् पिंन्!’ बिसि बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","छबिमा मोशाइ याहवेहने बिइ, “इस्राएलीमैंइ ङए ताँ आथे! ङ पोंलै आह्रबै म्हि ग, ङए ताँ फारोइ झन् खैले थेम् रो?” ");
INSERT INTO gvr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","झाइले याहवेहजी इस्राएलीमैं नेरो मिश्रर्बै फारो म्रुँए बारेर मोशा नेरो हारूनने ताँ ल्हैदिइ। “इस्राएलीमैंलाइ मिश्रउँइँले तेइ पखो!” बिसि चमैंने बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","इस्राएलए च्ह थेब रूबेनए च्हमैं हानोक, पल्‍लु, हेस्रोन नेरो कर्मि मुँल। चुमैंउँइँले रूबेनए बंशमैं खब् ग। ");
INSERT INTO gvr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","शिमियोनए च्हमैं यमूएल, यामिन, ओहद, याकिन, सोहोर नेरो कनानी च्हमिरिए च्ह शौल मुँल। चुमैंउँइँले शिमियोनए बंशमैं खब् ग। ");
INSERT INTO gvr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","लेबीए च्हमैं सों गेर्शोन, कहात नेरो मरारि मुँल। चुमैंउँइँले लेबीए बंशमैं खब् ग। (लेबी प्रसे सोंच्युसे ङिदि बर्ष समा सोइ।) ");
INSERT INTO gvr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","गेर्शोनए च्हमैं ङ्हिं लिब्नि नेरो शिमि मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","कहातए च्हमैं अम्राम, यिसहार, हेब्रोन नेरो उज्जीएल मुँल। (कहात प्रसे सोंच्युसे सोंदि समा सोइ।) ");
INSERT INTO gvr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","मरारिए च्हमैं महलि नेरो मूशि मुँल। लेबीए बंशमैं चए पुस्ता अनुसार चुमैं ताँन् ग। ");
INSERT INTO gvr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","अम्रामइ ह्रोंसए फोज्यों योकेबेदने ब्ह्‍या लसि हारून नेरो मोशा फिइ। (अम्राम प्रसे सोंच्युसे ङिदिं बर्ष समा सोइ।) ");
INSERT INTO gvr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","यिसहारए च्हमैं कोरह, नेपेग नेरो जिक्रि मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","उज्‍जीएलए च्हमैं मीशाएल, एलसाफान नेरो सिथ्रि मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","हारूनइ अम्मिनादाबए च्हमि नहशोनए अङाँ एलीशेबाने ब्ह्‍या लइ। चइ नादाब, अबिहू, एलाजार नेरो ईतामार फिइ। ");
INSERT INTO gvr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","कोरहए च्हमैं अस्सिर, एल्काना नेरो अबिआसाप मुँल। कोरहए बंशमैं चुमैंन् ग। ");
INSERT INTO gvr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","हारूनए च्ह एलाजारइ पतिएलए च्हमिमैं न्होंर्बै घ्रिने ब्ह्‍या लसि पिनहास फिइ। लेबीमैंए परवारर्बै चिब्मैं चमैंए बंशमैं चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","याहवेहजी चु हारून नेरो मोशाने “इस्राएलीमैंलाइ कुल कुल लसि मिश्रउँइँले तेइ पखो” बिसि बिल। ");
INSERT INTO gvr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","मिश्रर्बै फारो म्रुँने “इस्राएलीमैंलाइ मिश्रउँइँले ह्‍याल् पिंन्!” बिब चु मोशा नेरो हारून मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","याहवेहजी मिश्रर मोशाने बालु पोंबै त्हिंर, ");
INSERT INTO gvr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“ङ याहवेह ग। ङइ क्हिने तो-तो ताँ बिबर ल्हैदिइमुँ, च ताँन् मिश्रर्बै फारो म्रुँने बिद्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","दिलेया मोशाइ याहवेहने बिइ, “ङ पोंलै आह्रबै म्हिए ताँ फारोइ खैले थेलै रो?” ");
INSERT INTO gvr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","छबिमा याहवेहजी मोशाने बिइ, “थेद्, ङइ फारोए ल्हागिर क्हि परमेश्‍वर धोंन् लमिंइमुँ, धै क्हिए आघें हारून क्हिए ताँ पोंमिंबै म्हि तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","ङइ क्हिने बिबै ताँन् ताँमैं क्हिइ क्हिए आघें हारूनने बिद्, धै क्हिए आघें हारूनइ इस्राएलीमैंलाइ ह्रोंसए ह्‍युलर ह्‍याल् पिंन् बिसि फारोने बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","दिलेया ङइ फारोए सैं सारो लवाब्मुँ। धै ङइ ङ्हिंन् ङ्हाँन् तबै औदिबै चिनुमैं ल्हें लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","दिलेया फारोइ क्हेमैंए ताँ थेरिब् आरे। छतमा ङइ ङए शक्‍ति मिश्र ह्‍युलर उँइँब्मुँ। धै छेनाले निसाफ लसि ङए म्हिमैं मिश्रउँइँले तेइ पखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ङइ मिश्र ह्‍युलर ह्रोंसए यो क्वेसि चमैंए म्हाँजोउँइँले इस्राएलीमैं तेइ पखब्मुँ। छलमा मिश्रीमैंइ ङ याहवेह मुँन बिसि सेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","याहवेहजी मोशा नेरो हारूनने बिब् धोंलेन् चमैंइ लइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","फारोने ताँ लमा मोशा प्रेच्यु बर्षर्बै नेरो हारून प्रेच्युसे सोंदिर्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","झाइले याहवेहजी मोशा नेरो हारूनने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“फारोइ क्हेमैंने ‘औदिबै के लसि उँइँन्’ बिमा, क्हिइ हारुने ‘प्हरे फारोए उँइँर भ्योंवाँन्’ बिदु, धै च प्हरे प्हुरि तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","छतसि मोशा नेरो हारून फारो ङाँर ह्‍यासि याहवेहजी बिब् धोंलेन् हारूनइ ह्रोंसए प्हरे किंसि फारो नेरो चए म्हिमैंए ओंसों भ्योंवामा प्हरे प्हुरि तयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","छतमा फारोज्यै या ह्रोंसए ह्रब सेब्मैं नेरो टुना मुना लब्मैं हुइबर कुलइ। धै च मिश्रर्बै जादु लब्मैंज्यै या ह्रों-ह्रोंसए न्होंर्बै सिपउँइँले छान् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ताँनइ ह्रों-ह्रोंसए प्हरे भ्योंवामा प्हुरि तयाइ। दिलेया हारूनए प्हरेइ चमैंए प्हरे क्ल्ह्‍योंवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","दिलेया फारोए सैं सारो तइ। धै याहवेहजी बिब् धोंलेन् फारोइ चमैंए ताँ आथे। ");
INSERT INTO gvr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","झाइले याहवेहजी मोशाने बिइ, “फारोए सैं सारो तइमुँ। छतसि चइ म्हिमैं ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","न्हाँकर्न फारो नील स्योंउँइँ ह्‍यारिबै त्हेर क्हि च प्हुरि तबै प्हरे बोसि नील स्योंए तिरर चने त्होबर रारिद्। ");
INSERT INTO gvr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","झाइले चने छ बिद्, ‘हिब्रूमैंए याहवेह परमेश्‍वरजी ङलाइ क्हि ङाँर कुलइमुँ। खीजी क्हिने “ङए म्हिमैंलाइ क्यु आयोंबै क्ल्ह्‍योर ङए सेवा लबर ह्‍याल् पिंन्!” बिइ। दिलेया तोगो समा क्हिइ ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","छतसि “ङ्‍ह्‍योद्, ङइ नील स्योंर्बै क्यु ङए योर्बै प्हरेइ प्रिंब्मुँ। धै च को तयाब्मुँ। छले ङ याहवेह ग बिबै ताँ क्हिइ सेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","झाइले स्योंर्बै ताँगमैं सियाब्मुँ, धै स्यों बेल्‍ले थाँ नाँबइले मिश्रीमैंइ चर्बै क्यु थुँल् खाँरिब् आरे,” बिसि याहवेहजी बिइमुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","धबै याहवेहजी मोशाने बिइ, “‘मिश्ररर्बै स्यों, क्युखादुँ, ङ्‍ह्‍योखो, नेरो कुलोर्बै क्यु को तयारिगे बिसि क्हिए प्हरे किंसि च ताँनए फिर क्हिए यो स्योंन्,’ बिसि हारूनने बिद्। ‘छलस्याँ ताँन् मिश्रर मुँबै क्यु, सिं नेरो युँमाइ बनेबै छेदो न्होंर्बै क्युमैं या, को तयाब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","झाइले मोशा नेरो हारूनइ याहवेहजी बिब् धोंलेन् लइ। फारो नेरो चए के लब्हिमैंए उँइँर्न हारूनइ प्हरे नील स्योंए क्युर प्रिंमा ताँन् क्यु को तयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","नील स्योंर्बै ताँगमैं सियासि स्यों थाँ नाँबर होंइ, धै मिश्रर्बै ताँन् क्यु को तयाबइले मिश्रीमैंइ स्योंर्बै क्यु थुँल् आखाँल। ");
INSERT INTO gvr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","दिलेया मिश्रर्बै जादु लब्मैंज्यै या ह्रोंसए न्होंर्बै सिपउँइँले छान् लइ। याहवेहजी बिब् धोंलेन् फारोए सैं सारो तसि चमैंए ताँ आथे। ");
INSERT INTO gvr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","च्हौ थेबै दुःख तलेया तो तल् तरिगे बिसि फारो ह्रोंसए दरबारर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","नील स्योंर्बै क्यु थुँल् आखाँबइले ताँन् मिश्रीमैंइ नील स्योंए रेजरे थुँबै क्युए ल्हागिर ताबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","याहवेहजी नील स्योंर्बै क्यु को लमिंसि ङिगें तइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","धबै याहवेहजी मोशाने बिइ, “फारो ङाँर ह्‍यासि ‘ङए म्हिमैं ङए सेवा लबर ह्‍याल् पिंन् बिसि याहवेहजी बिइमुँ,’ बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","‘क्हिइ चमैंलाइ ह्‍याल् आपिंस्याँ ङइ क्हिए ताँन् ह्‍युलर प्हद्गोमैं कुलसि ह्रुगुदिल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","झाइले नील स्योंर प्हद्गोइ प्लिंसि च क्हिए दरबारर, क्हि रोबै कोठार, क्हिए खाटर, क्हिए के लब्मैंए धिं-धिंर, क्हिए म्हिमैंए फिर, क्हिए कोदाजरे नेरो प्रो चेंबै भाँडाजरे खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","च प्हद्गोमैं क्हिने, क्हिए म्हिमैंने, क्हिए के लब्मैं फिरै या खब्मुँ,’ बिसि चने बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","झाइले याहवेहजी मोशाने बिइ, “‘मिश्र तिगोंन् प्हद्गोमैं खरिगे बिसि हारूनइ प्हरे किंसि स्योंमैं, कुलोमैं नेरो ङ्‍ह्‍योमैं फिर यो स्योंन्,’ बिसि हारूनने बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","छबिमा हारूनइ मिश्रर्बै क्यु मुँबै क्ल्ह्‍योजरे ह्रोंसए यो स्योंमा प्हद्गोमैं त्होंसि मिश्र ह्‍युल हुवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","छलेन जादु लब्मैंज्यै ह्रोंसए न्होंर्बै सिपउँइँले छान् लसि मिश्रर प्हद्गोमैं तेवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","छतमा फारोइ मोशा नेरो हारूनलाइ हुइबर कुलसि बिइ, “याहवेहजी ङ नेरो ङए म्हिमैंउँइँले प्हद्गोमैं स्योमिंरिगे बिसि खीने बिन्ति लमिंन्। छलस्याँ खीए ल्हागिर ख्रो पिंबर क्हिए म्हिमैं ङइ ह्‍याल् पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","मोशाइ फारोने बिइ, “प्हद्गोमैं क्हि नेरो क्हिए धिंउँइँले म्हह्‍यारिगे, नील स्योंर मत्‍त्रे तरिगे बिसि ङइ क्हि नेरो क्हिए के लब्मैं नेरो क्हिए म्हिमैंए ल्हागिर याहवेहने खोंयों बिन्ति लमिंल् त्हुम बिसि बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","फारोइ “प्हन्हाँग” बिइ। मोशाइ बिइ, “क्हिइ बिब् धोंलेन् तब्मुँ, धै ङिए याहवेह परमेश्‍वर धोंब अरू खाबै आरे बिसि क्हिइ सेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","प्हद्गोमैं क्हि, क्हिए धिंउँइँले, क्हिए के लबै म्हिमैंउँइँले नेरो क्हिए म्हिमैंउँइँले एह्‍याब्मुँ, नील स्योंर मत्‍त्रे तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","झाइले मोशा नेरो हारून फारोउँइँले त्होंइ ह्‍याइ। धै फारोए फिर कुल्मिंबै प्हद्गोमैं स्योवामिंन् बिसि मोशाइ याहवेहने प्राथना लइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","छलमा याहवेहजी मोशाइ बिब् धोंलेन् लमिंसि धिंर, ह्‍युर नेरो म्रोंजरे मुँबै प्हद्गोमैं सियाइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","म्हिमैंइ चमैं खुसि क्ल्ह्‍यो घ्रिर थेंमा, मिश्र ह्‍युल आछ्याँबै थाँ नाँबर प्लिंयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","दिलेया फारोइ प्हद्गोमैं सियाब म्रोंलेया याहवेहजी बिब् धोंलेन् चइ ह्रोंसए सैं सारो लसि मोशा नेरो हारूनए ताँ आथे। ");
INSERT INTO gvr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","छतमा याहवेहजी धबै मोशाने बिइ, “त्हुलउँइँले मिश्र तिगोंन् मोसोमैं तयारिगे बिसि प्हरे किंसि त्हुलर प्रिंन् बिसि हारूनने बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","याहवेहजी मोशाने बिब् धोंले हारूनइ प्हरे किंसि स त्हुलर प्रिंमा मिश्र ह्‍युलर्बै ताँन् स त्हुला मोसो मोसोन् तयासि म्हिमैं नेरो खेदोमैंने कुयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","धै जादु लब्मैंज्यै ह्रोंसए न्होंर्बै सिपउँइँले मोसो बनेल् म्हैइ, दिलेया बनेल् आखाँ। दिलेया म्हिमैं नेरो खेदोमैंने मोसो तरिइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","छतमा जादु लब्मैंइ फारोने बिइ, “चु के परमेश्‍वरजीन् लब् ग।” छबिलेना याहवेहजी बिब् धोंलेन् फारोए सैं सारो तसि चमैंए ताँ आथे। ");
INSERT INTO gvr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","धबै याहवेहजी मोशाने बिइ, “प्हन्हाँग न्हाँकर्न ह्‍यासि फारो स्योंर ह्‍याबै त्हेर चने त्होसि बिद्, ‘ङए सेवा लबर ङए म्हिमैं ह्‍याल् पिंन् बिसि याहवेहजी बिइमुँ’ बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","‘ङए म्हिमैं ह्‍याल् आपिंस्याँ, ङ्‍ह्‍योद्, क्हि, क्हिए के लब्मैं फिर, क्हि म्हिमैं नेरो क्हिए धिंर ङइ बेल्‍ले ल्हें च्युमिंमैं कुल्मिंब्मुँ, छलेन मिश्रीमैंए धिं-धिंर नेरो चमैं टिबै क्ल्ह्‍योजरै या च्युमिंइ प्लिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","दिलेया च त्हिंइर याहवेह चु ह्‍युलर मुँ बिब् क्हिइ सेरिगे बिसि ङए म्हिमैं टिबै गोशेन ह्‍युललाइ बिस्याँ ङइ जोगेमिंब्मुँ, चर च्युमिं तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","छले ङए म्हिमैं नेरो क्हिए म्हिमैंए म्हाँजोर ङइ स्यो-स्योबै केमैं लब्मुँ। चु औदिबै चिनुमैं प्हन्हाँग तब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","च्हमा याहवेहजी छान् लइ। फारोए दरबार नेरो चए के लब्मैंए धिं-धिंर बेल्‍ले ल्हें च्युमिंमैं खइ, धै च्युमिंमैंइ मिश्र ह्‍युलर बेल्‍ले ह्रुगुदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","छतमा फारोइ मोशा नेरो हारून हुइसि बिइ, “क्हेमैं ह्‍यासि चु ह्‍युलए न्होंर्न ह्रोंसए परमेश्‍वरए ल्हागिर ख्रो पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","दिलेया मोशाइ बिइ, “छ लब ठिक आत, तलेबिस्याँ ङिए याहवेह परमेश्‍वरए ल्हागिर ङिइ पिंबै ख्रो म्रोंसि मिश्रीमैं छेरम्। मिश्रीमैंइ आखोबै ख्रो चमैंए ओंसों पिंइ बिस्याँ चमैंइ ङिलाइ युँमाइ आप्रिं रो वा? ");
INSERT INTO gvr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","ङि सोंरोबै घ्याँ ह्‍यासि क्यु आयोंबै क्ल्ह्‍योर ह्रोंसए परमेश्‍वरजी बिब् धोंलेन् खीए ल्हागिर ङिइ ख्रो पिंल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","छबिमा फारोइ बिइ, “तम्, ङइ क्हेमैंलाइ क्यु आयोंबै क्ल्ह्‍योर क्हेमैंए याहवेह परमेश्‍वरए ल्हागिर ख्रो पिंबर ह्‍यालम् पिंम्, दिलेया ह्रेंगो बिस्याँ आह्‍याद्। ङए ल्हागिरै या प्राथना लमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","मोशाइ बिइ, “ङ क्हि ङाँइले बैरु ह्‍याबै तोंदोंन् क्हि, क्हिए के लब्मैं नेरो क्हिए म्हिमैंउँइँले प्हन्हाँगन् च च्युमिंमैं स्योह्‍यारिगे बिसि याहवेहने प्राथना लब्मुँ। दिलेया याहवेहए ल्हागिर ख्रो पिंबर ह्‍याल् पिंम् बिसि धबै स्योर आतेद्।” ");
INSERT INTO gvr_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","झाइले मोशा फारो ङाँइले बैरु ह्‍यासि याहवेहने प्राथना लइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","छलमा याहवेहजी मोशाइ बिब् धोंलेन् लमिंइ, धै फारो, चए के लब्मैं नेरो चए म्हिमैंउँइँले च च्युमिंमैं घ्रि या आचैल्‍ले स्योह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","छ तलेना चु लारै या फारोइ धबै सैं सारो लसि म्हिमैं ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","याहवेहजी धबै मोशाने बिइ, “फारो ङाँर ह्‍यासि चने ‘ङए म्हिमैं ङए सेवा लबर ह्‍याल् पिंन् बिसि हिब्रूमैंए याहवेह परमेश्‍वरजी बिइमुँ,’ बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","‘क्हिइ अझै चमैंलाइ ह्‍याल् आपिंल्‍ले क्वेइ थेंस्याँ ");
INSERT INTO gvr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","क्हिए खेदोमैं, घोडा, गदा, सलु (ऊँट) म्येमैं नेरो र-क्युमैं फिर ङइ ङ्हिंन् ङ्हाँबै नब छब तल् लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","दिलेया ङइ इस्राएलीमैंए खेदोमैं नेरो मिश्रीमैंए खेदोमैं फेलब्मुँ। धै इस्राएलीमैंल खेदोमैं घ्रि या सिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ङइ प्हन्हाँगन् चु के लब्मुँ बिसि त्हे तौदिइ,’ बिसि फारोने बिद।” ");
INSERT INTO gvr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","चए प्हँन्हाँग्धों याहवेहजी च के लइ, धै मिश्रर्बै खेदोमैं ताँन् सिइ, इस्राएलीमैंल बिस्याँ खेदो घ्रि या आसि। ");
INSERT INTO gvr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","फारोइ चजरे ङ्‍ह्‍योबर म्हिमैं कुलमा इस्राएलीमैंल खेदोमैं घ्रि या सिब चमैंइ आम्रों। छान् तलेया फारोए सैं सारो तरिसि चइ म्हिमैं ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","च लिउँइँ याहवेहजी मोशा नेरो हारूनने बिइ, “कोदाउँइँले ह्रों-ह्रोंसए मुट्ठि तिगों मेब्रो किंनु, धै मोशाइ फारोए ओंसों च मेब्रो मुउँइँ टाँमिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","च मेब्रो ताँन् मिश्रर त्हुल तसि मिश्रर्बै ताँन् म्हिमैं नेरो खेदोमैंए ज्युर पोर तयाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","छबिमा चमैं कोदार्बै मेब्रो किंसि फारोए ओंसों रासि मोशाइ च मेब्रो मुउँइँ टाँमिंइ, धै म्हिमैं नेरो खेदोमैंए ज्युर पोरमैं त्होंखइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","जादु लब्मैं पोरइ लमा मोशाए उँइँर राल् आखाँ। तलेबिस्याँ जादु लब्मैंए ज्युर नेरो मिश्रीमैं ताँनए ज्युर पोर खल। ");
INSERT INTO gvr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","दिलेया याहवेहजी फारोए सैं सारो लमिंइ, धै याहवेहजी मोशाने बिब् धोंले मोशा नेरो हारूनए ताँ चइ आथे। ");
INSERT INTO gvr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","याहवेहजी धबै मोशाने बिइ, “प्हन्हाँग न्हाँकर्न रेसि फारो ङाँर ह्‍यासि चने, ‘ङए सेवा लबर ङए म्हिमैं ह्‍याल् पिंन्!’ बिसि हिब्रूमैंए याहवेह परमेश्‍वरजी बिइमुँ बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","‘ह्‍याल् आपिंस्याँ चु लार ङइ क्हिए फिर, के लब्मैंए फिर नेरो म्हिमैंए फिर बेल्‍ले थेबै दुःखमैं कुलब्मुँ। छले पृथ्‍बीर ङ धोंबै परमेश्‍वर खाबै आरे बिसि क्हिइ सेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ङइ ह्रोंसए यो स्योंसि क्हि नेरो क्हिए म्हिमैं नल् लवास्याँ क्हि चु पृथ्‍बीउँइँले नास तयामल, ");
INSERT INTO gvr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","दिलेया ह्‍युल तिगोंन् ङए मिं बिप्ररिगे धै ङए शक्‍ति क्हिइ म्रोंल् खाँरिगे बिसि ङइ क्हिलाइ सोगों थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","अझै या क्हि थेब् प्हैंसि ङए म्हिमैं ह्‍याल् आपिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","छतसि प्हन्हाँग चु त्हेर्न ङइ बेल्‍ले थेबै तिस्यु कुलब्मुँ। च्हौ थेबै तिस्यु मिश्र ह्‍‍युलर तोगो समा आयुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","छतसि “खेदोमैं नेरो बैरु मुँबै ताँन् सैमैं युना न्होंर झोंन्!” बिबर म्हिमैं कुलद्, तलेबिस्याँ धिं न्होंर आझोंल्‍ले बैरुन् वाथेंबै म्हिमैं नेरो खेदोमैं तिस्युइ ह्रासि सियाब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","धै फारोए के लब्मैं न्होंरि याहवेहजी बिबै ताँने ङ्हिंब्मैंइ ह्रों-ह्रोंसए केब्छैंमैं नेरो खेदोमैं धिं न्होंर झोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","दिलेया याहवेहजी बिबै ताँने आङ्हिंब्मैंइ ह्रों-ह्रोंसए केब्छैंमैं नेरो खेदोमैं बैरुन् टिल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","झाइले याहवेहजी मोशाने बिइ, “क्हिए यो मुउँइँ स्योंन्, धै मिश्र तिगोंन् तिस्यु युसि मिश्रर्बै म्हि, खेदो, म्रोंर म्‍लोबै ताँन् सैमैं तिस्युइ ह्रारिगे।” ");
INSERT INTO gvr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","झाइले मोशाइ ह्रोंसए प्हरे मुउँइँ स्योंमा याहवेहजी मु ङ्‍हेल् लवासि पृथ्‍बीर काम्‍लि-तिम्‍लि रासि मिश्रर ङ्हिंन ङ्हाँबै तिस्यु कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","तिस्यु युसि काम्‍लि-तिम्‍लि राइ। छाबै तिस्यु मिश्र ह्‍युलर ओंसों खोंयोंइ आयुल! ");
INSERT INTO gvr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ताँन् मिश्ररर्बै बैरु मुँबै म्हि नेरो खेदो तिस्युइ प्रुइ। तिस्युइ म्रोंर म्‍लोबै सैमैं नेरो सिंधुँमैं तोइ आचैन् लवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","दिलेया इस्राएलीमैं मत्‍त्रे टिबै गोशेन ह्‍युलर तिस्यु आयु। ");
INSERT INTO gvr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","छतमा फारोइ मोशा नेरो हारून हुइसि “चु लारै ङइ पाप लइ,” बिइ। “याहवेहजी ठिक लइमुँ, ङ नेरो ङए म्हिमैंज्यै आछ्याँबै केमैं लइमुँ! ");
INSERT INTO gvr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","छतसि याहवेहने प्राथना लमिंन्, तलेबिस्याँ चु मु ङ्‍हेब नेरो तिस्युइ सारुन् लइ। ङइ क्हेमैं ह्‍याल् पिंब्मुँ। तारे क्हेमैं अझै चुर टिल् आत्हु।” ");
INSERT INTO gvr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","मोशाइ म्रुँने बिइ, “ङ सहरउँइँ त्होंह्‍याबै तोंदोंन् ङइ याहवेह ङाँइ ह्रोंसए यो स्योंब्मुँ, झाइले मु ङ्‍हेब नेरो तिस्यु युब टियाब्मुँ। छले पृथ्‍बी याहवेहलन् ग बिसि क्हिइ सेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","दिलेया क्हि नेरो क्हिए के लब्मैंइ बिस्याँ तोगो समा याहवेह परमेश्‍वरने आङ्हिंइमुँ बिसि ङइ सेइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","नाँ त्होंबै जौ नेरो सारबै सनपाटर तिस्युइ प्रुवाल। ");
INSERT INTO gvr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","दिलेया गहुँ बिस्याँ तिस्युइ आप्रु तलेबिस्याँ गहुँल नाँमैं आत्होंल। ");
INSERT INTO gvr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","झाइले मोशा फारो ङाँइले त्होंसि सहर बैरु ह्‍यासि याहवेह ङाँइ ह्रोंसए यो स्योंमा मु ङ्‍हेब नेरो तिस्यु युब टियाइ, धै नाँ या टियाइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","दिलेया फारोइ नाँ तिस्यु नेरो मु ङ्‍हेब टियाब् म्रोंसि फारो नेरो चए के लब्मैंइ सैं सारो लसि धबै पाप लइ। ");
INSERT INTO gvr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","छले फारोए सैं सारो तइ, झाइले याहवेहजी मोशाने बिब् धोंलेन् चइ इस्राएलीमैं ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","याहवेहजी धबै मोशाने “फारो ङाँर ह्‍याद्,” बिइ। “तलेबिस्याँ चमैंए म्हाँजोर ङए चु औदिबै चिनुमैं उँइँरिगे बिसि ङइ च नेरो चए के लब्मैंए सैं सारो लमिंब् ग। ");
INSERT INTO gvr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","छ लमा ङइ मिश्रीमैं म्हाँजोर खै-खैबै चिनुमैं उँइँइ बिसि क्हिए च्ह क्वेमैंने बिब्मुँ, झाइले याहवेह ङन् ग बिसि क्हेमैंइ सेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","छतसि मोशा नेरो हारून फारो ङाँर ह्‍यासि चने बिइ, “हिब्रूमैंए याहवेह परमेश्‍वरजी क्हिने ‘खोंयों समा क्हि च्योंने तसि ङइ बिब् आङिं?’ बिइ। ‘ङए सेवा लरिगे बिसि ङए म्हिमैं ह्‍याल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","क्हिइ ङए म्हिमैं ह्‍याल् आपिंस्याँ प्हन्हाँग ङइ क्हिए ह्‍युलर तिरिमैं पखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","तिरिमैंइ स आम्रोंन्ले हुवाब्मुँ। तिस्युउँइँले जोगेसि ङैबै सैमैं नेरो क्ह्‍योंर म्‍लोबै ताँन् सिधुँए प्होमैं चमैंइ चवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","क्हिए धिंर, क्हिए के लब्मैंए धिंमैंर नेरो ताँन् मिश्रीमैंए धिंमैंर तिरिइ प्लिंब्मुँ। च्हौ ल्हें दु:ख क्हिए खेमैंइ तिंयाँ समा खोंयोंन् बिलै आम्रोंल,’ बिइ।” च्हौ बिसि मोशा फारो ङाँइँले त्होंसि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","फारोए के लब्मैंइ चने “खोंयों समा चुइ ङ्योलाइ दुःख पिंमुँ?” बिइ। “मिश्र ह्‍युल नास तयाइ बिब क्हिइ आसेइमुँ वा? च म्हिमैंलाइ खेंमैंए याहवेह परमेश्‍वरए सेवा लबर ह्‍याल् पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","झाइले फारोए म्हिमैंइ मोशा नेरो हारून फारो ङाँर पखइ। फारोइ चमैंने बिइ, “ह्‍यासि क्हेमैंए याहवेह परमेश्‍वरए सेवा लद्। दिलेया ह्‍याब्मैं खा-खाब्मैं जा?” ");
INSERT INTO gvr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","मोशाइ बिइ, “ङि, ङिए कोलोमैं, खेब् माँब्मैं, च्ह च्हमिमैं, र-क्युमैं नेरो खेदोमैं किंसि ह्‍याब्मुँ, तलेबिस्याँ ङिइ याहवेहए ल्हागिर चाड म्हाँदिल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","फारोइ बिइ, “ङइ च्हमिरिमैं नेरो कोलोमैं क्हेमैंने ह्‍याल् पिंम् बिस्याँ क्हेमैंए रक्षा लबर याहवेह क्हेमैंनेन् मुँल् त्हुम्! तलेबिस्याँ क्हेमैंए सैंर आछ्याँब ताँमैं मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","छ आत! क्हेमैं ह्‍यासि याहवेहए सेवा लदा ङ्हाँम। छतसि मुँयुँमैं मत्‍त्रे बोसि ह्‍याद्।” झाइले फारोए म्हिमैंइ मोशा नेरो हारून फारो ङाँइँले ल्हावाइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","छतमा याहवेहजी मोशाने बिइ, “तिरिमैं मिश्रर खसि तिस्युइ आस्याबै म्रोंर्बै प्याँ-पिं ट्हा-ट्हुमैं ताँन् चवारिगे बिसि मिश्र ह्‍युलउँइँ ह्रोंसए यो स्योंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","छबिमा मोशाइ ह्रोंसए प्हरे मिश्रए फिर स्योंमा याहवेहजी च त्हिंइ नेरो म्हुँइँसा मिश्रर स्यारउँइँले खैं खमिंइ। झाइले न्हाँग तमा स्यारबै खैंइ तिरिमैं पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","तिरिमैं मिश्रर खसि ह्‍युल तिगोंन् टिइ। च्हौ ल्हें तिरि चु भन्दा ओंसों खोंयोंन् बिलै आखल, लिउँइँज्यै या धबै खरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","तिरिइ ताँन् क्ल्ह्‍यो म्‍लोंगि ब्योंन्ले हुवाइ। धै तिस्युइ आस्याबै मिश्रर्बै ताँन् प्याँ पिं ट्हा ट्हुमैं नेरो सिंधुँर्बै रोमैं तोइ आचैल्‍ले चवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","छतमा फारोइ मोशा नेरो हारून युनन् हुइबर कुलसि “ङइ क्हेमैंए याहवेह परमेश्‍वर नेरो क्हेमैंए बिरोधर पाप लइ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","“छतसि तारे ङ यो छ्युँ लमुँ, ङए पाप तोगोइन क्षमा लद्, धै ङए फिर तखबै चु दुःख खीजी स्योमिंरिगे बिसि क्हेमैंए याहवेह परमेश्‍वरने यो छ्युँ लसि प्राथना लद्।” ");
INSERT INTO gvr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","छबिमा मोशा फारो ङाँइँले त्होंइ ह्‍यासि याहवेहने यो छ्युँ लसि प्राथना लइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","झाइले याहवेहजी छ्यो न्हुउँइँले (पश्‍चिमउँइँले) बेल्‍ले थेबै खैं खमिंइ, खैंइ तिरिमैं सुएज बिबै मा ङ्युँइउँइँ नोबोइ। मिश्रर तिरि घ्रि या आचै। ");
INSERT INTO gvr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","दिलेया याहवेहजी फारोए सैं सारो लमिंमा चइ इस्राएलीमैं ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","याहवेहजी धबै मोशाने बिइ, “छुइमा या था सेबै मिछु खैब मिश्रर तयारिगे बिसि क्हिए यो मुउँइँ स्योंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","छबिमा मोशाइ ह्रोंसए यो मुउँइँ स्योंमा मिश्रर सोंगैं समा मिछु खैयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","सोंगैं समा मिश्रीमैंइ खाबै म्रोंल् आखाँ, खाबै या ह्रोंसए क्ल्ह्‍योउँइँले प्रल् आखाँ दिलेया इस्राएलीमैं टिबै क्ल्ह्‍योर बिस्याँ मि म्रोंरिल। ");
INSERT INTO gvr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","छतमा फारोइ मोशालाइ हुइसि बिइ, “क्हेमैं ह्‍यासि याहवेहए सेवा लद्! क्हेमैंए च्हमिरिमैं नेरो कोलोमैं या क्हेमैंने ह्‍यारिगे, दिलेया र-क्युमैं नेरो खेदोमैं मत्‍त्रे वाथेंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","छबिमा मोशाइ बिइ, “ङिए याहवेह परमेश्‍वरए ल्हागिर ख्रो पिंबर ङिए योर ख्रो पिंबै सैमैं नेरो मिइ ख्रोंबै ख्रोमैं हिइ बोल् पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","खेदोमैं न्होंर्बै को-कोइ ङिइ ह्रोंसए याहवेह परमेश्‍वर म्हाँदिबर ख्रो पिंल् त्हुम्। ङि चर आफेन् समा याहवेहए मिंर तो तो ख्रो पिंल् त्हुम् बिसि ङिइ आसे। छतसि ङिए खेदोमैं ङिने बालुन् बोयाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","दिलेया याहवेहजी फारोए सैं सारो लमिंमा फारोइ चमैं ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","फारोइ मोशाने बिइ, “ङ ङाँइँले ह्‍याद्। न्ह क्रो मिं क्रोले टिसि ङए ओंसों धबै आखो। तलेबिस्याँ क्हिइ ङए लि ङ्ह्‍योबै त्हिंइर्न क्हि सिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","मोशाइ बिइ, “क्हिइ बिब् धोंलेन् तरिगे, ङ धबै क्हिए लि खोंयोंन् बिलै ङ्‍ह्‍योरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","झाइले याहवेहजी मोशाने बिइ, “ङइ धबै थेबै दुःख घ्रि फारो नेरो मिश्रफिर कुलब्मुँ। च लिउँइँ चइ क्हेमैं च ह्‍युलउँइँले छेनाले ह्‍याल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","तारे ताँन् मुइँमैं नेरो च्हमिरिमैंइ ह्रों-ह्रोंसए ङ्‍हेब् ट्हुब्मैंने मारा चाँदिए घानामैं ह्रिद् बिसि क्हिए म्हिमैंने बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","झाइले याहवेहजी मिश्रीमैंइ च इस्राएलीमैंलाइ मान लबै सैं पिंइ। धै मिश्र ह्‍युलर्बै फारोए के लब्मैं नेरो समाजर्बै म्हिमैंइ मोशा बेल्‍ले थेबै म्हि मुँन बिसि मैंइ। ");
INSERT INTO gvr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","छतसि मोशाइ फारोने बिइ, “‘म्हुँइँस आधाजरे ङ मिश्रए म्हाँजोउँइँले तसि ह्‍याब्मुँ’ बिसि याहवेहजी बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","‘राजगद्दिर टिबै फारोए च्ह थेबउँइँले किंसि ह्रेंदो प्ह्रोबै केब्स्योए च्ह थेब, खेदोमैंए ओंसों फिबै प्हसेमैं नेरो मिश्रर्बै च्ह थेब समा ताँन् सिब्मुँ। धबै खेदोमैंए ओंसों फिब्मैं या ताँन् सिब्मुँ ");
INSERT INTO gvr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","मिश्रर ओंसों खोंयोंइ आथेबै क्रोबै कै थेब्मुँ, छाबै कै धबै थेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","छान् तलेया खेदोमैंए बिरोधर मुँले म्हिमैंए बिरोधर मुँले इस्राएलीमैंए म्हाँजोर नगि घ्रि या छुरिब् आरे। छतमा याहवेहजी मिश्रीमैं नेरो इस्राएलीमैंए म्हाँजोर फेलमन बिसि क्हेमैंइ सेब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","झाइले मोशाइ म्रुँने बिइ, “क्हिए के लब्मैं ङ ङाँर खसि फ्योसि ‘क्हि नेरो क्हिए लिलि ल्हैदिबै ताँन् म्हिमैं त्होंह्‍याद्!’ बिब्मुँ। च लिउँइँ ङ त्होंह्‍याब्मुँ।” च्हौ बिसि मोशा बेल्‍ले ह्रिस खसि फारोउँइँले त्होंह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","“मिश्रर ङए औदिबै केमैं ल्हें तदै ह्‍यारिगे बिसि फारोइ क्हिए ताँ थेरिब् आरे,” बिसि याहवेहजी मोशाने बिल। ");
INSERT INTO gvr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","मोशा नेरो हारूनइ औदिबै केमैं ताँन् फारोए उँइँर लइ। दिलेया याहवेहजी फारोए सैं सारो लमिंसि चइ इस्राएलीमैं ह्रोंसए ह्‍युलउँइँले ह्‍याल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","मिश्र ह्‍युलर याहवेहजी मोशा नेरो हारूनने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“चु म्हैंन क्हेमैंए ल्हागिर बर्षए ओंसोंबै म्हैंन तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","म्हैंनर्बै च्युगैंर क्हेमैं ताँनइ ह्रों-ह्रोंसए परवाए ल्हागिर ताँन् घराना अनुसार घ्रि-घ्रि र बोग्या पइ थेंरिगे बिसि इस्रालर्बै ताँन् म्हिमैंने बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","म्हि घ्रिए घरानार र बोग्या घ्रि चबै म्हि च्युगुदे तस्याँ चइ ह्रोंसए ङ्‍हेब् ट्हुब्मैंने म्हिमैं च्योसे क्ह्रिरिगे। ताँन् म्हिमैंइ कति चम् बिसि र बोग्या च्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","क्हेमैंइ त्हाँबै खेदो, र मुँले क्यु मुँले तोइ खोट आरेबै तिदिंर्बै पइ खो। ");
INSERT INTO gvr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","क्हेमैंइ च बोग्या म्हैंनर्बै च्युसे प्लिगैं समा थेंसि इस्राएलर्बै ताँन् म्हिमैंइ च ङेसा छजँ सैल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","झाइले खा-खाबै धिंर च ख्रोए से चमुँ, चमैंइ च को म्राए न्होंरि फिरि नेरो क्होवाइ फोरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","चमैंइ च म्हुँइँसर्न चए से मिर ख्रोंसि प्लेढा आझोंबै क्हें नेरो काँबै पिंट्हाने चरिगे ");
INSERT INTO gvr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","च से स्युन् आचद्, क्युर ख्वालसि आङिं, चए क्र प्हलेमैं नेरो न्होंर्बै सेमैं ताँन् बालुन मिर ख्रोंसि चद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","च से न्हाँग समा आथेंन्, न्हाँग समा तोइ ङैस्याँ मिर ख्रोंवान्। ");
INSERT INTO gvr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","चु याहवेहजी दुःखउँइँले फ्रेमिंबै चाड ग। छतसि क्हेमैंइ फगि खिसि, प्हलेर जुत्ता खिसि, योर प्हरे किंसि यु-युनले चद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“च म्हुँइँसर ङ मिश्र तसि ह्‍याब्मुँ, धै मिश्रर्बै म्हि नेरो खेदोए ओंसों फिब्मैं सैवाब्मुँ, धै मिश्रर्बै ताँन् देवतामैंए बिरोधर ङइ निसाफ लब्मुँ। तलेबिस्याँ ङ याहवेह ग। ");
INSERT INTO gvr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","क्हेमैं टिबै धिंजरे च को क्हेमैंए ल्हागिर चिनु तब्मुँ। ङइ च को म्रोंसि क्हेमैंलाइ तोइ आलल्‍ले पिवाब्मुँ, ङइ मिश्रीमैं नास लमा क्हेमैंए फिर तोइ दुःख तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","च चाड क्हेमैंए ल्हागिर म्‍लेसे म्‍लेल् आखाँबै त्हिंइ तब्मुँ, क्हेमैंइ च त्हिंइ याहवेहए ल्हागिर चाड म्हाँदिब्मुँ। क्हेमैंइ चु चाड पुस्ता पुस्ता समा लिउँज्यै या खोंयोंन् बिलै म्हाँदिब्रें लद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","“क्हेमैंइ ङिगैं समा प्लेढा आझोंबै क्हें चद्। ओंसोंबै त्हिंइर्न क्हेमैंइ ह्रों-ह्रोंसए धिंउँइँले ताँन् प्लेढा भ्योंवाँन्। तलेबिस्याँ खाबइ ओंसोंबै त्हिंइउँइँले ङिगैं समा प्लेढा झोंबै क्हें चमुँ च म्हि इस्राएलउँइँले तेवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ओंसोंबै त्हिंइर नेरो ङिगैंर्बै त्हिंइर क्हेमैं खागु तसि ङए सेवा लद्। च त्हिंइ ङ्हिंर ताँन् म्हिमैंइ ह्‍योब् तेबै के मत्‍त्रे लद् अरू तोइ आलद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","क्हेमैंइ प्लेढा आझोंबै क्हें चबै चाड म्हाँदिब्ब्रें लद्। तलेबिस्याँ चु त्हिंइर्न ङइ क्हेमैंए टोलि-टोलिलाइ मिश्रउँइँले पखब् ग। छतसि क्हेमैंइ चु चाड पुस्ता पुस्ता समा लिउँज्यै या खोंयोंन् बिलै म्हाँदिल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","ओंसोंबै म्हैंनए च्युसे प्लिगैंए ङेसउँइँले ङ्हिच्युसे तिगैंए ङेसा समा प्लेढा आझोंबै क्हें चद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","क्हेमैंए धिंर ङिगैं समा क्हेंर झोंबै प्लेढा थेंल् आत। खाबज्यै प्लेढा झोंबै सै चस्याँ च आगुए ह्‍युलर्बै म्हि मुँलेया इस्राएली मुँलेया च इस्राएलीमैं ङाँइँले तेवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ङिगैं समा क्हेमैंइ प्लेढा झोंबै क्हें आचद्। क्हेमैं खनिर टिलेया प्लेढा आझोंबै क्हें चल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","झाइले मोशाइ इस्राएलर्बै ताँन् चिबनाँब्मैं हुइबर चमैंलाइ कुलसि छ बिइ, “ह्‍यासि ह्रों-ह्रोंसए परवा अनुसार घ्रि-घ्रि र-क्यु तो मुँलेया तेसि दुःखने फ्रेबै चाडर ख्रो पिंबर त्हाँसि सैद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","हिसप धुँए ला भाँडार्बै कोर प्ल्हुँसि म्राए क्होवाइ नेरो त्हो ङ्हिंर प्राद्। क्हेमैं न्होंर खाबै या न्हाँग समा धिंर्बै म्राउँइँले बैरु आत्होंन्। ");
INSERT INTO gvr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","याहवेह मिश्रीमैं ल्हिबर चमैंए ह्‍युलजरे ह्‍यामा म्रा फिर नेरो त्हो ङ्हिंर खीजी को म्रोंब्मुँ झाइले च म्रा वाथेंसि नास लबै सै क्हेमैं सैबर धिं न्होंर होंल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","क्हेमैंइ चु ताँ खोंयोंन् बिलै तरिबै रोस घ्रि धोंले ह्रोंस नेरो ह्रोंसए लिउँइँबै सन्तानए ल्हागिर म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","याहवेहजी बाछा फैसि पिंम् बिबै ह्‍युलर क्हेमैं होंमा क्हेमैंइ चु चाड म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","क्हेमैंए च्ह-च्हमिमैंइ ‘चु चाडए अर्थ तो जा’ बिसि ङ्योएस्याँ, ");
INSERT INTO gvr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","‘चु याहवेहजी दुःखउँइँले फ्रेमिंबै चाडए ख्रो ग। मिश्रर मुँबै इस्राएलीमैंए धिंजरे ह्‍यासि खीजी मिश्रीमैंलाइ ल्हिमा ङ्योए धिं पिथेंल।’” च ताँ थेसि म्हिमैं ताँनइ क्र कुरसि खीए सेवा लइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","झाइले याहवेहजी मोशा नेरो हारूनने बिब् धोंले इस्राएलीमैंइ ताँन् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","झाइले राजगद्दिर टिबै फारोए च्ह थेबउँइँले किंसि झेलर मुँब्मैंए च्ह थेब, खेदोमैंए ओंसो फिब नेरो मिश्रर्बै च्ह थेब्मैं ताँन् याहवेहजी च म्हुँइँस आधार सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","फारो चए के लब्मैं नेरो मिश्रीमैं ताँन् म्हुँइँसर्न रेइ। मिश्रर बेल्‍ले क्रोब्-म्होब तइ, तलेबिस्याँ चर च्ह थेब आसिबै धिं घ्रि या आरेल। ");
INSERT INTO gvr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","छतमा फारोइ म्हुँइँसर्न मोशा नेरो हारून हुइबर कुलसि बिइ, “क्हेमैं नेरो इस्राएलीमैं ताँन् ङए म्हिमैंए म्हाँजोउँइँले त्होंइ ह्‍याद्, धै क्हेमैंइ बिब् धोंलेन् याहवेहए सेवा लद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","क्हेमैंइ बिब् धोंलेन् ह्रों-ह्रोंसए र-क्यु नेरो खेदोमैं किंसि ह्‍याद्। ङलाज्यै आशिक पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","मिश्रीमैंइ इस्राएलीमैंलाइ युनन् खेंमैंए ह्‍युलउँइँले कुलबै सैं लइ। “चुमैंलाइ युनन् आकुलस्याँ ङि ताँन् सिब्मुँ,” बिसि चमैंइ बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","छतमा इस्राएलीमैंइ ह्रों-ह्रोंसए चेंबै प्रोर प्लेढा आझोंबन् थेंसि चमैंइ ह्रों-ह्रोंसए प्रो चेंबै भाँडामैं क्वेंर म्होरसि प्हैंदर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","मोशाइ बिब् धोंले इस्राएलीमैंइ लइ, चमैंइ मिश्रीमैंने मारा चाँदिए घाना नेरो क्वेंमैं या ह्रिइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","याहवेहजी मिश्रीमैंइ इस्राएलीमैंए फिर ल्हयो खन् लमिंइ। छतमा चमैंइ ह्रिबै ताँन् सै मिश्रीमैंइ पिंइ। छले चमैंइ मिश्रीमैंए सै न्होर बोयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","इस्राएलीमैं रामसेसउँइँले प्रसि सुक्‍कोत बिबै क्ल्ह्‍योर ह्‍याइ। प्हलेइ प्रब्मैं च्हमिरिमैं नेरो कोलोमैं पिसि लाख टुदे मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","चमैंने बालु अरू म्हिमैं र-क्यु नेरो खेदोमैं या बोइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","चमैंइ ह्रोंसने बालु मिश्रउँइँले पखबै चेंबै प्रोला प्लेढा आझोंल्‍ले क्हें बनेइ। तलेबिस्याँ चमैं मिश्रउँइँले ल्हामा ह्रोंसए ल्हागिर चबै सैमैं बनेबै त्हे आयोंल। ");
INSERT INTO gvr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","इस्राएलीमैं मिश्रर प्लिब्रासे सोंच्यु बर्ष समा टिल। ");
INSERT INTO gvr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","प्लिब्रासे सोंच्यु बर्ष तबै त्हिंइर्न याहवेहए ताँन् म्हिमैं मिश्रउँइँले त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","मिश्रउँइँले चमैं तेइ पखबर च म्हुँइँसर याहवेह न्हरु आच्हुइल्‍ले चमैं म्रोंइ। छतसि इस्राएलीमैं या च म्हुँइँसर न्हरु आच्हुइल्‍ले पुस्ता पुस्ता समा याहवेहए मान लरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","याहवेहजी मोशा नेरो हारूनने बिइ, “दुःखउँइँले फ्रेमिंबै चाडर लल् त्हुबै ताँमैं चुन् ग: आगुए ह्‍युलर्बै म्हिमैंइ ख्रो पिंबै सेमैं आचरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","दिलेया किंसि पखबै केब्छैंमैंइ ज्युर चिनु लल् खाँइ बिस्याँ च चरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","आगुए ह्‍युलर्बै म्हि नेरो नों सै फोसि थेंबै केब्छैंइ च आचरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“चब् थुँब् ह्‍योब् तेब् लबै धिंर्न च चल् त्हुम्, चए से धिंउँइँले बैरु आबोद्, चए ह्रुइब घ्रि या आचोद्। ");
INSERT INTO gvr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","इस्राएलर्बै ताँन् म्हिमैंइ चु ताँमैं ललन् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","दिलेया क्हिने बालु आगुए ह्‍युलर्बै म्हि खाबै मुँस्याँ, चइ दुःखउँइँले फ्रेमिंबै चाड म्हाँदिबै सैं लस्याँ चए धिंर्बै ताँन् मुँयुँमैंइ ट्हुबिर चिनु लल् त्हुम्। छलमा चइ च ह्‍युलर्न फिब धोंले च चाड म्हाँदिल् खाँम्। ट्हुबिर चिनु आलबै म्हिइ च आचरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","च ह्‍युलर्बै म्हिमैं नेरो आगुए ह्‍युलर्बै म्हिए ल्हागिर ठिम घ्रिन् म्हाँदिल् त्हुब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","याहवेहजी मोशा नेरो हारूनने बिब् धोंलेन् ताँन् इस्राएलीमैंइ लइ। ");
INSERT INTO gvr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","याहवेहजी इस्राएलीमैंलाइ टोलि-टोलि लसि मिश्रउँइँले च त्हिंइर्न तेसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“इस्राएलीमैं न्होंर्बै म्हिमैंए च्ह थेब्मैं नेरो खेदोए ओंसों फिबै त्होब ङल् ग। छतसि ङलाइ पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","झाइले मोशाइ म्हिमैंने बिइ, “क्हेमैं केब्छैं तसि टिबै मिश्र ह्‍युलउँइँले त्होंइ खबै चु त्हिंइ क्हेमैंइ मैंथेंन्, तलेबिस्याँ याहवेहजी ह्रोंसए योए शक्‍तिजी क्हेमैं च क्ल्ह्‍योउँइँले तेइ पखइ। च त्हिंइर प्लेढा झोंबै क्हें आचद्। ");
INSERT INTO gvr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","आबीब म्हैंनर्बै तिंयाँबै त्हिंइर क्हेमैं मिश्र ह्‍युलउँइँले त्होंइ ह्‍यासिन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","याहवेहजी क्हेमैंने कनानी, हित्ती, एमोरी, हिव्वी नेरो यबूसीमैंए ह्‍युल अथवा ङ्‍हे नेरो क्वे खुदु बगेबै ह्‍यु‍लर पखब्मुँ, च ह्‍युल खीजी क्हेमैंए खेमैंने पिंम् बिसि ओंसों बाछा फैल, छतसि चु म्हैंनर चु चाड म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","क्हेमैंइ ङिगैं समा प्लेढा आझोंबै क्हें चद्, धै ङिगैंर याहवेहए ल्हागिर चाड म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ङिगैं समा प्लेढा आझोंबै क्हें चद्। क्हेमैंए साँद न्होंरै या प्लेढा झोंबै चब सैमैं नेरो सोडामैं म्रोंल् आता; क्हेमैंए ह्‍युलर या आयोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","च चाड म्हादिबै त्हिंर ‘मिश्रउँइँले त्होंइ खमा याहवेहजी ङए ल्हागिर लमिंबै केमैं मैंबै ल्हागिर चु चाड म्हाँदिब् ग,’ बिसि क्हेमैंइ ह्रोंसए च्हमैंने बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","याहवेहजी ह्रोंसए शक्‍तिए योजी मिश्रउँइँले क्हेमैं तेइ पखब् ग। छतसि याहवेहजी पिंबै ठिमर्बै ताँमैं क्हेमैंए सुँर तरिगे बिसि क्हेमैंए ल्हागिर योर नेरो ङ्‍होए ओंसों क्हेमैंलाइ मैंल् लमिंबै चिनु तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","बर्ष ह्रोंसे तोक्दिबै त्हेर चु चाड म्हाँदिब्ब्रें लद्। ");
INSERT INTO gvr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“याहवेहजी क्हेमैं नेरो क्हेमैंए खेमैंने कसम चसि क्रें (बाछा) लब् धोंले कनानीमैंए ह्‍युलर क्हेमैंलाइ बोसि च ह्‍युल क्हेमैंलाइ पिंसि। ");
INSERT INTO gvr_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","क्हेमैं ताँनइ च्ह थेब याहवेहलाइ पिंन्। क्हेमैंए खेदोमैंइ ओंसों फिबै त्होबामैं या ताँन् याहवेहए ल्हागिर्न तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","दिलेया गदाए ओंसों फिबै प्हसेलाइ क्यु प्हसे घ्रि पिंसि खामिंन्। छले आखाबिय्याँ चए खरि चोमिंन्। ह्रोंसए च्हमैं न्होंर च्ह थेबै या खाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","प्हँना लिउँइँ क्हेमैंए च्हमैंइ तले छ लब् जा बिसि क्हेमैंने ङ्योए बिस्याँ, च त्हेर क्हेमैंइ चमैंने छले बिद्, ‘याहवेहजी ङिलाइ केब्छैं तसि टिल् त्हुबै मिश्र ह्‍युलउँइँले ह्रोंसए शक्‍तिए योजी तेइ पखमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","च त्हेर फारोइ सैं सारो लसि ङिलाइ ह्‍याल् आपिं, छतमा याहवेहजी मिश्रर ताँन् म्हि नेरो खेदोए ओंसों फिब्मैं सैवाइ। छतसि ओंसों फिबै त्होबामैं याहवेहए ल्हागिर ख्रो पिंमुँ, धै ङए च्हमैं न्होंर्बै च्ह थेबलाइ या ख्रो पिंसि खाम्। ");
INSERT INTO gvr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","चु याहवेहजी ङिलाइ ह्रोंसए शक्‍तोए योजी मिश्रउँइँले तेइ पखमिंइ बिसि क्हेमैंए ल्हागिर योर मुँबै चिनु, नेरो ङ्‍होर मुँबै चिनु घ्रि तब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","फारोइ च म्हिमैं ह्‍याल् पिंमा पलिश्तीमैंए ह्‍युलए घ्याँउँइँले ह्‍यामा रिन्ठि तलेना परमेश्‍वरजी चमैंलाइ च घ्याँउँइँले आपख। तलेबिस्याँ “चु म्हिमैंइ ल्हडें म्रोंसि मिश्रर्न एह्‍यालै,” बिसि परमेश्‍वरजी बिल। ");
INSERT INTO gvr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","छतसि परमेश्‍वरजी चमैंलाइ स्युरसि म्हि आटिबै क्ल्ह्‍योए घ्याँउँइँले ओल्ग्या मा ङ्युँइर बोमा। इस्राएलीमैं ल्हडें लब् तयार तरिगे बिसि मिश्रउँइँले त्हों ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ओंसों ओंसों योसेफइ इस्राएलीमैंने “परमेश्‍वरजी क्हेमैंए ल्हागिरि क्‍ह्रोसेन्ले ल्होमिंब् मुँ। च त्हेर क्हेमैंइ ङए ह्रुइबमैं छुउँइँले बोयाद्,” बिसि चु ताँर कसम चबर ल्हैदिल। छतसि मोशाइ योसेफए ह्रुइबमैं बोसि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","इस्राएलीमैं सुक्‍कोतउँइँले ह्‍याबै लिउँइँ म्हि आटिबै क्ल्ह्‍योए ङाँर एथाम् बिबै नाँसर प्ह्रों बनेसि बास टिइ। ");
INSERT INTO gvr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","झाइले चमैं त्हिंइ म्हुँइँस प्रल् खाँरिगे बिसि चमैंलाइ घ्याँ तेंबर याहवेह त्हिंइर न्हाँम्स्योए त्हो, नेरो म्हुँइँसर मिए राब तसि चमैंए ओंसों-ओंसो ह्‍यामल। ");
INSERT INTO gvr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","छले परमेश्‍वर त्हिंइर न्हाँम्स्योए त्हो तसि, धै म्हुँइँसर मिए राब तसि म्हिमैंए ओंसों-ओंसों ह्‍याब खोंयोंन् बिलै आपि। ");
INSERT INTO gvr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","झाइले याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“इस्राएलीमैं एसि मिग्दोल नेरो काँसए घारि मुँबै मा ङ्युँइ म्हाँजोर पि-हहिरोत ङाँर बाल सेफोनए ओंसों प्ह्रों बनेसि टिरिगे बिसि लैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","‘चमैं अलमल् तसि ह्‍युल स्युररिइमा म्हि आटिबे क्ल्‍ह्‍योर चमैं क्वेथेइँमुँ,’ बिसि फारोइ इस्राएलीमैंए बारेर मैंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ङइ फारोए सैं सारो लमिंब्मुँ धै चइ इस्राएलीमैं ल्हाब्मुँ। दिलेया फारो नेरो चए ताँन् सिपाइमैंउँइँले ङए मिं थेब् तल् योंब्मुँ। छतमा मिश्रीमैंइ ‘ङन् याहवेह ग।’ बिसि सेब्मुँ।” याहवेहजी छले बिमा इस्राएलीमैंइ छान् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","झाइले मिश्रर्बै म्रुँइ च म्हिमैं भौदिह्‍याबै ताँ थेसि च नेरो चए के लब्मैंए सैं प्लिंयाइ धै “ङ्योइ तो लगे? ङ्योइ इस्राएलीमैंलाइ ह्‍याल् पिंइ, ङ्योए केबछैंमैं ह्‍याइ!” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","छ तसि चइ रथ तयार लसि ह्रोंसए सिपाइमैं बोइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","चइ छ्याँ-छ्याँबै टुब्रा रथमैं नेरो मिश्रर्बै अरू रथमैं धै च ताँनए फिर्बै अफिसरमैं या किंसि बोइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","इस्राएलीमैं सैं भोंन्ले घ्याँर प्ररिल, दिलेया याहवेहजी मिश्रर्बै फारो म्रुँए सैं सारो लमिंमा चइ चमैंए लिलि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","झाइले मिश्रीमैं, फारोए घोडामैं ताँन्, रथ, चए घोडा क्रेब्मैं नेरो सिपाइमैंइ इस्राएलीमैं ल्हाबोमा पि-हहिरोतए ङाँर बाल सेफोनए ओंसों मा ङ्युँइए छ्योगोर प्ह्रों बनेसि टिबै त्हेर्न चमैंलाइ स्याइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","झाइले इस्राएलीमैंइ ङ्‍ह्‍योमा फारो नेरो मिश्रीमैं खेंमैंए लिलि खरिब् म्रोंसि चमैं बेल्‍ले ङ्हिंसि याहवेहने ग्वार ह्रिइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","चमैंइ मोशाने बिइ, “मिश्रर छगोंमैं आरेल् वा? क्हिइ चु क्यु आयोंबै क्ल्ह्‍योर ङि सिबर पखल् वा? ङि मिश्रउँइँले पखसि खैइ तब् ङे? ");
INSERT INTO gvr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ङि मिश्रर मुँमा ङिइ क्हिने मिश्रीमैंए केब्छैंन् तसि ङि टिल् पिंन् बिब आङिं वा? क्यु आयोंबै क्ल्ह्‍योर सिब भन्दा ङि मिश्रीमैंए केब्छैंन् तसि टिब छ्याँब तमल।” ");
INSERT INTO gvr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","मोशाइ इस्राएलीमैंने बिइ, “क्हेमैं आङ्हिंन्ले सैं भोंब लद्। ङ्ह्‍योद्! याहवेहजी तिंयाँ क्हेमैंलाइ मिश्रउँइँले फ्रेमिंब्मुँ। चु मिश्रीमैं क्हेमैंइ तिंयाँ म्रोंइमुँ, तारे क्हेमैंइ धबै चमैंलाइ खोंयोंन् बिलै म्रोंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","याहवेहन् क्हेमैंए ल्हागिर नेमिंब्मुँ। छतसि क्हेमैं सैं भोंन् लसि तोइ आलले टिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","याहवेहजी मोशाने बिइ, “क्हिइ तले ङने ग्वार ह्रिल? इस्राएलीमैंने ओंसों प्रबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ह्रोंसए योइ प्हरे क्वेसि मा ङ्युँइउँइँ (समुद्रउँइँ) स्योंन्। धै मा ङ्युँइ ङ्हिंबाँतमा इस्राएलीमैं चए म्हाँजोउँइँले ओबनो क्ल्ह्‍योर प्रसि ह्‍याल् खाँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ङइ मिश्रीमैंए सैं सारो लमिंब्मुँ, धै चमैं क्हेमैंए लिलि ल्हैदिब्मुँ। दिलेया फारो नेरो चए ताँन् सिपाइमैं चए रथमैं नेरो चए घोडा क्रेब्मैंउँइँले ङए महिमा तल्मिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","फारो, चए रथमैं नेरो चए गोडा क्रेब्मैंलाइ ङइ ट्होवामा मिश्रीमैंइ ङन् याहवेह ग बिबै ताँ सेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","झाइले इस्राएलर्बै सिपाइमैंए ओंसों-ओंसों प्रबै परमेश्‍वरए दूत स्योसि चमैंए लिग्याँइ ह्‍याइ, धै न्हाँम्स्योए त्हो या चमैंए ओंसोंउँइँले स्योसि चमैंए लिग्याँइ राइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","मिश्रीमैंए सिपाइमैं नेरो इस्राएलीमैंए सिपाइमैंए म्हाँजोर न्हाँम्स्यो खसि म्हुँइँस तिमि तिराइ मि आम्रोंब् तइ धै अर्को क्ल्ह्‍योइ मि म्रोंब् लमिंइ। छतमा चमैं म्हुँइँसतिमि घ्रि घ्रिए ङाँर खल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","झाइले खीजी बिब् धोंलेन् मोशाइ ह्रोंसए यो मा ङ्युँइए फिर स्योंइ, धै याहवेहजी म्हुँइँसतिमि स्यारउँइँले खैं कुल्मिंसि मा ङ्युँइर्बै क्युलाइ लिग्याँइ स्योमिंमा क्यु ङ्हिंबाँ तसि मा ङ्युँइर (समुद्र) कारा क्ल्ह्‍यो तयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","धै चमैंए क्योलो नेरो त्हेब्रे हार चमैंए ल्हागिर क्यु बान्‍नो तइ, छतमा इस्राएलीमैं मा ङ्युँइए म्हाँजोउँइँले कारा क्ल्ह्‍योर प्रसि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","मिश्रीमैं, फारोए घोडामैं, रथमैं, नेरो घोडा क्रेब्मैंइ चमैंलाइ मा ङ्युँइए (समुन्द्रए) न्हों-न्होंन् ल्हाबोइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","झाइले च म्हुँइँसर याहवेहजी मिश्रीमैंए सिपाइमैंलाइ मि नेरो न्हाँम्स्योए त्होउँइँले ङ्‍ह्‍योइ, धै मिश्रीमैंए सिपाइमैं अलमल् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","खीजी चमैंए रथए पाङ्ग्रामैं प्ल्हमिंमा चमैंइ च ओलेबर गारो तइ। छतमा मिश्रीमैंइ बिबर होंइ, “ङ्यो इस्राएलीमैंउँइँले भौदिह्‍याले, तलेबिस्याँ याहबेह चमैंए ख तसि ङ्योए बिरोधर नेरिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","झाइले याहवेहजी मोशाने बिइ, “मिश्रीमैंए रथमैं नेरो घोडा क्रेब्मैंए फिर च क्यु धबै बडिइ युरिगे बिसि क्हिए यो मा ङ्युँइए (समुन्द्रए) फिर स्योंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","मोशाइ ह्रोंसए यो मा ङ्युँइए (समुन्द्रए) फिर स्योंइ, धै न्हाँगर मि म्रोंमा मा ङ्युँइ धबै एसि ह्रोंसए क्ल्ह्‍योर एखइ। मिश्रीमैं भौदिबर होंमा याहवेहजी चमैं मा ङ्युँइर्न भ्योंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","क्यु एइ खसि रथमैं, घोडा क्रेब्मैं इस्राएलीमैंए लिलि खबै फारोए सिपाइमैं, ताँन् क्युइ हुवाइ, चमैं न्होंर घ्रि या आसो। ");
INSERT INTO gvr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","दिलेया इस्राएलीमैं बिस्याँ मा ङ्युँइए म्हाँजोउँइँले कारा क्ल्ह्‍योर प्रसि ह्‍याइ। चमैंए क्योलो नेरो त्हेब्रेउँइँ क्यु बान्‍नों तइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","च त्हिंइर याहवेहजी इस्राएलीमैंलाइ मिश्रीमैंए योउँइँले जोगेमिंइ। मिश्रीमैं बिस्याँ मा ङ्युँइए छेउर सिसि क्हुरिह्‍याब् इस्राएलीमैंइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","याहवेहजी मिश्रीमैंए फिर लमिंबै थेबै के इस्राएलीमैंइ म्रोंसि चमैंइ याहवेहने ङ्हिंइ, च त्हेसेरो चमैंइ याहवेह नेरो खीए केब्छैं मोशाए फिर बिश्‍वास लइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","झाइले मोशा नेरो इस्राएलीमैंइ याहवेहए ल्हागिर चु क्वे प्रिंइ: “ङ याहवेहए ल्हागिर क्वे प्रिंब्मुँ, तलेबिस्याँ खीजी थेबै लडें लसि ट्होइमुँ। खीजी घोडा नेरो चए फिर क्रेब्मैं मा ङ्युँइर (समुन्द्रर) भ्योंमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","याहवेहन् ङए शक्‍ति ग, ङलाइ जोगेमिंब खीन् ग, छतसि ङ खीलाइ क्वे प्रिंब्मुँ। खी ङए परमेश्‍वर ग, ङ खीए सेवा लब्मुँ, खी ङए खेमैंए परमेश्‍वर ग, ङ खीए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","याहवेहन् ल्हडेंर नेमुँ, खीए मिं याहवेह ग। ");
INSERT INTO gvr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“खीजी फारोए रथमैं नेरो चए सिपाइमैं या मा ङ्युँइर भ्योंमिंइमुँ। फारोए धाँसे थेबै चिबनाँब्मैं ओल्ग्या मा ङ्युँइर (समुद्रर) प्ल्हुँयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","गैरु क्युइ चमैंलाइ हुवाइ। चमैं युँमा धोंले गैरुर प्ल्हुँयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“ओ याहवेह, क्हिए क्योलो यो बेल्‍ले भोंब् मुँल। ओ याहवेह, क्हिए क्योलो योइ शत्तुरमैं त्हुला भुँ लवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","क्हिजी ल्हडेंर ट्होवाँइले क्हिए बिरोधर राब्मैं क्युरु खारमिंइ। क्हिजी ह्रोंसए मि धोंबै ह्रिस उँइँमिंइ, च ह्रिसइ चमैंलाइ पराल धोंले ख्रोंवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","क्हिए नखुँर्बै सोइ फुइमा क्युए थुप्रो तयाइ। प्ल्होंखबै क्यु क्ल्ह्‍यो घ्रिर्न थुप्रो तसि बान्‍नों धोंले राइ। गैरु क्यु मा ङ्युँइए म्हाँजोर चाँयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","शत्तुरइ बिइ, ‘ङइ चमैं ल्हासि स्याब्मुँ, लुडिबै सैमैं ङ चुब्मुँ, च लुडिबै सैमैंउँइँले तो लदा ङ्हाँमुँ च ङ किंब्मुँ। ङइ ङए सेलाँ (तरवार) ट्‍हुइसि चमैं सैवाब्मुँ।’ ");
INSERT INTO gvr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","दिलेया क्हिजी ह्रोंसए सो फुइमा मा ङ्युँइ (समुन्द्रइ) चमैं हुवाइ। बेल्‍ले भोंबै मा ङ्युँइर चमैं पैए सिसा धोंले प्ल्हुँयाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“ओ याहवेह, देवतामैं न्होंर क्हि धों तब खाब् मुँ? बेल्‍ले पबित्र, बेल्‍ले मान लल् त्हुब, औदिबै के लबर क्हि धों तब खाब् मुँ? ");
INSERT INTO gvr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","क्हिजी क्हिए क्योलो यो स्योंमा पृथ्‍बीइ चमैं क्ल्ह्‍योंवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","क्हिए खोंयोंन् बिलै आखाँबै म्हाँयार क्हिजी मिश्रउँइँले फ्रेमिंबै म्हिमैं डोरेब्मुँ। क्हिजी ह्रोंसए भोंउँइँले चमैं क्हिए पबित्र क्ल्ह्‍योर डोरेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ह्रें-ह्रेंमैंइ क्हिए बारेर थेसि त्हारब्मुँ। पलिश्त ह्‍युलर टिब्मैं ङ्हिंसि न्हुँ खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","एदोमर्बै क्र थेब्मैं ङ्हिंब्मुँ, मोआबर्बै चिब्मैं त्हारब्मुँ। कनानर टिबै ताँन् म्हिमैं भों आरेब् धोंन् तयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ओ याहवेह, क्हिए म्हिमैं क्योंजा अतर्दिन् समा क्हिजी मिश्रउँइँले फ्रेसि पखबै म्हिमैं क्योंजा आह्‍यान् समा, च ह्रेंमैं ङ्हिंसि त्हारमा क्हिए योर्बै भोंजी चमैं युँमा धोंले क्ल्ह्‍यो घ्रिर्न टिम्। ");
INSERT INTO gvr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","क्हिजी क्हिए म्हिमैं पखसि ह्रोंसए कोंर थेंब्मुँ। ओ याहवेह, च क्ल्ह्‍योर्न क्हिए ल्हागिर टिबै क्ल्ह्‍यो बनेइ, ओ याहवेह, च पबित्र क्ल्ह्‍यो क्हिए योजीन् बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","याहवेहजी खोंयोंइ बिलै ग्याल्स लरिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","इस्राएलीमैं मा ङ्युँइए म्हाँजोउँइँले क्यु आरेबै सर प्रसि ह्‍याइ, दिलेया फारोए घोडामैं, रथमैं नेरो घोडा फिर क्रेब्मैं मा ङ्युँइर (समुन्द्रर) होंमा याहवेहजी चमैं फिर मा ङ्युँइए क्यु एपखइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","छतमा अगमबक्‍तास्यो मिरियम, हारूनए आनाइ, योर खैंचडी किंमा ताँन् च्हमिरिमैं या खैंचडी किंसि सेदै चए लिलि त्होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","मिरियमइ छ बिदै क्वे प्रिंबर होंइ, “याहवेहए मिंर क्वे प्रिंले, तलेबिस्याँ खीजी औदिबै के लसि ट्होइमुँ। घोडा नेरो चए फिर क्रेब्मैं खीजी मा ङ्युँइर (समुन्द्रर) भ्योंवाइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","छ तबै लिउँइँ मोशाइ इस्राएलीमैं काँसए घारि मुँबै मा ङ्युँइउँइँले डोरेसि बोइ। चमैं शूर बिबै क्यु आरेबै क्ल्ह्‍योउँइँ ह्‍यामा चमैंइ सोंरो समा प्रमा चमैंइ क्यु आयों। ");
INSERT INTO gvr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","झाइले मारा बिबै क्ल्ह्‍योर त्होंखबै लिउँइँ चमैंइ मारार्बै क्यु थुँल् आखाँ, तलेबिस्याँ चर्बै क्यु काँब मुँल। (छतसि चए मिं मारा (काँब) तइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","छतसि म्हिमैंइ “ङि तो थुँब?” बिसि मोशाने गनगन लबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","छतमा मोशाइ याहवेह परमेश्‍वरने प्राथना लमा याहवेहजी चने सिंए म्हुँडा घ्रि उँइँमिंइ, धै चइ सिंए म्हुँडा क्युर झोंमा क्यु लिंब तइ। याहवेहजी च क्ल्ह्‍योर्न चमैंए छ्ह थोबै ल्हागिर ठिममैं पिंसि चर्न खीजी चमैंए जाँच लइ। ");
INSERT INTO gvr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","खीजी बिइ, “क्हेमैंइ ङए ताँ छेनाले थेसि ङइ बिबै ताँन् ताँमैं नेरो ङए ठिममैं म्हाँदिइ बिस्याँ, ङइ मिश्रीमैं फिर कुलब् धों तबै नब-छबमैं घ्रि या क्हेमैंए फिर कुलरिब् आरे, तलेबिस्याँ क्हेमैं सल् लबै याहवेह ङन् ग।” ");
INSERT INTO gvr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","झाइले चमैं एलीम बिबै क्ह्ल्योर फेखइ, चर च्युसे ङ्हिं क्युए मुल नेरो ङिच्यु खजूरए धुँमैं मुँल। चमैंइ च क्यु ङाँर्न प्ह्रों बनेसि टिइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","इस्राएलीमैं एलीमउँइँले प्रसि मिश्रउँइँले प्रबै म्हैंन ङ्हिंए च्युसे ङ्‍हगैंर एलीम नेरो सिनै बिबै कोंए म्हाँजोर मुँबै तोइ आरेबै सिनै बिबै क्ल्ह्‍योर फेखइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","चर फेखमा ताँन् म्हिमैं मोशा नेरो हारूनने गनगन लबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","इस्राएलीमैंइ चमैंने बिइ, “ङि मिश्रर याहवेहए योउँइँले सिस्याँ छ्याँब तमल। तलेबिस्याँ ङि चर ह्‍योबै भाँडोए कारग्युले क्हुँसि से नेरो अरू चबै सैमैं म्रेंन्ले चल् योंमल। दिलेया क्हेमैंइ ङि ताँन् फोतेंन् सैबर क्यु आयोंबै क्ल्ह्‍योर पखइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","छबिमा याहवेहजी मोशाने बिइ, “क्हेमैंए ल्हागिर ङइ स्वर्गउँइँले क्हें कुल्मिंब्मुँ। म्हिमैं त्हिंइ ह्रोंसे बैरु ह्‍यासि तिगैंर्बै छो योल्‍ले मत्‍त्रे खुरिगे। ङइ बिबै ताँ चमैंइ ङिमना उ आङिंमना बिसि ङइ जाँच लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","तेल् उँइँ खुब् भन्दा ट्हुगैंर चमैंइ ङ्हिछो तल्‍ले खुसि छेनाले थेंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","छतसि मोशा नेरो हारूनइ ताँन् इस्राएलीमैंने बिइ, “याहवेहजीन् क्हेमैंलाइ मिश्रउँइँले तेइ पखब् ग बिसि क्हेमैंइ तिंयाँबै ङेसर था सेब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","प्हँना न्हाँगर क्हेमैंइ याहवेहए चारबै ह्‍वे म्रोंब्मुँ, क्हेमैंइ याहवेहए बिरोधर गनगन लब खीजी थेइमुँ। ङि खाब् जा क्हेमैं ङिए बिरोधर गनगन लब? ङिम् खीजी बिब् धोंले प्रब्मैं मत्‍त्रे ग्।” ");
INSERT INTO gvr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","धबै मोशाइ बिइ, “याहवेहजी क्हेमैंलाइ ङेसर चबर से नेरो न्हाँगर म्रेंनाले क्हें पिंब्मुँ, तलेबिस्याँ क्हेमैंइ खीए बिरोधर गनगन लब खीजी थेइमुँ। ङि खाब् रो? क्हेमैंए चु गनगन ङिए बिरोधर आङिं, याहवेहए बिरोधर तइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","झाइले मोशाइ हारूनने बिइ, “इस्राएलर्बै ताँन् म्हिमैंने छ बिद्, ‘याहवेहए उँइँर खो, तलेबिस्याँ क्हेमैंइ लबै गनगन खीजी थेइमुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","झाइले इस्राएलर्बै ताँन् म्हिमैंने हारून छले पोंमा चमैंइ क्यु आयोंबै क्ल्ह्‍योउँइँ ङ्ह्‍योइ। छले ङ्ह्‍योमा न्हँम्स्योर याहवेहए चारबै ह्‍वे म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“इस्राएलीमैं गन गन लब ङइ थेइमुँ। क्हेमैंइ ङेसर से चल् योंब्मुँ, धै न्हाँगर क्हें म्रेंन्ले चल् योंब्मुँ। छले चल् योंमा ङ क्हेमैंए याहवेह परमेश्‍वर ग बिसि क्हेमैंइ सेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","च लिउँइँ ङेसर बट्टाइ नेमेमैं खसि चमैं टिबै ब्यारेक हुवाइ, धै न्हाँगर च ब्यारेकए कारग्युले शीत युरिइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","च शीत कारसि ह्रुइ धोंबै चबै सै तइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","इस्राएलीमैंइ च म्रोंसि खेंमैंए न्होंरि “चु सै तो जा?” बिबर होंइ, तलेबिस्याँ चमैंइ च सै तो जा बिसि आसेल। छतमा मोशाइ चमैंने बिइ, “चु याहवेहजी क्हेमैंए ल्हागिर पिंबै क्हें ग। ");
INSERT INTO gvr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","याहवेहजी ‘क्हेमैं ताँनइ ह्रोंसइ कति चमुँ च्हग खुद्,’ बिइमुँ। ‘परवार्बै म्हि घ्रिए ल्हागिर म्हन् ङ्हिंए दरइ खुद्।’” ");
INSERT INTO gvr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","इस्राएलीमैं छान् लइ, कोइइ ल्हें, कोइइ च्युगुदे खुइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","चमैंइ च चबै सै क्होंइँमा ल्हें खुब्मैंला ल्हें आत, च्युगुदे खुब्मैंलैया च्युगुदे आत। चमैं ताँनइ ह्रोंसइ चल् खाँब्दे खुइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","मोशाइ चमैंने बिइ, “खाबज्यै या च्हौदे ङैसि प्हँन्हाँग्धों समा आथेंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","दिलेया चमैं न्होंरि को-कोइइ मोशाए ताँ सैंर आथे, छतमा चमैंइ ह्रोंसइ चसि ङैब प्हँन्हाँग्धों समा थेंमा चर प्हुँलुँ तसि थाँ नाँबर होंइ। छाब् म्रोंसि मोशा चमैंने ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","छले न्हाँग ह्रोंसे चमैं ताँनइ खेंमैंइ चल् खाँब्दे खुइ, त्हिंयाँ चर्केबै लिउँइँ च क्हें युलियामल। ");
INSERT INTO gvr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ट्हुगैंर चमैंइ म्हि घ्रिए ल्हागिर सोदाजरे भन्दा ङ्हिछो तल्‍ले म्हन् प्लि खुमल। छलमा चमैं न्होंर्बै चिब्मैं खसि च ताँए बारेर मोशाने ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","झाइले मोशाइ चमैंने बिइ, “याहवेहजी लद् बिबै ताँ चुन् ग: ‘प्हन्हाँग प्रिबै (के आलबै) त्हिंइ ग, याहवेहए ल्हागिर म्हाँदिबै त्हिंइ ग। ह्‍योल् त्हुबै सैमै ह्‍योद्, प्लुल् त्हुबै सैमैं प्लुद्। ङैबै सैमैं प्हन्हाँगए ल्हागिर थेंन्।’” ");
INSERT INTO gvr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","मोशाइ बिब् धोंले चमैंइ ङैबै क्हें न्हाँग समन् थेंमा थाँ या आनाँ, प्हुँलुँ या आत। ");
INSERT INTO gvr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","धै मोशाइ बिइ, “च तिंयाँ चद्, तलेबिस्याँ तिंयाँ याहवेहए ल्हागिर प्रिबै त्हे ग। तिंयाँ क्हेमैंइ च चबै सै सर योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ट्हुगैं समा क्हेमैंइ च चबै सै खुद्, दिलेया ङिगैंर प्रिबै त्हिंइ ग, छतसि च त्हिंइर क्हेमैंइ तोइ योंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","दिलेया ङिगैंरै या चमैं न्होंर्बै को-कोइ च चबै सै खुबर ह्‍याइ, दिलेया चमैंइ तोइ आयोंल। ");
INSERT INTO gvr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","झाइले याहवेहजी मोशाने बिइ, “क्हेमैंइ खोंयों समा ङइ बिबै ताँमैं आङिं? ");
INSERT INTO gvr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","सैंर थेंन्, याहवेहजी क्हेमैंए ल्हागिर प्रिबै त्हिंइ पिंइमुँ। छतसि याहवेहजी क्हेमैंए ल्हागिर ट्हुगैंर ङ्हिरोबै क्हें पिंइमुँ। ङिगैंर क्हेमैं ताँन् खनिर मुँ चर्न टिरिद्, खाबै या ह्रोंसए धिंउँइँले बैरु आह्‍याद्।” ");
INSERT INTO gvr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","छतसि म्हिमैंइ ङिगैंर भों न्हइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","इस्राएलीमैंइ च क्हेंए मिं “मन्‍न” थेंइ। च धनिया प्लु धों तब तार्ग्या मुँल। धै च क्वे खुदुर बनेबै क्हें धोंले लिंब मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","मोशाइ बिइ, “क्हेमैंलाइ मिश्रउँइँले तेइ पखमा क्यु आयोंबै क्ल्ह्‍योर याहवेहजी क्हेमैंलाइ च चबै सै चल् पिंल। छतसि लिउँइँबै च्ह क्वें-क्वेंमिमैंइ म्रोंरिगे प्हना लिउँइँ समा मन्‍न ङ्हिम्न थेंन् बिसि खीजी बिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","च लिउँइँ मोशाइ हारूनने बिइ, “झोंबै भाँडो घ्रि किंसि चर ङ्हिम्ना मन्‍न झोंसि लिउँइँबै च्ह क्वें-क्वेंमिमैंइ म्रोंबै ल्हागिर तरिगे बिसि याहवेहए ओंसों थेंमिन्।” ");
INSERT INTO gvr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","याहवेहजी मोशाने बिब् धोंलेन् च मन्‍न खोंयोंइ बिले तरिगे बिसि हारूनइ ठिम थेंबै मुदुसए ओंसों मन्‍न थेंइ। च मन्‍न यहवेइ फैबै बाछा मुँबै युमा ङ्हि ओंसों थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","इस्राएलीमैं कनान ह्‍युलर फेनेसि टिबै तौदु आतन् समा चमैंइ मन्‍न चरिइ। ");
INSERT INTO gvr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(ओमेरे घ्रि, आधा पथि ग।) ");
INSERT INTO gvr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ताँन् इस्राएलीमैं सिनए क्यु आयोंबै क्ल्ह्‍योउँइँले याहवेहजी बिब् धोंलेन् क्ल्ह्‍यो-क्ल्ह्‍योर ह्‍यासि रपिदिम बिबै क्ल्ह्‍योर ब्यारेक लइ। चर चमैंइ प्ह्रों बनेइ, दिलेया चर म्हिमैंए ल्हागिर थुँबै क्यु आरेल। ");
INSERT INTO gvr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","छतमा चमैंइ मोशाने ह्रिस खसि बिइ, “ङिलाइ थुँबै क्यु पिंन्।” छबिमा मोशाइ चमैंने बिइ, “क्हेमैं तले ङने ह्रिस खमुँ? क्हेमैं तले याहवेहए जाँच लमुँ?” ");
INSERT INTO gvr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","दिलेया म्हिमैंलाइ क्यु पिइ, छतसि चमैंइ मोशाने बालु गनगन लइ, “क्हिइ ङि, ङिए प्हसेमैं नेरो खेदोमैं क्यु थुँल् आयोंल्‍ले सैबर तले मिश्रउँइँले चुर पखल?” ");
INSERT INTO gvr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","छबिमा मोशाइ याहवेहने “ङ चु म्हिमैंलाइ तो लब? चुमैंइ ङ युँमाइ ल्हिल् म्हैमुँ!” बिसि प्राथना लइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","छ लमा याहवेहजी मोशाने बिइ, “इस्राएलीमैंए चिबनाँब्मैं न्होंर्बै को-कोइ नेरो क्हिइ नील स्योंर ल्हिबै प्हरे योर किंसि म्हिमैंए ओंसो-ओंसों ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ङ होरेब मुँबै पारार क्हिए ओंसों राब्मुँ। क्हिइ पारार प्हरेइ ल्हिद्, छले ल्हिमा म्हिमैंइ थुँबै क्यु छाइले त्होंब्मुँ।” झाइले मोशाइ इस्राएलीमैंए चिबनाँब्मैंए ओंसों छान् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","याहवेह ङ्योए म्हाँजोर मुँ उ आरे बिसि इस्राएलीमैंइ आक्वेंसि प्होंगि कैगि लसि याहवेहए जाँच लइ, छतसि च क्ल्ह्‍योए मिं मोशाइ मस्साह नेरो मेरीबा थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","च लिउँइँ रपिदिम बिबै क्ल्ह्‍योर अमालेकीमैं खसि इस्राएलीमैंए फिर ह्‍वानेइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","छतमा मोशाइ यहूशूने बिइ, “अमालेकीमैंने नेबै ल्हागिर च्हौदे म्हिमैं त्हँसि नेबर ह्‍याद्। प्हन्हाँग याहवेहए प्हरे ङए योर किंसि ङ कोंए फिर राब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","मोशाइ बिब् धोंले यहोशूइ लइ, धै अमालेकीमैंने नेबर होंइ। मोशा, हारून नेरो हुर बिस्याँ कोंए फिर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","मोशाइ यो कैंडो क्वेरिमा इस्राएलीमैंइ ट्होमल। यो क्युरु लमा अमालेकीमैंइ ट्होमल। ");
INSERT INTO gvr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","मोशाए यो नारमा हारून नेरो हुरइ युँमा घ्रि पखसि चए न्होंर थेंमिंमा च चए फिर क्हुँइ। धै हारून नेरो हुरइ घ्रि तिराइ घ्रि तिराइ रासि चए ह्‍योरमिंइ। त्हिंयाँ आलिन् समा चए यो कैंडोन् क्वेरिइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","छलमा यहोशूइ अमालेकी सिपाइमैंलाइ सेलाँइ (तरवारइ) ल्हिसि तोइ आचैन् लवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","च लिउँइँ याहवेहजी मोशाने बिइ, “चु ताँ मैंबै ल्हागिर कापिर प्ह्रिथेंन्। ङइ चु ह्‍युलउँइँले अमालेकीमैंए मिं क्ह्रन् म्हवाम् बिसि यहोशूने बिद्।” ");
INSERT INTO gvr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","मोशाइ चर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि चए मिं “याहवेह ङए ताच्यैं (झन्डा) ग” थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","झाइले मोशाइ बिइ, “याहवेहए ताच्यैं क्वेद्! पुस्ता पुस्ता समा याहवेह अमालेकीमैंने नेमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","परमेश्‍वरजी मोशा नेरो खीए इस्राएली म्हिमैं मिश्रउँइँले तेइ पखमा चमैंए ल्हागिर तोन्दोंरि लबै केमैं मिद्यानर्बै खेगि यित्रो, मोशाए क्येंइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ओंसों मोशाइ ह्रोंसए प्ह्रेंस्यो सिप्पोरा मैता कुलइ। छतसि मोशाए क्यें यित्रोइ सिप्पोरा ");
INSERT INTO gvr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","नेरो चए च्ह ङ्हिं मोशा ङाँर पखइ। (च्ह घ्रिए मिं गेर्शोम मुँल, तलेबिस्याँ च फिबै त्हेर मोशाइ, “ङ आगुए ह्‍युलर टिबै म्हि तइमुँ,” बिल। छतसि च्हए मिं चइ गेर्शोम थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","अर्को च्हए मिं एलीएजर मुँल, तलेबिस्याँ मोशाइ, “ङए आबाए परमेश्‍वरजी ङलाइ ल्होमिंसि फारोए सेलाँउँइँले ङ जोगेमिंइ,” बिल। छतसि च्हए मिं चइ एलीएजर थेंइ।) ");
INSERT INTO gvr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","मोशाए च्हमैं नेरो प्ह्रेंस्यो पसि मोशाए क्यें यित्रो परमेश्‍वरए कों ङाँर मोशा टिबै क्यु आयोंबै क्ल्ह्‍योर खइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","यित्रोइ मोशाने, “ङ क्हिए क्यें यित्रो, क्हिए प्ह्रेंस्यो नेरो क्हिए च्ह ङ्हिं किंसि क्हि ङाँर खसिन् मुँ,” बिसि सउँसर कुलल। ");
INSERT INTO gvr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","छतसि मोशा ह्रोंसए क्येंने त्होबर ह्‍याइ, धै त्होसि क्येंलाइ फ्योइ, धै रासि म्वैं लइ। चमैंइ खें-खेंमैंए छ्याँब आछ्याँब ताँमैं ङ्योएसि मोशाए तम्बु न्होंर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","इस्राएलीमैंलाइ मिश्रउँइँले फ्रेमिंबर याहवेहजी फारो नेरो मिश्रीमैंए फिर लबै तोन्दोंरि ताँमैं नेरो इस्राएलीमैंइ घ्याँर तो-तो दुःख योंइ, धै याहवेहजी चमैंलाइ खैले जोगेमिंइ बिबै ताँमै ताँन् मोशाइ ह्रोंसए क्येंने बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","इस्राएलीमैं मिश्रीमैंए योउँइँले फ्रेसि पखमा चमैंए ल्हागिर याहवेहजी लबै छ्याँबै ताँमैं थेसि यित्रो सैं तोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","यित्रोइ बिइ, “मिश्रीमैं नेरो फारो म्रुँए योउँइँले क्हेमैं फ्रेमिंबै याहवेहए मिं थेब् तरिगे! खीजी ह्रोंसए म्हिमैंलाइ मिश्रीमैंए केब्छैंमैं तबइँले फ्रेमिंइ! ");
INSERT INTO gvr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","याहवेह ताँन् देवतामैं भन्दा थेब मुँन बिसि ङइ तोगो सेइ, तलेबिस्याँ मिश्रीमैंइ इस्राएलीमैंए फिर आछ्याँबै के लमा खीजी चमैंलाइ जोगेमिंइ।” ");
INSERT INTO gvr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","च लिउँइँ मोशाए क्यें यित्रोइ परमेश्‍वरए ल्हागिर मिइ ख्रोंबै ख्रो नेरो अरू भेटिमैं या पिंइ। झाइले हारून नेरो इस्राएलर्बै चिबनाँब्मैं मोशाए क्यें यित्रोने परमेश्‍वरए ओंसों क्हें चबर खइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","प्हन्हाँगधों मोशा म्हिमैंए निसाफ लबर टिमा न्हाँगउँइँले ङेसा समा म्हिमैं मोशाए कारग्युले टिइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","मोशाइ म्हिमैंए ल्हागिर लबै ताँन् केमैं मोशाए क्येंइ म्रोंसि चने ङ्योएइ, “क्हिइ चु म्हिमैंए ल्हागिर लबै के तो जा? क्हि घ्रि मत्‍त्रे तले निसाफ लबर टिरिमुँ? छलेन म्हिमैं न्हाँगउँइँले ङेसा समा तले क्हिए कारग्युले रारिमुँ?” ");
INSERT INTO gvr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","मोशाइ ह्रोंसए क्येंने बिइ, “म्हिमैं ङ ङाँइँले परमेश्‍वरए इच्छा क्होबर खम्। ");
INSERT INTO gvr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","चमैं न्होंरि आक्ह्रिबै ताँमैं तोइ मुँस्याँ चमैं ङ ङाँर खम्, धै ङ चमैंए म्हाँजोरि निसाफ लमिंब्मुँ। छलमा ङइ चमैंने परमेश्‍वरए ठिममैं बिमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","मोशाए क्येंइ चने बिइ, “क्हिइ लबै चु के छ्याँब आत। ");
INSERT INTO gvr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","छलमा क्हि नारब्मुँ क्हि ङाँर खब्मैं या नारब्मुँ। तलेबिस्याँ क्हिए ल्हागिर चु के बेल्‍ले गारो मुँ। क्हि घ्रिइ चु के लल् खाँरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","तारे ङए ताँ थेद्। परमेश्‍वर क्हिने बालु तरिगे बिसि ङ क्हिलाइ सल्‍ला पिंब्मुँ, बरु क्हि म्हिमैंए आक्ह्रिबै ताँ परमेश्‍वरए ओंसों बोब छ्याँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","क्हिइ चमैंलाइ परमेश्‍वरजी बिबै ताँमैं नेरो चमैंइ छ्ह खैले थोल् त्हुम् बिबै ताँ नेरो चमैंइ लल् त्हुबै केमैं चमैंलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","दिलेया म्हिमैंए न्होंउँइँले ह्रब्-सेबै म्हिमैं त्हाँन्। चमैं परमेश्‍वरने ङ्हिंब्मैं, बिश्‍वास योग्यर्बै म्हिमैं, आछ्याँबै केमैं आलब छ्याँबै के लबै म्हिमैं तल् त्हुम्। चमैं हजार-हजार, प्र-प्र, ङ्‍हच्यु-ङ्‍हच्यु नेरो च्यु-च्युए फिर चिब तबर त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","चमैंइ खोंयोंइ बिले म्हिमैंए आक्ह्रिबै ताँमैं क्ह्रिमिंबै के लरिगे। थे-थेबै आक्ह्रिबै ताँमैं बिस्याँ चमैंइ क्हि ङाँर पखरिगे, दिलेया च्योंबै ताँमैं चमैंइन क्ह्रिमिंरिगे। छ लस्याँ क्हिए के योंब्मुँ, तलेबिस्याँ चमैंज्यैया क्हिए ति नोबर ल्होमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","परमेश्‍वरजी बिब् धोंले क्हिइ लइ बिस्याँ क्हिइ चु के आनरल्‍ले लल् खाँब्मुँ, धै चु म्हिमैंया सैं क्होसि ह्रों-ह्रोंसए धिंर ह्‍याब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","छबिमा मोशाइ चए क्येंइ बिबै ताँ ङिंइ, धै खिइ बिब् धोंले ताँन् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","मोशाइ ताँन् इस्राएलीमैं न्होंर ह्रब्-सेबै म्हिमैं त्हाँसि हजार-हजार, प्र-प्र, ङ्‍हच्यु-ङ्‍हच्यु, च्यु-च्युए फिर्बै चिब्मैं तल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","चमैंइ खोंयोंइ बिलै म्हिमैंए आक्ह्रिबै ताँमैं क्ह्रिमिंबै के लमल। क्ह्रिल् आखाँबै ताँमैं मत्‍त्रे चमैंइ मोशा ङाँर पखमल, दिलेया च्योंब ताँमैं चमैं खेंमैंन क्ह्रिमिंमल। ");
INSERT INTO gvr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","च लिउँइँ मोशाइ ह्रोंसए क्येंलाइ मान लसि कुलइ, धै यित्रो ह्रोंसए ह्‍युलउँइँ ह्‍याबै घ्याँ क्हाइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","इस्राएलीमैं मिश्रउँइँले त्होंबै म्हैंन सोंलर सिनै बिबै क्यु आयोंबै क्ल्ह्‍योर फेखइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","चमैं रपिदिमउँइँले प्रसि सिनै बिबै तोइ आरेबै क्ल्‍ह्‍योर फेखसि च कोंए ओंसों इस्राएलीमैइ तम्बु टौंदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","च लिउँइँ मोशा कों क्रेसि परमेश्‍वर ङाँर ह्‍यामा याहवेहजी कोंउँइँले चने बिइ, “क्हिइ याकूबए घराना नेरो इस्राएलीमैंने छ बिद्: ");
INSERT INTO gvr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘क्हेमैंलाइ जोगेबै ल्हागिर ङइ मिश्रीमैंलाइ खै लइ, क्व्रेइ ह्रोंसए प्हसे प्ह्‍यागोर नोब् धोंले ङइ क्हेमैंलाइ नोसि ङ ङाँर पखब क्हेमैंइ म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","तारे ङए ताँ छेनाले थेसि ङने बाछा फैब् धोंले क्हेमैं प्रइ बिस्याँ, ताँन् ह्‍युल ङलन् तलेया ताँन् ह्रेंमैं न्होंरि क्हेमैं ङए म्हिमैं तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","क्हेमैं ङए ल्हागिर पबित्र ह्रें (जात) तसि ङए खेगिमैं तब्मुँ।’ क्हिइ इस्राएलीमैंने बिल् त्हुबै ताँ चुन् ग।” ");
INSERT INTO gvr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","च लिउँइँ मोशा कोंउँइँले क्युरु युसि म्हिमैंए चिबनाँब्मैं खागु लसि याहवेहजी चने बिद् बिसि ल्हैदिबै ताँन् ताँमैं चमैंए ओंसों बिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","छतमा ताँन् म्हिमैंइ तिख्खेर “याहवेहजी बिबै ताँन् ताँमैं ङिइ लब्मुँ,” बिइ। छबिमा म्हिमैंइ बिबै ताँमै मोशाइ याहवेहने बिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","याहवेहजी मोशाने बिइ, “थेद्, ङ क्हिने ताँ लब म्हिमैंइ थेरिगे धै खोंयोंन् बिलै या क्हिए फिर बिश्‍वास लरिगे बिसि ङ क्हि ङाँर रुँदो न्हाँम्स्योर युब्मुँ।” म्हिमैंइ बिबै ताँ मोशाइ याहवेहने बिमा ");
INSERT INTO gvr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","याहवेहजी चने बिइ, “क्हि म्हिमैं ङाँर ह्‍यासि ‘तिंयाँ नेरो प्हन्हाँग पबित्र तसि ह्रों-ह्रोंसए क्वें ख्रुद्,’ बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","झाइले नोगि चमैं छेसि टिरिगे, तलेबिस्याँ नोगि सिनै कोंर ताँन् म्हिमैंइ म्रोंल्‍ले ङ युब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","कोंए कारग्युले बार थोसि म्हिमैंने छ बिद्, ‘क्हेमैं न्ह क्रों मि क्रोंले टिद्, क्हेमैं कों फिर आह्‍याद्, धै चए साँदमैं या आछुइद्। कों छुइबै म्हिलाइ खैले बिलैया सैवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","खाबज्यै च कों आछुइद्। खेदो मुँलेया म्हि मुँलेया च कों छुइ बिस्याँ चमैंलाइ आछुइल्‍ले युँमाइ तलेया म्ये त्हलेइ तलेया ल्हिसि सैवाद्। च सोल् योंरिब् आरे।’ दिलेया थुतुरु ह्राबै कै थेबै लिउँइँ मत्‍त्रे चमैं कोंर खरिगे।” ");
INSERT INTO gvr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","मोशा कोंउँइँले क्युरु म्हिमैं ङाँर युबै लिउँइँ चइ म्हिमैंलाइ पबित्र लइरि चमैइ ह्रों-ह्रोंसए क्वें ख्रुइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","च लिउँइँ चइ म्हिमैंने बिइ, “नोगिए ल्हागिर छेइ टिद्। क्हेमैं च्हमिरिमैंने बालु आतद्।” ");
INSERT INTO gvr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","नोगिम्धों न्हाँग तमा कोंर गड्‌याङगुडुङ तइ, धै काम्‍लि तिम्‍लि रासि कोंर रुँदो न्हाँमस्यो राइ, धै बेल्‍ले ङ्‍हेबै थुतुरिए कै थेइ। छतमा ब्यारेकर मुँबै ताँन् म्हिमैं ङ्हिंसि थरथर त्हारइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","च लिउँइँ मोशाइ ब्यारेकउँइँले म्हिमैंलाइ परमेश्‍वरने त्होबर पखमा म्हिमैं कोंए फेदिर राइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","याहवेह मि तसि चर युबइले सिनै कों मिखु-मिखुइ प्लिंयाँइ। मिए भट्टिउँइँले मिखु त्होंब् धोंलेन् मिखु त्होंमा कोंमैं बेल्‍ले त्हारबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","छतमा थुतुरिए कै अझै सार्ले ङ्‍हेबर होंमा मोशा पोंबर होंइ, धै परमेश्‍वरजी मु गड्‌याङगुडुङ लवासि मोशालाइ ज्वाफ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","झाइले याहवेह सिनै कोंए च्होर युसि मोशालाइ कोंए च्होर हुइ। छतसि मोशा कोंर क्रेसि ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","याहवेहजी मोशाने बिइ, “याहवेह ङ्‍ह्‍योब् बिसि म्हिमैं बार ङ्‍वैसि कोंर आखरिगे बिसि क्हि क्युरु ह्‍यासि चमैंलाइ कों आछुइद् बिद्। चमैंइ छ लस्याँ चमैं न्होंर ल्हें म्हि सियाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ङ ङाँर खमा खेगि या पबित्र तल् त्हुम्। पबित्र आतस्याँ ङइ च त्हेर्न चमैं सैवाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","मोशाइ याहवेहने बिइ, “म्हिमैं सिनै कोंर क्रेसि खल् आखाँ, तलेबिस्याँ चु कों पबित्र मुँ ङ्हाँसि कोंए कारग्युले क्हिजी बार थोद् बिसि ल्हैदिल।” ");
INSERT INTO gvr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","याहवेहजी चने बिइ, “क्हि क्युरु ह्‍यासि हारूनने बालु कोंर क्रेसि खो। खेगिमै नेरो म्हिमैं बिस्याँ, बार ङ्वैसि कोंर क्रेसि ङ ङाँर आखरिगे। आस्याँ ङइ चमैं सैवाब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","च लिउँइँ मोशा क्युरु म्हिमैं ङाँर ह्‍यासि याहवेहजी बिबै ताँ बिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","परमेश्‍वरजी चु ताँन् ताँमैं बिइ: ");
INSERT INTO gvr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“ङ याहवेह क्हेमैंए परमेश्‍वर ग, क्हेमैं केब्छैंमैं तसि टिबै मिश्र ह्‍युलउँइँले ङइन तेसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“छतसि ङलाइ मत्‍त्रे म्हाँदिद् अरू देवतामैं आम्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“क्हेमैंइ ह्रोंसए ल्हागिर मु, पृथ्‍बी नेरो क्यु न्होंर मुँबै सैमैंला कु (मूर्ति) आबनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","चमैंए ओंसों आकुरद्, चमैंए पूजा आलद्, तलेबिस्याँ क्हेमैंए याहवेह परमेश्‍वर ङ ह्रिस लबै परमेश्‍वर ग। ङलाइ छेरब्मैंए पुस्ता सों, प्लि समा दण्ड पिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","दिलेया ङलाइ म्हाँया लब्मैं नेरो ङइ बिबै ताँ ङिंब्मैंए हजार-हजार पुस्ताए फिर ङ ल्हयो खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“ह्रोंसए याहवेह परमेश्‍‍वरए मिं फाकर्र्न आकिंन्, तलेबिस्याँ ङए मिं फाक्‍कर्न किंब्मैंलाइ ङइ छ्याब् ल्हैदिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“प्रिबै त्हिंइ पबित्र ङ्हाँल् त्हुम् बिसि सैंर मैंन्। ");
INSERT INTO gvr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ट्हुगैं समा ह्रोंसए लल् त्हुबै केमैं ताँन् लद्, ");
INSERT INTO gvr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","दिलेया क्हेमैंए याहवेह परमेश्‍वरए ल्हागिर ङिगैं ‘प्रिबै त्हिंइ’ ग। च त्हिंइर क्हेमैंए च्ह च्हमि, केब्छैं-केब्स्योमैं, खेदोमैं नेरो आगुए ह्‍युलर्बै म्हिमैं खाबज्यै तो के या आलद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","तलेबिस्याँ टुगैंर ङ याहवेहजी मु, पृथ्‍बी, मा ङ्युँइ (समुन्द्र) नेरो चर मुँबै तोन्दोंरि सैमैं बनेइ, धै ङिगैंर भों न्हइ। छतसि प्रिबै त्हिंइलाइ याहवेहजी आशिक पिंसि पबित्र लइ। ");
INSERT INTO gvr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“ह्रोंसए आबा-आमाए मान लद्, छलस्याँ ङइ पिंबै ह्‍युलर क्हेमैं ह्रिंग्यो छ्ह योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“म्हि आसैद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ब्यभिचार आलद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“आह्‍योद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ह्रोंसए ङ्‍हेब्टुमैंए बिरोधर स्योर तेसि छ्याब् आल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ह्रोंसए ङ्‍हेब्मैंए धिं-नाँ, प्ह्रेंस्यो, केब्छैं-केब्स्योमैं, क्ल्या, गदा चए तो सै म्रोंलेया आम्रोद्।” ");
INSERT INTO gvr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","च त्हेर काम्‍लि तिम्‍लि रासि मु ङ्‍हेब नेरो थुतुरिए कै थेइ धै कोंउँइँले मिखु खब म्रोंसि चमैं थरथरले त्हारसि ह्रेंगोन् रारिइ। ");
INSERT INTO gvr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","चमैंइ मोशाने बिइ, “क्हि ङिने पोंइ बिस्याँ ङिइ क्हिए ताँ थेब्मुँ, दिलेया परमेश्‍वर ङिने आपोंरिगे। खी ङिने पोंस्याँ ङि सिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","मोशाइ म्हिमैंने बिइ, “क्हेमैं आङ्हिंन्, तलेबिस्याँ क्हेमैंए जाँच लबर, क्हेमैंइ पाप आलरिगे धै खीने ङ्हिंरिगे बिसि परमेश्‍वर युइमु।” ");
INSERT INTO gvr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","दिलेया म्हिमैं ह्रेंगोन् रारिइ। परमेश्‍वर मुँबै रुँदो न्हाँम्स्योर खीए ङाँर मोशा ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","छले ह्‍यामा याहवेहजी मोशाने बिइ, “ङ स्वर्गउँइँले क्हेमैंने पोंब क्हेमैंइ म्रोंइमुँ बिसि क्हिइ इस्राएलीमैंने बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","क्हेमैंइ ह्रोंसए ल्हागिर चाँदि नेरो माराए देवतामैं बनेसि आफ्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“क्हेमैंइ ङए ल्हागिर सए ख्रो पिंबै क्ल्ह्‍यो बनेसि मिइ ख्रोंबै ख्रोमैं, क्ह्रिमिंबै ख्रोमैं, क्युमैं नेरो खेदोए ख्रोमैं पिंन्। ङए मिंए मान लबै क्ल्ह्‍योजरे ङ युसि क्हेमैंलाइ आशिक पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ङए ल्हागिरि क्हेमैंइ युँमाए ख्रो पिंबै क्ल्ह्‍यो बनेमा कुन्दिबै युँमाए ख्रो पिंबै क्ल्ह्‍यो आबनेद्। तलेबिस्याँ छिनइ युँमार कुन्दिमा क्हेमैंइ ख्रो पिंबै क्ल्ह्‍यो अशुद्ध लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","छलेन क्हेमैंए म्रोंल् आतबै सै आम्रोंरिगे बिसि लिउँइँले ङए मिंर ख्रो पिंबै क्ल्ह्‍योर आक्रेद्। ");
INSERT INTO gvr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“तारे ङइ क्हेमैंए ल्हागिर पिंबै ठिममैं चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“क्हेमैंइ हिब्रू म्हि मुइ फोसि केब्छैं तबर थेंइ बिस्याँ चइ टुदि समा मत्‍त्रे क्हेमैंए के लरिगे। ङिदिर च तोइ आफोन्ले ह्रोंसए धिंर ह्‍याल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","केब्छैं तबर च घ्रिन् खब् ग बिस्याँ च घ्रिन् ह्‍यारिगे। चइ ब्ह्‍या लसि प्ह्रेंस्योने बालु खब् ग बिस्याँ प्ह्रेंस्यो बोसिन् ह्‍यारिगे। ");
INSERT INTO gvr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","“चए क्ल्हेइ चलाइ ब्ह्‍या लमिंसि च्ह च्हमिंमैं योंइ बिस्याँ, म्रिं प्हसेमैं क्ल्हे ङाँर्न टिल् त्हुब्मुँ, च म्हि घ्रि मत्‍त्रे ह्‍याल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","दिलेया च केब्छैंइ ‘ङ ह्रोंसए क्ल्‍हे नेरो म्रिं, प्हसेमैंए म्हाँया खमुँ, छतसि ङ ह्रोंसए धिंर आह्‍या’ बिइ बिस्याँ, ");
INSERT INTO gvr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","चए क्ल्हेइ चलाइ निसाफ लबै म्हिमैं ङाँर बोसि म्रार राल् पिंसि चए न्ह थोंमिंरिगे। छ लबै लिउँइँ आसिन् समा च म्हि क्ल्हेए केब्छैं तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“खाबज्यै या ह्रोंसए च्हमि केब्स्यो तबर चुँइँमुँ बिस्याँ मुयु केब्छैंमैं धोंले च केब्स्यो धबै क्ल्हेए धिंउँइँले ह्‍याल् योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","दिलेया च च्हमिरि ह्रोंसए ल्हागिरि पखबै लिउँइँ क्ल्हेइ चलाइ आखोइ बिस्याँ केब्स्योए आबाइ मुइ पिंसि चलाइ आबाइ बोयाल् त्हुम्। क्ल्हेइ चए फिर ठिक के आलबइले चलाइ अरू ह्रेंमैंने चुँल् योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","दिलेया क्ल्हेइ चलाइ ह्रोंसए च्हए प्ह्रेंस्यो तबर त्हाँइ बिस्याँ, चने केब्स्यो धोंन् आङिं, च्हमिं धोंन् ङ्हाँल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","च केब्स्यो पखसि क्ल्हेइ अर्को प्ह्रेंस्यो पखइ बिस्याँ, थेब्स्योलाइ चब् थुँब्, नेरो क्वें पिंसि प्ह्रेंस्योलाइ म्हाँया लब आपिरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","क्ल्हेइ चने चु केमैं सों आलस्याँ, मुइ तिफुँइ आफोल्‍ले च फ्रेयाल् खाँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“खाबज्यै या म्हिलाइ प्रिंसि सैवास्याँ चलाज्यै या सैवाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","दिलेया खाबज्यै या ह्रना-ह्रन् म्हि आसैलै या परमेश्‍वरजीन् छ तल् पिंब् ग बिस्याँ, चए ल्हागिर भौदिह्‍याबै क्ल्ह्‍यो घ्रि ङइ तोक्दिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","दिलेया म्हि ह्रिस खसि दाउ ङ्‍ह्‍योसि म्हिलाइ सैइ बिस्याँ, छाबै म्हिलाइ सैबर बोयाद्, ङए ख्रो पिंबै क्ल्ह्‍योर ह्‍यसि टिलेया सैबर बोयाद्। ");
INSERT INTO gvr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ह्रोंसए आबा-आमालाइ प्रिंबै म्हिलाइ सैवालन् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“खाबइ म्हिमैं क्हासि चुँमुँ अथवा आचुँले थेंमुँ, छाबै म्हिलाज्यै या सैवालन् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ह्रोंसए आबा आमाए फिर गाल् केबै म्हि या सैवालन् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“म्हिमैं प्होंगि कैगि लसि घ्रिइ घ्रिलाइ युँमा नेरो योइ ल्हिमा च म्हि सिबम् आसि दिलेया आधा कल्सो तसि क्ल्ह्‍योर तयास्याँ ");
INSERT INTO gvr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","लिउँइँ धबै प्हरे तुँसि प्रल् खाँस्याँ, चलाइ प्रिंबै म्हि छ्याब आरेब तब्मुँ। दिलेया च क्ल्ह्‍योर तमा छेनाले आसन् समा प्रिंबै म्हिइन मैंए सै नेरो चब् थुँब ङ्‍ह्‍योल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“खाबज्यै या ह्रोंसए केब्छैं केब्स्योलाइ प्हरेइ प्रिंमा सियाइ बिस्याँ च सैवाबै म्हिइ दण्ड योंलन् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","दिलेया च म्हि तिगें ङ्हिंगैं लिउँइँ रेइ बिस्याँ च प्रिंबै म्हिलाइ दण्ड आपिंन्, तलेबिस्याँ क्ल्हेइ सै फोसि केब्छैंलाइ किंब् ग। ");
INSERT INTO gvr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“म्हिमैं प्होंब नेब तमा फोर प्हसे मुँबै च्हमिरिलाइ ने म्योंसि फिबै त्हे आतबन् प्हसे फिइ, दिलेया च च्हमिरिलाइ तोइ नोक्सन आतइ बिस्याँ, च्हमिरिए प्युँइ बिब् धोंलेन् नेरो निसाफ लबै म्हिमैंइ तोक्दिब् अनुसार नें म्योंल् लबै म्हिइ मुइ फोल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","दिलेया च्हमिरिलाज्यै या नें म्योंइ बिस्याँ सोए खि सो किंल् त्हुम। ");
INSERT INTO gvr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","छलेन मिए खि मि, सए खि स, योए खि यो, प्हलेए खि प्हले, ");
INSERT INTO gvr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","डामए खि डाम, नें म्योंबए खि नें म्योंब, प्रिंबए खि प्रिंब च म्हिइ योंरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“खाबज्यै ह्रोंसए केब्छैं-केब्स्योए मिंर प्रिंसि तिवास्याँ, चए मिंए साटोर चइ तोइ आफोल्‍ले फ्रेसि ह्‍याल् योंम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","छलेन ह्रोंसए केब्छैं केब्स्योए सर प्रिंमा स चुयाइ बिस्याँ, च सए साटोर चइ तोइ आफोल्‍ले फ्रेसि ह्‍याल् योंम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“क्ल्याइ रुइ थासि म्हिलाइ सैवाइ बिस्याँ, च क्ल्‍या युँमाइ ल्हिसि सैवाद्, चए से आचद्, धै चए क्ल्हेलाइ दण्ड आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","दिलेया च क्ल्याइ ओंसों या थाब्रें लमल बिसि क्ल्हेने बिलेया चइ क्ल्या च्युँइ आथेंबै लमा म्हिमैं थासि सैवाइ बिस्याँ च क्ल्या युँमाइ ल्हिसि सैवाद्, धै चए क्ल्हेलाज्यै या सैवाद्। ");
INSERT INTO gvr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","दिलेया च म्हिलाइ आसैबै ल्हागिर मुइ तोक्दिस्याँ चइ ह्रोंसए ज्यु जोगेबै ल्हागिर तोक्दिबै मुइ फोल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","क्ल्याइ कोलोमैं थासि सैवास्याँ, चु ठिमर बिब् धोंले या लद्। ");
INSERT INTO gvr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","क्ल्याइ थासि केब्छैं केब्स्यो सैवास्याँ, क्ल्याए क्ल्हेइ केब्छैंए क्ल्हेलाइ चाँदिए सोंच्यु सिक्‍का पिंल् त्हुम्, धै च क्ल्या युँमाइ ल्हिसि सैवाद्। ");
INSERT INTO gvr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“खाबज्यै या इनारए क्हा आझोंल्‍ले ह्‍वाङ्‍गन् थेंमा इनार तासि आहुल्‍ले थेंमा चर क्ल्या अथवा गदा पायास्याँ, ");
INSERT INTO gvr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","च इनार बनेबै म्हिइ क्ल्या अथवा गदाए क्ल्हेलाइ मुइ पिंसि च सियाबै खेदो चइन योंरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","म्हि घ्रिए क्ल्याइ अर्को म्हिए क्ल्यालाइ थासि सैवास्याँ, क्ल्हेमैं ङ्हिं क्ह्रिसि च सोगों क्ल्या चुँसि योंबै सै नेरो सियाबै क्ल्याए से या चुल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","दिलेया च क्ल्याइ ओंसों ओंनोंन् थामल बिसि क्ल्हेइ सेलेया च क्ल्या च्युँइँसि आथेंस्याँ, च क्ल्हेइ क्ल्याए खि क्ल्यान् पिंल् त्हुम्, धै सियाबै क्ल्या चलन् तरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“खाबज्यै या क्ल्या अथवा क्यु ह्‍योसि सैलेया चुँलेया, चइ क्ल्याए खि क्ल्या ङ्‍ह नेरो क्युए खि क्यु प्लि पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“ह्‍योइ म्हुँइँसर धिंर ह्‍योरिबै तोंर स्याइ बिस्याँ चलाइ प्रिंमा च सियास्याँ, चलाइ सैवाबै छ्याब् प्रिंबै म्हिए फिर खरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","दिलेया त्हिंयाँ प्योल् खाँइमुँ बिस्याँ, चए फिर म्हि सैबै छ्याब् ल्हैदिब्मुँ। “ह्‍योइ दण्ड फोल् त्हुम्। ह्‍योसि बोबै सै क्ल्या, गदा, क्यु तो मुँलेया स्याइ बिस्याँ चए ङ्हिथु फोल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ह्‍योने बालु फोबै सै तोइ आरेस्याँ, चइ ह्‍योबै के लबइले चइ फोल् त्हुबै दण्ड केब्छैं तसि फोल् त्हु म्। ");
INSERT INTO gvr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“खाबज्यै ह्रोंसए खेदो रेंबर पिवामा खेदोइ आगुए म्रोंर्बै रा-रोमै चवास्याँ, खेदोए क्ल्हेइ ह्रोंसए म्रों नेरो अँगुरए बारिर्बै ताँन् भन्दा छ्याँबै रोमैं खि पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“खाबज्यै ह्रोंसए म्रोंर घुरान्मैं ख्रोंमा आगुए म्रोंर्बै खेतिमैं तोइ आचल्‍ले ख्रोंवाँइ बिस्याँ, चए खि घुरान्मैं ख्रोंबै म्हिइन पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“खाबज्यै ह्रोंसए ङ्‍हेब्मैंने मुइ मुँले अरू तो सै मुँले थेंल् पिंइ, झाइले च म्हिए धिंउँइँले ह्‍योवाइ धै ह्‍योलाइ स्याइ बिस्याँ च ह्‍योइ तिंबाँर ङ्हिंबाँ तेंसि पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","दिलेया ह्‍यो आस्यास्याँ, ङ्‍हेब्मैंइ थेंल् पिंबै सै धिं क्‍ल्‍हेइन लोइ उ आलो बिसि था सेबै ल्हागिर छेनाले निसाफ लबै म्हिमैं ङाँर च ह्‍यारिगे। ");
INSERT INTO gvr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“क्ल्या, गदा, क्यु, क्वें, तो मुँले म्हह्‍याबै सैए बारेर खाबज्यै ‘च सै ङल ग’ बिइ बिस्याँ, चमैं ङ्हिंन-ङ्हिंन् निसाफ लबै म्हिमैं ङाँर ह्‍यारिगे। धै निसाफ लबै म्हिमैंइ दोषि ठर्दिबै म्हिइन ह्रोंसए ङ्‍हेब्मैंलाइ तिंबाँर ङ्हिंबाँ तेंसि पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“छलेन खाबज्यै ह्रोंसए ङ्‍हेब्मैंलाइ गदा, क्ल्या, क्यु थेंल् पिंइ, दिलेया च खेदो खाबज्यै आम्रोंल्‍ले सियालेया, ने म्योंलेया अथवा खाबज्यै ल्हा बोइ बिस्याँ, ");
INSERT INTO gvr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ह्रोंसए ङ्‍हेब्मैंए सैमैं ङइ आछुइमुँ बिसि याहवेहए ओंसों कसम चसि चमैं ङ्हिंए न्होंरि आक्ह्रिबै ताँ क्ह्रिरिगे। धै खेदोए क्ल्‍हेइ च ताँ ङिंरिगे, छलमा ङ्‍हेब्मैंए सै थेंबै म्हिइ खि फोल् आत्हु। ");
INSERT INTO gvr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","दिलेया खेदो ङ्‍हेब्मैंन ह्‍योब् ग बिस्याँ, खेदोए क्ल्हेलाइ खि फोल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","क्ह्‍योंर्बै चें भलुइ खेदोलाइ सैवाइ बिस्याँ, च खेदो थेंबै म्हिइ खेदोए सिनु फखसि उँइँल् त्हुब्मुँ। धै च खेदो चें भलुइन सैवाब् ग बिस्याँ खेदो थेंबै म्हिइ खि फोल् आत्हु। ");
INSERT INTO gvr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“खाबज्यै ह्रोंसए ङ्‍हेब्मैंउँइँले खेदो ङैसि बोमा क्ल्याए क्ल्हे आरेमा क्ल्या नें म्योंइ अथवा सियाइ बिस्याँ, ङैबै म्हिइ चए खि पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","दिलेया क्ल्याए क्ल्‍हे क्ल्यानेन् मुँस्याँ ङै बोबै म्हिइ चए खि फोल् त्हुरिब् आरे। च खेदो नों सै फोसि पखब् ग बिस्याँ, चए नोक्सन् तब नों सैन पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“खाबज्यै मग्नि आतबै कन्येलाइ न्होंवाइ बिस्याँ, न्होंवाबै म्हिइ प्ह्रेंस्योए सै फोसि च कन्येने ब्ह्‍या लरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","दिलेया आबाइ च्हमिलाइ च मुँयुँने ब्ह्‍या लल् आपिंस्याँ, कन्येए छ्या अनुसार च मुँयुँइ कन्येए आबालाइ मुइ फोल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“जादु लबै च्हमिरि सोगों आथेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“खेदोने न्होंब्मैं सैवाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“याहवेह बाहेक अरू देवतालाइ ख्रो पिंब्मैं खैलसेया सैवाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“आगुए ह्‍युलर्बै म्हिमैंलाइ दुःख आपिंन्, धै न्होह्रों या आलद, तलेबिस्याँ क्हेमैं या मिश्रर परदेशि मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“म्हरेस्यो नेरो आबा आरेब्मैं आलुडिद्। ");
INSERT INTO gvr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","क्हेमैंइ लुडिसि चमैंइ ङने ग्वार ह्रिमा ङइ चमैंए ताँ थेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ङ बेल्‍ले ह्रिस खसि सेलाँइ क्हेमैं सैवाब्मुँ, झाइले क्हेमैंए प्ह्रेंस्योमैं म्हरेस्यो तब्मुँ धै क्हेमैंए च्ह-च्हमिंमैं आबा आरेब्मैं तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“क्हेमैंने बालु मुँबै ङए ङ्हाँदु म्हिलाइ क्हेमैंइ छे पिंइ बिस्याँ चए फिर क्ल्हे आप्हैंन्, चने ब्याजै या आकिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","क्हेमैंए ङ्‍हेब्मैंए नेंबै क्वें क्हिइ धितोर थेंइमुँ बिस्याँ, त्हिंयाँ लिब् भन्दा ओंसोंन् च क्वें एमिंन्, ");
INSERT INTO gvr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","तलेबिस्याँ चल नेंबै क्वें च घ्रि मत्‍त्रे ग। च घ्रि या क्हिइ थेंवास्याँ च तो नेंसि रोब? छतसि चइ ङने ग्वार ह्रिइ बिस्याँ ङ चए ताँ थेब्मुँ, तलेबिस्याँ ङइ ल्हयो खमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“परमेश्‍वर आस्यारद्, छलेन क्हेमैंए फिर्बै चिब्मैंलाज्यै या सराप आझोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“क्हेमैंए म्रोंर्बै रोमैं नेरो अँगुरए खुगु परमेश्‍वरए मिंर पखबर क्हैन् आलद्। “क्हेमैंए च्ह थेब ङए ल्हागिर पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“छलेन क्हेमैंए खेदोमैं नेरो क्युमैं या ङलाइ पिंन्। च ओंसों फिबै खेदोए प्हसे ङिगें समा ह्रोंसए आमाने टिरिगे, प्ह्रेगैंर बिस्याँ क्हेमैंइ च खेदोए प्हसे ङए ल्हागिर पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“क्हेमैं ङए पक्‍का म्हिमैं तल् त्हुम्। छतसि क्हेमैंइ चें भलुइ सैबै खेदोए से आचद्। च से क्हेमैंइ नगिमैं पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“स्योर ताँ आपोंन्। दुष्‍टलाइ जोगेब् बिसि स्योर ताँआपोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","आगुए न्होह्रों लबर म्हि हुलने आत्हुँन्। मुद्दा तमा खाबल् म्हि ल्हें मुँ चए ख लसि आगुइ लबै निसाफ आन्होंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ङ्हाँदु म्हि मुद्दार फेमा ‘च म्हि ङ्हाँदु ग,’ बिसि चए ख आलद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“क्हेमैंइ ह्रोंसए शत्तुरमैंए म्ये, गदा स्योरसि ह्‍यारिब म्रोंइ बिस्याँ, च खेदोलाइ क्ल्हे ङाँर समिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","क्हेमैंए फिर ह्रिस लब्मैंए गदा तिइ प्लेवाब म्रोंस्याँ, चलाइ छलेन् आवाथेंन्, चलाइ रेबर ल्होद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“मुद्दा तमा ङ्हाँदु म्हिइ ठिक निसाफ योंल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“स्योर ताँ तिफुँइ पोंसि छ्याब आल्हैदिद्। छ्याब् आरेबै म्हि नेरो स्योर आतेबै म्हिलाइ सिबै दण्ड आपिंन्, तलेबिस्याँ छ्याब् मुँबै म्हिलाइ ङइ खोंयोंन् बिलै छ्याब् आरे बिल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","ख्याब आचद्, तलेबिस्याँ ख्याबइ म्हिमैं मि आम्रोंब् लवाम्, धै चइ क्ह्रोंसेंन्बै ताँ आसे। छतसि छ्याब् आरेब्मैंइ निसाफ आयों। ");
INSERT INTO gvr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“आगुए ह्‍युलर्बै म्हिमैंलाइ दुःख आपिंन्। क्हेमैं मिश्रर परदेशि तसि टिबइले आगुए ह्‍युलर टिब्मैंए सैं खैतब् तम् बिसि क्हेमैंइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“टुदिं समा ह्रोंसए म्रोंर प्लु प्लुसि छाइले खबै रोमैं खुद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","दिलेया ङिदिंर च क्ल्ह्‍यो आक्योल्‍ले बाँजोन् पिवाद्, च क्ल्ह्‍योउँइँले खबै रोमैं ङ्हाँदुमैंइ चरिगे। चमैंइ चसि ङैब क्ह्‍योंर्बै खेदोमैंइ चरिगे। क्हेमैंए अँगुरए ह्‍वे (बारि) नेरो जैतुनए ह्‍वे या छान् लद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“टुगैं समा के लद्, दिलेया ङिगैंर भों न्हद्, छ लस्याँ क्हेमैंए क्ल्या, गदा, क्हिए धिंर्न फिबै केब्छैं नेरो आगुए ह्‍युलर्बै म्हिमैंइ भों न्हल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ङइ बिबै ताँन् ताँ क्हेमैंइ सैंर थेंन्। अरू देवतामैंए मिं या आकिंन्। क्हेमैंए सुँउँइँले देवतामैंए मिं या आकिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ङए मान लबर बर्षर सोंखे चाड म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","क्हेमैंइ प्लेढा आझोंबै क्हें चबै चाड म्हाँदिद्। ङइ क्हेमेंने बिब् धोंले आबीब म्हैंनर बिबै त्हेर ङिगैं समा प्लेढा आझोंबै क्हें चद्, तलेबिस्याँ चु म्हैंनर्न क्हेमैं मिश्र ह्‍युलउँइँले त्होंइ खब् ग। क्हेमैं ङ ङाँर खमा यो क्होत्‍ते आखो। ");
INSERT INTO gvr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“अर्को, क्हेमैंइ म्रोंर प्लुसि खबै ओंसोंबै रो परमेश्‍वरए मिंर पिंसि बालि खैंबै चाड म्हाँदिद्। “अर्को, ह्रोंसइ रुँइँबै रो ह्रोंसए म्रोंउँइँले खुमा बालि ङ्‍हेरबै चाड म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“क्हेमैंए ताँन् मुँयुँमैं बर्षर सोंखे याहवेहए उँइँर ह्‍याल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ङलाइ खेदोए ख्रो पिंबै कोने प्लेढा झोंबै क्हें आचडेद्। “ङए ल्हागिर चाडर ख्रो पिंबै खेदोमैंए छि प्हन्हाँग समा आथेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“क्हेमैंए म्रोंर ताँन् भन्दा ओंसों रोबै छ्याँबै रो ह्रोंसए याहबेह परमेश्‍वरए धिंर पखो। “र बोक्याए से चए आमाए ङ्‍हेर आह्‍योद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ङ्‍ह्‍योद्, क्हेमैंलाइ घ्याँर जोगेबर नेरो ङइ तयार लबै क्ल्ह्‍योर क्हेमैंलाइ सथेंनेबर ङइ क्हेमैंए ओंसो-ओंसो स्वर्गदूत घ्रि कुलब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","क्हेमैंइ चए ताँ छेनाले थेद्, तलेबिस्याँ चलाइ ङइ कुलब् ग। छतसि चए बिरोध आलद्, आस्याँ चइ क्हेमैंए पापमैं क्षमा लरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","क्हेमैंइ चइ बिबै ताँ ङिंसि ङइ बिब् धों लस्याँ, ङ क्हेमैंए ताँन् शत्तुरमैं नेरो बिरोधीमैंए बिरोध लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ङए दूत क्हेमैंए ओंसो-ओंसो ह्‍यासि एमोरी, हित्ती, परिज्जी, कनानी, हिव्‍वि नेरो यबूसीमैंए ह्‍युलर क्हेमैं सथेंनेब्मुँ, धै ङइ चमैंए मिं क्ह्रन् मेटिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","चमैंए देवतामैं पूजा लसि आफ्योद्, चमैंए छ्यार लब् धोंले आलद्, चमैंए देवतामैं फतिवाद्, चमैंए पबित्र युँमामैं या फतिवाद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","क्हेमैंइ ह्रोंसए याहवेह परमेश्‍वरए सेवा लद्। छ लस्याँ ङइ क्हेमैंए रा-रोमैंर आशिक पिंब्मुँ, धै ङइ क्हेमैंए नब्-छब् सल् लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","क्हेमैंए ह्‍युलर खाबै या प्हसे प्युलब नेरो थरि तरिब् आरे। ङइ क्हेमैंलाइ ह्रिंबै छ्ह पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“क्हिए बिरोध लब्मैंलाइ ङए मान लबर ल्हैदिब्मुँ। क्हेमैं खाब् ह्रेंमैं ङाँर नेबर ह्‍यामुँ चमैं ताँनलाइ खेंमैंए न्होंर्न ङइ आक्ह्रिन् लवाब्मुँ, धै क्हेमैं ङाँइँले क्हेमैंए शत्तुरमैं ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","ङ क्हेमैंए ओंसों-ओंसों च्ह्‍युगु कुलब्मुँ‍, झाइले च च्ह्‍युगुइ क्हेमैंउँइँले हिव्वी, कनानी नेरो हित्तीमैंलाइ ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","दिलेया ङ चमैंलाइ तिदिं न्होंर्न क्हेमैं ङाँइले ल्हारिब् आरे, छ लस्याँ ह्‍युल सुन्य तब्मुँ, धै क्हेमैं भन्दा क्ह्‍योंर्बै खेदोमैं ल्हें तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","क्हमैंए म्हिमैं ल्हें तसि च ह्‍युल क्हेमैंइ क्ल्हे आलन् समा ङ चमैंलाइ दे-दे लसि क्हेमैं ङाँइँले ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","ङ क्हेमैंए ह्‍युलए साँध ओल्ग्या माँ ङ्युँइउँइँले पलिश्‍तिमैंए माँ ङ्युँइ समा छलेन क्यु आयोंबै क्ल्ह्‍योउँइँले यूफ्रेटिस स्यों समा तोक्दिमिंब्मुँ। च ह्‍युलर्बै म्हिमैंलाइ ङइ क्हेमैंए योर सुम्पिदिवाब्मुँ, धै क्हेमैंइ चमैंलाइ ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","चमैं नेरो चमैंए देवतामैंने क्ह्रिबै बाछा क्हेमैंइ आफैद्। ");
INSERT INTO gvr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","च म्हिमैंलाइ क्हेमैंए ह्‍युलर टिल् आपिंन्। टिल् पिंइ बिस्याँ क्हेमैंलाइ ङए बिरोधर पाप लबर ल्हैदिब्मुँ, तलेबिस्याँ क्हेमैंइ चमैंए देवतामैंए पूजा लइ बिस्याँ क्हेमैं जालर फेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","याहवेहजी धबै मोशाने बिइ, “क्हि हारून, नादाब, अबिहू नेरो इस्राएलर्बै चिब्मैं न्होंर्बै ङिच्यु चिब्मैं कों क्रेसि ङ ङाँर खो, धै ह्रेंगोउँइँलेन् क्र कुरसि ङलाइ फ्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","दिलेया मोशा मत्‍त्रे ङ ङाँर खल् त्हुम्, अरू चिब्मैं ङ ङाँर आखो, धै अरू म्हिमैंइ कोंर प्हले या आम्हैरिगे।” ");
INSERT INTO gvr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","मोशा ह्‍यासि याहवेहजी बिबै ताँमैं नेरो लल् त्हुबै ठिममैं म्हिमैंने बिमिंमा चमैं ताँनइ सुँ घ्रिले, “याहवेहजी बिबै ताँन् ताँमैं ङि लब्मुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","झाइले मोशाइ याहवेहए ताँन् ताँमैं प्ह्रिइ। धै प्हँन्हाँग्धों न्हाँकर्न रेसि मोशाइ कोंए जरर ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि चर इस्राएलए कुल घ्रि-घ्रि ल्हागिर घ्रि-घ्रि लसि च्युसे ङ्हिं युँमा क्योइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","च लिउँइँ मोशाइ इस्राएलर्बै फ्रेसिमैं कुलइ, धै चमैंइ याहवेहए मिंर मिइ ख्रोंबै ख्रोमैं नेरो क्ह्रिमिंबै ल्हागिर क्ल्या साँढेमैं ख्रो पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","च खेदोमैंए ङ्हिबाँर्बै तिबाँ को मोशाइ भाँडोर झोंइ, धै तिबाँ को ख्रो पिंबै क्ल्ह्‍योर प्रामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","च लिउँइँ मोशाइ याहवेहजी ल्हैदिबै ताँ प्ह्रिबै कितब किंसि म्हिमैंए उँइँर थेबै कैले खेमिंमा “याहवेहजी ल्हैदिबै ताँन् ताँमैं ङिं लब्मुँ,” बिसि चमैंइ बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","च लिउँइँ मोशाइ भाँडोर्बै को किंसि म्हिमैं फिर प्रासि बिइ, “थेद्, चु याहवेहजी बाछा फैबै को ग। खीजी चु बाछा खीजी ताँन् ताँमैं बिब् धोंले क्हेमैंने फैइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","च लिउँइँ मोशा, हारून, नादाब, अबिहू नेरो इस्राएलर्बै चिब्मैं न्होंर्बै ङिच्यु चिब्मैं कोंर क्रेसि ");
INSERT INTO gvr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","इस्राएलए परमेश्‍वरलाइ म्रोंइ। खीए प्हले न्होंर निरइ स्युबै मु धोंबै छ्याँबै युँमा प्लना मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","दिलेया परमेश्‍वरजी इस्राएलर्बै चिब्मैंए न्होह्रों आल। चमैंइ परमेश्‍वरलाइ म्रोंइ धै बालुन् चब् थुँब् लइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","याहवेहजी मोशाने बिइ, “कोंर ङ ङाँर खसि टिद्। क्हिइ म्हिमैंलाइ लोमिंरिगे बिसि ङइ ठिम नेरो लल् त्हुबै ताँमैं युँमाए प्लनार प्ह्रिइमुँ। च युँमा क्हिलाइ पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","छबिमा मोशा नेरो चलाइ ल्होबै यहूशू रेसि परमेश्‍वरए पबित्र कोंर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","मोशाइ च चिब्मैंने बिइ, “ङि एसि आयुन् समा ङिलाइ चुर्न प्रेंरिद्। हारून नेरो हुर क्हेमैंनेन् तब्मुँ। खाबलैया तोइ ताँ आक्ह्रिस्याँ चमैं ङाँर ह्‍याद्।” ");
INSERT INTO gvr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","छ बिसि मोशा सिनै कोंर ह्‍यामा न्हाँम्स्योइ कों हुवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","याहवेहए चारबै ह्‍वे सिनै कोंर चारइ। ट्हुगैं समा न्हाँम्स्योइ कों हुवाइ, धै ङिगैंर याहवेहजी न्हाँम्स्यो न्होंउँइँले मोशालाइ हुइ। ");
INSERT INTO gvr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","इस्राएलीमैंइ कोंए च्होर ङ्‍ह्‍योमा याहवेहए ह्‍वे लुँरिबै मि धों तब् म्रोंल। ");
INSERT INTO gvr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","मोशा न्हाँम्स्यो न्होंउँइँले कोंर ह्‍याइ, धै प्लिच्यु त्हिंइ प्लिच्यु म्हुँइँस चर टिइ। ");
INSERT INTO gvr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“चमैंइ ङए ल्हागिर भेटि पल् त्हुम् बिसि इस्राएलीमैंने बिद्, चमैं ताँनइ सैं तोंदै पिंबै भेटि क्हिइ ङए ल्हागिर किंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","चमैंइ पिंबै भेटिमैं चुन् तम्: मारा, चाँदि, काँसा, ");
INSERT INTO gvr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","नीलो, कलेजी, ओल्ग्या रु, मलमलए क्वें, रए मुइ बनेब क्वें, ");
INSERT INTO gvr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ओल्ग्या रङ झोंबै क्यु साँडए ट्हुबि, ङ्याँ-ङ्याँ ह्‍याबै ट्हुबि, बबुलए सिं, ");
INSERT INTO gvr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","बत्तिए म्रोबै ल्हागिर जैतुनए छ्युगु, अभिषेक लबै छ्युगु नेरो लिंबै थाँ खबै धुपए ल्हागिर मसलामैं, ");
INSERT INTO gvr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","एपोद नेरो खेगिए तिंर खिबै क्वेंए ल्हागिर आनिक्स नेरो अरू मँगो तुथुमैं। ");
INSERT INTO gvr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ङ चमैंए म्हाँजोर टिबर चमैंइ ङए ल्हागिर पबित्र तम्बु घ्रि टौंदिल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ङइ क्हिने उँइँबै नमुना धोंले क्हिइ पबित्र तम्बु नेरो चर चैदिबै ताँन् सैमैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“चमैंइ बबुल सिंए मुदुस घ्रि बनेरिगे। च ङ्हिउरु ह्रिंब, तिउरुसे आधा प्ल्हाब, तिउरुसे आधा नुब तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","क्हिइ च मुदुसए न्हों, फि छ्याँबै माराइ म्होरद्। चए कारग्युले माराए ङाँ सैद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","च नोबै ल्हागिर माराए न्हमैं प्लि बनेसि मुदुसए प्हले प्लि प्ह्‍याद्। न्ह ङ्हिं तिराइ न्ह ङ्हिं तिराइ प्ह्‍यामिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","छलेन क्हिइ बबुल सिंए प्हरे बनेसि माराइ म्होरद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","मुदुस नोबै ल्हागिर च प्हरेमैं मुदुसए हार ङ्हिंर मुँबै न्हमैंर क्ह्‍युद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","च प्हरेमैं मुदुसए न्हमैंर क्ह्‍युथेंल् त्हुम्। च प्हरेमैं न्हउँइँले आट्हुइद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ङए ठिममैं प्ह्रिबै युँमाए प्लना ङ क्हिलाइ पिंब्मुँ, च मुदुसर च युँमाए प्लना थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“छलेन छ्याँबै माराए मुदुसए क्हा घ्रि बनेद्। च ङ्हिउरुसे आधा ह्रिंब, तिउरुसे आधा प्ल्हाब तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","माराए प्ह्‍या ङ्हिं मुँबै करूबमैं बनेसि मुदुसए छेउ छेउर थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","करूब घ्रि तिरैबै च्होर करूब घ्रि तिरैबै च्होर थेंन्। माराए टुक्र घ्रिउँइँले च क्हा नेरो करूब ङ्हिं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","च करूबमैंइ प्ह्‍यामैं क्होवाइ फैसि मुदुसए क्हालाइ प्ह्‍यामैंइ हुल् त्हुम्। चमैंए सुँ मुदुसउँइँ ह्‍वेंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","च क्हा मुदुसए फिर थेंन्। ङए ठिममैं प्ह्रिबै युँमाए प्लना क्हिलाइ पिंब्मुँ, च युँमाए प्लना च मुदुसर थेंन्, ");
INSERT INTO gvr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","चर्न ङ क्हिने त्होब्मुँ। ठिम थेंबै मुदुसए क्हा फिर्बै करूबमैंए म्हाँजोउँइँले इस्राएलथेंमैंए ल्हागिर ङए ताँन् ठिममैं क्हिलाइ पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“क्हिइ बबुल सिंए टेबल घ्रि बनेद्। च ङ्हिउरु ह्रिंब, तिउरु प्ल्हाब, तिउरुसे आधा नुब तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","च टेबल छ्याँबै माराइ म्होरसि चए कार्ग्यलै माराइ ङाँ सैद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","चए कारग्युले योरिं प्लि प्ल्हाब गेर बनेसि चए कारग्युले माराइ ङाँ सैद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","टेबल नोबै ल्हागिर माराए न्ह प्लि बनेद्, धै च न्हमैं टेबलए प्हले प्लिर प्ह्‍यामिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","टेबल नोबै ल्हागिर प्हेरमैं क्ह्‍युबै क्ल्ह्‍यो तल्‍ले च न्हमैं घेराए रेर प्ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","टेबल नोबै प्हरे बबुल सिंल बनेसि च प्हरेलाइ माराइ म्होरद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","क्हिइ टेबलर थेंबै ल्हागिर छ्याँबै माराए थलिमैं, धुपार, करुवा नेरो प्हेलामैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ङए मिंर पिंबै क्हेंमैं टेबलर थेंसि खोंयोंन् बिलै ङए ओंसों थेंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“क्हिइ छ्याँबै माराए पानस बनेद्। चए क्हाबै क्ल्ह्‍यो, प्हेला धों ब्योंबै ट, टए त्होर नेरो टमैं माराए टुक्राउँइँलेन् बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","चए हाँग ट्हु बैरु हार त्होंल् त्हुम्, हाँग सों पानसए तिरै छलेन तिरै हाँग सों तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ताँन् हाँगर हाडे बदामए ट धोंबै त्होर नेरो प्होमैं मुँबै सों-सौंलो ट बनेसि हाँगमैं पैरेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","छलेन पानस बत्तिर हाडे बदामए ट धोंब प्लिउलो, टए त्होर नेरो ट या तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","सोंजोर हाँगमैंए ताँन् जोर न्होंर घ्रि-घ्रि टए त्होर बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","पानस बत्ति, टए त्होर नेरो हाँगमैं छ्याँबै माराए टुक्र घ्रिउँइँलेन् बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","पानसए ओंसों मि म्रोंरिगे बिसि ङिउलो पलर छ्युगु झोंसि म्रोंसि पानसए ओंसों थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","चए सलेदाए थनर नेरो मोसो झोंबै भाँडो छ्याँबै माराला बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","पानस नेरो च ताँन् सजेबै सैमैं सोंच्युसे ङ्‍ह किलो छ्याँबै माराला बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ङइ क्हिने कोंर उँइँबै नमुना धोंले क्हिइ मैंसि च्हैंसि बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“क्हिइ पर्दा च्युउलो झोंबै पबित्र तम्बु बनद्। च पर्दामैं छेनाले रोबै सुति क्वेंला तल् त्हुम्। च क्वेंमैं मु रङ (नीलो), कलेजी नेरो ओल्ग्या रङर्बै रुइ रोब तल् त्हुम्। माराए के लल् ह्रब्मैंइ बनेबै करूबमैं चर थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ताँन् पर्दामैं नाप घ्रिर्बै तल् त्हुम्, ताँन् पर्दामैं ङ्हिस्युसे प्रेउरु ह्रिंब, प्लिउरु प्ल्हाब तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ङ्‍हउलो पर्दा अर्को पर्दामैंने जोड्दिद्, छलेन अर्को पर्दा ङ्‍ह या अर्को पर्दा घ्रि‍ घ्रिने जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ओंसों जोड्दिबै भागए दे क्याइ दनेबै ङाँर मु रङर्बै सुर्कानि झोंन्। छलेन लिउँइँ जोड्दिबै भागए दे क्याइ दनेबै ङाँरै या छलेन् सुर्कानि झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","पर्दा घ्रिर ङ्‍हच्यु सुर्कानि झोंन्, छलेन लिउँइँ जोड्दिबै भागए अर्को पर्दार ङ्‍हच्यु सुर्कानि झोंन्। च सुर्कानिमैं तिरैना ह्‍वेंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","झाइले माराए अङ्‌कुसि ङ्‍हच्यु बनेसि पर्दामैं जोड्दिद्, छलमा पबित्र तम्बु घ्रिन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“पबित्र तम्बु हुबै ल्हागिर रए मुइइ रोबै क्वेंए पर्दा च्युसे घ्रि टुद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ताँन् पर्दामैं च्युसे सों मिटर ह्रिंब नेरो मिटर ङ्हि प्ल्हाब तल् त्हुम्। च्युसे घ्रि पर्दामैं नाप घ्रिर्बैन् तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ङ्‍हउलो क्वें गैंदिसि पर्दा घ्रि बनेदु। छलेन टुउलो क्वें गैंदिसि पर्दा घ्रि बनेद्। टुउलो क्वें गैंदिसि बनेबै पर्दा बिस्याँ तम्बुए ओंसों च्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ओंसों गैंदिबै भागए क्याइ दनेबै पर्दाए ङाँर ङ्‍हउलो सुर्कानि झोंन्, छलेन अर्को गैंदिबै भागए क्याइ दनेबै पर्दाए ङाँरै या ङ्‍हउलो सुर्कानि झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","पर्दा ङ्हिं गैंदिसि घ्रिन् लबै ल्हागिर क्हिइ काँसाए ङ्‍हच्यु अङ्‍कुसि बनेसि पर्दाए सुर्कानिर झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ङैब आधा पर्दा पबित्र तम्बुए लिउँइँ च्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","तम्बु हुसि ह्रिंग्यो तबै पर्दा तिउरु छुइ हार धै तिउरु छाइबै हार पबित्र तम्बु हुबै ल्हागिर पर्दाए ङो ङ्हिंर च्योइ थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“तम्बु हुबै ल्हागिर ओल्ग्या रङ फोबै क्यु साँडए ट्हुबिए पर्दा बनद्, छलेन सिल ताँगाए ट्हुबिए अर्को पर्दा बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“पबित्र तम्बुए ल्हागिर बबुल सिंए फालेमैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","च फालेमैं ताँन् च्युउरु ह्रिंब, छलेन तिउरुसे आधा प्ल्हाब तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","च फालेमैं जोड्दिबै ल्हागिर च फालेमैंर ङ्हिं-ङ्हिं चोसोमैं थेंल् त्हुम्। क्हिइ पबित्र तम्बुए ल्हागिर ताँन् फालेमैं छलेन् बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","पबित्र तम्बुए छ्यो ल्हुए (दक्षिण) भागए ल्हागिर ङ्हिस्यु फालेमैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","च ङ्हिस्यु फालेए न्होंर चाँदिए प्लिच्यु क्योबै क्ल्ह्‍यो बनेद्। क्योबै क्ल्ह्‍यो ङ्हिं फाले घ्रिर न्होंर थेंन्, धै ताँन् चोसाए न्होंर क्योबै क्ल्ह्‍यो घ्रि थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","पबित्र तम्बुए उत्तर हारए ल्हागिर ङ्हिस्यु फालेमैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","झाइले च फालेमैंए न्होंर क्योबै क्ल्ह्‍यो ङ्हिं योल्‍ले चाँदिए प्लिच्यु क्योबै क्ल्ह्‍योमैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","पबित्र तम्बुए छ्यो न्हुए भागए (पश्‍चिम दिशा) ल्हागिर टुउलो फाले बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","कुना-कुनार झोंबै ल्हागिर क्हिइ फाले ङ्हिं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","च फालेमैं ताइले माइ समा ङ्हिथु खप्टिदिद्, च फालेमैं न्ह घ्रिर्न जोड्दिद्। च फालेमैं ङ्हिं या छलेन् जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","‍तम्बुर फ्रेउलो फालेमैं तल् त्हुम्, च फालेए ल्हागिर चाँदिए च्युसे टुउलो क्योबै क्ल्ह्‍यो तल् त्हुम्। फाले घ्रिए न्होंर ङ्हिं-ङ्हि क्योबै क्ल्ह्‍यो तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“क्हिइ बबुल सिंए बारमैं बनेद्। च्युसे ङ्‍ह पेडो तबै बारमैं बनेद। पबित्र तम्बुए तिरैबै फालेमैंए ल्हागिर ङ्‍हउलो बार बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","छलेन अर्को फालेमैंए ल्हागिर ङ्‍हउलो बार बनेद्। धै छ्यो न्हुए भागर्बै फालेमैंए ल्हागिर ङ्‍हउलो बार बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","फालेमैंए म्हाँजोर मुँबै बार छेउ घ्रिउँइँले अर्को छेउ समा फनेल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","फालेमैं माराइ म्होरद्। बारमैं क्हाबै ल्हागिर माराए न्हमैं बनेद्। बारमैं या माराइ म्होरल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“क्हिलाइ कोंर नमुना उँइँब् धोंले पबित्र तम्बु बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“झाइले पबित्र तम्बुए न्होंर सजेबै ल्हागिर, मु रङ, कलेजी रङ, ओल्ग्या रुइ छेनाले ख्रिंबै सुति क्वेंए पर्दा बनेद्। धै सिपालु म्हिइ बनेबै करूबमैं चर थेंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","माराइ म्होरबै बबुल सिंए प्लिउलो त्होर माराए अङ्‍कुसिइ च पर्दा च्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","क्हिइ च पर्दामैं अङ्‍कुसिइ च्योद् धै चए लिउँइँ ठिम थेंबै मुदुस थेंन्। च पर्दाइ क्हेमैंए ल्हागिर पबित्र क्ल्ह्‍योलाइ ताँन् भन्दा पबित्र क्ल्ह्‍योउँइँले स्यो लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ताँन् भन्दा पबित्र क्ल्ह्‍योर्बै ठिम थेंबै मुदुसए फिर क्हा थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","पर्दाए बैरु हार पबित्र क्ल्ह्‍योए उत्तर हार टेबल थेंन्, छलेन पबित्र क्ल्ह्‍योए छ्यो न्हुउँइँ टेबलए ओंसों पानस थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“तम्बुए म्राए ल्हागिर मु रङ, कलेजी रङ, ओल्ग्या रु नेरो छेनाले रोबै सुति क्वेंए बुट्‍टा फ्रिंबै पर्दा बनेद। ");
INSERT INTO gvr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","च पर्दाए ल्हागिर बबुल सिंए त्हो ङ्‍ह बनेद्, धै च त्होलाइ माराइ म्होरद्। अङ्‍कुसिमैं माराल तल् त्हुम्। चए ल्हागिर काँसाए ङ्‍हउलो क्हा बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“क्हिइ बबुल सिंए ङ्‍हउरु ह्रिंब, ङ्‍हउरु प्ल्हाब, सोंउरु नुब चार पाटे मिइ ख्रोंसि ख्रो पिंबै क्ल्ह्‍यो बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","चए कुना प्लिर रु घ्रि-घ्रि बनेद्। ख्रो पिंबै क्ल्ह्‍यो नेरो रु सिं घ्रिउँइँलेन् बनेल् त्हुम्। च ख्रो पिंबै क्ल्ह्‍योलाइ काँसाइ म्होरद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","छि ङ्हाँबै मेब्रो तोबै भाँडोमैं नेरो बेल्चामैं, प्हेला, अङ्‍कुसि तबै काँटा नेरो मिर ह्‍योबै भाडोमैं ताँन् काँसाल बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","काँसाए जालि घ्रि बेनेसि चए कुना प्लिर काँसाए न्ह प्लि प्ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","जालि ख्रो पिंबै क्ल्ह्‍योए न्होंर ङाँए च्हो-च्होर थेंन्, छले थेंमा जालि ख्रो पिंबै क्ल्ह्‍योए म्हाँजोर समा फेनेल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","ख्रो पिंबै क्ल्ह्‍यो नोबै प्हरेमैं बबुल सिंल बनेसि काँसाइ म्होरद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ख्रो पिंबै क्ल्ह्‍यो नोमा च प्हरेमैं ख्रो पिंबै क्ल्ह्‍योए न्ह ङ्हिंर क्ह्‍युद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","ङइ क्हिलाइ कोंर उँइँब् धोंले च ख्रो पिंबै क्ल्ह्‍यो खोत्ते फालेल बनेद्।” ");
INSERT INTO gvr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“क्हिइ ङ टिबै पबित्र तम्बुए कारग्युले ह्‍यु बनेसि बार थोदु, चए छ्यो ल्हुए (दक्षिण) भाग प्र क्रुल तल् त्हुम्, चलाइ थोबै ल्हागिर छेनाले ख्रिंबै सुति क्वेंए पर्दा बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","पर्दा च्योबै ल्हागिर काँसाए त्हो ङ्हिस्यु, धै त्हो क्योबै क्ल्ह्‍यो या ङ्हिस्युन् काँसाल् तल् त्हुम्। झाइले चर च्योबै छोमैं नेरो अङ्‍कुसि बिस्याँ चाँदिल् तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","छलेन उत्तरउँइँबै भागए ल्हागिरै या प्र क्रु ह्रिंबै पर्दा तल् त्हुम्। चए त्होमैं ङ्हिस्यु, त्हो क्योबै क्ल्ह्‍यो या ङ्हिस्युन् काँसाल तल् त्हुम्। दिलेया त्होमैंए अङ्‍कुसि नेरो छोमैं बिस्याँ चाँदिल तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ङाँए छ्यो न्हुउँइँबै पर्दामैं ङ्‍हच्यु क्रु तल् त्हुम्। चए त्होमैं च्युउलो क्योबै क्ल्ह्‍यो या च्युउलो तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","स्यारउँइँबै (पूर्ब पट्टि) भागए ल्हागिर ङ्‍हच्यु क्रुर्बै पर्दा तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","मुल म्राए तिरैबै भागए ल्हागिर च्युसे ङ्‍ह क्रु पर्दा तल् त्हुम्। चए त्होमैं सोंउलो, क्योबै क्ल्ह्‍यो या सोंउलोन् तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","अर्को हारए ल्हागिरै या च्युसे ङ्‍ह क्रु पर्दामैं तल् त्हुम्। चए त्हो सोंउलो क्योबै क्ल्ह्‍यो या सोंउलोन् तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“म्राए ल्हागिर मु रङ, कलेजी रङ नेरो ओल्ग्या रुइ रोबै क्वें नेरो छेनाले ख्रिंबै सुति क्वेंए बुट्टा झोंबै ङ्हिस्यु क्रुए पर्दा तल् त्हुम्। चए त्होमैं प्लिउलो, क्योबै क्ल्ह्‍यो या प्लिउलो तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","घेराए प्लि हारर्बै त्होमैंए छो नेरो अङ्‍कुसिमैं चाँदिल तल् त्हुम्। चए क्योबै क्ल्ह्‍योमैं काँसाल तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","घेरा प्र क्रु ह्रिंब नेरो ङ्‍हच्यु क्रु प्ल्हाब तल् त्हुम्। चए पर्दामैं छेनाले ख्रिंबै सुति क्वेंए ङ्‍हउरु ह्रिंब तल् त्हुम्। चए क्योबै क्ल्ह्‍योमैं काँसाल तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","पबित्र तम्बुर चैदिबै तोन्दोंरि सैमैं नेरो काँटिमैं काँसाल तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“बत्ति म्रोबै ल्हागिर म्हाबै जैतुनए छ्याँबै छ्युगु पइ खो बिसि इस्रलिमैंने बिद्। धै बत्तिमैं खोंयोंन् बिलै लुँरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","पबित्र तम्बुर ठिम थेंबै मुदुसए उँइँर्बै पर्दाए बैरु हारून नेरो चए च्हमैंइ याहवेहए उँइँर च बत्तिमैं ङेसउँइँले न्हाँग समा लुँरिल् लल् त्हुम्। इस्राएलीमैंए पुस्ता-पुस्ता समा खोंयोंन् बिलै चु के लल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“ङए ल्हागिर खेगि (पुजारि) के लरिगे बिसि इस्राएलीमैंए म्हाँजोउँइँले क्हिए आघें हारून नेरो चए च्हमैं नादाब, अबिहू, एलाजार नेरो इताममार क्हि ङाँर हुइद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","क्हिए आघें हारूनए ल्हागिर बेल्‍ले छ्याँब नेरो इजेत तबै खेगिइ खिबै क्वें टुमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","‘हारूनइ खेगि के लबै ल्हागिर खेगिइ खिबै क्वें टुमिंन्,’ बिसि ङइ क्वें टुबर लोमिंब्मैंने बिद्। च क्वें खिसि चइ ङए सेवा लरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","क्हिए आघें हारून नेरो चए च्हमैं खेगि तसि ङए सेवा लबै ल्हागिर च क्वें टुब्मैंइ चमैंए ल्हागिर चु पबित्र क्वें टुमिंरिगे: तिंर खिबै क्वें, एपोद, लबेदा, अलखा, क्रेगि नेरो फगि। ");
INSERT INTO gvr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","चुमैंइ चु क्वें टुमा मारा, मु रङ, कलेजी रङ, ओल्ग्या रङ नेरो छेनाले ख्रिंबै सुतिए क्वेंल टुरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“च क्वें टुब्मैंइ एपोद टुमा मारा, मु रङ, कलेजी रङ, ओल्ग्या रङ नेरो छेनाले ख्रिंबै सुतिए क्वेंल छेनाले टुरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","च क्वेंमैं जोड्दिबै ल्हागिर काँदए छेउ ङ्हिंर फैसों ङ्हिं तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","फिर खिबै फगि एपोद टुबै क्वेंउँइँलेन् मारा, मु रङ, कलेजी रङ, ओल्ग्या रङ नेरो छेनाले ख्रिंबै सुतिए क्वेंल टुल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“इस्राएलए च्हमैंए मिं आनिक्स बिबै युँमा ङ्हिंर प्ह्रिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","च्ह थेबइले सुरु लसि च्ह टुए मिं आनिक्स बिबै युँमा घ्रिर खोप्दिसि प्ह्रिद्, अरू च्ह टुए मिं अर्को आनिक्स बिबै युँमार खोप्दिसि प्ह्रिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","युँमार खोप्दिल् ह्रब्मैंइ खैले खोप्दिमुँ, छलेन् युँमा ङ्हिंर इस्राएलए च्हमैंए मिं खोप्दिद्। झाइले च युँमा माराए के लबै म्हिने जोड्दिबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","इस्राएलए च्हमैं मैंबै ल्हागिर च युँमा ङ्हिं एपोदए प्हैंदर च्योमिंन्। झाइले याहवेहजी खोंयोंन् बिलै मैंरिगे बिसि चमैंए मिं हारूनइ ह्रोंसए प्हैंदर नोरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","झाइले क्हिइ मारा तोबै धिं ङ्हिं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","छो धोंले ख्रिंबै छ्याँबै माराए सिक्रि ङ्हिं बनेद्, धै च ख्रिंबै सिक्रि मारा तोबै धिंर जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“निसाफ लबै म्हिए ल्हागिर छेनाले टुल् ह्रबै म्हिए लहागिर तिंर खिबै क्वें बनेद्। एपोद बनेब् धोंलेन् मारा, मु रङ, कलेजी रङ, ओल्ग्या रङ नेरो छेनाले ख्रिंबै सुतिए क्वेंल टुल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","च क्वें चार पाटे नेरो ङ्हिबाताले टुल् त्हुम्। च बित्ता घ्रि ह्रिंब, बित्ता घ्रिन् प्ल्हाब तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","चर मणिजगोए प्लिउलो ल्हस्यार लसि मणिमैं जोड्दिद्। ओंसोबै ल्हस्यारर मानिक, पुष्‍पराज नेरो बेरुज झोंन् ");
INSERT INTO gvr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ल्हस्यार ङ्हिंर फिरोजा, निर नेरो पन्‍ना झोंन्, ");
INSERT INTO gvr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ल्हस्यार सोंर नीलमणि, हाकिक नेरो कटेलाल झोंन्, ");
INSERT INTO gvr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ल्हस्यार प्लिर पितमणि, आनिक्स नेरो बिल्‍लौर झोंन्। चु ताँन् मारा तोबै धिंजरे बोसि जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","इस्राएलए कुल ङो सेबै ल्हागिर च च्युसे ङ्हिं मणिर याकूबए च्युसे ङ्हिं च्हमैंए मिं घ्रि-घ्रिले खोप्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“तिंर खिबै क्वेंए ल्हागिर छो धोंले ख्रिंबै छ्याँबै माराए सिक्रिमैं बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","माराए रिंङ ङ्हिं बनेसि तिंर खिबै क्वेंए कुना ङ्हिंर च्योमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","च माराए सिक्रि ङ्हिं तिंर खिबै क्वेंए छेउ-छेउर मुँबै रिंङ ङ्हिंर जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","च सिक्रि ङ्हिंए च्हो ङ्हिं बिस्याँ मारा तोबै धिंर जोड्दिसि एपोदए काँदर्बै फैसोंए ओंसों खिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","धबै माराए न्ह ङ्हिं बनेसि तिंर खिबै क्वेंए न्होंर्बै कुना ङ्हिंर एपोदए ङाँर जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","धबै माराए न्ह ङ्हिं बनेसि एपोदए उँइँ हार काँद ङ्हिंर्बै फैसोंए न्होंउँइँले नेरो एपोदए फिर खिबै फगिए फिर्बै सिउनिर जोड्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","तिंर खिबै क्वें एपोदउँइँले आसर्दिरिगे बिसि तिंर खिबै क्वें रिंङउँइँले एपोदए रिंङजगोर मु रङर्बै फित्ताइ फगिर फैद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“हारून पबित्र क्ल्ह्‍योर होंमा चइ इस्राएलए कुलए मिं खोप्दिबै तिंर खिबै क्वें खिब्मुँ धै ङ याहवेहजी ङए म्हिमैं मैंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","तिंर खिबै क्वेंर ऊरीम नेरो तुम्मिम थेंन्। हारून ङए ओंसों खब्रें लमा चए तिंर खिबै क्वें तल् त्हुम्। छले हारूनइ इस्राएलीमैंए ल्हागिर ङए इच्छा तो मुँ च छेनाले था सेल् खाँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“एपोद फिर खिबै क्वें ताँन् मु रङल बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","चर क्र क्ह्‍युबै क्ल्ह्‍यो बनेद्, धै क्र क्ह्‍युबै क्ल्ह्‍यो आट्होरिगे बिसि कारग्युर्ले रोसि घेराए ङाँ सैद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","चए प्ह्रिर्बै ङाँर मु रङ, कलेजी रङ, नेरो ओल्ग्या रुइ अनार बनेसि म्हाँ-म्हाँजोर माराए स्यों च्योमिन्। ");
INSERT INTO gvr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","चए प्ह्रिर्बै ङाँर माराए स्यों नेरो अनार कारग्युले च्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","हारूनइ खेगि के लमा च क्वें खिरिगे। च पबित्र क्ल्ह्‍योर ङए ओंसों खमा बैरु त्होंमा स्योंए कै थेब्मुँ धै च सिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“क्हिइ पबित्र माराए प्लना बनेसि च्यार छाप झोंब् धोंले ‘याहवेहए ल्हागिर पबित्र’ बिसि चर खोप्दिद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","धै चलाइ मु रङए छोइ उँइँ तल्‍ले फैसि ");
INSERT INTO gvr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","हारूनए ङ्‍होर खिद्, धै याहवेहए मिंर इस्राएलीमैंइ भेटिमैं पिंमा गल्ति तलेया च दोष हारूनइ नोरयगे बिसि खोंयोंन् बिलै हारूनए ङ्‍होर च ङ्‍होर खिबै सै तल् त्हुम्। छलस्याँ इस्राएलीमैंइ पिंबै भेटिमैं याहवेहजी किंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“प्हले समा फेनेबै ह्रिंग्यो क्वें नेरो क्रेगि छेनाले ख्रिंबै सुति क्वेंल बनेदु। बुट्टा झोंबै रुइन फगि या बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“क्हिइ हारूनए च्हमैंए ल्हागिर बेल्‍ले मान तबै छ्याँबै लबेदा, फगि, नेरो क्रेगिमैं टुद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","चु क्वेंमैं क्हिए आघें नेरो चए च्हमैं खिमिंसि खेगि के लबर चमैंलाइ त्हाँसि छ्युगु फोद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“चमैंए ज्यु हुबै ल्हागिर प्हले लिगु समा फेनेल्‍ले सुति क्वेंए न्होंर खिबै क्वें टुद्। ");
INSERT INTO gvr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","चमैंने छ्याब् आतरिगे धै आसिरिगे बिसि हारून नेरो चए च्हमैं पबित्र क्ल्ह्‍योर सेवा लबर ङ ङाँर खमा च क्वें खिरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“ङए सेवा लबर हारून नेरो चए च्हमैंलाइ पबित्र लबर क्हिइ चमैंए ल्हागिर लल् त्हुबै के चुन् ग: तोइ खोट आरेबै क्ल्या भारा नेरो क्यु साँड् ङ्हिं पइ खो। ");
INSERT INTO gvr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","झाइले गहुँए प्रोए क्हें, छ्युगुर चेंबै फुरौला नेरो छ्युगु फोबै बाबर क्हें प्लेढा आझोंल्‍ले बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ट्हलोर झोंसि क्हेंए ट्हलो क्ल्या भारा नेरो क्यु साँड्मैं पइ खो। ");
INSERT INTO gvr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“च लिउँइँ हारून नेरो चए च्हमैं ङ टिबै पबित्र तम्बुए म्रा ङाँर पखसि चमैंलाइ ख्रुमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","झाइले हारूनलाइ लबेदा, एपोद न्होंर खिबै क्वें, एपोद, नेरो तिंर खिबै क्वें खिसि चए फिर फगि खिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","चए क्रर क्रेगि तिमिंन् झाइले क्रेगिए फिर पबित्र मुकुट कुमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","च लिउँइँ अभिषेक लबै छ्युगु चए क्रर कुमिंसि चलाइ स्यो लद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“हारूनए च्हमैं पखसि लबेदा खिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","हारूनए च्हमैंए क्रर क्रेगि तिंमिंन्। धै हारून नेरो चए च्हमैंलाइ फगि खिमिंन्। झाइले खोंयोंन् बिलै चमैं खेगि तल् योंब्मुँ। छले हारून नेरो चए च्हमैं खेगि के लबर त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“च क्ल्या भारा ङ टिबै पबित्र तम्बुए ओंसों पइ खो, चमैंए क्रए फिर हारून नेरो चए च्हमैंइ यो थेंबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","च क्ल्या भारा ङ टिबै पबित्र तम्बुए म्रा ओंसों सैसि ख्रो पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","क्ल्या भाराए च्युगुदे को योरिंइ किंसि ख्रो पिंबै क्ल्ह्‍योए कुना प्लिर्बै रुर फोद्, धै ङैबै को ख्रो पिंबै क्ल्ह्‍योए न्होंर ङेवाद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","झाइले न्हाँनु भुँडिमैं हुबै छि नेरो ओएटा, खइ नेरो चए फिर्बै छि किंसि ख्रो पिंबै क्ल्ह्‍योर ख्रोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","दिलेया, क्ल्या भाराए से, ट्हुबि नेरो न्हाँनुमैं म्हिमैं टिबै ब्यारेकए बैरु बोसि ख्रोंन्। चु खेगिमैंए पाप ख्रुबै ख्रो ग। ");
INSERT INTO gvr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“धबै क्यु साँड् घ्रि किंसि चए क्रर हारून नेरो चए च्हमैंने यो थेंबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","च क्यु साँड् ख्रो पिंसि चए को ख्रो पिंबै क्ल्ह्‍योए कारग्युले फ्रुँन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","क्यु साँड्लाइ कुदु-कुदु लसि चए न्हाँनु नेरो प्हलेमैं ख्रुसि क्रने बालन् थेंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","च सक्लोन् क्यु साँड् ख्रो पिंबै क्ल्ह्‍योर ख्रोंन्। चए छ्याँब थाँइ ङ सैं तोंन् लम्। ");
INSERT INTO gvr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“क्हिइ अर्को क्यु साँड् किंन्, हारून नेरो चए च्हमैंइ च क्यु साँडए क्रर यो थेंबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","च क्यु ख्रो पिंसि चए च्युगुदे को किंसि हारून नेरो चए च्हमैंए क्योलो हारबै न्हमे नेरो चमैंए क्योलो योए यो आबा नेरो प्हले आबार फोद्। ङैब को ख्रो पिंबै क्ल्ह्‍योए कारग्युले फ्रुँमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ख्रो पिंबै क्ल्ह्‍योर्बै को नेरो अभिषेक लबै छ्युगु च्युगुदे किंसि हारून नेरो चए क्वेंर फ्रुमिन्। छलेन हारूनए च्हमैं नेरो चमैंए क्वेंरै या फ्रुमिंन्। छलमा हारून, चए च्हमैं नेरो चमैंए क्वेंमैं या पबित्र तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“चु क्यु साँडेए छि, छि मुँबै मे, न्हाँनु भुँडिमैं हुबै छि, ओएटा, छि मुँबै पाङरु ङ्हिं नेरो क्योलो प्हाँ क्ह्‍याँसि किंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","याहवेहए उँइँर मुँबै प्लेढा आझोंबै क्हें झोंबै ट्हलोउँइँले क्हें घ्रि नेरो छ्युगुर ख्रोंबै फुरौला घ्रि नेरो बाबर किंसि ");
INSERT INTO gvr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","चु ताँन् हारून नेरो चए च्हमैंए योर थेंन्। चु सैमैं याहवेहजी खोबै छ्याँबै ख्रो तबर पिंबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","झाइले याहवेहजी खोबै थाँ तरिगे बिसि ङइ खोबै भेटिमैं चमैंए योइ मिइ ख्रोंबै ख्रोने बालु ख्रो पिंबै क्ल्ह्‍योर ख्रोंवान्। चु याहवेहए ल्हागिर मिउँइँले चडेबै ख्रो ग। ");
INSERT INTO gvr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“झाइले हारूनइ ख्रो पिंबै क्यु साँडए कु से किंसि याहवेहजी खोबै छ्याँबै ख्रो तबर पिंन्। च क्हिए भाग तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“अर्पण लबै क्यु साँडउँइँले हारून नेरो चए च्हमैंए ल्हागिर क्युए कु से नेरो प्हाँ से पबित्र लद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","इस्राएलीमैंइ हारून नेरो चए च्हमैंए ल्हागिर खोंयोंन् बिलै पिंल् त्हुबै भाग चुन् तल् त्हुम्। तलेबिस्याँ इस्राएलीमैंइ क्ह्रिमिंबै भेटिमैंउँइँले याहवेहए ल्हागिर पिंल् त्हुबै भाग चुन् ग। ");
INSERT INTO gvr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“हारूनए पबित्र क्वें चए च्हमैंलाइ पिंन्, चमैंइ च क्वें खिसि अभिषेक लसि खेगि तबर त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","हारूनए साटोर खेगि के लबै च्ह ङ टिबै पबित्र तम्बु न्होंर सेवा लबर खमा ङिगैं समा च कवें खिल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“खेगि त्हाँमा सैबै क्यु साँड् बोसि चए से पबित्र क्ल्ह्‍योर ह्‍योद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","च लिउँइँ हारून नेरो चए च्हमैंइ च क्युए से नेरो ट्हलोर मुँबै क्हें ङ टिबै पबित्र तम्बुए म्रा ङाँर चरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","चमैंलाइ त्हाँसि पबित्र लबर तो-तो सैमैंइ ओलेल, च सैमैं चमैंइ चरिगे। अरू म्हिमैंइ बिस्याँ आचरिगे, तलेबिस्याँ च पबित्र मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","क्युए से नेरो क्हेंमैं प्हन्हाँग समा ङैस्याँ च मिर ख्रोंवान्। च खाबज्यै या आचद्, तलेबिस्याँ च पबित्र मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ङइ क्हिने बिब् धोंले हारून नेरो चए च्हमैंने लद् बिद्। ङिगैं छ्युल्‍ले चमैंलाइ त्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","पाप क्षमा तबै ल्हागिर त्हिंइ ह्रोंसे क्हिइ क्ल्या भारा सैसि ख्रो पिंन्, धै ख्रो पिंबै क्ल्ह्‍यो क्षमा तबै ल्हागिर ख्रो पिंमा चलाइ पबित्र लबर जैतुनए छ्युगु कुसि अभिषेक लद्। ");
INSERT INTO gvr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ख्रो पिंबै क्ल्ह्‍योलाइ पाप क्षमा तब नेरो पबित्र लबै ल्हागिर ङिगैं समा क्हिइ ख्रो पिंबै क्ल्ह्‍योर छ्युगु कुसि अभिषेक लद्। छलमा ख्रो पिंबै क्ल्ह्‍यो बेल्‍ले पबित्र तब्मुँ धै चलाइ छुइबै तोन्दोंरि सैमैं या पबित्र तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ख्रो पिंबै क्ल्ह्‍योर खोंयोंन् बिलै त्हिंइ ह्रोंसे तिदिंर्बै क्यु ङ्हिं क्हिइ ख्रो पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","क्यु घ्रि न्हाँगर क्यु घ्रि ङेसर ख्रो पिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","न्हाँगर सैबै क्युने बालु लिटर घ्रि जैतुनए छ्युगुर चेंबै किलो घ्रि प्रो नेरो अर्ग बलिए ल्हागिर लिटर घ्रि अँगुरए कुमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ङेसर सैबै क्युने बालु या न्हाँगर्बै धोंलेन् रा-रोए ख्रो नेरो अर्ग बलि पिंल् त्हुम्। याहवेहए ल्हागिर लिंबै थाँ खबै ख्रो या मिर ख्रोंसि पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“क्हेमैंए पुस्ता-पुस्ता समा याहवेहए उँइँर पबित्र तम्बुए म्रा ङाँर मिर ख्रोंसि ख्रो पिंब्रें लद्। च क्ल्ह्‍योर्न ङ क्हिने ताँ लबर क्हिने त्होब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","इस्राएलीमैंने ङ चर्न त्होब्मुँ। ङए चारबै ह्‍वेइ च तम्बु पबित्र लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“ङइ ख्रो पिंबै क्ल्ह्‍यो नेरो तम्बु पबित्र लब्मुँ। झाइले हारून नेरो चए च्हमैंलाज्यै या खेगि तसि ङए सेवा लबै ल्हागिर पबित्र लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","इस्राएलीमैंए म्हाँजोर ङ टिब्मुँ, धै चमैंए परमेश्‍वर तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","ङ याहवेह चमैंए परमेश्‍वर ग धै ङ चमैंए म्हाँजोर टिबै ल्हागिर ङइ चमैंलाइ मिश्र ह्‍युलउँइँले तेइ पखइ बिसि चमैंइ सेब्मुँ। ङ याहवेह चमैंए परमेश्‍वर ग। ");
INSERT INTO gvr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“धुप म्रोबै ल्हागिर क्हिइ अर्को बबुल सिंए क्ल्ह्‍यो घ्रि बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","च तिउरु ह्रिंब, तिउरु प्ल्हाब, ङ्हिउरु नुब चार पाटे तल् त्हुम्। चए रुमैं या क्ल्ह्‍यो बनेबै सिंए टुक्राल तल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","चए क्होइबै भाग, कारग्युबै भागमैं नेरो चए रुमैं या छ्याँबै माराइ म्होरसि चए कारग्युले माराए ङाँ सैद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","माराए न्हमैं बनेसि क्ल्ह्‍योए हार ङ्हिंर प्ह्‍याद्। च क्ल्ह्‍यो नोबै ल्हागिर चए ङाँ न्होंर प्हरे क्युलबै क्ल्ह्‍यो तल् त्हमु। ");
INSERT INTO gvr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","च प्हरेमैं या बबुल सिंल बनेसि माराइ म्होरद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","चु धुप म्रोबै क्ल्ह्‍यो ठिम थेंबै मुदुसए ओंसों च्योथेंबै पर्दाए ओंसों थेंन्, चर्न ङ क्हिने त्होब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“न्हाँग ह्रोंसे बत्ति तयार लबर खमा हारूनइ छ्याँब थाँ खबै धुप च क्ल्ह्‍योर म्रोरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","ङेसरै या बत्ति म्रोमा हारूनइ छ्याँब थाँ खबै धुप च क्ल्ह्‍योर म्रोरिगे। छलेन खबै पुस्ता-पुस्ता समा खोंयोंन् बिलै याहवेहए उँइँर धुप म्रोरिल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","चु क्ल्ह्‍योर क्हिइ अरू खालर्बै धुप, मिर ख्रोंसि पिंबै ख्रो, रा-रोए ख्रो नेरो प्हा या आचडेद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","सालर तिला हारूनइ पाप ख्रुबर ख्रो पिंबै खेदोए को चए प्लिउलो रुर फोसि चु क्ल्ह्‍यो पबित्र लरिगे। चु पबित्र लबै के पुस्ता-पुस्ता समा सालर तिला लरिल् त्हुम्। ङ याहवेहए ल्हागिर चु क्ल्ह्‍यो बेल्‍ले पबित्र ग।” ");
INSERT INTO gvr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“क्हिइ इस्राएलीमैं च्योमा चमैंए न्होंर्बै ताँनइ ह्रोंस सोल् योंरिगे बिसि याहवेहलाइ सै फोल् त्हुब्मुँ, छलमा चमैंए फिर दुःख खरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","च्योब्मैं ताँनइ तोक्दिबै मुइ फोल् त्हुब्मुँ। च तोक्दिबै मुइ भेटिए रुपर ताँनइ फोल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ङ्हिस्यु बर्ष भन्दा क्होइबै म्हिमैंइ याहवेहए मिंर च मुइ पिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","क्हेमैं पाप क्षमा तबै ल्हागिर याहवेहए मिंर भेटि पिंमा प्लब्मैंइ ल्हें ङ्हाँदुमैंइ च्युगुदे आपिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","च भेटि क्हेमैं पाप क्षमा तबै ल्हागिर पिंब् ग बिसि याहवेहजी इस्राएलीमैं मैंरिगे बिसि इस्राएलीमैंउँइँले मुइ किंसि पबित्र तम्बुए ल्हागिर खर्ज लदु।” ");
INSERT INTO gvr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“क्यु झोंबै ल्हागिर काँसाए प्हले मुँबै काँसाए बाटा बनेसि पबित्र तम्बु नेरो मिइ ख्रोंसि ख्रो पिंबै क्ल्ह्‍योए म्हाँजोर थेंसि चर क्यु झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","हारून नेरो चए च्हमैंइ च क्युइ यो प्हले ख्रुरिगे। ");
INSERT INTO gvr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","चमैं पबित्र तम्बुर होंस्याँ, धै याहवेहए मिंर ख्रो पिंबै क्ल्ह्‍योर ख्रो ख्रोंबर खस्याँ चमैंइ चु क्युइ यो-प्हले ख्रुल् त्हुम। आस्याँ चमैं सियाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","चमैं आसिरिगे बिसि चमैंइ चु क्युइ यो-प्हले ख्रुरिगे। हारून नेरो चए पुस्ता-पुस्ता समा छलेन् प्हले ख्रुल् त्हुब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“क्हिइ ताँन् भन्दा छ्याँब मसला, लिटर घ्रि मूर्र, आधा किलो दालचिनि, आध किलो बोझो, ");
INSERT INTO gvr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","किलो घ्रि लेपो, चु ताँन् सैमैं पबित्र तम्बुर मुँबै पाराइ क्वेल् त्हुम्। लिटर प्लि जैतुनए छ्युगु चर कोंसि ");
INSERT INTO gvr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","अभिषेक लबै ल्हागिर पबित्र छ्युगु बनेद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","झाइले ङ टिबै पबित्र तम्बु, ठिम थेंबै मुदुस, टेबल, टेबलर थेंबै सैमैं, पानस नेरो पानसर थेंबै सैमैं, धुप म्रोंबै ख्रो पिंबै क्ल्ह्‍यो, ");
INSERT INTO gvr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","टेबल नेरो चए ताँन् सैमैं, सामदान नेरो चए ताँन् सैमैं, धुप म्रोंबै ख्रो पिंबै क्ल्ह्‍यो, ");
INSERT INTO gvr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","मिर ख्रोंसि ख्रो पिंबै क्ल्ह्‍यो, चर्बै सैमैं, प्हले ख्रुबै बाटा नेरो चए प्हलेजरे या च छ्युगुइ अभिषेक लद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","च सैमैं बेल्‍ले पबित्र तरिगे बिसि छले अभिषेक लसि पबित्र लद्। च सैमैं तो सैइ छुइलेया च पबित्र तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“खेगि तसि ङए सेवा लरिगे बिसि हारून नेरो चए च्हमैं अभिषेक लसि पबित्र लदु। ");
INSERT INTO gvr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","‘इस्राएलीमैंए पुस्ता-पुस्ता समा ङए सेवा लबै ल्हागिर अभिषेक लबै पबित्र छ्युगु चुन् तरिगे,’ बिसि चमैंने बिद्। ");
INSERT INTO gvr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","‘चु छ्युगु अरू म्हिमैंए फिर आकुमिंन्, चु सैमैंन् कोंसि धबै छाबन् छ्युगु आबनेद्। चु छ्युगु पबित्र मुँ, चु छ्युगु क्हेमैंइ पबित्र मुँ ङ्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","खाबइ चु सैमैं कोंसि अभिषेक लबै छ्युगु धोंन् बनेमुँ, धै खेगि बाहेक अरू अरू म्हिमैंए फिर चु छ्युगु फोमुँ, ङए म्हिमैं ङाँइँले च म्हि तेवाब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","याहवेहजी धबै मोशाने बिइ, “लिंबै थाँ खबै मसलामैं खोटो, सेखलेट, हिङ धोंबै चोप नेरो लिंबै थाँ खबै धूपमैं बराबरले कोंसि ");
INSERT INTO gvr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","लिंब थाँ खबै छ्युगु बनेब् धोंले धुप बनेद्। च धुप पबित्र तरिगे बिसि चजै या कोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","चु धुप क्हेमैंए ल्हागिर बेल्‍ले पबित्र तल् त्हुम्। छतसि चए तिबाँ त्हुल् तल्‍ले तोंसि च्हौदे ङ टिबै पबित्र तम्बुर ठिम थेंबै मुदुसए ओंसों थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","च धुप बनेब् धोंले क्हेमैंए ल्हागिर धुप आबनेद्। याहवेहए ल्हागिर च धुप पबित्र मुँ ङ्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","च धुपए थाँ खोसि खाबज्यै या च धुप धोंले अरू धुप बनेइ बिस्याँ च ह्रोंसए म्हिमैंउँइँले तेवाल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“ङइ यहूदाए कुलर्बै हुरए क्वें नेरो ऊरीए च्ह बजलेललाइ त्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ङइ चलाइ परमेश्‍वरए प्ल्हजी प्लिंसि ह्रब सेब नेरो ताँन् खालर्बै के लल् ह्रबै सिप पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","चइ मारा, चाँदि नेरो काँसार नक्सा प्ह्रिब, ");
INSERT INTO gvr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","छलेन हिरा थोसि जोड्दिब, सिंर बुट्टा झोंब नेरो अरू ल्हें खालर्बै बुट्टा झोंबै केमैं लरिगे बिसि चलाइ त्हाँब् ग। ");
INSERT INTO gvr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","चलाइ ल्होबर दान कुलर्बै अहीसामाकए च्ह ओहोलीआबलाइया त्हाँइमुँ। धै ङइ क्हिने लद् बिबै तोन्दोंरि सैमैं बनेबर अरू ताँन् के लब्मैंलाइ ङइ सिप पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","छतसि ङ टिबै पबित्र तम्बु, ठिम थेंबै मुदुस, हुबै क्हा नेरो तम्बु सजेबै ताँन् सैमैं, चमैंइ बनेरिगे: ");
INSERT INTO gvr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","टेबल नेरो चर थेंबै समानमैं, छ्याँबै माराए पानस नेरो चए समानमैं, धुप म्रोंबै ख्रो पिंबै क्ल्ह्‍यो, ");
INSERT INTO gvr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","मिर ख्रोंसि ख्रो पिंबै क्ल्ह्‍यो नेरो चर चैदिबै सैमैं, प्हले ख्रुबर क्यु झोंबै बाटा नेरो चए प्हलेमैं, ");
INSERT INTO gvr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","खेगि के लबर हारून नेरो चए च्हमैंइ खिल् त्हुबै क्वेंमैं, ");
INSERT INTO gvr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","अभिषेक लबै छ्युगु नेरो पबित्र तम्बुए ल्हागिर लिंबै थाँ खबै धुप। ङइ क्हिने बिब् धोंले चमैंइ चु ताँन् सैमैं बनेल् त्हुब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","च लिउँइँ याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“क्हिइ इस्राएलीमैंने चु या बिद्, प्रिबै त्हिंइ ङए भों न्हबै त्हिंइ ग। छतसि क्हेमैंइ खैले बिलेना प्रिबै त्हिंइर के आलद्। क्हेमैंलाइ पबित्र लमिंम् बिसि क्हेमैंइ सेरिगे बिसि, क्हेमैं नेरो ङए म्हाँजोर चु प्रिबै त्हिंइ खोंयोंन् बिलै चिनु घ्रि तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","क्हेमैंइ प्रिबै त्हिंइर के आलद्, तलेबिस्याँ क्हेमैंए ल्हागिर चु पबित्र त्हिंइ ग। चु ताँ आम्हाँदिब्मैं खैलसे या सैल् त्हुम्। च त्हिंइर के लब्मैंलाइ समाजउँइँले तेवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","टुगैं समा के लरिगे, दिलेया ङिगैंर भों न्हबै त्हिंइ ग, चु त्हिंइ याहवेहए ल्हागिर पबित्र ग। चु त्हिंइर के लब्मैंलाइ सैवाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","इस्राएलीमैंइ च त्हिंइर के आलरिगे, खेंमैंए तुस्ता-पुस्ता समा खोंयोंन् बिलै च त्हिंइ बाछाए चिनु धोंलेन् म्हाँदिल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","इस्राएलीमैंए म्हाँजोर चु प्रिबै त्हिंइ खोंयोंन् बिलै तबै चिनु घ्रि तब्मुँ, तलेबिस्याँ याहवेहजी टुगैं न्होंर मु नेरो पृथ्‍बी बनेइ, धै ङिगैंर भों न्हइ।” ");
INSERT INTO gvr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","याहवेहजी सिनै कोंर मोशाने ताँ लल् खाँबै लिउँइँ खीए योरिंइ प्ह्रिबै युँमाए प्लना ङ्हिं खीजी मोशालाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","मोशा कोंउँइँले युब क्हैन् लब म्रोंसि इस्राएलीमैं हारून ङाँर खागु तसि “ङिलाइ मिश्र ह्‍युलउँइँले तेइ पखबै मोशालाइ तो तइ ङिइ आसे। छतसि रेद्, ङिए ओंसों-ओंसों घ्याँ तेंबर देवता घ्रि बनेमिंन्,” बिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","छबिमा हारूनइ चमैंने बिइ, “क्हेमैंए म्रिं नेरो च्ह-च्हमिंमैंइ न्हप्हेर खिबै माराए रिंङमैं प्लिसि ङ ङाँर पखो।” ");
INSERT INTO gvr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","छबिमा ताँन् म्हिमैंइ ह्रों-ह्रोंसए न्हर्बै माराए रिंङमैं प्लिसि हारून ङाँर पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","हारूनइ म्हिमैंउँइँले मारा किंसि मिर गाल्दिइ, धै कोप्दिसि क्ल्या भारा घ्रि बनेइ। छाब् म्रोंसि म्हिमैंइ बिइ, “ओ इस्राएलीमैं! क्हेमैंलाइ मिश्रउँइँले तेइ पखबै क्हेमैंए देवता चुन् ग!” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","छतसि हारूनइ माराए क्ल्या भाराए ओंसों ख्रो पिंबै क्ल्ह्‍यो घ्रि बनेसि बिइ, “प्हन्हाँग याहवेहए मिंर चाड घ्रि म्हाँदिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","प्हँन्हाँग्धों म्हिमैं न्हाँकर्न रेसि मिर ख्रोंसि पिंबै खेदोमैं नेरो क्ह्रिमिंबै भेटिमैं बोसि ख्रो पिंइ। झाइले चमैं चब् थुँब् लसि मोज लबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","छलब् म्रोंसि याहवेहजी मोशाने बिइ, “क्हि युनन् क्युरु ह्‍याद्, तलेबिस्याँ क्हिइ मिश्रउँइँले तेइ पखबै क्हिए म्हिमैंइ पाप लसि ङलाइ म्हाँदिब पिवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","ङइ प्रबर ल्हैदिबै घ्याँ चमैंइ च्हौ युनन् पिवासि अर्कोन् घ्याँ प्रइमुँ। चमैंइ ह्रोंसए ल्हागिर क्ल्या भाराए कु बनेसि चलाइन म्हाँदिसि ख्रो पिंसि, ‘ओ इस्राएलीमैं, क्हेमैंलाइ मिश्र ह्‍युलउँइँले तेइ पखबै क्हेमैंए देवता चुन् ग’ बिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","याहवेहजी मोशाने बिइ, “चु म्हिमैं बेल्‍ले आच्योब्मैं मुँन बिसि ङइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","तारे ङने तोइ आबिद्, ङ चमैंने बेल्‍ले ह्रिस खइमुँ। तारे ङइ चमैं नास लवाब्मुँ। धै क्हि ङाँइँलेन् ङइ थेबै ह्रें घ्रि बनेब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","दिलेया मोशाइ ह्रोंसए याहवेह परमेश्‍वरने यो छ्युँ लसि “ओ याहवेह!” बिइ। “क्हिइ ह्रोंसए थेबै भों मुँबै योइ मिश्रउँइँले तेइ पखबै ह्रोंसए म्हिमैंए फिर तले च्हौ थेबै ह्रिस खल? ");
INSERT INTO gvr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","क्हिइ ह्रोंसए म्हिमैंलाइ कोंर सैबै सैं लसि पखब् ग बिसि मिश्रीमैंलाइ तले बिल् पिंमुँ? छतसि क्हि ह्रिस आखद्, सैं एसि ह्रोंसए म्हिमैंलाइ नास तल् आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ह्रोंसए केब्छैंमैं अब्राहाम, इसहाक नेरो याकूबलाइ मैंन्दि। चमैंने बालु क्हिजी ह्रोंसए मिंर कसम चसि ‘ङइ क्हेमैंए सन्तान मुर्बै सारमैं धोंले ल्हें लमिंब्मुँ। ङइ क्हेमैंए खेमैंलाइ पिंम् बिसि बाछा फैबै चु ताँन् ह्‍युल क्हेमैंए सन्तानलाइ पिंब्मुँ, धै क्हेमैंए सन्तानमैंइ च क्ल्ह्‍योर खोंयोंन् बिलै क्ल्हे लब्मुँ’ बिसि बिल।” ");
INSERT INTO gvr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","छबिमा याहवेहजी ह्रोंसए म्हिमैंलाइ नास लवाब्मुँ बिलेया खीजी सैं एसि चमैंलाइ जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","झाइले परमेश्‍वरजी लद् बिबै ताँमैं हार ङ्हिर्न प्ह्रिबै युँमाए प्लना ङ्हिं योर किंसि मोशा कोंउँइँले तयुइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","परमेश्‍वर खीजीन च युँमाए पलानमैं बनेसि खीजी लद् बिबै ताँमैं चर प्ह्रिथेंल। ");
INSERT INTO gvr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","म्हिमैं कै तेब् थेसि यहोशूइ मोशाने “ब्यारेक न्होंर म्हिमै प्होंब् धों तबै कै थेइमुँ,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","दिलेया मोशाइ बिइ, “चु कैम् लडइ ट्होब्मैंलै या आङिं, हार्दिब्मैंलै या आङि। ङइमि क्वे प्रिंबै कै ग थेइमुँ दि।” ");
INSERT INTO gvr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","झाइले मोशा ब्यारेक चेंदों खरिमा माराए क्ल्या भाराए उँइँर म्हिमैं सेरिब् म्रोंइ। छतमा मोशा बेल्‍ले ह्रिस खसि च युँमाए प्लनामैं कोंए जरर भ्योंवामा च तियाइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","छलेन चमैंइ बनेबै माराए क्ल्या भारा मिर त्हुला भुँले ख्रोंवासि क्युर कोंवाँइ, धै च क्यु इस्राएलीमैंलाइ थुँबर ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","च लिउँइँ मोशाइ हारूनने बिइ, “चु म्हिमैंइ क्हिलाइ तो लइ? क्हिइ चुमैंलाइ तले च्हौ थेबै पाप के लबर ल्हैदिब?” ");
INSERT INTO gvr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","हारूनइ बिइ, “ओ चिब, क्हि ङने ह्रिस आखमिंन्। चु म्हिमैं खैतब् मुँ बिसि क्हिइ सेइमुँ। चुमैं खोंयोंन् बिलै आछ्याँबै के लदा ङ्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","चमैंइ ङने, ‘ङि मिश्रउँइँले तेइ पखबै मोशालाइ तो तगे ङिइ आसे। छतसि ङिए ओंसों-ओंसों घ्याँ तेंबै ल्हागिर देवता बनेमिन्’ बिसि बिइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","छबिमा ङइ चमैंने ‘माराए घानामैं खिब्मैंइ घानामैं प्लिसि ङ ङाँर पखो,’ बिइ, झाइले चमैंइ घानामैं ङने पिंइ। धै ङइ च घानामैं मिर झोंवामा क्ल्या भारा तयाइ!” ");
INSERT INTO gvr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","हारूनइ म्हिमैंलाइ तो लदा ङ्हाँम् लल् पिंबइले म्हिमैंइ ह्रोंसए सैंर तो मैंमुँ चन् लसि शत्तुरमैं निस्युबै के तल् पिंना बिसि मोशाइ था सेइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","छतसि मोशा ब्यारेकए म्रा ङाँर रासि, “याहवेहलाइ म्हाँदिब्मैं ङ ङाँइ खो!” बिमा ताँन् लेबीमैं च ङाँर खागु तखइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","धै मोशाइ लेबीमैंने बिइ, “‘क्हेमैं ताँनइ ह्रों-ह्रोंसए सेलाँ किंसि ब्यारेकर्बै चु म्राउँइँले अर्को म्रा समा ह्‍यासि ह्रोंसए अलिमैं, थुमैं नेरो ङ्‍हेब् ट्हुब्मैं सैद्!’ बिसि इस्राएलर्बै याहवेह परमेश्‍वरजी ल्हैदिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","मोशाइ बिब् धोंलेन् लेबीमैं लइ, च त्हिंइर हजार सों म्हिमैं सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","झाइले मोशाइ लेबीमैंने बिइ, “तिंयाँ क्हेमैंइ ह्रों-ह्रोंसए च्ह नेरो अलिमैं सैसि याहवेहए ल्हागिर स्यो लइमुँ। छतसि याहवेहजी क्हेमैंए फिर आशिक पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","प्हँन्हाँग्धों मोशाइ म्हिमैंने बिइ, “क्हेमैंइ थेबै पाप लइमुँ। क्हेमैंइ लबै पापए क्षमा ह्रिबर तारे ङ याहवेह ङाँर ह्‍यामुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","च लिउँइँ मोशा याहवेह ङाँर ह्‍यासि बिइ, “चु म्हिमैंइ थेबै पाप लइमुँ! चमैंइ माराए कु बनेसि फ्योइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","दिलेया चमैंए पाप क्हिइ क्षमा लमिंन्। क्षमा आलमिंस्याँ क्हिजी ह्रोंसए म्हिमैंए मिं प्ह्रिबै कितबउँइँले ङए मिं मेटिमिन्।” ");
INSERT INTO gvr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","याहवेहजी मोशाने बिइ, “ङए बिरोधर पाप लबै म्हिलाइन ह्रोंसए कितबउँइँले ङ मेटिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","तारे ह्‍याद्! ङइ बिबै क्ल्ह्‍योर म्हिमैंलाइ घ्याँ तेंसि बोद्। ङए दूतमैं क्हिए ओंसों-ओंसों ह्‍याब्मुँ। दिलेया चमैंलाइ सजैं पिंबै त्हे खबै लिउँइँ चमैंए पापए दण्ड ङ पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","झाइले हारूनइ बनेबै माराए क्ल्या भारा चमैंइ फ्योबइले याहवेहजी रूढि कुलसि म्हिमैं सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","याहवेहजी मोशाने बिइ, “क्हिए सन्तानलाइ पिंम् बिसि ङइ अब्राहाम, इसहाक नेरो याकूबने बाछा फैबै क्ल्ह्‍योर मिश्रउँइँले फखबै म्हिमैंने ह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","क्हेमैंए ओंसों-ओंसों दूत घ्रि कुल्मिंब्मुँ, धै कनानी, एमोरी, हित्ती, परिज्जी, हिव्वी नेरो यबूसीमैंलाइ ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","दिलेया क्हेमैं आच्योब्मैं ग, धै ङ क्हेमैंने ह्‍यास्याँ ङइ क्हेमैंलाइ सैवालै। छतसि ङ क्हेमैंने बालु ह्‍यारिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","चु ताँ थेसि म्हिमैंइ न्हुँ लसि खाबज्यै या घानामैं आखि। ");
INSERT INTO gvr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","तलेबिस्याँ “‘क्हेमैं आच्योमैं ग। ङ तिस्याँदे क्हेमैंने ह्‍यास्याँ ङइ क्हेमैंलाइ सैवालै। छतसि तोगो क्हेमैंइ ह्रोंसए घानामैं प्लिद्, धै क्हेमैंलाइ तो लल् त्हुमुँ ङ बिचार लस्यो,’ बिसि इस्राएलीमैंने बिद् बिसि याहवेहजी मोशाने बिल।” ");
INSERT INTO gvr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","छतसि इस्राएलीमैंइ सिनै कों वाथेंसि घानामैं आखिमल। ");
INSERT INTO gvr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","म्हिमैं टिबै ब्यारेकउँइँले ल्हें ह्रेंगो मोशाइ तम्बु घ्रि टौंदिमल। च तम्बुलाइ मोशाइ याहवेहने त्होबै तम्बु बिमल, धै याहवेहने त्होदा ङ्हाँब्मैं च तम्बुर ह्‍यामल। ");
INSERT INTO gvr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","मोशा च तम्बुर ह्‍यामा ताँन् म्हिमैं ह्रोंसए तम्बुए म्रार रासि मोशा याहवेहने त्होबै तम्बु न्होंर आहोंन् समा च ङाँइन ङ्‍ह्‍योरिमल। ");
INSERT INTO gvr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","मोशा न्होंर होंमा न्हाँम्स्योए त्हो रासि च तम्बुए म्रार रामल। झाइले न्हाँम्स्योए म्हाँजोउँइँले याहवेहजी मोशाने ताँ सेमल। ");
INSERT INTO gvr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","म्हिमैंइ न्हाँम्स्योए त्हो तम्बुए म्रार राब् म्रोंमा चमैं रेसि ह्रों-ह्रोंसए तम्बुर्बै म्रार कुरसि फ्योमल। ");
INSERT INTO gvr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","म्हिमैं ह्रोंसए थुमैंने ताँ सेब् धोंले याहवेह या मोशाने बालु सुँ-सुँ ह्‍वेंसि ताँ सेमल। झाइले मोशा ब्यारेकर एखमा चलाइ ल्होबै फ्रेंसि नुनए च्ह यहोशू च तम्बुर टिमल। ");
INSERT INTO gvr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","झाइले मोशाइ याहवेहने बिइ, “क्हिजी ङने ‘चु म्हिमैं बोसि ह्‍याद्,’ बिमुँ, दिलेया ङने बालु खा-खाब् कुलम् बिसि क्हिजी ङने आबिइमुँ। ‘ङइ क्हिलाइ क्हिए मिंइ सेम्: धै क्हिए फिर ङए म्हाँया मुँ,’ बिसि क्हिजी बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","क्हिए म्हाँया ङए फिर मुँ बिस्याँ, ङइ क्हिलाइ ङो सेल् खाँरिगे धै क्हिए उँइँर छ्याँबै केमैं लसि क्हिलाइ सैं तोंन् लल् खाँरिगे बिसि ङलाइ क्हिए घ्याँ उँइँमिंन्। चु ह्रें (जात) क्हिलन् ग बिसि मैंमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","छबिमा याहवेहजी बिइ, “ङ क्हिने बालुन् ह्‍याब्मुँ, धै क्हिलाइ भों न्हल् पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","मोशाइ याहवेहने बिइ, “क्हि ङिने बालुन् आह्‍यास्याँ ङिलाइ चु क्ल्ह्‍योउँइँले क्याइ आबोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","क्हि ङिने बालु आह्‍यास्याँ क्हिए म्हिमैं नेरो ङइ क्हिए म्हाँया योंइमुँ बिसि अरू ह्रेंमैंइ खैले सेब? ङ नेरो क्हिए म्हिमैं पृथ्‍बीर्बै ताँन् म्हिमैंने स्योन् उँइँबर क्हि ङिने बालुन् तल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","याहवेहजी मोशाने बिइ, “क्हिइ बिब् धोंले ङ लब्मुँ, तलेबिस्याँ ङए म्हाँया क्हिने मुँ, धै ङइ क्हिलाइ क्हिए मिंइ सेइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","मोशाइ यो छ्युँ लसि बिइ, “क्हिए चारबै ह्‍वे उँइँमिन्।” ");
INSERT INTO gvr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","याहवेहजी बिइ, “ङ क्हिए उँइँर्न ङए औदिबै छ्याँबै केमैं उँइँमिंसि ‘याहवेहए’ मिं ओरसि पोंब्मुँ। खाबलाइ ङ दयाम्हाँया लदा ङ्हाँमुँ चलाइ ङ दयाम्हँया लमुँ, खाबलाइ ल्हयो खदा ङ्हाँमुँ चलाइ ङ ल्हयो खमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","दिलेया क्हिइ ङए लि म्रोंल् खाँरिब् आरे, तलेबिस्याँ ङए लि ङ्ह्‍योस्याँ म्हिमैं सोल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","दिलेया ङए रेर पारा घ्रि मुँ। चर्न क्हि राद्। ");
INSERT INTO gvr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","ङए चाराबै ह्‍वे छाइले ह्‍यामा ङइ क्हिलाइ च पाराए पोर थेंब्मुँ, धै छाइले ङ आखन् समा ङए योइ क्हिलाइ हुथेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","च लिउँइँ ङए यो स्योवामा ङए क्हो क्हिइ म्रोंब्मुँ, लि बिस्याँ म्रोंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","याहवेहजी मोशाने बिइ, “ओंसोंबै धोंलेन् युँमाए प्लना ङ्हिं थोसि पखो। क्हिइ ओंसों तिवाबै युँमाए प्लनार प्ह्रिबै ताँमैं च युँमाए प्लनार ङइ प्ह्रिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","प्हन्हाँग न्हाँकर्न छेसि सिनै कोंर ङने त्होबर खो। ");
INSERT INTO gvr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","क्हिने खाबै या आखरिगे, कोंर खनिरै या म्हिमैं आम्रोंरिगे। र-क्यु नेरो खेदोमैं या चर आरेंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","छतसि मोशाइ धबै युँमाए प्लना ङ्हिं थोसि याहवेहजी बिब् धोंलेन् न्हाँकर्न युँमाए प्लना किंसि सिनै कोंर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","झाइले याहवेह न्हाँम्स्यो न्होंउँइँले तयुइ, धै मोशाने बालु रासि ह्रोंसए मिं “याहवेह” बिसि ओरइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","च लिउँइँ याहवेह चए ओंसोंउँइँले ह्‍यासि छ बिसि ओरइ, “याहवेह, याहवेह! ङ म्हिमैंए फिर बेल्‍ले म्हाँया नेरो ल्हयो खबै पइरमेश्‍वर ग! ङ युनन् ह्रिस आख, थेबै म्हाँया लमुँ, भर पर्दिल् खाँब् मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ङइ हजार-हजार पुस्ताए फिर आशिक पिंमुँ, धै दुष्‍ट केमैं, प्होंगि कैगि लब नेरो पापए क्षमा लमिंम्। दिलेया दोषिलाइ खैले बिलेना सजैं पिंमुँ। आबा-आमाइ लबै पापए दण्ड चमैंए च्ह-च्हमिमैं, क्वें-क्वेंमिमैं पुस्ता सों प्लि समा पिंमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","छ बिबै तोंदोंन् मोशाइ सर क्र कुरसि परमेश्‍वरलाइ फ्योइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","धै मोशाइ बिइ, “ओ याहवेह, क्हिए म्हाँया ङने मुँ बिस्याँ ङ यो छ्युँ लमुँ, क्हिन् ङिने बालु प्रमिंन्। चु म्हिमैं आच्योब्मैं मुँलेया ङिए दुष्‍ट केमैं नेरो पापए क्षमा लमिंसि ङिलाइ क्हिए म्हिमैं लमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","याहवेहजी मोशाने बिइ, “थेद्, ङ इस्राएलीमैंने बालु बाछा घ्रि फैम्। क्हिए म्हिमैंए ओंसों ङ औदिबै केमैं लब्मुँ। छाबै के पृथ्‍बीर्बै खाब् ह्रेंमैंए ङाँर आलइमुँ। ङ याहवेहजी क्हिए ल्हागिर छाबै औदिबै के लमना बिसि क्हिने बालु मुँबै म्हिमैंइ म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ङइ क्हिने बिबै ताँ म्हाँदिद्। ङइ क्हिए उँइँर्न एमोरी, कनानी, हित्ती, परिज्जी, हिव्वी नेरो यबूसीमैं ल्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","छतसि न्ह क्रों मि क्रोंले टिद्! क्हि ह्‍याबै ह्‍युलर्बै म्हिमैंने बालु बाछा आफैद्। बाछा फैस्याँ क्हेमैंए ल्हागिर ङो चुब् धोंन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","बरु चमैंए ख्रो पिंबै क्ल्ह्‍योमैं फुवाद्, चमैंए पबित्र युँमामैं त्हुला भुँ लवाद्, धै चमैंए अशेरा देबीए कुमैं (मूर्तिहरु) फुमिंन्! ");
INSERT INTO gvr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","क्हेमैंइ अरू देवतामैंए पूजा आलद्, तलेबिस्याँ ङ याहवेह ह्रिस लबै परमेश्‍वर ग। ");
INSERT INTO gvr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“न्ह क्रों मि क्रों तद्! च ह्‍युलर्बै म्हिमैंने बालु बाछा आफैद्, तलेबिस्याँ चमैं ह्रोंसए देवतामैंए पूजा लसि ख्रो पिंमा चमैंइ क्हेमैंलाज्यै या हुइब्मुँ, धै चमैंइ ख्रो पिंबै से क्हेमैंइ चब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","क्हेमैंए च्हमैंइ चमैंए च्हमिमैं ब्ह्‍या लसि पखलै, धै च च्हमिमैंइ ह्रोंसए देवतामैं पूजा लसि क्हेमैंए च्हमैंलाज्यै या पूजा लबर ल्हैदिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“क्हेमैंइ ह्रोंसए ल्हागिर तो सैलैया कु (मूर्ति) बनेसि आफ्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“प्लेढा आझोंब क्हें चबै चाड म्हाँदिद्। ङइ बिब् धोंले आबीब म्हैंनर ङिगैं समा प्लेढा आझोंब क्हें चद्, तलेबिस्याँ च म्हैंनर क्हेमैं मिश्र ह्‍युलउँइँले त्होंइ खब् ग। ");
INSERT INTO gvr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“च्ह थेब्मैं नेरो क्हेमैंए खेदोमैंइ ओंसों फिबै त्होबामैं, भालेमैं ङलन् ग। ");
INSERT INTO gvr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","दिलेया गदाइ ओंसों फिबै प्हसेए साटोर क्यु झजा पिंसि स्यो लद्। चलाइ स्यो आलस्याँ चए खरि चुवाद्। ह्रोंसए च्ह थेब्मैंलायै या तो मुँले सै पिंसि स्यो लद। “खाबै या भेटि आपल्‍ले ङ ङाँर खल् आत। ");
INSERT INTO gvr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“टुगैं समा ह्रोंसए के ति लद्, ङिगैंर बिस्याँ भों न्हद्। क्ल्या क्योब नेरो रो खुबै त्हेरै या ङिगैंर भों न्हद्। ");
INSERT INTO gvr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“ओंसों मिंबै गउँ खैंमा क्हेमैंइ नोगि चबै चाड म्हाँदिद्। छलेन सर्खर रा-रोमैं खुमा प्ह्रोर टिबै चाड म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“क्हेमैंए ताँन् मुँयुँमैं बर्षर सोंखे इस्राएलर्बै याहवेह परमेश्‍वरए उँइँर खल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","ङइ ह्रें-ह्रेंमैं क्हेमैं ङाँइँले ह्रेंगो ल्हामिंसि क्हेमैंए साँदमैं बडिमिंब्मुँ। क्हेमैं बर्षर सोंखे ह्रोंसए याहवेह परमेश्‍वरए उँइँर चाड म्हाँदिबर ह्‍याइ बिस्याँ खाबज्यै या क्हेमैंए क्ल्ह्‍यो लोब लरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ङए मिंर ख्रो पिंमा प्लेढा झोंसि ख्रोंबै क्हें आचडेद्। दुःखने फ्रेबै चाडर ख्रो पिंबै सैमैं प्हँन्हाँग्धों समा आथेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“क्हेमैंए म्रोंर्बै धाँसे ओंसों रोबै छ्याँबै रा-रोमैं ह्रोंसए याहवेह परमेश्‍वरए धिंर पखो। “र बोक्याए से चए आमाए ङ्‍हेर आह्‍योद्।” ");
INSERT INTO gvr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","याहवेहजी मोशाने बिइ, “चु ताँमैं प्ह्रिद्, तलेबिस्याँ चु ताँ धोंलेन् क्हि नेरो इस्राएलीमैंने ङइ बाछा फैइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","मोशा सिनै कोंर याहवेहने बालु प्लिच्यु त्हिंइ प्लिच्यु म्हुँइँस तोइ आचल्‍ले तोइ आथुँल्‍ले टिसि युँमाए प्लनामैंर बाछा फैबै ताँमैं, अथवा म्हिमैंइ ललन् त्हुबै “च्युउलो ताँमैं” प्ह्रिइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","म्हिमैंइ ललन् त्हुबै ताँमैं प्ह्रिबै युँमाए प्लना ङ्हिं योर किंसि कोंउँइँले तयुमा परमेश्‍वर चने बालु ताँ सेरिबइले ह्रोंसए लि चाररिइमुँ बिबै ताँ मोशाइ था आसेल। ");
INSERT INTO gvr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","हारून नेरो इस्राएलीमैंइ मोशालाइ ङ्‍ह्‍योमा चए लि चारब म्रोंइ। छतमा चमैं मोशाए ङाँर ह्‍याबर ङ्हिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","दिलेया मोशाइ चमैंलाइ हुइमा हारून नेरो इस्राएलर्बै ताँन् चिबनाँब्मैं मोशाए ङाँर खइ, झाइले मोशाइ चमैंने ताँ सेइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","च लिउँइँ इस्राएलर्बै ताँन् म्हिमैं चए ङाँर खइ, धै सिनै कोंर याहवेहजी मोशाने बिबै ताँन् ताँ मोशाइ चमैंने “ललन् त्हुबै ताँ चुन् ग” बिसि बिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","मोशाइ चमैंने ताँ सेल् खाँबै लिउँइँ ह्रोंसए लि क्वेंइ हुइ। ");
INSERT INTO gvr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","मोशा याहवेहए उँइँर पबित्र तम्बु न्होंर खीने ताँ सेबर ह्‍यामा नेरो बैरु आत्होंन् समा क्वेंइ लि आउमल। झाइले याहवेहजी ललन् त्हुम् बिसि बिबै ताँ मोशा बैरु युसि इस्राएलीमैंने बिमिंमा ");
INSERT INTO gvr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","इस्राएलीमैंइ मोशाए लि चाररिब म्रोंमल। याहवेहने बालु ताँ सेबर पबित्र तम्बु न्होंर आहोंन् समा मोशाइ धबै क्वेंइ लि हुमल। ");
INSERT INTO gvr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","मोशाइ इस्राएलर्बै ताँन् ह्रेंमैं खागु लसि बिइ, “क्हेमैंइ ललन् त्हुम् बिसि याहवेहजी पिंबै ताँ चुन् ग: ");
INSERT INTO gvr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","क्हेमैंइ टुगैं समा के लद्, दिलेया ङिगैं क्हेमैंए ल्हागिर पबित्र ग। चु याहवेहए मिंर भों न्हबै त्हिंइ ग। खाबज्यै या च त्हिंइर के लइ बिस्याँ च म्हि सैवाल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","प्रिबै त्हिंइर क्हेमैंए धिंर मि या आफुइद्।” ");
INSERT INTO gvr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","मोशाइ इस्राएलर्बै ताँन् म्हिमैंने बिइ, “ललन् त्हुम् बिसि याहवेहजी बिबै ताँ चुन् ग: ");
INSERT INTO gvr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","क्हेमैंइ याहवेहए मिंर भेटि पखो। भेटि पिंदा ङ्हाँब्मैंइ छाबै सैमैं पिंरिगे: मारा, चाँदि, काँसा; ");
INSERT INTO gvr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","मु रङर्बै क्वें, कलेजी रङर्बै क्वें, ओल्ग्या रु, नेरो छेनाले ख्रिंबै सुतिए क्वें; रए मुइ; ");
INSERT INTO gvr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ओल्ग्या रङ झोंबै क्यु साँडए ट्हुबि, सिल ताँगए ट्हुबि; बबुल सिं; ");
INSERT INTO gvr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","बत्ति म्रोबै ल्हागिर छ्युगु; अभिषेक लबै छ्युगु नेरो लिंबै थाँ खबै धुप बनेबै मसलामैं; ");
INSERT INTO gvr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","एपोद नेरो तिंर खिबै क्वेंर जोड्दिबै आनिक्स नेरो अरू सै ल्हें फेबै रत्नमैं। ");
INSERT INTO gvr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“क्हेमैंए न्होंरि सिप मुँबै म्हिमैं ताँन् खसि याहवेहजी लबर ल्हैदिबै सैमैं बनेद्: ");
INSERT INTO gvr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","पबित्र तम्बु, तम्बु स्युबै पाल, पाल टौंदिमा चैदिबै छत, अँङ्‍कुसिमैं फैलोमैं, बार थोबै सैमैं, त्होमैं, क्योबै क्ल्ह्‍योमैं; ");
INSERT INTO gvr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","बाछा फैबै बकस, बकसर नोबै प्हरेमैं, बकसए क्हा नेरो पर्दा; ");
INSERT INTO gvr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","टेबल, टेबलर नोबै प्हरेमैं, टेबल बनेमा चैदिबै सैंमैं, परमेश्‍वर मिंर चडेबै क्हें; ");
INSERT INTO gvr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","बत्ति म्रोंबै पानस, दारमैं, नेरो बत्ति म्रोबै छ्युगु; ");
INSERT INTO gvr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","धुप म्रोबै क्ल्ह्‍यो, च क्ल्ह्‍यो नोबै प्हरेमैं, अभिषेक लबै छ्युगु, लिंबै थाँ खबै धुप; पबित्र तम्बुए म्रार्बै पर्दा; ");
INSERT INTO gvr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","मिइ ख्रोंबै ख्रो पिंबै क्ल्ह्‍यो, चए फिर तिबै काँसाए जालि, च नोबै प्हरेमैं, चैदिबै ताँन् सैमैं; प्हले ख्रुबै ल्हागिर क्यु झोंबै काँसाए बाटा, बाटाए प्हलेमैं; ");
INSERT INTO gvr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","पबित्र तम्बु कारग्युले थोबै पर्दामैं, च टौंदिबै त्होमैं, क्योबै क्ल्ह्‍योमैं, कारग्युले थोबै म्रार्बै पर्दा; ");
INSERT INTO gvr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","पबित्र तम्बु, कारग्युले थोबै काँटिमैं, छोमैं; ");
INSERT INTO gvr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","पबित्र क्ल्ह्‍योर सेवा लमा खेगिमैंइ खिबै क्वेंमैं, हारूनइ खेगि के लमा खिबै पबित्र क्वेंमैं नेरो हारूनए च्हमैंइ खेगि के लमा खिबै क्वेंमैं।” ");
INSERT INTO gvr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","च लिउँइँ इस्राएलर्बै ताँन् म्हिमैं मोशा ङाँइँले ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","सैं प्ल्हसि पिंदा ङ्हाँब्मैंइ पबित्र तम्बु बनेबै ल्हागिर चैदिबै सैमैं नेरो खेगिमैंइ खिबै क्वें टुबै ल्हागिर याहवेहए मिंर भेटिमैं पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","सैं प्ल्हसि पिंदा ङ्हाँबै मुँयुँमैं नेरो च्हमिरिमैइ ल्हें खालर्बै माराए घानामैं, पिन, न्हखुमैं, च्यामैं, सिक्रिमैं सजेबै सैमैं पसि याहवेह मिंर थेंमिइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","खाब्ने बालु मु रङ, कलेजी रङ, ओल्ग्या रङइ रोबै रु, नेरो छेनाले ख्रिंबै सुति क्वें, रए पै, ओल्ग्या रङर्बै क्यु साँडए ट्हुबिमैं नेरो सिल ताँगए ट्हुबिमैं मुँल, च सैमैं पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","चाँदि नेरो काँसाए भेटि पिंब्मैंइ याहवेहए मिंर पखइ। सेवार चैदिबै बबुल सिं मुँब्मैंइ चन् पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","च्हमिरिमैंइ ह्रों-ह्रोंसइ पेरबै मु रङर्बै रु, कलेजी रङर्बै रु, ओल्ग्या रङर्बै रु नेरो छेनाले ख्रिंबै सुतिए क्वें पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","पै पेरल् ह्रबै च्हमिरिमैंइ रए मुइ पेरइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","चिबनाँबमैंइ एपोद नेरो तिंर खिबै क्वेंर जोड्दिबै आनिक्स नेरो अरू मणिमैं पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","बत्ति म्रोबै छ्युगु, अभिषेक लबै छ्युगु, छ्याँबै थाँ खबै छ्युगु, नेरो लिंबै थाँ खबै धुप बनेबै ल्हागिर मसला या पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","याहवेहजी मोशाने लबर ल्हैदिबै केमैंए ल्हागिर पिंदा ङ्हाँबै इस्राएलर्बै ताँन् मुँयुँमैं नेरो च्हमिरिमैंइ सैं तोंदै भेटि पखइ। ");
INSERT INTO gvr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","मोशाइ इस्राएलीमैंने बिइ, “थेद्, याहवेहजी यहूदा कुलर्बै हुरए क्वें ऊरीए च्ह बजलेललाइ त्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","खीजी चलाइ परमेश्‍वरए प्ल्हजी प्लिंमिंइमुँ, धै सिप, ज्ञान बुद्धि, नेरो तोन्दोंरि लल् ह्रब लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","मारा, चाँदि नेरो काँसार बुट्टा झोंब, ");
INSERT INTO gvr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","हिरा थोब नेरो जोड्दिब, सिंर बुट्टा झोंब धै ताँन् खालर्बै केमैं लल् ह्रबै सिप खीजी चलाइ पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","च नेरो दानए कुलर्बै अहीसामाकए च्ह ओहोलीआबइ अरूमैंलाइ लोमिंरिगे बिसि याहवेहजी चमैंलाइ तोन्दोंरि लल् ह्रबै सिप पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","चमैंइ ताँन् खालर्बै भाँडार बुट्टा झोंब, मु रङर्बै क्वें, कलेजी रङर्बै क्वें, ओल्ग्या रङर्बै क्वें नेरो छेनाले ख्रिंबै सुतिए क्वें रोसि बुट्टा झोंबै केमैं छेनाले लल् खाँरिगे बिसि खीजी चमैंलाइ सिपमैं पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“छतसि बजलेल, ओहोलीआब नेरो ल्हें खालर्बै सिप मुँबै म्हिमैंइ याहवेहजी लद् बिब् धोंबै के लरिगे बिसि खीजी चमैंलाइ पबित्र तम्बु बनेबर ज्ञान नेरो सिप पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","छतसि बजलेल, ओहोलीआब नेरो याहवेहजी ज्ञान नेरो सिपमैं पिंबै ताँन् म्हिमैं मोशाइ हुइसि के लद् बिसि ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","इस्राएलीमैंइ पबित्र तम्बु बनेबै ल्हागिर पखबै ताँन् भेटिमैं मोशाए योउँइँले चमैंइ किंइ। दिलेया इस्राएलर्बै म्हिमैंइ न्हाँगै ह्रोंसे मोशा ङाँर भेटिमैं पखमल। ");
INSERT INTO gvr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","छतसि पबित्र तम्बु छेनाले बनेल् ह्रब्मैं ह्रों-ह्रोंसए केमैं पिसि मोशा ङाँर ह्‍यासि बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“याहवेहजी बनेबर ल्हैदिबै केए ल्हागिर चैदिब् भन्दा ल्हें सैमैं म्हिमैंइ परिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","छतमा पबित्र तम्बु बनेबर तारे खाबज्यै या तो सैया आपखो बिसि मोशाइ ताँन् ब्यारेकजरे बिइ। छबिमा म्हिमैंइ भेटि पखब पिवाइ, ");
INSERT INTO gvr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","तलेबिस्याँ तम्बु बनेबर चमैंने बालु चैदिब सैमैं भन्दा ल्हें मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","के लब्मैं न्होंर्बै छेनाले बनेल् ह्रब्मैंइ पर्दा च्युउलो मुँबै तम्बु बेनेइ। च पर्दामैं मु रङ, कलेजी रङ नेरो ओल्ग्या रङइ रोबै क्वें नेरो छेनाले ख्रिंबै सुति क्वेंला बुट्टा पिंल् ह्रब्मैंइ बनेबै करूबमैं पर्दार मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","च पर्दामैं ताँन् नाप घ्रिर्बैन् ङ्‍ह्‍युस्युसे प्रे क्रु ह्रिंब नेरो प्लिउरु प्ल्हाब मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","पर्दामैं ङ्‍हउलो-ङ्‍हउलो जोड्दिसि थे-थेबै पर्दामैं ङ्हिं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","च थे-थेबै पर्दाए बैरुउँबै ङाँर चमैंइ मु रङर्बै क्वेंए सुर्कानि झोंबै क्ल्ह्‍यो बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","पर्दा ङ्हिंर्न चमैंइ ङ्‍हच्यु-ङ्‍हच्यु सुर्कानि बनेइ। च सुर्कानिमैं तिरैना ह्‍वेंब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","चमैंइ माराए अङ्‍कुसिमैं बनेसि च पर्दामैं जोड्दिइ। छले पबित्र तम्बु क्ल्ह्‍यो घ्रिर्न तइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","पबित्र तम्बु हुबै ल्हागिर चमैंइ रए मुइ रोबै क्वेंला च्युसे घ्रि पर्दामैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","च पर्दामैं नाप घ्रिर्बैन् सोंच्यु क्रु ह्रिब नेरो प्लिउरु प्ल्हाब मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","चमैंइ पर्दा ङ्‍हउलो जोड्दिसि थेबै पर्दा घ्रि बनेइ। छलेन पर्दा टुउलो जोड्दिसि अर्को पर्दा बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","थेबै पर्दामैं जोड्दिबै ङाँ-ङाँर चमैंइ ङ्‍हच्यु-ङ्‍हच्यु सुर्कानि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","च पर्दामैं जोड्दिबै ल्हागिर चमैंइ काँसाए ङ्‍हच्यु अङ्‍कुसिमैं बनेसि प्ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","तम्बु हुबै ल्हागिर चमैंइ ओल्ग्‍या रङर्बै क्यु साँडए ट्हुबिए पर्दा नेरो सिल ताँगए ट्हुबिए पर्दामैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","चमैंइ पबित्र तम्बुए ल्हागिर बबुल सिंए फ्ल्याकमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","फालेमैं ताँन् च्युउरु ह्रिंब नेरो तिउरुसे आधा प्ल्हाब मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ताँन् फालेर जोड्दिबै चोसामैं ङ्हिं उँइ-उँइँ ह्‍वेंसि थेंल। चु धोंलेन् पबित्र तम्बु बनेबै फ्ल्याकमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","चमैंइ छ्यो ल्हुए (दक्षिण) ल्हागिर ङ्‍ह्‍युस्यु फ्ल्याकमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","झाइले ङ्‍ह्‍युस्यु फालेमैंए न्होंर प्लिच्यु चाँदिए क्योबै क्ल्ह्‍योमैं बनेइ। फ्ल्याक घ्रिए न्होंर क्योबै क्ल्ह्‍यो ङ्हिं चोसामैं न्होंर क्योबै क्ल्ह्‍यो घ्रि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","पबित्र तम्बुए ताइ हार (उत्तर) चमैंइ ङ्‍ह्‍युस्यु फ्ल्याकमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","झाइले ताँन् फ्ल्याकए न्होंर ङ्हिं-ङ्हिं लसि चाँदिए प्लिच्यु क्योबै क्ल्ह्‍योमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","पबित्र तम्बुए छ्यो न्हुँ हारए ल्हागिर (पश्‍चिम हार) चमैंइ फालेमैं टुउलो बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","पबित्र तम्बुए कुना-कुनाए ल्हागिर फ्ल्याकमैं ङ्हिं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","च कुनार्बै फ्ल्याकमैं ताइले माइ समा ङ्हिपो ङ्हिपो झोंसि रिंङ घ्रिर्न जोड्दिल। कुना ङ्हिंर्बै फ्ल्याकमैं या चमैंइ छलेन् बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","च फ्ल्याकमैं प्रेउलोए ल्हागिर चाँदिए च्युसे टुउलो क्योबै क्ल्ह्‍यो बनेसि फालेमैंए न्होंर थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","पबित्र तम्बुर्बै तिरैबै फालेमैं थोबै ल्हागिर बबुल सिंए बारमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","छलेन अर्को फालेमैं थोबै ल्हागिर ङ्‍हउलो बारमैं बनेइ, धै छ्यो न्हुँर्बै (पश्‍चिम) कुनार मुँबै फ्ल्याकमैं थोबर ङ्‍हउलो बार बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","फालेमैंए म्हाँजोर्बै बार बिस्याँ छेउ घ्रिउँइँले अर्को छेउ समा फेनेल्‍ले बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","चमैंइ फ्ल्याकमैं माराइ म्होरइ, धै बारमैं क्हाबै ल्हागिर माराए न्हमैं बनेइ। बारमैं या माराइना म्होरइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","चमैंइ मु रङ, कलेजी रङ, नेरो ओल्गया रुइ रोबै क्वें नेरो छेनाले ख्रिंबै सुतिए क्वेंला पर्दा घ्रि बनेइ, चर बुट्टा झोंल् ह्रब्मैंइ करूबए बुट्टामैं झोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","पर्दा च्योबै ल्हागिर बबुल सिंए त्हो प्लिउलो बनेसि माराइ म्होरइ। अङ्‍कुसिमैं या माराल बनेइ। त्होमैं धाँदिबर चाँदिए क्योबै क्ल्ह्‍यो प्लिउलो बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","तम्बुए म्राए ल्हागिर चमैंइ मु रङ, कलेजी रङ नेरो ओल्ग्या रङर्बै रुइ रोबै क्वें नेरो छेनाले ख्रिंबै सुतिए क्वेंर बुट्टा झोंबै पर्दा बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","च पर्दा च्योबै ल्हागिर चमैंइ त्हो ङ्‍हउलो बनेसि त्होए च्हो नेरो छो माराइ म्होरइ, झाइले त्हो धाँदिबै ल्हागिर काँसाए ङ्‍हउलो क्योबै क्ल्ह्‍योमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","बजलेलइ बबुल सिंए मुदुस बनेइ। च ङ्हिउरुसे आधा ह्रिंब, तिउरुसे आधा प्ल्हाब नेरो तिउरुसे आधा नुब मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","चइ मुदुसए न्हों नेरो बैरु छ्याँबै माराइ म्होरसि कारग्युले माराइ ङाँ सैइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","चइ मुदुसर प्ह्‍याबै माराए प्लिउलो न्हमैं बनेसि मुदुसए प्हले प्लिर प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","छलेन चइ बबुल सिंए प्हरेमैं बनेसि माराइ म्होरइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","झाइले मुदुस नोबै ल्हागिर च प्हरेमैं मुदुसए न्हमैंर क्युलइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","चइ ङ्हिउरुसे आधा ह्रिंब नेरो तिउरुसे आधा प्ल्हाब छ्याँबै माराला बाछाए मुदुसए का घ्रि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","चइ मुदुसए क्योबै क्ल्ह्‍योर माराए करूब ङ्हिं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","करूब घ्रि छेउ घ्रिर, करूब घ्रि अर्को छेउर प्ह्‍यामिंइ। च करूब ङ्हिं नेरो मुदुसए क्योबै क्ल्ह्‍यो माराए डल्‍ला घ्रिउँइँलेन् बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","च करूबमैंइ ह्रों-ह्रोंसए प्ह्‍यामैं फैसि मुदुसए काए फिर छरि लल। चमैंए सुँ उँइँ उँइँ लसि मुदुसए काउँइँ ह्‍वेंल। ");
INSERT INTO gvr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","बजलेलइ ङ्हिउरु ह्रिंब तिउरु प्ल्हाब तिउरुसे आधा नुब बबुल सिंए टेबल बनेसि ");
INSERT INTO gvr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","छ्याँबै माराइ म्होरइ धै चए कारग्युले माराए ङाँ सैइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","टेबलए कारग्युले योरिं प्लि प्ल्हाबै घेरा बनेसि चए कारग्युले माराए ङाँ सैइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","टेबलर प्ह्‍याबै ल्हागिर चइ माराए न्ह प्लि बनेसि टेबलए प्हले प्लिए कुनार प्‍ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","टेबल नोबै प्हरेमैं क्युलबै ल्हागिर घेराए रेर्न च न्हमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","चइ टेबल नोबै ल्हागिर बबुल सिंए प्हरेमैं बनेसि माराइ म्होरइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","टेबलर थेंबै थलिमैं, धुपरा, प्हेलामैं, प्हा झोंसि चडेबै करुवामैं चइ ताँन् छ्याँबै माराल बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","चइ छ्याँब माराए बत्ति म्रोंबै पानस बनेइ। चए क्योबै क्ल्ह्‍यो, डाँठ, ट धोंबै प्हेला, कोपिला, नेरो टमैं माराए डल्‍ला घ्रिउँइँलेन् बनेल। ");
INSERT INTO gvr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","तिरै सोंउलो अर्को हार सोंउलो लसि टुउलो हाँगमैंबत्ति म्रोंबै पानसउँइँले बैरु त्होंल। ");
INSERT INTO gvr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","हाँग घ्रिर हाडे बदामए ट धों ब्योंबै प्हेला, नेरो कोपिला धै टमै मुँल। अर्को हाँगरै या प्हेला सोंउलो मुँल। पानसउँइँले त्होबै टुउलोन् हाँगमैं घ्रि खालर्बैन् मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","पानसर हाडे बदामए ट धों ब्योंबै प्हेला प्लि नेरो टमैं धै टै या मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","पानसउँइँले त्होंबै टुउलो हाँगमैं न्होंर ओंसोंबै हाँग न्होंर कोपिला घ्रि, अर्को हाँग न्होंर कोपिला धै अर्को हाँग न्होंरै या कोपिला मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","बत्ति म्रोंबै पानस, कोपिला नेरो हाँगमैं माराए डल्‍ला घ्रिउँइँलेन् बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","चइ पानसर थेंबै पलमैं, थनर (चिम्टा) नेरो पुज्या झोंबै भाँडो छ्याँबै माराला बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","चइ सोंच्युसे ङ्‍ह किलो छ्याँब माराइ बत्ति म्रोंबै पानस नेरो चर सजेबै सैमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","चइ धुप म्रोबै क्ल्ह्‍यो बबुल सिंला बनेइ। च ख्रो पिंबै क्ल्ह्‍यो तिउरु ह्रिंब, तिउरु प्ल्हाब, ङ्हिउरु नुब चार पाटे मुँल। ख्रो पिंबै क्ल्ह्‍योए रुमैं या ख्रो पिंबै क्ल्ह्‍यो बनेबै सिंलन् बनेल। ");
INSERT INTO gvr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","ख्रो पिंबै क्ल्ह्‍योए हार प्लिर्बै भाग नेरो रुमैं या छ्याँबै माराइ म्होरसि कारग्युले माराए ङाँ बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","ख्रो पिंबै क्ल्ह्‍यो नोबै प्हरेमैं क्युलबै ल्हागिर ख्रो पिंबै क्ल्ह्‍योए हार ङ्हिंर्न माराए न्हमैं ङ्हिं बनेसि ख्रो पिंबै क्ल्ह्‍योए हार ङ्हिंर्न प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","चइ बबुल सिंए प्हरेमैं बनेसि माराइ म्होरइ। ");
INSERT INTO gvr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","अभिषेक लबै पबित्र छ्युगु नेरो अत्तर बनेब्मैंइ धोंले लिंबै थाँ खबै धुप चइ बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","धै बजलेलइ ङ्‍हउरु ह्रिंब, ङ्‍हउरु प्ल्हाब, सोंउरु नुब चार पाटे मिइ ख्रोंसि ख्रो पिंबै बबुल सिंए क्ल्ह्‍यो बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","चए कुना प्लिर रुमैं बनेइ। च ख्रो पिंबै क्ल्ह्‍यो नेरो रुमैं सिं घ्रिउँइँलेन् बनेसि काँसाइ म्होरइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","चइ ख्रो पिंबै क्ल्ह्‍योर चैदिबै भाँडोमैं, बेल्चामैं, क्यु झोंबै बाटामैं, से तिबै काँटामैं, मि म्ल्हमैं झोंबै भाँडोमैं काँसाला बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ख्रो पिंबै क्ल्ह्‍योए फिर तिबै ल्हागिर चइ ख्रो पिंबै क्ल्ह्‍योए ङाँए न्होंर म्हाँजोर समा फेनेल्‍ले काँसए जालि घ्रि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","चइ काँसाए जालिए कुना प्लिर नोबै प्हरे क्युलबै ल्हागिर न्ह प्लिउलो बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","प्हरेमैं बबुल सिंल बेनेसि काँसाइ म्होरइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","च प्हरेमैं ख्रो पिंबै क्ल्ह्‍योए रे प्लिर प्ह्‍याबै न्हमैंर ख्रो पिंबै क्ल्ह्‍यो नोबै ल्हागिर क्युलइ। चइ बबुल सिंउँइँले न्होंर खोक्रो तबै ख्रो पिंबै क्ल्ह्‍यो बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","पबित्र तम्बुए म्रार के लबै च्हमिरिमैंइ ङ्‍ह्‍योबै दर्पनउँइँले (ऐना) चइ काँसाए क्यु झोंबै भाँडो नेरो च भाडोए प्हले बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","छेनाले ख्रिंबै सुति क्वेंए पर्दामैं बनेसि याहवेहए पबित्र तम्बु थोइ। पर्दाए माइ हारबै भाग (दक्षिण) प्र क्रुल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","च पर्दा च्योबै त्होमैं ङ्हिस्यु, चए क्योबै क्ल्ह्‍यो या ङ्हिस्युन् काँसाल मुँल। त्होए अङ्‍कुसिमैं नेरो छोमैं चाँदिल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","पर्दाए ताइ हारबै भाग या (उत्तर) प्र क्रुल मुँल। त्होमैं नेरो क्योबै क्ल्ह्‍योमैं या काँसालन् ङ्हिस्युन् मुँल। त्होमैंए अङ्‍कुसि नेरो छोमैं बिस्याँ चाँदिल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","छ्यो न्हुँ हारबै पर्दामैं ङ्‍हच्यु क्रुल मुँल। चए त्होमैं च्यु, क्योबै क्ल्ह्‍यो या च्युन् मुँल, त्होए अङ्‍कुसि नेरो छोमैं चाँदिल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","स्यार हारबै पर्दाए भाग (पूर्व) ङ्‍हच्यु क्रुल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","मुल म्रा हारबै पर्दामैं च्युसे ङ्‍ह क्रुल मुँल। चए त्होमैं नेरो क्योबै क्ल्ह्‍यो या सोंउलोन् मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ह्‍युर्बै म्राए क्योलो नेरो त्हेब्रे हारबै पर्दामैं च्युसे ङ्‍ह क्रुल मुँल। चए त्होमैं नेरो क्योबै क्ल्ह्‍यो या सोंउलोन् मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ह्‍युर्बै प्लि हारबै पर्दामैं छेनाले रोबै सुति क्वेंल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","त्होए क्योबै क्ल्ह्‍योमैं काँसाल मुँल, त्होर्बै अङ्‍कुसि नेरो छोमैं चाँदिल मुँल। त्होए च्होमैं चाँदिइ म्होरल। ह्‍युर्बै त्होमैंर च्योबै छोमैं या चाँदिलन् मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ह्‍युर्बै मुल म्रार्बै पर्दा मु रङ, कलेजी रङ नेरो ओल्ग्या रङर्बै रुइ टुसि बुट्टा झोंब मुँल। च पर्दा ङ्हिस्यु क्रु ह्रिंब नेरो ङ्‍हउरु नुब मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","च पर्दा च्योबै त्होमैं नेरो क्योबै क्ल्ह्‍योमैं प्लि काँसाल मुँल। अङ्‍कुसि नेरो छोमैं चाँदिल मुँल, त्होए च्होमैं या चाँदिइ म्होरल। ");
INSERT INTO gvr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","पबित्र तम्बु नेरो तम्बुए ह्‍युर्बै काँटिमैं काँसाल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","पबित्र तम्बु बनेबर ल्हैदिबै सैमैं छले मुँ। मोशाइ बिब् धोंले खेगि हारूनए च्ह ईतामारइ ल्हैदिब् अनुसार लेबीमैंइ प्ह्रिल। ");
INSERT INTO gvr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","याहवेहजी मोशाने बिब् धोंले यहूदाए कुलर्बै ऊरीए च्ह, हुरए क्वें बजलेलइ लइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","चने बालु दानए कुलर्बै अहीसामाकए च्ह ओहोलीआब मुँल। च भाडर बुट्टा प्रिंल् ह्रब् नेरो मु रङर्बै, कलेजी रङर्बै नेरो ओल्ग्या रङर्बै रुमैं नेरो छेनाले ख्रिंबै सुतिइ बुट्टा झोंल् ह्रब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","पबित्र तम्बु बनेसि याहवेहए मिं फुलबै ल्हागिर पखबै मारा पबित्र तम्बुर्बै पार अनुसार हाजार घ्रि किलो मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","इस्राएलर्बै म्हिमैं च्योबै त्हेर खुबै चाँदि पबित्र तम्बुर मुँबै पारर क्वेमा ३,४३० किलो मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ङ्हिस्यु बर्ष भन्दा कैंडुबै म्हिमैं च्योमा लाख टुसे हजार सोंसे ङ्‍हब्रसे ङ्हच्यु (६,०३,५५०) तल। च ताँन् म्हिमैंइ एखबै मुइ पबित्र तम्बुर्बै पारइ क्वेमा आधा शेकेल मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","३,४०० किलो चाँदि पबित्र तम्बु नेरो पर्दाए क्योबै क्ल्ह्‍योमैं बनेबै ल्हागिर मुँल। क्योबै क्ल्ह्‍यो घ्रि बनेमा ३४ किलो ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ङैब सोंच्यु किलो चाँदिउँइँले चमैंइ त्होए च्होमैंए ल्हागिर अङ्‍कुसि बनेसि त्होए च्होमैं म्होरसि छोमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","याहवेहए मिंर फुलबै काँसा २,४२५ किलो मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","च काँसाइ पबित्र तम्बुर्बै मुल म्राए क्योबै क्ल्ह्‍योमैं, ख्रो पिंबै क्ल्ह्‍यो, जालि नेरो ख्रो पिंबै क्ल्ह्‍योर्बै ताँन् सैमैं, ");
INSERT INTO gvr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ह्‍युर्बै क्योबै क्ल्ह्‍योमैं, मुल म्राए क्योबै क्ल्ह्‍योमैं, नेरो पबित्र तम्बुर चैदिबै काँटि नेरो ह्‍युए कारग्युले चैदिबै काँटिमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","पबित्र तम्बुर के लबै खेगिमैंए ल्हागिर चमैंइ मु रङ, कलेजी रङ, नेरो ओल्ग्या रङर्बै रुमैंइ रोबै क्वेंमैं टुइ। छलेन याहबेहजी मोशाने बिब् धोंलेन् चमैंइ हारूनइ खेगि के लमा खिबै क्वें या टुइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","मु रङ, कलेजी रङ, ओल्ग्या रङ नेरो छेनाले ख्रिंबै सुतिए क्वें छेनाले ख्रिंसि एपोदै या टुइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","चमैंइ माराए तारमैं बनेसि च तारइ मु रङ, कलेजी रङ, ओल्ग्या रङ नेरो छेनाले ख्रिंबै सुतिए क्वेंर बुट्टा झोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","एपोद प्हैदर छ्योरिगे बिसि चमैंइ एपोदए छेउ ङ्हिंर तनामैं प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","छलेन याहवेहजी मोशाने बिब् धोंलेन् चमैंइ मु रङ, कलेजी रङ, ओल्ग्या रङ, माराए तार नेरो छेनाले ख्रिंबै सुतिए क्वें ख्रिंसि एपोदए फिर खिबै छ्याँबै फगि रोइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","चमैंइ माराए स्युउनिर तुथु जोड्दिसि इस्राएलए च्युसे ङ्हिं च्हमैंए मिं तुथुर प्ह्रिइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","याहवेहजी मोशाने बिब् धोंलेन् इस्रालए च्युसे ङ्हिं च्हमैं मैंरिगे बिसि चमैंइ तुथु एपोदए प्हैंदर प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","एपोद टुब् धोंलेन् बुट्टामैं झोंल् ह्रबै म्हिइ के लब् धोंले चमैंइ मारा, मु रङ, कलेजी रङ, ओल्‍ग्‍या रङर्बै रु नेरो क्वें छेनाले ख्रिंसि तिंर खिबै क्वें बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","च तिंर खिबै क्वें बित्ता घ्रि ह्रिंब, बित्ता घ्रि प्ल्हाब ङ्हिथरले ताब चार पाटे मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","चर मणिमैं ल्हस्यार प्लि लसि मणिमै जोद्डिइ। तिस्यार मानिक, पुष्पराज नेरो बेरुज मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ङ्हिस्यारर फिरोजा, निर नेरो पन्‍ना मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","सोंस्यारर ओल्ग्या मणि, हाकिक नेरो कटेला मुँल। ");
INSERT INTO gvr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","प्लिस्यारर पितमणि, आनिक्स नेरो बिल्‍लौर मुँल। चु ताँन् मणिमैं माराइ जोड्दिल। ");
INSERT INTO gvr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","इस्राएलए खेमैं मैंबै ल्हागिर च च्युसे ङ्हिं तुथु घ्रि-घ्रिर याकूबए च्युसे ङ्हिं च्हमैंए मिं प्ह्रिथेंल। ");
INSERT INTO gvr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","तिंर खिबै क्वें बनेबै ल्हागिर चमैंइ छो धोंले ख्रिंबै छ्याँबै माराए सिक्रिमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","चमैंइ माराए न्ह ङ्हिं नेरो न्ह प्ह्‍यबै धिं ङ्हिं बनेसि तिंर खिबै क्वेंए कुना ङ्हिंर न्हमैं ङ्हिं प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","माराए सिक्रि ङ्हिं तिंर खिबै क्वेंए छेउ-छेउ ङ्हिंर मुँबै न्हमैं ङ्हिंर जोड्दिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","सिक्रि ङ्हिंए छेउ ङ्हिं रिङ प्ह्‍याबै धिंर जोड्दिसि एपोदए प्हैंदर्बै उँइँ हारबै तनिर प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","चमैंइ माराए रिङ ङ्हिं बनेसि तिंर खिबै क्वेंए अर्को कुना ङ्हिंर एपोदए न्हों हारबै ङाँर प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","चमैंइ अझै माराए रिङ ङ्हिं बनेसि एपोदए उँइँ हारबै प्हैंद ङ्हिंर्बै तनिर नेरो एपोदए फिर खिबै फगिए फिर्बै सिउनिर प्ह्‍यामिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","याहवेहजी मोशाने बिब् धोंलेन् एपोदए फिर फगि आसर्दिरिगे बिसि तिंर खिबै क्वेंए रिङमैं नेरो एपोदए रिङमैं मु रङर्बै फिताइ फगिर फैइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","झाइले एपोदए न्होंर खिबै लबेदामैं मु रङर्बै क्वेंइ टुइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","लबेदाए म्हाँजोर क्र क्ल्युलबै सुँ बनेसि चए कारग्युले आटोरिगे बिसि ङाँ सैमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","लबेदाए माइबै फरोर मु रङ, कलेजी रङ, ओल्ग्या रु नेरो छेनाले ख्रिंबै सुति क्वें ख्रिंसि अनारमैं बनेइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","छ्याँबै माराए स्योंमैं बनेसि च फेरोए कारग्युले अनारए म्हाँ-म्हाँजोर माराए स्योंमैं च्योमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","याहवेहजी मोशाने बिब् धोंलेन् सेवा लमा खिबै लबेदाए माइबै फेरोए कारग्युले माराए स्यों नेरो अनार च्योमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","हारून नेरो चए च्हमैंइ खिबै ल्हागिर सुति क्वेंए लबेदामैं, ");
INSERT INTO gvr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","क्रेगि, कुलेमैं नेरो न्होंर खिबै क्वें चमैंइ टुइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","याहवेहजी मोशाने बिब् धोंलेन् छेनाले ख्रिंबै सुति क्वें ख्रिंसि, मु रङ, कलेजी रङ, ओल्ग्या रुइ बुट्टा झोंबै फगि टुइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","चमैंइ छ्याँबै माराल पबित्र मुकुट बनेसि चर “याहवेह मिंर पिंब् ग” बिसि कोप्दिइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","याहवेहजी मोशाने बिब् धोंलेन् चमैंइ क्रेगिए ओंसों मु रङर्बै पित्ताइ फैइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","याहवेहजी मोशाने बिब् धोंलेन् पबित्र तम्बु बनेबै के ताँन् खाँइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","झाइले चमैंइ पबित्र तम्बु नेरो चर चैदिबै तोन्दोंरि सैमैं मोशा ङाँर पइ: अङ्‍कुसिमैं, फ्ल्याकमैं, बार थोबै सैंमैं, नेरो त्होमैं क्योबै क्ल्ह्‍योमैं, ");
INSERT INTO gvr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","तम्बु उबै ल्हागिर ओल्ग्या रङर्बै क्यु साँडए ट्हुबि, बाछाए मुदुस उँइँर थेंबै पर्दामैं, ");
INSERT INTO gvr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ठिम थेंबै मुदुस, मुदुसर क्युलबै प्हरेमैं, नेरो मुदुसए क्हा, ");
INSERT INTO gvr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","टेबल नेरो चए चैदिबै सैमैं, परमेश्‍वरए मिंर पिंबै क्हें, ");
INSERT INTO gvr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","छ्याँबै माराए पानस, पलमैं, बत्ति म्रोबै तेल, नेरो चैदिबै तोन्दोंरि सैमैं, ");
INSERT INTO gvr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","धुप म्रोबै ल्हागिर माराल ख्रो पिंबै क्ल्ह्‍यो, अभिषेक लबै छ्युगु नेरो छ्याँब थाँ खबै धुप, पबित्र तम्बुए म्रार्बै पर्दा, ");
INSERT INTO gvr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","काँसाए ख्रो पिंबै क्ल्ह्‍यो, काँसाए जालि, ख्रो पिंबै क्ल्ह्‍यो नोबै प्हरेमैं नेरो चर चैदिबै सैमैं, यो प्हले ख्रुबै ल्हागिर क्यु झोंबै बाटा नेरो बाटाए प्हलेमैं, ");
INSERT INTO gvr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ह्‍युर कारग्यु लबै पर्दा, त्होमैं नेरो चमैंए क्योबै क्ल्ह्‍योमैं, ह्‍युर्बै म्राए पर्दा, छोमैं नेरो काँटिमैं, पबित्र तम्बुर चैदिबै सैमैं, ");
INSERT INTO gvr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","पबित्र तम्बुर हारून खेगि नेरो चए च्हमैंइ खेगि के लमा खिबै पबित्र क्वेंमैं। ");
INSERT INTO gvr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","छलेन याहवेहजी मोशाने बिब् धोंलेन् इस्राइलिमैंइ ताँन् के लइ। ");
INSERT INTO gvr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","मोशाइ चमैंइ लबै ताँन् केमैं ङ्‍ह्‍योमा याहवेहजी बिब् धोंलेन् चमैंइ लइ बिब् म्रोंइ। छतसि मोशाइ चमैं ताँनए फिर आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","याहवेहजी मोशाने बिइ, ");
INSERT INTO gvr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ओंसोंबै म्हैंनर्बै ओंसोंबै त्हिंइर याहवेहए पबित्र तम्बु क्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ठिम थेंबै मुदुस चर थेंन्, धै चए ओंसों पर्दा च्योद्। ");
INSERT INTO gvr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","टेबलै या न्होंर थेंसि चए फिर सजेबै सैमैं थेंन्, धै पानस न्होंर पखसि चर पलमैं थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ठिम थेंबै मुदुसए ओंसों धुप म्रोबै ख्रो पिंबै क्ल्ह्‍यो थेंन्, झाइले पबित्र तम्बुए म्रार पर्दा झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","पबित्र तम्बुए म्रार्बै ओंसों मिर ख्रोंसि ख्रो पिंबै क्ल्ह्‍यो थेंन्। ");
INSERT INTO gvr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","च लिउँइँ पबित्र तम्बु नेरो मिइ ख्रोंबै ख्रोमैं पिंबै क्ल्ह्‍योए म्हाँजोर बाटा थेंसि क्यु झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ह्‍युर कारग्युले बार थोसि ह्‍युर्बै म्रार पर्दा झोंन्। ");
INSERT INTO gvr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“झाइले अभिषेक लबै छ्युगुइ पबित्र तम्बु नेरो चर मुँबै तोन्दोंरि सैर फोसि पबित्र तम्बु नेरो चर मुबै सैमैं चोखो लद्। छ लस्याँ च ताँन् पबित्र तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","छलेन मिर ख्रोंसि ख्रो पिंबै क्ल्ह्‍यो नेरो चर्बै तोन्दोंरि सैमैं या छ्युगु फोसि पबित्र लद्। छलमा च ताँन् पबित्र तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","झाइले क्यु झोंबै बाटा नेरो बाटाए प्हले या छ्युगु फोसि पबित्र लद्। ");
INSERT INTO gvr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“च लिउँइँ हारून नेरो चए च्हमैं पबित्र तम्बुए म्रार पखसि ख्रुबर ल्हैदिद्। ");
INSERT INTO gvr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","हारूनलाइ पबित्र क्वें खिमिंसि अभिषेक लद्, झाइले च खेगि तसि ङए सेवा लरिगे बिसि चलाइ पबित्र लद्। ");
INSERT INTO gvr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","हारूनए च्हमैं पसि लबेदा खिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","चमैंए आबालाइ अभिषेक लब् धोंले हारूनए च्हमैंइ खेगि तसि ङए सेवा लरिगे बिसि चमैंलाज्यै या अभिषेक लद्। छले अभिषेक लमा चमैंए पुस्ता-पुस्ता समा खोंयोंन् बिलै चमैं खेगिन् तरिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","याहवेहजी ल्हैदिबै तोन्दोंरि के मोशाइ लइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","छले चमैंइ मिश्र ह्‍युल पिथेंबै ङ्हिदिंर्बै ओंसोंबै म्हैंनर्बै ओंसोंबै त्हिंइर याहवेहए पबित्र तम्बु क्योइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","मोशाइ पबित्र तम्बु क्योइ, धै चए क्योबै क्ल्ह्‍योमैं तिसि फ्ल्याकमैंइ बार थोसि त्होमैं क्योइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","याहवेहजी बिब् धोंले पबित्र तम्बुए फिर पाल टौंदिसि पालए फिर सिंइ नोंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","झाइले लद् बिबै च्युउलो ताँ प्ह्रिबै युँमाए प्लना ङ्हिं बाछाए मुदुसर झोंसि चइ चए क्हा मुदुसए फिर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","याहवेहजी बिब् धोंलेन् मोशाइ ठिम थेंबै मुदुस पबित्र तम्बु न्होंर थेंइ, झाइले च मुदुस म्हिमैंइ आम्रोंरिगे बिसि पर्दा झोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","झाइले पबित्र तम्बुए ताइ हार पर्दाए बैरु टेबल थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","याहवेहजी मोशाने बिब् धोंलेन् टेबलए फिर याहवेह फुलबै क्हें थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","छलेन पबित्र तम्बुर्बै टेबलए ओंसों दक्षिण हारै पानस थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","याहवेहजी बिब् धोंलेन् खीए ओंसों पानसर बत्ति म्रोइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","पर्दाए ओंसों मोशाइ माराल धुप म्रोबै क्ल्ह्‍यो थेंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","याहवेहजी बिब् धोंलेन् लिंबै थाँ खबै धुप म्रोइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","झाइले पबित्र तम्बुए म्रार पर्दा झोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","झाइले याहवेहजी बिब् धोंले पबित्र तम्बुए म्रा ओंसों चइ मिइ ख्रोंबै ख्रो पिंबै क्ल्ह्‍यो थेंइ धै मिइ ख्रोंबै ख्रो नेरो रा-रोमैं फुलइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","पबित्र तम्बु नेरो ख्रो पिंबै क्ल्ह्‍योए म्हाँजोर चइ बाटा थेंसि क्यु झोंइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","याहवेहजी बिब् धोंलेन् मोशा, हारून नेरो हारूनए च्हमैंइ च बाटार्बै क्युइ यो प्हलेमैं ख्रुइ, ");
INSERT INTO gvr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","पबित्र तम्बु न्होंर अथवा ख्रो पिंबै क्ल्ह्‍योर ह्‍यामा चमैंइ यो प्हले ख्रुब्रें लमल। ");
INSERT INTO gvr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","मोशाइ पबित्र तम्बु नेरो ख्रो पिंबै क्ल्ह्‍योए कारग्युले गेरा झोंसि ह्‍युए धेरा बनेइ, धै ह्‍युर्बै म्रार पर्दा झोंइ। छले मोशाइ ताँन् केमैं खाँइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","च लिउँइँ न्हाँम्स्योइ पबित्र तम्बु हुवामा याहवेहए चारबै ह्‍वेइ पबित्र तम्बु चारइ। ");
INSERT INTO gvr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","छतमा मोशा पबित्र तम्बु न्होंर होंल् आखाँल। ");
INSERT INTO gvr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","पबित्र तम्बुउँइँले न्हाँम्स्यो स्योयामा इस्राएलीमैं अरू क्ल्ह्‍योर ह्‍यामल। ");
INSERT INTO gvr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","पबित्र तम्बुउँइँले न्हाँम्स्यो आस्योन् समा चमैं खनिरै आह्‍यामल। ");
INSERT INTO gvr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","छतमा इस्राएलीमैं खनिर प्रलैया त्हिंयाँर पबित्र तम्बुए फिर याहवेह युइमुँ बिसि उँइँबै न्हाँम्स्यो तमल, म्हुँइँसर बिस्याँ न्हाँम्स्योर मि लुँब् म्रोंमल।");
INSERT INTO gvr_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","ल्हें त्हे ओसों निसाफ लबै म्हिमैंइ ग्याल्स त्हेजरे यहूदा ह्‍युलर थेबै अँगल् तइ। छतसि यहूदार्बै बेथलेहेम नाँसउँइँले म्हि घ्रि ह्रोंसए प्ह्रेंस्यो नेरो च्ह ङ्हिं किंसि मोआबी ह्‍युलर टिबर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","चए मिं एलीमेलेक मुँल। चए प्ह्रेंस्योए मिं नाओमी धै चए च्हमैंए मिं महलोन नेरो किल्योन मुँल। चमैं यहूदार्बै बेथलेहेम नासर्बै एप्रातीमैं मुँल। चमैं मोआबी ह्‍युलर ह्‍यासि चर्न टिइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","चर टिमा नाओमीए प्युँ एलीमेलेक सियाइ, धै नाओमी नेरो चए च्ह ङ्हिं मत्‍त्रे तइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","च च्हमैं ङ्हिंइ मोआब थेंस्योमैं ओर्पा नेरो रूथने ब्ह्‍या लइ। चमैं च क्ल्ह्‍योर च्युदिदे टिरिमा ");
INSERT INTO gvr_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","च च्हमैं ङ्हिं महलोन नेरो किल्योनै या सियाइ। छले नाओमी ह्रोंसए प्युँ नेरो च्ह ङ्हिंने फ्रेयाइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","ह्रोंसए ह्‍युलर्बै म्हिमैंलाइ याहवेहजी आशिक पिंसि चब-थुँब् पिंइमुँ रो बिबै ताँ नाओमीइ मोआब ह्‍युलर थेइ। छतसि नाओमी नेरो चए चोंमैं ह्रोंसए धिंर एह्‍याबै सैं लइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","नाओमीइ ह्रोंसए चोंमैं ङ्हिं किंसि ह्रोंस टिबै क्ल्ह्‍यो वाथेंइ, धै ह्रोंसए धिंर ह्‍याबर यहूदाए घ्याँ क्हाइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","झाइले घ्याँर प्ररिमा नाओमीइ ह्रोंसए चोंमैंने बिइ, “क्हेमैं ह्रों-ह्रोंसए माइत धिंर एह्‍याद्, धै ह्रोंसए आमाने टिद्! सियाबै ङए च्हमैं नेरो ङए फिर क्हेमैंइ म्हाँया लब् धोंलेन् क्हेमैंए फिरै या याहवेहजी म्हाँया लरिगे। ");
INSERT INTO gvr_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","याहवेजी धबै क्हेमैंए धिं-नाँ चुमिंसि प्युँमैंए धिंर छेनाले थेंमिंरिगे!” च्हौ बिसि नाओमीइ चोंमैंलाइ म्वें लमा चोंमैं बेल्‍ले क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","धै चोंमैंइ नाओमीने बिइ, “ङि या क्हिने बालुन् क्हिए म्हिमैं ङाँर ह्‍याम्।” ");
INSERT INTO gvr_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","छबिमा नाओमीइ बिइ, “ओ ङए च्हमिमैं, क्हेमैं ङने तले ह्‍याब? क्हेमैं एयाद्; क्हेमैंए ल्हागिर ङइ धबै च्हमैं फिल् खाँम्मा? आखाँ! ");
INSERT INTO gvr_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","छतसि ङए च्हमिमैं, क्हेमैं ह्रोंसए माइतउँइँ एह्‍याद्, तलेबिस्याँ क्हमैंए ल्हागिर ङइ ब्ह‍या लसि च्हमैं फिब्गो बिलेया ङ माँब तयाइमुँ। प्हसे योंबै आशा लसि तिंयाँ म्हुँइँसर्न ब्ह्‍या लसि च्हमैं फिलै या ");
INSERT INTO gvr_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","चमैं थेब् तन् समा क्हेमैंइ पैंल् खाँम्‍मा? ब्ह्‍या आलल्‍ले टिम्मा? छ तलन् आखाँ ङए च्हमिमैं। क्हेमैंए फिर ङइ बेल्‍ले न्हुँ लइमुँ, दिलेया ङइ तोइ लमिंल् आखाँ। तलेबिस्याँ याहवेहए ङए बिरोधर मुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","चु ताँ थेसि चमैं धबै बेल्‍ले क्रोइ। धै स्युमिलाइ म्वें लसि ओर्पा माइत धिंउँइँ एह्‍याइ। रूथ बिस्याँ स्युमिनेन् टिइ। ");
INSERT INTO gvr_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","धै नाओमीइ रूथने बिइ, “ङ्ह्‍योत्ति, क्हिए आन ह्रोंसए म्हिमैं नेरो ह्रोंसए देवतामैंए ङाँर एह्‍याइ; क्हि या आन धोंलेन् ह्रोंसए माइतउँइँन एह्‍याद्।” ");
INSERT INTO gvr_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","छबिमा रूथइ बिइ, “क्हिलाइ वाथेंसि ह्‍याबर ङलाइ कर आल्हैदिद्। क्हि खनिर ह्‍यामुँ, ङइ या चर्न ह्‍यामु, धै क्हि खनिर टिमुँ, ङइ या चर्न टिमु। क्हिए म्हिमैं ङए म्हिमैं ग, क्हिए परमेश्‍वर ङए परमेश्‍वर ग। ");
INSERT INTO gvr_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","क्हि खनिर सिमुँ, ङइ या चर्न सिम्, धै क्हि खनिर पामुँ ङइ या चर्न पारिगे। कालइ बाहेक क्हि नेरो ङलाइ तो सैज्यै या फ्रेल् आखाँरिगे! क्हिलाइ ङइ वाथेंस्याँ याहवेहजी ङए फिर थेबै दण्ड पिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","रूथइ ह्रोंसने ह्‍याबै ल्हागिर भों लब् म्रोंसि नाओमीइ रूथने अरू तोइ आबि। ");
INSERT INTO gvr_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","धै चमैं ङ्हिं प्र-प्रइ बेथलेहेम सहरर फेनेइ। चमैं चर खइमुँ बिब ताँनइ सेइ। झाइले चर्बै चमिरिमैंइ बिइ, “क्हि नाओमीन् आङिं वा?” बिसि ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","नाओमीइ चमैंने बिइ, “अँ ङ नाओमीन् ग, दिलेया क्हेमैंइ ङने नाओमी आबिद्; ङलाइ मारा बिद्, तलेबिस्याँ ताँन् भन्दा थेबै परमेश्‍वरजी ङए छ्ह बेल्‍ले काँब लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","ङ छुइले ह्‍यामा ङने तोन्दोरि मुँल, तोगो ङने तोइ आरे, याहवेहजी ङलाइ क्होत्तेन् एभइ। छतसि क्हेमैंइ ङने नाओमी आबिद्। याहवेह ङए बिरोदर मुँ, तान् भन्दा थेबै परमेश्‍वरजी ङए फिर थेबै दु:ख तल् पिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","छले नाओमी चए चों मोआबी थेंस्यो रूथने बालु बेथहेलमर एखइ। च्हमा चर जौ खैंबै त्हे तल। ");
INSERT INTO gvr_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","चर बोअज बिबै प्लबै म्हि मुँल। च ह्रोंसए प्युँ एलीमेलेक ङाँइले नाओमीलै या नातो फेमल। ");
INSERT INTO gvr_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","तिंगैं मोआब थेंस्यो रूथइ नाओमीने बिइ, “ङ म्रोंर ह्‍यासि खाबइ ङए फिर ल्हयो खमुँ, चए लिलि म्रोंमैंइ वाथेंबै जौ सिलमैं खुबर ह्‍याल् पिंन्,” बिमा नाओमीइ “ओं ओं ह्‍याद, ङए च्हमि,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","छतसि जौ खैंब्मैंए लिलि म्रोंर जौए सिलमैं म्हैबर रूथ ह्‍याइ। छले ह्‍यामा चए क्यें एलीमेलेकए नातो फेबै बोअजए म्रोंर च फेनेइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","च्हमा बोअजै या बेथलेहेम सहरउँइँले म्रोंर फेनेइ। बोअजइ जौ खैंब्मैंने “याहवेह क्हेमैंने प्रे तरिगे!” बिमा चमैंज्यै या बिइ, “याहवेहजी क्हिए फिर आशिक पिंरिगे!” ");
INSERT INTO gvr_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","झाइले बोअजइ ह्रोंसए के लब्मैं न्होंर्बै चिबने “चु च्हमिरि खाब् जा?” बिसि ङ्योएमा ");
INSERT INTO gvr_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","चिबइ बिइ, “च मोआब ह्‍युलउँइँले नाओमीने खबै मोआबी थेंस्यो ग। ");
INSERT INTO gvr_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","‘म्रोंमैंए लिलि जौ सिलमैं खुल् पिंन्,’ बिसि चइ ङने यो छ्युँ लइ। च न्हाँग ओंनोंन् के लसिन् मुँ, तोगो तिस्यादे भों न्हरिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","छबिमा बोअजइ रूथने बिइ, “ओ ङए च्हमि, थेद्, अरूमैंए म्रोंर ह्‍यासि सिलमैं आम्हैद्, ङए के लबै म्रिंस्योमैंने प्रे चुर्न सिलमैं म्हैद्। ");
INSERT INTO gvr_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","चमैंइ खैंबै क्ल्ह्‍योर चमैंए लिलि सिलमैं म्हैद्। खाबज्यै या क्हिने तोइ आलद् बिसि ङइ चुर्बै फ्रेसिमैंने बिइमुँ। धै क्हि क्यु पिस्याँ चर फ्रेसिमैंइ खामिंसि थेंबै गौरिर्बै क्यु थुँन्।” ");
INSERT INTO gvr_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","छबिमा रूथइ बोअजए प्हलेर कुरसि बिइ, “ङ अरू ह्‍युलर्बै च्हमिरि बिब् था सेसेया क्हिइ ङए फिर तले च्हौ थेबै ल्हयो खइ?” ");
INSERT INTO gvr_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","बोअजइ बिइ, “ह्रोंसए प्युँ सियासे या स्युमिलाइ म्हाँया लसि ह्रोंसए ह्‍युल, ह्रोंसए आबा‍-आमा वाथेंसि खाबै ङो आसेबै आगुए ह्‍युलर स्युमिने प्रे खब् ग बिबै ताँ ङइ थेइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","छले छ्याँबै के लबइले क्हिए फिर इस्राएलए परमेश्‍वर याहवेहजी आशिक पिंरिगे। खी ङाँर क्हि खइमुँ, छतसि खीजी खोंयोंन् बिलै क्हिए फिर आशिक पिंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","छबिमा रूथइ बिइ, “ङ क्हिए क्येब्स्यो आङिंलै या क्हिइ ङए सैं क्होमिंसि ङए फिर ल्हयो लइ, छलेन् खोंयोंन् बिलै ङइ क्हिउँइँले ल्हयो योंरिगे।” ");
INSERT INTO gvr_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","प्रु चबै त्हे तमा बोअजइ चने बिइ, “खो खो, प्रु चखो, क्हें लुँसि सिर्कार तिंसि चद्।” छबिमा रूथ जौ खैंब्मैंनेन् बालु क्हुँमा बोअजइ चलाइ ङ्‍होबै जौ या पिंइ, धै चइ म्रेंनाले चसि ङैब थेंइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","लिउँइँ च धबै सिल खुबर रेमा “चलाइ सिलमैं मत्त्रे आङिं, खैंथेंबै प्हैंउँइँलेन् किंल् पिंन्। चने तोइ आबिद्,” बिसि बोअजइ ह्रोंसए म्रोमैंने बिइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","“जौ खैंमा जौए प्हैंउँइँले दे-दे चए ल्हागिर वाथेंन्, चलाइ आहौदिल्‍ले त्हुँल् पिंन्।” ");
INSERT INTO gvr_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","छतसि रूथइ ङेस समा म्रोंर जौ सिल खुइ। ह्रोंसइ खुबै जौ सिलमैं नेमा ङ्‍हब्योंदे तइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","धै जौ नोसि च धिंर ह्‍यामा चइ पखबै जौ स्युमिलाइ उँइँइ। धै चसि ङैपखबै जौ या चइ स्युमिलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","धै स्युमिइ “तिंयाँ क्हि जौ सिलमैं खाबए म्रोंर खुल? क्हिलाइ ह्रोंसए म्रोंर सिलमैं म्हैल् पिंबै म्हिइ आशिक योंरिगे,” बिइ। छबिमा रूथइ “तिंयाँ ङइ जौ सिलमैं खुबै क्ल्ह्‍यो क्ल्हेए मिं बोअज मुँल,” बिसि ह्रोंसइ जौ सिलमैं खुबै क्ल्ह्‍यो क्ल्हेए बारेर चइ स्युमिने ताँ लइ। ");
INSERT INTO gvr_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","च ताँ थेसि नाओमीइ ह्रोंसए चोंने बिइ, “याहवेहजी च म्हिलाइ आशिक पिंरिगे! याहवेहजी सोगोंमैं नेरो सियाब्मैंए फिर ल्हयो खमिंइ!” धबै नाओमीइ चने बिइ, “च ङ्योए नातो न्होंर्बै म्हिन् ग। ङ्योए फिर दु:ख तमा ङ्योलाइ ल्होल् त्हुबै म्हिमैं न्होंर च घ्रि ग।” ");
INSERT INTO gvr_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","स्युमिइ छबिमा रूथइ धबै बिइ, “च म्हिइ ‘ङए म्रोंर्बै जौ खुल् आखाँन् समा क्हि या ङए म्रोंमैंने बालुन् जौ खुरिद्,’ बिसि ङने बिइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","नाओमीइ बिइ, “अँ ङए च्हमि, क्हि चए केब्स्योमैंने बालुन् प्रब छ्याँब तम्। अरूए म्रोंर ह्‍यास्याँ क्हिलाइ हौदिब धोंब लल् खाँम्।” ");
INSERT INTO gvr_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","छतसि जौ नेरो गउँ खुल् आखाँन् समा रूथै या बोअजए म्रोंमैंने बालु सिलमैं खुप्रइ। छले च ह्रोंसए स्युमिने प्रे टिरिल। ");
INSERT INTO gvr_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","तिगैं रूथए स्युमि नाओमीइ चने बिइ, “ओ ङए च्हमि, ङए सैंर तारे क्हि ब्ह्‍या लसि ह्रोंसल्न धिं-नाँ चुसि टिस्याँ तमला ङ्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","बोअज ङ्योए नातो न्होंर्बै म्हि ग, क्हि या चए म्रोंस्योमैंनेन् बा-बालु के लप्रइमुँ; तिंयाँ म्हुँइँसर बोअजइ खलर जौ बतेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","छतसि ख्रुसि छ्युगु फोद्, धै छ्याँबै क्वें खिसि खलर ह्‍याद्, दिलेया चइ चब-थुँब लल् आखाँन् समा क्हि चए ओंसों आह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","च रोबर ह्‍यामा चए रोबै क्ल्ह्‍यो ङ्ह्‍योथेंन्। झाइले च न्हरु च्हुयाबै लिउँइँ क्हि था आसेल्‍ले चए प्हले प्ह्रिर ह्‍यासि चइ नेंबै क्वें आलले चैंसि रोद्। च लिउँइँ क्हिइ तो लल् त्हुम् बिबै ताँ चइन क्हिने बिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","छबिमा रूथइ बिइ, “क्हिइ तो लद् बिमुँ ङइ चन् लम्।” ");
INSERT INTO gvr_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","झाइले रूथ खलर ह्‍याइ, धै स्युमिइ बिब् धोंलेन् लइ। ");
INSERT INTO gvr_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","बोअजइ चब्-थुँब् लल् खाँसि सैं तोंदै जौ थुप्ब्रो लथेंबै तिराइ ह्‍यासि रोइ। छले रोरिमा रूथ था आसेल्‍ले ह्‍यासि बोअजए प्हले ङाँइबै नेबै क्वें ओसि रोइ। ");
INSERT INTO gvr_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","म्हुँइँस आधार बोअज न्हरुइले छोरमा ह्रोंसए प्हले ङाँर च्हमिरि घ्रि रोरिब् चइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","“क्हि खाब जा?” बिसि बोअजइ ङ्योएमा रूथइ बिइ, “ङ क्हिए केब्स्यो रूथ ग। क्हिए नेंबै क्वे ह्रोंसए केब्स्योए फिर नेंमिंन्, तलेबिस्याँ ङए दु:ख सुखर ल्होमिंल् त्हुबै म्हि क्हिन् ग।” ");
INSERT INTO gvr_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","बोहजइ बिइ, “याहवेहजी क्हिए फिर आशिक पिंरिगे। क्हि ढुक्‍का तद्, क्हिइ स्युमिलाइ लबै म्हाँया भन्दा चु ताँ थेब् मुँ, तलेबिस्याँ प्लब, ङ्हाँब फ्रेंसिमैं खाबने या क्हि आल्हैदि। ");
INSERT INTO gvr_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","तारे ढुक्‍का तसि टिद्। क्हिलाइ चैदिबै के ङइ क्हिए लागिर लमिंब्मुँ, तलेबिस्याँ क्हि छ्याँबै सुबास मुँबै च्हमिरि ग बिसि चुर्बै ताँन् म्हिमैंइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","क्हिए दु:ख सुखर ल्होमिंल् त्हुबै म्हि ङ ग बिब क्ह्रोंसेन ग, दिलेया अझै ङ भन्दा चेंदोंर्बै नातो फेबै म्हि घ्रि मुँ। चइ क्हेमैंए दु:ख सुखर ल्होमिंल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","क्हि तिंयाँबै म्हुँइँस चुर्न थोदु, धै प्हन्हाँग क्हिए ल्हागिर लल् त्हुबै के चइ लमिंम् बिस्याँ, ठिकन् मुँ; आलइ बिस्याँ ङइ लमिंस्यो। सोगों याहवेहए मिंर कसम चसि ङ बिमुँ, न्हुँ आलद्।” ");
INSERT INTO gvr_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","छबिमा न्हाँग आतन् समा रूथ बोअजए प्हले ङाँर्न रोरिइ, दिलेया मिं म्रोंब् भन्दा ओंसों रूथ रेइ। तलेबिस्याँ “खलर च्हमिरि घ्रि मुँल!” बिबै ताँ खाबज्यै आसेरिगे बिसि बोअजइ ओंसोंन् बिल। ");
INSERT INTO gvr_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","धबै बोअजइ “क्हिइ कुबै क्रमुँ तोद्,” बिमा चइ क्रमुँ तोइ, धै बोअजइ जौ टुब्योंदे क्ह्‍वेसि रूथलाइ नोल् पिंइ। झाइले रूथ सहरर एह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","रूथ ह्रोंसए स्युमि ङाँर खमा “ओ ङए च्हमि, तो तो तइ?” बिसि स्युमिइ रूथने ङ्योएइ। ");
INSERT INTO gvr_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","बोअजइ ह्रोंसने बिबै ताँन् ताँमै रूथइ स्युमिने सेइ। धै “क्हिए स्युमि ङाँर क्हि यो क्होतेंन् आह्‍याद्,” बिसि चु जौ टुब्यों या चइ ङलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","धबै नाओमीइ बिइ, “ओ ङए च्हमि, आअदेल्‍ले टिद्, तलेबिस्याँ बोअजइ चइ लल् त्हुबै के तिंयाँन् लब्मुँ। च के आलन् समा च ढुक्‍काले टिरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","छतसि बोअज सहरर्बै मुल म्रा ङाँर ह्‍यासि टिरिबै तिस्याँदे लिउँइँ चमैंलाइ दु:ख सुखर ल्होल् त्हुबै एलीमेलेकए चेंदोर्बै नातो फेबै म्हि च घ्याँन् खइ। चए बारेर बोअजइ ओसोंन् रूथने बिल। चलाइ म्रोंसि “ओ ङए थु, चुर खो,” बिसि बोअजइ चलाइ हुइ। छले हुइमा चै या बोअज ङाँर खसि टिइ। ");
INSERT INTO gvr_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","च त्हेर्न सहरउँइँले चिबनाँब्मैं च्यु च घ्याँर् खरिल। छतसि चमैंलाज्यै या बोअजइ “तिस्याँ चुर टिमिंन्,” बिसि यो छ्युँ लमा चमैं या टिइ। ");
INSERT INTO gvr_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","झाइले नाओमी नेरो रूथलाइ दु:ख सुखर ल्होल् त्हुबै एलीमेलेकए चेंदोर्बै नातो फेबै म्हिने बिइ, “ङ्योए आघेंए प्ह्रेंस्यो नाओमी मोआब ह्‍युलउँइँले एखइमुँ, चइ ह्रोंसने मुँबै म्रों तिलुँ चुँल् म्हैमुँ। ");
INSERT INTO gvr_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","छतसि चु चिबनाँब्मैंए ओंसों च म्रों क्हिइ किंरिगे बिब ङए सैं मुँ। तलेबिस्याँ चेंदोंर्बै नातो न्होंर्बै हगवाल क्हि ग। क्हिइ आकिं बिस्याँ ङन् किंम्, तलेबिस्याँ ङै या नातो न्होंर्बै म्हिन् ग।” छबिमा चइ “अँ अँ ङन् किंम्,” बिइ। ");
INSERT INTO gvr_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","धबै बोअजइ बिइ, “तम् तम्। नाओमीए क्ल्ह्‍यो किंम् बिस्याँ क्हिइ मोआब ह्‍युलउँइँले नाओमीने खबै म्हरेस्यो रूथने ब्ह्‍या लल् त्हुम्। तलेबिस्याँ सियाबै म्हिए मिं आम्हबै ल्हागिर च क्ल्ह्‍यो चए परवाए न्होंर्न तल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","चु ताँ थेसि च चेंदोंर्बै नातो फेबै म्हिइ बिइ, “चु क्ल्ह्‍यो ङ आकिं, क्हिन् किंन्। ङ चेंदोंर्बै हगवाल मुँनबिलेया चु क्ल्ह्‍‍यो किंबै हग ङइ क्हिलाइन पिंस्यो, तलेबिस्याँ चु क्ल्ह्‍यो किंइबिस्याँ लिउँइँ ङइ योंल् त्हुबै सै न्होर आयों उ बिसि ङ ङ्हिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","स्योंम इस्राएलीमैंइ क्ल्ह्‍‍यो किंब-चुँब लमा तारे ताँ पक्‍का तइ ओ बिबै ल्हागिर चुँबै म्हिइ किंबै म्हिलाइ ह्रोंसए जुत्ता प्लिसि पिंबै छ्या मुँल। छले चमैंइ ह्रोंसए ताँ पक्‍का लमल। ");
INSERT INTO gvr_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","छतसि च चेंदोंर्बै नातो फेबै म्हिइ “क्हिइन चु म्रों किंन्” बिसि ह्रोंसए जुत्ता प्लिसि बोअजलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","झाइले बोअजइ चर्बै चिबनाँब्मैं नेरो ताँन् म्हिमैंने बिइ, “एलीमेलेक, महलोन नेरो किल्‍योनए ताँन् सैमैं ङइ नाओमीए योउँइँले किंइमुँ बिबै ताँर तिंयाँ क्हेमैं साँचि मुँ। ");
INSERT INTO gvr_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","च बाहेक सियाबै म्हिए मिं खोंयोंइ आम्हरिगे बिसि महलोनए प्ह्रेंस्यो मोआबीस्यो रूथने ङइ ब्ह्‍या लइमुँ। चु सहरर्बै म्हिमैंए मिं प्ह्रिबै खाता नेरो ङ्योए म्हाँजोउँइँले महलोनए मिं खोंयोंइ म्हरिब् आरे बिबै ताँए साँचि या क्हेमैंन् मुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","छबिमा मुल म्रार मुँबै चिबनाँब्मैं नेरो ताँन् म्हिमैंइ “चु ताँर ङि साँचि मुँ,” बिइ। “धै क्हिए धिंर खबै चु च्हमिरिलाइ इस्राएलए कुल बनेबै स्योंम्बै राहेल नेरो लेआलाइ धोंले आशिक पिंरिगे। एप्राताए कुलर क्हिलाइ ताँनइ म्हाँदिरिगे। बेथलेहेमर क्हिए मिं कालेदिरिगे। ");
INSERT INTO gvr_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","झाइले याहवेहजी चु च्हमिरिउँइँले पिंबै प्हसेमैंउँइँले क्हिए सन्तान यहूदाउँइँले तामारइ फिबै च्ह फारेसए सन्तान धोंन् तरिगे।” ");
INSERT INTO gvr_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","छले बोअजइ रूथलाइ ब्ह्‍या लसि ह्रोंसए धिंर बोइ। धै याहवेहजी आशिक पिंसि चमैंलाइ च्ह घ्रि पिंइ। ");
INSERT INTO gvr_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","छतसि चर्बै च्हमिरिमैंइ नाओमीने बिइ, “याहवेहए मिं थेब् तरिगे! क्हिलाइ ल्होबै अर्को म्हि याहवेहजी पिंमा क्हिइ क्वें योंइ। इस्राएलर चु कोलोए मिं कालेदिरिगे। ");
INSERT INTO gvr_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","क्हिए च्होंइ क्हिलाइ ल्हें म्हाँया लकमुँ, क्हिए ल्हागिर च्ह ङिइ भन्दा च थेब् ग। धै तोगो चउँइँले क्हिइ क्वें योंइमुँ। चु कोलोइ क्हिलाइ छारा छ पिंब्मुँ, धै क्हि माँब् तमा चुइ क्हि छेनाले न्हब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","नाओमीइ च कोलो सुसर लसि क्ह्‍वेंदर ख्वेमल। ");
INSERT INTO gvr_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","चमैंए ङ्‍हेब्-ट्हुबमैंइ “नाओमीइ च्ह योंइ!” बिसि चए मिं ओबेद थेंइ। चुन् ओबेद यिशैए आबा नेरो दाऊदए बाज्यु तइ। ");
INSERT INTO gvr_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","फारेसए च्ह हेस्रोन तइ, ");
INSERT INTO gvr_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","हेस्रोनए च्ह आराम तइ, आरामए च्ह अम्‍मीनादाब तइ, ");
INSERT INTO gvr_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","अम्‍मीनादाबए च्ह नहशोन तइ, नहशोनए च्ह सल्‍मोन तइ, ");
INSERT INTO gvr_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","सल्‍मोनए च्ह बोअज तइ, बोअजए च्ह ओबेद तइ, ");
INSERT INTO gvr_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","ओबेदए च्ह यिशै तइ, धै यिशैए च्ह दाऊद तइ।");
INSERT INTO gvr_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","चुर मुँबै ताँमैं म्रुँ अहासूरसए पलोर तल। च म्रुँ अहासूरसइ भारात ह्‍युलउँइँले कूश ह्‍युल समा प्रसे ङ्हिस्युसे ङिं ह्‍युल फिर ग्याल्स लल। ");
INSERT INTO gvr_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","च त्हेर म्रुँ अहासूरसइ शूशनर मुँबै ह्रोंसए राजगद्दिर टिसि शासन लल। ");
INSERT INTO gvr_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","चइ शासन लबै सोंदिर ह्रोंसए ताँन् के लब्मैंए जिम्मा नोब्मैं नेरो चर्बै चिब्मैंए ल्हागिर थेबै भत्‍तेर पिंइ। छले भत्‍तेर पिंमा चर ताँन् ह्‍युलर्बै म्रुँमैंए प्हसेमैं, फारसी नेरो मादी सेनामैं, थे-थेबै म्हिमैं नेरो ताँन् ह्‍युलर्बै चिबनाँब्मैं खइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","च त्हेर म्रुँइ ह्रोंसए दरबारर मुँबै सै न्होरमैं नेरो सै ल्हें फेब छ्याँ-छ्याँबै सैमैं प्रसे प्रेज्यु त्हिंइ (म्हैंन ट्हुल्) समा उँइँइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","च त्हेमैं नुयाबै लिउँइँ म्रुँइ राजधानी शूशनर्बै थेब च्योंबै म्हिमैं ताँनलाइ भत्तेर पिंइ। च भत्तेर म्रुँए दरबारर्बै बगैंचा न्होंर ङिगैं समा तइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","च बगैंचर सुतिए तार्ग्या, पिङ्ग्या पर्दामैं च्योंल। च पर्दा तार्ग्या नेरो कलाँजी रङर्बै छोइ सिङ्गमरमर बिबै तार्ग्या युमाए त्होर मुँबै चाँदिए रिंङमैंर फैल, धै चर छ्याँ-छ्याँबै बुट्‍टा झोंबै ओल्ग्या, तार्ग्या सिङ्गमरमर नेरो सै ल्हें फेबै छ्याँ-छ्याँबै युमामैं ह्‍युर तिल। छलेन म्हि क्हुँबै ल्हागिर चए फिर मारा नेरो चाँदिए सोफामैं थेंल। ");
INSERT INTO gvr_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","धै सैं तोंदै म्रुँइ स्यो-स्योबै बुट्‍टा झोंबै माराए प्हेलर अँगुरए प्हा झोंसि चर टिबै म्हिमैंलाइ म्रेंन्ले थुँल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","चर खाबलाज्यै या कर ल्हैदिसि थुँल् पिंल् आयोंमल। छतसि ह्रोंसए के लब्मैंने “म्हिमैंइ थुँल् खाँब्दे थुँल् पिंन्,” बिसि म्रुँइ ओंसोंन् बिथेंल। ");
INSERT INTO gvr_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","च त्हेर्न म्रुँस्यो बश्तीज्यै या म्रुँ अहासूरसए दरबारर च्हमिरिमैंए ल्हागिर भत्तेर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","भत्तेर लबै ङिरोर अँगुरए प्हा थुँदै निस्योदै सैं तोंसि म्रुँइ ह्रोंसए केब्छैंमैं ङि महूमान, बिज्‍था, हर्बोना, बिग्‍ता, अबगथा, जेथेर नेरो कर्कास हुइसि “म्रुँस्योलाइ मुकुट कुसि पैरेदिसि ङ ङाँर पखो,” बिसि ल्हैदिइ, ");
INSERT INTO gvr_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","तलेबिस्याँ म्रुँस्यो बश्ती बेल्‍ले छ्याँब मुँल। छतसि चर्बै चिबनाँब्मैं नेरो अरू ताँन् मुँयुमैंइ म्रुँस्यो म्रोंरिगे बिबै सैं म्रुँल् मुँल। ");
INSERT INTO gvr_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","दिलेया चइ खो बिसि सँउँसर कुलसेया म्रुँस्यो बश्ती आखमा म्रुँ मि धोंलेन् लुँबै ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","च त्हेर “छाबै म्हिमैंए ल्हागिर तो लल् त्हुम्? नियम कानुनर तो मुँ?” बिसि क्होबर म्रुँइ ह्रब् सेब्मैंने सल्‍ला किंइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","फारस नेरो मादी ह्‍युलर्बै कर्शेना, शेथार, अद्‌माथा, तर्शीश, मेरेस, मर्सेना नेरो ममूकान बिबै म्हिमैं म्रुँने बालुन् मुँल। चमैं खोंयोंन् बिलै म्रुँ ङाँर ह्‍याल् योंमल धै च ग्याल्सर्बै थेबै मान योंब्मैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","छतसि म्रुँइ चमैंने बिइ, “म्रुँस्योलाइ किंबर ङइ म्हिमैं कुलसेया च आख। ङइ बिब चइ आङिं! तारे छाबै म्हिलाइ कानुनइ पिंल् त्हुबै सजैं तो मुँ? तलेबिस्याँ ङइ किंबर म्हिमैं कुलसेया च खल् आङिं।” ");
INSERT INTO gvr_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","छबिमा ममूकानइ बिइ, “म्रुँल् मत्त्रै आङि। म्रुँस्यो बश्तीइ म्रुँ अहासूरसए ग्याल्सर्बै ताँन् चिबनाँब्मैं नेरो अरू ताँन् मुँयुमैंल या अब्ब्रु वाइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","म्रुँस्यो बश्तीइ लबै केमैं तारे खन्तोदोंर्बै चमिरिमैंइ थेब्मुँ, धै चमैंज्यै या ह्रों-ह्रोंसए प्युँलाइ तो धोंइ आङ्हाँब्मुँ। ‘म्रुँ अहासूरइ म्रुँस्यो बश्ती ह्रोंसए ङाँर पोखो बिसि म्हिमैं कुलसेया म्रुँस्यो बश्ती आङि,’ बिसि चमैंइ बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","म्रुँस्यो बश्तीइ छ लइ बिब थेमा फारस नेरो मादीर्बै थे-थेबै घरानार्बै च्हमिरिमैंइ म्रुँए के लबै चिब्मैंने चु ताँ लब्मुँ। चु ताँइ लमा चर्बै च्हमिरिमैंज्यै या ह्रोंसए प्युँमैंलाइ तो धोंइ आङ्हाँब्मुँ, छलमा चमैंए प्युँमैं बेल्‍ले ह्रिस खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","छतसि तारे बश्ती खोंयोंइ क्हिए ङाँर खल् आयोंरिगे बिब क्हिए सैं मुँस्याँ फरिसीमैं नेरो मादीमैंए कानुनइ थोल् आखाँबै प्ह्रिछ्या घ्रि प्ह्रिबर ल्हैदिद्। धै म्रुँस्यो बश्तीए क्ल्ह्‍योरि च भन्दा छ्याँबै च्हमिरिलाइ म्रुँस्यो लसि थेंन्। ");
INSERT INTO gvr_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","छले म्रुँइ प्ह्रिछ्या प्ह्रिइ बिबै ताँ ताँन् ग्याल्सर थेनेरिगे। छलस्याँ थेब च्योंब ताँन् च्हमिरिमैंइ ह्रों-ह्रोंसए प्युँइ बिब ङिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","ममूकानइ बिबै चु ताँ म्रुँ नेरो म्रुँए चिब्मैंइ छ्याँब ङ्हाँइ, धै म्रुँइ ममूकानइ बिब् धोंन् लइ। ");
INSERT INTO gvr_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","झाइले “चर्बै मुँयुँमैंइ ह्रोंसए धिंर्बै परवार क्ल्हे लरिगे,” बिसि म्रुँइ ग्याल्सर्बै खन्तोदोंन् ह्रों-ह्रोंसए क्युइर प्ह्रिछ्या प्ह्रिसि कुलइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","लिउइ म्रुँ अहासूरसए ह्रिस म्हमा म्रुँस्यो बश्ती नेरो चइ लबै केए बिरोधर चइ प्ह्रिबै प्ह्रिछया मैंइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","छतमा म्रुँए सेवा लब्मैंइ बिइ, “क्हिए ल्हागिर छ्याँ-छ्याँबै छमिंमैं म्हैद्। ");
INSERT INTO gvr_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","ह्रोंसए ग्याल्सर्बै ताँन् ह्‍युलउँइँले क्हिइ छ्याँ-छ्याँबै छमिंमैं क्हि टिबै क्ल्ह्‍यो शूशनर्बै दरबरर पखो बिसि क्हिए के लबै म्हिमैं खटिदिद्। धै क्हिए के लबै म्हि हिचडा हेगेए जिम्मार चमैंलाइ थेंन्। धै चमैंलाइ पैरेबै सैमैं पिंन्। ");
INSERT INTO gvr_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","झाइले खाब् छमिंलाइ क्हिइ खोमुँ चलाइन बश्तीए क्ल्ह्‍योर म्रुँस्यो तरिगे।” चु ताँ म्रुँइ बेल्‍ले छ्याँब ङ्हाँइ, धै छान् लइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","राजधनि शूशनर बिन्यामिन खलकर्बै मोर्दकै मिं मुँबै यहूदी घ्रि मुँल। च याईरए च्ह मुँल, याईरए आबा शिमि मुँल, शिमिए आबा किश मुँल। ");
INSERT INTO gvr_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","बेबिलोनर्बै म्रुँ नबुकदनेसरइ यरूशलेमउँइँले यहूदार्बै म्रुँ यहोयाकीन च्युबर बोमा चु किश बिबै म्हि या चमैंने बालु बोल। ");
INSERT INTO gvr_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","चइ ह्रोंसए प्हाज्योंए च्हमि हदस्सा बिबै एस्तर धर्म च्हमि बनेल, तलेबिस्याँ चल आबा-आमा खाबै आरेल। च बेल्‍ले छ्याँब मुँल। चए आबा आमा सिबै लिउँइँ मोर्दकैइ च ह्रोंसए च्हमि धोंले न्हल। ");
INSERT INTO gvr_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","च्हम म्रुँइ प्ह्रिबै प्ह्रिछ्यार्बै ताँ खन्तोदोंन् थेनेइ। छतसि ल्हें म्हिमैंइ ह्रों-ह्रोंसए छमिंमैं शूशनर्बै म्रुँए दरबरर हेगेए जिम्मार पिंखइ। एस्तरलाज्यैया च छमिंमैंए जिम्मा किंबै म्हि हेगेए जिम्मा दरबरर पखइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","एस्तर म्रोंमा हेगे बेल्‍ले सैं तोंसि चइ पैरेबै ल्हागिर एस्तरलाइ छ्या-छ्याँबै सैमैं पिंइ। झाइले म्रुँए दरबारउँइँले चए सेवा लबै ल्हागिर हेगेइ छमिंमैं ङि खटेइ। च छमिंमैं टिबै धिंर अरूलाइ भन्दा चमैंलाइ छेन् लइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","एस्तरइ ह्रोंसए परवा नेरो ह्रेंए बारेर खाबलाज्यै या तोइ आबिल, तलेबिस्या मोर्दकैइ एस्तरने चु ताँ खाब्नेइ आबिद् बिल। ");
INSERT INTO gvr_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","एस्तर खै तरिइमुँ बिसि क्होबर च छमिंमैं टिबै धिंर्बै ह्‍यु घ्याँ मोर्दकैइ त्हिंइ ह्रोंसे प्ररिमल। ");
INSERT INTO gvr_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","च त्हेर छमिंमैं म्रुँ ङाँर बोब् भन्दा ओंसों म्हैंन टुल् समा मुर्रए छ्युगु, म्हैना टुल अत्तर फोसि छ्याँ-छ्याँबै सैमैंइ पैरेमिंमल। धै तिदिं योबै लिउँइँ छमिंमैं पलो-पलोले म्रुँ ङाँर बोमल। ");
INSERT INTO gvr_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","छमिं खाब् मुँलै खेंमैं टिबै धिंउँइँले म्रुँए दरबरर ह्‍यामा ह्रोंस चैदिबै सैमैं तो मुँलेया चइ बोसि ह्‍याल् योंमल। ");
INSERT INTO gvr_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","छमिं ङेसर म्रुँए ङाँर बोमल, धै प्हन्हाँधों न्हाँगर म्रुँइ न्हबै च्हमिरिमैंए जिम्मा किंबै म्हि हिचड शाश्गजए जिम्मार अर्को धिंर च बोमल, धै म्रुँ सैं तोंसि चए मिं तेसि आहुइन् समा च म्रुँ ङाँर ह्‍याल् आयोंमल। ");
INSERT INTO gvr_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","च त्हेर्न मोर्दकैए प्हाज्यों अबीहेलए च्हमि एस्तर म्रुँ ङाँर ह्‍याबै पलो खइ। (मोर्दकैइ एस्तरलाइ ह्रोंसए च्हमि धोंलेन् न्हल।) झाइले च छमिंमैं रुँबर थेंबै हिचड हेगेइ तो-तो बोद् बिल च मत्त्रे एस्तरइ बोइ, अरू तोइ आबो। एस्तरलाइ म्रोंब्मैं ताँनइ चलाइ छ्याँब ङ्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","म्रुँ अहासूरसइ ग्याल्स लसि टुदिंसे म्हैंन च्युल् तमा, तेबेत (पौष) बिबै म्हैनर, एस्तरलाइ दरबारर म्रुँ ङाँर बोइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","ताँन् अरू च्हमिरिमैं भन्दा म्रुँइ एस्तरलाइ बेल्‍ले खोइ, धै चए सैं ताँन् अरू छमिंमैं भन्दा एस्तर ङाँइ ह्‍याइ, छतसि म्रुँइ एस्तरए क्रर म्रुँस्योइ कुबै मुकुट कुमिंसि चलाइ बश्तीए क्ल्ह्‍योर म्रुँस्यो तल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","च लिउँइँ म्रुँइ ह्रोंसए ग्याल्सर्बै ताँन् ह्‍युलर छुट्टि लसि ह्रोंसए ग्याल्सर्बै चिबनाँब्मैं नेरो ह्रोंसए सेवा लब्मैं हुइसि एस्तरए मिंर थेबै भत्तेर पिंइ। धै ताँनलाइ सै ल्हें फेबै सैमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","ताँन् छमिंमैं धबै खागु लमा मोर्दकै म्रुँए दरबारए मुल म्रार टिरिल। ");
INSERT INTO gvr_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","मोर्दकैइ बिब् धोंलेन् एस्तरइ च त्हे समा च खाब म्हिमैं ग बिसि नेरो ह्रोंसए परवाए बारेर खाब्नेया तोइ आबिल। तलेबिस्याँ कोलो ओंनोंन् चइ मोर्दकैइ बिबै ताँ ङिंमल। ");
INSERT INTO gvr_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","तिगैं मोर्दकै म्रुँए दरबारए मुल म्रार टिरिमा दरबारए म्रार राबै हिचड ङ्हिं बिग्थाना नेरो तेरेश म्रुँने ह्रिस खसि म्रुँलाइ सैबै ताँ लरिल। ");
INSERT INTO gvr_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","चु ताँ थेसि मोर्दकैइ म्रुँस्यो एस्तरने बिइ, धै एस्तरइ मोर्दकैइ बिबै ताँ म्रुँने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","चु ताँ क्ह्रोंसेंन ङिंन उ आङिन बिसि ङ्योलु-च्युलु लमा चु ताँ क्ह्रोंसेन मुँन बिब् सेसि चमैं ङ्हिंलाइ सिं धुँर च्योवाइ। धै ओंसों तबै ताँमैं प्ह्रिथेंबै कितबर म्रुँए उँइँर चु ताँ या प्ह्रिथेंइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","च लिउँइँ म्रुँ अहासूरसइ अगागी ह्रेंर्बै हम्मदाताए च्ह हामानए मान बढिमिंसि ताँन् भन्दा थेबै चिब लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","झाइले म्रुँइ बिब् धोंलेन् म्रुँए दरबारर्बै मुल म्रार राब्मैं ताँनइ हामानलाइ च्हि तुँसि फ्योमल। दिलेया मोर्दकैइ बिस्याँ छ आलमल। ");
INSERT INTO gvr_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","छतसि म्रुँए दरबारर्बै मुल म्रार राब्मैंइ मोर्दकैने, “क्हिइ म्रुँइ बिबै ताँ तले आङिंल?” ");
INSERT INTO gvr_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","बिसि त्हिंइ ह्रोंसे बिरिमल। दिलेया मोर्दकइ चमैंए ताँ थेबै न्है आलमल। मोर्दकैइ “ङ यहूदी ग” बिसि चमैंने ओंसोंन् बिल। छतसि च अझै हामानलाइ फ्योब आफ्योब् बिसि चमैंइ “मोर्दकैइ क्हिलाइ आफ्योब् ग,” बिसि हामानने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","छले मोर्दकैइ च्हि तुँसि चलाइ आफ्योबै ताँ सेसि हामान बेल्‍ले ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","दिलेया चइ मोर्दकैए फिर यो झोंब मत्‍त्रे आङिं, म्रुँ अहासूरसए ग्याल्सर मुँबै चए ह्रेंर्बै ताँन् यहूदीमैंलाइ सैवाबै चाँजो लइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","छतसि म्रुँ अहासूरसइ ग्याल्स लबै च्युसे ङ्हिं बर्षर्बै नीसान (बैसाख) बिबै ओंसोंबै म्हैनरि “यहूदीमैंलाइ खाब म्हैनर्बै खाब त्हिंइर सैब?” बिसि त्हिंइ तोक्दिबर हामानए उँइँर म्हिमैंइ म्हैन ह्रोंसे चिट्ठा झोंमल। (च चिट्ठालाइ “पूर” बिमल।) चिट्ठा लिउँइँबै अदार (चैत्र) बिबै च्युसे ङ्हिं म्हैंनर्बै च्युसे सों त्हिंइर तइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","झाइले हामानइ म्रुँ अहासूरसने बिइ, “क्हिए ग्याल्सर मुँबै ह्रेंमैंए म्हाँजोर छाबै ह्रें घ्रि मुँ, चमैंए रोस अरू म्हिमैंल् भन्दा स्योन् मुँ। चमैंइ म्रुँए कानुनमैं आम्हाँदि, छतसि म्रुँए ल्हागिर चमैं ठिक आरे। ");
INSERT INTO gvr_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","चु ताँ क्हिए सैंर ठिकन् ग ङ्हाँस्याँ छाबै म्हिमैं सैल् त्हुम् बिबै प्ह्रिछ्या घ्रि प्ह्रिबर ल्हैदिद्। छलस्याँ च केए ल्हागिर ङज्यैया लाख सों किलो चाँदि पिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","छबिमा म्रुँइ ह्रोंसए छाप मुँबै च्या चए योउँइँले प्लिसि यहूदीमैंए शत्तुर अगागी ह्रेंर्बै हम्मदाताए च्ह हामानलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","झाइले म्रुँइ हामानने बिइ, “च चाँदि क्हिनेन् थेंन्, धै चु ह्रें या क्हिए योर्न पिंमुँ। क्हिइ तो लदा ङ्हाँमुँ, चन् लद्।” ");
INSERT INTO gvr_vpl VALUES ("ET3_12","018_3_12","EST","3","12","12","झाइले ओंसोंबै म्हैंनए च्युसे सों त्हिंइर म्रुँइ बिबै ताँमैं प्ह्रिबर म्हिमैं हुइइ, धै हामानइ बिब् धोंलेन् म्रुँए के लबै चिब्मैं, ताँन् क्ल्ह्‍योर्बै चिबनाँब्मैं नेरो ताँन् क्ल्ह्‍योर्बै ताँन ह्रेंमैंए चिब्मैंलाइ, चमैंए क्युइर्न प्ह्रिछ्या प्ह्रिसि कुलइ। म्रुँ अहासूरसए मिंउँइँलेन् च प्ह्रिछ्या प्ह्रिल, धै च प्ह्रिछ्यार म्रुँए छाप मुँबै च्याए छापै या झोंल। ");
INSERT INTO gvr_vpl VALUES ("ET3_13","018_3_13","EST","3","13","13","च प्ह्रिछ्यार तारे खबै च्युसे ङ्हिंर्बै अदार बिबै म्हैनए च्युसे सों त्हिंइर यहूदी ह्रेंर्बै कोलोमैं चिब्मैं, फ्रेंसि छमिमैं, खेब्-माँब्मैं, ताँन् सैवासि चमैंए ताँन् सै न्होर किंवाँन् बिबै ताँमैं च प्ह्रिछ्यार मुँल। ");
INSERT INTO gvr_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","तोक्दिबै त्हेर यहूदीमैं सैबर ताँन् म्हिमैं तयार तरिगे बिसि प्ह्रिछ्यार्बै ताँमैं ताँन् म्हिमैंइ सेल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","म्रुँइ ल्हैदिब् धोंले च प्ह्रिछ्या बोब्मैं युनन् क्ल्ह्‍यो क्ल्ह्‍योर ह्‍याइ। चु ताँमैं राजधानी शूशनर्बै म्हिमैंने या बिइ। चु ताँ थेसि शूशनर्बै म्हिमैं खैलबैल तइ, दिलेया म्रुँ नेरो हामान बिस्याँ प्हा थुँबर टिइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","चु ताँ था सेसि मोर्दकैइ ह्रोंसए क्वें ट्होदै नइ ह्रेंग खिसि मेप्रो फोसि थेबै कैले क्रोदै सहरजरे स्युर प्रइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","च्हमा मर्दकइ म्रुँए दरबारए मुल म्रा समा ह्‍याइ, तलेबिस्याँ नइ ह्रेंग खिसि खाबै या म्रुँए मुल म्राउँइँले न्होंर होंल् आयोंमल। ");
INSERT INTO gvr_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","छले म्रुँइ कुलबै प्ह्रिछ्या योंबै ताँन् क्ल्ह्‍योर्बै यहूदीमैं क्रोदै न्हुँ लसि बर्त टिइ, झाइले चमैं नइ ह्रेंगा खिसि मेप्रोए फिर टिइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","छतबै ताँ एस्तरए केब्स्योमैं नेरो हिचडमैंइ एस्तर ङाँर खसि बिमा म्रुँस्यो खैल-तोल तसि आदेइ। झाइले मोर्दकैइ नइ ह्रेंग प्लिइ भ्योंवासि छ्याँबै क्वें खिरिगे बिसि एस्तरइ चए ल्हागिर क्वेंमैं पिमिंइ, दिलेया मोर्दकैइ च क्वें खिल् आङिं। ");
INSERT INTO gvr_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","छतसि मोर्दकैइ खै तरिगे तो तरिगे बिसि क्होबर एस्तरइ हताक बिबै हिचड घ्रि हुइसि मोर्दकैइ ङाँर कुलइ। चु हिचड एस्तरए के लबै ल्हागिर म्रुँइ खटेबै म्हि मुँल। ");
INSERT INTO gvr_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","झाइले च हताक म्रुँए दरबारए उँइँर मुँबै चौरर मोर्दकैए ङाँर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","छले हताक च ङाँर खमा मोर्दकैइ “म्रुँइ यहूदीमैं सैल् त्हुम् बिसि प्ह्रिछ्या प्ह्रिइ, धै युहूदिमैं सैबर हामानइ लाख सों किलो चाँदि पिंम्। छतसि ङ बेल्‍ले न्हुँ खइमुँ बिबै ता एस्तरने बिमिंन्,” बिसि हाताकने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","म्रुँइ शूशनर यहूदीमैं सैल् त्हुम् बिसि प्ह्रिबै प्ह्रिछ्यार्बै ताँमैं अर्को काउदर सार्दिसि चु प्ह्रिछ्या एस्तरलाइ पिंन् बिइ, धै “ह्रोंसए ह्रेंमैं जोगेबै ल्हागिर क्हि म्रुँ ङाँर ह्‍यासि बिन्ति लद्!” बिबै ताँ या एस्तरने खैलसेया बिद् बिसि मोर्दकैइ हताक कुलइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","छले हताक ह्‍यासि मोर्दकैइ बिबै ताँन् ताँमैं एस्तरने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","च लिउँइँ धबै मोर्दकैइ ङाँर ह्‍यासि चु ताँ बिद् बिसि एस्तरइ हताक कुलइ, ");
INSERT INTO gvr_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“मुँयुमैं मुँलै च्हमिरिमैं मुँलै, म्रुँ आहसुरसए दरबार न्होंर होंम् बिस्याँ चए ल्हागिर घ्रि मत्‍त्रे ठिम मुँ। म्रुँइ ह्रोंसने मुँबै माराए प्हरे आस्योंस्याँ च सैवाब्मुँ, माराए प्हरे स्योंइ बिस्याँ च सोल् योंब्मुँ। ङै या म्रुँ ङाँर ह्‍याल् आयोंब सोंच्यु त्हिंइ तइ।” ");
INSERT INTO gvr_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","हताक ह्‍यासि एस्तरइ बिबै ताँमैं मोर्दकैने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","धै मोर्दकैइ हताकने म्रुँस्यो एस्तरए ल्हागिर चु सँउँसर कुलइ, “क्हि म्रुँस्यो तसि म्रुँए दरबारर मुँ बिबर्न यहूदीमैं न्होंरि ङ मत्त्रे सोल् योंब्मुँ बिबै सैं क्हिइ आमैंन्। ");
INSERT INTO gvr_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","छाबै त्हेर क्हि आपोंल्‍ले टिइ बिस्याँ यहूदीमैं जोगेमिंबर अरूमैंन् त्होंब्मुँ, दिलेया क्हि नेरो क्हिए आबाए सन्तानमैं ताँन् सिब्मुँ। ह्रोंसए ह्रेंमैंलाइ जोगेबै ल्हागिर्न क्हि चु त्हेर्न म्रुँस्यो तसि म्रुँए दरबारर टिल् योंइ उ?” ");
INSERT INTO gvr_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","धबै एस्तरइ मोर्दकै ङाँर छ बिसि कुलइ, ");
INSERT INTO gvr_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“छ बिस्याँ क्हि ह्‍यासि शूशनर्बै ताँन् यहूदीमैं खागु लद्, धै सोंरो समा त्हिंयाँ म्हुँइँस तोइ आचल्‍ले तोइ आथुँन्ले ङए ल्हागिर बर्त टिद्। ङ नेरो ङए केब्स्योमैं या छलेन् बर्त टिम्। च लिउँइँ ठिमए बिरोधर मुँलैया ङ म्रुँ अहासूरस ङाँर ह्‍याब्मुँ। सिल् त्हुम् बिस्याँ, ङ सिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","च ताँ थेसि मोर्दकै ह्‍यासि एस्तरइ चने बिब् धोंन् लइ। ");
INSERT INTO gvr_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","बर्त टिसि सोंरोर एस्तरइ म्रुँस्योइ खिल् त्हुबै क्वें खिइ, धै म्रुँए दरबारए न्होंर्बै ह्‍युर ह्‍यासि रारिइ। च त्हेर म्रुँ ह्रोंसए गद्दिर क्हुँसि मुल म्राउँइँ ह्‍वेंरिल। ");
INSERT INTO gvr_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","च्हमा एस्तर ह्‍युर रारिब् म्रोंसि म्रुँइ ह्रोसए योर्बै माराए प्हरे एस्तरउँइँ स्योंइ। छलमा एस्तर चेंदो ह्‍यासि म्रुँए प्हरेए च्होर छुइ। ");
INSERT INTO gvr_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","झाइले म्रुँइ बिइ, “म्रुँस्यो एस्तर, क्हिलाइ तो चैदिइमुँ? क्हिइ तो ह्रिलैया ङइ पिंस्यो, ङए आधा ग्याल्स ह्रिलेया ङइ क्हि पिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","छबिमा एस्तरइ बिइ, “ओ म्रुँ, क्हिइ छ्याँब ङ्हाम् बिस्याँ हामान नेरो क्हि खैलसेया खमिंन्। तिंयाँ ङइ क्हिए ल्हागिर लिंबै चबै सैमैं ह्‍योथेंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","छबिमा एस्तरइ बिब् धोंलेन् म्रुँइ “हामान युनन् हुइ पउ,” बिसि म्हि कुलइ। धै म्रुँ नेरो हामान एस्तरए ङाँर चब् चबर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","च्हमा अँगुरए प्हा थुँदै म्रुँइ एस्तरने धबै बिइ, “क्हिइ ङने तो ह्रिइमुँ? तो ह्रिलैया ङइ पिंस्यो। क्हिइ ह्रिदा ङ्हाँबै सै तो जा? बिद्, ङ‍ए आधा ग्याल्स समान् ह्रिलैया ङइ पिंस्यों।” ");
INSERT INTO gvr_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","एस्तरइ बिइ, “ङए बिन्ति चुन् मुँ: ");
INSERT INTO gvr_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","ओ म्रुँ, ङए ताँ ङिंम् बिस्याँ, ङइ ह्रिबै सै पिंम् बिस्याँ, प्हन्हाँगै या क्हेमैंए ल्हागिर ङइ ह्‍योथेंबै चबै सैमैं चबर खमिंन्। धै च्हमन् ङए सैंर्बै ताँमैं ङइ क्हिने बिस्यो।” ");
INSERT INTO gvr_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","च त्हिंइर हामान सैं तोंदै ह्‍यारिमा मोर्दकै म्रुँए दरबारए मुल म्राए ओसों म्रोंइ। हामान म्रोंलेया च आरे, आङ्हिंन्ले क्हुँइ। छाब् म्रोंसि हामान बेल्‍ले ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","छ तलेया हामानइ ह्रोंसए ह्रिस थौंदसि धिंर ह्‍याइ। झाइले चइ ह्रोंसए थुमैं नेरो ह्रोंसए प्ह्रेंस्‍यो जेरेश हुइबर म्हि कुलइ। ");
INSERT INTO gvr_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","चमैं खबै लिउँइँ हामानइ ह्रोंसए सै न्होरमैं कति मुँ बिबै ताँ, च्ह-च्हमि कति मुँ बिबै ताँ नेरो के लब्मैंए न्होंर म्रुँइ चलाइ खैले ताँन् भन्दा थेबै पदर थेंमिंइ बिबै ताँ चमैंने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","हामानइ धबै बिइ, “च्हौ मत्त्रे आङिं, के लब्मैं न्होंर म्रुँने बालु चब् थुँब लबर म्रुँस्यो एस्तरइ ङलाइ मत्त्रे हुइइ। धबै प्हान्हागै या म्रुँने बालुन् चब् थुँब् लबर ङलाइ हुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","दिलेया ङल थेबै मान, ल्हें सै न्होरमैं नेरो च्ह-च्हमिमैं मुँलेया च यहूदी मोर्दकै म्रुँए दरबारए मुल म्राए ओसों क्हुँरिब् म्रोंन् समा ङए सैंर सन्तोक आत।” ");
INSERT INTO gvr_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","चु ताँ थेसि चए प्ह्रेंस्यो जेरेश नेरो चए ताँन् थुमैंइ बिइ, “चलाइ च्योसि सैवाबै ल्हागिर ङ्हिंस्युसे ङ्‍ह मिटर नुबै त्हो क्योदु, धै प्हान्हा न्हाकर्न च त्होर मर्दाकैलाइ च्योवासि सैबर ल्हैदिद् बिसि म्रुँने बिदु। च लिउँइँ सैं तोंदै म्रुँने बालु म्रुँस्योइ ह्‍योथेंबै चब् चबर ह्‍याद्।” छबिमा चु ताँ हामानइ बेल्‍ले छ्याँब ङ्हाँइ, धै चइ मोर्दकै च्योवाबै ल्हागिर त्हो क्योबर ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","च म्हुँइँसर म्रुँलाइ तिफुँइ न्हरु आख। छतसि म्रुँइ ह्रोंसए के लबै म्हि घ्रिने चए ग्याल्सर ओसों तल् खाँबै ताँमैं प्ह्रिथेंबै कितब पखसि खेमिंन् बिसि ल्हैदिइ, धै चइ कतब पखसि म्रुँए ल्हागिर खेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","म्रुँए म्रार राबै म्हि ङ्हिं बिग्थाना नेरो तेरेशइ म्रुँ अहासूरसलाइ सैबै चाँजो लइमुँ बिबै ताँ च कितबर प्ह्रिथेंल। धै च ताँ मोर्दकैउँइँले सेल बिसि थेइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","झाइले चु ताँ सेसि म्रुँइ बिइ, “चु ताँए ल्हागिर मोर्दकैलाइ तो इनाम पिंइ दि?” धै म्रुँए सेवा लब्मैंइ बिइ, “मोर्दकैए ल्हागिर तोइ इनाम आपिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","छबिमा म्रुँइ “चोकर खाब् मुँ?” बिसि ङ्योएइ। च त्हेर्न हामानइ मोर्दकै च्योब बिसि चइ बनेबै त्हो क्योसि म्रुँने च ताँ बिबर दरबारर्बै चोकर फेखल। ");
INSERT INTO gvr_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","छतसि म्रुँए सेवा लब्मैंइ बिइ, “चोकर हामान रारिइमुँ।” धै म्रुँइ “च न्होंर पखो,” बिसि ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","झाइले हामान न्होंर खमा, म्रुँइ चने “म्रुँइ ह्रोंसए सैंउँइँलेन् मान् इजेत पिंदा ङ्हाँबै म्हिए ल्हागिर तो लल् त्हुमुँ?” बिसि चने ङ्योएइ। छबिमा “म्रुँइ मान् इजेत पिंबै म्हि ङ बाहेक् अरू खाब् मुँलै?” बिसि हामानइ मैंइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_7","018_6_7","EST","6","7","7","छतसि चइ म्रुँने बिइ, “खाबलाइ म्रुँइ मान्-इजेत पिंदा ङ्हामुँ, ");
INSERT INTO gvr_vpl VALUES ("ET6_8","018_6_8","EST","6","8","8","चए ल्हागिर म्रुँइ ह्रोंसइ खिबै क्वें, म्रुँइ क्रेबै घोडा नेरो म्रुँए क्रर कुबै मुकुट पखरिगे। ");
INSERT INTO gvr_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","च क्वें नेरो घोडा म्रुँए के लब्मैं न्होंर्बै ताँन् भन्दा थेबै पद मुँबै चिबए योर पिंरिगे, धै च चिबइ म्रुँइ मान-इजेद पिंदा ङ्हाँबै म्हिलाइ च सैमैं पैरेमिंरिगे। धै सहरर्बै घ्याँजरे च घोडा फिर क्रेसि स्युररिमिमा ‘म्रुँइ मान-इजेत पिंबै म्हिलाइ खैबै इनाम पिंइमुँ ङ्‍ह्‍योद्!’ बिदै चिबनाँब्मैं चए ओंसों-ओंसों घ्याँजरे ओररिगे।” ");
INSERT INTO gvr_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","झाइले म्रुँइ हामानने बिइ, “छ बिस्याँ क्हिइ बिब् धोंलेन् च क्वें नेरो घोडा युनन् पखो, धै यहूदी मोर्दकैए ल्हागिर छान् लद्। च दरबारर्बै ओंसों मुल म्रार टिरिम्। क्हिइ बिबै ताँन् ताँमैंर घ्रि या आछुटिरिगे।” ");
INSERT INTO gvr_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","म्रुँइ बिब् धोंलेन् हामानइ च क्वें पखसि मोर्दकै घोडा फिर क्रेमिंइ, धै सहरर्बै घ्याँजरे स्युरदै बोसि ओंसों-ओसों हामान छ बिदै ओरइ, “म्रुँइ मान-इजेत पिंबै म्हिलाइ खैबै इनाम पिंइमुँ ङ्ह्‍योद्!” बिसि बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","झाइले मोर्दकै धबै म्रुँए मुल म्रार एखइ। हामान बिस्याँ सुँ हुदै धिंर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","धै चइ ह्रोंसए प्ह्रेंस्यो जेरेश नेरो ताँन् थुमैंने ह्रोंसए फिर तखबै ताँन् ताँमैं बिइ। धै चलाइ सल्‍ला पिंबै थुमैं नेरो चए प्ह्रेंस्यो जेरेशइ चने बिइ, “च मोर्दकै यहूदी ह्रें ग बिस्याँ, क्हिइ चए न्होह्रों लल् आखाँ। क्हिइ चए फिर ट्होल् आखाँ, क्हिइ चए ओंसों खैलेबिले कुरल् त्हुब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","छले चमैंइ हमानने प्रे च ताँमैं लरिबै त्हेर म्रुँए के लबै हिचडामैं फेखइ, धै हामानलाइ एस्तरए ङाँर चब चबर बोयाइ। ");
INSERT INTO gvr_vpl VALUES ("ET7_1","018_7_1","EST","7","1","1","झाइले म्रुँ नेरो हामान म्रुँस्यो एस्तर ङाँर चब् चबर ह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("ET7_2","018_7_2","EST","7","2","2","च अर्को त्हिंइर अँगुरए प्हा थुँदै म्रुँइ म्रुँस्यो एस्तरने धबै बिइ, “म्रुँस्यो एस्तर, तारे क्हिए सैंर तो मुँ? बिद्। क्हिइ तो ह्रिदा ङ्हाँइमुँ? च ङइ क्हि पिंस्यो। क्हिइ ङए आधा ग्याल्स ह्रिलैया ङइ पिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","छबिमा म्रुँस्यो एस्तरइ बिइ, “ओ म्रुँ, क्हि ङए फिर ल्हयो खम् बिस्याँ, धै ङए यो छ्युँ पिंदा ङ्हाँस्याँ, ङ नेरो ङए ह्रेंमैं जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","तलेबिस्याँ ङ नेरो ङए ह्रेंमैंलाइ सैवासि ङिए मिं-क्ह्रन् म्हवाद् बिसि म्हिमैंलाइ मुइ पिंइमुँ। ङिलाइ केब्छैं-केब्स्योमैं तबर मत्‍त्रे चुँवाब् ग बिस्याँ ङ आपोंन्ले टिमल, च्हौ च्योंबै ताँर म्रुँलाइ छोंरों ङ्हाँन् आलमल।” ");
INSERT INTO gvr_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","चु ताँ थेसि म्रुँ अहासूरसइ एस्तरने बिइ, “छाबै के लबै म्हि खाब् जा? च खनिर मुँ?” ");
INSERT INTO gvr_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","एस्तरइ बिइ, “ङलाइ सैल् म्हैबै ङिए शत्तुर चु दुष्‍ट हामानन् ग।” छ बिब् थेसि म्रुँ नेरो म्रुँस्योए ओंसों हामान बेल्‍ले ङ्हिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","झाइले म्रुँ ह्रिसइ मि धों तसि अँगुरए प्हा थुँरिबै क्ल्ह्‍योउँइँले रेसि दरबारए बगैंचाए बैरु ह्‍याइ। हामान बिस्याँ ह्रोंसए ज्यु जोगेबर म्रुँस्यो एस्तरने यो छ्युँ लरिइ, तलेबिस्याँ तारे म्रुँइ दण्ड पिब्मुँ बिब चइ सेल। ");
INSERT INTO gvr_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","झाइले म्रुँ दरबारए बगैंचाउँइँले अँगुरए प्हा थुँबै क्ल्ह्‍योर धबै एखमा एस्तर रोबै सोफाए फिर हामान क्रेरिब म्रोंइ। छाब् म्रोंसि म्रुँ ह्रिस खसि “चुइ ङए धिंर, ङए ओंसोंन् म्रुँस्योलाइ न्होंवाल् म्हैमुँ उ तो जा?” बिसि ओरइ। म्रुँइ छ बिबै तोदोंन् हिचडमैंइ हामानए लि हुवाइ। ");
INSERT INTO gvr_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","झाइले म्रुँए ओंसों खोंयोंइ रारिबै हिचडामैं न्होंर्बै हर्बोनाइ बिइ, “ङ्ह्‍योद्, क्हिलाइ जोगेबै मोर्दकैलाइ च्योवाब् बिसि चुइ ह्रोंसए धिंर ङ्हिस्युसे ङ्‍ह मिटर नुबै त्हो क्योइमुँ।” झाइले म्रुँइ बिइ, “छ बिस्याँ च त्होर चलाइन च्योवाद्।” ");
INSERT INTO gvr_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","म्रुँइ छबिमा मोर्दकैलाइ च्योब् बिसि क्योबै त्होर चमैंइ हामानलाइन च्योवाइ। च लिउँइँ बल्‍ल म्रुँए ह्रिस म्हइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","च त्हिंइर्न म्रुँ अहासूरसइ यहूदीमैंए शत्तुर हामानए धिं-नाँ ताँन् एस्तरलाइ पिंवाइ। झाइले एस्तरइ म्रुँने मोर्दकै ङए प्हाज्यों ग बिइ, छतसि च त्हेउँइँले मोर्दकै म्रुँ ङाँर खल् योंइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","झाइले म्रुँइ ह्रोंसए योर्बै च्या प्लिसि मोर्दकैलाइ पिंइ। च च्या म्रुँइ ओंसों हामान पिंल, धबै लिउँइँ चइन प्हेंवाइ। धै एस्तरज्यै या हामानए धिं-नाँए जिम्मा मोर्दकैलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","धबै एस्तरइ म्रुँए प्हले फ्योसि क्रोदै बिइ, “अगागी ह्रेंर्बै म्हि हामानइ यहूदीमैंए बिरोधर लल् म्हैबै आछ्याँबै चाँजोमैं स्योवामिंन्।” ");
INSERT INTO gvr_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","छबिमा म्रुँइ एस्तर ङाँइ ह्रोंसए माराए प्हरे स्योंमा एस्तर रेसि म्रुँए ओंसों राइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","एस्तरइ धबै बिइ, “ङइ बिबै ताँ क्हिइ छ्याँब ङ्हाँस्याँ, ङए फिर ल्हयो मुँस्याँ, धै चु के क्हिइ ठिक ङ्हाँस्याँ, अगागी ह्रेंर्बै हम्मदाताए च्ह हामानइ यहूदीमैंलाइ नास लल् त्हुम् बिसि प्ह्रिबै प्ह्रिछ्यार्बै ताँमैं थोबर अर्को प्ह्रिछ्या प्ह्रिबर ल्हैदिसि क्हिए ग्याल्सर्बै ताँन् क्ल्ह्‍यो-क्ल्ह्‍योर पिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","तलेबिस्याँ ङए म्हिमैंए फिर तखबै दु:ख ङइ खैले सैदिब? ङए परवा नास तब ङइ खैले ङ्‍ह्‍योब?” ");
INSERT INTO gvr_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","छबिमा म्रुँ अहासूरसइ म्रुँस्यो एस्तर नेरो यहूदी मोर्दकैने बिइ, “ङ्ह्‍योद्, ङइ हामानए ताँन् सैमैं म्रुँस्यो एस्तरलाइ पिंइमुँ, हामान बिस्याँ च्योसि सैवाइमुँ, तलेबिस्याँ चइ यहूदीमैंलाइ सैल् म्हैइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","दिलेया म्रुँए मिंर प्ह्रिसि चइ च्याए छाप ल्हैदिबै प्ह्रिछ्या खाबज्यै थोल् आखाँ। छतसि तारे क्हेमैंइ क्हेमैंए ल्हागिर खैले छ्याँब तम् ङ्हाँमुँ, छलेन ङए मिंर अर्को प्ह्रिछ्या घ्रि प्ह्रिद्, धै ङए च्याए छाप ल्हैदिद्।” ");
INSERT INTO gvr_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","छतसि सीवान (आषाढ) म्हैनर्बै ङ्हिस्युसे सों त्हिंइर म्रुँइ खटिदिबै सचिबमैं ताँन् मोर्दकैइ हुइइ, धै मोर्दकैइ बिब् धोंलेन् भारातउँइँले कूश ह्‍युल् समार्बै प्रसे ङ्हिस्युसे ङि ह्‍युलर्बै ताँन् क्रथे मिंथेमैं नेरो चिबनाँब्मैंए खें-खेंमैंए लिपि नेरो क्युइर प्ह्रिछ्या प्ह्रिइ। छलेन युहूदिमैंए ल्हागिरै या चमैंए लिपि नेरो क्युर्न प्ह्रिछ्या प्ह्रिइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","च प्ह्रिछ्या मोर्दकैइ म्रुँ अहासूरसए मिंर प्ह्रिसि म्रुँए च्याए छाप ल्हैदिइ। धै प्ह्रिछ्या बोबै ल्हागिर बेल्‍ले न्हेल् खाँबै घोडामैंर म्हिमैं क्रेमिंसि क्ल्ह्‍यो-क्ल्ह्‍योर कुलइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","“क्ल्ह्‍यो-क्ल्ह्‍योर्बै यहूदीमैं ताँन् क्ह्रिसि ह्रोंसए ह्रेंमैंलाइ जोगेल् त्हुम्। धै क्हेमैं नेरो क्हेमैंए म्रिं-प्हसेमैंने नेखबै ह्रेंमैं खाबन् मुँलेया, आर्मि पुलिसमैं मुँलेया, क्हेमैंज्यै या चमैं सैवासि चमैंए मि-क्ह्रन् म्हवाल् खाँम्, धै चमैंए धिं-नाँमैं या क्हेमैंइ किंल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","अदार (फागुन) बिबै च्युसे ङ्हिं म्हैनर्बै च्युसे सों त्हिंइर क्हेमैंइ चु के लल् खाँम्,” बिसि च प्ह्रिछ्यार प्ह्रिल। ");
INSERT INTO gvr_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","तोक्दिबै त्हिंइर यहूदीमैंइ ह्रोंसए शत्तुरमैंने खि किंल् खाँरिगे बिसि चु प्ह्रिछ्यार्बै ताँमैं क्ल्ह्‍यो-क्ल्ह्‍योर्बै ताँन् म्हिमैंलाइ बिबर ल्हैदिल। ");
INSERT INTO gvr_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","छतसि म्रुँइ बिब् धोंलेन् म्रुँए छ्याँबै घोडामैंर क्रेसि म्हिमैं प्ह्रिछ्या बोसि क्ल्ह‍यो-क्ल्ह्‍योर ह्‍याइ। धै म्रुँए टिबै क्ल्ह्‍यो शूशनर्बै म्हिमैंने या चु ताँ बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","च लिउँइँ म्रुँमैंइ खिबै तार्ग्या नेरो मु रङर्बै क्वें खिसि मोर्दकै कलाँजी रङर्बै सुतिए पछ्यौर पोइ, धै माराइ बनेबै मुकुट कुसि मोर्दकै म्रुँए दरबाराउँइँले त्होंइ। छले शूशन सहरर मुँबै ताँन् म्हिमैं बेल्‍ले सैं तोंदै उफर्दिइ, ");
INSERT INTO gvr_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","धै यहूदीमैं बेल्‍ले सैं तोंइ, तलेबिस्याँ तारे ङ्हिंल् आत्हुमल। ");
INSERT INTO gvr_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","छतमा म्रुँए ग्याल्सर्बै ताँन् क्ल्ह्‍योजरे मुँबै यहूदीमैं सैं तोंदै लिं-लिंबै चबै सैमैं चबै त्हिंइ तइ। च्हमा अरू ह्रेंर्बै ल्हें ह्रेंमैं या यहूदी ह्रें तखइ, तलेबिस्याँ चमैं यहूदीमैंने ङ्हिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","म्रुँइ ओंसोंन् बिब् धोंले अदार (फागुन) बिबै च्युसे ङ्हिं म्हैनर्बै च्युसे सोंगैंर प्ह्रिछ्यार प्ह्रिब् धोंलेन् लबै त्हे तखइ। च त्हिंइर यहूदीमैंए शत्तुरमैंइ यहूदीमैं खेंमैंए न्होंर थेंल् योंबै आशा लल, दिलेया उल्टोन् चमैं यहूदीमैंए न्होंर टिल् त्हुबै त्हिंइ तइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","च त्हिंइर म्रुँ अहासूरसए ग्याल्सर मुँबै क्ल्ह्‍यो-क्ल्ह्‍योर्बै ताँन् यहूदीमैं ह्रों-ह्रोंसए क्ल्ह्‍योर खेंमैंने नेबर खब्मैंलाइ सैब् बिसि खागु तल। छतसि म्हिमैं ङ्हिंसि चमैंने नेखल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","च क्ल्ह्‍योर्बै ताँन् चिब्मैं, क्रथे मिंथेमैं, म्रुँए के लब्मैं नेरो म्रुँए सेवा लब्मैंइ यहूदीमैंलाइ ल्होइ, तलेबिस्याँ चमैं मोर्दकैने ङ्हिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","म्रुँए दरबारर के लब्मैं न्होंर्बै क्रथे मोर्दकै थेब तइमुँ, धै चइ थेब-थेबै के लबै हग योंइमुँ बिबै ताँ ताँन् क्ल्ह्‍योजरे थेनेइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","छतसि यहूदीमैंइ खेंमैंलाइ हेल लब्मैंलाइ खै लदा ङ्हामुँ छान् लल् योंइ। धै चमैंइ ताँन् शत्तुरमैं सेलाँइ सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","यहूदीमैंइ राजधानी शूशनर ङ्‍हप्र मुँयुँमैं सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_7","018_9_7","EST","9","7","7","धै चमैंइ पर्शन्दाता, दल्फोन, अस्पाता, ");
INSERT INTO gvr_vpl VALUES ("ET9_8","018_9_8","EST","9","8","8","पोराता, अदलिया, अरीदाता, ");
INSERT INTO gvr_vpl VALUES ("ET9_9","018_9_9","EST","9","9","9","पर्मशता, अरीशै, अरीदै, नेरो बैजाता सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_10","018_9_10","EST","9","10","10","दिलेया यहूदीमैंइ चमैंए सैमैं तोंइ आकिं। चुमैं यहूदीमैंए शत्तुर हामानए च्ह च्यु हम्मदाताए क्वेंमैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","च त्हिंइर्न शूशनर्बै राजधानीर मुँयुँमैं कति सैवाइमुँ बिबै ताँ म्हिमैंइ म्रुँने बिइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","चु ताँ थेसि “यहूदीमैंइ शूशनर्बै राजधानीर मुँयुँमैं ङ्‍हप्र नेरो हामानए च्ह च्यु सैवान!” बिसि म्रुँइ म्रुँस्यो एस्तरने बिइ। “चुरमि छ लइ बिस्याँ अरू क्ल्ह्‍योरम् झन खै लगे? तारे क्हिए सैंर तोइ ताँ मुँस्याँ बिद्। तो ह्रिलेया ङइ पिंस्यो।” ");
INSERT INTO gvr_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","एस्तरइ बिइ, “क्हिए सैं मुँस्याँ तिंयाँ खै लल प्हन्हागै या यहूदीमैंइ शूशनर छान् लल् योंरिगे, धै हामानए च्ह च्युए सिनु त्होर च्योवारिगे।” ");
INSERT INTO gvr_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","छबिमा म्रुँइ म्हिमैंने छान् लबर ल्हैदिइ, धै म्हिमैंइ हामानए च्ह च्युए सिनु त्होर च्योवाइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","धबै अदार म्हैनर्बै च्युसे प्लिगैंरै या शूशनर्बै यहूदीमैं ताँन् खागु तसि चर्बै मुँयुँमैं सोंप्र सैवाइ। दिलेया चमैंने मुँबै सैमैं तोंइ आकिं। ");
INSERT INTO gvr_vpl VALUES ("ET9_16","018_9_16","EST","9","16","16","छलेन म्रुँए ग्याल्सर्बै अरू क्ल्ह्‍योजरेबै यहूदीमैं या ह्रों-ह्रोंसए क्ल्ह्‍योर खागु तसि ह्रोंसए म्हिमैं जोगेबर शत्तुरमैंने नेइ। छले नेमा चमैंइ ङिच्युसे हजार ङ्‍ह म्हिमैं सैवाइ, दिलेया चमैंने मुँबै सैमैं तोइ आकिं। ");
INSERT INTO gvr_vpl VALUES ("ET9_17","018_9_17","EST","9","17","17","छले अदार म्हैनर्बै च्युसे सोंगैंर चमैंइ खेंमैंए शत्तुरमैं सैवाइ, धै च्युसे प्लिगैंर भों न्हसि सैं तोंदै लिं-लिंबै चबै सैमैं चइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","दिलेया शूशनर्बै यहूदीमैं बिस्याँ अदार म्हैनर्बै च्युसे सों नेरो च्युसे प्लि, चु ङ्हिरोन् खेंमैंए शत्तुरमैंने नेइ। छतसि च्युसे ङ्‍‍हगैंर लिं-लिंबै चबै सैमैं चसि सैं तोंदै चमैं भों न्हइ। छले चमैंइ चु त्हिंइलाइ चाड म्हाँदिइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","दिलेया नाँस जरेबै यहूदीमैंइ बिस्याँ अदार म्हैनर्बै च्युसे प्लिगैंर चाड म्हाँदिम्। च त्हिंइर चमैंइ घ्रिइ घ्रिलाइ चबै सैमैं पिमिंम्। ");
INSERT INTO gvr_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","मोर्दकैइ चु ताँन् ताँमैं प्ह्रिबर ल्हैदिइ। झाइले म्रुँ अहासूरसए ह्‍युलर मुँबै ताँन् क्ल्ह्‍यो जरेबै यहूदीमैंलाइ प्ह्रिछ्यामैं पिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","च प्ह्रिछ्यार “तारे सेरे बर्ष ह्रोंसे चु अदार म्हैनए च्युसे प्लि नेरो च्युसे ङ्‍ह त्हिंइलाइ बेल्‍ले छेन्ले म्हाँदिद्। ");
INSERT INTO gvr_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","च त्हिंइ ङ्योइ शत्तुरमैंलाइ ट्होबै त्हिंइ ग। च त्हिंइ ङ्यो न्हुँ नेरो दु:खउँइँले फ्रेसि छिं ङ्हाँबै त्हिंइ ग। छतसि सैं तोंदै म्हाँदिद्। च त्हिंइर घ्रिइ घ्रिलाइ चबै सैमैं पिमिंन्, धै आयो-आख्युब्मैंलाइ चल् पिंन्,” बिसि प्ह्रिल। ");
INSERT INTO gvr_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","छले मोर्दकैइ कुलबै प्ह्रिछ्यार्बै ताँमैं ताँन् यहूदीमैंइ ङिंइ, धै च छ्यान् तइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","तलेबिस्याँ च त्हेए ल्हागिर्न अगागी ह्रेंर्बै हम्मदाताए च्ह यहूदीमैंए शत्रु हामानइ यहूदीमैं सैब् बिसि चिट्टा झोंबै चाँजो लइ, चिट्टाने हिब्रू क्युइर “पूरिम्” बिम्। ");
INSERT INTO gvr_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","हामानइ यहूदीमैं सैबै चाँजो लइमुँ बिबै ताँ एस्तरउँइँले म्रुँ सेसि “हामानइ यहूदीमैंलाइ खै लल् म्हैइमुँ चलाज्यै छन् लद्!” बिसि म्रुँइ प्ह्रिछ्या प्ह्रिबर ल्हैदिइ। छले ह्रोंसै लबै आछ्याँबै चाँजोइ लमा हामान नेरो चए च्हमैं त्होर च्योवाइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","(छतसि च त्हिंइमैंलाइ “पूर” बिबै ताँफुँउँइँले “पूरिम” बिइ।) च प्ह्रिछ्यार प्ह्रिबै ताँमैं ताँन् चमैंए छ्हर तल। ");
INSERT INTO gvr_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","छतसि यहूदीमैंइ “बर्ष ह्रोंसे ङ्हिरो खेंमैं, खेंमैंए प्हसेमैं नेरो यहूदी तखब्मैं ताँनइ चाड म्हाँदिल् त्हुम्,” बिसि ठिम बनेइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","“यहूदीमैंए ल्हागिर च त्हिंइमैंर तो-तो तल बिबै ताँ क्हेमैंइ खोयोंन् बिलै आम्‍लेरिगे बिसि ताँन् क्ल्हयोर्बै यहूदीमैंइ चु चाड म्हाँदिल् त्हुम्।” ");
INSERT INTO gvr_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","चु ताँ धबै अबीहेलए च्हमि म्रुँस्यो एस्तर नेरो यहूदी मोर्दकैइ “चु पूरिम बिबै चाड खैले बिलै म्हाँदिल् त्हुम्। चु ङ्योए ल्हागिर थेबै त्हिंइ ग,” बिसि थेबै अधिकारले अर्को प्ह्रिछ्या प्ह्रिइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","धै म्रुँ अहासूरसए ग्याल्सर मुँबै प्रसे ङ्हिस्युसे ङि क्ल्ह्‍यो-क्ल्ह्‍योर्बै यहूदीमैंलाइ “तारे ङ्यो ङ्हिंल् आत्हु, ङ्योइ न्हुँ लल् आत्हु,” बिसि एस्तरइ चमैंलाइ भों खबै प्ह्रिछ्यामैं पिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","झाइले यहूदी मोर्दकै नेरो म्रुँस्यो एस्तरइ “चु पूरिम बिबै चाड ठिक त्हिंइर म्हाँदिद्,” बिसि ल्हैदिइ। (यहूदीमैंइ खेंमैंज्यै ह्रोंस नेरो ह्रोंसए सन्तानमैंए ल्हागिर ओंसों योंबै दु:खमैं मैंदै बर्त टिसि सैं नब् म्हाँदिबै ठिम लब् धोंले चमैंइ पूरिम बिबै चाड म्हाँदिबै ठिम लइ।) ");
INSERT INTO gvr_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","छले म्रुँस्यो एस्तरइ पूरिमए ल्हागिर पक्‍का लबै ताँ कितबर प्ह्रिबर ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","झाइले म्रुँ अहासूरसइ चए ताँन् ह्‍युल तिगों नेरो मा ङ्युँए रे-रेमैंर मुँबै नाँसथेंमैंलाइ बालि फोबर ल्हैदिइ। ");
INSERT INTO gvr_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","म्रुँ अहासूरसए शक्ति, चए छ्याँबै केमैं, नेरो मोर्दकैलाइ थेबै मान पिंसि चए बयन्, चु ताँन् ताँमैं मादी नेरो फारस ह्‍युलर्बै म्रुँमैंए इतिहासए कितबर प्ह्रिइमुँ ");
INSERT INTO gvr_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","यहूदी मोर्दकै म्रुँ अहासूरस भन्दा न्होंर्बै ताँन् भन्दा चिब मुँल। च यहूदीमैंए थेबै म्हि मुँल। धै चइ ह्रोंसए यहूदी म्हिमैंए ल्हागिर बेल्‍ले छ्याँबै के लसि खातोनोइ खोबै म्हि तइ। मोर्दकैइ ह्रोंसए ह्रेंर्बै म्हिमैंए ताँन् सन्तानमैंए ल्हागिर शन्तिए ताँमैं मत्‍त्रे लइ।");
INSERT INTO gvr_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","दुष्‍टमैंए सल्‍लार आप्रब, नेरो पापिमैंइ लब् धोंले आलब, धै परमेश्‍वर स्यारब्मैंने बालु आटिबै म्हिइ आशिक योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","दिलेया याहवेहए ठिमर्न (नियमर्न) च सैं तोंरिमुँ, धै त्हिंयाँ म्हुँइँस खीए ठिम सैंर थेंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","च स्योंए रेर रुँइँबै सिंधुँ धोंन् तम्। चइ रो रोल् त्हुबै त्हेर रो पिंम्, धै चए प्हो खोंयोंइ आङ्योंलों। चइ तो के ललेया छ्याँब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","दुष्‍ट के लब्मैं बिस्याँ छाब आत! चमैं खैंइ नोइ बोयाबै पुइ धोंन् तम्। ");
INSERT INTO gvr_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","छतसि दुष्‍ट के लब्मैं निसाफ लबै त्हेर राल् खाँरिब् आरे, धै पापिमैं ठिक के लब्मैंने बालु टिल् योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","छलेन याहवेहजी ठिक के लब्मैं प्रल् त्हुबै घ्याँर रक्षा लमिंम्, दिलेया दुष्‍ट म्हिमैं बिस्याँ नास तबै घ्याँर प्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","अरू ह्रेंमैंइ तले जाल रोमुँ? धै म्हिमैंइ तोन् तोर्बै ताँमैं तले मैंम्? ");
INSERT INTO gvr_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","याहवेह नेरो खीजी छ्युगु फोसि त्हाँबै म्रुँए बिरोधर ह्‍युलर्बै म्रुँमैं राम्, धै चर्बै चिब्मैं खागु तसि खेंमैंए न्होंर मदो लसि ");
INSERT INTO gvr_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“चमैंइ फैबै सँउँलिमैं ङ्योइ टोंवाले धै चमैंइ फैबै छोमैं प्लवाले,” बिसि चमैंइ बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","चमैं म्रोंसि स्वर्गर्बै राजगद्दिर टिबै याहवेह निस्योम्; खीजी चमैंलाइ प्ह्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","झाइले याहवेह ह्रिस खसि चमैंलाइ हौदिब्मुँ, धै ह्रोंसए थेबै ह्रिसर खीजी चमैंलाइ ङ्हिंन् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“सियोन बिबै ङए पबित्र कोंर ङइ ह्रोंसए म्रुँ थेंइमुँ,” बिसि खीजी बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","“याहवेहजी बिद् बिबै ताँ ङइ बिब्मुँ: खीजी ङने बिइ, ‘क्हि ङए च्ह ग; तिंयाँ ङ क्हिए आबा तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","ङने बालु ह्रिद्, धै ङइ ताँन् ह्रेंमैंए फिर क्हिलाइ क्ल्हे लमिंब्मुँ, झाइले पृथ्‍बीर्बै ताँन् साँदर टिबै ह्रेंमैंए फिर क्हिलाइ क्ल्हे लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","पैए प्हरे छेसि क्हि चमैंए म्रुँ तब्मुँ, सए भाँडो तिब् धोंले क्हिइ चमैं त्हुल भुँ लवाब्मुँ।’” ");
INSERT INTO gvr_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","छतसि ओ म्रुँमैं! बुद्धि मुँब् तद्; ओ ह्‍युलर्बै क्रथे मिंथेमैं, न्हक्रों मिक्रों तद्। ");
INSERT INTO gvr_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","ङ्हिंसि त्हारदै याहवेहए सेवा लद्, धै सैं तोंन्। ");
INSERT INTO gvr_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","च्हलाइ मान लसि फ्योद्, छ आलस्याँ खी ह्रिस खब्मुँ, धै क्हेमैं घ्याँर्न सिब्मुँ, तलेबिस्याँ खी युनन् ह्रिस खम्। खीए प्हलेर ग्वार ह्रिबर ह्‍याब्मैंइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","ह्रोंसए च्ह अब्शालोमउँइँले न्हेयामा दाऊदइ प्ह्रिबै भजन। ओ याहवेह, ङए शत्तुरमैं बेल्‍ले ल्हें मुँ! ङए बिरोधर रेब्मैं या ल्हेंन् मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","“परमेश्‍वरजी चलाइ ल्होमिंरिब् आरे,” बिसि ङए बारेर ल्हें म्हिइ बिरिइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","दिलेया ओ याहवेह, क्हि ङलाइ जोगेमिंबै ढाल ग, क्हिजी ङलाइ मान पिंम्, क्हिजी ङए क्र कैंडो लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","ङ थेबै कैले याहवेहने ग्वार ह्रिब्रें लमुँ, धै खीजी ह्रोंसए पबित्र कोंउँइँले ङलाइ ज्वाफ पिंमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","ङ रोमा न्हरु खयामुँ, धै छोरमुँ, तलेबिस्याँ याहवेहजीन् ङ जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","ङए बिरोधर ङए कारग्युले राबै हजार च्यु शत्तुरमैंने या ङ ङ्हिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","ओ याहवेह ल्हुसे! ओ ङए परमेश्‍वर, ङलाइ जोगेमिंन्! ङए ताँन् शत्तुरमैंए क्ह्राँबोर ल्हिमिंन्; धै दुष्‍टमैंए स चोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","क्हिए आशिकए यो क्हिए म्हिमैंए फिर तरिगे; तलेबिस्याँ याहवेहजी ह्रोंसए म्हिमैं जोगेमिंम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर बीणा-सारङ्गींमैं ह्रादै दाऊदइ भजन घ्रि प्रिंब। ओ ङलाइ ठिक ठर्दिमिंबै परमेश्‍वर, ङइ ग्वार ह्रिमा ङलाइ ज्वाफ पिंन्। ङए फिर दुःख तमा क्हिजी ल्होमिंइ। ङए फिर दयाम्हाँया लमिंसि ङए प्राथना थेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","ओ म्हिमैं, खोंयों समा क्हेमैंइ ङए थेबै मिं वासि ङ फाफिन् लरिम्? खोंयों समा क्हेमैं केर आफेबै सैंमैं खोरिम् धै स्योलिबै देवतामैंए लिलि प्ररिम्? तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","दिलेया याहवेहजी खीजी बिब् ङिंब्मैंलाइ ह्रोंसए ल्हागिर स्यो लथेंइमुँ बिब क्हेमैंइ सेद्; ङइ ग्वार ह्रिमा याहवेहजी थेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","ङ्हिंसि त्हारद् धै पाप आलद्; क्ल्ह्‍योर रोमा ह्रों-ह्रोंसए खोंर चु ताँ मैंन्, धै च्याँ तद्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","याहवेहजी खोबै ख्रो पिंन्, धै खीए फिर्न भर थेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","“ङिलाइ छ्याँबै सैमैं खाबइ उँइँल् खाँमुँ?” बिसि ल्हें म्हिइ ङ्योएरिइमुँ। ओ याहवेह, ङइ ग्वार ह्रिमा क्हिए लिर्बै ह्‍वे ङिए फिर चारमिंसि आशिक पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","ल्हें रा-रोमैं नेरो अँगुरए लिंबै प्हा योंसि चमैं सैं तोंब् भन्दा क्हिजी ङए सैं ल्हें तोंन् लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","ङ रोमा तोइ न्हुँ आलल्‍ले न्हरु च्हुइब्मुँ; तलेबिस्याँ ओ याहवेह, क्हिजी मत्‍त्रे ङ जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर मुरलि ह्रादै दाऊदइ भजन घ्रि प्रिंब। ओ याहवेह, ङए ताँमैंर न्ह तोमिंन्; ङइ दुःख तबै सो हेंमा क्हिजी थेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","ओ ङए म्रुँ, ङए परमेश्‍वर, ङ क्हिनेन् प्राथना लम्, छतसि ङइ ग्वार ह्रिमा थेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","ओ याहवेह, न्हाँगर्न क्हिजी ङए कै थेम्; ङइ न्हाँग फोर्न क्हिने प्राथना लसि क्हि ङाँइँले योंबै ज्वाफ ह्रेरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","क्हि आछ्याँबै केर सैं तोंबै परमेश्‍वर आङिं; धै आछ्याँबै सैमैं क्हिने टिल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","थेब् प्हैंब्मैं क्हिए ओंसों रालन् आखाँ; आछयाँबै के लब्मैं ताँन् क्हिजी हेल लम्। ");
INSERT INTO gvr_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","स्योर तेसि पोंब्मैं क्हिजी नास लम्; म्हि सैब्मैं नेरो लुब्मैंने याहवेह छेरम्। ");
INSERT INTO gvr_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","दिलेया ङ बिस्याँ क्हिए खोंयोंइ आनुबै म्हाँयाइ लमा क्हिए धिं न्होंर होंल् योंब्मुँ। मान लदै ङ पबित्र क्ल्ह्‍योउँइँ तोसि क्हिलाइ फ्योब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","ओ याहवेह, ङए शत्तुरमैं ल्हें मुँ छतसि क्हिए ठिक घ्याँर ङ डोरेमिंन्; क्हिए घ्याँ ङए ओंसों सोजो लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","चमैंए सुँइ क्ह्रोंसेंन्बै ताँ आपों; चमैंए खों आछ्याँबै सैमैंइ प्लिंइमुँ; चमैंए म्‍लोगो थोंथेंबै छगों ग; छतसि चमैंइ फिब्लो पार्दिसि पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","ओ परमेश्‍वर, चमैंए दोष उँइँमिंन्; ह्रोंसइ चुबै ङोर चमैं खेंमैंन् फेरिगे; चमैंइ ल्हें अपराधमैं लइमुँ, छतसि चमैं पिवाद्, तलेबिस्याँ चमैं क्हिए बिरोधर राइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","दिलेया क्हि ङाँइँले ग्वार योंब्मैं सैं तोंरिगे, धै चमैं खोंयोंइन सैं तोंदै क्वे प्रिंरिगे। धै क्हिए मिंलाइ म्हाँया लब्मैं क्हिनेन् सैं तोंरिगे बिसि चमैं जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","तलेबिस्याँ ओ याहवेह, ठिक के लब्मैंलाइ क्हिजी आशिक पिंम्, ढालइ धोंले क्हिए म्हाँयाजी चमैं जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर बीणा-सारङ्गीं ह्रादै शिमिनिथ भाकाले प्रिंब। दाऊदए भजन घ्रि। ओ याहवेह, क्हि ह्रिस खमा ङ आहौदिद्, क्हिए ह्रिसर ङ प्हरेइ आप्रुद्। ");
INSERT INTO gvr_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","ओ याहवेह, ङने भों तिफुँइ आरे, छतसि ङए फिर ल्हयो खमिंन्; ओ याहवेह, ङए ह्रिबमैं नइमुँ, छतसि ङ सल् लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","ङए सो खैता-खैता तइमुँ! ओ याहवह, खोंयों समा पैंरिब् जा, खोंयों समा? ");
INSERT INTO gvr_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","ओ याहवेह, ङ ङाँइ तोद्, ङ सिल् आपिंन्; खोंयोंइ आनुबै क्हिए म्हाँया ङए फिर मुँबइले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","सियाब्मैंइ क्हिलाइ आमैं; क्रोंर क्हिए मिं खाबइ क्वेब्मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","ङ क्रोसि तोइ लल् आखाँब् तइमुँ; म्हुँइँस ह्रोंसे ङ क्रो-क्रोइ ङए क्ह्‍ल्यो प्हाँइमुँ, धै ङए मिग्लिइ ङए क्रेगु या प्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","न्हुँइ लमा ङए मि आचारब् तइमुँ; ङए शत्तुरमैंइ दुःख पिंबइले ङ छेनाले म्रोंल् आखाँब् तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","ओ आछ्याँबै के लबै म्हिमैं, ङ ङाँइँले ह्‍याद्, तलेबिस्याँ ङ क्रोब याहवेहजी थेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","ल्होमिंन् बिसि ङइ ग्वार ह्रिमा याहवेहजी थेइमुँ; ङइ लबै प्राथनाए ज्वाफ खीजी पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","ङए ताँन् शत्तुरमैं फापिल् त्हुब्मुँ; धै खैता-खैता तयाब्मुँ, चमैं फाफिसि तिस्यार्न ङ ङाँइँले स्योयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","दाऊदइ याहवेहए उँइँर बेन्यामीनि कूशए बारेर प्रिंबै भजन घ्रि। ओ ङए याहवेह परमेश्‍वर, ङ ग्वार योंबर क्हिए प्हलेर्न खमुँ; ङलाइ दुःख पिंबर ल्हाखब्मैं ताँनउँइँले ङ जोगेमिंन् धै फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","क्हिजी आजोगेमिंस्याँ चमैंइ सिंहइ धोंले ङ रुएवाब्मुँ, धै ङलाइ फ्रेमिंबै म्हि खाबै आरेमा चमैंइ ङ कुदु-कुदु लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","ओ ङए याहवेह परमेश्‍वर, ङए योइ तोइ आछ्याँबै केमैं लइमुँ बिस्याँ, ");
INSERT INTO gvr_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","छलेन ङए थुलाइ ङइ तोइ न्होह्रों लस्याँ, धै ङए शत्तुरलाइ ङइ फाक्‍कर्न लुडिस्याँ ");
INSERT INTO gvr_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","ङए शत्तुरइ ङलाइ ल्हामा चइ ङ स्यारिगे, धै ङलाइ सैसि सर प्लेवारिगे; धै ङए ज्यु त्हुलर कोंवारिगे। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","ओ याहवेह, ह्रिस खमा रेद्, धै ङए शत्तुरमैंने नेबर क्हिन् रामिंन्; ओ ङए परमेश्‍वर, रेद, ङए ठिक निसाफ लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","ह्रें-ह्रेंमैं क्हिए कारग्यु तरिगे, धै नुबै क्ल्ह्‍योउँइँले चमैंए फिर ग्याल्स लद्। ");
INSERT INTO gvr_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","याहवेहजी ताँन् ह्रेंमैंए फिर निसाफ लब्मुँ। ओ याहवेह, ङइ लबै ठिक के अनुसार्बै नेरो ङने तोइ छ्याब् आरेब अनुसार्बै ङए ठिक निसाफ लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","ओ ठिक निसाफ लबै परमेश्‍वर, सैं नेरो खों खैतब मुँ बिसि क्हिजी ङ्‍ह्‍योम्। दुष्‍ट म्हिमैंइ लबै आछ्याँबै केमैं सदसुदुले म्हवाद्, दिलेया ठिक के लब्मैं भोंब लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","परमेश्‍‍वरन् ङए ढाल ग, छ्याँबै खों मुँब्मैं खीजी जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","परमेश्‍वरजी ठिक निसाफ लम्, धै खीजी त्हिंइ ह्रोंसे दुष्‍टमैंए फिर ह्रोंसए ह्रिस उँइँम्। ");
INSERT INTO gvr_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","म्हिमैंइ सैं आएस्याँ खीजी ह्रोंसए सेलाँ म्याब्मुँ; खीजी ह्रोंसए त्हलेर छोइ फैसि तयार लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","खीजी ङ्हिंन् ङ्हाँबै हतियारमैं खुथेंइमुँ, धै खीजी मेमैं मिए प्हैं लसि चमैंलाइ ल्हिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","दुष्‍टमैंए सैंर आछ्याँबै ताँमैंइ प्लिंरिम्, चमैंइ आगुलाइ दुःख पिंबै ताँमैं मैंरिम्; चमैंइ स्योलिबै ताँमैं लम्। ");
INSERT INTO gvr_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","चमैंइ ताबै थेबै होंर चमैं ह्रोंसन् पायाम्। ");
INSERT INTO gvr_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","चमैंइ लबै आछ्याँबै केमैंए दण्ड चमैंए क्रर्न खम्, चमैंइ लबै दुष्‍ट केमैं चमैंए क्रर्न कुखम्। ");
INSERT INTO gvr_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","याहवेहजी ठिक निसाफ लम्, छतसि ङ खीलाइ धन्यबाद पिंम्, धै ताँन् भन्दा थेबै याहवेहए मिंर ङ क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर “गित्तित” बिबै भाका धोंले प्रिंबै दाऊदए भजन। ओ याहवेह, ङिए क्ल्हे, ह्‍युल तिगोंन् क्हिए मिं बेल्‍ले थेब मुँ! क्हिए मिंर क्वे प्रिंब मु भन्दा क्होवाइ थेनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","कोलोमैं नेरो ङ्‍हे थुँबै कोलो ओंलाँमैंए सुँउँइँले या क्हिजी ह्रोंसए मिंर क्वे प्रिंल् पिंइमुँ। क्हिए शत्तुरमैं नेरो बिरोधीमैंए सुँ म्रुबै ल्हागिर क्हिजी छ लब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","क्हिजी बनेबै मु, क्हिजी मुर थेंमिंबै लयाँ नेरो मुसारमैं ङइ ङ्‍ह्‍योमा, ");
INSERT INTO gvr_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","म्हि तो जा? क्हिजी तले चए वास्ता लब? म्हिए च्ह तो जा? क्हिजी तले चए न्हुँ लब? ");
INSERT INTO gvr_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","क्हिजी म्हिए च्हलाइ स्वर्गदूतमैं भन्दा च्युगुदे न्होंवाँइ थेंमिंइ, धै लिउँइँ खीलाइ थेबै मानए मुकुट कुमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","क्हिजी खीलाइ क्हिए योइ बनेबै सैमैं फिर्बै क्ल्हे तल् पिंइ; धै क्हिजी तोन्दोंरि सै खीए प्हले न्होंर थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","र-क्युमैं क्ल्यामैं मेमैं, क्ह्‍योंर्बै ताँन् खेदोमैं, ");
INSERT INTO gvr_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","मुर प्हुरबै नमेंमैं, मा ङ्युँइर्बै ताँगामैं, नेरो मा ङ्युँइ न्होंर मुँबै ताँन् सो प्ह्‍याबै सैमैं या म्हिए च्हए न्होंर्न थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","ओ याहवेह, ङिए क्ल्हे, ह्‍युल तिगोंन् क्हिए मिं बेल्‍ले थेब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। “च्ह सियाइ” बिबै भाकर प्रिंब। ओ याहवेह, खों न्होंउँइँलेन् ङ क्हिए मिं थेब् लब्मुँ; क्हिजी लबै ताँन् औदिबै केमैंए बयन ङ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","ङ क्हिनेन् सैं तोंसि उफर्दिब्मुँ। ओ ताँन् भन्दा थेबै परमेश्‍वर, ङ क्हिए मिंर्न क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","क्हिलाइ म्रोंसि ङए शत्तुरमैं लिग्याँइ तोसि न्हेयामा क्हिए उँइँर्न थुरसि नास तयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","तलेबिस्याँ राजगद्दिर क्हुँसि क्हिजी ठिक निसाफ लइमुँ धै ङइ योंल् त्हुबै सैमैं ङलाइ पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","अरू ह्रेंमैंलाइ क्हिजी हौदिइमुँ; झाइले दुष्‍ट म्हिमैं नास लवाइमुँ; क्हिजी चमैंए मिं क्ह्रन् म्हवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","ङए शत्तुरमैंए फिर तोइ आचैन् लवाबै दुःख खइमुँ, चमैं टिबै क्ल्ह्‍योमैं क्हिजी स्युवाइमुँ; छतसि चमैंए मिं क्ह्रन् म्हयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","दिलेया याहवेहजी खोंयोंन् बिलै ग्याल्स लमुँ; खीजी निसाफ लबै ल्हागिर ह्रोंसए राजगद्दि बनेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","खीजी ह्‍युलर्बै म्हिमैंए फिर ठिक निसाफ लम्, खीजी खाबलाज्यै या आफेलल्‍ले निसाफ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","आगुइ क्र ओलै आपिंब्मैंए ल्हागिर याहवेह किल्‍ला ग। दुःख तमा ग्वार योंबै क्ल्ह्‍यो खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","क्हिलाइ ङो सेब्मैंइ क्हिए फिर्न भर लम्; तलेबिस्याँ ओ याहवेह, क्हिलाइ म्हैब्मैंलाइ क्हिजी खोंयोंइ पिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","सियोनर टिबै याहवेहए ल्हागिर क्वे प्रिंन्! खीजी लबै केमैं ह्रें-ह्रेंमैंए उँइँर बिमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","तलेबिस्याँ याहवेहजी दुःख तब्मैं आम्ले, चमैंइ ग्वार ह्रिमा खीजी थेम्, धै चमैंलाइ दु:ख पिंब्मैंलाइ दण्डा पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","ओ याहवेह, ङ फिर दयाम्हाँया लमिंन्! ङ्ह्‍योत्ति, ङलाइ आखोब्मैंउँइँले ङइ बेल्‍ले दुःख योंल् त्हुइमुँ। छतसि कालए सुँउँइँले ङलाइ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","यरूशलेमर्बै तगररि ङइ क्हिए मिं थेब लरिमा क्हिजी ङलाइ जोगेमिंबइले ङ सैं तोंसि चर टिल् योंरिगे बिसि ङ कालए सुँउँइँले फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","अरू ह्रेंमैं ह्रोंसइ ताबै होंल्दोंर खेंमैंन् पायाइमुँ, चमैंइ लोसि चुबै ङोइ चमैं ह्रोंसन् स्याइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","याहवेहजी ठिक निसाफ लम् बिब ताँनइ सेइमुँ, दुष्‍टमैं बिस्याँ खेंमैंइ लबै केर खेंमैंन् फसेइमुँ। च्याँ तसि तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","दुष्‍ट म्हिमैं नेरो परमेश्‍वर म्‍लेयाबै ताँन् ह्रेंमैं सिसि ह्‍याबै क्रोंर फेनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","दिलेया आयों आख्युब्मैं परमेश्‍वरजी खोंयोंइ म्‍लेरिब् आरे, दुःख योंब्मैंए आशा खोंयोंइ म्हरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","ओ याहवेह रेद्, म्हिमैंइ ट्होल् आयोंरिगे, ह्रें-ह्रेंमैंए निसाफ लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","ओ याहवेह, चमैं क्हिने ङ्हिंरिगे, चमैंम् म्हि मत्‍त्रे ग बिसि अरू ह्रेंमैंइ सेरिगे। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","ओ याहवेह, क्हि तले ह्रेंगो राल? ङए फिर दुःख तमा क्हि तले लोइ टिल? ");
INSERT INTO gvr_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","दुष्‍ट म्हिमैंइ ङम् ङन् ग बिब् प्हैंसि ङ्हाँदु म्हिमैंलाइ ह्रुगुदिम्, चमैंइ लबै चाँजोर चमैंन् फसेरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","तलेबिस्याँ दुष्‍टमैं ह्रोंसए सैंर मैंबै आछ्याँबै ताँर्न प्हैंरिम्, चमैंइ खोंबै म्हिलाइ आशिक पिंम्, धै याहवेहलाइ स्यारम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","ङम् ङन् ग बिसि दुष्‍टमैंइ परमेश्‍वर आम्है, चमैंइ तोइ ताँरै या परमेश्‍वर आमैं। ");
INSERT INTO gvr_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","चमैंइ लबै केमैं खोंयोंन् बिलै चमैंए सैंर मैंब् धोंन् तम्। चमैं थेब् प्हैंरिम्, छतसि क्हिए ठिममैं चमैंउँइँले ह्रेंगो तम्। चमैंइ ह्रोंसए ताँन् शत्तुरमैं प्ह्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","“तो सैज्यैया ङलाइ लाल् खाँरिब् आरे, छतमा ङए फिर खोंयोंन् बिलै तोइ दुःख तरिब् आरे,” बिसि चमैंए सैंर मैंम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","चमैंए सुँर आगुलाइ हौदिब, स्योर तेब नेरो सराब पिंबै ताँ मत्‍त्रे मुँ; चमैंए सुँर केरै आफेबै छेरन् ङ्हाँबै ताँ मत्‍त्रे मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","नाँ-नाँसए चेंदो चमैं दाउ च्ह्‍यासि टिम्, क्होइ टिबै क्ल्ह्‍योजरे चमैंइ सोजो म्हिमैं सैम्; चमैंइ लो‍-लोइ दुःख योंरिब्मैंए छैं लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","झ्याडिए न्होंर लोसि पैंरिबै सिंह धोंले, ल्होबै म्हि खाबै आरेब्मैं क्हाबर च क्होइ टिम्, ल्होबै म्हिमैं खाबै आरेब्मैंलाइ चइ ह्रोंसए जालर चैं बोम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","दुःख योंब्मैं क्र ओलै आपिंमा चमैं नारसि क्हुरियाम्, चमैंए भोंइ लमा दुःख योब्मैं पोंयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","चमैंइ सैं न्होंर मैंइमुँ, “परमेश्‍वरजी खीए मोंडा ङउँइँले लोइमुँ, धै ङलाज्यै या म्‍लेवाइमुँ, छतसि ङइ लबै के या आम्रों।” ");
INSERT INTO gvr_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","ओ याहवेह रेत्ति! क्हिए यो क्वेदु, ल्होब्मैं खाबै आरेब्मैंलाइ आम्‍लेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","दुष्‍ट म्हिमैंइ तले परमेश्‍वरलाइ स्यारमुँ? ङइ लबै केए हिसाब परमेश्‍वरजी आथें बिसि चए सैंर तले मैंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","दिलेया ओ परमेश्‍वर, क्हिजी दुःख योंब्मैंए दुःख म्रोंमुँ, क्हिजी चमैंए दुःख ह्रोंसए योर्न किंमुँ, दुःख योंब्मैं ताँन् क्हिए प्हलेर्न खमुँ, खाबै आरेब्मैंलाइ ल्होमिंब क्हिन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","दुष्‍टमैं नेरो आछ्याँबै के लब्मैंइ तोइ लल् आखाँन् लवाद्; आछ्याँबै के लब् आपिंन् समा चमैंइ लबै केए दण्ड पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","याहवेह खोयोंन् बिलै तरिबै म्रुँ ग, छतसि खीए फिर बिश्‍वास आलबै ह्रेंमैं खीए ह्‍युलउँइँले नास तयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","ओ याहवेह! दुःख योंब्मैंए प्राथना क्हिजी थेम्; क्हिजी चमैंए सैं भोंब् लम्, धै चमैंइ ग्वार ह्रिब क्हिजी थेम्। ");
INSERT INTO gvr_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","आबा आरेब्मैं नेरो आगुइ क्र ओलै आपिंब्मैं क्हिजी जोगेमिंम्, तलेबिस्याँ ह्‍युलर्बै सिल् त्हुबै म्हिइ धबै खाबै फिरै या दुःख पिंल् खाँरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन ङ ग्वार योंबर याहवेहए प्हलेर्न खमुँ; छतसि “नमे धोंले ह्रोंसए कोंर प्हुर ह्‍याद्, बिसि क्हेमैंइ खैले ङने बिल् खाँमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","तलेबिस्याँ ङ्‍ह्‍योद्, दुष्‍टमैंइ त्हलेर छोइ फैइमुँ; मिछु खैबै क्ल्ह्‍योउँइँले सोजो म्हिमैंलाइ ल्हिब् बिसि चमैंइ मे छोर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","ठिमइ बिब् धोंले म्हिमैं आप्रस्याँ ठिक के लब्मैंइ तो लल् खाँम् रो?” ");
INSERT INTO gvr_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","दिलेया याहवेह ह्रोंसए पबित्र क्ल्ह्‍योर मुँ; याहवेहए राजगद्दि स्वर्गर मुँ; खीजी म्हिमैंलाइ छेनाले ङ्‍ह्‍योमुँ; खीजी ह्रोंसए मिजी चमैंए जाँच लमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","याहवेहजी ठिक के लब्मैंए जाँच लमुँ; आछ्याँबै के लब्मैं नेरो म्हि सैब् म्‍लुबै के लदा ङ्हाँब्मैं खीजी आखो। ");
INSERT INTO gvr_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","आछ्याँबै के लब्मैंए फिर खीजी मि नेरो बारुद प्रामिंब्मुँ, धै ट्हुबिन् लास्युवाबै लल खैंइ चमैं ख्रोंवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","तलेबिस्याँ याहवेहजी ठिक निसाफ लम्, ठिक केमैं खीजी खोम्; सोजो म्हिमैंइ खीए लि म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर शिमिनिथ भाकार प्रिंबै दाऊदइ प्ह्रिबै भजन घ्रि। ओ याहवेह, ल्होमिंन्! तलेबिस्याँ क्हिजी बिब् ङिंबै म्हि तारे घ्रि या आचैइमुँ, म्हिमैंए म्हाँजोर भर लल् खाँब्मैं खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","ताँनइ ह्रोंसए ङ्‍हेब् ट्हुब्मैंने स्योर तेसि पोंम्, चमैं फिब्लो पार्दिसि स्योर ताँमैं पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","फिब्लो पार्दिसि पोंब्मैं, नेरो थेब् प्हैंसि पोंब्मैं याहवेहजी थोवारिगे। ");
INSERT INTO gvr_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","“ङिइ पोंसि पोंइ चमैंलाइ ट्होब्मुँ,” बिसि चमैंइ बिमुँ। “ङिए सुँ ङिलन् ग! ङिए फिर खाब् क्ल्हे तल् खाँमुँ?” ");
INSERT INTO gvr_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","“आखाँम्मैं लुडिवाइमुँ, धै ङ्हाँदुमैंइ दुःखए सो हेंइमुँ। छतसि तारे ङ रेब्मुँ, धै चमैंए न्होह्रों लब्मैंउँइँले ङइ चमैं जोगेमिंब्मुँ,” बिसि याहवेहजी बिमुँ ");
INSERT INTO gvr_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","याहवेहजी फैबै बाछामैं खोट आरेब मुँ, सए कोदर मिइ ङिखे समा खारिदिबै चाँदि धोंब खीजी फैबै बाछा मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","ओ याहवेह, ङिए रक्षा क्हिजी लमिंब्मुँ, क्हिजी खोंयोंन् बिलै छाबै म्हिमैंउँइँले जोगेसि थेंमिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","आछ्याँबै के लब्मैंलाइ म्हिमैंइ खोम्। छतसि दुष्‍ट म्हिमैं ङम् ङन् ग बिब् प्हैंसि ताँनइ म्रोंल्‍ले प्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। ओ याहवेह, खोंयों समा क्हिजी ङ म्‍लेमुँ? क्हिजी खोंयोंइन म्‍लेवाम्‍मा? क्हिजी ह्रोंसए लि ङने खोंयों समा लोरिम्? ");
INSERT INTO gvr_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","खोंयों समा ङइ सैं न्होंरि दुःख सैदिल् त्हुब् जा? धै त्हिंइ ह्रोंसे ङइ कति न्हुँ लब? खोंयों समा ङए शत्तुरमैं ङए फिर ट्होगों तरिम्? ");
INSERT INTO gvr_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","ओ याहवेह ङए परमेश्‍वर, ङए फिर मि ङ्‍ह्‍योमिंन्, धै ङने ज्वाफ पिंन्, ङलाइ धबै भों पिंन्, आस्याँ ङ क्रोंर फेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","आस्याँ ङए शत्तुरइ, “ङइ च ट्होवाइ,” बिब्मुँ, धै ङ क्हुरियामा ङए शत्तुरमैं सैं तोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","दिलेया क्हिए खोंयोंइ आनुबै म्हाँयार ङइ सैं केंइमुँ, क्हिजी ङ जोगेमिंबइले ङए सैं तोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","ङ याहवेहए क्‍वे प्रिंब्मुँ, तलेबिस्याँ खीजी ङए फिर ल्हयो खम्। ");
INSERT INTO gvr_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन। आमादुमैंइ ह्रोंसए सैंर “परमेश्‍वर आरे!” बिमुँ। चमैंइ छेरन् ङ्हाँबै केमैं लमुँ, चमैं छेरन् ङ्हाँन् तब्मैं मुँ; छ्याँबै के लब्मैं खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","ताँ क्होब्मैं नेरो परमेश्‍वर म्हैब्मैं खाबै मुँ उ बिसि याहवेहजी स्वर्गउँइँले म्हिमैंलाइ ङ्ह्‍योम्। ");
INSERT INTO gvr_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","चमैं ताँन् आछ्याँबै घ्याउँइँ प्रइमुँ, धै चमैं ताँन् छेरन् ङ्हाँन् तयाइमुँ। खाबज्यै छ्याँबै के आल, छ्याँबै के लब्मैं घ्रि या आरे। ");
INSERT INTO gvr_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","चु आछ्याँबै के लब्मैंइ तोइ आसे वा? ह्‍योइ लुडिब् धोंले चुमैंइ ङए म्हिमैं लुडिसि ह्रोंसए फो न्हम्, चुमैंइ याहवेहए मिं खोंयोंइ आकिं। ");
INSERT INTO gvr_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","छतसि चमैं ङ्हिंसि आदिदिम्, तलेबिस्याँ ठिक के लब्मैंने बालु परमेश्‍वर तम्। ");
INSERT INTO gvr_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","क्हेमैं दुष्‍टमैंइ ङ्हाँदुमैंए चाँजोमैं फुवाम्, दिलेया चमैंइ ग्वार योंबै क्ल्ह्‍यो याहवेहन् ग! ");
INSERT INTO gvr_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","इस्राएलीमैं जोगेमिंबै याहवेह सियोनउँइँले युरिगे बिसि ङ प्राथना लम्! याहवेहजी ह्रोंसए म्हिमैंलाइ धबै सुख पिंमा याकूबए सन्तानमैं निस्योब्मुँ धै इस्राएलीमैंया बेल्‍ले सैं तोंब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","दाऊदए भजन घ्रि ओ याहवेह, क्हिए पबित्र तम्बुर खाब् होंल् खाँमुँ? क्हिए पबित्र कोंर खाब् टिल् योंमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","क्हिजी प्रद् बिबै घ्याँर प्रब, धै ठिक केमैं लब, खों न्होउँइँलेन् क्ह्रोंसेंन्बै ताँ पोंब, ");
INSERT INTO gvr_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","ह्रोंसए लेइ आगुलाइ आस्यारब ह्रोंसए ङ्‍हेब्मैंए न्होह्रों आलब, धै ह्रोंसए थुमैंए बारेर आछ्याँबै ताँ आपोंब, ");
INSERT INTO gvr_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","आछ्याँबै के लब्मैंलाइ आखोब, दिलेया याहवेहने ङ्हिंब्मैंलाइ मान लब, ह्रोंसए न्होह्रों तलेया ङ लम् बिबै के पूरा लब, ");
INSERT INTO gvr_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","मुइ पिंमा ब्याज आकिंब, धै तोइ छ्याब आरेबै म्हिमैंलाइ नास लबर घुस (ख्याब) आकिंब, छाबै म्हि क्हिए पबित्र कोंर टिल् योंमुँ। छ लबै म्हिइ खोंयोंइन रक्षा योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","दाऊदइ प्ह्रिबै मिक्‍ताम। ओ परमेश्‍वर, ङ जोगेमिंन्, तलेबिस्याँ ङ क्हिए प्हलेर ग्वार योंबर खइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","ङइ याहवेहने बिइमुँ, “क्हि ङए प्रभु ग; ङए ल्हागिर क्हि मत्‍त्रे छ्याँब ग, अरू तो सै या छ्याँब आरे।” ");
INSERT INTO gvr_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","इस्राएल ह्‍युलर्बै परमेश्‍वरए म्हिमैं बेल्‍ले कालदिब मुँ, चमैं म्रोंसि ङ सैं तोंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","दिलेया अरू देउतमैंए लिलि प्रब्मैंइ ह्रोंसए फिर्न ल्हें दुःख थौदिम्। च देउतमैंए मिंर कोए ख्रो ङइ पिंरिब् आरे, धै ङए सुँइ चमैंए मिं किंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","ओ याहवेह, ङइ योंल् त्हुबै सैमैं पिंब क्हिन् ग ङलाइ चैदिबै ताँन् सै क्हिजी पिंम्, ङए छ्ह या क्हिए योर्न मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","ङए ल्हागिर क्हिजी थेंमिंबै साँद बेल्‍ले छ्याँबै सैं तोंबै क्ल्ह्‍योर मुँ। क्ह्रोंसेंन, ङइ खेमैंए सै न्होर योंइँमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","ङलाइ लोदा सैंदा लबै याहवेहए मिं ङ थेब् लब्मुँ, ङए खोंइ म्हुँइँसरै या ङलाइ लोदा सैंदा लम्। ");
INSERT INTO gvr_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","ङइ याहवेह खोंयोंइन ङए ओंसों थेंइमुँ। ङए क्योलोउँइँ खी मुँ, छतसि ङ छाइ छुइ तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","छतसि ङए सैं तोंइमुँ, ङए ज्यु या ढुक्‍क मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","तलेबिस्याँ क्हिजी ङए प्ल्हलाइ क्रोंर वाथेंरिब् आरे, धै ह्रोंसए पबित्र म्हिए ज्यु क्हिजी क्राँल् पिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","क्हिजी खोंयोंइ आखाँबै छ्ह योंबै घ्याँ ङलाइ उइमिंइमुँ; क्हिने त्होमा ङए सैं बेल्‍ले तोंन् लमिंब्मुँ; क्हिए क्योलो योर खोंयोंन् बिलै सैं तोंल् योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","दाऊदइ लबै प्राथना! ओ याहवेह! ल्होमिंन् बिसि ङइ ग्वार ह्रिमा क्हिजी थेमिंन्! छ्याँबै खोंउँइँले लबै ङए प्राथनार क्हिए न्ह तोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","ङने तोइ छ्याब् आरे िबबै निसाफ क्हिउँइँलेन् खरिगे! क्हिजी ङ ङाँइ ङ्ह्‍योमा ङ ठिक के लब् म्रोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","क्हिजी ङए खोंर तोइ आछ्याँबै सै मुँ उ? बिसि म्हैलै या धै म्हुँइँसरै या ङए जाँच ललेया या ङए खों न्होंर क्हिजी आछ्याँबै सै तोइ योंरिब् आरे। ङए सुँइ पोंबै ताँइ खाबलाज्यै या सैं नल् लरिब् आरे बिसि ङइ मैंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","म्हिमैंए केए ल्हागिर बिब् ग बिस्याँ, क्हिए सुँर्बै ताँउँइँलेन् न्होह्रों लबै केउँइँले ङइ ह्रोंसलाइ जोगेसि थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","क्हिजी प्रद् बिबै घ्याँर ङए प्हलेइ भोंन्‍ले म्हैमुँ, धै ङए प्हले आप्लेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","ओ परमेश्‍वर, ङ क्हिनेन् प्राथना लम्, तलेबिस्याँ क्हिजी ङइ ह्रिबै सै पिंम्, क्हिए न्ह ङ ङाँइ तोमिंनु, धै ङइ बिबै ताँ थेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","ओ प्रभु, ह्रोंसए शत्तुरमैंउँइँले जोगेबै ल्हागिर क्हिने ग्वार ह्रिखब्मैंलाइ क्हिजी ह्रोंसए क्योलो योइ जोगेमिंसि, क्हिए खोंयोंइ आनुबै म्हाँयाजी लबै प्लेटोयान् तबै केमैं उँइँमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","क्हिए मिफुँ धोंले ङ जोगेसि थेंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","ङलाइ लुडिबै दुष्‍टमैंउँइँले नेरो ङए न्होह्रों लबर ङए कारग्यु तखबै शत्तुरमैंउँइँले जोगेबर क्हिए प्ह्‍यागोंए न्होंर ङलाइ लोथेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","चमैंए सैंर दयाम्‍हाँया तोइ आरे, दिलेया चमैं बेल्‍ले थेब् प्हैंसि पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","चमैंइ ल्हासि-ल्हाइ ङलाइ स्याइमुँ, तारे चमैं ङए कारग्यु तब्मुँ, धै ङलाइ सर क्हुरवाबै ल्हागिर चमैंइ दाउ ङ्‍ह्‍योम्। ");
INSERT INTO gvr_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","फो ख्रेंसि चबै सै म्हैप्रबै सिंह धोंन् चमैं तइमुँ, थेबै सिंह धोंले चमैं क्ह्‍वेइ टिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","ओ याहवेह, रेत्ति, चमैंने नेसि ट्होमिंन्। क्हिए सेलाँइ च दुष्‍टमैंउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","ओ याहवेह, च म्हिमैंइ चु ह्‍युलर्बै सै मत्त्रे म्हैम्, क्हिए योजी च म्हिमैं ङाँइँले ङ जोगेमिंन्। क्हिजी खोबै म्हिमैंलाइ बिस्याँ, क्हिजी चल् पिंम्, चमैंए च्ह-च्हमिमैंए ल्हागिरै या तोन्दोंरि योल्‍ले-ख्युल्‍ले पिंमुँ, धै खेंमैंए प्हसेमैंए ल्हागिर चमैंइ ल्हें सै न्होर साँथेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","ङ ठिक के लसि क्हिए लि ङ्‍ह्‍योब्मुँ, धै छोरमा ङ क्हिलाइ म्रोंसि सैं तोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर याहवेहए के लबै दाऊदए भजन घ्रि। चए ताँन् शत्तुरमैं नेरो शाऊलए योउँइँले फ्रेमिंबै त्हिंइर चइ याहवेहने चु क्वेए ताँफुँमैं बिइ। ओ याहवेह, क्हिजी ङलाइ भों पिंम्, ङइ क्हिलाइ म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","याहवेह ङ लोबै पारा, ङए किल्‍ला नेरो ङ जोगेमिंबै ङए परमेश्‍वर ग। ङए परमेश्‍वर ङ रक्षा लमिंबै पारा ग। ढाल धोंले भोंब् तसि खीजी ङलाइ जोगेमिंम्! ङ खाबज्यै तोइ लल् आखाँबै क्ल्ह्‍योर खीजी थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","ङ याहवेहए मिं किंम्, खी मान लल् त्हुब मुँ, ङए शत्तुरमैंउँइँले खीजी ङ जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","कालए छोइ ङ कारग्यु लखइ, नास लवाबै बाढिइ ङ आदेल् लइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","क्रोंर्बै छोमैंइ ङ फैवाइ, कालए ङोइ ङए घ्याँ थोइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","ङए सैंरै आमैंबै दुःखमैं ङए फिर तखमा ङइ याहवेहने ग्वार ह्रिइ, छले ल्होमिंन् बिसि ङए परमेश्‍वरलाइ हुइमा खीजी ह्रोंसए टिबै क्ल्ह‍योउँइँले ङए ताँ थेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","च्हमा सयो खसि ह्‍युल लायाइ, कोंमैंए तेंमैं या थरथरले लायाइ, तलेबिस्याँ खी ह्रिस खल। ");
INSERT INTO gvr_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","खीए नखुँउँइँले मिखु त्होंइ, खीए सुँउँइँले त्होंबै मिइ ताँन् ख्रोंवाइ, धै लुँरिबै मिए राब खीए सुँउँइँले लुँइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","खी स्वर्ग थोंसि क्युरु युइ; म्‍लोंकि ब्योंबै न्हाँम्स्यो खीए प्हले न्होंर मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","खी करूबए फिर क्रेसि प्हुरइ; धै खैंए प्ह्‍यागोंर कैंडो प्हुरयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","मिछु खैब खीजी ह्रोंसए नेंबै सै लइ; क्युइ म्‍लोंग्या लवाबै रुँदो न्हाँम्स्यो खीजी ह्रोंसए टिबै क्ल्ह्‍यो लइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","खीए चारबै ह्‍वेर न्हाँम्स्योउँइँले काम्‍लि तिम्‍लि, तिस्यु नेरो मिए राब युइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","याहवेहजी स्वर्गउँइँले थेबै कै तेमा, ताँन् भन्दा थेबै परमेश्‍वरए कै खन्तोंदोंन् कोयाइ। छतमा तिस्यु नेरो मिए राब तेयुइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","खीजी ह्रोंसए मे ल्हिसि शत्तुरमैं सग्याँ-प्हुग्याँ लवाइ, धै नाँम्रिइ ल्हिसि चमैं खैला तोला लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","ओ याहवेह, क्हिजी हौदिमा, क्हिए नखुँउँइँले त्होंबै थेबै सोइ मा ङ्युँइए तेंमैं नरो पृथ्बीए तेंमैं म्रोंयाँइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","खीजी स्वर्गउँइँले ह्रोंसए यो स्योंसि ङलाइ क्हासि, मा ङ्युँइए गैरुउँइँले ङलाइ चैंसि तेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","ङ भन्दा भोंबै शत्तुर नेरो ङलाइ आखोब्मैंउँइँले खीजी फ्रेमिंइ, तलेबिस्याँ चमैं ङ भन्दा बेल्‍ले भोंब मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","ङए फिर दुःख तमा चमैं ङए फिर ह्‍वाखइ, दिलेया याहवेहजी ङ ल्होमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","खीजी ङ खाबज्यै तोइ लल् आखाँबै क्ल्ह्‍योर पखसि ङलाइ जोगेमिंइ, तलेबिस्याँ खी ङने बालुन् सैं तोंल। ");
INSERT INTO gvr_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","ङइ ठिक के लबइले याहवेहजी ङ इनाम पिंइ, ङए योइ लबै छ्याँबै केमैं ङ्‍ह्‍योसि खीजी ङ आशिक पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","तलेबिस्याँ ङ याहवेहए घ्याँर प्रइमुँ, ङए परमेश्‍वरउँइँले ह्रेंगो तसि ङइ आछ्याँबै केमैं आलइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","खीजी पिंबै ठिममैं ङइ म्हाँदिइमुँ, धै खीजी ल्हैदिबै केमैं ङइ आपिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","ङइ आछ्याँबै केमैं तोइ आलल्‍ले टिल। छतसि खीए उँइँर ङ छ्याब् आरेब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","छतसि याहवेहजी ङइ लबै ठिक के, नेरो खीए उँइँर ङए योमैंइ लबै ठिक केमैं ङ्‍ह्‍योसि ङलाइ आशिक पिंइँमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","क्हिजी बिब् ङिंब्मैंने क्हि म्हाँया लम्। छ्याब् आरेब्मैंलाइ क्हिजी छ्याब् आरेबन् उँइँमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","छ्याँबै के लब्मैंने क्हिजी छ्याँबन् लमुँ, धै खाबने या आक्ह्रिबै म्हिमैंने क्हिजी आक्ह्रिबै ब्यबहार लम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","थेब् आप्हैंब्मैंलाइ क्हिजी जोगेमिंब्मुँ, दिलेया थेब् प्हैंब्मैं बिस्याँ क्हिजी कुरुवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","ओ याहवेह, क्हिजी ङए बत्ति लुँरिल् पिंम्, ङ मिछु खैबर प्ररिमा ङए परमेश्‍वरजी मि म्रोंल् लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","क्हिजी ल्होमिंमा ङ सिपाइमैंने नेनिल् खाँम्, ङए परमेश्‍वरजी ल्होमिंबइले ङइ गारा ङ्वैल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","परमेश्‍वरए बारेर बिब् ग बिस्याँ, खीए घ्याँ बेल्‍ले छ्याँब मुँ, याहवेहजी बिबै बाछा भर लल् खाँब मुँ; खीए प्हलेर ग्वार योंब्मैं ताँनए ल्हागिर ढाल ग। ");
INSERT INTO gvr_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","तलेबिस्याँ याहवेह धों तबै परमेश्‍‍वर अरू खाब् मुँ? ङ्योए परमेश्‍वर धों तबै लोबै पारा अरू खाब् मुँ रो? ");
INSERT INTO gvr_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","परमेश्‍वरजीन् ङलाइ भोंब लमिंम्, धै ङइ लल् म्हैबै केमैं खीजी छ्याँब् लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","खीजी ङए प्हलेमैं भोंब लमिंमुँ, छतसि फो धोंले ङ नु-नुबै क्ल्ह्‍योजरेया प्रल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","छलेन ल्हडे खैले ट्होमुँ बिसेया खीजी ङलाइ लोमिंइमुँ, छतसि ङए योइ काँसाए त्हँलेमैंया कुरल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","ङलाइ जोगेमिंबै ल्हागिर क्हिन् ङए ढाल तइमुँ। धै क्हिए क्योलो योजी ङ ल्होमिंइमुँ, ङलाइ थेब् लमिंबै ल्हागिर क्हि ह्रोंसन् कुरइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","ङ प्रबै ल्हागिर क्हिजी प्ल्हाबै घ्याँ बनेमिंम्, छतसि ङए प्हले प्लेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","ङए शत्तुरमैं ल्हाबोमा ङइ चमैं स्याइ, चमैंलाइ आसैन् समा ङ आएखल। ");
INSERT INTO gvr_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","चमैं रेलै आखाँन्ले ङइ प्रिंइ, धै चमैं ङए प्हले ङाँर क्हुरियाइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","क्हिजी ङ शत्तुरमैंने नेबै ल्हागिर भोंब लमिंइ; क्हिजी ङए शत्तुरमैं ङए प्हलेर कुरामिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","क्हिजी ङए शत्तुरमैं लिग्याँ तोसि न्हेयाल् पिंइ, छतसि ङए शत्तुरमैं ङइ सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","चमैंइ ल्होमिंन् बिसि ग्वार ह्रिइ, दिलेया चमैं जोगेमिंब खाबै आरेल। चमैंइ याहवेहने या ग्वार ह्रिइ, दिलेया खीजी चमैंने तोइ ज्वाफ आपिं। ");
INSERT INTO gvr_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","खैंइ नोइ बोबै त्हुल धोंले ङइ चमैं त्हुल भुँ लवासि घ्याँर्बै हिल धोंले ङइ चमैं भ्योंवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","ङए बिरोधीमैंए योउँइँले क्हिजी ङ जोगेमिंइमुँ, क्हिजी ङ अरू ह्रेंमैंए चिब लमिंइमुँ, ङो आसेबै म्हिमैं या ङए न्होंर मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","ङए ताँ थेबै तोंदोंन् चमैंइ ङइ बिब् धोंन् लम्, अरू ह्‍युलर्बै म्हिमैं या ङए उँइँर कुरम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","चमैं ङ्हिंसि लल-लुलु तयाम्, चमैं ह्रों-ह्रोसए लोबै किल्‍लाउँइँले ङ्हिंसि त्हारदै त्होंह्‍याम्। ");
INSERT INTO gvr_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","याहवेह सोगों मुँ! ङ लोबै पाराए मिं थेब तरिगे! ङ जोगेमिंबै परमेश्‍वरए मिं बेल्‍ले थेब तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","ङए शत्तुरमैंने खि किंब नेरो म्हिमैंलाइ ङए न्होंर थेंमिंब परमेश्‍वरन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","खीजी ङलाइ ङए शत्तुरमैंउँइँले जोगेमिंम्। ङए शत्तुरमैंए फिर क्हिजी ङ ट्होगो लमिंइ, म्हिसै प्रब्मैंए योउँइँले क्हिजी ङ जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","छतसि ओ याहवेह, अरू ह्रेंमैंए म्हाँजोर ङ क्हिए मिं थेब लब्मुँ, धै क्हिए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","खीजी ह्रोंसए म्रुँलाइ ट्होगों लमिंम्, धै खीजी त्हाँबै म्रुँ दाऊद नेरो चए सन्तानए फिर खोंयोंइ आनुबै म्हाँया लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। परमेश्‍वरए छ्याँबै बयन मुइ लमुँ, खीजी बनेबै मुसारामैंइ खीए केमैं उँइँमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","त्हिंइ ह्रोंसे चमैंइ ताँ सेम्; धै म्हुँइँस ह्रोंसे चमैंइ ज्ञानए ताँमैं उँइँमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","चमैंने ताँफुँमैं आरे, चमैंल क्युइ या आरे, चमैंए कै या आथे। ");
INSERT INTO gvr_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","दिलेया चमैंए कै ह्‍युल तिगोंन् कोनिइमुँ, चमैंइ पोंबै ताँमैं ताँन् ह्‍युलर फेनेइमुँ, खीजी त्हिंयाँ टिबै ल्हागिर मुर क्ल्‍ह्‍यो घ्रि लथेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","च त्हिंयाँ ब्ह्‍याए जग्‍यउँइँले पैरेसि त्होंइ खबै प्ह्रेंरो धों तब् मुँ, ट्होइ खबै म्हि सैं तोंब् धोंलेन् ह्रोंसए के लबर च सैं तोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","मुए छेउ घ्रिर च त्होंमुँ, धै स्युरदै अर्को छेउ समा फेनेम्। चए राबउँइँले तो सै या लोल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","याहवेहए ठिम खोट आरेब मुँ, च ठिमइ सैं सिब्मैंलाइ भों पिंम्। खीजी बिबै ताँमैं भर लल् खाँब मुँ, आह्र आसेब्मैंलाइ च ताँइ बुद्धि पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","याहवेहए ठिममैं ठिक मुँ, खीजी ल्हैदिबै के लइ बिस्याँ सैं तोंल् योंम्। याहवेहजी बिबै ताँमैं ठिक मुँ, च ताँमैंइ ङ्योए न्ह मि थोंमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","खीलाइ मान लद् बिबै ताँ छ्याँब मुँ, धै खोंयोंन् बिलै तरिब्मुँ। याहवेहए ठिमर्बै ताँमैं क्ह्रोंसेंन्बै मुँ, चु ताँमैं ठिक मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","मारा भन्दा याहवेहए ताँमैं म्हैल् त्हुब मुँ, छ्याँबै मारा भन्दा झन ल्हें खीए ताँ म्हैल् त्हुम्; खीए ताँ क्वे खुदु भन्दा खुदुब् मुँ, धै न्हाँज्युउँइँले तेयुबै खुदु भन्दा च बेल्‍ले लिंब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","चु ताँमैंउँइँलेन् क्हिए केब्छैंइ तो लल् त्हुम् बिसि सेमुँ, चु ताँमैंइ बिब् धों लस्याँ थेबै इनाम योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","ह्रोंसइ लबै गल्तिमैं खाबइ सेल् खाँम् रो? खाबज्यै सेल् आखाँ। छतसि ङइ था आसेल्‍ले लबै गल्तिमैं क्षमा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","क्हिए केब्छैंइ ह्रना-ह्रन् पाप केमैं लल् आपिंन्? च सैमैंइ ङलाइ पापर च्होवाल् आखाँरिगे, छ लस्याँ ङ क्हिए उँइँर छ्याब् आरेब तब्मुँ, धै थेबै अपराधउँइँले जोगेसि ङ दोष आरेब् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","ओ याहवेह, ङ लोबै पारा नेरो ङलाइ खामिंबै परमेश्‍वर, ङए सुँउँइँले त्होंबै ताँफुँमैं नेरो ङए सैंर मैंबै ताँमैं क्हिए उँइँर छ्याँब तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","क्वे प्रिंबै चिबए ल्हागिर - दाऊदए भजन घ्रि। ओ म्रुँ, दुःखए त्हेर ग्वार ह्रिमा याहवेहजी क्हि ल्होमिंरिगे, याकूबए परमेश्‍वरजी क्हिए रक्षा लमिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","खीजी ह्रोंसए पबित्र क्ल्‍ह्‍योउँइँले क्हिलाइ ल्होमिंरिगे, छले खीजी सियोनउँइँले क्हि ल्होमिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","क्हिइ पिंबै ताँन् भेटिमैं खीजी मैंरिगे, धै क्हिइ ख्रोंइ पिंबै ख्रोमैं म्रोंसि खी सैं तोंरिगे। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","क्हिए सैंर मैंबै ताँमैं खीजी योमिंरिगे, धै क्हिइ लल् म्हैबै ताँन् केमैंर आशिक पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","क्हिजी ट्‍होमा ङि सैं तोंदै क्हिए जय-जय लब्मुँ, धै ङिए परमेश्‍वरए मिं क्वेदै ङि ह्रोंसए झन्डा क्वेब्मुँ। याहवेहजी क्हिइ ह्रिबै तोन्दोंरि सैमैं पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","याहवेहजी ह्रोंसजी त्हाँबै म्हिलाइ ल्होमिंमुँ। खीजी खीए पबित्र स्‍वर्गउँइँले ह्रोंसए क्योलो योर मुँबै जोगेमिंबै भोंउँइँले, ह्रोंसइ त्हाँबै म्हि जोगेमिंब्मुँ बिसि ङइ तोगो सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","कोइइ रथमैंए फिर, कोइइ घोडामैंए फिर भर लम्, दिलेया ङिम् ङिए याहवेह परमेश्‍वरए मिंर्न भर लम्। ");
INSERT INTO gvr_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","चमैं क्र कुरसि क्हुरयाम्, दिलेया ङिम् आक्हुरल्‍ले राम्। ");
INSERT INTO gvr_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","ओ याहवेह, म्रुँलाइ ट्होगों लमिंन्, धै ङिइ ग्वार ह्रिमा ङिलाज्यै ल्होमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। ओ याहवेह, क्हिजी शक्‍ति पिंबइले म्रुँ सैं तोंइमुँ। धै क्हिजी ट्होगों लमिंबइले खी बेल्‍ले सैं तोंसि उफर्दिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","क्हिजी म्रुँए सैंर मैंब् धों लमिंइमुँ, धै खीजी यो छ्युँ लसि ग्वार ह्रिमा क्हिजी थेमिंइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","छ्याँ-छ्याँबै सैमैं पुयुसि क्हि चने त्होबर युइ, धै छ्याँबै माराए मुकुट चए क्रर कुमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","चइ क्हिने छ्ह ह्रिमा क्हिजी चलाइ खोंयोंइ आखाँबै छ्ह पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","क्हिजी ट्होंगों लमिंबइले खीए मिं थेब तइमुँ, क्हिजी चए मिं थेब् लसि म्रुँमैंइ योंब् धों तबै मान पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","क्ह्रोंसेंन्ले क्हिजी चलाइ खोंयोंइ आखाँबै आशिक पिंइमुँ, धै क्हि चने तमिंबइले चए सैं खोंयोंन् बिलै तोंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","तलेबिस्याँ म्रुँइ याहवेहए फिर भर थेंम्, ताँन् भन्दा थेबै परमेश्‍वरए खोंयोंइ आनुबै म्हाँया चए फिर मुँबइले च खोंयोंइ ङ्हिंल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","क्हिए योजी ह्रोंसए ताँन् शत्तुरमैं म्हैसि पखब्मुँ, धै क्हिए शत्तुरमैं ताँन् क्हिए क्योलो योजी क्हाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","क्हि युबै त्हेर क्हिजी चमैं लुँरिबै मिर भ्योंवाब्मुँ, याहवेहजी ह्रोंसए ह्रिसर चमैं क्ल्ह्‍योंवाब्मुँ, धै मिइ चमैं ख्रोंवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","क्हिजी पृथ्‍बीर चमैंए सन्तानमैं घ्रि या आचैल् लवाब्मुँ, धै चमैंए खलकमैं म्हिमैंए म्हाँजोउँइँले नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","चमैंइ क्हिए बिरोधर आछ्याँबै ताँमैं मैंलेया, धै ङो चुसि क्हिए न्होह्रों लल् म्हैले या चमैंए सैंर मैंब् धों तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","क्हिजी त्हलेर मे थेंसि चमैं ल्हिमा चमैं लिग्याँ तोसि न्हेयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","ओ याहवेह, ह्रोंसए थेबै भोंर क्हि ताँन् भन्दा थेब् तद्! क्हिए भोंजी लबै थेबै केए क्वे प्रिंदै ङि क्हिए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर, “त्हिंयाँ प्योबै त्हेर्बै फो आमा” बिबै भाकार प्रिंल् त्हुबै दाऊदए भजन घ्रि। ओ ङए परमेश्‍वर, ओ ङए परमेश्‍वर, क्हिजी ङ तले पिवाल? सैं आतोंसि क्रोसेया ङ आजोगेमिंल्‍ले क्हि तले ङ ङाँइँले ह्रेंगो तल? ");
INSERT INTO gvr_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","ओ ङए परमेश्‍वर, ङइ त्हिंइ ह्रोंसे क्हिए मिंन् किंइमुँ, म्हुँइँस ह्रोंसे या क्हिनेन् ग्वार ह्रिइमुँ छान् ललेया ङ छिं आङ्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","दिलेया क्हि पबित्र परमेश्‍वर राजगद्दिर टिम्, इस्राएलीमैंइ क्हिए मिं क्वेम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","ङिए खेमैं माँमैंइ क्हिए फिर्न भर लमल, चमैंइ क्हिए फिर भर लबइले क्हिजी चमैं जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","चमैंइ ओरदै क्हिनेन् ग्वार ह्रिइ, छतसि चमैं सोइ। चमैंइ क्हिए फिर्न भर लबइले चमैं फा पिल् आत्हुल। ");
INSERT INTO gvr_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","दिलेया ङ प्हुँलुँ धोंन् तब् मुँ, म्हि आङिं बिसि म्हिमैंइ ङलाइ तोइ धोंइ आङ्हाँ, धै ङलाइ प्ह्रइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","ङलाइ म्रोंब्मैं ताँनइ ङउँइँ ङ्‍ह्‍योसि म्हदे म्‍लिंसि छ बिदै खरि च्यारम्: ");
INSERT INTO gvr_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“याहवेहजीन् जोगेमिंम् बिसि खीए फिर्न चइ भर लम्। च म्रोंसि याहवेह सैं तोंम्, छतसि खीजीन् चलाइ जोगेमिंरिगे,” बिसि चमैंइ ङलाइ प्ह्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","चमैंइ तोन् बिलेया आमाए फोउँइँले ङलाइ तेब क्हिन् ग। आमाए क्ह्‍वेंउँइँलेन् क्हिजी ङलाइ क्हिए फिर भर लब लोमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","फिबै त्हे ओंनोंन् ङ क्हिलन् ग, आमाए फोर मुँब् ओंनोंबै ङए परमेश्‍वर क्हिन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","ङ ङाँइले ह्रेंगो आतमिंन्, तलेबिस्याँ ङए न्होह्रों लल् म्हैब्मैं ल्हें मुँ, ङलाइ ल्होमिंब खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","साँढे धोंले भोंबै शत्तुरमैंइ ङ घेर्दिइमुँ, बाशान ह्‍युलर्बै भोंबै साँढेमैं धों तबै शत्तुरमैं ङए कारग्युले मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","फो ख्रेंसि ङ्‍हेदै ह्‍वाखबै सिंहमैं धोंले ङए न्होह्रों लबै ल्हागिर चमैंइ सुँ आँ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","क्यु ङेयाब् धोंले ङए भों नुयाइमुँ, ङए ह्रिबए जोर्निमैं ताँन् प्ल्ह्‍याइमुँ। ङए खों युलुयाबै मम् बत्ति धोंन् तयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","भों नुयासि ङ तियाबै पु धोंन् तयाइमुँ, ङए ले ताइ ह्रेंयाइमुँ, सियारिगे बिसि क्हिजी ङ त्हुलर भ्योंथेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","दुष्‍ट म्हिमैं ङए कारग्युले मुँ, नगिमैंइ धोंले चमैंइ ङ घेर्दिइमुँ, चमैंइ ङए यो प्हलेमैंर खुँ थोंवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","ङए ताँन् ह्रिबमैं ङइ च्योल् खाँम्, म्हिमैंइ आछ्याँबै सैंले ङ ङाँइ ङ्ह्‍योबै ङ्‍ह्‍योबन् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","चिट्टा झोंसि चमैंइ ङए क्वें खें-खेंमैंए न्होंर चुम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","दिलेया ओ याहवेह, ङ ङाँइले क्हि ह्रेंगो आतमिंन्! ओ ङए भों, युनन् ङलाइ ग्वार पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","सेलाँउँइँले ङ जोगेमिंन्, चु नगिमैंउँइँले ङ सिल् आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","चेंमैंए सुँउँइँले ङ फ्रेमिंन्, धै क्ह्‍योंर्बै साँढेए रुउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","ङए अलिमैंए उँइँर क्हिजी लबै छ्याँबै केमैंए बयन लदै ङ क्हिए मिं थेब लब्मुँ। ल्हें म्हि च्होंबै क्ल्ह्‍योरै या ङ क्हिलाइन थेब् लब्मुँ ");
INSERT INTO gvr_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","ओ याहवेहलाइ मान लब्मैं, खीलाइन थेब् लद्! ओ याकूबए ताँन् सन्तानमैं, खीए मिं क्वेद्! ओ इस्राएलए ताँन् सन्तानमैं, खीने ङ्हिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","तलेबिस्याँ आगुइ ह्रुगुदिसि दुःख योंबै म्हिलाइ खीजी ल्होमिंम्, हेलै या आल, खीजी ह्रोंसए मोंडा छाबै म्हिमैंउँइँले आलो, चइ ल्होमिन् बिसि ग्वार ह्रिमा खीजी थेम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","ल्हें म्हि च्होंबै क्ल्ह्‍योर ङए छ्याँबै बयन तल् पिंब क्हिन् ग, छतसि क्हिलाइ मान लब्मैंए उँइँर बाछा फैसि लम् बिबै के ङइ पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","ङ्हाँदुमैं चसि म्रेंब्मुँ, याहवेह म्हैब्मैंइ खीलाइन थेब् लब्मुँ। धै चमैं खोंयोंन् बिलै सोरिल् योंब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","ह्‍युलर मुँबै ताँन् ह्रेंमैंइ क्हिलाइन मैंब्मुँ धै क्हि ङाँइँन तोखब्मुँ। ह्रें-ह्रेंर्बै म्हिमैं ताँनइ क्हिलाइन फ्योब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","तलेबिस्याँ ताँन् ह्रेंमैंए म्रुँ क्हिन् ग, क्हिजीन् खन्तोंदोंन् ग्याल्स लम्। ");
INSERT INTO gvr_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","ह्‍युलर्बै ताँन् प्लो प्लोब्मैंइ भोज चदै सैं तोंदै क्हिए मिं क्वेब्मुँ। ह्रोंसलाइ जोगेल् आखाँब्मैं सर्न कोंनेल् त्हुब्मुँ, चमैं ताँनइ क्हिए उँइँर्न च्हि तुँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","लिउँइँ खबै सन्तानइ खीए के लब्मुँ, लिउँइँ खबै पुस्तमैंने या चमैंइ याहवेहए बारेर बिमिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","तिंयाँ समा आफिबै म्हिमैंलाज्यै या चमैंइ खीजी लबै ठिक केमैंए बारेर बिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","दाऊदए भजन घ्रि याहवेह ङए प्ह्रोंछैं ग, ङने तोइ खाँचो तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","खीजी ङ पिंग्या छि मुँबै क्‍ल्‍ह्‍योर टिल् पिंमुँ, क्यु पिसि हार-हार तब सल् लबै क्यु ङाँर खीजी ङलाइ डोरेसि बोम्। ");
INSERT INTO gvr_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","खीजी ङ धबै सोगों लमिंमुँ। ङइ खीए मिं थेब लरिगे बिसि खीजी ङ ठिक घ्याँर डोरेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","मिछु खैबै खोल्सर प्रल् त्हुलेया ङ तो सैने या ङ्हिंरिब् आरे, तलेबिस्याँ क्हि ङने बालु मुँ; क्हिए तुँबै प्हरे नेरो ह्‍वाबै प्हरेइ ङए रक्षा लम्। ");
INSERT INTO gvr_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","ङए शत्तुरमैंए उँइँर, क्हिजी ङए ल्हागिर चब् थुँब तयार लमिंमुँ। क्हिजी ङलाइ प्ह्रेंमैं धोंले मान लइमुँ, धै ङए प्हेल आप्लिंन् समा क्हिजी झोंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","क्ह्रोंसेंन्ले क्हिए खोंयोंइ आनुबै म्हाँया नेरो आशिक ङए छ्ह तिगोंन् ङने प्रे तरिब्मुँ, धै ङ खोंयोंन् बिलै याहवेहए धिंर टिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","दाऊदए भजन घ्रि पृथ्‍बी नेरो चर मुँबै तोन्दोंरि सैमैं याहवेहलन् ग, ह्‍युल नेरो चर टिब्मैं ताँन् खीलन् ग, ");
INSERT INTO gvr_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","तलेबिस्याँ खीजी पृथ्‍बी मा ङ्युँए फिर थेंइमुँ, धै पृथ्‍बीए जग गैरु क्युए फिर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","याहवेए कोंर खाब् क्रेल् खाँमुँ? धै खीए पबित्र क्‍ल्‍ह्‍योर खाब् राल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","आछ्याँबै केमैं आलब्मैं, छ्याँबै सैं प्ह्‍याब्मैं, कु ङाँइ सैं आल्हैदिब्मैं धै स्योलिबै ताँर कसम आचब्मैंन्, याहवेहए कोंर क्रेल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","छाबै म्हिमैंइन याहवेह ङाँइँले आशिक योंब्मुँ, धै चमैंलाइ जोगेमिंबै परमेश्‍वरजी चमैंलाइ ठिक ठर्दिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","खीलाइ म्हैबै म्हिमैं छाबन् तम्, चमैंइ याकूबए परमेश्‍वरने त्होबै सैं लम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","ओ मुल् म्रामैं, मान लल् त्हुबै म्रुँ होंरिगे बिसि क्हेमैंए क्र कैंडो लद्! ओ स्योंम्बै म्रामैं, नुब् तद्! ");
INSERT INTO gvr_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","मान लल् त्हुबै म्रुँ खाब् जा? याहवेहन् ग! खी भोंब नेरो शक्‍ति मुँब मुँ, याहवेहजीन् ल्हडें ट्होम्। ");
INSERT INTO gvr_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","ओ मुल् म्रामैं, मान लल् त्हुबै म्रुँ होंरिगे बिसि क्हेमैंए क्र कैंडो लद्! ओ स्योंम्बै म्रामैं, नुब तद्! ");
INSERT INTO gvr_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","मान लल् त्हुबै म्रुँ खाब् जा? स्वर्गर्बै सेनामैंए चिब याहवेहन् ग! खीन् मान लल् त्हुबै म्रुँ ग। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","दाऊदए भजन घ्रि। ओ याहवेह, ङए सैं क्हि ङाँइँन लमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","ओ ङए परमेश्‍वर, ङइ क्हिए फिर्न भर लइमुँ, ङलाइ फा पिन् आलमिंन्, ङए शत्तुरमैं ङए फिर ट्होगों तल् आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","क्हिए फिर भर थेंब्मैं खाबै या खोंयोंइ फा पिल् त्हुरिब् आरे, दिलेया फाकर्न धोका पिंब्मैं फा पिल् त्हुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","ओ याहवेह, ङलाइ क्हिए घ्याँ तेंमिंन्, क्हिए घ्याँर प्रबर ङलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","क्हिए क्ह्रोंसेंन्बै घ्याँर प्रबर ङलाइ लोमिंन्, तलेबिस्याँ ङलाइ जोगेमिंबै परमेश्‍वर क्हिन् ग; धै ङइ त्हिंतिमिंन् क्हिए फिर्न आशा लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","ओ याहवेह, स्योंम् ओंनोंन् ङए फिर मुँबै क्हिए थेबै दयाम्हाँया मैंमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","ओ याहवेह, ङए फ्रेंसिर्बै पापमैं नेरो ङइ लबै आछ्याँबै केमैं आमैंमिंन्; क्हि खोंयोंन् बिलै म्हाँया लबै परमेश्‍वर ग, छतसि ङलाइ आम्‍लेमिंन्, तलेबिस्याँ क्हिए सैं छ्याँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","याहवेहजी ठिक निसाफ लमुँ, खी स्वाब मुँ, छतसि खीजी पापिमैंलाज्यै या ठिक घ्याँर प्रबर लोमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","खीजी थेब् आप्हैंब्मैंलाइ ठिक घ्याँर डोरेमिंब्मुँ, धै चमैंलाइ खीए घ्याँर प्रबर लोमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","खीजी फैबै बाछाए ताँमैं ङिंब्मैंलाइ याहवेहजी खोंयोंइ आनुबै म्हाँया लसि भर पर्दिल् खाँन्ले डोरेम्। ");
INSERT INTO gvr_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","ओ याहवेह, ङइ आछ्याँबै केमैं ल्हें लइ। ङलाइ क्षमा पिंन्, तलेबिस्याँ क्हि क्षमा पिंबै परमेश्‍वर ग। ");
INSERT INTO gvr_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","याहवेहलाइ मान लब्मैंइ खेंमैं खैले प्रल् त्हुम् बिबै ताँ खीउँइँलेन् लोल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","चइ सुखर त्हिंइमैं थोब्मुँ, धै चए सन्तानमैं ह्‍युलए फिर क्ल्हे तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","याहवेहलाइ मान लब्मैंने बालु खी बेल्‍ले क्ह्रिबै थु तम्, धै खीजी फैबै बाछाए ताँमैं चमैंलाइ सेल् पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","ङए मिइ खोंयोंन् बिलै याहवेह ङाँइँन ङ्‍ह्‍योरिमुँ, तलेबिस्याँ खीजीन् ङए प्हलेमैं ङोउँइँले जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","ङ ङाँइ तोमिंन् धै ङए फिर दयाम्हाँया लमिंन्, तलेबिस्याँ ङ घ्रिन् मुँ धै ङए फिर दुःख तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","ङए सैंर्बै दुःखमैं ल्हें ततै ह्‍याइमुँ; क्हिजीन् चु दुःखउँइँले ङ फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","ङए दुःख नेरो पिरमैं क्हिजी बिचार लमिंन्, धै ङए ताँन् पापमैं क्षमा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","ङ्ह्‍योत्ति, ङए शत्तुरमैं कति ल्हें मुँ, चमैंइ ङलाइ बेल्‍ले हेल् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","ङए रक्षा लमिंन् धै ङलाइ जोगेमिंन्! ङ फा फिल् आत्हुरिगे, तलेबिस्याँ ङ क्हिए प्हलेर ग्वार योंबर खइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","ङइ स्योर आतेइमुँ, ङइ लबै छ्याँब आछ्याँबै केमैं ताँन् ङइ क्हिनेन् बिइमुँ। छतसि ङलाइ जोगेमिंन्, तलेबिस्याँ ङइ क्हिए फिर्न आशा थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","ओ परमेश्‍वर, क्हिजी त्हाँबै इस्राएललाइ दुःखउँइँले फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","दाऊदए भजन ओ याहवेह, ङने तोइ छ्याब् आरे बिसि उँइँमिंन्, तलेबिस्याँ ङइ छ्याब् खबै केमैं आलइमुँ, धै ङइ तिफुँइ छाइ-छुइ आतल्‍ले क्हिए फिर्न भर लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","ओ याहवेह, ङलाइ जाँचेद्, ङ खैबै म्हि जा बिसि बिचार लमिंन्; ङए सैं नेरो खों जाँचेद्। ");
INSERT INTO gvr_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","तलेबिस्याँ क्हिजी लबै खोंयोंइ आनुबै म्हाँया ङइ झलझलले मैंरिमुँ, धै क्हिए भर लल् खाँबै घ्याँर ङ प्ररिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","ङ स्योर तेब्मैंने बालु आटि, धै छलु म्हिलु लब्मैंने या आप्र। ");
INSERT INTO gvr_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","आछ्याँबै के लब्मैं म्रोंसि ङ छेरम्, धै दुष्‍ट म्हिमैंने ङ आटि। ");
INSERT INTO gvr_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","ओ याहवेह, ङए योइ छ्याब् खबै केमैं तोइ आलइमुँ; छतसि क्हिए मिंर ख्रो पिंबै क्ल्ह्‍योर क्हिए मिं क्वेदै ङ प्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","थेबै कै तेसि धन्यबादए क्वे प्रिंदै क्हिजी लबै औदिबै केमैंए बयन ङइ लप्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","ओ याहवेह, क्हि टिबै धिं, क्हिए चारबै ह्‍वे मुँबै क्‍ल्‍ह्‍योलाइ ङइ म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","पापिमैंने बालुन् ङलाइ नास आलद्, धै म्हि सैमैंने ङलाइ बालु आलमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","चमैंए योइ आछ्याँबै केमैं लम्, धै चमैंए क्योलो योइ खोंयोंन् बिलै ख्याब किंम्। ");
INSERT INTO gvr_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","दिलेया ङइमि छ्याब् आखबै छ्ह थोइमुँ; छतसि ङलाइ जोगेमिंन्, ङए फिर दयाम्हाँया लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","ङ सोजो घ्याँर प्रइमुँ ङइ ल्हें म्हिए म्हाँजोर क्हिए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","दाऊदए भजन याहवेह ङए चारबै ह्‍वे नेरो ङए मुक्‍ति ग! ङ खाब्ने ङ्हिंब? याहवेहन् ङए रक्षा लबै किल्‍ला ग। छतसि ङ खाब् म्रोंसि ङ्हिंब? ");
INSERT INTO gvr_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","ङए शत्तुरमैं नेरो बिरोधीमैं दुष्‍ट म्हिमैं ग! चमैं ङए से चबर ङए बिरोधर रामा चमैंए प्हले थुरियासि क्हुरह्‍याम्। ");
INSERT INTO gvr_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","सेनामैं ङए बिरोधर कारग्यु तखलेया, ङए सैं ङ्हिंरिब् आरे। ङए बिरोधर लडें तलेया ङ परमेश्‍वरए फिर भर थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","ङइ याहवेहने ताँ घ्रि ह्रिइमुँ, ङइ म्हैबै ताँ चुन् ग: खी टिबै क्ल्ह‍योर ङइ खीलाइ म्हैल् खाँरिगे, ङए छ्ह तिगोंन् याहवेहए धिंर टिल् योंरिगे, धै खीए छ्याँबै केमैं ङ्ह्‍योल् योंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","तलेबिस्याँ दुःख तमा खीजी खी टिबै क्‍ल्‍ह्‍योर ङलाइ जोगेसि थेंमिंब्मुँ, खीए पबित्र तम्बु न्होंर खीजी ङ लोसि थेंमिंब्मुँ, धै थेबै पाराए फिर खीजी ङ नुल्‍ले थेंमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","झाइले ङए कारग्यु तखबै शत्तुरमैंए फिर खीजी ङए क्र कैंडो लमिंब्मुँ, छतसि खीए पबित्र तम्बुर ङ सैं तोंदै ओरादै ख्रो पिंखब्मुँ; धै भजन प्रिंदै याहवेहए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","ओ याहवेह, ङइ थेबै कै तेसि ग्वार ह्रिमा क्हिजी थेमिंन्; ङए फिर दयाम्हाँया लमिंन् धै ङलाइ ज्वाफ पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","“क्हेमैंइ ङए मोंड म्हैद्!” बिसि क्हिजी बिइ। छतसि ङए सैंइ क्हिने बिइ, “ओ याहवेह, क्हिए मोंड ङ म्हैब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","ओ ङए मुक्‍ति पिंबै परमेश्‍वर! क्हिए मोंड ङ ङाँइँले आलोमिंन्, ह्रिस खमा क्हिए के लबै म्हिलाइ आस्योमिंन्। ङलाइ जोगेमिंबै परमेश्‍वर क्हि ग। छतसि ङलाइ आपिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","ङए आबा-आमाइ ङलाइ वाथेंलेया याहवेहजी ङलाइ समल्दिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","ओ याहवेह, क्हिए छ्याँबै घ्याँर प्रबर ङलाइ लोमिंन्। ङए शत्तुरमैं ल्हें मुँ, छतसि क्हिए छ्याँबै घ्याँर डोरेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","शत्तुरमैंए योर ङलाइ आपिंमिंन्; तलेबिस्याँ ङए बिरोधर स्योर ताँ पोंब्मैं रेइमुँ, चमैं सैब् म्‍लोब् लब् बिसि प्रइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","सोगोंमैंए ह्‍युलर ङ याहवेहए छ्याँबै केमैं म्रोंब्मुँ बिब ङलाइ अझै बिश्‍वास मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","याहवेहए घ्याँ ङ्‍ह्‍योरिद्; सैं च्योंब आलद्, खीजी क्हिए सैं भोंब् लमिंब्मुँ; छतसि ङ बिमुँ! याहवेहए घ्याँ ङ्‍ह्‍योरिद्। ");
INSERT INTO gvr_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","दाऊदए भजन ओ याहवेह, ङ लोबै पारा, क्हिनेन् ङ ग्वार ह्रिमुँ, ङइ ग्वार ह्रिमा आथेब् धों आलमिंन्, क्हिजी ङए ताँ आथेमिंस्याँ, सिसि क्रोंर ह्‍याब्मैं धों ङ तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","ल्होमिंन् बिसि क्हिनेन् ग्वार ह्रिमुँ, धै क्हिए ताँन् भन्दा पबित्र क्‍ल्‍ह्‍योउँइँ ङ ह्रोंसए यो क्वेमुँ, छतसि ङए ताँमैं थेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","दुष्‍ट म्हिमैं नेरो आछ्याँबै के लब्मैंने बालु ङलाइ दण्ड आपिंन्! चमैंइ ह्रोंसए ङ्‍हेब्मैंने बालु छ्याँबै ताँ लम्, दिलेया चमैंए खोंर बिस्याँ आछ्याँबै ताँ मैंम्। ");
INSERT INTO gvr_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","चमैंइ लबै आछ्याँबै केमैं नेरो चमैंए योइ लबै केमैं ङ्ह्‍योसि योंल् त्हुबै दण्ड चमैंलाइ पिंन्; चमैंए योइ खैबै के लइमुँ छाबन् दण्ड चमैंलाइ पिंन्, चमैंइ योंल् तुबै दण्ड चमैंलाइ पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","याहवेहजी लबै केमैं नेरो खीए योजी लबै केमैं चमैंइ वास्ता आल, छतसि खीजी चमैंलाइ नास लवाब्मुँ, खोंयोंइ चमैंलाइ बनेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","याहवेहए मिं थेब् तरिगे! तलेबिस्याँ ल्हयो खमिंन् बिबै प्राथना लमा खीजी थेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","याहवेह ङए शक्‍ति नेरो ङए ढाल ग! ङइ खीनेन् सैं केइमुँ, धै खीजीन् ङ ल्होमिंबइले ङए सैं बेल्‍ले तोंइमुँ, धै ङ भजन प्रिंसि खीलाइ धन्यबाद पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","याहवेहजी खीए म्हिमैंलाइ भों पिंम्, धै खीजी त्हाँबै म्रुँ जोगेसि रक्षा लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","क्हिए म्हिमैं जोगेमिंन्, धै ह्रोंसजी त्हाँबै म्हिमैंलाइ आशिक पिंन्! चमैंए प्ह्रोंछैं तमिंनु, धै खोंयोंन् बिलै चमैंए वास्ता लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","दाऊदए भजन घ्रि। ओ थेबै शक्ति मुँबै परमेश्‍वरए दूतमैं, याहवेहए मिं क्वेद्! खी बेल्‍ले थेब मुँ बिसि खीए भोंए बयन लद्। ");
INSERT INTO gvr_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","याहवेहए मिं क्वेसि खीलाइ लल् त्हुबै मान लद्, खी धोंलेन् पबित्र तसि खीए मिं क्वेद्। ");
INSERT INTO gvr_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","याहवेहए कै मा ङ्युँइ फिर थेल् खाँम्, मान पिंल् त्हुबै परमेश्‍वर बेल्‍ले ओरम्, याहवेह थेबै कैले मा ङ्युँइए फि-फि ओरम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","याहवेहजी पोंबै ताँर शक्‍ति मुँ, याहवेहए कै बेल्‍ले भोंब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","याहवेहए कैजी थे-थेबै देबदारुए धुँमैं या चोवाम्; लेबनानए कोंर्बै देबदारुए धुँमैं याहवेहजी कुदु-कुदु लवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","खीजी लेबनानर्बै कोंमैं मे झज धोंलेन् उफर्दिमिंम्, धै सिरिओन बिबै कों क्‍ह्‍योंर्बै साँडे धोंले उफर्दिमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","काम्‍लि-तिम्‍लिने युबै चड्कनेइ धोंलेन् याहवेहए कैजी ल्हिम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","याहवेहए कैजी क्यु आयोंबै क्‍ल्‍ह्‍यो लाम्, याहवेहजी कादेश बिबै क्यु आयोंबै क्‍ल्‍ह्‍यो लाम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","याहवेहए कैइ चाँफए धुँमैं ख्योदे लवाम्, क्ह्‍यों तोइ आचैन् लवाम्, छतसि “परमेश्‍वर बेल्‍ले थेब मुँ!” बिदै खीए मन्दिरर ताँन् म्हिमैं ओरम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","याहवेह नाँ बाढिए फिर टिम्, याहवेह खोंयोंन् बिलै म्रुँ धोंले राजगद्दिर टिम्। ");
INSERT INTO gvr_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","तोंन् तलेया याहवेहजी ह्रोंसए म्हिमैंए सैं ढुक्‍का लमिंम्। तलेबिस्याँ याहवेहजी ह्रोंसए म्हिमैंलाइ भों पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","परमेश्‍वरए योर मन्दिर सुम्पिदिमा चु क्वे प्रिंन्। दाऊदए भजन घ्रि। ओ याहवेह, क्हिजी ङ गैरुउँइँले कैंडो तेमिंइ, धै ङ म्रोंसि ङए शत्तुरमैं निस्योल् आपिंइमुँ, छतसि ङ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","ओ ङए याहवेह परमेश्‍वर, ङ नमा ङइ क्हिने ल्होमिंन् बिसि ग्वार ह्रिइ, धै क्हिजी ङ सल् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","ओ याहवेह, क्हिजी ङए सोलाइ क्रोंउँइँले तेमिंइ, धै सिसि क्रोंर ह्‍याब्मैंउँइँले ङलाइ जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","ओ याहवेहए म्हिमैं, खीए ल्हागिर भजन प्रिंन्, धै खीए पबित्र मिंर धन्यबाद पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","तलेबिस्याँ खी तिस्याँदे मत्‍त्रे ह्रिस खम्, दिलेया ङ्योए छ्ह तिगोंन् खीजी ल्हयो खरिम्। म्हुँइँस् तिमिंन् मिग्लि युलेया न्हाँगर बिस्याँ सैं तोंल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","ताँन् सै ठिक तबै त्हेरि ङइ बिइ, “ङ खोंयोंइ ङ्हिंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","ओ याहवेह, क्हिजी ङ ल्होमिंसि ङलाइ नुबै कोंर बोसि थेंमिंइ, दिलेया क्हिजी ह्रोंसए मोंडा लोवामा ङए सैं नइ। ");
INSERT INTO gvr_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","ओ याहवेह, ङइ क्हिनेन् ग्वार हिइमुँ। ल्होमिंन् बिसि ङइ क्हिनेन् ग्वार ह्रिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“ङ सियास्याँ क्हिलाइ तो फायदा तमुँ? ङ क्रोंर ह्‍यामा क्हिलाइ तो फायदा तमुँ? स त्हुलइ क्हिलाइ थेब् लम् रो वा? क्हि भर लल् खाँबै परमेश्‍वर ग बिसि स त्हुलइ क्हिए बयन लम् रो वा? ");
INSERT INTO gvr_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","ओ याहवेह ङए ताँ थेमिंनु, ङए फिर ल्हयो खमिंनु! ओ याहवेह, ङलाइ ल्होमिंन्।” ");
INSERT INTO gvr_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","ङ क्रोरिमा क्हिजी ङ सैं तोंल् लमिंइ; क्हिजी ङए नइँए ह्रेंग प्लिमिंसि खाँसों ङ्हाँबै क्वें खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","छतसि ङ तोइ आबिल्‍ले टिरिब् आरे, ङ क्हिलाइन थेब् लबै क्वेमैं प्रिंमुँ। ओ ङए याहवेह पारमेश्‍वर, ङ खोंयोंन् बिलै क्हिलाइन धन्यबाद पिंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। ओ याहवेह, ङ खोंयोंइ फा पिल् आत्हुरिगे बिसि ङ क्हिए प्हलेर ग्वार योंबर खइमुँ। क्हि ठिक के लबै परमेश्‍वर ग। छतसि ङलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","ङइ ग्वार ह्रिमा न्ह तोमिंनु; युनन् ङ जोगेमिंनु! क्हि ङए रक्षा लबै पारा तमिंन्, ङलाइ जोगेबै भोंबै किल्‍ला तमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","ङ लोबै पारा नेरो ङए किल्‍ला क्हिन् ग; छतसि क्हिए मिं कैंडों तबै ल्हागिर ङलाइ डोरेसि ङ प्रल् त्हुबै घ्याँ उँइँमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","क्हि ङए ग्वार योंबै क्‍ल्‍ह्‍यो ग। ङए ल्हागिर चुबै ङोउँइँले ङ जोगेमिंन्, ");
INSERT INTO gvr_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","ङए छ्ह क्हिए योर्न पिंमुँ; ओ क्ह्रोंसेंन्बै याहवेह परमेश्‍वर, ङलाइ दु:खउँइँले फ्रेमिंबमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","स्योलिबै कु पूजा लब्मैं ङइ आखो; ङ बिस्याँ याहवेहए फिर्न भर लम्। ");
INSERT INTO gvr_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","क्हिए खोंयोंइ आनुबै म्हाँयाजी ङ छिं ङ्हाँल् योंइमुँ, छतसि ङ बेल्‍ले सैं तोंब्मुँ, तलेबिस्याँ क्हिजी ङए दुःख म्रोंइमुँ, ङए सैंर्बै दुःख क्हिजी सेइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","क्हिजी ङलाइ शत्तुरए योर फेल् आपिंइमुँ, धै क्हिजी ङए प्हले प्ल्हाबै क्‍ल्‍ह्‍योर थेंमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","ओ याहवेह, ङए फिर दयाम्हाँया लमिंन्, तलेबिस्याँ ङ थेबै दुःखर फेइमुँ, शोकइ लमा ङए मि आचारइमुँ, धै ङए सैं च्योंयाइमुँ, ङए ज्यु या कारयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","तलेबिस्याँ ङए छ्ह दुःखर, नेरो ङए त्हिंइमैं शोकर थोइमुँ, ङइ लबै आछ्याँबै केमैंइ लमा ङए भों नुयाइमुँ, धै ङए ह्रिब्मैं या ङ्युयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","ङए शत्तुरमैंइ लमा ङए ङ्‍हेब्मैंए उँइँर ङ म्हि आच्हिन् तइमुँ, धै ङए थुमैं ङ म्रोंसिन् ङ्हिंइमुँ। घ्याँजरे ङलाइ म्रोंब्मैं ङउँइँले भौदियाम्। ");
INSERT INTO gvr_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","सियाबै म्हिलाइ म्‍लेब् धोंले ताँनइ ङ म्‍लेयाइमुँ; ङ फतियाबै भाडो धोंन् तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","ल्हें म्हिइ ङए बिरोधर आछ्याँबै ताँ पोंब ङइ थेइमुँ, छतसि ङ खन्तोदोंउँइँलेन् ङ्हिंल् त्हुइमुँ! चमैं क्ह्रिसि ङए बिरोधर मत लम्; धै ङलाइ सैबै जाल रोम्। ");
INSERT INTO gvr_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","दिलेया ओ याहवेह, ङइ क्हिए फिर्न भर लइमुँ; ङइ बिमुँ: “क्हिन् ङए परमेश्‍वर ग।” ");
INSERT INTO gvr_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","ङए छ्ह क्हिए योर्न मुँ; ङए शत्तुरमैं नेरो ङलाइ ह्रुगुदिब्मैंए योउँइँले ङ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","क्हिए लि ह्रोंसए के लबै म्हिए फिर चारमिंन्; खोंयोंइ आनुबै क्हिए म्हाँयाजी ङलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","ओ याहवेह, ङ फापिल् आत्हुरिगे, तलेबिस्याँ ङइ क्हिने ग्वार ह्रिइमुँ; दिलेया दुष्‍टमैं बिस्याँ फा पिन् तयारिगे; धै चमैं क्रोंर च्याँले टिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","स्योर ताँ पोंबै चमैंए म्हदेमैं म्रुयारिगे, तलेबिस्याँ चमैंइ थेब् प्हैंदै ठिक के लब्मैंए बिरोधर म्हि आच्हिल्‍ले पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","क्हिलाइ मान लब्मैंए ल्हागिर क्हिजी साँथेंबै छ्याँबै सैमैं कति थेब मुँ! क्हिए प्हलेर्न ग्वार योंब्मैंलाइ क्हिजी च छ्याँबै सैमैं पिंब ताँन् म्हिमैंइ म्रोंइमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","क्हि टिबै रक्षा योंबै क्‍ल्‍ह्‍योर क्हिजी म्हिमैंए जालउँइँले चमैंलाइ लोसि थेंमिंमुँ। चमैंलाइ छ्याब् ल्हैदिबै लेमैंउँइँले क्हिजी चमैं ह्रोंस टिबै क्‍ल्‍ह्‍योर जोगेसि थेंमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","याहवेहए मिं थेब् तरिगे, तलेबिस्याँ शत्तुरमैंइ घेर्दिबै सहर न्होंर ङ मुँमा खीजी खोंयोंइ आनुबै म्हाँया ङए फिर उँइँमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","ङ्हिंबै त्हेर ङइ बिइ, “क्हि ङाँइँले ङ ह्रेंगो तइमुँ।” दिलेया ल्होमिंन् बिसि क्हिने ग्वार ह्रिमा क्हिजी ङए ताँ थेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","ओ खीए ताँन् म्हिमैं, याहवेहलाइ म्हाँया लद्! खीए फिर बिश्‍वास लब्मैंलाइ याहवेहजी रक्षा लम्, दिलेया थेब् प्हैंब्मैंलाइ बिस्याँ खीजी पिंल् त्हुबै दण्ड पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","ओ याहवेहए फिर आशा थेंब्मैं, भोंसि तद्, क्हेमैंए सैं भोंब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","दाऊदए मस्किल बिबै भजन घ्रि पापए क्षमा योंसि पाप त्होयाबै म्हि ङ्‍हो सब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","छाबै म्हिलाइ याहवेहजी दोषि आठर्दि, छले आछ्याँबै सैं आरेबै म्हिए फिर खीजी आशिक पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","पाप लसेया ङइ “पाप लइमुँ” आबिल्‍ले टिमा त्हिंइतिमिंन् ङ क्रोबइले ङए ह्रिब्मैं ङ्युयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","तलेबिस्याँ त्हिंयाँ म्हुँइँस क्हिजी ङलाइ थेबै दण्ड पिंइ। छतसि ख्वालबै त्हेर्बै त्हिंयाँइ ख्रोंब् धोंले ङए ज्युर्बै भों खाँयाल। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","लिउँइँ क्हिए उँइँर ङ पापि ग बिसि ङइ बिल, धै ङइ लबै आछ्याँबै केमैं ङइ आलो। “ङइ लबै आछ्याँबै केमैं याहवेहए उँइँर बिब्मुँ,” बिसि ङइ बिइ, धै ङए पापमैं क्हिजी क्षमा लमिंइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","छतसि क्हिलाइ त्होल् खाँबै त्हे मुँमन् क्हिजी बिब् ङिंब्मैं ताँनइ प्राथना लरिगे। छलमा प्ल्हों खबै भेल्गज्यै या चमैंलाइ छुइरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","क्हिन् ङए लोइ टिबै क्‍ल्‍ह्‍यो ग, क्हिजी ङ दुःखउँइँले जोगेमिंइमुँ, छतसि ङलाइ जोगेमिंबै परमेश्‍वर क्हिन् ग बिसि सैं तोंदै क्वे प्रिंसि ङ क्हिए मिं क्वेब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","“ङइ क्हिलाइ लोमिंब्मुँ,” बिसि याहवेहजी बिइ। “क्हि प्रल् त्हुबै घ्याँर ङइ क्हिलाइ डोरेमिंब्मुँ; ङइ क्हिलाइ लोदा-सैंदा लसि क्हिए फिर्न मि छरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","क्हेमैं बुद्धि आरेबै घोडा नेरो खच्‍चर धों आतद्! चमैंलाइ तार झोंबै ल्हागिर लगाम नेरो पैए प्हरे चैदिम्, आस्याँ क्हिइ चमैंलाइ तार झोंल् आखाँ।” ");
INSERT INTO gvr_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","दुष्‍ट म्हिमैंइ ल्हें दुःख योंल् त्हुब्मुँ, दिलेया याहवेहए फिर भर लब्मैंलाइ बिस्याँ खीजी खोंयोंइ आनुबै म्हाँया लसि रक्षा लमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","ओ ठिक के लब्मैं, याहवेहजी लबै केमै मैंसि सैं तोंसि कै तेद्, ओ छ्याँबै सैं प्ह्‍याब्मैं, सैं तोंदै खीए जयजय लद्। ");
INSERT INTO gvr_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","ओ ठिक के लब्मैं, सैं तोंदै याहवेहए मिंर भजन प्रिंन्! छ्याँबै सैं प्ह्‍याब्मैंइ खीए मिंर क्वे प्रिंब ङ्‍हेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","बीणा ह्रादै याहवेहए मिं थेब् लद्; तार च्यु मुँबै सारङ्गी ह्रादै खीए मिंर क्वे प्रिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","खीए ल्हागिर छारा क्वे घ्रि प्रिंन्; जय जय लदै क्ह्‍युरल्‍ले बाजामैं ह्राद्। ");
INSERT INTO gvr_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","तलेबिस्याँ याहवेहजी बिबै ताँ ठिक मुँ; धै खीए ताँन् केमैं भर लल् खाँब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","याहवेहजी खाबलाज्यै या आफेल्‍ले ठिक निसाफ लब खोम्; खीजी लबै छ्याँबै केमैं ह्‍युल तिगोंन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","याहवेहए बचनइ मु बनेइ, धै चर मुँबै तोन्दोंरि सै बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","खीजी मा ङ्युँइर्बै क्यु खागु लमुँ; खीजी गैरु मा ङ्युँइमैं ह्रोंसए धन्सरर थेंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","पृथ्बीर्बै ताँन् म्हिमैं याहवेह म्रोंसि ङ्हिंरिगे; ह्‍युलर टिबै ताँन् म्हिमैंइ खीलाइ म्हाँदिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","तलेबिस्याँ खीजी बचन पोंसि तोन्दोंरि सैमैं लमिंइ; खीजी तयाद् बिमा ताँन् सै तयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","अरू ह्रेंमैंइ लबै आछ्याँबै चाँजोमैं याहवेहजी फुवाम्, चमैंइ लल् म्हैबै आछ्याँबै केमैं खीजी तल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","दिलेया याहवेहजी लबै चाँजोमैं बिस्याँ खोंयोंन् बिलै तरिम्, खीए खोंर मैंबै ताँमैं पुस्ता पुस्ता समा तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","याहवेहलाइ परमेश्‍वर बिसि म्हाँदिबै म्हिमैंइ आशिक योंम्। खीजी ह्रोंसए म्हिमैं लबर चमैंलाइ त्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","याहवेहजी स्वर्गउँइँले ङ्ह्‍योमुँ धै खीजी म्हिमैंए ताँन् सन्तानलाइ म्रोंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","खीजी ह्रोंस टिबै राजगद्दिउँइँले पृथ्बीर्बै ताँन् म्हिमैं ङ्ह्‍योरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","ताँन् म्हिमैंलाइ मैंबै सैं पिंब खीन् ग, धै चमैंइ लबै तोन्दोंरि केमैं खीजी म्रोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","सेनाए भोंउँइँले म्रुँ जोगेल् आखाँ; नेबर ह्‍याबै म्हि ह्रोंसए भोंउँइँले सोल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","ट्होबै ल्हागिर घोडाए फिर भर लब तोनतोर्न ग, च कतिन् भोंलेया जोगेल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","दिलेया याहवेहजी खीने ङ्हिंब्मैंए छैं लम्; तलेबिस्याँ चमैंइ खीए खोंयोंइ आनुबै म्हाँयाए फिर आशा थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","छतसि चमैंलाइ सोगों थेंबै ल्हागिर अँङ्गालरै या खीजी चमैंलाइ तोइ सैरै या खाँचो आलमिं। ");
INSERT INTO gvr_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","छ बिसि याहवेहए फिर आशा थेंसि ङ्योइ खीए घ्याँ ङ्‍ह्‍योरिम्; तलेबिस्याँ ङ्योलाइ ल्होमिंब नेरो ङ्योए रक्षा लबै परमेश्‍वर खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","खीजीन् ङ्योए सैं तोंन् लमिंम्, तलेबिस्याँ खीए पबित्र मिंर ङ्योइ भर लम्। ");
INSERT INTO gvr_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","ओ याहवेह, क्हिए फिर ङिइ आशा थेंइमुँ; छतसि क्हिए खोंयोंइ आनुबै म्हाँया ङिए फिर तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","दाऊदए भजन घ्रि। दाऊदइ आबिमेलेखए उँइँर सोबलमैंल् धोंबै ब्योर उँइँइ। छतसि आबिमेलेखइ दाऊदलाइ ल्हावाइ। खोंयोंन् बिलेया ङ याहवेहए मिं क्वेरिब्मुँ; ङए सुँर खोंयोंन् बिलै खीलाइन थेब् लबै ताँमैं तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","ङए सोइ याहवेहर्न सैं तोंरिब्मुँ; दुःख योंब्मैं चु ताँ थेसि छिं ङ्हाँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","ङने बा-बालुन् याहवेहए मिं थेब् लद्, धै ङ्यो खागु तसि खीए मिं कैंडो लले! ");
INSERT INTO gvr_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","ङइ याहवेहने ग्वार ह्रिमा खीजी ङलाइ ज्वाफ पिंइ धै ङलाइ ङ्हिंन् लबै ताँन् सैमैंउँइँले ङ फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","खी ङाँइ ङ्ह्‍योब्मैं बेल्‍ले सैं तोंल् योंब्मुँ, धै फा पिसि चमैंए क्र खोंयोंइ कुरल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","दुःख योंबै म्हिइ याहवेहने ग्वार ह्रिमा खीजी चए ताँ थेमिंइ धै चए ताँन् दुःखउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","याहवेहलाइ मान लब्मैं ताँनए कारग्युले खीजी खीए स्वर्गदूत रुँबर ल्हैदिम्, धै चमैं जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","याहवेहजी कति ल्हें ल्हयो खमुँ बिसि ह्रोंसैन म्हैसि क्होद्। खीए प्हलेर्न ग्वार योंबै म्हिइ आशिक योंमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","ओ याहवेहए म्हिमैं, खीलाइ मान लदै खीजी बिबै ताँ ङिंन्! तलेबिस्याँ खीलाइ मान लब्मैंने तोइ सैलै या खाँचो आत। ");
INSERT INTO gvr_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","भर्खर्बै सिंहमैं चबै सै तोइ आयोंसि फोत्तेन् तब्मुँ, दिलेया याहवेहलाइ म्हैब्मैंने बिस्याँ छ्याँब सैमैंल खाँचो तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","ओ च्ह-च्हमिमैं खो, ङए ताँ थेद्; याहवेहलाइ खैले म्हाँदिल् त्हम् बिसि ङइ क्हेमैंलाइ लोमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","क्हेमैंए न्होंरि खाबज्यै ह्रिंबै छ्ह सोसि सैं तोंन्ले छ्ह थोल् योंस्याँ तमल ङ्हाँस्याँ, ");
INSERT INTO gvr_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","ह्रोंसए लेइ आछ्याँबै ताँ आपोंन्, धै ह्रोंसए म्हदेइ स्योर आतेद्, ");
INSERT INTO gvr_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","आछ्याँबै के लबउँइँले एखो धै छ्याँबै के लद्; आक्ह्रिबै म्हिमैं क्ह्रिमिंन्, खोंयोंन् बिलै छाबन् के लरिद्। ");
INSERT INTO gvr_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","याहवेहजी ठिक के लब्मैंए फिर मि छरिमुँ धै चमैंए ताँ थेम्। ");
INSERT INTO gvr_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","दिलेया आछ्याँबै के लब्मैंलाइ खीजी बिरोध लम्। छतसि चमैं सिबै लिउँइँ ताँन् म्हिमैंइ युनन् म्‍लेवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","ठिक के लब्मैंइ ग्वार ह्रिमा याहवेहजी थेमुँ धै चमैंए ताँन् दुःखउँइँले फ्रेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","सैं चोयाब्मैंने बालु याहवेह तमुँ; धै सैं सियाब्मैंलाइ खीजी सैं क्होल् लमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","ठिक के लबै म्हिए फिर ल्हें दुःखमैं खमुँ, दिलेया याहवेहजी चए ताँन् दुःखउँइँले फ्रेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","खीजी चए ताँन् ह्रिब्मैंए रक्षा लमुँ; चए ह्रिब्मैं घ्रि या चोरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","ह्रोंसइ लबै आछ्याँबै केइन दुष्‍ट म्हिमैं सैवाब्मुँ, धै ठिक के लब्मैंलाइ आखोब्मैंइ दण्‍ड योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","याहवेहजी ह्रोंसए के लब्मैं जोगेमिंम्; खीए प्हलेर्न ग्वार योंब्मैं खाबै या दोषि ठर्दिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","दाऊदए भजन घ्रि ओ याहवेह, ङए बिरोध लब्मैंए बिरोध लमिंन्; ङने नेखब्मैंने क्हिन् नेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","क्हिए ढाल छेदु, पैए जामा खिदु, धै ङ ल्होबर खमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","बर्षा छेदु, धै ङलाइ ल्हाप्रब्मैंलाइ ल्हिद् “क्हिलाइ मुक्‍ति पिंबै परमेश्‍वर ङन् ग,” बिसि ङए सोने बिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","ङलाइ सैल् म्हैब्मैं फापिसि लि उँइँलै आखाँन् तरिगे। ङए न्होह्रों लल् म्हैब्मैं ल्हावारिगे धै अलमल् तयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","चमैं खैंइ नोइ बोवाबै पुइ धोंन् तरिगे, धै याहवेहए दूतमैंइ चमैं ल्हावारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","चमैंए घ्याँ मिछु खैब् नेरो प्लेब तरिगे, धै याहवेहए दूतइ चमैं ल्हासिन् टिरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","तलेबिस्याँ तोनतोर्न चमैंइ ङलाइ फसेबै ल्हागिर ङो चुइ, धै तोनतोर्न ङलाइ सैबै ल्हागिर हों ताइ। ");
INSERT INTO gvr_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","थाइ आसेल्‍ले चमैं नास तयारिगे! चमैंइ लोइ चुबै ङोर चमैंन् फेरिगे; चमैंइ ताबै होंर चमैंन् पयासि नास तयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","ङ बिस्याँ याहवेहनेन् सैं तोंब्मुँ, छले खीजी ङलाइ जोगेमिंबइले ङए सैं बेल्‍ले तोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","“ओ याहवेह, क्हि धों तब खाब् मुँ? क्हिजी भों आरेब्मैंलाइ ह्रोंस भन्दा भोंबै म्हिमैंउँइँले जोगेमिंम्, छले भों आरेब्मैं नेरो आयों आख्युब्मैंलाइ ह्रुगिदिबै म्हिमैंउँइँले क्हिजी चमैंलाइ जोगेमिंम्,” बिसि ङए ताँन् ज्यु नेरो सैंइ बिप्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","स्योलिबै ताँ पोंब्मैं खसि ङइ था आसेबै ताँमैंए बारेर ङए फिर छ्याब् ल्हैदिम्। ");
INSERT INTO gvr_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","चमैंए फिर ङइ छ्याँबन् ललेया चमैंइ ङए न्होह्रों लम्; धै ङए सैं बेल्‍ले च्योंन् लवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","दिलेया चमैं नब्-छब् तमा ङइ नइँए ह्रेंग खिसि बर्त टिसि चमैंए ल्हागिर प्राथना लमल। ");
INSERT INTO gvr_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","ङए थुमैं नेरो ङए आघें अलिमैंए ल्हागिर न्हुँ लब् धोंलेन् ङइ चमैंए ल्हागिर न्हुँ लमल; ह्रोंसए आमाए ल्हागिर शोक लब् धोंले, ङइ क्र कुरसि चमैंए ल्हागिर शोक लइ। ");
INSERT INTO gvr_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","दिलेया ङए फिर दुःख तमा चमैं निस्योदै ङए बिरोधर खागु तइ; ङइ थाइ आसेल्‍ले ङए न्होह्रों लबर चमैं खागु तइ। चमैंइ खोंयोंइन ङए बिरोधर आछ्याँबै ताँमैंन् लरिइ। ");
INSERT INTO gvr_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","आछ्याँब खों मुँब्मैंइ भत्यारर बिरोध लसि प्ह्रब् धोंले चमैं ङए फिर ह्रिस खसि स ह्रादै पोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","ओ याहवेह, खोंयों समा क्हिजी ङए फिर तरिबै अनिया ङ्ह्‍योरिमुँ? ङए बिरोधर रासि खोंयोंन् बिलै ङए न्होह्रों लल् म्हैबै सिंहमैं धों तबै म्हिमैंउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","म्हिमैं च्होबै क्ल्ह्‍योर ङइ क्हिलाइन धन्यबाद पिंम्; छलेन ल्हें म्हिए म्हाँजोरै या ङइ क्हिए मिंन् थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","तोन् तोर्न ङए बिरोध लबै शत्तुरमैं ङ म्रोंसि सैं तोंल् आयोंरिगे, धै तोन् तोर्न ङलाइ हेल् लब्मैंइ मि स्युरसि ङलाइ प्ह्रल् आयोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","तलेबिस्याँ चमैंइ क्ह्रिबै ताँ खोंयोंइ आपों, क्ह्रिसि टिब्मैंए म्हाँजोरै या स्योलिबै ताँमैं बिसि छ्याब् ल्हैदिल् म्हैम्। ");
INSERT INTO gvr_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","चमैंइ ङलाइ प्ह्रमा “क्हिइ लबै के ङिए मिइन म्रोंल् योंइ!” बिसि अझै ङए बिरोधर्न पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","ओ याहवेह, चमैं ङए बिरोधर पोंब क्हिजी थेइमुँ; छतसि आपोंल्‍ले आटिमिंन्! ओ थेब प्रभु, ङउँइँले ह्रेंगो आतमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","ङए निसाफ लबै ल्हागिर रेमिंन्, ओ थेबै प्रभु, ङए परमेश्‍वर, ङए ल्हागिर नेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","ओ ङए याहवेह परमेश्‍वर, क्हि ठिक निसाफ लबै परमेश्‍वर ग। छतसि ङलाइ तोइ दोष आरेब ठर्दिमिंन्, धै ङए बिरोधर पोंबै म्हिमैं सैं तोंल् आयोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","चमैंइ खेमैंए सैंर “अँ, ङिए सैंर मैंब् धोंन् तइ!” बिल् आयोंरिगे। “ङिइ चलाइ ट्होवाइ!” बिल् आयोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","ङए फिर दुःख तमा ङए बिल्‍लि लदै निस्योब्मैं ताँन् फापिल् त्हुरिगे धै खैलातोला तबर फेरिगे! “ङिम् च भन्दा थेब् ग,” बिसि प्हैंब्मैं या ताँन् लि उँइँलै आखाँल्‍ले फापिल् त्हुरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","“चम् ठिक के लबै म्हि ग,” बिसि ङए बारेर छ्याँबै ताँ पोंब्मैं सैं तोंसि छिं ङ्हाँल् योंसि कै तेरिगे। “ह्रोंसए के लबै म्हिल बिब् धों पोंब् धों तब् म्रोंसि याहवेह सैं तोंइमुँ। छतसि खीए मिं थेब् तरिगे!” बिसि चमैंइ खोंयोंन् बिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","क्हिजी लबै ठिक केमैंए बयन लदै ङ खोंयोंन् बिलै क्हिए मिं क्वेरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर याहवेहए सेवा लबै दाऊदए भजन घ्रि दुष्‍ट म्हिइ लबै आछ्याँबै केमैंए बारेर ङए खोंर ताँ घ्रि मुँ, च ताँ तो जा बिस्याँ च परमेश्‍वर म्रोंसि आङ्हिं। ");
INSERT INTO gvr_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","तलेबिस्याँ चइ ङम् ङन् ग बिसि ह्रोंसलाइ थेब् लम्, धै ह्रोंसइ लबै आछ्याँबै केमैं चइ आम्रों; छतसि चइ पाप केमैंन् लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","चए सुँइ स्योलिबै ताँमैं नेरो आछ्याँबै ताँमैं पोंमुँ; छ्याँबै केमैं लब नेरो केर फेबै ताँमैं पोंब चइ पिवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","क्‍ल्‍ह्‍योर रोरिमै या चइ आछ्याँबै चाँजोमैंन् लरिम्; छतसि च आछ्याँबै घ्याँर्न प्रम्; छले चइ आछ्याँबै केमैंन् लप्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","ओ याहवेह, ङिए फिर क्हिजी लबै खोंयोंइ आनुबै म्हाँया स्वर्ग समा फेनेइमुँ, क्हि‍जी बिबै ताँमैं या मु समा भर लल् खाँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","ओ याहवेह, क्हिजी लबै ठिक के बेल्‍ले थेबै कोंमैं धों तब् मुँ; क्हिजी लबै निसाफमैं तो सैज्यै या लाल् आखाँबै मा ङ्युँइए गैरु धों तब मुँ; क्हिजी म्हिलाइ मत्‍त्रे आङिं, ताँन् सो प्ह्‍याबै सैंमैंलाइ वास्ता लम्। ");
INSERT INTO gvr_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","ओ याहवेह, क्हिए खोंयोंइ आनुबै म्हाँया बेल्‍ले थेब मुँ! ताँन् म्हिमैंइ क्हिए प्ह्‍यागोमैं न्होंर ग्वार योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","क्हिजी पिंसिन् ङिइ म्रेंन्ले चल् योंइमुँ, स्यों धोंले खोंयोंन् बिलै युरिबै आशिकइ क्हिजी ङिलाइ प्लिंमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","तलेबिस्याँ क्हिउँइँलेन् म्हिमैंइ खोंयोंइ आखाँबै छ्ह योंमुँ, क्हि चारबै ह्‍वे ग, छतसि क्हिए छ्याँबै घ्याँर ङि प्रल् योंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","क्हिलाइ ङो सेब्मैंए फिर क्हिए खोंयोंइ आनुबै म्हाँया खोंयोंन् बिलै तरिगे, धै छ्याँबै खों मुँब्मैंलाइ खोंयोंन् बिलै ठिक ठर्दिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","थेब् प्हैब्मैंए प्हलेइ ङलाइ प्लेल् आयोंरिगे, दुष्‍ट म्हिमैंए योज्यै या ङलाइ क्हाल् आखाँरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","आछ्याँबै के लब्मैं क्हुरयाइमुँ चमैं रेलै आखाँन्ले प्योयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","दाऊदए भजन घ्रि। दुष्‍ट म्हिमैं प्लब् म्रोंसि सैं च्योंब् आलद्; दुष्‍ट म्हिमैंइ तो ललैया चमैंए फिर ह्रिस आलद्। ");
INSERT INTO gvr_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","तलेबिस्याँ चमैं छि धोंले युनन् करायाम्, धै नो धोंले ङ्योंलोंयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","छतसि याहवेहए फिर भर थेंनु, धै छ्याँबै केमैं लद्; क्हेमैं ह्‍युलर टिमा योब ख्युब तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","याहवेहनेन् सैं तोंन्, धै खीजी क्हिए सैंर मैंबै ताँमैं योमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","ह्रोंसइ लल् म्हैबै तोन्दोंरि के याहवेहए योर्न थेंवाँन्, खीए फिर्न भर थेंन्, धै क्हिए ल्हागिर तो लल् त्हुमुँ खीजीन् लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","न्हागर्बै चारब ह्‍वे धोंले क्हिइ लबै ठिक के खीजी उँइँमिंब्मुँ, धै त्हिंयाँ आधार्बै त्हिंयाँ धोंले क्हिए ठिक निसाफ लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","याहवेहए उँइँर च्याँले टिदु, धै आअदेल्‍ले खीलाइ पैंरिद्; आछ्याँबै के लबै म्हि प्लब् तमा, धै चइ आछ्याँबै चाँजोमैं लमा सैं च्योंब् आलद्। ");
INSERT INTO gvr_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","ह्रिस आलद्, ह्रिस लब पिवाद्। सैं च्योंब् आलद्, छाबै बानि ब्योरइ आछ्याँबै घ्याँउँइँ ल्हैदिवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","तलेबिस्याँ आछ्याँबै के लब्मैं नास तयाब्मुँ, याहवेहए फिर भर थेंब्मैं बिस्याँ ह्‍युलए फिर क्ल्हे तल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","तारेबै दे त्हेर्न दुष्‍ट म्हिमैं नास तयाब्मुँ; क्हिइ म्हैले या चमैं योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","दिलेया थेब् आप्हैंब्मैंइ ह्‍युलर क्ल्हे लब्मुँ, धै चमैं छिं ङ्हाँसि सैं तोंल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","दुष्‍ट म्हिइ ठिक के लबै म्हिए बिरोधर आछ्याँबै चाँजोमैं लम्, धै च म्रोंसि स ह्राम्, ");
INSERT INTO gvr_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","दिलेया चलाइ प्ह्रसि प्रभु निस्योम्, तलेबिस्याँ च नास तयाब्मुँ बिब खीजी सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","दुःख योंब्मैं नेरो आयों आख्युब्मैंलाइ सैबै ल्हागिर, धै क्ह्रोंसेंन्बै घ्याँर प्रब्मैंलाइ नास लबै ल्हागिर, दुष्‍टमैंइ सेलाँ छेम् धै त्हँले या कुरम्। ");
INSERT INTO gvr_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","दिलेया चमैंइ छेबै सेलाँइ चमैंए तिंन् म्‍लेवाब्मुँ, धै चमैंए त्हँले चोयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","दुष्‍टमैंने मुँबै ल्हें सै न्होर भन्दा ठिक के लब्मैंने मुँबै च्युगुदे सै छ्याँब ग। ");
INSERT INTO gvr_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","तलेबिस्याँ दुष्‍ट म्हिमैंए भों याहवेहजी नास लवाब्मुँ, दिलेया ठिक के लब्मैंलाइ खीजी जोगेसि थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","याहवेहजी दोष आरेबै म्हिमैंए वास्ता लमुँ, धै चमैंइ योंल् त्हुबै सैमैंए हग चमैंने खोंयोंन् बिले तरिब्मुँ; ");
INSERT INTO gvr_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","दुःख तबै त्हेरै या चमैं फापिल् त्हुरिब् आरे; अँङ्गलै त्हेरै या चमैं योब-ख्युब तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","दिलेया दुष्‍ट म्हिमैं बिस्याँ नास तयाब्मुँ; याहवेहए शत्तुरमैं चउरर्बै छि धोंन् तम्; चमैं युनन् नास तयाब्मुँ, मिखु धोंलेन् चमैं म्हयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","दुष्‍ट म्हिमैंइ छे किंमुँ, धै चमैंइ छे आफो, दिलेया ठिक के लबै म्हिंमैंइ बिस्याँ थेबै सैंले पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","याहवेहउँइँले आशिक योंब्मैंइ ह्‍युलए फिर क्ल्हे लब्मुँ, दिलेया खीउँइँले सराब योंब्मैं बिस्याँ नास तयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","म्हिइ लबै केमैं याहवेहजी खोइ बिस्याँ च प्रल् त्हुबै घ्याँर खीजीन् चलाइ डोरेम्। ");
INSERT INTO gvr_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","च थुरलैया क्हुररिब् आरे तलेबिस्याँ याहवेहजी ह्रोंसए योइन चए यो क्हासि क्हुरल् पिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","ङ फ्रेसि मुँब् ओंनोंबै तिंयाँ खेब तन् समै या, याहवेहजी ठिक के लबै म्हिलाइ पिवाब नेरो चए प्हसेमैं ह्रिसि चब ङइ खोंयोंइ आम्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","चइ खाँचो तब्मैंलाइ यो प्ल्हसि पिंमुँ, धै चए प्हसेमैंइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","आछ्याँबै केमैं लब् पिसि छ्याँबै केमैं लप्रद्; छलस्याँ खोंयोंन् बिलै क्हिइ ह्‍युलर क्ल्हे लल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","तलेबिस्याँ ठिक निसाफ लबै म्हिमैंलाइ याहवेहजी खोम्; खीए म्हिमैं खीजी पिरिब् आरे। चमैंलाइ खोंयोंन् बिलै खीजी जोगेसि थेंमुँ, दिलेया दुष्‍ट म्हिमैंए सन्तान बिस्याँ नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","ठिक के लबै म्हिमैंइ ह्‍युलर क्ल्हे तल् योंब्मुँ धै चर खोंयोंन् बिलै टिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","ठिक के लबै म्हिइ ज्ञान बुद्धिए ताँमैं पोंम्, धै चए लेइ ठिक ताँ पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","चइ म्हाँदिबै परमेश्‍वरए ठिम चए खोंर तम्; छतसि चए प्हले प्लेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","ठिक के लबै म्हिमैंलाइ खैले सैल् योंब् ङ्‍हे बिसि दुष्‍ट म्हिमैं च्ह्‍याइ टिम्। ");
INSERT INTO gvr_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","दिलेया ठिक के लबै म्हिमैंलाइ याहवेहजी दुष्‍ट म्हिमैंए योर पिरिब् आरे, धै निसाफ तमै या खीजी चमैंलाइ छ्याब् आरेबन् ठर्दिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","याहवेहए घ्यार्न प्ररिद्, खीलाइन पैंरिद्। धै खीजी क्हेमैंलाइ चु ह्‍युलर्बै क्ल्हे तल् पिंब्मुँ; धै दुष्‍टमैं नास तब क्हिए मिइन म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","आगुए न्होह्रों लबै दुष्‍ट म्हि घ्रि ङइ म्रोंइमुँ, च बेल्‍ले सपर्दिबै च्हसिंए धुँ धों तब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","दिलेया दे लिउँइँन ङ ह्‍यामा च आरेल, ङइ म्हैलेया चने त्होल् आयोंल। ");
INSERT INTO gvr_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","छ्याब् आरेबै म्हिमैंलाइ मैंन्, सोजो म्हिमैंलाइ ङ्ह्‍योद्; तलेबिस्याँ छाबै म्हिमैंल सन्‍तानमैं तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","दिलेया आछ्याँबै के लब्मैं बिस्याँ नास तयाब्मुँ; धै दुष्‍ट म्हिमैंए सन्तानमैंल मिं क्ह्रन् म्हयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","ठिक के लब्मैंलाइ याहवेहजी जोगेमिंम्; दुःख तबै त्हेर चमैंए लोबै क्ल्ह्‍यो खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","याहवेहजी चमैंलाइ ल्होमिंसि जोगेमिंम्; खीजी दुष्‍टमैंउँइँले चमैं फ्रेमिंम् धै चमैंलाइ रक्षा लम्, तलेबिस्याँ चमैंइ खीए प्हलेर्न चमैंइ ग्वार योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","याहवेहए मिंरि ख्रो पिंबै ल्हागिर दाऊदए भजन घ्रि। ओ याहवेह, क्हि ह्रिस खमा ङलाइ आहौदिद्, धै क्हिए लल ह्रिसर ङलाइ दण्ड आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","तलेबिस्याँ क्हिए योइ प्रिंबै मे ङए ज्युर क्योयाइमुँ, धै ङ बेल्‍ले नइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","क्हि ह्रिस खबइले ङए ताँन् ज्यु नइमुँ। ङइ लबै पाप केमैंइ लमा ङए ह्रिबमैं आभोंब् तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","ङइ लबै आछ्याँबै केमैंइ ङ क्र समा हुवाइमुँ, छले ङइ लबै आछ्याँबै केमैं ल्हें तयाबइले ङ क्र ओलै आखाँन् तयाइमुँ; ");
INSERT INTO gvr_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","ङ आमादु तसि आछ्याँबै केमैं लबइले, ङए घामैं पौदिसि क्राँथाँ नाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","ङ कुरयासि त्हुलर्न क्हुरयाल् खाँइमुँ, छतसि शोकइ लमा ङ त्हिंतिमिंन् क्रो प्ररिल् त्हुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","ङए क्रे बेल्‍ले ख्रोंइमुँ, ङए ज्यु ताँन् नइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","ङने भों तिफुँइ आरे, ङए ज्यु रगा-रुगु तयाल् खाँइमुँ; छतसि ङए सैंर्बै शोकइ लमा ङ क्रोरिल् त्हुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","ओ याहवेह, ङए सैंर मुँबै ताँन् ताँमैं क्हिजी सेइमुँ; ङए दुःख या क्हिजी म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","ङए तिं ढुक्-ढुक् तइमुँ; ङने भों आरे, ङए मि या आम्रोंब् तयाल् खाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","ङए क्राँथाँ नाँबै घाइ लमा ङए थुमैं नेरो ङए ङ्‍हेब् ट्हुब्मैं ङउँइँले ह्रेंगो तम्, धै ङए परवामैं या ङ ङाँर आख। ");
INSERT INTO gvr_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","ङलाइ सैल् म्हैब्मैंइ ङ सैबै ल्हागिर ङो चुम्; ङए न्होह्रों लल् म्हैब्मैंइ ङलाइ सैबै मत लम्। छले चमैं खोंयोंन् बिलै ङए बिरोधर जाल रोरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","दिलेया ङ न्ह आथेबै म्हि धोंन् तइमुँ, चमैंइ तो पोंइमुँ ङइ वास्ता आल। ङ लड धोंन् तइमुँ, ङइ तोइ आपों। ");
INSERT INTO gvr_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","न्ह आथेबै म्हि धोंन् ङ तइमुँ, छतसि ङइ तोइ ज्वाफ पिंल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","दिलेया, ओ याहवेह, क्हिए फिर्न ङइ आशा थेइमुँ; ओ ङए याहवेह परमेश्‍वर, ङए ताँ क्हिजी थेमिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","तलेबिस्याँ “चमैंइ ङए बिरोधर जाल रोल् आयोंरिगे, धै ङए प्हले प्लेयासि ङ क्हुरियामा ङ म्रोंसि चमैं निस्योल् आयोंरिगे,” बिसि ङइ क्हिने बिल। ");
INSERT INTO gvr_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","दिलेया ङए सैंर खोंयोंन् बिलै शोकन् तरिइमुँ, ङ क्हुरियाबिन् छेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","ङइ छेरन् ङ्हाँबै केमैं लइमुँ बिसि ङइ क्हिने बिइमुँ; ङइ लबै आछ्याँबै केमैंइ लमन् ङइ शोक लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","ङए शत्तुरमैं बेल्‍ले भोंब्मैं मुँ, तोन्-तोर्न ङलाइ हेल लब्मैं ल्हेंन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","ङइ छेन् लना-लन् ङए न्होह्रों लब्मैंइ ङए बिरोधर आछ्याँबै ताँमैं पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","ओ याहवेह, ङलाइ आपिद्! ओ ङए परमेश्‍वर, ङउँइँले ह्रेंगो आतमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","ओ याहवेह, ङलाइ जोगेमिंबै परमेश्‍वर, ङ ल्होबर युनन् युमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","क्वे प्रिंब्मैंए चिब यदूतूनएल्हागिर दाऊदए भजन घ्रि। “ङइ तो के ललेया च्हैंसि मैंसि छेनाले लब्मुँ, धै ङए सुँज्यै या आछ्याँबै ताँमैं पोंरिब् आरे। दुष्‍ट म्हिमैंए उँइँर ङ तोइ ताँ पोंरिब् आरे,” बिसि ङइ बिल। ");
INSERT INTO gvr_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","छले छ्याँब आछ्याँब तोइ आपोंन्‍ले ङ च्याँले टिलेया ङए सैंर ल्हें दुःख तइ। ");
INSERT INTO gvr_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","छाइ मैंसे आत छुइ मैंसे आत, ङए सैंर खैता-खैता ङ्हाँइ। छतसि बल्‍ल ङइ पोंइ: ");
INSERT INTO gvr_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“ओ याहवेह, ङ खोंयों सिम् बिबै ताँ ङलाइ सेल् पिंन्। ङ कति सोम्? तारे ङ कति ल्हें सोम् बिसि ङइ सेल् योंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","क्हिजी तिस्याँदेए ल्हागिर मत्‍त्रे ङ सोल् पिंइमुँ, क्हिए उँइँर ङए छ्ह तोइ आङिं। ताँन् म्हिए छ्ह मुठि घ्रि सोर मत्‍त्रे ह्रेंरिइमुँ! तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","म्हिमैं छरि धोंलेन् म्हयाम्। म्हिमैंइ फाक्‍कर्बै केमैं लप्ररिम्! चइ ल्हें सै न्होर खागु लमुँ दिलेया च खाबल् तनेमुँ चइ आसे! ");
INSERT INTO gvr_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“तारे ओ याहवेह, ङइ तोए ल्हागिर पैंले? ङए आशा क्हिनेन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","ङए ताँन् पापउँइँले ङ फ्रेमिंनु! आमादुमैंइ ङ प्ह्रल् आयोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","ङ च्याँले टिइ, ङइ तोइ आपों, तलेबिस्याँ क्हिजीन् ङलाइ छले टिल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","तारे ङलाइ दण्ड आपिंन्; क्हिजी दण्ड पिंबइले ङ सिबिन् छेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","आछ्याँबै केमैं लबै म्हिलाइ क्हिजी हौदिसि दण्ड पिंमुँ, चइ खोबै सैमैं ताँन् प्हुँलुइ चसि नास लवाब् धोंले क्हिजी नास लवाब्मुँ। म्हिमैं तोइ आङिं, चमैंम् मुठि घ्रि सो मत्‍त्रे ग! तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“ओ याहवेह, ङए प्राथना थेमिंनु, ङइ क्हिने ग्वार ह्रिमा क्हिजी थेमिंनु; ङ क्रोदै ग्वार ह्रिमा ङलाइ ल्होमिंन्! तलेबिस्याँ ङए खेमैं धोंलेन् ङ आगुए ह्‍युलर्बै म्हि ग, स्याँ म्हि मुँलेया ङ क्हिनेन् टिम्। ");
INSERT INTO gvr_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","ङ सिसि ङए मिं म्हयाब् भन्दा ओंसोंन्, ङ धबै सैं तोंल् योंबै ल्हागिर क्हिए ह्रिस ङउँइँले स्योमिंन्!” ");
INSERT INTO gvr_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। ङइ आआदेनाले याहवेहलाइन पैंरिइ, धै खीजी ङ ङाँइ न्ह तोसि ङइ ग्वार ह्रिब थेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","खीजी ङलाइ नास तबै होंल्दोउँइँले नेरो हिलए ढाबउँइँले तेसि पखइ, खीजी ङए प्हले पाराए फिर थेंमिंइ, धै ङ राबर भोंबै क्‍ल्‍ह्‍यो पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","खीजी खीए मिंलाइ थेब् लबै ल्हागिर छारा क्वे घ्रि ङए सुँर थेंमिंइ, छतसि ङ्योए परमेश्‍वरए मिं थेब् लबै क्वे ङइ प्रिंइ, छाब् म्रोंसि म्हिमैं हार म्हाँदिसि ङ्हिंब्मुँ, धै याहवेहए फिर्न चमैंइ भर थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","थेब् प्हैंब्मैं ङाँइ आङ्ह्‍योब, धै स्योलिबै देवतामैं ङाँइ ल्हैदिब्मैंने आत्हुँब, याहवेहए फिर्न भर थेंब, छाबै म्हिइ आशिक योंब्मुँ। 1 ");
INSERT INTO gvr_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","ओ याहवेह, ङए परमेश्‍वर, क्हिजी लबै औदिबै केमैं नेरो क्हिजी ङिए ल्हागिर लबै चाँजोमैं ल्हेंन् मुँ। क्हिजी लबै औदिबै केमैं ल्हेंन् मुँ, छतसि ङइ च केमैंए बयन लल् आखाँ। क्हि धों तब अरू खाबै आरे! ");
INSERT INTO gvr_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","ख्रो नेरो भेटि क्हिजी आम्है, मिर ख्रोंसि पिंबै ख्रो नेरो पाप ख्रुबै ल्हागिर्बै ख्रो क्हिजी आह्रि। बरु क्हिए ताँ थेबै ल्हागिर क्हिजी ङए न्हमैं थोमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","छतसि ङइ बिइ, “ङ चुर्न खइमुँ! ङइ तो-तो लल् त्हुडम् बिसि काउदए प्हैंर प्ह्रिथेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","ओ ङए परमेश्‍वर, क्हिजी ङने ल्हैदिबै के ङइ सैं तोंन्ले लम्, तलेबिस्याँ क्हिए ठिम ङए सैंर मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","ओ याहवेह, क्हिजी ङिलाइ जोगेमिंम् बिबै ताँ ङइ थेबै म्हि च्होंर बिइमुँ। ङए सुँइ चु ताँ आपोंन्ले टिल् आखाँ बिसि क्हिजी छेनाले सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","क्हिजी रक्षा लमिंम् बिबै सैं तोंबै ताँ ङइ ह्रोंसए खोंर लोइरि आथेंइमुँ, बरु क्हि जोगेमिंब नेरो भर लल् खाँब मुँ बिसि ङइ पोंइमुँ। क्ह्रोंसेंन्बै खोंयोंइ आनुबै म्हाँया लबै परमेश्‍वर क्हिन् ग बिसि ङइ थेबै म्हि च्होंर बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","ओ याहवेह, ङए फिर खोंयोंन् बिलै ल्हयो खरिद्! क्हि भर थेंल् खाँबै परमेश्‍वर ग। क्हिजी ङलाइ खोंयोंन् बिलै म्हाँया लरिम्। छतसि ङलाइ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","तलेबिस्याँ ङए फिर ल्हें दुःख तइमुँ; ङइ लबै आछ्याँबै केमैंइ लमा ङ क्र ओलै आखाँन् तयाइमुँ; क्रप्हो भन्दा ल्हें दु:खमैं ङए फिर तबइले ङइ मि या छेन्ले आम्रों; छतसि ङए सैं बेल्‍ले च्योंयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","ओ याहवेह, ङलाइ जोगेमिंबै सैं लमिंन्! ओ याहवेह, ङ ल्होबर युनन् युमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","ङलाइ सैल् म्हैब्मैं ताँन् अलमल् तसि फा फिन् तरिगे। ङए न्होह्रों तब् म्रोंसि सैं तोंब्मैं लिग्याँ तोसि न्हेयारिगे धै आगुइ चमैंलाइ म्हि आच्हिन् लवारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","ङलाइ प्ह्रब्मैं फा फिसि लि उँइँल् आखाँरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","दिलेया क्हिलाइ म्हैब्मैं ताँन् क्हिलाइन मैंसि सैं तोंरिगे धै छिं ङ्हाँरिगे! “क्हिजी जोगेमिंइ!” बिसि धन्यबाद पिंब्मैंइ खोंयोंइन् बिलै “याहवेह बेल्‍ले थेब मुँ!” बिसि बिरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","ङ बिस्याँ आयोंब् नेरो आख्युब मुँ, दिलेया प्रभुजी ङलाइ मैंम्। क्हिजी ङलाइ ल्होसि ताँन् दुःखउँइँले फ्रेमिंम्। ओ ङए परमेश्‍वर, युनन् यमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। आयों आख्युब्मैंए खाँचो टार्दिमिंबै म्हिइ आशिक योंम्! छाबै म्हिए फिर दुःख तमा याहवेहजी चलाइ दुःखउँइँले फ्रेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","याहवेहजी चए रक्षा लब्मुँ, धै खोंयोंइ आखाँबै छ्ह पिंसि चलाइ जोगेमिंब्मुँ; च ह्‍युलर मुँमै या खीजी चलाइ आशिक पिंब्मुँ; धै चलाइ शत्तुरमैंए योर पिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","च नबै त्हेरै या याहवेहजी चलाइ ल्होब्मुँ; धै चलाइ सल् लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","ङइ बिइ, “क्हिजी आखोबै केमैं ङइ लइमुँ!” दिलेया ओ याहवेह ङए फिर दयाम्हाँया लमिंन्, धै ङ सल् लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","ङए शत्तुरमैंइ “चु खोंयों सियाब् ङ्‍हे चुए मिं क्ह्र खोंयों म्हयाब् ङहे?” बिसि ङए बारेर आछ्याँबै ताँमैं लमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","ङलाइ ङ्ह्‍योबरम् खनबिलैया चमैं छ्याँबै सैंउँइँले आख; चमैंइ सुँइ लिरिक्‍क लमुँ, दिलेया बैरु त्होंयाबै लिउँइँ ङए ताँन् लप्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","ङलाइ आखोब्मैं ताँन् खागु तसि ङए बारेर खस्या-खुस्युले ताँ लम्; ङ‍ए बिरोधर चमैंइ आछ्याँबै चाँजोमैं लम्। ");
INSERT INTO gvr_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","चमैंइ बिमुँ, “च बेल्‍ले आछ्याँबै रोगइ स्याइमुँ, च रोबै क्‍ल्‍ह्‍योउँइँले धबै रेरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","ङने बेल्‍ले क्ह्रिब, ङनेन् चब् थुँब् लब, ङइ खोबै थुइन, ङए बिरोधर आछ्याँबै ताँमैं लप्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","दिलेया ओ याहवेह, ङ फिर दयाम्हाँया लमिंन्; चमैंए खि फोल् योंबै ल्हागिर ङ सल् लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","ङए शत्तुरमैंइ ङए फिर ट्होल् खाँरिब् आरे। छतसि ङ म्रोंसि क्हि सैं तोंइमुँ बिब ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","तो ठिक मुँ च केन् ङइ लबइले क्हिजी ङ ल्होमिंम्, धै क्हिजी खोंयोंन् बिलै ङ क्हिए उँइँर्न थेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","इस्राएलए याहवेह परमेश्‍वरए मिं खोंयोंन् बिलै थेब् तरिगे। आमेन। छान् तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","क्वे प्रिंब्मैंए चिबै ल्हागिर कोराए च्हमैंइ प्रिंबै मस्किल घ्रि फोइ क्यु पिसि स्योंर्बै क्यु म्हैब् धोंले, ओ परमेश्‍वर, ङए सोज्यै या क्हिन् म्हैरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","क्हि खोंयोंन् बिलै तरिबै परमेश्‍वरने खोंयों त्होनेब् ङ्‍हे बिसि ङए सोइ क्हिलाइन म्हैरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","ङए मिग्लि त्हिंयाँ म्हुँइँस ङए चबै सै तइमुँ, छाब् म्रोंमा ङए शत्तुरमैंइ “क्हिए परमेश्‍वर खनिर मुँ?” बिसि खोंयोंन् बिलै ङलाइ प्ह्ररिम्। ");
INSERT INTO gvr_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","सैं तोंदै धन्यबाद पिंबै म्हिमैंए चिब ङ तल। छतसि परमेश्‍वरए मिं क्वेबर ह्‍याबै ल्हें म्हिमैंने क्ह्रिसि ङइ चमैंलाइ परमेश्‍वरए धिंउँइँ बोब्रें लमल। चु ताँमैं मैंरिमा ङए सैं बेल्‍ले नम्। ");
INSERT INTO gvr_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","ओ ङए सो, क्हि तले आतोंल? धै ङए खों न्होंर क्हि तले च्हतर्लै आदेल? क्हिए आशा परमेश्‍वरने थेंन्; तलेबिस्याँ खी ङलाइ मुक्‍ति पिंबै परमेश्‍वर ग। छतसि ङ अझै खीलाइन थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","ङए सैं आतों। छतसि ङइ यर्दन स्यों नेरो हेर्मोन कोंमैंए ह्‍युलउँइँले धै मिसारए कोंउँइँले क्हिलाइन मैंम्। ");
INSERT INTO gvr_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","मा ङ्युँइए क्यु प्ल्होंइ खमा क्हिए ताँन् क्युए भेल्गमैं नेरो मा ङ्युँइर्बै क्युमैंइ ङए सैं खैता-खैता ङ्हाँन् लवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","दिलेया याहवेहए खोंयोंइ आनुबै म्हाँया त्हिंयाँर ङने तमुँ, धै म्हुँइँसर खीए मिंर भजनमैं प्रिंसि ङलाइ छ्ह पिंबै परमेश्‍वरने ङइ प्राथना लम्। ");
INSERT INTO gvr_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","ङए परमेश्‍वरने, ङ लोबै पाराने, ङइ बिम्: “क्हिजी तले ङ म्‍लेल? शत्तुरमैंइ क्र ओल् आपिंसि ङ तले न्हुँ लसि प्ररिल् त्हुइमुँ?” ");
INSERT INTO gvr_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","ङए ह्रिबमैंर सेलाँइ थोसि घा तब् धोंले ङए शत्तुरमैंइ ङलाइ प्ह्रम्, धै चमैंइ त्हिंइतिमिन् ङने बिरिम्, “क्हिए परमेश्‍वर खनिर मुँ?” ");
INSERT INTO gvr_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","ओ ङए सो, क्हि तले आतोंल? धै ङए खों न्होंर क्हि तले च्हतर्ले आदेल? क्हिए आशा परमेश्‍वरने थेंन्; तलेबिस्याँ खी ङलाइ मुक्‍ति पिंबै परमेश्‍वर ग। छतसि ङ अझै खीलाइन थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","ओ परमेश्‍वर, ङने तोइ छ्याब् आरे बिमिंन्, धै क्हिजी बिब् आङिंबै ह्रेंमैंए बिरोधर ङए ख लसि पोंमिंन्, छलु म्हिलु लब्मैं नेरो दुष्‍ट म्हिमैंउँइँले ङलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","तलेबिस्याँ, ओ परमेश्‍वर, क्हिए प्हलेर्न ङइ ग्वार योंम्। ङलाइ तले पिवाल? शत्तुरमैंए योर फेसि ङ तले क्रोप्ररिल् त्हुइमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","क्हिए क्ह्रोंसेंन्बै ताँमैं ङने बिमिंसि क्हिए चारबै ह्‍वे उँइँमिंन्; चमैंइन ङ डोरेरिगे; धै क्हिए पबित्र कोंर क्हि टिबै क्‍ल्‍ह्‍योर ङ फेनेल् योंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","ओ परमेश्‍वर, ङए परमेश्‍वर, छलस्याँ क्हिए मिंर ख्रो पिंबै क्ल्ह्‍योर ङ फेनेब्मुँ, धै ङए सैं तोंन् लबै परमेश्‍वरए मिंर ङइ बीणा ह्रादै क्हिए क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","ओ ङए सैं, क्हि तले आतोंल? ओ ङए खों, क्हि तले च्हतर्ले आदेल? क्हिए आशा परमेश्‍वरने थेंन्; तलेबिस्याँ खी ङलाइ मुक्‍ति पिंबै परमेश्‍वर ग। छतसि ङ अझै खीलाइना थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर कोराए च्हमैंइ प्ह्रिबै मस्किल घ्रि ओ परमेश्‍वर, स्योंमा ङिए खे-मामैंए पलोर क्हिजी बेल्‍ले थेबै केमैं लल बिसि ङिए खे-मामैंइ बिब ङिए न्हइ थेल। ");
INSERT INTO gvr_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","क्हिजी ह्रोंसए योजीन् अरू ह्रेंमैं ल्हावासि ङिए खेमैं चर टिल् पिंइ; क्हिजी अरू म्हिमैंलाइ कुरवासि ङिए खेमैंलाइ थेब् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","तलेबिस्याँ चमैंइ सेलाँइ नेसि ह्‍युल ट्होब आङिं, धै चमैंइ ह्रोंसए यो पाख्राए भोंइ नेसि ट्होबै या आङिं, दिलेया क्हिए क्योलो योर्बै भों नेरो क्हिए चारबै मोंडए ह्‍वेइन चमैंइ ट्होब् ग, तलेबिस्याँ क्हिजी चमैंए फिर म्हाँया लमल। ");
INSERT INTO gvr_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","क्हिन ङए म्रुँ नेरो ङए परमेश्‍वर ग; क्हिजी याकूबलाइ ट्होगों लमिंम्! ");
INSERT INTO gvr_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","क्हिजी ल्होमिंबइले ङिइ ह्रोंसए शत्तुरमैं ल्हाल् खाँइ। ङिए बिरोधर राब्मैं ङिइ क्हिए मिंए भोंउँइँले प्लेम्। ");
INSERT INTO gvr_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","ङ ह्रोंसए मेत्हले फिर भर आल, ङए सेलाँइ ङलाइ ट्होल् आपिं, ");
INSERT INTO gvr_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","दिलेया ङिए शत्तुरमैंए फिर क्हिजी ङिलाइ ट्होल् पिंब्मुँ, धै ङिए बिरोधीमैं फापिल् लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","ङिए सैं खोंयोंइ बिलै परमेश्‍वरर्न तोंरिम्, धै ङि खोंयोंन् बिले क्हिए मिं क्वेरिम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","दिलेया क्हिजी ङिलाइ पिवासि ङिए सेनामैं आल्होमिंबइले ङि कुरल् त्हुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","क्हिजी ङिलाइ शत्तुरमैंए फिर ट्होल् आखाँब् लमिंबइले चमैंइ ङिने मुँबै सैमैं लुडिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","अरू ह्रेंमैंए म्हाँजोर क्हिजी ङि खन्तोंदोंन् प्हुँवाइ। र-क्युमैं सैबर पिंवाब् धोंलेन् क्हिजी ङिलाज्यै या सैबर पिंवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","ह्रोंसए म्हिमैंलाइ तो धोंइ आङ्हाँन्ले क्हिजी चुँवाइ; चमैं चुँवासि क्हिलाइ तोइ फायद आतइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","ङिए ङ्‍हेब्मैंए ओंसों क्हिजी ङिलाइ आगुइ प्ह्रन् छेब लवाइ, म्हिमैंए उँइँर क्हिजी ङिलाइ चमैंइ आक्वेंब नेरो म्हि आच्हिब लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","अरू ह्रेंमैंए म्हाँजोर क्हिजी ङि आउ निस्योबै घ्याँ तल् पिंइमुँ, छतसि ङि म्रोंसि म्हिमैंइ क्र लाम्। ");
INSERT INTO gvr_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","छतमा म्हिमैंइ त्हिंइतिमिन् ङए मिं वाम्, छतसि फापिसि ङइ लि उँइँलै आखाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","ङए बिरोधर राबै शत्तुरमैंइ लमा फापिसि ङइ क्र ओलै आखाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","क्हिइ ल्हैदिबै केमैं ङिइ लरिइमुँ, क्हिलाइन मैंसि ङि टिरिइमुँ, दिलेया चु ताँन् दुःख ङिए फिर्न तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","दुःखन् तनाबिलेया ङिए सैं क्हि ङाँइन मुँ, क्हिइ तेंबै घ्याँउँइँले ङि छाइ-छुइ आतइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","दिलेया क्हिजी ङिलाइ त्हुल भुँ लवासि सेलमैं टिबै क्ल्ह्‍योर मिछु खैबर भ्योंवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","खनिज्यै ङिइ ह्रोंसए परमेश्‍वरए मिं म्‍लेयासि अरू देवतामैं फ्योनेस्याँ ");
INSERT INTO gvr_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","खीजी चु आसेमल् रो वा? तलेबिस्याँ खीजी खों न्होंर्बै ताँमैं सेम्। ");
INSERT INTO gvr_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","छले सैबर बोबै क्यु धोंन् ङि तइमुँ, क्हिए ल्हागिर ङि खोंयोंन् बिलै सिब् धोंन् तल् त्हुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","छतसि ओ प्रभु, तले रोल? रेद्! छोरद्! खोंयोंइ ङिलाइ आपिद्। ");
INSERT INTO gvr_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","ङि ङाँइले तले ह्रेंगो तल? ङि फिर तबै दुःख नेरो कष्‍ट तले म्‍लेल? ");
INSERT INTO gvr_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","ङि त्हुलर कोंयाइमुँ; ङिए ज्यु सर्न ह्रेंयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","रेद्, ङिलाइ ल्होमिंन्! क्हिए खोंयोंइ आनुबै म्हाँयाजी ङिलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","क्वे प्रिंब्मैंए चिबए लागिर, लिलि ट बिबै भाकार प्रिंबै कोराए च्हमैंए मस्किल घ्रि, म्हाँया क्वे घ्रि। छ्याँबै ताँमैंइ प्लिंसि ङए सैं बेल्‍ले तोंइमुँ; म्रुँए ल्हागिर ङइ प्ह्रिबै कबिता ङ बिमुँ; ङए ले छेनाले प्ह्रिल् ह्रबै म्हिए कलम धों तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","मुँयुमैंए न्होंर क्हि बेल्‍ले छ्याँब मुँ; क्हि पोंबरै बेल्‍ले ह्रब मुँ; तलेबिस्याँ परमेश्‍वरजी खोंयोंन् बिलै क्हिए फिर आशिक पिंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","ओ थेब शक्‍ति मुँबै म्रुँ, क्हिए थेबै मिंए मान नेरो क्हिए थेबै केमैं उँइँबै ल्हागिर ह्रोंसए क्रेर सेलाँ खिद्। ");
INSERT INTO gvr_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","क्ह्रोंसेंन्बै ताँ पोंल् त्हुम्, करल् त्हुम् ठिक निसाफ लल् त्हुम् बिदै ह्रोंसए शक्तिर ट्होदै ह्‍याद्। क्हिए क्योलो योजी औदिबै केमैं लमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","क्हिए म्ह्रुछु तबै मेइ म्रुँए शत्तुरमैंए तिंर म्‍लेवारिगे; अरू ह्रेंमैं क्हिए प्हलेर्न कुरखरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","ओ परमेश्‍वर, क्हिए ग्याल्स खोंयोंन् बिलै तरिम्। ठिक केमैं लसि ह्रोंसए म्हिमैंए फिर क्हिजी ग्याल्स लम्; ");
INSERT INTO gvr_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","ठिक केमैं लब क्हिजी खोमुँ, आछ्याँबै केमैं बिस्याँ क्हिजी आखो। छतसि परमेश्‍वर, क्हिए परमेश्‍वरजी क्हिए थुमैंलाइ भन्दा क्हिलाइ ल्हें आशिक पिंसि क्हिए सैं तोंन् लमिंइमुँ; ");
INSERT INTO gvr_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","क्हिए ताँन् क्वेंमैंर मूर्र, एलवा नेरो लेबोए लिंब थाँ खम्। हात्तिए समैंइ सजेबै दरबारउँइँले त्होंबै गिटार-सारङ्गींमैंए छ्याँब कैइ क्हिए सैं तोंन् लम्; ");
INSERT INTO gvr_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","क्हिउँइँले मान योंबै च्हमिरिमैं न्होंर म्रुँमैंए च्हमिमैं या मुँ; क्हिए क्योलोउँइँ ओपीरर्बै माराए घानइ पैरिदिबै म्रुँस्यो राइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","ओ च्हमि छेनाले थेद्, क्हिए म्हिमैं नेरो क्हिए आबाए धिं म्‍लेवाद्। ");
INSERT INTO gvr_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","छ लइ बिस्याँ क्हि छ्याँब् म्रोंसि म्रुँ सैं तोंब्मुँ। खीलाइ म्हाँदिद्, तलेबिस्याँ खी क्हिए क्ल्हे ग। ");
INSERT INTO gvr_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","टुरोसर्बै म्रुँए च्हमि क्होल्सै किंसि खब्मुँ, प्लबै म्हिमैंइ क्हिनेन् आशा थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","म्रुँए च्हमि ह्रोंसए कोठार टिमा कति छ्याँब मुँ! चए क्वेंरै या माराइन बुट्टा प्रिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","छले बेल्‍ले छ्याँबै क्वें खिसि चलाइ म्रुँ ङाँर सनेब्मुँ, चए थुमैं या चए लिलिन् खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","निस्यो-स्योइ सैं तोंदै चमैं खमुँ, धै चमैं म्रुँए दरबार न्होंर होंम्। ");
INSERT INTO gvr_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","क्हिए खेमैं म्रुँ तब् धोंले क्हिए सन्तानमैं या म्रुँ तब्मुँ; क्हिजी चमैंलाइ ताँन् ह्‍युलए फिर क्ल्हे तल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","लिउँइँबै पुस्त-पुस्त समा क्हिए मिं मैंरिब लमिंब्मुँ; छतसि अरू ह्रेंमैंइ खोंयोंन् बिलै क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर। अलामोत बिबै भाकार प्रिंबै कोराए च्हमैंए क्वे घ्रि। ङ्योए लोबै क्‍ल्‍ह्‍यो नेरो भों पिंब परमेश्‍वरन् ग, दुःख तमा युन्लेन् ङ्योलाइ ल्होमिंब खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","छतसि ह्‍युल लालेया, मा ङ्युँइर कोंमैं तेयालेया, ");
INSERT INTO gvr_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","मा ङ्युँइ घ्वा-घ्वाले ङ्‍हेसि पिबि थोलै या, धै च प्ल्होंखसि कोंमैं लालै या ङि ङ्हिंरिब् आरे। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","स्यों घ्रि मुँ, च स्योंइ ताँन् भन्दा थेबै परमेश्‍वरए म्हिमैं टिबै सहर नेरो खी टिबै पबित्र क्ल्ह्‍यो सैं तोंल् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","परमेश्‍वर च सहरर मुँ; छतसि च तेयारिब् आरे; न्हाग छझँ मि छेनाले आम्रोंबर्न परमेश्‍वरजी च ल्होमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","ह्रें-ह्रेंमैं ङ्हिंसि त्हारम् धै ग्याल्समैं लायाम्; खीजी थेब कै तेमा पृथ्‍बी बिलेयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","स्वर्गर्बै सेनामैंए चिब याहवेह ङ्योने बालु मुँ; ङ्योलाइ जोगेमिंबै किल्‍ला याकूबए परमेश्‍वर ग। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","खो, याहवेहजी लबै केमैं ङ्ह्‍योनेले। ह्‍युलर खीजी नास लबै केमैं ङ्ह्‍योद्। ");
INSERT INTO gvr_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","ह्‍युलर तरिबै ल्हडें खीजी तल् आपिं; खीजी त्हलें चुवाम्, धै मेमैं कुदुकुदु लवाम्; झाइले ढालमैं मिर ख्रोंसि मेउरो लवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","“च्याँले टिद्, धै ङ परमेश्‍वर ग बिसि सेद्। ह्रें-ह्रेंमैंए फिर ङ थेब् तब्मुँ, ताँन् ह्‍युलरै या ङन् थेब् तब्मुँ!” बिसि याहवेहजी बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","स्वर्गर्बै सेनामैंए चिब याहवेह ङ्योने बालु मुँ; ङ्योलाइ जोगेमिंबै किल्‍ला याकूबए परमेश्‍वर ग। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर कोरहए च्हमैंए भजन घ्रि। ओ ताँन् ह्रेंमैं, योप्ल्ह ह्राद्! सैं तोंदै थेबै कै तेसि परमेश्‍वरए जय-जय लद्! ");
INSERT INTO gvr_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","तलेबिस्याँ ताँन् भन्दा थेबै याहवेहने बेल्‍ले ङ्हिंल् त्हुब मुँ, पृथ्बी तिगोंर्बै थेबै म्रुँ खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","खीजी ह्रें-ह्रेंर्बै म्हिमैं ङिए न्होंर पखइ, धै म्हिमैंलाइ ङिए प्हले न्होंर लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","खीजी ङि याकूबए सन्तानमैं खोइमुँ, खीजी ङिए ल्हागिर टिबै ह्‍युल त्हाँइ, धै च ह्‍युल योंसि ङि सैं तोंइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","परमेश्‍वर कैंडो ह्‍यारिमा म्हिमैंइ बेल्‍ले सैं तोंदै खीए मिं क्वेइमुँ, छले याहवेह कैंडो ह्‍यामा चमैंइ थुतुरु या ह्राइ। ");
INSERT INTO gvr_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","परमेश्‍वरए मिं थेब् लदै क्वे प्रिंन्, ङ्योए म्रुँलाइ थेब् लदै क्वे प्रिंन्, खीए मिंर क्वे प्रिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","तलेबिस्याँ ह्‍युल तिगोंर्बै म्रुँ परमेश्‍वरन् ग; छतसि खीए मिं थेब् लबै भजन प्रिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","ह्रें-ह्रेंमैंए फिर परमेश्‍वरजी ग्याल्स लमुँ; परमेश्‍वर ह्रोंसए पबित्र राजगद्दिर टिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","अब्राहामए परमेश्‍वरए म्हिमैंने बालु अरू ह्रेंमैंए क्रथे मिंथेमैं खागु तइमुँ। तलेबिस्याँ पृथ्बीर्बै म्रुँमैं परमेश्‍वरए योर्न मुँ; खी बेल्‍ले थेब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","कोराहए च्हमैंए भजन घ्रि, क्वे घ्रि। याहवेह बेल्‍ले थेब मुँ, धै ङ्योए परमेश्‍वरए सहरर, खीए पबित्र कोंर, खी बेल्‍ले थब् लल् त्हुब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","च सहर नुबै क्ल्ह्‍योर बेल्‍ले छ्याँब मुँ, ह्‍युलर्बै ताँन् म्हिमैंइ च म्रोंसि सैं तोंम्। सापोन कों भन्दा सियोन कों ताँन् भन्दा थेब म्रुँए सहर ग। ");
INSERT INTO gvr_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","परमेश्‍वर चए किल्‍लामैंर तमुँ, धै खीजी चए रक्षा लमिंम् बिसि ताँनलाइ सेल् पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","ङ्ह्‍योत्ति, म्रुँमैं खागु तसि नेबर खइ, ");
INSERT INTO gvr_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","दिलेया सियोन कों म्रोंसि चमैं प्लेटोयाइ; धै ङ्हिंसि भौदिह्‍याइ। ");
INSERT INTO gvr_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","छले चमैं बेल्‍ले ङ्हिंसि सुत्केरि बेथा ल्हैदिबै च्हमिरि धोंन् तइ। ");
INSERT INTO gvr_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","तर्शीशर्बै क्यु झाजमैं स्यारउँइँले खबै खैंइ नास लब् धोंलेन् क्हिजी चमैं या नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","ङ्योइ तो थेइ, चन् स्वर्गर्बै सेनामैंए चिब याहवेहए सहरर म्रोंइमुँ, ङ्योए परमेश्‍वरए सहरर ङ्योइ छले म्रोंइमुँ। खीजी च सहर खोंयोंन् बिलै जोगेसि थेंब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","ओ परमेश्‍वर, क्हिजी लबै खोंयोंइ आनुबै म्हाँयाए बारेर क्हिए पबित्र क्ल्ह्‍योर ङिइ खोंयोंइ मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","ओ परमेश्‍वर, पृथ्बीए छेउ समा म्हिमैंइ क्हिए मिं सेब्मुँ। छलेन पृथ्बी तिगोंन् म्हिमैंइ क्हिए मिं क्वेम्। क्हिए क्योलो योइ ठिक के लम्। ");
INSERT INTO gvr_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","सियोन कों सैं तोंम्! क्हिजी ठिक के लब् म्रोंसि यहूदा ह्‍युलर्बै म्हिमैं निस्योम्! ");
INSERT INTO gvr_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","सियोनए कारर्ग्युन् स्युरदै प्रद्, चर्बै धररमैं च्योद्, ");
INSERT INTO gvr_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","चर्बै गारामैं छेनाले ङ्ह्‍योद्, चर्बै किल्‍लामैं छेनाले सेथेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","छ लस्याँ “खोंयोंन् बिलै तरिबै ङ्योए परमेश्‍वर खीन् ग, धै खीजीन् ङ्योलाइ खोंयोंन् बिलै डोरेब्मुँ,” बिसि क्हेमैंइ लिउँइँबै पुस्ताने बिल् खाँब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर कोराए च्हमैंए भजन घ्रि। ओ ताँन् ह्रें-ह्रेंर्बै म्हिमैं चु ताँ थेद्! ह्‍युलर टिबै ताँन् म्हिमैं न्ह तोद्, ");
INSERT INTO gvr_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","च्योंब नेरो थेब, प्लब्मैं नेरो ङ्हाँदुमैं ताँनइ थेद्! ");
INSERT INTO gvr_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","ङए सुँइ बुद्धिए ताँ पोंब्मुँ; ङए सैंर मैंबै ताँमैंइ क्होबै शक्ति पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","ङ अहान् थेब्मुँ; बीणा ह्रादै ङइ च ताँए अर्थ खोल्दिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","ङए फिर दुःखन् तलेया, धै आछ्याँबै के लब्मैंइ ङलाइ कारर्ग्यु लखलेया, ");
INSERT INTO gvr_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","प्लबै म्हिमैंइ खेंमैंए सै न्होरए फिर थेब् प्हैंसि ङलाइ म्हि आच्हिन् ललेया ङ ङ्हिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","खाबज्यै या सै फोसि अरू म्हिलाइ खाल् आखाँ, छलेन ङलाइ जोगेमिंन् बिसि खाबज्यै या परमेश्‍वरलाइ सै फोल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","तलेबिस्याँ छए सै ल्हें मुँ। म्हि खोंयोंन् बिलै सोरिगे ");
INSERT INTO gvr_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","धै क्रोंर आह्‍यारिगे बिसि खाबज्यै तो सैज्यै या म्हिए सै फोल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","तलेबिस्याँ बुद्धि मुँबै म्हिमैं या सिल् त्हुब, धै आमादुमैं नेरो आह्र आसेब्मैं ङ्हिंन-ङ्हिंन् सियामा सै न्होर अरूमैंए ल्हागिर्न वाथेंल् त्हुमन बिब ताँनइ म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","चमैंए छगों खोंयोंन् बिलै चमैंए धिं तब्मुँ, पुस्ता पुस्ता समा चमैं छगोंर टिब्मुँ। चमैंए धिं-नाँमैं, क्ल्ह्‍यो न्हेंमैंर खेंमैंए मिं थेंलेया ");
INSERT INTO gvr_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","मान इजेत मुँलेया च खोंयोंन् बिलै सोरिल् आखाँ। च नास तयाबै खेदोमैं धोंन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","ह्रोंसए फिर भर थेंबै म्हिमैंए गति या छाबन् तम्; धै चमैंए लिलि प्रसि चमैंए ताँ क्वेंब्मैंए गति या छाबन् तम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","क्युमैं धोंले चमैं क्रोंर ह्‍याल् त्हुम्, चमैंलाइ कालइ बोयाम्! ठिक के लब्मैंन् चमैंए फिर न्हाँगन् क्ल्हे तब्मुँ। चमैं टिबै क्‍ल्‍ह्‍योउँइँले ह्रेंगोर चमैंए ज्यु क्रोंर क्राँयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","दिलेया ङलाइ बिस्याँ परमेश्‍वरजी क्रोंउँइँले फ्रेमिंब्मुँ, धै खीने बालुन् टिल् पिंब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","छतसि म्हिमैं प्लब् योब् तसि चमैंइ थेबै धिं योंलेया क्हेमैं तो धोंइ आङ्हाँन्। ");
INSERT INTO gvr_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","तलेबिस्याँ च सियामा चइ तोइ बोल् खाँरिब् आरे; चइ योंबै मान इजेतै या चए लिलि छगोंर ह्‍यारिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","च सोन् समा चइ “ङम् ङ्‍हो सब् ग” बिसि मैंलेया म्हिमैंउँइँले चइ थेबै मान इजेत योंलेया ");
INSERT INTO gvr_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","च ह्रोंसए खेमैं माँमैंनेन् च्ह्‍यालनेब्मुँ, चइ खोंयोंइ आखाँबै चारबै छ्ह योंबै ह्‍वे म्रोंल् योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","मान इजेत मुँबै म्हि मुँलेया चइ आक्होस्याँ नास तसि ह्‍याबै खेदोमैं धोंन् तब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","आसापए भजन घ्रि। ताँन् भन्दा थेब शक्‍ति मुँबै याहवेह परमेश्‍वर पोंम्, त्हिंयाँ प्योबै क्ल्ह्‍योउँइँले त्हिंयाँ लिबै क्ल्ह्‍यो समा ह्‍युलर्बै ताँन् म्हिमैंलाइ खीजी हुइम्। ");
INSERT INTO gvr_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","बेल्‍ले छ्याँबै सियोनउँइँले बेल्‍ले म्हारल्‍ले परमेश्‍वर चारइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","ङ्योए परमेश्‍वर युसिन् मुँ, युसि खी च्याँले टिरिब् आरे; खीए ओंसों लुँबै मि मुँ, खीए कारर्ग्युले नाँ-खैंमैं मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","ह्रोंसए म्हिमैंए निसाफ लबर खीजी मु नेरो पृथ्‍बीलाइ हुइब्मुँ: ");
INSERT INTO gvr_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“ख्रो पिंसि ङने बाछा फैब नेरो ङलाइ क्वेंबै म्हिमैं ङ ङाँर पखो।” ");
INSERT INTO gvr_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","“खीजी ठिक के लम्,” बिसि मुइ बिमुँ, “तलेबिस्याँ ठिक निसाफ लबै परमेश्‍वर क्हिन् ग। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“ओ ङए म्हिमैं, ङ पोंमुँ, ङए ताँ थेद्!” बिसि परमेश्‍वरजी बिम्। “ओ इस्राएल, ङ परमेश्‍वर ग, ङ क्हिए परमेश्‍वर ग। ङ क्हिए बिरोधर पोंब्मुँ: ");
INSERT INTO gvr_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","दिलेया क्हिइ पिंबै ख्रोमैंए ल्हागिर ङइ क्हिलाइ दोष आपिं, ङए मिंर मिर ख्रोंसि पिंबै ख्रोमैं क्हिइ खोंयोंन् बिलै पखब ङइ म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","दिलेया क्हिए धिंर्बै साँड्मैं नेरो क्हिए प्ह्रोंर्बै र बुग्यामैं ङलाइ आचैदि। ");
INSERT INTO gvr_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","तलेबिस्याँ क्ह्‍योंर्बै ताँन् खेदोमैं नेरो ताँन् कोंजरेबै खेदोमैं ङलन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","कोंजरेबै ताँन् नमेमैं नेरो सर मुँबै सो प्ह्‍याबै सैमैं या ङइ ताँन् ङो सेम्। ");
INSERT INTO gvr_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","ङ फोतेन् तलेना क्हिने ह्रिल् आत्हु, तलेबिस्याँ पृथ्बी नेरो चर मुँबै तोन्दोंरि सैमैं ङलन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","साँड्मैंए से ङइ चम्‍मा? धै रए को थुँम्‍मा? ");
INSERT INTO gvr_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","बरु ङलाइ धन्यबाद पिंसि ङए मिं क्वेद्! चुन् पिंल् त्हुबै ख्रो ग। धै ताँन् भन्दा थेबै परमेश्‍वए मिंर लबै भकल पूरा लद्। ");
INSERT INTO gvr_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","धै दुःख तबै त्हेर ङने ग्वार ह्रिद्; ङइ क्हि दुःखउँइँले फ्रेमिंब्मुँ, झाइले क्हिइ ङए मिं थेब् लब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","दिलेया दुष्‍टमैंने बिस्याँ परमेश्‍वरजी बिमुँ, “ङए ठिम खेब नेरो ङइ फैबै बाछाए ताँमैं बारेर पोंब क्हेमैंल तोए हग मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","ङइ लोमिंबै ताँमैं क्हिइ आखो, धै ङइ ल्हैदिबै केमैं क्हिइ आल। ");
INSERT INTO gvr_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","ह्‍यो त्होमा क्हि चनेन् त्हुँयाम्, धै ब्यभिचार लबै म्हिमैं त्होमा क्हि चमैंनेन् क्ह्रियाम्। ");
INSERT INTO gvr_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","“क्हिए सुँइ आछ्याँबै ताँमैं पोंमुँ, धै क्हिए लेइ फिब्लो पार्दिब ताँमैं लम्। ");
INSERT INTO gvr_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","क्हि खोंयोंन् बिलै ह्रोंसए अलिए बिरोधर पोंम्; धै ह्रोंसए अलिलाइन क्हिइ स्यारम्। ");
INSERT INTO gvr_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","क्हिइ चु ताँन् आछ्याँबै केमैं लइमुँ दिलेया ङ तोइ आपोंन्ले टिइ; छतसि ङै या क्हि धोंन् तब्मुँ बिब क्हिए सैंर ङ्हाँमै। छ आङिं! ङइ क्हि हौदिब्मुँ धै क्हिइ खैबै केमैं लइमुँ बिब क्हिए ओंसोंन् ताँन् उँइँमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“ओ परमेश्‍वरलाइ आमैंब्मैं, छेनाले मैंन्। आमैंस्याँ ङइ क्हि कुदु-कुदु लवाब्मुँ, क्हिलाइ फ्रेमिंब खाबै तरिब् आरे! ");
INSERT INTO gvr_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","धन्यबादए ख्रो पिंबै म्हिइन ङए मिं थेब् लब्मुँ। धै ठिक घ्याँर प्रब्मैंलाइन ङइ जोगेमिंब्मुँ,” बिसि फरमेश्‍वरजी बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","दाऊदइ बेथसेबा न्होंवाबै लिउँइँ नाथन बिबै अगमबक्‍ता दाऊदए ङाँर ह्‍याइ। च त्हेर दाऊदइ क्वे प्रिंब्मैंए चिबए ल्हागिर भजन घ्रि प्ह्रिइ। ओ परमेश्‍वर, क्हिए खोंयोंइ आनुबै म्हाँयाइ ङए फिर ल्हयो खमिंन्। क्हिजी लबै थेबै म्हाँयाउँइँले ङए पापमैं त्होमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","ङइ लबै ताँन् आछ्याँबै केमैंउँइँले ङ फ्रेमिंन्, धै ङए पाप त्होमिंसि ङ चोखो लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","तलेबिस्याँ ङइ लबै आछ्याँबै केमैं ङइ सेइमुँ, ङइ लबै पाप खोंयोंइन ङइ मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","क्हिए बिरोधर्न ङइ पाप केमैं लइमुँ, धै क्हिजी आखोबै केमैंन् ङइ लइमुँ, छतसि क्हिजी ङने बिबै ताँ क्ह्रोंसेंन् ग, धै क्हिजी लबै निसाफ ताँनए उँइँर ठिक मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","क्ह्रोंसेंन फिबै त्हे ओंनोंन् ङ पापि मुँल, ङए आमाए फो न्होंर मुँब् ओंनोंन् ङ पापि मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","क्ह्रोंसेंन क्हिजी ङए खों छ्याँब् तरिगे ङ्हाँम्, छतसि क्हिजी ङए सैंर ज्ञान-बुद्धिए ताँमैं झोंमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","लुँडइ ङए सैं म्यामिंन् धै ङए सैं छ्याँब तब्मुँ; छले ख्रुमिंमा ङ चोखो तसि क्लिं भन्दा तार्ग्या तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","ङलाइ सैं तोंबै ताँ नेरो आनन्‍द तबै ताँमैं थेल् पिंन्; क्हिजी त्हुल भुँ लवाबै ङए ह्रिबमैं सरिगे धै ङ सैं तोंल् योंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","ङइ लबै पाप केमैं क्हिजी आङ्‍ह्‍योद्, धै ङइ लबै आछ्याँबै केमैं मेटिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","ओ परमेश्‍वर, ङए खों छ्याँब लमिंन्, धै ङलाइ ठिक सैं पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","क्हि ङाँइँले ङ आस्योमिंन्, धै ङ ङाँइँले क्हिए पबित्र प्ल्ह आबोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","क्हिजी पिंबै मुक्‍तिउँइँले धबै ङ सैं तोंन् लमिंन्, धै आछ्याँबै केमैं या लदा आङ्हाँबै सैं पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","क्हिजी छ लमिंस्याँ आछ्याँबै के लब्मैंलाइ ङइ क्हिए क्ह्रोंसेंन्बै ताँमैं लोमिंब्मुँ, धै आछ्याँबै के लब्मैं क्हि ङाँइ एब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","ओ परमेश्‍वर, ङलाइ जोगेमिंबै परमेश्‍वर, ङइ म्हि सैवाइ, च पापउँइँले ङ क्षमा पिंन्, ङए पाप क्षमा लमिंबइले क्हिए मिं क्वेदै ङ क्वे प्रिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","ओ याहवेह, ङलाइ पोंल् ह्रब् लमिंन्, धै ङइ क्हिए मिंन् थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","क्हि ख्रोर सैं तोंस्याँ क्हिए मिंर ङइ ख्रो पिंमल, दिलेया मिर ख्रोंसि पिंबै ख्रोमैंरै या क्हि सैं आतों। ");
INSERT INTO gvr_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","ङ पापि ग बिसि मैंबै सैंन् परमेश्‍वरजी खोबै ख्रो ग; ओ परमेश्‍वर, ङइ आछ्याँबै के लना बिसि न्हुँ लबै म्हिलाइ क्हिजी म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","क्हिए सैंर मैंब् धोंलेन् सियोनए फिर ल्हयो खमिंन्; यरूशलेमर्बै फुयाबै गारामैं धबै रुइमिंन्; ");
INSERT INTO gvr_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","धै क्हिए सैं तोंल् लबर म्हिमैंइ ठिक ख्रोमैं पिंखब्मुँ, मिर ख्रोंसि पिंबै ख्रोमैं नेरो अरू पिंल् त्हुबै ख्रोमैं म्हिमैंइ पिंब्मुँ, छले साँडेमैं क्हिए मिंर ख्रो पिंबै क्ल्ह्‍योर पखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर। एदोम ह्‍युलर्बै दोएग शाऊल ङाँर खसि चने “दाऊद अहिमेलेकए धिंर ह्‍याइमुँ,” बिमा दाऊदइ चु मस्किल प्ह्रिइ। ओ भोंबै म्हि, आछ्याँबै केमैं लसि क्हि तले थेब् प्हैंल? क्हि तले त्हिंतिमिन् प्हैंरिम्? छाबै म्हि परमेश्‍वरजी तिफुँइ आखो! ");
INSERT INTO gvr_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","क्हि फिब्लो पार्दिसि के लमुँ, छ्यारबै छुरिइ धोंले क्हिए लेइ नास लवाबै चाँजो लम्। ");
INSERT INTO gvr_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","छ्याँबै के भन्दा आछ्याँबै के क्हिइ खोम्, धै क्ह्रोंसेंन्बै ताँ भन्दा स्योलिबै ताँमैं क्हि पोंम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","ओ फिब्लो पार्दिबै म्हि, म्हिमैंए न्होह्रों लबै ताँमैंर क्हि सैं तोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","छतसि परमेश्‍वरजी क्हिलाइ योगोर्लेन् नास लवाब्मुँ; क्हिए तम्बुउँइँलेन् खीजी क्हि चैंबोब्मुँ, सोगोंमैंए ह्‍युलउँइँले खीजी क्हि स्युसि भ्योंवाब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","छलब् म्रोंसि ठिक के लब्मैं या ङ्हिंब्मुँ; धै निस्योसि चलाइ छ बिब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“ङ्ह्‍योत्ति! परमेश्‍वरए फिर भर आलबै म्हि! चुइ ह्रोंसने मुँबै ल्हें सै न्होरए फिर भर लइ, धै अरूमैं नास लवासि भोंब तइ।” ");
INSERT INTO gvr_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","दिलेया ङ बिस्याँ परमेश्‍वरए धिंर मुँबै पिंक्यो भ्योंबै जैतुनए धुँ धोंन् तइमुँ, तलेबिस्याँ परमेश्‍वरए खोंयोंइ आनुबै म्हाँयार ङइ भर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","क्हिजी लमिंबै छ्याँबै केमैंए ल्हागिर ङ खोंयोंन् बिलै क्हिए मिंन् थेब् लब्मुँ। क्हिए मिं छ्याँब मुँ, छतसि ङइ क्हिए फिर्न भर लब्मुँ, क्हिजी बिब् ङिंब्मैंने बालुन् ङै या क्हिए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए मस्किल घ्रि। माहालत बिबै भाकार प्रिंल् त्हुम्। आमादुमैंइ ह्रोंसए सैंर “परमेश्‍वर आरे!” बिमुँ। चमैंइ आछ्याँबै केमैं लमुँ, चमैं छेरन् ङ्हाँन् तब्मैं मुँ; छ्याँबै के लब्मैं खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","ताँ क्होब्मैं नेरो परमेश्‍वर म्हैब्मैं खाबै मुँ उ बिसि परमेश्‍वरजी स्वर्गउँइँले म्हिमैंलाइ ङ्ह्‍योम्। ");
INSERT INTO gvr_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","चमैं ताँन् आछ्याँबै घ्याउँइँ प्रयाइ, धै चमैं ताँन् छेरन् ङ्हाँन् तयाइमुँ। खाबज्यै छ्याँबै के आल, छ्याँबै के लब्मैं घ्रि या आरे। ");
INSERT INTO gvr_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","चु आछ्याँबै के लब्मैंइ तोइ आसे वा? ह्‍योइ लुडिब् धोंले चुमैंइ ङए म्हिमैं लुडिसि ह्रोंसए फो न्हम्, चुमैंइ परमेश्‍वरए मिं खोंयोंइ आकिं। ");
INSERT INTO gvr_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","ङ्हिंलन् आत्हुबै क्ल्ह्‍योरै या चमैं ङ्हिंसि त्हारब्मुँ, क्हेमैंए बिरोधर राब्मैंलाइ परमेश्‍वरजी चमैंए ह्रुबि या सग्याँ-प्हुग्याँ लवाब्मुँ। तलेबिस्याँ परमेश्‍वरजी चमैं आखो; छतसि क्हेमैंइन चमैंलाइ फापिल् लल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","इस्राएलए मुक्‍ति पिंबै म्हि सियोनउँइँले युस्याँ कति छ्याँब् तमल! धै परमेश्‍वरजी ह्रोंसए म्हिमैंलाइ धबै सुख पिंमा याकूब निस्योरिगे, इस्राएल सैं तोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर बीणा-सारङ्गीं ह्रादै प्रिंबै भजन। जीपथेंमैं शाऊल ङाँर ह्‍यासि “दाऊद ङ्योए न्होंर लोइमुँ,” बिमा दाऊदइ चु मस्किल प्ह्रिइ। ओ परमेश्‍वर, क्हिए थेबै भोंइ ङ जोगेमिंन्, क्हिए शक्तिइ ङलाइ छ्याब् आरेब लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","ओ परमेश्‍वर, ङए प्राथना थेमिंन्; ङए सुँउँइँले त्होंबै ताँ फुँमैंर न्ह तोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","तलेबिस्याँ स्याँमैंइ ङए न्होह्रों लम्; ल्हयो आखब्मैंइ ङलाइ सैल् म्हैइमुँ; चमैंइ खोंयोंइ परमेश्‍वरलाइ आमैं। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","परमेश्‍वरजी खैलसेया ङलाइ ल्होमिंम्, याहवेहजी ङ जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","ङए शत्तुरमैंइ लबै आछ्याँबै केमैंए दण्ड खीजी चमैंलाइ पिंब्मुँ। ठिक निसाफ लसि क्हिजी चमैं नास लवाद्। ");
INSERT INTO gvr_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","ओ याहवेह, क्हिजी ङए ताँन् दुःखउँइँले खैलसे फ्रेमिंब्मुँ, धै ङए शत्तुरमैंए फिर ङ ट्होगों तब ङइ म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","छतसि सैं तोंदै ख्रो किंसि ङ क्हि ङाँर खब्मुँ; क्हिए मिं छ्याँब मुँ, छतसि ङइ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर बीणा-सारङ्गीं ह्रादै। दाऊदइ प्ह्रिबै मस्किल घ्रि। ओ परमेश्‍वर, ङए प्राथनार क्हिए न्ह तोमिंन्, धै ङइ यो छ्युँ लसि ग्वार ह्रिमा क्हिए लि आलोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","ङए ताँ थेमिंनु धै ङलाइ ज्वाफ पिंन्; ङए सैंर ताँ क्ल्योंसि ङ बेल्‍ले न्हुँ खइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","तलेबिस्याँ शत्तुरमैंइ ङलाइ थेबै कैले हौदिम्, धै दुष्‍टमैंइ ङलाइ क्र ओलै आपिं। चमैं ह्रिस खसि ङलाइ दुःख पिंम्; धै ङए फिर खैच्हिजिले पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","सिबन् मुँन बिब् मैंसि बेल्‍ले ङ्हिंसि ङ खैता-खैता तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","बेल्‍ले ङ्हिंसि ङ त्हारम्, छतसि ङ रेलै आखाँन् तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","“तोंगुल् धोंले प्ह्‍यागों मुँस्याँ ङ प्हुरह्‍यामल धै भों न्हमल। ");
INSERT INTO gvr_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","छले ह्रेंगो ह्‍यासि खाबै आरेबै क्‍ल्‍ह्‍योर टिमल। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","चु थेब नाँ-खैंउँइँले ह्रेंगो ङइ ग्वार योंबै क्ल्ह्‍योर ङ युन्लेन् ह्‍यामल।” ");
INSERT INTO gvr_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","दुष्‍टमैंइ सहरजरे प्होंब् नेब् नेरो सैब् म्‍लोबै केमैं लब मत्‍त्रे ङइ म्रोंइमुँ, छतसि ओ प्रभु, चमैंए क्युइ घ्रिइ पोंब घ्रिइ आक्होब लवाद्। ");
INSERT INTO gvr_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","आगुए न्होह्रों लब् बिसि चमैं त्हिंयाँ म्हुँइँस सहरर्बै गाराए फि-फि प्रप्रम्, चमैंए सुँइ आछ्याँबै ताँमैं पोंमुँ; धै चमैंए सैंइ आछ्याँबै चाँजोमैं लम्। ");
INSERT INTO gvr_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","सहरर आछ्याँबै के लबै दुष्‍टमैं ल्हें मुँ, घ्याँर प्रमैया चमैंइ स्योलिबै ताँमैं पोंसि म्हिलाइ थर्केम्। ");
INSERT INTO gvr_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","शत्तुरइन म्हि आच्हिसि पिंबै दुःखम् ङइ सैदिल् खाँमला; शत्तुरइन सैबर खस्याँम् चउँइँले ङ लोल् खाँमल, ");
INSERT INTO gvr_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","दिलेया ङलाइ दुःख पिंबै म्हिम् ङ धों तबै म्हि ङने क्ह्रिबै थुन् ग मुँन। ");
INSERT INTO gvr_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","म्हिमैंने बालु परमेश्‍वरए धिंर ह्‍यामा ङि ङ्हिंना-ङ्हिंनइन ह्रोंसए सैंर्बै ताँमैं घ्रिइ घ्रिने बिमल। ");
INSERT INTO gvr_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","थाइ आसेल्‍ले ङए शत्तुरमैं कालए सुँर फेरिगे; सोगोंन् चमैं क्रोंर ह्‍याल् त्हुरिगे; तलेबिस्याँ चमैंए सैंइ आछ्याँबै चाँजो मत्त्रे लम्। ");
INSERT INTO gvr_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","दिलेया ङ परमेश्‍वरने बिन्ति लमुँ, धै याहवेहजी ङ जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","न्हाँगर, त्हिंयाँर, ङेसर, कति त्हेर्न बिलै ङए दुःखर ङइ खीने ग्वार ह्रिमा खीजी ङए ताँ थेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","ल्हें म्हि ङए बिरोधर रासि ङने नेखलेया परमेश्‍वरजीन् ङलाइ चमैंउँइँले फ्रेसि जोगेमिंम्; छतसि चमैंइ ङलाइ तोइ लल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","खोंयोंन् बिलै राजगद्दिर क्हुँसि ग्याल्स लबै परमेश्‍वरजी ङए ताँ थेसि चमैंलाइ दण्ड पिंब्मुँ। तिस्याँदे मैंन् तलेबिस्याँ चमैं परमेश्‍वर म्रोंसि आङ्हिं, धै चमैंइ खेंमैंए आछ्याँबै बानि ब्योरै या खोंयोंइ आपि। ");
INSERT INTO gvr_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","ङए थुइ ह्रोंसने क्ह्रिबै थुमैंए फिर्न खैच्हिजी लइ; छले चइ ह्रोंसइ फैबै बाछा फुवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","चइ सुँइ लिरिक्‍क लमल, दिलेया चए सैं आछ्याँब मुँल; चइ ङ्याँ ह्‍याल्‍ले आथेलै थेथे ङ्हाँन्ले ताँ पोंमल, छले स्युट्‍टले पोंसि सेलाँइ धोंले चइ न्होह्रों लमल। ");
INSERT INTO gvr_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","क्हिए दुःखए ताँमैं याहवेहने बिद्, धै खीजी क्हि ख्वेब्मुँ; खीजी ठिक के लब्मैंलाइ खोंयोंइ नास तल् पिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","दिलेया ओ परमेश्‍वर, क्हिजी दुष्‍टमैं नास तबै होंल्दोंर भ्योंवाब्मुँ; म्हि सैब्मैं नेरो छलु म्हिलु लब्मैं आधा बैंसर्न सियाब्मुँ। दिलेया ङइ बिस्याँ क्हिए फिर्न भर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","क्वे प्रिंब्मैंए चिबलाइ, “ह्रेंगोबै तेरेबिन्थक बिबै सिंधुँर टिबै तोंगु” भाकार प्रिंन्। पलिश्‍तिमैंइ गातर दाऊद क्हाबै बारेर दाऊदइ चु मिक्‍ताम घ्रि प्ह्रिइ। ओ परमेश्‍वर, ङए फिर दयाम्हाँया लमिंन्, तलेबिस्याँ त्हिंइतिमिन् म्हिमैं ङने नेबर खम्; धै चमैंइ ङलाइ ह्रुगुदिम्। ");
INSERT INTO gvr_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","ङए शत्तुरमैंइ त्हिंइतिमिन् ङलाइ ल्हाम्; ल्हें म्हि ह्रिस उँइँदै ङने नेबर खम्। ");
INSERT INTO gvr_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","छतसि ङ ङ्हिंमा ङइ क्हिए फिर्न भर थेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","परमेश्‍वरजी पोंबै ताँमैंए बयन ङ लरिमुँ। खीए फिर्न ङइ भर लइमुँ, छतसि ङ ङ्हिंरिब् आरे। म्हिमैंइ ङलाइ तो लल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","त्हिंइतिमि चमैंइ ङइ पोंबै ताँमैंए उल्टो अर्थ ल्हैदिम्; चमैंइ खोंयोंन् बिलै ङए न्होह्रों लबै ल्हागिर चाँजोमैं लम्। ");
INSERT INTO gvr_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","ङइ आसेल्‍ले चमैंइ ङए बिरोधर आछ्याँबै चाँजो लम्; चमैंइ ङ प्रबै घ्याँ ङ्ह्‍योमुँ; ङ सैब् बिसि चमैं च्ह्‍याइ टिम्। ");
INSERT INTO gvr_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","ओ परमेश्‍वर, चमैंइ लबै आछ्याँबै केमैंए दण्ड चमैंलाइ पिंन्; क्हिए ह्रिसर चमैंलाइ क्हुरवाद्! ");
INSERT INTO gvr_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","ङइ योंबै दुःखए हिसाब-कितब थेंमिंन्, ङए मिग्लि खेरो ह्‍याल् आपिंन्। ङइ योंबै दुःखए हिसाब-कितब क्हिजी आप्ह्रिइमुँ वा? ");
INSERT INTO gvr_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","ल्होमिंन् बिसि ङइ क्हिने ग्वार ह्रिमा ङए शत्तुरमैं लिग्याँ तोसि न्हेयाब्मुँ। परमेश्‍वरजी खैलसे ङए ख लम् बिब ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","परमेश्‍वरजी पोंबै ताँमैंए बयन ङ लरिमुँ। याहवेहजी पोंबै ताँमैंए बयन ङ लरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","ङइ खीए फिर्न भर लइमुँ, छतसि ङ ङ्हिंरिब् आरे। म्हिमैंइ ङलाइ तो लल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","ओ परमेश्‍वर, ङइ क्हिने बालु लबै भकल पूरा लल् त्हुमुँ; क्हिए मिंर ङइ धन्यबादए ख्रो पिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","तलेबिस्याँ छ्ह योंब्मैंए फिर परमेश्‍वरए ह्‍वे चारब् धोंले ङए फिरै या क्हिए ह्‍वे चारमिंन्; ङ क्हिए उँइँर छेनाले प्ररिगे बिसि क्हिजी ङए प्हले थुरसि क्हुरल् आपिं, धै कालए सुँउँइँले या क्हिजी ङ फ्रेपखइ। ");
INSERT INTO gvr_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","क्वे प्रिंब्मैंए चिबलाइ, “नास आलद्” बिबै भाकार चु क्वे प्रिंन्। दाऊद शाऊलउँइँले न्हेयासि उ न्‍होंर होंबै त्हेए बारेर दाऊदइ चु मिक्‍ताम प्ह्रिइ। ङए फिर ल्हयो खमिंन्, ओ परमेश्‍वर, ल्हयो खमिंन्! क्हिए प्हलेर्न ग्वार योंबर ङ खइमुँ; चु दु:ख पिंबै सैंमैं आस्योवान् समा क्हिए प्ह्‍यागोंए न्होंर्न ङइ ग्वार योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","ङए ल्हागिर तोन्दोंरि लमिंबै ताँन् भन्दा थेबै परमेश्‍वरनेन् ङइ ग्वार ह्रिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","खीजी स्वर्गउँइँलेन् ङलाइ जोगेमिंब्मुँ; ङलाइ ह्रुगुदिब्मैंलाइ खीजी हौदिब्मुँ। तिस्याँदे मैंन् छले खीजी खीए खोंयोंइ आनुबै म्हाँया नेरो खी भर लल् खाँबै परमेश्‍वर ग बिबै ताँ ङलाइ उँइँमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","ङ सिंहमैं धों तबै म्हिमैंए म्हाँजोर मुँ; म्हिलाइ नास लबै खेदोमैंने ङ टिल् त्हुइमुँ। चुमैंए स बर्षा नेरो मे धों तब मुँ, चुमैंए ले बेल्‍ले छ्यारबै क्होज धों तब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","ओ परमेश्‍वर, क्हि मु भन्दा क्होवाइ मुँ बिसि ताँन् म्हिमैंने उँइँमिंन्; धै ह्‍युल् तिगोंन् क्हिए थेबै मिंए बयन तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","ङए प्हले क्होसि क्हुरयारिगे बिसि शत्तुरमैंइ जाल तिइमुँ; शोकइ लमा ङए क्र कुरयाइमुँ। ङ प्रल् त्हुबै घ्याँजरे चमैंइ होंल्दों ताइमुँ, दिलेया चमैंइ ताबै होंल्दोंर खेंमैंन् पायाइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","ओ परमेश्‍वर, ङइ क्हिए फिर्न भर लइमुँ, ङइ क्हिए फिर्न भर लइमुँ। छतसि ङ बाजा ह्रादै क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","ओ ङए ज्यु, छोरद्! ओ बीणा नेरो सारङ्गी, क्ह्‍युरल्‍ले कै तेद्! तलेबिस्याँ नाँ न्होंन बिब सेरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","ओ याहवेह, अरू ह्रेंमैंए म्हाँजोर ङ क्हिए मिं थेब् लब्मुँ; धै ह्‍यु-ह्‍युलर ह्‍यासि क्हिए मिंर क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","तलेबिस्याँ क्हिए खोंयोंइ आनुबै म्हाँया स्वर्ग भन्दा थेब् मुँ, क्हिजी पोंबै ताँमैं भर लल् खाँब मुँ, धै क्हिए भर लल् खाँबै ताँमैंइ मुन् छुइनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","ओ परमेश्‍वर, क्हि मु भन्दा क्होवाइ मुँ बिसि ताँन् म्हिमैंने उँइँमिंन्! क्हिए थेबै मिंए बयन ह्‍युल् तिगोंन् तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर, “नास आलद्” बिबै भाकार प्रिंब। दाऊदइ प्ह्रिबै मिक्‍ताम घ्रि। ओ क्रथे मिंथेमैं, क्ह्रोंसेंन्लेन् क्हेमैंइ स्योर आतेल्‍ले ठिक ताँमैं मत्‍त्रे पोंम्‍मा? क्हेमैंइ म्हिमैंए फिर ठिक निसाफ लम्‍मा? ");
INSERT INTO gvr_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","आल! आछ्याँबै चाँजोमैं लसि; ह्‍युलर क्हेमैंइ सैब्-म्‍लोब् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","आमाए फो न्होंउँइँलेन् दुष्‍ट म्हिमैंइ आछ्याँबै ताँ मैंम्; फिबै तोदोंन् चमैं आछ्याँबै घ्याँउँइँ प्रसि स्योलिबै ताँमैं पोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","चमैंए ताँ प्हुरिए म्येकैं धोंन् तम्। न्ह आथेबै साँबे प्हुरिइ धोंले चमैंइ खेंमैंए न्ह म्रुम्। ");
INSERT INTO gvr_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","जादु लब्मैंइ क्ह्‍युरल्‍ले साँने ह्रासि प्हुरि हुइलेया प्हुरिइ थेल् आङिं। छलेन च म्हिमैंइ थेबै न्ह आल। ");
INSERT INTO gvr_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","ओ परमेश्‍वर, चमैंए स चमैंए सुँ न्होंर्न चोवामिंन्; ओ याहवेह, च सिंहमैं धों तबै दुष्‍टमैं म्हिमैंए काँस पोंवामिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","चैबै क्यु सर्न म्हयाब् धोंलेन् चमैंए मिं क्ह्रन् म्हयारिगे; चमैंइ त्हलेर मे झोंमा मे बोदो तयारिगे। ");
INSERT INTO gvr_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","प्रना-प्रन् च्युँयाबै कबो धोंले चमैं म्हयारिगे, म्हैंन आयोबर्न प्युलुयाबै कोलोइ धोंले चमैंइ खोंयोंइ त्हिंयाँ आम्रोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","पिंग्या मुँले कारयाब मुँलेया पुजु युनन् लुँसि क्हेमैंए भाँडोमैं लाब् भन्दा ओंसोंन् परमेश्‍वरजी दुष्‍ट म्हिमैं नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","छले पापिमैंइ दण्ड योंब् म्रोंसि ठिक के लब्मैं सैं तोंब्मुँ; धै दुष्‍ट म्हिमैंए कोर चमैंइ प्हले ख्रुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","छाब् म्रोंसि “ठिक के लब्मैंइ क्ह्रोंसेंन इनाम योब् मुँन; धै पृथ्‍बीर ठिक निसाफ लब परमेश्‍वर मुँन,” बिसि म्हिमैंइ बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर, “नास आलद्” बिबै भाकार प्रिंन्। शाऊलइ दाऊद सैबर म्हिमैं चए धिं ङ्ह्‍योबर कुल्मिंमा दाऊदइ चु मिक्‍ताम प्ह्रिइ। ओ ङए परमेश्‍वर, ङए शत्तुरमैंउँइँले ङ फ्रेमिंन्; ङए बिरोधर राब्मैंउँइँले ङ रक्षा लमिंन्; ");
INSERT INTO gvr_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","आछ्याँबै के लबै दुष्‍टमैंउँइँले ङ फ्रेमिंन्, ङलाइ सैल् म्हैबै म्हिमैंउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","ङ्ह्‍योद्! ङलाइ सैबर चमैं ह्रेसि टिइमुँ; चमैं ङए बिरोधर रासि “खैले चलाइ सैल् योंब् ङ्‍हे?” बिसि ङलाइ च्ह्‍याइ टिइमुँ। दिलेया ओ याहवेह, ङइ तोइ अपराध, तोइ पाप आलइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","ङइ आछ्याँबै के तोइ आललै या चमैं तोन्-तोर्न ङने नेबर खम्। ङए दुःख ङ्‍ह्‍योमिंन्, रेसि ङलाइ ल्होमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","ओ ताँन् भन्दा थेबै याहवेह परमेश्‍वर, इस्राएलए परमेश्‍वर, क्हिलाइ आम्हाँदिबै ह्रेंमैंए फिर दण्ड पिंबर रेद्; धोक पिंबै दुष्‍ट म्हिमैंए फिर तिफुँइ ल्हयो आखद्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","ङ्हुर-ङ्हुरले ङ्हेदै नगि स्युरब् धोंले ङेस ह्रोंसे खागु तसि चमैं सहरजरे स्युरम्। ");
INSERT INTO gvr_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","ङ्ह्‍योद्, चमैंए सुँउँइँले तो त्होंमुँ? चमैंए ले सेलाँ धों तब् मुँ; चमैंए सैंर “ङिइ छ बिब खाबज्यै आथेइमुँ!” ङ्हाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","दिलेया ओ याहवेह, च शत्तुरमैंलाइ क्हिजी प्ह्रब्मुँ; ताँन् अरू ह्रेंमैं म्रोंसि क्हि निस्योब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","ओ ङए भों, ङ क्हिलाइन ङ्ह्‍योब्मुँ, तलेबिस्याँ, ओ परमेश्‍वर क्हि ङए किल्‍ला ग। ");
INSERT INTO gvr_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","परमेश्‍वरए खोंयोंइ आनुबै म्हाँया ङए फिर थेब मुँ। खी ङए ओं-ओंसों ह्‍याब्मुँ, धै ङए बिरोधर राब्मैंलाइ ङइन ट्होल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","दिलेया ओ याहवेह, ङिए ढाल, चमैं आसैमिंन्, आस्याँ ङए म्हिमैंइ चमैंलाइ म्‍लिवाब्मुँ; बरु क्हिए थेबै भोंइ चमैंलाइ सग्याँ-प्हुँग्याँ लवासि ट्होवाद्! ");
INSERT INTO gvr_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","चमैंए सुँर्बै पाप नेरो म्हदेर्बै ताँफुँमैंइ लमा चमैं थेब् प्हैंबइले ङोर फेरिगे। चमैंइ प्ह्रबै ताँमैं नेरो स्योलिबै ताँमैं लमा ");
INSERT INTO gvr_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","क्हिए ह्रिसइ चमैं नास लवामिंन्, चमैं तोइ आचैल्‍ले नास लवामिंन्! छलेन परमेश्‍वरजी इस्राएलए फिर ग्याल्स लमिंम् बिब पृथ्‍बीर्बै ताँन् साँदर टिबै ह्रेंमैंइ सेरिगे। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","ङ्हुर्-ङ्हुरले नगि स्युरब् धोंले ङेस ह्रोंसे खागु तसि चमैं सहरजरे स्युरम्। ");
INSERT INTO gvr_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","चब सैमैं म्हैबर चमैं स्युर प्रम् धै म्रेंन्ले चल् आयोंमा चमैं ओरम्। ");
INSERT INTO gvr_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","दिलेया ङ बिस्याँ क्हिए शक्‍तिए क्वे प्रिंब्मुँ; ङए फिर क्हिजी लबै खोंयोंइ आनुबै म्हाँयाए बारेर ङ न्हाँगर्न क्वे प्रिंब्मुँ, तलेबिस्याँ क्हि ङए किल्‍ला नेरो ङए फिर दुःख तमा ङइ ग्वार योंबै क्‍ल्‍ह्‍यो तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","ओ ङए भों, क्हिए बयन लदै ङ क्वे प्रिंब्मुँ, ओ परमेश्‍वर, क्हि ङए किल्‍ला, नेरो ङलाइ खोंयोंइ आनुबै म्हाँया लबै परमेश्‍वर ग। ");
INSERT INTO gvr_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर, “शुशान-एदथ” बिबै भाकार प्रिंब। दाऊदइ अरम-नहरैम नेरो अरम-जोबाहने बालु नेइ, धै योआबइ एसि चजए ब्याँसिर हजार च्युसे ङ्हिं एदोमिमैं सैइ। च त्हेरि दाऊदइ चु मिक्‍ताम लोमिंबै ल्हागिर प्ह्रिइ। ओ परमेश्‍वर, क्हिजी ङि पिवाइमुँ, क्हिजी ङि सग्याँ-प्हुँग्या लवाइमुँ; ङि म्रोंसि क्हि ह्रिस खइमुँ, दिलेया तारेम् क्हि ङि ङाँइ तोमिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","क्हिजी ङिए ह्‍युललाइ थर्केसि क्ल्हेवाइमुँ। चर्बै होंल्दोंमैं म्यालमिंन्, तलेबिस्याँ च त्हाररिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","क्हिजी ह्रोंसए म्हिमैंए फिर सैदिलै आखाँबै दुःख तल् पिंइमुँ; छलमा क्हिजी ह्रिस खसि ङिलाइ म्हेरबै प्हा थुँल् पिंब् धोंले ङिए प्हलेमैं छेनाले म्हैल् आखाँब् तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","दिलेया मेत्हलेमैं छेब्मैंउँइँले जोगेबै ल्हागिर क्हिलाइ मान लब्मैंए ल्हागिर क्हिजी झन्डा घ्रि क्योमिंइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","क्हिजी म्हाँया लब्मैं दु:खउँइँले फ्रेमिंबर क्हिए क्योलो योजी ङि जोगेमिंन्, ङिए प्राथना ज्वाफ पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","“शकेमलाइ ट्होसि ङइ चुमिंब्मुँ, धै सुक्‍कोतर्बै ब्याँसि च्हैंसि स्यो-स्यो लब्मुँ,” बिसि परमेश्‍वरजी ह्रोंसए पबित्र क्‍ल्‍ह्‍योउँइले बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","“गिलाद ङल् ग, मनश्शे या ङलन् ग; एफ्राइम ङए मुकुट ग, यहूदा ङए ल्हागिर म्रुँइ छेबै प्हरे धों तब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","मोआब ङए ल्हागिर यो प्हले ख्रुबै क्‍ल्‍ह्‍यो ग, एदोमए फिर ङइ ह्रोंसए जुत्ता भ्योंमुँ; पलिश्तए फिर ङ ट्होगों तसि ओरम्।” ");
INSERT INTO gvr_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","खाबइ ङलाइ किल्‍ला मुँबै सहरर बोमिंब् ङ्‍हे? एदोम समा खाबइ ङ डोरेमिंब् ङ्‍हे? ");
INSERT INTO gvr_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","ओ परमेश्‍वर, क्हिजीन् ङिलाइ पिवाइ, आङिं वा? तारे ङिए सिपाइमैंने बालु आह्‍या वा? ");
INSERT INTO gvr_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","शत्तुरमैंने नेल् त्हुमा ङि ल्होमिंन्, तलेबिस्याँ म्हिमैंइ ल्होल् आखाँ! ");
INSERT INTO gvr_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","परमेश्‍वरउँइँले मत्‍त्रे ङ्योइ ट्होल् खाँब्मुँ, तलेबिस्याँ ङ्योए शत्तुरमैं प्लेवाब खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर गिटार-सारङ्गींमैं ह्रादै प्रिंबै दाऊदए भजन। ओ परमेश्‍वर, ङइ ग्वार ह्रिब थेमिंन्, ङए प्राथना छेनाले थेमिंन्; ");
INSERT INTO gvr_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","ङ‍ए सैं आतेसि पृथ्बीए छ्योगोउँइँले ङइ क्हिने ग्वार ह्रिमा, ङ भन्दा थेबै पारार डोरेमिंन्, ");
INSERT INTO gvr_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","तलेबिस्याँ ङए ग्वार योंबै क्‍ल्‍ह्‍यो नेरो शत्तुरमैंउँइँले जोगेल् योंबै भोंबै धरर क्हिन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","खोंयोंन् बिलै क्हिए तम्बुर ङलाइ टिल् पिंन्! क्हिए प्ह्‍यागोंमैंइ ङए रक्षा लद्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","तलेबिस्याँ ओ परमेश्‍वर, क्हिने बालु ङइ फैबै भकलमैं क्हिजी थेइमुँ; क्हिलाइ मान लब्मैंइ योंल् त्हुबै सैमैं क्हिजी ङलाज्यै या पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","म्रुँए छ्ह ह्रिंग्यो लमिंन्; च खोंयोंन् बिलै सोरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","च परमेश्‍वरए ओंसों खोंयोंन् बिलै राजगद्दिर टिरिगे; क्हिजी खोंयोंइ आनुबै म्हाँया लबइले नेरो च क्हिए फिर भर लल् खाँबइले चए रक्षा लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","झाइले दिन ह्रोसे क्हिने फैबै भकल ङइ पूरा लमा ङ क्हिए मिं खोंयोंन् बिलै थेब् लसि क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","क्वे प्रिंब्मैंए चिब यदूतूनएल्हागिर दाऊदए भजन घ्रि। क्ह्रोंसेंन ङए सोइ परमेश्‍वरर मत्‍त्रे भों न्हल् योंम्; खीजी ङ जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","खी मत्‍त्रे ङ रक्षा लमिंबै पारा, नेरो ङए किल्‍ला ग, छतसि ङ ङ्हिंसि त्हाररिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","खोंयों समा क्हेमैंइ म्हिए न्होह्रों लरिमुँ? फुयाबै गारा नेरो आभोंबै बार धों तबै म्हिलाइ क्हेमैं ताँन् त्हुँसि क्र ओलै आखाँन् लब् वा? ");
INSERT INTO gvr_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","चए थेबै पदउँइँले चलाइ क्युरु तवाबर चमैंइ मत्‍त्रे आछ्याँबै ताँ मैंरिम्। चमैं स्योलिबै ताँमैंर सैं तोंम्। चमैंए सुँइ आशिक पिंमुँ, सैं न्होंर बिस्याँ सराप पिंम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","छतसि ओ ङए सो, परमेश्‍वरर मत्‍त्रे भों न्हद्; ङए आशा खीजीन् पूरा लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","खी मत्‍त्रे ङ रक्षा लमिंबै पारा नेरो ङए किल्‍ला ग; छतसि ङ ङ्हिंसि त्हाररिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","परमेश्‍वरए फिर बिश्‍वास लसि ङइ मुक्‍ति नेरो मान योंमुँ। ङए भोंबै पारा नेरो ङए ग्वार योंबै क्‍ल्‍ह्‍यो परमेश्‍वरन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","छतसि ओ म्हिमैं, खोंयोंन् बिलै खीनेन् भर थेंन्; खीए ओंसों ह्रोंसए सैंर्बै ताँ बिद्; तलेबिस्याँ ङ्योए ग्वार ह्रिबै क्‍ल्‍ह्‍यो परमेश्‍वर ग। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","आयोब् आख्युब्मैं मुट्ठि घ्रि सो मत्‍त्रे ग, प्लब्मैं या तोइ केर आफे, तलेबिस्याँ पारर क्वेमा चमैं योंयाम्, चमैं ङ्हिंना-ङ्हिंन् मुट्ठि घ्रि सो मत्‍त्रे ग। ");
INSERT INTO gvr_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","धुदिबै केर भर आतद् धै ह्‍योबै सैर थेब् आप्हैंन्; क्हिए सै न्होर ल्हें तलेया चए फिर भर आथेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","परमेश्‍वरजी ताँ घ्रि पोंइमुँ, ङइ ल्हें खे च ताँ थेइमुँ: ओ परमेश्‍वर, क्हि बेल्‍ले भोंब मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","ओ याहवेह, क्हिजी खोंयोंइ आनुबै म्हाँया लमुँ। तलेबिस्याँ क्हिजी ताँन् म्हिमैंलाइ ह्रों-ह्रोंसइ लबै के अन्सार्बै नों सै पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","दाऊद यहूदा ह्‍युलर्बै क्यु आयोंबै क्‍ल्‍ह्‍योर टिमा खीजी प्ह्रिबै भजन घ्रि। ओ परमेश्‍वर, क्हि ङए परमेश्‍वर ग; ङए सैं न्होंइले क्हिए साँ खरिम्, क्यु आरेसि कारयाबै बाँजो क्‍ल्‍ह्‍योर क्यु पिब्मैंइ क्यु म्हैब् धोंले ङए ज्युइ क्हिलाइन म्हैब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","पबित्र क्‍ल्‍ह्‍योर ङइ क्हिलाइ म्रोंइमुँ, क्हि शक्‍ति मुँब नेरो बेल्‍ले म्हारब ङइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","ङए ल्हागिरि क्हिए खोंयोंइ आनुबै म्हाँया छ्ह भन्दा थेब मुँ, छतसि ङए म्हदिइ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","ङए छ्ह तिगोंन् क्हिलाइन थेब् लब्मुँ, धै क्हिए मिंर ङ ह्रोंसए यो क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","लिंबै चबै सैमैं चसि म्रेंब् धोंले ङए सो छिं ङ्हाँब्मुँ, ङए सुँइ सैं तोंबै क्वेमैं प्रिंसि क्हिलाइन थेब् लब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","रोबै क्‍ल्‍ह्‍योर ङइ क्हिलाइन मैंम्, धै म्हुँइँस तिमिंन् ङ क्हिलाइन मैंरिम्, ");
INSERT INTO gvr_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","तलेबिस्याँ क्हिजी ङ ल्होमिंइमुँ, छतसि ङ क्हिए प्ह्‍यागोंमैंए छरि न्होंर सैं तोंसि क्वे प्रिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","ङए सो क्हिए कुगु न्होंर टिरिम्; क्हिए क्योलो योजी ङ ख्वेसि जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","ङलाइ सैल् म्हैब्मैं बिस्याँ क्रोंर फेनेसि नास तयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","सेलाँइ चमैंलाइ सैवाब्मुँ, धै सेलमैंए चबै सै तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","परमेश्‍वरजी लबै के म्रोंसि म्रुँ सैं तोंरिब्मुँ। खीए मिंर कसम चब्मैंइ खीलाइन थेब् लरिब्मुँ, दिलेया स्योर तेब्मैंए सुँ म्रुवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदइ प्ह्रिबै भजन घ्रि। ओ परमेश्‍वर, ङइ ग्वार ह्रिमा ङए ताँ थेमिंन्, शत्तुरमैं म्रोंसि ङ ङ्हिंइमुँ, छतसि ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","ङए बिरोधर ङइ आसेल्‍ले दुष्‍टमैंइ लबै चाँजोमैं नेरो आछ्याँबै के लब्मैंइ ङए बिरोधर रोबै जालउँइँले ङलाइ लोथेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","सेलाँर धार झोंब् धोंले चमैंइ खेंमैंए लेर धार झोंमुँ, मे त्हँलेइ ल्हिब् धोंलेन् चमैंइ पोंबै ताँमैंइ म्हिए सैं नल् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","तोइ दोष आरेब्मैंलाज्यै या चमैंइ तो धोंइ आङ्हाँन्ले दोष ल्हैदिब्मुँ। छले आगुए फिर खैच्हिजिले पोंसेया चमैंए सैंर तोइ आङ्हाँ। ");
INSERT INTO gvr_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","आछ्याँबै केमैं लबर चमैंइ खें-खेंमैंए न्होंर घ्रिइ घ्रिलाइ भों पिंमुँ। खाबज्यै आसेल्‍ले ङो चुले बिसि चमैं क्ह्रिसि मत लमुँ। “ङ्योइ लबै चु के खाबइ म्रोंम्‌ रो?” बिसि चमैंइ बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","म्हिमैंए सैं कति आछ्याँब् तमना, चमैंइ आगुए न्होह्रों लबै जाल रोमुँ, दिलेया “ङिइ ठिक चाँजोमैं लइमुँ,” बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","दिलेया परमेश्‍वरजी चमैंए फिर मे त्हलेइ ल्हिब्मुँ, धै चमैं था आसेल्‍ले घायते तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","चमैंइ पोंबै ताँ खेंमैंए फिर्न खीजी एखल् लब्मुँ, धै चमैं नास लवाब्मुँ। झाइले चमैंलाइ म्रोंम्मैं ताँनइ प्ह्रदै क्र लाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","छतब् म्रोंसि ताँन् ह्रेंर्बै म्हिमैं ङ्हिंब्मुँ, चमैंइ परमेश्‍वरजी लबै केए बयन लब्मुँ, धै खीजी लबै केमैं छेनाले क्होल् म्हैब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","ठिक के लब्मैं याहवेहनेन् सैं तोंब्मुँ, धै खीए प्हलेर्न ग्वार योंम्। सोजो म्हिमैं ताँनइ खीए मिं थेब् लब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि, क्वे घ्रि। ओ परमेश्‍वर, सियोनर ङिइ क्हिए मिं क्वेब्मुँ, छले क्हिने फैबै ताँन् भकलमैं ङिइ पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","ओ प्राथना थेमिंबै परमेश्‍वर, क्हिए प्हलेर्न ताँन् म्हिमैं खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","ङिइ छेरन् ङ्हाँबै केमैं लसि पापर प्ल्हुँरिम ङिए अपराधमैं क्हिजी क्षमा लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","क्हिजी त्हाँबै म्हिमैंइ आशिक योंम्, धै क्हिजी चमैंलाइ क्हि ङाँर पखसि क्हिए धिंर्बै ह्‍युर टिल् पिंम्! क्हिए धिंर्बै लिं-लिंबै सैमैं नेरो क्हिए पबित्र धिंर मुँबै आशिकमैंइ ङिं बेल्‍ले सैं तोंल् लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","ओ ङिलाइ जोगेमिंबै परमेश्‍वर, क्हिजी ठिक के लमा थेब्-थेबै केमैंउँइँले ङिलाइ ज्वाफ पिंम्। पृथ्‍बीर्बै ताँन् साँदर टिबै ह्रेंमैं नेरो ह्रें-ह्रेंगोर्बै मा ङ्युँइए रेजरेबै ताँन म्हिमैंइ क्हिए फिर्न आशा थेंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","क्हिजी ह्रोंसए भोंउँइलेन् नुबै कोंमैं बनेइ, थे-थेबै के लबै शक्‍ति क्हिनेन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","थेबै कैले ङ्‍हेबै मा ङ्युँइ नेरो चर्बै भेल्गमैं ङ्‍हेब, नेरो ह्रें-ह्रेंमैंइ लबै खैला-बैला क्हिजीन् च्याँ लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","क्हिजी लबै थे-थेबै केमैं म्रोंसि ह्‍युल तिगोंर्बै म्हिमैं ङ्हिंम्। न्हाँग तमा ङेसा तमा क्हिजी म्हिमैं सैं तोंदै क्वेमैं प्रिंल् पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","क्हिजी पृथ्बीए वास्ता लमुँ, धै नाँ कुलमिंसि स प्हाँमिंमुँ, क्हिजी चर ल्हें रा-रोमैं रोमिंमुँ। म्हिमैंए ल्हागिर चबै सैमैं योंरिगे बिसि परमेश्‍वरए स्योंमैं क्युइ प्लिंरिमुँ, तलेबिस्याँ क्हिजी छान् तरिद् बिल। ");
INSERT INTO gvr_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","क्ल्योबै क्ल्ह्‍योए छेउ समन् क्हिजी छेनाले क्युइ क्योमिंम्। नाँ कुलसि स ङ्याल-ङ्याल लमिंम्, झाइले क्हिजी चर ल्हें रोमैं रोल् पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","क्हिजी ठिक त्हेर ल्हें रा-रोमैं योंल् पिंम्। धै क्हिए भकारिमैं खोंयोंन् बिलै प्लिंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","तोइ आकेबै क्ल्ह्‍योरै या पिंक्योले छिमैंइ प्लिंइमुँ, धै कोंमैं सैं तोंइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","खर्कमैं र-क्युमैंइ प्लिंइमुँ, धै ब्याँसिमैं रा-रोमैंइ प्लिंइमुँ। छतसि ताँन् क्ह्रिमा चमैंइ कै तेसि सैं तोंदै क्वे प्रिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर भजन, क्वे घ्रि। ओ पृथ्बीर मुँबै तोंन्दोरि सैमैं, सैं तोंदै परमेश्‍वरए जयजय लद्। ");
INSERT INTO gvr_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","खीए मिं थेब् लसि क्वे प्रिंन्, खीए मान् लदै छेनाले क्वे प्रिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","“क्हिजी लबै केमैं औदिले छ्याँब मुँ!” बिसि परमेश्‍वरने बिद्। “क्हिए शक्ति बेल्‍ले थेब् मुँ, छतसि क्हिए शत्तुरमैं ङ्हिंसि क्हिए उँइँर कुरम्। ");
INSERT INTO gvr_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","पृथ्बीर मुँबै तोंन्दोरि सैमैंइ क्हिए प्हले फ्योम्, चमैंइ क्हिलाइन थेब् लदै क्वे प्रिंम्, चमैंइ क्हिए मिं थेब् लदै क्वे प्रिंम्।” तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","खो, परमेश्‍वरजी लबै केमैं ङ्‍ह्‍योद्, म्हिमैंए ल्हागिर खीजी लबै केमैं औदिले छ्याँब् मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","खीजी मा ङ्युँइर ओबनो क्‍ल्‍ह्‍यो लमिंइ; धै चमैं प्हलेइ प्रसिन् मा ङ्युँइए क्योंज ह्‍याइ। खो, खीजी लबै के ङ्ह्‍योसि ङ्यो सैं तोंले। ");
INSERT INTO gvr_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","खीजी ह्रोंसए भोंइन खोंयोंन् बिलै ग्याल्स लरिम्, खीजी अरू ह्रेंमैंए फिर ङ्‍ह्‍योरिम्। छतसि खीए बिरोधर राब्मैं थेब् आप्हैंरिगे। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","ओ ह्रें-ह्रेंर्बै म्हिमैं, ङ्योए परमेश्‍वरए मिंर क्वे प्रिंन्; खीए मिं क्वेब खन्तोदोंर्बै म्हिमैंइ थेरिगे, ");
INSERT INTO gvr_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","खीजी ङ्योए सो जोगेथेंइमुँ, धै ङ्योए प्हले प्लेल् आपिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","ओ परमेश्‍वर, क्हिजी ङिए जाँच् लइमुँ, क्हिजी ङि चाँदि धोंले खार्दिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","क्हिजी ङि ङोर फेल् पिंजी; धै ङिए क्होर ल्हिबै ति नोल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","क्हिजी म्हिमैंलाइ ङिए क्र फिर प्लेल् पिंइ, ङि मि नेरो क्युउँइँले तसि ह्‍याइ, दिलेया क्हिजी छ्याजाल्हुलु तबै क्‍ल्‍ह्‍योर ङि पखमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","ङ क्हिए मन्दिरर मिर ख्रोंसि पिंबै ख्रोमैं किंसि खब्मुँ; धै क्हिने लबै भकल पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","ङ दुःखर मुँबै त्हेर ङइ क्हिने लबै भकल पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","ङइ क्हिए मिंर छोबै खेदोमैं मिर ख्रोंसि ख्रोमैं पिब्मुँ, क्यु साँडेमैं ख्रोंसि ङ ख्रो पिंखब्मुँ; क्ल्या भारामैं नेरो र-बुग्यामैं ङइ क्हिए मिंर ख्रो पिंब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","परमेश्‍वरलाइ मान लब्मैं, ताँन् खसि थेद्, ङए ल्हागिर खीजी लमिंबै केमैं ङलाइ बिल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","ङए सुँइ खीने ग्वार ह्रिइ, धै ङए लेइ खीए मिं क्वेइ। ");
INSERT INTO gvr_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","ङए सैंइ पाप मैंरिस्याँ परमेश्‍रजी ङए ताँ आथेमल। ");
INSERT INTO gvr_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","दिलेया परमेश्‍वरजी ङए ताँ खैलसे थेमिंइमुँ, खीजी ङए प्राथना छेनाले थेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","परमेश्‍वरए मिं थेब् तरिगे! खीजी ङए प्राथना थेमिंइमुँ, धै खीए खोंयोंइ आनुबै म्हाँया ङउँइँले आस्योइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर बीणा-सारङ्गींमैं ह्रादै प्रिंबै। भजन घ्रि, क्वे घ्रि। ह्‍युलर्बै ताँन् म्हिमैंइ ङो सेरिगे धै क्हिजी जोगेमिंम् बिबै ताँ ताँन् ह्रेंमैंइ था सेरिगे बिसि ");
INSERT INTO gvr_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","परमेश्‍वरजी ङ्योए फिर दयाम्हाँया लरिगे, ङ्योए फिर आशिक पिंरिगे, धै खीए लि ङ्योए फिर चारमिंरिगे! तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","ओ परमेश्‍वर, ताँन् ह्रेंमैंइ क्हिलाइन थेब लरिगे, ताँन् ह्रेंमैंइ क्हिलाइन थेब लरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","क्हिजी ह्रें-ह्रेंमैंए फिर ठिक निसाफ लमुँ, धै ह्‍युलर्बै ह्रें-ह्रेंमैं घ्याँ तेंमिंम्। छतसि ह्रें-ह्रेंमैं सैं तोंरिगे धै छिं ङ्हाँसि क्वे प्रिंरिगे! तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","ओ परमेश्‍वर, ह्रें-ह्रेंमैंइ क्हिलाइन थेब लरिगे, ताँन् ह्रेंमैंइ क्हिलाइन थेब लरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","परमेश्‍वरजी ङ्योए फिर आशिक पिंब्मुँ, छतसि सइ ल्हें रोमैं रोमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","पृथ्‍बीर्बै ताँन् साँदर टिबै ह्रेंमैंइ परमेश्‍वर ङ्हिंरिगे बिसि खीजी ङ्योए फिर आशिक पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि, क्वे घ्रि। परमेश्‍वर रेब्मुँ, खीए शत्तुरमैं सग्याँ प्हुँग्याँ लवाब्मुँ, धै खीलाइ आखोब्मैं खीउँइँले न्हेयाब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","खैले खैंइ मिगु बोमु, छलेन क्हिइ चमैंलाइ बोब्मुँ; मिए ङाँर क्योलों युलियाब् धोंले परमेश्‍वरए उँइँर आछ्याँबै के लब्मैं नास तयाब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","दिलेया ठिक के लब्मैं बिस्याँ सैं तोंरिब्मुँ; चमैं परमेश्‍वरए उँइँर सैं तोंरिगे; चमैं सैं तोंबै कै तेरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","परमेश्‍वरए मिंर क्वे प्रिंन्, खीए मिं थेब् लबै क्वे प्रिंन्; न्हाँम्स्योमैंए फिर क्रेसि स्युरबै परमेश्‍वरलाइ थेब् लद्; खीए मिं याहवेह ग; खीए उँइँर सैं तोंन्! ");
INSERT INTO gvr_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","ह्रोंसए पबित्र क्‍ल्‍ह्‍योर टिबै परमेश्‍वर आबा आरेब्मैंए आबा ग, धै खीजी म्हरेस्योमैंलाइ रक्षा लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","खाबै आरेबै म्हिमैंलाइ खीजी परवा पिंम्; झेलर मुँब्मैंलाइ तेसि सैं तोंल् पिंम्; दिलेया परमेश्‍वरजी बिब् आङिंब्मैं बिस्याँ त्हिंयाँइ ख्रोंबै क्‍ल्‍ह्‍योर टिम्। ");
INSERT INTO gvr_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","ओ परमेश्‍वर, क्हिजी ह्रोंसए म्हिमैं खैले डोरेमिंजी, छलेन क्हि तोइ आरेबै क्‍ल्‍ह्‍योउँइँले तसि ओंसों ह्‍याइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","च त्हेर सिनै बिबै कोंर युबै परमेश्‍वरए उँइँर, इस्राएलए परमेश्‍वरए उँइँर, पृथ्बी त्हारइ, मुउँइँले नाँ युइ। ");
INSERT INTO gvr_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","ओ परमेश्‍वर, क्हिजी नाँ कुलसि कारबै क्‍ल्‍ह्‍यो क्योसि छ्याँब् लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","क्हिए म्हिमैं च क्‍ल्‍ह्‍योर टिइमुँ, धै खीजी ङ्हाँदुमैंलाइ छ्याँबै सैमैं पिंसि सैं तोंल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","ल्हडें लबर ह्‍याद् बिसि याहवेहजी ताँ लइ। धै “म्रुँमैं नेरो चमैंए सिपाइमैं युनन् न्हेयाइ!” बिसि ल्हें च्हमिरिमैंइ ताँ लइ। ");
INSERT INTO gvr_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","धिंर पखबै सैमैं च्हमिरिमैंइ चुम्। ");
INSERT INTO gvr_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","चमैंइ पखबै सैमैं न्होंर कोइ चाँदिइ म्होरबै तोंगुए प्ह्‍यागोंमैं नेरो छ्याँबै माराइ म्होरबै चए प्ह्‍यागोंमैं मुँल। (दिलेया क्हेमैं को-कोइ मुँयुँमैं ल्हडें लबै त्हेर तले क्यु प्ह्रोंर टिरिल?) ");
INSERT INTO gvr_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","तोनदोंरि लल् खाँबै परमेश्‍वरजी म्रुँमैंलाइ ह्‍युलर खन्तोदोंन् प्हुँवामा साल्मोन बिबै कोंर क्लि झोंब् धों तल। ");
INSERT INTO gvr_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","बाशान बिबै कों बेल्‍ले छ्याँब् मुँ; च कोंर क्लिं क्हाँ मुँबै च्होमैं ल्हें मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","ओ ल्हें च्होमैं मुँबै कों, परमेश्‍वरजी ग्याल्स लल् म्हैबै सियोन बिबै कोंउँइँ तले आछ्याँबै सैंले ङ्ह्‍योल? चर याहवेह खोंयोंन् बिलै टिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","परमेश्‍वरए रथमैं लाख लाख करोड करोड मुँ! सिनै कोंउँइले प्रभु ह्रोंसए पबित्र क्‍ल्‍ह्‍योर युइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","क्हि नुबर क्रे ह्‍यामा क्हाइ बोब्मैंलाइ क्हिए लिलि बोइ, क्हिजी म्हिमैंउँइँले क्होल्सै किंइ, ओं, क्हिजी बिब् आङिंब्मैंउँइँले या किंइ। छलेन याहवेह पारमेश्‍वर चर टिम्। ");
INSERT INTO gvr_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","प्रभुए मिं थेब् तरिगे! ङ्योलाइ जगेमिंबै परमेश्‍वर खीन् ग, त्हिंइ ह्रोंसे ङ्योए दुःख खीजी नोमिंम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","ङ्योए परमेश्‍वर जोगेमिंबै परमेश्‍वर ग। याहवेह ङ्योए प्रभु ग, खीजीन् ङ्योलाइ सिबउँइले सोगों लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","क्ह्रोंसेंन ह्रोंसए शत्तुरमैंए क्र परमेश्‍वरजी तिवाब्मुँ, पापर प्ररिब्मैंए क्र कोच्याब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","“क्हेमैंइ ह्रोंसए प्हले ङए शत्तुरमैंए कोर प्ल्हुँरिगे, धै क्हेमैंए नगिमैंए लेइ चमैंए को ल्हेंल् योंरिगे बिसि ");
INSERT INTO gvr_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","ङजी च शत्तुरमैं बाशान बिबै क्ल्ह्‍योउँइँले एपखब्मुँ; ङजी चमैं मा ङ्युँइए न्होंउँइँले पखब्मुँ,” बिसि याहवेहजी बिल। ");
INSERT INTO gvr_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","ओ परमेश्‍वर, क्हिजी ट्होसि खब ताँनइ म्रोंइमुँ! ङए परमेश्‍वर ङए म्रुँ ग! क्हिजी ट्होसि पबित्र क्‍ल्‍ह्‍योर युइ। ");
INSERT INTO gvr_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","ओंसों ओंसों क्वे प्रिंब्मैं मुँ, चमैंए लिलि बाज ह्राब्मैं, चमैंए म्हाँजोर खैजरि ह्राबै छमिमैं मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","“ल्हें म्हि च्होंबै क्ल्ह्‍योर परमेश्‍वरए मिं थेब लद्; इस्राएली म्हिमैंए म्हाँजोर याहवेहए मिं थेब लद्,” बिसि चमैंइ बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","चमैंए लिउँइँ ताँन् भन्दा च्योंबै बेन्यामीनए कुलइ अरूमैं डोरेइमुँ, चए लिउँइँ यहूदए कुलए चिब्मैं खइमुँ, धै जबूलून नेरो नप्‍तालीमैंए कुलमैं या खइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","ओ परमेश्‍वर, ह्रोंसए शक्ति उँइँन्, धै ओंसों ङिए ल्हागिर लब् धोंले ह्रोंसए शक्ति उँइँमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","यरूशलेमर क्हिए मन्दिरर ह्रेंगोउँइँले खबै म्रुँमैंइ क्हिए ङाँर बालि फोखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","काँसए घारिर टिबै च खेदो धों तबै मिश्र ह्‍युललाइ हौदिद्, मे प्हसेमैंए म्हाँजोर साँडेइ थाब् धों तबै च ह्रेंलाइ हौदिद्! चाँदिए भेटि पखसि चमैंइ क्हिलाइ कुरसि फ्योबर ल्हैदिद्। ल्हडें लदा ङ्हाँब्मैं खन्तोदोंन् प्हुँवाँन्। ");
INSERT INTO gvr_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","मिश्र ह्‍युलउँइँले थेबै म्हिमैं खब्मुँ, कूश ह्‍युलर्बै म्हिमैं ह्रोंसए योमैं क्वेसि परमेश्‍वरने प्राथना लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","ओ पृथ्बीर्बै म्हिमैं, परमेश्‍वरए मिंर क्वे प्रिंन्; खीए मिं थेब् लदै क्वे प्रिंन्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","खी स्योंम् ओंनोंन् स्वर्गर स्युरम्; मु ङ्‍हेब् धोंले खी ह्रोंसए कै तेम्। ");
INSERT INTO gvr_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","परमेश्‍वरए शक्तिए बारेर बिप्रद्! खीजी इस्राएलए फिर ग्याल्स लमुँ, खीए शक्ति ताँन् म्हिमैंइ मुर म्रोंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","ओ परमेश्‍वर, क्हि पबित्र क्‍ल्‍ह्‍योउँइँले युमा क्हि म्रोंसि ताँन् म्हिमैं ङ्हिंम्; इस्राएलए परमेश्‍वरजी ह्रोंसए म्हिमैंलाइ शक्ति नेरो भों पिंम्। परमेश्‍वरए मिं थेब् तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","क्वे प्रिंब्मैंए चिबलाइ, “लिलि ट” बिबै भाकार प्रिंबै दाऊदए भजन। ओ परमेश्‍वर, ङ जोगेमिंन् तलेबिस्याँ स्योंर्बै क्यु ङए खरि समा फेखइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","ङ हिलर प्ल्हुँबि छेइमुँ, चर ङए प्हले म्हैबै क्‍ल्‍ह्‍यो आरे; गैरु क्युर ङ प्ल्हुँबि छेइमुँ, बाढि ङए फिर प्ल्होंखइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","ल्होमिंन् बिसि ओरन-ओरन ङ नारइमुँ; ङए म्‍लोंगो कारयाइमुँ। ङए परमेश्‍वरए घ्याँ ङ्ह्‍योन-ङ्ह्‍योन् ङ‍ए मि छेनाले म्रोंल् आखाँब् तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","तोन् तोर्न ङलाइ आखोब्मैं ङए क्रप्होमैं भन्दा ल्हें मुँ; तोन् तोर्न ङए शत्तुरमैं ल्हें मुँ; चमैंइ ङ सैल् म्हैम्। ङइ आलुडिबै सैमैं या चमैंइ खैले बिलेया पिंन् बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","ओ परमेश्‍वर, ङ आमादु मुँ बिब क्हिजी सेइमुँ; ङइ लबै आछ्याँबै केमैं क्हिजी म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","ओ याहवेह, ताँन् भन्दा थेबै प्रभु, ङइ लमा क्हिने आशा थेंब्मैं फापिल् आत्हुरिगे। ओ इस्राएलए परमेश्‍वर ङइ लमा क्हिलाइ म्हैब्मैं फापिल् आत्हुरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","तलेबिस्याँ क्हिए फिर ङइ भर लबइले आगुइ आखो, धै ङ फापिन् तसि लि उँइँल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","छतसि ङए अलिमैंए म्हाँजोर ङ ङो आसेब् धोंन् तइमुँ, ङए त्येमैंए ङाँर ङ स्याँ तइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","तलेबिस्याँ क्‍हिए धिं ङलाइ बेल्‍ले म्हाँया खम्, क्हिलाइ गाल् केब्‍मैंए गाल् ङए फिर तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","ङ थेब् आप्हैंनले क्रोदै बर्त टिमा म्हिमैंइ ङ प्ह्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","छले शोक लसि ङइ नइँए ह्रेंग खिमा म्हिमैंइ ङ प्ह्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","मुल म्रार खागु तब्मैंइ ङ स्यारम्, धै प्हाइ म्हेरब्मैंइ ङए बारेर क्वे प्रिंम्! ");
INSERT INTO gvr_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","दिलेया, ओ याहवेह, ङ क्हिनेन् प्राथना लम्। क्हिजी तोक्दिबै त्हेर, ओ परमेश्‍वर, क्हिए खोंयोंइ आनुबै म्हाँयाइ लमा क्हिजी खैलेबिलै ङलाइ जोगेमिंम् बिसि ज्वाफ् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","ङ हिलर प्ल्हुँबउँइँले जोगेमिंन्; ङलाइ आखोब्मैं नेरो गैरु क्युउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","नाँ बाढिमैंइ ङ आउरिगे, धै क्युइ ङ आप्ल्हुँरिगे, झाइले क्रोंइ ह्रोंसए सुँ ङए फिर आम्रुरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","ओ याहवेह, क्हिए खोंयोंइ आनुबै म्हाँया थेब मुँ, छतसि ङ ज्वाफ पिंनु; क्हिजी थेबै ल्हयो खसि ङए वास्ता लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","क्हिए लि ह्रोंसए केब्छैंउँइँले आलोमिंनु; तलेबिस्याँ ङए फिर थेबै दुःख तइ। छतसि युनन् ज्वाफ पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","ङए चेंदोले खमिंनु धै ङलाइ जोगेमिंनु; ङए शत्तुरमैंउँइँले ङलाइ खामिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","ङलाइ प्ह्रब, ङ फापिल् लब, नेरो ङए मिं ह्‍याब क्हिजी सेम्; ङए ताँन् शत्तुरमैं क्हिजी सेम्। ");
INSERT INTO gvr_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","म्हिमैंइ प्ह्रमा ङए सैं चोयाइमुँ, धै ङए सैं बेल्‍ले नइमुँ। ङए फिर ल्हयो खब्मैं खाबै मुँ उ बिसि म्हैइ, दिलेया खाबै आरेल, धै सैं क्होल् लमिंब्मैं या खाबै मुँ उ बिसि ङइ म्हैइ, दिलेया खाबै आयों। ");
INSERT INTO gvr_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","ङए चबै सैर चमैंइ काँ झोंइ, धै ङ क्यु पिमा चमैंइ ङलाइ प्हा क्युँ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","चमैंए ल्हागिर थेंबै चबै सैमैं चमैंलाइ ङो चुब् धों तरिगे; धै ख्रो पिंसि चबै सैमैं चमा चमैं नास तयारिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","छेनाले म्रोंल् आखाँरिगे बिसि चमैंए मि मिछु तरिगे, धै चमैंए क्रे खोंयोंन् बिलै कुदुँ तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","चमैंए फिर क्हिए ह्रिस ङेमिंन्, धै लुँबै मि धोंले क्हिए ह्रिसइ चमैंए फिर सजैं पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","चमैं टिबै क्‍ल्‍ह्‍यो नास तयारिगे; चमैंए धिंर खाबै सोगों आतरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","तलेबिस्याँ क्हिजी सजैं पिंबै म्हिलाइ चमैंइ ह्रुगुदिम्, धै क्हिजी घाइते लब्मैंलाइ चमैंइ बेल्‍ले स्यारम्। ");
INSERT INTO gvr_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","चमैंइ लबै पापए हिसाब थेंन्; धै क्हिजी म्हिमैं जोगेमिंमा चमैं जोगेल् आयोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","छ्ह योंब्‍मैंए मिं प्‍ह्रिथेंबै कितबउँइँले चमैंए मिं मेटियारिगे; धै ठिक के लब्मैंने बालु चमैंए मिं आप्ह्रिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","दिलेया ङलाइ दुःख नेरो न्हुँ तइमुँ; ओ परमेश्‍वर, क्हिजी म्हिमैंलाइ जोगेमिंमा ङए रक्षा लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","धै ङ क्वे प्रिंसि परमेश्‍वरए मिं थेब् लब्मुँ; धन्यबाद पिंसि ङ खीए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","क्ल्या भार ख्रो पिंब् भन्दा, रु नेरो खुर मुँबै क्ल्या ख्रो पिंब् भन्दा खीए मिं क्वेस्याँ याहवेह बेल्‍ले सैं तोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","छलब् म्रोंसि आगुइ क्र ओलै आपिंब्मैं सैं तोंब्मुँ। ओ परमेश्‍वर म्हैब्मैं, क्हेमैंए सैं भोंब तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","तलेबिस्याँ याहवेहजी दुःख योंब्मैंए ताँ थेम्, धै झेलर च्युवाबै ह्रोंसए म्हिमैंलाइ खीजी वास्ता लम्। ");
INSERT INTO gvr_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","स्वर्ग नेरो पृथ्बीइ खीए मिं थेब् लरिगे, मा ङ्युँइ नेरो चर मुँबै सो प्ह्‍याबै तोन्दोंरि सैमैंइ खीए मिं थेब् लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","तलेबिस्याँ परमेश्‍वरजी यरूशलेमलाइ जोगेमिंब्मुँ धै यहूदाए सन्तानमैं टिबै सहरमैं धबै बनेब्मुँ, झाइले म्हिमैं चर टिब्मुँ धै च क्‍ल्‍ह्‍योए क्ल्हे चमैं तब्मुँ; ");
INSERT INTO gvr_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","च क्‍ल्‍ह्‍योर्बै हग खीए के लबै म्हिमैंए प्हसेमैंइ योंब्मुँ, धै खीलाइ म्हाँया लब्मैं चर टिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर, याहवेहए मिंरि ख्रो पिंबै ल्हागिर दाऊदइ प्ह्रिबै भजन ओ परमेश्‍वर, ङलाइ युनन् जोगेमिंन्! ओ याहवेह, ङ ल्होबर युनन् युमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","ङलाइ सैल् म्हैब्मैं अलमल् तसि फा फिन् तरिगे! ङए न्होह्रों तब् म्रोंसि सैं तोंब्मैं लिग्याँ तोसि न्हेयारिगे धै आगुइ चमैंलाइ म्हि आच्हिन् लवारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","ङलाइ प्ह्रब्मैं फा फिसि लि उँइँलै आखाँरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","दिलेया क्हिलाइ म्हैब्मैं ताँन् क्हिलाइन मैंसि सैं तोंरिगे धै छिं ङ्हाँरिगे! “क्हिजी जोगेमिंइ!” बिसि धन्यबाद पिंब्मैंइ खोंयोंइन् बिलै “परमेश्‍वर बेल्‍ले थेब मुँ!” बिसि बिरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","दिलेया ङ आयोब् नेरो आख्युब मुँ; ओ परमेश्‍वर, ङए ङाँर युनन् युमिंन्! क्हिजी ङलाइ ल्होसि ताँन् दुःखउँइँले फ्रेमिंम्। ओ याहवेह, युनन् युमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","ओ याहवेह, ङ ग्वार योंबर क्हिए प्हलेर खइमुँ; ङ खोंयोंइ फापिल् आत्हुरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","क्हि ठिक निसाफ लबै परमेश्‍वर ग, छतसि आछ्याँबै सैमैंउँइँले फ्रेमिंसि ङलाइ जोगेमिंन्, ह्रोंसए न्ह ङ ङाँइ तोमिंनु धै ङ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","ङ क्हि ङाँर खरिमा ङए शत्तुरमैंइ ङ आस्यारिगे बिसि ङ रक्षा लमिंबै पारा तमिंन्। ङलाइ जोगेबर ल्हैदिद्, तलेबिस्याँ क्हि ङए ङ रक्षा लमिंबै पारा नेरो किल्‍ला ग। ");
INSERT INTO gvr_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","ओ ङए परमेश्‍वर, दुष्‍टए योमैंउँइँले ङ फ्रेमिंन्, दयाम्हाँया आरेबै अनिया लबै म्हिउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","तलेबिस्याँ, ओ याहवेह परमेश्‍वर, ङइ क्हिए फिर आशा लइमुँ, ङ फ्रेंसि तब् ओंनोंन् ङइ क्हिए फिर भर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","फिब् ओंनोंन् ङइ क्हिए फिर भर लइमुँ; ङ‍ए आमाए प्होउँइँले तेमिंब क्हिन् ग। छतसि खोंयोंन् बिलै ङ क्हिए मिं थेब् लरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","ल्हें म्हिए ल्हागिर ङ आछ्याँबै ताँ तल् खाँब्मुँ बिबै चिनु तइमुँ, दिलेया क्हि ङए भोंबै ग्वार योंबै क्‍ल्‍ह्‍यो तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","ङए सुँइ क्वे प्रिंसि क्हिए मिं थेब् लरिमुँ, धै त्हिंइतिमिन् ङइ क्हिए थेबै मिंए बारेर बिप्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","खेब् तबै त्हेर ङलाइ आपिदु, ङए भों नुयामा ङलाइ आवाथेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","तलेबिस्याँ ङए शत्तुरमैंइ ङए बिरोधर ताँ लम्, ङलाइ सैल् म्हैब्मैं खेंमैंए न्होंर छ बिसि मत लम्, ");
INSERT INTO gvr_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","“परमेश्‍वरजी चलाइ पिवाइमुँ; छतसि चलाइ ल्हाबोसि क्हाद्, तलेबिस्याँ चलाइ जोगेब खाबै आरे।” ");
INSERT INTO gvr_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","ओ परमेश्‍वर, ङ ङाँइँले ह्रेंगो आतमिंन्; ओ ङए परमेश्‍वर, ङ ल्होबर युनन् युमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","ङ छ्याब् ल्हैदिब्मैं फा पिसि मेब्रो तयारिगे; ङए न्होह्रों लल् म्हैब्मैं फापिन् तसि लि उँइँल् आखाँरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","दिलेया ङ बिस्याँ खोंयोंन् बिलै क्हिए फिर आशा लरिब्मुँ, धै क्हिलाइन झन् थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","क्हिजी लबै ठिक केमैं नेरो क्हिजी ङ जोगेमिंबै बारेर त्हिंइतिमि ङए सुँइ पोंब्मुँ। दिलेया च केमैं कति मुँ बिब ङइ आसे। ");
INSERT INTO gvr_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","ओ याहवेह परमेश्‍वर, क्हिजी लबै शक्‍ति मुँबै केमैं ङ बिप्रब्मुँ, क्हिजी लबै ठिक निसाफमैं मत्‍त्रे ङ बिप्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","ओ परमेश्‍वर, ङ फ्रेंसि तब् ओंनोंबै क्हिजी ङलाइ लोमिंइमुँ, छतसि क्हिजी लबै औदिबै केमैंए बारेर तिंयाँबै त्हिंइ समा ङइ बिप्रइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","ओ परमेश्‍वर, चु पुस्ता नेरो लिउँइँ खबै ताँन् पुस्तामैंने क्हिजी लबै शक्‍ति मुँबै केमैं आबिन् समा ङ खेब् तसि ङए क्र सारयामैं या ङलाइ आपिद्। ");
INSERT INTO gvr_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","ओ परमेश्‍वर, क्हिजी लबै ठिक निसाफ मु समा फेनेम्, क्हिजी थेबै केमैं लइमुँ। ओ परमेश्‍वर, क्हि धों तब खाब् मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","क्हिजी ङए फिर ल्हें दुःखमैं खल् पिंइ, दिलेया क्हिजी ङ धबै सोगों लमिंब्मुँ, पृथ्‍बीए न्होंउँइँले क्हिजी ङ धबै कैंडो पखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","क्हिजी ङए मान बडिमिंब्मुँ, धै ङए सैं धबै क्होमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","ओ ङए परमेश्‍वर, क्हि भर लल् खाँबै परमेश्‍वर तबइले ङ बीणा ह्रादै क्हिन् थेब लब्मुँ। ओ इस्राएलर्बै पबित्र परमेश्‍वर, सारङ्गी ह्रासि ङ क्हिलाइन थेब् लबै क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","क्हिलाइ थेब् लबै क्वेमैं प्रिंमा ङए म्हदेमैं सैं तोंसि ओरब्मुँ, तलेबिस्याँ क्हिजी ङ जोगेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","ङए न्होह्रों लल् म्हैब्मैं फापिसि खैला तोला तबर फेइमुँ, छतसि ङए लेइ त्हिंइतिमिंन् क्हिजी लबै ठिक केमैंए बयन लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","सोलोमनए भजन ओ परमेश्‍वर, क्हिजी लब् धोंले म्रुँलाइ निसाफ लल् पिंन्, धै क्हिजी ठिक के लब् धोंले म्रुँए च्हलाइ ठिक के लबर लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","धै क्हिए म्हिमैं नेरो दुःख योंब्मैंए फिर चइ ठिक निसाफ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","कोंमैंइ क्हिए म्हिमैंलाइ प्लोब लमिंम्, धै क्लिं क्हाँमैंइ ठिक केमैं लल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","म्हिमैं दुःख तमा चइ रक्षा लब्मुँ, ङ्हाँदुमैंए प्हसेमैंलाइ जोगेब्मुँ, धै आगुए न्होह्रों लब्मैंलाइ चइ न्होंर प्लेवाब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","लयाँ नेरो त्हिंयाँ मुँन् समा ताँन् पुस्ता-पुस्ताइ चए मिं क्वेरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","छि खैंवाबै चउरर युबै नाँ धों तब नेरो स क्योबै झरि धों तब च तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","चए ग्याल्सर ठिक के लब्मैंल बिब् धों तरिगे, धै लयाँ मुँन् समा तोन्दोंरि सै छ्याँब तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","मा ङ्युँइ घ्रिउँइँले अर्को मा ङ्युँइ समा, धै यूफ्रेटिस बिबै स्योंउँइँले पृथ्बीए साँद् समा चइ ग्याल्स लब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","क्यु आयोंबै क्‍ल्‍ह्‍योर्बै ह्रेंमैं चए उँइँर कुरब्मुँ, धै चए शत्तुरमैंइ त्हुल ल्हेंब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","तर्शीश नेरो ह्रेंगोबै मा ङ्युँइए रेजरेबै म्रुँमैंइ च ङाँर बालि फोखब्मुँ; शेबा नेरो सेबाए म्रुँमैंइ चलाइ भेटि पिंखब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","ताँन् म्रुँमैं चए उँइँर पदखु तब्मुँ, धै ताँन् ह्रेंमैंइ चए सेवा लब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","ङ्हाँदुमैंइ नेरो ल्होबै म्हि आरेब्मैंलाइ ग्वार ह्रिमा चइ जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","भों आरेब्मैं नेरो ङ्हाँदुमैंए फिर चइ ल्हयो खब्मुँ, धै ङ्हाँदुमैंए ज्यु जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","आगुइ क्र ओलै आपिंब्मैं नेरो ल्हें दुःख योंब्मैंलाइ चइ जोगेमिंब्मुँ, तलेबिस्याँ चए उँइँर चमैंए को किंसे किंल् आखाँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","चइ ह्रिंग्यो छ्ह योंरिगे; शेबा ह्‍युलर्बै मारा म्हिमैंइ चलाइ भेटि पिंरिगे! चए ल्हागिर म्हिमैंइ खोंयोंइन् बिले प्राथना लरिगे, त्हिंइतिमिन् चमैंइ चए फिर आशिक ह्रिरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","ह्‍युल तिगोंन् रा-रोमैंइ प्लिंरिगे; कोंए च्होजरे च रा-रोमैं बेल्‍ले छ्याँरिगे; च‍ए रोमैं लेबनान धोंले म्रेरिगे; च खर्कर्बै छि मौलिदिब् धोंले सहरर्बै म्हिमैं प्लोरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","चए मिं खोंयोंन् बिलै तरिगे, त्हिंयाँ धोंले चए बयन ल्हें समा तरिगे! ताँन् ह्रेंमैंइ चउँइँले आशिक योंरिगे, धै चमैंइ चए मिं थेब् लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","याहवेह परमेश्‍वरजी मत्‍त्रे औदिबै केमैं लम्, छतसि इस्राएलए परमेश्‍वरए मिं थेब तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","खीए थेबै मिं खोंयोंन बिलै क्वेरिगे; पृथ्बी तिगोंन् म्हिमैंइ खीए थेबै के म्रोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","यिशैए च्ह दाऊदए प्राथना चुर खाँइ। ");
INSERT INTO gvr_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","आसापए भजन घ्रि। क्ह्रोंसेंन इस्राएलए ल्हागिर, छ्याँबै सैं प्ह्‍याब्मैंए ल्हागिर, परमेश्‍वर स्वाब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","दिलेया ङए प्हले प्लेबर होंल, प्हले प्लेब् धोंले ङए बिश्‍वास म्हायाबि छेल, ");
INSERT INTO gvr_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","तलेबिस्याँ दुष्‍टमैं छ्याँब् तब् म्रोंसि च थेब् प्हैंब्मैंए फिर ङइ ह्रिस लमल। ");
INSERT INTO gvr_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","चमैं आसिन् समा दुःख तरिब् आरे; चमैं नब्-छब् आत, चमैंए ज्यु भोंब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","अरू म्हिमैंइ धोंले चमैंइ दुःख आयों; अरू म्हिमैंए फिर आछ्याँबै ताँमैं खब् धोंले चमैंए फिर आख। ");
INSERT INTO gvr_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","सिक्रि खिल् योंमा सैं तोंब् धोंले थेब् प्हैंमा चमैं सैं तोंम्; धै क्वें खिब् धोंले चमैंइ प्होंगि कैगि लम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","चमैंए सारो सैंउँइँले दुष्‍ट केमैं खम्; चमैंए सैंइ खोंयोंन् बिलै आछ्याँब ताँ मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","चमैंइ आगुए बिल्‍लि लम्, झाइले दुष्‍ट ताँ पोंम्; धै ङम् ङन् ग बिसि अरूलाइ क्र ओलै आपिं। ");
INSERT INTO gvr_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","मु ङिलन् ग बिसि चमैंए सुँइ बिम्, धै चमैंए लेइ पृथ्बी तिगोंन् अधीन लम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","छतसि परमेश्‍वरए म्हिमैं चमैं ङाँइ एखम्, धै ल्हें क्यु थुँब् धोंले चमैंए ताँ क्वेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","“ङ्योइ लबै के परमेश्‍वरजी खैले सेमुँ? ताँन् भन्दा थेबै परमेश्‍वरने ज्ञान मुँ वा?” बिसि चमैंइ बिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","दुष्‍टमैं छाब तम्: चमैं खोंयोंइ न्हुँ आल, चमैंए सै न्होर ल्हें तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","क्ह्रोंसेंन ङइ तोनतोर्न ह्रोंसए सैं छ्याँब् प्ह्‍याइमुँ, धै गल्ति आलइमुँ बिसि ङइ यो ख्रुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","त्हिंतिमिन् ङइ दुःख योंइमुँ; धै न्हाँग ह्रोंसे ङइ दण्ड योंल् त्हुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","दिलेया दुष्‍टमैंइ पोंब् धोंले ङज्यै या पोंस्याँ क्हिए सन्तानलाइ ङइ दु:ख पिंमल। ");
INSERT INTO gvr_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","चु ताँमैं ङइ क्होल् म्हैमा ङए ल्हागिर बेल्‍ले गारो तइ। ");
INSERT INTO gvr_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","दिलेया लिउँइँ ङ परमेश्‍वरए पबित्र क्‍ल्‍ह्‍योर होंमा खी ङाँर खसि मत्‍त्रे चमैंए लिउँइँ तरिबै ताँमैं ङइ क्होइ। ");
INSERT INTO gvr_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","क्ह्रोंसेंन क्हिजी चमैंलाइ प्हले प्लेबै क्‍ल्‍ह्‍यो जरे थेंम्; क्हिजी चमैं नास तयाबर भ्योंवाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","थाइ आसेल्‍ले चमैं नास तयाम्, चमैं बेल्‍ले ङ्हिंमा ताँन् नोबोइ! ");
INSERT INTO gvr_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","न्हाँगर छोरमा म्होंड म्हयाब् धोंले, ओ प्रभु, क्हि छोरमा चमैंलाइ तो धोंइ आङ्हाँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","ङए सैंर दुःख तल, ङए सैं ककाँ क्युँ-क्युँ ङ्हाँल, ");
INSERT INTO gvr_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","छतसि ङ च्हैंब् मैंल् आखाँब नेरो ताँ क्होल् आखाँब् मुँल; क्हिए उँइँर ङ खेदो धोंन् तब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","दिलेया ङ खोंयोंन् बिलै क्हिने बालुन् मुँ; क्हिजी ङए क्योलो यो क्हामुँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","क्हिजी सल्‍ला पिंसि ङलाइ डोरेमिंम्, धै लिउँइँ ङ क्हि ङाँर मान योंबै क्ल्ह्‍योर बोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","ङए ल्हागिर स्वर्गर क्हि बाहेक अरू खाब् मुँ? धै पृथ्‍बीरै या क्हि बाहेक ङइ खोब खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","ङए सैं नेरो ज्यु ङ्हिंन-ङ्हिंन् भों आरेलै खाँम्, दिलेया परमेश्‍वरजी ङए सैंर भों पिंम् धै खोंयोंन् बिलै ङ‍ए चैदिबै सै क्हिन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","क्हिउँइँले ह्रेंगो तब्मैं सियाब्मुँ; क्हिलाइ बिश्‍वास आलसि पिवाब्मैं क्हिजी नास लम्। ");
INSERT INTO gvr_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","दिलेया परमेश्‍वरने चेंदो तरिब ङए ल्हागिर छ्याँब ग, याहवेह परमेश्‍वरए प्हलेर्न ङ ग्वार योंबर खइमुँ। छतसि क्हिए ताँन् केमैंए बयन ङइ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","आसापए मस्किल घ्रि ओ परमेश्‍वर, क्हिजी तले ङिलाइ युगुर्लै पिवाल? ङि क्हिए खर्गर्बै क्युमैं ग। क्हिए ह्रिस तले ङिए फिर मि धोंले लुँइमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","क्हिजी ओंसोंन् त्हाँबै म्हिमैं मैंमिंन्। क्हिए म्हिमैं तबर क्हिजी ङिलाइ केब्छैं तबउँइँले फ्रेसि पखइ! क्हि टिबै सियोन कों मैंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","शत्तुरमैंइ क्हिए मन्दिरर मुँबै ताँन् सैमैं नास लवाइ! नास तयाबै सहरउँइँ ह्रोंसए खसि ङ्ह्‍योद्! ");
INSERT INTO gvr_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","क्हिजी ङिने त्होबै क्‍ल्‍ह्‍योर क्हिए शत्तुरमैं ओरइमुँ; ट्होबै चिनु उँइँबै ल्हागिर चमैंइ ह्रोंसए झन्डा क्योइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","म्हिइ सिंधुँमैंर तइ थोवाब् धोंले चमैंइ त छेसि क्हिए मन्दिर नास लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","चमैंइ ह्रोंसए त नेरो घनइ बुट्टा झोंबै खापामैं त्हुला भुँ लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","चमैंइ क्हिए पबित्र क्‍ल्‍ह्‍योर मि त्हवासि नास लवाइ; क्हिए मिं मुँबै क्‍ल्‍ह्‍यो चमैंइ जुठ लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","“चमैं ताँनलाइ ङिइ प्लेवाब्मुँ,” बिसि चमैंइ ह्रोंसए सैंर मैंइ; परमेश्‍वरए मिं क्वेबै ह्‍युलर्बै ताँन् क्ल्ह्‍यो चमैंइ ख्रोंवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","औदिबै चिनुमैं ङिइ तोइ आम्रों; तारे अगमवक्तामैं घ्रि या आचै, धै चु दुःख खोंयों समा तरिब्मुँ बिसि ङि आसे। ");
INSERT INTO gvr_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","ओ परमेश्‍वर, खोंयों समा शत्तुरमैंइ क्हिलाइ प्ह्रब्मुँ? शत्तुरमैंइ खोंयोंइन क्हिए मिंलाइ स्याररिम्‍म? ");
INSERT INTO gvr_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","क्हिजी ह्रोंसए यो, ह्रोंसए क्योलो योइ तले तोइ लल् आपिंल? क्वें न्होंउँइँले यो ट्हुइदु धै चमैं नास लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","दिलेया ओ परमेश्‍वर, क्हि स्योंम् ओंनोंन् ङए म्रुँ ग, क्हिजी पृथ्‍बीर मुक्ति पुयुमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","क्हिजी ह्रोंसए शक्तिजी मा ङ्युँइ ङ्हिंबाँ लवाइ; मा ङ्युँइए न्होंर मुँबै सो प्ह्‍याबै थे-थेबै ङ्हिंन् ङ्हाँबै सैमैंए क्र त्हुला भुँ लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","माँ ङ्युँइर टिबै बेल्‍ले ङ्हिंन् ङ्हाँबै लिव्यातनए क्रमैं क्हिजी त्हुला भुँ लवाइ; धै चए से क्यु आयोंबै क्‍ल्‍ह्‍योर टिबै खेदोमैंलाइ क्हिजी चबर पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","क्हिजीन् क्युए मुल तिसि स्यों युल् पिंइ; क्हिजी खोंयोंइन युरिबै स्योंमैं ङ्हाह्रमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","त्हिंइ क्हिलन् ग, म्हुँइँसै या क्हिलन् ग; त्हिंयाँ नेरो लयाँ क्हिजीन् बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","पृथ्‍बीर्बै साँदमैं क्हिजीन् थेंब् ग; ख्वालबै त्हे नेरो खुँबै त्हे क्हिजीन् बनेब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","ओ याहवेह, शत्तुरमैंइ क्हिलाइ खैले प्ह्रइमुँ, धै मुर्ख म्हिमैंइ क्हिए मिंलाइ स्यारइमुँ बिसि मैंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","तोंगु धों तबै ह्रोंसए म्हिमैंलाइ क्ह्‍योंर्बै खेदोमैं धों तबै दुष्‍टमैंए उँइँर फेल् आपिंन्; आगुइ क्र ओलै आपिंबै क्हिए म्हिमैंलाइ खोंयोंइ आम्‍लेद्। ");
INSERT INTO gvr_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","ह्‍युलर्बै मिछु खैबै क्‍ल्‍ह्‍योर म्हिसैब्मैंइ प्लिंरिइमुँ, छतसि क्हिजी फैबै बाछा मैंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","आगुइ क्र ओलै आपिंब्मैं फापिसि लिउँइँ तोल् आत्हुरिगे; दुःख योंब्मैं नेरो आयों आख्युब्मैंइ क्हिए मिं थेब लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","ओ परमेश्‍वर, रेत्ति, क्हिजी लबै केमैं आगुइ न्होह्रों लल् आपिंन्; आमादुमैंइ त्हिंतिमिन् क्हिलाइन प्ह्ररिमुँ, छतसि मैंन्! ");
INSERT INTO gvr_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","क्हिए बिरोधीमैं ओरब धै क्हिए शत्तुरमैं प्होंब नेब लदै ह्‍याब आम्‍लेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर “नास आलद्” बिबै भाकार प्रिंबै आसापए भजन घ्रि, क्वे घ्रि। ओ परमेश्‍वर, ङिइ क्हिलाइन धन्यबाद पिंम्, क्हि ङिए चेंदो मुँ, छतसि ङिइ क्हिलाइ धन्यबाद पिंम्। क्हिजी लबै औदिबै केमैंए बयन् म्हिमैंइ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","“ङजी ठिक त्हे तोक्दिइमुँ,” बिसि परमेश्‍वरजी बिइमुँ। “च त्हेर खाबै आफेलल्‍ले ङइ निसाफ लब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","पृथ्बी नेरो चर मुँबै ताँन् सैमैं त्हारलेया पृथ्बीए त्होमैं थाम्दिसि थेंब ङन् ग। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","थेब् प्हैंब्मैंने ङजी बिमुँ, ‘थेब् आप्हैंन्’, धै दुष्‍टमैंने बिमुँ, ‘क्हेमैं थेब प्हैंसि ओक्रों आतद्; ");
INSERT INTO gvr_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","क्हेमैं स्वर्गए बिरोधर पोंसि ओक्रों आतद्; थेब् प्हैंसि आपोंन्।’” ");
INSERT INTO gvr_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","स्याराउँइँले (पुर्वाउँइँले) मुँलेया न्हुँरउँइँले (पश्‍चिमउँइँले) मुँलेया क्यु आयोंबै क्‍ल्‍ह्‍योउँइँले मुँलेया खाबज्यै या म्हिलाइ थेब् लल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","दिलेया परमेश्‍वरजीन् निसाफ लमा घ्रिलाइ च्योंब लमुँ, घ्रिलाइ थेब लमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","याहवेहए योर प्हेल घ्रि मुँ, खीए ह्रिसइ च प्हेलर प्लिंइमुँ। पृथ्बीर्बै दुष्‍टमैं ताँनइ दण्ड योंम्, प्हेलर मुँबै सै तोइ आचैल्‍ले चमैं थुँल् खाँल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","दिलेया खीजी लबै थे-थेबै केमैंए बयन ङ खोंयोंन् बिले लब्मुँ; याकूबए परमेश्‍वरए मिं क्वेसि ङ क्वे प्रिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","तलेबिस्याँ परमेश्‍वरजी बिइ, “ताँन् दुष्‍टमैंए भों ङइ नास लवाब्मुँ, दिलेया ठिक के लब्मैंए भों थेब लमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","क्वे प्रिंब्मैंए चिबलाइ बीणा-सारङ्गीं ह्रादै प्रिंबै आसापए भजन घ्रि, क्वे घ्रि। यहूदा ह्‍युलर्बै म्हिमैंइ परमेश्‍वर ङो सेइमुँ; इस्राएलर खीए मिं बेल्‍ले थेब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","यरूशलेमर खीए तम्बु मुँ, खी टिबै क्‍ल्‍ह्‍यो सियोन बिबै कोंर मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","चर शत्तुरमैंए लुँरिबै मेमैं, ढालमैं, सेलाँ नेरो ल्हडें लमा छेबै हतियारमैं खीजी चोवाइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","क्हि बेल्‍ले चारबै ह्‍वे ग, ह्रोंसए शत्‍तुरमैं ट्होवासि कोंउँइँले क्युरु युमा क्हि बेल्‍ले ङ्‍हो ल्होंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","भोंबै सैं मुँबै सिपाइमैंए ताँन् सैमैं लुडिवाइमुँ, झाइले चमैं सिसि थेबै न्हरु च्हुइरिइमुँ। धै च नेल् खाँब्मैंए भों नुयासि यो क्वेल् आखाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","ओ याकूबए परमेश्‍वर, क्हिजी हौदिमा घोडा नेरो चर क्रेब्मैं ङ्हिंन-ङ्हिंन् ओलेल् आखाँब् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","दिलेया ओ याहवेह, क्हिने मत्‍त्रे ङ्हिल् त्हुब मुँ! क्हि ह्रिस खमा क्हिए उँइँर खाब् राल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","8","ओ परमेश्‍वर, क्हिजी स्वर्गउँइँले निसाफ लइमुँ; ");
INSERT INTO gvr_vpl VALUES ("PS76_9","020_76_9","PSA","76","9","9","पृथ्‍बीर्बै आगुए न्होंर मुँब्मैं ताँन् जोगेबै ल्हागिर क्हि निसाफ लबर रेमा पृथ्‍बीर्बै म्हिमैं ङ्हिंसि आपोंल्‍ले टिइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","क्ह्रोंसेंन् म्हिमैंने क्हिए ह्रिस खमा क्हिए मिंन् थेब् लब्मुँ; झाइले क्हिए ह्रिसउँइँले सोब्मैंइ आछ्याँबै के लब पिवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","याहवेह क्हेमैंए परमेश्‍वरने लबै भकलमैं पूरा लद्; खीए खागु मुँबै ह्रेंमैंइ खीलाइ बालि फोरिगे। खीजी ताँनलाइ ङ्हिंबर ल्हैदिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","थेब् प्हैंबै क्रथे मिंथेमैं खीजी कुरवाम्; पृथ्‍बीर्बै म्रुँमैं खीने ङ्हिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","क्वे प्रिंब्मैंए चिब यदूतूनए ल्हागिर, आसापए भजन घ्रि। थेबै कैले ङइ परमेश्‍वरने ग्वार ह्रिम्, खीजी थेरिगे बिसि ङइ थेबै कैले ओरम्। ");
INSERT INTO gvr_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","दुःख योंबै त्हेर ङइ प्रभु म्हैम्; ङइ आनारल्‍ले म्हुँइँस तिमिंन् ङए यो स्योंइ; परमेश्‍वरजी आल्होमिंन् समा ङ छिं आङ्हाँ। ");
INSERT INTO gvr_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","परमेश्‍वर मैंमा ङइ न्हुँ लसि सो खुइ लम्; खीलाइ मैंमा ङए सैं च्योंब् तम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","क्हिजी ङए मि च्युँ ललै आपिं; ङलाइ थेबै दुःख लमा पोंलै आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","ह्‍याबै त्हिंइमैं, ओंसों ओंनोंबै बर्षमैं, ङइ मैंम्। ");
INSERT INTO gvr_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","म्हुँइँसर ङइ ह्रोंसए क्वेमैं मैंइ; तले जा बिसि ङइ सैंर मैंल। धै ङए सैंइ चु ताँमैं ङ्योलु-च्युलु लइ: ");
INSERT INTO gvr_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“प्रभुजी ङ्योलाइ युगुर्लै वाथेंम् रो वा? खीजी धबै खोंयोंइ ङ्योए फिर ल्हयो आख रो वा? ");
INSERT INTO gvr_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","खीए खोंयोंइ आनुबै म्हाँया युगुर्लै खाँयाँइ वा? खीए बाछा युगुर्लै नुयाइ वा? ");
INSERT INTO gvr_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","परमेश्‍वरजी दयाम्हाँया लब म्‍लेयाइ वा? ह्रिस खसि तारे खीजी म्हाँया आल रो वा?” बिसि ङइ ङ्योएल। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","झाइले ताँन् भन्दा थेबै परमेश्‍वरए क्योलो योर भों आरेन उ? बिब ङइ मैंइ। चु ताँर ङए सैं च्योंब् तइ। ");
INSERT INTO gvr_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","दिलेया याहवेहजी लबै केमैं ङ मैंब्मुँ; क्ह्रोंसेंन्ले क्हिजी ओंसों ओंनोंन् लबै औदिबै केमैं ङ मैंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","क्हिजी लबै ताँन् केमैंए बारेर ङइ सैंर मैंब्मुँ, धै क्हिजी लबै ताँन् शक्‍तिए केमैंए बारेर ङ बिचार लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","ओ परमेश्‍वर, क्हिजी लबै ताँन् केमैं पबित्र मुँ। ङिए परमेश्‍वर धों तबै थेबै देवता अरू खाब् मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","क्हि औदिबै केमैं लबै परमेश्‍वर ग; क्हिजी ह्रोंसए शक्ति ह्रें-ह्रेंमैंए म्हाँजोर उँइँमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","ह्रोंसए योए भोंइ क्हिजी ह्रोंसए म्हिमैं, अथवा याकूब नेरो योसेफए सन्तानमैं जोगेमिंइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","ओ परमेश्‍वर, मा ङ्युँइर्बै क्युइ क्हि म्रोंइ, क्युइ क्हि म्रोंमा चमैं ङ्हिंयाँइ, धै थेबै मा ङ्युँइ त्हारइ। ");
INSERT INTO gvr_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","न्हाम्स्योंमैंइ नाँ युमिंइ; मु बेल्‍ले ङ्हेबर होंइ; मेमैं धोंले क्हिए काम्‍लि-तिम्‍लि खोन्तोदोंन् चारबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","नाँ-खैंर मु ङ्हेब् धोंले क्हिए कै तेइ; क्हिए कम्‍लि-तिम्‍लिइ ताँन् ह्‍युल चारइ; पृथ्‍बी ङ्हिंसि त्हारइ। ");
INSERT INTO gvr_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","क्हिजी डोरेबै घ्याँ मा ङ्युँइए महाँजोर मुँल, क्हि प्रबै घ्याँ थेबै क्युए महाँजोर मुँल; दिलेया क्हिए प्हलेए म्है आम्रोंल। ");
INSERT INTO gvr_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","मोशा नेरो हारूनए योउँइँले क्हिजी ह्रोंसए म्हिमैं क्युमैंए बगल धोंले डोरेइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","आसापए मस्किल घ्रि ओ ङए म्हिमैं, ङइ लोमिंबै ताँमैंर न्ह तोद्; ङइ बिबै ताँमैं छेनाले थेद्। ");
INSERT INTO gvr_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","ङइ आहनउँइँले पोंब्मुँ, था आसेबै स्योंम्बै ताँमैं ङइ बिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","च ताँमैं ङ्योए बाज्यूमैंइ ङ्योने बिथेंइमुँ, छतसि ङ्योइ थेसि सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","चु ताँमैं ङ्योइ ह्रोंसए प्हसेमैंउँइँले लोइरि थेंरिब् आरे, दिलेया तारे खबै पुस्तमैंने याहवेहजी लबै औदिबै केमैं नेरो खीए भोंए बारेर धै खीजी लबै प्लेटोयान् तबै केमैंए बयन ङ्योइ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","याकूबए सन्तानए ल्हागिर खीजी ताँमैं बिइ, धै इस्राएल ह्रें न्होंर ठिम घ्रि पिंइ, ह्रोंसए सन्तानमैंने चु ताँ लोमिंरिगे बिसि खीजी ङ्योए खेबाज्युमैंने बिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","तलेबिस्याँ लिउँइँबै पुस्तामैंइ चु ताँ ह्ररिगे, धै अझै तोगो समा आफिबै कोलो ओंलामैंइ चु ताँ सेरिगे, धै चमैंइ ह्रोंसए सन्तानमैंने या चु ताँ बिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","छले चमैंइ परमेश्‍वरए फिर भर थेंमल, धै खीजी लबै केमैं आम्‍लेमल, धै खीए ताँमैं ङिंमल। ");
INSERT INTO gvr_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","ह्रोंसए खेबाज्युमैंइ लब् धोंले सैं सारो नेरो बिब् आङिंबै पुस्तामैं चमैं आतरिगे। चमैंए खेबाज्युमैंइ परमेश्‍वरए फिर भर आम्हाँदिमल, चमैंइ खीए फिर बिश्‍वास आलमल। ");
INSERT INTO gvr_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","एफ्राइमर्बै म्हिमैं मे त्हलेमैं छेमल, दिलेया नेबै त्हेर चमैं क्हो तोसि न्हेयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","चमैंइ परमेश्‍वरजी फैबै बाछा आम्हाँदि, धै खीए ठिमर प्रदा आङ्हाँ। ");
INSERT INTO gvr_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","खीजी लबै केमैं चमैंइ म्‍लेयाइ, च औदिबै केमैं खीजी चमैंने उँइँमिंल। ");
INSERT INTO gvr_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","चमैंए खेबाज्युमैंए उँइँर मिश्र ह्‍युलर्बै सोअन बिबै सहरए चेप्ला तबै क्ल्ह्‍योर खीजी औदि-औदिबै केमैं लल। ");
INSERT INTO gvr_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","खीजी मा ङ्युँइ ङ्हिबाँ लइ धै क्युए म्हाँजोउँइँले चमैंलाइ क्योंज डोरेबोइ, धै खीजी गारा धोंले क्यु रामिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","त्हिंयाँर न्हाँम्स्योए त्हो नेरो म्हुँइँसर मिए राब तसि खीजी चमैं डोरेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","क्यु आयोंबै क्‍ल्‍ह्‍योर खीजी पारा ङ्हिबाँ फैलसि तिवाइ, धै मा ङ्युँइर्बै क्यु धोंले चमैंलाइ ल्हें क्यु थुँल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","खीजी पाराउँइँले स्योंमैं त्होंमिंइ धै स्यों धोंले क्यु बग्दिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","दिलेया क्यु आयोंबै क्‍ल्‍ह्‍योर ताँन् भन्दा थेबै परमेश्‍वरए बिरोधर चमैंइ आछ्याँबै के लदै लइ, खीजी बिबै ताँ या आङिंमल। ");
INSERT INTO gvr_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","ह्रोंसए सैंर मैंब् धोंले चबै सै ह्रिसि चमैंइ सेन-सेन् परमेश्‍वरए जाँच लइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","“परमेश्‍वरजी क्यु आयोंबै क्‍ल्‍ह्‍योर चबै सैमैं पिंल् खाँम्मा?” बिसि चमैंइ परमेश्‍वरए बिरोधर पोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","“खीजी पारर प्रिंमा पार तिसि क्यु त्होंइ, स्योंमैं धोंले क्यु ल्हें बग्दिइ। दिलेया खीजी ङ्योलाइ चबै सैमैं या पिंल् खाँम् रो वा? धै खीजी ह्रोंसए म्हिमैंए ल्हागिर से पिंल् खाँम् रो वा?” ");
INSERT INTO gvr_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","चमैंए ताँ थेसि याहवेह बेल्‍ले ह्रिस खइ; धै याकूबए सन्तानए बिरोधर खीजी मि कुलसि चमैं नास लवाइ, इस्राएलए बिरोधर खी बेल्‍ले थेबै ह्रिस खइ, ");
INSERT INTO gvr_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","तलेबिस्याँ चमैंइ परमेश्‍वरए फिर बिश्‍वास आलल, खीजी जोगेमिंम् बिबै ताँर चमैंइ भर आथेंल। ");
INSERT INTO gvr_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","दिलेया “चबै सै कुलद्” बिसि मुने बिमा खीजी मुर्बै म्रामैं थोंमिंइ, ");
INSERT INTO gvr_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","म्हिमैंइ चबै ल्हागिर खीजी मन्‍न बर्सादिमिंइ, धै चमैंलाइ स्वर्गर्बै चबै सैमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","स्वर्गदूतमैंइ चबै क्हें म्हिमैंइ चइ; परमेश्‍वरजी चमैंलाइ ल्हें चबै सैमैं पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","खीजी मुर स्यारउँइँले खैं खल् पिंइ, धै खीजी ह्रोंसए शक्तिजी न्हुरउँइँले खैं खल् पिंइ; ");
INSERT INTO gvr_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","छलेन स त्हुल धोंले खीजी चमैंए फिर से कुल्मिंइ, मा ङ्युँइर्बै बालुवा धोंले नमेमैं कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","चमैं टिबै क्ल्ह्‍यो न्होंर नेरो चमैंए तम्बुजरे खीजी नमेमैं युल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","खीजी चमैंए सैंर मैंब् धोंले पिंल, छतसि चमैंइ म्रेंन्ले चइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","दिलेया चमैंए चबै सै चमैंए सुँर मुँमन्, चमैं म्रेंब् भन्दा ओंसों, ");
INSERT INTO gvr_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","चमैंए फिर परमेश्‍वरए थेबै ह्रिस मि धोंले लुँइ। चमैंए न्होंर्बै भोंबै म्हिमैं खीजी सैवाइ, धै इस्राएलर्बै फ्रेंसिमैं ताँन् क्हुरवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","छान् ललेया चमैंइ पाप के लरिइ; खीजी औदिबै केमैं ललैया चमैंइ खीए फिर बिश्‍वास आल। ");
INSERT INTO gvr_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","छतसि खीजी चमैंए छ्ह नुल् लवाइ, धै चमैंए बर्षमैं ङ्हिंदा ङ्हाँन् तब लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","छले परमेश्‍वरजी म्हिमैं सैवामा अरूमैंइ खीलाइ म्हैइ; झाइले चमैंइ सैं एसि खी ङाँइ एइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","परमेश्‍वर चमैंए रक्षा लमिंबै पारा ग, धै ताँन् भन्दा थेबै परमेश्‍वरजी चमैंलाइ जोगेमिंम् बिसि चमैंइ मैंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","दिलेया च लिउँइँ चमैंइ सुँइ मत्‍त्रे खीलाइ थेब लइ; धै ह्रोंसए लेइ खीने स्योर ताँ पोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","चमैंए खोंइ खीए फिर भर आलल; खीजी फैबै बाछा चमैंइ फुवाल। ");
INSERT INTO gvr_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","दिलेया खीजी ल्हयो खबइले चमैंए पाप क्षमा लमिंइ, धै चमैंलाइ नास आलल; खीजी ह्रोंसए ह्रिस ल्हें खे समा थौंदिइ थेंइ, धै खीजी ह्रोंसलाइ ह्रिस खल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","चमैंम् ज्यु मत्‍त्रे ग, चमैंम् खैं धोंले ह्‍याबै ह्‍याबन् तम्, बिसि खीजी मैंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","क्यु आयोंबै क्‍ल्‍ह्‍योर चमैंइ ल्हें खे खीए बिरोध लइ, धै तोइ आकेबै क्‍ल्‍ह्‍योर खीए सैं नल् लइ! ");
INSERT INTO gvr_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","चमैंइ घरिघरि खीए जाँच लइ, धै इस्राएलए बेल्‍ले थेबै परमेश्‍वरलाइ चमैंइ ह्रिस खल् लइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","खीए शक्ति चमैंइ आमैंल, खीजी शत्तुरमैंउँइँले फ्रेमिंबै त्हिंइ चमैंइ आमैंल। ");
INSERT INTO gvr_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","च त्हेर खीजी मिश्र ह्‍युलर ह्रोंसए चिनुमैं उँइँमिंइ, धै सोअनर्बै चेप्ला तबै क्ल्ह्‍योर औदिबै केमैं लल। ");
INSERT INTO gvr_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","च त्हेरि मिश्रीमैंए स्योंमैं खीजी को लवाइ, छतसि च स्योंमैंर्बै क्यु चमैंइ थुँल् आखाँल। ");
INSERT INTO gvr_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","चमैंलाइ च्हिरिगे बिसि चमैंए म्हाँजोर खीजी च्योमिमैं कुल्मिंइ, धै नास लबै प्हद्गोमैं या कुलइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","खीजी चमैंए म्ल्ह-नारे नम्ज्योमैंइ चल् पिंइ, धै चमैंइ के लसि खबै रा-रोमैं या तिरिमैंइ चवाल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","खीजी चमैंए अँगुरए धुँमैंलाइ तिस्युइ नेरो चमैंए तोंबुए धुँमैं प्हमइ नास लल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","खीजी चमैंए खेदोमैं तिस्युइ धै चमैंए र-क्युए बगल कम्‍लि-तिम्‍लिइ ल्हिल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","चमैंने बालु खी थेबै ह्रिस खल। छतसि चमैंलाइ न्होह्रों लबर खीजी सैवाबै दूतए बगल कुलइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","खीजी ह्रोंस ह्रिस खबै घ्याँ तयार लइ; चमैंलाइ कालउँइँले आजोगेमिं, दिलेया चमैंलाइ रुडिइ नास लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","खीजी मिश्र ह्‍युलर्बै च्ह थेब्मैं ताँन् सैवाइ, हाम बिबै ह्रेंर्बै ठागुमैं या सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","धै खीजी ह्रोंसए म्हिमैं क्युमैं धोंले बैरु तेसि पखइ, धै क्यु बगल धोंले चमैंलाइ क्यु आयोंबै क्‍ल्‍ह्‍योए म्हाँजोउँइँले खीजी डोरेइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","चमैं आङ्हिंरिगे बिसि खीजी जोगेदै पखइ, दिलेया चमैंए शत्तुरमैं बिस्याँ मा ङ्युँइर प्ल्हुँयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","छले परमेश्‍वरजी ह्रोसए पबित्र ह्‍युलर चमैं डोरेइ, च कोंमैं मुँबै ह्‍युल खीजी ह्रोंसए क्योलो योइ ट्होसि चमैंलाइ पखइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","चमैंए उँइँर खीजी अरू ह्रेंमैंलाइ ल्हावाइ, झाइले चमैंए क्ह्ल्‍यो न्हेमैं खेमैंए सै न्होर धोंले भाग-भाग लसि इस्राएलीमैंलाइ पिंइ, धै कुल-कुल लसि चमैंए तम्बुर टिल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","दिलेया चमैंइ परमेश्‍वरए जाँच लइ, धै ताँन् भन्दा थेबै परमेश्‍वरए बिरोध लसि खीलाइ ह्रिस खल् लइ, धै खीजी बिबै ताँमैं आङिंल। ");
INSERT INTO gvr_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","चमैं ह्रोंसए खेबाज्युमैं धोंले बाछा फुवाब् नेरो धोका पिंब्मैं तइ, धै भर लल् आखाँबै न्होंयाबै मेत्हले धों तब् मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","नुबै कोंजरे पूजा लबै क्‍ल्‍ह्‍यो बनेसि चमैंइ खीलाइ ह्रिस खल् लइ; धै चमैंइ कुमैं बनेसि फ्योइ, छतसि खी थेबै ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","च ताँ सेसि परमेश्‍वर बेल्‍ले ह्रिस खइ, धै इस्राएलीमैंलाइ युगुर्लै पिवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","शिलोर मुँबै पबित्र तम्बुए न्होंर खी म्हिमैंए म्हाँजोर टिमल, दिलेया तोगो च तम्बु खीजी पिवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","बाछा फैसि प्ह्रिबै युमा थेंबै मुदुस खीजी अरू ह्‍युलर पिमिंइ, खीए शक्ति बेल्‍ले थेब मुँ धै खी बेल्‍ले छ्याँब मुँ बिबै चिनु खीजी शत्तुरमैंए योर पिंवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","खीजी ह्रोंसए म्हिमैं सेलाँइ सैल् पिंइ, धै चमैंने बेल्‍ले ह्रिस खइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","चमैंए फ्रेंसिमैं ताँन् मिइ ख्रोंवाइ, छतमा चमैंए च्हमिमैंए ल्हागिर ब्ह्‍या लब खाबै आयों। ");
INSERT INTO gvr_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","चमैंए खेगिमैं सेलाँइ सैवाइ, धै चमैंए म्हरेस्योमैंइ शोक ललै आयों। ");
INSERT INTO gvr_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","लिउँइँ न्हरुउँइँले छोरब् धोंले याहवेह छोरइ, अँगुरए प्हाइ पिब् धोंले खी छोरइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","खीजी ह्रोंसए बिरोधीमैं सग्याँप्हुँग्या लवाइ, खीजी खोंयोंन् बिलै चमैंलाइ फापिल् लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","छले खीजी योसेफए सन्‍तानमैं पिवाइ; खीजी एफ्राइमए कुललाइ आत्हाँ, ");
INSERT INTO gvr_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","दिलेया यहूदाए कुल नेरो ह्रोंसजी खोबै सियोन कों खीजी त्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","खीजी ह्रोंसए पबित्र क्‍ल्‍ह्‍यो नुबर मुँबै स्वर्ग धोंबन् बनेइ, धै पृथ्बी धोंलेन् खोंयोंन् बिलै तरिगे बिसि खीजी च क्ल्ह्‍यो बनेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","खीजी ह्रोंसए के लबै म्हि दाऊदलाइ त्हाँइ, धै चलाइ क्यु प्ह्रोंउँइँले तेसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","क्युमैंए छैं लबै केउँइँले दाऊद पखसि खीजी चलाइ याकूबए सन्तानए प्ह्रोंछैं तल् पिंइ, खीजी त्हाँबै इस्राएली म्हिमैंए म्रुँ तल पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","चु ङइ लल् त्हुबै के ग ङ्हाँसि दाऊदइ चमैंए छैं लइ, धै चइ चमैंलाइ छेनाले डोरेइ। ");
INSERT INTO gvr_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","आसापए भजन घ्रि। ओ परमेश्‍वर, अरू ह्रेंमैंइ क्हिए ह्‍युलए फिर ह्‍वाखइमुँ; धै क्हिए पबित्र मन्दिर चमैंइ जुठ लइमुँ; चमैंइ यरूशलेम नास लवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","क्हिए के लबै म्हिमैंए सिनु मुर प्हुरबै नमेमैंलाइ चबै ल्हागिर शत्तुरमैंइ पिंइमुँ, चमैंए से क्ह्‍योंर्बै खेदोमैं पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","शत्तुरमैंइ चुमैंए को क्यु धोंले यरूशलेमर बग्दिवाइमुँ, धै चुमैंलाइ पाबै म्हिमैं खाबै आरे। ");
INSERT INTO gvr_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","छतसि ङिए चेंदो मुँबै ह्रेंमैंइ ङिलाइ बिल्‍लि लइमुँ, झाइले ङिए खागु टिबै म्हिमैंइ ङिलाइ प्ह्रसि निस्योम्। ");
INSERT INTO gvr_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","ओ याहवेह, खोंयों समा? क्हि खोंयोंइन ङिने ह्रिस खरिब्मा? क्हिए ह्रिस मि धोंले खोंयों समा लुँरिमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","च ह्रेंमैंइ क्हिलाइ आम्हाँदि, च ह्‍युलमैंर्बै म्हिमैंइ क्हिए मिं आकिं, छतसि चमैंए फिर क्हिए ह्रिंस उँमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","तलेबिस्याँ चमैंइ याकूबलाइ क्ल्ह्‍योंवाइमुँ धै च टिबै क्‍ल्‍ह्‍यो तोइ आचैन् लवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","ङिए खेमैंइ लबै पापए हिसाब ङिने आकिंन्; ङिए फिर क्हिजी युनन् ल्हयो खमिंन्, तलेबिस्याँ ङिलाइ क्हिए थेबै खाँचो मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","ओ ङिलाइ मुक्ति पिंबै परमेश्‍वर, ङिइ क्हिए मिं थेब लरिगे बिसि ङिलाइ ल्होमिंन्। क्हिए मिं थेब लबै ल्हागिर ङिए पाप क्षमा लसि ङिलाइ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","“चमैंए परमेश्‍वर खनिर मुँ?” बिसि अरू ह्रेंमैंइ तले बिए? क्हिए के लब्मैंए बग्दिबै कोए खी क्हिजीन् किंम् बिसि अरू ह्रेंमैंइ सेरिगे! ङिज्यै या म्रोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","झेलर मुँब्मैंइ ल्हयो खल्‍ले ओरबै कै क्हि ङाँर फेनेरिगे; सिल् त्हुबै दण्ड योंब्मैंलाइ क्हिए थेबै शक्‍तिउँइँले रक्षा लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","ओ प्रभु, क्हिलाइ प्ह्रसि ङिए ङ्‍हेब् ट्हुब्मैंइ क्हिए मिं वाइमुँ, छतसि चए ङिखे गुणा खी चमैंने किंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","छ लमा ङि, क्हिए म्हिमैं, क्हिए खर्गर्बै क्युमैं ग। छतसि ङि खोंयोंन् बिलै क्हिए मिं क्वेब्मुँ; पुस्त-पुस्त समा ङिइ क्हिए छ्याँबै बयन लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","क्वे प्रिंब्मैंए चिबलाइ, “बाछाए लिलि टमैं” बिबै भाकार प्रिंबै आसापए भजन घ्रि। ओ इस्राएलए प्ह्रोंछैं, न्ह तोमिंन्! तलेबिस्याँ क्युए बगल धोंले क्हिजी योसेफए सन्तानमैंलाइ डोरेम्। क्हि करूबमैंए म्हाँजोर टिम्, छतसि क्हिए शक्ति उँइँमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","एफ्राइम, बेन्यामीन नेरो मनश्शे बिबै कुलमैंए उँइँर क्हिए शक्ति उँइँमिंन्, धै ङि जोगेमिंबर युमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","ओ परमेश्‍वर, ङिए ह्‍युल धबै भोंब लमिंन्; ङिए फिर लहयो लद्, धै ङि सोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","ओ याहवेह, स्वर्गर्बै सेनामैंए चिब, परमेश्‍वर, ह्रोंसए म्हिमैंए प्राथना थेसि खोंयों समा क्हि ह्रिस खरिब्मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","क्हिजी चबै ल्हागिर चमैंलाइ न्हुँ पिंइमुँ, धै ल्हें-ल्हें मिग्लि थुँल् पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","क्हिजी ङिए खागु टिबै ह्रेंमैं प्होंबर खल् पिंइमुँ, धै ङिए शत्तुरमैंइ ङिलाइ प्ह्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","ओ सेनामैंए परमेश्‍वर, ङिए ह्‍युल धबै भोंब लमिंन्; ङिए फिर लहयो लद्, धै ङि सोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","अँगुरए धुँ घ्रि धोंले क्हिजी ङिलाइ मिश्र ह्‍युलउँइँले पखमिंइ; क्हिजी अरू ह्रेंमैं ल्हावासि च धुँ कनान ह्‍युलर रुँइँइ। ");
INSERT INTO gvr_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","क्हिजी च रुँइँबै ल्हागिर स ताइ; च धुँए जर गैरुले च्योंमा च जर ह्‍युल तिगोंन् फैलिदिइ। ");
INSERT INTO gvr_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","च धुँए छरिइ कोंमैं हुवाब् धोंले ङिइ ताँन् ह्‍युल ट्होवाइ, चए हाँगमैंइ लेबनानर्बै थे-थेबै देवदारु बिबै धुँमैं हुवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","चए हाँगमैं थेबै मा ङ्युँइ समा नेरो चए च्होमैं यूफ्रेटिस बिबै स्यों समा फैलिदिइ। ");
INSERT INTO gvr_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","दिलेया तोगो च अँगुरए धुँ मुँबै गारामैं क्हिजी तले फुवाल? च घ्याँउँइँले ह्‍याब्मैं ताँनइ चए रोमैं ह्‍योम्। ");
INSERT INTO gvr_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","क्ह्‍योंर्बै तिलिमैंइ च धुँ नास लब् धोंले, धै क्ह्‍योंर्बै खेदोमैंइ चए रोमैं चब् धोंले, ङिए खागु मुँबै ह्रेंमैंइ ङिलाइ नास लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","ओ सेनामैंए परमेश्‍वर, ङि ङाँइ तोमिंन्! स्वर्गउँइँले क्युरु ङ्ह्‍योमिंन्, धै च अँगुरए धुँ छेनाले छैं लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","च अँगुरए धुँ क्हिजी ह्रोंसए क्योलो योइ रुँइँब् ग, धै क्हिजी ह्रोंसए ल्हागिर फारमिंबै च्ह ङि ग! ");
INSERT INTO gvr_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","दिलेया शत्तुरमैंइ क्हिए अँगुरए धुँ थोवासि मिइ ख्रोंइमुँ! क्हिजी हौदिमा क्हिए म्हिमैं नास तयाम्! ");
INSERT INTO gvr_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","ह्रोंसजी त्हाँबै ह्रेंलाइ आशिक पिंन्! चमैंलाइ क्हिजी भोंब् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","छलस्याँ क्हिउँइँले ङि खोंयोंइ क्हो तोरिब् आरे; ङिलाइ सोगों लमिंनु, धै ङि क्हिए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","ओ याहवेह, क्हि स्वर्गर्बै सेनामैंए चिब, नेरो परमेश्‍वरन् ग! ङिए ह्‍युल धबै भोंब लमिंन्; ङिए फिर लहयो लद्, धै ङि सोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर: गित्तित ह्राब् धोंलेन् आसापए भजन परमेश्‍वरए मिंर सैं तोंदै क्वे प्रिंन्! खी ङ्योए शक्ति ग, छतसि थेबै कै तेदै याकूबए परमेश्‍वरए जयजय लद्! ");
INSERT INTO gvr_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","क्वे प्रिंन्! खैंजडि ह्राद्! सारङ्गी नेरो बीणा या छेनाले ह्राद्! ");
INSERT INTO gvr_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","ङ्योए थेबै चाड सुरु लबर औंसि नेरो पूर्नेर क्यु साँडेए रूँए थुतुरु ह्राद्। ");
INSERT INTO gvr_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","इस्राएलए ल्हागिर चु निसाफ घ्रि ग, याकूबए परमेश्‍वरजी लद् बिसि ल्हैदिबै ताँ ग, ");
INSERT INTO gvr_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","खी मिश्र ह्‍युलए बिरोधर रेमा योसेफए ह्रेंए ल्हागिर खीजी निसाफ घ्रि बिथेंइ। च क्‍ल्‍ह्‍योर्न ङइ ङो आसेबै कै छ बिब् थेल: ");
INSERT INTO gvr_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“क्हेमैंए प्हैंदउँइँले ङइ ल्हिबै ति तमिंइ; ल्हिबै ट्हलोउँइँले क्हेमैंए यो तेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","दुःख तमा क्हेमैंइ ङने ग्वार ह्रिइ, धै क्हेमैंए दु:खउँइँले ङइ फ्रेमिंइ। मु ङ्हेबै क्‍ल्‍ह्‍योउँइँले खाबज्यै आम्रोंल्‍ले ङइ क्हेमैंलाइ ज्वाफ पिंइ; मेरिबार त्होंखबै क्युर ङइ क्हेमैंए जाँच लइ। तियाँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","“ओ ङए म्हिमैं थेद्! ङइ क्हेमैंलाइ लोदा सैंदा लब्मुँ! ओ इस्राएल, क्हेमैंइ ङए ताँ थेब् गो बिस्याँ! ");
INSERT INTO gvr_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","क्हेमैंए म्हाँजोर आगुए देवता थेंल् आत; क्हेमैं अरू ह्रेंए देवताए ओंसों कुरल् आत। ");
INSERT INTO gvr_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","ङ याहवेह क्हेमैंए परमेश्‍वर ग, क्हेमैंलाइ मिश्र ह्‍युलउँइँले ङइ तेसि पखइ। क्हेमैंए सुँ आँ लद्, ङइ म्रेंन्ले चल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“दिलेया ङ‍ए म्हिमैंइ ङइ बिबै ताँ थेल् आङिं; इस्रएल ङए न्होंर टिल् आङिं। ");
INSERT INTO gvr_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","छतसि चमैं खेंमैंए सैंर मैंब् धोंले प्ररिगे बिसि चमैंए सैंर्बै इच्छार्न ङइ पिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","ङए म्हिमैंइ ङए कै थेरिगे, धै इस्राएल ङए घ्याँर प्ररिगे बिब ङए सैं मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","छतस्याँ चमैंए शत्तुरमैंलाइ ङइ युनन् ट्होवामल, धै चमैंलाइ दुःख पिंब्मैंए बिरोधर ङए यो रेमल! ");
INSERT INTO gvr_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","याहवेहलाइ तो धोंइ आङ्हाँब्मैं खी म्रोंसि ङ्हिंमल, दिलेया चमैंइ खोंयोंन् बिलै दण्ड योंरिल् त्हुमल। ");
INSERT INTO gvr_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","दिलेया ङइ इस्राएलीमैंलाइ ताँन् भन्दा छ्याँबै गहुँ चल् पिंमल, धै पारार्बै खुदुइ क्हेमैंलाइ म्रेंल् पिंमल।” ");
INSERT INTO gvr_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","आसापए भजन घ्रि। स्वर्गर्बै म्हिमैंए च्होंर परमेश्‍वर टिइमुँ; देवतामैंए उँइँर खीजी निसाफ लम्: ");
INSERT INTO gvr_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","“खोंयों समा क्हेमैं अनिया लब्मैंए ख लरिमुँ? धै दुष्‍टमैं ङाँइन ल्हैदिरिमुँ?” बिइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","“ङ्हाँदुमैं नेरो आबा आरेब्मैंल ठिक निसाफ लमिंन्; आयों-आख्युब्मैं नेरो आगुइ क्र ओलै आपिंब्मैंए रक्षा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","आखाँब्मैं नेरो आयों-आख्युब्मैं जोगेमिंन्; दुष्‍टमैंए योउँइँले चमैंलाइ फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","क्हेमैंने ज्ञान आरे, क्होल् आखाँ, क्हेमैं मिछु खैबर प्ररिम्; ठिमइ बिब् धोंले आप्र। ");
INSERT INTO gvr_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","“क्हेमैं देवतामैं ग!” बिसि ङइ बिल। “क्हेमैं ताँन् भन्दा थेबै परमेश्‍वरए च्हमैं ग, ");
INSERT INTO gvr_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","दिलेया म्हिमैं धोंले क्हेमैं सिब्मुँ, धै चिब्मैं धोंले क्हमैं नास तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","ओ परमेश्‍वर, रेत्ति, पृथ्बीए निसाफ लमिंन्; तलेबिस्याँ ताँन् ह्रें-ह्रेंमैंए हग वाल क्हि ग। ");
INSERT INTO gvr_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","आसापए भजन घ्रि, क्वे घ्रि। ओ परमेश्‍वर, क्हि आपोंल्‍ले आटिमिंन्! ओ परमेश्‍वर, तोइ आबिल्‍ले आटिमिंन्, के आलल्‍ले आटिमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","ङ्ह्‍योत्ति, क्हिए शत्तुरमैं सयो खब् धों तइमुँ, क्हि आखोब्मैंइ क्र कैंडो लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","चमैंइ स्योर तेसि क्हिए म्हिमैंलाइ ङो चुइमुँ, क्हिए खोबै म्हिमैंए बिरोधर चमैंइ ताँ लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","“खो, ङ्यो चमैंए ह्रें नास लले; धै इस्राएलीमैंए मिं क्ह्रन् म्हयारिगे,” बिसि चमैंइ बिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","चमैं सैं घ्रि तसि जाल् रोइमुँ, क्हिए बिरोध लबै ताँर चमैंइ मत लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","एदोमथेंमैं नेरो इश्माएलीमैं, मोआबीमैं नेरो हग्रिमैं, ");
INSERT INTO gvr_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","गबालि, अम्‍मोनि नेरो अमालेकी, पलिश्ती नेरो टुरोसथेंमैं, चुमैं ताँन् क्हिए बिरोधर मत लसि क्ह्रिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","लोतए सन्‍तानमैंलाइ ल्होबर अश्शूरीमैं या चमैंनेन् क्ह्रिइमुँ। तिस्या मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","मिद्यानिमैंलाइ क्हिजी सैब् धोंले, किशोन स्योंर सिसरा नेरो याबिनलाइ क्हिजी लब् धोंले, क्हिए फिर जाल रोब्मैंलाज्यै या लद्। ");
INSERT INTO gvr_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","सिसरा नेरो याबिनलाइ एन्दोर बिबै क्ल्ह्‍योर क्हिजी नास लवासि चमैंए ज्यु सर क्राँयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","छलेन चमैंए क्रथे मिंथेमैंलाइ ओरब नेरो जएब धोंन् लमिंन्, जेबह नेरो सल्मुन्‍नालाइ धोंले चमैंए चिब्मैंलाज्यै या लमिंन्, ");
INSERT INTO gvr_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","तलेबिस्याँ “परमेश्‍वरजी ह्रोंसए म्हिमैंलाइ पिंबै क्‍ल्‍ह्‍यो ङ्योइ क्ल्हे लले,” बिसि जेबह नेरो सल्मुन्‍नाइ बिल। ");
INSERT INTO gvr_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","ओ ङए परमेश्‍वर, चमैंलाइ छाज्यै प्लिल् खाँब छुज्यै प्लिल् खाँबै नो धों, नेरो खैंइ नोबोबै पुइ धों लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","खैले मिइ क्ह्‍यों (बन) ख्रोंसि मेउरो लवाम्, धै मिए राबाइ कोंमैं ख्रोंवाम्, ");
INSERT INTO gvr_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","छलेन क्हिए थेबै नाँ-बाडिइ चमैंलाइ ङ्हिंन् लसि क्हिए थेबै नाँ-खैंइ चमैंलाइ ल्हामिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","ओ याहवेह, चमैंइ क्हिए मिं म्हैप्ररिगे बिसि चमैंए लि फापिन् लवाद्। ");
INSERT INTO gvr_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","ह्‍युल तिगोंन् क्हि मत्‍त्रे ताँन् भन्दा थेबै परमेश्‍वर ग धै क्हिए मिं याहवेह ग सेरिगे बिसि ");
INSERT INTO gvr_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","चमैं खोंयोंन् बिलै फापिल् त्हुरिगे, चमैं ङ्हिंरिगे, धै चमैं आब्रु ह्‍याल्‍ले सियारिगे। ");
INSERT INTO gvr_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर: गित्तित भाकार कोराए च्हमैंए भजन घ्रि। ओ स्वर्गर्बै सेनामैंए चिब याहवेह, क्हि टिबै क्‍ल्‍ह्‍यो कति छ्याँब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","याहवेहए धिंर टिबै ल्हागिर ङए सोइ थेबै इच्छा लम्, धै मूर्छ तम्; ङए खों नेरो ज्युइ सैं तोंसि खोंयोंन् बिलै तरिबै परमेश्‍वरलाइ क्वे प्रिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","ओ स्वर्गर्बै सेनामैंए चिब याहवेह, ङए म्रुँ नेरो ङए परमेश्‍वर, क्हिए मिंर ख्रो पिंबै थाँनए चेंदो कोल्मेंइ प्हसे योंमुँ, धै चिब्लिमैंइ च्हों थासि ह्रोंसए प्हसेमैं चर थेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","क्हिए धिंर टिसि खोंयोंन् बिलै क्हिए मिंर क्वे प्रिंरिब्मैंइ आशिक योंम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","क्हिउँइँले भों योंब्मैं, नेरो सियोन कोंर ह्‍याबै सैं लब्मैंइ आशिक योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","चमैं बाका बिबै ब्याँसि तसि ह्‍यामा चर क्युए मुल् बनेम्; बर्खर्बै नाँइ चर ङ्ह्‍योखोमैं तम्। ");
INSERT INTO gvr_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","चमैं ताँन् सियोनर देवतामैंए परमेश्‍वरए आम्रोंखन् समा चमैंइ भोंए फिर भों योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","ओ स्वर्गर्बै सेनामैंए चिब याहवेह परमेश्‍वर, ङए प्राथना थेमिंन्; ओ याकूबए परमेश्‍वर, ङए ताँ थेमिंन्! तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","ओ परमेश्‍वर, ढाल धोंले ङिलाइ जोगेबै म्रुँ ङाँइ ङ्ह्‍योमिंन्; छ्युगु फोसि त्हाँबै ह्रोंसए म्हिए फिर मि ङ्ह्‍योमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","अरू क्‍ल्‍ह्‍योजरे हजार त्हिंइमैं थोब् भन्दा क्हिए ह्‍युमैंर तिगें टिब छ्याँब तम्। दुष्‍टमैंए तम्बुमैंर टिब् भन्दा बरु ङए परमेश्‍वरए धिंर रुँबै म्हि तब ङलाइ खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","तलेबिस्याँ याहवेह परमेश्‍वर त्हिंयाँ नेरो ढाल ग; याहवेहजी दयाम्हाँया लमुँ धै मान इजेत पिंम्; ठिक घ्याँर प्रब्मैंलाइ खीजी ताँन् छ्याँबै सैमैं पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","ओ स्वर्गर्बै सेनामैंए चिब याहवेह, क्हिए फिर भर थेंबै म्हिइ आशिक योंम्! ");
INSERT INTO gvr_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","क्वे प्रिंब्मैंए चिबए लागिर कोराए च्हमैंए भजन घ्रि। ओ याहवेह, ह्रोंसए ह्‍युलए फिर क्हिजी ल्हयो उँइँमिंइ; याकूबए सन्तानमैंए सुख शान्ति क्हिजी एमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","ह्रोंसए म्हिमैंए आछ्याँबै केमैं क्हिजी क्षमा लमिंइ; चमैंए ताँन् पापमैं क्हिजी हुमिंइ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","क्हिजी ह्रिस खब पिवाइ; धै लुँरिबै ह्रिसउँइँले एखइ। ");
INSERT INTO gvr_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","ओ ङिलाइ मुक्ति पिंबै परमेश्‍वर, ङिलाइ एपखमिंन्, धै ङिए फिर खबै क्हिए ह्रिस म्हमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","ङिने बालु क्हि खोंयोंइन ह्रिस खरिम्मा? पुस्ता-पुसता समा ङिने बालु ह्रिस खरिम्मा? ");
INSERT INTO gvr_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","क्हिए म्हिमैं क्हिने बालुन् सैं तोंल् योंरिगे बिसि ङिलाइ धबै भोंसि आलमिं वा? ");
INSERT INTO gvr_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","ओ याहवेह, खोंयोंइ आनुबै क्हिए म्हाँया ङिने उँइँमिंन्, धै क्हिउँइँले योंबै मुक्ति ङिलाइ पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","याहवेह परमेश्‍वरजी बिबै ताँमैं ङ थेरिब्मुँ, तलेबिस्याँ खीए म्हिमैंने खीजी शान्तिए ताँ पोंब्मुँ। दिलेया चमैं धबै आछ्याँबै घ्याँर आप्ररिगे! ");
INSERT INTO gvr_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","क्ह्रोंसेन्ले खीलाइ मान लब्मैंलाइ खीजी खैतबै त्हेरै या जोगेमिंब्मुँ; छतसि ङ्योए ह्‍युलर खी मुँ बिसि ङ्योइ था सेल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","खोंयोंइ आनुबै म्हाँया लबै परमेश‍वर नेरो भर लल् खाँबै इस्राएलीमैं क्ह्रिइमुँ; परमेश्‍वरजी ठिक के लमा म्हिमैं छिं ङ्हाँल् योंम्। धै म्हिमैंइ परमेश्‍वरने म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","म्हिमैंइ परमेश्‍वरए फिर भर लमा पृथ्‍बीउँइँलेन् मुर फेनेम्, परमेश्‍वरजी ठिक के लमा स्वर्गउँइँले क्युरु ङ्ह्‍योम्। ");
INSERT INTO gvr_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","याहवेहजी छ्याँबै सैमैं ङ्योलाइ खैलसेया पिंब्मुँ, धै ङ्योए म्रोंइ ल्हें रा-रोमैं रोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","परमेश्‍वरजी लबै ठिक केमैं खीए ओंसों-ओंसों ह्‍याब्मुँ, धै खीए ल्हागिर घ्याँ तयार लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","दाऊदए प्राथना ओ याहवेह, ङए प्राथना थेमिंन् धै ज्वाफ पिंन्, तलेबिस्याँ ङ ङ्हाँदु नेरो आयों आख्युब् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","क्हिजी बिबै ताँ ङइ ङिंम्, ङलाइ रक्षा लमिंन्। क्हि ङए परमेश्‍वर ग। छतसि क्हिए के लबै म्हिलाइ जोगेमिंन्, ङइ क्हिए फिर भर लम्। ");
INSERT INTO gvr_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","ओ प्रभु, ङए फिर दयाम्हाँया लमिंन्, तलेबिस्याँ ङ त्हिंइतिमिन् क्हिए मिं किंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","क्हिए के लबै म्हिलाइ सैं तोंल् लमिंन्, तलेबिस्याँ ओ प्रभु, ङ क्हिलाइन प्राथना लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","तलेबिस्याँ ओ प्रभु, क्हि स्वाब नेरो क्षमा पिंरिब् मुँ, क्हिए मिं किंब्मैं ताँनलाइ क्हिजी खोंयोंइ आनुबै थेबै म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","ओ याहवेह, ङए प्राथानर क्हिए न्ह तोमिंन्; ल्होमिंन् बिसि ग्वार ह्रिमा ङए ताँ थेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","ङए दुःखए त्हिंइर ङ क्हिने ग्वार ह्रिमुँ, तलेबिस्याँ क्हिजी ज्वाफ पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","ओ प्रभु, क्हि धों तब अरू देवतामैं खाबै आरे, क्हिजी लब् धों तबै केमैं अरू खाबज्यै या लल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","ओ प्रभु, क्हिजी बनेबै ताँन् ह्रें-ह्रेंमैं क्हिए उँइँर कुरब्मुँ, धै चमैंइ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","तलेबिस्याँ क्हि बेल्‍ले थेब मुँ धै औदिबै केमैं लम्; घ्रि मत्‍त्रे परमेश्‍वर क्हि ग। ");
INSERT INTO gvr_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","ओ याहवेह, क्हिए घ्याँर प्रबर ङलाइ लोमिंन्, धै क्हिए क्ह्रोसेंन्बै घ्याँर ङ प्रब्मुँ; क्हिए मिंलाइ ङइ मान लल् खाँरिगे बिसि ङए सैं खोंयोंन् बिलै क्हि ङाँइन तल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","ओ याहवेह ङए परमेश्‍वर, ङए खों न्होंउँइँले ङ क्हिए मिं थेब् लब्मुँ, धै ङ खोंयोंन् बिलै क्हिए मिं क्वेब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","तलेबिस्याँ ङए फिर क्हिए खोंयोंइ आनुबै म्हाँया बेल्‍ले थेब मुँ; धै क्हिजी ङए सो क्रोंर्बै गैरु क्ल्ह्‍योउँइँले फ्रेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","ओ परमेश्‍वर, घमण्डि म्हिमैं ङए बिरोधर रेइमुँ; दयाम्हाँया आरेब्मैंइ ङलाइ सैल् म्हैइमुँ; धै च म्हिमैंइ क्हिलाइ आमैं। ");
INSERT INTO gvr_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","दिलेया ओ प्रभु, क्हि ल्हयो खब नेरो दयाम्हाँया मुँबै परमेश्‍वर ग, युनन् ह्रिस आखब, ताँनए फिर खोंयोंइ आनुबै म्हाँया लब नेरो भर लल् खाँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","ङए फिर दयाम्हाँया लसि ङ ङाँइ तोमिंनु; ह्रोंसए के लबै म्हिलाइ क्हिए शक्ति पिंनु, धै ह्रोंसए केब्स्योए च्हलाइ जोगेमिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","ओ याहवेह, क्हिजी ङ ल्होमिंइमुँ धै ङए सैं क्होमिंइमुँ। छतसि क्हिजी ङिए फिर छ्याँबन् लम् बिसि ङलाइ चिनु घ्रि उँइँमिंन्, धै ङलाइ आखोब्मैं च चिनु म्रोंसि फापिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","कोरहए च्हमैंए भजन घ्रि, क्वे घ्रि। याहवेहजी ह्रोंसए सहरए जग पबित्र कोंर झोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","याकूबए सन्तानमैं टिबै ताँन् क्‍ल्‍ह्‍योमैं भन्दा खीजी यरूशलेम सहर ल्हें म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","ओ परमेश्‍वरए सहर, क्हिए बारेर छ्याँब बयन लइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","ङलाइ ङोसेबै ह्रेंमैं न्होंर ङ मिश्र नेरो बेबिलोनए बारेर बिमिंब्मुँ; धै पलिश्त, टुरोस नेरो कूश ह्‍युलर्बै म्हिमैंए बारेरै या “चु यरूशलेमर्न फिल!” बिसि ङ चमैं ङए म्हिमैं ठर्दिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","म्हिमैंइ सियोनए बारेर छले बिब्मुँ, “चु तान् म्हि चर्न फिल; झाइले ताँन् भन्दा थेबै परमेश्‍वरजीन् चलाइ भोंब लमिंब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","याहवेहजी ह्रें-ह्रेंर्बै मिं प्ह्रिमा “चुमैं ताँन् यरूशलेमर्बै म्हिमैं ग,” बिसि प्ह्रिब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","“ओ यरूशलेम, ङए ताँन् आशिकमैं योंबै क्ल्ह्‍यो क्हिन् ग!” बिसि चमैंइ बाजा ह्रामा क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","कोराए च्हमैंए भजन घ्रि, क्वे घ्रि, क्वे प्रिंब्मैंए चिबलाइ, “महलत-लिन्‍नोत” बिबै भाका धोंलेन् प्रिंल् त्हुम्। हेमान एज्रिए मस्किल घ्रि। ओ याहवेह, ङलाइ जोगेमिंबै परमेश्‍वर; ङइ त्हिंयाँ म्हुँइँस क्हिने ग्वार ह्रिइमुँ; ");
INSERT INTO gvr_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","क्हिए उँइँर ङए प्राथना फेनेरिगे; ङइ ग्वार ह्रिमा क्हिए न्ह तोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","तलेबिस्याँ ङए सैंर ल्हें दुःख तइमुँ, छतसि युनन् ङ क्रोंर फेनेबि छेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","क्रोंर फेनेबै म्हि धोंन् ङ तइमुँ; भों आरेबै म्हि धोंन् ङ तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","सिनुमैंने बालु ङलाइ थेंमिंइमुँ, छगोंर रोबै सैवाबै म्हिमैं धोंले ङ तइमुँ। क्हिजी खोंयोंइ चमैंलाइ आमैं, क्हिजी चमैंलाइ वास्ता आलल्‍ले पिवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","क्हिजी ङलाइ क्रोंर्बै ताँन् भन्दा गैरु मिछु खैब क्‍ल्‍ह्‍योर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","क्हिए ह्रिसइ ङलाइ प्लेथेंइमुँ, धै क्हिजी ह्रोंसए ह्रिसइ ङलाइ दु:ख पिंइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","ङए खोबै थुमैंने क्हिजी ङ ह्रेंगो लमिंइमुँ; चमैंए उँइँर क्हिजी ङ आखोब् लमिंइमुँ। ङ च्युथेंइमुँ, छतसि ङ बैरु त्होल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","शोकइ लमा ङए मिइ छेनाले म्रोंल् आखाँ। ओ याहवेह, त्हिंइ ह्रोंसे ङ क्हिनेन् ग्वार ह्रिइमुँ; ङए यो क्हि ङाँइन स्योंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","सिनुमैंने क्हिजी ह्रोंसए औदिबै केमैं उँइँम्मा? च सिनुमैं सोगों तसि क्हिए मिं थेब् लम् रो वा? तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","क्हिजी लबै खोंयोंइ आनुबै म्हाँयाए बारेर छगोंर बयन लम्मा? धै नास तबै क्ल्ह्‍योर क्हि भर लल् खाँब मुँ बिसि खाबज्यै बिल् खाँम्मा? ");
INSERT INTO gvr_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","क्हिजी लबै औदिबै केमैं मिछु खैबै क्‍ल्‍ह्‍योर म्रोंल् खाँम्‍मा? धै क्हिजी लबै ठिक केमैं मैंल् खाँबै शक्ति नुयाबै त्हेरै म्रोंल् खाँम् रो वा? ");
INSERT INTO gvr_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","दिलेया ओ याहवेह, ङम् क्हिनेन् ग्वार ह्रिमुँ; धै न्हाँकर्न ङइ लबै प्राथना क्हिए उँइँर खम्। ");
INSERT INTO gvr_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","ओ याहवेह, क्हिजी ङलाइ तले पिवाल? ङउँइँले ह्रोंसए लि तले लोल? ");
INSERT INTO gvr_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","कोलो ओंनोंन् ङए फिर दुःख तइमुँ, धै सिबि छेइमुँ, क्हिजी हौदिबइले ङ बेल्‍ले ङ्हिंइमुँ, छतसि ङए सैं च्योंब तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","क्हिए ह्रिस ङए फिर खइमुँ; क्हिजी हौदिमा ङ नास तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","त्हिंइ ह्रोंसे क्हिजी क्युइ धोंले ङलाइ घेर्दिसि हुइमुँ; खन्तदोंउँइँले क्हिजी ङलाइ घेर्दिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","ङए थुमैं नेरो ङए फिर म्हाँया लब्मैंलाइ क्हिजी ङउँइँले ह्रेंगो लवाइ; छतसि मिछु खैबै क्ल्ह्‍यो ङने क्ह्रिबै थु तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","एतान एज्रिए मस्किल घ्रि। याहवेहजी लबै खोंयोंइ आनुबै म्हाँयाए बारेर ङइ खोंयोंइ क्वे प्रिंब्मुँ; क्हि भर लल् खाँब मुँ बिसि ङइ ताँन् पुस्ता-पुस्ताने बिमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","“क्हिए आनुबै म्हाँया खोंयोंन् बिलै तरिब्मुँ; मु तरिब् धोंले क्हिए ताँ खोंयोंन् बिलै भर लल् खाँब लइमुँ,” बिसि ङ बिप्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","“ङइ त्हाँबै म्हिने बाछा फैइमुँ,” बिसि याहवेहजी बिइ। “ङए के लबै म्हि दाऊदने ङइ चु कसम चइमुँ: ");
INSERT INTO gvr_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘क्हिए सन्तानलाइ खोंयोंन् बिलै ङइ म्रुँ तल् पिंब्मुँ, धै क्हिए ग्याल्स पुस्ता-पुस्ता समा तल् पिंब्मुँ,’ बिसि ङए के लबै म्हि दाऊदने कसम चइमुँ।” तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","ओ याहवेह, क्हिजी औदिबै केमैं लइमुँ धै क्हि भर लल् खाँब मुँ बिसि स्वर्गदूतमैं च्होंबै क्ल्ह्‍योर चमैंइ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","तलेबिस्याँ मुर मुँब्मैं न्होंर याहवेहने बालु खाब् च्हैंल् खाँमुँ? स्वर्गर्बै सो प्ह्‍याबै सैमैं न्होंरै या याहवेह धों तब खाब् मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","स्वर्गदूतमैं च्होंबै क्ल्ह्‍योर परमेश्‍वरने बेल्‍ले ङ्हिंल् त्हुम्, धै खीए खागु मुँब्मैंइ खीए मान लल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","ओ स्वर्गर्बै सेनामैंए चिब याहवेह परमेश्‍वर, क्हि धों तब शक्ति मुँब खाब् मुँ? ओ याहवेह, क्हि तोन्दोंरि सैर भर लल् खाँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","प्ल्हों खबै मा ङ्युँइलाइ क्हिजीन् तार झोंम्; चए भेल्गलाइ क्हिजीन् च्याँ लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","क्हिजी सैवाबै म्हि धोंले राहाबलाइ त्हुल भुँ लवाइ; क्हिजी ह्रोंसए शत्तुरमैंलाइ ह्रोंसए भोंबै योजी सग्याँ प्हुँग्याँ लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","मु क्हिलन् ग; पृथ्बी या क्हिलन् ग; ताँन् ह्‍युल नेरो चर मुँबै तोन्दोंरि सै क्हिजीन् बनेब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","उत्तर नेरो दक्षिण क्हिजीन् बनेब् ग; तबोर नेरो हेर्मोन कोंमैं सैं तोंदै क्हिए मिंर क्वे प्रिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","क्हिए पाख्रर बेल्‍ले शक्ति मुँ; क्हिए यो भोंब मुँ, क्हिए क्योलो यो नुब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","ठिक के नेरो ठिक निसाफ लसि क्हिजी ग्याल्स लम्; क्हिजी खोंयोंन् आनुबै म्हाँया नेरो भर लल् खाँबै के लम्। ");
INSERT INTO gvr_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","ओ याहवेह, क्हिए छ्याँबै बयन लल् ह्रब्मैं आशिक योंम्, चमैं क्हिए ल्हयोए ह्‍वेर प्ररिम्। ");
INSERT INTO gvr_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","चमैं त्हिंइतिमिन् क्हिए मिं किंसि सैं तोंम्, धै क्हिजी लबै ठिक केमैं म्रोंसि चमैं आनन्द तम्। ");
INSERT INTO gvr_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","तलेबिस्याँ क्हिजीन् चमैंलाइ थेबै शक्ति पिंम्। क्हिए म्हाँयाजी ङिलाइ ट्होल् लमिंइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","तलेबिस्याँ ढालइ धोंले ङिलाइ रक्षा लमिंबै म्हि याहवेहलन् ग, इस्राएलर्बै पबित्र परमेश्‍वरजी ङिलाइ ङिए म्रुँ पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","क्हिजी बिब् ङिंबै म्हिने तिखे दर्शनर बिइ: “ङइ बेल्‍ले भोंबै म्हिलाइ भों पिंइमुँ; इस्राएली म्हिमैंए न्होंउँइँले त्हाँबै म्हिलाइ ङइ म्रुँ लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","ङए के लबै म्हि दाऊदलाइ ङइ योंइमुँ; ह्रोंसए पबित्र छ्युगु फोसि ङइ चलाइ त्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","ङए यो चए फिर तब्मुँ; ङए पाख्रइ चलाइ भोंब लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","शत्तुरमैं खाबज्यै या चलाइ ट्होरिब् आरे; दुष्‍टमैंइ चलाइ दुःख पिंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","चए बिरोधीमैंलाइ चए उँइँर्न त्हुल भुँ लवाब्मुँ, धै चलाइ आखोब्मैंलाइ ङइ सैवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","ङलाइ चइ भर लल् खाँब्मुँ धै ङइ खोंयोंइ आनुबै म्हाँया चने लब्मुँ, धै ङए मिंउँइँले च भोंब तब्मुँ ");
INSERT INTO gvr_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","ङइ चए यो मा ङ्युँइए फिर धै चए क्योलो यो स्योंमैंए फिर थेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","चइ ङने छ बिसि बिन्ति लब्मुँ, ‘क्हि ङए आबा, ङए परमेश्‍वर ग, धै क्हिजी ङ जोगेमिंसि रक्षा लमिंम्।’ ");
INSERT INTO gvr_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","चलाइ ङए च्ह थेब लमिंब्मुँ, पृथ्बीर्बै म्रुँमैंए न्होंर ताँन् भन्दा थेब चलाइ लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","ङइ चए फिर ङए म्हाँया खोंयोंन् बिलै थेंब्मुँ, धै चने बालु फैबै ङए बाछा खोंयोंन् बिलै तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","चए सन्तानलाइ खोंयोंन् बिलै ङ भोंब लमिंब्मुँ, धै चए ग्याल्स मु मुँन् समा तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“चए प्हसेमैंइ ङए ठिम आम्हाँदिइ बिस्याँ धै ङए निसाफमैंर आप्रइ बिस्याँ, ");
INSERT INTO gvr_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","ङए निसाफमैं चमैंइ फुवाइ बिस्याँ धै ङए ताँ आङिंइ बिस्याँ, ");
INSERT INTO gvr_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","चमैंइ लबै पापए सजैं प्हरेइ पिंब्मुँ, धै चमैंइ लबै आछ्याँबै केमैंए सजैं कोरइ प्रुब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","दिलेया ङए खोंयोंइ आनुबै म्हाँया दाऊदउँइँले स्योरिब् आरे, चने बालु ङइ फैबै बाछा ङ भर पर्दिल्‍ले लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","ङइ फैबै बाछा ङ फुरिब् आरे, ङए सुँउँइँले त्होंबै बचन ङ फेर्दिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","‘दाऊदए सन्तान खोंयोंन् बिलै तरिब्मुँ, धै त्हिंयाँ मुँन् समा चए राजगद्दि ङए उँइँर तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","मुर लयाँ भर लल् खाँबै साक्षि तरिब् धोंले दाऊदए राजगद्दि ङइ खोंयोंन् बिलै थेंमिंब्मुँ,’ बिसि ");
INSERT INTO gvr_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","ह्रोंसए पबित्र मिंर ङइ खोंयोंबै ल्हागिर कसम चइमुँ; दाऊदलाइ ङ स्योर तेरिब् आरे।” तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","दिलेया छ्युगु फोसि त्हाँबै ह्रोंसए म्हिलाइ ह्रिस खसि क्हिजी पिवाइमुँ, धै तो धोंइ आङ्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","ह्रोंसए के लबै म्हिने क्हिजी बाछा टोंवाँइमुँ; चए मुकुट सर कोंवासि क्हिजी अपबित्र लवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","चए यरूशलेम सहर रक्षा लबै ताँन् गारामैं क्हिजी फुवाइमुँ; धै चए किल्‍लामैं नास लवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","च घ्याँ तसि ह्‍याब्मैं ताँनइ चए सहर लुडिइमुँ; धै ह्रोंसए ङ्‍हेब्मैंइ चलाइ प्ह्रइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","चए शत्तुरमैंए क्योलो यो क्हिजी ट्होल् लमिंइमुँ; चए ताँन् शत्तुरमैंलाइ क्हिजी सैं तोंल् लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","चए सेलाँए धार क्हिजी आछ्याँरब् लमिंइमुँ, धै ल्हडेर ह्‍याल् आखाँब् लमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","चए मान क्हिजी प्हेंवाइमुँ, धै चए राजगद्दि सर भ्योंवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","चए छ्ह क्हिजी रिंठि लमिंइमुँ; क्हिजी चलाइ फापिन् लवाइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","ओ याहवेह, ह्रोंसलाइ युगुर्लै लोथेंब्मुँ? क्हिए ह्रिस खोंयों समा मि धोंले लुँरिब्मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","ङए छ्ह कति रिंठि मुँ बिसि मैंमिंन्दि! क्हिजी म्हिमैंलाइ फाकर्न बनेल् वा? ");
INSERT INTO gvr_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","आसिल्‍ले खोंयोंन् बिलै सोरिबै म्हि खाब् मुँ? खाबइ ह्रोंसए सोलाइ क्रोंउँइँले फ्रेल् खाँमुँ? तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","ओ प्रभु, क्हिजी लबै खोंयोंइ आनुबै ओंसोंबै म्हाँया खनिर ह्‍याइ? क्हिजी दाऊदने बालु म्हाँया लब्मुँ बिसि चबै कसम खनिर ह्‍याइ? ");
INSERT INTO gvr_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","ओ प्रभु, क्हिए के लबै म्हिलाइ म्हिमैंइ खैले प्ह्रइमुँ, धै अरू ह्रेंमैंइ गाल् केब ङइ खैले सैदिरिइमुँ, च ताँ मैंमिंन्दि। ");
INSERT INTO gvr_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","ओ याहवेह, क्हिए शत्तुरमैंइ ङलाइ हेल लइमुँ, क्हिजी छ्युगु फोसि त्हाँबै म्हिलाइ चमैंइ प्ह्रइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","याहवेहए मिं खोंयोंन् बिलै थेब् तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","परमेश्‍वरए म्हि मोशाइ लबै प्राथना घ्रि ओ प्रभु, पुस्ताउँइँले पुस्ता समा ङिए टिबै क्‍ल्‍ह्‍यो क्हि तमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","कोंमैं तखब् भन्दा ओंसों, क्हिजी पृथ्बी नेरो ह्‍युल बनेब भन्दा ओंसों, ओंसोंउँइँले लिउँइँ समा क्हिन् परमेश्‍वर ग। ");
INSERT INTO gvr_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","“ओ म्हिए प्हसेमैं सर एखो!” बिसि क्हिजी म्हिमैं स त्हुलर कोंमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","क्हिए ल्हागिर हजार बर्ष घ्रि ह्‍याबै त्हिंइ घ्रि धों मत्‍त्रे ग, धै म्हुँइँसर्बै तिस्याँ मत्‍त्रे धों तब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","नाँए प्हलें युब् धोंले क्हिजी म्हिमैंलाइ बोयाम्, चमैं न्हाँगर्बै म्‍लोखबै छि धोंब मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","च न्हाँगर मल्गेमुँ धै थेब् तदै ह्‍यामुँ, ङेसर च ङ्योंलोंसि कारयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","क्हिए ह्रिसर ङि नास तइमुँ, क्हि थेबै ह्रिस खमा ङि ङ्हिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","ङिइ लबै छेरन् ङ्हाँबै केमैं क्हिजी ङ्ह्‍योरिइमुँ, ङिए न्होंर्बै आम्रोंबै पापमैं क्हिजी म्रोंरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","क्हिए थेबै ह्रिसर ङिए ताँन् त्हिंइमैं थोम्; ङिइ ह्रोंसए बर्षमैं दुःखर नुयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","ङिए छ्ह ङिंच्यु बर्ष मत्‍त्रे ग, भों लस्याँ प्रेच्यु बर्ष सोलै; दिलेया च छ्ह दुःख नेरो न्हुँ लसि थोइ; च त्हिंइमैं युनन् ह्‍याम्, धै ङि सियाम्। ");
INSERT INTO gvr_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","क्हिए ह्रिस कति ल्हें मुँ बिसि खाबइ क्होइमुँ? क्हिए थेबै ह्रिस क्हिलाइ लल् त्हुबै मान धों तब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","छतसि ङिइ बुद्धि योंल् खाँरिगे बिसि ङिए छ्ह कति रिंन्ठि मुँ बिसि ङिलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","अझै क्हि खोंयों समा ह्रिस खरिमुँ? ओ याहवेह, ह्रोंसए के लब्मैंए फिर ल्हयो खमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","ङिए छ्ह तिगोंन् सैं तोंदै निस्योल योंरिगे बिसि क्हिए खोंयोंइ आनुबै म्हाँयाजी न्हाँगर्न ङिलाइ छिं ङ्हाँन् लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","कति त्हिंइ समा क्हिजी ङिए फिर दुःख पिंइ, धै कति बर्षमैं आगुइ ङिलाइ ह्रुगुदिइमुँ, च्हगन् ङिलाइ सैं तोंन् लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","क्हिए के लब्मैंने क्हिजी लबै केमैं उँइँमिंन्, धै क्हिजी लबै औदिबै केमैं ङिए सन्‍तानमैंलाइ म्रोंल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","ङिए याहवेह परमेश्‍वरए आशिक ङिए फिर तरिगे, ङिए योइ लबै केमैं ङिए ल्हागिर छ्याँब् लमिंन्; ङिए योइ लबै केमैं छ्याँब् लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","ताँन् भन्दा थेबै परमेश्‍वरने ग्वार ह्रिबै म्हि तोन्दोंरि लल् खाँबै परमेश्‍वरए छरि न्होंर टिरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","याहवेहए बारेर ङ बिब्मुँ, “खी ङए ग्वार योंबै क्‍ल्‍ह्‍यो नेरो ङए किल्‍ला ग, खी ङए परमेश्‍वर ग, खीए फिर ङइ भर थेंम्।” ");
INSERT INTO gvr_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","नमे सैब्मैंए ङोउँइँले नेरो आछ्याँबै ह्रिंउँइँले खीजी क्हिलाइ खैलसेया जोगेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","खीजी ह्रोंसए प्ह्‍यागोंइ क्हिलाइ हुमिंब्मुँ, धै खीए प्ह्‍यागों न्होंर क्हिइ ग्वार योंब्मुँ; खी भर लल् खाँबै परमेश्‍वर ग, छतसि ढाल तसि खीजी क्हिलाइ रक्षा लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","म्हुँइँसर ङ्हिंन् लखबै सैउँइँले नेरो त्हिंइर प्हुरसि खबै मेउँइँले क्हि ङ्हिंल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","मिछु खैबर खबै ह्रिं, नेरो त्हिंइ आधार नास लबै नब् छबउँइँले क्हि ङ्हिंल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","क्हिए रेर हजार घ्रि म्हि धै क्हिए क्योलो योउँइँ हजार च्यु म्हि क्हुरियाले या च सैइ क्हिलाइ स्यारिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","क्हिइ ह्रोंसए मिइ मत्‍त्रे च म्रोंब्मुँ धै दुष्‍टमैंइ योंबै सजैं म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","याहवेहने क्हि टिरिम्, ताँन् भन्दा थेबै परमेश्‍वर क्हिइ ग्वार योंबै क्‍ल्‍ह्‍यो तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","छतसि क्हिल तोइ नोक्सन् तरिब् आरे, क्हि टिबै धिं ङाँर ह्रिंमैं खरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","तलेबिस्याँ प्रबै घ्याँजरे क्हिलाइ जोगेबर खीजी ह्रोंसए स्वर्गदूतमैं कुलब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","क्हिए प्हले युँमार आथुररिगे बिसि स्वर्गदूतमैंइ क्हिलाइ यो-योर्न तोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","सिंह नेरो गोमनलाइ क्हिजी प्लेब्मुँ; भखर्बै सिंह नेरो प्हुरिलाइ क्हिइ प्हले न्होंर प्लेवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","“चइ ङने म्हाँया लबइले ङइ चए दुःखउँइँले फ्रेमिंब्मुँ, चइ ङए मिं किंइमुँ, छतसि ङइ चए रक्षा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","चइ ग्वार ह्रिमा ङइ चलाइ ज्वाफ पिंब्मुँ; चए दुःखर ङ चने बालु तब्मुँ; चए दुःखउँइँले ङइ फ्रेमिंब्मुँ, धै चलाइ थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","ह्रिंबै छ्ह पिंसि ङइ चलाइ सन्तोक् लमिंब्मुँ धै चलाइ जोगेमिंब्मुँ,” बिसि ङइ दर्शन पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","प्रिबै त्हिंइर प्रिंबै क्वे घ्रि। ओ ताँन् भन्दा थेबै परमेश्‍वर, क्हिए मिंर क्वे प्रिंब नेरो याहवेहलाइ धन्यबाद पिंब बेल्‍ले छ्याँबै ताँ ग। ");
INSERT INTO gvr_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","ङिए फिर क्हिजी लबै खोंयोंइ आनुबै म्हाँयाए बारेर न्हाँगर प्रिंब, धै म्हुँइँसर क्हि भर लल् खाँबै परमेश्‍वर ग बिसि बयन लब, ");
INSERT INTO gvr_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","झाइले तार च्यु मुँबै सारङ्गी नेरो बीणा ह्रादै क्हिए मिं क्वेब बेल्‍ले छ्याँबै ताँ ग। ");
INSERT INTO gvr_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","तलेबिस्याँ ओ याहवेह, क्हिजी ह्रोंसए केमैंउँइँले ङए सैं तोंल् लमिंइमुँ; क्हिए योजी लबै केमैं म्रोंसि ङ बेल्‍ले सैं तोंदै क्वे प्रिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","ओ याहवेह, क्हिजी लबै केमैं कति थेब मुँ! क्हिए बिचारमैं कति गैरु मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","दिलेया च्हैंब-मैंब लल् आखाँबै म्हिइ चु ताँ क्होल् आखाँ; आमादुइ चु ताँ क्होल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","दुष्‍ट म्हिमैं छि धोंले मौलिदिलेया धै आछ्याँबै के लब्मैंल बिब् धों मैंब् धों तलेया, चमैं युगुर्ले नास तयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","दिलेया ओ याहवेह, क्हि खोंयोंन् बिलै नुबै क्‍ल्‍ह्‍योर मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","ओ याहवेह, क्हिए शत्तुरमैं क्ह्रोंसेंन्ले नास तब्मुँ; दुष्‍ट म्हिमैं ताँन् सग्याँ प्हुग्याँ तयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","ङ बिस्याँ क्ह्‍योंर्बै साँढे धोंले क्हिजी ङए भों थेब लमिंब्मुँ; छ्युगु फोसि ङलाइ त्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","ङए शत्तुरमैं हार्दिब ङए मिइ म्रोंइमुँ; ङए शत्तुरमैं ल्हावाबै ताँ ङए न्हइ थेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","ठिक के लबै म्हिमैं बिस्याँ छोग्रए धुँ धोंले मौलदिम्; लेबनानल कोंर्बै थेबै देवदारु सिं धुँ धोंले चमैं थेब त-तै ह्‍याब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","याहवेहजी च म्हिमैंलाइ ह्रोंसए धिंर रुँइँइमुँ; चमैं ङ्योए परमेश्‍वरए मन्दिरर मौलिदिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","खिब् तयालैया चमैंइ रो ल्हें रोब्मुँ; चमैं ताजा नेरो पिंक्यो ब्योंब् तरिब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","धै “याहवेह स्वाब मुँ; खी ङ रक्षा लमिंबै पारा ग, धै खीजी आछ्याँबै के खोंयोंइ आल!” बिसि बयन लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","याहवेहजी ग्याल्स लमुँ! म्रुँइ खिब् धों तबै क्वें खीजी खिम्, फगि खिसि भों खब् धोंले याहवेह बेल्‍ले शक्‍ति मुँब मुँ। पृथ्बीए तें बेल्‍ले भोंब् मुँ, च खोंयोंइ छाइ-छुइ तरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","ओ याहवेह, क्हि टिबै राजगद्दि स्योंम् ओंनोंन् भोंन्ले थेंइमुँ, क्हि ओंसों ओंनोंन् मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","ओ याहवेह, मा ङ्युँइमैं प्ल्हों खइमुँ, चए भेल्कमैं बेल्‍ले ओरइमुँ, चए थेबै भेल्कमैं प्ल्हों खइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","दिलेया चए कै भन्दा, थेबै मा ङ्युँइए भोंबै भेल्कमैं भन्दै या, ताँन् भन्दा क्होंवाइ टिबै याहवेह बेल्‍ले भोंब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","क्हिजी पिंबै ठिमैं ताँनइ भर लल् खाँब मुँ। ओ याहवेह, क्हिए धिं खोंयोंन् बिलै पबित्र मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","ओ याहवेह, क्हिजी आछ्याँबै के लब्मैंलाइ दण्ड पिंम्, ह्रोंसए ह्रिस उँइँन्! ");
INSERT INTO gvr_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","ओ पृथ्बीर्बै नियाधिश रेत्ति; थेब् प्हैंब्मैंइ लबै केए दण्ड चमैंलाइ पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","ओ याहवेह, दुष्‍टमैं खोंयों समा, दुष्‍टमैं खोंयों समा सैं तोंरिल् योंब्मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","चमैं प्हैंसि ताँ लरिम्; दुष्‍ट म्हिमैं थेब् प्हैंरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","ओ याहवेह, क्हिए म्हिमैंलाइ चमैंइ प्लेम्, धै क्हिजी त्हाँबै म्हिमैंलाइ ह्रुगिदिम्। ");
INSERT INTO gvr_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","म्हरेस्यो नेरो बिदेशिमैंलाइ चमैंइ सैम्, छलेन आबा आरेब्मैंलाज्यै या सैम्; ");
INSERT INTO gvr_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","“याहवेहजी आम्रों; याकूबए परमेश्‍वरजी वास्ता आल,” बिसि चमैंइ बिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","ओ ङए म्हिमैंए न्होंर्बै च्हैंब् मैंब् लल् आखाँब्मैं, मैंन्दि! ओ मुर्खमैं, क्हेमैं खोंयों च्हैंब् मैंब् लल् खाँब्मैं तमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","न्ह बनेमिंबै परमेश्‍वरजी ङ्योए ताँ आथे रो वा? मि बनेमिंबै परमेश्‍वरजी आम्रों रो वा? ");
INSERT INTO gvr_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","अरू ह्रेंमैंलाइ दु:ख पिंबै परमेश्‍वरजी दण्ड आपिं रो वा? म्हिमैंलाइ लोमिंबै परमेश्‍वरने बुद्धिए खाँचो तम् रो वा? ");
INSERT INTO gvr_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","याहवेहजी म्हिमैंए सैंर्बै ताँमैं क्होम्, चमैं केर आफेब्मैं ग बिसि खीजी सेम्। ");
INSERT INTO gvr_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","ओ याहवेह, क्हिजी तार झोंबै म्हि नेरो ह्रोंसए ठिमउँइँले क्हिजी लोमिंबै म्हिइ आशिक योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","दुष्‍टमैंए ल्हागिर होल्दों आतन् समा ठिक के लब्मैंए फिर दुःख तलेया क्हिजी छिं ङ्हाँल् पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","तलेबिस्याँ याहवेहजी ह्रोंसए म्हिमैंलाइ भ्योंरिब् आरे; खीजी ह्रोंसजी त्हाँबै म्हिमैं पिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","न्याय लब्मैंइ धबै ठिक निसाफ लब्मुँ, धै छ्याँबै सैं प्ह्‍याब्मैं ताँन् च ठिक निसाफए लिलि प्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","दुष्‍ट म्हिमैंए बिरोधर ङने बालु खाब् रामुँ? आछ्याँबै के लब्मैंए बिरोधर ङए ख लसि खाब् रामुँ? ");
INSERT INTO gvr_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","याहवेहजी ङ आल्होस्याँ ङए सो उँयाँनन् तोइ कै आथेबै क्रोंर ह्‍यामल। ");
INSERT INTO gvr_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","ओ याहवेह, “ङए प्हले प्लेइमुँ” बिसि ङ‌इ बिमा क्हिए खोंयोंइ आनुबै म्हाँयाजी ङ थौंदिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","ङए सैंर बेल्‍ले न्हुँ तमा क्हिजी ङए सैं क्होमिंसि तोंल् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","दुष्‍ट क्रथे मिंथेमैं क्हिने बालु क्ह्रिल् खाँम्‍मा? ह्रोंसइ बनेबै निसाफमैंउँइँले चमैंइ अनिया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","ठिक के लब्मैंए बिरोधर चमैं जाल रोम्, धै तोइ छ्याब् आरेबै म्हिलाइ सैवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","दिलेया याहवेह ङए किल्‍ला तमिंइमुँ, छतसि ङए परमेश्‍वर ङ रक्षा लमिंबै पारा ग। ");
INSERT INTO gvr_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","चमैंइ लबै पाप खीजी चमैंए फिर्न कुमिंब्मुँ, धै दुष्‍ट केमैं लबइले चमैंलाइ नास लवाब्मुँ; ङ्योए याहवेह परमेश्‍वरजी चमैं नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","खो, याहवेहए मिंर ङ्यो क्वे प्रिंले! ङ्यो रक्षा लमिंबै पारा ङाँर ह्‍यासि सैं तोंदै कै तेसि ओरले! ");
INSERT INTO gvr_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","धन्यबाद पिंदै खीए ओंसों ह्‍याले, सैं तोंदै कै तेसि खीए मिं थेब् लले! ");
INSERT INTO gvr_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","तलेबिस्याँ याहवेह बेल्‍ले थेबै परमेश्‍वर ग, ताँन् देवतामैंए फिर्बै थेबै म्रुँ खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","खीए योर पृथ्‍बीर्बै गैरु-गैरु क्‍ल्‍ह्‍योमैं मुँ, नु-नुबै क्लिं क्हाँए च्होमैं या खीलन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","मा ङ्युँइ खीलन् ग, खीजीन् च बनेब् ग, धै कार क्‍ल्‍ह्‍यो या खीए योजीन् बनेब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","खो, क्र कुरसि खीलाइ फ्योले धै ङ्यो बनेबै याहवेहए ओंसों च्हि तुँले! ");
INSERT INTO gvr_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","तलेबिस्याँ खीन् ङ्योए परमेश्‍वर ग, धै ङ्यो खीए खर्गर्बै क्युमैं, नेरो खीए म्हिमैं ग। तिंयाँ क्हेमैंइ खीए कै थेद्! ");
INSERT INTO gvr_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","याहवेहजी छले बिमुँ, “क्हेमैंए खेमैंइ मेरीबा नेरो क्यु आयोंबै क्‍ल्‍ह्‍योर्बै मस्साहर लब् धोंले ह्रोंसए सैं सारो आलद्। ");
INSERT INTO gvr_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","चर ङइ लबै केमैं क्हेमैंए खेमैंइ म्रोंसे या चमैंइ ङए जाँच लइ। ");
INSERT INTO gvr_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","छतसि च त्हेर्बै म्हिमैंने ङ प्लिच्यु बर्ष समा बेल्‍ले ह्रिस खसि बिइ, ‘चु म्हिमैंइ ङए घ्याँ आसेइमुँ, चुमैंए सैं ङ ङाँइले ह्रेंगो तयाइमुँ।’ ");
INSERT INTO gvr_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","छतसि ‘ङइ भों न्हल् पिंबै क्‍ल्‍ह्‍योर चुमैं खोंयोंइ होंल् योंरिब् आरे!’ बिसि ह्रिसर ङइ कसम चइ।” ");
INSERT INTO gvr_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","‍‍एयाहवेहए मिंर छारा क्वे घ्रि प्रिंन्; पृथ्बी तिगोंर्बै म्हिमैंइ याहवेहए ल्हागिर क्वे प्रिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","याहवेहए ल्हागिर क्वे प्रिंन्, खीए मिं क्वेद्; खीजी ङ्योलाइ जोगेमिंइमुँ बिसि त्हिंइ ह्रोंसे बिप्रद्! ");
INSERT INTO gvr_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","खी बेल्‍ले थेब मुँ बिसि अरू ह्रेंमैंए म्हाँजोर बिप्रद्, ताँन् म्हिमैंए म्हाँजोर खीजी लबै औदिबै केमैंए बयन लद्! ");
INSERT INTO gvr_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","तलेबिस्याँ याहवेह बेल्‍ले थेब मुँ, धै खीए मिं बेल्‍ले नुल्‍ले क्वेल् त्हुब मुँ; ताँन् देवतामैंल् भन्दा खीए मिं बेल्‍ले क्वेल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","तलेबिस्याँ अरू ह्रेंमैंइ म्हाँदिबै देवतामैं कु मत्‍त्रे ग, दिलेया याहवेहजीम् मु बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","खीए उँइँर इजेत नेरो मान मुँ; खीए पबित्र क्‍ल्‍ह्‍यो म्रोंमा खी कति भोंब मुँ, कति छ्याँब् मुँ बिसि सेल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","ओ ह्रें-ह्रेंमैंए परवा, याहवेहए बयन लद्! याहवेहए मिं बेल्‍ले थेब् मुँ, खी बेल्‍ले भोंब् मुँ बिसि बयन लद्! ");
INSERT INTO gvr_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","खीए मिंलाइ ङ्‍हेंबै मान याहवेहलाइ पिंन्; भेटि किंसि खीए ह्‍युमैंर खो! ");
INSERT INTO gvr_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","खी पबित्र नेरो छ्याँब तब् सेसि याहवेहलाइ फ्योद्; पृथ्बी तिगोंर्बै म्हिमैं खीए उँइँर थरथरले त्हारद्। ");
INSERT INTO gvr_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","“याहवेहजी ग्याल्स लम्! खीजीम् पृथ्‍बी भोंब् लसि थेंमिंइमुँ, छतसि चलाइ लाल् आखाँ; खीजी खाबलाज्यै आफेलल्‍ले ताँन् म्हिमैंए निसाफ लब्मुँ,” बिसि अरू ह्रेंमैंए म्हाँजोर बिद्! ");
INSERT INTO gvr_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","मु आनन्द तरिगे, पृथ्बी सैं तोंरिगे; मा ङ्युँइ नेरो चर मुँबै तोन्दोंरि सैं बेल्‍ले तोंरिगे; ");
INSERT INTO gvr_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","म्रों नेरो चर मुँबै तोन्दोंरि सै बेल्‍ले तोंरिगे! छलेन क्ह्‍योंर्बै ताँन् सिंधुँमैं आनन्दले याहवेहए उँइँर क्वे प्रिंब्मुँ; ");
INSERT INTO gvr_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","तलेबिस्याँ खी युसिन् मुँ, पृथ्बीर मुँबै म्हिमैंए निसाफ लबर खी युसिन् मुँ। ह्‍युलर्बै म्हिमैंए निसाफ खीजी ठिकले लब्मुँ; धै खीजी ह्रेंमैंए निसाफ भर लल् खाँल्‍ले लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","याहवेहजी ग्याल्स लम्, पृथ्‍बी सैं तोंरिगे; मा ङ्युँइर्बै कोंमैं सैं तोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","खीए कारर्ग्युले न्हाँम्स्यो नेरो मिछु खैब मुँ; राजगद्दिर टिसि खीजी ठिक केमैं नेरो ठिक निसाफ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","खीए ओंसों ओंसों मि ह्‍यामुँ, धै खीए कारर्ग्यु मुँबै शत्तुरमैं ख्रोंवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","खीए कम्‍लि-तिम्‍लिइ ह्‍युलर चारम्; पृथ्‍बीइ म्रोंसि थरथरले त्हारम्। ");
INSERT INTO gvr_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","ताँन् ह्‍युलर्बै क्ल्हे याहवेहए उँइँर क्योंलों धोंले कोंमैं युलियाम्। ");
INSERT INTO gvr_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","खीजी लबै ठिक केमैंए बयन मुइ लम्, धै खी कति थेब मुँ बिसि ताँन् ह्रेंमैंइ म्रोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","कु पूजा लब्मैं ताँन् फापिल् त्हुम्, कुलाइ थेबै सै ङ्हाँसि फ्योब्मैं ताँन् फापिल् त्हुम्; छतसि ओ ताँन् देवतामैं, खीए प्हले फ्योद्! ");
INSERT INTO gvr_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","ओ याहवेह, क्हिजी ठिक निसाफ लबै ताँ सियोनर्बै म्हिमैंइ थेसि सैं तोंइमुँ, धै यहूदार्बै नाँसमैं सैं तोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","तलेबिस्याँ ओ याहवेह, ह्‍युलए फिर ताँन् भन्दा थेबै परमेश्‍वर क्हिन् म्रुँ ग; ताँन् देवतामैं भन्दा थेब क्हिन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","याहवेहने म्हाँया लब्मैं ताँनइ आछ्याँबै केमैं लब पिवारिगे! तलेबिस्याँ खीजी ह्रोंसए म्हिमैंलाइ रक्षा लमिंम्; धै दुष्‍टमैंए योउँइँले चमैं फ्रेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","ठिक के लब्मैंए फिर परमेश्‍वरए ह्‍वे चारम्, धै छ्याँबै खों प्ह्‍याब्मैं सैं तोंल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","ओ ठिक के लब्मैं, याहवेहने सैं तोंन्, धै खीए पबित्र मिंर धन्यबाद पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","भजन घ्रि। याहवेहए मिंर छारा क्वे प्रिंन्, तलेबिस्याँ खीजी औदिबै केमैं लइमुँ! खीए क्योलो यो नेरो पबित्र योजी ह्रोंसए म्हिमैं दु:खउँइँले फ्रेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","खीए त्हाँबै म्हिमैं जोगेमिंब याहवेहजी उँइँमिंइमुँ; धै खीजी ह्रोंसए ठिक केमैं ह्रें-ह्रेंमैंए ओंसों उँइँमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","इस्राएलए परवाए फिर लबै खोंयोंइ आनुबै म्हाँया नेरो चमैंइ खोंयोंइ खीए फिर भर लल् खाँम् बिसि याहवेहजी मैंइमुँ। ङ्योए परमेश्‍वरजी जोगेमिंबै केमैं ह्‍युलर्बै ताँन् साँदर टिबै ह्रेंमैंइ म्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","ओ ताँन् ह्‍युलर्बै म्हिमैं, सैं तोंदै याहवेहए मिंर कै तेद्; सैं तोंदै क्वे प्रिंसि खीए जयजय लद्। ");
INSERT INTO gvr_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","बीणा ह्रादै क्ह्‍युरल्‍ले भजन प्रिंन्, बीणा ह्रादै याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","थुतुरु नेरो क्युए रु ह्रादै याहवेह म्रुँए उँइँर सैं तोंदै कै तेसि ओरद्। ");
INSERT INTO gvr_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","मा ङ्युँइ नेरो चर मुँबै ताँन् सो प्ह्‍याबै सैमैंइ थेबै कैले खीए मिं क्वेरिगे; छलेन पृथ्बी नेरो चर मुँबै तोन्दोंरि सैमैंज्यै या थेबै कै तेरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","स्योंमैंइ योप्ल्ह ह्रारिगे; कोंमैंइ सैं तोंदै तिखेर्न क्वे प्रिंरिगे; ");
INSERT INTO gvr_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","चमैं ताँनइ याहवेहए उँइँर क्वे प्रिंरिगे, तलेबिस्याँ निसाफ लबर खी पृथ्बीर युम्। खीजी ह्‍युलर ठिक निसाफ लब्मुँ, धै ह्रें-ह्रेंर्बै म्हिमैं खाबै आफेलल्‍ले खीजी ठिक निसाफ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","याहवेहजी ग्याल्स लम्; छतसि ह्रें-ह्रेंमैं त्हाररिगे! करूबमैंए म्हाँजोर खी क्हुँम्; पृथ्बी लारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","सियोनर याहवेह थेब मुँ; ताँन् ह्रेंमैंए फिर खी बेल्‍ले थेब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","बेल्‍ले मान लल् त्हुबै क्हिए मिं चमैंइ थेब् लरिगे! खी पबित्र मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","म्रुँ बेल्‍ले भोंब मुँ, ठिक निसाफ खीजी खोम्। क्हिजी खाबै आफेलल्‍ले निसाफ लमुँ; याकूबए सन्तानमैंए फिर क्हिजी ठिक निसाफ नेरो ठिक के लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","ङ्योए याहवेह परमेश्‍वरए मिं क्वेद्; धै खीए प्हले फ्योद्! तलेबिस्याँ खी पबित्र मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","मोशा नेरो हारून खीए खेगिमैं मुँल, खीए मिं किंब्मैं न्होंर शमूएल मुँल। चमैंइ याहवेहने ग्वार ह्रिमा खीजी चमैंलाइ ज्वाफ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","न्हाँम्स्योए त्हो तसि खी चमैंने पोंइ; खीजी बिबै ताँमैं नेरो ठिममैं चमैंइ म्हाँदिइ। ");
INSERT INTO gvr_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","ओ ङिए याहवेह परमेश्‍वर, क्हिजी चमैंलाइ ज्वाफ पिंइ; क्हिजी चमैंइ लबै आछ्याँबै केमैंए दण्ड पिंलेया चमैंलाइ क्षमा पिंबै परमेश्‍वर क्हि ग। ");
INSERT INTO gvr_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","ङ्योए याहवेह परमेश्‍वरए मिं थेब् लद्, धै खीए पबित्र कोंर खीए मिं क्वेद्; तलेबिस्याँ ङ्योए याहवेह परमेश्‍वर पबित्र मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","धन्यबाद पिंबै भजन घ्रि। ओ ताँन् ह्‍युलर्बै म्हिमैं याहवेहए मिंर सैं तोंदै कै तेसि ओरद्! ");
INSERT INTO gvr_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","सैं तोंदै याहवेह फ्योद्! सैं तोंबै क्वे प्रिंसि खीए उँइँर खो! ");
INSERT INTO gvr_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","याहवेहन् परमेश्‍वर ग बिसि सेद्! खीजीन् ङ्योलाइ खीए म्हिमैं तल् पिंइ, ङ्यो खीलन् ग, छतसि ङ्यो खीए म्हिमैं नेरो खीए खर्गर्बै क्युमैं ग। ");
INSERT INTO gvr_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","धन्यबाद पिंदै खीए तगरउँइँले न्होंर होंन्, धै खीए मिं क्वेदै खीए ह्‍युमैंर ह्‍याद्! धै खीए मिं थेब् लदै धन्यबाद पिंन्, ");
INSERT INTO gvr_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","तलेबिस्याँ याहवेह स्वाब मुँ, खीए म्हाँया खोंयोंन् बिलै तरिमुँ, पुस्ता-पुस्ता समान् खीए फिर ङ्योइ भर लल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","दाऊदए भजन घ्रि। क्हिजी लबै खोंयोंइ आनुबै म्हाँया नेरो ठिक निसाफए बारेर ङ क्वे प्रिंब्मुँ; ओ याहवेह, क्हिए मिंर ङ क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","न्ह क्रों मि क्रोंले ङ छ्याब् आरेबै छ्ह थोब्मुँ। ङ ङाँर क्हि खोंयों युमुँ? छ्याँबै बानि ब्योर लसि ङ ह्रोंसए धिंर छ्ह थोब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","केर आफेबै सैमैं ङ‍ए उँइँर थेंरिब् आरे। दुष्‍ट के लब्मैंलाइ ङ आखो; छाबै म्हिमैंने ङ प्ररिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","आछ्याँबै सैं प्ह्‍याब्मैंने ङ ह्रेंगोन् टिब्मुँ; दुष्‍ट केमैं ङ खोंयोंइ लरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","न्हों-न्हों ह्रोंसए ङ्‍हेब्मैंए ताँ लबै म्हिलाइ ङइ नास लब्मुँ। ह्रोंसन् ह्रब् सेब् प्हैंसि थेब् प्हैंबै म्हिलाइ ङ सैदिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","भर लल् खाँबै म्हिमैं ङने बालु टिल् योंरिगे बिसि चमैंए फिर ङए मि छरिमुँ; ठिक घ्याँर प्रबै म्हिइ ङए सेवा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","छलु म्हिलु लबै म्हि ङए धिंर टिल् योंरिब् आरे; स्योलिबै ताँ पोंबै म्हि ङए उँइँर टिल् योंरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","ह्‍युलर्बै ताँन् दुष्‍ट म्हिमैं ङइ न्हाँग ह्रोंसे नास लवाब्मुँ, दुष्‍ट के लब्मैं ताँनलाइ याहवेहए सहरउँइँले ङइ ल्हावाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","दुःख तबै त्हेर लबै प्राथना। दुःख तमा याहवेहने ह्रोंसए दुःख ङेम्। ओ याहवेह, ङए प्राथना थेमिंन्; ल्होमिंन् बिसि लबै प्राथना क्हि ङाँर फेनेरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","ङए फिर दुःख तमा क्हिए लि ङ ङाँइँले आलोमिंन्! क्हिए न्ह ङ ङाँइ तोमिंन्; धै ङइ ग्वार ह्रिमा ङलाइ युनन् ज्वाफ पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","तलेबिस्याँ मिखु धोंले ङए छ्ह ह्‍यारिइमुँ, धै मिए राबइ ख्रोंब् धोंले ङए ह्रिबमैं ख्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","ङए खों छि धोंले ङ्योंलोंसि काराह्‍याइमुँ; धै ङ‍इ चब् चबै या म्‍लेयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","ङए सैंर ल्हें न्हुँ मुँ, छतसि ङए ज्यु ह्रिब नेरो ट्हुबि मत्‍त्रे तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","क्यु आयोंबै क्‍ल्‍ह्‍योर्बै खोंगों धोंले ङ घ्रिन् तसि टिइमुँ, तोइ आचैल्‍ले फुह्‍याबै धिंर टिबै खोंगों धों ङ तइमुँ; ");
INSERT INTO gvr_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","न्हरु आखसि ङ आरोल्‍ले टिरिइमुँ; धै धिं फिर्बै थुने फ्रेयाबै नमे धों ङ तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","ङए शत्तुरमैंइ त्हिंतिमिन् ङलाइ स्यारम्; ङलाइ प्ह्रसि निस्युब्मैंइ ङ खै ङहाँल् त्हुइमुँ चमैंया छान् ङ्हाँल् त्हुरिगे बिसि आगुलाइ सराप पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","क्हि ह्रिस खबइले चबै सै धोंले ङइ मेब्रो चइमुँ, ");
INSERT INTO gvr_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","धै मिग्लि कोंबै क्यु थुँइमुँ। तलेबिस्याँ क्हिजी ङलाइ क्वेसि तिराइ भ्योंवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","ङए छ्ह ङेसार्बै छरि धोंन् तब् ग; ङ छि धोंले ङ्योंलोंयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","दिलेया ओ याहवेह, क्हि खोंयोंन् बिलै राजगद्दिर टिरिम्; पुस्ता-पुस्ता समा क्हिलाइ मैंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","क्हि राब्मुँ धै सियोनाए फिर ल्हयो खब्मुँ; सियोनाए फिर ल्हयो खबै त्हे तोगोन् ग; तौदिबै त्हे फेखइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","सियोन नास तयाल् खाँलेया क्हिए के लबै म्हिमैंइ चर्बै युँममैं म्हाँया लम्; धै चर्बै त्हुलए फिरै या ल्हयो खम्। ");
INSERT INTO gvr_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","याहवेहए मिंर ताँन् ह्रेंमैं ङ्हिंब्मुँ, पृथ्बीर्बै ताँन् म्रुँमैंइ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","तलेबिस्याँ याहवेहजी धबै सियोन बनेमिंब्मुँ; झाइले ह्रोंसइ योंबै मानर खी युब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","दु:ख योंब्मैंइ लबै प्राथना खीजी थेब्मुँ; धै चमैंए प्राथना थेलेया आथेब् धों आल। ");
INSERT INTO gvr_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","“नुबै क्‍ल्‍ह्‍योर मुँबै ह्रोंसए पबित्र क्ल्ह्‍योउँइँले याहवेहजी क्युरु ङ्ह्‍योइ; खीजी स्वर्गउँइँले पृथ्बीर ङ्ह्‍योइ। ");
INSERT INTO gvr_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","झेलर च्युथेंब्मैंइ ग्वार ह्रिब खीजी थेइ, धै सिल त्हुबै म्हिमैंलाइ जोगेमिंइ,” बिसि ");
INSERT INTO gvr_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","तिंयाँ समा आफिबै म्हिमैंइ याहवेहए मिं थेब् लरिगे धै लिउँइँ खबै पुस्तामैंए ल्हागिर चु ताँ प्ह्रिसि थेंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","छले सियोनर चमैंइ याहवेहए मिंए बयन लरिगे, धै यरूशलेमर खीए मिं थेब् लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","च त्हेर याहवेहए मिं क्वेबर ह्रें-ह्रेंर्बै म्हिमैं नेरो ग्याल्स ग्याल्सर्बै म्हिमैं चर खागु तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","ङए छ्ह थोदै लमा खीजी ङए भों नुवाइमुँ; धै ङए छ्ह रिंठि लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","छतसि ङइ बिइ, “ओ ङए परमेश्‍वर, आधा बैंसार्न ङलाइ आबोमिंन्।” पुस्ता पुस्ता समा क्हिए बर्षमैं तरिम्! ");
INSERT INTO gvr_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","स्योंमन् क्हिजी पृथ्बीए जग झोंमिंइ, धै मु क्हिए योजीन् बनेब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","च सैमैं नास तयाब्मुँ, क्हि बिस्याँ खोंयोंन् बिलै तरिब्मुँ; क्वें धोंले चमैं स्योब तयाब्मुँ। क्वें फेर्दिब् धोंले क्हिजी प्लिसि फेर्दिमिंब्मुँ, धै चमैं ताँन् भ्योंवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","दिलेया क्हि बिस्याँ खोंयोंइ आफेर्दि, धै क्हिए छ्ह खोंयोंइ आनु। ");
INSERT INTO gvr_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","ङिए च्ह-च्हमिमैं क्हिए रक्षा योंसि टिब्मुँ; धै चमैंए प्हसेमैं या तोइ आतल्‍ले क्हिए उँइँर टिरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","दाऊए भजन घ्रि ओ ङए सो, याहवेहए मिं क्वेद्; ओ ङए खों, खीए पबित्र मिं थेब लद्! ");
INSERT INTO gvr_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","ओ ङए सो, याहवेहए मिं क्वेद्; धै खीजी लबै छ्याँबै केमैं आम्‍लेद्। ");
INSERT INTO gvr_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","क्हिइ लबै ताँन् छेरन् ङ्हाँबै केमैं खीजी क्षमा लमिंम्; धै क्हिए ताँन् नब-छब सल् लमिंम्, ");
INSERT INTO gvr_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","खीजी क्हि कालउँइँले जोगेमिंम्; धै मुकुट कुब् धोंले खीए खोंयोंइ आनुबै म्हाँया नेरो क्हिए फिर खीजी ल्हयो खम्। ");
INSERT INTO gvr_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","क्व्रे धोंले क्हिए छ्ह धबै छारा तरिगे बिसि छ्याँ-छ्याँबै सैमैं पिंसि खीजी क्हिलाइ सैं तोंन् लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","आगुइ क्र ओलै आपिंब्मैं ताँनए ल्हागिरि याहवेहजी ठिक के नेरो निसाफ लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","खीजी मोशालाइ ह्रोंसए घ्याँर प्रबर ल्हैदिइ; धै इस्राएलीमैंए उँइँर खीजी थे-थेबै केमैं लसि उँइँइ। ");
INSERT INTO gvr_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","याहवेह ल्हयो खब नेरो दयाम्हाँया मुँबै परमेश्‍वर ग, युनन् ह्रिस आखब, ताँनए फिर खोंयोंइ आनुबै म्हाँया लब नेरो भर लल् खाँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","खीजी खोंयोंइ छ्याब् आल्हैदिरि, धै खीए खोंर खोंयोंन् बिलै ह्रिस आथेंरि। ");
INSERT INTO gvr_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","ङ्योइ कति थेबै पाप ललेया ङ्योइ लबै पापए दण्ड खीजी ङ्योलाइ आपिं, धै ङ्योइ आछ्याँबै के ललेया ङ्योइ लबै छेरन् ङ्हाँबै केमैंए दण्ड खीजी आपिं। ");
INSERT INTO gvr_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","तलेबिस्याँ पृथ्‍बीउँइँले मु कति नुब मुँ, खीलाइ मान लब्मैंए फिर खीए खोंयोंइ आनुबै म्हाँया या च्हगन् थेब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","स्यारउँइँले (पूर्व) न्हुँर (पश्‍चिम) कति ह्रेंगो मुँ, ङ्योइ लबै छेरन् ङ्हाँबै केमैं खीजी च्हगन् ह्रेंगो स्योवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","खैले आबाइ ह्रोंसए च्ह च्हमिमैंए फिर ल्हयो खमुँ, छलेन खीलाइ मान लब्मैंए फिर याहवेहजी ल्हयो खम्। ");
INSERT INTO gvr_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","तलेबिस्याँ ङ्यो खैले बनेइ बिब खीजी सेइमुँ, ङ्यो स त्हुल मत्‍त्रे ग बिबै या खीजी सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","म्हिए छ्ह छि धों तब् ग, क्ह्‍योंर्बै ट धोंले च प्हारसि म्हारम्, ");
INSERT INTO gvr_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","दिलेया खैंइ लवामा च खारयाम्, धै च चुर दने मुँल बिबै या खाबज्यै आसे। ");
INSERT INTO gvr_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","दिलेया खीए मान लब्मैं खीजी खोंयोंन् बिलै म्हाँया लरिम्। धै चमैंए च्ह-क्वेंमैं, ");
INSERT INTO gvr_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","खीने फैबै बाछा पूरा लब्मैं, नेरो खीजी बिबै के लब्मैं ताँनए ल्हागिर खी क्वेंल् खाँब् तरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","याहवेहए राजगद्दि स्वर्गर मुँ, ताँनए फिर खीजी ग्याल्स लम्। ");
INSERT INTO gvr_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","ओ खीजी बिबै ताँमै ङिंबै शक्‍ति मुँबै स्वर्गदूतमैं, याहवेहए मिं क्वेद्। ");
INSERT INTO gvr_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","ओ स्वर्गर्बै ताँन् सेनामैं, खीए सैंर मैंब् धोंबै के लबै स्वर्गदूतमैं, याहवेहए मिं क्वेद्। ");
INSERT INTO gvr_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","ओ खीजी बनेबै तोंन्दोरि सैमैं, खीजी ग्याल्स लबै ताँन् क्ल्ह्‍योर, याहवेहए मिं क्वेद्! ओ ङए सो, याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","ओ ङए सो, याहवेहए मिं क्वेद्! ओ ङए याहवेह परमेश्‍वर, क्हि बेल्‍ले थेब मुँ! क्वें खिब् धोंले क्हिजी मान नेरो इजेत पैरेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","क्हिजी क्वें खिब् धोंले चारबै ह्‍वे पैरेइमुँ, क्हिजी तम्बु धोंले मु टौंदिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","खीजी ह्रोंसए नुबै कोठार्बै दलिनमैं क्युमैंए फिर थेंम्; खीजी न्हाँमस्योमैं ह्रोंसए रथ बनेम्; खी खैंए प्ह्‍यामैंर प्ररिम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","खीजी खैंलाइ ह्रोंसए दूत, धै मिए राब ह्रोंसए के लब्मैं बनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","पृथ्बी खोंयोंन् बिलै भोंब तरिगे बिसि खीजी चलाइ जगए फिर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","क्हिजी चलाइ क्वेंइ धोंले गैरु क्युइ हुमिंइ; धै कोंमैए फिफि क्यु फेनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","दिलेया क्हिजी हौदिमा क्यु न्हेयाइ, क्हिए कै थेबै तोदोंन् च क्यु स्योयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","धै कोंमैंए फिफिउँइँले ब्याँसि तदै च क्यु क्हिजी तयार लथेंबै क्‍ल्‍ह्‍योर तेयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","क्युइ धबै पृथ्‍बी आप्ल्हुँरिगे बिसि क्युइ ङ्वेल् आखाँबै साँद क्हिजी थेंमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","खीजी खोल्सजरे क्युए धरु कुलमुँ; कोंमैंए म्हाँजोउँइँले च क्यु बग्दिम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","चेर्बै ताँन् सो प्ह्‍याबै सैमैंलाइ चमैंइ क्यु पिंम्; क्ह्‍योंर्बै गधामैंज्यै चर्बै क्युन् थुँम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","चमैंए रेजरे मुर्बै नमेमैंइ च्हों थाम्; हाँगमैंए म्हाँजोर चमैंइ क्वे प्रिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","ह्रोंसए नुबै कोठामैंउँइँले खीजी कोंजरे नाँ कुल्मिंम्; खीजी नाँ कुल्मिंबइले पृथ्बीर रा-रोमैंइ प्लिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","खेदोमैंए ल्हागिर छि नेरो म्हिमैंए ल्हागिर ट्हा ट्हुमैं खीजी म्‍लोमिंम्। धै सउँइँले म्हिमैंइ चबै सैमैं रोब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","अँगुरए प्हाइ म्हिमैंए सैं तोंन् लब्मुँ, छ्युगुइ म्हिमैंए लि वाँ-वाँ ब्योंल् लब्मुँ धै म्हिमैंए खों भोंब् लबर खीजी क्हें पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","लेबनान कोंर्बै देबदारुमैंलाइ याहवेहजी ल्हें क्यु पिंइमुँ, चमैं खीजी रुँइँबै सिंधुँमैं ग। ");
INSERT INTO gvr_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","चर नमेमैंइ च्हों थामुँ; चर बकुलइ धिं बनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","नुब्-नुबै कोंमैं क्ह्‍योंर्बै रमैं टिबै ल्हागिर ग; पारामैं क्ह्‍योंर्बै भइँकोदलेमैंए ल्हागिर ग्वार योंबै क्‍ल्‍ह्‍यो ग। ");
INSERT INTO gvr_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","लयाँइ औंसि-पूर्णि फेलम्; त्हिंयाँइ ह्रोंस लिबै त्हे था सेम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","क्हिजी मिछु खैल् लम्, धै म्हुँइँस तम्, झाइले क्ह्‍योंर्बै ताँन् सो प्ह्‍याबै सैमैं त्होंखम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","चेंमैंइ ह्रोंसए चबै सै म्हैबर ङ्हेम्, चइ परमेश्‍वरउँइँले ह्रोंसए चबै सैमैं म्हैम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","त्हिंयाँ खमा सिंहमैं ह्रोंसए रोर ह्‍यासि रोम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","झाइले म्हिमैं ह्रोंसए के लबर त्होंम् धै ङेस समा के लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","ओ याहवेह, क्हिजी लबै केमैं कति ल्हें मुँ! चु ताँन् सैं क्हिजी ह्रोंसए बुद्धिइ बनेइ; क्हिजी बनेबै तोन्दोंरि सैइ पृथ्बी प्लिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","चर बेल्‍ले थेबै मा ङ्युँइ मुँ, चर च्योलै आखाँबै थेब च्योंब सो प्ह्‍याबै सैमैं मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","चर क्यु झाजमैं प्रम्, धै चर लिव्यातन या मुँ, क्हिजी चलाइ चर क्ल्योंबै ल्हागिर बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","फो ख्रेंबै त्हेर क्हिजी चमैंलाइ चबै सै पिंब्मुँ बिसि चमैं ताँनइ क्हिए घ्याँ ङ्ह्‍योरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","क्हिजी चमैंलाइ चबै सै पिंमा चमैंइ खुम्; क्हिजी ह्रोंसए यो प्ल्हमा चमैं लिंबै सैमैं चसि म्रेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","क्हिजी ह्रोंसए लि लोमा चमैं ङ्हिंम्; क्हिजी चमैंए सो किंमा चमैं सियाम् धै धबै सर्न कोंयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","क्हिजी ह्रोंसए प्ल्ह कुलमुँ, धै चमैंलाइ बनेमुँ, धै क्हिजी पृथ्बीलाइ छार लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","याहवेहए मिं खोंयोंन् बिलै थेब् तरिगे; ह्रोंसइ लबै केमैंर याहवेह सैं तोंरिगे, ");
INSERT INTO gvr_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","खीजी पृथ्बीर ङ्ह्‍योमा च त्हारम्, खीजी छुइमा कोंमैंउँइँले मिखु त्होंम्! ");
INSERT INTO gvr_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","ङए छ्ह तिगोंन् याहवेहए मिंर ङ क्वे प्रिंरिब्मुँ; ङ सोन् समा ङए परमेश्‍वरए क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","ङइ खीए बारेर मैंबै ताँमैं खीजी खोरिगे, तलेबिस्याँ ङ याहवेहर सैं तोंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","पापिमैं बिस्याँ पृथ्बीउँइँले मेटियारिगे, धै दुष्‍टमैं धबै खोंयोंइ आचैरिगे! ओ ङए सो, याहवेहलाइ धन्यबाद पिंन्! याहवेहए मिं थेब लद्! ");
INSERT INTO gvr_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","याहवेहलाइ धन्यबाद पिंन्, खीए प्हलेर ग्वार ह्रिद्; अरू ह्रेंमैंए म्हाँजोर खीजी लबै केमैं बिमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","खीए ल्हागिरि क्वे प्रिंन्, खीए मिं थेब् लद्; खीजी लबै औदिबै केमैंए बयन लद्। ");
INSERT INTO gvr_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","खीन् पबित्र मुँ बिसि खीए मिं थेब् लद्; याहवेहलाइ म्हैब्मैंए सैं तोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","याहवेहनेरो खीए शक्ति म्हैद्; खोंयोंन् बिलै खीलाइ म्हैद्। ");
INSERT INTO gvr_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","ओ खीए के लबै म्हि अब्रहामए सन्तानमैं ओ खीजी त्हाँबै याकूबए सन्तानमैं, ");
INSERT INTO gvr_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","खीजी लबै औदिबै केमैं मैंन्, खीजी लबै औदिबै केमैं नेरो खीजी लबै निसाफ मैंन्। ");
INSERT INTO gvr_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","खीन् याहवेह ङ्योए परमेश्‍वर ग; ह्‍युल् तिगोंन् खीजीन् निसाफ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","खीजी ह्रोंसइ फैबै बाछा खोंयोंन् बिलै मैंरिमुँ, खीजी बिथेंबै ताँमैं हजार-हजार पुस्तामैंए ल्हागिर ग। ");
INSERT INTO gvr_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","च बाछा खीजी अब्राहामने फैइ, खीजी फैबै बाछा पक्‍का तम् बिबै ताँर इसहाकने कसम चइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","“ङजी क्हि कनान ह्‍युल पिंब्मुँ, च क्हिए हगर्बै अँश तब्मुँ,” बिसि ");
INSERT INTO gvr_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","खीजी याकूबने च क्ह्रोंसेंन्बै निसाफ बनेइ, छले इस्राएलने खोंयोंन् बिलै तरिबै बाछा खीजी फैइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","कनान ह्‍युलरि चमैं च्योमा च्युगुदे मत्‍त्रे मुँल, सारय च्युगुदे, चमैं आगुए ह्‍युलर्बै म्हिमैं धों मुँल, ");
INSERT INTO gvr_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","चमैं घ्रि ह्‍युलउँइँले अर्को ह्‍युलर, धै घ्रि क्ल्ह्‍योउँइँले अर्को क्ल्ह्‍योर स्युर प्रमल। ");
INSERT INTO gvr_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","दिलेया खीजी चमैंए फिर खाबज्यै या तोइ न्होह्रों लल् आपिंल; चमैंए ल्हागिर खीजी म्रुँमैंलाज्यै या छ बिसि हौदिइ, ");
INSERT INTO gvr_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“ङइ त्हाँबै म्हिमैंलाइ आछुइद्; ङए अगमबक्‍तामैंलाइ तोइ न्होह्रों आलद्!” ");
INSERT INTO gvr_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","खीजी च कनान ह्‍युलर अङ्गल कुल्मिंइ, धै चमैंइ प्लुबै प्लुमैं या तोइ म्‍लोल् आपिं; ");
INSERT INTO gvr_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","खीजी योसेफ मिं मुँबै म्हि घ्रि चमैंए ओंसों कुल्मिंइ, च केब्छैं तबर चुँवाल। ");
INSERT INTO gvr_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","म्हिमैंइ चए प्हलेर कडि फैसि दुःख पिंइ, धै चए खरिर पैए सँउँलि खिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","योसेफइ बिबै अगमबाणि पूरा आतन् समा च झेलर टिइ। “चइ क्ह्रोंसेंन्बै ताँ पोंइ” बिसि याहवेहजी ह्रोंसए ताँइ प्रमाण पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","फारो म्रुँइ म्हि कुलबै लिउँइँ झेलर्बै क्रथेइ योसेफलाइ पिवाइ, छले मिश्र ह्‍युलर्बै म्रुँइ चलाइ छ्याब् आरेब ठर्दिमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","फारो म्रुँइ चलाइ खीए ताँन् सै न्होरए जिम्‍मा पिंसि खीए धिंर्बै क्ल्हे तल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","म्रुँए के लबै क्रथे मिंथेमैंलाइ योसेफइ छेनाले लोमिंरिगे धै म्रुँलाइ ताँ लोमिंब्मैंलाज्यै या ज्ञान-बुद्धि पिंरिगे बिसि छान् लइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","लिउँइँ याकूब मिश्र ह्‍युलर ह्‍याइ; झाइले इस्राएल हामए ह्‍युलर आगुए ह्‍युलर्बै म्हि धोंले टिइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","याहवेहजी ह्रोंसए इस्राएली म्हिमैं ल्हें लमिंइ; धै चमैंए शत्तुरमैं भन्दा चमैं बेल्‍ले भोंब् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","खीजी त्हाँबै म्हिमैंलाइ मिश्रीमैंइ आखोरिगे बिसि परमेश्‍वरजी चमैंए सैं एमिंइ; ह्रोंसए के लब्मैंए बिरोधर राबै सैं चमैंलाइ पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","च लिउँइँ याहवेहजी ह्रोंसए के लबै म्हि मोशा नेरो खीजी त्हाँबै हारून कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","चमैंइ मिश्रीमैंए म्हाँजोर खीजी लबै औदिबै केमैं उँइँमिंइ; छलेन हामए ह्‍युलर चमैंइ खीए शक्तिए केमैं उँउँइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","खीजी मिछु खैब कुलमा ताँन् ह्‍युल आचि-म्हाँचि तयाइ, तलेबिस्याँ खीजी पोंबै ताँमैंए बिरोध चमैंइ लल। ");
INSERT INTO gvr_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","खीजी चमैंए ह्‍युलर्बै स्योंमैं ताँन् को लवाइ, धै चर्बै ताँगमैं ताँन् सियाइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","चमैंए ह्‍युल प्हद्गोमैंइ प्लिंयाइ; चमैंए म्रुँमैं रोबै क्ल्ह्‍योजरे या प्हद्गोमैंइ प्लिंयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","खीजी पोंब् धोंलेन् चमैंए ह्‍युल तिगोंन् च्योमि नेरो मोसोइ प्लिंयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","खीजी नाँलाइ तिस्यु लमिंइ, धै चमैंए ह्‍युल तिगोंन् काम्‍लि-तिम्‍लि रामिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","खीजी चमैंए अँगुरए धुँ नेरो तोंबुए धुमैं नास लवाइ धै चमैंए ह्‍युलर्बै सिंधुमैं चुवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","खीजी बिब् धोंले तिरिमैं नेरो च्योलै आखाँबै नम्ज्योंमैं खइ, ");
INSERT INTO gvr_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","नम्ज्योंमैंइ चमैंए ह्‍युलर्बै ताँन् प्याँ-पिंमैं नेरो चमैंए म्रोंर्बै रा-रोमैं चवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","झाइले खीजी चमैंए ह्‍युलर्बै च्ह थेब नास लवाइ, चमैंए ओंसों फिबै च्हमैं सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","मारा नेरो चाँदिने खीजी इस्राएलीमैंलाइ बैरु तेमिंइ, धै चमैंए न्होंर खाबलै या न्होह्रों आत। ");
INSERT INTO gvr_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","चमैं त्होंसि ह्‍यामा मिश्र ह्‍युल सैं तोंइ, तलेबिस्याँ इस्राएलीमैंने चमैं ङ्हिंमल। ");
INSERT INTO gvr_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","छरि तरिगे बिसि खीजी न्हाँम्स्यो थेंमिंइ, धै म्हुँइँसर मि म्रोंरिगे बिसि मि पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","चमैंइ चबै सै ह्रिमा खीजी बट्टाइ नमेमैं पिंइ धै मुर्बै क्हें चमैंलाइ म्रेंन्ले पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","खीजी पारा तिवामा क्यु त्होंइ, क्यु आयोंबै क्‍ल्‍ह्‍योर स्यों धोंले क्यु बगेइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","ह्रोंसए के लबै म्हि अब्राहामने फैबै पबित्र बाछा खीजी चिइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","खीजी ह्रोंसइ त्हाँबै म्हिमैंलाइ सैं तोंन् लदै जयजय बिदै ओरदै पखइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","खीजी चमैंलाइ अरू ह्रेंमैंए ह्‍युल पिंइ, धै अरू म्हिमैंइ दुःख लसि योंबै सैमैं ताँन् चमैंइ क्ल्हे लइ। ");
INSERT INTO gvr_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","खीजी लबै निसाफमैं चमैंइ ङिंरिगे, धै खीए ठिममैं म्हाँदिरिगे बिसिन् चु ताँन् तब् ग। याहवेहए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","याहवेहए मिं थेब् लद्! याहवेहलाइ धन्यबाद पिंन्, तलेबिस्याँ खीजी ङ्योए फिर ल्हयो खम्, धै खोंयोंइ आनुबै म्हाँया लरिम्! ");
INSERT INTO gvr_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","याहवेहजी लबै थेबै केमैंए बयन खाबइ लल् खाँमुँ? “खी कति थेब मुँ!” बिसि खीए बयन खाबइ लल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","ठिक निसाफ लब्मैंइ आशिक योंब्मुँ, धै चमैंइ खोंयोंन् बिलै ठिक के लसि सैं तोंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","ओ याहवेह, क्हिजी त्हाँबै म्हिमैंइ सुख शान्ति योंब ङइ म्रोंल् योंरिगे, धै क्हिए म्हिमैं सैं तोंमा ङै या सैं तोंल् योंरिगे, झाइले क्हिए हगवाला म्हिमैंने क्ह्रिसि क्हिए मिं थेब् लल् खाँरिगे बिसि ");
INSERT INTO gvr_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","क्हिजी ह्रोंसए म्हिमैंए फिर ल्हयो खमा ङलाज्यै या मैंमिंन्, धै चमैंलाइ खामिंमा ङलाज्यै या ल्होमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","ङिए खेमैंइ धोंले ङिज्यै या पाप लइमुँ; ङिइ छेरन् ङ्हाँब नेरो दुष्‍ट केमैं लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","ङिए खेमैं मिश्र ह्‍युलर मुँमा क्हिजी लबै औदिबै केमैं चमैंइ वास्ता आल, क्हिजी लबै खोंयोंइ आनुबै म्हाँया चमैंइ आमैं, झन् काँसए घारि मुँबै मा ङ्युँइर चमैं ताँनइ क्हिए बिरोध लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","बिरोध ललेया ह्रोंसए बेल्‍ले थेबै शक्‍ति म्रोंरिगे बिसि, खीजी ह्रोंसए मिंए आब्रु जोगेबै ल्हागिर चमैं जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","खीजी काँसए घारि मुँबै मा ङ्युँइलाइ हौदिमा च ङ्हारयाइ, धै खीजी क्यु आयोंबै क्ल्ह्‍योर्बै घ्याँर धोंलेन् च गैरु क्‍ल्‍ह्‍योउँइँले ह्रोंसए म्हिमैं डोरेसि बोइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","छले खीजी चमैंलाइ शत्तुरमैंए योउँइँले जोगेसि शत्तुरमैंए योउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","चमैंए शत्तुरमैंलाइ बिस्याँ मा ङ्युँइए क्युइ हुवाइ, चमैंए न्होंरि घ्रि या आसो। ");
INSERT INTO gvr_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","झाइले खीजी बिबै ताँर बिश्‍वास लसि चमैंइ खीए मिं थेब् लदै भजन क्वेमैं प्रिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","दिलेया खीजी लबै केमैं चमैंइ युनन् म्‍लेयाइ; धै खीजी तो बिब् ङ्‍हे बिसि चमैंइ थेबर आपैं। ");
INSERT INTO gvr_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","तोइ आकेबै क्‍ल्‍ह्‍योर चमैंइ मिश्रर्बै लिंब-लिंबै चबै सै मैंसि बेल्‍ले चदा ङ्हाँइ, धै चमैंइ क्यु आयोंबै क्ल्ह्‍योर परमेश्‍वरए जाँच लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","छतसि चमैंइ ह्रिबै सैमैं खीजी पिंइ, दिलेया चमैंए फिर खीजी ह्रिं कुल्मिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","तम्बुर चमैंइ मोशा नेरो याहवेहए पबित्र म्हि हारूनए फिर ह्रिस लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","छतमा पृथ्बी क्ल्येयासि दातानलाइ क्ल्ह्‍योंवाइ, झाइले अबिरामए म्हिमैंलाइ म्यालवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","चमैंने क्ह्रिब्मैंए म्हाँजोर मि लुँइ; मिए राबाइ दुष्‍टमैं मेब्रो लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","चमैंइ होरेब बिबै क्ल्ह्‍योर क्ल्या भाराए कु बनेसि चए पूजा लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","छले चमैंइ बेल्‍ले थेबै परमेश्‍वर पिसि छि चबै क्ल्याए कुलाइ मान लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","मिश्र ह्‍युलर थेबै केमैं लसि खेंमैं जोगेमिंबै परमेश्‍वर चमैंइ म्‍लेयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","चमैंए ल्हागिर्न खीजी हामए ह्‍युलर औदिबै केमैं नेरो ओल्ग्‍या मा ङ्युँइर ङ्हिंन् ङ्हाँबै केमैं लल। ");
INSERT INTO gvr_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","छतसि खीजी चमैं नास लवाम् बिल, दिलेया खीए नास लबै ह्रिस म्हल् लबै ल्हागिर खीजी त्हाँबै मोशा खीए ओंसों राइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","चमैंइ खीजी बिबै बाछा आक्वें, छतसि चमैंइ कनान ह्‍युलर होंल् आङिंसि च छ्याँबै ह्‍युललाइ तो धोंइ आङ्हाँ। ");
INSERT INTO gvr_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","चमैंइ ह्रोंसए तम्बुर गनगन लइ, धै याहवेहजी बिबै ताँ आथे। ");
INSERT INTO gvr_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","छतमा चमैंलाइ क्यु आयोंबै क्‍ल्‍ह्‍योर नास लवाम् बिसि खीजी यो रेसि कसम चइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","झाइले चमैंए सन्तानमैं अरू ह्रेंमैंए म्हाँजोर नेरो ह्‍यु-ह्‍युलर प्हुँवाब्मुँ बिइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","चमैंइ पोर बिबै क्‍ल्‍ह्‍योर बाल बिबै देवताए पूजा लइ, धै सो आप्ह्‍याबै देवतामैंलाइ चडेबै सैमैं चइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","चमैंइ आछ्याँबै केमैं लसि याहवेह ह्रिस खल् लइ, छतमा चमैंए म्हाँजोर ङ्हिंन् ङ्हाँबै ह्रिं खइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","दिलेया पिनहास बिबै म्हि रेसि छेरन् ङ्हाँबै के लबै म्हिलाइ सजैं पिंइ, धै याहवेहजी च ङ्हिंन् ङ्हाँबै ह्रिं म्हल् लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","चु केइ लमा चए पुस्ता-पुस्ता समा खोंयोंन् बिलै चलाइ ठिक के लबै म्हि बिम्। ");
INSERT INTO gvr_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","मेरिबाए क्युरै या चमैंइ याहवेह ह्रिस खल् लइ, चमैंइ लमा मोशाइ दु:ख योंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","चमैंइ खीए सैं नल् लइ, छतसि मोशाइ तब आतब ताँ पोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","याहवेहजी आछ्याँबै के लबै ह्रेंमैं नास लवाद् बिसि चमैंने बिलेया चमैंइ चमैं नास आल। ");
INSERT INTO gvr_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","झन् चमैं आगु ह्रेंमैंनेन् प्रब टिब लसि चमैंइ लब् धोंबै केमैंन् लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","परमेश्‍वरए म्हिमैंइ चमैंए कुमैं फ्योइ, च कुमैं चमैंए ल्हागिर ङो चुब् धोंन् तइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","चमैंइ ह्रोंसए च्ह-च्हमिमैं स्यागि म्होंगिलाइ ख्रो पिंइ; ");
INSERT INTO gvr_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","तोइ छ्याब् आरेबै ह्रोंसए च्ह-च्हमिमैं चमैंइ कनानर्बै कुमैंए ल्हागिर ख्रो पिंइ, धै चमैंए कोइ च ह्‍युल अपबित्र तइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","छले चमैं ह्रोंसए केइन पापर च्होयाइ, धै ह्रोंसइ लबै आछ्याँबै केइ लमा चमैं ब्यभिचार लब् धोंन् तइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","छतसि ह्रोंसए म्हिमैंए फिर याहवेह बेल्‍ले ह्रिस खइ, धै ह्रोंसजी त्हाँबै म्हिमैं म्रोंसि खी छेरइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","झाइले खीजी चमैं अरू ह्रेंमैंए योर पिंवाइ, धै चमैंए शत्तुरमैंइ चमैंए फिर ग्याल्स लइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","चमैंए शत्तुरमैंइ चमैंलाइ क्र ओलै आपिं, धै चमैंलाइ ह्रोंसए शक्‍तिए न्होंर थेंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","ल्हें खे खीजी चमैंलाइ दुःखउँइँले फ्रेमिंइ, दिलेया चमैंइ ह्रोंसए सैंर तो मैंमुँ चन् लइ, धै ह्रोंसए छेरन् ङ्हाँबै केइ लमा चमैं पापर्न प्ल्हुँयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","दिलेया चमैंइ ओरदै ग्वार ह्रिब थेसि खीजी चमैंए दुःख ङ्‍ह्‍योइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","खीजी चमैंए ल्हागिर ह्रोंसइ फैबै बाछा मैंइ, धै चमैंए फिर खोंयोंइ आनुबै म्हाँया लबइले खीए सैं एइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","चमैंलाइ फैसि बोयाब्मैंलाज्यै या खीजी चमैंए फिर ल्हयो खल् लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","ओ ङिए याहवेह परमेश्‍वर, ङि जोगेमिंन्! क्हिए पबित्र मिंलाइ धन्यबाद पिंबर नेरो क्हिए मिं क्वेदै सैं तोंबर अरू ह्रेंमैंए म्हाँजोउँइँले ङि खागु लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","इस्राएलए याहवेह परमेश्‍वर खोंयोंन् बिलै थेब् तरिगे! धै ताँन् म्हिमैंइ “आमेन” बिरिगे। याहवेहए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","याहवेहलाइ धन्यबाद पिंन्, तलेबिस्याँ खी स्वाब मुँ, खीए म्हाँया खोंयोंन् बिलै तरिम्! ");
INSERT INTO gvr_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","याहवेहजी खामिंब्मैंइ छान् बिरिगे! खीजी शत्तुरमैंए योउँइँले सै फोसि चमैंलाइ फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","खीजी चमैंलाइ ह्‍युल-ह्‍युलउँइँले, स्यार, न्हुँर नेरो ताइ माइले खागु लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","को-कोइ क्यु आयोंबै क्‍ल्‍ह्‍योजरे अलमल् तसि प्रमल, टिबै ल्हागिर चमैंइ खनिरै सहरर्बै घ्याँ आस्या। ");
INSERT INTO gvr_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","फो ख्रेंसि क्यु पिसि, चमैंए सो ह्‍याम् उ बिदिन् तल। ");
INSERT INTO gvr_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","छतमा चमैंइ ह्रोंसए दुःखर याहवेहने क्रोदै ग्वार ह्रिइ, धै खीजी चमैंए दु:खउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","चमैं छ्याँबै क्ल्ह्‍योर फेनेसि टिल् खाँरिगे बिसि खीजी चमैंलाइ ठिक घ्याँर डोरेइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","याहवेहजी लबै खोंयोंइ आनुबै म्हाँयाए ल्हागिर नेरो म्हिमैंए फिर खीजी लबै औदिबै केमैंए ल्हागिर चमैंइ धन्यबाद पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","तलेबिस्याँ खीजी क्यु पिब्मैंलाइ क्यु पिब सल् लमिंम्, धै फो ख्रेंब्मैंलाइ लिंब् लिंबै सैमैंइ म्रेंल् पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","को-कोइलाइ दु:ख नेरो सँउँलिइ फैथेंमल, चमैं मिछु खैबै कालए छरि न्होंर टिमल, ");
INSERT INTO gvr_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","तलेबिस्याँ चमैंइ परमेश्‍वरजी पोंबै ताँमैं थोल, धै ताँन् भन्दा थेबै परमेश्‍वरजी पिंबै सल्‍ला तो धोंइ आङ्हाँल। ");
INSERT INTO gvr_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","छतसि खीजी चमैंलाइ बेल्‍ले दुःखले के लल् पिंइ; चमैं क्हुरियामा चमैंलाइ ल्होब खाबै आत। ");
INSERT INTO gvr_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","छतमा चमैंइ ह्रोंसए दुःखर याहवेहने क्रोदै ग्वार ह्रिइ, धै खीजी चमैंए दु:खउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","खीजी मिछु खैबै कालए छरि न्होंउँइँले चमैंलाइ बैरु पखइ, धै खीजी चमैंए फैछोमैं कुदु-कुदु लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","याहवेहजी लबै खोंयोंइ आनुबै म्हाँयाए ल्हागिर नेरो म्हिमैंए फिर खीजी लबै औदिबै केमैंए ल्हागिर खीलाइ धन्यबाद पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","तलेबिस्याँ खीजी काँसाए मुल म्रामैं फुवाम्, धै नुल्‍ले थोइ थेंबै पैए बारमैं टोंवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","को-कोइ ह्रोंसइ लबै आछ्याँबै केमैंइ लमा मुर्ख तइ, धै ह्रोंसए अपराधइ लमा बेल्‍ले दुःख योंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","चमैंलाइ चबै सैमैं तिफुँइ चदा आङ्हाँ। छतसि चमैं सिबिन् छेल। ");
INSERT INTO gvr_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","छतमा चमैंइ ह्रोंसए दुःखर याहवेहने क्रोदै ग्वार ह्रिइ, धै खीजी चमैंए दु:खउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","खीजी सयाद् बिमा चमैं सयाइ; धै चमैंलाइ कालउँइँले जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","याहवेहजी लबै खोंयोंइ आनुबै म्हाँयाए ल्हागिर नेरो म्हिमैंए फिर खीजी लबै औदिबै केमैंए ल्हागिर खीलाइ धन्यबाद पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","चमैंइ धन्यबादए ख्रो पिंरिगे, धै सैं तोंबै क्वेमैं प्रिंदै खीजी लबै केमैंए बयन लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","को-कोइ झाजर क्रेसि स्युरइ; चमैं मा ङ्युँइए फिर छों लब्मैं मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","याहवेहजी लबै केमैं चमैंइ म्रोंइ, मा ङ्युँइए गैरु क्ल्ह्‍योर खीजी लबै औदिबै केमैं चमैंइ म्रोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","तलेबिस्याँ खीजी बिमा थेबै नाँ-खैं तइ, नाँ खैंइ लमा मा ङ्युँइर्बै भेलमैं रेइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","च भेलमैं मु समन् क्रेसि ह्‍याइ, धै धबै मा ङ्युँइए तेंर्न तेयुइ; छाबै दु:खइ लमा चमैं भों आखन् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","प्हा ल्हें थुँसि म्हेरबै म्हिमैं धोंब चमैं लयाल; धै चमैं तोइ मैंल् आखाँब् तयाल। ");
INSERT INTO gvr_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","छतमा चमैंइ ह्रोंसए दुःखर याहवेहने क्रोदै ग्वार ह्रिइ, धै खीजी चमैंए दु:खउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","खीजी थेबै नाँ-खैं च्याँ लमिंइ; धै मा ङ्युँइर्बै भेलमैं या टियाइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","नाँ-खैं च्याँ तबै लिउँइँ चमैं सैं तोंइ, धै चमैं ह्‍यादा ङ्हाँबै क्ल्ह्‍योर खीजी सथेंनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","याहवेहजी लबै खोंयोंइ आनुबै म्हाँयाए ल्हागिर नेरो म्हिमैंए फिर खीजी लबै औदिबै केमैंए ल्हागिर खीलाइ धन्यबाद पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","ल्हें म्हि च्होंबै क्ल्ह्‍योर चमैंइ खीए बयन लरिगे, धै चिबनाँबमैं च्होंबै क्‍ल्‍ह्‍योर चमैंइ खीए मिं थेब् लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","खीजी स्योंमैं क्यु आयोंबै क्‍ल्‍ह्‍यो धोंन् लवामुँ, क्युए मुलमैं कारबै क्‍ल्‍ह्‍यो धोंन् लवामुँ, ");
INSERT INTO gvr_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","धै मलिलो सलाइ चज ङ्हाँबै ह्रुखो लमिंइ। चर टिबै म्हिमैंइ आछ्याँबै केमैं लबइले छ तब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","खीजी क्यु आयोंबै क्‍ल्‍ह्‍योमैं ङ्ह्‍योखोमैं लमिंइ, धै कारयाबै क्‍ल्‍ह्‍योमैंर स्योंमैं युमिंइ; ");
INSERT INTO gvr_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","फो ख्रेंरिब्मैंलाइ खीजी चर टिबर पखइ, धै चमैंइ खेंमैं टिबै ल्हागिर सहर घ्रि बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","चमैंइ म्रोंर प्लु प्लुसि अँगुरए धुँमैं या रुँइ, धै छ्याँबै रोमैं रोइ धै योंइ; ");
INSERT INTO gvr_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","चमैंए फिर खीजी आशिक पिंसि चमैंए सन्तान ल्हें तइ, झाइले चमैंए खेदोंमैं या खीजी च्युगुदे तल् आपिं। ");
INSERT INTO gvr_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","चमैंए फिर दु:ख कष्‍ट नेरो शोक तमा चमैं च्युगुदे तयाइ धै चमैं म्हि आच्हिन् तयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","खीजी क्रथे मिंथेमैंलाइ खाबज्यै आक्वेंब लवामुँ, धै सिंधुँमैं तोइ आरेबै क्‍ल्‍ह्‍योजरे चमैंलाइ क्याइ खैने माइ खै लवामुँ। ");
INSERT INTO gvr_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","दिलेया खीजी ङ्हाँदुमैंलाइ चमैंए दुःखउँइले फ्रेसि कैंडो लमिंम्; धै चमैंए परवामैं क्युए बगल धोंले ल्हें लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","ठिक के लब्मैंइ चु म्रोंब्मुँ धै तोंब्मुँ, दिलेया दुष्‍ट म्हिमैंइ ह्रोंसए सुँ म्रुब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","बुद्धि मुँबै म्हिमैंइ चु ताँमैं छेनाले क्होल् म्हैरिगे, धै याहवेहजी लबै खोंयोंइ आनुबै म्हाँया चमैंइ क्होब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","दाऊदइ प्ह्रिबै भजन घ्रि, क्वे घ्रि। ओ परमेश्‍वर, ङए सैंइ क्हिए फिर्न भर थेंइमुँ; छतसि सैं न्होंउँइँले ङ बाजा ह्रादै क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","ओ बीणा नेरो सारङ्गी छोरद्! ङ न्हाँगलाइ छोरब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","ओ याहवेह, ह्रें-ह्रेंमैंए म्हाँजोर ङ क्हिए मिं क्वेब्मुँ; ह्रें-ह्रेंमैंए म्हाँजोर ङ क्हिए मिंर क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","तलेबिस्याँ क्हिए खोंयोंइ आनुबै म्हाँया मु भन्दा थेब मुँ; धै क्हिए भर लल् खाँबै ताँ न्हाँम्स्यो समन् फेनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","ओ परमेश्‍वर, क्हि मु भन्दा क्होवाइ मुँ बिसि ताँन् म्हिमैंने उँइँमिंन्; धै क्हिए छ्याँबै बयन ह्‍युल तिगोंन् तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","क्हिजी म्हाँया लब्मैं दु:खउँइँले फ्रेमिंबर क्हिए क्योलो योजी ङि जोगेमिंन्, ङए प्राथना ज्वाफ पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","“शकेमलाइ ट्होसि ङइ चुमिंब्मुँ, धै सुक्‍कोतर्बै ब्याँसि च्हैंसि स्यो-स्यो लब्मुँ,” बिसि परमेश्‍वरजी ह्रोंसए पबित्र क्‍ल्‍ह्‍योउँइले बाछा लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","“गिलाद ङल् ग, मनश्शे या ङलन् ग; एफ्राइम ङए मुकुट ग, यहूदा ङए ल्हागिर म्रुँइ छेबै प्हरे धों तब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","मोआब ङए ल्हागिर यो प्हले ख्रुबै क्‍ल्‍ह्‍यो ग, एदोमए फिर ङइ ह्रोंसए जुत्ता भ्योंमुँ; पलिश्तए फिर ङ ट्होगों तसि ओरम्।” ");
INSERT INTO gvr_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","खाबइ ङलाइ किल्‍ला मुँबै सहरर बोमिंब् ङ्‍हे? एदोम समा खाबइ ङ डोरेमिंब् ङ्‍हे? ");
INSERT INTO gvr_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","ओ परमेश्‍वर, क्हिजीन् ङिलाइ पिवाइ, आङिं वा? तारे ङिए सिपाइमैंने बालु आह्‍या वा? ");
INSERT INTO gvr_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","शत्तुरमैंने नेल् त्हुमा ङि ल्होमिंन्, तलेबिस्याँ म्हिमैंइ ल्होल् आखाँ! ");
INSERT INTO gvr_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","परमेश्‍वरउँइँले मत्‍त्रे ङ्योइ ट्होल् खाँब्मुँ, तलेबिस्याँ ङ्योए शत्तुरमैं प्लेवाब खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। ओ परमेश्‍वर, ङ क्हिए मिं क्वेब्मुँ, आपोंन्ले आटिमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","तलेबिस्याँ आछ्याँबै के लब्मैं नेरो स्योलिबै ताँ पोंब्मैं ङए बिरोधर पोंइमुँ, धै चमैंइ स्योर तेबै लेइ ङए बिरोधर पोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","चमैंइ ङने छेरन् ङ्हाँबै ताँमैं पोंइमुँ, धै तोन् तोर्न चमैं ङए फिर ह्‍वाखम्। ");
INSERT INTO gvr_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","ङइ चमैंए फिर म्हाँया ललेया चमैंइ ङलाइ छ्याब् ल्हैदिम्, दिलेया ङ बिस्याँ चमैंए ल्हागिर प्राथना लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","चमैंलाइ छ्याँन् ललेया चमैंइ ङए न्होह्रों लम्, धै ङइ म्हाँया ललेया चमैंइ ङलाइ हेल लम्। ");
INSERT INTO gvr_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","छतसि ङए शत्‍तुरए बिरोध लबै ल्हागिर दुष्‍ट म्हि घ्रि त्हाँन्; धै चए फिर छ्याब् ल्हैदिबै म्हि चए क्योलोउँइँ राल् पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","चए निसाफ तमा च छ्याब् मुँब ठर्दिरिगे; धै चइ प्राथान लमा चलाइन दण्ड योंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","चए छ्ह रिंठि तरिगे; धै चए पद आगुइ प्हेंवारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","चए प्हसेमैं आबा आरेब्मैं तरिगे धै चए प्ह्रेंस्यो म्हरेस्यो तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","चए प्हसेमैं आगुने ह्रिसि चल् त्हुरिगे, चमैं टिबै फुयाबै धिंउँइँले त्होंसि चबै सैमैं म्हैल् त्हुरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","चने मुँबै ताँन् सै न्होर साउइ किंवारिगे; धै चइ दुःख लसि रोबै रोमैं स्याँमैंइ लुडिरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","चए फिर म्हाँया लब्मैं खाबै आतरिगे, धै चए आबा आरेबै प्हसेमैंए फिर ल्हयो खब्मैं या खाबै आतरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","चए सन्तानमैं ताँन् नास तयारिगे; धै लिउँइँ खबै पुस्तार चए मिं क्ह्रन् म्हयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","चए खेबाज्युइ लबै आछ्याँबै केमैं याहवेहजी मैंरिगे, धै चए आमाइ लबै पाप खोंयोंइ आमेटिरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","चमैंइ लबै पाप खोंयोंइन याहवेहए उँइँर तरिगे, धै खीजी चमैंए मिं पृथ्बीउँइँले मेटिवारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","तलेबिस्याँ आगुए फिर म्हाँया लम् बिसि चइ खोंयोंइ आमैं, दिलेया दु:ख योंब्मैं नेरो आयों-आख्युब्मैंलाइ चइ ह्रुगिदिइ, धै सैं चोयाब्मैंलाइ सैयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","चइ खैले आगुए फिर सराप झोंइ, छलेन चए फिर सराप ल्हैदिरिगे; चइ आगुए फिर आशिक पिंब आखोमल, छतसि चइ आशिक आयोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","क्वें खिब् धोंले चइ सराप लब खिइमुँ; चए फोर क्यु धोंले सरापइ प्लिंइ, धै छ्युगु धोंले चए ह्रिबर सराप होंइ! ");
INSERT INTO gvr_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","चए ल्हागिर सराप क्वें धोंन् तरिगे, धै चए क्रेर सराप खोंयोंइ खिरिबै फगि धोंन् तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","ङए फिर छ्याब् ल्हैदिब्मैं नेरो ङए बिरोधर आछ्याँबै ताँ पोंब्मैंलाइ याहवेहजी छाबन् इनाम पिंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","दिलेया ओ याहवेह, ङए थेबै प्रभु, ङइ क्हिए मिं थेब लरिगे बिसि ङए फिर ल्हयो खमिंन्; क्हिए खोंयोंइ आनुबै म्हाँया बेल्‍ले थेब मुँ, छतसि ङलाइ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","तलेबिस्याँ ङ आयोंब आख्युब मुँ, धै ङए सैं बेल्‍ले नइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","ङेसर्बै छरि धोंले ङ म्हयामुँ; तिनि क्वेंउँइँले भ्योंवाब् धोंले ङलाइ खारासि भ्योंवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","बर्त टिब्रें लमा ङए च्हिमैं आभोंब् तइमुँ; ङए ज्यु च्हवेसि कारयाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","ङलाइ छ्याब् ल्हैदिब्मैंए उँइँर ङ आखोबै म्हि तइमुँ; ङलाइ म्रोंमा चमैंइ क्र लाम्। ");
INSERT INTO gvr_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","ओ ङए याहवेह परमेश्‍वर, ङलाइ ल्होमिंन्! क्हिए खोंयोंइ आनुबै म्हाँयाजी ङ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","क्हिए योइन छ लइ बिसि चमैंइ सेरिगे; ओ याहवेह, चु क्हिजीन् लब् ग बिसि चमैंइ क्होरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","चमैंइ ङलाइ सराप पिंलेया क्हिजी आशिक पिंब्मुँ! चमैंइ ङए फिर यो झोंखमा चमैं फापिल् तब्मुँ, दिलेया क्हिए के लबै म्हि ङ सैं तोंल् योंब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","ङए फिर छ्याब् ल्हैदिब्मैं फापिल् त्हुबै क्वें खिरिगे; धै फापिबै पछ्यौरइ चमैं हुवारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","ङ ह्रोंसए सुँइ याहवेहलाइ बेल्‍ले थेब लब्मुँ; ल्हें म्हिए म्हाँजोर ङ खीए क्वे प्रिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","तलेबिस्याँ दण्ड पिंबै म्हिउँइँले दु:ख योंबै म्हिलाइ जोगेमिंबै ल्हागिर चए क्योलोउँइँ खी रारिम्। ");
INSERT INTO gvr_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","दाऊदए भजन घ्रि। “ङइ क्हिए शत्तुरमैं क्हिए प्हले न्होंर आप्लेन् समा क्हि ङए क्योलोउँइँ टिद्,” बिसि याहवेहजी ङए प्रभुने बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","“क्हिजी भोंन्ले ग्याल्स लब सियोनउँइँले ल्हें क्ल्ह्‍योर फेनेरिगे,” बिसि याहवेहजी क्हिलाइ हग पिंब्मुँ। “क्हिए शत्तुरमैंए फिर क्ल्हे लद्! ");
INSERT INTO gvr_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","क्हिजी नेल् त्हुबै त्हिंइर क्हिए म्हिमैं खेंमैंए सैंइ मैंसि नेबै ल्हागिर न्हागर्न खब्मुँ। न्हाँगर्बै शीत धोंले क्हिए फ्रेंसिमैं सियोनए पबित्र कोंमैंर क्हि ङाँर खब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","“मल्किसेदेकए पदरि क्हि खोंयोंन् बिलै खेगि तब्मुँ,” बिसि याहवेहजी कसम चइमुँ। खीए सैं फेर्दिरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","ओ याहवेह, ङए प्रभु अधिकार किंसि क्हिए क्योलोउँइँ टिम्; ह्रिस खबै त्हेर खीजी म्रुँमैं त्हुलफुँ लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","खीजी ह्रें-ह्रेंमैंए निसाफ लमा ल्हें सिनुमैं खागु लब्मुँ; धै पृथ्बी तिगोंर्बै म्रुँमैं त्हुलफुँ लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","खी म्रुँ तसि ग्याल्स लबै अधिकार योंब्मुँ; छले खी भोंब तसि शत्तुरमैंए फिर ट्होगों तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","याहवेहए मिं थेब लद्! ठिक के लब्मैंए म्हाँजोर नेरो म्हि ल्हें च्होंबै क्ल्ह्‍योर ङए सैं न्होंउँइँले याहवेहलाइ धन्यबाद पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","याहवेहजी लबै केमैं बेल्‍ले थेब मुँ, खीए केमैं म्रोंसि सैं तोंब्मैं ताँनइ च केमैं क्होल् म्हैम्। ");
INSERT INTO gvr_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","खीजी लबै केमैंइ खीए मान नेरो इजेत थेब लमुँ, धै खीजी लबै ठिक केमैं खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","खीजी ह्रोंसए औदिबै केमैं मैंरिल् पिंइमुँ; याहवेहजी ङ्योए फिर ल्हयो खसि दयाम्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","खीने बालु ङ्हिंब्मैंलाइ खीजी चबै सैमैं जुटेमिंब्मुँ; धै खीजी फैबै बाछा खोंयोंइ मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","अरू ह्रेंमैंए क्ल्ह्‍यो-ने ह्रोंसए म्हिमैंलाइ पिंसि खीजी ह्रोंसइ लबै औदिबै केमैं खीए म्हिमैंलाइ उँइँमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","खीए योजी लबै केमैं भर लल् खाँब नेरो ठिक मुँ; खीजी के ल्हैदिबै ताँमैं भर लल् खाँब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","खीजी बिबै ताँमैं खोंयोंन् बिलै तरिम्, चु ताँ पिंमा याहवेह भर लल् खाँब नेरो क्ह्रोंसेंन्बै मुँल। ");
INSERT INTO gvr_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","खीजी ह्रोंसए म्हिमैंलाइ जोगेमिंइ; ह्रोंसइ फैबै बाछा खोंयोंन् बिलै तरिगे बिसि खीजी बिइ। खीए मिं पबित्र नेरो मान लल् त्हुब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","याहवेहलाइ मान लब बुद्धि योंबै घ्याँ ग; खीजी बिबै ताँ ङिंब्मैंइ छेनाले च्हैंब् मैंब् लल् खाँम्। खीए मिं खोंयोंन् बिलै थेब् तरिम्! ");
INSERT INTO gvr_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","याहवेहए मिं थेब लद्! याहवेहलाइ मान लब धै खीए ताँमैं सैं तोंदै म्हाँदिबै म्हिइ आशिक योंम्! ");
INSERT INTO gvr_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","चए सन्तान ह्‍युलर बेल्‍ले भोंब तब्मुँ; ठिक के लबै म्हिए सन्तानइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","चए धिंर सैन्होर तब्मुँ, धै चइ लबै ठिक केमैं खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","सोजो म्हिमैंए ल्हागिर म्हुँइँसरै या ह्‍वे चारम्, चमैंइ दयाम्हाँया लम्, ल्हयो खम्, ठिक के लम्। ");
INSERT INTO gvr_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","सैं प्ल्हसि छे पिंब नेरो भर म्हाँदिल् खाँबै के लरिबै म्हिल बिब् धों मैंब् धों तम्। ");
INSERT INTO gvr_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","ठिक के लबै म्हि खोंयोंन् बिलै छ्याँबै घ्याँर प्रम्; छाबै म्हिलाइ खोंयोंन् बिलै मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","आछ्याँबै ताँमैं थेमा च आङ्हिं; चइ याहवेहए फिर भर लबइले चए सैं भोंब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","चए सैं भोंब मुँ, छतसि च आङ्हिं, लिउँइँ शत्तुरमैं हार्दियाब चइ म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","आयोंब्-आख्युब्मैंलाइ चइ सैं प्ल्हसि पिंइमुँ; चइ लबै ठिक केमैं खोंयोंन् बिलै तरिम्; चलाइ ताँनइ मान लब्मुँ, धै चए क्र कैंडो तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","दुष्‍ट म्हिमैंइ चु म्रोंसि ह्रिस लब्मुँ, धै स ह्रासि नास तयाब्मुँ; दुष्‍ट म्हिमैंल बिब् धों मैंब् धों आत। ");
INSERT INTO gvr_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","याहवेहए मिं थेब् लद्! ओ याहवेहए सेवा लब्मैं, खीए मिं थेब् लद्! खीए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","तोगोउँइँले खोंयोंन् बिलै याहवेहए मिं थेब् तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","त्हिंयाँ प्योबै त्हे सेरो त्हिंयाँ लिबै त्हे समन् खीए मिं थेब् तल् त्हुम्! ");
INSERT INTO gvr_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","याहवेहजी ताँन् ह्रेंमैंए फिर ग्याल्स लम्, धै खीए मान मु भन्दा नुब मुँ बिसि ताँन् म्हिमैंने उँइँमिंन्! खीए मिंर क्वे प्रिंब मु भन्दा नुब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","ङ्योए याहवेह परमेश्‍वर धों तब खाब् मुँ? खी ताँन् भन्दा नुबै क्‍ल्‍ह्‍योर म्रुँ तसि क्हुँम्, ");
INSERT INTO gvr_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","दिलेया मु नेरो पृथ्बी ङ्ह्‍योबर खी कुरम्। ");
INSERT INTO gvr_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","खीजी आयों आख्युब्मैं त्हुलउँइँले रेमिंम्, धै ङ्हाँदुमैं मेब्रोए रासउँइँले क्वेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","खीए म्हिमैंए क्रथे मिंथेमैंने प्रे ग्याल्स लबै ल्हागिर खीजी चमैं टिल् पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","थरिस्योलाइ खीजी सैं तोंल्‍ले टिबै ल्हागिरि परवा पिंम्। याहवेहए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","याहवेहजी इस्राएलीमैं मिश्र ह्‍युलउँइँले पखइ, आक्होबै क्युइ पोंबै म्हिमैंए म्हाँजोउँइँले याकूबए परवारमैं त्होंखइ। ");
INSERT INTO gvr_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","च त्हेरि यहूदा ह्‍युल याहवेहए पबित्र क्‍ल्‍ह्‍यो तयाइ, धै इस्राएल खीए ग्याल्स तइ। ");
INSERT INTO gvr_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","याहवेहजी चु के लब् म्रोंसि मा ङ्युँइ भौदियाइ; यर्दन स्यों उल्टोले प्रबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","कोंमैं ङ्हिंसि क्यु साँडेमैं धोंले धै डाँडामैं क्यु झज धोंले उफार्दिबर होंइ। ");
INSERT INTO gvr_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","ओ मा ङ्युँइ, क्हिलाइ तो तइ? तले भौदियाइ। ओ यर्दन, क्हि तले लिउँइँन एह्‍याल? ");
INSERT INTO gvr_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","ओ कोंमै, क्यु साँडेमैं धोंले क्हेमैं तले उफार्दिल, ओ डाँडामैं, क्यु झज धोंले क्हेमैं तले उफार्दिल? ");
INSERT INTO gvr_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","ओ पृथ्‍बी, याहवेहए उँइँर ङ्हिंन्, याकूबए परमेश्‍वरए उँइँर थरथरले त्हारद्; ");
INSERT INTO gvr_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","खीजी पारालाइ क्युए ङ्ह्‍योखोमैं लमिंइ, धै प्रोलाइ क्युए मुल लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","ओ याहवेह, क्हि खोंयोंइ आनुबै म्हाँया लब नेरो भर लल् खाँबै परमेश्‍वर ग! छतसि ङिलाइ आङिं, दिलेया क्हिलाइन मान तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","“चमैंए परमेश्‍वर खनिर मुँ?” बिसि अरू ह्रेंमैंइ तले बिमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","ङिए परमेश्‍वर स्वर्गर मुँ; खीजी तो लदा ङ्हाँमुँ चन् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","दिलेया चमैंए कुमैं मारा नेरो चाँदिबै मत्‍त्रे ग, म्हिमैंए योइ च कुमैं बनेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","चमैंल सुँ मुँ, दिलेया पोंल् आखाँ; मि मुँ, दिलेया म्रोंल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","चमैंल न्ह मुँ, दिलेया थेल् आखाँ; नखु मुँ, दिलेया थाँ नाँल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","चमैंल यो मुँ, दिलेया छुइल् आखाँ; प्हले मुँ, दिलेया प्रल् आखाँ; धै चमैंए म्‍लोगोउँइँले कै त्होंल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","छतसि चमैंलाइ बनेब्मैं या चमैं धोंन् तब्मुँ; चमैंए फिर भर थेंब्मैं या छाबन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","ओ इस्राएलए सन्तानमैं, याहवेहए फिर भर थेंन्! क्हेमैंलाइ ल्होब नेरो जोगेब खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","ओ हारूनए सन्तान, याहवेहए फिर भर थेंन्! क्हेमैंलाइ ल्होब नेरो जोगेब खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","ओ याहवेहलाइ मान लब्मैं, याहवेहए फिर भर थेंन्! क्हेमैंलाइ ल्होब नेरो जोगेब खीन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","याहवेहजी ङ्योलाइ मैंरिइमुँ; धै ङ्योए फिर आशिक पिंब्मुँ; इस्राएलए सन्तानलाइ खीजी आशिक पिंब्मुँ; हारूनए सन्तानलाइ खीजी आशिक पिंब्मुँ; ");
INSERT INTO gvr_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","याहवेहलाइ मान लब्मैं थेब च्योंब ताँनलाइ, खीजी आशिक पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","याहवेहजी क्हेमैंलाइ ल्हें लमिंरिगे, क्हमैं नेरो क्हेमैंए सन्तानलाइ ल्हें लमिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","स्वर्क नेरो पृथ्‍बी बनेबै याहवेहउँइँले क्हेमैंइ आशिक योंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","स्वर्ग याहवेहलन् ग, दिलेया पृथ्‍बी बिस्याँ खीजी म्हिमैंलाइ पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","सियाब्मैंइ याहवेहए मिं थेब आल, क्रोंर ह्‍याब्मैंइ खीए मिं थेब आल। ");
INSERT INTO gvr_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","दिलेया ङिम् तोगोउँइँले खोंयोंन् बिलै याहवेहलाइ मिं थेब लब्मुँ। याहवेहए मिं थेब लद्! ");
INSERT INTO gvr_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","ङ याहवेहने म्हाँया लम्, तलेबिस्याँ ङइ ग्वार ह्रिमा खीजी थेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","खीजी ह्रोंसए न्ह ङ ङाँइ तोइ, छतसि ङ सोन् समा खीनेन् ग्वार ह्रिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","कालए छोइ ङलाइ फैइ; क्रोंर्बै दुःख ङ फिर खइ; दुःख नेरो शोक ङलाइ प्लेइ। ");
INSERT INTO gvr_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","“ओ याहवेह, ङए सो जोगेमिंन्!” बिसि ङइ याहवेहए मिंर प्राथना लइ। ");
INSERT INTO gvr_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","याहवेहजी ताँनए फिर दयाम्हाँया लसि ठिक के लम्; ङ्योए परमेश्‍वरजी ल्हयो खम्। ");
INSERT INTO gvr_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","याहवेहजी आह्र आसेब्मैंलाइ रक्षा लम्; ङए भों नुयाबै त्हेरैया खीजी ङ जोगेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","ओ ङए सो, याहवेहजी क्हि छ्याँब लमिंइमुँ, छतसि धबै तिखे छिं तद्। ");
INSERT INTO gvr_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","ओ याहवेह, क्हिजी ङए सो कालाउँइँले फ्रेमिंइमुँ, ङए मिर मिग्लि युल् आपिंइमुँ, धै ङए प्हले थुरल् आपिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","छतसि ङ सोगोंमैंए ह्‍युलर मुँन् समा याहवेहए घ्याँर प्रब् टिब् लल् खाँम्। ");
INSERT INTO gvr_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","“ङए फिर ल्हें दुःख तइमुँ,” बिबै त्हेर खीए फिर ङइ पक्‍का बिश्‍वास लइ। ");
INSERT INTO gvr_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","धै “ताँन् म्हिमैं स्युर्गु ग!” बिसि ङ आदेबै त्हेर बिइ। ");
INSERT INTO gvr_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","याहवेहजी ङए फिर लबै छ्याँबै केमैंए खि ङइ खैले फोब् ङ्‍हे? ");
INSERT INTO gvr_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","याहवेहजी ङलाइ जोगेमिंइ, छतसि खीलाइ धन्यबाद पिंबर ङ अँगुरए प्हा खीए मिंर पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","याहवेहए ताँन् म्हिमैंए उँइँर खीने लबै ङए भकलमैं ङ पूरा लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","याहवेहए म्हिमैं सिमा खी बेल्‍ले न्हुँ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","ओ याहवेह, क्ह्रोंसेंन्ले ङ क्हिए केब्छैं ग; ङ क्हिए केब्छैं ग, क्हिए केब्स्योए च्ह। क्हिजी ङ सिबउँइँले जोगेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","ङ क्हिए ल्हागिर धन्यबादए ख्रो पिंब्मुँ धै याहवेहए मिंर ग्वार ह्रिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","याहवेहए ताँन् म्हिमैंए उँइँर, खीए मन्दिरर्बै ह्‍युमैंर, ");
INSERT INTO gvr_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","ओ यरूशलेम, क्हिए म्हाँजोर, याहवेहने लबै ङए भकलमैं ङ पूरा लब्मुँ। याहवेहए मिं थेब् लद्!! ");
INSERT INTO gvr_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","ओ ताँन् ह्रें-ह्रेंमैं, याहवेहए मिं थेब् लद्! ओ ताँन् म्हिमैं, खीए जय-जय लद्! ");
INSERT INTO gvr_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","तलेबिस्याँ ङ्योए फिर खीए खोंयोंइ आनुबै म्हाँया बेल्‍ले थेब मुँ, धै याहवेहए फिर खोंयोंन् बिलै भर लल् खाँम्। याहवेहए मिं थेब् लद्!! ");
INSERT INTO gvr_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","याहवेहलाइ धन्यबाद पिंन्, तलेबिस्याँ खी स्वाब मुँ, धै खीए खोंयोंइ आनुबै म्हाँया खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","“खीए खोंयोंइ आनुबै म्हाँया खोंयोंन् बिलै तरिम्” बिसि इस्राएलीमैंइ बिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","“खीए खोंयोंइ आनुबै म्हाँया खोंयोंन् बिलै तरिम्,” बिसि हारूनए प्हसेमैंइ बिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","“खीए खोंयोंइ आनुबै म्हाँया खोंयोंन् बिलै तरिम्,” बिसि याहवेहलाइ मान लब्मैंइ बिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","बेल्‍ले दु:ख तमा ङइ याहवेहने ग्वार ह्रिइ, खीजी ङने ज्वाफ पिंइ, धै ङए दुःखउँइँले फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","याहवेह ङने बालुन् मुँ, छतसि ङ तो सैने या ङ्हिंरिब् आरे, म्हिमैंइ ङलाइ तोइ लल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","याहवेह ङने बालुन् मुँ, खीजी ङ ल्होमिंमुँ। छतसि शत्तुरमैंलाइ ङइ ट्होवाब म्रोंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","म्हिमैंए फिर भर थेंब् भन्दा याहवेहए प्हलेर्न ग्वार योंब छ्याँब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","क्रथे मिंथेब्मैंए फिर भर थेंब् भन्दा याहवेहए प्हलेर्न ग्वार योंब छ्याँब तम्। ");
INSERT INTO gvr_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","ताँन् ह्रेंमैं ङए कारग्यु तखइ, दिलेया याहवेहए शक्‍तिउँइँले ङइ चमैं सैवाइ! ");
INSERT INTO gvr_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","चमैंइ ङ खन्तदोंइले कारग्यु लखइ, दिलेया याहवेहए शक्‍तिउँइँले ङइ चमैं सैवाइ! ");
INSERT INTO gvr_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","चमैंइ क्वेमैंइ धोंले ङ म्होरखइ, दिलेया पुजुए झ्याँगर लुँब् धोंले चमैं तिस्यार्न सियाइ। याहवेहए शक्‍तिउँइँले ङइ चमैं सैवाइ! ");
INSERT INTO gvr_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","शत्तुरमैंइ भोंन्ले लिग्याँइ ङलाइ कैवामा ङ क्हुरयाबि छेल, दिलेया याहवेहजी ङ ल्होमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","याहवेहजी ङलाइ शक्‍ति पिंमा ङइ खीए मिंर क्वें प्रिंम्, तलेबिस्याँ खीजी ङ जोगेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","“याहवेहए क्योलो योजी शक्‍तिए के लइमुँ,” बिसि ठिक के लब्मैंइ तम्बुर सैं तोंबै कै नेरो ट्होब कै तेम्। ");
INSERT INTO gvr_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","“याहवेहए क्योलो यो कैंडो क्वेइमुँ, याहवेहए क्योलो योजी शक्‍तिए के लइमुँ!” ");
INSERT INTO gvr_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","ङ सिरिब् आरे, सोगोंन् तरिब्मुँ, धै याहवेहजी लबै केमैं ङ बिप्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","याहवेहजी ङ थेबै दण्ड पिंइमुँ, दिलेया खीजी ङ सिल् आपिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","ठिक के लब्मैं मन्दिरर्बै तगरमैंउँइँले होंम्। च तगरमैं ङए ल्हागिर थोंमिंन्। च न्होंर होंसि ङइ याहवेहलाइ धन्यबाद पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","चु तगर याहवेहल् ग, च न्होंर ठिक के लब्मैं मत्‍त्रे होंल् योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","क्हिजी ङए प्राथनाए ज्वाफ पिंबै ल्हागिर नेरो ङलाइ जोगेमिंबै ल्हागिर ङ क्हिलाइ धन्यबाद पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","धिं लब्मैंइ केर आफे बिसि भ्योंवाबै युँमान् तेंर्बै क्र युँमा तइ। ");
INSERT INTO gvr_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","चु के याहवेहउँइँले तब् ग, ङ्योइ मैंरिमा चु आच्म्‍मबै के मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","तिंयाँबै त्हिंइ याहवेहजी बनेब् ग। छतसि चु त्हिंइर ङ्यो आनन्दले सैं तोंले। ");
INSERT INTO gvr_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","“ओ याहवेह, ङि जोगेमिंन्” बिसि ङ क्हिने यो छ्युँ लम्! ओ याहवेह, ङ क्हिने यो छ्युँ लमुँ, ङिए सैंर मैंब् धों लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","याहवेहए मिंर युबै म्रुँइ आशिक योंम्। धै ङिइ क्हेमैं ताँनलाइ याहवेहए धिंउँइँले आशिक पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","याहवेहन् परमेश्‍वर ग, खीजी ङ्योलाइ चारबै ह्‍वे पिंइमुँ। छतसि सिं धुँए हाँगमैं छेसि चाड म्हाँदिब्मैंने बालु सैं तोंदै ख्रो पिंबै क्ल्ह्‍यो समा क्रेयाद्। ");
INSERT INTO gvr_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","क्हि ङए परमेश्‍वर ग, छतसि ङ क्हिलाइन धन्यबाद पिंब्मुँ, क्हि ङए परमेश्‍वर ग, ङ क्हिलाइन थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","याहवेहलाइ धन्यबाद पिंन्, तलेबिस्याँ खी स्वाब मुँ। खीए खोंयोंइ आनुबै म्हाँया खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","छ्याब् आरेब्मैंइ आशिक योंम्; चमैं याहवेहए ठिमर बिब् धोंले प्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","खीजी बिबै ताँमैं ङिंब्मैं, नेरो सैं न्होंउँइँले खीलाइ म्हैब्मैंइ आशिक योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","चमैंइ आछ्याँबै केमैं आल, दिलेया खीए घ्याँर प्रम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","ङिइ लल् त्हुबै के ताँन् छेनाले लरिगे बिसि ङिइ लल् त्हुबै ताँमैं क्हिजी पिंथेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","क्हिए निसाफमैं ङिंबै ल्हागिर ङल आछ्याँबै घ्याँर प्रबै सैं आखस्याँ कति छ्याँब् तमल! ");
INSERT INTO gvr_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","झाइले क्हिए ताँन् ताँमैं च्हैंसि मैंसि लसि ङ फापिल त्हुरिब आरे। ");
INSERT INTO gvr_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","क्हिए ठिक ठिममैं लोसि ङए छ्याँबै सैंइ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","क्हिजी पिंबै ठिमर्बै ताँमैं ङिंस्यो; ङलाइ खैंमैंइ आपिमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","फ्रेंसि म्हिइ आछ्याँबै केमैंउँइँले ह्रोंसलाइ खैले जोगेसि थेंल् खाँम्? क्हिए ताँइ बिब् धोंले प्रसिन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","ङइ ह्रोंसए सैं न्होंउँइँलेन् क्हिलाइ म्हैमुँ; क्हिए ताँमैं थोसि प्रबइले ङ जोगेमिंन् ");
INSERT INTO gvr_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","क्हिए बिरोधर ङइ पाप आलरिगे बिसि क्हिजी बिबै ताँमैं ङए सैं न्होंर जोगेसि थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","ओ याहवेह, क्हिए मिं थेब् तरिगे! क्हिए ठिममैं ङ लोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","क्हिए सुँउँइँले त्होंबै ताँन् ठिममैंए बयन ङइ लमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","ल्हें सैन्होर योंबै म्हि सैं तोंब् धोंले क्हिजी बिबै ताँमैं ङिंबर ङए सैं तोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","क्हिजी लद् बिबै ताँमैं ङइ सैंर मैंमुँ धै क्हिजी लोमिंबै ताँमैं ङइ मैंरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","क्हिजी पिंबै ठिममैंर ङए सैं तोंरिब्मुँ; धै क्हिए ताँमैं ङ खोंयोंइ म्‍लेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","ङ ल्हें सोसि क्हिए ताँमैं ङिंरिगे बिसि ह्रोंसए के लबै म्हिलाइ बिब् धों मैंब् धों लमिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","क्हिए ठिमर्बै आचम्बै ताँमैं ङइ म्रोंल् योंरिगे बिसि ङए मि थोमिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","ङम् चु ह्‍युलर ङ्हिरोबै प्ह्रें ग; क्हिए ताँमैं ङउँइँले आलोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","क्हिए ठिममैं क्होबर ङए खों खोंयोंन् बिलै क्यु पिब् धोंन् तम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","थेब् प्हैंब्मैंलाइ क्हिजी हौदिमुँ। चमैं सरापए न्होंर मुँ, क्हिजी तेंबै घ्याँर चमैं आप्र। ");
INSERT INTO gvr_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","क्हिजी बिबै ताँमैं ङइ ङिंइमुँ। छतसि ङए अब्ब्रु वासि ङलाइ प्ह्रब्मैं ङ ङाँइँले स्योमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","क्रथे मिंथेमैं खागु तसि ङए बिरोधर ताँ लम्, दिलेया क्हिए के लबै म्हिइ क्हिए निसाफमैं छेनाले मैंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","क्हिजी बिबै ताँमैंइ ङए सैं तोंन् लइमुँ; च ताँमैंइन ङलाइ छेनाले लोदा सैंदा लम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","ङ त्हुलर्न सिबि छेइमुँ, छतसि क्हिजी बिब् धोंलेन् ङए रक्षा लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","ङए बानि ब्योर खै तब् मुँ बिसि ङइ क्हिने बिमा क्हिजी ङ जवाफ पिंइ; क्हिजी पिंबै ठिममैं ङलाइ लोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","क्हिजी ल्हैदिबै केमैं छेनाले क्होल् खाँरिगे बिसि क्हिजी लबै औदिबै केमैं ङइ मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","शोकइ लमा ङ तोइ लल् आखाँब् तइमुँ; छतसि क्हिए ताँइ बिब् धोंले ङ भोंब् लमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","आछ्याँबै घ्याँमैंउँइँले ङलाइ स्यो लसि थेंन्; धै ङए फिर दयाम्हाँया लसि क्हिए ठिमर्बै ताँमैं ङ लोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","ङइ क्ह्रोंसेन्बै घ्याँ त्हाँइमुँ; क्हिए निसाफमैं ङइ ङए ओंसों थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","ओ याहवेह, क्हिजी बिबै ताँमैं ङइ ङिंइमुँ। ङ फाफिल् लल् आपिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","क्हिजी बिबै घ्याँर ङ प्रइमुँ, तलेबिस्याँ क्हिजी ङए खों खाँसों ङ्हाँन् लमिंइमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","ओ याहवेह, क्हिए निसाफमैंइ बिब् धोंलेन् प्रब ङलाइ लोमिंन्; धै चमैंइ बिब् ङिंसि ङ लिउँइँ समा प्ररिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","ङलाइ क्होल् खाँबै शक्ति पिंन्, धै ङइ क्हिए ठिमर्बै ताँमैं म्हाँदिब्मुँ; धै ङए खों न्होंउँइँलेन् ङ ङिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","क्हिजी ल्हैदिबै के छेनाले लल् खाँबै म्हि ङलाइ तल् पिंनु, तलेबिस्याँ च केर्न ङए सैं तोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","ङए सैंर तोइ सैलैया लोब् आखरिगे बिसि ङए सैंर क्हिए बिबै ताँमैं थेंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","ङए मिइ केर आफेबै सैमैं ङ्ह्‍योल् आपिंन्; क्हिए ताँइ बिब् धोंलेन् ङए‍ रक्षा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","क्हिलाइ मान लबै म्हिमैंने क्हिजी बाछा फैइमुँ; क्हिए के लबै म्हिए ल्हागिर च बाछा पूरा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","क्हिए ठिममैं छ्याँब मुँ, दिलेया च ठिममैं म्हाँदिबइले म्हिमैंइ ङलाइ प्ह्रम्। ङ फा पिल त्हुलै बिसि ङ ङ्हिंम्। छतसि ङलाइ प्ह्रबै म्हिमैं ङउँइँले स्योमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","क्हिजी ल्हैदिबै केमैं ताँन् ङइ लइमुँ! छतसि ठिक निसाफ लसि ङलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","ओ याहवेह, क्हिए खोंयोंइ आनुबै म्हाँया ङइ योंरिगे, क्हिजी बाछा फैसि पिंम् बिबै मुक्ति ङए ङाँर खरिगे; ");
INSERT INTO gvr_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","छतस्याँ ङलाइ प्ह्रब्मैंलाज्यै या ङइ बिल् योंब्मुँ, तलेबिस्याँ क्हिजी बिबै ताँर ङइ भर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","खोंयोंन् बिलै ङइ क्हिए क्ह्रोंसेंन्बै ताँमैं पोंल् खाँरिगे; तलेबिस्याँ क्हिए निसाफमैंर ङइ आशा थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","क्हिए ठिमर्बै ताँमैं ङइ खोंयोंन् बिलै म्हाँदिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","ङ खाँसो ङ्हाँन्ले प्रब्मुँ, तलेबिस्याँ क्हिजी ल्हैदिबै केमैं लबै भों ङइ लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","म्रुँमैंए उँइँर क्हिजी बिबै ताँमैंए बारेर ङ पोंब्मुँ, धै ङ फापिल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","क्हिजी ल्हैदिबै केमैं लमा ङए सैं तोंम्, तलेबिस्याँ क्हिजी बिबै ताँमैं ङइ खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","क्हिजी बिबै ताँमैं ङइ खोसि म्हाँदिम, धै क्हिए निसाफैंन् ङइ मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","ह्रोंसए के लबै म्हिने फैबै बाछा मैंमिंन्, तलेबिस्याँ चउँइँले क्हिजी ङलाइ आशा पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","ङए फिर दुःख तमा क्हिजी फैबै बाछाइन ङए सैं क्होमिंइमुँ, च बाछाइन ङ जोगेमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","तोंन् तोर्न थेब् प्हैंब्मैंइ ङलाइ प्ह्रसि निस्योइमुँ, दिलेया क्हिए ठिमउँइँले ङ ह्रेंगो आतइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","क्हिजी स्योंम् ओंनों लबै निसाफमैं ङइ मैंरिइमुँ। छतसि ओ याहवेह, चमैंइन ङए सैं क्होमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","क्हिए ठिमर्बै ताँमैंइ बिब् धों आलबै दुष्‍टमैं म्रोंसि ङ बेल्‍ले ह्रिस खइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","ङ खनिर टिलैया क्हिए निसाफमैंए बारेर ङइ भजन प्रिंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","ओ याहवेह म्हुँसरैया ङ क्हिलाइन मैंरिमुँ, धै क्हिए ठिमइ बिब् धोंलेन् ङइ लरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","ङ खोंयोंन् बिलै क्हिजी ल्हैदिबै केमैं ङइ लरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","ओ याहवेह, ङ‍ए चैदिबै सै क्हिन् ग! क्हिए ताँमैं ङिंम् बिसि ङइ बाछा फैइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","ङए खों न्होंउँइँलेन् क्हिलाइ म्हैइमुँ; क्हिजी फैबै बाछा मैंसि ङए फिर दयाम्हाँया लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","ङए बानि ब्योर ङइ च्हैंब् मैंब् लइमुँ, धै क्हिए ताँइ बिब् धोंबै घ्याँर ङइ प्रबै भों लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","क्हैल् आलल्‍ले युन्ले क्हिजी ल्हैदिबै के लबै सैं ङल् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","दुष्‍ट म्हिमैंइ ङलाइ छोइ फैथेंलैया क्हिए ठिमर्बै ताँमैं ङ म्‍लेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","क्हिजी लबै ठिक निसाफमैंए ल्हागिर म्हुँइँस आधरैया क्हिलाइ धन्यबाद पिंबर ङ रेम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","क्हिने ताँन् ङ्हिंब्मैंए थु ङ ग; ओं, क्हिजी ल्हैदिबै के ताँन् लब्मैंए थु ङ ग। ");
INSERT INTO gvr_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","ओ याहवेह, क्हिए खोंयोंइ आनुबै म्हाँयाजी पृथ्बी प्लिंइमुँ; क्हिए निसाफमैं ङलाइ लोमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","ओ याहवेह, क्हिजी ताँ बिब् धोंलेन् क्हिए के लबै म्हिलाइ बिब् धों मैंब् धों लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","क्हिए ताँमैं ङइ क्वेंइमुँ; छतसि ज्ञान बुद्धिए छ्याँब ताँमैं ङलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","ङए फिर दुःख खब् भन्दा ओंसों ङ घ्याँ फ्लेसि प्ररिल, दिलेया तारेम् क्हिजी बिबै ताँमैं ङिंसि ङ प्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","क्हि स्वाब मुँ, क्हिजी छ्याँबै के लम्; क्हिए निसाफइ बिब् धोंले प्रब ङलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","थेब् प्हेंब्मैंइ ङए बिरोधर स्योलिबै ताँमैं ललैया, क्हिजी ल्हैदिबै केमैं ङइ ताँन् खोंउँइँले लम्; ");
INSERT INTO gvr_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","चमैंए खों सारो मुँ, चमैंइ खाबलाज्यै या दयाम्हाँया आल। दिलेया ङए सैं बिस्याँ क्हिए ठिमर्बै ताँमैंर्न तोंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","ङए फिर दुःखमैं तखब छ्याँबन् तइ, तलेबिस्याँ क्हिए निसाफमैं ङइ क्होल् योंइ। ");
INSERT INTO gvr_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","मारा नेरो चाँदिए हजार टुक्र भन्दै या क्हिए सुँउँइँले त्होंबै ठिम ङए ल्हागिर बेल्‍ले छ्याँब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","क्हिए योजीन् ङ बनेइ; क्हिए ताँमैं लोबर ङलाइ क्होबै शक्ति पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","क्हिजी बिबै ताँर ङइ आशा थेंइमुँ; छतसि क्हिलाइ मान लब्मैं ङलाइ म्रोंसि सैं तोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","ओ याहवेह, क्हिजी लबै निसाफमैं ठिक मुँ। तले ङलाइ दुःख पिंइ बिस्याँ क्हि भर लल् खाँब मुँ बिसि ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","ङ क्हिए के लबै म्हिने क्हिजी फैबै बाछाउँइँले क्हिए खोंयोंइ आनुबै म्हाँयार ङए सैं क्होमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","क्हिए ठिमर्बै ताँमैंइन ङए सैं तोंन् लमिंम्; छतसि ङ सोरिगे बिसि क्हिए ल्हयो ङए फिर थेंमिन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","थेब् प्हैंब्मैं फा पिन् तरिगे तलेबिस्याँ चमैंइ तोन् तोर्न ङए न्होह्रों लम्; दिलेया ङ बिस्याँ क्हिजी ल्हैदिबै केमैं मैंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","क्हिलाइ मान लब्मैं ङउँइँ तोरिगे; ओं, क्हिजी बिबै ताँमैं क्होब्मैं ङउँइँ तोरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","ङ फापिल् आत्हुबै ल्हागिर क्हिए निसाफमैंइ बिब् धोंले ङए खों छ्याब मुँब आतरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","क्हिजी खोंयों जोगेमिंब् ङ्‍हे बिसि क्हिए घ्याँ ङ्‍ह्‍योन-ङ्‍ह्‍योन् ङ नारल् खाँइ। दिलेया क्हिजी फैबै बाछार ङइ आशा थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","क्हिजी फैबै बाछाए ताँ मैंन-मैंन् ङए मि छेन्ले आम्रोंब् तल् खाँइमुँ; “खोंयों क्हिजी ङए सैं क्होमिंमुँ?” ");
INSERT INTO gvr_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","केर आफेबै च्युँयाबै छाकल धोंन् ङ तयाइमुँ, दिलेया क्हिए निसाफमैं ङइ आम्‍लेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","ङइ अझै खोंयों समा प्रेंल् त्हुब् जा? ङए न्होह्रों लब्मैंलाइ क्हिजी खोंयों दण्ड पिम्? ");
INSERT INTO gvr_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","क्हिए ठिमर्बै ताँ आङिंसि थेब् प्हैंब्मैंइ ङ पायारिगे बिसि होंल्दो ताइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","क्हिए ताँन् ताँमैं भर लल् खाँब मुँ; छतसि ङ ल्होमिंन्, तलेबिस्याँ म्हिमैंइ तोन् तोर्न ङलाइ ह्रुगुदिइमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","चमैंइ ङ धन्दै सैवाब, दिलेया क्हिजी ल्हैदिबै केमैं ङइ लसिन् मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","क्हिए खोंयोंइ आनुबै म्हाँयाइ ङए फिर रक्षा लमिंन्, तलेबिस्याँ क्हिए सुँउँइँले त्होंबै ताँमैंइ बिब् धों ङइ लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","ओ याहवेह, क्हिजी बिबै ताँ खोंयोंन् बिलै तरिम्; सवर्गर च भोंले थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","क्हिजी पोंबै ताँमैं पुस्ता-पुस्ता समान् तरिम्; पृथ्बी क्हिजीन् छेनाले बनेइ, छतसि च खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","क्हिए निसाफमैंइ तो‍-तो बिइमुँ तिंयाँ समन् छान् तरिइमुँ, तलेबिस्याँ क्हिए ताँ तोंन्दोरिइ म्हाँदिल् त्हुम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","क्हिए ठिमर्बै ताँमैंइ ङए सैं तोंल् आलस्याँ, ङए दुःखइ लमा ङ सियामल। ");
INSERT INTO gvr_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","क्हिजी लोदा सैंदा लबै ताँमैं ङ खोंयोंइ म्‍लेरिब् आरे, तलेबिस्याँ चमैंउँइँलेन् ङ सोरिल् योंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","क्हिजी ल्हैदिबै केमैं ङइ लसिन् मुँ; ङ जोगेमिंनु तलेबिस्याँ ङ क्हिलन् ग। ");
INSERT INTO gvr_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","ङलाइ सैब् बिसि दुष्‍ट म्हिमैं ह्रेसि टिइमुँ, दिलेया ङए सैंइ क्हिजी बिबै ताँमैंन् मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","तो सैन् मुँलेया तिस्याँ मत्‍त्रे ग बिब ङइ सेइमुँ, दिलेया क्हिए ताँमैं बिस्याँ खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","क्हिए ठिम ङइ बेल्‍ले खोम्! त्हिंतिमिन् ङ चन् मैंरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","क्हिए ताँमैं खोंयोंन् बिलै ङए सैंर थेंइमुँ, च ताँमैंइन ङए शत्तुरमैं भन्दा ङ बुद्धि मुँब लमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","ङलाइ लोमिंब्मैंइ भन्दा ङइ ल्हें क्होइमुँ, तलेबिस्याँ क्हिजी बिबै ताँमैं ङए सैंर मैंरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","चिब्मैंइ भन्दा ङइ ल्हें च्हैंब् मैंब् लल् खाँम्; तलेबिस्याँ क्हिजी ल्हैदिबै केमैं ङइ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","क्हिजी बिब् धोंबै केमैं लल् खाँरिगे बिसि ङइ आछ्याँबै के लबै घ्याँर प्रब पिवाइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","क्हिए निसाफमैंइ बिब् धोंलेन् ङ प्ररिइमुँ, तलेबिस्याँ छले प्रबर क्हिजीन् ङ लोमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","क्हिजी फैबै बाछा ङए लेर बेल्‍ले लिंब तइमुँ, क्वे खुदु भन्दै या ङए सुँर च बेल्‍ले लिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","क्हिजी ल्हैदिबै केमैंउँइँलेन् ङइ च्हैब् मैंब् लल् खाँबै शक्ति योंइमुँ; छतसि ताँन् आछ्याँबै के लबै घ्याँमैं ङइ पिवाल् खाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","क्हिए ताँ ङए प्हलेमैंए ल्हागिर बत्ति ग, धै ङ प्रल् त्हुबै घ्याँर ङलाइ डोरेबै ह्‍वे ग। ");
INSERT INTO gvr_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","क्हिए ठिक निसाफमैंइ बिब् धोंबै के लब्मुँ बिसि ङइ कसम चइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","ङइ बेल्‍ले दुःख योंइमुँ; ओ याहवेह, क्हिजी बिब् धोंलेन् ङलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","ओ याहवेह, ङइ क्हिए मिं क्वेमा क्हि सैं तोंमिंन्। धै क्हिए निसाफमैं ङलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","ङ कालए सुँर्न फेल् त्हुलैया क्हिए ठिमर्बै ताँमैं ङइ म्‍लेरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","दुष्‍ट म्हिमैंइ ङए ल्हागिर ङो चुइमुँ, दिलेया क्हिजी ल्हैदिबै केमैं ङइ लइन मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","क्हिजी बिबै ताँमैं ङए ल्हागिर मारा मुइ भन्दा थेब मुँ, च ताँमैंइ खोंयोंइ बिलै ङ‍ए सैं तोंन् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","ङ आसिन् समा क्हिए निसाफमैं म्हाँदिब्मुँ बिसि ङइ सैं लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","सैं ङ्हिरि तबै म्हिमैं ङइ आखो, दिलेया क्हिए ठिम ङइ खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","क्हि ङए लोबै क्‍ल्‍ह्‍यो नेरो ढाल ग; क्हिए ताँर ङइ भर थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","ङए परमेश्‍वरए ताँमैं ङइ छेनाले ङिंरिगे बिसि, ओ दुष्‍ट के लब्मैं, ङउँइँले ह्रेंगो तह्‍याद्। ");
INSERT INTO gvr_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","ङ सोरिबै ल्हागिर क्हिजी फैबै बाछा अनुसार ङलाइ भोंब लमिंन्। ङइ थेंबै आशा फुल् आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","ङ सोल् योंरिगे ङलाइ जोगेमिंन्; धै क्हिए निसाफमैं खोंयोंन् बिले ङइ छेनाले म्हाँदिब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","क्हिए निसाफमैं आङिंब्मैं क्हिजी भ्योंवाम्, तलेबिस्याँ चमैंइ पोंबै स्योलिबै ताँमैं केर आफे। ");
INSERT INTO gvr_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","पृथ्बीर्बै ताँन् दुष्‍ट म्हिमैंलाइ क्हिजी कसिं भ्योंब् धोंले भ्योंवाम्, छतसि क्हिजी बिबै ताँमैं ङइ बेल्‍ले खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","क्हिने ङ्हिंसि ङ त्हाररिमुँ, धै क्हिए निसाफमैं म्रोंसि ङ ङ्हिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","ङइ क्ह्रोंसेंन्बै ठिक केमैं लसि प्रइमुँ; छतसि दुःख पिंब्मैंए योर ङलाइ आवाथेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","ह्रोंसए के लबै म्हिलाइ छ्याँबै के लमिंबै जिम्मा किंन्; थेब् पैंब्मैंइ ङलाइ खैच्हिजी लल् आयोंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","क्हिजी खोंयों जोगेमिंब् ङ्‍हे? धै क्हिजी फैबै क्ह्रोंसेंन्बै बाछा खोंयों पिंब् ङ्‍हे? बिसि ङए मि छेन्ले आम्रोंब् तल् खाँइमुँ; ");
INSERT INTO gvr_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","क्हिए खोंयोंइ आनुबै म्हाँयार ह्रोंसए के लबै म्हिए फिर ल्हयो लमिंन्, धै क्हिए निसाफमैं ङलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","ङ क्हिए के लबै म्हि ग! छतसि क्हिजी बिबै ताँमैं क्होल् खाँरिगे बिसि ङलाइ च्हैंब् मैंब् लल् पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","ओ याहवेह, म्हिमैंइ क्हिए ठिमए बिरोध लइमुँ! चमैंलाइ तो लल् त्हुब् जा क्हिजीन् लद्। ");
INSERT INTO gvr_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","मारा मुइ भन्दा, बेल्‍ले छ्याँबै मारा भनदै या, क्हिए ताँमैंन् ङइ खोम्, ");
INSERT INTO gvr_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","धै क्हिजी लद् बिबै ताँन् केमैं ङइ लइमुँ; आछ्याँबै के लबै ताँन् घ्याँ ङइ आखो। ");
INSERT INTO gvr_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","क्हिजी बिबै ताँमैं औदिबै मुँ; छतसि सैं न्होंउँइँलेन् ङइ चमैं ङिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","क्हिए ताँए अर्थ खोल्दिमिंमा ज्ञान बुद्धि योंमुँ, धै आह्र आसेब्मैं या ह्रब् सेब् तम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","क्हिए ताँमैं ङइ छेनाले क्होदा ङ्हाँसि ङ क्यु पिब् धोंले सो हेंम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","क्हिए मिं म्हाँया लब्मैंए फिर क्हिजी ल्हयो लब् धोंले ङए फिर दयाम्हाँया लसि ङ ङाँइ तोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","क्हिजी फैबै बाछाइ बिब् धोंलेन् ङलाइ ठिक घ्याँर डोरेमिंन्, तोइ सैज्यै या ङलाइ पापर च्होवाल् आखाँरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","क्हिजी ल्हैदिबै केमैं लल् खाँबै ल्हागिर ङलाइ दु:ख पिंब्मैंउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","क्हिए के लबै म्हिलाइ छ्याँब लमिंन्; धै क्हिए निसाफमैं ङलाइ लोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","म्हिमैंइ क्हिए ठिम आङिंब् म्रोंमा ङए सैं नसि मिग्लि युम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","ओ याहवेह, क्हिजी ठिक के लमुँ, धै क्हिए निसाफमैं ठिक मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","क्हिजी बिबै ताँमैं ठिक मुँ, धै क्ह्रोंसेंन्बै भर लल् खाँबै ताँमैं मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","ङए शत्तुरमैंइ क्हिए ताँमैंलाइ तो धोंइ आङ्हाँब् म्रोंसि ङ बेल्‍ले त्होंदो रासि मिइ धोंले ङलाइ ख्रोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","क्हिजी फैबै बाछार्बै ताँमैं जाँच लसि पक्‍का मुँ, छतसि क्हिए के लबै म्हिइ च ताँ बेल्‍ले खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","ङ तोंन् तोर्बै मुँ बिसि म्हिमैंइ म्हि आच्हि, दिलेया क्हिजी ल्हैदिबै केमैं ङइ आम्‍ले। ");
INSERT INTO gvr_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","क्हिजी लबै ठिक केमैं खोंयोंन् बिलै तरिमुँ, धै क्हिए ठिमर क्ह्रोंसेंन्बै ताँमैं मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","ङए फिर थेबै दुःख तइमुँ, दिलेया क्हिए ताँमैंइ ङए सैं तोंल् लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","क्हिजी बिबै ताँमैं खोंयोंन् बिलै ठिक मुँ! ङ सोरिगे बिसि च ताँमैं क्होबै शक्ति पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","ओ याहवेह, ङए सैं न्होंउँइँलेन् ङइ क्हिने ग्वार हिमा ङ जवाफ पिंन्, धै क्हिए निसाफमैं ङइ म्हाँदिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","ङइ क्हिने ग्वार ह्रिमा ङ जोगेमिंन्, झाइले क्हिजी बिबै ताँमैं अनुसार ङ प्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","त्हिंइ प्योब् भन्दा ओंसों रेसि ङ क्हिने ग्वार ह्रिमुँ; ङइ क्हिए ताँए फिर आशा थेंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","क्हिजी फैबै बाछाए ताँमैं मैंबै ल्हागिर म्हुँइँस तिरो ङ न्हरु आख। ");
INSERT INTO gvr_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","ओ याहवेह, क्हिजी खोंयोंन् बिलै ङने म्हाँया लमुँ; छतसि ङए ताँ थेमिंनु, क्हिए निसाफमैं अनुसार ङलाइ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","आछ्याँबै के लप्रबै दुष्‍ट म्हिमैं ङए ङाँर खसिन् मुँ, क्हिए ठिमर्बै ताँमैं चमैंइ तिफुँइ आम्हाँदि! ");
INSERT INTO gvr_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","दिलेया ओ याहवेह, क्हि ङए ङाँर्न मुँ, धै क्हिए ताँन् ताँमैं क्ह्रोंसेंन्बै मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","खोंयोंन् बिलै तरिगे बिसि क्हिजी क्हिए ताँमैं प्ह्रिथेंइ बिसि ङइ च ताँमैंउँइँले ओंसों ओंनोंन् लोइ। ");
INSERT INTO gvr_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","क्हिए ठिम ङइ आम्‍लेइमुँ, छतसि ङए दुःख ङ्ह्‍योमिंसि ङ फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","ङए ख लसि ङए ल्हागिर पोंमिंन्, धै चु दु:खउँइँले ङ फ्रेमिंन्; क्हिजी फैबै बाछा अनुसार ङलाइ जोगेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","दुष्‍टमैंइ मुक्ति योंरिब् आरे, तलेबिस्याँ क्हिए निसाफमैं चमैंइ आम्हाँदि। ");
INSERT INTO gvr_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","ओ याहवेह, क्हिजी ङए फिर बेल्‍ले ल्हयो खमुँ; क्हिए निसाफमैंइ बिब् धोंलेन् ङए रक्षा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","ङलाइ ह्रुगुदिबै शत्तुरमैं ल्हें मुँ, दिलेया क्हिजी तामैं बिब् धोंलेन् प्ररिब ङ आपिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","धोका पिंबै म्हिमैं ङइ तिफुँइ आखो; तलेबिस्याँ क्हिजी बिबै ताँमैं चमैंइ आङिं। ");
INSERT INTO gvr_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","ङ्ह्‍योत्ति, क्हिजी चु के लद् बिबै ताँमैं ङइ कति म्हाँया लइमुँ! छतसि ओ याहवेह, क्हिए खोंयोंइ आनुबै म्हाँयाजी ङलाइ रक्षा लमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","क्हिजी पोंबै ताँन् ताँमैं क्ह्रोंसेंन्बै मुँ, क्हिए ताँन् ठिक निसाफमैं खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","क्रथे मिंथेमैंइ तोन्-तोर्न ङलाइ ह्रुगुदिम्, दिलेया ङए सैं क्हिए ताँर्न तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","लुडिसि पखबै सै न्होर योंबै म्हि सैं तोंब् धोंले क्हिजी फैबै बाछए ताँर ङ सैं तोंम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","स्योलिबै ताँमैंर ङ धोंइ आङ्हाँ, छाबै ताँमैं ङइ आखो, दिलेया क्हिए ठिम ङइ खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","क्हिए ठिक निसाफमैंए ल्हागिर तिंगैंर्न ङइ ङिखे समा क्हिए मिं थेब् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","क्हिए ठिमइ खोब्मैंइ तो सैरै या न्हुँ लल् आत्हु; तो सैज्यै या चमैंलाइ ट्होल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","ओ याहवेह, क्हिजी जोगेमिंब्मुँ बिसि ङइ ह्रेरिइमुँ; धै क्हिए ताँमैं अनुसार ङ प्ररिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","क्हिजी बिबै ताँमैं ङइ ङिंरिइमुँ; तलेबिस्याँ च ताँमैं ङइ बेल्‍ले खोम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","क्हिजी ल्हैदिबै केमैं ङइ लमुँ, धै क्हिजी बिबै ताँमैं ङइ ङिंम्; तलेबिस्याँ ङए ताँन् बानि ब्योर क्हिजी सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","ओ याहवेह, ङइ ग्वार ह्रिमा क्हिजी थेमिंनु; क्हिए ताँइ बिब् धोंले ङलाइ क्होबै शक्ति पिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","ङइ यो छ्युँ लमा क्हिजी थेमिंनु; क्हिजी फैबै बाछा अनुसार ङलाइ फ्रेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","क्हिए निसाफमैं ङलाइ क्हिजी लोमिंम्; छतसि ङए सुँउँइँले खोंयोंन् बिलै क्हिए मिं क्‍वेबै ताँमैं त्होंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","क्हिए ताँमैं ताँन् ठिक मुँ; छतसि ङए सुँइ क्हिए बाछाए छ्याँबै बयन प्रिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","क्हिजी ल्हैदिबै केमैं ङइ लइमुँ; छतसि क्हिए योजी खोंयोंन् बिलै ङलाइ ल्होमिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","ओ याहवेह, ङइ क्हिए मुक्तिर आशा थेंइमुँ, धै क्हिए ठिमइ ङए सैं तोंल् लम्। ");
INSERT INTO gvr_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","क्हिए मिं क्वेबै ल्हागिर ङ सोल् योंरिगे, धै क्हिए निसाफमैंइ ङलाइ ल्होरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","म्हयाबै क्यु धों ङ तप्ररिइमुँ; ह्रोंसए केब्छैंलाइ म्हैदु, तलेबिस्याँ क्हिए ताँमैं ङइ आम्‍लेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","कैंडो क्रेबै त्हेर्बै क्वे ङए दुःखर ङ याहवेहने ग्वार ह्रिमा खीजी ङने ज्वाफ पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","स्योर तेबै म्हदे मुँबै म्हिमैंउँइँले, नेरो छलु म्हिलु लबै म्हिए लेउँइँले, ओ याहवेह, ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","ओ स्योर तेबै ले, खीजी क्हिए फिर कति थेबै दण्ड पिंलै? क्हिने झन् खै लब्मुँ? ");
INSERT INTO gvr_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","खीजी क्हिए फिर सिपाइमैंइ छेबै म्ह्रुछु तबै मेमैंइ दण्ड पिंब्मुँ, धै झ्याडिर लुँरिबै मिए राबइ ख्रोंवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","धिक्‍कार ङ, तलेबिस्याँ मेशेकर्बै ल्हयो आखब्मैं टिब् धोंले धै केदारर्बै तम्बुमैंए म्हाँजोर स्याँ म्हि टिब् धोंले ङ क्हेमैंए म्हाँजोर टिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","शान्तिलाइ आखोब्मैंए म्हाँजोर ङ टिब ल्हें तइ। ");
INSERT INTO gvr_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","ङ शान्ति म्हैबै म्हि ग, दिलेया ङ छले पोंमा चमैं नेबर तयार तम्। ");
INSERT INTO gvr_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","कैंडो क्रेबै त्हेर्बै क्वे कोंमैंउँइँ ङइ मि ङ्ह्‍योमुँ। ङलाइ ल्होबर खनिउँइँले युम्? ");
INSERT INTO gvr_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","स्वर्ग नेरो पृथ्बी बनेबै याहवेहउँइँले ङलाइ ल्होबर युम्। ");
INSERT INTO gvr_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","खीजी क्हिए प्हले प्लेल् पिंरिब् आरे; क्हिए रक्षा लबर खी खैंमइ न्हरु च्हुइरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","क्ह्रोंसेंन इस्राएलए रक्षा लबर खी खोंयोंइ न्हरु आकु धै न्हरु या च्हुइरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","याहवेहजी क्हि रक्षा लमिंम्; याहवेह क्हिए क्योलो योउँइँबै छरि ग। ");
INSERT INTO gvr_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","त्हिंइर्बै त्हिंयाँइ क्हिए न्होह्रों लरिब् आरे, धै म्हुँइँसर्बै लयाँइ क्हिए न्होह्रों लरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","क्हिलाइ न्होह्रों लबै तोन्दोंरि सैमैंउँइँले याहवेहजी जोगेमिंब्मुँ; खीजी क्हिए सोए रक्षा लमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","क्हि बैरु ह्‍यामा न्होंर खमा खनि ह्‍यालै या याहवेहजी क्हिए रक्षा लमिंब्मुँ, तोगोउँइँले खोंयोंन् बिलै। ");
INSERT INTO gvr_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","कैंडो क्रेबै त्हेए ल्हागिर दाऊदइ प्ह्रिबै क्वे घ्रि “लु, ङ्यो याहवेहए धिंर ह्‍याले!” बिसि म्हिमैंइ ङने बिमा ङए सैं तोंइ। ");
INSERT INTO gvr_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","ओ यरूशलेम, ङिए प्हलेमैं क्हिए म्रामैं न्होंर राइमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","छेन्ले क्ह्रिबै सहर घ्रि धोंले यरूशलेम बेल्‍ले छेन्ले बनेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","याहवेहजी इस्राएलीमैंने ताँ बिब् धोंले कुल-कुलर्बै म्हिमैं, याहवेहए कुलमैं, खीए मिंलाइ धन्यबाद पिंबर चु सहरर ह्‍यामुँ। ");
INSERT INTO gvr_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","चुर्न दाऊदए खलगर्बै म्रुँमैं निसाफ लबर चु सहरर्बै गद्दिमैंए फिर क्हुँम्। ");
INSERT INTO gvr_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","यरूशलेमर शान्ति तरिगे बिसि प्राथना लद्! “क्हिए फिर म्हाँया लब्मैंल बिब् धों तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","क्हिए गारमैंए न्होंर शान्ति तरिगे, धै क्हिए किल्‍लामैंए न्होंर छ्याँब क्ह्‍युब तरिगे!” ");
INSERT INTO gvr_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","“क्हिए न्होंर शान्ति तरिगे!” बिसि ङए आघें-अलिमैं नेरो ङए थुमैंए ल्हागिर ङइ बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","याहवेह ङ्योए परमेश्‍वरए धिं छेन् लल् खाँरिगे बिसि “ङइ क्हिए ल्हागिर” प्राथना लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","कैंडो क्रेबै त्हेर्बै क्वे ओ स्वर्गर्बै राजगद्दिर टिबै परमेश्‍वर, क्हि ङाँइन ङ ङए मि क्वेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","खैले केब्छैंमैंए मिइ ह्रोंसए क्ल्हेए योउँइँ ङ्ह्‍योमुँ, खैले क्येब्स्योए मिइ ह्रोंसए क्ल्हेस्योए योउँइँ ङ्ह्‍योमुँ, छलेन ङिए याहवेह परमेश्‍वरजी ङिए फिर ल्हयो आखन् समा ङिए मि खी ङाँइँन ङ्ह्‍योरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","ङिए फिर ल्हयो खमिंन्, ओ याहवेह, ङिए फिर ल्हयो खमिंन्, तलेबिस्याँ म्हिमैंइ प्ह्रब ङिइ ल्हें सैदिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","थेब प्हैंब्मैंइ प्ह्रब नेरो ह्रब् सेब् प्हैंब्मैंइ हेल लब ङिइ ल्हें सैदिरिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","कैंडो क्रेबै त्हेए ल्हागिर दाऊदइ प्ह्रिबै क्‍वे। “याहवेह ङ्योने बालु आरेस्याँ!” इस्राएलीमैंइ बिरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","“याहवेह ङ्योने आरेस्याँ म्हिमैंइ सैल् म्हैबै त्हेरि ");
INSERT INTO gvr_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","चमैंए ह्रिंस ङिए फिर मि धोंले लुँमा चमैंइ ङि सोगोंन् क्ल्ह्‍योंवामल। ");
INSERT INTO gvr_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","प्ल्होंखबै बाढिइ धोंले चमैंइ ङि गास घ्रिन् लवामल; धै प्हलें ङिए फिर प्रमल; ");
INSERT INTO gvr_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","प्ल्हों खबै बाढिइ ङि नोइ बोयामल।” ");
INSERT INTO gvr_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","याहवेहजी शत्तुरमैंए योउँइँले ङ्योलाइ सिल् आपिं। छतसि खीए मिं थेब् तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","नमे सैइ प्रबै म्हिइ चुबै ङोउँइँले नमे स्योरब् धोंले ङि स्योर खइमुँ; चमैंए जाल ट्होयाइ, धै ङि त्होंल् योंइ! ");
INSERT INTO gvr_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","स्वर्ग नेरो पृथ्बी बनेबै याहवेहए मिंर ङ्योइ ग्वार योंम्। ");
INSERT INTO gvr_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","कैंडो क्रेबै त्हेर्बै क्वे याहवेहए फिर भर थेंब्मैं सियोन कों धों तम्, च कोंलाइ खाबज्यै लाल् आखाँ, खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","यरूशालेमलाइ कोंमैंइ कारर्ग्यु लब् धोंले, याहवेह ह्रोंसए म्हिमैंए कारर्ग्युले खोंयोंन् बिलै तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","ठिक के लब्मैंए ह्‍युलर दुष्‍टमैं तरिब् आरे, आस्याँ ठिक के लब्मैंए योइ आछ्याँबै के लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","ओ याहवेह, छ्याँब लब्मैंलाइ छ्याँबन् लमिंन्, छलेन छ्याँबै खों प्ह्‍याब्मैंलाज्यै या छ्याँबन् लमिंन् ");
INSERT INTO gvr_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","दिलेया आछ्याँबै के लप्रब्मैं बिस्याँ याहवेहजी दुष्‍ट के लब्मैंलाइ पिंब् धों तबै सजैं पिंब्मुँ! इस्राएलए फिर शान्ति तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","कैंडो क्रेबै त्हेर्बै क्वे याहवेहजी ङिलाइ सियोनर एपखमा ङि म्होंड धोंन् ङ्हाँइ। ");
INSERT INTO gvr_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","धै ङि बेल्‍ले सैं तोंसि निस्योदै क्वे प्रिंइ! छाब् म्रोंसि “याहवेहजी चमैंए ल्हागिर थेबै केमैं लमिंइमुँ।” बिसि अरू ह्रेंर्बै म्हिमैंइ बिइ। ");
INSERT INTO gvr_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","याहवेहजी ङ्योए ल्हागिर थेबै के लमिंइमुँ, छतसि ङ्यो सैं तोंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","ओ याहवेह, नेगेब ह्‍युलर स्योंमैं प्ल्हों खब् धोंले शत्‍तुरमैंइ बोसि च्युथेंबै ङिए म्हिमैं एसि पखमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","क्रोदै प्लु प्लुब्मैंइ सैं तोंबै क्वे प्रिंदै खैंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","क्रोदै प्लु नोसि प्लुबर ह्‍याब्मैंइ म्ल्हा-नारेए तिमैं नोसि सैं तोंबै क्वे प्रिंदै एखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","कैंडो क्रेबै त्हेए ल्हागिर सोलोमनइ प्ह्रिबै क्वे याहवेहजीन् धिं आबनेस्याँ बनेब्मैंए के फाकर्न तम्। याहवेहजीन् सहर आरुँमिंस्याँ रुँब्मैंइ रुँब फाकर्न तम्। ");
INSERT INTO gvr_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","चबै सैमैंए ल्हागिर दुःख लबर न्हाँगर्न रेब नेरो ङेसर क्हैल्‍ले रोबै या फाकर्न ग, तलेबिस्याँ खीजी म्हाँया लब्मैंलाइ, न्हरु पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","च्ह च्हमिमैं याहवेहजी पिंबै आशिकमैं ग, फो न्होंर्बै प्हसेमैं खीजी पिंबै इनाम ग। ");
INSERT INTO gvr_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","ल्हडेर ह्‍याबै म्हिए योर्बै मे धों तब फ्रें-छमिंर योंबै प्हसेमैं तम्। ");
INSERT INTO gvr_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","त्हुर ल्हें मे मुँबै म्हि आशिक योंबै म्हि ग, तलेबिस्याँ निया लबै क्ल्ह्‍योर शत्तुरमैंए उँइँर राल् त्हुमा च फापिल् त्हुरिब् आरे। ");
INSERT INTO gvr_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","कैंडो क्रेबै त्हेर्बै क्वे याहवेहलाइ मान लब्मैं नेरो खीए घ्याँर प्रब्मैं ताँनइ आशिक योंम्! ");
INSERT INTO gvr_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","क्हिइ ह्रोंसइन के लसि चब्मुँ; क्हिए फिर आशिक युब्मुँ धै छ्याँब तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","क्हिए प्ह्रेंस्यो क्हिए धिंर बेल्‍ले रोबै अँगुरए धुँ धों तब्मुँ; क्हिए प्हसेमैं क्हिए टेबलए खागु जैतुनए त्होर धोंन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","याहवेहलाइ मान लबै म्हिइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","याहवेहजी सियोनउँइँले क्हिए फिर आशिक पिंरिगे! क्हिइ ह्रोंसए छ्ह तिगोंन् यरूशलेमर छ्याँब तब म्रोंरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","क्हिइ क्वें-क्वेंमिमै म्रोंल् योंरिगे! इस्राएलए फिर शान्ति तरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","कैंडो क्रेबै त्हेर्बै क्वे “ङ कोलो मुँब् ओंनोन् चमैंइ ङए फिर ल्हें खे दुःख पिंइमुँ!” ");
INSERT INTO gvr_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“ङ कोलो मुँब् ओंनोन् चमैंइ ङए फिर ल्हें खे दुःख पिंइमुँ। दिलेया चमैंइ ङलाइ ट्होल् आखाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","क्ल्याछैंमैंइ ङए क्होर क्ल्योइ; चमैंइ खेंमैंए क्होरए फलिइ ङए क्हो तिगोंन् क्ल्योइ। ");
INSERT INTO gvr_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","दिलेया याहवेहजी ठिक निसाफ लमुँ; छतसि खीजी दुष्‍टमैंए योउँइँले ङ फ्रेमिंइमुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","सियोन म्रोंसि छेरब्मैं ताँन् फापिल् त्हुरिगे धै लिग्याँइ स्योयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","धिं फिर्बै छि धोंन् चमैं तब्मुँ! फारब् भन्दा ओंसोंन् च ङ्योंलोंयाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","छि खैंमा च मुठ्ठि घ्रि या तल् आखाँ, धै प्हैं फैमा च आङ्लो घ्रि या तल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","“याहवेहए आशिक क्हिए फिर तरिगे! याहवेहए मिंर ङिइ क्हिलाइ आशिक पिंम्!” बिसि च घ्याँ तसि ह्‍याब्मैंइ आबि। ");
INSERT INTO gvr_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","कैंडो क्रेबै त्हेर्बै क्वे ओ याहवेह, गैरु क्ल्ह्‍योउँइँले ङइ क्हिने ग्वार ह्रिइमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","ओ याहवेह, ङइ ग्वार ह्रिब थेमिंन्! ल्हयो खमिंन् बिसि ङइ ग्वार ह्रिब क्हिए न्हइ थेमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","ओ याहवेह, म्हिमैंइ लबै पापए हिसाब क्हिजी थेंइ बिस्याँ, ओ प्रभु, क्हिए उँइँर खाब् राल् खामुँ? ");
INSERT INTO gvr_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","दिलेया क्हिजी क्षमा पिंम्, छतसि ङइ क्हिलाइ मान लम्। ");
INSERT INTO gvr_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","ङ याहवेहए घ्याँ ङ्ह्‍योरिम्, ङए सोइ खीलाइ प्रेंरिम्, धै खीए बचनर ङइ आशा थेंम्; ");
INSERT INTO gvr_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","न्हाँग खोंयों तब् ङ्‍हे बिसि पालेइ न्हाँग ह्रेब् भन्दा ल्हें ङए सोइ याहवेहए घ्याँ ङ्ह्‍योरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","ओ इस्राएल, याहवेहए फिर आशा थेंन्! तलेबिस्याँ याहवेजी खोंयोंन् बिलै म्याँया लरिम्, धै तोंन्दोरि आछ्याँबै सैउँइँले खीजीन् जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","इस्राएलइ लबै ताँन् पापउँइँले खीजी फ्रेमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","कैंडो क्रेबै त्हेए ल्हागिर दाऊदइ प्ह्रिबै क्वे घ्रि ओ याहवेह, ङए सैं थेब आप्हैं, ङ थेब् तदा आङ्हाँ; ह्रोंसइ आक्होबै सैमैं नेरो ह्रोंसइ लल् आखाँबै सैमैंर ङ क्होसि आटि। ");
INSERT INTO gvr_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","दिलेया आमाने टिल् योंमा कोलो च्याँ तब् धोंले छले ङइ ङए खों दरो नेरो ढुक्‍का लइमुँ। आमाए ङ्‍हे थुँब् पिबै कोलो धोंले ङए खों छिं तइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","ओ इस्राएल, तोगोउँइँले खोंयोंन् बिलै याहवेहए फिर आशा थेंन्। ");
INSERT INTO gvr_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","कैंडो क्रेबै त्हेर्बै क्वे ओ याहवेह, दाऊदलाइ मैंमिंन्, चइ योंबै ताँन् दुःखमैं मैंमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","चइ याहवेहए मिंर कसम चइमुँ; धै तोन्दोंरि सै लल् खाँबै याकूबइ म्हाँदिबै परमेश्‍वरए मिंर भकल लइ: ");
INSERT INTO gvr_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","3","“याहवेहए ल्हागिर क्‍ल्‍ह्‍यो घ्रि तौदु लल् आखाँन् समा, याकूबइ म्हाँदिबै तोन्दोंरि सै लल् खाँबै परमेश्‍वरए ल्हागिर टिबै क्‍ल्‍ह्‍यो घ्रि ङइ आयोंन् समा, ");
INSERT INTO gvr_vpl VALUES ("PS132_4","020_132_4","PSA","132","4","4","ङ ह्रोंसए धिं न्होंर होंरिब् आरे, ह्रोंसए खाडरै या क्रेरिब् आरे, ");
INSERT INTO gvr_vpl VALUES ("PS132_5","020_132_5","PSA","132","5","5","ङए मिर न्हरु या खल् पिंरिब् आरे, धै ङए मि तिस्याँ या च्युँ लल् पिंरिब् आरे।” ");
INSERT INTO gvr_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","बाछा प्ह्रिथेंबै बाकसए बारेर ङिइ एप्राता बिबै नाँसर थेल; याआरर्बै चेप्ला तबै क्ल्ह्‍योर ङिइ च बाकस स्याइ। ");
INSERT INTO gvr_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","“खी टिबै क्‍ल्‍ह्‍योर ङ्यो ह्‍याले; खीए प्हले म्हैबै क्ल्‍ह्‍योर ह्‍यासि खीए मिं क्वेले!” ");
INSERT INTO gvr_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","ओ याहवेह रेत्ति, क्हिए शक्तिए बाकस बालु क्हिए भों न्हबै क्‍ल्‍ह्‍योर युमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","क्वें खिब् धोंले क्हिए खेगिमैंइ खोंयोंन् बिलै ठिक के लरिगे, धै क्हिए म्हिमैं सैं तोंदै क्हिए जयजय लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","क्हिजी ह्रोंसए के लबै म्हि दाऊदने फैबै बाछा मैंसि क्हिजी त्हाँबै म्रुँउँइँले क्हिए लि आलोमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","याहवेहजी दाऊदने बाछा घ्रि फैइमुँ; चु बाछाउँइँले खी स्योयारिब् आरे: “क्हिए च्हमैंए न्होंर्बै घ्रिलाइ ङइ क्हिए राजगद्दिर थेंमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","क्हिए च्हमैंइ ङइ फैबै बाछा नेरो ङइ चमैंने लोमिंबै ताँमैं ङिंइ बिस्याँ, चमैंए च्हमैं या खोंयोंन् बिलै क्हिए राजगद्दिर टिब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","याहवेहजी सियोनलाइ त्हाँइमुँ; खीजी चलाइ ह्रोंस टिबै क्‍ल्‍ह्‍यो बनेदा ङ्हाँइमुँ: ");
INSERT INTO gvr_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“खोंयोंन् बिलै ङए भों न्हबै क्‍ल्‍ह्‍यो चु ग; चु राजगद्दिर ङ टिब्मुँ, तलेबिस्याँ चुर्न ङ टिदा ङ्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","चु सहरलाइ चैदिबै तोन्दोंरि सैर ङइ आशिक पिंब्मुँ; चर्बै ङ्हाँदुमैंलाइ ङइ क्हेंइ म्रेंल् पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","चर्बै खेगिमैंलाइ ङइ मुक्ति पिंब्मुँ, धै चर्बै ङए म्हिमैं सैं तोंदै कै तेसि ओरब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","दाऊदए ल्हागिर चर ङइ थेबै म्रुँ घ्रि बनेब्मुँ; ङइ त्हाँबै म्रुँए ल्हागिर बत्ति घ्रि तयार लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","चए शत्तुरमैंलाइ ङइ फापिल् लवाब्मुँ, दिलेया चए क्रर मुकुट चारब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","कैंडो क्रेबै त्हेए ल्हागिर दाऊदइ प्ह्रिबै क्वे घ्रि थेद्, आघें-अलिमैं क्ह्रिसि टिब बेल्‍ले छ्याँबै सैं तोंबै ताँ ग! ");
INSERT INTO gvr_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","सै ल्हें फेबै छ्युगु हारूनए क्रर युमिंब् धोंब चु तम्। च छ्युगु हारूनए दाह्रि समा युम्, चए क्वेंए ङाँ समा फेनेम्। ");
INSERT INTO gvr_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","हेर्मोन बिबै कोंर्बै शीत धोंन् च छ्याँब तम्! च शीत सियोनर्बै कोंमैंर युम्। चर्न खोंयोंइ आखाँबै छ्ह योंबै आशिक युरिगे बिसि याहवेहजी बिइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","कैंडो क्रेबै त्हेर्बै क्वे ओ याहवेहए सेवा लब्मैं, म्हुँइँसर याहवेहए धिंर राब्मैं, याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","पबित्र क्ल्ह्‍योर ह्रोंसए यो क्वेसि याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","स्वर्ग नेरो पृथ्बी बनेबै याहवेहजी सियोनउँइँले क्हिए फिर आशिक पिंरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","याहवेहए मिं क्वेद्! याहवेहए मिं थेब् लद्, ओ याहवेहए सेवा लब्मैं खीए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","याहवेहए धिंर ङ्योए परमेश्‍वरए धिंर्बै ह्‍युमैंर राब्मैं खीए मिं क्वेद्। ");
INSERT INTO gvr_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","याहवेह बेल्‍ले स्वाब मुँ, छतसि खीए मिं थेब लद्; खीजी म्हिमैंए फिर ल्हयो खम्, छतसि खीए मिंर क्वे प्रिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","तलेबिस्याँ याहवेहजी याकूबलाइ ह्रोंसल् लबर, धै इस्राएलीमैंलाइ ह्रोंसए म्हिमैं तबर त्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","याहवेह बेल्‍ले थेब मुँ, छतसि ङ्योए प्रभु ताँन् देवतामैं भन्दा थेब मुँ बिसि ङइ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","स्वर्गर, पृथ्बीर, नेरो मा ङ्युँइमैंए गैरु क्ल्ह्‍योमैंरै या, याहवेहजी ह्रोंसए सैंर मैंब् धोंले लम्। ");
INSERT INTO gvr_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","खीजी पृथ्बीए च्होउँइँले न्हाँम्स्यो रेमिंम्, खीजी नाँने बालु काम्‍लि-तिम्‍लि कुल्मिंम् धै खीए भण्डरउँइँले खैं तेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","स्योंम खीजी मिश्रीमैंए ओंसों फिबै च्हमैं, नेरो ओंसों फिबै खेदोमैं सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","ओ मिश्र ह्‍युल, क्हिए ह्‍युलए म्हाँजोर्न फारो नेरो चए ताँन् के लब्मैंए उँइँर खीजी औदिबै चिनु नेरो प्लेटोयाबै केमैं लइ। ");
INSERT INTO gvr_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","खीजी ल्हें ह्रें-ह्रेंमैं सैवाइ, भों-भोंबै म्रुँमैं या सैवाइ: ");
INSERT INTO gvr_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","एमोरीमैंए म्रुँ सिहोन, नेरो बाशानर्बै म्रुँ ओगलाज्यै या सैवाइ, धै कनान ह्‍युलर्बै ताँन् ग्याल्समैं खीजी नास लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","झाइले चमैंए क्‍ल्‍ह्‍यो-न्हेए फिर खीए म्हिमैं इस्राएलीमैंलाइ क्ल्हे तल् पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","ओ याहवेह, क्हिए मिं खोंयोंन् बिलै तरिम्, ओ याहवेह, पुस्ता-पुस्ता समा म्हिमैंइ क्हि मैंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","तलेबिस्याँ याहवेहजी ह्रोंसए म्हिमैंए ठिक निसाफ लब्मुँ, धै ह्रोंसए सेवा लब्मैंए फिर ल्हयो खब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","अरू ह्रेंमैंए कुमैं मारा नेरो चाँदिउँइँले म्हिमैंए योइन बनेब् ग। ");
INSERT INTO gvr_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","चमैंल सुँ मुँ, दिलेया पोंल् आखाँ; मि मुँ, दिलेया म्रोंल् आखाँ; ");
INSERT INTO gvr_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","न्ह मुँ, दिलेया थेल् आखाँ, चमैंइ सो आसें। ");
INSERT INTO gvr_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","छाबै सैमैं बनेब्मैं या छाबन् तब्मुँ, धै कुमैंए फिर भर थेंब्मैं या कुमैं धोंन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","ओ इस्राएलए सन्तानमैं, याहवेहए मिं थेब् लद्! ओ हारूनए सन्तानमैं, याहवेहए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","ओ लेबीए सन्तानमैं, याहवेहए मिं थेब् लद्! ओ याहवेहलाइ मान लब्मैं, याहवेहए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","सियोनर टिब्मैं याहवेहए मिं थेब् लद्, यरूशलेमर टिबै याहवेहए मिं थेब् लद्। याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","याहबेहलाइ धन्यबाद पिंन्, तलेबिस्याँ खी स्वाब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","देवतामैं भन्दा थेबै परमेश्‍वरलाइ धन्यबाद पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","प्रभुमैंए प्रभुलाइ धन्यबाद पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","खीजी मत्‍त्रे औदिबै थेब-थेबै केमैं लम्। ");
INSERT INTO gvr_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","खीजी ह्रोंसए ज्ञान बुद्धिइ स्वर्ग बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","खीजी क्युए फिर पृथ्बी थेंइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","खीजी त्हिंयाँ नेरो लयाँ बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","त्हिंइए फिर क्ल्हे लबर खीजी त्हिंयाँ बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","म्हुँइँसए फिर क्ल्‍हे लबर लयाँ नेरो मुसारा बनेइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","खीजी मिश्र ह्‍युलर्बै च्ह थेब ताँन् सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","खीजी इस्राएलीमैंलाइ मिश्र ह्‍युलउँइँले तेसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","खीए भोंबै यो नेरो पाखरइ चमैं तेसि पखइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","खीजी ओल्ग्या मा ङ्युँइ ङ्हिबाँ लवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","खीजी इस्राएलीमैंलाइ चए म्हाँजोउँइँले डोरेपइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","मिश्रर्बै म्रुँ फारो नरो चए सेनालाइ खीजी ओल्ग्या मा ङ्युँइर भ्योंवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","खीजी ह्रोंसए म्हिमैंलाइ क्यु आयोंबै क्‍ल्‍ह्‍योउँइँले डोरेपइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","खीजी थे-थेबै म्रुँमैं सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","कालिदिबै म्रुँमैं या खीजी सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","एमोरीमैंए म्रुँ सिहोनलाइ खीजी सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","बाशानर्बै म्रुँ ओगलाज्यै या खीजी सैवाइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","खीजी चमैंए ह्‍युल ह्रोंसए म्हिमैंलाइ क्ल्हे तल् पिंइ, ");
INSERT INTO gvr_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","खीजी ह्रोंसए के लबै इस्राएलीमैंलाइ च ह्‍युल पिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","ङि हार्दियामैं या खीजी ङिलाइ आम्‍ले। ");
INSERT INTO gvr_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","ङिए शत्तुरमैंउँइँले खीजी फ्रेमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","सो प्ह्‍याबै तोन्दोंरि सैलाइ खीजी चबै सै पिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","स्वगर्बै परमेश्‍वरलाइ धन्यबाद पिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","बेबिलोनर्बै स्योंमैंए रेर टिमा सियोनलाइ मैंसि ङ्यो क्रोइ। ");
INSERT INTO gvr_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","चर्बै बैंस बिबै सिधुँमैंर ङ्योइ ह्रोंसए बीणामैं च्योइ। ");
INSERT INTO gvr_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","तलेबिस्याँ ङ्योलाइ च्युबर बोब्मैंइ चर ङ्योने क्वे प्रिंबर ल्हैदिइ, धै “ङिए सैं तोंबै ल्हागिर सियोनए क्वेंमैं प्रिंन्!” बिसि ङ्योए फिर दुःख पिंब्मैंइ ङ्योने बिइ। ");
INSERT INTO gvr_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","आगुए ह्‍युलर ङ्योइ याहवेहए क्वे खैले प्रिंब? ");
INSERT INTO gvr_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","ओ यरूशलेम, ङइ क्हिलाइ म्‍लेयाइ बिस्याँ ङए क्योलो योइ ह्रोंसए सिपमैं म्‍लेयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","ङइ क्हिलाइ आमैंस्याँ, ङए ताँन् भन्दा सैं तोंबै सै यरूशलेम ग! बिसि ङइ आबिस्याँ, ङए ले तालुर ह्रेंयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","ओ याहवेह, यरूशलेम नास तबै त्हिंइर एदोमिमैंइ खैबै के लल मैंन्दि, “चु फुवाद्, चुए तें समन् फुवाद्!” बिसि चमैं चिरल। ");
INSERT INTO gvr_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","ओ बेबिलोनए च्हमि, क्हि नास लवाब्मुँ। ङिए फिर क्हिइ खै लल, छाबन् खि किंबै म्हिइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","क्हिए च्युगुथिरि कोलोमैंलाइ क्हासि युँमार प्योवाबै म्हिइ आशिक योंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","दाऊदए भजन घ्रि ओ याहवेह, ङए सैं न्होंउँइँले क्हिलाइ धन्याबाद पिंम्, देवतामैंए ओंसों ङ क्हिलाइन थेब लम्। ");
INSERT INTO gvr_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","क्हिजी ह्रोंसए मिं नेरो क्हिए बाछामैं तोन्दोंरि सैमैंए फिर बेल्‍ले थेब लइमुँ। छतसि क्हिए पबित्र क्ल्ह्‍योउँइँ ङ तोसि क्हिलाइन फ्योब्मुँ, धै क्हि खोंयोंइ आनुबै म्हाँया लब नेरो ङइ भर लल् खाँबै परमेश्‍वर ग बिसि ङ क्हिए मिं थेब लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","ङइ ग्वार ह्रिमा क्हिजी ङलाइ ज्वाफ पिंइ, धै क्हिजी ङ आङ्हिंब नेरो भोंब लमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","ओ याहवेह, क्हिए सुँउँइँले त्होंबै ताँ थेमा ताँन् ह्‍युलर्बै म्रुँमैंइ क्हिन थेब् लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","चमैंइ याहवेहजी लबै केमैंए बारेर क्वे प्रिंरिगे, तलेबिस्याँ याहवेहए मिं बेल्‍ले थेब मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","याहवेह बेल्‍ले थेब मुँलेन थेब् आप्हैंब्मैंलाइ खीजी ङ्ह्‍योम्, दिलेया थेब् प्हैंब्मैं बिस्याँ खीजी ह्रेंगोउँइँलेन् ङो सेम्। ");
INSERT INTO gvr_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","ङइ ल्हें दुःख योंलै या क्हिजी ङ जोगेमिंम्। ङए शत्तुरमैं ह्रिस खसि ङने छैखमा क्हिजी यो स्योंम्, झाइले ह्रोंसए क्योलो योजी ङ जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","याहवेहजी ङए ल्हागिर लबै चाँजोमैं पूरा लमिंब्मुँ। ओ याहवेह, ङिए फिर क्हिए म्हाँया खोंयोंन् बिलै तरिब्मुँ। क्हिए योजी लबै केमैं आवामिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","क्वे प्रिंब्मैंए चिबए ल्हागिर दाऊदए भजन घ्रि। ओ याहवेह, क्हिजी छेनाले ङए जाँच लइमुँ, धै ङ खैब मुँ बिसि क्हिजी सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","ङ टिब नेरो राब क्हिजी सेइमुँ, ङए सैंर मैंबै ताँ क्हिजी ह्रेंगोउँइँलेन् क्होमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","ङ बैरु ह्‍यालेया धिंर रोलेया ङलाइ तो तइमुँ बिसि क्हिजी छेनाले सेम्, धै ङइ तो लइमुँ बिब क्हिजी ताँन् सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","ओ याहवेह, ङए सुँइ तोइ ताँ पोंब् भन्दा ओंसोंन् ङइ तो बिल् म्हैइमुँ बिब क्हिजी छेनाले सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","ङए लिलि ओंसों कारग्युले क्हि मुँ, धै रक्षा लबर क्हिजी ह्रोंसए यो ङए फिर थेंमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","क्हिए छाबै ज्ञान म्रोंसि ङ प्लेटोयाइमुँ, क्हिए ज्ञान क्होबर ङए ल्हागिर बेल्‍ले गारो मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","क्हिए प्ल्हउँइँले ङ खनिरै ह्‍याल् आखाँ! धै क्हिउँइँले ङ खनिरै भौदिल् आखाँ! ");
INSERT INTO gvr_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","ङ स्वर्गर ह्‍यालेन क्हि चर्न तमुँ! क्रोंर रोलेया क्हि चर्न तमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","त्हिंयाँ खबै क्ल्ह्‍योउँइँलेन् त्हिंयाँ लिबै क्ल्ह्‍यो समा प्हुरसि ह्‍यालेया ");
INSERT INTO gvr_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","चरै या क्हिए योजी ङ डोरेमिंब्मुँ, धै क्हिए क्योलो योजी ङ क्हाथेंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","“मिछु खैबइ ङ हुवाब्मुँ, धै ङए कारग्यु चारबै ह्‍वे या मिछु तयाब्मुँ,” बिसि ङइ बिलेया ");
INSERT INTO gvr_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","च मिछु खैब क्हिए ल्हागिर म्हुँइँस छु तरिब् आरे। मिछु खैब क्हिए ल्हागिर चारबै ह्‍वे धोंबन् ग। छतसि त्हिंयाँर्बै मि म्रोंब् धोंले म्हुँइँस चारब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","क्हिजीन् ङए न्होंर्बै भागमैं बनेइ, क्हिजी आमाए फो न्होंर ङ केमिंइ। ");
INSERT INTO gvr_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","ङ औदिले छेन्ले बनेइमुँ, छतसि ङ क्हिए मिं थेब् लमुँ। क्हिए केमैं औदिबै मुँ बिब ङइ छेनाले सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","आमाए फोर ङए ह्रिबमैं बनेसिन् मुँमा ङ खैले बनेब बिसि क्हिजी सेल् खाँल। झाइले ङ पृथ्बीए गैरुर बनेदै मुँमा, ");
INSERT INTO gvr_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","क्हिजी ङए आबनेबै ज्यु म्रोंइ। ङ कति सोल् योंम् बिसि ङ फिब् भन्दा ओंसोंन् क्हिए कितबर प्ह्रिथेंल। ");
INSERT INTO gvr_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","ओ परमेश्‍वर, ङए ल्हागिर क्हिए बिचारमैं सै ल्हें फेबै सैमैं भन्दा थेब मुँ! चमैं च्योसे च्योल् आखाँब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","चमैं ङइ च्योल् त्हुस्याँ, च बालुवाए त्हुल् भन्दा ल्हें तमल। ङ छोरमा ङ क्हिने बालुन् तमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","ओ परमेश्‍वर, क्हिजी दुष्‍टमैं नास लवास्याँ कति छ्याँब तमल! ओ म्हि सैमैं, ङ ङाँइँले ह्रेंगो त‍याद्! ");
INSERT INTO gvr_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","च शत्‍तुरमैंइ क्हिए बिरोधर आछ्याँबै ताँ पोंम्, चमैंइ क्हिए मिं फाकर्न किंम्। ");
INSERT INTO gvr_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","ओ याहवेह, क्हिलाइ आखोब्मैं ङइ कत्ति आखो! छलेन क्हिए बिरोधर रेब्मैंलाइ ङइ आछ्याँबै मिइ ङ्ह्‍योम्! ");
INSERT INTO gvr_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","छाबै म्हिमैंलाइ ङ तिफुँइ आखो; ङइ चमैंलाइ शत्तुरमैं धोंन् ङ्हाँइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","ओ परमेश्‍वर, ङ जाँचेदु, धै ङए खोंर्बै ताँमैं सेदु! ङ जाँचेदु, धै ङए न्हुँ कति ल्हें मुँ बिसि क्होमिंनु! ");
INSERT INTO gvr_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","आछ्याँबै घ्याँर प्रइमुँ उ बिसि ङ जाँचेदु, धै खोंयोंइ आखाँबै छ्ह योंबै घ्याँर ङ डोरेमिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","क्वे प्रिंबै चिबए ल्हागिर दाऊदए भजन घ्रि। ओ याहवेह, दुष्‍टमैंउँइँले ङ फ्रेमिंनु। म्हिसैमैंउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","चमैंइ ह्रोंसए खोंर आछ्याँबै चाँजोमैं लम्, धै त्हिंइ ह्रोंसे नेबै के लम्। ");
INSERT INTO gvr_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","प्हुरिइ च्हिब् धोंले चमैंए लेइ नल् लम्, चमैंए सुँर प्हुरिए म्येकैं ल्हें तम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","ओ याहवेह, दुष्‍टमैंए योउँइँले ङ जोगेमिंन्, म्हिसैमैंउँइँले ङ रक्षा लमिंन्, ङए प्हले थुरवाबै चाँजो चमैंइ लइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","थेब् प्हैंबै म्हिमैंइ ङए ल्हागिर ङो चुइमुँ, चमैंइ ह्रोंसए जालए छो च्योइमुँ, धै ङ प्रबै घ्याँर ङो चुइमुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","ओ याहवेह, ङ क्हिने बिमुँ, “क्हि ङए परमेश्‍वर ग!” ओ याहवेह, ङइ ग्वार ह्रिब थेमिंनु! ");
INSERT INTO gvr_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","ओ याहवेह, ङलाइ जोगेमिंबै शक्ति मुँबै परमेश्‍वर, ल्हडें तबै त्हिंइर क्हिजी ङए क्र जोगेमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","ओ याहवेह, दुष्‍टमैंए सैंर मैंब योल् आपिंनु, चमैंइ लबै चाँजोमैं फुवाद्, आस्याँ चमैं थेब् प्हैंब्मुँ। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","ङलाइ घेर्दिब्मैंए क्रए फिर चमैंए सुँइ पोंबै आछ्याँबै ताँइन हुवारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","लुँरिबै मिए राब चमैंए फिर उँयारिगे! बेल्‍ले लुँरिबै मिर चमैं भ्योंवारिगे, धै रेलै आखाँन्ले चमैं हिल् मुँबै होल्दोंर तेयारिगे! ");
INSERT INTO gvr_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","आगुलाइ स्यारब्मैं चु ह्‍युलर टिल् आयोंरिगे, म्हिसैमैं युनन् नास तबर फेरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","आगुइ क्र ओलै आपिंब्मैंए ख लसि याहवेहजी मुद्दा नेमिंम्, धै ङ्हाँदुमैंए ठिक निसाफ लमिंब्मुँ बिसि ङ सेइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","क्ह्रोंसेन ठिक के लब्मैंइ क्हिए मिंलाइ थेब लब्मुँ, झाइले सोजो म्हिमैं क्हिए उँइँर टिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","दाऊदए भजन घ्रि। ओ याहवेह, ङइ क्हिलाइ हुइमा क्हि युनन् युमिंन्। ङइ क्हिलाइ हुइमा ङए कै थेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","ङइ लबै प्राथना क्हिए उँइँर लिंबै थाँ खबै धुप धोंब तरिगे, ङइ ह्रोंसए यो क्वेमा ङेसर पिंबै ख्रो धोंन् तरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","ओ याहवेह, ङए सुँइ आछ्याँबै ताँ पोंल् आपिंन्, ङए म्हदिइ आछ्याँबै ताँ पोंल् आपिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","दुष्‍ट के लब्मैंने बालु आछ्याँबै के लबर ङए सैं ह्‍याल् आपिंन्, धै चमैंए लिं-लिंबै चबै सैमैं ङइ चल् आत्हुरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","ठिक के लबै म्हिइ ङलाइ धोंरिगे, छ लमा ङए ल्हागिर म्हाँया लब् धोंन् तब्मुँ, चइ ङ हौदिरिगे, छले हौदिमा ङए क्रए ल्हागिर छ्युगु तब्मुँ। ङए क्रइ च छ्युगु स्योवारिब् आरे। दिलेया आछ्याँबै के लब्मैंए बिरोधर ङइ खोंयोंइ बिलै प्राथना लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","चमैंए क्रथे मिंथेमैं कोंउँइँले क्युरु भ्योंवामा ङइ पोंबै ताँ क्ह्रोंसेंन ग बिसि दुष्‍टमैंइ क्होब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","चमैंइ बिब्मुँ, “खैले क्होर क्ल्योब्मैंइ म्रों क्ल्योसि डल्‍ल तिवामुँ, छलेन ङ्योए ह्रिबमैं क्रोंए सुँर सग्याँ-प्हुँग्या तब्मुँ।” ");
INSERT INTO gvr_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","ओ याहवेह ङए प्रभु, ङए मि क्हि ङाँइन ङ्‍ह्‍योरिमुँ, क्हिए प्हलेर्न ङ ग्वार ह्रिबर खइमुँ! ङलाइ कालए सुँर आभ्योंमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","दुष्‍टमैंइ ङए ल्हागिर तोबै ङो, नेरो आछ्याँबै के लब्मैंइ तोबै ङोउँइँले ङ जोगेमिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","दुष्‍टमैं खेंमैंइ तोबै ङोर फेयारिगे, ङ बिस्याँ तोइ आतनले स्योरइ खरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","उर मुँमा दाऊदइ चु मस्किल प्राथना लइ। ओरदै ङ याहवेहने ग्वार ह्रिमुँ, ङए फिर ल्हयो खमिंन् बिसि थेबै कै तेदै ङइ याहवेहने यो छ्युँ लम्। ");
INSERT INTO gvr_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","ङइ ह्रोंसए ताँमैं खीए उँइँर थेंमुँ, खीने बालुन् ङइ ह्रोंसए दुःख ङेमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","ङए सैं च्योंब् तमा ङइ तो लल् त्हुम् बिब क्हिजी सेम्! ङ प्रबै घ्याँर म्हिमैंइ ङए ल्हागिर ङो चुइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","ङए क्योलोउँइँ ङ्ह्‍योमिंनु, ङए न्हुँ लब खाबै या आरे, ङ ग्वार योंबै क्‍ल्‍ह्‍यो खनिरै आरे। खाबज्यै या ङए वास्ता आल। ");
INSERT INTO gvr_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","ओ याहवेह, ङ क्हिनेन् ग्वार ह्रिमुँ; “क्हि ङए ग्वार योंबै क्‍ल्‍ह्‍यो, नेरो सोगोंमैंए ह्‍युलर ङ‍ए चैदिबै सै क्हिन् ग!” बिसि ङइ बिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","ङइ ग्वार ह्रिब थेमिंनु, तलेबिस्याँ ङ थेबै दुःखर फेइमुँ! ङलाइ ल्हाब्मैंउँइँले जोगेमिंनु, तलेबिस्याँ चमैं ङ भन्दा बेल्‍ले भोंब मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","ङइ क्हिए मिं थेब् लल् खाँरिगे बिसि झेलर च्युब् धों तबै दुःखउँइँले ङ फ्रेमिंनु! छले क्हिजी ङए फिर छ्याँब् लब् म्रोंसि ठिक के लब्मैं ङए कारर्ग्युले खागु तखब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","दाऊदए भजन घ्रि। ओ याहवेह, ङए प्राथना थेमिंनु, ल्होमिंन् बिसि ङइ ग्वार ह्रिब थेमिंनु! क्हि भर लल् खाँब नेरो ठिक के लबै परमेश्‍वर ग, छतसि ङलाइ जवाफ पिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","ह्रोंसए केब्छैंए बिरोधर निसाफ आलमिंनु, तलेबिस्याँ क्हिए उँइँर सोगों म्हिमैं खाबै या ठिक ठर्दिल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","ङलाइ सैब् बिसि शत्तुरइ ल्हामुँ, चइ ङलाइ सर क्हुरवासि प्लेवामुँ। ओंसोंन् सियाब्मैंलाइ धोंले चइ ङ मिछु खैबर टिलन् त्हुम् बिसि ल्हैदिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","छतसि ङए सैं खैता-खैता तइमुँ, धै ङए सैं बेल्‍ले च्योंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","ह्‍याबै त्हिंइमैं ङइ मैंमुँ, धै क्हिजी ताँन् केमैं खैले लगे बिसि ङए सैंर मैंरिमुँ; धै क्हिए योइ औदिबै केमैं खैले लगे बिसि ङ मैंरिमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","ङए यो क्हि ङाँइन स्योंमुँ, कारयाबै क्‍ल्‍ह्‍योइ क्यु ल्हें ङाब् धोंले ङए सोइ क्हिलाइन म्हैरिम्। तिस्याँदे मैंन् ");
INSERT INTO gvr_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","ओ याहवेह, ङइ ग्वार ह्रिब युनन् थेमिंन्, ङए सैं खैता-खैता तइमुँ! ङने बालु क्हिए लि आलोमिंनु, आस्याँ ङ क्रोंर फेनेब्मैं धोंन् तब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","न्हाँग छजँ क्हिए खोंयोंइ आनुबै म्हाँयाए बारेर थेरिगे; तलेबिस्याँ क्हिए फिर्न ङइ भर थेंइमुँ। ङ प्रल् त्हुबै घ्याँ ङलाइ लोमिंनु, तलेबिस्याँ ङए सो ङ क्हि ङाँइन क्वेमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","ओ याहवेह, ङए शत्तुरमैंउँइँले ङ जोगेमिंनु! तलेबिस्याँ क्हिए प्हलेर्न ङ ग्वार योंबर खइमुँ! ");
INSERT INTO gvr_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","क्हिए सैंर मैंब पूरा लबै ल्हागिर ङलाइ लोमिंनु, तलेबिस्याँ क्हि ङए परमेश्‍वर ग! क्हिए खों बेल्‍ले छ्याँब मुँ, छतसि ङलाइ छ्याँबै घ्याँर डोरेमिंनु! ");
INSERT INTO gvr_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","ओ याहवेह, ङइ क्हिए मिं थेब लरिगे बिसि ङए सो जोगेमिंनु! क्हिजी खोंयोंइ ठिक के लमुँ, छतसि ङए दुःखउँइँले फ्रेमिंनु! ");
INSERT INTO gvr_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","ङए फिर क्हिए म्हाँया खोंयोंइ आनुल्‍ले मुँ, छतसि ङए शत्तुरमैं सैवाद्, धै ङए फिर दु:ख पिंब्मैं ताँनलाइ नास लवाद्, तलेबिस्याँ ङ क्हिए केब्छैं ग। ");
INSERT INTO gvr_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","दाऊदए भजन। याहवेह ङ रक्षा लमिंबै पारा ग, छतसि ङ खीए मिं थेब् लब्मुँ। ङए योमैं नेबर, नेरो ङए योरिंमैं ल्हडें लबर खीजी लोमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","खी ङए फिर खोंयोंइ आनुबै म्हाँया लबै परमेश्‍वर नेरो ङए किल्‍ला ग, ङलाइ खाबज्यै तोइ लल् आपिंब ङलाइ जोगेब परमेश्‍वर ग, खी ङए ढाल ग, खीए प्हलेर्न ङ ग्वार योंमुँ। खीजी अरू ह्रेंमैंलाइ ङए न्होंर थेंमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","ओ याहवेह, म्हि तो जा? क्हिजी तले चए वास्ता लब? म्हिए च्ह तो जा? क्हिजी तले चए न्हुँ लब? ");
INSERT INTO gvr_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","तलेबिस्याँ म्हिम् मुठि घ्रि सो धोंबन् ग, चए छ्ह छरि धोंले ह्‍यायाम्। ");
INSERT INTO gvr_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","ओ याहवेह, ह्रोंसए मु थोंसि क्युरु युमिंनु! कोंमैंउँइँले मिखु त्होंखरिगे बिसि छुइमिंन्! ");
INSERT INTO gvr_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","काम्‍लि-तिम्‍लि चारमिंसि ङए शत्तुरमैं खन्तोदोंन् प्हुँवाँन्! क्हिए मे त्हलेमैं ल्हिसि चमैं सग्या-प्हुग्या लवाद्! ");
INSERT INTO gvr_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","नुबै क्‍ल्‍ह्‍योउँइँले ह्रोंसए यो स्योमिंनु, प्ल्होंखबै बाडि नेरो आगुए ह्‍युलर्बै म्हिमैंए योउँइँले ङ जोगेमिंसि फ्रेमिंनु। ");
INSERT INTO gvr_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","चमैंए सुँइ स्योर ताँमैं पोंमुँ, धै चमैंइ कसम चलेया स्योलिबै ताँ पोंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","ओ परमेश्‍वर, क्हिए ल्हागिर ङ छारा क्वे घ्रि प्रिंब्मुँ; तार च्यु प्ह्‍याबै सारङ्गी ह्रासि ङ क्हिए मिंर क्वे प्रिंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","क्हिजी म्रुँमैंलाइ ट्होल् पिंमुँ, क्हिजी ह्रोंसए के लबै दाऊदलाइ न्होह्रों लबै सेलाउँइँले जोगेमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","ङलाइ आगुए ह्‍युलर्बै म्हिमैंए योउँइँले जोगेमिंसि फ्रेमिंनु। चमैंए सुँइ स्योर ताँमैं पोंमुँ, धै चमैंइ कसम चलेया स्योलिबै ताँ पोंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","झाइले फ्रेंसि तबै त्हेर ङ्योए च्हमैं सपर्दिबै सिंधुँमैं धोंन् तरिगे, धै ङ्योए च्हमिमैं दरबार सिंगार्दिबर कुन्दिबै त्होमैं धोंब तरिगे; ");
INSERT INTO gvr_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","ङ्योए धनसारमैंर ल्हें खालर्बै रोमैंइ प्लिंरिगे, ङ्योए क्युमैं हजार गुणा बडिरिगे, ङ्योए म्रोंजरे लाखै लाख क्यु तरिगे; ");
INSERT INTO gvr_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","ङ्योए क्ल्यामैंइ ल्हिबै ति नोरिगे, ङ्योए सहरए गारमैं आफुरिगे, धै ङ्यो झेलर ह्‍याल् आत्हुरिगे, ङ्योए घ्याँजरे क्रोबै कै आथेरिगे! ");
INSERT INTO gvr_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","चु आशिकमैं योंबै म्हि ङ्हो सब् ग! याहवेहलाइ परमेश्‍वर बिसि म्हाँदिब्मैं ङ्हो सब् ग! ");
INSERT INTO gvr_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","याहवेहए मिं थेब् लदै प्रिंबै दाऊदए क्वे घ्रि। ओ ङए परमेश्‍वर, ङए म्रुँ, ङ क्हिए मिं थेब् लब्मुँ, ङ खोंयोंन् बिलै क्हिलाइ धन्यबाद पिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","त्हिंइ ह्रोंसे ङ क्हिलाइ धन्यबाद पिंब्मुँ धै खोंयोंन् बिलै ङ क्हिए मिं थेब् लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","याहवेह थेब मुँ, धै थेब् लसि म्हाँदिल् त्हुब मुँ, खी कति थेब मुँ बिसि खाबज्यै क्होल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","क्हिजी लबै केए बयन पुस्ता घ्रिइ अर्को पुस्ताने लब्मुँ, धै क्हिजी लबै शक्तिए केमैं चमैंइ बयन लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","क्हि बेल्‍ले छ्याँब नेरो म्हारब मुँ बिसि चमैंइ बयन लब्मुँ; क्हिजी औदिबै केमैं खैले लगे बिसि क्हिजी लबै केमैंए बारेर ङ मैंब्मुँ, ");
INSERT INTO gvr_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","क्हिजी लबै औदिबै थे-थेबै केमैंए बारेर म्हिमैंइ बयन लब्मुँ, धै क्हि कति थेब मुँ बिसि ङज्यै या बिप्रब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","क्हिजी थे-थेबै छ्याँबै के लब्मुँ बिसि चमैंइ बयन लब्मुँ धै क्हिजी लबै ठिक केमैंए बारेर क्वे प्रिंदै जयजय लब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","याहवेहजी दयाम्हाँया लमुँ धै ल्हयो खमुँ, खी युनन् ह्रिस आख, धै खोंयोंइ आनुबै म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","याहवेहजी ताँनए फिर छ्याँब लम्, ह्रोंसजी बनेबै तोन्दोंरि सैमैंए फिर ल्हयो खमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","ओ याहवेह, क्हिजी बनेबै तोन्दोंरि सैमैंइ क्हिलाइन धन्यबाद पिंब्मुँ, धै क्हिए म्हिमैंइ क्हिए मिं क्वेब्मुँ! ");
INSERT INTO gvr_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","ताँन् म्हिमैंइ क्हिजी लबै शक्तिए केमैं था सेरिगे, धै क्हिए ग्याल्सर्बै छ्याँ-छ्याँबै म्हारबै सैमैं म्रोंरिगे बिसि ");
INSERT INTO gvr_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","क्हिए म्हिमैंइ क्हिए ग्याल्सर्बै छ्याँ-छ्याँबै ताँमैंए बयन लब्मुँ, धै क्हिजी लबै शक्तिए केमैं बिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","क्हिए ग्याल्स खोंयोंन् बिलै तरिबै ग्याल्स ग, पुस्ता-पुस्ता समा क्हिजी क्ल्हे लरिब्मुँ। याहवेहजी फैबै ताँन् बाछामैं भर लल् खाँब मुँ, ह्रोंसइ बनेबै तोन्दोंरि सैलाइ खीजी म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","क्हुरियाब्मैं ताँनलाइ याहवेहजी ल्होमिंम्; आगुइ प्लेथेंब्मैं ताँनलाइ खीजी रेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","सो प्ह्‍याबै तोन्दोंरि सैमैंइ क्हि ङाँइन ङ्ह्‍योम्, धै चमैं फो ख्रेंमा क्हिजी चबै सै पिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","क्हिजी यो प्ल्हसि तोन्दोंरि सै पिंमुँ; धै ताँन् सो प्ह्‍याबै सैमैंए सैंर मैंब योमिंब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","याहवेहजी लबै तोन्दोंरि केमैं ठिक मुँ, धै ह्रोंसइ बनेबै तोन्दोंरि सैमैंलाइ म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","याहवेहए मिं किंब्मैं ताँनए चेंदों खी तरिम्, क्ह्रोसेंन्बै छ्याँबै सैंइ खीए मिं किंब्मैं ताँनए चेंदों खी तरिम्। ");
INSERT INTO gvr_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","खीने बालु ङ्हिंब्मैं ताँनए सैंर मैंब खीजी पूरा लमिंम्; चमैंइ हुइब खीजी थेमुँ धै चमैंलाइ जोगेमिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","खीए फिर म्हाँया लब्मैं ताँनलाइ याहवेहजी रक्षा लमिंम्, दिलेया दुष्‍टमैं बिस्याँ खीजी नास लवाब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","ङए सुँइ याहवेहए मिं थेब् लसि पोंब्मुँ। सो प्ह्‍याबै तोन्दोंरि सैमैंइ खोंयोंन् बिलै खीए पबित्र मिं थेब् लरिगे। ");
INSERT INTO gvr_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","हल्‍लेलूयाह! ओ ङए सो, याहवेहए मिं थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","ङए छ्ह तिगोंन् ङ याहवेहए मिं थेब् लब्मुँ, छ्ह तिगोंन् ङ परमेश्‍वरए क्वेमैं प्रिंरिब्मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","क्रथे मिंथेमैं नेरो सिल् त्हुबै म्हिमैंए फिर भर आथेंन्, तलेबिस्याँ चमैंइ जोगेमिंल् आखाँ। ");
INSERT INTO gvr_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","चमैंइ सो पिमा चमैं सर कोंयाम्, च त्हिंइर्न चमैंए चाँजोमैं या नुयाम्। ");
INSERT INTO gvr_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","याकूबए परमेश्‍वरजी ल्होमिंबै म्हिइ आशिक योंम्, ह्रोंसए याहवेह परमेश्‍वरने चइ आशा लम्। ");
INSERT INTO gvr_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","स्वर्ग, पृथ्बी, मा ङ्युँइ, नेरो चर मुँबै तोंन्दोरि सैमैं खीजी बनेइ, खी खोंयोंन् बिलै भर लल् खाँब मुँ; ");
INSERT INTO gvr_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","आगुइ क्र ओलै आपिंब्मैंलाइ याहवेहजी ठिक निसाफ लमुँ, खीजी फो ख्रेंब्मैंलाइ चल् पिंमुँ। याहवेहजी कैदिमैं बैरु तेमिंम्, ");
INSERT INTO gvr_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","याहवेहजी मि आम्रोंब्मैंए मि थोंमिंम्। ल्हिबै ति नोसि ओलै आखाँब्मैंलाइ याहवेहजी रेमिंम्, याहवेहजी ठिक के लब्मैं म्हाँया लम्। ");
INSERT INTO gvr_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","अरू ह्‍युलउँइँले खबै तोइ आरेब्मैं याहवेहजी रक्षा लम्, आबा-आमा आरेब्मैं नेरो म्हरेस्योमैं खीजी ल्होमिंम्, दिलेया दुष्‍ट म्हिमैंए चाँजो खीजी फुवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","याहवेहजी खोंयोंन् बिलै ग्याल्स लब्मुँ, ओ सियोन, क्हिए परमेश्‍वरजी पुस्ता-पुस्ता समा ग्याल्स लब्मुँ। हल्‍लेलूयाह! याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","हल्‍लेलूयाह! ङ्योए परमेश्‍वरए क्वे प्रिंब बेल्‍ले छ्याँब ताँ गो, खीए मिं थेब् लब कति सैं तोंबै ताँ मुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","याहवेहजी यरूशलेम धबै बनेमिंमुँ, इस्राएलउँइँले ल्हामिंब्मैंलाइ खीजी खागु लमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","खीजी चोयाबै सैं सल् लमिंमुँ धै चमैंए सैं क्होल् लमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","मुसारमैं च्हगन् मुँ बिसि खीजी सेइमुँ; धै च ताँन् मुसारमैंए मिं थेंमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","ङ्योए प्रभु बेल्‍ले थेब नेरो भोंब मुँ, खीए बुद्धि च्हैंसे च्हैंल् आखाँब मुँ; ");
INSERT INTO gvr_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","याहवेहजी ङ्हाँदुमैं नेरो सैं च्योंब तब्मैंलाइ भों पिंमुँ, दिलेया दुष्‍टमैंलाइ बिस्याँ खीजी सर प्योवाम्। ");
INSERT INTO gvr_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","धन्यबाद पिंदै याहवेहए क्वे प्रिंन्; बीणा ह्रादै ङ्योए परमेश्‍वरए क्वे प्रिंन्। ");
INSERT INTO gvr_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","खीजी मु न्हाँम्स्योइ हुमिंमुँ; धै पृथ्बीर नाँ युल् पिंमुँ; खीजी कोंजरे छि म्‍लोमिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","खेदोमैं नेरो कगए प्हसेमैं ङ्‍हेमा खीजी चल् पिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","घोडाए भोंने खी सैं आतों, म्हिए प्हलेने या खी सैं आतों, ");
INSERT INTO gvr_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","दिलेया याहवेहलाइ मान लब्मैं नेरो खीए खोंयोंइ आनुबै म्हाँयार भर लब्मैंने खी सैं तोंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","ओ यरूशलेम, याहवेहए मिं क्वेद्! ओ सियोन, ह्रोंसए परमेश्‍वर थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","तलेबिस्याँ क्हिए मुल म्रामैंए जीगलमैं खीजी भोंब लमिंइमुँ, धै क्हिए प्हसेमैंए फिर खीजी आशिक पिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","क्हिए साँदमैंर खीजी प्होंगि तल् आपिं; धै ताँन् भन्दा छ्याँबै गउँ क्हिलाइ पिंमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","खीजी पृथ्बीर छ लद् छु लद् बिमुँ, धै खीए ताँ पृथ्बीइ युनन् ङिंम्। ");
INSERT INTO gvr_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","क्युए पै धोंलेन् खीजी क्लिं कुल्मिंम्, मेब्रो धोंलेन् खीजी प्हमइ प्रामुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","खीजी तिस्यु कुल्मिंमुँ, खीजी कुल्मिंबै ङ्युँबै खैंर खाब् राल् खाँमुँ? ");
INSERT INTO gvr_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","खीजी ताँ पोंसि चमैं ताँन् बिलिदिवाम्। खीजी खैं कुल्मिंमा क्युमैं बगेबर होंम्। ");
INSERT INTO gvr_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","खीजी ह्रोंसए ताँ याकूबने धै ह्रोंसए ठिममैं नेरो निसाफमैं इस्राएलने उँइँमिंइमुँ। ");
INSERT INTO gvr_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","अरू ह्रेमैंए ल्हागिर खीजी छाबै केमैं आलइमुँ; खीए ठिममैं चमैंइ आसेइमुँ। हल्‍लेलूयाह! याहवेहए मिं क्वेद्! ");
INSERT INTO gvr_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","हल्‍लेलूयाह! स्वर्गउँइँले याहवेहए मिं क्वेद्; मुउँइँले खीलाइन थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","ओ ताँन् स्वर्गदूतमैं, खीलाइन थेब् लद्; ओ खीए स्वर्गर्बै सिपाइमैं, खीलाइन थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","ओ त्हिंयाँ नेरो लयाँ, खीलाइन थेब् लद्, ओ मुर्बै चारबै मुसारमैं, खीलाइन थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","ओ नुबै मु नेरो मुए फिर्बै क्युमैं, खीलाइन थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","चमैंइ याहवेहए मिंन् थेब् लरिगे! तलेबिस्याँ खीए सुँइ पोंमा च सैमैं तयाइ। ");
INSERT INTO gvr_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","चमैं खोंयोंन् बिलै तरिगे बिसि खीजी लमिंइ; झाइले खोंयोंइ आम्हबै ठिम चमैंए ल्हागिरि खीजी पिंथेंइ। ");
INSERT INTO gvr_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","ह्‍युलउँइँले याहवेहए मिं क्वेद्! ओ थेबै मा ङ्युँइ न्होंर टिबै सो प्ह्‍याबै सैमैं, नेरो ताँन् गैरु मा ङ्युँइ, ");
INSERT INTO gvr_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","धै काम्‍लि-तिम्‍लि, तिस्यु, क्लिं नेरो न्हाँम्स्यो, धै खीजी बिबै ताँ ङिंबै नाँ-खैंज्यै या खीलाइन थेब् लद्! ");
INSERT INTO gvr_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","क्लिंक्हाँ नेरो ताँन् कोंमैं, रो-रोबै सिंधुँमैं नेरो ताँन् थे-